/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000181b0ULL, 0x0000000000017e30ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x346a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4532336a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL,
0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL, 0x45316a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x324545386a4c4532ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x0000000000000067ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x656b240061686d5fULL,
0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x65642e0066754265ULL, 0x6d6172665f677562ULL,
0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL, 0x665f67756265642eULL,
0x766e2e00656d6172ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x00000061686d5f6cULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000001beULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000b000100000204ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b00010000024bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000291ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000002dfULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000032dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000b00010000037bULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000003c9ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a002200000424ULL, 0x00000000000167f0ULL, 0x0000000000000210ULL,
0x000400030000049aULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL,
0x0000000000000000ULL, 0x0000000000016a00ULL, 0x000d0003000004caULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000167f000000000ULL, 0x0001080400000000ULL,
0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL,
0x000167f000000000ULL, 0x0000021000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000001500082f04ULL, 0x00082304000000bbULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001500082304ULL,
0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL, 0x0004370400000000ULL,
0x000c17040000007bULL, 0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL,
0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL,
0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0xffffffff00dc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000002d000dc2804ULL, 0x00000960000003c0ULL, 0x00002c4000002bd0ULL,
0x00002e5000002d20ULL, 0x000030c000002f80ULL, 0x0000364000003630ULL, 0x0000366000003650ULL,
0x0000551000005480ULL, 0x00005720000055f0ULL, 0x0000599000005850ULL, 0x00005e5000005e40ULL,
0x00005e7000005e60ULL, 0x00007c1000007b80ULL, 0x00007e2000007cf0ULL, 0x0000809000007f50ULL,
0x0000855000008540ULL, 0x0000857000008560ULL, 0x0000a3600000a2f0ULL, 0x0000a5800000a450ULL,
0x0000a7f00000a6b0ULL, 0x0000ad200000ad10ULL, 0x0000ad400000ad30ULL, 0x0000bf900000bf80ULL,
0x0000bfb00000bfa0ULL, 0x000150c000015010ULL, 0x000154c0000153b0ULL, 0x000159a0000158a0ULL,
0x00015cd000015c50ULL, 0x0000047004303904ULL, 0x0001a600000000ffULL, 0x0000055000040100ULL,
0x0001a60800000000ULL, 0x00000660003f0100ULL, 0x0001a68800000000ULL, 0x00000790003f0100ULL,
0x0001a6a800000005ULL, 0x000008a0003f0100ULL, 0x0001a6c800000004ULL, 0x00001000003f0100ULL,
0x0001a600000000ffULL, 0x0000118000090107ULL, 0x0001a68800000000ULL, 0x00001be0003f0101ULL,
0x00000000000000ffULL, 0x00001c4000040107ULL, 0x00000000000000ffULL, 0x00001cc000040101ULL,
0x0000002000000002ULL, 0x00001e10003f0101ULL, 0x0001a6c800000036ULL, 0x00001fa000090109ULL,
0x0001a6c800000038ULL, 0x00002870003f0109ULL, 0x0001a6b000000038ULL, 0x0000294000090107ULL,
0x0001a6b00000003aULL, 0x00002950003f0101ULL, 0x0001a60800000080ULL, 0x00002970003f0101ULL,
0x0001a60800000080ULL, 0x00002ae0003f0109ULL, 0x0001a60800000080ULL, 0x00003250003f0109ULL,
0x0001a6a80000003aULL, 0x000033c0003f0109ULL, 0x0001a6a80000003aULL, 0x000047a0003f0109ULL,
0x0001a6c800000034ULL, 0x000047c0003f0101ULL, 0x0001a68800000081ULL, 0x0000482000090101ULL,
0x0000000000000006ULL, 0x00004990003f0109ULL, 0x0000000000000006ULL, 0x00005190003f0109ULL,
0x0001a6a80000007aULL, 0x0000523000090107ULL, 0x0001a6a800000084ULL, 0x00005240003f0101ULL,
0x0001a62800000080ULL, 0x00005260003f0101ULL, 0x0001a62800000080ULL, 0x000053d0003f0109ULL,
0x0001a62800000080ULL, 0x00005b60003f0109ULL, 0x0001a6b00000002fULL, 0x00005ce000090109ULL,
0x0001a6b000000037ULL, 0x00006e80003f0109ULL, 0x0001a6c800000034ULL, 0x00006ea0003f0101ULL,
0x0001a69000000036ULL, 0x00006f1000090101ULL, 0x0000000000000006ULL, 0x00007080003f0109ULL,
0x0000000000000006ULL, 0x000078b0003f0109ULL, 0x0001a6b00000002eULL, 0x0000793000090107ULL,
0x0001a6b000000086ULL, 0x00007940003f0101ULL, 0x0001a64800000080ULL, 0x00007960003f0101ULL,
0x0001a64800000080ULL, 0x00007ad0003f0109ULL, 0x0001a64800000080ULL, 0x00008260003f0109ULL,
0x0001a6a80000002fULL, 0x000083e000090109ULL, 0x0001a6a800000037ULL, 0x00009580003f0109ULL,
0x0001a6c80000004dULL, 0x000095a0003f0101ULL, 0x0001a69800000036ULL, 0x0000961000090101ULL,
0x0001a6c80000004dULL, 0x000097a0003f0109ULL, 0x0001a6c80000004dULL, 0x0000a060003f0109ULL,
0x0001a6a800000080ULL, 0x0000a0b000090107ULL, 0x0001a6a80000002cULL, 0x0000a0c0003f0101ULL,
0x0001a66800000009ULL, 0x0000a0f0003f0101ULL, 0x0001a66800000009ULL, 0x0000a260003f0109ULL,
0x0001a66800000009ULL, 0x0000a9c0003f0109ULL, 0x0001a6b00000002fULL, 0x0000ab4000090109ULL,
0x0001a6b000000037ULL, 0x0000bd50003f0109ULL, 0x0000000000000006ULL, 0x0000bdc0003f0101ULL,
0x0001a6a000000006ULL, 0x0000daf0003f0101ULL, 0x0001a600000000ffULL, 0x0000f3f000090101ULL,
0x0001a600000000ffULL, 0x0000f56000090109ULL, 0x0001a600000000ffULL, 0x0000f8c000090109ULL,
0x0001a600000000ffULL, 0x0000f8e000090101ULL, 0x0001a600000000ffULL, 0x0000fa5000090109ULL,
0x0001a600000000ffULL, 0x000128f000090109ULL, 0x0001a68800000006ULL, 0x00012cc0003f0101ULL,
0x0001a68800000006ULL, 0x00012e30003f0109ULL, 0x0001a68800000006ULL, 0x00016790003f0109ULL,
0x0001a60800000077ULL, 0x000167a0003f0101ULL, 0x0001a61000000077ULL, 0x000167b0003f0101ULL,
0x0001a61800000077ULL, 0x000167c0003f0101ULL, 0x0001a62000000077ULL, 0x00053803003f0101ULL,
0x0000ceb000301c04ULL, 0x0000d0c00000cf10ULL, 0x0000d3800000d220ULL, 0x0000d6400000d4e0ULL,
0x0000d9300000d7a0ULL, 0x0000fa800000da30ULL, 0x000c0504000167e0ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0060190300000000ULL, 0x0000001600080a04ULL, 0x0000000000600210ULL,
0x00000000000000bcULL, 0x0000001500000002ULL, 0x00000000000167f0ULL, 0x0000000000000044ULL,
0x0000001500000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001500000002ULL,
0x0000000000000000ULL, 0x000000000001a700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff027b82ULL, 0x000ea20000000a00ULL,
0x0000000000097919ULL, 0x000ee20000002300ULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000000000a7919ULL, 0x000eea0000002200ULL, 0x00000400ff067b82ULL, 0x000f220000000800ULL,
0x0000000000637919ULL, 0x000f620000002100ULL, 0x0000010000047ab9ULL, 0x000fcc0000000800ULL,
0x00008600ff137b82ULL, 0x000ee20000000800ULL, 0x0000000300007306ULL, 0x004ea20000209000ULL,
0x000000ff0300720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x004ea40000001000ULL,
0x0ffffffe00047836ULL, 0x004fcc0000000000ULL, 0x0000000400057305ULL, 0x0004e4000021f000ULL,
0x000000ffff047224ULL, 0x004fe400078e00ffULL, 0x000000ffff087224ULL, 0x00afc800078e0a05ULL,
0x0000000308077224ULL, 0x000fe400078e02ffULL, 0x0000000000087919ULL, 0x000e640000002600ULL,
0x0000000705057227ULL, 0x000fcc00078e0004ULL, 0x0000000605777227ULL, 0x010fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a77ULL, 0x0000000503007224ULL, 0x000fca00078e0206ULL,
0x000000030000720cULL, 0x000fda0003f06070ULL, 0x0000000100000824ULL, 0x000fe400078e0a03ULL,
0x0000000177770836ULL, 0x000fc60000000000ULL, 0x000000030000720cULL, 0x000fda0003f26070ULL,
0x0000000177771836ULL, 0x000fe20000000000ULL, 0x00000003ff77a212ULL, 0x000fc800078e33ffULL,
0x0000007700007306ULL, 0x000ea20000209000ULL, 0x000000ff7700720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x004ea40000001000ULL, 0x0ffffffe00047836ULL, 0x004fe40000000000ULL,
0x0000000409007c24ULL, 0x000fe2000f8e020aULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000400057305ULL, 0x0004e4000021f000ULL, 0x000000ffff047224ULL, 0x004fe400078e00ffULL,
0x0000000577067224ULL, 0x008fc800078e02ffULL, 0x000000ffff077224ULL, 0x000fc800078e0a06ULL,
0x0000000705057227ULL, 0x000fe400078e0004ULL, 0x0000000000077919ULL, 0x000ea40000002700ULL,
0x0000000400047c24ULL, 0x120fe2000f8e0263ULL, 0x00000005ff637819ULL, 0x000fe20000011663ULL,
0x0000000805587227ULL, 0x002fc600078e00ffULL, 0x0000007f0400780cULL, 0x040fe20003f64070ULL,
0x000000ffff057224ULL, 0x000fe200078e0a58ULL, 0x00001fff63637589ULL, 0x000e6200000e0000ULL,
0x000000030400780cULL, 0x000fe40003f84070ULL, 0x0000000577007224ULL, 0x000fca00078e0208ULL,
0x000000770000720cULL, 0x000fc60003f06070ULL, 0x000000000006b919ULL, 0x000ee20000008800ULL,
0x000004000005b802ULL, 0x000fd20000000f00ULL, 0x0000000100000824ULL, 0x000fe400078e0a77ULL,
0x0000000158580836ULL, 0x000fe20000000000ULL, 0x000000ff0400720cULL, 0x000fe40003f05270ULL,
0x000000770000720cULL, 0x000fda0003f26070ULL, 0x0000000158581836ULL, 0x000fe20000000000ULL,
0x00000077ff58a212ULL, 0x000fe400078e33ffULL, 0x0000000f0400780cULL, 0x000fe40003f24070ULL,
0x000006540605b816ULL, 0x008fe20000000005ULL, 0x000000ffff007224ULL, 0x000fe200078e0a58ULL,
0x00001fff09067589ULL, 0x00026200000e0000ULL, 0x000000010400780cULL, 0x000fe40003f44070ULL,
0x0000000077777224ULL, 0x000fc400078e0208ULL, 0xff317217ff08b424ULL, 0x000fe400078e00ffULL,
0x000000040405b824ULL, 0x000fe200078e0205ULL, 0x0000000000240947ULL, 0x006fec0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x004fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000eb40000000000ULL, 0x01a60006043f75b2ULL, 0x0004a40008000100ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404007c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000000612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x01a60804063f75b2ULL, 0x0004b00008000100ULL, 0xfffffffd00e81947ULL, 0x004fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404007c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000000612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x01a68804063f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x004fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01a400080500b388ULL, 0x0005e20000000800ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x0000002077007824ULL, 0x000fc600078e00ffULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ee20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x008fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000404057c11ULL, 0x004fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000050612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ea40000000000ULL,
0x01a6a804063f75b2ULL, 0x0004b00008000100ULL, 0xfffffffd00e81947ULL, 0x004fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x008fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x004fca0000000000ULL, 0x00000000040612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x01a6c804063f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x004fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe200078e0a00ULL, 0x0000001302057219ULL, 0x084fe200000006ffULL,
0x0000000207027224ULL, 0x000fe200078e02ffULL, 0x00000013030b7219ULL, 0x080fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000500720cULL, 0x000fe20003f06070ULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x0000002005757446ULL, 0x000fe20003800004ULL,
0x0000000406047824ULL, 0x002fe200078e0263ULL, 0x0000001358767219ULL, 0x000fc400000006ffULL,
0x000000ff75757207ULL, 0x000fe20000000000ULL, 0x0000000404047824ULL, 0x000fe400078e00ffULL,
0x0000000b02027224ULL, 0x000fe200078e0276ULL, 0x000000207500780cULL, 0x000fda0003f05270ULL,
0x0000000000c88947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x000e620000000000ULL,
0xffffffffff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000475057248ULL, 0x000fe20007fe0000ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000107919ULL, 0x000ea20000008800ULL,
0x00000400000d7802ULL, 0x000fe40000000f00ULL, 0x000000130c097219ULL, 0x000fe200000006ffULL,
0x0000000105057824ULL, 0x000fe200078e0a04ULL, 0x00000004ff087819ULL, 0x002fe4000001160aULL,
0x0000065410127816ULL, 0x004fc6000000000dULL, 0x00000002080e7836ULL, 0x000fe20000000000ULL,
0x000000050800720cULL, 0x080fe20003f06070ULL, 0x00000001040f7824ULL, 0x000fe200078e0208ULL,
0x00000000120972caULL, 0x000fe200000e0000ULL, 0x0000000104117824ULL, 0x000fe200078e020eULL,
0x000000050e00720cULL, 0x000fe20003f26070ULL, 0x00000001000c7824ULL, 0x040fe400078e020fULL,
0x0000000100047824ULL, 0x000fe400078e0211ULL, 0x00000001110e7824ULL, 0x040fe200078e020aULL,
0x000000090c0d7212ULL, 0x080fe200078e30ffULL, 0x0000001011117824ULL, 0x000fe200078e00ffULL,
0x0000000904097212ULL, 0x000fc400078e30ffULL, 0x00000013ff0c7219ULL, 0x080fe2000001160cULL,
0x00000001020d7824ULL, 0x040fe200078e020dULL, 0x00000013ff107219ULL, 0x000fe20000011604ULL,
0x0000000102097824ULL, 0x000fe200078e0209ULL, 0xfffffff0110e7812ULL, 0x000fe200078ee20eULL,
0x0000000b0c087224ULL, 0x080fe400078e020dULL, 0x000000100a047824ULL, 0x000fe400078e00ffULL,
0x0000000b100c7224ULL, 0x000fe400078e0209ULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x000000f004057812ULL, 0x000fc600078ec0ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000508087212ULL, 0x000fc600078efcffULL, 0x000000010f027824ULL, 0x040fe200078e020aULL,
0x000000050c057212ULL, 0x000fe200078efcffULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0x0000000408087c10ULL, 0x000fe4000ff5e0ffULL, 0x00000004050c7c10ULL, 0x000fe4000ff7e0ffULL,
0xfffffff00f027812ULL, 0x000fe400078ee202ULL, 0x0000000509097c10ULL, 0x000fe400097fe4ffULL,
0x0000000902057c11ULL, 0x000fc4000f8e20ffULL, 0x000000050d0d7c10ULL, 0x000fe40009ffe4ffULL,
0x000000090e0f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008057faeULL, 0x0003e8000c101c46ULL, 0x000000000c0f7faeULL, 0x0003e2000c901c46ULL,
0x0000000000ac7947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x000e620000000000ULL,
0x00000400000c7802ULL, 0x000fe20000000f00ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000117919ULL, 0x000ea20000008800ULL, 0x000000040a057211ULL, 0x002fe200078fe0ffULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x00000654110c7816ULL, 0x004fc6000000000cULL,
0x00000002050f7836ULL, 0x000fe20000000000ULL, 0x00000013040d7219ULL, 0x000fe200000006ffULL,
0x0000000100047824ULL, 0x000fe200078e0205ULL, 0x000000000c0972caULL, 0x000fe200000e0000ULL,
0x0000000100087824ULL, 0x000fe400078e020fULL, 0x000000100f0e7824ULL, 0x000fe200078e00ffULL,
0x0000000d04097212ULL, 0x080fe400078e30ffULL, 0x0000000d080d7212ULL, 0x000fe400078e30ffULL,
0x00000013ff047219ULL, 0x080fe20000011604ULL, 0x0000000102097824ULL, 0x040fe200078e0209ULL,
0x00000013ff087219ULL, 0x000fe20000011608ULL, 0x00000001020d7824ULL, 0x000fc400078e020dULL,
0x0000000b04097224ULL, 0x080fe400078e0209ULL, 0x000000100a047824ULL, 0x000fe400078e00ffULL,
0x0000000b080d7224ULL, 0x000fe400078e020dULL, 0x0000010009087825ULL, 0x000fe200078e00ffULL,
0x000000f004117812ULL, 0x000fc600078ec0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e00ffULL,
0x0000001108087212ULL, 0x000fc600078efcffULL, 0x0000000105027824ULL, 0x140fe200078e020aULL,
0x000000110c0c7212ULL, 0x000fe200078efcffULL, 0x0000001005137824ULL, 0x000fe200078e00ffULL,
0x0000000408087c10ULL, 0x000fe2000ff1e0ffULL, 0x000000010f057824ULL, 0x000fe200078e020aULL,
0x000000040c0c7c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff013027812ULL, 0x000fe400078ee202ULL,
0xfffffff00e0e7812ULL, 0x000fe400078ee205ULL, 0x0000000509097c10ULL, 0x000fc400087fe4ffULL,
0x0000000902057c11ULL, 0x000fe4000f8e20ffULL, 0x000000050d0d7c10ULL, 0x000fe40008ffe4ffULL,
0x000000090e0f7c11ULL, 0x000fe2000f8e20ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008057faeULL, 0x0003e8000b901c46ULL, 0x000000000c0f7faeULL, 0x0003e4000b901c46ULL,
0x0001a60009047890ULL, 0x000fe2000fffe03fULL, 0x00009200ff087b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000407087825ULL, 0x002fe200078e0008ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0000000608747981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x0000003f74627836ULL, 0x004fe40000000000ULL,
0x000000ff74057836ULL, 0x000fc60000000000ULL, 0x00000006ff627819ULL, 0x000fe40000011662ULL,
0x00000008ff617819ULL, 0x000fca0000011605ULL, 0x000000c800608947ULL, 0x000fea0003800000ULL,
0x00000002ff5a7819ULL, 0x000fe20000011663ULL, 0xffffffffff027424ULL, 0x000fe400078e00ffULL,
0x00000004ff0f7424ULL, 0x000fe200078e00ffULL, 0x03ffffff5a597812ULL, 0x000fc800078ec0ffULL,
0x000000625900720cULL, 0x000fda0003f06070ULL, 0x00009400ff0d8b82ULL, 0x000e620000000800ULL,
0x0000000207008824ULL, 0x000fce00078e00ffULL, 0x00009000ff088b82ULL, 0x000ea20000000a00ULL,
0x0000000d00008224ULL, 0x002fc800078e020dULL, 0x00000001590d8824ULL, 0x000fe200078e0200ULL,
0x0000000963007c11ULL, 0x000fc6000f8e18ffULL, 0x000000040d088825ULL, 0x004fe200078e0008ULL,
0x01a6880f00ff79a7ULL, 0x0003e8000850003fULL, 0x0000000608028981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0500780cULL, 0x000fe20003f04070ULL, 0x0000004058587824ULL, 0x000fe200078e00ffULL,
0x00000001ff607819ULL, 0x000fe40000011663ULL, 0x0000000163057812ULL, 0x000fc600078ec0ffULL,
0x00000020605b7824ULL, 0x000fe200078e00ffULL, 0x00008e00ff0c7b82ULL, 0x000ee80000000a00ULL,
0x0000002058007812ULL, 0x002fe200078ef85bULL, 0x0000000302027224ULL, 0x004fc800078e02ffULL,
0x0000004002037824ULL, 0x000fc800078e00ffULL, 0x0000008003027825ULL, 0x008fe200078e000cULL,
0x0000000000fc0947ULL, 0x000fec0003800000ULL, 0x0000005b74067248ULL, 0x000fe20007fe0000ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x00000003ff087819ULL, 0x000fc6000001160aULL,
0x0000000106067824ULL, 0x000fe400078e0a5bULL, 0x0000000105097824ULL, 0x000fe400078e0208ULL,
0x00000004080d7836ULL, 0x000fe20000000000ULL, 0x0000000506067248ULL, 0x000fe20007fe0000ULL,
0x00000001090c7824ULL, 0x040fe400078e020aULL, 0x00000008090f7824ULL, 0x000fe400078e00ffULL,
0x0000000106067824ULL, 0x000fc400078e0a05ULL, 0x0000000c080e7836ULL, 0x000fe20000000000ULL,
0xfffffff80f127812ULL, 0x000fe200078ee20cULL, 0x00000008080c7836ULL, 0x000fe20000000000ULL,
0x000000060d00720cULL, 0x080fe20003f46070ULL, 0x00000001050d7824ULL, 0x000fe200078e020dULL,
0x000000060800720cULL, 0x080fe20003f66070ULL, 0x0000000100097824ULL, 0x000fe200078e0209ULL,
0x000000060c00720cULL, 0x080fe20003f26070ULL, 0x000000010d087824ULL, 0x040fe200078e020aULL,
0x000000060e00720cULL, 0x000fe20003f06070ULL, 0x000000080d137824ULL, 0x000fc400078e00ffULL,
0x0000000105117824ULL, 0x040fe400078e020eULL, 0x00000001050f7824ULL, 0x000fe200078e020cULL,
0xfffffff813067812ULL, 0x000fe200078ee208ULL, 0x0000008009087825ULL, 0x000fc800078e00ffULL,
0x00000001000e7824ULL, 0x040fe200078e0211ULL, 0x0000007008137812ULL, 0x000fe200078ef804ULL,
0x0000000111087824ULL, 0x040fe400078e020aULL, 0x0000000811117824ULL, 0x000fe200078e00ffULL,
0x0000001302107210ULL, 0x000fe20007f9e0ffULL, 0x00000001000d7824ULL, 0x040fe400078e020dULL,
0x00000001000c7824ULL, 0x000fe200078e020fULL, 0xfffffff811167812ULL, 0x000fe200078ee208ULL,
0x0000000103117824ULL, 0x000fe200020e0609ULL, 0x0000000960007c11ULL, 0x000fe2000f8e68ffULL,
0x000000800d087825ULL, 0x000fc800078e00ffULL, 0x000000010f057824ULL, 0x040fe200078e020aULL,
0x00000070081d7812ULL, 0x000fe200078ef804ULL, 0x000000080f147824ULL, 0x000fe400078e00ffULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee205ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c1b7812ULL, 0x000fc600078ef804ULL,
0x0001600000057836ULL, 0x000fe20000000000ULL, 0x000000700e197812ULL, 0x000fe400078ef804ULL,
0x0000001d02047210ULL, 0x000fe20007f9e0ffULL, 0x0000001012137824ULL, 0x100fe200078e0205ULL,
0x0000001b02087210ULL, 0x000fe20007fbe0ffULL, 0x0000001006157824ULL, 0x100fe200078e0205ULL,
0x0000001902027210ULL, 0x000fe20007fde0ffULL, 0x0000001014177824ULL, 0x100fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000d901c46ULL,
0x0000001016197824ULL, 0x000fc400078e0205ULL, 0x0000000103057824ULL, 0x040fe400020e0609ULL,
0x0000000103097824ULL, 0x040fe400028e060dULL, 0x0000000103037824ULL, 0x000fe200030e060fULL,
0x0000000004157faeULL, 0x0003e8000d101c46ULL, 0x0000000008177faeULL, 0x0003e8000c901c46ULL,
0x0000000002197faeULL, 0x0003e2000c101c46ULL, 0x0000000000c87947ULL, 0x000fea0003800000ULL,
0x0000001005057824ULL, 0x000fca00078e00ffULL, 0x000000050a057211ULL, 0x000fca00078fe8ffULL,
0x00000004050d7836ULL, 0x000fe40000000000ULL, 0x0000000100087824ULL, 0x000fe400078e0205ULL,
0x000000010d097824ULL, 0x140fe400078e020aULL, 0x000000080d127824ULL, 0x000fe400078e00ffULL,
0x0000000105067824ULL, 0x040fe400078e020aULL, 0x00000008050f7824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee209ULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff80f067812ULL, 0x000fe200078ee206ULL, 0x00000008050f7836ULL, 0x000fe20000000000ULL,
0x0000007008117812ULL, 0x000fe200078ef804ULL, 0x0000000c05057836ULL, 0x000fe40000000000ULL,
0x00000001000d7824ULL, 0x040fe200078e020dULL, 0x0000001102107210ULL, 0x000fe20007f1e0ffULL,
0x00000001000e7824ULL, 0x040fe400078e0205ULL, 0x0000000105087824ULL, 0x000fe400078e020aULL,
0x00000001000c7824ULL, 0x000fc400078e020fULL, 0x0000000805057824ULL, 0x000fe400078e00ffULL,
0x000000010f007824ULL, 0x040fe400078e020aULL, 0x000000080f137824ULL, 0x000fe200078e00ffULL,
0x00000009600f7c11ULL, 0x000fe2000f8e68ffULL, 0x0000000103117824ULL, 0x000fe200000e0609ULL,
0xfffffff805057812ULL, 0x000fe200078ee208ULL, 0x000000800d087825ULL, 0x000fe200078e00ffULL,
0xfffffff813007812ULL, 0x000fc600078ee200ULL, 0x000160000f1f7836ULL, 0x000fe20000000000ULL,
0x00000070081d7812ULL, 0x000fe200078ef804ULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c1b7812ULL, 0x000fc600078ef804ULL,
0x0000001006137824ULL, 0x100fe200078e021fULL, 0x000000700e197812ULL, 0x000fe200078ef804ULL,
0x0000001012157824ULL, 0x100fe200078e021fULL, 0x0000001d02047210ULL, 0x000fe20007f1e0ffULL,
0x0000001000177824ULL, 0x100fe200078e021fULL, 0x0000001b02087210ULL, 0x000fe20007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000b901c46ULL,
0x0000001902027210ULL, 0x000fe20007f5e0ffULL, 0x0000001005197824ULL, 0x000fe400078e021fULL,
0x0000000103057824ULL, 0x000fc400000e0609ULL, 0x0000000103097824ULL, 0x040fe400008e060dULL,
0x0000000103037824ULL, 0x000fe200010e060fULL, 0x0000000004157faeULL, 0x0003e8000b901c46ULL,
0x0000000008177faeULL, 0x0003e8000b901c46ULL, 0x0000000002197faeULL, 0x0003e4000b901c46ULL,
0x0000000159597836ULL, 0x000fe40000000000ULL, 0xffffffffff817424ULL, 0x000fc600078e00ffULL,
0x000000625900720cULL, 0x000fda0003f06070ULL, 0x00009400ff058b82ULL, 0x002e620000000800ULL,
0x0000000207008824ULL, 0x000fce00078e00ffULL, 0x00009000ff028b82ULL, 0x000ea20000000a00ULL,
0x0000000500008224ULL, 0x002fc800078e0205ULL, 0x0000000100058824ULL, 0x000fc800078e0259ULL,
0x0000000405028825ULL, 0x004fc800078e0002ULL, 0x00000009ff057e24ULL, 0x000fe2000f8e00ffULL,
0x00000000600472caULL, 0x000fe200000e0000ULL, 0x0000000602818981ULL, 0x000322000c1e1900ULL,
0x000000ff6100720cULL, 0x000fe20003f05270ULL, 0x0001a6a805057836ULL, 0x000fe20000000000ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000001ff097424ULL, 0x000fe200078e00ffULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff827224ULL, 0x000fe200078e00ffULL,
0x00000000050572caULL, 0x000fe400000e0000ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000504047291ULL, 0x000fe2000f8e203fULL,
0x00000000000e7805ULL, 0x000fc4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x0000000000527805ULL, 0x000fc4000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff497224ULL, 0x000fe200078e00ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000860027824ULL, 0x002fe200078e0205ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x00000009ff7879a7ULL, 0x0002a20008500004ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fc4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00002009020279a7ULL, 0x0002e2000850003fULL, 0x0000000000567805ULL, 0x000fe4000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x000000a000448947ULL, 0x000fec0003800000ULL,
0x00009400ff2f7b82ULL, 0x000f620000000800ULL, 0x0000000863027824ULL, 0x008fe200078e00ffULL,
0x0000000160007812ULL, 0x000fe200078ec0ffULL, 0x0000000207087824ULL, 0x000fe200078e00ffULL,
0x000000095a057c11ULL, 0x000fe2000f8e28ffULL, 0x000000ffff397224ULL, 0x000fe200078e0003ULL,
0x0000000802027812ULL, 0x000fe200078ec0ffULL, 0xff317217ff7e7424ULL, 0x000fe400078e00ffULL,
0x0000001000057824ULL, 0x000fe400078e0205ULL, 0x000000ffff077224ULL, 0x000fc400078e00ffULL,
0x0000000102097824ULL, 0x002fe400078e0205ULL, 0x0000002f08087224ULL, 0x020fe400078e022fULL,
0x000000ffff2f7224ULL, 0x000fce00078e00ffULL, 0x000000ffff6e7224ULL, 0x000fce00078e0059ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x0000000463067824ULL, 0x000fca00078e00ffULL,
0xfffffff806367812ULL, 0x000fc800078ec0ffULL, 0x01a6c839360075a7ULL, 0x000e620008000149ULL,
0x0000000936387c36ULL, 0x000fc80008000000ULL, 0x0001a6c838067836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x01a6c839380075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00008e00ff347b82ULL, 0x000e620000000a00ULL, 0x0000001063367824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x00000001073a7836ULL, 0x000fe40000000000ULL,
0x0000000481817c24ULL, 0x010fe2000f8e02ffULL, 0xffffffe036387812ULL, 0x000fe400078ec0ffULL,
0x000000613a00720cULL, 0x000fe20003f26070ULL, 0x0000004081817824ULL, 0x000fe400078e00ffULL,
0x0000010007387824ULL, 0x000fc800078e0238ULL, 0x0000004038397836ULL, 0x000fca0000000000ULL,
0x0000002039377812ULL, 0x000fe200078ec0ffULL, 0x0000008081347825ULL, 0x002fc800078e0034ULL,
0x00000001584c7824ULL, 0x000fe200078e0237ULL, 0x0000000400049947ULL, 0x000fec0003800000ULL,
0x0000001036377812ULL, 0x000fe200078ec0ffULL, 0x000000100a5c7824ULL, 0x000fe200078e00ffULL,
0x0000003974367248ULL, 0x000fe40007fe0000ULL, 0x00000003ff3a7819ULL, 0x100fe4000001160aULL,
0x000000705c657812ULL, 0x000fe200078ec0ffULL, 0x0000000136367824ULL, 0x000fe400078e0a39ULL,
0x000000013a397824ULL, 0x000fe400078e0237ULL, 0x000000083a4d7836ULL, 0x000fe20000000000ULL,
0x0000003736367248ULL, 0x000fe20007fe0000ULL, 0x0000000139387824ULL, 0x000fc400078e020aULL,
0x00000008393b7824ULL, 0x000fe400078e00ffULL, 0x0000000136367824ULL, 0x000fc600078e0a37ULL,
0xfffffff83b4e7812ULL, 0x000fe200078ee238ULL, 0x000000043a3b7836ULL, 0x000fe20000000000ULL,
0x000000363a00720cULL, 0x080fe20003f86070ULL, 0x0000000c3a3a7836ULL, 0x000fe20000000000ULL,
0x000000364d00720cULL, 0x0c0fe20003f46070ULL, 0x000000014d4d7824ULL, 0x100fe200078e0237ULL,
0x000000363b00720cULL, 0x0c0fe20003f66070ULL, 0x000000013b3b7824ULL, 0x100fe200078e0237ULL,
0x000000363a00720cULL, 0x040fe20003f06070ULL, 0x000000013a4f7824ULL, 0x000fe400078e0237ULL,
0x000000014c387824ULL, 0x000fc400078e023bULL, 0x000000013b3a7824ULL, 0x140fe400078e020aULL,
0x000000083b5f7824ULL, 0x000fe400078e00ffULL, 0x000000014c367824ULL, 0x040fe400078e0239ULL,
0x000000014c3b7824ULL, 0x040fe200078e024dULL, 0xfffffff85f5c7812ULL, 0x000fe200078ee23aULL,
0x000000014c5d7824ULL, 0x000fe200078e024fULL, 0x00000009605f7c11ULL, 0x000fe2000f8e68ffULL,
0x000000014d4c7824ULL, 0x000fc400078e020aULL, 0x000000084d677824ULL, 0x000fe400078e00ffULL,
0x000000014f4d7824ULL, 0x040fe400078e020aULL, 0x000000084f647824ULL, 0x000fe200078e00ffULL,
0xfffffff8675e7812ULL, 0x000fe200078ee24cULL, 0x0000008038387825ULL, 0x000fc600078e00ffULL,
0xfffffff864647812ULL, 0x000fe200078ee24dULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x00000065384d7212ULL, 0x000fc600078efcffULL, 0x000000803b3a7825ULL, 0x000fe200078e00ffULL,
0x00000065364f7212ULL, 0x080fe400078efcffULL, 0x0000004d34387210ULL, 0x000fe20007fde0ffULL,
0x000000805d4c7825ULL, 0x000fe200078e00ffULL, 0x0000004f34367210ULL, 0x000fe40007fbe0ffULL,
0x000000653a677212ULL, 0x080fe200078efcffULL, 0x000170005f4f7836ULL, 0x000fe20000000000ULL,
0x000000654c657212ULL, 0x000fe200078efcffULL, 0x0000000135377824ULL, 0x040fe200028e0637ULL,
0x00000067343a7210ULL, 0x000fe20007fbe0ffULL, 0x0000000135397824ULL, 0x000fe200030e0639ULL,
0x0000006534347210ULL, 0x000fe20007fde0ffULL, 0x000000104e5d7824ULL, 0x000fc400078e024fULL,
0x000000105c5f7824ULL, 0x100fe400078e024fULL, 0x000000105e657824ULL, 0x000fe200078e024fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000365d7faeULL, 0x0003e2000e101c46ULL,
0x00000001353b7824ULL, 0x040fe400028e063bULL, 0x00000010644f7824ULL, 0x000fe200078e024fULL,
0x00000000385f7faeULL, 0x0003e2000d901c46ULL, 0x0000000135357824ULL, 0x000fc600030e064dULL,
0x000000003a657faeULL, 0x0003e8000d101c46ULL, 0x00000000344f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x0000001036377812ULL, 0x000fe200078ec0ffULL,
0x000000100a3a7824ULL, 0x000fc600078e00ffULL, 0x000000370a377211ULL, 0x000fe400078fe8ffULL,
0x000000703a657812ULL, 0x000fc600078ec0ffULL, 0x0000000437397836ULL, 0x000fe40000000000ULL,
0x0000000137367824ULL, 0x140fe400078e020aULL, 0x00000008373b7824ULL, 0x000fe400078e00ffULL,
0x0000000139387824ULL, 0x040fe400078e020aULL, 0x00000008394d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b4e7812ULL, 0x000fe200078ee236ULL, 0x000000014c367824ULL, 0x000fc400078e0237ULL,
0x00000008373b7836ULL, 0x000fe20000000000ULL, 0xfffffff84d5c7812ULL, 0x000fe200078ee238ULL,
0x0000000c374d7836ULL, 0x000fe40000000000ULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x000000014c397824ULL, 0x000fe200078e0239ULL, 0x00000065364f7212ULL, 0x000fe200078efcffULL,
0x000000014c3a7824ULL, 0x040fe400078e023bULL, 0x000000013b387824ULL, 0x140fe200078e020aULL,
0x0000004f34367210ULL, 0x000fe20007f1e0ffULL, 0x000000083b5d7824ULL, 0x000fe400078e00ffULL,
0x000000014c4c7824ULL, 0x000fe400078e024dULL, 0x000000014d3b7824ULL, 0x040fe200078e020aULL,
0xfffffff85d5e7812ULL, 0x000fe200078ee238ULL, 0x000000084d647824ULL, 0x000fe200078e00ffULL,
0x00000009604d7c11ULL, 0x000fe2000f8e68ffULL, 0x0000008039387825ULL, 0x000fc600078e00ffULL,
0xfffffff864647812ULL, 0x000fe200078ee23bULL, 0x000170004d6b7836ULL, 0x000fe20000000000ULL,
0x0000006538697212ULL, 0x000fe200078efcffULL, 0x000000803a3a7825ULL, 0x000fc800078e00ffULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x000000653a677212ULL, 0x000fc600078efcffULL,
0x0000000135377824ULL, 0x040fe200000e0637ULL, 0x000000654c657212ULL, 0x000fe200078efcffULL,
0x000000104e4f7824ULL, 0x100fe200078e026bULL, 0x0000006934387210ULL, 0x000fe20007f1e0ffULL,
0x000000105c5d7824ULL, 0x100fe200078e026bULL, 0x00000067343a7210ULL, 0x000fe20007f5e0ffULL,
0x000000105e5f7824ULL, 0x000fe200078e026bULL, 0x0000006534347210ULL, 0x000fe20007f7e0ffULL,
0x0000000135397824ULL, 0x040fe200000e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000364f7faeULL, 0x0003e2000b901c46ULL, 0x00000001353b7824ULL, 0x000fc400010e063bULL,
0x0000001064657824ULL, 0x000fe200078e026bULL, 0x00000000385d7faeULL, 0x0003e2000b901c46ULL,
0x0000000135357824ULL, 0x000fc600018e064dULL, 0x000000003a5f7faeULL, 0x0003e8000b901c46ULL,
0x0000000034657faeULL, 0x0003e4000b901c46ULL, 0x0000000159377836ULL, 0x002fe40000000000ULL,
0xffffffffff7c7424ULL, 0x000fc600078e00ffULL, 0x000000623700720cULL, 0x000fe20003f06070ULL,
0x00000008637a7824ULL, 0x000fca00078e00ffULL, 0xfffffff07a387812ULL, 0x000fca00078ec0ffULL,
0x00000009383a7c36ULL, 0x000fe40008000000ULL, 0x00009000ff348b82ULL, 0x000e620000000a00ULL,
0x0000000108378824ULL, 0x000fe200078e0237ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000003a0472caULL, 0x000fda00000e0000ULL, 0x0001a6b004047890ULL, 0x000fe2000fffe03fULL,
0x0000000437348825ULL, 0x002fd000078e0034ULL, 0x00000000ff0079b0ULL, 0x000fe80008000a44ULL,
0x00000006347c8981ULL, 0x000322000c1e1900ULL, 0xffffffe07a367812ULL, 0x040fe200078ec0ffULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x000000107a377812ULL, 0x000fc800078ec0ffULL,
0x0000000937367c10ULL, 0x000fe4000fffe036ULL, 0x000000087a377812ULL, 0x000fca00078ec0ffULL,
0x0000000136807824ULL, 0x000fe200078e0237ULL, 0x0000000000007918ULL, 0x002fcc0000000000ULL,
0x01a6b0393a8679a7ULL, 0x0002e4000850003fULL, 0x01a60839803879a7ULL, 0x0022a4000850003fULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x01a60839800075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a60839800075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x000000100a6d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff707819ULL, 0x000fe2000001160aULL,
0x0000002063347824ULL, 0x000fe400078e00ffULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x000000706d6d7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff837224ULL, 0x000fe200078e007eULL,
0xffffff8034347812ULL, 0x000fe400078ec0ffULL, 0x0000000c70707812ULL, 0x000fe400078ec0ffULL,
0x000000096d357c10ULL, 0x000fca000fffe034ULL, 0x0000000135357824ULL, 0x000fca00078e0270ULL,
0x01a0000035377984ULL, 0x000ea80000000800ULL, 0x01a2000035397984ULL, 0x000b620000000800ULL,
0x0000007e3700720bULL, 0x004fda0003f1d000ULL, 0x0000000000367806ULL, 0x000fc800000e0100ULL,
0x000000ff3600720cULL, 0x000fda0003f05270ULL, 0x00000004008c8947ULL, 0x02afea0003800000ULL,
0x000000635a00720cULL, 0x000fe40003f45270ULL, 0x0000007e3700720bULL, 0x0c0fe40003f14000ULL,
0x0000007e37837209ULL, 0x000fd20007810000ULL, 0x000000096334ac11ULL, 0x000fe4000f8e38ffULL,
0x0000000000357806ULL, 0x000fe400000e0100ULL, 0x000000347034a210ULL, 0x000fe40007ffe06dULL,
0x000000ff3500720cULL, 0x000fc60003f05270ULL, 0x01a400833400a388ULL, 0x0003f40000000800ULL,
0x0000000400508947ULL, 0x002fea0003800000ULL, 0x0000007e83347221ULL, 0x000fe20000010100ULL,
0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0035ff7812ULL, 0x040fe2000784c0ffULL,
0x3fb8aa3b34347820ULL, 0x000fe20000410000ULL, 0x00ff000035ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000035ff7812ULL, 0x000fe2000788c0ffULL, 0x00000034003b7308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff347819ULL, 0x002fcc000001160aULL,
0x00001f343b347589ULL, 0x004e6400000e0000ULL, 0x0000003454547220ULL, 0x082fe20000410000ULL,
0x0000003455557220ULL, 0x080fe20000410000ULL, 0x000000343c3c7220ULL, 0x080fe20000410000ULL,
0x000000343d3d7220ULL, 0x080fe20000410000ULL, 0x0000003440407220ULL, 0x080fe20000410000ULL,
0x0000003441417220ULL, 0x080fe20000410000ULL, 0x0000003444447220ULL, 0x080fe20000410000ULL,
0x0000003445457220ULL, 0x080fe20000410000ULL, 0x0000003448487220ULL, 0x080fe20000410000ULL,
0x0000003449497220ULL, 0x080fe20000410000ULL, 0x0000003450507220ULL, 0x080fe20000410000ULL,
0x0000003451517220ULL, 0x080fe20000410000ULL, 0x0000003428287220ULL, 0x080fe20000410000ULL,
0x0000003429297220ULL, 0x080fe20000410000ULL, 0x0000003424247220ULL, 0x080fe20000410000ULL,
0x0000003425257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000080a347811ULL, 0x002fcc00078ff0ffULL, 0x00001f343b347589ULL, 0x004e6400000e0000ULL,
0x0000003456567220ULL, 0x082fe20000410000ULL, 0x0000003457577220ULL, 0x080fe20000410000ULL,
0x000000343e3e7220ULL, 0x080fe20000410000ULL, 0x000000343f3f7220ULL, 0x080fe20000410000ULL,
0x0000003442427220ULL, 0x080fe20000410000ULL, 0x0000003443437220ULL, 0x080fe20000410000ULL,
0x0000003446467220ULL, 0x080fe20000410000ULL, 0x0000003447477220ULL, 0x080fe20000410000ULL,
0x000000344a4a7220ULL, 0x080fe20000410000ULL, 0x000000344b4b7220ULL, 0x080fe20000410000ULL,
0x0000003452527220ULL, 0x080fe20000410000ULL, 0x0000003453537220ULL, 0x080fe20000410000ULL,
0x000000342a2a7220ULL, 0x080fe20000410000ULL, 0x000000342b2b7220ULL, 0x080fe20000410000ULL,
0x0000003426267220ULL, 0x080fe20000410000ULL, 0x0000003427277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000100a347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343b347589ULL, 0x004e6400000e0000ULL, 0x000000340c0c7220ULL, 0x082fe20000410000ULL,
0x000000340d0d7220ULL, 0x080fe20000410000ULL, 0x0000003410107220ULL, 0x080fe20000410000ULL,
0x0000003411117220ULL, 0x080fe20000410000ULL, 0x0000003414147220ULL, 0x080fe20000410000ULL,
0x0000003415157220ULL, 0x080fe20000410000ULL, 0x0000003418187220ULL, 0x080fe20000410000ULL,
0x0000003419197220ULL, 0x080fe20000410000ULL, 0x000000341c1c7220ULL, 0x080fe20000410000ULL,
0x000000341d1d7220ULL, 0x080fe20000410000ULL, 0x0000003420207220ULL, 0x080fe20000410000ULL,
0x0000003421217220ULL, 0x080fe20000410000ULL, 0x0000003430307220ULL, 0x080fe20000410000ULL,
0x0000003431317220ULL, 0x080fe20000410000ULL, 0x000000342c2c7220ULL, 0x080fe20000410000ULL,
0x000000342d2d7220ULL, 0x000fce0000410000ULL, 0x0000003b82827220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000180a347811ULL, 0x002fcc00078ff0ffULL,
0x00001f343b347589ULL, 0x000e6400000e0000ULL, 0x000000340e0e7220ULL, 0x082fe20000410000ULL,
0x000000340f0f7220ULL, 0x080fe20000410000ULL, 0x0000003412127220ULL, 0x080fe20000410000ULL,
0x0000003413137220ULL, 0x080fe20000410000ULL, 0x0000003416167220ULL, 0x080fe20000410000ULL,
0x0000003417177220ULL, 0x080fe20000410000ULL, 0x000000341a1a7220ULL, 0x080fe20000410000ULL,
0x000000341b1b7220ULL, 0x080fe20000410000ULL, 0x000000341e1e7220ULL, 0x080fe20000410000ULL,
0x000000341f1f7220ULL, 0x080fe20000410000ULL, 0x0000003422227220ULL, 0x080fe20000410000ULL,
0x0000003423237220ULL, 0x080fe20000410000ULL, 0x0000003432327220ULL, 0x080fe20000410000ULL,
0x0000003433337220ULL, 0x080fe20000410000ULL, 0x000000342e2e7220ULL, 0x080fe20000410000ULL,
0x000000342f2f7220ULL, 0x000fce0000410000ULL, 0x0000003536ff7212ULL, 0x000fda00078030ffULL,
0x8000008337370221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b37370820ULL, 0x000fc80000410000ULL, 0x0000003700040308ULL, 0x000ea40000000800ULL,
0x0000000439390220ULL, 0x004fce0000410000ULL, 0x0000008239827221ULL, 0x000fce0000010000ULL,
0x0000000000347805ULL, 0x002fce0000015200ULL, 0x01a6a8793a0075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3b7224ULL, 0x000fce00078e00ffULL,
0x000000103b00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x0000003634397210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003936367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013b3b7836ULL, 0x000fce0000000000ULL,
0x01a6a8793a0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991038357816ULL, 0x000fe200000000ffULL, 0x0000000263817824ULL, 0x040fe400078e00ffULL,
0x0000040063347824ULL, 0x000fe200078e00ffULL, 0x000000ff3500720cULL, 0x000fe20003f05270ULL,
0x00000004637d7824ULL, 0x000fe200078e00ffULL, 0x000000080a357812ULL, 0x000fe200078ec0ffULL,
0x00000009ff797e24ULL, 0x000fe2000f8e00ffULL, 0x0000000481717812ULL, 0x000fe200078ec0ffULL,
0x00000009ff377e24ULL, 0x000fe2000f8e00ffULL, 0x00000007356c7812ULL, 0x000fc400078ef80aULL,
0x000000710a357211ULL, 0x000fe400078fe0ffULL, 0x000000106c787812ULL, 0x040fe200078efcffULL,
0x000000086c367824ULL, 0x000fe200078e00ffULL, 0xfffff00034347812ULL, 0x000fe200078ec0ffULL,
0x000000016c7f7824ULL, 0x000fe200078e0235ULL, 0x000000047d7d7812ULL, 0x000fe200078ec0ffULL,
0x00000001357e7824ULL, 0x000fe200078e0278ULL, 0x0001200079797810ULL, 0x000fe20007ffe034ULL,
0x0000000878357824ULL, 0x000fe200078e00ffULL, 0x0000007d0a7d7211ULL, 0x000fe200078fe0ffULL,
0x0000100063347824ULL, 0x000fe200078e00ffULL, 0xfffffff8367f7812ULL, 0x000fe200078ee27fULL,
0x000000086c6f7824ULL, 0x040fe200078e00ffULL, 0xfffffff8357e7812ULL, 0x000fe200078ee27eULL,
0x000000016c5c7824ULL, 0x000fe200078e027dULL, 0xffffe00034347812ULL, 0x000fe200078ec0ffULL,
0x000000107f367824ULL, 0x000fc400078e0279ULL, 0x000000107e387824ULL, 0x000fe200078e0279ULL,
0x00016000375e7810ULL, 0x000fe40007ffe034ULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee25cULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000000ffULL, 0x0000001003057836ULL, 0x000fe20000000000ULL,
0x0000541000347816ULL, 0x000fe20000000000ULL, 0x0000000803357836ULL, 0x000fe40000000000ULL,
0x0000001803377836ULL, 0x000fe40000000000ULL, 0x00001f0534057589ULL, 0x0002a800000e0000ULL,
0x00001f3534027589ULL, 0x0002e800000e0000ULL, 0x00001f0334037589ULL, 0x00026800000e0000ULL,
0x00001f3734007589ULL, 0x00026400000e0000ULL, 0x000000003634783bULL, 0x002e620000000200ULL,
0x000000106f4c7824ULL, 0x000fc600078e025eULL, 0x000000003838783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x088fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x0000000538387232ULL, 0x084fe40000000000ULL,
0x000000053a3a7232ULL, 0x000fc40000000000ULL, 0x0000000039397232ULL, 0x080fe40000000000ULL,
0x000000003b3b7232ULL, 0x000fce0000000000ULL, 0x000000086c647824ULL, 0x000fe200078e00ffULL,
0x000000004c4c783bULL, 0x000f620000004200ULL, 0x000000025c7b7836ULL, 0x000fe20000000000ULL,
0x0000000271717812ULL, 0x000fc800078efcffULL, 0xfffffff8647b7812ULL, 0x000fca00078ee27bULL,
0x000000107b5e7824ULL, 0x000fcc00078e025eULL, 0x000000005e5c783bULL, 0x000f640000004200ULL,
0x00000018ff677819ULL, 0x028fe4000001164fULL, 0x00000010ff917819ULL, 0x000fe4000001164cULL,
0x00000018ff657819ULL, 0x000fe4000001164eULL, 0x0000ffff4d8c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff927819ULL, 0x000fc4000001164dULL, 0x0000ffff4e8d7812ULL, 0x000fe400078ec0ffULL,
0x0000ffff4c6a7812ULL, 0x040fe400078ec0ffULL, 0x000000ff4c907812ULL, 0x000fe400078ec0ffULL,
0x000000ff91917812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6b7819ULL, 0x004fe4000001165dULL,
0x000000ff5d947812ULL, 0x000fc400078ec0ffULL, 0x000000ff5e957812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe4000001165fULL, 0x000000ff5f967812ULL, 0x040fe400078ec0ffULL,
0x00000018ff687819ULL, 0x000fe4000001165fULL, 0x0000ffff5f727812ULL, 0x000fe400078ec0ffULL,
0x00000010ff887819ULL, 0x000fc4000001165eULL, 0x00000018ff937819ULL, 0x000fe4000001165eULL,
0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL, 0x00000067ff5f723eULL, 0x000fe400020006ffULL,
0x00000065ff5e723eULL, 0x000fe400020006ffULL, 0x0000006bff67723eULL, 0x000fe400020006ffULL,
0x00000094ff65723eULL, 0x000fc400020006ffULL, 0x00000095ff6b723eULL, 0x000fe400020006ffULL,
0x00000008ff8c7819ULL, 0x000fe4000001168cULL, 0x00000018ff8a7819ULL, 0x000fe4000001164cULL,
0x000000ff4d8f7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8b7819ULL, 0x000fe4000001164dULL,
0x000000ff92947812ULL, 0x000fc400078ec0ffULL, 0x00000008ff957819ULL, 0x000fe4000001168dULL,
0x00000010ff4d7819ULL, 0x000fe4000001164eULL, 0x0000ffff4f4c7812ULL, 0x040fe400078ec0ffULL,
0x00000008ff927819ULL, 0x000fe4000001166aULL, 0x000000ff4e897812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f697812ULL, 0x000fc400078ec0ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000093ff6a723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001165cULL, 0x0000008cff93723eULL, 0x000fe400020006ffULL,
0x00000010ff8e7819ULL, 0x000fc4000001164fULL, 0x00000095ff8c723eULL, 0x000fe400020006ffULL,
0x00000010ff4f7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d857812ULL, 0x000fe400078ec0ffULL,
0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff957819ULL, 0x000fe4000001164cULL,
0x000000ff5c847812ULL, 0x000fc400078ec0ffULL, 0x00000018ff737819ULL, 0x000fe4000001165cULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000069ff5d723eULL, 0x000fe400020006ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00005410904c7816ULL, 0x000fe40000000091ULL,
0x0000ffff5c5c7812ULL, 0x000fc400078ec0ffULL, 0x00000096ff69723eULL, 0x000fe400020006ffULL,
0x000000ff4e907812ULL, 0x000fe400078ec0ffULL, 0x000000ff8e967812ULL, 0x000fe400078ec0ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x0000004dff8e723eULL, 0x000fe400020006ffULL,
0x00005410924e7816ULL, 0x000fc4000000008aULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x00000090ff90723eULL, 0x000fe400020006ffULL, 0x00000008ff8a7819ULL, 0x000fe4000001165cULL,
0x00005410895c7816ULL, 0x000fe4000000008eULL, 0x000000ff64897812ULL, 0x000fe400078ec0ffULL,
0x0000008fff8f723eULL, 0x000fc400020006ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000094ff94723eULL, 0x000fe400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x000000ff88887812ULL, 0x000fe400078ec0ffULL, 0x0000541084647816ULL, 0x000fe40000000090ULL,
0x000000ff4f917812ULL, 0x000fc400078ec0ffULL, 0x00000008ff857819ULL, 0x000fe40000011685ULL,
0x00000008ff847819ULL, 0x000fe40000011666ULL, 0x00000008ff727819ULL, 0x000fe40000011672ULL,
0x000054108f4d7816ULL, 0x000fe40000000094ULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x000054108a667816ULL, 0x000fc40000000073ULL, 0x0000008bff8b723eULL, 0x000fe200020006ffULL,
0x0000004c3454723cULL, 0x002fe20000001854ULL, 0x00000096ff8d723eULL, 0x000fe400020006ffULL,
0x00000095ff8f723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fe200020006ffULL,
0x0000004c380c723cULL, 0x000fe2000000180cULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fc400020006ffULL, 0x00000068ff73723eULL, 0x000fe400020006ffULL,
0x00000084ff84723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x000054106b687816ULL, 0x000fe40000000088ULL, 0x00005410934f7816ULL, 0x000fe4000000008bULL,
0x000054105d5d7816ULL, 0x000fc4000000008dULL, 0x000054108c5e7816ULL, 0x000fe4000000005eULL,
0x000054108f5f7816ULL, 0x000fe2000000005fULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x0000541065657816ULL, 0x000fe40000000091ULL, 0x0000541085677816ULL, 0x000fe40000000067ULL,
0x0000541069697816ULL, 0x000fe20000000089ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x00005410846a7816ULL, 0x000fc4000000006aULL, 0x00005410726b7816ULL, 0x000fe40000000073ULL,
0x0000000960737c11ULL, 0x000fe2000f8e68ffULL, 0x0000005e3444723cULL, 0x000fe80000001844ULL,
0x0001600073847836ULL, 0x000fe40000000000ULL, 0x000000643448723cULL, 0x000fec0000001848ULL,
0x000000663450723cULL, 0x000fec0000001850ULL, 0x000000683428723cULL, 0x000fec0000001828ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x0000005c3814723cULL, 0x000fe20000001814ULL,
0x000000710a357211ULL, 0x000fe200078fe0ffULL, 0x000000086c347824ULL, 0x000fc400078e00ffULL,
0x0000000878377824ULL, 0x000fe400078e00ffULL, 0x000000016c717824ULL, 0x100fe200078e0235ULL,
0x0000004e3810723cULL, 0x000fe20000001810ULL, 0x0000000178727824ULL, 0x040fe400078e0235ULL,
0x00000001785c7824ULL, 0x040fe200078e027dULL, 0xfffffff834717812ULL, 0x000fe200078ee271ULL,
0x00000008787d7824ULL, 0x000fe200078e00ffULL, 0xfffffff837727812ULL, 0x000fe200078ee272ULL,
0x0000005e3818723cULL, 0x000fe40000001818ULL, 0x0000001071347824ULL, 0x100fe200078e0279ULL,
0xfffffff87d7d7812ULL, 0x000fe200078ee25cULL, 0x0000001072797824ULL, 0x000fc400078e0279ULL,
0x00000064381c723cULL, 0x000fe4000000181cULL, 0x000000003434783bULL, 0x000e620000000200ULL,
0x000000107d4c7824ULL, 0x000fc600078e0284ULL, 0x000000663820723cULL, 0x000fec0000001820ULL,
0x000000683830723cULL, 0x000fec0000001830ULL, 0x0000006a3838723cULL, 0x000fe2000000182cULL,
0x00000000792c783bULL, 0x0004e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x080fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x088fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x00000008785e7824ULL, 0x000fe200078e00ffULL,
0x000000004c4c783bULL, 0x000f620000004200ULL, 0x000000025c797836ULL, 0x004fe20000000000ULL,
0xfffffff881817812ULL, 0x000fc800078ec0ffULL, 0xfffffff85e797812ULL, 0x000fca00078ee279ULL,
0x00000010795c7824ULL, 0x000fcc00078e0284ULL, 0x000000005c5c783bULL, 0x000ea20000004200ULL,
0x00000018ff677819ULL, 0x020fe4000001164fULL, 0x00000010ff957819ULL, 0x100fe4000001164dULL,
0x000000ff4d937812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001164dULL,
0x00000018ff657819ULL, 0x000fe4000001164eULL, 0x00000010ff947819ULL, 0x000fc4000001164cULL,
0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4c6a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff94947812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6b7819ULL, 0x004fe4000001165dULL,
0x000000ff5e987812ULL, 0x000fe400078ec0ffULL, 0x00000010ff647819ULL, 0x000fc4000001165fULL,
0x000000ff5f997812ULL, 0x040fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fe4000001165fULL,
0x0000ffff5f857812ULL, 0x000fe400078ec0ffULL, 0x00000067ff5f723eULL, 0x000fe400020006ffULL,
0x0000006bff67723eULL, 0x000fe400020006ffULL, 0x000000ff5d977812ULL, 0x000fc400078ec0ffULL,
0x00000098ff6b723eULL, 0x000fe400020006ffULL, 0x000000ff95987812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8b7819ULL, 0x100fe4000001165eULL, 0x00000018ff967819ULL, 0x000fe4000001165eULL,
0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL, 0x00000065ff5e723eULL, 0x000fc400020006ffULL,
0x00000097ff65723eULL, 0x000fe400020006ffULL, 0x00000008ff4d7819ULL, 0x000fe4000001164dULL,
0x00000018ff8f7819ULL, 0x000fe4000001164cULL, 0x00000010ff8d7819ULL, 0x000fe4000001164eULL,
0x000000ff4e8c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4e917812ULL, 0x000fc400078ec0ffULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x00000008ff977819ULL, 0x000fe4000001166aULL,
0x00000098ff98723eULL, 0x000fe400020006ffULL, 0x00000010ff4e7819ULL, 0x000fe4000001165cULL,
0x00000096ff6a723eULL, 0x000fe400020006ffULL, 0x00000094ff95723eULL, 0x000fc400020006ffULL,
0x0000004dff96723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000097ff94723eULL, 0x000fe400020006ffULL, 0x000000ff8d8d7812ULL, 0x000fe400078ec0ffULL,
0x00005410934d7816ULL, 0x000fe40000000098ULL, 0x000000ff5c897812ULL, 0x000fc400078ec0ffULL,
0x00000018ff887819ULL, 0x000fe4000001165cULL, 0x000000ff4e937812ULL, 0x000fe400078ec0ffULL,
0x000000ff4c927812ULL, 0x000fe400078ec0ffULL, 0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff977819ULL, 0x000fe40000011691ULL, 0x0000008cff8c723eULL, 0x000fc400020006ffULL,
0x0000008dff91723eULL, 0x000fe400020006ffULL, 0x00005410944e7816ULL, 0x000fe4000000008fULL,
0x0000ffff4f4c7812ULL, 0x040fe400078ec0ffULL, 0x00000093ff8f723eULL, 0x000fe400020006ffULL,
0x00000010ff907819ULL, 0x000fe4000001164fULL, 0x000000ff4f697812ULL, 0x000fc400078ec0ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000008ff937819ULL, 0x000fe4000001165cULL, 0x00000010ff4f7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d8a7812ULL, 0x000fe400078ec0ffULL, 0x00000097ff8d723eULL, 0x000fc400020006ffULL,
0x000054108c5c7816ULL, 0x000fe40000000091ULL, 0x00000008ff977819ULL, 0x000fe4000001164cULL,
0x000000ff648c7812ULL, 0x000fe400078ec0ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00005410924c7816ULL, 0x000fc40000000095ULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x000000ff8b8b7812ULL, 0x000fe400078ec0ffULL,
0x0000541089647816ULL, 0x000fe2000000008fULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x000000ff90907812ULL, 0x000fe400078ec0ffULL, 0x000000ff4f957812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8a7819ULL, 0x000fe2000001168aULL, 0x0000004c2c0c723cULL, 0x008fe2000000180cULL,
0x00000008ff897819ULL, 0x000fc40000011666ULL, 0x00000008ff857819ULL, 0x000fe40000011685ULL,
0x00000069ff5d723eULL, 0x000fe400020006ffULL, 0x00005410964f7816ULL, 0x000fe4000000008eULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x0000541093667816ULL, 0x000fe40000000088ULL,
0x00000099ff69723eULL, 0x000fe200020006ffULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x00000090ff90723eULL, 0x000fc400020006ffULL, 0x00000097ff92723eULL, 0x000fe400020006ffULL,
0x00000095ff8e723eULL, 0x000fe200020006ffULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x0000008cff8c723eULL, 0x000fe400020006ffULL,
0x00000068ff88723eULL, 0x000fe400020006ffULL, 0x00000089ff89723eULL, 0x000fc400020006ffULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x000054106b687816ULL, 0x000fe4000000008bULL,
0x000054105d5d7816ULL, 0x000fe40000000090ULL, 0x000054108d5e7816ULL, 0x000fe4000000005eULL,
0x00005410925f7816ULL, 0x000fe4000000005fULL, 0x0000541065657816ULL, 0x000fe2000000008eULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x000054108a677816ULL, 0x000fc40000000067ULL,
0x0000541069697816ULL, 0x000fe4000000008cULL, 0x00005410896a7816ULL, 0x000fe2000000006aULL,
0x0000005e3444723cULL, 0x000fe20000001844ULL, 0x00005410856b7816ULL, 0x000fca0000000088ULL,
0x000000643448723cULL, 0x000fec0000001848ULL, 0x000000663450723cULL, 0x000fec0000001850ULL,
0x000000683428723cULL, 0x000fec0000001828ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x0000000960347c11ULL, 0x000fe2000f8e18ffULL,
0x00000001ff367424ULL, 0x000fc800078e00ffULL, 0x0000005e2c18723cULL, 0x000fe20000001818ULL,
0x01a6c836343479a7ULL, 0x0002aa000850003fULL, 0x000000642c1c723cULL, 0x000fe2000000181cULL,
0x01a6883681ff79a7ULL, 0x0003ea0008500009ULL, 0x000000662c20723cULL, 0x000fec0000001820ULL,
0x000000682c30723cULL, 0x000fec0000001830ULL, 0x0000006a2c38723cULL, 0x002fde0000001838ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x00000035060075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000372e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00008e00ff2c7b82ULL, 0x000e620000000a00ULL,
0x00000010632e7824ULL, 0x000fe200078e00ffULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x000000047c7c7c24ULL, 0x010fe4000f8e02ffULL, 0xffffffe02e347812ULL, 0x000fe400078ec0ffULL,
0x000000407c357824ULL, 0x000fc600078e00ffULL, 0x0000010007347824ULL, 0x000fc800078e0234ULL,
0x0000008034377836ULL, 0x000fca0000000000ULL, 0x00000020372f7812ULL, 0x000fe200078ec0ffULL,
0x00000080352c7825ULL, 0x002fc800078e002cULL, 0x00000001584e7824ULL, 0x000fe200078e022fULL,
0x0000000000f49947ULL, 0x000fec0003800000ULL, 0x000000102e2f7812ULL, 0x000fe400078ec0ffULL,
0x00000037742e7248ULL, 0x000fe40007fe0000ULL, 0x00000003ff347819ULL, 0x000fc6000001160aULL,
0x000000012e2e7824ULL, 0x000fe400078e0a37ULL, 0x0000000134357824ULL, 0x100fe400078e022fULL,
0x0000000434377836ULL, 0x000fe20000000000ULL, 0x0000002e2f2e7248ULL, 0x000fe20007fe0000ULL,
0x0000000135367824ULL, 0x040fe400078e020aULL, 0x00000008355d7824ULL, 0x000fe400078e00ffULL,
0x000000012e2e7824ULL, 0x000fc400078e0a2fULL, 0x0000000c344d7836ULL, 0x000fe20000000000ULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee236ULL, 0x0000000834367836ULL, 0x000fe20000000000ULL,
0x0000002e3700720cULL, 0x0c0fe20003f66070ULL, 0x0000000137377824ULL, 0x100fe200078e022fULL,
0x0000002e3400720cULL, 0x080fe20003f86070ULL, 0x00000001364f7824ULL, 0x040fe200078e022fULL,
0x0000002e3600720cULL, 0x080fe20003f46070ULL, 0x0000000135347824ULL, 0x100fe200078e024eULL,
0x0000002e4d00720cULL, 0x000fe20003f06070ULL, 0x00000001374c7824ULL, 0x000fc400078e024eULL,
0x000000014f357824ULL, 0x140fe400078e020aULL, 0x000000084f5c7824ULL, 0x000fe400078e00ffULL,
0x000000014d5f7824ULL, 0x000fe400078e022fULL, 0x00000001372f7824ULL, 0x040fe200078e020aULL,
0xfffffff85c697812ULL, 0x000fe200078ee235ULL, 0x0000000837367824ULL, 0x000fe400078e00ffULL,
0x000000804c4c7825ULL, 0x000fc600078e00ffULL, 0xfffffff836677812ULL, 0x000fe200078ee22fULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000006d4c2f7212ULL, 0x000fc600078efcffULL,
0x000000014f367824ULL, 0x100fe200078e024eULL, 0x0000006d344f7212ULL, 0x000fe200078efcffULL,
0x000000015f2e7824ULL, 0x000fe200078e024eULL, 0x0000002f2c4c7210ULL, 0x000fe20007fde0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000004f2c347210ULL, 0x000fc60007fbe0ffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000006d36657212ULL, 0x000fc600078efcffULL,
0x000000015f4e7824ULL, 0x040fe400078e020aULL, 0x000000085f6b7824ULL, 0x000fe200078e00ffULL,
0x0000006d2e5f7212ULL, 0x000fe200078efcffULL, 0x000000012d357824ULL, 0x040fe200028e0635ULL,
0x000000652c367210ULL, 0x000fe20007fbe0ffULL, 0x000000012d4d7824ULL, 0x000fe200030e064dULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee24eULL, 0x000000105d4f7824ULL, 0x100fe200078e0284ULL,
0x0000005f2c2c7210ULL, 0x000fe20007fde0ffULL, 0x00000010675d7824ULL, 0x000fc400078e0284ULL,
0x00000010695f7824ULL, 0x100fe200078e0284ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000344f7faeULL, 0x0003e2000e101c46ULL, 0x000000012d377824ULL, 0x000fe400028e0637ULL,
0x000000106b657824ULL, 0x000fe200078e0284ULL, 0x000000004c5d7faeULL, 0x0003e2000d901c46ULL,
0x000000012d2d7824ULL, 0x000fc600030e062fULL, 0x00000000365f7faeULL, 0x0003e8000d101c46ULL,
0x000000002c657faeULL, 0x0003e2000c101c46ULL, 0x0000000000c07947ULL, 0x000fea0003800000ULL,
0x000000102e2f7812ULL, 0x000fc800078ec0ffULL, 0x0000002f0a2f7211ULL, 0x000fca00078fe8ffULL,
0x000000012f347824ULL, 0x040fe400078e020aULL, 0x000000082f4f7824ULL, 0x040fe400078e00ffULL,
0x000000012f2e7824ULL, 0x000fe400078e024eULL, 0x000000042f357836ULL, 0x000fe20000000000ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee234ULL, 0x000000082f4d7836ULL, 0x000fe40000000000ULL,
0x0000000c2f5d7836ULL, 0x000fc40000000000ULL, 0x000000802e2e7825ULL, 0x000fc800078e00ffULL,
0x0000000135367824ULL, 0x100fe400078e024eULL, 0x000000014d4c7824ULL, 0x100fe400078e024eULL,
0x000000015d347824ULL, 0x000fe400078e024eULL, 0x0000000135377824ULL, 0x140fe400078e020aULL,
0x00000008355c7824ULL, 0x000fe200078e00ffULL, 0x0000006d2e357212ULL, 0x000fe200078efcffULL,
0x000000014d4e7824ULL, 0x000fc400078e020aULL, 0x000000084d5f7824ULL, 0x000fe200078e00ffULL,
0x000000352c2e7210ULL, 0x000fe20007f1e0ffULL, 0x000000015d4d7824ULL, 0x040fe400078e020aULL,
0x000000085d5e7824ULL, 0x000fe200078e00ffULL, 0xfffffff85c5d7812ULL, 0x000fe200078ee237ULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0xfffffff85f5f7812ULL, 0x000fe400078ee24eULL,
0xfffffff85e6b7812ULL, 0x000fe200078ee24dULL, 0x000000804c4c7825ULL, 0x000fe200078e00ffULL,
0x0000006d36697212ULL, 0x000fc600078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000006d4c677212ULL, 0x000fc600078efcffULL, 0x000000012d2f7824ULL, 0x000fe200000e062fULL,
0x0000006d34657212ULL, 0x000fe200078efcffULL, 0x000000104f4f7824ULL, 0x100fe200078e0284ULL,
0x000000692c367210ULL, 0x000fe20007f1e0ffULL, 0x000000105d5d7824ULL, 0x100fe200078e0284ULL,
0x000000672c4c7210ULL, 0x000fe20007f5e0ffULL, 0x000000105f5f7824ULL, 0x000fe200078e0284ULL,
0x000000652c2c7210ULL, 0x000fe20007f7e0ffULL, 0x000000012d377824ULL, 0x040fe200000e0637ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e4f7faeULL, 0x0003e2000b901c46ULL,
0x000000012d4d7824ULL, 0x000fc400010e064dULL, 0x000000106b657824ULL, 0x000fe200078e0284ULL,
0x00000000365d7faeULL, 0x0003e2000b901c46ULL, 0x000000012d2d7824ULL, 0x000fc600018e0635ULL,
0x000000004c5f7faeULL, 0x0003e8000b901c46ULL, 0x000000002c657faeULL, 0x0003e4000b901c46ULL,
0x00000002592f7836ULL, 0x002fe40000000000ULL, 0xffffffffff817424ULL, 0x000fc600078e00ffULL,
0x000000622f00720cULL, 0x000fe40003f06070ULL, 0xfffffff07a7a7812ULL, 0x000fca00078ec0ffULL,
0x000000097a847c36ULL, 0x000fe20008000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00009000ff2c8b82ULL, 0x000e620000000a00ULL, 0x00000000840472caULL, 0x000fe200000e0000ULL,
0x00000001082f8824ULL, 0x000fd800078e022fULL, 0x0001a6a804047890ULL, 0x000fd2000fffe03fULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x000000042f2c8825ULL, 0x002fca00078e002cULL,
0x000000062c818981ULL, 0x000322000c1e1900ULL, 0x00000001ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x01a6a82f848479a7ULL, 0x0004e4000850003fULL,
0x01a6282f802e79a7ULL, 0x004464000850003fULL, 0x00000000002c7805ULL, 0x002fce0000015200ULL,
0x01a6282f800075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x000000342c377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6282f800075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000020632c7824ULL, 0x000fe400078e00ffULL,
0x00000009ff2d7e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0xffffff802c2c7812ULL, 0x000fc800078ec0ffULL, 0x000000802d2c7810ULL, 0x000fc80007ffe02cULL,
0x0000002c702c7210ULL, 0x000fca0007ffe06dULL, 0x01a000002c2e7984ULL, 0x000e680000000800ULL,
0x01a200002c2d7984ULL, 0x000b620000000800ULL, 0x000000832e00720bULL, 0x002fda0003f1d000ULL,
0x00000000002f7806ULL, 0x000fc800000e0100ULL, 0x000000ff2f00720cULL, 0x000fda0003f05270ULL,
0x00000004009c8947ULL, 0x02cfea0003800000ULL, 0x000000015a2c7836ULL, 0x000fe20000000000ULL,
0x000000832e00720bULL, 0x000fc80003f14000ULL, 0x000000632c00720cULL, 0x000fda0003f45270ULL,
0x000000096334ac11ULL, 0x000fe4000f8e38ffULL, 0x000000832e2ca209ULL, 0x000fe40007810000ULL,
0x000000347035a210ULL, 0x000fe40007ffe06dULL, 0x0000000000347806ULL, 0x000fc600000e0100ULL,
0x01a4002c3500a388ULL, 0x0003e20000000800ULL, 0x000000ff3400720cULL, 0x000fda0003f05270ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x000000832e2c7209ULL, 0x000fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x000000832c2c7221ULL, 0x000fe20000010100ULL, 0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000034ff7812ULL, 0x000fe2000788c0ffULL, 0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL,
0x0000002c00357308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff2c7819ULL, 0x002fcc000001160aULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x000000542c547220ULL, 0x042fe20000410000ULL, 0x000000552c557220ULL, 0x040fe20000410000ULL,
0x0000003c2c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d2c3d7220ULL, 0x040fe20000410000ULL,
0x000000402c407220ULL, 0x040fe20000410000ULL, 0x000000412c417220ULL, 0x040fe20000410000ULL,
0x000000442c447220ULL, 0x040fe20000410000ULL, 0x000000452c457220ULL, 0x040fe20000410000ULL,
0x000000482c487220ULL, 0x040fe20000410000ULL, 0x000000492c497220ULL, 0x040fe20000410000ULL,
0x000000502c507220ULL, 0x040fe20000410000ULL, 0x000000512c517220ULL, 0x040fe20000410000ULL,
0x000000282c287220ULL, 0x040fe20000410000ULL, 0x000000292c297220ULL, 0x040fe20000410000ULL,
0x000000242c247220ULL, 0x040fe20000410000ULL, 0x000000252c257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a2c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x000000562c567220ULL, 0x042fe20000410000ULL,
0x000000572c577220ULL, 0x040fe20000410000ULL, 0x0000003e2c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f2c3f7220ULL, 0x040fe20000410000ULL, 0x000000422c427220ULL, 0x040fe20000410000ULL,
0x000000432c437220ULL, 0x040fe20000410000ULL, 0x000000462c467220ULL, 0x040fe20000410000ULL,
0x000000472c477220ULL, 0x040fe20000410000ULL, 0x0000004a2c4a7220ULL, 0x040fe20000410000ULL,
0x0000004b2c4b7220ULL, 0x040fe20000410000ULL, 0x000000522c527220ULL, 0x040fe20000410000ULL,
0x000000532c537220ULL, 0x040fe20000410000ULL, 0x0000002a2c2a7220ULL, 0x040fe20000410000ULL,
0x0000002b2c2b7220ULL, 0x040fe20000410000ULL, 0x000000262c267220ULL, 0x040fe20000410000ULL,
0x000000272c277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a2c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x0000000c2c0c7220ULL, 0x042fe20000410000ULL, 0x0000000d2c0d7220ULL, 0x040fe20000410000ULL,
0x000000102c107220ULL, 0x040fe20000410000ULL, 0x000000112c117220ULL, 0x040fe20000410000ULL,
0x000000142c147220ULL, 0x040fe20000410000ULL, 0x000000152c157220ULL, 0x040fe20000410000ULL,
0x000000182c187220ULL, 0x040fe20000410000ULL, 0x000000192c197220ULL, 0x040fe20000410000ULL,
0x0000001c2c1c7220ULL, 0x040fe20000410000ULL, 0x0000001d2c1d7220ULL, 0x040fe20000410000ULL,
0x000000202c207220ULL, 0x040fe20000410000ULL, 0x000000212c217220ULL, 0x040fe20000410000ULL,
0x000000302c307220ULL, 0x040fe20000410000ULL, 0x000000312c317220ULL, 0x040fe20000410000ULL,
0x000000382c387220ULL, 0x040fe20000410000ULL, 0x000000392c397220ULL, 0x000fce0000410000ULL,
0x0000003582827220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a2c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x000e6400000e0000ULL,
0x0000000e2c0e7220ULL, 0x042fe20000410000ULL, 0x0000000f2c0f7220ULL, 0x040fe20000410000ULL,
0x000000122c127220ULL, 0x040fe20000410000ULL, 0x000000132c137220ULL, 0x040fe20000410000ULL,
0x000000162c167220ULL, 0x040fe20000410000ULL, 0x000000172c177220ULL, 0x040fe20000410000ULL,
0x0000001a2c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b2c1b7220ULL, 0x040fe20000410000ULL,
0x0000001e2c1e7220ULL, 0x040fe20000410000ULL, 0x0000001f2c1f7220ULL, 0x040fe20000410000ULL,
0x000000222c227220ULL, 0x040fe20000410000ULL, 0x000000232c237220ULL, 0x040fe20000410000ULL,
0x000000322c327220ULL, 0x040fe20000410000ULL, 0x000000332c337220ULL, 0x040fe20000410000ULL,
0x0000003a2c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b2c3b7220ULL, 0x000fce0000410000ULL,
0x000000342fff7212ULL, 0x000fe200078030ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x000000832e837209ULL, 0x000fd60007810000ULL, 0x800000832e2e0221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL,
0x0000002e00040308ULL, 0x000ea40000000800ULL, 0x000000042d2d0220ULL, 0x004fce0000410000ULL,
0x000000822d827221ULL, 0x000fce0000010000ULL, 0x00000000002c7805ULL, 0x002fce0000015200ULL,
0x00000008632e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2f7812ULL, 0x000fc800078ec0ffULL,
0x01a6b0872f0075a7ULL, 0x000e620008000149ULL, 0x000000092f377c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6b087370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009910342c7816ULL, 0x000fe200000000ffULL, 0x00000400632d7824ULL, 0x040fe400078e00ffULL,
0x00001000632e7824ULL, 0x000fe200078e00ffULL, 0x000000ff2c00720cULL, 0x000fe20003f05270ULL,
0x00000009ff7c7e24ULL, 0x000fe2000f8e00ffULL, 0xfffff0002d2d7812ULL, 0x000fe200078ec0ffULL,
0x00000009ff2f7e24ULL, 0x000fe2000f8e00ffULL, 0xffffe0002e2e7812ULL, 0x000fe400078ec0ffULL,
0x000130007c7c7810ULL, 0x000fc40007ffe02dULL, 0x000170002f5c7810ULL, 0x000fc60007ffe02eULL,
0x000000107f347824ULL, 0x100fe400078e027cULL, 0x000000107e2c7824ULL, 0x000fe400078e027cULL,
0x000000106f4c7824ULL, 0x000fe200078e025cULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff2e7819ULL, 0x000fe4000001160aULL, 0x00000004ff00723eULL, 0x000fc600000000ffULL,
0x000000082e027836ULL, 0x000fe20000000000ULL, 0x00005410002d7816ULL, 0x000fe20000000000ULL,
0x000000102e367836ULL, 0x000fe40000000000ULL, 0x000000182e4e7836ULL, 0x000fe40000000000ULL,
0x00001f022d027589ULL, 0x0002a800000e0000ULL, 0x00001f362d057589ULL, 0x0002e800000e0000ULL,
0x00001f2e2d037589ULL, 0x00026800000e0000ULL, 0x00001f4e2d007589ULL, 0x00026400000e0000ULL,
0x000000003434783bULL, 0x002e680000000200ULL, 0x000000002c2c783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x084fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x088fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000107b5c7824ULL, 0x000fe200078e025cULL,
0x000000004c4c783bULL, 0x000f6a0000004200ULL, 0x000000005c5c783bULL, 0x000f640000004200ULL,
0x00000018ff657819ULL, 0x028fe4000001164eULL, 0x00000010ff927819ULL, 0x000fc4000001164cULL,
0x00000018ff677819ULL, 0x000fe4000001164fULL, 0x000000ff5d957812ULL, 0x004fe400078ec0ffULL,
0x0000ffff4c6a7812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001165dULL,
0x00000010ff887819ULL, 0x000fe4000001165eULL, 0x000000ff5e967812ULL, 0x000fc400078ec0ffULL,
0x00000018ff947819ULL, 0x000fe4000001165eULL, 0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL,
0x00000010ff937819ULL, 0x000fe4000001164dULL, 0x00000010ff647819ULL, 0x100fe4000001165fULL,
0x000000ff5f977812ULL, 0x000fe400078ec0ffULL, 0x00000018ff687819ULL, 0x000fc4000001165fULL,
0x0000ffff5f7a7812ULL, 0x000fe400078ec0ffULL, 0x00000065ff5e723eULL, 0x000fe400020006ffULL,
0x00000067ff5f723eULL, 0x000fe400020006ffULL, 0x00000095ff65723eULL, 0x000fe400020006ffULL,
0x000000ff92927812ULL, 0x000fe400078ec0ffULL, 0x0000ffff4d8d7812ULL, 0x000fc400078ec0ffULL,
0x0000006bff67723eULL, 0x000fe400020006ffULL, 0x00000008ff957819ULL, 0x000fe4000001166aULL,
0x0000ffff4e8e7812ULL, 0x000fe400078ec0ffULL, 0x00000096ff6b723eULL, 0x000fe400020006ffULL,
0x000000ff93967812ULL, 0x000fe400078ec0ffULL, 0x000000ff4c917812ULL, 0x000fc400078ec0ffULL,
0x00000092ff93723eULL, 0x000fe400020006ffULL, 0x00000095ff92723eULL, 0x000fe400020006ffULL,
0x00000008ff8d7819ULL, 0x000fe4000001168dULL, 0x00000018ff8b7819ULL, 0x000fe4000001164cULL,
0x000000ff4d907812ULL, 0x000fe400078ec0ffULL, 0x00000018ff8c7819ULL, 0x000fc4000001164dULL,
0x00000008ff957819ULL, 0x000fe4000001168eULL, 0x00000010ff4d7819ULL, 0x000fe4000001164eULL,
0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e8a7812ULL, 0x000fe400078ec0ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000094ff6a723eULL, 0x000fc400020006ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001165cULL, 0x0000008dff94723eULL, 0x000fe400020006ffULL,
0x00000095ff8d723eULL, 0x000fe400020006ffULL, 0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff957819ULL, 0x000fe4000001164cULL, 0x000000ff5c877812ULL, 0x000fc400078ec0ffULL,
0x00000018ff867819ULL, 0x000fe4000001165cULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00005410914c7816ULL, 0x000fe40000000093ULL, 0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4e917812ULL, 0x000fe400078ec0ffULL, 0x0000008aff8a723eULL, 0x000fc400020006ffULL,
0x0000004dff8e723eULL, 0x000fe400020006ffULL, 0x00005410924e7816ULL, 0x000fe4000000008bULL,
0x00000010ff8f7819ULL, 0x000fe4000001164fULL, 0x000000ff4f697812ULL, 0x000fe400078ec0ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x00000091ff91723eULL, 0x000fc400020006ffULL,
0x00000008ff8b7819ULL, 0x000fe4000001165cULL, 0x00000010ff4f7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d897812ULL, 0x000fe400078ec0ffULL, 0x000054108a5c7816ULL, 0x000fe4000000008eULL,
0x000000ff648a7812ULL, 0x000fe400078ec0ffULL, 0x00000090ff90723eULL, 0x000fc400020006ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x00000096ff96723eULL, 0x000fe400020006ffULL,
0x0000008bff8b723eULL, 0x000fe400020006ffULL, 0x000000ff88887812ULL, 0x000fe400078ec0ffULL,
0x0000541087647816ULL, 0x000fe40000000091ULL, 0x000000ff8f8f7812ULL, 0x000fc400078ec0ffULL,
0x000000ff4f937812ULL, 0x000fe400078ec0ffULL, 0x00000008ff897819ULL, 0x000fe40000011689ULL,
0x00000008ff877819ULL, 0x000fe40000011666ULL, 0x00000008ff7a7819ULL, 0x000fe4000001167aULL,
0x00000069ff5d723eULL, 0x000fe400020006ffULL, 0x00005410904d7816ULL, 0x000fc40000000096ULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x000054108b667816ULL, 0x000fe40000000086ULL,
0x0000008cff8c723eULL, 0x000fe200020006ffULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x00000097ff69723eULL, 0x000fe400020006ffULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000095ff90723eULL, 0x000fe200020006ffULL, 0x0000004c2c0c723cULL, 0x000fe2000000180cULL,
0x00000093ff93723eULL, 0x000fc400020006ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000068ff86723eULL, 0x000fe200020006ffULL,
0x00000010724c7824ULL, 0x000fe200078e027cULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x0000007aff7a723eULL, 0x000fe400020006ffULL, 0x000054106b687816ULL, 0x000fc40000000088ULL,
0x00005410944f7816ULL, 0x000fe4000000008cULL, 0x000054105d5d7816ULL, 0x000fe4000000008fULL,
0x000054108d5e7816ULL, 0x000fe4000000005eULL, 0x00005410905f7816ULL, 0x000fe2000000005fULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x0000541065657816ULL, 0x000fe40000000093ULL,
0x0000541089677816ULL, 0x000fc40000000067ULL, 0x0000541069697816ULL, 0x000fe2000000008aULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x00005410876a7816ULL, 0x000fe4000000006aULL,
0x000054107a6b7816ULL, 0x000fe20000000086ULL, 0x00017000737a7836ULL, 0x000fe40000000000ULL,
0x0000005e3444723cULL, 0x000fec0000001844ULL, 0x000000643448723cULL, 0x000fec0000001848ULL,
0x000000663450723cULL, 0x000fec0000001850ULL, 0x000000683428723cULL, 0x000fec0000001828ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x0000001071347824ULL, 0x000fc400078e027cULL, 0x000000107d7c7824ULL, 0x000fc600078e027aULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x000000003434783bULL, 0x000e6a0000000200ULL,
0x0000005e2c18723cULL, 0x000fec0000001818ULL, 0x000000642c1c723cULL, 0x000fec000000181cULL,
0x000000662c20723cULL, 0x000fec0000001820ULL, 0x000000682c30723cULL, 0x000fec0000001830ULL,
0x0000006a2c38723cULL, 0x000fe20000001838ULL, 0x000000004c2c783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x080fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x00000010795c7824ULL, 0x000fe200078e027aULL, 0x000000007c4c783bULL, 0x004eaa0000004200ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x00000018ff677819ULL, 0x004fe4000001164fULL,
0x00000010ff947819ULL, 0x000fe4000001164dULL, 0x000000ff4d927812ULL, 0x000fc400078ec0ffULL,
0x00000018ff6b7819ULL, 0x028fe4000001165dULL, 0x000000ff5e977812ULL, 0x000fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe4000001165fULL, 0x000000ff5f987812ULL, 0x040fe400078ec0ffULL,
0x00000018ff687819ULL, 0x000fe4000001165fULL, 0x0000ffff5f867812ULL, 0x000fc400078ec0ffULL,
0x00000067ff5f723eULL, 0x000fe400020006ffULL, 0x00000018ff8e7819ULL, 0x000fe4000001164dULL,
0x00000018ff657819ULL, 0x000fe4000001164eULL, 0x0000006bff67723eULL, 0x000fe400020006ffULL,
0x00000010ff937819ULL, 0x000fe4000001164cULL, 0x0000ffff4d4d7812ULL, 0x000fc400078ec0ffULL,
0x000000ff5d967812ULL, 0x000fe400078ec0ffULL, 0x00000097ff6b723eULL, 0x000fe400020006ffULL,
0x0000ffff4c6a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff94977812ULL, 0x000fe400078ec0ffULL,
0x00000010ff897819ULL, 0x100fe4000001165eULL, 0x00000018ff957819ULL, 0x000fc4000001165eULL,
0x0000ffff5e667812ULL, 0x000fe400078ec0ffULL, 0x00000065ff5e723eULL, 0x000fe400020006ffULL,
0x00000010ff8c7819ULL, 0x000fe4000001164eULL, 0x00000096ff65723eULL, 0x000fe400020006ffULL,
0x000000ff93937812ULL, 0x000fe400078ec0ffULL, 0x00000008ff4d7819ULL, 0x000fc4000001164dULL,
0x00000018ff8d7819ULL, 0x000fe4000001164cULL, 0x000000ff4e8b7812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e907812ULL, 0x000fe400078ec0ffULL, 0x000000ff4f697812ULL, 0x000fe400078ec0ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00000008ff967819ULL, 0x000fc4000001166aULL,
0x00000097ff97723eULL, 0x000fe400020006ffULL, 0x000000ff4c917812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4e7819ULL, 0x000fe4000001165cULL, 0x00000010ff8f7819ULL, 0x000fe4000001164fULL,
0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL, 0x00000095ff6a723eULL, 0x000fc400020006ffULL,
0x00000010ff4f7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d8a7812ULL, 0x000fe400078ec0ffULL,
0x00000093ff94723eULL, 0x000fe400020006ffULL, 0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL,
0x0000004dff95723eULL, 0x000fe400020006ffULL, 0x000000ff5c887812ULL, 0x000fc400078ec0ffULL,
0x00000018ff877819ULL, 0x000fe4000001165cULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000069ff5d723eULL, 0x000fe400020006ffULL, 0x00000096ff93723eULL, 0x000fe400020006ffULL,
0x00005410924d7816ULL, 0x000fe40000000097ULL, 0x0000ffff5c5c7812ULL, 0x000fc400078ec0ffULL,
0x00000098ff69723eULL, 0x000fe400020006ffULL, 0x000000ff4e927812ULL, 0x000fe400078ec0ffULL,
0x000000ff8f987812ULL, 0x000fe400078ec0ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000008ff967819ULL, 0x000fe40000011690ULL, 0x0000008cff8f723eULL, 0x000fc400020006ffULL,
0x00005410934e7816ULL, 0x000fe4000000008dULL, 0x00000091ff91723eULL, 0x000fe400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000092ff92723eULL, 0x000fe400020006ffULL,
0x00000008ff8d7819ULL, 0x000fe4000001165cULL, 0x00000096ff8c723eULL, 0x000fc400020006ffULL,
0x000054108b5c7816ULL, 0x000fe4000000008fULL, 0x00000008ff967819ULL, 0x000fe4000001164cULL,
0x000000ff648b7812ULL, 0x000fe400078ec0ffULL, 0x00000087ff87723eULL, 0x000fe400020006ffULL,
0x00005410914c7816ULL, 0x000fe40000000094ULL, 0x0000008dff8d723eULL, 0x000fc400020006ffULL,
0x000000ff89897812ULL, 0x000fe400078ec0ffULL, 0x0000541088647816ULL, 0x000fe20000000092ULL,
0x0000004c3454723cULL, 0x002fe20000001854ULL, 0x000000ff4f947812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8a7819ULL, 0x000fe4000001168aULL, 0x00000008ff887819ULL, 0x000fe20000011666ULL,
0x0000004c2c0c723cULL, 0x000fe2000000180cULL, 0x00000008ff867819ULL, 0x000fc40000011686ULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x000054108d667816ULL, 0x000fe40000000087ULL,
0x0000008eff8e723eULL, 0x000fe400020006ffULL, 0x00000098ff90723eULL, 0x000fe400020006ffULL,
0x00000096ff91723eULL, 0x000fe400020006ffULL, 0x00000094ff94723eULL, 0x000fc400020006ffULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000068ff87723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000086ff86723eULL, 0x000fe400020006ffULL, 0x000054106b687816ULL, 0x000fc40000000089ULL,
0x00005410954f7816ULL, 0x000fe4000000008eULL, 0x000054105d5d7816ULL, 0x000fe40000000090ULL,
0x000054108c5e7816ULL, 0x000fe4000000005eULL, 0x00005410915f7816ULL, 0x000fe2000000005fULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x0000541065657816ULL, 0x000fe40000000094ULL,
0x000054108a677816ULL, 0x000fc40000000067ULL, 0x0000541069697816ULL, 0x000fe2000000008bULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x00005410886a7816ULL, 0x000fe4000000006aULL,
0x00005410866b7816ULL, 0x000fc60000000087ULL, 0x0000005e3444723cULL, 0x000fec0000001844ULL,
0x000000643448723cULL, 0x000fec0000001848ULL, 0x000000663450723cULL, 0x000fec0000001850ULL,
0x000000683428723cULL, 0x000fec0000001828ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x0000004e2c10723cULL, 0x000fe20000001810ULL, 0x0000000263357824ULL, 0x000fe200078e00ffULL,
0x0000000960347c11ULL, 0x000fe2000f8e18ffULL, 0x00000001ff377424ULL, 0x000fc600078e00ffULL,
0xfffffff835367812ULL, 0x000fe200078ec0ffULL, 0x0000005c2c14723cULL, 0x000fe20000001814ULL,
0x01a6c837343479a7ULL, 0x00026a000850003fULL, 0x0000005e2c18723cULL, 0x000fe20000001818ULL,
0x01a6903736ff79a7ULL, 0x0003ea0008500009ULL, 0x000000642c1c723cULL, 0x000fec000000181cULL,
0x000000662c20723cULL, 0x000fec0000001820ULL, 0x000000682c30723cULL, 0x000fec0000001830ULL,
0x0000006a2c38723cULL, 0x002fde0000001838ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x00000035060075a7ULL, 0x000e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x00000035060075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00008e00ff2c7b82ULL, 0x000e620000000a00ULL, 0x00000010632e7824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe40000000800ULL, 0x0000000481817c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe02e347812ULL, 0x000fe400078ec0ffULL, 0x0000004081817824ULL, 0x000fc600078e00ffULL,
0x0000010007347824ULL, 0x000fc800078e0234ULL, 0x000000c034357836ULL, 0x000fca0000000000ULL,
0x00000020352f7812ULL, 0x000fe200078ec0ffULL, 0x00000080812c7825ULL, 0x002fc800078e002cULL,
0x00000001584d7824ULL, 0x000fe200078e022fULL, 0x0000000000f49947ULL, 0x000fec0003800000ULL,
0x000000102e2f7812ULL, 0x000fe400078ec0ffULL, 0x00000035742e7248ULL, 0x000fe40007fe0000ULL,
0x00000003ff347819ULL, 0x000fc6000001160aULL, 0x000000012e2e7824ULL, 0x000fe400078e0a35ULL,
0x0000000134357824ULL, 0x100fe400078e022fULL, 0x0000000434377836ULL, 0x000fe20000000000ULL,
0x0000002e2f2e7248ULL, 0x000fe20007fe0000ULL, 0x0000000135367824ULL, 0x040fe400078e020aULL,
0x00000008355f7824ULL, 0x000fe400078e00ffULL, 0x000000012e2e7824ULL, 0x000fc400078e0a2fULL,
0x00000008344c7836ULL, 0x000fe20000000000ULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee236ULL,
0x0000000137367824ULL, 0x040fe200078e022fULL, 0x0000002e3400720cULL, 0x080fe20003f86070ULL,
0x0000000c344e7836ULL, 0x000fe20000000000ULL, 0x0000002e3700720cULL, 0x080fe20003f66070ULL,
0x0000000135347824ULL, 0x000fe200078e024dULL, 0x0000002e4c00720cULL, 0x080fe20003f46070ULL,
0x0000000136357824ULL, 0x000fe200078e020aULL, 0x0000002e4e00720cULL, 0x000fe20003f06070ULL,
0x00000008365e7824ULL, 0x000fc400078e00ffULL, 0x000000014c377824ULL, 0x000fe400078e022fULL,
0x0000000136367824ULL, 0x000fe200078e024dULL, 0xfffffff85e657812ULL, 0x000fe200078ee235ULL,
0x0000008034347825ULL, 0x000fc800078e00ffULL, 0x000000014e5c7824ULL, 0x000fe200078e022fULL,
0x0000006d342f7212ULL, 0x000fe200078efcffULL, 0x00000001374c7824ULL, 0x040fe400078e024dULL,
0x00000001374e7824ULL, 0x040fe200078e020aULL, 0x0000002f2c347210ULL, 0x000fe20007fbe0ffULL,
0x0000000837677824ULL, 0x000fe400078e00ffULL, 0x0000008036367825ULL, 0x000fc600078e00ffULL,
0xfffffff867677812ULL, 0x000fe200078ee24eULL, 0x000000015c2e7824ULL, 0x000fe200078e024dULL,
0x0000006d364f7212ULL, 0x000fe200078efcffULL, 0x000000804c4c7825ULL, 0x000fc800078e00ffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000006d4c5d7212ULL, 0x000fc600078efcffULL,
0x000000012d357824ULL, 0x040fe200028e0635ULL, 0x0000004f2c367210ULL, 0x000fe20007fbe0ffULL,
0x000000015c4e7824ULL, 0x000fe200078e020aULL, 0x0000006d2e4f7212ULL, 0x000fe200078efcffULL,
0x000000085c697824ULL, 0x000fe400078e00ffULL, 0x000000012d377824ULL, 0x000fe200028e0637ULL,
0x0000005d2c4c7210ULL, 0x000fe20007fbe0ffULL, 0x000000105f5f7824ULL, 0x100fe200078e027aULL,
0x0000004f2c2c7210ULL, 0x000fe20007fde0ffULL, 0x0000001065657824ULL, 0x100fe200078e027aULL,
0xfffffff8694f7812ULL, 0x000fe200078ee24eULL, 0x000000012d4d7824ULL, 0x000fe200028e064dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000345f7faeULL, 0x0003e2000e101c46ULL,
0x0000001067677824ULL, 0x000fc400078e027aULL, 0x000000012d2d7824ULL, 0x000fe200030e062fULL,
0x0000000036657faeULL, 0x0003e2000d901c46ULL, 0x000000104f4f7824ULL, 0x000fc600078e027aULL,
0x000000004c677faeULL, 0x0003e8000d101c46ULL, 0x000000002c4f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000c07947ULL, 0x000fea0003800000ULL, 0x000000102e2f7812ULL, 0x000fc800078ec0ffULL,
0x0000002f0a2f7211ULL, 0x000fca00078fe8ffULL, 0x000000042f367836ULL, 0x000fe40000000000ULL,
0x000000082f4c7836ULL, 0x000fe40000000000ULL, 0x0000000136347824ULL, 0x140fe400078e020aULL,
0x0000000836677824ULL, 0x000fe400078e00ffULL, 0x000000014c357824ULL, 0x040fe400078e020aULL,
0x000000084c4e7824ULL, 0x000fe200078e00ffULL, 0xfffffff867677812ULL, 0x000fe200078ee234ULL,
0x000000012f347824ULL, 0x000fc400078e024dULL, 0x000000012f2e7824ULL, 0x040fe200078e020aULL,
0xfffffff84e697812ULL, 0x000fe200078ee235ULL, 0x000000082f657824ULL, 0x000fe400078e00ffULL,
0x0000000c2f2f7836ULL, 0x000fe40000000000ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0xfffffff865657812ULL, 0x000fc600078ee22eULL, 0x0000000136367824ULL, 0x100fe200078e024dULL,
0x0000006d344f7212ULL, 0x000fe200078efcffULL, 0x000000014c4c7824ULL, 0x100fe400078e024dULL,
0x000000012f2e7824ULL, 0x000fe200078e024dULL, 0x0000004f2c347210ULL, 0x000fe20007f1e0ffULL,
0x0000008036367825ULL, 0x000fc800078e00ffULL, 0x000000012f4e7824ULL, 0x040fe200078e020aULL,
0x0000006d365f7212ULL, 0x080fe200078efcffULL, 0x000000082f6b7824ULL, 0x000fe400078e00ffULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x0000005f2c367210ULL, 0x000fe40007f5e0ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee24eULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000006d4c5d7212ULL, 0x000fc600078efcffULL, 0x000000012d357824ULL, 0x000fe200000e0635ULL,
0x0000006d2e4f7212ULL, 0x000fe200078efcffULL, 0x0000001065657824ULL, 0x100fe200078e027aULL,
0x0000005d2c4c7210ULL, 0x000fe20007f1e0ffULL, 0x000000012d377824ULL, 0x000fe200010e0637ULL,
0x0000004f2c2c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001067677824ULL, 0x100fe200078e027aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034657faeULL, 0x0003e2000b901c46ULL,
0x000000012d4d7824ULL, 0x000fe400000e064dULL, 0x0000001069697824ULL, 0x000fe200078e027aULL,
0x0000000036677faeULL, 0x0003e2000b901c46ULL, 0x000000012d2d7824ULL, 0x000fc400018e062fULL,
0x000000106b6b7824ULL, 0x000fe200078e027aULL, 0x000000004c697faeULL, 0x0003e8000b901c46ULL,
0x000000002c6b7faeULL, 0x0003e4000b901c46ULL, 0x00000003592f7836ULL, 0x000fe40000000000ULL,
0xffffffffff817424ULL, 0x000fc600078e00ffULL, 0x000000622f00720cULL, 0x000fe20003f06070ULL,
0x00000008632e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2e7812ULL, 0x000fca00078ec0ffULL,
0x000000092e867c36ULL, 0x000fe40008000000ULL, 0x00009000ff2c8b82ULL, 0x002e620000000a00ULL,
0x00000001082f8824ULL, 0x000fe200078e022fULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000860472caULL, 0x000fda00000e0000ULL, 0x0001a6b004047890ULL, 0x000fe2000fffe03fULL,
0x000000042f2c8825ULL, 0x002fd000078e002cULL, 0x00000000ff0079b0ULL, 0x000fe80008000a44ULL,
0x000000062c818981ULL, 0x000322000c1e1900ULL, 0x00000001ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x01a6b02f868679a7ULL, 0x0004e2000850003fULL,
0x01a6482f802c79a7ULL, 0x002464000850003fULL, 0x00000000002e7805ULL, 0x004fce0000015200ULL,
0x01a6482d800075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fce0000015200ULL,
0x000000342e377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e2fULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6482d800075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000020632c7824ULL, 0x000fe400078e00ffULL,
0x00000009ff2d7e24ULL, 0x000fe4000f8e00ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0xffffff802c2c7812ULL, 0x000fc800078ec0ffULL, 0x000001002d2c7810ULL, 0x000fc80007ffe02cULL,
0x0000002c702c7210ULL, 0x000fca0007ffe06dULL, 0x01a000002c2e7984ULL, 0x000e680000000800ULL,
0x01a200002c2d7984ULL, 0x0004a20000000800ULL, 0x000000832e00720bULL, 0x002fda0003f1d000ULL,
0x00000000002f7806ULL, 0x000fc800000e0100ULL, 0x000000ff2f00720cULL, 0x000fda0003f05270ULL,
0x00000004009c8947ULL, 0x00cfea0003800000ULL, 0x000000025a2c7836ULL, 0x000fe20000000000ULL,
0x000000832e00720bULL, 0x000fc80003f14000ULL, 0x000000632c00720cULL, 0x000fda0003f45270ULL,
0x000000096334ac11ULL, 0x000fe4000f8e38ffULL, 0x000000832e2ca209ULL, 0x000fe40007810000ULL,
0x000000347035a210ULL, 0x000fe40007ffe06dULL, 0x0000000000347806ULL, 0x000fc600000e0100ULL,
0x01a4002c3500a388ULL, 0x0003e20000000800ULL, 0x000000ff3400720cULL, 0x000fda0003f05270ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x000000832e2c7209ULL, 0x000fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x000000832c2c7221ULL, 0x000fe20000010100ULL, 0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000034ff7812ULL, 0x000fe2000788c0ffULL, 0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL,
0x0000002c00357308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff2c7819ULL, 0x002fcc000001160aULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x000000542c547220ULL, 0x042fe20000410000ULL, 0x000000552c557220ULL, 0x040fe20000410000ULL,
0x0000003c2c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d2c3d7220ULL, 0x040fe20000410000ULL,
0x000000402c407220ULL, 0x040fe20000410000ULL, 0x000000412c417220ULL, 0x040fe20000410000ULL,
0x000000442c447220ULL, 0x040fe20000410000ULL, 0x000000452c457220ULL, 0x040fe20000410000ULL,
0x000000482c487220ULL, 0x040fe20000410000ULL, 0x000000492c497220ULL, 0x040fe20000410000ULL,
0x000000502c507220ULL, 0x040fe20000410000ULL, 0x000000512c517220ULL, 0x040fe20000410000ULL,
0x000000282c287220ULL, 0x040fe20000410000ULL, 0x000000292c297220ULL, 0x040fe20000410000ULL,
0x000000242c247220ULL, 0x040fe20000410000ULL, 0x000000252c257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a2c7811ULL, 0x002fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x004e6400000e0000ULL, 0x000000562c567220ULL, 0x042fe20000410000ULL,
0x000000572c577220ULL, 0x040fe20000410000ULL, 0x0000003e2c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f2c3f7220ULL, 0x040fe20000410000ULL, 0x000000422c427220ULL, 0x040fe20000410000ULL,
0x000000432c437220ULL, 0x040fe20000410000ULL, 0x000000462c467220ULL, 0x040fe20000410000ULL,
0x000000472c477220ULL, 0x040fe20000410000ULL, 0x0000004a2c4a7220ULL, 0x040fe20000410000ULL,
0x0000004b2c4b7220ULL, 0x040fe20000410000ULL, 0x000000522c527220ULL, 0x040fe20000410000ULL,
0x000000532c537220ULL, 0x040fe20000410000ULL, 0x0000002a2c2a7220ULL, 0x040fe20000410000ULL,
0x0000002b2c2b7220ULL, 0x040fe20000410000ULL, 0x000000262c267220ULL, 0x040fe20000410000ULL,
0x000000272c277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a2c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x004e6400000e0000ULL,
0x0000000c2c0c7220ULL, 0x042fe20000410000ULL, 0x0000000d2c0d7220ULL, 0x040fe20000410000ULL,
0x000000102c107220ULL, 0x040fe20000410000ULL, 0x000000112c117220ULL, 0x040fe20000410000ULL,
0x000000142c147220ULL, 0x040fe20000410000ULL, 0x000000152c157220ULL, 0x040fe20000410000ULL,
0x000000182c187220ULL, 0x040fe20000410000ULL, 0x000000192c197220ULL, 0x040fe20000410000ULL,
0x0000001c2c1c7220ULL, 0x040fe20000410000ULL, 0x0000001d2c1d7220ULL, 0x040fe20000410000ULL,
0x000000202c207220ULL, 0x040fe20000410000ULL, 0x000000212c217220ULL, 0x040fe20000410000ULL,
0x000000302c307220ULL, 0x040fe20000410000ULL, 0x000000312c317220ULL, 0x040fe20000410000ULL,
0x000000382c387220ULL, 0x040fe20000410000ULL, 0x000000392c397220ULL, 0x000fce0000410000ULL,
0x0000003582827220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a2c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x000e6400000e0000ULL,
0x0000000e2c0e7220ULL, 0x042fe20000410000ULL, 0x0000000f2c0f7220ULL, 0x040fe20000410000ULL,
0x000000122c127220ULL, 0x040fe20000410000ULL, 0x000000132c137220ULL, 0x040fe20000410000ULL,
0x000000162c167220ULL, 0x040fe20000410000ULL, 0x000000172c177220ULL, 0x040fe20000410000ULL,
0x0000001a2c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b2c1b7220ULL, 0x040fe20000410000ULL,
0x0000001e2c1e7220ULL, 0x040fe20000410000ULL, 0x0000001f2c1f7220ULL, 0x040fe20000410000ULL,
0x000000222c227220ULL, 0x040fe20000410000ULL, 0x000000232c237220ULL, 0x040fe20000410000ULL,
0x000000322c327220ULL, 0x040fe20000410000ULL, 0x000000332c337220ULL, 0x040fe20000410000ULL,
0x0000003a2c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b2c3b7220ULL, 0x000fce0000410000ULL,
0x000000342fff7212ULL, 0x000fe200078030ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x000000832e837209ULL, 0x000fd60007810000ULL, 0x800000832e2e0221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL,
0x0000002e00040308ULL, 0x000ea40000000800ULL, 0x000000042d2d0220ULL, 0x004fce0000410000ULL,
0x000000822d827221ULL, 0x000fce0000010000ULL, 0x00000000002c7805ULL, 0x002fce0000015200ULL,
0x0000000863807824ULL, 0x000fca00078e00ffULL, 0xfffffff0802f7812ULL, 0x000fc800078ec0ffULL,
0x01a6a8852f0075a7ULL, 0x000e620008000149ULL, 0x000000092f377c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6a885370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009910342c7816ULL, 0x000fe200000000ffULL, 0x00000400632d7824ULL, 0x040fe400078e00ffULL,
0x00001000632e7824ULL, 0x000fe200078e00ffULL, 0x000000ff2c00720cULL, 0x000fe20003f05270ULL,
0x00000009ff847e24ULL, 0x000fe2000f8e00ffULL, 0xfffff0002d2d7812ULL, 0x000fe200078ec0ffULL,
0x00000009ff2f7e24ULL, 0x000fe2000f8e00ffULL, 0xffffe0002e2e7812ULL, 0x000fe400078ec0ffULL,
0x0001400084847810ULL, 0x000fc40007ffe02dULL, 0x000160002f5c7810ULL, 0x000fc60007ffe02eULL,
0x000000107f347824ULL, 0x100fe400078e0284ULL, 0x000000107e2c7824ULL, 0x000fe400078e0284ULL,
0x000000106f4d7824ULL, 0x000fe200078e025cULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff2e7819ULL, 0x000fe4000001160aULL, 0x00000004ff00723eULL, 0x000fc600000000ffULL,
0x000000082e027836ULL, 0x000fe20000000000ULL, 0x00005410002d7816ULL, 0x000fe20000000000ULL,
0x000000102e367836ULL, 0x000fe40000000000ULL, 0x000000182e4c7836ULL, 0x000fe40000000000ULL,
0x00001f022d027589ULL, 0x0002a800000e0000ULL, 0x00001f362d057589ULL, 0x0002e800000e0000ULL,
0x00001f2e2d037589ULL, 0x00026800000e0000ULL, 0x00001f4c2d007589ULL, 0x00026400000e0000ULL,
0x000000003434783bULL, 0x002e680000000200ULL, 0x000000002c2c783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x084fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x088fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000107b5c7824ULL, 0x000fe200078e025cULL,
0x000000004d4c783bULL, 0x000f6a0000004200ULL, 0x000000005c5c783bULL, 0x000f640000004200ULL,
0x00000018ff657819ULL, 0x028fe4000001164eULL, 0x00000010ff927819ULL, 0x000fc4000001164dULL,
0x000000ff4d907812ULL, 0x000fe400078ec0ffULL, 0x000000ff5d937812ULL, 0x004fe400078ec0ffULL,
0x00000010ff857819ULL, 0x100fe4000001165eULL, 0x00000018ff947819ULL, 0x000fe4000001165eULL,
0x000000ff5e957812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5e667812ULL, 0x000fc400078ec0ffULL,
0x00000018ff8b7819ULL, 0x000fe4000001164dULL, 0x0000ffff4d8e7812ULL, 0x000fe400078ec0ffULL,
0x00000065ff5e723eULL, 0x000fe400020006ffULL, 0x00000010ff4d7819ULL, 0x000fe4000001164eULL,
0x00000093ff65723eULL, 0x000fe400020006ffULL, 0x0000ffff4c697812ULL, 0x000fc400078ec0ffULL,
0x000000ff4f6a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff92937812ULL, 0x000fe400078ec0ffULL,
0x00000010ff917819ULL, 0x100fe4000001164cULL, 0x000000ff4c8f7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001164cULL, 0x00000010ff8d7819ULL, 0x000fc4000001164fULL,
0x00000018ff677819ULL, 0x000fe4000001164fULL, 0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8e7819ULL, 0x000fe4000001168eULL, 0x00000010ff4f7819ULL, 0x100fe4000001165dULL,
0x00000018ff6b7819ULL, 0x000fe4000001165dULL, 0x0000ffff5d887812ULL, 0x000fc400078ec0ffULL,
0x000000ff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x000000ff4e897812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e8c7812ULL, 0x000fe400078ec0ffULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x0000006aff5d723eULL, 0x000fe400020006ffULL, 0x00000008ff927819ULL, 0x000fc40000011669ULL,
0x00000093ff93723eULL, 0x000fe400020006ffULL, 0x00000010ff4e7819ULL, 0x000fe4000001165cULL,
0x00000094ff6a723eULL, 0x000fe400020006ffULL, 0x0000008eff94723eULL, 0x000fe400020006ffULL,
0x0000004dff8e723eULL, 0x000fe400020006ffULL, 0x000000ff5c7f7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001165cULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x00000092ff92723eULL, 0x000fe400020006ffULL, 0x00005410904d7816ULL, 0x000fe40000000093ULL,
0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff91917812ULL, 0x000fc400078ec0ffULL,
0x000000ff4e907812ULL, 0x000fe400078ec0ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x00000010ff647819ULL, 0x100fe4000001165fULL, 0x00000018ff687819ULL, 0x000fe4000001165fULL,
0x000000ff5f967812ULL, 0x040fe400078ec0ffULL, 0x0000ffff5f7b7812ULL, 0x000fc400078ec0ffULL,
0x00005410924e7816ULL, 0x000fe4000000008aULL, 0x0000008fff8f723eULL, 0x000fe400020006ffULL,
0x00000067ff5f723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000090ff90723eULL, 0x000fc400020006ffULL,
0x00000008ff8a7819ULL, 0x000fe4000001165cULL, 0x0000006bff67723eULL, 0x000fe400020006ffULL,
0x00000095ff6b723eULL, 0x000fe400020006ffULL, 0x00005410895c7816ULL, 0x000fe4000000008eULL,
0x00000008ff957819ULL, 0x000fe4000001164cULL, 0x000000ff64897812ULL, 0x000fc400078ec0ffULL,
0x0000007eff7e723eULL, 0x000fe400020006ffULL, 0x000054108f4c7816ULL, 0x000fe40000000091ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x000000ff85857812ULL, 0x000fe400078ec0ffULL,
0x000054107f647816ULL, 0x000fe20000000090ULL, 0x0000004c3454723cULL, 0x002fe20000001854ULL,
0x000000ff8d8d7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff8c7819ULL, 0x000fe4000001168cULL,
0x000000ff4f917812ULL, 0x000fe200078ec0ffULL, 0x0000004c2c0c723cULL, 0x000fe2000000180cULL,
0x00000008ff887819ULL, 0x000fe40000011688ULL, 0x00000008ff7f7819ULL, 0x000fe40000011666ULL,
0x00000008ff7b7819ULL, 0x000fe4000001167bULL, 0x00000085ff85723eULL, 0x000fc400020006ffULL,
0x000054108a667816ULL, 0x000fe4000000007eULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000096ff69723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x00000095ff8f723eULL, 0x000fc400020006ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x00000068ff7e723eULL, 0x000fe400020006ffULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x0000007bff7b723eULL, 0x000fc400020006ffULL,
0x000054106b687816ULL, 0x000fe40000000085ULL, 0x00005410944f7816ULL, 0x000fe4000000008bULL,
0x000054105d5d7816ULL, 0x000fe4000000008dULL, 0x000054108c5e7816ULL, 0x000fe4000000005eULL,
0x000054108f5f7816ULL, 0x000fe2000000005fULL, 0x0000004e343c723cULL, 0x000fe2000000183cULL,
0x0000541065657816ULL, 0x000fc40000000091ULL, 0x0000541088677816ULL, 0x000fe40000000067ULL,
0x0000541069697816ULL, 0x000fe20000000089ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x000054107f6a7816ULL, 0x000fe4000000006aULL, 0x000054107b6b7816ULL, 0x000fe2000000007eULL,
0x00016000737e7836ULL, 0x000fe40000000000ULL, 0x0000005e3444723cULL, 0x000fe40000001844ULL,
0x000000107d4c7824ULL, 0x000fc800078e027eULL, 0x000000643448723cULL, 0x000fec0000001848ULL,
0x000000663450723cULL, 0x000fec0000001850ULL, 0x000000683428723cULL, 0x000fec0000001828ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x0000001071347824ULL, 0x000fc400078e0284ULL, 0x0000001072847824ULL, 0x000fc600078e0284ULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x000000003434783bULL, 0x000e6a0000000200ULL,
0x0000005e2c18723cULL, 0x000fec0000001818ULL, 0x000000642c1c723cULL, 0x000fec000000181cULL,
0x000000662c20723cULL, 0x000fec0000001820ULL, 0x000000682c30723cULL, 0x000fec0000001830ULL,
0x0000006a2c38723cULL, 0x000fe20000001838ULL, 0x00000000842c783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x080fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x00000010795c7824ULL, 0x000fe200078e027eULL, 0x000000004c4c783bULL, 0x000f6a0000004200ULL,
0x000000005c5c783bULL, 0x000f640000004200ULL, 0x00000018ff657819ULL, 0x024fe4000001164eULL,
0x00000010ff8f7819ULL, 0x000fc4000001164dULL, 0x0000ffff4c697812ULL, 0x000fe400078ec0ffULL,
0x000000ff5d907812ULL, 0x008fe400078ec0ffULL, 0x00000010ff7f7819ULL, 0x100fe4000001165eULL,
0x00000018ff917819ULL, 0x000fe4000001165eULL, 0x000000ff5e927812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5e667812ULL, 0x000fc400078ec0ffULL, 0x00000065ff5e723eULL, 0x000fe400020006ffULL,
0x00000090ff65723eULL, 0x000fe400020006ffULL, 0x000000ff4d897812ULL, 0x000fe400078ec0ffULL,
0x000000ff4f6a7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8f907812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8e7819ULL, 0x000fc4000001164cULL, 0x000000ff4c8a7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff857819ULL, 0x000fe4000001164cULL, 0x00000018ff887819ULL, 0x000fe4000001164dULL,
0x0000ffff4d8d7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff8b7819ULL, 0x100fe4000001164fULL,
0x00000018ff677819ULL, 0x000fc4000001164fULL, 0x0000ffff4f4c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff8c7819ULL, 0x000fe4000001164eULL, 0x0000ffff4e4d7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4f7819ULL, 0x100fe4000001165dULL, 0x00000018ff6b7819ULL, 0x000fe4000001165dULL,
0x0000ffff5d7d7812ULL, 0x000fc400078ec0ffULL, 0x000000ff4e847812ULL, 0x000fe400078ec0ffULL,
0x00000089ff89723eULL, 0x000fe400020006ffULL, 0x0000006aff5d723eULL, 0x000fe400020006ffULL,
0x00000008ff8f7819ULL, 0x000fe40000011669ULL, 0x00000090ff90723eULL, 0x000fe400020006ffULL,
0x00000010ff4e7819ULL, 0x000fc4000001165cULL, 0x00000091ff6a723eULL, 0x000fe400020006ffULL,
0x000000ff8b917812ULL, 0x000fe400078ec0ffULL, 0x000000ff8c8c7812ULL, 0x000fe400078ec0ffULL,
0x00000008ff8b7819ULL, 0x000fe4000001164dULL, 0x000000ff5c7b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff797819ULL, 0x000fc4000001165cULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x0000008fff8f723eULL, 0x000fe400020006ffULL, 0x00005410894d7816ULL, 0x000fe40000000090ULL,
0x0000ffff5c5c7812ULL, 0x000fe400078ec0ffULL, 0x000000ff8e8e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4e897812ULL, 0x000fc400078ec0ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x0000008cff8c723eULL, 0x000fe400020006ffULL, 0x00000010ff647819ULL, 0x100fe4000001165fULL,
0x00000018ff687819ULL, 0x000fe4000001165fULL, 0x000000ff5f937812ULL, 0x040fe400078ec0ffULL,
0x0000ffff5f737812ULL, 0x000fc400078ec0ffULL, 0x000054108f4e7816ULL, 0x000fe40000000085ULL,
0x0000008aff8a723eULL, 0x000fe400020006ffULL, 0x00000067ff5f723eULL, 0x000fe400020006ffULL,
0x0000007bff7b723eULL, 0x000fe400020006ffULL, 0x0000008eff8e723eULL, 0x000fe400020006ffULL,
0x00000089ff89723eULL, 0x000fc400020006ffULL, 0x00000008ff857819ULL, 0x000fe4000001165cULL,
0x0000006bff67723eULL, 0x000fe400020006ffULL, 0x00000092ff6b723eULL, 0x000fe400020006ffULL,
0x00005410845c7816ULL, 0x000fe4000000008cULL, 0x00000008ff927819ULL, 0x000fe4000001164cULL,
0x000000ff64847812ULL, 0x000fc400078ec0ffULL, 0x00000079ff79723eULL, 0x000fe400020006ffULL,
0x000054108a4c7816ULL, 0x000fe4000000008eULL, 0x00000085ff85723eULL, 0x000fe400020006ffULL,
0x000000ff7f7f7812ULL, 0x000fe400078ec0ffULL, 0x000054107b647816ULL, 0x000fe20000000089ULL,
0x0000004c3454723cULL, 0x002fe20000001854ULL, 0x00000008ff8d7819ULL, 0x000fc4000001168dULL,
0x000000ff4f8a7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7d7819ULL, 0x000fe2000001167dULL,
0x0000004c2c0c723cULL, 0x000fe2000000180cULL, 0x00000008ff7b7819ULL, 0x000fe40000011666ULL,
0x00000008ff737819ULL, 0x000fe40000011673ULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x0000541085667816ULL, 0x000fc40000000079ULL, 0x00000088ff88723eULL, 0x000fe400020006ffULL,
0x00000093ff69723eULL, 0x000fe400020006ffULL, 0x0000008dff8d723eULL, 0x000fe400020006ffULL,
0x00000091ff91723eULL, 0x000fe400020006ffULL, 0x0000008bff8b723eULL, 0x000fe400020006ffULL,
0x00000092ff92723eULL, 0x000fc400020006ffULL, 0x0000008aff8a723eULL, 0x000fe400020006ffULL,
0x0000007dff7d723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x00000068ff79723eULL, 0x000fe400020006ffULL, 0x0000007bff7b723eULL, 0x000fe400020006ffULL,
0x00000073ff73723eULL, 0x000fc400020006ffULL, 0x000054106b687816ULL, 0x000fe4000000007fULL,
0x000054108d4f7816ULL, 0x000fe40000000088ULL, 0x000054105d5d7816ULL, 0x000fe40000000091ULL,
0x000054108b5e7816ULL, 0x000fe4000000005eULL, 0x00005410925f7816ULL, 0x000fe2000000005fULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x0000541065657816ULL, 0x000fc4000000008aULL,
0x000054107d677816ULL, 0x000fe40000000067ULL, 0x0000541069697816ULL, 0x000fe20000000084ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x000054107b6a7816ULL, 0x000fe4000000006aULL,
0x00005410736b7816ULL, 0x000fe40000000079ULL, 0x00000009604d7c11ULL, 0x000fe2000f8e18ffULL,
0x0000005e3444723cULL, 0x000fec0000001844ULL, 0x000000643448723cULL, 0x000fec0000001848ULL,
0x000000663450723cULL, 0x000fec0000001850ULL, 0x000000683428723cULL, 0x000fec0000001828ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x0000000263347824ULL, 0x000fc400078e00ffULL, 0x00000001ff377424ULL, 0x000fc600078e00ffULL,
0xfffffff834367812ULL, 0x000fe200078ec0ffULL, 0x0000005c2c14723cULL, 0x000fe20000001814ULL,
0x01a6c8374d3479a7ULL, 0x00026a000850003fULL, 0x0000005e2c18723cULL, 0x000fe20000001818ULL,
0x01a6983736ff79a7ULL, 0x0003ea0008500009ULL, 0x000000642c1c723cULL, 0x000fec000000181cULL,
0x000000662c20723cULL, 0x000fec0000001820ULL, 0x000000682c30723cULL, 0x000fec0000001830ULL,
0x0000006a2c38723cULL, 0x002fde0000001838ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x01a6c8354d0075a7ULL, 0x000e62000800017fULL,
0x000000035a367836ULL, 0x000fc80000000000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e0036ULL,
0x0000000000600947ULL, 0x002fec0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000372e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a6c8354d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000ffff2e7224ULL, 0x000fce00078e0036ULL, 0x0000000107347836ULL, 0x000fe40000000000ULL,
0x0000000359597836ULL, 0x000fc60000000000ULL, 0x000000613400720cULL, 0x000fda0003f06070ULL,
0x0000000800080947ULL, 0x000fea0003800000ULL, 0x00008e00ff2c7b82ULL, 0x000e620000000a00ULL,
0x0000010034357824ULL, 0x000fe200078e025bULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x0000000207347836ULL, 0x000fe40000000000ULL, 0x0000000481817c24ULL, 0x010fe2000f8e02ffULL,
0x00000020352f7812ULL, 0x000fe400078ec0ffULL, 0x000000613400720cULL, 0x000fe20003f06070ULL,
0x0000004081817824ULL, 0x000fe400078e00ffULL, 0x00000001584e7824ULL, 0x000fc400078e022fULL,
0x00000080812c7825ULL, 0x002fd000078e002cULL, 0x0000000000f88947ULL, 0x000fea0003800000ULL,
0x00000035742f7248ULL, 0x000fe20007fe0000ULL, 0x0000001063347824ULL, 0x000fc800078e00ffULL,
0x000000012f2f7824ULL, 0x000fe200078e0a35ULL, 0x0000001034347812ULL, 0x000fe400078ec0ffULL,
0x00000003ff357819ULL, 0x000fe4000001160aULL, 0x0000002f342f7248ULL, 0x000fc60007fe0000ULL,
0x0000000435367836ULL, 0x000fe40000000000ULL, 0x000000012f2f7824ULL, 0x100fe400078e0a34ULL,
0x00000008354c7836ULL, 0x000fe40000000000ULL, 0x0000000c354d7836ULL, 0x000fe20000000000ULL,
0x0000002f3500720cULL, 0x0c0fe20003f86070ULL, 0x0000000135357824ULL, 0x100fe200078e0234ULL,
0x0000002f3600720cULL, 0x0c0fe20003f66070ULL, 0x0000000136377824ULL, 0x000fe200078e0234ULL,
0x0000002f4c00720cULL, 0x0c0fe20003f46070ULL, 0x0000000135367824ULL, 0x000fe200078e024eULL,
0x0000002f4d00720cULL, 0x000fe20003f06070ULL, 0x000000014c4f7824ULL, 0x000fc400078e0234ULL,
0x000000014d597824ULL, 0x000fe400078e0234ULL, 0x0000000137347824ULL, 0x040fe400078e020aULL,
0x00000008375f7824ULL, 0x040fe400078e00ffULL, 0x00000001374c7824ULL, 0x000fe400078e024eULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0xfffffff85f5f7812ULL, 0x000fc600078ee234ULL,
0x00000001352f7824ULL, 0x140fe400078e020aULL, 0x00000008355c7824ULL, 0x000fe400078e00ffULL,
0x000000014f357824ULL, 0x040fe400078e020aULL, 0x000000084f5e7824ULL, 0x000fe200078e00ffULL,
0xfffffff85c5d7812ULL, 0x000fe200078ee22fULL, 0x000000804c4c7825ULL, 0x000fc600078e00ffULL,
0xfffffff85e657812ULL, 0x000fe200078ee235ULL, 0x000000014f347824ULL, 0x100fe200078e024eULL,
0x0000006d364f7212ULL, 0x080fe200078efcffULL, 0x00000001594e7824ULL, 0x000fe200078e024eULL,
0x0000006d4c2f7212ULL, 0x000fe200078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000004f2c367210ULL, 0x000fe40007fbe0ffULL, 0x0000002f2c4c7210ULL, 0x000fe20007fde0ffULL,
0x000000804e4e7825ULL, 0x000fc800078e00ffULL, 0x00000001595c7824ULL, 0x040fe200078e020aULL,
0x0000006d4e2f7212ULL, 0x080fe200078efcffULL, 0x0000000859677824ULL, 0x000fe200078e00ffULL,
0x0000006d34597212ULL, 0x000fe200078efcffULL, 0x000000012d377824ULL, 0x040fe400028e0637ULL,
0x000000012d4d7824ULL, 0x000fe200030e064dULL, 0x000000592c347210ULL, 0x000fe20007fbe0ffULL,
0x000000105d5d7824ULL, 0x100fe200078e027eULL, 0xfffffff867677812ULL, 0x000fe200078ee25cULL,
0x000000105f5f7824ULL, 0x100fe200078e027eULL, 0x0000002f2c2c7210ULL, 0x000fe20007fde0ffULL,
0x0000001065657824ULL, 0x000fe200078e027eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000365d7faeULL, 0x0003e2000e101c46ULL, 0x000000012d357824ULL, 0x000fc400028e0635ULL,
0x0000001067677824ULL, 0x000fe200078e027eULL, 0x000000004c5f7faeULL, 0x0003e2000d901c46ULL,
0x000000012d2d7824ULL, 0x000fc600030e064fULL, 0x0000000034657faeULL, 0x0003e8000d101c46ULL,
0x000000002c677faeULL, 0x0003e2000c101c46ULL, 0x0000000000c47947ULL, 0x000fea0003800000ULL,
0x00000010632f7824ULL, 0x000fca00078e00ffULL, 0x000000102f2f7812ULL, 0x000fc800078ec0ffULL,
0x0000002f0a2f7211ULL, 0x000fca00078fe8ffULL, 0x000000012f357824ULL, 0x040fe400078e020aULL,
0x000000082f367824ULL, 0x040fe400078e00ffULL, 0x000000012f347824ULL, 0x000fe400078e024eULL,
0x000000042f377836ULL, 0x000fe20000000000ULL, 0xfffffff836597812ULL, 0x000fe200078ee235ULL,
0x000000082f4f7836ULL, 0x000fe40000000000ULL, 0x0000008034347825ULL, 0x000fc800078e00ffULL,
0x0000000c2f5d7836ULL, 0x000fe20000000000ULL, 0x0000006d342f7212ULL, 0x000fe200078efcffULL,
0x0000000137367824ULL, 0x040fe400078e024eULL, 0x00000001374d7824ULL, 0x140fe200078e020aULL,
0x0000002f2c347210ULL, 0x000fe20007f1e0ffULL, 0x00000008375c7824ULL, 0x000fe400078e00ffULL,
0x000000014f377824ULL, 0x040fe400078e020aULL, 0x000000084f5e7824ULL, 0x040fe200078e00ffULL,
0xfffffff85c2f7812ULL, 0x000fe200078ee24dULL, 0x000000014f4c7824ULL, 0x000fc400078e024eULL,
0x000000015d4f7824ULL, 0x040fe200078e020aULL, 0xfffffff85e677812ULL, 0x000fe200078ee237ULL,
0x000000085d647824ULL, 0x040fe400078e00ffULL, 0x000000015d4e7824ULL, 0x000fe400078e024eULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0xfffffff864697812ULL, 0x000fc600078ee24fULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x0000006d365d7212ULL, 0x000fc600078efcffULL,
0x000000804e4e7825ULL, 0x000fc800078e00ffULL, 0x00000010595f7824ULL, 0x100fe200078e027eULL,
0x0000006d4c597212ULL, 0x080fe200078efcffULL, 0x000000102f657824ULL, 0x100fe200078e027eULL,
0x0000006d4e2f7212ULL, 0x000fe200078efcffULL, 0x000000012d357824ULL, 0x000fe200000e0635ULL,
0x0000005d2c367210ULL, 0x000fe20007f1e0ffULL, 0x0000001067677824ULL, 0x100fe200078e027eULL,
0x000000592c4c7210ULL, 0x000fe20007f5e0ffULL, 0x0000001069697824ULL, 0x000fe200078e027eULL,
0x0000002f2c2c7210ULL, 0x000fe20007f7e0ffULL, 0x000000012d377824ULL, 0x040fe200000e0637ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000345f7faeULL, 0x0003e2000b901c46ULL,
0x000000012d4d7824ULL, 0x000fc400010e064dULL, 0x000000012d2d7824ULL, 0x000fe200018e064fULL,
0x0000000036657faeULL, 0x0003e8000b901c46ULL, 0x000000004c677faeULL, 0x0003e8000b901c46ULL,
0x000000002c697faeULL, 0x0003e4000b901c46ULL, 0x000000046e597836ULL, 0x000fe40000000000ULL,
0xffffffffff817424ULL, 0x000fc600078e00ffULL, 0x000000625900720cULL, 0x000fda0003f06070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00009000ff2c7b82ULL, 0x002e620000000a00ULL,
0x00000001082f7824ULL, 0x000fc800078e0259ULL, 0x000000042f2c7825ULL, 0x002fca00078e002cULL,
0x000000062c817981ULL, 0x000324000c1e1900ULL, 0xfffffff080807812ULL, 0x000fe200078ec0ffULL,
0x00000001ff367424ULL, 0x002fc800078e00ffULL, 0x00000009802c7c36ULL, 0x000fe20008000000ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x000000002c0472caULL, 0x000fda00000e0000ULL,
0x0001a6a804047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x01a6a8362c2c79a7ULL, 0x0002a4000850003fULL,
0x01a66836093679a7ULL, 0x0022e4000850003fULL, 0x000000ffff797224ULL, 0x006fce00078e002dULL,
0x00000000002c7805ULL, 0x000fce0000015200ULL, 0x01a66837090075a7ULL, 0x008e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x000000342c347210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e2dULL, 0x003d09003400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2f7819ULL, 0x000fc80000011435ULL,
0x000000342f2f7211ULL, 0x000fca00078110ffULL, 0x000000ffff347224ULL, 0x000fca00000e0635ULL,
0x000000022f2f7819ULL, 0x000fc80000001234ULL, 0x0000002f0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a66837090075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000092e2e7c11ULL, 0x000fe2000f8e38ffULL, 0x00000001ff347424ULL, 0x000fe400078e00ffULL,
0x000000ffff7e7224ULL, 0x000fe200078e0083ULL, 0x0000002e702e7210ULL, 0x000fca0007ffe06dULL,
0x01a000002e367984ULL, 0x000e680000000800ULL, 0x01a200002e2d7984ULL, 0x0004a20000000800ULL,
0x000000833600720bULL, 0x002fda0003f1d000ULL, 0x00000000002f7806ULL, 0x000fc800000e0100ULL,
0x000000ff2f00720cULL, 0x000fda0003f05270ULL, 0x0000000400948947ULL, 0x004fea0003800000ULL,
0x000000035a2c7836ULL, 0x000fe20000000000ULL, 0x000000833600720bULL, 0x0c0fe40003f14000ULL,
0x00000083367e7209ULL, 0x000fe40007810000ULL, 0x000000632c00720cULL, 0x000fd20003f45270ULL,
0x00000000002e7806ULL, 0x000fc800000e0100ULL, 0x00000009632cac11ULL, 0x000fe4000f8e38ffULL,
0x000000ff2e00720cULL, 0x000fe40003f05270ULL, 0x0000002c706da210ULL, 0x000fca0007ffe06dULL,
0x01a4007e6d00a388ULL, 0x0003ec0000000800ULL, 0x0000000400508947ULL, 0x000fea0003800000ULL,
0x000000837e2c7221ULL, 0x000fe20000010100ULL, 0x000000ff2eff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff002eff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b2c2c7820ULL, 0x000fe20000410000ULL,
0x00ff00002eff7812ULL, 0x040fe4000786c0ffULL, 0xff0000002eff7812ULL, 0x000fe2000788c0ffULL,
0x0000002c00357308ULL, 0x0004ec0000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff2c7819ULL, 0x004fcc000001160aULL, 0x00001f2c352c7589ULL, 0x008ea400000e0000ULL,
0x000000542c547220ULL, 0x044fe20000410000ULL, 0x000000552c557220ULL, 0x040fe20000410000ULL,
0x0000003c2c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d2c3d7220ULL, 0x040fe20000410000ULL,
0x000000402c407220ULL, 0x040fe20000410000ULL, 0x000000412c417220ULL, 0x040fe20000410000ULL,
0x000000442c447220ULL, 0x040fe20000410000ULL, 0x000000452c457220ULL, 0x040fe20000410000ULL,
0x000000482c487220ULL, 0x040fe20000410000ULL, 0x000000492c497220ULL, 0x040fe20000410000ULL,
0x000000502c507220ULL, 0x040fe20000410000ULL, 0x000000512c517220ULL, 0x040fe20000410000ULL,
0x000000282c287220ULL, 0x040fe20000410000ULL, 0x000000292c297220ULL, 0x040fe20000410000ULL,
0x000000242c247220ULL, 0x040fe20000410000ULL, 0x000000252c257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a2c7811ULL, 0x004fcc00078ff0ffULL,
0x00001f2c352c7589ULL, 0x008ea400000e0000ULL, 0x000000562c567220ULL, 0x044fe20000410000ULL,
0x000000572c577220ULL, 0x040fe20000410000ULL, 0x0000003e2c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f2c3f7220ULL, 0x040fe20000410000ULL, 0x000000422c427220ULL, 0x040fe20000410000ULL,
0x000000432c437220ULL, 0x040fe20000410000ULL, 0x000000462c467220ULL, 0x040fe20000410000ULL,
0x000000472c477220ULL, 0x040fe20000410000ULL, 0x0000004a2c4a7220ULL, 0x040fe20000410000ULL,
0x0000004b2c4b7220ULL, 0x040fe20000410000ULL, 0x000000522c527220ULL, 0x040fe20000410000ULL,
0x000000532c537220ULL, 0x040fe20000410000ULL, 0x0000002a2c2a7220ULL, 0x040fe20000410000ULL,
0x0000002b2c2b7220ULL, 0x040fe20000410000ULL, 0x000000262c267220ULL, 0x040fe20000410000ULL,
0x000000272c277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a2c7811ULL, 0x004fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x008ea400000e0000ULL,
0x0000000c2c0c7220ULL, 0x044fe20000410000ULL, 0x0000000d2c0d7220ULL, 0x040fe20000410000ULL,
0x000000102c107220ULL, 0x040fe20000410000ULL, 0x000000112c117220ULL, 0x040fe20000410000ULL,
0x000000142c147220ULL, 0x040fe20000410000ULL, 0x000000152c157220ULL, 0x040fe20000410000ULL,
0x000000182c187220ULL, 0x040fe20000410000ULL, 0x000000192c197220ULL, 0x040fe20000410000ULL,
0x0000001c2c1c7220ULL, 0x040fe20000410000ULL, 0x0000001d2c1d7220ULL, 0x040fe20000410000ULL,
0x000000202c207220ULL, 0x040fe20000410000ULL, 0x000000212c217220ULL, 0x040fe20000410000ULL,
0x000000302c307220ULL, 0x040fe20000410000ULL, 0x000000312c317220ULL, 0x040fe20000410000ULL,
0x000000382c387220ULL, 0x040fe20000410000ULL, 0x000000392c397220ULL, 0x000fce0000410000ULL,
0x0000003582827220ULL, 0x008fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a2c7811ULL, 0x004fcc00078ff0ffULL, 0x00001f2c352c7589ULL, 0x000ea400000e0000ULL,
0x0000000e2c0e7220ULL, 0x044fe20000410000ULL, 0x0000000f2c0f7220ULL, 0x040fe20000410000ULL,
0x000000122c127220ULL, 0x040fe20000410000ULL, 0x000000132c137220ULL, 0x040fe20000410000ULL,
0x000000162c167220ULL, 0x040fe20000410000ULL, 0x000000172c177220ULL, 0x040fe20000410000ULL,
0x0000001a2c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b2c1b7220ULL, 0x040fe20000410000ULL,
0x0000001e2c1e7220ULL, 0x040fe20000410000ULL, 0x0000001f2c1f7220ULL, 0x040fe20000410000ULL,
0x000000222c227220ULL, 0x040fe20000410000ULL, 0x000000232c237220ULL, 0x040fe20000410000ULL,
0x000000322c327220ULL, 0x040fe20000410000ULL, 0x000000332c337220ULL, 0x040fe20000410000ULL,
0x0000003a2c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b2c3b7220ULL, 0x000fce0000410000ULL,
0x0000002e2fff7212ULL, 0x000fe200078030ffULL, 0x00000001ff347424ULL, 0x000fd800078e00ffULL,
0x000000367e2c0221ULL, 0x004fe20000010100ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b2c2c0820ULL, 0x000fc80000410000ULL, 0x0000002c00040308ULL, 0x000ea40000000800ULL,
0x000000042d2d0220ULL, 0x004fce0000410000ULL, 0x000000822d827221ULL, 0x000fe20000010000ULL,
0x0000000160367812ULL, 0x000fce00078ec0ffULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x00000008632e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2f7812ULL, 0x000fc800078ec0ffULL,
0x01a6b0872f0075a7ULL, 0x000ea20008000149ULL, 0x000000092f377c36ULL, 0x000fe20008000000ULL,
0x00000000005c0947ULL, 0x004fec0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a6b087370075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x00000004ff2d7819ULL, 0x000fe2000001160aULL, 0x000000035a2e7836ULL, 0x000fe20000000000ULL,
0x00009910342c7816ULL, 0x000fe200000000ffULL, 0x00000004632f7824ULL, 0x000fe400078e00ffULL,
0x00000004362d7824ULL, 0x000fe200078e022dULL, 0x000000ff2c00720cULL, 0x000fe20003f05270ULL,
0x000000086c357824ULL, 0x000fe200078e00ffULL, 0x000000092e2e7c11ULL, 0x000fe2000f8e60ffULL,
0x000000016c2c7824ULL, 0x000fe200078e022dULL, 0x000000042f2f7812ULL, 0x000fe200078ec0ffULL,
0x0000000878347824ULL, 0x000fc400078e00ffULL, 0x00000001782d7824ULL, 0x000fe200078e022dULL,
0xfffffff8352c7812ULL, 0x000fe200078ee22cULL, 0x000120002e657836ULL, 0x000fe20000000000ULL,
0x000000022f7b7812ULL, 0x000fe400078efcffULL, 0xfffffff8342e7812ULL, 0x000fe200078ee22dULL,
0x000000106f2d7824ULL, 0x000fe200078e027aULL, 0x0000007b0a7b7211ULL, 0x000fe200078fe0ffULL,
0x000000102c2c7824ULL, 0x100fe400078e0265ULL, 0x000000102e2e7824ULL, 0x000fe200078e0265ULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff347819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000000ffULL, 0x0000000834027836ULL, 0x000fe20000000000ULL,
0x00005410002f7816ULL, 0x000fe20000000000ULL, 0x0000001034367836ULL, 0x000fe40000000000ULL,
0x00000018344c7836ULL, 0x000fe40000000000ULL, 0x00001f022f027589ULL, 0x0004e800000e0000ULL,
0x00001f362f057589ULL, 0x00046800000e0000ULL, 0x00001f342f037589ULL, 0x00046800000e0000ULL,
0x00001f4c2f007589ULL, 0x00046400000e0000ULL, 0x000000002c5c783bULL, 0x000ae80000000200ULL,
0x000000002e34783bULL, 0x0044620000000200ULL, 0x0000000000200947ULL, 0x020fea0003800000ULL,
0x000000035c5c7232ULL, 0x08afe40000000000ULL, 0x000000035e5e7232ULL, 0x000fe40000000000ULL,
0x000000025d5d7232ULL, 0x080fe40000000000ULL, 0x000000025f5f7232ULL, 0x000fe40000000000ULL,
0x0000000534347232ULL, 0x080fe40000000000ULL, 0x0000000536367232ULL, 0x000fc40000000000ULL,
0x0000000035357232ULL, 0x080fe40000000000ULL, 0x0000000037377232ULL, 0x000fce0000000000ULL,
0x000000086c4d7824ULL, 0x040fe200078e00ffULL, 0x000000002d2c783bULL, 0x004ea20000004200ULL,
0x000000016c6c7824ULL, 0x000fe400078e027bULL, 0x0000001072707824ULL, 0x100fe400078e0265ULL,
0x00000010716e7824ULL, 0x000fe200078e0265ULL, 0xfffffff84d4d7812ULL, 0x000fca00078ee26cULL,
0x000000104d4d7824ULL, 0x000fcc00078e027aULL, 0x000000004d4c783bULL, 0x000f620000004200ULL,
0x00000018ff697819ULL, 0x104fe4000001162dULL, 0x000000ff2f6c7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff877819ULL, 0x000fe4000001162dULL, 0x000000ff2d837812ULL, 0x040fe400078ec0ffULL,
0x0000ffff2d8b7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff867819ULL, 0x000fc4000001162cULL,
0x00000010ff847819ULL, 0x100fe4000001162eULL, 0x000000ff2e6b7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6a7819ULL, 0x000fe4000001162eULL, 0x00000010ff667819ULL, 0x128fe4000001164cULL,
0x000000ff4c6d7812ULL, 0x002fe400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fc4000001164cULL,
0x0000ffff4c687812ULL, 0x000fe400078ec0ffULL, 0x000000ff4d727812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4c7819ULL, 0x100fe4000001164fULL, 0x000000ff4f897812ULL, 0x040fe400078ec0ffULL,
0x00000018ff887819ULL, 0x000fe4000001164fULL, 0x0000ffff4f2d7812ULL, 0x000fc400078ec0ffULL,
0x00000018ff737819ULL, 0x000fe4000001164eULL, 0x00000069ff4f723eULL, 0x000fe400020006ffULL,
0x0000006cff69723eULL, 0x000fe400020006ffULL, 0x0000006dff6c723eULL, 0x000fe400020006ffULL,
0x0000ffff2e647812ULL, 0x000fe400078ec0ffULL, 0x00000072ff6d723eULL, 0x000fc400020006ffULL,
0x00000010ff857819ULL, 0x100fe4000001162fULL, 0x00000018ff2e7819ULL, 0x000fe4000001162fULL,
0x00000073ff72723eULL, 0x000fe400020006ffULL, 0x000000ff2c807812ULL, 0x040fe400078ec0ffULL,
0x00000018ff7f7819ULL, 0x000fe4000001162cULL, 0x0000ffff2c8a7812ULL, 0x000fc400078ec0ffULL,
0x0000ffff2f657812ULL, 0x000fe400078ec0ffULL, 0x00000088ff73723eULL, 0x000fe400020006ffULL,
0x00000018ff717819ULL, 0x000fe4000001164dULL, 0x00000010ff2f7819ULL, 0x000fe4000001164eULL,
0x000000ff4e7d7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4e2c7812ULL, 0x000fc400078ec0ffULL,
0x000000ff86867812ULL, 0x000fe400078ec0ffULL, 0x000000ff87887812ULL, 0x000fe400078ec0ffULL,
0x0000006bff4e723eULL, 0x000fe400020006ffULL, 0x0000002eff6b723eULL, 0x000fe400020006ffULL,
0x000000ff85857812ULL, 0x000fe400078ec0ffULL, 0x0000006fff2e723eULL, 0x000fc400020006ffULL,
0x00000008ff647819ULL, 0x000fe40000011664ULL, 0x00000008ff657819ULL, 0x000fe40000011665ULL,
0x00000080ff80723eULL, 0x000fe400020006ffULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000071ff6f723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fc400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000010ff677819ULL, 0x000fe4000001164dULL,
0x00000089ff71723eULL, 0x000fe400020006ffULL, 0x00000008ff877819ULL, 0x000fe4000001168aULL,
0x00000008ff897819ULL, 0x000fe4000001168bULL, 0x00000085ff8a723eULL, 0x000fc400020006ffULL,
0x000000ff84847812ULL, 0x000fe400078ec0ffULL, 0x00000064ff85723eULL, 0x000fe400020006ffULL,
0x00000065ff8b723eULL, 0x000fe400020006ffULL, 0x0000541080647816ULL, 0x000fe40000000086ULL,
0x0000541083657816ULL, 0x000fe40000000088ULL, 0x0000007fff7f723eULL, 0x000fc400020006ffULL,
0x00000087ff87723eULL, 0x000fe400020006ffULL, 0x000000ff66807812ULL, 0x000fe200078ec0ffULL,
0x00000064340c723cULL, 0x000fe2000000180cULL, 0x000000ff67837812ULL, 0x000fe400078ec0ffULL,
0x0000ffff4d4d7812ULL, 0x000fe400078ec0ffULL, 0x00000008ff687819ULL, 0x000fe20000011668ULL,
0x000000645c54723cULL, 0x000fe20000001854ULL, 0x00000084ff84723eULL, 0x000fc400020006ffULL,
0x0000541087667816ULL, 0x000fe4000000007fULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x00000083ff83723eULL, 0x000fe400020006ffULL, 0x00000068ff7f723eULL, 0x000fe400020006ffULL,
0x00000008ff4d7819ULL, 0x000fe4000001164dULL, 0x000054104e687816ULL, 0x000fc40000000084ULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x000000ff2f4e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL, 0x00000089ff89723eULL, 0x000fe400020006ffULL,
0x000054106c6c7816ULL, 0x000fe40000000080ULL, 0x000054106d6d7816ULL, 0x000fc40000000083ULL,
0x0000004dff2f723eULL, 0x000fe400020006ffULL, 0x00000008ff807819ULL, 0x000fe4000001162cULL,
0x00000008ff837819ULL, 0x000fe2000001162dULL, 0x0000006c341c723cULL, 0x000fe2000000181cULL,
0x00005410856a7816ULL, 0x000fe4000000006aULL, 0x0000007dff7d723eULL, 0x000fe400020006ffULL,
0x0000541089677816ULL, 0x000fe2000000004fULL, 0x0000006c5c48723cULL, 0x000fe20000001848ULL,
0x0000004eff84723eULL, 0x000fc400020006ffULL, 0x0000004cff85723eULL, 0x000fe400020006ffULL,
0x000000006e4c783bULL, 0x0002a20000000200ULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x000000663410723cULL, 0x000fe20000001810ULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x000054102f6f7816ULL, 0x000fe4000000006fULL, 0x0000541069697816ULL, 0x000fe2000000008aULL,
0x000000665c3c723cULL, 0x000fe2000000183cULL, 0x000054107f6e7816ULL, 0x002fc4000000002eULL,
0x00000000702c783bULL, 0x0002a20000000200ULL, 0x000054108b6b7816ULL, 0x000fe4000000006bULL,
0x0000541071717816ULL, 0x000fe20000000085ULL, 0x000000683414723cULL, 0x000fe20000001814ULL,
0x0000541080727816ULL, 0x000fe40000000072ULL, 0x0000541083737816ULL, 0x000fe40000000073ULL,
0x000054107d707816ULL, 0x002fe20000000084ULL, 0x0000006a3418723cULL, 0x000fec0000001818ULL,
0x0000006e3420723cULL, 0x000fec0000001820ULL, 0x000000703430723cULL, 0x000fec0000001830ULL,
0x000000685c40723cULL, 0x000fec0000001840ULL, 0x0000006a5c44723cULL, 0x000fec0000001844ULL,
0x0000006e5c50723cULL, 0x000fec0000001850ULL, 0x000000705c28723cULL, 0x000fec0000001828ULL,
0x000000725c24723cULL, 0x000fec0000001824ULL, 0x000000723434723cULL, 0x000fe20000001838ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000200947ULL, 0x004fde0003800000ULL,
0x000000034c4c7232ULL, 0x080fe40000000000ULL, 0x000000034e4e7232ULL, 0x000fe40000000000ULL,
0x000000024d4d7232ULL, 0x080fe40000000000ULL, 0x000000024f4f7232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x080fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x000000007c5c783bULL, 0x000e620000004200ULL, 0x00000001787b7824ULL, 0x040fe400078e027bULL,
0x0000000878787824ULL, 0x000fe400078e00ffULL, 0x0000000107077836ULL, 0x000fc60000000000ULL,
0xfffffff8787b7812ULL, 0x000fca00078ee27bULL, 0x000000107b387824ULL, 0x000fe200078e027aULL,
0x00000010ff397819ULL, 0x002fe4000001165cULL, 0x00000010ff3b7819ULL, 0x000fe4000001165dULL,
0x000000ff5d647812ULL, 0x000fe400078ec0ffULL, 0x000000ff5c3a7812ULL, 0x000fe400078ec0ffULL,
0x000000ff39397812ULL, 0x000fe400078ec0ffULL, 0x000000ff3b3b7812ULL, 0x000fc400078ec0ffULL,
0x00000064ff65723eULL, 0x000fe400020006ffULL, 0x0000003aff3a723eULL, 0x000fe400020006ffULL,
0x00000039ff39723eULL, 0x000fe400020006ffULL, 0x0000003bff3b723eULL, 0x000fe400020006ffULL,
0x0000ffff5c647812ULL, 0x000fe400078ec0ffULL, 0x0000ffff5d687812ULL, 0x000fc400078ec0ffULL,
0x00000018ff677819ULL, 0x000fe4000001165dULL, 0x00000008ff5d7819ULL, 0x000fe40000011664ULL,
0x000054103a647816ULL, 0x000fe40000000039ULL, 0x0000541065657816ULL, 0x000fe4000000003bULL,
0x000000003838783bULL, 0x000e620000004200ULL, 0x00000018ff5c7819ULL, 0x000fe4000001165cULL,
0x00000008ff687819ULL, 0x000fc40000011668ULL, 0x0000005cff66723eULL, 0x000fe200020006ffULL,
0x000000644c54723cULL, 0x000fe20000001854ULL, 0x0000005dff5c723eULL, 0x000fe400020006ffULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x00000068ff5d723eULL, 0x000fe200020006ffULL,
0x000000642c0c723cULL, 0x000fe2000000180cULL, 0x000054105c5c7816ULL, 0x000fe40000000066ULL,
0x000054105d5d7816ULL, 0x000fc40000000067ULL, 0x000000ff5e687812ULL, 0x040fe400078ec0ffULL,
0x00000010ff647819ULL, 0x100fe4000001165eULL, 0x00000018ff657819ULL, 0x000fe2000001165eULL,
0x0000005c4c3c723cULL, 0x000fe2000000183cULL, 0x0000ffff5e6b7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff5e7819ULL, 0x100fe4000001165fULL, 0x000000ff5f697812ULL, 0x000fe200078ec0ffULL,
0x0000005c2c10723cULL, 0x000fe20000001810ULL, 0x00000018ff6a7819ULL, 0x000fc4000001165fULL,
0x0000ffff5f5f7812ULL, 0x000fe400078ec0ffULL, 0x000000ff64647812ULL, 0x000fe400078ec0ffULL,
0x00000008ff5c7819ULL, 0x000fe4000001166bULL, 0x00000008ff5d7819ULL, 0x000fe4000001165fULL,
0x000000ff5e5e7812ULL, 0x000fe400078ec0ffULL, 0x00000065ff65723eULL, 0x000fc400020006ffULL,
0x0000006aff6a723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000005dff5d723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000069ff69723eULL, 0x000fe400020006ffULL, 0x00000064ff64723eULL, 0x000fc400020006ffULL,
0x0000005eff5e723eULL, 0x000fe400020006ffULL, 0x000054105c5c7816ULL, 0x000fe40000000065ULL,
0x000054105d5d7816ULL, 0x000fe4000000006aULL, 0x0000541068687816ULL, 0x000fe40000000064ULL,
0x0000541069697816ULL, 0x000fe4000000005eULL, 0x00000010ff5f7819ULL, 0x002fe20000011639ULL,
0x0000005c4c44723cULL, 0x000fe20000001844ULL, 0x000000ff39657812ULL, 0x000fc400078ec0ffULL,
0x00000018ff647819ULL, 0x000fe40000011639ULL, 0x0000ffff396d7812ULL, 0x000fe200078ec0ffULL,
0x0000005c2c18723cULL, 0x000fe20000001818ULL, 0x00000018ff397819ULL, 0x100fe4000001163aULL,
0x0000ffff386c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff667819ULL, 0x000fe2000001163aULL,
0x000000684c40723cULL, 0x000fe20000001840ULL, 0x00000010ff5c7819ULL, 0x000fc40000011638ULL,
0x000000ff3a677812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3a6e7812ULL, 0x000fe200078ec0ffULL,
0x000000682c14723cULL, 0x000fe20000001814ULL, 0x00000018ff6a7819ULL, 0x100fe4000001163bULL,
0x000000ff3b3a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff3b6f7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff697819ULL, 0x000fc4000001163bULL, 0x00000039ff68723eULL, 0x000fe400020006ffULL,
0x00000018ff5d7819ULL, 0x000fe40000011638ULL, 0x00000008ff397819ULL, 0x000fe4000001166cULL,
0x00000008ff3b7819ULL, 0x000fe4000001166dULL, 0x000000ff385e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff5c5c7812ULL, 0x000fc400078ec0ffULL, 0x000000ff5f5f7812ULL, 0x000fe400078ec0ffULL,
0x0000003aff6b723eULL, 0x000fe400020006ffULL, 0x0000005dff5d723eULL, 0x000fe400020006ffULL,
0x00000064ff64723eULL, 0x000fe400020006ffULL, 0x00000039ff3a723eULL, 0x000fe400020006ffULL,
0x0000003bff3b723eULL, 0x000fc400020006ffULL, 0x0000005eff38723eULL, 0x000fe400020006ffULL,
0x00000065ff65723eULL, 0x000fe400020006ffULL, 0x0000005cff5c723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe400020006ffULL, 0x000054103a3a7816ULL, 0x000fe4000000005dULL,
0x000054103b3b7816ULL, 0x000fc40000000064ULL, 0x000000ff66667812ULL, 0x000fe400078ec0ffULL,
0x000000ff69697812ULL, 0x000fe400078ec0ffULL, 0x0000541038387816ULL, 0x000fe2000000005cULL,
0x0000003a4c50723cULL, 0x000fe20000001850ULL, 0x0000541065397816ULL, 0x000fe4000000005fULL,
0x00000008ff5c7819ULL, 0x000fe4000001166eULL, 0x00000008ff5f7819ULL, 0x000fe2000001166fULL,
0x0000003a2c20723cULL, 0x000fe20000001820ULL, 0x00000067ff67723eULL, 0x000fc400020006ffULL,
0x00000066ff66723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe200020006ffULL,
0x000000384c48723cULL, 0x000fe20000001848ULL, 0x0000006aff6a723eULL, 0x000fe200020006ffULL,
0x00000001ff3b7424ULL, 0x000fe200078e00ffULL, 0x0000005cff5e723eULL, 0x000fe400020006ffULL,
0x0000005fff5f723eULL, 0x000fe200020006ffULL, 0x000000382c1c723cULL, 0x000fe2000000181cULL,
0x00005410675c7816ULL, 0x000fe20000000066ULL, 0x0000003b063879a7ULL, 0x0002e2000850003fULL,
0x000054106b5d7816ULL, 0x000fc40000000069ULL, 0x000054105e5e7816ULL, 0x000fe40000000068ULL,
0x000054105f5f7816ULL, 0x000fc6000000006aULL, 0x0000005c2c30723cULL, 0x000fe20000001830ULL,
0x000000095a067c11ULL, 0x002fca000f8e18ffULL, 0x0000005c4c28723cULL, 0x000fe20000001828ULL,
0x01a6a03b06ff79a7ULL, 0x0007ea000850003fULL, 0x0000005e4c24723cULL, 0x000fec0000001824ULL,
0x0000005e2c2c723cULL, 0x000fe20000001834ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffff5c00f09947ULL, 0x00cfde000383ffffULL, 0x000000ff6100720cULL, 0x000fda0003f05270ULL,
0x0000000400648947ULL, 0x000fea0003800000ULL, 0x0180000082007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000bea000047802ULL, 0x000fce0000000f00ULL, 0x000000a800547944ULL, 0x01efea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000008200037308ULL, 0x008ee40000001000ULL,
0xbf80000003007423ULL, 0x008fc80000000082ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009800ff027b82ULL, 0x000f640000000a00ULL, 0x0000000602037981ULL, 0x02aee2000c1e9900ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000001805077811ULL, 0x042fe400078ff0ffULL,
0x00000002ff097819ULL, 0x000fe40000011605ULL, 0x0000000805357811ULL, 0x040fe400078ff0ffULL,
0x0000001005377811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x00cfca0000410000ULL,
0x00001f0900047589ULL, 0x000e6800000e0000ULL, 0x00001f3500067589ULL, 0x000ea800000e0000ULL,
0x00001f3700057589ULL, 0x000ee800000e0000ULL, 0x00001f0700077589ULL, 0x000f6200000e0000ULL,
0x0000005404547220ULL, 0x042fe20000410000ULL, 0x0000005504557220ULL, 0x040fe20000410000ULL,
0x0000003c043c7220ULL, 0x040fe20000410000ULL, 0x0000003d043d7220ULL, 0x040fe20000410000ULL,
0x0000004004407220ULL, 0x040fe20000410000ULL, 0x0000004104417220ULL, 0x040fe20000410000ULL,
0x0000004404447220ULL, 0x040fe20000410000ULL, 0x0000004504457220ULL, 0x040fe20000410000ULL,
0x0000004804487220ULL, 0x040fe20000410000ULL, 0x0000004904497220ULL, 0x040fe20000410000ULL,
0x0000005004507220ULL, 0x040fe20000410000ULL, 0x0000005104517220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x000fe20000410000ULL,
0x0000005606567220ULL, 0x044fe20000410000ULL, 0x0000005706577220ULL, 0x040fe20000410000ULL,
0x0000003e063e7220ULL, 0x040fe20000410000ULL, 0x0000003f063f7220ULL, 0x040fe20000410000ULL,
0x0000004206427220ULL, 0x040fe20000410000ULL, 0x0000004306437220ULL, 0x040fe20000410000ULL,
0x0000004606467220ULL, 0x040fe20000410000ULL, 0x0000004706477220ULL, 0x040fe20000410000ULL,
0x0000004a064a7220ULL, 0x040fe20000410000ULL, 0x0000004b064b7220ULL, 0x040fe20000410000ULL,
0x0000005206527220ULL, 0x040fe20000410000ULL, 0x0000005306537220ULL, 0x040fe20000410000ULL,
0x0000002a062a7220ULL, 0x040fe20000410000ULL, 0x0000002b062b7220ULL, 0x040fe20000410000ULL,
0x0000002606267220ULL, 0x040fe20000410000ULL, 0x0000002706277220ULL, 0x000fe20000410000ULL,
0x0000000c050c7220ULL, 0x048fe20000410000ULL, 0x0000000d050d7220ULL, 0x040fe20000410000ULL,
0x0000001005107220ULL, 0x040fe20000410000ULL, 0x0000001105117220ULL, 0x040fe20000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x0000001505157220ULL, 0x040fe20000410000ULL,
0x0000001805187220ULL, 0x040fe20000410000ULL, 0x0000001905197220ULL, 0x040fe20000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x0000001d051d7220ULL, 0x040fe20000410000ULL,
0x0000002005207220ULL, 0x040fe20000410000ULL, 0x0000002105217220ULL, 0x040fe20000410000ULL,
0x0000003005307220ULL, 0x040fe20000410000ULL, 0x0000003105317220ULL, 0x040fe20000410000ULL,
0x0000002c052c7220ULL, 0x040fe20000410000ULL, 0x0000002d052d7220ULL, 0x000fe20000410000ULL,
0x0000000e070e7220ULL, 0x060fe20000410000ULL, 0x0000000f070f7220ULL, 0x040fe20000410000ULL,
0x0000001207127220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000001607167220ULL, 0x040fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001b071b7220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000003207327220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x040fe20000410000ULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0x0000002f072f7220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000f620000000000ULL, 0x0000000163637812ULL, 0x000fe400078ec0ffULL,
0x000000484948723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000505150723eULL, 0x000fc400000000ffULL, 0x000000282928723eULL, 0x000fe400000000ffULL,
0x000000242524723eULL, 0x000fe400000000ffULL, 0x000000565757723eULL, 0x000fe400000000ffULL,
0x0000003e3f3e723eULL, 0x000fe400000000ffULL, 0x000000424342723eULL, 0x000fe400000000ffULL,
0x000000464746723eULL, 0x000fc400000000ffULL, 0x0000004a4b4a723eULL, 0x000fe400000000ffULL,
0x000000525325723eULL, 0x000fe400000000ffULL, 0x0000541057567816ULL, 0x000fe4000000003eULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x0000000800057811ULL, 0x062fe400078ff0ffULL,
0x0000000200027812ULL, 0x008fc400078ec0ffULL, 0x0000001800097811ULL, 0x000fe200078ff0ffULL,
0x0000000805367824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x000fe400078ff8ffULL,
0x0000001000057811ULL, 0x000fe200078ff0ffULL, 0x00000008093a7824ULL, 0x000fe200078e00ffULL,
0x00000002ff077819ULL, 0x000fe40000011600ULL, 0xfffffff836367812ULL, 0x000fe200078ee203ULL,
0x0000000805387824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x040fe200078ff8ffULL,
0x0000000807347824ULL, 0x000fe200078e00ffULL, 0x0000000702047211ULL, 0x000fc400078ff8ffULL,
0x0000000902057211ULL, 0x000fe200078ff8ffULL, 0x0000000807097824ULL, 0x040fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee203ULL, 0x0000000204027836ULL, 0x000fe20000000000ULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee205ULL, 0x0000000807057824ULL, 0x000fe200078e00ffULL,
0x0000000963037c11ULL, 0x000fe2000f8e68ffULL, 0x0000000404067836ULL, 0x000fe20000000000ULL,
0xfffffff809087812ULL, 0x000fe200078ee202ULL, 0x0000000604077836ULL, 0x000fe20000000000ULL,
0xfffffff805027812ULL, 0x000fe200078ee204ULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff8090a7812ULL, 0x000fe200078ee206ULL, 0x0000100060057824ULL, 0x000fe200078e0203ULL,
0xfffffff834347812ULL, 0x000fc400078ee207ULL, 0x0000000804077812ULL, 0x000fe200078ec0ffULL,
0x0000001002067824ULL, 0x100fe200078e0205ULL, 0x000000545502723eULL, 0x000fe200000000ffULL,
0x0000001036367824ULL, 0x000fe200078e0205ULL, 0x0000003c3d04723eULL, 0x000fe200000000ffULL,
0x0000000106067824ULL, 0x000fe200078e0207ULL, 0x000000262726723eULL, 0x000fe200000000ffULL,
0x0000001038387824ULL, 0x100fe200078e0205ULL, 0x00005410023c7816ULL, 0x100fe20000000004ULL,
0x000000103a3a7824ULL, 0x100fe200078e0205ULL, 0x00007632023d7816ULL, 0x000fe20000000004ULL,
0x0000001008087824ULL, 0x100fe200078e0205ULL, 0x000000404102723eULL, 0x000fe200000000ffULL,
0x000000100a0a7824ULL, 0x100fe200078e0205ULL, 0x000000444504723eULL, 0x000fe200000000ffULL,
0x0000001034347824ULL, 0x000fe200078e0205ULL, 0x0000003c06007388ULL, 0x0003e20000000a00ULL,
0x0000000107367824ULL, 0x000fe200078e0236ULL, 0x0000763257577816ULL, 0x000fe2000000003eULL,
0x0000000107387824ULL, 0x040fe200078e0238ULL, 0x0000763242297816ULL, 0x000fe20000000046ULL,
0x00000001073a7824ULL, 0x000fe200078e023aULL, 0x0000000c0d0c723eULL, 0x000fe200000000ffULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0x000000141514723eULL, 0x000fe200000000ffULL,
0x0000000107057824ULL, 0x000fe200078e020aULL, 0x00000018190a723eULL, 0x000fe200000000ffULL,
0x0000000107347824ULL, 0x000fe200078e0234ULL, 0x0000541002067816ULL, 0x002fc40000000004ULL,
0x0000763202077816ULL, 0x000fe20000000004ULL, 0x000000015b027824ULL, 0x000fe200078e0200ULL,
0x00007632140d7816ULL, 0x000fe4000000000aULL, 0x0000001c1d1c723eULL, 0x000fe200000000ffULL,
0x0000000608007388ULL, 0x0003e20000000a00ULL, 0x000000202120723eULL, 0x000fe200000000ffULL,
0x0000001002027824ULL, 0x000fe200078e0203ULL, 0x000000303130723eULL, 0x000fe400000000ffULL,
0x0000002c2d18723eULL, 0x000fc400000000ffULL, 0x0000000e0f0e723eULL, 0x000fe400000000ffULL,
0x000000161716723eULL, 0x000fe400000000ffULL, 0x0000001a1b1a723eULL, 0x000fe400000000ffULL,
0x0000541048067816ULL, 0x142fe40000000050ULL, 0x0000763248077816ULL, 0x000fe40000000050ULL,
0x0000001e1f1e723eULL, 0x000fc400000000ffULL, 0x00000022230f723eULL, 0x000fe200000000ffULL,
0x0000000605007388ULL, 0x0003e20000000a00ULL, 0x000000323332723eULL, 0x000fe400000000ffULL,
0x0000002e2f19723eULL, 0x000fe400000000ffULL, 0x000000ff6000720cULL, 0x000fe40003f05270ULL,
0x0000763232097816ULL, 0x000fe40000000019ULL, 0x0000541028067816ULL, 0x002fc40000000024ULL,
0x0000763228077816ULL, 0x000fe40000000024ULL, 0x0000541042287816ULL, 0x000fe40000000046ULL,
0x000054104a247816ULL, 0x140fe20000000025ULL, 0x0000000634007388ULL, 0x0003e20000000a00ULL,
0x000076324a257816ULL, 0x000fc60000000025ULL, 0x0000005636007388ULL, 0x000fe80000000a00ULL,
0x0004002808007388ULL, 0x000fe20000000a00ULL, 0x000000101106723eULL, 0x002fc600000000ffULL,
0x0004002405007388ULL, 0x000fe20000000a00ULL, 0x000054102a107816ULL, 0x140fe40000000026ULL,
0x000076322a117816ULL, 0x000fe40000000026ULL, 0x000000121307723eULL, 0x000fc600000000ffULL,
0x0004001034007388ULL, 0x0003e40000000a00ULL, 0x000054100c107816ULL, 0x142fe40000000006ULL,
0x000076320c117816ULL, 0x000fe40000000006ULL, 0x00005410140c7816ULL, 0x000fe4000000000aULL,
0x000054100e067816ULL, 0x140fe20000000007ULL, 0x0000001038007388ULL, 0x000fe20000000a00ULL,
0x000076320e077816ULL, 0x000fc60000000007ULL, 0x0008000c08007388ULL, 0x0003e40000000a00ULL,
0x000054101c0c7816ULL, 0x142fe40000000020ULL, 0x000076321c0d7816ULL, 0x000fca0000000020ULL,
0x0008000c05007388ULL, 0x0003e40000000a00ULL, 0x00005410300c7816ULL, 0x142fe40000000018ULL,
0x00007632300d7816ULL, 0x000fca0000000018ULL, 0x0008000c34007388ULL, 0x000fe80000000a00ULL,
0x000000063a007388ULL, 0x0003e40000000a00ULL, 0x0000541016067816ULL, 0x142fe4000000001aULL,
0x0000763216077816ULL, 0x000fca000000001aULL, 0x000c000608007388ULL, 0x0003e40000000a00ULL,
0x000054101e067816ULL, 0x142fe4000000000fULL, 0x000076321e077816ULL, 0x000fe4000000000fULL,
0x0000541032087816ULL, 0x000fc60000000019ULL, 0x000c000605007388ULL, 0x000fe80000000a00ULL,
0x000c000834007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000020c7984ULL, 0x000e680000000c00ULL, 0x0004000002147984ULL, 0x000ee80000000c00ULL,
0x00080000021c7984ULL, 0x000f680000000c00ULL, 0x000c000002047984ULL, 0x000f680000000c00ULL,
0x0010000002107984ULL, 0x000f680000000c00ULL, 0x0014000002187984ULL, 0x000f680000000c00ULL,
0x0018000002207984ULL, 0x000f680000000c00ULL, 0x001c000002247984ULL, 0x000f620000000c00ULL,
0x200000ff0f0f7230ULL, 0x002fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff17177230ULL, 0x008fe40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fc40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x024fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fe40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff07077230ULL, 0x000fc40000000000ULL, 0x200000ff06067230ULL, 0x000fe40000000000ULL,
0x200000ff05057230ULL, 0x000fe40000000000ULL, 0x200000ff04047230ULL, 0x000fe40000000000ULL,
0x000000130f0f7230ULL, 0x000fe40000000000ULL, 0x000000120e0e7230ULL, 0x000fe40000000000ULL,
0x000000110d0d7230ULL, 0x000fc40000000000ULL, 0x000000100c0c7230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x000fe40000000000ULL, 0x0000001a16167230ULL, 0x000fe20000000000ULL,
0x0000000c02007388ULL, 0x0003e20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fe40000000000ULL, 0x000000231f1f7230ULL, 0x000fc40000000000ULL,
0x000000221e1e7230ULL, 0x000fe20000000000ULL, 0x0004001402007388ULL, 0x0003e20000000c00ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fe40000000000ULL,
0x0000002707077230ULL, 0x000fe40000000000ULL, 0x0000002606067230ULL, 0x000fe20000000000ULL,
0x0008001c02007388ULL, 0x0003e20000000c00ULL, 0x0000002505057230ULL, 0x000fc40000000000ULL,
0x0000002404047230ULL, 0x000fca0000000000ULL, 0x000c000402007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ea20000002700ULL, 0x00000003ff047819ULL, 0x002fe20000011600ULL,
0x0000840000057ab9ULL, 0x000fc60000000800ULL, 0x000000750400720cULL, 0x000fe20003f06070ULL,
0x00000005040472a4ULL, 0x004fd8000f8e023fULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000104027824ULL, 0x000fe200078e0200ULL, 0x00008600000a7ab9ULL, 0x000fe20000000800ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x0000880000087ab9ULL, 0x000fe20000000a00ULL,
0x0000000a05057299ULL, 0x000fe2000800063fULL, 0x0000000702057812ULL, 0x000fe400078ec0ffULL,
0x00000007000a7812ULL, 0x000fe400078ec0ffULL, 0x0ffffff805027812ULL, 0x000fc600078ef800ULL,
0x0000000863077824ULL, 0x000fe400078e020aULL, 0x0000001002067824ULL, 0x000fe400078e0203ULL,
0x0000002077027824ULL, 0x000fc600078e0204ULL, 0x00000000060c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff047c19ULL, 0x000fe20008011602ULL,
0x000000040b027c24ULL, 0x000fe4000f8e02ffULL, 0x0000000176057824ULL, 0x000fe400078e0205ULL,
0x0000002000067836ULL, 0x002fe40000000000ULL, 0x0000000b04057224ULL, 0x000fca00078e0205ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe400080f4408ULL,
0x00000003ff087819ULL, 0x000fe20000011606ULL, 0x0000001007047825ULL, 0x000fc600078e0004ULL,
0x000000750800720cULL, 0x000fe40003f06070ULL, 0x0000000c04007986ULL, 0x0043f6000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x102fe400078e0208ULL,
0x0000002077087824ULL, 0x000fc600078e0208ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef806ULL, 0x0000000508057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff087c19ULL, 0x000fe20008011608ULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x0000000176057824ULL, 0x000fc600078e0205ULL,
0x00000000070c7984ULL, 0x0002a20000000c00ULL, 0x0000000b08057224ULL, 0x000fca00078e0205ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x0000000863077824ULL, 0x002fc800078e0206ULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe200080f4408ULL, 0x0000004000087836ULL, 0x000fe40000000000ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x00000003ff067819ULL, 0x000fc80000011608ULL,
0x000000750600720cULL, 0x000fe20003f06070ULL, 0x0000000c04007986ULL, 0x0043d8000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000108047824ULL, 0x102fe400078e0206ULL,
0x0000002077067824ULL, 0x000fc600078e0206ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef808ULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff067c19ULL, 0x000fe20008011606ULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x0000000708087812ULL, 0x000fe200078ec0ffULL, 0x0000000176057824ULL, 0x000fc600078e0205ULL,
0x00000000070c7984ULL, 0x0002a20000000c00ULL, 0x0000000b06057224ULL, 0x000fca00078e0205ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x0000000863077824ULL, 0x002fc800078e0208ULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe200080f4406ULL, 0x0000006000067836ULL, 0x000fe40000000000ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x00000003ff087819ULL, 0x000fc80000011606ULL,
0x000000750800720cULL, 0x000fe20003f06070ULL, 0x0000000c04007986ULL, 0x0043d8000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x102fe400078e0208ULL,
0x0000002077087824ULL, 0x000fc600078e0208ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef806ULL, 0x0000000508057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff087c19ULL, 0x000fe20008011608ULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x0000000176057824ULL, 0x000fc600078e0205ULL,
0x00000000070c7984ULL, 0x0002a20000000c00ULL, 0x0000000b08057224ULL, 0x000fca00078e0205ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x0000000863077824ULL, 0x002fc800078e0206ULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe200080f4408ULL, 0x0000008000087836ULL, 0x000fe40000000000ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x00000003ff067819ULL, 0x000fc80000011608ULL,
0x000000750600720cULL, 0x000fe20003f06070ULL, 0x0000000c04007986ULL, 0x0043d8000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000108047824ULL, 0x102fe400078e0206ULL,
0x0000002077067824ULL, 0x000fc600078e0206ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef808ULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff067c19ULL, 0x000fe20008011606ULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x0000000708087812ULL, 0x000fe200078ec0ffULL, 0x0000000176057824ULL, 0x000fc600078e0205ULL,
0x00000000070c7984ULL, 0x0002a20000000c00ULL, 0x0000000b06057224ULL, 0x000fca00078e0205ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x0000000863077824ULL, 0x002fc800078e0208ULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe200080f4406ULL, 0x000000a000067836ULL, 0x000fe40000000000ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x00000003ff087819ULL, 0x000fc80000011606ULL,
0x000000750800720cULL, 0x000fe20003f06070ULL, 0x0000000c04007986ULL, 0x0043d8000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x102fe400078e0208ULL,
0x0000002077087824ULL, 0x000fc600078e0208ULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef806ULL, 0x0000000508057c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff087c19ULL, 0x000fe20008011608ULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x0000000176057824ULL, 0x000fc600078e0205ULL,
0x00000000070c7984ULL, 0x0002a20000000c00ULL, 0x0000000b08057224ULL, 0x000fca00078e0205ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x0000000863077824ULL, 0x002fc800078e0206ULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe200080f4408ULL, 0x000000c000087836ULL, 0x000fe40000000000ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x00000003ff067819ULL, 0x000fc80000011608ULL,
0x000000750600720cULL, 0x000fe20003f06070ULL, 0x0000000c04007986ULL, 0x0043d8000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000108047824ULL, 0x102fe400078e0206ULL,
0x0000002077067824ULL, 0x000fe400078e0206ULL, 0x000000e000007836ULL, 0x000fe20000000000ULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef808ULL,
0x0000000506057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff067c19ULL, 0x000fe20008011606ULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x0000000176057824ULL, 0x000fc600078e0205ULL, 0x00000000070c7984ULL, 0x0002a20000000c00ULL,
0x0000000b06057224ULL, 0x000fe200078e0205ULL, 0x00000003ff067819ULL, 0x000fc80000011600ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x0000000100097824ULL, 0x000fe400078e0206ULL,
0x0000000863077824ULL, 0x002fe400078e0208ULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fe4000f8040ffULL, 0x0000000709097812ULL, 0x000fe400078ec0ffULL,
0x0000000905057c11ULL, 0x000fc400080f440aULL, 0x000000750600720cULL, 0x000fe40003f06070ULL,
0xfffffff809087812ULL, 0x000fe200078ef800ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0043ea000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001008087824ULL, 0x000fe200078e0203ULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x0000002077067824ULL, 0x000fc600078e0206ULL, 0x00000000080c7984ULL, 0x002e620000000c00ULL,
0x0000000863637824ULL, 0x000fe200078e0200ULL, 0x0000000506037c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff067c19ULL, 0x000fc60008011606ULL, 0x0000000176037824ULL, 0x000fc800078e0203ULL,
0x0000000b06037224ULL, 0x000fca00078e0203ULL, 0x0000000302037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x0000000803027c11ULL, 0x000fc8000f8040ffULL,
0x0000000903037c11ULL, 0x000fc600080f4404ULL, 0x0000001063027825ULL, 0x000fca00078e0002ULL,
0x0000000c02007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000626300720cULL, 0x000fe20003f06070ULL, 0x00009800ff107b82ULL, 0x000e620000000a00ULL,
0x00000001ff087424ULL, 0x000fe400078e00ffULL, 0xffffffffff0b7424ULL, 0x000fca00078e00ffULL,
0x00008e00ff0c7b82ULL, 0x000ea80000000a00ULL, 0x0000000207028824ULL, 0x000fc800078e00ffULL,
0x00009400ff098b82ULL, 0x000ef00000000800ULL, 0x00009000ff0e8b82ULL, 0x000f620000000a00ULL,
0x00000006105d7981ULL, 0x002322000c1e9900ULL, 0x0000000902098224ULL, 0x008fc800078e0263ULL,
0x00000004090e8825ULL, 0x020fe400078e000eULL, 0x01a60008ff0879a7ULL, 0x000e660008500009ULL,
0x000000060e0b8981ULL, 0x000ee2000c1e1900ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x0000004003027824ULL, 0x000fe400078e00ffULL, 0x0000004063037824ULL, 0x000fe400078e00ffULL,
0x0000004058057824ULL, 0x000fc400078e00ffULL, 0x0000000b020b7224ULL, 0x008fc800078e02ffULL,
0x000000800b0c7825ULL, 0x004fe400078e000cULL, 0x0000000c00200947ULL, 0x002fea0003800000ULL,
0x00000003ff357819ULL, 0x000fe4000001160aULL, 0x0000000374067248ULL, 0x000fc60007fe0000ULL,
0x00000004350f7836ULL, 0x000fe40000000000ULL, 0x0000000106067824ULL, 0x000fe400078e0a03ULL,
0x000000010f0b7824ULL, 0x140fe400078e020aULL, 0x000000080f0e7824ULL, 0x040fe200078e00ffULL,
0x000000060f00720cULL, 0x080fe20003f86070ULL, 0x00000008350f7836ULL, 0x000fe40000000000ULL,
0x0000004058587824ULL, 0x000fe200078e0235ULL, 0xfffffff80e257812ULL, 0x000fe200078ee20bULL,
0x000000010f0b7824ULL, 0x040fe200078e020aULL, 0x000000060f00720cULL, 0x040fe20003f06070ULL,
0x000000080f167824ULL, 0x000fc400078e00ffULL, 0x0000000c35117836ULL, 0x000fe40000000000ULL,
0x00000080580e7825ULL, 0x000fe200078e00ffULL, 0xfffffff816277812ULL, 0x000fe400078ee20bULL,
0x000000061100720cULL, 0x040fe20003f26070ULL, 0x0000000458107836ULL, 0x000fe20000000000ULL,
0x000000700e1b7812ULL, 0x000fe200078ef804ULL, 0x0000000111147824ULL, 0x040fe400078e020aULL,
0x0000000811297824ULL, 0x000fe200078e00ffULL, 0x0000001b0c1a7210ULL, 0x000fe20007f5e0ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee214ULL,
0x0000000858127836ULL, 0x000fe20000000000ULL, 0x00000070101d7812ULL, 0x000fe200078ef804ULL,
0x0000000c580e7836ULL, 0x000fe40000000000ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x000000010d1b7824ULL, 0x000fe200010e060fULL, 0x0000001d0c1c7210ULL, 0x000fe20007f5e0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x00000070121f7812ULL, 0x000fc600078ef804ULL,
0x0000001058107836ULL, 0x000fe20000000000ULL, 0x000000700e217812ULL, 0x000fe200078ef804ULL,
0x000000010d1d7824ULL, 0x000fe200010e0611ULL, 0x0000001f0c1e7210ULL, 0x000fe20007f7e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000210c207210ULL, 0x000fc60007f5e0ffULL,
0x0000001458127836ULL, 0x000fe20000000000ULL, 0x00000070100b7812ULL, 0x000fe200078ef804ULL,
0x0000001858147836ULL, 0x000fe40000000000ULL, 0x0000001c58187836ULL, 0x000fe40000000000ULL,
0x000000010d1f7824ULL, 0x000fe400018e0613ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000007014177812ULL, 0x000fc600078ef804ULL, 0x000000010d217824ULL, 0x040fe200010e060fULL,
0x0000000b0c107210ULL, 0x000fe20007f5e0ffULL, 0x00000020580e7836ULL, 0x000fe20000000000ULL,
0x00000070120f7812ULL, 0x000fe200078ef804ULL, 0x0000001c35317836ULL, 0x000fe20000000000ULL,
0x00000070180b7812ULL, 0x000fe200078ef804ULL, 0x000000010d117824ULL, 0x000fe200010e0611ULL,
0x0000000f0c127210ULL, 0x000fe20007f5e0ffULL, 0x00000001350f7824ULL, 0x000fe200078e020aULL,
0x000000170c167210ULL, 0x000fe20007f7e0ffULL, 0x00000018352f7836ULL, 0x000fe20000000000ULL,
0x0000000b0c147210ULL, 0x000fe20007fbe0ffULL, 0x000000010d137824ULL, 0x000fe200010e0613ULL,
0x00000009630b7c11ULL, 0x000fe2000f8e70ffULL, 0x000000010d177824ULL, 0x000fe200018e0615ULL,
0x000000070f2b7812ULL, 0x000fe200078ec0ffULL, 0x000000010d157824ULL, 0x000fe200028e0619ULL,
0x000000063500720cULL, 0x000fe20003fa6070ULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x000020000b247836ULL, 0x000fe20000000000ULL, 0x000000700e237812ULL, 0x000fe200078ef804ULL,
0x0000001435197836ULL, 0x000fe40000000000ULL, 0x00000010350b7836ULL, 0x000fe20000000000ULL,
0x000000230c227210ULL, 0x000fe20007fde0ffULL, 0x00000001190e7824ULL, 0x140fe200078e020aULL,
0x000000061900720cULL, 0x080fe20003f66070ULL, 0x000000010b187824ULL, 0x040fe200078e020aULL,
0x000000060b00720cULL, 0x040fe20003f46070ULL, 0x000000080b2d7824ULL, 0x000fe200078e00ffULL,
0x0ffffff82b0b7812ULL, 0x000fe200078ef80aULL, 0x0000000819197824ULL, 0x000fc400078e00ffULL,
0x000000010d237824ULL, 0x000fe200030e060fULL, 0xfffffff82d2b7812ULL, 0x000fe200078ee218ULL,
0x0000002858187836ULL, 0x000fe20000000000ULL, 0xfffffff8192d7812ULL, 0x000fe200078ee20eULL,
0x00000024580e7836ULL, 0x000fe40000000000ULL, 0x000000100b0b7824ULL, 0x000fe400078e0224ULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a0b7faeULL, 0x0003e2000e901c46ULL, 0x0000001025257824ULL, 0x000fe200078e0224ULL,
0x000000700e337812ULL, 0x000fe200078ef804ULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x000000062f00720cULL, 0x0c0fe40003fa6070ULL, 0x000000001c257faeULL, 0x0005e2000e101c46ULL,
0x000000012f267824ULL, 0x000fe200078e020aULL, 0x000000063100720cULL, 0x000fe20003f86070ULL,
0x000000082f2f7824ULL, 0x000fe400078e00ffULL, 0x0000001027277824ULL, 0x100fe200078e0224ULL,
0x000000330c1a7210ULL, 0x002fe20007fde0ffULL, 0x0000001029297824ULL, 0x000fe200078e0224ULL,
0x00000070180b7812ULL, 0x000fe200078ef804ULL, 0x0000000131187824ULL, 0x000fe200078e020aULL,
0x000000001e277faeULL, 0x000fe2000c101c46ULL, 0x000000010d1b7824ULL, 0x000fe200030e060fULL,
0x0000000b0c0e7210ULL, 0x000fe20007fde0ffULL, 0x00000008311d7824ULL, 0x004fe200078e00ffULL,
0xfffffff82f0b7812ULL, 0x000fe200078ee226ULL, 0x000000102b2b7824ULL, 0x000fe200078e0224ULL,
0x0000000020297faeULL, 0x000fe2000c901c46ULL, 0x000000010d0f7824ULL, 0x000fe200030e0619ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee218ULL, 0x0000002c58187836ULL, 0x000fe20000000000ULL,
0x00000000102b7faeULL, 0x0003e2000d101c46ULL, 0x0000002035257836ULL, 0x000fc40000000000ULL,
0x0000008018187825ULL, 0x000fc600078e00ffULL, 0x000000062500720cULL, 0x080fe20003f06070ULL,
0x000000102d2d7824ULL, 0x100fe200078e0224ULL, 0x0000007018317812ULL, 0x000fe200078ef804ULL,
0x00000024352f7836ULL, 0x000fe40000000000ULL, 0x000000100b0b7824ULL, 0x100fe200078e0224ULL,
0x00000000122d7faeULL, 0x0005e2000d901c46ULL, 0x0000003058107836ULL, 0x002fe20000000000ULL,
0x000000310c187210ULL, 0x000fe20007fde0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0224ULL,
0x00000000160b7faeULL, 0x000fe2000e901c46ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000062f00720cULL, 0x000fc40003f26070ULL, 0x00000000141d7faeULL, 0x0003e2000e101c46ULL,
0x00000001251c7824ULL, 0x140fe400078e020aULL, 0x0000000825337824ULL, 0x000fe400078e00ffULL,
0x000000012f257824ULL, 0x140fe400078e020aULL, 0x000000082f1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8331f7812ULL, 0x000fe200078ee21cULL, 0x0000002835217836ULL, 0x000fe40000000000ULL,
0x0000003458127836ULL, 0x004fe20000000000ULL, 0x0000007010157812ULL, 0x002fe200078ef804ULL,
0x000000010d197824ULL, 0x000fe200030e0619ULL, 0xfffffff81e257812ULL, 0x000fe200078ee225ULL,
0x00000001210b7824ULL, 0x040fe200078e020aULL, 0x000000150c147210ULL, 0x000fe20007fde0ffULL,
0x0000000821167824ULL, 0x040fe200078e00ffULL, 0x000000062100720cULL, 0x000fe20003fa6070ULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff816177812ULL, 0x000fe200078ee20bULL,
0x000000101f1f7824ULL, 0x100fe400078e0224ULL, 0x0000001025257824ULL, 0x000fe400078e0224ULL,
0x0000003035297836ULL, 0x000fe20000000000ULL, 0x00000000221f7faeULL, 0x000fe2000c101c46ULL,
0x0000002c35277836ULL, 0x000fe40000000000ULL, 0x00000034352b7836ULL, 0x000fe20000000000ULL,
0x000000001a257faeULL, 0x0003e2000c901c46ULL, 0x00000038352d7836ULL, 0x000fe20000000000ULL,
0x000000062700720cULL, 0x080fe20003f86070ULL, 0x0000003c352f7836ULL, 0x000fe20000000000ULL,
0x000000062900720cULL, 0x080fe20003f66070ULL, 0x000000010d157824ULL, 0x000fe200030e0611ULL,
0x0000007012117812ULL, 0x000fe200078ef804ULL, 0x00000001290b7824ULL, 0x100fe200078e020aULL,
0x000000062b00720cULL, 0x080fe20003f46070ULL, 0x0000000829167824ULL, 0x000fe200078e00ffULL,
0x000000062d00720cULL, 0x080fe20003f26070ULL, 0x0000003858107836ULL, 0x000fe20000000000ULL,
0x000000062f00720cULL, 0x000fe20003f06070ULL, 0x0000000127067824ULL, 0x040fe200078e020aULL,
0x000000110c127210ULL, 0x000fe20007fde0ffULL, 0x00000008271b7824ULL, 0x002fe200078e00ffULL,
0xfffffff8161d7812ULL, 0x000fe200078ee20bULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee206ULL, 0x0000003c580b7836ULL, 0x000fe20000000000ULL,
0x00000070101f7812ULL, 0x000fe200078ef804ULL, 0x000000012b067824ULL, 0x100fe400078e020aULL,
0x000000012d167824ULL, 0x100fe400078e020aULL, 0x000000012f1a7824ULL, 0x000fe400078e020aULL,
0x000000800b0a7825ULL, 0x000fc800078e00ffULL, 0x000000010d137824ULL, 0x000fe200030e0613ULL,
0x0000001f0c107210ULL, 0x000fe20007fde0ffULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0x000000700a257812ULL, 0x000fe200078ef804ULL, 0x000000082d217824ULL, 0x000fe400078e00ffULL,
0x000000082f237824ULL, 0x000fe200078e00ffULL, 0xfffffff82b1f7812ULL, 0x000fe200078ee206ULL,
0x000000010d117824ULL, 0x000fe200030e0611ULL, 0xfffffff821217812ULL, 0x000fe200078ee216ULL,
0x0000001017177824ULL, 0x100fe200078e0224ULL, 0xfffffff823237812ULL, 0x000fe200078ee21aULL,
0x000000101b1b7824ULL, 0x100fe200078e0224ULL, 0x000000250c0a7210ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0224ULL, 0x000000000e177faeULL, 0x0003e2000e901c46ULL,
0x000000101f1f7824ULL, 0x000fc400078e0224ULL, 0x0000001021217824ULL, 0x100fe200078e0224ULL,
0x00000000181b7faeULL, 0x0003e2000e101c46ULL, 0x0000001023237824ULL, 0x000fe400078e0224ULL,
0x000000010d0b7824ULL, 0x000fe200030e060bULL, 0x00000000141d7faeULL, 0x0003e8000d901c46ULL,
0x00000000121f7faeULL, 0x0003e8000d101c46ULL, 0x0000000010217faeULL, 0x0003e8000c901c46ULL,
0x000000000a237faeULL, 0x0003e2000c101c46ULL, 0x0000000800d07947ULL, 0x000fea0003800000ULL,
0x000000040a0f7811ULL, 0x040fe400078fe8ffULL, 0x000000100a177811ULL, 0x040fe400078fe8ffULL,
0x000000140a197811ULL, 0x040fe200078fe8ffULL, 0x000000010f067824ULL, 0x140fe200078e020aULL,
0x000000080a137811ULL, 0x040fe200078fe8ffULL, 0x000000080f0b7824ULL, 0x000fe200078e00ffULL,
0x000000200a1f7811ULL, 0x040fe200078fe8ffULL, 0x00000001170e7824ULL, 0x140fe200078e020aULL,
0x0000000c0a157811ULL, 0x040fe200078fe8ffULL, 0x00000008171b7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b127812ULL, 0x000fe200078ee206ULL, 0x0000000119107824ULL, 0x140fe200078e020aULL,
0x000000240a217811ULL, 0x040fe200078fe8ffULL, 0x00000008191d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81b187812ULL, 0x000fe200078ee20eULL, 0x0000000113067824ULL, 0x140fe200078e020aULL,
0x000000180a1b7811ULL, 0x040fe200078fe8ffULL, 0x0000000813117824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1a7812ULL, 0x000fe200078ee210ULL, 0x000000011f0e7824ULL, 0x140fe200078e020aULL,
0x0000001c0a1d7811ULL, 0x040fe200078fe8ffULL, 0x000000081f237824ULL, 0x000fe200078e00ffULL,
0xfffffff811147812ULL, 0x000fe200078ee206ULL, 0x00000001150b7824ULL, 0x140fe200078e020aULL,
0x000000300a2c7811ULL, 0x040fe200078fe8ffULL, 0x0000000815167824ULL, 0x000fe200078e00ffULL,
0xfffffff823207812ULL, 0x000fe200078ee20eULL, 0x0000000121107824ULL, 0x140fe200078e020aULL,
0x000000280a237811ULL, 0x040fe200078fe8ffULL, 0x0000000821257824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee20bULL, 0x000000011b067824ULL, 0x140fe200078e020aULL,
0x000000340a2e7811ULL, 0x040fe200078fe8ffULL, 0x000000081b117824ULL, 0x000fe200078e00ffULL,
0xfffffff825227812ULL, 0x000fe200078ee210ULL, 0x000000011d0b7824ULL, 0x140fe200078e020aULL,
0x0000002c0a257811ULL, 0x040fe200078fe8ffULL, 0x000000081d1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8111c7812ULL, 0x000fe200078ee206ULL, 0x0000000123067824ULL, 0x140fe200078e020aULL,
0x000000380a307811ULL, 0x000fe200078fe8ffULL, 0x0000000823117824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20bULL, 0x000000012c0e7824ULL, 0x100fe200078e020aULL,
0x0000003c0a327811ULL, 0x000fe200078fe8ffULL, 0x000000082c277824ULL, 0x000fe200078e00ffULL,
0xfffffff811247812ULL, 0x000fe200078ee206ULL, 0x00000001250b7824ULL, 0x140fe200078e020aULL,
0x0000000a0a067211ULL, 0x000fe200078fe8ffULL, 0x0000000825267824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee20eULL, 0x000000012e107824ULL, 0x100fe200078e020aULL,
0x000000050a0e7211ULL, 0x000fe200078fe8ffULL, 0x000000082e297824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee20bULL, 0x00000008322b7824ULL, 0x000fe200078e00ffULL,
0x00000007060b7812ULL, 0x000fe200078ec0ffULL, 0x0000000130067824ULL, 0x000fe200078e020aULL,
0x0000000963117c11ULL, 0x000fc4000f8e70ffULL, 0xfffffff829287812ULL, 0x000fe200078ee210ULL,
0x0000000105107824ULL, 0x000fe200078e020fULL, 0x0ffffff80b0b7812ULL, 0x000fe200078ef80aULL,
0x0000000830297824ULL, 0x000fe400078e00ffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff829067812ULL, 0x000fe200078ee206ULL, 0x00000001320a7824ULL, 0x000fe200078e020aULL,
0x000000700e297812ULL, 0x000fe200078ef804ULL, 0x00002000114b7836ULL, 0x000fe40000000000ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0xfffffff82b0e7812ULL, 0x000fe400078ee20aULL,
0x000000290c0a7210ULL, 0x000fe20007f1e0ffULL, 0x000000100b2d7824ULL, 0x100fe200078e024bULL,
0x00000070100b7812ULL, 0x000fe200078ef804ULL, 0x00000010122f7824ULL, 0x000fc400078e024bULL,
0x0000001014317824ULL, 0x100fe400078e024bULL, 0x0000001016337824ULL, 0x100fe400078e024bULL,
0x0000001018357824ULL, 0x100fe400078e024bULL, 0x000000101a377824ULL, 0x100fe400078e024bULL,
0x000000101c397824ULL, 0x100fe400078e024bULL, 0x000000101e3b7824ULL, 0x000fc400078e024bULL,
0x00000010203d7824ULL, 0x100fe400078e024bULL, 0x00000010223f7824ULL, 0x100fe400078e024bULL,
0x0000001024417824ULL, 0x100fe400078e024bULL, 0x0000001026437824ULL, 0x100fe400078e024bULL,
0x0000001027457824ULL, 0x100fe400078e024bULL, 0x0000001028477824ULL, 0x000fc400078e024bULL,
0x0000001006497824ULL, 0x100fe400078e024bULL, 0x000000100e4b7824ULL, 0x000fe200078e024bULL,
0x0000000b0c0e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000105107824ULL, 0x040fe400078e0213ULL,
0x0000000105127824ULL, 0x000fe400078e0215ULL, 0x000000010d0b7824ULL, 0x040fe400000e060fULL,
0x000000010d0f7824ULL, 0x000fc400008e0611ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a2d7faeULL, 0x0003e6000b901c46ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000007010297812ULL, 0x000fe200078ef804ULL,
0x000000000e2f7faeULL, 0x0003e4000b901c46ULL, 0x0000000105167824ULL, 0x040fe200078e0219ULL,
0x000000290c107210ULL, 0x000fe20007f1e0ffULL, 0x0000000105147824ULL, 0x000fc400078e0217ULL,
0x0000000105187824ULL, 0x000fe200078e021bULL, 0x00000070121b7812ULL, 0x000fe200078ef804ULL,
0x0000008016167825ULL, 0x000fc600078e00ffULL, 0x0000001b0c127210ULL, 0x000fe20007f3e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000070161b7812ULL, 0x000fc600078ef804ULL,
0x000000010d117824ULL, 0x040fe200000e0611ULL, 0x0000001b0c167210ULL, 0x000fe20007f1e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x00000070181b7812ULL, 0x000fe400078ef804ULL,
0x0000000010317faeULL, 0x0003e2000b901c46ULL, 0x000000010d177824ULL, 0x000fe200000e0617ULL,
0x0000001b0c227210ULL, 0x000fe20007f1e0ffULL, 0x00000001051a7824ULL, 0x040fe200078e021dULL,
0x0000007014277812ULL, 0x000fe200078ef804ULL, 0x0000000105187824ULL, 0x000fc400078e021fULL,
0x00000001051e7824ULL, 0x000fe200078e0223ULL, 0x000000270c147210ULL, 0x000fe20007f5e0ffULL,
0x000000801a1a7825ULL, 0x000fc800078e00ffULL, 0x000000010d237824ULL, 0x000fe400000e0619ULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x00000001051c7824ULL, 0x000fe200078e0221ULL,
0x000000701a217812ULL, 0x000fe200078ef804ULL, 0x000000010d137824ULL, 0x000fe200008e0613ULL,
0x0000007018277812ULL, 0x000fe200078ef804ULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000210c247210ULL, 0x000fe40007f1e0ffULL, 0x000000270c267210ULL, 0x000fe20007f3e0ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000000701c297812ULL, 0x000fe200078ef804ULL,
0x0000000012337faeULL, 0x0003e4000b901c46ULL, 0x0000000105067824ULL, 0x000fe200078e0225ULL,
0x000000701e2b7812ULL, 0x000fe200078ef804ULL, 0x000000010d257824ULL, 0x040fe200000e061bULL,
0x000000290c287210ULL, 0x000fe20007f1e0ffULL, 0x000000010d277824ULL, 0x000fc400008e0619ULL,
0x0000008006187825ULL, 0x000fc800078e00ffULL, 0x000000010d157824ULL, 0x040fe200010e0615ULL,
0x0000002b0c2a7210ULL, 0x000fe20007f5e0ffULL, 0x000000010d297824ULL, 0x000fe200000e061dULL,
0x00000070181d7812ULL, 0x000fe200078ef804ULL, 0x00000001051a7824ULL, 0x040fe200078e022cULL,
0x0000000014357faeULL, 0x0003e2000b901c46ULL, 0x00000001051c7824ULL, 0x040fe200078e022eULL,
0x0000001d0c187210ULL, 0x000fe20007f1e0ffULL, 0x00000001051e7824ULL, 0x040fe200078e0230ULL,
0x0000000016377faeULL, 0x0003e2000b901c46ULL, 0x0000000105207824ULL, 0x000fc400078e0232ULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000000022397faeULL, 0x0003e6000b901c46ULL,
0x000000010d2b7824ULL, 0x040fe200010e061fULL, 0x000000701a537812ULL, 0x000fe200078ef804ULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x00000000243b7faeULL, 0x0003e6000b901c46ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000000701c517812ULL, 0x000fe200078ef804ULL,
0x00000000263d7faeULL, 0x0003e4000b901c46ULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x000000701e4f7812ULL, 0x000fe200078ef804ULL, 0x00000000283f7faeULL, 0x0003e2000b901c46ULL,
0x000000510c1c7210ULL, 0x000fe20007f3e0ffULL, 0x000000010d197824ULL, 0x040fe200000e0619ULL,
0x00000070204d7812ULL, 0x000fe200078ef804ULL, 0x000000002a417faeULL, 0x0003e2000b901c46ULL,
0x000000530c1a7210ULL, 0x000fe20007f1e0ffULL, 0x000000010d1d7824ULL, 0x040fe200008e061dULL,
0x0000004f0c1e7210ULL, 0x000fe20007f5e0ffULL, 0x0000000018437faeULL, 0x0003e2000b901c46ULL,
0x0000004d0c0c7210ULL, 0x000fe20007f7e0ffULL, 0x000000010d1b7824ULL, 0x000fc400000e061bULL,
0x000000010d1f7824ULL, 0x040fe400010e061fULL, 0x000000010d0d7824ULL, 0x000fe200018e0621ULL,
0x000000001a457faeULL, 0x0003e8000b901c46ULL, 0x000000001c477faeULL, 0x0003e8000b901c46ULL,
0x000000001e497faeULL, 0x0003e8000b901c46ULL, 0x000000000c4b7faeULL, 0x0003e4000b901c46ULL,
0x00000004637d7836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff7b7424ULL, 0x000fc600078e00ffULL, 0x000000627d00720cULL, 0x000fda0003f06070ULL,
0x00009400ff0d8b82ULL, 0x002e620000000800ULL, 0x0000000207048824ULL, 0x000fce00078e00ffULL,
0x00009000ff0a8b82ULL, 0x000ea20000000a00ULL, 0x0000000d040d8224ULL, 0x002fc800078e027dULL,
0x000000040d0a8825ULL, 0x004fca00078e000aULL, 0x000000060a7b8981ULL, 0x000324000c1e1900ULL,
0x00000000000a7805ULL, 0x002fce0000015200ULL, 0x01a60009ff0075a7ULL, 0x000e640008000149ULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff067224ULL, 0x000fce00078e00ffULL,
0x000000100600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fce0000015200ULL, 0x0000000c0a0f7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc8000001140dULL,
0x0000000f04047211ULL, 0x000fca00078110ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060dULL,
0x0000000204047819ULL, 0x000fc8000000120dULL, 0x000000040000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000106067836ULL, 0x000fce0000000000ULL,
0x01a60009ff0075a7ULL, 0x000e640008000149ULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000047919ULL, 0x000e640000000000ULL, 0x0000002063047824ULL, 0x002fc800078e0204ULL,
0x0000000104087836ULL, 0x000fe20000000000ULL, 0x00000004ff067819ULL, 0x000fc80000011604ULL,
0x0ffffffe06097812ULL, 0x000fe400078ec0ffULL, 0x0000001f04067812ULL, 0x000fc600078ec0ffULL,
0x00000001090b7824ULL, 0x000fe400078e0208ULL, 0x00000001040a7824ULL, 0x000fe400078e0209ULL,
0x00000010060c7824ULL, 0x040fe200078e00ffULL, 0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL,
0x00000010060d7824ULL, 0x000fe200078e00ffULL, 0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000809097836ULL, 0x000fe20000000000ULL, 0x000001f00c0b7812ULL, 0x000fe200078ee20bULL,
0x0000001006157824ULL, 0x000fe200078e00ffULL, 0x000001f00d0a7812ULL, 0x000fe200078ee20aULL,
0x0000000104047824ULL, 0x100fe200078e0209ULL, 0x000000090b0b7c11ULL, 0x000fe2000f8e20ffULL,
0x0000000108087824ULL, 0x000fe200078e0209ULL, 0x000000090a0a7c11ULL, 0x000fe2000f8e20ffULL,
0x0000001006097824ULL, 0x000fe200078e00ffULL, 0x0000000f04047812ULL, 0x000fe200078ec0ffULL,
0x000000000b0c7984ULL, 0x000e620000000c00ULL, 0x0000000f08087812ULL, 0x000fc400078ec0ffULL,
0x000001f009047812ULL, 0x000fe200078ee204ULL, 0x000000000a107984ULL, 0x000ea20000000c00ULL,
0x000001f015087812ULL, 0x000fe400078ee208ULL, 0x0000000904047c11ULL, 0x000fe4000f8e20ffULL,
0x0000000908087c11ULL, 0x000fe2000f8e20ffULL, 0x000000ffff167224ULL, 0x002fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff147224ULL, 0x004fc400078e0010ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fe200078e000fULL, 0x000000140a007388ULL, 0x000fe20000000c00ULL,
0x000000ffff187224ULL, 0x000fe400078e0011ULL, 0x000000ffff197224ULL, 0x000fca00078e0013ULL,
0x000000180b007388ULL, 0x000fe80000000c00ULL, 0x00000000080c7984ULL, 0x000e680000000c00ULL,
0x0000000004107984ULL, 0x000ea20000000c00ULL, 0x000000ffff1e7224ULL, 0x002fe400078e000cULL,
0x000000ffff1f7224ULL, 0x000fc400078e000eULL, 0x000000ffff1c7224ULL, 0x004fe400078e0010ULL,
0x000000ffff1d7224ULL, 0x000fe400078e0012ULL, 0x000000ffff227224ULL, 0x000fe400078e000dULL,
0x000000ffff237224ULL, 0x000fe200078e000fULL, 0x0000001c04007388ULL, 0x0003e20000000c00ULL,
0x000000ffff207224ULL, 0x000fe400078e0011ULL, 0x000000ffff217224ULL, 0x000fc400078e0013ULL,
0x00000001ff0c7424ULL, 0x000fc600078e00ffULL, 0x0000002008007388ULL, 0x0003e60000000c00ULL,
0x01a6000cff0c79a7ULL, 0x000ea40008500009ULL, 0x0000000000087805ULL, 0x002fce0000015200ULL,
0x01a6000dff0075a7ULL, 0x004e640008000149ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff067224ULL, 0x000fce00078e00ffULL, 0x000000100600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0000000a080f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc8000001140bULL, 0x0000000f04047211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000204047819ULL, 0x000fc8000000120bULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000106067836ULL, 0x000fce0000000000ULL, 0x01a6000dff0075a7ULL, 0x000e640008000149ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff6100720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00009400ff787b82ULL, 0x000e620000000800ULL,
0x0000000000047919ULL, 0x000ea20000000000ULL, 0x00008400000a7ab9ULL, 0x000fe20000000800ULL,
0x3db504f35d5d7820ULL, 0x010fe20000410000ULL, 0x0000001f0a047890ULL, 0x000fe4000fffe03fULL,
0x8000000a745e7c36ULL, 0x000fe20008000000ULL, 0x0000000963067c11ULL, 0x040fe2000f8e18ffULL,
0x0000010003797836ULL, 0x000fe20000000000ULL, 0x000000043f047899ULL, 0x000fe20008011604ULL,
0x0000000963777c11ULL, 0x000fe2000f8e28ffULL, 0x000000ffff767224ULL, 0x000fe200078e00ffULL,
0x00000008ff5e7819ULL, 0x000fe2000001165eULL, 0xffffffff0a057890ULL, 0x000fc4000fffe03fULL,
0x000000090a087890ULL, 0x000fe4000fffe03fULL, 0x0ffffffe04047892ULL, 0x000fe2000f8ec03fULL,
0x0000007807787224ULL, 0x002fe400078e02ffULL, 0x000000ffff077224ULL, 0x000fd200078e00ffULL,
0x00008e00ff087b82ULL, 0x008e620000000a00ULL, 0x00000002760a7836ULL, 0x000fe20000000000ULL,
0x00000001075c7812ULL, 0x000fe200078e0cffULL, 0x0000007b027b7224ULL, 0x010fc600078e02ffULL,
0x000000610a00720cULL, 0x000fe20003f06070ULL, 0x000000807b087825ULL, 0x002fd800078e0008ULL,
0x0000000c00308947ULL, 0x000fea0003800000ULL, 0x00000100760b7824ULL, 0x000fe200078e0279ULL,
0x00000003ff0d7819ULL, 0x004fc80000011604ULL, 0x0000000b740c7248ULL, 0x000fe20007fe0000ULL,
0x000000040d0f7836ULL, 0x000fe40000000000ULL, 0x000000080d137836ULL, 0x000fe40000000000ULL,
0x0000000c0d197836ULL, 0x000fe40000000000ULL, 0x000000010c0c7824ULL, 0x000fe400078e0a0bULL,
0x000000010f0a7824ULL, 0x140fe400078e0204ULL, 0x000000080f217824ULL, 0x040fe200078e00ffULL,
0x0000000c0f00720cULL, 0x080fe20003f46070ULL, 0x00000001130b7824ULL, 0x140fe200078e0204ULL,
0x0000000c1300720cULL, 0x0c0fe20003f66070ULL, 0x0000000813107824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee20aULL, 0x00000001190e7824ULL, 0x040fe200078e0204ULL,
0x0000000c1900720cULL, 0x040fe20003fa6070ULL, 0x0000000819257824ULL, 0x000fe200078e00ffULL,
0xfffffff810237812ULL, 0x000fe200078ee20bULL, 0x00000010040a7824ULL, 0x000fc400078e00ffULL,
0x0000000105107824ULL, 0x040fe200078e020fULL, 0xfffffff825257812ULL, 0x000fe200078ee20eULL,
0x00000001050e7824ULL, 0x000fe200078e020dULL, 0x000000700a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x000000100d1b7836ULL, 0x000fe20000000000ULL,
0x0000000a10177212ULL, 0x000fe200078efcffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x0000001708167210ULL, 0x000fe20007f3e0ffULL, 0x000000180d2d7836ULL, 0x000fe20000000000ULL,
0x0000000a0e157212ULL, 0x000fe200078efcffULL, 0x000000011b0b7824ULL, 0x140fe200078e0204ULL,
0x0000000c1b00720cULL, 0x040fe20003f86070ULL, 0x000000081b127824ULL, 0x000fe200078e00ffULL,
0x0000001508147210ULL, 0x000fe20007f1e0ffULL, 0x000000140d297836ULL, 0x000fe40000000000ULL,
0x000000012d0e7824ULL, 0x040fe200078e0204ULL, 0xfffffff812277812ULL, 0x000fe200078ee20bULL,
0x000000082d2f7824ULL, 0x000fc400078e00ffULL, 0x00000001290b7824ULL, 0x140fe400078e0204ULL,
0x0000000829127824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee20eULL,
0x0000000105107824ULL, 0x000fe400078e0219ULL, 0x0000000109177824ULL, 0x000fe200008e0611ULL,
0xfffffff8122b7812ULL, 0x000fe200078ee20bULL, 0x00000001050e7824ULL, 0x000fe200078e0213ULL,
0x00000009630b7c11ULL, 0x000fe2000f8e70ffULL, 0x000000010d137824ULL, 0x040fe200078e0204ULL,
0x0000000c0d00720cULL, 0x000fe20003f26070ULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x00000007131f7812ULL, 0x000fe200078ec0ffULL, 0x0000000105127824ULL, 0x000fe200078e021bULL,
0x0000000a101b7212ULL, 0x000fe200078efcffULL, 0x0000000109157824ULL, 0x000fe200000e060fULL,
0x0ffffff81f1f7812ULL, 0x000fe200078ef804ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001b081a7210ULL, 0x000fc60007fde0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000a0e197212ULL, 0x000fc600078efcffULL, 0x000020005c187824ULL, 0x000fe200078e020bULL,
0x0000000a121d7212ULL, 0x000fe200078efcffULL, 0x0000000105107824ULL, 0x000fe400078e0229ULL,
0x00002000180e7836ULL, 0x000fe20000000000ULL, 0x0000001908187210ULL, 0x000fe20007f1e0ffULL,
0x00000001091b7824ULL, 0x000fe200030e0611ULL, 0x0000001d081c7210ULL, 0x000fe20007fde0ffULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x0000000109197824ULL, 0x000fe200000e060fULL,
0x0000000c2900720cULL, 0x000fe20003f06070ULL, 0x000000101f0f7824ULL, 0x000fe400078e020eULL,
0x00000001091d7824ULL, 0x000fe200030e0613ULL, 0x0000000a10137212ULL, 0x000fe200078efcffULL,
0x000000200d317836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140f7faeULL, 0x0003e2000c901c46ULL, 0x0000000105127824ULL, 0x000fe200078e022dULL,
0x0000000c2d00720cULL, 0x000fe20003f26070ULL, 0x0000000131107824ULL, 0x000fc400078e0204ULL,
0x0000000831337824ULL, 0x000fe400078e00ffULL, 0x0000001c0d297836ULL, 0x000fc60000000000ULL,
0xfffffff833337812ULL, 0x000fe200078ee210ULL, 0x00000001291e7824ULL, 0x040fe200078e0204ULL,
0x0000001308147210ULL, 0x002fe20007fde0ffULL, 0x00000008292d7824ULL, 0x000fe400078e00ffULL,
0x00000010210f7824ULL, 0x000fe400078e020eULL, 0x0000000109157824ULL, 0x000fe200030e0611ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee21eULL, 0x0000008012107825ULL, 0x000fe200078e00ffULL,
0x00000000160f7faeULL, 0x0003e2000d101c46ULL, 0x0000000c2900720cULL, 0x000fc40003f46070ULL,
0x0000000105127824ULL, 0x040fe200078e0229ULL, 0x0000000a101f7212ULL, 0x000fe200078efcffULL,
0x0000000105107824ULL, 0x000fe400078e0231ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000001f081e7210ULL, 0x000fc60007fde0ffULL, 0x0000001023217824ULL, 0x100fe200078e020eULL,
0x0000000a12177212ULL, 0x002fe200078efcffULL, 0x00000001091f7824ULL, 0x000fe400030e0611ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000001708167210ULL, 0x000fe20007fde0ffULL,
0x0000000018217faeULL, 0x0003e2000d901c46ULL, 0x0000000c3100720cULL, 0x000fe20003f66070ULL,
0x000000240d237836ULL, 0x000fe40000000000ULL, 0x00000010250f7824ULL, 0x000fc400078e020eULL,
0x0000000105127824ULL, 0x000fe400078e0223ULL, 0x0000000109177824ULL, 0x000fe200030e0613ULL,
0x000000001a0f7faeULL, 0x0005e2000e901c46ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000c2300720cULL, 0x040fe40003fa6070ULL, 0x0000000a10197212ULL, 0x002fe200078efcffULL,
0x0000000123207824ULL, 0x040fe400078e0204ULL, 0x0000000823217824ULL, 0x000fe200078e00ffULL,
0x0000001908187210ULL, 0x000fe20007fde0ffULL, 0x000000300d297836ULL, 0x000fc40000000000ULL,
0x000000280d0f7836ULL, 0x004fe20000000000ULL, 0x0000000a121b7212ULL, 0x000fe200078efcffULL,
0x0000000109197824ULL, 0x000fe200030e0611ULL, 0xfffffff821237812ULL, 0x000fe200078ee220ULL,
0x000000010f117824ULL, 0x040fe200078e0204ULL, 0x0000001b081a7210ULL, 0x000fe20007fde0ffULL,
0x000000080f127824ULL, 0x000fe400078e00ffULL, 0x0000000105107824ULL, 0x000fe400078e020fULL,
0x0000001027217824ULL, 0x000fe200078e020eULL, 0xfffffff812257812ULL, 0x000fe200078ee211ULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0x000000001c217faeULL, 0x0003e2000e101c46ULL,
0x0000002c0d277836ULL, 0x000fe20000000000ULL, 0x0000000c0f00720cULL, 0x000fe20003f86070ULL,
0x000000102b0f7824ULL, 0x000fe400078e020eULL, 0x00000001091b7824ULL, 0x000fe200030e0613ULL,
0x0000000a10137212ULL, 0x000fe200078efcffULL, 0x0000000105127824ULL, 0x000fe200078e0227ULL,
0x00000000140f7faeULL, 0x0005e2000c101c46ULL, 0x0000000827207824ULL, 0x040fe200078e00ffULL,
0x0000001308107210ULL, 0x000fe20007fde0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000c2700720cULL, 0x000fc60003f06070ULL, 0x00000001271d7824ULL, 0x002fe400078e0204ULL,
0x00000001051c7824ULL, 0x000fe400078e0229ULL, 0x0000000109117824ULL, 0x000fe200030e0611ULL,
0xfffffff820277812ULL, 0x000fe200078ee21dULL, 0x000000102f0f7824ULL, 0x004fe200078e020eULL,
0x0000000a121d7212ULL, 0x000fe200078efcffULL, 0x0000000129127824ULL, 0x040fe400078e0204ULL,
0x000000801c147825ULL, 0x000fe200078e00ffULL, 0x000000001e0f7faeULL, 0x0003e2000c901c46ULL,
0x0000000c2900720cULL, 0x000fc40003f26070ULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0x0000001d081c7210ULL, 0x000fe20007fde0ffULL, 0x000000340d2b7836ULL, 0x000fe20000000000ULL,
0x0000000a14217212ULL, 0x000fe200078efcffULL, 0x0000001023237824ULL, 0x100fe200078e020eULL,
0xfffffff829297812ULL, 0x000fe200078ee212ULL, 0x0000000105127824ULL, 0x000fe400078e022bULL,
0x00000001091d7824ULL, 0x000fe200030e0613ULL, 0x0000002108147210ULL, 0x000fe20007fde0ffULL,
0x000000102d217824ULL, 0x000fc400078e020eULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0x0000000016217faeULL, 0x0005e2000d101c46ULL, 0x00000010330f7824ULL, 0x002fe200078e020eULL,
0x0000000a121f7212ULL, 0x000fe200078efcffULL, 0x000000380d2d7836ULL, 0x000fe40000000000ULL,
0x0000003c0d2f7836ULL, 0x000fe20000000000ULL, 0x00000000180f7faeULL, 0x0003e2000d901c46ULL,
0x00000001050d7824ULL, 0x000fe200078e022dULL, 0x0000000c2d00720cULL, 0x080fe20003f66070ULL,
0x0000000109157824ULL, 0x000fe200030e0615ULL, 0x000000001a237faeULL, 0x0007e2000e901c46ULL,
0x0000000c2b00720cULL, 0x080fe20003fa6070ULL, 0x0000000105127824ULL, 0x000fe200078e022fULL,
0x0000000c2f00720cULL, 0x000fe20003f46070ULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x0000001f081e7210ULL, 0x000fc60007fde0ffULL, 0x000000012b167824ULL, 0x004fe200078e0204ULL,
0x0000000a0c0f7212ULL, 0x002fe200078efcffULL, 0x00000001091f7824ULL, 0x000fe400030e0613ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000000f080c7210ULL, 0x000fc60007fde0ffULL,
0x000000082b217824ULL, 0x000fe200078e00ffULL, 0x0000000a121b7212ULL, 0x008fe200078efcffULL,
0x000000012d177824ULL, 0x140fe400078e0204ULL, 0x000000082d1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee216ULL, 0x000000012f187824ULL, 0x040fe400078e0204ULL,
0x000000082f2b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a237812ULL, 0x000fe200078ee217ULL,
0x00000001090d7824ULL, 0x000fe200030e060dULL, 0x0000001b08087210ULL, 0x000fe20007fde0ffULL,
0x00000010250f7824ULL, 0x100fe200078e020eULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee218ULL,
0x0000001027177824ULL, 0x000fc400078e020eULL, 0x0000001029197824ULL, 0x100fe200078e020eULL,
0x00000000100f7faeULL, 0x0003e2000e101c46ULL, 0x00000010211b7824ULL, 0x100fe400078e020eULL,
0x0000001023217824ULL, 0x100fe200078e020eULL, 0x000000001c177faeULL, 0x0003e2000c101c46ULL,
0x000000102b237824ULL, 0x000fe400078e020eULL, 0x0000000109097824ULL, 0x000fe200030e0613ULL,
0x0000000014197faeULL, 0x0003e8000c901c46ULL, 0x000000001e1b7faeULL, 0x0003e8000e901c46ULL,
0x000000000c217faeULL, 0x0003e8000d901c46ULL, 0x0000000008237faeULL, 0x0003e2000d101c46ULL,
0x0000000800dc7947ULL, 0x000fea0003800000ULL, 0x0000000804107811ULL, 0x044fe400078fe8ffULL,
0x00000004040e7811ULL, 0x040fe400078fe8ffULL, 0x0000001404157811ULL, 0x000fe200078fe8ffULL,
0x00000001100b7824ULL, 0x100fe200078e0204ULL, 0x0000001804177811ULL, 0x000fe200078fe8ffULL,
0x00000008100c7824ULL, 0x000fe200078e00ffULL, 0x0000000c04127811ULL, 0x000fe200078fe8ffULL,
0x000000010e0a7824ULL, 0x100fe200078e0204ULL, 0x00000024041e7811ULL, 0x000fe200078fe8ffULL,
0x000000080e2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c317812ULL, 0x000fe200078ee20bULL,
0x00000001150c7824ULL, 0x140fe200078e0204ULL, 0x0000002804207811ULL, 0x040fe200078fe8ffULL,
0x0000000815377824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee20aULL,
0x00000001170d7824ULL, 0x140fe200078e0204ULL, 0x0000001c041a7811ULL, 0x000fe200078fe8ffULL,
0x0000000817167824ULL, 0x000fe200078e00ffULL, 0xfffffff837377812ULL, 0x000fe200078ee20cULL,
0x00000001120a7824ULL, 0x100fe200078e0204ULL, 0x0000003404267811ULL, 0x000fe200078fe8ffULL,
0x0000000812337824ULL, 0x000fe200078e00ffULL, 0xfffffff816397812ULL, 0x000fe200078ee20dULL,
0x000000011e0c7824ULL, 0x100fe200078e0204ULL, 0x0000003804287811ULL, 0x000fe200078fe8ffULL,
0x000000081e3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe200078ee20aULL,
0x00000001200d7824ULL, 0x100fe200078e0204ULL, 0x0000002c04227811ULL, 0x000fe200078fe8ffULL,
0x0000000820167824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee20cULL,
0x000000011a0a7824ULL, 0x100fe200078e0204ULL, 0x0000001004137811ULL, 0x000fe200078fe8ffULL,
0x000000081a3b7824ULL, 0x000fe200078e00ffULL, 0xfffffff816417812ULL, 0x000fe200078ee20dULL,
0x00000001260c7824ULL, 0x100fe200078e0204ULL, 0x00000020041c7811ULL, 0x000fe200078fe8ffULL,
0x0000000826477824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee20aULL,
0x00000001280d7824ULL, 0x100fe200078e0204ULL, 0x0000003004247811ULL, 0x000fe200078fe8ffULL,
0x0000000828167824ULL, 0x000fe200078e00ffULL, 0xfffffff847477812ULL, 0x000fe200078ee20cULL,
0x00000001220a7824ULL, 0x000fe200078e0204ULL, 0x00000005040c7211ULL, 0x000fe200078fe8ffULL,
0x0000000822437824ULL, 0x000fe200078e00ffULL, 0xfffffff816497812ULL, 0x000fe200078ee20dULL,
0x00000001050e7824ULL, 0x000fe200078e020eULL, 0x00000004040d7211ULL, 0x040fe200078fe8ffULL,
0x00000001130b7824ULL, 0x000fe200078e0204ULL, 0xfffffff843437812ULL, 0x000fe200078ee20aULL,
0x00000010040a7824ULL, 0x000fe200078e00ffULL, 0x000000070d0f7812ULL, 0x000fe200078ec0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000003c04297811ULL, 0x000fc400078fe8ffULL,
0x000000700a4d7812ULL, 0x000fe200078ec0ffULL, 0x0000000813147824ULL, 0x000fe200078e00ffULL,
0x0ffffff80f2d7812ULL, 0x000fe200078ef804ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000004d0c117212ULL, 0x080fe400078efcffULL, 0xfffffff814357812ULL, 0x000fe200078ee20bULL,
0x000000011c0b7824ULL, 0x040fe200078e0204ULL, 0x00000011080c7210ULL, 0x000fe20007f1e0ffULL,
0x000000081c147824ULL, 0x000fe200078e00ffULL, 0x0000004d0e117212ULL, 0x000fe200078efcffULL,
0x0000000105107824ULL, 0x000fc400078e0210ULL, 0x0000000105167824ULL, 0x000fe200078e0215ULL,
0x00000011080e7210ULL, 0x000fe20007f3e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0xfffffff8143d7812ULL, 0x000fc600078ee20bULL, 0x00000001240b7824ULL, 0x100fe200078e0204ULL,
0x0000004d101b7212ULL, 0x000fe200078efcffULL, 0x0000000824147824ULL, 0x000fe400078e00ffULL,
0x0000000105187824ULL, 0x000fe400078e0217ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0xfffffff814457812ULL, 0x000fe400078ee20bULL, 0x00000009630b7c11ULL, 0x000fe2000f8e70ffULL,
0x0000000129147824ULL, 0x000fc400078e0204ULL, 0x00000008294b7824ULL, 0x000fe400078e00ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0609ULL, 0x0000001b08107210ULL, 0x000fe20007f1e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000004d161b7212ULL, 0x080fe400078efcffULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee214ULL, 0x0000000105147824ULL, 0x000fe400078e0213ULL,
0x0000000111117824ULL, 0x000fe200000e0609ULL, 0x0000001b08167210ULL, 0x000fe20007f1e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000004d181b7212ULL, 0x000fc600078efcffULL,
0x00000001051a7824ULL, 0x000fe200078e021aULL, 0x0000004d141f7212ULL, 0x000fe200078efcffULL,
0x0000000117177824ULL, 0x000fe200000e0609ULL, 0x0000001b08187210ULL, 0x000fe20007f1e0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000001f08147210ULL, 0x000fc60007f5e0ffULL,
0x0000000105127824ULL, 0x040fe200078e0212ULL, 0x0000004d1a237212ULL, 0x000fe200078efcffULL,
0x00000001051e7824ULL, 0x000fe400078e021eULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000004d121d7212ULL, 0x000fc600078efcffULL,
0x0000000105207824ULL, 0x000fe400078e0220ULL, 0x0000000119197824ULL, 0x000fe200000e0609ULL,
0x00000023081a7210ULL, 0x000fe20007f1e0ffULL, 0x00000001051c7824ULL, 0x000fe200078e021cULL,
0x0000004d1e237212ULL, 0x000fe200078efcffULL, 0x0000008020207825ULL, 0x000fc800078e00ffULL,
0x0000000105227824ULL, 0x000fe200078e0222ULL, 0x0000004d20277212ULL, 0x000fe200078efcffULL,
0x000000010f0f7824ULL, 0x100fe200008e0609ULL, 0x0000001d08127210ULL, 0x000fe20007f3e0ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0609ULL, 0x00000023081e7210ULL, 0x000fe20007f1e0ffULL,
0x000000801c1c7825ULL, 0x000fc800078e00ffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000004d1c257212ULL, 0x000fc600078efcffULL, 0x000020005c0a7824ULL, 0x000fe400078e020bULL,
0x0000000115157824ULL, 0x100fe200010e0609ULL, 0x0000002708207210ULL, 0x000fe20007f5e0ffULL,
0x0000000105247824ULL, 0x040fe200078e0224ULL, 0x0000004d22277212ULL, 0x000fe200078efcffULL,
0x0000000105267824ULL, 0x000fe400078e0226ULL, 0x000020000a0a7836ULL, 0x000fe40000000000ULL,
0x0000000113137824ULL, 0x000fe200008e0609ULL, 0x00000025081c7210ULL, 0x000fe20007f3e0ffULL,
0x0000000105287824ULL, 0x000fc400078e0228ULL, 0x000000011f1f7824ULL, 0x000fe200000e0609ULL,
0x0000002708227210ULL, 0x000fe20007f1e0ffULL, 0x00000001052a7824ULL, 0x000fe400078e0229ULL,
0x0000008024247825ULL, 0x000fc800078e00ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000004d244f7212ULL, 0x000fc600078efcffULL, 0x000000102d2d7824ULL, 0x000fe200078e020aULL,
0x0000004d26517212ULL, 0x000fe200078efcffULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c2d7faeULL, 0x0003e2000b901c46ULL,
0x000000102f2f7824ULL, 0x000fe200078e020aULL, 0x0000004d28537212ULL, 0x000fe200078efcffULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0x000000000e2f7faeULL, 0x0003e2000b901c46ULL,
0x0000001031317824ULL, 0x100fe200078e020aULL, 0x0000004d2a4d7212ULL, 0x000fe200078efcffULL,
0x0000001033337824ULL, 0x100fe400078e020aULL, 0x0000001035357824ULL, 0x100fe200078e020aULL,
0x0000000010317faeULL, 0x0003e2000b901c46ULL, 0x0000001037377824ULL, 0x100fe400078e020aULL,
0x0000001039397824ULL, 0x100fe200078e020aULL, 0x0000000012337faeULL, 0x0003e2000b901c46ULL,
0x0000000123237824ULL, 0x100fe200000e0609ULL, 0x0000004f08247210ULL, 0x000fe20007f1e0ffULL,
0x000000103b3b7824ULL, 0x100fe200078e020aULL, 0x0000000014357faeULL, 0x0003e2000b901c46ULL,
0x000000011d1d7824ULL, 0x100fe200008e0609ULL, 0x0000005108267210ULL, 0x000fe20007f3e0ffULL,
0x000000103d3d7824ULL, 0x100fe200078e020aULL, 0x0000000016377faeULL, 0x0003e2000b901c46ULL,
0x0000000121217824ULL, 0x000fe200010e0609ULL, 0x0000005308287210ULL, 0x000fe20007f5e0ffULL,
0x000000103f3f7824ULL, 0x100fe200078e020aULL, 0x0000004d08087210ULL, 0x000fe20007f7e0ffULL,
0x0000001041417824ULL, 0x100fe200078e020aULL, 0x0000000018397faeULL, 0x0003e2000b901c46ULL,
0x0000001043437824ULL, 0x000fc400078e020aULL, 0x0000001045457824ULL, 0x100fe200078e020aULL,
0x000000001a3b7faeULL, 0x0003e2000b901c46ULL, 0x0000000125257824ULL, 0x100fe400000e0609ULL,
0x0000001047477824ULL, 0x100fe200078e020aULL, 0x000000001c3d7faeULL, 0x0003e2000b901c46ULL,
0x0000000127277824ULL, 0x100fe400008e0609ULL, 0x0000001049497824ULL, 0x000fe200078e020aULL,
0x000000001e3f7faeULL, 0x0003e2000b901c46ULL, 0x0000000129297824ULL, 0x000fc400010e0609ULL,
0x000000104b4b7824ULL, 0x000fe200078e020aULL, 0x0000000020417faeULL, 0x0003e2000b901c46ULL,
0x000000012b097824ULL, 0x000fc600018e0609ULL, 0x0000000022437faeULL, 0x0003e8000b901c46ULL,
0x0000000024457faeULL, 0x0003e8000b901c46ULL, 0x0000000026477faeULL, 0x0003e8000b901c46ULL,
0x0000000028497faeULL, 0x0003e8000b901c46ULL, 0x00000000084b7faeULL, 0x0003e4000b901c46ULL,
0x000000047d7d7836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff7b7424ULL, 0x000fc600078e00ffULL, 0x000000627d00720cULL, 0x000fda0003f06070ULL,
0x00009000ff088b82ULL, 0x002e620000000a00ULL, 0x00000002780d8824ULL, 0x000fe200078e027dULL,
0x0000000804497812ULL, 0x040fe200078ec0ffULL, 0x00000020045f7836ULL, 0x000fe40000000000ULL,
0x0000200007537824ULL, 0x000fe200078e020bULL, 0xfffffff804077812ULL, 0x000fe200078ec0ffULL,
0x000000ffff757224ULL, 0x000fe200078e00ffULL, 0xfffffff85f5f7812ULL, 0x000fe400078ec0ffULL,
0x0000000000467805ULL, 0x000fc4000001ff00ULL, 0x0000000749527812ULL, 0x000fe400078ef804ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x0000000707607812ULL, 0x000fe400078ef804ULL,
0x00000000000a7805ULL, 0x000fe4000001ff00ULL, 0x00000004ff507819ULL, 0x000fe40000011604ULL,
0x00000000000e7805ULL, 0x000fc4000001ff00ULL, 0x0000000704517812ULL, 0x000fe400078ec0ffULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fc4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000040d088825ULL, 0x002fe200078e0008ULL,
0x00000000000c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000006087b8981ULL, 0x000322000c1e1900ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000087805ULL, 0x002fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fc4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000200053537836ULL, 0x000fe20000000000ULL, 0x000000075f5f7812ULL, 0x000fe200078ef804ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000001052077812ULL, 0x000fce00078efcffULL,
0x0000000160487824ULL, 0x040fe400078e0275ULL, 0x0000000860497824ULL, 0x000fe400078e00ffULL,
0x00000002757a7824ULL, 0x000fe400078e0250ULL, 0x0000000175557836ULL, 0x000fe20000000000ULL,
0xfffffff849487812ULL, 0x000fe200078ee248ULL, 0x000000085f497824ULL, 0x000fe400078e00ffULL,
0x0000001052577824ULL, 0x000fc400078e00ffULL, 0x00000010484c7824ULL, 0x000fe400078e0253ULL,
0x000000015f487824ULL, 0x040fe400078e0275ULL, 0x0000000152547824ULL, 0x000fe400078e027aULL,
0x000000004c4c783bULL, 0x000e620000000200ULL, 0xfffffff849487812ULL, 0x000fe200078ee248ULL,
0x000000085f5b7824ULL, 0x040fe200078e00ffULL, 0xfffffff057547812ULL, 0x000fe200078ee254ULL,
0x000000015f587824ULL, 0x000fc400078e0255ULL, 0x0000001048487824ULL, 0x000fe200078e0253ULL,
0x0000000954547c11ULL, 0x000fe2000f8e20ffULL, 0x0000000860597824ULL, 0x040fe200078e00ffULL,
0xfffffff85b587812ULL, 0x000fe200078ee258ULL, 0x0000000160707824ULL, 0x000fe400078e0255ULL,
0x000000004848783bULL, 0x000ea20000000200ULL, 0x0000001007567824ULL, 0x040fe400078e00ffULL,
0x00000001077f7824ULL, 0x000fe200078e027aULL, 0xfffffff859707812ULL, 0x000fe200078ee270ULL,
0x0000001058587824ULL, 0x000fc400078e0253ULL, 0x000000027a7a7836ULL, 0x000fe20000000000ULL,
0xfffffff0567f7812ULL, 0x000fe200078ee27fULL, 0x0000000275757836ULL, 0x000fe20000000000ULL,
0x000000005454783bULL, 0x000ee80000000200ULL, 0x000000087500780cULL, 0x000fe40003f05270ULL,
0x00000010ff6b7819ULL, 0x002fe4000001164cULL, 0x00000010ff817819ULL, 0x000fc4000001164eULL,
0x00000018ff737819ULL, 0x000fe4000001164eULL, 0x000000ff4e727812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4e887812ULL, 0x000fe400078ec0ffULL, 0x00000010ff867819ULL, 0x100fe4000001164fULL,
0x00000018ff657819ULL, 0x000fe4000001164fULL, 0x000000ff4f667812ULL, 0x000fc400078ec0ffULL,
0x0000ffff4f897812ULL, 0x000fe400078ec0ffULL, 0x00000018ff6f7819ULL, 0x000fe4000001164cULL,
0x000000ff4c6e7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4c827812ULL, 0x000fe400078ec0ffULL,
0x00000010ff877819ULL, 0x104fe40000011648ULL, 0x00000018ff677819ULL, 0x000fc40000011648ULL,
0x000000ff484f7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff484e7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff4c7819ULL, 0x100fe40000011649ULL, 0x00000018ff7e7819ULL, 0x000fe40000011649ULL,
0x000000ff497c7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff495b7812ULL, 0x000fc400078ec0ffULL,
0x000000ff6b487812ULL, 0x000fe400078ec0ffULL, 0x00000018ff497819ULL, 0x000fe4000001164aULL,
0x0000ffff4d847812ULL, 0x040fe400078ec0ffULL, 0x000000ff4d647812ULL, 0x000fe400078ec0ffULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x00000048ff83723eULL, 0x000fc400020006ffULL,
0x00000049ff6b723eULL, 0x000fe400020006ffULL, 0x00000008ff4e7819ULL, 0x000fe4000001164eULL,
0x00000010ff807819ULL, 0x100fe4000001164dULL, 0x00000018ff717819ULL, 0x000fe4000001164dULL,
0x00000008ff487819ULL, 0x000fe40000011682ULL, 0x00000008ff497819ULL, 0x000fc40000011684ULL,
0x00000064ff4d723eULL, 0x000fe400020006ffULL, 0x00000066ff64723eULL, 0x000fe400020006ffULL,
0x00005410836f7816ULL, 0x000fe4000000006fULL, 0x0000004fff66723eULL, 0x000fe400020006ffULL,
0x0000004eff83723eULL, 0x000fe200020006ffULL, 0x00000010704e7824ULL, 0x000fe200078e0253ULL,
0x00000048ff4f723eULL, 0x000fc400020006ffULL, 0x00000049ff84723eULL, 0x000fe400020006ffULL,
0x000000ff4c4c7812ULL, 0x000fe400078ec0ffULL, 0x0000006eff6e723eULL, 0x000fe400020006ffULL,
0x000054104d707816ULL, 0x000fe40000000084ULL, 0x000054106e6e7816ULL, 0x000fe4000000004fULL,
0x0000004cff84723eULL, 0x000fc400020006ffULL, 0x000000097f487c11ULL, 0x000fe2000f8e20ffULL,
0x000000004e4c783bULL, 0x000fe20000000200ULL, 0x00000008ff497819ULL, 0x000fe20000011688ULL,
0x0000006e5440723cULL, 0x008fe20000001840ULL, 0x000000ff81827812ULL, 0x000fe400078ec0ffULL,
0x000000ff86817812ULL, 0x000fe400078ec0ffULL, 0x00000010ff597819ULL, 0x000fe4000001164aULL,
0x000000ff4a6c7812ULL, 0x000fc400078ec0ffULL, 0x0000ffff4a5a7812ULL, 0x000fe400078ec0ffULL,
0x00000010ff687819ULL, 0x100fe4000001164bULL, 0x00000018ff6d7819ULL, 0x000fe4000001164bULL,
0x000000ff4b6a7812ULL, 0x040fe400078ec0ffULL, 0x0000ffff4b697812ULL, 0x000fe400078ec0ffULL,
0x000000ff80807812ULL, 0x000fc400078ec0ffULL, 0x00000049ff86723eULL, 0x000fe400020006ffULL,
0x000000004848783bULL, 0x000e620000000200ULL, 0x000000ff877f7812ULL, 0x000fe400078ec0ffULL,
0x00000080ff85723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000008ff807819ULL, 0x000fc40000011689ULL,
0x00000067ff67723eULL, 0x000fe400020006ffULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x00000008ff5b7819ULL, 0x000fe4000001165bULL, 0x00000080ff80723eULL, 0x000fe400020006ffULL,
0x0000541082737816ULL, 0x000fe40000000073ULL, 0x00000065ff65723eULL, 0x000fc400020006ffULL,
0x0000007cff7c723eULL, 0x000fe400020006ffULL, 0x00000081ff81723eULL, 0x000fe400020006ffULL,
0x0000005bff82723eULL, 0x000fe400020006ffULL, 0x00000008ff5a7819ULL, 0x000fe4000001165aULL,
0x000054107f677816ULL, 0x000fe40000000067ULL, 0x0000541066667816ULL, 0x000fc40000000083ULL,
0x000000ff59597812ULL, 0x000fe400078ec0ffULL, 0x000000ff68837812ULL, 0x000fe400078ec0ffULL,
0x00000008ff7f7819ULL, 0x000fe20000011669ULL, 0x000000665430723cULL, 0x000fe20000001830ULL,
0x0000541064647816ULL, 0x000fe40000000080ULL, 0x0000006cff6c723eULL, 0x000fe400020006ffULL,
0x0000541081657816ULL, 0x000fe20000000065ULL, 0x0000006e4820723cULL, 0x002fe20000001820ULL,
0x0000005aff80723eULL, 0x000fc400020006ffULL, 0x000054107c687816ULL, 0x000fe40000000082ULL,
0x00000071ff71723eULL, 0x000fe200020006ffULL, 0x000000645434723cULL, 0x000fe20000001834ULL,
0x00000072ff72723eULL, 0x000fe400020006ffULL, 0x0000007eff7e723eULL, 0x000fe400020006ffULL,
0x0000006dff6d723eULL, 0x000fe200020006ffULL, 0x000000644814723cULL, 0x000fe20000001814ULL,
0x00000059ff81723eULL, 0x000fc400020006ffULL, 0x0000006aff7c723eULL, 0x000fe200020006ffULL,
0x000000005858783bULL, 0x000e620000000200ULL, 0x00000083ff83723eULL, 0x000fe200020006ffULL,
0x000000664810723cULL, 0x000fe20000001810ULL, 0x0000007fff7f723eULL, 0x000fe400020006ffULL,
0x000054106c6a7816ULL, 0x000fe40000000080ULL, 0x0000541085717816ULL, 0x000fe40000000071ULL,
0x0000541072727816ULL, 0x000fc40000000086ULL, 0x0000541084697816ULL, 0x000fe4000000007eULL,
0x00005410816b7816ULL, 0x000fe2000000006bULL, 0x00000070543c723cULL, 0x000fe2000000183cULL,
0x00005410836d7816ULL, 0x000fe4000000006dULL, 0x000054107c6c7816ULL, 0x000fe4000000007fULL,
0x00000010ff877819ULL, 0x100fe2000001164cULL, 0x000000725438723cULL, 0x000fe20000001838ULL,
0x00000018ff837819ULL, 0x000fc4000001164cULL, 0x000000ff4c827812ULL, 0x040fe400078ec0ffULL,
0x0000ffff4c887812ULL, 0x000fe200078ec0ffULL, 0x00000068542c723cULL, 0x000fe2000000182cULL,
0x00000010ff897819ULL, 0x100fe4000001164dULL, 0x00000018ff817819ULL, 0x000fe4000001164dULL,
0x000000ff4d7f7812ULL, 0x040fe200078ec0ffULL, 0x0000006a5428723cULL, 0x000fe20000001828ULL,
0x0000ffff4d8a7812ULL, 0x000fc400078ec0ffULL, 0x00000010ff847819ULL, 0x000fe4000001164eULL,
0x000000ff4e807812ULL, 0x040fe200078ec0ffULL, 0x0000006c5424723cULL, 0x000fe20000001824ULL,
0x0000ffff4e857812ULL, 0x000fe400078ec0ffULL, 0x00000010ff867819ULL, 0x100fe4000001164fULL,
0x00000018ff8b7819ULL, 0x000fe2000001164fULL, 0x00000070481c723cULL, 0x000fe2000000181cULL,
0x0000001052557824ULL, 0x040fe200078e00ffULL, 0x000000ff4f8c7812ULL, 0x000fe200078ec0ffULL,
0x0000000152547824ULL, 0x000fe200078e027aULL, 0x00000018ff8d7819ULL, 0x002fe20000011658ULL,
0x0000001007577824ULL, 0x040fe200078e00ffULL, 0x000000724818723cULL, 0x000fe20000001818ULL,
0x00000001077a7824ULL, 0x000fe200078e027aULL, 0xfffffff055567812ULL, 0x000fc400078ee254ULL,
0x0000ffff4f557812ULL, 0x000fe400078ec0ffULL, 0xfffffff057547812ULL, 0x000fe200078ee27aULL,
0x00000068480c723cULL, 0x000fe2000000180cULL, 0x00000009564c7c11ULL, 0x000fe4000f8e20ffULL,
0x0000000954547c11ULL, 0x000fe4000f8e20ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001164eULL,
0x0000006a4808723cULL, 0x000fe20000001808ULL, 0x000000004c4c783bULL, 0x000e620000000200ULL,
0x00000008ff687819ULL, 0x000fc4000001168aULL, 0x0000ffff58577812ULL, 0x040fe400078ec0ffULL,
0x0000006c4844723cULL, 0x000fe20000001844ULL, 0x00000010ff567819ULL, 0x000fe20000011658ULL,
0x000000005448783bULL, 0x000ea20000000200ULL, 0x000000ff588e7812ULL, 0x000fe400078ec0ffULL,
0x0000007fff7f723eULL, 0x000fe400020006ffULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x00000010ff587819ULL, 0x000fc40000011659ULL, 0x000000ff89697812ULL, 0x000fe400078ec0ffULL,
0x00000008ff6a7819ULL, 0x000fe40000011655ULL, 0x00000008ff6b7819ULL, 0x000fe40000011657ULL,
0x0000ffff597c7812ULL, 0x000fe400078ec0ffULL, 0x00000010ff7e7819ULL, 0x000fe4000001165aULL,
0x0000ffff5a727812ULL, 0x000fc400078ec0ffULL, 0x00000010ff707819ULL, 0x000fe4000001165bULL,
0x0000ffff5b717812ULL, 0x000fe400078ec0ffULL, 0x000000ff566c7812ULL, 0x000fe400078ec0ffULL,
0x00000018ff917819ULL, 0x000fe4000001165aULL, 0x000000ff5a737812ULL, 0x000fe400078ec0ffULL,
0x000054107f567816ULL, 0x000fc40000000068ULL, 0x00000018ff8f7819ULL, 0x000fe40000011659ULL,
0x00000081ff81723eULL, 0x000fe400020006ffULL, 0x0000008cff5a723eULL, 0x000fe400020006ffULL,
0x0000008eff64723eULL, 0x000fe400020006ffULL, 0x00000069ff69723eULL, 0x000fe400020006ffULL,
0x0000006aff6a723eULL, 0x000fc400020006ffULL, 0x0000006bff6b723eULL, 0x000fe400020006ffULL,
0x000000ff58687812ULL, 0x000fe400078ec0ffULL, 0x000000ff59907812ULL, 0x000fe400078ec0ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001165bULL, 0x000000ff5b6e7812ULL, 0x000fe400078ec0ffULL,
0x000000ff87877812ULL, 0x000fc400078ec0ffULL, 0x00000008ff887819ULL, 0x000fe40000011688ULL,
0x000000ff84847812ULL, 0x000fe400078ec0ffULL, 0x00000008ff857819ULL, 0x000fe40000011685ULL,
0x000000ff86867812ULL, 0x000fe400078ec0ffULL, 0x00000008ff7c7819ULL, 0x000fe4000001167cULL,
0x000000ff7e7e7812ULL, 0x000fc400078ec0ffULL, 0x00000008ff727819ULL, 0x000fe40000011672ULL,
0x000000ff70707812ULL, 0x000fe400078ec0ffULL, 0x00000008ff717819ULL, 0x000fe40000011671ULL,
0x0000007aff59723eULL, 0x000fe400020006ffULL, 0x0000008fff67723eULL, 0x000fe400020006ffULL,
0x0000541069577816ULL, 0x000fc40000000081ULL, 0x00000068ff68723eULL, 0x000fe400020006ffULL,
0x000054105a5a7816ULL, 0x000fe4000000006aULL, 0x0000541064647816ULL, 0x000fe2000000006bULL,
0x000000564c3c723cULL, 0x002fe2000000183cULL, 0x00000083ff83723eULL, 0x000fe400020006ffULL,
0x00000082ff82723eULL, 0x000fe400020006ffULL, 0x00000080ff80723eULL, 0x000fe200020006ffULL,
0x00000056481c723cULL, 0x004fe2000000181cULL, 0x0000008bff5b723eULL, 0x000fc400020006ffULL,
0x0000008dff65723eULL, 0x000fe400020006ffULL, 0x00000090ff66723eULL, 0x000fe400020006ffULL,
0x00000091ff7a723eULL, 0x000fe400020006ffULL, 0x00000073ff73723eULL, 0x000fe400020006ffULL,
0x0000006fff6f723eULL, 0x000fe400020006ffULL, 0x00000087ff87723eULL, 0x000fc400020006ffULL,
0x00000088ff88723eULL, 0x000fe400020006ffULL, 0x00000084ff84723eULL, 0x000fe400020006ffULL,
0x00000085ff85723eULL, 0x000fe400020006ffULL, 0x00000086ff86723eULL, 0x000fe400020006ffULL,
0x0000006cff6c723eULL, 0x000fe400020006ffULL, 0x0000007cff7c723eULL, 0x000fc400020006ffULL,
0x0000007eff69723eULL, 0x000fe400020006ffULL, 0x00000072ff72723eULL, 0x000fe400020006ffULL,
0x0000006eff6a723eULL, 0x000fe400020006ffULL, 0x00000070ff6b723eULL, 0x000fe400020006ffULL,
0x00000071ff71723eULL, 0x000fe400020006ffULL, 0x0000541068677816ULL, 0x000fc40000000067ULL,
0x0000541087557816ULL, 0x000fe40000000083ULL, 0x0000541082547816ULL, 0x000fe40000000088ULL,
0x0000541084597816ULL, 0x000fe40000000059ULL, 0x0000541080587816ULL, 0x000fe40000000085ULL,
0x00005410865b7816ULL, 0x000fe2000000005bULL, 0x000000544c40723cULL, 0x000fe20000001840ULL,
0x000054106c657816ULL, 0x000fc40000000065ULL, 0x0000541066667816ULL, 0x000fe4000000007cULL,
0x0000541069697816ULL, 0x000fe2000000007aULL, 0x000000584c38723cULL, 0x000fe20000001838ULL,
0x0000541073687816ULL, 0x000fe40000000072ULL, 0x000054106b6b7816ULL, 0x000fe4000000006fULL,
0x000054106a6a7816ULL, 0x000fe20000000071ULL, 0x0000005a4c34723cULL, 0x000fec0000001834ULL,
0x000000644c30723cULL, 0x000fec0000001830ULL, 0x000000664c2c723cULL, 0x000fec000000182cULL,
0x000000684c28723cULL, 0x000fec0000001828ULL, 0x0000006a4c24723cULL, 0x000fec0000001824ULL,
0x000000544820723cULL, 0x000fec0000001820ULL, 0x000000584818723cULL, 0x000fec0000001818ULL,
0x0000005a4814723cULL, 0x000fec0000001814ULL, 0x000000644810723cULL, 0x000fec0000001810ULL,
0x00000066480c723cULL, 0x000fec000000180cULL, 0x000000684808723cULL, 0x000fec0000001808ULL,
0x0000006a4844723cULL, 0x000fe20000001844ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffec00c40947ULL, 0x000fde000383ffffULL, 0x00000001ff4d7424ULL, 0x000fe400078e00ffULL,
0x0000005d40077220ULL, 0x080fe20000410000ULL, 0x0000005d20497220ULL, 0x080fe20000410000ULL,
0x0000005d41417220ULL, 0x080fe20000410000ULL, 0x0000005d42427220ULL, 0x080fe20000410000ULL,
0x0000005d43437220ULL, 0x080fe20000410000ULL, 0x01a6884d064c79a7ULL, 0x000262000850003fULL,
0x0000005d3c3c7220ULL, 0x080fe20000410000ULL, 0x0000005d3d3d7220ULL, 0x080fe20000410000ULL,
0x0000005d3e3e7220ULL, 0x080fe20000410000ULL, 0x0000005d3f3f7220ULL, 0x080fe20000410000ULL,
0x0000005d38387220ULL, 0x080fe20000410000ULL, 0x0000005d39397220ULL, 0x080fe20000410000ULL,
0x0000005d3a3a7220ULL, 0x080fe20000410000ULL, 0x0000005d3b3b7220ULL, 0x080fe20000410000ULL,
0x0000005d34347220ULL, 0x080fe20000410000ULL, 0x0000005d35357220ULL, 0x080fe20000410000ULL,
0x0000005d36367220ULL, 0x080fe20000410000ULL, 0x0000005d37377220ULL, 0x080fe20000410000ULL,
0x0000005d30307220ULL, 0x080fe20000410000ULL, 0x0000005d31317220ULL, 0x080fe20000410000ULL,
0x0000005d32327220ULL, 0x080fe20000410000ULL, 0x0000005d33337220ULL, 0x080fe20000410000ULL,
0x0000005d2c2c7220ULL, 0x080fe20000410000ULL, 0x0000005d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000005d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000005d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000005d28287220ULL, 0x080fe20000410000ULL, 0x0000005d29297220ULL, 0x080fe20000410000ULL,
0x0000005d2a2a7220ULL, 0x080fe20000410000ULL, 0x0000005d2b2b7220ULL, 0x080fe20000410000ULL,
0x0000005d24247220ULL, 0x080fe20000410000ULL, 0x0000005d25257220ULL, 0x080fe20000410000ULL,
0x0000005d26267220ULL, 0x080fe20000410000ULL, 0x0000005d27277220ULL, 0x080fe20000410000ULL,
0x0000005d21217220ULL, 0x080fe20000410000ULL, 0x0000005d22227220ULL, 0x080fe20000410000ULL,
0x0000005d23237220ULL, 0x080fe20000410000ULL, 0x0000005d1c1c7220ULL, 0x080fe20000410000ULL,
0x0000005d1d1d7220ULL, 0x080fe20000410000ULL, 0x0000005d1e1e7220ULL, 0x080fe20000410000ULL,
0x0000005d1f1f7220ULL, 0x080fe20000410000ULL, 0x0000005d18187220ULL, 0x080fe20000410000ULL,
0x0000005d19197220ULL, 0x080fe20000410000ULL, 0x0000005d1a1a7220ULL, 0x080fe20000410000ULL,
0x0000005d1b1b7220ULL, 0x080fe20000410000ULL, 0x0000005d14147220ULL, 0x080fe20000410000ULL,
0x0000005d15157220ULL, 0x080fe20000410000ULL, 0x0000005d16167220ULL, 0x080fe20000410000ULL,
0x0000005d17177220ULL, 0x080fe20000410000ULL, 0x0000005d10107220ULL, 0x080fe20000410000ULL,
0x0000005d11117220ULL, 0x080fe20000410000ULL, 0x0000005d12127220ULL, 0x080fe20000410000ULL,
0x0000005d13137220ULL, 0x080fe20000410000ULL, 0x0000005d0c0c7220ULL, 0x080fe20000410000ULL,
0x0000005d0d0d7220ULL, 0x080fe20000410000ULL, 0x0000005d0e0e7220ULL, 0x080fe20000410000ULL,
0x0000005d0f0f7220ULL, 0x080fe20000410000ULL, 0x0000005d08207220ULL, 0x080fe20000410000ULL,
0x0000005d09407220ULL, 0x080fe20000410000ULL, 0x0000005d0a487220ULL, 0x080fe20000410000ULL,
0x0000005d0b4a7220ULL, 0x080fe20000410000ULL, 0x0000005d44447220ULL, 0x080fe20000410000ULL,
0x0000005d45457220ULL, 0x080fe20000410000ULL, 0x0000005d46467220ULL, 0x080fe20000410000ULL,
0x0000005d47477220ULL, 0x002fce0000410000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x01a6884d060075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff4e7224ULL, 0x000fce00078e00ffULL, 0x000000104e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fce0000015200ULL,
0x000000080a4b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e0bULL,
0x003d09004b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000004b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000014e4e7836ULL, 0x000fce0000000000ULL, 0x01a6884d060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000404087824ULL, 0x000fe200078e00ffULL,
0x00000009634b7c11ULL, 0x000fe4000f8e38ffULL, 0x0000005e7600720cULL, 0x000fe40003f06070ULL,
0xfffffff008087812ULL, 0x000fca00078ec0ffULL, 0x000000014b4b7824ULL, 0x000fca00078e0208ULL,
0x01a400004b087984ULL, 0x0002a20000000c00ULL, 0x0000001c00c48947ULL, 0x000fea0003800000ULL,
0x00000100764d7824ULL, 0x000fe200078e0203ULL, 0x00000000044c7211ULL, 0x040fe200078ff0ffULL,
0x0000000204aa7824ULL, 0x000fe200078e00ffULL, 0x00008c00ff567b82ULL, 0x000ee20000000a00ULL,
0x00008600000a7ab9ULL, 0x000fe20000000800ULL, 0x0000004d74ac7248ULL, 0x000fe20007fe0000ULL,
0x000000084c4e7836ULL, 0x000fe20000000000ULL, 0x00000006aaaa7812ULL, 0x000fe200078ec0ffULL,
0x00008400000b7ab9ULL, 0x000fe20000000800ULL, 0x000000104c507836ULL, 0x000fe40000000000ULL,
0x00000001acac7824ULL, 0x000fe200078e0a4dULL, 0x0000000aff4d7c19ULL, 0x000fe2000801164cULL,
0x00000008aa4f7c36ULL, 0x000fe20008000000ULL, 0x0000000aff4e7c19ULL, 0x000fe2000801164eULL,
0x000000ffff607224ULL, 0x000fe200078e0aacULL, 0x000000054d4d7c48ULL, 0x000fe2000bfe0000ULL,
0x0000000baaa97c36ULL, 0x000fe20008000000ULL, 0x000000ac4f00720cULL, 0x000fe20003f26070ULL,
0x000000184c4c7836ULL, 0x000fe20000000000ULL, 0x000000054f4f7e46ULL, 0x000fe2000b800060ULL,
0x000000044d697c24ULL, 0x000fe2000f8e02ffULL, 0x000000054e4e7c48ULL, 0x000fc4000bfe0000ULL,
0x000000aca900720cULL, 0x000fe40003f06070ULL, 0x00000005a99a7e46ULL, 0x000fe2000b800060ULL,
0x000000044e6d7c24ULL, 0x000fe2000f8e02ffULL, 0x00000004ff4f7819ULL, 0x000fe4000001164fULL,
0x000000ff9a9a7207ULL, 0x000fe40000000000ULL, 0x000000ff4f4e7207ULL, 0x000fe40000800000ULL,
0x0000000aff507c19ULL, 0x000fc40008011650ULL, 0x0000000aff4c7c19ULL, 0x000fe2000801164cULL,
0x00000001695b7824ULL, 0x000fe200078e024eULL, 0x000000699a4d7211ULL, 0x040fe400078fe0ffULL,
0x0000000550507c48ULL, 0x000fe2000bfe0000ULL, 0x000000025b5a7825ULL, 0x108fe200078e0056ULL,
0x000000054c8b7c48ULL, 0x000fe4000bfe0000ULL, 0x0000006d9a957211ULL, 0x000fe200078fe0ffULL,
0x000000024d4c7825ULL, 0x000fe200078e0056ULL, 0x000000065aa87981ULL, 0x004ea6000c1e9500ULL,
0x00000004506b7c24ULL, 0x000fe2000f8e02ffULL, 0x000000064ca77981ULL, 0x0006a2000c1e9500ULL,
0x000000048b8b7c24ULL, 0x000fc4000f8e02ffULL, 0x000000014e537824ULL, 0x000fe200078e026bULL,
0x0000006b9a597211ULL, 0x000fe200078fe0ffULL, 0x000000014e4f7824ULL, 0x000fe200078e026dULL,
0x00000010aa857812ULL, 0x000fe200078efcffULL, 0x0000000295947825ULL, 0x000fc800078e0056ULL,
0x000000014e5f7824ULL, 0x000fe400078e028bULL, 0x00000002534c7825ULL, 0x10afe200078e0056ULL,
0x0000000694947981ULL, 0x0002e6000c1e9500ULL, 0x0000000259587825ULL, 0x100fe400078e0056ULL,
0x000000064c4c7981ULL, 0x000f64000c1e9500ULL, 0x000000024f4e7825ULL, 0x000fc400078e0056ULL,
0x0000000658957981ULL, 0x002f64000c1e9500ULL, 0x00000008855b7c36ULL, 0x000fe40008000000ULL,
0x000000064e977981ULL, 0x0002e2000c1e9500ULL, 0x0000008b9a557211ULL, 0x000fe200078fe0ffULL,
0x0000000b85867c36ULL, 0x000fe20008000000ULL, 0x000000055b507e46ULL, 0x000fe2000b800060ULL,
0x000000025f527825ULL, 0x000fe200078e0056ULL, 0x000000ac5b00720cULL, 0x080fe40003f26070ULL,
0x00000004ff507819ULL, 0x000fe20000011650ULL, 0x0000000255547825ULL, 0x000fe200078e0056ULL,
0x000000ac8600720cULL, 0x000fe20003f06070ULL, 0x0000000652527981ULL, 0x000ee2000c1e9500ULL,
0x0000000586987e46ULL, 0x000fc4000b800060ULL, 0x000000ff50507207ULL, 0x000fe20000800000ULL,
0x0000000654937981ULL, 0x0002e2000c1e9500ULL, 0x000000ff98987207ULL, 0x000fc60000000000ULL,
0x00000001698f7824ULL, 0x000fe200078e0250ULL, 0x0000006d984f7211ULL, 0x002fe200078fe0ffULL,
0x00000001508d7824ULL, 0x000fe200078e026dULL, 0x0000006998557211ULL, 0x000fe200078fe0ffULL,
0x000000028f8e7825ULL, 0x000fe200078e0056ULL, 0x00000020aa707812ULL, 0x000fc600078efcffULL,
0x000000028d8c7825ULL, 0x100fe400078e0056ULL, 0x000000068e8e7981ULL, 0x000ee4000c1e9500ULL,
0x0000000255547825ULL, 0x100fe400078e0056ULL, 0x000000068c8c7981ULL, 0x000ee4000c1e9500ULL,
0x000000024f4e7825ULL, 0x000fe400078e0056ULL, 0x0000000654897981ULL, 0x0002e4000c1e9500ULL,
0x00000008705f7c36ULL, 0x000fc40008000000ULL, 0x000000064e877981ULL, 0x0002e2000c1e9500ULL,
0x0000000b70717c36ULL, 0x000fe20008000000ULL, 0x0000006b985b7211ULL, 0x000fe200078fe0ffULL,
0x00000001504d7824ULL, 0x000fe200078e026bULL, 0x0000008b98597211ULL, 0x000fe200078fe0ffULL,
0x0000000150537824ULL, 0x000fe200078e028bULL, 0x000000055f647e46ULL, 0x000fe2000b800060ULL,
0x000000025b5a7825ULL, 0x100fe200078e0056ULL, 0x000000ac7100720cULL, 0x080fe40003f06070ULL,
0x0000000571507e46ULL, 0x000fe2000b800060ULL, 0x0000000259587825ULL, 0x000fe200078e0056ULL,
0x000000ac5f00720cULL, 0x000fe20003f26070ULL, 0x000000065a8a7981ULL, 0x0002e2000c1e9500ULL,
0x00000004ff647819ULL, 0x000fe20000011664ULL, 0x000000024d547825ULL, 0x102fe200078e0056ULL,
0x000000ff50507207ULL, 0x000fe20000000000ULL, 0x0000000658887981ULL, 0x000ee4000c1e9500ULL,
0x00000002534e7825ULL, 0x000fe200078e0056ULL, 0x000000ff64647207ULL, 0x000fe20000800000ULL,
0x00000006544d7981ULL, 0x000ee2000c1e9500ULL, 0x0000006d50737211ULL, 0x000fc600078fe0ffULL,
0x000000064e537981ULL, 0x0002e2000c1e9500ULL, 0x00000001645b7824ULL, 0x000fe400078e026dULL,
0x0000000273727825ULL, 0x000fc800078e0056ULL, 0x000000025b5a7825ULL, 0x000fe400078e0056ULL,
0x0000000672727981ULL, 0x000ee2000c1e9500ULL, 0x00000069504f7211ULL, 0x042fe200078fe0ffULL,
0x0000000169597824ULL, 0x000fe400078e0264ULL, 0x000000065a7f7981ULL, 0x000ee4000c1e9500ULL,
0x000000024f4e7825ULL, 0x000fe200078e0056ULL, 0x0000006b50677211ULL, 0x000fc600078fe0ffULL,
0x0000000259587825ULL, 0x000fe200078e0056ULL, 0x0000008b50657211ULL, 0x000fe200078fe0ffULL,
0x000000064e7a7981ULL, 0x0002e4000c1e9500ULL, 0x0000000164557824ULL, 0x040fe400078e026bULL,
0x00000001645f7824ULL, 0x000fe200078e028bULL, 0x0000000658817981ULL, 0x0002e2000c1e9500ULL,
0x0000000267667825ULL, 0x000fc800078e0056ULL, 0x00000002554e7825ULL, 0x102fe200078e0056ULL,
0x0000000666757981ULL, 0x000ee6000c1e9500ULL, 0x000000025f547825ULL, 0x100fe200078e0056ULL,
0x00000030aa587812ULL, 0x000fe200078efcffULL, 0x000000064e4e7981ULL, 0x000ee4000c1e9500ULL,
0x0000000265647825ULL, 0x000fe400078e0056ULL, 0x0000000654547981ULL, 0x000ee4000c1e9500ULL,
0x0000000858597c36ULL, 0x000fc40008000000ULL, 0x0000000664737981ULL, 0x0002e2000c1e9500ULL,
0x0000000b585f7c36ULL, 0x000fe40008000000ULL, 0x0000000559687e46ULL, 0x000fe4000b800060ULL,
0x000000ac5900720cULL, 0x080fe40003f26070ULL, 0x000000ac5f00720cULL, 0x000fe40003f06070ULL,
0x000000055f967e46ULL, 0x000fe4000b800060ULL, 0x00000004ff687819ULL, 0x000fc40000011668ULL,
0x000000ff96967207ULL, 0x000fe40000000000ULL, 0x000000ff68607207ULL, 0x000fe40000800000ULL,
0x0000006996657211ULL, 0x042fe400078fe0ffULL, 0x0000006b966f7211ULL, 0x000fe200078fe0ffULL,
0x00000001695b7824ULL, 0x000fe400078e0260ULL, 0x00000001606b7824ULL, 0x000fe400078e026bULL,
0x0000000265647825ULL, 0x000fc800078e0056ULL, 0x000000025b5a7825ULL, 0x100fe200078e0056ULL,
0x0000000664687981ULL, 0x0002e6000c1e9500ULL, 0x000000026f6e7825ULL, 0x100fe200078e0056ULL,
0x000000065a697981ULL, 0x0002e6000c1e9500ULL, 0x000000026b6a7825ULL, 0x000fe200078e0056ULL,
0x000000066e647981ULL, 0x002ee2000c1e9500ULL, 0x0000006d96837211ULL, 0x000fc600078fe0ffULL,
0x000000066a4f7981ULL, 0x000ee2000c1e9500ULL, 0x00000001606d7824ULL, 0x000fe400078e026dULL,
0x0000000283827825ULL, 0x000fc800078e0056ULL, 0x000000026d6c7825ULL, 0x000fe200078e0056ULL,
0x0000000682667981ULL, 0x0002e2000c1e9500ULL, 0x0000008b965b7211ULL, 0x000fc600078fe0ffULL,
0x000000066c677981ULL, 0x0002e2000c1e9500ULL, 0x00000001608b7824ULL, 0x000fe400078e028bULL,
0x000000025b5a7825ULL, 0x000fc800078e0056ULL, 0x000000028b567825ULL, 0x000fe200078e0056ULL,
0x000000065a607981ULL, 0x000ee8000c1e9500ULL, 0x0000000656657981ULL, 0x0002e2000c1e9500ULL,
0xfffffff09a9b7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff997424ULL, 0x000fc800078e00ffULL,
0x00000001ac9a7824ULL, 0x000fc800078e029bULL, 0x00000001a9a67824ULL, 0x000fe200078e0a9aULL,
0x00000001aa917812ULL, 0x000fc800078efcffULL, 0x000000a699a67219ULL, 0x000fe200000006ffULL,
0x0000000b91927c36ULL, 0x000fe20008000000ULL, 0xfffffff096a17812ULL, 0x000fc600078ec0ffULL,
0x0000000192967824ULL, 0x100fe200078e0a9aULL, 0x00000008aa8d7812ULL, 0x040fe400078efcffULL,
0x00000009aa8b7812ULL, 0x000fe400078efcffULL, 0x0000009699967219ULL, 0x000fe200000006ffULL,
0x0000000b8d907c36ULL, 0x000fe40008000000ULL, 0x0000000b8b8f7c36ULL, 0x000fe20008000000ULL,
0xfffffff0989d7812ULL, 0x000fe200078ec0ffULL, 0x0000000190987824ULL, 0x000fc400078e0a9aULL,
0x000000018f9a7824ULL, 0x000fe200078e0a9aULL, 0x00000011aa837812ULL, 0x042fe400078efcffULL,
0x0000009899987219ULL, 0x040fe400000006ffULL, 0x0000009a999a7219ULL, 0x000fe200000006ffULL,
0x0000000b83847c36ULL, 0x000fe20008000000ULL, 0x00000018aa7e7812ULL, 0x000fe200078efcffULL,
0x00000001ac9b7824ULL, 0x000fe200078e029dULL, 0x00000019aa7c7812ULL, 0x000fc600078efcffULL,
0x0000000b7e827c36ULL, 0x000fe40008000000ULL, 0x0000000b7c807c36ULL, 0x000fe40008000000ULL,
0x0000000186b87824ULL, 0x100fe400078e0a9bULL, 0x00000001849c7824ULL, 0x100fe400078e0a9bULL,
0x0000000182b67824ULL, 0x100fe400078e0a9bULL, 0x00000001809e7824ULL, 0x000fe200078e0a9bULL,
0x00005410a7a77816ULL, 0x004fc800000000a8ULL, 0x000000a7a6ff7212ULL, 0x000fc800078ac0ffULL,
0x000000aca900720cULL, 0x000fc80002fa1470ULL, 0x000000acaa00720cULL, 0x000fe40002fa1070ULL,
0x000000a796ff7212ULL, 0x000fe4000782c0ffULL, 0xff80000007077808ULL, 0x000fe40002800000ULL,
0x0000541095957816ULL, 0x020fe4000000004cULL, 0x0000541094977816ULL, 0x008fe40000000097ULL,
0x00000095a6ff7212ULL, 0x000fc4000788c0ffULL, 0x00000097a6ff7212ULL, 0x080fe4000784c0ffULL,
0x0000009796ff7212ULL, 0x000fe400078ac0ffULL, 0x000000aca900720cULL, 0x0c0fe40001741470ULL,
0x000000aca900720cULL, 0x080fe40002781470ULL, 0x000000ac9200720cULL, 0x0c0fe40000f21470ULL,
0x000000ac9200720cULL, 0x000fc40002fa1470ULL, 0x000000acaa00720cULL, 0x0c0fe40001741070ULL,
0x000000acaa00720cULL, 0x080fe40002781070ULL, 0x000000ac9100720cULL, 0x0c0fe40000f21070ULL,
0x000000ac9100720cULL, 0x000fe40002fa1070ULL, 0x0000541093937816ULL, 0x000fe40000000052ULL,
0xff80000042427808ULL, 0x000fc40001000000ULL, 0xff80000049497808ULL, 0x000fe40002000000ULL,
0xff80000041417808ULL, 0x000fe40000800000ULL, 0xff80000043437808ULL, 0x000fe40002800000ULL,
0x000000a798ff7212ULL, 0x000fe4000786c0ffULL, 0x00000093a6ff7212ULL, 0x000fe4000780c0ffULL,
0x0000009596ff7212ULL, 0x000fc4000784c0ffULL, 0x0000009396ff7212ULL, 0x000fe4000788c0ffULL,
0x000000979aff7212ULL, 0x000fe4000782c0ffULL, 0x0000009598ff7212ULL, 0x000fe400078ac0ffULL,
0x000000aca900720cULL, 0x080fe40000701470ULL, 0x000000ac9200720cULL, 0x0c0fe40001741470ULL,
0x000000ac9200720cULL, 0x000fc40002781470ULL, 0x000000ac9000720cULL, 0x0c0fe40001f61470ULL,
0x000000ac9000720cULL, 0x080fe40002fa1470ULL, 0x000000ac8f00720cULL, 0x080fe40000f21470ULL,
0x000000acaa00720cULL, 0x080fe40000701070ULL, 0x000000ac9100720cULL, 0x0c0fe40001741070ULL,
0x000000ac9100720cULL, 0x000fc40002781070ULL, 0x000000ac8d00720cULL, 0x0c0fe40001f61070ULL,
0x000000ac8d00720cULL, 0x080fe40002fa1070ULL, 0x000000ac8b00720cULL, 0x000fe40000f21070ULL,
0x000000b8999b7219ULL, 0x040fe400000006ffULL, 0x0000009c999c7219ULL, 0x000fe400000006ffULL,
0x0000541089897816ULL, 0x000fc4000000008eULL, 0x0000541087877816ULL, 0x000fe4000000008cULL,
0xff80000022227808ULL, 0x000fe40000000000ULL, 0xff80000021217808ULL, 0x000fe40001000000ULL,
0xff80000023237808ULL, 0x000fe40002000000ULL, 0xff8000003c3c7808ULL, 0x000fe40001800000ULL,
0xff8000001c1c7808ULL, 0x000fc40002800000ULL, 0xff8000003f3f7808ULL, 0x000fe40000800000ULL,
0x0000009798ff7212ULL, 0x000fe4000780c0ffULL, 0x000000959aff7212ULL, 0x000fe4000784c0ffULL,
0x0000009398ff7212ULL, 0x080fe4000788c0ffULL, 0x000000939aff7212ULL, 0x000fe4000786c0ffULL,
0x000000899cff7212ULL, 0x000fc400078ac0ffULL, 0x000000879bff7212ULL, 0x000fe4000782c0ffULL,
0x000000ac9000720cULL, 0x0c0fe40000701470ULL, 0x000000ac9000720cULL, 0x080fe40002781470ULL,
0x000000ac8f00720cULL, 0x0c0fe40001741470ULL, 0x000000ac8f00720cULL, 0x080fe40001f61470ULL,
0x000000ac8600720cULL, 0x000fc40000f21470ULL, 0x000000ac8400720cULL, 0x080fe40002fa1470ULL,
0xfffffff0509f7812ULL, 0x000fe400078ec0ffULL, 0x000000ac8d00720cULL, 0x0c0fe40000701070ULL,
0x000000ac8d00720cULL, 0x080fe40002781070ULL, 0x000000ac8b00720cULL, 0x0c0fe40001741070ULL,
0x000000ac8b00720cULL, 0x000fc40001f61070ULL, 0x000000ac8500720cULL, 0x080fe40000f21070ULL,
0x000000ac8300720cULL, 0x000fe40002fa1070ULL, 0x000000b6999d7219ULL, 0x040fe400000006ffULL,
0x0000009e999e7219ULL, 0x000fe400000006ffULL, 0x000054108a4d7816ULL, 0x000fe4000000004dULL,
0x0000541088537816ULL, 0x000fe20000000053ULL, 0x00000001aca27824ULL, 0x000fe200078e029fULL,
0xff8000003e3e7808ULL, 0x000fc40000000000ULL, 0xff8000001e1e7808ULL, 0x000fe40002000000ULL,
0xff8000001d1d7808ULL, 0x000fe40001000000ULL, 0xff8000001f1f7808ULL, 0x000fe40001800000ULL,
0xff8000003a3a7808ULL, 0x000fe40000800000ULL, 0xff80000039397808ULL, 0x000fe40002800000ULL,
0x000000899bff7212ULL, 0x000fc4000780c0ffULL, 0x000000899dff7212ULL, 0x000fe4000788c0ffULL,
0x0000004d9bff7212ULL, 0x040fe4000784c0ffULL, 0x000000539bff7212ULL, 0x000fe4000786c0ffULL,
0x0000004d9cff7212ULL, 0x000fe4000782c0ffULL, 0x000000879eff7212ULL, 0x000fe200078ac0ffULL,
0x0000000171b47824ULL, 0x000fe200078e0aa2ULL, 0x000000ac8600720cULL, 0x000fc40000701470ULL,
0x000000ac8600720cULL, 0x0c0fe40001741470ULL, 0x000000ac8600720cULL, 0x080fe40001f61470ULL,
0x000000ac8400720cULL, 0x080fe40000f21470ULL, 0x000000ac8200720cULL, 0x080fe40002781470ULL,
0x000000ac8000720cULL, 0x000fe40002fa1470ULL, 0x00000021aa6e7812ULL, 0x000fc400078efcffULL,
0x000000ac8500720cULL, 0x0c0fe40000701070ULL, 0x000000ac8500720cULL, 0x0c0fe40001741070ULL,
0x000000ac8500720cULL, 0x080fe40001f61070ULL, 0x000000ac8300720cULL, 0x080fe40000f21070ULL,
0x000000ac7e00720cULL, 0x080fe40002781070ULL, 0x000000ac7c00720cULL, 0x000fc40002fa1070ULL,
0x000000b4999f7219ULL, 0x000fe400000006ffULL, 0x0000541072727816ULL, 0x000fe2000000007fULL,
0x0000000b6e6f7c36ULL, 0x000fe20008000000ULL, 0xff80000038387808ULL, 0x000fe40000000000ULL,
0xff80000018187808ULL, 0x000fe40001000000ULL, 0xff8000001a1a7808ULL, 0x000fe40001800000ULL,
0xff80000019197808ULL, 0x000fc40000800000ULL, 0xff80000034347808ULL, 0x000fe40002000000ULL,
0xff80000037377808ULL, 0x000fe40002800000ULL, 0x000000879cff7212ULL, 0x040fe4000780c0ffULL,
0x000000539cff7212ULL, 0x000fe4000784c0ffULL, 0x000000879dff7212ULL, 0x000fe4000786c0ffULL,
0x0000004d9eff7212ULL, 0x000fc4000782c0ffULL, 0x000000539eff7212ULL, 0x000fe4000788c0ffULL,
0x000000729fff7212ULL, 0x000fe200078ac0ffULL, 0x000000016fa07824ULL, 0x000fe200078e0aa2ULL,
0x000000ac8400720cULL, 0x0c0fe40000701470ULL, 0x000000ac8400720cULL, 0x080fe40001741470ULL,
0x000000ac8200720cULL, 0x080fe40001f61470ULL, 0x000000ac8000720cULL, 0x000fc40000f21470ULL,
0x000000ac8000720cULL, 0x080fe40002781470ULL, 0x000000ac7100720cULL, 0x080fe40002fa1470ULL,
0x00000028aa6b7812ULL, 0x040fe400078efcffULL, 0x00000029aa6a7812ULL, 0x000fe400078efcffULL,
0x000000ac8300720cULL, 0x0c0fe40000701070ULL, 0x000000ac8300720cULL, 0x000fc40001741070ULL,
0x000000ac7e00720cULL, 0x080fe40001f61070ULL, 0x000000ac7c00720cULL, 0x0c0fe40000f21070ULL,
0x000000ac7c00720cULL, 0x080fe40002781070ULL, 0x000000ac7000720cULL, 0x000fe40002fa1070ULL,
0x000000a099a07219ULL, 0x000fe400000006ffULL, 0x000054107a7a7816ULL, 0x000fc40000000081ULL,
0x00005410754e7816ULL, 0x000fe4000000004eULL, 0x0000541073547816ULL, 0x000fe20000000054ULL,
0x0000000b6b6d7c36ULL, 0x000fe20008000000ULL, 0xff8000003b3b7808ULL, 0x000fe20000000000ULL,
0x0000000b6a6c7c36ULL, 0x000fe20008000000ULL, 0xff8000001b1b7808ULL, 0x000fe40001000000ULL,
0xff80000036367808ULL, 0x000fe40001800000ULL, 0xff80000015157808ULL, 0x000fc40000800000ULL,
0xff80000017177808ULL, 0x000fe40002000000ULL, 0xff80000032327808ULL, 0x000fe40002800000ULL,
0x000000a79aff7212ULL, 0x000fe400078cc0ffULL, 0x0000004d9dff7212ULL, 0x040fe4000780c0ffULL,
0x000000539dff7212ULL, 0x000fe4000784c0ffULL, 0x0000007a9fff7212ULL, 0x000fc4000786c0ffULL,
0x0000004e9fff7212ULL, 0x040fe4000782c0ffULL, 0x000000549fff7212ULL, 0x000fe4000788c0ffULL,
0x0000004ea0ff7212ULL, 0x000fe200078ac0ffULL, 0x000000016db27824ULL, 0x100fe200078e0aa2ULL,
0x000000ac8f00720cULL, 0x080fe200037c1470ULL, 0x000000016ca27824ULL, 0x000fe200078e0aa2ULL,
0x000000ac8200720cULL, 0x0c0fe40000701470ULL, 0x000000ac8200720cULL, 0x000fc40001741470ULL,
0x000000ac7100720cULL, 0x0c0fe40001f61470ULL, 0x000000ac7100720cULL, 0x0c0fe40000f21470ULL,
0x000000ac7100720cULL, 0x080fe40002781470ULL, 0x000000ac6f00720cULL, 0x080fe20002fa1470ULL,
0x00000001ac507824ULL, 0x000fe200078e02a1ULL, 0x000000ac8b00720cULL, 0x080fe400037c1070ULL,
0x000000ac7e00720cULL, 0x000fc40000701070ULL, 0x000000ac7e00720cULL, 0x080fe40001741070ULL,
0x000000ac7000720cULL, 0x0c0fe40001f61070ULL, 0x000000ac7000720cULL, 0x0c0fe40000f21070ULL,
0x000000ac7000720cULL, 0x080fe40002781070ULL, 0x000000ac6e00720cULL, 0x000fe40002fa1070ULL,
0x000000b299a17219ULL, 0x000fc400000006ffULL, 0x000000a299a27219ULL, 0x000fe400000006ffULL,
0xff8000003d3d7808ULL, 0x000fe40003000000ULL, 0xff80000014147808ULL, 0x000fe40000000000ULL,
0xff80000016167808ULL, 0x000fe40001000000ULL, 0xff80000030307808ULL, 0x000fe40001800000ULL,
0xff80000010107808ULL, 0x000fc40000800000ULL, 0xff80000012127808ULL, 0x000fe40002000000ULL,
0xff80000011117808ULL, 0x000fe40002800000ULL, 0x000000899eff7212ULL, 0x000fe400078cc0ffULL,
0x0000007aa0ff7212ULL, 0x0c0fe4000780c0ffULL, 0x0000007aa1ff7212ULL, 0x000fe4000784c0ffULL,
0x00000072a0ff7212ULL, 0x000fc4000786c0ffULL, 0x00000054a0ff7212ULL, 0x000fe4000782c0ffULL,
0x00000072a1ff7212ULL, 0x000fe4000788c0ffULL, 0x0000004ea2ff7212ULL, 0x000fe200078ac0ffULL,
0x000000015fb07824ULL, 0x000fe200078e0a50ULL, 0x000000ac8000720cULL, 0x080fe400037c1470ULL,
0x000000ac6f00720cULL, 0x0c0fe40000701470ULL, 0x000000ac6f00720cULL, 0x000fc40001f61470ULL,
0x000000ac6f00720cULL, 0x080fe40000f21470ULL, 0x000000ac6d00720cULL, 0x0c0fe40001741470ULL,
0x000000ac6d00720cULL, 0x080fe40002781470ULL, 0x000000ac6c00720cULL, 0x000fe40002fa1470ULL,
0x00000031aa577812ULL, 0x040fe400078efcffULL, 0x00000038aa567812ULL, 0x000fc400078efcffULL,
0x00000039aa557812ULL, 0x000fe400078efcffULL, 0x000000ac7c00720cULL, 0x080fe400037c1070ULL,
0x000000ac6e00720cULL, 0x0c0fe40000701070ULL, 0x000000ac6e00720cULL, 0x0c0fe40001f61070ULL,
0x000000ac6e00720cULL, 0x080fe40000f21070ULL, 0x000000ac6b00720cULL, 0x000fc40001741070ULL,
0x000000ac6b00720cULL, 0x080fe40002781070ULL, 0x000000ac6a00720cULL, 0x000fe40002fa1070ULL,
0x000000b099a37219ULL, 0x000fe400000006ffULL, 0x0000541068687816ULL, 0x000fe40000000069ULL,
0x00005410644f7816ULL, 0x000fe2000000004fULL, 0x0000000b575b7c36ULL, 0x000fe20008000000ULL,
0xff80000035357808ULL, 0x000fe20003000000ULL, 0x0000000b565a7c36ULL, 0x000fe20008000000ULL,
0xff80000031317808ULL, 0x000fe20000000000ULL, 0x0000000b55597c36ULL, 0x000fe20008000000ULL,
0xff80000033337808ULL, 0x000fc40001800000ULL, 0xff80000013137808ULL, 0x000fe40000800000ULL,
0xff8000002c2c7808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40002000000ULL,
0xff8000000d0d7808ULL, 0x000fe40002800000ULL, 0x0000007aa2ff7212ULL, 0x040fe400078cc0ffULL,
0x00000072a2ff7212ULL, 0x000fc4000780c0ffULL, 0x0000004ea1ff7212ULL, 0x040fe4000786c0ffULL,
0x00000054a1ff7212ULL, 0x080fe4000782c0ffULL, 0x00000054a2ff7212ULL, 0x000fe4000784c0ffULL,
0x00000068a3ff7212ULL, 0x040fe4000788c0ffULL, 0x0000004fa3ff7212ULL, 0x000fe200078ac0ffULL,
0x000000015ba47824ULL, 0x100fe200078e0a50ULL, 0x000000ac6d00720cULL, 0x0c0fe20001f61470ULL,
0x000000015aae7824ULL, 0x100fe200078e0a50ULL, 0x000000ac6d00720cULL, 0x080fe20000f21470ULL,
0x0000000159507824ULL, 0x000fe200078e0a50ULL, 0x000000ac6c00720cULL, 0x000fc400037c1470ULL,
0x000000ac6c00720cULL, 0x0c0fe40000701470ULL, 0x000000ac6c00720cULL, 0x080fe40001741470ULL,
0x000000ac5f00720cULL, 0x0c0fe40002781470ULL, 0x000000ac5f00720cULL, 0x080fe40002fa1470ULL,
0x000000ac6b00720cULL, 0x0c0fe40001f61070ULL, 0x000000ac6b00720cULL, 0x000fc40000f21070ULL,
0x000000ac6a00720cULL, 0x0c0fe400037c1070ULL, 0x000000ac6a00720cULL, 0x0c0fe40000701070ULL,
0x000000ac6a00720cULL, 0x080fe40001741070ULL, 0x000000ac5800720cULL, 0x0c0fe40002781070ULL,
0x000000ac5800720cULL, 0x000fe40002fa1070ULL, 0x000000a499a47219ULL, 0x000fc400000006ffULL,
0x000000ae99a57219ULL, 0x040fe400000006ffULL, 0x0000005099507219ULL, 0x000fe400000006ffULL,
0x0000541066667816ULL, 0x000fe40000000067ULL, 0xff8000000c0c7808ULL, 0x000fe40001800000ULL,
0xff8000000e0e7808ULL, 0x000fe40000800000ULL, 0xff8000002d2d7808ULL, 0x000fc40003000000ULL,
0xff8000002f2f7808ULL, 0x000fe40000000000ULL, 0xff8000000f0f7808ULL, 0x000fe40001000000ULL,
0xff80000028287808ULL, 0x000fe40002000000ULL, 0xff80000020207808ULL, 0x000fe40002800000ULL,
0x00000068a4ff7212ULL, 0x080fe4000786c0ffULL, 0x00000068a5ff7212ULL, 0x000fc4000782c0ffULL,
0x0000006850ff7212ULL, 0x000fe400078cc0ffULL, 0x00000066a3ff7212ULL, 0x080fe4000780c0ffULL,
0x00000066a4ff7212ULL, 0x0c0fe4000784c0ffULL, 0x00000066a5ff7212ULL, 0x000fe4000788c0ffULL,
0x0000004fa4ff7212ULL, 0x000fe400078ac0ffULL, 0x000000ac5f00720cULL, 0x000fc40000701470ULL,
0x000000ac5b00720cULL, 0x0c0fe40001f61470ULL, 0x000000ac5b00720cULL, 0x0c0fe40001741470ULL,
0x000000ac5b00720cULL, 0x080fe40002fa1470ULL, 0x000000ac5a00720cULL, 0x0c0fe40000f21470ULL,
0x000000ac5900720cULL, 0x080fe400037c1470ULL, 0x000000ac5a00720cULL, 0x000fc40002781470ULL,
0x000000ac5800720cULL, 0x080fe40000701070ULL, 0x000000ac5700720cULL, 0x0c0fe40001f61070ULL,
0x000000ac5700720cULL, 0x0c0fe40001741070ULL, 0x000000ac5700720cULL, 0x080fe40002fa1070ULL,
0x000000ac5600720cULL, 0x080fe40000f21070ULL, 0x000000ac5500720cULL, 0x000fc400037c1070ULL,
0x000000ac5600720cULL, 0x000fe40002781070ULL, 0x0000541060607816ULL, 0x000fe40000000065ULL,
0xff8000002a2a7808ULL, 0x000fe40000000000ULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff8000002b2b7808ULL, 0x000fe40001000000ULL, 0xff80000040407808ULL, 0x000fc40002800000ULL,
0xff80000024247808ULL, 0x000fe40000800000ULL, 0xff80000025257808ULL, 0x000fe40003000000ULL,
0xff80000026267808ULL, 0x000fe40002000000ULL, 0x0000006650ff7212ULL, 0x040fe4000780c0ffULL,
0x0000004fa5ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004f50ff7212ULL, 0x000fc4000784c0ffULL,
0x00000060a3ff7212ULL, 0x080fe400078ac0ffULL, 0x00000060a4ff7212ULL, 0x080fe4000782c0ffULL,
0x00000060a5ff7212ULL, 0x080fe400078cc0ffULL, 0x0000006050ff7212ULL, 0x000fe4000788c0ffULL,
0x000000ac5f00720cULL, 0x080fe40002fa1470ULL, 0x000000ac5b00720cULL, 0x000fc40000f21470ULL,
0x000000ac5a00720cULL, 0x0c0fe40001f61470ULL, 0x000000ac5a00720cULL, 0x080fe400037c1470ULL,
0x000000ac5900720cULL, 0x0c0fe40000701470ULL, 0x000000ac5900720cULL, 0x0c0fe40001741470ULL,
0x000000ac5900720cULL, 0x080fe40002781470ULL, 0x000000ac5800720cULL, 0x000fc40002fa1070ULL,
0x000000ac5700720cULL, 0x080fe40000f21070ULL, 0x000000ac5500720cULL, 0x0c0fe40000701070ULL,
0x000000ac5600720cULL, 0x0c0fe40001f61070ULL, 0x000000ac5600720cULL, 0x080fe400037c1070ULL,
0x000000ac5500720cULL, 0x0c0fe40001741070ULL, 0x000000ac5500720cULL, 0x000fc40002781070ULL,
0xff80000027277808ULL, 0x000fe40000000000ULL, 0xff80000044447808ULL, 0x000fe40001800000ULL,
0xff80000045457808ULL, 0x000fe40001000000ULL, 0xff80000048487808ULL, 0x000fe40002800000ULL,
0xff8000004a4a7808ULL, 0x000fe40000800000ULL, 0xff80000046467808ULL, 0x000fc40003000000ULL,
0xff80000047477808ULL, 0x000fce0002000000ULL, 0x000000070800720bULL, 0x004fe20003f1e000ULL,
0x0000000176767836ULL, 0x000fe20000000000ULL, 0xfffffff8ff517812ULL, 0x000fe400078ee251ULL,
0x0000000807087208ULL, 0x000fc80004000000ULL, 0x000000410800720bULL, 0x000fc80003f1e000ULL,
0x00000008414d7208ULL, 0x000fc80004000000ULL, 0x0000003c4d00720bULL, 0x000fc80003f1e000ULL,
0x0000004d3c087208ULL, 0x000fc80004000000ULL, 0x0000003d0800720bULL, 0x000fc80003f1e000ULL,
0x000000083d4d7208ULL, 0x000fc80004000000ULL, 0x000000384d00720bULL, 0x000fc80003f1e000ULL,
0x0000004d38087208ULL, 0x000fc80004000000ULL, 0x000000390800720bULL, 0x000fc80003f1e000ULL,
0x00000008394d7208ULL, 0x000fc80004000000ULL, 0x000000344d00720bULL, 0x000fc80003f1e000ULL,
0x0000004d34087208ULL, 0x000fc80004000000ULL, 0x000000350800720bULL, 0x000fc80003f1e000ULL,
0x00000008354d7208ULL, 0x000fc80004000000ULL, 0x000000304d00720bULL, 0x000fc80003f1e000ULL,
0x0000004d30087208ULL, 0x000fc80004000000ULL, 0x000000310800720bULL, 0x000fc80003f1e000ULL,
0x00000008314d7208ULL, 0x000fc80004000000ULL, 0x0000002c4d00720bULL, 0x000fc80003f1e000ULL,
0x0000004d2c087208ULL, 0x000fc80004000000ULL, 0x0000002d0800720bULL, 0x000fc80003f1e000ULL,
0x000000082d4d7208ULL, 0x000fc80004000000ULL, 0x000000284d00720bULL, 0x000fc80003f1e000ULL,
0x0000004d28087208ULL, 0x000fc80004000000ULL, 0x000000290800720bULL, 0x000fc80003f1e000ULL,
0x00000008294d7208ULL, 0x000fc80004000000ULL, 0x000000244d00720bULL, 0x000fc80003f1e000ULL,
0x0000004d24087208ULL, 0x000fe40004000000ULL, 0x000000420900720bULL, 0x000fe40003f1e000ULL,
0x000000250800720bULL, 0x000fc80003f3e000ULL, 0x00000008254c7208ULL, 0x000fe40004800000ULL,
0x0000000942087208ULL, 0x000fc60004000000ULL, 0x0c401f004c4d7f89ULL, 0x000ea200000e0000ULL,
0x000000430800720bULL, 0x000fc80003f1e000ULL, 0x0000000843097208ULL, 0x000fc80004000000ULL,
0x0000003e0900720bULL, 0x000fc80003f1e000ULL, 0x000000093e087208ULL, 0x000fc80004000000ULL,
0x0000003f0800720bULL, 0x000fc80003f1e000ULL, 0x000000083f097208ULL, 0x000fe40004000000ULL,
0x0000004d4c00720bULL, 0x004fe40003f3e000ULL, 0x0000003a0900720bULL, 0x000fe40003f1e000ULL,
0x0000004c4d4d7208ULL, 0x000fe40004800000ULL, 0x000000093a087208ULL, 0x000fc60004000000ULL,
0x0c201f004d4c7f89ULL, 0x000ea200000e0000ULL, 0x0000003b0800720bULL, 0x000fc80003f1e000ULL,
0x000000083b097208ULL, 0x000fc80004000000ULL, 0x000000360900720bULL, 0x000fc80003f1e000ULL,
0x0000000936087208ULL, 0x000fc80004000000ULL, 0x000000370800720bULL, 0x000fc80003f1e000ULL,
0x0000000837097208ULL, 0x000fe40004000000ULL, 0x0000004c4d00720bULL, 0x004fe40003f3e000ULL,
0x000000320900720bULL, 0x000fe40003f1e000ULL, 0x0000004d4c087208ULL, 0x000fe40004800000ULL,
0x00000009324c7208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b08547820ULL, 0x000fe20000410000ULL,
0x000000334c00720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b07097823ULL, 0x100fe20000010854ULL,
0x0000004c33077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3c4d7823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b35507823ULL, 0x100fe20000010854ULL, 0x00000009004c7308ULL, 0x0005e20000000800ULL,
0x0000002e0700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b25357823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b39397823ULL, 0x000fe20000010854ULL,
0x000000072e4e7208ULL, 0x000fc60004000000ULL, 0x0000004d004d7308ULL, 0x000fe20000000800ULL,
0x0000002f4e00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b38097823ULL, 0x004fc60000010854ULL,
0x0000004e2f077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3d4e7823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b343d7823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b24347823ULL, 0x000fe20000010854ULL,
0x0000002a0700720bULL, 0x000fe20003f1e000ULL, 0x0000004100417308ULL, 0x000fe60000000800ULL,
0x000000072a3c7208ULL, 0x000fc80004000000ULL, 0x0000002b3c00720bULL, 0x000fe20003f1e000ULL,
0x0000004e004e7308ULL, 0x000fe60000000800ULL, 0x0000003c2b077208ULL, 0x000fc80004000000ULL,
0x000000260700720bULL, 0x000fe20003f1e000ULL, 0x00000009003c7308ULL, 0x0005e60000000800ULL,
0x0000000726387208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b30077823ULL, 0x100fe20000010854ULL,
0x3fb8aa3b31307823ULL, 0x100fe20000010854ULL, 0x3fb8aa3b2c317823ULL, 0x100fe20000010854ULL,
0x000000273800720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b282c7823ULL, 0x000fe20000010854ULL,
0x0000003900397308ULL, 0x000fe40000000800ULL, 0x0000003827387208ULL, 0x000fc40004000000ULL,
0x000000490a00720bULL, 0x000fc60003f1e000ULL, 0x0c401f00384f7f89ULL, 0x000ee200000e0000ULL,
0x0000000a490a7208ULL, 0x000fe20004000000ULL, 0x0000003d003d7308ULL, 0x000fe60000000800ULL,
0x000000210a00720bULL, 0x000fc80003f1e000ULL, 0x0000000a21097208ULL, 0x004fe20004000000ULL,
0x0000005000507308ULL, 0x000fe60000000800ULL, 0x0000001c0900720bULL, 0x000fc80003f1e000ULL,
0x000000091c0a7208ULL, 0x000fe20004000000ULL, 0x0000000700077308ULL, 0x000fe60000000800ULL,
0x0000001d0a00720bULL, 0x000fe40003f1e000ULL, 0x0000004f3800720bULL, 0x008fe40003f3e000ULL,
0x0000000a1d097208ULL, 0x000fe20004000000ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x000000384f4f7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b2d387823ULL, 0x100fe20000010854ULL,
0x000000180900720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b292d7823ULL, 0x000fc40000010854ULL,
0x0c201f004f527f89ULL, 0x000ea200000e0000ULL, 0x00000009180a7208ULL, 0x000fe20004000000ULL,
0x0000003100317308ULL, 0x000fe60000000800ULL, 0x000000190a00720bULL, 0x000fc80003f1e000ULL,
0x0000000a19097208ULL, 0x000fe20004000000ULL, 0x0000003800387308ULL, 0x000fe60000000800ULL,
0x000000140900720bULL, 0x000fc80003f1e000ULL, 0x00000009140a7208ULL, 0x000fe20004000000ULL,
0x0000003400347308ULL, 0x000fe60000000800ULL, 0x000000150a00720bULL, 0x000fe40003f1e000ULL,
0x000000524f00720bULL, 0x004fe40003f3e000ULL, 0x0000000a15297208ULL, 0x000fe20004000000ULL,
0x0000003500357308ULL, 0x000fe20000000800ULL, 0x0000004f52097208ULL, 0x000fc40004800000ULL,
0x000000102900720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b094f7820ULL, 0x000fe20000410000ULL,
0x00000029100a7208ULL, 0x000fe20004000000ULL, 0x0000002c002c7308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b3e287823ULL, 0x100fe2000001084fULL, 0x000000110a00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b3f3e7823ULL, 0x100fe2000001084fULL, 0x3fb8aa3b42247823ULL, 0x100fe2000001084fULL,
0x3fb8aa3b43437823ULL, 0x100fe2000001084fULL, 0x0000000a11257208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b36427823ULL, 0x100fe2000001084fULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe2000001084fULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe2000001084fULL, 0x0000000c2500720bULL, 0x000fe20003f1e000ULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001084fULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001084fULL, 0x000000250c0a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001084fULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001084fULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001084fULL, 0x0000000d0a00720bULL, 0x000fe20003f1e000ULL,
0x0000004300257308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b2b7823ULL, 0x000fc4000001084fULL,
0x0000000a0d297208ULL, 0x000fe40004000000ULL, 0x000000220b00720bULL, 0x000fe40003f1e000ULL,
0x000000202900720bULL, 0x000fe20003f3e000ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x0000000b220a7208ULL, 0x000fe40004000000ULL, 0x00000029203f7208ULL, 0x000fe40004800000ULL,
0x000000230a00720bULL, 0x000fc40003f1e000ULL, 0x000000403f00720bULL, 0x000fe20003f3e000ULL,
0x0000003e00297308ULL, 0x0005e20000000800ULL, 0x0000000a230b7208ULL, 0x000fe40004000000ULL,
0x0000003f403f7208ULL, 0x000fe40004800000ULL, 0x0000001e0b00720bULL, 0x000fe40003f1e000ULL,
0x000000443f00720bULL, 0x000fe20003f3e000ULL, 0x0000003a003a7308ULL, 0x000fe20000000800ULL,
0x0000000b1e0a7208ULL, 0x000fc40004000000ULL, 0x0000003f443e7208ULL, 0x004fe20004800000ULL,
0x3fb8aa3b373f7823ULL, 0x100fe2000001084fULL, 0x0000001f0a00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b27377823ULL, 0x000fe2000001084fULL, 0x000000453e00720bULL, 0x000fe20003f3e000ULL,
0x0000003b003b7308ULL, 0x000fe20000000800ULL, 0x0000000a1f0b7208ULL, 0x000fe40004000000ULL,
0x0000003e45367208ULL, 0x000fe40004800000ULL, 0x0000001a0b00720bULL, 0x000fc60003f1e000ULL,
0x0c401f0036437f89ULL, 0x000ea200000e0000ULL, 0x0000000b1a0a7208ULL, 0x000fe20004000000ULL,
0x00000042003e7308ULL, 0x0007e60000000800ULL, 0x0000001b0a00720bULL, 0x000fc80003f1e000ULL,
0x0000000a1b0b7208ULL, 0x000fe20004000000ULL, 0x0000003f003f7308ULL, 0x000fe60000000800ULL,
0x000000160b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b160a7208ULL, 0x000fe20004000000ULL,
0x0000003200327308ULL, 0x000fe60000000800ULL, 0x000000170a00720bULL, 0x000fe40003f1e000ULL,
0x000000433600720bULL, 0x004fe40003f3e000ULL, 0x0000000a170b7208ULL, 0x000fe20004000000ULL,
0x0000003300337308ULL, 0x000fe20000000800ULL, 0x0000003643437208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b26367823ULL, 0x000fe2000001084fULL, 0x000000120b00720bULL, 0x000fc60003f1e000ULL,
0x0c201f0043427f89ULL, 0x008ea200000e0000ULL, 0x0000000b120a7208ULL, 0x000fe20004000000ULL,
0x0000002e002e7308ULL, 0x000fe60000000800ULL, 0x000000130a00720bULL, 0x000fc80003f1e000ULL,
0x0000000a130b7208ULL, 0x000fe20004000000ULL, 0x0000002f002f7308ULL, 0x000fe60000000800ULL,
0x0000000e0b00720bULL, 0x000fc80003f1e000ULL, 0x0000000b0e0a7208ULL, 0x000fe20004000000ULL,
0x0000003600367308ULL, 0x000fe60000000800ULL, 0x0000000f0a00720bULL, 0x000fe40003f1e000ULL,
0x000000424300720bULL, 0x004fe40003f3e000ULL, 0x0000000a0f0b7208ULL, 0x000fe20004000000ULL,
0x0000003700377308ULL, 0x000fe20000000800ULL, 0x00000043420a7208ULL, 0x000fc40004800000ULL,
0x000000480b00720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b0a277820ULL, 0x000fe20000410000ULL,
0x0000000b480b7208ULL, 0x000fe20004000000ULL, 0x0000002d002d7308ULL, 0x000ea40000000800ULL,
0x3fb8aa3b10437823ULL, 0x100fe20000010827ULL, 0x0000004a0b00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010827ULL, 0x0000000b4a0b7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b11527823ULL, 0x100fe20000010827ULL, 0x000000460b00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b0c4f7823ULL, 0x100fe20000010827ULL, 0x0000004900557308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010827ULL, 0x0000000b46267208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010827ULL,
0x3fb8aa3b0d547823ULL, 0x100fe20000010827ULL, 0x000000472600720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b20427823ULL, 0x100fe20000010827ULL, 0x0000002100567308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b40497823ULL, 0x108fe20000010827ULL, 0x0000002647267208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b44407823ULL, 0x100fe20000010827ULL, 0x3fb8aa3b45457823ULL, 0x000fe20000010827ULL,
0x0000002c2d2c723eULL, 0x004fc400000000ffULL, 0x0c401f00260b7f89ULL, 0x000ea200000e0000ULL,
0x0000001c001c7308ULL, 0x000ff00000000800ULL, 0x0000001d001d7308ULL, 0x000ef00000000800ULL,
0x0000001400597308ULL, 0x000be20000000800ULL, 0x0000000b2600720bULL, 0x004fce0003f1e000ULL,
0x00000015005a7308ULL, 0x0005e20000000800ULL, 0x0000004c4114723eULL, 0x022fe400000000ffULL,
0x000000260b0b7208ULL, 0x000fca0004000000ULL, 0x0c201f000b107f89ULL, 0x000e6200000e0000ULL,
0x000000242515723eULL, 0x004fe200000000ffULL, 0x0000001900587308ULL, 0x0005f00000000800ULL,
0x0000001800577308ULL, 0x000ae20000000800ULL, 0x0000003a3b19723eULL, 0x004fce00000000ffULL,
0x0000004300437308ULL, 0x000fe20000000800ULL, 0x0000003c3918723eULL, 0x020fe400000000ffULL,
0x000000100b00720bULL, 0x002fca0003f1e000ULL, 0x0000005200527308ULL, 0x000fe20000000800ULL,
0x0000000b100b7208ULL, 0x000fe40004000000ULL, 0x0000000304ff7812ULL, 0x000fc6000780c0ffULL,
0x3fb8aa3b0b537820ULL, 0x000fe40000410000ULL, 0x0000004f004f7308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010853ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010853ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010853ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010853ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010853ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010853ULL,
0x0000002200117308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b16107823ULL, 0x100fe20000010853ULL,
0x3fb8aa3b17417823ULL, 0x000fe20000010853ULL, 0x000000282917723eULL, 0x000fe200000000ffULL,
0x3c003c00ff287424ULL, 0x000fe200078e00ffULL, 0x0000004d4e16723eULL, 0x000fe200000000ffULL,
0x3c003c00ff297424ULL, 0x000fc400078e00ffULL, 0x3fb8aa3b12257823ULL, 0x100fe20000010853ULL,
0x00000023000c7308ULL, 0x0002a20000000800ULL, 0x3fb8aa3b133a7823ULL, 0x100fe20000010853ULL,
0x0000001c1d12723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010853ULL,
0x00000057581c723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe20000010853ULL,
0x00000003ff4d7819ULL, 0x000fe20000011604ULL, 0x3fb8aa3b48487823ULL, 0x100fe20000010853ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x000000281420723cULL, 0x002fe200000018ffULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010853ULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010853ULL,
0x3fb8aa3b4a4a7823ULL, 0x000fe20000010853ULL, 0x000000110c11723eULL, 0x004fc600000000ffULL,
0x0000001f001f7308ULL, 0x000e620000000800ULL, 0x00000004040c7810ULL, 0x000fc80007ffe04dULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001a000d7308ULL, 0x0005e20000000800ULL,
0x0000001e1f13723eULL, 0x002fce00000000ffULL, 0x0000001b00267308ULL, 0x0002e20000000800ULL,
0x0000003d501a723eULL, 0x004fe200000000ffULL, 0x00000008513d7836ULL, 0x000fe20000000000ULL,
0x000000595a1e723eULL, 0x000fca00000000ffULL, 0x0000001000277308ULL, 0x0005e20000000800ULL,
0x0000003e3f1b723eULL, 0x002fe200000000ffULL, 0x00000010513f7836ULL, 0x000fc80000000000ULL,
0x000000083f577824ULL, 0x000fe200078e00ffULL, 0x0000000d261d723eULL, 0x008fe200000000ffULL,
0x0000004100247308ULL, 0x0002e20000000800ULL, 0x000000555610723eULL, 0x004fe200000000ffULL,
0x000000281820723cULL, 0x000fe20000001820ULL, 0x00000008510d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8574c7812ULL, 0x000fe200078ee20cULL, 0x000000083d557824ULL, 0x000fc600078e00ffULL,
0x0000002500397308ULL, 0x0005e20000000800ULL, 0x0000001851417836ULL, 0x002fe20000000000ULL,
0xfffffff80d3e7812ULL, 0x000fe400078ee20cULL, 0xfffffff855447812ULL, 0x000fe200078ee20cULL,
0x0000000841597824ULL, 0x000fe200078e00ffULL, 0x00000032330d723eULL, 0x000fe200000000ffULL,
0x00000008414e7824ULL, 0x000fe200078e00ffULL, 0x00000027241f723eULL, 0x008fe200000000ffULL,
0x0000005400547308ULL, 0x000e620000000800ULL, 0x000000281024723cULL, 0x004fe200000018ffULL,
0xfffffff859507812ULL, 0x000fc400078ee20cULL, 0x00000007300c723eULL, 0x000fe400000000ffULL,
0x000000435230723eULL, 0x000fe400000000ffULL, 0x0000003a003a7308ULL, 0x000ea20000000800ULL,
0x0000004f5432723eULL, 0x002fce00000000ffULL, 0x0000000e003b7308ULL, 0x0003f00000000800ULL,
0x0000000f003c7308ULL, 0x0007620000000800ULL, 0x000000281c24723cULL, 0x000fe20000001824ULL,
0x00000031380e723eULL, 0x002fc400000000ffULL, 0x000000393a31723eULL, 0x004fe200000000ffULL,
0x000000ffff397224ULL, 0x000fe200078e0016ULL, 0x0000000963387c11ULL, 0x000fe2000f8e60ffULL,
0x000000ffff3a7224ULL, 0x000fe200078e0018ULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x0000002e2f0f723eULL, 0x008fe200000000ffULL, 0x000000ffff167224ULL, 0x000fe200078e0019ULL,
0x00000034352e723eULL, 0x000fe200000000ffULL, 0x000000ffff187224ULL, 0x000fe200078e0010ULL,
0x00000036372f723eULL, 0x000fe200000000ffULL, 0x000000ffff197224ULL, 0x000fe200078e0012ULL,
0x0000003b3c33723eULL, 0x020fe200000000ffULL, 0x000000280c20723cULL, 0x000fe20000001820ULL,
0x0000002b002b7308ULL, 0x000e620000000800ULL, 0x000000083d3c7824ULL, 0x000fc400078e00ffULL,
0x000000ffff3b7224ULL, 0x000fe400078e001aULL, 0x000000ffff1a7224ULL, 0x000fe400078e001cULL,
0x000000ffff107224ULL, 0x000fe200078e0011ULL, 0x000000283034723cULL, 0x000fe20000001824ULL,
0x0000004200427308ULL, 0x000fe20000000800ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000ffff127224ULL, 0x000fe400078e001dULL, 0x000000ffff137224ULL, 0x000fe200078e001fULL,
0x0000002a2b2d723eULL, 0x002fe200000000ffULL, 0x00000008512a7824ULL, 0x000fe200078e00ffULL,
0x0000004900497308ULL, 0x000e620000000800ULL, 0x000000034d2b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff1c7224ULL, 0x000fc400078e0031ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0033ULL,
0x000000282c20723cULL, 0x000fe20000001820ULL, 0x000000012b2b7824ULL, 0x000fe200078e0204ULL,
0x0000004000407308ULL, 0x000fe80000000800ULL, 0x000000072b2b7812ULL, 0x000fe400078ec0ffULL,
0x000000424924723eULL, 0x002fc400000000ffULL, 0x0000004500457308ULL, 0x000e620000000800ULL,
0xfffffff82a2a7812ULL, 0x000fe400078ee22bULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee22bULL,
0xfffffff84e4e7812ULL, 0x000fc600078ee22bULL, 0x0000004800487308ULL, 0x000fec0000000800ULL,
0x000000ffff217224ULL, 0x000fe200078e0022ULL, 0x000000404526723eULL, 0x002fe200000000ffULL,
0x0000004a00077308ULL, 0x0002b00000000800ULL, 0x0000004600467308ULL, 0x000fe20000000800ULL,
0x000000083f4a7824ULL, 0x002fca00078e00ffULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee22bULL,
0x00012000382b7836ULL, 0x000fe20000000000ULL, 0x0000004700477308ULL, 0x000e620000000800ULL,
0x000000480725723eULL, 0x004fe200000000ffULL, 0x000000ffff387224ULL, 0x000fe400078e0014ULL,
0x000000103e3e7824ULL, 0x100fe400078e022bULL, 0x0000001044447824ULL, 0x100fe400078e022bULL,
0x000000104c4c7824ULL, 0x000fc400078e022bULL, 0x000000102a077824ULL, 0x100fe400078e022bULL,
0x0000001050507824ULL, 0x100fe400078e022bULL, 0x000000103c3c7824ULL, 0x100fe200078e022bULL,
0x000000464727723eULL, 0x002fe200000000ffULL, 0x000000104a4a7824ULL, 0x100fe200078e022bULL,
0x0000003807007844ULL, 0x0003e20000000200ULL, 0x000000104e4e7824ULL, 0x000fe400078e022bULL,
0x000000ffff147224ULL, 0x000fc400078e0015ULL, 0x000000282434723cULL, 0x000fe20000001834ULL,
0x000000ffff2a7224ULL, 0x000fe400078e002cULL, 0x000000ffff2b7224ULL, 0x000fe400078e002eULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x000000ffff287224ULL, 0x000fe400078e000cULL,
0x000000ffff297224ULL, 0x000fe400078e000eULL, 0x000000ffff0c7224ULL, 0x000fc400078e000dULL,
0x000000ffff177224ULL, 0x000fe200078e001bULL, 0x000000283e007844ULL, 0x000fe20000000200ULL,
0x000000ffff0d7224ULL, 0x000fe400078e000fULL, 0x000000ffff0e7224ULL, 0x000fe200078e002dULL,
0x000000143c007844ULL, 0x000fe20000000200ULL, 0x000000ffff0f7224ULL, 0x000fe400078e002fULL,
0x000000ffff1b7224ULL, 0x000fe400078e001eULL, 0x000000ffff2c7224ULL, 0x000fe200078e0030ULL,
0x0000000c44007844ULL, 0x0005e20000000200ULL, 0x000000ffff2d7224ULL, 0x000fc400078e0032ULL,
0x000000ffff2e7224ULL, 0x000fe200078e0024ULL, 0x000000184a007844ULL, 0x0007e20000000200ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0026ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0025ULL,
0x000000ffff1f7224ULL, 0x000fe200078e0027ULL, 0x0000002c4c007844ULL, 0x0007e20000000200ULL,
0x000000ffff227224ULL, 0x000fe400078e0034ULL, 0x000000ffff237224ULL, 0x000fe200078e0036ULL,
0x000000104e007844ULL, 0x0007e20000000200ULL, 0x000000ffff077224ULL, 0x002fc400078e005cULL,
0x00000001ff0c7424ULL, 0x004fe200078e00ffULL, 0x0000001c50007844ULL, 0x0007e80000000200ULL,
0x01a000084b008388ULL, 0x0007e80000000c00ULL, 0x01a200204b008388ULL, 0x0007e20000000c00ULL,
0x000000617600720cULL, 0x000fe20003f06070ULL, 0x01a6080c77ff79a7ULL, 0x0007e2000850003fULL,
0x01a6100c77ff79a7ULL, 0x0007e2000850003fULL, 0x01a6180c77ff79a7ULL, 0x0007e2000850003fULL,
0x01a6200c77ff79a7ULL, 0x0007f2000850003fULL, 0xffffff9000f08947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000082007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000008200008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff82ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000082027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000008200007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffe9402a47950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004e3ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000660ULL, 0x0000000000000228ULL, 0x0000001500000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000888ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000968ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009bcULL, 0x0000000000000700ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010c0ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010c0ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001108ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000016a00ULL, 0x0000001500000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017b80ULL, 0x0000000000000040ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017bc0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000017bc0ULL, 0x0000000000000270ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x00000000000181b0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000181b0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000001108ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000016a00ULL,
0x0000000000016a00ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000017b80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000017bc0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000270ULL, 0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_0_m_32_sm_90_cubin_len = 99072;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
