/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000010dd0ULL, 0x0000000000010a50ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL, 0x497461324545386aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x386a4c4536316a4cULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL, 0x632e766e2e006675ULL,
0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL, 0x756265642e006d61ULL,
0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL, 0x642e616c65722e00ULL,
0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL, 0x000000000000006eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b0ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003feULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000443ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b002200000489ULL, 0x000000000000ef70ULL, 0x0000000000000170ULL,
0x000b0022000004bcULL, 0x000000000000f0e0ULL, 0x0000000000000040ULL, 0x000b0022000004e7ULL,
0x000000000000f120ULL, 0x0000000000000050ULL, 0x000b002200000511ULL, 0x000000000000f170ULL,
0x0000000000000110ULL, 0x000a00030000057fULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000400030000059fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005cfULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x000000000000f280ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000ef7000000000ULL, 0x0000040400000000ULL,
0x810c000001340400ULL, 0x003a9c0400288080ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808b0828808081ULL, 0x90082880808c0828ULL, 0x2880809408288080ULL, 0x8096082880809508ULL,
0x0828808097082880ULL, 0x80808408288080b8ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0000ef7000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x8c082880808b0828ULL, 0x2880809008288080ULL, 0x8095082880809408ULL, 0x0828808096082880ULL,
0x8080b008288080b8ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080b092ULL,
0x0000001cffffffffULL, 0x0000010800000000ULL, 0x0000f0e000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x8c082880808b0828ULL,
0x2880809008288080ULL, 0x8095082880809408ULL, 0x0828808096082880ULL, 0x8080b80828808097ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x002200288080b892ULL, 0x0000002cffffffffULL,
0x000001a000000000ULL, 0x0000f12000000000ULL, 0x0000005000000000ULL, 0x0000100400000000ULL,
0x8090288080b80900ULL, 0x0000000000002880ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x8c082880808b0828ULL, 0x2880809408288080ULL, 0x8096082880809508ULL, 0x0828808097082880ULL,
0x80809008288080b8ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880809092ULL,
0x0000001cffffffffULL, 0x0000024800000000ULL, 0x0000f17000000000ULL, 0x0000011000000000ULL,
0x0000000000000000ULL, 0x0000001a00082f04ULL, 0x0008230400000064ULL, 0x0000000000000016ULL,
0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL, 0x0000001500082304ULL,
0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL, 0x0008230400000000ULL,
0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL,
0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL,
0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL, 0x0008110400000000ULL,
0x000000000000001aULL, 0x0000007b00043704ULL, 0x0000001700080a04ULL, 0x0050190300500160ULL,
0x00000000000c1704ULL, 0x0021f00000480006ULL, 0x00000000000c1704ULL, 0x0021f00000400005ULL,
0x00000000000c1704ULL, 0x0011f00000380004ULL, 0x00000000000c1704ULL, 0x0081f00000180003ULL,
0x00000000000c1704ULL, 0x0021f00000100002ULL, 0x00000000000c1704ULL, 0x0021f00000080001ULL,
0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL, 0x0134290400000020ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01342804ffffffffULL, 0x000000c0000000b0ULL,
0x000023a000000400ULL, 0x0000256000002450ULL, 0x00002b40000026d0ULL, 0x00002bc000002b70ULL,
0x0000452000002c10ULL, 0x000046f0000045c0ULL, 0x00004cc000004850ULL, 0x00004d4000004cf0ULL,
0x000063a000004d90ULL, 0x0000657000006440ULL, 0x00006b40000066d0ULL, 0x00006bc000006b70ULL,
0x0000828000006c10ULL, 0x0000844000008320ULL, 0x00008a00000085a0ULL, 0x00008a8000008a30ULL,
0x0000929000008ad0ULL, 0x0000d7c0000092a0ULL, 0x0000d8100000d800ULL, 0x0000d8700000d820ULL,
0x0000d8b00000d890ULL, 0x0000e5000000d8c0ULL, 0x0000e5a00000e550ULL, 0x0000e6500000e5f0ULL,
0x0000e7000000e6b0ULL, 0x0000e7900000e750ULL, 0x0000e8400000e7e0ULL, 0x0000e8e00000e890ULL,
0x0000e9800000e930ULL, 0x0000ea300000e9d0ULL, 0x0000ead00000ea80ULL, 0x0000eb600000eb20ULL,
0x0000ec100000ebb0ULL, 0x0000ecb00000ec60ULL, 0x0000ed700000ed10ULL, 0x0000ee300000edd0ULL,
0x0000eef00000ee90ULL, 0x044039040000ef50ULL, 0x000000ff00000220ULL, 0x003f01000000f600ULL,
0x0000000d000002a0ULL, 0x003f01200000f608ULL, 0x0000000d00000370ULL, 0x003f01200000f688ULL,
0x0000000d000003a0ULL, 0x003f01200000f6a8ULL, 0x0000000d000003d0ULL, 0x003f01200000f6c8ULL,
0x000000ff00000460ULL, 0x003f01070000f600ULL, 0x0000000900000600ULL, 0x003f010200000004ULL,
0x00000009000006b0ULL, 0x003f010100000000ULL, 0x000000ff000010a0ULL, 0x0004010700000000ULL,
0x000000ff00001120ULL, 0x0004010100000000ULL, 0x0000001400001180ULL, 0x003f010100000020ULL,
0x0000001200001330ULL, 0x003f01050000f6ccULL, 0x0000001200001510ULL, 0x003f01050000f6ccULL,
0x0000004700001ed0ULL, 0x003f01070000f6a8ULL, 0x0000004700002040ULL, 0x003f01010000f6a8ULL,
0x0000004d000020a0ULL, 0x003f01010000f608ULL, 0x0000004d000020c0ULL, 0x003f01050000f60cULL,
0x0000004d00002290ULL, 0x003f01050000f60cULL, 0x00000016000028a0ULL, 0x003f01050000f6acULL,
0x0000001600002a70ULL, 0x003f01050000f6acULL, 0x0000001400003420ULL, 0x003f01010000f6c8ULL,
0x0000004a000034a0ULL, 0x003f01010000f688ULL, 0x0000004e00003520ULL, 0x003f010500000004ULL,
0x0000004e000036f0ULL, 0x003f010500000004ULL, 0x00000059000040f0ULL, 0x003f01070000f6a8ULL,
0x0000005900004220ULL, 0x003f01010000f6a8ULL, 0x0000004d00004280ULL, 0x003f01010000f628ULL,
0x0000004d000042a0ULL, 0x003f01050000f62cULL, 0x0000004d00004470ULL, 0x003f01050000f62cULL,
0x0000004700004a20ULL, 0x003f01050000f6acULL, 0x0000004700004bf0ULL, 0x003f01050000f6acULL,
0x0000001000005390ULL, 0x003f010100000000ULL, 0x0000004a00005400ULL, 0x003f01010000f690ULL,
0x0000004e00005470ULL, 0x003f010500000004ULL, 0x0000004e00005640ULL, 0x003f010500000004ULL,
0x0000005a00005f40ULL, 0x003f010700000000ULL, 0x00000047000060a0ULL, 0x003f01010000f6a8ULL,
0x0000004d00006100ULL, 0x003f01010000f648ULL, 0x0000004d00006120ULL, 0x003f01050000f64cULL,
0x0000004d000062f0ULL, 0x003f01050000f64cULL, 0x00000059000068a0ULL, 0x003f01050000f6acULL,
0x0000005900006a70ULL, 0x003f01050000f6acULL, 0x0000001400007260ULL, 0x003f010100000000ULL,
0x0000004a000072d0ULL, 0x003f01010000f698ULL, 0x0000004e00007350ULL, 0x003f010500000004ULL,
0x0000004e00007520ULL, 0x003f010500000004ULL, 0x0000005800007e20ULL, 0x003f010700000000ULL,
0x0000005900007f80ULL, 0x003f01010000f6a8ULL, 0x0000004d00007fe0ULL, 0x003f01010000f668ULL,
0x0000004d00008000ULL, 0x003f01050000f66cULL, 0x0000004d000081d0ULL, 0x003f01050000f66cULL,
0x0000004700008760ULL, 0x003f01050000f6acULL, 0x0000004700008930ULL, 0x003f01050000f6acULL,
0x0000001400009050ULL, 0x003f010100000000ULL, 0x0000004a000090b0ULL, 0x003f01010000f6a0ULL,
0x000000ff00009e60ULL, 0x003f01010000f600ULL, 0x000000ff0000ac60ULL, 0x003f01050000f604ULL,
0x000000ff0000ae30ULL, 0x003f01050000f604ULL, 0x000000ff0000b060ULL, 0x003f01010000f600ULL,
0x000000ff0000b090ULL, 0x003f01050000f604ULL, 0x000000ff0000b250ULL, 0x003f01050000f604ULL,
0x000000380000cbf0ULL, 0x003f010100000000ULL, 0x000000380000ccf0ULL, 0x003f010500000004ULL,
0x000000380000cec0ULL, 0x003f010500000004ULL, 0x0000003b0000e360ULL, 0x003f010100000000ULL,
0x0000003b0000e3c0ULL, 0x003f010100000008ULL, 0x0000003b0000e420ULL, 0x003f010100000010ULL,
0x0000003b0000e490ULL, 0x003f010100000018ULL, 0x00141c0400053803ULL, 0x00009d8000009b00ULL,
0x0000b3800000b2b0ULL, 0x000004010000e4d0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000002ccULL,
0x0000001a00000002ULL, 0x0000000000000224ULL, 0x0000001a00000002ULL, 0x000000000000018cULL,
0x0000001a00000002ULL, 0x00000000000000f4ULL, 0x0000001a00000002ULL, 0x0000000000000044ULL,
0x0000001a00000002ULL, 0x00000000000002a8ULL, 0x0000001a00000002ULL, 0x0000000000000200ULL,
0x0000001a00000002ULL, 0x0000000000000168ULL, 0x0000001a00000002ULL, 0x00000000000000d0ULL,
0x0000001a00000002ULL, 0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002100ULL,
0x0000000000157806ULL, 0x000fe200038e0000ULL, 0x00005800ff137624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000ea80000002300ULL,
0x0000000000037919ULL, 0x000ee80000002200ULL, 0x0000000000047919ULL, 0x000f280000000000ULL,
0x0000000000127919ULL, 0x000f280000002600ULL, 0x00000000000c7919ULL, 0x000f220000002700ULL,
0x00000005ff417819ULL, 0x002fc6000001160dULL, 0x00001fff020e7589ULL, 0x0043e800000e0000ULL,
0x00001fff41417589ULL, 0x000ea200000e0000ULL, 0x0000010002007a24ULL, 0x008fe400078e0203ULL,
0x0000001500037300ULL, 0x000ee400000e0000ULL, 0x00000000000d7a24ULL, 0x000fe400078e020dULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x0000000812057824ULL, 0x010fc400078e00ffULL,
0x000000ff0d00720cULL, 0x040fe20003f45270ULL, 0x0000001500157309ULL, 0x000f220000000000ULL,
0x0000007f0d00780cULL, 0x040fe40003f84070ULL, 0x0000000f0d00780cULL, 0x040fe40003f64070ULL,
0x000000030d00780cULL, 0x000fe40003f24070ULL, 0x000000040300720cULL, 0x008fe20003f02070ULL,
0x0000000813047824ULL, 0x000fc800078e00ffULL, 0x3fffff80ff02a424ULL, 0x002fe400078e00ffULL,
0x000000040e087824ULL, 0x004fe400078e0241ULL, 0x0000000c04057224ULL, 0x000fe400078e0205ULL,
0x0000000208047824ULL, 0x000fe200078e00ffULL, 0x00000004ff107819ULL, 0x000fe20000011600ULL,
0x7fffff80ff03a424ULL, 0x000fc600078e00ffULL, 0x00000008040b7817ULL, 0x040fe20007800000ULL,
0xff317217ff14c424ULL, 0x000fe400078e00ffULL, 0x00000001040a7824ULL, 0x000fe200078e0210ULL,
0x00f60002ff00a388ULL, 0x0003e20000000a00ULL, 0x000000010d00780cULL, 0x000fe20003f44070ULL,
0x000000010b0f7824ULL, 0x000fe400078e0a04ULL, 0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL,
0x00f400140d00c388ULL, 0x0005e20000004800ULL, 0x7fffffc0ff07b424ULL, 0x000fc400078e00ffULL,
0x0000001000047824ULL, 0x000fe400078e00ffULL, 0x00000100ff037424ULL, 0x002fe200078e00ffULL,
0x00f608060d00b388ULL, 0x0003e20000008a00ULL, 0x0000000105027824ULL, 0x000fe200078e020aULL,
0x000000f004117812ULL, 0x000fe200078ec0ffULL, 0x000000010a057824ULL, 0x000fe200078e0200ULL,
0x0000000f1000720cULL, 0x000fe20003f66070ULL, 0x000000100a147824ULL, 0x004fe400078e00ffULL,
0x00005c0002027625ULL, 0x000fc600078e0003ULL, 0xfffffff0140f7812ULL, 0x000fe200078ee205ULL,
0x3fffff60ff089424ULL, 0x000fe200078e00ffULL, 0x0000001102027210ULL, 0x000fe20007f9e0ffULL,
0x7fffff60ff099424ULL, 0x000fe400078e00ffULL, 0x3fffff80ff069424ULL, 0x002fe400078e00ffULL,
0x7fffff80ff079424ULL, 0x000fe200078e00ffULL, 0x00f688080d009388ULL, 0x0009e20000008a00ULL,
0x3fffffc0ff0aa424ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL,
0x00f6a8060d009388ULL, 0x000fe20000008a00ULL, 0x000000ffff037224ULL, 0x000fc400020e0603ULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x00f6c80a0d00a388ULL, 0x000fe20000008a00ULL,
0x00000004ff057424ULL, 0x000fe400078e00ffULL, 0x000000ffff087224ULL, 0x010fe200078e0a15ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020f7faeULL, 0x0003e2000d901c46ULL, 0x000062000c427625ULL, 0x000fc600078e0005ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000642427981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0e00720cULL, 0x000fc40003f05270ULL,
0x0000003f42407810ULL, 0x044fe40007ffe0ffULL, 0x000000ff42037810ULL, 0x002fe40007ffe0ffULL,
0x00000006ff407819ULL, 0x000fe40000011640ULL, 0x00000008ff0f7819ULL, 0x000fca0000011603ULL,
0x0000984000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011641ULL,
0x00000003ff0a7424ULL, 0x000fe200078e00ffULL, 0x0000f68841097811ULL, 0x000fe200078e18ffULL,
0xffffffffff087424ULL, 0x000fe200078e00ffULL, 0x03ffffff0d577812ULL, 0x000fc800078ec0ffULL,
0x000000405700720cULL, 0x000fda0003f06070ULL, 0x000000020c028824ULL, 0x000fe400078e00ffULL,
0x00006400ff078624ULL, 0x000fc800078e00ffULL, 0x0000640002028624ULL, 0x000fc800078e0207ULL,
0x0000000157028824ULL, 0x000fe200078e0202ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040a09ff738cULL, 0x0003e20000000000ULL, 0x0000600002068625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000606088981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0300780cULL, 0x000fe20003f04070ULL, 0x0000004012027824ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011641ULL, 0x0000000009ff7f8cULL, 0x0007e8000c80043fULL,
0x000000200e037824ULL, 0x000fca00078e00ffULL, 0x00000020020a7812ULL, 0x002fe200078ef803ULL,
0x00005800080b7a24ULL, 0x004fe200078e02ffULL, 0x0000000141087812ULL, 0x000fc600078ec0ffULL,
0x000000400b197824ULL, 0x000fe200078e00ffULL, 0x0000047000000947ULL, 0x000fea0003800000ULL,
0x0000001008077824ULL, 0x008fe200078e00ffULL, 0x0000000342067217ULL, 0x000fe40007800000ULL,
0x00000003ff087819ULL, 0x000fe40000011600ULL, 0x00000070041d7812ULL, 0x000fe200078ec0ffULL,
0x0000000106067824ULL, 0x000fe200078e0a03ULL, 0x0000000408107810ULL, 0x040fe20007ffe0ffULL,
0x0000000107097824ULL, 0x000fe200078e0208ULL, 0x0000000c08137810ULL, 0x000fc40007ffe0ffULL,
0x0000000706067217ULL, 0x000fe20007800000ULL, 0x00000001090b7824ULL, 0x040fe400078e0200ULL,
0x0000000809127824ULL, 0x000fe400078e00ffULL, 0x000000010a097824ULL, 0x000fe400078e0209ULL,
0x0000000106067824ULL, 0x000fe200078e0a07ULL, 0xfffffff8120b7812ULL, 0x000fe200078ee20bULL,
0x0000000107117824ULL, 0x000fe200078e0210ULL, 0x0000000919187210ULL, 0x000fe20007f1e0ffULL,
0x0000000107157824ULL, 0x000fe200078e0213ULL, 0x0000000808127810ULL, 0x040fe20007ffe0ffULL,
0x00000008111b7824ULL, 0x040fe200078e00ffULL, 0x000000060800720cULL, 0x080fe20003f66070ULL,
0x0000000111087824ULL, 0x000fe200078e0200ULL, 0x000000061000720cULL, 0x080fe20003f46070ULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x00005e0018107a11ULL, 0x000fe200078838ffULL,
0x0000000107097824ULL, 0x000fe200078e0212ULL, 0x000000061200720cULL, 0x080fe20003f26070ULL,
0x000000010a117824ULL, 0x040fe200078e0211ULL, 0x000000061300720cULL, 0x000fe20003f06070ULL,
0x000000010a067824ULL, 0x000fe200078e0209ULL, 0x00005f0018187a11ULL, 0x000fe200020f3c17ULL,
0x000000010a0a7824ULL, 0x000fe200078e0215ULL, 0x0000001119167210ULL, 0x000fe20007f9e0ffULL,
0x0000000815117824ULL, 0x000fe200078e00ffULL, 0xfffffff81b077812ULL, 0x000fe200078ee208ULL,
0x0000000109087824ULL, 0x100fe200078e0200ULL, 0x0000000619127210ULL, 0x000fe20007fbe0ffULL,
0x0000000809097824ULL, 0x000fe200078e00ffULL, 0x0000000a190a7210ULL, 0x000fe20007fde0ffULL,
0x0000000115067824ULL, 0x000fc400078e0200ULL, 0x000000ffff137224ULL, 0x000fe200020e06ffULL,
0x00005e0016147a11ULL, 0x000fe200078838ffULL, 0x000000ffff1b7224ULL, 0x000fe200028e06ffULL,
0xfffffff809097812ULL, 0x000fe400078ee208ULL, 0x0000b0000e087811ULL, 0x000fe400078e68ffULL,
0xfffffff811117812ULL, 0x000fe400078ee206ULL, 0x00005f0016167a11ULL, 0x000fe200020f3c13ULL,
0x0000001007157824ULL, 0x100fe200078e0208ULL, 0x000000101d067210ULL, 0x000fe20007f9e0ffULL,
0x0000001009177824ULL, 0x000fc400078e0208ULL, 0x000000100b137824ULL, 0x000fe200078e0208ULL,
0x00005e00120b7a11ULL, 0x000fe200078a38ffULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x00005e000a107a11ULL, 0x000fe200078c38ffULL, 0x000000ffff077224ULL, 0x000fe400020e0618ULL,
0x0000001011197824ULL, 0x000fe200078e0208ULL, 0x0000001d14087210ULL, 0x080fe40007f9e0ffULL,
0x00005f0012117a11ULL, 0x000fe200028f3c1bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006137faeULL, 0x0003e2000d901c46ULL, 0x00005f000a047a11ULL, 0x000fe200030f3c09ULL,
0x000000ffff097224ULL, 0x000fe200020e0616ULL, 0x0000001d0b0a7210ULL, 0x000fc40007fbe0ffULL,
0x0000001d10107210ULL, 0x000fe40007f9e0ffULL, 0x0000000008157faeULL, 0x0003e2000d101c46ULL,
0x000000ffff0b7224ULL, 0x000fe400028e0611ULL, 0x000000ffff117224ULL, 0x000fc600020e0604ULL,
0x000000000a177faeULL, 0x0003e8000c901c46ULL, 0x0000000010197faeULL, 0x0003e2000c101c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000001008077824ULL, 0x008fe200078e00ffULL,
0x00000070041b7812ULL, 0x000fc800078ec0ffULL, 0x0000000700077211ULL, 0x000fc800078fe8ffULL,
0x0000000407097810ULL, 0x040fe20007ffe0ffULL, 0x0000000107067824ULL, 0x140fe400078e0200ULL,
0x00000008070b7824ULL, 0x000fe400078e00ffULL, 0x0000000109087824ULL, 0x040fe400078e0200ULL,
0x0000000809117824ULL, 0x000fe200078e00ffULL, 0xfffffff80b067812ULL, 0x000fe200078ee206ULL,
0x000000010a097824ULL, 0x000fe200078e0209ULL, 0x00000008070b7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff811087812ULL, 0x000fe400078ee208ULL, 0x0000000c07117810ULL, 0x000fe20007ffe0ffULL,
0x000000010a077824ULL, 0x040fe200078e0207ULL, 0x0000000919147210ULL, 0x040fe20007f5e0ffULL,
0x000000010a107824ULL, 0x040fe400078e020bULL, 0x000000010a0a7824ULL, 0x000fe200078e0211ULL,
0x0000000719167210ULL, 0x000fe20007f3e0ffULL, 0x000000010b077824ULL, 0x100fe200078e0200ULL,
0x0000001019127210ULL, 0x000fe20007f7e0ffULL, 0x000000080b187824ULL, 0x000fe200078e00ffULL,
0x0000000a190a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e06ffULL,
0x00005e0016107a11ULL, 0x000fe200078238ffULL, 0x0000000111097824ULL, 0x040fe200078e0200ULL,
0x0000b0000e197811ULL, 0x000fe200078e68ffULL, 0x00000008111a7824ULL, 0x000fe200078e00ffULL,
0xfffffff818077812ULL, 0x000fe200078ee207ULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x00005f0016167a11ULL, 0x000fe200008f3c0bULL, 0x0000001008157824ULL, 0x000fe200078e0219ULL,
0xfffffff81a097812ULL, 0x000fe200078ee209ULL, 0x000000ffff0b7224ULL, 0x000fe200010e06ffULL,
0x00005e0014087a11ULL, 0x000fe200078238ffULL, 0x0000001006137824ULL, 0x000fc400078e0219ULL,
0x0000001007177824ULL, 0x000fe200078e0219ULL, 0x00005f0014147a11ULL, 0x000fe200008f3c0bULL,
0x0000001009197824ULL, 0x000fe200078e0219ULL, 0x000000101b067210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e000a107a11ULL, 0x000fe400078638ffULL,
0x00005e00120b7a11ULL, 0x000fe200078438ffULL, 0x000000ffff077224ULL, 0x000fe200008e0616ULL,
0x000000081b087210ULL, 0x000fe40007f1e0ffULL, 0x00005f000a047a11ULL, 0x000fc400018f3c09ULL,
0x00005f0012117a11ULL, 0x000fe200010f3c11ULL, 0x000000ffff097224ULL, 0x000fe200000e0614ULL,
0x0000000b1b0a7210ULL, 0x040fe20007f3e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006137faeULL, 0x0003e2000b901c46ULL, 0x000000101b107210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e0611ULL, 0x0000000008157faeULL, 0x0003e2000b901c46ULL,
0x000000ffff117224ULL, 0x000fc600010e0604ULL, 0x000000000a177faeULL, 0x0003e8000b901c46ULL,
0x0000000010197faeULL, 0x0003e4000b901c46ULL, 0x0000000157577810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff047424ULL, 0x000fc600078e00ffULL, 0x000000405700720cULL, 0x000fda0003f06070ULL,
0x0000006000000947ULL, 0x000fea0003800000ULL, 0x000000020c047824ULL, 0x000fe400078e00ffULL,
0x00006400ff077624ULL, 0x002fc800078e00ffULL, 0x0000640004047624ULL, 0x000fc800078e0207ULL,
0x0000000104047824ULL, 0x000fc800078e0257ULL, 0x0000600004047625ULL, 0x000fcc00078e0005ULL,
0x0000000604047981ULL, 0x000324000c1e1900ULL, 0x000000000e0473c2ULL, 0x000ea200000e0000ULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x000000ffff057224ULL, 0x002fe200078e00ffULL,
0x0000f6a80e147811ULL, 0x000fe200078e18ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047891ULL, 0x004fd2000f8e203fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff5e7f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200014147f8cULL, 0x000ea2000c80043fULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00007ef000008947ULL, 0x000fea0003800000ULL, 0x000000020c067824ULL, 0x000fe400078e00ffULL,
0x00006400ff077624ULL, 0x000fc400078e00ffULL, 0xff317217ff5d7424ULL, 0x000fe400078e00ffULL,
0x0000640006067624ULL, 0x000fe400078e0207ULL, 0x000000ffff087224ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x000fc400078e00ffULL,
0x0000010008077824ULL, 0x000fca00078e00ffULL, 0x000000420700720cULL, 0x000fda0003f06070ULL,
0x00007e1000000947ULL, 0x002fea0003800000ULL, 0x000000ffff077224ULL, 0x000fe400078e0057ULL,
0x000000ffff097224ULL, 0x000fc400078e0013ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0x0000000441127824ULL, 0x000fca00078e00ffULL, 0xfffffff812127812ULL, 0x000fc800078ec0ffULL,
0x0000f6c8124e7810ULL, 0x000fe20007ffe0ffULL, 0x00f6cc0012147984ULL, 0x004ea40000000800ULL,
0x8000000014ff7812ULL, 0x004fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001610397210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e11ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011417ULL,
0x0000003914147211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000214147819ULL, 0x000fc80000001217ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc0012147984ULL, 0x000ea40000000800ULL,
0x8000000014ff7812ULL, 0x004fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001041107824ULL, 0x000fe200078e00ffULL,
0x0000000108127810ULL, 0x000fe20007ffe0ffULL, 0x0000580004047a24ULL, 0x010fe200078e02ffULL,
0x0000000113497812ULL, 0x000fe400078e0cffULL, 0x0000000f1200720cULL, 0x000fe20003f06070ULL,
0x0000004004437824ULL, 0x000fe200078e00ffULL, 0xffffffe010117812ULL, 0x000fca00078ec0ffULL,
0x0000010008117824ULL, 0x000fca00078e0211ULL, 0x0000004011397810ULL, 0x000fc80007ffe0ffULL,
0x00000020023c7812ULL, 0x000fe200078ef839ULL, 0x0000049000008947ULL, 0x000fea0003800000ULL,
0x0000001010157812ULL, 0x000fe200078ec0ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x00000003ff387819ULL, 0x000fc80000011600ULL, 0x00000004383e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000138117824ULL, 0x000fe200078e0215ULL, 0x0000007010457812ULL, 0x000fe400078ec0ffULL,
0x0000000c38447810ULL, 0x000fe20007ffe0ffULL, 0x000000013c047824ULL, 0x000fe400078e0211ULL,
0x000000013e3b7824ULL, 0x000fe400078e0215ULL, 0x0000000111127824ULL, 0x000fe200078e0200ULL,
0x0000000443167210ULL, 0x000fe20007f1e0ffULL, 0x000000013c107824ULL, 0x000fe200078e023bULL,
0x0000003942047217ULL, 0x000fe20007800000ULL, 0x0000000811117824ULL, 0x000fc400078e00ffULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x00005e0016147a11ULL, 0x000fe200078038ffULL,
0x0000000104047824ULL, 0x000fe200078e0a39ULL, 0x00000010433a7210ULL, 0x000fe40007fde0ffULL,
0x00005f0016167a11ULL, 0x000fe200000f3c17ULL, 0x000000020e177824ULL, 0x000fe200078e0249ULL,
0x0000001504047217ULL, 0x000fe20007800000ULL, 0x000000ffff3d7224ULL, 0x000fe200030e06ffULL,
0x0000004514107210ULL, 0x000fe40007fbe0ffULL, 0xfffffff811127812ULL, 0x000fe200078ee212ULL,
0x0000000104047824ULL, 0x000fe200078e0a15ULL, 0x0000b00017177811ULL, 0x000fe200078e60ffULL,
0x000000ffff117224ULL, 0x000fe200028e0616ULL, 0x00005e003a147a11ULL, 0x000fc400078c38ffULL,
0x000000043800720cULL, 0x080fe20003f06070ULL, 0x0000001012397824ULL, 0x000fe200078e0217ULL,
0x000000043e00720cULL, 0x000fe20003fa6070ULL, 0x000000013b127824ULL, 0x040fe200078e0200ULL,
0x00000008383e7810ULL, 0x000fe20007ffe0ffULL, 0x000000083b3b7824ULL, 0x000fe200078e00ffULL,
0x00005f003a3a7a11ULL, 0x000fc600030f3c3dULL, 0x000000013e3d7824ULL, 0x100fe200078e0215ULL,
0xfffffff83b127812ULL, 0x000fe200078ee212ULL, 0x00000001443b7824ULL, 0x000fe400078e0215ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010397faeULL, 0x0005e2000c101c46ULL,
0x000000013c167824ULL, 0x000fe200078e023dULL, 0x0000004514147210ULL, 0x000fc80007f1e0ffULL,
0x0000001643387210ULL, 0x000fe20007fde0ffULL, 0x000000ffff157224ULL, 0x000fe200000e063aULL,
0x000000043e00720cULL, 0x000fc60003f06070ULL, 0x000000ffff3f7224ULL, 0x000fe400030e06ffULL,
0x0000001012397824ULL, 0x004fe400078e0217ULL, 0x000000013c107824ULL, 0x000fc600078e023bULL,
0x0000000014397faeULL, 0x0005e2000e901c46ULL, 0x00005e0038117a11ULL, 0x040fe400078a38ffULL,
0x0000001043167210ULL, 0x000fe40007fde0ffULL, 0x00005f0038127a11ULL, 0x000fe400028f3c3fULL,
0x000000044400720cULL, 0x000fe20003fa6070ULL, 0x000000ffff3f7224ULL, 0x000fe200030e06ffULL,
0x0000004511107210ULL, 0x000fe20007fde0ffULL, 0x000000013d047824ULL, 0x000fc400078e0200ULL,
0x000000083d3d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff117224ULL, 0x000fe200030e0612ULL,
0x00005e0016147a11ULL, 0x044fe200078c38ffULL, 0x000000013b127824ULL, 0x000fe200078e0200ULL,
0xfffffff83d047812ULL, 0x000fe200078ee204ULL, 0x000000083b3b7824ULL, 0x000fe200078e00ffULL,
0x00005f0016157a11ULL, 0x000fe400030f3c3fULL, 0x0000004514147210ULL, 0x000fe20007fde0ffULL,
0x0000001004397824ULL, 0x000fe200078e0217ULL, 0xfffffff83b127812ULL, 0x000fc600078ee212ULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x0000000010397faeULL, 0x0005e2000c101c46ULL,
0x0000001012177824ULL, 0x000fca00078e0217ULL, 0x0000000014177faeULL, 0x0005e2000e901c46ULL,
0x000003c000007947ULL, 0x000fea0003800000ULL, 0x0000001010117812ULL, 0x000fc800078ec0ffULL,
0x0000001100117211ULL, 0x000fc800078fe8ffULL, 0x0000000411157810ULL, 0x040fe20007ffe0ffULL,
0x0000000111107824ULL, 0x140fe400078e0200ULL, 0x0000000811177824ULL, 0x000fe400078e00ffULL,
0x000000013c047824ULL, 0x040fe400078e0211ULL, 0x0000000115147824ULL, 0x000fe200078e0200ULL,
0xfffffff817127812ULL, 0x000fe200078ee210ULL, 0x0000000815397824ULL, 0x000fe200078e00ffULL,
0x0000000811177810ULL, 0x000fe20007ffe0ffULL, 0x000000013c157824ULL, 0x000fe200078e0215ULL,
0x00000004433f7210ULL, 0x000fc40007f1e0ffULL, 0x0000000c11117810ULL, 0x000fe20007ffe0ffULL,
0x000000013c107824ULL, 0x040fe200078e0217ULL, 0xfffffff839047812ULL, 0x000fe200078ee214ULL,
0x000000ffff167224ULL, 0x000fe200000e06ffULL, 0x00005e003f3e7a11ULL, 0x000fe200078038ffULL,
0x000000013c147824ULL, 0x000fe200078e0211ULL, 0x0000001543157210ULL, 0x000fe20007fde0ffULL,
0x0000000811397824ULL, 0x000fe200078e00ffULL, 0x00000010433c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000117107824ULL, 0x000fe200078e0200ULL, 0x00005f003f3f7a11ULL, 0x000fe200000f3c16ULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0x00000014433a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff167224ULL, 0x000fe200030e06ffULL, 0x00005e00153b7a11ULL, 0x000fe200078c38ffULL,
0x0000000111147824ULL, 0x000fe200078e0200ULL, 0xfffffff817177812ULL, 0x000fe200078ee210ULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x00005f00153d7a11ULL, 0x000fe200030f3c16ULL,
0x000000ffff157224ULL, 0x000fe200028e06ffULL, 0x00005e003c167a11ULL, 0x000fe200078a38ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x0000007010437812ULL, 0x000fc400078ec0ffULL,
0x00005f003c3c7a11ULL, 0x000fe200028f3c15ULL, 0x000000020e157824ULL, 0x000fe200078e0249ULL,
0xfffffff839397812ULL, 0x000fe400078ee214ULL, 0x00005e003a387a11ULL, 0x000fe400078c38ffULL,
0x000000433e107210ULL, 0x080fe40007f1e0ffULL, 0x000000433b147210ULL, 0x080fe40007fbe0ffULL,
0x00005f003a3a7a11ULL, 0x000fe200030f3c11ULL, 0x000000ffff117224ULL, 0x000fe200000e063fULL,
0x0000b000153e7811ULL, 0x000fe200078e60ffULL, 0x000000ffff157224ULL, 0x000fe200028e063dULL,
0x0000004316167210ULL, 0x000fc40007f1e0ffULL, 0x0000004338387210ULL, 0x000fe20007fbe0ffULL,
0x00000010123b7824ULL, 0x100fe400078e023eULL, 0x00000010043d7824ULL, 0x100fe400078e023eULL,
0x00000010173f7824ULL, 0x100fe200078e023eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000103b7faeULL, 0x0005e2000b901c46ULL, 0x0000001039437824ULL, 0x000fe400078e023eULL,
0x000000ffff177224ULL, 0x000fe200000e063cULL, 0x00000000143d7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff397224ULL, 0x000fc600028e063aULL, 0x00000000163f7faeULL, 0x0005e8000b901c46ULL,
0x0000000038437faeULL, 0x0005e4000b901c46ULL, 0x0000000841127824ULL, 0x000fe200078e00ffULL,
0x0000000157117810ULL, 0x004fe20007ffe0ffULL, 0xffffffffff047424ULL, 0x000fc600078e00ffULL,
0xfffffff012147812ULL, 0x000fe400078ec0ffULL, 0x000000401100720cULL, 0x000fc60003f06070ULL,
0x0000000849477824ULL, 0x000fca00078e0214ULL, 0x0000000000007918ULL, 0x000fea0000000000ULL,
0x0000000106108824ULL, 0x000fe400078e0211ULL, 0x00000004ff118424ULL, 0x000fe200078e00ffULL,
0xffffffe0124d7812ULL, 0x040fe400078ec0ffULL, 0x0000001012147812ULL, 0x000fe200078ec0ffULL,
0x0000600010108625ULL, 0x000fe200078e0011ULL, 0x0000000812127812ULL, 0x000fe200078ec0ffULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x0000f6a8475a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000610048981ULL, 0x000522000c1e1900ULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x0000004d124d7210ULL, 0x000fd60007ffe014ULL, 0x000000005a0403c2ULL, 0x000ee40000060000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00b9b0ULL, 0x008fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20001f0f070ULL,
0xffffff8000003947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a80047607f8cULL, 0x0006a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f608004d167f8cULL, 0x0006a4000c80043fULL, 0x0000000000107805ULL, 0x004fc40000015200ULL,
0x00f60c004d157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x004fc40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410397210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011415ULL,
0x0000003912127211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000212127819ULL, 0x000fc80000001215ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60c004d157984ULL, 0x000ea40000000800ULL,
0x8000000015ff7812ULL, 0x004fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x00000001ff4b7819ULL, 0x000fe20000011600ULL,
0x00000020414c7824ULL, 0x000fe400078e00ffULL, 0xffffffffff467424ULL, 0x000fe200078e00ffULL,
0x0000007010387812ULL, 0x000fc400078ec0ffULL, 0xffffff804c4c7812ULL, 0x000fe400078ec0ffULL,
0x0000000c4b4b7812ULL, 0x000fc800078ec0ffULL, 0x0000004c4b107210ULL, 0x000fca0007ffe038ULL,
0x00f0000010127984ULL, 0x000ea80000000800ULL, 0x00f2000010147984ULL, 0x0006620000000800ULL,
0x0000005d1200720bULL, 0x004fe20003f1d000ULL, 0x0000c1427f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x008fc800000e0100ULL, 0x0000ffff103a7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff507424ULL, 0x000fe400078e00ffULL,
0x000000ffff567224ULL, 0x000fc400078e005dULL, 0x0000001fff487424ULL, 0x000fe400078e00ffULL,
0xffffffffff457424ULL, 0x000fca00078e00ffULL, 0x0000043000008947ULL, 0x000fea0003800000ULL,
0x000000410d00720cULL, 0x000fe40003fa5270ULL, 0x0000005d1200720bULL, 0x000fe20003f14000ULL,
0x0000c0e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000157806ULL, 0x000fc400000e0100ULL,
0x000000804110d824ULL, 0x000fe200078e0238ULL, 0x000000125d567209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe40003800000ULL, 0x000000014b11d824ULL, 0x000fe200078e0210ULL,
0x0000991015107816ULL, 0x000fc800000000ffULL, 0x00f400561100d388ULL, 0x0005e20000000800ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x800000565d107221ULL, 0x004fe20000010000ULL, 0x000000ff15ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000397308ULL, 0x0004ec0000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x004fe20000011600ULL, 0x0000c0227f007947ULL, 0x000fea000b800000ULL,
0x00001f1039107589ULL, 0x0084e400000e0000ULL, 0x0000001024247220ULL, 0x088fe20000410000ULL,
0x0000001025257220ULL, 0x080fe20000410000ULL, 0x0000001034347220ULL, 0x080fe20000410000ULL,
0x0000001035357220ULL, 0x080fe20000410000ULL, 0x0000001030307220ULL, 0x080fe20000410000ULL,
0x0000001031317220ULL, 0x080fe20000410000ULL, 0x0000001020207220ULL, 0x080fe20000410000ULL,
0x0000001021217220ULL, 0x080fe20000410000ULL, 0x000000101c1c7220ULL, 0x080fe20000410000ULL,
0x000000101d1d7220ULL, 0x080fe20000410000ULL, 0x000000102c2c7220ULL, 0x080fe20000410000ULL,
0x000000102d2d7220ULL, 0x080fe20000410000ULL, 0x0000001028287220ULL, 0x080fe20000410000ULL,
0x0000001029297220ULL, 0x080fe20000410000ULL, 0x0000001018187220ULL, 0x080fe20000410000ULL,
0x0000001019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0015ff7812ULL, 0x000fe2000780c0ffULL, 0x0000003905057220ULL, 0x008fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000800107811ULL, 0x004fe200078ff0ffULL,
0x0000bf027f007947ULL, 0x000fea000b800000ULL, 0x00001f1039107589ULL, 0x0004e400000e0000ULL,
0x0000001026267220ULL, 0x088fe20000410000ULL, 0x0000001027277220ULL, 0x080fe20000410000ULL,
0x0000001036367220ULL, 0x080fe20000410000ULL, 0x0000001037377220ULL, 0x080fe20000410000ULL,
0x0000001032327220ULL, 0x080fe20000410000ULL, 0x0000001033337220ULL, 0x080fe20000410000ULL,
0x0000001022227220ULL, 0x080fe20000410000ULL, 0x0000001023237220ULL, 0x080fe20000410000ULL,
0x000000101e1e7220ULL, 0x080fe20000410000ULL, 0x000000101f1f7220ULL, 0x080fe20000410000ULL,
0x000000102e2e7220ULL, 0x080fe20000410000ULL, 0x000000102f2f7220ULL, 0x080fe20000410000ULL,
0x000000102a2a7220ULL, 0x080fe20000410000ULL, 0x000000102b2b7220ULL, 0x080fe20000410000ULL,
0x000000101a1a7220ULL, 0x080fe20000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff3aff7812ULL, 0x000fda0007806015ULL,
0x8000005612120221ULL, 0x000fe20000010000ULL, 0x00007610ff500816ULL, 0x000fc60000000050ULL,
0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL, 0x00000012000a0308ULL, 0x000ea40000000800ULL,
0x0000000a14140220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000514057221ULL, 0x002fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x000000020e127824ULL, 0x000fc800078e0213ULL, 0x0000000812167824ULL, 0x000fca00078e00ffULL,
0x00f6ac0016127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe4000780485fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011415ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000212127819ULL, 0x000fc80000001215ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0016127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe4000780485fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991050107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x0000000aff0b723eULL, 0x000fe400000000ffULL, 0x00000002ff127819ULL, 0x000fe40000011600ULL,
0x000054100b157816ULL, 0x000fe2000000000bULL, 0x0000bae27f007947ULL, 0x000fea000b800000ULL,
0x00001f12150b7589ULL, 0x0002a400000e0000ULL, 0x00000008120c7810ULL, 0x000fe20007ffe0ffULL,
0x0000bb127f007947ULL, 0x000fea000b800000ULL, 0x00001f0c150c7589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001012107810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0015ULL, 0x00002bd000387802ULL, 0x000fc40000000f00ULL,
0x0000c55000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001812107810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0015ULL,
0x00002c2000387802ULL, 0x000fc40000000f00ULL, 0x0000c50000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000700117812ULL, 0x000fe200078ec0ffULL,
0x00000002414a7824ULL, 0x040fe200078e00ffULL, 0x00000004ff517819ULL, 0x100fe20000011600ULL,
0x0000020041437824ULL, 0x000fe200078e00ffULL, 0x00000008113e7812ULL, 0x000fe200078ef800ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000044a117812ULL, 0x000fc400078ec0ffULL,
0xfffff80043437812ULL, 0x000fe200078ec0ffULL, 0x000000083e447824ULL, 0x040fe200078e00ffULL,
0x000000113e117210ULL, 0x000fc80007ffe051ULL, 0xfffffff844447812ULL, 0x000fe400078ee211ULL,
0x0000000800117812ULL, 0x000fc600078ec0ffULL, 0x0000001044447824ULL, 0x000fc400078e0243ULL,
0x00000004415b7824ULL, 0x000fe200078e00ffULL, 0x00000007115c7812ULL, 0x000fe200078ef800ULL,
0x000000020e4f7824ULL, 0x000fe200078e0213ULL, 0x009000004414783bULL, 0x00ee640000000200ULL,
0x000000045b5b7812ULL, 0x000fe200078ec0ffULL, 0x000000085c117824ULL, 0x040fe200078e00ffULL,
0x0000b0004f4f7811ULL, 0x000fe200078e60ffULL, 0x000000085c397824ULL, 0x040fe200078e00ffULL,
0x000000105c587812ULL, 0x000fe200078efcffULL, 0x00000001515b7824ULL, 0x000fc800078e025bULL,
0x000000015c387824ULL, 0x000fe400078e025bULL, 0x0000000858527824ULL, 0x000fc600078e00ffULL,
0xfffffff811107812ULL, 0x000fe400078ee238ULL, 0x0000000238547810ULL, 0x000fc60007ffe0ffULL,
0x0000001010107824ULL, 0x000fe200078e024fULL, 0xfffffff839547812ULL, 0x000fca00078ee254ULL,
0x000000001010783bULL, 0x000ea20000004200ULL, 0x0000001054387824ULL, 0x000fcc00078e024fULL,
0x000000003838783bULL, 0x000ee20000004200ULL, 0x0000000b14148232ULL, 0x082fe40000000000ULL,
0x0000000b16168232ULL, 0x000fe40000000000ULL, 0x0000000c15158232ULL, 0x080fe40000000000ULL,
0x0000000c17178232ULL, 0x000fe20000000000ULL, 0x00003120103f7816ULL, 0x004fe400000000ffULL,
0x0000312011117816ULL, 0x000fc400000000ffULL, 0x0000003fff3c723eULL, 0x000fe400020006ffULL,
0x00000011ff3d723eULL, 0x000fe400020006ffULL, 0x0000003fff10723eULL, 0x000fe400030006ffULL,
0x00000011ff11723eULL, 0x000fe400030006ffULL, 0x0000312012127816ULL, 0x000fe200000000ffULL,
0x0000003c1424723cULL, 0x000b620000001824ULL, 0x0000312013137816ULL, 0x000fc400000000ffULL,
0x0000312038537816ULL, 0x008fe400000000ffULL, 0x0000312039557816ULL, 0x000fe400000000ffULL,
0x000000040e3d7824ULL, 0x020fe200078e0251ULL, 0x000000101434723cULL, 0x000b620000001834ULL,
0x000000083e3c7824ULL, 0x000fe200078e00ffULL, 0x00000053ff38723eULL, 0x000fe200020006ffULL,
0x000000015b517824ULL, 0x000fe200078e0258ULL, 0x000000023d3d7810ULL, 0x000fe40007ffe03eULL,
0x00000055ff39723eULL, 0x000fc400020006ffULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee23dULL,
0xfffffff852527812ULL, 0x000fe400078ee251ULL, 0x00000013ff3d723eULL, 0x080fe200030006ffULL,
0x000000103c437824ULL, 0x000fe200078e0243ULL, 0x00000012ff3c723eULL, 0x080fe200030006ffULL,
0x00000010523e7824ULL, 0x000fe200078e024fULL, 0x00000012ff10723eULL, 0x020fe200020006ffULL,
0x00000038141c723cULL, 0x000be2000000181cULL, 0x00000013ff11723eULL, 0x000fc400020006ffULL,
0x000031203a3a7816ULL, 0x000fe400000000ffULL, 0x000031203b3b7816ULL, 0x000fe400000000ffULL,
0x00000053ff38723eULL, 0x020fe200030006ffULL, 0x0000003c1420723cULL, 0x000be20000001820ULL,
0x00000055ff39723eULL, 0x000fe200030006ffULL, 0x000000003e3c783bULL, 0x020e620000004200ULL,
0x0000991050537816ULL, 0x000fe200000000ffULL, 0x0000000858557824ULL, 0x000fe200078e00ffULL,
0x0000000251507810ULL, 0x000fc40007ffe0ffULL, 0x000000ff5300720cULL, 0x000fe20003f05270ULL,
0x000000101430723cULL, 0x000b620000001830ULL, 0xfffffff855507812ULL, 0x000fe200078ee250ULL,
0x009000004310783bULL, 0x020ea20000000200ULL, 0x0000003aff58723eULL, 0x000fe400030006ffULL,
0x0000003bff59723eULL, 0x000fc600030006ffULL, 0x00000038142c723cULL, 0x040b6e000000182cULL,
0x0000003aff38723eULL, 0x020fe200020006ffULL, 0x000000581418723cULL, 0x000fe20000001818ULL,
0x0000003bff39723eULL, 0x000fce00020006ffULL, 0x000000381428723cULL, 0x000b6e0000001828ULL,
0x0000001050387824ULL, 0x020fe200078e024fULL, 0x000031203c3c7816ULL, 0x002fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fc600000000ffULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x0000003cff14723eULL, 0x000fe400020006ffULL, 0x0000003dff15723eULL, 0x000fe200020006ffULL,
0x0000000b10108232ULL, 0x084fe20000000000ULL, 0x000031203e3e7816ULL, 0x000fe200000000ffULL,
0x0000000b12128232ULL, 0x000fe20000000000ULL, 0x000031203f3f7816ULL, 0x000fe200000000ffULL,
0x0000000c11118232ULL, 0x080fe40000000000ULL, 0x0000000c13138232ULL, 0x000fce0000000000ULL,
0x000000141024723cULL, 0x000b6e0000001824ULL, 0x0000003cff14723eULL, 0x020fe400030006ffULL,
0x0000003dff15723eULL, 0x000fce00030006ffULL, 0x000000141034723cULL, 0x000b620000001834ULL,
0x0000312038387816ULL, 0x002fcc00000000ffULL, 0x0000003eff14723eULL, 0x0a0fe400020006ffULL,
0x0000003fff15723eULL, 0x000fe400020006ffULL, 0x0000312039397816ULL, 0x000fe400000000ffULL,
0x000031203a3a7816ULL, 0x000fe400000000ffULL, 0x000031203b3b7816ULL, 0x000fe200000000ffULL,
0x000000141030723cULL, 0x000b6e0000001830ULL, 0x0000003eff14723eULL, 0x020fc400030006ffULL,
0x0000003fff15723eULL, 0x000fce00030006ffULL, 0x000000141020723cULL, 0x000b6e0000001820ULL,
0x00000038ff14723eULL, 0x0a0fe400020006ffULL, 0x00000039ff15723eULL, 0x000fe400020006ffULL,
0x00000038ff38723eULL, 0x000fc400030006ffULL, 0x00000039ff39723eULL, 0x000fc600030006ffULL,
0x00000014101c723cULL, 0x040b6e000000181cULL, 0x0000003aff14723eULL, 0x0a0fe200020006ffULL,
0x00000038102c723cULL, 0x000f62000000182cULL, 0x0000003bff15723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fc400030006ffULL, 0x0000003bff3b723eULL, 0x000fc600030006ffULL,
0x000000141028723cULL, 0x040b6e0000001828ULL, 0x000000080e147824ULL, 0x020fe200078e00ffULL,
0x0000003a1018723cULL, 0x000b620000001818ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x00f6c80014147f8cULL, 0x000e62000c80043fULL, 0xfffffff84a4a7812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000004008117811ULL, 0x020fe200078e40ffULL,
0x00f688004aff7f8cULL, 0x0005e2000c80043fULL, 0x0000000157577810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5d7224ULL, 0x000fe200078e0056ULL, 0x000000421100720cULL, 0x000fe20003f06070ULL,
0x000000ffff5f7224ULL, 0x000fc400078e0061ULL, 0x000000ffff137224ULL, 0x000fd400078e0049ULL,
0x00005bd000000947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x004fc40000015200ULL,
0x000004004e127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x006fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004004e127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001041117824ULL, 0x000fe200078e00ffULL, 0x0000000108107810ULL, 0x000fe20007ffe0ffULL,
0x0000580004047a24ULL, 0x010fc600078e02ffULL, 0x0000000f1000720cULL, 0x000fe20003f06070ULL,
0x0000004004047824ULL, 0x000fe200078e00ffULL, 0xffffffe011137812ULL, 0x000fca00078ec0ffULL,
0x0000010008137824ULL, 0x000fca00078e0213ULL, 0x0000008013397810ULL, 0x000fc80007ffe0ffULL,
0x0000002002137812ULL, 0x000fe200078ef839ULL, 0x000004b000008947ULL, 0x000fea0003800000ULL,
0x0000001011387812ULL, 0x000fe200078ec0ffULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x00000003ff3d7819ULL, 0x000fe40000011600ULL, 0x0000003942107217ULL, 0x000fe40007800000ULL,
0x000000043d3f7810ULL, 0x040fe20007ffe0ffULL, 0x000000013d3a7824ULL, 0x000fe200078e0238ULL,
0x0000007012127812ULL, 0x000fc600078ec0ffULL, 0x000000013a117824ULL, 0x040fe400078e0213ULL,
0x000000013f3e7824ULL, 0x000fe400078e0238ULL, 0x000000083a3c7824ULL, 0x000fe200078e00ffULL,
0x0000001104147210ULL, 0x000fe20007f1e0ffULL, 0x0000000110117824ULL, 0x000fe400078e0a39ULL,
0x0000100009107824ULL, 0x000fe400078e00ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x00005e0014177a11ULL, 0x000fe200078038ffULL, 0x000000013a397824ULL, 0x000fe200078e0200ULL,
0x0000001138117217ULL, 0x000fe20007800000ULL, 0x000000083e517824ULL, 0x000fe200078e00ffULL,
0x00005f0014147a11ULL, 0x000fc400000f3c15ULL, 0x0000100010157812ULL, 0x000fe200078ec0ffULL,
0x0000000111167824ULL, 0x000fe200078e0a38ULL, 0x0000001217107210ULL, 0x000fe20007fbe0ffULL,
0x000000013e117824ULL, 0x000fe200078e0213ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee239ULL,
0x000020000e157824ULL, 0x000fe200078e0215ULL, 0x000000163d00720cULL, 0x080fe40003f06070ULL,
0x00000011043a7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff117224ULL, 0x000fe200028e0614ULL,
0x000000163f00720cULL, 0x000fc40003fa6070ULL, 0x0000b00015177810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200030e06ffULL, 0x000000083d3f7810ULL, 0x040fe40007ffe0ffULL,
0x00005e003a3b7a11ULL, 0x000fe200078c38ffULL, 0x000000103c397824ULL, 0x000fe200078e0217ULL,
0x0000000c3d3d7810ULL, 0x000fe20007ffe0ffULL, 0x000000013f4f7824ULL, 0x000fe200078e0238ULL,
0x00005f003a3a7a11ULL, 0x000fe200030f3c15ULL, 0x000000013e3c7824ULL, 0x000fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010397faeULL, 0x0003e2000c101c46ULL,
0x000000014f157824ULL, 0x000fe200078e0213ULL, 0x000000123b147210ULL, 0x000fe20007f1e0ffULL,
0x000000013d3e7824ULL, 0x000fe200078e0238ULL, 0xfffffff8513c7812ULL, 0x000fc400078ee23cULL,
0x0000001504387210ULL, 0x000fe20007fde0ffULL, 0x000000013e137824ULL, 0x000fe400078e0213ULL,
0x000000ffff157224ULL, 0x000fe200000e063aULL, 0x000000163f00720cULL, 0x000fe20003f06070ULL,
0x000000ffff3b7224ULL, 0x000fe200030e06ffULL, 0x0000001304047210ULL, 0x000fe20007fde0ffULL,
0x000000103c397824ULL, 0x002fc800078e0217ULL, 0x000000ffff137224ULL, 0x000fe200030e06ffULL,
0x0000000014397faeULL, 0x0003e2000e901c46ULL, 0x00005e0038117a11ULL, 0x000fc800078a38ffULL,
0x00005f0038387a11ULL, 0x000fe400028f3c3bULL, 0x0000001211107210ULL, 0x000fe40007fde0ffULL,
0x000000163d00720cULL, 0x000fe20003fa6070ULL, 0x000000014f167824ULL, 0x040fe400078e0200ULL,
0x000000084f4f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff117224ULL, 0x000fe200030e0638ULL,
0x00005e0004157a11ULL, 0x002fe200078c38ffULL, 0x000000013e387824ULL, 0x040fe200078e0200ULL,
0xfffffff84f167812ULL, 0x000fe200078ee216ULL, 0x000000083e397824ULL, 0x000fe200078e00ffULL,
0x00005f0004047a11ULL, 0x000fc400030f3c13ULL, 0x0000001215147210ULL, 0x000fe20007fde0ffULL,
0x0000001016137824ULL, 0x000fe200078e0217ULL, 0xfffffff839387812ULL, 0x000fc600078ee238ULL,
0x000000ffff157224ULL, 0x000fe200030e0604ULL, 0x0000000010137faeULL, 0x0003e2000c101c46ULL,
0x0000001038177824ULL, 0x000fca00078e0217ULL, 0x0000000014177faeULL, 0x0003e2000e901c46ULL,
0x000003e000007947ULL, 0x000fea0003800000ULL, 0x0000001011117812ULL, 0x000fc800078ec0ffULL,
0x0000001100107211ULL, 0x000fc800078fe8ffULL, 0x0000000410157810ULL, 0x040fe20007ffe0ffULL,
0x0000000110127824ULL, 0x140fe200078e0200ULL, 0x0000000c10387810ULL, 0x040fe20007ffe0ffULL,
0x0000000810397824ULL, 0x040fe400078e00ffULL, 0x0000000110117824ULL, 0x100fe400078e0213ULL,
0x0000000115177824ULL, 0x000fe200078e0200ULL, 0xfffffff839147812ULL, 0x000fe200078ee212ULL,
0x00000008153c7824ULL, 0x040fe200078e00ffULL, 0x0000001104167210ULL, 0x000fe20007f1e0ffULL,
0x0000000115117824ULL, 0x000fe200078e0213ULL, 0x0000000810127810ULL, 0x000fe20007ffe0ffULL,
0x0000100009107824ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee217ULL,
0x000000ffff177224ULL, 0x000fe200000e06ffULL, 0x00005e00163b7a11ULL, 0x000fe200078038ffULL,
0x0000000112157824ULL, 0x100fe200078e0213ULL, 0x0000001104117210ULL, 0x000fe20007fde0ffULL,
0x0000000138137824ULL, 0x000fe200078e0213ULL, 0x00005f0016167a11ULL, 0x000fe200000f3c17ULL,
0x00000008123e7824ULL, 0x000fe200078e00ffULL, 0x0000001504157210ULL, 0x000fe20007fbe0ffULL,
0x0000000838177824ULL, 0x000fe200078e00ffULL, 0x0000001304047210ULL, 0x000fe20007f1e0ffULL,
0x0000000112137824ULL, 0x000fc400078e0200ULL, 0x0000000138127824ULL, 0x000fe400078e0200ULL,
0x000000ffff387224ULL, 0x000fe200030e06ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL,
0x000000ffff3a7224ULL, 0x000fe200028e06ffULL, 0x0000100010137812ULL, 0x000fe400078ec0ffULL,
0x00005e00113d7a11ULL, 0x000fe400078c38ffULL, 0xfffffff817587812ULL, 0x000fe200078ee212ULL,
0x000020000e137824ULL, 0x000fe200078e0213ULL, 0x00005f0011387a11ULL, 0x000fe200030f3c38ULL,
0x0000001000127824ULL, 0x000fe200078e00ffULL, 0x00005e0004397a11ULL, 0x000fe200078a38ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x00005e0015177a11ULL, 0x000fc400078038ffULL,
0x0000b000133f7810ULL, 0x000fe40007ffe0ffULL, 0x0000007012127812ULL, 0x000fe400078ec0ffULL,
0x00005f00153a7a11ULL, 0x000fe200000f3c3aULL, 0x0000001014137824ULL, 0x000fe200078e023fULL,
0x00005f0004047a11ULL, 0x000fe400028f3c11ULL, 0x000000123b107210ULL, 0x080fe20007f1e0ffULL,
0x000000103c3b7824ULL, 0x100fe200078e023fULL, 0x000000123d147210ULL, 0x000fe20007fbe0ffULL,
0x000000103e3d7824ULL, 0x000fc400078e023fULL, 0x000000ffff117224ULL, 0x000fe200000e0616ULL,
0x0000001217167210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200028e0638ULL,
0x0000001239387210ULL, 0x000fe20007fbe0ffULL, 0x00000010583f7824ULL, 0x000fe200078e023fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000b901c46ULL,
0x000000ffff177224ULL, 0x000fe400000e063aULL, 0x000000ffff397224ULL, 0x000fe200028e0604ULL,
0x00000000143b7faeULL, 0x0003e8000b901c46ULL, 0x00000000163d7faeULL, 0x0003e8000b901c46ULL,
0x00000000383f7faeULL, 0x0003e4000b901c46ULL, 0x0000000841147824ULL, 0x002fe200078e00ffULL,
0x0000000207117810ULL, 0x000fe20007ffe0ffULL, 0x0000000809137824ULL, 0x000fc400078e00ffULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0xfffffff014147812ULL, 0x000fe400078ec0ffULL,
0x0000000813137812ULL, 0x000fe400078ec0ffULL, 0x000000401100720cULL, 0x000fc60003f06070ULL,
0x0000000114597824ULL, 0x000fca00078e0213ULL, 0x0000000000007918ULL, 0x000fea0000000000ULL,
0x0000000206108810ULL, 0x000fe20007ffe007ULL, 0x00000004ff118424ULL, 0x000fc800078e00ffULL,
0x0000600010108625ULL, 0x000fe200078e0011ULL, 0x000000c000007945ULL, 0x000fe20003800000ULL,
0x0000f6a859587810ULL, 0x000fc60007ffe0ffULL, 0x0000000610048981ULL, 0x000322000c1e1900ULL,
0x000000000000781cULL, 0x000fda0003f0f070ULL, 0x00000000580403c2ULL, 0x000ea40000040000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00a9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000170f070ULL,
0xffffff8000002947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800595e7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f628004d107f8cULL, 0x0022a4000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x00f62c004d137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x006fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614167210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011417ULL,
0x0000001613137211ULL, 0x000fca00078110ffULL, 0x000000ffff167224ULL, 0x000fca00000e0617ULL,
0x0000000213137819ULL, 0x000fc80000001216ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f62c004d137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008012107810ULL, 0x000fca0007ffe04cULL, 0x000000014b107824ULL, 0x000fca00078e0210ULL,
0x00f0000010137984ULL, 0x000e680000000800ULL, 0x00f2000010147984ULL, 0x0004e20000000800ULL,
0x000000561300720bULL, 0x002fe20003f1d000ULL, 0x0000a1c27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000157806ULL, 0x004fc800000e0100ULL, 0x0000ffff15ff7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000ffff5d7224ULL, 0x000fd200078e0056ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000010d107810ULL, 0x000fe40007ffe0ffULL, 0x000000561300720bULL, 0x000fe40003f14000ULL,
0x000000411000720cULL, 0x000fe20003fa5270ULL, 0x0000a1727f007947ULL, 0x000fd4000b800000ULL,
0x0000000000167806ULL, 0x000fc400000e0100ULL, 0x000000804112d824ULL, 0x000fe200078e0212ULL,
0x000000561310d209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991016117816ULL, 0x000fe200000000ffULL, 0x000000014b17d824ULL, 0x000fc600078e0212ULL,
0x000000ff1100720cULL, 0x000fe40003f05270ULL, 0x00f400101700d388ULL, 0x0003f60000000800ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000005613117209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff16ff7812ULL, 0x000fc6000780c0ffULL,
0x0000005611107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000127308ULL, 0x000e640000000800ULL, 0x0000001205057220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe20000011600ULL,
0x0000a0827f007947ULL, 0x000fea000b800000ULL, 0x00001f1012107589ULL, 0x0002a400000e0000ULL,
0x0000001024247220ULL, 0x084fe20000410000ULL, 0x0000001025257220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001030307220ULL, 0x080fe20000410000ULL, 0x0000001031317220ULL, 0x080fe20000410000ULL,
0x0000001020207220ULL, 0x080fe20000410000ULL, 0x0000001021217220ULL, 0x080fe20000410000ULL,
0x000000101c1c7220ULL, 0x080fe20000410000ULL, 0x000000101d1d7220ULL, 0x080fe20000410000ULL,
0x000000102c2c7220ULL, 0x080fe20000410000ULL, 0x000000102d2d7220ULL, 0x080fe20000410000ULL,
0x0000001028287220ULL, 0x080fe20000410000ULL, 0x0000001029297220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000800107811ULL, 0x000fe200078ff0ffULL,
0x00009f727f007947ULL, 0x000fea000b800000ULL, 0x00001f1012107589ULL, 0x00046400000e0000ULL,
0x0000001026267220ULL, 0x082fe20000410000ULL, 0x0000001027277220ULL, 0x080fe20000410000ULL,
0x0000001036367220ULL, 0x080fe20000410000ULL, 0x0000001037377220ULL, 0x080fe20000410000ULL,
0x0000001032327220ULL, 0x080fe20000410000ULL, 0x0000001033337220ULL, 0x080fe20000410000ULL,
0x0000001022227220ULL, 0x080fe20000410000ULL, 0x0000001023237220ULL, 0x080fe20000410000ULL,
0x000000101e1e7220ULL, 0x080fe20000410000ULL, 0x000000101f1f7220ULL, 0x080fe20000410000ULL,
0x000000102e2e7220ULL, 0x080fe20000410000ULL, 0x000000102f2f7220ULL, 0x080fe20000410000ULL,
0x000000102a2a7220ULL, 0x080fe20000410000ULL, 0x000000102b2b7220ULL, 0x080fe20000410000ULL,
0x000000101a1a7220ULL, 0x080fe20000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff16ff7812ULL, 0x000fe20007800815ULL,
0x00000001ff167424ULL, 0x000fe200078e00ffULL, 0x00000056135d7209ULL, 0x000fd60007810000ULL,
0x8000005d13130221ULL, 0x000fe20000010000ULL, 0x00007610ff160816ULL, 0x000fc60000000016ULL,
0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL, 0x00000013000a0308ULL, 0x000e640000000800ULL,
0x0000000a14140220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000514057221ULL, 0x008fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x00f6ac0047137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804861ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x004fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0047137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804861ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991016107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x0000000aff0b723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe40000011600ULL,
0x000054100b127816ULL, 0x004fe2000000000bULL, 0x00009b527f007947ULL, 0x000fea000b800000ULL,
0x00001f13120b7589ULL, 0x0002a400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x00009b827f007947ULL, 0x000fea000b800000ULL, 0x00001f10120c7589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00004d5000387802ULL, 0x000fc40000000f00ULL,
0x0000a3d000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0012ULL,
0x00004da000387802ULL, 0x000fc40000000f00ULL, 0x0000a38000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000015c107824ULL, 0x048fe200078e025bULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000085c117824ULL, 0x000fe200078e00ffULL,
0x009800004414783bULL, 0x004ea20000000200ULL, 0x000000020e617824ULL, 0x000fc600078e0249ULL,
0xfffffff811107812ULL, 0x000fe400078ee210ULL, 0x0000b00061617811ULL, 0x000fca00078e60ffULL,
0x0000001010557824ULL, 0x100fe400078e0261ULL, 0x0000001054537824ULL, 0x100fe400078e0261ULL,
0x0000001052517824ULL, 0x000fe200078e0261ULL, 0x000000005510783bULL, 0x002e680000004200ULL,
0x00000000533c783bULL, 0x000ee20000004200ULL, 0x0000000b14148232ULL, 0x004fc40000000000ULL,
0x0000000b16168232ULL, 0x000fe40000000000ULL, 0x0000000c15158232ULL, 0x080fe40000000000ULL,
0x0000000c17178232ULL, 0x000fe20000000000ULL, 0x0000312010107816ULL, 0x002fe400000000ffULL,
0x0000312011117816ULL, 0x000fe400000000ffULL, 0x00000010ff38723eULL, 0x000fe400020006ffULL,
0x00000011ff39723eULL, 0x000fc400020006ffULL, 0x00000010ff10723eULL, 0x000fe400030006ffULL,
0x00000011ff11723eULL, 0x000fe400030006ffULL, 0x0000312012127816ULL, 0x000fe200000000ffULL,
0x000000381424723cULL, 0x000b620000001824ULL, 0x0000312013137816ULL, 0x000fe200000000ffULL,
0x000000005138783bULL, 0x020e620000004200ULL, 0x00000012ff56723eULL, 0x000fe400030006ffULL,
0x00000013ff57723eULL, 0x000fc400030006ffULL, 0x000031203c4f7816ULL, 0x008fe200000000ffULL,
0x000000101434723cULL, 0x040b620000001834ULL, 0x000031203d5e7816ULL, 0x000fe400000000ffULL,
0x0000004fff3c723eULL, 0x000fe400020006ffULL, 0x0000005eff3d723eULL, 0x000fe400020006ffULL,
0x00000012ff10723eULL, 0x020fe200020006ffULL, 0x000000561420723cULL, 0x000be20000001820ULL,
0x00000013ff11723eULL, 0x000fc400020006ffULL, 0x000031203e3e7816ULL, 0x000fe400000000ffULL,
0x000031203f3f7816ULL, 0x000fe400000000ffULL, 0x0000003eff56723eULL, 0x020fe200030006ffULL,
0x000000101430723cULL, 0x040b620000001830ULL, 0x0000003fff57723eULL, 0x000fe200030006ffULL,
0x009800004310783bULL, 0x020eac0000000200ULL, 0x0000003c141c723cULL, 0x040b6e000000181cULL,
0x0000004fff3c723eULL, 0x020fe200030006ffULL, 0x00000010504f7824ULL, 0x000fe200078e0261ULL,
0x0000005eff3d723eULL, 0x000fe200030006ffULL, 0x000000561418723cULL, 0x000fe20000001818ULL,
0x0000312038387816ULL, 0x002fc400000000ffULL, 0x0000312039397816ULL, 0x000fe400000000ffULL,
0x000031203a3a7816ULL, 0x000fe400000000ffULL, 0x000031203b3b7816ULL, 0x000fe200000000ffULL,
0x0000003c142c723cULL, 0x000b6e000000182cULL, 0x0000003eff3c723eULL, 0x020fc400020006ffULL,
0x0000003fff3d723eULL, 0x000fce00020006ffULL, 0x0000003c1428723cULL, 0x000b620000001828ULL,
0x0000000b10108232ULL, 0x084fe20000000000ULL, 0x000000004f3c783bULL, 0x020e620000004200ULL,
0x0000000b12128232ULL, 0x000fe40000000000ULL, 0x0000000c11118232ULL, 0x080fe40000000000ULL,
0x0000000c13138232ULL, 0x000fe20000000000ULL, 0x00000038ff14723eULL, 0x000fe400020006ffULL,
0x00000039ff15723eULL, 0x000fce00020006ffULL, 0x000000141024723cULL, 0x000b6e0000001824ULL,
0x00000038ff14723eULL, 0x020fe400030006ffULL, 0x00000039ff15723eULL, 0x000fce00030006ffULL,
0x000000141034723cULL, 0x000b6e0000001834ULL, 0x0000003aff14723eULL, 0x020fe400020006ffULL,
0x0000003bff15723eULL, 0x000fe400020006ffULL, 0x000031203c3c7816ULL, 0x002fc400000000ffULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e3e7816ULL, 0x000fe200000000ffULL,
0x000000141030723cULL, 0x000b620000001830ULL, 0x000031203f3f7816ULL, 0x000fcc00000000ffULL,
0x0000003aff14723eULL, 0x020fe400030006ffULL, 0x0000003bff15723eULL, 0x000fce00030006ffULL,
0x000000141020723cULL, 0x000b6e0000001820ULL, 0x0000003cff14723eULL, 0x020fe400020006ffULL,
0x0000003dff15723eULL, 0x000fce00020006ffULL, 0x00000014101c723cULL, 0x000b6e000000181cULL,
0x0000003cff14723eULL, 0x020fe400030006ffULL, 0x0000003dff15723eULL, 0x000fce00030006ffULL,
0x00000014102c723cULL, 0x000b6e000000182cULL, 0x0000003eff14723eULL, 0x020fe400020006ffULL,
0x0000003fff15723eULL, 0x000fce00020006ffULL, 0x000000141028723cULL, 0x000b6e0000001828ULL,
0x0000003eff14723eULL, 0x020fe400030006ffULL, 0x0000003fff15723eULL, 0x000fce00030006ffULL,
0x000000141018723cULL, 0x000b6e0000001818ULL, 0x0000f6c80e107811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000010107f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000008008137811ULL, 0x000fe200078e40ffULL,
0x00f690004aff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff157224ULL, 0x002fe200078e0011ULL,
0x0000000207577810ULL, 0x000fc40007ffe0ffULL, 0x000000421300720cULL, 0x000fe40003f06070ULL,
0x0000000109137812ULL, 0x000fd600078ec0ffULL, 0x00003c8000000947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x004fc40000015200ULL, 0x000004004e107984ULL, 0x000e640000000800ULL,
0x8000000010ff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x0000001012177210ULL, 0x000fca0007f1e1ffULL, 0x0000000111117824ULL, 0x000fe200000e0e13ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x000fc80000011411ULL, 0x0000001710107211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0611ULL, 0x0000000210107819ULL, 0x000fc80000001211ULL,
0x000000100000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004004e107984ULL, 0x000e640000000800ULL, 0x8000000010ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001041117824ULL, 0x000fe200078e00ffULL,
0x0000000108107810ULL, 0x000fe20007ffe0ffULL, 0x0000580004047a24ULL, 0x010fc600078e02ffULL,
0x0000000f1000720cULL, 0x000fe20003f06070ULL, 0x0000004004047824ULL, 0x000fe200078e00ffULL,
0xffffffe011137812ULL, 0x000fca00078ec0ffULL, 0x0000010008137824ULL, 0x000fca00078e0213ULL,
0x000000c013137810ULL, 0x000fc80007ffe0ffULL, 0x0000002002147812ULL, 0x000fe200078ef813ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000010113b7812ULL, 0x000fe200078ec0ffULL,
0x0000001000387824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe40000011600ULL,
0x0000001342107217ULL, 0x000fe40007800000ULL, 0x00000004163e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000116177824ULL, 0x000fe200078e023bULL, 0x0000007038387812ULL, 0x000fe200078ec0ffULL,
0x0000000110107824ULL, 0x000fe200078e0a13ULL, 0x0000000c16567810ULL, 0x000fe20007ffe0ffULL,
0x0000000117117824ULL, 0x000fc400078e0214ULL, 0x000000013e3d7824ULL, 0x100fe200078e023bULL,
0x000000103b107217ULL, 0x000fe20007800000ULL, 0x0000000117397824ULL, 0x040fe200078e0200ULL,
0x0000001104117210ULL, 0x000fe20007f1e0ffULL, 0x00000008173c7824ULL, 0x000fe400078e00ffULL,
0x0000000110157824ULL, 0x000fe400078e0a3bULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x00005e0011137a11ULL, 0x000fe400078038ffULL, 0xfffffff83c3c7812ULL, 0x000fc400078ee239ULL,
0x00005f0011127a11ULL, 0x000fe200000f3c12ULL, 0x000000013d117824ULL, 0x000fe200078e0214ULL,
0x0000003813107210ULL, 0x000fe20007fbe0ffULL, 0x000000103c177824ULL, 0x000fe200078e0261ULL,
0x000000151600720cULL, 0x000fe20003f06070ULL, 0x000000013d3c7824ULL, 0x040fe200078e0200ULL,
0x00000011043a7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff117224ULL, 0x000fe200028e0612ULL,
0x000000153e00720cULL, 0x000fe20003fa6070ULL, 0x000000083d3d7824ULL, 0x000fe200078e00ffULL,
0x00000008163e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200030e06ffULL,
0x00005e003a397a11ULL, 0x000fc400078c38ffULL, 0xfffffff83d3c7812ULL, 0x000fe200078ee23cULL,
0x000000013e3f7824ULL, 0x000fe200078e023bULL, 0x00005f003a3a7a11ULL, 0x000fe200030f3c13ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0003e2000c101c46ULL,
0x0000003839127210ULL, 0x000fe20007f1e0ffULL, 0x000000013f137824ULL, 0x000fe400078e0214ULL,
0x00000001563d7824ULL, 0x000fc600078e023bULL, 0x0000001304167210ULL, 0x000fe20007fde0ffULL,
0x000000ffff137224ULL, 0x000fe200000e063aULL, 0x000000153e00720cULL, 0x000fe20003f06070ULL,
0x000000103c177824ULL, 0x002fe400078e0261ULL, 0x000000013d117824ULL, 0x000fe400078e0214ULL,
0x000000ffff397224ULL, 0x000fe200030e06ffULL, 0x0000000012177faeULL, 0x0003e2000e901c46ULL,
0x00005e00163b7a11ULL, 0x000fe200078a38ffULL, 0x000000013f147824ULL, 0x140fe200078e0200ULL,
0x0000001104047210ULL, 0x000fe20007fde0ffULL, 0x000000083f3f7824ULL, 0x000fe200078e00ffULL,
0x00005f0016117a11ULL, 0x000fe200028f3c39ULL, 0x000000083d167824ULL, 0x000fe200078e00ffULL,
0x000000155600720cULL, 0x000fe20003fa6070ULL, 0x000000ffff397224ULL, 0x000fe200030e06ffULL,
0x000000383b107210ULL, 0x000fe20007fde0ffULL, 0x000000013d157824ULL, 0x000fe200078e0200ULL,
0xfffffff83f147812ULL, 0x000fc600078ee214ULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x00005e0004137a11ULL, 0x002fe400078c38ffULL, 0xfffffff816167812ULL, 0x000fe200078ee215ULL,
0x0000001014157824ULL, 0x000fe200078e0261ULL, 0x00005f0004047a11ULL, 0x000fe400030f3c39ULL,
0x0000003813127210ULL, 0x000fe20007fde0ffULL, 0x0000001016617824ULL, 0x000fe200078e0261ULL,
0x0000000010157faeULL, 0x0003e6000c101c46ULL, 0x000000ffff137224ULL, 0x000fca00030e0604ULL,
0x0000000012617faeULL, 0x0003e2000e901c46ULL, 0x000003a000007947ULL, 0x000fea0003800000ULL,
0x0000001011117812ULL, 0x000fe200078ec0ffULL, 0x0000001000387824ULL, 0x000fc600078e00ffULL,
0x0000001100157211ULL, 0x000fe400078fe8ffULL, 0x0000007038387812ULL, 0x000fe400078ec0ffULL,
0x0000000415177810ULL, 0x040fe20007ffe0ffULL, 0x0000000115117824ULL, 0x040fe400078e0214ULL,
0x0000000115127824ULL, 0x100fe400078e0200ULL, 0x0000000117137824ULL, 0x040fe200078e0200ULL,
0x0000001104107210ULL, 0x000fe20007f1e0ffULL, 0x00000008173c7824ULL, 0x000fc400078e00ffULL,
0x0000000815397824ULL, 0x000fe400078e00ffULL, 0x0000000117117824ULL, 0x000fe200078e0214ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee213ULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0xfffffff839167812ULL, 0x000fe400078ee212ULL, 0x00005e00103b7a11ULL, 0x000fe400078038ffULL,
0x0000000815397810ULL, 0x040fe40007ffe0ffULL, 0x0000000c15177810ULL, 0x000fc40007ffe0ffULL,
0x00005f0010107a11ULL, 0x000fe200000f3c13ULL, 0x0000000139137824ULL, 0x100fe200078e0214ULL,
0x0000001104127210ULL, 0x040fe20007f1e0ffULL, 0x0000000117117824ULL, 0x000fe400078e0214ULL,
0x0000000139147824ULL, 0x040fe200078e0200ULL, 0x00000013043a7210ULL, 0x040fe20007fbe0ffULL,
0x0000000839397824ULL, 0x000fe200078e00ffULL, 0x0000001104047210ULL, 0x000fe20007fde0ffULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005e00123d7a11ULL, 0x000fc400078038ffULL,
0xfffffff8393e7812ULL, 0x000fe200078ee214ULL, 0x0000000117147824ULL, 0x040fe200078e0200ULL,
0x00005f0012127a11ULL, 0x000fe200000f3c15ULL, 0x0000000817397824ULL, 0x000fe200078e00ffULL,
0x00005e003a157a11ULL, 0x000fe200078038ffULL, 0x000000ffff177224ULL, 0x000fe200028e06ffULL,
0x00005e0004137a11ULL, 0x000fe200078a38ffULL, 0x000000ffff117224ULL, 0x000fe200030e06ffULL,
0xfffffff839567812ULL, 0x000fe200078ee214ULL, 0x0000001016397824ULL, 0x000fe200078e0261ULL,
0x00005f003a3a7a11ULL, 0x000fc400000f3c17ULL, 0x000000383b167210ULL, 0x080fe20007f1e0ffULL,
0x000000103c3b7824ULL, 0x000fe200078e0261ULL, 0x00005f0004047a11ULL, 0x000fe400028f3c11ULL,
0x000000383d147210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff177224ULL, 0x000fe200000e0610ULL,
0x0000003815107210ULL, 0x080fe20007f1e0ffULL, 0x000000103e3d7824ULL, 0x100fe400078e0261ULL,
0x000000ffff157224ULL, 0x000fe200028e0612ULL, 0x0000003813127210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200000e063aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016397faeULL, 0x0003e2000b901c46ULL, 0x0000001056617824ULL, 0x000fc400078e0261ULL,
0x000000ffff137224ULL, 0x000fe200028e0604ULL, 0x00000000143b7faeULL, 0x0003e8000b901c46ULL,
0x00000000103d7faeULL, 0x0003e8000b901c46ULL, 0x0000000012617faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000307117810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fc40003f0f070ULL,
0x000000401100720cULL, 0x000fda0003fa6070ULL, 0x0000004000005947ULL, 0x000fea0003800000ULL,
0x0000000106107824ULL, 0x000fe400078e0211ULL, 0x00000004ff117424ULL, 0x000fc800078e00ffULL,
0x0000600010107625ULL, 0x000fca00078e0011ULL, 0x0000000610047981ULL, 0x000324000c1e1900ULL,
0x0000009000007945ULL, 0x000fe40003800000ULL, 0x000000005a0403c2ULL, 0x000ea40000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a80047607f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f648004d107f8cULL, 0x0022a4000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x00f64c004d137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x006fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001214177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e15ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c004d137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010038107810ULL, 0x000fca0007ffe04cULL, 0x000000014b107824ULL, 0x000fca00078e0210ULL,
0x00f0000010127984ULL, 0x000e680000000800ULL, 0x00f2000010137984ULL, 0x0004e20000000800ULL,
0x0000005d1200720bULL, 0x002fe20003f1d000ULL, 0x000085227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x004fc800000e0100ULL, 0x0000ffff14ff7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff397424ULL, 0x000fe400078e00ffULL,
0x000000ffff5a7224ULL, 0x000fd200078e005dULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000020d107810ULL, 0x000fe40007ffe0ffULL, 0x0000005d1200720bULL, 0x000fe40003f14000ULL,
0x000000411000720cULL, 0x000fe20003fa5270ULL, 0x000084d27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000157806ULL, 0x000fc400000e0100ULL, 0x000000804138d824ULL, 0x000fe200078e0238ULL,
0x000000125d10d209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991015117816ULL, 0x000fe200000000ffULL, 0x000000014b17d824ULL, 0x000fc600078e0238ULL,
0x000000ff1100720cULL, 0x000fe40003f05270ULL, 0x00f400101700d388ULL, 0x0003f60000000800ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000125d107209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff15ff7812ULL, 0x000fc6000780c0ffULL,
0x800000105d107221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000167308ULL, 0x000e640000000800ULL, 0x0000001605057220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe20000011600ULL,
0x000083f27f007947ULL, 0x000fea000b800000ULL, 0x00001f1016107589ULL, 0x0002a400000e0000ULL,
0x0000001024247220ULL, 0x084fe20000410000ULL, 0x0000001025257220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001030307220ULL, 0x080fe20000410000ULL, 0x0000001031317220ULL, 0x080fe20000410000ULL,
0x0000001020207220ULL, 0x080fe20000410000ULL, 0x0000001021217220ULL, 0x080fe20000410000ULL,
0x000000101c1c7220ULL, 0x080fe20000410000ULL, 0x000000101d1d7220ULL, 0x080fe20000410000ULL,
0x000000102c2c7220ULL, 0x080fe20000410000ULL, 0x000000102d2d7220ULL, 0x080fe20000410000ULL,
0x0000001028287220ULL, 0x080fe20000410000ULL, 0x0000001029297220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000800107811ULL, 0x000fe200078ff0ffULL,
0x000082e27f007947ULL, 0x000fea000b800000ULL, 0x00001f1016107589ULL, 0x00046400000e0000ULL,
0x0000001026267220ULL, 0x082fe20000410000ULL, 0x0000001027277220ULL, 0x080fe20000410000ULL,
0x0000001036367220ULL, 0x080fe20000410000ULL, 0x0000001037377220ULL, 0x080fe20000410000ULL,
0x0000001032327220ULL, 0x080fe20000410000ULL, 0x0000001033337220ULL, 0x080fe20000410000ULL,
0x0000001022227220ULL, 0x080fe20000410000ULL, 0x0000001023237220ULL, 0x080fe20000410000ULL,
0x000000101e1e7220ULL, 0x080fe20000410000ULL, 0x000000101f1f7220ULL, 0x080fe20000410000ULL,
0x000000102e2e7220ULL, 0x080fe20000410000ULL, 0x000000102f2f7220ULL, 0x080fe20000410000ULL,
0x000000102a2a7220ULL, 0x080fe20000410000ULL, 0x000000102b2b7220ULL, 0x080fe20000410000ULL,
0x000000101a1a7220ULL, 0x080fe20000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff15ff7812ULL, 0x000fe20007800814ULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x000000125d5a7209ULL, 0x000fd60007810000ULL,
0x8000005a12120221ULL, 0x000fe20000010000ULL, 0x00007610ff390816ULL, 0x000fc60000000039ULL,
0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL, 0x00000012000a0308ULL, 0x000e640000000800ULL,
0x0000000a13130220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000513057221ULL, 0x008fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x00f6ac0059127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe4000780485fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0059127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe4000780485fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991039107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x0000000aff0b723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe40000011600ULL,
0x000054100b127816ULL, 0x000fe2000000000bULL, 0x00007ec27f007947ULL, 0x000fea000b800000ULL,
0x00001f13120b7589ULL, 0x0002e400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x00007ef27f007947ULL, 0x000fea000b800000ULL, 0x00001f10120c7589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00006bd000387802ULL, 0x000fc40000000f00ULL,
0x0000855000007944ULL, 0x01cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0012ULL,
0x00006c2000387802ULL, 0x000fc40000000f00ULL, 0x0000850000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000100009107824ULL, 0x002fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000015c5b7824ULL, 0x000fe200078e025bULL,
0x00a000004414783bULL, 0x004e620000000200ULL, 0x0000991039387816ULL, 0x000fc400000000ffULL,
0x0000100010117812ULL, 0x000fe200078ec0ffULL, 0x000000085c107824ULL, 0x000fe200078e00ffULL,
0x000000ff3800720cULL, 0x000fc60003f05270ULL, 0x000020000e117824ULL, 0x000fe200078e0211ULL,
0xfffffff810107812ULL, 0x000fc800078ee25bULL, 0x0000b000115b7810ULL, 0x000fca0007ffe0ffULL,
0x0000001010107824ULL, 0x100fe400078e025bULL, 0x00000010543c7824ULL, 0x000fc800078e025bULL,
0x000000001010783bULL, 0x000ea80000004200ULL, 0x000000003c3c783bULL, 0x000ee40000004200ULL,
0x0000000b14148232ULL, 0x08afe40000000000ULL, 0x0000000b16168232ULL, 0x000fe40000000000ULL,
0x0000000c15158232ULL, 0x000fc40000000000ULL, 0x0000000c17178232ULL, 0x000fe20000000000ULL,
0x00003120103a7816ULL, 0x004fe400000000ffULL, 0x0000312011117816ULL, 0x000fe400000000ffULL,
0x0000003aff38723eULL, 0x080fe400020006ffULL, 0x00000011ff39723eULL, 0x080fe400020006ffULL,
0x0000003aff10723eULL, 0x000fe400030006ffULL, 0x00000011ff11723eULL, 0x000fc400030006ffULL,
0x0000312012127816ULL, 0x000fe200000000ffULL, 0x000000381424723cULL, 0x040b620000001824ULL,
0x0000312013137816ULL, 0x000fe400000000ffULL, 0x000031203d547816ULL, 0x000fe400000000ffULL,
0x00000012ff56723eULL, 0x000fe400030006ffULL, 0x0000001052387824ULL, 0x020fe200078e025bULL,
0x000000101434723cULL, 0x000b620000001834ULL, 0x000031203c527816ULL, 0x000fc400000000ffULL,
0x00000054ff3d723eULL, 0x000fe400020006ffULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x00000052ff3c723eULL, 0x000fe400020006ffULL, 0x00000012ff10723eULL, 0x020fe400020006ffULL,
0x00000013ff11723eULL, 0x080fe400020006ffULL, 0x00000013ff57723eULL, 0x000fe200030006ffULL,
0x0000003c141c723cULL, 0x000be2000000181cULL, 0x000031203e3e7816ULL, 0x000fc400000000ffULL,
0x000031203f3f7816ULL, 0x000fc800000000ffULL, 0x00000052ff3c723eULL, 0x020fe200030006ffULL,
0x000000101430723cULL, 0x040b620000001830ULL, 0x00000054ff3d723eULL, 0x000fe200030006ffULL,
0x00a000004310783bULL, 0x020eac0000000200ULL, 0x0000003c142c723cULL, 0x040bee000000182cULL,
0x0000003eff3c723eULL, 0x020fe200020006ffULL, 0x000000561420723cULL, 0x000b620000001820ULL,
0x0000003fff3d723eULL, 0x000fcc00020006ffULL, 0x0000003eff56723eULL, 0x020fe200030006ffULL,
0x0000003c1428723cULL, 0x040b620000001828ULL, 0x0000003fff57723eULL, 0x000fe400030006ffULL,
0x0000312038387816ULL, 0x002fe400000000ffULL, 0x0000312039397816ULL, 0x000fe400000000ffULL,
0x00000010503c7824ULL, 0x020fe200078e025bULL, 0x000000561418723cULL, 0x000b620000001818ULL,
0x000031203a3a7816ULL, 0x000fc400000000ffULL, 0x000031203b3b7816ULL, 0x000fe400000000ffULL,
0x000000003c3c783bULL, 0x000e640000004200ULL, 0x00000038ff14723eULL, 0x020fe400020006ffULL,
0x00000039ff15723eULL, 0x000fe200020006ffULL, 0x0000000b10108232ULL, 0x084fe40000000000ULL,
0x0000000b12128232ULL, 0x000fe40000000000ULL, 0x0000000c11118232ULL, 0x000fc40000000000ULL,
0x0000000c13138232ULL, 0x000fce0000000000ULL, 0x000000141024723cULL, 0x000b6e0000001824ULL,
0x00000038ff14723eULL, 0x020fe400030006ffULL, 0x00000039ff15723eULL, 0x000fce00030006ffULL,
0x000000141034723cULL, 0x000b620000001834ULL, 0x000031203c3c7816ULL, 0x002fcc00000000ffULL,
0x0000003aff14723eULL, 0x0a0fe400020006ffULL, 0x0000003bff15723eULL, 0x000fe400020006ffULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e3e7816ULL, 0x000fe400000000ffULL,
0x000031203f3f7816ULL, 0x000fe200000000ffULL, 0x000000141030723cULL, 0x000b6e0000001830ULL,
0x0000003aff14723eULL, 0x020fc400030006ffULL, 0x0000003bff15723eULL, 0x000fce00030006ffULL,
0x000000141020723cULL, 0x000b6e0000001820ULL, 0x0000003cff14723eULL, 0x0a0fe400020006ffULL,
0x0000003dff15723eULL, 0x000fe400020006ffULL, 0x0000003cff3c723eULL, 0x000fc400030006ffULL,
0x0000003dff3d723eULL, 0x000fc600030006ffULL, 0x00000014101c723cULL, 0x040b6e000000181cULL,
0x0000003eff14723eULL, 0x0a0fe200020006ffULL, 0x0000003c102c723cULL, 0x000f62000000182cULL,
0x0000003fff15723eULL, 0x000fe400020006ffULL, 0x0000003eff3e723eULL, 0x000fc400030006ffULL,
0x0000003fff3f723eULL, 0x000fc600030006ffULL, 0x000000141028723cULL, 0x040b6e0000001828ULL,
0x0000f6c80e147811ULL, 0x020fe200078e18ffULL, 0x0000003e1018723cULL, 0x000b620000001818ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000014147f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c008117811ULL, 0x020fe200078e40ffULL, 0x00f698004aff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff137224ULL, 0x000fe200078e0049ULL, 0x0000000307577810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5d7224ULL, 0x000fe200078e005aULL, 0x000000421100720cULL, 0x000fe20003f06070ULL,
0x000000ffff5f7224ULL, 0x000fd800078e0061ULL, 0x00001da000000947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x004fc40000015200ULL, 0x000004004e127984ULL, 0x000ea40000000800ULL,
0x8000000012ff7812ULL, 0x006fe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210177210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001712127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004004e127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000208127810ULL, 0x040fe20007ffe0ffULL,
0x0000010008107824ULL, 0x000fe400078e0203ULL, 0x0000580004047a24ULL, 0x010fe200078e02ffULL,
0x0000000f1200720cULL, 0x000fe40003f06070ULL, 0x0000010010157810ULL, 0x000fe20007ffe0ffULL,
0x0000004004047824ULL, 0x000fc600078e00ffULL, 0x0000002002137812ULL, 0x000fce00078ef815ULL,
0x0000048000008947ULL, 0x000fea0003800000ULL, 0x0000001041107824ULL, 0x000fe200078e00ffULL,
0x00000003ff387819ULL, 0x000fe20000011600ULL, 0x0000001000127824ULL, 0x000fc600078e00ffULL,
0x00000010103b7812ULL, 0x000fe400078ec0ffULL, 0x0000001542107217ULL, 0x000fe40007800000ULL,
0x00000004383d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000138177824ULL, 0x000fe200078e023bULL,
0x0000007012127812ULL, 0x000fe200078ec0ffULL, 0x0000000110107824ULL, 0x000fe400078e0a15ULL,
0x0000000117117824ULL, 0x000fe400078e0213ULL, 0x000000013d3e7824ULL, 0x000fe200078e023bULL,
0x000000103b107217ULL, 0x000fe20007800000ULL, 0x0000000117397824ULL, 0x040fe200078e0200ULL,
0x0000001104117210ULL, 0x000fe20007f1e0ffULL, 0x00000008173c7824ULL, 0x000fc400078e00ffULL,
0x0000000110167824ULL, 0x000fe400078e0a3bULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x00005e0011157a11ULL, 0x040fe200078038ffULL, 0x000000083e497824ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee239ULL, 0x00005f0011147a11ULL, 0x000fe200000f3c14ULL,
0x000000013e117824ULL, 0x000fe200078e0213ULL, 0x0000001215107210ULL, 0x000fe20007fbe0ffULL,
0x000000103c177824ULL, 0x000fe200078e025bULL, 0x000000163800720cULL, 0x080fe20003f06070ULL,
0x000000013e3c7824ULL, 0x000fe200078e0200ULL, 0x00000011043a7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff117224ULL, 0x000fe200028e0614ULL, 0x000000163d00720cULL, 0x000fc40003fa6070ULL,
0x00000008383d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200030e06ffULL,
0x00005e003a397a11ULL, 0x000fe400078c38ffULL, 0x0000000c383e7810ULL, 0x000fe20007ffe0ffULL,
0x000000013d3f7824ULL, 0x000fe200078e023bULL, 0x00005f003a3a7a11ULL, 0x000fe200030f3c15ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0003e2000c101c46ULL,
0x0000001239147210ULL, 0x000fe20007f1e0ffULL, 0x000000013f157824ULL, 0x000fe200078e0213ULL,
0xfffffff8493c7812ULL, 0x000fe200078ee23cULL, 0x000000013e3b7824ULL, 0x000fc600078e023bULL,
0x0000001504387210ULL, 0x000fe20007fde0ffULL, 0x000000013b137824ULL, 0x000fe400078e0213ULL,
0x000000ffff157224ULL, 0x000fe200000e063aULL, 0x000000163d00720cULL, 0x000fe20003f06070ULL,
0x000000103c177824ULL, 0x002fe400078e025bULL, 0x000000ffff397224ULL, 0x000fe200030e06ffULL,
0x0000001304047210ULL, 0x000fe40007fde0ffULL, 0x0000000014177faeULL, 0x0003e2000e901c46ULL,
0x00005e0038117a11ULL, 0x000fc400078a38ffULL, 0x000000ffff137224ULL, 0x000fe400030e06ffULL,
0x00005f0038387a11ULL, 0x000fe400028f3c39ULL, 0x0000001211107210ULL, 0x000fe40007fde0ffULL,
0x000000163e00720cULL, 0x000fe20003fa6070ULL, 0x000000013f167824ULL, 0x040fe400078e0200ULL,
0x000000083f3f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff117224ULL, 0x000fe200030e0638ULL,
0x00005e0004157a11ULL, 0x042fe200078c38ffULL, 0x000000013b177824ULL, 0x000fe200078e0200ULL,
0xfffffff83f167812ULL, 0x000fe200078ee216ULL, 0x000000083b387824ULL, 0x000fe200078e00ffULL,
0x00005f0004047a11ULL, 0x000fc400030f3c13ULL, 0x0000001215147210ULL, 0x000fe20007fde0ffULL,
0x0000001016137824ULL, 0x000fe200078e025bULL, 0xfffffff838387812ULL, 0x000fc600078ee217ULL,
0x000000ffff157224ULL, 0x000fe200030e0604ULL, 0x0000000010137faeULL, 0x0003e2000c101c46ULL,
0x00000010385b7824ULL, 0x000fca00078e025bULL, 0x00000000145b7faeULL, 0x0003e2000e901c46ULL,
0x000003b000007947ULL, 0x000fea0003800000ULL, 0x0000001041107824ULL, 0x000fca00078e00ffULL,
0x0000001010117812ULL, 0x000fc800078ec0ffULL, 0x0000001100107211ULL, 0x000fc800078fe8ffULL,
0x0000000410177810ULL, 0x040fe20007ffe0ffULL, 0x0000000110117824ULL, 0x140fe400078e0213ULL,
0x0000000110127824ULL, 0x100fe400078e0200ULL, 0x0000000117157824ULL, 0x040fe200078e0200ULL,
0x0000001104167210ULL, 0x000fe20007f1e0ffULL, 0x00000008173c7824ULL, 0x040fe400078e00ffULL,
0x0000000810397824ULL, 0x000fe400078e00ffULL, 0x0000000117117824ULL, 0x000fe200078e0213ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee215ULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0xfffffff839147812ULL, 0x000fc400078ee212ULL, 0x00005e00163b7a11ULL, 0x000fe400078038ffULL,
0x0000000810127810ULL, 0x040fe40007ffe0ffULL, 0x0000000c10177810ULL, 0x000fe40007ffe0ffULL,
0x00005f0016167a11ULL, 0x000fe200000f3c15ULL, 0x0000000112157824ULL, 0x100fe200078e0213ULL,
0x0000001104117210ULL, 0x000fe20007f1e0ffULL, 0x0000000117137824ULL, 0x000fe400078e0213ULL,
0x0000000112107824ULL, 0x000fe200078e0200ULL, 0x0000001504157210ULL, 0x000fe20007fbe0ffULL,
0x0000000812397824ULL, 0x000fe200078e00ffULL, 0x0000001304047210ULL, 0x000fe20007fde0ffULL,
0x000000ffff387224ULL, 0x000fe200000e06ffULL, 0x00005e00113d7a11ULL, 0x000fe200078038ffULL,
0x0000001000127824ULL, 0x000fe200078e00ffULL, 0xfffffff8393e7812ULL, 0x000fe200078ee210ULL,
0x0000000117107824ULL, 0x000fe200078e0200ULL, 0x00005f0011387a11ULL, 0x000fe200000f3c38ULL,
0x0000000817137824ULL, 0x000fe200078e00ffULL, 0x00005e0015177a11ULL, 0x000fe200078038ffULL,
0x000000ffff3a7224ULL, 0x000fe200028e06ffULL, 0x00005e0004397a11ULL, 0x000fe200078a38ffULL,
0x000000ffff117224ULL, 0x000fe200030e06ffULL, 0x0000007012127812ULL, 0x000fc400078ec0ffULL,
0xfffffff8134e7812ULL, 0x000fe200078ee210ULL, 0x0000001014137824ULL, 0x000fe200078e025bULL,
0x00005f00153a7a11ULL, 0x000fe400000f3c3aULL, 0x00005f0004047a11ULL, 0x000fe400028f3c11ULL,
0x000000123b107210ULL, 0x080fe20007f1e0ffULL, 0x000000103c3b7824ULL, 0x100fe200078e025bULL,
0x000000123d147210ULL, 0x080fe20007fbe0ffULL, 0x000000103e3d7824ULL, 0x100fe400078e025bULL,
0x000000ffff117224ULL, 0x000fe200000e0616ULL, 0x0000001217167210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff157224ULL, 0x000fe200028e0638ULL, 0x0000001239387210ULL, 0x000fe20007fbe0ffULL,
0x000000104e5b7824ULL, 0x000fe200078e025bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0003e2000b901c46ULL, 0x000000ffff177224ULL, 0x000fc400000e063aULL,
0x000000ffff397224ULL, 0x000fe200028e0604ULL, 0x00000000143b7faeULL, 0x0003e8000b901c46ULL,
0x00000000163d7faeULL, 0x0003e8000b901c46ULL, 0x00000000385b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000407117810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fc40003f0f070ULL,
0x000000401100720cULL, 0x000fda0003fa6070ULL, 0x0000004000005947ULL, 0x000fea0003800000ULL,
0x0000000106107824ULL, 0x000fe400078e0211ULL, 0x00000004ff117424ULL, 0x000fc800078e00ffULL,
0x0000600010107625ULL, 0x000fca00078e0011ULL, 0x0000000610047981ULL, 0x000324000c1e1900ULL,
0x0000009000007945ULL, 0x000fe40003800000ULL, 0x00000000580403c2ULL, 0x000ea40000080000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00c9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000270f070ULL,
0xffffff8000004947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800595e7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f668004d107f8cULL, 0x0022a4000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x00f66c004d137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x006fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614167210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011417ULL,
0x0000001613137211ULL, 0x000fca00078110ffULL, 0x000000ffff167224ULL, 0x000fca00000e0617ULL,
0x0000000213137819ULL, 0x000fc80000001216ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c004d137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000180124c7810ULL, 0x000fca0007ffe04cULL, 0x000000014b4c7824ULL, 0x000fca00078e024cULL,
0x00f000004c137984ULL, 0x000e680000000800ULL, 0x00f200004c147984ULL, 0x0004e20000000800ULL,
0x0000005a1300720bULL, 0x002fe20003f1d000ULL, 0x000068327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000157806ULL, 0x004fc800000e0100ULL, 0x0000ffff15ff7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000ffff5d7224ULL, 0x000fd200078e005aULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x000000030d107810ULL, 0x000fe40007ffe0ffULL, 0x0000005a1300720bULL, 0x000fe40003f14000ULL,
0x000000411000720cULL, 0x000fe20003fa5270ULL, 0x000067e27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000167806ULL, 0x000fc400000e0100ULL, 0x000000804112d824ULL, 0x000fe200078e0212ULL,
0x0000005a135d7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991016107816ULL, 0x000fe200000000ffULL, 0x000000014b12d824ULL, 0x000fc600078e0212ULL,
0x000000ff1000720cULL, 0x000fe40003f05270ULL, 0x00f4005d1200d388ULL, 0x0003f60000000800ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000005a5d107221ULL, 0x002fe20000010100ULL,
0x000000ff16ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000127308ULL, 0x000e640000000800ULL,
0x0000001205057220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe20000011600ULL, 0x000067027f007947ULL, 0x000fea000b800000ULL,
0x00001f1012107589ULL, 0x0002a400000e0000ULL, 0x0000001024247220ULL, 0x084fe20000410000ULL,
0x0000001025257220ULL, 0x080fe20000410000ULL, 0x0000001034347220ULL, 0x080fe20000410000ULL,
0x0000001035357220ULL, 0x080fe20000410000ULL, 0x0000001030307220ULL, 0x080fe20000410000ULL,
0x0000001031317220ULL, 0x080fe20000410000ULL, 0x0000001020207220ULL, 0x080fe20000410000ULL,
0x0000001021217220ULL, 0x080fe20000410000ULL, 0x000000101c1c7220ULL, 0x080fe20000410000ULL,
0x000000101d1d7220ULL, 0x080fe20000410000ULL, 0x000000102c2c7220ULL, 0x080fe20000410000ULL,
0x000000102d2d7220ULL, 0x080fe20000410000ULL, 0x0000001028287220ULL, 0x080fe20000410000ULL,
0x0000001029297220ULL, 0x080fe20000410000ULL, 0x0000001018187220ULL, 0x080fe20000410000ULL,
0x0000001019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000800107811ULL, 0x000fe200078ff0ffULL, 0x000065f27f007947ULL, 0x000fea000b800000ULL,
0x00001f1012107589ULL, 0x00046400000e0000ULL, 0x0000001026267220ULL, 0x082fe20000410000ULL,
0x0000001027277220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x0000001022227220ULL, 0x080fe20000410000ULL,
0x0000001023237220ULL, 0x080fe20000410000ULL, 0x000000101e1e7220ULL, 0x080fe20000410000ULL,
0x000000101f1f7220ULL, 0x080fe20000410000ULL, 0x000000102e2e7220ULL, 0x080fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000101a1a7220ULL, 0x080fe20000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff16ff7812ULL, 0x000fe20007800815ULL, 0x00000001ff167424ULL, 0x000fd800078e00ffULL,
0x000000135d130221ULL, 0x000fe20000010100ULL, 0x00007610ff160816ULL, 0x000fc60000000016ULL,
0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL, 0x00000013000a0308ULL, 0x000e640000000800ULL,
0x0000000a14140220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000514057221ULL, 0x008fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x00f6ac0047137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804861ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x004fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0047137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804861ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991016107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x0000000aff0b723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe40000011600ULL,
0x000054100b127816ULL, 0x004fe2000000000bULL, 0x000061e27f007947ULL, 0x000fea000b800000ULL,
0x00001f13120b7589ULL, 0x0002a400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x000062127f007947ULL, 0x000fea000b800000ULL, 0x00001f10120c7589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00008a9000387802ULL, 0x000fc40000000f00ULL,
0x0000669000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0012ULL,
0x00008ae000387802ULL, 0x000fc40000000f00ULL, 0x0000664000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000005510783bULL, 0x00ee680000004200ULL, 0x00a800004414783bULL, 0x000ea80000000200ULL,
0x00000000533c783bULL, 0x000ee20000004200ULL, 0x0000312010107816ULL, 0x002fc400000000ffULL,
0x0000312011117816ULL, 0x000fe400000000ffULL, 0x00000010ff38723eULL, 0x080fe200020006ffULL,
0x0000000b14148232ULL, 0x084fe20000000000ULL, 0x00000011ff39723eULL, 0x000fe200020006ffULL,
0x0000000b16168232ULL, 0x000fe20000000000ULL, 0x0000312012127816ULL, 0x000fe200000000ffULL,
0x0000000c15158232ULL, 0x080fe20000000000ULL, 0x0000312013137816ULL, 0x000fe200000000ffULL,
0x0000000c17178232ULL, 0x000fe20000000000ULL, 0x00000010ff10723eULL, 0x000fc400030006ffULL,
0x00000011ff11723eULL, 0x000fe400030006ffULL, 0x00000012ff44723eULL, 0x000fe400030006ffULL,
0x00000013ff45723eULL, 0x000fe200030006ffULL, 0x000000381424723cULL, 0x000b620000001824ULL,
0x000031203c3c7816ULL, 0x008fe200000000ffULL, 0x000000005138783bULL, 0x020e620000004200ULL,
0x000031203d3d7816ULL, 0x000fe400000000ffULL, 0x000031203e3e7816ULL, 0x000fc400000000ffULL,
0x000031203f3f7816ULL, 0x000fe200000000ffULL, 0x000000101434723cULL, 0x040b6e0000001834ULL,
0x00000012ff10723eULL, 0x020fe200020006ffULL, 0x000000441420723cULL, 0x000be20000001820ULL,
0x00000013ff11723eULL, 0x000fcc00020006ffULL, 0x0000003cff44723eULL, 0x0a0fe200020006ffULL,
0x000000101430723cULL, 0x000b620000001830ULL, 0x0000003dff45723eULL, 0x080fe200020006ffULL,
0x00a800004310783bULL, 0x020ea20000000200ULL, 0x0000003cff3c723eULL, 0x000fe400030006ffULL,
0x0000003dff3d723eULL, 0x000fc600030006ffULL, 0x00000044141c723cULL, 0x040b6e000000181cULL,
0x0000003eff44723eULL, 0x020fe200030006ffULL, 0x0000003c142c723cULL, 0x000b62000000182cULL,
0x0000003fff45723eULL, 0x000fe400030006ffULL, 0x0000312038387816ULL, 0x002fc400000000ffULL,
0x0000312039397816ULL, 0x000fe400000000ffULL, 0x0000003eff3c723eULL, 0x020fe200020006ffULL,
0x000000441418723cULL, 0x000fe20000001818ULL, 0x0000003fff3d723eULL, 0x000fe400020006ffULL,
0x000031203a3a7816ULL, 0x000fe400000000ffULL, 0x000031203b3b7816ULL, 0x000fc600000000ffULL,
0x0000003c1428723cULL, 0x000b640000001828ULL, 0x000000004f3c783bULL, 0x020e6a0000004200ULL,
0x00000038ff14723eULL, 0x080fe400020006ffULL, 0x00000039ff15723eULL, 0x080fe200020006ffULL,
0x0000000b10108232ULL, 0x084fe20000000000ULL, 0x00000038ff38723eULL, 0x000fe200030006ffULL,
0x0000000b12128232ULL, 0x000fe20000000000ULL, 0x00000039ff39723eULL, 0x000fe200030006ffULL,
0x0000000c11118232ULL, 0x000fc40000000000ULL, 0x0000000c13138232ULL, 0x000fce0000000000ULL,
0x000000141024723cULL, 0x040b6e0000001824ULL, 0x0000003aff14723eULL, 0x0a0fe200020006ffULL,
0x000000381034723cULL, 0x000f620000001834ULL, 0x0000003bff15723eULL, 0x000fe400020006ffULL,
0x0000003aff3a723eULL, 0x000fc400030006ffULL, 0x0000003bff3b723eULL, 0x000fc600030006ffULL,
0x000000141030723cULL, 0x000b620000001830ULL, 0x000031203c3c7816ULL, 0x002fe400000000ffULL,
0x000031203d3d7816ULL, 0x000fc800000000ffULL, 0x0000003cff14723eULL, 0x0a0fe200020006ffULL,
0x0000003a1020723cULL, 0x040f620000001820ULL, 0x0000003dff15723eULL, 0x080fe400020006ffULL,
0x000031203e3e7816ULL, 0x000fe400000000ffULL, 0x000031203f3f7816ULL, 0x000fe400000000ffULL,
0x0000003cff3c723eULL, 0x000fe200030006ffULL, 0x00000014101c723cULL, 0x000b62000000181cULL,
0x0000003dff3d723eULL, 0x000fcc00030006ffULL, 0x0000003eff14723eULL, 0x0a0fe200020006ffULL,
0x0000003c102c723cULL, 0x000f62000000182cULL, 0x0000003fff15723eULL, 0x080fe400020006ffULL,
0x0000003eff3e723eULL, 0x000fe400030006ffULL, 0x0000003fff3f723eULL, 0x000fc600030006ffULL,
0x000000141028723cULL, 0x040b6e0000001828ULL, 0x0000f6c80e147811ULL, 0x020fe200078e18ffULL,
0x0000003e1018723cULL, 0x000b620000001818ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000014147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a0004aff7f8cULL, 0x0005e2000c80043fULL,
0x0000000407577810ULL, 0x000fc40007ffe0ffULL, 0x0000000109137812ULL, 0x020fc400078ec0ffULL,
0x0000000108087810ULL, 0x004fc80007ffe0ffULL, 0x0000000f0800720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff818000007947ULL, 0x000fea000383ffffULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000005007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x000091b000047802ULL, 0x010fc40000000f00ULL,
0x00005dc000007944ULL, 0x006fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000500007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x008fc80000000005ULL,
0x800000ff02077221ULL, 0x000fc80000010100ULL, 0x0000000700007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff057624ULL, 0x000fe400078e00ffULL,
0x00006800ff047624ULL, 0x010fca00078e00ffULL, 0x0000000604057981ULL, 0x008ee8000c1e9900ULL,
0x0000000000027919ULL, 0x000ea80000000000ULL, 0x0000000000087919ULL, 0x000e620000000000ULL,
0x00000002ff077819ULL, 0x004fe40000011602ULL, 0x0000000808097811ULL, 0x002fe200078ff0ffULL,
0x0000000005067220ULL, 0x008fca0000410000ULL, 0x00001f0706007589ULL, 0x000e6800000e0000ULL,
0x00001f0906027589ULL, 0x000ea200000e0000ULL, 0x0000002400247220ULL, 0x042fe20000410000ULL,
0x0000002500257220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000001c001c7220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000002800287220ULL, 0x040fe20000410000ULL,
0x0000002900297220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001900197220ULL, 0x000fe20000410000ULL, 0x0000002602267220ULL, 0x044fe20000410000ULL,
0x0000002702277220ULL, 0x040fe20000410000ULL, 0x0000003602367220ULL, 0x040fe20000410000ULL,
0x0000003702377220ULL, 0x040fe20000410000ULL, 0x0000003202327220ULL, 0x040fe20000410000ULL,
0x0000003302337220ULL, 0x040fe20000410000ULL, 0x0000002202227220ULL, 0x040fe20000410000ULL,
0x0000002302237220ULL, 0x040fe20000410000ULL, 0x0000001e021e7220ULL, 0x040fe20000410000ULL,
0x0000001f021f7220ULL, 0x040fe20000410000ULL, 0x0000002e022e7220ULL, 0x040fe20000410000ULL,
0x0000002f022f7220ULL, 0x040fe20000410000ULL, 0x0000002a022a7220ULL, 0x040fe20000410000ULL,
0x0000002b022b7220ULL, 0x040fe20000410000ULL, 0x0000001a021a7220ULL, 0x040fe20000410000ULL,
0x0000001b021b7220ULL, 0x000fc20000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x0000100041067824ULL, 0x000fe200078e00ffULL, 0x0000002c2d2d723eULL, 0x000fc400000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000282928723eULL, 0x000fe400000000ffULL,
0x000000181914723eULL, 0x006fe400000000ffULL, 0x000000323332723eULL, 0x000fc400000000ffULL,
0x000000222319723eULL, 0x000fe400000000ffULL, 0x0000001e1f1e723eULL, 0x000fe400000000ffULL,
0x0000541032187816ULL, 0x140fe40000000019ULL, 0x0000763232197816ULL, 0x000fe40000000019ULL,
0x00000002ff077819ULL, 0x008fe40000011600ULL, 0x0000000200027812ULL, 0x000fc400078ec0ffULL,
0x0000000800097811ULL, 0x000fe200078ff0ffULL, 0x00000008070b7824ULL, 0x040fe200078e00ffULL,
0x0000000702047211ULL, 0x050fe200078ff8ffULL, 0x00000008070c7824ULL, 0x000fe200078e00ffULL,
0x0000000902057211ULL, 0x000fe200078ff8ffULL, 0x0000000809107824ULL, 0x000fe200078e00ffULL,
0x0000000204027810ULL, 0x000fe20007ffe0ffULL, 0x0000000807097824ULL, 0x000fe200078e00ffULL,
0x0000002e2f0f723eULL, 0x000fe400000000ffULL, 0xfffffff810107812ULL, 0x000fc400078ee205ULL,
0x0000100006057812ULL, 0x000fe400078ee2ffULL, 0xfffffff809087812ULL, 0x040fe400078ee202ULL,
0xfffffff809027812ULL, 0x000fe200078ee204ULL, 0x000008000e077824ULL, 0x000fe200078e0205ULL,
0x0000000404067810ULL, 0x040fe40007ffe0ffULL, 0x0000000604097810ULL, 0x000fe20007ffe0ffULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0a7812ULL, 0x000fe200078ee206ULL,
0x0000001002067824ULL, 0x000fe200078e0207ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee209ULL,
0x0000001010107824ULL, 0x100fe200078e0207ULL, 0x0000000804097812ULL, 0x000fe200078ec0ffULL,
0x0000001008087824ULL, 0x100fe200078e0207ULL, 0x000000242502723eULL, 0x000fe200000000ffULL,
0x000000100a0a7824ULL, 0x100fe200078e0207ULL, 0x000000343504723eULL, 0x000fe200000000ffULL,
0x000000100c0c7824ULL, 0x000fe200078e0207ULL, 0x0000002a2b2a723eULL, 0x000fe200000000ffULL,
0x0000000106077824ULL, 0x000fe200078e0209ULL, 0x0000541002127816ULL, 0x040fe20000000004ULL,
0x0000000109087824ULL, 0x040fe200078e0208ULL, 0x0000763202137816ULL, 0x000fe20000000004ULL,
0x00000001090a7824ULL, 0x000fe200078e020aULL, 0x000000303102723eULL, 0x000fe200000000ffULL,
0x00000001090c7824ULL, 0x000fe200078e020cULL, 0x000000202104723eULL, 0x000fe200000000ffULL,
0x0000001207007388ULL, 0x0003e20000000a00ULL, 0x0000001c1d06723eULL, 0x000fe200000000ffULL,
0x0000000109107824ULL, 0x000fe200078e0210ULL, 0x0000001a1b15723eULL, 0x000fc400000000ffULL,
0x00005410062c7816ULL, 0x140fe4000000002dULL, 0x00007632062d7816ULL, 0x000fe4000000002dULL,
0x0000541028067816ULL, 0x000fe40000000014ULL, 0x000076322a097816ULL, 0x000fe40000000015ULL,
0x0000541002127816ULL, 0x142fe40000000004ULL, 0x0000763202137816ULL, 0x000fc40000000004ULL,
0x0000763228077816ULL, 0x000fe40000000014ULL, 0x000000262702723eULL, 0x000fe200000000ffULL,
0x0000001208007388ULL, 0x000fe20000000a00ULL, 0x000000363704723eULL, 0x000fe400000000ffULL,
0x000000ff0e00720cULL, 0x000fe20003f05270ULL, 0x0000002c0a007388ULL, 0x000fe80000000a00ULL,
0x000000060c007388ULL, 0x0003e40000000a00ULL, 0x0000541002067816ULL, 0x002fc40000000004ULL,
0x0000763202077816ULL, 0x000fe20000000004ULL, 0x0000000103027824ULL, 0x000fc800078e0200ULL,
0x0000000610007388ULL, 0x0003e20000000a00ULL, 0x0000001002027824ULL, 0x000fc600078e0205ULL,
0x0004001808007388ULL, 0x0005e20000000a00ULL, 0x000054101e067816ULL, 0x142fe4000000000fULL,
0x000076321e077816ULL, 0x000fe4000000000fULL, 0x000054102a087816ULL, 0x004fc60000000015ULL,
0x000400060a007388ULL, 0x000fe80000000a00ULL, 0x000400080c007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000002107984ULL, 0x000e680000000c00ULL,
0x0004000002187984ULL, 0x000ea80000000c00ULL, 0x0008000002147984ULL, 0x000ee80000000c00ULL,
0x000c0000021c7984ULL, 0x000ee20000000c00ULL, 0x200000ff13137230ULL, 0x002fc40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fe40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x200000ff1b1b7230ULL, 0x004fe40000000000ULL,
0x200000ff1a1a7230ULL, 0x000fe40000000000ULL, 0x200000ff19197230ULL, 0x000fc40000000000ULL,
0x200000ff18187230ULL, 0x000fe40000000000ULL, 0x0000001713137230ULL, 0x008fe40000000000ULL,
0x0000001612127230ULL, 0x000fe40000000000ULL, 0x0000001511117230ULL, 0x000fe40000000000ULL,
0x0000001410107230ULL, 0x000fe40000000000ULL, 0x0000001f1b1b7230ULL, 0x000fc40000000000ULL,
0x0000001e1a1a7230ULL, 0x000fe20000000000ULL, 0x0000001002007388ULL, 0x000fe20000000c00ULL,
0x0000001d19197230ULL, 0x000fe40000000000ULL, 0x0000001c18187230ULL, 0x000fca0000000000ULL,
0x0004001802007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002000067810ULL, 0x000fe20007ffe0ffULL,
0x0000000000107919ULL, 0x000e620000002600ULL, 0x00000003ff117819ULL, 0x000fe20000011600ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x00000003ff077819ULL, 0x000fe20000011606ULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x0000000141417812ULL, 0x000fe200078ec0ffULL,
0x0000000111027824ULL, 0x000fe200078e0200ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000106047824ULL, 0x000fc600078e0207ULL, 0x0000000702037812ULL, 0x000fe400078ec0ffULL,
0x0000000704097812ULL, 0x000fe400078ec0ffULL, 0x0ffffff803027812ULL, 0x000fe400078ef800ULL,
0x0ffffff809047812ULL, 0x000fc600078ef806ULL, 0x0000001002027824ULL, 0x100fe400078e0205ULL,
0x0000001004047824ULL, 0x000fe400078e0205ULL, 0x0000000810127824ULL, 0x042fe200078e00ffULL,
0x0000000002087984ULL, 0x0002e20000000c00ULL, 0x0000000810107824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x004fe4000f8e023fULL, 0x00000000040c7984ULL, 0x0005220000000c00ULL,
0xfffffff812037812ULL, 0x000fe200078ee211ULL, 0x0000000841117824ULL, 0x000fe200078e00ffULL,
0xfffffff810077812ULL, 0x000fc400078ee207ULL, 0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000407057c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000841077824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee206ULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x00005a0003027a11ULL, 0x002fe200078040ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x00005a0005047a11ULL, 0x004fe400078240ffULL, 0x00005b0003037a11ULL, 0x000fc400000f4412ULL,
0xfffffff807077812ULL, 0x000fe400078ee200ULL, 0x00005b0005057a11ULL, 0x000fc600008f4410ULL,
0x0000001007027825ULL, 0x000fc800078e0002ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x008fe8000c101d06ULL, 0x0000000c04007986ULL, 0x010fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000404100720cULL, 0x000fe20003f06070ULL,
0xffffffffff027424ULL, 0x000fd800078e00ffULL, 0x000000020c088824ULL, 0x000fc800078e00ffULL,
0x0000640008088a24ULL, 0x000fc800078e0241ULL, 0x0000600008088625ULL, 0x000fe200078e0005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff0a7624ULL, 0x000fe200078e00ffULL,
0x0000000608028981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff0b7624ULL, 0x000fc600078e00ffULL,
0x00f60000ff067f8cULL, 0x000e68000c80043fULL, 0x000000060a0e7981ULL, 0x000722000c1e9900ULL,
0x000001ff0300780cULL, 0x000fe20003f04070ULL, 0x0000004013037824ULL, 0x000fe400078e00ffULL,
0x00000040410d7824ULL, 0x000fe400078e00ffULL, 0x0000004012397824ULL, 0x000fc400078e00ffULL,
0x0000000302207224ULL, 0x004fcc00078e02ffULL, 0x0000071000000947ULL, 0x000fea0003800000ULL,
0x00000002ff217819ULL, 0x00afe40000011600ULL, 0x0000003004237812ULL, 0x000fe400078ec0ffULL,
0x0000100041137811ULL, 0x000fe200078e68ffULL, 0x0000004012127824ULL, 0x000fe200078e0221ULL,
0x0000001821257810ULL, 0x040fe40007ffe0ffULL, 0x00000020211b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000812057810ULL, 0x000fc40007ffe0ffULL, 0x0000001012087810ULL, 0x000fe40007ffe0ffULL,
0x0000000520057210ULL, 0x040fe40007f3e0ffULL, 0x0000000820087210ULL, 0x000fe40007f5e0ffULL,
0x0000001812097810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff167224ULL, 0x000fe200008e06ffULL,
0x0000001220177210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e06ffULL,
0x00005e0005147a11ULL, 0x000fc400078238ffULL, 0x00005e00080a7a11ULL, 0x000fe200078438ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x0000000920097210ULL, 0x000fe40007f7e0ffULL,
0x00005f0005167a11ULL, 0x000fe400008f3c16ULL, 0x00005f00080b7a11ULL, 0x000fe200010f3c0bULL,
0x000000ffff1a7224ULL, 0x000fe200018e06ffULL, 0x0000000000057211ULL, 0x000fe400078fe8ffULL,
0x00005e00171c7a11ULL, 0x000fc400078038ffULL, 0x0000000d42087217ULL, 0x000fe40007800000ULL,
0x0000000305117812ULL, 0x000fe400078ec0ffULL, 0x00005e0009187a11ULL, 0x000fe400078638ffULL,
0x00005f0017177a11ULL, 0x000fe200000f3c10ULL, 0x0000000108107824ULL, 0x000fe200078e0a0dULL,
0x0000000821057810ULL, 0x000fe40007ffe0ffULL, 0x00005f00091a7a11ULL, 0x000fc400018f3c1aULL,
0x0ffffffc11007812ULL, 0x000fe200078ef800ULL, 0x0000000405087824ULL, 0x000fe200078e00ffULL,
0x0000001021097810ULL, 0x040fe40007ffe0ffULL, 0x000000102100720cULL, 0x000fe20003f06070ULL,
0x0000001000157824ULL, 0x000fe200078e0213ULL, 0x0000001c23047210ULL, 0x000fe20007f7e0ffULL,
0x00000004091c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc08007812ULL, 0x000fe400078ee211ULL,
0x000000100500720cULL, 0x080fe20003f26070ULL, 0x000000ffff057224ULL, 0x000fe200018e0617ULL,
0x0000002314087210ULL, 0x000fe20007f7e0ffULL, 0x0000001000177824ULL, 0x000fe200078e0213ULL,
0x000000100900720cULL, 0x000fc40003f46070ULL, 0xfffffffc1c147812ULL, 0x000fe200078ee211ULL,
0x000000ffff097224ULL, 0x000fe200018e0616ULL, 0x0000002012007810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004157faeULL, 0x0003e2000c101c46ULL,
0x000000230a0a7210ULL, 0x000fe20007f9e0ffULL, 0x0000001014197824ULL, 0x000fe200078e0213ULL,
0x00000028211d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000425147824ULL, 0x040fe200078e00ffULL,
0x0000000008177faeULL, 0x0005e2000c901c46ULL, 0x000000ffff0b7224ULL, 0x000fe200020e060bULL,
0x000000102500720cULL, 0x000fc40003f86070ULL, 0x00000030211f7810ULL, 0x040fe40007ffe0ffULL,
0x0000003821217810ULL, 0x000fe20007ffe0ffULL, 0x000000000a197faeULL, 0x0007e2000d101c46ULL,
0x0000000020057210ULL, 0x002fe40007f1e0ffULL, 0x0000002318047210ULL, 0x000fe20007fbe0ffULL,
0x0000000421187824ULL, 0x000fe200078e00ffULL, 0x00005e0005167a11ULL, 0x000fe200078c38ffULL,
0x000000ffff087224ULL, 0x004fe200000e06ffULL, 0xfffffffc14007812ULL, 0x000fc400078ee211ULL,
0x000000101b00720cULL, 0x080fe40003f66070ULL, 0x000000101d00720cULL, 0x080fe20003f46070ULL,
0x0000001000097824ULL, 0x000fe200078e0213ULL, 0x000000101f00720cULL, 0x0c0fe20003f26070ULL,
0x000000041f0a7824ULL, 0x008fe200078e00ffULL, 0x000000102100720cULL, 0x000fe40003f06070ULL,
0x00005f0005107a11ULL, 0x000fe200030f3c08ULL, 0x000000ffff057224ULL, 0x000fe200028e061aULL,
0x0000002812007810ULL, 0x000fc40007ffe0ffULL, 0x0000003012087810ULL, 0x000fe40007ffe0ffULL,
0x0000000004097faeULL, 0x0003e2000e101c46ULL, 0x0000000020147210ULL, 0x040fe20007fbe0ffULL,
0x000000041b007824ULL, 0x000fe200078e00ffULL, 0x00000008200b7210ULL, 0x000fe20007f9e0ffULL,
0x000000041d087824ULL, 0x000fe200078e00ffULL, 0xfffffffc0a0a7812ULL, 0x100fe400078ee211ULL,
0xfffffffc00007812ULL, 0x100fe400078ee211ULL, 0xfffffffc08087812ULL, 0x000fe200078ee211ULL,
0x000000100a197824ULL, 0x000fe200078e0213ULL, 0x0000003812127810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff057224ULL, 0x002fe200028e06ffULL, 0xfffffffc18047812ULL, 0x000fe200078ee211ULL,
0x0000001000157824ULL, 0x100fe200078e0213ULL, 0x00005e0014117a11ULL, 0x000fe200078a38ffULL,
0x0000001008177824ULL, 0x100fe200078e0213ULL, 0x0000001220127210ULL, 0x000fe20007fde0ffULL,
0x0000001004137824ULL, 0x000fe200078e0213ULL, 0x00005f0014147a11ULL, 0x000fe200028f3c05ULL,
0x000000ffff007224ULL, 0x000fe200020e06ffULL, 0x0000002316047210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200030e06ffULL, 0x00005e000b0a7a11ULL, 0x000fc600078838ffULL,
0x000000ffff057224ULL, 0x000fe200028e0610ULL, 0x00005e0012107a11ULL, 0x040fe400078c38ffULL,
0x0000002311087210ULL, 0x080fe40007fbe0ffULL, 0x00005f000b0b7a11ULL, 0x000fe200020f3c00ULL,
0x0000000004157faeULL, 0x0003e2000d901c46ULL, 0x00005f0012007a11ULL, 0x000fe200030f3c09ULL,
0x000000ffff097224ULL, 0x000fe200028e0614ULL, 0x000000230a0a7210ULL, 0x080fe40007f9e0ffULL,
0x0000002310107210ULL, 0x000fc40007fbe0ffULL, 0x0000000008177faeULL, 0x0003e2000d101c46ULL,
0x000000ffff0b7224ULL, 0x000fe400020e060bULL, 0x000000ffff117224ULL, 0x000fc600028e0600ULL,
0x000000000a197faeULL, 0x0003e8000c901c46ULL, 0x0000000010137faeULL, 0x0003e2000c101c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000003900057211ULL, 0x04afe400078ff0ffULL,
0x0000002000107811ULL, 0x000fe400078ff0ffULL, 0x0000000520057210ULL, 0x000fe40007f1e0ffULL,
0x00000008001a7811ULL, 0x040fe200078ff0ffULL, 0x0000000139117824ULL, 0x000fe200078e0210ULL,
0x0000001000087811ULL, 0x000fe200078ff0ffULL, 0x000000ffff267224ULL, 0x000fe200000e06ffULL,
0x00005e0005247a11ULL, 0x000fe200078038ffULL, 0x0000000410107824ULL, 0x000fe200078e00ffULL,
0x0000000000197211ULL, 0x040fe200078fe8ffULL, 0x0000000139097824ULL, 0x000fe200078e0208ULL,
0x00000018000a7811ULL, 0x000fe200078ff0ffULL, 0x0000000408087824ULL, 0x000fe200078e00ffULL,
0x0000002800127811ULL, 0x000fc400078ff0ffULL, 0x00005f0005267a11ULL, 0x000fe200000f3c26ULL,
0x0000000139057824ULL, 0x040fe200078e021aULL, 0x0000003000147811ULL, 0x000fe200078ff0ffULL,
0x00000001390b7824ULL, 0x000fe200078e020aULL, 0x00000003191b7812ULL, 0x000fe200078ec0ffULL,
0x000000040a0a7824ULL, 0x000fe200078e00ffULL, 0x0000001120117210ULL, 0x000fe20007f3e0ffULL,
0x0000000139137824ULL, 0x000fe200078e0212ULL, 0x0000100041277811ULL, 0x000fe200078e68ffULL,
0x00000004121c7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc1b127812ULL, 0x000fe200078ef800ULL,
0x0000000139157824ULL, 0x000fe200078e0214ULL, 0x0000000520227210ULL, 0x000fe20007fde0ffULL,
0x0000000414147824ULL, 0x000fe200078e00ffULL, 0xfffffffc08057812ULL, 0x000fe200078ee21bULL,
0x0000001012297824ULL, 0x100fe200078e0227ULL, 0x0000003800167811ULL, 0x000fe200078ff0ffULL,
0x000000041a1a7824ULL, 0x000fe200078e00ffULL, 0x0000000920187210ULL, 0x000fe20007fbe0ffULL,
0x00000010051d7824ULL, 0x000fe200078e0227ULL, 0xfffffffc0a087812ULL, 0x100fe200078ee21bULL,
0x0000000139177824ULL, 0x000fe200078e0216ULL, 0x0000000b201e7210ULL, 0x000fe20007f1e0ffULL,
0x0000000416167824ULL, 0x000fe200078e00ffULL, 0xfffffffc10097812ULL, 0x100fe200078ee21bULL,
0x000000ffff197224ULL, 0x000fe200030e06ffULL, 0xfffffffc1c0a7812ULL, 0x000fe200078ee21bULL,
0x000000ffff1c7224ULL, 0x000fe200008e06ffULL, 0x00005e0011127a11ULL, 0x000fe200078238ffULL,
0x0000001009217824ULL, 0x000fe200078e0227ULL, 0xfffffffc140b7812ULL, 0x000fe200078ee21bULL,
0x000000ffff057224ULL, 0x000fe200000e06ffULL, 0x0000001320137210ULL, 0x000fe20007f5e0ffULL,
0x000000100a237824ULL, 0x100fe200078e0227ULL, 0x0000001520157210ULL, 0x000fe20007f7e0ffULL,
0x000000100b257824ULL, 0x100fe200078e0227ULL, 0x00005e001e097a11ULL, 0x000fe200078038ffULL,
0x000000ffff0b7224ULL, 0x000fe200028e06ffULL, 0x00005f00111c7a11ULL, 0x000fe200008f3c1cULL,
0x00000010081f7824ULL, 0x000fe200078e0227ULL, 0x0000003004117812ULL, 0x000fe200078ec0ffULL,
0x000000ffff087224ULL, 0x000fe200018e06ffULL, 0xfffffffc1a007812ULL, 0x000fe200078ee21bULL,
0x000000ffff1a7224ULL, 0x000fe200010e06ffULL, 0x0000001720177210ULL, 0x000fc40007f9e0ffULL,
0x00005e00180a7a11ULL, 0x000fe400078a38ffULL, 0x00005f001e1e7a11ULL, 0x000fe400000f3c05ULL,
0x00005e0022207a11ULL, 0x000fe400078c38ffULL, 0xfffffffc16107812ULL, 0x000fe200078ee21bULL,
0x00000010001b7824ULL, 0x100fe200078e0227ULL, 0x0000002411047210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200020e06ffULL, 0x00005e0015167a11ULL, 0x000fe200078438ffULL,
0x0000001010277824ULL, 0x000fe200078e0227ULL, 0x00005e0013147a11ULL, 0x000fe200078238ffULL,
0x000000ffff057224ULL, 0x000fe200000e0626ULL, 0x00005f00180b7a11ULL, 0x000fc400028f3c0bULL,
0x00005f0022227a11ULL, 0x000fe400030f3c19ULL, 0x00005e0017187a11ULL, 0x000fe200078638ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004297faeULL, 0x0003e2000b901c46ULL,
0x00005f0015197a11ULL, 0x000fe400010f3c08ULL, 0x00005f00131a7a11ULL, 0x000fe400008f3c1aULL,
0x0000002011087210ULL, 0x040fe40007f1e0ffULL, 0x0000000a110a7210ULL, 0x000fc40007f3e0ffULL,
0x00005f0017007a11ULL, 0x000fe400018f3c00ULL, 0x0000000911107210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0622ULL, 0x0000001211127210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x0000001411147210ULL, 0x040fe40007f9e0ffULL,
0x0000001611167210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200018e061cULL,
0x0000001811187210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200010e061eULL,
0x00000000081b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff157224ULL, 0x000fc400020e061aULL,
0x000000ffff177224ULL, 0x000fe200028e0619ULL, 0x000000000a1d7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff197224ULL, 0x000fc600000e0600ULL, 0x00000000101f7faeULL, 0x0003e8000b901c46ULL,
0x0000000012217faeULL, 0x0003e8000b901c46ULL, 0x0000000014237faeULL, 0x0003e8000b901c46ULL,
0x0000000016257faeULL, 0x0003e8000b901c46ULL, 0x0000000018277faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000047805ULL, 0x002fc40000015200ULL,
0x00f60400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011409ULL,
0x0000000b00007211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000200007819ULL, 0x000fc80000001209ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e640000000000ULL, 0x0000002041007824ULL, 0x002fca00078e0200ULL,
0x00000003ff047819ULL, 0x000fc80000011600ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x0000000f00047812ULL, 0x000fc600078ec0ffULL, 0x0000000100057824ULL, 0x000fe400078e0205ULL,
0x0000001004077824ULL, 0x040fe400078e00ffULL, 0x0000001004047824ULL, 0x000fe200078e00ffULL,
0x0000000f05007812ULL, 0x040fe400078ec0ffULL, 0x0000000105057810ULL, 0x000fe40007ffe0ffULL,
0x000000f007007812ULL, 0x000fe400078ee200ULL, 0x0000000f05057812ULL, 0x000fc600078ec0ffULL,
0x0000000000107984ULL, 0x000e62000000cc00ULL, 0x000000f004057812ULL, 0x000fca00078ee205ULL,
0x0000000005087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fe400078e0013ULL, 0x000000ffff167224ULL, 0x004fe400078e0008ULL,
0x000000ffff177224ULL, 0x000fc400078e000aULL, 0x000000ffff127224ULL, 0x000fe400078e0009ULL,
0x000000ffff137224ULL, 0x000fe200078e000bULL, 0x0000001400007388ULL, 0x0003e8000000cc00ULL,
0x0000001005007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff087f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0a7224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x002fc80000015200ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x006fc40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011407ULL,
0x0000000b00007211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000200007819ULL, 0x000fc80000001207ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x000064000c0c7a24ULL, 0x000fe200078e02ffULL,
0x3db504f30e0e7820ULL, 0x010fe20000410000ULL, 0x0000f68841387811ULL, 0x000fe200078e18ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0xffffffff0f3a7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e00ffULL, 0x0000f608413b7811ULL, 0x000fe200078e28ffULL,
0x000000ffff3d7224ULL, 0x000fc400078e0041ULL, 0x000001003c3f7824ULL, 0x000fe200078e020dULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x0000003f4200720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x01cfea0003800000ULL, 0x000000ffff247224ULL, 0x000fe200078e003eULL,
0x0000000000067805ULL, 0x000fe2000001ff00ULL, 0x000000ffff437224ULL, 0x000fe200078e00ffULL,
0x0000000000047805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fc4000001ff00ULL, 0x0000000143257810ULL, 0x000fe20007ffe0ffULL,
0x00000d6000007945ULL, 0x000fe20003800000ULL, 0x000000ffff447224ULL, 0x000fe200078e0043ULL,
0x00000001243e7812ULL, 0x000fe200078e0cffULL, 0x0000000302347224ULL, 0x010fe200078e02ffULL,
0x0000003c25287211ULL, 0x040fe200078ff8ffULL, 0x000000ffff437224ULL, 0x000fe200078e0025ULL,
0x000000022500780cULL, 0x000fc40003f06070ULL, 0x0000000128267810ULL, 0x000fe40007ffe0ffULL,
0x0000000125487812ULL, 0x000fe400078ec0ffULL, 0x0000000f2600720cULL, 0x000fda0003f26070ULL,
0x000006c000009947ULL, 0x000fea0003800000ULL, 0x00000002ff4a7819ULL, 0x002fe20000011600ULL,
0x0000010028257824ULL, 0x000fe400078e020dULL, 0x0000000448457824ULL, 0x000fe200078e00ffULL,
0x000000084a4c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000139267824ULL, 0x000fe200078e024aULL,
0x000000104a507810ULL, 0x000fe20007ffe0ffULL, 0x0000000241497824ULL, 0x000fe200078e023eULL,
0x0000002542287217ULL, 0x000fe20007800000ULL, 0x0000000139277824ULL, 0x040fe200078e024cULL,
0x00000026342b7210ULL, 0x000fe20007f3e0ffULL, 0x0000000139297824ULL, 0x040fe200078e0250ULL,
0x000000184a527810ULL, 0x000fe20007ffe0ffULL, 0x0000000128257824ULL, 0x000fe200078e0a25ULL,
0x0000002734277210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x0000002934297210ULL, 0x000fe20007f7e0ffULL, 0x0000000139287824ULL, 0x000fe200078e0252ULL,
0x00005e002b467a11ULL, 0x000fe200078238ffULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0x00005e0027367a11ULL, 0x000fe200078438ffULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x00005e0029267a11ULL, 0x000fc400078638ffULL, 0x000000204a547810ULL, 0x040fe40007ffe0ffULL,
0x000000284a567810ULL, 0x040fe40007ffe0ffULL, 0x000000384a5a7810ULL, 0x040fe40007ffe0ffULL,
0x00005f0027377a11ULL, 0x000fe400010f3c30ULL, 0x00005f002b477a11ULL, 0x000fe400008f3c32ULL,
0x00005f0029277a11ULL, 0x000fe200018f3c2aULL, 0x0000000139297824ULL, 0x040fe200078e0254ULL,
0x000000304a587810ULL, 0x000fe20007ffe0ffULL, 0x00000001392a7824ULL, 0x040fe200078e0256ULL,
0x0000002834317210ULL, 0x040fe20007f3e0ffULL, 0x0000000139287824ULL, 0x040fe200078e025aULL,
0x0000002934337210ULL, 0x040fe20007fbe0ffULL, 0x00000001392b7824ULL, 0x000fe200078e0258ULL,
0x0000002a34357210ULL, 0x040fe20007fde0ffULL, 0x000000ffff2a7224ULL, 0x000fe200008e06ffULL,
0x0000002834297210ULL, 0x000fc40007f7e0ffULL, 0x0000000000287211ULL, 0x000fe200078fe8ffULL,
0x000000ffff4e7224ULL, 0x000fe200030e06ffULL, 0x00005e0031307a11ULL, 0x040fe400078238ffULL,
0x0000002b342b7210ULL, 0x000fe20007f9e0ffULL, 0x000000044c347824ULL, 0x000fe200078e00ffULL,
0x00000003284f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff287224ULL, 0x000fe200028e06ffULL,
0x000000254a00720cULL, 0x000fe20003f46070ULL, 0x000000ffff4a7224ULL, 0x000fe200018e06ffULL,
0x00005f0031317a11ULL, 0x000fc400008f3c2aULL, 0x000000254c00720cULL, 0x000fe20003f26070ULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x0000100049497811ULL, 0x000fe400078e60ffULL,
0x0ffffffc4f2a7812ULL, 0x100fe400078ef800ULL, 0xfffffffc45457812ULL, 0x000fe400078ee200ULL,
0xfffffffc34347812ULL, 0x000fe200078ee24fULL, 0x000000102a4b7824ULL, 0x000fe200078e0249ULL,
0x00005e0033327a11ULL, 0x000fe200078a38ffULL, 0x0000001045467825ULL, 0x000fe200078e0046ULL,
0x00005e002b2a7a11ULL, 0x000fc400078838ffULL, 0x00005f0033337a11ULL, 0x000fe200028f3c28ULL,
0x00000010344d7824ULL, 0x000fe200078e0249ULL, 0x00005e0029287a11ULL, 0x000fe200078638ffULL,
0x0000001045367825ULL, 0x000fe200078e0036ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000464b7faeULL, 0x0003e2000d101c46ULL, 0x00005e0035347a11ULL, 0x000fe400078a38ffULL,
0x000000255200720cULL, 0x080fe20003f46070ULL, 0x00000000364d7faeULL, 0x0005e2000c901c46ULL,
0x000000255000720cULL, 0x0c0fe20003f26070ULL, 0x0000000450507824ULL, 0x000fe200078e00ffULL,
0x00005f0029297a11ULL, 0x000fe200018f3c4aULL, 0x0000000452527824ULL, 0x000fe200078e00ffULL,
0x00005f002b2b7a11ULL, 0x000fe200020f3c4cULL, 0x00000004544a7824ULL, 0x000fe200078e00ffULL,
0x00005f0035357a11ULL, 0x000fe200028f3c4eULL, 0x00000004564c7824ULL, 0x000fe200078e00ffULL,
0x000000255400720cULL, 0x080fe20003f66070ULL, 0x00000004584e7824ULL, 0x000fe200078e00ffULL,
0x000000255a00720cULL, 0x0c0fe20003fc6070ULL, 0x000000045a5a7824ULL, 0x000fe200078e00ffULL,
0x000000255600720cULL, 0x000fe20003f86070ULL, 0x0000001045267825ULL, 0x000fe200078e0026ULL,
0xfffffffc50367812ULL, 0x004fc400078ee24fULL, 0x000000255800720cULL, 0x000fe20003fa6070ULL,
0x0000001045307825ULL, 0x040fe200078e0030ULL, 0xfffffffc52467812ULL, 0x102fe400078ee24fULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee24fULL, 0x0000001036257824ULL, 0x000fe200078e0249ULL,
0xfffffffc4c4c7812ULL, 0x000fe200078ee24fULL, 0x0000001046377824ULL, 0x000fe200078e0249ULL,
0xfffffffc4e4e7812ULL, 0x000fe200078ee24fULL, 0x000000104a477824ULL, 0x000fe200078e0249ULL,
0xfffffffc5a507812ULL, 0x000fe200078ee24fULL, 0x0000001045327825ULL, 0x040fe200078e0032ULL,
0x0000000026257faeULL, 0x0003e6000c901c46ULL, 0x000000104c4b7824ULL, 0x000fe200078e0249ULL,
0x0000000030377faeULL, 0x0003e2000d101c46ULL, 0x0000001045347825ULL, 0x000fc600078e0034ULL,
0x0000000032477faeULL, 0x0003e2000d901c46ULL, 0x000000104e4d7824ULL, 0x000fe400078e0249ULL,
0x00000010452a7825ULL, 0x040fe200078e002aULL, 0x00000000344b7faeULL, 0x0003e6000e101c46ULL,
0x0000001050497824ULL, 0x000fe200078e0249ULL, 0x000000002a4d7faeULL, 0x0003e2000e901c46ULL,
0x0000001045287825ULL, 0x000fca00078e0028ULL, 0x0000000028497faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x0000000800307811ULL, 0x042fe200078ff0ffULL,
0x00000002412a7824ULL, 0x000fe200078e023eULL, 0x0000003900277211ULL, 0x000fe200078ff0ffULL,
0x0000000448537824ULL, 0x000fe200078e00ffULL, 0x00000018004a7811ULL, 0x000fe200078ff0ffULL,
0x0000000139257824ULL, 0x000fe200078e0230ULL, 0x0000003427277210ULL, 0x080fe20007f3e0ffULL,
0x0000000430307824ULL, 0x000fe200078e00ffULL, 0x0000003800527811ULL, 0x040fe400078ff0ffULL,
0x0000003425257210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff287224ULL, 0x000fe200008e06ffULL,
0x00005e0027467a11ULL, 0x000fe200078238ffULL, 0x0000000139337824ULL, 0x000fe200078e0252ULL,
0x0000001000327811ULL, 0x000fe200078ff0ffULL, 0x000000ffff267224ULL, 0x000fe200010e06ffULL,
0x00005e0025367a11ULL, 0x000fe200078438ffULL, 0x0000000452527824ULL, 0x000fe200078e00ffULL,
0x00005f0027477a11ULL, 0x000fe200008f3c28ULL, 0x0000000139277824ULL, 0x000fe200078e024aULL,
0x00005f0025377a11ULL, 0x000fe200010f3c26ULL, 0x0000000139257824ULL, 0x040fe200078e0232ULL,
0x0000003000507811ULL, 0x000fe200078ff0ffULL, 0x0000000432327824ULL, 0x000fe200078e00ffULL,
0x00000020004c7811ULL, 0x000fe200078ff0ffULL, 0x000000044a4a7824ULL, 0x000fe200078e00ffULL,
0x00000028004e7811ULL, 0x040fe200078ff0ffULL, 0x0000000139297824ULL, 0x040fe200078e0250ULL,
0x0000000000287211ULL, 0x000fe200078fe8ffULL, 0x0000000139317824ULL, 0x000fe200078e024cULL,
0x0000003427267210ULL, 0x080fe20007fbe0ffULL, 0x00000001392b7824ULL, 0x000fe200078e024eULL,
0x0000003433277210ULL, 0x080fe20007f7e0ffULL, 0x0000000450507824ULL, 0x000fe200078e00ffULL,
0x0000003425257210ULL, 0x000fe20007fde0ffULL, 0x000000044e4e7824ULL, 0x000fe200078e00ffULL,
0x0000000328337812ULL, 0x000fe200078ec0ffULL, 0x000000044c4c7824ULL, 0x000fe200078e00ffULL,
0x000010002a517811ULL, 0x000fe200078e60ffULL, 0x000000ffff287224ULL, 0x000fe200030e06ffULL,
0xfffffffc32327812ULL, 0x000fc400078ee233ULL, 0x0000003431317210ULL, 0x080fe40007f9e0ffULL,
0x000000342b2b7210ULL, 0x080fe20007f3e0ffULL, 0x0000001032457824ULL, 0x000fe200078e0251ULL,
0x0000003429297210ULL, 0x000fe40007f5e0ffULL, 0xfffffffc50507812ULL, 0x100fe400078ee233ULL,
0xfffffffc30307812ULL, 0x100fe400078ee233ULL, 0xfffffffc4e4e7812ULL, 0x000fe200078ee233ULL,
0x00000010504f7824ULL, 0x000fe200078e0251ULL, 0x00005e0025347a11ULL, 0x000fe200078c38ffULL,
0x000000ffff507224ULL, 0x000fe200020e06ffULL, 0xfffffffc4c4c7812ULL, 0x000fe200078ee233ULL,
0x000000104e4d7824ULL, 0x000fe200078e0251ULL, 0x0ffffffc332a7812ULL, 0x000fe200078ef800ULL,
0x000000ffff4e7224ULL, 0x000fe200008e06ffULL, 0xfffffffc4a4a7812ULL, 0x000fe200078ee233ULL,
0x000000104c4b7824ULL, 0x000fe200078e0251ULL, 0xfffffffc52527812ULL, 0x000fe200078ee233ULL,
0x000000ffff337224ULL, 0x000fe200028e06ffULL, 0x00005f0025357a11ULL, 0x000fe200030f3c28ULL,
0x0000001030257824ULL, 0x100fe200078e0251ULL, 0x00005e0026327a11ULL, 0x000fe200078a38ffULL,
0x000000102a557824ULL, 0x100fe200078e0251ULL, 0xfffffffc53537812ULL, 0x000fe200078ee200ULL,
0x000000104a497824ULL, 0x000fe200078e0251ULL, 0x00005e0031307a11ULL, 0x000fe200078838ffULL,
0x000000ffff4c7224ULL, 0x000fe200010e06ffULL, 0x00005e002b2a7a11ULL, 0x000fe200078238ffULL,
0x000000ffff4a7224ULL, 0x000fe200018e06ffULL, 0x00005f0026337a11ULL, 0x000fe200028f3c33ULL,
0x0000001053467825ULL, 0x000fe200078e0046ULL, 0x00005e0029287a11ULL, 0x000fc400078438ffULL,
0x00005e0027267a11ULL, 0x000fe200078638ffULL, 0x0000001053367825ULL, 0x000fe200078e0036ULL,
0x00005f0031317a11ULL, 0x000fe200020f3c50ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000046557faeULL, 0x0003e2000b901c46ULL, 0x00005f002b2b7a11ULL, 0x000fe200008f3c4eULL,
0x0000001053347825ULL, 0x000fe200078e0034ULL, 0x00005f0029297a11ULL, 0x000fe200010f3c4cULL,
0x0000000036257faeULL, 0x0003e2000b901c46ULL, 0x00005f0027277a11ULL, 0x000fe200018f3c4aULL,
0x0000001053327825ULL, 0x040fe400078e0032ULL, 0x0000000034457faeULL, 0x0003e4000b901c46ULL,
0x0000001053307825ULL, 0x000fc400078e0030ULL, 0x0000000032497faeULL, 0x0003e4000b901c46ULL,
0x00000010532a7825ULL, 0x040fe400078e002aULL, 0x00000000304b7faeULL, 0x0003e4000b901c46ULL,
0x0000001053287825ULL, 0x000fe400078e0028ULL, 0x000000002a4d7faeULL, 0x0003e4000b901c46ULL,
0x0000001052517824ULL, 0x000fc400078e0251ULL, 0x0000001053267825ULL, 0x000fe200078e0026ULL,
0x00000000284f7faeULL, 0x0003e8000b901c46ULL, 0x0000000026517faeULL, 0x0003e4000b901c46ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff4800720cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000009947ULL, 0x000fea0003800000ULL,
0x000000043d3d7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff027424ULL, 0x000fc600078e00ffULL,
0x000000403d00720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x000000020c267824ULL, 0x002fe400078e023dULL, 0x00000004ff277424ULL, 0x000fc800078e00ffULL,
0x0000600026267625ULL, 0x000fca00078e0027ULL, 0x0000000626027981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002000497810ULL, 0x042fe20007ffe0ffULL, 0x0000000241477824ULL, 0x000fe200078e0224ULL,
0xfffffff800257812ULL, 0x040fe200078ec0ffULL, 0x000000ffff457224ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe400078ec0ffULL, 0x0000000700277812ULL, 0x000fe400078ec0ffULL,
0x0000000725467812ULL, 0x100fe400078ef800ULL, 0x0000000749497812ULL, 0x000fc400078ef800ULL,
0x0000100047477811ULL, 0x000fe400078e60ffULL, 0x0000000827487812ULL, 0x000fe400078ef800ULL,
0x00000001ff4a7819ULL, 0x000fe40000011646ULL, 0x00000001ff4c7819ULL, 0x000fe20000011649ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000444357824ULL, 0x100fe200078e0245ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000014a247824ULL, 0x020fe200078e0245ULL,
0x00000001454b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000446257824ULL, 0x000fc400078e00ffULL,
0x0000000235357824ULL, 0x000fe400078e00ffULL, 0x0000001048267824ULL, 0x000fe200078e00ffULL,
0xfffffffc25247812ULL, 0x000fe200078ee224ULL, 0x000000014c307824ULL, 0x000fe200078e0245ULL,
0x0000003500257211ULL, 0x000fe200078fe0ffULL, 0x0000000449317824ULL, 0x000fe200078e00ffULL,
0x0000000235357810ULL, 0x000fe20007ffe0ffULL, 0x0000001024287824ULL, 0x000fe200078e0247ULL,
0x0000000245457810ULL, 0x000fe20007ffe0ffULL, 0x0000000148257824ULL, 0x000fe200078e0225ULL,
0xfffffffc31307812ULL, 0x000fc400078ee230ULL, 0x0000003500357211ULL, 0x000fe200078fe0ffULL,
0x000000002828783bULL, 0x000e620000000200ULL, 0xfffffff026257812ULL, 0x000fe200078ee225ULL,
0x0000001030307824ULL, 0x000fe200078e0247ULL, 0x000000044500780cULL, 0x000fe20003f25270ULL,
0x0000000148357824ULL, 0x000fe400078e0235ULL, 0x0000001025257824ULL, 0x000fe400078e00ffULL,
0x000000003030783bULL, 0x000fe80000000200ULL, 0x000000002524783bULL, 0x000ea20000000200ULL,
0x00000028ff36723eULL, 0x002fc400020006ffULL, 0x00000028ff37723eULL, 0x000fe400030006ffULL,
0x00000029ff4e723eULL, 0x080fe400020006ffULL, 0x00000029ff4f723eULL, 0x000fe400030006ffULL,
0x0000002aff28723eULL, 0x080fe400020006ffULL, 0x0000002aff29723eULL, 0x000fe200030006ffULL,
0x000000014a2a7824ULL, 0x100fe200078e024bULL, 0x000000362420723cULL, 0x004b620000001820ULL,
0x000000014c4b7824ULL, 0x000fcc00078e024bULL, 0x0000000446377824ULL, 0x020fe200078e00ffULL,
0x000000282418723cULL, 0x040be80000001818ULL, 0xfffffffc37347812ULL, 0x000fe400078ee22aULL,
0x0000002bff2a723eULL, 0x080fe200020006ffULL, 0x0000001048287824ULL, 0x020fe200078e00ffULL,
0x0000004e241c723cULL, 0x000b62000000181cULL, 0x0000001034347824ULL, 0x000fe200078e0247ULL,
0x0000002bff2b723eULL, 0x000fc400030006ffULL, 0xfffffff028287812ULL, 0x000fc600078ee235ULL,
0x00000030ff4e723eULL, 0x0a0fe200020006ffULL, 0x000000003434783bULL, 0x000e620000000200ULL,
0x00000030ff4f723eULL, 0x000fe200030006ffULL, 0x0000001028287824ULL, 0x000fe200078e00ffULL,
0x00000031ff30723eULL, 0x080fe200020006ffULL, 0x0000002a242c723cULL, 0x000b62000000182cULL,
0x00000031ff31723eULL, 0x000fc600030006ffULL, 0x000000002828783bULL, 0x020ea80000000200ULL,
0x0000004e2414723cULL, 0x040b6e0000001814ULL, 0x00000004494e7824ULL, 0x020fe200078e00ffULL,
0x000000302410723cULL, 0x000b620000001810ULL, 0x00000033ff4f723eULL, 0x000fcc00030006ffULL,
0x00000032ff30723eULL, 0x0a0fe400020006ffULL, 0x00000032ff31723eULL, 0x000fe400030006ffULL,
0xfffffffc4e327812ULL, 0x000fe400078ee24bULL, 0x00000033ff4e723eULL, 0x000fc600020006ffULL,
0x0000001032327824ULL, 0x000fe200078e0247ULL, 0x000000302408723cULL, 0x040b6a0000001808ULL,
0x000000003230783bULL, 0x020ee60000000200ULL, 0x0000004e2404723cULL, 0x000b6e0000001804ULL,
0x00000034ff24723eULL, 0x022fc400020006ffULL, 0x00000034ff25723eULL, 0x000fe400030006ffULL,
0x00000035ff34723eULL, 0x080fe400020006ffULL, 0x00000035ff35723eULL, 0x000fc600030006ffULL,
0x000000242820723cULL, 0x044b6e0000001820ULL, 0x00000036ff24723eULL, 0x0a0fe200020006ffULL,
0x00000034281c723cULL, 0x000f62000000181cULL, 0x00000036ff25723eULL, 0x000fe400030006ffULL,
0x00000037ff36723eULL, 0x000fc400020006ffULL, 0x00000037ff37723eULL, 0x000fc600030006ffULL,
0x000000242818723cULL, 0x040b6e0000001818ULL, 0x00000030ff24723eULL, 0x0a8fe200020006ffULL,
0x00000036282c723cULL, 0x000f62000000182cULL, 0x00000030ff25723eULL, 0x000fe400030006ffULL,
0x00000031ff30723eULL, 0x000fc400020006ffULL, 0x00000031ff31723eULL, 0x000fc600030006ffULL,
0x000000242814723cULL, 0x040b6e0000001814ULL, 0x00000032ff24723eULL, 0x0a0fe200020006ffULL,
0x000000302810723cULL, 0x000b620000001810ULL, 0x00000032ff25723eULL, 0x000fe400030006ffULL,
0x00000033ff32723eULL, 0x000fc400020006ffULL, 0x00000033ff33723eULL, 0x000fc600030006ffULL,
0x000000242808723cULL, 0x040b700000001808ULL, 0x000000322804723cULL, 0x000b620000001804ULL,
0xfffffa8000001947ULL, 0x000fce000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff247224ULL, 0x020fe200078e003eULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffeb2000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000000e20257220ULL, 0x080fe20000410000ULL, 0x0000000e21267220ULL, 0x080fe20000410000ULL,
0x0000000e22207220ULL, 0x080fe20000410000ULL, 0x0000000e23217220ULL, 0x080fe20000410000ULL,
0x0000000e2c2b7220ULL, 0x080fe20000410000ULL, 0x0000000e1c277220ULL, 0x080fe20000410000ULL,
0x0000000e1d287220ULL, 0x080fe20000410000ULL, 0x0000000e1e307220ULL, 0x080fe20000410000ULL,
0x0000000e1f317220ULL, 0x080fe20000410000ULL, 0x0000000e18297220ULL, 0x080fe20000410000ULL,
0x0000000e192a7220ULL, 0x080fe20000410000ULL, 0x0000000e2d2c7220ULL, 0x080fe20000410000ULL,
0x0000000e10237220ULL, 0x080fe20000410000ULL, 0x0000000e11227220ULL, 0x080fe20000410000ULL,
0x0000000e1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000e1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000e2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000e2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000e142d7220ULL, 0x080fe20000410000ULL, 0x0000000e15247220ULL, 0x080fe20000410000ULL,
0x0000000e16187220ULL, 0x080fe20000410000ULL, 0x0000000e17197220ULL, 0x080fe20000410000ULL,
0x0000000e12107220ULL, 0x080fe20000410000ULL, 0x0000000e13117220ULL, 0x080fe20000410000ULL,
0x0000000e081f7220ULL, 0x080fe20000410000ULL, 0x0000000e091e7220ULL, 0x080fe20000410000ULL,
0x0000000e0a327220ULL, 0x080fe20000410000ULL, 0x0000000e0b337220ULL, 0x080fe20000410000ULL,
0x0000000e041d7220ULL, 0x080fe20000410000ULL, 0x0000000e051c7220ULL, 0x080fe20000410000ULL,
0x0000000e06067220ULL, 0x080fe20000410000ULL, 0x0000000e07077220ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000038047f8cULL, 0x0002a2000c80043fULL,
0x000000ffff137224ULL, 0x000fc400078e001aULL, 0x000000ffff147224ULL, 0x000fe400078e001bULL,
0x000000ffff177224ULL, 0x000fe400078e0018ULL, 0x000000ffff127224ULL, 0x000fe400078e0019ULL,
0x000000ffff087224ULL, 0x000fe400078e0020ULL, 0x000000ffff097224ULL, 0x000fe400078e0021ULL,
0x000000ffff0a7224ULL, 0x000fc400078e0030ULL, 0x000000ffff0b7224ULL, 0x000fe400078e0031ULL,
0x000000ffff157224ULL, 0x000fe400078e002eULL, 0x000000ffff167224ULL, 0x000fe400078e002fULL,
0x000000ffff187224ULL, 0x000fe400078e0032ULL, 0x000000ffff197224ULL, 0x000fe400078e0033ULL,
0x000000ffff1a7224ULL, 0x000fc400078e0006ULL, 0x000000ffff1b7224ULL, 0x000fc400078e0007ULL,
0x0000000000067805ULL, 0x006fca0000015200ULL, 0x0000040038217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x00000020062f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e07ULL,
0x003d09002f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff207819ULL, 0x000fc80000011421ULL, 0x0000002f20207211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0621ULL, 0x0000000220207819ULL, 0x000fc80000001221ULL,
0x000000200000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040038217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000400217824ULL, 0x000fe200078e00ffULL,
0x0000003a3c00720cULL, 0x000fc80003f05270ULL, 0xfffffff021207812ULL, 0x000fca00078ec0ffULL,
0x0000008041207824ULL, 0x000fca00078e0220ULL, 0x00f4000020047984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x00000002002e7824ULL, 0x000fe400078e00ffULL,
0x00000001423f7824ULL, 0x000fc600078e0a3fULL, 0x000000062e2e7812ULL, 0x000fc800078ec0ffULL,
0x000000012e307812ULL, 0x040fe400078efcffULL, 0x000000082e327812ULL, 0x000fe400078efcffULL,
0x0000003f3000720cULL, 0x080fe40003f26070ULL, 0x000000102e307812ULL, 0x000fe400078efcffULL,
0x0000003f3200720cULL, 0x080fe40003f06070ULL, 0x0000003f3000720cULL, 0x000fc40003fc6070ULL,
0x000000112e327812ULL, 0x040fe400078efcffULL, 0x000000182e307812ULL, 0x040fe400078efcffULL,
0x0000003f2e00720cULL, 0x080fe40003f46070ULL, 0x0000003f3200720cULL, 0x080fe40003fa6070ULL,
0x0000003f3000720cULL, 0x000fe40003f66070ULL, 0x000000092e347812ULL, 0x000fc400078efcffULL,
0x000000192e327812ULL, 0x040fe400078efcffULL, 0x000000202e307812ULL, 0x000fe400078efcffULL,
0xff80000008087808ULL, 0x000fe40005000000ULL, 0xff80000025257808ULL, 0x000fe40005000000ULL,
0xff80000009097808ULL, 0x000fe40004800000ULL, 0xff80000026267808ULL, 0x000fc40004800000ULL,
0x0000003f3400720cULL, 0x080fe40003f86070ULL, 0x0000003f3200720cULL, 0x080fe40003f46070ULL,
0x0000003f3000720cULL, 0x000fe40003f26070ULL, 0x000000212e327812ULL, 0x040fe400078efcffULL,
0x000000282e307812ULL, 0x000fe400078efcffULL, 0xff8000000a0a7808ULL, 0x000fc40004000000ULL,
0xff80000027277808ULL, 0x000fe40004000000ULL, 0xff8000000b0b7808ULL, 0x000fe40006000000ULL,
0xff80000028287808ULL, 0x000fe40006000000ULL, 0x0000003f3200720cULL, 0x080fe40003f06070ULL,
0x0000003f3000720cULL, 0x000fe40003f86070ULL, 0x000000292e327812ULL, 0x000fc400078efcffULL,
0x000000302e307812ULL, 0x000fe400078efcffULL, 0xff80000013137808ULL, 0x000fe40007000000ULL,
0xff80000029297808ULL, 0x000fe40007000000ULL, 0xff80000014147808ULL, 0x000fe40006800000ULL,
0xff8000002a2a7808ULL, 0x000fe40006800000ULL, 0x0000003f3200720cULL, 0x000fc40003fc6070ULL,
0x0000003f3000720cULL, 0x000fe40003fa6070ULL, 0x000000312e327812ULL, 0x040fe400078efcffULL,
0x000000382e307812ULL, 0x040fe400078efcffULL, 0x000000392e2e7812ULL, 0x000fe400078efcffULL,
0xff80000015157808ULL, 0x000fe40005800000ULL, 0xff8000002b2b7808ULL, 0x000fc40005800000ULL,
0xff80000016167808ULL, 0x000fe40005000000ULL, 0xff8000002c2c7808ULL, 0x000fe40005000000ULL,
0xff80000017177808ULL, 0x000fe40004800000ULL, 0xff8000002d2d7808ULL, 0x000fe40004800000ULL,
0x0000003f3200720cULL, 0x080fe40003f66070ULL, 0x0000003f3000720cULL, 0x000fc40003f46070ULL,
0x0000003f2e00720cULL, 0x000fe40003f26070ULL, 0xff80000012127808ULL, 0x000fe40004000000ULL,
0xff80000024247808ULL, 0x000fe40004000000ULL, 0xff80000010107808ULL, 0x000fe40006000000ULL,
0xff80000023237808ULL, 0x000fe40006000000ULL, 0xff80000011117808ULL, 0x000fc40007000000ULL,
0xff80000022227808ULL, 0x000fe40007000000ULL, 0xff80000018187808ULL, 0x000fe40006800000ULL,
0xff8000001f1f7808ULL, 0x000fe40006800000ULL, 0xff80000019197808ULL, 0x000fe40005800000ULL,
0xff8000001e1e7808ULL, 0x000fe40005800000ULL, 0xff8000001a1a7808ULL, 0x000fc40005000000ULL,
0xff8000001d1d7808ULL, 0x000fe40005000000ULL, 0xff8000001b1b7808ULL, 0x000fe40004800000ULL,
0xff8000001c1c7808ULL, 0x000fc40004800000ULL, 0x000000250400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff367424ULL, 0x000fe200078e00ffULL, 0x000000080500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff377424ULL, 0x000fe200078e00ffULL, 0x00000004252f7208ULL, 0x000fe40004000000ULL,
0x0000000508047208ULL, 0x000fc40004800000ULL, 0x000000262f00720bULL, 0x000fe40003f1e000ULL,
0x000000090400720bULL, 0x000fe40003f3e000ULL, 0x0000002f262e7208ULL, 0x000fe40004000000ULL,
0x0000000409057208ULL, 0x000fe40004800000ULL, 0x000000272e00720bULL, 0x000fe40003f1e000ULL,
0x0000000a0500720bULL, 0x000fc40003f3e000ULL, 0x0000002e272f7208ULL, 0x000fe40004000000ULL,
0x000000050a047208ULL, 0x000fe40004800000ULL, 0x000000282f00720bULL, 0x000fe40003f1e000ULL,
0x0000000b0400720bULL, 0x000fe40003f3e000ULL, 0x0000002f282e7208ULL, 0x000fe40004000000ULL,
0x000000040b047208ULL, 0x000fc40004800000ULL, 0x000000292e00720bULL, 0x000fe40003f1e000ULL,
0x000000130400720bULL, 0x000fe40003f3e000ULL, 0x0000002e29057208ULL, 0x000fe40004000000ULL,
0x00000004132f7208ULL, 0x000fe40004800000ULL, 0x0000002a0500720bULL, 0x000fe40003f1e000ULL,
0x000000142f00720bULL, 0x000fc40003f3e000ULL, 0x000000052a047208ULL, 0x000fe40004000000ULL,
0x0000002f142e7208ULL, 0x000fe40004800000ULL, 0x0000002b0400720bULL, 0x000fe40003f1e000ULL,
0x000000152e00720bULL, 0x000fe40003f3e000ULL, 0x000000042b057208ULL, 0x000fe40004000000ULL,
0x0000002e152f7208ULL, 0x000fc40004800000ULL, 0x0000002c0500720bULL, 0x000fe40003f1e000ULL,
0x000000162f00720bULL, 0x000fe40003f3e000ULL, 0x000000052c047208ULL, 0x000fe40004000000ULL,
0x0000002f162e7208ULL, 0x000fe40004800000ULL, 0x0000002d0400720bULL, 0x000fe40003f1e000ULL,
0x000000172e00720bULL, 0x000fc40003f3e000ULL, 0x000000042d057208ULL, 0x000fe40004000000ULL,
0x0000002e172f7208ULL, 0x000fe40004800000ULL, 0x000000240500720bULL, 0x000fe40003f1e000ULL,
0x000000122f00720bULL, 0x000fe40003f3e000ULL, 0x0000000524047208ULL, 0x000fe40004000000ULL,
0x0000002f122f7208ULL, 0x000fc40004800000ULL, 0x000000230400720bULL, 0x000fe40003f1e000ULL,
0x000000102f00720bULL, 0x000fe40003f3e000ULL, 0x0000000423057208ULL, 0x000fe40004000000ULL,
0x0000002f10047208ULL, 0x000fe40004800000ULL, 0x000000220500720bULL, 0x000fe40003f1e000ULL,
0x000000110400720bULL, 0x000fc40003f3e000ULL, 0x00000005222e7208ULL, 0x000fe40004000000ULL,
0x0000000411057208ULL, 0x000fe40004800000ULL, 0x0000001f2e00720bULL, 0x000fe40003f1e000ULL,
0x000000180500720bULL, 0x000fe40003f3e000ULL, 0x0000002e1f2f7208ULL, 0x000fe40004000000ULL,
0x0000000518047208ULL, 0x000fc40004800000ULL, 0x0000001e2f00720bULL, 0x000fe40003f1e000ULL,
0x000000190400720bULL, 0x000fe40003f3e000ULL, 0x0000002f1e2e7208ULL, 0x000fe40004000000ULL,
0x0000000419057208ULL, 0x000fe40004800000ULL, 0x0000001d2e00720bULL, 0x000fe40003f1e000ULL,
0x0000001a0500720bULL, 0x000fc40003f3e000ULL, 0x0000002e1d2f7208ULL, 0x000fe40004000000ULL,
0x000000051a047208ULL, 0x000fe40004800000ULL, 0x0000001c2f00720bULL, 0x000fe40003f1e000ULL,
0x0000001b0400720bULL, 0x000fe40003f3e000ULL, 0x0000002f1c327208ULL, 0x000fe40004000000ULL,
0x000000041b347208ULL, 0x000fe20004800000ULL, 0x000014d27f007947ULL, 0x000fec000b800000ULL,
0x0c401f0032047f89ULL, 0x0004e400000e0000ULL, 0x000000043200720bULL, 0x008fc80003f1e000ULL,
0x0000003204357208ULL, 0x000fe20004000000ULL, 0x000014e27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0034047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0006057f89ULL, 0x000e6800000e0000ULL,
0x0c401f00072e7f89ULL, 0x000ea200000e0000ULL, 0x000000043400720bULL, 0x008fc40003f1e000ULL,
0x000000050600720bULL, 0x002fe40003f3e000ULL, 0x0000003404307208ULL, 0x000fe40004000000ULL,
0x0000000605317208ULL, 0x000fe20004800000ULL, 0x0c201f0035047f89ULL, 0x000e6200000e0000ULL,
0x0000002e0700720bULL, 0x004fc60003f1e000ULL, 0x0c201f0030057f89ULL, 0x000ea200000e0000ULL,
0x000000072e2e7208ULL, 0x000fc60004000000ULL, 0x0c201f0031327f89ULL, 0x000ee800000e0000ULL,
0x0c201f002e2f7f89ULL, 0x0002e400000e0000ULL, 0x000000043500720bULL, 0x002fe40003f1e000ULL,
0x000000053000720bULL, 0x004fe40003f3e000ULL, 0x0000003504047208ULL, 0x000fc40004000000ULL,
0x000000323100720bULL, 0x008fe40003f5e000ULL, 0x0000003005057208ULL, 0x000fe40004800000ULL,
0x0000003132067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04307820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000300ff7812ULL, 0x000fe4000780c0ffULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010830ULL,
0x0000002800347308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b1f077823ULL, 0x100fe20000010830ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010830ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010830ULL,
0x0000002600327308ULL, 0x0023e20000000800ULL, 0x3fb8aa3b1c287823ULL, 0x008fe20000010830ULL,
0x3fb8aa3b051c7820ULL, 0x000fe20000410000ULL, 0x0000002f2e00720bULL, 0x004fc60003f3e000ULL,
0x3fb8aa3b08087823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b09097823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b0b0b7823ULL, 0x000fe2000001081cULL,
0x0000002500317308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b24267823ULL, 0x102fe20000010830ULL,
0x3fb8aa3b23247823ULL, 0x000fe20000010830ULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b15157823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b17357823ULL, 0x000fe2000001081cULL,
0x0000002700337308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b2d257823ULL, 0x004fce0000010830ULL,
0x00000008001f7308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b22277823ULL, 0x002fce0000010830ULL,
0x0000000900227308ULL, 0x000e620000000800ULL, 0x000000313208723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b11327823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b10317823ULL, 0x000fca000001081cULL,
0x0000000a00237308ULL, 0x0005f00000000800ULL, 0x0000000b00307308ULL, 0x000ee20000000800ULL,
0x0000001f2209723eULL, 0x002fe200000000ffULL, 0x3c003c00ff227424ULL, 0x000fe200078e00ffULL,
0x00000033340a723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b121f7823ULL, 0x000fe2000001081cULL,
0x00000002ff347819ULL, 0x000fc60000011600ULL, 0x0000001400367308ULL, 0x000fe20000000800ULL,
0x0000000234337810ULL, 0x040fe20007ffe0ffULL, 0x0000000834377824ULL, 0x000fe200078e00ffULL,
0x00000023300b723eULL, 0x008fe200000000ffULL, 0x3c003c00ff237424ULL, 0x000fc800078e00ffULL,
0x00000015002d7308ULL, 0x000ff00000000800ULL, 0x0000001600447308ULL, 0x0003f00000000800ULL,
0x0000001300137308ULL, 0x000ea20000000800ULL, 0x000000220814723cULL, 0x002f6e00000018ffULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x0000002a002a7308ULL, 0x000e620000000800ULL,
0x000000133611723eULL, 0x004fe200000000ffULL, 0x0000000834367824ULL, 0x000fe200078e00ffULL,
0x0000002d4413723eULL, 0x000fe200000000ffULL, 0x00000008342d7824ULL, 0x000fc600078e00ffULL,
0xfffffff836337812ULL, 0x000fe200078ee233ULL, 0x0000002b002b7308ULL, 0x000ff00000000800ULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x000000292a10723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b19297823ULL, 0x000fcc000001081cULL, 0x0000001f00307308ULL, 0x0003e20000000800ULL,
0x0000002b2c12723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b181f7823ULL, 0x102fe2000001081cULL,
0x3fb8aa3b1a2b7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b1b1c7823ULL, 0x000fc8000001081cULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x00000001342c7810ULL, 0x040fe20007ffe0ffULL,
0x000000221018723cULL, 0x020b660000001814ULL, 0xfffffff82d2d7812ULL, 0x000fe400078ee22cULL,
0xffffffff342c7810ULL, 0x040fe20007ffe0ffULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x0000000834167824ULL, 0x060fe200078e00ffULL, 0x0000000334147810ULL, 0x000fc40007ffe0ffULL,
0x0000000434157810ULL, 0x000fe40007ffe0ffULL, 0xfffffff837377812ULL, 0x000fe400078ee214ULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0xfffffff8163f7812ULL, 0x000fce00078ee215ULL,
0x0000002700277308ULL, 0x000ea20000000800ULL, 0x000000252614723eULL, 0x002fe200000000ffULL,
0x0000000834257824ULL, 0x040fe200078e00ffULL, 0x0000000534267810ULL, 0x000fc80007ffe0ffULL,
0xfffffff825257812ULL, 0x000fe200078ee234ULL, 0x0000003500357308ULL, 0x000e700000000800ULL,
0x0000003100317308ULL, 0x000fe20000000800ULL, 0x000000242716723eULL, 0x004fe200000000ffULL,
0x0000000834277824ULL, 0x000fca00078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee226ULL,
0x0000003200327308ULL, 0x000ea20000000800ULL, 0x000000353015723eULL, 0x002fe200000000ffULL,
0x0000000834307824ULL, 0x040fe200078e00ffULL, 0x0000000834357810ULL, 0x000fe40007ffe0ffULL,
0x0000900041267811ULL, 0x000fc600078e58ffULL, 0x0000000700077308ULL, 0x000fe40000000800ULL,
0x0000001025257824ULL, 0x100fe400078e0226ULL, 0x000000102d2d7824ULL, 0x100fe400078e0226ULL,
0x0000001033337824ULL, 0x000fe200078e0226ULL, 0x000000313217723eULL, 0x004fe200000000ffULL,
0x0000001e001e7308ULL, 0x000e620000000800ULL, 0x0000000834317824ULL, 0x000fe400078e00ffULL,
0x0000000835327824ULL, 0x000fc400078e00ffULL, 0x0000001037377824ULL, 0x000fe200078e0226ULL,
0x000000221418723cULL, 0x000f620000001818ULL, 0xfffffff831317812ULL, 0x000fe200078ee22cULL,
0x0000001d001d7308ULL, 0x000fe20000000800ULL, 0xfffffff832357812ULL, 0x000fe200078ee235ULL,
0x000000103f3f7824ULL, 0x100fe400078e0226ULL, 0x0000001027277824ULL, 0x100fe400078e0226ULL,
0x0000001031317824ULL, 0x100fe400078e0226ULL, 0x0000002800287308ULL, 0x000ea20000000800ULL,
0x0000001035357824ULL, 0x000fce00078e0226ULL, 0x0000001f001f7308ULL, 0x000ff00000000800ULL,
0x00000029002a7308ULL, 0x0006700000000800ULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x0000000634297810ULL, 0x008fc80007ffe0ffULL, 0xfffffff830297812ULL, 0x000fc600078ee229ULL,
0x0000001c00247308ULL, 0x0002e40000000800ULL, 0x0000001029297824ULL, 0x000fe200078e0226ULL,
0x000000071e1c723eULL, 0x002fe400000000ffULL, 0x0000001d281e723eULL, 0x004fe400000000ffULL,
0x0000001f2a1d723eULL, 0x000fe400000000ffULL, 0x0000002e2f077208ULL, 0x000fe40004800000ULL,
0x0000002b241f723eULL, 0x008fc400000000ffULL, 0x0000000c21247812ULL, 0x000fca00078ec0ffULL,
0x000000221c18723cULL, 0x020f620000001818ULL, 0x0000000125257824ULL, 0x000fe400078e0224ULL,
0x00000001242d7824ULL, 0x040fe400078e022dULL, 0x0000000124337824ULL, 0x040fe200078e0233ULL,
0x0000000825007388ULL, 0x0003e20000000800ULL, 0x0000000124377824ULL, 0x040fe400078e0237ULL,
0x00000001243f7824ULL, 0x040fe200078e023fULL, 0x0000000a2d007388ULL, 0x0003e20000000800ULL,
0x0000000124277824ULL, 0x000fc400078e0227ULL, 0x0000000124297824ULL, 0x040fe200078e0229ULL,
0x0000001033007388ULL, 0x0003e20000000800ULL, 0x0000000124317824ULL, 0x040fe400078e0231ULL,
0x0000000124247824ULL, 0x000fe200078e0235ULL, 0x0000001237007388ULL, 0x0003e80000000800ULL,
0x000000143f007388ULL, 0x0003e40000000800ULL, 0x000000ffff197224ULL, 0x020fc400078e001aULL,
0x0000001627007388ULL, 0x0003e80000000800ULL, 0x0000001c29007388ULL, 0x0003e80000000800ULL,
0x0000001e31007388ULL, 0x0003e80000000800ULL, 0x0000000924007388ULL, 0x0003e80000000800ULL,
0x0004000b2d007388ULL, 0x0003e80000000800ULL, 0x0004001133007388ULL, 0x0003e80000000800ULL,
0x0004001337007388ULL, 0x0003e80000000800ULL, 0x000400153f007388ULL, 0x0003e80000000800ULL,
0x0004001727007388ULL, 0x0003e80000000800ULL, 0x0004001d29007388ULL, 0x0003e80000000800ULL,
0x0004001f31007388ULL, 0x0003e80000000800ULL, 0x00f0000420008388ULL, 0x0003e80000000c00ULL,
0x00f2001820008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000003bff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000008003bff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000010003bff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000013c3c7810ULL, 0x000fe20007ffe0ffULL, 0x000018003bff7f8cULL, 0x0003e6000c80043fULL,
0x0000000f3c00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffce8000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff117807ULL, 0x008fe40004000000ULL, 0x0000e51000107802ULL, 0x000fc40000000f00ULL,
0x00000c6000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0016ULL,
0xffff3e8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x000fe40004000000ULL,
0x0000e56000107802ULL, 0x000fc40000000f00ULL, 0x00000c1000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0016ULL, 0xffff3ee000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x008fe200078e0039ULL, 0x0000e5b000387802ULL, 0x000fc40000000f00ULL,
0x00000b7000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff3fa000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0039ULL,
0x0000e60000387802ULL, 0x000fc40000000f00ULL, 0x00000b2000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff40c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0015ULL, 0x0000e66000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0012ULL, 0x00000ac000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0017ULL, 0xffff44d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e000cULL, 0x0000e6c000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff177224ULL, 0x000fc400078e0015ULL, 0x00000a6000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0017ULL, 0xffff44a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x004fe40004000000ULL, 0x0000e71000107802ULL, 0x000fc40000000f00ULL,
0x00000a6000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff157224ULL, 0x000fe200078e0016ULL,
0xffff5e0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x000fe40004000000ULL,
0x0000e76000107802ULL, 0x000fc40000000f00ULL, 0x00000a1000007944ULL, 0x018fea0003c00000ULL,
0xffff5e6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x0000e7a000387802ULL, 0x000fc40000000f00ULL, 0x0000098000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff5f4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x0000e7f000387802ULL, 0x000fc40000000f00ULL,
0x0000093000007944ULL, 0x01afea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff605000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x0000e85000387802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fc400078e0013ULL,
0x000008d000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e0017ULL,
0xffff646000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x0000e8a000387802ULL, 0x000fc40000000f00ULL, 0x0000088000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0017ULL, 0xffff644000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x004fe40004000000ULL, 0x0000e8f000107802ULL, 0x000fc40000000f00ULL,
0x0000088000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0016ULL,
0xffff7aa000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x000fe40004000000ULL,
0x0000e94000107802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0016ULL, 0xffff7af000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0016ULL, 0x0000e99000387802ULL, 0x000fc40000000f00ULL,
0x0000079000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff7bd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0016ULL,
0x0000e9e000387802ULL, 0x000fc40000000f00ULL, 0x0000074000007944ULL, 0x01afea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff7ce000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x0000ea4000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0013ULL, 0x000006e000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0017ULL, 0xffff80f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x0000ea9000387802ULL, 0x000fc40000000f00ULL,
0x0000069000007944ULL, 0x01efea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0017ULL,
0xffff80d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff117807ULL, 0x004fe40004000000ULL,
0x0000eae000107802ULL, 0x000fc40000000f00ULL, 0x0000069000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0016ULL, 0xffff979000007947ULL, 0x000fea000383ffffULL,
0x00000001ff117807ULL, 0x000fe40004000000ULL, 0x0000eb3000107802ULL, 0x000fc40000000f00ULL,
0x0000064000007944ULL, 0x018fea0003c00000ULL, 0xffff97f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x0000eb7000387802ULL, 0x000fc40000000f00ULL,
0x000005b000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff98c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x0000ebc000387802ULL, 0x000fc40000000f00ULL, 0x0000056000007944ULL, 0x01afea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff99d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x0000ec2000387802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0013ULL, 0x0000050000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e0017ULL, 0xffff9dd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x0000ec7000387802ULL, 0x000fc40000000f00ULL,
0x000004b000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0017ULL,
0xffff9db000007947ULL, 0x000fea000383ffffULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x0000ecc000307802ULL, 0x000fc40000000f00ULL, 0x0000042000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e002fULL, 0xffffeaf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x006fe200078e0034ULL, 0x0000ed2000307802ULL, 0x000fe20000000f00ULL,
0x00000002ff337424ULL, 0x000fc400078e00ffULL, 0x000003c000007944ULL, 0x010fea0003c00000ULL,
0x0000002f3400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0006ULL,
0x0000ed8000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x000000342f347208ULL, 0x000fc80004000000ULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0x0000002f0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0007ULL,
0x0000ede000307802ULL, 0x000fe20000000f00ULL, 0x00000002ff337424ULL, 0x000fe200078e00ffULL,
0x000000062f067208ULL, 0x000fc80004000000ULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x0000002f0700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0035ULL,
0x0000ee4000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x000000072f2e7208ULL, 0x000fc80004000000ULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x0000002f3500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0034ULL,
0x0000eea000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x000000352f047208ULL, 0x000fc80004000000ULL, 0x0000024000007944ULL, 0x000fea0003c00000ULL,
0x0000002f3400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0006ULL,
0x0000ef0000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x000000342f057208ULL, 0x000fc80004000000ULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0x0000002f0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e002eULL,
0x0000ef6000307802ULL, 0x000fe20000000f00ULL, 0x00000001ff337424ULL, 0x000fe200078e00ffULL,
0x000000062f067208ULL, 0x000fc80004000000ULL, 0x0000018000007944ULL, 0x000fea0003c00000ULL,
0xffffe9c000007947ULL, 0x000fea000383ffffULL, 0x0180000005007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000500008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff077807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000007ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff05ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000005027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000007ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000500007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff057424ULL, 0x006fc800078e00ffULL, 0xffff0f2004007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff317424ULL, 0x000fe200078e00ffULL, 0x0000003700007348ULL, 0x000fe80003800000ULL,
0x0c000033322f7389ULL, 0x0002a200000e0036ULL, 0xffff0ee030007950ULL, 0x000fea0003c3ffffULL,
0x0000004500007348ULL, 0x000fe80003800000ULL, 0x0000001017177389ULL, 0x0002a200000e0048ULL,
0x00000000ff117424ULL, 0x000fc400078e00ffULL, 0x000000ffff107224ULL, 0x002fc800078e0038ULL,
0xffff0e9010007950ULL, 0x000fea0003c3ffffULL, 0x000000011100780cULL, 0x000fe20003f05070ULL,
0x0000004600007348ULL, 0x000fd80003800000ULL, 0x0000000000117806ULL, 0x000fc800040e0100ULL,
0x0000004611167212ULL, 0x000fe200078ec0ffULL, 0x00000000ff117424ULL, 0x000fc800078e00ffULL,
0xffff0e3010007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005deULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x00000000000002e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ca8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d68ULL, 0x0000000000000780ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000014e8ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000014f8ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001588ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000000158cULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001780ULL, 0x000000000000f280ULL, 0x6400001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000010a00ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000010a50ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000010dd0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001588ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000f478ULL, 0x000000000000f478ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000010a00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000010dd0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_e4m3_pagedKV_64_nqpkv_8_m_8_sm_89_cubin_len = 69296;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
