/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000016940ULL, 0x00000000000165c0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL,
0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL,
0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL,
0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL,
0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c00010000028dULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00010000036fULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b0022000003b5ULL, 0x0000000000014cc0ULL, 0x0000000000000170ULL, 0x000b0022000003e8ULL,
0x0000000000014e30ULL, 0x0000000000000040ULL, 0x000b002200000413ULL, 0x0000000000014e70ULL,
0x0000000000000050ULL, 0x000b00220000043dULL, 0x0000000000014ec0ULL, 0x0000000000000140ULL,
0x000a0003000004abULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000004cbULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004fbULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000015000ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00014cc000000000ULL, 0x0000040400000000ULL, 0x810c000001500400ULL,
0x0051d40400288080ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL,
0x8808288080870828ULL, 0x2880808b08288080ULL, 0x808e082880808d08ULL, 0x082880808f082880ULL,
0x80809d082880809bULL, 0xa2082880809f0828ULL, 0x288080a508288080ULL, 0x80b308288080ab08ULL,
0x08288080b9082880ULL, 0x808280162880808cULL, 0x0000000000031028ULL, 0x2880808c92000000ULL,
0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x00014cc000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL,
0x8b08288080870828ULL, 0x2880808c08288080ULL, 0x808e082880808d08ULL, 0x082880808f082880ULL,
0x80809d082880809bULL, 0xa2082880809f0828ULL, 0x288080a508288080ULL, 0x80b308288080ab08ULL,
0x08288080b9082880ULL, 0x8082801628808088ULL, 0x0000000000031028ULL, 0x2880808892000000ULL,
0x0000000000002200ULL, 0x0000001cffffffffULL, 0x0000013000000000ULL, 0x00014e3000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL,
0x8808288080870828ULL, 0x2880808b08288080ULL, 0x808d082880808c08ULL, 0x082880808e082880ULL,
0x80809d082880809bULL, 0xa2082880809f0828ULL, 0x288080a508288080ULL, 0x80b308288080ab08ULL,
0x08288080b9082880ULL, 0x808280162880808fULL, 0x0000000000031028ULL, 0x2880808f92000000ULL,
0x0000000000002200ULL, 0x0000002cffffffffULL, 0x000001f000000000ULL, 0x00014e7000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x808e2880808f0900ULL, 0x0000000000002880ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080860828808081ULL, 0x8808288080870828ULL, 0x2880808b08288080ULL,
0x808d082880808c08ULL, 0x082880808f082880ULL, 0x80809d082880809bULL, 0xa2082880809f0828ULL,
0x288080a508288080ULL, 0x80b308288080ab08ULL, 0x08288080b9082880ULL, 0x808280162880808eULL,
0x0000000000031028ULL, 0x2880808e92000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x000002c000000000ULL, 0x00014ec000000000ULL, 0x0000014000000000ULL, 0x0000000000000000ULL,
0x0000001800082f04ULL, 0x000823040000007fULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL,
0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL, 0x0000000000000012ULL,
0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL, 0x0000001100082304ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008230400000000ULL,
0x0000000000000018ULL, 0x0000001800081204ULL, 0x0008110400000000ULL, 0x0000000000000018ULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0058016000000015ULL, 0x000c170400581903ULL,
0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040021f000ULL,
0x0040000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040061f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0x000008b000043104ULL, 0xffffffff01542904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000002d001542804ULL, 0x000004e000000440ULL, 0x0000285000001880ULL, 0x00002a10000028f0ULL,
0x00002d8000002b70ULL, 0x00002e2000002db0ULL, 0x000034e000002e90ULL, 0x00004450000043b0ULL,
0x000046e000004580ULL, 0x00004920000048f0ULL, 0x00004a0000004990ULL, 0x00005d2000004e60ULL,
0x00005ef000005dc0ULL, 0x0000626000006050ULL, 0x0000630000006290ULL, 0x0000682000006370ULL,
0x000077c000007730ULL, 0x00007a50000078f0ULL, 0x00007c9000007c60ULL, 0x00007d7000007d00ULL,
0x000082e0000082d0ULL, 0x0000a6b00000a670ULL, 0x0000ae100000add0ULL, 0x0001329000013250ULL,
0x000132b0000132a0ULL, 0x0001332000013300ULL, 0x0001335000013340ULL, 0x00013ff000013fa0ULL,
0x000140c000014060ULL, 0x000141a000014130ULL, 0x0001425000014200ULL, 0x00014320000142c0ULL,
0x0001440000014390ULL, 0x000144b000014460ULL, 0x0001458000014520ULL, 0x00014660000145f0ULL,
0x00014710000146c0ULL, 0x000147e000014780ULL, 0x000148c000014850ULL, 0x000149a000014930ULL,
0x00014aa000014a20ULL, 0x00014ba000014b20ULL, 0x00014ca000014c20ULL, 0x000003b002003904ULL,
0x0001b600000000ffULL, 0x000003e0003f0100ULL, 0x0001b6080000000bULL, 0x00000480003f0120ULL,
0x0001b6880000000bULL, 0x00000920003f0120ULL, 0x0001b600000000ffULL, 0x00000a30003f0107ULL,
0x0001b68c00000071ULL, 0x00000ac0003f0102ULL, 0x0001b68800000071ULL, 0x00002540003f0101ULL,
0x0001b60800000030ULL, 0x00002580003f0101ULL, 0x0001b60c00000009ULL, 0x00002750003f0105ULL,
0x0001b60c00000009ULL, 0x000034a0003f0105ULL, 0x0001b6880000000cULL, 0x000040f0003f0101ULL,
0x0001b6280000000bULL, 0x00004110003f0101ULL, 0x0001b62c0000000bULL, 0x000042e0003f0105ULL,
0x0001b62c0000000bULL, 0x00004e20003f0105ULL, 0x000000000000000eULL, 0x00005a60003f0101ULL,
0x0001b64800000004ULL, 0x00005a80003f0101ULL, 0x0001b64c00000004ULL, 0x00005c50003f0105ULL,
0x0001b64c00000004ULL, 0x00006800003f0105ULL, 0x000000000000000cULL, 0x00007480003f0101ULL,
0x0001b6680000000aULL, 0x000074a0003f0101ULL, 0x0001b66c0000000aULL, 0x00007670003f0105ULL,
0x0001b66c0000000aULL, 0x00008140003f0105ULL, 0x0000000000000004ULL, 0x0000bcf0003f0101ULL,
0x0001b600000000ffULL, 0x0000d520003f0101ULL, 0x0001b604000000ffULL, 0x0000d6f0003f0105ULL,
0x0001b604000000ffULL, 0x00011730003f0105ULL, 0x000000000000006fULL, 0x00011870003f0101ULL,
0x000000040000006fULL, 0x00011a40003f0105ULL, 0x000000040000006fULL, 0x00013df0003f0105ULL,
0x0001b60800000071ULL, 0x00013e50003f0101ULL, 0x0001b61000000071ULL, 0x00013eb0003f0101ULL,
0x0001b61800000071ULL, 0x00013f20003f0101ULL, 0x0001b62000000071ULL, 0x00033803003f0101ULL,
0x0000b67000201c04ULL, 0x0000b8800000b6a0ULL, 0x0000bb700000b9e0ULL, 0x0000d7500000bc70ULL,
0x0000040100013f60ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000036cULL, 0x0000001800000002ULL,
0x000000000000029cULL, 0x0000001800000002ULL, 0x00000000000001dcULL, 0x0000001800000002ULL,
0x000000000000011cULL, 0x0000001800000002ULL, 0x0000000000000044ULL, 0x0000001800000002ULL,
0x0000000000000343ULL, 0x0000001800000002ULL, 0x0000000000000273ULL, 0x0000001800000002ULL,
0x00000000000001b3ULL, 0x0000001800000002ULL, 0x00000000000000f3ULL, 0x0000001800000002ULL,
0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0d7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000097919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000d767a19ULL, 0x000fe200000006ffULL,
0x00000000000579c3ULL, 0x000f220000002500ULL, 0x0000000000077919ULL, 0x000ea20000002100ULL,
0x0000460000087ab9ULL, 0x000fc60000000a00ULL, 0x00000000000c7919ULL, 0x000ea20000002700ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003757a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a75ULL, 0x0000040003007624ULL, 0x000fca00078e020dULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000175750810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000175751810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff75aa12ULL, 0x000fc800078e33ffULL,
0x0000007500007306ULL, 0x000e620000209000ULL, 0x000000ff7500720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000375047224ULL, 0x004fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x0000000000047919ULL, 0x000ee40000002200ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000000603737227ULL, 0x000fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a73ULL,
0x0000000075007224ULL, 0x000fca00078e0206ULL, 0x000000750000720cULL, 0x000fe20003f06070ULL,
0x0000010009027a24ULL, 0x008fe400078e0204ULL, 0x00001fff09097589ULL, 0x000fe400000e0000ULL,
0x00000000020b7a24ULL, 0x000fca00078e0207ULL, 0x000000ff0b00720cULL, 0x000fc60003f65270ULL,
0x0000000100000824ULL, 0x000fe200078e0a75ULL, 0x0000000173730810ULL, 0x000fe40007ffe0ffULL,
0x0000000f0b00780cULL, 0x040fe40003f84070ULL, 0x000000750000720cULL, 0x000fe40003f26070ULL,
0x000000030b00780cULL, 0x000fc60003f04070ULL, 0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03b424ULL, 0x000fc800078e00ffULL, 0x3fffffc0ff04c424ULL, 0x000fe400078e00ffULL,
0x0000000173731810ULL, 0x000fe20007ffe0ffULL, 0x7fffffc0ff05c424ULL, 0x000fe200078e00ffULL,
0x00000075ff73a212ULL, 0x000fe200078e33ffULL, 0x01b60002ff00b388ULL, 0x0003e20000000a00ULL,
0x0000007f0b00780cULL, 0x000fc60003f24070ULL, 0x000000ffff007224ULL, 0x000fe200078e0a73ULL,
0x01b608040b00c388ULL, 0x000fe60000008a00ULL, 0x0000000075757224ULL, 0x000fe200078e0206ULL,
0x00000005ff007819ULL, 0x000fe20000011607ULL, 0x3fffff60ff068424ULL, 0x000fe400078e00ffULL,
0x00000010756b7824ULL, 0x000fe400078e00ffULL, 0x7fffff60ff078424ULL, 0x000fe200078e00ffULL,
0x00001fff00007589ULL, 0x000ea200000e0000ULL, 0xff317217ff089424ULL, 0x000fe200078e00ffULL,
0x000000046b027c10ULL, 0x042fe2000fffe1ffULL, 0x000058000c037a24ULL, 0x000fe200078e02ffULL,
0x01b688060b008388ULL, 0x000fe20000008a00ULL, 0x000000046b007c0cULL, 0x000fc4000bf03070ULL,
0x0000001002027817ULL, 0x000fe20003800000ULL, 0x01b400080b009388ULL, 0x000fe60000004800ULL,
0x000000ff02747207ULL, 0x000fe40000000000ULL, 0x00005a0073027a19ULL, 0x000fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000107400780cULL, 0x000fe20003f05270ULL,
0x0000007603047224ULL, 0x000fc400078e0202ULL, 0x00000005ff027e24ULL, 0x010fe4000f8e00ffULL,
0x0000000409057824ULL, 0x004fc800078e0200ULL, 0x0000000205057824ULL, 0x000fc800078e00ffULL,
0x000001d000008947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00000004ff087819ULL, 0x002fca0000011603ULL,
0x00000001050a7824ULL, 0x000fc800078e0208ULL, 0x000000016b067824ULL, 0x000fca00078e020aULL,
0x00000004060b7c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff077a19ULL, 0x000fe20000011606ULL,
0x0000001003067824ULL, 0x000fe400078e00ffULL, 0x00000001040b7824ULL, 0x000fe200078e020bULL,
0x0000000574047217ULL, 0x000fc60007800000ULL, 0x00000076070b7224ULL, 0x000fe400078e020bULL,
0x0000000104077824ULL, 0x000fe400078e0a05ULL, 0x000001000b047825ULL, 0x000fe200078e00ffULL,
0x000000f0060b7812ULL, 0x000fe400078ec0ffULL, 0x000000070800720cULL, 0x000fe20003f06070ULL,
0x000000010a077824ULL, 0x000fe200078e0203ULL, 0x0000000b040b7212ULL, 0x000fe200078efcffULL,
0x000000100a0a7824ULL, 0x000fc600078e00ffULL, 0x00005e000b047a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00a077812ULL, 0x000fe400078ee207ULL, 0x00005f0005057a10ULL, 0x000fc60000ffe4ffULL,
0x0000001007077824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000c101c48ULL, 0x0000018000007947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x0000000503087211ULL, 0x042fe200078fe0ffULL, 0x0000001003067824ULL, 0x000fc800078e00ffULL,
0x000000016b057824ULL, 0x000fe200078e0208ULL, 0x000000f0060b7812ULL, 0x000fc800078ec0ffULL,
0x0000000405077c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff057a19ULL, 0x000fc60000011605ULL,
0x0000000104077824ULL, 0x000fc800078e0207ULL, 0x0000007605057224ULL, 0x000fe400078e0207ULL,
0x0000000108077824ULL, 0x000fe400078e0203ULL, 0x0000010005047825ULL, 0x000fc800078e00ffULL,
0x0000001008087824ULL, 0x000fe200078e00ffULL, 0x0000000b04047212ULL, 0x000fc800078efcffULL,
0xfffffff008077812ULL, 0x000fe400078ee207ULL, 0x00005e0004047a10ULL, 0x000fc60007f1e0ffULL,
0x0000001007077824ULL, 0x000fe200078e00ffULL, 0x00005f0005057a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000b901c48ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x0000000000047806ULL, 0x002fe200038e0000ULL,
0x00000004ff6d7424ULL, 0x000fc600078e00ffULL, 0x0000000400057300ULL, 0x000ea200000e0000ULL,
0x000064000c6c7625ULL, 0x000fce00078e006dULL, 0x0000000400077309ULL, 0x000e620000000000ULL,
0x000000080500720cULL, 0x004fe20003f02070ULL, 0x000000ffff057224ULL, 0x002fe400078e0a07ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x01b60405ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000086c6c7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0900720cULL, 0x000fc40003f05270ULL,
0x000000ff6c5e7810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff5e7819ULL, 0x000fce000001165eULL,
0x0000b29000008947ULL, 0x000fea0003800000ULL, 0x000000020c047824ULL, 0x000fe400078e00ffULL,
0x0000000800717824ULL, 0x000fe400078e00ffULL, 0x00000003ff087424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b68c0871ff738cULL, 0x0005e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000102057810ULL, 0x002fe20007ffe0ffULL,
0x0000590004047624ULL, 0x000fe200078e020dULL, 0x00000001ff0b7819ULL, 0x000fe20000011600ULL,
0x01b6880071ff7f8cULL, 0x0003e2000c80043fULL, 0x0000005e0500720cULL, 0x000fe20003f06070ULL,
0x00000001736b7824ULL, 0x000fe200078e0204ULL, 0x0000000100667812ULL, 0x000fe200078ec0ffULL,
0x000000200b707824ULL, 0x000fc800078e00ffULL, 0x0000010002057824ULL, 0x000fc800078e0270ULL,
0x000066006b1f7a24ULL, 0x000fe400078e0205ULL, 0x0000064000008947ULL, 0x000fea0003800000ULL,
0x00000003ff147819ULL, 0x002fe20000011603ULL, 0x000000020b177824ULL, 0x000fe200078e0266ULL,
0x000000056c047217ULL, 0x000fe40007800000ULL, 0x0000000414087810ULL, 0x044fe40007ffe0ffULL,
0x00000008140c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000104047824ULL, 0x000fe200078e0a05ULL,
0x0000000c140d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000108057824ULL, 0x100fe200078e0203ULL,
0x0000001014127810ULL, 0x000fe20007ffe0ffULL, 0x0000000808187824ULL, 0x000fe200078e00ffULL,
0x00000020040a7817ULL, 0x000fe20003800000ULL, 0x000000010c077824ULL, 0x000fe200078e0203ULL,
0x0000001414157810ULL, 0x000fe20007ffe0ffULL, 0x000000080c1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee205ULL, 0x000000010d097824ULL, 0x040fe200078e0203ULL,
0x0000007006057812ULL, 0x000fe200078ec0ffULL, 0x000000080d1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee207ULL, 0x000000011f077824ULL, 0x040fe200078e0214ULL,
0x0000000a0800720cULL, 0x080fe20003f86070ULL, 0x0000008066047824ULL, 0x000fe200078e0205ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000000a0c00720cULL, 0x080fe20003f66070ULL, 0x000000011f097824ULL, 0x000fe200078e0208ULL,
0x0000000a0d00720cULL, 0x000fe20003f46070ULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x0001300017177811ULL, 0x000fc400078e68ffULL, 0x0000000a1400720cULL, 0x000fe20003fa6070ULL,
0x00000001120f7824ULL, 0x000fe200078e0203ULL, 0x00006200060e7a10ULL, 0x000fe20007f1e0ffULL,
0x00000008121e7824ULL, 0x000fe400078e00ffULL, 0x0000010009087825ULL, 0x000fc600078e0004ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20fULL, 0x0000000115117824ULL, 0x140fe200078e0203ULL,
0x0000620008107a10ULL, 0x000fe20007f3e0ffULL, 0x0000000815207824ULL, 0x000fe200078e00ffULL,
0x00006300070f7a10ULL, 0x000fe200007fe4ffULL, 0x000000011f077824ULL, 0x000fe400078e020cULL,
0x00000001140c7824ULL, 0x000fe200078e0203ULL, 0xfffffff820207812ULL, 0x000fe200078ee211ULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x0000630009117a10ULL, 0x000fc40000ffe4ffULL,
0x0000000a1200720cULL, 0x000fe20003f26070ULL, 0x000000011f097824ULL, 0x040fe200078e020dULL,
0x000000070c167812ULL, 0x000fe200078ec0ffULL, 0x000000011f0d7824ULL, 0x000fe200078e0212ULL,
0x0000620006127a10ULL, 0x000fe20007f1e0ffULL, 0x0000010009087825ULL, 0x000fe200078e0004ULL,
0x0ffffff816167812ULL, 0x000fe400078ef803ULL, 0x0000630007137a10ULL, 0x000fe200007fe4ffULL,
0x000001000d0c7825ULL, 0x000fe200078e0004ULL, 0x0000620008087a10ULL, 0x000fc40007fde0ffULL,
0x0000000a1500720cULL, 0x080fe20003f06070ULL, 0x000000011f077824ULL, 0x000fe200078e0215ULL,
0x0000630009097a10ULL, 0x000fe200037fe4ffULL, 0x0000001016197824ULL, 0x000fe200078e0217ULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x0000001814167810ULL, 0x000fe40007ffe0ffULL, 0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x00000010181b7824ULL, 0x000fe200078e0217ULL, 0x0000001c14187810ULL, 0x000fe20007ffe0ffULL,
0x000000011f1d7824ULL, 0x040fe200078e0216ULL, 0x0000620006147a10ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e197faeULL, 0x0003e2000e901c48ULL,
0x0000000a1600720cULL, 0x080fe20003fa6070ULL, 0x000000011f1f7824ULL, 0x000fe200078e0218ULL,
0x0000630007157a10ULL, 0x000fe200037fe4ffULL, 0x000001001d067825ULL, 0x000fe200078e0004ULL,
0x00000000101b7faeULL, 0x0005e2000e101c48ULL, 0x0000000a1800720cULL, 0x000fc40003f86070ULL,
0x00000001160a7824ULL, 0x000fe200078e0203ULL, 0x0000620006067a10ULL, 0x000fe20007fde0ffULL,
0x000001001f047825ULL, 0x000fc600078e0004ULL, 0x0000630007077a10ULL, 0x000fe200037fe4ffULL,
0x00000008160f7824ULL, 0x002fe200078e00ffULL, 0x0000620004047a10ULL, 0x000fe20007fde0ffULL,
0x00000001180e7824ULL, 0x040fe400078e0203ULL, 0x0000000818117824ULL, 0x004fe200078e00ffULL,
0xfffffff80f0a7812ULL, 0x000fe200078ee20aULL, 0x000000101a0f7824ULL, 0x100fe200078e0217ULL,
0x0000630005057a10ULL, 0x000fe200037fe4ffULL, 0x000000101e197824ULL, 0x100fe200078e0217ULL,
0xfffffff8110e7812ULL, 0x000fe200078ee20eULL, 0x000000101c117824ULL, 0x100fe200078e0217ULL,
0x00000000120f7faeULL, 0x0003e2000d901c48ULL, 0x00000010201b7824ULL, 0x000fc400078e0217ULL,
0x000000100a1d7824ULL, 0x100fe200078e0217ULL, 0x0000000008117faeULL, 0x0003e2000d101c48ULL,
0x000000100e177824ULL, 0x000fc600078e0217ULL, 0x000000000c197faeULL, 0x0003e8000c901c48ULL,
0x00000000141b7faeULL, 0x0003e8000c101c48ULL, 0x00000000061d7faeULL, 0x0003e8000e901c48ULL,
0x0000000004177faeULL, 0x0003e2000e101c48ULL, 0x0000057000007947ULL, 0x000fea0003800000ULL,
0x0000000403087811ULL, 0x006fe200078fe8ffULL, 0x000000020b197824ULL, 0x000fe200078e0266ULL,
0x00000008030a7811ULL, 0x000fc400078fe8ffULL, 0x0000001403107811ULL, 0x040fe200078fe8ffULL,
0x0000000108047824ULL, 0x140fe200078e0203ULL, 0x0000000c030c7811ULL, 0x040fe200078fe8ffULL,
0x0000000808077824ULL, 0x000fe200078e00ffULL, 0x00000010030e7811ULL, 0x000fe200078fe8ffULL,
0x000000010a057824ULL, 0x100fe200078e0203ULL, 0x0000007006157812ULL, 0x000fe200078ec0ffULL,
0x000000080a187824ULL, 0x000fe200078e00ffULL, 0xfffffff807167812ULL, 0x000fe200078ee204ULL,
0x0000000110077824ULL, 0x140fe200078e0203ULL, 0x0000001c03067811ULL, 0x040fe200078fe8ffULL,
0x00000008101e7824ULL, 0x000fe200078e00ffULL, 0x0000001803127811ULL, 0x000fe200078fe8ffULL,
0x000000010c047824ULL, 0x000fe200078e0203ULL, 0xfffffff818187812ULL, 0x000fe200078ee205ULL,
0x000000080c0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee207ULL,
0x000000010e057824ULL, 0x040fe200078e0203ULL, 0x0001300019257811ULL, 0x000fe200078e68ffULL,
0x000000080e1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d1a7812ULL, 0x000fe200078ee204ULL,
0x0000008066147824ULL, 0x000fe200078e0215ULL, 0x0000000303047211ULL, 0x000fe200078fe8ffULL,
0x000000011f077824ULL, 0x000fe200078e0208ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee205ULL,
0x0000000106087824ULL, 0x100fe200078e0203ULL, 0x0000000704047812ULL, 0x000fe200078ec0ffULL,
0x0000000806157824ULL, 0x000fe200078e00ffULL, 0x0000001f03057211ULL, 0x000fe200078fe8ffULL,
0x0000000112097824ULL, 0x000fc400078e0203ULL, 0x0000000812207824ULL, 0x000fe200078e00ffULL,
0xfffffff815227812ULL, 0x000fe200078ee208ULL, 0x000000ffff157224ULL, 0x000fe400078e00ffULL,
0x000000011f0d7824ULL, 0x040fe200078e020cULL, 0xfffffff820207812ULL, 0x000fe200078ee209ULL,
0x000000011f097824ULL, 0x040fe200078e020aULL, 0x0ffffff8040a7812ULL, 0x000fe200078ef803ULL,
0x000000011f177824ULL, 0x000fe400078e0206ULL, 0x0000010005047825ULL, 0x000fc800078e0014ULL,
0x000000011f0f7824ULL, 0x000fe200078e020eULL, 0x0000620004047a10ULL, 0x000fe20007f1e0ffULL,
0x0000010007067825ULL, 0x000fc600078e0014ULL, 0x0000630005057a10ULL, 0x000fe200007fe4ffULL,
0x000000011f117824ULL, 0x000fe200078e0210ULL, 0x0000620006067a10ULL, 0x000fe20007f3e0ffULL,
0x0000010009087825ULL, 0x000fc600078e0014ULL, 0x0000630007077a10ULL, 0x000fe20000ffe4ffULL,
0x000000011f137824ULL, 0x000fe200078e0212ULL, 0x0000620008087a10ULL, 0x000fe20007f5e0ffULL,
0x000001000d0c7825ULL, 0x000fc600078e0014ULL, 0x0000630009097a10ULL, 0x000fe200017fe4ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0014ULL, 0x000062000c0c7a10ULL, 0x000fc60007f7e0ffULL,
0x0000010011107825ULL, 0x100fe200078e0014ULL, 0x000062000e0e7a10ULL, 0x000fe40007f1e0ffULL,
0x000063000d0d7a10ULL, 0x000fe20001ffe4ffULL, 0x0000010013127825ULL, 0x100fe200078e0014ULL,
0x0000620010107a10ULL, 0x000fe40007f3e0ffULL, 0x000063000f0f7a10ULL, 0x000fe200007fe4ffULL,
0x0000010017147825ULL, 0x000fe200078e0014ULL, 0x0000620012127a10ULL, 0x000fe40007f5e0ffULL,
0x0000630011117a10ULL, 0x000fe20000ffe4ffULL, 0x000000100a177824ULL, 0x100fe200078e0225ULL,
0x0000620014147a10ULL, 0x000fe20007f7e0ffULL, 0x0000001016197824ULL, 0x100fe200078e0225ULL,
0x0000630013137a10ULL, 0x000fe200017fe4ffULL, 0x00000010181b7824ULL, 0x100fe200078e0225ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004177faeULL, 0x0003e2000b901c48ULL,
0x000000101a1d7824ULL, 0x100fe200078e0225ULL, 0x0000630015157a10ULL, 0x000fe20001ffe4ffULL,
0x000000101c1f7824ULL, 0x100fe200078e0225ULL, 0x0000000006197faeULL, 0x0003e2000b901c48ULL,
0x000000101e217824ULL, 0x000fc400078e0225ULL, 0x0000001020237824ULL, 0x100fe200078e0225ULL,
0x00000000081b7faeULL, 0x0003e2000b901c48ULL, 0x0000001022257824ULL, 0x000fc600078e0225ULL,
0x000000000c1d7faeULL, 0x0003e8000b901c48ULL, 0x000000000e1f7faeULL, 0x0003e8000b901c48ULL,
0x0000000010217faeULL, 0x0003e8000b901c48ULL, 0x0000000012237faeULL, 0x0003e8000b901c48ULL,
0x0000000014257faeULL, 0x0003e4000b901c48ULL, 0x0000005e0200720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff087424ULL, 0x002fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000693000000947ULL, 0x000fea0003800000ULL,
0xff317217ff087424ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fc400078e00ffULL,
0x0000000102097810ULL, 0x040fe20007ffe0ffULL, 0x0000010002047824ULL, 0x000fe200078e0270ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000005e0900720cULL, 0x000fe40003f06070ULL,
0x0000004004307810ULL, 0x020fca0007ffe0ffULL, 0x000066006b367a24ULL, 0x000fcc00078e0230ULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000003ff3f7819ULL, 0x100fe20000011603ULL,
0x000000020b3c7824ULL, 0x000fe200078e0266ULL, 0x000000306c097217ULL, 0x000fe40007800000ULL,
0x000000043f317810ULL, 0x040fe40007ffe0ffULL, 0x000000083f357810ULL, 0x000fe20007ffe0ffULL,
0x0000000109307824ULL, 0x000fe200078e0a30ULL, 0x0000000c3f397810ULL, 0x000fe20007ffe0ffULL,
0x00000001310c7824ULL, 0x100fe200078e0203ULL, 0x000000103f417810ULL, 0x000fe20007ffe0ffULL,
0x00000008313d7824ULL, 0x000fe200078e00ffULL, 0x000000143f457810ULL, 0x000fe20007ffe0ffULL,
0x0000001003097824ULL, 0x000fe200078e00ffULL, 0x00000020303a7817ULL, 0x000fe20003800000ULL,
0x00000008350f7824ULL, 0x000fe200078e00ffULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee20cULL,
0x00000001350c7824ULL, 0x100fe200078e0203ULL, 0x00000070090d7812ULL, 0x000fe200078ec0ffULL,
0x0000000139377824ULL, 0x000fe200078e0203ULL, 0x0000003a3100720cULL, 0x080fe20003f86070ULL,
0x00000008390e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f097812ULL, 0x000fe200078ee20cULL,
0x00000080660c7824ULL, 0x000fe200078e020dULL, 0x0000003a3f00720cULL, 0x0c0fe20003f66070ULL,
0x000000013f0f7824ULL, 0x000fe200078e0236ULL, 0xfffffff80e377812ULL, 0x000fe200078ee237ULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x0000003a3900720cULL, 0x000fe20003f26070ULL,
0x0000000141337824ULL, 0x000fe200078e0203ULL, 0x000140003c3c7811ULL, 0x000fe200078e68ffULL,
0x000001000f0e7825ULL, 0x000fe200078e000cULL, 0x000000183f497810ULL, 0x000fc40007ffe0ffULL,
0x0000001c3f4b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000841387824ULL, 0x000fe200078e00ffULL,
0x000062000e327a10ULL, 0x000fe20007f1e0ffULL, 0x0000000145347824ULL, 0x040fe400078e0203ULL,
0x0000000845477824ULL, 0x000fe200078e00ffULL, 0xfffffff838437812ULL, 0x000fe200078ee233ULL,
0x000000013f387824ULL, 0x000fe200078e0203ULL, 0x000063000f337a10ULL, 0x000fe200007fe4ffULL,
0x00000001310f7824ULL, 0x100fe200078e0236ULL, 0x0000003a3500720cULL, 0x040fe20003f06070ULL,
0x0000000135317824ULL, 0x000fe200078e0236ULL, 0xfffffff847477812ULL, 0x000fe200078ee234ULL,
0x0000000139357824ULL, 0x000fe200078e0236ULL, 0x00000007383e7812ULL, 0x000fe200078ec0ffULL,
0x000001000f0e7825ULL, 0x000fc600078e000cULL, 0x0ffffff83e3b7812ULL, 0x000fe200078ef803ULL,
0x0000010031307825ULL, 0x000fe200078e000cULL, 0x000062000e387a10ULL, 0x000fc60007f5e0ffULL,
0x0000010035347825ULL, 0x000fe200078e000cULL, 0x00006200300e7a10ULL, 0x000fe40007fbe0ffULL,
0x000063000f397a10ULL, 0x000fe200017fe4ffULL, 0x000000103b3b7824ULL, 0x000fe200078e023cULL,
0x0000620034307a10ULL, 0x000fe20007fde0ffULL, 0x00000001453f7824ULL, 0x000fe200078e0236ULL,
0x00006300310f7a10ULL, 0x000fe20002ffe4ffULL, 0x000000103d3d7824ULL, 0x000fe200078e023cULL,
0x0000630035317a10ULL, 0x000fe200037fe4ffULL, 0x0000000141357824ULL, 0x140fe200078e0236ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000323b7faeULL, 0x0003e2000d901c48ULL,
0x0000003a4100720cULL, 0x080fe20003f46070ULL, 0x0000000149417824ULL, 0x000fe200078e0236ULL,
0x0000003a4500720cULL, 0x080fe20003fa6070ULL, 0x0000010035347825ULL, 0x000fe200078e000cULL,
0x00000000383d7faeULL, 0x0005e2000e101c48ULL, 0x0000003a4900720cULL, 0x000fc40003f86070ULL,
0x0000003a4b00720cULL, 0x040fe20003f66070ULL, 0x000000014b3a7824ULL, 0x000fe200078e0203ULL,
0x0000620034347a10ULL, 0x000fe20007fde0ffULL, 0x0000001009097824ULL, 0x000fe400078e023cULL,
0x000001003f327825ULL, 0x102fe200078e000cULL, 0x0000630035357a10ULL, 0x000fe400037fe4ffULL,
0x000000000e097faeULL, 0x0003e2000c101c48ULL, 0x0000010041387825ULL, 0x004fe200078e000cULL,
0x0000620032327a10ULL, 0x000fc60007fde0ffULL, 0x000000014b3b7824ULL, 0x000fe200078e0236ULL,
0x0000630033337a10ULL, 0x000fe200037fe4ffULL, 0x0000000149367824ULL, 0x040fe200078e0203ULL,
0x0000620038387a10ULL, 0x000fe20007fde0ffULL, 0x00000008493f7824ULL, 0x000fe400078e00ffULL,
0x000000084b417824ULL, 0x000fe200078e00ffULL, 0x0000630039397a10ULL, 0x000fe200037fe4ffULL,
0x000001003b0c7825ULL, 0x000fe200078e000cULL, 0xfffffff83f3f7812ULL, 0x000fe400078ee236ULL,
0xfffffff841417812ULL, 0x000fe200078ee23aULL, 0x0000001037377824ULL, 0x100fe200078e023cULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x00000010433b7824ULL, 0x000fc400078e023cULL,
0x00000010473d7824ULL, 0x100fe200078e023cULL, 0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x000000103f3f7824ULL, 0x100fe200078e023cULL, 0x0000000030377faeULL, 0x0003e2000c901c48ULL,
0x0000001041417824ULL, 0x000fc600078e023cULL, 0x00000000343b7faeULL, 0x0003e8000d101c48ULL,
0x00000000323d7faeULL, 0x0003e8000e901c48ULL, 0x00000000383f7faeULL, 0x0003e8000e101c48ULL,
0x000000000c417faeULL, 0x0003e2000d901c48ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x0000000803337811ULL, 0x040fe400078fe8ffULL, 0x0000000403317811ULL, 0x000fc400078fe8ffULL,
0x0000000c03357811ULL, 0x000fe200078fe8ffULL, 0x00000001330c7824ULL, 0x100fe200078e0203ULL,
0x0000001403397811ULL, 0x000fe200078fe8ffULL, 0x00000008333f7824ULL, 0x000fe200078e00ffULL,
0x0000001003377811ULL, 0x000fe200078fe8ffULL, 0x0000000131097824ULL, 0x100fe200078e0203ULL,
0x00000018033b7811ULL, 0x000fe200078fe8ffULL, 0x00000008310e7824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee20cULL, 0x00000001350d7824ULL, 0x000fe200078e0203ULL,
0x0000001c03497811ULL, 0x000fe200078fe8ffULL, 0x0000000835307824ULL, 0x000fe200078e00ffULL,
0xfffffff80e3d7812ULL, 0x000fe200078ee209ULL, 0x00000001390c7824ULL, 0x000fe200078e0203ULL,
0x00000036030f7211ULL, 0x000fe200078fe8ffULL, 0x0000000839457824ULL, 0x000fe200078e00ffULL,
0xfffffff830417812ULL, 0x000fe200078ee20dULL, 0x0000000137097824ULL, 0x000fc400078e0203ULL,
0x00000008370e7824ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ee20cULL,
0x000000013b0d7824ULL, 0x000fe200078e0203ULL, 0x00000003030c7211ULL, 0x000fe200078fe8ffULL,
0x000000083b307824ULL, 0x000fe200078e00ffULL, 0xfffffff80e437812ULL, 0x000fe200078ee209ULL,
0x00000001490e7824ULL, 0x040fe200078e0203ULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x00000008494b7824ULL, 0x000fe200078e00ffULL, 0xfffffff830477812ULL, 0x000fe200078ee20dULL,
0x0000001003097824ULL, 0x000fc400078e00ffULL, 0x000000020b0d7824ULL, 0x000fe200078e0266ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee20eULL, 0x0000000131317824ULL, 0x100fe200078e0236ULL,
0x0000007009097812ULL, 0x000fe200078ec0ffULL, 0x0000000133337824ULL, 0x100fe200078e0236ULL,
0x000140000d0e7811ULL, 0x000fe200078e68ffULL, 0x0000000135357824ULL, 0x000fe200078e0236ULL,
0x0ffffff80c0d7812ULL, 0x000fe200078ef803ULL, 0x00000080660c7824ULL, 0x000fe400078e0209ULL,
0x000000103d3d7824ULL, 0x000fc400078e020eULL, 0x000000100d097824ULL, 0x100fe400078e020eULL,
0x000000ffff0d7224ULL, 0x000fe400078e00ffULL, 0x000000103f3f7824ULL, 0x100fe400078e020eULL,
0x0000001041417824ULL, 0x100fe400078e020eULL, 0x0000001043437824ULL, 0x100fe400078e020eULL,
0x0000001045457824ULL, 0x000fc400078e020eULL, 0x0000001047477824ULL, 0x100fe400078e020eULL,
0x000000104b4b7824ULL, 0x000fe400078e020eULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x0000000137377824ULL, 0x000fe200078e0236ULL, 0x000062000e0e7a10ULL, 0x000fe20007f1e0ffULL,
0x0000010031307825ULL, 0x000fc600078e000cULL, 0x000063000f0f7a10ULL, 0x000fe200007fe4ffULL,
0x0000000139397824ULL, 0x000fe200078e0236ULL, 0x0000620030307a10ULL, 0x000fe20007f3e0ffULL,
0x0000010033327825ULL, 0x000fe400078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e097faeULL, 0x0003e2000b901c48ULL, 0x0000630031317a10ULL, 0x000fe20000ffe4ffULL,
0x000000013b3b7824ULL, 0x000fe200078e0236ULL, 0x0000620032327a10ULL, 0x000fe20007f5e0ffULL,
0x0000010035347825ULL, 0x000fe400078e000cULL, 0x00000000303d7faeULL, 0x0003e2000b901c48ULL,
0x0000630033337a10ULL, 0x000fe200017fe4ffULL, 0x0000000149497824ULL, 0x000fe200078e0236ULL,
0x0000620034347a10ULL, 0x000fe20007f7e0ffULL, 0x0000010037367825ULL, 0x000fc400078e000cULL,
0x00000000323f7faeULL, 0x0003e2000b901c48ULL, 0x0000630035357a10ULL, 0x000fe20001ffe4ffULL,
0x0000010039387825ULL, 0x000fe200078e000cULL, 0x0000620036367a10ULL, 0x000fc60007f1e0ffULL,
0x000001003b3a7825ULL, 0x100fe200078e000cULL, 0x0000620038387a10ULL, 0x000fe20007f3e0ffULL,
0x0000000034417faeULL, 0x0003e2000b901c48ULL, 0x0000630037377a10ULL, 0x000fe200007fe4ffULL,
0x00000100490c7825ULL, 0x000fe200078e000cULL, 0x000062003a3a7a10ULL, 0x000fe40007f5e0ffULL,
0x0000630039397a10ULL, 0x000fe20000ffe4ffULL, 0x0000000036437faeULL, 0x0003e2000b901c48ULL,
0x000062000c0c7a10ULL, 0x000fe40007f7e0ffULL, 0x000063003b3b7a10ULL, 0x000fe200017fe4ffULL,
0x0000000038457faeULL, 0x0003e2000b901c48ULL, 0x000063000d0d7a10ULL, 0x000fc60001ffe4ffULL,
0x000000003a477faeULL, 0x0003e8000b901c48ULL, 0x000000000c4b7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe071097812ULL, 0x042fe400078ec0ffULL,
0x00000010710c7812ULL, 0x000fca00078ec0ffULL, 0x0000000109097824ULL, 0x000fc800078e020cULL,
0x0000000866307824ULL, 0x000fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6080030307f8cULL, 0x000e64000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x00000008710e7812ULL, 0x000fca00078ec0ffULL, 0x0000000109097824ULL, 0x000fca00078e020eULL,
0x01b60c00090f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x006fe40007804831ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c337210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09003300780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403300780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000330e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000132327810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b60c00090f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010036f7824ULL, 0x000fe200078e00ffULL, 0x00000001ff727819ULL, 0x000fe20000011603ULL,
0x0000002000097824ULL, 0x000fc600078e00ffULL, 0x000000706f6f7812ULL, 0x000fe400078ec0ffULL,
0xffffff8009097812ULL, 0x000fe400078ec0ffULL, 0x0000000c72727812ULL, 0x000fc800078ec0ffULL,
0x0000000972097210ULL, 0x000fca0007ffe06fULL, 0x01b00000090d7984ULL, 0x000e680000000800ULL,
0x01b2000009327984ULL, 0x0004e20000000800ULL, 0x000000080d00720bULL, 0x002fe20003f1d000ULL,
0x000117227f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0c347812ULL, 0x000fe2000782c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff097224ULL, 0x000fd400078e0008ULL,
0x0000044000009947ULL, 0x000fea0003800000ULL, 0x00000002ff097819ULL, 0x000fe40000011600ULL,
0x000000080d00720bULL, 0x000fe40003f54000ULL, 0x000000000900720cULL, 0x000fe20003f25270ULL,
0x000116d27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000337806ULL, 0x000fc400010e0100ULL,
0x00000080000f9824ULL, 0x000fe200078e026fULL, 0x000000080d097209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x00009910330e7816ULL, 0x000fe200000000ffULL,
0x00000001720c9824ULL, 0x000fca00078e020fULL, 0x01b400090c009388ULL, 0x0003e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f25270ULL, 0x0000030000009947ULL, 0x000fea0003800000ULL,
0x0000000809087221ULL, 0x002fe20000010100ULL, 0x000000ff33ff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL,
0x0000000800357308ULL, 0x000e640000000800ULL, 0x000000350a0a7220ULL, 0x002fc80000410000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011603ULL,
0x000116127f007947ULL, 0x000fea000b800000ULL, 0x00001f0c350c7589ULL, 0x0002a400000e0000ULL,
0x0000000c2c2c7220ULL, 0x084fe40000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000c28287220ULL, 0x080fe40000410000ULL, 0x0000000c29297220ULL, 0x080fe40000410000ULL,
0x0000000c10107220ULL, 0x080fe40000410000ULL, 0x0000000c11117220ULL, 0x000fc40000410000ULL,
0x0000000c14147220ULL, 0x080fe40000410000ULL, 0x0000000c15157220ULL, 0x080fe40000410000ULL,
0x0000000c18187220ULL, 0x080fe40000410000ULL, 0x0000000c19197220ULL, 0x080fe40000410000ULL,
0x0000000c1c1c7220ULL, 0x080fe40000410000ULL, 0x0000000c1d1d7220ULL, 0x000fc40000410000ULL,
0x0000000c20207220ULL, 0x080fe40000410000ULL, 0x0000000c21217220ULL, 0x080fe40000410000ULL,
0x0000000c24247220ULL, 0x080fe40000410000ULL, 0x0000000c25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0033ff7812ULL, 0x000fda000782c0ffULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000008030c7811ULL, 0x000fe200078ff0ffULL,
0x000115127f007947ULL, 0x000fea000b800000ULL, 0x00001f0c350c7589ULL, 0x00046400000e0000ULL,
0x0000000c2e2e7220ULL, 0x086fe40000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000c2a2a7220ULL, 0x080fe40000410000ULL, 0x0000000c2b2b7220ULL, 0x080fe40000410000ULL,
0x0000000c12127220ULL, 0x080fe40000410000ULL, 0x0000000c13137220ULL, 0x000fc40000410000ULL,
0x0000000c16167220ULL, 0x080fe40000410000ULL, 0x0000000c17177220ULL, 0x080fe40000410000ULL,
0x0000000c1a1a7220ULL, 0x080fe40000410000ULL, 0x0000000c1b1b7220ULL, 0x080fe40000410000ULL,
0x0000000c1e1e7220ULL, 0x080fe40000410000ULL, 0x0000000c1f1f7220ULL, 0x000fc40000410000ULL,
0x0000000c22227220ULL, 0x080fe40000410000ULL, 0x0000000c23237220ULL, 0x080fe40000410000ULL,
0x0000000c26267220ULL, 0x080fe40000410000ULL, 0x0000000c27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff34ff7812ULL, 0x000fda0007826033ULL,
0x800000090d0d1221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b0d0d1820ULL, 0x000fc80000410000ULL, 0x0000000d00051308ULL, 0x000e640000000800ULL,
0x0000000532321220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x0000000a320a7221ULL, 0x008fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000005ff06723eULL, 0x000fe400000000ffULL, 0x00000002ff087819ULL, 0x000fe40000011603ULL,
0x00005410060d7816ULL, 0x000fe20000000006ULL, 0x000113627f007947ULL, 0x000fea000b800000ULL,
0x00001f080d067589ULL, 0x0002a400000e0000ULL, 0x00000008080c7810ULL, 0x000fe20007ffe0ffULL,
0x000113b27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0d077589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010080c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00002e30000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0001204000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000018080c7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000dULL,
0x00002ea0000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x00011fd000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff087819ULL, 0x102fe20000011603ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000007036d7812ULL, 0x040fe400078ec0ffULL,
0x00000008036e7812ULL, 0x000fe200078ec0ffULL, 0x000000040b0d7824ULL, 0x008fe200078e0208ULL,
0x000000086d0c7812ULL, 0x004fe200078ef803ULL, 0x0000020000087824ULL, 0x000fc800078e00ffULL,
0x000000010c0d7824ULL, 0x000fe200078e020dULL, 0xfffff80008317812ULL, 0x000fe200078ec0ffULL,
0x000000080c0e7824ULL, 0x000fca00078e00ffULL, 0xfffffff80e087812ULL, 0x000fca00078ee20dULL,
0x0000001008087824ULL, 0x000fc600078e0231ULL, 0x0000006d6e0e7212ULL, 0x040fe200078efcffULL,
0x000000020b5c7824ULL, 0x000fe200078e0266ULL, 0x011000000844783bULL, 0x000e620000000200ULL,
0x000000106e327812ULL, 0x000fe400078efe6dULL, 0x0000000e030f7211ULL, 0x000fe200078fe0ffULL,
0x000000080e307824ULL, 0x040fe200078e00ffULL, 0x000000020d0d7810ULL, 0x000fe20007ffe0ffULL,
0x000000080e337824ULL, 0x040fe200078e00ffULL, 0x000000040f627810ULL, 0x040fe20007ffe0ffULL,
0x000000080e647824ULL, 0x000fe200078e00ffULL, 0x000000060f657810ULL, 0x000fe20007ffe0ffULL,
0x000020005c5c7824ULL, 0x000fe200078e00ffULL, 0xfffffff833627812ULL, 0x000fe200078ee262ULL,
0x000000080e0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff864647812ULL, 0x000fe200078ee20fULL,
0x0000000832367824ULL, 0x000fe200078e00ffULL, 0x000130005c0b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000832617824ULL, 0x000fe200078e00ffULL, 0xfffffff80e657812ULL, 0x000fe200078ee265ULL,
0x0000000832387824ULL, 0x000fe200078e00ffULL, 0x000000020f637810ULL, 0x000fe20007ffe0ffULL,
0x0000001064507824ULL, 0x100fe200078e020bULL, 0x0000003203347211ULL, 0x000fe200078fe0ffULL,
0x00000010624c7824ULL, 0x000fe200078e020bULL, 0xfffffff830637812ULL, 0x000fe200078ee263ULL,
0x0000001065487824ULL, 0x100fe200078e020bULL, 0x00000004345f7810ULL, 0x000fe20007ffe0ffULL,
0x000000005050783bULL, 0x000ea20000004200ULL, 0x000000080c307824ULL, 0x000fe200078e00ffULL,
0x00000006345d7810ULL, 0x000fe20007ffe0ffULL, 0x00000010630c7824ULL, 0x000fe200078e020bULL,
0x000000004c4c783bULL, 0x000ee20000004200ULL, 0xfffffff861617812ULL, 0x000fe200078ee234ULL,
0x0000000832357824ULL, 0x000fe200078e00ffULL, 0xfffffff830307812ULL, 0x000fe200078ee20dULL,
0x000000004848783bULL, 0x000fe20000004200ULL, 0xfffffff8365f7812ULL, 0x000fe200078ee25fULL,
0x0000001061407824ULL, 0x000fe200078e020bULL, 0xfffffff8385d7812ULL, 0x000fe200078ee25dULL,
0x000000000c0c783bULL, 0x000fe20000004200ULL, 0x0000001030307824ULL, 0x000fe200078e0231ULL,
0x0000000234607810ULL, 0x000fe20007ffe0ffULL, 0x000000105f387824ULL, 0x100fe200078e020bULL,
0x000000004040783bULL, 0x000fe20000004200ULL, 0x000000105d347824ULL, 0x000fe200078e020bULL,
0xfffffff835607812ULL, 0x000fe200078ee260ULL, 0x0000000644440232ULL, 0x082fe20000000000ULL,
0x011000003030783bULL, 0x000e620000000200ULL, 0x0000000646460232ULL, 0x000fc40000000000ULL,
0x00000010603c7824ULL, 0x000fe200078e020bULL, 0x000000003838783bULL, 0x000f220000004200ULL,
0x0000000745450232ULL, 0x080fe40000000000ULL, 0x0000000747470232ULL, 0x000fe20000000000ULL,
0x000000003434783bULL, 0x000f280000004200ULL, 0x000000003c3c783bULL, 0x000f240000004200ULL,
0x00000050442c723cULL, 0x044f70000000182cULL, 0x000000524428723cULL, 0x040f700000001828ULL,
0x0000004c4418723cULL, 0x008f620000001818ULL, 0x0000000630300232ULL, 0x002fc40000000000ULL,
0x0000000632320232ULL, 0x000fca0000000000ULL, 0x0000004e441c723cULL, 0x000f62000000181cULL,
0x0000000731310232ULL, 0x080fe40000000000ULL, 0x0000000733330232ULL, 0x000fca0000000000ULL,
0x000000484420723cULL, 0x040f700000001820ULL, 0x0000004a4424723cULL, 0x040f700000001824ULL,
0x0000000c4410723cULL, 0x040f700000001810ULL, 0x0000000e440c723cULL, 0x000f700000001814ULL,
0x00000040302c723cULL, 0x060f70000000182cULL, 0x000000423028723cULL, 0x040f700000001828ULL,
0x000000383018723cULL, 0x050f700000001818ULL, 0x0000003a301c723cULL, 0x040f70000000181cULL,
0x000000343020723cULL, 0x040f700000001820ULL, 0x000000363024723cULL, 0x040f700000001824ULL,
0x0000003c3014723cULL, 0x040f700000001810ULL, 0x0000003e303c723cULL, 0x000b6e000000180cULL,
0x00000002000c7824ULL, 0x020fca00078e00ffULL, 0xfffffff80c0c7812ULL, 0x000fe200078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000001020f7810ULL, 0x000fe20007ffe0ffULL,
0x01b688000cff7f8cULL, 0x0003e2000c80043fULL, 0x00000080040d7810ULL, 0x000fe40007ffe0ffULL,
0x0000005e0f00720cULL, 0x000fc60003f06070ULL, 0x000066006b367a24ULL, 0x000fe200078e020dULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000061000008947ULL, 0x000fea0003800000ULL,
0x00000003ff377819ULL, 0x002fe40000011603ULL, 0x0000000d6c0c7217ULL, 0x000fe40007800000ULL,
0x0000000437117810ULL, 0x040fe40007ffe0ffULL, 0x0000000837137810ULL, 0x040fe20007ffe0ffULL,
0x000000010c0d7824ULL, 0x000fe200078e0a0dULL, 0x0000000c37357810ULL, 0x000fe20007ffe0ffULL,
0x00000001110e7824ULL, 0x000fe200078e0203ULL, 0x0000001037397810ULL, 0x000fe20007ffe0ffULL,
0x00000008110f7824ULL, 0x000fe200078e00ffULL, 0x000000200d427817ULL, 0x000fe20003800000ULL,
0x00000080660c7824ULL, 0x000fe200078e026fULL, 0x00000014373b7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0xfffffff80f447812ULL, 0x000fe200078ee20eULL,
0x00000001370f7824ULL, 0x100fe200078e0236ULL, 0x000000421100720cULL, 0x0c0fe20003f86070ULL,
0x0000000111117824ULL, 0x000fe200078e0236ULL, 0x000000423500720cULL, 0x080fe20003f46070ULL,
0x0000000113387824ULL, 0x040fe200078e0203ULL, 0x000000421300720cULL, 0x0c0fe20003f66070ULL,
0x0000000813317824ULL, 0x000fe200078e00ffULL, 0x000000423700720cULL, 0x000fe20003fa6070ULL,
0x000001000f0e7825ULL, 0x000fe200078e000cULL, 0x0000001837437810ULL, 0x000fc40007ffe0ffULL,
0xfffffff831387812ULL, 0x000fe200078ee238ULL, 0x0000010011107825ULL, 0x000fe200078e000cULL,
0x000062000e327a10ULL, 0x000fe40007f1e0ffULL, 0x0000001c37457810ULL, 0x000fe20007ffe0ffULL,
0x0000000135407824ULL, 0x140fe200078e0203ULL, 0x0000620010307a10ULL, 0x000fe20007f3e0ffULL,
0x0000000835317824ULL, 0x000fe400078e00ffULL, 0x00000001393a7824ULL, 0x140fe400078e0203ULL,
0x0000000839337824ULL, 0x000fe200078e00ffULL, 0xfffffff831407812ULL, 0x000fe200078ee240ULL,
0x00000001370e7824ULL, 0x100fe200078e0203ULL, 0x0000630011317a10ULL, 0x000fe20000ffe4ffULL,
0x0000000135117824ULL, 0x000fe200078e0236ULL, 0xfffffff8333a7812ULL, 0x000fe200078ee23aULL,
0x000000013b357824ULL, 0x000fe200078e0203ULL, 0x000063000f337a10ULL, 0x000fe200007fe4ffULL,
0x00000001130f7824ULL, 0x000fe200078e0236ULL, 0x000000070e347812ULL, 0x000fe200078ec0ffULL,
0x0000010011107825ULL, 0x000fe200078e000cULL, 0x000000423900720cULL, 0x000fc40003f26070ULL,
0x0ffffff834347812ULL, 0x000fe200078ef803ULL, 0x000001000f0e7825ULL, 0x000fe200078e000cULL,
0x0000620010107a10ULL, 0x000fc60007fde0ffULL, 0x000000083b467824ULL, 0x000fe200078e00ffULL,
0x000062000e0e7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000139137824ULL, 0x000fe200078e0236ULL,
0x0000630011117a10ULL, 0x000fe200037fe4ffULL, 0x0000001034397824ULL, 0x000fe200078e020bULL,
0xfffffff846467812ULL, 0x000fe200078ee235ULL, 0x0000010013127825ULL, 0x000fe200078e000cULL,
0x000063000f0f7a10ULL, 0x000fe400007fe4ffULL, 0x000000423b00720cULL, 0x040fe20003f06070ULL,
0x000000013b357824ULL, 0x000fe200078e0236ULL, 0x0000620012127a10ULL, 0x000fe20007fde0ffULL,
0x00000010443b7824ULL, 0x000fe200078e020bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032397faeULL, 0x0003e2000e901c48ULL, 0x0000010035347825ULL, 0x000fe200078e000cULL,
0x0000630013137a10ULL, 0x000fc400037fe4ffULL, 0x00000000303b7faeULL, 0x0005e2000e101c48ULL,
0x0000000143377824ULL, 0x100fe200078e0236ULL, 0x0000620034347a10ULL, 0x000fe20007fde0ffULL,
0x0000000145417824ULL, 0x000fe200078e0236ULL, 0x000000424300720cULL, 0x0c0fe20003fa6070ULL,
0x0000000143367824ULL, 0x000fe200078e0203ULL, 0x000000424500720cULL, 0x040fe20003f86070ULL,
0x0000000845427824ULL, 0x000fe200078e00ffULL, 0x0000630035357a10ULL, 0x000fe200037fe4ffULL,
0x0000010037327825ULL, 0x002fc800078e000cULL, 0x0000000145317824ULL, 0x004fe200078e0203ULL,
0x0000620032307a10ULL, 0x000fe20007fde0ffULL, 0x0000000843437824ULL, 0x000fe400078e00ffULL,
0x00000100410c7825ULL, 0x000fe200078e000cULL, 0xfffffff842327812ULL, 0x000fe400078ee231ULL,
0xfffffff843367812ULL, 0x000fe200078ee236ULL, 0x0000001040377824ULL, 0x100fe200078e020bULL,
0x0000630033317a10ULL, 0x000fe200037fe4ffULL, 0x0000001038337824ULL, 0x100fe200078e020bULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x000000103a397824ULL, 0x000fc400078e020bULL,
0x00000010463b7824ULL, 0x100fe200078e020bULL, 0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x0000001036417824ULL, 0x100fe200078e020bULL, 0x000000000e337faeULL, 0x0003e2000d901c48ULL,
0x00000010320b7824ULL, 0x000fc600078e020bULL, 0x0000000010377faeULL, 0x0003e8000d101c48ULL,
0x0000000012397faeULL, 0x0003e8000c901c48ULL, 0x00000000343b7faeULL, 0x0003e8000c101c48ULL,
0x0000000030417faeULL, 0x0003e8000e901c48ULL, 0x000000000c0b7faeULL, 0x0003e2000e101c48ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000000403337811ULL, 0x042fe400078fe8ffULL,
0x0000000803377811ULL, 0x000fc400078fe8ffULL, 0x0000001003137811ULL, 0x000fe200078fe8ffULL,
0x00000001330c7824ULL, 0x100fe200078e0203ULL, 0x0000000c03357811ULL, 0x000fe200078fe8ffULL,
0x00000008330f7824ULL, 0x000fe200078e00ffULL, 0x0000001403117811ULL, 0x000fe200078fe8ffULL,
0x00000001370d7824ULL, 0x140fe400078e0203ULL, 0x0000000837407824ULL, 0x000fe200078e00ffULL,
0xfffffff80f3a7812ULL, 0x000fe200078ee20cULL, 0x0000000813447824ULL, 0x000fe200078e00ffULL,
0x00000018030f7811ULL, 0x000fe200078fe8ffULL, 0x00000001350c7824ULL, 0x000fe200078e0203ULL,
0xfffffff840407812ULL, 0x000fe200078ee20dULL, 0x00000001130d7824ULL, 0x000fc400078e0203ULL,
0x0000000835317824ULL, 0x000fe400078e00ffULL, 0x00000001110e7824ULL, 0x040fe200078e0203ULL,
0xfffffff844447812ULL, 0x000fe200078ee20dULL, 0x0000000811397824ULL, 0x000fe200078e00ffULL,
0x00000003030d7211ULL, 0x000fe200078fe8ffULL, 0x000000010f107824ULL, 0x000fe200078e0203ULL,
0xfffffff831427812ULL, 0x000fe200078ee20cULL, 0x000000080f3b7824ULL, 0x000fe200078e00ffULL,
0xfffffff839467812ULL, 0x000fe200078ee20eULL, 0x00000080660c7824ULL, 0x000fe200078e026fULL,
0x0000003603317211ULL, 0x000fe200078fe8ffULL, 0x0000000133337824ULL, 0x000fe200078e0236ULL,
0xfffffff83b487812ULL, 0x000fe200078ee210ULL, 0x0000000137377824ULL, 0x100fe200078e0236ULL,
0x000000070d0e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x0000001c03107811ULL, 0x000fe200078fe8ffULL, 0x0000000135357824ULL, 0x000fe200078e0236ULL,
0x0ffffff80e387812ULL, 0x000fe200078ef803ULL, 0x0000010031307825ULL, 0x000fc800078e000cULL,
0x0000000113137824ULL, 0x100fe200078e0236ULL, 0x0000620030307a10ULL, 0x000fe20007f1e0ffULL,
0x0000000111117824ULL, 0x100fe400078e0236ULL, 0x000000010f0f7824ULL, 0x100fe200078e0236ULL,
0x0000630031317a10ULL, 0x000fe200007fe4ffULL, 0x0000000110397824ULL, 0x000fe400078e0236ULL,
0x0000010033327825ULL, 0x000fc800078e000cULL, 0x0000010037367825ULL, 0x000fe200078e000cULL,
0x0000620032327a10ULL, 0x000fc60007f3e0ffULL, 0x0000010035347825ULL, 0x000fe200078e000cULL,
0x0000620036367a10ULL, 0x000fe40007f5e0ffULL, 0x0000630033337a10ULL, 0x000fe20000ffe4ffULL,
0x00000001103b7824ULL, 0x000fe200078e0203ULL, 0x0000620034347a10ULL, 0x000fe20007f7e0ffULL,
0x00000008104a7824ULL, 0x000fe200078e00ffULL, 0x0000630037377a10ULL, 0x000fe200017fe4ffULL,
0x0000010013127825ULL, 0x000fe200078e000cULL, 0x0000630035357a10ULL, 0x000fe40001ffe4ffULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee23bULL, 0x0000010011107825ULL, 0x000fe200078e000cULL,
0x0000620012127a10ULL, 0x000fc60007f1e0ffULL, 0x000001000f0e7825ULL, 0x100fe200078e000cULL,
0x0000620010107a10ULL, 0x000fe40007f3e0ffULL, 0x0000630013137a10ULL, 0x000fe200007fe4ffULL,
0x00000100390c7825ULL, 0x000fe200078e000cULL, 0x000062000e0e7a10ULL, 0x000fe40007f5e0ffULL,
0x0000630011117a10ULL, 0x000fe20000ffe4ffULL, 0x0000001038397824ULL, 0x100fe200078e020bULL,
0x000062000c0c7a10ULL, 0x000fe20007f7e0ffULL, 0x000000103a3b7824ULL, 0x100fe200078e020bULL,
0x000063000f0f7a10ULL, 0x000fe200017fe4ffULL, 0x0000001040417824ULL, 0x100fe200078e020bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030397faeULL, 0x0003e2000b901c48ULL,
0x0000001042437824ULL, 0x100fe200078e020bULL, 0x000063000d0d7a10ULL, 0x000fe20001ffe4ffULL,
0x0000001044457824ULL, 0x100fe200078e020bULL, 0x00000000323b7faeULL, 0x0003e2000b901c48ULL,
0x0000001046477824ULL, 0x000fc400078e020bULL, 0x0000001048497824ULL, 0x100fe200078e020bULL,
0x0000000036417faeULL, 0x0003e2000b901c48ULL, 0x000000104a0b7824ULL, 0x000fc600078e020bULL,
0x0000000034437faeULL, 0x0003e8000b901c48ULL, 0x0000000012457faeULL, 0x0003e8000b901c48ULL,
0x0000000010477faeULL, 0x0003e8000b901c48ULL, 0x000000000e497faeULL, 0x0003e8000b901c48ULL,
0x000000000c0b7faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffe0710b7812ULL, 0x002fc400078ec0ffULL, 0x00000010710c7812ULL, 0x040fe400078ec0ffULL,
0x00000008710d7812ULL, 0x000fc800078ec0ffULL, 0x0000000b0d0b7210ULL, 0x000fe20007ffe00cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b628000b107f8cULL, 0x0002a4000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x01b62c000b0f7984ULL, 0x000ee40000000800ULL,
0x800000000fff7812ULL, 0x00cfe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c137210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000130e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000112127810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b62c000b0f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x004fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020000b7824ULL, 0x002fca00078e00ffULL,
0xffffff800b0c7812ULL, 0x000fc800078ec0ffULL, 0x000000806f0b7810ULL, 0x000fca0007ffe00cULL,
0x00000001720b7824ULL, 0x000fca00078e020bULL, 0x01b000000b107984ULL, 0x000e680000000800ULL,
0x01b200000b117984ULL, 0x0004e20000000800ULL, 0x000000091000720bULL, 0x002fe20003f1d000ULL,
0x0000fe227f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0c127812ULL, 0x000fe2000782c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff0d7224ULL, 0x000fd400078e0009ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x00000001000b7811ULL, 0x000fe400078ff0ffULL,
0x000000091000720bULL, 0x000fe40003f34000ULL, 0x000000000b00720cULL, 0x000fe20003f05270ULL,
0x0000fdd27f007947ULL, 0x000fd4000b800000ULL, 0x00000000000b7806ULL, 0x000fc400008e0100ULL,
0x00000080000d8824ULL, 0x000fe200078e026fULL, 0x00000009100c8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x00000001720f8824ULL, 0x000fe200078e020dULL,
0x000099100b0d7816ULL, 0x000fc800000000ffULL, 0x01b4000c0f008388ULL, 0x0003e20000000800ULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x00000009100c7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0bff7812ULL, 0x000fc6000780c0ffULL, 0x000000090c0c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c000d7308ULL, 0x000e640000000800ULL,
0x0000000d0a0a7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011603ULL, 0x0000fd027f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0d0c7589ULL, 0x0002a400000e0000ULL, 0x0000000c2c2c7220ULL, 0x084fe40000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe40000410000ULL, 0x0000000c28287220ULL, 0x080fe40000410000ULL,
0x0000000c29297220ULL, 0x000fc40000410000ULL, 0x0000000c14147220ULL, 0x080fe40000410000ULL,
0x0000000c15157220ULL, 0x080fe40000410000ULL, 0x0000000c3c3c7220ULL, 0x080fe40000410000ULL,
0x0000000c3d3d7220ULL, 0x080fe40000410000ULL, 0x0000000c18187220ULL, 0x080fe40000410000ULL,
0x0000000c19197220ULL, 0x000fc40000410000ULL, 0x0000000c1c1c7220ULL, 0x080fe40000410000ULL,
0x0000000c1d1d7220ULL, 0x080fe40000410000ULL, 0x0000000c20207220ULL, 0x080fe40000410000ULL,
0x0000000c21217220ULL, 0x080fe40000410000ULL, 0x0000000c24247220ULL, 0x080fe40000410000ULL,
0x0000000c25257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000bff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008030c7811ULL, 0x000fe200078ff0ffULL, 0x0000fc027f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0d0c7589ULL, 0x00046400000e0000ULL, 0x0000000c2e2e7220ULL, 0x086fe40000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe40000410000ULL, 0x0000000c2a2a7220ULL, 0x080fe40000410000ULL,
0x0000000c2b2b7220ULL, 0x080fe40000410000ULL, 0x0000000c16167220ULL, 0x080fe40000410000ULL,
0x0000000c17177220ULL, 0x000fc40000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe40000410000ULL,
0x0000000c3f3f7220ULL, 0x080fe40000410000ULL, 0x0000000c1a1a7220ULL, 0x080fe40000410000ULL,
0x0000000c1b1b7220ULL, 0x080fe40000410000ULL, 0x0000000c1e1e7220ULL, 0x080fe40000410000ULL,
0x0000000c1f1f7220ULL, 0x000fc40000410000ULL, 0x0000000c22227220ULL, 0x080fe40000410000ULL,
0x0000000c23237220ULL, 0x080fe40000410000ULL, 0x0000000c26267220ULL, 0x080fe40000410000ULL,
0x0000000c27277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff12ff7812ULL, 0x000fe4000780600bULL, 0x00000009100d7209ULL, 0x000fd60007810000ULL,
0x8000000d10100221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b10100820ULL, 0x000fc80000410000ULL,
0x0000001000050308ULL, 0x000e640000000800ULL, 0x0000000511110220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000000a11107221ULL, 0x008fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000005ff06723eULL, 0x000fe400000000ffULL,
0x00000002ff0a7819ULL, 0x000fe40000011603ULL, 0x0000541006097816ULL, 0x000fe20000000006ULL,
0x0000fa527f007947ULL, 0x000fea000b800000ULL, 0x00001f0a09067589ULL, 0x0002a400000e0000ULL,
0x000000080a0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000faa27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c09077589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100a0c7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0009ULL,
0x000049a0000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x000104d000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180a0c7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0009ULL, 0x00004a10000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0001046000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x00000001ff0b7819ULL, 0x000fe20000011600ULL,
0x01180000084c783bULL, 0x0008e20000000200ULL, 0x00000004ff0a7819ULL, 0x002fe40000011603ULL,
0x0000006e6d097212ULL, 0x008fe200078efcffULL, 0x000000020b0c7824ULL, 0x004fc400078e0266ULL,
0x000000040b0a7824ULL, 0x000fe400078e020aULL, 0x00000008090e7824ULL, 0x040fe200078e00ffULL,
0x000140000c0c7811ULL, 0x000fe200078e68ffULL, 0x00000001090a7824ULL, 0x000fe200078e020aULL,
0x00000002ff087819ULL, 0x010fc60000011600ULL, 0x0000001064307824ULL, 0x100fe200078e020cULL,
0x000000020a097810ULL, 0x000fe20007ffe0ffULL, 0x0000001063587824ULL, 0x100fe400078e020cULL,
0x0000001062547824ULL, 0x100fe200078e020cULL, 0xfffffff80e097812ULL, 0x000fe200078ee209ULL,
0x0000001065507824ULL, 0x000fe200078e020cULL, 0x000000003030783bULL, 0x000e620000004200ULL,
0x0001b690080e7811ULL, 0x040fe400078e18ffULL, 0x0000008008347824ULL, 0x000fe200078e0209ULL,
0x000000005858783bULL, 0x000ea20000004200ULL, 0x000140005c097810ULL, 0x000fc60007ffe0ffULL,
0x000000005454783bULL, 0x000fe20000004200ULL, 0x0001180034347811ULL, 0x000fe200078e20ffULL,
0x0000001061677824ULL, 0x100fe400078e0209ULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x0000001060687824ULL, 0x100fe400078e0209ULL, 0x000000105f697824ULL, 0x100fe200078e0209ULL,
0x000000003434783bULL, 0x000ee20000000200ULL, 0x000000105d6a7824ULL, 0x000fe200078e0209ULL,
0x000000064c4c0232ULL, 0x000fc40000000000ULL, 0x000000006748783bULL, 0x000f220000004200ULL,
0x000000064e4e0232ULL, 0x000fe40000000000ULL, 0x000000074d4d0232ULL, 0x080fe20000000000ULL,
0x000000006844783bULL, 0x000f220000004200ULL, 0x000000074f4f0232ULL, 0x000fc60000000000ULL,
0x000000006940783bULL, 0x000f280000004200ULL, 0x000000006a38783bULL, 0x000f220000004200ULL,
0x000000304c2c723cULL, 0x042f70000000182cULL, 0x000000324c28723cULL, 0x040f700000001828ULL,
0x000000584c14723cULL, 0x004f620000001814ULL, 0x0000000634340232ULL, 0x008fc40000000000ULL,
0x0000000636360232ULL, 0x000fe40000000000ULL, 0x0000000735350232ULL, 0x080fe40000000000ULL,
0x0000000737370232ULL, 0x000fe20000000000ULL, 0x0000005a4c3c723cULL, 0x040f70000000183cULL,
0x000000544c18723cULL, 0x040f700000001818ULL, 0x000000564c1c723cULL, 0x040f70000000181cULL,
0x000000504c20723cULL, 0x040f700000001820ULL, 0x000000524c24723cULL, 0x000f700000001824ULL,
0x00000048342c723cULL, 0x070b70000000182cULL, 0x0000004a3428723cULL, 0x040b700000001828ULL,
0x000000443414723cULL, 0x040b700000001814ULL, 0x00000046343c723cULL, 0x040b70000000183cULL,
0x000000403418723cULL, 0x040b700000001818ULL, 0x00000042341c723cULL, 0x040b70000000181cULL,
0x000000383420723cULL, 0x040b700000001820ULL, 0x0000003a3424723cULL, 0x000b620000001824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x00000001020f7810ULL, 0x000fe20007ffe0ffULL,
0x000000000eff7f8cULL, 0x0003e2000c80043fULL, 0x000000c004117810ULL, 0x000fc40007ffe0ffULL,
0x0000005e0f00720cULL, 0x000fc60003f06070ULL, 0x000066006b0c7a24ULL, 0x000fe200078e0211ULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000061000008947ULL, 0x000fea0003800000ULL,
0x00000003ff347819ULL, 0x022fe20000011603ULL, 0x0000008066387824ULL, 0x000fe200078e026fULL,
0x000000116c047217ULL, 0x000fe20007800000ULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x00000010343a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000134337824ULL, 0x040fe200078e020cULL,
0x0000000c34307810ULL, 0x000fe20007ffe0ffULL, 0x0000000104117824ULL, 0x000fe200078e0a11ULL,
0x00000004340e7810ULL, 0x000fe20007ffe0ffULL, 0x000000013a047824ULL, 0x100fe200078e0203ULL,
0x0000000834127810ULL, 0x000fe20007ffe0ffULL, 0x000000083a317824ULL, 0x000fe200078e00ffULL,
0x0000002011117817ULL, 0x000fe20003800000ULL, 0x0000000130407824ULL, 0x100fe200078e0203ULL,
0x0000001434487810ULL, 0x000fe20007ffe0ffULL, 0x0000000830137824ULL, 0x000fe200078e00ffULL,
0xfffffff831047812ULL, 0x000fe200078ee204ULL, 0x000000010e447824ULL, 0x100fe200078e0203ULL,
0x000000113000720cULL, 0x080fe20003f46070ULL, 0x000000080e0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff813407812ULL, 0x000fe200078ee240ULL, 0x0000000112317824ULL, 0x140fe200078e020cULL,
0x000000111200720cULL, 0x080fe20003f66070ULL, 0x0000000130137824ULL, 0x000fe200078e020cULL,
0xfffffff80f447812ULL, 0x000fe200078ee244ULL, 0x0000000112427824ULL, 0x000fe200078e0203ULL,
0x000000110e00720cULL, 0x000fe20003fa6070ULL, 0x00000008120f7824ULL, 0x000fe200078e00ffULL,
0x00000018344a7810ULL, 0x000fe20007ffe0ffULL, 0x0000010033327825ULL, 0x000fc600078e0038ULL,
0xfffffff80f427812ULL, 0x000fe200078ee242ULL, 0x0000010031307825ULL, 0x000fe200078e0038ULL,
0x0000620032367a10ULL, 0x000fc60007f1e0ffULL, 0x0000010013127825ULL, 0x000fe200078e0038ULL,
0x0000620030327a10ULL, 0x000fe40007f9e0ffULL, 0x0000630033377a10ULL, 0x000fe200007fe4ffULL,
0x0000000148467824ULL, 0x000fe200078e0203ULL, 0x0000620012307a10ULL, 0x000fe20007fde0ffULL,
0x0000000848357824ULL, 0x000fe200078e00ffULL, 0x0000630031337a10ULL, 0x000fe200027fe4ffULL,
0x000000010e0f7824ULL, 0x100fe200078e020cULL, 0x0000630013317a10ULL, 0x000fe200037fe4ffULL,
0x000000013a137824ULL, 0x000fe200078e020cULL, 0xfffffff835467812ULL, 0x000fe200078ee246ULL,
0x000001000f0e7825ULL, 0x000fe200078e0038ULL, 0x000000114800720cULL, 0x000fc40003f06070ULL,
0x000000113400720cULL, 0x0c0fe20003f86070ULL, 0x0000000134357824ULL, 0x000fe200078e0203ULL,
0x000062000e0e7a10ULL, 0x000fe20007f3e0ffULL, 0x00000001483b7824ULL, 0x000fe200078e020cULL,
0x0000001c34487810ULL, 0x000fe20007ffe0ffULL, 0x0000010013127825ULL, 0x000fe200078e0038ULL,
0x0000000735347812ULL, 0x000fe400078ec0ffULL, 0x000063000f0f7a10ULL, 0x000fe20000ffe4ffULL,
0x000000014a357824ULL, 0x100fe200078e020cULL, 0x000000113a00720cULL, 0x000fe20003f26070ULL,
0x0000000148437824ULL, 0x000fe200078e020cULL, 0x0ffffff8340c7812ULL, 0x000fe200078ef803ULL,
0x000001003b3a7825ULL, 0x000fe200078e0038ULL, 0x0000620012127a10ULL, 0x000fc60007fde0ffULL,
0x0000010035347825ULL, 0x000fe200078e0038ULL, 0x0000630013137a10ULL, 0x000fe400037fe4ffULL,
0x000062003a3a7a10ULL, 0x000fe20007fde0ffULL, 0x000000100c417824ULL, 0x000fe400078e0209ULL,
0x0000010043387825ULL, 0x000fe200078e0038ULL, 0x000063003b3b7a10ULL, 0x000fe400037fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036417faeULL, 0x0003e2000e101c48ULL,
0x0000001044437824ULL, 0x000fe200078e0209ULL, 0x000000114a00720cULL, 0x0c0fe20003fc6070ULL,
0x000000014a0c7824ULL, 0x100fe200078e0203ULL, 0x0000620034347a10ULL, 0x000fe20007f9e0ffULL,
0x0000000148447824ULL, 0x040fe200078e0203ULL, 0x000000000e437faeULL, 0x0005e2000e901c48ULL,
0x000000114800720cULL, 0x000fe20003fa6070ULL, 0x000000084a117824ULL, 0x000fe200078e00ffULL,
0x0000630035357a10ULL, 0x000fe200027fe4ffULL, 0x0000000848457824ULL, 0x000fe200078e00ffULL,
0x0000620038387a10ULL, 0x000fe20007f9e0ffULL, 0x0000001004377824ULL, 0x102fe200078e0209ULL,
0xfffffff8110c7812ULL, 0x000fe200078ee20cULL, 0x0000001042117824ULL, 0x100fe200078e0209ULL,
0xfffffff845447812ULL, 0x000fe200078ee244ULL, 0x0000001046417824ULL, 0x100fe200078e0209ULL,
0x0000630039397a10ULL, 0x000fe200027fe4ffULL, 0x00000010400f7824ULL, 0x104fe200078e0209ULL,
0x0000000032117faeULL, 0x0003e2000d901c48ULL, 0x000000100c437824ULL, 0x000fc400078e0209ULL,
0x0000001044457824ULL, 0x000fe200078e0209ULL, 0x00000000300f7faeULL, 0x0003e8000d101c48ULL,
0x0000000012377faeULL, 0x0003e8000c901c48ULL, 0x000000003a417faeULL, 0x0003e8000c101c48ULL,
0x0000000034437faeULL, 0x0003e8000f101c48ULL, 0x0000000038457faeULL, 0x0003e2000e901c48ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000000803137811ULL, 0x042fe200078fe8ffULL,
0x00000080663a7824ULL, 0x020fe200078e026fULL, 0x00000004030f7811ULL, 0x000fc400078fe8ffULL,
0x0000000c03317811ULL, 0x000fe200078fe8ffULL, 0x0000000113467824ULL, 0x100fe200078e0203ULL,
0x0000001803377811ULL, 0x000fe200078fe8ffULL, 0x0000000813337824ULL, 0x000fe200078e00ffULL,
0x0000001403357811ULL, 0x000fe200078fe8ffULL, 0x000000010f487824ULL, 0x100fe200078e0203ULL,
0x0000001c030e7811ULL, 0x000fe200078fe8ffULL, 0x000000080f117824ULL, 0x000fe200078e00ffULL,
0xfffffff833467812ULL, 0x000fe200078ee246ULL, 0x0000000131447824ULL, 0x100fe200078e0203ULL,
0x0000001003337811ULL, 0x000fe200078fe8ffULL, 0x0000000137047824ULL, 0x000fe200078e0203ULL,
0xfffffff811487812ULL, 0x000fe200078ee248ULL, 0x0000000831117824ULL, 0x000fc400078e00ffULL,
0x0000000133427824ULL, 0x140fe400078e0203ULL, 0x0000000833397824ULL, 0x000fe200078e00ffULL,
0xfffffff811447812ULL, 0x000fe200078ee244ULL, 0x0000000837417824ULL, 0x000fe400078e00ffULL,
0x0000000135407824ULL, 0x000fe200078e0203ULL, 0xfffffff839427812ULL, 0x000fe200078ee242ULL,
0x00000008353b7824ULL, 0x000fe200078e00ffULL, 0xfffffff841047812ULL, 0x000fe200078ee204ULL,
0x000000010f0f7824ULL, 0x100fe200078e020cULL, 0x0000000c03397211ULL, 0x000fe200078fe8ffULL,
0x0000000113137824ULL, 0x000fe200078e020cULL, 0xfffffff83b407812ULL, 0x000fe200078ee240ULL,
0x0000000131317824ULL, 0x000fc400078e020cULL, 0x0000000133337824ULL, 0x100fe400078e020cULL,
0x0000000135357824ULL, 0x100fe400078e020cULL, 0x0000000137377824ULL, 0x100fe400078e020cULL,
0x000000010e117824ULL, 0x040fe400078e020cULL, 0x000000010e0c7824ULL, 0x040fe400078e0203ULL,
0x000000080e417824ULL, 0x000fc400078e00ffULL, 0x000000ffff3b7224ULL, 0x000fe400078e00ffULL,
0x0000001046437824ULL, 0x000fe200078e0209ULL, 0xfffffff8414a7812ULL, 0x000fe200078ee20cULL,
0x0000010039387825ULL, 0x000fe200078e003aULL, 0x00000003030c7211ULL, 0x000fc600078fe8ffULL,
0x000001000f0e7825ULL, 0x100fe200078e003aULL, 0x0000620038387a10ULL, 0x000fe40007f1e0ffULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000010013127825ULL, 0x100fe200078e003aULL,
0x000062000e0e7a10ULL, 0x000fe40007f3e0ffULL, 0x0000630039397a10ULL, 0x000fe200007fe4ffULL,
0x0000010031307825ULL, 0x000fe200078e003aULL, 0x0ffffff80c0c7812ULL, 0x000fe400078ef803ULL,
0x000063000f0f7a10ULL, 0x000fe20000ffe4ffULL, 0x0000010033327825ULL, 0x000fe200078e003aULL,
0x0000620012127a10ULL, 0x000fc40007f1e0ffULL, 0x0000620030307a10ULL, 0x000fe20007f3e0ffULL,
0x0000010035347825ULL, 0x100fe200078e003aULL, 0x0000620032327a10ULL, 0x000fe40007f5e0ffULL,
0x0000630013137a10ULL, 0x000fe200007fe4ffULL, 0x0000010037367825ULL, 0x100fe200078e003aULL,
0x0000630031317a10ULL, 0x000fe40000ffe4ffULL, 0x0000620034347a10ULL, 0x000fe20007f1e0ffULL,
0x00000100113a7825ULL, 0x000fe200078e003aULL, 0x0000630033337a10ULL, 0x000fc400017fe4ffULL,
0x0000620036367a10ULL, 0x000fe20007f3e0ffULL, 0x000000100c117824ULL, 0x100fe200078e0209ULL,
0x000062003a3a7a10ULL, 0x000fe20007f5e0ffULL, 0x0000001048417824ULL, 0x100fe200078e0209ULL,
0x0000630035357a10ULL, 0x000fe200007fe4ffULL, 0x0000001044457824ULL, 0x100fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038117faeULL, 0x0003e2000b901c48ULL,
0x0000001042477824ULL, 0x100fe200078e0209ULL, 0x0000630037377a10ULL, 0x000fe20000ffe4ffULL,
0x0000001040497824ULL, 0x100fe200078e0209ULL, 0x000000000e417faeULL, 0x0003e2000b901c48ULL,
0x00000010044b7824ULL, 0x100fe200078e0209ULL, 0x000063003b3b7a10ULL, 0x000fe200017fe4ffULL,
0x000000104a4d7824ULL, 0x000fe200078e0209ULL, 0x0000000012437faeULL, 0x0003e8000b901c48ULL,
0x0000000030457faeULL, 0x0003e8000b901c48ULL, 0x0000000032477faeULL, 0x0003e8000b901c48ULL,
0x0000000034497faeULL, 0x0003e8000b901c48ULL, 0x00000000364b7faeULL, 0x0003e8000b901c48ULL,
0x000000003a4d7faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000010710f7812ULL, 0x002fca00078ec0ffULL, 0x00000020080f7824ULL, 0x000fc800078e020fULL,
0x0000000866047824ULL, 0x000fe200078e020fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b64800040e7f8cULL, 0x0002a4000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x01b64c0004117984ULL, 0x000ee40000000800ULL, 0x8000000011ff7812ULL, 0x00cfe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000307805ULL, 0x000fcc0000015200ULL, 0x0000003012117210ULL, 0x000fca0007f1e1ffULL,
0x0000000131307824ULL, 0x000fe200000e0e13ULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff3000720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff3000720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011430ULL,
0x0000001108087211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0630ULL,
0x0000000208087819ULL, 0x000fc80000001211ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b64c0004117984ULL, 0x000ea40000000800ULL,
0x8000000011ff7812ULL, 0x004fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002000047824ULL, 0x002fca00078e00ffULL, 0xffffff8004047812ULL, 0x000fc800078ec0ffULL,
0x000001006f0f7810ULL, 0x000fca0007ffe004ULL, 0x00000001720f7824ULL, 0x000fca00078e020fULL,
0x01b000000f047984ULL, 0x000e680000000800ULL, 0x01b200000f117984ULL, 0x0004e20000000800ULL,
0x0000000d0400720bULL, 0x002fe20003f1d000ULL, 0x0000e7127f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0c137812ULL, 0x000fe2000782c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff087224ULL, 0x000fd400078e000dULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x00000002000f7811ULL, 0x000fe400078ff0ffULL, 0x0000000d0400720bULL, 0x000fe40003f34000ULL,
0x000000000f00720cULL, 0x000fe20003f05270ULL, 0x0000e6c27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000087806ULL, 0x000fc400008e0100ULL, 0x00000080000f8824ULL, 0x000fe200078e026fULL,
0x0000000d040c8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x00009910080e7816ULL, 0x000fe200000000ffULL, 0x00000001720f8824ULL, 0x000fca00078e020fULL,
0x01b4000c0f008388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000d040c7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff08ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000d0c0c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00337308ULL, 0x000e640000000800ULL, 0x0000003310107220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011603ULL,
0x0000e5f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c330c7589ULL, 0x0002a400000e0000ULL,
0x0000000c2c2c7220ULL, 0x084fe40000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000c28287220ULL, 0x080fe40000410000ULL, 0x0000000c29297220ULL, 0x000fc40000410000ULL,
0x0000000c14147220ULL, 0x080fe40000410000ULL, 0x0000000c15157220ULL, 0x080fe40000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe40000410000ULL,
0x0000000c18187220ULL, 0x080fe40000410000ULL, 0x0000000c19197220ULL, 0x000fc40000410000ULL,
0x0000000c1c1c7220ULL, 0x080fe40000410000ULL, 0x0000000c1d1d7220ULL, 0x080fe40000410000ULL,
0x0000000c20207220ULL, 0x080fe40000410000ULL, 0x0000000c21217220ULL, 0x080fe40000410000ULL,
0x0000000c24247220ULL, 0x080fe40000410000ULL, 0x0000000c25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0008ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008030c7811ULL, 0x000fe200078ff0ffULL,
0x0000e4f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c330c7589ULL, 0x00046400000e0000ULL,
0x0000000c2e2e7220ULL, 0x086fe40000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000c2a2a7220ULL, 0x080fe40000410000ULL, 0x0000000c2b2b7220ULL, 0x080fe40000410000ULL,
0x0000000c16167220ULL, 0x080fe40000410000ULL, 0x0000000c17177220ULL, 0x000fc40000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe40000410000ULL,
0x0000000c1a1a7220ULL, 0x080fe40000410000ULL, 0x0000000c1b1b7220ULL, 0x080fe40000410000ULL,
0x0000000c1e1e7220ULL, 0x080fe40000410000ULL, 0x0000000c1f1f7220ULL, 0x000fc40000410000ULL,
0x0000000c22227220ULL, 0x080fe40000410000ULL, 0x0000000c23237220ULL, 0x080fe40000410000ULL,
0x0000000c26267220ULL, 0x080fe40000410000ULL, 0x0000000c27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff13ff7812ULL, 0x000fe40007806008ULL,
0x0000000d04087209ULL, 0x000fd60007810000ULL, 0x8000000804040221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b04040820ULL, 0x000fc80000410000ULL, 0x0000000400050308ULL, 0x000e640000000800ULL,
0x0000000511110220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x0000001011107221ULL, 0x008fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000005ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011603ULL,
0x0000541004047816ULL, 0x000fe20000000004ULL, 0x0000e3427f007947ULL, 0x000fea000b800000ULL,
0x00001f0d04067589ULL, 0x0002a400000e0000ULL, 0x000000080d0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000e3927f007947ULL, 0x000fea000b800000ULL, 0x00001f0c04077589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100d0c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0004ULL, 0x00006310000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0000eb6000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180d0c7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0004ULL,
0x00006380000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x0000eaf000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000006e6d0f7212ULL, 0x000fe200078efcffULL,
0x00000002000d7824ULL, 0x042fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000200000047824ULL, 0x008fe400078e00ffULL, 0x000000080f117824ULL, 0x000fc400078e00ffULL,
0x00000200000c7824ULL, 0x004fc600078e00ffULL, 0xfffffff811117812ULL, 0x000fe400078ee20aULL,
0x000000040d0a7812ULL, 0x000fe400078ec0ffULL, 0xffffc000040d7812ULL, 0x000fe400078ec0ffULL,
0xfffff8000c0c7812ULL, 0x000fe400078ec0ffULL, 0x000000020a0a7812ULL, 0x000fe200078efcffULL,
0x00002000660d7824ULL, 0x000fe400078e020dULL, 0x0000001011117824ULL, 0x000fe200078e020cULL,
0x0000000a030a7211ULL, 0x000fc400078fe0ffULL, 0x000130000d047810ULL, 0x000fe40007ffe0ffULL,
0x012000001148783bULL, 0x0002a20000000200ULL, 0x000000010f0a7824ULL, 0x000fe400078e020aULL,
0x0000001063547824ULL, 0x100fe400078e0204ULL, 0x0000001062507824ULL, 0x100fe400078e0204ULL,
0x00000010654c7824ULL, 0x000fe200078e0204ULL, 0x00000002ff117819ULL, 0x002fe20000011600ULL,
0x000000080f0f7824ULL, 0x000fe200078e00ffULL, 0x000000005454783bULL, 0x000e620000004200ULL,
0x00000010640c7824ULL, 0x000fc600078e0204ULL, 0x000000005050783bULL, 0x000ee20000004200ULL,
0xfffffff80f0a7812ULL, 0x000fc600078ee20aULL, 0x000000004c4c783bULL, 0x000fe40000004200ULL,
0x000000100a047824ULL, 0x000fe200078e00ffULL, 0x000130005c0a7810ULL, 0x000fe20007ffe0ffULL,
0x000000000c0c783bULL, 0x000fe40000004200ULL, 0x0000080011307824ULL, 0x000fe400078e0204ULL,
0x0000001060407824ULL, 0x100fe400078e020aULL, 0x000000105d347824ULL, 0x000fc400078e020aULL,
0x012000003030783bULL, 0x000f220000000200ULL, 0x000000105f387824ULL, 0x100fe400078e020aULL,
0x0000001061447824ULL, 0x000fe200078e020aULL, 0x000000004040783bULL, 0x000f280000004200ULL,
0x000000003838783bULL, 0x000f220000004200ULL, 0x0000000648480232ULL, 0x004fc60000000000ULL,
0x000000003434783bULL, 0x000ea20000004200ULL, 0x000000064a4a0232ULL, 0x000fe40000000000ULL,
0x0000000749490232ULL, 0x080fe20000000000ULL, 0x000000004444783bULL, 0x000ea20000004200ULL,
0x000000074b4b0232ULL, 0x000fce0000000000ULL, 0x000000544814723cULL, 0x042f700000001814ULL,
0x00000056483c723cULL, 0x040f70000000183cULL, 0x000000504818723cULL, 0x008f620000001818ULL,
0x0000000630300232ULL, 0x010fc40000000000ULL, 0x0000000632320232ULL, 0x000fe40000000000ULL,
0x0000000731310232ULL, 0x080fe40000000000ULL, 0x0000000733330232ULL, 0x000fe20000000000ULL,
0x00000052481c723cULL, 0x040f70000000181cULL, 0x0000004c4820723cULL, 0x040f700000001820ULL,
0x0000004e4824723cULL, 0x040f700000001824ULL, 0x0000000c482c723cULL, 0x040f70000000182cULL,
0x0000000e480c723cULL, 0x000f700000001828ULL, 0x000000403014723cULL, 0x060f700000001814ULL,
0x00000042303c723cULL, 0x040f70000000183cULL, 0x000000383018723cULL, 0x040f700000001818ULL,
0x0000003a301c723cULL, 0x040f70000000181cULL, 0x000000343020723cULL, 0x044f700000001820ULL,
0x000000363024723cULL, 0x040f700000001824ULL, 0x00000044302c723cULL, 0x040f70000000182cULL,
0x000000463044723cULL, 0x000b6e000000180cULL, 0x0001b698110c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fcc0000008000ULL, 0x00000300020f7a10ULL, 0x000fe20007ffe0ffULL,
0x000000000cff7f8cULL, 0x0003e6000c80043fULL, 0x0000005e0f00720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x00000ba000000947ULL, 0x000fea0003800000ULL,
0x000000010f0d7810ULL, 0x042fe20007ffe0ffULL, 0x000001000f0f7824ULL, 0x000fc600078e0270ULL,
0x0000005e0d00720cULL, 0x000fe20003f06070ULL, 0x000066006b347a24ULL, 0x000fd800078e020fULL,
0x0000061000008947ULL, 0x000fea0003800000ULL, 0x00000003ff367819ULL, 0x000fe40000011603ULL,
0x0000000f6c0c7217ULL, 0x000fe40007800000ULL, 0x00000004360e7810ULL, 0x040fe40007ffe0ffULL,
0x0000000836307810ULL, 0x000fe20007ffe0ffULL, 0x000000010c3b7824ULL, 0x000fe200078e0a0fULL,
0x0000000c36387810ULL, 0x000fe20007ffe0ffULL, 0x000000010e0d7824ULL, 0x100fe200078e0203ULL,
0x00000010363a7810ULL, 0x000fe20007ffe0ffULL, 0x000000080e127824ULL, 0x000fe200078e00ffULL,
0x000000203b3b7817ULL, 0x000fe20003800000ULL, 0x0000000130357824ULL, 0x000fe200078e0203ULL,
0x0000001436407810ULL, 0x000fe20007ffe0ffULL, 0x0000000830287824ULL, 0x000fe200078e00ffULL,
0xfffffff812417812ULL, 0x000fe200078ee20dULL, 0x00000080660c7824ULL, 0x000fe200078e026fULL,
0x0000003b0e00720cULL, 0x080fe20003f86070ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0xfffffff828357812ULL, 0x000fe200078ee235ULL, 0x000000010e137824ULL, 0x100fe200078e0234ULL,
0x0000003b3800720cULL, 0x080fe20003f46070ULL, 0x00000001360f7824ULL, 0x040fe200078e0234ULL,
0x0000003b3600720cULL, 0x080fe20003fa6070ULL, 0x0000010013127825ULL, 0x000fe200078e000cULL,
0x0000003b3000720cULL, 0x000fc60003f66070ULL, 0x0000000138397824ULL, 0x000fe200078e0203ULL,
0x00006200122a7a10ULL, 0x000fe20007f3e0ffULL, 0x0000000838287824ULL, 0x000fe400078e00ffULL,
0x000001000f0e7825ULL, 0x000fe200078e000cULL, 0x00006300132b7a10ULL, 0x000fe40000ffe4ffULL,
0xfffffff828397812ULL, 0x000fe200078ee239ULL, 0x000000013a377824ULL, 0x100fe200078e0203ULL,
0x000062000e287a10ULL, 0x000fe20007f1e0ffULL, 0x000000083a327824ULL, 0x040fe200078e00ffULL,
0x0000003b3a00720cULL, 0x000fe20003f26070ULL, 0x00000001360e7824ULL, 0x000fe200078e0203ULL,
0x000063000f297a10ULL, 0x000fe200007fe4ffULL, 0x0000000138137824ULL, 0x000fe200078e0234ULL,
0xfffffff832377812ULL, 0x000fe200078ee237ULL, 0x0000000140337824ULL, 0x000fe200078e0203ULL,
0x000000070e327812ULL, 0x000fe200078ec0ffULL, 0x0000000840387824ULL, 0x000fc400078e00ffULL,
0x0000010013127825ULL, 0x000fc600078e000cULL, 0xfffffff8384b7812ULL, 0x000fe200078ee233ULL,
0x00000001300f7824ULL, 0x100fe200078e0234ULL, 0x0ffffff832337812ULL, 0x000fe200078ef803ULL,
0x000000013a317824ULL, 0x000fe200078e0234ULL, 0x0000620012127a10ULL, 0x000fe20007fde0ffULL,
0x000001000f0e7825ULL, 0x100fe200078e000cULL, 0x0000001836387810ULL, 0x000fe40007ffe0ffULL,
0x0000630013137a10ULL, 0x000fe200037fe4ffULL, 0x0000010031307825ULL, 0x000fe200078e000cULL,
0x000062000e0e7a10ULL, 0x000fc40007f1e0ffULL, 0x0000001c36367810ULL, 0x000fe20007ffe0ffULL,
0x0000001033437824ULL, 0x000fe200078e020aULL, 0x0000620030307a10ULL, 0x000fe20007fde0ffULL,
0x0000000140337824ULL, 0x000fe200078e0234ULL, 0x000063000f0f7a10ULL, 0x000fe200007fe4ffULL,
0x0000001041497824ULL, 0x000fe200078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028437faeULL, 0x0003e2000e901c48ULL, 0x0000010033327825ULL, 0x000fe200078e000cULL,
0x0000630031317a10ULL, 0x000fe400037fe4ffULL, 0x000000002a497faeULL, 0x0005e2000e101c48ULL,
0x0000000138417824ULL, 0x000fe200078e0234ULL, 0x0000003b4000720cULL, 0x080fe20003f06070ULL,
0x0000001035357824ULL, 0x100fe200078e020aULL, 0x0000620032327a10ULL, 0x000fe20007fde0ffULL,
0x0000001039397824ULL, 0x100fe200078e020aULL, 0x0000003b3800720cULL, 0x080fe20003fa6070ULL,
0x0000001037377824ULL, 0x000fe200078e020aULL, 0x0000003b3600720cULL, 0x040fe20003f86070ULL,
0x0000010041287825ULL, 0x002fe200078e000cULL, 0x0000630033337a10ULL, 0x000fe200037fe4ffULL,
0x000000000e357faeULL, 0x0003e4000d901c48ULL, 0x00000001363b7824ULL, 0x000fe200078e0234ULL,
0x0000620028287a10ULL, 0x000fe20007fde0ffULL, 0x0000000138347824ULL, 0x140fe200078e0203ULL,
0x0000000012397faeULL, 0x0003e2000d101c48ULL, 0x0000000838417824ULL, 0x000fe200078e00ffULL,
0x0000630029297a10ULL, 0x000fe200037fe4ffULL, 0x00000001362a7824ULL, 0x044fe200078e0203ULL,
0x0000000030377faeULL, 0x0003e2000c901c48ULL, 0x0000000836437824ULL, 0x000fe200078e00ffULL,
0xfffffff8412b7812ULL, 0x000fe200078ee234ULL, 0x000001003b0c7825ULL, 0x000fc600078e000cULL,
0xfffffff8433b7812ULL, 0x000fe200078ee22aULL, 0x000000104b4b7824ULL, 0x100fe200078e020aULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x000000102b2b7824ULL, 0x100fe400078e020aULL,
0x000000103b3b7824ULL, 0x000fe200078e020aULL, 0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x00000000324b7faeULL, 0x0003e8000c101c48ULL, 0x00000000282b7faeULL, 0x0003e8000e901c48ULL,
0x000000000c3b7faeULL, 0x0003e2000e101c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000000403337811ULL, 0x040fe200078fe8ffULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0x0000000803357811ULL, 0x000fc400078fe8ffULL, 0x0000000c030e7811ULL, 0x000fe200078fe8ffULL,
0x00000001330c7824ULL, 0x100fe200078e0203ULL, 0x00000010030f7811ULL, 0x000fe200078fe8ffULL,
0x00000008333b7824ULL, 0x000fe200078e00ffULL, 0x0000001403137811ULL, 0x000fe200078fe8ffULL,
0x00000001350d7824ULL, 0x100fe200078e0203ULL, 0x0000001803297811ULL, 0x000fe200078fe8ffULL,
0x0000000835127824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee20cULL,
0x000000010e0c7824ULL, 0x040fe200078e0203ULL, 0x0000003403317211ULL, 0x000fe200078fe8ffULL,
0x000000080e437824ULL, 0x000fe200078e00ffULL, 0xfffffff812417812ULL, 0x000fe200078ee20dULL,
0x000000010f0d7824ULL, 0x000fc400078e0203ULL, 0x000000080f2a7824ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fe200078ee20cULL, 0x0000000113127824ULL, 0x000fe200078e0203ULL,
0x00000003030c7211ULL, 0x000fe200078fe8ffULL, 0x00000008134b7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a497812ULL, 0x000fe200078ee20dULL, 0x00000080662a7824ULL, 0x000fe200078e026fULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000133337824ULL, 0x000fe200078e0234ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee212ULL, 0x0000000135357824ULL, 0x100fe200078e0234ULL,
0x0000001c03127811ULL, 0x000fe200078fe8ffULL, 0x000000010e0d7824ULL, 0x000fe200078e0234ULL,
0x0ffffff80c397812ULL, 0x100fe200078ef803ULL, 0x0000000129287824ULL, 0x000fc400078e0203ULL,
0x00000008294d7824ULL, 0x000fe400078e00ffULL, 0x0000010031307825ULL, 0x000fc600078e002aULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee228ULL, 0x000000010f0f7824ULL, 0x100fe200078e0234ULL,
0x0000620030307a10ULL, 0x000fe20007f1e0ffULL, 0x0000000113137824ULL, 0x100fe400078e0234ULL,
0x0000000129297824ULL, 0x100fe200078e0234ULL, 0x0000630031317a10ULL, 0x000fe200007fe4ffULL,
0x0000000112377824ULL, 0x000fe400078e0234ULL, 0x0000010033327825ULL, 0x000fc800078e002aULL,
0x0000010035347825ULL, 0x000fe200078e002aULL, 0x0000620032327a10ULL, 0x000fc60007f3e0ffULL,
0x000001000d0c7825ULL, 0x000fe200078e002aULL, 0x0000620034347a10ULL, 0x000fe40007f5e0ffULL,
0x0000630033337a10ULL, 0x000fe20000ffe4ffULL, 0x0000000112367824ULL, 0x000fe200078e0203ULL,
0x000062000c0c7a10ULL, 0x000fe20007f7e0ffULL, 0x00000008124f7824ULL, 0x000fe200078e00ffULL,
0x0000630035357a10ULL, 0x000fe200017fe4ffULL, 0x000001000f0e7825ULL, 0x000fe200078e002aULL,
0x000063000d0d7a10ULL, 0x000fc60001ffe4ffULL, 0x0000010013127825ULL, 0x000fe200078e002aULL,
0x000062000e0e7a10ULL, 0x000fc60007f1e0ffULL, 0x0000010029287825ULL, 0x100fe200078e002aULL,
0x0000620012127a10ULL, 0x000fe40007f3e0ffULL, 0x000063000f0f7a10ULL, 0x000fe200007fe4ffULL,
0x00000100372a7825ULL, 0x000fe200078e002aULL, 0xfffffff84f377812ULL, 0x000fe400078ee236ULL,
0x0000620028287a10ULL, 0x000fe20007f5e0ffULL, 0x0000001039397824ULL, 0x100fe200078e020aULL,
0x000062002a2a7a10ULL, 0x000fe20007f7e0ffULL, 0x000000103b3b7824ULL, 0x100fe200078e020aULL,
0x0000630013137a10ULL, 0x000fe20000ffe4ffULL, 0x0000001041417824ULL, 0x100fe200078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030397faeULL, 0x0003e2000b901c48ULL,
0x0000001043437824ULL, 0x100fe200078e020aULL, 0x0000630029297a10ULL, 0x000fe200017fe4ffULL,
0x0000001049497824ULL, 0x100fe200078e020aULL, 0x00000000323b7faeULL, 0x0003e2000b901c48ULL,
0x000000104b4b7824ULL, 0x100fe200078e020aULL, 0x000063002b2b7a10ULL, 0x000fe20001ffe4ffULL,
0x000000104d4d7824ULL, 0x100fe200078e020aULL, 0x0000000034417faeULL, 0x0003e2000b901c48ULL,
0x0000001037377824ULL, 0x000fc600078e020aULL, 0x000000000c437faeULL, 0x0003e8000b901c48ULL,
0x000000000e497faeULL, 0x0003e8000b901c48ULL, 0x00000000124b7faeULL, 0x0003e8000b901c48ULL,
0x00000000284d7faeULL, 0x0003e8000b901c48ULL, 0x000000002a377faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x002e220000000000ULL, 0x00000010710a7812ULL, 0x000fc400078ec0ffULL,
0x00000008710d7812ULL, 0x000fc600078ec0ffULL, 0x00000020110a7824ULL, 0x000fc800078e020aULL,
0x000000010d0a7824ULL, 0x000fe200078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b668000a127f8cULL, 0x0002a4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x01b66c000a0f7984ULL, 0x000ee40000000800ULL, 0x800000000fff7812ULL, 0x00cfe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff287224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c117210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000110e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000128287810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b66c000a0f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000003000a7811ULL, 0x002fca00078ff0ffULL, 0x000000800a0d7824ULL, 0x000fc800078e026fULL,
0x00000001720d7824ULL, 0x000fca00078e020dULL, 0x01b000000d117984ULL, 0x000e680000000800ULL,
0x01b200000d0a7984ULL, 0x0004e20000000800ULL, 0x000000081100720bULL, 0x002fe20003f1d000ULL,
0x0000cf627f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0c127812ULL, 0x000fe2000782c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x00000003000d7811ULL, 0x000fe400078ff0ffULL, 0x000000081100720bULL, 0x000fe40003f34000ULL,
0x000000000d00720cULL, 0x000fe20003f05270ULL, 0x0000cf227f007947ULL, 0x000fd4000b800000ULL,
0x00000000000d7806ULL, 0x000fc400008e0100ULL, 0x00000080006f8824ULL, 0x000fe200078e026fULL,
0x00000008110c8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x000099100d0e7816ULL, 0x000fe200000000ffULL, 0x00000001726f8824ULL, 0x000fca00078e026fULL,
0x01b4000c6f008388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x00000008110f7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0dff7812ULL, 0x000fc6000780c0ffULL,
0x000000080f0c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00137308ULL, 0x000e640000000800ULL, 0x0000001310107220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011603ULL,
0x0000ce527f007947ULL, 0x000fea000b800000ULL, 0x00001f0c130c7589ULL, 0x0002a400000e0000ULL,
0x0000000c2c2c7220ULL, 0x084fe40000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000c44447220ULL, 0x080fe40000410000ULL, 0x0000000c45457220ULL, 0x000fc40000410000ULL,
0x0000000c14147220ULL, 0x080fe40000410000ULL, 0x0000000c15157220ULL, 0x080fe40000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe40000410000ULL,
0x0000000c18187220ULL, 0x080fe40000410000ULL, 0x0000000c19197220ULL, 0x000fc40000410000ULL,
0x0000000c1c1c7220ULL, 0x080fe40000410000ULL, 0x0000000c1d1d7220ULL, 0x080fe40000410000ULL,
0x0000000c20207220ULL, 0x080fe40000410000ULL, 0x0000000c21217220ULL, 0x080fe40000410000ULL,
0x0000000c24247220ULL, 0x080fe40000410000ULL, 0x0000000c25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000dff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008030c7811ULL, 0x000fe200078ff0ffULL,
0x0000cd527f007947ULL, 0x000fea000b800000ULL, 0x00001f0c130c7589ULL, 0x00046400000e0000ULL,
0x0000000c2e2e7220ULL, 0x086fe40000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000c46467220ULL, 0x080fe40000410000ULL, 0x0000000c47477220ULL, 0x080fe40000410000ULL,
0x0000000c16167220ULL, 0x080fe40000410000ULL, 0x0000000c17177220ULL, 0x000fc40000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe40000410000ULL,
0x0000000c1a1a7220ULL, 0x080fe40000410000ULL, 0x0000000c1b1b7220ULL, 0x080fe40000410000ULL,
0x0000000c1e1e7220ULL, 0x080fe40000410000ULL, 0x0000000c1f1f7220ULL, 0x000fc40000410000ULL,
0x0000000c22227220ULL, 0x080fe40000410000ULL, 0x0000000c23237220ULL, 0x080fe40000410000ULL,
0x0000000c26267220ULL, 0x080fe40000410000ULL, 0x0000000c27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff12ff7812ULL, 0x000fe4000780600dULL,
0x0000000811087209ULL, 0x000fd60007810000ULL, 0x8000000811110221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL, 0x0000001100050308ULL, 0x000e640000000800ULL,
0x000000050a0a0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x000000100a0a7221ULL, 0x008fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000005ff06723eULL, 0x000fe400000000ffULL, 0x00000002ff107819ULL, 0x000fe40000011603ULL,
0x00005410060d7816ULL, 0x000fe20000000006ULL, 0x0000cba27f007947ULL, 0x000fea000b800000ULL,
0x00001f100d067589ULL, 0x0002a400000e0000ULL, 0x00000008100c7810ULL, 0x000fe20007ffe0ffULL,
0x0000cbf27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0d077589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010100c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00007d10000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0000d16000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000018100c7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000dULL,
0x00007d80000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x0000d0f000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002000c7824ULL, 0x04cfe200078e00ffULL,
0x0000006e6d6d7212ULL, 0x000fe200078efcffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000003000d7811ULL, 0x002fe400078ff0ffULL, 0x000000040c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000086d0f7824ULL, 0x000fc400078e00ffULL, 0x000008000d0d7824ULL, 0x000fe200078e00ffULL,
0x0000000c030c7211ULL, 0x000fca00078fe0ffULL, 0x000000016d0c7824ULL, 0x000fca00078e020cULL,
0xfffffff80f0c7812ULL, 0x000fca00078ee20cULL, 0x000000100c107824ULL, 0x000fcc00078e020dULL,
0x011000001010783bULL, 0x000e620000000200ULL, 0x0000001064287824ULL, 0x100fe200078e0209ULL,
0x000110000d0d7810ULL, 0x000fe20007ffe004ULL, 0x0000001063507824ULL, 0x100fe200078e0209ULL,
0x000000006838783bULL, 0x000fe20000004200ULL, 0x00000010624c7824ULL, 0x100fe200078e0209ULL,
0x00000002ff047819ULL, 0x000fe20000011600ULL, 0x0000001065487824ULL, 0x000fe200078e0209ULL,
0x000000002828783bULL, 0x000ea20000004200ULL, 0x0000030002027a10ULL, 0x000fe40007ffe0ffULL,
0x0001b6a004047811ULL, 0x000fe200078e18ffULL, 0x000000005050783bULL, 0x000ee80000004200ULL,
0x000000004c4c783bULL, 0x000fe80000004200ULL, 0x000000004848783bULL, 0x000fe80000004200ULL,
0x000000000d0c783bULL, 0x000f280000000200ULL, 0x000000006740783bULL, 0x000f280000004200ULL,
0x000000006934783bULL, 0x000f280000004200ULL, 0x000000006a30783bULL, 0x000f220000004200ULL,
0x0000000610100232ULL, 0x002fc40000000000ULL, 0x0000000612120232ULL, 0x000fe40000000000ULL,
0x0000000711110232ULL, 0x080fe40000000000ULL, 0x0000000713130232ULL, 0x000fce0000000000ULL,
0x00000028102c723cULL, 0x044ff0000000182cULL, 0x000000501014723cULL, 0x008f620000001814ULL,
0x000000060c0c0232ULL, 0x090fe40000000000ULL, 0x000000060e0e0232ULL, 0x000fc40000000000ULL,
0x000000070d0d0232ULL, 0x000fc60000000000ULL, 0x0000002a1028723cULL, 0x000f620000001844ULL,
0x000000070f0f0232ULL, 0x000fce0000000000ULL, 0x00000052103c723cULL, 0x040f70000000183cULL,
0x0000004c1018723cULL, 0x040f700000001818ULL, 0x0000004e101c723cULL, 0x040f70000000181cULL,
0x000000481020723cULL, 0x040f700000001820ULL, 0x0000004a1024723cULL, 0x000f700000001824ULL,
0x000000380c10723cULL, 0x060b700000001814ULL, 0x000000400c2c723cULL, 0x040b70000000182cULL,
0x000000420c28723cULL, 0x040b700000001828ULL, 0x0000003a0c14723cULL, 0x040b70000000183cULL,
0x000000340c18723cULL, 0x040b700000001818ULL, 0x000000360c1c723cULL, 0x040b70000000181cULL,
0x000000300c20723cULL, 0x040b700000001820ULL, 0x000000320c24723cULL, 0x000b620000001824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000005e0200720cULL, 0x000fe20003f06070ULL,
0x0000000004ff7f8cULL, 0x0003d8000c80043fULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff96f000007947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000e620000002500ULL,
0x000000ffff077224ULL, 0x020fe400078e0014ULL, 0x000000ffff067224ULL, 0x000fe400078e0013ULL,
0x000000ffff147224ULL, 0x000fe200078e0012ULL, 0x0000005e0300720cULL, 0x002fda0003f06070ULL,
0x0000032000000947ULL, 0x000fea0003800000ULL, 0x018000000a027810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x00008240000c7802ULL, 0x000fc40000000f00ULL, 0x0000ca8000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000a00057308ULL, 0x000e640000001000ULL,
0xbf80000005027423ULL, 0x002fc8000000000aULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000205027223ULL, 0x000fc40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000f240000000000ULL, 0x00000002ff097819ULL, 0x010fe40000011605ULL,
0x0000000805057811ULL, 0x000fc600078ff0ffULL, 0x00001f0902047589ULL, 0x00cea800000e0000ULL,
0x00001f0502057589ULL, 0x000ee200000e0000ULL, 0x0000002c042c7220ULL, 0x044fe40000410000ULL,
0x0000002d042d7220ULL, 0x040fe40000410000ULL, 0x0000002804287220ULL, 0x040fe40000410000ULL,
0x0000002904297220ULL, 0x000fc40000410000ULL, 0x0000001004107220ULL, 0x040fe40000410000ULL,
0x0000001104117220ULL, 0x040fe40000410000ULL, 0x0000000704077220ULL, 0x040fe40000410000ULL,
0x0000001504157220ULL, 0x040fe40000410000ULL, 0x0000001804187220ULL, 0x040fe40000410000ULL,
0x0000001904197220ULL, 0x000fc40000410000ULL, 0x0000001c041c7220ULL, 0x040fe40000410000ULL,
0x0000001d041d7220ULL, 0x040fe40000410000ULL, 0x0000002004207220ULL, 0x040fe40000410000ULL,
0x0000002104217220ULL, 0x040fe40000410000ULL, 0x0000002404247220ULL, 0x040fe40000410000ULL,
0x0000002504257220ULL, 0x000fc40000410000ULL, 0x0000002e052e7220ULL, 0x048fe40000410000ULL,
0x0000002f052f7220ULL, 0x040fe40000410000ULL, 0x0000002a052a7220ULL, 0x040fe40000410000ULL,
0x0000002b052b7220ULL, 0x040fe40000410000ULL, 0x0000001405147220ULL, 0x040fe40000410000ULL,
0x0000000605067220ULL, 0x000fc40000410000ULL, 0x0000001605167220ULL, 0x040fe40000410000ULL,
0x0000001705177220ULL, 0x040fe40000410000ULL, 0x0000001a051a7220ULL, 0x040fe40000410000ULL,
0x0000001b051b7220ULL, 0x040fe40000410000ULL, 0x0000001e051e7220ULL, 0x040fe40000410000ULL,
0x0000001f051f7220ULL, 0x000fc40000410000ULL, 0x0000002205227220ULL, 0x040fe40000410000ULL,
0x0000002305237220ULL, 0x040fe40000410000ULL, 0x0000002605267220ULL, 0x040fe40000410000ULL,
0x0000002705277220ULL, 0x000fc40000410000ULL, 0x0000000000057919ULL, 0x000ea20000000000ULL,
0x00000010110c723eULL, 0x000fe400000000ffULL, 0x000000202110723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000001c1d0f723eULL, 0x000fc400000000ffULL,
0x00000007150d723eULL, 0x000fe400000000ffULL, 0x000000161715723eULL, 0x000fe400000000ffULL,
0x0000001e1f17723eULL, 0x000fe400000000ffULL, 0x000000140614723eULL, 0x000fe400000000ffULL,
0x00000018190e723eULL, 0x000fe400000000ffULL, 0x000000262719723eULL, 0x000fc400000000ffULL,
0x00000002ff207819ULL, 0x004fe40000011605ULL, 0x0000001a1b16723eULL, 0x000fe400000000ffULL,
0x0000000120047810ULL, 0x040fe20007ffe0ffULL, 0x00000008201d7824ULL, 0x040fe200078e00ffULL,
0x0000000220067810ULL, 0x040fe20007ffe0ffULL, 0x00000008201f7824ULL, 0x040fe200078e00ffULL,
0x0000000520077810ULL, 0x040fe20007ffe0ffULL, 0x0000000820217824ULL, 0x040fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee204ULL, 0x00000008201c7824ULL, 0x040fe200078e00ffULL,
0x0000000320047810ULL, 0x040fe20007ffe0ffULL, 0x0000000820277824ULL, 0x040fe200078e00ffULL,
0x000000222318723eULL, 0x000fe200000000ffULL, 0x0000000820237824ULL, 0x040fe200078e00ffULL,
0x00000006201a7810ULL, 0x040fe20007ffe0ffULL, 0x00000008201b7824ULL, 0x000fe200078e00ffULL,
0x000000242511723eULL, 0x000fc400000000ffULL, 0xfffffff81f1f7812ULL, 0x000fe400078ee206ULL,
0x0000000420067810ULL, 0x000fe40007ffe0ffULL, 0xfffffff821217812ULL, 0x000fe200078ee204ULL,
0x0000100066047824ULL, 0x000fe200078e00ffULL, 0xfffffff81c257812ULL, 0x000fe200078ee207ULL,
0x000008000b077824ULL, 0x000fe200078e00ffULL, 0x0000002a2b13723eULL, 0x000fe400000000ffULL,
0xfffffff827277812ULL, 0x000fe200078ee21aULL, 0x00000004051a7824ULL, 0x040fe200078e00ffULL,
0x00000008052b7811ULL, 0x000fc400078ff0ffULL, 0xfffffff823237812ULL, 0x000fe200078ee206ULL,
0x0000000104067824ULL, 0x000fe200078e0207ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee220ULL,
0x000000082b1e7824ULL, 0x000fe200078e00ffULL, 0x000000282909723eULL, 0x000fe200000000ffULL,
0x0000000820297824ULL, 0x040fe200078e00ffULL, 0xffffffff201c7810ULL, 0x000fe20007ffe0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0206ULL, 0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0206ULL, 0xfffffff829297812ULL, 0x000fe200078ee21cULL,
0x000000101f1f7824ULL, 0x100fe200078e0206ULL, 0xfffffff81e2b7812ULL, 0x000fe200078ee22bULL,
0x0000001021217824ULL, 0x100fe200078e0206ULL, 0x0000002c2d02723eULL, 0x000fe200000000ffULL,
0x0000001023237824ULL, 0x000fe200078e0206ULL, 0x0000002e2f12723eULL, 0x000fe200000000ffULL,
0x000000011b1b7824ULL, 0x000fc400078e021aULL, 0x0000001025257824ULL, 0x100fe400078e0206ULL,
0x000000011a1c7824ULL, 0x040fe200078e021dULL, 0x000000021b007388ULL, 0x0005e20000000800ULL,
0x0000001027277824ULL, 0x100fe400078e0206ULL, 0x000000011a1f7824ULL, 0x040fe200078e021fULL,
0x000000091c007388ULL, 0x000fe20000000800ULL, 0x0000001029297824ULL, 0x100fe400078e0206ULL,
0x000000011a1e7824ULL, 0x000fe200078e0221ULL, 0x0000000c1f007388ULL, 0x000fe20000000800ULL,
0x000000102b2b7824ULL, 0x000fc400078e0206ULL, 0x000000011a237824ULL, 0x040fe200078e0223ULL,
0x0000000d1e007388ULL, 0x000fe20000000800ULL, 0x000000011a207824ULL, 0x040fe400078e0225ULL,
0x000000011a277824ULL, 0x040fe200078e0227ULL, 0x0000000e23007388ULL, 0x000fe20000000800ULL,
0x000000011a227824ULL, 0x040fe400078e0229ULL, 0x000000011a2b7824ULL, 0x000fe200078e022bULL,
0x0000000f20007388ULL, 0x000fe20000000800ULL, 0x00000001701b7824ULL, 0x004fc400078e0205ULL,
0x00000300ff217624ULL, 0x000fe200078e00ffULL, 0x0000001027007388ULL, 0x000fe20000000800ULL,
0x000000101b1a7824ULL, 0x000fc600078e0204ULL, 0x0000001122007388ULL, 0x000fe20000000800ULL,
0x000000012100780cULL, 0x000fc60003f05270ULL, 0x000000122b007388ULL, 0x000fe80000000800ULL,
0x000400131c007388ULL, 0x000fe80000000800ULL, 0x000400141f007388ULL, 0x000fe80000000800ULL,
0x000400151e007388ULL, 0x000fe80000000800ULL, 0x0004001623007388ULL, 0x000fe80000000800ULL,
0x0004001720007388ULL, 0x000fe80000000800ULL, 0x0004001827007388ULL, 0x000fe80000000800ULL,
0x0004001922007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000001a0c7984ULL, 0x000ea80000000c00ULL, 0x000400001a287984ULL, 0x000ee80000000c00ULL,
0x000800001a107984ULL, 0x000f280000000c00ULL, 0x000c00001a2c7984ULL, 0x000e620000000c00ULL,
0x200000ff0f0f7230ULL, 0x004fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff2b2b7230ULL, 0x008fe40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fe40000000000ULL,
0x200000ff29297230ULL, 0x000fc40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x000000130f0f7230ULL, 0x010fe40000000000ULL, 0x000000120e0e7230ULL, 0x000fe40000000000ULL,
0x000000110d0d7230ULL, 0x000fe40000000000ULL, 0x000000100c0c7230ULL, 0x000fe40000000000ULL,
0x0000002f2b2b7230ULL, 0x002fc40000000000ULL, 0x0000002e2a2a7230ULL, 0x000fe20000000000ULL,
0x0000000c1a007388ULL, 0x000fe20000000c00ULL, 0x0000002d29297230ULL, 0x000fe40000000000ULL,
0x0000002c28287230ULL, 0x000fca0000000000ULL, 0x000400281a007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00002a6000008947ULL, 0x000fea0003800000ULL,
0x00000400ff027624ULL, 0x000fe200078e00ffULL, 0x00000000001e7919ULL, 0x000e620000002600ULL,
0x000000401b1d7810ULL, 0x000fc40007ffe0ffULL, 0x0000680002027a24ULL, 0x000fe200078e02ffULL,
0x00000000000f7919ULL, 0x000e680000002700ULL, 0x0000000f020d7811ULL, 0x040fe200078e10ffULL,
0x0000030002027a24ULL, 0x000fe200078e02ffULL, 0x000000001a107984ULL, 0x0004e40000000c00ULL,
0xfffffff00d0d7812ULL, 0x000fe400078ec0ffULL, 0x000400001a147984ULL, 0x0004a60000000c00ULL,
0x0000008002097824ULL, 0x000fc800078e020dULL, 0x0000008002027824ULL, 0x000fca00078e0209ULL,
0x0000007f02027810ULL, 0x000fe20007ffe0ffULL, 0x000004000f1e7a24ULL, 0x002fc600078e021eULL,
0xffffff8002027812ULL, 0x000fe200078ec0ffULL, 0x000003001e0c7a24ULL, 0x000fc600078e02ffULL,
0x00006c00020e7a10ULL, 0x000fe20007f1e0ffULL, 0x000000010c037824ULL, 0x000fc800078e0203ULL,
0x00006d00ff187624ULL, 0x000fe200000e06ffULL, 0x000000010bff7812ULL, 0x000fe4000780f800ULL,
0x0000000e030e7211ULL, 0x000fc800078260ffULL, 0x00000018030f7211ULL, 0x000fe400008f64ffULL,
0x00006c000d1f7a10ULL, 0x000fc60007f3e0ffULL, 0x00000800660e7825ULL, 0x000fc800078e000eULL,
0x00006d00ff207624ULL, 0x000fe400008e06ffULL, 0x000000101b187825ULL, 0x000fc800078e000eULL,
0x000000101d0e7825ULL, 0x000fe200078e000eULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x00000010051b7824ULL, 0x00cfe200078e00ffULL, 0x00000001ff1c7819ULL, 0x000fe20000011605ULL,
0x00000080031a7824ULL, 0x000fe200078e00ffULL, 0x00000019ff037819ULL, 0x000fe40000011603ULL,
0x000000701b1b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c1c1d7812ULL, 0x000fe400078ec0ffULL,
0x00006c001a1c7a10ULL, 0x000fc40007ebe009ULL, 0x0000001f1b1a7210ULL, 0x000fe40007a3e01aULL,
0x0000001c1d1c7210ULL, 0x000fe40007c7e01bULL, 0x00006d00031b7a10ULL, 0x000fe40002fec4ffULL,
0x0000001a1d1a7210ULL, 0x000fe40007fbe0ffULL, 0x00000020ff037210ULL, 0x000fe40000fe4403ULL,
0x0000001bff1d7210ULL, 0x000fc60001fe84ffULL, 0x000000ffff1b7224ULL, 0x000fca00028e0603ULL,
0x000000081a007986ULL, 0x0003e8000c101908ULL, 0x0000000a1c007986ULL, 0x0003e4000c101908ULL,
0x000000ff0500720cULL, 0x00cfe20000705670ULL, 0x0000001018007986ULL, 0x000fe2000c101d08ULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000140e007986ULL, 0x000fe8000c101d08ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff0f7424ULL, 0x000fe200078e00ffULL, 0xffffffff21037810ULL, 0x000fc60007ffe0ffULL,
0x00006c001e0e7625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x000000030e0e79a8ULL, 0x000ea400099ee1c8ULL, 0x000000030e00720cULL, 0x004fc80003f05270ULL,
0x00000001ff087807ULL, 0x002fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000008ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff037984ULL, 0x000ea40000000000ULL,
0x000000ff0300720cULL, 0x004fda0003f05270ULL, 0x000025e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001005007824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe40000011605ULL,
0x0000001f0c0e7211ULL, 0x000fe400078038ffULL, 0x00000070000f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c03037812ULL, 0x000fe400078ec0ffULL, 0x000000200c007211ULL, 0x000fe400000f3cffULL,
0x0000000e030e7210ULL, 0x000fc8000791e00fULL, 0x00000000ff0f7210ULL, 0x000fca00007e24ffULL,
0x000000080e007981ULL, 0x000528000c1e1900ULL, 0x000080080e037981ULL, 0x000522000c1e1900ULL,
0x000000022100780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x000100080e117981ULL, 0x004522000c1e1900ULL, 0x000000042100780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x000180080e137981ULL, 0x004522000c1e1900ULL,
0x000000042100780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x000200080e157981ULL, 0x004522000c1e1900ULL, 0x000000062100780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x000280080e177981ULL, 0x004522000c1e1900ULL,
0x000000062100780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000082100780cULL, 0x004fe20003f06070ULL, 0x000300080e197981ULL, 0x000518000c1e1900ULL,
0x000380080e1b0981ULL, 0x002524000c1e1900ULL, 0x0000000721087810ULL, 0x006fc80007ffe0ffULL,
0x00000003ff087819ULL, 0x000fc80000011608ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x0000000d0c1f7211ULL, 0x040fe200078038ffULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1d7224ULL, 0x010fe200078e0000ULL, 0x00006c001f1f7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff0c0a7211ULL, 0x000fe400000f3cffULL, 0x000007801f1f7810ULL, 0x000fc80007f5e0ffULL,
0x00006d00ff0a7a10ULL, 0x000fc400017e240aULL, 0x0000030010007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000408007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x00000008100e7810ULL, 0x040fe40007ffe0ffULL,
0x00000001100f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001d00007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010050e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011605ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060aULL, 0xfffc80080e1d7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x00000009100e7810ULL, 0x042fe40007ffe0ffULL,
0x00000002100f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000000300007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001005037824ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fc80000011605ULL, 0x0000007003037812ULL, 0x000fc800078ec0ffULL,
0x0000000c030e7812ULL, 0x000fc800078ef80eULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060aULL, 0xfffd00080e037981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a100e7810ULL, 0x042fe40007ffe0ffULL,
0x00000003100f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001100007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010050e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011605ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060aULL, 0xfffd80080e117981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b100e7810ULL, 0x042fe40007ffe0ffULL,
0x00000004100f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001300007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010050e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011605ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060aULL, 0xfffe00080e137981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c100e7810ULL, 0x042fe40007ffe0ffULL,
0x00000005100f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001500007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010050e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011605ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060aULL, 0xfffe80080e157981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d100e7810ULL, 0x042fe40007ffe0ffULL,
0x00000006100f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001700007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010050e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011605ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060aULL, 0xffff00080e177981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e100e7810ULL, 0x042fe40007ffe0ffULL,
0x00000007100f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001900007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010050e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011605ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060aULL, 0xffff80080e197981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f100e7810ULL, 0x002fe40007ffe0ffULL,
0x0000001b00007209ULL, 0x000fe40007810000ULL, 0x000003000e007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010050e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011605ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060aULL, 0x000000080e1b7981ULL, 0x000326000c1e1900ULL,
0x000004001f1f7810ULL, 0x000fe40007f3e0ffULL, 0x0000000810107810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e060aULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000057919ULL, 0x000ea40000000000ULL, 0x0000001005037824ULL, 0x014fe200078e00ffULL,
0x00000001ff087819ULL, 0x000fc80000011605ULL, 0x0000007003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fca00078ec0ffULL, 0x0000000103037824ULL, 0x000fca00078e0208ULL,
0x0000000003007388ULL, 0x0005e40000000800ULL, 0x00006c0002027a10ULL, 0x000fe20007f3e0ffULL,
0x000000010b197824ULL, 0x000fe200078e020cULL, 0x000000070500780cULL, 0x000fe20003f04070ULL,
0x0000080066007824ULL, 0x004fe200078e00ffULL, 0x000000010b087812ULL, 0x002fe200078ec0ffULL,
0x00006d00ff037624ULL, 0x000fe200008e06ffULL, 0x00006c000d0d7a10ULL, 0x000fe20007f5e0ffULL,
0x000020000b0a7824ULL, 0x000fe200078e0204ULL, 0x0000004005157810ULL, 0x000fe20007ffe0ffULL,
0x00001000190e7825ULL, 0x000fe200078e0002ULL, 0x0000006005177810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000020b118824ULL, 0x140fe200078e0266ULL,
0x000000000e0e7210ULL, 0x000fe20007f3e0ffULL, 0x000000020b138824ULL, 0x000fe200078e0266ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000002111c8824ULL, 0x100fe200078e0208ULL,
0x0000080007117812ULL, 0x000fe200078ec0ffULL, 0x00000002131e8824ULL, 0x000fe200078e0208ULL,
0x0000002005137810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x00006c0009077a10ULL, 0x000fe20007f3e0ffULL, 0x0000001005087824ULL, 0x040fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe20000011605ULL, 0x000000010a107824ULL, 0x000fe200078e0211ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00006d00ff167624ULL, 0x000fe200008e06ffULL,
0x0000007008087812ULL, 0x000fe200078ec0ffULL, 0x00000010051f7824ULL, 0x000fe200078e0210ULL,
0x0000000c09097812ULL, 0x000fe200078ec0ffULL, 0x00006d00ff187624ULL, 0x000fe200010e06ffULL,
0x0000000719228211ULL, 0x000fe200078238ffULL, 0x0000001013107825ULL, 0x100fe200078e000eULL,
0x0000000d191a8211ULL, 0x040fe200078438ffULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000001619238211ULL, 0x000fe200008f3cffULL, 0x0000001015127825ULL, 0x000fe200078e000eULL,
0x000003000b007a0cULL, 0x000fe20003f26070ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000018191b8211ULL, 0x000fe200010f3cffULL, 0x00000001081d7824ULL, 0x000fe200078e0209ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000001017147825ULL, 0x100fe200078e000eULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000001d177984ULL, 0x0002a20000000800ULL, 0x00000010050e7825ULL, 0x000fe200078e000eULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fc4000001ff00ULL,
0x000000081c1c8824ULL, 0x100fe200078e0205ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000e1f7faeULL, 0x0007e2000b901c48ULL, 0x000000081e1e8824ULL, 0x000fe400078e0205ULL,
0x0000001005228825ULL, 0x000fe200078e0022ULL, 0x000045801c258811ULL, 0x000fe200078e20ffULL,
0x00380000101f7faeULL, 0x0009e2000b901c48ULL, 0x000041801e278811ULL, 0x000fe200078e20ffULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x002fe2000001ff00ULL,
0x00580000121f7faeULL, 0x0009e2000b901c48ULL, 0x000000ffff387224ULL, 0x000fc400078e00ffULL,
0x00000010050e8825ULL, 0x008fe200078e001aULL, 0x00780000141f7faeULL, 0x0009e2000b901c48ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x000000ffff3a7224ULL, 0x000fe200078e00ffULL,
0x0000000022258faeULL, 0x0003e8000b901c48ULL, 0x000000000e278faeULL, 0x0007e8000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000001e7805ULL, 0x010fe2000001ff00ULL,
0x0000000000227805ULL, 0x002fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x008fe2000001ff00ULL, 0x00000c6000001947ULL, 0x000fea0003800000ULL,
0x000000ffff197224ULL, 0x004fe400078e00ffULL, 0x000000ffff397224ULL, 0x000fca00078e000bULL,
0x00000001390f7810ULL, 0x000fc80007ffe0ffULL, 0x000003000f007a0cULL, 0x000fda0003f06070ULL,
0x0000028000000947ULL, 0x000fea0003800000ULL, 0x000000070500780cULL, 0x000fe20003f44070ULL,
0x000000010c3f7824ULL, 0x000fe200078e020fULL, 0x000000010f0e7812ULL, 0x000fe400078ec0ffULL,
0x0000004005157810ULL, 0x000fe20007ffe0ffULL, 0x000010003f087825ULL, 0x000fca00078e0002ULL,
0x0000000008107210ULL, 0x000fe20007f1e0ffULL, 0x000008000f087824ULL, 0x000fe400078e00ffULL,
0x000000020b11a824ULL, 0x140fe400078e0266ULL, 0x000000020b13a824ULL, 0x000fe400078e0266ULL,
0x00000002113ea824ULL, 0x100fe400078e020eULL, 0x000000ffff117224ULL, 0x000fe200000e0609ULL,
0x0000080008097812ULL, 0x000fe200078ec0ffULL, 0x000000021340a824ULL, 0x000fe200078e020eULL,
0x0000002005137810ULL, 0x040fe20007ffe0ffULL, 0x00000010053c7825ULL, 0x000fe200078e0010ULL,
0x000000073f0ea211ULL, 0x000fc400078038ffULL, 0x0000000d3f08a211ULL, 0x000fe200078238ffULL,
0x000000010a127824ULL, 0x000fe200078e0209ULL, 0x0000006005097810ULL, 0x000fe20007ffe0ffULL,
0x0000001015147825ULL, 0x000fe200078e0010ULL, 0x000000163f0fa211ULL, 0x000fc600000f3cffULL,
0x00000010053b7824ULL, 0x000fe400078e0212ULL, 0x0000001013127825ULL, 0x000fc600078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800003c3b7faeULL, 0x0003e2000b901c48ULL,
0x0000001009107825ULL, 0x000fe200078e0010ULL, 0x000000183f09a211ULL, 0x000fe400008f3cffULL,
0x00380000123b7faeULL, 0x0003e2000b901c48ULL, 0x000000083e3ea824ULL, 0x100fe400078e0205ULL,
0x000000084040a824ULL, 0x000fe200078e0205ULL, 0x00580000143b7faeULL, 0x0003e2000b901c48ULL,
0x00000010050ea825ULL, 0x000fe200078e000eULL, 0x000045803e3fa811ULL, 0x000fc400078e20ffULL,
0x000041804041a811ULL, 0x000fe200078e20ffULL, 0x000000100508a825ULL, 0x000fe200078e0008ULL,
0x00780000103b7faeULL, 0x0003e8000b901c48ULL, 0x000000000e3fafaeULL, 0x0003e8000b901c48ULL,
0x000000000841afaeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000008039087824ULL, 0x002fe200078e00ffULL, 0x00000001ff107819ULL, 0x100fe20000011605ULL,
0x000000020b0f7824ULL, 0x000fe200078e0266ULL, 0x00000002ff447819ULL, 0x000fe20000011605ULL,
0x0000001005097824ULL, 0x000fe200078e00ffULL, 0x0000008008087812ULL, 0x000fc400078ec0ffULL,
0x0000000244117810ULL, 0x040fe20007ffe0ffULL, 0x0000000844147824ULL, 0x040fe200078e00ffULL,
0x0000000844487810ULL, 0x040fe20007ffe0ffULL, 0x000001000f0e7824ULL, 0x000fe200078e0008ULL,
0x0000007009087812ULL, 0x000fe200078ec0ffULL, 0x00000008443e7824ULL, 0x000fe200078e00ffULL,
0x0000000c10097812ULL, 0x000fe200078ec0ffULL, 0x0000000844427824ULL, 0x040fe200078e00ffULL,
0x00000001440f7810ULL, 0x040fe20007ffe0ffULL, 0x00000008444a7824ULL, 0x000fe200078e00ffULL,
0x0000000e09107210ULL, 0x000fe20007ffe008ULL, 0x00000800390e7824ULL, 0x000fe200078e00ffULL,
0xfffffff814137812ULL, 0x000fe200078ee20fULL, 0x00000008443f7824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3b7812ULL, 0x000fe200078ee211ULL, 0x0000000844117824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800010127984ULL, 0x000e620000000800ULL,
0x000008000e0f7812ULL, 0x000fe200078ec0ffULL, 0x00000004050e7824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee244ULL, 0x00458000103c7984ULL, 0x0004e20000000800ULL,
0x00000003443d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c0e467812ULL, 0x000fe400078ec0ffULL,
0xfffffff8423d7812ULL, 0x000fe400078ee23dULL, 0x00000004443e7810ULL, 0x000fc40007ffe0ffULL,
0x000001800a107810ULL, 0x004fe20007ffe00fULL, 0x00000008480f7824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe400078ee23eULL, 0xffffffff443e7810ULL, 0x000fe20007ffe0ffULL,
0x00000010110e7824ULL, 0x000fe200078e0210ULL, 0xfffffff80f0f7812ULL, 0x000fe400078ee248ULL,
0x0000000239397810ULL, 0x000fe20007ffe0ffULL, 0x00000001460e7824ULL, 0x000fe400078e020eULL,
0x000000100f0f7824ULL, 0x000fe200078e0210ULL, 0x0000030039007a0cULL, 0x000fc40003f06070ULL,
0x000000000e117984ULL, 0x000ea20000000800ULL, 0x0000000146147824ULL, 0x000fe400078e020fULL,
0x00000010130f7824ULL, 0x100fe200078e0210ULL, 0x0000000544137810ULL, 0x000fe40007ffe0ffULL,
0x0000000014407984ULL, 0x000f220000000800ULL, 0x00000001460f7824ULL, 0x000fe200078e020fULL,
0xfffffff84a437812ULL, 0x000fe200078ee213ULL, 0x000000103b137824ULL, 0x000fe200078e0210ULL,
0x00000006443b7810ULL, 0x000fc40007ffe0ffULL, 0x000400000f417984ULL, 0x000fe20000000800ULL,
0x0000001217127221ULL, 0x002fe40000010100ULL, 0x0000000146137824ULL, 0x000fe400078e0213ULL,
0x3fb8aa3b12127820ULL, 0x000fc60000410000ULL, 0x0000000013147984ULL, 0x000fe20000000800ULL,
0x0000001200157308ULL, 0x0002e60000000800ULL, 0x0004000013427984ULL, 0x0005e80000000800ULL,
0x000000000f127984ULL, 0x002fe20000000800ULL, 0x0000003c15457220ULL, 0x008fe40000410000ULL,
0x00000008443c7824ULL, 0x040fe200078e00ffULL, 0x20000011ff137230ULL, 0x004fe20000004100ULL,
0x000000103d157824ULL, 0x100fe200078e0210ULL, 0x00001f44450e7589ULL, 0x000e6200000e0000ULL,
0x00000008443d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c477812ULL, 0x000fe200078ee23bULL,
0x0000000146157824ULL, 0x040fe200078e0215ULL, 0x00001f48450f7589ULL, 0x0004e200000e0000ULL,
0x000000103f3c7824ULL, 0x000fe200078e0210ULL, 0xfffffff83d3f7812ULL, 0x000fe200078ee23eULL,
0x00000010433d7824ULL, 0x000fe200078e0210ULL, 0x00000000153b7984ULL, 0x000ee20000000800ULL,
0x00000001463c7824ULL, 0x000fc400078e023cULL, 0x00000010473e7824ULL, 0x100fe200078e0210ULL,
0x0004000015437984ULL, 0x000ee20000000800ULL, 0x000000103f3f7824ULL, 0x000fe400078e0210ULL,
0x00000001463d7824ULL, 0x040fe200078e023dULL, 0x000000003c107984ULL, 0x000ee20000000800ULL,
0x00000001463e7824ULL, 0x040fe400078e023eULL, 0x00000001463f7824ULL, 0x000fe200078e023fULL,
0x20000040ff467230ULL, 0x110fe20000004100ULL, 0x0000003a453a7221ULL, 0x000fe20000010000ULL,
0x30000011ff457230ULL, 0x004fe20000004100ULL, 0x000400003d157984ULL, 0x000ea20000000800ULL,
0x30000040ff407230ULL, 0x000fe20000004100ULL, 0x0000000e131a7223ULL, 0x002fc4000001001aULL,
0x000000003d117984ULL, 0x000e620000000800ULL, 0x0000000e45307223ULL, 0x080fe20000010030ULL,
0x30000012ff457230ULL, 0x100fe20000004100ULL, 0x0000000f402f7223ULL, 0x088fe2000001002fULL,
0x000400003c447984ULL, 0x000ee20000000800ULL, 0x20000012ff407230ULL, 0x000fe20000004100ULL,
0x0000000f46227223ULL, 0x080fe20000010022ULL, 0x20000041ff127230ULL, 0x100fe20000004100ULL,
0x000400003e3c7984ULL, 0x000f220000000800ULL, 0x30000041ff417230ULL, 0x000fe20000004100ULL,
0x0000000e401f7223ULL, 0x000fe2000001001fULL, 0x20000014ff407230ULL, 0x000fe20000004100ULL,
0x000000003e137984ULL, 0x0005220000000800ULL, 0x0000000f122d7223ULL, 0x000fc4000001002dULL,
0x0000000f412c7223ULL, 0x080fe2000001002cULL, 0x000000003f127984ULL, 0x000f220000000800ULL,
0x30000014ff417230ULL, 0x000fe20000004100ULL, 0x0000000e452e7223ULL, 0x080fe2000001002eULL,
0x20000042ff457230ULL, 0x100fe20000004100ULL, 0x000400003f3d7984ULL, 0x000f220000000800ULL,
0x2000003bff147230ULL, 0x100fe20000004100ULL, 0x0000000e402b7223ULL, 0x080fe2000001002bULL,
0x3000003bff3b7230ULL, 0x000fe20000004100ULL, 0x0000000e41387223ULL, 0x080fe20000010038ULL,
0x20000043ff3e7230ULL, 0x104fe20000004100ULL, 0x0000000e14377223ULL, 0x080fe20000010037ULL,
0x30000042ff427230ULL, 0x000fe20000004100ULL, 0x0000000e3b367223ULL, 0x080fe20000010036ULL,
0x20000010ff147230ULL, 0x100fe20000004100ULL, 0x0000000f452a7223ULL, 0x080fe2000001002aULL,
0x30000010ff107230ULL, 0x000fe20000004100ULL, 0x0000000f42297223ULL, 0x000fe20000010029ULL,
0x30000043ff437230ULL, 0x000fe20000004100ULL, 0x0000000e14277223ULL, 0x000fc40000010027ULL,
0x0000000e10257223ULL, 0x080fe20000010025ULL, 0x20000015ff107230ULL, 0x100fe20000004100ULL,
0x0000000f3e267223ULL, 0x080fe20000010026ULL, 0x30000015ff157230ULL, 0x000fe20000004100ULL,
0x0000000f43287223ULL, 0x080fe20000010028ULL, 0x20000011ff3b7230ULL, 0x102fe20000004100ULL,
0x0000000f10337223ULL, 0x080fe20000010033ULL, 0x30000011ff117230ULL, 0x000fe20000004100ULL,
0x0000000f15327223ULL, 0x080fe20000010032ULL, 0x20000044ff147230ULL, 0x108fe20000004100ULL,
0x0000000e3b247223ULL, 0x080fe20000010024ULL, 0x30000044ff447230ULL, 0x000fe20000004100ULL,
0x0000000e11237223ULL, 0x080fe20000010023ULL, 0x2000003cff117230ULL, 0x110fe20000004100ULL,
0x0000000f14357223ULL, 0x080fe20000010035ULL, 0x3000003cff3c7230ULL, 0x000fe20000004100ULL,
0x0000000f44347223ULL, 0x080fe20000010034ULL, 0x20000013ff107230ULL, 0x100fe20000004100ULL,
0x0000000f11207223ULL, 0x080fe20000010020ULL, 0x30000013ff137230ULL, 0x000fe20000004100ULL,
0x0000000f3c317223ULL, 0x000fe20000010031ULL, 0x20000012ff117230ULL, 0x100fe20000004100ULL,
0x0000000e101b7223ULL, 0x080fe2000001001bULL, 0x30000012ff127230ULL, 0x000fe20000004100ULL,
0x0000000e13217223ULL, 0x080fe20000010021ULL, 0x2000003dff107230ULL, 0x100fe20000004100ULL,
0x0000000e111e7223ULL, 0x080fe2000001001eULL, 0x3000003dff147230ULL, 0x000fe20000004100ULL,
0x0000000e121d7223ULL, 0x000fc4000001001dULL, 0x0000000f101c7223ULL, 0x080fe4000001001cULL,
0x0000000f14197223ULL, 0x000fe20000010019ULL, 0xfffff3c000008947ULL, 0x000fea000383ffffULL,
0x000000ff6600720cULL, 0x004fe20003f05270ULL, 0x0000017000007945ULL, 0x000fd80003800000ULL,
0x000000800b008824ULL, 0x000fe400078e0208ULL, 0x0000000108087824ULL, 0x000fe400078e0209ULL,
0x0000000109038824ULL, 0x000fca00078e0200ULL, 0x0049803a03008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0049800008007984ULL, 0x000e680000000800ULL,
0x004a000008057984ULL, 0x000ea20000000800ULL, 0x00000000ff007221ULL, 0x002fc80000010000ULL,
0x0000000500007221ULL, 0x004fca0000010000ULL, 0x0180000000027810ULL, 0x000fc80007ffe0ffULL,
0x7f80000002027812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0000ULL, 0x0000ad30000c7802ULL, 0x000fc40000000f00ULL,
0x00009f9000007944ULL, 0x000fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000000037308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc80000000003ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000203027223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000f280000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000008050f7811ULL, 0x010fc400078ff0ffULL,
0x00000002ff0d7819ULL, 0x000fc60000011605ULL, 0x00001f0f02077589ULL, 0x00cea200000e0000ULL,
0x000000040d0e7810ULL, 0x040fe20007ffe0ffULL, 0x000000080d137824ULL, 0x040fe200078e00ffULL,
0x000000020d0a7810ULL, 0x042fe20007ffe0ffULL, 0x00001f0d02007589ULL, 0x000e6200000e0000ULL,
0x000000080d157824ULL, 0x040fe200078e00ffULL, 0x000000030d0c7810ULL, 0x040fe20007ffe0ffULL,
0x000000080d177824ULL, 0x040fe400078e00ffULL, 0x000000080d397824ULL, 0x000fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fc400078ee20aULL, 0xfffffff817177812ULL, 0x000fe400078ee20cULL,
0x000000060d0a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001015157824ULL, 0x100fe200078e0206ULL,
0xffffffff0d0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001017177824ULL, 0x000fe400078e0206ULL,
0x0000002207227220ULL, 0x044fe40000410000ULL, 0x0000002f072f7220ULL, 0x040fe40000410000ULL,
0x0000002d072d7220ULL, 0x000fc40000410000ULL, 0x0000002c072c7220ULL, 0x000fe20000410000ULL,
0x000000222f22723eULL, 0x000fe200000000ffULL, 0x0000002a072a7220ULL, 0x040fe40000410000ULL,
0x0000002907297220ULL, 0x040fe20000410000ULL, 0x0000002d2c2c723eULL, 0x000fe200000000ffULL,
0x0000002607267220ULL, 0x040fe40000410000ULL, 0x0000002807097220ULL, 0x000fe20000410000ULL,
0x0000002a2929723eULL, 0x000fe200000000ffULL, 0x0000003507357220ULL, 0x000fc40000410000ULL,
0x0000003407347220ULL, 0x000fe20000410000ULL, 0x000000260909723eULL, 0x000fe200000000ffULL,
0x0000003307337220ULL, 0x040fe40000410000ULL, 0x0000003207327220ULL, 0x040fe20000410000ULL,
0x000000353434723eULL, 0x000fe200000000ffULL, 0x0000002007207220ULL, 0x040fe40000410000ULL,
0x0000003107317220ULL, 0x040fe20000410000ULL, 0x000000333232723eULL, 0x000fe200000000ffULL,
0x0000001c071c7220ULL, 0x000fc40000410000ULL, 0x0000001907077220ULL, 0x000fe20000410000ULL,
0x000000203120723eULL, 0x000fe200000000ffULL, 0x000000080d197824ULL, 0x000fe400078e00ffULL,
0x0000001a001a7220ULL, 0x042fe20000410000ULL, 0x0000001c0707723eULL, 0x000fe200000000ffULL,
0x0000003000037220ULL, 0x040fe20000410000ULL, 0xfffffff819197812ULL, 0x000fe200078ee20eULL,
0x0000001f001f7220ULL, 0x040fe40000410000ULL, 0x0000002e002e7220ULL, 0x040fe20000410000ULL,
0x0000001a0303723eULL, 0x000fe200000000ffULL, 0x0000002b002b7220ULL, 0x000fc40000410000ULL,
0x0000003800387220ULL, 0x000fe20000410000ULL, 0x0000001f2e1f723eULL, 0x000fe200000000ffULL,
0x0000003700377220ULL, 0x040fe40000410000ULL, 0x0000003600367220ULL, 0x000fe20000410000ULL,
0x0000002b382b723eULL, 0x000fe200000000ffULL, 0x0000002700277220ULL, 0x040fe40000410000ULL,
0x0000002500087220ULL, 0x000fe20000410000ULL, 0x000000373636723eULL, 0x000fe200000000ffULL,
0x0000002400247220ULL, 0x000fc40000410000ULL, 0x0000002300237220ULL, 0x000fe20000410000ULL,
0x000000270808723eULL, 0x000fe200000000ffULL, 0x0000001b001b7220ULL, 0x040fe40000410000ULL,
0x0000002100027220ULL, 0x040fe20000410000ULL, 0x000000242323723eULL, 0x000fe200000000ffULL,
0x0000001e001e7220ULL, 0x040fe40000410000ULL, 0x0000001d001d7220ULL, 0x000fe20000410000ULL,
0x000000010d007810ULL, 0x040fe20007ffe0ffULL, 0x000000080d0e7824ULL, 0x040fe200078e00ffULL,
0x0000001b0202723eULL, 0x000fe200000000ffULL, 0x000000080d217824ULL, 0x000fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee200ULL, 0x000000080d257824ULL, 0x040fe200078e00ffULL,
0x000000050d007810ULL, 0x000fe20007ffe0ffULL, 0x0000001019197824ULL, 0x000fe200078e0206ULL,
0xfffffff80e117812ULL, 0x000fe200078ee20dULL, 0x000000080f0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8210d7812ULL, 0x000fe200078ee200ULL, 0x0000000405007824ULL, 0x000fe200078e00ffULL,
0xfffffff825217812ULL, 0x000fe200078ee20aULL, 0x0000001011117824ULL, 0x000fe200078e0206ULL,
0xfffffff839257812ULL, 0x000fe200078ee20cULL, 0x0000001013137824ULL, 0x100fe200078e0206ULL,
0xfffffff80e397812ULL, 0x000fe200078ee20fULL, 0x000000100d0d7824ULL, 0x100fe200078e0206ULL,
0x0000000c00007812ULL, 0x000fe200078ec0ffULL, 0x00000010210f7824ULL, 0x100fe200078e0206ULL,
0x0000001e1d1d723eULL, 0x000fe200000000ffULL, 0x00000010251b7824ULL, 0x000fc400078e0206ULL,
0x0000001039397824ULL, 0x000fe400078e0206ULL, 0x0000000111067824ULL, 0x000fe400078e0200ULL,
0x0000000100137824ULL, 0x040fe400078e0213ULL, 0x00000001000a7824ULL, 0x040fe200078e0215ULL,
0x0000000306007388ULL, 0x0003e20000000800ULL, 0x00000001001c7824ULL, 0x040fe400078e0217ULL,
0x0000000100217824ULL, 0x040fe200078e0219ULL, 0x0000001f13007388ULL, 0x000fe20000000800ULL,
0x00000001001e7824ULL, 0x000fc400078e020dULL, 0x0000000100257824ULL, 0x040fe200078e020fULL,
0x0000002b0a007388ULL, 0x000fe20000000800ULL, 0x0000000100247824ULL, 0x040fe400078e021bULL,
0x0000000100397824ULL, 0x000fe200078e0239ULL, 0x000000361c007388ULL, 0x000fe20000000800ULL,
0x0000000170037824ULL, 0x002fc600078e0205ULL, 0x0000000821007388ULL, 0x000fe20000000800ULL,
0x0000001003037824ULL, 0x000fc600078e0204ULL, 0x000000231e007388ULL, 0x000fe80000000800ULL,
0x0000000225007388ULL, 0x000fe80000000800ULL, 0x0000001d24007388ULL, 0x000fe80000000800ULL,
0x0000002239007388ULL, 0x000fe80000000800ULL, 0x0004002c13007388ULL, 0x000fe80000000800ULL,
0x000400290a007388ULL, 0x000fe80000000800ULL, 0x000400091c007388ULL, 0x000fe80000000800ULL,
0x0004003421007388ULL, 0x000fe80000000800ULL, 0x000400321e007388ULL, 0x000fe80000000800ULL,
0x0004002025007388ULL, 0x000fe80000000800ULL, 0x0004000724007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000030c7984ULL, 0x000e680000000c00ULL,
0x0004000003147984ULL, 0x000ea80000000c00ULL, 0x0008000003107984ULL, 0x000ee80000000c00ULL,
0x000c000003187984ULL, 0x000f220000000c00ULL, 0x200000ff0f0f7230ULL, 0x002fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x004fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x000000130f0f7230ULL, 0x008fe40000000000ULL,
0x000000120e0e7230ULL, 0x000fe40000000000ULL, 0x000000110d0d7230ULL, 0x000fe40000000000ULL,
0x000000100c0c7230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x010fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000c03007388ULL, 0x000fe20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001403007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fc80000011605ULL, 0x000000740000720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x0000000100027824ULL, 0x000fe200078e0205ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x0000001075007824ULL, 0x000fe200078e0200ULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x00005a0073737a19ULL, 0x000fe200000006ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x0000580000067ab9ULL, 0x000fe20000000800ULL,
0x00000020050d7810ULL, 0x000fc40007ffe0ffULL, 0x0ffffff802037812ULL, 0x000fe400078ef805ULL,
0x0000000500067c12ULL, 0x000fe4000f8e30ffULL, 0x0000000705077812ULL, 0x000fe200078ec0ffULL,
0x0000001003027824ULL, 0x000fe200078e0204ULL, 0x00005a00ff037a19ULL, 0x000fe20000011600ULL,
0x0000000173067824ULL, 0x000fe400078e0206ULL, 0x0000000866077824ULL, 0x000fe200078e0207ULL,
0x0000000002087984ULL, 0x0022e20000000c00ULL, 0x0000007603037224ULL, 0x000fe200078e0206ULL,
0x00000006040472a4ULL, 0x004fcc000f8e023fULL, 0x0000000476007c24ULL, 0x000fca000f8e02ffULL,
0x0000000300037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x002fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fe400000f4406ULL,
0x00000003ff067819ULL, 0x000fc6000001160dULL, 0x0000001007027825ULL, 0x000fe200078e0002ULL,
0x000000740600720cULL, 0x000fc80003f06070ULL, 0x0000000802007986ULL, 0x0083f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d027824ULL, 0x102fe200078e0206ULL,
0x00000040050f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001075067824ULL, 0x000fc600078e0206ULL,
0x0000000702027812ULL, 0x000fc800078ec0ffULL, 0x0ffffff802037812ULL, 0x000fe400078ef80dULL,
0x0000000506027c12ULL, 0x000fe4000f8e30ffULL, 0x000000070d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000001003077824ULL, 0x000fe200078e0204ULL, 0x00005a00ff037a19ULL, 0x000fe20000011606ULL,
0x0000000173027824ULL, 0x000fe400078e0202ULL, 0x00000008660d7824ULL, 0x000fe200078e020dULL,
0x0000000007087984ULL, 0x000e620000000c00ULL, 0x0000007603037224ULL, 0x000fca00078e0202ULL,
0x0000000300037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fe400000f4406ULL,
0x00000003ff067819ULL, 0x000fc6000001160fULL, 0x000000100d027825ULL, 0x000fe200078e0002ULL,
0x000000740600720cULL, 0x000fc80003f06070ULL, 0x0000000802007986ULL, 0x0023f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010f027824ULL, 0x102fe200078e0206ULL,
0x00000060050d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001075067824ULL, 0x000fe200078e0206ULL,
0x000000070f057812ULL, 0x000fc400078ec0ffULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000000866057824ULL, 0x000fe200078e0205ULL, 0x0ffffff802037812ULL, 0x000fe400078ef80fULL,
0x0000000506027c12ULL, 0x000fc6000f8e30ffULL, 0x0000001003077824ULL, 0x000fe200078e0204ULL,
0x00005a00ff037a19ULL, 0x000fe20000011606ULL, 0x0000000173027824ULL, 0x000fe200078e0202ULL,
0x00000003ff067819ULL, 0x000fe4000001160dULL, 0x0000000007087984ULL, 0x0002a20000000c00ULL,
0x0000007603037224ULL, 0x000fca00078e0202ULL, 0x0000000300037210ULL, 0x000fe20007f1e0ffULL,
0x000000010d077824ULL, 0x002fc800078e0206ULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fe400078040ffULL, 0x0000000707077812ULL, 0x000fe400078ec0ffULL,
0x00005d0003037a11ULL, 0x000fe400000f440cULL, 0x000000740600720cULL, 0x000fe40003f06070ULL,
0xfffffff807077812ULL, 0x000fe200078ef80dULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x0043ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001007077824ULL, 0x000fe200078e0204ULL, 0x000000070d057812ULL, 0x000fe200078ec0ffULL,
0x0000001075067824ULL, 0x000fc600078e0206ULL, 0x0000000007087984ULL, 0x002e620000000c00ULL,
0x0000000866057824ULL, 0x000fe200078e0205ULL, 0x0000000506027c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff037a19ULL, 0x000fc60000011606ULL, 0x0000000173027824ULL, 0x000fc800078e0202ULL,
0x0000007603037224ULL, 0x000fca00078e0202ULL, 0x0000000300037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fca00000f4400ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000102077810ULL, 0x000fe20007ffe0ffULL,
0x000000020c687824ULL, 0x000fe200078e00ffULL, 0x01b60000ff047f8cULL, 0x002e62000c80043fULL,
0x0000004000727824ULL, 0x000fe200078e00ffULL, 0x0000005e0700720cULL, 0x000fe20003f06070ULL,
0x0000590068687a24ULL, 0x000fe400078e0273ULL, 0x0000010002077824ULL, 0x000fc800078e0272ULL,
0x0000660068087a24ULL, 0x000fcc00078e0207ULL, 0x00000c7000008947ULL, 0x000fea0003800000ULL,
0x000000076c097217ULL, 0x000fe40007800000ULL, 0x00000003ff147819ULL, 0x000fc60000011603ULL,
0x0000000109097824ULL, 0x000fe200078e0a07ULL, 0x00000004140c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001080a7824ULL, 0x000fe200078e0214ULL, 0x00000008140e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000114157824ULL, 0x100fe200078e0203ULL, 0x000000090c00720cULL, 0x0c0fe20003fa6070ULL,
0x000000010c077824ULL, 0x100fe200078e0203ULL, 0x0000000c14107810ULL, 0x000fe20007ffe0ffULL,
0x000000080c227824ULL, 0x000fe200078e00ffULL, 0x0000001014127810ULL, 0x000fe20007ffe0ffULL,
0x00000001080c7824ULL, 0x000fe200078e020cULL, 0x000000091000720cULL, 0x000fe20003f46070ULL,
0x000000010e0b7824ULL, 0x000fe200078e0203ULL, 0xfffffff822227812ULL, 0x000fe200078ee207ULL,
0x000000080e2a7824ULL, 0x000fe200078e00ffULL, 0x00000014141e7810ULL, 0x000fe20007ffe0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000001814287810ULL, 0x000fc40007ffe0ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee20bULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x100fe400078ef806ULL, 0x0000001c14347810ULL, 0x000fe20007ffe0ffULL,
0x0000000110077824ULL, 0x100fe200078e0203ULL, 0x000062000c0c7a10ULL, 0x000fe20007f3e0ffULL,
0x00000008102c7824ULL, 0x000fe200078e00ffULL, 0x000000700a0a7812ULL, 0x000fe200078ef806ULL,
0x00000001120f7824ULL, 0x040fe200078e0203ULL, 0x000063000d0d7a10ULL, 0x000fe20000ffe4ffULL,
0x00000008122e7824ULL, 0x000fe200078e00ffULL, 0x000062000a0a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000108107824ULL, 0x000fe200078e0210ULL, 0x000000090e00720cULL, 0x000fe20003f26070ULL,
0x00000001080e7824ULL, 0x000fe200078e020eULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee20fULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x000063000b0b7a10ULL, 0x000fc400007fe4ffULL,
0x000000091200720cULL, 0x000fe20003f06070ULL, 0x00000001081a7824ULL, 0x000fe200078e021eULL,
0x0000007010187812ULL, 0x000fe200078ef806ULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe400078ee207ULL, 0x0000620018187a10ULL, 0x000fe20007f9e0ffULL,
0x0000000108127824ULL, 0x000fe200078e0212ULL, 0x000000700e167812ULL, 0x000fe200078ef806ULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x0000630011197a10ULL, 0x000fc400027fe4ffULL,
0x0000620016167a10ULL, 0x000fe20007f7e0ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000701a107812ULL, 0x000fe400078ef806ULL, 0x000063000f177a10ULL, 0x000fe20001ffe4ffULL,
0x00000001081c7824ULL, 0x000fe200078e0228ULL, 0x00000070120e7812ULL, 0x000fe200078ef806ULL,
0x000000081e307824ULL, 0x000fe200078e00ffULL, 0x0000620010107a10ULL, 0x000fe20007f9e0ffULL,
0x000001001c1c7825ULL, 0x000fe200078e00ffULL, 0x000062000e0e7a10ULL, 0x000fc40007f7e0ffULL,
0x000063001b117a10ULL, 0x000fe200027fe4ffULL, 0x00000001081a7824ULL, 0x000fe200078e0234ULL,
0x000000701c127812ULL, 0x000fe200078ef806ULL, 0x0000000128237824ULL, 0x100fe200078e0203ULL,
0x00000007151c7812ULL, 0x000fe200078ec0ffULL, 0x000000011e157824ULL, 0x000fe200078e0203ULL,
0x000000091400720cULL, 0x080fe20003f86070ULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x00006300130f7a10ULL, 0x000fe40001ffe4ffULL, 0x000000091e00720cULL, 0x000fe20003f66070ULL,
0x0000000828327824ULL, 0x000fe200078e00ffULL, 0x0000100000077811ULL, 0x000fc400078e70ffULL,
0x0ffffff81c1e7812ULL, 0x000fe400078ef803ULL, 0xfffffff830307812ULL, 0x000fe400078ee215ULL,
0x0000002814267810ULL, 0x000fe20007ffe0ffULL, 0x000000101e157824ULL, 0x000fe200078e0207ULL,
0x0000002014207810ULL, 0x000fe40007ffe0ffULL, 0x0000620012127a10ULL, 0x000fe20007fde0ffULL,
0x0000000108217824ULL, 0x040fe200078e0226ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a157faeULL, 0x0005e2000e101c48ULL, 0x00000001081c7824ULL, 0x000fe200078e0220ULL,
0x0000002414247810ULL, 0x000fc40007ffe0ffULL, 0x000063001d137a10ULL, 0x000fe200037fe4ffULL,
0x000001001c1c7825ULL, 0x000fe200078e00ffULL, 0x000000701a1a7812ULL, 0x000fe400078ef806ULL,
0x000000092800720cULL, 0x000fe20003f86070ULL, 0x00000001081e7824ULL, 0x000fe200078e0224ULL,
0x000062001a1a7a10ULL, 0x000fe20007fde0ffULL, 0x0000000824257824ULL, 0x000fe200078e00ffULL,
0x000000701c1c7812ULL, 0x000fe200078ef806ULL, 0x0000001022157824ULL, 0x004fe200078e0207ULL,
0x0000002c14287810ULL, 0x000fe20007ffe0ffULL, 0x00000100210a7825ULL, 0x000fe200078e00ffULL,
0x000063001b1b7a10ULL, 0x000fc400037fe4ffULL, 0x000000000c157faeULL, 0x0005e2000e901c48ULL,
0x000000093400720cULL, 0x0c0fe20003fa6070ULL, 0x0000000134217824ULL, 0x000fe200078e0203ULL,
0x000062001c1c7a10ULL, 0x000fe20007fde0ffULL, 0x0000000834347824ULL, 0x000fe200078e00ffULL,
0xfffffff832327812ULL, 0x000fe200078ee223ULL, 0x000001001e1e7825ULL, 0x000fe200078e00ffULL,
0x000063001d1d7a10ULL, 0x000fe400037fe4ffULL, 0xfffffff834347812ULL, 0x000fe200078ee221ULL,
0x000000102a217824ULL, 0x100fe200078e0207ULL, 0x000000701e1e7812ULL, 0x100fe200078ef806ULL,
0x000000102c157824ULL, 0x004fe200078e0207ULL, 0x000000700a0a7812ULL, 0x000fe200078ef806ULL,
0x00000001080c7824ULL, 0x000fe200078e0228ULL, 0x0000000016217faeULL, 0x0005e2000c901c48ULL,
0x000000092000720cULL, 0x040fe20003f26070ULL, 0x0000000120227824ULL, 0x100fe200078e0203ULL,
0x000062001e1e7a10ULL, 0x000fe20007fde0ffULL, 0x0000000820237824ULL, 0x000fe200078e00ffULL,
0x0000000018157faeULL, 0x0007e2000d101c48ULL, 0x0000000124207824ULL, 0x000fe200078e0203ULL,
0x000063001f1f7a10ULL, 0x000fe200037fe4ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x000062000a0a7a10ULL, 0x000fc40007fde0ffULL, 0xfffffff825207812ULL, 0x000fe200078ee220ULL,
0x000000102e177824ULL, 0x104fe200078e0207ULL, 0x0000003014167810ULL, 0x000fe20007ffe0ffULL,
0x0000001034217824ULL, 0x100fe200078e0207ULL, 0x000000700c0c7812ULL, 0x000fe200078ef806ULL,
0x0000001020257824ULL, 0x100fe200078e0207ULL, 0x000000000e177faeULL, 0x0005e2000c101c48ULL,
0x0000001030157824ULL, 0x108fe200078e0207ULL, 0xfffffff823227812ULL, 0x000fe200078ee222ULL,
0x0000001032197824ULL, 0x000fe200078e0207ULL, 0x000000092400720cULL, 0x000fc40003f46070ULL,
0x000063000b0b7a10ULL, 0x000fe200037fe4ffULL, 0x0000000010157faeULL, 0x0007e2000d901c48ULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x0000001022237824ULL, 0x000fe200078e0207ULL,
0x0000003414207810ULL, 0x000fe20007ffe0ffULL, 0x0000000012197faeULL, 0x0009e2000e101c48ULL,
0x00000001080e7824ULL, 0x004fe200078e0216ULL, 0x0000003814227810ULL, 0x040fe40007ffe0ffULL,
0x0000003c14247810ULL, 0x000fe20007ffe0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL, 0x000000001a217faeULL, 0x0005e2000e901c48ULL,
0x000000092600720cULL, 0x0c0fe20003fa6070ULL, 0x0000000826147824ULL, 0x000fe200078e00ffULL,
0x000000092800720cULL, 0x080fe20003f86070ULL, 0x0000000108107824ULL, 0x008fe200078e0220ULL,
0x000000700e127812ULL, 0x010fe200078ef806ULL, 0x0000000126137824ULL, 0x100fe200078e0203ULL,
0x000000001c237faeULL, 0x0007e2000c901c48ULL, 0x00000001160e7824ULL, 0x000fe200078e0203ULL,
0x0000620012127a10ULL, 0x000fe20007fde0ffULL, 0x0000000816157824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee213ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000063000f137a10ULL, 0x000fe200037fe4ffULL, 0x000000001e257faeULL, 0x0009e2000d101c48ULL,
0x000000091600720cULL, 0x080fe20003f66070ULL, 0x00000001080f7824ULL, 0x000fe200078e0222ULL,
0x000000092000720cULL, 0x080fe20003f46070ULL, 0x0000000108087824ULL, 0x000fe200078e0224ULL,
0x000000092200720cULL, 0x080fe20003f26070ULL, 0x00000008201a7824ULL, 0x004fe200078e00ffULL,
0x000000092400720cULL, 0x000fe20003f06070ULL, 0x0000000128097824ULL, 0x040fe200078e0203ULL,
0xfffffff815187812ULL, 0x000fe200078ee20eULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0x0000007010107812ULL, 0x000fe200078ef806ULL, 0x000001000f0e7825ULL, 0x000fc600078e00ffULL,
0x0000620010107a10ULL, 0x000fe20007fde0ffULL, 0x0000000120157824ULL, 0x000fe200078e0203ULL,
0xfffffff828167812ULL, 0x000fe200078ee209ULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x100fe400078ef806ULL, 0x0000630011117a10ULL, 0x000fe200037fe4ffULL,
0x0000000122177824ULL, 0x100fe200078e0203ULL, 0x000062000e0e7a10ULL, 0x000fe20007fde0ffULL,
0x00000008221c7824ULL, 0x008fe200078e00ffULL, 0x0000007008067812ULL, 0x000fe200078ef806ULL,
0x0000000124037824ULL, 0x000fe200078e0203ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee215ULL,
0x00000008241e7824ULL, 0x010fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee217ULL,
0x0000001016157824ULL, 0x100fe200078e0207ULL, 0x000063000f0f7a10ULL, 0x000fe200037fe4ffULL,
0x0000001018177824ULL, 0x000fe200078e0207ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee203ULL,
0x0000001014037824ULL, 0x100fe200078e0207ULL, 0x0000620006067a10ULL, 0x000fe20007fde0ffULL,
0x000000101a197824ULL, 0x000fc400078e0207ULL, 0x000000101c1b7824ULL, 0x100fe200078e0207ULL,
0x000000000a037faeULL, 0x0005e2000e901c48ULL, 0x000000101e1d7824ULL, 0x000fe200078e0207ULL,
0x0000630009077a10ULL, 0x000fe400037fe4ffULL, 0x000000000c157faeULL, 0x0005e8000e101c48ULL,
0x0000000012177faeULL, 0x0005e8000d901c48ULL, 0x0000000010197faeULL, 0x0005e8000d101c48ULL,
0x000000000e1b7faeULL, 0x0005e8000c901c48ULL, 0x00000000061d7faeULL, 0x0005e2000c101c48ULL,
0x00000b3000007947ULL, 0x000fea0003800000ULL, 0x0000000403107811ULL, 0x040fe400078fe8ffULL,
0x0000000c03147811ULL, 0x000fc400078fe8ffULL, 0x0000001c03227811ULL, 0x040fe200078fe8ffULL,
0x0000000110077824ULL, 0x140fe200078e0203ULL, 0x0000000803127811ULL, 0x040fe200078fe8ffULL,
0x00000008100c7824ULL, 0x000fe200078e00ffULL, 0x00000010031a7811ULL, 0x040fe200078fe8ffULL,
0x00000001140a7824ULL, 0x040fe200078e0203ULL, 0x00000018031e7811ULL, 0x040fe200078fe8ffULL,
0x0000000814277824ULL, 0x000fe200078e00ffULL, 0xfffffff80c1f7812ULL, 0x000fe200078ee207ULL,
0x00000001220b7824ULL, 0x140fe200078e0203ULL, 0x00000014031c7811ULL, 0x000fe200078fe8ffULL,
0x0000000822167824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee20aULL,
0x0000000112097824ULL, 0x040fe200078e0203ULL, 0x00000028030d7811ULL, 0x040fe200078fe8ffULL,
0x00000008120e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8162f7812ULL, 0x000fe200078ee20bULL,
0x000000011a077824ULL, 0x040fe200078e0203ULL, 0x00000024030b7811ULL, 0x040fe200078fe8ffULL,
0x000000081a0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e1d7812ULL, 0x000fe200078ee209ULL,
0x000000011e0a7824ULL, 0x040fe200078e0203ULL, 0x0000002c03137811ULL, 0x040fe200078fe8ffULL,
0x000000081e2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c297812ULL, 0x000fe200078ee207ULL,
0x000000011c097824ULL, 0x140fe200078e0203ULL, 0x0000002003077811ULL, 0x000fe200078fe8ffULL,
0x000000081c0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee20aULL,
0x000000010b0a7824ULL, 0x000fe200078e0203ULL, 0x0000003003177811ULL, 0x000fe200078fe8ffULL,
0x000000080b0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e2b7812ULL, 0x000fe200078ee209ULL,
0x0000000107097824ULL, 0x100fe200078e0203ULL, 0x0000003403187811ULL, 0x000fe200078fe8ffULL,
0x0000000807167824ULL, 0x000fe200078e00ffULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee20aULL,
0x000000010d0c7824ULL, 0x000fe200078e0203ULL, 0x00000003030a7211ULL, 0x000fe200078fe8ffULL,
0x000000080d117824ULL, 0x000fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee209ULL,
0x00000001130e7824ULL, 0x000fe200078e0203ULL, 0x0000003803197811ULL, 0x000fe200078fe8ffULL,
0x0000000813157824ULL, 0x000fe200078e00ffULL, 0x0000003c031b7811ULL, 0x000fe200078fe8ffULL,
0x0000000108247824ULL, 0x000fe200078e0207ULL, 0xfffffff811117812ULL, 0x000fe200078ee20cULL,
0x00000001120c7824ULL, 0x100fe200078e0208ULL, 0x0000000803097211ULL, 0x000fe200078fe8ffULL,
0x000000011c127824ULL, 0x000fe200078e0208ULL, 0xfffffff815157812ULL, 0x000fe200078ee20eULL,
0x00000001140e7824ULL, 0x100fe200078e0208ULL, 0x000000070a207812ULL, 0x000fe200078ec0ffULL,
0x00000001100a7824ULL, 0x000fc400078e0208ULL, 0x0000000108267824ULL, 0x000fe200078e020bULL,
0x0ffffff820217812ULL, 0x000fe200078ef803ULL, 0x000000011a107824ULL, 0x100fe400078e0208ULL,
0x000000011e147824ULL, 0x000fe400078e0208ULL, 0x0000000108287824ULL, 0x000fe400078e020dULL,
0x0000000117077824ULL, 0x040fe400078e0203ULL, 0x00000008172c7824ULL, 0x000fc400078e00ffULL,
0x00000001081c7824ULL, 0x000fe400078e0218ULL, 0x00000001180b7824ULL, 0x040fe400078e0203ULL,
0x00000008182e7824ULL, 0x000fe400078e00ffULL, 0x0000000122227824ULL, 0x000fe400078e0208ULL,
0x00000001082a7824ULL, 0x000fe200078e0213ULL, 0xfffffff82c137812ULL, 0x000fe200078ee207ULL,
0x00000001081e7824ULL, 0x000fe200078e0217ULL, 0x00001000002c7811ULL, 0x000fe200078e70ffULL,
0x0000000108187824ULL, 0x000fe200078e0219ULL, 0xfffffff82e207812ULL, 0x000fe200078ee20bULL,
0x00000001190d7824ULL, 0x000fc400078e0203ULL, 0x0000000819307824ULL, 0x000fe400078e00ffULL,
0x00000001081a7824ULL, 0x000fe400078e021bULL, 0x0000010009087825ULL, 0x000fe200078e00ffULL,
0xfffffff830237812ULL, 0x000fc600078ee20dULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000007008087812ULL, 0x000fc600078ef806ULL, 0x000000100f357824ULL, 0x000fe200078e022cULL,
0x0000620008087a10ULL, 0x000fe20007f1e0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x100fe400078ef806ULL, 0x0000630009097a10ULL, 0x000fe200007fe4ffULL,
0x000000011b037824ULL, 0x040fe200078e0203ULL, 0x000062000c0c7a10ULL, 0x000fe20007f1e0ffULL,
0x000000081b327824ULL, 0x000fe200078e00ffULL, 0x000000700e0e7812ULL, 0x000fe200078ef806ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x000063000d0d7a10ULL, 0x000fc400007fe4ffULL,
0xfffffff832257812ULL, 0x000fe200078ee203ULL, 0x00000010133b7824ULL, 0x000fe200078e022cULL,
0x000000700a0a7812ULL, 0x000fe200078ef806ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000062000e0e7a10ULL, 0x000fe40007f1e0ffULL, 0x000062000a0a7a10ULL, 0x000fe20007f3e0ffULL,
0x0000001011377824ULL, 0x000fe200078e022cULL, 0x0000007012127812ULL, 0x000fe200078ef806ULL,
0x00000010233f7824ULL, 0x000fe200078e022cULL, 0x000063000f0f7a10ULL, 0x000fe200007fe4ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x0000620012127a10ULL, 0x000fc40007f1e0ffULL,
0x000063000b0b7a10ULL, 0x000fe20000ffe4ffULL, 0x0000001015397824ULL, 0x000fe200078e022cULL,
0x0000007010107812ULL, 0x000fe200078ef806ULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x0000630013137a10ULL, 0x000fe400007fe4ffULL, 0x0000620010107a10ULL, 0x000fe20007f3e0ffULL,
0x0000010014147825ULL, 0x000fc600078e00ffULL, 0x0000630011117a10ULL, 0x000fe20000ffe4ffULL,
0x0000001025417824ULL, 0x000fe200078e022cULL, 0x0000007014147812ULL, 0x000fe200078ef806ULL,
0x0000001021217824ULL, 0x100fe400078e022cULL, 0x000000101f1f7824ULL, 0x100fe200078e022cULL,
0x0000620014147a10ULL, 0x000fe20007f5e0ffULL, 0x000000101d1d7824ULL, 0x100fe200078e022cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008217faeULL, 0x0005e2000b901c48ULL,
0x00000010271b7824ULL, 0x100fe200078e022cULL, 0x0000630015157a10ULL, 0x000fe200017fe4ffULL,
0x0000001029197824ULL, 0x100fe200078e022cULL, 0x000000000a1f7faeULL, 0x0005e2000b901c48ULL,
0x000000102b177824ULL, 0x000fc400078e022cULL, 0x000000102d077824ULL, 0x100fe200078e022cULL,
0x000000000c1d7faeULL, 0x0005e2000b901c48ULL, 0x000000102f037824ULL, 0x100fe400078e022cULL,
0x0000001016167824ULL, 0x100fe200078e022cULL, 0x000000000e1b7faeULL, 0x0005e2000b901c48ULL,
0x00000010203d7824ULL, 0x000fe200078e022cULL, 0x00000070222c7812ULL, 0x100fe200078ef806ULL,
0x0000010024247825ULL, 0x000fe200078e00ffULL, 0x0000000010197faeULL, 0x0005e4000b901c48ULL,
0x000062002c2c7a10ULL, 0x000fe20007f1e0ffULL, 0x0000010026267825ULL, 0x000fe200078e00ffULL,
0x00000070242e7812ULL, 0x100fe200078ef806ULL, 0x0000000012177faeULL, 0x0005e2000b901c48ULL,
0x00006300232d7a10ULL, 0x000fe200007fe4ffULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x0000007026307812ULL, 0x100fe200078ef806ULL, 0x0000000014077faeULL, 0x0005e2000b901c48ULL,
0x000062002e2e7a10ULL, 0x000fe20007f3e0ffULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x0000007028327812ULL, 0x000fe200078ef806ULL, 0x000000002c037faeULL, 0x0005e2000b901c48ULL,
0x0000620030307a10ULL, 0x000fe20007f1e0ffULL, 0x000001001e227825ULL, 0x000fe200078e00ffULL,
0x0000620032327a10ULL, 0x000fc40007f5e0ffULL, 0x00006300252f7a10ULL, 0x000fe20000ffe4ffULL,
0x000001001c247825ULL, 0x000fe200078e00ffULL, 0x000000702a2a7812ULL, 0x100fe400078ef806ULL,
0x0000630027317a10ULL, 0x000fe200007fe4ffULL, 0x0000010018267825ULL, 0x000fe200078e00ffULL,
0x0000630029337a10ULL, 0x000fe200017fe4ffULL, 0x000000002e167faeULL, 0x0005e2000b901c48ULL,
0x000062002a2a7a10ULL, 0x000fe20007f1e0ffULL, 0x000001001a287825ULL, 0x000fe200078e00ffULL,
0x0000007022227812ULL, 0x100fe200078ef806ULL, 0x0000000030357faeULL, 0x0005e2000b901c48ULL,
0x0000007024247812ULL, 0x000fc400078ef806ULL, 0x0000007026267812ULL, 0x100fe200078ef806ULL,
0x0000000032377faeULL, 0x0005e2000b901c48ULL, 0x000063002b2b7a10ULL, 0x000fe400007fe4ffULL,
0x0000007028067812ULL, 0x000fe400078ef806ULL, 0x0000620022227a10ULL, 0x000fe20007f1e0ffULL,
0x000000002a397faeULL, 0x0005e2000b901c48ULL, 0x0000620024247a10ULL, 0x000fe40007f3e0ffULL,
0x0000620026267a10ULL, 0x000fc40007f5e0ffULL, 0x0000620006287a10ULL, 0x000fe40007f7e0ffULL,
0x0000630023237a10ULL, 0x000fe400007fe4ffULL, 0x0000630025257a10ULL, 0x000fe40000ffe4ffULL,
0x0000630027277a10ULL, 0x000fe200017fe4ffULL, 0x00000000223b7faeULL, 0x0005e2000b901c48ULL,
0x0000630029297a10ULL, 0x000fc60001ffe4ffULL, 0x00000000243d7faeULL, 0x0005e8000b901c48ULL,
0x00000000263f7faeULL, 0x0005e8000b901c48ULL, 0x0000000028417faeULL, 0x0005e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x004fc40000015200ULL,
0x01b60400ff037984ULL, 0x000ea40000000800ULL, 0x8000000003ff7812ULL, 0x006fc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011409ULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000005e0200720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x00005800ff697624ULL, 0x000fe200078e00ffULL,
0x800058006c6d7a10ULL, 0x000fe20007ffe0ffULL, 0x0000002000717824ULL, 0x040fe200078e00ffULL,
0x0001b688006f7811ULL, 0x000fe400078e18ffULL, 0x0000001f69047810ULL, 0x040fe40007ffe0ffULL,
0xffffffff696e7810ULL, 0x000fe40007ffe0ffULL, 0x00000004ff047819ULL, 0x000fc40000011604ULL,
0x0000000969697810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff6d7819ULL, 0x000fe4000001166dULL,
0x0ffffffe046a7812ULL, 0x000fc400078ec0ffULL, 0x0000000102057810ULL, 0x040fe20007ffe0ffULL,
0x0000010002047824ULL, 0x000fe200078e0272ULL, 0x0000000000007946ULL, 0x000fe40003800000ULL,
0x0000005e0500720cULL, 0x000fe20003f06070ULL, 0x00006600680a7a24ULL, 0x000fd800078e0204ULL,
0x00000bb000008947ULL, 0x00cfea0003800000ULL, 0x00000003ff0b7819ULL, 0x102fe20000011603ULL,
0x0000001003057824ULL, 0x000fe200078e00ffULL, 0x000000046c0d7217ULL, 0x000fe40007800000ULL,
0x000000040b0f7810ULL, 0x040fe20007ffe0ffULL, 0x000000010b1b7824ULL, 0x140fe200078e0203ULL,
0x000000080b117810ULL, 0x000fe20007ffe0ffULL, 0x000000010d1e7824ULL, 0x000fe200078e0a04ULL,
0x0000007005057812ULL, 0x000fe200078ec0ffULL, 0x000000010f067824ULL, 0x100fe200078e0203ULL,
0x0000000c0b137810ULL, 0x000fe20007ffe0ffULL, 0x000000080f097824ULL, 0x000fe200078e00ffULL,
0x0000008005087812ULL, 0x000fe200078efcffULL, 0x0000000111077824ULL, 0x100fe200078e0203ULL,
0x000000100b157810ULL, 0x000fe20007ffe0ffULL, 0x0000000811207824ULL, 0x000fe200078e00ffULL,
0xfffffff8091a7812ULL, 0x000fe200078ee206ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x0000001e0f00720cULL, 0x080fe20003f86070ULL, 0x00000001130e7824ULL, 0x000fe200078e0203ULL,
0xfffffff820207812ULL, 0x000fe200078ee207ULL, 0x000000010b077824ULL, 0x040fe200078e020aULL,
0x000000140b1f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000813177824ULL, 0x000fe200078e00ffULL,
0x0000001e1100720cULL, 0x080fe20003f46070ULL, 0x0000010007067825ULL, 0x000fe200078e0008ULL,
0x0000001e1300720cULL, 0x000fc40003f66070ULL, 0xfffffff817227812ULL, 0x000fe200078ee20eULL,
0x0000000115107824ULL, 0x040fe200078e0203ULL, 0x00006200060c7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0x000000180b237810ULL, 0x000fe20007ffe0ffULL,
0x000000081f267824ULL, 0x000fe200078e00ffULL, 0x00006300070d7a10ULL, 0x000fe200007fe4ffULL,
0x000000010f077824ULL, 0x000fe200078e020aULL, 0xfffffff819247812ULL, 0x000fe200078ee210ULL,
0x00000001110f7824ULL, 0x000fe200078e020aULL, 0x0000001e1500720cULL, 0x000fe20003f06070ULL,
0x0000010007067825ULL, 0x000fe200078e0008ULL, 0x0000001c0b277810ULL, 0x000fc40007ffe0ffULL,
0x000000200b297810ULL, 0x000fe20007ffe0ffULL, 0x0000000113117824ULL, 0x000fe200078e020aULL,
0x00006200061c7a10ULL, 0x000fe20007f3e0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0008ULL,
0x0000003c0b2b7810ULL, 0x000fe40007ffe0ffULL, 0x00006300071d7a10ULL, 0x000fe20000ffe4ffULL,
0x0000000115137824ULL, 0x100fe200078e020aULL, 0x000062000e147a10ULL, 0x000fe20007fbe0ffULL,
0x000000011f157824ULL, 0x000fe400078e020aULL, 0x0000010011107825ULL, 0x000fc800078e0008ULL,
0x0000010013067825ULL, 0x000fe200078e0008ULL, 0x0000620010167a10ULL, 0x000fc60007f3e0ffULL,
0x0000010015127825ULL, 0x000fe200078e0008ULL, 0x000063000f157a10ULL, 0x000fe40002ffe4ffULL,
0x0000620006107a10ULL, 0x000fe20007fbe0ffULL, 0x0000000123197824ULL, 0x000fe200078e020aULL,
0x0000630011177a10ULL, 0x000fe20000ffe4ffULL, 0x0000000123257824ULL, 0x000fe200078e0203ULL,
0x0000630007117a10ULL, 0x000fe20002ffe4ffULL, 0x0000000823287824ULL, 0x000fe200078e00ffULL,
0x0ffffff803067812ULL, 0x000fe200078ec0ffULL, 0x00000008272a7824ULL, 0x000fe200078e00ffULL,
0x0000001e0b00720cULL, 0x000fc40003fa6070ULL, 0x00006200120e7a10ULL, 0x000fe40007fde0ffULL,
0x0000300000077811ULL, 0x000fe400078e70ffULL, 0x0000000706187812ULL, 0x000fe200078ef81bULL,
0x00000001291b7824ULL, 0x000fe200078e020aULL, 0x00006300130f7a10ULL, 0x000fe200037fe4ffULL,
0x0000010019127825ULL, 0x000fe200078e0008ULL, 0x0000001e1f00720cULL, 0x0c0fe40003f26070ULL,
0xfffffff828287812ULL, 0x000fe200078ee225ULL, 0x000000011f197824ULL, 0x000fe200078e0203ULL,
0x0000620012127a10ULL, 0x000fe20007fde0ffULL, 0x00000010181f7824ULL, 0x100fe200078e0207ULL,
0x0000002c0b257810ULL, 0x000fe20007ffe0ffULL, 0x000000101a217824ULL, 0x000fe200078e0207ULL,
0xfffffff826267812ULL, 0x000fe200078ee219ULL, 0x0000000127197824ULL, 0x000fe200078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c1f7faeULL, 0x0003e2000e901c48ULL,
0x0000001e2300720cULL, 0x080fe20003fa6070ULL, 0x0000000127237824ULL, 0x000fe200078e0203ULL,
0x0000630013137a10ULL, 0x000fe200037fe4ffULL, 0x0000010019187825ULL, 0x000fe200078e0008ULL,
0x000000001c217faeULL, 0x0005e2000e101c48ULL, 0x0000001e2700720cULL, 0x000fc40003f86070ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee223ULL, 0x000001001b1a7825ULL, 0x000fe200078e0008ULL,
0x000000240b237810ULL, 0x040fe40007ffe0ffULL, 0x0000620018187a10ULL, 0x000fe20007fde0ffULL,
0x00000010201f7824ULL, 0x102fe200078e0207ULL, 0x000000300b277810ULL, 0x000fe20007ffe0ffULL,
0x00000001230d7824ULL, 0x000fe200078e020aULL, 0x0000630019197a10ULL, 0x000fe200037fe4ffULL,
0x0000001022217824ULL, 0x004fe200078e0207ULL, 0x000062001a1a7a10ULL, 0x000fe20007fde0ffULL,
0x000001000d0c7825ULL, 0x000fe200078e0008ULL, 0x00000000141f7faeULL, 0x0003e2000d101c48ULL,
0x0000001e2300720cULL, 0x000fc40003f46070ULL, 0x00000001291d7824ULL, 0x100fe200078e0203ULL,
0x000063001b1b7a10ULL, 0x000fe200037fe4ffULL, 0x0000000829227824ULL, 0x000fe200078e00ffULL,
0x000062000c1c7a10ULL, 0x000fe20007fde0ffULL, 0x0000000123207824ULL, 0x040fe200078e0203ULL,
0x0000000016217faeULL, 0x0005e2000d901c48ULL, 0x0000000823237824ULL, 0x000fe200078e00ffULL,
0xfffffff8220c7812ULL, 0x000fe200078ee21dULL, 0x0000001024157824ULL, 0x102fe200078e0207ULL,
0x000063000d1d7a10ULL, 0x000fe200037fe4ffULL, 0x00000010260d7824ULL, 0x100fe200078e0207ULL,
0xfffffff823207812ULL, 0x000fe200078ee220ULL, 0x000000102a1f7824ULL, 0x100fe200078e0207ULL,
0x000000280b237810ULL, 0x000fe20007ffe0ffULL, 0x0000000010157faeULL, 0x0003e2000c101c48ULL,
0x0000001e2900720cULL, 0x080fe20003f66070ULL, 0x000000100c217824ULL, 0x004fe200078e0207ULL,
0x000000380b297810ULL, 0x000fe20007ffe0ffULL, 0x000000000e0d7faeULL, 0x0005e2000c901c48ULL,
0x00000001230c7824ULL, 0x040fe200078e0203ULL, 0x0000001e2300720cULL, 0x080fe20003fc6070ULL,
0x0000001028177824ULL, 0x000fe200078e0207ULL, 0x0000001e2900720cULL, 0x080fe20003f26070ULL,
0x0000000825167824ULL, 0x000fe200078e00ffULL, 0x0000001e2b00720cULL, 0x000fc40003f06070ULL,
0x000000340b157810ULL, 0x002fe20007ffe0ffULL, 0x00000010200b7824ULL, 0x000fe200078e0207ULL,
0x0000000012177faeULL, 0x0003e2000e901c48ULL, 0x0000000125117824ULL, 0x040fe200078e0203ULL,
0x0000001e2500720cULL, 0x080fe20003fa6070ULL, 0x00000008230d7824ULL, 0x004fe200078e00ffULL,
0x00000000181f7faeULL, 0x0005e2000e101c48ULL, 0x00000001250f7824ULL, 0x000fe200078e020aULL,
0x0000001e2700720cULL, 0x000fe40003f86070ULL, 0xfffffff80d147812ULL, 0x000fe200078ee20cULL,
0x00000001230d7824ULL, 0x000fe200078e020aULL, 0x000000001a217faeULL, 0x0007e2000d901c48ULL,
0x000001000f0e7825ULL, 0x000fe200078e0008ULL, 0xfffffff816167812ULL, 0x000fc400078ee211ULL,
0x000000001c0b7faeULL, 0x0009e2000d101c48ULL, 0x000001000d0c7825ULL, 0x000fe200078e0008ULL,
0x0000001e1500720cULL, 0x000fc60003f66070ULL, 0x0000000127137824ULL, 0x042fe200078e020aULL,
0x000062000c107a10ULL, 0x000fe20007f5e0ffULL, 0x0000000127127824ULL, 0x040fe400078e0203ULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0x000063000d117a10ULL, 0x000fe200017fe4ffULL,
0x0000000815177824ULL, 0x000fe400078e00ffULL, 0x00000100130c7825ULL, 0x000fe200078e0008ULL,
0xfffffff827187812ULL, 0x004fe400078ee212ULL, 0x000062000e127a10ULL, 0x000fe20007f5e0ffULL,
0x00000001150e7824ULL, 0x000fc400078e0203ULL, 0x00000001150b7824ULL, 0x110fe200078e020aULL,
0x000063000f137a10ULL, 0x000fe200017fe4ffULL, 0x0000000129157824ULL, 0x000fe200078e020aULL,
0xfffffff8171a7812ULL, 0x008fe200078ee20eULL, 0x000001000b0e7825ULL, 0x000fe200078e0008ULL,
0x000062000c0c7a10ULL, 0x000fc60007f5e0ffULL, 0x000000012b177824ULL, 0x000fe200078e020aULL,
0x000063000d0d7a10ULL, 0x000fe200017fe4ffULL, 0x00000100150a7825ULL, 0x000fe200078e0008ULL,
0x000062000e0e7a10ULL, 0x000fc60007f5e0ffULL, 0x0000000129197824ULL, 0x100fe200078e0203ULL,
0x000063000f0f7a10ULL, 0x000fe200017fe4ffULL, 0x00000008291c7824ULL, 0x000fe200078e00ffULL,
0x000062000a0a7a10ULL, 0x000fe20007f5e0ffULL, 0x000000012b157824ULL, 0x040fe400078e0203ULL,
0x000000082b1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee219ULL,
0x0000010017087825ULL, 0x000fe200078e0008ULL, 0x000063000b0b7a10ULL, 0x000fe400017fe4ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee215ULL, 0x0000001014157824ULL, 0x100fe200078e0207ULL,
0x0000620008087a10ULL, 0x000fe20007f5e0ffULL, 0x0000001016177824ULL, 0x000fc400078e0207ULL,
0x0000001018197824ULL, 0x100fe200078e0207ULL, 0x0000630009097a10ULL, 0x000fe200017fe4ffULL,
0x000000101a1b7824ULL, 0x100fe200078e0207ULL, 0x0000000010157faeULL, 0x0003e2000f101c48ULL,
0x000000101c1d7824ULL, 0x100fe400078e0207ULL, 0x000000101e077824ULL, 0x000fe200078e0207ULL,
0x0000000012177faeULL, 0x0003e8000e901c48ULL, 0x000000000c197faeULL, 0x0003e8000e101c48ULL,
0x000000000e1b7faeULL, 0x0003e8000d901c48ULL, 0x000000000a1d7faeULL, 0x0003e8000c901c48ULL,
0x0000000008077faeULL, 0x0003e2000c101c48ULL, 0x00000a7000007947ULL, 0x000fea0003800000ULL,
0x00000004030d7811ULL, 0x042fe400078fe8ffULL, 0x00000008030f7811ULL, 0x000fc400078fe8ffULL,
0x0000000c03117811ULL, 0x000fe200078fe8ffULL, 0x000000010d057824ULL, 0x100fe200078e0203ULL,
0x0000001403157811ULL, 0x000fe200078fe8ffULL, 0x000000080d087824ULL, 0x000fe200078e00ffULL,
0x0000001003137811ULL, 0x000fe200078fe8ffULL, 0x000000010f067824ULL, 0x000fe200078e0203ULL,
0x0000001803177811ULL, 0x000fe200078fe8ffULL, 0x000000080f097824ULL, 0x000fe200078e00ffULL,
0xfffffff808297812ULL, 0x000fe200078ee205ULL, 0x0000000111057824ULL, 0x100fe200078e0203ULL,
0x00000020031b7811ULL, 0x000fe200078fe8ffULL, 0x0000000811087824ULL, 0x000fe200078e00ffULL,
0xfffffff809097812ULL, 0x000fe200078ee206ULL, 0x0000000115077824ULL, 0x000fe200078e0203ULL,
0x0000001c03197811ULL, 0x000fe200078fe8ffULL, 0x00000008150c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8082b7812ULL, 0x000fe200078ee205ULL, 0x0000000113067824ULL, 0x000fe200078e0203ULL,
0x00000024031d7811ULL, 0x000fe200078fe8ffULL, 0x00000008132d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c2f7812ULL, 0x000fe200078ee207ULL, 0x0000000117057824ULL, 0x100fe200078e0203ULL,
0x0000002c03217811ULL, 0x000fe200078fe8ffULL, 0x0000000817087824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee206ULL, 0x000000011b077824ULL, 0x000fe200078e0203ULL,
0x00000028031f7811ULL, 0x000fe200078fe8ffULL, 0x000000081b0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff808317812ULL, 0x000fe200078ee205ULL, 0x0000000119067824ULL, 0x000fe200078e0203ULL,
0x0000003003237811ULL, 0x000fe200078fe8ffULL, 0x0000000819337824ULL, 0x000fe200078e00ffULL,
0xfffffff80c357812ULL, 0x000fe200078ee207ULL, 0x000000011d057824ULL, 0x100fe200078e0203ULL,
0x0000003803277811ULL, 0x000fe200078fe8ffULL, 0x000000081d087824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee206ULL, 0x0000000121077824ULL, 0x000fe200078e0203ULL,
0x0000003403257811ULL, 0x000fe200078fe8ffULL, 0x00000008210c7824ULL, 0x000fe200078e00ffULL,
0xfffffff808377812ULL, 0x000fe200078ee205ULL, 0x000000011f067824ULL, 0x000fe200078e0203ULL,
0x0000003c033f7811ULL, 0x000fe200078fe8ffULL, 0x000000081f397824ULL, 0x000fe200078e00ffULL,
0xfffffff80c3b7812ULL, 0x000fe200078ee207ULL, 0x0000000123057824ULL, 0x100fe200078e0203ULL,
0x0000000a030b7211ULL, 0x000fe200078fe8ffULL, 0x0000000823087824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee206ULL, 0x0000000127077824ULL, 0x000fc400078e0203ULL,
0x00000008270c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8083d7812ULL, 0x000fe200078ee205ULL,
0x0000000125067824ULL, 0x040fe400078e0203ULL, 0x0000000825417824ULL, 0x000fe200078e00ffULL,
0xfffffff80c437812ULL, 0x000fe200078ee207ULL, 0x0000001003057824ULL, 0x000fe200078e00ffULL,
0x00003000000c7811ULL, 0x000fe200078e70ffULL, 0x000000013f087824ULL, 0x000fe200078e0203ULL,
0xfffffff841417812ULL, 0x000fe200078ee206ULL, 0x000000083f457824ULL, 0x000fe200078e00ffULL,
0x0000000303077211ULL, 0x000fe200078fe8ffULL, 0x000000102b2a7824ULL, 0x100fe200078e020cULL,
0x0ffffff803067812ULL, 0x000fe200078ec0ffULL, 0x0000001009287824ULL, 0x100fe200078e020cULL,
0x0000007005057812ULL, 0x000fe200078ec0ffULL, 0x000000102d2b7824ULL, 0x000fe200078e020cULL,
0xfffffff845457812ULL, 0x000fe200078ee208ULL, 0x000000102f2c7824ULL, 0x100fe200078e020cULL,
0x0000000706077812ULL, 0x000fe200078ef807ULL, 0x00000010312d7824ULL, 0x100fe200078e020cULL,
0x0000008005087812ULL, 0x000fe200078efcffULL, 0x00000010332f7824ULL, 0x000fc400078e020cULL,
0x000000ffff097224ULL, 0x000fe400078e00ffULL, 0x000000010d0d7824ULL, 0x000fe400078e020aULL,
0x0000001035317824ULL, 0x100fe400078e020cULL, 0x0000001037337824ULL, 0x000fe400078e020cULL,
0x000000010f0f7824ULL, 0x000fe400078e020aULL, 0x0000001039357824ULL, 0x000fc400078e020cULL,
0x000000103b377824ULL, 0x000fe400078e020cULL, 0x0000000111117824ULL, 0x100fe400078e020aULL,
0x0000000113137824ULL, 0x100fe400078e020aULL, 0x0000000115157824ULL, 0x100fe400078e020aULL,
0x0000000117177824ULL, 0x100fe400078e020aULL, 0x0000000119197824ULL, 0x000fc400078e020aULL,
0x000000011b1b7824ULL, 0x100fe400078e020aULL, 0x000000011d1d7824ULL, 0x100fe400078e020aULL,
0x000000011f1f7824ULL, 0x100fe400078e020aULL, 0x0000000121217824ULL, 0x100fe400078e020aULL,
0x0000000123237824ULL, 0x100fe400078e020aULL, 0x0000000125257824ULL, 0x000fc400078e020aULL,
0x0000000127277824ULL, 0x100fe400078e020aULL, 0x000000013f3f7824ULL, 0x000fe400078e020aULL,
0x000000103d397824ULL, 0x100fe400078e020cULL, 0x00000010413b7824ULL, 0x100fe400078e020cULL,
0x0000001007077824ULL, 0x100fe400078e020cULL, 0x0000001029297824ULL, 0x000fc400078e020cULL,
0x00000010433d7824ULL, 0x100fe400078e020cULL, 0x0000001045417824ULL, 0x000fe400078e020cULL,
0x000001000b0a7825ULL, 0x000fc800078e0008ULL, 0x000001000d0c7825ULL, 0x000fe200078e0008ULL,
0x000062000a0a7a10ULL, 0x000fc60007f1e0ffULL, 0x000001000f0e7825ULL, 0x100fe200078e0008ULL,
0x000062000c0c7a10ULL, 0x000fe40007f3e0ffULL, 0x000063000b0b7a10ULL, 0x000fe200007fe4ffULL,
0x0000010011107825ULL, 0x100fe200078e0008ULL, 0x000062000e0e7a10ULL, 0x000fe40007f5e0ffULL,
0x000063000d0d7a10ULL, 0x000fe20000ffe4ffULL, 0x0000010013127825ULL, 0x100fe200078e0008ULL,
0x0000620010107a10ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a077faeULL, 0x0003e2000b901c48ULL, 0x000063000f0f7a10ULL, 0x000fe200017fe4ffULL,
0x0000010015147825ULL, 0x100fe200078e0008ULL, 0x0000620012127a10ULL, 0x000fe20007f1e0ffULL,
0x000000000c297faeULL, 0x0003e2000b901c48ULL, 0x0000630011117a10ULL, 0x000fe20001ffe4ffULL,
0x0000010017167825ULL, 0x100fe200078e0008ULL, 0x0000620014147a10ULL, 0x000fe20007f3e0ffULL,
0x000000000e287faeULL, 0x0003e2000b901c48ULL, 0x0000630013137a10ULL, 0x000fe200007fe4ffULL,
0x0000010019187825ULL, 0x100fe200078e0008ULL, 0x0000620016167a10ULL, 0x000fe20007f5e0ffULL,
0x00000000102a7faeULL, 0x0003e2000b901c48ULL, 0x0000630015157a10ULL, 0x000fe20000ffe4ffULL,
0x000001001b1a7825ULL, 0x100fe200078e0008ULL, 0x0000620018187a10ULL, 0x000fe20007f7e0ffULL,
0x00000000122b7faeULL, 0x0003e2000b901c48ULL, 0x0000630017177a10ULL, 0x000fe200017fe4ffULL,
0x000001001d1c7825ULL, 0x100fe200078e0008ULL, 0x000062001a1a7a10ULL, 0x000fe20007f1e0ffULL,
0x00000000142c7faeULL, 0x0003e2000b901c48ULL, 0x0000630019197a10ULL, 0x000fe20001ffe4ffULL,
0x000001001f1e7825ULL, 0x100fe200078e0008ULL, 0x000062001c1c7a10ULL, 0x000fe20007f3e0ffULL,
0x00000000162d7faeULL, 0x0003e2000b901c48ULL, 0x000063001b1b7a10ULL, 0x000fe200007fe4ffULL,
0x0000010021207825ULL, 0x100fe200078e0008ULL, 0x000062001e1e7a10ULL, 0x000fe20007f5e0ffULL,
0x00000000182f7faeULL, 0x0003e2000b901c48ULL, 0x000063001d1d7a10ULL, 0x000fe20000ffe4ffULL,
0x0000010023227825ULL, 0x100fe200078e0008ULL, 0x0000620020207a10ULL, 0x000fe20007f7e0ffULL,
0x000000001a317faeULL, 0x0003e2000b901c48ULL, 0x000063001f1f7a10ULL, 0x000fe200017fe4ffULL,
0x0000010025247825ULL, 0x100fe200078e0008ULL, 0x0000620022227a10ULL, 0x000fe20007f1e0ffULL,
0x000000001c337faeULL, 0x0003e2000b901c48ULL, 0x0000630021217a10ULL, 0x000fe20001ffe4ffULL,
0x0000010027267825ULL, 0x100fe200078e0008ULL, 0x0000620024247a10ULL, 0x000fe20007f3e0ffULL,
0x000000001e357faeULL, 0x0003e2000b901c48ULL, 0x0000630023237a10ULL, 0x000fe200007fe4ffULL,
0x000001003f087825ULL, 0x000fe200078e0008ULL, 0x0000620026267a10ULL, 0x000fe20007f5e0ffULL,
0x0000000020377faeULL, 0x0003e2000b901c48ULL, 0x0000630025257a10ULL, 0x000fc40000ffe4ffULL,
0x0000620008087a10ULL, 0x000fe20007f7e0ffULL, 0x0000000022397faeULL, 0x0003e2000b901c48ULL,
0x0000630027277a10ULL, 0x000fe400017fe4ffULL, 0x0000630009097a10ULL, 0x000fe20001ffe4ffULL,
0x00000000243b7faeULL, 0x0003e8000b901c48ULL, 0x00000000263d7faeULL, 0x0003e8000b901c48ULL,
0x0000000008417faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000703387812ULL, 0x000fc400078ec0ffULL, 0x00000004ff0a7819ULL, 0x102fe40000011603ULL,
0x0000000838077812ULL, 0x000fca00078ef803ULL, 0x000000010a087824ULL, 0x000fe400078e0207ULL,
0x0000001007097824ULL, 0x000fca00078e00ffULL, 0xfffffff009097812ULL, 0x000fca00078ee208ULL,
0x00000010092c7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x000000080a097824ULL, 0x000fe200078e00ffULL,
0x00000003ff617819ULL, 0x000fe20000011603ULL, 0x00000010070d7824ULL, 0x000fe200078e00ffULL,
0x00000002080c7810ULL, 0x000fe20007ffe0ffULL, 0x000000002c2c783bULL, 0x000fe20000000200ULL,
0xfffffff809387812ULL, 0x000fe200078ee238ULL, 0x0000400000097824ULL, 0x000fe200078e00ffULL,
0x00000001610b7812ULL, 0x000fe400078ec0ffULL, 0x0000001038357810ULL, 0x040fe20007ffe0ffULL,
0x00000008385d7824ULL, 0x040fe200078e00ffULL, 0x00001000090a7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b347824ULL, 0x000fe200078e0238ULL, 0xfffffff00d0c7812ULL, 0x000fe200078ee20cULL,
0x000000010b5c7824ULL, 0x000fe200078e0235ULL, 0x0000002038367810ULL, 0x040fe20007ffe0ffULL,
0x00000008350d7824ULL, 0x000fe200078e00ffULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee234ULL,
0x00000008380f7824ULL, 0x040fe200078e00ffULL, 0x0000003038377810ULL, 0x000fe20007ffe0ffULL,
0x000000100c287824ULL, 0x000fe200078e00ffULL, 0x0000000234607810ULL, 0x000fe20007ffe0ffULL,
0x000000105d1c7824ULL, 0x000fe200078e020aULL, 0xfffffff80d5c7812ULL, 0x000fe200078ee25cULL,
0x000000010b5b7824ULL, 0x000fe200078e0236ULL, 0xfffffff80f607812ULL, 0x000fe200078ee260ULL,
0x000000010b5a7824ULL, 0x000fe200078e0237ULL, 0x000000002828783bULL, 0x000fe20000000200ULL,
0x00000008360c7824ULL, 0x000fe200078e00ffULL, 0x0000001234657810ULL, 0x000fe20007ffe0ffULL,
0x00000008370b7824ULL, 0x000fe200078e00ffULL, 0x000000001c1c783bULL, 0x000e620000000200ULL,
0x000000105c107824ULL, 0x100fe200078e020aULL, 0xfffffff80c5b7812ULL, 0x000fe200078ee25bULL,
0x0000001060507824ULL, 0x000fe200078e020aULL, 0xfffffff80b5a7812ULL, 0x000fe200078ee25aULL,
0x0000000835147824ULL, 0x000fe200078e00ffULL, 0x0000002234677810ULL, 0x040fe20007ffe0ffULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x000000105b0c7824ULL, 0x100fe200078e020aULL,
0x0000003234667810ULL, 0x000fe20007ffe0ffULL, 0x000000105a307824ULL, 0x000fe200078e020aULL,
0x000000005050783bULL, 0x000ee20000000200ULL, 0xfffffff814657812ULL, 0x000fe200078ee265ULL,
0x0000000836147824ULL, 0x000fe200078e00ffULL, 0xfffffff80b667812ULL, 0x000fe200078ee266ULL,
0x000000000c0c783bULL, 0x000f220000000200ULL, 0x00000004080b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001065187824ULL, 0x100fe200078e020aULL, 0xfffffff814677812ULL, 0x000fe200078ee267ULL,
0x000000003030783bULL, 0x000ee20000000200ULL, 0x00000008373a7824ULL, 0x040fe200078e00ffULL,
0x00000004345f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000837377824ULL, 0x000fe200078e00ffULL,
0x000000001818783bULL, 0x000ee20000000200ULL, 0x0000001067207824ULL, 0x000fe200078e020aULL,
0x0000001434597810ULL, 0x000fc40007ffe0ffULL, 0x0000002434587810ULL, 0x000fc60007ffe0ffULL,
0x000000002020783bULL, 0x000ee20000000200ULL, 0x0000001c2c54723cULL, 0x042f7000000018ffULL,
0x0000001e2c1c723cULL, 0x040f7000000018ffULL, 0x000000102c14723cULL, 0x044f7000000018ffULL,
0x000000122c10723cULL, 0x000f7000000018ffULL, 0x000000502854723cULL, 0x068ff00000001854ULL,
0x000000522850723cULL, 0x000ff0000000181cULL, 0x0000000c2c1c723cULL, 0x050f7000000018ffULL,
0x000000302c24723cULL, 0x040bee00000018ffULL, 0x0000001066307824ULL, 0x020fe200078e020aULL,
0x0000000e2c0c723cULL, 0x040f7000000018ffULL, 0x000000322c2c723cULL, 0x000b6400000018ffULL,
0x000000003030783bULL, 0x020e6c0000000200ULL, 0x000000182814723cULL, 0x040f700000001814ULL,
0x0000001a2818723cULL, 0x040b6e0000001810ULL, 0x0000001007107824ULL, 0x020fe200078e00ffULL,
0x00000020281c723cULL, 0x000b62000000181cULL, 0x0000000838127824ULL, 0x000fc400078e00ffULL,
0x0000000836117824ULL, 0x000fe200078e00ffULL, 0xfffffff010107812ULL, 0x000fe200078ee20bULL,
0x0000000838387824ULL, 0x000fe200078e00ffULL, 0x00000034340b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000835207824ULL, 0x020fe200078e00ffULL, 0xfffffff8125f7812ULL, 0x000fe200078ee25fULL,
0x0000001010407824ULL, 0x000fe200078e00ffULL, 0xfffffff811587812ULL, 0x000fe400078ee258ULL,
0xfffffff820597812ULL, 0x000fe200078ee259ULL, 0x000000105f107824ULL, 0x100fe200078e020aULL,
0xfffffff83a0b7812ULL, 0x000fe200078ee20bULL, 0x0000001058487824ULL, 0x100fe200078e020aULL,
0x000000222820723cULL, 0x000b62000000180cULL, 0x00000010594c7824ULL, 0x100fe200078e020aULL,
0x000000004040783bULL, 0x000fe20000000200ULL, 0x000000100b447824ULL, 0x000fc600078e020aULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x00000010070f7824ULL, 0x020fe200078e00ffULL,
0x00000006080c7810ULL, 0x000fe20007ffe0ffULL, 0x000000302824723cULL, 0x042b620000001824ULL,
0x000000004c4c783bULL, 0x000e620000000200ULL, 0x00000006340d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff00f0f7812ULL, 0x000fe200078ee20cULL, 0x000000004848783bULL, 0x000ee20000000200ULL,
0xfffffff8380c7812ULL, 0x000fe200078ee20dULL, 0x0000000835307824ULL, 0x020fe200078e00ffULL,
0x00000016340d7810ULL, 0x000fe20007ffe0ffULL, 0x000000004444783bULL, 0x000f220000000200ULL,
0x0000000836317824ULL, 0x000fe200078e00ffULL, 0x00000026340e7810ULL, 0x040fe20007ffe0ffULL,
0x000000100f627824ULL, 0x000fe200078e00ffULL, 0x0000003634347810ULL, 0x000fe20007ffe0ffULL,
0x000000322828723cULL, 0x000b62000000182cULL, 0xfffffff8300d7812ULL, 0x000fe200078ee20dULL,
0x000000100c3c7824ULL, 0x000fe200078e020aULL, 0xfffffff8310e7812ULL, 0x000fe200078ee20eULL,
0x00000000622c783bULL, 0x020fe20000000200ULL, 0xfffffff8370f7812ULL, 0x000fe200078ee234ULL,
0x000000100d387824ULL, 0x000fc400078e020aULL, 0x000000100e347824ULL, 0x100fe200078e020aULL,
0x000000003c3c783bULL, 0x000ee20000000200ULL, 0x000000100f307824ULL, 0x000fc600078e020aULL,
0x000000003838783bULL, 0x000ee80000000200ULL, 0x000000003434783bULL, 0x000f280000000200ULL,
0x000000003030783bULL, 0x000f220000000200ULL, 0x000000104054723cULL, 0x044f700000001854ULL,
0x000000124050723cULL, 0x040f700000001850ULL, 0x0000004c4014723cULL, 0x042f700000001814ULL,
0x0000004e4018723cULL, 0x040f700000001818ULL, 0x00000048401c723cULL, 0x048b6e000000181cULL,
0x0000030002487a10ULL, 0x020fe20007ffe0ffULL, 0x0000004a4020723cULL, 0x000f660000001820ULL,
0x0000000148117810ULL, 0x000fc80007ffe0ffULL, 0x0000005e1100720cULL, 0x000fe20003f06070ULL,
0x000000444024723cULL, 0x010f620000001824ULL, 0x0000010048117824ULL, 0x000fc800078e0272ULL,
0x00006600684c7a24ULL, 0x000fc600078e0211ULL, 0x000000464028723cULL, 0x000f700000001828ULL,
0x0000003c2c54723cULL, 0x040b700000001854ULL, 0x0000003e2c50723cULL, 0x040b700000001850ULL,
0x000000382c14723cULL, 0x040b700000001814ULL, 0x0000003a2c18723cULL, 0x040b700000001818ULL,
0x000000342c1c723cULL, 0x040b70000000181cULL, 0x000000362c20723cULL, 0x060b700000001820ULL,
0x000000302c24723cULL, 0x040b700000001824ULL, 0x000000322c28723cULL, 0x000b620000001828ULL,
0x00000c4000008947ULL, 0x000fce0003800000ULL, 0x0000000461137810ULL, 0x040fe20007ffe0ffULL,
0x00000001613d7824ULL, 0x040fe200078e0203ULL, 0x00000008612d7810ULL, 0x020fc40007ffe0ffULL,
0x000000116c387217ULL, 0x000fe20007800000ULL, 0x0000000113417824ULL, 0x100fe200078e0203ULL,
0x0000001061317810ULL, 0x000fe20007ffe0ffULL, 0x0000000813107824ULL, 0x000fe200078e00ffULL,
0x0000001461437810ULL, 0x000fe20007ffe0ffULL, 0x000000012d377824ULL, 0x000fe200078e0203ULL,
0x0000000c612f7810ULL, 0x000fe20007ffe0ffULL, 0x000000082d127824ULL, 0x000fe200078e00ffULL,
0xfffffff810417812ULL, 0x000fe200078ee241ULL, 0x0000000161107824ULL, 0x040fe200078e024cULL,
0x00000007063d7812ULL, 0x000fe200078ef83dULL, 0x0000000138387824ULL, 0x000fe200078e0a11ULL,
0xfffffff812377812ULL, 0x000fe200078ee237ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x0000001861457810ULL, 0x000fc40007ffe0ffULL, 0x000000381300720cULL, 0x080fe20003f46070ULL,
0x00000001313f7824ULL, 0x140fe200078e0203ULL, 0x0000000510107212ULL, 0x000fe200078efcffULL,
0x00000008312c7824ULL, 0x000fe200078e00ffULL, 0x000000382d00720cULL, 0x080fe20003f66070ULL,
0x0000000113127824ULL, 0x000fe200078e024cULL, 0x0000620010107a10ULL, 0x000fe20007f1e0ffULL,
0x00000001433b7824ULL, 0x040fe200078e0203ULL, 0xfffffff82c3f7812ULL, 0x000fe200078ee23fULL,
0x00000008432e7824ULL, 0x000fe200078e00ffULL, 0x0000630011117a10ULL, 0x000fe200007fe4ffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x000000383100720cULL, 0x000fc40003f86070ULL,
0xfffffff82e3b7812ULL, 0x000fe200078ee23bULL, 0x000000012f2c7824ULL, 0x100fe200078e024cULL,
0x00000005122e7212ULL, 0x080fe200078efcffULL, 0x000000012d307824ULL, 0x100fe200078e024cULL,
0x000000382f00720cULL, 0x080fe20003fa6070ULL, 0x000001002c2c7825ULL, 0x000fe200078e00ffULL,
0x000062002e2e7a10ULL, 0x000fe40007f1e0ffULL, 0x000000386100720cULL, 0x000fe20003f26070ULL,
0x0000000131127824ULL, 0x000fe200078e024cULL, 0x000000052c327212ULL, 0x000fe200078efcffULL,
0x0000010030307825ULL, 0x000fe200078e00ffULL, 0x0000001c61477810ULL, 0x000fc40007ffe0ffULL,
0x0000620032327a10ULL, 0x000fe20007fde0ffULL, 0x000000012f357824ULL, 0x040fe200078e0203ULL,
0x0000000530307212ULL, 0x080fe200078efcffULL, 0x000000082f067824ULL, 0x000fe200078e00ffULL,
0x00006300132f7a10ULL, 0x000fe200007fe4ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000063002d337a10ULL, 0x000fe400037fe4ffULL, 0xfffffff806357812ULL, 0x000fe200078ee235ULL,
0x00000001432c7824ULL, 0x000fe200078e024cULL, 0x0000000512127212ULL, 0x000fe200078efcffULL,
0x0000000145397824ULL, 0x000fe200078e0203ULL, 0x0000620030307a10ULL, 0x000fe20007f1e0ffULL,
0x000001002c2c7825ULL, 0x000fe200078e00ffULL, 0x0000620012127a10ULL, 0x000fc40007fde0ffULL,
0x0000002061497810ULL, 0x000fe20007ffe0ffULL, 0x0000000845067824ULL, 0x000fe200078e00ffULL,
0x0000630031317a10ULL, 0x000fe200007fe4ffULL, 0x000000103d3d7824ULL, 0x000fe200078e020aULL,
0x000000052c2c7212ULL, 0x000fe200078efcffULL, 0x0000000147347824ULL, 0x000fe200078e0203ULL,
0x000000384300720cULL, 0x080fe20003f06070ULL, 0x0000000847437824ULL, 0x000fe200078e00ffULL,
0xfffffff806397812ULL, 0x000fe200078ee239ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000103d7faeULL, 0x0003e2000c901c48ULL, 0x0000630013137a10ULL, 0x000fe200037fe4ffULL,
0x0000000145067824ULL, 0x040fe200078e024cULL, 0x000000384500720cULL, 0x000fe20003f26070ULL,
0x0000000149367824ULL, 0x000fc400078e0203ULL, 0x0000000849457824ULL, 0x000fe400078e00ffULL,
0x000000103f3f7824ULL, 0x100fe400078e020aULL, 0x0000001039397824ULL, 0x000fe200078e020aULL,
0x000062002c107a10ULL, 0x002fe40007fde0ffULL, 0xfffffff8433d7812ULL, 0x000fe200078ee234ULL,
0x0000001041437824ULL, 0x000fe200078e020aULL, 0x000063002d117a10ULL, 0x000fe200037fe4ffULL,
0x00000100062c7825ULL, 0x000fe200078e00ffULL, 0xfffffff845417812ULL, 0x000fc400078ee236ULL,
0x000000002e437faeULL, 0x0003e2000d101c48ULL, 0x0000000147367824ULL, 0x000fe200078e024cULL,
0x000000052c2c7212ULL, 0x080fe200078efcffULL, 0x0000001037457824ULL, 0x000fe200078e020aULL,
0x000000384700720cULL, 0x000fe20003f46070ULL, 0x0000010036367825ULL, 0x000fe200078e00ffULL,
0x000062002c2c7a10ULL, 0x000fe40007fde0ffULL, 0x0000000030457faeULL, 0x0005e2000d901c48ULL,
0x0000000149347824ULL, 0x000fe200078e024cULL, 0x000063002d2d7a10ULL, 0x000fe200037fe4ffULL,
0x0000001035477824ULL, 0x000fe200078e020aULL, 0x00000005362e7212ULL, 0x002fe200078efcffULL,
0x0000010034347825ULL, 0x000fe200078e00ffULL, 0x00000024612f7810ULL, 0x000fc40007ffe0ffULL,
0x000062002e2e7a10ULL, 0x000fe20007fde0ffULL, 0x0000000032477faeULL, 0x0003e2000e901c48ULL,
0x000000382f00720cULL, 0x0c0fe20003fa6070ULL, 0x000000012f437824ULL, 0x040fe200078e0203ULL,
0x0000000534307212ULL, 0x084fe200078efcffULL, 0x000000082f367824ULL, 0x040fe200078e00ffULL,
0x00000000123f7faeULL, 0x0005e2000e101c48ULL, 0x000000012f067824ULL, 0x000fe200078e024cULL,
0x00006300372f7a10ULL, 0x000fe200037fe4ffULL, 0x000000103b457824ULL, 0x100fe200078e020aULL,
0x0000620030307a10ULL, 0x000fe20007fde0ffULL, 0x000000103d3d7824ULL, 0x100fe200078e020aULL,
0xfffffff836437812ULL, 0x000fe200078ee243ULL, 0x0000010006327825ULL, 0x002fe200078e00ffULL,
0x0000630035317a10ULL, 0x000fe200037fe4ffULL, 0x0000000010457faeULL, 0x0003e2000c101c48ULL,
0x0000002861357810ULL, 0x000fe20007ffe0ffULL, 0x0000001041417824ULL, 0x000fe200078e020aULL,
0x00000030613f7810ULL, 0x004fe20007ffe0ffULL, 0x000000002c397faeULL, 0x0005e2000c901c48ULL,
0x000000383500720cULL, 0x0c0fe20003f86070ULL, 0x0000000135377824ULL, 0x040fe200078e0203ULL,
0x0000000532327212ULL, 0x000fe200078efcffULL, 0x0000000835347824ULL, 0x000fe200078e00ffULL,
0x000000384900720cULL, 0x000fe20003f66070ULL, 0x0000000135067824ULL, 0x000fe200078e024cULL,
0x0000002c61357810ULL, 0x000fe20007ffe0ffULL, 0x000000002e3d7faeULL, 0x0007e2000d101c48ULL,
0xfffffff834377812ULL, 0x000fe200078ee237ULL, 0x0000010006127825ULL, 0x000fe200078e00ffULL,
0x0000620032327a10ULL, 0x000fc40007fde0ffULL, 0x000000383500720cULL, 0x0c0fe20003f06070ULL,
0x0000000135347824ULL, 0x140fe200078e024cULL, 0x0000000512127212ULL, 0x080fe200078efcffULL,
0x00000001353b7824ULL, 0x000fe200078e0203ULL, 0x0000003461457810ULL, 0x002fe20007ffe0ffULL,
0x0000000835367824ULL, 0x000fe200078e00ffULL, 0x0000630033337a10ULL, 0x000fe200037fe4ffULL,
0x000000013f067824ULL, 0x040fe200078e024cULL, 0x0000620012127a10ULL, 0x000fe20007fde0ffULL,
0x0000010034347825ULL, 0x000fe200078e00ffULL, 0x000000383f00720cULL, 0x000fe20003f26070ULL,
0x0000000030417faeULL, 0x0003e2000d901c48ULL, 0x0000003861397810ULL, 0x004fe20007ffe0ffULL,
0x0000010006107825ULL, 0x000fe200078e00ffULL, 0x0000000534347212ULL, 0x000fc400078efcffULL,
0x0000630013137a10ULL, 0x000fe200037fe4ffULL, 0x000000013f067824ULL, 0x040fe200078e0203ULL,
0x0000620034347a10ULL, 0x000fe20007fde0ffULL, 0x000000083f3f7824ULL, 0x000fe200078e00ffULL,
0x0000000510107212ULL, 0x000fe200078efcffULL, 0x00000001452c7824ULL, 0x000fe200078e024cULL,
0x0000003c61617810ULL, 0x000fe20007ffe0ffULL, 0x0000001043437824ULL, 0x000fe200078e020aULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee206ULL, 0x000001002c2c7825ULL, 0x000fe200078e00ffULL,
0x0000630035357a10ULL, 0x000fc400037fe4ffULL, 0x0000620010107a10ULL, 0x000fe20007fde0ffULL,
0x0000000139067824ULL, 0x100fe200078e024cULL, 0x000000052c2c7212ULL, 0x080fe200078efcffULL,
0x00000001612e7824ULL, 0x008fe200078e024cULL, 0x0000630011117a10ULL, 0x000fe200037fe4ffULL,
0x0000010006307825ULL, 0x002fe200078e00ffULL, 0xfffffff8363b7812ULL, 0x000fe200078ee23bULL,
0x0000000032437faeULL, 0x0003e2000e901c48ULL, 0x000062002c2c7a10ULL, 0x000fe20007fde0ffULL,
0x0000000145367824ULL, 0x040fe200078e0203ULL, 0x000000384500720cULL, 0x000fe20003fa6070ULL,
0x000001002e2e7825ULL, 0x000fe200078e00ffULL, 0x0000000530307212ULL, 0x000fc400078efcffULL,
0x000000383900720cULL, 0x080fe20003f66070ULL, 0x0000000845457824ULL, 0x000fe200078e00ffULL,
0x000063002d2d7a10ULL, 0x000fe200037fe4ffULL, 0x0000000139067824ULL, 0x140fe200078e0203ULL,
0x0000620030307a10ULL, 0x000fe20007fde0ffULL, 0x0000000839397824ULL, 0x000fe200078e00ffULL,
0x000000386100720cULL, 0x040fe20003f46070ULL, 0x0000000161327824ULL, 0x042fe200078e0203ULL,
0x000000052e2e7212ULL, 0x000fe200078efcffULL, 0x00000008613d7824ULL, 0x000fe200078e00ffULL,
0xfffffff845337812ULL, 0x000fe200078ee236ULL, 0x0000001037377824ULL, 0x000fe200078e020aULL,
0xfffffff839397812ULL, 0x000fe200078ee206ULL, 0x000000103b3b7824ULL, 0x000fe200078e020aULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee232ULL, 0x000000103f057824ULL, 0x100fe200078e020aULL,
0x0000630031317a10ULL, 0x000fe200037fe4ffULL, 0x0000001033337824ULL, 0x100fe200078e020aULL,
0x000062002e2e7a10ULL, 0x000fe20007fde0ffULL, 0x0000001039397824ULL, 0x100fe200078e020aULL,
0x0000000012377faeULL, 0x0003e2000e101c48ULL, 0x000000103d3d7824ULL, 0x000fe200078e020aULL,
0x000063002f2f7a10ULL, 0x000fc400037fe4ffULL, 0x00000000343b7faeULL, 0x0003e8000c101c48ULL,
0x0000000010057faeULL, 0x0003e8000c901c48ULL, 0x000000002c337faeULL, 0x0003e8000e901c48ULL,
0x0000000030397faeULL, 0x0003e8000d901c48ULL, 0x000000002e3d7faeULL, 0x0003e2000d101c48ULL,
0x00000b1000007947ULL, 0x000fea0003800000ULL, 0x0000000461347810ULL, 0x040fe20007ffe0ffULL,
0x00000001614d7824ULL, 0x140fe200078e0203ULL, 0x0000000861327810ULL, 0x060fe20007ffe0ffULL,
0x0000000161307824ULL, 0x040fe200078e024cULL, 0x0000001461367810ULL, 0x040fe20007ffe0ffULL,
0x00000001342f7824ULL, 0x140fe200078e0203ULL, 0x0000000c613a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000834107824ULL, 0x000fe200078e00ffULL, 0x0000001061387810ULL, 0x040fe20007ffe0ffULL,
0x0000000132637824ULL, 0x040fe200078e0203ULL, 0x00000018613f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000832127824ULL, 0x000fe200078e00ffULL, 0xfffffff8102f7812ULL, 0x000fe200078ee22fULL,
0x0000000136497824ULL, 0x040fe200078e0203ULL, 0x00000024613d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000836107824ULL, 0x000fe200078e00ffULL, 0x00000007064d7812ULL, 0x000fe200078ef84dULL,
0x000000013a397824ULL, 0x000fe200078e0203ULL, 0xfffffff812637812ULL, 0x000fe200078ee263ULL,
0x000000083a2c7824ULL, 0x000fe200078e00ffULL, 0xfffffff810497812ULL, 0x000fe200078ee249ULL,
0x00000001383b7824ULL, 0x140fe200078e0203ULL, 0x0000001c613e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000838067824ULL, 0x000fe200078e00ffULL, 0x00000020613c7810ULL, 0x000fe20007ffe0ffULL,
0x000000013f437824ULL, 0x000fe200078e0203ULL, 0x0000002861707810ULL, 0x000fe20007ffe0ffULL,
0x000000083f127824ULL, 0x000fe200078e00ffULL, 0xfffffff82c397812ULL, 0x000fe200078ee239ULL,
0x000000013d377824ULL, 0x040fe200078e0203ULL, 0xfffffff8063b7812ULL, 0x000fe200078ee23bULL,
0x000000083d107824ULL, 0x000fe200078e00ffULL, 0xfffffff812437812ULL, 0x000fe200078ee243ULL,
0x000000013e417824ULL, 0x040fe200078e0203ULL, 0x0000002c614f7810ULL, 0x040fe20007ffe0ffULL,
0x000000083e2c7824ULL, 0x000fe200078e00ffULL, 0xfffffff810377812ULL, 0x000fe200078ee237ULL,
0x0000010030307825ULL, 0x000fe200078e00ffULL, 0x0000003461107810ULL, 0x000fc40007ffe0ffULL,
0xfffffff82c417812ULL, 0x000fe200078ee241ULL, 0x000000013c2d7824ULL, 0x100fe200078e0203ULL,
0x0000000530307212ULL, 0x000fe200078efcffULL, 0x000000083c067824ULL, 0x000fe400078e00ffULL,
0x0000000170137824ULL, 0x000fe200078e0203ULL, 0x0000620030307a10ULL, 0x000fe20007f1e0ffULL,
0x0000000870127824ULL, 0x000fe200078e00ffULL, 0xfffffff8062d7812ULL, 0x000fe200078ee22dULL,
0x0000000134347824ULL, 0x000fe200078e024cULL, 0x0000003061067810ULL, 0x000fe20007ffe0ffULL,
0x000000014f117824ULL, 0x000fe200078e0203ULL, 0xfffffff812137812ULL, 0x000fe200078ee213ULL,
0x0000010034347825ULL, 0x000fe200078e00ffULL, 0x0000003861127810ULL, 0x000fc40007ffe0ffULL,
0x0000003c61617810ULL, 0x000fe20007ffe0ffULL, 0x000000084f2c7824ULL, 0x000fe200078e00ffULL,
0x0000000534467212ULL, 0x000fe200078efcffULL, 0x0000000132327824ULL, 0x100fe200078e024cULL,
0x0000630031317a10ULL, 0x000fe200007fe4ffULL, 0x00000001104b7824ULL, 0x000fe200078e024cULL,
0xfffffff82c117812ULL, 0x000fe200078ee211ULL, 0x0000000110477824ULL, 0x000fe200078e0203ULL,
0x0000620046467a10ULL, 0x000fe20007f1e0ffULL, 0x0000000810107824ULL, 0x000fe400078e00ffULL,
0x0000010032327825ULL, 0x000fc600078e00ffULL, 0xfffffff810477812ULL, 0x000fe200078ee247ULL,
0x000000013a3a7824ULL, 0x100fe200078e024cULL, 0x0000000532447212ULL, 0x000fe200078efcffULL,
0x0000000138387824ULL, 0x100fe400078e024cULL, 0x0000000136367824ULL, 0x100fe400078e024cULL,
0x000000013f3f7824ULL, 0x100fe400078e024cULL, 0x000000013e3e7824ULL, 0x100fe400078e024cULL,
0x000000013c3c7824ULL, 0x000fc400078e024cULL, 0x000000013d3d7824ULL, 0x100fe400078e024cULL,
0x0000000170707824ULL, 0x100fe400078e024cULL, 0x000000014f4f7824ULL, 0x100fe400078e024cULL,
0x00000001064e7824ULL, 0x040fe400078e024cULL, 0x0000000106457824ULL, 0x040fe400078e0203ULL,
0x00000008062c7824ULL, 0x000fc400078e00ffULL, 0x00000001124a7824ULL, 0x100fe400078e024cULL,
0x00000001614c7824ULL, 0x040fe200078e024cULL, 0xfffffff82c457812ULL, 0x000fe200078ee245ULL,
0x0000000161067824ULL, 0x140fe400078e0203ULL, 0x0000000861757824ULL, 0x000fe400078e00ffULL,
0x0000000112737824ULL, 0x040fe400078e0203ULL, 0x000000103b617824ULL, 0x000fe200078e020aULL,
0xfffffff875757812ULL, 0x000fe200078ee206ULL, 0x0000000812127824ULL, 0x000fc400078e00ffULL,
0x0000001039627824ULL, 0x000fe400078e020aULL, 0x000001003a3a7825ULL, 0x000fe200078e00ffULL,
0xfffffff812737812ULL, 0x000fc600078ee273ULL, 0x0000010038387825ULL, 0x000fe200078e00ffULL,
0x000000053a427212ULL, 0x000fc600078efcffULL, 0x0000001047107824ULL, 0x100fe200078e020aULL,
0x0000630035477a10ULL, 0x000fe200007fe4ffULL, 0x00000010372c7824ULL, 0x000fe200078e020aULL,
0x0000620044447a10ULL, 0x000fe20007f1e0ffULL, 0x0000010036367825ULL, 0x000fe200078e00ffULL,
0x0000000538407212ULL, 0x000fc600078efcffULL, 0x0000001011127824ULL, 0x100fe200078e020aULL,
0x0000620040407a10ULL, 0x000fe20007f3e0ffULL, 0x0000001045117824ULL, 0x100fe200078e020aULL,
0x0000630033457a10ULL, 0x000fe200007fe4ffULL, 0x000001003f347825ULL, 0x000fe200078e00ffULL,
0x0000620042427a10ULL, 0x000fe40007f1e0ffULL, 0x00000005363f7212ULL, 0x080fe200078efcffULL,
0x000000102f647824ULL, 0x100fe200078e020aULL, 0x0000000534347212ULL, 0x000fe200078efcffULL,
0x00000010432f7824ULL, 0x100fe200078e020aULL, 0x000063003b437a10ULL, 0x000fe200007fe4ffULL,
0x00000010412e7824ULL, 0x000fe200078e020aULL, 0x0000630039417a10ULL, 0x000fe20000ffe4ffULL,
0x000001003e327825ULL, 0x000fe200078e00ffULL, 0x000062003f3e7a10ULL, 0x000fc60007f1e0ffULL,
0x000001003c387825ULL, 0x000fe200078e00ffULL, 0x00006300373f7a10ULL, 0x000fe400007fe4ffULL,
0x00006200343c7a10ULL, 0x000fe20007f1e0ffULL, 0x000001003d367825ULL, 0x000fe200078e00ffULL,
0x00000005323a7212ULL, 0x080fe400078efcffULL, 0x0000000538387212ULL, 0x000fe200078efcffULL,
0x000000104d4d7824ULL, 0x000fe200078e020aULL, 0x00006300353d7a10ULL, 0x000fe200007fe4ffULL,
0x0000010070347825ULL, 0x000fe200078e00ffULL, 0x000062003a3a7a10ULL, 0x000fc40007f3e0ffULL,
0x0000620038387a10ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000304d7faeULL, 0x0003e2000b901c48ULL, 0x0000000536367212ULL, 0x080fe200078efcffULL,
0x0000001063637824ULL, 0x000fe200078e020aULL, 0x00006300333b7a10ULL, 0x000fe20000ffe4ffULL,
0x000001004f327825ULL, 0x000fe200078e00ffULL, 0x0000630039397a10ULL, 0x000fe200007fe4ffULL,
0x0000000046647faeULL, 0x0005e2000b901c48ULL, 0x0000620036367a10ULL, 0x000fe20007f1e0ffULL,
0x000001004e4e7825ULL, 0x000fe200078e00ffULL, 0x0000000534347212ULL, 0x080fe200078efcffULL,
0x0000000044637faeULL, 0x0005e2000b901c48ULL, 0x0000630037377a10ULL, 0x000fe200007fe4ffULL,
0x000001004b307825ULL, 0x002fe200078e00ffULL, 0x0000620034347a10ULL, 0x000fe20007f1e0ffULL,
0x0000000042627faeULL, 0x0005e2000b901c48ULL, 0x000000054e4e7212ULL, 0x080fe200078efcffULL,
0x000001004a4a7825ULL, 0x000fe200078e00ffULL, 0x0000000532327212ULL, 0x000fe200078efcffULL,
0x0000000040617faeULL, 0x0005e2000b901c48ULL, 0x0000630035357a10ULL, 0x000fe200007fe4ffULL,
0x000001004c4c7825ULL, 0x000fe200078e00ffULL, 0x000062004e4e7a10ULL, 0x000fc40007f1e0ffULL,
0x0000620032327a10ULL, 0x000fe20007f3e0ffULL, 0x0000001049497824ULL, 0x100fe200078e020aULL,
0x0000000530707212ULL, 0x080fe200078efcffULL, 0x000000102d2d7824ULL, 0x100fe200078e020aULL,
0x000000054a4a7212ULL, 0x080fe200078efcffULL, 0x0000001013137824ULL, 0x100fe200078e020aULL,
0x000000054c057212ULL, 0x000fe200078efcffULL, 0x000000003e497faeULL, 0x0005e2000b901c48ULL,
0x000063004f4f7a10ULL, 0x000fe200007fe4ffULL, 0x0000001073067824ULL, 0x100fe200078e020aULL,
0x0000630033337a10ULL, 0x000fe20000ffe4ffULL, 0x000000003c2f7faeULL, 0x0005e2000b901c48ULL,
0x0000620070307a10ULL, 0x000fe20007f1e0ffULL, 0x00000010750a7824ULL, 0x000fe200078e020aULL,
0x000062004a4a7a10ULL, 0x000fe20007f3e0ffULL, 0x000000003a2e7faeULL, 0x0005e2000b901c48ULL,
0x00006200054c7a10ULL, 0x000fc40007f5e0ffULL, 0x0000630031317a10ULL, 0x000fe200007fe4ffULL,
0x00000000382d7faeULL, 0x0005e2000b901c48ULL, 0x000063004b4b7a10ULL, 0x000fe40000ffe4ffULL,
0x000063004d4d7a10ULL, 0x000fe200017fe4ffULL, 0x00000000362c7faeULL, 0x0005e8000b901c48ULL,
0x0000000034137faeULL, 0x0005e8000b901c48ULL, 0x0000000032127faeULL, 0x0005e8000b901c48ULL,
0x000000004e117faeULL, 0x0005e8000b901c48ULL, 0x0000000030107faeULL, 0x0005e8000b901c48ULL,
0x000000004a067faeULL, 0x0005e8000b901c48ULL, 0x000000004c0a7faeULL, 0x0005e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001007067824ULL, 0x044fe200078e00ffULL,
0x0000000808057810ULL, 0x002fe20007ffe0ffULL, 0x0000001007397824ULL, 0x000fe200078e00ffULL,
0x0000300009097810ULL, 0x000fc40007ffe0ffULL, 0xfffffff006057812ULL, 0x000fe400078ee205ULL,
0x0000000a08067810ULL, 0x000fe20007ffe0ffULL, 0x000000105d2c7824ULL, 0x100fe400078e0209ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0xfffffff039067812ULL, 0x000fe200078ee206ULL,
0x000000105b307824ULL, 0x100fe400078e0209ULL, 0x000000105c347824ULL, 0x100fe400078e0209ULL,
0x000000105a407824ULL, 0x000fc400078e0209ULL, 0x00000010603c7824ULL, 0x100fe400078e0209ULL,
0x0000001006067824ULL, 0x000fe400078e00ffULL, 0x0000001065447824ULL, 0x000fe200078e0209ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002c2c783bULL, 0x000fe20000000200ULL,
0x000000100c0c7824ULL, 0x000fc600078e0209ULL, 0x000000000510783bULL, 0x0002a80000000200ULL,
0x000000003030783bULL, 0x000ee80000000200ULL, 0x000000003434783bULL, 0x000f220000000200ULL,
0x0000000c08057810ULL, 0x042fe40007ffe0ffULL, 0x0000000e08087810ULL, 0x000fe20007ffe0ffULL,
0x000000004040783bULL, 0x000e680000000200ULL, 0x000000003c3c783bULL, 0x000fe80000000200ULL,
0x000000000638783bULL, 0x0004680000000200ULL, 0x000000004444783bULL, 0x000fe20000000200ULL,
0x0000001007067824ULL, 0x004fc400078e00ffULL, 0x0000001007077824ULL, 0x000fc600078e00ffULL,
0xfffffff006057812ULL, 0x000fe400078ee205ULL, 0xfffffff007087812ULL, 0x000fc600078ee208ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x0000002c1054723cULL, 0x040b6e0000001854ULL,
0x00000010672c7824ULL, 0x120fe200078e0209ULL, 0x0000002e1050723cULL, 0x040bea0000001850ULL,
0x000000002c2c783bULL, 0x020ea60000000200ULL, 0x00000030101c723cULL, 0x048b6e000000181cULL,
0x000000105f307824ULL, 0x120fe200078e0209ULL, 0x000000341014723cULL, 0x050ff00000001814ULL,
0x000000361018723cULL, 0x040be40000001818ULL, 0x000000000534783bULL, 0x020fec0000000200ULL,
0x000000321020723cULL, 0x040b640000001820ULL, 0x000000003030783bULL, 0x020eec0000000200ULL,
0x000000401024723cULL, 0x042bee0000001824ULL, 0x000000100b407824ULL, 0x120fe200078e0209ULL,
0x000000421028723cULL, 0x000bea0000001828ULL, 0x000000004040783bULL, 0x020fe40000000200ULL,
0x0000001066107824ULL, 0x100fe200078e0209ULL, 0x0000003c3854723cULL, 0x040b6a0000001854ULL,
0x000000001010783bULL, 0x000e640000000200ULL, 0x00000010593c7824ULL, 0x120fe200078e0209ULL,
0x0000002c381c723cULL, 0x044bee000000181cULL, 0x00000010582c7824ULL, 0x120fe200078e0209ULL,
0x0000003e3850723cULL, 0x040b640000001850ULL, 0x000000003c3c783bULL, 0x020fec0000000200ULL,
0x0000002e3820723cULL, 0x040b640000001820ULL, 0x000000002c2c783bULL, 0x020eac0000000200ULL,
0x000000443814723cULL, 0x000bee0000001814ULL, 0x000000100d447824ULL, 0x120fe200078e0209ULL,
0x000000303454723cULL, 0x008bee0000001854ULL, 0x000000100e307824ULL, 0x120fe200078e0209ULL,
0x000000103824723cULL, 0x002be20000001824ULL, 0x000000100f097824ULL, 0x000fcc00078e0209ULL,
0x0000001008107824ULL, 0x020fe200078e00ffULL, 0x000000123828723cULL, 0x040b620000001828ULL,
0x000000000908783bULL, 0x000fe80000000200ULL, 0x000000001010783bULL, 0x020fe60000000200ULL,
0x000000463818723cULL, 0x000b640000001818ULL, 0x000000000c38783bULL, 0x020fe80000000200ULL,
0x000000004444783bULL, 0x000fe40000000200ULL, 0x000000323450723cULL, 0x040be40000001850ULL,
0x000000003030783bULL, 0x020e6c0000000200ULL, 0x0000002e3420723cULL, 0x044f700000001820ULL,
0x000000423428723cULL, 0x040f700000001828ULL, 0x0000003c3414723cULL, 0x040ff00000001814ULL,
0x0000003e3418723cULL, 0x040ff00000001818ULL, 0x0000002c341c723cULL, 0x040ff0000000181cULL,
0x000000403424723cULL, 0x000ff00000001824ULL, 0x000000321020723cULL, 0x062f700000001820ULL,
0x0000000a1028723cULL, 0x040f700000001828ULL, 0x000000381054723cULL, 0x040f700000001854ULL,
0x0000003a1050723cULL, 0x000f640000001850ULL, 0x3db504f3212e7820ULL, 0x020fc40000410000ULL,
0x3db504f320207820ULL, 0x000fe40000410000ULL, 0x3db504f322227820ULL, 0x000fe40000410000ULL,
0x3db504f3232d7820ULL, 0x000fe20000410000ULL, 0x000000441014723cULL, 0x000f620000001814ULL,
0x3db504f329217820ULL, 0x000fe40000410000ULL, 0x3db504f328287820ULL, 0x000fe40000410000ULL,
0x3db504f32a2a7820ULL, 0x000fc40000410000ULL, 0x3db504f32b297820ULL, 0x000fe20000410000ULL,
0x000000461018723cULL, 0x040f620000001818ULL, 0x3db504f354547820ULL, 0x000fe40000410000ULL,
0x3db504f355557820ULL, 0x000fe40000410000ULL, 0x3db504f356567820ULL, 0x000fe40000410000ULL,
0x3db504f357577820ULL, 0x000fe20000410000ULL, 0x00000030101c723cULL, 0x000f62000000181cULL,
0x3db504f350507820ULL, 0x000fc40000410000ULL, 0x3db504f352527820ULL, 0x000fca0000410000ULL,
0x000000081024723cULL, 0x000b640000001824ULL, 0x3db504f315057820ULL, 0x020fca0000410000ULL,
0x3db504f351137820ULL, 0x000fe40000410000ULL, 0x3db504f353127820ULL, 0x000fe40000410000ULL,
0x3db504f314117820ULL, 0x000fe40000410000ULL, 0x3db504f316087820ULL, 0x000fe40000410000ULL,
0x3db504f317097820ULL, 0x000fe40000410000ULL, 0x3db504f318187820ULL, 0x000fc40000410000ULL,
0x3db504f319317820ULL, 0x000fe40000410000ULL, 0x3db504f31a0a7820ULL, 0x000fe40000410000ULL,
0x3db504f31b307820ULL, 0x000fe40000410000ULL, 0x3db504f31c2f7820ULL, 0x000fe40000410000ULL,
0x3db504f31d1d7820ULL, 0x000fe40000410000ULL, 0x3db504f31e1e7820ULL, 0x000fc40000410000ULL,
0x3db504f31f1f7820ULL, 0x000fe40000410000ULL, 0x3db504f3242c7820ULL, 0x000fe40000410000ULL,
0x3db504f325067820ULL, 0x000fe40000410000ULL, 0x3db504f3260b7820ULL, 0x000fe40000410000ULL,
0x3db504f327277820ULL, 0x000fe20000410000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0006ULL, 0x000000006f067f8cULL, 0x0002a2000c80043fULL,
0x000000ffff257224ULL, 0x000fc400078e001dULL, 0x000000ffff267224ULL, 0x000fe400078e0020ULL,
0x000000ffff1d7224ULL, 0x000fe400078e001fULL, 0x000000ffff247224ULL, 0x000fe400078e0018ULL,
0x000000ffff207224ULL, 0x000fe400078e0028ULL, 0x000000ffff1f7224ULL, 0x000fe400078e0022ULL,
0x000000ffff197224ULL, 0x000fc400078e0054ULL, 0x000000ffff177224ULL, 0x000fe400078e0055ULL,
0x000000ffff157224ULL, 0x000fe400078e0050ULL, 0x000000ffff237224ULL, 0x000fe400078e0005ULL,
0x000000ffff187224ULL, 0x000fe400078e0056ULL, 0x000000ffff167224ULL, 0x000fe400078e0057ULL,
0x000000ffff147224ULL, 0x000fc400078e0052ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0008ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0009ULL, 0x000000ffff1c7224ULL, 0x000fe400078e000aULL,
0x000000ffff227224ULL, 0x000fe400078e000bULL, 0x000000ffff287224ULL, 0x000fc400078e002aULL,
0x0000000000087805ULL, 0x006fca0000015200ULL, 0x000004006f057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140bULL, 0x0000000a05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000205057819ULL, 0x000fc8000000120aULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004006f057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004032a7824ULL, 0x000fe200078e00ffULL,
0x0000006d0200720cULL, 0x000fc80003f06070ULL, 0xfffffff02a057812ULL, 0x000fca00078ec0ffULL,
0x0000008000107824ULL, 0x000fca00078e0205ULL, 0x01b4000010087984ULL, 0x0002a20000000c00ULL,
0x0000135000008947ULL, 0x000fea0003800000ULL, 0x0000000203027824ULL, 0x040fe200078e00ffULL,
0x000000046c337217ULL, 0x000fe20007800000ULL, 0x00000002ff437424ULL, 0x000fe200078e00ffULL,
0x0000006b03057211ULL, 0x000fe400078ff0ffULL, 0x0000000602027812ULL, 0x000fe200078ec0ffULL,
0x0000000133337824ULL, 0x000fe200078e0a04ULL, 0x00005a00ff077a19ULL, 0x000fe40000011605ULL,
0x0000580002327a10ULL, 0x000fe20007ffe0ffULL, 0x0000000169047824ULL, 0x000fe200078e0202ULL,
0x000000076e077217ULL, 0x000fc40003800000ULL, 0x000000333200720cULL, 0x080fe20003f06070ULL,
0x00000001040d7824ULL, 0x140fe200078e0a33ULL, 0x000000330400720cULL, 0x000fe20003f26070ULL,
0x000000076a527224ULL, 0x000fe200078e02ffULL, 0x0000000805047810ULL, 0x000fe20007ffe0ffULL,
0x0000000132057824ULL, 0x000fe200078e0a33ULL, 0x0000000d6e0d7217ULL, 0x040fe40003800000ULL,
0x00005a00ff0f7a19ULL, 0x000fe40000011604ULL, 0x000000056e057217ULL, 0x000fc40003800000ULL,
0x00000004ff0d7819ULL, 0x000fe4000001160dULL, 0x0000001002367812ULL, 0x000fe400078efcffULL,
0x000000ff05357207ULL, 0x000fe40000000000ULL, 0x000000ff0d057207ULL, 0x000fe40000800000ULL,
0x0000000f6e0f7217ULL, 0x000fe20003800000ULL, 0x00000001690e7824ULL, 0x000fe200078e0236ULL,
0x0000580036387a10ULL, 0x000fe20007ffe0ffULL, 0x0000000152067824ULL, 0x000fe200078e0205ULL,
0x00000052350c7211ULL, 0x000fe200078fe0ffULL, 0x0000000f6a507224ULL, 0x000fc400078e02ffULL,
0x000000010e3b7824ULL, 0x100fe400078e0a33ULL, 0x00000001380f7824ULL, 0x000fe200078e0a33ULL,
0x00000020023e7812ULL, 0x000fe200078efcffULL, 0x000060000c0c7625ULL, 0x000fe200078e0043ULL,
0x0000003b6e3b7217ULL, 0x000fc60003800000ULL, 0x0000600006067625ULL, 0x000fe200078e0043ULL,
0x000000333800720cULL, 0x000fe20003f06070ULL, 0x000000080c377981ULL, 0x000722000c1e9500ULL,
0x0000000f6e0f7217ULL, 0x000fe40003800000ULL, 0x000058003e407a10ULL, 0x000fe20007ffe0ffULL,
0x0000000806347981ULL, 0x000322000c1e9500ULL, 0x0000005035047211ULL, 0x000fe200078fe0ffULL,
0x00000001053c7824ULL, 0x000fe200078e0250ULL, 0x000000330e00720cULL, 0x000fe40003f26070ULL,
0x00000004ff3b7819ULL, 0x000fc4000001163bULL, 0x000000ff0f3a7207ULL, 0x000fe20000000000ULL,
0x00000001403f7824ULL, 0x000fe200078e0a33ULL, 0x000000ff3b0d7207ULL, 0x008fe20000800000ULL,
0x0000600004047625ULL, 0x000fe200078e0043ULL, 0x000000523a067211ULL, 0x002fc600078fe0ffULL,
0x000060003c3c7625ULL, 0x000fe200078e0043ULL, 0x000000334000720cULL, 0x000fe20003f06070ULL,
0x0000000804397981ULL, 0x0002e2000c1e9500ULL, 0x0000003f6e3f7217ULL, 0x000fe20003800000ULL,
0x0000000169467824ULL, 0x000fe400078e023eULL, 0x00000001520c7824ULL, 0x000fe200078e020dULL,
0x000000083c3c7981ULL, 0x0004e2000c1e9500ULL, 0x0000000146417824ULL, 0x000fe200078e0a33ULL,
0x000000ff3f477207ULL, 0x000fe20000000000ULL, 0x0000600006047625ULL, 0x002fe200078e0043ULL,
0x000000334600720cULL, 0x000fc40003f26070ULL, 0x0000003002467812ULL, 0x000fe200078efcffULL,
0x000060000c067625ULL, 0x000fe200078e0043ULL, 0x000000503a0c7211ULL, 0x000fe200078fe0ffULL,
0x00000008043b7981ULL, 0x0002e2000c1e9500ULL, 0x000000416e417217ULL, 0x000fe20003800000ULL,
0x000000010d0e7824ULL, 0x000fe400078e0250ULL, 0x0000000169547824ULL, 0x000fe200078e0246ULL,
0x00000004ff417819ULL, 0x000fe20000011641ULL, 0x000060000c0c7625ULL, 0x080fe200078e0043ULL,
0x00005800464a7a10ULL, 0x000fe20007ffe0ffULL, 0x0000000806427981ULL, 0x0004e2000c1e9500ULL,
0x0000005247047211ULL, 0x002fe200078fe0ffULL, 0x000060000e0e7625ULL, 0x080fe200078e0043ULL,
0x000000ff41417207ULL, 0x000fe20000800000ULL, 0x000000080c3d7981ULL, 0x0042a4000c1e9500ULL,
0x0000600004047625ULL, 0x000fc400078e0043ULL, 0x000000080e447981ULL, 0x0002a4000c1e9500ULL,
0x0000000154457824ULL, 0x000fe400078e0a33ULL, 0x00000008043f7981ULL, 0x0002a2000c1e9500ULL,
0x0000000152067824ULL, 0x000fe200078e0241ULL, 0x00000050470c7211ULL, 0x002fe400078fe0ffULL,
0x000000456e457217ULL, 0x000fe20003800000ULL, 0x00000001410e7824ULL, 0x000fe400078e0250ULL,
0x000000014a057824ULL, 0x040fe200078e0a33ULL, 0x000000334a00720cULL, 0x000fe20003f06070ULL,
0x0000600006067625ULL, 0x000fe200078e0043ULL, 0x000000335400720cULL, 0x000fc40003f26070ULL,
0x000000056e057217ULL, 0x000fe20003800000ULL, 0x000060000c0c7625ULL, 0x080fe200078e0043ULL,
0x00000004ff457819ULL, 0x000fe20000011645ULL, 0x00000008064c7981ULL, 0x0002a4000c1e9500ULL,
0x000060000e0e7625ULL, 0x000fe200078e0043ULL, 0x000000ff05497207ULL, 0x000fe20000000000ULL,
0x000000080c417981ULL, 0x0002a2000c1e9500ULL, 0x000000ff45457207ULL, 0x000fc60000800000ULL,
0x000000080e4e7981ULL, 0x0002a2000c1e9500ULL, 0x0000005249047211ULL, 0x000fe200078fe0ffULL,
0x0000000152067824ULL, 0x002fc800078e0245ULL, 0x0000600004047625ULL, 0x000fc800078e0043ULL,
0x0000600006067625ULL, 0x000fe400078e0043ULL, 0x0000000804047981ULL, 0x0002a2000c1e9500ULL,
0x00000050490c7211ULL, 0x000fc600078fe0ffULL, 0x0000000806077981ULL, 0x0002a2000c1e9500ULL,
0x00000001450e7824ULL, 0x000fe400078e0250ULL, 0x000060000c0c7625ULL, 0x000fc800078e0043ULL,
0x000060000e0e7625ULL, 0x000fe400078e0043ULL, 0x000000080c0c7981ULL, 0x0002a8000c1e9500ULL,
0x000000080e0f7981ULL, 0x0002a2000c1e9500ULL, 0xfffffff0354b7812ULL, 0x000fe200078ec0ffULL,
0x00000001ff437424ULL, 0x000fe200078e00ffULL, 0xfffffff03a4d7812ULL, 0x000fc600078ec0ffULL,
0x00000001334b7824ULL, 0x000fe200078e024bULL, 0x0000000102787812ULL, 0x000fc600078efcffULL,
0x00000001323a7824ULL, 0x000fe200078e0a4bULL, 0x0000000802767812ULL, 0x040fe400078efcffULL,
0x0000000902747812ULL, 0x000fe400078efcffULL, 0x0000003a433a7219ULL, 0x000fe400000006ffULL,
0x0000580078057a10ULL, 0x002fe40007ffe0ffULL, 0x00005800767c7a10ULL, 0x000fe40007ffe0ffULL,
0x00005800747a7a10ULL, 0x000fc40007ffe0ffULL, 0xfffffff0474f7812ULL, 0x000fe200078ec0ffULL,
0x0000000105477824ULL, 0x100fe200078e0a4bULL, 0xfffffff049517812ULL, 0x000fe200078ec0ffULL,
0x000000017c497824ULL, 0x100fe400078e0a4bULL, 0x000000017a4b7824ULL, 0x000fe200078e0a4bULL,
0x0000001802607812ULL, 0x000fe400078efcffULL, 0x0000004943497219ULL, 0x040fe400000006ffULL,
0x0000004b434b7219ULL, 0x000fe200000006ffULL, 0x00000001334d7824ULL, 0x040fe200078e024dULL,
0x0000580060667a10ULL, 0x000fe20007ffe0ffULL, 0x0000000133657824ULL, 0x000fc400078e024fULL,
0x00000001384f7824ULL, 0x100fe400078e0a4dULL, 0x0000000166577824ULL, 0x000fe200078e0a4dULL,
0x0000001102627812ULL, 0x040fe400078efcffULL, 0x00000019025c7812ULL, 0x000fe400078efcffULL,
0x0000004743477219ULL, 0x040fe400000006ffULL, 0x0000004f434f7219ULL, 0x040fe400000006ffULL,
0x0000005743577219ULL, 0x000fc400000006ffULL, 0x0000580062707a10ULL, 0x000fe40007ffe0ffULL,
0x000058005c647a10ULL, 0x000fe20007ffe0ffULL, 0x00000001405b7824ULL, 0x000fe400078e0a65ULL,
0x0000000170537824ULL, 0x100fe400078e0a4dULL, 0x00000001645f7824ULL, 0x000fe200078e0a4dULL,
0x0000002102567812ULL, 0x040fe400078efcffULL, 0x0000002802547812ULL, 0x000fc400078efcffULL,
0x0000002902527812ULL, 0x000fe400078efcffULL, 0x0000005343537219ULL, 0x040fe400000006ffULL,
0x0000005f435f7219ULL, 0x040fe400000006ffULL, 0x0000005b435b7219ULL, 0x000fe400000006ffULL,
0x00005800565a7a10ULL, 0x000fe40007ffe0ffULL, 0x0000580054587a10ULL, 0x000fe20007ffe0ffULL,
0x0000000133517824ULL, 0x000fe200078e0251ULL, 0x00005800520d7a10ULL, 0x000fe20007ffe0ffULL,
0x000000015a597824ULL, 0x000fc400078e0a65ULL, 0x0000000158637824ULL, 0x100fe400078e0a65ULL,
0x000000010d657824ULL, 0x000fe400078e0a65ULL, 0x000000014a617824ULL, 0x000fe200078e0a51ULL,
0x0000003102507812ULL, 0x040fe400078efcffULL, 0x00000038020e7812ULL, 0x040fe400078efcffULL,
0x0000003902067812ULL, 0x000fe400078efcffULL, 0x0000005943597219ULL, 0x000fc400000006ffULL,
0x0000006343637219ULL, 0x040fe400000006ffULL, 0x0000006543657219ULL, 0x040fe400000006ffULL,
0x0000006143617219ULL, 0x000fe400000006ffULL, 0x0000580050357a10ULL, 0x000fe40007ffe0ffULL,
0x000058000e457a10ULL, 0x000fe40007ffe0ffULL, 0x00005800064d7a10ULL, 0x000fe20007ffe0ffULL,
0x00000001355d7824ULL, 0x000fc400078e0a51ULL, 0x0000000145557824ULL, 0x100fe400078e0a51ULL,
0x000000014d517824ULL, 0x000fe200078e0a51ULL, 0x0000005d435d7219ULL, 0x040fe400000006ffULL,
0x0000005543557219ULL, 0x040fe400000006ffULL, 0x0000005143517219ULL, 0x000fe400000006ffULL,
0x0000541037347816ULL, 0x010fc80000000034ULL, 0x000000343aff7212ULL, 0x000fc8000780c0ffULL,
0x000000333200720cULL, 0x000fc80000701470ULL, 0x000000330200720cULL, 0x000fc80000701070ULL,
0xff80000019197808ULL, 0x000fe40000000000ULL, 0x00005410393c7816ULL, 0x008fc8000000003cULL,
0x0000003c3aff7212ULL, 0x080fe4000788c0ffULL, 0x0000003c49ff7212ULL, 0x080fe400078cc0ffULL,
0x0000003c4bff7212ULL, 0x000fe4000780c0ffULL, 0x000000333200720cULL, 0x080fe40002781470ULL,
0x000000337c00720cULL, 0x080fe400037c1470ULL, 0x000000337a00720cULL, 0x000fc40000701470ULL,
0x000000344bff7212ULL, 0x000fe4000782c0ffULL, 0x000000330200720cULL, 0x080fe40002781070ULL,
0x000000337600720cULL, 0x080fe400037c1070ULL, 0x000000337400720cULL, 0x000fe40000701070ULL,
0x000054103b427816ULL, 0x000fe40000000042ULL, 0x000054103d447816ULL, 0x004fc40000000044ULL,
0x000000337a00720cULL, 0x000fe40000f21470ULL, 0xff80000018187808ULL, 0x000fe40002000000ULL,
0xff80000014147808ULL, 0x000fe40003000000ULL, 0xff80000012127808ULL, 0x000fe40000000000ULL,
0x0000003447ff7212ULL, 0x080fe4000786c0ffULL, 0x0000003449ff7212ULL, 0x000fc4000784c0ffULL,
0x0000003c47ff7212ULL, 0x000fe400078ac0ffULL, 0x000000424fff7212ULL, 0x040fe4000788c0ffULL,
0x000000444fff7212ULL, 0x080fe400078cc0ffULL, 0x0000004457ff7212ULL, 0x000fe4000780c0ffULL,
0x000000337400720cULL, 0x080fe40000f21070ULL, 0x000000330500720cULL, 0x000fc40001f61470ULL,
0x000000330500720cULL, 0x080fe40002fa1470ULL, 0x000000337c00720cULL, 0x080fe40001741470ULL,
0x000000333800720cULL, 0x0c0fe40002781470ULL, 0x000000333800720cULL, 0x080fe400037c1470ULL,
0x000000336600720cULL, 0x000fe40000701470ULL, 0xff80000013137808ULL, 0x000fc40000800000ULL,
0x000000337800720cULL, 0x0c0fe40001f61070ULL, 0x000000337800720cULL, 0x080fe40002fa1070ULL,
0x000000337600720cULL, 0x080fe40001741070ULL, 0x000000333600720cULL, 0x0c0fe40002721070ULL,
0x000000333600720cULL, 0x080fe400037c1070ULL, 0x000000336000720cULL, 0x000fc40000701070ULL,
0x000054103f4c7816ULL, 0x000fe4000000004cULL, 0x00005410414e7816ULL, 0x000fe4000000004eULL,
0xff80000017177808ULL, 0x000fe40001800000ULL, 0xff80000016167808ULL, 0x000fe40002800000ULL,
0xff80000015157808ULL, 0x000fe40001000000ULL, 0xff80000011117808ULL, 0x000fc40000800000ULL,
0xff8000001b1b7808ULL, 0x000fe40003000000ULL, 0xff8000001c1c7808ULL, 0x000fe40000000000ULL,
0x0000004253ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004257ff7212ULL, 0x080fe400078ac0ffULL,
0x000000425fff7212ULL, 0x000fe4000784c0ffULL, 0x0000004453ff7212ULL, 0x000fc4000788c0ffULL,
0x000000445fff7212ULL, 0x000fe4000782c0ffULL, 0x0000004c5bff7212ULL, 0x040fe400078cc0ffULL,
0x0000004e5bff7212ULL, 0x000fe4000780c0ffULL, 0x000000337000720cULL, 0x0c0fe40001f61470ULL,
0x000000337000720cULL, 0x080fe40002781470ULL, 0x000000336600720cULL, 0x000fc40002fa1470ULL,
0x000000336400720cULL, 0x0c0fe40001741470ULL, 0x000000336400720cULL, 0x080fe40000f21470ULL,
0x000000334000720cULL, 0x0c0fe400037c1470ULL, 0x000000334000720cULL, 0x080fe40000701470ULL,
0x000000336200720cULL, 0x0c0fe40001f61070ULL, 0x000000336200720cULL, 0x000fc40002781070ULL,
0x000000336000720cULL, 0x080fe40002fa1070ULL, 0x000000335c00720cULL, 0x0c0fe40001741070ULL,
0x000000335c00720cULL, 0x080fe40000f21070ULL, 0x000000333e00720cULL, 0x0c0fe400037c1070ULL,
0x000000333e00720cULL, 0x000fe40000701070ULL, 0x0000541004047816ULL, 0x000fc40000000007ULL,
0xff80000023237808ULL, 0x000fe40001800000ULL, 0xff8000001a1a7808ULL, 0x000fe40002000000ULL,
0xff80000024247808ULL, 0x000fe40002800000ULL, 0xff80000031317808ULL, 0x000fe40001000000ULL,
0xff80000030307808ULL, 0x000fe40000800000ULL, 0xff8000002f2f7808ULL, 0x000fc40003000000ULL,
0xff8000001e1e7808ULL, 0x000fe40000000000ULL, 0x0000004c59ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004c63ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004c65ff7212ULL, 0x000fe400078ac0ffULL,
0x0000004e59ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004e63ff7212ULL, 0x000fc4000782c0ffULL,
0x0000004e65ff7212ULL, 0x000fe400078cc0ffULL, 0x0000000461ff7212ULL, 0x000fe4000780c0ffULL,
0x000000335a00720cULL, 0x0c0fe40001f61470ULL, 0x000000335a00720cULL, 0x080fe40001741470ULL,
0x000000335800720cULL, 0x0c0fe40002781470ULL, 0x000000335800720cULL, 0x000fc40000f21470ULL,
0x000000330d00720cULL, 0x0c0fe40002fa1470ULL, 0x000000330d00720cULL, 0x080fe400037c1470ULL,
0x000000334a00720cULL, 0x080fe40000701470ULL, 0x000000335600720cULL, 0x0c0fe40001f61070ULL,
0x000000335600720cULL, 0x080fe40001741070ULL, 0x000000335400720cULL, 0x000fc40002781070ULL,
0x000000335400720cULL, 0x080fe40000f21070ULL, 0x000000335200720cULL, 0x0c0fe40002fa1070ULL,
0x000000335200720cULL, 0x080fe400037c1070ULL, 0x000000334600720cULL, 0x000fe40000701070ULL,
0x000054100c0c7816ULL, 0x000fe4000000000fULL, 0xff80000025257808ULL, 0x000fc40001800000ULL,
0xff8000001d1d7808ULL, 0x000fe40001000000ULL, 0xff80000026267808ULL, 0x000fe40002000000ULL,
0xff8000001f1f7808ULL, 0x000fe40000800000ULL, 0xff8000002e2e7808ULL, 0x000fe40002800000ULL,
0xff8000002d2d7808ULL, 0x000fe40003000000ULL, 0xff8000002c2c7808ULL, 0x000fc40000000000ULL,
0x000000045dff7212ULL, 0x080fe4000786c0ffULL, 0x0000000455ff7212ULL, 0x080fe4000784c0ffULL,
0x0000000451ff7212ULL, 0x000fe4000788c0ffULL, 0x0000000c61ff7212ULL, 0x080fe4000782c0ffULL,
0x0000000c5dff7212ULL, 0x080fe400078ac0ffULL, 0x0000000c55ff7212ULL, 0x000fc400078cc0ffULL,
0x0000000c51ff7212ULL, 0x000fe4000780c0ffULL, 0x000000334a00720cULL, 0x080fe40000f21470ULL,
0x000000333500720cULL, 0x0c0fe40001f61470ULL, 0x000000333500720cULL, 0x080fe40002fa1470ULL,
0x000000334500720cULL, 0x0c0fe40001741470ULL, 0x000000334500720cULL, 0x000fc400037c1470ULL,
0x000000334d00720cULL, 0x0c0fe40002781470ULL, 0x000000334d00720cULL, 0x080fe40000701470ULL,
0x000000334600720cULL, 0x080fe40000f21070ULL, 0x000000335000720cULL, 0x0c0fe40001f61070ULL,
0x000000335000720cULL, 0x080fe40002fa1070ULL, 0x000000330e00720cULL, 0x000fc40001741070ULL,
0x000000330e00720cULL, 0x080fe400037c1070ULL, 0x000000330600720cULL, 0x0c0fe40002781070ULL,
0x000000330600720cULL, 0x000fe40000701070ULL, 0xff8000002b2b7808ULL, 0x000fe40001800000ULL,
0xff80000020207808ULL, 0x000fe40001000000ULL, 0xff80000021217808ULL, 0x000fc40002000000ULL,
0xff80000022227808ULL, 0x000fe40000800000ULL, 0xff80000027277808ULL, 0x000fe40002800000ULL,
0xff80000028287808ULL, 0x000fe40003000000ULL, 0xff80000029297808ULL, 0x000fc40000000000ULL,
0x000000190800720bULL, 0x004fe40003f1e000ULL, 0x000000180900720bULL, 0x000fe40003f3e000ULL,
0x0000000819087208ULL, 0x000fc40004000000ULL, 0x0000000918097208ULL, 0x000fe40004800000ULL,
0x000000170800720bULL, 0x000fe40003f1e000ULL, 0x000000160900720bULL, 0x000fe40003f3e000ULL,
0x0000000817087208ULL, 0x000fe40004000000ULL, 0x0000000916097208ULL, 0x000fe40004800000ULL,
0x000000150800720bULL, 0x000fc40003f1e000ULL, 0x000000140900720bULL, 0x000fe40003f3e000ULL,
0x0000000815087208ULL, 0x000fe40004000000ULL, 0x0000000914097208ULL, 0x000fe40004800000ULL,
0x000000130800720bULL, 0x000fe40003f1e000ULL, 0x000000120900720bULL, 0x000fe40003f3e000ULL,
0x0000000813087208ULL, 0x000fc40004000000ULL, 0x0000000912027208ULL, 0x000fe40004800000ULL,
0x000000110800720bULL, 0x000fe40003f1e000ULL, 0x0000001b0200720bULL, 0x000fe40003f3e000ULL,
0x0000000811087208ULL, 0x000fe40004000000ULL, 0x000000021b057208ULL, 0x000fe40004800000ULL,
0x000000230800720bULL, 0x000fc40003f1e000ULL, 0x0000001a0500720bULL, 0x000fe40003f3e000ULL,
0x0000000823077208ULL, 0x000fe40004000000ULL, 0x000000051a057208ULL, 0x000fe40004800000ULL,
0x000000240700720bULL, 0x000fe40003f1e000ULL, 0x0000001c0500720bULL, 0x000fe40003f3e000ULL,
0x0000000724027208ULL, 0x000fc40004000000ULL, 0x000000051c057208ULL, 0x000fe40004800000ULL,
0x000000310200720bULL, 0x000fe40003f1e000ULL, 0x000000300500720bULL, 0x000fe40003f3e000ULL,
0x0000000231027208ULL, 0x000fe40004000000ULL, 0x0000000530057208ULL, 0x000fe40004800000ULL,
0x0000002f0200720bULL, 0x000fc40003f1e000ULL, 0x0000001e0500720bULL, 0x000fe40003f3e000ULL,
0x000000022f027208ULL, 0x000fe40004000000ULL, 0x000000051e047208ULL, 0x000fe40004800000ULL,
0x000000250200720bULL, 0x000fe40003f1e000ULL, 0x0000001d0400720bULL, 0x000fe40003f3e000ULL,
0x0000000225057208ULL, 0x000fc40004000000ULL, 0x000000041d047208ULL, 0x000fe40004800000ULL,
0x000000260500720bULL, 0x000fe40003f1e000ULL, 0x0000001f0400720bULL, 0x000fe40003f3e000ULL,
0x0000000526057208ULL, 0x000fe40004000000ULL, 0x000000041f047208ULL, 0x000fe40004800000ULL,
0x0000002e0500720bULL, 0x000fc40003f1e000ULL, 0x0000002d0400720bULL, 0x000fe40003f3e000ULL,
0x000000052e057208ULL, 0x000fe40004000000ULL, 0x000000042d077208ULL, 0x000fe40004800000ULL,
0x0000002c0500720bULL, 0x000fe40003f1e000ULL, 0x000000220700720bULL, 0x000fe40003f3e000ULL,
0x000000052c027208ULL, 0x000fc40004000000ULL, 0x0000000722047208ULL, 0x000fe40004800000ULL,
0x0000002b0200720bULL, 0x000fe40003f1e000ULL, 0x000000270400720bULL, 0x000fe40003f3e000ULL,
0x000000022b057208ULL, 0x000fe40004000000ULL, 0x0000000427077208ULL, 0x000fe40004800000ULL,
0x000000200500720bULL, 0x000fc40003f1e000ULL, 0x000000280700720bULL, 0x000fe40003f3e000ULL,
0x0000000520027208ULL, 0x000fe40004000000ULL, 0x0000000728047208ULL, 0x000fe40004800000ULL,
0x000000210200720bULL, 0x000fe40003f1e000ULL, 0x000000290400720bULL, 0x000fe40003f3e000ULL,
0x00000002210c7208ULL, 0x000fc40004000000ULL, 0x0000000429077208ULL, 0x000fe20004800000ULL,
0x000016a27f007947ULL, 0x000fec000b800000ULL, 0x0c401f000c027f89ULL, 0x0004e400000e0000ULL,
0x000000020c00720bULL, 0x00cfc80003f1e000ULL, 0x0000000c020e7208ULL, 0x000fe20004000000ULL,
0x000016c27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0007027f89ULL, 0x000ea800000e0000ULL,
0x0c401f000a057f89ULL, 0x000ee800000e0000ULL, 0x0c401f000b047f89ULL, 0x000f2200000e0000ULL,
0x000000020700720bULL, 0x004fc40003f1e000ULL, 0x000000050a00720bULL, 0x008fe40003f3e000ULL,
0x0000000702087208ULL, 0x000fe40004000000ULL, 0x0000000a05097208ULL, 0x000fe40004800000ULL,
0x0c201f000e057f89ULL, 0x000ea200000e0000ULL, 0x000000040b00720bULL, 0x010fc60003f1e000ULL,
0x0c201f00080d7f89ULL, 0x002e6200000e0000ULL, 0x0000000b04077208ULL, 0x000fc60004000000ULL,
0x0c201f0009067f89ULL, 0x000ee800000e0000ULL, 0x0c201f0007027f89ULL, 0x0002e200000e0000ULL,
0x000000050e00720bULL, 0x004fe40003f1e000ULL, 0x0000000d0800720bULL, 0x002fe40003f3e000ULL,
0x0000000e05047208ULL, 0x000fe40004000000ULL, 0x000000060900720bULL, 0x008fc40003f5e000ULL,
0x000000080d057208ULL, 0x000fe40004800000ULL, 0x0000000906067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04087820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000303ff7812ULL, 0x000fe4000780c0ffULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010808ULL,
0x000000020700720bULL, 0x004fe20003f3e000ULL, 0x3fb8aa3b19197823ULL, 0x100fe40000010808ULL,
0x00000024000f7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010808ULL,
0x0000000702077208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b23097823ULL, 0x000fc40000010808ULL,
0x3fb8aa3b17177823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010808ULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b247823ULL, 0x104fe40000010808ULL,
0x3fb8aa3b052b7820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b11117823ULL, 0x000fe40000010808ULL,
0x3fb8aa3b12127823ULL, 0x100fe2000001082bULL, 0x00000017000a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b16167823ULL, 0x000fc4000001082bULL, 0x3fb8aa3b14147823ULL, 0x100fe4000001082bULL,
0x3fb8aa3b18187823ULL, 0x000fe4000001082bULL, 0x3fb8aa3b25327823ULL, 0x100fe20000010808ULL,
0x00000009000e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b26257823ULL, 0x100fe40000010808ULL,
0x3fb8aa3b31317823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b2f237823ULL, 0x000fc40000010808ULL,
0x3fb8aa3b2e267823ULL, 0x100fe20000010808ULL, 0x00000014000b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b20207823ULL, 0x100fe40000010808ULL, 0x3fb8aa3b21217823ULL, 0x000fe40000010808ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe4000001082bULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082bULL,
0x0000001200127308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b1c1c7823ULL, 0x000fc4000001082bULL,
0x3fb8aa3b30307823ULL, 0x100fe4000001082bULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe4000001082bULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe2000001082bULL, 0x0000001500157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe4000001082bULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe4000001082bULL,
0x3fb8aa3b22227823ULL, 0x000fc4000001082bULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001082bULL,
0x00000013000c7308ULL, 0x0023e20000000800ULL, 0x0000000b120b723eULL, 0x004fe200000000ffULL,
0x3c003c00ff127424ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b28287823ULL, 0x100fe4000001082bULL,
0x3fb8aa3b29297823ULL, 0x000fe4000001082bULL, 0x0000001800097308ULL, 0x000fe20000000800ULL,
0x3c003c00ff137424ULL, 0x002fce00078e00ffULL, 0x0000001600167308ULL, 0x000e700000000800ULL,
0x00000011000d7308ULL, 0x0004e20000000800ULL, 0x000000091609723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b2c117823ULL, 0x004fe20000010808ULL, 0x000000190a08723eULL, 0x000fca00000000ffULL,
0x0000003100347308ULL, 0x000e620000000800ULL, 0x000000150c0a723eULL, 0x000fe400000000ffULL,
0x0000000d0e0c723eULL, 0x008fca00000000ffULL, 0x000000120814723cULL, 0x000f6200000018ffULL,
0x0000001b001b7308ULL, 0x000fe20000000800ULL, 0x0000000f340e723eULL, 0x002fce00000000ffULL,
0x0000001a001a7308ULL, 0x000e700000000800ULL, 0x0000001c001c7308ULL, 0x000ff00000000800ULL,
0x00000030002f7308ULL, 0x000ea20000000800ULL, 0x0000001b1a0d723eULL, 0x002fce00000000ffULL,
0x0000002300237308ULL, 0x000fe20000000800ULL, 0x0000001c2f0f723eULL, 0x004fce00000000ffULL,
0x0000003200327308ULL, 0x000e620000000800ULL, 0x00000002ff1c7819ULL, 0x000fc80000011603ULL,
0x000000011c2b7810ULL, 0x040fe20007ffe0ffULL, 0x000000120c18723cULL, 0x020b620000001814ULL,
0x000000081c367824ULL, 0x040fe200078e00ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x000000081c2e7824ULL, 0x040fe400078e00ffULL, 0x000000081c307824ULL, 0x040fe400078e00ffULL,
0x000000081c177824ULL, 0x060fe200078e00ffULL, 0x000000031c147810ULL, 0x040fe20007ffe0ffULL,
0x000000081c387824ULL, 0x040fe200078e00ffULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x000000041c157810ULL, 0x000fc40007ffe0ffULL, 0xfffffff817347812ULL, 0x000fe400078ee214ULL,
0xfffffff836367812ULL, 0x000fe400078ee215ULL, 0x000000233214723eULL, 0x002fe200000000ffULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee22bULL,
0x000000081c2b7824ULL, 0x040fe200078e00ffULL, 0xffffffff1c237810ULL, 0x000fc80007ffe0ffULL,
0xfffffff838387812ULL, 0x000fe200078ee223ULL, 0x0000001d001d7308ULL, 0x000e620000000800ULL,
0x000000252616723eULL, 0x004fe400000000ffULL, 0x000000081c257810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82b267812ULL, 0x000fc600078ee21cULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x00000008253a7824ULL, 0x000fca00078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe400078ee225ULL,
0x0000002d002c7308ULL, 0x0004e20000000800ULL, 0x0000001e1d15723eULL, 0x002fe400000000ffULL,
0x000000051c1d7810ULL, 0x040fe40007ffe0ffULL, 0x000000061c1e7810ULL, 0x000fc60007ffe0ffULL,
0x0000001100117308ULL, 0x000fe20000000800ULL, 0x000000021c2d7810ULL, 0x004fc80007ffe0ffULL,
0xfffffff830307812ULL, 0x000fe200078ee22dULL, 0x000000081c2d7824ULL, 0x000fe200078e00ffULL,
0x0000001f2c17723eULL, 0x008fe200000000ffULL, 0x0000002400247308ULL, 0x000e620000000800ULL,
0x000000081c2c7824ULL, 0x000fe400078e00ffULL, 0xfffffff82d327812ULL, 0x000fc600078ee21eULL,
0x000000121418723cULL, 0x000f620000001818ULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee21dULL,
0x0000002000207308ULL, 0x000ff00000000800ULL, 0x0000002100217308ULL, 0x000ea20000000800ULL,
0x00000011241c723eULL, 0x002fc400000000ffULL, 0x0001100000117811ULL, 0x000fca00078e58ffULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x0000001030237824ULL, 0x100fe400078e0211ULL,
0x0000001034247824ULL, 0x100fe400078e0211ULL, 0x0000001036257824ULL, 0x000fc600078e0211ULL,
0x0000002700277308ULL, 0x000e620000000800ULL, 0x00000020211e723eULL, 0x004fe200000000ffULL,
0x0000001026207824ULL, 0x100fe400078e0211ULL, 0x0000001032267824ULL, 0x000fc800078e0211ULL,
0x0000002800287308ULL, 0x000ff00000000800ULL, 0x00000029001f7308ULL, 0x0004e20000000800ULL,
0x00000022271d723eULL, 0x002fe200000000ffULL, 0x000000102e227824ULL, 0x000fc400078e0211ULL,
0x0000001038277824ULL, 0x000fe200078e0211ULL, 0x0000000c2a297812ULL, 0x004fca00078ec0ffULL,
0x0000000129217824ULL, 0x000fe200078e0220ULL, 0x000000281f1f723eULL, 0x008fe200000000ffULL,
0x000000102c207824ULL, 0x000fe400078e0211ULL, 0x0000000129227824ULL, 0x040fe200078e0222ULL,
0x0000000821007388ULL, 0x0003e20000000800ULL, 0x0000000129237824ULL, 0x040fe400078e0223ULL,
0x000000121c18723cULL, 0x020b620000001818ULL, 0x0000000129247824ULL, 0x000fe200078e0224ULL,
0x0000000a22007388ULL, 0x0003e20000000800ULL, 0x000000103a117824ULL, 0x000fc400078e0211ULL,
0x0000000129257824ULL, 0x040fe200078e0225ULL, 0x0000000c23007388ULL, 0x0003e20000000800ULL,
0x0000000129207824ULL, 0x040fe400078e0220ULL, 0x0000000129267824ULL, 0x040fe200078e0226ULL,
0x0000000e24007388ULL, 0x0003e20000000800ULL, 0x0000000129277824ULL, 0x040fe400078e0227ULL,
0x0000000129127824ULL, 0x020fe200078e0211ULL, 0x0000001425007388ULL, 0x0003e80000000800ULL,
0x0000001620007388ULL, 0x0003e80000000800ULL, 0x0000001c26007388ULL, 0x0003e40000000800ULL,
0x000000ffff197224ULL, 0x000fc400078e001aULL, 0x0000001e27007388ULL, 0x0003e80000000800ULL,
0x0000000912007388ULL, 0x0003e80000000800ULL, 0x0004000b22007388ULL, 0x0003e80000000800ULL,
0x0004000d23007388ULL, 0x0003e80000000800ULL, 0x0004000f24007388ULL, 0x0003e80000000800ULL,
0x0004001525007388ULL, 0x0003e80000000800ULL, 0x0004001720007388ULL, 0x0003e80000000800ULL,
0x0004001d26007388ULL, 0x0003e80000000800ULL, 0x0004001f27007388ULL, 0x0003e80000000800ULL,
0x01b0000410008388ULL, 0x0003e80000000c00ULL, 0x01b2001810008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6080071ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6100071ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6180071ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000005e4800720cULL, 0x000fe20003f06070ULL,
0x01b6200071ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff027224ULL, 0x000fd600078e0048ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff98b000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0c7807ULL, 0x004fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00013fb0000e7802ULL, 0x000fc40000000f00ULL,
0x00000f1000007944ULL, 0x008fea0003c00000ULL, 0xfffee8a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe20005000000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014000000e7802ULL, 0x000fc40000000f00ULL, 0x00000ec000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff337224ULL, 0x000fe200078e000cULL, 0xfffee8e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0035ULL, 0x00014070000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x00000e0000007944ULL, 0x008fea0003c00000ULL, 0xfffee9a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0035ULL, 0x000140d0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x00000da000007944ULL, 0x00afea0003c00000ULL, 0xfffeeaa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00014140000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0008ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x00000d3000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000cULL, 0xfffeec3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x000141b0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x00000cc000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000cULL,
0xfffeebf000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x004fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00014210000e7802ULL, 0x000fc40000000f00ULL,
0x00000cb000007944ULL, 0x008fea0003c00000ULL, 0xffff01a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014260000e7802ULL, 0x000fc40000000f00ULL, 0x00000c6000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e000cULL, 0xffff01e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x000142d0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x00000ba000007944ULL, 0x008fea0003c00000ULL, 0xffff02b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00014330000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x00000b4000007944ULL, 0x00afea0003c00000ULL, 0xffff03b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0009ULL, 0x000143a0000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fe400078e000aULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x00000ad000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000cULL, 0xffff054000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0009ULL, 0x00014410000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x00000a6000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000cULL,
0xffff050000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x004fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00014470000e7802ULL, 0x000fc40000000f00ULL,
0x00000a5000007944ULL, 0x008fea0003c00000ULL, 0xffff18b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x000144c0000e7802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e000cULL, 0xffff18f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0033ULL, 0x00014530000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0000094000007944ULL, 0x008fea0003c00000ULL, 0xffff19c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0033ULL, 0x00014590000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x000008e000007944ULL, 0x00afea0003c00000ULL, 0xffff1ac000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0004ULL, 0x00014600000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x0000087000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000cULL, 0xffff1c5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0004ULL, 0x00014670000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0000080000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000cULL,
0xffff1c1000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x004fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x000146d0000e7802ULL, 0x000fc40000000f00ULL,
0x000007f000007944ULL, 0x008fea0003c00000ULL, 0xffff306000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014720000e7802ULL, 0x000fc40000000f00ULL, 0x000007a000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e000cULL, 0xffff309000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0013ULL, 0x00014790000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x000006e000007944ULL, 0x008fea0003c00000ULL, 0xffff316000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0013ULL, 0x000147f0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fe400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x0000068000007944ULL, 0x00afea0003c00000ULL, 0xffff326000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00014860000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0010ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff307424ULL, 0x000fc400078e00ffULL, 0x0000061000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000cULL, 0xffff33f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x000148d0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff317424ULL, 0x000fc400078e00ffULL, 0xffffffffff307424ULL, 0x000fc400078e00ffULL,
0x000005a000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000cULL,
0xffff33b000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0d7424ULL, 0x000fe200078e00ffULL,
0x0001494000087802ULL, 0x000fe20000000f00ULL, 0x0000001fff027424ULL, 0x000fe400078e00ffULL,
0xffffffffff337424ULL, 0x000fc400078e00ffULL, 0x000004f000007944ULL, 0x002fea0003c00000ULL,
0xffffe91000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0c7224ULL, 0x002fe200078e0007ULL,
0x000149b000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0d7424ULL, 0x000fe400078e00ffULL,
0x0000001fff027424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x000000020700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000aULL, 0x00014a3000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000702057208ULL, 0x000fe20004000000ULL,
0x0000001fff027424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000040000007944ULL, 0x000fea0003c00000ULL, 0x000000020a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000bULL, 0x00014ab000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000a020f7208ULL, 0x000fe20004000000ULL,
0x0000001fff027424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x000000020b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000eULL, 0x00014b3000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000b02077208ULL, 0x000fe20004000000ULL,
0x0000001fff027424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0x000000020e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e0005ULL, 0x00014bb000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000e02047208ULL, 0x000fe20004000000ULL,
0x0000001fff027424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000028000007944ULL, 0x000fea0003c00000ULL, 0x000000020500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e000fULL, 0x00014c3000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000502057208ULL, 0x000fe20004000000ULL,
0x0000001fff027424ULL, 0x000fc400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000020000007944ULL, 0x000fea0003c00000ULL, 0x000000020f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0c7224ULL, 0x002fe200078e0007ULL, 0x00014cb000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000f02067208ULL, 0x000fe20004000000ULL,
0x0000001fff027424ULL, 0x000fe400078e00ffULL, 0xffffffffff337424ULL, 0x000fc400078e00ffULL,
0x0000018000007944ULL, 0x000fea0003c00000ULL, 0xffffe70000007947ULL, 0x000fea000383ffffULL,
0x018000000a027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000000a00028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000205ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0aff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000205ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000a057812ULL, 0x000fd600078ec0ffULL,
0x0080000005020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000a00027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff0d7424ULL, 0x000fc800078e00ffULL,
0xfffeb1d00c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000003300007348ULL, 0x000fe80003800000ULL, 0x0c00000d0c027389ULL, 0x0002a200000e0002ULL,
0xfffeb19008007950ULL, 0x000fea0003c3ffffULL, 0x0000003000007348ULL, 0x000fe80003800000ULL,
0x0000000c0e0c7389ULL, 0x0002a400000e0031ULL, 0x000000ffff0e7224ULL, 0x002fc400078e000fULL,
0x00000000ff0f7424ULL, 0x000fc800078e00ffULL, 0xfffeb1400e007950ULL, 0x000fea0003c3ffffULL,
0x000000010c00780cULL, 0x000fe20003f45070ULL, 0x0000000f00007348ULL, 0x000fd80003800000ULL,
0x00000000000c7806ULL, 0x000fc800050e0100ULL, 0x0000000f0c0c7212ULL, 0x000fe200078ec0ffULL,
0x00000000ff0f7424ULL, 0x000fc800078e00ffULL, 0xfffeb0e00e007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000050aULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000668ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008c0ULL,
0x0000000000000380ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c40ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d00ULL,
0x00000000000005c0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012c0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012d0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001360ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001364ULL,
0x00000000000001b8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001580ULL,
0x0000000000015000ULL, 0x7f00001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016580ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x00000000000165c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000016940ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001360ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000015220ULL,
0x0000000000015220ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000016580ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000016940ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_0_m_16_sm_80_cubin_len = 92704;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
