/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_0_m_16_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000152c0ULL, 0x0000000000014f40ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL,
0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL,
0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL,
0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL,
0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c00010000028dULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00010000036fULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b0022000003b5ULL, 0x0000000000013770ULL, 0x0000000000000170ULL, 0x000b0022000003e8ULL,
0x00000000000138e0ULL, 0x0000000000000040ULL, 0x000b002200000413ULL, 0x0000000000013920ULL,
0x0000000000000050ULL, 0x000b00220000043dULL, 0x0000000000013970ULL, 0x0000000000000110ULL,
0x000a0003000004abULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000004cbULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004fbULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000013a80ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001377000000000ULL, 0x0000040400000000ULL, 0x810c000001500400ULL,
0x004c800400288080ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808e0828808081ULL,
0x9a082880808f0828ULL, 0x2880808608288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x0000220028808086ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001377000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL,
0x8f082880808e0828ULL, 0x2880809a08288080ULL, 0x8280162880808808ULL, 0x0000000003102880ULL,
0x8080889200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL, 0x000000f000000000ULL,
0x000138e000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x80808e0828808081ULL, 0x8f082880809a0828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x002880808f920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL, 0x0000017800000000ULL,
0x0001392000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL, 0x808e2880808f0900ULL,
0x0000000000002880ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808f0828808081ULL, 0x8e082880809a0828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880808e920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x0000020800000000ULL, 0x0001397000000000ULL, 0x0000011000000000ULL,
0x0000000000000000ULL, 0x0000001800082f04ULL, 0x0008230400000080ULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL,
0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL,
0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL,
0x0000001100082304ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008230400000000ULL, 0x0000000000000018ULL, 0x0000001800081204ULL, 0x0008110400000000ULL,
0x0000000000000018ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0058016000000015ULL,
0x000c170400581903ULL, 0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL,
0x000c17040021f000ULL, 0x0040000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL,
0x000c17040061f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00801b030011f000ULL, 0x000008b000043104ULL, 0xffffffff01542904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000002e001542804ULL, 0x000004e000000400ULL, 0x0000286000001880ULL,
0x00002a4000002920ULL, 0x00002db000002ba0ULL, 0x00002e3000002de0ULL, 0x000034d000002e80ULL,
0x00004440000043a0ULL, 0x000046d000004570ULL, 0x00004910000048e0ULL, 0x000049b000004960ULL,
0x00005cd000004e10ULL, 0x00005ea000005d70ULL, 0x0000621000006000ULL, 0x0000629000006240ULL,
0x00006790000062e0ULL, 0x00007730000076a0ULL, 0x000079c000007860ULL, 0x00007c0000007bd0ULL,
0x00007ca000007c50ULL, 0x0000823000008220ULL, 0x0000a6000000a5c0ULL, 0x0000ad800000ad40ULL,
0x000120b000012070ULL, 0x000120d0000120c0ULL, 0x0001214000012120ULL, 0x0001217000012160ULL,
0x00012df000012db0ULL, 0x00012e8000012e40ULL, 0x00012f2000012ed0ULL, 0x00012fb000012f70ULL,
0x0001304000013000ULL, 0x000130e000013090ULL, 0x0001317000013130ULL, 0x00013200000131c0ULL,
0x000132a000013250ULL, 0x00013330000132f0ULL, 0x000133c000013380ULL, 0x0001346000013410ULL,
0x00013510000134b0ULL, 0x000135d000013570ULL, 0x0001369000013630ULL, 0x00013750000136f0ULL,
0x000003c002003904ULL, 0x00013600000000ffULL, 0x00000420003f0100ULL, 0x000136080000000bULL,
0x00000460003f0120ULL, 0x000136880000000bULL, 0x00000910003f0120ULL, 0x00013600000000ffULL,
0x00000a30003f0107ULL, 0x0001368c00000071ULL, 0x00000ab0003f0102ULL, 0x0001368800000071ULL,
0x00002540003f0101ULL, 0x0001360800000030ULL, 0x00002580003f0101ULL, 0x0001360c00000009ULL,
0x00002750003f0105ULL, 0x0001360c00000009ULL, 0x00003490003f0105ULL, 0x000136880000000cULL,
0x000040e0003f0101ULL, 0x000136280000000bULL, 0x00004100003f0101ULL, 0x0001362c0000000bULL,
0x000042d0003f0105ULL, 0x0001362c0000000bULL, 0x00004dd0003f0105ULL, 0x000000000000000cULL,
0x00005a10003f0101ULL, 0x0001364800000008ULL, 0x00005a30003f0101ULL, 0x0001364c00000008ULL,
0x00005c00003f0105ULL, 0x0001364c00000008ULL, 0x00006770003f0105ULL, 0x000000000000000cULL,
0x000073f0003f0101ULL, 0x000136680000000aULL, 0x00007410003f0101ULL, 0x0001366c0000000aULL,
0x000075e0003f0105ULL, 0x0001366c0000000aULL, 0x00008070003f0105ULL, 0x0000000000000004ULL,
0x0000bc50003f0101ULL, 0x00013600000000ffULL, 0x0000c820003f0101ULL, 0x00013604000000ffULL,
0x0000c9f0003f0105ULL, 0x00013604000000ffULL, 0x00010550003f0105ULL, 0x000000000000006eULL,
0x00010670003f0101ULL, 0x000000040000006eULL, 0x00010840003f0105ULL, 0x000000040000006eULL,
0x00012c10003f0105ULL, 0x000136080000006fULL, 0x00012c70003f0101ULL, 0x000136100000006fULL,
0x00012cd0003f0101ULL, 0x000136180000006fULL, 0x00012d40003f0101ULL, 0x000136200000006fULL,
0x00033803003f0101ULL, 0x0000b5d000201c04ULL, 0x0000b7e00000b600ULL, 0x0000bad00000b940ULL,
0x0000ca500000bbd0ULL, 0x0000040100012d80ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000274ULL,
0x0000001800000002ULL, 0x00000000000001e4ULL, 0x0000001800000002ULL, 0x0000000000000164ULL,
0x0000001800000002ULL, 0x00000000000000dcULL, 0x0000001800000002ULL, 0x0000000000000044ULL,
0x0000001800000002ULL, 0x000000000000024aULL, 0x0000001800000002ULL, 0x00000000000001baULL,
0x0000001800000002ULL, 0x000000000000013cULL, 0x0000001800000002ULL, 0x00000000000000b7ULL,
0x0000001800000002ULL, 0x0000000000013700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff6c7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000097919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a006c797a19ULL, 0x000fe200000006ffULL,
0x00000000000579c3ULL, 0x000f220000002500ULL, 0x0000000000077919ULL, 0x000ea20000002100ULL,
0x0000460000087ab9ULL, 0x000fc60000000a00ULL, 0x00000000000d7919ULL, 0x000ee20000002700ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fe40007ffe0ffULL,
0x00000005ff087819ULL, 0x004fc80000011607ULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000040003757a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a75ULL,
0x0000040003007624ULL, 0x000fca00078e026cULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x0000000175750810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x0000000175751810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff75aa12ULL, 0x000fc800078e33ffULL, 0x0000007500007306ULL, 0x000e620000209000ULL,
0x000000ff7500720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000375047224ULL, 0x004fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000ee40000002200ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000000603737227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a73ULL, 0x0000000075007224ULL, 0x000fca00078e0206ULL,
0x000000750000720cULL, 0x000fe20003f06070ULL, 0x0000010009027a24ULL, 0x008fe400078e0204ULL,
0x00001fff09097589ULL, 0x000fe400000e0000ULL, 0x00000000020b7a24ULL, 0x000fca00078e0207ULL,
0x000000ff0b00720cULL, 0x000fc60003f65270ULL, 0x0000000100000824ULL, 0x000fe200078e0a75ULL,
0x0000000173730810ULL, 0x000fe40007ffe0ffULL, 0x0000000f0b00780cULL, 0x040fe40003f84070ULL,
0x000000750000720cULL, 0x000fe40003f26070ULL, 0x000000030b00780cULL, 0x000fc60003f04070ULL,
0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03b424ULL, 0x000fc800078e00ffULL,
0x3fffffc0ff04c424ULL, 0x000fe400078e00ffULL, 0x0000000173731810ULL, 0x000fe20007ffe0ffULL,
0x7fffffc0ff05c424ULL, 0x000fe200078e00ffULL, 0x00000075ff73a212ULL, 0x000fe200078e33ffULL,
0x01360002ff00b388ULL, 0x0003e20000000a00ULL, 0x7fffff60ff078424ULL, 0x000fe200078e00ffULL,
0x0000007f0b00780cULL, 0x000fe40003f24070ULL, 0x000000ffff007224ULL, 0x000fe200078e0a73ULL,
0x00001fff08027589ULL, 0x000ea600000e0000ULL, 0x0000000075757224ULL, 0x000fe200078e0206ULL,
0x013608040b00c388ULL, 0x000fe20000008a00ULL, 0x3fffff60ff068424ULL, 0x000fe200078e00ffULL,
0x00005a0073037a19ULL, 0x002fe200000006ffULL, 0x00000010756b7824ULL, 0x000fc600078e00ffULL,
0x013688060b008388ULL, 0x000fe20000008a00ULL, 0xff317217ff0a9424ULL, 0x000fe200078e00ffULL,
0x000000046b007c10ULL, 0x040fe4000fffe1ffULL, 0x000000046b007c0cULL, 0x000fe4000bf03070ULL,
0x0000001000007817ULL, 0x000fe20003800000ULL, 0x0134000a0b009388ULL, 0x000fe60000004800ULL,
0x000000ff00747207ULL, 0x000fe20000000000ULL, 0x000058000d007a24ULL, 0x000fe200078e02ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000107400780cULL, 0x000fe20003f05270ULL,
0x0000000409057824ULL, 0x004fc400078e0202ULL, 0x0000007900047224ULL, 0x000fe400078e0203ULL,
0x00000005ff007e24ULL, 0x010fe4000f8e00ffULL, 0x0000000205057824ULL, 0x000fcc00078e00ffULL,
0x000001d000008947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00000004ff087819ULL, 0x002fca0000011603ULL,
0x00000001050a7824ULL, 0x000fc800078e0208ULL, 0x000000016b067824ULL, 0x000fca00078e020aULL,
0x0000000406077c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0c7a19ULL, 0x000fe40000011606ULL,
0x0000000574067217ULL, 0x000fe20007800000ULL, 0x0000000104077824ULL, 0x000fe400078e0207ULL,
0x0000001003047824ULL, 0x000fe400078e00ffULL, 0x000000790c077224ULL, 0x000fe400078e0207ULL,
0x0000000106057824ULL, 0x000fe200078e0a05ULL, 0x000000f0040b7812ULL, 0x000fe200078ec0ffULL,
0x0000010007067825ULL, 0x000fc600078e00ffULL, 0x000000050800720cULL, 0x000fe20003f06070ULL,
0x000000010a057824ULL, 0x000fe200078e0203ULL, 0x0000000b060b7212ULL, 0x000fe200078efcffULL,
0x000000100a0a7824ULL, 0x000fc600078e00ffULL, 0x00005e000b067a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00a057812ULL, 0x000fe400078ee205ULL, 0x00005f0007077a10ULL, 0x000fc60000ffe4ffULL,
0x0000001005057824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e2000c101c48ULL, 0x0000018000007947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x0000000503087211ULL, 0x002fca00078fe0ffULL, 0x000000016b057824ULL, 0x000fca00078e0208ULL,
0x0000000405077c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff067a19ULL, 0x000fe20000011605ULL,
0x0000000108057824ULL, 0x000fe400078e0203ULL, 0x0000000104077824ULL, 0x000fe400078e0207ULL,
0x0000001003047824ULL, 0x000fe400078e00ffULL, 0x0000007906067224ULL, 0x000fe400078e0207ULL,
0x0000001008087824ULL, 0x000fe200078e00ffULL, 0x000000f0040b7812ULL, 0x000fe200078ec0ffULL,
0x0000010006067825ULL, 0x000fc600078e00ffULL, 0xfffffff008057812ULL, 0x000fe400078ee205ULL,
0x0000000b06067212ULL, 0x000fc600078efcffULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0x00005e0006067a10ULL, 0x000fc80007f1e0ffULL, 0x00005f0007077a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e8000b901c48ULL,
0x0000000000077919ULL, 0x002e620000000000ULL, 0x0000000000057806ULL, 0x000fe200038e0000ULL,
0x00000004ff5c7424ULL, 0x000fc600078e00ffULL, 0x0000000500067300ULL, 0x000e6200000e0000ULL,
0x000064000d5c7625ULL, 0x000fce00078e005cULL, 0x0000000500087309ULL, 0x000ea20000000000ULL,
0x000000070600720cULL, 0x002fe40003f02070ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffff067224ULL, 0x004fd400078e0a08ULL, 0x01360406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01360000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000085c5c7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0900720cULL, 0x000fe40003f05270ULL,
0x000000ff5c667810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff667819ULL, 0x000fce0000011666ULL,
0x0000b1f000008947ULL, 0x000fea0003800000ULL, 0x000000020d057824ULL, 0x000fe400078e00ffULL,
0x0000000802717824ULL, 0x000fe400078e00ffULL, 0x00000003ff067424ULL, 0x002fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01368c0671ff738cULL, 0x0003e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00005900056c7624ULL, 0x000fe200078e026cULL,
0x0000000100057810ULL, 0x000fe20007ffe0ffULL, 0x0136880071ff7f8cULL, 0x0005e2000c80043fULL,
0x00000001ff0b7819ULL, 0x000fe20000011602ULL, 0x00000001736c7824ULL, 0x000fe200078e026cULL,
0x000000660500720cULL, 0x000fc40003f06070ULL, 0x0000000102677812ULL, 0x000fe200078ec0ffULL,
0x000000200b707824ULL, 0x000fc800078e00ffULL, 0x0000010000077824ULL, 0x000fc800078e0270ULL,
0x000066006c1f7a24ULL, 0x000fe400078e0207ULL, 0x0000064000008947ULL, 0x000fea0003800000ULL,
0x00000003ff147819ULL, 0x004fe20000011603ULL, 0x000000020b177824ULL, 0x000fe200078e0267ULL,
0x000000075c057217ULL, 0x000fe40007800000ULL, 0x0000000414067810ULL, 0x042fe40007ffe0ffULL,
0x0000000c140d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000105057824ULL, 0x000fe200078e0a07ULL,
0x0000007004047812ULL, 0x000fe200078ec0ffULL, 0x0000000106077824ULL, 0x100fe200078e0203ULL,
0x00000008140c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000806187824ULL, 0x000fe200078e00ffULL,
0x00000020050a7817ULL, 0x000fe20003800000ULL, 0x000000010d097824ULL, 0x040fe200078e0203ULL,
0x0000001014127810ULL, 0x000fe20007ffe0ffULL, 0x000000080d1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee207ULL, 0x0000008067047824ULL, 0x000fe200078e0204ULL,
0x0000000a0600720cULL, 0x080fe20003f86070ULL, 0x000000011f077824ULL, 0x000fe200078e0214ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000001414157810ULL, 0x000fe20007ffe0ffULL, 0x000000010c087824ULL, 0x040fe200078e0203ULL,
0x0000000a0c00720cULL, 0x0c0fe20003f66070ULL, 0x000000080c0f7824ULL, 0x000fe200078e00ffULL,
0x0000000a0d00720cULL, 0x000fe20003f46070ULL, 0x000000011f097824ULL, 0x000fe200078e0206ULL,
0x0000b00017177811ULL, 0x000fe200078e68ffULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0xfffffff80f1a7812ULL, 0x000fc400078ee208ULL, 0x0000000a1400720cULL, 0x000fe20003fa6070ULL,
0x00000001120f7824ULL, 0x000fe200078e0203ULL, 0x00006200060e7a10ULL, 0x000fe20007f1e0ffULL,
0x00000008121e7824ULL, 0x000fe400078e00ffULL, 0x0000010009087825ULL, 0x000fc600078e0004ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20fULL, 0x0000000115117824ULL, 0x140fe200078e0203ULL,
0x0000620008107a10ULL, 0x000fe20007f3e0ffULL, 0x0000000815207824ULL, 0x000fe200078e00ffULL,
0x00006300070f7a10ULL, 0x000fe200007fe4ffULL, 0x000000011f077824ULL, 0x000fe400078e020cULL,
0x00000001140c7824ULL, 0x000fe200078e0203ULL, 0xfffffff820207812ULL, 0x000fe200078ee211ULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x0000630009117a10ULL, 0x000fc40000ffe4ffULL,
0x0000000a1200720cULL, 0x000fe20003f26070ULL, 0x000000011f097824ULL, 0x040fe200078e020dULL,
0x000000070c167812ULL, 0x000fe200078ec0ffULL, 0x000000011f0d7824ULL, 0x000fe200078e0212ULL,
0x0000620006127a10ULL, 0x000fe20007f1e0ffULL, 0x0000010009087825ULL, 0x000fe200078e0004ULL,
0x0ffffff816167812ULL, 0x000fe400078ef803ULL, 0x0000630007137a10ULL, 0x000fe200007fe4ffULL,
0x000001000d0c7825ULL, 0x000fe200078e0004ULL, 0x0000620008087a10ULL, 0x000fc40007fde0ffULL,
0x0000000a1500720cULL, 0x080fe20003f06070ULL, 0x000000011f077824ULL, 0x000fe200078e0215ULL,
0x0000630009097a10ULL, 0x000fe200037fe4ffULL, 0x0000001016197824ULL, 0x000fe200078e0217ULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x0000001814167810ULL, 0x000fe40007ffe0ffULL, 0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x00000010181b7824ULL, 0x000fe200078e0217ULL, 0x0000001c14187810ULL, 0x000fe20007ffe0ffULL,
0x000000011f1d7824ULL, 0x040fe200078e0216ULL, 0x0000620006147a10ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e197faeULL, 0x0003e2000e901c48ULL,
0x0000000a1600720cULL, 0x080fe20003fa6070ULL, 0x000000011f1f7824ULL, 0x000fe200078e0218ULL,
0x0000630007157a10ULL, 0x000fe200037fe4ffULL, 0x000001001d067825ULL, 0x000fe200078e0004ULL,
0x00000000101b7faeULL, 0x0005e2000e101c48ULL, 0x0000000a1800720cULL, 0x000fc40003f86070ULL,
0x00000001160a7824ULL, 0x000fe200078e0203ULL, 0x0000620006067a10ULL, 0x000fe20007fde0ffULL,
0x000001001f047825ULL, 0x000fc600078e0004ULL, 0x0000630007077a10ULL, 0x000fe200037fe4ffULL,
0x00000008160f7824ULL, 0x002fe200078e00ffULL, 0x0000620004047a10ULL, 0x000fe20007fde0ffULL,
0x00000001180e7824ULL, 0x040fe400078e0203ULL, 0x0000000818117824ULL, 0x004fe200078e00ffULL,
0xfffffff80f0a7812ULL, 0x000fe200078ee20aULL, 0x000000101a0f7824ULL, 0x100fe200078e0217ULL,
0x0000630005057a10ULL, 0x000fe200037fe4ffULL, 0x000000101e197824ULL, 0x100fe200078e0217ULL,
0xfffffff8110e7812ULL, 0x000fe200078ee20eULL, 0x000000101c117824ULL, 0x100fe200078e0217ULL,
0x00000000120f7faeULL, 0x0003e2000d901c48ULL, 0x00000010201b7824ULL, 0x000fc400078e0217ULL,
0x000000100a1d7824ULL, 0x100fe200078e0217ULL, 0x0000000008117faeULL, 0x0003e2000d101c48ULL,
0x000000100e177824ULL, 0x000fc600078e0217ULL, 0x000000000c197faeULL, 0x0003e8000c901c48ULL,
0x00000000141b7faeULL, 0x0003e8000c101c48ULL, 0x00000000061d7faeULL, 0x0003e8000e901c48ULL,
0x0000000004177faeULL, 0x0003e2000e101c48ULL, 0x0000057000007947ULL, 0x000fea0003800000ULL,
0x0000000803087811ULL, 0x004fe200078fe8ffULL, 0x000000020b157824ULL, 0x000fe200078e0267ULL,
0x0000000403067811ULL, 0x002fc400078fe8ffULL, 0x00000010030c7811ULL, 0x040fe200078fe8ffULL,
0x0000000108077824ULL, 0x140fe200078e0203ULL, 0x0000000c030a7811ULL, 0x040fe200078fe8ffULL,
0x0000000808187824ULL, 0x000fe200078e00ffULL, 0x00000014030e7811ULL, 0x040fe200078fe8ffULL,
0x0000000106057824ULL, 0x040fe200078e0203ULL, 0x0000001803107811ULL, 0x040fe200078fe8ffULL,
0x0000000806167824ULL, 0x000fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ee207ULL,
0x000000010c077824ULL, 0x000fe200078e0203ULL, 0x0000007004147812ULL, 0x000fe200078ec0ffULL,
0x000000080c1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee205ULL,
0x000000010a057824ULL, 0x140fe200078e0203ULL, 0x0000001c03127811ULL, 0x040fe200078fe8ffULL,
0x000000080a1a7824ULL, 0x000fe200078e00ffULL, 0x0000000303047211ULL, 0x040fe200078fe8ffULL,
0x000000010e097824ULL, 0x000fe200078e0203ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee207ULL,
0x000000080e1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee205ULL,
0x00000001100d7824ULL, 0x100fe200078e0203ULL, 0x0000000704047812ULL, 0x000fe200078ec0ffULL,
0x0000000810207824ULL, 0x000fe200078e00ffULL, 0x0000001f03057211ULL, 0x000fe200078fe8ffULL,
0x000000011f077824ULL, 0x000fe200078e0206ULL, 0x0000b00015257811ULL, 0x000fe200078e68ffULL,
0x0000000112067824ULL, 0x000fe200078e0203ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee209ULL,
0x0000000812197824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee20dULL,
0x0000008067147824ULL, 0x000fc400078e0214ULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0xfffffff819227812ULL, 0x000fe200078ee206ULL, 0x000000011f097824ULL, 0x040fe400078e0208ULL,
0x000000011f0d7824ULL, 0x000fe200078e020aULL, 0x0ffffff8040a7812ULL, 0x000fe200078ef803ULL,
0x0000010005047825ULL, 0x000fc800078e0014ULL, 0x000000011f0f7824ULL, 0x000fe200078e020cULL,
0x0000620004047a10ULL, 0x000fe20007f1e0ffULL, 0x0000010007067825ULL, 0x000fc600078e0014ULL,
0x0000630005057a10ULL, 0x000fe200007fe4ffULL, 0x000000011f117824ULL, 0x000fe200078e020eULL,
0x0000620006067a10ULL, 0x000fe20007f3e0ffULL, 0x0000010009087825ULL, 0x000fc600078e0014ULL,
0x0000630007077a10ULL, 0x000fe20000ffe4ffULL, 0x000000011f137824ULL, 0x000fe200078e0210ULL,
0x0000620008087a10ULL, 0x000fe20007f5e0ffULL, 0x000001000d0c7825ULL, 0x000fc600078e0014ULL,
0x0000630009097a10ULL, 0x000fe200017fe4ffULL, 0x000000011f177824ULL, 0x000fe200078e0212ULL,
0x000062000c0c7a10ULL, 0x000fe20007f7e0ffULL, 0x000001000f0e7825ULL, 0x000fc600078e0014ULL,
0x000063000d0d7a10ULL, 0x000fe20001ffe4ffULL, 0x0000010011107825ULL, 0x000fe200078e0014ULL,
0x000062000e0e7a10ULL, 0x000fc60007f1e0ffULL, 0x0000010013127825ULL, 0x100fe200078e0014ULL,
0x0000620010107a10ULL, 0x000fe40007f3e0ffULL, 0x000063000f0f7a10ULL, 0x000fe200007fe4ffULL,
0x0000010017147825ULL, 0x000fe200078e0014ULL, 0x0000620012127a10ULL, 0x000fe40007f5e0ffULL,
0x0000630011117a10ULL, 0x000fe20000ffe4ffULL, 0x000000100a177824ULL, 0x100fe200078e0225ULL,
0x0000620014147a10ULL, 0x000fe20007f7e0ffULL, 0x0000001016197824ULL, 0x100fe200078e0225ULL,
0x0000630013137a10ULL, 0x000fe200017fe4ffULL, 0x00000010181b7824ULL, 0x100fe200078e0225ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004177faeULL, 0x0003e2000b901c48ULL,
0x000000101a1d7824ULL, 0x100fe200078e0225ULL, 0x0000630015157a10ULL, 0x000fe20001ffe4ffULL,
0x000000101c1f7824ULL, 0x100fe200078e0225ULL, 0x0000000006197faeULL, 0x0003e2000b901c48ULL,
0x000000101e217824ULL, 0x000fc400078e0225ULL, 0x0000001020237824ULL, 0x100fe200078e0225ULL,
0x00000000081b7faeULL, 0x0003e2000b901c48ULL, 0x0000001022257824ULL, 0x000fc600078e0225ULL,
0x000000000c1d7faeULL, 0x0003e8000b901c48ULL, 0x000000000e1f7faeULL, 0x0003e8000b901c48ULL,
0x0000000010217faeULL, 0x0003e8000b901c48ULL, 0x0000000012237faeULL, 0x0003e8000b901c48ULL,
0x0000000014257faeULL, 0x0003e4000b901c48ULL, 0x000000660000720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff087424ULL, 0x002fe200078e00ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000686000000947ULL, 0x000fea0003800000ULL,
0xff317217ff087424ULL, 0x000fe400078e00ffULL, 0x000000ffff277224ULL, 0x000fc400078e00ffULL,
0x0000000100097810ULL, 0x040fe20007ffe0ffULL, 0x0000010000047824ULL, 0x000fe200078e0270ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000660900720cULL, 0x000fe40003f06070ULL,
0x00000040040d7810ULL, 0x020fca0007ffe0ffULL, 0x000066006c367a24ULL, 0x000fcc00078e020dULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000003ff3f7819ULL, 0x000fe20000011603ULL,
0x000000020b3c7824ULL, 0x000fe200078e0267ULL, 0x0000000d5c097217ULL, 0x000fe40007800000ULL,
0x000000043f317810ULL, 0x040fe20007ffe0ffULL, 0x000000013f0f7824ULL, 0x040fe200078e0236ULL,
0x000000083f357810ULL, 0x000fe20007ffe0ffULL, 0x0000000109307824ULL, 0x000fe200078e0a0dULL,
0x0000000c3f397810ULL, 0x000fe20007ffe0ffULL, 0x00000001310c7824ULL, 0x100fe200078e0203ULL,
0x000000103f417810ULL, 0x000fe20007ffe0ffULL, 0x00000008313d7824ULL, 0x000fe200078e00ffULL,
0x000000143f457810ULL, 0x000fe20007ffe0ffULL, 0x0000001003097824ULL, 0x000fe200078e00ffULL,
0x00000020303a7817ULL, 0x000fe20003800000ULL, 0x00000001350d7824ULL, 0x100fe200078e0203ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee20cULL, 0x00000008350e7824ULL, 0x000fe200078e00ffULL,
0x00000070090c7812ULL, 0x000fe200078ec0ffULL, 0x0000000139377824ULL, 0x000fe200078e0203ULL,
0x0000003a3100720cULL, 0x080fe20003f86070ULL, 0x0000000839327824ULL, 0x000fe200078e00ffULL,
0xfffffff80e097812ULL, 0x000fe200078ee20dULL, 0x00000080670c7824ULL, 0x000fe200078e020cULL,
0x0000003a3f00720cULL, 0x080fe20003f66070ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0xfffffff832377812ULL, 0x000fe200078ee237ULL, 0x0000000141337824ULL, 0x000fe200078e0203ULL,
0x0000003a3900720cULL, 0x000fe20003f26070ULL, 0x000001000f0e7825ULL, 0x000fe200078e000cULL,
0x0000c0003c3c7811ULL, 0x000fc400078e68ffULL, 0x000000183f497810ULL, 0x000fe20007ffe0ffULL,
0x0000000841387824ULL, 0x000fe200078e00ffULL, 0x000062000e327a10ULL, 0x000fe20007f1e0ffULL,
0x0000000145347824ULL, 0x000fe200078e0203ULL, 0x0000001c3f4b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000845477824ULL, 0x000fe200078e00ffULL, 0xfffffff838437812ULL, 0x000fe200078ee233ULL,
0x000000013f387824ULL, 0x000fe200078e0203ULL, 0x000063000f337a10ULL, 0x000fe200007fe4ffULL,
0x00000001310f7824ULL, 0x100fe200078e0236ULL, 0x0000003a3500720cULL, 0x040fe20003f06070ULL,
0x0000000135317824ULL, 0x000fe200078e0236ULL, 0xfffffff847477812ULL, 0x000fe200078ee234ULL,
0x0000000139357824ULL, 0x000fe200078e0236ULL, 0x00000007383e7812ULL, 0x000fe200078ec0ffULL,
0x000001000f0e7825ULL, 0x000fc600078e000cULL, 0x0ffffff83e3b7812ULL, 0x000fe200078ef803ULL,
0x0000010031307825ULL, 0x000fe200078e000cULL, 0x000062000e387a10ULL, 0x000fc60007f5e0ffULL,
0x0000010035347825ULL, 0x000fe200078e000cULL, 0x00006200300e7a10ULL, 0x000fe40007fbe0ffULL,
0x000063000f397a10ULL, 0x000fe200017fe4ffULL, 0x000000103b3b7824ULL, 0x000fe200078e023cULL,
0x0000620034307a10ULL, 0x000fe20007fde0ffULL, 0x00000001453f7824ULL, 0x000fe200078e0236ULL,
0x00006300310f7a10ULL, 0x000fe20002ffe4ffULL, 0x000000103d3d7824ULL, 0x000fe200078e023cULL,
0x0000630035317a10ULL, 0x000fe200037fe4ffULL, 0x0000000141357824ULL, 0x140fe200078e0236ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000323b7faeULL, 0x0003e2000d901c48ULL,
0x0000003a4100720cULL, 0x080fe20003f46070ULL, 0x0000000149417824ULL, 0x000fe200078e0236ULL,
0x0000003a4500720cULL, 0x080fe20003fa6070ULL, 0x0000010035347825ULL, 0x000fe200078e000cULL,
0x00000000383d7faeULL, 0x0005e2000e101c48ULL, 0x0000003a4900720cULL, 0x000fc40003f86070ULL,
0x0000003a4b00720cULL, 0x040fe20003f66070ULL, 0x000000014b3a7824ULL, 0x000fe200078e0203ULL,
0x0000620034347a10ULL, 0x000fe20007fde0ffULL, 0x0000001009097824ULL, 0x000fe400078e023cULL,
0x000001003f327825ULL, 0x102fe200078e000cULL, 0x0000630035357a10ULL, 0x000fe400037fe4ffULL,
0x000000000e097faeULL, 0x0003e2000c101c48ULL, 0x0000010041387825ULL, 0x004fe200078e000cULL,
0x0000620032327a10ULL, 0x000fc60007fde0ffULL, 0x000000014b3b7824ULL, 0x000fe200078e0236ULL,
0x0000630033337a10ULL, 0x000fe200037fe4ffULL, 0x0000000149367824ULL, 0x040fe200078e0203ULL,
0x0000620038387a10ULL, 0x000fe20007fde0ffULL, 0x00000008493f7824ULL, 0x000fe400078e00ffULL,
0x000000084b417824ULL, 0x000fe200078e00ffULL, 0x0000630039397a10ULL, 0x000fe200037fe4ffULL,
0x000001003b0c7825ULL, 0x000fe200078e000cULL, 0xfffffff83f3f7812ULL, 0x000fe400078ee236ULL,
0xfffffff841417812ULL, 0x000fe200078ee23aULL, 0x0000001037377824ULL, 0x100fe200078e023cULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x00000010433b7824ULL, 0x000fc400078e023cULL,
0x00000010473d7824ULL, 0x100fe200078e023cULL, 0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x000000103f3f7824ULL, 0x100fe200078e023cULL, 0x0000000030377faeULL, 0x0003e2000c901c48ULL,
0x0000001041417824ULL, 0x000fc600078e023cULL, 0x00000000343b7faeULL, 0x0003e8000d101c48ULL,
0x00000000323d7faeULL, 0x0003e8000e901c48ULL, 0x00000000383f7faeULL, 0x0003e8000e101c48ULL,
0x000000000c417faeULL, 0x0003e2000d901c48ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x0000000803337811ULL, 0x000fe200078fe8ffULL, 0x000000020b0f7824ULL, 0x000fe200078e0267ULL,
0x0000000403317811ULL, 0x000fc400078fe8ffULL, 0x0000000c03357811ULL, 0x000fe200078fe8ffULL,
0x00000001330c7824ULL, 0x100fe200078e0203ULL, 0x0000001403397811ULL, 0x000fe200078fe8ffULL,
0x00000008333f7824ULL, 0x000fe200078e00ffULL, 0x0000001003377811ULL, 0x000fe200078fe8ffULL,
0x0000000131097824ULL, 0x100fe200078e0203ULL, 0x00000018033b7811ULL, 0x000fe200078fe8ffULL,
0x00000008310e7824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee20cULL,
0x00000001350d7824ULL, 0x000fe200078e0203ULL, 0x0000001c03497811ULL, 0x000fe200078fe8ffULL,
0x0000000835307824ULL, 0x000fe200078e00ffULL, 0xfffffff80e3d7812ULL, 0x000fe200078ee209ULL,
0x00000001390c7824ULL, 0x000fc400078e0203ULL, 0x0000000839457824ULL, 0x000fe200078e00ffULL,
0xfffffff830417812ULL, 0x000fe200078ee20dULL, 0x0000000137097824ULL, 0x140fe400078e0203ULL,
0x00000008370e7824ULL, 0x000fe200078e00ffULL, 0xfffffff845457812ULL, 0x000fe200078ee20cULL,
0x000000013b0d7824ULL, 0x040fe400078e0203ULL, 0x000000083b307824ULL, 0x000fe200078e00ffULL,
0xfffffff80e437812ULL, 0x000fe200078ee209ULL, 0x00000001490c7824ULL, 0x000fc400078e0203ULL,
0x00000008494b7824ULL, 0x000fe200078e00ffULL, 0xfffffff830477812ULL, 0x000fe200078ee20dULL,
0x0000001003097824ULL, 0x040fe200078e00ffULL, 0x00000003030d7211ULL, 0x000fe200078fe8ffULL,
0x0000000131317824ULL, 0x000fe200078e0236ULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee20cULL,
0x0000000133337824ULL, 0x100fe200078e0236ULL, 0x00000070090c7812ULL, 0x000fe200078ec0ffULL,
0x0000000135357824ULL, 0x000fe200078e0236ULL, 0x000000070d0e7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x0000c0000f307811ULL, 0x000fe200078e68ffULL,
0x00000080670c7824ULL, 0x000fe200078e020cULL, 0x0ffffff80e097812ULL, 0x000fe200078ef803ULL,
0x0000000137377824ULL, 0x000fe200078e0236ULL, 0x00000036030f7211ULL, 0x000fe200078fe8ffULL,
0x000000103d3d7824ULL, 0x000fc400078e0230ULL, 0x0000001009097824ULL, 0x100fe400078e0230ULL,
0x000000103f3f7824ULL, 0x100fe400078e0230ULL, 0x0000001041417824ULL, 0x100fe400078e0230ULL,
0x0000001043437824ULL, 0x100fe400078e0230ULL, 0x0000001045457824ULL, 0x100fe400078e0230ULL,
0x0000001047477824ULL, 0x000fc400078e0230ULL, 0x000000104b4b7824ULL, 0x000fe400078e0230ULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x0000010031307825ULL, 0x000fe200078e000cULL,
0x000062000e0e7a10ULL, 0x000fc60007f1e0ffULL, 0x0000000139397824ULL, 0x000fe200078e0236ULL,
0x0000620030307a10ULL, 0x000fe20007f3e0ffULL, 0x0000010033327825ULL, 0x000fe200078e000cULL,
0x000063000f0f7a10ULL, 0x000fe400007fe4ffULL, 0x0000630031317a10ULL, 0x000fe20000ffe4ffULL,
0x000000013b3b7824ULL, 0x000fe200078e0236ULL, 0x0000620032327a10ULL, 0x000fe20007f5e0ffULL,
0x0000010035347825ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e097faeULL, 0x0003e4000b901c48ULL, 0x0000630033337a10ULL, 0x000fe200017fe4ffULL,
0x0000000149497824ULL, 0x000fe200078e0236ULL, 0x0000620034347a10ULL, 0x000fe20007f7e0ffULL,
0x0000010037367825ULL, 0x100fe200078e000cULL, 0x00000000303d7faeULL, 0x0003e4000b901c48ULL,
0x0000630035357a10ULL, 0x000fe20001ffe4ffULL, 0x0000010039387825ULL, 0x100fe200078e000cULL,
0x0000620036367a10ULL, 0x000fe20007f1e0ffULL, 0x00000000323f7faeULL, 0x0003e4000b901c48ULL,
0x000001003b3a7825ULL, 0x100fe200078e000cULL, 0x0000620038387a10ULL, 0x000fe20007f3e0ffULL,
0x0000000034417faeULL, 0x0003e2000b901c48ULL, 0x0000630037377a10ULL, 0x000fe200007fe4ffULL,
0x00000100490c7825ULL, 0x000fe200078e000cULL, 0x000062003a3a7a10ULL, 0x000fc40007f5e0ffULL,
0x0000630039397a10ULL, 0x000fe20000ffe4ffULL, 0x0000000036437faeULL, 0x0003e2000b901c48ULL,
0x000062000c0c7a10ULL, 0x000fe40007f7e0ffULL, 0x000063003b3b7a10ULL, 0x000fe200017fe4ffULL,
0x0000000038457faeULL, 0x0003e2000b901c48ULL, 0x000063000d0d7a10ULL, 0x000fc60001ffe4ffULL,
0x000000003a477faeULL, 0x0003e8000b901c48ULL, 0x000000000c4b7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe071097812ULL, 0x042fe400078ec0ffULL,
0x00000010710c7812ULL, 0x000fca00078ec0ffULL, 0x00000001090e7824ULL, 0x000fc800078e020cULL,
0x0000000867307824ULL, 0x000fe200078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136080030307f8cULL, 0x000e64000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x0000000871097812ULL, 0x000fca00078ec0ffULL, 0x000000010e097824ULL, 0x000fca00078e0209ULL,
0x01360c00090f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x006fe40007804831ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c337210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09003300780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403300780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000330e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000132327810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01360c00090f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010036f7824ULL, 0x000fe200078e00ffULL, 0x00000001ff727819ULL, 0x000fe20000011603ULL,
0x0000002002097824ULL, 0x000fe400078e00ffULL, 0xffffffffff767424ULL, 0x000fe200078e00ffULL,
0x000000706f6f7812ULL, 0x000fc400078ec0ffULL, 0xffffff8009097812ULL, 0x000fe400078ec0ffULL,
0x0000000c72727812ULL, 0x000fc800078ec0ffULL, 0x0000000972097210ULL, 0x000fca0007ffe06fULL,
0x01300000090d7984ULL, 0x000e680000000800ULL, 0x0132000009307984ULL, 0x0004e20000000800ULL,
0x000000080d00720bULL, 0x002fe20003f1d000ULL, 0x000105327f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0c327812ULL, 0x000fe2000782c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff097224ULL, 0x000fe400078e0008ULL, 0x0000001fff787424ULL, 0x000fc400078e00ffULL,
0xffffffffff777424ULL, 0x000fcc00078e00ffULL, 0x0000044000009947ULL, 0x000fea0003800000ULL,
0x00000002ff097819ULL, 0x000fe40000011602ULL, 0x000000080d00720bULL, 0x000fe40003f54000ULL,
0x000000020900720cULL, 0x000fe20003f25270ULL, 0x000104b27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000317806ULL, 0x000fc400010e0100ULL, 0x00000080020f9824ULL, 0x000fe200078e026fULL,
0x000000080d097209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x00009910310e7816ULL, 0x000fe200000000ffULL, 0x00000001720c9824ULL, 0x000fca00078e020fULL,
0x013400090c009388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f25270ULL,
0x0000030000009947ULL, 0x000fea0003800000ULL, 0x0000000809087221ULL, 0x002fe20000010100ULL,
0x000000ff31ff7812ULL, 0x000fe2000782c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x0000000800337308ULL, 0x000e640000000800ULL,
0x000000330a0a7220ULL, 0x002fc80000410000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011603ULL, 0x000103e27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c330c7589ULL, 0x0002a400000e0000ULL, 0x0000000c2c2c7220ULL, 0x084fe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c28287220ULL, 0x080fe20000410000ULL,
0x0000000c29297220ULL, 0x080fe20000410000ULL, 0x0000000c10107220ULL, 0x080fe20000410000ULL,
0x0000000c11117220ULL, 0x080fe20000410000ULL, 0x0000000c14147220ULL, 0x080fe20000410000ULL,
0x0000000c15157220ULL, 0x080fe20000410000ULL, 0x0000000c18187220ULL, 0x080fe20000410000ULL,
0x0000000c19197220ULL, 0x080fe20000410000ULL, 0x0000000c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000c20207220ULL, 0x080fe20000410000ULL,
0x0000000c21217220ULL, 0x080fe20000410000ULL, 0x0000000c24247220ULL, 0x080fe20000410000ULL,
0x0000000c25257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0031ff7812ULL, 0x000fda000782c0ffULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000008030c7811ULL, 0x000fe200078ff0ffULL, 0x000102c27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c330c7589ULL, 0x00046400000e0000ULL, 0x0000000c2e2e7220ULL, 0x086fe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000c12127220ULL, 0x080fe20000410000ULL,
0x0000000c13137220ULL, 0x080fe20000410000ULL, 0x0000000c16167220ULL, 0x080fe20000410000ULL,
0x0000000c17177220ULL, 0x080fe20000410000ULL, 0x0000000c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000c22227220ULL, 0x080fe20000410000ULL,
0x0000000c23237220ULL, 0x080fe20000410000ULL, 0x0000000c26267220ULL, 0x080fe20000410000ULL,
0x0000000c27277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff32ff7812ULL, 0x000fda0007826031ULL, 0x800000090d0d1221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b0d0d1820ULL, 0x000fc80000410000ULL,
0x0000000d00051308ULL, 0x000e640000000800ULL, 0x0000000530301220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x0000000a300a7221ULL, 0x008fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005ff06723eULL, 0x000fe400000000ffULL,
0x00000002ff087819ULL, 0x000fe40000011603ULL, 0x00005410060d7816ULL, 0x000fe20000000006ULL,
0x000100f27f007947ULL, 0x000fea000b800000ULL, 0x00001f080d067589ULL, 0x0002a400000e0000ULL,
0x00000008080c7810ULL, 0x000fe20007ffe0ffULL, 0x000101227f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0d077589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010080c7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000dULL,
0x00002e40000f7802ULL, 0x000fc40000000f00ULL, 0x00010ae000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018080c7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00002e90000f7802ULL, 0x000fc40000000f00ULL,
0x00010a9000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004ff087819ULL, 0x002fe20000011603ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000007036d7812ULL, 0x000fc400078ec0ffULL, 0x00000008036e7812ULL, 0x000fe200078ec0ffULL,
0x000000040b0d7824ULL, 0x008fe200078e0208ULL, 0x000000086d0c7812ULL, 0x004fe200078ef803ULL,
0x0000020002087824ULL, 0x000fc800078e00ffULL, 0x000000010c0d7824ULL, 0x000fe200078e020dULL,
0xfffff80008317812ULL, 0x000fe200078ec0ffULL, 0x000000080c0e7824ULL, 0x000fca00078e00ffULL,
0xfffffff80e087812ULL, 0x000fca00078ee20dULL, 0x0000001008087824ULL, 0x000fc600078e0231ULL,
0x0000006d6e0e7212ULL, 0x040fe200078efcffULL, 0x000000020b5d7824ULL, 0x000fe200078e0267ULL,
0x009000000844783bULL, 0x000e620000000200ULL, 0x000000106e327812ULL, 0x000fe400078efe6dULL,
0x0000000e030f7211ULL, 0x000fe200078fe0ffULL, 0x000000080e307824ULL, 0x040fe200078e00ffULL,
0x000000020d0d7810ULL, 0x000fe20007ffe0ffULL, 0x000000080e337824ULL, 0x040fe200078e00ffULL,
0x000000040f627810ULL, 0x040fe20007ffe0ffULL, 0x000000080e647824ULL, 0x040fe200078e00ffULL,
0x000000060f657810ULL, 0x000fe20007ffe0ffULL, 0x000020005d5d7824ULL, 0x000fe200078e00ffULL,
0xfffffff833627812ULL, 0x000fe200078ee262ULL, 0x000000080e0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff864647812ULL, 0x000fe200078ee20fULL, 0x0000000832367824ULL, 0x040fe200078e00ffULL,
0x0000b0005d0b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000832617824ULL, 0x000fe200078e00ffULL,
0xfffffff80e657812ULL, 0x000fe200078ee265ULL, 0x0000000832377824ULL, 0x000fe200078e00ffULL,
0x000000020f637810ULL, 0x000fe20007ffe0ffULL, 0x0000001064507824ULL, 0x100fe200078e020bULL,
0x0000003203347211ULL, 0x000fe200078fe0ffULL, 0x00000010624c7824ULL, 0x000fe200078e020bULL,
0xfffffff830637812ULL, 0x000fe200078ee263ULL, 0x0000001065487824ULL, 0x100fe200078e020bULL,
0x00000004345f7810ULL, 0x000fe20007ffe0ffULL, 0x000000005050783bULL, 0x000ea20000004200ULL,
0x000000080c307824ULL, 0x000fe200078e00ffULL, 0x00000006345e7810ULL, 0x000fe20007ffe0ffULL,
0x00000010630c7824ULL, 0x000fe200078e020bULL, 0x000000004c4c783bULL, 0x000ee20000004200ULL,
0xfffffff861617812ULL, 0x000fe200078ee234ULL, 0x0000000832357824ULL, 0x000fe200078e00ffULL,
0xfffffff830307812ULL, 0x000fe200078ee20dULL, 0x000000004848783bULL, 0x000fe20000004200ULL,
0xfffffff8365f7812ULL, 0x000fe200078ee25fULL, 0x0000001061407824ULL, 0x000fe200078e020bULL,
0xfffffff8375e7812ULL, 0x000fe200078ee25eULL, 0x000000000c0c783bULL, 0x000fe20000004200ULL,
0x0000001030307824ULL, 0x000fe200078e0231ULL, 0x0000000234607810ULL, 0x000fe20007ffe0ffULL,
0x000000105f387824ULL, 0x100fe200078e020bULL, 0x000000004040783bULL, 0x000fe20000004200ULL,
0x000000105e347824ULL, 0x000fe200078e020bULL, 0xfffffff835607812ULL, 0x000fe200078ee260ULL,
0x0000000644440232ULL, 0x082fe20000000000ULL, 0x009000003030783bULL, 0x000e620000000200ULL,
0x0000000646460232ULL, 0x000fc40000000000ULL, 0x00000010603c7824ULL, 0x000fe200078e020bULL,
0x000000003838783bULL, 0x000f220000004200ULL, 0x0000000745450232ULL, 0x080fe40000000000ULL,
0x0000000747470232ULL, 0x000fe20000000000ULL, 0x000000003434783bULL, 0x000f280000004200ULL,
0x000000003c3c783bULL, 0x000f240000004200ULL, 0x00000050442c723cULL, 0x044f70000000182cULL,
0x000000524428723cULL, 0x040f700000001828ULL, 0x0000004c4418723cULL, 0x008f620000001818ULL,
0x0000000630300232ULL, 0x002fc40000000000ULL, 0x0000000632320232ULL, 0x000fca0000000000ULL,
0x0000004e441c723cULL, 0x000f62000000181cULL, 0x0000000731310232ULL, 0x080fe40000000000ULL,
0x0000000733330232ULL, 0x000fca0000000000ULL, 0x000000484420723cULL, 0x040f700000001820ULL,
0x0000004a4424723cULL, 0x040f700000001824ULL, 0x0000000c4410723cULL, 0x040f700000001810ULL,
0x0000000e440c723cULL, 0x000f700000001814ULL, 0x00000040302c723cULL, 0x060f70000000182cULL,
0x000000423028723cULL, 0x040f700000001828ULL, 0x000000383018723cULL, 0x050f700000001818ULL,
0x0000003a301c723cULL, 0x040f70000000181cULL, 0x000000343020723cULL, 0x040f700000001820ULL,
0x000000363024723cULL, 0x040f700000001824ULL, 0x0000003c3014723cULL, 0x040f700000001810ULL,
0x0000003e303c723cULL, 0x000b6e000000180cULL, 0x00000002020c7824ULL, 0x020fca00078e00ffULL,
0xfffffff80c0c7812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000001000f7810ULL, 0x000fe20007ffe0ffULL, 0x013688000cff7f8cULL, 0x0003e2000c80043fULL,
0x00000080040d7810ULL, 0x000fe40007ffe0ffULL, 0x000000660f00720cULL, 0x000fc60003f06070ULL,
0x000066006c367a24ULL, 0x000fe200078e020dULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000061000008947ULL, 0x000fea0003800000ULL, 0x00000003ff377819ULL, 0x002fe20000011603ULL,
0x00000080670e7824ULL, 0x000fe200078e026fULL, 0x0000000d5c0c7217ULL, 0x000fe40007800000ULL,
0x0000000837317810ULL, 0x040fe20007ffe0ffULL, 0x0000000137117824ULL, 0x040fe200078e0236ULL,
0x0000000437137810ULL, 0x040fe20007ffe0ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a0dULL,
0x0000001037397810ULL, 0x000fe20007ffe0ffULL, 0x0000000131387824ULL, 0x100fe200078e0203ULL,
0x0000000c37357810ULL, 0x000fe20007ffe0ffULL, 0x00000008310f7824ULL, 0x000fe200078e00ffULL,
0x000000200c427817ULL, 0x000fe20003800000ULL, 0x00000001130d7824ULL, 0x100fe200078e0203ULL,
0x00000014373b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000813467824ULL, 0x000fe200078e00ffULL,
0xfffffff80f387812ULL, 0x000fe200078ee238ULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x000000421300720cULL, 0x080fe20003f86070ULL, 0x00000001393a7824ULL, 0x000fe200078e0203ULL,
0xfffffff846467812ULL, 0x000fe200078ee20dULL, 0x00000001130d7824ULL, 0x000fe200078e0236ULL,
0x000000423500720cULL, 0x080fe20003f46070ULL, 0x0000010011107825ULL, 0x000fe200078e000eULL,
0x000000423100720cULL, 0x000fc40003f66070ULL, 0x000000423700720cULL, 0x080fe20003fa6070ULL,
0x000001000d0c7825ULL, 0x000fe200078e000eULL, 0x0000620010327a10ULL, 0x000fe40007f1e0ffULL,
0x0000001837437810ULL, 0x000fe20007ffe0ffULL, 0x0000000839337824ULL, 0x000fe200078e00ffULL,
0x000062000c107a10ULL, 0x000fe20007f3e0ffULL, 0x0000000135407824ULL, 0x100fe200078e0203ULL,
0x0000001c37457810ULL, 0x000fe20007ffe0ffULL, 0x0000000835137824ULL, 0x000fe200078e00ffULL,
0xfffffff8333a7812ULL, 0x000fe200078ee23aULL, 0x00000001370c7824ULL, 0x100fe200078e0203ULL,
0x0000630011337a10ULL, 0x000fe200007fe4ffULL, 0x000000013b447824ULL, 0x000fe200078e0203ULL,
0xfffffff813407812ULL, 0x000fe200078ee240ULL, 0x0000000135137824ULL, 0x100fe200078e0236ULL,
0x000063000d117a10ULL, 0x000fe20000ffe4ffULL, 0x00000001310d7824ULL, 0x000fe200078e0236ULL,
0x000000070c347812ULL, 0x000fe200078ec0ffULL, 0x0000010013127825ULL, 0x000fe200078e000eULL,
0x000000423900720cULL, 0x000fc40003f26070ULL, 0x0ffffff834347812ULL, 0x000fe200078ef803ULL,
0x000001000d0c7825ULL, 0x000fe200078e000eULL, 0x0000620012127a10ULL, 0x000fc60007fde0ffULL,
0x000000083b357824ULL, 0x000fe200078e00ffULL, 0x000062000c0c7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000139317824ULL, 0x000fe200078e0236ULL, 0x0000630013137a10ULL, 0x000fe200037fe4ffULL,
0x0000001034397824ULL, 0x000fe200078e020bULL, 0xfffffff835447812ULL, 0x000fe200078ee244ULL,
0x0000010031307825ULL, 0x000fe200078e000eULL, 0x000063000d0d7a10ULL, 0x000fe400007fe4ffULL,
0x000000423b00720cULL, 0x040fe20003f06070ULL, 0x000000013b357824ULL, 0x000fe200078e0236ULL,
0x0000620030307a10ULL, 0x000fe20007fde0ffULL, 0x00000010463b7824ULL, 0x000fe200078e020bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000032397faeULL, 0x0003e2000e901c48ULL,
0x0000010035347825ULL, 0x000fe200078e000eULL, 0x0000630031317a10ULL, 0x000fc400037fe4ffULL,
0x00000000103b7faeULL, 0x0005e2000e101c48ULL, 0x0000000143377824ULL, 0x100fe200078e0236ULL,
0x0000620034347a10ULL, 0x000fe20007fde0ffULL, 0x0000000145417824ULL, 0x000fe200078e0236ULL,
0x000000424300720cULL, 0x0c0fe20003fa6070ULL, 0x0000000143367824ULL, 0x000fe200078e0203ULL,
0x000000424500720cULL, 0x040fe20003f86070ULL, 0x0000000845427824ULL, 0x000fe200078e00ffULL,
0x0000630035357a10ULL, 0x000fe200037fe4ffULL, 0x0000010037327825ULL, 0x002fc800078e000eULL,
0x0000000145117824ULL, 0x004fe200078e0203ULL, 0x0000620032107a10ULL, 0x000fe20007fde0ffULL,
0x0000000843437824ULL, 0x000fe400078e00ffULL, 0x00000100410e7825ULL, 0x000fe200078e000eULL,
0xfffffff842327812ULL, 0x000fe400078ee211ULL, 0xfffffff843367812ULL, 0x000fe200078ee236ULL,
0x0000001040377824ULL, 0x100fe200078e020bULL, 0x0000630033117a10ULL, 0x000fe200037fe4ffULL,
0x0000001038337824ULL, 0x100fe200078e020bULL, 0x000062000e0e7a10ULL, 0x000fe20007fde0ffULL,
0x000000103a397824ULL, 0x000fc400078e020bULL, 0x00000010443b7824ULL, 0x100fe200078e020bULL,
0x000063000f0f7a10ULL, 0x000fe200037fe4ffULL, 0x0000001036417824ULL, 0x100fe200078e020bULL,
0x000000000c337faeULL, 0x0003e2000d901c48ULL, 0x00000010320b7824ULL, 0x000fc600078e020bULL,
0x0000000012377faeULL, 0x0003e8000d101c48ULL, 0x0000000030397faeULL, 0x0003e8000c901c48ULL,
0x00000000343b7faeULL, 0x0003e8000c101c48ULL, 0x0000000010417faeULL, 0x0003e8000e901c48ULL,
0x000000000e0b7faeULL, 0x0003e2000e101c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000000403357811ULL, 0x042fe400078fe8ffULL, 0x0000000803377811ULL, 0x000fc400078fe8ffULL,
0x0000000c03317811ULL, 0x000fe200078fe8ffULL, 0x0000000135387824ULL, 0x100fe200078e0203ULL,
0x0000001803117811ULL, 0x000fe200078fe8ffULL, 0x00000008350d7824ULL, 0x000fe400078e00ffULL,
0x00000001370c7824ULL, 0x140fe400078e0203ULL, 0x00000008370f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d387812ULL, 0x000fe200078ee238ULL, 0x0000000831137824ULL, 0x000fe200078e00ffULL,
0x00000010030d7811ULL, 0x000fe200078fe8ffULL, 0x0000000111127824ULL, 0x100fe200078e0203ULL,
0xfffffff80f407812ULL, 0x000fe200078ee20cULL, 0x00000001310c7824ULL, 0x100fe200078e0203ULL,
0x00000014030f7811ULL, 0x000fe200078fe8ffULL, 0x000000010d0e7824ULL, 0x000fc400078e0203ULL,
0x000000080d337824ULL, 0x000fe200078e00ffULL, 0xfffffff813427812ULL, 0x000fe200078ee20cULL,
0x00000008113b7824ULL, 0x000fe200078e00ffULL, 0x00000003030c7211ULL, 0x000fe200078fe8ffULL,
0x000000010f107824ULL, 0x000fe200078e0203ULL, 0xfffffff833447812ULL, 0x000fe200078ee20eULL,
0x000000080f397824ULL, 0x000fe200078e00ffULL, 0xfffffff83b487812ULL, 0x000fe200078ee212ULL,
0x0000008067127824ULL, 0x000fe200078e026fULL, 0x0000003603337211ULL, 0x040fe200078fe8ffULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0x0000001c030e7811ULL, 0x000fe200078fe8ffULL,
0x0000000135357824ULL, 0x000fe200078e0236ULL, 0xfffffff839467812ULL, 0x000fe200078ee210ULL,
0x0000000137377824ULL, 0x100fe200078e0236ULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000131317824ULL, 0x000fc400078e0236ULL, 0x0000010033327825ULL, 0x000fe200078e0012ULL,
0x0ffffff80c3a7812ULL, 0x000fc600078ef803ULL, 0x000000010d0d7824ULL, 0x100fe200078e0236ULL,
0x0000620032327a10ULL, 0x000fe20007f1e0ffULL, 0x000000010f0f7824ULL, 0x100fe400078e0236ULL,
0x0000000111117824ULL, 0x100fe200078e0236ULL, 0x0000630033337a10ULL, 0x000fe200007fe4ffULL,
0x000000010e397824ULL, 0x000fe400078e0236ULL, 0x0000010035347825ULL, 0x000fc800078e0012ULL,
0x0000010037367825ULL, 0x000fe200078e0012ULL, 0x0000620034347a10ULL, 0x000fc60007f3e0ffULL,
0x0000010031307825ULL, 0x000fe200078e0012ULL, 0x0000620036367a10ULL, 0x000fe40007f5e0ffULL,
0x0000630035357a10ULL, 0x000fe20000ffe4ffULL, 0x000000010e3b7824ULL, 0x000fe200078e0203ULL,
0x0000620030307a10ULL, 0x000fe20007f7e0ffULL, 0x000000080e4a7824ULL, 0x000fe200078e00ffULL,
0x0000630037377a10ULL, 0x000fe200017fe4ffULL, 0x000001000d0c7825ULL, 0x000fe200078e0012ULL,
0x0000630031317a10ULL, 0x000fe40001ffe4ffULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee23bULL,
0x000001000f0e7825ULL, 0x000fe200078e0012ULL, 0x000062000c0c7a10ULL, 0x000fc60007f1e0ffULL,
0x0000010011107825ULL, 0x100fe200078e0012ULL, 0x000062000e0e7a10ULL, 0x000fe40007f3e0ffULL,
0x000063000d0d7a10ULL, 0x000fe200007fe4ffULL, 0x0000010039127825ULL, 0x000fe200078e0012ULL,
0x0000620010107a10ULL, 0x000fe40007f5e0ffULL, 0x000063000f0f7a10ULL, 0x000fe20000ffe4ffULL,
0x000000103a397824ULL, 0x100fe200078e020bULL, 0x0000620012127a10ULL, 0x000fe20007f7e0ffULL,
0x00000010383b7824ULL, 0x100fe200078e020bULL, 0x0000630011117a10ULL, 0x000fe200017fe4ffULL,
0x0000001040417824ULL, 0x100fe200078e020bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032397faeULL, 0x0003e2000b901c48ULL, 0x0000001042437824ULL, 0x100fe200078e020bULL,
0x0000630013137a10ULL, 0x000fe20001ffe4ffULL, 0x0000001044457824ULL, 0x100fe200078e020bULL,
0x00000000343b7faeULL, 0x0003e2000b901c48ULL, 0x0000001046477824ULL, 0x000fc400078e020bULL,
0x0000001048497824ULL, 0x100fe200078e020bULL, 0x0000000036417faeULL, 0x0003e2000b901c48ULL,
0x000000104a0b7824ULL, 0x000fc600078e020bULL, 0x0000000030437faeULL, 0x0003e8000b901c48ULL,
0x000000000c457faeULL, 0x0003e8000b901c48ULL, 0x000000000e477faeULL, 0x0003e8000b901c48ULL,
0x0000000010497faeULL, 0x0003e8000b901c48ULL, 0x00000000120b7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe0710b7812ULL, 0x002fc400078ec0ffULL,
0x00000010710c7812ULL, 0x040fe400078ec0ffULL, 0x00000008710d7812ULL, 0x000fc800078ec0ffULL,
0x0000000b0d0b7210ULL, 0x000fe20007ffe00cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x013628000b0e7f8cULL, 0x0002a4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x01362c000b117984ULL, 0x000ee40000000800ULL, 0x8000000011ff7812ULL, 0x00cfe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100c137210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0dULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011411ULL,
0x0000001310107211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0611ULL,
0x0000000210107819ULL, 0x000fc80000001211ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01362c000b117984ULL, 0x000ea40000000800ULL,
0x8000000011ff7812ULL, 0x004fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020020b7824ULL, 0x002fca00078e00ffULL, 0xffffff800b0c7812ULL, 0x000fc800078ec0ffULL,
0x000000806f0b7810ULL, 0x000fca0007ffe00cULL, 0x00000001720b7824ULL, 0x000fca00078e020bULL,
0x013000000b107984ULL, 0x000e680000000800ULL, 0x013200000b117984ULL, 0x0004e20000000800ULL,
0x000000091000720bULL, 0x002fe20003f1d000ULL, 0x0000ebb27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0c127812ULL, 0x000fe2000782c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff0d7224ULL, 0x000fd400078e0009ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x00000001020b7811ULL, 0x000fe400078ff0ffULL, 0x000000091000720bULL, 0x000fe40003f34000ULL,
0x000000020b00720cULL, 0x000fe20003f05270ULL, 0x0000eb527f007947ULL, 0x000fd4000b800000ULL,
0x00000000000b7806ULL, 0x000fc400008e0100ULL, 0x00000080020d8824ULL, 0x000fe200078e026fULL,
0x00000009100c8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x00000001720f8824ULL, 0x000fe200078e020dULL, 0x000099100b0d7816ULL, 0x000fc800000000ffULL,
0x0134000c0f008388ULL, 0x0003e20000000800ULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x00000009100c7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0bff7812ULL, 0x000fc6000780c0ffULL,
0x000000090c0c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c000d7308ULL, 0x000e640000000800ULL, 0x0000000d0a0a7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011603ULL,
0x0000ea727f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0d0c7589ULL, 0x0002a400000e0000ULL,
0x0000000c2c2c7220ULL, 0x084fe20000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000c28287220ULL, 0x080fe20000410000ULL, 0x0000000c29297220ULL, 0x080fe20000410000ULL,
0x0000000c14147220ULL, 0x080fe20000410000ULL, 0x0000000c15157220ULL, 0x080fe20000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000c18187220ULL, 0x080fe20000410000ULL, 0x0000000c19197220ULL, 0x080fe20000410000ULL,
0x0000000c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000c20207220ULL, 0x080fe20000410000ULL, 0x0000000c21217220ULL, 0x080fe20000410000ULL,
0x0000000c24247220ULL, 0x080fe20000410000ULL, 0x0000000c25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000bff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008030c7811ULL, 0x000fe200078ff0ffULL,
0x0000e9527f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0d0c7589ULL, 0x00046400000e0000ULL,
0x0000000c2e2e7220ULL, 0x086fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000c16167220ULL, 0x080fe20000410000ULL, 0x0000000c17177220ULL, 0x080fe20000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000c1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000c1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000c22227220ULL, 0x080fe20000410000ULL, 0x0000000c23237220ULL, 0x080fe20000410000ULL,
0x0000000c26267220ULL, 0x080fe20000410000ULL, 0x0000000c27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff12ff7812ULL, 0x000fe4000780600bULL,
0x00000009100d7209ULL, 0x000fd60007810000ULL, 0x8000000d10100221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b10100820ULL, 0x000fc80000410000ULL, 0x0000001000050308ULL, 0x000e640000000800ULL,
0x0000000511110220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x0000000a11107221ULL, 0x008fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000005ff06723eULL, 0x000fe400000000ffULL, 0x00000002ff0a7819ULL, 0x000fe40000011603ULL,
0x0000541006097816ULL, 0x000fe20000000006ULL, 0x0000e7827f007947ULL, 0x000fea000b800000ULL,
0x00001f0a09067589ULL, 0x0002a400000e0000ULL, 0x000000080a0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000e7b27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c09077589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100a0c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0009ULL, 0x00004970000f7802ULL, 0x000fc40000000f00ULL,
0x0000efb000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180a0c7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0009ULL,
0x000049c0000f7802ULL, 0x000fc40000000f00ULL, 0x0000ef6000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x00000001ff0b7819ULL, 0x000fe20000011602ULL, 0x00980000084c783bULL, 0x0008e20000000200ULL,
0x00000004ff0a7819ULL, 0x002fc40000011603ULL, 0x0000006e6d097212ULL, 0x008fe200078efcffULL,
0x000000020b0c7824ULL, 0x044fe400078e0267ULL, 0x000000040b0a7824ULL, 0x000fe400078e020aULL,
0x00000008090e7824ULL, 0x040fe200078e00ffULL, 0x0000c0000c0c7811ULL, 0x000fe200078e68ffULL,
0x00000001090a7824ULL, 0x000fe200078e020aULL, 0x00000002ff087819ULL, 0x010fc60000011602ULL,
0x0000001064307824ULL, 0x100fe200078e020cULL, 0x000000020a097810ULL, 0x000fe20007ffe0ffULL,
0x0000001063587824ULL, 0x100fe400078e020cULL, 0x0000001062547824ULL, 0x100fe200078e020cULL,
0xfffffff80e097812ULL, 0x000fe200078ee209ULL, 0x0000001065507824ULL, 0x000fe200078e020cULL,
0x000000003030783bULL, 0x000e620000004200ULL, 0x00013690080c7811ULL, 0x040fe400078e18ffULL,
0x0000008008347824ULL, 0x000fe200078e0209ULL, 0x000000005858783bULL, 0x000ea20000004200ULL,
0x0000c0005d097810ULL, 0x000fc60007ffe0ffULL, 0x000000005454783bULL, 0x000fe20000004200ULL,
0x0000980034347811ULL, 0x000fe200078e20ffULL, 0x0000001061687824ULL, 0x100fe400078e0209ULL,
0x000000005050783bULL, 0x000fe20000004200ULL, 0x0000001060697824ULL, 0x100fe400078e0209ULL,
0x000000105f6a7824ULL, 0x100fe200078e0209ULL, 0x000000003434783bULL, 0x000ee20000000200ULL,
0x000000105e6b7824ULL, 0x000fe200078e0209ULL, 0x000000064c4c0232ULL, 0x000fc40000000000ULL,
0x000000006848783bULL, 0x000f220000004200ULL, 0x000000064e4e0232ULL, 0x000fe40000000000ULL,
0x000000074d4d0232ULL, 0x080fe20000000000ULL, 0x000000006944783bULL, 0x000f220000004200ULL,
0x000000074f4f0232ULL, 0x000fc60000000000ULL, 0x000000006a40783bULL, 0x000f280000004200ULL,
0x000000006b38783bULL, 0x000f220000004200ULL, 0x000000304c2c723cULL, 0x042f70000000182cULL,
0x000000324c28723cULL, 0x040f700000001828ULL, 0x000000584c14723cULL, 0x004f620000001814ULL,
0x0000000634340232ULL, 0x008fc40000000000ULL, 0x0000000636360232ULL, 0x000fe40000000000ULL,
0x0000000735350232ULL, 0x080fe40000000000ULL, 0x0000000737370232ULL, 0x000fe20000000000ULL,
0x0000005a4c3c723cULL, 0x040f70000000183cULL, 0x000000544c18723cULL, 0x040f700000001818ULL,
0x000000564c1c723cULL, 0x040f70000000181cULL, 0x000000504c20723cULL, 0x040f700000001820ULL,
0x000000524c24723cULL, 0x000f700000001824ULL, 0x00000048342c723cULL, 0x070b70000000182cULL,
0x0000004a3428723cULL, 0x040b700000001828ULL, 0x000000443414723cULL, 0x040b700000001814ULL,
0x00000046343c723cULL, 0x040b70000000183cULL, 0x000000403418723cULL, 0x040b700000001818ULL,
0x00000042341c723cULL, 0x040b70000000181cULL, 0x000000383420723cULL, 0x040b700000001820ULL,
0x0000003a3424723cULL, 0x000b620000001824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000001000f7810ULL, 0x000fe20007ffe0ffULL, 0x000000000cff7f8cULL, 0x0003e2000c80043fULL,
0x000000c004117810ULL, 0x000fc40007ffe0ffULL, 0x000000660f00720cULL, 0x000fc60003f06070ULL,
0x000066006c347a24ULL, 0x020fe200078e0211ULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000061000008947ULL, 0x000fea0003800000ULL, 0x00000003ff3a7819ULL, 0x002fe20000011603ULL,
0x0000008067387824ULL, 0x000fe200078e026fULL, 0x000000115c047217ULL, 0x000fe20007800000ULL,
0x000000ffff397224ULL, 0x000fe200078e00ffULL, 0x000000043a0e7810ULL, 0x040fe20007ffe0ffULL,
0x000000013a337824ULL, 0x040fe200078e0234ULL, 0x000000103a467810ULL, 0x000fe20007ffe0ffULL,
0x0000000104117824ULL, 0x000fe200078e0a11ULL, 0x0000000c3a307810ULL, 0x000fe20007ffe0ffULL,
0x000000010e447824ULL, 0x100fe200078e0203ULL, 0x000000083a127810ULL, 0x000fe20007ffe0ffULL,
0x000000080e0f7824ULL, 0x000fe200078e00ffULL, 0x0000002011117817ULL, 0x000fe20003800000ULL,
0x0000000146047824ULL, 0x100fe200078e0203ULL, 0x000000143a487810ULL, 0x000fe20007ffe0ffULL,
0x0000000846317824ULL, 0x000fe200078e00ffULL, 0xfffffff80f447812ULL, 0x000fe200078ee244ULL,
0x00000001300c7824ULL, 0x140fe200078e0203ULL, 0x000000113000720cULL, 0x0c0fe20003f46070ULL,
0x0000000830137824ULL, 0x000fe200078e00ffULL, 0xfffffff831047812ULL, 0x000fe200078ee204ULL,
0x0000000112407824ULL, 0x040fe200078e0203ULL, 0x000000111200720cULL, 0x0c0fe20003f66070ULL,
0x00000008120f7824ULL, 0x040fe200078e00ffULL, 0xfffffff8130c7812ULL, 0x000fe200078ee20cULL,
0x0000000112317824ULL, 0x100fe200078e0234ULL, 0x000000110e00720cULL, 0x000fe20003fa6070ULL,
0x0000000130137824ULL, 0x000fe200078e0234ULL, 0xfffffff80f407812ULL, 0x000fe200078ee240ULL,
0x000000010e0f7824ULL, 0x000fe200078e0234ULL, 0x000000183a4a7810ULL, 0x000fe20007ffe0ffULL,
0x0000010033327825ULL, 0x000fc800078e0038ULL, 0x0000010031307825ULL, 0x000fe200078e0038ULL,
0x0000620032367a10ULL, 0x000fc60007f1e0ffULL, 0x0000010013127825ULL, 0x000fe200078e0038ULL,
0x0000620030327a10ULL, 0x000fe40007f9e0ffULL, 0x0000630033377a10ULL, 0x000fe200007fe4ffULL,
0x0000000148427824ULL, 0x000fe200078e0203ULL, 0x0000620012307a10ULL, 0x000fe20007fde0ffULL,
0x0000000848357824ULL, 0x000fe200078e00ffULL, 0x0000630031337a10ULL, 0x000fe200027fe4ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0038ULL, 0x0000630013317a10ULL, 0x000fe400037fe4ffULL,
0xfffffff835427812ULL, 0x000fe200078ee242ULL, 0x000000013a357824ULL, 0x000fe200078e0203ULL,
0x000062000e0e7a10ULL, 0x000fe20007f3e0ffULL, 0x0000000146137824ULL, 0x100fe200078e0234ULL,
0x000000114800720cULL, 0x0c0fe20003f06070ULL, 0x00000001483b7824ULL, 0x000fe200078e0234ULL,
0x000063000f0f7a10ULL, 0x000fe20000ffe4ffULL, 0x0000010013127825ULL, 0x000fe200078e0038ULL,
0x000000114600720cULL, 0x000fc40003f26070ULL, 0x0000001c3a487810ULL, 0x000fe40007ffe0ffULL,
0x0000000735467812ULL, 0x000fe200078ec0ffULL, 0x000000014a357824ULL, 0x100fe200078e0234ULL,
0x000000113a00720cULL, 0x000fe20003f86070ULL, 0x0000000148437824ULL, 0x000fe200078e0234ULL,
0x0ffffff846467812ULL, 0x000fe200078ef803ULL, 0x000001003b3a7825ULL, 0x000fe200078e0038ULL,
0x0000620012127a10ULL, 0x000fc60007fde0ffULL, 0x0000010035347825ULL, 0x000fe200078e0038ULL,
0x0000630013137a10ULL, 0x000fe400037fe4ffULL, 0x000062003a3a7a10ULL, 0x000fe20007fde0ffULL,
0x0000001046417824ULL, 0x000fe400078e0209ULL, 0x0000010043387825ULL, 0x000fe200078e0038ULL,
0x000063003b3b7a10ULL, 0x000fe400037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000036417faeULL, 0x0003e2000e101c48ULL, 0x0000001044437824ULL, 0x000fe200078e0209ULL,
0x0000620034347a10ULL, 0x000fe20007f9e0ffULL, 0x0000000148447824ULL, 0x100fe200078e0203ULL,
0x000000114a00720cULL, 0x080fe20003fc6070ULL, 0x0000000848457824ULL, 0x040fe200078e00ffULL,
0x000000000e437faeULL, 0x0005e2000e901c48ULL, 0x000000114800720cULL, 0x000fe20003fa6070ULL,
0x000000014a117824ULL, 0x040fe200078e0203ULL, 0x0000630035357a10ULL, 0x000fe200027fe4ffULL,
0x000000084a4a7824ULL, 0x000fe200078e00ffULL, 0xfffffff845447812ULL, 0x000fe200078ee244ULL,
0x000000100c377824ULL, 0x002fc400078e0209ULL, 0x0000001042417824ULL, 0x000fe200078e0209ULL,
0xfffffff84a367812ULL, 0x000fe200078ee211ULL, 0x0000001040117824ULL, 0x100fe200078e0209ULL,
0x00006200380e7a10ULL, 0x004fe20007f9e0ffULL, 0x0000001044457824ULL, 0x100fe400078e0209ULL,
0x0000001036437824ULL, 0x100fe200078e0209ULL, 0x00006300390f7a10ULL, 0x000fe200027fe4ffULL,
0x0000001004397824ULL, 0x000fe200078e0209ULL, 0x0000000032117faeULL, 0x0003e8000d901c48ULL,
0x0000000030377faeULL, 0x0003e8000d101c48ULL, 0x0000000012397faeULL, 0x0003e8000c901c48ULL,
0x000000003a417faeULL, 0x0003e8000c101c48ULL, 0x0000000034437faeULL, 0x0003e8000f101c48ULL,
0x000000000e457faeULL, 0x0003e2000e901c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000000803137811ULL, 0x002fe200078fe8ffULL, 0x00000080673a7824ULL, 0x000fe200078e026fULL,
0x00000004030f7811ULL, 0x000fc400078fe8ffULL, 0x0000001403357811ULL, 0x000fe200078fe8ffULL,
0x0000000113447824ULL, 0x100fe200078e0203ULL, 0x0000000c03317811ULL, 0x000fe200078fe8ffULL,
0x0000000813337824ULL, 0x000fe200078e00ffULL, 0x0000001803377811ULL, 0x000fe200078fe8ffULL,
0x000000010f467824ULL, 0x100fe200078e0203ULL, 0x0000001c030e7811ULL, 0x000fe200078fe8ffULL,
0x000000080f117824ULL, 0x000fe200078e00ffULL, 0xfffffff833447812ULL, 0x000fe200078ee244ULL,
0x00000001350c7824ULL, 0x100fe200078e0203ULL, 0x0000001003337811ULL, 0x000fe200078fe8ffULL,
0x00000008353b7824ULL, 0x000fe200078e00ffULL, 0xfffffff811467812ULL, 0x000fe200078ee246ULL,
0x0000000131427824ULL, 0x000fc400078e0203ULL, 0x0000000133407824ULL, 0x100fe200078e0203ULL,
0xfffffff83b0c7812ULL, 0x000fe200078ee20cULL, 0x0000000833397824ULL, 0x000fe400078e00ffULL,
0x0000000831117824ULL, 0x000fe400078e00ffULL, 0x0000000137047824ULL, 0x000fe200078e0203ULL,
0xfffffff839407812ULL, 0x000fe200078ee240ULL, 0x0000000837417824ULL, 0x000fe200078e00ffULL,
0x0000003403397211ULL, 0x000fe200078fe8ffULL, 0x000000010f0f7824ULL, 0x000fe200078e0234ULL,
0xfffffff811427812ULL, 0x000fe200078ee242ULL, 0x0000000113137824ULL, 0x000fe200078e0234ULL,
0xfffffff841047812ULL, 0x000fe200078ee204ULL, 0x0000000131317824ULL, 0x000fc400078e0234ULL,
0x0000000133337824ULL, 0x100fe400078e0234ULL, 0x0000000135357824ULL, 0x100fe400078e0234ULL,
0x0000000137377824ULL, 0x100fe400078e0234ULL, 0x000000ffff3b7224ULL, 0x000fe400078e00ffULL,
0x000000010e117824ULL, 0x040fe400078e0234ULL, 0x000000010e417824ULL, 0x000fc400078e0203ULL,
0x000000080e4a7824ULL, 0x000fe400078e00ffULL, 0x0000010039387825ULL, 0x000fc600078e003aULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee241ULL, 0x000001000f0e7825ULL, 0x000fe200078e003aULL,
0x0000620038387a10ULL, 0x000fc60007f1e0ffULL, 0x0000010013127825ULL, 0x100fe200078e003aULL,
0x000062000e0e7a10ULL, 0x000fe40007f3e0ffULL, 0x0000630039397a10ULL, 0x000fe200007fe4ffULL,
0x0000010031307825ULL, 0x100fe200078e003aULL, 0x000063000f0f7a10ULL, 0x000fe40000ffe4ffULL,
0x0000620012127a10ULL, 0x000fe20007f1e0ffULL, 0x0000010033327825ULL, 0x100fe200078e003aULL,
0x0000620030307a10ULL, 0x000fe40007f3e0ffULL, 0x0000630013137a10ULL, 0x000fe200007fe4ffULL,
0x0000010035347825ULL, 0x000fe200078e003aULL, 0x0000620032327a10ULL, 0x000fc40007f5e0ffULL,
0x0000630031317a10ULL, 0x000fe20000ffe4ffULL, 0x0000010037367825ULL, 0x100fe200078e003aULL,
0x0000620034347a10ULL, 0x000fe40007f1e0ffULL, 0x0000630033337a10ULL, 0x000fe200017fe4ffULL,
0x00000100113a7825ULL, 0x000fe200078e003aULL, 0x0000000303117211ULL, 0x000fe400078fe8ffULL,
0x0000620036367a10ULL, 0x000fe20007f3e0ffULL, 0x0000001046417824ULL, 0x100fe200078e0209ULL,
0x0000000711487812ULL, 0x000fe200078ec0ffULL, 0x0000001044437824ULL, 0x100fe200078e0209ULL,
0x000062003a3a7a10ULL, 0x000fe20007f5e0ffULL, 0x0000001042457824ULL, 0x000fe200078e0209ULL,
0x0ffffff848487812ULL, 0x000fe200078ef803ULL, 0x0000001040477824ULL, 0x100fe200078e0209ULL,
0x0000630035357a10ULL, 0x000fe200007fe4ffULL, 0x000000100c497824ULL, 0x100fe200078e0209ULL,
0x0000630037377a10ULL, 0x000fe20000ffe4ffULL, 0x0000001048117824ULL, 0x100fe200078e0209ULL,
0x000063003b3b7a10ULL, 0x000fe200017fe4ffULL, 0x00000010044b7824ULL, 0x000fc400078e0209ULL,
0x000000104a4d7824ULL, 0x000fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038117faeULL, 0x0003e8000b901c48ULL, 0x000000000e417faeULL, 0x0003e8000b901c48ULL,
0x0000000012437faeULL, 0x0003e8000b901c48ULL, 0x0000000030457faeULL, 0x0003e8000b901c48ULL,
0x0000000032477faeULL, 0x0003e8000b901c48ULL, 0x0000000034497faeULL, 0x0003e8000b901c48ULL,
0x00000000364b7faeULL, 0x0003e8000b901c48ULL, 0x000000003a4d7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000010710f7812ULL, 0x002fca00078ec0ffULL,
0x0000002008087824ULL, 0x000fc800078e020fULL, 0x0000000867087824ULL, 0x000fe200078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01364800080e7f8cULL, 0x0002a4000c80043fULL,
0x0000000000127805ULL, 0x000fc40000015200ULL, 0x01364c0008117984ULL, 0x000ee40000000800ULL,
0x8000000011ff7812ULL, 0x00cfe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fcc0000015200ULL,
0x0000003012117210ULL, 0x000fca0007f1e1ffULL, 0x0000000131307824ULL, 0x000fe200000e0e13ULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff3000720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff3000720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011430ULL, 0x0000001104047211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0630ULL, 0x0000000204047819ULL, 0x000fc80000001211ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01364c0008117984ULL, 0x000ea40000000800ULL, 0x8000000011ff7812ULL, 0x004fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002002047824ULL, 0x000fca00078e00ffULL,
0xffffff8004047812ULL, 0x000fc800078ec0ffULL, 0x000001006f0f7810ULL, 0x000fca0007ffe004ULL,
0x00000001720f7824ULL, 0x000fca00078e020fULL, 0x013000000f047984ULL, 0x000ea80000000800ULL,
0x013200000f117984ULL, 0x0006620000000800ULL, 0x0000000d0400720bULL, 0x004fe20003f1d000ULL,
0x0000d4427f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0c137812ULL, 0x000fe2000782c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff087224ULL, 0x002fd400078e000dULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x00000002020f7811ULL, 0x000fe400078ff0ffULL,
0x0000000d0400720bULL, 0x000fe40003f34000ULL, 0x000000020f00720cULL, 0x000fe20003f05270ULL,
0x0000d3e27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000087806ULL, 0x000fc400008e0100ULL,
0x00000080020f8824ULL, 0x000fe200078e026fULL, 0x0000000d040c8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x00009910080e7816ULL, 0x000fe200000000ffULL,
0x00000001720f8824ULL, 0x000fca00078e020fULL, 0x0134000c0f008388ULL, 0x0003e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000d040c7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff08ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000d0c0c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00317308ULL, 0x000e640000000800ULL,
0x0000003110107220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011603ULL, 0x0000d3027f007947ULL, 0x000fea000b800000ULL,
0x00001f0c310c7589ULL, 0x0002a400000e0000ULL, 0x0000000c2c2c7220ULL, 0x084fe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c28287220ULL, 0x080fe20000410000ULL,
0x0000000c29297220ULL, 0x080fe20000410000ULL, 0x0000000c14147220ULL, 0x080fe20000410000ULL,
0x0000000c15157220ULL, 0x080fe20000410000ULL, 0x0000000c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000000c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000c18187220ULL, 0x080fe20000410000ULL,
0x0000000c19197220ULL, 0x080fe20000410000ULL, 0x0000000c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000c20207220ULL, 0x080fe20000410000ULL,
0x0000000c21217220ULL, 0x080fe20000410000ULL, 0x0000000c24247220ULL, 0x080fe20000410000ULL,
0x0000000c25257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0008ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008030c7811ULL, 0x000fe200078ff0ffULL, 0x0000d1e27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c310c7589ULL, 0x0004e400000e0000ULL, 0x0000000c2e2e7220ULL, 0x08cfe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000c16167220ULL, 0x080fe20000410000ULL,
0x0000000c17177220ULL, 0x080fe20000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000000c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000000c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000c22227220ULL, 0x080fe20000410000ULL,
0x0000000c23237220ULL, 0x080fe20000410000ULL, 0x0000000c26267220ULL, 0x080fe20000410000ULL,
0x0000000c27277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff13ff7812ULL, 0x000fe40007806008ULL, 0x0000000d04087209ULL, 0x000fd60007810000ULL,
0x8000000804040221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b04040820ULL, 0x000fc80000410000ULL,
0x0000000400050308ULL, 0x000e640000000800ULL, 0x0000000511110220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x0000001011107221ULL, 0x000fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011603ULL, 0x0000541004047816ULL, 0x000fe20000000004ULL,
0x0000d0127f007947ULL, 0x000fea000b800000ULL, 0x00001f0d04067589ULL, 0x0002a400000e0000ULL,
0x000000080d0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000d0427f007947ULL, 0x000fea000b800000ULL,
0x00001f0c04077589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100d0c7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0004ULL,
0x000062a0000f7802ULL, 0x000fc40000000f00ULL, 0x0000d68000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180d0c7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0004ULL, 0x000062f0000f7802ULL, 0x000fc40000000f00ULL,
0x0000d63000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000006e6d0d7212ULL, 0x002fe200078efcffULL, 0x0000200002047824ULL, 0x048fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000200020c7824ULL, 0x004fe200078e00ffULL,
0x00000002ff117819ULL, 0x000fe20000011602ULL, 0x000000080d0f7824ULL, 0x000fe200078e00ffULL,
0xffffc00004047812ULL, 0x000fe200078ec0ffULL, 0x00000002020e7824ULL, 0x000fe200078e00ffULL,
0xfffff8000c0c7812ULL, 0x000fc400078ec0ffULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee20aULL,
0x0000200067047824ULL, 0x000fe200078e0204ULL, 0x000000040e0a7812ULL, 0x000fc600078ec0ffULL,
0x000000100f487824ULL, 0x000fe200078e020cULL, 0x000000020a0a7812ULL, 0x000fe400078efcffULL,
0x0000b00004047810ULL, 0x000fe40007ffe0ffULL, 0x0000000a030a7211ULL, 0x000fe200078fe0ffULL,
0x00a000004848783bULL, 0x000e640000000200ULL, 0x0000001063547824ULL, 0x100fe400078e0204ULL,
0x0000001062507824ULL, 0x000fc400078e0204ULL, 0x00000010654c7824ULL, 0x000fe400078e0204ULL,
0x000000010d0a7824ULL, 0x040fe200078e020aULL, 0x000000005454783bULL, 0x000ea20000004200ULL,
0x000000080d0d7824ULL, 0x000fe400078e00ffULL, 0x00000010640c7824ULL, 0x000fe200078e0204ULL,
0x000000005050783bULL, 0x000ee40000004200ULL, 0xfffffff80d0a7812ULL, 0x000fe400078ee20aULL,
0x000000004c4c783bULL, 0x000fe60000004200ULL, 0x000000100a047824ULL, 0x000fe200078e00ffULL,
0x0000b0005d0a7810ULL, 0x000fe20007ffe0ffULL, 0x000000000c0c783bULL, 0x000fe40000004200ULL,
0x0000080011307824ULL, 0x000fc400078e0204ULL, 0x0000001060407824ULL, 0x100fe400078e020aULL,
0x000000105e347824ULL, 0x100fe400078e020aULL, 0x00a000003030783bULL, 0x000f220000000200ULL,
0x000000105f387824ULL, 0x100fe400078e020aULL, 0x0000001061447824ULL, 0x000fe200078e020aULL,
0x000000004040783bULL, 0x000f280000004200ULL, 0x000000003838783bULL, 0x000f220000004200ULL,
0x0000000648480232ULL, 0x002fc60000000000ULL, 0x000000003434783bULL, 0x000e620000004200ULL,
0x000000064a4a0232ULL, 0x000fe40000000000ULL, 0x0000000749490232ULL, 0x080fe20000000000ULL,
0x000000004444783bULL, 0x000e620000004200ULL, 0x000000074b4b0232ULL, 0x000fce0000000000ULL,
0x000000544814723cULL, 0x044f700000001814ULL, 0x00000056483c723cULL, 0x040f70000000183cULL,
0x000000504818723cULL, 0x008f620000001818ULL, 0x0000000630300232ULL, 0x010fc40000000000ULL,
0x0000000632320232ULL, 0x000fe40000000000ULL, 0x0000000731310232ULL, 0x080fe40000000000ULL,
0x0000000733330232ULL, 0x000fe20000000000ULL, 0x00000052481c723cULL, 0x040f70000000181cULL,
0x0000004c4820723cULL, 0x040f700000001820ULL, 0x0000004e4824723cULL, 0x040f700000001824ULL,
0x0000000c482c723cULL, 0x040f70000000182cULL, 0x0000000e480c723cULL, 0x000f700000001828ULL,
0x000000403014723cULL, 0x060f700000001814ULL, 0x00000042303c723cULL, 0x040f70000000183cULL,
0x000000383018723cULL, 0x040f700000001818ULL, 0x0000003a301c723cULL, 0x040f70000000181cULL,
0x000000343020723cULL, 0x042f700000001820ULL, 0x000000363024723cULL, 0x040f700000001824ULL,
0x00000044302c723cULL, 0x040f70000000182cULL, 0x000000463044723cULL, 0x000b6e000000180cULL,
0x00013698110c7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fcc0000008000ULL,
0x00000300000f7a10ULL, 0x000fe20007ffe0ffULL, 0x000000000cff7f8cULL, 0x0003e6000c80043fULL,
0x000000660f00720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00000ba000000947ULL, 0x000fea0003800000ULL, 0x000000010f0d7810ULL, 0x042fe20007ffe0ffULL,
0x000001000f0f7824ULL, 0x000fc600078e0270ULL, 0x000000660d00720cULL, 0x000fe20003f06070ULL,
0x000066006c347a24ULL, 0x000fd800078e020fULL, 0x0000061000008947ULL, 0x000fea0003800000ULL,
0x00000003ff367819ULL, 0x000fe40000011603ULL, 0x0000000f5c0c7217ULL, 0x000fe40007800000ULL,
0x00000004360e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000136137824ULL, 0x140fe200078e0234ULL,
0x0000000836307810ULL, 0x000fe20007ffe0ffULL, 0x000000010c3b7824ULL, 0x000fe200078e0a0fULL,
0x0000000c36387810ULL, 0x000fe20007ffe0ffULL, 0x000000010e0d7824ULL, 0x100fe200078e0203ULL,
0x00000010363a7810ULL, 0x000fe20007ffe0ffULL, 0x000000080e127824ULL, 0x000fe200078e00ffULL,
0x000000203b3b7817ULL, 0x000fe20003800000ULL, 0x0000000130357824ULL, 0x000fe200078e0203ULL,
0x0000001436407810ULL, 0x000fe20007ffe0ffULL, 0x0000000830287824ULL, 0x000fe200078e00ffULL,
0xfffffff812437812ULL, 0x000fe200078ee20dULL, 0x00000080670c7824ULL, 0x000fe200078e026fULL,
0x0000003b0e00720cULL, 0x080fe20003f86070ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0xfffffff828357812ULL, 0x000fe200078ee235ULL, 0x000000010e0f7824ULL, 0x000fe200078e0234ULL,
0x0000003b3800720cULL, 0x0c0fe20003f46070ULL, 0x0000000138397824ULL, 0x000fe200078e0203ULL,
0x0000003b3600720cULL, 0x080fe20003fa6070ULL, 0x0000000838287824ULL, 0x000fe200078e00ffULL,
0x0000003b3000720cULL, 0x000fe20003f66070ULL, 0x000001000f0e7825ULL, 0x000fc600078e000cULL,
0xfffffff828397812ULL, 0x000fe200078ee239ULL, 0x0000010013127825ULL, 0x000fe200078e000cULL,
0x000062000e287a10ULL, 0x000fc60007f3e0ffULL, 0x000000013a377824ULL, 0x100fe200078e0203ULL,
0x00006200122a7a10ULL, 0x000fe20007f1e0ffULL, 0x000000083a327824ULL, 0x000fe200078e00ffULL,
0x000063000f297a10ULL, 0x000fe20000ffe4ffULL, 0x00000001360e7824ULL, 0x000fe200078e0203ULL,
0x00006300132b7a10ULL, 0x000fe200007fe4ffULL, 0x0000000138137824ULL, 0x000fe200078e0234ULL,
0xfffffff832377812ULL, 0x000fe200078ee237ULL, 0x0000000140417824ULL, 0x000fe200078e0203ULL,
0x000000070e327812ULL, 0x000fe200078ec0ffULL, 0x0000010013127825ULL, 0x000fe200078e000cULL,
0x0000003b3a00720cULL, 0x000fc40003f26070ULL, 0x0ffffff832337812ULL, 0x000fe200078ef803ULL,
0x0000000840387824ULL, 0x000fe200078e00ffULL, 0x0000620012127a10ULL, 0x000fe20007fde0ffULL,
0x00000001300f7824ULL, 0x100fe400078e0234ULL, 0x000000013a317824ULL, 0x000fe200078e0234ULL,
0xfffffff838417812ULL, 0x000fe200078ee241ULL, 0x000001000f0e7825ULL, 0x100fe200078e000cULL,
0x0000001836387810ULL, 0x000fe40007ffe0ffULL, 0x0000630013137a10ULL, 0x000fe200037fe4ffULL,
0x0000010031307825ULL, 0x000fe200078e000cULL, 0x000062000e0e7a10ULL, 0x000fc40007f1e0ffULL,
0x0000001c36367810ULL, 0x000fe20007ffe0ffULL, 0x0000001033497824ULL, 0x000fe200078e020aULL,
0x0000620030307a10ULL, 0x000fe20007fde0ffULL, 0x0000000140337824ULL, 0x000fe200078e0234ULL,
0x000063000f0f7a10ULL, 0x000fe200007fe4ffULL, 0x00000010434b7824ULL, 0x000fe200078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a497faeULL, 0x0003e2000e901c48ULL,
0x0000010033327825ULL, 0x000fe200078e000cULL, 0x0000630031317a10ULL, 0x000fe400037fe4ffULL,
0x00000000284b7faeULL, 0x0005e2000e101c48ULL, 0x0000000138437824ULL, 0x000fe200078e0234ULL,
0x0000003b4000720cULL, 0x080fe20003f06070ULL, 0x0000001035357824ULL, 0x100fe200078e020aULL,
0x0000620032327a10ULL, 0x000fe20007fde0ffULL, 0x0000001039397824ULL, 0x100fe200078e020aULL,
0x0000003b3800720cULL, 0x080fe20003fa6070ULL, 0x0000001037377824ULL, 0x000fe200078e020aULL,
0x0000003b3600720cULL, 0x040fe20003f86070ULL, 0x00000100432a7825ULL, 0x002fe200078e000cULL,
0x0000630033337a10ULL, 0x000fe200037fe4ffULL, 0x000000000e357faeULL, 0x0003e4000d901c48ULL,
0x00000001363b7824ULL, 0x000fe200078e0234ULL, 0x000062002a287a10ULL, 0x004fe20007fde0ffULL,
0x0000000138347824ULL, 0x040fe200078e0203ULL, 0x0000000012397faeULL, 0x0003e2000d101c48ULL,
0x0000000838437824ULL, 0x000fc400078e00ffULL, 0x0000000136297824ULL, 0x040fe200078e0203ULL,
0x0000000030377faeULL, 0x0003e2000c901c48ULL, 0x0000000836367824ULL, 0x000fe400078e00ffULL,
0x000001003b0c7825ULL, 0x000fe200078e000cULL, 0xfffffff8433b7812ULL, 0x000fe400078ee234ULL,
0xfffffff836437812ULL, 0x000fe200078ee229ULL, 0x0000001041417824ULL, 0x100fe200078e020aULL,
0x000063002b297a10ULL, 0x000fe200037fe4ffULL, 0x000000103b3b7824ULL, 0x100fe200078e020aULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x0000001043437824ULL, 0x000fe200078e020aULL,
0x0000000032417faeULL, 0x0003e4000c101c48ULL, 0x000063000d0d7a10ULL, 0x000fc400037fe4ffULL,
0x00000000283b7faeULL, 0x0003e8000e901c48ULL, 0x000000000c437faeULL, 0x0003e2000e101c48ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000000803317811ULL, 0x040fe200078fe8ffULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000403337811ULL, 0x040fe400078fe8ffULL,
0x00000010030d7811ULL, 0x000fe200078fe8ffULL, 0x0000000131397824ULL, 0x100fe200078e0203ULL,
0x0000000c032b7811ULL, 0x000fe200078fe8ffULL, 0x00000008310e7824ULL, 0x000fe200078e00ffULL,
0x0000001803137811ULL, 0x000fe200078fe8ffULL, 0x0000000133377824ULL, 0x000fe200078e0203ULL,
0x00000014030f7811ULL, 0x000fe200078fe8ffULL, 0x00000008330c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e397812ULL, 0x000fe200078ee239ULL, 0x000000010d0e7824ULL, 0x000fe200078e0203ULL,
0x0000003403357211ULL, 0x000fe200078fe8ffULL, 0x000000080d497824ULL, 0x000fe200078e00ffULL,
0xfffffff80c377812ULL, 0x000fe200078ee237ULL, 0x000000012b0c7824ULL, 0x000fc400078e0203ULL,
0x000000082b437824ULL, 0x000fe200078e00ffULL, 0xfffffff849497812ULL, 0x000fe200078ee20eULL,
0x0000000113287824ULL, 0x100fe200078e0203ULL, 0x0000001c030e7811ULL, 0x000fe200078fe8ffULL,
0x00000008134d7824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee20cULL,
0x0000000133337824ULL, 0x000fe200078e0234ULL, 0x00000003030c7211ULL, 0x000fe200078fe8ffULL,
0x000000010f127824ULL, 0x000fe200078e0203ULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee228ULL,
0x0000008067287824ULL, 0x000fe200078e026fULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000080f4b7824ULL, 0x000fc400078e00ffULL, 0x0000000131317824ULL, 0x100fe200078e0234ULL,
0x0ffffff80c417812ULL, 0x000fe200078ef803ULL, 0x000000012b2b7824ULL, 0x000fe200078e0234ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee212ULL, 0x000000010d0d7824ULL, 0x100fe400078e0234ULL,
0x000000010f0f7824ULL, 0x100fe400078e0234ULL, 0x0000000113137824ULL, 0x100fe400078e0234ULL,
0x000000010e3b7824ULL, 0x000fc400078e0234ULL, 0x0000010035347825ULL, 0x000fc800078e0028ULL,
0x0000010033327825ULL, 0x000fe200078e0028ULL, 0x0000620034347a10ULL, 0x000fc60007f1e0ffULL,
0x0000010031307825ULL, 0x100fe200078e0028ULL, 0x0000620032327a10ULL, 0x000fe40007f3e0ffULL,
0x0000630035357a10ULL, 0x000fe200007fe4ffULL, 0x000001002b2a7825ULL, 0x000fe200078e0028ULL,
0x0000620030307a10ULL, 0x000fe40007f5e0ffULL, 0x0000630033337a10ULL, 0x000fe20000ffe4ffULL,
0x000000010e367824ULL, 0x000fe200078e0203ULL, 0x000062002a2a7a10ULL, 0x000fe20007f7e0ffULL,
0x000000080e4f7824ULL, 0x000fe200078e00ffULL, 0x0000630031317a10ULL, 0x000fe200017fe4ffULL,
0x000001000d0c7825ULL, 0x000fe200078e0028ULL, 0x000063002b2b7a10ULL, 0x000fc60001ffe4ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0028ULL, 0x000062000c0c7a10ULL, 0x000fc60007f1e0ffULL,
0x0000010013127825ULL, 0x100fe200078e0028ULL, 0x000062000e0e7a10ULL, 0x000fe40007f3e0ffULL,
0x000063000d0d7a10ULL, 0x000fe200007fe4ffULL, 0x000001003b287825ULL, 0x000fe200078e0028ULL,
0xfffffff84f3b7812ULL, 0x000fe400078ee236ULL, 0x0000620012127a10ULL, 0x000fe20007f5e0ffULL,
0x0000001041417824ULL, 0x100fe200078e020aULL, 0x0000620028287a10ULL, 0x000fe20007f7e0ffULL,
0x0000001037377824ULL, 0x100fe200078e020aULL, 0x000063000f0f7a10ULL, 0x000fe20000ffe4ffULL,
0x0000001039397824ULL, 0x100fe200078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034417faeULL, 0x0003e2000b901c48ULL, 0x0000001043437824ULL, 0x100fe200078e020aULL,
0x0000630013137a10ULL, 0x000fe200017fe4ffULL, 0x0000001049497824ULL, 0x100fe200078e020aULL,
0x0000000032377faeULL, 0x0003e2000b901c48ULL, 0x000000104b4b7824ULL, 0x100fe200078e020aULL,
0x0000630029297a10ULL, 0x000fe20001ffe4ffULL, 0x000000104d4d7824ULL, 0x100fe200078e020aULL,
0x0000000030397faeULL, 0x0003e2000b901c48ULL, 0x000000103b3b7824ULL, 0x000fc600078e020aULL,
0x000000002a437faeULL, 0x0003e8000b901c48ULL, 0x000000000c497faeULL, 0x0003e8000b901c48ULL,
0x000000000e4b7faeULL, 0x0003e8000b901c48ULL, 0x00000000124d7faeULL, 0x0003e8000b901c48ULL,
0x00000000283b7faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x00000010710a7812ULL, 0x000fc400078ec0ffULL, 0x00000008710d7812ULL, 0x000fc600078ec0ffULL,
0x00000020110a7824ULL, 0x000fc800078e020aULL, 0x000000010d0a7824ULL, 0x000fe200078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x013668000a0e7f8cULL, 0x0002a4000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x01366c000a117984ULL, 0x000ee40000000800ULL,
0x8000000011ff7812ULL, 0x00cfe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff287224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x000000120c127210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e0dULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff117819ULL, 0x000fc80000011413ULL, 0x0000001211117211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e0613ULL, 0x0000000211117819ULL, 0x000fc80000001212ULL,
0x000000110000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000128287810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01366c000a117984ULL, 0x000ea40000000800ULL, 0x8000000011ff7812ULL, 0x004fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000003020a7811ULL, 0x002fca00078ff0ffULL,
0x000000800a0d7824ULL, 0x000fc800078e026fULL, 0x00000001720d7824ULL, 0x000fca00078e020dULL,
0x013000000d117984ULL, 0x000e680000000800ULL, 0x013200000d0a7984ULL, 0x0004e20000000800ULL,
0x000000081100720bULL, 0x002fe20003f1d000ULL, 0x0000bc327f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0c127812ULL, 0x000fe2000782c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x00000003020d7811ULL, 0x000fe400078ff0ffULL,
0x000000081100720bULL, 0x000fe40003f34000ULL, 0x000000020d00720cULL, 0x000fe20003f05270ULL,
0x0000bbe27f007947ULL, 0x000fd4000b800000ULL, 0x00000000000d7806ULL, 0x000fc400008e0100ULL,
0x00000080026f8824ULL, 0x000fe200078e026fULL, 0x00000008110c8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x000099100d0e7816ULL, 0x000fe200000000ffULL,
0x00000001726f8824ULL, 0x000fca00078e026fULL, 0x0134000c6f008388ULL, 0x0003e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x00000008110f7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0dff7812ULL, 0x000fc6000780c0ffULL, 0x000000080f0c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00137308ULL, 0x000e640000000800ULL,
0x0000001310107220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011603ULL, 0x0000bb027f007947ULL, 0x000fea000b800000ULL,
0x00001f0c130c7589ULL, 0x0002a400000e0000ULL, 0x0000000c2c2c7220ULL, 0x084fe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c44447220ULL, 0x080fe20000410000ULL,
0x0000000c45457220ULL, 0x080fe20000410000ULL, 0x0000000c14147220ULL, 0x080fe20000410000ULL,
0x0000000c15157220ULL, 0x080fe20000410000ULL, 0x0000000c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000000c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000c18187220ULL, 0x080fe20000410000ULL,
0x0000000c19197220ULL, 0x080fe20000410000ULL, 0x0000000c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000c1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000c20207220ULL, 0x080fe20000410000ULL,
0x0000000c21217220ULL, 0x080fe20000410000ULL, 0x0000000c24247220ULL, 0x080fe20000410000ULL,
0x0000000c25257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000dff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008030c7811ULL, 0x000fe200078ff0ffULL, 0x0000b9e27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c130c7589ULL, 0x00046400000e0000ULL, 0x0000000c2e2e7220ULL, 0x086fe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c46467220ULL, 0x080fe20000410000ULL,
0x0000000c47477220ULL, 0x080fe20000410000ULL, 0x0000000c16167220ULL, 0x080fe20000410000ULL,
0x0000000c17177220ULL, 0x080fe20000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000000c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000000c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000c1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000c22227220ULL, 0x080fe20000410000ULL,
0x0000000c23237220ULL, 0x080fe20000410000ULL, 0x0000000c26267220ULL, 0x080fe20000410000ULL,
0x0000000c27277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff12ff7812ULL, 0x000fe4000780600dULL, 0x0000000811087209ULL, 0x000fd60007810000ULL,
0x8000000811110221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL,
0x0000001100050308ULL, 0x000e640000000800ULL, 0x000000050a0a0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x000000100a0a7221ULL, 0x008fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000005ff06723eULL, 0x000fe400000000ffULL,
0x00000002ff107819ULL, 0x000fe40000011603ULL, 0x00005410060d7816ULL, 0x000fe20000000006ULL,
0x0000b8127f007947ULL, 0x000fea000b800000ULL, 0x00001f100d067589ULL, 0x0002a400000e0000ULL,
0x00000008100c7810ULL, 0x000fe20007ffe0ffULL, 0x0000b8427f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0d077589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010100c7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000dULL,
0x00007c60000f7802ULL, 0x000fc40000000f00ULL, 0x0000bcc000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018100c7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00007cb0000f7802ULL, 0x000fc40000000f00ULL,
0x0000bc7000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002020c7824ULL, 0x04cfe200078e00ffULL, 0x0000006e6d6d7212ULL, 0x000fe200078efcffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000003020d7811ULL, 0x002fc400078ff0ffULL,
0x000000040c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000086d0f7824ULL, 0x000fe400078e00ffULL,
0x000008000d0d7824ULL, 0x000fe200078e00ffULL, 0x0000000c030c7211ULL, 0x000fca00078fe0ffULL,
0x000000016d0c7824ULL, 0x000fca00078e020cULL, 0xfffffff80f0c7812ULL, 0x000fca00078ee20cULL,
0x000000100c107824ULL, 0x000fcc00078e020dULL, 0x009000001010783bULL, 0x000e620000000200ULL,
0x0000001064287824ULL, 0x100fe200078e0209ULL, 0x000090000d0d7810ULL, 0x000fe20007ffe004ULL,
0x0000001063507824ULL, 0x100fe200078e0209ULL, 0x000000006938783bULL, 0x000fe20000004200ULL,
0x00000010624c7824ULL, 0x100fe200078e0209ULL, 0x00000002ff047819ULL, 0x000fe20000011602ULL,
0x0000001065487824ULL, 0x000fe200078e0209ULL, 0x000000002828783bULL, 0x000ea20000004200ULL,
0x0000030000007a10ULL, 0x000fe40007ffe0ffULL, 0x000136a004047811ULL, 0x000fe200078e18ffULL,
0x000000005050783bULL, 0x000ee80000004200ULL, 0x000000004c4c783bULL, 0x000fe80000004200ULL,
0x000000004848783bULL, 0x000fe80000004200ULL, 0x000000000d0c783bULL, 0x000f280000000200ULL,
0x000000006840783bULL, 0x000f280000004200ULL, 0x000000006a34783bULL, 0x000f280000004200ULL,
0x000000006b30783bULL, 0x000f220000004200ULL, 0x0000000610100232ULL, 0x002fc40000000000ULL,
0x0000000612120232ULL, 0x000fe40000000000ULL, 0x0000000711110232ULL, 0x080fe40000000000ULL,
0x0000000713130232ULL, 0x000fce0000000000ULL, 0x00000028102c723cULL, 0x044ff0000000182cULL,
0x000000501014723cULL, 0x008f620000001814ULL, 0x000000060c0c0232ULL, 0x090fe40000000000ULL,
0x000000060e0e0232ULL, 0x000fc40000000000ULL, 0x000000070d0d0232ULL, 0x000fc60000000000ULL,
0x0000002a1028723cULL, 0x000f620000001844ULL, 0x000000070f0f0232ULL, 0x000fce0000000000ULL,
0x00000052103c723cULL, 0x040f70000000183cULL, 0x0000004c1018723cULL, 0x040f700000001818ULL,
0x0000004e101c723cULL, 0x040f70000000181cULL, 0x000000481020723cULL, 0x040f700000001820ULL,
0x0000004a1024723cULL, 0x000f700000001824ULL, 0x000000380c10723cULL, 0x060b700000001814ULL,
0x000000400c2c723cULL, 0x040b70000000182cULL, 0x000000420c28723cULL, 0x040b700000001828ULL,
0x0000003a0c14723cULL, 0x040b70000000183cULL, 0x000000340c18723cULL, 0x040b700000001818ULL,
0x000000360c1c723cULL, 0x040b70000000181cULL, 0x000000300c20723cULL, 0x040b700000001820ULL,
0x000000320c24723cULL, 0x000b620000001824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000660000720cULL, 0x000fe20003f06070ULL, 0x0000000004ff7f8cULL, 0x0003d8000c80043fULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff97c000007947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000e620000002500ULL, 0x000000ffff0e7224ULL, 0x020fe400078e0015ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0014ULL, 0x000000ffff157224ULL, 0x000fe400078e0013ULL,
0x000000ffff147224ULL, 0x000fe200078e0012ULL, 0x000000660300720cULL, 0x002fda0003f06070ULL,
0x0000033000000947ULL, 0x000fea0003800000ULL, 0x018000000a007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000818000067802ULL, 0x000fc40000000f00ULL, 0x0000b5f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0005ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000a00057308ULL, 0x000e640000001000ULL, 0xbf80000005007423ULL, 0x002fc8000000000aULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000005007223ULL, 0x000fc40000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000ea40000000000ULL,
0x00000002ff077819ULL, 0x004fe40000011605ULL, 0x0000000805057811ULL, 0x000fc600078ff0ffULL,
0x00001f0700047589ULL, 0x000ea800000e0000ULL, 0x00001f0500057589ULL, 0x000ee200000e0000ULL,
0x0000002c042c7220ULL, 0x044fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000001004107220ULL, 0x040fe20000410000ULL, 0x0000001104117220ULL, 0x040fe20000410000ULL,
0x0000000d040d7220ULL, 0x040fe20000410000ULL, 0x0000000e040e7220ULL, 0x040fe20000410000ULL,
0x0000001804187220ULL, 0x040fe20000410000ULL, 0x0000001904197220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x000fe20000410000ULL,
0x0000002e052e7220ULL, 0x048fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000001405147220ULL, 0x040fe20000410000ULL, 0x0000001505157220ULL, 0x040fe20000410000ULL,
0x0000001605167220ULL, 0x040fe20000410000ULL, 0x0000001705177220ULL, 0x040fe20000410000ULL,
0x0000001a051a7220ULL, 0x040fe20000410000ULL, 0x0000001b051b7220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x000fc40000410000ULL,
0x0000000000057919ULL, 0x000ea20000000000ULL, 0x00000010110c723eULL, 0x000fc400000000ffULL,
0x000000202110723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000001c1d0f723eULL, 0x000fe400000000ffULL, 0x000000141514723eULL, 0x000fe400000000ffULL,
0x000000161715723eULL, 0x000fc400000000ffULL, 0x0000001e1f17723eULL, 0x000fe400000000ffULL,
0x0000000d0e0d723eULL, 0x000fe400000000ffULL, 0x00000018190e723eULL, 0x000fe400000000ffULL,
0x000000262719723eULL, 0x000fe400000000ffULL, 0x00000002ff207819ULL, 0x004fe40000011605ULL,
0x0000001a1b16723eULL, 0x000fc400000000ffULL, 0x0000000120007810ULL, 0x040fe20007ffe0ffULL,
0x00000008201d7824ULL, 0x040fe200078e00ffULL, 0x0000000220047810ULL, 0x040fe20007ffe0ffULL,
0x00000008201f7824ULL, 0x040fe200078e00ffULL, 0x0000000520077810ULL, 0x040fe20007ffe0ffULL,
0x0000000820217824ULL, 0x040fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee200ULL,
0x00000008201c7824ULL, 0x040fe200078e00ffULL, 0x0000000320007810ULL, 0x040fe20007ffe0ffULL,
0x0000000820277824ULL, 0x040fe200078e00ffULL, 0x000000222318723eULL, 0x000fe200000000ffULL,
0x0000000820237824ULL, 0x040fe200078e00ffULL, 0x00000006201a7810ULL, 0x040fe20007ffe0ffULL,
0x00000008201b7824ULL, 0x000fe200078e00ffULL, 0x000000242511723eULL, 0x000fc400000000ffULL,
0xfffffff81f1f7812ULL, 0x000fe400078ee204ULL, 0x0000000420047810ULL, 0x000fe40007ffe0ffULL,
0xfffffff821217812ULL, 0x000fe200078ee200ULL, 0x0000100067007824ULL, 0x000fe200078e00ffULL,
0xfffffff81c257812ULL, 0x000fe200078ee207ULL, 0x000008000b077824ULL, 0x000fe200078e00ffULL,
0x0000002a2b13723eULL, 0x000fe400000000ffULL, 0xfffffff827277812ULL, 0x000fe200078ee21aULL,
0x00000004051a7824ULL, 0x040fe200078e00ffULL, 0x00000008052b7811ULL, 0x000fc400078ff0ffULL,
0xfffffff823237812ULL, 0x000fe200078ee204ULL, 0x0000000100047824ULL, 0x000fe200078e0207ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee220ULL, 0x000000082b1e7824ULL, 0x000fe200078e00ffULL,
0x000000282909723eULL, 0x000fe200000000ffULL, 0x0000000820297824ULL, 0x040fe200078e00ffULL,
0xffffffff201c7810ULL, 0x000fe20007ffe0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0204ULL,
0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0204ULL,
0xfffffff829297812ULL, 0x000fe200078ee21cULL, 0x000000101f1f7824ULL, 0x100fe200078e0204ULL,
0xfffffff81e2b7812ULL, 0x000fe200078ee22bULL, 0x0000001021217824ULL, 0x100fe200078e0204ULL,
0x0000002c2d06723eULL, 0x000fe200000000ffULL, 0x0000001023237824ULL, 0x000fe200078e0204ULL,
0x0000002e2f12723eULL, 0x000fe200000000ffULL, 0x000000011b1b7824ULL, 0x000fc400078e021aULL,
0x0000001025257824ULL, 0x100fe400078e0204ULL, 0x000000011a1c7824ULL, 0x040fe200078e021dULL,
0x000000061b007388ULL, 0x0005e20000000800ULL, 0x0000001027277824ULL, 0x100fe400078e0204ULL,
0x000000011a1f7824ULL, 0x040fe200078e021fULL, 0x000000091c007388ULL, 0x000fe20000000800ULL,
0x0000001029297824ULL, 0x100fe400078e0204ULL, 0x000000011a1e7824ULL, 0x000fe200078e0221ULL,
0x0000000c1f007388ULL, 0x000fe20000000800ULL, 0x000000102b2b7824ULL, 0x000fc400078e0204ULL,
0x000000011a237824ULL, 0x040fe200078e0223ULL, 0x0000000d1e007388ULL, 0x000fe20000000800ULL,
0x000000011a207824ULL, 0x040fe400078e0225ULL, 0x000000011a277824ULL, 0x040fe200078e0227ULL,
0x0000000e23007388ULL, 0x000fe20000000800ULL, 0x000000011a227824ULL, 0x040fe400078e0229ULL,
0x000000011a2b7824ULL, 0x000fe200078e022bULL, 0x0000000f20007388ULL, 0x000fe20000000800ULL,
0x00000001701b7824ULL, 0x004fc400078e0205ULL, 0x00000300ff217624ULL, 0x000fe200078e00ffULL,
0x0000001027007388ULL, 0x000fe20000000800ULL, 0x000000101b1a7824ULL, 0x000fc600078e0200ULL,
0x0000001122007388ULL, 0x000fe20000000800ULL, 0x000000012100780cULL, 0x000fc60003f05270ULL,
0x000000122b007388ULL, 0x000fe80000000800ULL, 0x000400131c007388ULL, 0x000fe80000000800ULL,
0x000400141f007388ULL, 0x000fe80000000800ULL, 0x000400151e007388ULL, 0x000fe80000000800ULL,
0x0004001623007388ULL, 0x000fe80000000800ULL, 0x0004001720007388ULL, 0x000fe80000000800ULL,
0x0004001827007388ULL, 0x000fe80000000800ULL, 0x0004001922007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000001a0c7984ULL, 0x000ea80000000c00ULL,
0x000400001a287984ULL, 0x000ee80000000c00ULL, 0x000800001a107984ULL, 0x000f280000000c00ULL,
0x000c00001a2c7984ULL, 0x000e620000000c00ULL, 0x200000ff0f0f7230ULL, 0x004fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff2b2b7230ULL, 0x008fe40000000000ULL,
0x200000ff2a2a7230ULL, 0x000fe40000000000ULL, 0x200000ff29297230ULL, 0x000fc40000000000ULL,
0x200000ff28287230ULL, 0x000fe40000000000ULL, 0x000000130f0f7230ULL, 0x010fe40000000000ULL,
0x000000120e0e7230ULL, 0x000fe40000000000ULL, 0x000000110d0d7230ULL, 0x000fe40000000000ULL,
0x000000100c0c7230ULL, 0x000fe40000000000ULL, 0x0000002f2b2b7230ULL, 0x002fc40000000000ULL,
0x0000002e2a2a7230ULL, 0x000fe20000000000ULL, 0x0000000c1a007388ULL, 0x000fe20000000c00ULL,
0x0000002d29297230ULL, 0x000fe40000000000ULL, 0x0000002c28287230ULL, 0x000fca0000000000ULL,
0x000400281a007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00002a7000008947ULL, 0x000fea0003800000ULL, 0x00000400ff067624ULL, 0x000fe200078e00ffULL,
0x00000000001e7919ULL, 0x000e620000002600ULL, 0x000000401b1d7810ULL, 0x000fc40007ffe0ffULL,
0x0000680006067a24ULL, 0x000fe200078e02ffULL, 0x0000000000177919ULL, 0x000e680000002700ULL,
0x0000000f06157811ULL, 0x040fe200078e10ffULL, 0x0000030006067a24ULL, 0x000fe200078e02ffULL,
0x000000001a0c7984ULL, 0x0004e40000000c00ULL, 0xfffffff015157812ULL, 0x000fe400078ec0ffULL,
0x000400001a107984ULL, 0x0004a60000000c00ULL, 0x0000008006097824ULL, 0x000fc800078e0215ULL,
0x0000008006067824ULL, 0x000fca00078e0209ULL, 0x0000007f06147810ULL, 0x000fe20007ffe0ffULL,
0x00000400171e7a24ULL, 0x002fc600078e021eULL, 0xffffff8014147812ULL, 0x000fe200078ec0ffULL,
0x000003001e067a24ULL, 0x000fc600078e02ffULL, 0x00006c0014167a10ULL, 0x000fe20007f1e0ffULL,
0x0000000106037824ULL, 0x000fc800078e0203ULL, 0x00006d00ff187624ULL, 0x000fe200000e06ffULL,
0x000000010bff7812ULL, 0x000fe4000780f802ULL, 0x0000001603167211ULL, 0x000fc800078260ffULL,
0x0000001803177211ULL, 0x000fe400008f64ffULL, 0x00006c00151f7a10ULL, 0x000fc60007f3e0ffULL,
0x0000080067167825ULL, 0x000fc800078e0016ULL, 0x00006d00ff207624ULL, 0x000fe400008e06ffULL,
0x000000101b187825ULL, 0x000fc800078e0016ULL, 0x000000101d167825ULL, 0x000fe200078e0016ULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x00000010051b7824ULL, 0x00cfe200078e00ffULL,
0x00000001ff1c7819ULL, 0x000fe20000011605ULL, 0x00000080031a7824ULL, 0x000fe200078e00ffULL,
0x00000019ff037819ULL, 0x000fe40000011603ULL, 0x000000701b1b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c1c1d7812ULL, 0x000fe400078ec0ffULL, 0x00006c001a1c7a10ULL, 0x000fc40007ebe009ULL,
0x0000001f1b1a7210ULL, 0x000fe40007a3e01aULL, 0x0000001c1d1c7210ULL, 0x000fe40007c7e01bULL,
0x00006d00031b7a10ULL, 0x000fe40002fec4ffULL, 0x0000001a1d1a7210ULL, 0x000fe40007fbe0ffULL,
0x00000020ff037210ULL, 0x000fe40000fe4403ULL, 0x0000001bff1d7210ULL, 0x000fc60001fe84ffULL,
0x000000ffff1b7224ULL, 0x000fca00028e0603ULL, 0x000000081a007986ULL, 0x0003e8000c101908ULL,
0x0000000a1c007986ULL, 0x0003e4000c101908ULL, 0x000000ff0500720cULL, 0x00cfe20000705670ULL,
0x0000000c18007986ULL, 0x000fe2000c101d08ULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x0000001016007986ULL, 0x000fe8000c101d08ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000004ff0d7424ULL, 0x000fe200078e00ffULL,
0xffffffff21037810ULL, 0x000fc60007ffe0ffULL, 0x00006c001e0c7625ULL, 0x000fe200078e000dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x000000030c0c79a8ULL, 0x000ea400099ee1c8ULL,
0x000000030c00720cULL, 0x004fc80003f05270ULL, 0x00000001ff087807ULL, 0x002fe20000000000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000008ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000ff037984ULL, 0x000ea40000000000ULL, 0x000000ff0300720cULL, 0x004fda0003f05270ULL,
0x000025f000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x000fda0003f05270ULL,
0x00000a5000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x000001b000008947ULL, 0x000fea0003800000ULL, 0x0000001005037824ULL, 0x000fe200078e00ffULL,
0x00000001ff087819ULL, 0x002fe40000011605ULL, 0x0000001f06027211ULL, 0x000fe400078038ffULL,
0x00000070030d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c08087812ULL, 0x000fe400078ec0ffULL,
0x0000002006037211ULL, 0x000fe400000f3cffULL, 0x0000000208027210ULL, 0x000fc8000791e00dULL,
0x00000003ff037210ULL, 0x000fca00007e24ffULL, 0x0000000802087981ULL, 0x000328000c1e1900ULL,
0x00008008020d7981ULL, 0x000322000c1e1900ULL, 0x000000022100780cULL, 0x000fda0003f05270ULL,
0x000000f000008947ULL, 0x000fea0003800000ULL, 0x00010008020f7981ULL, 0x002322000c1e1900ULL,
0x000000042100780cULL, 0x000fda0003f06070ULL, 0x000000c000008947ULL, 0x000fea0003800000ULL,
0x0001800802117981ULL, 0x002322000c1e1900ULL, 0x000000042100780cULL, 0x000fda0003f05270ULL,
0x0000009000008947ULL, 0x000fea0003800000ULL, 0x0002000802137981ULL, 0x002322000c1e1900ULL,
0x000000062100780cULL, 0x000fda0003f06070ULL, 0x0000006000008947ULL, 0x000fea0003800000ULL,
0x0002800802177981ULL, 0x002322000c1e1900ULL, 0x000000062100780cULL, 0x000fda0003f05270ULL,
0x0000003000008947ULL, 0x000fea0003800000ULL, 0x000000082100780cULL, 0x002fe20003f06070ULL,
0x0003000802197981ULL, 0x000318000c1e1900ULL, 0x00038008021b0981ULL, 0x000324000c1e1900ULL,
0x0000000721027810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff0a7819ULL, 0x000fc80000011602ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000007d000008947ULL, 0x000fea0003800000ULL,
0x00000015061f7211ULL, 0x040fe200078038ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1d7224ULL, 0x010fe200078e0008ULL,
0x00006c001f1f7a10ULL, 0x000fe40007f3e0ffULL, 0x000000ff060c7211ULL, 0x000fe400000f3cffULL,
0x000007801f1f7810ULL, 0x000fc80007f5e0ffULL, 0x00006d00ff0c7a10ULL, 0x000fc400017e240cULL,
0x000003000e007a0cULL, 0x000fe20003f26070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x000000040a007c0cULL, 0x000fcc000bf03070ULL, 0x000006d000001947ULL, 0x012fea0003800000ULL,
0x000000080e027810ULL, 0x040fe40007ffe0ffULL, 0x000000010e037810ULL, 0x000fe40007ffe0ffULL,
0x0000030002007a0cULL, 0x000fe40003f26070ULL, 0x0000030003007a0cULL, 0x000fe40003f46070ULL,
0x0000001d08087209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001005027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011605ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x000000021f027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e060cULL,
0xfffc8008021d7981ULL, 0x000326000c1e1900ULL, 0x000005f000002947ULL, 0x000fea0003800000ULL,
0x000000090e027810ULL, 0x042fe40007ffe0ffULL, 0x000000020e037810ULL, 0x000fe40007ffe0ffULL,
0x0000030002007a0cULL, 0x000fe40003f26070ULL, 0x0000030003007a0cULL, 0x000fe40003f46070ULL,
0x0000000d08087209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001005027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011605ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x000000021f027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e060cULL,
0xfffd0008020d7981ULL, 0x000326000c1e1900ULL, 0x0000051000002947ULL, 0x000fea0003800000ULL,
0x0000000a0e027810ULL, 0x042fe40007ffe0ffULL, 0x000000030e037810ULL, 0x000fe40007ffe0ffULL,
0x0000030002007a0cULL, 0x000fe40003f26070ULL, 0x0000030003007a0cULL, 0x000fe40003f46070ULL,
0x0000000f08087209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001005027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011605ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x000000021f027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e060cULL,
0xfffd8008020f7981ULL, 0x000326000c1e1900ULL, 0x0000043000002947ULL, 0x000fea0003800000ULL,
0x0000000b0e027810ULL, 0x042fe40007ffe0ffULL, 0x000000040e037810ULL, 0x000fe40007ffe0ffULL,
0x0000030002007a0cULL, 0x000fe40003f26070ULL, 0x0000030003007a0cULL, 0x000fe40003f46070ULL,
0x0000001108087209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001005027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011605ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x000000021f027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e060cULL,
0xfffe000802117981ULL, 0x000326000c1e1900ULL, 0x0000035000002947ULL, 0x000fea0003800000ULL,
0x0000000c0e027810ULL, 0x042fe40007ffe0ffULL, 0x000000050e037810ULL, 0x000fe40007ffe0ffULL,
0x0000030002007a0cULL, 0x000fe40003f26070ULL, 0x0000030003007a0cULL, 0x000fe40003f46070ULL,
0x0000001308087209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001005027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011605ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x000000021f027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e060cULL,
0xfffe800802137981ULL, 0x000326000c1e1900ULL, 0x0000027000002947ULL, 0x000fea0003800000ULL,
0x0000000d0e027810ULL, 0x042fe40007ffe0ffULL, 0x000000060e037810ULL, 0x000fe40007ffe0ffULL,
0x0000030002007a0cULL, 0x000fe40003f26070ULL, 0x0000030003007a0cULL, 0x000fe40003f46070ULL,
0x0000001708087209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001005027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011605ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x000000021f027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e060cULL,
0xffff000802177981ULL, 0x000326000c1e1900ULL, 0x0000019000002947ULL, 0x000fea0003800000ULL,
0x0000000e0e027810ULL, 0x042fe40007ffe0ffULL, 0x000000070e037810ULL, 0x000fe40007ffe0ffULL,
0x0000030002007a0cULL, 0x000fe40003f26070ULL, 0x0000030003007a0cULL, 0x000fe40003f46070ULL,
0x0000001908087209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001005027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011605ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x000000021f027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e060cULL,
0xffff800802197981ULL, 0x000326000c1e1900ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000000f0e027810ULL, 0x002fe40007ffe0ffULL, 0x0000001b08087209ULL, 0x000fe40007810000ULL,
0x0000030002007a0cULL, 0x000fda0003f26070ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001005027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011605ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x000000021f027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e060cULL,
0x00000008021b7981ULL, 0x000326000c1e1900ULL, 0x000004001f1f7810ULL, 0x000fe40007f3e0ffULL,
0x000000080e0e7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200008e060cULL,
0xfffff8b000008947ULL, 0x000fea000383ffffULL, 0x0000000000057919ULL, 0x000ea40000000000ULL,
0x0000001005027824ULL, 0x006fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011605ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fca00078ec0ffULL,
0x0000000102037824ULL, 0x000fca00078e0203ULL, 0x0000000803007388ULL, 0x0103e40000000800ULL,
0x00006c0014027a10ULL, 0x000fe20007f3e0ffULL, 0x000000010b197824ULL, 0x000fe200078e0206ULL,
0x000000070500780cULL, 0x000fe20003f04070ULL, 0x00000800670a7824ULL, 0x002fe200078e00ffULL,
0x000000010b087812ULL, 0x000fe200078ec0ffULL, 0x00006d00ff037624ULL, 0x000fe200008e06ffULL,
0x00006c0015157a10ULL, 0x000fe20007f5e0ffULL, 0x000020000b147824ULL, 0x000fe200078e0200ULL,
0x0000004005137810ULL, 0x000fe20007ffe0ffULL, 0x00001000190c7825ULL, 0x000fe200078e0002ULL,
0x0000006005177810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000020b0f8824ULL, 0x140fe200078e0267ULL, 0x0000000a0c0c7210ULL, 0x000fe20007f3e0ffULL,
0x000000020b118824ULL, 0x000fe200078e0267ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x000000020f1c8824ULL, 0x100fe200078e0208ULL, 0x00000800070f7812ULL, 0x000fe200078ec0ffULL,
0x00000002111e8824ULL, 0x000fe200078e0208ULL, 0x0000002005117810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x00006c0009077a10ULL, 0x000fe20007f3e0ffULL,
0x0000001005087824ULL, 0x040fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011605ULL,
0x00000001140e7824ULL, 0x000fe200078e020fULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00006d00ff167624ULL, 0x000fe200008e06ffULL, 0x0000007008087812ULL, 0x000fe200078ec0ffULL,
0x00000010051f7824ULL, 0x000fe200078e020eULL, 0x0000000c09097812ULL, 0x000fe200078ec0ffULL,
0x00006d00ff187624ULL, 0x000fe200010e06ffULL, 0x0000000719228211ULL, 0x000fe200078238ffULL,
0x00000010110e7825ULL, 0x100fe200078e000cULL, 0x00000015191a8211ULL, 0x040fe200078438ffULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000001619238211ULL, 0x000fe200008f3cffULL,
0x0000001013107825ULL, 0x000fe200078e000cULL, 0x000003000b007a0cULL, 0x000fe20003f26070ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000018191b8211ULL, 0x000fe200010f3cffULL,
0x00000001081d7824ULL, 0x000fe200078e0209ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000001017127825ULL, 0x100fe200078e000cULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000000001d177984ULL, 0x0002a20000000800ULL,
0x00000010050c7825ULL, 0x000fe200078e000cULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fc4000001ff00ULL, 0x000000081c1c8824ULL, 0x100fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c1f7faeULL, 0x0007e2000b901c48ULL,
0x000000081e1e8824ULL, 0x000fe400078e0205ULL, 0x0000001005228825ULL, 0x000fe200078e0022ULL,
0x000045801c258811ULL, 0x000fe200078e20ffULL, 0x003800000e1f7faeULL, 0x0009e2000b901c48ULL,
0x000041801e278811ULL, 0x000fe200078e20ffULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x002fe2000001ff00ULL, 0x00580000101f7faeULL, 0x0009e2000b901c48ULL,
0x000000ffff387224ULL, 0x000fc400078e00ffULL, 0x00000010050c8825ULL, 0x008fe200078e001aULL,
0x00780000121f7faeULL, 0x0009e2000b901c48ULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0x000000ffff3a7224ULL, 0x000fe200078e00ffULL, 0x0000000022258faeULL, 0x0003e8000b901c48ULL,
0x000000000c278faeULL, 0x0007e8000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000001e7805ULL, 0x010fe2000001ff00ULL, 0x0000000000227805ULL, 0x002fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x008fe2000001ff00ULL,
0x00000c6000001947ULL, 0x000fea0003800000ULL, 0x000000ffff197224ULL, 0x004fe400078e00ffULL,
0x000000ffff397224ULL, 0x000fca00078e000bULL, 0x00000001390d7810ULL, 0x000fc80007ffe0ffULL,
0x000003000d007a0cULL, 0x000fda0003f06070ULL, 0x0000028000000947ULL, 0x000fea0003800000ULL,
0x000000070500780cULL, 0x000fe20003f44070ULL, 0x00000001063f7824ULL, 0x000fe200078e020dULL,
0x000000010d0c7812ULL, 0x000fe400078ec0ffULL, 0x0000004005137810ULL, 0x000fe20007ffe0ffULL,
0x000010003f087825ULL, 0x000fca00078e0002ULL, 0x0000000a080e7210ULL, 0x000fe20007f1e0ffULL,
0x000008000d087824ULL, 0x000fe400078e00ffULL, 0x000000020b0fa824ULL, 0x140fe400078e0267ULL,
0x000000020b11a824ULL, 0x000fe400078e0267ULL, 0x000000020f3ea824ULL, 0x100fe400078e020cULL,
0x000000ffff0f7224ULL, 0x000fe200000e0609ULL, 0x0000080008097812ULL, 0x000fe200078ec0ffULL,
0x000000021140a824ULL, 0x000fe200078e020cULL, 0x0000002005117810ULL, 0x040fe20007ffe0ffULL,
0x00000010053c7825ULL, 0x000fe200078e000eULL, 0x000000073f0ca211ULL, 0x000fc400078038ffULL,
0x000000153f08a211ULL, 0x000fe200078238ffULL, 0x0000000114107824ULL, 0x000fe200078e0209ULL,
0x0000006005097810ULL, 0x000fe20007ffe0ffULL, 0x0000001013127825ULL, 0x000fe200078e000eULL,
0x000000163f0da211ULL, 0x000fc600000f3cffULL, 0x00000010053b7824ULL, 0x000fe400078e0210ULL,
0x0000001011107825ULL, 0x000fc600078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800003c3b7faeULL, 0x0003e2000b901c48ULL, 0x00000010090e7825ULL, 0x000fe200078e000eULL,
0x000000183f09a211ULL, 0x000fe400008f3cffULL, 0x00380000103b7faeULL, 0x0003e2000b901c48ULL,
0x000000083e3ea824ULL, 0x100fe400078e0205ULL, 0x000000084040a824ULL, 0x000fe200078e0205ULL,
0x00580000123b7faeULL, 0x0003e2000b901c48ULL, 0x00000010050ca825ULL, 0x000fe200078e000cULL,
0x000045803e3fa811ULL, 0x000fc400078e20ffULL, 0x000041804041a811ULL, 0x000fe200078e20ffULL,
0x000000100508a825ULL, 0x000fe200078e0008ULL, 0x007800000e3b7faeULL, 0x0003e8000b901c48ULL,
0x000000000c3fafaeULL, 0x0003e8000b901c48ULL, 0x000000000841afaeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000008039087824ULL, 0x002fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fe20000011605ULL, 0x000000020b0d7824ULL, 0x000fe200078e0267ULL,
0x00000002ff447819ULL, 0x000fe20000011605ULL, 0x0000001005097824ULL, 0x000fe200078e00ffULL,
0x0000008008087812ULL, 0x000fc400078ec0ffULL, 0x0000000844487810ULL, 0x040fe20007ffe0ffULL,
0x0000000844127824ULL, 0x040fe200078e00ffULL, 0x00000002440f7810ULL, 0x040fe20007ffe0ffULL,
0x000001000d0c7824ULL, 0x000fe200078e0008ULL, 0x0000007009087812ULL, 0x000fe200078ec0ffULL,
0x00000008443e7824ULL, 0x000fe200078e00ffULL, 0x0000000c0e097812ULL, 0x000fe200078ec0ffULL,
0x0000000844427824ULL, 0x040fe200078e00ffULL, 0x00000001440d7810ULL, 0x040fe20007ffe0ffULL,
0x00000008444a7824ULL, 0x000fe200078e00ffULL, 0x0000000c090e7210ULL, 0x000fe20007ffe008ULL,
0x00000800390c7824ULL, 0x000fe200078e00ffULL, 0xfffffff812117812ULL, 0x000fe200078ee20dULL,
0x00000008443f7824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3b7812ULL, 0x000fe200078ee20fULL,
0x00000008440f7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x004180000e107984ULL, 0x000e620000000800ULL, 0x000008000c0d7812ULL, 0x000fe200078ec0ffULL,
0x00000004050c7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee244ULL,
0x004580000e3c7984ULL, 0x0004e20000000800ULL, 0x00000003443d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000c0c467812ULL, 0x000fe400078ec0ffULL, 0xfffffff8423d7812ULL, 0x000fe400078ee23dULL,
0x00000004443e7810ULL, 0x000fc40007ffe0ffULL, 0x00000180140e7810ULL, 0x004fe20007ffe00dULL,
0x00000008480d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe400078ee23eULL,
0xffffffff443e7810ULL, 0x000fe20007ffe0ffULL, 0x000000100f0c7824ULL, 0x000fe200078e020eULL,
0xfffffff80d0d7812ULL, 0x000fe400078ee248ULL, 0x0000000239397810ULL, 0x000fe20007ffe0ffULL,
0x00000001460c7824ULL, 0x000fe400078e020cULL, 0x000000100d0d7824ULL, 0x000fe200078e020eULL,
0x0000030039007a0cULL, 0x000fc40003f06070ULL, 0x000000000c0f7984ULL, 0x000fe20000000800ULL,
0x0000000146127824ULL, 0x000fe400078e020dULL, 0x00000010110d7824ULL, 0x100fe200078e020eULL,
0x0000000544117810ULL, 0x000fe40007ffe0ffULL, 0x0000000012407984ULL, 0x000ea20000000800ULL,
0x00000001460d7824ULL, 0x000fe200078e020dULL, 0xfffffff84a437812ULL, 0x000fe200078ee211ULL,
0x000000103b117824ULL, 0x000fe200078e020eULL, 0x00000006443b7810ULL, 0x000fc40007ffe0ffULL,
0x000400000d417984ULL, 0x000fe20000000800ULL, 0x0000001017107221ULL, 0x002fe20000010100ULL,
0x0000000146117824ULL, 0x000fc600078e0211ULL, 0x3fb8aa3b10107820ULL, 0x000fe40000410000ULL,
0x0000000011127984ULL, 0x000fe40000000800ULL, 0x0000001000137308ULL, 0x0002e40000000800ULL,
0x0004000011427984ULL, 0x000fe80000000800ULL, 0x000000000d107984ULL, 0x002fe20000000800ULL,
0x0000003c13457220ULL, 0x008fe20000410000ULL, 0x00000008443c7824ULL, 0x000fc400078e00ffULL,
0x000000103d137824ULL, 0x000fe200078e020eULL, 0x0000003a453a7221ULL, 0x000fe20000010000ULL,
0x00001f44450c7589ULL, 0x000e6200000e0000ULL, 0x00000008443d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c477812ULL, 0x000fe200078ee23bULL, 0x0000000146137824ULL, 0x040fe200078e0213ULL,
0x00001f48450d7589ULL, 0x00072200000e0000ULL, 0x000000103f3c7824ULL, 0x000fe200078e020eULL,
0xfffffff83d3f7812ULL, 0x000fe200078ee23eULL, 0x00000010433d7824ULL, 0x000fe200078e020eULL,
0x00000000133b7984ULL, 0x000f220000000800ULL, 0x00000001463c7824ULL, 0x000fc400078e023cULL,
0x00000010473e7824ULL, 0x100fe200078e020eULL, 0x0004000013437984ULL, 0x000fe20000000800ULL,
0x000000103f3f7824ULL, 0x000fe400078e020eULL, 0x00000001463d7824ULL, 0x000fe200078e023dULL,
0x000000003c0e7984ULL, 0x000f220000000800ULL, 0x20000040ff477230ULL, 0x104fe40000004100ULL,
0x3000000fff457230ULL, 0x008fe20000004100ULL, 0x000400003c447984ULL, 0x000ea20000000800ULL,
0x30000040ff407230ULL, 0x000fc40000004100ULL, 0x2000000fff117230ULL, 0x000fe20000004100ULL,
0x0000000c45307223ULL, 0x082fe20000010030ULL, 0x00000001463e7824ULL, 0x040fe200078e023eULL,
0x000000003d0f7984ULL, 0x000e620000000800ULL, 0x00000001463f7824ULL, 0x000fe200078e023fULL,
0x0000000d402f7223ULL, 0x090fe2000001002fULL, 0x20000010ff407230ULL, 0x100fe20000004100ULL,
0x0000000c111a7223ULL, 0x080fe2000001001aULL, 0x30000010ff457230ULL, 0x000fe20000004100ULL,
0x000400003d137984ULL, 0x000ee20000000800ULL, 0x20000041ff107230ULL, 0x100fe20000004100ULL,
0x0000000c401f7223ULL, 0x080fe2000001001fULL, 0x30000041ff417230ULL, 0x000fe20000004100ULL,
0x000400003e3c7984ULL, 0x000f220000000800ULL, 0x20000012ff407230ULL, 0x100fe20000004100ULL,
0x0000000d102d7223ULL, 0x080fe2000001002dULL, 0x0000000c452e7223ULL, 0x080fe2000001002eULL,
0x000000003e117984ULL, 0x000f220000000800ULL, 0x0000000d412c7223ULL, 0x080fe2000001002cULL,
0x30000012ff417230ULL, 0x000fe20000004100ULL, 0x0000000d47227223ULL, 0x080fe20000010022ULL,
0x000000003f107984ULL, 0x000f220000000800ULL, 0x20000042ff457230ULL, 0x100fe20000004100ULL,
0x0000000c402b7223ULL, 0x080fe2000001002bULL, 0x30000042ff427230ULL, 0x000fe20000004100ULL,
0x000400003f3d7984ULL, 0x0005220000000800ULL, 0x2000003bff127230ULL, 0x100fe20000004100ULL,
0x0000000c41387223ULL, 0x080fe20000010038ULL, 0x3000003bff3b7230ULL, 0x000fe20000004100ULL,
0x0000000d452a7223ULL, 0x080fe2000001002aULL, 0x0000000d42297223ULL, 0x000fe20000010029ULL,
0x0000000c12377223ULL, 0x080fe20000010037ULL, 0x2000000eff127230ULL, 0x100fe20000004100ULL,
0x0000000c3b367223ULL, 0x000fe20000010036ULL, 0x3000000eff0e7230ULL, 0x000fc40000004100ULL,
0x20000043ff3f7230ULL, 0x104fe20000004100ULL, 0x0000000c12277223ULL, 0x080fe20000010027ULL,
0x20000044ff127230ULL, 0x100fe20000004100ULL, 0x0000000c0e257223ULL, 0x080fe20000010025ULL,
0x30000043ff437230ULL, 0x000fe20000004100ULL, 0x0000000d3f267223ULL, 0x080fe20000010026ULL,
0x3000000fff0e7230ULL, 0x102fe20000004100ULL, 0x0000000d12357223ULL, 0x080fe20000010035ULL,
0x2000000fff3b7230ULL, 0x000fe20000004100ULL, 0x0000000d43287223ULL, 0x080fe20000010028ULL,
0x30000044ff3f7230ULL, 0x000fe20000004100ULL, 0x0000000c0e237223ULL, 0x080fe20000010023ULL,
0x20000013ff127230ULL, 0x108fe20000004100ULL, 0x0000000c3b247223ULL, 0x080fe20000010024ULL,
0x30000013ff137230ULL, 0x000fe20000004100ULL, 0x0000000d3f347223ULL, 0x080fe20000010034ULL,
0x2000003cff0f7230ULL, 0x110fe20000004100ULL, 0x0000000d12337223ULL, 0x080fe20000010033ULL,
0x3000003cff3c7230ULL, 0x000fe20000004100ULL, 0x0000000d13327223ULL, 0x080fe20000010032ULL,
0x20000011ff0e7230ULL, 0x100fe20000004100ULL, 0x0000000d0f207223ULL, 0x080fe20000010020ULL,
0x30000011ff127230ULL, 0x000fe20000004100ULL, 0x0000000d3c317223ULL, 0x000fe20000010031ULL,
0x20000010ff0f7230ULL, 0x100fe20000004100ULL, 0x0000000c0e1b7223ULL, 0x080fe2000001001bULL,
0x30000010ff107230ULL, 0x000fe20000004100ULL, 0x0000000c12217223ULL, 0x080fe20000010021ULL,
0x2000003dff117230ULL, 0x100fe20000004100ULL, 0x0000000c0f1e7223ULL, 0x080fe2000001001eULL,
0x3000003dff0e7230ULL, 0x000fe20000004100ULL, 0x0000000c101d7223ULL, 0x000fc4000001001dULL,
0x0000000d111c7223ULL, 0x080fe4000001001cULL, 0x0000000d0e197223ULL, 0x000fe20000010019ULL,
0xfffff3c000008947ULL, 0x000fea000383ffffULL, 0x000000ff6700720cULL, 0x004fe20003f05270ULL,
0x0000018000007945ULL, 0x000fd80003800000ULL, 0x000000800b028824ULL, 0x000fe400078e0208ULL,
0x0000000108087824ULL, 0x000fe400078e0209ULL, 0x0000000109038824ULL, 0x000fca00078e0202ULL,
0x0049803a03008388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0049800008027984ULL, 0x000e680000000800ULL, 0x004a000008057984ULL, 0x000ea20000000800ULL,
0x00000002ff027221ULL, 0x002fc80000010000ULL, 0x0000000502027221ULL, 0x004fca0000010000ULL,
0x0180000002057810ULL, 0x000fc80007ffe0ffULL, 0x7f80000005057812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0500780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e0002ULL,
0x0000ac8000067802ULL, 0x000fc40000000f00ULL, 0x00008af000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff037224ULL, 0x00cfe200078e0005ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000200037308ULL, 0x000e640000001000ULL, 0xbf80000002057423ULL, 0x002fc80000000003ULL,
0x800000ff05067221ULL, 0x000fc80000010100ULL, 0x0000000603037223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff0a7819ULL, 0x006fc40000011605ULL,
0x00000008050c7811ULL, 0x000fe400078ff0ffULL, 0x000000020a0d7810ULL, 0x040fe20007ffe0ffULL,
0x00001f0a03027589ULL, 0x000e6200000e0000ULL, 0x000000080a0f7824ULL, 0x040fe200078e00ffULL,
0x000000030a0e7810ULL, 0x040fe20007ffe0ffULL, 0x000000080a127824ULL, 0x040fe200078e00ffULL,
0x00001f0c03097589ULL, 0x000ea200000e0000ULL, 0x000000080a137824ULL, 0x040fe200078e00ffULL,
0x000000040a107810ULL, 0x040fe20007ffe0ffULL, 0x000000080a157824ULL, 0x000fe200078e00ffULL,
0xfffffff812117812ULL, 0x000fe200078ee20dULL, 0x000000080a177824ULL, 0x040fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee20eULL, 0x000000080a0d7824ULL, 0x040fe200078e00ffULL,
0xfffffff815157812ULL, 0x000fe200078ee210ULL, 0x0000001011117824ULL, 0x100fe200078e0204ULL,
0x000000060a0e7810ULL, 0x040fe20007ffe0ffULL, 0x0000001013137824ULL, 0x100fe200078e0204ULL,
0xffffffff0a107810ULL, 0x000fe20007ffe0ffULL, 0x0000001015157824ULL, 0x000fe200078e0204ULL,
0xfffffff80d0d7812ULL, 0x000fca00078ee20aULL, 0x000000100d0d7824ULL, 0x000fe200078e0204ULL,
0x0000001a021a7220ULL, 0x042fe20000410000ULL, 0x0000003002077220ULL, 0x040fe20000410000ULL,
0x0000001f021f7220ULL, 0x040fe20000410000ULL, 0x0000002e022e7220ULL, 0x040fe20000410000ULL,
0x0000002b022b7220ULL, 0x040fe20000410000ULL, 0x0000003802387220ULL, 0x040fe20000410000ULL,
0x0000003702377220ULL, 0x040fe20000410000ULL, 0x0000003602367220ULL, 0x040fe20000410000ULL,
0x0000002702277220ULL, 0x040fe20000410000ULL, 0x0000002502067220ULL, 0x040fe20000410000ULL,
0x0000002402247220ULL, 0x040fe20000410000ULL, 0x0000002302237220ULL, 0x040fe20000410000ULL,
0x0000001b021b7220ULL, 0x040fe20000410000ULL, 0x0000002102087220ULL, 0x040fe20000410000ULL,
0x0000001e021e7220ULL, 0x040fe20000410000ULL, 0x0000001d021d7220ULL, 0x000fe20000410000ULL,
0x000000010a027810ULL, 0x040fe20007ffe0ffULL, 0x0000002209227220ULL, 0x044fe20000410000ULL,
0x0000002f092f7220ULL, 0x040fe20000410000ULL, 0x0000002d092d7220ULL, 0x000fe20000410000ULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee202ULL, 0x0000002c092c7220ULL, 0x040fe20000410000ULL,
0x000000050a027810ULL, 0x040fe20007ffe0ffULL, 0x0000002a092a7220ULL, 0x040fe20000410000ULL,
0x0000002909297220ULL, 0x040fe20000410000ULL, 0x0000002609267220ULL, 0x040fe20000410000ULL,
0x0000002809037220ULL, 0x040fe20000410000ULL, 0x0000003509357220ULL, 0x040fe20000410000ULL,
0x0000003409347220ULL, 0x040fe20000410000ULL, 0x0000003309337220ULL, 0x040fe20000410000ULL,
0x0000003209327220ULL, 0x040fe20000410000ULL, 0x0000002009207220ULL, 0x040fe20000410000ULL,
0x0000003109317220ULL, 0x040fe20000410000ULL, 0x0000001c091c7220ULL, 0x040fe20000410000ULL,
0x0000001909097220ULL, 0x000fe20000410000ULL, 0x000000080a197824ULL, 0x040fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee202ULL, 0x000000080a217824ULL, 0x000fe200078e00ffULL,
0x000000270606723eULL, 0x000fe200000000ffULL, 0x000000080c257824ULL, 0x000fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fe200078ee20eULL, 0x0000000405027824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee210ULL, 0x000000100f0f7824ULL, 0x000fe200078e0204ULL,
0xfffffff825257812ULL, 0x000fe200078ee20cULL, 0x0000001017177824ULL, 0x100fe200078e0204ULL,
0x0000000c02027812ULL, 0x000fe200078ec0ffULL, 0x0000001019197824ULL, 0x100fe200078e0204ULL,
0x0000001b0808723eULL, 0x000fe200000000ffULL, 0x00000010211b7824ULL, 0x100fe200078e0204ULL,
0x0000001a0707723eULL, 0x000fe200000000ffULL, 0x0000001025277824ULL, 0x000fe200078e0204ULL,
0x0000001f2e1f723eULL, 0x000fe200000000ffULL, 0x000000010d047824ULL, 0x000fe200078e0202ULL,
0x0000002b382b723eULL, 0x000fe200000000ffULL, 0x00000001020a7824ULL, 0x040fe200078e020fULL,
0x0000001c0909723eULL, 0x000fe200000000ffULL, 0x0000000102147824ULL, 0x000fe200078e0211ULL,
0x000000373636723eULL, 0x000fe200000000ffULL, 0x00000001021c7824ULL, 0x040fe200078e0213ULL,
0x0000001e1d1d723eULL, 0x000fe200000000ffULL, 0x0000000102217824ULL, 0x040fe200078e0215ULL,
0x000000242323723eULL, 0x000fe200000000ffULL, 0x00000001021e7824ULL, 0x040fe200078e0217ULL,
0x0000000704007388ULL, 0x0003e20000000800ULL, 0x0000000102257824ULL, 0x040fe200078e0219ULL,
0x000000222f22723eULL, 0x000fe200000000ffULL, 0x0000000102247824ULL, 0x040fe200078e021bULL,
0x0000001f0a007388ULL, 0x000fe20000000800ULL, 0x0000000102277824ULL, 0x000fe200078e0227ULL,
0x0000002d2c2c723eULL, 0x000fc400000000ffULL, 0x0000002b14007388ULL, 0x000fe20000000800ULL,
0x0000002a2929723eULL, 0x000fe200000000ffULL, 0x0000000170077824ULL, 0x002fe200078e0205ULL,
0x000000260303723eULL, 0x000fe200000000ffULL, 0x000000361c007388ULL, 0x000fe20000000800ULL,
0x000000353434723eULL, 0x000fe200000000ffULL, 0x0000001007077824ULL, 0x000fe200078e0200ULL,
0x000000333232723eULL, 0x000fe200000000ffULL, 0x0000000621007388ULL, 0x000fe20000000800ULL,
0x000000203120723eULL, 0x000fc600000000ffULL, 0x000000231e007388ULL, 0x000fe80000000800ULL,
0x0000000825007388ULL, 0x000fe80000000800ULL, 0x0000001d24007388ULL, 0x000fe80000000800ULL,
0x0000002227007388ULL, 0x000fe80000000800ULL, 0x0004002c0a007388ULL, 0x000fe80000000800ULL,
0x0004002914007388ULL, 0x000fe80000000800ULL, 0x000400031c007388ULL, 0x000fe80000000800ULL,
0x0004003421007388ULL, 0x000fe80000000800ULL, 0x000400321e007388ULL, 0x000fe80000000800ULL,
0x0004002025007388ULL, 0x000fe80000000800ULL, 0x0004000924007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000070c7984ULL, 0x000e680000000c00ULL,
0x0004000007147984ULL, 0x000ea80000000c00ULL, 0x0008000007107984ULL, 0x000ee80000000c00ULL,
0x000c000007187984ULL, 0x000f220000000c00ULL, 0x200000ff0f0f7230ULL, 0x002fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x004fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x000000130f0f7230ULL, 0x008fe40000000000ULL,
0x000000120e0e7230ULL, 0x000fe40000000000ULL, 0x000000110d0d7230ULL, 0x000fe40000000000ULL,
0x000000100c0c7230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x010fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000c07007388ULL, 0x000fe20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001407007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x000fc80000011605ULL, 0x000000740200720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x0000000102037824ULL, 0x000fe200078e0205ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x0000001075027824ULL, 0x000fe200078e0202ULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x00005a0073737a19ULL, 0x000fe200000006ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x0000000703047812ULL, 0x000fe400078ec0ffULL, 0x0000580000067ab9ULL, 0x000fe20000000800ULL,
0x00000020050d7810ULL, 0x000fc40007ffe0ffULL, 0x0ffffff804037812ULL, 0x000fe400078ef805ULL,
0x0000000502047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff027a19ULL, 0x000fe20000011602ULL,
0x0000001003037824ULL, 0x000fe200078e0200ULL, 0x00000007050c7812ULL, 0x000fe200078ec0ffULL,
0x0000000173067824ULL, 0x000fc600078e0204ULL, 0x0000000003087984ULL, 0x0022e20000000c00ULL,
0x0000007902077224ULL, 0x000fe200078e0206ULL, 0x00000006040472a4ULL, 0x004fcc000f8e023fULL,
0x0000000479047c24ULL, 0x000fca000f8e02ffULL, 0x0000000704077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x00005c0007027a11ULL, 0x000fc800078040ffULL,
0x00005d0007037a11ULL, 0x002fe200000f4406ULL, 0x0000000867077824ULL, 0x000fe200078e020cULL,
0x00000003ff067819ULL, 0x000fc6000001160dULL, 0x0000001007027825ULL, 0x000fe200078e0002ULL,
0x000000740600720cULL, 0x000fc80003f06070ULL, 0x0000000802007986ULL, 0x0083f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d027824ULL, 0x102fe200078e0206ULL,
0x00000040050f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001075067824ULL, 0x000fc600078e0206ULL,
0x0000000702027812ULL, 0x000fc800078ec0ffULL, 0x0ffffff802037812ULL, 0x000fe400078ef80dULL,
0x0000000506027c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff067a19ULL, 0x000fe20000011606ULL,
0x0000001003077824ULL, 0x000fe400078e0200ULL, 0x0000000173027824ULL, 0x000fc600078e0202ULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000007906037224ULL, 0x000fe200078e0202ULL,
0x000000070d067812ULL, 0x000fc800078ec0ffULL, 0x0000000304037210ULL, 0x000fe20007f1e0ffULL,
0x0000000867077824ULL, 0x002fc800078e0206ULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fe400000f440cULL,
0x00000003ff0c7819ULL, 0x000fc6000001160fULL, 0x0000001007027825ULL, 0x000fe200078e0002ULL,
0x000000740c00720cULL, 0x000fc80003f06070ULL, 0x0000000802007986ULL, 0x0043f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010f027824ULL, 0x102fe200078e020cULL,
0x00000060050d7810ULL, 0x000fe20007ffe0ffULL, 0x00000010750c7824ULL, 0x000fc600078e020cULL,
0x0000000702027812ULL, 0x000fc800078ec0ffULL, 0x0ffffff802037812ULL, 0x000fe400078ef80fULL,
0x000000050c027c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0c7a19ULL, 0x000fe2000001160cULL,
0x0000001003067824ULL, 0x000fe400078e0200ULL, 0x0000000173027824ULL, 0x000fc600078e0202ULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x000000790c037224ULL, 0x000fe200078e0202ULL,
0x000000070f0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000304037210ULL, 0x000fe20007f1e0ffULL,
0x0000000867057824ULL, 0x000fe200078e020cULL, 0x00000003ff067819ULL, 0x002fc6000001160dULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fe200078040ffULL,
0x000000010d077824ULL, 0x000fc600078e0206ULL, 0x00005d0003037a11ULL, 0x000fe400000f440eULL,
0x000000740600720cULL, 0x000fe40003f06070ULL, 0x0000000707077812ULL, 0x000fe200078ec0ffULL,
0x0000001005027825ULL, 0x000fc600078e0002ULL, 0xfffffff807077812ULL, 0x000fe400078ef80dULL,
0x0000000802007986ULL, 0x0043ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001007077824ULL, 0x000fe400078e0200ULL, 0x0000001075067824ULL, 0x000fc600078e0206ULL,
0x0000000007087984ULL, 0x002e640000000c00ULL, 0x0000000506007c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff067a19ULL, 0x000fc60000011606ULL, 0x0000000173007824ULL, 0x000fc800078e0200ULL,
0x0000007906797224ULL, 0x000fe200078e0200ULL, 0x000000070d007812ULL, 0x000fc800078ec0ffULL,
0x0000007904797210ULL, 0x000fe20007f1e0ffULL, 0x0000000867677824ULL, 0x000fc800078e0200ULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005c0079027a11ULL, 0x000fc800078040ffULL,
0x00005d0079037a11ULL, 0x000fca00000f4404ULL, 0x0000001067027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000100057810ULL, 0x000fe20007ffe0ffULL,
0x000000020d687824ULL, 0x000fe200078e00ffULL, 0x01360000ff067f8cULL, 0x002e62000c80043fULL,
0x0000004002707824ULL, 0x000fe200078e00ffULL, 0x000000660500720cULL, 0x000fe20003f06070ULL,
0x0000590068687a24ULL, 0x000fe400078e0273ULL, 0x00000100000f7824ULL, 0x000fc800078e0270ULL,
0x0000660068227a24ULL, 0x000fcc00078e020fULL, 0x0000060000008947ULL, 0x000fea0003800000ULL,
0x00000002ff207819ULL, 0x000fe40000011603ULL, 0x0000000f5c057217ULL, 0x000fe40007800000ULL,
0x0000001020197810ULL, 0x000fe20007ffe0ffULL, 0x0000000122087824ULL, 0x000fe200078e0220ULL,
0x0000000820157810ULL, 0x040fe20007ffe0ffULL, 0x0000000105057824ULL, 0x000fe200078e0a0fULL,
0x00000018201b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001220c7824ULL, 0x000fe200078e0219ULL,
0x00000020201c7810ULL, 0x000fe20007ffe0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000303187211ULL, 0x000fc400078fe8ffULL, 0x00001000021a7811ULL, 0x000fe200078e68ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000003008107812ULL, 0x100fe400078ef804ULL,
0x0000000318187812ULL, 0x000fe200078ec0ffULL, 0x00000001220a7824ULL, 0x000fe200078e0215ULL,
0x000000300c087812ULL, 0x000fe200078ef804ULL, 0x00000001220e7824ULL, 0x000fe200078e021bULL,
0x0000620010107a10ULL, 0x000fe20007f1e0ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000620008087a10ULL, 0x000fc40007f3e0ffULL, 0x0000630009117a10ULL, 0x000fe200007fe4ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x000000300a127812ULL, 0x000fe400078ef804ULL,
0x000063000d097a10ULL, 0x000fe20000ffe4ffULL, 0x00000001220c7824ULL, 0x000fe200078e021cULL,
0x000000300e0a7812ULL, 0x000fe400078ef804ULL, 0x0000620012127a10ULL, 0x000fe20007f1e0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x000062000a0a7a10ULL, 0x000fc40007f5e0ffULL,
0x00000028200e7810ULL, 0x000fe40007ffe0ffULL, 0x000000300c147812ULL, 0x000fe400078ef804ULL,
0x000063000b137a10ULL, 0x000fe200007fe4ffULL, 0x00000001220c7824ULL, 0x000fe200078e020eULL,
0x000063000f0b7a10ULL, 0x000fe200017fe4ffULL, 0x00000004150f7824ULL, 0x040fe200078e00ffULL,
0x0000620014147a10ULL, 0x000fe40007f5e0ffULL, 0x000000051500720cULL, 0x000fc40003f26070ULL,
0x000000052000720cULL, 0x000fe40003f06070ULL, 0x000063000d157a10ULL, 0x000fe200017fe4ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0ffffffc18037812ULL, 0x000fe400078ef803ULL,
0x00000030201e7810ULL, 0x000fe40007ffe0ffULL, 0x000000300c167812ULL, 0x000fe200078ef804ULL,
0x0000001003037824ULL, 0x000fe200078e021aULL, 0xfffffffc0f0f7812ULL, 0x000fe200078ee218ULL,
0x00000001220c7824ULL, 0x000fe200078e021eULL, 0x0000620016167a10ULL, 0x000fc40007fde0ffULL,
0x0000003820207810ULL, 0x000fe20007ffe0ffULL, 0x000000100f0f7824ULL, 0x000fe200078e021aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010037faeULL, 0x0005e2000c101c48ULL,
0x000000051900720cULL, 0x080fe40003fa6070ULL, 0x000063000d177a10ULL, 0x000fe200037fe4ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x000000050e00720cULL, 0x080fe20003f46070ULL,
0x00000000120f7faeULL, 0x0007e2000c901c48ULL, 0x000000051b00720cULL, 0x080fe20003f86070ULL,
0x00000004201d7824ULL, 0x000fe200078e00ffULL, 0x000000051c00720cULL, 0x000fc40003f66070ULL,
0x000000051e00720cULL, 0x080fe20003f26070ULL, 0x0000000419037824ULL, 0x004fe200078e00ffULL,
0x000000052000720cULL, 0x000fe20003f06070ULL, 0x000000040e197824ULL, 0x000fe200078e00ffULL,
0x000000300c0c7812ULL, 0x000fe200078ef804ULL, 0x00000001220e7824ULL, 0x000fe200078e0220ULL,
0xfffffffc03037812ULL, 0x100fe200078ee218ULL, 0x000000041b057824ULL, 0x000fe200078e00ffULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x000000041c137824ULL, 0x008fe200078e00ffULL,
0xfffffffc19197812ULL, 0x100fe200078ee218ULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffffc05057812ULL, 0x000fc400078ee218ULL, 0xfffffffc13137812ULL, 0x000fe200078ee218ULL,
0x000000041e1b7824ULL, 0x000fe200078e00ffULL, 0x000000300e047812ULL, 0x000fe200078ef804ULL,
0x0000001003037824ULL, 0x000fe200078e021aULL, 0xfffffffc1d1d7812ULL, 0x000fe200078ee218ULL,
0x0000001005117824ULL, 0x000fe200078e021aULL, 0xfffffffc1b1b7812ULL, 0x000fe200078ee218ULL,
0x0000001013137824ULL, 0x100fe200078e021aULL, 0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x0000001019197824ULL, 0x100fe200078e021aULL, 0x0000620004047a10ULL, 0x000fe20007fde0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e021aULL, 0x0000000008037faeULL, 0x0005e2000e901c48ULL,
0x000000101d1d7824ULL, 0x000fe200078e021aULL, 0x000063000f057a10ULL, 0x000fc400037fe4ffULL,
0x000000000a117faeULL, 0x0005e8000e101c48ULL, 0x0000000014137faeULL, 0x0005e8000d901c48ULL,
0x0000000016197faeULL, 0x0005e8000d101c48ULL, 0x000000000c1b7faeULL, 0x0005e8000c901c48ULL,
0x00000000041d7faeULL, 0x0005e2000c101c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x00000003030a7211ULL, 0x040fe400078fe8ffULL, 0x0000000803117811ULL, 0x000fc400078ff0ffULL,
0x00000020030b7811ULL, 0x040fe400078ff0ffULL, 0x00000028030d7811ULL, 0x000fe200078ff0ffULL,
0x0000000411137824ULL, 0x000fe200078e00ffULL, 0x000000030a167812ULL, 0x000fe200078ec0ffULL,
0x00000001220a7824ULL, 0x040fe200078e0211ULL, 0x0000001003057811ULL, 0x040fe200078ff0ffULL,
0x0000000122117824ULL, 0x040fe200078e020bULL, 0x0000001803097811ULL, 0x040fe200078ff0ffULL,
0x0000000122187824ULL, 0x040fe200078e020dULL, 0x00000030030f7811ULL, 0x000fe200078ff0ffULL,
0x000000040b0b7824ULL, 0x000fe200078e00ffULL, 0x0000002203087211ULL, 0x000fe200078ff0ffULL,
0x000000040d0d7824ULL, 0x000fe200078e00ffULL, 0x0000003803107811ULL, 0x000fe200078ff0ffULL,
0x00000001220c7824ULL, 0x000fe200078e0205ULL, 0x0ffffffc16177812ULL, 0x000fe200078ef803ULL,
0x0000000409157824ULL, 0x000fe200078e00ffULL, 0xfffffffc13037812ULL, 0x100fe200078ee216ULL,
0x00000001221a7824ULL, 0x040fe200078e020fULL, 0xfffffffc0b137812ULL, 0x100fe200078ee216ULL,
0x0000000405057824ULL, 0x000fe200078e00ffULL, 0xfffffffc0d147812ULL, 0x100fe200078ee216ULL,
0x00000001220e7824ULL, 0x000fe200078e0209ULL, 0x00001000021e7811ULL, 0x000fe200078e68ffULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc05057812ULL, 0x000fe200078ee216ULL,
0x0000000410197824ULL, 0x000fc400078e00ffULL, 0x0000010008087825ULL, 0x000fc800078e00ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000003008127812ULL, 0x000fc600078ef804ULL,
0x00000001221c7824ULL, 0x000fe200078e0210ULL, 0xfffffffc15107812ULL, 0x100fe200078ee216ULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffffc0f157812ULL, 0x100fe400078ee216ULL,
0xfffffffc19167812ULL, 0x000fe200078ee216ULL, 0x00000010141f7824ULL, 0x000fe200078e021eULL,
0x000000300a147812ULL, 0x000fe200078ef804ULL, 0x0000001017257824ULL, 0x000fe200078e021eULL,
0x000000300c177812ULL, 0x000fe200078ef804ULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000620012127a10ULL, 0x000fc40007f1e0ffULL, 0x0000620014147a10ULL, 0x000fe20007f3e0ffULL,
0x0000001016237824ULL, 0x100fe200078e021eULL, 0x0000620017167a10ULL, 0x000fe20007f5e0ffULL,
0x00000010131d7824ULL, 0x100fe200078e021eULL, 0x0000630009137a10ULL, 0x000fe200007fe4ffULL,
0x0000001015217824ULL, 0x000fe200078e021eULL, 0x000000300e0e7812ULL, 0x000fe200078ef804ULL,
0x0000010011087825ULL, 0x000fe200078e00ffULL, 0x000063000b157a10ULL, 0x000fe20000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012257faeULL, 0x0005e2000b901c48ULL,
0x000063000d177a10ULL, 0x000fe200017fe4ffULL, 0x00000100180a7825ULL, 0x000fe200078e00ffULL,
0x000062000e0e7a10ULL, 0x000fc60007f1e0ffULL, 0x00000010101b7824ULL, 0x000fe200078e021eULL,
0x000063000f0f7a10ULL, 0x000fe200007fe4ffULL, 0x000001001a0c7825ULL, 0x000fc800078e00ffULL,
0x000001001c107825ULL, 0x000fc800078e00ffULL, 0x0000001005197824ULL, 0x000fe200078e021eULL,
0x0000003008057812ULL, 0x000fe200078ef804ULL, 0x0000001003037824ULL, 0x000fe200078e021eULL,
0x000000300a087812ULL, 0x100fe400078ef804ULL, 0x000000300c0a7812ULL, 0x100fe400078ef804ULL,
0x00000030100c7812ULL, 0x000fe200078ef804ULL, 0x0000000014037faeULL, 0x0005e2000b901c48ULL,
0x0000620005047a10ULL, 0x000fe40007f1e0ffULL, 0x0000620008087a10ULL, 0x000fe20007f3e0ffULL,
0x0000000016197faeULL, 0x0005e2000b901c48ULL, 0x000062000a0a7a10ULL, 0x000fc40007f5e0ffULL,
0x000062000c0c7a10ULL, 0x000fe20007f7e0ffULL, 0x000000000e1b7faeULL, 0x0005e2000b901c48ULL,
0x0000630009057a10ULL, 0x000fe400007fe4ffULL, 0x000063000b097a10ULL, 0x000fe40000ffe4ffULL,
0x000063000d0b7a10ULL, 0x000fe200017fe4ffULL, 0x00000000041d7faeULL, 0x0005e2000b901c48ULL,
0x00006300110d7a10ULL, 0x000fc60001ffe4ffULL, 0x00000000081f7faeULL, 0x0005e8000b901c48ULL,
0x000000000a217faeULL, 0x0005e8000b901c48ULL, 0x000000000c237faeULL, 0x0005e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000047805ULL, 0x004fc40000015200ULL,
0x01360400ff037984ULL, 0x000ea40000000800ULL, 0x8000000003ff7812ULL, 0x006fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000804087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e05ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011409ULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01360400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000660000720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000657919ULL, 0x000e620000000000ULL, 0x00005800ff697624ULL, 0x000fe200078e00ffULL,
0x800058005c6c7a10ULL, 0x000fe20007ffe0ffULL, 0x00000020026f7824ULL, 0x040fe200078e00ffULL,
0x00013688026e7811ULL, 0x000fe400078e18ffULL, 0x0000001f69037810ULL, 0x040fe40007ffe0ffULL,
0xffffffff696d7810ULL, 0x000fe40007ffe0ffULL, 0x00000004ff037819ULL, 0x000fc40000011603ULL,
0x0000000969697810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff6c7819ULL, 0x000fe4000001166cULL,
0x0ffffffe036a7812ULL, 0x000fc400078ec0ffULL, 0x0000000100037810ULL, 0x040fe20007ffe0ffULL,
0x0000010000587824ULL, 0x000fe200078e0270ULL, 0x0000000000007946ULL, 0x000fe40003800000ULL,
0x000000660300720cULL, 0x000fe20003f06070ULL, 0x00006600680f7a24ULL, 0x000fd800078e0258ULL,
0x0000064000008947ULL, 0x00cfea0003800000ULL, 0x00000002ff167819ULL, 0x002fe20000011665ULL,
0x00000010650e7824ULL, 0x000fe200078e00ffULL, 0x000000585c037217ULL, 0x000fe40007800000ULL,
0x0000000816187810ULL, 0x040fe20007ffe0ffULL, 0x0000000116047824ULL, 0x040fe200078e020fULL,
0x00000010161a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a58ULL,
0x00000018161c7810ULL, 0x000fe20007ffe0ffULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x000000300e0e7812ULL, 0x000fc400078ec0ffULL, 0x00000020161e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000118067824ULL, 0x100fe200078e020fULL, 0x000000400e177812ULL, 0x000fe200078efcffULL,
0x000000011a087824ULL, 0x100fe200078e020fULL, 0x0000002816207810ULL, 0x000fe20007ffe0ffULL,
0x000000011c0a7824ULL, 0x000fe200078e020fULL, 0x0000001704107212ULL, 0x000fe200078efcffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x000000031c00720cULL, 0x000fe40003fa6070ULL,
0x0000620010107a10ULL, 0x000fe20007f3e0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000001706127212ULL, 0x000fc400078efcffULL, 0x0000630005117a10ULL, 0x000fe20000ffe4ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000001708147212ULL, 0x080fe400078efcffULL,
0x0000620012127a10ULL, 0x000fe20007f3e0ffULL, 0x000000011e0c7824ULL, 0x000fe200078e020fULL,
0x000000170a047212ULL, 0x000fe400078efcffULL, 0x00000065650a7211ULL, 0x000fe200078fe8ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000620014147a10ULL, 0x000fc40007f5e0ffULL,
0x0ffffffc65087812ULL, 0x000fe400078ec0ffULL, 0x000000170c067212ULL, 0x000fe200078efcffULL,
0x00000004180c7824ULL, 0x000fe200078e00ffULL, 0x000000030a1d7812ULL, 0x000fe400078ec0ffULL,
0x0000630007137a10ULL, 0x000fe40000ffe4ffULL, 0x0000630009157a10ULL, 0x000fe400017fe4ffULL,
0x0000620004047a10ULL, 0x000fc40007f3e0ffULL, 0x0000620006067a10ULL, 0x000fe40007f7e0ffULL,
0x0000200002097811ULL, 0x000fe400078e68ffULL, 0x000000081d0a7212ULL, 0x000fe400078efcffULL,
0x000063000b057a10ULL, 0x000fe40000ffe4ffULL, 0x000063000d077a10ULL, 0x000fe20001ffe4ffULL,
0x000000100a0d7824ULL, 0x000fe200078e0209ULL, 0x000000031600720cULL, 0x000fe20003f26070ULL,
0x00000001200a7824ULL, 0x000fe200078e020fULL, 0xfffffffc0c0c7812ULL, 0x000fc400078ee21dULL,
0x000000031800720cULL, 0x080fe20003f46070ULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x000000031a00720cULL, 0x080fe40003f66070ULL, 0x000000031e00720cULL, 0x000fe20003f86070ULL,
0x000000041a187824ULL, 0x000fe200078e00ffULL, 0x000000170a0a7212ULL, 0x000fe200078efcffULL,
0x000000100c197824ULL, 0x000fe200078e0209ULL, 0x00000030160c7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100d7faeULL, 0x0003e2000c901c48ULL,
0xfffffffc18187812ULL, 0x000fc400078ee21dULL, 0x0000003816167810ULL, 0x000fe20007ffe0ffULL,
0x0000000012197faeULL, 0x0005e2000d101c48ULL, 0x000000030c00720cULL, 0x080fe20003f46070ULL,
0x00000010181b7824ULL, 0x000fe200078e0209ULL, 0x000000031600720cULL, 0x080fe20003f26070ULL,
0x000000040c187824ULL, 0x000fe400078e00ffULL, 0x00000004161a7824ULL, 0x000fe200078e00ffULL,
0x00000000141b7faeULL, 0x0007e2000d901c48ULL, 0x000062000a107a10ULL, 0x002fe20007fde0ffULL,
0x000000010c0a7824ULL, 0x100fe200078e020fULL, 0x000000032000720cULL, 0x000fe20003f66070ULL,
0x00000001160c7824ULL, 0x000fe200078e020fULL, 0x000063000b117a10ULL, 0x000fe200037fe4ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc18187812ULL, 0x000fc400078ee21dULL,
0xfffffffc1a1a7812ULL, 0x100fe200078ee21dULL, 0x000000041c127824ULL, 0x004fe200078e00ffULL,
0x000000170a0a7212ULL, 0x080fe200078efcffULL, 0x000000041e147824ULL, 0x008fe400078e00ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffffc12127812ULL, 0x100fe400078ee21dULL,
0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL, 0x0000000420207824ULL, 0x000fe200078e00ffULL,
0xfffffffc14147812ULL, 0x000fe200078ee21dULL, 0x0000001012037824ULL, 0x100fe200078e0209ULL,
0x000000170c0c7212ULL, 0x000fe200078efcffULL, 0x0000001018177824ULL, 0x000fe200078e0209ULL,
0xfffffffc20167812ULL, 0x000fe200078ee21dULL, 0x0000001014137824ULL, 0x100fe200078e0209ULL,
0x000063000b0b7a10ULL, 0x000fe200037fe4ffULL, 0x0000000004037faeULL, 0x0003e2000e901c48ULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x0000001016157824ULL, 0x000fc400078e0209ULL,
0x000000101a097824ULL, 0x000fe200078e0209ULL, 0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x0000000006137faeULL, 0x0003e8000e101c48ULL, 0x0000000010157faeULL, 0x0003e8000d901c48ULL,
0x000000000a177faeULL, 0x0003e8000d101c48ULL, 0x000000000c097faeULL, 0x0003e2000c901c48ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x00000008650a7811ULL, 0x042fe200078ff0ffULL,
0x00000010650e7824ULL, 0x040fe200078e00ffULL, 0x00000010650c7811ULL, 0x000fc400078ff0ffULL,
0x0000001865127811ULL, 0x040fe200078ff0ffULL, 0x000000010a067824ULL, 0x140fe200078e020fULL,
0x0000000f65047211ULL, 0x040fe200078ff0ffULL, 0x000000040a147824ULL, 0x000fe200078e00ffULL,
0x0000006565037211ULL, 0x040fe200078fe8ffULL, 0x000000010c0a7824ULL, 0x100fe200078e020fULL,
0x000000300e0e7812ULL, 0x000fe200078ec0ffULL, 0x000000040c167824ULL, 0x000fe200078e00ffULL,
0x0000002065187811ULL, 0x040fe200078ff0ffULL, 0x00000001120c7824ULL, 0x040fe200078e020fULL,
0x00000028651a7811ULL, 0x040fe200078ff0ffULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0x00000030651c7811ULL, 0x040fe200078ff0ffULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x00000038651e7811ULL, 0x000fc400078ff0ffULL, 0x0000000303037812ULL, 0x000fe200078ec0ffULL,
0x0000000418207824ULL, 0x000fe200078e00ffULL, 0x000000400e237812ULL, 0x000fe200078efcffULL,
0x000000041a227824ULL, 0x000fe200078e00ffULL, 0xfffffffc12197812ULL, 0x100fe200078ee203ULL,
0x000000041c247824ULL, 0x000fe200078e00ffULL, 0x0000002304127212ULL, 0x000fe200078efcffULL,
0x000000041e267824ULL, 0x000fe200078e00ffULL, 0x0ffffffc65087812ULL, 0x000fe200078ec0ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0xfffffffc14097812ULL, 0x000fc400078ee203ULL,
0xfffffffc160d7812ULL, 0x100fe200078ee203ULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffffc201b7812ULL, 0x100fe400078ee203ULL, 0xfffffffc221d7812ULL, 0x100fe400078ee203ULL,
0xfffffffc241f7812ULL, 0x100fe400078ee203ULL, 0xfffffffc26217812ULL, 0x000fe400078ee203ULL,
0x0000620012127a10ULL, 0x000fc40007f3e0ffULL, 0x0000200002107811ULL, 0x000fe400078e68ffULL,
0x0000000803037212ULL, 0x000fe400078efcffULL, 0x0000002306147212ULL, 0x080fe200078efcffULL,
0x0000000118067824ULL, 0x000fe200078e020fULL, 0x000000230a167212ULL, 0x000fe200078efcffULL,
0x0000001003257824ULL, 0x000fe200078e0210ULL, 0x0000630005137a10ULL, 0x000fe20000ffe4ffULL,
0x000001000c047825ULL, 0x000fe200078e00ffULL, 0x0000620014147a10ULL, 0x000fc40007f5e0ffULL,
0x0000620016167a10ULL, 0x000fe20007f7e0ffULL, 0x0000001009037824ULL, 0x100fe200078e0210ULL,
0x0000630007157a10ULL, 0x000fe200017fe4ffULL, 0x000000011a0a7824ULL, 0x100fe200078e020fULL,
0x000063000b177a10ULL, 0x000fe20001ffe4ffULL, 0x000000100d097824ULL, 0x100fe200078e0210ULL,
0x0000002304047212ULL, 0x000fe200078efcffULL, 0x0000001019197824ULL, 0x100fe200078e0210ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012257faeULL, 0x0003e2000b901c48ULL,
0x000000101b1b7824ULL, 0x100fe200078e0210ULL, 0x0000620004047a10ULL, 0x000fe20007f3e0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0210ULL, 0x0000000014037faeULL, 0x0003e2000b901c48ULL,
0x000000101f1f7824ULL, 0x100fe200078e0210ULL, 0x0000630005057a10ULL, 0x000fe20000ffe4ffULL,
0x0000001021217824ULL, 0x000fe200078e0210ULL, 0x0000000016097faeULL, 0x0003e2000b901c48ULL,
0x000000011c0c7824ULL, 0x000fc400078e020fULL, 0x000000011e107824ULL, 0x000fe200078e020fULL,
0x0000000004197faeULL, 0x0003e2000b901c48ULL, 0x0000010006067825ULL, 0x000fc800078e00ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000002306067212ULL, 0x000fc600078efcffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x000000230a0a7212ULL, 0x080fe400078efcffULL,
0x0000620006067a10ULL, 0x000fe20007f3e0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000230c0c7212ULL, 0x080fe400078efcffULL, 0x000062000a0a7a10ULL, 0x000fe40007f5e0ffULL,
0x0000002310107212ULL, 0x000fe400078efcffULL, 0x000062000c0c7a10ULL, 0x000fc40007f7e0ffULL,
0x0000620010107a10ULL, 0x000fe40007f9e0ffULL, 0x0000630007077a10ULL, 0x000fe40000ffe4ffULL,
0x000063000b0b7a10ULL, 0x000fe400017fe4ffULL, 0x000063000d0d7a10ULL, 0x000fe20001ffe4ffULL,
0x00000000061b7faeULL, 0x0003e2000b901c48ULL, 0x0000630011117a10ULL, 0x000fc600027fe4ffULL,
0x000000000a1d7faeULL, 0x0003e8000b901c48ULL, 0x000000000c1f7faeULL, 0x0003e8000b901c48ULL,
0x0000000010217faeULL, 0x0003e4000b901c48ULL, 0x00000004ff0c7819ULL, 0x102fe20000011665ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000765047812ULL, 0x000fe200078ec0ffULL,
0x0000200002067824ULL, 0x000fe200078e00ffULL, 0x00000003ff077819ULL, 0x100fe20000011665ULL,
0x000000080c057824ULL, 0x000fe200078e00ffULL, 0x00000008040d7812ULL, 0x000fc400078ef865ULL,
0x00001000060b7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff805057812ULL, 0x000fe200078ee204ULL,
0x000000010c0c7824ULL, 0x000fe200078e020dULL, 0x0000000107047812ULL, 0x000fe200078ec0ffULL,
0x000000100d037824ULL, 0x000fe200078e00ffULL, 0x0000001005117810ULL, 0x040fe20007ffe0ffULL,
0x0000000405407824ULL, 0x040fe200078e00ffULL, 0x0000002005137810ULL, 0x040fe20007ffe0ffULL,
0x0000000405147824ULL, 0x040fe200078e00ffULL, 0x0000003005157810ULL, 0x000fe20007ffe0ffULL,
0x00000004110a7824ULL, 0x000fe200078e00ffULL, 0x0000000405097211ULL, 0x080fe200078ff8ffULL,
0x00000004135b7824ULL, 0x000fe200078e00ffULL, 0x0000000411057211ULL, 0x080fe200078ff8ffULL,
0x0000000415177824ULL, 0x000fe200078e00ffULL, 0x0000000413107211ULL, 0x000fe200078ff8ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000415047211ULL, 0x000fe200078ff8ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0xfffffff003037812ULL, 0x000fe200078ee20cULL,
0x000000100d197824ULL, 0x000fe200078e00ffULL, 0xfffffffc40407812ULL, 0x000fe200078ee209ULL,
0x0000000411167824ULL, 0x000fe200078e00ffULL, 0xfffffffc0a5d7812ULL, 0x000fe200078ee205ULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0xfffffffc5b5b7812ULL, 0x000fe200078ee210ULL,
0x00000010400a7824ULL, 0x100fe200078e020bULL, 0xfffffffc175a7812ULL, 0x000fe200078ee204ULL,
0x000000105d5e7824ULL, 0x100fe200078e020bULL, 0x00000000032c783bULL, 0x0003e20000000200ULL,
0x000000105b607824ULL, 0x100fe200078e020bULL, 0x0000000209597810ULL, 0x000fe20007ffe0ffULL,
0x000000105a617824ULL, 0x000fe200078e020bULL, 0x000000000a38783bULL, 0x000ea20000000200ULL,
0x000000020c127810ULL, 0x000fe20007ffe0ffULL, 0x0000000413137824ULL, 0x000fe200078e00ffULL,
0xfffffffc14597812ULL, 0x000fe200078ee259ULL, 0x000000005e34783bULL, 0x000ee20000000200ULL,
0x0000000205057810ULL, 0x000fe20007ffe0ffULL, 0x0000000415147824ULL, 0x000fe200078e00ffULL,
0x0000000210107810ULL, 0x000fe20007ffe0ffULL, 0x000000006030783bULL, 0x000f220000000200ULL,
0x0000000204037810ULL, 0x002fe20007ffe0ffULL, 0x0000001059627824ULL, 0x000fe200078e020bULL,
0xfffffff019127812ULL, 0x000fe200078ee212ULL, 0x00000000613c783bULL, 0x000e620000000200ULL,
0xfffffffc16057812ULL, 0x000fc400078ee205ULL, 0xfffffffc13047812ULL, 0x000fe200078ee210ULL,
0x0000001012287824ULL, 0x000fe200078e00ffULL, 0xfffffffc14037812ULL, 0x000fe200078ee203ULL,
0x0000001005637824ULL, 0x100fe200078e020bULL, 0x000000006250783bULL, 0x000fe20000000200ULL,
0x0000001004647824ULL, 0x100fe400078e020bULL, 0x0000001003677824ULL, 0x000fe200078e020bULL,
0x000000002828783bULL, 0x000e680000000200ULL, 0x000000006318783bULL, 0x000e680000000200ULL,
0x000000006420783bULL, 0x000e680000000200ULL, 0x000000006710783bULL, 0x000e620000000200ULL,
0x000000382c54723cULL, 0x044f7000000018ffULL, 0x000000342c14723cULL, 0x048f7000000018ffULL,
0x000000302c1c723cULL, 0x050f7000000018ffULL, 0x0000003a2c38723cULL, 0x040f7000000018ffULL,
0x000000362c34723cULL, 0x040f7000000018ffULL, 0x000000322c30723cULL, 0x040f7000000018ffULL,
0x0000003c2c24723cULL, 0x042f7000000018ffULL, 0x0000003e2c2c723cULL, 0x000f7000000018ffULL,
0x000000502854723cULL, 0x060b700000001854ULL, 0x000000182814723cULL, 0x040b700000001814ULL,
0x00000020281c723cULL, 0x040b70000000181cULL, 0x000000522850723cULL, 0x040b700000001838ULL,
0x0000001a2818723cULL, 0x040b700000001834ULL, 0x000000222820723cULL, 0x040b700000001830ULL,
0x000000102824723cULL, 0x040b700000001824ULL, 0x000000122828723cULL, 0x000b62000000182cULL,
0x0000059000008947ULL, 0x000fce0003800000ULL, 0x00000002ff3e7819ULL, 0x100fe20000011665ULL,
0x000000ffff137224ULL, 0x020fe200078e00ffULL, 0x000000585c397217ULL, 0x000fe20007800000ULL,
0x0000000107077824ULL, 0x000fe200078e0265ULL, 0x000000083e447810ULL, 0x040fe20007ffe0ffULL,
0x000000013e317824ULL, 0x100fe200078e020fULL, 0x000000800e127812ULL, 0x000fe200078efcffULL,
0x0000000139397824ULL, 0x000fe200078e0a58ULL, 0x000000203e3a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001442f7824ULL, 0x000fe200078e020fULL, 0x000000103e467810ULL, 0x040fe20007ffe0ffULL,
0x0000010031307825ULL, 0x000fe200078e0012ULL, 0x000000283e3c7810ULL, 0x000fc40007ffe0ffULL,
0x000000183e427810ULL, 0x040fe20007ffe0ffULL, 0x000001002f2e7825ULL, 0x000fe200078e0012ULL,
0x000000303e387810ULL, 0x040fe40007ffe0ffULL, 0x000000393e00720cULL, 0x000fe20003f26070ULL,
0x000000013a357824ULL, 0x100fe200078e020fULL, 0x000062002e2e7a10ULL, 0x000fe20007f7e0ffULL,
0x00000001462d7824ULL, 0x000fe200078e020fULL, 0x000000383e3e7810ULL, 0x000fe20007ffe0ffULL,
0x0000010035347825ULL, 0x000fe200078e0012ULL, 0x000063002f2f7a10ULL, 0x000fc40001ffe4ffULL,
0x0000620030307a10ULL, 0x000fe20007f5e0ffULL, 0x000001002d2c7825ULL, 0x000fe200078e0012ULL,
0x0000620034347a10ULL, 0x000fe40007f7e0ffULL, 0x0000630031317a10ULL, 0x000fe200017fe4ffULL,
0x000000013c377824ULL, 0x100fe200078e020fULL, 0x000062002c2c7a10ULL, 0x000fe20007f9e0ffULL,
0x0000000142337824ULL, 0x100fe200078e020fULL, 0x0000630035357a10ULL, 0x000fe20001ffe4ffULL,
0x0000000138117824ULL, 0x100fe200078e020fULL, 0x000063002d2d7a10ULL, 0x000fe200027fe4ffULL,
0x000000013e097824ULL, 0x000fe200078e020fULL, 0x000000394400720cULL, 0x080fe20003f66070ULL,
0x0000010037367825ULL, 0x000fe200078e0012ULL, 0x000000393800720cULL, 0x000fc40003fa6070ULL,
0x000000393e00720cULL, 0x000fe20003fc6070ULL, 0x0000010033327825ULL, 0x000fe200078e0012ULL,
0x0000620036367a10ULL, 0x000fc60007f9e0ffULL, 0x0000010011107825ULL, 0x100fe200078e0012ULL,
0x0000630037377a10ULL, 0x000fe400027fe4ffULL, 0x000000394600720cULL, 0x000fe20003f86070ULL,
0x0000010009127825ULL, 0x000fe200078e0012ULL, 0x0000000307097812ULL, 0x000fe400078ec0ffULL,
0x0000620032327a10ULL, 0x000fe20007f5e0ffULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0x0000000809087212ULL, 0x000fe200078efcffULL, 0x0000000446467824ULL, 0x000fe200078e00ffULL,
0x0000630033337a10ULL, 0x000fe200017fe4ffULL, 0x0000000438387824ULL, 0x000fe200078e00ffULL,
0xfffffffc44447812ULL, 0x000fe200078ee209ULL, 0x0000001008077824ULL, 0x000fe200078e020bULL,
0xfffffffc46467812ULL, 0x000fc400078ee209ULL, 0x0000620010107a10ULL, 0x000fe20007f5e0ffULL,
0x00000010443b7824ULL, 0x100fe200078e020bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030077faeULL, 0x0003e2000c901c48ULL, 0x00000010463d7824ULL, 0x000fe200078e020bULL,
0x000000394200720cULL, 0x0c0fe20003f26070ULL, 0x0000000442427824ULL, 0x000fe200078e00ffULL,
0x000000002e3b7faeULL, 0x0005e2000d901c48ULL, 0x000000393a00720cULL, 0x040fe20003f66070ULL,
0x000000043a3a7824ULL, 0x000fe200078e00ffULL, 0x0000630011117a10ULL, 0x000fe200017fe4ffULL,
0x000000002c3d7faeULL, 0x0007e2000e101c48ULL, 0xfffffffc42427812ULL, 0x000fc400078ee209ULL,
0x000000393c00720cULL, 0x000fe20003f86070ULL, 0x000000043e307824ULL, 0x002fe200078e00ffULL,
0x0000620012127a10ULL, 0x000fe20007f5e0ffULL, 0x0000001042317824ULL, 0x000fe400078e020bULL,
0x000000043c2e7824ULL, 0x004fe200078e00ffULL, 0xfffffffc30307812ULL, 0x100fe400078ee209ULL,
0x0000000032317faeULL, 0x0003e2000c901c48ULL, 0xfffffffc3a2c7812ULL, 0x108fe400078ee209ULL,
0xfffffffc2e2e7812ULL, 0x000fc400078ee209ULL, 0x0000630013137a10ULL, 0x000fe200017fe4ffULL,
0x000000102c2d7824ULL, 0x000fe200078e020bULL, 0xfffffffc382c7812ULL, 0x000fe200078ee209ULL,
0x000000102e2f7824ULL, 0x000fc600078e020bULL, 0x00000000342d7faeULL, 0x0005e2000d901c48ULL,
0x000000102c317824ULL, 0x102fe400078e020bULL, 0x0000001030337824ULL, 0x000fe200078e020bULL,
0x00000000362f7faeULL, 0x0005e8000e101c48ULL, 0x0000000010317faeULL, 0x0005e8000e901c48ULL,
0x0000000012337faeULL, 0x0005e2000f101c48ULL, 0x000004d000007947ULL, 0x000fea0003800000ULL,
0x0000000865447811ULL, 0x040fe200078ff0ffULL, 0x000000ffff377224ULL, 0x020fe200078e00ffULL,
0x0000001065467811ULL, 0x000fe200078ff0ffULL, 0x0000000107077824ULL, 0x000fe200078e0265ULL,
0x0000001865427811ULL, 0x040fe200078ff0ffULL, 0x0000000144137824ULL, 0x100fe200078e020fULL,
0x00000020653e7811ULL, 0x040fe200078ff0ffULL, 0x00000001462d7824ULL, 0x100fe200078e020fULL,
0x00000028653c7811ULL, 0x040fe200078ff0ffULL, 0x00000001422f7824ULL, 0x100fe200078e020fULL,
0x0000003065387811ULL, 0x040fe200078ff0ffULL, 0x000000013e317824ULL, 0x100fe200078e020fULL,
0x00000038653a7811ULL, 0x040fe200078ff0ffULL, 0x000000013c337824ULL, 0x100fe200078e020fULL,
0x000000800e367812ULL, 0x000fe200078efcffULL, 0x0000000138357824ULL, 0x100fe200078e020fULL,
0x0000000f65117211ULL, 0x000fe200078ff0ffULL, 0x000000013a097824ULL, 0x000fc400078e020fULL,
0x0000010013127825ULL, 0x000fc800078e0036ULL, 0x0000010011107825ULL, 0x000fe200078e0036ULL,
0x0000620012127a10ULL, 0x000fc60007f5e0ffULL, 0x000001002d2c7825ULL, 0x100fe200078e0036ULL,
0x0000620010107a10ULL, 0x000fe40007f3e0ffULL, 0x0000630013137a10ULL, 0x000fe200017fe4ffULL,
0x000001002f2e7825ULL, 0x100fe200078e0036ULL, 0x0000630011117a10ULL, 0x000fe40000ffe4ffULL,
0x000062002c2c7a10ULL, 0x000fe20007f7e0ffULL, 0x0000010031307825ULL, 0x100fe200078e0036ULL,
0x000062002e2e7a10ULL, 0x000fe40007f3e0ffULL, 0x000063002d2d7a10ULL, 0x000fe20001ffe4ffULL,
0x0000010033327825ULL, 0x000fe200078e0036ULL, 0x0000620030307a10ULL, 0x000fc40007f5e0ffULL,
0x000063002f2f7a10ULL, 0x000fe20000ffe4ffULL, 0x0000010035347825ULL, 0x100fe200078e0036ULL,
0x0000620032327a10ULL, 0x000fe40007f3e0ffULL, 0x0000630031317a10ULL, 0x000fe200017fe4ffULL,
0x0000010009367825ULL, 0x000fe200078e0036ULL, 0x0000000307097812ULL, 0x000fe400078ec0ffULL,
0x0000620034347a10ULL, 0x000fe20007f5e0ffULL, 0x0000000446467824ULL, 0x000fe200078e00ffULL,
0x0000000809087212ULL, 0x000fe200078efcffULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0x0000630033337a10ULL, 0x000fe20000ffe4ffULL, 0x0000000442487824ULL, 0x000fe200078e00ffULL,
0xfffffffc46427812ULL, 0x000fe200078ee209ULL, 0x0000001008077824ULL, 0x000fe200078e020bULL,
0xfffffffc44447812ULL, 0x000fe200078ee209ULL, 0x000000043e3e7824ULL, 0x000fe200078e00ffULL,
0x0000620036367a10ULL, 0x000fe20007f3e0ffULL, 0x00000010423b7824ULL, 0x100fe200078e020bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010077faeULL, 0x0003e2000b901c48ULL,
0x0000001044397824ULL, 0x000fe200078e020bULL, 0xfffffffc48447812ULL, 0x100fe200078ee209ULL,
0x000000043c427824ULL, 0x000fe200078e00ffULL, 0xfffffffc3e3c7812ULL, 0x000fe200078ee209ULL,
0x0000000438387824ULL, 0x000fe200078e00ffULL, 0x0000000012397faeULL, 0x0005e2000b901c48ULL,
0x000000043a3a7824ULL, 0x000fe200078e00ffULL, 0x0000630035357a10ULL, 0x000fe200017fe4ffULL,
0x00000010443d7824ULL, 0x100fe200078e020bULL, 0x000000002c3b7faeULL, 0x0007e2000b901c48ULL,
0x0000630037377a10ULL, 0x000fe20000ffe4ffULL, 0x000000103c117824ULL, 0x002fe200078e020bULL,
0xfffffffc42107812ULL, 0x100fe200078ee209ULL, 0x000000002e3d7faeULL, 0x0003e2000b901c48ULL,
0xfffffffc38127812ULL, 0x004fc600078ee209ULL, 0x0000001010137824ULL, 0x000fe200078e020bULL,
0xfffffffc3a387812ULL, 0x000fe200078ee209ULL, 0x0000000030117faeULL, 0x0005e2000b901c48ULL,
0x00000010122d7824ULL, 0x008fc600078e020bULL, 0x0000000032137faeULL, 0x0005e2000b901c48ULL,
0x00000010382f7824ULL, 0x002fc600078e020bULL, 0x00000000342d7faeULL, 0x0005e8000b901c48ULL,
0x00000000362f7faeULL, 0x0005e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000100d117824ULL, 0x044fe200078e00ffULL, 0x000000040c107810ULL, 0x000fe20007ffe0ffULL,
0x000000100d2d7824ULL, 0x000fe200078e00ffULL, 0x0000200006067810ULL, 0x000fe40007ffe0ffULL,
0xfffffff011107812ULL, 0x000fc400078ee210ULL, 0x000000060c2c7810ULL, 0x000fe20007ffe0ffULL,
0x00000010405f7824ULL, 0x000fe400078e0206ULL, 0x0000001010407824ULL, 0x000fe200078e00ffULL,
0xfffffff02d2c7812ULL, 0x000fe200078ee22cULL, 0x000000105d5d7824ULL, 0x100fe400078e0206ULL,
0x000000105b5b7824ULL, 0x100fe400078e0206ULL, 0x000000105a5a7824ULL, 0x000fe400078e0206ULL,
0x000000102c2c7824ULL, 0x000fc400078e00ffULL, 0x0000001059597824ULL, 0x100fe400078e0206ULL,
0x0000001005057824ULL, 0x000fe200078e0206ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000005f10783bULL, 0x000fe20000000200ULL, 0x0000001004047824ULL, 0x100fe400078e0206ULL,
0x0000001003037824ULL, 0x000fe200078e0206ULL, 0x000000004040783bULL, 0x000e680000000200ULL,
0x000000005d4c783bULL, 0x000ea80000000200ULL, 0x000000005b48783bULL, 0x000ee80000000200ULL,
0x000000005a44783bULL, 0x000f280000000200ULL, 0x00000000593c783bULL, 0x000fe80000000200ULL,
0x000000002c2c783bULL, 0x000ee80000000200ULL, 0x000000000538783bULL, 0x000ee80000000200ULL,
0x000000000434783bULL, 0x000ee80000000200ULL, 0x000000000330783bULL, 0x000ee20000000200ULL,
0x000000104054723cULL, 0x042f700000001854ULL, 0x000000124050723cULL, 0x040f700000001850ULL,
0x0000004c4014723cULL, 0x044f700000001814ULL, 0x0000004e4018723cULL, 0x040f700000001818ULL,
0x00000048401c723cULL, 0x048f70000000181cULL, 0x0000004a4020723cULL, 0x040f700000001820ULL,
0x000000444024723cULL, 0x050f700000001824ULL, 0x000000464028723cULL, 0x000f700000001828ULL,
0x0000003c2c54723cULL, 0x060b700000001854ULL, 0x0000003e2c50723cULL, 0x040b700000001850ULL,
0x000000382c14723cULL, 0x040b700000001814ULL, 0x0000003a2c18723cULL, 0x040b700000001818ULL,
0x000000342c1c723cULL, 0x040b70000000181cULL, 0x000000362c20723cULL, 0x040b700000001820ULL,
0x000000302c24723cULL, 0x040b700000001824ULL, 0x000000322c28723cULL, 0x000b620000001828ULL,
0x0000056000008947ULL, 0x000fce0003800000ULL, 0x00000002ff367819ULL, 0x020fe20000011665ULL,
0x000000ffff2f7224ULL, 0x000fe200078e00ffULL, 0x000000c00e2e7812ULL, 0x000fc400078efcffULL,
0x0000000836377810ULL, 0x040fe20007ffe0ffULL, 0x0000000136137824ULL, 0x040fe200078e020fULL,
0x00000010363a7810ULL, 0x040fe40007ffe0ffULL, 0x00000018363c7810ULL, 0x040fe20007ffe0ffULL,
0x0000010013127825ULL, 0x000fe200078e002eULL, 0x00000028363e7810ULL, 0x040fe40007ffe0ffULL,
0x00000020363d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000137117824ULL, 0x100fe200078e020fULL,
0x0000620012307a10ULL, 0x000fe20007f1e0ffULL, 0x000000013a2d7824ULL, 0x100fe200078e020fULL,
0x00000038363f7810ULL, 0x000fe20007ffe0ffULL, 0x000000013c337824ULL, 0x100fe200078e020fULL,
0x0000630013317a10ULL, 0x000fe200007fe4ffULL, 0x000000013e397824ULL, 0x000fe200078e020fULL,
0x000000585c137217ULL, 0x000fe20007800000ULL, 0x0000000437407824ULL, 0x000fc400078e00ffULL,
0x0000010011107825ULL, 0x000fc600078e002eULL, 0xfffffffc403b7812ULL, 0x000fe200078ee209ULL,
0x0000000113387824ULL, 0x000fe200078e0a58ULL, 0x0000620010107a10ULL, 0x000fe20007f3e0ffULL,
0x000001002d2c7825ULL, 0x000fc600078e002eULL, 0x000000383600720cULL, 0x080fe20003f46070ULL,
0x000000013d357824ULL, 0x000fe200078e020fULL, 0x000000383700720cULL, 0x080fe20003f66070ULL,
0x0000010033127825ULL, 0x100fe200078e002eULL, 0x000062002c2c7a10ULL, 0x000fe40007f1e0ffULL,
0x0000630011117a10ULL, 0x000fe20000ffe4ffULL, 0x0000010039327825ULL, 0x000fe200078e002eULL,
0x000063002d2d7a10ULL, 0x000fe400007fe4ffULL, 0x0000620012127a10ULL, 0x000fe20007f1e0ffULL,
0x0000001008397824ULL, 0x000fe200078e0206ULL, 0x0000003036087810ULL, 0x000fe20007ffe0ffULL,
0x0000010035347825ULL, 0x000fe200078e002eULL, 0x000000383a00720cULL, 0x000fc40003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030397faeULL, 0x0003e2000d101c48ULL,
0x000000103b3b7824ULL, 0x000fe200078e0206ULL, 0x0000620034347a10ULL, 0x000fe20007f3e0ffULL,
0x0000000108377824ULL, 0x100fe200078e020fULL, 0x000000383c00720cULL, 0x000fe20003f86070ULL,
0x000000013f0f7824ULL, 0x000fe200078e020fULL, 0x0000630013137a10ULL, 0x000fe200007fe4ffULL,
0x000000043a3a7824ULL, 0x000fe200078e00ffULL, 0x00000000103b7faeULL, 0x0005e2000d901c48ULL,
0x0000010037367825ULL, 0x000fe200078e002eULL, 0x0000620032327a10ULL, 0x000fc40007f1e0ffULL,
0x0000630035357a10ULL, 0x000fe20000ffe4ffULL, 0x000000043c3c7824ULL, 0x000fe200078e00ffULL,
0x000000383e00720cULL, 0x0c0fe20003f46070ULL, 0x000000043e3e7824ULL, 0x000fe200078e00ffULL,
0x000000380800720cULL, 0x080fe20003f26070ULL, 0x000001000f2e7825ULL, 0x000fe200078e002eULL,
0x000000383d00720cULL, 0x0c0fe40003f66070ULL, 0xfffffffc3a0f7812ULL, 0x100fe200078ee209ULL,
0x000000043d107824ULL, 0x004fe200078e00ffULL, 0x0000630033337a10ULL, 0x000fe200007fe4ffULL,
0x0000000408087824ULL, 0x000fe200078e00ffULL, 0x0000620036367a10ULL, 0x000fe20007fde0ffULL,
0x000000043f307824ULL, 0x002fe200078e00ffULL, 0xfffffffc3c317812ULL, 0x000fe200078ee209ULL,
0x000000100f0f7824ULL, 0x000fe200078e0206ULL, 0x000000383f00720cULL, 0x000fc40003f06070ULL,
0xfffffffc10397812ULL, 0x100fe200078ee209ULL, 0x0000001031317824ULL, 0x100fe200078e0206ULL,
0xfffffffc3e3b7812ULL, 0x100fe200078ee209ULL, 0x000000002c0f7faeULL, 0x0003e2000e901c48ULL,
0xfffffffc083d7812ULL, 0x100fe200078ee209ULL, 0x0000001039397824ULL, 0x100fe200078e0206ULL,
0x0000630037377a10ULL, 0x000fe200037fe4ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0206ULL,
0xfffffffc303f7812ULL, 0x000fe200078ee209ULL, 0x000000103d3d7824ULL, 0x100fe200078e0206ULL,
0x000062002e107a10ULL, 0x000fe20007fde0ffULL, 0x0000000012317faeULL, 0x0003e4000e101c48ULL,
0x000000103f3f7824ULL, 0x000fe200078e0206ULL, 0x000063002f117a10ULL, 0x000fe200037fe4ffULL,
0x0000000034397faeULL, 0x0003e8000d901c48ULL, 0x00000000323b7faeULL, 0x0003e8000d101c48ULL,
0x00000000363d7faeULL, 0x0003e8000c901c48ULL, 0x00000000103f7faeULL, 0x0003e2000c101c48ULL,
0x000004a000007947ULL, 0x000fea0003800000ULL, 0x0000000865387811ULL, 0x060fe200078ff0ffULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x00000010653a7811ULL, 0x000fc400078ff0ffULL,
0x00000018653c7811ULL, 0x040fe200078ff0ffULL, 0x0000000138357824ULL, 0x100fe200078e020fULL,
0x000000c00e107812ULL, 0x000fe200078efcffULL, 0x000000013a377824ULL, 0x100fe200078e020fULL,
0x0000000f65337211ULL, 0x040fe200078ff0ffULL, 0x000000013c137824ULL, 0x000fe200078e020fULL,
0x00000020653e7811ULL, 0x000fe200078ff0ffULL, 0x0000010035347825ULL, 0x100fe200078e0010ULL,
0x0000002865407811ULL, 0x040fe400078ff0ffULL, 0x0000003065427811ULL, 0x000fe200078ff0ffULL,
0x0000010033327825ULL, 0x000fe200078e0010ULL, 0x0000003865447811ULL, 0x000fc400078ff0ffULL,
0x0000620034347a10ULL, 0x000fe20007f3e0ffULL, 0x000000013e2d7824ULL, 0x100fe200078e020fULL,
0x0000620032327a10ULL, 0x000fe20007f1e0ffULL, 0x0000000438387824ULL, 0x000fe200078e00ffULL,
0x0000630035357a10ULL, 0x000fe20000ffe4ffULL, 0x00000001402f7824ULL, 0x000fe200078e020fULL,
0x0000630033337a10ULL, 0x000fe200007fe4ffULL, 0x0000010037367825ULL, 0x000fe200078e0010ULL,
0xfffffffc38397812ULL, 0x000fc600078ee209ULL, 0x000000043a3a7824ULL, 0x000fe200078e00ffULL,
0x0000620036367a10ULL, 0x000fe20007f5e0ffULL, 0x0000000142317824ULL, 0x000fe400078e020fULL,
0x0000010013127825ULL, 0x000fe200078e0010ULL, 0xfffffffc3a3b7812ULL, 0x000fe400078ee209ULL,
0x0000630037377a10ULL, 0x000fe200017fe4ffULL, 0x000000043c3c7824ULL, 0x000fe200078e00ffULL,
0x0000620012127a10ULL, 0x000fe20007f7e0ffULL, 0x00000001440f7824ULL, 0x000fc400078e020fULL,
0x000000043e3e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc3c3d7812ULL, 0x000fe200078ee209ULL,
0x000001002d2c7825ULL, 0x000fe200078e0010ULL, 0x0000630013137a10ULL, 0x000fe40001ffe4ffULL,
0xfffffffc3e3f7812ULL, 0x000fe200078ee209ULL, 0x0000000440407824ULL, 0x000fe200078e00ffULL,
0x000062002c2c7a10ULL, 0x000fe20007f1e0ffULL, 0x000001002f2e7825ULL, 0x000fc600078e0010ULL,
0xfffffffc40417812ULL, 0x000fe200078ee209ULL, 0x0000000442427824ULL, 0x000fe200078e00ffULL,
0x000062002e2e7a10ULL, 0x000fe20007f3e0ffULL, 0x0000010031307825ULL, 0x000fe200078e0010ULL,
0x000063002d2d7a10ULL, 0x000fe400007fe4ffULL, 0xfffffffc42437812ULL, 0x000fe200078ee209ULL,
0x0000000444447824ULL, 0x000fe200078e00ffULL, 0x0000620030307a10ULL, 0x000fe20007f5e0ffULL,
0x000001000f107825ULL, 0x000fe200078e0010ULL, 0x000063002f2f7a10ULL, 0x000fc40000ffe4ffULL,
0xfffffffc44457812ULL, 0x000fe200078ee209ULL, 0x00000010080f7824ULL, 0x100fe200078e0206ULL,
0x0000620010107a10ULL, 0x000fe20007f7e0ffULL, 0x0000001039397824ULL, 0x100fe200078e0206ULL,
0x0000630031317a10ULL, 0x000fe200017fe4ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0206ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000320f7faeULL, 0x0003e2000b901c48ULL,
0x000000103d3d7824ULL, 0x100fe200078e0206ULL, 0x0000630011117a10ULL, 0x000fe20001ffe4ffULL,
0x000000103f3f7824ULL, 0x100fe200078e0206ULL, 0x0000000034397faeULL, 0x0003e2000b901c48ULL,
0x0000001041417824ULL, 0x000fc400078e0206ULL, 0x0000001043437824ULL, 0x100fe200078e0206ULL,
0x00000000363b7faeULL, 0x0003e2000b901c48ULL, 0x0000001045457824ULL, 0x000fc600078e0206ULL,
0x00000000123d7faeULL, 0x0003e8000b901c48ULL, 0x000000002c3f7faeULL, 0x0003e8000b901c48ULL,
0x000000002e417faeULL, 0x0003e8000b901c48ULL, 0x0000000030437faeULL, 0x0003e8000b901c48ULL,
0x0000000010457faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000100d0f7824ULL, 0x002fe200078e00ffULL, 0x000000080c067810ULL, 0x000fc40007ffe0ffULL,
0x0000000a0c087810ULL, 0x000fe40007ffe0ffULL, 0xfffffff00f067812ULL, 0x040fe400078ee206ULL,
0xfffffff00f087812ULL, 0x000fc600078ee208ULL, 0x0000001006067824ULL, 0x000fe400078e00ffULL,
0x0000001008087824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000a10783bULL, 0x000fe80000000200ULL, 0x000000000640783bULL, 0x000e680000000200ULL,
0x000000005e4c783bULL, 0x000ea80000000200ULL, 0x000000006048783bULL, 0x000ee80000000200ULL,
0x000000006144783bULL, 0x000f280000000200ULL, 0x00000000623c783bULL, 0x000fe80000000200ULL,
0x00000000082c783bULL, 0x000ee80000000200ULL, 0x000000006338783bULL, 0x000ee80000000200ULL,
0x000000006434783bULL, 0x000ee80000000200ULL, 0x000000006730783bULL, 0x000ee20000000200ULL,
0x000000104054723cULL, 0x042f700000001854ULL, 0x000000124050723cULL, 0x040f700000001850ULL,
0x0000004c4014723cULL, 0x044f700000001814ULL, 0x0000004e4018723cULL, 0x040f700000001818ULL,
0x00000048401c723cULL, 0x048f70000000181cULL, 0x0000004a4020723cULL, 0x040f700000001820ULL,
0x000000444024723cULL, 0x050f700000001824ULL, 0x000000464028723cULL, 0x000b6e0000001828ULL,
0x0000030000407a10ULL, 0x020fe20007ffe0ffULL, 0x0000003c2c54723cULL, 0x000b660000001854ULL,
0x00000001400f7810ULL, 0x000fc80007ffe0ffULL, 0x000000660f00720cULL, 0x000fe20003f06070ULL,
0x00000100400f7824ULL, 0x000fe200078e0270ULL, 0x0000003e2c50723cULL, 0x000b660000001850ULL,
0x0000660068067a24ULL, 0x000fca00078e020fULL, 0x000000382c14723cULL, 0x040b700000001814ULL,
0x0000003a2c18723cULL, 0x040b700000001818ULL, 0x000000342c1c723cULL, 0x040b70000000181cULL,
0x000000362c20723cULL, 0x040b700000001820ULL, 0x000000302c24723cULL, 0x040b700000001824ULL,
0x000000322c28723cULL, 0x000b620000001828ULL, 0x000005b000008947ULL, 0x000fce0003800000ULL,
0x00000002ff357819ULL, 0x020fe40000011665ULL, 0x0000000f5c087217ULL, 0x000fc40007800000ULL,
0x0000001035397810ULL, 0x040fe20007ffe0ffULL, 0x0000000135107824ULL, 0x140fe200078e0206ULL,
0x0000000835377810ULL, 0x040fe20007ffe0ffULL, 0x0000000108087824ULL, 0x000fe200078e0a0fULL,
0x00000018353b7810ULL, 0x040fe20007ffe0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x00000020353d7810ULL, 0x040fe40007ffe0ffULL, 0x00000030353f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000139127824ULL, 0x100fe200078e0206ULL, 0x0000000e102e7212ULL, 0x000fe200078efcffULL,
0x00000001372c7824ULL, 0x000fe200078e0206ULL, 0x000000083900720cULL, 0x000fe20003fa6070ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x000062002e2e7a10ULL, 0x000fc40007f1e0ffULL,
0x000000083b00720cULL, 0x000fe20003f86070ULL, 0x000001002c2c7825ULL, 0x000fe200078e00ffULL,
0x0000000e12107212ULL, 0x080fe400078efcffULL, 0x00006300112f7a10ULL, 0x000fe200007fe4ffULL,
0x000000013b327824ULL, 0x000fe200078e0206ULL, 0x0000000e2c307212ULL, 0x000fe200078efcffULL,
0x00000004370a7824ULL, 0x000fe200078e00ffULL, 0x0000620010107a10ULL, 0x000fe20007f1e0ffULL,
0x0000010032327825ULL, 0x000fe200078e00ffULL, 0x0000620030307a10ULL, 0x000fc40007f3e0ffULL,
0x0000630013117a10ULL, 0x000fe200007fe4ffULL, 0x000000013d2c7824ULL, 0x000fe200078e0206ULL,
0x000000083500720cULL, 0x080fe20003f06070ULL, 0x000000043d347824ULL, 0x000fe200078e00ffULL,
0x000063002d317a10ULL, 0x000fe20000ffe4ffULL, 0x000001002c2c7825ULL, 0x000fe200078e00ffULL,
0x000000083700720cULL, 0x000fe40003f26070ULL, 0x0000000e32127212ULL, 0x000fe200078efcffULL,
0x000000043f387824ULL, 0x000fe200078e00ffULL, 0x0000002835377810ULL, 0x000fc40007ffe0ffULL,
0x0000620012127a10ULL, 0x000fe40007f5e0ffULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee209ULL,
0x0000000137327824ULL, 0x100fe200078e0206ULL, 0x0000630033137a10ULL, 0x000fe200017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e077faeULL, 0x0003e2000c101c48ULL,
0x0000000e2c2c7212ULL, 0x080fe200078efcffULL, 0x0000010032327825ULL, 0x000fe200078e00ffULL,
0x0000003835357810ULL, 0x000fe40007ffe0ffULL, 0x000062002c2c7a10ULL, 0x000fe20007f7e0ffULL,
0x000000100a0f7824ULL, 0x000fe200078e020bULL, 0x0000000e32327212ULL, 0x000fe200078efcffULL,
0x00000004390a7824ULL, 0x000fe200078e00ffULL, 0x000063002d2d7a10ULL, 0x000fe20001ffe4ffULL,
0x0000000437367824ULL, 0x000fe200078e00ffULL, 0x00000000300f7faeULL, 0x0005e2000c901c48ULL,
0x000000013f2e7824ULL, 0x102fe200078e0206ULL, 0x000000083d00720cULL, 0x080fe20003f66070ULL,
0x0000000135067824ULL, 0x000fe200078e0206ULL, 0x0000620032327a10ULL, 0x000fe20007fde0ffULL,
0x000001002e2e7825ULL, 0x000fe200078e00ffULL, 0x000000083700720cULL, 0x000fc40003f46070ULL,
0x000000083f00720cULL, 0x080fe20003f26070ULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x000000083500720cULL, 0x000fe40003f06070ULL, 0x0000000e2e087212ULL, 0x000fe200078efcffULL,
0x000000043b307824ULL, 0x004fe200078e00ffULL, 0x0000630033337a10ULL, 0x000fe200037fe4ffULL,
0x00000004353a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc0a0a7812ULL, 0x100fe400078ee209ULL,
0xfffffffc302e7812ULL, 0x000fc400078ee209ULL, 0xfffffffc34307812ULL, 0x000fe200078ee209ULL,
0x000000100a0f7824ULL, 0x000fe200078e020bULL, 0x0000620008087a10ULL, 0x000fe40007fde0ffULL,
0xfffffffc36347812ULL, 0x000fe200078ee209ULL, 0x0000001030317824ULL, 0x000fe200078e020bULL,
0x0000000e06067212ULL, 0x000fe200078efcffULL, 0x00000000100f7faeULL, 0x0003e2000e901c48ULL,
0xfffffffc38367812ULL, 0x000fe200078ee209ULL, 0x0000001034357824ULL, 0x000fe200078e020bULL,
0xfffffffc3a387812ULL, 0x000fc400078ee209ULL, 0x000063002f097a10ULL, 0x000fe200037fe4ffULL,
0x000000102e2f7824ULL, 0x100fe200078e020bULL, 0x0000620006067a10ULL, 0x000fe20007fde0ffULL,
0x0000001036377824ULL, 0x100fe400078e020bULL, 0x00000010380b7824ULL, 0x000fe200078e020bULL,
0x0000630007077a10ULL, 0x000fe200037fe4ffULL, 0x00000000122f7faeULL, 0x0003e8000e101c48ULL,
0x000000002c317faeULL, 0x0003e8000d901c48ULL, 0x0000000032357faeULL, 0x0003e8000d101c48ULL,
0x0000000008377faeULL, 0x0003e8000c901c48ULL, 0x00000000060b7faeULL, 0x0003e2000c101c48ULL,
0x000004f000007947ULL, 0x000fea0003800000ULL, 0x0000001065117811ULL, 0x040fe400078ff0ffULL,
0x00000008650f7811ULL, 0x000fc400078ff0ffULL, 0x00000020652d7811ULL, 0x020fe200078ff0ffULL,
0x00000004110a7824ULL, 0x000fe200078e00ffULL, 0x0000000665107211ULL, 0x000fe200078ff0ffULL,
0x000000010f2c7824ULL, 0x100fe200078e0206ULL, 0x00000028652f7811ULL, 0x000fe200078ff0ffULL,
0x00000001112e7824ULL, 0x100fe200078e0206ULL, 0x0000001865137811ULL, 0x000fe200078ff0ffULL,
0x000000040f087824ULL, 0x000fe200078e00ffULL, 0x0000003065337811ULL, 0x000fe200078ff0ffULL,
0x000000012d0f7824ULL, 0x100fe200078e0206ULL, 0x0000003865357811ULL, 0x000fe200078ff0ffULL,
0x000000042d367824ULL, 0x000fe200078e00ffULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee209ULL,
0x000000012f307824ULL, 0x000fc400078e0206ULL, 0x000000042f387824ULL, 0x000fe200078e00ffULL,
0xfffffffc36367812ULL, 0x000fe200078ee209ULL, 0x0000010010107825ULL, 0x000fc600078e00ffULL,
0xfffffffc38387812ULL, 0x000fe200078ee209ULL, 0x000001002c2c7825ULL, 0x000fc800078e00ffULL,
0x000001002e2e7825ULL, 0x000fc800078e00ffULL, 0x0000000413347824ULL, 0x000fe400078e00ffULL,
0x00000004333a7824ULL, 0x000fe400078e00ffULL, 0x00000004353c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc34347812ULL, 0x100fe200078ee209ULL, 0x0000000113127824ULL, 0x100fe200078e0206ULL,
0xfffffffc3a3a7812ULL, 0x100fe200078ee209ULL, 0x0000000133317824ULL, 0x100fe200078e0206ULL,
0xfffffffc3c3c7812ULL, 0x100fe200078ee209ULL, 0x0000000135327824ULL, 0x000fe200078e0206ULL,
0xfffffffc08067812ULL, 0x000fe200078ee209ULL, 0x000000100a377824ULL, 0x000fe200078e020bULL,
0x0000000e10087212ULL, 0x080fe200078efcffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000000e2c0a7212ULL, 0x000fc400078efcffULL, 0x0000000e2e107212ULL, 0x080fe200078efcffULL,
0x0000001006357824ULL, 0x100fe200078e020bULL, 0x0000620008087a10ULL, 0x000fe20007f1e0ffULL,
0x0000001034397824ULL, 0x100fe200078e020bULL, 0x000062000a0a7a10ULL, 0x000fe20007f3e0ffULL,
0x00000010363b7824ULL, 0x100fe200078e020bULL, 0x0000620010107a10ULL, 0x000fe20007f5e0ffULL,
0x00000010383d7824ULL, 0x100fe200078e020bULL, 0x0000630011097a10ULL, 0x000fe200007fe4ffULL,
0x000000103a3f7824ULL, 0x100fe200078e020bULL, 0x0000000e12127212ULL, 0x080fe200078efcffULL,
0x000000103c417824ULL, 0x000fe200078e020bULL, 0x000063002d0b7a10ULL, 0x000fe20000ffe4ffULL,
0x000001000f2c7825ULL, 0x000fe200078e00ffULL, 0x000063002f117a10ULL, 0x000fe200017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008077faeULL, 0x0003e2000b901c48ULL,
0x0000620012127a10ULL, 0x000fe20007f1e0ffULL, 0x00000100302e7825ULL, 0x000fe200078e00ffULL,
0x0000000e2c0f7212ULL, 0x080fe200078efcffULL, 0x000000000a357faeULL, 0x0003e2000b901c48ULL,
0x0000630013137a10ULL, 0x000fe200007fe4ffULL, 0x0000010031307825ULL, 0x000fe200078e00ffULL,
0x0000000e2e2c7212ULL, 0x080fe200078efcffULL, 0x0000000010377faeULL, 0x0003e4000b901c48ULL,
0x0000010032327825ULL, 0x000fe200078e00ffULL, 0x0000000e302e7212ULL, 0x000fe200078efcffULL,
0x0000000012397faeULL, 0x0003e2000b901c48ULL, 0x000062002c2c7a10ULL, 0x000fc40007f3e0ffULL,
0x0000000e32307212ULL, 0x000fe400078efcffULL, 0x000062000f0e7a10ULL, 0x000fe40007f1e0ffULL,
0x000062002e2e7a10ULL, 0x000fe40007f5e0ffULL, 0x0000620030307a10ULL, 0x000fe40007f7e0ffULL,
0x000063002d0f7a10ULL, 0x000fe400007fe4ffULL, 0x000063002f2d7a10ULL, 0x000fc40000ffe4ffULL,
0x00006300312f7a10ULL, 0x000fe200017fe4ffULL, 0x000000000e3b7faeULL, 0x0003e2000b901c48ULL,
0x0000630033317a10ULL, 0x000fc60001ffe4ffULL, 0x000000002c3d7faeULL, 0x0003e8000b901c48ULL,
0x000000002e3f7faeULL, 0x0003e8000b901c48ULL, 0x0000000030417faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000100d077824ULL, 0x002fe200078e00ffULL,
0x0000000c0c067810ULL, 0x000fc40007ffe0ffULL, 0x0000000e0c0c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff007067812ULL, 0x040fe400078ee206ULL, 0xfffffff007077812ULL, 0x000fc600078ee20cULL,
0x0000001006067824ULL, 0x000fe400078e00ffULL, 0x0000001007347824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000005f08783bULL, 0x000fe80000000200ULL,
0x000000000610783bULL, 0x000e680000000200ULL, 0x000000005b0c783bULL, 0x000ea80000000200ULL,
0x000000005a30783bULL, 0x000ee80000000200ULL, 0x000000005d2c783bULL, 0x000f280000000200ULL,
0x00000000053c783bULL, 0x000fe80000000200ULL, 0x000000003434783bULL, 0x000fe80000000200ULL,
0x000000000404783bULL, 0x000ee80000000200ULL, 0x000000005938783bULL, 0x000fe20000000200ULL,
0x000000081054723cULL, 0x042ff00000001854ULL, 0x0000000a1050723cULL, 0x040be40000001850ULL,
0x000000000308783bULL, 0x020e6c0000000200ULL, 0x0000000c101c723cULL, 0x044f70000000181cULL,
0x0000000e1020723cULL, 0x040f700000001820ULL, 0x000000301024723cULL, 0x048f700000001824ULL,
0x000000321028723cULL, 0x040f700000001828ULL, 0x0000002c1014723cULL, 0x050ff00000001814ULL,
0x0000002e1018723cULL, 0x000ff00000001818ULL, 0x00000004341c723cULL, 0x060f70000000181cULL,
0x000000063420723cULL, 0x040f700000001820ULL, 0x000000083424723cULL, 0x042b700000001824ULL,
0x0000000a3428723cULL, 0x000f640000001828ULL, 0x3db504f31c2e7820ULL, 0x020fe20000410000ULL,
0x3db504f31f1c7820ULL, 0x000fe20000410000ULL, 0x3db504f31d1d7820ULL, 0x000fe20000410000ULL,
0x3db504f31e1e7820ULL, 0x000fc60000410000ULL, 0x000000383454723cULL, 0x000f620000001854ULL,
0x3db504f3212d7820ULL, 0x000fe20000410000ULL, 0x3db504f320207820ULL, 0x000fe20000410000ULL,
0x3db504f322097820ULL, 0x000fe20000410000ULL, 0x3db504f3232c7820ULL, 0x000fc80000410000ULL,
0x0000003a3450723cULL, 0x000f620000001850ULL, 0x3db504f326217820ULL, 0x000fe20000410000ULL,
0x3db504f327267820ULL, 0x000fe20000410000ULL, 0x3db504f324037820ULL, 0x000fe20000410000ULL,
0x3db504f325047820ULL, 0x000fc80000410000ULL, 0x0000003c3414723cULL, 0x000f620000001814ULL,
0x3db504f3281f7820ULL, 0x000fe20000410000ULL, 0x3db504f329297820ULL, 0x000fe20000410000ULL,
0x3db504f32a277820ULL, 0x000fe20000410000ULL, 0x3db504f32b287820ULL, 0x000fc80000410000ULL,
0x0000003e3418723cULL, 0x000f640000001818ULL, 0x3db504f354547820ULL, 0x020fe20000410000ULL,
0x3db504f355557820ULL, 0x000fe20000410000ULL, 0x3db504f356567820ULL, 0x000fe20000410000ULL,
0x3db504f357577820ULL, 0x000fc60000410000ULL, 0x3db504f350507820ULL, 0x000fe20000410000ULL,
0x3db504f351127820ULL, 0x000fe20000410000ULL, 0x3db504f352137820ULL, 0x000fe20000410000ULL,
0x3db504f353117820ULL, 0x000fca0000410000ULL, 0x3db504f314107820ULL, 0x000fe20000410000ULL,
0x3db504f315157820ULL, 0x000fe20000410000ULL, 0x3db504f316067820ULL, 0x000fe20000410000ULL,
0x3db504f317077820ULL, 0x000fca0000410000ULL, 0x3db504f318187820ULL, 0x000fe20000410000ULL,
0x3db504f319307820ULL, 0x000fe20000410000ULL, 0x3db504f31a087820ULL, 0x000fe20000410000ULL,
0x3db504f31b2f7820ULL, 0x000fe20000410000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000ffff2a7224ULL, 0x000fe400078e0004ULL, 0x000000006e047f8cULL, 0x0002a2000c80043fULL,
0x000000ffff247224ULL, 0x000fe400078e001dULL, 0x000000ffff227224ULL, 0x000fe400078e0015ULL,
0x000000ffff237224ULL, 0x000fc400078e0018ULL, 0x000000ffff257224ULL, 0x000fe400078e0020ULL,
0x000000ffff1d7224ULL, 0x000fe400078e001eULL, 0x000000ffff177224ULL, 0x000fe400078e0054ULL,
0x000000ffff167224ULL, 0x000fe400078e0055ULL, 0x000000ffff147224ULL, 0x000fe400078e0050ULL,
0x000000ffff2b7224ULL, 0x000fc400078e0003ULL, 0x000000ffff207224ULL, 0x000fe400078e0029ULL,
0x000000ffff187224ULL, 0x000fe400078e0056ULL, 0x000000ffff157224ULL, 0x000fe400078e0057ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0006ULL, 0x000000ffff197224ULL, 0x000fe400078e0007ULL,
0x000000ffff1b7224ULL, 0x000fc400078e0008ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0009ULL,
0x0000000000067805ULL, 0x006fca0000015200ULL, 0x000004006e037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000806087210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011409ULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e0609ULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004006e037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000465297824ULL, 0x000fe200078e00ffULL,
0x0000006c0000720cULL, 0x000fc80003f06070ULL, 0xfffffff029037812ULL, 0x000fca00078ec0ffULL,
0x0000008002037824ULL, 0x000fca00078e0203ULL, 0x0134000003047984ULL, 0x0002a20000000c00ULL,
0x0000135000008947ULL, 0x000fea0003800000ULL, 0x0000000265007824ULL, 0x040fe200078e00ffULL,
0x000000585c097217ULL, 0x000fe20007800000ULL, 0x00000002ff427424ULL, 0x000fe200078e00ffULL,
0x0000006b65087211ULL, 0x000fe400078ff0ffULL, 0x0000000600007812ULL, 0x000fe200078ec0ffULL,
0x0000000109587824ULL, 0x000fe200078e0a58ULL, 0x00005a00ff0a7a19ULL, 0x000fe40000011608ULL,
0x0000580000317a10ULL, 0x000fe20007ffe0ffULL, 0x0000000169097824ULL, 0x000fe200078e0200ULL,
0x0000000a6d4f7217ULL, 0x000fc40003800000ULL, 0x000000583100720cULL, 0x080fe20003f06070ULL,
0x00000001090c7824ULL, 0x140fe200078e0a58ULL, 0x000000580900720cULL, 0x000fe20003f26070ULL,
0x0000004f6a4f7224ULL, 0x000fe200078e02ffULL, 0x0000000808097810ULL, 0x000fe20007ffe0ffULL,
0x0000000131087824ULL, 0x000fe200078e0a58ULL, 0x0000000c6d0c7217ULL, 0x040fe40003800000ULL,
0x0000001000377812ULL, 0x000fe400078efcffULL, 0x000000086d087217ULL, 0x000fc40003800000ULL,
0x00000004ff0c7819ULL, 0x000fe4000001160cULL, 0x000000ff08337207ULL, 0x000fe40000000000ULL,
0x00005a00ff0a7a19ULL, 0x000fe40000011609ULL, 0x000000ff0c087207ULL, 0x000fe20000800000ULL,
0x00000001693d7824ULL, 0x000fe200078e0237ULL, 0x0000580037397a10ULL, 0x000fe40007ffe0ffULL,
0x0000000a6d4d7217ULL, 0x000fe20003800000ULL, 0x000000014f0d7824ULL, 0x000fe200078e0208ULL,
0x0000004f330f7211ULL, 0x000fe200078fe0ffULL, 0x0000000139367824ULL, 0x100fe200078e0a58ULL,
0x000000583d00720cULL, 0x040fe20003f26070ULL, 0x000000013d387824ULL, 0x000fe200078e0a58ULL,
0x00000020003d7812ULL, 0x000fe200078efcffULL, 0x0000004d6a4d7224ULL, 0x000fc400078e02ffULL,
0x000060000f0e7625ULL, 0x000fe200078e0042ULL, 0x000000583900720cULL, 0x000fc60003f06070ULL,
0x000060000d0c7625ULL, 0x000fe200078e0042ULL, 0x000000366d367217ULL, 0x040fe20003800000ULL,
0x000000080e357981ULL, 0x000722000c1e9500ULL, 0x000000386d387217ULL, 0x000fe40003800000ULL,
0x000058003d3f7a10ULL, 0x000fe20007ffe0ffULL, 0x000000080c327981ULL, 0x000322000c1e9500ULL,
0x0000004d33097211ULL, 0x000fe400078fe0ffULL, 0x000000ff36367207ULL, 0x000fe20000000000ULL,
0x00000001080b7824ULL, 0x000fe200078e024dULL, 0x00000004ff387819ULL, 0x000fe20000011638ULL,
0x000000013f3c7824ULL, 0x000fc400078e0a58ULL, 0x0000600009087625ULL, 0x080fe200078e0042ULL,
0x0000004f360d7211ULL, 0x002fe400078fe0ffULL, 0x000000ff380c7207ULL, 0x000fe20000800000ULL,
0x000060000b0a7625ULL, 0x000fe200078e0042ULL, 0x000000583f00720cULL, 0x000fe20003f06070ULL,
0x0000000808347981ULL, 0x0042a2000c1e9500ULL, 0x0000003c6d3c7217ULL, 0x000fe20003800000ULL,
0x0000000169457824ULL, 0x000fe400078e023dULL, 0x000000014f0f7824ULL, 0x008fe200078e020cULL,
0x000000080a3b7981ULL, 0x0006a2000c1e9500ULL, 0x00000001453e7824ULL, 0x000fe200078e0a58ULL,
0x000000ff3c447207ULL, 0x000fe20000000000ULL, 0x000060000d087625ULL, 0x002fe200078e0042ULL,
0x000000584500720cULL, 0x000fc40003f26070ULL, 0x0000003000457812ULL, 0x000fe200078efcffULL,
0x000060000f0a7625ULL, 0x008fe200078e0042ULL, 0x0000004d360d7211ULL, 0x000fe200078fe0ffULL,
0x0000000808387981ULL, 0x0002e2000c1e9500ULL, 0x0000003e6d3e7217ULL, 0x000fe20003800000ULL,
0x000000010c0f7824ULL, 0x000fe400078e024dULL, 0x0000000169517824ULL, 0x000fe200078e0245ULL,
0x00000004ff3e7819ULL, 0x000fe2000001163eULL, 0x000060000d0c7625ULL, 0x080fe200078e0042ULL,
0x0000580045477a10ULL, 0x000fe20007ffe0ffULL, 0x000000080a417981ULL, 0x0002e4000c1e9500ULL,
0x0000004f44097211ULL, 0x002fe200078fe0ffULL, 0x000060000f0e7625ULL, 0x080fe200078e0042ULL,
0x000000ff3e3e7207ULL, 0x000fe20000800000ULL, 0x000000080c3a7981ULL, 0x0002e4000c1e9500ULL,
0x0000600009087625ULL, 0x000fc400078e0042ULL, 0x000000080e437981ULL, 0x0002e4000c1e9500ULL,
0x0000000151467824ULL, 0x000fe400078e0a58ULL, 0x00000008083c7981ULL, 0x0002e2000c1e9500ULL,
0x000000014f0b7824ULL, 0x000fe200078e023eULL, 0x0000004d440d7211ULL, 0x002fe400078fe0ffULL,
0x000000466d467217ULL, 0x000fe20003800000ULL, 0x000000013e0f7824ULL, 0x000fe400078e024dULL,
0x0000000147087824ULL, 0x040fe200078e0a58ULL, 0x000000584700720cULL, 0x000fe20003f06070ULL,
0x000060000b0a7625ULL, 0x000fe200078e0042ULL, 0x000000585100720cULL, 0x000fc40003f26070ULL,
0x000000086d087217ULL, 0x000fe20003800000ULL, 0x000060000d0c7625ULL, 0x080fe200078e0042ULL,
0x00000004ff097819ULL, 0x000fe20000011646ULL, 0x000000080a497981ULL, 0x0002e4000c1e9500ULL,
0x000060000f0e7625ULL, 0x000fe200078e0042ULL, 0x000000ff08467207ULL, 0x000fe20000000000ULL,
0x000000080c3e7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff09487207ULL, 0x000fc60000800000ULL,
0x000000080e4b7981ULL, 0x0002e2000c1e9500ULL, 0x0000004f46097211ULL, 0x000fe200078fe0ffULL,
0x000000014f0b7824ULL, 0x002fc800078e0248ULL, 0x0000600009087625ULL, 0x000fc800078e0042ULL,
0x000060000b0a7625ULL, 0x000fe400078e0042ULL, 0x0000000808087981ULL, 0x0002e2000c1e9500ULL,
0x0000004d460d7211ULL, 0x000fc600078fe0ffULL, 0x000000080a0b7981ULL, 0x0002e2000c1e9500ULL,
0x00000001480f7824ULL, 0x000fe400078e024dULL, 0x000060000d0c7625ULL, 0x000fc800078e0042ULL,
0x000060000f0e7625ULL, 0x000fe400078e0042ULL, 0x000000080c0c7981ULL, 0x0002e8000c1e9500ULL,
0x000000080e4d7981ULL, 0x0002e4000c1e9500ULL, 0xfffffff0330a7812ULL, 0x002fe400078ec0ffULL,
0x0000000100737812ULL, 0x000fc400078efcffULL, 0x0000000800717812ULL, 0x000fe200078efcffULL,
0x00000001580a7824ULL, 0x000fe200078e020aULL, 0x0000000900677812ULL, 0x000fe200078efcffULL,
0x00000001ff427424ULL, 0x000fe200078e00ffULL, 0x0000580073797a10ULL, 0x000fe20007ffe0ffULL,
0x00000001310e7824ULL, 0x100fe200078e0a0aULL, 0x0000580071777a10ULL, 0x000fe40007ffe0ffULL,
0x0000580067757a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff036487812ULL, 0x000fe200078ec0ffULL,
0x0000000179367824ULL, 0x100fe200078e0a0aULL, 0xfffffff0444a7812ULL, 0x000fe200078ec0ffULL,
0x0000000177447824ULL, 0x100fe200078e0a0aULL, 0xfffffff0464c7812ULL, 0x000fe200078ec0ffULL,
0x0000000175467824ULL, 0x000fe200078e0a0aULL, 0x0000000e420a7219ULL, 0x000fc400000006ffULL,
0x00000011005d7812ULL, 0x000fe400078efcffULL, 0x00000036420e7219ULL, 0x000fe400000006ffULL,
0x00000018005b7812ULL, 0x000fe400078efcffULL, 0x0000004442367219ULL, 0x040fe400000006ffULL,
0x0000004642447219ULL, 0x000fe200000006ffULL, 0x0000000158487824ULL, 0x000fe200078e0248ULL,
0x0000001900597812ULL, 0x000fc400078efcffULL, 0x000058005d637a10ULL, 0x000fe40007ffe0ffULL,
0x000058005b617a10ULL, 0x000fe20007ffe0ffULL, 0x0000000158727824ULL, 0x000fe200078e024cULL,
0x00005800595f7a10ULL, 0x000fe20007ffe0ffULL, 0x00000001394c7824ULL, 0x100fe400078e0a48ULL,
0x0000000163507824ULL, 0x100fe400078e0a48ULL, 0x0000000161527824ULL, 0x100fe400078e0a48ULL,
0x000000015f5a7824ULL, 0x000fe200078e0a48ULL, 0x0000004c42487219ULL, 0x000fc400000006ffULL,
0x00000050424c7219ULL, 0x040fe400000006ffULL, 0x0000005242507219ULL, 0x000fe200000006ffULL,
0x00000001584a7824ULL, 0x000fc800078e024aULL, 0x000000013f547824ULL, 0x000fe200078e0a4aULL,
0x0000002100537812ULL, 0x040fe400078efcffULL, 0x0000002800517812ULL, 0x040fe400078efcffULL,
0x00000029004f7812ULL, 0x000fe400078efcffULL, 0x0000005a425a7219ULL, 0x040fe400000006ffULL,
0x0000005442547219ULL, 0x000fe400000006ffULL, 0x0000580053577a10ULL, 0x000fc40007ffe0ffULL,
0x0000580051557a10ULL, 0x000fe40007ffe0ffULL, 0x000058004f337a10ULL, 0x000fe20007ffe0ffULL,
0x0000000157647824ULL, 0x100fe400078e0a4aULL, 0x0000000155607824ULL, 0x100fe400078e0a4aULL,
0x0000000133627824ULL, 0x000fe400078e0a4aULL, 0x00000001475e7824ULL, 0x000fe200078e0a72ULL,
0x00000031000f7812ULL, 0x000fc400078efcffULL, 0x00000038000d7812ULL, 0x040fe400078efcffULL,
0x0000003900097812ULL, 0x000fe400078efcffULL, 0x0000006442527219ULL, 0x040fe400000006ffULL,
0x0000006042607219ULL, 0x040fe400000006ffULL, 0x0000006242627219ULL, 0x040fe400000006ffULL,
0x0000005e425e7219ULL, 0x000fc400000006ffULL, 0x000058000f7b7a10ULL, 0x000fe40007ffe0ffULL,
0x000058000d7d7a10ULL, 0x000fe40007ffe0ffULL, 0x0000580009467a10ULL, 0x000fe20007ffe0ffULL,
0x000000017b567824ULL, 0x100fe400078e0a72ULL, 0x000000017d4e7824ULL, 0x100fe400078e0a72ULL,
0x00000001464a7824ULL, 0x000fe200078e0a72ULL, 0x0000005642567219ULL, 0x000fc400000006ffULL,
0x0000004e424e7219ULL, 0x040fe400000006ffULL, 0x0000004a424a7219ULL, 0x000fe400000006ffULL,
0x0000541035357816ULL, 0x010fc80000000032ULL, 0x000000350aff7212ULL, 0x000fc8000780c0ffULL,
0x000000583100720cULL, 0x000fc80000701470ULL, 0x000000580000720cULL, 0x000fc80000701070ULL,
0xff80000017177808ULL, 0x000fe40000000000ULL, 0x00005410343b7816ULL, 0x004fc8000000003bULL,
0x0000003b0aff7212ULL, 0x080fe4000788c0ffULL, 0x0000003b36ff7212ULL, 0x080fe400078cc0ffULL,
0x0000003b44ff7212ULL, 0x000fe4000780c0ffULL, 0x000000583100720cULL, 0x080fe40002781470ULL,
0x000000587700720cULL, 0x080fe400037c1470ULL, 0x000000587500720cULL, 0x000fc40000701470ULL,
0x0000003544ff7212ULL, 0x000fe4000782c0ffULL, 0x000000580000720cULL, 0x080fe40002781070ULL,
0x000000587100720cULL, 0x080fe400037c1070ULL, 0x000000586700720cULL, 0x080fe40000701070ULL,
0x0000541038417816ULL, 0x008fe40000000041ULL, 0x000000587500720cULL, 0x000fc40000f21470ULL,
0x000054103a437816ULL, 0x000fe40000000043ULL, 0xff80000018187808ULL, 0x000fe40002000000ULL,
0xff80000013137808ULL, 0x000fe40003000000ULL, 0xff80000011117808ULL, 0x000fe40000000000ULL,
0x000000350eff7212ULL, 0x080fe4000786c0ffULL, 0x0000003536ff7212ULL, 0x000fc4000784c0ffULL,
0x0000003b0eff7212ULL, 0x000fe400078ac0ffULL, 0x0000004148ff7212ULL, 0x040fe4000788c0ffULL,
0x0000004348ff7212ULL, 0x080fe400078cc0ffULL, 0x0000004350ff7212ULL, 0x000fe4000780c0ffULL,
0x000000586700720cULL, 0x080fe40000f21070ULL, 0x000000587900720cULL, 0x000fc40001f61470ULL,
0x000000587900720cULL, 0x080fe40002fa1470ULL, 0x000000587700720cULL, 0x080fe40001741470ULL,
0x000000583900720cULL, 0x0c0fe40002781470ULL, 0x000000583900720cULL, 0x080fe400037c1470ULL,
0x000000586100720cULL, 0x000fe40000701470ULL, 0xff80000012127808ULL, 0x000fc40000800000ULL,
0x000000587300720cULL, 0x0c0fe40001f61070ULL, 0x000000587300720cULL, 0x080fe40002fa1070ULL,
0x000000587100720cULL, 0x080fe40001741070ULL, 0x000000583700720cULL, 0x0c0fe40002721070ULL,
0x000000583700720cULL, 0x080fe400037c1070ULL, 0x000000585b00720cULL, 0x000fc40000701070ULL,
0x000054103c497816ULL, 0x000fe40000000049ULL, 0x000054103e4b7816ULL, 0x000fe4000000004bULL,
0xff80000016167808ULL, 0x000fe40001800000ULL, 0xff80000015157808ULL, 0x000fe40002800000ULL,
0xff80000014147808ULL, 0x000fe40001000000ULL, 0xff80000010107808ULL, 0x000fc40000800000ULL,
0xff8000001a1a7808ULL, 0x000fe40003000000ULL, 0xff8000001b1b7808ULL, 0x000fe40000000000ULL,
0x000000414cff7212ULL, 0x080fe4000786c0ffULL, 0x0000004150ff7212ULL, 0x080fe400078ac0ffULL,
0x000000415aff7212ULL, 0x000fe4000784c0ffULL, 0x000000434cff7212ULL, 0x000fc4000788c0ffULL,
0x000000435aff7212ULL, 0x000fe4000782c0ffULL, 0x0000004954ff7212ULL, 0x040fe400078cc0ffULL,
0x0000004b54ff7212ULL, 0x000fe4000780c0ffULL, 0x000000586300720cULL, 0x0c0fe40001f61470ULL,
0x000000586300720cULL, 0x080fe40002781470ULL, 0x000000586100720cULL, 0x000fc40002fa1470ULL,
0x000000585f00720cULL, 0x0c0fe40001741470ULL, 0x000000585f00720cULL, 0x080fe40000f21470ULL,
0x000000583f00720cULL, 0x0c0fe400037c1470ULL, 0x000000583f00720cULL, 0x080fe40000701470ULL,
0x000000585d00720cULL, 0x0c0fe40001f61070ULL, 0x000000585d00720cULL, 0x000fc40002781070ULL,
0x000000585b00720cULL, 0x080fe40002fa1070ULL, 0x000000585900720cULL, 0x0c0fe40001741070ULL,
0x000000585900720cULL, 0x080fe40000f21070ULL, 0x000000583d00720cULL, 0x0c0fe400037c1070ULL,
0x000000583d00720cULL, 0x000fe40000701070ULL, 0x00005410080b7816ULL, 0x000fc4000000000bULL,
0xff80000022227808ULL, 0x000fe40001800000ULL, 0xff80000019197808ULL, 0x000fe40002000000ULL,
0xff80000023237808ULL, 0x000fe40002800000ULL, 0xff80000030307808ULL, 0x000fe40001000000ULL,
0xff8000002f2f7808ULL, 0x000fe40000800000ULL, 0xff8000002e2e7808ULL, 0x000fc40003000000ULL,
0xff8000001d1d7808ULL, 0x000fe40000000000ULL, 0x0000004952ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004960ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004962ff7212ULL, 0x000fe400078ac0ffULL,
0x0000004b52ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004b60ff7212ULL, 0x000fc4000782c0ffULL,
0x0000004b62ff7212ULL, 0x000fe400078cc0ffULL, 0x0000000b5eff7212ULL, 0x000fe4000780c0ffULL,
0x000000585700720cULL, 0x0c0fe40001f61470ULL, 0x000000585700720cULL, 0x080fe40001741470ULL,
0x000000585500720cULL, 0x0c0fe40002781470ULL, 0x000000585500720cULL, 0x000fc40000f21470ULL,
0x000000583300720cULL, 0x0c0fe40002fa1470ULL, 0x000000583300720cULL, 0x080fe400037c1470ULL,
0x000000584700720cULL, 0x080fe40000701470ULL, 0x000000585300720cULL, 0x0c0fe40001f61070ULL,
0x000000585300720cULL, 0x080fe40001741070ULL, 0x000000585100720cULL, 0x000fc40002781070ULL,
0x000000585100720cULL, 0x080fe40000f21070ULL, 0x000000584f00720cULL, 0x0c0fe40002fa1070ULL,
0x000000584f00720cULL, 0x080fe400037c1070ULL, 0x000000584500720cULL, 0x000fe40000701070ULL,
0x000054100c4d7816ULL, 0x000fe4000000004dULL, 0xff80000024247808ULL, 0x000fc40001800000ULL,
0xff8000001c1c7808ULL, 0x000fe40001000000ULL, 0xff80000025257808ULL, 0x000fe40002000000ULL,
0xff8000001e1e7808ULL, 0x000fe40000800000ULL, 0xff8000002d2d7808ULL, 0x000fe40002800000ULL,
0xff8000002c2c7808ULL, 0x000fe40003000000ULL, 0xff8000002b2b7808ULL, 0x000fc40000000000ULL,
0x0000000b56ff7212ULL, 0x080fe4000786c0ffULL, 0x0000000b4eff7212ULL, 0x080fe4000784c0ffULL,
0x0000000b4aff7212ULL, 0x000fe4000788c0ffULL, 0x0000004d5eff7212ULL, 0x080fe4000782c0ffULL,
0x0000004d56ff7212ULL, 0x080fe400078ac0ffULL, 0x0000004d4eff7212ULL, 0x000fc400078cc0ffULL,
0x0000004d4aff7212ULL, 0x000fe4000780c0ffULL, 0x000000584700720cULL, 0x080fe40000f21470ULL,
0x000000587b00720cULL, 0x0c0fe40001f61470ULL, 0x000000587b00720cULL, 0x080fe40002fa1470ULL,
0x000000587d00720cULL, 0x0c0fe40001741470ULL, 0x000000587d00720cULL, 0x000fc400037c1470ULL,
0x000000584600720cULL, 0x0c0fe40002781470ULL, 0x000000584600720cULL, 0x080fe40000701470ULL,
0x000000584500720cULL, 0x080fe40000f21070ULL, 0x000000580f00720cULL, 0x0c0fe40001f61070ULL,
0x000000580f00720cULL, 0x080fe40002fa1070ULL, 0x000000580d00720cULL, 0x000fc40001741070ULL,
0x000000580d00720cULL, 0x080fe400037c1070ULL, 0x000000580900720cULL, 0x0c0fe40002781070ULL,
0x000000580900720cULL, 0x000fe40000701070ULL, 0xff8000002a2a7808ULL, 0x000fe40001800000ULL,
0xff8000001f1f7808ULL, 0x000fe40001000000ULL, 0xff80000020207808ULL, 0x000fc40002000000ULL,
0xff80000021217808ULL, 0x000fe40000800000ULL, 0xff80000026267808ULL, 0x000fe40002800000ULL,
0xff80000027277808ULL, 0x000fe40003000000ULL, 0xff80000028287808ULL, 0x000fc40000000000ULL,
0x000000170400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff0d7424ULL, 0x000fe200078e00ffULL,
0x000000180500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff327424ULL, 0x000fe200078e00ffULL,
0x0000000417097208ULL, 0x000fc40004000000ULL, 0x0000000518007208ULL, 0x000fe40004800000ULL,
0x000000160900720bULL, 0x000fe40003f1e000ULL, 0x000000150000720bULL, 0x000fe40003f3e000ULL,
0x0000000916097208ULL, 0x000fe40004000000ULL, 0x0000000015007208ULL, 0x000fe40004800000ULL,
0x000000140900720bULL, 0x000fc40003f1e000ULL, 0x000000130000720bULL, 0x000fe40003f3e000ULL,
0x0000000914097208ULL, 0x000fe40004000000ULL, 0x0000000013007208ULL, 0x000fe40004800000ULL,
0x000000120900720bULL, 0x000fe40003f1e000ULL, 0x000000110000720bULL, 0x000fe40003f3e000ULL,
0x0000000912097208ULL, 0x000fc40004000000ULL, 0x0000000011057208ULL, 0x000fe40004800000ULL,
0x000000100900720bULL, 0x000fe40003f1e000ULL, 0x0000001a0500720bULL, 0x000fe40003f3e000ULL,
0x0000000910097208ULL, 0x000fe40004000000ULL, 0x000000051a007208ULL, 0x000fe40004800000ULL,
0x000000220900720bULL, 0x000fc40003f1e000ULL, 0x000000190000720bULL, 0x000fe40003f3e000ULL,
0x0000000922047208ULL, 0x000fe40004000000ULL, 0x0000000019007208ULL, 0x000fe40004800000ULL,
0x000000230400720bULL, 0x000fe40003f1e000ULL, 0x0000001b0000720bULL, 0x000fe40003f3e000ULL,
0x0000000423057208ULL, 0x000fc40004000000ULL, 0x000000001b007208ULL, 0x000fe40004800000ULL,
0x000000300500720bULL, 0x000fe40003f1e000ULL, 0x0000002f0000720bULL, 0x000fe40003f3e000ULL,
0x0000000530057208ULL, 0x000fe40004000000ULL, 0x000000002f007208ULL, 0x000fe40004800000ULL,
0x0000002e0500720bULL, 0x000fc40003f1e000ULL, 0x0000001d0000720bULL, 0x000fe40003f3e000ULL,
0x000000052e057208ULL, 0x000fe40004000000ULL, 0x000000001d097208ULL, 0x000fe40004800000ULL,
0x000000240500720bULL, 0x000fe40003f1e000ULL, 0x0000001c0900720bULL, 0x000fe40003f3e000ULL,
0x0000000524007208ULL, 0x000fc40004000000ULL, 0x000000091c097208ULL, 0x000fe40004800000ULL,
0x000000250000720bULL, 0x000fe40003f1e000ULL, 0x0000001e0900720bULL, 0x000fe40003f3e000ULL,
0x0000000025007208ULL, 0x000fe40004000000ULL, 0x000000091e097208ULL, 0x000fe40004800000ULL,
0x0000002d0000720bULL, 0x000fc40003f1e000ULL, 0x0000002c0900720bULL, 0x000fe40003f3e000ULL,
0x000000002d007208ULL, 0x000fe40004000000ULL, 0x000000092c047208ULL, 0x000fe40004800000ULL,
0x0000002b0000720bULL, 0x000fe40003f1e000ULL, 0x000000210400720bULL, 0x000fe40003f3e000ULL,
0x000000002b057208ULL, 0x000fc40004000000ULL, 0x0000000421097208ULL, 0x000fe40004800000ULL,
0x0000002a0500720bULL, 0x000fe40003f1e000ULL, 0x000000260900720bULL, 0x000fe40003f3e000ULL,
0x000000052a007208ULL, 0x000fe40004000000ULL, 0x0000000926047208ULL, 0x000fe40004800000ULL,
0x0000001f0000720bULL, 0x000fc40003f1e000ULL, 0x000000270400720bULL, 0x000fe40003f3e000ULL,
0x000000001f057208ULL, 0x000fe40004000000ULL, 0x0000000427097208ULL, 0x000fe40004800000ULL,
0x000000200500720bULL, 0x000fe40003f1e000ULL, 0x000000280900720bULL, 0x000fe40003f3e000ULL,
0x00000005200a7208ULL, 0x000fc40004000000ULL, 0x00000009280c7208ULL, 0x000fe20004800000ULL,
0x000014227f007947ULL, 0x000fec000b800000ULL, 0x0c401f000a007f89ULL, 0x0004e400000e0000ULL,
0x000000000a00720bULL, 0x008fc80003f1e000ULL, 0x0000000a000e7208ULL, 0x000fe20004000000ULL,
0x000014327f007947ULL, 0x000fea000b800000ULL, 0x0c401f000c007f89ULL, 0x000ee800000e0000ULL,
0x0c401f0006057f89ULL, 0x000f2800000e0000ULL, 0x0c401f0007047f89ULL, 0x000e6200000e0000ULL,
0x000000000c00720bULL, 0x008fc40003f1e000ULL, 0x000000050600720bULL, 0x010fe40003f3e000ULL,
0x0000000c00087208ULL, 0x000fe40004000000ULL, 0x0000000605097208ULL, 0x000fe40004800000ULL,
0x0c201f000e057f89ULL, 0x000ee200000e0000ULL, 0x000000040700720bULL, 0x002fc60003f1e000ULL,
0x0c201f00080b7f89ULL, 0x000e6200000e0000ULL, 0x0000000704007208ULL, 0x000fc60004000000ULL,
0x0c201f00090a7f89ULL, 0x004ea800000e0000ULL, 0x0c201f0000317f89ULL, 0x0002a200000e0000ULL,
0x000000050e00720bULL, 0x008fe40003f1e000ULL, 0x0000000b0800720bULL, 0x002fe40003f3e000ULL,
0x0000000e05047208ULL, 0x000fe40004000000ULL, 0x0000000a0900720bULL, 0x004fc40003f5e000ULL,
0x000000080b057208ULL, 0x000fe40004800000ULL, 0x000000090a067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04097820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000c29297812ULL, 0x000fe400078ec0ffULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010809ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010809ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010809ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010809ULL, 0x00000014000a7308ULL, 0x0023e20000000800ULL,
0x3fb8aa3b23077823ULL, 0x100fe20000010809ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010809ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010809ULL, 0x3fb8aa3b2e237823ULL, 0x100fe20000010809ULL,
0x3fb8aa3b242e7823ULL, 0x100fe20000010809ULL, 0x3fb8aa3b25247823ULL, 0x100fe20000010809ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010809ULL, 0x00000022000f7308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b05147820ULL, 0x002fe20000410000ULL, 0x3fb8aa3b2d257823ULL, 0x100fe20000010809ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010809ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010809ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010814ULL,
0x00000007000e7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b2a227823ULL, 0x108fe20000010809ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010814ULL,
0x0000001700087308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b077823ULL, 0x002fe20000010809ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b28287823ULL, 0x000fe20000010814ULL,
0x00000016000b7308ULL, 0x000e620000000800ULL, 0x0000000365ff7812ULL, 0x000fc4000780c0ffULL,
0x000000310000720bULL, 0x004fca0003f3e000ULL, 0x00000012000d7308ULL, 0x000eb00000000800ULL,
0x00000010000c7308ULL, 0x000ee20000000800ULL, 0x000000080b08723eULL, 0x002fce00000000ffULL,
0x0000001800097308ULL, 0x0003e20000000800ULL, 0x0000000a0d0a723eULL, 0x004fce00000000ffULL,
0x0000001500107308ULL, 0x000ea20000000800ULL, 0x3c003c00ff187424ULL, 0x002fe200078e00ffULL,
0x0000000c0f0c723eULL, 0x008fcc00000000ffULL, 0x0000001300137308ULL, 0x000ff00000000800ULL,
0x0000001100127308ULL, 0x000e620000000800ULL, 0x000000091009723eULL, 0x004fce00000000ffULL,
0x00000019002b7308ULL, 0x0005e20000000800ULL, 0x00000013120b723eULL, 0x002fe200000000ffULL,
0x3c003c00ff197424ULL, 0x004fcc00078e00ffULL, 0x0000003000177308ULL, 0x000e620000000800ULL,
0x000000180810723cULL, 0x000f6e00000018ffULL, 0x0000001a001a7308ULL, 0x000eb00000000800ULL,
0x0000001b001b7308ULL, 0x000fe20000000800ULL, 0x0000000e170e723eULL, 0x002fce00000000ffULL,
0x0000002f00167308ULL, 0x000e620000000800ULL, 0x0000001a2b0d723eULL, 0x004fe400000000ffULL,
0x00000002ff1a7819ULL, 0x000fc80000011665ULL, 0x000000021a2b7810ULL, 0x040fe20007ffe0ffULL,
0x0000002300237308ULL, 0x000fe20000000800ULL, 0x000000081a327824ULL, 0x040fe400078e00ffULL,
0x000000081a367824ULL, 0x040fe400078e00ffULL, 0x000000081a2a7824ULL, 0x000fe200078e00ffULL,
0x0000001b160f723eULL, 0x002fe400000000ffULL, 0x0000002e002e7308ULL, 0x000e620000000800ULL,
0x000000011a1b7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee21bULL,
0x000000180c14723cULL, 0x020b620000001810ULL, 0x000000051a1b7810ULL, 0x040fe20007ffe0ffULL,
0x0000002400247308ULL, 0x000fea0000000800ULL, 0x000000081a137824ULL, 0x060fe200078e00ffULL,
0x000000031a107810ULL, 0x040fe40007ffe0ffULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x000000041a117810ULL, 0x000fc40007ffe0ffULL, 0xfffffff813307812ULL, 0x000fe400078ee210ULL,
0xfffffff832327812ULL, 0x000fe400078ee211ULL, 0x000000232e10723eULL, 0x002fe200000000ffULL,
0x0000001d001d7308ULL, 0x000fe20000000800ULL, 0x000000081a237824ULL, 0x040fe400078e00ffULL,
0x000000081a2e7824ULL, 0x000fca00078e00ffULL, 0x0000001c001c7308ULL, 0x000e620000000800ULL,
0x000000242512723eULL, 0x004fe200000000ffULL, 0x000000081a257824ULL, 0x000fe200078e00ffULL,
0xfffffff823247812ULL, 0x000fe400078ee21aULL, 0xfffffff82e2e7812ULL, 0x000fc600078ee21bULL,
0x0000001e001e7308ULL, 0x000ff00000000800ULL, 0x0000002c002d7308ULL, 0x0004e20000000800ULL,
0x0000001d1c11723eULL, 0x002fe400000000ffULL, 0x000000061a1c7810ULL, 0x000fc40007ffe0ffULL,
0xffffffff1a1d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff825347812ULL, 0x000fe200078ee21cULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0xfffffff836367812ULL, 0x000fe200078ee21dULL,
0x000000081a2c7824ULL, 0x004fca00078e00ffULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee22bULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x0000001e2d13723eULL, 0x008fe400000000ffULL,
0x000000081a1e7810ULL, 0x000fca0007ffe0ffULL, 0x000000181014723cULL, 0x000f620000001814ULL,
0x0000000700077308ULL, 0x000fe20000000800ULL, 0x000000081e237824ULL, 0x000fca00078e00ffULL,
0xfffffff823387812ULL, 0x000fe400078ee21eULL, 0x0000002200227308ULL, 0x000ea20000000800ULL,
0x0000001f201e723eULL, 0x002fce00000000ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x00000007221c723eULL, 0x004fe400000000ffULL,
0x0000900002077811ULL, 0x000fca00078e58ffULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x00000010241a7824ULL, 0x100fe400078e0207ULL, 0x000000102a207824ULL, 0x100fe400078e0207ULL,
0x0000001030227824ULL, 0x100fe400078e0207ULL, 0x0000001032237824ULL, 0x100fe200078e0207ULL,
0x0000002800287308ULL, 0x000ea20000000800ULL, 0x00000021261d723eULL, 0x002fe200000000ffULL,
0x000000102c217824ULL, 0x000fc400078e0207ULL, 0x00000001291b7824ULL, 0x040fe400078e021aULL,
0x000000102e1a7824ULL, 0x100fe400078e0207ULL, 0x0000000129207824ULL, 0x040fe200078e0220ULL,
0x000000081b007388ULL, 0x0003e20000000800ULL, 0x0000001034247824ULL, 0x000fe400078e0207ULL,
0x0000000129217824ULL, 0x040fe200078e0221ULL, 0x0000000a20007388ULL, 0x0003e20000000800ULL,
0x0000001036257824ULL, 0x100fe200078e0207ULL, 0x00000027281f723eULL, 0x004fe200000000ffULL,
0x0000000129227824ULL, 0x000fe200078e0222ULL, 0x0000000c21007388ULL, 0x0003e20000000800ULL,
0x0000001038077824ULL, 0x000fc400078e0207ULL, 0x0000000129237824ULL, 0x040fe200078e0223ULL,
0x0000000e22007388ULL, 0x0003e20000000800ULL, 0x000000181c14723cULL, 0x020b620000001814ULL,
0x00000001291a7824ULL, 0x040fe400078e021aULL, 0x0000000129247824ULL, 0x040fe200078e0224ULL,
0x0000001023007388ULL, 0x0003e20000000800ULL, 0x0000000129257824ULL, 0x040fe400078e0225ULL,
0x0000000129187824ULL, 0x020fe200078e0207ULL, 0x000000121a007388ULL, 0x0003e20000000800ULL,
0x0000000031077208ULL, 0x000fc60004800000ULL, 0x0000001c24007388ULL, 0x0003e80000000800ULL,
0x0000001e25007388ULL, 0x0003e80000000800ULL, 0x0000000918007388ULL, 0x0003e80000000800ULL,
0x0004000b20007388ULL, 0x0003e20000000800ULL, 0x000000ffff157224ULL, 0x000fc600078e0016ULL,
0x0004000d21007388ULL, 0x0003e80000000800ULL, 0x0004000f22007388ULL, 0x0003e80000000800ULL,
0x0004001123007388ULL, 0x0003e80000000800ULL, 0x000400131a007388ULL, 0x0003e80000000800ULL,
0x0004001d24007388ULL, 0x0003e80000000800ULL, 0x0004001f25007388ULL, 0x0003e80000000800ULL,
0x0130000403008388ULL, 0x0003e80000000c00ULL, 0x0132001403008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x013608006fff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x013610006fff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x013618006fff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000664000720cULL, 0x000fe20003f06070ULL,
0x013620006fff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff007224ULL, 0x000fd600078e0040ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff9d9000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0c7807ULL, 0x004fe40004000000ULL,
0x00012dc0000e7802ULL, 0x000fc40000000f00ULL, 0x00000bb000007944ULL, 0x008fea0003c00000ULL,
0xfffefaa000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40005000000ULL,
0x00012e00000e7802ULL, 0x000fc40000000f00ULL, 0x00000b7000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff317224ULL, 0x000fe200078e000cULL, 0xfffefb1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0033ULL, 0x00012e50000f7802ULL, 0x000fc40000000f00ULL,
0x00000ad000007944ULL, 0x008fea0003c00000ULL, 0xfffefbf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0033ULL, 0x00012e90000f7802ULL, 0x000fc40000000f00ULL,
0x00000a9000007944ULL, 0x00afea0003c00000ULL, 0xfffefd1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00012ee0000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0008ULL, 0x00000a4000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000cULL, 0xfffefec000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00012f30000f7802ULL, 0x000fc40000000f00ULL,
0x000009f000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000cULL,
0xfffefea000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x004fe40004000000ULL,
0x00012f80000e7802ULL, 0x000fc40000000f00ULL, 0x000009f000007944ULL, 0x008fea0003c00000ULL,
0xffff142000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40004800000ULL,
0x00012fc0000e7802ULL, 0x000fc40000000f00ULL, 0x000009b000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e000cULL, 0xffff147000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00013010000f7802ULL, 0x000fc40000000f00ULL,
0x0000091000007944ULL, 0x008fea0003c00000ULL, 0xffff156000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00013050000f7802ULL, 0x000fc40000000f00ULL,
0x000008d000007944ULL, 0x00afea0003c00000ULL, 0xffff168000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0009ULL, 0x000130a0000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e000aULL, 0x0000088000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000cULL, 0xffff183000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0009ULL, 0x000130f0000f7802ULL, 0x000fc40000000f00ULL,
0x0000083000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000cULL,
0xffff181000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x008fe40004000000ULL,
0x00013140000e7802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x002fea0003c00000ULL,
0xffff2b9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40004800000ULL,
0x00013180000e7802ULL, 0x000fc40000000f00ULL, 0x000007f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e000cULL, 0xffff2be000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0031ULL, 0x000131d0000f7802ULL, 0x000fc40000000f00ULL,
0x0000075000007944ULL, 0x000fea0003c00000ULL, 0xffff2cd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0031ULL, 0x00013210000f7802ULL, 0x000fc40000000f00ULL,
0x0000071000007944ULL, 0x002fea0003c00000ULL, 0xffff2df000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0004ULL, 0x00013260000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e000dULL, 0x000006c000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000cULL, 0xffff2fa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0004ULL, 0x000132b0000f7802ULL, 0x000fc40000000f00ULL,
0x0000067000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000cULL,
0xffff2f8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x004fe40004000000ULL,
0x00013300000e7802ULL, 0x000fc40000000f00ULL, 0x0000067000007944ULL, 0x008fea0003c00000ULL,
0xffff43a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40004800000ULL,
0x00013340000e7802ULL, 0x000fc40000000f00ULL, 0x0000063000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e000cULL, 0xffff43e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0013ULL, 0x00013390000f7802ULL, 0x000fc40000000f00ULL,
0x0000059000007944ULL, 0x008fea0003c00000ULL, 0xffff44d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0013ULL, 0x000133d0000f7802ULL, 0x000fc40000000f00ULL,
0x0000055000007944ULL, 0x00afea0003c00000ULL, 0xffff45f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00013420000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fc400078e0010ULL, 0x0000050000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000cULL, 0xffff47a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000dULL, 0x00013470000f7802ULL, 0x000fc40000000f00ULL,
0x000004b000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000cULL,
0xffff478000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0b7424ULL, 0x000fe200078e00ffULL,
0x000134c000087802ULL, 0x000fc40000000f00ULL, 0x0000042000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e0031ULL, 0xffffeba000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0a7224ULL, 0x006fe200078e000cULL, 0x0001352000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0b7424ULL, 0x000fc400078e00ffULL, 0x000003c000007944ULL, 0x000fea0003c00000ULL,
0x000000310c00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e0006ULL,
0x0001358000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000c310c7208ULL, 0x000fc80004000000ULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0x000000310600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e0007ULL,
0x000135e000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000631067208ULL, 0x000fc80004000000ULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x000000310700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e000eULL,
0x0001364000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000731007208ULL, 0x000fc80004000000ULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x000000310e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e000cULL,
0x000136a000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000e31047208ULL, 0x000fc80004000000ULL, 0x0000024000007944ULL, 0x000fea0003c00000ULL,
0x000000310c00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e0006ULL,
0x0001370000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000c31057208ULL, 0x000fc80004000000ULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0x000000310600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0a7224ULL, 0x002fe200078e0000ULL,
0x0001376000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000631067208ULL, 0x000fc80004000000ULL, 0x0000018000007944ULL, 0x000fea0003c00000ULL,
0xffffea7000007947ULL, 0x000fea000383ffffULL, 0x018000000a057810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000005077812ULL, 0x000fc800078ec0ffULL,
0x018000000700780cULL, 0x000fda0003f05070ULL, 0x0000000a00058308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0700720cULL, 0x040fe40003f25070ULL,
0x008000000700780cULL, 0x000fe40003f02070ULL, 0x00000001ff0c7807ULL, 0x000fe40000800000ULL,
0x00000001ff057807ULL, 0x004fc80004000000ULL, 0x000000050cff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff0aff7812ULL, 0x040fe4000780c0ffULL,
0x800000000a077812ULL, 0x000fe400078ec0ffULL, 0x00000001ff057807ULL, 0x000fc80000000000ULL,
0x000000050cff7212ULL, 0x000fda000780c0ffULL, 0x0080000007050812ULL, 0x000fe200078efcffULL,
0x000000ffff058224ULL, 0x000fe200078e0007ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000a00057308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffec72006007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000003200007348ULL, 0x000fe80003800000ULL,
0x0c00000b0a317389ULL, 0x0002a200000e000dULL, 0xfffec6e008007950ULL, 0x000fea0003c3ffffULL,
0x0000007700007348ULL, 0x000fe80003800000ULL, 0x0000000c0e0c7389ULL, 0x0002a400000e0078ULL,
0x000000ffff0e7224ULL, 0x002fc400078e000fULL, 0x00000000ff0f7424ULL, 0x000fc800078e00ffULL,
0xfffec6900e007950ULL, 0x000fea0003c3ffffULL, 0x000000010c00780cULL, 0x000fe20003f45070ULL,
0x00000000ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000007600007348ULL, 0x000ff60003800000ULL,
0x00000000000c7806ULL, 0x000fc800050e0100ULL, 0x000000760c0c7212ULL, 0x000fe200078ec0ffULL,
0xfffec6300e007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000002ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000050aULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000668ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008c0ULL,
0x0000000000000288ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b48ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c08ULL,
0x00000000000005c0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000011c8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000011d8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001268ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000126cULL,
0x00000000000001b8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001480ULL,
0x0000000000013a80ULL, 0x8000001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000014f00ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000014f40ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x00000000000152c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001268ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000013c98ULL,
0x0000000000013c98ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000014f00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000152c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_0_m_16_sm_86_cubin_len = 86944;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
