/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_0_m_16_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000144a8ULL, 0x0000000000014128ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x326a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4536316a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4531ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45346a4c4545326aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL,
0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x0000000000676e69ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL, 0x735f616475635f5fULL,
0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL, 0x6c65722e00687461ULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x742e616c65722e00ULL, 0x6e72656b2e747865ULL,
0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL, 0x2e00667542657479ULL,
0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL,
0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL,
0x0061686d5f6c656eULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000b000100000135ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000b00010000017cULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000b0001000001beULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000204ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000b00010000024bULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b000100000291ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000002dfULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b00010000032dULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000b000100000373ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a0022000003ceULL,
0x0000000000012db0ULL, 0x0000000000000250ULL, 0x0004000300000444ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000013000ULL,
0x000d000300000474ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00012db000000000ULL, 0x0001140400000000ULL, 0x0000288080810c00ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8d08288080840828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL,
0x002880808d920000ULL, 0x0000000000000022ULL, 0x00000034ffffffffULL, 0x0000006000000000ULL,
0x00012db000000000ULL, 0x0000025000000000ULL, 0x0000480400000000ULL, 0x8082288080840900ULL,
0x0900000010042880ULL, 0x288080842880808dULL, 0x0000001400082f04ULL, 0x0008230400000080ULL,
0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0050000900000000ULL, 0x000c17040021f000ULL,
0x0048000800000000ULL, 0x000c17040021f000ULL, 0x0040000700000000ULL, 0x000c17040011f000ULL,
0x0028000600000000ULL, 0x000c17040061f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00b42904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000000f000b42804ULL, 0x0000076000000420ULL, 0x00002a7000001b50ULL,
0x00002bd000002af0ULL, 0x0000307000002d10ULL, 0x0000355000003080ULL, 0x000043d000004360ULL,
0x00004610000044d0ULL, 0x0000483000004820ULL, 0x00005a4000004c40ULL, 0x00005bb000005ab0ULL,
0x00005f8000005cf0ULL, 0x000063a000005f90ULL, 0x0000728000007200ULL, 0x000074a000007360ULL,
0x0000774000007730ULL, 0x00007c3000007c20ULL, 0x00009dd000009da0ULL, 0x0000a3f00000a3e0ULL,
0x000122b000012200ULL, 0x00012570000124e0ULL, 0x000128d0000128b0ULL, 0x00012b70000129c0ULL,
0x000004a001f03904ULL, 0x0001b600000000ffULL, 0x0000058000040100ULL, 0x0001b60800000003ULL,
0x00000690003f0100ULL, 0x0001b68800000002ULL, 0x00000be0003f0100ULL, 0x0001b60000000007ULL,
0x00000cf0003f0107ULL, 0x0001b68800000000ULL, 0x000027e0003f0101ULL, 0x0001b60800000020ULL,
0x00002820003f0101ULL, 0x0001b60800000023ULL, 0x00002990003f0109ULL, 0x0001b60800000023ULL,
0x00003500003f0109ULL, 0x0001b68800000021ULL, 0x00004140003f0101ULL, 0x0001b62800000023ULL,
0x00004160003f0101ULL, 0x0001b62800000023ULL, 0x000042d0003f0109ULL, 0x0001b62800000023ULL,
0x00004c10003f0109ULL, 0x0001b69000000021ULL, 0x00005820003f0101ULL, 0x0001b64800000021ULL,
0x00005840003f0101ULL, 0x0001b64800000021ULL, 0x000059b0003f0109ULL, 0x0001b64800000021ULL,
0x00006370003f0109ULL, 0x0001b69800000021ULL, 0x00006fe0003f0101ULL, 0x0001b66800000021ULL,
0x00007000003f0101ULL, 0x0001b66800000021ULL, 0x00007170003f0109ULL, 0x0001b66800000021ULL,
0x000079d0003f0109ULL, 0x0001b6a000000024ULL, 0x0000b0a0003f0101ULL, 0x0001b60000000007ULL,
0x0000c8d0003f0101ULL, 0x0001b60000000007ULL, 0x0000ca40003f0109ULL, 0x0001b60000000007ULL,
0x000107d0003f0109ULL, 0x0001b68800000048ULL, 0x00010a40003f0101ULL, 0x0001b68800000048ULL,
0x00010bb0003f0109ULL, 0x0001b68800000048ULL, 0x00012d50003f0109ULL, 0x0001b60800000008ULL,
0x00012d60003f0101ULL, 0x0001b61000000008ULL, 0x00012d70003f0101ULL, 0x0001b61800000008ULL,
0x00012d80003f0101ULL, 0x0001b62000000008ULL, 0x00033803003f0101ULL, 0x0000aa1000201c04ULL,
0x0000ac200000aa60ULL, 0x0000af100000ad80ULL, 0x0000ca700000b010ULL, 0x000c050400012da0ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0058190300000000ULL, 0x0000001500080a04ULL,
0x0000000000580210ULL, 0x00000000000000ccULL, 0x0000001400000002ULL, 0x0000000000012db0ULL,
0x0000000000000044ULL, 0x0000001400000002ULL, 0x0000000000000000ULL, 0x00000000000000a2ULL,
0x0000001400000002ULL, 0x0000000000000000ULL, 0x000000000001b700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff107b82ULL, 0x000ea20000000a00ULL,
0x0000000000067919ULL, 0x000ee20000002300ULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x0000000000097919ULL, 0x000eea0000002200ULL, 0x00000300ff0b7b82ULL, 0x000f220000000800ULL,
0x0000040000047ab9ULL, 0x000fe20000000800ULL, 0x0000000000077919ULL, 0x000f620000002100ULL,
0x0000000000137919ULL, 0x000f2a0000002700ULL, 0x00000000000579c3ULL, 0x000ea40000002600ULL,
0x0000001100007306ULL, 0x004ea20000209000ULL, 0x000000ff1100720cULL, 0x000fca0003f45070ULL,
0x00008600ff157b82ULL, 0x000f240000000800ULL, 0x0000000000007308ULL, 0x004ea20000001000ULL,
0x00000005ff0a7819ULL, 0x020fcc0000011607ULL, 0x00001fff0a0a7589ULL, 0x000f2200000e0000ULL,
0x0ffffffe00027836ULL, 0x004fc80000000000ULL, 0x0000000200037305ULL, 0x000564000021f000ULL,
0x000000ffff027224ULL, 0x004fe400078e00ffULL, 0x000000ffff047224ULL, 0x020fc800078e0a03ULL,
0x0000001104057224ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000000403057c27ULL, 0x000fc8000f8e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a05ULL,
0x0000000411007e24ULL, 0x000fe2000f8e0200ULL, 0x0000010000047ab9ULL, 0x000fc80000000800ULL,
0x000000110000720cULL, 0x000fda0003f06070ULL, 0x0000000100000824ULL, 0x000fe400078e0a11ULL,
0x0000000105050836ULL, 0x000fc60000000000ULL, 0x000000110000720cULL, 0x000fda0003f26070ULL,
0x0000000105051836ULL, 0x000fe20000000000ULL, 0x00000011ff05a212ULL, 0x000fc800078e33ffULL,
0x0000000500007306ULL, 0x000ea20000209000ULL, 0x000000ff0500720cULL, 0x000fce0003f65070ULL,
0x0000000000007308ULL, 0x004ea40000001000ULL, 0x0ffffffe00027836ULL, 0x004fe40000000000ULL,
0x0000000406007c24ULL, 0x008fe2000f8e0209ULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000200037305ULL, 0x0004e4000021f000ULL, 0x000000ffff027224ULL, 0x004fe400078e00ffULL,
0x0000000305047224ULL, 0x008fca00078e02ffULL, 0x000000ff040d7210ULL, 0x000fca0007ffe1ffULL,
0x0000000d03037227ULL, 0x000fc800078e0002ULL, 0x0000000400027c24ULL, 0x000fe2000f8e0207ULL,
0x00000000000479c3ULL, 0x000ea20000002500ULL, 0x00000005034a7c27ULL, 0x002fc6000f8e00ffULL,
0x0000007f0200780cULL, 0x000fe20003f44070ULL, 0x000000ffff047224ULL, 0x000fc800078e0a4aULL,
0x0000000505007e24ULL, 0x000fca000f8e0204ULL, 0x000000050000720cULL, 0x000fc60003f06070ULL,
0x000000000003a919ULL, 0x000e620000008800ULL, 0xff317217ff07a424ULL, 0x000fe400078e00ffULL,
0x00000004ff4c7e24ULL, 0x004fce000f8e00ffULL, 0x0000000100000824ULL, 0x000fe400078e0a05ULL,
0x000000014a4a0836ULL, 0x000fe20000000000ULL, 0x000000ff0200720cULL, 0x000fe40003f05270ULL,
0x000000050000720cULL, 0x000fe40003f26070ULL, 0x000004000000a802ULL, 0x000fd60000000f00ULL,
0x000000014a4a1836ULL, 0x000fe20000000000ULL, 0x00000005ff4ab212ULL, 0x000fe400078e33ffULL,
0x0000000f0200780cULL, 0x040fe40003f24070ULL, 0x000006540303a816ULL, 0x002fe20000000000ULL,
0x000000ffff487224ULL, 0x000fe200078e0a4aULL, 0x000000030200780cULL, 0x040fe40003f64070ULL,
0x000000030204a211ULL, 0x000fe200078e10ffULL, 0x0000000505487e24ULL, 0x000fc4000f8e0248ULL,
0x00001fff06057589ULL, 0x0002a400000e0000ULL, 0x0000001048007824ULL, 0x000fe200078e00ffULL,
0x0000000000240947ULL, 0x012fec0003800000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000067882ULL, 0x000fe20000000000ULL,
0x7ffc000000077882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x008fe20008000004ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000000073c6ULL, 0x000ef40000000000ULL,
0x01b60006043f75b2ULL, 0x0006e40008000100ULL, 0x0000000000007918ULL, 0x00afe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x008fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402037c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000030612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01b60804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000383947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ee20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x008fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000402027c11ULL, 0x000fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000020612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x01b68804063f75b2ULL, 0x0006f00008000100ULL, 0xfffffffd00e81947ULL, 0x00afea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe200078e0a00ULL,
0x0000001510037219ULL, 0x080fe200000006ffULL, 0x01b400070400a388ULL, 0x0007e20000000800ULL,
0x0000001511097219ULL, 0x080fe200000006ffULL, 0x0000001013107224ULL, 0x000fe200078e02ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000300720cULL, 0x000fe20003f06070ULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x00000010030f7446ULL, 0x000fe20003800002ULL,
0x0000000405037824ULL, 0x004fe200078e020aULL, 0x000000154a027219ULL, 0x000fc400000006ffULL,
0x000000ff0f0f7207ULL, 0x000fe20000000000ULL, 0x0000000203037824ULL, 0x000fe400078e00ffULL,
0x0000000910027224ULL, 0x000fe200078e0202ULL, 0x000000100f00780cULL, 0x000fda0003f05270ULL,
0x0000000000808947ULL, 0x008fea0003800000ULL, 0x0000000000087919ULL, 0x000ea20000000000ULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000177919ULL, 0x000ee60000008800ULL, 0x00000015040d7219ULL, 0x000fe400000006ffULL,
0x00000004ff067819ULL, 0x006fe40000011608ULL, 0x00000004080e7819ULL, 0x000fc600000006ffULL,
0x0000000103077824ULL, 0x000fc800078e0206ULL, 0x0000000100047824ULL, 0x000fca00078e0207ULL,
0x0000000d040d7212ULL, 0x000fe400078e30ffULL, 0x00000015ff047219ULL, 0x000fe20000011604ULL,
0x0000001007157824ULL, 0x000fe400078e00ffULL, 0x00000001020d7824ULL, 0x000fe200078e020dULL,
0x000000030f027248ULL, 0x000fc60007fe0000ULL, 0x00000009040d7224ULL, 0x000fe400078e020dULL,
0x0000000102047824ULL, 0x000fe400078e0a03ULL, 0x000001000d027825ULL, 0x000fe200078e00ffULL,
0x000000f00e0d7812ULL, 0x000fe400078ec0ffULL, 0x000000040600720cULL, 0x000fe20003f06070ULL,
0x0000000107047824ULL, 0x000fe200078e0208ULL, 0x0000040000067802ULL, 0x000fe40000000f00ULL,
0x0000000d020d7212ULL, 0x000fc400078efcffULL, 0x0000065417077816ULL, 0x008fe40000000006ULL,
0xfffffff015047812ULL, 0x000fe400078ee204ULL, 0x000000040d027c10ULL, 0x000fc6000ff3e0ffULL,
0x00000010040d7824ULL, 0x000fe200078e0207ULL, 0x0000000503037c10ULL, 0x000fca0008ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020d7faeULL, 0x0003e2000c101c46ULL,
0x00000000006c7947ULL, 0x000fea0003800000ULL, 0x0000000000087919ULL, 0x000ea20000000000ULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x0000040000067802ULL, 0x002fe20000000f00ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000177919ULL, 0x000e640000008800ULL,
0x0000001504047219ULL, 0x000fe400000006ffULL, 0x0000000308077211ULL, 0x044fe200078fe0ffULL,
0x00000010080e7824ULL, 0x000fc800078e00ffULL, 0x0000000100037824ULL, 0x000fca00078e0207ULL,
0x00000004030d7212ULL, 0x000fe400078e30ffULL, 0x00000015ff047219ULL, 0x000fc60000011603ULL,
0x00000001020d7824ULL, 0x000fc800078e020dULL, 0x0000000904027224ULL, 0x000fe200078e020dULL,
0x000000f00e0d7812ULL, 0x000fe400078ec0ffULL, 0x0000000807047210ULL, 0x000fe20007ffe0ffULL,
0x0000010002027825ULL, 0x000fc600078e00ffULL, 0x0000000d02027212ULL, 0x000fe200078efcffULL,
0x00000010070d7824ULL, 0x000fe200078e00ffULL, 0x0000065417077816ULL, 0x002fe40000000006ULL,
0x0000000402027c10ULL, 0x000fe4000ff1e0ffULL, 0xfffffff00d047812ULL, 0x000fe400078ee204ULL,
0x0000000503037c10ULL, 0x000fc600087fe4ffULL, 0x00000010040d7824ULL, 0x000fca00078e0207ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020d7faeULL, 0x0003e4000b901c46ULL,
0x00000000070472caULL, 0x000fe200000e0000ULL, 0x00009000ff027b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x0001b60004047890ULL, 0x000fd2000fffe03fULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000413027825ULL, 0x002fe200078e0002ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000602067981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0500720cULL, 0x000fe20003f05270ULL,
0x000000ff06057836ULL, 0x004fca0000000000ULL, 0x00000008ff057819ULL, 0x000fce0000011605ULL,
0x000000a000e48947ULL, 0x000fea0003800000ULL, 0x000000080a047824ULL, 0x000fe200078e00ffULL,
0x00000001ff527819ULL, 0x000fe2000001160aULL, 0x00000004ff037424ULL, 0x000fe200078e00ffULL,
0x0000920000047ab9ULL, 0x000fe20000000800ULL, 0x0000000107007824ULL, 0x000fe400078e0204ULL,
0x0000000213027824ULL, 0x000fe400078e00ffULL, 0x01b6880300ff79a7ULL, 0x0003e4000850003fULL,
0x0000001102117224ULL, 0x000fc800078e0211ULL, 0x000000014a027824ULL, 0x000fe400078e0211ULL,
0x000000014c007836ULL, 0x002fe20000000000ULL, 0x0000000552037819ULL, 0x000fc800000006ffULL,
0x000000050000720cULL, 0x000fe20003f06070ULL, 0x000001004c177824ULL, 0x000fe200078e0203ULL,
0x000000010a007812ULL, 0x000fc600078ec0ffULL, 0x0000000402157c24ULL, 0x000fd0000f8e0217ULL,
0x0000000400988947ULL, 0x000fea0003800000ULL, 0x000000700e0d7812ULL, 0x000fe200078ec0ffULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000003ff1d7819ULL, 0x000fe40000011608ULL,
0x00000017060e7248ULL, 0x000fe20007fe0000ULL, 0x00000080000c7824ULL, 0x000fe400078e020dULL,
0x0000000115117824ULL, 0x000fe400078e021dULL, 0x000000ffff0d7224ULL, 0x000fe400078e00ffULL,
0x000000041d137836ULL, 0x000fc40000000000ULL, 0x0000010011107825ULL, 0x000fc600078e000cULL,
0x0000000313197819ULL, 0x040fe200000006ffULL, 0x000000ffff177224ULL, 0x000fe200078e0a17ULL,
0x0000000410187c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000113127824ULL, 0x100fe400078e0208ULL,
0x000000081d257836ULL, 0x000fe20000000000ULL, 0x000000200e0e7446ULL, 0x000fe20003800017ULL,
0x0000000c1d277836ULL, 0x000fe20000000000ULL, 0xfffffff8191c7812ULL, 0x000fe200078ee212ULL,
0x000000011d127824ULL, 0x000fe200078e0208ULL, 0x0000000511197c10ULL, 0x000fe200087fe4ffULL,
0x0000400052117824ULL, 0x000fe200078e0207ULL, 0x0000000e1300720cULL, 0x080fe20003f26070ULL,
0x0000000115137824ULL, 0x000fe200078e0213ULL, 0x00000007121b7812ULL, 0x000fe200078ec0ffULL,
0x0000200000147824ULL, 0x000fe200078e0211ULL, 0x0000000e1d00720cULL, 0x080fe20003f06070ULL,
0x0000000115177824ULL, 0x000fe200078e0225ULL, 0x0000000e2500720cULL, 0x080fe20003fa6070ULL,
0x0000010013107825ULL, 0x000fe200078e000cULL, 0x0000000e2700720cULL, 0x000fc60003f86070ULL,
0x00000001151f7824ULL, 0x000fe200078e0227ULL, 0x00000004101a7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000010017127825ULL, 0x000fc800078e000cULL, 0x000001001f167825ULL, 0x000fe200078e000cULL,
0x00013000141f7810ULL, 0x000fe40007ffe0ffULL, 0x0ffffff81b147812ULL, 0x000fe200078ef808ULL,
0x000000101d297836ULL, 0x000fe20000000000ULL, 0x0000000412107c10ULL, 0x000fe2000ff7e0ffULL,
0x000000101c237824ULL, 0x100fe200078e021fULL, 0x00000005111b7c10ULL, 0x000fe200097fe4ffULL,
0x0000001014217824ULL, 0x000fe200078e021fULL, 0x0000000416127c10ULL, 0x000fe2000ff5e0ffULL,
0x000000141d2b7836ULL, 0x000fe20000000000ULL, 0x0000000513117c10ULL, 0x000fe20009ffe4ffULL,
0x000000181d2d7836ULL, 0x000fe20000000000ULL, 0x0000000517137c10ULL, 0x000fe200097fe4ffULL,
0x0000000115177824ULL, 0x000fe200078e0229ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018217faeULL, 0x0003e2000c101c46ULL, 0x0000001c1d2f7836ULL, 0x000fe20000000000ULL,
0x0000000e2900720cULL, 0x080fe20003f66070ULL, 0x0000010017167825ULL, 0x000fe200078e000cULL,
0x000000001a237faeULL, 0x0005e2000c901c46ULL, 0x0000000e2b00720cULL, 0x000fc40003f46070ULL,
0x0000000125147824ULL, 0x140fe200078e0208ULL, 0x0000000325257819ULL, 0x000fe200000006ffULL,
0x00000001151d7824ULL, 0x000fe200078e022dULL, 0x0000000e2d00720cULL, 0x080fe20003f26070ULL,
0x000000082b1e7824ULL, 0x000fe200078e00ffULL, 0x0000000416187c10ULL, 0x002fe2000ffde0ffULL,
0x0000000127197824ULL, 0x000fe200078e0208ULL, 0x0000000e2f00720cULL, 0x000fe20003f06070ULL,
0x000000082d207824ULL, 0x000fe200078e00ffULL, 0xfffffff8250e7812ULL, 0x000fe200078ee214ULL,
0x00000008271a7824ULL, 0x004fe200078e00ffULL, 0x0000002f15217210ULL, 0x000fe20007ffe0ffULL,
0x00000001151b7824ULL, 0x000fc400078e022bULL, 0x0000000129147824ULL, 0x040fe200078e0208ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee219ULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0x0000000517197c10ULL, 0x000fe2000b7fe4ffULL, 0x000001001b167825ULL, 0x000fc600078e000cULL,
0xfffffff8291c7812ULL, 0x000fe200078ee214ULL, 0x000000012b1b7824ULL, 0x000fe200078e0208ULL,
0x0000000416167c10ULL, 0x000fe2000ffde0ffULL, 0x000001001d147825ULL, 0x000fc600078e000cULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee21bULL, 0x000000012d1b7824ULL, 0x100fe200078e0208ULL,
0x0000000517177c10ULL, 0x000fe2000b7fe4ffULL, 0x000000012f1d7824ULL, 0x040fe200078e0208ULL,
0x0000000414147c10ULL, 0x000fe2000ffde0ffULL, 0x000000082f227824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee21bULL, 0x00000100210c7825ULL, 0x000fe200078e000cULL,
0x0000000515157c10ULL, 0x000fe4000b7fe4ffULL, 0xfffffff822227812ULL, 0x000fe200078ee21dULL,
0x000000100e1b7824ULL, 0x100fe200078e021fULL, 0x000000040c0c7c10ULL, 0x000fe2000ffde0ffULL,
0x000000101a1d7824ULL, 0x100fe200078e021fULL, 0x0000001f20257211ULL, 0x000fe200078e20ffULL,
0x000000101c217824ULL, 0x100fe200078e021fULL, 0x000000050d0d7c10ULL, 0x000fe2000b7fe4ffULL,
0x000000101e237824ULL, 0x100fe200078e021fULL, 0x00000000101b7faeULL, 0x0003e2000e901c46ULL,
0x00000010221f7824ULL, 0x000fc600078e021fULL, 0x00000000121d7faeULL, 0x0003e8000e101c46ULL,
0x0000000018217faeULL, 0x0003e8000d901c46ULL, 0x0000000016237faeULL, 0x0003e8000d101c46ULL,
0x0000000014257faeULL, 0x0003e8000c901c46ULL, 0x000000000c1f7faeULL, 0x0003e2000c101c46ULL,
0x0000000400647947ULL, 0x000fea0003800000ULL, 0x00000004080d7811ULL, 0x040fe200078fe8ffULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000808107811ULL, 0x040fe400078fe8ffULL,
0x0000000c08127811ULL, 0x040fe200078fe8ffULL, 0x000000010d0c7824ULL, 0x140fe200078e0208ULL,
0x0000001008147811ULL, 0x040fe200078fe8ffULL, 0x000000080d137824ULL, 0x000fe200078e00ffULL,
0x0000001408167811ULL, 0x000fe200078fe8ffULL, 0x0000000110117824ULL, 0x100fe200078e0208ULL,
0x0000000314247819ULL, 0x000fe200000006ffULL, 0x0000000810207824ULL, 0x000fe200078e00ffULL,
0xfffffff8131e7812ULL, 0x000fe200078ee20cULL, 0x00000001120c7824ULL, 0x100fe200078e0208ULL,
0x000000700e1d7812ULL, 0x000fe200078ec0ffULL, 0x0000000812197824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee211ULL, 0x0000000114117824ULL, 0x100fe200078e0208ULL,
0x0000001c080e7811ULL, 0x000fe200078fe8ffULL, 0x0000000116137824ULL, 0x040fe200078e0208ULL,
0xfffffff819227812ULL, 0x000fe200078ee20cULL, 0x0000000816267824ULL, 0x000fe200078e00ffULL,
0x00000008080c7211ULL, 0x000fe200078fe8ffULL, 0x00000080001c7824ULL, 0x000fe200078e021dULL,
0x0000001808187811ULL, 0x000fe200078fe8ffULL, 0x000000080e1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee211ULL, 0x0000000115197824ULL, 0x000fe200078e0212ULL,
0xfffffff826267812ULL, 0x000fe200078ee213ULL, 0x0000400052137824ULL, 0x000fe200078e0207ULL,
0x000000070c117812ULL, 0x000fe200078ec0ffULL, 0x000000010e0c7824ULL, 0x000fc400078e0208ULL,
0x0000000118177824ULL, 0x040fe400078e0208ULL, 0x0000000818287824ULL, 0x000fe200078e00ffULL,
0xfffffff81d2a7812ULL, 0x000fe200078ee20cULL, 0x00002000001a7824ULL, 0x000fe200078e0213ULL,
0x000000ff001d7202ULL, 0x000fe20000000f00ULL, 0x0000000115137824ULL, 0x040fe200078e020dULL,
0x00000015080d7211ULL, 0x000fe200078fe8ffULL, 0x0000000115237824ULL, 0x040fe200078e020eULL,
0xfffffff828287812ULL, 0x000fe200078ee217ULL, 0x00000001151b7824ULL, 0x000fe200078e0214ULL,
0x0000001015177210ULL, 0x000fe20007ffe0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e001cULL,
0x0ffffff8110e7812ULL, 0x000fc600078ef808ULL, 0x0000010013107825ULL, 0x000fe200078e001cULL,
0x000000040c0c7c10ULL, 0x000fc6000ff1e0ffULL, 0x00000001151f7824ULL, 0x040fe200078e0216ULL,
0x0000000410107c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000115217824ULL, 0x000fe200078e0218ULL,
0x000000050d0d7c10ULL, 0x000fe200087fe4ffULL, 0x0000010017127825ULL, 0x000fe200078e001cULL,
0x0000000511117c10ULL, 0x000fc60008ffe4ffULL, 0x0000010019147825ULL, 0x000fe200078e001cULL,
0x0000000412127c10ULL, 0x000fc6000ff5e0ffULL, 0x000001001b167825ULL, 0x100fe200078e001cULL,
0x0000000414147c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000513137c10ULL, 0x000fe200097fe4ffULL,
0x000130001a2d7836ULL, 0x000fe20000000000ULL, 0x0000000416167c10ULL, 0x000fe2000ff1e0ffULL,
0x000001001f187825ULL, 0x100fe200078e001cULL, 0x0000000515157c10ULL, 0x000fe40009ffe4ffULL,
0x0000000517177c10ULL, 0x000fe200087fe4ffULL, 0x00000100211a7825ULL, 0x000fe200078e001cULL,
0x0000000418187c10ULL, 0x000fc6000ff3e0ffULL, 0x00000100231c7825ULL, 0x000fe200078e001cULL,
0x000000041a1a7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000519197c10ULL, 0x000fe20008ffe4ffULL,
0x000000100e1f7824ULL, 0x100fe200078e022dULL, 0x000000041c1c7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000101e217824ULL, 0x100fe200078e022dULL, 0x000000051b1b7c10ULL, 0x000fe200097fe4ffULL,
0x0000001020237824ULL, 0x100fe200078e022dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c1f7faeULL, 0x0003e2000b901c46ULL, 0x0000001022257824ULL, 0x100fe200078e022dULL,
0x000000051d1d7c10ULL, 0x000fe20009ffe4ffULL, 0x0000001024277824ULL, 0x100fe200078e022dULL,
0x0000000010217faeULL, 0x0003e2000b901c46ULL, 0x0000001026297824ULL, 0x000fc400078e022dULL,
0x00000010282b7824ULL, 0x100fe200078e022dULL, 0x0000000012237faeULL, 0x0003e2000b901c46ULL,
0x000000102a2d7824ULL, 0x000fc600078e022dULL, 0x0000000014257faeULL, 0x0003e8000b901c46ULL,
0x0000000016277faeULL, 0x0003e8000b901c46ULL, 0x0000000018297faeULL, 0x0003e8000b901c46ULL,
0x000000001a2b7faeULL, 0x0003e8000b901c46ULL, 0x000000001c2d7faeULL, 0x0003e4000b901c46ULL,
0x000000054c00720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff31721700517802ULL, 0x000fe20000000f00ULL, 0x000000ffff567224ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x002fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fc4000001ff00ULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fc4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000005c00e00947ULL, 0x000fec0003800000ULL, 0xff317217ff517424ULL, 0x000fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x000fce00078e00ffULL, 0x000000014c187836ULL, 0x000fe20000000000ULL,
0x0000920000047ab9ULL, 0x000fe20000000800ULL, 0x000001004c597824ULL, 0x000fc600078e0203ULL,
0x000000051800720cULL, 0x000fe20003f06070ULL, 0x00000040591b7836ULL, 0x000fc80000000000ULL,
0x0000000402257c24ULL, 0x000fe2000f8e021bULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x00000004009c8947ULL, 0x000fea0003800000ULL, 0x0000001008187824ULL, 0x000fe200078e00ffULL,
0x00000003ff297819ULL, 0x100fe20000011608ULL, 0x000000ffff247224ULL, 0x000fe200078e0a1bULL,
0x0000001b06197248ULL, 0x000fe20007fe0000ULL, 0x0000400052277824ULL, 0x000fe200078e0207ULL,
0x0000007018217812ULL, 0x000fe200078ec0ffULL, 0x00000001291b7824ULL, 0x040fe200078e0225ULL,
0x0000002019247446ULL, 0x000fe20003800024ULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x0000002100187211ULL, 0x000fe200078e38ffULL, 0x00000004292b7836ULL, 0x000fe20000000000ULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000129217824ULL, 0x040fe200078e0208ULL,
0x000000242900720cULL, 0x000fe20003f26070ULL, 0x000001001b1a7825ULL, 0x000fc800078e0018ULL,
0x000000012b237824ULL, 0x000fe200078e0225ULL, 0x000000041a207c10ULL, 0x000fe2000ff1e0ffULL,
0x0000200000267824ULL, 0x000fe200078e0227ULL, 0x0000000721277812ULL, 0x000fe200078ec0ffULL,
0x000000082b287824ULL, 0x000fe200078e00ffULL, 0x000000051b217c10ULL, 0x000fe200087fe4ffULL,
0x00000100231a7825ULL, 0x000fe200078e0018ULL, 0x000000082b237210ULL, 0x000fe40007ffe0ffULL,
0x000000242b00720cULL, 0x080fe20003f06070ULL, 0x0001400026267836ULL, 0x000fe20000000000ULL,
0x000000041a227c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000c29437836ULL, 0x000fe20000000000ULL,
0x0ffffff827277812ULL, 0x000fe200078ef808ULL, 0x0000001029457836ULL, 0x000fe20000000000ULL,
0xfffffff8282b7812ULL, 0x000fe200078ee223ULL, 0x0000001429477836ULL, 0x000fe20000000000ULL,
0x000000051b237c10ULL, 0x000fe200097fe4ffULL, 0x00000008291b7836ULL, 0x000fe20000000000ULL,
0x000000244300720cULL, 0x080fe20003fa6070ULL, 0x0000001027277824ULL, 0x000fe200078e0226ULL,
0x000000244500720cULL, 0x080fe20003f86070ULL, 0x000000081b417824ULL, 0x040fe200078e00ffULL,
0x000000241b00720cULL, 0x0c0fe20003fc6070ULL, 0x0000001829497836ULL, 0x000fe20000000000ULL,
0x000000081b1a7210ULL, 0x000fe20007ffe0ffULL, 0x000000011b1b7824ULL, 0x000fe200078e0225ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020277faeULL, 0x0003e2000c901c46ULL,
0x0000001c294b7836ULL, 0x000fe20000000000ULL, 0xfffffff841417812ULL, 0x000fe200078ee21aULL,
0x000001001b1a7825ULL, 0x000fe200078e0018ULL, 0x000000244700720cULL, 0x000fc40003f66070ULL,
0x000000244900720cULL, 0x080fe20003f46070ULL, 0x0000000145297824ULL, 0x100fe200078e0225ULL,
0x000000244b00720cULL, 0x000fe20003f26070ULL, 0x0000000143247824ULL, 0x100fe400078e0208ULL,
0x0000000145287824ULL, 0x040fe200078e0208ULL, 0x0000000345457819ULL, 0x000fe200000006ffULL,
0x000000102b277824ULL, 0x002fe400078e0226ULL, 0x0000000143217824ULL, 0x040fe200078e0225ULL,
0xfffffff845457812ULL, 0x000fe200078ee228ULL, 0x0000000843437824ULL, 0x000fe200078e00ffULL,
0x0000000022277faeULL, 0x0003e2000c101c46ULL, 0x000000041a1a7c10ULL, 0x000fe2000ff1e0ffULL,
0x0000010021207825ULL, 0x000fc400078e0018ULL, 0xfffffff843437812ULL, 0x000fe400078ee224ULL,
0x000000051b1b7c10ULL, 0x000fe200087fe4ffULL, 0x0000000147247824ULL, 0x100fe200078e0208ULL,
0x0000000420207c10ULL, 0x000fe2000ff1e0ffULL, 0x00000001492b7824ULL, 0x040fe400078e0225ULL,
0x0000000149407824ULL, 0x000fe200078e0208ULL, 0x0000000521217c10ULL, 0x000fe200087fe4ffULL,
0x0000010029227825ULL, 0x002fc800078e0018ULL, 0x0000000147297824ULL, 0x040fe200078e0225ULL,
0x0000000422227c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000847277824ULL, 0x000fe400078e00ffULL,
0x0000010029287825ULL, 0x100fe200078e0018ULL, 0x0000000523237c10ULL, 0x000fe400087fe4ffULL,
0xfffffff827477812ULL, 0x000fe200078ee224ULL, 0x000001002b2a7825ULL, 0x000fe200078e0018ULL,
0x0000000428247c10ULL, 0x000fc6000ff1e0ffULL, 0x000000014b277824ULL, 0x000fe200078e0225ULL,
0x0000000529257c10ULL, 0x000fe200087fe4ffULL, 0x0000000849497824ULL, 0x000fe200078e00ffULL,
0x000000042a287c10ULL, 0x000fe2000ff1e0ffULL, 0x000000014b427824ULL, 0x040fe200078e0208ULL,
0x000000034b4b7819ULL, 0x000fe200000006ffULL, 0x0000010027187825ULL, 0x000fe200078e0018ULL,
0xfffffff849497812ULL, 0x000fe400078ee240ULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee242ULL,
0x0000001041277824ULL, 0x100fe200078e0226ULL, 0x000000052b297c10ULL, 0x000fe200087fe4ffULL,
0x00000010432b7824ULL, 0x100fe200078e0226ULL, 0x0000000418187c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001045417824ULL, 0x100fe200078e0226ULL, 0x000000001a277faeULL, 0x0003e2000f101c46ULL,
0x0000001047437824ULL, 0x100fe200078e0226ULL, 0x0000000519197c10ULL, 0x000fe200087fe4ffULL,
0x0000001049457824ULL, 0x100fe200078e0226ULL, 0x00000000202b7faeULL, 0x0003e2000e901c46ULL,
0x000000104b477824ULL, 0x000fc600078e0226ULL, 0x0000000022417faeULL, 0x0003e8000e101c46ULL,
0x0000000024437faeULL, 0x0003e8000d901c46ULL, 0x0000000028457faeULL, 0x0003e8000d101c46ULL,
0x0000000018477faeULL, 0x0003e2000c901c46ULL, 0x0000000400687947ULL, 0x000fea0003800000ULL,
0x0000000808237811ULL, 0x000fe200078fe8ffULL, 0x0000400052217824ULL, 0x000fe200078e0207ULL,
0x0000000408207811ULL, 0x040fe200078fe8ffULL, 0x00008e0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000c08277811ULL, 0x000fe200078fe8ffULL, 0x0000000823227824ULL, 0x000fe200078e00ffULL,
0x0000000823197210ULL, 0x000fe20007ffe0ffULL, 0x0000000120187824ULL, 0x100fe200078e0208ULL,
0x00000014082b7811ULL, 0x000fe200078fe8ffULL, 0x0000000820437824ULL, 0x000fe200078e00ffULL,
0x0000001008297811ULL, 0x040fe200078fe8ffULL, 0x00000001271a7824ULL, 0x140fe200078e0208ULL,
0x00000018084d7811ULL, 0x040fe200078fe8ffULL, 0x0000000827477824ULL, 0x000fe200078e00ffULL,
0xfffffff822457812ULL, 0x000fe200078ee219ULL, 0x000000012b197824ULL, 0x140fe200078e0208ULL,
0xfffffff843437812ULL, 0x000fe200078ee218ULL, 0x000000082b227824ULL, 0x000fe200078e00ffULL,
0x0000001c08537811ULL, 0x040fe200078fe8ffULL, 0x0000000129187824ULL, 0x140fe200078e0208ULL,
0xfffffff847477812ULL, 0x000fe200078ee21aULL, 0x0000000829497824ULL, 0x000fe200078e00ffULL,
0x000000034d4f7819ULL, 0x040fe200000006ffULL, 0x000000014d1a7824ULL, 0x100fe200078e0208ULL,
0xfffffff8224b7812ULL, 0x000fe200078ee219ULL, 0x0000000153197824ULL, 0x040fe200078e0208ULL,
0xfffffff849497812ULL, 0x000fe200078ee218ULL, 0x0000000853227824ULL, 0x000fe200078e00ffULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee21aULL, 0x0000001008187824ULL, 0x040fe200078e00ffULL,
0x00000008081a7211ULL, 0x000fe200078fe8ffULL, 0x0000000123237824ULL, 0x100fe200078e0225ULL,
0xfffffff822557812ULL, 0x000fe200078ee219ULL, 0x0000000127277824ULL, 0x000fe200078e0225ULL,
0x0000007018197812ULL, 0x000fe200078ec0ffULL, 0x0000200000187824ULL, 0x000fe200078e0221ULL,
0x000000071a1b7812ULL, 0x000fe200078ec0ffULL, 0x0000000120217824ULL, 0x000fe200078e0225ULL,
0x0000002529297210ULL, 0x000fe20007ffe0ffULL, 0x00014000181a7836ULL, 0x000fe20000000000ULL,
0x0ffffff81b417812ULL, 0x000fe200078ef808ULL, 0x0000008000187824ULL, 0x000fe200078e0219ULL,
0x00000025081b7211ULL, 0x000fe200078fe8ffULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x0000001a47477211ULL, 0x000fe200078e20ffULL, 0x0000001041417824ULL, 0x000fc400078e021aULL,
0x0000001043437824ULL, 0x100fe400078e021aULL, 0x0000001045457824ULL, 0x100fe400078e021aULL,
0x0000001049497824ULL, 0x100fe400078e021aULL, 0x000000104b4b7824ULL, 0x100fe400078e021aULL,
0x000000104f4f7824ULL, 0x100fe400078e021aULL, 0x0000001055557824ULL, 0x000fc400078e021aULL,
0x000001001b1a7825ULL, 0x000fc800078e0018ULL, 0x0000010021207825ULL, 0x000fe200078e0018ULL,
0x000000041a1a7c10ULL, 0x000fc6000ff1e0ffULL, 0x000000012b2b7824ULL, 0x100fe200078e0225ULL,
0x0000000420207c10ULL, 0x000fe2000ff3e0ffULL, 0x000000014d4d7824ULL, 0x100fe200078e0225ULL,
0x000000051b1b7c10ULL, 0x000fe200087fe4ffULL, 0x0000000153537824ULL, 0x000fe200078e0225ULL,
0x0000000521217c10ULL, 0x000fe20008ffe4ffULL, 0x0000010023227825ULL, 0x100fe400078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a417faeULL, 0x0003e4000b901c46ULL,
0x0000010027247825ULL, 0x100fe200078e0018ULL, 0x0000000422227c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000020437faeULL, 0x0003e4000b901c46ULL, 0x0000010029267825ULL, 0x000fe200078e0018ULL,
0x0000000424247c10ULL, 0x000fc4000ff7e0ffULL, 0x0000000523237c10ULL, 0x000fe200097fe4ffULL,
0x000001002b287825ULL, 0x100fe200078e0018ULL, 0x0000000426267c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000525257c10ULL, 0x000fe20009ffe4ffULL, 0x000001004d2a7825ULL, 0x100fe200078e0018ULL,
0x0000000428287c10ULL, 0x000fe2000ff3e0ffULL, 0x0000000022457faeULL, 0x0003e2000b901c46ULL,
0x0000000527277c10ULL, 0x000fe200087fe4ffULL, 0x0000010053187825ULL, 0x000fe200078e0018ULL,
0x000000042a2a7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000024477faeULL, 0x0003e2000b901c46ULL,
0x0000000529297c10ULL, 0x000fc40008ffe4ffULL, 0x0000000418187c10ULL, 0x000fe2000ff7e0ffULL,
0x0000000026497faeULL, 0x0003e2000b901c46ULL, 0x000000052b2b7c10ULL, 0x000fe400097fe4ffULL,
0x0000000519197c10ULL, 0x000fe20009ffe4ffULL, 0x00000000284b7faeULL, 0x0003e8000b901c46ULL,
0x000000002a4f7faeULL, 0x0003e8000b901c46ULL, 0x0000000018557faeULL, 0x0003e4000b901c46ULL,
0xffffffe004187812ULL, 0x042fe200078ec0ffULL, 0x00000001ff217424ULL, 0x000fe200078e00ffULL,
0x0000001004197812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x00000007191b7210ULL, 0x000fca0007ffe018ULL, 0x0000000800207824ULL, 0x000fcc00078e021bULL,
0x01b60821202079a7ULL, 0x000e64000850003fULL, 0x0000000000187805ULL, 0x000fe40000015200ULL,
0x00000008041a7812ULL, 0x000fca00078ec0ffULL, 0x000000011b237824ULL, 0x000fc800078e021aULL,
0x01b60821230075a7ULL, 0x002ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ff00227202ULL, 0x000fce0000000f00ULL, 0x000000102200780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001a7805ULL, 0x000fcc0000015200ULL,
0x0000001a18257210ULL, 0x000fca0007f1e1ffULL, 0x000000011b1b7824ULL, 0x000fe200000e0e19ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff1a7819ULL, 0x000fc8000001141bULL, 0x000000251a1a7211ULL, 0x000fca00078110ffULL,
0x000000ffff1b7224ULL, 0x000fca00000e061bULL, 0x000000021a1a7819ULL, 0x000fc8000000121bULL,
0x0000001a0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000122227836ULL, 0x000fce0000000000ULL, 0x01b60821230075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000001008457824ULL, 0x000fe200078e00ffULL,
0x00000001ff507819ULL, 0x000fe20000011608ULL, 0x000000200a187824ULL, 0x000fe400078e00ffULL,
0x000000ffff5a7224ULL, 0x000fe200078e0051ULL, 0x0000007045457812ULL, 0x000fe400078ec0ffULL,
0xffffff8018187812ULL, 0x000fe400078ec0ffULL, 0x0000000c50507812ULL, 0x000fe400078ec0ffULL,
0x0000000745197210ULL, 0x000fca0007ffe018ULL, 0x0000000119197824ULL, 0x000fca00078e0250ULL,
0x01b0000019187984ULL, 0x000e680000000800ULL, 0x01b20000194f7984ULL, 0x0004a20000000800ULL,
0x000000511800720bULL, 0x002fda0003f1d000ULL, 0x00000000001a7806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff1a1b7812ULL, 0x000fda000782c0ffULL,
0x0000000000f49947ULL, 0x004fea0003800000ULL, 0x00000002ff197819ULL, 0x000fe4000001160aULL,
0x000000511800720bULL, 0x0c0fe40003f34000ULL, 0x0000000a1900720cULL, 0x000fe40003f45270ULL,
0x00000051185a7209ULL, 0x000fd20007810000ULL, 0x0000000000207806ULL, 0x000fe400008e0100ULL,
0x000000800a19a824ULL, 0x000fe400078e0207ULL, 0x00009910201a7816ULL, 0x000fc600000000ffULL,
0x000000195019a210ULL, 0x000fe40007ffe045ULL, 0x000000ff1a00720cULL, 0x000fc60003f25270ULL,
0x01b4005a1900a388ULL, 0x0003f40000000800ULL, 0x0000000000b09947ULL, 0x002fea0003800000ULL,
0x000000515a197221ULL, 0x000fe20000010100ULL, 0x000000ff20ff7812ULL, 0x040fe4000782c0ffULL,
0x0000ff0020ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b19197820ULL, 0x000fc80000410000ULL,
0x00000019001a7308ULL, 0x0002ac0000000800ULL, 0x0000000000489947ULL, 0x000fea0003800000ULL,
0x00000002ff197819ULL, 0x002fcc0000011608ULL, 0x00001f191a197589ULL, 0x004e6400000e0000ULL,
0x000000192c2c7220ULL, 0x082fe20000410000ULL, 0x000000192d2d7220ULL, 0x080fe20000410000ULL,
0x0000001930307220ULL, 0x080fe20000410000ULL, 0x0000001931317220ULL, 0x080fe20000410000ULL,
0x0000001934347220ULL, 0x080fe20000410000ULL, 0x0000001935357220ULL, 0x080fe20000410000ULL,
0x0000001938387220ULL, 0x080fe20000410000ULL, 0x0000001939397220ULL, 0x080fe20000410000ULL,
0x000000193c3c7220ULL, 0x080fe20000410000ULL, 0x000000193d3d7220ULL, 0x080fe20000410000ULL,
0x0000001910107220ULL, 0x080fe20000410000ULL, 0x0000001911117220ULL, 0x080fe20000410000ULL,
0x0000001914147220ULL, 0x080fe20000410000ULL, 0x0000001915157220ULL, 0x080fe20000410000ULL,
0x000000191c1c7220ULL, 0x080fe20000410000ULL, 0x000000191d1d7220ULL, 0x000fce0000410000ULL,
0x0000001a56567220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x0000000808197811ULL, 0x002fcc00078ff0ffULL, 0x00001f191a197589ULL, 0x000e6400000e0000ULL,
0x000000192e2e7220ULL, 0x082fe20000410000ULL, 0x000000192f2f7220ULL, 0x080fe20000410000ULL,
0x0000001932327220ULL, 0x080fe20000410000ULL, 0x0000001933337220ULL, 0x080fe20000410000ULL,
0x0000001936367220ULL, 0x080fe20000410000ULL, 0x0000001937377220ULL, 0x080fe20000410000ULL,
0x000000193a3a7220ULL, 0x080fe20000410000ULL, 0x000000193b3b7220ULL, 0x080fe20000410000ULL,
0x000000193e3e7220ULL, 0x080fe20000410000ULL, 0x000000193f3f7220ULL, 0x080fe20000410000ULL,
0x0000001912127220ULL, 0x080fe20000410000ULL, 0x0000001913137220ULL, 0x080fe20000410000ULL,
0x0000001916167220ULL, 0x080fe20000410000ULL, 0x0000001917177220ULL, 0x080fe20000410000ULL,
0x000000191e1e7220ULL, 0x080fe20000410000ULL, 0x000000191f1f7220ULL, 0x000fce0000410000ULL,
0x0000ffff1bff7812ULL, 0x000fda0007826020ULL, 0x8000005a18181221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b18181820ULL, 0x000fc80000410000ULL,
0x00000018000c1308ULL, 0x000ea40000000800ULL, 0x0000000c4f4f1220ULL, 0x004fce0000410000ULL,
0x00000007084b7812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000004ff1b7819ULL, 0x000fe40000011608ULL, 0x00000008084e7812ULL, 0x000fe400078ec0ffULL,
0x000000084b517812ULL, 0x000fe200078ef808ULL, 0x0000000452187824ULL, 0x000fe200078e021bULL,
0x0000004b4e217212ULL, 0x000fe200078efcffULL, 0x00004000521b7824ULL, 0x000fe200078e0207ULL,
0x000000090a197819ULL, 0x002fe200000006ffULL, 0x0000000151537824ULL, 0x040fe200078e0218ULL,
0x0000002108207211ULL, 0x000fe200078fe0ffULL, 0x0000000851187824ULL, 0x000fe200078e00ffULL,
0xfffff80019547812ULL, 0x000fe200078ec0ffULL, 0x0000000821237824ULL, 0x040fe200078e00ffULL,
0x0000000420447810ULL, 0x000fe20007ffe0ffULL, 0x0000000220467836ULL, 0x000fe20000000000ULL,
0xfffffff8184d7812ULL, 0x000fe200078ee253ULL, 0x0000000821197824ULL, 0x000fc400078e00ffULL,
0x0000000821477824ULL, 0x000fe200078e00ffULL, 0xfffffff823467812ULL, 0x000fe200078ee246ULL,
0x00002000001b7824ULL, 0x000fe200078e021bULL, 0xfffffff819447812ULL, 0x000fe200078ee244ULL,
0x0000000107547824ULL, 0x000fe200078e0254ULL, 0xfffffff847477812ULL, 0x000fe200078ee220ULL,
0x000130001b527836ULL, 0x000fe40000000000ULL, 0x000000104d4d7824ULL, 0x000fe200078e0254ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff1b7819ULL, 0x000fe40000011608ULL,
0x0000000cff0d723eULL, 0x000fc600000000ffULL, 0x000000081b197836ULL, 0x000fe20000000000ULL,
0x000054100d187816ULL, 0x000fca000000000dULL, 0x00001f1b180d7589ULL, 0x0002a800000e0000ULL,
0x00001f19180e7589ULL, 0x0002e400000e0000ULL, 0x011000004d18783bULL, 0x0022e20000000200ULL,
0x0000001047247824ULL, 0x100fe400078e0252ULL, 0x0000001046407824ULL, 0x100fe400078e0252ULL,
0x0000001044287824ULL, 0x000fe200078e0252ULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000d18187232ULL, 0x08cfe40000000000ULL, 0x0000000d1a1a7232ULL, 0x000fe40000000000ULL,
0x0000000e19197232ULL, 0x080fe40000000000ULL, 0x0000000e1b1b7232ULL, 0x000fce0000000000ULL,
0x0000000620497836ULL, 0x000fe20000000000ULL, 0x0000000321227819ULL, 0x000fe200000006ffULL,
0x000000002828783bULL, 0x000f220000004200ULL, 0x0000000253537836ULL, 0x000fe40000000000ULL,
0xfffffff822497812ULL, 0x000fe200078ee249ULL, 0x000000002424783bULL, 0x000f680000004200ULL,
0x0000001049207824ULL, 0x000fe200078e0252ULL, 0x000000004040783bULL, 0x000fea0000004200ULL,
0x000000002020783bULL, 0x000f620000004200ULL, 0x0000002a1810723cULL, 0x018fec0000001810ULL,
0x00000028183c723cULL, 0x000fe2000000183cULL, 0x000000104e2b7812ULL, 0x000fe200078efe4bULL,
0x00000008512a7824ULL, 0x000fc800078e00ffULL, 0x00000024182c723cULL, 0x022fe2000000182cULL,
0x0000002b08287211ULL, 0x000fe400078fe0ffULL, 0xfffffff82a297812ULL, 0x000fe200078ee253ULL,
0x000000082b2a7824ULL, 0x000fe400078e00ffULL, 0x000000261824723cULL, 0x000fe20000001830ULL,
0x0000000228537836ULL, 0x000fe40000000000ULL, 0x0000000428517836ULL, 0x000fe40000000000ULL,
0x0000001029297824ULL, 0x000fe200078e0254ULL, 0x000000201814723cULL, 0x000fe20000001814ULL,
0x000000082b307824ULL, 0x000fe200078e00ffULL, 0xfffffff82a537812ULL, 0x000fe200078ee253ULL,
0x0000000628577836ULL, 0x000fc60000000000ULL, 0xfffffff830517812ULL, 0x000fe200078ee251ULL,
0x000000401834723cULL, 0x000fe20000001834ULL, 0x000000032b217819ULL, 0x040fe200000006ffULL,
0x000000082b207824ULL, 0x000fe400078e00ffULL, 0x0000001051307824ULL, 0x100fe200078e0252ULL,
0xfffffff821547812ULL, 0x000fe200078ee228ULL, 0x000000421838723cULL, 0x000fe20000001838ULL,
0x0000001053407824ULL, 0x000fc600078e0252ULL, 0x00000010542a7824ULL, 0x000fe400078e0252ULL,
0x00000022181c723cULL, 0x000fe2000000181cULL, 0x011000002918783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000d18187232ULL, 0x08cfe40000000000ULL, 0x0000000d1a1a7232ULL, 0x000fe40000000000ULL,
0x0000000e19197232ULL, 0x080fe40000000000ULL, 0x0000000e1b1b7232ULL, 0x000fce0000000000ULL,
0xfffffff820577812ULL, 0x000fe200078ee257ULL, 0x000000004040783bULL, 0x000f220000004200ULL,
0x0000920000047ab9ULL, 0x000fe20000000800ULL, 0x000000564f5c7221ULL, 0x000fe40000010000ULL,
0x0000001057207824ULL, 0x000fe200078e0252ULL, 0x000000003030783bULL, 0x000f680000004200ULL,
0x000000002a28783bULL, 0x002e680000004200ULL, 0x000000002020783bULL, 0x000e620000004200ULL,
0x000000401834723cULL, 0x018fec0000001834ULL, 0x000000421838723cULL, 0x000fec0000001838ULL,
0x00000030183c723cULL, 0x020fec000000183cULL, 0x000000321810723cULL, 0x000fe20000001810ULL,
0x0000000100307802ULL, 0x000fca0000000f00ULL, 0x00000028182c723cULL, 0x002fec000000182cULL,
0x0000002a1824723cULL, 0x000fe20000001824ULL, 0x000000020a287824ULL, 0x000fca00078e00ffULL,
0x000000201814723cULL, 0x000fe20000001814ULL, 0xfffffff828287812ULL, 0x000fca00078ec0ffULL,
0x000000221818723cULL, 0x000fe2000000181cULL, 0x0000000107217824ULL, 0x000fc800078e0228ULL,
0x01b6883021ff79a7ULL, 0x0003e4000850003fULL, 0x000000014c1c7836ULL, 0x000fe40000000000ULL,
0x00000080591f7836ULL, 0x000fc60000000000ULL, 0x000000051c00720cULL, 0x000fe20003f06070ULL,
0x0000000402317c24ULL, 0x000fe2000f8e021fULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0000000400888947ULL, 0x002fea0003800000ULL, 0x00000003ff417819ULL, 0x100fe20000011608ULL,
0x000000ffff407224ULL, 0x000fe200078e0a1fULL, 0x0000001f061d7248ULL, 0x000fe20007fe0000ULL,
0x00000080001c7824ULL, 0x000fe200078e0245ULL, 0x00008e0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000441217836ULL, 0x000fe20000000000ULL, 0x000000201d407446ULL, 0x000fe20003800040ULL,
0x00000001411f7824ULL, 0x100fe200078e0231ULL, 0x000000ff001d7202ULL, 0x000fe20000000f00ULL,
0x00000001211e7824ULL, 0x040fe200078e0208ULL, 0x000000402100720cULL, 0x0c0fe20003f26070ULL,
0x00000008214f7824ULL, 0x000fe200078e00ffULL, 0x000000404100720cULL, 0x000fe20003f06070ULL,
0x0000000121217824ULL, 0x000fc400078e0231ULL, 0x0000000c415b7836ULL, 0x000fe20000000000ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee21eULL, 0x00000001411e7824ULL, 0x000fe400078e0208ULL,
0x0000010021207825ULL, 0x100fe200078e001cULL, 0x000000524f4f7211ULL, 0x000fe400078e20ffULL,
0x000000071e337812ULL, 0x000fe200078ec0ffULL, 0x000001001f1e7825ULL, 0x000fe200078e001cULL,
0x0000000420327c10ULL, 0x000fe4000ff7e0ffULL, 0x000000405b00720cULL, 0x040fe20003f86070ULL,
0x0000000841557836ULL, 0x000fe20000000000ULL, 0x000000041e227c10ULL, 0x000fe2000ff5e0ffULL,
0x000000015b2b7824ULL, 0x000fc400078e0231ULL, 0x0000000155297824ULL, 0x000fe200078e0231ULL,
0x000000051f237c10ULL, 0x000fe200097fe4ffULL, 0x000001002b2a7825ULL, 0x100fe200078e001cULL,
0x0ffffff8331f7812ULL, 0x000fe400078ef808ULL, 0x0000000521337c10ULL, 0x000fe20009ffe4ffULL,
0x0000010029287825ULL, 0x000fe200078e001cULL, 0x000000042a207c10ULL, 0x000fe4000ff7e0ffULL,
0x000000405500720cULL, 0x080fe20003fa6070ULL, 0x000000101f437824ULL, 0x000fe200078e0252ULL,
0x00000004281e7c10ULL, 0x000fe2000ff5e0ffULL, 0x00000014415d7836ULL, 0x000fe20000000000ULL,
0x000000052b217c10ULL, 0x000fe20009ffe4ffULL, 0x00000010412b7836ULL, 0x000fe20000000000ULL,
0x00000005291f7c10ULL, 0x000fe200097fe4ffULL, 0x00000018415f7836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022437faeULL, 0x0003e2000c101c46ULL,
0x000000012b297824ULL, 0x040fe200078e0231ULL, 0x000000402b00720cULL, 0x080fe20003f66070ULL,
0x0000001c41617836ULL, 0x000fe20000000000ULL, 0x000000035b417819ULL, 0x000fe200000006ffULL,
0x0000000155287824ULL, 0x100fe200078e0208ULL, 0x00000000324f7faeULL, 0x0007e2000c901c46ULL,
0x000000015b2a7824ULL, 0x000fe200078e0208ULL, 0x000000405d00720cULL, 0x080fe20003f46070ULL,
0x0000000855557824ULL, 0x000fe200078e00ffULL, 0x000000405f00720cULL, 0x000fe20003f26070ULL,
0x0000010029227825ULL, 0x002fe200078e001cULL, 0xfffffff841417812ULL, 0x000fc400078ee22aULL,
0x000000406100720cULL, 0x000fe20003f06070ULL, 0x000000015d297824ULL, 0x000fe200078e0231ULL,
0x0000000422227c10ULL, 0x000fe2000ffde0ffULL, 0x000000012b2a7824ULL, 0x040fe200078e0208ULL,
0xfffffff855337812ULL, 0x008fe200078ee228ULL, 0x000000082b437824ULL, 0x000fe200078e00ffULL,
0x0000000523237c10ULL, 0x000fe2000b7fe4ffULL, 0x0000010029287825ULL, 0x000fc600078e001cULL,
0xfffffff843437812ULL, 0x000fe200078ee22aULL, 0x000000015f2b7824ULL, 0x000fe200078e0231ULL,
0x0000000428287c10ULL, 0x000fe2000ffde0ffULL, 0x000000015d327824ULL, 0x040fe400078e0208ULL,
0x000000085d4f7824ULL, 0x000fe200078e00ffULL, 0x0000000529297c10ULL, 0x000fe2000b7fe4ffULL,
0x000001002b2a7825ULL, 0x000fc600078e001cULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee232ULL,
0x0000000161317824ULL, 0x000fe200078e0231ULL, 0x000000042a2a7c10ULL, 0x000fe2000ffde0ffULL,
0x000000015f327824ULL, 0x140fe200078e0208ULL, 0x000000035f5f7819ULL, 0x000fe200000006ffULL,
0x0000000161407824ULL, 0x040fe200078e0208ULL, 0x000000052b2b7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000861557824ULL, 0x000fe400078e00ffULL, 0x00000100311c7825ULL, 0x000fe200078e001cULL,
0xfffffff85f317812ULL, 0x000fc400078ee232ULL, 0xfffffff855557812ULL, 0x000fe200078ee240ULL,
0x0000001033337824ULL, 0x100fe200078e0252ULL, 0x000000041c1c7c10ULL, 0x000fe2000ffde0ffULL,
0x0000001041417824ULL, 0x100fe400078e0252ULL, 0x0000001043437824ULL, 0x100fe200078e0252ULL,
0x000000051d1d7c10ULL, 0x000fe2000b7fe4ffULL, 0x000000104f4f7824ULL, 0x100fe200078e0252ULL,
0x000000001e337faeULL, 0x0003e2000e901c46ULL, 0x0000001031317824ULL, 0x100fe400078e0252ULL,
0x0000001055557824ULL, 0x000fe200078e0252ULL, 0x0000000020417faeULL, 0x0003e8000e101c46ULL,
0x0000000022437faeULL, 0x0003e8000d901c46ULL, 0x00000000284f7faeULL, 0x0003e8000d101c46ULL,
0x000000002a317faeULL, 0x0003e8000c901c46ULL, 0x000000001c557faeULL, 0x0003e2000c101c46ULL,
0x0000000400547947ULL, 0x000fea0003800000ULL, 0x00000008082b7811ULL, 0x000fe200078fe8ffULL,
0x0000008000287824ULL, 0x000fe200078e0245ULL, 0x0000000408417811ULL, 0x040fe200078fe8ffULL,
0x000000ffff297224ULL, 0x000fe200078e00ffULL, 0x0000000c08237811ULL, 0x040fe200078fe8ffULL,
0x000000012b1d7824ULL, 0x140fe200078e0208ULL, 0x00000008411c7210ULL, 0x000fe20007ffe0ffULL,
0x000000082b1e7824ULL, 0x000fe200078e00ffULL, 0x0000001808217811ULL, 0x040fe200078fe8ffULL,
0x00000008414f7824ULL, 0x000fe200078e00ffULL, 0x00000014081f7811ULL, 0x040fe200078fe8ffULL,
0x00000008235b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e557812ULL, 0x000fe200078ee21dULL,
0x0000000121227824ULL, 0x140fe200078e0208ULL, 0x00000010081d7811ULL, 0x040fe200078fe8ffULL,
0x0000000821617824ULL, 0x000fe200078e00ffULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee21cULL,
0x00000001231c7824ULL, 0x100fe200078e0208ULL, 0x0000003108337211ULL, 0x040fe200078fe8ffULL,
0x000000011d1e7824ULL, 0x100fe200078e0208ULL, 0x000000031f5f7819ULL, 0x000fe200000006ffULL,
0x000000081d5d7824ULL, 0x000fe200078e00ffULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee21cULL,
0x0000000141417824ULL, 0x100fe200078e0231ULL, 0x00000008081c7211ULL, 0x040fe200078fe8ffULL,
0x000000012b2b7824ULL, 0x100fe200078e0231ULL, 0xfffffff85d5d7812ULL, 0x000fe200078ee21eULL,
0x0000000123237824ULL, 0x000fe200078e0231ULL, 0x0000001c081e7811ULL, 0x000fe200078fe8ffULL,
0x000000011f207824ULL, 0x000fe200078e0208ULL, 0x000000071c437812ULL, 0x000fe200078ec0ffULL,
0x0000010033327825ULL, 0x000fe200078e0028ULL, 0x000000311f1f7210ULL, 0x000fe20007ffe0ffULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0xfffffff861617812ULL, 0x000fe200078ee222ULL,
0x000000011d1d7824ULL, 0x000fe200078e0231ULL, 0x0ffffff843437812ULL, 0x000fe200078ef808ULL,
0x0000010041407825ULL, 0x000fe200078e0028ULL, 0x0000000432327c10ULL, 0x000fc4000ff1e0ffULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee220ULL, 0x000001002b2a7825ULL, 0x000fe200078e0028ULL,
0x0000000440407c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000533337c10ULL, 0x000fe200087fe4ffULL,
0x0000000121217824ULL, 0x000fe200078e0231ULL, 0x000000042a2a7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000010023227825ULL, 0x000fe200078e0028ULL, 0x0000000541417c10ULL, 0x000fe40008ffe4ffULL,
0x000000052b2b7c10ULL, 0x000fe200097fe4ffULL, 0x000000011e317824ULL, 0x040fe200078e0231ULL,
0x0000000422227c10ULL, 0x000fe2000ff7e0ffULL, 0x000000011e427824ULL, 0x040fe200078e0208ULL,
0x0000005255557211ULL, 0x000fe200078e20ffULL, 0x000000081e637824ULL, 0x000fe200078e00ffULL,
0x0000000523237c10ULL, 0x000fe20009ffe4ffULL, 0x000001001d1c7825ULL, 0x000fc800078e0028ULL,
0x000001001f1e7825ULL, 0x000fe200078e0028ULL, 0x000000041c1c7c10ULL, 0x000fc6000ff1e0ffULL,
0x0000010021207825ULL, 0x100fe200078e0028ULL, 0x000000041e1e7c10ULL, 0x000fe4000ff3e0ffULL,
0x000000051d1d7c10ULL, 0x000fe200087fe4ffULL, 0x0000010031287825ULL, 0x000fe200078e0028ULL,
0xfffffff863317812ULL, 0x000fe400078ee242ULL, 0x0000000420207c10ULL, 0x000fe2000ff5e0ffULL,
0x0000001043437824ULL, 0x100fe200078e0252ULL, 0x0000000428287c10ULL, 0x000fe2000ff7e0ffULL,
0x000000104f4f7824ULL, 0x100fe200078e0252ULL, 0x000000051f1f7c10ULL, 0x000fe20008ffe4ffULL,
0x000000105b5b7824ULL, 0x100fe200078e0252ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032437faeULL, 0x0003e2000b901c46ULL, 0x000000105d5d7824ULL, 0x100fe200078e0252ULL,
0x0000000521217c10ULL, 0x000fe200097fe4ffULL, 0x000000105f5f7824ULL, 0x100fe200078e0252ULL,
0x00000000404f7faeULL, 0x0003e2000b901c46ULL, 0x0000001061617824ULL, 0x100fe200078e0252ULL,
0x0000000529297c10ULL, 0x000fe20009ffe4ffULL, 0x0000001031317824ULL, 0x000fe200078e0252ULL,
0x000000002a557faeULL, 0x0003e8000b901c46ULL, 0x00000000225b7faeULL, 0x0003e8000b901c46ULL,
0x000000001c5d7faeULL, 0x0003e8000b901c46ULL, 0x000000001e5f7faeULL, 0x0003e8000b901c46ULL,
0x0000000020617faeULL, 0x0003e8000b901c46ULL, 0x0000000028317faeULL, 0x0003e4000b901c46ULL,
0xffffffe0041c7812ULL, 0x042fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000010041d7812ULL, 0x040fe400078ec0ffULL, 0x00000008041e7812ULL, 0x000fe400078ec0ffULL,
0x000000071d1d7210ULL, 0x000fca0007ffe01cULL, 0x000000011d237824ULL, 0x000fc800078e021eULL,
0x01b62830233079a7ULL, 0x0002e6000850003fULL, 0x00000000001c7805ULL, 0x000fce0000015200ULL,
0x01b62831230075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff207224ULL, 0x000fce00078e00ffULL, 0x000000102000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fce0000015200ULL,
0x0000001e1c217210ULL, 0x000fc80007f1e1ffULL, 0x0000001f1d1f7210ULL, 0x000fe400007fe5ffULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000211e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000120207836ULL, 0x000fce0000000000ULL, 0x01b62831230075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x000000200a1c7824ULL, 0x000fca00078e00ffULL,
0xffffff801c1c7812ULL, 0x000fc800078ec0ffULL, 0x00000080071c7810ULL, 0x000fc80007ffe01cULL,
0x0000001c501c7210ULL, 0x000fca0007ffe045ULL, 0x01b000001c1d7984ULL, 0x000ee80000000800ULL,
0x01b200001c5b7984ULL, 0x0009220000000800ULL, 0x0000005a1d00720bULL, 0x008fda0003f1d000ULL,
0x00000000001e7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff1e207812ULL, 0x000fda000782c0ffULL, 0x0000000000f89947ULL, 0x016fea0003800000ULL,
0x000000010a1f7811ULL, 0x000fe400078ff0ffULL, 0x0000005a1d00720bULL, 0x000fe40003f14000ULL,
0x0000000a1f00720cULL, 0x000fd60003f25270ULL, 0x00000000001f7806ULL, 0x000fe400000e0100ULL,
0x000000800a1e9824ULL, 0x000fe200078e0207ULL, 0x0000005a1d1c9209ULL, 0x000fc80007810000ULL,
0x0000001e50219210ULL, 0x000fe40007ffe045ULL, 0x000099101f1e7816ULL, 0x000fc600000000ffULL,
0x01b4001c21009388ULL, 0x0003e20000000800ULL, 0x000000ff1e00720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005a1d217209ULL, 0x000fe40007810000ULL,
0x000000ff1fff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff001fff7812ULL, 0x000fe2000782c0ffULL,
0x0000005a211c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL,
0x0000001c00217308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff1c7819ULL, 0x002fcc0000011608ULL, 0x00001f1c211c7589ULL, 0x004e6400000e0000ULL,
0x0000002c1c2c7220ULL, 0x042fe20000410000ULL, 0x0000002d1c2d7220ULL, 0x040fe20000410000ULL,
0x000000241c247220ULL, 0x040fe20000410000ULL, 0x000000251c257220ULL, 0x040fe20000410000ULL,
0x000000341c347220ULL, 0x040fe20000410000ULL, 0x000000351c357220ULL, 0x040fe20000410000ULL,
0x000000381c387220ULL, 0x040fe20000410000ULL, 0x000000391c397220ULL, 0x040fe20000410000ULL,
0x0000003c1c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d1c3d7220ULL, 0x040fe20000410000ULL,
0x000000101c107220ULL, 0x040fe20000410000ULL, 0x000000111c117220ULL, 0x040fe20000410000ULL,
0x000000141c147220ULL, 0x040fe20000410000ULL, 0x000000151c157220ULL, 0x040fe20000410000ULL,
0x000000181c187220ULL, 0x040fe20000410000ULL, 0x000000191c197220ULL, 0x000fce0000410000ULL,
0x000000215c5c7220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x00000008081c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f1c211c7589ULL, 0x000e6400000e0000ULL,
0x0000002e1c2e7220ULL, 0x042fe20000410000ULL, 0x0000002f1c2f7220ULL, 0x040fe20000410000ULL,
0x000000261c267220ULL, 0x040fe20000410000ULL, 0x000000271c277220ULL, 0x040fe20000410000ULL,
0x000000361c367220ULL, 0x040fe20000410000ULL, 0x000000371c377220ULL, 0x040fe20000410000ULL,
0x0000003a1c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b1c3b7220ULL, 0x040fe20000410000ULL,
0x0000003e1c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f1c3f7220ULL, 0x040fe20000410000ULL,
0x000000121c127220ULL, 0x040fe20000410000ULL, 0x000000131c137220ULL, 0x040fe20000410000ULL,
0x000000161c167220ULL, 0x040fe20000410000ULL, 0x000000171c177220ULL, 0x040fe20000410000ULL,
0x0000001a1c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b1c1b7220ULL, 0x000fce0000410000ULL,
0x0000ffff20ff7812ULL, 0x000fe4000780601fULL, 0x0000005a1d5a7209ULL, 0x000fd60007810000ULL,
0x8000005a1d1d0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1d1d0820ULL, 0x000fc80000410000ULL,
0x0000001d000c0308ULL, 0x000ea40000000800ULL, 0x0000000c5b5b0220ULL, 0x004fce0000410000ULL,
0x00000001ff527819ULL, 0x000fe2000001160aULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00004000521d7824ULL, 0x000fc800078e0207ULL, 0x00002000001d7824ULL, 0x000fc800078e021dULL,
0x000140001d567836ULL, 0x000fe20000000000ULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff1d7819ULL, 0x000fe40000011608ULL, 0x0000000cff0d723eULL, 0x000fe400000000ffULL,
0x000000081d1f7810ULL, 0x000fe40007ffe0ffULL, 0x000054100d1c7816ULL, 0x002fca000000000dULL,
0x00001f1d1c0d7589ULL, 0x0002a800000e0000ULL, 0x00001f1f1c0e7589ULL, 0x0002e400000e0000ULL,
0x011800004d1c783bULL, 0x0022e20000000200ULL, 0x00000010474f7824ULL, 0x100fe400078e0256ULL,
0x0000001046407824ULL, 0x000fe200078e0256ULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000d1c1c7232ULL, 0x08cfe40000000000ULL, 0x0000000d1e1e7232ULL, 0x000fe40000000000ULL,
0x0000000e1d1d7232ULL, 0x080fe40000000000ULL, 0x0000000e1f1f7232ULL, 0x000fce0000000000ULL,
0x000000004f30783bULL, 0x0009620000004200ULL, 0x0000001049207824ULL, 0x000fe200078e0256ULL,
0x00000002ff5e7819ULL, 0x000fe2000001160aULL, 0x0000001044287824ULL, 0x100fe200078e0256ULL,
0x000000004040783bULL, 0x000fe20000004200ULL, 0x0000001054587824ULL, 0x100fe400078e0256ULL,
0x0000001053557824ULL, 0x100fe200078e0256ULL, 0x000000002020783bULL, 0x000f620000004200ULL,
0x00000010514f7824ULL, 0x010fc600078e0256ULL, 0x000000002828783bULL, 0x000f220000004200ULL,
0x000000301c2c723cULL, 0x02afec000000182cULL, 0x000000321c30723cULL, 0x000fec0000001824ULL,
0x000000201c14723cULL, 0x000fe20000001814ULL, 0x00000004ff257819ULL, 0x000fc40000011608ULL,
0x0000004e4b247212ULL, 0x000fc600078efcffULL, 0x0000000452257824ULL, 0x000fe200078e0225ULL,
0x000000401c34723cULL, 0x000fe20000001834ULL, 0x000008005e207824ULL, 0x000fe400078e0207ULL,
0x00000001245d7824ULL, 0x040fe400078e0225ULL, 0x0000000824257824ULL, 0x000fe200078e00ffULL,
0x000000421c38723cULL, 0x000fe40000001838ULL, 0x000000025d247810ULL, 0x000fc80007ffe0ffULL,
0xfffffff825257812ULL, 0x000fe200078ee224ULL, 0x000000281c3c723cULL, 0x010fe8000000183cULL,
0x0000001025207824ULL, 0x000fe400078e0220ULL, 0x0000002a1c10723cULL, 0x000fec0000001810ULL,
0x000000221c18723cULL, 0x000fe20000001818ULL, 0x01180000201c783bULL, 0x0002e20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000d1c1c7232ULL, 0x08cfe40000000000ULL, 0x0000000d1e1e7232ULL, 0x000fe40000000000ULL,
0x0000000e1d1d7232ULL, 0x080fe40000000000ULL, 0x0000000e1f1f7232ULL, 0x000fce0000000000ULL,
0x00000010574d7824ULL, 0x000fe200078e0256ULL, 0x000000005840783bULL, 0x000f220000004200ULL,
0x000000c059597836ULL, 0x000fe20000000000ULL, 0x0000920000047ab9ULL, 0x000fe20000000800ULL,
0x0000005c5b5c7221ULL, 0x000fe20000010000ULL, 0x000000005528783bULL, 0x000f680000004200ULL,
0x000000004f24783bULL, 0x000f680000004200ULL, 0x000000004d20783bULL, 0x002e620000004200ULL,
0x000000401c2c723cULL, 0x018fec000000182cULL, 0x000000421c30723cULL, 0x000fe20000001830ULL,
0x00000001ff407424ULL, 0x000fca00078e00ffULL, 0x000000281c34723cULL, 0x020fec0000001834ULL,
0x0000002a1c38723cULL, 0x000fe20000001838ULL, 0x0000000402297c24ULL, 0x000fca000f8e0259ULL,
0x000000241c3c723cULL, 0x000fec000000183cULL, 0x000000261c10723cULL, 0x000fec0000001810ULL,
0x000000201c14723cULL, 0x002fec0000001814ULL, 0x000000221c18723cULL, 0x000fe20000001818ULL,
0x000000075e217211ULL, 0x000fc800078e18ffULL, 0x01b6904021ff79a7ULL, 0x0003e4000850003fULL,
0x000000014c1c7836ULL, 0x000fca0000000000ULL, 0x000000051c00720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000000400888947ULL, 0x002fea0003800000ULL,
0x00000003ff287819ULL, 0x100fe20000011608ULL, 0x000000ffff1e7224ULL, 0x000fe200078e0a59ULL,
0x00000059061d7248ULL, 0x000fe20007fe0000ULL, 0x00000080001c7824ULL, 0x000fe200078e0245ULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000428227836ULL, 0x000fe20000000000ULL,
0x000000201d237446ULL, 0x000fe2000380001eULL, 0x00000001281e7824ULL, 0x040fe200078e0208ULL,
0x000000ff001d7202ULL, 0x000fe20000000f00ULL, 0x0000000128217824ULL, 0x140fe200078e0229ULL,
0x000000232800720cULL, 0x080fe20003f06070ULL, 0x00000001221f7824ULL, 0x000fe200078e0229ULL,
0x000000071e257812ULL, 0x000fe200078ec0ffULL, 0x0000010021207825ULL, 0x000fe200078e001cULL,
0x000000232200720cULL, 0x000fc40003f26070ULL, 0x0ffffff825257812ULL, 0x000fe200078ef808ULL,
0x0000000122247824ULL, 0x040fe200078e0208ULL, 0x0000000420207c10ULL, 0x000fe2000ff5e0ffULL,
0x00000008222b7824ULL, 0x000fe200078e00ffULL, 0x0000001028427810ULL, 0x000fe20007ffe0ffULL,
0x000001001f1e7825ULL, 0x000fe200078e001cULL, 0x0000000521217c10ULL, 0x000fe400097fe4ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee224ULL, 0x0000000828227836ULL, 0x000fe20000000000ULL,
0x000000041e1e7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001025277824ULL, 0x000fc400078e0256ULL,
0x000000102b2b7824ULL, 0x000fe200078e0256ULL, 0x000000051f1f7c10ULL, 0x000fe20009ffe4ffULL,
0x0000000122257824ULL, 0x040fe200078e0229ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020277faeULL, 0x0003e2000c101c46ULL, 0x0000000c282a7836ULL, 0x000fe20000000000ULL,
0x000000232200720cULL, 0x0c0fe20003fa6070ULL, 0x0000000122247824ULL, 0x000fe200078e0208ULL,
0x000000001e2b7faeULL, 0x0007e2000c901c46ULL, 0x0000001428607836ULL, 0x000fe20000000000ULL,
0x000000232a00720cULL, 0x080fe20003f86070ULL, 0x0000001828627836ULL, 0x000fe20000000000ULL,
0x000000234200720cULL, 0x080fe20003f66070ULL, 0x0000001c28287836ULL, 0x000fe20000000000ULL,
0x000000236000720cULL, 0x080fe20003f46070ULL, 0x000000082a417824ULL, 0x000fe200078e00ffULL,
0x000000236200720cULL, 0x000fe20003f26070ULL, 0x0000010025207825ULL, 0x002fe200078e001cULL,
0x0000002942257210ULL, 0x000fc40007ffe0ffULL, 0x000000232800720cULL, 0x000fe20003f06070ULL,
0x000000012a1f7824ULL, 0x008fe200078e0229ULL, 0x0000000420267c10ULL, 0x000fe2000ffde0ffULL,
0x0000000822277824ULL, 0x000fe200078e00ffULL, 0x0000000360597819ULL, 0x000fe200000006ffULL,
0x000001001f1e7825ULL, 0x000fc600078e001cULL, 0xfffffff8272b7812ULL, 0x000fe200078ee224ULL,
0x000000012a227824ULL, 0x000fe200078e0208ULL, 0x0000000521277c10ULL, 0x000fe2000b7fe4ffULL,
0x0000010025207825ULL, 0x000fe200078e001cULL, 0x000000041e1e7c10ULL, 0x000fe4000ffde0ffULL,
0xfffffff841417812ULL, 0x000fe200078ee222ULL, 0x0000000160237824ULL, 0x100fe200078e0229ULL,
0x000000051f1f7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000162257824ULL, 0x000fe200078e0229ULL,
0x0000000420207c10ULL, 0x000fe2000ffde0ffULL, 0x0000010023227825ULL, 0x000fc600078e001cULL,
0x0000000521217c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000128297824ULL, 0x000fe200078e0229ULL,
0x0000000422227c10ULL, 0x000fe2000ffde0ffULL, 0x00000001422a7824ULL, 0x040fe400078e0208ULL,
0x0000000842437824ULL, 0x000fe200078e00ffULL, 0x0000000523237c10ULL, 0x000fe2000b7fe4ffULL,
0x0000010025247825ULL, 0x000fc600078e001cULL, 0xfffffff843437812ULL, 0x000fe200078ee22aULL,
0x00000100291c7825ULL, 0x000fe200078e001cULL, 0x0000000424247c10ULL, 0x000fe4000ffde0ffULL,
0x0000005643437211ULL, 0x000fe200078e20ffULL, 0x0000000160427824ULL, 0x100fe200078e0208ULL,
0x0000000525257c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000162297824ULL, 0x140fe200078e0208ULL,
0x000000041c1c7c10ULL, 0x000fe2000ffde0ffULL, 0x0000000862627824ULL, 0x000fe200078e00ffULL,
0xfffffff859597812ULL, 0x000fe200078ee242ULL, 0x00000001282a7824ULL, 0x040fe200078e0208ULL,
0x000000051d1d7c10ULL, 0x000fe2000b7fe4ffULL, 0x00000008285b7824ULL, 0x000fe200078e00ffULL,
0xfffffff862297812ULL, 0x000fe200078ee229ULL, 0x000000102b2b7824ULL, 0x000fc400078e0256ULL,
0x0000001041417824ULL, 0x100fe200078e0256ULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee22aULL,
0x0000001059597824ULL, 0x100fe200078e0256ULL, 0x00000000262b7faeULL, 0x0003e2000e901c46ULL,
0x0000001029297824ULL, 0x100fe400078e0256ULL, 0x000000105b5b7824ULL, 0x000fe200078e0256ULL,
0x000000001e417faeULL, 0x0003e8000e101c46ULL, 0x0000000020437faeULL, 0x0003e8000d901c46ULL,
0x0000000022597faeULL, 0x0003e8000d101c46ULL, 0x0000000024297faeULL, 0x0003e8000c901c46ULL,
0x000000001c5b7faeULL, 0x0003e2000c101c46ULL, 0x0000000400547947ULL, 0x000fea0003800000ULL,
0x0000000408277811ULL, 0x040fe200078fe8ffULL, 0x00008e0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000008082b7811ULL, 0x040fe400078fe8ffULL, 0x0000000c081f7811ULL, 0x040fe200078fe8ffULL,
0x0000000127617824ULL, 0x140fe200078e0208ULL, 0x0000001008217811ULL, 0x040fe200078fe8ffULL,
0x00000008271c7824ULL, 0x000fe200078e00ffULL, 0x000000081f5b7210ULL, 0x000fe20007ffe0ffULL,
0x000000012b5f7824ULL, 0x140fe200078e0208ULL, 0x0000001c081d7811ULL, 0x040fe200078fe8ffULL,
0x000000082b1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c617812ULL, 0x000fe200078ee261ULL,
0x000000081f1c7824ULL, 0x000fe200078e00ffULL, 0x0000001408237811ULL, 0x040fe200078fe8ffULL,
0x0000000121597824ULL, 0x100fe200078e0208ULL, 0x0000001808637811ULL, 0x000fe200078fe8ffULL,
0x000000011d657824ULL, 0x100fe200078e0229ULL, 0xfffffff81e5f7812ULL, 0x000fe200078ee25fULL,
0x00000008211e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c5b7812ULL, 0x000fe200078ee25bULL,
0x000000081d677824ULL, 0x000fe200078e00ffULL, 0x00000045001c7211ULL, 0x000fe200078e38ffULL,
0x0000000123437824ULL, 0x140fe200078e0208ULL, 0x000000081d427210ULL, 0x000fe20007ffe0ffULL,
0x0000000823207824ULL, 0x000fe200078e00ffULL, 0x0000002908257211ULL, 0x000fe200078fe8ffULL,
0x000000011f1f7824ULL, 0x000fe200078e0229ULL, 0xfffffff81e597812ULL, 0x000fe200078ee259ULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0xfffffff820437812ULL, 0x000fe200078ee243ULL,
0x0000000163417824ULL, 0x000fc400078e0208ULL, 0x0000000863227824ULL, 0x000fe200078e00ffULL,
0x0000005643437211ULL, 0x000fe200078e20ffULL, 0x0000000121217824ULL, 0x100fe400078e0229ULL,
0x0000000123237824ULL, 0x100fe200078e0229ULL, 0xfffffff822417812ULL, 0x000fe200078ee241ULL,
0x0000000127277824ULL, 0x100fe400078e0229ULL, 0x000000012b2b7824ULL, 0x100fe400078e0229ULL,
0x0000000163637824ULL, 0x000fc400078e0229ULL, 0x000001001f287825ULL, 0x000fc800078e001cULL,
0x00000100211e7825ULL, 0x000fc800078e001cULL, 0x0000010023207825ULL, 0x000fe200078e001cULL,
0x000000041e1e7c10ULL, 0x000fc6000ff5e0ffULL, 0x0000010025247825ULL, 0x000fe200078e001cULL,
0x000000051f1f7c10ULL, 0x000fc600097fe4ffULL, 0x0000010027267825ULL, 0x000fe200078e001cULL,
0x0000000424247c10ULL, 0x000fc6000ff1e0ffULL, 0x000001002b2a7825ULL, 0x100fe200078e001cULL,
0x0000000426267c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000525257c10ULL, 0x000fe200087fe4ffULL,
0x0000010063227825ULL, 0x100fe200078e001cULL, 0x0000000527277c10ULL, 0x000fe40008ffe4ffULL,
0x000000042a2a7c10ULL, 0x000fe2000ff1e0ffULL, 0x00000100651c7825ULL, 0x000fe200078e001cULL,
0xfffffff867657812ULL, 0x000fe400078ee242ULL, 0x0000000808427211ULL, 0x000fe200078fe8ffULL,
0x0000001061617824ULL, 0x100fe200078e0256ULL, 0x0000000428287c10ULL, 0x000fe2000ff3e0ffULL,
0x000000105f5f7824ULL, 0x100fe200078e0256ULL, 0x0000000742637812ULL, 0x000fe200078ec0ffULL,
0x000000105b5b7824ULL, 0x100fe200078e0256ULL, 0x000000052b2b7c10ULL, 0x000fe200087fe4ffULL,
0x0000001059597824ULL, 0x100fe200078e0256ULL, 0x0ffffff863637812ULL, 0x000fe200078ef808ULL,
0x0000001041417824ULL, 0x100fe200078e0256ULL, 0x0000000529297c10ULL, 0x000fe20008ffe4ffULL,
0x0000001065657824ULL, 0x100fe200078e0256ULL, 0x0000000420207c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001063637824ULL, 0x000fe200078e0256ULL, 0x0000000422227c10ULL, 0x000fc4000ff3e0ffULL,
0x000000041c1c7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000521217c10ULL, 0x000fe200087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024637faeULL, 0x0003e2000b901c46ULL,
0x0000000523237c10ULL, 0x000fe40008ffe4ffULL, 0x000000051d1d7c10ULL, 0x000fe200097fe4ffULL,
0x0000000026617faeULL, 0x0003e8000b901c46ULL, 0x000000002a5f7faeULL, 0x0003e8000b901c46ULL,
0x00000000285b7faeULL, 0x0003e8000b901c46ULL, 0x000000001e597faeULL, 0x0003e8000b901c46ULL,
0x0000000020437faeULL, 0x0003e8000b901c46ULL, 0x0000000022417faeULL, 0x0003e8000b901c46ULL,
0x000000001c657faeULL, 0x0003e4000b901c46ULL, 0x00000010041d7812ULL, 0x002fe200078ec0ffULL,
0x000000205e5e7824ULL, 0x000fe200078e0207ULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000011d1d7824ULL, 0x000fc800078e025eULL, 0x0000000800217824ULL, 0x000fc800078e021dULL,
0x01b64840214079a7ULL, 0x0002e6000850003fULL, 0x00000000001c7805ULL, 0x000fce0000015200ULL,
0x01b64841210075a7ULL, 0x008ee4000800017fULL, 0x00000000005c0947ULL, 0x008fea0003800000ULL,
0x000000ffff207224ULL, 0x000fce00078e00ffULL, 0x000000102000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fce0000015200ULL,
0x0000001e1c237210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000231e1e7211ULL, 0x000fc800078110ffULL,
0x0000001fff1f7210ULL, 0x000fc800007fe4ffULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000120207836ULL, 0x000fce0000000000ULL, 0x01b64841210075a7ULL, 0x000ee4000800017fULL,
0xfffffffc00a88947ULL, 0x008fea000383ffffULL, 0x000000200a1c7824ULL, 0x000fca00078e00ffULL,
0xffffff801c1c7812ULL, 0x000fc800078ec0ffULL, 0x00000100071c7810ULL, 0x000fc80007ffe01cULL,
0x0000001c501c7210ULL, 0x000fca0007ffe045ULL, 0x01b000001c1d7984ULL, 0x000ee80000000800ULL,
0x01b200001c597984ULL, 0x0009220000000800ULL, 0x0000005a1d00720bULL, 0x008fda0003f1d000ULL,
0x00000000001e7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff1e207812ULL, 0x000fda000782c0ffULL, 0x0000000000f89947ULL, 0x016fea0003800000ULL,
0x000000020a1f7811ULL, 0x000fe400078ff0ffULL, 0x0000005a1d00720bULL, 0x000fe40003f14000ULL,
0x0000000a1f00720cULL, 0x000fd60003f25270ULL, 0x00000000001f7806ULL, 0x000fe400000e0100ULL,
0x000000800a1e9824ULL, 0x000fe200078e0207ULL, 0x0000005a1d1c9209ULL, 0x000fc80007810000ULL,
0x0000001e50219210ULL, 0x000fe40007ffe045ULL, 0x000099101f1e7816ULL, 0x000fc600000000ffULL,
0x01b4001c21009388ULL, 0x0003e20000000800ULL, 0x000000ff1e00720cULL, 0x000fda0003f05270ULL,
0x0000000000b48947ULL, 0x002fea0003800000ULL, 0x0000005a1d217209ULL, 0x000fe40007810000ULL,
0x000000ff1fff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff001fff7812ULL, 0x000fe2000782c0ffULL,
0x0000005a211c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL,
0x0000001c00217308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff1c7819ULL, 0x002fcc0000011608ULL, 0x00001f1c211c7589ULL, 0x004e6400000e0000ULL,
0x0000002c1c2c7220ULL, 0x042fe20000410000ULL, 0x0000002d1c2d7220ULL, 0x040fe20000410000ULL,
0x000000301c307220ULL, 0x040fe20000410000ULL, 0x000000311c317220ULL, 0x040fe20000410000ULL,
0x000000341c347220ULL, 0x040fe20000410000ULL, 0x000000351c357220ULL, 0x040fe20000410000ULL,
0x000000381c387220ULL, 0x040fe20000410000ULL, 0x000000391c397220ULL, 0x040fe20000410000ULL,
0x0000003c1c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d1c3d7220ULL, 0x040fe20000410000ULL,
0x000000101c107220ULL, 0x040fe20000410000ULL, 0x000000111c117220ULL, 0x040fe20000410000ULL,
0x000000141c147220ULL, 0x040fe20000410000ULL, 0x000000151c157220ULL, 0x040fe20000410000ULL,
0x000000181c187220ULL, 0x040fe20000410000ULL, 0x000000191c197220ULL, 0x000fce0000410000ULL,
0x000000215c5c7220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x00000008081c7811ULL, 0x002fcc00078ff0ffULL, 0x00001f1c211c7589ULL, 0x000e6400000e0000ULL,
0x0000002e1c2e7220ULL, 0x042fe20000410000ULL, 0x0000002f1c2f7220ULL, 0x040fe20000410000ULL,
0x000000321c327220ULL, 0x040fe20000410000ULL, 0x000000331c337220ULL, 0x040fe20000410000ULL,
0x000000361c367220ULL, 0x040fe20000410000ULL, 0x000000371c377220ULL, 0x040fe20000410000ULL,
0x0000003a1c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b1c3b7220ULL, 0x040fe20000410000ULL,
0x0000003e1c3e7220ULL, 0x040fe20000410000ULL, 0x0000003f1c3f7220ULL, 0x040fe20000410000ULL,
0x000000121c127220ULL, 0x040fe20000410000ULL, 0x000000131c137220ULL, 0x040fe20000410000ULL,
0x000000161c167220ULL, 0x040fe20000410000ULL, 0x000000171c177220ULL, 0x040fe20000410000ULL,
0x0000001a1c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b1c1b7220ULL, 0x000fce0000410000ULL,
0x0000ffff20ff7812ULL, 0x000fe4000780601fULL, 0x0000005a1d5a7209ULL, 0x000fd60007810000ULL,
0x8000005a1d1d0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1d1d0820ULL, 0x000fc80000410000ULL,
0x0000001d000c0308ULL, 0x000ea40000000800ULL, 0x0000000c59590220ULL, 0x004fce0000410000ULL,
0x000020000a1c7824ULL, 0x042fe200078e00ffULL, 0x0000004e4b5b7212ULL, 0x000fe200078efcffULL,
0x000002000a1d7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xffffc0001c1c7812ULL, 0x000fe200078ec0ffULL, 0x000000085b207824ULL, 0x000fe200078e00ffULL,
0xfffff8001d1e7812ULL, 0x000fc600078ec0ffULL, 0x00000001071d7824ULL, 0x000fe200078e021cULL,
0xfffffff8205d7812ULL, 0x000fe400078ee25dULL, 0x0000001e071e7210ULL, 0x000fe20007ffe0ffULL,
0x00002000001d7824ULL, 0x000fc800078e021dULL, 0x000000105d1e7824ULL, 0x000fe400078e021eULL,
0x000130001d207836ULL, 0x000fe20000000000ULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff1d7819ULL, 0x000fe40000011608ULL, 0x0000000cff0d723eULL, 0x000fc600000000ffULL,
0x000000081d1f7836ULL, 0x000fe20000000000ULL, 0x000054100d1c7816ULL, 0x000fca000000000dULL,
0x00001f1d1c0d7589ULL, 0x0002a800000e0000ULL, 0x00001f1f1c0e7589ULL, 0x0002e400000e0000ULL,
0x012000001e1c783bULL, 0x002e620000000200ULL, 0x0000001047407824ULL, 0x100fe400078e0220ULL,
0x0000001046287824ULL, 0x000fe200078e0220ULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000d1c1c7232ULL, 0x086fe40000000000ULL, 0x0000000d1e1e7232ULL, 0x000fe40000000000ULL,
0x0000000e1d1d7232ULL, 0x088fe40000000000ULL, 0x0000000e1f1f7232ULL, 0x000fce0000000000ULL,
0x000000004040783bULL, 0x000f220000004200ULL, 0x0000001044247824ULL, 0x000fe200078e0220ULL,
0x0000002049207211ULL, 0x000fe400078e20ffULL, 0x000000002828783bULL, 0x000f620000004200ULL,
0x00000002ff5e7819ULL, 0x000fc6000001160aULL, 0x000000002424783bULL, 0x000f680000004200ULL,
0x000000002020783bULL, 0x000f620000004200ULL, 0x000000401c2c723cULL, 0x012fec000000182cULL,
0x000000281c34723cULL, 0x028fe20000001834ULL, 0x000000020a417824ULL, 0x000fca00078e00ffULL,
0x000000241c3c723cULL, 0x004fe2000000183cULL, 0x0000000441297812ULL, 0x000fc800078ec0ffULL,
0x0000000229297812ULL, 0x000fe200078efcffULL, 0x000000201c14723cULL, 0x000fe20000001814ULL,
0x0000400052257824ULL, 0x000fe400078e0207ULL, 0x0000002908247211ULL, 0x000fe400078fe0ffULL,
0x0000200000257824ULL, 0x000fe200078e0225ULL, 0x000000421c30723cULL, 0x000fe20000001830ULL,
0x000008005e207824ULL, 0x000fe400078e0207ULL, 0x000000015b247824ULL, 0x000fc400078e0224ULL,
0x000000085b5b7824ULL, 0x000fe200078e00ffULL, 0x0000002a1c38723cULL, 0x000fe20000001838ULL,
0x0001300025607836ULL, 0x000fc60000000000ULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee224ULL,
0x0000001051247824ULL, 0x100fe200078e0260ULL, 0x000000261c10723cULL, 0x000fe20000001810ULL,
0x0000001053287824ULL, 0x100fe200078e0260ULL, 0x000000205b207211ULL, 0x000fe200078e20ffULL,
0x0000001054407824ULL, 0x000fc600078e0260ULL, 0x000000221c18723cULL, 0x000fe20000001818ULL,
0x01200000201c783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000d1c1c7232ULL, 0x084fe40000000000ULL,
0x0000000d1e1e7232ULL, 0x000fe40000000000ULL, 0x0000000e1d1d7232ULL, 0x080fe40000000000ULL,
0x0000000e1f1f7232ULL, 0x000fce0000000000ULL, 0x0000001057207824ULL, 0x002fe200078e0260ULL,
0x000000004040783bULL, 0x000e620000004200ULL, 0x0000005c59597221ULL, 0x000fc60000010000ULL,
0x000000002828783bULL, 0x000ee80000004200ULL, 0x000000002424783bULL, 0x000f280000004200ULL,
0x000000002020783bULL, 0x000f620000004200ULL, 0x000000401c2c723cULL, 0x006fec000000182cULL,
0x000000421c30723cULL, 0x000fe20000001830ULL, 0x00000001ff407424ULL, 0x000fca00078e00ffULL,
0x000000281c34723cULL, 0x008fec0000001834ULL, 0x0000002a1c38723cULL, 0x000fec0000001838ULL,
0x000000241c3c723cULL, 0x010fec000000183cULL, 0x000000261c10723cULL, 0x000fec0000001810ULL,
0x000000201c14723cULL, 0x020fec0000001814ULL, 0x000000221c18723cULL, 0x000fe20000001818ULL,
0x000000085e217824ULL, 0x000fc800078e0207ULL, 0x01b6984021ff79a7ULL, 0x0003e4000850003fULL,
0x000000010b1e7824ULL, 0x000fca00078e024cULL, 0x000000051e00720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0000000800f40947ULL, 0x002fea0003800000ULL,
0x000000011e1c7810ULL, 0x000fe20007ffe0ffULL, 0x000001001e1f7824ULL, 0x000fe200078e0203ULL,
0x0000920000047ab9ULL, 0x000fe40000000800ULL, 0x000000051c00720cULL, 0x000fe20003f06070ULL,
0x0000000402277c24ULL, 0x000fd8000f8e021fULL, 0x0000000400888947ULL, 0x000fea0003800000ULL,
0x00000003ff297819ULL, 0x100fe20000011608ULL, 0x000000ffff267224ULL, 0x000fe200078e0a1fULL,
0x0000001f061d7248ULL, 0x000fe20007fe0000ULL, 0x00000080001c7824ULL, 0x000fe200078e0245ULL,
0x0000002729217210ULL, 0x000fe20007ffe0ffULL, 0x0000000429257836ULL, 0x000fe20000000000ULL,
0x000000201d267446ULL, 0x000fe20003800026ULL, 0x000000ffff1d7224ULL, 0x000fe200078e00ffULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000001251e7824ULL, 0x040fe200078e0208ULL,
0x000000262500720cULL, 0x0c0fe20003f26070ULL, 0x0000000825417824ULL, 0x000fe200078e00ffULL,
0x000000262900720cULL, 0x000fe20003f06070ULL, 0x0000010021207825ULL, 0x000fc600078e001cULL,
0xfffffff841417812ULL, 0x000fe200078ee21eULL, 0x00000001291e7824ULL, 0x000fe200078e0208ULL,
0x0000000420207c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000125257824ULL, 0x000fe200078e0227ULL,
0x0000006041417211ULL, 0x000fe200078e20ffULL, 0x0000000829437836ULL, 0x000fe20000000000ULL,
0x000000071e2b7812ULL, 0x000fe200078ec0ffULL, 0x0000000c29517836ULL, 0x000fe20000000000ULL,
0x0000000521217c10ULL, 0x000fe200097fe4ffULL, 0x0000010025247825ULL, 0x000fe200078e001cULL,
0x0ffffff82b2b7812ULL, 0x000fc400078ef808ULL, 0x000000264300720cULL, 0x0c0fe20003fa6070ULL,
0x0000001029537836ULL, 0x000fe20000000000ULL, 0x0000000424247c10ULL, 0x000fe2000ff7e0ffULL,
0x00000001431f7824ULL, 0x100fe200078e0227ULL, 0x000000265100720cULL, 0x040fe20003f86070ULL,
0x0000000151237824ULL, 0x000fe200078e0227ULL, 0x0000000525257c10ULL, 0x000fe20009ffe4ffULL,
0x000000102b2b7824ULL, 0x000fe200078e0260ULL, 0x00000008512a7210ULL, 0x000fe20007ffe0ffULL,
0x0000001429577836ULL, 0x000fe40000000000ULL, 0x00000018295d7836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000202b7faeULL, 0x0003e2000c101c46ULL,
0x0000001c295f7836ULL, 0x000fc40000000000ULL, 0x0000000153297824ULL, 0x000fe200078e0227ULL,
0x0000000024417faeULL, 0x0005e2000c901c46ULL, 0x000001001f1e7825ULL, 0x100fe200078e001cULL,
0x000000265d00720cULL, 0x080fe40003f26070ULL, 0x000000265f00720cULL, 0x000fe20003f06070ULL,
0x0000010023227825ULL, 0x100fe200078e001cULL, 0x000000041e1e7c10ULL, 0x000fe4000ff5e0ffULL,
0x000000275f2b7210ULL, 0x002fe20007ffe0ffULL, 0x0000010029207825ULL, 0x000fe200078e001cULL,
0x0000000422227c10ULL, 0x000fc4000ff7e0ffULL, 0x000000051f1f7c10ULL, 0x000fe200097fe4ffULL,
0x0000000143287824ULL, 0x140fe200078e0208ULL, 0x0000000420247c10ULL, 0x004fe2000ffde0ffULL,
0x0000000843437824ULL, 0x000fe200078e00ffULL, 0x0000000523237c10ULL, 0x000fe20009ffe4ffULL,
0x0000000851517824ULL, 0x000fe200078e00ffULL, 0x000000265300720cULL, 0x080fe20003f66070ULL,
0x0000000157297824ULL, 0x040fe200078e0227ULL, 0xfffffff843417812ULL, 0x000fe200078ee228ULL,
0x0000000157287824ULL, 0x140fe200078e0208ULL, 0x000000265700720cULL, 0x000fe20003f46070ULL,
0x0000000153267824ULL, 0x040fe200078e0208ULL, 0xfffffff851437812ULL, 0x000fe200078ee22aULL,
0x0000000853517824ULL, 0x000fe200078e00ffULL, 0x0000000521257c10ULL, 0x000fe2000b7fe4ffULL,
0x0000010029207825ULL, 0x000fc600078e001cULL, 0xfffffff851517812ULL, 0x000fe200078ee226ULL,
0x000000015d297824ULL, 0x000fe200078e0227ULL, 0x0000000420207c10ULL, 0x000fe2000ffde0ffULL,
0x0000000857537824ULL, 0x000fe400078e00ffULL, 0x0000010029267825ULL, 0x000fe200078e001cULL,
0x0000000521217c10ULL, 0x000fe4000b7fe4ffULL, 0xfffffff853537812ULL, 0x000fe200078ee228ULL,
0x000000015d287824ULL, 0x140fe200078e0208ULL, 0x0000000426267c10ULL, 0x000fe2000ffde0ffULL,
0x000000085d297824ULL, 0x000fe200078e00ffULL, 0x0000006053537211ULL, 0x000fe200078e20ffULL,
0x000000015f2a7824ULL, 0x040fe200078e0208ULL, 0x0000000527277c10ULL, 0x000fe2000b7fe4ffULL,
0x000000085f5f7824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee228ULL,
0x000001002b1c7825ULL, 0x000fc600078e001cULL, 0xfffffff85f2b7812ULL, 0x000fe200078ee22aULL,
0x0000001041417824ULL, 0x100fe200078e0260ULL, 0x000000041c1c7c10ULL, 0x000fe2000ffde0ffULL,
0x0000001043437824ULL, 0x100fe400078e0260ULL, 0x0000001051517824ULL, 0x100fe200078e0260ULL,
0x000000051d1d7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001029297824ULL, 0x100fe200078e0260ULL,
0x000000001e417faeULL, 0x0003e2000e901c46ULL, 0x000000102b2b7824ULL, 0x000fc600078e0260ULL,
0x0000000022437faeULL, 0x0003e8000e101c46ULL, 0x0000000024517faeULL, 0x0003e8000d901c46ULL,
0x0000000020537faeULL, 0x0003e8000d101c46ULL, 0x0000000026297faeULL, 0x0003e8000c901c46ULL,
0x000000001c2b7faeULL, 0x0003e2000c101c46ULL, 0x0000000400547947ULL, 0x000fea0003800000ULL,
0x00000008081d7811ULL, 0x000fe200078fe8ffULL, 0x0000008000267824ULL, 0x000fe200078e0245ULL,
0x0000001008217811ULL, 0x040fe200078fe8ffULL, 0x00008e0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000408297811ULL, 0x040fe200078fe8ffULL, 0x000000011d437824ULL, 0x140fe200078e0208ULL,
0x0000000c081f7811ULL, 0x040fe200078fe8ffULL, 0x000000081d1e7824ULL, 0x000fe200078e00ffULL,
0x0000001408237811ULL, 0x040fe200078fe8ffULL, 0x00000008215d7824ULL, 0x000fe200078e00ffULL,
0x0000001808257811ULL, 0x040fe200078fe8ffULL, 0x0000000129417824ULL, 0x100fe200078e0208ULL,
0xfffffff81e437812ULL, 0x000fe200078ee243ULL, 0x00000001211e7824ULL, 0x100fe200078e0208ULL,
0x000000031f577819ULL, 0x000fe200000006ffULL, 0x00000008291c7824ULL, 0x000fe200078e00ffULL,
0x00000027082b7211ULL, 0x040fe200078fe8ffULL, 0x0000000123207824ULL, 0x140fe200078e0208ULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee21eULL, 0x00000008235f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c417812ULL, 0x000fe200078ee241ULL, 0x000000011f1c7824ULL, 0x100fe200078e0208ULL,
0x0000001c081e7811ULL, 0x040fe200078fe8ffULL, 0x0000000125227824ULL, 0x140fe200078e0208ULL,
0x0000002729297210ULL, 0x000fe20007ffe0ffULL, 0x0000000825617824ULL, 0x000fe200078e00ffULL,
0xfffffff857577812ULL, 0x000fe200078ee21cULL, 0x000000011d1d7824ULL, 0x100fe200078e0227ULL,
0x00000008081c7211ULL, 0x000fe200078fe8ffULL, 0x000000011f1f7824ULL, 0x100fe200078e0227ULL,
0x000000031e637819ULL, 0x000fe200000006ffULL, 0x0000000121217824ULL, 0x100fe200078e0227ULL,
0x000000071c537812ULL, 0x000fe200078ec0ffULL, 0x0000000123237824ULL, 0x100fe200078e0227ULL,
0xfffffff85f5f7812ULL, 0x000fe200078ee220ULL, 0x0000000125257824ULL, 0x100fe200078e0227ULL,
0xfffffff861617812ULL, 0x000fe200078ee222ULL, 0x000000011e517824ULL, 0x040fe200078e0227ULL,
0x0ffffff853537812ULL, 0x000fe200078ef808ULL, 0x000000ffff277224ULL, 0x000fe200078e00ffULL,
0x0000006061617211ULL, 0x000fe200078e20ffULL, 0x000000011e427824ULL, 0x000fc400078e0208ULL,
0x000001002b2a7825ULL, 0x000fc800078e0026ULL, 0x0000010029287825ULL, 0x000fe200078e0026ULL,
0x000000042a2a7c10ULL, 0x000fc6000ff1e0ffULL, 0x000001001d1c7825ULL, 0x100fe200078e0026ULL,
0x0000000428287c10ULL, 0x000fe4000ff3e0ffULL, 0x000000052b2b7c10ULL, 0x000fe200087fe4ffULL,
0x000001001f1e7825ULL, 0x100fe200078e0026ULL, 0x000000041c1c7c10ULL, 0x000fe4000ff5e0ffULL,
0x0000000529297c10ULL, 0x000fe20008ffe4ffULL, 0x0000010021207825ULL, 0x100fe200078e0026ULL,
0x000000041e1e7c10ULL, 0x000fe4000ff7e0ffULL, 0x000000051d1d7c10ULL, 0x000fe200097fe4ffULL,
0x0000010023227825ULL, 0x000fe200078e0026ULL, 0x0000000420207c10ULL, 0x000fc4000ff1e0ffULL,
0x000000051f1f7c10ULL, 0x000fe20009ffe4ffULL, 0x0000010025247825ULL, 0x100fe200078e0026ULL,
0x0000000422227c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000521217c10ULL, 0x000fe200087fe4ffULL,
0x0000010051267825ULL, 0x000fe200078e0026ULL, 0xfffffff863517812ULL, 0x000fe400078ee242ULL,
0x0000000424247c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001053537824ULL, 0x100fe200078e0260ULL,
0x0000000426267c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001041417824ULL, 0x100fe200078e0260ULL,
0x0000000523237c10ULL, 0x000fe20008ffe4ffULL, 0x0000001043437824ULL, 0x100fe200078e0260ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a537faeULL, 0x0003e2000b901c46ULL,
0x0000001057577824ULL, 0x100fe200078e0260ULL, 0x0000000525257c10ULL, 0x000fe200097fe4ffULL,
0x000000105d5d7824ULL, 0x100fe200078e0260ULL, 0x0000000028417faeULL, 0x0003e2000b901c46ULL,
0x000000105f5f7824ULL, 0x100fe200078e0260ULL, 0x0000000527277c10ULL, 0x000fe20009ffe4ffULL,
0x0000001051517824ULL, 0x000fe200078e0260ULL, 0x000000001c437faeULL, 0x0003e8000b901c46ULL,
0x000000001e577faeULL, 0x0003e8000b901c46ULL, 0x00000000205d7faeULL, 0x0003e8000b901c46ULL,
0x00000000225f7faeULL, 0x0003e8000b901c46ULL, 0x0000000024617faeULL, 0x0003e8000b901c46ULL,
0x0000000026517faeULL, 0x0003e4000b901c46ULL, 0x000000205e5e7824ULL, 0x000fe200078e0207ULL,
0x0000001004217812ULL, 0x042fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000008041c7812ULL, 0x000fc800078ec0ffULL, 0x0000005e1c217210ULL, 0x000fc80007ffe021ULL,
0x01b66840214079a7ULL, 0x0002a6000850003fULL, 0x00000000001c7805ULL, 0x000fce0000015200ULL,
0x01b66841210075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff207224ULL, 0x000fce00078e00ffULL, 0x000000102000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fce0000015200ULL,
0x0000001e1c237210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000231e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000120207836ULL, 0x000fce0000000000ULL, 0x01b66841210075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x000000030a1c7811ULL, 0x000fe400078ff0ffULL,
0x0000005a00517202ULL, 0x000fc60000000f00ULL, 0x000000801c1d7824ULL, 0x000fca00078e0207ULL,
0x0000001d501d7210ULL, 0x000fca0007ffe045ULL, 0x01b000001d1f7984ULL, 0x000ea80000000800ULL,
0x01b200001d537984ULL, 0x0006e20000000800ULL, 0x0000005a1f00720bULL, 0x004fda0003f1d000ULL,
0x00000000001e7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff1e207812ULL, 0x000fda000782c0ffULL, 0x0000000000f49947ULL, 0x00afea0003800000ULL,
0x0000000a1c00720cULL, 0x000fe40003f25270ULL, 0x0000005a1f00720bULL, 0x000fd60003f14000ULL,
0x000000800a1e9824ULL, 0x000fe200078e0207ULL, 0x0000005a1f1d9209ULL, 0x000fe40007810000ULL,
0x0000000000217806ULL, 0x000fe400000e0100ULL, 0x0000001e50509210ULL, 0x000fe40007ffe045ULL,
0x00009910211e7816ULL, 0x000fc600000000ffULL, 0x01b4001d50009388ULL, 0x0003e20000000800ULL,
0x000000ff1e00720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005a1f1d7209ULL, 0x000fe40007810000ULL, 0x000000ff21ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0021ff7812ULL, 0x000fe2000782c0ffULL, 0x0000005a1d1d7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1d1d7820ULL, 0x000fc80000410000ULL, 0x0000001d001e7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff1d7819ULL, 0x002fcc0000011608ULL,
0x00001f1d1e1d7589ULL, 0x004e6400000e0000ULL, 0x0000002c1d2c7220ULL, 0x042fe20000410000ULL,
0x0000002d1d2d7220ULL, 0x040fe20000410000ULL, 0x000000301d307220ULL, 0x040fe20000410000ULL,
0x000000311d317220ULL, 0x040fe20000410000ULL, 0x000000341d347220ULL, 0x040fe20000410000ULL,
0x000000351d357220ULL, 0x040fe20000410000ULL, 0x000000381d387220ULL, 0x040fe20000410000ULL,
0x000000391d397220ULL, 0x040fe20000410000ULL, 0x0000003c1d3c7220ULL, 0x040fe20000410000ULL,
0x0000003d1d3d7220ULL, 0x040fe20000410000ULL, 0x000000101d107220ULL, 0x040fe20000410000ULL,
0x000000111d117220ULL, 0x040fe20000410000ULL, 0x000000141d147220ULL, 0x040fe20000410000ULL,
0x000000151d157220ULL, 0x040fe20000410000ULL, 0x000000181d187220ULL, 0x040fe20000410000ULL,
0x000000191d197220ULL, 0x000fce0000410000ULL, 0x0000001e59597220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x00000008081d7811ULL, 0x002fcc00078ff0ffULL,
0x00001f1d1e1d7589ULL, 0x000e6400000e0000ULL, 0x0000002e1d2e7220ULL, 0x042fe20000410000ULL,
0x0000002f1d2f7220ULL, 0x040fe20000410000ULL, 0x000000321d327220ULL, 0x040fe20000410000ULL,
0x000000331d337220ULL, 0x040fe20000410000ULL, 0x000000361d367220ULL, 0x040fe20000410000ULL,
0x000000371d377220ULL, 0x040fe20000410000ULL, 0x0000003a1d3a7220ULL, 0x040fe20000410000ULL,
0x0000003b1d3b7220ULL, 0x040fe20000410000ULL, 0x0000003e1d3e7220ULL, 0x040fe20000410000ULL,
0x0000003f1d3f7220ULL, 0x040fe20000410000ULL, 0x000000121d127220ULL, 0x040fe20000410000ULL,
0x000000131d137220ULL, 0x040fe20000410000ULL, 0x000000161d167220ULL, 0x040fe20000410000ULL,
0x000000171d177220ULL, 0x040fe20000410000ULL, 0x0000001a1d1a7220ULL, 0x040fe20000410000ULL,
0x0000001b1d1b7220ULL, 0x000fce0000410000ULL, 0x0000ffff20ff7812ULL, 0x000fe40007806021ULL,
0x0000005a1f517209ULL, 0x000fd60007810000ULL, 0x800000511f1f0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b1f1f0820ULL, 0x000fc80000410000ULL, 0x0000001f000c0308ULL, 0x000ea40000000800ULL,
0x0000000c53530220ULL, 0x004fce0000410000ULL, 0x000000020a1d7824ULL, 0x002fe200078e00ffULL,
0x0000004e4b4e7212ULL, 0x000fe200078efcffULL, 0x000008001c207824ULL, 0x000fe200078e0207ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000041d1d7812ULL, 0x000fe200078ec0ffULL,
0x000000084e1e7824ULL, 0x000fe200078e00ffULL, 0x0000005644247211ULL, 0x000fe200078e20ffULL,
0x0000001047477824ULL, 0x100fe200078e0256ULL, 0x0000001d081d7211ULL, 0x000fe200078fe0ffULL,
0x0000001046407824ULL, 0x000fc800078e0256ULL, 0x000000014e1d7824ULL, 0x000fca00078e021dULL,
0xfffffff81e1d7812ULL, 0x000fca00078ee21dULL, 0x000000101d1d7824ULL, 0x000fe200078e0220ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff1f7819ULL, 0x000fe40000011608ULL,
0x0000000cff0d723eULL, 0x000fc600000000ffULL, 0x000000081f217836ULL, 0x000fe20000000000ULL,
0x000054100d1c7816ULL, 0x000fca000000000dULL, 0x00001f1f1c0d7589ULL, 0x0002a800000e0000ULL,
0x00001f211c0e7589ULL, 0x0002e400000e0000ULL, 0x011000001d1c783bULL, 0x002e620000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000d1c1c7232ULL, 0x086fe40000000000ULL,
0x0000000d1e1e7232ULL, 0x000fe40000000000ULL, 0x0000000e1d1d7232ULL, 0x088fe40000000000ULL,
0x0000000e1f1f7232ULL, 0x000fce0000000000ULL, 0x0000001049287824ULL, 0x000fe200078e0256ULL,
0x000000004744783bULL, 0x000f220000004200ULL, 0x000000105b207824ULL, 0x000fe400078e0220ULL,
0x0000005953567221ULL, 0x000fe20000010000ULL, 0x000000004040783bULL, 0x000f680000004200ULL,
0x000000002424783bULL, 0x000f680000004200ULL, 0x000000002828783bULL, 0x000f680000004200ULL,
0x011000002020783bULL, 0x000f620000000200ULL, 0x000000441c2c723cULL, 0x012fec000000182cULL,
0x000000461c30723cULL, 0x000fec0000001830ULL, 0x000000401c34723cULL, 0x028fec0000001834ULL,
0x000000421c38723cULL, 0x000fec0000001838ULL, 0x000000241c3c723cULL, 0x004fec000000183cULL,
0x000000261c10723cULL, 0x000fec0000001810ULL, 0x000000281c14723cULL, 0x000fec0000001814ULL,
0x0000002a1c1c723cULL, 0x000fe20000001818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000d20207232ULL, 0x080fe40000000000ULL,
0x0000000d22227232ULL, 0x000fe40000000000ULL, 0x0000000e21217232ULL, 0x080fe40000000000ULL,
0x0000000e23237232ULL, 0x000fce0000000000ULL, 0x000000004f24783bULL, 0x000e620000004200ULL,
0x000000010b4c7824ULL, 0x000fc600078e024cULL, 0x000000004d18783bULL, 0x000ea40000004200ULL,
0x000000054c00720cULL, 0x000fe40003f06070ULL, 0x000000005840783bULL, 0x000ee80000004200ULL,
0x000000005528783bULL, 0x000f220000004200ULL, 0x00000024203c723cULL, 0x002fec000000183cULL,
0x000000182014723cULL, 0x004fe20000001814ULL, 0x00000002ff247819ULL, 0x000fca000001160aULL,
0x0000000824247824ULL, 0x000fe200078e0207ULL, 0x00000040202c723cULL, 0x008fe2000000182cULL,
0x00000001ff197424ULL, 0x000fc800078e00ffULL, 0x01b6a01924ff79a7ULL, 0x0003e2000850003fULL,
0x000000422030723cULL, 0x000fec0000001830ULL, 0x000000282034723cULL, 0x010fec0000001834ULL,
0x0000002a2038723cULL, 0x000fec0000001838ULL, 0x000000262010723cULL, 0x000fec0000001810ULL,
0x0000001a201c723cULL, 0x000fe2000000181cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffa000288947ULL, 0x002fde000383ffffULL, 0x00000000000c7919ULL, 0x000e620000002500ULL,
0x0000001d00207202ULL, 0x000fe20000000f00ULL, 0x000000ffff217224ULL, 0x000fe400078e001cULL,
0x000000ffff1d7224ULL, 0x000fe400078e0016ULL, 0x000000ffff067224ULL, 0x000fe400078e0017ULL,
0x000000ffff167224ULL, 0x000fe400078e0015ULL, 0x000000ffff1c7224ULL, 0x000fe200078e0012ULL,
0x0000001100127202ULL, 0x000fe20000000f00ULL, 0x000000ffff177224ULL, 0x000fc400078e0014ULL,
0x000000ffff087224ULL, 0x000fe400078e0013ULL, 0x000000ffff157224ULL, 0x000fe200078e0010ULL,
0x000000050c00720cULL, 0x002fda0003f06070ULL, 0x0000000000c80947ULL, 0x000fea0003800000ULL,
0x0180000056027836ULL, 0x000fca0000000000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe200078e0056ULL, 0x00007b90000d7802ULL, 0x000fce0000000f00ULL,
0x000000b000887944ULL, 0x000fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000005600057308ULL, 0x000e640000001000ULL, 0xbf80000005027423ULL, 0x002fc80000000056ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000205027223ULL, 0x000fce0000000005ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x00000002ff0d7819ULL, 0x002fe40000011605ULL,
0x0000000805057811ULL, 0x000fe200078ff0ffULL, 0x0000000000007948ULL, 0x008fea0003800000ULL,
0x00001f0d02047589ULL, 0x000e6800000e0000ULL, 0x00001f0502057589ULL, 0x000ea200000e0000ULL,
0x0000002c042c7220ULL, 0x042fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000003804387220ULL, 0x040fe20000410000ULL, 0x0000003904397220ULL, 0x040fe20000410000ULL,
0x0000003c043c7220ULL, 0x040fe20000410000ULL, 0x0000003d043d7220ULL, 0x040fe20000410000ULL,
0x0000001504157220ULL, 0x040fe20000410000ULL, 0x0000001204127220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x040fe20000410000ULL, 0x0000001604167220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x000fe20000410000ULL,
0x0000002e052e7220ULL, 0x044fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000003a053a7220ULL, 0x040fe20000410000ULL, 0x0000003b053b7220ULL, 0x040fe20000410000ULL,
0x0000003e053e7220ULL, 0x040fe20000410000ULL, 0x0000003f053f7220ULL, 0x040fe20000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x0000000805087220ULL, 0x040fe20000410000ULL,
0x0000001d051d7220ULL, 0x040fe20000410000ULL, 0x0000000605067220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x000fce0000410000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x000000171616723eULL, 0x000fe400000000ffULL,
0x000000212017723eULL, 0x000fe200000000ffULL, 0x0000080052217824ULL, 0x000fe200078e00ffULL,
0x0000002c2d18723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000303119723eULL, 0x000fc400000000ffULL, 0x00000034351a723eULL, 0x000fe400000000ffULL,
0x00000038391b723eULL, 0x000fe400000000ffULL, 0x000000151215723eULL, 0x000fe400000000ffULL,
0x000000363712723eULL, 0x000fe400000000ffULL, 0x0000003a3b13723eULL, 0x000fe400000000ffULL,
0x0000001d0606723eULL, 0x000fc400000000ffULL, 0x000000010b00780cULL, 0x000fe40003f05270ULL,
0xfffffff8ff057812ULL, 0x002fe200078ee202ULL, 0x00000001032b7824ULL, 0x100fe200078e0202ULL,
0x00000003ff0d7819ULL, 0x000fc60000011602ULL, 0x0000000805117836ULL, 0x000fe20000000000ULL,
0x000000030d047812ULL, 0x000fe200078ec0ffULL, 0x0000000805147824ULL, 0x000fe400078e00ffULL,
0x0000000811277824ULL, 0x000fe200078e00ffULL, 0x00000011040e7210ULL, 0x000fe20007ffe0ffULL,
0x0000000805257824ULL, 0x000fe400078e00ffULL, 0x0000000104057824ULL, 0x000fe200078e0205ULL,
0xfffffff827277812ULL, 0x000fe200078ee20eULL, 0x00001000000e7824ULL, 0x000fe200078e0207ULL,
0x0000001e1f07723eULL, 0x000fe200000000ffULL, 0x0000000405047836ULL, 0x000fe20000000000ULL,
0xfffffff814237812ULL, 0x000fe200078ee205ULL, 0x0000000811297824ULL, 0x000fe200078e00ffULL,
0x0000003c3d14723eULL, 0x000fe200000000ffULL, 0x0000000c05107836ULL, 0x000fe20000000000ULL,
0x0000001c0805723eULL, 0x000fe200000000ffULL, 0x000000010e087824ULL, 0x000fe200078e0221ULL,
0xfffffff825257812ULL, 0x000fe200078ee204ULL, 0x000000102b287824ULL, 0x000fe200078e020eULL,
0xfffffff829297812ULL, 0x000fe200078ee210ULL, 0x0000001027227824ULL, 0x100fe200078e0208ULL,
0x0000000823237211ULL, 0x000fe200078e20ffULL, 0x0000001025207824ULL, 0x100fe200078e0208ULL,
0x0000002e2f10723eULL, 0x000fe200000000ffULL, 0x0000001029297824ULL, 0x000fe200078e0208ULL,
0x000000323311723eULL, 0x000fe200000000ffULL, 0x0000001823007844ULL, 0x000fe20000000200ULL,
0x0000003e3f04723eULL, 0x000fc600000000ffULL, 0x0000001420007844ULL, 0x000fe80000000200ULL,
0x0000001022007844ULL, 0x000fe80000000200ULL, 0x0000000429007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000282c7984ULL, 0x000e680000000c00ULL,
0x0004000028247984ULL, 0x000ea80000000c00ULL, 0x0008000028307984ULL, 0x000ee80000000c00ULL,
0x000c0000281c7984ULL, 0x000f220000000c00ULL, 0x200000ff2f2f7230ULL, 0x002fc40000000000ULL,
0x200000ff2e2e7230ULL, 0x000fe40000000000ULL, 0x200000ff2d2d7230ULL, 0x000fe40000000000ULL,
0x200000ff2c2c7230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x004fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fc40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x000000332f2f7230ULL, 0x008fe40000000000ULL,
0x000000322e2e7230ULL, 0x000fe40000000000ULL, 0x000000312d2d7230ULL, 0x000fe40000000000ULL,
0x000000302c2c7230ULL, 0x000fe40000000000ULL, 0x0000001f27277230ULL, 0x010fc40000000000ULL,
0x0000001e26267230ULL, 0x000fe20000000000ULL, 0x0000002c28007388ULL, 0x0003e20000000c00ULL,
0x0000001d25257230ULL, 0x000fe40000000000ULL, 0x0000001c24247230ULL, 0x000fca0000000000ULL,
0x0004002428007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000002400cc8947ULL, 0x000fea0003800000ULL, 0x00000400ff167b82ULL, 0x000ea20000000800ULL,
0x00000000001b7919ULL, 0x000ee20000002600ULL, 0x000000402b257836ULL, 0x002fe20000000000ULL,
0x00000000001a7919ULL, 0x000eea0000002700ULL, 0x00009400ff057b82ULL, 0x000eb00000000800ULL,
0x00009800ff147b82ULL, 0x000e620000000a00ULL, 0x0000000516047224ULL, 0x004fc800078e02ffULL,
0x0000000b04107224ULL, 0x0c0fe200078e02ffULL, 0x0000000f04177811ULL, 0x000fe200078e10ffULL,
0x000000161a167224ULL, 0x008fe200078e021bULL, 0x0000000028047984ULL, 0x0004e40000000c00ULL,
0xfffffff017177812ULL, 0x000fe200078ec0ffULL, 0x0000000b161d7224ULL, 0x000fc800078e02ffULL,
0x0000008010197824ULL, 0x040fe400078e0217ULL, 0x000000011d0c7824ULL, 0x000fe400078e020cULL,
0x0000008010187824ULL, 0x000fe400078e0219ULL, 0x0004000028107984ULL, 0x0004a60000000c00ULL,
0x0000007f18187810ULL, 0x000fc80007ffe0ffULL, 0xffffff80181b7812ULL, 0x000fc800078ec0ffULL,
0x000000141b1f7210ULL, 0x002fc80007f1e0ffULL, 0x0000001f0c1e7211ULL, 0x000fe200078260ffULL,
0x000000ffff1f7224ULL, 0x000fe200000e0615ULL, 0x0000000152ff7812ULL, 0x000fc8000780f80aULL,
0x0000001f0c1f7211ULL, 0x000fe400008f64ffULL, 0x00000014171a7210ULL, 0x000fe20007f3e0ffULL,
0x00000800001e7825ULL, 0x000fc800078e001eULL, 0x000000ffff1c7224ULL, 0x000fe400008e0615ULL,
0x000000102b227825ULL, 0x000fc800078e001eULL, 0x00000010251e7825ULL, 0x000fe200078e001eULL,
0x0000000000400947ULL, 0x008fec0003800000ULL, 0x0000001002207824ULL, 0x000fe200078e00ffULL,
0x00000001ff247819ULL, 0x000fe20000011602ULL, 0x000000800c187824ULL, 0x000fe200078e00ffULL,
0x00000019ff0c7819ULL, 0x000fe4000001160cULL, 0x0000007020277812ULL, 0x000fe400078ec0ffULL,
0x0000001418267210ULL, 0x000fe40007ebe019ULL, 0x0000000c24257812ULL, 0x000fe400078ec0ffULL,
0x0000001a27187210ULL, 0x000fc40007a3e018ULL, 0x000000150c207210ULL, 0x000fe40002fec4ffULL,
0x0000001825247210ULL, 0x000fe40007fbe0ffULL, 0x0000001cff0c7210ULL, 0x000fe40000fe440cULL,
0x0000002625267210ULL, 0x000fc60007c7e027ULL, 0x000000ffff257224ULL, 0x000fe200028e060cULL,
0x00000020ff277210ULL, 0x000fc80001fe84ffULL, 0x0000005124007986ULL, 0x0003e8000c101906ULL,
0x0000005626007986ULL, 0x0003e4000c101906ULL, 0x000000ff0200720cULL, 0x000fe20000705670ULL,
0x0000000422007986ULL, 0x0007e8000c101d06ULL, 0x000000101e007986ULL, 0x0047e2000c101d06ULL,
0x0000000000007b1dULL, 0x000fee0000000000ULL, 0x0000000000700947ULL, 0x000fea0003800000ULL,
0x00009800ff047b82ULL, 0x008ea20000000a00ULL, 0xffffffff0b077810ULL, 0x000fe20007ffe0ffULL,
0x0000000416047825ULL, 0x004fe200078e0004ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000000ff00798fULL, 0x000fe20002000000ULL,
0x00000007040479a8ULL, 0x00052200099ee1c6ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000000ff00798fULL, 0x000fe20002000000ULL,
0x00000000000579c3ULL, 0x000ee20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000070400720cULL, 0x010fc80003f05270ULL, 0x00000001ff047807ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x008fd20008000004ULL, 0x00000004ff007988ULL, 0x0007e60008000004ULL,
0x0000000000047919ULL, 0x008ee20000008800ULL, 0x00000400001f7802ULL, 0x000fe20000000f00ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000654041f7816ULL, 0x008fca000000001fULL, 0x000000001f047984ULL, 0x000ee40000000000ULL,
0x000000ff0400720cULL, 0x008fda0003f05270ULL, 0x0000002000708947ULL, 0x000fea0003800000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x0000000800940947ULL, 0x000fea0003800000ULL,
0x000000ff0b00720cULL, 0x000fda0003f05270ULL, 0x00000000006c8947ULL, 0x000fea0003800000ULL,
0x0000001002057824ULL, 0x004fe200078e00ffULL, 0x00000001ff067819ULL, 0x000fe40000011602ULL,
0x0000001a1d047211ULL, 0x000fe400078038ffULL, 0x0000007005077812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fe400078ec0ffULL, 0x0000001c1d057211ULL, 0x000fe400000f3cffULL,
0x0000000406047210ULL, 0x000fc8000791e007ULL, 0x00000005ff057210ULL, 0x000fca00007e24ffULL,
0x0000000604067981ULL, 0x000528000c1e1900ULL, 0x0000800604077981ULL, 0x000522000c1e1900ULL,
0x000000020b00780cULL, 0x000fda0003f05270ULL, 0x00000000003c8947ULL, 0x004fea0003800000ULL,
0x00010006040d7981ULL, 0x000522000c1e1900ULL, 0x000000040b00780cULL, 0x000fda0003f06070ULL,
0x0000000000308947ULL, 0x004fea0003800000ULL, 0x0001800604117981ULL, 0x000522000c1e1900ULL,
0x000000040b00780cULL, 0x000fda0003f05270ULL, 0x0000000000248947ULL, 0x004fea0003800000ULL,
0x0002000604137981ULL, 0x000522000c1e1900ULL, 0x000000060b00780cULL, 0x000fda0003f06070ULL,
0x0000000000188947ULL, 0x004fea0003800000ULL, 0x0002800604237981ULL, 0x000522000c1e1900ULL,
0x000000060b00780cULL, 0x000fda0003f05270ULL, 0x00000000000c8947ULL, 0x004fea0003800000ULL,
0x000000080b00780cULL, 0x000fe20003f06070ULL, 0x0003000604257981ULL, 0x002318000c1e1900ULL,
0x0003800604270981ULL, 0x000324000c1e1900ULL, 0x000000070b047836ULL, 0x002fca0000000000ULL,
0x00000003ff0c7819ULL, 0x000fc80000011604ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x0000000400f48947ULL, 0x000fea0003800000ULL, 0x000000171d057211ULL, 0x044fe200078038ffULL,
0x000000ffff297224ULL, 0x010fe200078e0006ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x0000003f00057c82ULL, 0x000fe20008000000ULL, 0x0000001405147210ULL, 0x000fe40007f3e0ffULL,
0x000000ff1d047211ULL, 0x000fe400000f3cffULL, 0x00000780142b7810ULL, 0x000fc80007f5e0ffULL,
0x00000004ff157210ULL, 0x000fd200017e2415ULL, 0x000000040b007c0cULL, 0x000fe2000bf23070ULL,
0x0000000105057890ULL, 0x000fcc000fffe03fULL, 0x000000050c007c0cULL, 0x000fcc000bf03070ULL,
0x0000000400b41947ULL, 0x012fee0003800000ULL, 0x0000000804087890ULL, 0x000fe2000fffe03fULL,
0x0000002906067209ULL, 0x000fca0007810000ULL, 0x000000080b007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001002047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011602ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000042b047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0615ULL, 0xfffc800604297981ULL, 0x000326000c1e1900ULL,
0x0000000104087890ULL, 0x000fcc000fffe03fULL, 0x000000080b007c0cULL, 0x000fda000bf23070ULL,
0x00000004007c1947ULL, 0x000fea0003800000ULL, 0x0000000904087890ULL, 0x000fe2000fffe03fULL,
0x0000000706067209ULL, 0x000fca0007810000ULL, 0x000000080b007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001002047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011602ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000042b047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0615ULL, 0xfffd000604077981ULL, 0x000326000c1e1900ULL,
0x0000000204087890ULL, 0x000fcc000fffe03fULL, 0x000000080b007c0cULL, 0x000fda000bf23070ULL,
0x0000000400441947ULL, 0x000fea0003800000ULL, 0x0000000a04087890ULL, 0x000fe2000fffe03fULL,
0x0000000d06067209ULL, 0x000fca0007810000ULL, 0x000000080b007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000000402047819ULL, 0x002fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe40000011602ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000042b047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0615ULL, 0xfffd8006040d7981ULL, 0x000326000c1e1900ULL,
0x0000000304087890ULL, 0x000fcc000fffe03fULL, 0x000000080b007c0cULL, 0x000fda000bf23070ULL,
0x00000004000c1947ULL, 0x000fea0003800000ULL, 0x0000000b04087890ULL, 0x000fe2000fffe03fULL,
0x0000001106067209ULL, 0x000fca0007810000ULL, 0x000000080b007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001002047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011602ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000042b047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0615ULL, 0xfffe000604117981ULL, 0x000326000c1e1900ULL,
0x0000000404087890ULL, 0x000fcc000fffe03fULL, 0x000000080b007c0cULL, 0x000fda000bf23070ULL,
0x0000000000d41947ULL, 0x000fea0003800000ULL, 0x0000000c04087890ULL, 0x000fe2000fffe03fULL,
0x0000001306067209ULL, 0x000fca0007810000ULL, 0x000000080b007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001002047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011602ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000042b047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0615ULL, 0xfffe800604137981ULL, 0x000326000c1e1900ULL,
0x0000000504087890ULL, 0x000fcc000fffe03fULL, 0x000000080b007c0cULL, 0x000fda000bf23070ULL,
0x00000000009c1947ULL, 0x000fea0003800000ULL, 0x0000000d04087890ULL, 0x000fe2000fffe03fULL,
0x0000002306067209ULL, 0x000fca0007810000ULL, 0x000000080b007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001002047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011602ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000042b047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0615ULL, 0xffff000604237981ULL, 0x000326000c1e1900ULL,
0x0000000604087890ULL, 0x000fcc000fffe03fULL, 0x000000080b007c0cULL, 0x000fda000bf23070ULL,
0x0000000000641947ULL, 0x000fea0003800000ULL, 0x0000000e04087890ULL, 0x000fe2000fffe03fULL,
0x0000002506067209ULL, 0x000fca0007810000ULL, 0x000000080b007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000000402047819ULL, 0x002fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe40000011602ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000042b047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0615ULL, 0xffff800604257981ULL, 0x000326000c1e1900ULL,
0x0000000704087890ULL, 0x000fcc000fffe03fULL, 0x000000080b007c0cULL, 0x000fda000bf23070ULL,
0x00000000002c1947ULL, 0x000fea0003800000ULL, 0x0000000f04087890ULL, 0x000fe2000fffe03fULL,
0x0000002706067209ULL, 0x000fca0007810000ULL, 0x000000080b007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001002047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011602ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000042b047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e0615ULL, 0x0000000604277981ULL, 0x000326000c1e1900ULL,
0x000004002b2b7810ULL, 0x000fe20007f3e0ffULL, 0x0000000804047890ULL, 0x000fc8000fffe03fULL,
0x000000ffff157224ULL, 0x000fe200008e0615ULL, 0xfffffff8002c8947ULL, 0x000fee000383ffffULL,
0x0000000000027919ULL, 0x000ee40000000000ULL, 0x0000001002047824ULL, 0x00afe200078e00ffULL,
0x00000001ff057819ULL, 0x004fc80000011602ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000001f05057210ULL, 0x000fca0007ffe004ULL,
0x0000000605007388ULL, 0x0103e40000000800ULL, 0x00009800ff247b82ULL, 0x002e620000000a00ULL,
0x000000070200780cULL, 0x000fe20003f04070ULL, 0x000008000a237824ULL, 0x000fe200078e00ffULL,
0x0000000152067812ULL, 0x000fe200078ec0ffULL, 0x0000001002207824ULL, 0x000fe200078e00ffULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x0000004002137836ULL, 0x000fe20000000000ULL,
0x0000080023237812ULL, 0x000fe200078ee2ffULL, 0x0000006002157836ULL, 0x000fe20000000000ULL,
0x0000007020207812ULL, 0x000fe400078ec0ffULL, 0x0000000000407805ULL, 0x000fc4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000020052058824ULL, 0x144fe200078e021fULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000020052118824ULL, 0x000fe200078e021fULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000010000078824ULL, 0x040fe200078e0205ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000010000118824ULL, 0x000fe200078e0211ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000008006278824ULL, 0x000fe200078e0207ULL,
0x0000001f52077211ULL, 0x000fe200078e68ffULL, 0x0000008006298824ULL, 0x000fe200078e0211ULL,
0x000000241b0c7210ULL, 0x002fe20007f3e0ffULL, 0x00000001521b7824ULL, 0x000fe200078e021dULL,
0x0000080021117812ULL, 0x000fe200078ec0ffULL, 0x00001000001e7824ULL, 0x000fe200078e0207ULL,
0x00000025ff0d7210ULL, 0x000fe20000ffe4ffULL, 0x0000002002077836ULL, 0x000fe20000000000ULL,
0x00000024190a7210ULL, 0x000fe20007f3e0ffULL, 0x000000011e117824ULL, 0x000fe200078e0211ULL,
0x00000024171c7210ULL, 0x000fe20007f7e0ffULL, 0x000010001b047825ULL, 0x000fe200078e000cULL,
0x00000001ff217819ULL, 0x000fc40000011602ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x00000025ff227210ULL, 0x000fe20000ffe4ffULL, 0x0000001002197824ULL, 0x040fe200078e0211ULL,
0x0000002304047210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff257224ULL, 0x000fe200018e0625ULL,
0x0000000c21217812ULL, 0x000fe200078ec0ffULL, 0x0000001002278824ULL, 0x000fe200078e0227ULL,
0x0000000a1b148211ULL, 0x040fe200078238ffULL, 0x000000ffff057224ULL, 0x000fe200010e0605ULL,
0x0000001c1b168211ULL, 0x000fc400078438ffULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x0000001f21247210ULL, 0x000fe20007ffe020ULL, 0x0000001013107825ULL, 0x100fe200078e0004ULL,
0x000000251b178211ULL, 0x000fe200010f3cffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000001015127825ULL, 0x100fe200078e0004ULL, 0x000000221b158211ULL, 0x000fe200008f3cffULL,
0x0000000024247984ULL, 0x000e620000000800ULL, 0x0000000b5200720cULL, 0x000fe20003f26070ULL,
0x0000001007067825ULL, 0x000fe200078e0004ULL, 0x00000000003a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000001002047825ULL, 0x000fc800078e0004ULL, 0x0000001002148825ULL, 0x040fe200078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000004197faeULL, 0x000fe6000b901c46ULL,
0x00000010021b8824ULL, 0x040fe200078e0229ULL, 0x0038000006197faeULL, 0x000fe2000b901c46ULL,
0x0000001002168825ULL, 0x000fe200078e0016ULL, 0x0000000000287805ULL, 0x000fe4000001ff00ULL,
0x0058000010197faeULL, 0x000fe2000b901c46ULL, 0x000000ffff467224ULL, 0x000fc600078e00ffULL,
0x0078000012197faeULL, 0x000fe8000b901c46ULL, 0x0458000014278faeULL, 0x0007e8000b901c46ULL,
0x04180000161b8faeULL, 0x0005e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000267805ULL, 0x008fe2000001ff00ULL, 0x0000000800701947ULL, 0x002fec0003800000ULL,
0x00000003ff047819ULL, 0x104fe20000011602ULL, 0x0000020052517824ULL, 0x000fe200078e021fULL,
0xfffffff8ff057812ULL, 0x000fe200078ee202ULL, 0x000000ffff267224ULL, 0x000fe200078e00ffULL,
0x0000000304047812ULL, 0x000fe200078ec0ffULL, 0x0000010000517824ULL, 0x000fe200078e0251ULL,
0x00000002ff4f7819ULL, 0x000fe20000011602ULL, 0x0000000805077836ULL, 0x000fe20000000000ULL,
0x00000052004c7202ULL, 0x000fe20000000f00ULL, 0x0000000805107824ULL, 0x040fe400078e00ffULL,
0x0000000805067824ULL, 0x000fe200078e00ffULL, 0x0000000504057210ULL, 0x000fe20007ffe0ffULL,
0x00000001044b7824ULL, 0x000fc400078e0207ULL, 0x0000000807047824ULL, 0x040fe200078e00ffULL,
0xfffffff806497812ULL, 0x000fe200078ee205ULL, 0x0000000807077824ULL, 0x000fe400078e00ffULL,
0x00000004054d7836ULL, 0x000fe20000000000ULL, 0xfffffff8044b7812ULL, 0x000fe200078ee24bULL,
0x0000000c054e7836ULL, 0x000fe40000000000ULL, 0x000000084f477836ULL, 0x000fe20000000000ULL,
0xfffffff8104d7812ULL, 0x000fe400078ee24dULL, 0xfffffff8074e7812ULL, 0x000fce00078ee24eULL,
0x000000014c107836ULL, 0x000fca0000000000ULL, 0x0000000b1000720cULL, 0x000fda0003f06070ULL,
0x0000000000980947ULL, 0x000fea0003800000ULL, 0x000000011d077824ULL, 0x000fe200078e0210ULL,
0x000000070200780cULL, 0x000fe20003f44070ULL, 0x0000080010067824ULL, 0x040fe200078e00ffULL,
0x0000000110187812ULL, 0x000fe200078ec0ffULL, 0x0000100007047825ULL, 0x000fc800078e000cULL,
0x0000002002537836ULL, 0x000fe20000000000ULL, 0x0000002304127210ULL, 0x000fe20007f1e0ffULL,
0x0000004002557836ULL, 0x000fe40000000000ULL, 0x0000006002577836ULL, 0x000fe20000000000ULL,
0x00000005ff137210ULL, 0x000fe200007fe4ffULL, 0x000002005211a824ULL, 0x000fe200078e021fULL,
0x0000080006057812ULL, 0x000fe400078ec0ffULL, 0x0000000a0714a211ULL, 0x040fe200078038ffULL,
0x000001000051a824ULL, 0x000fe200078e0211ULL, 0x0000001c0710a211ULL, 0x040fe200078238ffULL,
0x000000011e057824ULL, 0x000fe200078e0205ULL, 0x000000220715a211ULL, 0x040fe200000f3cffULL,
0x00000080181ba824ULL, 0x000fe200078e0251ULL, 0x000000250711a211ULL, 0x000fe200008f3cffULL,
0x0000001002197824ULL, 0x000fc400078e0205ULL, 0x0000001002167825ULL, 0x040fe200078e0012ULL,
0x0000001b021ba211ULL, 0x000fc600078e20ffULL, 0x0000001053047825ULL, 0x000fe200078e0012ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000016197faeULL, 0x0003e6000b901c46ULL,
0x000000801853a824ULL, 0x000fe200078e0251ULL, 0x0038000004197faeULL, 0x0003e2000b901c46ULL,
0x0000001055067825ULL, 0x000fc800078e0012ULL, 0x0000001057127825ULL, 0x000fe200078e0012ULL,
0x0058000006197faeULL, 0x0003e6000b901c46ULL, 0x000000100214a825ULL, 0x040fe200078e0014ULL,
0x0078000012197faeULL, 0x0003e6000b901c46ULL, 0x000000100210a825ULL, 0x040fe200078e0010ULL,
0x04580000141bafaeULL, 0x0003e6000b901c46ULL, 0x000000100253a824ULL, 0x000fca00078e0253ULL,
0x041800001053afaeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000804c047824ULL, 0x002fca00078e00ffULL, 0x0000008004047812ULL, 0x000fc800078ec0ffULL,
0x0000005120047210ULL, 0x000fca0007ffe004ULL, 0x0000000121507824ULL, 0x000fe400078e0204ULL,
0x000008004c047824ULL, 0x000fe400078e00ffULL, 0x000000024c4c7836ULL, 0x000fc60000000000ULL,
0x0000080004057812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800050157984ULL, 0x000e620000000800ULL, 0x000001801e187810ULL, 0x000fe40007ffe005ULL,
0x0000000b4c00720cULL, 0x000fe20003f06070ULL, 0x0045800050537984ULL, 0x000fe40000000800ULL,
0x0000001049047824ULL, 0x100fe400078e0218ULL, 0x000000104d107824ULL, 0x100fe400078e0218ULL,
0x000000104b147824ULL, 0x000fe200078e0218ULL, 0x000000184e187211ULL, 0x000fe200078e20ffULL,
0x000000000404783bULL, 0x000ea80000000200ULL, 0x000000001010783bULL, 0x000ee20000000200ULL,
0x0000001524197221ULL, 0x002fc60000010100ULL, 0x000000001414783bULL, 0x000e620000000200ULL,
0x3fb8aa3b19567820ULL, 0x000fc60000410000ULL, 0x000000001818783bULL, 0x000fe60000000200ULL,
0x0000005600567308ULL, 0x000f220000000800ULL, 0x20000005ff557230ULL, 0x004fe40000004100ULL,
0x30000005ff507230ULL, 0x000fe40000004100ULL, 0x20000013ff5b7230ULL, 0x008fe40000004100ULL,
0x30000013ff587230ULL, 0x000fc40000004100ULL, 0x20000007ff577230ULL, 0x000fe40000004100ULL,
0x30000007ff547230ULL, 0x000fe40000004100ULL, 0x20000011ff597230ULL, 0x000fe40000004100ULL,
0x0000005356627220ULL, 0x010fe20000410000ULL, 0x30000011ff567230ULL, 0x000fe40000004100ULL,
0x20000004ff537230ULL, 0x000fe40000004100ULL, 0x0000004662467221ULL, 0x000fe20000010000ULL,
0x00001f4f62637589ULL, 0x000ea200000e0000ULL, 0x20000006ff057230ULL, 0x000fc40000004100ULL,
0x20000010ff077230ULL, 0x000fe20000004100ULL, 0x00001f4762647589ULL, 0x000ee200000e0000ULL,
0x20000012ff117230ULL, 0x000fe40000004100ULL, 0x30000004ff047230ULL, 0x000fe40000004100ULL,
0x30000006ff067230ULL, 0x000fe40000004100ULL, 0x30000010ff107230ULL, 0x000fe40000004100ULL,
0x20000016ff5c7230ULL, 0x002fc40000004100ULL, 0x30000016ff5d7230ULL, 0x000fe40000004100ULL,
0x20000014ff5a7230ULL, 0x000fe40000004100ULL, 0x30000014ff137230ULL, 0x000fe40000004100ULL,
0x20000017ff167230ULL, 0x000fe40000004100ULL, 0x30000017ff5e7230ULL, 0x000fe40000004100ULL,
0x00000063533e7223ULL, 0x004fe2000001003eULL, 0x20000019ff5f7230ULL, 0x000fc40000004100ULL,
0x00000063043d7223ULL, 0x080fe2000001003dULL, 0x30000019ff607230ULL, 0x000fe40000004100ULL,
0x00000063553c7223ULL, 0x080fe2000001003cULL, 0x20000015ff147230ULL, 0x000fe40000004100ULL,
0x00000063503b7223ULL, 0x080fe2000001003bULL, 0x20000018ff177230ULL, 0x000fe40000004100ULL,
0x00000063053a7223ULL, 0x000fe2000001003aULL, 0x2000001aff197230ULL, 0x000fc40000004100ULL,
0x0000006306397223ULL, 0x080fe20000010039ULL, 0x2000001bff617230ULL, 0x000fe40000004100ULL,
0x0000006357387223ULL, 0x080fe20000010038ULL, 0x30000012ff127230ULL, 0x000fe40000004100ULL,
0x0000006354377223ULL, 0x080fe20000010037ULL, 0x30000015ff157230ULL, 0x000fe40000004100ULL,
0x0000006307367223ULL, 0x000fe20000010036ULL, 0x30000018ff187230ULL, 0x000fc40000004100ULL,
0x0000006310457223ULL, 0x080fe20000010045ULL, 0x3000001aff1a7230ULL, 0x000fe40000004100ULL,
0x0000006359447223ULL, 0x080fe20000010044ULL, 0x3000001bff1b7230ULL, 0x000fe40000004100ULL,
0x0000006356437223ULL, 0x080fe20000010043ULL, 0x0000006311427223ULL, 0x080fe20000010042ULL,
0x0000006312417223ULL, 0x080fe20000010041ULL, 0x000000635b407223ULL, 0x080fe20000010040ULL,
0x00000063583f7223ULL, 0x000fe2000001003fULL, 0x000000645a277223ULL, 0x088fe20000010027ULL,
0x0000006413347223ULL, 0x080fe20000010034ULL, 0x0000006414337223ULL, 0x080fe20000010033ULL,
0x0000006415327223ULL, 0x080fe20000010032ULL, 0x000000645c317223ULL, 0x080fe20000010031ULL,
0x000000645d307223ULL, 0x080fe20000010030ULL, 0x00000064162f7223ULL, 0x080fe2000001002fULL,
0x000000645e357223ULL, 0x080fe20000010035ULL, 0x00000064172e7223ULL, 0x080fe2000001002eULL,
0x00000064182d7223ULL, 0x080fe2000001002dULL, 0x000000645f2c7223ULL, 0x080fe2000001002cULL,
0x00000064602b7223ULL, 0x080fe2000001002bULL, 0x00000064192a7223ULL, 0x080fe2000001002aULL,
0x000000641a297223ULL, 0x080fe20000010029ULL, 0x0000006461287223ULL, 0x080fe20000010028ULL,
0x000000641b267223ULL, 0x000fe20000010026ULL, 0xfffffff400e88947ULL, 0x000fec000383ffffULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x0000001002047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe20000011602ULL,
0x000049801f027836ULL, 0x000fc60000000000ULL, 0x0000007004077812ULL, 0x000fe400078ec0ffULL,
0x0000000c050a7812ULL, 0x000fca00078ec0ffULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x00000080521f7824ULL, 0x000fe400078e021fULL,
0x0000001004057824ULL, 0x002fe200078e00ffULL, 0x00000001ff067819ULL, 0x000fc80000011604ULL,
0x0000007005047812ULL, 0x000fe400078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ec0ffULL,
0x0000001f061f7210ULL, 0x000fca0007ffe004ULL, 0x004980461f007388ULL, 0x0003e40000000800ULL,
0x000000020a027210ULL, 0x000fe20007ffe007ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000002047984ULL, 0x000ea80000000800ULL, 0x0000800002057984ULL, 0x000ee20000000800ULL,
0x00000004ff047221ULL, 0x004fc80000010000ULL, 0x0000000504047221ULL, 0x008fc80000010000ULL,
0x0180000004057836ULL, 0x000fca0000000000ULL, 0x7f80000005057812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0500780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000a310000d7802ULL, 0x000fce0000000f00ULL,
0x0000008800a87944ULL, 0x002fea0003c00000ULL, 0x000000ffff057224ULL, 0x008fe200078e0002ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000400057308ULL, 0x000ea40000001000ULL,
0xbf80000004027423ULL, 0x004fc80000000005ULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000205057223ULL, 0x000fce0000000005ULL, 0x0000000000027919ULL, 0x000ea40000000000ULL,
0x00000002ff047819ULL, 0x104fe20000011602ULL, 0x0000000103037824ULL, 0x100fe200078e0202ULL,
0x00000008020c7811ULL, 0x000fe400078ff0ffULL, 0x00000003ff0d7819ULL, 0x000fe20000011602ULL,
0x0000001003037824ULL, 0x000fe200078e020eULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0405047589ULL, 0x000ea800000e0000ULL, 0x00001f0c050b7589ULL, 0x00072200000e0000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0xfffffff8ff057812ULL, 0x008fc800078ee202ULL,
0x0000000805197810ULL, 0x000fe20007ffe0ffULL, 0x00000008051e7824ULL, 0x040fe400078e00ffULL,
0x00000008051d7824ULL, 0x000fe400078e00ffULL, 0x00000008191b7824ULL, 0x000fe400078e00ffULL,
0x0000003e043e7220ULL, 0x044fe20000410000ULL, 0x0000003d043d7220ULL, 0x040fe20000410000ULL,
0x0000003c043c7220ULL, 0x040fe20000410000ULL, 0x0000003b043b7220ULL, 0x040fe20000410000ULL,
0x0000003a04067220ULL, 0x040fe20000410000ULL, 0x0000003904397220ULL, 0x040fe20000410000ULL,
0x0000003804077220ULL, 0x040fe20000410000ULL, 0x00000037040a7220ULL, 0x040fe20000410000ULL,
0x0000003604107220ULL, 0x040fe20000410000ULL, 0x0000004504457220ULL, 0x040fe20000410000ULL,
0x0000004404117220ULL, 0x040fe20000410000ULL, 0x00000043040c7220ULL, 0x040fe20000410000ULL,
0x0000004204127220ULL, 0x040fe20000410000ULL, 0x0000004104417220ULL, 0x040fe20000410000ULL,
0x0000004004137220ULL, 0x040fe20000410000ULL, 0x0000003f04147220ULL, 0x000fe20000410000ULL,
0x000000030d047812ULL, 0x000fe200078ec0ffULL, 0x00000008191f7824ULL, 0x002fc400078e00ffULL,
0x000000310b167220ULL, 0x050fe20000410000ULL, 0x000000300b177220ULL, 0x040fe20000410000ULL,
0x000000270b277220ULL, 0x040fe20000410000ULL, 0x0000000104057824ULL, 0x040fe400078e0205ULL,
0x000000340b347220ULL, 0x040fe20000410000ULL, 0x00000001041a7824ULL, 0x000fe400078e0219ULL,
0x000000330b157220ULL, 0x040fe20000410000ULL, 0x0000000405047836ULL, 0x000fe20000000000ULL,
0x0000000c051c7810ULL, 0x000fe20007ffe0ffULL, 0x000000320b327220ULL, 0x040fe20000410000ULL,
0xfffffff81e057812ULL, 0x000fe200078ee205ULL, 0x0000002f0b2f7220ULL, 0x040fe20000410000ULL,
0xfffffff81d197812ULL, 0x000fe200078ee204ULL, 0x000000350b187220ULL, 0x040fe20000410000ULL,
0x0000002e0b2e7220ULL, 0x040fe20000410000ULL, 0x0000002d0b2d7220ULL, 0x040fe20000410000ULL,
0x0000002c0b2c7220ULL, 0x040fe20000410000ULL, 0x0000002b0b2b7220ULL, 0x040fe20000410000ULL,
0x0000002a0b2a7220ULL, 0x040fe20000410000ULL, 0x000000290b297220ULL, 0x040fe20000410000ULL,
0x000000280b287220ULL, 0x040fe20000410000ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee21aULL,
0x000000260b0b7220ULL, 0x000fe20000410000ULL, 0xfffffff81f1d7812ULL, 0x000fe200078ee21cULL,
0x0000001005307824ULL, 0x100fe200078e0208ULL, 0x0000003e3d04723eULL, 0x000fe200000000ffULL,
0x0000001019317824ULL, 0x100fe200078e0208ULL, 0x0000003c3b05723eULL, 0x000fe200000000ffULL,
0x000000101b337824ULL, 0x100fe200078e0208ULL, 0x000000063906723eULL, 0x000fe200000000ffULL,
0x000000101d087824ULL, 0x000fe200078e0208ULL, 0x000000070a07723eULL, 0x000fc400000000ffULL,
0x000000104510723eULL, 0x000fe400000000ffULL, 0x000000110c11723eULL, 0x000fe200000000ffULL,
0x0000000430007844ULL, 0x000fe20000000200ULL, 0x000000124112723eULL, 0x000fe400000000ffULL,
0x000000131413723eULL, 0x000fe400000000ffULL, 0x000000161716723eULL, 0x000fe400000000ffULL,
0x000000273414723eULL, 0x000fe200000000ffULL, 0x0000001031007844ULL, 0x000fe20000000200ULL,
0x000000153215723eULL, 0x000fc400000000ffULL, 0x0000002f1817723eULL, 0x000fe400000000ffULL,
0x0000002e2d18723eULL, 0x000fe400000000ffULL, 0x0000002c2b19723eULL, 0x000fe200000000ffULL,
0x0000001433007844ULL, 0x000fe20000000200ULL, 0x0000002a291a723eULL, 0x000fe400000000ffULL,
0x000000280b1b723eULL, 0x000fca00000000ffULL, 0x0000001808007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000031c7984ULL, 0x000e680000000c00ULL,
0x0004000003247984ULL, 0x000ea80000000c00ULL, 0x0008000003207984ULL, 0x000ee80000000c00ULL,
0x000c000003287984ULL, 0x000f220000000c00ULL, 0x200000ff1f1f7230ULL, 0x002fc40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fe40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x004fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fc40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x000000231f1f7230ULL, 0x008fe40000000000ULL,
0x000000221e1e7230ULL, 0x000fe40000000000ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fe40000000000ULL, 0x0000002b27277230ULL, 0x010fc40000000000ULL,
0x0000002a26267230ULL, 0x000fe20000000000ULL, 0x0000001c03007388ULL, 0x0003e20000000c00ULL,
0x0000002925257230ULL, 0x000fe40000000000ULL, 0x0000002824247230ULL, 0x000fca0000000000ULL,
0x0004002403007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff5200720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ee20000002700ULL, 0x0000000f0d00720cULL, 0x000fe20003f06070ULL,
0x0000840000057ab9ULL, 0x000fe40000000800ULL, 0x00000005040472a4ULL, 0x008fd4000f8e023fULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00008600ff0a7b82ULL, 0x000ee20000000800ULL,
0x000000010d037824ULL, 0x002fe200078e0202ULL, 0x0000880000087ab9ULL, 0x000fe20000000a00ULL,
0xffffffffff057424ULL, 0x004fe400078e00ffULL, 0x00000010480d7824ULL, 0x000fe200078e020dULL,
0x0000000703037812ULL, 0x000fe200078ec0ffULL, 0x0000000409067c24ULL, 0x000fe4000f8e02ffULL,
0x00000020020c7836ULL, 0x000fe20000000000ULL, 0x0ffffff803037812ULL, 0x000fc800078ef802ULL,
0x0000000e03037211ULL, 0x000fe400078e20ffULL, 0x00000003ff077819ULL, 0x000fc6000001160cULL,
0x0000000003107984ULL, 0x0002a20000000c00ULL, 0x0000000a05147219ULL, 0x088fe400000006ffULL,
0x0000000a4a4a7219ULL, 0x000fe400000006ffULL, 0x000000140d057212ULL, 0x000fe400078e30ffULL,
0x0000000aff047219ULL, 0x000fe4000001160dULL, 0x0000000702037812ULL, 0x002fe200078ec0ffULL,
0x000000014a057824ULL, 0x000fc800078e0205ULL, 0x0000000904057224ULL, 0x000fe400078e0205ULL,
0x0000000800037824ULL, 0x000fc600078e0203ULL, 0x0000000506057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x0000000f0700720cULL, 0x000fe20003f06070ULL,
0x0000001003047825ULL, 0x000fca00078e0004ULL, 0x0000001004007986ULL, 0x0043ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c037824ULL, 0x100fe400078e0207ULL,
0x0000001048077824ULL, 0x000fe400078e0207ULL, 0x00000040020b7836ULL, 0x000fe20000000000ULL,
0x0000000703037812ULL, 0x000fe400078ec0ffULL, 0x0000001407057212ULL, 0x002fe400078e30ffULL,
0x0ffffff803037812ULL, 0x000fe400078ef80cULL, 0x0000000aff047219ULL, 0x000fe20000011607ULL,
0x000000014a057824ULL, 0x000fe200078e0205ULL, 0x0000000e03037211ULL, 0x000fc400078e20ffULL,
0x000000070c077812ULL, 0x000fe200078ec0ffULL, 0x0000000904057224ULL, 0x000fe400078e0205ULL,
0x0000000003107984ULL, 0x0002a40000000c00ULL, 0x0000000800077824ULL, 0x000fe200078e0207ULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x040fe4000f8040ffULL, 0x00000003ff037819ULL, 0x002fe4000001160bULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x0000000f0300720cULL, 0x000fe20003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000001004007986ULL, 0x0043ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010b047824ULL, 0x002fe200078e0203ULL,
0x0000000348037211ULL, 0x000fe200078e20ffULL, 0x0000006002157836ULL, 0x000fc60000000000ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x0000001403077212ULL, 0x000fe400078e30ffULL,
0x0ffffff804057812ULL, 0x000fe400078ef80bULL, 0x0000000aff047219ULL, 0x000fe20000011603ULL,
0x000000014a077824ULL, 0x000fe400078e0207ULL, 0x0000001005057824ULL, 0x000fe400078e020eULL,
0x0000000904077224ULL, 0x000fe200078e0207ULL, 0x00000003ff047819ULL, 0x000fc40000011615ULL,
0x0000000005107984ULL, 0x0002a40000000c00ULL, 0x0000000706037210ULL, 0x000fe40007f1e0ffULL,
0x000000070b077812ULL, 0x000fc600078ec0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000803027c11ULL, 0x000fe2000f8040ffULL, 0x0000000800077824ULL, 0x000fe400078e0207ULL,
0x0000000115057824ULL, 0x002fe200078e0204ULL, 0x0000000903037c11ULL, 0x000fe400080f4408ULL,
0x0000000f0400720cULL, 0x000fe40003f06070ULL, 0x0000000705057812ULL, 0x000fe200078ec0ffULL,
0x0000001007027825ULL, 0x000fc600078e0002ULL, 0xfffffff805057812ULL, 0x000fe400078ef815ULL,
0x0000001002007986ULL, 0x0043ea000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000010050e7824ULL, 0x000fe200078e020eULL, 0x0000000715057812ULL, 0x000fe200078ec0ffULL,
0x0000001048047824ULL, 0x000fc800078e0204ULL, 0x000000000e0c7984ULL, 0x000ea20000000c00ULL,
0x0000001404027212ULL, 0x002fe200078e30ffULL, 0x0000000800057824ULL, 0x000fe200078e0205ULL,
0x0000000aff047219ULL, 0x000fe40000011604ULL, 0x000000024a027210ULL, 0x000fca0007ffe0ffULL,
0x0000000904097224ULL, 0x000fca00078e0202ULL, 0x0000000906097210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x0000000809027c11ULL, 0x000fc8000f8040ffULL,
0x0000000909037c11ULL, 0x000fc600080f4404ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000c02007986ULL, 0x004fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000014c047836ULL, 0x000fe20000000000ULL, 0x0000920000047ab9ULL, 0x000fe20000000800ULL,
0x0000000213027824ULL, 0x000fe400078e00ffULL, 0x000000400a037824ULL, 0x000fe200078e00ffULL,
0x000000050400720cULL, 0x000fe20003f06070ULL, 0x00000001ff0c7424ULL, 0x000fe400078e00ffULL,
0x000001004c137824ULL, 0x000fe400078e0203ULL, 0x00000011024a7224ULL, 0x000fc400078e024aULL,
0x01b6000c070c79a7ULL, 0x0002a4000850003fULL, 0x000000044a097c24ULL, 0x000fc8000f8e0213ULL,
0x0000000c00248947ULL, 0x000fea0003800000ULL, 0x00000003ff0f7819ULL, 0x100fe20000011608ULL,
0x00008e0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000001306047248ULL, 0x000fe40007fe0000ULL,
0x000000040f117810ULL, 0x000fe20007ffe0ffULL, 0x000000080f157836ULL, 0x000fe20000000000ULL,
0x000000240f2b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000104047824ULL, 0x000fe200078e0a13ULL,
0x0000001109127210ULL, 0x000fe20007ffe0ffULL, 0x0000000111027824ULL, 0x140fe400078e0208ULL,
0x0000000811277824ULL, 0x040fe200078e00ffULL, 0x000000041100720cULL, 0x000fe20003fa6070ULL,
0x0000000115137824ULL, 0x000fc400078e0208ULL, 0x000000100f197836ULL, 0x000fe20000000000ULL,
0xfffffff827277812ULL, 0x000fe200078ee202ULL, 0x0000000815027824ULL, 0x000fe400078e00ffULL,
0x0000000109107824ULL, 0x000fe400078e020fULL, 0x0000000119147824ULL, 0x000fe200078e0208ULL,
0xfffffff802317812ULL, 0x000fe200078ee213ULL, 0x0000010012127825ULL, 0x000fc800078e00ffULL,
0x0000000819357824ULL, 0x000fe200078e00ffULL, 0x0000007012127812ULL, 0x000fe200078ef80eULL,
0x0000010010107825ULL, 0x000fc600078e00ffULL, 0x0000000412127c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000c0f177836ULL, 0x000fe20000000000ULL, 0xfffffff835357812ULL, 0x000fe200078ee214ULL,
0x000000180f2f7836ULL, 0x000fe20000000000ULL, 0x0000007010107812ULL, 0x000fe200078ef80eULL,
0x0000000109167824ULL, 0x000fe200078e0217ULL, 0x0000001509147210ULL, 0x000fe20007ffe0ffULL,
0x0000000117027824ULL, 0x040fe200078e0208ULL, 0x0000000513137c10ULL, 0x000fe20008ffe4ffULL,
0x0000000817337824ULL, 0x000fe200078e00ffULL, 0x0000000410107c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000109187824ULL, 0x000fe200078e0219ULL, 0x000000041500720cULL, 0x080fe20003f26070ULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x000000041700720cULL, 0x000fc40003f46070ULL,
0x0000000511117c10ULL, 0x000fe200087fe4ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x000000041900720cULL, 0x000fe40003f06070ULL, 0x00000070141a7812ULL, 0x000fe200078ef80eULL,
0x0000000109207824ULL, 0x000fe200078e022fULL, 0x00000070161c7812ULL, 0x000fe200078ef80eULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x000000041a1a7c10ULL, 0x000fe4000ff7e0ffULL,
0x000000041c1c7c10ULL, 0x000fe2000ff9e0ffULL, 0x000000140f237836ULL, 0x000fe20000000000ULL,
0x0000007018147812ULL, 0x000fe200078ef80eULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x00000005151b7c10ULL, 0x000fc40009ffe4ffULL, 0x0000000414147c10ULL, 0x000fe2000ff7e0ffULL,
0x00000001091e7824ULL, 0x000fe200078e0223ULL, 0x0000007020187812ULL, 0x000fe200078ef80eULL,
0x000000010f207824ULL, 0x100fe200078e0208ULL, 0x00000005171d7c10ULL, 0x000fe2000a7fe4ffULL,
0x000001001e1e7825ULL, 0x000fe200078e00ffULL, 0x0000000418187c10ULL, 0x000fe4000ff9e0ffULL,
0x0000000519157c10ULL, 0x000fe20009ffe4ffULL, 0x0000001c0f3b7836ULL, 0x000fe20000000000ULL,
0x000000701e167812ULL, 0x000fe200078ef80eULL, 0x000000200f297836ULL, 0x000fe20000000000ULL,
0x0000000521197c10ULL, 0x000fe2000a7fe4ffULL, 0x0000000123227824ULL, 0x140fe200078e0208ULL,
0xfffffff833337812ULL, 0x000fe200078ee202ULL, 0x000040000a027824ULL, 0x000fe200078e0207ULL,
0x0000000720217812ULL, 0x000fe200078ec0ffULL, 0x0000000823377824ULL, 0x000fe200078e00ffULL,
0x000000040f00720cULL, 0x000fe20003f86070ULL, 0x0000100002027836ULL, 0x000fe20000000000ULL,
0x0000000416167c10ULL, 0x000fe2000ff7e0ffULL, 0x0000000109207824ULL, 0x000fe200078e0229ULL,
0x0000003b091e7210ULL, 0x000fe20007ffe0ffULL, 0x000000280f2d7836ULL, 0x000fe20000000000ULL,
0x0ffffff821217812ULL, 0x000fe200078ef808ULL, 0x000000012f267824ULL, 0x000fe200078e0208ULL,
0x000000051f177c10ULL, 0x000fe20009ffe4ffULL, 0x000001001e1e7825ULL, 0x000fe200078e00ffULL,
0xfffffff837377812ULL, 0x000fc400078ee222ULL, 0x000000042300720cULL, 0x000fe20003f66070ULL,
0x0000001021257824ULL, 0x000fe200078e0202ULL, 0x000000701e1e7812ULL, 0x000fe200078ef80eULL,
0x0000010020207825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010257faeULL, 0x0007e2000e101c46ULL, 0x0000000109227824ULL, 0x000fe200078e022bULL,
0x000000041e1e7c10ULL, 0x000fe2000ffde0ffULL, 0x000000082f397824ULL, 0x040fe200078e00ffULL,
0x0000007020207812ULL, 0x000fe200078ef80eULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0x000000042f00720cULL, 0x080fe40003f86070ULL, 0x000000051f1f7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000109247824ULL, 0x000fe200078e022dULL, 0x0000000420207c10ULL, 0x000fe2000ffde0ffULL,
0x0000002c0f2f7836ULL, 0x000fe20000000000ULL, 0x0000007022227812ULL, 0x000fe200078ef80eULL,
0x0000001027257824ULL, 0x108fe200078e0202ULL, 0x0000000521217c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001031277824ULL, 0x000fe200078e0202ULL, 0xfffffff839397812ULL, 0x000fe200078ee226ULL,
0x0000010024107825ULL, 0x000fe200078e00ffULL, 0x0000000012257faeULL, 0x0007e2000e901c46ULL,
0x000000043b00720cULL, 0x000fc40003fa6070ULL, 0x000000300f317836ULL, 0x000fe20000000000ULL,
0x000000001a277faeULL, 0x0009e2000c901c46ULL, 0x000000013b247824ULL, 0x140fe200078e0208ULL,
0x000000033b3b7819ULL, 0x000fe200000006ffULL, 0x000000012b267824ULL, 0x000fe200078e0208ULL,
0x0000000422227c10ULL, 0x000fe4000ffde0ffULL, 0x0000007010107812ULL, 0x000fe200078ef80eULL,
0x0000001033257824ULL, 0x108fe200078e0202ULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee224ULL,
0x0000000109127824ULL, 0x000fe200078e022fULL, 0x000000042900720cULL, 0x000fe20003f26070ULL,
0x00000010351b7824ULL, 0x010fe200078e0202ULL, 0x000000001c257faeULL, 0x0007e2000d101c46ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000000523237c10ULL, 0x000fc4000b7fe4ffULL,
0x00000000141b7faeULL, 0x0009e2000c101c46ULL, 0x0000000129247824ULL, 0x040fe200078e0208ULL,
0x0000000410107c10ULL, 0x000fe2000ffde0ffULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0x000000042b00720cULL, 0x080fe20003f46070ULL, 0x000000340f337836ULL, 0x000fe20000000000ULL,
0x0000007012127812ULL, 0x000fe200078ef80eULL, 0x000000103b277824ULL, 0x100fe200078e0202ULL,
0x000000032b2b7819ULL, 0x000fe200000006ffULL, 0x00000010371d7824ULL, 0x108fe200078e0202ULL,
0x0000000511117c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001039257824ULL, 0x100fe200078e0202ULL,
0x0000003109147210ULL, 0x010fe20007ffe0ffULL, 0x000000380f357836ULL, 0x000fe20000000000ULL,
0xfffffff829297812ULL, 0x000fe200078ee224ULL, 0x00000000161d7faeULL, 0x0007e2000d901c46ULL,
0x0000000412127c10ULL, 0x000fe2000ffde0ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee226ULL, 0x0000000018257faeULL, 0x0009e2000e101c46ULL,
0x0000000513137c10ULL, 0x000fe2000b7fe4ffULL, 0x0000001029297824ULL, 0x100fe200078e0202ULL,
0x000000042f00720cULL, 0x080fe20003f86070ULL, 0x000000102b2b7824ULL, 0x000fe200078e0202ULL,
0x000000001e277faeULL, 0x000fe2000e901c46ULL, 0x0000003c0f377836ULL, 0x000fe20000000000ULL,
0x000000042d00720cULL, 0x080fe20003fa6070ULL, 0x0000000109167824ULL, 0x008fe200078e0233ULL,
0x0000000020297faeULL, 0x0007e2000c901c46ULL, 0x00000008311d7824ULL, 0x040fe200078e00ffULL,
0x000000043100720cULL, 0x080fe20003f66070ULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x0000007014187812ULL, 0x010fe200078ef80eULL, 0x00000000222b7faeULL, 0x0009e2000d101c46ULL,
0x000000043300720cULL, 0x080fe20003f46070ULL, 0x0000000131147824ULL, 0x100fe200078e0208ULL,
0x0000000418187c10ULL, 0x000fe2000ffde0ffULL, 0x000000012d0f7824ULL, 0x100fe200078e0208ULL,
0x000000043500720cULL, 0x080fe20003f26070ULL, 0x000000082d1a7824ULL, 0x000fe200078e00ffULL,
0x0000000515197c10ULL, 0x000fe2000b7fe4ffULL, 0x0000000109157824ULL, 0x000fe200078e0235ULL,
0x000000043700720cULL, 0x000fe20003f06070ULL, 0x000000012f047824ULL, 0x040fe200078e0208ULL,
0x000000032f1b7819ULL, 0x000fe200000006ffULL, 0x0000000109097824ULL, 0x000fe200078e0237ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee214ULL, 0x0000010015147825ULL, 0x000fe200078e00ffULL,
0x0000007016167812ULL, 0x000fc400078ef80eULL, 0xfffffff81a0f7812ULL, 0x000fe200078ee20fULL,
0x00000001351a7824ULL, 0x100fe200078e0208ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee204ULL,
0x0000000133047824ULL, 0x100fe200078e0208ULL, 0x0000000416167c10ULL, 0x000fe2000ffde0ffULL,
0x00000001371c7824ULL, 0x000fe200078e0208ULL, 0x0000007014147812ULL, 0x000fe200078ef80eULL,
0x0000010009087825ULL, 0x000fe200078e00ffULL, 0x0000000517177c10ULL, 0x000fe4000b7fe4ffULL,
0x0000000335217819ULL, 0x008fe200000006ffULL, 0x00000008331f7824ULL, 0x002fe200078e00ffULL,
0x0000000414147c10ULL, 0x000fe2000ffde0ffULL, 0x0000000837237824ULL, 0x010fe200078e00ffULL,
0x0000007008087812ULL, 0x000fe200078ef80eULL, 0x000000100f0f7824ULL, 0x100fe200078e0202ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee204ULL, 0x000000101b1b7824ULL, 0x100fe200078e0202ULL,
0xfffffff821217812ULL, 0x000fe200078ee21aULL, 0x000000101d1d7824ULL, 0x100fe200078e0202ULL,
0x0000000515157c10ULL, 0x000fe2000b7fe4ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0202ULL,
0xfffffff823237812ULL, 0x000fe200078ee21cULL, 0x0000001021217824ULL, 0x000fe200078e0202ULL,
0x0000000408087c10ULL, 0x000fe2000ffde0ffULL, 0x00000000100f7faeULL, 0x0003e2000e901c46ULL,
0x0000000223237211ULL, 0x000fc400078e20ffULL, 0x0000000509097c10ULL, 0x000fe2000b7fe4ffULL,
0x00000000121b7faeULL, 0x0003e8000e101c46ULL, 0x00000000181d7faeULL, 0x0003e8000d901c46ULL,
0x00000000161f7faeULL, 0x0003e8000d101c46ULL, 0x0000000014217faeULL, 0x0003e8000c901c46ULL,
0x0000000008237faeULL, 0x0003e2000c101c46ULL, 0x0000000800d47947ULL, 0x000fea0003800000ULL,
0x0000000408167811ULL, 0x040fe200078fe8ffULL, 0x00008e0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000c081a7811ULL, 0x040fe400078fe8ffULL, 0x00000010081c7811ULL, 0x000fe200078fe8ffULL,
0x0000000116027824ULL, 0x100fe200078e0208ULL, 0x0000000808187811ULL, 0x000fe200078fe8ffULL,
0x0000000816297824ULL, 0x000fe200078e00ffULL, 0x0000001408207811ULL, 0x000fe200078fe8ffULL,
0x000000011a047824ULL, 0x100fe200078e0208ULL, 0x0000001808287811ULL, 0x000fe200078fe8ffULL,
0x000000081a257824ULL, 0x000fe200078e00ffULL, 0x000000031c127819ULL, 0x040fe200000006ffULL,
0x000000011c0f7824ULL, 0x100fe200078e0208ULL, 0xfffffff829297812ULL, 0x000fe200078ee202ULL,
0x0000000118027824ULL, 0x140fe200078e0208ULL, 0xfffffff825257812ULL, 0x000fe200078ee204ULL,
0x0000000818277824ULL, 0x000fe200078e00ffULL, 0xfffffff812237812ULL, 0x000fe200078ee20fULL,
0x0000000120107824ULL, 0x100fe200078e0208ULL, 0x0000002008047811ULL, 0x000fe200078fe8ffULL,
0x00000008202d7824ULL, 0x000fe200078e00ffULL, 0x00000024080f7811ULL, 0x000fe200078fe8ffULL,
0x0000000128117824ULL, 0x100fe200078e0208ULL, 0x0000001c082a7811ULL, 0x000fe200078fe8ffULL,
0x0000000828147824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee202ULL,
0x0000000104027824ULL, 0x140fe200078e0208ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee210ULL,
0x000000010f107824ULL, 0x140fe200078e0208ULL, 0xfffffff8142f7812ULL, 0x000fe200078ee211ULL,
0x000000080f177824ULL, 0x000fe200078e00ffULL, 0x0000000304157819ULL, 0x000fe200000006ffULL,
0x000000012a127824ULL, 0x000fe200078e0208ULL, 0x0000002808117811ULL, 0x000fe200078fe8ffULL,
0x000000082a317824ULL, 0x000fe200078e00ffULL, 0x0000002c08137811ULL, 0x040fe200078fe8ffULL,
0x00000001092c7824ULL, 0x000fe200078e0204ULL, 0x0000003008267811ULL, 0x040fe200078fe8ffULL,
0x0000000811197824ULL, 0x040fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee202ULL,
0x0000000111027824ULL, 0x100fe200078e0208ULL, 0x0000003408247811ULL, 0x000fe200078fe8ffULL,
0x00000008131b7824ULL, 0x040fe200078e00ffULL, 0xfffffff817177812ULL, 0x000fe200078ee210ULL,
0x0000000113107824ULL, 0x100fe200078e0208ULL, 0xfffffff831317812ULL, 0x000fe200078ee212ULL,
0x0000000126127824ULL, 0x140fe200078e0208ULL, 0x00000003261d7819ULL, 0x000fe200000006ffULL,
0x0000000124147824ULL, 0x140fe200078e0208ULL, 0xfffffff819227812ULL, 0x000fe200078ee202ULL,
0x00000008241f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b197812ULL, 0x000fe200078ee210ULL,
0x0000000109307824ULL, 0x040fe200078e0211ULL, 0x0000000808107211ULL, 0x000fe200078fe8ffULL,
0x00000001092e7824ULL, 0x040fe200078e020fULL, 0xfffffff81d1b7812ULL, 0x000fe200078ee212ULL,
0x0000000118127824ULL, 0x100fe200078e0209ULL, 0xfffffff81f1d7812ULL, 0x000fe200078ee214ULL,
0x0000000120187824ULL, 0x100fe200078e0209ULL, 0x00000038081e7811ULL, 0x000fe200078fe8ffULL,
0x000000011a147824ULL, 0x000fe200078e0209ULL, 0x0000003c081f7811ULL, 0x040fe200078fe8ffULL,
0x0000000109327824ULL, 0x000fe200078e0213ULL, 0x0000000908027211ULL, 0x000fe200078fe8ffULL,
0x000000011e047824ULL, 0x000fe200078e0208ULL, 0x0000000710217812ULL, 0x000fe200078ec0ffULL,
0x0000000116107824ULL, 0x100fe200078e0209ULL, 0x0000001e09207210ULL, 0x000fe20007ffe0ffULL,
0x000000011c167824ULL, 0x100fe200078e0209ULL, 0x00000009281a7210ULL, 0x000fe20007ffe0ffULL,
0x000000081e117824ULL, 0x000fe200078e00ffULL, 0x0ffffff821217812ULL, 0x000fe200078ef808ULL,
0x000000012a1c7824ULL, 0x000fc400078e0209ULL, 0x0000000109267824ULL, 0x040fe200078e0226ULL,
0xfffffff811287812ULL, 0x000fe200078ee204ULL, 0x0000000109247824ULL, 0x040fe400078e0224ULL,
0x00000001091e7824ULL, 0x000fe400078e021fULL, 0x000000011f0f7824ULL, 0x000fe400078e0208ULL,
0x0000010002087825ULL, 0x000fc800078e00ffULL, 0x000040000a027824ULL, 0x000fe200078e0207ULL,
0x0000007008087812ULL, 0x000fe200078ef80eULL, 0x0000010012127825ULL, 0x000fc600078e00ffULL,
0x0000000408087c10ULL, 0x000fe2000ff1e0ffULL, 0x0000100002347836ULL, 0x000fe20000000000ULL,
0x0000007012127812ULL, 0x000fe200078ef80eULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x0000000509097c10ULL, 0x000fe400087fe4ffULL, 0x0000003415027211ULL, 0x000fe200078e20ffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x0000000412127c10ULL, 0x000fe4000ff1e0ffULL,
0x0000007010107812ULL, 0x000fe200078ef80eULL, 0x00000010193d7824ULL, 0x000fe200078e0234ULL,
0x0000007014147812ULL, 0x000fe200078ef80eULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x0000000513137c10ULL, 0x000fc400087fe4ffULL, 0x0000000414147c10ULL, 0x000fe2000ff1e0ffULL,
0x0000001017047824ULL, 0x100fe200078e0234ULL, 0x0000007018187812ULL, 0x000fe200078ef80eULL,
0x000000081f2a7824ULL, 0x000fe200078e00ffULL, 0x00000034212b7211ULL, 0x000fe200078e20ffULL,
0x000000101d417824ULL, 0x100fe200078e0234ULL, 0x0000000410107c10ULL, 0x000fe2000ff3e0ffULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x0000000515157c10ULL, 0x000fe200087fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000082b7faeULL, 0x0007e2000b901c46ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee20fULL, 0x000000101b3f7824ULL, 0x000fe200078e0234ULL,
0x0000007016167812ULL, 0x000fe200078ef80eULL, 0x000001001c1c7825ULL, 0x000fe200078e00ffULL,
0x0000000418187c10ULL, 0x000fc4000ff1e0ffULL, 0x0000000511117c10ULL, 0x000fe20008ffe4ffULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x000000701c1c7812ULL, 0x000fe400078ef80eULL,
0x0000000416167c10ULL, 0x000fe2000ff3e0ffULL, 0x000000102d217824ULL, 0x100fe200078e0234ULL,
0x000000701a1a7812ULL, 0x000fe200078ef80eULL, 0x000000102f1f7824ULL, 0x000fe200078e0234ULL,
0x0000000519197c10ULL, 0x000fe200087fe4ffULL, 0x000001002c2c7825ULL, 0x000fe200078e00ffULL,
0x000000041c1c7c10ULL, 0x000fc4000ff1e0ffULL, 0x000000041a1a7c10ULL, 0x000fe2000ff5e0ffULL,
0x00000010310f7824ULL, 0x000fe200078e0234ULL, 0x000000702c367812ULL, 0x000fe200078ef80eULL,
0x000001002e2e7825ULL, 0x000fe200078e00ffULL, 0x0000000517177c10ULL, 0x000fe40008ffe4ffULL,
0x0000000436367c10ULL, 0x000fe2000ff3e0ffULL, 0x0000010030307825ULL, 0x000fe200078e00ffULL,
0x000000702e387812ULL, 0x000fe400078ef80eULL, 0x000000051d1d7c10ULL, 0x000fe200087fe4ffULL,
0x0000010032327825ULL, 0x000fe200078e00ffULL, 0x00000070303a7812ULL, 0x000fc400078ef80eULL,
0x000000051b1b7c10ULL, 0x000fe200097fe4ffULL, 0x0000001029297824ULL, 0x100fe200078e0234ULL,
0x0000000438387c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001027277824ULL, 0x100fe200078e0234ULL,
0x000000043a3a7c10ULL, 0x000fe2000ff5e0ffULL, 0x0000001025257824ULL, 0x100fe200078e0234ULL,
0x000000052d377c10ULL, 0x000fe20008ffe4ffULL, 0x00000100262c7825ULL, 0x000fe200078e00ffULL,
0x0000007032327812ULL, 0x000fe200078ef80eULL, 0x0000000010297faeULL, 0x0007e2000b901c46ULL,
0x000000052f397c10ULL, 0x000fe200087fe4ffULL, 0x00000100242e7825ULL, 0x000fe200078e00ffULL,
0x00000005313b7c10ULL, 0x000fe200097fe4ffULL, 0x0000000012277faeULL, 0x0007e2000b901c46ULL,
0x0000000432327c10ULL, 0x000fe2000ff1e0ffULL, 0x0000001023237824ULL, 0x100fe200078e0234ULL,
0x000000702c2c7812ULL, 0x000fe200078ef80eULL, 0x0000001022227824ULL, 0x100fe200078e0234ULL,
0x000000702e2e7812ULL, 0x000fe200078ef80eULL, 0x0000001028437824ULL, 0x100fe200078e0234ULL,
0x0000000533337c10ULL, 0x000fe200087fe4ffULL, 0x000000102a457824ULL, 0x000fe200078e0234ULL,
0x000000042c2c7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000010020307825ULL, 0x000fe200078e00ffULL,
0x0000000014257faeULL, 0x0007e2000b901c46ULL, 0x000000042e2e7c10ULL, 0x000fc4000ff3e0ffULL,
0x000001001e347825ULL, 0x000fe200078e00ffULL, 0x0000007030307812ULL, 0x000fe200078ef80eULL,
0x0000000016237faeULL, 0x0007e2000b901c46ULL, 0x000000052d2d7c10ULL, 0x000fe400087fe4ffULL,
0x00000070340e7812ULL, 0x000fe200078ef80eULL, 0x0000000018217faeULL, 0x0007e2000b901c46ULL,
0x0000000430307c10ULL, 0x000fe4000ff5e0ffULL, 0x000000040e347c10ULL, 0x000fe2000ff7e0ffULL,
0x000000001a1f7faeULL, 0x0007e2000b901c46ULL, 0x000000052f2f7c10ULL, 0x000fc40008ffe4ffULL,
0x0000000531317c10ULL, 0x000fe200097fe4ffULL, 0x000000001c0f7faeULL, 0x0007e2000b901c46ULL,
0x0000000535357c10ULL, 0x000fc60009ffe4ffULL, 0x0000000036027faeULL, 0x0007e8000b901c46ULL,
0x0000000038047faeULL, 0x0007e8000b901c46ULL, 0x000000003a227faeULL, 0x0007e8000b901c46ULL,
0x00000000323d7faeULL, 0x0007e8000b901c46ULL, 0x000000002c3f7faeULL, 0x0007e8000b901c46ULL,
0x000000002e417faeULL, 0x0007e8000b901c46ULL, 0x0000000030437faeULL, 0x0007e8000b901c46ULL,
0x0000000034457faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x00afe20000015200ULL, 0x01b6000d070075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ff00047202ULL, 0x000fce0000000f00ULL,
0x000000100400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e08117210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e09ULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc8000001140fULL,
0x0000001102027211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x0000000202027819ULL, 0x000fc8000000120fULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000104047836ULL, 0x000fce0000000000ULL,
0x01b6000d070075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000054c00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000097919ULL, 0x000e620000000000ULL, 0x0000840000097ab9ULL, 0x000fe20000000800ULL,
0x000000080a487824ULL, 0x140fe200078e0207ULL, 0x0000001f09047890ULL, 0x000fe4000fffe03fULL,
0x80000009064b7c36ULL, 0x000fe20008000000ULL, 0xffffffff09057890ULL, 0x000fe2000fffe03fULL,
0x000000200a087824ULL, 0x000fe200078e0207ULL, 0x000000043f047899ULL, 0x000fe40008011604ULL,
0x00000008ff4b7819ULL, 0x000fe2000001164bULL, 0x0000000909087890ULL, 0x000fc4000fffe03fULL,
0x0ffffffe04047892ULL, 0x000fd8000f8ec03fULL, 0x000000014c027836ULL, 0x000fe20000000000ULL,
0x000000034c497211ULL, 0x000fe200078e40ffULL, 0x0000920000097ab9ULL, 0x000fc60000000800ULL,
0x000000050200720cULL, 0x000fe20003f06070ULL, 0x000000094a0e7c24ULL, 0x002fd8000f8e0249ULL,
0x0000000800f48947ULL, 0x002fea0003800000ULL, 0x00000003ff0f7819ULL, 0x002fe20000011609ULL,
0x0000001009637824ULL, 0x040fe200078e00ffULL, 0x00008e00000a7ab9ULL, 0x000fe20000000a00ULL,
0x0ffffff809617812ULL, 0x000fe200078ec0ffULL, 0x000040000a5f7824ULL, 0x000fe200078e0207ULL,
0x000000200f2b7810ULL, 0x000fe20007ffe0ffULL, 0x000000040f137836ULL, 0x000fe20000000000ULL,
0x0000007063637812ULL, 0x000fe200078ec0ffULL, 0x000000080f157836ULL, 0x000fe40000000000ULL,
0x0000000113027824ULL, 0x000fe200078e0209ULL, 0x00000080630c7812ULL, 0x000fe200078efcffULL,
0x00000008130d7824ULL, 0x000fc400078e00ffULL, 0x0000000115047824ULL, 0x140fe400078e0209ULL,
0x0000000815117824ULL, 0x000fe200078e00ffULL, 0xfffffff80d1e7812ULL, 0x000fe200078ee202ULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x0000004906027248ULL, 0x000fe20007fe0000ULL,
0x000000100f1d7836ULL, 0x000fe20000000000ULL, 0xfffffff811227812ULL, 0x000fe200078ee204ULL,
0x0000000c0f177836ULL, 0x000fe20000000000ULL, 0x0000000e0f117210ULL, 0x000fe20007ffe0ffULL,
0x000000011d127824ULL, 0x040fe200078e0209ULL, 0x0000000249027210ULL, 0x000fe20007ffe1ffULL,
0x000000081d1b7824ULL, 0x000fc400078e00ffULL, 0x0000010011107825ULL, 0x000fe200078e000cULL,
0x000000021300720cULL, 0x080fe40003f86070ULL, 0x000000021500720cULL, 0x080fe20003f26070ULL,
0x0000000113137824ULL, 0x100fe200078e020eULL, 0x0000000a10107c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000115157824ULL, 0x000fe200078e020eULL, 0xfffffff81b267812ULL, 0x000fe200078ee212ULL,
0x0000000117047824ULL, 0x040fe200078e0209ULL, 0x0000000b11117c10ULL, 0x000fe200087fe4ffULL,
0x0000000817197824ULL, 0x000fe200078e00ffULL, 0x000000021d00720cULL, 0x080fe20003f06070ULL,
0x0000010013127825ULL, 0x000fe200078e000cULL, 0x000000021700720cULL, 0x000fc40003f46070ULL,
0xfffffff819247812ULL, 0x000fe200078ee204ULL, 0x000000140f1f7836ULL, 0x000fe20000000000ULL,
0x0000000a12207c10ULL, 0x000fe2000ff7e0ffULL, 0x0000010015147825ULL, 0x000fc600078e000cULL,
0x0000000b13217c10ULL, 0x000fe20009ffe4ffULL, 0x000000011d1d7824ULL, 0x100fe200078e020eULL,
0x0000000a14187c10ULL, 0x000fe2000ffbe0ffULL, 0x000000011f197824ULL, 0x100fe400078e020eULL,
0x0000000117177824ULL, 0x000fe400078e020eULL, 0x000001001d1c7825ULL, 0x000fc800078e000cULL,
0x0000010019127825ULL, 0x100fe200078e000cULL, 0x0000000b15197c10ULL, 0x000fe4000affe4ffULL,
0x0000000a1c147c10ULL, 0x000fe2000ffbe0ffULL, 0x0000010017167825ULL, 0x000fe200078e000cULL,
0x0000000a12127c10ULL, 0x000fe4000ffde0ffULL, 0x0000000b1d157c10ULL, 0x000fe2000affe4ffULL,
0x000000010f047824ULL, 0x140fe200078e0209ULL, 0x0000000a161a7c10ULL, 0x000fe2000ff7e0ffULL,
0x000000180f277836ULL, 0x000fe20000000000ULL, 0x000000020f00720cULL, 0x080fe20003fa6070ULL,
0x000030005f4d7836ULL, 0x000fe20000000000ULL, 0x0000000b171b7c10ULL, 0x000fe20009ffe4ffULL,
0x0000001c0f297836ULL, 0x000fe20000000000ULL, 0x0000000761047812ULL, 0x000fe200078ef804ULL,
0x000000011f1c7824ULL, 0x040fe200078e0209ULL, 0x0000000e27177210ULL, 0x000fe20007ffe0ffULL,
0x000000101e257824ULL, 0x100fe200078e024dULL, 0x000000021f00720cULL, 0x040fe20003f66070ULL,
0x000000081f1f7824ULL, 0x000fe200078e00ffULL, 0x0000000b13137c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001004237824ULL, 0x000fc400078e024dULL, 0x0000010017167825ULL, 0x000fe200078e000cULL,
0xfffffff81f287812ULL, 0x000fe400078ee21cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010237faeULL, 0x0003e2000e901c46ULL, 0x00000001291d7824ULL, 0x100fe200078e020eULL,
0x0000000a16167c10ULL, 0x000fe2000ffde0ffULL, 0x000000012b1f7824ULL, 0x000fe200078e020eULL,
0x0000000020257faeULL, 0x0005e2000e101c46ULL, 0x000001001d1c7825ULL, 0x000fe200078e000cULL,
0x000000022700720cULL, 0x0c0fe40003fa6070ULL, 0x0000000b17177c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000127047824ULL, 0x040fe200078e0209ULL, 0x0000000a1c1c7c10ULL, 0x000fe2000ffde0ffULL,
0x00000008272d7824ULL, 0x000fe200078e00ffULL, 0x000000022900720cULL, 0x0c0fe20003f86070ULL,
0x0000001024237824ULL, 0x002fe200078e024dULL, 0x0000000b1d1d7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000129277824ULL, 0x040fe200078e0209ULL, 0x0000004d22217211ULL, 0x004fe200078e20ffULL,
0x000000240f257836ULL, 0x000fe20000000000ULL, 0xfffffff82d047812ULL, 0x000fe200078ee204ULL,
0x0000000829107824ULL, 0x000fe200078e00ffULL, 0x000000300f2d7810ULL, 0x000fe20007ffe0ffULL,
0x000001001f1e7825ULL, 0x000fe200078e000cULL, 0x0000000018217faeULL, 0x0003e2000c901c46ULL,
0x000000022b00720cULL, 0x000fc40003f26070ULL, 0x0000000125117824ULL, 0x000fe200078e020eULL,
0x000000001a237faeULL, 0x0005e2000d101c46ULL, 0x000000012b227824ULL, 0x100fe200078e0209ULL,
0x000000022500720cULL, 0x000fe20003f46070ULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff810207812ULL, 0x000fe200078ee227ULL, 0x0000000125247824ULL, 0x040fe200078e0209ULL,
0x0000000a1e1e7c10ULL, 0x000fe2000ffde0ffULL, 0x0000000825257824ULL, 0x000fe200078e00ffULL,
0x0000004d26197211ULL, 0x002fe200078e20ffULL, 0x0000010011107825ULL, 0x000fe200078e000cULL,
0xfffffff82b227812ULL, 0x000fc400078ee222ULL, 0x0000000b1f1f7c10ULL, 0x000fe2000b7fe4ffULL,
0x00000010281b7824ULL, 0x104fe200078e024dULL, 0xfffffff825247812ULL, 0x000fe200078ee224ULL,
0x0000001004217824ULL, 0x100fe200078e024dULL, 0x0000000a10107c10ULL, 0x000fe2000ffde0ffULL,
0x0000000014197faeULL, 0x000fe2000c101c46ULL, 0x0000001020237824ULL, 0x100fe400078e024dULL,
0x000000280f297836ULL, 0x000fe20000000000ULL, 0x00000000121b7faeULL, 0x0003e2000d901c46ULL,
0x0000001022257824ULL, 0x100fe200078e024dULL, 0x0000000b11117c10ULL, 0x000fe2000b7fe4ffULL,
0x0000001024277824ULL, 0x000fe200078e024dULL, 0x0000000016217faeULL, 0x0005e2000e901c46ULL,
0x0000002c0f2b7836ULL, 0x000fe20000000000ULL, 0x000000022900720cULL, 0x080fe20003fa6070ULL,
0x000000340f2f7836ULL, 0x000fe20000000000ULL, 0x000000001c237faeULL, 0x0007e2000e101c46ULL,
0x000000380f317836ULL, 0x000fe20000000000ULL, 0x000000022b00720cULL, 0x080fe20003f86070ULL,
0x0000000129047824ULL, 0x000fe200078e0209ULL, 0x000000001e257faeULL, 0x000fe2000c901c46ULL,
0x000000012b137824ULL, 0x102fe200078e020eULL, 0x000000022d00720cULL, 0x080fe20003f66070ULL,
0x00000001311b7824ULL, 0x100fe200078e020eULL, 0x0000000010277faeULL, 0x0003e2000d101c46ULL,
0x0000003c0f217836ULL, 0x004fe20000000000ULL, 0x000000022f00720cULL, 0x080fe20003f46070ULL,
0x00000001290f7824ULL, 0x000fe200078e020eULL, 0x000000032f1c7819ULL, 0x008fe200000006ffULL,
0x0000010013127825ULL, 0x000fe200078e000cULL, 0x000000023100720cULL, 0x000fc40003f26070ULL,
0x000000022100720cULL, 0x000fe20003f06070ULL, 0x0000000829297824ULL, 0x000fe400078e00ffULL,
0x000000012b027824ULL, 0x000fe400078e0209ULL, 0x000001000f107825ULL, 0x002fe200078e000cULL,
0x0000000e2d0f7210ULL, 0x000fe40007ffe0ffULL, 0xfffffff829047812ULL, 0x000fe200078ee204ULL,
0x000000082b2b7824ULL, 0x000fe200078e00ffULL, 0x0000000a10147c10ULL, 0x000fe2000ffde0ffULL,
0x000000012d1a7824ULL, 0x000fc400078e0209ULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0x0000000b11157c10ULL, 0x000fe2000b7fe4ffULL, 0x000001000f107825ULL, 0x000fe200078e000cULL,
0x0000000a12167c10ULL, 0x000fe4000ffde0ffULL, 0xfffffff82b027812ULL, 0x000fe200078ee202ULL,
0x000000012f0f7824ULL, 0x000fe200078e020eULL, 0x0000000b13177c10ULL, 0x000fe2000b7fe4ffULL,
0x00000008211e7824ULL, 0x000fe200078e00ffULL, 0x0000000a10187c10ULL, 0x000fe2000ffde0ffULL,
0x000001000f127825ULL, 0x000fe200078e000cULL, 0xfffffff82d1a7812ULL, 0x000fc400078ee21aULL,
0x0000000b11197c10ULL, 0x000fe2000b7fe4ffULL, 0x000001001b107825ULL, 0x000fe200078e000cULL,
0x0000000a12127c10ULL, 0x000fe4000ffde0ffULL, 0x0000004d1a1d7211ULL, 0x000fe200078e20ffULL,
0x000000012f1b7824ULL, 0x000fe200078e0209ULL, 0x0000000b13137c10ULL, 0x000fe2000b7fe4ffULL,
0x00000001210f7824ULL, 0x000fe200078e020eULL, 0x0000000a100e7c10ULL, 0x000fe4000ffde0ffULL,
0xfffffff81c107812ULL, 0x000fe200078ee21bULL, 0x000001000f0c7825ULL, 0x000fe200078e000cULL,
0x0000000b110f7c10ULL, 0x000fc6000b7fe4ffULL, 0x0000000131117824ULL, 0x140fe200078e0209ULL,
0x0000000a0c0c7c10ULL, 0x000fe2000ffde0ffULL, 0x00000008311c7824ULL, 0x000fe400078e00ffULL,
0x00000001211b7824ULL, 0x000fe200078e0209ULL, 0x0000000b0d0d7c10ULL, 0x000fe2000b7fe4ffULL,
0x00000010101f7824ULL, 0x100fe200078e024dULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee211ULL,
0x0000001004117824ULL, 0x100fe200078e024dULL, 0xfffffff81e047812ULL, 0x000fe200078ee21bULL,
0x00000010021b7824ULL, 0x000fc400078e024dULL, 0x000000101c217824ULL, 0x100fe200078e024dULL,
0x0000000014117faeULL, 0x0003e2000e901c46ULL, 0x0000001004237824ULL, 0x000fc600078e024dULL,
0x00000000161b7faeULL, 0x0003e8000e101c46ULL, 0x00000000181d7faeULL, 0x0003e8000d901c46ULL,
0x00000000121f7faeULL, 0x0003e8000d101c46ULL, 0x000000000e217faeULL, 0x0003e8000c901c46ULL,
0x000000000c237faeULL, 0x0003e2000c101c46ULL, 0x0000000800a47947ULL, 0x000fea0003800000ULL,
0x0000000409117811ULL, 0x042fe200078fe8ffULL, 0x0000001009637824ULL, 0x040fe200078e00ffULL,
0x0000000809177811ULL, 0x040fe200078fe8ffULL, 0x00008e00000a7ab9ULL, 0x000fe20000000a00ULL,
0x00000010091b7811ULL, 0x000fe200078fe8ffULL, 0x0000000111407824ULL, 0x100fe200078e0209ULL,
0x00000014091d7811ULL, 0x000fe200078fe8ffULL, 0x00000008110d7824ULL, 0x000fe200078e00ffULL,
0x0000001c09217811ULL, 0x000fe200078fe8ffULL, 0x0000000117427824ULL, 0x100fe200078e0209ULL,
0x0000000c09197811ULL, 0x000fe200078fe8ffULL, 0x000000011b3e7824ULL, 0x100fe200078e0209ULL,
0xfffffff80d407812ULL, 0x000fe200078ee240ULL, 0x00000008170d7824ULL, 0x000fe200078e00ffULL,
0x0000002009237811ULL, 0x000fe200078fe8ffULL, 0x000000081b137824ULL, 0x000fe200078e00ffULL,
0x0000000921387210ULL, 0x000fe20007ffe0ffULL, 0x000000011d3c7824ULL, 0x140fe200078e0209ULL,
0xfffffff80d427812ULL, 0x000fe200078ee242ULL, 0x000000081d0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8133e7812ULL, 0x000fe200078ee23eULL, 0x0000000821137824ULL, 0x000fe200078e00ffULL,
0x0000002809277811ULL, 0x000fe200078fe8ffULL, 0x00000008190f7824ULL, 0x000fe200078e00ffULL,
0x0000000919447210ULL, 0x000fe20007ffe0ffULL, 0x0000000123367824ULL, 0x100fe200078e0209ULL,
0x00000018091f7811ULL, 0x000fe200078fe8ffULL, 0x0000000127327824ULL, 0x100fe200078e0209ULL,
0xfffffff80d3c7812ULL, 0x000fe200078ee23cULL, 0x00000008230d7824ULL, 0x000fe200078e00ffULL,
0xfffffff813387812ULL, 0x000fe200078ee238ULL, 0x0000000827137824ULL, 0x000fe200078e00ffULL,
0x0000002c09297811ULL, 0x000fe200078fe8ffULL, 0x000000011f3a7824ULL, 0x100fe200078e0209ULL,
0x0000003409157811ULL, 0x000fe200078fe8ffULL, 0x0000000111117824ULL, 0x100fe200078e020eULL,
0xfffffff80f447812ULL, 0x000fe200078ee244ULL, 0x000000081f0f7824ULL, 0x000fe200078e00ffULL,
0x0000002409257811ULL, 0x000fe200078fe8ffULL, 0x0000000115027824ULL, 0x100fe200078e0209ULL,
0xfffffff80d367812ULL, 0x000fe200078ee236ULL, 0x00000008290d7824ULL, 0x000fe200078e00ffULL,
0xfffffff813327812ULL, 0x000fe200078ee232ULL, 0x0000000815137824ULL, 0x000fe200078e00ffULL,
0x0000000929307210ULL, 0x000fe20007ffe0ffULL, 0x0000000125347824ULL, 0x100fe200078e0209ULL,
0x00000038090c7811ULL, 0x000fe200078fe8ffULL, 0x0000000119197824ULL, 0x100fe200078e020eULL,
0xfffffff80f3a7812ULL, 0x000fe200078ee23aULL, 0x00000008250f7824ULL, 0x000fe200078e00ffULL,
0x00000030092b7811ULL, 0x000fe200078fe8ffULL, 0x000000010c2c7824ULL, 0x140fe200078e0209ULL,
0xfffffff80d307812ULL, 0x000fe200078ee230ULL, 0x000000011b1b7824ULL, 0x100fe200078e020eULL,
0xfffffff813027812ULL, 0x000fe200078ee202ULL, 0x000000080c137824ULL, 0x040fe200078e00ffULL,
0x0000003c090d7811ULL, 0x000fe200078fe8ffULL, 0x000000012b047824ULL, 0x000fe200078e0209ULL,
0x0000007063637812ULL, 0x000fe200078ec0ffULL, 0x0000000121217824ULL, 0x100fe200078e020eULL,
0xfffffff80f347812ULL, 0x000fe200078ee234ULL, 0x000000082b0f7824ULL, 0x000fe200078e00ffULL,
0x000000090d2e7210ULL, 0x000fe20007ffe0ffULL, 0x000000010d2d7824ULL, 0x100fe200078e020eULL,
0x0000008063127812ULL, 0x000fe200078efcffULL, 0x000000080d2f7824ULL, 0x000fe200078e00ffULL,
0x0000000e090d7211ULL, 0x000fe200078fe8ffULL, 0x000000011d1d7824ULL, 0x100fe200078e020eULL,
0xfffffff8132c7812ULL, 0x000fe200078ee22cULL, 0x000000ffff137224ULL, 0x000fe200078e00ffULL,
0xfffffff80f047812ULL, 0x000fe200078ee204ULL, 0x000000010c0f7824ULL, 0x000fe200078e020eULL,
0x0000000e17177210ULL, 0x000fe20007ffe0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e0012ULL,
0x0000000909467211ULL, 0x000fc400078fe8ffULL, 0x0ffffff809617812ULL, 0x000fe200078ec0ffULL,
0x0000010011107825ULL, 0x100fe200078e0012ULL, 0x0000000a0c0c7c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000e27277210ULL, 0x000fe20007ffe0ffULL, 0x0000010019187825ULL, 0x100fe200078e0012ULL,
0x0000000a10107c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000b0d0d7c10ULL, 0x000fe200087fe4ffULL,
0x0000010017167825ULL, 0x000fe200078e0012ULL, 0x0000000b11117c10ULL, 0x000fc40008ffe4ffULL,
0x0000000a18187c10ULL, 0x000fe2000ff1e0ffULL, 0x000001001b1a7825ULL, 0x000fe200078e0012ULL,
0x0000000a16167c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000761467812ULL, 0x000fe200078ef846ULL,
0x0000000123237824ULL, 0x100fe200078e020eULL, 0x0000000a1a1a7c10ULL, 0x000fe2000ff3e0ffULL,
0x000000011f1f7824ULL, 0x100fe200078e020eULL, 0x0000000b19197c10ULL, 0x000fe200087fe4ffULL,
0x000040000a5f7824ULL, 0x000fe200078e0207ULL, 0x0000000b17177c10ULL, 0x000fe200097fe4ffULL,
0x0000000125257824ULL, 0x100fe200078e020eULL, 0x0000000b1b1b7c10ULL, 0x000fe20008ffe4ffULL,
0x0000000129297824ULL, 0x100fe200078e020eULL, 0xfffffff82f2e7812ULL, 0x000fe200078ee22eULL,
0x000000012b2b7824ULL, 0x000fc400078e020eULL, 0x0000000115157824ULL, 0x000fe400078e020eULL,
0x0000010021207825ULL, 0x000fc800078e0012ULL, 0x000001001d1c7825ULL, 0x000fe200078e0012ULL,
0x0000000a20207c10ULL, 0x000fc6000ff1e0ffULL, 0x0000010023227825ULL, 0x100fe200078e0012ULL,
0x0000000a1c1c7c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000b21217c10ULL, 0x000fe200087fe4ffULL,
0x000001001f1e7825ULL, 0x100fe200078e0012ULL, 0x0000000a22227c10ULL, 0x000fe4000ff3e0ffULL,
0x0000000b1d1d7c10ULL, 0x000fe200097fe4ffULL, 0x000030005f4d7836ULL, 0x000fe20000000000ULL,
0x0000000a1e1e7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000010025247825ULL, 0x000fe200078e0012ULL,
0x0000000b23237c10ULL, 0x000fc40008ffe4ffULL, 0x0000004d44337211ULL, 0x000fe200078e20ffULL,
0x0000010027267825ULL, 0x100fe200078e0012ULL, 0x0000000b1f1f7c10ULL, 0x000fe40009ffe4ffULL,
0x0000000a24247c10ULL, 0x000fe2000ff5e0ffULL, 0x0000010029287825ULL, 0x100fe200078e0012ULL,
0x0000000a26267c10ULL, 0x000fe4000ff7e0ffULL, 0x0000000b25257c10ULL, 0x000fe200097fe4ffULL,
0x000001002b2a7825ULL, 0x000fe200078e0012ULL, 0x0000000a28287c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000b27277c10ULL, 0x000fe20009ffe4ffULL, 0x0000010015147825ULL, 0x100fe200078e0012ULL,
0x0000000a2a2a7c10ULL, 0x000fe4000ff3e0ffULL, 0x0000000b29297c10ULL, 0x000fe200087fe4ffULL,
0x000001000f0e7825ULL, 0x100fe200078e0012ULL, 0x0000000b2b2b7c10ULL, 0x000fe40008ffe4ffULL,
0x0000000a14147c10ULL, 0x000fe2000ff1e0ffULL, 0x000001002d127825ULL, 0x000fe200078e0012ULL,
0x0000000a0e0e7c10ULL, 0x000fc4000ff3e0ffULL, 0x0000000b15157c10ULL, 0x000fe200087fe4ffULL,
0x00000010462d7824ULL, 0x100fe200078e024dULL, 0x0000000a12127c10ULL, 0x000fe2000ff5e0ffULL,
0x00000010402f7824ULL, 0x100fe200078e024dULL, 0x0000000b0f0f7c10ULL, 0x000fe20008ffe4ffULL,
0x0000001042317824ULL, 0x100fe200078e024dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c2d7faeULL, 0x0003e2000b901c46ULL, 0x000000103e357824ULL, 0x100fe200078e024dULL,
0x0000000b13137c10ULL, 0x000fe200097fe4ffULL, 0x000000103c377824ULL, 0x100fe200078e024dULL,
0x00000000102f7faeULL, 0x0005e2000b901c46ULL, 0x000000103a397824ULL, 0x000fc600078e024dULL,
0x0000000016317faeULL, 0x0007e2000b901c46ULL, 0x00000010380d7824ULL, 0x002fc600078e024dULL,
0x0000000018337faeULL, 0x0003e2000b901c46ULL, 0x0000001036117824ULL, 0x004fc600078e024dULL,
0x000000001a357faeULL, 0x0005e2000b901c46ULL, 0x0000001034177824ULL, 0x008fc600078e024dULL,
0x000000001c377faeULL, 0x0007e2000b901c46ULL, 0x0000001032197824ULL, 0x002fc600078e024dULL,
0x000000001e397faeULL, 0x0003e2000b901c46ULL, 0x0000004d301b7211ULL, 0x004fc600078e20ffULL,
0x00000000200d7faeULL, 0x0005e2000b901c46ULL, 0x00000010041d7824ULL, 0x008fc600078e024dULL,
0x0000000022117faeULL, 0x0007e2000b901c46ULL, 0x00000010021f7824ULL, 0x002fc600078e024dULL,
0x0000000024177faeULL, 0x0007e2000b901c46ULL, 0x000000102c0d7824ULL, 0x004fc600078e024dULL,
0x0000000026197faeULL, 0x0007e2000b901c46ULL, 0x000000102e217824ULL, 0x000fc600078e024dULL,
0x00000000281b7faeULL, 0x0007e8000b901c46ULL, 0x000000002a1d7faeULL, 0x0007e8000b901c46ULL,
0x00000000141f7faeULL, 0x0007e8000b901c46ULL, 0x000000000e0d7faeULL, 0x0007e8000b901c46ULL,
0x0000000012217faeULL, 0x0007e4000b901c46ULL, 0x00000004ff0c7819ULL, 0x102fe20000011609ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000709047812ULL, 0x000fe200078ec0ffULL,
0x000010005f5f7836ULL, 0x000fe20000000000ULL, 0x00000003ff027819ULL, 0x000fe20000011609ULL,
0x000000080c0f7824ULL, 0x008fe200078e00ffULL, 0x00000008044f7812ULL, 0x000fe200078ef809ULL,
0x000000010b7a7824ULL, 0x000fe200078e024cULL, 0x00000001020d7812ULL, 0x000fe400078ec0ffULL,
0xfffffff80f387812ULL, 0x000fe200078ee204ULL, 0x000000010c5d7824ULL, 0x000fc400078e024fULL,
0x000000104f0c7824ULL, 0x000fe200078e00ffULL, 0x000000380d377210ULL, 0x000fe20007ffe0ffULL,
0x0000000838787824ULL, 0x040fe200078e00ffULL, 0x0000003038347810ULL, 0x000fe20007ffe0ffULL,
0x0000001038367836ULL, 0x000fe20000000000ULL, 0xfffffff00c0c7812ULL, 0x000fe200078ee25dULL,
0x0000002038357836ULL, 0x000fe20000000000ULL, 0xfffffff878787812ULL, 0x000fe200078ee237ULL,
0x000000010d767824ULL, 0x000fe200078e0236ULL, 0x0000000338177819ULL, 0x000fe200000006ffULL,
0x000000100c0c7824ULL, 0x000fe200078e0207ULL, 0x0000003437607810ULL, 0x000fe20007ffe0ffULL,
0x0000001078107824ULL, 0x000fe200078e025fULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000010d747824ULL, 0x040fe200078e0235ULL, 0x000000000c24783bULL, 0x0003e20000000200ULL,
0x000000010d727824ULL, 0x000fe400078e0234ULL, 0x00000008360f7824ULL, 0x000fe200078e00ffULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x00000008340d7824ULL, 0x000fe400078e00ffULL,
0x0000000237707836ULL, 0x000fe20000000000ULL, 0xfffffff80f767812ULL, 0x000fe200078ee276ULL,
0x000000104f157824ULL, 0x000fe200078e00ffULL, 0xfffffff80d727812ULL, 0x000fe200078ee272ULL,
0x000000025d0e7836ULL, 0x000fe20000000000ULL, 0xfffffff817707812ULL, 0x000fe200078ee270ULL,
0x0000001076307824ULL, 0x100fe200078e025fULL, 0x00000003360d7819ULL, 0x000fe200000006ffULL,
0x0000001072287824ULL, 0x000fe200078e025fULL, 0xfffffff0150e7812ULL, 0x000fe200078ee20eULL,
0x00000008350f7824ULL, 0x000fc400078e00ffULL, 0x000000003030783bULL, 0x000ee20000000200ULL,
0x0000001070547824ULL, 0x000fe400078e025fULL, 0xfffffff80f747812ULL, 0x000fe200078ee274ULL,
0x000000002828783bULL, 0x000f220000000200ULL, 0x000000100e0e7824ULL, 0x000fe400078e0207ULL,
0x00000012376e7836ULL, 0x000fe20000000000ULL, 0x000000005454783bULL, 0x000fe20000000200ULL,
0x00000010742c7824ULL, 0x000fe400078e025fULL, 0x00000022376a7836ULL, 0x000fe20000000000ULL,
0x000000000e1c783bULL, 0x000f620000000200ULL, 0xfffffff80d6e7812ULL, 0x000fe200078ee26eULL,
0x0000000835157824ULL, 0x000fc400078e00ffULL, 0x000000002c2c783bULL, 0x000f620000000200ULL,
0x0000003237687836ULL, 0x000fe40000000000ULL, 0x000000106e0c7824ULL, 0x102fe200078e025fULL,
0xfffffff8156a7812ULL, 0x000fe200078ee26aULL, 0x00000008343b7824ULL, 0x000fe400078e00ffULL,
0x0000002437627836ULL, 0x000fe40000000000ULL, 0x000000000c0c783bULL, 0x000e620000000200ULL,
0x000000102420723cULL, 0x004fe200000018ffULL, 0x000000106a147824ULL, 0x000fe200078e025fULL,
0xfffffff83b607812ULL, 0x000fe200078ee260ULL, 0x0000000835397824ULL, 0x000fc400078e00ffULL,
0x00000004376c7836ULL, 0x000fe20000000000ULL, 0x000000122410723cULL, 0x000fe200000018ffULL,
0x000000001414783bULL, 0x000ea20000000200ULL, 0x00000010603c7824ULL, 0x000fe200078e025fULL,
0xfffffff839627812ULL, 0x000fe200078ee262ULL, 0x0000001437667836ULL, 0x000fe40000000000ULL,
0x00000036374e7836ULL, 0x000fe20000000000ULL, 0x0000005f62407211ULL, 0x000fe200078e20ffULL,
0x000000302450723cULL, 0x008fe200000018ffULL, 0x000000003c3c783bULL, 0x000fe20000000200ULL,
0x0000000637647836ULL, 0x000fc40000000000ULL, 0x0000000835357824ULL, 0x000fe200078e00ffULL,
0x000000004040783bULL, 0x000fe20000000200ULL, 0x000000282418723cULL, 0x010fe200000018ffULL,
0x00000016375e7836ULL, 0x000fe40000000000ULL, 0x00000026375c7836ULL, 0x000fc60000000000ULL,
0x000000541c20723cULL, 0x020fe20000001820ULL, 0x0000000834297824ULL, 0x000fe200078e00ffULL,
0xfffffff8355c7812ULL, 0x000fc800078ee25cULL, 0xfffffff829687812ULL, 0x000fe200078ee268ULL,
0x000000561c54723cULL, 0x000fe80000001810ULL, 0x0000001068287824ULL, 0x000fe400078e025fULL,
0x0000002c2410723cULL, 0x000fec00000018ffULL, 0x000000322430723cULL, 0x000fec00000018ffULL,
0x0000002e242c723cULL, 0x000fec00000018ffULL, 0x0000002a2424723cULL, 0x000fe200000018ffULL,
0x000000002828783bULL, 0x000eea0000000200ULL, 0x0000000c1c50723cULL, 0x002fec0000001850ULL,
0x000000141c10723cULL, 0x004fe20000001810ULL, 0x000000045d0c7836ULL, 0x000fe20000000000ULL,
0x000000044f0d7819ULL, 0x000fc800000006ffULL, 0xfffffff00d3a7812ULL, 0x000fe200078ee20cULL,
0x000000104f157824ULL, 0x000fe200078e00ffULL, 0x0000000e1c0c723cULL, 0x000fe20000001830ULL,
0x000000065d147836ULL, 0x000fe40000000000ULL, 0x000000103a3a7824ULL, 0x000fc800078e0207ULL,
0x0000000838317824ULL, 0x000fe200078e00ffULL, 0xfffffff015307812ULL, 0x000fe200078ee214ULL,
0x000000003a38783bULL, 0x000e620000000200ULL, 0x0000000836337824ULL, 0x000fe200078e00ffULL,
0x000000161c14723cULL, 0x000fe2000000182cULL, 0xfffffff8316c7812ULL, 0x000fe400078ee26cULL,
0x0000000730657211ULL, 0x000fe400078e20ffULL, 0xfffffff833667812ULL, 0x000fe200078ee266ULL,
0x000000106c587824ULL, 0x000fe200078e025fULL, 0xfffffff831647812ULL, 0x000fe200078ee264ULL,
0x00000008342f7824ULL, 0x000fc400078e00ffULL, 0x0000001066447824ULL, 0x100fe200078e025fULL,
0x000000281c18723cULL, 0x008fe20000001818ULL, 0x000000005858783bULL, 0x000ea20000000200ULL,
0xfffffff82f4e7812ULL, 0x000fe200078ee24eULL, 0x00000008362d7824ULL, 0x000fe400078e00ffULL,
0x000000004444783bULL, 0x000ee20000000200ULL, 0x0000002a1c1c723cULL, 0x000fe20000001824ULL,
0x000000104e287824ULL, 0x100fe200078e025fULL, 0xfffffff82d5e7812ULL, 0x000fe200078ee25eULL,
0x000000006524783bULL, 0x000fe20000000200ULL, 0x0000001064347824ULL, 0x000fc400078e025fULL,
0x000000105c2c7824ULL, 0x100fe200078e025fULL, 0x000000002828783bULL, 0x000f220000000200ULL,
0x000000105e307824ULL, 0x000fc600078e025fULL, 0x000000003434783bULL, 0x000f680000000200ULL,
0x000000003030783bULL, 0x000f280000000200ULL, 0x000000002c2c783bULL, 0x000f220000000200ULL,
0x0000003c3818723cULL, 0x002fec0000001818ULL, 0x0000003e381c723cULL, 0x000fec000000181cULL,
0x000000403810723cULL, 0x000fec0000001810ULL, 0x000000583820723cULL, 0x004fec0000001820ULL,
0x0000005a3854723cULL, 0x000fec0000001854ULL, 0x000000443850723cULL, 0x008fec0000001850ULL,
0x00000046380c723cULL, 0x000fec000000180cULL, 0x000000423814723cULL, 0x000fec0000001814ULL,
0x000000282418723cULL, 0x010fec0000001818ULL, 0x0000002a2428723cULL, 0x000fec000000181cULL,
0x000000342420723cULL, 0x020fe20000001820ULL, 0x000000017a1c7836ULL, 0x000fc40000000000ULL,
0x000001007a1d7824ULL, 0x000fc600078e0203ULL, 0x000000051c00720cULL, 0x000fe20003f06070ULL,
0x000000362454723cULL, 0x000fe20000001854ULL, 0x000000094a397c24ULL, 0x000fca000f8e021dULL,
0x000000302450723cULL, 0x000fec0000001850ULL, 0x00000032240c723cULL, 0x000fec000000180cULL,
0x0000002c2410723cULL, 0x000fec0000001810ULL, 0x0000002e2414723cULL, 0x000fe20000001814ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000c00108947ULL, 0x000fde0003800000ULL,
0x00000004021e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000c02267836ULL, 0x000fe20000000000ULL,
0x0000001d06357248ULL, 0x000fe20007fe0000ULL, 0x00000008022c7836ULL, 0x000fe20000000000ULL,
0x00000039021c7210ULL, 0x000fe20007ffe0ffULL, 0x000000011e3c7824ULL, 0x040fe400078e0209ULL,
0x000000081e1f7824ULL, 0x000fe400078e00ffULL, 0x0000000135357824ULL, 0x000fe400078e0a1dULL,
0x0000001402407836ULL, 0x000fe20000000000ULL, 0xfffffff81f3c7812ULL, 0x000fe200078ee23cULL,
0x00000001263e7824ULL, 0x000fe200078e0209ULL, 0x000000351e00720cULL, 0x080fe20003f46070ULL,
0x00000008261f7824ULL, 0x040fe200078e00ffULL, 0x000000352600720cULL, 0x080fe20003fa6070ULL,
0x000001001c1c7825ULL, 0x000fe200078e00ffULL, 0x000000352c00720cULL, 0x000fc40003f66070ULL,
0xfffffff81f3e7812ULL, 0x000fe200078ee23eULL, 0x000000012c327824ULL, 0x000fe200078e0209ULL,
0x000000631c1c7212ULL, 0x000fe200078efcffULL, 0x000000082c257824ULL, 0x000fe200078e00ffULL,
0x000000350200720cULL, 0x000fe20003f26070ULL, 0x000000011e1e7824ULL, 0x000fe200078e0239ULL,
0x0000000a1c1c7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000140367824ULL, 0x040fe200078e0209ULL,
0xfffffff825327812ULL, 0x000fe200078ee232ULL, 0x0000000840277824ULL, 0x000fe200078e00ffULL,
0x0000000b1d1d7c10ULL, 0x000fe200087fe4ffULL, 0x0000001002247836ULL, 0x000fc40000000000ULL,
0x0000000126267824ULL, 0x000fe200078e0239ULL, 0xfffffff827367812ULL, 0x000fe200078ee236ULL,
0x000001001e1e7825ULL, 0x000fe200078e00ffULL, 0x0000000324257819ULL, 0x040fe400000006ffULL,
0x000000352400720cULL, 0x040fe20003f86070ULL, 0x0000000124387824ULL, 0x000fe200078e0209ULL,
0x000000631e1e7212ULL, 0x000fe200078efcffULL, 0x000000012c2c7824ULL, 0x000fe400078e0239ULL,
0x0000010026267825ULL, 0x000fe200078e00ffULL, 0xfffffff825387812ULL, 0x000fc400078ee238ULL,
0x0000000a1e1e7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000124247824ULL, 0x000fe200078e0239ULL,
0x00000063262e7212ULL, 0x080fe200078efcffULL, 0x0000001802427836ULL, 0x000fe20000000000ULL,
0x0000000b1f1f7c10ULL, 0x000fe200087fe4ffULL, 0x000001002c2c7825ULL, 0x000fe200078e00ffULL,
0x0000000a2e2e7c10ULL, 0x000fe4000ffde0ffULL, 0x00000003422f7819ULL, 0x000fe200000006ffULL,
0x0000010024247825ULL, 0x000fe200078e00ffULL, 0x000000632c307212ULL, 0x000fc600078efcffULL,
0x0000000142347824ULL, 0x100fe200078e0209ULL, 0x00000063242c7212ULL, 0x000fe200078efcffULL,
0x00000001023a7824ULL, 0x000fe200078e0209ULL, 0x0000000a30307c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000140247824ULL, 0x100fe200078e0239ULL, 0xfffffff82f347812ULL, 0x000fe200078ee234ULL,
0x0000002002447836ULL, 0x000fe20000000000ULL, 0x0000000b272f7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000142337824ULL, 0x000fe200078e0239ULL, 0x0000000a2c2c7c10ULL, 0x000fe2000ffde0ffULL,
0x00000008443b7824ULL, 0x000fe200078e00ffULL, 0x00000007613a7812ULL, 0x000fc400078ef83aULL,
0x0000000b2d317c10ULL, 0x000fe400087fe4ffULL, 0x000000354000720cULL, 0x000fe20003f06070ULL,
0x0000001c02407836ULL, 0x000fe20000000000ULL, 0x0000000b252d7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000010024247825ULL, 0x000fc800078e00ffULL, 0x000000103a277824ULL, 0x000fe200078e025fULL,
0x0000006324267212ULL, 0x000fe200078efcffULL, 0x00000001403a7824ULL, 0x040fe200078e0209ULL,
0x0000000944247210ULL, 0x000fe20007ffe0ffULL, 0x0000000840377824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c277faeULL, 0x0003e2000c901c46ULL,
0x0000000a26267c10ULL, 0x000fe4000ffde0ffULL, 0x000000354200720cULL, 0x000fe40003f26070ULL,
0xfffffff8373a7812ULL, 0x000fe200078ee23aULL, 0x000000103c377824ULL, 0x100fe200078e025fULL,
0xfffffff83b3c7812ULL, 0x000fe200078ee224ULL, 0x00000010323b7824ULL, 0x000fc400078e025fULL,
0x0000000140327824ULL, 0x100fe200078e0239ULL, 0x000000001e377faeULL, 0x0005e2000d101c46ULL,
0x00000100331c7825ULL, 0x002fe200078e00ffULL, 0x0000000b25277c10ULL, 0x000fe4000b7fe4ffULL,
0x00000000303b7faeULL, 0x0003e2000d901c46ULL, 0x0000010032327825ULL, 0x000fe200078e00ffULL,
0x000000631c1c7212ULL, 0x000fe400078efcffULL, 0x000000354000720cULL, 0x000fe20003f46070ULL,
0x0000000144247824ULL, 0x000fe200078e0239ULL, 0x0000000a1c1c7c10ULL, 0x000fe2000ffde0ffULL,
0x0000003002407836ULL, 0x000fe20000000000ULL, 0x00000063321e7212ULL, 0x004fe200078efcffULL,
0x000000103e377824ULL, 0x000fe200078e025fULL, 0x0000000b1d1d7c10ULL, 0x000fe2000b7fe4ffULL,
0x00000024023e7836ULL, 0x000fe20000000000ULL, 0x0000000a1e1e7c10ULL, 0x000fe2000ffde0ffULL,
0x0000010024247825ULL, 0x000fe200078e00ffULL, 0x000000002e377faeULL, 0x0005e2000e901c46ULL,
0x000000354400720cULL, 0x000fc40003f66070ULL, 0x000000083e327824ULL, 0x040fe200078e00ffULL,
0x000000093e317210ULL, 0x002fe20007ffe0ffULL, 0x000000013e307824ULL, 0x040fe200078e0239ULL,
0x000000353e00720cULL, 0x000fe40003fa6070ULL, 0xfffffff8323e7812ULL, 0x000fe200078ee231ULL,
0x0000001038317824ULL, 0x000fe200078e025fULL, 0x0000000b331f7c10ULL, 0x000fe2000b7fe4ffULL,
0x00000100302e7825ULL, 0x004fe200078e00ffULL, 0x0000006324247212ULL, 0x000fe400078efcffULL,
0x000000002c317faeULL, 0x0003e2000e101c46ULL, 0x0000005f36377211ULL, 0x000fe200078e20ffULL,
0x0000002802307836ULL, 0x000fe20000000000ULL, 0x0000000a24247c10ULL, 0x000fe2000ffde0ffULL,
0x0000002c02367836ULL, 0x000fe20000000000ULL, 0x000000632e2e7212ULL, 0x000fe200078efcffULL,
0x0000000130327824ULL, 0x040fe200078e0209ULL, 0x000000353000720cULL, 0x040fe20003f86070ULL,
0x0000000830337824ULL, 0x040fe200078e00ffULL, 0x0000000b25257c10ULL, 0x000fe2000b7fe4ffULL,
0x0000000130307824ULL, 0x000fe200078e0239ULL, 0x0000000a2e2e7c10ULL, 0x000fe2000ffde0ffULL,
0x0000000136387824ULL, 0x000fe200078e0209ULL, 0x0000000026377faeULL, 0x0005e2000c101c46ULL,
0x00000100302c7825ULL, 0x002fe200078e00ffULL, 0xfffffff833327812ULL, 0x000fc400078ee232ULL,
0x000000353600720cULL, 0x040fe20003f06070ULL, 0x0000000136307824ULL, 0x000fe200078e0239ULL,
0x000000632c2c7212ULL, 0x080fe200078efcffULL, 0x00000008363b7824ULL, 0x000fe200078e00ffULL,
0x0000000b2f2f7c10ULL, 0x000fe2000b7fe4ffULL, 0x0000010030307825ULL, 0x000fe200078e00ffULL,
0x0000000a2c2c7c10ULL, 0x000fe4000ffde0ffULL, 0xfffffff83b367812ULL, 0x000fe200078ee238ULL,
0x0000001034377824ULL, 0x004fe200078e025fULL, 0x0000006330307212ULL, 0x000fe200078efcffULL,
0x0000000140337824ULL, 0x000fe200078e0239ULL, 0x0000000b2d2d7c10ULL, 0x000fe2000b7fe4ffULL,
0x0000003402387836ULL, 0x000fe20000000000ULL, 0x000000001c377faeULL, 0x0003e2000c901c46ULL,
0x0000010033267825ULL, 0x000fe200078e00ffULL, 0x0000000940337210ULL, 0x000fc40007ffe0ffULL,
0x0000000a30307c10ULL, 0x000fe2000ffde0ffULL, 0x0000000840347824ULL, 0x000fe200078e00ffULL,
0x0000006326267212ULL, 0x000fe200078efcffULL, 0x000000103a3b7824ULL, 0x100fe200078e025fULL,
0x0000000b31317c10ULL, 0x000fe2000b7fe4ffULL, 0x00000038023a7836ULL, 0x000fe20000000000ULL,
0xfffffff834347812ULL, 0x000fe200078ee233ULL, 0x000000103e3d7824ULL, 0x000fe200078e025fULL,
0x0000000a26267c10ULL, 0x000fe2000ffde0ffULL, 0x00000001381c7824ULL, 0x002fe200078e0239ULL,
0x000000001e3b7faeULL, 0x0003e2000d101c46ULL, 0x000000103c377824ULL, 0x000fe200078e025fULL,
0x0000003c023c7810ULL, 0x000fe20007ffe0ffULL, 0x000001001c1c7825ULL, 0x000fe200078e00ffULL,
0x0000000b27277c10ULL, 0x000fc4000b7fe4ffULL, 0x0000000024377faeULL, 0x0005e2000d901c46ULL,
0x000000013a337824ULL, 0x000fe200078e0239ULL, 0x000000631c1c7212ULL, 0x000fe400078efcffULL,
0x000000002e3d7faeULL, 0x0007e2000e901c46ULL, 0x000000354000720cULL, 0x080fe20003f26070ULL,
0x00000100331e7825ULL, 0x002fe200078e00ffULL, 0x0000000a1c1c7c10ULL, 0x000fe4000ffde0ffULL,
0x000000353800720cULL, 0x080fe20003fa6070ULL, 0x000000013c337824ULL, 0x000fe200078e0209ULL,
0x000000353a00720cULL, 0x080fe20003f66070ULL, 0x000000013c247824ULL, 0x044fe200078e0239ULL,
0x000000353c00720cULL, 0x000fe20003f46070ULL, 0x0000000138357824ULL, 0x000fe200078e0209ULL,
0x000000631e1e7212ULL, 0x000fe200078efcffULL, 0x0000010024247825ULL, 0x000fe200078e00ffULL,
0x0000000b1d1d7c10ULL, 0x000fc4000b7fe4ffULL, 0x000000033c3c7819ULL, 0x000fe200000006ffULL,
0x0000000838387824ULL, 0x000fe200078e00ffULL, 0x0000000a1e1e7c10ULL, 0x000fe2000ffde0ffULL,
0x000000013a2f7824ULL, 0x008fe200078e0209ULL, 0x0000006324247212ULL, 0x000fe200078efcffULL,
0x000000083a3a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8382e7812ULL, 0x000fe200078ee235ULL,
0x0000001034357824ULL, 0x100fe200078e025fULL, 0x0000000b1f1f7c10ULL, 0x000fe4000b7fe4ffULL,
0xfffffff83a387812ULL, 0x000fe200078ee22fULL, 0x00000010322f7824ULL, 0x100fe200078e025fULL,
0xfffffff83c3a7812ULL, 0x000fe200078ee233ULL, 0x0000001036337824ULL, 0x100fe200078e025fULL,
0x0000000a24247c10ULL, 0x000fe2000ffde0ffULL, 0x000000102e377824ULL, 0x100fe200078e025fULL,
0x000000002c2f7faeULL, 0x0003e2000e101c46ULL, 0x0000001038397824ULL, 0x100fe200078e025fULL,
0x0000000b25257c10ULL, 0x000fe2000b7fe4ffULL, 0x000000103a5f7824ULL, 0x000fe200078e025fULL,
0x0000000030337faeULL, 0x0003e8000c101c46ULL, 0x0000000026357faeULL, 0x0003e8000c901c46ULL,
0x000000001c377faeULL, 0x0003e8000e901c46ULL, 0x000000001e397faeULL, 0x0003e8000d901c46ULL,
0x00000000245f7faeULL, 0x0003e2000d101c46ULL, 0x0000000800c47947ULL, 0x000fea0003800000ULL,
0x0000000402267810ULL, 0x000fe20007ffe0ffULL, 0x0000001002247836ULL, 0x000fe20000000000ULL,
0x0000002402447810ULL, 0x000fe20007ffe0ffULL, 0x0000000c022c7836ULL, 0x000fe40000000000ULL,
0x00000008021e7836ULL, 0x000fe40000000000ULL, 0x0000000126737824ULL, 0x140fe200078e0209ULL,
0x000000092c587210ULL, 0x000fe20007ffe0ffULL, 0x00000008262e7824ULL, 0x000fe400078e00ffULL,
0x0000000124467824ULL, 0x000fc400078e0209ULL, 0x0000000824257824ULL, 0x000fe200078e00ffULL,
0xfffffff82e737812ULL, 0x000fe200078ee273ULL, 0x000000082c1f7824ULL, 0x000fe400078e00ffULL,
0x0000002002327836ULL, 0x000fe20000000000ULL, 0xfffffff825467812ULL, 0x000fe200078ee246ULL,
0x000000011e3e7824ULL, 0x040fe200078e0209ULL, 0xfffffff81f587812ULL, 0x000fe200078ee258ULL,
0x000000081e1d7824ULL, 0x000fe400078e00ffULL, 0x0000001c02367836ULL, 0x000fe20000000000ULL,
0x0000005f586f7211ULL, 0x000fe200078e20ffULL, 0x0000001802387836ULL, 0x000fe20000000000ULL,
0xfffffff81d3e7812ULL, 0x000fe200078ee23eULL, 0x00000014022e7836ULL, 0x000fc40000000000ULL,
0x00000001325a7824ULL, 0x140fe400078e0209ULL, 0x0000000832257824ULL, 0x000fe200078e00ffULL,
0x000000092e407210ULL, 0x000fe20007ffe0ffULL, 0x00000001367c7824ULL, 0x140fe400078e0209ULL,
0x00000008361f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8255a7812ULL, 0x000fe200078ee25aULL,
0x0000000138697824ULL, 0x040fe400078e0209ULL, 0x0000000838307824ULL, 0x000fe200078e00ffULL,
0xfffffff81f7c7812ULL, 0x000fe200078ee27cULL, 0x0000002c02347836ULL, 0x000fc40000000000ULL,
0x00000001021c7824ULL, 0x100fe200078e0209ULL, 0xfffffff830697812ULL, 0x000fe200078ee269ULL,
0x000000082e1d7824ULL, 0x000fe200078e00ffULL, 0x00000009343a7210ULL, 0x000fe20007ffe0ffULL,
0x0000002802427836ULL, 0x000fe20000000000ULL, 0x00000007611c7812ULL, 0x000fe200078ef81cULL,
0x00000030022d7836ULL, 0x000fe20000000000ULL, 0xfffffff81d407812ULL, 0x000fe200078ee240ULL,
0x0000000834257824ULL, 0x000fe400078e00ffULL, 0x00000001423c7824ULL, 0x000fc400078e0209ULL,
0x00000008421f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8253a7812ULL, 0x000fe200078ee23aULL,
0x000000012d307824ULL, 0x140fe200078e0209ULL, 0x0000003926257210ULL, 0x000fe20007ffe0ffULL,
0x000000082d277824ULL, 0x000fe200078e00ffULL, 0xfffffff81f3c7812ULL, 0x000fe200078ee23cULL,
0x0000000144617824ULL, 0x000fe200078e0209ULL, 0x0000005f3a597211ULL, 0x000fe200078e20ffULL,
0x00000008441d7824ULL, 0x000fe200078e00ffULL, 0xfffffff827307812ULL, 0x000fe200078ee230ULL,
0x0000003802337836ULL, 0x000fe20000000000ULL, 0x0000003944447210ULL, 0x000fe20007ffe0ffULL,
0x0000003402317836ULL, 0x000fe20000000000ULL, 0xfffffff81d617812ULL, 0x000fe200078ee261ULL,
0x0000003c023b7836ULL, 0x000fc40000000000ULL, 0x00000001021f7824ULL, 0x100fe400078e0239ULL,
0x000000012e267824ULL, 0x100fe400078e0239ULL, 0x0000000124277824ULL, 0x100fe400078e0239ULL,
0x0000000132377824ULL, 0x100fe400078e0239ULL, 0x00000001342f7824ULL, 0x100fe400078e0239ULL,
0x000000012d2e7824ULL, 0x100fe200078e0239ULL, 0x00000009332d7210ULL, 0x000fe20007ffe0ffULL,
0x000000011e1d7824ULL, 0x000fc400078e0239ULL, 0x000000012c2c7824ULL, 0x100fe400078e0239ULL,
0x0000000138387824ULL, 0x100fe400078e0239ULL, 0x0000000136367824ULL, 0x100fe400078e0239ULL,
0x0000000142427824ULL, 0x100fe400078e0239ULL, 0x0000000131327824ULL, 0x040fe400078e0239ULL,
0x0000000131247824ULL, 0x000fc400078e0209ULL, 0x0000000831457824ULL, 0x000fe400078e00ffULL,
0x0000000133357824ULL, 0x100fe400078e0239ULL, 0x000000013b347824ULL, 0x000fe200078e0239ULL,
0xfffffff845457812ULL, 0x000fe200078ee224ULL, 0x0000000833337824ULL, 0x000fe400078e00ffULL,
0x000000013b317824ULL, 0x040fe400078e0209ULL, 0x000000083b397824ULL, 0x000fe200078e00ffULL,
0xfffffff8332d7812ULL, 0x000fe200078ee22dULL, 0x000001001f1e7825ULL, 0x000fc600078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee231ULL, 0x0000010025247825ULL, 0x000fe200078e00ffULL,
0x000000631e317212ULL, 0x000fc600078efcffULL, 0x0000001030477824ULL, 0x100fe200078e025fULL,
0x0000000a31307c10ULL, 0x000fe2000ff1e0ffULL, 0x00000010406b7824ULL, 0x100fe200078e025fULL,
0x0000006324407212ULL, 0x000fe200078efcffULL, 0x000000102d437824ULL, 0x000fe200078e025fULL,
0x0000000b1f317c10ULL, 0x000fe200087fe4ffULL, 0x000001002c2c7825ULL, 0x000fe200078e00ffULL,
0x0000000a40407c10ULL, 0x000fc6000ff1e0ffULL, 0x000000103c5b7824ULL, 0x100fe200078e025fULL,
0x000000632c3c7212ULL, 0x080fe200078efcffULL, 0x000000101c337824ULL, 0x100fe200078e025fULL,
0x0000000b25417c10ULL, 0x000fe200087fe4ffULL, 0x00000100271e7825ULL, 0x000fe200078e00ffULL,
0x0000000a3c3c7c10ULL, 0x000fe4000ff1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030337faeULL, 0x0003e2000b901c46ULL, 0x000001001d1c7825ULL, 0x000fe200078e00ffULL,
0x000000631e3a7212ULL, 0x080fe400078efcffULL, 0x0000000b2d3d7c10ULL, 0x000fe200087fe4ffULL,
0x000000103e717824ULL, 0x000fe200078e025fULL, 0x000000631c3e7212ULL, 0x000fe200078efcffULL,
0x0000010026267825ULL, 0x000fe200078e00ffULL, 0x0000000a3a3a7c10ULL, 0x000fc4000ff1e0ffULL,
0x0000000a3e3e7c10ULL, 0x000fe2000ff3e0ffULL, 0x0000010038247825ULL, 0x000fe200078e00ffULL,
0x0000006326387212ULL, 0x080fe400078efcffULL, 0x0000000b1f3b7c10ULL, 0x000fe200087fe4ffULL,
0x00000100371e7825ULL, 0x000fe200078e00ffULL, 0x0000000b1d3f7c10ULL, 0x000fe40008ffe4ffULL,
0x0000000a38387c10ULL, 0x000fe2000ff1e0ffULL, 0x00000100361c7825ULL, 0x000fe200078e00ffULL,
0x0000006324367212ULL, 0x000fc400078efcffULL, 0x000000631e1e7212ULL, 0x080fe200078efcffULL,
0x0000001073737824ULL, 0x100fe200078e025fULL, 0x0000000a36367c10ULL, 0x000fe2000ff3e0ffULL,
0x00000010466d7824ULL, 0x100fe200078e025fULL, 0x000000631c1c7212ULL, 0x080fe200078efcffULL,
0x0000001069697824ULL, 0x100fe200078e025fULL, 0x0000000b25377c10ULL, 0x000fe20008ffe4ffULL,
0x000000107c677824ULL, 0x100fe200078e025fULL, 0x0000000a1c1c7c10ULL, 0x000fe2000ff5e0ffULL,
0x000000105a657824ULL, 0x100fe200078e025fULL, 0x0000000040737faeULL, 0x0005e2000b901c46ULL,
0x0000001061617824ULL, 0x100fe200078e025fULL, 0x0000000b1d1d7c10ULL, 0x000fe200097fe4ffULL,
0x0000001045457824ULL, 0x100fe200078e025fULL, 0x000000003e717faeULL, 0x0005e2000b901c46ULL,
0x00000010395f7824ULL, 0x000fe200078e025fULL, 0x0000000b27397c10ULL, 0x000fe200087fe4ffULL,
0x0000010042267825ULL, 0x000fe200078e00ffULL, 0x0000000a1e1e7c10ULL, 0x000fe2000ff1e0ffULL,
0x000000003c6f7faeULL, 0x0005e4000b901c46ULL, 0x000001002f2c7825ULL, 0x000fe200078e00ffULL,
0x0000006326267212ULL, 0x080fe200078efcffULL, 0x000000003a6d7faeULL, 0x0005e2000b901c46ULL,
0x0000000b1f1f7c10ULL, 0x000fe200087fe4ffULL, 0x000001002e2e7825ULL, 0x000fe200078e00ffULL,
0x0000000a26267c10ULL, 0x000fe2000ff1e0ffULL, 0x00000000386b7faeULL, 0x0005e2000b901c46ULL,
0x000000632c2c7212ULL, 0x080fe200078efcffULL, 0x0000010044247825ULL, 0x000fe200078e00ffULL,
0x000000632e2e7212ULL, 0x080fe200078efcffULL, 0x0000000036697faeULL, 0x0005e2000b901c46ULL,
0x0000000b27277c10ULL, 0x000fe200087fe4ffULL, 0x0000010032327825ULL, 0x002fe200078e00ffULL,
0x0000006324247212ULL, 0x080fe200078efcffULL, 0x000000001c677faeULL, 0x0005e2000b901c46ULL,
0x0000000a2e2e7c10ULL, 0x000fe2000ff1e0ffULL, 0x0000010035307825ULL, 0x000fe200078e00ffULL,
0x0000000a24247c10ULL, 0x000fe2000ff3e0ffULL, 0x000000001e657faeULL, 0x0005e2000b901c46ULL,
0x0000006332327212ULL, 0x000fe200078efcffULL, 0x0000010034347825ULL, 0x000fe200078e00ffULL,
0x0000000b2f2f7c10ULL, 0x000fc400087fe4ffULL, 0x0000000b25257c10ULL, 0x000fe40008ffe4ffULL,
0x0000000a32327c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000a2c2c7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000000024617faeULL, 0x0005e2000b901c46ULL, 0x0000006330307212ULL, 0x080fe400078efcffULL,
0x0000006334347212ULL, 0x000fe200078efcffULL, 0x00000000265b7faeULL, 0x0005e2000b901c46ULL,
0x0000000b33337c10ULL, 0x000fc400087fe4ffULL, 0x0000000b2d2d7c10ULL, 0x000fe40008ffe4ffULL,
0x0000000a30307c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000a34347c10ULL, 0x000fe2000ff3e0ffULL,
0x000000002c597faeULL, 0x0005e2000b901c46ULL, 0x0000000b31317c10ULL, 0x000fe400087fe4ffULL,
0x0000000b35357c10ULL, 0x000fe20008ffe4ffULL, 0x000000002e477faeULL, 0x0005e8000b901c46ULL,
0x0000000032457faeULL, 0x0005e8000b901c46ULL, 0x0000000030437faeULL, 0x0005e8000b901c46ULL,
0x00000000345f7faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000085d1c7836ULL, 0x006fe40000000000ULL, 0x000000104f1d7824ULL, 0x040fe400078e00ffULL,
0x0000001078387824ULL, 0x100fe400078e024dULL, 0x00000010763c7824ULL, 0x100fe200078e024dULL,
0xfffffff01d1c7812ULL, 0x000fe200078ee21cULL, 0x00000010722c7824ULL, 0x000fe400078e024dULL,
0x0000000a5d247836ULL, 0x000fe20000000000ULL, 0x000000071c347211ULL, 0x000fe200078e20ffULL,
0x000000104f257824ULL, 0x000fc400078e00ffULL, 0x00000010741c7824ULL, 0x100fe400078e024dULL,
0x0000001070307824ULL, 0x100fe200078e024dULL, 0xfffffff025247812ULL, 0x000fe200078ee224ULL,
0x000000106a6a7824ULL, 0x100fe400078e024dULL, 0x000000106c6c7824ULL, 0x000fe400078e024dULL,
0x0000001024247824ULL, 0x000fe200078e0207ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000003838783bULL, 0x000fe20000000200ULL, 0x0000001060587824ULL, 0x100fe400078e024dULL,
0x000000104f407824ULL, 0x000fe200078e00ffULL, 0x000000003434783bULL, 0x000e620000000200ULL,
0x0000001064447824ULL, 0x000fc600078e024dULL, 0x000000003c3c783bULL, 0x000ea80000000200ULL,
0x000000002c2c783bULL, 0x000ee80000000200ULL, 0x000000001c1c783bULL, 0x000f280000000200ULL,
0x000000003030783bULL, 0x000fe80000000200ULL, 0x000000002424783bULL, 0x000f680000000200ULL,
0x000000005858783bULL, 0x000fe80000000200ULL, 0x000000004444783bULL, 0x000fe20000000200ULL,
0x000000383420723cULL, 0x002fec0000001820ULL, 0x0000003a3454723cULL, 0x000fe20000001854ULL,
0x0000004d6e387211ULL, 0x000fca00078e20ffULL, 0x0000003c3450723cULL, 0x004fe20000001850ULL,
0x000000003838783bULL, 0x000e6a0000000200ULL, 0x0000002c3418723cULL, 0x008fe20000001818ULL,
0x000000104f3c7824ULL, 0x000fca00078e00ffULL, 0x0000001c3410723cULL, 0x010fe20000001810ULL,
0x0000000c5d2d7836ULL, 0x000fe20000000000ULL, 0x0000000e5d5d7810ULL, 0x000fe20007ffe0ffULL,
0x00000010682c7824ULL, 0x000fc600078e024dULL, 0xfffffff03c3c7812ULL, 0x000fe200078ee22dULL,
0x0000001e341c723cULL, 0x000fe20000001814ULL, 0xfffffff040407812ULL, 0x000fe200078ee25dULL,
0x000000006a14783bULL, 0x000ea40000000200ULL, 0x000000103c3c7824ULL, 0x100fe400078e0207ULL,
0x0000003e340c723cULL, 0x000fe2000000180cULL, 0x0000001040407824ULL, 0x000fc600078e0207ULL,
0x000000003c3c783bULL, 0x000fe40000000200ULL, 0x0000002e3428723cULL, 0x000fe40000001828ULL,
0x000000002c2c783bULL, 0x000ee80000000200ULL, 0x000000302434723cULL, 0x020fe20000001820ULL,
0x000000004040783bULL, 0x000fe80000000200ULL, 0x000000006c20783bULL, 0x000f220000000200ULL,
0x000000382450723cULL, 0x002fe20000001850ULL, 0x0000001066307824ULL, 0x000fca00078e024dULL,
0x000000322454723cULL, 0x000fe20000001854ULL, 0x0000001062387824ULL, 0x100fe200078e024dULL,
0x000000003030783bULL, 0x000e680000000200ULL, 0x0000003a240c723cULL, 0x000fe2000000180cULL,
0x000000003838783bULL, 0x000f6a0000000200ULL, 0x000000142410723cULL, 0x004fec0000001810ULL,
0x00000016241c723cULL, 0x000fe2000000181cULL, 0x000000105e147824ULL, 0x000fca00078e024dULL,
0x0000002c2418723cULL, 0x008fe20000001818ULL, 0x000000001414783bULL, 0x000eaa0000000200ULL,
0x0000002e2428723cULL, 0x000fec0000001828ULL, 0x000000203c34723cULL, 0x010fe20000001834ULL,
0x000000105c247824ULL, 0x000fca00078e024dULL, 0x000000223c54723cULL, 0x000fe20000001854ULL,
0x0000004d4e207211ULL, 0x000fe200078e20ffULL, 0x000000002424783bULL, 0x000ee80000000200ULL,
0x000000303c50723cULL, 0x002fe20000001850ULL, 0x000000002020783bULL, 0x000e6a0000000200ULL,
0x000000323c0c723cULL, 0x000fec000000180cULL, 0x000000383c10723cULL, 0x020fec0000001810ULL,
0x0000003a3c1c723cULL, 0x000fec000000181cULL, 0x000000583c18723cULL, 0x000fec0000001818ULL,
0x0000005a3c28723cULL, 0x000fec0000001828ULL, 0x000000144050723cULL, 0x004fec0000001850ULL,
0x000000444034723cULL, 0x000fe20000001834ULL, 0x00000001ff157424ULL, 0x000fca00078e00ffULL,
0x000000464054723cULL, 0x000fe20000001854ULL, 0x01b68815481479a7ULL, 0x000eaa000850003fULL,
0x00000016400c723cULL, 0x000fec000000180cULL, 0x000000244010723cULL, 0x008fe20000001810ULL,
0x3db504f350507820ULL, 0x000fe20000410000ULL, 0x3db504f351517820ULL, 0x000fe20000410000ULL,
0x3db504f352527820ULL, 0x000fe20000410000ULL, 0x3db504f353537820ULL, 0x000fc40000410000ULL,
0x00000026401c723cULL, 0x000fe2000000181cULL, 0x3db504f335357820ULL, 0x000fe20000410000ULL,
0x3db504f336367820ULL, 0x000fe20000410000ULL, 0x3db504f337377820ULL, 0x000fc60000410000ULL,
0x000000204018723cULL, 0x002fe20000001818ULL, 0x3db504f354547820ULL, 0x000fe20000410000ULL,
0x3db504f355557820ULL, 0x000fe20000410000ULL, 0x3db504f356567820ULL, 0x000fe20000410000ULL,
0x3db504f357577820ULL, 0x000fe40000410000ULL, 0x000000224028723cULL, 0x000fe20000001828ULL,
0x3db504f334217820ULL, 0x000fe20000410000ULL, 0x3db504f30c207820ULL, 0x000fe20000410000ULL,
0x3db504f30f247820ULL, 0x000fc60000410000ULL, 0x3db504f310257820ULL, 0x000fe20000410000ULL,
0x3db504f30d237820ULL, 0x000fe20000410000ULL, 0x3db504f30e227820ULL, 0x000fe20000410000ULL,
0x3db504f311267820ULL, 0x000fe20000410000ULL, 0x3db504f312277820ULL, 0x000fe20000410000ULL,
0x3db504f3132c7820ULL, 0x000fe20000410000ULL, 0x3db504f31c1c7820ULL, 0x000fe20000410000ULL,
0x3db504f31d1d7820ULL, 0x000fe20000410000ULL, 0x3db504f31e1e7820ULL, 0x000fe20000410000ULL,
0x3db504f31f1f7820ULL, 0x000fc60000410000ULL, 0x3db504f3182d7820ULL, 0x000fe20000410000ULL,
0x3db504f3192e7820ULL, 0x000fe20000410000ULL, 0x3db504f31a1a7820ULL, 0x000fe20000410000ULL,
0x3db504f31b1b7820ULL, 0x000fc60000410000ULL, 0x3db504f328287820ULL, 0x000fe20000410000ULL,
0x3db504f329297820ULL, 0x000fe20000410000ULL, 0x3db504f32a2f7820ULL, 0x000fe20000410000ULL,
0x3db504f32b2b7820ULL, 0x000fe20000410000ULL, 0x00000000000c7805ULL, 0x000fe20000015200ULL,
0x01b68815480075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff107224ULL, 0x000fce00078e00ffULL, 0x000000101000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c117210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000110e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000110107836ULL, 0x000fce0000000000ULL, 0x01b68815480075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000004090c7824ULL, 0x000fe200078e00ffULL,
0x0000004b4c00720cULL, 0x000fe20003f06070ULL, 0x000000800a0d7824ULL, 0x000fc600078e0207ULL,
0xfffffff00c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0d2a7210ULL, 0x000fca0007ffe0ffULL,
0x01b400002a0c7984ULL, 0x0002a20000000c00ULL, 0x0000001000c08947ULL, 0x000fea0003800000ULL,
0x0000000209307824ULL, 0x040fe200078e00ffULL, 0x0000004906327248ULL, 0x000fe20007fe0000ULL,
0x00008c00ff107b82ULL, 0x000ee20000000a00ULL, 0x0000000009127211ULL, 0x000fe200078ff0ffULL,
0x0000860000097ab9ULL, 0x000fe20000000800ULL, 0x0000000630307812ULL, 0x000fe200078ec0ffULL,
0x0000000132327824ULL, 0x000fe200078e0a49ULL, 0x00008400000a7ab9ULL, 0x000fe20000000800ULL,
0x00000009ff137c19ULL, 0x000fe20008011612ULL, 0x0000000812127836ULL, 0x000fe40000000000ULL,
0x0000000830157c36ULL, 0x000fe20008000000ULL, 0x0000000513137c48ULL, 0x000fe2000bfe0000ULL,
0x000000ffff4c7224ULL, 0x000fe200078e0a32ULL, 0x00000009ff147c19ULL, 0x000fe20008011612ULL,
0x0000000a30317c36ULL, 0x000fe20008000000ULL, 0x000000321500720cULL, 0x000fe20003f26070ULL,
0x0000000413597c24ULL, 0x000fe2000f8e02ffULL, 0x0000000515157e46ULL, 0x000fc4000b80004cULL,
0x000000323100720cULL, 0x000fe40003f06070ULL, 0x0000000531387e46ULL, 0x000fe4000b80004cULL,
0x00000004ff157819ULL, 0x000fe40000011615ULL, 0x000000ff38387207ULL, 0x000fe40000000000ULL,
0x000000ff15127207ULL, 0x000fe40000800000ULL, 0x0000001030397812ULL, 0x000fc400078efcffULL,
0x0000005938197211ULL, 0x000fe200078fe0ffULL, 0x0000000159177824ULL, 0x000fe200078e0212ULL,
0x0000000514147c48ULL, 0x000fe2000bfe0000ULL, 0x00000008393f7c36ULL, 0x000fe40008000000ULL,
0x0000000a39337c36ULL, 0x000fe40008000000ULL, 0x0000000219187825ULL, 0x008fc800078e0010ULL,
0x0000000217167825ULL, 0x000fe200078e0010ULL, 0x000000053f3e7e46ULL, 0x000fe2000b80004cULL,
0x00000006183b7981ULL, 0x000ee4000c1e9500ULL, 0x00000004144f7c24ULL, 0x000fe2000f8e02ffULL,
0x000000323300720cULL, 0x080fe20003f06070ULL, 0x0000000616347981ULL, 0x0008e2000c1e9500ULL,
0x00000005333c7e46ULL, 0x000fe4000b80004cULL, 0x000000323f00720cULL, 0x000fe40003f26070ULL,
0x00000020303f7812ULL, 0x000fc400078efcffULL, 0x0000004f38137211ULL, 0x000fe400078fe0ffULL,
0x0000004f12157210ULL, 0x000fe40007ffe0ffULL, 0x00000004ff3e7819ULL, 0x000fe4000001163eULL,
0x000000ff3c3c7207ULL, 0x000fe20000000000ULL, 0x0000000a3f437c36ULL, 0x000fe20008000000ULL,
0x000000ff3e167207ULL, 0x012fe20000800000ULL, 0x0000000213127825ULL, 0x000fe200078e0010ULL,
0x000000593c177211ULL, 0x000fc600078fe0ffULL, 0x0000000215147825ULL, 0x000fe200078e0010ULL,
0x000000324300720cULL, 0x000fe20003f06070ULL, 0x00000006123a7981ULL, 0x0042a2000c1e9500ULL,
0x0000000543467e46ULL, 0x000fe2000b80004cULL, 0x000000083f477c36ULL, 0x000fe40008000000ULL,
0x0000000159197824ULL, 0x000fe200078e0216ULL, 0x00000006143d7981ULL, 0x0008a2000c1e9500ULL,
0x000000ff46467207ULL, 0x000fe20000000000ULL, 0x0000000217127825ULL, 0x002fe200078e0010ULL,
0x0000004f3c177211ULL, 0x000fc400078fe0ffULL, 0x0000000547427e46ULL, 0x000fe2000b80004cULL,
0x0000000219147825ULL, 0x010fe200078e0010ULL, 0x00000006123e7981ULL, 0x000322000c1e9500ULL,
0x000000324700720cULL, 0x000fe40003f26070ULL, 0x0000000116197824ULL, 0x000fe200078e024fULL,
0x0000003030477812ULL, 0x000fe200078efcffULL, 0x0000000217167825ULL, 0x000fe200078e0010ULL,
0x00000004ff427819ULL, 0x000fe20000011642ULL, 0x0000000614417981ULL, 0x000f22000c1e9500ULL,
0x0000005946137211ULL, 0x002fe200078fe0ffULL, 0x0000000219187825ULL, 0x100fe200078e0010ULL,
0x000000ff42447207ULL, 0x000fe20000800000ULL, 0x0000000616407981ULL, 0x000364000c1e9500ULL,
0x0000000213127825ULL, 0x000fc400078e0010ULL, 0x0000000618457981ULL, 0x000364000c1e9500ULL,
0x00000008475b7c36ULL, 0x000fe40008000000ULL, 0x0000000612427981ULL, 0x000362000c1e9500ULL,
0x0000000a47497c36ULL, 0x000fe20008000000ULL, 0x0000004f46177211ULL, 0x002fe200078fe0ffULL,
0x0000000159157824ULL, 0x000fe200078e0244ULL, 0x0000004f44197210ULL, 0x000fe40007ffe0ffULL,
0x000000055b127e46ULL, 0x000fc6000b80004cULL, 0x0000000219187825ULL, 0x100fe200078e0010ULL,
0x000000324900720cULL, 0x080fe40003f06070ULL, 0x00000005494c7e46ULL, 0x000fe2000b80004cULL,
0x0000000215147825ULL, 0x000fe200078e0010ULL, 0x000000325b00720cULL, 0x000fe20003f26070ULL,
0x0000000618197981ULL, 0x000f62000c1e9500ULL, 0x00000004ff127819ULL, 0x000fe20000011612ULL,
0x0000000217167825ULL, 0x000fe200078e0010ULL, 0x000000ff4c4c7207ULL, 0x000fe20000000000ULL,
0x00000006144d7981ULL, 0x000362000c1e9500ULL, 0x000000ff124e7207ULL, 0x000fc60000800000ULL,
0x0000000616447981ULL, 0x000362000c1e9500ULL, 0x000000594c137211ULL, 0x000fe200078fe0ffULL,
0x0000000159157824ULL, 0x002fc800078e024eULL, 0x0000000213127825ULL, 0x000fc800078e0010ULL,
0x0000000215147825ULL, 0x000fe400078e0010ULL, 0x0000000612127981ULL, 0x000f62000c1e9500ULL,
0x0000004f4c177211ULL, 0x000fc600078fe0ffULL, 0x0000000614157981ULL, 0x000362000c1e9500ULL,
0x000000014e597824ULL, 0x000fe400078e024fULL, 0x0000000217167825ULL, 0x000fc800078e0010ULL,
0x0000000259107825ULL, 0x000fe400078e0010ULL, 0x0000000616167981ULL, 0x000368000c1e9500ULL,
0x00000006104f7981ULL, 0x000362000c1e9500ULL, 0xfffffff038387812ULL, 0x000fe200078ec0ffULL,
0x00000001ff187424ULL, 0x000fc800078e00ffULL, 0x0000000132387824ULL, 0x000fe200078e0238ULL,
0x0000000130737812ULL, 0x000fc600078efcffULL, 0x0000000131147824ULL, 0x102fe200078e0a38ULL,
0x0000000830717812ULL, 0x040fe400078efcffULL, 0x00000009306f7812ULL, 0x000fe400078efcffULL,
0x0000001418147219ULL, 0x000fe200000006ffULL, 0x0000000a73797c36ULL, 0x000fe20008000000ULL,
0x0000000a6f757c10ULL, 0x000fe2000fffe0ffULL, 0x0000000a71777c36ULL, 0x000fe20008000000ULL,
0xfffffff03c4e7812ULL, 0x000fe200078ec0ffULL, 0x00000001793c7824ULL, 0x100fe200078e0a38ULL,
0xfffffff046587812ULL, 0x000fe200078ec0ffULL, 0x0000000177467824ULL, 0x100fe200078e0a38ULL,
0xfffffff04c5a7812ULL, 0x000fe200078ec0ffULL, 0x00000001754c7824ULL, 0x000fe200078e0a38ULL,
0x0000001130677812ULL, 0x000fc400078efcffULL, 0x0000003c18387219ULL, 0x000fe400000006ffULL,
0x0000001830657812ULL, 0x000fe400078efcffULL, 0x00000046183c7219ULL, 0x040fe400000006ffULL,
0x0000004c18467219ULL, 0x000fe200000006ffULL, 0x00000001324e7824ULL, 0x000fe200078e024eULL,
0x0000001930637812ULL, 0x000fe200078efcffULL, 0x0000000a676d7c36ULL, 0x000fe20008000000ULL,
0x0000005a32707210ULL, 0x000fe20007ffe0ffULL, 0x0000000a656b7c36ULL, 0x000fc40008000000ULL,
0x0000000a63697c36ULL, 0x000fe40008000000ULL, 0x00000001335a7824ULL, 0x100fe400078e0a4eULL,
0x000000016d5e7824ULL, 0x100fe400078e0a4eULL, 0x000000016b607824ULL, 0x100fe400078e0a4eULL,
0x0000000169667824ULL, 0x000fe200078e0a4eULL, 0x0000005a184e7219ULL, 0x040fe400000006ffULL,
0x0000005e185a7219ULL, 0x000fc400000006ffULL, 0x00000060185e7219ULL, 0x000fe200000006ffULL,
0x0000000132587824ULL, 0x000fc800078e0258ULL, 0x0000000143627824ULL, 0x000fe200078e0a58ULL,
0x00000021305d7812ULL, 0x040fe400078efcffULL, 0x00000028305b7812ULL, 0x040fe400078efcffULL,
0x0000002930597812ULL, 0x000fe400078efcffULL, 0x0000006618667219ULL, 0x040fe400000006ffULL,
0x0000006218627219ULL, 0x000fe200000006ffULL, 0x0000000a5d617c36ULL, 0x000fc40008000000ULL,
0x0000000a5b5f7c36ULL, 0x000fe40008000000ULL, 0x0000000a597b7c36ULL, 0x000fe40008000000ULL,
0x00000001616e7824ULL, 0x100fe400078e0a58ULL, 0x000000015f6a7824ULL, 0x000fe200078e0a58ULL,
0x0000007b586c7210ULL, 0x000fe20007ffe1ffULL, 0x0000000149687824ULL, 0x000fe200078e0a70ULL,
0x0000003130177812ULL, 0x040fe400078efcffULL, 0x0000003830137812ULL, 0x000fc400078efcffULL,
0x0000003930117812ULL, 0x000fe400078efcffULL, 0x0000006e18607219ULL, 0x040fe400000006ffULL,
0x0000006a186a7219ULL, 0x040fe400000006ffULL, 0x0000006c186c7219ULL, 0x040fe400000006ffULL,
0x0000006818687219ULL, 0x000fe200000006ffULL, 0x0000000a177d7c36ULL, 0x000fe20008000000ULL,
0x0000000a13107c10ULL, 0x000fe2000fffe0ffULL, 0x0000000a114c7c36ULL, 0x000fc40008000000ULL,
0x000000017d647824ULL, 0x100fe400078e0a70ULL, 0x00000001105c7824ULL, 0x100fe400078e0a70ULL,
0x000000014c587824ULL, 0x000fe200078e0a70ULL, 0x0000006418647219ULL, 0x040fe400000006ffULL,
0x0000005c185c7219ULL, 0x040fe400000006ffULL, 0x0000005818587219ULL, 0x000fe400000006ffULL,
0x000054103b3b7816ULL, 0x008fc80000000034ULL, 0x0000003b14ff7212ULL, 0x000fc8000780c0ffULL,
0x000000323100720cULL, 0x000fc80000701470ULL, 0x000000323000720cULL, 0x000fc80000701070ULL,
0xff80000021217808ULL, 0x000fe40000000000ULL, 0x000054103a3d7816ULL, 0x004fc8000000003dULL,
0x0000003d14ff7212ULL, 0x080fe4000788c0ffULL, 0x0000003d3cff7212ULL, 0x080fe400078cc0ffULL,
0x0000003d46ff7212ULL, 0x000fe4000780c0ffULL, 0x000000323100720cULL, 0x080fe40002781470ULL,
0x000000327700720cULL, 0x080fe400037c1470ULL, 0x000000327500720cULL, 0x000fc40000701470ULL,
0x0000003b46ff7212ULL, 0x000fe4000782c0ffULL, 0x000000323000720cULL, 0x080fe40002781070ULL,
0x000000327100720cULL, 0x080fe400037c1070ULL, 0x000000326f00720cULL, 0x000fe40000701070ULL,
0x000054103e417816ULL, 0x010fe40000000041ULL, 0x0000541040457816ULL, 0x020fc40000000045ULL,
0x000000327500720cULL, 0x000fe40000f21470ULL, 0xff80000036367808ULL, 0x000fe40002000000ULL,
0xff80000056567808ULL, 0x000fe40003000000ULL, 0xff80000057577808ULL, 0x000fe40000000000ULL,
0x0000003b38ff7212ULL, 0x080fe4000786c0ffULL, 0x0000003b3cff7212ULL, 0x000fc4000784c0ffULL,
0x0000003d38ff7212ULL, 0x000fe400078ac0ffULL, 0x000000414eff7212ULL, 0x040fe4000788c0ffULL,
0x000000454eff7212ULL, 0x080fe400078cc0ffULL, 0x000000455eff7212ULL, 0x000fe4000780c0ffULL,
0x000000326f00720cULL, 0x080fe40000f21070ULL, 0x000000327900720cULL, 0x000fc40001f61470ULL,
0x000000327900720cULL, 0x080fe40002fa1470ULL, 0x000000327700720cULL, 0x080fe40001741470ULL,
0x000000323300720cULL, 0x0c0fe40002781470ULL, 0x000000323300720cULL, 0x080fe400037c1470ULL,
0x000000326b00720cULL, 0x000fe40000701470ULL, 0xff80000055557808ULL, 0x000fc40000800000ULL,
0x000000327300720cULL, 0x0c0fe40001f61070ULL, 0x000000327300720cULL, 0x080fe40002fa1070ULL,
0x000000327100720cULL, 0x080fe40001741070ULL, 0x000000323900720cULL, 0x0c0fe40002721070ULL,
0x000000323900720cULL, 0x080fe400037c1070ULL, 0x000000326500720cULL, 0x000fc40000701070ULL,
0x00005410424d7816ULL, 0x000fe4000000004dULL, 0x0000541044197816ULL, 0x000fe40000000019ULL,
0xff80000035357808ULL, 0x000fe40001800000ULL, 0xff80000037377808ULL, 0x000fe40002800000ULL,
0xff80000054547808ULL, 0x000fe40001000000ULL, 0xff80000050507808ULL, 0x000fc40000800000ULL,
0xff80000052527808ULL, 0x000fe40003000000ULL, 0xff80000022227808ULL, 0x000fe40000000000ULL,
0x000000415aff7212ULL, 0x080fe4000786c0ffULL, 0x000000415eff7212ULL, 0x080fe400078ac0ffULL,
0x0000004166ff7212ULL, 0x000fe4000784c0ffULL, 0x000000455aff7212ULL, 0x000fc4000788c0ffULL,
0x0000004566ff7212ULL, 0x000fe4000782c0ffULL, 0x0000004d62ff7212ULL, 0x040fe400078cc0ffULL,
0x0000001962ff7212ULL, 0x000fe4000780c0ffULL, 0x000000326d00720cULL, 0x0c0fe40001f61470ULL,
0x000000326d00720cULL, 0x080fe40002781470ULL, 0x000000326b00720cULL, 0x000fc40002fa1470ULL,
0x000000326900720cULL, 0x0c0fe40001741470ULL, 0x000000326900720cULL, 0x080fe40000f21470ULL,
0x000000324300720cULL, 0x0c0fe400037c1470ULL, 0x000000324300720cULL, 0x080fe40000701470ULL,
0x000000326700720cULL, 0x0c0fe40001f61070ULL, 0x000000326700720cULL, 0x000fc40002781070ULL,
0x000000326500720cULL, 0x080fe40002fa1070ULL, 0x000000326300720cULL, 0x0c0fe40001741070ULL,
0x000000326300720cULL, 0x080fe40000f21070ULL, 0x000000323f00720cULL, 0x0c0fe400037c1070ULL,
0x000000323f00720cULL, 0x000fe40000701070ULL, 0x0000541012157816ULL, 0x000fc40000000015ULL,
0xff80000051517808ULL, 0x000fe40001800000ULL, 0xff80000053537808ULL, 0x000fe40002000000ULL,
0xff80000020207808ULL, 0x000fe40002800000ULL, 0xff80000023237808ULL, 0x000fe40001000000ULL,
0xff80000024247808ULL, 0x000fe40000800000ULL, 0xff80000025257808ULL, 0x000fc40003000000ULL,
0xff80000027277808ULL, 0x000fe40000000000ULL, 0x0000004d60ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004d6aff7212ULL, 0x080fe4000788c0ffULL, 0x0000004d6cff7212ULL, 0x000fe400078ac0ffULL,
0x0000001960ff7212ULL, 0x080fe4000784c0ffULL, 0x000000196aff7212ULL, 0x000fc4000782c0ffULL,
0x000000196cff7212ULL, 0x000fe400078cc0ffULL, 0x0000001568ff7212ULL, 0x000fe4000780c0ffULL,
0x000000326100720cULL, 0x0c0fe40001f61470ULL, 0x000000326100720cULL, 0x080fe40001741470ULL,
0x000000325f00720cULL, 0x0c0fe40002781470ULL, 0x000000325f00720cULL, 0x000fc40000f21470ULL,
0x000000327b00720cULL, 0x0c0fe40002fa1470ULL, 0x000000327b00720cULL, 0x080fe400037c1470ULL,
0x000000324900720cULL, 0x080fe40000701470ULL, 0x000000325d00720cULL, 0x0c0fe40001f61070ULL,
0x000000325d00720cULL, 0x080fe40001741070ULL, 0x000000325b00720cULL, 0x000fc40002781070ULL,
0x000000325b00720cULL, 0x080fe40000f21070ULL, 0x000000325900720cULL, 0x0c0fe40002fa1070ULL,
0x000000325900720cULL, 0x080fe400037c1070ULL, 0x000000324700720cULL, 0x000fe40000701070ULL,
0x00005410164f7816ULL, 0x000fe4000000004fULL, 0xff80000026267808ULL, 0x000fc40001800000ULL,
0xff8000002c2c7808ULL, 0x000fe40001000000ULL, 0xff8000001c1c7808ULL, 0x000fe40002000000ULL,
0xff8000001e1e7808ULL, 0x000fe40000800000ULL, 0xff8000001d1d7808ULL, 0x000fe40002800000ULL,
0xff8000001f1f7808ULL, 0x000fe40003000000ULL, 0xff8000002d2d7808ULL, 0x000fc40000000000ULL,
0x0000001564ff7212ULL, 0x080fe4000786c0ffULL, 0x000000155cff7212ULL, 0x080fe4000784c0ffULL,
0x0000001558ff7212ULL, 0x000fe4000788c0ffULL, 0x0000004f68ff7212ULL, 0x080fe4000782c0ffULL,
0x0000004f64ff7212ULL, 0x080fe400078ac0ffULL, 0x0000004f5cff7212ULL, 0x000fc400078cc0ffULL,
0x0000004f58ff7212ULL, 0x000fe4000780c0ffULL, 0x000000324900720cULL, 0x080fe40000f21470ULL,
0x000000327d00720cULL, 0x0c0fe40001f61470ULL, 0x000000327d00720cULL, 0x080fe40002fa1470ULL,
0x000000321000720cULL, 0x0c0fe40001741470ULL, 0x000000321000720cULL, 0x000fc400037c1470ULL,
0x000000324c00720cULL, 0x0c0fe40002781470ULL, 0x000000324c00720cULL, 0x080fe40000701470ULL,
0x000000324700720cULL, 0x080fe40000f21070ULL, 0x000000321700720cULL, 0x0c0fe40001f61070ULL,
0x000000321700720cULL, 0x080fe40002fa1070ULL, 0x000000321300720cULL, 0x000fc40001741070ULL,
0x000000321300720cULL, 0x080fe400037c1070ULL, 0x000000321100720cULL, 0x0c0fe40002781070ULL,
0x000000321100720cULL, 0x000fe40000701070ULL, 0xff8000002e2e7808ULL, 0x000fe40001800000ULL,
0xff80000028287808ULL, 0x000fe40001000000ULL, 0xff80000029297808ULL, 0x000fc40002000000ULL,
0xff8000001a1a7808ULL, 0x000fe40000800000ULL, 0xff8000001b1b7808ULL, 0x000fe40002800000ULL,
0xff8000002f2f7808ULL, 0x000fe40003000000ULL, 0xff8000002b2b7808ULL, 0x000fce0000000000ULL,
0x000000210c00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff4c7224ULL, 0x000fe200078e007aULL,
0xfffffff8ff047812ULL, 0x000fe400078ee204ULL, 0x0000000c210c7208ULL, 0x000fc80004000000ULL,
0x000000350c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c35117208ULL, 0x000fc80004000000ULL,
0x000000541100720bULL, 0x000fc80003f1e000ULL, 0x00000011540c7208ULL, 0x000fc80004000000ULL,
0x000000550c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c55117208ULL, 0x000fc80004000000ULL,
0x000000501100720bULL, 0x000fc80003f1e000ULL, 0x00000011500c7208ULL, 0x000fc80004000000ULL,
0x000000510c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c51117208ULL, 0x000fc80004000000ULL,
0x000000201100720bULL, 0x000fc80003f1e000ULL, 0x00000011200c7208ULL, 0x000fc80004000000ULL,
0x000000230c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c230c7208ULL, 0x000fc80004000000ULL,
0x000000250c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c25117208ULL, 0x000fc80004000000ULL,
0x000000261100720bULL, 0x000fc80003f1e000ULL, 0x0000001126117208ULL, 0x000fc80004000000ULL,
0x0000001c1100720bULL, 0x000fc80003f1e000ULL, 0x000000111c0c7208ULL, 0x000fe40004000000ULL,
0x000000360d00720bULL, 0x000fe40003f1e000ULL, 0x0000001d0c00720bULL, 0x000fc80003f3e000ULL,
0x0000000c1d107208ULL, 0x000fe40004800000ULL, 0x0000000d360c7208ULL, 0x000fe40004000000ULL,
0x0000002d1000720bULL, 0x000fe40003f3e000ULL, 0x000000370c00720bULL, 0x000fe40003f1e000ULL,
0x000000102d117208ULL, 0x000fe40004800000ULL, 0x0000000c370d7208ULL, 0x000fc40004000000ULL,
0x0000002e1100720bULL, 0x000fe40003f3e000ULL, 0x000000560d00720bULL, 0x000fe40003f1e000ULL,
0x000000112e117208ULL, 0x000fe40004800000ULL, 0x0000000d560c7208ULL, 0x000fe40004000000ULL,
0x000000281100720bULL, 0x000fe40003f3e000ULL, 0x000000570c00720bULL, 0x000fc40003f1e000ULL,
0x0000001128107208ULL, 0x000fe40004800000ULL, 0x0000000c570d7208ULL, 0x000fe40004000000ULL,
0x000000291000720bULL, 0x000fe40003f3e000ULL, 0x000000520d00720bULL, 0x000fe40003f1e000ULL,
0x0000001029107208ULL, 0x000fe40004800000ULL, 0x0000000d520c7208ULL, 0x000fc60004000000ULL,
0x0c401f0010117f89ULL, 0x000ea200000e0000ULL, 0x000000530c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c530d7208ULL, 0x000fc80004000000ULL, 0x000000220d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d220d7208ULL, 0x000fc80004000000ULL, 0x000000240d00720bULL, 0x000fc80003f1e000ULL,
0x0000000d240c7208ULL, 0x000fe40004000000ULL, 0x000000111000720bULL, 0x004fe40003f3e000ULL,
0x000000270c00720bULL, 0x000fe40003f1e000ULL, 0x0000001011117208ULL, 0x000fe40004800000ULL,
0x0000000c270d7208ULL, 0x000fc60004000000ULL, 0x0c201f0011107f89ULL, 0x000ea200000e0000ULL,
0x0000002c0d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d2c0d7208ULL, 0x000fc80004000000ULL,
0x0000001e0d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d1e0c7208ULL, 0x000fc80004000000ULL,
0x0000001f0c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c1f0d7208ULL, 0x000fe40004000000ULL,
0x000000101100720bULL, 0x004fe40003f3e000ULL, 0x0000001a0d00720bULL, 0x000fe40003f1e000ULL,
0x00000011100c7208ULL, 0x000fe40004800000ULL, 0x0000000d1a107208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b0c127820ULL, 0x000fe20000410000ULL, 0x0000001b1000720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010812ULL, 0x000000101b107208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010812ULL,
0x0000002600197308ULL, 0x000fe20000000800ULL, 0x0000002f1000720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b54547823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b55557823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010812ULL, 0x000000102f107208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b50507823ULL, 0x100fe20000010812ULL,
0x0000002100217308ULL, 0x000fe20000000800ULL, 0x0000002b1000720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b51517823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010812ULL, 0x000000102b107208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010812ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010812ULL,
0x0000003500147308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010812ULL,
0x0c401f00100d7f89ULL, 0x000ea200000e0000ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010812ULL,
0x3fb8aa3b29127823ULL, 0x000fc80000010812ULL, 0x0000002000167308ULL, 0x000ff00000000800ULL,
0x0000001c00307308ULL, 0x000ff00000000800ULL, 0x0000005400547308ULL, 0x000fe20000000800ULL,
0x0000000d1000720bULL, 0x004fc80003f1e000ULL, 0x000000100d0d7208ULL, 0x000fc60004000000ULL,
0x0000005500557308ULL, 0x000fe40000000800ULL, 0x0c201f000d107f89ULL, 0x000eac00000e0000ULL,
0x0000002500187308ULL, 0x0007300000000800ULL, 0x0000001200297308ULL, 0x000be20000000800ULL,
0x3c003c00ff257424ULL, 0x008fe200078e00ffULL, 0x000000181918723eULL, 0x010fcc00000000ffULL,
0x0000002300157308ULL, 0x000ee20000000800ULL, 0x000000545512723eULL, 0x022fe400000000ffULL,
0x000000100d00720bULL, 0x004fc80003f1e000ULL, 0x0000000d100d7208ULL, 0x000fe20004000000ULL,
0x0000005000507308ULL, 0x000fe20000000800ULL, 0x000000211410723eULL, 0x000fc600000000ffULL,
0x3fb8aa3b0d267820ULL, 0x000fe20000410000ULL, 0x000000161516723eULL, 0x008fc600000000ffULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b56567823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b57577823ULL, 0x100fe20000010826ULL,
0x0000003600117308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b24147823ULL, 0x100fe20000010826ULL,
0x3c003c00ff247424ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b52527823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010826ULL,
0x00000037001c7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b1a327823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b1b337823ULL, 0x100fe20000010826ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010826ULL,
0x3fb8aa3b2b267823ULL, 0x000fe20000010826ULL, 0x00000008042b7836ULL, 0x000fe20000000000ULL,
0x0000005600137308ULL, 0x000fe20000000800ULL, 0x000000111c11723eULL, 0x002fce00000000ffULL,
0x0000005700207308ULL, 0x000e620000000800ULL, 0x000000ffff347224ULL, 0x000fce00078e0011ULL,
0x0000002200177308ULL, 0x0005e20000000800ULL, 0x000000132013723eULL, 0x002fce00000000ffULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x0000001300357202ULL, 0x000fe20000000f00ULL,
0x000000241020723cULL, 0x004fec00000018ffULL, 0x0000005200527308ULL, 0x000fe20000000800ULL,
0x00000001ff117424ULL, 0x000fce00078e00ffULL, 0x0000005300537308ULL, 0x000e700000000800ULL,
0x00000014001c7308ULL, 0x0004e20000000800ULL, 0x000000525315723eULL, 0x002fce00000000ffULL,
0x0000001d00317308ULL, 0x0003220000000800ULL, 0x000000505114723eULL, 0x004fe200000000ffULL,
0x000000ffff367224ULL, 0x000fe200078e0015ULL, 0x000000171c17723eULL, 0x008fca00000000ffULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x0c401f000e1d7f89ULL, 0x002e6200000e0000ULL,
0x000000ffff377224ULL, 0x000fc600078e0017ULL, 0x0c401f000f1c7f89ULL, 0x000ea200000e0000ULL,
0x000000241420723cULL, 0x000fe20000001820ULL, 0x00000030311a723eULL, 0x010fe200000000ffULL,
0x0000002c002c7308ULL, 0x000ee20000000800ULL, 0x000000082b317824ULL, 0x000fce00078e00ffULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x000000272c19723eULL, 0x008fce00000000ffULL,
0x0000001f001f7308ULL, 0x000ee20000000800ULL, 0x0000001d0e00720bULL, 0x002fe20003f1e000ULL,
0x000008000a277824ULL, 0x000fe200078e0207ULL, 0x00000003022c7812ULL, 0x000fe400078ec0ffULL,
0x0000001c0f00720bULL, 0x004fe40003f3e000ULL, 0x0000000e1d0e7208ULL, 0x000fe20004000000ULL,
0x0000002800287308ULL, 0x000e620000000800ULL, 0x0000000f1c0f7208ULL, 0x000fca0004800000ULL,
0x0c201f000f027f89ULL, 0x000ea200000e0000ULL, 0x0000001e1f1b723eULL, 0x008fe200000000ffULL,
0x0000002f002f7308ULL, 0x000fe80000000800ULL, 0x000000ffff157224ULL, 0x000fe400078e001bULL,
0x000000241820723cULL, 0x000fe20000001820ULL, 0x00000028291e723eULL, 0x002fe200000000ffULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x0000000804297824ULL, 0x000fce00078e00ffULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x000000020f00720bULL, 0x004fce0003f3e000ULL,
0x0000002e002e7308ULL, 0x000ea20000000800ULL, 0x0000002f261f723eULL, 0x002fe400000000ffULL,
0x000000042c267210ULL, 0x000fe20007ffe0ffULL, 0x000000012c2c7824ULL, 0x000fe200078e022bULL,
0x000000032b2f7819ULL, 0x000fe200000006ffULL, 0x00011000272b7836ULL, 0x000fe20000000000ULL,
0x0000000f020f7208ULL, 0x000fe20004800000ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x0000000426287836ULL, 0x000fe20000000000ULL, 0xfffffff82f2c7812ULL, 0x000fe200078ee22cULL,
0x000000ffff277224ULL, 0x000fc400078e0016ULL, 0x000000ffff2f7224ULL, 0x000fe200078e001eULL,
0x0000002d2e1c723eULL, 0x004fe400000000ffULL, 0x0000003300337308ULL, 0x000e620000000800ULL,
0x00000008042d7824ULL, 0x000fe200078e00ffULL, 0xfffffff829047812ULL, 0x000fe200078ee226ULL,
0x0000000c26267836ULL, 0x000fe20000000000ULL, 0x0c201f000e297f89ULL, 0x000ea200000e0000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e001cULL, 0xfffffff82d287812ULL, 0x000fe200078ee228ULL,
0x0000001004047824ULL, 0x100fe200078e022bULL, 0xfffffff831307812ULL, 0x000fe200078ee226ULL,
0x000000ffff2d7224ULL, 0x000fe200078e001aULL, 0x0000001400267202ULL, 0x000fe20000000f00ULL,
0x0000001028287824ULL, 0x000fc400078e022bULL, 0x0000001030307824ULL, 0x000fe200078e022bULL,
0x00000032331d723eULL, 0x002fe200000000ffULL, 0x000000ffff147224ULL, 0x000fe400078e0019ULL,
0x000000ffff177224ULL, 0x000fe400078e001fULL, 0x000000ffff167224ULL, 0x000fe400078e001dULL,
0x000000241c20723cULL, 0x000fe20000001820ULL, 0x000000290e00720bULL, 0x004fcc0003f1e000ULL,
0x000000ffff247224ULL, 0x000fe400078e0010ULL, 0x000000ffff257224ULL, 0x000fe200078e0012ULL,
0x0000000e290e7208ULL, 0x000fe40004000000ULL, 0x0000000309ff7812ULL, 0x000fe4000780c0ffULL,
0x0000002404007844ULL, 0x0003ec0000000200ULL, 0x000000102c217824ULL, 0x000fc400078e022bULL,
0x000000ffff2c7224ULL, 0x000fe400078e0018ULL, 0x000000ffff127224ULL, 0x000fe200078e0020ULL,
0x0000002200137202ULL, 0x000fe40000000f00ULL, 0x0000002c28007844ULL, 0x0003e80000000200ULL,
0x0000003421007844ULL, 0x0003e80000000200ULL, 0x0000001430007844ULL, 0x0003e80000000200ULL,
0x01b0000c2a008388ULL, 0x0003e80000000c00ULL, 0x01b200122a008388ULL, 0x0003e20000000a00ULL,
0x000000057a00720cULL, 0x000fe20003f06070ULL, 0x01b6081108ff79a7ULL, 0x0003e2000850003fULL,
0x01b6101108ff79a7ULL, 0x0003e2000850003fULL, 0x01b6181108ff79a7ULL, 0x0003e2000850003fULL,
0x01b6201108ff79a7ULL, 0x0003f2000850003fULL, 0xffffff9c00648947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000004027836ULL, 0x000fe20000000000ULL,
0x0000013000007945ULL, 0x000fe80003800000ULL, 0x7f80000002057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000400028308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000205ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff04ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000004047812ULL, 0x002fe400078ec0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000205ff7212ULL, 0x000fda000780c0ffULL, 0x0080000004020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0004ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000400027308ULL, 0x0004e40000001000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x006fe400078e000dULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffffed004347950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x000000000000048dULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000608ULL, 0x0000000000000210ULL, 0x0000001400000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000818ULL, 0x00000000000000f8ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000910ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000964ULL, 0x0000000000000460ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000dc8ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000dc8ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000000e10ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000000e80ULL, 0x0000000000013000ULL, 0x0000001400000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000013e80ULL, 0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000013ec0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x0000000000013ec0ULL, 0x0000000000000268ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x00000000000144a8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x00000000000144a8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000000e10ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000e80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000013000ULL, 0x0000000000013000ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000013e80ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000013ec0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000268ULL, 0x0000000000000268ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_0_m_16_sm_90_cubin_len = 83448;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
