/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001c240ULL, 0x000000000001bec0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL,
0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL,
0x616e7265746e695fULL, 0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL,
0x705f796c66625f63ULL, 0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL,
0x6c6668735f30376dULL, 0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL,
0x616475635f5f245fULL, 0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL,
0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL,
0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL,
0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000028ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b00220000036fULL, 0x000000000001a5a0ULL, 0x0000000000000170ULL, 0x000b0022000003a2ULL,
0x000000000001a710ULL, 0x0000000000000040ULL, 0x000b0022000003cdULL, 0x000000000001a750ULL,
0x0000000000000050ULL, 0x000b0022000003f7ULL, 0x000000000001a7a0ULL, 0x0000000000000160ULL,
0x000a000300000465ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000485ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004b5ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001a900ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001a5a000000000ULL, 0x0000040400000000ULL, 0x810c000001500400ULL,
0x0068080400288080ULL, 0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808c92ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x0001a5a000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808c0828808081ULL, 0x8f082880808e0828ULL, 0x2880809008288080ULL,
0x8092082880809108ULL, 0x0828808095082880ULL, 0x8080a0082880809dULL, 0xa608288080a10828ULL,
0x288080a808288080ULL, 0x80ed08288080aa08ULL, 0x08288080ee082880ULL, 0x80828016288080ceULL,
0x0000000000031028ULL, 0x288080ce92000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x000000e000000000ULL, 0x0001a71000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808c0828808081ULL, 0x8f082880808e0828ULL, 0x2880809008288080ULL,
0x8092082880809108ULL, 0x0828808095082880ULL, 0x8080a0082880809dULL, 0xa608288080a10828ULL,
0x288080a908288080ULL, 0x80ed08288080aa08ULL, 0x08288080ee082880ULL, 0x80828016288080a8ULL,
0x0000000000031028ULL, 0x288080a892000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL,
0x000001a000000000ULL, 0x0001a75000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x80aa288080a80900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0x8f082880808e0828ULL, 0x2880809008288080ULL, 0x8092082880809108ULL, 0x0828808095082880ULL,
0x8080a0082880809dULL, 0xa608288080a10828ULL, 0x288080a808288080ULL, 0x80ed08288080aa08ULL,
0x08288080ee082880ULL, 0x80828016288080a9ULL, 0x0000000000031028ULL, 0x288080a992000000ULL,
0x0000000000002200ULL, 0x0000002cffffffffULL, 0x0000027000000000ULL, 0x0001a7a000000000ULL,
0x0000016000000000ULL, 0x0000180400000000ULL, 0x80aa288080a90900ULL, 0x0000000000002880ULL,
0x0000001700082f04ULL, 0x00082304000000d8ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000011ULL,
0x0000001100081204ULL, 0x0008110400000000ULL, 0x0000000000000011ULL, 0x0000001000082304ULL,
0x0008120400000000ULL, 0x0000000000000010ULL, 0x0000001000081104ULL, 0x0008230400000000ULL,
0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0058016000000014ULL, 0x000c170400581903ULL,
0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040021f000ULL,
0x0040000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040061f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00000ab000043104ULL, 0xffffffff01cc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000002d001cc2804ULL,
0x0000051000000380ULL, 0x00002b5000001b80ULL, 0x00002d0000002bf0ULL, 0x00002fe000002e70ULL,
0x0000335000003140ULL, 0x000033a000003390ULL, 0x00003cb0000033d0ULL, 0x00004c4000004ba0ULL,
0x00004ed000004d60ULL, 0x000051a000005040ULL, 0x000053e0000053a0ULL, 0x00005420000053f0ULL,
0x000069a000005ae0ULL, 0x00006b6000006a40ULL, 0x00006e4000006cd0ULL, 0x000071b000006fa0ULL,
0x00007200000071f0ULL, 0x000078d000007230ULL, 0x00008880000087e0ULL, 0x00008b10000089a0ULL,
0x00008de000008c80ULL, 0x0000903000008ff0ULL, 0x0000907000009040ULL, 0x0000984000009830ULL,
0x0000986000009850ULL, 0x0000c6a00000c5e0ULL, 0x0000c6d00000c6c0ULL, 0x0000d2500000d220ULL,
0x0000d2b00000d280ULL, 0x00017d9000017d50ULL, 0x00017db000017da0ULL, 0x00017e3000017e10ULL,
0x00017e5000017e40ULL, 0x00019210000191b0ULL, 0x000192e000019280ULL, 0x000193a000019340ULL,
0x0001948000019410ULL, 0x00019560000194f0ULL, 0x00019620000195c0ULL, 0x000196f000019690ULL,
0x000197b000019750ULL, 0x0001989000019820ULL, 0x0001997000019900ULL, 0x00019a30000199d0ULL,
0x00019b0000019aa0ULL, 0x00019bc000019b60ULL, 0x00019ca000019c30ULL, 0x00019d8000019d10ULL,
0x00019e4000019de0ULL, 0x00019f1000019eb0ULL, 0x00019fd000019f70ULL, 0x0001a0b00001a040ULL,
0x0001a1900001a120ULL, 0x0001a2700001a200ULL, 0x0001a3700001a2f0ULL, 0x0001a4700001a3f0ULL,
0x0001a5700001a4f0ULL, 0x000003e002003904ULL, 0x0001e600000000ffULL, 0x00000410003f0100ULL,
0x0001e6080000000bULL, 0x00000470003f0120ULL, 0x0001e6880000000bULL, 0x00000ac0003f0120ULL,
0x0001e600000000ffULL, 0x00000c30003f0107ULL, 0x0001e68c00000007ULL, 0x00000cc0003f0102ULL,
0x0001e68800000007ULL, 0x00002840003f0101ULL, 0x0001e60800000016ULL, 0x00002880003f0101ULL,
0x0001e60c0000000cULL, 0x00002a50003f0105ULL, 0x0001e60c0000000cULL, 0x00003c70003f0105ULL,
0x0001e6880000001dULL, 0x000048c0003f0101ULL, 0x0001e62800000028ULL, 0x00004900003f0101ULL,
0x0001e62c0000002aULL, 0x00004ad0003f0105ULL, 0x0001e62c0000002aULL, 0x00005aa0003f0105ULL,
0x0000000000000028ULL, 0x000066e0003f0101ULL, 0x0001e64800000026ULL, 0x00006700003f0101ULL,
0x0001e64c00000026ULL, 0x000068d0003f0105ULL, 0x0001e64c00000026ULL, 0x000078b0003f0105ULL,
0x0000000000000021ULL, 0x00008530003f0101ULL, 0x0001e66800000024ULL, 0x00008550003f0101ULL,
0x0001e66c00000024ULL, 0x00008720003f0105ULL, 0x0001e66c00000024ULL, 0x000096a0003f0105ULL,
0x0001e6a00000000bULL, 0x0000ecb0003f0101ULL, 0x0001e600000000ffULL, 0x000104e0003f0101ULL,
0x0001e604000000ffULL, 0x000106b0003f0105ULL, 0x0001e604000000ffULL, 0x00014fb0003f0105ULL,
0x000000000000009bULL, 0x00015370003f0101ULL, 0x000000040000009bULL, 0x00015540003f0105ULL,
0x000000040000009bULL, 0x00019000003f0105ULL, 0x0001e6080000009aULL, 0x00019060003f0101ULL,
0x0001e6100000009aULL, 0x000190c0003f0101ULL, 0x0001e6180000009aULL, 0x00019130003f0101ULL,
0x0001e6200000009aULL, 0x00033803003f0101ULL, 0x0000e0c000301c04ULL, 0x0000e2c00000e0f0ULL,
0x0000e5800000e420ULL, 0x0000e8400000e6e0ULL, 0x0000eb300000e9a0ULL, 0x000107100000ec30ULL,
0x0000040100019170ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000031cULL, 0x0000001700000002ULL,
0x000000000000024cULL, 0x0000001700000002ULL, 0x000000000000018cULL, 0x0000001700000002ULL,
0x00000000000000ccULL, 0x0000001700000002ULL, 0x0000000000000044ULL, 0x0000001700000002ULL,
0x00000000000002f3ULL, 0x0000001700000002ULL, 0x0000000000000223ULL, 0x0000001700000002ULL,
0x0000000000000163ULL, 0x0000001700000002ULL, 0x00000000000000a8ULL, 0x0000001700000002ULL,
0x000000000001e700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff157624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000f7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a0015837a19ULL, 0x000fe200000006ffULL,
0x00000000000579c3ULL, 0x000f220000002500ULL, 0x0000000000077919ULL, 0x000ea20000002100ULL,
0x0000460000087ab9ULL, 0x000fc60000000a00ULL, 0x0000000000137919ULL, 0x000ea20000002700ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003817a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a81ULL, 0x0000040003007624ULL, 0x000fca00078e0215ULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000181810810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000181811810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff81aa12ULL, 0x000fc800078e33ffULL,
0x0000008100007306ULL, 0x000e620000209000ULL, 0x000000ff8100720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000381047224ULL, 0x004fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x0000000000047919ULL, 0x000ee40000002200ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x00000006030a7227ULL, 0x000fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a0aULL,
0x0000000081007224ULL, 0x000fca00078e0206ULL, 0x000000810000720cULL, 0x000fe20003f06070ULL,
0x000001000f027a24ULL, 0x008fe400078e0204ULL, 0x00001fff0f0f7589ULL, 0x000fe400000e0000ULL,
0x00000000020b7a24ULL, 0x000fca00078e0207ULL, 0x000000ff0b00720cULL, 0x000fc60003f65270ULL,
0x0000000100000824ULL, 0x000fe200078e0a81ULL, 0x000000010a0a0810ULL, 0x000fe40007ffe0ffULL,
0x0000000f0b00780cULL, 0x040fe40003f84070ULL, 0x000000810000720cULL, 0x000fe40003f26070ULL,
0x000000030b00780cULL, 0x000fe40003f04070ULL, 0x00000005ff007819ULL, 0x000fe20000011607ULL,
0x3fffff80ff02b424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03b424ULL, 0x000fc600078e00ffULL,
0x00001fff00007589ULL, 0x000e6200000e0000ULL, 0x3fffffc0ff04c424ULL, 0x000fe400078e00ffULL,
0x000000010a0a1810ULL, 0x000fe20007ffe0ffULL, 0x7fffffc0ff05c424ULL, 0x000fe200078e00ffULL,
0x00000081ff0aa212ULL, 0x000fe200078e33ffULL, 0x7fffff60ff098424ULL, 0x000fe200078e00ffULL,
0x01e60002ff00b388ULL, 0x0009e20000000a00ULL, 0x0000007f0b00780cULL, 0x000fe40003f24070ULL,
0x000000ffff087224ULL, 0x000fe200078e0a0aULL, 0x01e608040b00c388ULL, 0x0003e20000008a00ULL,
0x00005a000a807a19ULL, 0x000fc400000006ffULL, 0x0000000881817224ULL, 0x000fe400078e0206ULL,
0x3fffff60ff088424ULL, 0x000fe400078e00ffULL, 0x0000002081077824ULL, 0x000fe400078e00ffULL,
0x00000005ff037e24ULL, 0x010fe2000f8e00ffULL, 0x01e688080b008388ULL, 0x0005e20000008a00ULL,
0xff317217ff069424ULL, 0x000fe200078e00ffULL, 0x0000000407027c10ULL, 0x000fe2000fffe1ffULL,
0x000000040f057824ULL, 0x002fe200078e0200ULL, 0x0000000407007c0cULL, 0x000fe2000bf03070ULL,
0x0000580013047a24ULL, 0x000fe200078e02ffULL, 0x0000002002027817ULL, 0x000fe20003800000ULL,
0x01e400060b009388ULL, 0x000fe60000004800ULL, 0x000000ff02027207ULL, 0x000fe20000000000ULL,
0x0000000405097824ULL, 0x004fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000200200780cULL, 0x000fe20003f05270ULL, 0x0000008304057224ULL, 0x000fd800078e0280ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe20000000000ULL, 0x0000000902067217ULL, 0x000fe20007800000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe4000800063fULL,
0x0000000106067824ULL, 0x000fe200078e0a09ULL, 0x00000004ff087819ULL, 0x002fc80000011604ULL,
0x00000002080d7810ULL, 0x040fe20007ffe0ffULL, 0x00000001090e7824ULL, 0x000fe200078e0208ULL,
0x000000060800720cULL, 0x080fe40003f06070ULL, 0x000000060d00720cULL, 0x000fe20003f26070ULL,
0x0000000109117824ULL, 0x000fe400078e020dULL, 0x00000001070b7824ULL, 0x040fe400078e020eULL,
0x0000000107127824ULL, 0x000fe400078e0211ULL, 0x000000010e067824ULL, 0x140fe200078e0204ULL,
0x000000040b107c12ULL, 0x000fe2000f8e30ffULL, 0x000000100e177824ULL, 0x000fe200078e00ffULL,
0x0000000412147c12ULL, 0x000fe2000f8e30ffULL, 0x00000001110e7824ULL, 0x000fe200078e0204ULL,
0x00005a00ff0c7a19ULL, 0x000fe2000001160bULL, 0x0000000105107824ULL, 0x040fe200078e0210ULL,
0x00005a00ff127a19ULL, 0x000fe20000011612ULL, 0x0000000105147824ULL, 0x000fe200078e0214ULL,
0xfffffff017067812ULL, 0x000fe200078ee206ULL, 0x000000830c087224ULL, 0x000fc400078e0210ULL,
0x00000010040b7824ULL, 0x000fe400078e00ffULL, 0x00000083120c7224ULL, 0x000fe400078e0214ULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x000000f00b057812ULL, 0x000fc600078ec0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000508087212ULL, 0x000fc600078efcffULL,
0x0000001011117824ULL, 0x000fe200078e00ffULL, 0x000000050c057212ULL, 0x000fe400078efcffULL,
0x00005e0008087a10ULL, 0x000fe40007f5e0ffULL, 0xfffffff0110e7812ULL, 0x000fe400078ee20eULL,
0x00005e00050c7a10ULL, 0x000fe20007f7e0ffULL, 0x0000001006057824ULL, 0x000fe200078e00ffULL,
0x00005f0009097a10ULL, 0x000fe200017fe4ffULL, 0x000000100e117824ULL, 0x000fe200078e00ffULL,
0x00005f000d0d7a10ULL, 0x000fc60001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008057faeULL, 0x0003e8000c101c48ULL, 0x000000000c117faeULL, 0x0003e2000c901c48ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x0000000904067211ULL, 0x042fe200078fe0ffULL,
0x00000010040b7824ULL, 0x000fc600078e00ffULL, 0x00000002060e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107087824ULL, 0x000fe200078e0206ULL, 0x000000f00b117812ULL, 0x000fc600078ec0ffULL,
0x0000000107097824ULL, 0x000fe200078e020eULL, 0x00000004080c7c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff087a19ULL, 0x000fe40000011608ULL, 0x0000000409107c12ULL, 0x000fe2000f8e30ffULL,
0x00000001050c7824ULL, 0x000fc800078e020cULL, 0x0000000105057824ULL, 0x000fe200078e0210ULL,
0x00005a00ff107a19ULL, 0x000fe20000011609ULL, 0x0000008308087224ULL, 0x000fc800078e020cULL,
0x0000008310057224ULL, 0x000fe400078e0205ULL, 0x0000010008087825ULL, 0x000fc800078e00ffULL,
0x00000100050c7825ULL, 0x000fe200078e00ffULL, 0x0000001108087212ULL, 0x000fc600078efcffULL,
0x0000000106057824ULL, 0x100fe200078e0204ULL, 0x000000110c0c7212ULL, 0x000fe200078efcffULL,
0x0000001006107824ULL, 0x000fe200078e00ffULL, 0x00005e0008087a10ULL, 0x000fe20007f1e0ffULL,
0x000000010e067824ULL, 0x000fe200078e0204ULL, 0x00005e000c0c7a10ULL, 0x000fe20007f3e0ffULL,
0x000000100e117824ULL, 0x000fe200078e00ffULL, 0xfffffff010057812ULL, 0x000fe400078ee205ULL,
0x00005f0009097a10ULL, 0x000fe400007fe4ffULL, 0xfffffff011067812ULL, 0x000fe200078ee206ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x00005f000d0d7a10ULL, 0x000fc60000ffe4ffULL,
0x0000001006117824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008057faeULL, 0x0003e8000b901c48ULL, 0x000000000c117faeULL, 0x0003e4000b901c48ULL,
0x0000000000097919ULL, 0x002e620000000000ULL, 0x0000000000057806ULL, 0x000fc600038e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000500067300ULL, 0x000e7000000e0000ULL,
0x0000000500087309ULL, 0x000ea20000000000ULL, 0x000000090600720cULL, 0x002fe20003f02070ULL,
0x000000ffff067224ULL, 0x004fc400078e0a08ULL, 0x00000004ff087424ULL, 0x000fc800078e00ffULL,
0x0000640013087625ULL, 0x000fcc00078e0008ULL, 0x01e60406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01e60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000808057981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0f00720cULL, 0x000fe40003f05270ULL,
0x000000ff05067810ULL, 0x006fc80007ffe0ffULL, 0x00000008ff067819ULL, 0x000fce0000011606ULL,
0x0000e05000008947ULL, 0x000fea0003800000ULL, 0x0000000213087824ULL, 0x000fe400078e00ffULL,
0x0000000800077824ULL, 0x000fe400078e00ffULL, 0x00000003ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e68c0c07ff738cULL, 0x0003e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000001030d7810ULL, 0x000fe20007ffe0ffULL,
0x0000590008097624ULL, 0x000fe200078e0215ULL, 0x00000001ff217819ULL, 0x000fe20000011600ULL,
0x01e6880007ff7f8cULL, 0x0005e2000c80043fULL, 0x000000060d00720cULL, 0x000fe20003f06070ULL,
0x000000010a097824ULL, 0x000fe200078e0209ULL, 0x00000001000a7812ULL, 0x000fe200078ec0ffULL,
0x0000002021087824ULL, 0x000fc800078e00ffULL, 0x0000010003107824ULL, 0x000fc800078e0208ULL,
0x00006600092d7a24ULL, 0x000fe400078e0210ULL, 0x0000064000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1a7819ULL, 0x004fe40000011604ULL, 0x00000010050c7217ULL, 0x002fe40007800000ULL,
0x000000041a0e7810ULL, 0x040fe40007ffe0ffULL, 0x000000081a127810ULL, 0x000fe20007ffe0ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0a10ULL, 0x0000000c1a137810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0d7824ULL, 0x100fe200078e0204ULL, 0x000000101a187810ULL, 0x000fe20007ffe0ffULL,
0x000000080e147824ULL, 0x000fe200078e00ffULL, 0x000000141a1e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001120f7824ULL, 0x000fc400078e0204ULL, 0x0000000812167824ULL, 0x000fe200078e00ffULL,
0xfffffff8141f7812ULL, 0x000fe200078ee20dULL, 0x0000000113107824ULL, 0x000fe200078e0204ULL,
0x000000700b0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000813257824ULL, 0x000fe200078e00ffULL,
0x000000200c0b7817ULL, 0x000fe20003800000ULL, 0x000000012d117824ULL, 0x040fe200078e020eULL,
0xfffffff816237812ULL, 0x000fe200078ee20fULL, 0x000000800a0c7824ULL, 0x000fe200078e020dULL,
0x0000000b0e00720cULL, 0x080fe20003f86070ULL, 0x000000012d0f7824ULL, 0x000fe200078e021aULL,
0xfffffff825257812ULL, 0x000fe200078ee210ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x0000000b1200720cULL, 0x080fe20003f66070ULL, 0x0000000118157824ULL, 0x000fe200078e0204ULL,
0x0000000b1300720cULL, 0x080fe20003f46070ULL, 0x000001000f0e7825ULL, 0x000fe200078e000cULL,
0x0000000b1a00720cULL, 0x000fc60003fa6070ULL, 0x00000008181c7824ULL, 0x000fe200078e00ffULL,
0x000062000e147a10ULL, 0x000fe20007f1e0ffULL, 0x0000010011107825ULL, 0x000fc600078e000cULL,
0xfffffff81c277812ULL, 0x000fe200078ee215ULL, 0x000000011e177824ULL, 0x000fe200078e0204ULL,
0x0000620010167a10ULL, 0x000fe20007f3e0ffULL, 0x000000081e207824ULL, 0x000fe200078e00ffULL,
0x000063000f157a10ULL, 0x000fe200007fe4ffULL, 0x000000012d0f7824ULL, 0x000fe200078e0212ULL,
0x0000000a211c7211ULL, 0x000fe200078e08ffULL, 0x000000011a127824ULL, 0x000fe200078e0204ULL,
0xfffffff820297812ULL, 0x000fe200078ee217ULL, 0x000001000f0e7825ULL, 0x000fe200078e000cULL,
0x0000630011177a10ULL, 0x000fc40000ffe4ffULL, 0x0000000b1800720cULL, 0x000fe20003f26070ULL,
0x000000012d117824ULL, 0x040fe200078e0213ULL, 0x00000007121b7812ULL, 0x000fe200078ec0ffULL,
0x000000012d137824ULL, 0x000fe200078e0218ULL, 0x000062000e187a10ULL, 0x000fe20007f1e0ffULL,
0x0000010011107825ULL, 0x100fe200078e000cULL, 0x000160001c1c7811ULL, 0x000fe400078e68ffULL,
0x000063000f197a10ULL, 0x000fe200007fe4ffULL, 0x0000010013127825ULL, 0x000fe200078e000cULL,
0x0000620010107a10ULL, 0x000fc40007fde0ffULL, 0x0ffffff81b1b7812ULL, 0x000fe200078ef804ULL,
0x000000012d0f7824ULL, 0x000fe200078e021eULL, 0x0000630011117a10ULL, 0x000fe200037fe4ffULL,
0x000000101f1f7824ULL, 0x000fe200078e021cULL, 0x0000620012127a10ULL, 0x000fe20007fde0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e000cULL, 0x0000000b1e00720cULL, 0x080fe40003f06070ULL,
0x000000181a1e7810ULL, 0x040fe20007ffe0ffULL, 0x000000101b1d7824ULL, 0x100fe200078e021cULL,
0x0000630013137a10ULL, 0x000fe200037fe4ffULL, 0x0000001023237824ULL, 0x000fe200078e021cULL,
0x0000001c1a207810ULL, 0x000fe20007ffe0ffULL, 0x000000012d2b7824ULL, 0x040fe200078e021eULL,
0x000062000e1a7a10ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x0003e2000e901c48ULL, 0x0000000b1e00720cULL, 0x080fe20003fa6070ULL,
0x000000012d2d7824ULL, 0x000fe200078e0220ULL, 0x000063000f1b7a10ULL, 0x000fe200037fe4ffULL,
0x00000000161f7faeULL, 0x0005e2000e101c48ULL, 0x000001002b0e7825ULL, 0x000fe200078e000cULL,
0x0000000b2000720cULL, 0x000fc40003f86070ULL, 0x0000000018237faeULL, 0x0005e2000d901c48ULL,
0x000000011e0b7824ULL, 0x100fe200078e0204ULL, 0x000062000e0e7a10ULL, 0x000fe20007fde0ffULL,
0x000000081e1e7824ULL, 0x000fe400078e00ffULL, 0x0000000120147824ULL, 0x042fe200078e0204ULL,
0x000063000f0f7a10ULL, 0x000fe200037fe4ffULL, 0x0000000820157824ULL, 0x000fe200078e00ffULL,
0xfffffff81e0b7812ULL, 0x000fe200078ee20bULL, 0x000001002d0c7825ULL, 0x000fc600078e000cULL,
0xfffffff815157812ULL, 0x000fe200078ee214ULL, 0x0000001025257824ULL, 0x100fe200078e021cULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x0000001027277824ULL, 0x100fe400078e021cULL,
0x0000001029297824ULL, 0x100fe200078e021cULL, 0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x000000100b0b7824ULL, 0x100fe200078e021cULL, 0x0000000010257faeULL, 0x0005e2000d101c48ULL,
0x0000001015157824ULL, 0x000fc600078e021cULL, 0x0000000012277faeULL, 0x0005e8000c901c48ULL,
0x000000001a297faeULL, 0x0005e8000c101c48ULL, 0x000000000e0b7faeULL, 0x0005e8000e901c48ULL,
0x000000000c157faeULL, 0x0005e2000e101c48ULL, 0x0000057000007947ULL, 0x000fea0003800000ULL,
0x00000004040d7811ULL, 0x044fe400078fe8ffULL, 0x0000000804117811ULL, 0x000fc400078fe8ffULL,
0x0000001404177811ULL, 0x040fe200078fe8ffULL, 0x000000010d0c7824ULL, 0x142fe200078e0204ULL,
0x0000000c04137811ULL, 0x040fe200078fe8ffULL, 0x000000080d0f7824ULL, 0x000fe200078e00ffULL,
0x0000001804197811ULL, 0x040fe200078fe8ffULL, 0x00000001110e7824ULL, 0x040fe400078e0204ULL,
0x0000000811157824ULL, 0x000fe200078e00ffULL, 0xfffffff80f1c7812ULL, 0x000fe200078ee20cULL,
0x00000001170f7824ULL, 0x040fe400078e0204ULL, 0x0000000817247824ULL, 0x000fe200078e00ffULL,
0xfffffff8151e7812ULL, 0x000fe200078ee20eULL, 0x00000001130c7824ULL, 0x140fe200078e0204ULL,
0x0000001004157811ULL, 0x000fe200078fe8ffULL, 0x00000008131b7824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee20fULL, 0x0000000119107824ULL, 0x000fe200078e0204ULL,
0x000000700b0f7812ULL, 0x000fe200078ec0ffULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81b207812ULL, 0x000fe200078ee20cULL, 0x00000001150e7824ULL, 0x040fe200078e0204ULL,
0x0000001c041b7811ULL, 0x000fe200078fe8ffULL, 0x00000008151d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f267812ULL, 0x000fe200078ee210ULL, 0x000000800a1a7824ULL, 0x000fe200078e020fULL,
0x00000004040b7211ULL, 0x040fe200078fe8ffULL, 0x000000012d0f7824ULL, 0x000fe200078e020dULL,
0xfffffff81d227812ULL, 0x000fe200078ee20eULL, 0x000000011b0c7824ULL, 0x040fe200078e0204ULL,
0x0000002d040d7211ULL, 0x000fe200078fe8ffULL, 0x000000081b1f7824ULL, 0x000fe200078e00ffULL,
0x000000070b0b7812ULL, 0x000fe200078ec0ffULL, 0x00000002210e7824ULL, 0x000fc400078e020aULL,
0x000000012d1d7824ULL, 0x000fe200078e021bULL, 0xfffffff81f287812ULL, 0x000fe200078ee20cULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x000160000e2b7811ULL, 0x000fe200078e68ffULL,
0x000000012d117824ULL, 0x000fe200078e0211ULL, 0x0ffffff80b0b7812ULL, 0x000fe200078ef804ULL,
0x000000012d137824ULL, 0x000fe400078e0213ULL, 0x000001000d0c7825ULL, 0x000fc800078e001aULL,
0x000000012d157824ULL, 0x000fe200078e0215ULL, 0x000062000c0c7a10ULL, 0x000fe20007f1e0ffULL,
0x000001000f0e7825ULL, 0x000fc600078e001aULL, 0x000063000d0d7a10ULL, 0x000fe200007fe4ffULL,
0x000000012d177824ULL, 0x000fe200078e0217ULL, 0x000062000e0e7a10ULL, 0x000fe20007f3e0ffULL,
0x0000010011107825ULL, 0x000fc600078e001aULL, 0x000063000f0f7a10ULL, 0x000fe20000ffe4ffULL,
0x000000012d197824ULL, 0x000fe200078e0219ULL, 0x0000620010107a10ULL, 0x000fe20007f5e0ffULL,
0x0000010013127825ULL, 0x000fc600078e001aULL, 0x0000630011117a10ULL, 0x000fe200017fe4ffULL,
0x0000010015147825ULL, 0x000fe200078e001aULL, 0x0000620012127a10ULL, 0x000fc60007f7e0ffULL,
0x0000010017167825ULL, 0x100fe200078e001aULL, 0x0000620014147a10ULL, 0x000fe40007f1e0ffULL,
0x0000630013137a10ULL, 0x000fe20001ffe4ffULL, 0x0000010019187825ULL, 0x100fe200078e001aULL,
0x0000620016167a10ULL, 0x000fe40007f3e0ffULL, 0x0000630015157a10ULL, 0x000fe200007fe4ffULL,
0x000001001d1a7825ULL, 0x000fe200078e001aULL, 0x0000620018187a10ULL, 0x000fe40007f5e0ffULL,
0x0000630017177a10ULL, 0x000fe20000ffe4ffULL, 0x000000100b0b7824ULL, 0x100fe200078e022bULL,
0x000062001a1a7a10ULL, 0x000fe20007f7e0ffULL, 0x000000101c1d7824ULL, 0x100fe200078e022bULL,
0x0000630019197a10ULL, 0x000fe200017fe4ffULL, 0x000000101e1f7824ULL, 0x100fe200078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0b7faeULL, 0x0003e2000b901c48ULL,
0x0000001020237824ULL, 0x100fe200078e022bULL, 0x000063001b1b7a10ULL, 0x000fe20001ffe4ffULL,
0x0000001022257824ULL, 0x100fe200078e022bULL, 0x000000000e1d7faeULL, 0x0003e2000b901c48ULL,
0x0000001024277824ULL, 0x000fc400078e022bULL, 0x0000001026297824ULL, 0x100fe200078e022bULL,
0x00000000101f7faeULL, 0x0003e2000b901c48ULL, 0x00000010282b7824ULL, 0x000fc600078e022bULL,
0x0000000012237faeULL, 0x0003e8000b901c48ULL, 0x0000000014257faeULL, 0x0003e8000b901c48ULL,
0x0000000016277faeULL, 0x0003e8000b901c48ULL, 0x0000000018297faeULL, 0x0003e8000b901c48ULL,
0x000000001a2b7faeULL, 0x0003e4000b901c48ULL, 0x000000060300720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff207424ULL, 0x000fe200078e00ffULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff257224ULL, 0x006fe200078e00ffULL,
0x0000000000687805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00007b9000000947ULL, 0x000fea0003800000ULL,
0xff317217ff207424ULL, 0x000fe400078e00ffULL, 0x000000ffff6b7224ULL, 0x000fc400078e00ffULL,
0x00000001030b7810ULL, 0x040fe20007ffe0ffULL, 0x0000010003267824ULL, 0x000fe200078e0208ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000060b00720cULL, 0x000fe40003f06070ULL,
0x00000040260c7810ULL, 0x000fca0007ffe0ffULL, 0x0000660009297a24ULL, 0x020fcc00078e020cULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1e7819ULL, 0x000fe40000011604ULL,
0x0000000c050b7217ULL, 0x000fe40007800000ULL, 0x000000041e147810ULL, 0x040fe20007ffe0ffULL,
0x000000011e137824ULL, 0x040fe200078e0229ULL, 0x000000081e167810ULL, 0x040fe20007ffe0ffULL,
0x000000010b0b7824ULL, 0x000fe200078e0a0cULL, 0x0000000c1e1a7810ULL, 0x000fe20007ffe0ffULL,
0x00000010040c7824ULL, 0x000fe200078e00ffULL, 0x000000141e287810ULL, 0x000fe20007ffe0ffULL,
0x0000000114127824ULL, 0x100fe200078e0204ULL, 0x000000101e247810ULL, 0x000fe20007ffe0ffULL,
0x0000000814277824ULL, 0x000fe200078e00ffULL, 0x000000700c237812ULL, 0x000fe200078ec0ffULL,
0x00000008162b7824ULL, 0x000fe200078e00ffULL, 0x000000200b0b7817ULL, 0x000fe20003800000ULL,
0x000000011a0c7824ULL, 0x000fe200078e0204ULL, 0xfffffff827277812ULL, 0x000fe200078ee212ULL,
0x0000000116127824ULL, 0x000fe200078e0204ULL, 0x00000003246f7819ULL, 0x000fe200000006ffULL,
0x000000800a227824ULL, 0x000fe200078e0223ULL, 0x0000000b1a00720cULL, 0x0c0fe20003f26070ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee212ULL,
0x000000081a6d7824ULL, 0x000fe200078e00ffULL, 0x0000000b1400720cULL, 0x080fe20003f86070ULL,
0x0000010013127825ULL, 0x000fe200078e0022ULL, 0x0000000b1e00720cULL, 0x000fc40003f66070ULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee20cULL, 0x0000000128157824ULL, 0x100fe200078e0204ULL,
0x0000620012187a10ULL, 0x000fe20007f1e0ffULL, 0x00000008281c7824ULL, 0x000fe200078e00ffULL,
0x0000001c1e2a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001240c7824ULL, 0x000fe200078e0204ULL,
0x0000630013197a10ULL, 0x000fe200007fe4ffULL, 0x0000000114137824ULL, 0x000fe200078e0229ULL,
0xfffffff81c717812ULL, 0x000fe200078ee215ULL, 0x000000011a177824ULL, 0x100fe200078e0229ULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee20cULL, 0x0000000116157824ULL, 0x040fe200078e0229ULL,
0x0000000b1600720cULL, 0x000fe20003f06070ULL, 0x000000011e1a7824ULL, 0x000fc400078e0204ULL,
0x0000010013127825ULL, 0x000fc600078e0022ULL, 0x000000071a1b7812ULL, 0x000fe200078ec0ffULL,
0x00000002210c7824ULL, 0x000fe200078e020aULL, 0x00006200121a7a10ULL, 0x000fe20007f5e0ffULL,
0x0000010015147825ULL, 0x000fe200078e0022ULL, 0x0ffffff81b1f7812ULL, 0x000fe400078ef804ULL,
0x000170000c0c7811ULL, 0x000fe200078e68ffULL, 0x0000010017167825ULL, 0x000fe200078e0022ULL,
0x00006200141c7a10ULL, 0x000fe40007fbe0ffULL, 0x00006300131b7a10ULL, 0x000fe200017fe4ffULL,
0x0000000124137824ULL, 0x000fe200078e0229ULL, 0x00006300151d7a10ULL, 0x000fe20002ffe4ffULL,
0x000000101f157824ULL, 0x100fe200078e020cULL, 0x0000620016167a10ULL, 0x000fe20007fde0ffULL,
0x0000001027277824ULL, 0x000fe200078e020cULL, 0x0000000b2400720cULL, 0x080fe20003f46070ULL,
0x0000010013127825ULL, 0x000fe200078e0022ULL, 0x000000181e247810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018157faeULL, 0x0003e2000d901c48ULL,
0x0000630017177a10ULL, 0x000fe200037fe4ffULL, 0x00000001281f7824ULL, 0x040fe200078e0229ULL,
0x0000000b2800720cULL, 0x080fe20003fa6070ULL, 0x000000001a277faeULL, 0x0005e2000e101c48ULL,
0x0000000b2400720cULL, 0x000fc40003f86070ULL, 0x00006200121e7a10ULL, 0x000fe40007fde0ffULL,
0x0000000b2a00720cULL, 0x000fe20003f66070ULL, 0x00000001240b7824ULL, 0x000fe400078e0229ULL,
0x000001001f147825ULL, 0x002fe200078e0022ULL, 0x00006300131f7a10ULL, 0x000fc600037fe4ffULL,
0x000001000b127825ULL, 0x000fe200078e0022ULL, 0x0000620014187a10ULL, 0x000fc60007fde0ffULL,
0x000000012a1b7824ULL, 0x044fe200078e0229ULL, 0x0000630015197a10ULL, 0x000fe200037fe4ffULL,
0x000000012a0b7824ULL, 0x100fe200078e0204ULL, 0x0000620012127a10ULL, 0x000fe20007fde0ffULL,
0x00000001241a7824ULL, 0x040fe400078e0204ULL, 0x0000000824297824ULL, 0x000fe200078e00ffULL,
0x0000630013137a10ULL, 0x000fe200037fe4ffULL, 0x000000082a2a7824ULL, 0x000fe400078e00ffULL,
0x000001001b147825ULL, 0x000fe200078e0022ULL, 0xfffffff829297812ULL, 0x000fc400078ee21aULL,
0xfffffff82a737812ULL, 0x000fe200078ee20bULL, 0x000000102b0b7824ULL, 0x100fe200078e020cULL,
0x0000620014147a10ULL, 0x000fe20007fde0ffULL, 0x000000106d1b7824ULL, 0x100fe400078e020cULL,
0x000000106f237824ULL, 0x100fe200078e020cULL, 0x0000630015157a10ULL, 0x000fe200037fe4ffULL,
0x0000001071277824ULL, 0x100fe200078e020cULL, 0x000000001c0b7faeULL, 0x0003e2000c101c48ULL,
0x0000001029297824ULL, 0x100fe400078e020cULL, 0x00000010732b7824ULL, 0x000fe200078e020cULL,
0x00000000161b7faeULL, 0x0003e8000c901c48ULL, 0x000000001e237faeULL, 0x0003e8000d101c48ULL,
0x0000000018277faeULL, 0x0003e8000e901c48ULL, 0x0000000012297faeULL, 0x0003e8000e101c48ULL,
0x00000000142b7faeULL, 0x0003e2000d901c48ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x0000000c04197811ULL, 0x040fe400078fe8ffULL, 0x0000000804177811ULL, 0x000fc400078fe8ffULL,
0x0000000404157811ULL, 0x040fe200078fe8ffULL, 0x0000000119127824ULL, 0x140fe200078e0204ULL,
0x00000010041b7811ULL, 0x040fe200078fe8ffULL, 0x00000008191d7824ULL, 0x000fe200078e00ffULL,
0x00000018041f7811ULL, 0x040fe200078fe8ffULL, 0x00000001170c7824ULL, 0x040fe200078e0204ULL,
0x0000001c04737811ULL, 0x040fe200078fe8ffULL, 0x0000000817137824ULL, 0x000fe200078e00ffULL,
0xfffffff81d187812ULL, 0x000fe200078ee212ULL, 0x00000001150b7824ULL, 0x040fe200078e0204ULL,
0x00000014041d7811ULL, 0x000fe200078fe8ffULL, 0x0000000815147824ULL, 0x000fe200078e00ffULL,
0xfffffff813167812ULL, 0x000fe200078ee20cULL, 0x000000081b1a7824ULL, 0x000fc400078e00ffULL,
0x000000011d0c7824ULL, 0x140fe200078e0204ULL, 0xfffffff814147812ULL, 0x000fe200078ee20bULL,
0x000000081d137824ULL, 0x000fe400078e00ffULL, 0x000000011b0b7824ULL, 0x100fe400078e0204ULL,
0x000000011f127824ULL, 0x000fe200078e0204ULL, 0xfffffff8131c7812ULL, 0x000fe200078ee20cULL,
0x000000081f237824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee20bULL,
0x0000000173137824ULL, 0x040fe200078e0204ULL, 0x00000004040c7211ULL, 0x040fe200078fe8ffULL,
0x0000000873247824ULL, 0x000fe200078e00ffULL, 0xfffffff8231e7812ULL, 0x000fe200078ee212ULL,
0x00000010040b7824ULL, 0x000fc400078e00ffULL, 0x0000000221127824ULL, 0x000fe200078e020aULL,
0xfffffff824247812ULL, 0x000fe200078ee213ULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x000000070c137812ULL, 0x000fe200078ec0ffULL, 0x0000000115157824ULL, 0x100fe200078e0229ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000117177824ULL, 0x100fe200078e0229ULL,
0x0ffffff8130c7812ULL, 0x000fe200078ef804ULL, 0x0000000119197824ULL, 0x000fe200078e0229ULL,
0x0001700012757811ULL, 0x000fe200078e68ffULL, 0x000000800a227824ULL, 0x000fe200078e020bULL,
0x0000002904137211ULL, 0x000fe200078fe8ffULL, 0x000000011b1b7824ULL, 0x000fc400078e0229ULL,
0x000000011d1d7824ULL, 0x100fe400078e0229ULL, 0x000000011f1f7824ULL, 0x100fe400078e0229ULL,
0x0000000173737824ULL, 0x000fe400078e0229ULL, 0x0000001014277824ULL, 0x000fe400078e0275ULL,
0x0000010013127825ULL, 0x000fc800078e0022ULL, 0x0000001016297824ULL, 0x000fe200078e0275ULL,
0x0000620012127a10ULL, 0x000fe20007f1e0ffULL, 0x0000010015147825ULL, 0x000fc600078e0022ULL,
0x0000630013137a10ULL, 0x000fe200007fe4ffULL, 0x00000010182b7824ULL, 0x000fe200078e0275ULL,
0x0000620014147a10ULL, 0x000fe20007f3e0ffULL, 0x0000010017167825ULL, 0x000fc600078e0022ULL,
0x0000630015157a10ULL, 0x000fe20000ffe4ffULL, 0x0000010019187825ULL, 0x000fe200078e0022ULL,
0x0000620016167a10ULL, 0x000fc60007f5e0ffULL, 0x000000101a6d7824ULL, 0x100fe200078e0275ULL,
0x0000620018187a10ULL, 0x000fe20007f7e0ffULL, 0x000000101c6f7824ULL, 0x000fe200078e0275ULL,
0x0000630017177a10ULL, 0x000fe200017fe4ffULL, 0x000001001b1a7825ULL, 0x000fe200078e0022ULL,
0x0000630019197a10ULL, 0x000fc60001ffe4ffULL, 0x000000101e717824ULL, 0x000fe200078e0275ULL,
0x000062001a1a7a10ULL, 0x000fe20007f1e0ffULL, 0x000001001d1c7825ULL, 0x000fc600078e0022ULL,
0x000063001b1b7a10ULL, 0x000fe200007fe4ffULL, 0x000001001f1e7825ULL, 0x000fe200078e0022ULL,
0x000062001c1c7a10ULL, 0x000fc60007f3e0ffULL, 0x0000010073227825ULL, 0x000fe200078e0022ULL,
0x000062001e1e7a10ULL, 0x000fe40007f5e0ffULL, 0x000063001d1d7a10ULL, 0x000fe20000ffe4ffULL,
0x000000100c0b7824ULL, 0x100fe200078e0275ULL, 0x0000620022227a10ULL, 0x000fe20007f7e0ffULL,
0x0000001024757824ULL, 0x000fe200078e0275ULL, 0x000063001f1f7a10ULL, 0x000fe400017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000120b7faeULL, 0x0003e2000b901c48ULL,
0x0000630023237a10ULL, 0x000fc60001ffe4ffULL, 0x0000000014277faeULL, 0x0003e8000b901c48ULL,
0x0000000016297faeULL, 0x0003e8000b901c48ULL, 0x00000000182b7faeULL, 0x0003e8000b901c48ULL,
0x000000001a6d7faeULL, 0x0003e8000b901c48ULL, 0x000000001c6f7faeULL, 0x0003e8000b901c48ULL,
0x000000001e717faeULL, 0x0003e8000b901c48ULL, 0x0000000022757faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe0070b7812ULL, 0x002fc400078ec0ffULL,
0x00000010070c7812ULL, 0x000fca00078ec0ffULL, 0x000000010b0b7824ULL, 0x000fc800078e020cULL,
0x000000080a167824ULL, 0x000fe200078e020bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e6080016167f8cULL, 0x000e64000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x00000008070c7812ULL, 0x000fca00078ec0ffULL, 0x000000010b0c7824ULL, 0x000fca00078e020cULL,
0x01e60c000c0b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x006fe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001412147210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011415ULL,
0x000000140b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff147224ULL, 0x000fca00000e0615ULL,
0x000000020b0b7819ULL, 0x000fc80000001214ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000118187810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e60c000c0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020000c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff137819ULL, 0x000fe20000011604ULL,
0x00000010040b7824ULL, 0x000fc600078e00ffULL, 0xffffff800c127812ULL, 0x000fe400078ec0ffULL,
0x000000700b0b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c130c7812ULL, 0x000fc800078ec0ffULL,
0x000000120c127210ULL, 0x000fca0007ffe00bULL, 0x01e0000012137984ULL, 0x000e680000000800ULL,
0x01e2000012147984ULL, 0x0004e20000000800ULL, 0x000000201300720bULL, 0x002fe20003f1d000ULL,
0x000166327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000127806ULL, 0x004fc800000e0100ULL,
0x000000ff1200720cULL, 0x000fe20003f25270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff1b7224ULL, 0x000fd400078e0020ULL,
0x0000071000009947ULL, 0x000fea0003800000ULL, 0x00000002ff157819ULL, 0x000fe40000011600ULL,
0x000000201300720bULL, 0x000fe40003f54000ULL, 0x000000001500720cULL, 0x000fe20003f25270ULL,
0x000165f27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000157806ULL, 0x000fc400010e0100ULL,
0x0000008000179824ULL, 0x000fe200078e020bULL, 0x00000020131b7209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010c169824ULL, 0x000fca00078e0217ULL,
0x01e4001b16009388ULL, 0x0003e20000000800ULL, 0x000000ff1500720cULL, 0x000fda0003f25270ULL,
0x000005e000009947ULL, 0x000fea0003800000ULL, 0x000000201b167221ULL, 0x002fe20000010100ULL,
0x000000ff15ff7812ULL, 0x000fe2000782c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b16167820ULL, 0x000fcc0000410000ULL, 0x0000001600167308ULL, 0x000e640000000800ULL,
0x0000001625257220ULL, 0x002fe40000410000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe20000011604ULL, 0x000165427f007947ULL, 0x000fea000b800000ULL,
0x00001f2916297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0015ff7812ULL, 0x000fe2000782c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x0000000804297811ULL, 0x000fe200078ff0ffULL,
0x000164327f007947ULL, 0x000fea000b800000ULL, 0x00001f2916297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000015ff7812ULL, 0x000fe2000782c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x0000001004297811ULL, 0x000fe200078ff0ffULL, 0x000163227f007947ULL, 0x000fea000b800000ULL,
0x00001f2916297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000015ff7812ULL, 0x000fda000782c0ffULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x0000001804297811ULL, 0x000fe200078ff0ffULL, 0x000162227f007947ULL, 0x000fea000b800000ULL,
0x00001f2916297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000001512ff7212ULL, 0x000fda00078230ffULL, 0x8000001b13131221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b13131820ULL, 0x000fc80000410000ULL,
0x00000013000d1308ULL, 0x000e640000000800ULL, 0x0000000d14141220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000002514257221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x0000000dff0e723eULL, 0x000fe400000000ffULL,
0x00000002ff117819ULL, 0x000fe40000011604ULL, 0x000054100e127816ULL, 0x000fe2000000000eULL,
0x000160727f007947ULL, 0x000fea000b800000ULL, 0x00001f11120e7589ULL, 0x0002a400000e0000ULL,
0x0000000811297810ULL, 0x000fe20007ffe0ffULL, 0x000160c27f007947ULL, 0x000fea000b800000ULL,
0x0000001011137810ULL, 0x000fe20007ffe0ffULL, 0x00001f29120f7589ULL, 0x00066800000e0000ULL,
0x00001f1312107589ULL, 0x0006a400000e0000ULL, 0x0000001811297810ULL, 0x008fe20007ffe0ffULL,
0x000161527f007947ULL, 0x000fea000b800000ULL, 0x00001f2912117589ULL, 0x0022e400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000421127824ULL, 0x042fe200078e00ffULL,
0x0000000804137812ULL, 0x000fe200078ec0ffULL, 0x0000040000157824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000221247824ULL, 0x000fe200078e020aULL,
0x00000004121d7812ULL, 0x000fe200078ec0ffULL, 0x0000029000007945ULL, 0x000fe20003800000ULL,
0x0000000713127812ULL, 0x000fe200078ef804ULL, 0x0000200024247824ULL, 0x000fe200078e00ffULL,
0x0000001d04147211ULL, 0x000fc400078fe0ffULL, 0x0000001012137812ULL, 0x040fe200078efcffULL,
0x0000000812167824ULL, 0x040fe200078e00ffULL, 0xfffff00015157812ULL, 0x000fe200078ec0ffULL,
0x0000000112197824ULL, 0x000fe200078e0214ULL, 0x0000001204177211ULL, 0x000fe200078fe0ffULL,
0x00000001141a7824ULL, 0x000fe200078e0213ULL, 0x00012000151e7810ULL, 0x000fe20007ffe0ffULL,
0x00000008131f7824ULL, 0x000fe200078e00ffULL, 0xfffffff816197812ULL, 0x000fe200078ee219ULL,
0x0000000812217824ULL, 0x040fe200078e00ffULL, 0x0000000417187810ULL, 0x000fe20007ffe0ffULL,
0x0000000812237824ULL, 0x040fe200078e00ffULL, 0xfffffff81f1a7812ULL, 0x000fe200078ee21aULL,
0x00000008121f7824ULL, 0x000fe200078e00ffULL, 0x00000006171c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001019787824ULL, 0x100fe200078e021eULL, 0x0000000217147810ULL, 0x000fe20007ffe0ffULL,
0x000000101a287824ULL, 0x000fe200078e021eULL, 0xfffffff816167812ULL, 0x000fc400078ee217ULL,
0xfffffff81f177812ULL, 0x000fe200078ee218ULL, 0x000000007878783bULL, 0x000e620000000200ULL,
0xfffffff821187812ULL, 0x000fe400078ee21cULL, 0xfffffff823147812ULL, 0x000fe200078ee214ULL,
0x000000002828783bULL, 0x000ee20000000200ULL, 0x00016000241c7810ULL, 0x000fca0007ffe0ffULL,
0x0000001016747824ULL, 0x100fe400078e021cULL, 0x0000001014707824ULL, 0x100fe400078e021cULL,
0x0000001017207824ULL, 0x000fe200078e021cULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000e78787232ULL, 0x086fe40000000000ULL, 0x0000000e7a7a7232ULL, 0x000fe40000000000ULL,
0x0000000f79797232ULL, 0x080fe40000000000ULL, 0x0000000f7b7b7232ULL, 0x000fc40000000000ULL,
0x0000001028287232ULL, 0x088fe40000000000ULL, 0x000000102a2a7232ULL, 0x000fe40000000000ULL,
0x0000001129297232ULL, 0x080fe40000000000ULL, 0x000000112b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010186c7824ULL, 0x000fe200078e021cULL,
0x000000002020783bULL, 0x000f220000004200ULL, 0x000000021d1d7812ULL, 0x000fe200078efcffULL,
0x0000000813277824ULL, 0x000fe200078e00ffULL, 0x0000036000007945ULL, 0x000fe20003800000ULL,
0x000000007070783bULL, 0x000fe20000004200ULL, 0x0000001d041d7211ULL, 0x000fc600078fe0ffULL,
0x000000006c6c783bULL, 0x000ee40000004200ULL, 0x00000001121f7824ULL, 0x140fe400078e021dULL,
0x000000007474783bULL, 0x000ea20000004200ULL, 0x00000001131d7824ULL, 0x040fe200078e021dULL,
0x00000020783c723cULL, 0x092f70000000183cULL, 0x00000020285c723cULL, 0x008b6e000000185cULL,
0x0000000812207824ULL, 0x020fe200078e00ffULL, 0x0000006c7844723cULL, 0x000f620000001844ULL,
0x0000000813217824ULL, 0x000fc600078e00ffULL, 0xfffffff8201f7812ULL, 0x000fe400078ee21fULL,
0x0000001304207211ULL, 0x000fe400078fe0ffULL, 0x0000006c2864723cULL, 0x000b620000001864ULL,
0x000000101f1f7824ULL, 0x000fe200078e021eULL, 0xfffffff821217812ULL, 0x000fc800078ee220ULL,
0x000000001f7c783bULL, 0x0002e20000000200ULL, 0x00000008136c7824ULL, 0x060fe200078e00ffULL,
0x000000707834723cULL, 0x000f620000001834ULL, 0x00000008136d7824ULL, 0x000fc600078e00ffULL,
0xfffffff86c1d7812ULL, 0x000fc800078ee21dULL, 0x000000702854723cULL, 0x000b620000001854ULL,
0x000000101d1d7824ULL, 0x000fcc00078e021eULL, 0x0000000813707824ULL, 0x020fe200078e00ffULL,
0x000000227840723cULL, 0x080f700000001840ULL, 0x000000222860723cULL, 0x040b6e0000001860ULL,
0x0000000220227810ULL, 0x060fe20007ffe0ffULL, 0x00000074284c723cULL, 0x004f62000000184cULL,
0x0000000420237810ULL, 0x000fc40007ffe0ffULL, 0xfffffff827227812ULL, 0x000fe400078ee222ULL,
0xfffffff870237812ULL, 0x000fe400078ee223ULL, 0x0000000620207810ULL, 0x000fe20007ffe0ffULL,
0x000000762850723cULL, 0x000f640000001850ULL, 0x0000001023707824ULL, 0x000fe200078e021cULL,
0xfffffff86d207812ULL, 0x000fca00078ee220ULL, 0x000000722858723cULL, 0x040f700000001858ULL,
0x0000006e2868723cULL, 0x000b640000001868ULL, 0x000000001d28783bULL, 0x0202ac0000000200ULL,
0x00000074782c723cULL, 0x040b6e000000182cULL, 0x0000001022747824ULL, 0x120fe200078e021cULL,
0x000000767830723cULL, 0x040f700000001830ULL, 0x000000727838723cULL, 0x040f700000001838ULL,
0x0000006e7848723cULL, 0x000b6e0000001848ULL, 0x0000001021787824ULL, 0x020fe200078e021cULL,
0x0000008000008947ULL, 0x000fd60003800000ULL, 0x0000000e7c7c7232ULL, 0x08afe40000000000ULL,
0x0000000e7e7e7232ULL, 0x000fc40000000000ULL, 0x0000000f7d7d7232ULL, 0x080fe40000000000ULL,
0x0000000f7f7f7232ULL, 0x000fe40000000000ULL, 0x0000001028287232ULL, 0x084fe40000000000ULL,
0x000000102a2a7232ULL, 0x000fe40000000000ULL, 0x0000001129297232ULL, 0x080fe40000000000ULL,
0x000000112b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x00afea0003800000ULL,
0x00000010206c7824ULL, 0x000fe200078e021cULL, 0x000000007878783bULL, 0x000e620000004200ULL,
0x00000002001d7824ULL, 0x000fc600078e00ffULL, 0x000000007474783bULL, 0x000ee40000004200ULL,
0xfffffff81d1d7812ULL, 0x000fe400078ec0ffULL, 0x000000007070783bULL, 0x000f280000004200ULL,
0x000000006c6c783bULL, 0x000ea20000004200ULL, 0x000000787c2c723cULL, 0x042b70000000182cULL,
0x0000007a7c30723cULL, 0x040b700000001830ULL, 0x000000747c34723cULL, 0x048b700000001834ULL,
0x000000767c38723cULL, 0x040b700000001838ULL, 0x000000707c3c723cULL, 0x050b70000000183cULL,
0x000000727c40723cULL, 0x040b700000001840ULL, 0x0000006c7c44723cULL, 0x044b700000001844ULL,
0x0000006e7c48723cULL, 0x000b700000001848ULL, 0x00000078284c723cULL, 0x040b70000000184cULL,
0x0000007a2850723cULL, 0x040b700000001850ULL, 0x000000742854723cULL, 0x040b700000001854ULL,
0x000000762858723cULL, 0x040b700000001858ULL, 0x00000070285c723cULL, 0x040b70000000185cULL,
0x000000722860723cULL, 0x040b700000001860ULL, 0x0000006c2864723cULL, 0x040b700000001864ULL,
0x0000006e2868723cULL, 0x000b620000001868ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000001031f7810ULL, 0x000fe20007ffe0ffULL, 0x01e688001dff7f8cULL, 0x0003e2000c80043fULL,
0x00000080261e7810ULL, 0x000fc40007ffe0ffULL, 0x000000061f00720cULL, 0x000fc60003f06070ULL,
0x00006600097b7a24ULL, 0x020fe200078e021eULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000061000008947ULL, 0x000fea0003800000ULL, 0x00000003ff747819ULL, 0x002fe40000011604ULL,
0x0000001e051d7217ULL, 0x000fe40007800000ULL, 0x0000000474287810ULL, 0x040fe20007ffe0ffULL,
0x0000000174297824ULL, 0x040fe200078e027bULL, 0x00000008746c7810ULL, 0x040fe20007ffe0ffULL,
0x000000011d1d7824ULL, 0x000fe200078e0a1eULL, 0x0000000c74727810ULL, 0x000fe20007ffe0ffULL,
0x00000001281f7824ULL, 0x100fe200078e0204ULL, 0x000000046c277210ULL, 0x000fe20007ffe0ffULL,
0x00000008282a7824ULL, 0x000fe200078e00ffULL, 0x000000201d1d7817ULL, 0x000fe20003800000ULL,
0x000000086c6e7824ULL, 0x000fe200078e00ffULL, 0x0000001074767810ULL, 0x000fe20007ffe0ffULL,
0x000000800a1e7824ULL, 0x000fe200078e020bULL, 0xfffffff82a777812ULL, 0x000fe200078ee21fULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0xfffffff86e7d7812ULL, 0x000fe200078ee227ULL,
0x00000001282b7824ULL, 0x040fe200078e027bULL, 0x0000001d2800720cULL, 0x080fe20003f86070ULL,
0x0000000172277824ULL, 0x040fe200078e0204ULL, 0x0000001d7200720cULL, 0x0c0fe20003f46070ULL,
0x00000008726e7824ULL, 0x000fe200078e00ffULL, 0x0000001d6c00720cULL, 0x080fe20003f66070ULL,
0x0000010029287825ULL, 0x000fe200078e001eULL, 0x0000001d7400720cULL, 0x000fc40003fa6070ULL,
0xfffffff86e7f7812ULL, 0x000fe200078ee227ULL, 0x000001002b2a7825ULL, 0x000fe200078e001eULL,
0x00006200286e7a10ULL, 0x000fc60007f1e0ffULL, 0x00000001766d7824ULL, 0x000fe200078e0204ULL,
0x000062002a707a10ULL, 0x000fe20007f3e0ffULL, 0x0000000876787824ULL, 0x000fe200078e00ffULL,
0x00006300296f7a10ULL, 0x000fe200007fe4ffULL, 0x000000016c297824ULL, 0x100fe200078e027bULL,
0x000063002b717a10ULL, 0x000fe20000ffe4ffULL, 0x00000001722b7824ULL, 0x000fe200078e027bULL,
0xfffffff878857812ULL, 0x000fe200078ee26dULL, 0x0000010029287825ULL, 0x000fe200078e001eULL,
0x0000001474787810ULL, 0x000fe40007ffe0ffULL, 0x0000001d7600720cULL, 0x040fe20003f26070ULL,
0x00000001766d7824ULL, 0x000fe200078e027bULL, 0x0000620028727a10ULL, 0x000fe20007f1e0ffULL,
0x0000000174277824ULL, 0x000fc400078e0204ULL, 0x0000000178737824ULL, 0x040fe400078e0204ULL,
0x0000000878767824ULL, 0x000fe200078e00ffULL, 0x0000000727277812ULL, 0x000fe200078ec0ffULL,
0x000001002b2a7825ULL, 0x000fc600078e001eULL, 0xfffffff876877812ULL, 0x000fe200078ee273ULL,
0x000001006d6c7825ULL, 0x000fe200078e001eULL, 0x000062002a2a7a10ULL, 0x000fe40007fde0ffULL,
0x0000630029737a10ULL, 0x000fe200007fe4ffULL, 0x0000000178297824ULL, 0x000fe200078e027bULL,
0x0ffffff827277812ULL, 0x000fe200078ef804ULL, 0x0000001077777824ULL, 0x000fe200078e021cULL,
0x000063002b2b7a10ULL, 0x000fe200037fe4ffULL, 0x0000010029287825ULL, 0x000fe200078e001eULL,
0x000062006c6c7a10ULL, 0x000fc40007fde0ffULL, 0x0000001874767810ULL, 0x000fe20007ffe0ffULL,
0x0000001027277824ULL, 0x000fe200078e021cULL, 0x0000001d7800720cULL, 0x080fe40003f06070ULL,
0x000063006d6d7a10ULL, 0x000fe200037fe4ffULL, 0x0000000176797824ULL, 0x000fe200078e027bULL,
0x0000001c74787810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e277faeULL, 0x0003e2000e901c48ULL, 0x0000620028747a10ULL, 0x000fe40007fde0ffULL,
0x0000001d7600720cULL, 0x080fe20003fa6070ULL, 0x0000000070777faeULL, 0x0005e2000e101c48ULL,
0x0000630029757a10ULL, 0x000fe200037fe4ffULL, 0x0000010079287825ULL, 0x000fe200078e001eULL,
0x0000001d7800720cULL, 0x000fc60003f86070ULL, 0x00000001781d7824ULL, 0x000fe200078e027bULL,
0x0000620028287a10ULL, 0x000fe20007fde0ffULL, 0x0000000176277824ULL, 0x142fe400078e0204ULL,
0x0000000876767824ULL, 0x000fe200078e00ffULL, 0x0000630029297a10ULL, 0x000fe200037fe4ffULL,
0x00000001786e7824ULL, 0x040fe400078e0204ULL, 0x0000000878797824ULL, 0x000fe200078e00ffULL,
0xfffffff876777812ULL, 0x004fe200078ee227ULL, 0x000001001d1e7825ULL, 0x000fc600078e001eULL,
0xfffffff879797812ULL, 0x000fe200078ee26eULL, 0x000000107d1d7824ULL, 0x100fe200078e021cULL,
0x000062001e1e7a10ULL, 0x000fe20007fde0ffULL, 0x000000107f277824ULL, 0x100fe400078e021cULL,
0x00000010856f7824ULL, 0x100fe200078e021cULL, 0x000063001f1f7a10ULL, 0x000fe200037fe4ffULL,
0x0000001087717824ULL, 0x100fe200078e021cULL, 0x00000000721d7faeULL, 0x0003e2000d901c48ULL,
0x0000001077777824ULL, 0x100fe400078e021cULL, 0x0000001079797824ULL, 0x000fe200078e021cULL,
0x000000002a277faeULL, 0x0003e8000d101c48ULL, 0x000000006c6f7faeULL, 0x0003e8000c901c48ULL,
0x0000000074717faeULL, 0x0003e8000c101c48ULL, 0x0000000028777faeULL, 0x0003e8000e901c48ULL,
0x000000001e797faeULL, 0x0003e2000e101c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000000404297811ULL, 0x002fe200078fe8ffULL, 0x000000800a747824ULL, 0x000fe200078e020bULL,
0x00000008042b7811ULL, 0x040fe200078fe8ffULL, 0x000000ffff757224ULL, 0x000fe200078e00ffULL,
0x0000000c046d7811ULL, 0x040fe200078fe8ffULL, 0x00000001291d7824ULL, 0x140fe200078e0204ULL,
0x00000010046f7811ULL, 0x040fe200078fe8ffULL, 0x0000000829287824ULL, 0x000fe200078e00ffULL,
0x0000001404717811ULL, 0x040fe200078fe8ffULL, 0x000000012b1e7824ULL, 0x140fe200078e0204ULL,
0x0000001804737811ULL, 0x000fe200078fe8ffULL, 0x000000082b797824ULL, 0x000fe200078e00ffULL,
0xfffffff828777812ULL, 0x000fe200078ee21dULL, 0x000000016d1d7824ULL, 0x000fc400078e0204ULL,
0x000000086d287824ULL, 0x000fe200078e00ffULL, 0xfffffff879797812ULL, 0x000fe200078ee21eULL,
0x000000016f1e7824ULL, 0x140fe400078e0204ULL, 0x000000086f7f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8287d7812ULL, 0x000fe200078ee21dULL, 0x00000001711f7824ULL, 0x040fe200078e0204ULL,
0x00000004041d7211ULL, 0x040fe200078fe8ffULL, 0x00000008712a7824ULL, 0x000fe200078e00ffULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee21eULL, 0x0000000173277824ULL, 0x040fe200078e0204ULL,
0x0000001c041e7811ULL, 0x000fe200078fe8ffULL, 0x00000008736c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a857812ULL, 0x000fe200078ee21fULL, 0x0000000129297824ULL, 0x100fe200078e027bULL,
0x0000007b041f7211ULL, 0x000fe200078fe8ffULL, 0x000000012b2b7824ULL, 0x000fe200078e027bULL,
0xfffffff86c877812ULL, 0x000fe200078ee227ULL, 0x000000016d6d7824ULL, 0x100fe200078e027bULL,
0x000000071d277812ULL, 0x000fe200078ec0ffULL, 0x000000016f6f7824ULL, 0x000fc400078e027bULL,
0x0000000171717824ULL, 0x100fe200078e027bULL, 0x0ffffff827277812ULL, 0x100fe200078ef804ULL,
0x0000000173737824ULL, 0x100fe400078e027bULL, 0x000000011e1d7824ULL, 0x040fe400078e027bULL,
0x000000011e767824ULL, 0x040fe400078e0204ULL, 0x000000081e7b7824ULL, 0x000fe400078e00ffULL,
0x000001001f1e7825ULL, 0x000fc800078e0074ULL, 0x0000010029287825ULL, 0x000fc800078e0074ULL,
0x000001002b2a7825ULL, 0x000fc800078e0074ULL, 0x000001006d6c7825ULL, 0x000fc800078e0074ULL,
0x000001006f6e7825ULL, 0x000fc800078e0074ULL, 0x0000010071707825ULL, 0x000fc800078e0074ULL,
0x0000010073727825ULL, 0x000fc800078e0074ULL, 0x000001001d747825ULL, 0x000fe200078e0074ULL,
0xfffffff87b1d7812ULL, 0x000fc600078ee276ULL, 0x000000107d7b7824ULL, 0x100fe400078e021cULL,
0x000000107f7d7824ULL, 0x100fe400078e021cULL, 0x00000010857f7824ULL, 0x100fe400078e021cULL,
0x0000001087857824ULL, 0x100fe400078e021cULL, 0x0000001027277824ULL, 0x100fe400078e021cULL,
0x0000001077777824ULL, 0x000fc400078e021cULL, 0x0000001079797824ULL, 0x100fe400078e021cULL,
0x000000101d877824ULL, 0x000fe200078e021cULL, 0x000062001e1c7a10ULL, 0x000fe40007f1e0ffULL,
0x00006200281e7a10ULL, 0x000fe40007f3e0ffULL, 0x000062002a287a10ULL, 0x000fe40007f5e0ffULL,
0x000062006c2a7a10ULL, 0x000fe40007f7e0ffULL, 0x000063001f1d7a10ULL, 0x000fc400007fe4ffULL,
0x00006300291f7a10ULL, 0x000fe40000ffe4ffULL, 0x000062006e6c7a10ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c277faeULL, 0x0003e2000b901c48ULL,
0x000063002b297a10ULL, 0x000fe400017fe4ffULL, 0x00006200706e7a10ULL, 0x000fe20007f3e0ffULL,
0x000000001e777faeULL, 0x0003e2000b901c48ULL, 0x000063006d2b7a10ULL, 0x000fe40001ffe4ffULL,
0x0000620072707a10ULL, 0x000fe20007f5e0ffULL, 0x0000000028797faeULL, 0x0003e2000b901c48ULL,
0x0000620074727a10ULL, 0x000fc40007f7e0ffULL, 0x000063006f6d7a10ULL, 0x000fe200007fe4ffULL,
0x000000002a7b7faeULL, 0x0003e2000b901c48ULL, 0x00006300716f7a10ULL, 0x000fe40000ffe4ffULL,
0x0000630073717a10ULL, 0x000fe200017fe4ffULL, 0x000000006c7d7faeULL, 0x0003e2000b901c48ULL,
0x0000630075737a10ULL, 0x000fc60001ffe4ffULL, 0x000000006e7f7faeULL, 0x0003e8000b901c48ULL,
0x0000000070857faeULL, 0x0003e8000b901c48ULL, 0x0000000072877faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe0071e7812ULL, 0x042fe400078ec0ffULL,
0x00000010071f7812ULL, 0x000fc400078ec0ffULL, 0x0000000807287812ULL, 0x000fc800078ec0ffULL,
0x0000001e28287210ULL, 0x000fe20007ffe01fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e6280028287f8cULL, 0x000e64000c80043fULL, 0x00000000001c7805ULL, 0x000fc40000015200ULL,
0x000000011e1f7824ULL, 0x000fc800078e021fULL, 0x000000080a2a7824ULL, 0x000fca00078e021fULL,
0x01e62c002a1f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x006fe40007804829ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e1c277210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e1dULL, 0x003d09002700780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402700780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1e7819ULL, 0x000fc8000001141fULL,
0x000000271e1e7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e061fULL,
0x000000021e1e7819ULL, 0x000fc8000000121fULL, 0x0000001e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012b2b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e62c002a1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020001c7824ULL, 0x000fca00078e00ffULL, 0xffffff801c1c7812ULL, 0x000fc800078ec0ffULL,
0x000000800b1d7810ULL, 0x000fc80007ffe01cULL, 0x0000001d0c1d7210ULL, 0x000fca0007ffe0ffULL,
0x01e000001d1c7984ULL, 0x000e680000000800ULL, 0x01e200001d1e7984ULL, 0x0004e20000000800ULL,
0x0000001b1c00720bULL, 0x002fe20003f1d000ULL, 0x000149f27f007947ULL, 0x000fd8000b800000ULL,
0x00000000001d7806ULL, 0x004fc800000e0100ULL, 0x000000ff1d00720cULL, 0x000fe20003f25270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff277224ULL, 0x000fd400078e001bULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x00000001001f7811ULL, 0x000fe400078ff0ffULL, 0x0000001b1c00720bULL, 0x000fe40003f34000ULL,
0x000000001f00720cULL, 0x000fe20003f05270ULL, 0x000149b27f007947ULL, 0x000fd4000b800000ULL,
0x00000000006e7806ULL, 0x000fc400008e0100ULL, 0x0000008000278824ULL, 0x000fe200078e020bULL,
0x0000001b1c1f8209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x000000010c288824ULL, 0x000fca00078e0227ULL, 0x01e4001f28008388ULL, 0x0003e20000000800ULL,
0x000000ff6e00720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000001b1c287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff6eff7812ULL, 0x000fc6000780c0ffULL, 0x0000001b281f7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1f1f7820ULL, 0x000fc80000410000ULL, 0x0000001f00707308ULL, 0x000e640000000800ULL,
0x0000007025257220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe20000011604ULL, 0x000148f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2970297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff006eff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000804297811ULL, 0x000fe200078ff0ffULL,
0x000147e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2970297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00006eff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001004297811ULL, 0x000fe200078ff0ffULL, 0x000146d27f007947ULL, 0x000fea000b800000ULL,
0x00001f2970297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000006eff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001804297811ULL, 0x000fe200078ff0ffULL, 0x000145d27f007947ULL, 0x000fea000b800000ULL,
0x00001f2970297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006e1dff7212ULL, 0x000fe400078030ffULL, 0x0000001b1c277209ULL, 0x000fd60007810000ULL,
0x800000271c1c0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b1c1c0820ULL, 0x000fc80000410000ULL,
0x0000001c000d0308ULL, 0x000e640000000800ULL, 0x0000000d1e1e0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000251e257221ULL, 0x008fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x0000000dff0e723eULL, 0x000fe400000000ffULL, 0x00000002ff1c7819ULL, 0x000fe40000011604ULL,
0x000054100e117816ULL, 0x000fe2000000000eULL, 0x000144327f007947ULL, 0x000fea000b800000ULL,
0x00001f1c110e7589ULL, 0x0002a400000e0000ULL, 0x000000081c297810ULL, 0x000fe20007ffe0ffULL,
0x000144827f007947ULL, 0x000fea000b800000ULL, 0x000000101c107810ULL, 0x000fe20007ffe0ffULL,
0x00001f29110f7589ULL, 0x00066a00000e0000ULL, 0x00001f1011107589ULL, 0x0006a400000e0000ULL,
0x000000181c297810ULL, 0x008fe20007ffe0ffULL, 0x000145127f007947ULL, 0x000fea000b800000ULL,
0x00001f2911117589ULL, 0x0022e400000e0000ULL, 0x00002000001b7824ULL, 0x000fe200078e00ffULL,
0x00013000157c7810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000014000007945ULL, 0x000fe40003800000ULL, 0xffffc0001b1b7812ULL, 0x000fe200078ec0ffULL,
0x0000001019197824ULL, 0x000fc400078e027cULL, 0x000000101a1a7824ULL, 0x000fe400078e027cULL,
0x000020000a1b7824ULL, 0x000fe200078e021bULL, 0x000000001978783bULL, 0x0002e80000000200ULL,
0x000170001b1b7810ULL, 0x000fe20007ffe0ffULL, 0x000000001a1c783bULL, 0x0002a80000000200ULL,
0x0000001016747824ULL, 0x000fc400078e021bULL, 0x0000001014707824ULL, 0x100fe400078e021bULL,
0x00000010176c7824ULL, 0x000fe200078e021bULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000e78787232ULL, 0x08efe40000000000ULL, 0x0000000e7a7a7232ULL, 0x000fe40000000000ULL,
0x0000000f79797232ULL, 0x080fe40000000000ULL, 0x0000000f7b7b7232ULL, 0x000fe40000000000ULL,
0x000000101c1c7232ULL, 0x000fc40000000000ULL, 0x000000101e1e7232ULL, 0x000fe40000000000ULL,
0x000000111d1d7232ULL, 0x080fe40000000000ULL, 0x000000111f1f7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x002fea0003800000ULL, 0x0000001018287824ULL, 0x000fe200078e021bULL,
0x000000007474783bULL, 0x000e620000004200ULL, 0x0000000200197824ULL, 0x000fe200078e00ffULL,
0x000002e000007945ULL, 0x000fe40003800000ULL, 0x000000007070783bULL, 0x000fe40000004200ULL,
0x0000000419197812ULL, 0x000fc400078ec0ffULL, 0x000000002828783bULL, 0x000f240000004200ULL,
0x0000000219197812ULL, 0x000fe400078efcffULL, 0x000000006c6c783bULL, 0x000ee40000004200ULL,
0x0000001904197211ULL, 0x000fca00078fe0ffULL, 0x00000001121a7824ULL, 0x140fe400078e0219ULL,
0x00000001131b7824ULL, 0x040fe200078e0219ULL, 0x00000074782c723cULL, 0x04af70000000182cULL,
0x000000287844723cULL, 0x090f700000001844ULL, 0x000000281c64723cULL, 0x004b6e0000001864ULL,
0x0000000812297824ULL, 0x020fe200078e00ffULL, 0x0000002a7848723cULL, 0x000f620000001848ULL,
0x0000000813287824ULL, 0x000fc600078e00ffULL, 0xfffffff829197812ULL, 0x000fe400078ee21aULL,
0xfffffff8281a7812ULL, 0x000fe400078ee21bULL, 0x00017000241b7810ULL, 0x000fe20007ffe0ffULL,
0x00000010197d7824ULL, 0x100fe200078e027cULL, 0x0000002a1c68723cULL, 0x000b620000001868ULL,
0x000000101a287824ULL, 0x000fc800078e027cULL, 0x000000007d7c783bULL, 0x000e660000000200ULL,
0x000000767830723cULL, 0x040f640000001830ULL, 0x000000002828783bULL, 0x020eac0000000200ULL,
0x000000707834723cULL, 0x040f700000001834ULL, 0x000000727838723cULL, 0x040f700000001838ULL,
0x0000006c783c723cULL, 0x040f70000000183cULL, 0x0000006e7840723cULL, 0x000f700000001840ULL,
0x000000741c4c723cULL, 0x040f70000000184cULL, 0x000000761c50723cULL, 0x040f700000001850ULL,
0x000000701c54723cULL, 0x040f700000001854ULL, 0x000000721c58723cULL, 0x040f700000001858ULL,
0x0000006c1c5c723cULL, 0x040f70000000185cULL, 0x0000006e1c60723cULL, 0x000b6e0000001860ULL,
0x00000010211c7824ULL, 0x020fc400078e021bULL, 0x00000010221d7824ULL, 0x100fe400078e021bULL,
0x00000010231e7824ULL, 0x000fe200078e021bULL, 0x0000008000008947ULL, 0x000fce0003800000ULL,
0x0000000e7c7c7232ULL, 0x086fe40000000000ULL, 0x0000000e7e7e7232ULL, 0x000fe40000000000ULL,
0x0000000f7d7d7232ULL, 0x080fe40000000000ULL, 0x0000000f7f7f7232ULL, 0x000fe40000000000ULL,
0x0000001028287232ULL, 0x000fc40000000000ULL, 0x000000102a2a7232ULL, 0x000fe40000000000ULL,
0x0000001129297232ULL, 0x080fe40000000000ULL, 0x000000112b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x006fea0003800000ULL, 0x00000010201f7824ULL, 0x000fe200078e021bULL,
0x000000001c78783bULL, 0x000e680000004200ULL, 0x000000001d74783bULL, 0x000ea80000004200ULL,
0x000000001e70783bULL, 0x000ee80000004200ULL, 0x000000001f6c783bULL, 0x000f220000004200ULL,
0x000000787c2c723cULL, 0x042f70000000182cULL, 0x0000007a7c30723cULL, 0x040f700000001830ULL,
0x000000747c34723cULL, 0x044f700000001834ULL, 0x000000767c38723cULL, 0x040f700000001838ULL,
0x000000707c3c723cULL, 0x048f70000000183cULL, 0x000000727c40723cULL, 0x040f700000001840ULL,
0x0000006e7c48723cULL, 0x050f700000001848ULL, 0x0000006c7c44723cULL, 0x080f700000001844ULL,
0x0000006c2864723cULL, 0x040b6e0000001864ULL, 0x00000002ff6c7819ULL, 0x020fe20000011600ULL,
0x00000078284c723cULL, 0x040f70000000184cULL, 0x0000007a2850723cULL, 0x040f700000001850ULL,
0x000000742854723cULL, 0x040f700000001854ULL, 0x000000762858723cULL, 0x040f700000001858ULL,
0x00000070285c723cULL, 0x040f70000000185cULL, 0x000000722860723cULL, 0x040f700000001860ULL,
0x0000006e2868723cULL, 0x000b6e0000001868ULL, 0x0001e6906c287811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fcc0000008000ULL, 0x0000000103297810ULL, 0x000fe20007ffe0ffULL,
0x0000000028ff7f8cULL, 0x0003e2000c80043fULL, 0x000000c0262a7810ULL, 0x000fc40007ffe0ffULL,
0x000000062900720cULL, 0x000fc60003f06070ULL, 0x0000660009797a24ULL, 0x000fe200078e022aULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000061000008947ULL, 0x000fea0003800000ULL,
0x00000003ff6d7819ULL, 0x002fe20000011604ULL, 0x000000800a7a7824ULL, 0x000fe200078e020bULL,
0x0000002a05267217ULL, 0x000fe20007800000ULL, 0x000000ffff7b7224ULL, 0x000fe200078e00ffULL,
0x000000046d2b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c6d717810ULL, 0x040fe20007ffe0ffULL,
0x0000000126267824ULL, 0x000fe200078e0a2aULL, 0x000000086d6f7810ULL, 0x000fe20007ffe0ffULL,
0x000000012b287824ULL, 0x000fe200078e0204ULL, 0x000000106d7d7810ULL, 0x000fe20007ffe0ffULL,
0x000000082b297824ULL, 0x000fe200078e00ffULL, 0x000000146d7f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000871827824ULL, 0x000fe200078e00ffULL, 0x0000002026267817ULL, 0x000fe20003800000ULL,
0x000000086f737824ULL, 0x000fe200078e00ffULL, 0xfffffff8297c7812ULL, 0x000fe200078ee228ULL,
0x0000000171297824ULL, 0x100fe200078e0204ULL, 0x000000262b00720cULL, 0x080fe20003fa6070ULL,
0x000000016f287824ULL, 0x100fe200078e0204ULL, 0x000000792b2b7210ULL, 0x000fe20007ffe0ffULL,
0x000000017d2a7824ULL, 0x000fe200078e0204ULL, 0xfffffff882827812ULL, 0x000fe200078ee229ULL,
0x000000016d297824ULL, 0x000fe200078e0279ULL, 0xfffffff8737e7812ULL, 0x000fe200078ee228ULL,
0x000000087d757824ULL, 0x000fe200078e00ffULL, 0x000000266f00720cULL, 0x080fe20003f66070ULL,
0x000000017f727824ULL, 0x000fe200078e0204ULL, 0x000000267100720cULL, 0x000fe20003f46070ULL,
0x000000087f737824ULL, 0x000fe200078e00ffULL, 0xfffffff875847812ULL, 0x000fe200078ee22aULL,
0x0000010029287825ULL, 0x000fe200078e007aULL, 0x000000186d857810ULL, 0x000fc40007ffe0ffULL,
0xfffffff873867812ULL, 0x000fe200078ee272ULL, 0x000000016f6f7824ULL, 0x100fe200078e0279ULL,
0x0000620028727a10ULL, 0x000fe20007f1e0ffULL, 0x0000000171717824ULL, 0x000fe400078e0279ULL,
0x000001002b2a7825ULL, 0x100fe200078e007aULL, 0x0000630029737a10ULL, 0x000fe400007fe4ffULL,
0x000000267f00720cULL, 0x000fe20003f06070ULL, 0x000001006f6e7825ULL, 0x000fe200078e007aULL,
0x000062002a747a10ULL, 0x000fc60007f3e0ffULL, 0x0000010071707825ULL, 0x000fe200078e007aULL,
0x000062006e767a10ULL, 0x000fe40007f9e0ffULL, 0x000063002b757a10ULL, 0x000fe20000ffe4ffULL,
0x000000017d297824ULL, 0x000fe200078e0279ULL, 0x0000620070707a10ULL, 0x000fe20007fde0ffULL,
0x000000016d2a7824ULL, 0x000fe200078e0204ULL, 0x000000267d00720cULL, 0x000fe20003f26070ULL,
0x0000010029287825ULL, 0x000fe200078e007aULL, 0x000063006f777a10ULL, 0x000fe400027fe4ffULL,
0x000000072a7d7812ULL, 0x000fe200078ec0ffULL, 0x000000017f2b7824ULL, 0x000fe200078e0279ULL,
0x0000001c6d7f7810ULL, 0x000fc40007ffe0ffULL, 0x0000630071717a10ULL, 0x000fe200037fe4ffULL,
0x000001002b2a7825ULL, 0x000fe200078e007aULL, 0x000000266d00720cULL, 0x000fe40003f86070ULL,
0x0000620028787a10ULL, 0x000fe20007fde0ffULL, 0x00000001856d7824ULL, 0x100fe200078e0279ULL,
0x0ffffff87d6e7812ULL, 0x000fe200078ef804ULL, 0x000000017f6f7824ULL, 0x000fe200078e0279ULL,
0x0000630029797a10ULL, 0x000fe200037fe4ffULL, 0x000001006d287825ULL, 0x000fe200078e007aULL,
0x000062002a2a7a10ULL, 0x000fc60007fde0ffULL, 0x000000106e6d7824ULL, 0x000fe200078e021bULL,
0x000063002b2b7a10ULL, 0x000fe200037fe4ffULL, 0x000001006f6e7825ULL, 0x000fe200078e007aULL,
0x000000268500720cULL, 0x000fe40003fc6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000726d7faeULL, 0x0003e2000e101c48ULL, 0x000000107c7b7824ULL, 0x000fe200078e021bULL,
0x0000620028287a10ULL, 0x000fe20007f9e0ffULL, 0x000000017f7a7824ULL, 0x000fc600078e0204ULL,
0x00000000747b7faeULL, 0x0005e2000e901c48ULL, 0x000000267f00720cULL, 0x000fe20003fa6070ULL,
0x0000000185267824ULL, 0x000fe200078e0204ULL, 0x0000630029297a10ULL, 0x000fe200027fe4ffULL,
0x0000000885857824ULL, 0x000fe200078e00ffULL, 0x000062006e6e7a10ULL, 0x000fe20007f9e0ffULL,
0x000000087f7f7824ULL, 0x000fe400078e00ffULL, 0x000000107e6d7824ULL, 0x102fe200078e021bULL,
0xfffffff885267812ULL, 0x000fe200078ee226ULL, 0x0000001082737824ULL, 0x100fe200078e021bULL,
0xfffffff87f7a7812ULL, 0x000fe200078ee27aULL, 0x0000001084757824ULL, 0x104fe200078e021bULL,
0x000063006f6f7a10ULL, 0x000fe200027fe4ffULL, 0x00000010867b7824ULL, 0x100fe200078e021bULL,
0x00000000766d7faeULL, 0x0003e2000d901c48ULL, 0x00000010267d7824ULL, 0x000fc400078e021bULL,
0x000000107a7f7824ULL, 0x000fe200078e021bULL, 0x0000000070737faeULL, 0x0003e8000d101c48ULL,
0x0000000078757faeULL, 0x0003e8000c901c48ULL, 0x000000002a7b7faeULL, 0x0003e8000c101c48ULL,
0x00000000287d7faeULL, 0x0003e8000f101c48ULL, 0x000000006e7f7faeULL, 0x0003e2000e901c48ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x00000004042b7811ULL, 0x002fe200078fe8ffULL,
0x000000800a787824ULL, 0x000fe200078e020bULL, 0x00000008046f7811ULL, 0x000fc400078fe8ffULL,
0x0000000c04717811ULL, 0x040fe200078fe8ffULL, 0x000000012b267824ULL, 0x140fe200078e0204ULL,
0x0000001404757811ULL, 0x040fe200078fe8ffULL, 0x000000082b297824ULL, 0x000fe200078e00ffULL,
0x0000001004737811ULL, 0x040fe200078fe8ffULL, 0x000000016f287824ULL, 0x040fe200078e0204ULL,
0x0000001804777811ULL, 0x000fe200078fe8ffULL, 0x000000086f6d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8297a7812ULL, 0x000fe200078ee226ULL, 0x0000000171267824ULL, 0x100fe400078e0204ULL,
0x0000000175297824ULL, 0x000fe200078e0204ULL, 0xfffffff86d7c7812ULL, 0x000fe200078ee228ULL,
0x00000008716d7824ULL, 0x000fc400078e00ffULL, 0x0000000875847824ULL, 0x000fe400078e00ffULL,
0x0000000173287824ULL, 0x000fe200078e0204ULL, 0xfffffff86d7e7812ULL, 0x000fe200078ee226ULL,
0x00000008737b7824ULL, 0x000fe200078e00ffULL, 0x0000001c04267811ULL, 0x000fe200078fe8ffULL,
0x00000001772a7824ULL, 0x040fe200078e0204ULL, 0xfffffff884847812ULL, 0x000fe200078ee229ULL,
0x00000008777d7824ULL, 0x000fe200078e00ffULL, 0x0000007904297211ULL, 0x000fe200078fe8ffULL,
0x000000012b2b7824ULL, 0x100fe200078e0279ULL, 0xfffffff87b827812ULL, 0x000fe200078ee228ULL,
0x000000016f6f7824ULL, 0x100fe200078e0279ULL, 0xfffffff87d867812ULL, 0x000fe200078ee22aULL,
0x0000000171717824ULL, 0x000fc400078e0279ULL, 0x0000000173737824ULL, 0x100fe400078e0279ULL,
0x0000000175757824ULL, 0x100fe400078e0279ULL, 0x0000000177777824ULL, 0x100fe400078e0279ULL,
0x00000001266d7824ULL, 0x040fe400078e0279ULL, 0x000000ffff797224ULL, 0x000fe400078e00ffULL,
0x00000001267b7824ULL, 0x000fc400078e0204ULL, 0x0000000826887824ULL, 0x000fe200078e00ffULL,
0x0000000404267211ULL, 0x000fe200078fe8ffULL, 0x0000010029287825ULL, 0x000fc600078e0078ULL,
0xfffffff888887812ULL, 0x000fe200078ee27bULL, 0x000001002b2a7825ULL, 0x000fe200078e0078ULL,
0x0000620028287a10ULL, 0x000fc60007f1e0ffULL, 0x000001006f6e7825ULL, 0x100fe200078e0078ULL,
0x000062002a2a7a10ULL, 0x000fe40007f3e0ffULL, 0x0000630029297a10ULL, 0x000fe200007fe4ffULL,
0x0000010071707825ULL, 0x100fe200078e0078ULL, 0x000063002b2b7a10ULL, 0x000fe40000ffe4ffULL,
0x000062006e6e7a10ULL, 0x000fe20007f1e0ffULL, 0x0000010073727825ULL, 0x100fe200078e0078ULL,
0x0000620070707a10ULL, 0x000fe40007f3e0ffULL, 0x000063006f6f7a10ULL, 0x000fe200007fe4ffULL,
0x0000010075747825ULL, 0x000fe200078e0078ULL, 0x0000620072727a10ULL, 0x000fc40007f5e0ffULL,
0x0000630071717a10ULL, 0x000fe20000ffe4ffULL, 0x0000010077767825ULL, 0x100fe200078e0078ULL,
0x0000620074747a10ULL, 0x000fe40007f1e0ffULL, 0x0000630073737a10ULL, 0x000fe200017fe4ffULL,
0x000001006d787825ULL, 0x000fe200078e0078ULL, 0x00000007266d7812ULL, 0x000fe400078ec0ffULL,
0x0000620076767a10ULL, 0x000fe20007f3e0ffULL, 0x000000107a7b7824ULL, 0x100fe200078e021bULL,
0x0ffffff86d267812ULL, 0x000fe200078ef804ULL, 0x000000107c7d7824ULL, 0x100fe200078e021bULL,
0x0000620078787a10ULL, 0x000fe20007f5e0ffULL, 0x000000107e7f7824ULL, 0x100fe200078e021bULL,
0x0000630075757a10ULL, 0x000fe200007fe4ffULL, 0x00000010266d7824ULL, 0x100fe200078e021bULL,
0x0000630077777a10ULL, 0x000fe20000ffe4ffULL, 0x0000001082857824ULL, 0x100fe200078e021bULL,
0x0000630079797a10ULL, 0x000fe200017fe4ffULL, 0x0000001084877824ULL, 0x100fe200078e021bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000286d7faeULL, 0x0003e2000b901c48ULL,
0x0000001086897824ULL, 0x000fc400078e021bULL, 0x00000010888b7824ULL, 0x000fe200078e021bULL,
0x000000002a7b7faeULL, 0x0003e8000b901c48ULL, 0x000000006e7d7faeULL, 0x0003e8000b901c48ULL,
0x00000000707f7faeULL, 0x0003e8000b901c48ULL, 0x0000000072857faeULL, 0x0003e8000b901c48ULL,
0x0000000074877faeULL, 0x0003e8000b901c48ULL, 0x0000000076897faeULL, 0x0003e8000b901c48ULL,
0x00000000788b7faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001007297812ULL, 0x002fca00078ec0ffULL, 0x000000206c297824ULL, 0x000fc800078e0229ULL,
0x000000080a267824ULL, 0x000fe200078e0229ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e64800266c7f8cULL, 0x0002a4000c80043fULL, 0x0000000000287805ULL, 0x000fc40000015200ULL,
0x01e64c00262b7984ULL, 0x000ee40000000800ULL, 0x800000002bff7812ULL, 0x00cfe4000780486dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a286f7210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09006f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x0000006f2a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016e6e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e64c00262b7984ULL, 0x000ea40000000800ULL,
0x800000002bff7812ULL, 0x004fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002000267824ULL, 0x002fca00078e00ffULL, 0xffffff8026267812ULL, 0x000fc800078ec0ffULL,
0x000001000b297810ULL, 0x000fca0007ffe026ULL, 0x000000010c297824ULL, 0x000fca00078e0229ULL,
0x01e00000296e7984ULL, 0x000e680000000800ULL, 0x01e2000029707984ULL, 0x0004e20000000800ULL,
0x000000276e00720bULL, 0x002fe20003f1d000ULL, 0x000130027f007947ULL, 0x000fd8000b800000ULL,
0x00000000006d7806ULL, 0x004fc800000e0100ULL, 0x000000ff6d00720cULL, 0x000fe20003f25270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff267224ULL, 0x000fd400078e0027ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x0000000200297811ULL, 0x000fe400078ff0ffULL, 0x000000276e00720bULL, 0x000fe40003f34000ULL,
0x000000002900720cULL, 0x000fe20003f05270ULL, 0x00012fc27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000267806ULL, 0x000fc400008e0100ULL, 0x0000008000298824ULL, 0x000fe200078e020bULL,
0x000000276e288209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x000000010c298824ULL, 0x000fca00078e0229ULL, 0x01e4002829008388ULL, 0x0003e20000000800ULL,
0x000000ff2600720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x000000276e287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff26ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002728287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x0000002800727308ULL, 0x000e640000000800ULL,
0x0000007225257220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe20000011604ULL, 0x00012f027f007947ULL, 0x000fea000b800000ULL,
0x00001f2972297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0026ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000804297811ULL, 0x000fe200078ff0ffULL,
0x00012df27f007947ULL, 0x000fea000b800000ULL, 0x00001f2972297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000026ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001004297811ULL, 0x000fe200078ff0ffULL, 0x00012ce27f007947ULL, 0x000fea000b800000ULL,
0x00001f2972297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000026ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001804297811ULL, 0x000fe200078ff0ffULL, 0x00012be27f007947ULL, 0x000fea000b800000ULL,
0x00001f2972297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x000000266dff7212ULL, 0x000fe400078030ffULL, 0x000000276e267209ULL, 0x000fd60007810000ULL,
0x800000266e6e0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b6e6e0820ULL, 0x000fc80000410000ULL,
0x0000006e000d0308ULL, 0x000e640000000800ULL, 0x0000000d70700220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000002570257221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x0000000dff0e723eULL, 0x000fe400000000ffULL,
0x00000002ff6e7819ULL, 0x000fe40000011604ULL, 0x000054100e117816ULL, 0x000fe2000000000eULL,
0x00012a327f007947ULL, 0x000fea000b800000ULL, 0x00001f6e110e7589ULL, 0x0002a400000e0000ULL,
0x000000086e297810ULL, 0x000fe20007ffe0ffULL, 0x00012a827f007947ULL, 0x000fea000b800000ULL,
0x000000106e107810ULL, 0x000fe20007ffe0ffULL, 0x00001f29110f7589ULL, 0x00066a00000e0000ULL,
0x00001f1011107589ULL, 0x0006a400000e0000ULL, 0x000000186e297810ULL, 0x008fe20007ffe0ffULL,
0x00012b127f007947ULL, 0x000fea000b800000ULL, 0x00001f2911117589ULL, 0x0022e400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000200277824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000200000287824ULL, 0x000fe200078e00ffULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x00000008126d7824ULL, 0x000fe200078e00ffULL,
0x0000000427277812ULL, 0x000fe200078ec0ffULL, 0x00000008132a7824ULL, 0x000fe200078e00ffULL,
0xffffc000282b7812ULL, 0x000fc400078ec0ffULL, 0x0000002704277211ULL, 0x000fc600078fe0ffULL,
0x000020000a2b7824ULL, 0x000fe400078e022bULL, 0x0000000112287824ULL, 0x100fe400078e0227ULL,
0x0000000113297824ULL, 0x002fe200078e0227ULL, 0x0001400015277810ULL, 0x000fe40007ffe0ffULL,
0xfffffff86d287812ULL, 0x000fe400078ee228ULL, 0xfffffff82a2a7812ULL, 0x000fe400078ee229ULL,
0x000160002b757810ULL, 0x000fe20007ffe0ffULL, 0x00000010286c7824ULL, 0x000fc400078e0227ULL,
0x000000102a2a7824ULL, 0x000fe400078e0227ULL, 0x0000001016707824ULL, 0x100fe400078e0275ULL,
0x000000006c6c783bULL, 0x000e620000000200ULL, 0x0000001014747824ULL, 0x100fe400078e0275ULL,
0x0000001017787824ULL, 0x000fe200078e0275ULL, 0x000000002a28783bULL, 0x000ee20000000200ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000000e6c6c7232ULL, 0x086fe40000000000ULL,
0x0000000e6e6e7232ULL, 0x000fc40000000000ULL, 0x0000000f6d6d7232ULL, 0x080fe40000000000ULL,
0x0000000f6f6f7232ULL, 0x000fe40000000000ULL, 0x0000001028287232ULL, 0x088fe40000000000ULL,
0x000000102a2a7232ULL, 0x000fe40000000000ULL, 0x0000001129297232ULL, 0x080fe40000000000ULL,
0x000000112b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010187c7824ULL, 0x000fe200078e0275ULL, 0x000000007070783bULL, 0x000f220000004200ULL,
0x0001600024247810ULL, 0x000fe20007ffe0ffULL, 0x0000024000007945ULL, 0x000fe40003800000ULL,
0x000000007474783bULL, 0x000ee40000004200ULL, 0x0000001022227824ULL, 0x000fc400078e0224ULL,
0x000000007878783bULL, 0x000ea80000004200ULL, 0x000000007c7c783bULL, 0x000e640000004200ULL,
0x000000706c2c723cULL, 0x092f70000000182cULL, 0x00000070284c723cULL, 0x048b6e000000184cULL,
0x0000001019707824ULL, 0x120fe200078e0227ULL, 0x000000722850723cULL, 0x000f620000001850ULL,
0x000000101a277824ULL, 0x000fce00078e0227ULL, 0x000000742854723cULL, 0x040f700000001854ULL,
0x000000762858723cULL, 0x040f700000001858ULL, 0x00000078285c723cULL, 0x044f70000000185cULL,
0x0000007a2860723cULL, 0x040f700000001860ULL, 0x0000007c2864723cULL, 0x000f700000001864ULL,
0x000000726c30723cULL, 0x000b640000001830ULL, 0x000000007070783bULL, 0x020e6c0000000200ULL,
0x0000007e2828723cULL, 0x000b640000001868ULL, 0x000000002768783bULL, 0x0204ec0000000200ULL,
0x000000746c34723cULL, 0x040b6e0000001834ULL, 0x0000001023747824ULL, 0x120fe200078e0224ULL,
0x000000766c38723cULL, 0x040f700000001838ULL, 0x000000786c3c723cULL, 0x040f70000000183cULL,
0x0000007a6c40723cULL, 0x040f700000001840ULL, 0x0000007c6c44723cULL, 0x040f700000001844ULL,
0x0000007e6c48723cULL, 0x000b6e0000001848ULL, 0x00000010216c7824ULL, 0x020fe200078e0224ULL,
0x0000008000008947ULL, 0x000fd60003800000ULL, 0x0000000e70707232ULL, 0x08efe40000000000ULL,
0x0000000e72727232ULL, 0x000fc40000000000ULL, 0x0000000f71717232ULL, 0x080fe40000000000ULL,
0x0000000f73737232ULL, 0x000fe40000000000ULL, 0x0000001068687232ULL, 0x080fe40000000000ULL,
0x000000106a6a7232ULL, 0x000fe40000000000ULL, 0x0000001169697232ULL, 0x080fe40000000000ULL,
0x000000116b6b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x00efea0003800000ULL,
0x0000001020787824ULL, 0x000fe200078e0224ULL, 0x000000006c6c783bULL, 0x000e680000004200ULL,
0x000000002220783bULL, 0x000ea80000004200ULL, 0x000000007474783bULL, 0x000ee80000004200ULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x0000006c684c723cULL, 0x042f70000000184cULL,
0x0000006e6850723cULL, 0x040f700000001850ULL, 0x000000206854723cULL, 0x044f700000001854ULL,
0x000000226858723cULL, 0x040f700000001858ULL, 0x00000074685c723cULL, 0x048f70000000185cULL,
0x000000766860723cULL, 0x040f700000001860ULL, 0x000000786864723cULL, 0x010f700000001864ULL,
0x0000006c702c723cULL, 0x040f70000000182cULL, 0x0000006e7030723cULL, 0x040f700000001830ULL,
0x000000227038723cULL, 0x040f700000001838ULL, 0x00000074703c723cULL, 0x040f70000000183cULL,
0x000000767040723cULL, 0x040f700000001840ULL, 0x000000787044723cULL, 0x040f700000001844ULL,
0x0000007a7048723cULL, 0x080f700000001848ULL, 0x0000007a6868723cULL, 0x000f700000001828ULL,
0x000000207034723cULL, 0x000b6e0000001834ULL, 0x00000002ff207819ULL, 0x020fc80000011600ULL,
0x0001e69820217811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fcc0000008000ULL,
0x0000030003037a10ULL, 0x000fe20007ffe0ffULL, 0x0000000021ff7f8cULL, 0x0003e6000c80043fULL,
0x000000060300720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00000ba000000947ULL, 0x000fea0003800000ULL, 0x0000000103217810ULL, 0x042fe20007ffe0ffULL,
0x0000010003227824ULL, 0x000fc600078e0208ULL, 0x000000062100720cULL, 0x000fe20003f06070ULL,
0x0000660009777a24ULL, 0x000fd800078e0222ULL, 0x0000061000008947ULL, 0x000fea0003800000ULL,
0x00000003ff747819ULL, 0x000fe40000011604ULL, 0x0000002205217217ULL, 0x000fe40007800000ULL,
0x0000000474287810ULL, 0x040fe20007ffe0ffULL, 0x0000000174297824ULL, 0x040fe200078e0277ULL,
0x00000008746c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000121217824ULL, 0x000fe200078e0a22ULL,
0x0000000c74727810ULL, 0x000fe20007ffe0ffULL, 0x0000000128237824ULL, 0x100fe200078e0204ULL,
0x0000001074767810ULL, 0x000fe20007ffe0ffULL, 0x00000008282a7824ULL, 0x000fe200078e00ffULL,
0x0000002021217817ULL, 0x000fe20003800000ULL, 0x000000016c277824ULL, 0x000fc400078e0204ULL,
0x000000086c6e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82a757812ULL, 0x000fe200078ee223ULL,
0x000000800a227824ULL, 0x000fe200078e020bULL, 0x000000212800720cULL, 0x080fe20003f86070ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0xfffffff86e7d7812ULL, 0x000fe200078ee227ULL,
0x00000001282b7824ULL, 0x000fe200078e0277ULL, 0x000000217200720cULL, 0x0c0fe20003f46070ULL,
0x0000000172277824ULL, 0x000fe200078e0204ULL, 0x000000216c00720cULL, 0x080fe20003f66070ULL,
0x00000008726e7824ULL, 0x000fe200078e00ffULL, 0x000000217400720cULL, 0x000fe20003fa6070ULL,
0x0000010029287825ULL, 0x000fc600078e0022ULL, 0xfffffff86e7f7812ULL, 0x000fe200078ee227ULL,
0x000001002b2a7825ULL, 0x000fe200078e0022ULL, 0x00006200286e7a10ULL, 0x000fc60007f1e0ffULL,
0x00000001766d7824ULL, 0x140fe200078e0204ULL, 0x00006300296f7a10ULL, 0x000fe200007fe4ffULL,
0x0000000876787824ULL, 0x000fe200078e00ffULL, 0x000062002a707a10ULL, 0x000fe20007f3e0ffULL,
0x000000016c297824ULL, 0x000fe400078e0277ULL, 0x0000000174277824ULL, 0x000fe200078e0204ULL,
0xfffffff878857812ULL, 0x000fe200078ee26dULL, 0x0000010029287825ULL, 0x000fe200078e0022ULL,
0x0000001474787810ULL, 0x000fe40007ffe0ffULL, 0x000063002b717a10ULL, 0x000fe20000ffe4ffULL,
0x00000001722b7824ULL, 0x100fe200078e0277ULL, 0x000000217600720cULL, 0x040fe20003f26070ULL,
0x00000001766d7824ULL, 0x000fe200078e0277ULL, 0x0000620028727a10ULL, 0x000fe20007f1e0ffULL,
0x0000000178737824ULL, 0x040fe200078e0204ULL, 0x0000000727277812ULL, 0x000fe200078ec0ffULL,
0x0000000878767824ULL, 0x000fc400078e00ffULL, 0x000001002b2a7825ULL, 0x000fe200078e0022ULL,
0x0ffffff827277812ULL, 0x000fe400078ef804ULL, 0xfffffff876877812ULL, 0x000fe200078ee273ULL,
0x000001006d6c7825ULL, 0x000fe200078e0022ULL, 0x0000630029737a10ULL, 0x000fe400007fe4ffULL,
0x000062002a2a7a10ULL, 0x000fe20007fde0ffULL, 0x0000001027797824ULL, 0x100fe200078e0224ULL,
0x0000007778297210ULL, 0x000fe20007ffe0ffULL, 0x00000010757b7824ULL, 0x100fe200078e0224ULL,
0x000063002b2b7a10ULL, 0x000fe200037fe4ffULL, 0x000000107d7d7824ULL, 0x000fe200078e0224ULL,
0x000062006c6c7a10ULL, 0x000fe20007fde0ffULL, 0x0000010029287825ULL, 0x000fe200078e0022ULL,
0x0000001874767810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e797faeULL, 0x0003e2000e901c48ULL, 0x000000217800720cULL, 0x080fe20003f06070ULL,
0x000000107f7f7824ULL, 0x100fe200078e0224ULL, 0x000063006d6d7a10ULL, 0x000fe200037fe4ffULL,
0x0000000176277824ULL, 0x000fe200078e0277ULL, 0x0000001c74787810ULL, 0x000fe20007ffe0ffULL,
0x00000000707b7faeULL, 0x0005e2000e101c48ULL, 0x0000620028747a10ULL, 0x000fe20007fde0ffULL,
0x0000001085857824ULL, 0x100fe200078e0224ULL, 0x000000217600720cULL, 0x080fe20003fa6070ULL,
0x0000001087877824ULL, 0x000fe200078e0224ULL, 0x0000630029757a10ULL, 0x000fe200037fe4ffULL,
0x0000010027287825ULL, 0x000fe200078e0022ULL, 0x000000217800720cULL, 0x040fe20003f86070ULL,
0x00000000727d7faeULL, 0x0005e4000d901c48ULL, 0x0000000178217824ULL, 0x000fe200078e0277ULL,
0x0000620028287a10ULL, 0x000fe20007fde0ffULL, 0x0000000176277824ULL, 0x140fe200078e0204ULL,
0x000000002a7f7faeULL, 0x0005e2000d101c48ULL, 0x0000000876767824ULL, 0x000fe200078e00ffULL,
0x0000630029297a10ULL, 0x000fe200037fe4ffULL, 0x00000001786e7824ULL, 0x042fe200078e0204ULL,
0x000000006c857faeULL, 0x0005e2000c901c48ULL, 0x00000008786f7824ULL, 0x000fe200078e00ffULL,
0xfffffff876277812ULL, 0x000fe200078ee227ULL, 0x0000010021227825ULL, 0x000fe200078e0022ULL,
0x0000000074877faeULL, 0x0005e4000c101c48ULL, 0xfffffff86f217812ULL, 0x000fe200078ee26eULL,
0x0000001027277824ULL, 0x000fe200078e0224ULL, 0x0000620022227a10ULL, 0x000fc60007fde0ffULL,
0x0000001021217824ULL, 0x000fe200078e0224ULL, 0x0000630023237a10ULL, 0x000fe200037fe4ffULL,
0x0000000028277faeULL, 0x0005e8000e901c48ULL, 0x0000000022217faeULL, 0x0005e2000e101c48ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000000404297811ULL, 0x000fe200078fe8ffULL,
0x000000800a747824ULL, 0x000fe200078e020bULL, 0x00000008042b7811ULL, 0x040fe200078fe8ffULL,
0x000000ffff757224ULL, 0x000fe200078e00ffULL, 0x0000000c046d7811ULL, 0x040fe200078fe8ffULL,
0x0000000129217824ULL, 0x140fe200078e0204ULL, 0x00000010046f7811ULL, 0x040fe200078fe8ffULL,
0x0000000829287824ULL, 0x000fe200078e00ffULL, 0x0000001404717811ULL, 0x040fe200078fe8ffULL,
0x000000012b227824ULL, 0x140fe200078e0204ULL, 0x0000001804737811ULL, 0x000fe200078fe8ffULL,
0x000000082b7b7824ULL, 0x000fe200078e00ffULL, 0xfffffff828797812ULL, 0x000fe200078ee221ULL,
0x000000016d217824ULL, 0x000fc400078e0204ULL, 0x000000086d287824ULL, 0x000fe200078e00ffULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee222ULL, 0x000000016f227824ULL, 0x140fe400078e0204ULL,
0x000000086f7f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8287d7812ULL, 0x000fe200078ee221ULL,
0x0000000171237824ULL, 0x040fe200078e0204ULL, 0x0000000404217211ULL, 0x040fe200078fe8ffULL,
0x00000008712a7824ULL, 0x000fe200078e00ffULL, 0xfffffff87f7f7812ULL, 0x000fe200078ee222ULL,
0x0000000173277824ULL, 0x040fe200078e0204ULL, 0x0000001c04227811ULL, 0x000fe200078fe8ffULL,
0x00000008736c7824ULL, 0x000fe200078e00ffULL, 0xfffffff82a857812ULL, 0x000fe200078ee223ULL,
0x0000000129297824ULL, 0x100fe200078e0277ULL, 0x0000007704237211ULL, 0x000fe200078fe8ffULL,
0x000000012b2b7824ULL, 0x000fe200078e0277ULL, 0xfffffff86c877812ULL, 0x000fe200078ee227ULL,
0x000000016d6d7824ULL, 0x100fe200078e0277ULL, 0x0000000721277812ULL, 0x000fe200078ec0ffULL,
0x000000016f6f7824ULL, 0x000fc400078e0277ULL, 0x0000000171717824ULL, 0x100fe200078e0277ULL,
0x0ffffff827277812ULL, 0x100fe200078ef804ULL, 0x0000000173737824ULL, 0x100fe400078e0277ULL,
0x0000000122217824ULL, 0x040fe400078e0277ULL, 0x0000000122767824ULL, 0x040fe400078e0204ULL,
0x0000000822777824ULL, 0x000fe400078e00ffULL, 0x0000010023227825ULL, 0x000fc800078e0074ULL,
0x0000010029287825ULL, 0x000fe200078e0074ULL, 0x0000620022227a10ULL, 0x000fc60007f1e0ffULL,
0x000001002b2a7825ULL, 0x100fe200078e0074ULL, 0x0000620028287a10ULL, 0x000fe40007f3e0ffULL,
0x0000630023237a10ULL, 0x000fe200007fe4ffULL, 0x000001006d6c7825ULL, 0x100fe200078e0074ULL,
0x000062002a2a7a10ULL, 0x000fe40007f5e0ffULL, 0x0000630029297a10ULL, 0x000fe20000ffe4ffULL,
0x000001006f6e7825ULL, 0x100fe200078e0074ULL, 0x000062006c6c7a10ULL, 0x000fe40007f7e0ffULL,
0x000063002b2b7a10ULL, 0x000fe200017fe4ffULL, 0x0000010071707825ULL, 0x000fe200078e0074ULL,
0x000062006e6e7a10ULL, 0x000fc40007f1e0ffULL, 0x000063006d6d7a10ULL, 0x000fe20001ffe4ffULL,
0x0000010073727825ULL, 0x100fe200078e0074ULL, 0x0000620070707a10ULL, 0x000fe40007f3e0ffULL,
0x000063006f6f7a10ULL, 0x000fe200007fe4ffULL, 0x0000010021747825ULL, 0x000fe200078e0074ULL,
0xfffffff877217812ULL, 0x000fe400078ee276ULL, 0x0000620072727a10ULL, 0x000fe20007f5e0ffULL,
0x0000001027277824ULL, 0x100fe200078e0224ULL, 0x0000620074747a10ULL, 0x000fe20007f7e0ffULL,
0x0000001079797824ULL, 0x100fe200078e0224ULL, 0x0000630071717a10ULL, 0x000fe20000ffe4ffULL,
0x000000107b7b7824ULL, 0x100fe200078e0224ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022277faeULL, 0x0003e2000b901c48ULL, 0x000000107d7d7824ULL, 0x100fe200078e0224ULL,
0x0000630073737a10ULL, 0x000fe200017fe4ffULL, 0x000000107f7f7824ULL, 0x100fe200078e0224ULL,
0x0000000028797faeULL, 0x0003e2000b901c48ULL, 0x0000001085857824ULL, 0x100fe200078e0224ULL,
0x0000630075757a10ULL, 0x000fe20001ffe4ffULL, 0x0000001087877824ULL, 0x100fe200078e0224ULL,
0x000000002a7b7faeULL, 0x0003e2000b901c48ULL, 0x0000001021217824ULL, 0x000fc600078e0224ULL,
0x000000006c7d7faeULL, 0x0003e8000b901c48ULL, 0x000000006e7f7faeULL, 0x0003e8000b901c48ULL,
0x0000000070857faeULL, 0x0003e8000b901c48ULL, 0x0000000072877faeULL, 0x0003e8000b901c48ULL,
0x0000000074217faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x0000001007217812ULL, 0x004fc400078ec0ffULL, 0x0000000807247812ULL, 0x000fc600078ec0ffULL,
0x0000002020217824ULL, 0x000fc800078e0221ULL, 0x0000000124247824ULL, 0x000fe200078e0221ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e6680024287f8cULL, 0x0002a4000c80043fULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x01e66c0024237984ULL, 0x000ee40000000800ULL,
0x8000000023ff7812ULL, 0x00cfe40007804829ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220277210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09002700780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402700780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011423ULL, 0x0000002722227211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x0000000222227819ULL, 0x000fc80000001223ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e66c0024237984ULL, 0x000ea40000000800ULL, 0x8000000023ff7812ULL, 0x004fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000300207811ULL, 0x000fca00078ff0ffULL,
0x0000008020217824ULL, 0x000fc800078e020bULL, 0x000000010c217824ULL, 0x000fca00078e0221ULL,
0x01e0000021237984ULL, 0x000ea80000000800ULL, 0x01e2000021227984ULL, 0x0006620000000800ULL,
0x000000262300720bULL, 0x004fe20003f1d000ULL, 0x000115d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000217806ULL, 0x008fc800000e0100ULL, 0x000000ff2100720cULL, 0x000fe20003f25270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff207224ULL, 0x000fd400078e0026ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x0000000300277811ULL, 0x000fe400078ff0ffULL, 0x000000262300720bULL, 0x000fe40003f34000ULL,
0x000000002700720cULL, 0x000fe20003f05270ULL, 0x000115927f007947ULL, 0x000fd4000b800000ULL,
0x0000000000207806ULL, 0x000fc400008e0100ULL, 0x0000008000278824ULL, 0x000fe200078e020bULL,
0x00000026230b8209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x000000010c0c8824ULL, 0x000fca00078e0227ULL, 0x01e4000b0c008388ULL, 0x0005e20000000800ULL,
0x000000ff2000720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x00000026230b7209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff20ff7812ULL, 0x000fc6000780c0ffULL, 0x000000260b0b7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL, 0x0000000b000c7308ULL, 0x000ea40000000800ULL,
0x0000000c25257220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe20000011604ULL, 0x000114d27f007947ULL, 0x000fea000b800000ULL,
0x00001f290c297589ULL, 0x0004e400000e0000ULL, 0x000000292c2c7220ULL, 0x08cfe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0020ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000804297811ULL, 0x000fe200078ff0ffULL,
0x000113c27f007947ULL, 0x000fea000b800000ULL, 0x00001f290c297589ULL, 0x0004e400000e0000ULL,
0x000000292e2e7220ULL, 0x08cfe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000020ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001004297811ULL, 0x000fe200078ff0ffULL, 0x000112b27f007947ULL, 0x000fea000b800000ULL,
0x00001f290c297589ULL, 0x0004e400000e0000ULL, 0x000000294c4c7220ULL, 0x08cfe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000020ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001804297811ULL, 0x000fe200078ff0ffULL, 0x000111b27f007947ULL, 0x000fea000b800000ULL,
0x00001f290c297589ULL, 0x0004e400000e0000ULL, 0x000000294e4e7220ULL, 0x08cfe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000002021ff7212ULL, 0x000fe400078030ffULL, 0x0000002623207209ULL, 0x000fd60007810000ULL,
0x8000002023230221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL,
0x00000023000d0308ULL, 0x000ea40000000800ULL, 0x0000000d22220220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000002522257221ULL, 0x002fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x0000000dff0b723eULL, 0x000fe400000000ffULL,
0x00000002ff0c7819ULL, 0x000fe40000011604ULL, 0x000054100b0b7816ULL, 0x000fe2000000000bULL,
0x000110027f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0b0e7589ULL, 0x0002a400000e0000ULL,
0x000000080c297810ULL, 0x000fe20007ffe0ffULL, 0x000110527f007947ULL, 0x000fea000b800000ULL,
0x000000100c107810ULL, 0x000fe20007ffe0ffULL, 0x00001f290b0f7589ULL, 0x00066a00000e0000ULL,
0x00001f100b107589ULL, 0x0006a400000e0000ULL, 0x000000180c297810ULL, 0x008fe20007ffe0ffULL,
0x000110e27f007947ULL, 0x000fea000b800000ULL, 0x00001f290b117589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001ff217819ULL, 0x000fe20000011600ULL,
0x0000000812237824ULL, 0x000fe200078e00ffULL, 0x00000004ff0c7819ULL, 0x002fe20000011604ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000001210b7812ULL, 0x008fe200078ec0ffULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000000300227811ULL, 0x000fe200078ff0ffULL,
0x0000001016787824ULL, 0x000fc400078e021bULL, 0x000000040b0b7824ULL, 0x000fe400078e020cULL,
0x00000010147c7824ULL, 0x000fe400078e021bULL, 0x00000001130c7824ULL, 0x140fe400078e020bULL,
0x0000000112127824ULL, 0x000fe200078e020bULL, 0x00012000220b7811ULL, 0x000fe200078e60ffULL,
0x0000000813137824ULL, 0x000fe400078e00ffULL, 0x00000010176c7824ULL, 0x000fe200078e021bULL,
0xfffffff823127812ULL, 0x000fc400078ee212ULL, 0xfffffff8130c7812ULL, 0x000fc600078ee20cULL,
0x0000001012127824ULL, 0x100fe400078e020bULL, 0x000000100c0c7824ULL, 0x000fc600078e020bULL,
0x000000001274783bULL, 0x0002e80000000200ULL, 0x000000000c28783bULL, 0x0002a20000000200ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000000e74747232ULL, 0x08cfe40000000000ULL,
0x0000000e76767232ULL, 0x000fe40000000000ULL, 0x0000000f75757232ULL, 0x080fe40000000000ULL,
0x0000000f77777232ULL, 0x000fc40000000000ULL, 0x0000001028287232ULL, 0x080fe40000000000ULL,
0x000000102a2a7232ULL, 0x000fe40000000000ULL, 0x0000001129297232ULL, 0x080fe40000000000ULL,
0x000000112b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001018707824ULL, 0x000fe200078e021bULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x0001500015157810ULL, 0x000fe20007ffe0ffULL, 0x0000022000007945ULL, 0x000fe40003800000ULL,
0x000000007c7c783bULL, 0x000e640000004200ULL, 0x0000001019197824ULL, 0x000fc400078e0215ULL,
0x000000006c6c783bULL, 0x000ee20000004200ULL, 0x000000101a157824ULL, 0x000fc600078e0215ULL,
0x000000007070783bULL, 0x000ea80000004200ULL, 0x000000001918783bULL, 0x000e680000000200ULL,
0x000000001514783bULL, 0x000ea20000000200ULL, 0x00000078742c723cULL, 0x058b70000000182cULL,
0x0000007a7430723cULL, 0x040b700000001830ULL, 0x0000007c7434723cULL, 0x042b700000001834ULL,
0x0000007e7438723cULL, 0x040b700000001838ULL, 0x0000006c743c723cULL, 0x040b70000000183cULL,
0x0000006e7440723cULL, 0x040b700000001840ULL, 0x000000707444723cULL, 0x044b700000001844ULL,
0x000000727448723cULL, 0x000b700000001848ULL, 0x00000078284c723cULL, 0x040b70000000184cULL,
0x0000007a2850723cULL, 0x040b700000001850ULL, 0x0000007c2854723cULL, 0x040b700000001854ULL,
0x0000007e2858723cULL, 0x040b700000001858ULL, 0x0000006c285c723cULL, 0x040b70000000185cULL,
0x0000006e2860723cULL, 0x040b700000001860ULL, 0x000000702864723cULL, 0x040b700000001864ULL,
0x000000722868723cULL, 0x000b620000001868ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000008000008947ULL, 0x000fde0003800000ULL, 0x0000000e18187232ULL, 0x080fe40000000000ULL,
0x0000000e1a1a7232ULL, 0x000fc40000000000ULL, 0x0000000f19197232ULL, 0x080fe40000000000ULL,
0x0000000f1b1b7232ULL, 0x000fe40000000000ULL, 0x0000001014147232ULL, 0x080fe40000000000ULL,
0x0000001016167232ULL, 0x000fe40000000000ULL, 0x0000001115157232ULL, 0x080fe40000000000ULL,
0x0000001117177232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000001c28783bULL, 0x020e620000004200ULL, 0x00000002000b7824ULL, 0x000fc600078e00ffULL,
0x000000001d6c783bULL, 0x000ea40000004200ULL, 0xfffffff80b0b7812ULL, 0x000fe400078ec0ffULL,
0x000000001e70783bULL, 0x000ee80000004200ULL, 0x000000001f74783bULL, 0x000f220000004200ULL,
0x00000028182c723cULL, 0x042b70000000182cULL, 0x0000002a1830723cULL, 0x040b700000001830ULL,
0x0000006c1834723cULL, 0x044b700000001834ULL, 0x0000006e1838723cULL, 0x040b700000001838ULL,
0x00000070183c723cULL, 0x048b70000000183cULL, 0x000000721840723cULL, 0x040b700000001840ULL,
0x000000741844723cULL, 0x050b700000001844ULL, 0x000000761848723cULL, 0x000b700000001848ULL,
0x00000028144c723cULL, 0x040b70000000184cULL, 0x0000002a1450723cULL, 0x040b700000001850ULL,
0x0000006c1454723cULL, 0x040b700000001854ULL, 0x0000006e1458723cULL, 0x040b700000001858ULL,
0x00000070145c723cULL, 0x040b70000000185cULL, 0x000000721460723cULL, 0x040b700000001860ULL,
0x000000741464723cULL, 0x040b700000001864ULL, 0x000000761468723cULL, 0x000b620000001868ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000060300720cULL, 0x000fe20003f06070ULL,
0x01e6a0000bff7f8cULL, 0x0003d8000c80043fULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff849000007947ULL, 0x000fea000383ffffULL, 0x0000000000077919ULL, 0x000e640000002500ULL,
0x000000060700720cULL, 0x002fda0003f06070ULL, 0x0000057000000947ULL, 0x000fea0003800000ULL,
0x0180000025037810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000003037812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e0025ULL,
0x00009780000c7802ULL, 0x000fc40000000f00ULL, 0x00010e2000007944ULL, 0x020fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002500047308ULL, 0x000e640000001000ULL,
0xbf80000004037423ULL, 0x002fc80000000025ULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000304037223ULL, 0x000fc40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000f240000000000ULL, 0x00000002ff047819ULL, 0x010fe40000011605ULL,
0x0000001005067811ULL, 0x046fe400078ff0ffULL, 0x00000018050e7811ULL, 0x040fe400078ff0ffULL,
0x00000008050c7811ULL, 0x000fe200078ff0ffULL, 0x00001f0403047589ULL, 0x008e6800000e0000ULL,
0x00001f0e03097589ULL, 0x000ea800000e0000ULL, 0x00001f0c03057589ULL, 0x000ee800000e0000ULL,
0x00001f0603067589ULL, 0x000f2200000e0000ULL, 0x0000002c042c7220ULL, 0x022fc40000410000ULL,
0x0000002d042d7220ULL, 0x040fe40000410000ULL, 0x0000003004307220ULL, 0x040fe40000410000ULL,
0x0000003104317220ULL, 0x040fe40000410000ULL, 0x0000003404347220ULL, 0x040fe40000410000ULL,
0x0000003504357220ULL, 0x040fe40000410000ULL, 0x0000003804387220ULL, 0x000fc40000410000ULL,
0x0000003904397220ULL, 0x040fe40000410000ULL, 0x0000003c043c7220ULL, 0x040fe40000410000ULL,
0x0000003d043d7220ULL, 0x040fe40000410000ULL, 0x0000004004407220ULL, 0x040fe40000410000ULL,
0x0000004104417220ULL, 0x040fe40000410000ULL, 0x0000004404447220ULL, 0x000fc40000410000ULL,
0x0000004504457220ULL, 0x040fe40000410000ULL, 0x0000004804487220ULL, 0x040fe40000410000ULL,
0x0000004904497220ULL, 0x000fe40000410000ULL, 0x0000004e094e7220ULL, 0x044fe40000410000ULL,
0x0000004f094f7220ULL, 0x040fe40000410000ULL, 0x0000005209527220ULL, 0x000fc40000410000ULL,
0x0000005309537220ULL, 0x040fe40000410000ULL, 0x0000005609567220ULL, 0x040fe40000410000ULL,
0x0000005709577220ULL, 0x040fe40000410000ULL, 0x0000005a095a7220ULL, 0x040fe40000410000ULL,
0x0000005b095b7220ULL, 0x040fe40000410000ULL, 0x0000005e095e7220ULL, 0x000fc40000410000ULL,
0x0000005f095f7220ULL, 0x040fe40000410000ULL, 0x0000006209627220ULL, 0x040fe40000410000ULL,
0x0000006309637220ULL, 0x040fe40000410000ULL, 0x0000006609667220ULL, 0x040fe40000410000ULL,
0x0000006709677220ULL, 0x040fe40000410000ULL, 0x0000006a096a7220ULL, 0x000fc40000410000ULL,
0x0000006b096b7220ULL, 0x000fe40000410000ULL, 0x000000052e2e7220ULL, 0x088fe40000410000ULL,
0x000000052f2f7220ULL, 0x080fe40000410000ULL, 0x0000000532327220ULL, 0x080fe40000410000ULL,
0x0000000533337220ULL, 0x080fe40000410000ULL, 0x0000000536367220ULL, 0x000fc40000410000ULL,
0x0000000537377220ULL, 0x080fe40000410000ULL, 0x000000053a3a7220ULL, 0x080fe40000410000ULL,
0x000000053b3b7220ULL, 0x080fe40000410000ULL, 0x000000053e3e7220ULL, 0x080fe40000410000ULL,
0x000000053f3f7220ULL, 0x080fe40000410000ULL, 0x0000000542427220ULL, 0x000fc40000410000ULL,
0x0000000543437220ULL, 0x080fe40000410000ULL, 0x0000000546467220ULL, 0x080fe40000410000ULL,
0x0000000547477220ULL, 0x080fe40000410000ULL, 0x000000054a4a7220ULL, 0x080fe40000410000ULL,
0x000000054b4b7220ULL, 0x000fe40000410000ULL, 0x000000064c4c7220ULL, 0x010fc40000410000ULL,
0x000000064d4d7220ULL, 0x080fe40000410000ULL, 0x0000000650507220ULL, 0x080fe40000410000ULL,
0x0000000651517220ULL, 0x080fe40000410000ULL, 0x0000000654547220ULL, 0x080fe40000410000ULL,
0x0000000655557220ULL, 0x080fe40000410000ULL, 0x0000000658587220ULL, 0x000fc40000410000ULL,
0x0000000659597220ULL, 0x080fe40000410000ULL, 0x000000065c5c7220ULL, 0x080fe40000410000ULL,
0x000000065d5d7220ULL, 0x080fe40000410000ULL, 0x0000000660607220ULL, 0x080fe40000410000ULL,
0x0000000661617220ULL, 0x080fe40000410000ULL, 0x0000000664647220ULL, 0x000fc40000410000ULL,
0x0000000665657220ULL, 0x080fe40000410000ULL, 0x0000000668687220ULL, 0x080fe40000410000ULL,
0x0000000669697220ULL, 0x000fc40000410000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x0000002c2d06723eULL, 0x020fe400000000ffULL, 0x00000030310b723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000034350c723eULL, 0x000fc400000000ffULL,
0x00000038390d723eULL, 0x000fe400000000ffULL, 0x0000003c3d0e723eULL, 0x000fe400000000ffULL,
0x00000040410f723eULL, 0x000fe400000000ffULL, 0x000000444510723eULL, 0x000fe400000000ffULL,
0x000000484911723eULL, 0x000fe400000000ffULL, 0x0000002e2f2e723eULL, 0x000fc400000000ffULL,
0x00000002ff1b7819ULL, 0x002fe40000011603ULL, 0x00000008032c7811ULL, 0x000fe400078ff0ffULL,
0x000000011b047810ULL, 0x040fe20007ffe0ffULL, 0x000000081b1d7824ULL, 0x040fe200078e00ffULL,
0x000000031b097810ULL, 0x040fe20007ffe0ffULL, 0x000000081b227824ULL, 0x040fe200078e00ffULL,
0x000000041b1a7810ULL, 0x040fe20007ffe0ffULL, 0x000000081b1f7824ULL, 0x040fe200078e00ffULL,
0x000000021b057810ULL, 0x040fe20007ffe0ffULL, 0x000000081b1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1c7812ULL, 0x000fe200078ee204ULL, 0x000000081b2a7824ULL, 0x040fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee209ULL, 0x000000081b287824ULL, 0x000fe200078e00ffULL,
0xfffffff81f247812ULL, 0x000fe200078ee21aULL, 0x000000081b1a7824ULL, 0x040fe200078e00ffULL,
0x000000051b047810ULL, 0x040fe20007ffe0ffULL, 0x000000082c1f7824ULL, 0x000fe200078e00ffULL,
0xffffffff1b097810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81e1e7812ULL, 0x000fe400078ee205ULL,
0x000000061b057810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81d267812ULL, 0x000fe200078ee204ULL,
0x000020000a047824ULL, 0x000fe200078e00ffULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee209ULL,
0x0000100021097824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee21bULL,
0x00000004031b7824ULL, 0x040fe200078e00ffULL, 0x0000001003307811ULL, 0x000fc400078ff0ffULL,
0xfffffff828287812ULL, 0x000fe200078ee205ULL, 0x0000000104057824ULL, 0x000fe200078e0209ULL,
0x0000001803347811ULL, 0x000fe200078ff0ffULL, 0x00000008301d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f2c7812ULL, 0x000fe200078ee22cULL, 0x000000101a1a7824ULL, 0x100fe200078e0205ULL,
0x0000000c1b1b7812ULL, 0x000fe200078ec0ffULL, 0x00000008341f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d307812ULL, 0x000fe200078ee230ULL, 0x000000101c1c7824ULL, 0x100fe200078e0205ULL,
0x000000323332723eULL, 0x000fe200000000ffULL, 0x000000101e1e7824ULL, 0x100fe200078e0205ULL,
0xfffffff81f347812ULL, 0x000fe200078ee234ULL, 0x0000001022227824ULL, 0x100fe200078e0205ULL,
0x000000363736723eULL, 0x000fe200000000ffULL, 0x0000001024247824ULL, 0x000fe200078e0205ULL,
0x0000003a3b3a723eULL, 0x000fe200000000ffULL, 0x000000011a1d7824ULL, 0x000fe200078e021bULL,
0x0000003e3f3e723eULL, 0x000fe200000000ffULL, 0x0000001026267824ULL, 0x100fe200078e0205ULL,
0x000000424342723eULL, 0x000fe200000000ffULL, 0x000000011b1c7824ULL, 0x000fe200078e021cULL,
0x000000061d007388ULL, 0x000fe20000000800ULL, 0x0000001028287824ULL, 0x100fe200078e0205ULL,
0x000000464746723eULL, 0x000fe200000000ffULL, 0x000000102a2a7824ULL, 0x100fe200078e0205ULL,
0x0000000b1c007388ULL, 0x000fe20000000800ULL, 0x000000011b1f7824ULL, 0x000fe200078e021eULL,
0x0000004a4b4a723eULL, 0x000fe200000000ffULL, 0x000000011b227824ULL, 0x040fe200078e0222ULL,
0x0000002a1b2a7210ULL, 0x040fe20007ffe0ffULL, 0x000000102c2c7824ULL, 0x100fe200078e0205ULL,
0x0000000c1f007388ULL, 0x000fe20000000800ULL, 0x000000011b237824ULL, 0x000fe200078e0224ULL,
0x0000004c4d4c723eULL, 0x000fe200000000ffULL, 0x000000011b267824ULL, 0x040fe200078e0226ULL,
0x0000000d22007388ULL, 0x000fe20000000800ULL, 0x000000011b277824ULL, 0x000fe200078e0228ULL,
0x000000505150723eULL, 0x000fe200000000ffULL, 0x000000011b297824ULL, 0x000fe200078e022cULL,
0x0000000e23007388ULL, 0x000fe20000000800ULL, 0x0000001030307824ULL, 0x100fe200078e0205ULL,
0x000000545554723eULL, 0x000fe200000000ffULL, 0x0000001034347824ULL, 0x000fe200078e0205ULL,
0x0000000f26007388ULL, 0x0003e20000000800ULL, 0x000000011b2b7824ULL, 0x000fe200078e0230ULL,
0x000000585958723eULL, 0x000fe200000000ffULL, 0x000000011b1b7824ULL, 0x000fe200078e0234ULL,
0x0000001027007388ULL, 0x000fe20000000800ULL, 0x0000005c5d5c723eULL, 0x000fc400000000ffULL,
0x000000606160723eULL, 0x000fe200000000ffULL, 0x000000112a007388ULL, 0x000fe20000000800ULL,
0x000000646564723eULL, 0x000fe200000000ffULL, 0x00000001080f7824ULL, 0x002fe200078e0203ULL,
0x000000686968723eULL, 0x000fe200000000ffULL, 0x0000002e29007388ULL, 0x000fe20000000800ULL,
0x0000004e4f12723eULL, 0x000fe200000000ffULL, 0x000000100f0b7824ULL, 0x000fe200078e0204ULL,
0x000000525313723eULL, 0x000fe200000000ffULL, 0x000400321c007388ULL, 0x000fe20000000800ULL,
0x000000565714723eULL, 0x000fc400000000ffULL, 0x0000005a5b15723eULL, 0x000fe200000000ffULL,
0x000400361f007388ULL, 0x000fe20000000800ULL, 0x0000005e5f16723eULL, 0x000fe400000000ffULL,
0x000000626317723eULL, 0x000fe200000000ffULL, 0x0004003a22007388ULL, 0x000fe20000000800ULL,
0x000000666718723eULL, 0x000fe400000000ffULL, 0x0000006a6b19723eULL, 0x000fe200000000ffULL,
0x0004003e23007388ULL, 0x000fe80000000800ULL, 0x0004004226007388ULL, 0x000fe80000000800ULL,
0x0004004627007388ULL, 0x000fe80000000800ULL, 0x0004004a2a007388ULL, 0x000fe80000000800ULL,
0x0000004c2b007388ULL, 0x000fe80000000800ULL, 0x000800501c007388ULL, 0x000fe80000000800ULL,
0x000800541f007388ULL, 0x000fe80000000800ULL, 0x0008005822007388ULL, 0x000fe80000000800ULL,
0x0008005c23007388ULL, 0x000fe80000000800ULL, 0x0008006026007388ULL, 0x000fe80000000800ULL,
0x0008006427007388ULL, 0x000fe80000000800ULL, 0x000800682a007388ULL, 0x000fe80000000800ULL,
0x000000121b007388ULL, 0x0003e80000000800ULL, 0x000c00131c007388ULL, 0x000fe80000000800ULL,
0x000c00141f007388ULL, 0x000fe20000000800ULL, 0x00000300ff1b7624ULL, 0x002fc600078e00ffULL,
0x000c001522007388ULL, 0x000fe40000000800ULL, 0x000000011b00780cULL, 0x000fe40003f05270ULL,
0x000c001623007388ULL, 0x000fe80000000800ULL, 0x000c001726007388ULL, 0x000fe80000000800ULL,
0x000c001827007388ULL, 0x000fe80000000800ULL, 0x000c00192a007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000b2c7984ULL, 0x000e680000000c00ULL,
0x000400000b1c7984ULL, 0x000ea80000000c00ULL, 0x000800000b347984ULL, 0x000ee80000000c00ULL,
0x000c00000b147984ULL, 0x000f280000000c00ULL, 0x001000000b107984ULL, 0x000ee80000000c00ULL,
0x001400000b307984ULL, 0x000f280000000c00ULL, 0x001800000b387984ULL, 0x000f280000000c00ULL,
0x001c00000b3c7984ULL, 0x000f220000000c00ULL, 0x200000ff2f2f7230ULL, 0x002fc40000000000ULL,
0x200000ff2e2e7230ULL, 0x000fe40000000000ULL, 0x200000ff2d2d7230ULL, 0x000fe40000000000ULL,
0x200000ff2c2c7230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x004fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fc40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x200000ff37377230ULL, 0x008fe40000000000ULL,
0x200000ff36367230ULL, 0x000fe40000000000ULL, 0x200000ff35357230ULL, 0x000fe40000000000ULL,
0x200000ff34347230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x010fc40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fe40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x000000132f2f7230ULL, 0x000fe40000000000ULL,
0x000000122e2e7230ULL, 0x000fe40000000000ULL, 0x000000112d2d7230ULL, 0x000fc40000000000ULL,
0x000000102c2c7230ULL, 0x000fe40000000000ULL, 0x000000331f1f7230ULL, 0x000fe40000000000ULL,
0x000000321e1e7230ULL, 0x000fe20000000000ULL, 0x0000002c0b007388ULL, 0x000fe20000000c00ULL,
0x000000311d1d7230ULL, 0x000fe40000000000ULL, 0x000000301c1c7230ULL, 0x000fe40000000000ULL,
0x0000003b37377230ULL, 0x000fc40000000000ULL, 0x0000003a36367230ULL, 0x000fe20000000000ULL,
0x0004001c0b007388ULL, 0x000fe20000000c00ULL, 0x0000003935357230ULL, 0x000fe40000000000ULL,
0x0000003834347230ULL, 0x000fe40000000000ULL, 0x0000003f17177230ULL, 0x000fe40000000000ULL,
0x0000003e16167230ULL, 0x000fe20000000000ULL, 0x000800340b007388ULL, 0x000fe20000000c00ULL,
0x0000003d15157230ULL, 0x000fc40000000000ULL, 0x0000003c14147230ULL, 0x000fca0000000000ULL,
0x000c00140b007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000394000008947ULL, 0x000fea0003800000ULL, 0x00000400ff067624ULL, 0x000fe200078e00ffULL,
0x00000000000d7919ULL, 0x000e620000002600ULL, 0x000000400f117810ULL, 0x000fc40007ffe0ffULL,
0x0000680006067a24ULL, 0x000fe200078e02ffULL, 0x00000000000e7919ULL, 0x000e620000002700ULL,
0x000000800f137810ULL, 0x000fc60007ffe0ffULL, 0x0000000f060c7811ULL, 0x040fe200078e10ffULL,
0x0000030006067a24ULL, 0x000fe200078e02ffULL, 0x000000000b1c7984ULL, 0x000ea40000000c00ULL,
0xfffffff00c277812ULL, 0x000fe400078ec0ffULL, 0x000400000b2c7984ULL, 0x000ee60000000c00ULL,
0x0000008006297824ULL, 0x040fe200078e0227ULL, 0x000800000b307984ULL, 0x000ea60000000c00ULL,
0x0000008006067824ULL, 0x000fe200078e0229ULL, 0x000c00000b347984ULL, 0x0008a80000000c00ULL,
0x0000007f06067810ULL, 0x000fe20007ffe0ffULL, 0x000004000e0d7a24ULL, 0x002fc600078e020dULL,
0xffffff8006187812ULL, 0x000fe200078ec0ffULL, 0x000003000d0c7a24ULL, 0x000fe200078e02ffULL,
0x000000c00f0b7810ULL, 0x010fc60007ffe0ffULL, 0x000000010c147824ULL, 0x000fe200078e0207ULL,
0x00006c0018077a10ULL, 0x000fc80007f1e0ffULL, 0x0000000714067211ULL, 0x000fe200078268ffULL,
0x00006d00ff077624ULL, 0x000fe200000e06ffULL, 0x0000000121ff7812ULL, 0x000fc8000780f800ULL,
0x0000000714077211ULL, 0x000fe400008f6cffULL, 0x00006c0027197a10ULL, 0x000fc60007f3e0ffULL,
0x000010000a067825ULL, 0x000fc800078e0006ULL, 0x00006d00ff1a7624ULL, 0x000fe400008e06ffULL,
0x000000100f0e7825ULL, 0x000fc800078e0006ULL, 0x0000001011107825ULL, 0x000fc800078e0006ULL,
0x0000001013127825ULL, 0x000fc800078e0006ULL, 0x000000100b067825ULL, 0x000fe200078e0006ULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x00000010030b7824ULL, 0x00cfe200078e00ffULL,
0x00000001ff157819ULL, 0x000fe20000011603ULL, 0x0000008014167824ULL, 0x000fc600078e00ffULL,
0x000000700b227812ULL, 0x000fe400078ec0ffULL, 0x0000000c15157812ULL, 0x000fe400078ec0ffULL,
0x00006c0016177a10ULL, 0x000fe40007ebe029ULL, 0x00000019ff0b7819ULL, 0x000fe40000011614ULL,
0x0000001922147210ULL, 0x000fe40007a3e016ULL, 0x0000001715167210ULL, 0x000fc40007c7e022ULL,
0x00006d000b177a10ULL, 0x000fe40002fec4ffULL, 0x0000001415147210ULL, 0x000fe40007fbe0ffULL,
0x0000001aff0b7210ULL, 0x000fe40000fe440bULL, 0x00000017ff177210ULL, 0x000fc60001fe84ffULL,
0x000000ffff157224ULL, 0x000fca00028e060bULL, 0x0000002014007986ULL, 0x0003e8000c101908ULL,
0x0000002516007986ULL, 0x0003e4000c101908ULL, 0x000000ff0300720cULL, 0x00cfe20000705670ULL,
0x0000001c0e007986ULL, 0x000fe2000c101d08ULL, 0x0000017000007945ULL, 0x000fe60003800000ULL,
0x0000002c10007986ULL, 0x000fe8000c101d08ULL, 0x0000003012007986ULL, 0x000fe8000c101d08ULL,
0x0000003406007986ULL, 0x000fe8000c101d08ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000004ff067424ULL, 0x000fe200078e00ffULL,
0xffffffff1b0b7810ULL, 0x000fc60007ffe0ffULL, 0x00006c000d067625ULL, 0x000fe200078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x0000000b060679a8ULL, 0x000ea400099ee1c8ULL,
0x0000000b0600720cULL, 0x004fc80003f05270ULL, 0x00000001ff0d7807ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x0000000dff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000ff067984ULL, 0x000ee40000000000ULL, 0x000000ff0600720cULL, 0x008fda0003f05270ULL,
0x0000344000008947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x00000a5000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x000001b000008947ULL, 0x000fea0003800000ULL, 0x0000001003007824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe40000011603ULL, 0x000000190c067211ULL, 0x000fe400078038ffULL,
0x0000007000077812ULL, 0x000fe400078ec0ffULL, 0x0000000c0b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000001a0c007211ULL, 0x000fe400000f3cffULL, 0x000000060b067210ULL, 0x000fc8000791e007ULL,
0x00000000ff077210ULL, 0x000fca00007e24ffULL, 0x0000000806007981ULL, 0x000728000c1e1900ULL,
0x00008008060b7981ULL, 0x000722000c1e1900ULL, 0x000000021b00780cULL, 0x000fda0003f05270ULL,
0x000000f000008947ULL, 0x000fea0003800000ULL, 0x00010008060f7981ULL, 0x008722000c1e1900ULL,
0x000000041b00780cULL, 0x000fda0003f06070ULL, 0x000000c000008947ULL, 0x000fea0003800000ULL,
0x0001800806117981ULL, 0x008722000c1e1900ULL, 0x000000041b00780cULL, 0x000fda0003f05270ULL,
0x0000009000008947ULL, 0x000fea0003800000ULL, 0x0002000806137981ULL, 0x008722000c1e1900ULL,
0x000000061b00780cULL, 0x000fda0003f06070ULL, 0x0000006000008947ULL, 0x000fea0003800000ULL,
0x0002800806157981ULL, 0x00a322000c1e1900ULL, 0x000000061b00780cULL, 0x000fda0003f05270ULL,
0x0000003000008947ULL, 0x000fea0003800000ULL, 0x000000081b00780cULL, 0x002fe20003f06070ULL,
0x0003000806177981ULL, 0x000318000c1e1900ULL, 0x0003800806190981ULL, 0x000324000c1e1900ULL,
0x000000071b067810ULL, 0x00afc80007ffe0ffULL, 0x00000003ff0d7819ULL, 0x004fc80000011606ULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x000007d000008947ULL, 0x000fea0003800000ULL,
0x000000270c1d7211ULL, 0x040fe200078038ffULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1b7224ULL, 0x010fe200078e0000ULL,
0x00006c001d1d7a10ULL, 0x000fe40007f3e0ffULL, 0x000000ff0c0e7211ULL, 0x000fe400000f3cffULL,
0x000007801d1d7810ULL, 0x000fc80007f5e0ffULL, 0x00006d00ff0e7a10ULL, 0x000fc400017e240eULL,
0x0000030010007a0cULL, 0x000fe20003f26070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x000000040d007c0cULL, 0x000fcc000bf03070ULL, 0x000006d000001947ULL, 0x012fea0003800000ULL,
0x0000000810067810ULL, 0x040fe40007ffe0ffULL, 0x0000000110077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000001b00007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011603ULL,
0x0000007006067812ULL, 0x000fc800078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ef807ULL,
0x000000061d067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e060eULL,
0xfffc8008061b7981ULL, 0x000326000c1e1900ULL, 0x000005f000002947ULL, 0x000fea0003800000ULL,
0x0000000910067810ULL, 0x042fe40007ffe0ffULL, 0x0000000210077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000000b00007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011603ULL,
0x0000007006067812ULL, 0x000fc800078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ef807ULL,
0x000000061d067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e060eULL,
0xfffd0008060b7981ULL, 0x000326000c1e1900ULL, 0x0000051000002947ULL, 0x000fea0003800000ULL,
0x0000000a10067810ULL, 0x042fe40007ffe0ffULL, 0x0000000310077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000000f00007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011603ULL,
0x0000007006067812ULL, 0x000fc800078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ef807ULL,
0x000000061d067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e060eULL,
0xfffd8008060f7981ULL, 0x000326000c1e1900ULL, 0x0000043000002947ULL, 0x000fea0003800000ULL,
0x0000000b10067810ULL, 0x042fe40007ffe0ffULL, 0x0000000410077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000001100007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011603ULL,
0x0000007006067812ULL, 0x000fc800078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ef807ULL,
0x000000061d067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e060eULL,
0xfffe000806117981ULL, 0x000326000c1e1900ULL, 0x0000035000002947ULL, 0x000fea0003800000ULL,
0x0000000c10067810ULL, 0x042fe40007ffe0ffULL, 0x0000000510077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000001300007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011603ULL,
0x0000007006067812ULL, 0x000fc800078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ef807ULL,
0x000000061d067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e060eULL,
0xfffe800806137981ULL, 0x000326000c1e1900ULL, 0x0000027000002947ULL, 0x000fea0003800000ULL,
0x0000000d10067810ULL, 0x042fe40007ffe0ffULL, 0x0000000610077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000001500007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011603ULL,
0x0000007006067812ULL, 0x000fc800078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ef807ULL,
0x000000061d067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e060eULL,
0xffff000806157981ULL, 0x000326000c1e1900ULL, 0x0000019000002947ULL, 0x000fea0003800000ULL,
0x0000000e10067810ULL, 0x042fe40007ffe0ffULL, 0x0000000710077810ULL, 0x000fe40007ffe0ffULL,
0x0000030006007a0cULL, 0x000fe40003f26070ULL, 0x0000030007007a0cULL, 0x000fe40003f46070ULL,
0x0000001700007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011603ULL,
0x0000007006067812ULL, 0x000fc800078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ef807ULL,
0x000000061d067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e060eULL,
0xffff800806177981ULL, 0x000326000c1e1900ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000000f10067810ULL, 0x002fe40007ffe0ffULL, 0x0000001900007209ULL, 0x000fe40007810000ULL,
0x0000030006007a0cULL, 0x000fda0003f26070ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001003067824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011603ULL,
0x0000007006067812ULL, 0x000fc800078ec0ffULL, 0x0000000c06067812ULL, 0x000fc800078ef807ULL,
0x000000061d067210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff077224ULL, 0x000fca00008e060eULL,
0x0000000806197981ULL, 0x000326000c1e1900ULL, 0x000004001d1d7810ULL, 0x000fe40007f3e0ffULL,
0x0000000810107810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e060eULL,
0xfffff8b000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000ea40000000000ULL,
0x0000001003067824ULL, 0x006fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fc80000011603ULL,
0x0000007006067812ULL, 0x000fe400078ec0ffULL, 0x0000000c07077812ULL, 0x000fca00078ec0ffULL,
0x0000000106077824ULL, 0x000fca00078e0207ULL, 0x0000000007007388ULL, 0x0103e40000000800ULL,
0x00006c0018067a10ULL, 0x000fe20007f3e0ffULL, 0x0000000121117824ULL, 0x000fe200078e020cULL,
0x000000070300780cULL, 0x000fe20003f04070ULL, 0x000010000a007824ULL, 0x002fe200078e00ffULL,
0x00000001210b7812ULL, 0x000fe200078ec0ffULL, 0x00006d00ff077624ULL, 0x000fe200008e06ffULL,
0x00000001ff127819ULL, 0x000fe20000011603ULL, 0x0000001003137824ULL, 0x040fe200078e00ffULL,
0x0000002003177810ULL, 0x000fe20007ffe0ffULL, 0x00002000110e7825ULL, 0x000fe200078e0006ULL,
0x0000004003197810ULL, 0x000fe20007ffe0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000221108824ULL, 0x140fe200078e020aULL, 0x000000000e0e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000221208824ULL, 0x000fe200078e020aULL, 0x00000060031b7810ULL, 0x040fe20007ffe0ffULL,
0x00000002102a8824ULL, 0x000fe200078e020bULL, 0x00000080031d7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e060fULL, 0x000000a0031f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000220208824ULL, 0x000fe200078e020bULL, 0x000000c003237810ULL, 0x000fe20007ffe0ffULL,
0x0000001017167825ULL, 0x000fe200078e000eULL, 0x000000e003257810ULL, 0x000fe20007ffe0ffULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000100009107812ULL, 0x000fe200078ec0ffULL,
0x0000400021097824ULL, 0x000fe200078e0204ULL, 0x0000007013137812ULL, 0x000fe200078ec0ffULL,
0x0000001019187825ULL, 0x100fe200078e000eULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00006c00290d7a10ULL, 0x004fe20007f3e0ffULL,
0x000000101b1a7825ULL, 0x100fe200078e000eULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x000000101d1c7825ULL, 0x100fe200078e000eULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x000000101f1e7825ULL, 0x100fe200078e000eULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000001023227825ULL, 0x100fe200078e000eULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000001025247825ULL, 0x100fe200078e000eULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000001003147825ULL, 0x000fe200078e000eULL, 0x00006c00270e7a10ULL, 0x000fe20007f5e0ffULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000000109107824ULL, 0x000fc400078e0210ULL, 0x00000001130b7824ULL, 0x000fe400078e0212ULL,
0x00006d00ff0f7624ULL, 0x000fe200008e06ffULL, 0x0000000d11268211ULL, 0x000fe200078238ffULL,
0x00000010032b7824ULL, 0x000fe400078e0210ULL, 0x00006d00ff107624ULL, 0x000fe200010e06ffULL,
0x0000000e11288211ULL, 0x040fe200078438ffULL, 0x000000000b0b7984ULL, 0x000e620000000800ULL,
0x0000000f11278211ULL, 0x000fe200008f3cffULL, 0x0000000820208824ULL, 0x100fe200078e0203ULL,
0x0000030021007a0cULL, 0x000fe20003f26070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000142b7faeULL, 0x0005e2000b901c48ULL, 0x0000001011298211ULL, 0x000fe200010f3cffULL,
0x000000082a2a8824ULL, 0x000fc400078e0203ULL, 0x00380000162b7faeULL, 0x0007e2000b901c48ULL,
0x0000001003268825ULL, 0x040fe400078e0026ULL, 0x000081802a2d8811ULL, 0x000fe200078e20ffULL,
0x00580000182b7faeULL, 0x0009e2000b901c48ULL, 0x0000001003288825ULL, 0x000fc600078e0028ULL,
0x007800001a2b7faeULL, 0x0009e2000b901c48ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x0000000000147805ULL, 0x004fe2000001ff00ULL, 0x000000ffff557224ULL, 0x000fe200078e00ffULL,
0x009800001c2b7faeULL, 0x0005e2000b901c48ULL, 0x0000000000167805ULL, 0x008fc6000001ff00ULL,
0x00b800001e2b7faeULL, 0x0007e2000b901c48ULL, 0x0000000000187805ULL, 0x010fe2000001ff00ULL,
0x00008580201b8811ULL, 0x000fe400078e20ffULL, 0x00d80000222b7faeULL, 0x0009e2000b901c48ULL,
0x000000ffff207224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x004fe4000001ff00ULL,
0x00f80000242b7faeULL, 0x0005e2000b901c48ULL, 0x00000000001e7805ULL, 0x008fc6000001ff00ULL,
0x00000000261b8faeULL, 0x0007e8000b901c48ULL, 0x00000000282d8faeULL, 0x0003e2000b901c48ULL,
0x0000000000227805ULL, 0x010fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000247805ULL, 0x004fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x008fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x002fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x000012e000001947ULL, 0x000fea0003800000ULL, 0x000000ffff117224ULL, 0x000fe400078e00ffULL,
0x000000ffff547224ULL, 0x000fca00078e0021ULL, 0x0000000154577810ULL, 0x000fc80007ffe0ffULL,
0x0000030057007a0cULL, 0x000fda0003f06070ULL, 0x0000034000000947ULL, 0x000fea0003800000ULL,
0x000000070300780cULL, 0x000fe20003f44070ULL, 0x000000010c677824ULL, 0x000fe200078e0257ULL,
0x0000000157587812ULL, 0x040fe200078ec0ffULL, 0x0000100057567824ULL, 0x000fe200078e00ffULL,
0x00000060035d7810ULL, 0x000fe20007ffe0ffULL, 0x0000200067127825ULL, 0x000fe200078e0006ULL,
0x00000080035f7810ULL, 0x000fe40007ffe0ffULL, 0x0000100056567812ULL, 0x000fe400078ec0ffULL,
0x0000000012127210ULL, 0x000fc40007f1e0ffULL, 0x0000005609567210ULL, 0x000fe20007ffe0ffULL,
0x000000022159a824ULL, 0x100fe200078e020aULL, 0x000000a003617810ULL, 0x000fe20007ffe0ffULL,
0x00000002215ba824ULL, 0x000fe200078e020aULL, 0x000000c003637810ULL, 0x000fe20007ffe0ffULL,
0x000000025968a824ULL, 0x100fe200078e0258ULL, 0x0000002003597810ULL, 0x000fe20007ffe0ffULL,
0x000000025b6aa824ULL, 0x000fe200078e0258ULL, 0x00000040035b7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x000000e003657810ULL, 0x040fe20007ffe0ffULL,
0x0000001003697824ULL, 0x000fe200078e0256ULL, 0x0000000d6764a211ULL, 0x000fe200078038ffULL,
0x0000001003567825ULL, 0x000fe200078e0012ULL, 0x0000000e6766a211ULL, 0x000fc600078238ffULL,
0x0000001059587825ULL, 0x100fe200078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000056697faeULL, 0x0003e6000b901c48ULL, 0x000000105b5a7825ULL, 0x100fe200078e0012ULL,
0x0038000058697faeULL, 0x0005e6000b901c48ULL, 0x000000105d5c7825ULL, 0x100fe200078e0012ULL,
0x005800005a697faeULL, 0x0007e6000b901c48ULL, 0x000000105f5e7825ULL, 0x100fe200078e0012ULL,
0x007800005c697faeULL, 0x0007e6000b901c48ULL, 0x0000001061607825ULL, 0x100fe200078e0012ULL,
0x009800005e697faeULL, 0x0007e6000b901c48ULL, 0x0000001063627825ULL, 0x100fe200078e0012ULL,
0x00b8000060697faeULL, 0x0007e6000b901c48ULL, 0x0000001065127825ULL, 0x000fe200078e0012ULL,
0x0000000f6765a211ULL, 0x040fe200000f3cffULL, 0x00d8000062697faeULL, 0x0007e2000b901c48ULL,
0x000000106767a211ULL, 0x000fe200008f3cffULL, 0x000000086868a824ULL, 0x000fc400078e0203ULL,
0x000000086a6aa824ULL, 0x000fe200078e0203ULL, 0x00f8000012697faeULL, 0x0007e2000b901c48ULL,
0x000000100364a825ULL, 0x040fe200078e0064ULL, 0x00008580686ba811ULL, 0x000fe400078e20ffULL,
0x000081806a59a811ULL, 0x004fe200078e20ffULL, 0x000000100356a825ULL, 0x002fe400078e0066ULL,
0x00000000646bafaeULL, 0x0007e8000b901c48ULL, 0x000000005659afaeULL, 0x0007e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000008054127824ULL, 0x008fe200078e00ffULL,
0x00000001ff587819ULL, 0x100fe20000011603ULL, 0x0000000221577824ULL, 0x000fe200078e020aULL,
0x00000002ff6b7819ULL, 0x000fe20000011603ULL, 0x0000001003137824ULL, 0x000fe200078e00ffULL,
0x0000008012127812ULL, 0x000fc400078ec0ffULL, 0x000000026b597810ULL, 0x040fe20007ffe0ffULL,
0x000000086b617824ULL, 0x000fe200078e00ffULL, 0x0000007013137812ULL, 0x000fe200078ec0ffULL,
0x0000010057567824ULL, 0x000fe200078e0012ULL, 0x0000000c58127812ULL, 0x000fe200078ec0ffULL,
0x000000086b5a7824ULL, 0x040fe200078e00ffULL, 0x000000086b6d7810ULL, 0x040fe20007ffe0ffULL,
0x000000086b5c7824ULL, 0x040fe200078e00ffULL, 0x0000005612577210ULL, 0x000fe20007ffe013ULL,
0x000000086b677824ULL, 0x040fe200078e00ffULL, 0x000000016b567810ULL, 0x000fe20007ffe0ffULL,
0x000000086d5e7824ULL, 0x000fe200078e00ffULL, 0xfffffff85a637812ULL, 0x000fe200078ee259ULL,
0x0000000403597824ULL, 0x000fe200078e00ffULL, 0xfffffff861617812ULL, 0x000fe200078ee256ULL,
0x0000100054567824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0081800057587984ULL, 0x000e620000000800ULL, 0x0000100056567812ULL, 0x000fe200078ec0ffULL,
0x000000086b6f7824ULL, 0x000fe200078e00ffULL, 0x0000000c59687812ULL, 0x000fe200078ec0ffULL,
0x00858000575f7984ULL, 0x0004e20000000800ULL, 0x0000018009567810ULL, 0x000fe20007ffe056ULL,
0x000000086b717824ULL, 0x040fe200078e00ffULL, 0x000000046b5b7810ULL, 0x040fe20007ffe0ffULL,
0x000000086b607824ULL, 0x040fe200078e00ffULL, 0x000000106b737810ULL, 0x040fe40007ffe0ffULL,
0x000000186b757810ULL, 0x000fc40007ffe0ffULL, 0xfffffff85c577812ULL, 0x044fe400078ee26bULL,
0xfffffff85c697812ULL, 0x000fe200078ee25bULL, 0x00000008735c7824ULL, 0x000fe200078e00ffULL,
0xfffffff85e597812ULL, 0x000fe200078ee26dULL, 0x0000001057577824ULL, 0x000fe200078e0256ULL,
0x000000036b5a7810ULL, 0x000fe20007ffe0ffULL, 0x00000008755e7824ULL, 0x000fe200078e00ffULL,
0xfffffff85c5b7812ULL, 0x000fe200078ee273ULL, 0x0000000168577824ULL, 0x000fe200078e0257ULL,
0xfffffff867677812ULL, 0x000fe200078ee25aULL, 0x0000001059597824ULL, 0x100fe200078e0256ULL,
0xfffffff85e5d7812ULL, 0x000fe200078ee275ULL, 0x000000105b5b7824ULL, 0x100fe200078e0256ULL,
0x000000056b5a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000057577984ULL, 0x000ea20000000800ULL,
0x0000000168597824ULL, 0x040fe200078e0259ULL, 0x000000066b5c7810ULL, 0x000fe20007ffe0ffULL,
0x000000105d5d7824ULL, 0x000fe200078e0256ULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee25aULL,
0x00000001685b7824ULL, 0x040fe200078e025bULL, 0x0000000059647984ULL, 0x0008a20000000800ULL,
0x00000001685e7824ULL, 0x000fe200078e025dULL, 0xfffffff871717812ULL, 0x000fe200078ee25cULL,
0x00000010695d7824ULL, 0x100fe200078e0256ULL, 0x000000005b657984ULL, 0x000ea20000000800ULL,
0x00000010675c7824ULL, 0x000fe200078e0256ULL, 0x0000000254547810ULL, 0x000fe20007ffe0ffULL,
0x000000580b587221ULL, 0x002fe20000010100ULL, 0x000000005e667984ULL, 0x000fe20000000800ULL,
0x0000001063597824ULL, 0x010fe200078e0256ULL, 0x0000030054007a0cULL, 0x000fe20003f06070ULL,
0x3fb8aa3b58587820ULL, 0x000fc40000410000ULL, 0x00000001685a7824ULL, 0x040fe400078e0259ULL,
0x00000001685d7824ULL, 0x040fe400078e025dULL, 0x0000005800587308ULL, 0x000ee20000000800ULL,
0x00000001685c7824ULL, 0x000fe200078e025cULL, 0x000000005a5b7984ULL, 0x000fe80000000800ULL,
0x000000005d5e7984ULL, 0x000e620000000800ULL, 0x0000005f586c7220ULL, 0x008fe20000410000ULL,
0xffffffff6b5f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001061587824ULL, 0x000fe200078e0256ULL,
0x30000057ff637230ULL, 0x004fe20000004100ULL, 0x000000556c557221ULL, 0x000fe20000010000ULL,
0xfffffff860617812ULL, 0x000fe200078ee25fULL, 0x0000000168587824ULL, 0x040fe200078e0258ULL,
0x00001f6d6c6d7589ULL, 0x000ea200000e0000ULL, 0x0000001071607824ULL, 0x100fe200078e0256ULL,
0x20000064ff6a7230ULL, 0x000fe20000004100ULL, 0x000000106f5f7824ULL, 0x100fe200078e0256ULL,
0x0000000058597984ULL, 0x000fe20000000800ULL, 0x0000001061627824ULL, 0x000fe200078e0256ULL,
0x20000065ff677230ULL, 0x100fe20000004100ULL, 0x0000000168617824ULL, 0x040fe200078e0260ULL,
0x000000005c567984ULL, 0x000fe20000000800ULL, 0x00000001685f7824ULL, 0x040fe200078e025fULL,
0x30000065ff657230ULL, 0x000fe20000004100ULL, 0x0000000168627824ULL, 0x000fe200078e0262ULL,
0x00001f6b6c6b7589ULL, 0x000ee200000e0000ULL, 0x20000057ff687230ULL, 0x000fc60000004100ULL,
0x00001f736c6e7589ULL, 0x000f2800000e0000ULL, 0x00001f756c6f7589ULL, 0x000f2200000e0000ULL,
0x2000005eff697230ULL, 0x002fc60000004100ULL, 0x0000000061577984ULL, 0x000e620000000800ULL,
0x0000006d6a4f7223ULL, 0x004fe2000001004fULL, 0x20000066ff6a7230ULL, 0x000fe40000004100ULL,
0x000000005f607984ULL, 0x000ea20000000800ULL, 0x3000005eff5e7230ULL, 0x000fe20000004100ULL,
0x0000006b68517223ULL, 0x088fe20000010051ULL, 0x30000064ff687230ULL, 0x000fe20000004100ULL,
0x0000006b63507223ULL, 0x000fe20000010050ULL, 0x0004000058647984ULL, 0x000ee20000000800ULL,
0x0000006e65327223ULL, 0x010fc40000010032ULL, 0x0000006d68337223ULL, 0x000fe20000010033ULL,
0x0000000062637984ULL, 0x000f220000000800ULL, 0x0000006f6a317223ULL, 0x000fe20000010031ULL,
0x30000066ff6a7230ULL, 0x000fe20000004100ULL, 0x0000006e674e7223ULL, 0x000fe2000001004eULL,
0x000400005a657984ULL, 0x000f220000000800ULL, 0x20000059ff667230ULL, 0x100fe20000004100ULL,
0x0000006b69447223ULL, 0x080fe20000010044ULL, 0x30000059ff687230ULL, 0x000fe20000004100ULL,
0x0000006b5e417223ULL, 0x080fe20000010041ULL, 0x000400005c597984ULL, 0x000f220000000800ULL,
0x0000006b662f7223ULL, 0x080fe2000001002fULL, 0x2000005bff677230ULL, 0x100fe20000004100ULL,
0x0000006b684d7223ULL, 0x000fe2000001004dULL, 0x000400005d667984ULL, 0x000f220000000800ULL,
0x3000005bff687230ULL, 0x000fe20000004100ULL, 0x0000006f6a477223ULL, 0x000fe20000010047ULL,
0x20000056ff5b7230ULL, 0x100fe20000004100ULL, 0x0000006b674c7223ULL, 0x080fe2000001004cULL,
0x30000056ff567230ULL, 0x000fe20000004100ULL, 0x000400005f677984ULL, 0x000f220000000800ULL,
0x0000006b68377223ULL, 0x080fe20000010037ULL, 0x20000057ff697230ULL, 0x102fe20000004100ULL,
0x0000006b5b487223ULL, 0x080fe20000010048ULL, 0x30000057ff5e7230ULL, 0x000fe20000004100ULL,
0x0000006b56457223ULL, 0x080fe20000010045ULL, 0x0004000062577984ULL, 0x000e620000000800ULL,
0x20000060ff5b7230ULL, 0x104fe20000004100ULL, 0x0000006b693c7223ULL, 0x080fe2000001003cULL,
0x30000060ff607230ULL, 0x000fe20000004100ULL, 0x0004000061567984ULL, 0x000ea20000000800ULL,
0x0000006b5e397223ULL, 0x000fc40000010039ULL, 0x0000006b5b207223ULL, 0x080fe40000010020ULL,
0x0000006b603d7223ULL, 0x000fe2000001003dULL, 0x00080000585b7984ULL, 0x000ea20000000800ULL,
0x20000064ff687230ULL, 0x108fe40000004100ULL, 0x30000064ff697230ULL, 0x000fe20000004100ULL,
0x000c000058607984ULL, 0x000ee20000000800ULL, 0x20000063ff5e7230ULL, 0x110fe20000004100ULL,
0x0000006d68357223ULL, 0x080fe20000010035ULL, 0x30000063ff637230ULL, 0x000fe20000004100ULL,
0x0000006d694a7223ULL, 0x000fe2000001004aULL, 0x20000065ff647230ULL, 0x100fe20000004100ULL,
0x0000006b5e4b7223ULL, 0x080fe2000001004bULL, 0x30000065ff657230ULL, 0x000fe20000004100ULL,
0x000800005a5e7984ULL, 0x000f220000000800ULL, 0x0000006b63367223ULL, 0x000fe20000010036ULL,
0x20000059ff697230ULL, 0x100fe20000004100ULL, 0x0000006d641b7223ULL, 0x080fe2000001001bULL,
0x30000059ff647230ULL, 0x000fe20000004100ULL, 0x000800005c587984ULL, 0x000f220000000800ULL,
0x20000066ff597230ULL, 0x100fe20000004100ULL, 0x0000006d65307223ULL, 0x080fe20000010030ULL,
0x30000066ff667230ULL, 0x000fe20000004100ULL, 0x0000006d69467223ULL, 0x080fe20000010046ULL,
0x000c00005a637984ULL, 0x000f220000000800ULL, 0x0000006d59407223ULL, 0x080fe20000010040ULL,
0x20000067ff657230ULL, 0x100fe20000004100ULL, 0x0000006d64277223ULL, 0x080fe20000010027ULL,
0x000800005d597984ULL, 0x000f220000000800ULL, 0x30000067ff687230ULL, 0x000fe20000004100ULL,
0x0000006d66257223ULL, 0x080fe20000010025ULL, 0x20000057ff6b7230ULL, 0x102fe20000004100ULL,
0x0000006d653e7223ULL, 0x080fe2000001003eULL, 0x30000057ff577230ULL, 0x000fe20000004100ULL,
0x000c00005d657984ULL, 0x0003220000000800ULL, 0x20000056ff677230ULL, 0x104fe20000004100ULL,
0x0000006d683b7223ULL, 0x080fe2000001003bULL, 0x30000056ff697230ULL, 0x000fe20000004100ULL,
0x0000006d57347223ULL, 0x080fe20000010034ULL, 0x000800005f567984ULL, 0x000ea20000000800ULL,
0x0000006d67267223ULL, 0x080fe20000010026ULL, 0x3000005bff677230ULL, 0x100fe20000004100ULL,
0x0000006d69387223ULL, 0x080fe20000010038ULL, 0x0008000061577984ULL, 0x000ea20000000800ULL,
0x2000005bff5d7230ULL, 0x002fe20000004100ULL, 0x0000006d6b1c7223ULL, 0x000fe2000001001cULL,
0x20000060ff5a7230ULL, 0x108fe20000004100ULL, 0x000c00005c647984ULL, 0x000e620000000800ULL,
0x30000060ff697230ULL, 0x000fe20000004100ULL, 0x0000006e5d187223ULL, 0x000fc40000010018ULL,
0x000c0000615b7984ULL, 0x000ee20000000800ULL, 0x0000006f5a2d7223ULL, 0x080fe2000001002dULL,
0x2000005eff607230ULL, 0x110fe20000004100ULL, 0x0000006e672e7223ULL, 0x080fe2000001002eULL,
0x000c00005f5c7984ULL, 0x0008e20000000800ULL, 0x0000006f692c7223ULL, 0x000fe4000001002cULL,
0x0000006e602b7223ULL, 0x000fe2000001002bULL, 0x00080000625a7984ULL, 0x000ee80000000800ULL,
0x000c0000625d7984ULL, 0x000ee20000000800ULL, 0x3000005eff5f7230ULL, 0x010fc40000004100ULL,
0x20000058ff5e7230ULL, 0x100fe40000004100ULL, 0x20000063ff667230ULL, 0x000fe20000004100ULL,
0x0000006e5f427223ULL, 0x080fe20000010042ULL, 0x30000058ff5f7230ULL, 0x000fe20000004100ULL,
0x0000006e5e3f7223ULL, 0x080fe2000001003fULL, 0x20000059ff587230ULL, 0x100fe20000004100ULL,
0x0000006f66297223ULL, 0x080fe20000010029ULL, 0x30000059ff5e7230ULL, 0x000fe20000004100ULL,
0x0000006e5f2a7223ULL, 0x080fe2000001002aULL, 0x30000063ff637230ULL, 0x000fe20000004100ULL,
0x0000006e58237223ULL, 0x080fe20000010023ULL, 0x20000065ff587230ULL, 0x100fe20000004100ULL,
0x0000006e5e1f7223ULL, 0x080fe2000001001fULL, 0x20000056ff597230ULL, 0x104fe20000004100ULL,
0x0000006f63287223ULL, 0x080fe20000010028ULL, 0x30000056ff567230ULL, 0x000fe20000004100ULL,
0x0000006f58437223ULL, 0x080fe20000010043ULL, 0x30000065ff657230ULL, 0x000fe20000004100ULL,
0x0000006e591e7223ULL, 0x080fe2000001001eULL, 0x20000057ff597230ULL, 0x100fe20000004100ULL,
0x0000006e561d7223ULL, 0x080fe2000001001dULL, 0x30000057ff577230ULL, 0x000fe20000004100ULL,
0x0000006f653a7223ULL, 0x080fe2000001003aULL, 0x20000064ff617230ULL, 0x102fe20000004100ULL,
0x0000006e59147223ULL, 0x080fe20000010014ULL, 0x2000005bff567230ULL, 0x108fe20000004100ULL,
0x0000006e571a7223ULL, 0x080fe2000001001aULL, 0x30000064ff637230ULL, 0x000fe20000004100ULL,
0x0000006f61227223ULL, 0x080fe20000010022ULL, 0x2000005cff587230ULL, 0x100fe20000004100ULL,
0x0000006f56197223ULL, 0x080fe20000010019ULL, 0x3000005cff5c7230ULL, 0x000fe20000004100ULL,
0x0000006f63247223ULL, 0x080fe20000010024ULL, 0x2000005aff567230ULL, 0x100fe20000004100ULL,
0x0000006f58497223ULL, 0x080fe20000010049ULL, 0x3000005aff577230ULL, 0x000fe20000004100ULL,
0x0000006f5c537223ULL, 0x080fe20000010053ULL, 0x3000005bff5b7230ULL, 0x000fe20000004100ULL,
0x0000006e56177223ULL, 0x080fe20000010017ULL, 0x2000005dff587230ULL, 0x100fe20000004100ULL,
0x0000006e57167223ULL, 0x000fe20000010016ULL, 0x3000005dff5a7230ULL, 0x000fe20000004100ULL,
0x0000006f5b527223ULL, 0x000fc40000010052ULL, 0x0000006f58157223ULL, 0x080fe40000010015ULL,
0x0000006f5a117223ULL, 0x000fe20000010011ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffed4000007947ULL, 0x000fea000383ffffULL, 0x000000ff0a00720cULL, 0x000fe20003f05270ULL,
0x0000018000007945ULL, 0x000fd80003800000ULL, 0x0000008021038824ULL, 0x000fc800078e0213ULL,
0x0000000112008824ULL, 0x000fe400078e0203ULL, 0x0000000113127824ULL, 0x000fc600078e0212ULL,
0x0089805500008388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0089800012037984ULL, 0x000e680000000800ULL, 0x008a000012067984ULL, 0x000ea20000000800ULL,
0x00000003ff037221ULL, 0x002fc80000010000ULL, 0x0000000603037221ULL, 0x004fca0000010000ULL,
0x0180000003067810ULL, 0x000fc80007ffe0ffULL, 0x7f80000006067812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0600780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e0003ULL,
0x0000d160000c7802ULL, 0x000fc40000000f00ULL, 0x0000d44000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000300007308ULL, 0x000e640000001000ULL, 0xbf80000003067423ULL, 0x002fc80000000000ULL,
0x800000ff06077221ULL, 0x000fc80000010100ULL, 0x0000000700007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000803577811ULL, 0x004fc400078ff0ffULL,
0x00000002ff557819ULL, 0x000fe40000011603ULL, 0x0000001003597811ULL, 0x040fe200078ff0ffULL,
0x00001f5700077589ULL, 0x000ea200000e0000ULL, 0x00000018035b7811ULL, 0x000fe200078ff0ffULL,
0x0000000855567824ULL, 0x000fe400078e00ffULL, 0x00001f5500067589ULL, 0x002e6200000e0000ULL,
0x0000000857587824ULL, 0x000fe400078e00ffULL, 0x000000085b5c7824ULL, 0x000fe200078e00ffULL,
0x00001f59000b7589ULL, 0x000ee200000e0000ULL, 0x00000008595a7824ULL, 0x000fe200078e00ffULL,
0xfffffff858587812ULL, 0x000fc400078ee257ULL, 0x00001f5b00107589ULL, 0x00086200000e0000ULL,
0xfffffff85c5c7812ULL, 0x000fe400078ee25bULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee259ULL,
0x0000001058587824ULL, 0x100fe400078e0205ULL, 0x000000105c5c7824ULL, 0x000fe200078e0205ULL,
0x000000055a5a7211ULL, 0x000fe200078e20ffULL, 0x0000004f074f7220ULL, 0x044fe40000410000ULL,
0x00000033070e7220ULL, 0x000fe20000410000ULL, 0x0000000355337810ULL, 0x000fe20007ffe0ffULL,
0x0000003507357220ULL, 0x000fc40000410000ULL, 0x0000004a074a7220ULL, 0x040fe20000410000ULL,
0x0000004f0e0e723eULL, 0x000fe200000000ffULL, 0x0000001b071b7220ULL, 0x040fe40000410000ULL,
0x0000003007307220ULL, 0x040fe20000410000ULL, 0x000000354a35723eULL, 0x000fe200000000ffULL,
0x0000004607467220ULL, 0x040fe40000410000ULL, 0x0000002707277220ULL, 0x040fe20000410000ULL,
0x0000001b301b723eULL, 0x000fe200000000ffULL, 0x0000004007407220ULL, 0x000fc40000410000ULL,
0x0000002507257220ULL, 0x000fe20000410000ULL, 0x000000462727723eULL, 0x000fe200000000ffULL,
0x0000003e073e7220ULL, 0x040fe40000410000ULL, 0x0000003b073b7220ULL, 0x000fe20000410000ULL,
0x000000402525723eULL, 0x000fe200000000ffULL, 0x0000002607267220ULL, 0x040fe40000410000ULL,
0x0000003807097220ULL, 0x000fe20000410000ULL, 0x0000003e3b3b723eULL, 0x000fe200000000ffULL,
0x0000001c071c7220ULL, 0x000fc40000410000ULL, 0x0000003407077220ULL, 0x000fe20000410000ULL,
0x000000260909723eULL, 0x000fe200000000ffULL, 0x0000000855347824ULL, 0x000fe400078e00ffULL,
0x0000005106517220ULL, 0x042fe20000410000ULL, 0x0000001c0707723eULL, 0x000fe200000000ffULL,
0x0000005006507220ULL, 0x000fe20000410000ULL, 0xfffffff834347812ULL, 0x000fe200078ee233ULL,
0x0000002f062f7220ULL, 0x040fe40000410000ULL, 0x0000004d060c7220ULL, 0x000fe20000410000ULL,
0x000000515050723eULL, 0x000fe200000000ffULL, 0x0000004c064c7220ULL, 0x000fc40000410000ULL,
0x0000003706377220ULL, 0x000fe20000410000ULL, 0x0000002f0c0c723eULL, 0x000fe200000000ffULL,
0x0000004806487220ULL, 0x040fe40000410000ULL, 0x0000004506457220ULL, 0x040fe20000410000ULL,
0x0000004c3737723eULL, 0x000fe200000000ffULL, 0x0000004406447220ULL, 0x040fe40000410000ULL,
0x0000004106417220ULL, 0x040fe20000410000ULL, 0x000000484545723eULL, 0x000fe200000000ffULL,
0x0000002006207220ULL, 0x000fc40000410000ULL, 0x0000003d063d7220ULL, 0x040fe20000410000ULL,
0x000000444141723eULL, 0x000fe200000000ffULL, 0x0000003c063c7220ULL, 0x040fe40000410000ULL,
0x0000003906397220ULL, 0x040fe20000410000ULL, 0x000000203d20723eULL, 0x000fe200000000ffULL,
0x0000004b064b7220ULL, 0x000fe40000410000ULL, 0x0000004e0b4e7220ULL, 0x008fe20000410000ULL,
0x0000003c3939723eULL, 0x000fe200000000ffULL, 0x000000320b0d7220ULL, 0x000fe20000410000ULL,
0x0000000255327810ULL, 0x000fe20007ffe0ffULL, 0x000000180b187220ULL, 0x000fc40000410000ULL,
0x0000002e0b0f7220ULL, 0x000fe20000410000ULL, 0x0000004e0d0d723eULL, 0x000fe200000000ffULL,
0x0000002b0b2b7220ULL, 0x040fe40000410000ULL, 0x000000420b427220ULL, 0x000fe20000410000ULL,
0x000000180f0f723eULL, 0x000fe200000000ffULL, 0x0000003f0b3f7220ULL, 0x040fe40000410000ULL,
0x0000002a0b2a7220ULL, 0x040fe20000410000ULL, 0x0000002b422b723eULL, 0x000fe200000000ffULL,
0x000000230b237220ULL, 0x000fc40000410000ULL, 0x0000001f0b007220ULL, 0x010fe20000410000ULL,
0x00000001551f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001e0b1e7220ULL, 0x040fe20000410000ULL,
0x0000003f2a2a723eULL, 0x000fe200000000ffULL, 0x0000001d0b1d7220ULL, 0x040fe20000410000ULL,
0x000000230000723eULL, 0x000fe200000000ffULL, 0x000000140b147220ULL, 0x040fe40000410000ULL,
0x0000001a0b137220ULL, 0x000fe20000410000ULL, 0x0000001e1d1d723eULL, 0x000fe200000000ffULL,
0x000000170b177220ULL, 0x000fc40000410000ULL, 0x000000160b167220ULL, 0x000fe20000410000ULL,
0x000000141313723eULL, 0x000fe200000000ffULL, 0x0000003606067220ULL, 0x000fe40000410000ULL,
0x0000003110317220ULL, 0x000fe20000410000ULL, 0x000000171616723eULL, 0x000fe200000000ffULL,
0x0000004710127220ULL, 0x000fe20000410000ULL, 0x0000004b0606723eULL, 0x000fe200000000ffULL,
0x0000002d102d7220ULL, 0x040fe40000410000ULL, 0x0000002c102c7220ULL, 0x000fe20000410000ULL,
0x000000311212723eULL, 0x000fe200000000ffULL, 0x0000002910297220ULL, 0x000fc40000410000ULL,
0x0000002810287220ULL, 0x000fe20000410000ULL, 0x0000002d2c2c723eULL, 0x000fe200000000ffULL,
0x0000002210227220ULL, 0x040fe40000410000ULL, 0x00000024100b7220ULL, 0x040fe20000410000ULL,
0x0000000655247810ULL, 0x000fe20007ffe0ffULL, 0x0000004310437220ULL, 0x000fe20000410000ULL,
0x000000292828723eULL, 0x000fe200000000ffULL, 0x0000003a103a7220ULL, 0x040fe20000410000ULL,
0x000000220b0b723eULL, 0x000fe200000000ffULL, 0x0000004910497220ULL, 0x000fc40000410000ULL,
0x00000053101a7220ULL, 0x000fe20000410000ULL, 0x000000433a3a723eULL, 0x000fe200000000ffULL,
0x0000001910197220ULL, 0x040fe40000410000ULL, 0x0000005210527220ULL, 0x000fe20000410000ULL,
0x000000491a1a723eULL, 0x000fe200000000ffULL, 0x0000001510157220ULL, 0x040fe40000410000ULL,
0x0000001110107220ULL, 0x000fe20000410000ULL, 0x0000000455117810ULL, 0x040fe20007ffe0ffULL,
0x0000000855367824ULL, 0x040fe200078e00ffULL, 0x000000195219723eULL, 0x000fe200000000ffULL,
0x0000000855337824ULL, 0x040fe200078e00ffULL, 0x000000151010723eULL, 0x000fe200000000ffULL,
0x00000008552e7824ULL, 0x040fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee211ULL,
0x00000008554d7824ULL, 0x040fe200078e00ffULL, 0xffffffff55117810ULL, 0x040fe20007ffe0ffULL,
0x0000000855387824ULL, 0x000fe200078e00ffULL, 0xfffffff833547812ULL, 0x000fe200078ee224ULL,
0x0000001034347824ULL, 0x000fe200078e0205ULL, 0xfffffff856247812ULL, 0x000fe200078ee255ULL,
0x0000001036367824ULL, 0x000fe200078e0205ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee21fULL,
0x0000001054547824ULL, 0x000fe200078e0205ULL, 0xfffffff856567812ULL, 0x000fe200078ee211ULL,
0x0000000403117824ULL, 0x000fe200078e00ffULL, 0x00000005551f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001024247824ULL, 0x100fe200078e0205ULL, 0xfffffff84d327812ULL, 0x000fe200078ee232ULL,
0x000000102e2e7824ULL, 0x000fe200078e0205ULL, 0xfffffff838387812ULL, 0x000fe200078ee21fULL,
0x0000001056567824ULL, 0x100fe200078e0205ULL, 0x0000000c11117812ULL, 0x000fe200078ec0ffULL,
0x0000001032327824ULL, 0x000fc400078e0205ULL, 0x0000001038387824ULL, 0x000fe400078e0205ULL,
0x0000000124057824ULL, 0x000fe400078e0211ULL, 0x00000001112e7824ULL, 0x040fe400078e022eULL,
0x0000000111327824ULL, 0x040fe200078e0232ULL, 0x0000005005007388ULL, 0x0003e20000000800ULL,
0x0000000111347824ULL, 0x040fe400078e0234ULL, 0x0000000111367824ULL, 0x040fe200078e0236ULL,
0x0000000c2e007388ULL, 0x000fe20000000800ULL, 0x0000000111387824ULL, 0x000fc400078e0238ULL,
0x0000000111547824ULL, 0x040fe200078e0254ULL, 0x0000003732007388ULL, 0x000fe20000000800ULL,
0x0000000111237824ULL, 0x040fe400078e0256ULL, 0x0000000111157824ULL, 0x040fe200078e0258ULL,
0x0000004534007388ULL, 0x000fe20000000800ULL, 0x00000001115a7824ULL, 0x040fe400078e025aULL,
0x0000000111117824ULL, 0x000fe200078e025cULL, 0x0000004136007388ULL, 0x000fe20000000800ULL,
0x0000000108057824ULL, 0x002fc600078e0203ULL, 0x0000002038007388ULL, 0x000fe20000000800ULL,
0x0000001005057824ULL, 0x000fc600078e0204ULL, 0x0000003954007388ULL, 0x000fe80000000800ULL,
0x0000000623007388ULL, 0x000fe80000000800ULL, 0x0000000e15007388ULL, 0x000fe80000000800ULL,
0x000400352e007388ULL, 0x000fe80000000800ULL, 0x0004001b32007388ULL, 0x000fe80000000800ULL,
0x0004002734007388ULL, 0x000fe80000000800ULL, 0x0004002536007388ULL, 0x000fe80000000800ULL,
0x0004003b38007388ULL, 0x000fe80000000800ULL, 0x0004000954007388ULL, 0x000fe80000000800ULL,
0x0004000723007388ULL, 0x000fe80000000800ULL, 0x0000000d5a007388ULL, 0x000fe80000000800ULL,
0x0008000f2e007388ULL, 0x000fe80000000800ULL, 0x0008002b32007388ULL, 0x000fe80000000800ULL,
0x0008002a34007388ULL, 0x000fe80000000800ULL, 0x0008000036007388ULL, 0x000fe80000000800ULL,
0x0008001d38007388ULL, 0x000fe80000000800ULL, 0x0008001354007388ULL, 0x000fe80000000800ULL,
0x0008001623007388ULL, 0x000fe80000000800ULL, 0x0000001211007388ULL, 0x000fe80000000800ULL,
0x000c002c2e007388ULL, 0x000fe80000000800ULL, 0x000c002832007388ULL, 0x000fe80000000800ULL,
0x000c000b34007388ULL, 0x000fe80000000800ULL, 0x000c003a36007388ULL, 0x000fe80000000800ULL,
0x000c001a38007388ULL, 0x000fe80000000800ULL, 0x000c001954007388ULL, 0x000fe80000000800ULL,
0x000c001023007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000050c7984ULL, 0x000e680000000c00ULL, 0x00040000051c7984ULL, 0x000ea80000000c00ULL,
0x0008000005287984ULL, 0x000ee80000000c00ULL, 0x000c000005307984ULL, 0x000f280000000c00ULL,
0x0010000005147984ULL, 0x000ee80000000c00ULL, 0x0014000005247984ULL, 0x000f280000000c00ULL,
0x00180000052c7984ULL, 0x000f280000000c00ULL, 0x001c000005347984ULL, 0x000f220000000c00ULL,
0x200000ff0f0f7230ULL, 0x002fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x004fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fc40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff2b2b7230ULL, 0x008fe40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fe40000000000ULL,
0x200000ff29297230ULL, 0x000fe40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x200000ff33337230ULL, 0x010fc40000000000ULL, 0x200000ff32327230ULL, 0x000fe40000000000ULL,
0x200000ff31317230ULL, 0x000fe40000000000ULL, 0x200000ff30307230ULL, 0x000fe40000000000ULL,
0x000000170f0f7230ULL, 0x000fe40000000000ULL, 0x000000160e0e7230ULL, 0x000fe40000000000ULL,
0x000000150d0d7230ULL, 0x000fc40000000000ULL, 0x000000140c0c7230ULL, 0x000fe40000000000ULL,
0x000000271f1f7230ULL, 0x000fe40000000000ULL, 0x000000261e1e7230ULL, 0x000fe20000000000ULL,
0x0000000c05007388ULL, 0x000fe20000000c00ULL, 0x000000251d1d7230ULL, 0x000fe40000000000ULL,
0x000000241c1c7230ULL, 0x000fe40000000000ULL, 0x0000002f2b2b7230ULL, 0x000fc40000000000ULL,
0x0000002e2a2a7230ULL, 0x000fe20000000000ULL, 0x0004001c05007388ULL, 0x000fe20000000c00ULL,
0x0000002d29297230ULL, 0x000fe40000000000ULL, 0x0000002c28287230ULL, 0x000fe40000000000ULL,
0x0000003733337230ULL, 0x000fe40000000000ULL, 0x0000003632327230ULL, 0x000fe20000000000ULL,
0x0008002805007388ULL, 0x000fe20000000c00ULL, 0x0000003531317230ULL, 0x000fc40000000000ULL,
0x0000003430307230ULL, 0x000fca0000000000ULL, 0x000c003005007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff2100720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fc80000011603ULL,
0x000000020000720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ee20000002700ULL, 0x0000000100057824ULL, 0x100fe200078e0203ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x0000002081007824ULL, 0x000fe200078e0200ULL,
0x00005a0000067ab9ULL, 0x000fe20000000800ULL, 0x0000002003097810ULL, 0x000fe20007ffe0ffULL,
0x0000000605057299ULL, 0x000fe2000800063fULL, 0x0000000705067812ULL, 0x000fe400078ec0ffULL,
0x0000580000067ab9ULL, 0x000fe40000000800ULL, 0x0ffffff806057812ULL, 0x000fc400078ef803ULL,
0x0000000500077c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff067a19ULL, 0x000fe20000011600ULL,
0x0000001005057824ULL, 0x000fe400078e0204ULL, 0x0000000180077824ULL, 0x000fc600078e0207ULL,
0x00000000050c7984ULL, 0x0045220000000c00ULL, 0x0000008306077224ULL, 0x000fe200078e0207ULL,
0x00000006040472a4ULL, 0x008fe2000f8e023fULL, 0x0000000703057812ULL, 0x004fca00078ec0ffULL,
0x0000000483007c24ULL, 0x000fe4000f8e02ffULL, 0x000000080a057824ULL, 0x000fc600078e0205ULL,
0x0000000700077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005c0007067a11ULL, 0x000fc800078040ffULL, 0x00005d0007077a11ULL, 0x000fe400000f4408ULL,
0x00000003ff087819ULL, 0x000fc60000011609ULL, 0x0000001005067825ULL, 0x000fe200078e0006ULL,
0x000000020800720cULL, 0x000fc80003f06070ULL, 0x0000000c06007986ULL, 0x0105f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000109057824ULL, 0x100fe200078e0208ULL,
0x00000040030b7810ULL, 0x000fe20007ffe0ffULL, 0x0000002081087824ULL, 0x000fc600078e0208ULL,
0x0000000705057812ULL, 0x000fe400078ec0ffULL, 0x0000000508077c12ULL, 0x004fe4000f8e30ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef809ULL, 0x00005a00ff087a19ULL, 0x000fe20000011608ULL,
0x0000000180077824ULL, 0x000fe200078e0207ULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x0000001005057824ULL, 0x000fe400078e0204ULL, 0x0000008308077224ULL, 0x000fc400078e0207ULL,
0x000000080a097824ULL, 0x000fe200078e0209ULL, 0x00000000050c7984ULL, 0x0004e40000000c00ULL,
0x0000000700077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005c0007067a11ULL, 0x040fe400078040ffULL, 0x00000003ff057819ULL, 0x004fe4000001160bULL,
0x00005d0007077a11ULL, 0x000fe400000f4408ULL, 0x000000020500720cULL, 0x000fc60003f06070ULL,
0x0000001009067825ULL, 0x000fca00078e0006ULL, 0x0000000c06007986ULL, 0x0085ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010b067824ULL, 0x104fe200078e0205ULL,
0x0000006003097810ULL, 0x000fe20007ffe0ffULL, 0x0000002081057824ULL, 0x000fc600078e0205ULL,
0x0000000706067812ULL, 0x000fc800078ec0ffULL, 0x0ffffff806077812ULL, 0x000fe400078ef80bULL,
0x00005a00ff067a19ULL, 0x000fc60000011605ULL, 0x0000001007087824ULL, 0x000fe200078e0204ULL,
0x0000000505077c12ULL, 0x000fe4000f8e30ffULL, 0x000000070b057812ULL, 0x000fe400078ec0ffULL,
0x00000000080c7984ULL, 0x0004e20000000c00ULL, 0x0000000180077824ULL, 0x000fe400078e0207ULL,
0x000000080a057824ULL, 0x000fe400078e0205ULL, 0x0000008306077224ULL, 0x000fe200078e0207ULL,
0x00000003ff087819ULL, 0x004fc80000011609ULL, 0x0000000700077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x00005c0007067a11ULL, 0x000fc800078040ffULL,
0x00005d0007077a11ULL, 0x000fe400000f4410ULL, 0x000000020800720cULL, 0x000fc60003f06070ULL,
0x0000001005067825ULL, 0x000fca00078e0006ULL, 0x0000000c06007986ULL, 0x0085ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000109057824ULL, 0x100fe200078e0208ULL,
0x00000080030b7810ULL, 0x000fe20007ffe0ffULL, 0x0000002081087824ULL, 0x000fc600078e0208ULL,
0x0000000705057812ULL, 0x000fe400078ec0ffULL, 0x0000000508077c12ULL, 0x004fe4000f8e30ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef809ULL, 0x00005a00ff087a19ULL, 0x000fe20000011608ULL,
0x0000000180077824ULL, 0x000fe200078e0207ULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x0000001005057824ULL, 0x000fe400078e0204ULL, 0x0000008308077224ULL, 0x000fc400078e0207ULL,
0x000000080a097824ULL, 0x000fe200078e0209ULL, 0x00000000050c7984ULL, 0x0004e40000000c00ULL,
0x0000000700077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005c0007067a11ULL, 0x040fe400078040ffULL, 0x00000003ff057819ULL, 0x004fe4000001160bULL,
0x00005d0007077a11ULL, 0x000fe400000f4408ULL, 0x000000020500720cULL, 0x000fc60003f06070ULL,
0x0000001009067825ULL, 0x000fca00078e0006ULL, 0x0000000c06007986ULL, 0x0085ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010b067824ULL, 0x104fe200078e0205ULL,
0x000000a003097810ULL, 0x000fe20007ffe0ffULL, 0x0000002081057824ULL, 0x000fc600078e0205ULL,
0x0000000706067812ULL, 0x000fc800078ec0ffULL, 0x0ffffff806077812ULL, 0x000fe400078ef80bULL,
0x00005a00ff067a19ULL, 0x000fc60000011605ULL, 0x0000001007087824ULL, 0x000fe200078e0204ULL,
0x0000000505077c12ULL, 0x000fe4000f8e30ffULL, 0x000000070b057812ULL, 0x000fe400078ec0ffULL,
0x00000000080c7984ULL, 0x0004e20000000c00ULL, 0x0000000180077824ULL, 0x000fe400078e0207ULL,
0x000000080a057824ULL, 0x000fe400078e0205ULL, 0x0000008306077224ULL, 0x000fe200078e0207ULL,
0x00000003ff087819ULL, 0x004fc80000011609ULL, 0x0000000700077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x00005c0007067a11ULL, 0x000fc800078040ffULL,
0x00005d0007077a11ULL, 0x000fe400000f4410ULL, 0x000000020800720cULL, 0x000fc60003f06070ULL,
0x0000001005067825ULL, 0x000fca00078e0006ULL, 0x0000000c06007986ULL, 0x0085ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000109057824ULL, 0x100fe200078e0208ULL,
0x000000c0030b7810ULL, 0x000fe20007ffe0ffULL, 0x0000002081087824ULL, 0x000fc600078e0208ULL,
0x0000000705057812ULL, 0x000fe400078ec0ffULL, 0x0000000508077c12ULL, 0x004fe4000f8e30ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef809ULL, 0x00005a00ff087a19ULL, 0x000fe20000011608ULL,
0x0000000180077824ULL, 0x000fe200078e0207ULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x0000001005057824ULL, 0x000fe400078e0204ULL, 0x0000008308077224ULL, 0x000fc400078e0207ULL,
0x000000080a097824ULL, 0x000fe200078e0209ULL, 0x00000000050c7984ULL, 0x0004e40000000c00ULL,
0x0000000700077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005c0007067a11ULL, 0x040fe400078040ffULL, 0x00000003ff057819ULL, 0x004fe4000001160bULL,
0x00005d0007077a11ULL, 0x000fe400000f4408ULL, 0x000000020500720cULL, 0x000fc60003f06070ULL,
0x0000001009067825ULL, 0x000fca00078e0006ULL, 0x0000000c06007986ULL, 0x0085ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010b067824ULL, 0x104fe200078e0205ULL,
0x000000e003097810ULL, 0x000fe20007ffe0ffULL, 0x0000002081057824ULL, 0x000fe200078e0205ULL,
0x000000070b037812ULL, 0x000fe400078ec0ffULL, 0x0000000706067812ULL, 0x000fc600078ec0ffULL,
0x000000080a037824ULL, 0x000fe200078e0203ULL, 0x0ffffff806077812ULL, 0x000fe400078ef80bULL,
0x00005a00ff067a19ULL, 0x000fc60000011605ULL, 0x0000001007087824ULL, 0x000fe200078e0204ULL,
0x0000000505077c12ULL, 0x000fe4000f8e30ffULL, 0x00000003ff057819ULL, 0x000fe40000011609ULL,
0x00000000080c7984ULL, 0x0004e20000000c00ULL, 0x0000000180077824ULL, 0x000fc800078e0207ULL,
0x0000008306077224ULL, 0x000fe400078e0207ULL, 0x0000000109087824ULL, 0x004fc600078e0205ULL,
0x0000000700077210ULL, 0x000fe40007f1e0ffULL, 0x0000000708087812ULL, 0x000fc600078ec0ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x00005c0007067a11ULL, 0x000fc800078040ffULL,
0x00005d0007077a11ULL, 0x000fe400000f4410ULL, 0x000000020500720cULL, 0x000fc60003f06070ULL,
0x0000001003027825ULL, 0x000fe200078e0006ULL, 0xfffffff808077812ULL, 0x000fc800078ef809ULL,
0x0000000c02007986ULL, 0x0085ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001007077824ULL, 0x000fe400078e0204ULL, 0x0000002081057824ULL, 0x000fc600078e0205ULL,
0x00000000070c7984ULL, 0x004ea40000000c00ULL, 0x0000000505037c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011605ULL, 0x0000000709057812ULL, 0x000fe200078ec0ffULL,
0x0000000180037824ULL, 0x000fc800078e0203ULL, 0x0000008302037224ULL, 0x000fe400078e0203ULL,
0x000000080a057824ULL, 0x000fc600078e0205ULL, 0x0000000300037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fca00000f4400ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000c02007986ULL, 0x004fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000001030d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000213137824ULL, 0x000fe200078e00ffULL, 0x01e60000ff087f8cULL, 0x000e62000c80043fULL,
0x00000040007c7824ULL, 0x000fe200078e00ffULL, 0x000000060d00720cULL, 0x000fe20003f06070ULL,
0x0000590013027a24ULL, 0x000fe400078e020aULL, 0x00000100030d7824ULL, 0x000fc800078e027cULL,
0x0000660002327a24ULL, 0x000fcc00078e020dULL, 0x00000c7000008947ULL, 0x000fea0003800000ULL,
0x00000003ff337819ULL, 0x100fe40000011604ULL, 0x0000000d050a7217ULL, 0x000fe40007800000ULL,
0x00000004330f7810ULL, 0x040fe40007ffe0ffULL, 0x00000033320c7210ULL, 0x000fe20007ffe0ffULL,
0x000000010a0a7824ULL, 0x000fe200078e0a0dULL, 0x0000001033157810ULL, 0x000fe20007ffe0ffULL,
0x000000010f0d7824ULL, 0x000fe200078e0204ULL, 0x0000000833117810ULL, 0x000fe20007ffe0ffULL,
0x000000080f127824ULL, 0x040fe200078e00ffULL, 0x0000000a0f00720cULL, 0x000fe20003fa6070ULL,
0x00000001320e7824ULL, 0x000fe200078e020fULL, 0x0000000c33137810ULL, 0x000fe20007ffe0ffULL,
0x0000000815317824ULL, 0x000fe200078e00ffULL, 0xfffffff812217812ULL, 0x000fe200078ee20dULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x00000018332d7810ULL, 0x000fc40007ffe0ffULL,
0x00000014331f7810ULL, 0x040fe20007ffe0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c167812ULL, 0x100fe400078ef80bULL, 0x0000001c33397810ULL, 0x000fe20007ffe0ffULL,
0x00000001150c7824ULL, 0x100fe200078e0204ULL, 0x0000620016167a10ULL, 0x000fe20007f1e0ffULL,
0x0000000111107824ULL, 0x040fe200078e0204ULL, 0x000000700e187812ULL, 0x000fe200078ef80bULL,
0x0000000811257824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee20cULL,
0x00000001320c7824ULL, 0x000fe200078e0211ULL, 0x000063000d177a10ULL, 0x000fe200007fe4ffULL,
0x00000008132f7824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee210ULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000620018187a10ULL, 0x000fc40007f3e0ffULL,
0x0000000a1500720cULL, 0x080fe20003f06070ULL, 0x0000000113107824ULL, 0x000fe200078e0204ULL,
0x000000700c1a7812ULL, 0x000fe200078ef80bULL, 0x00000001320e7824ULL, 0x040fe200078e0213ULL,
0x000063000f197a10ULL, 0x000fe20000ffe4ffULL, 0x0000000132147824ULL, 0x000fe200078e022dULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee210ULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000062001a1a7a10ULL, 0x000fe40007f7e0ffULL, 0x0000000a1100720cULL, 0x080fe20003f26070ULL,
0x0000000132107824ULL, 0x040fe200078e0215ULL, 0x0000000a1300720cULL, 0x000fe20003f46070ULL,
0x0000000132127824ULL, 0x000fe200078e021fULL, 0x000000700e1c7812ULL, 0x000fe200078ef80bULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x000063000d1b7a10ULL, 0x000fc40001ffe4ffULL,
0x000062001c1c7a10ULL, 0x000fe20007f9e0ffULL, 0x00000001320c7824ULL, 0x000fe200078e0239ULL,
0x0000007014147812ULL, 0x100fe200078ef80bULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x0000002033277810ULL, 0x000fe40007ffe0ffULL, 0x0000620014147a10ULL, 0x000fe20007fde0ffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000007010107812ULL, 0x100fe400078ef80bULL,
0x000063000f1d7a10ULL, 0x000fe200027fe4ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000007012127812ULL, 0x000fc400078ef80bULL, 0x0000620010107a10ULL, 0x000fe20007f7e0ffULL,
0x00000001330e7824ULL, 0x100fe200078e0204ULL, 0x000000700c1e7812ULL, 0x000fe200078ef80bULL,
0x00000001320c7824ULL, 0x000fe200078e0227ULL, 0x0000620012127a10ULL, 0x000fe20007f9e0ffULL,
0x000000081f357824ULL, 0x000fe200078e00ffULL, 0x0000630015157a10ULL, 0x000fe200037fe4ffULL,
0x000000012d247824ULL, 0x040fe200078e0204ULL, 0x000062001e1e7a10ULL, 0x000fe20007fde0ffULL,
0x000000082d377824ULL, 0x000fe200078e00ffULL, 0x0000630011117a10ULL, 0x000fc40001ffe4ffULL,
0x0000630013137a10ULL, 0x000fe400027fe4ffULL, 0x000000070e0f7812ULL, 0x000fe200078ec0ffULL,
0x000000011f0e7824ULL, 0x000fe200078e0204ULL, 0x0000000a3300720cULL, 0x080fe40003f86070ULL,
0x0000000a1f00720cULL, 0x000fe40003f66070ULL, 0x000063000d1f7a10ULL, 0x000fe200037fe4ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000200000227811ULL, 0x000fc400078e70ffULL,
0x0ffffff80f0f7812ULL, 0x000fe400078ef804ULL, 0x0000002433297810ULL, 0x000fe20007ffe0ffULL,
0x0000001025257824ULL, 0x100fe200078e0222ULL, 0x00000028332b7810ULL, 0x000fe20007ffe0ffULL,
0x000000100f237824ULL, 0x000fe200078e0222ULL, 0x000000700c207812ULL, 0x000fe400078ef80bULL,
0xfffffff835357812ULL, 0x000fe200078ee20eULL, 0x00000001320e7824ULL, 0x000fe200078e0229ULL,
0x0000620020207a10ULL, 0x000fe20007fde0ffULL, 0x00000001320c7824ULL, 0x000fe200078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016237faeULL, 0x0005e2000e101c48ULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000a2d00720cULL, 0x000fc40003f86070ULL,
0x0000002c332d7810ULL, 0x000fe40007ffe0ffULL, 0x000000700e0e7812ULL, 0x000fe400078ef80bULL,
0xfffffff837377812ULL, 0x000fe200078ee224ULL, 0x0000000827247824ULL, 0x000fe400078e00ffULL,
0x0000001021237824ULL, 0x004fe200078e0222ULL, 0x000063000d217a10ULL, 0x000fe200037fe4ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x000062000e0e7a10ULL, 0x000fc40007fde0ffULL,
0x0000000018237faeULL, 0x0005e2000e901c48ULL, 0x0000000139177824ULL, 0x040fe200078e0204ULL,
0x000000700c167812ULL, 0x000fe200078ef80bULL, 0x00000008390c7824ULL, 0x040fe200078e00ffULL,
0x0000000a3900720cULL, 0x080fe20003fa6070ULL, 0x000000001a257faeULL, 0x0007e2000c901c48ULL,
0x000063000f0f7a10ULL, 0x000fe400037fe4ffULL, 0x0000620016167a10ULL, 0x000fe40007fde0ffULL,
0xfffffff80c397812ULL, 0x000fe200078ee217ULL, 0x00000001320c7824ULL, 0x000fe200078e022dULL,
0x000063000d177a10ULL, 0x000fe200037fe4ffULL, 0x000000102f237824ULL, 0x004fe200078e0222ULL,
0x0000000a2700720cULL, 0x000fe20003f26070ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x00000034332f7810ULL, 0x000fc40007ffe0ffULL, 0x000000001c237faeULL, 0x0005e2000d101c48ULL,
0x0000000127197824ULL, 0x100fe200078e0204ULL, 0x000000700c187812ULL, 0x000fe200078ef80bULL,
0x00000001290c7824ULL, 0x040fe200078e0204ULL, 0x0000000a2900720cULL, 0x040fe20003f46070ULL,
0x0000000829277824ULL, 0x000fe200078e00ffULL, 0x0000620018187a10ULL, 0x000fe20007fde0ffULL,
0x00000010311b7824ULL, 0x008fe200078e0222ULL, 0x0000003033297810ULL, 0x000fe40007ffe0ffULL,
0xfffffff824257812ULL, 0x000fc400078ee219ULL, 0x000063000d197a10ULL, 0x000fe200037fe4ffULL,
0x00000010350d7824ULL, 0x000fe200078e0222ULL, 0xfffffff827277812ULL, 0x000fe200078ee20cULL,
0x00000001320c7824ULL, 0x000fe200078e0229ULL, 0x00000000101b7faeULL, 0x0007e2000c101c48ULL,
0x00000010371d7824ULL, 0x104fe200078e0222ULL, 0x0000003833317810ULL, 0x000fe20007ffe0ffULL,
0x0000001039237824ULL, 0x100fe200078e0222ULL, 0x00000000120d7faeULL, 0x0005e2000d901c48ULL,
0x0000001025257824ULL, 0x100fe200078e0222ULL, 0x0000003c33337810ULL, 0x000fe20007ffe0ffULL,
0x0000001027277824ULL, 0x000fe200078e0222ULL, 0x00000000141d7faeULL, 0x0009e2000e101c48ULL,
0x0000000a2d00720cULL, 0x000fc40003f86070ULL, 0x0000000a2900720cULL, 0x080fe20003f66070ULL,
0x000000001e237faeULL, 0x0003e2000e901c48ULL, 0x000000012b117824ULL, 0x148fe200078e0204ULL,
0x0000000a2b00720cULL, 0x080fe20003fa6070ULL, 0x000000082d1b7824ULL, 0x000fe200078e00ffULL,
0x0000000020257faeULL, 0x0007e2000c901c48ULL, 0x000001000c0c7825ULL, 0x004fe200078e00ffULL,
0x0000000a3100720cULL, 0x080fe40003f26070ULL, 0x000000000e277faeULL, 0x0005e2000d101c48ULL,
0x0000000132127824ULL, 0x000fe200078e022fULL, 0x000000700c107812ULL, 0x000fe200078ef80bULL,
0x000000082b147824ULL, 0x010fe200078e00ffULL, 0x0000000a2f00720cULL, 0x080fe20003f46070ULL,
0x00000001290c7824ULL, 0x040fe200078e0204ULL, 0x0000620010107a10ULL, 0x000fe20007fde0ffULL,
0x00000008291d7824ULL, 0x000fe200078e00ffULL, 0xfffffff814157812ULL, 0x000fe200078ee211ULL,
0x000000082f1f7824ULL, 0x002fe200078e00ffULL, 0x000063000d117a10ULL, 0x000fe200037fe4ffULL,
0x00000001320d7824ULL, 0x000fe200078e0231ULL, 0x0000000a3300720cULL, 0x000fe20003f06070ULL,
0x00000100120e7825ULL, 0x004fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fc600078ee20cULL,
0x000000012d0a7824ULL, 0x000fe200078e0204ULL, 0x000000700e127812ULL, 0x000fe200078ef80bULL,
0x000001000d0c7825ULL, 0x000fc600078e00ffULL, 0x0000620012127a10ULL, 0x000fe20007fde0ffULL,
0x00000001320e7824ULL, 0x000fe200078e0233ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee20aULL,
0x000000012f0a7824ULL, 0x000fe200078e0204ULL, 0x000063000f137a10ULL, 0x000fe200037fe4ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x100fe400078ef80bULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee20aULL, 0x0000000131147824ULL, 0x140fe200078e0204ULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x0000000831217824ULL, 0x008fe200078e00ffULL,
0x000000700e0b7812ULL, 0x000fe200078ef80bULL, 0x0000000133047824ULL, 0x000fe200078e0204ULL,
0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL, 0x0000000833237824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee214ULL, 0x0000001015157824ULL, 0x100fe200078e0222ULL,
0x000062000b0a7a10ULL, 0x000fe20007fde0ffULL, 0x000000101b1b7824ULL, 0x000fe200078e0222ULL,
0xfffffff823237812ULL, 0x000fe200078ee204ULL, 0x000000101d1d7824ULL, 0x100fe200078e0222ULL,
0x000063000f0b7a10ULL, 0x000fe200037fe4ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0222ULL,
0x0000000016157faeULL, 0x0003e2000e901c48ULL, 0x0000001021217824ULL, 0x000fc400078e0222ULL,
0x0000001023237824ULL, 0x000fe200078e0222ULL, 0x00000000181b7faeULL, 0x0003e8000e101c48ULL,
0x00000000101d7faeULL, 0x0003e8000d901c48ULL, 0x00000000121f7faeULL, 0x0003e8000d101c48ULL,
0x000000000c217faeULL, 0x0003e8000c901c48ULL, 0x000000000a237faeULL, 0x0003e2000c101c48ULL,
0x00000b3000007947ULL, 0x000fea0003800000ULL, 0x0000000c04257811ULL, 0x040fe400078fe8ffULL,
0x0000000404137811ULL, 0x000fc400078fe8ffULL, 0x00000004250d7210ULL, 0x0c0fe20007ffe0ffULL,
0x00000008250e7824ULL, 0x000fe200078e00ffULL, 0x00000018042d7811ULL, 0x040fe200078fe8ffULL,
0x00000001130a7824ULL, 0x140fe200078e0204ULL, 0x0000000804217811ULL, 0x000fe200078fe8ffULL,
0x00000008132f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e337812ULL, 0x000fe200078ee20dULL,
0x000000012d0d7824ULL, 0x140fe200078e0204ULL, 0x0000001004277811ULL, 0x040fe200078fe8ffULL,
0x000000082d107824ULL, 0x000fe200078e00ffULL, 0x0000001c043b7811ULL, 0x040fe200078fe8ffULL,
0x00000001210c7824ULL, 0x000fe200078e0204ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee20aULL,
0x0000000821317824ULL, 0x000fe200078e00ffULL, 0x00000014042b7811ULL, 0x000fe200078fe8ffULL,
0x00000001270a7824ULL, 0x140fe200078e0204ULL, 0xfffffff810397812ULL, 0x000fe200078ee20dULL,
0x0000000827357824ULL, 0x000fe200078e00ffULL, 0x00000020040d7811ULL, 0x040fe200078fe8ffULL,
0x000000013b0e7824ULL, 0x000fe200078e0204ULL, 0xfffffff831317812ULL, 0x000fe200078ee20cULL,
0x000000083b3d7824ULL, 0x000fe200078e00ffULL, 0x0000002804117811ULL, 0x040fe200078fe8ffULL,
0x000000012b0c7824ULL, 0x000fe200078e0204ULL, 0xfffffff835357812ULL, 0x000fe200078ee20aULL,
0x000000082b377824ULL, 0x000fe200078e00ffULL, 0x00000024040f7811ULL, 0x040fe200078fe8ffULL,
0x000000010d0a7824ULL, 0x000fe200078e0204ULL, 0xfffffff83d3d7812ULL, 0x000fe200078ee20eULL,
0x000000080d157824ULL, 0x000fe200078e00ffULL, 0xfffffff837377812ULL, 0x000fe200078ee20cULL,
0x00000001110e7824ULL, 0x040fe200078e0204ULL, 0x0000002c04197811ULL, 0x040fe200078fe8ffULL,
0x00000008111b7824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee20aULL,
0x000000010f0c7824ULL, 0x040fe200078e0204ULL, 0x00000004040a7211ULL, 0x040fe200078fe8ffULL,
0x000000080f177824ULL, 0x000fe200078e00ffULL, 0xfffffff81b187812ULL, 0x000fe200078ee20eULL,
0x0000000119107824ULL, 0x040fe200078e0204ULL, 0x00000030041b7811ULL, 0x000fe200078fe8ffULL,
0x00000008191d7824ULL, 0x000fe200078e00ffULL, 0xfffffff817177812ULL, 0x000fe200078ee20cULL,
0x0000000132247824ULL, 0x000fe200078e020dULL, 0x00000038041f7811ULL, 0x000fe200078fe8ffULL,
0x00000001322c7824ULL, 0x000fe200078e021bULL, 0x00000032040c7211ULL, 0x000fe200078fe8ffULL,
0x000000081b1e7824ULL, 0x000fe200078e00ffULL, 0x000000070a297812ULL, 0x000fe200078ec0ffULL,
0x00000001250a7824ULL, 0x000fe200078e0232ULL, 0xfffffff81d1a7812ULL, 0x000fe200078ee210ULL,
0x0000000132257824ULL, 0x000fe200078e020fULL, 0x00000034041d7811ULL, 0x040fe200078fe8ffULL,
0x000000011b0f7824ULL, 0x100fe200078e0204ULL, 0x0000003c04237811ULL, 0x000fe200078fe8ffULL,
0x000000011f167824ULL, 0x100fe200078e0204ULL, 0x0ffffff829297812ULL, 0x000fe200078ef804ULL,
0x000000081f1b7824ULL, 0x000fc400078e00ffULL, 0x000001000c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee216ULL, 0x00000001130e7824ULL, 0x100fe200078e0232ULL,
0x000000700c167812ULL, 0x000fe200078ef80bULL, 0x0000000121107824ULL, 0x100fe200078e0232ULL,
0x00002000000c7811ULL, 0x000fe200078e70ffULL, 0x0000000127127824ULL, 0x100fe200078e0232ULL,
0x0000620016167a10ULL, 0x000fe20007f1e0ffULL, 0x000000012b137824ULL, 0x100fe400078e0232ULL,
0x000000012d147824ULL, 0x100fe400078e0232ULL, 0x000000013b217824ULL, 0x000fc400078e0232ULL,
0x0000000132267824ULL, 0x040fe400078e0211ULL, 0x0000000132277824ULL, 0x040fe400078e0219ULL,
0x00000001322e7824ULL, 0x040fe400078e021dULL, 0x0000000132307824ULL, 0x040fe400078e021fULL,
0x000000011d117824ULL, 0x000fe400078e0204ULL, 0x0000000132327824ULL, 0x000fc400078e0223ULL,
0x00000001231c7824ULL, 0x000fe200078e0204ULL, 0xfffffff81e047812ULL, 0x000fe200078ee20fULL,
0x000000081d207824ULL, 0x000fe400078e00ffULL, 0x0000000823237824ULL, 0x000fe400078e00ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff820197812ULL, 0x000fe400078ee211ULL,
0xfffffff8231c7812ULL, 0x000fe200078ee21cULL, 0x0000001018417824ULL, 0x000fe200078e020cULL,
0x000000700e187812ULL, 0x000fe200078ef80bULL, 0x0000010010107825ULL, 0x000fc600078e00ffULL,
0x0000620018187a10ULL, 0x000fe20007f3e0ffULL, 0x000000103d3b7824ULL, 0x100fe400078e020cULL,
0x00000010173f7824ULL, 0x100fe200078e020cULL, 0x000063000d177a10ULL, 0x000fe200007fe4ffULL,
0x00000010292d7824ULL, 0x100fe400078e020cULL, 0x000000102f2f7824ULL, 0x100fe400078e020cULL,
0x0000001031317824ULL, 0x100fe200078e020cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000162d7faeULL, 0x0005e2000b901c48ULL, 0x0000001033337824ULL, 0x000fc400078e020cULL,
0x0000001035357824ULL, 0x100fe400078e020cULL, 0x0000001037377824ULL, 0x100fe400078e020cULL,
0x0000001039397824ULL, 0x100fe400078e020cULL, 0x00000010153d7824ULL, 0x100fe400078e020cULL,
0x000000101a437824ULL, 0x100fe200078e020cULL, 0x00000070101a7812ULL, 0x000fe200078ef80bULL,
0x0000001004457824ULL, 0x000fc400078e020cULL, 0x0000001019477824ULL, 0x100fe200078e020cULL,
0x000063000f197a10ULL, 0x000fe20000ffe4ffULL, 0x000000101b497824ULL, 0x100fe200078e020cULL,
0x000062001a1a7a10ULL, 0x000fe20007f1e0ffULL, 0x000000101c4b7824ULL, 0x000fe400078e020cULL,
0x000001000a0c7825ULL, 0x000fe200078e00ffULL, 0x00006300111b7a10ULL, 0x000fe200007fe4ffULL,
0x00000000182f7faeULL, 0x0005e4000b901c48ULL, 0x00000100120e7825ULL, 0x000fe200078e00ffULL,
0x000000700c1c7812ULL, 0x100fe200078ef80bULL, 0x000000001a317faeULL, 0x0005e4000b901c48ULL,
0x0000010013127825ULL, 0x000fe200078e00ffULL, 0x000000700e1e7812ULL, 0x000fc400078ef80bULL,
0x000062001c1c7a10ULL, 0x000fe20007f1e0ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000007012207812ULL, 0x100fe400078ef80bULL, 0x000062001e1e7a10ULL, 0x000fe20007f3e0ffULL,
0x0000010025107825ULL, 0x000fe200078e00ffULL, 0x000063000d1d7a10ULL, 0x000fe400007fe4ffULL,
0x0000620020207a10ULL, 0x000fe20007f1e0ffULL, 0x00000100210c7825ULL, 0x000fe200078e00ffULL,
0x0000007014227812ULL, 0x000fe200078ef80bULL, 0x000000001c337faeULL, 0x0005e2000b901c48ULL,
0x000063000f1f7a10ULL, 0x000fe20000ffe4ffULL, 0x00000100240e7825ULL, 0x000fe200078e00ffULL,
0x0000630013217a10ULL, 0x000fc400007fe4ffULL, 0x000000700c247812ULL, 0x100fe200078ef80bULL,
0x0000010026127825ULL, 0x000fe200078e00ffULL, 0x0000620022227a10ULL, 0x000fe20007f5e0ffULL,
0x000000001e357faeULL, 0x0005e2000b901c48ULL, 0x000000700e267812ULL, 0x100fe400078ef80bULL,
0x0000620024247a10ULL, 0x000fe20007f1e0ffULL, 0x0000000020377faeULL, 0x0005e2000b901c48ULL,
0x0000007010287812ULL, 0x100fe400078ef80bULL, 0x0000630015237a10ULL, 0x000fe200017fe4ffULL,
0x0000010027147825ULL, 0x000fe200078e00ffULL, 0x00000070122a7812ULL, 0x000fc400078ef80bULL,
0x0000620026267a10ULL, 0x000fe20007f3e0ffULL, 0x0000000022397faeULL, 0x0005e2000b901c48ULL,
0x000063000d257a10ULL, 0x000fe200007fe4ffULL, 0x000001002c0c7825ULL, 0x000fe200078e00ffULL,
0x0000620028287a10ULL, 0x000fe40007f1e0ffULL, 0x000062002a2a7a10ULL, 0x000fe20007f5e0ffULL,
0x00000000243b7faeULL, 0x0005e2000b901c48ULL, 0x000063000f277a10ULL, 0x000fe20000ffe4ffULL,
0x000001002e0e7825ULL, 0x000fe200078e00ffULL, 0x0000007014147812ULL, 0x000fc400078ef80bULL,
0x0000630011297a10ULL, 0x000fe200007fe4ffULL, 0x0000010030107825ULL, 0x000fe200078e00ffULL,
0x00006300132b7a10ULL, 0x000fe200017fe4ffULL, 0x00000000263d7faeULL, 0x0005e2000b901c48ULL,
0x0000620014147a10ULL, 0x000fe20007f1e0ffULL, 0x0000010032127825ULL, 0x000fe200078e00ffULL,
0x000000700c0a7812ULL, 0x100fe200078ef80bULL, 0x00000000283f7faeULL, 0x0005e2000b901c48ULL,
0x000000700e0c7812ULL, 0x100fe400078ef80bULL, 0x00000070100e7812ULL, 0x000fe200078ef80bULL,
0x000000002a417faeULL, 0x0005e2000b901c48ULL, 0x0000630015157a10ULL, 0x000fc400007fe4ffULL,
0x00000070120b7812ULL, 0x000fe400078ef80bULL, 0x000062000a0a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000014437faeULL, 0x0005e2000b901c48ULL, 0x000062000c0c7a10ULL, 0x000fe40007f3e0ffULL,
0x000062000e0e7a10ULL, 0x000fe40007f5e0ffULL, 0x000062000b107a10ULL, 0x000fe40007f7e0ffULL,
0x000063000d0b7a10ULL, 0x000fc400007fe4ffULL, 0x000063000f0d7a10ULL, 0x000fe40000ffe4ffULL,
0x00006300110f7a10ULL, 0x000fe200017fe4ffULL, 0x000000000a457faeULL, 0x0005e2000b901c48ULL,
0x0000630013117a10ULL, 0x000fc60001ffe4ffULL, 0x000000000c477faeULL, 0x0005e8000b901c48ULL,
0x000000000e497faeULL, 0x0005e8000b901c48ULL, 0x00000000104b7faeULL, 0x0005e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x00000000000a7805ULL, 0x006fc40000015200ULL,
0x01e60400ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fc40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a0f7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc8000001140dULL,
0x0000000f04047211ULL, 0x000fca00078110ffULL, 0x000000ffff0d7224ULL, 0x000fca00000e060dULL,
0x0000000204047819ULL, 0x000fc8000000120dULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e60400ff0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000060300720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000009d7919ULL, 0x000e620000000000ULL, 0x00005800ff977624ULL, 0x000fe200078e00ffULL,
0x8000580005987a10ULL, 0x000fe20007ffe0ffULL, 0x00000020009a7824ULL, 0x040fe200078e00ffULL,
0x0001e688009b7811ULL, 0x000fe400078e18ffULL, 0x0000001f97047810ULL, 0x040fe40007ffe0ffULL,
0xffffffff97997810ULL, 0x000fe40007ffe0ffULL, 0x00000004ff047819ULL, 0x000fc40000011604ULL,
0x0000000997977810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff987819ULL, 0x000fe40000011698ULL,
0x0ffffffe04957812ULL, 0x000fc400078ec0ffULL, 0x0000000103097810ULL, 0x044fe20007ffe0ffULL,
0x0000010003967824ULL, 0x000fe200078e027cULL, 0x0000000000007946ULL, 0x000fe40003800000ULL,
0x000000060900720cULL, 0x000fe20003f06070ULL, 0x0000660002207a24ULL, 0x000fd800078e0296ULL,
0x00000bb000008947ULL, 0x008fea0003800000ULL, 0x00000003ff237819ULL, 0x102fe2000001169dULL,
0x000000109d947824ULL, 0x000fe200078e00ffULL, 0x00000096050d7217ULL, 0x000fe40007800000ULL,
0x0000000823117810ULL, 0x040fe20007ffe0ffULL, 0x00000001230b7824ULL, 0x000fe200078e0220ULL,
0x0000007094947812ULL, 0x000fe400078ec0ffULL, 0x00000003110a7819ULL, 0x040fe200000006ffULL,
0x0000000111097824ULL, 0x000fe200078e029dULL, 0x0000008094087812ULL, 0x000fc400078efcffULL,
0x00000004230f7810ULL, 0x040fe40007ffe0ffULL, 0xfffffff80a257812ULL, 0x000fe200078ee209ULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x0000000c23157810ULL, 0x000fe20007ffe0ffULL,
0x000000010f047824ULL, 0x000fe200078e029dULL, 0x0000001023177810ULL, 0x000fe20007ffe0ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0008ULL, 0x00000014231b7810ULL, 0x040fe40007ffe0ffULL,
0x00000018231d7810ULL, 0x000fe20007ffe0ffULL, 0x000000080f217824ULL, 0x000fe200078e00ffULL,
0x000062000a127a10ULL, 0x000fe20007f1e0ffULL, 0x00000001150c7824ULL, 0x000fe200078e029dULL,
0x0ffffff89d937812ULL, 0x000fe200078ec0ffULL, 0x0000000815277824ULL, 0x000fe200078e00ffULL,
0x000063000b137a10ULL, 0x000fe200007fe4ffULL, 0x000000010f0b7824ULL, 0x000fe200078e0220ULL,
0xfffffff821217812ULL, 0x000fe200078ee204ULL, 0x000000010d047824ULL, 0x000fe200078e0a96ULL,
0xfffffff827277812ULL, 0x000fe200078ee20cULL, 0x000001000b0a7825ULL, 0x000fe200078e0008ULL,
0x0000001c232d7810ULL, 0x000fc40007ffe0ffULL, 0x000000041100720cULL, 0x0c0fe20003f46070ULL,
0x00000001110d7824ULL, 0x100fe200078e0220ULL, 0x000062000a147a10ULL, 0x000fe20007f3e0ffULL,
0x0000000117117824ULL, 0x000fe200078e0220ULL, 0x000000040f00720cULL, 0x080fe20003f86070ULL,
0x000001000d0c7825ULL, 0x000fe200078e0008ULL, 0x000000041500720cULL, 0x080fe40003f66070ULL,
0x000000041700720cULL, 0x040fe20003f06070ULL, 0x00000001170e7824ULL, 0x040fe200078e029dULL,
0x000062000c167a10ULL, 0x000fe20007fbe0ffULL, 0x0000000817297824ULL, 0x000fe200078e00ffULL,
0x00004000001e7811ULL, 0x000fe200078e70ffULL, 0x00000001150f7824ULL, 0x100fe200078e0220ULL,
0x000063000b157a10ULL, 0x000fe20000ffe4ffULL, 0x000000011b177824ULL, 0x000fe200078e0220ULL,
0xfffffff829297812ULL, 0x000fe200078ee20eULL, 0x00000100110a7825ULL, 0x000fe200078e0008ULL,
0x00000020232f7810ULL, 0x000fc60007ffe0ffULL, 0x0000010017107825ULL, 0x000fe200078e0008ULL,
0x000063000d177a10ULL, 0x000fe40002ffe4ffULL, 0x000062000a187a10ULL, 0x000fe20007fbe0ffULL,
0x000000011d0d7824ULL, 0x000fe200078e0220ULL, 0x0000620010107a10ULL, 0x000fe20007fde0ffULL,
0x000001000f0e7825ULL, 0x100fe200078e0008ULL, 0x000063000b197a10ULL, 0x000fe40002ffe4ffULL,
0x000000042300720cULL, 0x000fe20003fa6070ULL, 0x000001000d0a7825ULL, 0x000fe200078e0008ULL,
0x000062000e0e7a10ULL, 0x000fc40007f3e0ffULL, 0x0000630011117a10ULL, 0x000fe200037fe4ffULL,
0x00000001230c7824ULL, 0x100fe200078e029dULL, 0x000062000a1a7a10ULL, 0x000fe20007fde0ffULL,
0x000000011b0d7824ULL, 0x100fe200078e029dULL, 0x000063000f0f7a10ULL, 0x000fe20000ffe4ffULL,
0x000000081b1c7824ULL, 0x000fe200078e00ffULL, 0x00000007931f7812ULL, 0x000fe200078ef80cULL,
0x0000001021217824ULL, 0x000fe200078e021eULL, 0x000000041b00720cULL, 0x000fe20003f26070ULL,
0x000000011d227824ULL, 0x000fe200078e029dULL, 0x000063000b1b7a10ULL, 0x000fe200037fe4ffULL,
0x000000012d0b7824ULL, 0x000fe200078e0220ULL, 0xfffffff81c2b7812ULL, 0x000fe200078ee20dULL,
0x000000101f1f7824ULL, 0x000fc400078e021eULL, 0x000001000b0a7825ULL, 0x000fc600078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000121f7faeULL, 0x0003e2000e901c48ULL,
0x000000012f0d7824ULL, 0x000fe200078e0220ULL, 0x000062000a1c7a10ULL, 0x000fe20007fde0ffULL,
0x000000012d0a7824ULL, 0x040fe200078e029dULL, 0x0000000014217faeULL, 0x0005e2000e101c48ULL,
0x000000042d00720cULL, 0x080fe20003f86070ULL, 0x000000081d317824ULL, 0x040fe200078e00ffULL,
0x000000041d00720cULL, 0x000fe20003fa6070ULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0x000063000b1d7a10ULL, 0x000fe200037fe4ffULL, 0x000001000d0c7825ULL, 0x000fc600078e0008ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee20aULL, 0x00000010271f7824ULL, 0x102fe200078e021eULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x0000001025157824ULL, 0x004fe200078e021eULL,
0x0000002423257810ULL, 0x000fe20007ffe0ffULL, 0x000000012f137824ULL, 0x100fe200078e029dULL,
0xfffffff831217812ULL, 0x000fe200078ee222ULL, 0x000000082f227824ULL, 0x000fe200078e00ffULL,
0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL, 0x00000001250b7824ULL, 0x040fe200078e0220ULL,
0x0000000016157faeULL, 0x0003e2000d101c48ULL, 0x000000042500720cULL, 0x040fe20003f46070ULL,
0x0000000125147824ULL, 0x000fc400078e029dULL, 0x000001000b0a7825ULL, 0x000fe200078e0008ULL,
0x000000000e1f7faeULL, 0x0005e2000d901c48ULL, 0x000000042f00720cULL, 0x000fe40003f66070ULL,
0x0000000825277824ULL, 0x000fe200078e00ffULL, 0x000062000a127a10ULL, 0x000fe40007fde0ffULL,
0xfffffff822257812ULL, 0x000fe200078ee213ULL, 0x0000001029157824ULL, 0x102fe200078e021eULL,
0x000063000b137a10ULL, 0x000fe200037fe4ffULL, 0x000000102b0b7824ULL, 0x000fe200078e021eULL,
0xfffffff827277812ULL, 0x000fe200078ee214ULL, 0x000000102d177824ULL, 0x100fe200078e021eULL,
0x0000000018157faeULL, 0x0003e2000c101c48ULL, 0x00000010210f7824ULL, 0x104fe200078e021eULL,
0x0000002823217810ULL, 0x000fe20007ffe0ffULL, 0x00000010251f7824ULL, 0x000fe200078e021eULL,
0x00000000100b7faeULL, 0x0005e2000c901c48ULL, 0x0000002c23257810ULL, 0x000fc40007ffe0ffULL,
0x00000001210a7824ULL, 0x000fe200078e029dULL, 0x000000001a0f7faeULL, 0x0007e2000e901c48ULL,
0x0000003023297810ULL, 0x040fe40007ffe0ffULL, 0x00000034232b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000821197824ULL, 0x002fe200078e00ffULL, 0x000000001c177faeULL, 0x0003e2000e101c48ULL,
0x00000038232d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000129157824ULL, 0x100fe200078e0220ULL,
0x0000003c23237810ULL, 0x000fe20007ffe0ffULL, 0x00000001210b7824ULL, 0x004fe200078e0220ULL,
0xfffffff819197812ULL, 0x000fe200078ee20aULL, 0x0000001027117824ULL, 0x000fe200078e021eULL,
0x000000000c1f7faeULL, 0x0005e2000d901c48ULL, 0x000001000b0a7825ULL, 0x000fe200078e0008ULL,
0x000000042100720cULL, 0x000fc40003fc6070ULL, 0x0000000012117faeULL, 0x0009e2000d101c48ULL,
0x00000001290f7824ULL, 0x048fe200078e029dULL, 0x000062000a0e7a10ULL, 0x000fe20007f5e0ffULL,
0x0000000829107824ULL, 0x000fe200078e00ffULL, 0x000000042500720cULL, 0x0c0fe20003fa6070ULL,
0x00000008251b7824ULL, 0x000fe200078e00ffULL, 0x000000042900720cULL, 0x080fe20003f86070ULL,
0x0000000123177824ULL, 0x102fe200078e0220ULL, 0xfffffff8101d7812ULL, 0x000fe200078ee20fULL,
0x00000001250d7824ULL, 0x004fe200078e0220ULL, 0x000063000b0f7a10ULL, 0x000fe200017fe4ffULL,
0x00000100150a7825ULL, 0x000fe200078e0008ULL, 0x000000042b00720cULL, 0x000fc40003f66070ULL,
0x000000042d00720cULL, 0x080fe20003f26070ULL, 0x000001000d0c7825ULL, 0x000fe200078e0008ULL,
0x000000042300720cULL, 0x000fc60003f06070ULL, 0x0000000125047824ULL, 0x000fe200078e029dULL,
0x000062000c107a10ULL, 0x000fe20007f5e0ffULL, 0x000000012b137824ULL, 0x110fe400078e0220ULL,
0x000000012d157824ULL, 0x000fe200078e0220ULL, 0x000063000d117a10ULL, 0x000fe200017fe4ffULL,
0x00000100130c7825ULL, 0x000fe200078e0008ULL, 0x000062000a127a10ULL, 0x000fe40007f5e0ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee204ULL, 0x000000012b047824ULL, 0x000fe200078e029dULL,
0x000063000b137a10ULL, 0x000fe200017fe4ffULL, 0x000000082b1f7824ULL, 0x000fe200078e00ffULL,
0x000062000c0c7a10ULL, 0x000fe20007f5e0ffULL, 0x00000100150a7825ULL, 0x000fc600078e0008ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee204ULL, 0x000000012d047824ULL, 0x100fe200078e029dULL,
0x000063000d0d7a10ULL, 0x000fe200017fe4ffULL, 0x000000082d217824ULL, 0x000fe200078e00ffULL,
0x000062000a0a7a10ULL, 0x000fe20007f5e0ffULL, 0x0000000123147824ULL, 0x040fe400078e029dULL,
0x0000000823237824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee204ULL,
0x0000010017087825ULL, 0x000fe200078e0008ULL, 0x000063000b0b7a10ULL, 0x000fc400017fe4ffULL,
0xfffffff823237812ULL, 0x000fe200078ee214ULL, 0x0000001019157824ULL, 0x100fe200078e021eULL,
0x0000620008087a10ULL, 0x000fe20007f5e0ffULL, 0x000000101b177824ULL, 0x100fe400078e021eULL,
0x000000101d197824ULL, 0x100fe200078e021eULL, 0x0000630009097a10ULL, 0x000fe200017fe4ffULL,
0x000000101f1b7824ULL, 0x100fe200078e021eULL, 0x000000000e157faeULL, 0x0003e2000f101c48ULL,
0x00000010211d7824ULL, 0x100fe400078e021eULL, 0x00000010231f7824ULL, 0x000fe200078e021eULL,
0x0000000010177faeULL, 0x0003e8000e901c48ULL, 0x0000000012197faeULL, 0x0003e8000e101c48ULL,
0x000000000c1b7faeULL, 0x0003e8000d901c48ULL, 0x000000000a1d7faeULL, 0x0003e8000c901c48ULL,
0x00000000081f7faeULL, 0x0003e2000c101c48ULL, 0x00000a7000007947ULL, 0x000fea0003800000ULL,
0x000000049d0b7811ULL, 0x042fe200078fe8ffULL, 0x000000109d947824ULL, 0x040fe200078e00ffULL,
0x000000089d0d7811ULL, 0x000fc400078fe8ffULL, 0x000000149d137811ULL, 0x000fe200078fe8ffULL,
0x000000010b047824ULL, 0x100fe200078e029dULL, 0x000000109d117811ULL, 0x000fe200078fe8ffULL,
0x000000080b0f7824ULL, 0x000fe200078e00ffULL, 0x000000209d197811ULL, 0x000fe200078fe8ffULL,
0x000000010d097824ULL, 0x100fe200078e029dULL, 0x0000002c9d1f7811ULL, 0x000fe200078fe8ffULL,
0x000000080d0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f087812ULL, 0x000fe200078ee204ULL,
0x0000000113107824ULL, 0x000fe200078e029dULL, 0x0000000c9d0f7811ULL, 0x000fe200078fe8ffULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0xfffffff80a0a7812ULL, 0x000fe200078ee209ULL,
0x0000000111097824ULL, 0x100fe200078e029dULL, 0x000000030f157819ULL, 0x040fe200000006ffULL,
0x000000010f047824ULL, 0x100fe200078e029dULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x00000008110e7824ULL, 0x000fe200078e00ffULL, 0x0000001c9d177811ULL, 0x000fe200078fe8ffULL,
0x0000000119167824ULL, 0x000fe200078e029dULL, 0xfffffff8150c7812ULL, 0x000fe200078ee204ULL,
0x00000008191d7824ULL, 0x000fe200078e00ffULL, 0x000000189d157811ULL, 0x000fe200078fe8ffULL,
0x0000000817147824ULL, 0x040fe200078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL,
0x0000000117097824ULL, 0x100fe200078e029dULL, 0xfffffff81d167812ULL, 0x000fe200078ee216ULL,
0x0000000115047824ULL, 0x000fe200078e029dULL, 0x000000289d1d7811ULL, 0x000fe200078fe8ffULL,
0x00000008151b7824ULL, 0x000fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee209ULL,
0x000000011f1c7824ULL, 0x100fe200078e029dULL, 0x0000003c9d477811ULL, 0x000fe200078fe8ffULL,
0x000000081f237824ULL, 0x000fe200078e00ffULL, 0xfffffff81b127812ULL, 0x000fe200078ee204ULL,
0x000000011d097824ULL, 0x100fe200078e029dULL, 0x000000249d1b7811ULL, 0x000fe200078fe8ffULL,
0x000000081d1a7824ULL, 0x000fe200078e00ffULL, 0xfffffff8231c7812ULL, 0x000fe200078ee21cULL,
0x0000000847287824ULL, 0x000fe200078e00ffULL, 0x000000349d237811ULL, 0x000fe200078fe8ffULL,
0x000000011b047824ULL, 0x040fe200078e029dULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee209ULL,
0x000000081b217824ULL, 0x000fe200078e00ffULL, 0x0000007094947812ULL, 0x000fe200078ec0ffULL,
0x0000000123097824ULL, 0x040fe200078e029dULL, 0x0000400000497811ULL, 0x000fe200078e70ffULL,
0x0000000823227824ULL, 0x000fe200078e00ffULL, 0xfffffff821187812ULL, 0x000fe200078ee204ULL,
0x000000010b0b7824ULL, 0x100fe200078e0220ULL, 0x000000309d217811ULL, 0x000fe200078fe8ffULL,
0x000000010d0d7824ULL, 0x100fe200078e0220ULL, 0xfffffff822227812ULL, 0x000fe200078ee209ULL,
0x0000000147097824ULL, 0x100fe200078e029dULL, 0x0000008094267812ULL, 0x000fe200078efcffULL,
0x0000000121047824ULL, 0x000fe200078e029dULL, 0x000000389d257811ULL, 0x000fe200078fe8ffULL,
0x0000000821277824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee209ULL,
0x000000010f0f7824ULL, 0x000fe200078e0220ULL, 0x000000209d097211ULL, 0x000fe200078fe8ffULL,
0x00000010082b7824ULL, 0x100fe200078e0249ULL, 0xfffffff8271e7812ULL, 0x000fe200078ee204ULL,
0x000000ffff277224ULL, 0x000fe200078e00ffULL, 0x0000009d9d047211ULL, 0x040fe200078fe8ffULL,
0x000000100a2d7824ULL, 0x000fe200078e0249ULL, 0x0ffffff89d937812ULL, 0x000fe200078ec0ffULL,
0x0000010009087825ULL, 0x000fc600078e0026ULL, 0x0000000793047812ULL, 0x000fe200078ef804ULL,
0x0000000111117824ULL, 0x000fe200078e0220ULL, 0x0000620008087a10ULL, 0x000fe20007f1e0ffULL,
0x000000100c2f7824ULL, 0x000fe400078e0249ULL, 0x000001000b0a7825ULL, 0x000fe200078e0026ULL,
0x0000630009097a10ULL, 0x000fc600007fe4ffULL, 0x0000000113137824ULL, 0x000fe200078e0220ULL,
0x000062000a0a7a10ULL, 0x000fe20007f3e0ffULL, 0x000000100e317824ULL, 0x000fe400078e0249ULL,
0x000001000d0c7825ULL, 0x000fe200078e0026ULL, 0x000063000b0b7a10ULL, 0x000fc60000ffe4ffULL,
0x0000000115157824ULL, 0x000fe200078e0220ULL, 0x000062000c0c7a10ULL, 0x000fe20007f5e0ffULL,
0x000001000f0e7825ULL, 0x000fc600078e0026ULL, 0x000063000d0d7a10ULL, 0x000fe200017fe4ffULL,
0x0000000117177824ULL, 0x000fe200078e0220ULL, 0x000062000e0e7a10ULL, 0x000fe20007f7e0ffULL,
0x0000001010337824ULL, 0x100fe400078e0249ULL, 0x0000001012357824ULL, 0x000fe200078e0249ULL,
0x000063000f0f7a10ULL, 0x000fe20001ffe4ffULL, 0x0000010011107825ULL, 0x000fc800078e0026ULL,
0x0000000125247824ULL, 0x040fe200078e029dULL, 0x0000620010107a10ULL, 0x000fe20007f1e0ffULL,
0x0000000825297824ULL, 0x000fe400078e00ffULL, 0x0000000119197824ULL, 0x000fe200078e0220ULL,
0x0000630011117a10ULL, 0x000fe200007fe4ffULL, 0x0000001014377824ULL, 0x000fe200078e0249ULL,
0xfffffff829247812ULL, 0x000fe200078ee224ULL, 0x0000010013127825ULL, 0x000fc800078e0026ULL,
0x000000011b1b7824ULL, 0x000fe200078e0220ULL, 0x0000620012127a10ULL, 0x000fe20007f3e0ffULL,
0x0000001016397824ULL, 0x000fe400078e0249ULL, 0x0000010015147825ULL, 0x000fe200078e0026ULL,
0x0000630013137a10ULL, 0x000fc60000ffe4ffULL, 0x000000011d1d7824ULL, 0x000fe200078e0220ULL,
0x0000620014147a10ULL, 0x000fe20007f5e0ffULL, 0x0000010017167825ULL, 0x000fc600078e0026ULL,
0x0000630015157a10ULL, 0x000fe200017fe4ffULL, 0x000000011f1f7824ULL, 0x000fe200078e0220ULL,
0x0000620016167a10ULL, 0x000fe20007f7e0ffULL, 0x00000010183b7824ULL, 0x100fe400078e0249ULL,
0x000000101a3d7824ULL, 0x000fe200078e0249ULL, 0x0000630017177a10ULL, 0x000fe20001ffe4ffULL,
0x0000010019187825ULL, 0x000fc800078e0026ULL, 0x0000000121217824ULL, 0x000fe200078e0220ULL,
0x0000620018187a10ULL, 0x000fe20007f1e0ffULL, 0x000000101c3f7824ULL, 0x000fe400078e0249ULL,
0x000001001b1a7825ULL, 0x000fe200078e0026ULL, 0x0000630019197a10ULL, 0x000fc600007fe4ffULL,
0x0000000123237824ULL, 0x000fe200078e0220ULL, 0x000062001a1a7a10ULL, 0x000fe20007f3e0ffULL,
0x0000001004297824ULL, 0x100fe400078e0249ULL, 0x000000101e417824ULL, 0x000fe200078e0249ULL,
0x000063001b1b7a10ULL, 0x000fe20000ffe4ffULL, 0x000001001d1c7825ULL, 0x000fe200078e0026ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008297faeULL, 0x0003e6000b901c48ULL,
0x0000000125257824ULL, 0x000fe200078e0220ULL, 0x000062001c1c7a10ULL, 0x000fe20007f5e0ffULL,
0x000001001f1e7825ULL, 0x000fe200078e0026ULL, 0x000000000a2b7faeULL, 0x0003e4000b901c48ULL,
0x000063001d1d7a10ULL, 0x000fe200017fe4ffULL, 0x0000000147477824ULL, 0x000fe200078e0220ULL,
0x000062001e1e7a10ULL, 0x000fe20007f7e0ffULL, 0x0000001022437824ULL, 0x000fe200078e0249ULL,
0x000000000c2d7faeULL, 0x0003e2000b901c48ULL, 0x0000010021207825ULL, 0x000fe200078e0026ULL,
0x000063001f1f7a10ULL, 0x000fc40001ffe4ffULL, 0x000000000e2f7faeULL, 0x0003e2000b901c48ULL,
0x0000001024457824ULL, 0x000fe200078e0249ULL, 0x0000620020207a10ULL, 0x000fe20007f1e0ffULL,
0x0000010023227825ULL, 0x100fe200078e0026ULL, 0x0000000010317faeULL, 0x0003e4000b901c48ULL,
0x0000630021217a10ULL, 0x000fe200007fe4ffULL, 0x0000010025247825ULL, 0x100fe200078e0026ULL,
0x0000620022227a10ULL, 0x000fe20007f3e0ffULL, 0x0000000012337faeULL, 0x0003e4000b901c48ULL,
0x0000010047267825ULL, 0x000fe200078e0026ULL, 0x0000620024247a10ULL, 0x000fe20007f5e0ffULL,
0x0000000014357faeULL, 0x0003e2000b901c48ULL, 0x0000630023237a10ULL, 0x000fe20000ffe4ffULL,
0x0000001028497824ULL, 0x000fe200078e0249ULL, 0x0000620026267a10ULL, 0x000fe20007f7e0ffULL,
0x0000000016377faeULL, 0x0003e2000b901c48ULL, 0x0000630025257a10ULL, 0x000fc400017fe4ffULL,
0x0000630027277a10ULL, 0x000fe20001ffe4ffULL, 0x0000000018397faeULL, 0x0003e8000b901c48ULL,
0x000000001a3b7faeULL, 0x0003e8000b901c48ULL, 0x000000001c3d7faeULL, 0x0003e8000b901c48ULL,
0x000000001e3f7faeULL, 0x0003e8000b901c48ULL, 0x0000000020417faeULL, 0x0003e8000b901c48ULL,
0x0000000022437faeULL, 0x0003e8000b901c48ULL, 0x0000000024457faeULL, 0x0003e8000b901c48ULL,
0x0000000026497faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000089d927812ULL, 0x000fc400078ec0ffULL, 0x00000004ff8b7819ULL, 0x100fe4000001169dULL,
0x0000000792927812ULL, 0x000fe400078ef89dULL, 0x000000079d1c7812ULL, 0x002fc600078ec0ffULL,
0x000000018b917824ULL, 0x000fe400078e0292ULL, 0x0000001092047824ULL, 0x000fca00078e00ffULL,
0xfffffff004047812ULL, 0x000fca00078ee291ULL, 0x0000001004107824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x000000088b097824ULL, 0x000fe200078e00ffULL, 0x00000003ff907819ULL, 0x000fe2000001169dULL,
0x00004000008f7824ULL, 0x000fe200078e00ffULL, 0x00000010928e7812ULL, 0x040fe200078efcffULL,
0x00000010921d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8091c7812ULL, 0x000fe200078ee21cULL,
0x000000001010783bULL, 0x000fe20000000200ULL, 0x0000000190097812ULL, 0x000fe200078ec0ffULL,
0x000000018b8b7824ULL, 0x000fe200078e028eULL, 0x000000101c207810ULL, 0x040fe20007ffe0ffULL,
0x000000081c0b7824ULL, 0x040fe200078e00ffULL, 0x000000201c7e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000109047824ULL, 0x000fe200078e021cULL, 0x000000301c7d7810ULL, 0x000fe20007ffe0ffULL,
0x000000108e087824ULL, 0x000fe200078e00ffULL, 0x000020008f8d7810ULL, 0x000fe20007ffe0ffULL,
0x00000001098a7824ULL, 0x000fe200078e0220ULL, 0xfffffff80b8c7812ULL, 0x000fe200078ee204ULL,
0x0000000109897824ULL, 0x040fe200078e027eULL, 0xfffffff008087812ULL, 0x000fe200078ee28bULL,
0x0000000109887824ULL, 0x000fe200078e027dULL, 0x00000002910a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000820097824ULL, 0x000fe200078e00ffULL, 0x0000008d8c187211ULL, 0x000fe200078e20ffULL,
0x000000087e0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff01d1d7812ULL, 0x000fe200078ee20aULL,
0x000000087d0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8098a7812ULL, 0x000fe200078ee28aULL,
0x0000001008087824ULL, 0x000fe200078e00ffULL, 0xfffffff80c897812ULL, 0x000fe200078ee289ULL,
0x000000108e0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80b887812ULL, 0x000fe200078ee288ULL,
0x000000108a0c7824ULL, 0x100fe200078e028dULL, 0x000000000878783bULL, 0x0003e20000000200ULL,
0x000000028b0a7810ULL, 0x000fe20007ffe0ffULL, 0x000000081c167824ULL, 0x000fe200078e00ffULL,
0x0000000204877810ULL, 0x000fe20007ffe0ffULL, 0x0000001088147824ULL, 0x000fe200078e028dULL,
0xfffffff00d1e7812ULL, 0x000fe200078ee20aULL, 0x000000001818783bULL, 0x000ea20000000200ULL,
0xfffffff816877812ULL, 0x000fe200078ee287ULL, 0x0000001089087824ULL, 0x002fe200078e028dULL,
0x0000001204867810ULL, 0x000fe20007ffe0ffULL, 0x000000000c0c783bULL, 0x000e620000000200ULL,
0x00000008201f7824ULL, 0x000fe200078e00ffULL, 0x0000002204857810ULL, 0x000fe20007ffe0ffULL,
0x000000087e227824ULL, 0x000fe200078e00ffULL, 0x000000000808783bULL, 0x000ee20000000200ULL,
0x0000003204847810ULL, 0x000fe20007ffe0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f867812ULL, 0x000fe200078ee286ULL, 0x000000001414783bULL, 0x000f220000000200ULL,
0x000000087d1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff822857812ULL, 0x000fe200078ee285ULL,
0x000000101e1e7824ULL, 0x000fe200078e00ffULL, 0x000000001d58783bULL, 0x000fe20000000200ULL,
0x0000001086387824ULL, 0x100fe200078e028dULL, 0xfffffff81f847812ULL, 0x000fe200078ee284ULL,
0x0000001087547824ULL, 0x100fe200078e028dULL, 0x000000001e40783bULL, 0x000fe20000000200ULL,
0x0000001085287824ULL, 0x100fe200078e028dULL, 0x0000000404837810ULL, 0x000fe20007ffe0ffULL,
0x0000001084247824ULL, 0x000fe200078e028dULL, 0x000000003838783bULL, 0x000ee20000000200ULL,
0x0000001404827810ULL, 0x000fc40007ffe0ffULL, 0x0000002404817810ULL, 0x040fe20007ffe0ffULL,
0x000000005454783bULL, 0x000ee20000000200ULL, 0x0000003404807810ULL, 0x040fe40007ffe0ffULL,
0x00000006047f7810ULL, 0x000fe20007ffe0ffULL, 0x000000002828783bULL, 0x000ee80000000200ULL,
0x000000002424783bULL, 0x000ee20000000200ULL, 0x000000181044723cULL, 0x044ff000000018ffULL,
0x0000000c1060723cULL, 0x042f7000000018ffULL, 0x0000000e1068723cULL, 0x000f7000000018ffULL,
0x0000000c7850723cULL, 0x040f7000000018ffULL, 0x0000000e780c723cULL, 0x000f7000000018ffULL,
0x0000001a104c723cULL, 0x040f7000000018ffULL, 0x000000081070723cULL, 0x048f7000000018ffULL,
0x0000000a106c723cULL, 0x040f7000000018ffULL, 0x000000141064723cULL, 0x050f7000000018ffULL,
0x000000161010723cULL, 0x000f7000000018ffULL, 0x000000087834723cULL, 0x040f7000000018ffULL,
0x0000000a7808723cULL, 0x000f7000000018ffULL, 0x000000385860723cULL, 0x060ff00000001860ULL,
0x0000003a5868723cULL, 0x000ff00000001868ULL, 0x000000384050723cULL, 0x040ff00000001850ULL,
0x0000003a4038723cULL, 0x000bee000000180cULL, 0x000000081c0c7824ULL, 0x020fe200078e00ffULL,
0x000000545844723cULL, 0x000fe20000001844ULL, 0x00000008200d7824ULL, 0x000fc400078e00ffULL,
0x000000087e0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c837812ULL, 0x000fe200078ee283ULL,
0x000000087d0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d827812ULL, 0x000fe200078ee282ULL,
0x000000087d0d7824ULL, 0x000fe200078e00ffULL, 0x00000056584c723cULL, 0x000fe2000000184cULL,
0xfffffff80e817812ULL, 0x000fe200078ee281ULL, 0x0000001083747824ULL, 0x100fe200078e028dULL,
0xfffffff80f807812ULL, 0x000fe200078ee280ULL, 0x00000010823c7824ULL, 0x000fe200078e028dULL,
0xfffffff80c7f7812ULL, 0x000fe200078ee27fULL, 0x00000010812c7824ULL, 0x000fc400078e028dULL,
0x000000147830723cULL, 0x000be200000018ffULL, 0x0000001080217824ULL, 0x100fe200078e028dULL,
0x000000007474783bULL, 0x000fe20000000200ULL, 0x000000107f0c7824ULL, 0x000fc600078e028dULL,
0x000000003c3c783bULL, 0x000fe20000000200ULL, 0x0000001092157824ULL, 0x020fe200078e00ffULL,
0x000000285870723cULL, 0x040fe20000001870ULL, 0x000000108e147824ULL, 0x000fe200078e00ffULL,
0x000000002c2c783bULL, 0x000fec0000000200ULL, 0x0000002a586c723cULL, 0x040ff0000000186cULL,
0x000000245864723cULL, 0x040ff00000001864ULL, 0x000000265858723cULL, 0x000bee0000001810ULL,
0x0000000491107810ULL, 0x020fe20007ffe0ffULL, 0x000000187848723cULL, 0x000f6200000018ffULL,
0x000000048b117810ULL, 0x000fc40007ffe0ffULL, 0xfffffff015107812ULL, 0x000fe400078ee210ULL,
0xfffffff014117812ULL, 0x000fe400078ee211ULL, 0x0000000691127810ULL, 0x000fe20007ffe0ffULL,
0x0000001a7818723cULL, 0x000f6200000018ffULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0x000000068b137810ULL, 0x000fe20007ffe0ffULL, 0x0000001011117824ULL, 0x000fc600078e00ffULL,
0x00000000105c783bULL, 0x000e640000000200ULL, 0x000000284034723cULL, 0x040fe40000001834ULL,
0x00000000111c783bULL, 0x000fec0000000200ULL, 0x0000002a4028723cULL, 0x000bee0000001808ULL,
0x0000000820097824ULL, 0x020fe200078e00ffULL, 0x000000167878723cULL, 0x000b6200000018ffULL,
0x000000002120783bULL, 0x000ea20000000200ULL, 0x000000087e0b7824ULL, 0x000fe200078e00ffULL,
0x00000016047e7810ULL, 0x000fc40007ffe0ffULL, 0x0000002604087810ULL, 0x000fe40007ffe0ffULL,
0x0000001092177824ULL, 0x020fe200078e00ffULL, 0x0000003604047810ULL, 0x000fe20007ffe0ffULL,
0x000000544048723cULL, 0x040f620000001848ULL, 0xfffffff8097e7812ULL, 0x000fe200078ee27eULL,
0x000000108e167824ULL, 0x000fe200078e00ffULL, 0xfffffff017127812ULL, 0x000fe400078ee212ULL,
0xfffffff80b7d7812ULL, 0x000fe200078ee208ULL, 0x000000107e147824ULL, 0x000fe200078e028dULL,
0xfffffff80d047812ULL, 0x000fe200078ee204ULL, 0x000000564054723cULL, 0x040b620000001818ULL,
0x0000001012087824ULL, 0x000fe200078e00ffULL, 0xfffffff016137812ULL, 0x000fe200078ee213ULL,
0x000000000c0c783bULL, 0x000fe80000000200ULL, 0x000000107d187824ULL, 0x020fe200078e028dULL,
0x000000244030723cULL, 0x000b620000001830ULL, 0x000000000808783bULL, 0x000ee20000000200ULL,
0x0000001013137824ULL, 0x000fc600078e00ffULL, 0x000000001414783bULL, 0x000f240000000200ULL,
0x0000001004247824ULL, 0x020fe200078e028dULL, 0x000000264040723cULL, 0x000b620000001878ULL,
0x000000001818783bULL, 0x000ea80000000200ULL, 0x000000002424783bULL, 0x020ea40000000200ULL,
0x0000030003797a10ULL, 0x000fe20007ffe0ffULL, 0x000000745c44723cULL, 0x042f620000001844ULL,
0x000000001310783bULL, 0x000e6e0000000200ULL, 0x000000765c4c723cULL, 0x040f70000000184cULL,
0x0000003c5c60723cULL, 0x040f700000001860ULL, 0x0000003e5c68723cULL, 0x040f700000001868ULL,
0x0000002c5c70723cULL, 0x040f700000001870ULL, 0x0000002e5c6c723cULL, 0x040f70000000186cULL,
0x000000205c64723cULL, 0x044f700000001864ULL, 0x000000225c58723cULL, 0x000f700000001858ULL,
0x000000741c48723cULL, 0x040f700000001848ULL, 0x000000761c54723cULL, 0x040f700000001854ULL,
0x0000003c1c50723cULL, 0x040f700000001850ULL, 0x0000003e1c38723cULL, 0x040f700000001838ULL,
0x0000002c1c34723cULL, 0x040f700000001834ULL, 0x0000002e1c28723cULL, 0x040f700000001828ULL,
0x000000201c30723cULL, 0x040f700000001830ULL, 0x000000221c40723cULL, 0x000f700000001840ULL,
0x0000000c0844723cULL, 0x068f700000001844ULL, 0x0000000e084c723cULL, 0x040f70000000184cULL,
0x000000140860723cULL, 0x050f700000001860ULL, 0x000000160868723cULL, 0x040f700000001868ULL,
0x000000180870723cULL, 0x040f700000001870ULL, 0x0000001a086c723cULL, 0x040f70000000186cULL,
0x000000240864723cULL, 0x040f700000001864ULL, 0x000000260858723cULL, 0x000b6e0000001858ULL,
0x0000000179097810ULL, 0x060fe20007ffe0ffULL, 0x0000010079087824ULL, 0x000fe200078e027cULL,
0x0000000c1048723cULL, 0x002b640000001848ULL, 0x000000060900720cULL, 0x000fe20003f06070ULL,
0x00006600020b7a24ULL, 0x000fca00078e0208ULL, 0x0000000e1054723cULL, 0x040b700000001854ULL,
0x000000141050723cULL, 0x040b700000001850ULL, 0x000000161038723cULL, 0x040b700000001838ULL,
0x000000181034723cULL, 0x040b700000001834ULL, 0x0000001a1028723cULL, 0x040b700000001828ULL,
0x000000241030723cULL, 0x040b700000001830ULL, 0x000000261040723cULL, 0x000b620000001840ULL,
0x00000c4000008947ULL, 0x000fce0003800000ULL, 0x00000004900e7810ULL, 0x060fe20007ffe0ffULL,
0x00000001900a7824ULL, 0x000fe200078e029dULL, 0x00000008050d7217ULL, 0x000fc40007800000ULL,
0x0000000890107810ULL, 0x000fe20007ffe0ffULL, 0x000000010e097824ULL, 0x000fe200078e029dULL,
0x0000000c90167810ULL, 0x000fe20007ffe0ffULL, 0x000000080e0c7824ULL, 0x000fe200078e00ffULL,
0x0000001490207810ULL, 0x040fe20007ffe0ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0a08ULL,
0x0000001090187810ULL, 0x040fe20007ffe0ffULL, 0x0000000190087824ULL, 0x000fe200078e020bULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee209ULL, 0x00000001100f7824ULL, 0x000fe200078e029dULL,
0x0000000d0e00720cULL, 0x080fe20003f46070ULL, 0x00000008101a7824ULL, 0x040fe200078e00ffULL,
0x0000000d1000720cULL, 0x000fe20003f66070ULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000001890247810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee20fULL,
0x00000001160f7824ULL, 0x100fe200078e029dULL, 0x0000009408127212ULL, 0x000fe200078efcffULL,
0x00000008161c7824ULL, 0x040fe200078e00ffULL, 0x0000000d1600720cULL, 0x080fe20003fa6070ULL,
0x0000000120087824ULL, 0x000fe200078e029dULL, 0x0000620012127a10ULL, 0x000fe20007f1e0ffULL,
0x0000000820137824ULL, 0x000fe200078e00ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee20fULL,
0x000000010e0e7824ULL, 0x000fe200078e020bULL, 0x0000000d9000720cULL, 0x000fe20003f26070ULL,
0x0000000118117824ULL, 0x000fe200078e029dULL, 0xfffffff813227812ULL, 0x000fe200078ee208ULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000630009137a10ULL, 0x000fc400007fe4ffULL,
0x00000007930a7812ULL, 0x000fe200078ef80aULL, 0x0000000110087824ULL, 0x100fe200078e020bULL,
0x000000940e147212ULL, 0x080fe200078efcffULL, 0x00000008181e7824ULL, 0x040fe200078e00ffULL,
0x0000000d1800720cULL, 0x000fe20003f86070ULL, 0x0000000116107824ULL, 0x000fe200078e020bULL,
0x0000620014147a10ULL, 0x000fe20007f1e0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe400078ee211ULL, 0x000063000f157a10ULL, 0x000fe200007fe4ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x0000009408167212ULL, 0x000fc400078efcffULL,
0x0000000b20087210ULL, 0x000fe20007ffe0ffULL, 0x00000001180e7824ULL, 0x000fe200078e020bULL,
0x0000009410107212ULL, 0x080fe200078efcffULL, 0x0000000124177824ULL, 0x000fe200078e029dULL,
0x0000620016167a10ULL, 0x000fe20007f1e0ffULL, 0x0000000824267824ULL, 0x000fe200078e00ffULL,
0x0000620010107a10ULL, 0x000fe20007fde0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x00000020902c7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff826267812ULL, 0x000fe200078ee217ULL,
0x000000100a1b7824ULL, 0x000fe200078e028dULL, 0x0000630009177a10ULL, 0x000fe200007fe4ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x000000940e187212ULL, 0x000fc400078efcffULL,
0x0000630011117a10ULL, 0x000fe200037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121b7faeULL, 0x0003e2000c901c48ULL, 0x0000620018187a10ULL, 0x000fe20007fde0ffULL,
0x00000001240a7824ULL, 0x000fe200078e020bULL, 0x0000009408087212ULL, 0x000fe200078efcffULL,
0x000000012c1f7824ULL, 0x000fe200078e029dULL, 0x000063000f197a10ULL, 0x000fe200037fe4ffULL,
0x000000100c1d7824ULL, 0x000fe200078e028dULL, 0x0000000d2400720cULL, 0x000fe20003f26070ULL,
0x000000082c247824ULL, 0x000fe200078e00ffULL, 0x0000001c900e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000d2000720cULL, 0x080fe20003f06070ULL, 0x00000000141d7faeULL, 0x0005e2000d101c48ULL,
0x0000620008127a10ULL, 0x002fe20007fde0ffULL, 0x000000010e0f7824ULL, 0x000fe200078e029dULL,
0xfffffff8240c7812ULL, 0x000fe200078ee21fULL, 0x000000080e207824ULL, 0x000fe200078e00ffULL,
0x0000630009137a10ULL, 0x000fe200037fe4ffULL, 0x000001000a087825ULL, 0x000fe200078e00ffULL,
0x0000000d0e00720cULL, 0x080fe40003f46070ULL, 0xfffffff820207812ULL, 0x000fe200078ee20fULL,
0x000000101a1f7824ULL, 0x000fe200078e028dULL, 0x00000094081a7212ULL, 0x000fe200078efcffULL,
0x000000010e0e7824ULL, 0x100fe200078e020bULL, 0x00000024900a7810ULL, 0x000fe20007ffe0ffULL,
0x000000012c087824ULL, 0x000fe200078e020bULL, 0x000062001a1a7a10ULL, 0x000fe20007fde0ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x00000000161f7faeULL, 0x0003e2000d901c48ULL,
0x0000000d2c00720cULL, 0x000fc40003f66070ULL, 0x00006300091b7a10ULL, 0x000fe200037fe4ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x000000940e147212ULL, 0x084fe400078efcffULL,
0x0000003490247810ULL, 0x000fe20007ffe0ffULL, 0x000000101c1d7824ULL, 0x000fe200078e028dULL,
0x0000620014147a10ULL, 0x000fe20007fde0ffULL, 0x000000010a0e7824ULL, 0x000fe200078e020bULL,
0x0000009408167212ULL, 0x002fe200078efcffULL, 0x000000010a177824ULL, 0x040fe200078e029dULL,
0x000063000f157a10ULL, 0x000fe200037fe4ffULL, 0x000000080a1c7824ULL, 0x000fe200078e00ffULL,
0x0000620016167a10ULL, 0x000fe20007fde0ffULL, 0x000000101e1f7824ULL, 0x000fe200078e028dULL,
0x0000002890087810ULL, 0x000fe20007ffe0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x00000000101d7faeULL, 0x0003e2000e901c48ULL, 0x0000000d0a00720cULL, 0x000fc40003fa6070ULL,
0xfffffff81c0a7812ULL, 0x000fe200078ee217ULL, 0x00000000181f7faeULL, 0x0005e2000e101c48ULL,
0x0000630009177a10ULL, 0x000fe200037fe4ffULL, 0x0000000108097824ULL, 0x000fe200078e029dULL,
0x000000940e1c7212ULL, 0x000fe200078efcffULL, 0x00000008081e7824ULL, 0x040fe200078e00ffULL,
0x0000000d0800720cULL, 0x040fe20003f86070ULL, 0x0000000108087824ULL, 0x000fe200078e020bULL,
0x000062001c1c7a10ULL, 0x000fe20007fde0ffULL, 0x0000001022117824ULL, 0x002fe200078e028dULL,
0x0000002c90107810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee209ULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x000063000f1d7a10ULL, 0x000fe200037fe4ffULL,
0x0000000012117faeULL, 0x0003e2000c101c48ULL, 0x0000003090227810ULL, 0x000fe20007ffe0ffULL,
0x00000001100e7824ULL, 0x000fe200078e020bULL, 0x0000009408087212ULL, 0x000fe200078efcffULL,
0x0000000110187824ULL, 0x044fe200078e029dULL, 0x0000000d1000720cULL, 0x040fe20003f06070ULL,
0x0000000810197824ULL, 0x000fe200078e00ffULL, 0x0000620008087a10ULL, 0x000fe20007fde0ffULL,
0x000001000e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff819187812ULL, 0x000fe200078ee218ULL,
0x0000001026197824ULL, 0x000fe200078e028dULL, 0x000000940e127212ULL, 0x002fe200078efcffULL,
0x00000001220e7824ULL, 0x040fe200078e029dULL, 0x0000630009097a10ULL, 0x000fe200037fe4ffULL,
0x00000008221f7824ULL, 0x040fe200078e00ffULL, 0x000000001a197faeULL, 0x0003e2000c901c48ULL,
0x0000000122107824ULL, 0x040fe200078e020bULL, 0x0000000d2200720cULL, 0x000fe40003f26070ULL,
0x0000620012127a10ULL, 0x000fe20007fde0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0xfffffff81f227812ULL, 0x000fc400078ee20eULL, 0x000063000f137a10ULL, 0x000fe200037fe4ffULL,
0x00000010201f7824ULL, 0x000fe200078e028dULL, 0x0000009410107212ULL, 0x000fe200078efcffULL,
0x00000001240e7824ULL, 0x000fe400078e020bULL, 0x000000100a1b7824ULL, 0x102fe200078e028dULL,
0x00000038900a7810ULL, 0x000fe20007ffe0ffULL, 0x000000100c197824ULL, 0x000fe200078e028dULL,
0x0000003c90907810ULL, 0x000fe20007ffe0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x00000000141f7faeULL, 0x0003e2000d101c48ULL, 0x0000620010107a10ULL, 0x000fc40007fde0ffULL,
0x000000010a0c7824ULL, 0x140fe200078e020bULL, 0x0000000016197faeULL, 0x0005e2000d901c48ULL,
0x0000000d0a00720cULL, 0x080fe20003f66070ULL, 0x00000001900b7824ULL, 0x040fe200078e020bULL,
0x0000000d9000720cULL, 0x080fe20003f46070ULL, 0x000000001c1b7faeULL, 0x0007e2000e901c48ULL,
0x0000000d2400720cULL, 0x000fe20003fa6070ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x000000940e0e7212ULL, 0x080fe400078efcffULL, 0x0000630011117a10ULL, 0x000fe200037fe4ffULL,
0x000000010a157824ULL, 0x002fe200078e029dULL, 0x000062000e0e7a10ULL, 0x000fe20007fde0ffULL,
0x000000080a167824ULL, 0x004fe200078e00ffULL, 0x000000940c0c7212ULL, 0x000fe200078efcffULL,
0x000001000b0a7825ULL, 0x000fe200078e00ffULL, 0x000063000f0f7a10ULL, 0x000fc400037fe4ffULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x0000000124147824ULL, 0x000fe200078e029dULL,
0x000000940a0a7212ULL, 0x000fe200078efcffULL, 0x0000000824197824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee215ULL, 0x0000000190177824ULL, 0x040fe200078e029dULL,
0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL, 0x00000008901a7824ULL, 0x000fe200078e00ffULL,
0xfffffff819147812ULL, 0x000fe200078ee214ULL, 0x000000101e157824ULL, 0x100fe200078e028dULL,
0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL, 0x0000001022197824ULL, 0x000fe200078e028dULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee217ULL, 0x0000001018177824ULL, 0x100fe200078e028dULL,
0x000063000b0b7a10ULL, 0x000fe200037fe4ffULL, 0x00000010141b7824ULL, 0x108fe200078e028dULL,
0x0000000008157faeULL, 0x0003e2000e101c48ULL, 0x00000010161d7824ULL, 0x000fc400078e028dULL,
0x000000101a8d7824ULL, 0x000fe200078e028dULL, 0x0000000012177faeULL, 0x0003e8000c101c48ULL,
0x0000000010197faeULL, 0x0003e8000c901c48ULL, 0x000000000e1b7faeULL, 0x0003e8000e901c48ULL,
0x000000000c1d7faeULL, 0x0003e8000d901c48ULL, 0x000000000a8d7faeULL, 0x0003e2000d101c48ULL,
0x00000b1000007947ULL, 0x000fea0003800000ULL, 0x0000000890107810ULL, 0x060fe20007ffe0ffULL,
0x0000000190087824ULL, 0x040fe200078e029dULL, 0x0000000c90147810ULL, 0x000fc40007ffe0ffULL,
0x0000001090187810ULL, 0x000fe20007ffe0ffULL, 0x00000001100d7824ULL, 0x100fe200078e029dULL,
0x00000004900c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000810127824ULL, 0x000fe200078e00ffULL,
0x00000007930a7812ULL, 0x000fe200078ef808ULL, 0x00000001140f7824ULL, 0x100fe200078e029dULL,
0x0000001890207810ULL, 0x000fe20007ffe0ffULL, 0x0000000814167824ULL, 0x000fe200078e00ffULL,
0x0000001c90247810ULL, 0x000fe20007ffe0ffULL, 0x0000000118087824ULL, 0x000fe200078e029dULL,
0x00000020902c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000818117824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee20dULL, 0x000000010c097824ULL, 0x000fe200078e029dULL,
0xfffffff816167812ULL, 0x000fe200078ee20fULL, 0x000000080c0e7824ULL, 0x000fe200078e00ffULL,
0x00000014901c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001200d7824ULL, 0x140fe200078e029dULL,
0xfffffff8111a7812ULL, 0x000fe200078ee208ULL, 0x0000000820227824ULL, 0x000fe200078e00ffULL,
0x00000028905c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001240f7824ULL, 0x000fe200078e029dULL,
0x0000002c90747810ULL, 0x000fe20007ffe0ffULL, 0x0000000824267824ULL, 0x000fe200078e00ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL, 0x000000012c087824ULL, 0x000fe200078e029dULL,
0xfffffff822227812ULL, 0x000fe200078ee20dULL, 0x000000082c117824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee20fULL, 0x000000011c097824ULL, 0x100fe200078e029dULL,
0x00000024903c7810ULL, 0x000fe20007ffe0ffULL, 0x000000081c1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8112e7812ULL, 0x000fe200078ee208ULL, 0x000000015c0d7824ULL, 0x100fe200078e029dULL,
0x0000000b90087210ULL, 0x000fe20007ffe0ffULL, 0x000000085c5e7824ULL, 0x000fe200078e00ffULL,
0x0000003090787810ULL, 0x000fe20007ffe0ffULL, 0x00000001740f7824ULL, 0x000fe200078e029dULL,
0x00000034907a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000874767824ULL, 0x000fe200078e00ffULL,
0x00000038909c7810ULL, 0x000fe20007ffe0ffULL, 0x000000083c3e7824ULL, 0x000fe200078e00ffULL,
0x0000003c90907810ULL, 0x000fe20007ffe0ffULL, 0x000000011c137824ULL, 0x000fe200078e020bULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee209ULL, 0x000000013c097824ULL, 0x000fe200078e029dULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee20dULL, 0x00000001100d7824ULL, 0x000fe200078e020bULL,
0xfffffff876767812ULL, 0x000fe200078ee20fULL, 0x00000001140f7824ULL, 0x000fe200078e020bULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee209ULL, 0x0000000118107824ULL, 0x000fc400078e020bULL,
0x0000000120147824ULL, 0x100fe400078e020bULL, 0x000000010c0c7824ULL, 0x100fe400078e020bULL,
0x0000000124177824ULL, 0x100fe400078e020bULL, 0x000000012c187824ULL, 0x100fe400078e020bULL,
0x000000013c1b7824ULL, 0x100fe400078e020bULL, 0x000000015c1c7824ULL, 0x000fc400078e020bULL,
0x00000001741f7824ULL, 0x100fe400078e020bULL, 0x0000000178207824ULL, 0x100fe400078e020bULL,
0x000000017a237824ULL, 0x100fe400078e020bULL, 0x000000019c257824ULL, 0x100fe400078e020bULL,
0x0000000190277824ULL, 0x000fe400078e020bULL, 0x000000019c0b7824ULL, 0x000fc400078e029dULL,
0x000000089c3c7824ULL, 0x000fe400078e00ffULL, 0x0000010008087825ULL, 0x000fc600078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20bULL, 0x000000100a2d7824ULL, 0x000fe200078e028dULL,
0x0000009408087212ULL, 0x000fe200078efcffULL, 0x000001000c0a7825ULL, 0x000fc600078e00ffULL,
0x0000620008087a10ULL, 0x000fe20007f1e0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e00ffULL,
0x000000940a0a7212ULL, 0x080fe400078efcffULL, 0x0000630009097a10ULL, 0x000fe200007fe4ffULL,
0x000000100e2f7824ULL, 0x100fe200078e028dULL, 0x000000940c0c7212ULL, 0x080fe200078efcffULL,
0x000001000f0e7825ULL, 0x000fe200078e00ffULL, 0x000062000a0a7a10ULL, 0x000fe20007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000082d7faeULL, 0x0003e2000b901c48ULL,
0x000062000c0c7a10ULL, 0x000fe20007f1e0ffULL, 0x00000010123d7824ULL, 0x000fe200078e028dULL,
0x000000940e0e7212ULL, 0x000fe200078efcffULL, 0x0000010013127825ULL, 0x000fe200078e00ffULL,
0x000063000d0d7a10ULL, 0x000fc400007fe4ffULL, 0x000062000e0e7a10ULL, 0x000fe20007f1e0ffULL,
0x00000010163f7824ULL, 0x000fe200078e028dULL, 0x0000009412127212ULL, 0x080fe200078efcffULL,
0x0000000178117824ULL, 0x040fe200078e029dULL, 0x000063000f0f7a10ULL, 0x000fe200007fe4ffULL,
0x0000000878247824ULL, 0x000fe200078e00ffULL, 0x0000620012127a10ULL, 0x000fe20007f1e0ffULL,
0x0000010017167825ULL, 0x000fe200078e00ffULL, 0x000063000b0b7a10ULL, 0x000fe40000ffe4ffULL,
0xfffffff824247812ULL, 0x000fe200078ee211ULL, 0x000000017a157824ULL, 0x000fe200078e029dULL,
0x0000009416167212ULL, 0x080fe200078efcffULL, 0x000000087a2c7824ULL, 0x000fe200078e00ffULL,
0x0000630013137a10ULL, 0x000fe200007fe4ffULL, 0x000000101a5d7824ULL, 0x000fe200078e028dULL,
0x0000620016167a10ULL, 0x000fe20007f1e0ffULL, 0x0000000190197824ULL, 0x000fe200078e029dULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee215ULL, 0x00000008905c7824ULL, 0x000fe200078e00ffULL,
0x0000630017177a10ULL, 0x000fe200007fe4ffULL, 0x000001001b1a7825ULL, 0x000fe200078e00ffULL,
0x000000000a2f7faeULL, 0x0003e4000b901c48ULL, 0xfffffff85c5c7812ULL, 0x000fe200078ee219ULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x000000941a1a7212ULL, 0x080fe200078efcffULL,
0x000000000c3d7faeULL, 0x0003e4000b901c48ULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000009410107212ULL, 0x080fe200078efcffULL, 0x000000000e3f7faeULL, 0x0003e2000b901c48ULL,
0x000062001a1a7a10ULL, 0x000fe20007f1e0ffULL, 0x000000101e5f7824ULL, 0x000fe200078e028dULL,
0x0000009414147212ULL, 0x000fe200078efcffULL, 0x000001001f1e7825ULL, 0x000fe200078e00ffULL,
0x0000620010107a10ULL, 0x000fc40007f3e0ffULL, 0x0000620014147a10ULL, 0x000fe20007f5e0ffULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x000000941e1e7212ULL, 0x080fe400078efcffULL,
0x000063001b1b7a10ULL, 0x000fe200007fe4ffULL, 0x000001001c1c7825ULL, 0x000fe200078e00ffULL,
0x0000009418187212ULL, 0x080fe400078efcffULL, 0x0000630011117a10ULL, 0x000fe20000ffe4ffULL,
0x0000001022757824ULL, 0x100fe200078e028dULL, 0x000000941c1c7212ULL, 0x080fe200078efcffULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x000062001e1e7a10ULL, 0x000fe20007f1e0ffULL,
0x00000000105d7faeULL, 0x0003e2000b901c48ULL, 0x0000630015157a10ULL, 0x000fe200017fe4ffULL,
0x0000001024a37824ULL, 0x100fe200078e028dULL, 0x0000620018187a10ULL, 0x000fe20007f3e0ffULL,
0x0000010023227825ULL, 0x000fe200078e00ffULL, 0x0000009420207212ULL, 0x080fe200078efcffULL,
0x00000000125f7faeULL, 0x0003e2000b901c48ULL, 0x000062001c1c7a10ULL, 0x000fe20007f5e0ffULL,
0x0000001026777824ULL, 0x100fe200078e028dULL, 0x0000009422227212ULL, 0x080fe200078efcffULL,
0x0000010025247825ULL, 0x000fe200078e00ffULL, 0x000063001f1f7a10ULL, 0x000fe200007fe4ffULL,
0x0000000014757faeULL, 0x0003e2000b901c48ULL, 0x0000630019197a10ULL, 0x000fe20000ffe4ffULL,
0x0000010027267825ULL, 0x000fe200078e00ffULL, 0x0000009424247212ULL, 0x080fe200078efcffULL,
0x0000000016777faeULL, 0x0003e2000b901c48ULL, 0x0000620020207a10ULL, 0x000fe20007f1e0ffULL,
0x000000102e7b7824ULL, 0x100fe200078e028dULL, 0x0000009426267212ULL, 0x000fe200078efcffULL,
0x000000103e937824ULL, 0x100fe200078e028dULL, 0x000063001d1d7a10ULL, 0x000fe200017fe4ffULL,
0x000000105e9f7824ULL, 0x100fe200078e028dULL, 0x0000620022227a10ULL, 0x000fe20007f3e0ffULL,
0x0000001076a17824ULL, 0x100fe200078e028dULL, 0x0000620024247a10ULL, 0x000fe20007f5e0ffULL,
0x000000102ca57824ULL, 0x100fe200078e028dULL, 0x0000620026267a10ULL, 0x000fe20007f7e0ffULL,
0x00000000187b7faeULL, 0x0003e2000b901c48ULL, 0x0000630021217a10ULL, 0x000fe200007fe4ffULL,
0x000000103ca77824ULL, 0x100fe200078e028dULL, 0x0000630023237a10ULL, 0x000fe20000ffe4ffULL,
0x000000001a937faeULL, 0x0003e2000b901c48ULL, 0x0000630025257a10ULL, 0x000fe200017fe4ffULL,
0x000000105c8d7824ULL, 0x000fe200078e028dULL, 0x0000630027277a10ULL, 0x000fe20001ffe4ffULL,
0x000000001c9f7faeULL, 0x0003e8000b901c48ULL, 0x000000001ea17faeULL, 0x0003e8000b901c48ULL,
0x0000000020a37faeULL, 0x0003e8000b901c48ULL, 0x0000000022a57faeULL, 0x0003e8000b901c48ULL,
0x0000000024a77faeULL, 0x0003e8000b901c48ULL, 0x00000000268d7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000010920b7824ULL, 0x002fe200078e00ffULL,
0x0000000891087810ULL, 0x000fe20007ffe0ffULL, 0x000000108e107824ULL, 0x000fe200078e00ffULL,
0x000000088b097810ULL, 0x000fe20007ffe0ffULL, 0x0000001092217824ULL, 0x000fe200078e00ffULL,
0x000040008f8f7810ULL, 0x000fe20007ffe0ffULL, 0x000000108e3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff00b087812ULL, 0x000fc400078ee208ULL, 0xfffffff010107812ULL, 0x000fe200078ee209ULL,
0x0000001089187824ULL, 0x100fe200078e028fULL, 0x0000000a91207810ULL, 0x000fe20007ffe0ffULL,
0x00000010080c7824ULL, 0x000fe400078e00ffULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0xfffffff021207812ULL, 0x000fe200078ee220ULL, 0x000000108c097824ULL, 0x100fe200078e028fULL,
0x0000000a8b217810ULL, 0x000fe20007ffe0ffULL, 0x000000108a1c7824ULL, 0x100fe400078e028fULL,
0x0000001088147824ULL, 0x000fe200078e028fULL, 0xfffffff03c3c7812ULL, 0x000fe200078ee221ULL,
0x0000001020247824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000c0c783bULL, 0x000fe20000000200ULL, 0x00000010855c7824ULL, 0x100fe400078e028fULL,
0x000000103c3c7824ULL, 0x000fe200078e00ffULL, 0x000000001818783bULL, 0x000e620000000200ULL,
0x0000001087227824ULL, 0x100fe400078e028fULL, 0x00000010862c7824ULL, 0x100fe200078e028fULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x0000001084747824ULL, 0x100fe400078e028fULL,
0x000000107e7e7824ULL, 0x100fe200078e028fULL, 0x000000000908783bULL, 0x000ee80000000200ULL,
0x000000001c1c783bULL, 0x000f280000000200ULL, 0x000000001414783bULL, 0x000ee80000000200ULL,
0x000000002424783bULL, 0x000fe80000000200ULL, 0x000000005c5c783bULL, 0x000f280000000200ULL,
0x000000003c3c783bULL, 0x000f280000000200ULL, 0x000000002220783bULL, 0x000f280000000200ULL,
0x000000002c2c783bULL, 0x000f220000000200ULL, 0x000000180c70723cULL, 0x082f660000001870ULL,
0x000000007474783bULL, 0x000e6a0000000200ULL, 0x000000181034723cULL, 0x004b6e0000001834ULL,
0x0000001081187824ULL, 0x020fe200078e028fULL, 0x000000080c44723cULL, 0x088f700000001844ULL,
0x000000081048723cULL, 0x000b6e0000001848ULL, 0x0000001092097824ULL, 0x060fe200078e00ffULL,
0x0000001a0c6c723cULL, 0x000f62000000186cULL, 0x0000000c91087810ULL, 0x040fe20007ffe0ffULL,
0x0000001092927824ULL, 0x000fe200078e00ffULL, 0x0000000e91917810ULL, 0x000fc40007ffe0ffULL,
0xfffffff009087812ULL, 0x000fe400078ee208ULL, 0xfffffff092917812ULL, 0x000fe200078ee291ULL,
0x0000001a1028723cULL, 0x000b640000001828ULL, 0x0000001008087824ULL, 0x000fe200078e00ffULL,
0x000000001818783bULL, 0x020fea0000000200ULL, 0x0000000a0c4c723cULL, 0x080f70000000184cULL,
0x0000000a1054723cULL, 0x040b640000001854ULL, 0x000000000808783bULL, 0x020fec0000000200ULL,
0x0000001c1050723cULL, 0x050ff00000001850ULL, 0x0000001e1038723cULL, 0x040ff00000001838ULL,
0x000000141030723cULL, 0x040ff00000001830ULL, 0x000000161040723cULL, 0x000bee0000001840ULL,
0x000000108e137824ULL, 0x020fe200078e00ffULL, 0x0000000c8b107810ULL, 0x040fe20007ffe0ffULL,
0x000000140c64723cULL, 0x000be20000001864ULL, 0x0000001082117824ULL, 0x000fe200078e028fULL,
0x0000000e8b8b7810ULL, 0x000fc40007ffe0ffULL, 0x000000048e8e7819ULL, 0x000fc600000006ffULL,
0xfffffff013147812ULL, 0x020fe200078ee210ULL, 0x0000001c0c60723cULL, 0x000b620000001860ULL,
0x000000001110783bULL, 0x000ea20000000200ULL, 0xfffffff08e8b7812ULL, 0x000fca00078ee28bULL,
0x00000010911c7824ULL, 0x020fe200078e00ffULL, 0x0000001e0c68723cULL, 0x040b6a0000001868ULL,
0x000000001c1c783bULL, 0x020fe60000000200ULL, 0x000000160c58723cULL, 0x000b6e0000001858ULL,
0x00000010830c7824ULL, 0x120fe200078e028fULL, 0x0000005c2470723cULL, 0x080fea0000001870ULL,
0x000000000c0c783bULL, 0x000fe60000000200ULL, 0x0000005c3c34723cULL, 0x000bee0000001834ULL,
0x00000010145c7824ULL, 0x020fe200078e00ffULL, 0x000000202444723cULL, 0x000fe20000001844ULL,
0x000000107f147824ULL, 0x000fcc00078e028fULL, 0x000000001414783bULL, 0x000fe20000000200ULL,
0x000000203c48723cULL, 0x000bee0000001848ULL, 0x0000001080207824ULL, 0x120fe200078e028fULL,
0x0000005e246c723cULL, 0x080ff0000000186cULL, 0x0000005e3c28723cULL, 0x000be40000001828ULL,
0x000000005c5c783bULL, 0x020eec0000000200ULL, 0x00000022244c723cULL, 0x080ff0000000184cULL,
0x000000223c54723cULL, 0x000be40000001854ULL, 0x000000002020783bULL, 0x020f2c0000000200ULL,
0x0000002c2460723cULL, 0x040f700000001860ULL, 0x0000002e2468723cULL, 0x000f700000001868ULL,
0x0000002c3c50723cULL, 0x000b6e0000001850ULL, 0x00000010042c7824ULL, 0x120fe200078e028fULL,
0x000000742464723cULL, 0x042ff00000001864ULL, 0x000000762458723cULL, 0x000bee0000001858ULL,
0x000000108b247824ULL, 0x020fe200078e00ffULL, 0x0000002e3c38723cULL, 0x040b640000001838ULL,
0x000000002c2c783bULL, 0x020fe80000000200ULL, 0x000000002424783bULL, 0x000fe40000000200ULL,
0x000000743c80723cULL, 0x040b6e0000001830ULL, 0x000000107d307824ULL, 0x020fe200078e028fULL,
0x000000763c40723cULL, 0x000b640000001840ULL, 0x000000007e3c783bULL, 0x020e680000000200ULL,
0x000000003030783bULL, 0x000e640000000200ULL, 0x000000100860723cULL, 0x044f700000001860ULL,
0x000000120868723cULL, 0x000f700000001868ULL, 0x000000105c50723cULL, 0x008f700000001850ULL,
0x0000000c0844723cULL, 0x040f700000001844ULL, 0x0000000e084c723cULL, 0x040ff0000000184cULL,
0x000000180870723cULL, 0x040ff00000001870ULL, 0x0000001a086c723cULL, 0x000ff0000000186cULL,
0x0000000c5c48723cULL, 0x040ff00000001848ULL, 0x000000125c38723cULL, 0x040ff00000001838ULL,
0x000000185c34723cULL, 0x000ff00000001834ULL, 0x000000200864723cULL, 0x010ff00000001864ULL,
0x0000000e5c54723cULL, 0x040ff00000001854ULL, 0x0000001a5c74723cULL, 0x040ff00000001828ULL,
0x000000205c80723cULL, 0x000ff00000001880ULL, 0x000000220858723cULL, 0x080ff00000001858ULL,
0x000000225c40723cULL, 0x000ff00000001840ULL, 0x0000003c1c60723cULL, 0x062f700000001860ULL,
0x0000003e1c20723cULL, 0x000f700000001868ULL, 0x0000003c2428723cULL, 0x000ff00000001850ULL,
0x000000141c44723cULL, 0x000f640000001844ULL, 0x3db504f360607820ULL, 0x020fc40000410000ULL,
0x3db504f361617820ULL, 0x000fe40000410000ULL, 0x3db504f362627820ULL, 0x000fe40000410000ULL,
0x3db504f363637820ULL, 0x000fe20000410000ULL, 0x000000161c4c723cULL, 0x000f62000000184cULL,
0x3db504f320207820ULL, 0x000fe40000410000ULL, 0x3db504f321217820ULL, 0x000fca0000410000ULL,
0x000000301c18723cULL, 0x040f700000001870ULL, 0x000000321c0c723cULL, 0x000fe2000000186cULL,
0x3db504f345047820ULL, 0x000fe40000410000ULL, 0x3db504f344447820ULL, 0x000fc40000410000ULL,
0x3db504f346467820ULL, 0x000fe40000410000ULL, 0x3db504f347477820ULL, 0x000fe20000410000ULL,
0x000000142410723cULL, 0x040b640000001848ULL, 0x3db504f34c4c7820ULL, 0x020fe40000410000ULL,
0x3db504f34d4d7820ULL, 0x000fe40000410000ULL, 0x3db504f34e4e7820ULL, 0x000fe40000410000ULL,
0x3db504f34f4f7820ULL, 0x000fe20000410000ULL, 0x0000003e243c723cULL, 0x000f620000001838ULL,
0x3db504f318187820ULL, 0x000fc40000410000ULL, 0x3db504f3294a7820ULL, 0x000fca0000410000ULL,
0x000000302434723cULL, 0x000f700000001834ULL, 0x0000002c1c08723cULL, 0x000f620000001864ULL,
0x3db504f311457820ULL, 0x000fe40000410000ULL, 0x3db504f312517820ULL, 0x000fc40000410000ULL,
0x3db504f313527820ULL, 0x000fc60000410000ULL, 0x000000162414723cULL, 0x000b640000001854ULL,
0x3db504f33c3c7820ULL, 0x020fe40000410000ULL, 0x3db504f33d3d7820ULL, 0x000fc60000410000ULL,
0x3db504f33e577820ULL, 0x000fe20000410000ULL, 0x000000322430723cULL, 0x000fe20000001874ULL,
0x3db504f32a557820ULL, 0x000fe40000410000ULL, 0x3db504f32b567820ULL, 0x000fe40000410000ULL,
0x3db504f3343e7820ULL, 0x000fc60000410000ULL, 0x0000002c2438723cULL, 0x000b620000001880ULL,
0x3db504f308087820ULL, 0x000fe40000410000ULL, 0x3db504f309097820ULL, 0x000fe40000410000ULL,
0x3db504f30a0a7820ULL, 0x000fe40000410000ULL, 0x3db504f3222c7820ULL, 0x020fe20000410000ULL,
0x0000002e1c1c723cULL, 0x000b620000001858ULL, 0x3db504f317547820ULL, 0x000fe40000410000ULL,
0x3db504f3232d7820ULL, 0x000fc40000410000ULL, 0x3db504f319227820ULL, 0x000fe40000410000ULL,
0x3db504f33f587820ULL, 0x020fe20000410000ULL, 0x0000002e2424723cULL, 0x000b620000001840ULL,
0x3db504f3375a7820ULL, 0x000fe40000410000ULL, 0x3db504f30b0b7820ULL, 0x000fe40000410000ULL,
0x3db504f314487820ULL, 0x000fe40000410000ULL, 0x3db504f31a2e7820ULL, 0x020fc40000410000ULL,
0x3db504f31b2f7820ULL, 0x000fe40000410000ULL, 0x3db504f33a5d7820ULL, 0x000fe40000410000ULL,
0x3db504f33b5e7820ULL, 0x000fe40000410000ULL, 0x3db504f30c1a7820ULL, 0x000fe40000410000ULL,
0x3db504f30d1b7820ULL, 0x000fe40000410000ULL, 0x3db504f30e407820ULL, 0x000fc40000410000ULL,
0x3db504f30f417820ULL, 0x000fe40000410000ULL, 0x3db504f31c1c7820ULL, 0x000fe40000410000ULL,
0x3db504f31d1d7820ULL, 0x000fe40000410000ULL, 0x3db504f31e427820ULL, 0x000fe40000410000ULL,
0x3db504f31f1f7820ULL, 0x000fe40000410000ULL, 0x3db504f310437820ULL, 0x000fc40000410000ULL,
0x3db504f315497820ULL, 0x000fe40000410000ULL, 0x3db504f316537820ULL, 0x000fe40000410000ULL,
0x3db504f328177820ULL, 0x000fe40000410000ULL, 0x3db504f3353f7820ULL, 0x000fe40000410000ULL,
0x3db504f336597820ULL, 0x000fe40000410000ULL, 0x3db504f330377820ULL, 0x000fc40000410000ULL,
0x3db504f3314b7820ULL, 0x000fe40000410000ULL, 0x3db504f3325b7820ULL, 0x000fe40000410000ULL,
0x3db504f3335c7820ULL, 0x000fe40000410000ULL, 0x3db504f338387820ULL, 0x000fe40000410000ULL,
0x3db504f339507820ULL, 0x000fe40000410000ULL, 0x3db504f3243a7820ULL, 0x000fc40000410000ULL,
0x3db504f3253b7820ULL, 0x000fe40000410000ULL, 0x3db504f3265f7820ULL, 0x000fe40000410000ULL,
0x3db504f327647820ULL, 0x000fe20000410000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000ffff117224ULL, 0x000fe400078e0020ULL, 0x000000ffff1e7224ULL, 0x000fe400078e004eULL,
0x000000ffff207224ULL, 0x000fe400078e004fULL, 0x000000009b4e7f8cULL, 0x0002a2000c80043fULL,
0x000000ffff197224ULL, 0x000fc400078e0018ULL, 0x000000ffff157224ULL, 0x000fe400078e001bULL,
0x000000ffff187224ULL, 0x000fe400078e001aULL, 0x000000ffff1b7224ULL, 0x000fe400078e001dULL,
0x000000ffff247224ULL, 0x000fe400078e002dULL, 0x000000ffff257224ULL, 0x000fe400078e002eULL,
0x000000ffff267224ULL, 0x000fc400078e002fULL, 0x000000ffff287224ULL, 0x000fe400078e0041ULL,
0x000000ffff337224ULL, 0x000fe400078e003cULL, 0x000000ffff367224ULL, 0x000fe400078e003fULL,
0x000000ffff0d7224ULL, 0x000fe400078e0044ULL, 0x000000ffff0c7224ULL, 0x000fe400078e004cULL,
0x000000ffff127224ULL, 0x000fc400078e0021ULL, 0x000000ffff147224ULL, 0x000fe400078e0022ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0046ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0047ULL,
0x000000ffff237224ULL, 0x000fe400078e002cULL, 0x000000ffff277224ULL, 0x000fe400078e0040ULL,
0x000000ffff2b7224ULL, 0x000fc400078e0042ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0043ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0045ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0048ULL,
0x000000ffff307224ULL, 0x000fe400078e0049ULL, 0x000000ffff327224ULL, 0x000fe400078e004aULL,
0x000000ffff347224ULL, 0x000fc400078e003dULL, 0x000000ffff357224ULL, 0x000fe400078e003eULL,
0x000000ffff397224ULL, 0x000fe400078e004bULL, 0x000000ffff3c7224ULL, 0x000fe400078e0038ULL,
0x000000ffff3f7224ULL, 0x000fe400078e003aULL, 0x000000ffff417224ULL, 0x000fe400078e003bULL,
0x000000ffff0e7224ULL, 0x000fc400078e004dULL, 0x000000ffff0f7224ULL, 0x000fe400078e0060ULL,
0x000000ffff107224ULL, 0x000fe400078e0061ULL, 0x000000ffff167224ULL, 0x000fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e0009ULL, 0x000000ffff217224ULL, 0x000fe400078e0062ULL,
0x000000ffff227224ULL, 0x000fc400078e0063ULL, 0x000000ffff297224ULL, 0x000fe400078e000aULL,
0x000000ffff2a7224ULL, 0x000fe400078e000bULL, 0x000000ffff2c7224ULL, 0x000fe400078e001fULL,
0x000000ffff317224ULL, 0x000fe400078e0017ULL, 0x000000ffff3d7224ULL, 0x000fe400078e0050ULL,
0x000000ffff427224ULL, 0x000fc400078e0051ULL, 0x000000ffff457224ULL, 0x000fe400078e0052ULL,
0x000000ffff467224ULL, 0x000fe400078e0053ULL, 0x000000ffff487224ULL, 0x000fe400078e0054ULL,
0x000000ffff4a7224ULL, 0x000fe400078e0055ULL, 0x000000ffff4b7224ULL, 0x000fe400078e0056ULL,
0x000000ffff4c7224ULL, 0x000fc400078e0057ULL, 0x000000ffff497224ULL, 0x000fe400078e0058ULL,
0x000000ffff477224ULL, 0x000fe400078e0059ULL, 0x000000ffff387224ULL, 0x000fe400078e005aULL,
0x000000ffff3a7224ULL, 0x000fe400078e005bULL, 0x000000ffff3b7224ULL, 0x000fe400078e005cULL,
0x000000ffff3e7224ULL, 0x000fc400078e005dULL, 0x000000ffff407224ULL, 0x000fe400078e005eULL,
0x000000ffff437224ULL, 0x000fe400078e005fULL, 0x000000ffff447224ULL, 0x000fc400078e0064ULL,
0x0000000000087805ULL, 0x006fca0000015200ULL, 0x000004009b0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe4000780484fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a08177210ULL, 0x000fc80007f1e1ffULL, 0x0000000b090b7210ULL, 0x000fe400007fe5ffULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x000000170a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004009b0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe4000780484fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000049d1f7824ULL, 0x000fe200078e00ffULL,
0x000000980300720cULL, 0x000fc80003f06070ULL, 0xfffffff01f177812ULL, 0x000fca00078ec0ffULL,
0x0000008000177824ULL, 0x000fca00078e0217ULL, 0x01e4000017087984ULL, 0x0002a20000000c00ULL,
0x00001f5000008947ULL, 0x000fea0003800000ULL, 0x000000029d037824ULL, 0x000fe200078e00ffULL,
0x00000096054f7217ULL, 0x000fe20007800000ULL, 0x00000002ff5e7424ULL, 0x000fe200078e00ffULL,
0x000000079d4d7211ULL, 0x000fe400078ff0ffULL, 0x0000000603037812ULL, 0x000fe200078ec0ffULL,
0x000000014f967824ULL, 0x000fe200078e0a96ULL, 0x00005a00ff4e7a19ULL, 0x000fe4000001164dULL,
0x000000084d507810ULL, 0x000fe20007ffe0ffULL, 0x00000001974f7824ULL, 0x000fe200078e0203ULL,
0x000000104d517810ULL, 0x000fc40007ffe0ffULL, 0x000000184d537810ULL, 0x000fe20007ffe0ffULL,
0x000000014f527824ULL, 0x000fe200078e0a96ULL, 0x00005800034d7a10ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff547a19ULL, 0x000fe40000011650ULL, 0x0000005299527217ULL, 0x000fe20003800000ULL,
0x000000014d507824ULL, 0x000fe200078e0a96ULL, 0x0000005499547217ULL, 0x000fe40003800000ULL,
0x000000964d00720cULL, 0x000fc40003f06070ULL, 0x0000005099507217ULL, 0x000fe20003800000ULL,
0x0000005495767224ULL, 0x000fe200078e02ffULL, 0x0000004e994e7217ULL, 0x000fe40003800000ULL,
0x000000964f00720cULL, 0x000fe40003f26070ULL, 0x00000004ff527819ULL, 0x000fe20000011652ULL,
0x0000004e95747224ULL, 0x000fe200078e02ffULL, 0x000000ff505d7207ULL, 0x000fe40000000000ULL,
0x000000ff52577207ULL, 0x000fc40000800000ULL, 0x000000765d557211ULL, 0x000fe400078fe0ffULL,
0x00005a00ff4e7a19ULL, 0x000fe20000011651ULL, 0x0000000174517824ULL, 0x000fe200078e0257ULL,
0x00005a00ff507a19ULL, 0x000fe20000011653ULL, 0x0000600055547625ULL, 0x000fe200078e005eULL,
0x000000745d537211ULL, 0x000fe400078fe0ffULL, 0x0000004e994e7217ULL, 0x040fe40003800000ULL,
0x0000005099567217ULL, 0x000fe20003800000ULL, 0x0000600051507625ULL, 0x080fe200078e005eULL,
0x00000008544f7981ULL, 0x000726000c1e9500ULL, 0x0000600053527625ULL, 0x000fc400078e005eULL,
0x0000000850517981ULL, 0x0042a4000c1e9500ULL, 0x0000004e95787224ULL, 0x040fe400078e02ffULL,
0x00000056957a7224ULL, 0x000fe200078e02ffULL, 0x0000001003557812ULL, 0x008fe200078efcffULL,
0x00000001575b7824ULL, 0x040fe200078e0276ULL, 0x00000008524e7981ULL, 0x0006a2000c1e9500ULL,
0x0000000157637824ULL, 0x040fe400078e0278ULL, 0x0000000157597824ULL, 0x000fe200078e027aULL,
0x0000580055577a10ULL, 0x000fc40007ffe0ffULL, 0x000000785d617211ULL, 0x000fe200078fe0ffULL,
0x00000001975f7824ULL, 0x000fe400078e0255ULL, 0x0000000157567824ULL, 0x000fe400078e0a96ULL,
0x0000600061607625ULL, 0x000fe200078e005eULL, 0x000000965700720cULL, 0x000fc60003f06070ULL,
0x000060005b5a7625ULL, 0x000fe200078e005eULL, 0x0000005699567217ULL, 0x000fe20003800000ULL,
0x0000000860507981ULL, 0x002324000c1e9500ULL, 0x0000600063627625ULL, 0x000fe200078e005eULL,
0x000000ff567d7207ULL, 0x000fe20000000000ULL, 0x000000085a547981ULL, 0x000324000c1e9500ULL,
0x000000015f5c7824ULL, 0x000fe400078e0a96ULL, 0x0000000862537981ULL, 0x008722000c1e9500ULL,
0x0000007a5d657211ULL, 0x000fc400078fe0ffULL, 0x0000005c995c7217ULL, 0x000fe40003800000ULL,
0x000000747d617211ULL, 0x002fe200078fe0ffULL, 0x0000600059587625ULL, 0x000fe200078e005eULL,
0x000000965f00720cULL, 0x000fe40003f26070ULL, 0x00000004ff5c7819ULL, 0x000fe2000001165cULL,
0x0000600065647625ULL, 0x000fe200078e005eULL, 0x000000767d637211ULL, 0x008fe200078fe0ffULL,
0x0000000858597981ULL, 0x0002e2000c1e9500ULL, 0x000000ff5c5f7207ULL, 0x000fe20000800000ULL,
0x0000600061607625ULL, 0x000fc400078e005eULL, 0x0000000864527981ULL, 0x0002e4000c1e9500ULL,
0x00000001745b7824ULL, 0x000fe400078e025fULL, 0x0000000860567981ULL, 0x0002e2000c1e9500ULL,
0x000000015f677824ULL, 0x000fe400078e0276ULL, 0x0000600063627625ULL, 0x000fe200078e005eULL,
0x0000002003617812ULL, 0x002fc600078efcffULL, 0x000060005b5a7625ULL, 0x080fe200078e005eULL,
0x0000000862587981ULL, 0x0002e6000c1e9500ULL, 0x0000600067667625ULL, 0x000fe400078e005eULL,
0x000000085a5b7981ULL, 0x0002e4000c1e9500ULL, 0x00000001976f7824ULL, 0x000fe400078e0261ULL,
0x000000015f657824ULL, 0x000fe200078e0278ULL, 0x0000580061637a10ULL, 0x002fe20007ffe0ffULL,
0x000000015f6b7824ULL, 0x000fc400078e027aULL, 0x000000016f627824ULL, 0x100fe200078e0a96ULL,
0x00000008665f7981ULL, 0x0002e2000c1e9500ULL, 0x000000787d697211ULL, 0x000fe200078fe0ffULL,
0x0000000163607824ULL, 0x000fe200078e0a96ULL, 0x0000007a7d6d7211ULL, 0x000fe400078fe0ffULL,
0x0000006299627217ULL, 0x000fe20003800000ULL, 0x0000600065647625ULL, 0x000fe200078e005eULL,
0x000000966300720cULL, 0x000fe40003f06070ULL, 0x0000006099607217ULL, 0x000fe20003800000ULL,
0x000060006b6a7625ULL, 0x000fe200078e005eULL, 0x000000966f00720cULL, 0x000fe20003f26070ULL,
0x0000000864657981ULL, 0x0002e2000c1e9500ULL, 0x00000004ff627819ULL, 0x000fe20000011662ULL,
0x0000600069687625ULL, 0x000fc800078e005eULL, 0x000060006d6c7625ULL, 0x000fe200078e005eULL,
0x000000ff607f7207ULL, 0x000fe20000000000ULL, 0x00000008685a7981ULL, 0x0002e2000c1e9500ULL,
0x000000ff626f7207ULL, 0x000fc60000800000ULL, 0x000000086c5c7981ULL, 0x0002e8000c1e9500ULL,
0x000000086a6b7981ULL, 0x0004e2000c1e9500ULL, 0x000000016f777824ULL, 0x000fe200078e0276ULL,
0x000000767f6d7211ULL, 0x002fe200078fe0ffULL, 0x0000000174697824ULL, 0x000fe400078e026fULL,
0x000000016f7b7824ULL, 0x040fe400078e0278ULL, 0x000000016f817824ULL, 0x000fc400078e027aULL,
0x000060006d6c7625ULL, 0x000fe200078e005eULL, 0x000000747f677211ULL, 0x000fc600078fe0ffULL,
0x00006000776e7625ULL, 0x000fe200078e005eULL, 0x000000086c627981ULL, 0x0002e2000c1e9500ULL,
0x000000787f717211ULL, 0x000fc600078fe0ffULL, 0x000000086ecb7981ULL, 0x0002e2000c1e9500ULL,
0x0000600067667625ULL, 0x000fe200078e005eULL, 0x0000007a7f737211ULL, 0x000fe400078fe0ffULL,
0x0000003003b17812ULL, 0x000fe200078efcffULL, 0x0000600069687625ULL, 0x080fe200078e005eULL,
0x0000000866607981ULL, 0x0002e6000c1e9500ULL, 0x0000600071707625ULL, 0x080fe200078e005eULL,
0x0000000868757981ULL, 0x0002e6000c1e9500ULL, 0x0000600073727625ULL, 0x080fe200078e005eULL,
0x00005800b1b37a10ULL, 0x000fe20007ffe0ffULL, 0x0000000870cf7981ULL, 0x0002e4000c1e9500ULL,
0x000060007b667625ULL, 0x002fc400078e005eULL, 0x0000000872d37981ULL, 0x0002e4000c1e9500ULL,
0x00006000816c7625ULL, 0x000fe400078e005eULL, 0x0000000866807981ULL, 0x0002e4000c1e9500ULL,
0x0000000197697824ULL, 0x000fe400078e02b1ULL, 0x000000086c847981ULL, 0x0002e4000c1e9500ULL,
0x0000000169687824ULL, 0x000fc400078e0a96ULL, 0x00000001b3647824ULL, 0x000fc600078e0a96ULL,
0x0000006899687217ULL, 0x000fe40003800000ULL, 0x000000966900720cULL, 0x080fe40003f26070ULL,
0x00000096b300720cULL, 0x000fe40003f06070ULL, 0x0000006499647217ULL, 0x000fe40003800000ULL,
0x00000004ff687819ULL, 0x000fe40000011668ULL, 0x000000ff64857207ULL, 0x000fc40000000000ULL,
0x000000ff68777207ULL, 0x000fe40000800000ULL, 0x0000007485717211ULL, 0x040fe400078fe0ffULL,
0x0000007885677211ULL, 0x002fe200078fe0ffULL, 0x0000000174737824ULL, 0x000fe400078e0277ULL,
0x0000000177697824ULL, 0x000fe400078e0278ULL, 0x0000600071707625ULL, 0x000fc800078e005eULL,
0x0000600073727625ULL, 0x080fe200078e005eULL, 0x0000000870b57981ULL, 0x0002e6000c1e9500ULL,
0x0000600067667625ULL, 0x080fe200078e005eULL, 0x0000000872747981ULL, 0x0002e6000c1e9500ULL,
0x0000600069687625ULL, 0x000fe200078e005eULL, 0x0000000866d17981ULL, 0x0002e2000c1e9500ULL,
0x00000076856d7211ULL, 0x000fc600078fe0ffULL, 0x0000000868827981ULL, 0x0002e2000c1e9500ULL,
0x00000001776f7824ULL, 0x000fe400078e0276ULL, 0x000060006d6c7625ULL, 0x000fc800078e005eULL,
0x000060006f6e7625ULL, 0x000fe200078e005eULL, 0x000000086ccd7981ULL, 0x0002e4000c1e9500ULL,
0x0000007a85717211ULL, 0x002fe400078fe0ffULL, 0x000000086e7e7981ULL, 0x0002e2000c1e9500ULL,
0x0000000177737824ULL, 0x000fe400078e027aULL, 0x0000600071707625ULL, 0x000fc800078e005eULL,
0x0000600073727625ULL, 0x000fe200078e005eULL, 0x0000000870d57981ULL, 0x0002e8000c1e9500ULL,
0x0000000872867981ULL, 0x0002e2000c1e9500ULL, 0xfffffff05d5d7812ULL, 0x000fe200078ec0ffULL,
0x00000001ffc97424ULL, 0x000fc800078e00ffULL, 0x00000001965e7824ULL, 0x000fc800078e025dULL,
0x000000014d5d7824ULL, 0x000fe200078e0a5eULL, 0x00000001036d7812ULL, 0x000fc800078efcffULL,
0x0000005dc95d7219ULL, 0x000fe400000006ffULL, 0x000058006d677a10ULL, 0x000fe40007ffe0ffULL,
0x0000000803777812ULL, 0x000fc600078efcffULL, 0x0000000167647824ULL, 0x100fe200078e0a5eULL,
0x00000009037b7812ULL, 0x000fe400078efcffULL, 0x00005800776f7a10ULL, 0x002fe40007ffe0ffULL,
0x00000064c9697219ULL, 0x000fe400000006ffULL, 0x000058007b737a10ULL, 0x000fe20007ffe0ffULL,
0x000000016f667824ULL, 0x000fe200078e0a5eULL, 0xfffffff07d7d7812ULL, 0x000fc600078ec0ffULL,
0x00000001735e7824ULL, 0x000fe200078e0a5eULL, 0x0000001103817812ULL, 0x000fe200078efcffULL,
0x0000000196687824ULL, 0x000fe200078e027dULL, 0x00000066c9717219ULL, 0x040fe400000006ffULL,
0x0000005ec97d7219ULL, 0x000fe400000006ffULL, 0x0000580081837a10ULL, 0x000fe20007ffe0ffULL,
0x00000001575e7824ULL, 0x100fe200078e0a68ULL, 0xfffffff07f7f7812ULL, 0x000fe400078ec0ffULL,
0xfffffff085857812ULL, 0x000fe200078ec0ffULL, 0x0000000183647824ULL, 0x000fe200078e0a68ULL,
0x000054104e4e7816ULL, 0x004fc80000000051ULL, 0x0000004e5dff7212ULL, 0x000fc800078ac0ffULL,
0x000000964d00720cULL, 0x000fc80002fa1470ULL, 0x000000960300720cULL, 0x000fe40002fa1070ULL,
0x0000004e69ff7212ULL, 0x000fe4000782c0ffULL, 0xff8000000d0d7808ULL, 0x000fe40002800000ULL,
0x000054104f547816ULL, 0x010fe40000000054ULL, 0x0000541050507816ULL, 0x000fe40000000053ULL,
0x000000545dff7212ULL, 0x000fc4000784c0ffULL, 0x000000505dff7212ULL, 0x000fe4000788c0ffULL,
0x0000005469ff7212ULL, 0x000fe400078ac0ffULL, 0x000000964d00720cULL, 0x0c0fe40001741470ULL,
0x000000964d00720cULL, 0x080fe40002781470ULL, 0x000000966700720cULL, 0x0c0fe40000f21470ULL,
0x000000966700720cULL, 0x000fc40002fa1470ULL, 0x000000960300720cULL, 0x0c0fe40001741070ULL,
0x000000960300720cULL, 0x080fe40002781070ULL, 0x000000966d00720cULL, 0x0c0fe40000f21070ULL,
0x000000966d00720cULL, 0x000fe40002fa1070ULL, 0x0000541052527816ULL, 0x008fe40000000059ULL,
0xff8000001a1a7808ULL, 0x000fc40001000000ULL, 0xff8000002d2d7808ULL, 0x000fe40002000000ULL,
0xff80000004047808ULL, 0x000fe40000800000ULL, 0xff8000001d1d7808ULL, 0x000fe40002800000ULL,
0x0000004e71ff7212ULL, 0x000fe4000786c0ffULL, 0x000000525dff7212ULL, 0x000fe4000780c0ffULL,
0x0000005069ff7212ULL, 0x000fc4000784c0ffULL, 0x0000005269ff7212ULL, 0x000fe4000788c0ffULL,
0x000000547dff7212ULL, 0x000fe4000782c0ffULL, 0x0000005071ff7212ULL, 0x000fe400078ac0ffULL,
0x000000964d00720cULL, 0x080fe40000701470ULL, 0x000000966700720cULL, 0x0c0fe40001741470ULL,
0x000000966700720cULL, 0x000fc40002781470ULL, 0x000000966f00720cULL, 0x0c0fe40001f61470ULL,
0x000000966f00720cULL, 0x080fe40002fa1470ULL, 0x000000967300720cULL, 0x080fe20000f21470ULL,
0x00000001966a7824ULL, 0x040fe200078e027fULL, 0x0000001803877812ULL, 0x040fe200078efcffULL,
0x0000000196727824ULL, 0x000fe200078e0285ULL, 0x00000019038d7812ULL, 0x040fe400078efcffULL,
0x000000960300720cULL, 0x000fc40000701070ULL, 0x000000966d00720cULL, 0x0c0fe40001741070ULL,
0x000000966d00720cULL, 0x080fe40002781070ULL, 0x000000967700720cULL, 0x0c0fe40001f61070ULL,
0x000000967700720cULL, 0x080fe40002fa1070ULL, 0x000000967b00720cULL, 0x000fe40000f21070ULL,
0x0000005ec97f7219ULL, 0x000fc400000006ffULL, 0x00000064c9857219ULL, 0x000fe400000006ffULL,
0x0000541056567816ULL, 0x000fe4000000005bULL, 0x0000541058587816ULL, 0x000fe4000000005fULL,
0x0000580087897a10ULL, 0x000fe40007ffe0ffULL, 0x000058008d8f7a10ULL, 0x000fe40007ffe0ffULL,
0xff80000042427808ULL, 0x000fc40000000000ULL, 0xff8000002e2e7808ULL, 0x000fe40001000000ULL,
0xff80000045457808ULL, 0x000fe40002000000ULL, 0xff8000000c0c7808ULL, 0x000fe40001800000ULL,
0xff8000002f2f7808ULL, 0x000fe40002800000ULL, 0xff80000020207808ULL, 0x000fe40000800000ULL,
0x0000005471ff7212ULL, 0x000fc4000780c0ffULL, 0x000000507dff7212ULL, 0x000fe4000784c0ffULL,
0x0000005271ff7212ULL, 0x080fe4000788c0ffULL, 0x000000527dff7212ULL, 0x000fe4000786c0ffULL,
0x0000005685ff7212ULL, 0x000fe400078ac0ffULL, 0x000000587fff7212ULL, 0x000fe2000782c0ffULL,
0x0000000189667824ULL, 0x100fe200078e0a68ULL, 0x000000966f00720cULL, 0x080fe20000701470ULL,
0x000000018f687824ULL, 0x000fe200078e0a68ULL, 0x000000966f00720cULL, 0x000fc40002781470ULL,
0x000000967300720cULL, 0x0c0fe40001741470ULL, 0x000000967300720cULL, 0x080fe40001f61470ULL,
0x000000965700720cULL, 0x080fe40000f21470ULL, 0x000000968300720cULL, 0x080fe40002fa1470ULL,
0x000000967700720cULL, 0x0c0fe40000701070ULL, 0x000000967700720cULL, 0x000fc40002781070ULL,
0x000000967b00720cULL, 0x0c0fe40001741070ULL, 0x000000967b00720cULL, 0x080fe40001f61070ULL,
0x000000965500720cULL, 0x080fe40000f21070ULL, 0x000000968100720cULL, 0x000fe40002fa1070ULL,
0x00000066c98b7219ULL, 0x040fe400000006ffULL, 0x00000068c9917219ULL, 0x000fc400000006ffULL,
0x000054105a5a7816ULL, 0x000fe40000000065ULL, 0x000054105c5c7816ULL, 0x000fe4000000006bULL,
0xff8000001e1e7808ULL, 0x000fe40000000000ULL, 0xff80000046467808ULL, 0x000fe40002000000ULL,
0xff80000030307808ULL, 0x000fe40001000000ULL, 0xff80000048487808ULL, 0x000fc40001800000ULL,
0xff80000021217808ULL, 0x000fe40000800000ULL, 0xff80000010107808ULL, 0x000fe40002800000ULL,
0x000000567fff7212ULL, 0x080fe4000780c0ffULL, 0x000000568bff7212ULL, 0x000fe4000788c0ffULL,
0x0000005a7fff7212ULL, 0x040fe4000784c0ffULL, 0x0000005c7fff7212ULL, 0x000fc4000786c0ffULL,
0x0000005a85ff7212ULL, 0x000fe4000782c0ffULL, 0x0000005891ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001636c7824ULL, 0x000fe200078e0a6aULL, 0x000000965700720cULL, 0x0c0fe40000701470ULL,
0x000000965700720cULL, 0x0c0fe40001741470ULL, 0x000000965700720cULL, 0x080fe40001f61470ULL,
0x000000968300720cULL, 0x000fc40000f21470ULL, 0x000000968900720cULL, 0x080fe40002781470ULL,
0x000000968f00720cULL, 0x080fe40002fa1470ULL, 0x00000021039f7812ULL, 0x000fe400078efcffULL,
0x000000965500720cULL, 0x0c0fe40000701070ULL, 0x000000965500720cULL, 0x0c0fe40001741070ULL,
0x000000965500720cULL, 0x000fc40001f61070ULL, 0x000000968100720cULL, 0x080fe40000f21070ULL,
0x000000968700720cULL, 0x080fe40002781070ULL, 0x000000968d00720cULL, 0x000fe40002fa1070ULL,
0x0000006cc9937219ULL, 0x000fe400000006ffULL, 0x0000541062627816ULL, 0x000fe400000000cbULL,
0x000058009fa17a10ULL, 0x000fc40007ffe0ffULL, 0xff8000000f0f7808ULL, 0x000fe40000000000ULL,
0xff80000031317808ULL, 0x000fe40001000000ULL, 0xff8000004a4a7808ULL, 0x000fe40001800000ULL,
0xff80000032327808ULL, 0x000fe40000800000ULL, 0xff80000011117808ULL, 0x000fe40002000000ULL,
0xff80000024247808ULL, 0x000fc40002800000ULL, 0x0000005885ff7212ULL, 0x040fe4000780c0ffULL,
0x0000005c85ff7212ULL, 0x000fe4000784c0ffULL, 0x000000588bff7212ULL, 0x000fe4000786c0ffULL,
0x0000005a91ff7212ULL, 0x040fe4000782c0ffULL, 0x0000005c91ff7212ULL, 0x000fe4000788c0ffULL,
0x0000006293ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001a16e7824ULL, 0x000fe200078e0a6aULL,
0x000000968300720cULL, 0x000fc40000701470ULL, 0x000000968300720cULL, 0x080fe40001741470ULL,
0x000000968900720cULL, 0x080fe40001f61470ULL, 0x000000968f00720cULL, 0x0c0fe40000f21470ULL,
0x000000968f00720cULL, 0x080fe40002781470ULL, 0x000000966300720cULL, 0x000fe40002fa1470ULL,
0x0000002803a57812ULL, 0x000fc400078efcffULL, 0x0000002903ab7812ULL, 0x000fe400078efcffULL,
0x000000968100720cULL, 0x0c0fe40000701070ULL, 0x000000968100720cULL, 0x080fe40001741070ULL,
0x000000968700720cULL, 0x080fe40001f61070ULL, 0x000000968d00720cULL, 0x0c0fe40000f21070ULL,
0x000000968d00720cULL, 0x000fc40002781070ULL, 0x000000966100720cULL, 0x000fe40002fa1070ULL,
0x0000006ec9a37219ULL, 0x000fe400000006ffULL, 0x0000541060607816ULL, 0x000fe40000000075ULL,
0x00005410cf807816ULL, 0x000fe40000000080ULL, 0x00005410d3847816ULL, 0x000fe40000000084ULL,
0x00005800a5a77a10ULL, 0x000fc40007ffe0ffULL, 0x00005800abad7a10ULL, 0x000fe40007ffe0ffULL,
0xff80000022227808ULL, 0x000fe40000000000ULL, 0xff8000004b4b7808ULL, 0x000fe40001000000ULL,
0xff80000023237808ULL, 0x000fe40001800000ULL, 0xff80000034347808ULL, 0x000fe40000800000ULL,
0xff80000049497808ULL, 0x000fc40002000000ULL, 0xff80000025257808ULL, 0x000fe40002800000ULL,
0x0000004e7dff7212ULL, 0x000fe400078cc0ffULL, 0x0000005a8bff7212ULL, 0x040fe4000780c0ffULL,
0x0000005c8bff7212ULL, 0x000fe4000784c0ffULL, 0x0000006093ff7212ULL, 0x040fe4000786c0ffULL,
0x0000008093ff7212ULL, 0x000fc4000782c0ffULL, 0x0000008493ff7212ULL, 0x000fe4000788c0ffULL,
0x00000080a3ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001a7707824ULL, 0x100fe200078e0a6aULL,
0x000000967300720cULL, 0x080fe200037c1470ULL, 0x00000001ad6a7824ULL, 0x000fe200078e0a6aULL,
0x000000968900720cULL, 0x0c0fe40000701470ULL, 0x000000968900720cULL, 0x080fe40001741470ULL,
0x000000966300720cULL, 0x000fc40001f61470ULL, 0x000000966300720cULL, 0x0c0fe40000f21470ULL,
0x000000966300720cULL, 0x080fe40002781470ULL, 0x00000096a100720cULL, 0x080fe40002fa1470ULL,
0x000000967b00720cULL, 0x080fe400037c1070ULL, 0x000000968700720cULL, 0x0c0fe40000701070ULL,
0x000000968700720cULL, 0x000fc40001741070ULL, 0x000000966100720cULL, 0x0c0fe40001f61070ULL,
0x000000966100720cULL, 0x0c0fe40000f21070ULL, 0x000000966100720cULL, 0x080fe40002781070ULL,
0x000000969f00720cULL, 0x000fe40002fa1070ULL, 0x00000070c9a97219ULL, 0x040fe400000006ffULL,
0x0000006ac9af7219ULL, 0x000fc400000006ffULL, 0xff8000000e0e7808ULL, 0x000fe40003000000ULL,
0xff80000033337808ULL, 0x000fe40000000000ULL, 0xff8000004c4c7808ULL, 0x000fe40001000000ULL,
0xff80000019197808ULL, 0x000fe40001800000ULL, 0xff80000035357808ULL, 0x000fe40000800000ULL,
0xff80000047477808ULL, 0x000fc40002000000ULL, 0xff80000036367808ULL, 0x000fe40002800000ULL,
0x0000005691ff7212ULL, 0x000fe400078cc0ffULL, 0x00000060a3ff7212ULL, 0x080fe4000780c0ffULL,
0x00000060a9ff7212ULL, 0x000fe4000784c0ffULL, 0x00000062a3ff7212ULL, 0x040fe4000786c0ffULL,
0x00000084a3ff7212ULL, 0x000fc4000782c0ffULL, 0x00000062a9ff7212ULL, 0x000fe4000788c0ffULL,
0x00000080afff7212ULL, 0x000fe200078ac0ffULL, 0x00000001b3767824ULL, 0x000fe200078e0a72ULL,
0x000000968f00720cULL, 0x080fe400037c1470ULL, 0x00000096a100720cULL, 0x0c0fe40000701470ULL,
0x00000096a100720cULL, 0x0c0fe40001f61470ULL, 0x00000096a100720cULL, 0x000fc40000f21470ULL,
0x00000096a700720cULL, 0x0c0fe40001741470ULL, 0x00000096a700720cULL, 0x080fe40002781470ULL,
0x00000096ad00720cULL, 0x000fe40002fa1470ULL, 0x0000003103b97812ULL, 0x040fe400078efcffULL,
0x0000003803bf7812ULL, 0x040fe400078efcffULL, 0x0000003903c57812ULL, 0x000fc400078efcffULL,
0x000000968d00720cULL, 0x080fe400037c1070ULL, 0x000000969f00720cULL, 0x0c0fe40000701070ULL,
0x000000969f00720cULL, 0x0c0fe40001f61070ULL, 0x000000969f00720cULL, 0x080fe40000f21070ULL,
0x00000096a500720cULL, 0x0c0fe40001741070ULL, 0x00000096a500720cULL, 0x000fc40002781070ULL,
0x00000096ab00720cULL, 0x000fe40002fa1070ULL, 0x00000076c9b77219ULL, 0x000fe400000006ffULL,
0x00005410b5747816ULL, 0x000fe40000000074ULL, 0x00005410d1827816ULL, 0x000fe40000000082ULL,
0x00005800b9bb7a10ULL, 0x000fe40007ffe0ffULL, 0x00005800bfc17a10ULL, 0x000fc40007ffe0ffULL,
0x00005800c5c77a10ULL, 0x000fe40007ffe0ffULL, 0xff80000012127808ULL, 0x000fe40003000000ULL,
0xff80000014147808ULL, 0x000fe40000000000ULL, 0xff80000026267808ULL, 0x000fe40001800000ULL,
0xff80000038387808ULL, 0x000fe40000800000ULL, 0xff80000018187808ULL, 0x000fc40001000000ULL,
0xff80000027277808ULL, 0x000fe40002000000ULL, 0xff80000039397808ULL, 0x000fe40002800000ULL,
0x00000060afff7212ULL, 0x040fe400078cc0ffULL, 0x00000062afff7212ULL, 0x000fe4000780c0ffULL,
0x00000080a9ff7212ULL, 0x040fe4000786c0ffULL, 0x00000084a9ff7212ULL, 0x000fc4000782c0ffULL,
0x00000084afff7212ULL, 0x000fe4000784c0ffULL, 0x00000074b7ff7212ULL, 0x040fe4000788c0ffULL,
0x00000082b7ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001bb787824ULL, 0x100fe200078e0a72ULL,
0x00000096a700720cULL, 0x080fe20001f61470ULL, 0x00000001c17a7824ULL, 0x100fe200078e0a72ULL,
0x00000096a700720cULL, 0x080fe20000f21470ULL, 0x00000001c7727824ULL, 0x000fe200078e0a72ULL,
0x00000096ad00720cULL, 0x000fc400037c1470ULL, 0x00000096ad00720cULL, 0x0c0fe40000701470ULL,
0x00000096ad00720cULL, 0x080fe40001741470ULL, 0x00000096b300720cULL, 0x0c0fe40002781470ULL,
0x00000096b300720cULL, 0x000fe40002fa1470ULL, 0x00000078c9bd7219ULL, 0x040fe400000006ffULL,
0x0000007ac9c37219ULL, 0x000fc400000006ffULL, 0x00000096a500720cULL, 0x0c0fe40001f61070ULL,
0x00000096a500720cULL, 0x080fe40000f21070ULL, 0x00000096ab00720cULL, 0x0c0fe400037c1070ULL,
0x00000096ab00720cULL, 0x0c0fe40000701070ULL, 0x00000096ab00720cULL, 0x080fe40001741070ULL,
0x00000096b100720cULL, 0x000fc40002781070ULL, 0x00000096b100720cULL, 0x000fe40002fa1070ULL,
0x00000072c9c97219ULL, 0x000fe400000006ffULL, 0x00005410cd7e7816ULL, 0x000fe4000000007eULL,
0xff80000037377808ULL, 0x000fe40001800000ULL, 0xff8000003a3a7808ULL, 0x000fe40000800000ULL,
0xff80000015157808ULL, 0x000fc40003000000ULL, 0xff80000028287808ULL, 0x000fe40000000000ULL,
0xff8000003b3b7808ULL, 0x000fe40001000000ULL, 0xff80000016167808ULL, 0x000fe40002000000ULL,
0xff8000003c3c7808ULL, 0x000fe40002800000ULL, 0x00000074bdff7212ULL, 0x080fe4000786c0ffULL,
0x00000074c3ff7212ULL, 0x000fc4000782c0ffULL, 0x00000074c9ff7212ULL, 0x000fe400078cc0ffULL,
0x0000007eb7ff7212ULL, 0x080fe4000780c0ffULL, 0x0000007ebdff7212ULL, 0x080fe4000784c0ffULL,
0x0000007ec3ff7212ULL, 0x000fe4000788c0ffULL, 0x00000082bdff7212ULL, 0x000fe400078ac0ffULL,
0x00000096b300720cULL, 0x000fc40000701470ULL, 0x00000096bb00720cULL, 0x0c0fe40001f61470ULL,
0x00000096bb00720cULL, 0x0c0fe40001741470ULL, 0x00000096bb00720cULL, 0x080fe40002fa1470ULL,
0x00000096c100720cULL, 0x080fe40000f21470ULL, 0x00000096c700720cULL, 0x080fe400037c1470ULL,
0x00000096c100720cULL, 0x000fc40002781470ULL, 0x00000096b100720cULL, 0x080fe40000701070ULL,
0x00000096b900720cULL, 0x0c0fe40001f61070ULL, 0x00000096b900720cULL, 0x0c0fe40001741070ULL,
0x00000096b900720cULL, 0x080fe40002fa1070ULL, 0x00000096bf00720cULL, 0x080fe40000f21070ULL,
0x00000096c500720cULL, 0x000fc400037c1070ULL, 0x00000096bf00720cULL, 0x000fe40002781070ULL,
0x00005410d5867816ULL, 0x000fe40000000086ULL, 0xff80000029297808ULL, 0x000fe40000000000ULL,
0xff80000013137808ULL, 0x000fe40001800000ULL, 0xff8000002a2a7808ULL, 0x000fe40001000000ULL,
0xff8000003d3d7808ULL, 0x000fc40002800000ULL, 0xff8000001c1c7808ULL, 0x000fe40000800000ULL,
0xff8000001b1b7808ULL, 0x000fe40003000000ULL, 0xff8000002b2b7808ULL, 0x000fe40002000000ULL,
0x0000007ec9ff7212ULL, 0x000fe4000780c0ffULL, 0x00000082c3ff7212ULL, 0x080fe4000786c0ffULL,
0x00000082c9ff7212ULL, 0x000fc4000784c0ffULL, 0x00000086b7ff7212ULL, 0x080fe400078ac0ffULL,
0x00000086bdff7212ULL, 0x080fe4000782c0ffULL, 0x00000086c3ff7212ULL, 0x080fe400078cc0ffULL,
0x00000086c9ff7212ULL, 0x000fe4000788c0ffULL, 0x00000096b300720cULL, 0x080fe40002fa1470ULL,
0x00000096bb00720cULL, 0x000fc40000f21470ULL, 0x00000096c100720cULL, 0x0c0fe40001f61470ULL,
0x00000096c100720cULL, 0x080fe400037c1470ULL, 0x00000096c700720cULL, 0x0c0fe40000701470ULL,
0x00000096c700720cULL, 0x0c0fe40001741470ULL, 0x00000096c700720cULL, 0x080fe40002781470ULL,
0x00000096b100720cULL, 0x000fc40002fa1070ULL, 0x00000096b900720cULL, 0x080fe40000f21070ULL,
0x00000096c500720cULL, 0x080fe40000701070ULL, 0x00000096bf00720cULL, 0x0c0fe40001f61070ULL,
0x00000096bf00720cULL, 0x080fe400037c1070ULL, 0x00000096c500720cULL, 0x0c0fe40001741070ULL,
0x00000096c500720cULL, 0x000fc40002781070ULL, 0xff8000002c2c7808ULL, 0x000fe40000000000ULL,
0xff8000003f3f7808ULL, 0x000fe40001800000ULL, 0xff80000041417808ULL, 0x000fe40001000000ULL,
0xff8000003e3e7808ULL, 0x000fe40002800000ULL, 0xff80000040407808ULL, 0x000fe40000800000ULL,
0xff80000043437808ULL, 0x000fc40003000000ULL, 0xff80000044447808ULL, 0x000fc40002000000ULL,
0x0000000d0800720bULL, 0x004fe40003f1e000ULL, 0x0000001a0900720bULL, 0x000fe40003f3e000ULL,
0x0000002d0a00720bULL, 0x000fe40003f5e000ULL, 0x000000420b00720bULL, 0x000fe40003f7e000ULL,
0x000000080d037208ULL, 0x000fe40004000000ULL, 0x000000091a087208ULL, 0x000fc40004800000ULL,
0x0000000a2d097208ULL, 0x000fe40005000000ULL, 0x0000000b420a7208ULL, 0x000fe40005800000ULL,
0x000000040300720bULL, 0x000fe40003f1e000ULL, 0x0000001d0800720bULL, 0x000fe40003f3e000ULL,
0x0000002e0900720bULL, 0x000fe40003f5e000ULL, 0x000000450a00720bULL, 0x000fc40003f7e000ULL,
0x0000000304037208ULL, 0x000fe40004000000ULL, 0x000000081d0b7208ULL, 0x000fe40004800000ULL,
0x000000092e087208ULL, 0x000fe40005000000ULL, 0x0000000a45097208ULL, 0x000fe40005800000ULL,
0x0000000c0300720bULL, 0x000fe40003f1e000ULL, 0x0000001e0b00720bULL, 0x000fc40003f3e000ULL,
0x0000002f0800720bULL, 0x000fe40003f5e000ULL, 0x000000460900720bULL, 0x000fe40003f7e000ULL,
0x000000030c037208ULL, 0x000fe40004000000ULL, 0x0000000b1e0b7208ULL, 0x000fe40004800000ULL,
0x000000082f4d7208ULL, 0x000fe40005000000ULL, 0x0000000946097208ULL, 0x000fc40005800000ULL,
0x0000000e0300720bULL, 0x000fe40003f1e000ULL, 0x000000200b00720bULL, 0x000fe40003f3e000ULL,
0x000000304d00720bULL, 0x000fe40003f5e000ULL, 0x000000480900720bULL, 0x000fe40003f7e000ULL,
0x000000030e087208ULL, 0x000fe40004000000ULL, 0x0000000b200a7208ULL, 0x000fc40004800000ULL,
0x0000004d304e7208ULL, 0x000fe40005000000ULL, 0x0000000948097208ULL, 0x000fe40005800000ULL,
0x0000000f0800720bULL, 0x000fe40003f1e000ULL, 0x000000210a00720bULL, 0x000fe40003f3e000ULL,
0x000000314e00720bULL, 0x000fe40003f5e000ULL, 0x0000004a0900720bULL, 0x000fc40003f7e000ULL,
0x000000080f037208ULL, 0x000fe40004000000ULL, 0x0000000a210b7208ULL, 0x000fe40004800000ULL,
0x0000004e314d7208ULL, 0x000fe40005000000ULL, 0x000000094a087208ULL, 0x000fe40005800000ULL,
0x000000100300720bULL, 0x000fe40003f1e000ULL, 0x000000220b00720bULL, 0x000fc40003f3e000ULL,
0x000000324d00720bULL, 0x000fe40003f5e000ULL, 0x0000004b0800720bULL, 0x000fe40003f7e000ULL,
0x00000003100a7208ULL, 0x000fe40004000000ULL, 0x0000000b224e7208ULL, 0x000fe40004800000ULL,
0x0000004d32507208ULL, 0x000fe40005000000ULL, 0x000000084b037208ULL, 0x000fc40005800000ULL,
0x000000110a00720bULL, 0x000fe40003f1e000ULL, 0x000000234e00720bULL, 0x000fe40003f3e000ULL,
0x000000335000720bULL, 0x000fe40003f5e000ULL, 0x0000004c0300720bULL, 0x000fe40003f7e000ULL,
0x0000000a11097208ULL, 0x000fe40004000000ULL, 0x0000004e230b7208ULL, 0x000fc40004800000ULL,
0x00000050334d7208ULL, 0x000fe40005000000ULL, 0x000000034c087208ULL, 0x000fe40005800000ULL,
0x000000120900720bULL, 0x000fe40003f1e000ULL, 0x000000240b00720bULL, 0x000fe40003f3e000ULL,
0x000000344d00720bULL, 0x000fe40003f5e000ULL, 0x000000490800720bULL, 0x000fc40003f7e000ULL,
0x00000009120a7208ULL, 0x000fe40004000000ULL, 0x0000000b244e7208ULL, 0x000fe40004800000ULL,
0x0000004d34507208ULL, 0x000fe40005000000ULL, 0x0000000849087208ULL, 0x000fe40005800000ULL,
0x000000190a00720bULL, 0x000fe40003f1e000ULL, 0x000000254e00720bULL, 0x000fc40003f3e000ULL,
0x000000355000720bULL, 0x000fe40003f5e000ULL, 0x000000470800720bULL, 0x000fe40003f7e000ULL,
0x0000000a19037208ULL, 0x000fe40004000000ULL, 0x0000004e25097208ULL, 0x000fe40004800000ULL,
0x00000050350b7208ULL, 0x000fe40005000000ULL, 0x00000008474d7208ULL, 0x000fc40005800000ULL,
0x000000140300720bULL, 0x000fe40003f1e000ULL, 0x000000260900720bULL, 0x000fe40003f3e000ULL,
0x000000360b00720bULL, 0x000fe40003f5e000ULL, 0x000000384d00720bULL, 0x000fe40003f7e000ULL,
0x0000000314037208ULL, 0x000fe40004000000ULL, 0x0000000926087208ULL, 0x000fc40004800000ULL,
0x0000000b360a7208ULL, 0x000fe40005000000ULL, 0x0000004d384d7208ULL, 0x000fe40005800000ULL,
0x000000180300720bULL, 0x000fe40003f1e000ULL, 0x000000270800720bULL, 0x000fe40003f3e000ULL,
0x000000370a00720bULL, 0x000fe40003f5e000ULL, 0x0000003a4d00720bULL, 0x000fc40003f7e000ULL,
0x00000003184e7208ULL, 0x000fe40004000000ULL, 0x0000000827037208ULL, 0x000fe40004800000ULL,
0x0000000a370a7208ULL, 0x000fe40005000000ULL, 0x0000004d3a087208ULL, 0x000fe40005800000ULL,
0x000000154e00720bULL, 0x000fe40003f1e000ULL, 0x000000280300720bULL, 0x000fc40003f3e000ULL,
0x000000390a00720bULL, 0x000fe40003f5e000ULL, 0x0000003b0800720bULL, 0x000fe40003f7e000ULL,
0x0000004e15097208ULL, 0x000fe40004000000ULL, 0x00000003284e7208ULL, 0x000fe40004800000ULL,
0x0000000a39037208ULL, 0x000fe40005000000ULL, 0x000000083b0b7208ULL, 0x000fc40005800000ULL,
0x000000160900720bULL, 0x000fe40003f1e000ULL, 0x000000294e00720bULL, 0x000fe40003f3e000ULL,
0x0000003c0300720bULL, 0x000fe40003f5e000ULL, 0x0000003e0b00720bULL, 0x000fe40003f7e000ULL,
0x0000000916087208ULL, 0x000fe40004000000ULL, 0x0000004e29097208ULL, 0x000fc40004800000ULL,
0x000000033c0a7208ULL, 0x000fe40005000000ULL, 0x0000000b3e0b7208ULL, 0x000fe40005800000ULL,
0x000000130800720bULL, 0x000fe40003f1e000ULL, 0x0000002a0900720bULL, 0x000fe40003f3e000ULL,
0x0000003d0a00720bULL, 0x000fe40003f5e000ULL, 0x000000400b00720bULL, 0x000fc40003f7e000ULL,
0x0000000813037208ULL, 0x000fe40004000000ULL, 0x000000092a087208ULL, 0x000fe40004800000ULL,
0x0000000a3d0a7208ULL, 0x000fe40005000000ULL, 0x0000000b404e7208ULL, 0x000fe40005800000ULL,
0x0000001c0300720bULL, 0x000fe40003f1e000ULL, 0x0000002b0800720bULL, 0x000fc40003f3e000ULL,
0x0000003f0a00720bULL, 0x000fe40003f5e000ULL, 0x000000434e00720bULL, 0x000fe40003f7e000ULL,
0x000000031c507208ULL, 0x000fe40004000000ULL, 0x000000082b037208ULL, 0x000fe40004800000ULL,
0x0000000a3f0a7208ULL, 0x000fe40005000000ULL, 0x0000004e43097208ULL, 0x000fc40005800000ULL,
0x0000001b5000720bULL, 0x000fe40003f1e000ULL, 0x0000002c0300720bULL, 0x000fe40003f3e000ULL,
0x000000410a00720bULL, 0x000fe40003f5e000ULL, 0x000000440900720bULL, 0x000fe40003f7e000ULL,
0x000000501b0b7208ULL, 0x000fe40004000000ULL, 0x000000032c527208ULL, 0x000fc40004800000ULL,
0x0000000a414d7208ULL, 0x000fe40005000000ULL, 0x0000000944547208ULL, 0x000fe20005800000ULL,
0x000024727f007947ULL, 0x000fea000b800000ULL, 0x0c401f000b037f89ULL, 0x0004e400000e0000ULL,
0x000000030b00720bULL, 0x00cfc80003f1e000ULL, 0x0000000b03537208ULL, 0x000fe20004000000ULL,
0x000024927f007947ULL, 0x000fea000b800000ULL, 0x0c401f0052037f89ULL, 0x000ea800000e0000ULL,
0x0c401f004d087f89ULL, 0x000ee800000e0000ULL, 0x0c401f0054097f89ULL, 0x000f2200000e0000ULL,
0x000000035200720bULL, 0x004fc40003f1e000ULL, 0x000000084d00720bULL, 0x008fe40003f3e000ULL,
0x0000005203037208ULL, 0x000fe40004000000ULL, 0x0000004d080b7208ULL, 0x002fe40004800000ULL,
0x000000095400720bULL, 0x010fe20003f1e000ULL, 0x0c201f00030a7f89ULL, 0x000e6600000e0000ULL,
0x0000005409517208ULL, 0x000fe20004000000ULL, 0x0c201f0053087f89ULL, 0x000ea800000e0000ULL,
0x0c201f000b4e7f89ULL, 0x000ee800000e0000ULL, 0x0c201f0051527f89ULL, 0x0002e400000e0000ULL,
0x0000000a0300720bULL, 0x002fc40003f3e000ULL, 0x000000085300720bULL, 0x004fe40003f1e000ULL,
0x000000030a097208ULL, 0x000fe40004800000ULL, 0x0000004e0b00720bULL, 0x008fe40003f5e000ULL,
0x0000005308087208ULL, 0x000fe40004000000ULL, 0x0000000b4e0a7208ULL, 0x000fc60005000000ULL,
0x3fb8aa3b080b7820ULL, 0x002fe20000410000ULL, 0x000000525100720bULL, 0x000fe20003f1e000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x3fb8aa3b04047823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe4000001080bULL, 0x0000000400547308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b10107823ULL, 0x100fe2000001080bULL,
0x0000000c00537308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b11117823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b12127823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b19037823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b144e7823ULL, 0x100fe2000001080bULL, 0x0000000f00557308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b184d7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b15507823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b16167823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001080bULL,
0x0000000d000d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1c047823ULL, 0x102fe4000001080bULL,
0x3fb8aa3b1b4f7823ULL, 0x000fe4000001080bULL, 0x3fb8aa3b090b7820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b0a0c7820ULL, 0x004fe20000410000ULL, 0x0000001000567308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b1a1a7823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001080bULL,
0x0000001100577308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b21217823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b22227823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b23237823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001080bULL, 0x0000001e000f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b25257823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b26267823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b27277823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001080bULL,
0x00000025001e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b29297823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b2c0b7823ULL, 0x000fe2000001080bULL, 0x0000001200587308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080cULL, 0x00000002ff2c7819ULL, 0x000fe2000001169dULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe2000001080cULL,
0x000000022c147810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001080cULL,
0x0000000b00617308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001080cULL,
0x000000032c157810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b32327823ULL, 0x000fc4000001080cULL,
0x3fb8aa3b33337823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b34347823ULL, 0x100fe2000001080cULL,
0x0000001300597308ULL, 0x000fe20000000800ULL, 0x00000051520b7208ULL, 0x002fe20004000000ULL,
0x3fb8aa3b35357823ULL, 0x100fe2000001080cULL, 0x000000039dff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b36367823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b0b257820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b37377823ULL, 0x000fe2000001080cULL, 0x0000000e000e7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b42427823ULL, 0x000fc40000010825ULL, 0x3fb8aa3b45457823ULL, 0x100fe40000010825ULL,
0x3fb8aa3b46467823ULL, 0x100fe40000010825ULL, 0x3fb8aa3b48487823ULL, 0x000fe20000010825ULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b39397823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b3d3d7823ULL, 0x000fc4000001080cULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe2000001080cULL, 0x0000001d001d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b410c7823ULL, 0x000fe2000001080cULL, 0x000000530e0e723eULL, 0x002fe200000000ffULL,
0x000000082c417824ULL, 0x040fe400078e00ffULL, 0x000000082c187824ULL, 0x040fe400078e00ffULL,
0x000000082c637824ULL, 0x040fe200078e00ffULL, 0x0000002000207308ULL, 0x000e620000000800ULL,
0xfffffff841417812ULL, 0x000fe200078ee214ULL, 0x000000082c657824ULL, 0x000fe200078e00ffULL,
0xfffffff818517812ULL, 0x000fe200078ee215ULL, 0x000000082c537824ULL, 0x040fe200078e00ffULL,
0x000000052c147810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b4a4a7823ULL, 0x000fe20000010825ULL,
0x000000062c157810ULL, 0x000fe20007ffe0ffULL, 0x00000027005c7308ULL, 0x000fe20000000800ULL,
0xfffffff865657812ULL, 0x000fe200078ee214ULL, 0x3c003c00ff147424ULL, 0x000fe200078e00ffULL,
0xfffffff818677812ULL, 0x000fe200078ee215ULL, 0x3c003c00ff157424ULL, 0x000fe200078e00ffULL,
0xffffffff2c187810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b4b4b7823ULL, 0x000fc40000010825ULL,
0x0000002d00107308ULL, 0x0005e20000000800ULL, 0x0000000f200f723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010825ULL, 0xfffffff853537812ULL, 0x000fe200078ee218ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010825ULL, 0x000000555620723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b47477823ULL, 0x100fe40000010825ULL, 0x0000002e00117308ULL, 0x0002e20000000800ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010825ULL, 0x000000102c2d7810ULL, 0x004fe20007ffe0ffULL,
0x3fb8aa3b3a3a7823ULL, 0x000fc40000010825ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe40000010825ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010825ULL, 0x0000002f00127308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b40407823ULL, 0x100fe40000010825ULL, 0x3fb8aa3b43437823ULL, 0x100fe40000010825ULL,
0x3fb8aa3b44447823ULL, 0x000fe40000010825ULL, 0x000000082d2e7824ULL, 0x002fe200078e00ffULL,
0x0000003000137308ULL, 0x000e620000000800ULL, 0x000000101110723eULL, 0x008fce00000000ffULL,
0x0000004200427308ULL, 0x000ff00000000800ULL, 0x0000004500457308ULL, 0x000ea20000000800ULL,
0x000000121312723eULL, 0x002fce00000000ffULL, 0x0000004600467308ULL, 0x000ff00000000800ULL,
0x0000004800277308ULL, 0x000e620000000800ULL, 0x000000424511723eULL, 0x004fce00000000ffULL,
0x0000003900627308ULL, 0x0005f00000000800ULL, 0x0000000c00527308ULL, 0x0007e20000000800ULL,
0x000000082c397824ULL, 0x004fe200078e00ffULL, 0x000000462713723eULL, 0x002fcc00000000ffULL,
0x00000024005a7308ULL, 0x000fe20000000800ULL, 0x000000012c0c7810ULL, 0x008fc80007ffe0ffULL,
0xfffffff839397812ULL, 0x000fe400078ee20cULL, 0x000000042c0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000026005b7308ULL, 0x0003e60000000800ULL, 0xfffffff863637812ULL, 0x000fe400078ee20cULL,
0x0000000d540c723eULL, 0x000fe400000000ffULL, 0x0000001a1d0d723eULL, 0x000fe200000000ffULL,
0x00000028005d7308ULL, 0x000ea20000000800ULL, 0x000000141024723cULL, 0x002fe200000018ffULL,
0x000000082c1d7824ULL, 0x000fca00078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee22cULL,
0x00000029005e7308ULL, 0x000fe20000000800ULL, 0x000000140c18723cULL, 0x000f6e00000018ffULL,
0x0000002a005f7308ULL, 0x000fe20000000800ULL, 0x0000005c5d2f723eULL, 0x004fce00000000ffULL,
0x0000002b00607308ULL, 0x000ff00000000800ULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x00000022001c7308ULL, 0x0002b00000000800ULL, 0x0000002300237308ULL, 0x000ee20000000800ULL,
0x000000575822723eULL, 0x002fce00000000ffULL, 0x0000003100287308ULL, 0x0003e20000000800ULL,
0x000000211c21723eULL, 0x004fe400000000ffULL, 0x000000082c1c7810ULL, 0x040fe40007ffe0ffULL,
0x000000182c2c7810ULL, 0x000fc60007ffe0ffULL, 0x0000003200297308ULL, 0x000ea20000000800ULL,
0x000000235a23723eULL, 0x008fe200000000ffULL, 0x000000081c457824ULL, 0x000fe200078e00ffULL,
0x0000005e5f31723eULL, 0x002fc800000000ffULL, 0xfffffff845457812ULL, 0x000fe200078ee21cULL,
0x00000033002a7308ULL, 0x0003e20000000800ULL, 0x000000142018723cULL, 0x020f6e0000001818ULL,
0x00000034002b7308ULL, 0x000ee20000000800ULL, 0x000000282928723eULL, 0x004fc400000000ffULL,
0x000000606133723eULL, 0x002fca00000000ffULL, 0x0000004a004a7308ULL, 0x000ff00000000800ULL,
0x0000004b004b7308ULL, 0x000e620000000800ULL, 0x0000002a2b2a723eULL, 0x008fce00000000ffULL,
0x0000004c004c7308ULL, 0x000ff00000000800ULL, 0x0000004900497308ULL, 0x000ea20000000800ULL,
0x0000004a4b29723eULL, 0x002fe200000000ffULL, 0x000000082c4b7824ULL, 0x000fca00078e00ffULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee22cULL, 0x0000003500357308ULL, 0x000fe20000000800ULL,
0x0000004c492b723eULL, 0x004fce00000000ffULL, 0x0000003600367308ULL, 0x000e620000000800ULL,
0xfffffff82e497812ULL, 0x000fe400078ee22dULL, 0x0000001e5b2d723eULL, 0x000fe200000000ffULL,
0x000000142824723cULL, 0x000f680000001824ULL, 0x0000000300037308ULL, 0x000ff00000000800ULL,
0x0000004e004e7308ULL, 0x000ea20000000800ULL, 0x000000353634723eULL, 0x002fce00000000ffULL,
0x0000004d004d7308ULL, 0x000ff00000000800ULL, 0x0000005000507308ULL, 0x000e620000000800ULL,
0x000000034e2c723eULL, 0x004fce00000000ffULL, 0x0000003700377308ULL, 0x000eb00000000800ULL,
0x0000004700477308ULL, 0x000fe20000000800ULL, 0x0000004d502e723eULL, 0x002fce00000000ffULL,
0x0000003800387308ULL, 0x000e620000000800ULL, 0x000000376236723eULL, 0x004fe200000000ffULL,
0x000000142c18723cULL, 0x020f6c0000001818ULL, 0x0000003a003a7308ULL, 0x000ff00000000800ULL,
0x0000003b003b7308ULL, 0x000ea20000000800ULL, 0x000000473835723eULL, 0x002fc400000000ffULL,
0x0000000c1f477812ULL, 0x000fca00078ec0ffULL, 0x0000000400047308ULL, 0x000ff00000000800ULL,
0x0000004f004f7308ULL, 0x000e620000000800ULL, 0x0000003a3b37723eULL, 0x004fce00000000ffULL,
0x0000001600167308ULL, 0x000ea20000000800ULL, 0x000000143424723cULL, 0x000fee0000001824ULL,
0x0000003c003c7308ULL, 0x000fe20000000800ULL, 0x000000044f32723eULL, 0x002fe400000000ffULL,
0x0001200000047811ULL, 0x000fca00078e60ffULL, 0x0000003d003d7308ULL, 0x000fe20000000800ULL,
0x000000165930723eULL, 0x004fe200000000ffULL, 0x000000101d167824ULL, 0x100fe400078e0204ULL,
0x00000010391c7824ULL, 0x100fe400078e0204ULL, 0x00000010411e7824ULL, 0x100fe400078e0204ULL,
0x0000003f003f7308ULL, 0x000e620000000800ULL, 0x00000010511f7824ULL, 0x100fe200078e0204ULL,
0x000000143018723cULL, 0x020f620000001818ULL, 0x0000001063387824ULL, 0x000fc400078e0204ULL,
0x00000001471d7824ULL, 0x000fe400078e0216ULL, 0x0000001065397824ULL, 0x000fe200078e0204ULL,
0x0000003e003e7308ULL, 0x000fe20000000800ULL, 0x00000001471c7824ULL, 0x000fe200078e021cULL,
0x0000000c1d007388ULL, 0x0005e20000000800ULL, 0x00000010673a7824ULL, 0x000fe400078e0204ULL,
0x00000001471e7824ULL, 0x000fe200078e021eULL, 0x0000000e1c007388ULL, 0x0005e20000000800ULL,
0x0000001053167824ULL, 0x100fe200078e0204ULL, 0x0000004000037308ULL, 0x0007220000000800ULL,
0x0000003f5242723eULL, 0x002fe200000000ffULL, 0x00000001471f7824ULL, 0x000fe200078e021fULL,
0x000000201e007388ULL, 0x0005e20000000800ULL, 0x00000010453b7824ULL, 0x000fc400078e0204ULL,
0x0000000147387824ULL, 0x000fe200078e0238ULL, 0x000000221f007388ULL, 0x0005e20000000800ULL,
0x0000004300437308ULL, 0x000fe20000000800ULL, 0x0000003c3d40723eULL, 0x008fe200000000ffULL,
0x0000000147397824ULL, 0x040fe200078e0239ULL, 0x0000002c38007388ULL, 0x0005e20000000800ULL,
0x00000001473a7824ULL, 0x000fe400078e023aULL, 0x0000001049457824ULL, 0x100fe200078e0204ULL,
0x0000002e39007388ULL, 0x0005e20000000800ULL, 0x0000004400447308ULL, 0x000e620000000800ULL,
0x0000003e0341723eULL, 0x010fe200000000ffULL, 0x000000104b467824ULL, 0x000fe200078e0204ULL,
0x000000303a007388ULL, 0x0005e20000000800ULL, 0x0000000147167824ULL, 0x000fc400078e0216ULL,
0x0000000147047824ULL, 0x040fe400078e023bULL, 0x0000000147457824ULL, 0x040fe200078e0245ULL,
0x0000003216007388ULL, 0x0005e20000000800ULL, 0x0000000147467824ULL, 0x000fe400078e0246ULL,
0x000000ffff197224ULL, 0x020fe200078e001aULL, 0x0000000d04007388ULL, 0x0005e20000000800ULL,
0x000000434443723eULL, 0x002fc600000000ffULL, 0x0004000f1c007388ULL, 0x0005e80000000800ULL,
0x000400211e007388ULL, 0x0005e20000000800ULL, 0x000000144024723cULL, 0x000f660000001824ULL,
0x000400231f007388ULL, 0x0005e80000000800ULL, 0x0004002d38007388ULL, 0x0005e80000000800ULL,
0x0004002f39007388ULL, 0x0005e80000000800ULL, 0x000400313a007388ULL, 0x0005e80000000800ULL,
0x0004003316007388ULL, 0x0005e80000000800ULL, 0x0000001045007388ULL, 0x0005e20000000800ULL,
0x000000ffff1a7224ULL, 0x020fc600078e0024ULL, 0x000800121c007388ULL, 0x0005e20000000800ULL,
0x000000ffff1b7224ULL, 0x000fc600078e0026ULL, 0x000800281e007388ULL, 0x0005e80000000800ULL,
0x0008002a1f007388ULL, 0x0005e80000000800ULL, 0x0008003438007388ULL, 0x0005e80000000800ULL,
0x0008003639007388ULL, 0x0005e80000000800ULL, 0x000800403a007388ULL, 0x0005e80000000800ULL,
0x0008004216007388ULL, 0x0005e80000000800ULL, 0x0000001146007388ULL, 0x0005e80000000800ULL,
0x000c00131c007388ULL, 0x0005e80000000800ULL, 0x000c00291e007388ULL, 0x0005e80000000800ULL,
0x000c002b1f007388ULL, 0x0005e80000000800ULL, 0x000c003538007388ULL, 0x0005e80000000800ULL,
0x000c003739007388ULL, 0x0005e80000000800ULL, 0x000c00413a007388ULL, 0x0005e80000000800ULL,
0x000c004316007388ULL, 0x0005e80000000800ULL, 0x01e0000817008388ULL, 0x0005e80000000c00ULL,
0x01e2001817008388ULL, 0x0005e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e608009aff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e610009aff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e618009aff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000067900720cULL, 0x000fe20003f06070ULL, 0x01e620009aff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff037224ULL, 0x000fd600078e0079ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff766000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff287807ULL, 0x004fe20004000000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x000191c000297802ULL, 0x000fc40000000f00ULL, 0x000015e000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff127224ULL, 0x000fe200078e0028ULL, 0xfffe998000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40005000000ULL, 0xffffffff002a7802ULL, 0x000fe40000000f00ULL,
0x0001922000297802ULL, 0x000fc40000000f00ULL, 0x0000158000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0028ULL, 0xfffe99c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0016ULL, 0x0001929000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000014c000007944ULL, 0x008fea0003c00000ULL, 0xfffe9a7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0016ULL, 0x000192f000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000146000007944ULL, 0x00afea0003c00000ULL, 0xfffe9b8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0016ULL, 0x0001935000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000140000007944ULL, 0x00afea0003c00000ULL, 0xfffe9c9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0016ULL, 0x000193b000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000013a000007944ULL, 0x00afea0003c00000ULL, 0xfffe9d9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0012ULL, 0x0001942000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fe400078e0011ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000133000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0xfffe9f2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0012ULL, 0x0001949000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000012c000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0x0000001011297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0012ULL,
0x0001950000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000125000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0029ULL, 0xfffe9e9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0012ULL, 0x0001957000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000011e000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0029ULL,
0xfffe9e5000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x004fe20004000000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x000195d000297802ULL, 0x000fc40000000f00ULL,
0x000011d000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0028ULL,
0xfffeb5c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe20004800000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x0001963000297802ULL, 0x000fc40000000f00ULL,
0x0000117000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff6e7224ULL, 0x000fe200078e0028ULL,
0xfffeb60000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0070ULL,
0x000196a000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000010b000007944ULL, 0x008fea0003c00000ULL,
0xfffeb6c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0070ULL,
0x0001970000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000105000007944ULL, 0x00afea0003c00000ULL,
0xfffeb7d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0070ULL,
0x0001976000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000ff000007944ULL, 0x00afea0003c00000ULL,
0xfffeb8e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0070ULL,
0x000197c000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000f9000007944ULL, 0x00afea0003c00000ULL,
0xfffeb9e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0011ULL,
0x0001983000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fe400078e001cULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000f2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0xfffebb6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0011ULL,
0x000198a000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000eb000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0x000000101c297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0011ULL, 0x0001991000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000e4000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0029ULL,
0xfffebad000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0011ULL,
0x0001998000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000dd000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0029ULL, 0xfffeba9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x004fe20004000000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x000199e000297802ULL, 0x000fc40000000f00ULL, 0x00000dc000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff6d7224ULL, 0x000fe200078e0028ULL, 0xfffecfb000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe20004800000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x00019a4000297802ULL, 0x000fc40000000f00ULL, 0x00000d6000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff267224ULL, 0x000fe200078e0028ULL, 0xfffecff000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0072ULL, 0x0000001f006c7802ULL, 0x000fe20000000f00ULL,
0xffffffffff2b7424ULL, 0x000fe200078e00ffULL, 0x00019ab000287802ULL, 0x000fc40000000f00ULL,
0x00000ca000007944ULL, 0x008fea0003c00000ULL, 0xfffed0b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0072ULL, 0x00019b1000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000c4000007944ULL, 0x00afea0003c00000ULL, 0xfffed1c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0072ULL, 0x00019b7000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000be000007944ULL, 0x00afea0003c00000ULL, 0xfffed2d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0072ULL, 0x00019bd000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000b8000007944ULL, 0x00afea0003c00000ULL, 0xfffed3d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0011ULL, 0x00019c4000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e006eULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000b1000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0xfffed56000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0011ULL, 0x00019cb000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000aa000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0x000000106e297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0011ULL,
0x00019d2000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000a3000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0029ULL, 0xfffed4d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0011ULL, 0x00019d9000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000009c000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0029ULL,
0xfffed49000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x008fe20004000000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x00019df000297802ULL, 0x000fc40000000f00ULL,
0x000009b000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff217224ULL, 0x000fe200078e0028ULL,
0xfffee9e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe20004800000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x00019e5000297802ULL, 0x000fc40000000f00ULL,
0x0000095000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff207224ULL, 0x000fe200078e0028ULL,
0xfffeea2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x00019ec000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000089000007944ULL, 0x002fea0003c00000ULL,
0xfffeeae000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x00019f2000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000083000007944ULL, 0x002fea0003c00000ULL,
0xfffeebf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x00019f8000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000007d000007944ULL, 0x002fea0003c00000ULL,
0xfffeed0000007947ULL, 0x000fea000383ffffULL, 0x0000000c002a7202ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fe200078e00ffULL, 0x00019fe000287802ULL, 0x000fe20000000f00ULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000077000007944ULL, 0x002fea0003c00000ULL,
0xfffeee0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000bULL,
0x0001a05000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e000cULL,
0x0000001fff6c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000070000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0xfffeef9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000bULL,
0x0001a0c000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000069000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0x000000100c297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000bULL, 0x0001a13000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff6c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000062000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0029ULL,
0xfffeef0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000bULL,
0x0001a1a000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff6c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000005b000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0029ULL, 0xfffeeec000007947ULL, 0x000fea000383ffffULL,
0x00000002ff507424ULL, 0x000fe200078e00ffULL, 0x0001a210004e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff037424ULL, 0x000fe400078e00ffULL, 0xffffffffff567424ULL, 0x000fc400078e00ffULL,
0x0000050000007944ULL, 0x002fea0003c00000ULL, 0xffffdb4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0b7224ULL, 0x002fe200078e0052ULL, 0x0001a280004e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff507424ULL, 0x000fc400078e00ffULL, 0x0000001fff037424ULL, 0x000fe400078e00ffULL,
0xffffffffff567424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x000000035200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e004dULL,
0x0001a300004e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff507424ULL, 0x000fe200078e00ffULL,
0x00000052030a7208ULL, 0x000fe20004000000ULL, 0x0000001fff037424ULL, 0x000fe400078e00ffULL,
0xffffffffff567424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x000000034d00720bULL, 0x004fe20003f1e000ULL, 0x00000002ff507424ULL, 0x002fe200078e00ffULL,
0x00000054000b7202ULL, 0x000fe20000000f00ULL, 0xffffffffff567424ULL, 0x000fe200078e00ffULL,
0x0000004d03527208ULL, 0x000fe20004000000ULL, 0x0000001fff037424ULL, 0x000fe200078e00ffULL,
0x0001a380004e7802ULL, 0x000fc40000000f00ULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x000000035400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e0053ULL,
0x0001a400004e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff507424ULL, 0x000fe200078e00ffULL,
0x0000005403517208ULL, 0x000fe20004000000ULL, 0x0000001fff037424ULL, 0x000fc400078e00ffULL,
0xffffffffff567424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000035300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e000aULL,
0x0001a480004e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff507424ULL, 0x000fe200078e00ffULL,
0x0000005303087208ULL, 0x000fe20004000000ULL, 0x0000001fff037424ULL, 0x000fe400078e00ffULL,
0xffffffffff567424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x000000030a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e0052ULL,
0x0001a500004e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff507424ULL, 0x000fe200078e00ffULL,
0x0000000a03097208ULL, 0x000fe20004000000ULL, 0x0000001fff037424ULL, 0x000fc400078e00ffULL,
0xffffffffff567424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000035200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e0051ULL,
0x0001a580004e7802ULL, 0x000fe20000000f00ULL, 0x00000001ff507424ULL, 0x000fe200078e00ffULL,
0x00000052030a7208ULL, 0x000fe20004000000ULL, 0x0000001fff037424ULL, 0x000fe400078e00ffULL,
0xffffffffff567424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff527224ULL, 0x004fe200078e0003ULL, 0xffffd92000007947ULL, 0x000fea000383ffffULL,
0x0180000006037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003097812ULL, 0x000fc800078ec0ffULL, 0x018000000900780cULL, 0x000fda0003f05070ULL,
0x0000000600038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0900720cULL, 0x040fe40003f25070ULL, 0x008000000900780cULL, 0x000fe40003f02070ULL,
0x00000001ff0e7807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x000000030eff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000006067812ULL, 0x002fe400078ec0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x000000030eff7212ULL, 0x000fda000780c0ffULL,
0x0080000006030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0006ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000600037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff0d7424ULL, 0x000fc800078e00ffULL,
0xfffe58f00c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff4f7424ULL, 0x000fe200078e00ffULL,
0x0000005600007348ULL, 0x000fe80003800000ULL, 0x0c0000500b037389ULL, 0x0002a200000e0003ULL,
0xfffe58b04e007950ULL, 0x000fea0003c3ffffULL, 0x0000002b00007348ULL, 0x000fe80003800000ULL,
0x000000292a297389ULL, 0x0002a400000e006cULL, 0x000000ffff2a7224ULL, 0x002fc400078e0028ULL,
0x00000000ff2b7424ULL, 0x000fc800078e00ffULL, 0xfffe58602a007950ULL, 0x000fea0003c3ffffULL,
0x000000012800780cULL, 0x000fe20003f45070ULL, 0x0000002a00007348ULL, 0x000fe80003800000ULL,
0x00000000ff2b7424ULL, 0x000fd000078e00ffULL, 0x0000000000287806ULL, 0x000fc800050e0100ULL,
0x0000002a28287212ULL, 0x000fe200078ec0ffULL, 0x000000ffff2a7224ULL, 0x000fc800078e0029ULL,
0xfffe57f02a007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000100000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x00000000000004c4ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000620ULL,
0x0000000000000240ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000860ULL,
0x0000000000000340ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ba0ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c60ULL,
0x00000000000006c0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001320ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001330ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000013c0ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000013c4ULL,
0x00000000000001b8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001580ULL,
0x000000000001a900ULL, 0xd800001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001be80ULL,
0x0000000000000038ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001bec0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001c240ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000013c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001aac0ULL,
0x000000000001aac0ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001be80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001c240ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_0_m_32_sm_80_cubin_len = 115488;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
