/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_0_m_32_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001aac0ULL, 0x000000000001a740ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL,
0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL,
0x616e7265746e695fULL, 0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL,
0x705f796c66625f63ULL, 0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL,
0x6c6668735f30376dULL, 0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL,
0x616475635f5f245fULL, 0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL,
0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL,
0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL,
0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000028ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b00220000036fULL, 0x0000000000018e60ULL, 0x0000000000000170ULL, 0x000b0022000003a2ULL,
0x0000000000018fd0ULL, 0x0000000000000040ULL, 0x000b0022000003cdULL, 0x0000000000019010ULL,
0x0000000000000050ULL, 0x000b0022000003f7ULL, 0x0000000000019060ULL, 0x0000000000000120ULL,
0x000a000300000465ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000485ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004b5ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000019180ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00018e6000000000ULL, 0x0000040400000000ULL, 0x810c000001500400ULL,
0x0062380400288080ULL, 0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808c92ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x00018e6000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808c0828808081ULL, 0x8f082880808e0828ULL, 0x2880809008288080ULL,
0x8092082880809108ULL, 0x0828808095082880ULL, 0x8080a0082880809dULL, 0xa608288080a10828ULL,
0x288080a808288080ULL, 0x80ec08288080aa08ULL, 0x08288080ed082880ULL, 0x80828016288080d0ULL,
0x0000000000031028ULL, 0x288080d092000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x000000e000000000ULL, 0x00018fd000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808c0828808081ULL, 0x8f082880808e0828ULL, 0x2880809008288080ULL,
0x8092082880809108ULL, 0x0828808095082880ULL, 0x8080a0082880809dULL, 0xa608288080a10828ULL,
0x288080a908288080ULL, 0x80ec08288080aa08ULL, 0x08288080ed082880ULL, 0x80828016288080a8ULL,
0x0000000000031028ULL, 0x288080a892000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL,
0x000001a000000000ULL, 0x0001901000000000ULL, 0x0000005000000000ULL, 0x0000100400000000ULL,
0x80aa288080a80900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0x8f082880808e0828ULL, 0x2880809008288080ULL, 0x8092082880809108ULL, 0x0828808095082880ULL,
0x8080a0082880809dULL, 0xa608288080a10828ULL, 0x288080a808288080ULL, 0x80ec08288080aa08ULL,
0x08288080ed082880ULL, 0x80828016288080a9ULL, 0x0000000000031028ULL, 0x288080a992000000ULL,
0x0000000000002200ULL, 0x0000002cffffffffULL, 0x0000027000000000ULL, 0x0001906000000000ULL,
0x0000012000000000ULL, 0x0000080400000000ULL, 0x80aa288080a90900ULL, 0x0000000000002880ULL,
0x0000001700082f04ULL, 0x00082304000000d6ULL, 0x0000000000000013ULL, 0x0000001300081204ULL,
0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL,
0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000011ULL,
0x0000001100081204ULL, 0x0008110400000000ULL, 0x0000000000000011ULL, 0x0000001000082304ULL,
0x0008120400000000ULL, 0x0000000000000010ULL, 0x0000001000081104ULL, 0x0008230400000000ULL,
0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0058016000000014ULL, 0x000c170400581903ULL,
0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040021f000ULL,
0x0040000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040061f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00000ab000043104ULL, 0xffffffff01cc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000002d001cc2804ULL,
0x0000052000000380ULL, 0x00002b6000001b80ULL, 0x00002d3000002c20ULL, 0x0000301000002ea0ULL,
0x0000338000003170ULL, 0x000033d0000033c0ULL, 0x00003ce000003400ULL, 0x00004c7000004bd0ULL,
0x00004f0000004d90ULL, 0x000051d000005070ULL, 0x00005410000053d0ULL, 0x0000545000005420ULL,
0x000069d000005b10ULL, 0x00006b9000006a70ULL, 0x00006e7000006d00ULL, 0x000071e000006fd0ULL,
0x0000723000007220ULL, 0x0000790000007260ULL, 0x000088b000008810ULL, 0x00008b40000089d0ULL,
0x00008e1000008cb0ULL, 0x0000906000009020ULL, 0x000090a000009070ULL, 0x0000987000009860ULL,
0x0000989000009880ULL, 0x0000c6b00000c620ULL, 0x0000c7100000c6e0ULL, 0x0000d2800000d250ULL,
0x0000d2e00000d2b0ULL, 0x00016be000016ba0ULL, 0x00016c0000016bf0ULL, 0x00016c8000016c60ULL,
0x00016ca000016c90ULL, 0x0001803000017fe0ULL, 0x000180c000018080ULL, 0x0001814000018100ULL,
0x000181e000018190ULL, 0x0001828000018230ULL, 0x00018320000182d0ULL, 0x000183b000018370ULL,
0x00018430000183f0ULL, 0x000184d000018480ULL, 0x0001857000018520ULL, 0x00018610000185c0ULL,
0x000186a000018660ULL, 0x00018720000186e0ULL, 0x000187c000018770ULL, 0x0001886000018810ULL,
0x00018900000188b0ULL, 0x0001899000018950ULL, 0x00018a10000189d0ULL, 0x00018ab000018a60ULL,
0x00018b5000018b00ULL, 0x00018bf000018ba0ULL, 0x00018cb000018c50ULL, 0x00018d7000018d10ULL,
0x00018e3000018dd0ULL, 0x000003e002003904ULL, 0x00016600000000ffULL, 0x00000410003f0100ULL,
0x000166080000000bULL, 0x00000470003f0120ULL, 0x000166880000000bULL, 0x00000ac0003f0120ULL,
0x00016600000000ffULL, 0x00000c30003f0107ULL, 0x0001668c00000007ULL, 0x00000cc0003f0102ULL,
0x0001668800000007ULL, 0x00002840003f0101ULL, 0x0001660800000016ULL, 0x00002880003f0101ULL,
0x0001660c0000000cULL, 0x00002a50003f0105ULL, 0x0001660c0000000cULL, 0x00003ca0003f0105ULL,
0x000166880000001dULL, 0x000048f0003f0101ULL, 0x0001662800000028ULL, 0x00004930003f0101ULL,
0x0001662c0000002aULL, 0x00004b00003f0105ULL, 0x0001662c0000002aULL, 0x00005ad0003f0105ULL,
0x0000000000000028ULL, 0x00006710003f0101ULL, 0x0001664800000026ULL, 0x00006730003f0101ULL,
0x0001664c00000026ULL, 0x00006900003f0105ULL, 0x0001664c00000026ULL, 0x000078e0003f0105ULL,
0x0000000000000021ULL, 0x00008560003f0101ULL, 0x0001666800000024ULL, 0x00008580003f0101ULL,
0x0001666c00000024ULL, 0x00008750003f0105ULL, 0x0001666c00000024ULL, 0x000096d0003f0105ULL,
0x000166a00000000bULL, 0x0000ece0003f0101ULL, 0x00016600000000ffULL, 0x0000f8b0003f0101ULL,
0x00016604000000ffULL, 0x0000fa80003f0105ULL, 0x00016604000000ffULL, 0x00013e90003f0105ULL,
0x0000000000000098ULL, 0x000141a0003f0101ULL, 0x0000000400000098ULL, 0x00014370003f0105ULL,
0x0000000400000098ULL, 0x00017e40003f0105ULL, 0x0001660800000097ULL, 0x00017ea0003f0101ULL,
0x0001661000000097ULL, 0x00017f00003f0101ULL, 0x0001661800000097ULL, 0x00017f70003f0101ULL,
0x0001662000000097ULL, 0x00033803003f0101ULL, 0x0000e0f000301c04ULL, 0x0000e2f00000e120ULL,
0x0000e5b00000e450ULL, 0x0000e8700000e710ULL, 0x0000eb600000e9d0ULL, 0x0000fae00000ec60ULL,
0x0000040100017fb0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000031cULL, 0x0000001700000002ULL,
0x000000000000024cULL, 0x0000001700000002ULL, 0x000000000000018cULL, 0x0000001700000002ULL,
0x00000000000000ccULL, 0x0000001700000002ULL, 0x0000000000000044ULL, 0x0000001700000002ULL,
0x00000000000002f3ULL, 0x0000001700000002ULL, 0x0000000000000223ULL, 0x0000001700000002ULL,
0x0000000000000163ULL, 0x0000001700000002ULL, 0x00000000000000a8ULL, 0x0000001700000002ULL,
0x0000000000016700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff147624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000f7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a0014847a19ULL, 0x000fe200000006ffULL,
0x00000000000579c3ULL, 0x000f220000002500ULL, 0x0000000000077919ULL, 0x000ea20000002100ULL,
0x0000460000087ab9ULL, 0x000fc60000000a00ULL, 0x0000000000137919ULL, 0x000ea20000002700ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003817a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a81ULL, 0x0000040003007624ULL, 0x000fca00078e0214ULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000181810810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000181811810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff81aa12ULL, 0x000fc800078e33ffULL,
0x0000008100007306ULL, 0x000e620000209000ULL, 0x000000ff8100720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000381047224ULL, 0x004fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x0000000000047919ULL, 0x000ee40000002200ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x00000006030a7227ULL, 0x000fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a0aULL,
0x0000000081007224ULL, 0x000fca00078e0206ULL, 0x000000810000720cULL, 0x000fe20003f06070ULL,
0x000001000f027a24ULL, 0x008fe400078e0204ULL, 0x00001fff0f0f7589ULL, 0x000fe400000e0000ULL,
0x00000000020b7a24ULL, 0x000fca00078e0207ULL, 0x000000ff0b00720cULL, 0x000fc60003f65270ULL,
0x0000000100000824ULL, 0x000fe200078e0a81ULL, 0x000000010a0a0810ULL, 0x000fe40007ffe0ffULL,
0x0000000f0b00780cULL, 0x040fe40003f84070ULL, 0x000000810000720cULL, 0x000fe40003f26070ULL,
0x000000030b00780cULL, 0x000fe40003f04070ULL, 0x00000005ff007819ULL, 0x000fe20000011607ULL,
0x3fffff80ff02b424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03b424ULL, 0x000fc600078e00ffULL,
0x00001fff00007589ULL, 0x000e6200000e0000ULL, 0x3fffffc0ff04c424ULL, 0x000fe400078e00ffULL,
0x000000010a0a1810ULL, 0x000fe20007ffe0ffULL, 0x7fffffc0ff05c424ULL, 0x000fe200078e00ffULL,
0x00000081ff0aa212ULL, 0x000fe200078e33ffULL, 0x7fffff60ff098424ULL, 0x000fe200078e00ffULL,
0x01660002ff00b388ULL, 0x0009e20000000a00ULL, 0x0000007f0b00780cULL, 0x000fe40003f24070ULL,
0x000000ffff087224ULL, 0x000fe200078e0a0aULL, 0x016608040b00c388ULL, 0x0003e20000008a00ULL,
0x00005a000a807a19ULL, 0x000fc400000006ffULL, 0x0000000881817224ULL, 0x000fe400078e0206ULL,
0x3fffff60ff088424ULL, 0x000fe400078e00ffULL, 0x0000002081077824ULL, 0x000fe400078e00ffULL,
0x00000005ff037e24ULL, 0x010fe2000f8e00ffULL, 0x016688080b008388ULL, 0x0005e20000008a00ULL,
0xff317217ff069424ULL, 0x000fe200078e00ffULL, 0x0000000407027c10ULL, 0x000fe2000fffe1ffULL,
0x000000040f047824ULL, 0x002fe200078e0200ULL, 0x0000000407007c0cULL, 0x000fe2000bf03070ULL,
0x0000580013057a24ULL, 0x000fe200078e02ffULL, 0x0000002002027817ULL, 0x000fe20003800000ULL,
0x016400060b009388ULL, 0x000fe40000004800ULL, 0x0000008405057224ULL, 0x000fe200078e0280ULL,
0x000000ff02027207ULL, 0x000fe20000000000ULL, 0x0000000404097824ULL, 0x004fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000200200780cULL, 0x000fda0003f05270ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe20000000000ULL, 0x0000000902067217ULL, 0x000fe20007800000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe4000800063fULL,
0x0000000106067824ULL, 0x000fe200078e0a09ULL, 0x00000004ff087819ULL, 0x002fc80000011604ULL,
0x00000002080d7810ULL, 0x040fe20007ffe0ffULL, 0x00000001090e7824ULL, 0x000fe200078e0208ULL,
0x000000060800720cULL, 0x080fe40003f06070ULL, 0x000000060d00720cULL, 0x000fe20003f26070ULL,
0x0000000109107824ULL, 0x000fe400078e020dULL, 0x00000001070b7824ULL, 0x040fe400078e020eULL,
0x0000000107117824ULL, 0x000fe400078e0210ULL, 0x000000010e067824ULL, 0x000fe200078e0204ULL,
0x000000040b0c7c12ULL, 0x000fe2000f8e30ffULL, 0x0000001010157824ULL, 0x000fe200078e00ffULL,
0x0000000411127c12ULL, 0x000fc4000f8e30ffULL, 0x00005a00ff0b7a19ULL, 0x000fe2000001160bULL,
0x00000001050c7824ULL, 0x040fe200078e020cULL, 0x00005a00ff117a19ULL, 0x000fe20000011611ULL,
0x0000000105127824ULL, 0x000fe400078e0212ULL, 0x000000840b087224ULL, 0x080fe400078e020cULL,
0x00000010040b7824ULL, 0x000fe400078e00ffULL, 0x00000084110c7224ULL, 0x000fe400078e0212ULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x000000f00b057812ULL, 0x000fc600078ec0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000508087212ULL, 0x000fc600078efcffULL,
0x000000100e117824ULL, 0x000fe200078e00ffULL, 0x000000050c057212ULL, 0x000fe200078efcffULL,
0x00000001100e7824ULL, 0x000fe200078e0204ULL, 0x00005e0008087a10ULL, 0x000fe40007f5e0ffULL,
0xfffffff011067812ULL, 0x000fe400078ee206ULL, 0xfffffff0150e7812ULL, 0x000fe400078ee20eULL,
0x00005e00050c7a10ULL, 0x000fe20007f7e0ffULL, 0x0000001006057824ULL, 0x000fe200078e00ffULL,
0x00005f0009097a10ULL, 0x000fe200017fe4ffULL, 0x000000100e117824ULL, 0x000fe200078e00ffULL,
0x00005f000d0d7a10ULL, 0x000fc60001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008057faeULL, 0x0003e8000c101c48ULL, 0x000000000c117faeULL, 0x0003e2000c901c48ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x0000000904067211ULL, 0x002fc800078fe0ffULL,
0x00000002060e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000107087824ULL, 0x000fc800078e0206ULL,
0x00000001070b7824ULL, 0x000fe200078e020eULL, 0x00000004080c7c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff097a19ULL, 0x000fe40000011608ULL, 0x000000040b107c12ULL, 0x000fe2000f8e30ffULL,
0x00000001050c7824ULL, 0x000fc800078e020cULL, 0x0000000105107824ULL, 0x000fe200078e0210ULL,
0x00005a00ff057a19ULL, 0x000fe2000001160bULL, 0x0000008409097224ULL, 0x080fe400078e020cULL,
0x00000010040b7824ULL, 0x000fe400078e00ffULL, 0x0000008405057224ULL, 0x000fe400078e0210ULL,
0x0000010009087825ULL, 0x000fe200078e00ffULL, 0x000000f00b117812ULL, 0x000fc600078ec0ffULL,
0x00000100050c7825ULL, 0x000fe200078e00ffULL, 0x0000001108087212ULL, 0x000fc600078efcffULL,
0x0000000106057824ULL, 0x100fe200078e0204ULL, 0x000000110c0c7212ULL, 0x000fe200078efcffULL,
0x0000001006107824ULL, 0x000fe200078e00ffULL, 0x00005e0008087a10ULL, 0x000fe20007f1e0ffULL,
0x000000010e067824ULL, 0x000fe200078e0204ULL, 0x00005e000c0c7a10ULL, 0x000fe20007f3e0ffULL,
0x000000100e117824ULL, 0x000fe200078e00ffULL, 0xfffffff010057812ULL, 0x000fe400078ee205ULL,
0x00005f0009097a10ULL, 0x000fe400007fe4ffULL, 0xfffffff011067812ULL, 0x000fe200078ee206ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x00005f000d0d7a10ULL, 0x000fc60000ffe4ffULL,
0x0000001006117824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008057faeULL, 0x0003e8000b901c48ULL, 0x000000000c117faeULL, 0x0003e4000b901c48ULL,
0x0000000000097919ULL, 0x002e620000000000ULL, 0x0000000000057806ULL, 0x000fc600038e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000500067300ULL, 0x000e7000000e0000ULL,
0x0000000500087309ULL, 0x000ea20000000000ULL, 0x000000090600720cULL, 0x002fe20003f02070ULL,
0x000000ffff067224ULL, 0x004fc400078e0a08ULL, 0x00000004ff087424ULL, 0x000fc800078e00ffULL,
0x0000640013087625ULL, 0x000fcc00078e0008ULL, 0x01660406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01660000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000808057981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0f00720cULL, 0x000fe40003f05270ULL,
0x000000ff05067810ULL, 0x006fc80007ffe0ffULL, 0x00000008ff067819ULL, 0x000fce0000011606ULL,
0x0000e08000008947ULL, 0x000fea0003800000ULL, 0x0000000213087824ULL, 0x000fe400078e00ffULL,
0x0000000800077824ULL, 0x000fe400078e00ffULL, 0x00000003ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01668c0c07ff738cULL, 0x0003e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000001030d7810ULL, 0x000fe20007ffe0ffULL,
0x0000590008097624ULL, 0x000fe200078e0214ULL, 0x00000001ff217819ULL, 0x000fe20000011600ULL,
0x0166880007ff7f8cULL, 0x0005e2000c80043fULL, 0x000000060d00720cULL, 0x000fe20003f06070ULL,
0x000000010a097824ULL, 0x000fe200078e0209ULL, 0x00000001000a7812ULL, 0x000fe200078ec0ffULL,
0x0000002021087824ULL, 0x000fc800078e00ffULL, 0x0000010003107824ULL, 0x000fc800078e0208ULL,
0x00006600092d7a24ULL, 0x000fe400078e0210ULL, 0x0000064000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1a7819ULL, 0x004fe40000011604ULL, 0x00000010050c7217ULL, 0x002fe40007800000ULL,
0x000000041a0e7810ULL, 0x040fe40007ffe0ffULL, 0x000000081a127810ULL, 0x000fe20007ffe0ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0a10ULL, 0x0000000c1a137810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0d7824ULL, 0x100fe200078e0204ULL, 0x000000101a187810ULL, 0x000fe20007ffe0ffULL,
0x000000080e147824ULL, 0x000fe200078e00ffULL, 0x000000141a1e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001120f7824ULL, 0x000fc400078e0204ULL, 0x0000000812167824ULL, 0x000fe200078e00ffULL,
0xfffffff8141f7812ULL, 0x000fe200078ee20dULL, 0x0000000113107824ULL, 0x000fe200078e0204ULL,
0x000000700b0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000813257824ULL, 0x000fe200078e00ffULL,
0x000000200c0b7817ULL, 0x000fe20003800000ULL, 0x000000012d117824ULL, 0x040fe200078e020eULL,
0xfffffff816237812ULL, 0x000fe200078ee20fULL, 0x000000800a0c7824ULL, 0x000fe200078e020dULL,
0x0000000b0e00720cULL, 0x080fe20003f86070ULL, 0x000000012d0f7824ULL, 0x000fe200078e021aULL,
0xfffffff825257812ULL, 0x000fe200078ee210ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x0000000b1200720cULL, 0x080fe20003f66070ULL, 0x0000000118157824ULL, 0x000fe200078e0204ULL,
0x0000000b1300720cULL, 0x080fe20003f46070ULL, 0x000001000f0e7825ULL, 0x000fe200078e000cULL,
0x0000000b1a00720cULL, 0x000fc60003fa6070ULL, 0x00000008181c7824ULL, 0x000fe200078e00ffULL,
0x000062000e147a10ULL, 0x000fe20007f1e0ffULL, 0x0000010011107825ULL, 0x000fc600078e000cULL,
0xfffffff81c277812ULL, 0x000fe200078ee215ULL, 0x000000011e177824ULL, 0x000fe200078e0204ULL,
0x0000620010167a10ULL, 0x000fe20007f3e0ffULL, 0x000000081e207824ULL, 0x000fe200078e00ffULL,
0x000063000f157a10ULL, 0x000fe200007fe4ffULL, 0x000000012d0f7824ULL, 0x000fe400078e0212ULL,
0x000000011a127824ULL, 0x000fe200078e0204ULL, 0xfffffff820297812ULL, 0x000fe200078ee217ULL,
0x000001000f0e7825ULL, 0x000fe200078e000cULL, 0x0000630011177a10ULL, 0x000fc40000ffe4ffULL,
0x0000000b1800720cULL, 0x080fe20003f26070ULL, 0x000000012d117824ULL, 0x040fe200078e0213ULL,
0x00000007121b7812ULL, 0x000fe200078ec0ffULL, 0x000000012d137824ULL, 0x000fe200078e0218ULL,
0x000062000e187a10ULL, 0x000fe20007f1e0ffULL, 0x0000010011107825ULL, 0x000fe200078e000cULL,
0x0ffffff81b1b7812ULL, 0x000fe400078ef804ULL, 0x000063000f197a10ULL, 0x000fe200007fe4ffULL,
0x00000002211c7824ULL, 0x000fe200078e020aULL, 0x0000620010107a10ULL, 0x000fe20007fde0ffULL,
0x0000010013127825ULL, 0x000fe200078e000cULL, 0x0000000b1e00720cULL, 0x000fc40003f06070ULL,
0x0000e0001c1c7811ULL, 0x000fe200078e68ffULL, 0x000000012d0f7824ULL, 0x000fe200078e021eULL,
0x0000630011117a10ULL, 0x000fe400037fe4ffULL, 0x0000620012127a10ULL, 0x000fe20007fde0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e000cULL, 0x000000181a1e7810ULL, 0x040fe40007ffe0ffULL,
0x0000630013137a10ULL, 0x000fe200037fe4ffULL, 0x000000101b1d7824ULL, 0x100fe200078e021cULL,
0x0000001c1a207810ULL, 0x000fe20007ffe0ffULL, 0x000000101f1f7824ULL, 0x000fe200078e021cULL,
0x000062000e1a7a10ULL, 0x000fe20007fde0ffULL, 0x000000012d2b7824ULL, 0x040fe200078e021eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e2000e901c48ULL,
0x0000000b1e00720cULL, 0x080fe20003fa6070ULL, 0x000000012d2d7824ULL, 0x000fe200078e0220ULL,
0x000063000f1b7a10ULL, 0x000fe200037fe4ffULL, 0x00000000161f7faeULL, 0x0005e2000e101c48ULL,
0x000001002b0e7825ULL, 0x000fe200078e000cULL, 0x0000000b2000720cULL, 0x000fc60003f86070ULL,
0x000000011e0b7824ULL, 0x100fe200078e0204ULL, 0x000062000e0e7a10ULL, 0x000fe20007fde0ffULL,
0x000000081e1e7824ULL, 0x000fe400078e00ffULL, 0x0000000120147824ULL, 0x042fe200078e0204ULL,
0x000063000f0f7a10ULL, 0x000fe200037fe4ffULL, 0x0000000820157824ULL, 0x000fe200078e00ffULL,
0xfffffff81e0b7812ULL, 0x000fe200078ee20bULL, 0x000001002d0c7825ULL, 0x000fc600078e000cULL,
0xfffffff815157812ULL, 0x000fe200078ee214ULL, 0x0000001023237824ULL, 0x100fe200078e021cULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x0000001025257824ULL, 0x100fe400078e021cULL,
0x0000001027277824ULL, 0x100fe200078e021cULL, 0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x0000001029297824ULL, 0x100fe200078e021cULL, 0x0000000018237faeULL, 0x0005e2000d901c48ULL,
0x000000100b0b7824ULL, 0x100fe400078e021cULL, 0x0000001015157824ULL, 0x000fe200078e021cULL,
0x0000000010257faeULL, 0x0005e8000d101c48ULL, 0x0000000012277faeULL, 0x0005e8000c901c48ULL,
0x000000001a297faeULL, 0x0005e8000c101c48ULL, 0x000000000e0b7faeULL, 0x0005e8000e901c48ULL,
0x000000000c157faeULL, 0x0005e2000e101c48ULL, 0x0000057000007947ULL, 0x000fea0003800000ULL,
0x00000004040d7811ULL, 0x044fe400078fe8ffULL, 0x0000000804117811ULL, 0x000fc400078fe8ffULL,
0x0000001404177811ULL, 0x040fe200078fe8ffULL, 0x000000010d0c7824ULL, 0x142fe200078e0204ULL,
0x0000000c04137811ULL, 0x040fe200078fe8ffULL, 0x000000080d0f7824ULL, 0x000fe200078e00ffULL,
0x0000001804197811ULL, 0x040fe200078fe8ffULL, 0x00000001110e7824ULL, 0x040fe400078e0204ULL,
0x0000000811157824ULL, 0x000fe200078e00ffULL, 0xfffffff80f1c7812ULL, 0x000fe200078ee20cULL,
0x00000001170f7824ULL, 0x040fe400078e0204ULL, 0x0000000817247824ULL, 0x000fe200078e00ffULL,
0xfffffff8151e7812ULL, 0x000fe200078ee20eULL, 0x00000001130c7824ULL, 0x140fe200078e0204ULL,
0x0000001004157811ULL, 0x000fe200078fe8ffULL, 0x00000008131b7824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee20fULL, 0x0000000119107824ULL, 0x000fe200078e0204ULL,
0x000000700b0f7812ULL, 0x000fe200078ec0ffULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81b207812ULL, 0x000fe200078ee20cULL, 0x00000001150e7824ULL, 0x040fe200078e0204ULL,
0x0000001c041b7811ULL, 0x000fe200078fe8ffULL, 0x00000008151d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f267812ULL, 0x000fe200078ee210ULL, 0x000000800a1a7824ULL, 0x000fe200078e020fULL,
0x00000004040b7211ULL, 0x040fe200078fe8ffULL, 0x000000012d0f7824ULL, 0x000fe200078e020dULL,
0xfffffff81d227812ULL, 0x000fe200078ee20eULL, 0x000000011b0c7824ULL, 0x040fe200078e0204ULL,
0x0000002d040d7211ULL, 0x000fe200078fe8ffULL, 0x000000081b1f7824ULL, 0x000fe200078e00ffULL,
0x000000070b0b7812ULL, 0x000fe200078ec0ffULL, 0x00000002210e7824ULL, 0x000fc400078e020aULL,
0x000000012d1d7824ULL, 0x000fe200078e021bULL, 0xfffffff81f287812ULL, 0x000fe200078ee20cULL,
0x000000ffff1b7224ULL, 0x000fe200078e00ffULL, 0x0000e0000e2b7811ULL, 0x000fe200078e68ffULL,
0x000000012d117824ULL, 0x000fe200078e0211ULL, 0x0ffffff80b0b7812ULL, 0x000fe200078ef804ULL,
0x000000012d137824ULL, 0x000fe400078e0213ULL, 0x000001000d0c7825ULL, 0x000fc800078e001aULL,
0x000000012d157824ULL, 0x000fe200078e0215ULL, 0x000062000c0c7a10ULL, 0x000fe20007f1e0ffULL,
0x000001000f0e7825ULL, 0x000fc600078e001aULL, 0x000063000d0d7a10ULL, 0x000fe200007fe4ffULL,
0x000000012d177824ULL, 0x000fe200078e0217ULL, 0x000062000e0e7a10ULL, 0x000fe20007f3e0ffULL,
0x0000010011107825ULL, 0x000fc600078e001aULL, 0x000063000f0f7a10ULL, 0x000fe20000ffe4ffULL,
0x000000012d197824ULL, 0x000fe200078e0219ULL, 0x0000620010107a10ULL, 0x000fe20007f5e0ffULL,
0x0000010013127825ULL, 0x000fc600078e001aULL, 0x0000630011117a10ULL, 0x000fe200017fe4ffULL,
0x0000010015147825ULL, 0x000fe200078e001aULL, 0x0000620012127a10ULL, 0x000fc60007f7e0ffULL,
0x0000010017167825ULL, 0x100fe200078e001aULL, 0x0000620014147a10ULL, 0x000fe40007f1e0ffULL,
0x0000630013137a10ULL, 0x000fe20001ffe4ffULL, 0x0000010019187825ULL, 0x100fe200078e001aULL,
0x0000620016167a10ULL, 0x000fe40007f3e0ffULL, 0x0000630015157a10ULL, 0x000fe200007fe4ffULL,
0x000001001d1a7825ULL, 0x000fe200078e001aULL, 0x0000620018187a10ULL, 0x000fe40007f5e0ffULL,
0x0000630017177a10ULL, 0x000fe20000ffe4ffULL, 0x000000100b0b7824ULL, 0x100fe200078e022bULL,
0x000062001a1a7a10ULL, 0x000fe20007f7e0ffULL, 0x000000101c1d7824ULL, 0x100fe200078e022bULL,
0x0000630019197a10ULL, 0x000fe200017fe4ffULL, 0x000000101e1f7824ULL, 0x100fe200078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0b7faeULL, 0x0003e2000b901c48ULL,
0x0000001020237824ULL, 0x100fe200078e022bULL, 0x000063001b1b7a10ULL, 0x000fe20001ffe4ffULL,
0x0000001022257824ULL, 0x100fe200078e022bULL, 0x000000000e1d7faeULL, 0x0003e2000b901c48ULL,
0x0000001024277824ULL, 0x000fc400078e022bULL, 0x0000001026297824ULL, 0x100fe200078e022bULL,
0x00000000101f7faeULL, 0x0003e2000b901c48ULL, 0x00000010282b7824ULL, 0x000fc600078e022bULL,
0x0000000012237faeULL, 0x0003e8000b901c48ULL, 0x0000000014257faeULL, 0x0003e8000b901c48ULL,
0x0000000016277faeULL, 0x0003e8000b901c48ULL, 0x0000000018297faeULL, 0x0003e8000b901c48ULL,
0x000000001a2b7faeULL, 0x0003e4000b901c48ULL, 0x000000060300720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff207424ULL, 0x000fe200078e00ffULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff257224ULL, 0x006fe200078e00ffULL,
0x0000000000687805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00007bc000000947ULL, 0x000fea0003800000ULL,
0xff317217ff207424ULL, 0x000fe400078e00ffULL, 0x000000ffff6b7224ULL, 0x000fc400078e00ffULL,
0x00000001030b7810ULL, 0x040fe20007ffe0ffULL, 0x0000010003267824ULL, 0x000fe200078e0208ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000060b00720cULL, 0x000fe40003f06070ULL,
0x00000040260c7810ULL, 0x000fca0007ffe0ffULL, 0x0000660009297a24ULL, 0x020fcc00078e020cULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1e7819ULL, 0x000fe40000011604ULL,
0x0000000c050b7217ULL, 0x000fe40007800000ULL, 0x000000041e147810ULL, 0x040fe20007ffe0ffULL,
0x000000011e137824ULL, 0x040fe200078e0229ULL, 0x000000081e167810ULL, 0x040fe20007ffe0ffULL,
0x000000010b0b7824ULL, 0x000fe200078e0a0cULL, 0x0000000c1e1a7810ULL, 0x000fe20007ffe0ffULL,
0x00000010040c7824ULL, 0x000fe200078e00ffULL, 0x000000141e287810ULL, 0x000fe20007ffe0ffULL,
0x0000000114127824ULL, 0x100fe200078e0204ULL, 0x000000101e247810ULL, 0x000fe20007ffe0ffULL,
0x0000000814277824ULL, 0x000fe200078e00ffULL, 0x000000700c237812ULL, 0x000fe200078ec0ffULL,
0x00000008162b7824ULL, 0x000fe200078e00ffULL, 0x000000200b0b7817ULL, 0x000fe20003800000ULL,
0x000000011a0c7824ULL, 0x000fe200078e0204ULL, 0xfffffff827277812ULL, 0x000fe200078ee212ULL,
0x0000000116127824ULL, 0x000fe200078e0204ULL, 0x0000000b1a00720cULL, 0x080fe20003f26070ULL,
0x000000800a227824ULL, 0x000fe200078e0223ULL, 0x0000000b1400720cULL, 0x080fe20003f86070ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee212ULL,
0x000000081a6d7824ULL, 0x000fe200078e00ffULL, 0x0000000b1e00720cULL, 0x040fe20003f66070ULL,
0x0000010013127825ULL, 0x000fe200078e0022ULL, 0x0000001c1e2a7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee20cULL, 0x0000000128157824ULL, 0x100fe200078e0204ULL,
0x0000620012187a10ULL, 0x000fe20007f1e0ffULL, 0x00000008281c7824ULL, 0x000fe400078e00ffULL,
0x00000001240c7824ULL, 0x040fe200078e0204ULL, 0x0000630013197a10ULL, 0x000fe200007fe4ffULL,
0x00000008246f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c717812ULL, 0x000fe200078ee215ULL,
0x0000000114137824ULL, 0x100fe200078e0229ULL, 0x0000000b1600720cULL, 0x000fe20003f06070ULL,
0x000000011a177824ULL, 0x100fe200078e0229ULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee20cULL,
0x0000000116157824ULL, 0x000fc400078e0229ULL, 0x000000011e1a7824ULL, 0x000fe400078e0204ULL,
0x0000010013127825ULL, 0x000fc600078e0022ULL, 0x000000071a1b7812ULL, 0x000fe200078ec0ffULL,
0x00000002210c7824ULL, 0x000fe200078e020aULL, 0x00006200121a7a10ULL, 0x000fe20007f5e0ffULL,
0x0000010015147825ULL, 0x000fe200078e0022ULL, 0x0ffffff81b1f7812ULL, 0x000fe400078ef804ULL,
0x0000f0000c0c7811ULL, 0x000fe200078e68ffULL, 0x0000010017167825ULL, 0x000fe200078e0022ULL,
0x00006200141c7a10ULL, 0x000fe40007fbe0ffULL, 0x00006300131b7a10ULL, 0x000fe200017fe4ffULL,
0x0000000124137824ULL, 0x000fe200078e0229ULL, 0x00006300151d7a10ULL, 0x000fe20002ffe4ffULL,
0x000000101f157824ULL, 0x100fe200078e020cULL, 0x0000620016167a10ULL, 0x000fe20007fde0ffULL,
0x0000001027277824ULL, 0x000fe200078e020cULL, 0x0000000b2400720cULL, 0x080fe20003f46070ULL,
0x0000010013127825ULL, 0x000fe200078e0022ULL, 0x000000181e247810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018157faeULL, 0x0003e2000d901c48ULL,
0x0000630017177a10ULL, 0x000fe200037fe4ffULL, 0x00000001281f7824ULL, 0x040fe200078e0229ULL,
0x0000000b2800720cULL, 0x080fe20003fa6070ULL, 0x000000001a277faeULL, 0x0005e2000e101c48ULL,
0x0000000b2400720cULL, 0x000fc40003f86070ULL, 0x00006200121e7a10ULL, 0x000fe40007fde0ffULL,
0x0000000b2a00720cULL, 0x000fe20003f66070ULL, 0x00000001240b7824ULL, 0x000fe400078e0229ULL,
0x000001001f147825ULL, 0x002fe200078e0022ULL, 0x00006300131f7a10ULL, 0x000fc600037fe4ffULL,
0x000001000b127825ULL, 0x000fe200078e0022ULL, 0x0000620014187a10ULL, 0x000fc60007fde0ffULL,
0x000000012a1b7824ULL, 0x044fe200078e0229ULL, 0x0000630015197a10ULL, 0x000fe200037fe4ffULL,
0x000000012a0b7824ULL, 0x100fe200078e0204ULL, 0x0000620012127a10ULL, 0x000fe20007fde0ffULL,
0x00000001241a7824ULL, 0x040fe400078e0204ULL, 0x0000000824297824ULL, 0x000fe200078e00ffULL,
0x0000630013137a10ULL, 0x000fe200037fe4ffULL, 0x000000082a2a7824ULL, 0x000fe400078e00ffULL,
0x000001001b147825ULL, 0x000fe200078e0022ULL, 0xfffffff829297812ULL, 0x000fc400078ee21aULL,
0xfffffff82a737812ULL, 0x000fe200078ee20bULL, 0x000000102b0b7824ULL, 0x100fe200078e020cULL,
0x0000620014147a10ULL, 0x000fe20007fde0ffULL, 0x000000106d1b7824ULL, 0x100fe400078e020cULL,
0x000000106f237824ULL, 0x100fe200078e020cULL, 0x0000630015157a10ULL, 0x000fe200037fe4ffULL,
0x0000001071277824ULL, 0x100fe200078e020cULL, 0x000000001c0b7faeULL, 0x0003e2000c101c48ULL,
0x0000001029297824ULL, 0x100fe400078e020cULL, 0x00000010732b7824ULL, 0x000fe200078e020cULL,
0x00000000161b7faeULL, 0x0003e8000c901c48ULL, 0x000000001e237faeULL, 0x0003e8000d101c48ULL,
0x0000000018277faeULL, 0x0003e8000e901c48ULL, 0x0000000012297faeULL, 0x0003e8000e101c48ULL,
0x00000000142b7faeULL, 0x0003e2000d901c48ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x0000000c04197811ULL, 0x040fe400078fe8ffULL, 0x0000000804177811ULL, 0x000fc400078fe8ffULL,
0x0000000404157811ULL, 0x040fe200078fe8ffULL, 0x0000000119127824ULL, 0x140fe200078e0204ULL,
0x00000010041b7811ULL, 0x040fe200078fe8ffULL, 0x00000008191d7824ULL, 0x000fe200078e00ffULL,
0x00000018041f7811ULL, 0x040fe200078fe8ffULL, 0x00000001170c7824ULL, 0x040fe200078e0204ULL,
0x0000001c04737811ULL, 0x040fe200078fe8ffULL, 0x0000000817137824ULL, 0x000fe200078e00ffULL,
0xfffffff81d187812ULL, 0x000fe200078ee212ULL, 0x00000001150b7824ULL, 0x040fe200078e0204ULL,
0x00000014041d7811ULL, 0x000fe200078fe8ffULL, 0x0000000815147824ULL, 0x000fe200078e00ffULL,
0xfffffff813167812ULL, 0x000fe200078ee20cULL, 0x000000081b1a7824ULL, 0x000fc400078e00ffULL,
0x000000011d0c7824ULL, 0x140fe200078e0204ULL, 0xfffffff814147812ULL, 0x000fe200078ee20bULL,
0x000000081d137824ULL, 0x000fe400078e00ffULL, 0x000000011b0b7824ULL, 0x100fe400078e0204ULL,
0x000000011f127824ULL, 0x000fe200078e0204ULL, 0xfffffff8131c7812ULL, 0x000fe200078ee20cULL,
0x000000081f237824ULL, 0x000fe200078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee20bULL,
0x0000000173137824ULL, 0x040fe200078e0204ULL, 0x00000004040c7211ULL, 0x040fe200078fe8ffULL,
0x0000000873247824ULL, 0x000fe200078e00ffULL, 0xfffffff8231e7812ULL, 0x000fe200078ee212ULL,
0x00000010040b7824ULL, 0x000fc400078e00ffULL, 0x0000000221127824ULL, 0x000fe200078e020aULL,
0xfffffff824247812ULL, 0x000fe200078ee213ULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x000000070c137812ULL, 0x000fe200078ec0ffULL, 0x0000000115157824ULL, 0x100fe200078e0229ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000117177824ULL, 0x100fe200078e0229ULL,
0x0ffffff8130c7812ULL, 0x000fe200078ef804ULL, 0x0000000119197824ULL, 0x000fe200078e0229ULL,
0x0000f00012757811ULL, 0x000fe200078e68ffULL, 0x000000800a227824ULL, 0x000fe200078e020bULL,
0x0000002904137211ULL, 0x000fe200078fe8ffULL, 0x000000011b1b7824ULL, 0x000fc400078e0229ULL,
0x000000011d1d7824ULL, 0x100fe400078e0229ULL, 0x000000011f1f7824ULL, 0x100fe400078e0229ULL,
0x0000000173737824ULL, 0x000fe400078e0229ULL, 0x0000001014277824ULL, 0x000fe400078e0275ULL,
0x0000010013127825ULL, 0x000fc800078e0022ULL, 0x0000001016297824ULL, 0x000fe200078e0275ULL,
0x0000620012127a10ULL, 0x000fe20007f1e0ffULL, 0x0000010015147825ULL, 0x000fc600078e0022ULL,
0x0000630013137a10ULL, 0x000fe200007fe4ffULL, 0x00000010182b7824ULL, 0x000fe200078e0275ULL,
0x0000620014147a10ULL, 0x000fe20007f3e0ffULL, 0x0000010017167825ULL, 0x000fc600078e0022ULL,
0x0000630015157a10ULL, 0x000fe20000ffe4ffULL, 0x0000010019187825ULL, 0x000fe200078e0022ULL,
0x0000620016167a10ULL, 0x000fc60007f5e0ffULL, 0x000000101a6d7824ULL, 0x100fe200078e0275ULL,
0x0000620018187a10ULL, 0x000fe20007f7e0ffULL, 0x000000101c6f7824ULL, 0x000fe200078e0275ULL,
0x0000630017177a10ULL, 0x000fe200017fe4ffULL, 0x000001001b1a7825ULL, 0x000fe200078e0022ULL,
0x0000630019197a10ULL, 0x000fc60001ffe4ffULL, 0x000000101e717824ULL, 0x000fe200078e0275ULL,
0x000062001a1a7a10ULL, 0x000fe20007f1e0ffULL, 0x000001001d1c7825ULL, 0x000fc600078e0022ULL,
0x000063001b1b7a10ULL, 0x000fe200007fe4ffULL, 0x000001001f1e7825ULL, 0x000fe200078e0022ULL,
0x000062001c1c7a10ULL, 0x000fc60007f3e0ffULL, 0x0000010073227825ULL, 0x000fe200078e0022ULL,
0x000062001e1e7a10ULL, 0x000fe40007f5e0ffULL, 0x000063001d1d7a10ULL, 0x000fe20000ffe4ffULL,
0x000000100c0b7824ULL, 0x100fe200078e0275ULL, 0x0000620022227a10ULL, 0x000fe20007f7e0ffULL,
0x0000001024757824ULL, 0x000fe200078e0275ULL, 0x000063001f1f7a10ULL, 0x000fe400017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000120b7faeULL, 0x0003e2000b901c48ULL,
0x0000630023237a10ULL, 0x000fc60001ffe4ffULL, 0x0000000014277faeULL, 0x0003e8000b901c48ULL,
0x0000000016297faeULL, 0x0003e8000b901c48ULL, 0x00000000182b7faeULL, 0x0003e8000b901c48ULL,
0x000000001a6d7faeULL, 0x0003e8000b901c48ULL, 0x000000001c6f7faeULL, 0x0003e8000b901c48ULL,
0x000000001e717faeULL, 0x0003e8000b901c48ULL, 0x0000000022757faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe0070b7812ULL, 0x002fc400078ec0ffULL,
0x00000010070c7812ULL, 0x000fca00078ec0ffULL, 0x000000010b0b7824ULL, 0x000fc800078e020cULL,
0x000000080a167824ULL, 0x000fe200078e020bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0166080016167f8cULL, 0x000e64000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x00000008070c7812ULL, 0x000fca00078ec0ffULL, 0x000000010b0c7824ULL, 0x000fca00078e020cULL,
0x01660c000c0b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x006fe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001412147210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011415ULL,
0x000000140b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff147224ULL, 0x000fca00000e0615ULL,
0x000000020b0b7819ULL, 0x000fc80000001214ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000118187810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01660c000c0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020000c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff137819ULL, 0x000fe20000011604ULL,
0x00000010040b7824ULL, 0x000fe400078e00ffULL, 0xffffffffff827424ULL, 0x000fe200078e00ffULL,
0xffffff800c127812ULL, 0x000fc400078ec0ffULL, 0x000000700b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c130c7812ULL, 0x000fc800078ec0ffULL, 0x000000120c127210ULL, 0x000fca0007ffe00bULL,
0x0160000012137984ULL, 0x000e680000000800ULL, 0x0162000012147984ULL, 0x0004e20000000800ULL,
0x000000201300720bULL, 0x002fe20003f1d000ULL, 0x000154627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000127806ULL, 0x004fc800000e0100ULL, 0x000000ff1200720cULL, 0x000fe20003f25270ULL,
0x0000077000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0020ULL, 0x0000001fff867424ULL, 0x000fc400078e00ffULL,
0xffffffffff837424ULL, 0x000fcc00078e00ffULL, 0x0000071000009947ULL, 0x000fea0003800000ULL,
0x00000002ff157819ULL, 0x000fe40000011600ULL, 0x000000201300720bULL, 0x000fe40003f54000ULL,
0x000000001500720cULL, 0x000fe20003f25270ULL, 0x000153f27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000157806ULL, 0x000fc400010e0100ULL, 0x0000008000179824ULL, 0x000fe200078e020bULL,
0x00000020131b7209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010c169824ULL, 0x000fca00078e0217ULL, 0x0164001b16009388ULL, 0x0003e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f25270ULL, 0x000005e000009947ULL, 0x000fea0003800000ULL,
0x000000201b167221ULL, 0x002fe20000010100ULL, 0x000000ff15ff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b16167820ULL, 0x000fcc0000410000ULL,
0x0000001600167308ULL, 0x000e640000000800ULL, 0x0000001625257220ULL, 0x002fe40000410000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe20000011604ULL,
0x000153327f007947ULL, 0x000fea000b800000ULL, 0x00001f2916297589ULL, 0x0002a400000e0000ULL,
0x000000292c2c7220ULL, 0x084fe20000410000ULL, 0x000000292d2d7220ULL, 0x080fe20000410000ULL,
0x0000002930307220ULL, 0x080fe20000410000ULL, 0x0000002931317220ULL, 0x080fe20000410000ULL,
0x0000002934347220ULL, 0x080fe20000410000ULL, 0x0000002935357220ULL, 0x080fe20000410000ULL,
0x0000002938387220ULL, 0x080fe20000410000ULL, 0x0000002939397220ULL, 0x080fe20000410000ULL,
0x000000293c3c7220ULL, 0x080fe20000410000ULL, 0x000000293d3d7220ULL, 0x080fe20000410000ULL,
0x0000002940407220ULL, 0x080fe20000410000ULL, 0x0000002941417220ULL, 0x080fe20000410000ULL,
0x0000002944447220ULL, 0x080fe20000410000ULL, 0x0000002945457220ULL, 0x080fe20000410000ULL,
0x0000002948487220ULL, 0x080fe20000410000ULL, 0x0000002949497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0015ff7812ULL, 0x000fe2000782c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x0000000804297811ULL, 0x000fe200078ff0ffULL, 0x000152027f007947ULL, 0x000fea000b800000ULL,
0x00001f2916297589ULL, 0x00046400000e0000ULL, 0x000000292e2e7220ULL, 0x086fe20000410000ULL,
0x000000292f2f7220ULL, 0x080fe20000410000ULL, 0x0000002932327220ULL, 0x080fe20000410000ULL,
0x0000002933337220ULL, 0x080fe20000410000ULL, 0x0000002936367220ULL, 0x080fe20000410000ULL,
0x0000002937377220ULL, 0x080fe20000410000ULL, 0x000000293a3a7220ULL, 0x080fe20000410000ULL,
0x000000293b3b7220ULL, 0x080fe20000410000ULL, 0x000000293e3e7220ULL, 0x080fe20000410000ULL,
0x000000293f3f7220ULL, 0x080fe20000410000ULL, 0x0000002942427220ULL, 0x080fe20000410000ULL,
0x0000002943437220ULL, 0x080fe20000410000ULL, 0x0000002946467220ULL, 0x080fe20000410000ULL,
0x0000002947477220ULL, 0x080fe20000410000ULL, 0x000000294a4a7220ULL, 0x080fe20000410000ULL,
0x000000294b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000015ff7812ULL, 0x000fe2000782c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x0000001004297811ULL, 0x000fe200078ff0ffULL,
0x000150d27f007947ULL, 0x000fea000b800000ULL, 0x00001f2916297589ULL, 0x00046400000e0000ULL,
0x000000294c4c7220ULL, 0x086fe20000410000ULL, 0x000000294d4d7220ULL, 0x080fe20000410000ULL,
0x0000002950507220ULL, 0x080fe20000410000ULL, 0x0000002951517220ULL, 0x080fe20000410000ULL,
0x0000002954547220ULL, 0x080fe20000410000ULL, 0x0000002955557220ULL, 0x080fe20000410000ULL,
0x0000002958587220ULL, 0x080fe20000410000ULL, 0x0000002959597220ULL, 0x080fe20000410000ULL,
0x000000295c5c7220ULL, 0x080fe20000410000ULL, 0x000000295d5d7220ULL, 0x080fe20000410000ULL,
0x0000002960607220ULL, 0x080fe20000410000ULL, 0x0000002961617220ULL, 0x080fe20000410000ULL,
0x0000002964647220ULL, 0x080fe20000410000ULL, 0x0000002965657220ULL, 0x080fe20000410000ULL,
0x0000002968687220ULL, 0x080fe20000410000ULL, 0x0000002969697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000015ff7812ULL, 0x000fda000782c0ffULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x0000001804297811ULL, 0x000fe200078ff0ffULL,
0x00014fb27f007947ULL, 0x000fea000b800000ULL, 0x00001f2916297589ULL, 0x00046400000e0000ULL,
0x000000294e4e7220ULL, 0x086fe20000410000ULL, 0x000000294f4f7220ULL, 0x080fe20000410000ULL,
0x0000002952527220ULL, 0x080fe20000410000ULL, 0x0000002953537220ULL, 0x080fe20000410000ULL,
0x0000002956567220ULL, 0x080fe20000410000ULL, 0x0000002957577220ULL, 0x080fe20000410000ULL,
0x000000295a5a7220ULL, 0x080fe20000410000ULL, 0x000000295b5b7220ULL, 0x080fe20000410000ULL,
0x000000295e5e7220ULL, 0x080fe20000410000ULL, 0x000000295f5f7220ULL, 0x080fe20000410000ULL,
0x0000002962627220ULL, 0x080fe20000410000ULL, 0x0000002963637220ULL, 0x080fe20000410000ULL,
0x0000002966667220ULL, 0x080fe20000410000ULL, 0x0000002967677220ULL, 0x080fe20000410000ULL,
0x000000296a6a7220ULL, 0x080fe20000410000ULL, 0x000000296b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000001512ff7212ULL, 0x000fda00078230ffULL,
0x8000001b13131221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b13131820ULL, 0x000fc80000410000ULL, 0x00000013000d1308ULL, 0x000e640000000800ULL,
0x0000000d14141220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000002514257221ULL, 0x008fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x0000000dff0e723eULL, 0x000fe400000000ffULL, 0x00000002ff117819ULL, 0x000fe40000011604ULL,
0x000054100e127816ULL, 0x000fe2000000000eULL, 0x00014de27f007947ULL, 0x000fea000b800000ULL,
0x00001f11120e7589ULL, 0x0002a400000e0000ULL, 0x0000000811297810ULL, 0x000fe20007ffe0ffULL,
0x00014e127f007947ULL, 0x000fea000b800000ULL, 0x0000001011137810ULL, 0x000fe20007ffe0ffULL,
0x00001f29120f7589ULL, 0x00066800000e0000ULL, 0x00001f1312107589ULL, 0x0006a400000e0000ULL,
0x0000001811297810ULL, 0x008fe20007ffe0ffULL, 0x00014e627f007947ULL, 0x000fea000b800000ULL,
0x00001f2912117589ULL, 0x0022e400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000421127824ULL, 0x042fe200078e00ffULL, 0x0000000804137812ULL, 0x000fe200078ec0ffULL,
0x0000040000157824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000221247824ULL, 0x000fe200078e020aULL, 0x00000004121d7812ULL, 0x000fe200078ec0ffULL,
0x0000029000007945ULL, 0x000fe20003800000ULL, 0x0000000713127812ULL, 0x000fe200078ef804ULL,
0x0000200024247824ULL, 0x000fe200078e00ffULL, 0x0000001d04147211ULL, 0x000fc400078fe0ffULL,
0x0000001012137812ULL, 0x040fe200078efcffULL, 0x0000000812167824ULL, 0x040fe200078e00ffULL,
0xfffff00015157812ULL, 0x000fe200078ec0ffULL, 0x0000000112197824ULL, 0x000fe200078e0214ULL,
0x0000001204177211ULL, 0x000fe200078fe0ffULL, 0x00000001141a7824ULL, 0x000fe200078e0213ULL,
0x0000a000151e7810ULL, 0x000fe20007ffe0ffULL, 0x00000008131f7824ULL, 0x000fe200078e00ffULL,
0xfffffff816197812ULL, 0x000fe200078ee219ULL, 0x0000000812217824ULL, 0x040fe200078e00ffULL,
0x0000000417187810ULL, 0x000fe20007ffe0ffULL, 0x0000000812237824ULL, 0x040fe200078e00ffULL,
0xfffffff81f1a7812ULL, 0x000fe200078ee21aULL, 0x00000008121f7824ULL, 0x000fe200078e00ffULL,
0x00000006171c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001019787824ULL, 0x100fe200078e021eULL,
0x0000000217147810ULL, 0x000fe20007ffe0ffULL, 0x000000101a287824ULL, 0x000fe200078e021eULL,
0xfffffff816167812ULL, 0x000fc400078ee217ULL, 0xfffffff81f177812ULL, 0x000fe200078ee218ULL,
0x000000007878783bULL, 0x000e620000000200ULL, 0xfffffff821187812ULL, 0x000fe400078ee21cULL,
0xfffffff823147812ULL, 0x000fe200078ee214ULL, 0x000000002828783bULL, 0x000ee20000000200ULL,
0x0000e000241c7810ULL, 0x000fca0007ffe0ffULL, 0x0000001016747824ULL, 0x100fe400078e021cULL,
0x0000001014707824ULL, 0x100fe400078e021cULL, 0x0000001017207824ULL, 0x000fe200078e021cULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000000e78787232ULL, 0x086fe40000000000ULL,
0x0000000e7a7a7232ULL, 0x000fe40000000000ULL, 0x0000000f79797232ULL, 0x080fe40000000000ULL,
0x0000000f7b7b7232ULL, 0x000fc40000000000ULL, 0x0000001028287232ULL, 0x088fe40000000000ULL,
0x000000102a2a7232ULL, 0x000fe40000000000ULL, 0x0000001129297232ULL, 0x080fe40000000000ULL,
0x000000112b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010186c7824ULL, 0x000fe200078e021cULL, 0x000000002020783bULL, 0x000f220000004200ULL,
0x000000021d1d7812ULL, 0x000fe200078efcffULL, 0x0000000813277824ULL, 0x000fe200078e00ffULL,
0x0000036000007945ULL, 0x000fe20003800000ULL, 0x000000007070783bULL, 0x000fe20000004200ULL,
0x0000001d041d7211ULL, 0x000fc600078fe0ffULL, 0x000000006c6c783bULL, 0x000ee40000004200ULL,
0x00000001121f7824ULL, 0x140fe400078e021dULL, 0x000000007474783bULL, 0x000ea20000004200ULL,
0x00000001131d7824ULL, 0x040fe200078e021dULL, 0x00000020783c723cULL, 0x092f70000000183cULL,
0x00000020285c723cULL, 0x008b6e000000185cULL, 0x0000000812207824ULL, 0x020fe200078e00ffULL,
0x0000006c7844723cULL, 0x000f620000001844ULL, 0x0000000813217824ULL, 0x000fc600078e00ffULL,
0xfffffff8201f7812ULL, 0x000fe400078ee21fULL, 0x0000001304207211ULL, 0x000fe400078fe0ffULL,
0x0000006c2864723cULL, 0x000b620000001864ULL, 0x000000101f1f7824ULL, 0x000fe200078e021eULL,
0xfffffff821217812ULL, 0x000fc800078ee220ULL, 0x000000001f7c783bULL, 0x0002e20000000200ULL,
0x00000008136c7824ULL, 0x060fe200078e00ffULL, 0x000000707834723cULL, 0x000f620000001834ULL,
0x00000008136d7824ULL, 0x000fc600078e00ffULL, 0xfffffff86c1d7812ULL, 0x000fc800078ee21dULL,
0x000000702854723cULL, 0x000b620000001854ULL, 0x000000101d1d7824ULL, 0x000fcc00078e021eULL,
0x0000000813707824ULL, 0x020fe200078e00ffULL, 0x000000227840723cULL, 0x080f700000001840ULL,
0x000000222860723cULL, 0x040b6e0000001860ULL, 0x0000000220227810ULL, 0x060fe20007ffe0ffULL,
0x00000074284c723cULL, 0x004f62000000184cULL, 0x0000000420237810ULL, 0x000fc40007ffe0ffULL,
0xfffffff827227812ULL, 0x000fe400078ee222ULL, 0xfffffff870237812ULL, 0x000fe400078ee223ULL,
0x0000000620207810ULL, 0x000fe20007ffe0ffULL, 0x000000762850723cULL, 0x000f640000001850ULL,
0x0000001023707824ULL, 0x000fe200078e021cULL, 0xfffffff86d207812ULL, 0x000fca00078ee220ULL,
0x000000722858723cULL, 0x040f700000001858ULL, 0x0000006e2868723cULL, 0x000b640000001868ULL,
0x000000001d28783bULL, 0x0202ac0000000200ULL, 0x00000074782c723cULL, 0x040b6e000000182cULL,
0x0000001022747824ULL, 0x120fe200078e021cULL, 0x000000767830723cULL, 0x040f700000001830ULL,
0x000000727838723cULL, 0x040f700000001838ULL, 0x0000006e7848723cULL, 0x000b6e0000001848ULL,
0x0000001021787824ULL, 0x020fe200078e021cULL, 0x0000008000008947ULL, 0x000fd60003800000ULL,
0x0000000e7c7c7232ULL, 0x08afe40000000000ULL, 0x0000000e7e7e7232ULL, 0x000fc40000000000ULL,
0x0000000f7d7d7232ULL, 0x080fe40000000000ULL, 0x0000000f7f7f7232ULL, 0x000fe40000000000ULL,
0x0000001028287232ULL, 0x084fe40000000000ULL, 0x000000102a2a7232ULL, 0x000fe40000000000ULL,
0x0000001129297232ULL, 0x080fe40000000000ULL, 0x000000112b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x00afea0003800000ULL, 0x00000010206c7824ULL, 0x000fe200078e021cULL,
0x000000007878783bULL, 0x000e620000004200ULL, 0x00000002001d7824ULL, 0x000fc600078e00ffULL,
0x000000007474783bULL, 0x000ee40000004200ULL, 0xfffffff81d1d7812ULL, 0x000fe400078ec0ffULL,
0x000000007070783bULL, 0x000f280000004200ULL, 0x000000006c6c783bULL, 0x000ea20000004200ULL,
0x000000787c2c723cULL, 0x042b70000000182cULL, 0x0000007a7c30723cULL, 0x040b700000001830ULL,
0x000000747c34723cULL, 0x048b700000001834ULL, 0x000000767c38723cULL, 0x040b700000001838ULL,
0x000000707c3c723cULL, 0x050b70000000183cULL, 0x000000727c40723cULL, 0x040b700000001840ULL,
0x0000006c7c44723cULL, 0x044b700000001844ULL, 0x0000006e7c48723cULL, 0x000b700000001848ULL,
0x00000078284c723cULL, 0x040b70000000184cULL, 0x0000007a2850723cULL, 0x040b700000001850ULL,
0x000000742854723cULL, 0x040b700000001854ULL, 0x000000762858723cULL, 0x040b700000001858ULL,
0x00000070285c723cULL, 0x040b70000000185cULL, 0x000000722860723cULL, 0x040b700000001860ULL,
0x0000006c2864723cULL, 0x040b700000001864ULL, 0x0000006e2868723cULL, 0x000b620000001868ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x00000001031f7810ULL, 0x000fe20007ffe0ffULL,
0x016688001dff7f8cULL, 0x0003e2000c80043fULL, 0x00000080261e7810ULL, 0x000fc40007ffe0ffULL,
0x000000061f00720cULL, 0x000fc60003f06070ULL, 0x00006600097b7a24ULL, 0x020fe200078e021eULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x0000061000008947ULL, 0x000fea0003800000ULL,
0x00000003ff747819ULL, 0x002fe40000011604ULL, 0x0000001e051d7217ULL, 0x000fe40007800000ULL,
0x0000000474287810ULL, 0x040fe20007ffe0ffULL, 0x0000000174297824ULL, 0x040fe200078e027bULL,
0x00000008746c7810ULL, 0x040fe20007ffe0ffULL, 0x000000011d1d7824ULL, 0x000fe200078e0a1eULL,
0x0000000c74727810ULL, 0x000fe20007ffe0ffULL, 0x00000001281f7824ULL, 0x100fe200078e0204ULL,
0x0000001074767810ULL, 0x000fe20007ffe0ffULL, 0x00000008282a7824ULL, 0x000fe200078e00ffULL,
0x000000201d1d7817ULL, 0x000fe20003800000ULL, 0x000000016c277824ULL, 0x000fc400078e0204ULL,
0x000000086c6e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82a777812ULL, 0x000fe200078ee21fULL,
0x000000800a1e7824ULL, 0x000fe200078e020bULL, 0x0000001d2800720cULL, 0x080fe20003f86070ULL,
0x000000ffff1f7224ULL, 0x000fe200078e00ffULL, 0xfffffff86e7d7812ULL, 0x000fe200078ee227ULL,
0x00000001282b7824ULL, 0x000fe200078e027bULL, 0x0000001d7200720cULL, 0x0c0fe20003f46070ULL,
0x0000000172277824ULL, 0x000fe200078e0204ULL, 0x0000001d6c00720cULL, 0x080fe20003f66070ULL,
0x00000008726e7824ULL, 0x000fe200078e00ffULL, 0x0000001d7400720cULL, 0x000fe20003fa6070ULL,
0x0000010029287825ULL, 0x000fc600078e001eULL, 0xfffffff86e7f7812ULL, 0x000fe200078ee227ULL,
0x000001002b2a7825ULL, 0x000fe200078e001eULL, 0x00006200286e7a10ULL, 0x000fc60007f1e0ffULL,
0x00000001766d7824ULL, 0x000fe200078e0204ULL, 0x000062002a707a10ULL, 0x000fe20007f3e0ffULL,
0x0000000876787824ULL, 0x000fe200078e00ffULL, 0x00006300296f7a10ULL, 0x000fe200007fe4ffULL,
0x000000016c297824ULL, 0x100fe200078e027bULL, 0x000063002b717a10ULL, 0x000fe20000ffe4ffULL,
0x00000001722b7824ULL, 0x000fe200078e027bULL, 0xfffffff878857812ULL, 0x000fe200078ee26dULL,
0x0000010029287825ULL, 0x000fe200078e001eULL, 0x0000001474787810ULL, 0x000fe40007ffe0ffULL,
0x0000001d7600720cULL, 0x040fe20003f26070ULL, 0x00000001766d7824ULL, 0x000fe200078e027bULL,
0x0000620028727a10ULL, 0x000fe20007f1e0ffULL, 0x0000000174277824ULL, 0x000fc400078e0204ULL,
0x0000000178737824ULL, 0x040fe400078e0204ULL, 0x0000000878767824ULL, 0x000fe200078e00ffULL,
0x0000000727277812ULL, 0x000fe200078ec0ffULL, 0x000001002b2a7825ULL, 0x000fc600078e001eULL,
0xfffffff876877812ULL, 0x000fe200078ee273ULL, 0x000001006d6c7825ULL, 0x000fe200078e001eULL,
0x000062002a2a7a10ULL, 0x000fe40007fde0ffULL, 0x0000630029737a10ULL, 0x000fe200007fe4ffULL,
0x0000000178297824ULL, 0x000fe200078e027bULL, 0x0ffffff827277812ULL, 0x000fe200078ef804ULL,
0x0000001077777824ULL, 0x000fe200078e021cULL, 0x000063002b2b7a10ULL, 0x000fe200037fe4ffULL,
0x0000010029287825ULL, 0x000fe200078e001eULL, 0x000062006c6c7a10ULL, 0x000fc40007fde0ffULL,
0x0000001874767810ULL, 0x000fe20007ffe0ffULL, 0x0000001027277824ULL, 0x000fe200078e021cULL,
0x0000001d7800720cULL, 0x080fe40003f06070ULL, 0x000063006d6d7a10ULL, 0x000fe200037fe4ffULL,
0x0000000176797824ULL, 0x000fe200078e027bULL, 0x0000001c74787810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006e277faeULL, 0x0003e2000e901c48ULL,
0x0000620028747a10ULL, 0x000fe40007fde0ffULL, 0x0000001d7600720cULL, 0x080fe20003fa6070ULL,
0x0000000070777faeULL, 0x0005e2000e101c48ULL, 0x0000630029757a10ULL, 0x000fe200037fe4ffULL,
0x0000010079287825ULL, 0x000fe200078e001eULL, 0x0000001d7800720cULL, 0x000fc60003f86070ULL,
0x00000001781d7824ULL, 0x000fe200078e027bULL, 0x0000620028287a10ULL, 0x000fe20007fde0ffULL,
0x0000000176277824ULL, 0x142fe400078e0204ULL, 0x0000000876767824ULL, 0x000fe200078e00ffULL,
0x0000630029297a10ULL, 0x000fe200037fe4ffULL, 0x00000001786e7824ULL, 0x040fe400078e0204ULL,
0x0000000878797824ULL, 0x000fe200078e00ffULL, 0xfffffff876777812ULL, 0x004fe200078ee227ULL,
0x000001001d1e7825ULL, 0x000fc600078e001eULL, 0xfffffff879797812ULL, 0x000fe200078ee26eULL,
0x000000107d1d7824ULL, 0x100fe200078e021cULL, 0x000062001e1e7a10ULL, 0x000fe20007fde0ffULL,
0x000000107f277824ULL, 0x100fe400078e021cULL, 0x00000010856f7824ULL, 0x100fe200078e021cULL,
0x000063001f1f7a10ULL, 0x000fe200037fe4ffULL, 0x0000001087717824ULL, 0x100fe200078e021cULL,
0x00000000721d7faeULL, 0x0003e2000d901c48ULL, 0x0000001077777824ULL, 0x100fe400078e021cULL,
0x0000001079797824ULL, 0x000fe200078e021cULL, 0x000000002a277faeULL, 0x0003e8000d101c48ULL,
0x000000006c6f7faeULL, 0x0003e8000c901c48ULL, 0x0000000074717faeULL, 0x0003e8000c101c48ULL,
0x0000000028777faeULL, 0x0003e8000e901c48ULL, 0x000000001e797faeULL, 0x0003e2000e101c48ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000000404297811ULL, 0x002fe200078fe8ffULL,
0x000000800a747824ULL, 0x000fe200078e020bULL, 0x00000008042b7811ULL, 0x040fe200078fe8ffULL,
0x000000ffff757224ULL, 0x000fe200078e00ffULL, 0x0000000c046d7811ULL, 0x040fe200078fe8ffULL,
0x00000001291d7824ULL, 0x140fe200078e0204ULL, 0x00000010046f7811ULL, 0x040fe200078fe8ffULL,
0x0000000829287824ULL, 0x000fe200078e00ffULL, 0x0000001404717811ULL, 0x040fe200078fe8ffULL,
0x000000012b1e7824ULL, 0x140fe200078e0204ULL, 0x0000001804737811ULL, 0x000fe200078fe8ffULL,
0x000000082b797824ULL, 0x000fe200078e00ffULL, 0xfffffff828777812ULL, 0x000fe200078ee21dULL,
0x000000016d1d7824ULL, 0x000fc400078e0204ULL, 0x000000086d287824ULL, 0x000fe200078e00ffULL,
0xfffffff879797812ULL, 0x000fe200078ee21eULL, 0x000000016f1e7824ULL, 0x140fe400078e0204ULL,
0x000000086f7f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8287d7812ULL, 0x000fe200078ee21dULL,
0x00000001711f7824ULL, 0x040fe200078e0204ULL, 0x00000004041d7211ULL, 0x040fe200078fe8ffULL,
0x00000008712a7824ULL, 0x000fe200078e00ffULL, 0xfffffff87f7f7812ULL, 0x000fe200078ee21eULL,
0x0000000173277824ULL, 0x040fe200078e0204ULL, 0x0000001c041e7811ULL, 0x000fe200078fe8ffULL,
0x00000008736c7824ULL, 0x000fe200078e00ffULL, 0xfffffff82a857812ULL, 0x000fe200078ee21fULL,
0x0000000129297824ULL, 0x100fe200078e027bULL, 0x0000007b041f7211ULL, 0x000fe200078fe8ffULL,
0x000000012b2b7824ULL, 0x000fe200078e027bULL, 0xfffffff86c877812ULL, 0x000fe200078ee227ULL,
0x000000016d6d7824ULL, 0x100fe200078e027bULL, 0x000000071d277812ULL, 0x000fe200078ec0ffULL,
0x000000016f6f7824ULL, 0x000fc400078e027bULL, 0x0000000171717824ULL, 0x100fe200078e027bULL,
0x0ffffff827277812ULL, 0x100fe200078ef804ULL, 0x0000000173737824ULL, 0x100fe400078e027bULL,
0x000000011e1d7824ULL, 0x040fe400078e027bULL, 0x000000011e767824ULL, 0x040fe400078e0204ULL,
0x000000081e7b7824ULL, 0x000fe400078e00ffULL, 0x000001001f1e7825ULL, 0x000fc800078e0074ULL,
0x0000010029287825ULL, 0x000fc800078e0074ULL, 0x000001002b2a7825ULL, 0x000fc800078e0074ULL,
0x000001006d6c7825ULL, 0x000fc800078e0074ULL, 0x000001006f6e7825ULL, 0x000fc800078e0074ULL,
0x0000010071707825ULL, 0x000fc800078e0074ULL, 0x0000010073727825ULL, 0x000fc800078e0074ULL,
0x000001001d747825ULL, 0x000fe200078e0074ULL, 0xfffffff87b1d7812ULL, 0x000fc600078ee276ULL,
0x000000107d7b7824ULL, 0x100fe400078e021cULL, 0x000000107f7d7824ULL, 0x100fe400078e021cULL,
0x00000010857f7824ULL, 0x100fe400078e021cULL, 0x0000001087857824ULL, 0x100fe400078e021cULL,
0x0000001027277824ULL, 0x100fe400078e021cULL, 0x0000001077777824ULL, 0x000fc400078e021cULL,
0x0000001079797824ULL, 0x100fe400078e021cULL, 0x000000101d877824ULL, 0x000fe200078e021cULL,
0x000062001e1c7a10ULL, 0x000fe40007f1e0ffULL, 0x00006200281e7a10ULL, 0x000fe40007f3e0ffULL,
0x000062002a287a10ULL, 0x000fe40007f5e0ffULL, 0x000062006c2a7a10ULL, 0x000fe40007f7e0ffULL,
0x000063001f1d7a10ULL, 0x000fc400007fe4ffULL, 0x00006300291f7a10ULL, 0x000fe40000ffe4ffULL,
0x000062006e6c7a10ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c277faeULL, 0x0003e2000b901c48ULL, 0x000063002b297a10ULL, 0x000fe400017fe4ffULL,
0x00006200706e7a10ULL, 0x000fe20007f3e0ffULL, 0x000000001e777faeULL, 0x0003e2000b901c48ULL,
0x000063006d2b7a10ULL, 0x000fe40001ffe4ffULL, 0x0000620072707a10ULL, 0x000fe20007f5e0ffULL,
0x0000000028797faeULL, 0x0003e2000b901c48ULL, 0x0000620074727a10ULL, 0x000fc40007f7e0ffULL,
0x000063006f6d7a10ULL, 0x000fe200007fe4ffULL, 0x000000002a7b7faeULL, 0x0003e2000b901c48ULL,
0x00006300716f7a10ULL, 0x000fe40000ffe4ffULL, 0x0000630073717a10ULL, 0x000fe200017fe4ffULL,
0x000000006c7d7faeULL, 0x0003e2000b901c48ULL, 0x0000630075737a10ULL, 0x000fc60001ffe4ffULL,
0x000000006e7f7faeULL, 0x0003e8000b901c48ULL, 0x0000000070857faeULL, 0x0003e8000b901c48ULL,
0x0000000072877faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffe0071e7812ULL, 0x042fe400078ec0ffULL, 0x00000010071f7812ULL, 0x000fc400078ec0ffULL,
0x0000000807287812ULL, 0x000fc800078ec0ffULL, 0x0000001e28287210ULL, 0x000fe20007ffe01fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0166280028287f8cULL, 0x000e64000c80043fULL,
0x00000000001c7805ULL, 0x000fc40000015200ULL, 0x000000011e1f7824ULL, 0x000fc800078e021fULL,
0x000000080a2a7824ULL, 0x000fca00078e021fULL, 0x01662c002a1f7984ULL, 0x000ea40000000800ULL,
0x800000001fff7812ULL, 0x006fe40007804829ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001e7805ULL, 0x000fcc0000015200ULL,
0x0000001e1c277210ULL, 0x000fca0007f1e1ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0e1dULL,
0x003d09002700780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402700780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1e7819ULL, 0x000fc8000001141fULL, 0x000000271e1e7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e061fULL, 0x000000021e1e7819ULL, 0x000fc8000000121fULL,
0x0000001e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012b2b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01662c002a1f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe40007804829ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020001c7824ULL, 0x000fca00078e00ffULL,
0xffffff801c1c7812ULL, 0x000fc800078ec0ffULL, 0x000000800b1d7810ULL, 0x000fca0007ffe01cULL,
0x000000010c1d7824ULL, 0x000fca00078e021dULL, 0x016000001d1c7984ULL, 0x000e680000000800ULL,
0x016200001d1e7984ULL, 0x0004e20000000800ULL, 0x0000001b1c00720bULL, 0x002fe20003f1d000ULL,
0x000136e27f007947ULL, 0x000fd8000b800000ULL, 0x00000000001d7806ULL, 0x004fc800000e0100ULL,
0x000000ff1d00720cULL, 0x000fe20003f25270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff277224ULL, 0x000fd400078e001bULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x00000001001f7811ULL, 0x000fe400078ff0ffULL,
0x0000001b1c00720bULL, 0x000fe40003f34000ULL, 0x000000001f00720cULL, 0x000fe20003f05270ULL,
0x000136927f007947ULL, 0x000fd4000b800000ULL, 0x00000000006c7806ULL, 0x000fc400008e0100ULL,
0x0000008000278824ULL, 0x000fe200078e020bULL, 0x0000001b1c1f8209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x000000010c288824ULL, 0x000fca00078e0227ULL,
0x0164001f28008388ULL, 0x0003e20000000800ULL, 0x000000ff6c00720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000001b1c287209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff6cff7812ULL, 0x000fc6000780c0ffULL,
0x0000001b281f7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b1f1f7820ULL, 0x000fc80000410000ULL,
0x0000001f006e7308ULL, 0x000e640000000800ULL, 0x0000006e25257220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe20000011604ULL,
0x000135c27f007947ULL, 0x000fea000b800000ULL, 0x00001f296e297589ULL, 0x0002a400000e0000ULL,
0x000000292c2c7220ULL, 0x084fe20000410000ULL, 0x000000292d2d7220ULL, 0x080fe20000410000ULL,
0x0000002930307220ULL, 0x080fe20000410000ULL, 0x0000002931317220ULL, 0x080fe20000410000ULL,
0x0000002934347220ULL, 0x080fe20000410000ULL, 0x0000002935357220ULL, 0x080fe20000410000ULL,
0x0000002938387220ULL, 0x080fe20000410000ULL, 0x0000002939397220ULL, 0x080fe20000410000ULL,
0x000000293c3c7220ULL, 0x080fe20000410000ULL, 0x000000293d3d7220ULL, 0x080fe20000410000ULL,
0x0000002940407220ULL, 0x080fe20000410000ULL, 0x0000002941417220ULL, 0x080fe20000410000ULL,
0x0000002944447220ULL, 0x080fe20000410000ULL, 0x0000002945457220ULL, 0x080fe20000410000ULL,
0x0000002948487220ULL, 0x080fe20000410000ULL, 0x0000002949497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff006cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000804297811ULL, 0x000fe200078ff0ffULL, 0x000134927f007947ULL, 0x000fea000b800000ULL,
0x00001f296e297589ULL, 0x00046400000e0000ULL, 0x000000292e2e7220ULL, 0x086fe20000410000ULL,
0x000000292f2f7220ULL, 0x080fe20000410000ULL, 0x0000002932327220ULL, 0x080fe20000410000ULL,
0x0000002933337220ULL, 0x080fe20000410000ULL, 0x0000002936367220ULL, 0x080fe20000410000ULL,
0x0000002937377220ULL, 0x080fe20000410000ULL, 0x000000293a3a7220ULL, 0x080fe20000410000ULL,
0x000000293b3b7220ULL, 0x080fe20000410000ULL, 0x000000293e3e7220ULL, 0x080fe20000410000ULL,
0x000000293f3f7220ULL, 0x080fe20000410000ULL, 0x0000002942427220ULL, 0x080fe20000410000ULL,
0x0000002943437220ULL, 0x080fe20000410000ULL, 0x0000002946467220ULL, 0x080fe20000410000ULL,
0x0000002947477220ULL, 0x080fe20000410000ULL, 0x000000294a4a7220ULL, 0x080fe20000410000ULL,
0x000000294b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00006cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001004297811ULL, 0x000fe200078ff0ffULL,
0x000133627f007947ULL, 0x000fea000b800000ULL, 0x00001f296e297589ULL, 0x00046400000e0000ULL,
0x000000294c4c7220ULL, 0x086fe20000410000ULL, 0x000000294d4d7220ULL, 0x080fe20000410000ULL,
0x0000002950507220ULL, 0x080fe20000410000ULL, 0x0000002951517220ULL, 0x080fe20000410000ULL,
0x0000002954547220ULL, 0x080fe20000410000ULL, 0x0000002955557220ULL, 0x080fe20000410000ULL,
0x0000002958587220ULL, 0x080fe20000410000ULL, 0x0000002959597220ULL, 0x080fe20000410000ULL,
0x000000295c5c7220ULL, 0x080fe20000410000ULL, 0x000000295d5d7220ULL, 0x080fe20000410000ULL,
0x0000002960607220ULL, 0x080fe20000410000ULL, 0x0000002961617220ULL, 0x080fe20000410000ULL,
0x0000002964647220ULL, 0x080fe20000410000ULL, 0x0000002965657220ULL, 0x080fe20000410000ULL,
0x0000002968687220ULL, 0x080fe20000410000ULL, 0x0000002969697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000006cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001804297811ULL, 0x000fe200078ff0ffULL,
0x000132427f007947ULL, 0x000fea000b800000ULL, 0x00001f296e297589ULL, 0x00046400000e0000ULL,
0x000000294e4e7220ULL, 0x086fe20000410000ULL, 0x000000294f4f7220ULL, 0x080fe20000410000ULL,
0x0000002952527220ULL, 0x080fe20000410000ULL, 0x0000002953537220ULL, 0x080fe20000410000ULL,
0x0000002956567220ULL, 0x080fe20000410000ULL, 0x0000002957577220ULL, 0x080fe20000410000ULL,
0x000000295a5a7220ULL, 0x080fe20000410000ULL, 0x000000295b5b7220ULL, 0x080fe20000410000ULL,
0x000000295e5e7220ULL, 0x080fe20000410000ULL, 0x000000295f5f7220ULL, 0x080fe20000410000ULL,
0x0000002962627220ULL, 0x080fe20000410000ULL, 0x0000002963637220ULL, 0x080fe20000410000ULL,
0x0000002966667220ULL, 0x080fe20000410000ULL, 0x0000002967677220ULL, 0x080fe20000410000ULL,
0x000000296a6a7220ULL, 0x080fe20000410000ULL, 0x000000296b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000006c1dff7212ULL, 0x000fe400078030ffULL,
0x0000001b1c277209ULL, 0x000fd60007810000ULL, 0x800000271c1c0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b1c1c0820ULL, 0x000fc80000410000ULL, 0x0000001c000d0308ULL, 0x000e640000000800ULL,
0x0000000d1e1e0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000251e257221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x0000000dff0e723eULL, 0x000fe400000000ffULL,
0x00000002ff1c7819ULL, 0x000fe40000011604ULL, 0x000054100e117816ULL, 0x000fe2000000000eULL,
0x000130827f007947ULL, 0x000fea000b800000ULL, 0x00001f1c110e7589ULL, 0x0002a400000e0000ULL,
0x000000081c297810ULL, 0x000fe20007ffe0ffULL, 0x000130b27f007947ULL, 0x000fea000b800000ULL,
0x000000101c107810ULL, 0x000fe20007ffe0ffULL, 0x00001f29110f7589ULL, 0x00066a00000e0000ULL,
0x00001f1011107589ULL, 0x0006a400000e0000ULL, 0x000000181c297810ULL, 0x008fe20007ffe0ffULL,
0x000131027f007947ULL, 0x000fea000b800000ULL, 0x00001f2911117589ULL, 0x0022e400000e0000ULL,
0x00002000001b7824ULL, 0x000fe200078e00ffULL, 0x0000b000157c7810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000014000007945ULL, 0x000fe40003800000ULL,
0xffffc0001b1b7812ULL, 0x000fe200078ec0ffULL, 0x0000001019197824ULL, 0x000fc400078e027cULL,
0x000000101a1a7824ULL, 0x000fe400078e027cULL, 0x000020000a1b7824ULL, 0x000fe200078e021bULL,
0x000000001978783bULL, 0x0002e80000000200ULL, 0x0000f0001b1b7810ULL, 0x000fe20007ffe0ffULL,
0x000000001a1c783bULL, 0x0002a80000000200ULL, 0x0000001016747824ULL, 0x000fc400078e021bULL,
0x0000001014707824ULL, 0x100fe400078e021bULL, 0x00000010176c7824ULL, 0x000fe200078e021bULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000000e78787232ULL, 0x08efe40000000000ULL,
0x0000000e7a7a7232ULL, 0x000fe40000000000ULL, 0x0000000f79797232ULL, 0x080fe40000000000ULL,
0x0000000f7b7b7232ULL, 0x000fe40000000000ULL, 0x000000101c1c7232ULL, 0x000fc40000000000ULL,
0x000000101e1e7232ULL, 0x000fe40000000000ULL, 0x000000111d1d7232ULL, 0x080fe40000000000ULL,
0x000000111f1f7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x002fea0003800000ULL,
0x0000001018287824ULL, 0x000fe200078e021bULL, 0x000000007474783bULL, 0x000e620000004200ULL,
0x0000000200197824ULL, 0x000fe200078e00ffULL, 0x000002e000007945ULL, 0x000fe40003800000ULL,
0x000000007070783bULL, 0x000fe40000004200ULL, 0x0000000419197812ULL, 0x000fc400078ec0ffULL,
0x000000002828783bULL, 0x000f240000004200ULL, 0x0000000219197812ULL, 0x000fe400078efcffULL,
0x000000006c6c783bULL, 0x000ee40000004200ULL, 0x0000001904197211ULL, 0x000fca00078fe0ffULL,
0x00000001121a7824ULL, 0x140fe400078e0219ULL, 0x00000001131b7824ULL, 0x040fe200078e0219ULL,
0x00000074782c723cULL, 0x04af70000000182cULL, 0x000000287844723cULL, 0x090f700000001844ULL,
0x000000281c64723cULL, 0x004b6e0000001864ULL, 0x0000000812297824ULL, 0x020fe200078e00ffULL,
0x0000002a7848723cULL, 0x000f620000001848ULL, 0x0000000813287824ULL, 0x000fc600078e00ffULL,
0xfffffff829197812ULL, 0x000fe400078ee21aULL, 0xfffffff8281a7812ULL, 0x000fe400078ee21bULL,
0x0000f000241b7810ULL, 0x000fe20007ffe0ffULL, 0x00000010197d7824ULL, 0x100fe200078e027cULL,
0x0000002a1c68723cULL, 0x000b620000001868ULL, 0x000000101a287824ULL, 0x000fc800078e027cULL,
0x000000007d7c783bULL, 0x000e660000000200ULL, 0x000000767830723cULL, 0x040f640000001830ULL,
0x000000002828783bULL, 0x020eac0000000200ULL, 0x000000707834723cULL, 0x040f700000001834ULL,
0x000000727838723cULL, 0x040f700000001838ULL, 0x0000006c783c723cULL, 0x040f70000000183cULL,
0x0000006e7840723cULL, 0x000f700000001840ULL, 0x000000741c4c723cULL, 0x040f70000000184cULL,
0x000000761c50723cULL, 0x040f700000001850ULL, 0x000000701c54723cULL, 0x040f700000001854ULL,
0x000000721c58723cULL, 0x040f700000001858ULL, 0x0000006c1c5c723cULL, 0x040f70000000185cULL,
0x0000006e1c60723cULL, 0x000b6e0000001860ULL, 0x00000010211c7824ULL, 0x020fc400078e021bULL,
0x00000010221d7824ULL, 0x100fe400078e021bULL, 0x00000010231e7824ULL, 0x000fe200078e021bULL,
0x0000008000008947ULL, 0x000fce0003800000ULL, 0x0000000e7c7c7232ULL, 0x086fe40000000000ULL,
0x0000000e7e7e7232ULL, 0x000fe40000000000ULL, 0x0000000f7d7d7232ULL, 0x080fe40000000000ULL,
0x0000000f7f7f7232ULL, 0x000fe40000000000ULL, 0x0000001028287232ULL, 0x000fc40000000000ULL,
0x000000102a2a7232ULL, 0x000fe40000000000ULL, 0x0000001129297232ULL, 0x080fe40000000000ULL,
0x000000112b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x006fea0003800000ULL,
0x00000010201f7824ULL, 0x000fe200078e021bULL, 0x000000001c78783bULL, 0x000e680000004200ULL,
0x000000001d74783bULL, 0x000ea80000004200ULL, 0x000000001e70783bULL, 0x000ee80000004200ULL,
0x000000001f6c783bULL, 0x000f220000004200ULL, 0x000000787c2c723cULL, 0x042f70000000182cULL,
0x0000007a7c30723cULL, 0x040f700000001830ULL, 0x000000747c34723cULL, 0x044f700000001834ULL,
0x000000767c38723cULL, 0x040f700000001838ULL, 0x000000707c3c723cULL, 0x048f70000000183cULL,
0x000000727c40723cULL, 0x040f700000001840ULL, 0x0000006e7c48723cULL, 0x050f700000001848ULL,
0x0000006c7c44723cULL, 0x080f700000001844ULL, 0x0000006c2864723cULL, 0x040b6e0000001864ULL,
0x00000002ff6c7819ULL, 0x020fe20000011600ULL, 0x00000078284c723cULL, 0x040f70000000184cULL,
0x0000007a2850723cULL, 0x040f700000001850ULL, 0x000000742854723cULL, 0x040f700000001854ULL,
0x000000762858723cULL, 0x040f700000001858ULL, 0x00000070285c723cULL, 0x040f70000000185cULL,
0x000000722860723cULL, 0x040f700000001860ULL, 0x0000006e2868723cULL, 0x000b6e0000001868ULL,
0x000166906c287811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fcc0000008000ULL,
0x0000000103297810ULL, 0x000fe20007ffe0ffULL, 0x0000000028ff7f8cULL, 0x0003e2000c80043fULL,
0x000000c0262a7810ULL, 0x000fc40007ffe0ffULL, 0x000000062900720cULL, 0x000fc60003f06070ULL,
0x00006600097b7a24ULL, 0x000fe200078e022aULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x0000061000008947ULL, 0x000fea0003800000ULL, 0x00000003ff6d7819ULL, 0x002fe40000011604ULL,
0x0000002a05267217ULL, 0x000fe40007800000ULL, 0x000000046d6f7810ULL, 0x040fe40007ffe0ffULL,
0x000000086d717810ULL, 0x040fe20007ffe0ffULL, 0x0000000126267824ULL, 0x000fe200078e0a2aULL,
0x000000106d797810ULL, 0x000fe20007ffe0ffULL, 0x000000016f287824ULL, 0x100fe200078e0204ULL,
0x0000000c6d737810ULL, 0x000fe20007ffe0ffULL, 0x000000086f297824ULL, 0x000fe200078e00ffULL,
0x000000146d7d7810ULL, 0x000fe20007ffe0ffULL, 0x00000008717e7824ULL, 0x000fe200078e00ffULL,
0x0000002026267817ULL, 0x000fe20003800000ULL, 0x00000001792b7824ULL, 0x000fe200078e0204ULL,
0xfffffff8297c7812ULL, 0x000fe200078ee228ULL, 0x0000000171297824ULL, 0x100fe200078e0204ULL,
0x000000266f00720cULL, 0x080fe20003fa6070ULL, 0x00000008798a7824ULL, 0x000fe200078e00ffULL,
0x000000267100720cULL, 0x080fe20003f66070ULL, 0x00000001732a7824ULL, 0x040fe200078e0204ULL,
0xfffffff87e7e7812ULL, 0x000fe200078ee229ULL, 0x0000000873757824ULL, 0x040fe200078e00ffULL,
0xfffffff88a8a7812ULL, 0x000fe200078ee22bULL, 0x000000800a287824ULL, 0x000fe200078e020bULL,
0x000000267300720cULL, 0x000fe20003f46070ULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0xfffffff875887812ULL, 0x000fe200078ee22aULL, 0x000000016d2b7824ULL, 0x040fe200078e027bULL,
0x000000186d7f7810ULL, 0x000fe20007ffe0ffULL, 0x000000017d747824ULL, 0x000fc400078e0204ULL,
0x000000087d757824ULL, 0x000fe400078e00ffULL, 0x000001002b2a7825ULL, 0x000fc600078e0028ULL,
0xfffffff8758c7812ULL, 0x000fe200078ee274ULL, 0x000000016f6f7824ULL, 0x100fe200078e027bULL,
0x000062002a747a10ULL, 0x000fe20007f1e0ffULL, 0x0000000171717824ULL, 0x100fe400078e027bULL,
0x0000000173737824ULL, 0x000fe200078e027bULL, 0x000063002b757a10ULL, 0x000fe200007fe4ffULL,
0x000001006f6e7825ULL, 0x000fe200078e0028ULL, 0x000000267d00720cULL, 0x000fc60003f06070ULL,
0x0000010071707825ULL, 0x000fe200078e0028ULL, 0x000062006e767a10ULL, 0x000fc60007f3e0ffULL,
0x0000010073727825ULL, 0x000fe200078e0028ULL, 0x0000620070707a10ULL, 0x000fe40007f9e0ffULL,
0x000063006f777a10ULL, 0x000fe20000ffe4ffULL, 0x00000001792b7824ULL, 0x000fe200078e027bULL,
0x0000620072727a10ULL, 0x000fe20007fde0ffULL, 0x000000016d6e7824ULL, 0x000fe200078e0204ULL,
0x000000267900720cULL, 0x000fe20003f26070ULL, 0x000001002b2a7825ULL, 0x000fe200078e0028ULL,
0x0000630071717a10ULL, 0x000fe400027fe4ffULL, 0x000000076e797812ULL, 0x000fe200078ec0ffULL,
0x000000017d6f7824ULL, 0x000fe200078e027bULL, 0x0000001c6d7d7810ULL, 0x000fc40007ffe0ffULL,
0x000000266d00720cULL, 0x000fe20003f86070ULL, 0x000000017f6d7824ULL, 0x100fe200078e027bULL,
0x0000630073737a10ULL, 0x000fe200037fe4ffULL, 0x000000017d7b7824ULL, 0x000fe200078e027bULL,
0x000062002a787a10ULL, 0x000fe20007fde0ffULL, 0x000001006f6e7825ULL, 0x000fe200078e0028ULL,
0x0ffffff8797a7812ULL, 0x000fe400078ef804ULL, 0x000063002b797a10ULL, 0x000fe200037fe4ffULL,
0x000001006d2a7825ULL, 0x000fe200078e0028ULL, 0x000062006e6e7a10ULL, 0x000fc60007fde0ffULL,
0x000000107a6d7824ULL, 0x000fe200078e021bULL, 0x000063006f6f7a10ULL, 0x000fe200037fe4ffULL,
0x000001007b287825ULL, 0x000fe200078e0028ULL, 0x000000267f00720cULL, 0x000fe40003fc6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000746d7faeULL, 0x0003e2000e101c48ULL,
0x000000107c7b7824ULL, 0x000fe200078e021bULL, 0x000062002a2a7a10ULL, 0x000fe20007f9e0ffULL,
0x000000017d7a7824ULL, 0x000fc600078e0204ULL, 0x00000000767b7faeULL, 0x0005e2000e901c48ULL,
0x000000267d00720cULL, 0x000fe20003fa6070ULL, 0x000000017f267824ULL, 0x000fe200078e0204ULL,
0x000063002b2b7a10ULL, 0x000fe200027fe4ffULL, 0x000000087f7f7824ULL, 0x000fe200078e00ffULL,
0x0000620028287a10ULL, 0x000fe20007f9e0ffULL, 0x000000087d7d7824ULL, 0x000fe400078e00ffULL,
0x000000107e6d7824ULL, 0x102fe200078e021bULL, 0xfffffff87f267812ULL, 0x000fe200078ee226ULL,
0x0000001088757824ULL, 0x100fe200078e021bULL, 0xfffffff87d7a7812ULL, 0x000fe200078ee27aULL,
0x000000108a777824ULL, 0x104fe200078e021bULL, 0x0000630029297a10ULL, 0x000fe200027fe4ffULL,
0x000000108c7b7824ULL, 0x100fe200078e021bULL, 0x00000000706d7faeULL, 0x0003e2000d901c48ULL,
0x00000010267d7824ULL, 0x000fc400078e021bULL, 0x000000107a7f7824ULL, 0x000fe200078e021bULL,
0x0000000072757faeULL, 0x0003e8000d101c48ULL, 0x0000000078777faeULL, 0x0003e8000c901c48ULL,
0x000000006e7b7faeULL, 0x0003e8000c101c48ULL, 0x000000002a7d7faeULL, 0x0003e8000f101c48ULL,
0x00000000287f7faeULL, 0x0003e2000e901c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x00000004042b7811ULL, 0x002fe200078fe8ffULL, 0x000000800a787824ULL, 0x000fe200078e020bULL,
0x00000008046f7811ULL, 0x000fc400078fe8ffULL, 0x0000000c04717811ULL, 0x040fe200078fe8ffULL,
0x000000012b267824ULL, 0x140fe200078e0204ULL, 0x0000001404757811ULL, 0x040fe200078fe8ffULL,
0x000000082b297824ULL, 0x000fe200078e00ffULL, 0x0000001004737811ULL, 0x040fe200078fe8ffULL,
0x000000016f287824ULL, 0x040fe200078e0204ULL, 0x0000001804777811ULL, 0x000fe200078fe8ffULL,
0x000000086f6d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8297a7812ULL, 0x000fe200078ee226ULL,
0x0000000171267824ULL, 0x100fe400078e0204ULL, 0x0000000175297824ULL, 0x000fe200078e0204ULL,
0xfffffff86d7c7812ULL, 0x000fe200078ee228ULL, 0x00000008716d7824ULL, 0x000fc400078e00ffULL,
0x00000008758a7824ULL, 0x000fe400078e00ffULL, 0x0000000173287824ULL, 0x000fe200078e0204ULL,
0xfffffff86d7e7812ULL, 0x000fe200078ee226ULL, 0x0000000873797824ULL, 0x000fe200078e00ffULL,
0xfffffff88a8a7812ULL, 0x000fe200078ee229ULL, 0x00000001772a7824ULL, 0x040fe200078e0204ULL,
0x0000001c04267811ULL, 0x040fe200078fe8ffULL, 0x00000008777d7824ULL, 0x000fe200078e00ffULL,
0xfffffff879887812ULL, 0x000fe200078ee228ULL, 0x000000ffff797224ULL, 0x000fe200078e00ffULL,
0x0000007b04297211ULL, 0x000fe200078fe8ffULL, 0x000000012b2b7824ULL, 0x100fe200078e027bULL,
0xfffffff87d8c7812ULL, 0x000fe200078ee22aULL, 0x000000016f6f7824ULL, 0x000fc400078e027bULL,
0x0000000171717824ULL, 0x100fe400078e027bULL, 0x0000000173737824ULL, 0x100fe400078e027bULL,
0x0000000175757824ULL, 0x100fe400078e027bULL, 0x0000000177777824ULL, 0x100fe400078e027bULL,
0x00000001266d7824ULL, 0x040fe400078e027bULL, 0x00000001267b7824ULL, 0x000fc400078e0204ULL,
0x00000008268e7824ULL, 0x000fe200078e00ffULL, 0x0000000404267211ULL, 0x000fe200078fe8ffULL,
0x0000010029287825ULL, 0x000fc600078e0078ULL, 0xfffffff88e8e7812ULL, 0x000fe200078ee27bULL,
0x000001002b2a7825ULL, 0x000fe200078e0078ULL, 0x0000620028287a10ULL, 0x000fc60007f1e0ffULL,
0x000001006f6e7825ULL, 0x100fe200078e0078ULL, 0x000062002a2a7a10ULL, 0x000fe40007f3e0ffULL,
0x0000630029297a10ULL, 0x000fe200007fe4ffULL, 0x0000010071707825ULL, 0x100fe200078e0078ULL,
0x000063002b2b7a10ULL, 0x000fe40000ffe4ffULL, 0x000062006e6e7a10ULL, 0x000fe20007f1e0ffULL,
0x0000010073727825ULL, 0x100fe200078e0078ULL, 0x0000620070707a10ULL, 0x000fe40007f3e0ffULL,
0x000063006f6f7a10ULL, 0x000fe200007fe4ffULL, 0x0000010075747825ULL, 0x000fe200078e0078ULL,
0x0000620072727a10ULL, 0x000fc40007f5e0ffULL, 0x0000630071717a10ULL, 0x000fe20000ffe4ffULL,
0x0000010077767825ULL, 0x100fe200078e0078ULL, 0x0000620074747a10ULL, 0x000fe40007f1e0ffULL,
0x0000630073737a10ULL, 0x000fe200017fe4ffULL, 0x000001006d787825ULL, 0x000fe200078e0078ULL,
0x00000007266d7812ULL, 0x000fe400078ec0ffULL, 0x0000620076767a10ULL, 0x000fe20007f3e0ffULL,
0x000000107a7b7824ULL, 0x100fe200078e021bULL, 0x0ffffff86d267812ULL, 0x000fe200078ef804ULL,
0x000000107c7d7824ULL, 0x100fe200078e021bULL, 0x0000620078787a10ULL, 0x000fe20007f5e0ffULL,
0x000000107e7f7824ULL, 0x100fe200078e021bULL, 0x0000630075757a10ULL, 0x000fe200007fe4ffULL,
0x00000010266d7824ULL, 0x100fe200078e021bULL, 0x0000630077777a10ULL, 0x000fe20000ffe4ffULL,
0x0000001088857824ULL, 0x100fe200078e021bULL, 0x0000630079797a10ULL, 0x000fe200017fe4ffULL,
0x000000108a877824ULL, 0x100fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000286d7faeULL, 0x0003e2000b901c48ULL, 0x000000108c897824ULL, 0x000fc400078e021bULL,
0x000000108e8b7824ULL, 0x000fe200078e021bULL, 0x000000002a7b7faeULL, 0x0003e8000b901c48ULL,
0x000000006e7d7faeULL, 0x0003e8000b901c48ULL, 0x00000000707f7faeULL, 0x0003e8000b901c48ULL,
0x0000000072857faeULL, 0x0003e8000b901c48ULL, 0x0000000074877faeULL, 0x0003e8000b901c48ULL,
0x0000000076897faeULL, 0x0003e8000b901c48ULL, 0x00000000788b7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001007297812ULL, 0x002fca00078ec0ffULL,
0x000000206c297824ULL, 0x000fc800078e0229ULL, 0x000000080a267824ULL, 0x000fe200078e0229ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01664800266c7f8cULL, 0x0002a4000c80043fULL,
0x0000000000287805ULL, 0x000fc40000015200ULL, 0x01664c00262b7984ULL, 0x000ee40000000800ULL,
0x800000002bff7812ULL, 0x00cfe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a286f7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09006f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff2a7819ULL, 0x000fc8000001142bULL, 0x0000006f2a2a7211ULL, 0x000fca00078110ffULL,
0x000000ffff2b7224ULL, 0x000fca00000e062bULL, 0x000000022a2a7819ULL, 0x000fc8000000122bULL,
0x0000002a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016e6e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01664c00262b7984ULL, 0x000ea40000000800ULL, 0x800000002bff7812ULL, 0x004fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000267824ULL, 0x002fca00078e00ffULL,
0xffffff8026267812ULL, 0x000fc800078ec0ffULL, 0x000001000b297810ULL, 0x000fca0007ffe026ULL,
0x000000010c297824ULL, 0x000fca00078e0229ULL, 0x01600000296c7984ULL, 0x000e680000000800ULL,
0x01620000296e7984ULL, 0x0004e20000000800ULL, 0x000000276c00720bULL, 0x002fe20003f1d000ULL,
0x00011bd27f007947ULL, 0x000fd8000b800000ULL, 0x00000000006d7806ULL, 0x004fc800000e0100ULL,
0x000000ff6d00720cULL, 0x000fe20003f25270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff267224ULL, 0x000fd400078e0027ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x0000000200297811ULL, 0x000fe400078ff0ffULL,
0x000000276c00720bULL, 0x000fe40003f34000ULL, 0x000000002900720cULL, 0x000fe20003f05270ULL,
0x00011b827f007947ULL, 0x000fd4000b800000ULL, 0x0000000000267806ULL, 0x000fc400008e0100ULL,
0x0000008000298824ULL, 0x000fe200078e020bULL, 0x000000276c288209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x000000010c298824ULL, 0x000fca00078e0229ULL,
0x0164002829008388ULL, 0x0003e20000000800ULL, 0x000000ff2600720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x000000276c287209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff26ff7812ULL, 0x000fc6000780c0ffULL,
0x0000002728287221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL,
0x0000002800707308ULL, 0x000e640000000800ULL, 0x0000007025257220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe20000011604ULL,
0x00011ab27f007947ULL, 0x000fea000b800000ULL, 0x00001f2970297589ULL, 0x0002a400000e0000ULL,
0x000000292c2c7220ULL, 0x084fe20000410000ULL, 0x000000292d2d7220ULL, 0x080fe20000410000ULL,
0x0000002930307220ULL, 0x080fe20000410000ULL, 0x0000002931317220ULL, 0x080fe20000410000ULL,
0x0000002934347220ULL, 0x080fe20000410000ULL, 0x0000002935357220ULL, 0x080fe20000410000ULL,
0x0000002938387220ULL, 0x080fe20000410000ULL, 0x0000002939397220ULL, 0x080fe20000410000ULL,
0x000000293c3c7220ULL, 0x080fe20000410000ULL, 0x000000293d3d7220ULL, 0x080fe20000410000ULL,
0x0000002940407220ULL, 0x080fe20000410000ULL, 0x0000002941417220ULL, 0x080fe20000410000ULL,
0x0000002944447220ULL, 0x080fe20000410000ULL, 0x0000002945457220ULL, 0x080fe20000410000ULL,
0x0000002948487220ULL, 0x080fe20000410000ULL, 0x0000002949497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0026ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000804297811ULL, 0x000fe200078ff0ffULL, 0x000119827f007947ULL, 0x000fea000b800000ULL,
0x00001f2970297589ULL, 0x00046400000e0000ULL, 0x000000292e2e7220ULL, 0x086fe20000410000ULL,
0x000000292f2f7220ULL, 0x080fe20000410000ULL, 0x0000002932327220ULL, 0x080fe20000410000ULL,
0x0000002933337220ULL, 0x080fe20000410000ULL, 0x0000002936367220ULL, 0x080fe20000410000ULL,
0x0000002937377220ULL, 0x080fe20000410000ULL, 0x000000293a3a7220ULL, 0x080fe20000410000ULL,
0x000000293b3b7220ULL, 0x080fe20000410000ULL, 0x000000293e3e7220ULL, 0x080fe20000410000ULL,
0x000000293f3f7220ULL, 0x080fe20000410000ULL, 0x0000002942427220ULL, 0x080fe20000410000ULL,
0x0000002943437220ULL, 0x080fe20000410000ULL, 0x0000002946467220ULL, 0x080fe20000410000ULL,
0x0000002947477220ULL, 0x080fe20000410000ULL, 0x000000294a4a7220ULL, 0x080fe20000410000ULL,
0x000000294b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000026ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001004297811ULL, 0x000fe200078ff0ffULL,
0x000118527f007947ULL, 0x000fea000b800000ULL, 0x00001f2970297589ULL, 0x00046400000e0000ULL,
0x000000294c4c7220ULL, 0x086fe20000410000ULL, 0x000000294d4d7220ULL, 0x080fe20000410000ULL,
0x0000002950507220ULL, 0x080fe20000410000ULL, 0x0000002951517220ULL, 0x080fe20000410000ULL,
0x0000002954547220ULL, 0x080fe20000410000ULL, 0x0000002955557220ULL, 0x080fe20000410000ULL,
0x0000002958587220ULL, 0x080fe20000410000ULL, 0x0000002959597220ULL, 0x080fe20000410000ULL,
0x000000295c5c7220ULL, 0x080fe20000410000ULL, 0x000000295d5d7220ULL, 0x080fe20000410000ULL,
0x0000002960607220ULL, 0x080fe20000410000ULL, 0x0000002961617220ULL, 0x080fe20000410000ULL,
0x0000002964647220ULL, 0x080fe20000410000ULL, 0x0000002965657220ULL, 0x080fe20000410000ULL,
0x0000002968687220ULL, 0x080fe20000410000ULL, 0x0000002969697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000026ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001804297811ULL, 0x000fe200078ff0ffULL,
0x000117327f007947ULL, 0x000fea000b800000ULL, 0x00001f2970297589ULL, 0x00046400000e0000ULL,
0x000000294e4e7220ULL, 0x086fe20000410000ULL, 0x000000294f4f7220ULL, 0x080fe20000410000ULL,
0x0000002952527220ULL, 0x080fe20000410000ULL, 0x0000002953537220ULL, 0x080fe20000410000ULL,
0x0000002956567220ULL, 0x080fe20000410000ULL, 0x0000002957577220ULL, 0x080fe20000410000ULL,
0x000000295a5a7220ULL, 0x080fe20000410000ULL, 0x000000295b5b7220ULL, 0x080fe20000410000ULL,
0x000000295e5e7220ULL, 0x080fe20000410000ULL, 0x000000295f5f7220ULL, 0x080fe20000410000ULL,
0x0000002962627220ULL, 0x080fe20000410000ULL, 0x0000002963637220ULL, 0x080fe20000410000ULL,
0x0000002966667220ULL, 0x080fe20000410000ULL, 0x0000002967677220ULL, 0x080fe20000410000ULL,
0x000000296a6a7220ULL, 0x080fe20000410000ULL, 0x000000296b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x000000266dff7212ULL, 0x000fe400078030ffULL,
0x000000276c267209ULL, 0x000fd60007810000ULL, 0x800000266c6c0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b6c6c0820ULL, 0x000fc80000410000ULL, 0x0000006c000d0308ULL, 0x000e640000000800ULL,
0x0000000d6e6e0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x000000256e257221ULL, 0x008fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x0000000dff0e723eULL, 0x000fe400000000ffULL, 0x00000002ff6c7819ULL, 0x000fe40000011604ULL,
0x000054100e117816ULL, 0x000fe2000000000eULL, 0x000115627f007947ULL, 0x000fea000b800000ULL,
0x00001f6c110e7589ULL, 0x0002a400000e0000ULL, 0x000000086c297810ULL, 0x000fe20007ffe0ffULL,
0x000115927f007947ULL, 0x000fea000b800000ULL, 0x000000106c107810ULL, 0x000fe20007ffe0ffULL,
0x00001f29110f7589ULL, 0x00066a00000e0000ULL, 0x00001f1011107589ULL, 0x0006a400000e0000ULL,
0x000000186c297810ULL, 0x008fe20007ffe0ffULL, 0x000115e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2911117589ULL, 0x0022e400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000200277824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000200000287824ULL, 0x000fe200078e00ffULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x00000008126d7824ULL, 0x000fe200078e00ffULL, 0x0000000427277812ULL, 0x000fe200078ec0ffULL,
0x00000008132a7824ULL, 0x000fe200078e00ffULL, 0xffffc000282b7812ULL, 0x000fc400078ec0ffULL,
0x0000002704277211ULL, 0x000fc600078fe0ffULL, 0x000020000a2b7824ULL, 0x000fe400078e022bULL,
0x0000000112287824ULL, 0x100fe400078e0227ULL, 0x0000000113297824ULL, 0x002fe200078e0227ULL,
0x0000c00015277810ULL, 0x000fe40007ffe0ffULL, 0xfffffff86d287812ULL, 0x000fe400078ee228ULL,
0xfffffff82a2a7812ULL, 0x000fe400078ee229ULL, 0x0000e0002b757810ULL, 0x000fe20007ffe0ffULL,
0x00000010286c7824ULL, 0x000fc400078e0227ULL, 0x000000102a2a7824ULL, 0x000fe400078e0227ULL,
0x0000001016707824ULL, 0x100fe400078e0275ULL, 0x000000006c6c783bULL, 0x000e620000000200ULL,
0x0000001014747824ULL, 0x100fe400078e0275ULL, 0x0000001017787824ULL, 0x000fe200078e0275ULL,
0x000000002a28783bULL, 0x000ee20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000e6c6c7232ULL, 0x086fe40000000000ULL, 0x0000000e6e6e7232ULL, 0x000fc40000000000ULL,
0x0000000f6d6d7232ULL, 0x080fe40000000000ULL, 0x0000000f6f6f7232ULL, 0x000fe40000000000ULL,
0x0000001028287232ULL, 0x088fe40000000000ULL, 0x000000102a2a7232ULL, 0x000fe40000000000ULL,
0x0000001129297232ULL, 0x080fe40000000000ULL, 0x000000112b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010187c7824ULL, 0x000fe200078e0275ULL,
0x000000007070783bULL, 0x000f220000004200ULL, 0x0000e00024247810ULL, 0x000fe20007ffe0ffULL,
0x0000024000007945ULL, 0x000fe40003800000ULL, 0x000000007474783bULL, 0x000ee40000004200ULL,
0x0000001022227824ULL, 0x000fc400078e0224ULL, 0x000000007878783bULL, 0x000ea80000004200ULL,
0x000000007c7c783bULL, 0x000e640000004200ULL, 0x000000706c2c723cULL, 0x092f70000000182cULL,
0x00000070284c723cULL, 0x048b6e000000184cULL, 0x0000001019707824ULL, 0x120fe200078e0227ULL,
0x000000722850723cULL, 0x000f620000001850ULL, 0x000000101a277824ULL, 0x000fce00078e0227ULL,
0x000000742854723cULL, 0x040f700000001854ULL, 0x000000762858723cULL, 0x040f700000001858ULL,
0x00000078285c723cULL, 0x044f70000000185cULL, 0x0000007a2860723cULL, 0x040f700000001860ULL,
0x0000007c2864723cULL, 0x000f700000001864ULL, 0x000000726c30723cULL, 0x000b640000001830ULL,
0x000000007070783bULL, 0x020e6c0000000200ULL, 0x0000007e2828723cULL, 0x000b640000001868ULL,
0x000000002768783bULL, 0x0204ec0000000200ULL, 0x000000746c34723cULL, 0x040b6e0000001834ULL,
0x0000001023747824ULL, 0x120fe200078e0224ULL, 0x000000766c38723cULL, 0x040f700000001838ULL,
0x000000786c3c723cULL, 0x040f70000000183cULL, 0x0000007a6c40723cULL, 0x040f700000001840ULL,
0x0000007c6c44723cULL, 0x040f700000001844ULL, 0x0000007e6c48723cULL, 0x000b6e0000001848ULL,
0x00000010216c7824ULL, 0x020fe200078e0224ULL, 0x0000008000008947ULL, 0x000fd60003800000ULL,
0x0000000e70707232ULL, 0x08efe40000000000ULL, 0x0000000e72727232ULL, 0x000fc40000000000ULL,
0x0000000f71717232ULL, 0x080fe40000000000ULL, 0x0000000f73737232ULL, 0x000fe40000000000ULL,
0x0000001068687232ULL, 0x080fe40000000000ULL, 0x000000106a6a7232ULL, 0x000fe40000000000ULL,
0x0000001169697232ULL, 0x080fe40000000000ULL, 0x000000116b6b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x00efea0003800000ULL, 0x0000001020787824ULL, 0x000fe200078e0224ULL,
0x000000006c6c783bULL, 0x000e680000004200ULL, 0x000000002220783bULL, 0x000ea80000004200ULL,
0x000000007474783bULL, 0x000ee80000004200ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x0000006c684c723cULL, 0x042f70000000184cULL, 0x0000006e6850723cULL, 0x040f700000001850ULL,
0x000000206854723cULL, 0x044f700000001854ULL, 0x000000226858723cULL, 0x040f700000001858ULL,
0x00000074685c723cULL, 0x048f70000000185cULL, 0x000000766860723cULL, 0x040f700000001860ULL,
0x000000786864723cULL, 0x010f700000001864ULL, 0x0000006c702c723cULL, 0x040f70000000182cULL,
0x0000006e7030723cULL, 0x040f700000001830ULL, 0x000000227038723cULL, 0x040f700000001838ULL,
0x00000074703c723cULL, 0x040f70000000183cULL, 0x000000767040723cULL, 0x040f700000001840ULL,
0x000000787044723cULL, 0x040f700000001844ULL, 0x0000007a7048723cULL, 0x080f700000001848ULL,
0x0000007a6868723cULL, 0x000f700000001828ULL, 0x000000207034723cULL, 0x000b6e0000001834ULL,
0x00000002ff207819ULL, 0x020fc80000011600ULL, 0x0001669820217811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fcc0000008000ULL, 0x0000030003037a10ULL, 0x000fe20007ffe0ffULL,
0x0000000021ff7f8cULL, 0x0003e6000c80043fULL, 0x000000060300720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x00000ba000000947ULL, 0x000fea0003800000ULL,
0x0000000103217810ULL, 0x042fe20007ffe0ffULL, 0x0000010003227824ULL, 0x000fc600078e0208ULL,
0x000000062100720cULL, 0x000fe20003f06070ULL, 0x0000660009777a24ULL, 0x000fd800078e0222ULL,
0x0000061000008947ULL, 0x000fea0003800000ULL, 0x00000003ff747819ULL, 0x000fe40000011604ULL,
0x0000002205217217ULL, 0x000fe40007800000ULL, 0x0000000474287810ULL, 0x040fe20007ffe0ffULL,
0x0000000174297824ULL, 0x040fe200078e0277ULL, 0x00000008746c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000121217824ULL, 0x000fe200078e0a22ULL, 0x0000000c74727810ULL, 0x000fe20007ffe0ffULL,
0x0000000128237824ULL, 0x100fe200078e0204ULL, 0x0000001074767810ULL, 0x000fe20007ffe0ffULL,
0x00000008282a7824ULL, 0x000fe200078e00ffULL, 0x0000002021217817ULL, 0x000fe20003800000ULL,
0x000000016c277824ULL, 0x000fc400078e0204ULL, 0x000000086c6e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a757812ULL, 0x000fe200078ee223ULL, 0x000000800a227824ULL, 0x000fe200078e020bULL,
0x000000212800720cULL, 0x080fe20003f86070ULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0xfffffff86e7d7812ULL, 0x000fe200078ee227ULL, 0x00000001282b7824ULL, 0x000fe200078e0277ULL,
0x000000217200720cULL, 0x0c0fe20003f46070ULL, 0x0000000172277824ULL, 0x000fe200078e0204ULL,
0x000000216c00720cULL, 0x080fe20003f66070ULL, 0x00000008726e7824ULL, 0x000fe200078e00ffULL,
0x000000217400720cULL, 0x000fe20003fa6070ULL, 0x0000010029287825ULL, 0x000fc600078e0022ULL,
0xfffffff86e7f7812ULL, 0x000fe200078ee227ULL, 0x000001002b2a7825ULL, 0x000fe200078e0022ULL,
0x00006200286e7a10ULL, 0x000fc60007f1e0ffULL, 0x00000001766d7824ULL, 0x000fe200078e0204ULL,
0x000062002a707a10ULL, 0x000fe20007f3e0ffULL, 0x0000000876787824ULL, 0x000fe200078e00ffULL,
0x00006300296f7a10ULL, 0x000fe200007fe4ffULL, 0x000000016c297824ULL, 0x100fe200078e0277ULL,
0x000063002b717a10ULL, 0x000fe20000ffe4ffULL, 0x00000001722b7824ULL, 0x000fe200078e0277ULL,
0xfffffff878857812ULL, 0x000fe200078ee26dULL, 0x0000010029287825ULL, 0x000fe200078e0022ULL,
0x0000001474787810ULL, 0x000fe40007ffe0ffULL, 0x000000217600720cULL, 0x040fe20003f26070ULL,
0x00000001766d7824ULL, 0x000fe200078e0277ULL, 0x0000620028727a10ULL, 0x000fe20007f1e0ffULL,
0x0000000174277824ULL, 0x000fc400078e0204ULL, 0x0000000178737824ULL, 0x040fe400078e0204ULL,
0x0000000878767824ULL, 0x000fe200078e00ffULL, 0x0000000727277812ULL, 0x000fe200078ec0ffULL,
0x000001002b2a7825ULL, 0x000fc600078e0022ULL, 0xfffffff876877812ULL, 0x000fe200078ee273ULL,
0x000001006d6c7825ULL, 0x000fe200078e0022ULL, 0x000062002a2a7a10ULL, 0x000fe40007fde0ffULL,
0x0000630029737a10ULL, 0x000fe200007fe4ffULL, 0x0000000178297824ULL, 0x000fe200078e0277ULL,
0x0ffffff827277812ULL, 0x000fe200078ef804ULL, 0x00000010757b7824ULL, 0x000fe200078e0224ULL,
0x000063002b2b7a10ULL, 0x000fe200037fe4ffULL, 0x0000010029287825ULL, 0x000fe200078e0022ULL,
0x000062006c6c7a10ULL, 0x000fc40007fde0ffULL, 0x0000001874767810ULL, 0x000fe20007ffe0ffULL,
0x0000001027797824ULL, 0x100fe200078e0224ULL, 0x000000217800720cULL, 0x080fe20003f06070ULL,
0x000000107d7d7824ULL, 0x100fe200078e0224ULL, 0x000063006d6d7a10ULL, 0x000fe200037fe4ffULL,
0x0000000176277824ULL, 0x000fe200078e0277ULL, 0x0000001c74787810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006e797faeULL, 0x0003e2000e901c48ULL,
0x0000620028747a10ULL, 0x000fe20007fde0ffULL, 0x000000107f7f7824ULL, 0x000fe200078e0224ULL,
0x000000217600720cULL, 0x080fe20003fa6070ULL, 0x00000000707b7faeULL, 0x0005e2000e101c48ULL,
0x0000630029757a10ULL, 0x000fe200037fe4ffULL, 0x0000010027287825ULL, 0x000fe200078e0022ULL,
0x000000217800720cULL, 0x040fe20003f86070ULL, 0x00000000727d7faeULL, 0x0005e4000d901c48ULL,
0x0000000178217824ULL, 0x000fe200078e0277ULL, 0x0000620028287a10ULL, 0x000fe20007fde0ffULL,
0x0000000176277824ULL, 0x140fe200078e0204ULL, 0x000000002a7f7faeULL, 0x0005e2000d101c48ULL,
0x0000000876767824ULL, 0x000fe200078e00ffULL, 0x0000630029297a10ULL, 0x000fe200037fe4ffULL,
0x00000001786e7824ULL, 0x002fc400078e0204ULL, 0x00000008786f7824ULL, 0x000fe200078e00ffULL,
0xfffffff876277812ULL, 0x000fe200078ee227ULL, 0x0000010021227825ULL, 0x000fc600078e0022ULL,
0xfffffff86f217812ULL, 0x000fe200078ee26eULL, 0x0000001085857824ULL, 0x100fe200078e0224ULL,
0x0000620022227a10ULL, 0x000fe20007fde0ffULL, 0x0000001087877824ULL, 0x100fe400078e0224ULL,
0x0000001027277824ULL, 0x100fe200078e0224ULL, 0x0000630023237a10ULL, 0x000fe200037fe4ffULL,
0x0000001021217824ULL, 0x000fe200078e0224ULL, 0x000000006c857faeULL, 0x0005e8000c901c48ULL,
0x0000000074877faeULL, 0x0005e8000c101c48ULL, 0x0000000028277faeULL, 0x0005e8000e901c48ULL,
0x0000000022217faeULL, 0x0005e2000e101c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000000404297811ULL, 0x000fe200078fe8ffULL, 0x000000800a747824ULL, 0x000fe200078e020bULL,
0x00000008042b7811ULL, 0x040fe200078fe8ffULL, 0x000000ffff757224ULL, 0x000fe200078e00ffULL,
0x0000000c046d7811ULL, 0x040fe200078fe8ffULL, 0x0000000129217824ULL, 0x140fe200078e0204ULL,
0x00000010046f7811ULL, 0x040fe200078fe8ffULL, 0x0000000829287824ULL, 0x000fe200078e00ffULL,
0x0000001404717811ULL, 0x040fe200078fe8ffULL, 0x000000012b227824ULL, 0x140fe200078e0204ULL,
0x0000001804737811ULL, 0x000fe200078fe8ffULL, 0x000000082b7b7824ULL, 0x000fe200078e00ffULL,
0xfffffff828797812ULL, 0x000fe200078ee221ULL, 0x000000016d217824ULL, 0x000fc400078e0204ULL,
0x000000086d287824ULL, 0x000fe200078e00ffULL, 0xfffffff87b7b7812ULL, 0x000fe200078ee222ULL,
0x000000016f227824ULL, 0x140fe400078e0204ULL, 0x000000086f7f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8287d7812ULL, 0x000fe200078ee221ULL, 0x0000000171237824ULL, 0x040fe200078e0204ULL,
0x0000000404217211ULL, 0x040fe200078fe8ffULL, 0x00000008712a7824ULL, 0x000fe200078e00ffULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee222ULL, 0x0000000173277824ULL, 0x040fe200078e0204ULL,
0x0000001c04227811ULL, 0x000fe200078fe8ffULL, 0x00000008736c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a857812ULL, 0x000fe200078ee223ULL, 0x0000000129297824ULL, 0x100fe200078e0277ULL,
0x0000007704237211ULL, 0x000fe200078fe8ffULL, 0x000000012b2b7824ULL, 0x000fe200078e0277ULL,
0xfffffff86c877812ULL, 0x000fe200078ee227ULL, 0x000000016d6d7824ULL, 0x100fe200078e0277ULL,
0x0000000721277812ULL, 0x000fe200078ec0ffULL, 0x000000016f6f7824ULL, 0x000fc400078e0277ULL,
0x0000000171717824ULL, 0x100fe200078e0277ULL, 0x0ffffff827277812ULL, 0x100fe200078ef804ULL,
0x0000000173737824ULL, 0x100fe400078e0277ULL, 0x0000000122217824ULL, 0x040fe400078e0277ULL,
0x0000000122767824ULL, 0x040fe400078e0204ULL, 0x0000000822777824ULL, 0x000fe400078e00ffULL,
0x0000010023227825ULL, 0x000fc800078e0074ULL, 0x0000010029287825ULL, 0x000fe200078e0074ULL,
0x0000620022227a10ULL, 0x000fc60007f1e0ffULL, 0x000001002b2a7825ULL, 0x100fe200078e0074ULL,
0x0000620028287a10ULL, 0x000fe40007f3e0ffULL, 0x0000630023237a10ULL, 0x000fe200007fe4ffULL,
0x000001006d6c7825ULL, 0x100fe200078e0074ULL, 0x000062002a2a7a10ULL, 0x000fe40007f5e0ffULL,
0x0000630029297a10ULL, 0x000fe20000ffe4ffULL, 0x000001006f6e7825ULL, 0x100fe200078e0074ULL,
0x000062006c6c7a10ULL, 0x000fe40007f7e0ffULL, 0x000063002b2b7a10ULL, 0x000fe200017fe4ffULL,
0x0000010071707825ULL, 0x000fe200078e0074ULL, 0x000062006e6e7a10ULL, 0x000fc40007f1e0ffULL,
0x000063006d6d7a10ULL, 0x000fe20001ffe4ffULL, 0x0000010073727825ULL, 0x100fe200078e0074ULL,
0x0000620070707a10ULL, 0x000fe40007f3e0ffULL, 0x000063006f6f7a10ULL, 0x000fe200007fe4ffULL,
0x0000010021747825ULL, 0x000fe200078e0074ULL, 0xfffffff877217812ULL, 0x000fe400078ee276ULL,
0x0000620072727a10ULL, 0x000fe20007f5e0ffULL, 0x0000001027277824ULL, 0x100fe200078e0224ULL,
0x0000620074747a10ULL, 0x000fe20007f7e0ffULL, 0x0000001079797824ULL, 0x100fe200078e0224ULL,
0x0000630071717a10ULL, 0x000fe20000ffe4ffULL, 0x000000107b7b7824ULL, 0x100fe200078e0224ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000022277faeULL, 0x0003e2000b901c48ULL,
0x000000107d7d7824ULL, 0x100fe200078e0224ULL, 0x0000630073737a10ULL, 0x000fe200017fe4ffULL,
0x000000107f7f7824ULL, 0x100fe200078e0224ULL, 0x0000000028797faeULL, 0x0003e2000b901c48ULL,
0x0000001085857824ULL, 0x100fe200078e0224ULL, 0x0000630075757a10ULL, 0x000fe20001ffe4ffULL,
0x0000001087877824ULL, 0x100fe200078e0224ULL, 0x000000002a7b7faeULL, 0x0003e2000b901c48ULL,
0x0000001021217824ULL, 0x000fc600078e0224ULL, 0x000000006c7d7faeULL, 0x0003e8000b901c48ULL,
0x000000006e7f7faeULL, 0x0003e8000b901c48ULL, 0x0000000070857faeULL, 0x0003e8000b901c48ULL,
0x0000000072877faeULL, 0x0003e8000b901c48ULL, 0x0000000074217faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x002e220000000000ULL, 0x0000001007217812ULL, 0x004fc400078ec0ffULL,
0x0000000807247812ULL, 0x000fc600078ec0ffULL, 0x0000002020217824ULL, 0x000fc800078e0221ULL,
0x0000000124247824ULL, 0x000fe200078e0221ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0166680024287f8cULL, 0x0002a4000c80043fULL, 0x0000000000207805ULL, 0x000fc40000015200ULL,
0x01666c0024237984ULL, 0x000ee40000000800ULL, 0x8000000023ff7812ULL, 0x00cfe40007804829ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002220277210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e21ULL, 0x003d09002700780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402700780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff227819ULL, 0x000fc80000011423ULL,
0x0000002722227211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e0623ULL,
0x0000000222227819ULL, 0x000fc80000001223ULL, 0x000000220000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012a2a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01666c0024237984ULL, 0x000ea40000000800ULL,
0x8000000023ff7812ULL, 0x004fe40007804829ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000300207811ULL, 0x000fca00078ff0ffULL, 0x0000008020217824ULL, 0x000fc800078e020bULL,
0x000000010c217824ULL, 0x000fca00078e0221ULL, 0x0160000021237984ULL, 0x000ea80000000800ULL,
0x0162000021227984ULL, 0x0006620000000800ULL, 0x000000262300720bULL, 0x004fe20003f1d000ULL,
0x000100827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000217806ULL, 0x008fc800000e0100ULL,
0x000000ff2100720cULL, 0x000fe20003f25270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff207224ULL, 0x000fd400078e0026ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x0000000300277811ULL, 0x000fe400078ff0ffULL,
0x000000262300720bULL, 0x000fe40003f34000ULL, 0x000000002700720cULL, 0x000fe20003f05270ULL,
0x000100327f007947ULL, 0x000fd4000b800000ULL, 0x0000000000207806ULL, 0x000fc400008e0100ULL,
0x0000008000278824ULL, 0x000fe200078e020bULL, 0x00000026230b8209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x000000010c0c8824ULL, 0x000fca00078e0227ULL,
0x0164000b0c008388ULL, 0x0005e20000000800ULL, 0x000000ff2000720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x00000026230b7209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff20ff7812ULL, 0x000fc6000780c0ffULL,
0x000000260b0b7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL,
0x0000000b000c7308ULL, 0x000ea40000000800ULL, 0x0000000c25257220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe20000011604ULL,
0x0000ff627f007947ULL, 0x000fea000b800000ULL, 0x00001f290c297589ULL, 0x0004e400000e0000ULL,
0x000000292c2c7220ULL, 0x08cfe20000410000ULL, 0x000000292d2d7220ULL, 0x080fe20000410000ULL,
0x0000002930307220ULL, 0x080fe20000410000ULL, 0x0000002931317220ULL, 0x080fe20000410000ULL,
0x0000002934347220ULL, 0x080fe20000410000ULL, 0x0000002935357220ULL, 0x080fe20000410000ULL,
0x0000002938387220ULL, 0x080fe20000410000ULL, 0x0000002939397220ULL, 0x080fe20000410000ULL,
0x000000293c3c7220ULL, 0x080fe20000410000ULL, 0x000000293d3d7220ULL, 0x080fe20000410000ULL,
0x0000002940407220ULL, 0x080fe20000410000ULL, 0x0000002941417220ULL, 0x080fe20000410000ULL,
0x0000002944447220ULL, 0x080fe20000410000ULL, 0x0000002945457220ULL, 0x080fe20000410000ULL,
0x0000002948487220ULL, 0x080fe20000410000ULL, 0x0000002949497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0020ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000804297811ULL, 0x000fe200078ff0ffULL, 0x0000fe327f007947ULL, 0x000fea000b800000ULL,
0x00001f290c297589ULL, 0x0004e400000e0000ULL, 0x000000292e2e7220ULL, 0x08cfe20000410000ULL,
0x000000292f2f7220ULL, 0x080fe20000410000ULL, 0x0000002932327220ULL, 0x080fe20000410000ULL,
0x0000002933337220ULL, 0x080fe20000410000ULL, 0x0000002936367220ULL, 0x080fe20000410000ULL,
0x0000002937377220ULL, 0x080fe20000410000ULL, 0x000000293a3a7220ULL, 0x080fe20000410000ULL,
0x000000293b3b7220ULL, 0x080fe20000410000ULL, 0x000000293e3e7220ULL, 0x080fe20000410000ULL,
0x000000293f3f7220ULL, 0x080fe20000410000ULL, 0x0000002942427220ULL, 0x080fe20000410000ULL,
0x0000002943437220ULL, 0x080fe20000410000ULL, 0x0000002946467220ULL, 0x080fe20000410000ULL,
0x0000002947477220ULL, 0x080fe20000410000ULL, 0x000000294a4a7220ULL, 0x080fe20000410000ULL,
0x000000294b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000020ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001004297811ULL, 0x000fe200078ff0ffULL,
0x0000fd027f007947ULL, 0x000fea000b800000ULL, 0x00001f290c297589ULL, 0x0004e400000e0000ULL,
0x000000294c4c7220ULL, 0x08cfe20000410000ULL, 0x000000294d4d7220ULL, 0x080fe20000410000ULL,
0x0000002950507220ULL, 0x080fe20000410000ULL, 0x0000002951517220ULL, 0x080fe20000410000ULL,
0x0000002954547220ULL, 0x080fe20000410000ULL, 0x0000002955557220ULL, 0x080fe20000410000ULL,
0x0000002958587220ULL, 0x080fe20000410000ULL, 0x0000002959597220ULL, 0x080fe20000410000ULL,
0x000000295c5c7220ULL, 0x080fe20000410000ULL, 0x000000295d5d7220ULL, 0x080fe20000410000ULL,
0x0000002960607220ULL, 0x080fe20000410000ULL, 0x0000002961617220ULL, 0x080fe20000410000ULL,
0x0000002964647220ULL, 0x080fe20000410000ULL, 0x0000002965657220ULL, 0x080fe20000410000ULL,
0x0000002968687220ULL, 0x080fe20000410000ULL, 0x0000002969697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000020ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001804297811ULL, 0x000fe200078ff0ffULL,
0x0000fbe27f007947ULL, 0x000fea000b800000ULL, 0x00001f290c297589ULL, 0x0004e400000e0000ULL,
0x000000294e4e7220ULL, 0x08cfe20000410000ULL, 0x000000294f4f7220ULL, 0x080fe20000410000ULL,
0x0000002952527220ULL, 0x080fe20000410000ULL, 0x0000002953537220ULL, 0x080fe20000410000ULL,
0x0000002956567220ULL, 0x080fe20000410000ULL, 0x0000002957577220ULL, 0x080fe20000410000ULL,
0x000000295a5a7220ULL, 0x080fe20000410000ULL, 0x000000295b5b7220ULL, 0x080fe20000410000ULL,
0x000000295e5e7220ULL, 0x080fe20000410000ULL, 0x000000295f5f7220ULL, 0x080fe20000410000ULL,
0x0000002962627220ULL, 0x080fe20000410000ULL, 0x0000002963637220ULL, 0x080fe20000410000ULL,
0x0000002966667220ULL, 0x080fe20000410000ULL, 0x0000002967677220ULL, 0x080fe20000410000ULL,
0x000000296a6a7220ULL, 0x080fe20000410000ULL, 0x000000296b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000002021ff7212ULL, 0x000fe400078030ffULL,
0x0000002623207209ULL, 0x000fd60007810000ULL, 0x8000002023230221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL, 0x00000023000d0308ULL, 0x000ea40000000800ULL,
0x0000000d22220220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000002522257221ULL, 0x002fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x0000000dff0b723eULL, 0x000fe400000000ffULL, 0x00000002ff0c7819ULL, 0x000fe40000011604ULL,
0x000054100b0b7816ULL, 0x000fe2000000000bULL, 0x0000fa127f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0b0e7589ULL, 0x0002a400000e0000ULL, 0x000000080c297810ULL, 0x000fe20007ffe0ffULL,
0x0000fa427f007947ULL, 0x000fea000b800000ULL, 0x000000100c107810ULL, 0x000fe20007ffe0ffULL,
0x00001f290b0f7589ULL, 0x00066a00000e0000ULL, 0x00001f100b107589ULL, 0x0006a400000e0000ULL,
0x000000180c297810ULL, 0x008fe20007ffe0ffULL, 0x0000fa927f007947ULL, 0x000fea000b800000ULL,
0x00001f290b117589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001ff217819ULL, 0x000fe20000011600ULL, 0x0000000812237824ULL, 0x000fe200078e00ffULL,
0x00000004ff0c7819ULL, 0x002fe20000011604ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000001210b7812ULL, 0x008fe200078ec0ffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x0000000300227811ULL, 0x000fe200078ff0ffULL, 0x0000001016787824ULL, 0x000fc400078e021bULL,
0x000000040b0b7824ULL, 0x000fe400078e020cULL, 0x00000010147c7824ULL, 0x000fe400078e021bULL,
0x00000001130c7824ULL, 0x140fe400078e020bULL, 0x0000000112127824ULL, 0x000fe200078e020bULL,
0x0000a000220b7811ULL, 0x000fe200078e60ffULL, 0x0000000813137824ULL, 0x000fe400078e00ffULL,
0x00000010176c7824ULL, 0x000fe200078e021bULL, 0xfffffff823127812ULL, 0x000fc400078ee212ULL,
0xfffffff8130c7812ULL, 0x000fc600078ee20cULL, 0x0000001012127824ULL, 0x100fe400078e020bULL,
0x000000100c0c7824ULL, 0x000fc600078e020bULL, 0x000000001274783bULL, 0x0002e80000000200ULL,
0x000000000c28783bULL, 0x0002a20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000e74747232ULL, 0x08cfe40000000000ULL, 0x0000000e76767232ULL, 0x000fe40000000000ULL,
0x0000000f75757232ULL, 0x080fe40000000000ULL, 0x0000000f77777232ULL, 0x000fc40000000000ULL,
0x0000001028287232ULL, 0x080fe40000000000ULL, 0x000000102a2a7232ULL, 0x000fe40000000000ULL,
0x0000001129297232ULL, 0x080fe40000000000ULL, 0x000000112b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001018707824ULL, 0x000fe200078e021bULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x0000d00015157810ULL, 0x000fe20007ffe0ffULL,
0x0000022000007945ULL, 0x000fe40003800000ULL, 0x000000007c7c783bULL, 0x000e640000004200ULL,
0x0000001019197824ULL, 0x000fc400078e0215ULL, 0x000000006c6c783bULL, 0x000ee20000004200ULL,
0x000000101a157824ULL, 0x000fc600078e0215ULL, 0x000000007070783bULL, 0x000ea80000004200ULL,
0x000000001918783bULL, 0x000e680000000200ULL, 0x000000001514783bULL, 0x000ea20000000200ULL,
0x00000078742c723cULL, 0x058b70000000182cULL, 0x0000007a7430723cULL, 0x040b700000001830ULL,
0x0000007c7434723cULL, 0x042b700000001834ULL, 0x0000007e7438723cULL, 0x040b700000001838ULL,
0x0000006c743c723cULL, 0x040b70000000183cULL, 0x0000006e7440723cULL, 0x040b700000001840ULL,
0x000000707444723cULL, 0x044b700000001844ULL, 0x000000727448723cULL, 0x000b700000001848ULL,
0x00000078284c723cULL, 0x040b70000000184cULL, 0x0000007a2850723cULL, 0x040b700000001850ULL,
0x0000007c2854723cULL, 0x040b700000001854ULL, 0x0000007e2858723cULL, 0x040b700000001858ULL,
0x0000006c285c723cULL, 0x040b70000000185cULL, 0x0000006e2860723cULL, 0x040b700000001860ULL,
0x000000702864723cULL, 0x040b700000001864ULL, 0x000000722868723cULL, 0x000b620000001868ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000008000008947ULL, 0x000fde0003800000ULL,
0x0000000e18187232ULL, 0x080fe40000000000ULL, 0x0000000e1a1a7232ULL, 0x000fc40000000000ULL,
0x0000000f19197232ULL, 0x080fe40000000000ULL, 0x0000000f1b1b7232ULL, 0x000fe40000000000ULL,
0x0000001014147232ULL, 0x080fe40000000000ULL, 0x0000001016167232ULL, 0x000fe40000000000ULL,
0x0000001115157232ULL, 0x080fe40000000000ULL, 0x0000001117177232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000001c28783bULL, 0x020e620000004200ULL,
0x00000002000b7824ULL, 0x000fc600078e00ffULL, 0x000000001d6c783bULL, 0x000ea40000004200ULL,
0xfffffff80b0b7812ULL, 0x000fe400078ec0ffULL, 0x000000001e70783bULL, 0x000ee80000004200ULL,
0x000000001f74783bULL, 0x000f220000004200ULL, 0x00000028182c723cULL, 0x042b70000000182cULL,
0x0000002a1830723cULL, 0x040b700000001830ULL, 0x0000006c1834723cULL, 0x044b700000001834ULL,
0x0000006e1838723cULL, 0x040b700000001838ULL, 0x00000070183c723cULL, 0x048b70000000183cULL,
0x000000721840723cULL, 0x040b700000001840ULL, 0x000000741844723cULL, 0x050b700000001844ULL,
0x000000761848723cULL, 0x000b700000001848ULL, 0x00000028144c723cULL, 0x040b70000000184cULL,
0x0000002a1450723cULL, 0x040b700000001850ULL, 0x0000006c1454723cULL, 0x040b700000001854ULL,
0x0000006e1458723cULL, 0x040b700000001858ULL, 0x00000070145c723cULL, 0x040b70000000185cULL,
0x000000721460723cULL, 0x040b700000001860ULL, 0x000000741464723cULL, 0x040b700000001864ULL,
0x000000761468723cULL, 0x000b620000001868ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000060300720cULL, 0x000fe20003f06070ULL, 0x0166a0000bff7f8cULL, 0x0003d8000c80043fULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff846000007947ULL, 0x000fea000383ffffULL,
0x0000000000077919ULL, 0x000e640000002500ULL, 0x000000060700720cULL, 0x002fda0003f06070ULL,
0x0000057000000947ULL, 0x000fea0003800000ULL, 0x0180000025037810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000003037812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e0025ULL, 0x000097b0000c7802ULL, 0x000fc40000000f00ULL,
0x0000f6b000007944ULL, 0x020fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000002500047308ULL, 0x000e640000001000ULL, 0xbf80000004037423ULL, 0x002fc80000000025ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000304037223ULL, 0x000fc40000000004ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000f240000000000ULL,
0x00000002ff047819ULL, 0x010fe40000011605ULL, 0x0000001005067811ULL, 0x046fe400078ff0ffULL,
0x00000018050e7811ULL, 0x040fe400078ff0ffULL, 0x00000008050c7811ULL, 0x000fe200078ff0ffULL,
0x00001f0403047589ULL, 0x008e6800000e0000ULL, 0x00001f0e03097589ULL, 0x000ea800000e0000ULL,
0x00001f0c03057589ULL, 0x000ee800000e0000ULL, 0x00001f0603067589ULL, 0x000f2200000e0000ULL,
0x0000002c042c7220ULL, 0x062fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000003804387220ULL, 0x040fe20000410000ULL, 0x0000003904397220ULL, 0x040fe20000410000ULL,
0x0000003c043c7220ULL, 0x040fe20000410000ULL, 0x0000003d043d7220ULL, 0x040fe20000410000ULL,
0x0000004004407220ULL, 0x040fe20000410000ULL, 0x0000004104417220ULL, 0x040fe20000410000ULL,
0x0000004404447220ULL, 0x040fe20000410000ULL, 0x0000004504457220ULL, 0x040fe20000410000ULL,
0x0000004804487220ULL, 0x040fe20000410000ULL, 0x0000004904497220ULL, 0x000fe20000410000ULL,
0x0000004e094e7220ULL, 0x044fe20000410000ULL, 0x0000004f094f7220ULL, 0x040fe20000410000ULL,
0x0000005209527220ULL, 0x040fe20000410000ULL, 0x0000005309537220ULL, 0x040fe20000410000ULL,
0x0000005609567220ULL, 0x040fe20000410000ULL, 0x0000005709577220ULL, 0x040fe20000410000ULL,
0x0000005a095a7220ULL, 0x040fe20000410000ULL, 0x0000005b095b7220ULL, 0x040fe20000410000ULL,
0x0000005e095e7220ULL, 0x040fe20000410000ULL, 0x0000005f095f7220ULL, 0x040fe20000410000ULL,
0x0000006209627220ULL, 0x040fe20000410000ULL, 0x0000006309637220ULL, 0x040fe20000410000ULL,
0x0000006609667220ULL, 0x040fe20000410000ULL, 0x0000006709677220ULL, 0x040fe20000410000ULL,
0x0000006a096a7220ULL, 0x040fe20000410000ULL, 0x0000006b096b7220ULL, 0x000fe20000410000ULL,
0x000000052e2e7220ULL, 0x088fe20000410000ULL, 0x000000052f2f7220ULL, 0x080fe20000410000ULL,
0x0000000532327220ULL, 0x080fe20000410000ULL, 0x0000000533337220ULL, 0x080fe20000410000ULL,
0x0000000536367220ULL, 0x080fe20000410000ULL, 0x0000000537377220ULL, 0x080fe20000410000ULL,
0x000000053a3a7220ULL, 0x080fe20000410000ULL, 0x000000053b3b7220ULL, 0x080fe20000410000ULL,
0x000000053e3e7220ULL, 0x080fe20000410000ULL, 0x000000053f3f7220ULL, 0x080fe20000410000ULL,
0x0000000542427220ULL, 0x080fe20000410000ULL, 0x0000000543437220ULL, 0x080fe20000410000ULL,
0x0000000546467220ULL, 0x080fe20000410000ULL, 0x0000000547477220ULL, 0x080fe20000410000ULL,
0x000000054a4a7220ULL, 0x080fe20000410000ULL, 0x000000054b4b7220ULL, 0x000fe20000410000ULL,
0x000000064c4c7220ULL, 0x090fe20000410000ULL, 0x000000064d4d7220ULL, 0x080fe20000410000ULL,
0x0000000650507220ULL, 0x080fe20000410000ULL, 0x0000000651517220ULL, 0x080fe20000410000ULL,
0x0000000654547220ULL, 0x080fe20000410000ULL, 0x0000000655557220ULL, 0x080fe20000410000ULL,
0x0000000658587220ULL, 0x080fe20000410000ULL, 0x0000000659597220ULL, 0x080fe20000410000ULL,
0x000000065c5c7220ULL, 0x080fe20000410000ULL, 0x000000065d5d7220ULL, 0x080fe20000410000ULL,
0x0000000660607220ULL, 0x080fe20000410000ULL, 0x0000000661617220ULL, 0x080fe20000410000ULL,
0x0000000664647220ULL, 0x080fe20000410000ULL, 0x0000000665657220ULL, 0x080fe20000410000ULL,
0x0000000668687220ULL, 0x080fe20000410000ULL, 0x0000000669697220ULL, 0x000fc20000410000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x0000002c2d06723eULL, 0x020fc400000000ffULL,
0x00000030310b723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000034350c723eULL, 0x000fe400000000ffULL, 0x00000038390d723eULL, 0x000fe400000000ffULL,
0x0000003c3d0e723eULL, 0x000fc400000000ffULL, 0x00000040410f723eULL, 0x000fe400000000ffULL,
0x000000444510723eULL, 0x000fe400000000ffULL, 0x000000484911723eULL, 0x000fe400000000ffULL,
0x0000002e2f2e723eULL, 0x000fe400000000ffULL, 0x00000002ff1b7819ULL, 0x002fe40000011603ULL,
0x00000008032c7811ULL, 0x000fc400078ff0ffULL, 0x000000011b047810ULL, 0x040fe20007ffe0ffULL,
0x000000081b1d7824ULL, 0x040fe200078e00ffULL, 0x000000031b097810ULL, 0x040fe20007ffe0ffULL,
0x000000081b227824ULL, 0x040fe200078e00ffULL, 0x000000041b1a7810ULL, 0x040fe20007ffe0ffULL,
0x000000081b1f7824ULL, 0x040fe200078e00ffULL, 0x000000021b057810ULL, 0x040fe20007ffe0ffULL,
0x000000081b1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1c7812ULL, 0x000fe200078ee204ULL,
0x000000081b2a7824ULL, 0x040fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee209ULL,
0x000000081b287824ULL, 0x000fe200078e00ffULL, 0xfffffff81f247812ULL, 0x000fe200078ee21aULL,
0x000000081b1a7824ULL, 0x040fe200078e00ffULL, 0x000000051b047810ULL, 0x040fe20007ffe0ffULL,
0x000000082c1f7824ULL, 0x000fe200078e00ffULL, 0xffffffff1b097810ULL, 0x000fc40007ffe0ffULL,
0xfffffff81e1e7812ULL, 0x000fe400078ee205ULL, 0x000000061b057810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81d267812ULL, 0x000fe200078ee204ULL, 0x000020000a047824ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee209ULL, 0x0000100021097824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee21bULL, 0x00000004031b7824ULL, 0x040fe200078e00ffULL,
0x0000001003307811ULL, 0x000fc400078ff0ffULL, 0xfffffff828287812ULL, 0x000fe200078ee205ULL,
0x0000000104057824ULL, 0x000fe200078e0209ULL, 0x0000001803347811ULL, 0x000fe200078ff0ffULL,
0x00000008301d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f2c7812ULL, 0x000fe200078ee22cULL,
0x000000101a1a7824ULL, 0x100fe200078e0205ULL, 0x0000000c1b1b7812ULL, 0x000fe200078ec0ffULL,
0x00000008341f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d307812ULL, 0x000fe200078ee230ULL,
0x000000101c1c7824ULL, 0x100fe200078e0205ULL, 0x000000323332723eULL, 0x000fe200000000ffULL,
0x000000101e1e7824ULL, 0x100fe200078e0205ULL, 0xfffffff81f347812ULL, 0x000fe200078ee234ULL,
0x0000001022227824ULL, 0x100fe200078e0205ULL, 0x000000363736723eULL, 0x000fe200000000ffULL,
0x0000001024247824ULL, 0x000fe200078e0205ULL, 0x0000003a3b3a723eULL, 0x000fe200000000ffULL,
0x000000011a1d7824ULL, 0x000fe200078e021bULL, 0x0000003e3f3e723eULL, 0x000fe200000000ffULL,
0x0000001026267824ULL, 0x100fe200078e0205ULL, 0x000000424342723eULL, 0x000fe200000000ffULL,
0x000000011b1c7824ULL, 0x000fe200078e021cULL, 0x000000061d007388ULL, 0x000fe20000000800ULL,
0x0000001028287824ULL, 0x100fe200078e0205ULL, 0x000000464746723eULL, 0x000fe200000000ffULL,
0x000000011b1f7824ULL, 0x000fe200078e021eULL, 0x0000000b1c007388ULL, 0x000fe20000000800ULL,
0x000000102a2a7824ULL, 0x100fe200078e0205ULL, 0x0000004a4b4a723eULL, 0x000fe200000000ffULL,
0x000000011b227824ULL, 0x000fe200078e0222ULL, 0x0000000c1f007388ULL, 0x000fe20000000800ULL,
0x000000102c2c7824ULL, 0x100fe200078e0205ULL, 0x0000004c4d4c723eULL, 0x000fe200000000ffULL,
0x000000011b237824ULL, 0x040fe200078e0224ULL, 0x0000000d22007388ULL, 0x000fe20000000800ULL,
0x000000011b267824ULL, 0x000fe200078e0226ULL, 0x000000505150723eULL, 0x000fe200000000ffULL,
0x000000011b277824ULL, 0x040fe200078e0228ULL, 0x0000000e23007388ULL, 0x000fe20000000800ULL,
0x000000011b2a7824ULL, 0x000fe200078e022aULL, 0x000000545554723eULL, 0x000fe200000000ffULL,
0x000000011b297824ULL, 0x000fe200078e022cULL, 0x0000000f26007388ULL, 0x0003e20000000800ULL,
0x0000001030307824ULL, 0x100fe200078e0205ULL, 0x000000585958723eULL, 0x000fe200000000ffULL,
0x0000001034347824ULL, 0x000fe200078e0205ULL, 0x0000001027007388ULL, 0x000fe20000000800ULL,
0x000000011b2b7824ULL, 0x000fe200078e0230ULL, 0x0000005c5d5c723eULL, 0x000fe200000000ffULL,
0x000000011b1b7824ULL, 0x000fe200078e0234ULL, 0x000000112a007388ULL, 0x000fe20000000800ULL,
0x000000606160723eULL, 0x000fe200000000ffULL, 0x00000001080f7824ULL, 0x002fe200078e0203ULL,
0x000000646564723eULL, 0x000fe200000000ffULL, 0x0000002e29007388ULL, 0x000fe20000000800ULL,
0x000000686968723eULL, 0x000fe200000000ffULL, 0x000000100f0b7824ULL, 0x000fe200078e0204ULL,
0x0000004e4f12723eULL, 0x000fe200000000ffULL, 0x000400321c007388ULL, 0x000fe20000000800ULL,
0x000000525313723eULL, 0x000fc400000000ffULL, 0x000000565714723eULL, 0x000fe200000000ffULL,
0x000400361f007388ULL, 0x000fe20000000800ULL, 0x0000005a5b15723eULL, 0x000fe400000000ffULL,
0x0000005e5f16723eULL, 0x000fe200000000ffULL, 0x0004003a22007388ULL, 0x000fe20000000800ULL,
0x000000626317723eULL, 0x000fe400000000ffULL, 0x000000666718723eULL, 0x000fe200000000ffULL,
0x0004003e23007388ULL, 0x000fe20000000800ULL, 0x0000006a6b19723eULL, 0x000fc600000000ffULL,
0x0004004226007388ULL, 0x000fe80000000800ULL, 0x0004004627007388ULL, 0x000fe80000000800ULL,
0x0004004a2a007388ULL, 0x000fe80000000800ULL, 0x0000004c2b007388ULL, 0x000fe80000000800ULL,
0x000800501c007388ULL, 0x000fe80000000800ULL, 0x000800541f007388ULL, 0x000fe80000000800ULL,
0x0008005822007388ULL, 0x000fe80000000800ULL, 0x0008005c23007388ULL, 0x000fe80000000800ULL,
0x0008006026007388ULL, 0x000fe80000000800ULL, 0x0008006427007388ULL, 0x000fe80000000800ULL,
0x000800682a007388ULL, 0x000fe80000000800ULL, 0x000000121b007388ULL, 0x0003e80000000800ULL,
0x000c00131c007388ULL, 0x000fe80000000800ULL, 0x000c00141f007388ULL, 0x000fe20000000800ULL,
0x00000300ff1b7624ULL, 0x002fc600078e00ffULL, 0x000c001522007388ULL, 0x000fe40000000800ULL,
0x000000011b00780cULL, 0x000fe40003f05270ULL, 0x000c001623007388ULL, 0x000fe80000000800ULL,
0x000c001726007388ULL, 0x000fe80000000800ULL, 0x000c001827007388ULL, 0x000fe80000000800ULL,
0x000c00192a007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000b2c7984ULL, 0x000e680000000c00ULL, 0x000400000b1c7984ULL, 0x000ea80000000c00ULL,
0x000800000b347984ULL, 0x000ee80000000c00ULL, 0x000c00000b147984ULL, 0x000f280000000c00ULL,
0x001000000b107984ULL, 0x000ee80000000c00ULL, 0x001400000b307984ULL, 0x000f280000000c00ULL,
0x001800000b387984ULL, 0x000f280000000c00ULL, 0x001c00000b3c7984ULL, 0x000f220000000c00ULL,
0x200000ff2f2f7230ULL, 0x002fc40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fe40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x004fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fc40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff37377230ULL, 0x008fe40000000000ULL, 0x200000ff36367230ULL, 0x000fe40000000000ULL,
0x200000ff35357230ULL, 0x000fe40000000000ULL, 0x200000ff34347230ULL, 0x000fe40000000000ULL,
0x200000ff17177230ULL, 0x010fc40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fe40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x000000132f2f7230ULL, 0x000fe40000000000ULL, 0x000000122e2e7230ULL, 0x000fe40000000000ULL,
0x000000112d2d7230ULL, 0x000fc40000000000ULL, 0x000000102c2c7230ULL, 0x000fe40000000000ULL,
0x000000331f1f7230ULL, 0x000fe40000000000ULL, 0x000000321e1e7230ULL, 0x000fe20000000000ULL,
0x0000002c0b007388ULL, 0x000fe20000000c00ULL, 0x000000311d1d7230ULL, 0x000fe40000000000ULL,
0x000000301c1c7230ULL, 0x000fe40000000000ULL, 0x0000003b37377230ULL, 0x000fc40000000000ULL,
0x0000003a36367230ULL, 0x000fe20000000000ULL, 0x0004001c0b007388ULL, 0x000fe20000000c00ULL,
0x0000003935357230ULL, 0x000fe40000000000ULL, 0x0000003834347230ULL, 0x000fe40000000000ULL,
0x0000003f17177230ULL, 0x000fe40000000000ULL, 0x0000003e16167230ULL, 0x000fe20000000000ULL,
0x000800340b007388ULL, 0x000fe20000000c00ULL, 0x0000003d15157230ULL, 0x000fc40000000000ULL,
0x0000003c14147230ULL, 0x000fca0000000000ULL, 0x000c00140b007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000394000008947ULL, 0x000fea0003800000ULL,
0x00000400ff067624ULL, 0x000fe200078e00ffULL, 0x00000000000d7919ULL, 0x000e620000002600ULL,
0x000000400f117810ULL, 0x000fc40007ffe0ffULL, 0x0000680006067a24ULL, 0x000fe200078e02ffULL,
0x00000000000e7919ULL, 0x000e620000002700ULL, 0x000000800f137810ULL, 0x000fc60007ffe0ffULL,
0x0000000f060c7811ULL, 0x040fe200078e10ffULL, 0x0000030006067a24ULL, 0x000fe200078e02ffULL,
0x000000000b1c7984ULL, 0x000ea40000000c00ULL, 0xfffffff00c277812ULL, 0x000fe400078ec0ffULL,
0x000400000b2c7984ULL, 0x000ee60000000c00ULL, 0x0000008006297824ULL, 0x040fe200078e0227ULL,
0x000800000b307984ULL, 0x000ea60000000c00ULL, 0x0000008006067824ULL, 0x000fe200078e0229ULL,
0x000c00000b347984ULL, 0x0008a80000000c00ULL, 0x0000007f06067810ULL, 0x000fe20007ffe0ffULL,
0x000004000e0d7a24ULL, 0x002fc600078e020dULL, 0xffffff8006187812ULL, 0x000fe200078ec0ffULL,
0x000003000d0c7a24ULL, 0x000fe200078e02ffULL, 0x000000c00f0b7810ULL, 0x010fc60007ffe0ffULL,
0x000000010c147824ULL, 0x000fe200078e0207ULL, 0x00006c0018077a10ULL, 0x000fc80007f1e0ffULL,
0x0000000714067211ULL, 0x000fe200078268ffULL, 0x00006d00ff077624ULL, 0x000fe200000e06ffULL,
0x0000000121ff7812ULL, 0x000fc8000780f800ULL, 0x0000000714077211ULL, 0x000fe400008f6cffULL,
0x00006c0027197a10ULL, 0x000fc60007f3e0ffULL, 0x000010000a067825ULL, 0x000fc800078e0006ULL,
0x00006d00ff1a7624ULL, 0x000fe400008e06ffULL, 0x000000100f0e7825ULL, 0x000fc800078e0006ULL,
0x0000001011107825ULL, 0x000fc800078e0006ULL, 0x0000001013127825ULL, 0x000fc800078e0006ULL,
0x000000100b067825ULL, 0x000fe200078e0006ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x00000010030b7824ULL, 0x00cfe200078e00ffULL, 0x00000001ff157819ULL, 0x000fe20000011603ULL,
0x0000008014167824ULL, 0x000fc600078e00ffULL, 0x000000700b227812ULL, 0x000fe400078ec0ffULL,
0x0000000c15157812ULL, 0x000fe400078ec0ffULL, 0x00006c0016177a10ULL, 0x000fe40007ebe029ULL,
0x00000019ff0b7819ULL, 0x000fe40000011614ULL, 0x0000001922147210ULL, 0x000fe40007a3e016ULL,
0x0000001715167210ULL, 0x000fc40007c7e022ULL, 0x00006d000b177a10ULL, 0x000fe40002fec4ffULL,
0x0000001415147210ULL, 0x000fe40007fbe0ffULL, 0x0000001aff0b7210ULL, 0x000fe40000fe440bULL,
0x00000017ff177210ULL, 0x000fc60001fe84ffULL, 0x000000ffff157224ULL, 0x000fca00028e060bULL,
0x0000002014007986ULL, 0x0003e8000c101908ULL, 0x0000002516007986ULL, 0x0003e4000c101908ULL,
0x000000ff0300720cULL, 0x00cfe20000705670ULL, 0x0000001c0e007986ULL, 0x000fe2000c101d08ULL,
0x0000017000007945ULL, 0x000fe60003800000ULL, 0x0000002c10007986ULL, 0x000fe8000c101d08ULL,
0x0000003012007986ULL, 0x000fe8000c101d08ULL, 0x0000003406007986ULL, 0x000fe8000c101d08ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff067424ULL, 0x000fe200078e00ffULL, 0xffffffff1b0b7810ULL, 0x000fc60007ffe0ffULL,
0x00006c000d067625ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x0000000b060679a8ULL, 0x000ea400099ee1c8ULL, 0x0000000b0600720cULL, 0x004fc80003f05270ULL,
0x00000001ff0d7807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x0000000dff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff067984ULL, 0x000ee40000000000ULL,
0x000000ff0600720cULL, 0x008fda0003f05270ULL, 0x0000344000008947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001003007824ULL, 0x000fe200078e00ffULL, 0x00000001ff0b7819ULL, 0x000fe40000011603ULL,
0x000000190c067211ULL, 0x000fe400078038ffULL, 0x0000007000077812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0b7812ULL, 0x000fe400078ec0ffULL, 0x0000001a0c007211ULL, 0x000fe400000f3cffULL,
0x000000060b067210ULL, 0x000fc8000791e007ULL, 0x00000000ff077210ULL, 0x000fca00007e24ffULL,
0x0000000806007981ULL, 0x000728000c1e1900ULL, 0x00008008060b7981ULL, 0x000722000c1e1900ULL,
0x000000021b00780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010008060f7981ULL, 0x008722000c1e1900ULL, 0x000000041b00780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x0001800806117981ULL, 0x008722000c1e1900ULL,
0x000000041b00780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x0002000806137981ULL, 0x008722000c1e1900ULL, 0x000000061b00780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800806157981ULL, 0x00a322000c1e1900ULL,
0x000000061b00780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081b00780cULL, 0x002fe20003f06070ULL, 0x0003000806177981ULL, 0x000318000c1e1900ULL,
0x0003800806190981ULL, 0x000324000c1e1900ULL, 0x000000071b067810ULL, 0x00afc80007ffe0ffULL,
0x00000003ff0d7819ULL, 0x004fc80000011606ULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x000000270c1d7211ULL, 0x040fe200078038ffULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1b7224ULL, 0x010fe200078e0000ULL, 0x00006c001d1d7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff0c0e7211ULL, 0x000fe400000f3cffULL, 0x000007801d1d7810ULL, 0x000fc80007f5e0ffULL,
0x00006d00ff0e7a10ULL, 0x000fc400017e240eULL, 0x0000030010007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x000000040d007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x0000000810067810ULL, 0x040fe40007ffe0ffULL,
0x0000000110077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001b00007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060eULL, 0xfffc8008061b7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x0000000910067810ULL, 0x042fe40007ffe0ffULL,
0x0000000210077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000b00007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060eULL, 0xfffd0008060b7981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000310077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000f00007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060eULL, 0xfffd8008060f7981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000410077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001100007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060eULL, 0xfffe000806117981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000510077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001300007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060eULL, 0xfffe800806137981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000610077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001500007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060eULL, 0xffff000806157981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e10067810ULL, 0x042fe40007ffe0ffULL,
0x0000000710077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001700007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060eULL, 0xffff800806177981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f10067810ULL, 0x002fe40007ffe0ffULL,
0x0000001900007209ULL, 0x000fe40007810000ULL, 0x0000030006007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e060eULL, 0x0000000806197981ULL, 0x000326000c1e1900ULL,
0x000004001d1d7810ULL, 0x000fe40007f3e0ffULL, 0x0000000810107810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e060eULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x0000001003067824ULL, 0x006fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011603ULL, 0x0000007006067812ULL, 0x000fe400078ec0ffULL,
0x0000000c07077812ULL, 0x000fca00078ec0ffULL, 0x0000000106077824ULL, 0x000fca00078e0207ULL,
0x0000000007007388ULL, 0x0103e40000000800ULL, 0x00006c0018067a10ULL, 0x000fe20007f3e0ffULL,
0x0000000121117824ULL, 0x000fe200078e020cULL, 0x000000070300780cULL, 0x000fe20003f04070ULL,
0x000010000a007824ULL, 0x002fe200078e00ffULL, 0x00000001210b7812ULL, 0x000fe200078ec0ffULL,
0x00006d00ff077624ULL, 0x000fe200008e06ffULL, 0x00000001ff127819ULL, 0x000fe20000011603ULL,
0x0000001003137824ULL, 0x040fe200078e00ffULL, 0x0000002003177810ULL, 0x000fe20007ffe0ffULL,
0x00002000110e7825ULL, 0x000fe200078e0006ULL, 0x0000004003197810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000221108824ULL, 0x140fe200078e020aULL,
0x000000000e0e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000221208824ULL, 0x000fe200078e020aULL,
0x00000060031b7810ULL, 0x040fe20007ffe0ffULL, 0x00000002102a8824ULL, 0x000fe200078e020bULL,
0x00000080031d7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x000000a0031f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000220208824ULL, 0x000fe200078e020bULL,
0x000000c003237810ULL, 0x000fe20007ffe0ffULL, 0x0000001017167825ULL, 0x000fe200078e000eULL,
0x000000e003257810ULL, 0x000fe20007ffe0ffULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000100009107812ULL, 0x000fe200078ec0ffULL, 0x0000400021097824ULL, 0x000fe200078e0204ULL,
0x0000007013137812ULL, 0x000fe200078ec0ffULL, 0x0000001019187825ULL, 0x100fe200078e000eULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00006c00290d7a10ULL, 0x004fe20007f3e0ffULL, 0x000000101b1a7825ULL, 0x100fe200078e000eULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000101d1c7825ULL, 0x100fe200078e000eULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x000000101f1e7825ULL, 0x100fe200078e000eULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000001023227825ULL, 0x100fe200078e000eULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000001025247825ULL, 0x100fe200078e000eULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000001003147825ULL, 0x000fe200078e000eULL,
0x00006c00270e7a10ULL, 0x000fe20007f5e0ffULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x0000000109107824ULL, 0x000fc400078e0210ULL,
0x00000001130b7824ULL, 0x000fe400078e0212ULL, 0x00006d00ff0f7624ULL, 0x000fe200008e06ffULL,
0x0000000d11268211ULL, 0x000fe200078238ffULL, 0x00000010032b7824ULL, 0x000fe400078e0210ULL,
0x00006d00ff107624ULL, 0x000fe200010e06ffULL, 0x0000000e11288211ULL, 0x040fe200078438ffULL,
0x000000000b0b7984ULL, 0x000e620000000800ULL, 0x0000000f11278211ULL, 0x000fe200008f3cffULL,
0x0000000820208824ULL, 0x100fe200078e0203ULL, 0x0000030021007a0cULL, 0x000fe20003f26070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000142b7faeULL, 0x0005e2000b901c48ULL,
0x0000001011298211ULL, 0x000fe200010f3cffULL, 0x000000082a2a8824ULL, 0x000fc400078e0203ULL,
0x00380000162b7faeULL, 0x0007e2000b901c48ULL, 0x0000001003268825ULL, 0x040fe400078e0026ULL,
0x000081802a2d8811ULL, 0x000fe200078e20ffULL, 0x00580000182b7faeULL, 0x0009e2000b901c48ULL,
0x0000001003288825ULL, 0x000fc600078e0028ULL, 0x007800001a2b7faeULL, 0x0009e2000b901c48ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x004fe2000001ff00ULL,
0x000000ffff557224ULL, 0x000fe200078e00ffULL, 0x009800001c2b7faeULL, 0x0005e2000b901c48ULL,
0x0000000000167805ULL, 0x008fc6000001ff00ULL, 0x00b800001e2b7faeULL, 0x0007e2000b901c48ULL,
0x0000000000187805ULL, 0x010fe2000001ff00ULL, 0x00008580201b8811ULL, 0x000fe400078e20ffULL,
0x00d80000222b7faeULL, 0x0009e2000b901c48ULL, 0x000000ffff207224ULL, 0x000fe200078e00ffULL,
0x00000000001c7805ULL, 0x004fe4000001ff00ULL, 0x00f80000242b7faeULL, 0x0005e2000b901c48ULL,
0x00000000001e7805ULL, 0x008fc6000001ff00ULL, 0x00000000261b8faeULL, 0x0007e8000b901c48ULL,
0x00000000282d8faeULL, 0x0003e2000b901c48ULL, 0x0000000000227805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000247805ULL, 0x004fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x008fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x002fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x000012e000001947ULL, 0x000fea0003800000ULL,
0x000000ffff117224ULL, 0x000fe400078e00ffULL, 0x000000ffff547224ULL, 0x000fca00078e0021ULL,
0x0000000154577810ULL, 0x000fc80007ffe0ffULL, 0x0000030057007a0cULL, 0x000fda0003f06070ULL,
0x0000034000000947ULL, 0x000fea0003800000ULL, 0x000000070300780cULL, 0x000fe20003f44070ULL,
0x000000010c677824ULL, 0x000fe200078e0257ULL, 0x0000000157587812ULL, 0x040fe200078ec0ffULL,
0x0000100057567824ULL, 0x000fe200078e00ffULL, 0x00000060035d7810ULL, 0x000fe20007ffe0ffULL,
0x0000200067127825ULL, 0x000fe200078e0006ULL, 0x00000080035f7810ULL, 0x000fe40007ffe0ffULL,
0x0000100056567812ULL, 0x000fe400078ec0ffULL, 0x0000000012127210ULL, 0x000fc40007f1e0ffULL,
0x000000a003617810ULL, 0x000fe20007ffe0ffULL, 0x000000022159a824ULL, 0x100fe200078e020aULL,
0x000000c003637810ULL, 0x000fe20007ffe0ffULL, 0x00000002215ba824ULL, 0x000fe200078e020aULL,
0x000000e003657810ULL, 0x000fe20007ffe0ffULL, 0x000000025968a824ULL, 0x100fe200078e0258ULL,
0x0000002003597810ULL, 0x000fe20007ffe0ffULL, 0x000000025b6aa824ULL, 0x000fe200078e0258ULL,
0x00000040035b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109567824ULL, 0x000fe200078e0256ULL,
0x0000000e6766a211ULL, 0x040fe200078238ffULL, 0x000000ffff137224ULL, 0x000fe200000e0613ULL,
0x0000000d6764a211ULL, 0x000fe200078038ffULL, 0x0000001003697824ULL, 0x000fc400078e0256ULL,
0x0000001003567825ULL, 0x000fc800078e0012ULL, 0x0000001059587825ULL, 0x100fe200078e0012ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000056697faeULL, 0x0003e6000b901c48ULL,
0x000000105b5a7825ULL, 0x100fe200078e0012ULL, 0x0038000058697faeULL, 0x0005e6000b901c48ULL,
0x000000105d5c7825ULL, 0x100fe200078e0012ULL, 0x005800005a697faeULL, 0x0007e6000b901c48ULL,
0x000000105f5e7825ULL, 0x100fe200078e0012ULL, 0x007800005c697faeULL, 0x0007e6000b901c48ULL,
0x0000001061607825ULL, 0x100fe200078e0012ULL, 0x009800005e697faeULL, 0x0007e6000b901c48ULL,
0x0000001063627825ULL, 0x100fe200078e0012ULL, 0x00b8000060697faeULL, 0x0007e6000b901c48ULL,
0x0000001065127825ULL, 0x000fe200078e0012ULL, 0x0000000f6765a211ULL, 0x040fe200000f3cffULL,
0x00d8000062697faeULL, 0x0007e2000b901c48ULL, 0x000000106767a211ULL, 0x000fe200008f3cffULL,
0x000000086868a824ULL, 0x000fc400078e0203ULL, 0x000000086a6aa824ULL, 0x000fe200078e0203ULL,
0x00f8000012697faeULL, 0x0007e2000b901c48ULL, 0x000000100364a825ULL, 0x040fe200078e0064ULL,
0x00008580686ba811ULL, 0x000fe400078e20ffULL, 0x000081806a59a811ULL, 0x004fe200078e20ffULL,
0x000000100356a825ULL, 0x002fe400078e0066ULL, 0x00000000646bafaeULL, 0x0007e8000b901c48ULL,
0x000000005659afaeULL, 0x0007e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000008054127824ULL, 0x008fe200078e00ffULL, 0x00000001ff587819ULL, 0x100fe20000011603ULL,
0x0000000221577824ULL, 0x000fe200078e020aULL, 0x00000002ff6b7819ULL, 0x000fe20000011603ULL,
0x0000001003137824ULL, 0x000fe200078e00ffULL, 0x0000008012127812ULL, 0x000fc400078ec0ffULL,
0x000000026b597810ULL, 0x040fe20007ffe0ffULL, 0x000000086b617824ULL, 0x000fe200078e00ffULL,
0x0000007013137812ULL, 0x000fe200078ec0ffULL, 0x0000010057567824ULL, 0x000fe200078e0012ULL,
0x0000000c58127812ULL, 0x000fe200078ec0ffULL, 0x000000086b5a7824ULL, 0x040fe200078e00ffULL,
0x000000086b6d7810ULL, 0x040fe20007ffe0ffULL, 0x000000086b5c7824ULL, 0x040fe200078e00ffULL,
0x0000005612577210ULL, 0x000fe20007ffe013ULL, 0x000000086b677824ULL, 0x040fe200078e00ffULL,
0x000000016b567810ULL, 0x000fe20007ffe0ffULL, 0x000000086d5e7824ULL, 0x000fe200078e00ffULL,
0xfffffff85a637812ULL, 0x000fe200078ee259ULL, 0x0000000403597824ULL, 0x000fe200078e00ffULL,
0xfffffff861617812ULL, 0x000fe200078ee256ULL, 0x0000100054567824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0081800057587984ULL, 0x000e620000000800ULL,
0x0000100056567812ULL, 0x000fe200078ec0ffULL, 0x000000086b6f7824ULL, 0x000fe200078e00ffULL,
0x0000000c59687812ULL, 0x000fe200078ec0ffULL, 0x00858000575f7984ULL, 0x0004e20000000800ULL,
0x0000018009567810ULL, 0x000fe20007ffe056ULL, 0x000000086b717824ULL, 0x040fe200078e00ffULL,
0x000000046b5b7810ULL, 0x040fe20007ffe0ffULL, 0x000000086b607824ULL, 0x040fe200078e00ffULL,
0x000000106b737810ULL, 0x040fe40007ffe0ffULL, 0x000000186b757810ULL, 0x000fc40007ffe0ffULL,
0xfffffff85c577812ULL, 0x044fe400078ee26bULL, 0xfffffff85c697812ULL, 0x000fe200078ee25bULL,
0x00000008735c7824ULL, 0x000fe200078e00ffULL, 0xfffffff85e597812ULL, 0x000fe200078ee26dULL,
0x0000001057577824ULL, 0x000fe200078e0256ULL, 0x000000036b5a7810ULL, 0x000fe20007ffe0ffULL,
0x00000008755e7824ULL, 0x000fe200078e00ffULL, 0xfffffff85c5b7812ULL, 0x000fe200078ee273ULL,
0x0000000168577824ULL, 0x000fe200078e0257ULL, 0xfffffff867677812ULL, 0x000fe200078ee25aULL,
0x0000001059597824ULL, 0x100fe200078e0256ULL, 0xfffffff85e5d7812ULL, 0x000fe200078ee275ULL,
0x000000105b5b7824ULL, 0x100fe200078e0256ULL, 0x000000056b5a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000057577984ULL, 0x000ea20000000800ULL, 0x0000000168597824ULL, 0x040fe200078e0259ULL,
0x000000066b5c7810ULL, 0x000fe20007ffe0ffULL, 0x000000105d5d7824ULL, 0x000fe200078e0256ULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee25aULL, 0x00000001685b7824ULL, 0x040fe200078e025bULL,
0x0000000059647984ULL, 0x0008a20000000800ULL, 0x00000001685e7824ULL, 0x040fe200078e025dULL,
0xfffffff871717812ULL, 0x000fe200078ee25cULL, 0x00000010695d7824ULL, 0x100fe200078e0256ULL,
0x000000005b657984ULL, 0x000ea20000000800ULL, 0x00000010675c7824ULL, 0x000fe200078e0256ULL,
0x000000580b587221ULL, 0x002fe20000010100ULL, 0x00000001685d7824ULL, 0x000fe200078e025dULL,
0x000000005e667984ULL, 0x000fe20000000800ULL, 0x0000001063597824ULL, 0x010fe200078e0256ULL,
0x3fb8aa3b58587820ULL, 0x000fe20000410000ULL, 0x00000001685c7824ULL, 0x040fe200078e025cULL,
0x000000005d5e7984ULL, 0x000e620000000800ULL, 0x00000001685a7824ULL, 0x000fe200078e0259ULL,
0x0000000254547810ULL, 0x000fc40007ffe0ffULL, 0x0000005800587308ULL, 0x000ee40000000800ULL,
0x000000005a5b7984ULL, 0x000fe20000000800ULL, 0x0000030054007a0cULL, 0x000fe20003f06070ULL,
0x0000005f586c7220ULL, 0x008fe20000410000ULL, 0x0000001061587824ULL, 0x000fe200078e0256ULL,
0xffffffff6b5f7810ULL, 0x000fe20007ffe0ffULL, 0x30000057ff637230ULL, 0x004fe20000004100ULL,
0x000000556c557221ULL, 0x000fe20000010000ULL, 0x0000000168587824ULL, 0x000fe200078e0258ULL,
0xfffffff860617812ULL, 0x000fe200078ee25fULL, 0x0000001071607824ULL, 0x100fe200078e0256ULL,
0x00001f6d6c6d7589ULL, 0x000ea200000e0000ULL, 0x000000106f5f7824ULL, 0x000fc400078e0256ULL,
0x0000001061627824ULL, 0x000fe200078e0256ULL, 0x0000000058597984ULL, 0x000fe20000000800ULL,
0x0000000168617824ULL, 0x040fe400078e0260ULL, 0x00000001685f7824ULL, 0x040fe200078e025fULL,
0x000000005c567984ULL, 0x000fe20000000800ULL, 0x0000000168627824ULL, 0x000fe400078e0262ULL,
0x20000057ff687230ULL, 0x000fe20000004100ULL, 0x00001f6b6c6b7589ULL, 0x000ee200000e0000ULL,
0x20000064ff6a7230ULL, 0x000fc40000004100ULL, 0x20000065ff677230ULL, 0x100fe20000004100ULL,
0x00001f736c6e7589ULL, 0x000f2200000e0000ULL, 0x30000065ff657230ULL, 0x000fe40000004100ULL,
0x2000005eff697230ULL, 0x102fe20000004100ULL, 0x00001f756c6f7589ULL, 0x000e6200000e0000ULL,
0x3000005eff5e7230ULL, 0x000fc60000004100ULL, 0x0000000061577984ULL, 0x000e620000000800ULL,
0x0000006d6a4f7223ULL, 0x004fe2000001004fULL, 0x20000066ff6a7230ULL, 0x000fe40000004100ULL,
0x000000005f607984ULL, 0x000ea20000000800ULL, 0x0000006b68517223ULL, 0x088fe20000010051ULL,
0x30000064ff687230ULL, 0x000fe20000004100ULL, 0x0000006b63507223ULL, 0x000fe20000010050ULL,
0x0004000058647984ULL, 0x000ee20000000800ULL, 0x0000006e65327223ULL, 0x090fe20000010032ULL,
0x0000006e674e7223ULL, 0x000fe2000001004eULL, 0x0000006d68337223ULL, 0x000fe20000010033ULL,
0x0000000062637984ULL, 0x000f220000000800ULL, 0x0000006f6a317223ULL, 0x002fe20000010031ULL,
0x30000066ff6a7230ULL, 0x000fe20000004100ULL, 0x0000006b69447223ULL, 0x080fe20000010044ULL,
0x000400005a657984ULL, 0x000e620000000800ULL, 0x20000059ff667230ULL, 0x100fe20000004100ULL,
0x0000006b5e417223ULL, 0x000fe20000010041ULL, 0x30000059ff687230ULL, 0x000fe20000004100ULL,
0x0000006f6a477223ULL, 0x000fe20000010047ULL, 0x000400005c597984ULL, 0x000e620000000800ULL,
0x0000006b662f7223ULL, 0x080fe2000001002fULL, 0x2000005bff677230ULL, 0x100fe20000004100ULL,
0x0000006b684d7223ULL, 0x000fe2000001004dULL, 0x000400005d667984ULL, 0x000e620000000800ULL,
0x3000005bff687230ULL, 0x000fc40000004100ULL, 0x20000056ff5b7230ULL, 0x100fe20000004100ULL,
0x0000006b674c7223ULL, 0x080fe2000001004cULL, 0x30000056ff567230ULL, 0x000fe20000004100ULL,
0x000400005f677984ULL, 0x000e620000000800ULL, 0x0000006b68377223ULL, 0x080fe20000010037ULL,
0x20000057ff697230ULL, 0x100fe20000004100ULL, 0x0000006b5b487223ULL, 0x080fe20000010048ULL,
0x0000006b56457223ULL, 0x080fe20000010045ULL, 0x30000057ff5e7230ULL, 0x000fe20000004100ULL,
0x0004000061567984ULL, 0x000e620000000800ULL, 0x20000060ff5b7230ULL, 0x104fe20000004100ULL,
0x0000006b693c7223ULL, 0x080fe2000001003cULL, 0x30000060ff607230ULL, 0x000fe20000004100ULL,
0x0004000062577984ULL, 0x000ea20000000800ULL, 0x0000006b5e397223ULL, 0x080fe20000010039ULL,
0x0000006b5b207223ULL, 0x000fc40000010020ULL, 0x0000006b603d7223ULL, 0x000fe2000001003dULL,
0x00080000585b7984ULL, 0x000ea20000000800ULL, 0x20000064ff687230ULL, 0x008fc60000004100ULL,
0x000c000058607984ULL, 0x000ee20000000800ULL, 0x30000064ff697230ULL, 0x000fe40000004100ULL,
0x20000063ff5e7230ULL, 0x110fe20000004100ULL, 0x000800005c587984ULL, 0x000fe20000000800ULL,
0x30000063ff637230ULL, 0x000fe20000004100ULL, 0x0000006d694a7223ULL, 0x000fe2000001004aULL,
0x20000065ff647230ULL, 0x102fe20000004100ULL, 0x0000006b5e4b7223ULL, 0x000fe2000001004bULL,
0x30000065ff657230ULL, 0x000fe20000004100ULL, 0x000800005a5e7984ULL, 0x000e620000000800ULL,
0x20000059ff697230ULL, 0x100fe20000004100ULL, 0x0000006d641b7223ULL, 0x080fe2000001001bULL,
0x30000059ff647230ULL, 0x000fe20000004100ULL, 0x0000006d65307223ULL, 0x080fe20000010030ULL,
0x20000066ff597230ULL, 0x000fe20000004100ULL, 0x0000006d68357223ULL, 0x000fe20000010035ULL,
0x0000006b63367223ULL, 0x000fe20000010036ULL, 0x0000006d69467223ULL, 0x080fe20000010046ULL,
0x000c00005a637984ULL, 0x000f220000000800ULL, 0x0000006d59407223ULL, 0x080fe20000010040ULL,
0x20000067ff657230ULL, 0x100fe20000004100ULL, 0x0000006d64277223ULL, 0x000fe20000010027ULL,
0x000800005d597984ULL, 0x000f220000000800ULL, 0x30000067ff687230ULL, 0x000fc40000004100ULL,
0x0000006d653e7223ULL, 0x080fe2000001003eULL, 0x20000056ff677230ULL, 0x100fe20000004100ULL,
0x000c00005d657984ULL, 0x0005e20000000800ULL, 0x30000056ff697230ULL, 0x000fe20000004100ULL,
0x0000006d683b7223ULL, 0x080fe2000001003bULL, 0x20000057ff6b7230ULL, 0x104fe20000004100ULL,
0x000800005f567984ULL, 0x000ea20000000800ULL, 0x30000057ff577230ULL, 0x000fe20000004100ULL,
0x0000006d67267223ULL, 0x080fe20000010026ULL, 0x0000006d69387223ULL, 0x080fe20000010038ULL,
0x2000005bff5d7230ULL, 0x100fe20000004100ULL, 0x000c00005c647984ULL, 0x000ea20000000800ULL,
0x0000006d57347223ULL, 0x080fe20000010034ULL, 0x3000005bff677230ULL, 0x000fe20000004100ULL,
0x0000006d6b1c7223ULL, 0x000fe2000001001cULL, 0x0008000061577984ULL, 0x000ea20000000800ULL,
0x20000060ff5a7230ULL, 0x108fe20000004100ULL, 0x0000006e5d187223ULL, 0x080fe20000010018ULL,
0x30000060ff697230ULL, 0x000fe20000004100ULL, 0x000c0000615b7984ULL, 0x000ee20000000800ULL,
0x30000066ff667230ULL, 0x000fe20000004100ULL, 0x0000006f5a2d7223ULL, 0x000fe2000001002dULL,
0x0000006e672e7223ULL, 0x080fe2000001002eULL, 0x000c00005f5c7984ULL, 0x0008e20000000800ULL,
0x2000005eff607230ULL, 0x002fe20000004100ULL, 0x0000006d66257223ULL, 0x000fe20000010025ULL,
0x0000006f692c7223ULL, 0x000fe2000001002cULL, 0x00080000625a7984ULL, 0x000e640000000800ULL,
0x0000006e602b7223ULL, 0x000fc4000001002bULL, 0x000c0000625d7984ULL, 0x000e620000000800ULL,
0x3000005eff5f7230ULL, 0x010fe40000004100ULL, 0x20000058ff5e7230ULL, 0x100fe40000004100ULL,
0x20000063ff667230ULL, 0x000fe20000004100ULL, 0x0000006e5f427223ULL, 0x080fe20000010042ULL,
0x30000058ff5f7230ULL, 0x000fe20000004100ULL, 0x0000006e5e3f7223ULL, 0x080fe2000001003fULL,
0x20000059ff587230ULL, 0x100fe20000004100ULL, 0x0000006f66297223ULL, 0x080fe20000010029ULL,
0x30000059ff5e7230ULL, 0x000fe20000004100ULL, 0x0000006e5f2a7223ULL, 0x080fe2000001002aULL,
0x30000063ff637230ULL, 0x000fe20000004100ULL, 0x0000006e58237223ULL, 0x080fe20000010023ULL,
0x20000056ff597230ULL, 0x104fe20000004100ULL, 0x0000006e5e1f7223ULL, 0x080fe2000001001fULL,
0x30000056ff567230ULL, 0x000fe20000004100ULL, 0x0000006f63287223ULL, 0x080fe20000010028ULL,
0x20000065ff587230ULL, 0x000fe20000004100ULL, 0x0000006e591e7223ULL, 0x080fe2000001001eULL,
0x20000064ff617230ULL, 0x100fe20000004100ULL, 0x0000006e561d7223ULL, 0x080fe2000001001dULL,
0x30000064ff637230ULL, 0x000fe20000004100ULL, 0x0000006f58437223ULL, 0x080fe20000010043ULL,
0x20000057ff597230ULL, 0x100fe20000004100ULL, 0x0000006f61227223ULL, 0x080fe20000010022ULL,
0x30000057ff577230ULL, 0x000fe20000004100ULL, 0x0000006f63247223ULL, 0x080fe20000010024ULL,
0x2000005bff567230ULL, 0x008fe20000004100ULL, 0x0000006e59147223ULL, 0x080fe20000010014ULL,
0x30000065ff657230ULL, 0x000fe20000004100ULL, 0x0000006e571a7223ULL, 0x080fe2000001001aULL,
0x2000005cff587230ULL, 0x100fe20000004100ULL, 0x0000006f56197223ULL, 0x080fe20000010019ULL,
0x3000005cff5c7230ULL, 0x000fe20000004100ULL, 0x0000006f653a7223ULL, 0x080fe2000001003aULL,
0x2000005aff567230ULL, 0x102fe20000004100ULL, 0x0000006f58497223ULL, 0x080fe20000010049ULL,
0x3000005aff577230ULL, 0x000fe20000004100ULL, 0x0000006f5c537223ULL, 0x080fe20000010053ULL,
0x3000005bff5b7230ULL, 0x000fe20000004100ULL, 0x0000006e56177223ULL, 0x080fe20000010017ULL,
0x2000005dff587230ULL, 0x100fe20000004100ULL, 0x0000006e57167223ULL, 0x000fe20000010016ULL,
0x3000005dff5a7230ULL, 0x000fe20000004100ULL, 0x0000006f5b527223ULL, 0x000fc40000010052ULL,
0x0000006f58157223ULL, 0x080fe40000010015ULL, 0x0000006f5a117223ULL, 0x000fe20000010011ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffed4000007947ULL, 0x000fea000383ffffULL,
0x000000ff0a00720cULL, 0x000fe20003f05270ULL, 0x0000018000007945ULL, 0x000fd80003800000ULL,
0x0000008021038824ULL, 0x000fc800078e0213ULL, 0x0000000112008824ULL, 0x000fe400078e0203ULL,
0x0000000113127824ULL, 0x000fc600078e0212ULL, 0x0089805500008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0089800012037984ULL, 0x000e680000000800ULL,
0x008a000012067984ULL, 0x000ea20000000800ULL, 0x00000003ff037221ULL, 0x002fc80000010000ULL,
0x0000000603037221ULL, 0x004fca0000010000ULL, 0x0180000003067810ULL, 0x000fc80007ffe0ffULL,
0x7f80000006067812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0600780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x000fe200078e0003ULL, 0x0000d190000c7802ULL, 0x000fc40000000f00ULL,
0x0000bcd000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000300007308ULL, 0x000e640000001000ULL,
0xbf80000003067423ULL, 0x002fc80000000000ULL, 0x800000ff06077221ULL, 0x000fc80000010100ULL,
0x0000000700007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000803577811ULL, 0x004fc400078ff0ffULL, 0x00000002ff557819ULL, 0x000fe40000011603ULL,
0x0000001003597811ULL, 0x040fe200078ff0ffULL, 0x00001f5700077589ULL, 0x000ea200000e0000ULL,
0x00000018035b7811ULL, 0x000fe200078ff0ffULL, 0x0000000855567824ULL, 0x000fe400078e00ffULL,
0x00001f5500067589ULL, 0x002e6200000e0000ULL, 0x0000000857587824ULL, 0x000fe400078e00ffULL,
0x00000008595a7824ULL, 0x000fe200078e00ffULL, 0x00001f59000b7589ULL, 0x000ee200000e0000ULL,
0x000000085b5c7824ULL, 0x000fe200078e00ffULL, 0xfffffff858587812ULL, 0x000fc400078ee257ULL,
0x00001f5b00107589ULL, 0x00086200000e0000ULL, 0xfffffff85a5a7812ULL, 0x000fe400078ee259ULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee25bULL, 0x0000001058587824ULL, 0x100fe400078e0205ULL,
0x000000105a5a7824ULL, 0x100fe400078e0205ULL, 0x000000105c5c7824ULL, 0x000fe200078e0205ULL,
0x0000004f074f7220ULL, 0x044fe20000410000ULL, 0x00000033070e7220ULL, 0x040fe20000410000ULL,
0x0000003507357220ULL, 0x040fe20000410000ULL, 0x0000004a074a7220ULL, 0x040fe20000410000ULL,
0x0000001b071b7220ULL, 0x040fe20000410000ULL, 0x0000003007307220ULL, 0x040fe20000410000ULL,
0x0000004607467220ULL, 0x040fe20000410000ULL, 0x0000002707277220ULL, 0x040fe20000410000ULL,
0x0000004007407220ULL, 0x040fe20000410000ULL, 0x0000002507257220ULL, 0x040fe20000410000ULL,
0x0000003e073e7220ULL, 0x040fe20000410000ULL, 0x0000003b073b7220ULL, 0x040fe20000410000ULL,
0x0000002607267220ULL, 0x040fe20000410000ULL, 0x0000003807097220ULL, 0x040fe20000410000ULL,
0x0000001c071c7220ULL, 0x040fe20000410000ULL, 0x0000003407077220ULL, 0x000fe20000410000ULL,
0x0000000855347824ULL, 0x000fe200078e00ffULL, 0x0000005106517220ULL, 0x042fe20000410000ULL,
0x0000005006507220ULL, 0x040fe20000410000ULL, 0x0000002f062f7220ULL, 0x040fe20000410000ULL,
0x0000004d060c7220ULL, 0x040fe20000410000ULL, 0x0000004c064c7220ULL, 0x040fe20000410000ULL,
0x0000003706377220ULL, 0x040fe20000410000ULL, 0x0000004806487220ULL, 0x040fe20000410000ULL,
0x0000004506457220ULL, 0x040fe20000410000ULL, 0x0000004406447220ULL, 0x040fe20000410000ULL,
0x0000004106417220ULL, 0x040fe20000410000ULL, 0x0000002006207220ULL, 0x040fe20000410000ULL,
0x0000003d063d7220ULL, 0x040fe20000410000ULL, 0x0000003c063c7220ULL, 0x040fe20000410000ULL,
0x0000003906397220ULL, 0x040fe20000410000ULL, 0x0000004b064b7220ULL, 0x040fe20000410000ULL,
0x0000004e0b4e7220ULL, 0x048fe20000410000ULL, 0x000000320b0d7220ULL, 0x040fe20000410000ULL,
0x000000180b187220ULL, 0x040fe20000410000ULL, 0x0000002e0b0f7220ULL, 0x040fe20000410000ULL,
0x0000002b0b2b7220ULL, 0x040fe20000410000ULL, 0x000000420b427220ULL, 0x040fe20000410000ULL,
0x0000003f0b3f7220ULL, 0x040fe20000410000ULL, 0x0000002a0b2a7220ULL, 0x040fe20000410000ULL,
0x000000230b237220ULL, 0x040fe20000410000ULL, 0x0000001f0b007220ULL, 0x050fe20000410000ULL,
0x0000001e0b1e7220ULL, 0x040fe20000410000ULL, 0x0000001d0b1d7220ULL, 0x040fe20000410000ULL,
0x000000140b147220ULL, 0x040fe20000410000ULL, 0x0000001a0b137220ULL, 0x040fe20000410000ULL,
0x000000170b177220ULL, 0x040fe20000410000ULL, 0x000000160b167220ULL, 0x000fe20000410000ULL,
0x0000000355337810ULL, 0x040fe20007ffe0ffULL, 0x0000003606067220ULL, 0x000fe20000410000ULL,
0x0000003110317220ULL, 0x040fe20000410000ULL, 0x0000004710127220ULL, 0x040fe20000410000ULL,
0x0000002d102d7220ULL, 0x040fe20000410000ULL, 0x0000002c102c7220ULL, 0x040fe20000410000ULL,
0x0000002910297220ULL, 0x040fe20000410000ULL, 0x0000002810287220ULL, 0x040fe20000410000ULL,
0x0000002210227220ULL, 0x040fe20000410000ULL, 0x00000024100b7220ULL, 0x040fe20000410000ULL,
0x0000004310437220ULL, 0x040fe20000410000ULL, 0x0000003a103a7220ULL, 0x040fe20000410000ULL,
0x0000004910497220ULL, 0x040fe20000410000ULL, 0x00000053101a7220ULL, 0x040fe20000410000ULL,
0x0000001910197220ULL, 0x040fe20000410000ULL, 0x0000005210527220ULL, 0x040fe20000410000ULL,
0x0000001510157220ULL, 0x040fe20000410000ULL, 0x0000001110107220ULL, 0x000fe20000410000ULL,
0x0000000855367824ULL, 0x040fe200078e00ffULL, 0x0000000455117810ULL, 0x040fe20007ffe0ffULL,
0x00000008552e7824ULL, 0x040fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ee233ULL,
0x0000000855337824ULL, 0x040fe200078e00ffULL, 0x0000000655247810ULL, 0x040fe20007ffe0ffULL,
0x00000008554d7824ULL, 0x040fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe200078ee211ULL,
0x0000000855387824ULL, 0x040fe200078e00ffULL, 0x00000001551f7810ULL, 0x040fe20007ffe0ffULL,
0x0000001034347824ULL, 0x100fe200078e0205ULL, 0xffffffff55117810ULL, 0x000fe20007ffe0ffULL,
0x0000001036367824ULL, 0x000fe200078e0205ULL, 0xfffffff833547812ULL, 0x000fc400078ee224ULL,
0xfffffff856247812ULL, 0x000fe400078ee255ULL, 0x0000000255327810ULL, 0x000fe20007ffe0ffULL,
0x0000001054547824ULL, 0x000fe200078e0205ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee21fULL,
0x0000001024247824ULL, 0x000fe200078e0205ULL, 0xfffffff856567812ULL, 0x000fe200078ee211ULL,
0x0000000403117824ULL, 0x000fe200078e00ffULL, 0x00000005551f7810ULL, 0x000fe20007ffe0ffULL,
0x000000102e2e7824ULL, 0x100fe200078e0205ULL, 0xfffffff84d327812ULL, 0x000fe200078ee232ULL,
0x0000001056567824ULL, 0x000fe200078e0205ULL, 0xfffffff838387812ULL, 0x000fc400078ee21fULL,
0x0000000c11117812ULL, 0x000fe200078ec0ffULL, 0x0000001032327824ULL, 0x100fe200078e0205ULL,
0x000000515050723eULL, 0x000fe200000000ffULL, 0x0000001038387824ULL, 0x000fe200078e0205ULL,
0x0000002f0c0c723eULL, 0x000fe200000000ffULL, 0x0000000124057824ULL, 0x000fe200078e0211ULL,
0x0000004c3737723eULL, 0x000fe200000000ffULL, 0x00000001112e7824ULL, 0x000fe200078e022eULL,
0x000000484545723eULL, 0x000fe200000000ffULL, 0x0000000111327824ULL, 0x000fe200078e0232ULL,
0x000000444141723eULL, 0x000fe200000000ffULL, 0x0000000111347824ULL, 0x000fe200078e0234ULL,
0x000000203d20723eULL, 0x000fe200000000ffULL, 0x0000000111367824ULL, 0x040fe200078e0236ULL,
0x0000005005007388ULL, 0x0003e20000000800ULL, 0x0000000111387824ULL, 0x000fe200078e0238ULL,
0x0000003c3939723eULL, 0x000fe200000000ffULL, 0x0000000111547824ULL, 0x040fe200078e0254ULL,
0x000000230000723eULL, 0x000fe200000000ffULL, 0x0000000c2e007388ULL, 0x000fe20000000800ULL,
0x0000004b0606723eULL, 0x000fe200000000ffULL, 0x0000000111237824ULL, 0x040fe200078e0256ULL,
0x000000151010723eULL, 0x000fe200000000ffULL, 0x0000003732007388ULL, 0x000fe20000000800ULL,
0x0000004f0e0e723eULL, 0x000fe200000000ffULL, 0x0000000111157824ULL, 0x040fe200078e0258ULL,
0x000000354a35723eULL, 0x000fe200000000ffULL, 0x0000004534007388ULL, 0x000fe20000000800ULL,
0x0000001b301b723eULL, 0x000fe200000000ffULL, 0x00000001115a7824ULL, 0x000fe200078e025aULL,
0x000000462727723eULL, 0x000fe200000000ffULL, 0x0000004136007388ULL, 0x000fe20000000800ULL,
0x000000402525723eULL, 0x000fe200000000ffULL, 0x0000000111117824ULL, 0x000fe200078e025cULL,
0x0000003e3b3b723eULL, 0x000fe200000000ffULL, 0x0000002038007388ULL, 0x000fe20000000800ULL,
0x000000260909723eULL, 0x000fe200000000ffULL, 0x0000000108057824ULL, 0x002fe200078e0203ULL,
0x0000001c0707723eULL, 0x000fe200000000ffULL, 0x0000003954007388ULL, 0x000fe20000000800ULL,
0x0000004e0d0d723eULL, 0x000fe200000000ffULL, 0x0000001005057824ULL, 0x000fe200078e0204ULL,
0x000000180f0f723eULL, 0x000fe200000000ffULL, 0x0000000623007388ULL, 0x000fe20000000800ULL,
0x0000002b422b723eULL, 0x000fc400000000ffULL, 0x0000003f2a2a723eULL, 0x000fe200000000ffULL,
0x0000000e15007388ULL, 0x000fe20000000800ULL, 0x0000001e1d1d723eULL, 0x000fe400000000ffULL,
0x000000141313723eULL, 0x000fe200000000ffULL, 0x000400352e007388ULL, 0x000fe20000000800ULL,
0x000000171616723eULL, 0x000fe400000000ffULL, 0x000000311212723eULL, 0x000fe200000000ffULL,
0x0004001b32007388ULL, 0x000fe20000000800ULL, 0x0000002d2c2c723eULL, 0x000fc400000000ffULL,
0x000000292828723eULL, 0x000fe200000000ffULL, 0x0004002734007388ULL, 0x000fe20000000800ULL,
0x000000220b0b723eULL, 0x000fe400000000ffULL, 0x000000433a3a723eULL, 0x000fe200000000ffULL,
0x0004002536007388ULL, 0x000fe20000000800ULL, 0x000000491a1a723eULL, 0x000fe400000000ffULL,
0x000000195219723eULL, 0x000fe200000000ffULL, 0x0004003b38007388ULL, 0x000fe80000000800ULL,
0x0004000954007388ULL, 0x000fe80000000800ULL, 0x0004000723007388ULL, 0x000fe80000000800ULL,
0x0000000d5a007388ULL, 0x000fe80000000800ULL, 0x0008000f2e007388ULL, 0x000fe80000000800ULL,
0x0008002b32007388ULL, 0x000fe80000000800ULL, 0x0008002a34007388ULL, 0x000fe80000000800ULL,
0x0008000036007388ULL, 0x000fe80000000800ULL, 0x0008001d38007388ULL, 0x000fe80000000800ULL,
0x0008001354007388ULL, 0x000fe80000000800ULL, 0x0008001623007388ULL, 0x000fe80000000800ULL,
0x0000001211007388ULL, 0x000fe80000000800ULL, 0x000c002c2e007388ULL, 0x000fe80000000800ULL,
0x000c002832007388ULL, 0x000fe80000000800ULL, 0x000c000b34007388ULL, 0x000fe80000000800ULL,
0x000c003a36007388ULL, 0x000fe80000000800ULL, 0x000c001a38007388ULL, 0x000fe80000000800ULL,
0x000c001954007388ULL, 0x000fe80000000800ULL, 0x000c001023007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000050c7984ULL, 0x000e680000000c00ULL,
0x00040000051c7984ULL, 0x000ea80000000c00ULL, 0x0008000005287984ULL, 0x000ee80000000c00ULL,
0x000c000005307984ULL, 0x000f280000000c00ULL, 0x0010000005147984ULL, 0x000ee80000000c00ULL,
0x0014000005247984ULL, 0x000f280000000c00ULL, 0x00180000052c7984ULL, 0x000f280000000c00ULL,
0x001c000005347984ULL, 0x000f220000000c00ULL, 0x200000ff0f0f7230ULL, 0x002fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x004fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fc40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x200000ff2b2b7230ULL, 0x008fe40000000000ULL,
0x200000ff2a2a7230ULL, 0x000fe40000000000ULL, 0x200000ff29297230ULL, 0x000fe40000000000ULL,
0x200000ff28287230ULL, 0x000fe40000000000ULL, 0x200000ff33337230ULL, 0x010fc40000000000ULL,
0x200000ff32327230ULL, 0x000fe40000000000ULL, 0x200000ff31317230ULL, 0x000fe40000000000ULL,
0x200000ff30307230ULL, 0x000fe40000000000ULL, 0x000000170f0f7230ULL, 0x000fe40000000000ULL,
0x000000160e0e7230ULL, 0x000fe40000000000ULL, 0x000000150d0d7230ULL, 0x000fc40000000000ULL,
0x000000140c0c7230ULL, 0x000fe40000000000ULL, 0x000000271f1f7230ULL, 0x000fe40000000000ULL,
0x000000261e1e7230ULL, 0x000fe20000000000ULL, 0x0000000c05007388ULL, 0x000fe20000000c00ULL,
0x000000251d1d7230ULL, 0x000fe40000000000ULL, 0x000000241c1c7230ULL, 0x000fe40000000000ULL,
0x0000002f2b2b7230ULL, 0x000fc40000000000ULL, 0x0000002e2a2a7230ULL, 0x000fe20000000000ULL,
0x0004001c05007388ULL, 0x000fe20000000c00ULL, 0x0000002d29297230ULL, 0x000fe40000000000ULL,
0x0000002c28287230ULL, 0x000fe40000000000ULL, 0x0000003733337230ULL, 0x000fe40000000000ULL,
0x0000003632327230ULL, 0x000fe20000000000ULL, 0x0008002805007388ULL, 0x000fe20000000c00ULL,
0x0000003531317230ULL, 0x000fc40000000000ULL, 0x0000003430307230ULL, 0x000fca0000000000ULL,
0x000c003005007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff2100720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fc80000011603ULL, 0x000000020000720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ee20000002700ULL,
0x0000000100057824ULL, 0x000fe200078e0203ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x0000002081007824ULL, 0x000fe200078e0200ULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x00000020030b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x0000000705067812ULL, 0x000fe400078ec0ffULL, 0x0000580000067ab9ULL, 0x000fe20000000800ULL,
0x00005a00ff077a19ULL, 0x000fc40000011600ULL, 0x0ffffff806057812ULL, 0x000fe400078ef803ULL,
0x0000000500097c12ULL, 0x000fc6000f8e30ffULL, 0x0000001005057824ULL, 0x000fe400078e0204ULL,
0x0000000180097824ULL, 0x000fc600078e0209ULL, 0x00000000050c7984ULL, 0x0045220000000c00ULL,
0x0000008407077224ULL, 0x000fe200078e0209ULL, 0x00000006040472a4ULL, 0x008fcc000f8e023fULL,
0x0000000484007c24ULL, 0x000fe2000f8e02ffULL, 0x0000000703057812ULL, 0x004fc800078ec0ffULL,
0x0000000700077210ULL, 0x000fe20007f1e0ffULL, 0x000000080a057824ULL, 0x000fc800078e0205ULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005c0007067a11ULL, 0x000fc800078040ffULL,
0x00005d0007077a11ULL, 0x000fe400000f4408ULL, 0x00000003ff087819ULL, 0x000fc6000001160bULL,
0x0000001005067825ULL, 0x000fe200078e0006ULL, 0x000000020800720cULL, 0x000fc80003f06070ULL,
0x0000000c06007986ULL, 0x0105f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010b057824ULL, 0x100fe200078e0208ULL, 0x0000004003117810ULL, 0x000fe20007ffe0ffULL,
0x0000002081087824ULL, 0x000fc600078e0208ULL, 0x0000000705057812ULL, 0x000fe400078ec0ffULL,
0x0000000508097c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef80bULL,
0x00005a00ff077a19ULL, 0x004fe20000011608ULL, 0x0000000180097824ULL, 0x000fe400078e0209ULL,
0x0000001005057824ULL, 0x000fe400078e0204ULL, 0x0000008407077224ULL, 0x000fe200078e0209ULL,
0x000000070b097812ULL, 0x000fc400078ec0ffULL, 0x00000000050c7984ULL, 0x0004e40000000c00ULL,
0x0000000700077210ULL, 0x000fe20007f1e0ffULL, 0x000000080a097824ULL, 0x000fc800078e0209ULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005c0007067a11ULL, 0x040fe400078040ffULL,
0x00000003ff057819ULL, 0x004fe40000011611ULL, 0x00005d0007077a11ULL, 0x000fe400000f4408ULL,
0x000000020500720cULL, 0x000fc60003f06070ULL, 0x0000001009067825ULL, 0x000fca00078e0006ULL,
0x0000000c06007986ULL, 0x0085ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000111067824ULL, 0x104fe200078e0205ULL, 0x00000060030b7810ULL, 0x000fe20007ffe0ffULL,
0x0000002081057824ULL, 0x000fc600078e0205ULL, 0x0000000706067812ULL, 0x000fc800078ec0ffULL,
0x0ffffff806077812ULL, 0x000fca00078ef811ULL, 0x0000001007087824ULL, 0x000fe200078e0204ULL,
0x0000000505077c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff057a19ULL, 0x000fe40000011605ULL,
0x00000000080c7984ULL, 0x0004e20000000c00ULL, 0x0000000180077824ULL, 0x000fc800078e0207ULL,
0x0000008405057224ULL, 0x000fe200078e0207ULL, 0x00000003ff087819ULL, 0x004fc8000001160bULL,
0x0000000500077210ULL, 0x000fe40007f1e0ffULL, 0x0000000711057812ULL, 0x000fc600078ec0ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x00005c0007067a11ULL, 0x000fe200078040ffULL,
0x000000080a057824ULL, 0x000fc600078e0205ULL, 0x00005d0007077a11ULL, 0x000fe400000f4410ULL,
0x000000020800720cULL, 0x000fc60003f06070ULL, 0x0000001005067825ULL, 0x000fca00078e0006ULL,
0x0000000c06007986ULL, 0x0085ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010b057824ULL, 0x100fe200078e0208ULL, 0x0000008003117810ULL, 0x000fe20007ffe0ffULL,
0x0000002081087824ULL, 0x000fc600078e0208ULL, 0x0000000705057812ULL, 0x000fe400078ec0ffULL,
0x0000000508097c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef80bULL,
0x00005a00ff077a19ULL, 0x004fe20000011608ULL, 0x0000000180097824ULL, 0x000fe400078e0209ULL,
0x0000001005057824ULL, 0x000fe400078e0204ULL, 0x0000008407077224ULL, 0x000fe200078e0209ULL,
0x000000070b097812ULL, 0x000fc400078ec0ffULL, 0x00000000050c7984ULL, 0x0004e40000000c00ULL,
0x0000000700077210ULL, 0x000fe20007f1e0ffULL, 0x000000080a097824ULL, 0x000fc800078e0209ULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005c0007067a11ULL, 0x040fe400078040ffULL,
0x00000003ff057819ULL, 0x004fe40000011611ULL, 0x00005d0007077a11ULL, 0x000fe400000f4408ULL,
0x000000020500720cULL, 0x000fc60003f06070ULL, 0x0000001009067825ULL, 0x000fca00078e0006ULL,
0x0000000c06007986ULL, 0x0085ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000111067824ULL, 0x104fe200078e0205ULL, 0x000000a0030b7810ULL, 0x000fe20007ffe0ffULL,
0x0000002081057824ULL, 0x000fc600078e0205ULL, 0x0000000706067812ULL, 0x000fc800078ec0ffULL,
0x0ffffff806077812ULL, 0x000fca00078ef811ULL, 0x0000001007087824ULL, 0x000fe200078e0204ULL,
0x0000000505077c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff057a19ULL, 0x000fe40000011605ULL,
0x00000000080c7984ULL, 0x0004e20000000c00ULL, 0x0000000180077824ULL, 0x000fc800078e0207ULL,
0x0000008405057224ULL, 0x000fe200078e0207ULL, 0x00000003ff087819ULL, 0x004fc8000001160bULL,
0x0000000500077210ULL, 0x000fe40007f1e0ffULL, 0x0000000711057812ULL, 0x000fc600078ec0ffULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x00005c0007067a11ULL, 0x000fe200078040ffULL,
0x000000080a057824ULL, 0x000fc600078e0205ULL, 0x00005d0007077a11ULL, 0x000fe400000f4410ULL,
0x000000020800720cULL, 0x000fc60003f06070ULL, 0x0000001005067825ULL, 0x000fca00078e0006ULL,
0x0000000c06007986ULL, 0x0085ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010b057824ULL, 0x100fe200078e0208ULL, 0x000000c003117810ULL, 0x000fe20007ffe0ffULL,
0x0000002081087824ULL, 0x000fc600078e0208ULL, 0x0000000705057812ULL, 0x000fe400078ec0ffULL,
0x0000000508097c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef80bULL,
0x00005a00ff077a19ULL, 0x004fe20000011608ULL, 0x0000000180097824ULL, 0x000fe400078e0209ULL,
0x0000001005057824ULL, 0x000fe400078e0204ULL, 0x0000008407077224ULL, 0x000fe200078e0209ULL,
0x000000070b097812ULL, 0x000fc400078ec0ffULL, 0x00000000050c7984ULL, 0x0004e40000000c00ULL,
0x0000000700077210ULL, 0x000fe20007f1e0ffULL, 0x000000080a097824ULL, 0x000fc800078e0209ULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005c0007067a11ULL, 0x040fe400078040ffULL,
0x00000003ff057819ULL, 0x004fe40000011611ULL, 0x00005d0007077a11ULL, 0x000fe400000f4408ULL,
0x000000020500720cULL, 0x000fc60003f06070ULL, 0x0000001009067825ULL, 0x000fca00078e0006ULL,
0x0000000c06007986ULL, 0x0085ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000111067824ULL, 0x104fe200078e0205ULL, 0x000000e003097810ULL, 0x000fe20007ffe0ffULL,
0x0000002081057824ULL, 0x000fe200078e0205ULL, 0x0000000711037812ULL, 0x000fe400078ec0ffULL,
0x0000000706067812ULL, 0x000fc600078ec0ffULL, 0x000000080a037824ULL, 0x000fe200078e0203ULL,
0x0ffffff806077812ULL, 0x000fca00078ef811ULL, 0x0000001007087824ULL, 0x000fe200078e0204ULL,
0x0000000505077c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff057a19ULL, 0x000fe40000011605ULL,
0x00000000080c7984ULL, 0x0004e20000000c00ULL, 0x0000000180077824ULL, 0x000fc800078e0207ULL,
0x0000008405057224ULL, 0x000fca00078e0207ULL, 0x0000000500077210ULL, 0x000fe40007f1e0ffULL,
0x00000003ff057819ULL, 0x000fc60000011609ULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x00005c0007067a11ULL, 0x000fe200078040ffULL, 0x0000000109087824ULL, 0x004fc600078e0205ULL,
0x00005d0007077a11ULL, 0x000fe400000f4410ULL, 0x000000020500720cULL, 0x000fe40003f06070ULL,
0x0000000708087812ULL, 0x000fe200078ec0ffULL, 0x0000001003027825ULL, 0x000fc600078e0006ULL,
0xfffffff808077812ULL, 0x000fe400078ef809ULL, 0x0000000c02007986ULL, 0x0085ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001007077824ULL, 0x000fe400078e0204ULL,
0x0000002081057824ULL, 0x000fc600078e0205ULL, 0x00000000070c7984ULL, 0x004ea40000000c00ULL,
0x0000000505037c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff057a19ULL, 0x000fc60000011605ULL,
0x0000000180037824ULL, 0x000fc800078e0203ULL, 0x0000008405037224ULL, 0x000fe200078e0203ULL,
0x0000000709057812ULL, 0x000fc800078ec0ffULL, 0x0000000300037210ULL, 0x000fe20007f1e0ffULL,
0x000000080a057824ULL, 0x000fc800078e0205ULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fca00000f4400ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x004fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000001030f7810ULL, 0x000fe20007ffe0ffULL, 0x00000002130d7824ULL, 0x000fe200078e00ffULL,
0x01660000ff087f8cULL, 0x000e62000c80043fULL, 0x00000040009a7824ULL, 0x000fe200078e00ffULL,
0x000000060f00720cULL, 0x000fe20003f06070ULL, 0x000059000d027a24ULL, 0x000fe400078e020aULL,
0x0000010003137824ULL, 0x000fc800078e029aULL, 0x0000660002207a24ULL, 0x000fcc00078e0213ULL,
0x0000060000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe40000011604ULL,
0x00000013050a7217ULL, 0x000fe40007800000ULL, 0x00000018292d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001200c7824ULL, 0x000fe200078e0229ULL, 0x0000002029237810ULL, 0x040fe20007ffe0ffULL,
0x000000010a0a7824ULL, 0x000fe200078e0a13ULL, 0x00000010292b7810ULL, 0x040fe20007ffe0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000829177810ULL, 0x000fc40007ffe0ffULL,
0x00000004041b7211ULL, 0x000fe200078fe8ffULL, 0x0000000120127824ULL, 0x000fe200078e022dULL,
0x000000300c147812ULL, 0x000fe200078ef80bULL, 0x00000001200c7824ULL, 0x040fe200078e0223ULL,
0x000000031b1b7812ULL, 0x000fe200078ec0ffULL, 0x0000000120107824ULL, 0x000fe200078e022bULL,
0x0000620014147a10ULL, 0x000fe20007f1e0ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x00002000001d7811ULL, 0x000fe400078e68ffULL, 0x000063000d157a10ULL, 0x000fe200007fe4ffULL,
0x00000001200e7824ULL, 0x000fe200078e0217ULL, 0x0000003012127812ULL, 0x000fe200078ef80bULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0ffffffc1b047812ULL, 0x000fc400078ef804ULL,
0x0000620012127a10ULL, 0x000fe20007f5e0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000300c167812ULL, 0x100fe400078ef80bULL, 0x0000002829257810ULL, 0x000fe20007ffe0ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000003010107812ULL, 0x100fe400078ef80bULL,
0x0000630013137a10ULL, 0x000fe200017fe4ffULL, 0x00000004170c7824ULL, 0x000fe200078e00ffULL,
0x000000300e0e7812ULL, 0x000fe200078ef80bULL, 0x00000010041f7824ULL, 0x000fe200078e021dULL,
0x0000620010107a10ULL, 0x000fe20007f3e0ffULL, 0x0000000120047824ULL, 0x000fe200078e0225ULL,
0xfffffffc0c0c7812ULL, 0x000fe200078ee21bULL, 0x00000004251a7824ULL, 0x000fe200078e00ffULL,
0x000062000e0e7a10ULL, 0x000fc40007f1e0ffULL, 0x0000620016167a10ULL, 0x000fe20007f5e0ffULL,
0x000000100c217824ULL, 0x000fe200078e021dULL, 0x0000630011117a10ULL, 0x000fe40000ffe4ffULL,
0x0000000a1700720cULL, 0x080fe40003f26070ULL, 0x000063000f0f7a10ULL, 0x000fe400007fe4ffULL,
0x000063000d177a10ULL, 0x000fe200017fe4ffULL, 0x00000100040c7825ULL, 0x000fe200078e00ffULL,
0x0000000a2900720cULL, 0x000fc40003f06070ULL, 0x0000003029277810ULL, 0x000fe20007ffe0ffULL,
0x000000042b047824ULL, 0x000fe200078e00ffULL, 0x000000300c187812ULL, 0x000fe400078ef80bULL,
0x0000003829297810ULL, 0x000fe20007ffe0ffULL, 0x00000001200c7824ULL, 0x000fe200078e0227ULL,
0x0000620018187a10ULL, 0x000fe20007fde0ffULL, 0x00000004271c7824ULL, 0x000fe200078e00ffULL,
0x0000000a2b00720cULL, 0x080fe20003fa6070ULL, 0x00000004291e7824ULL, 0x000fe200078e00ffULL,
0x000063000d197a10ULL, 0x000fe200037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0005e2000c101c48ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000a2d00720cULL, 0x000fc40003f86070ULL, 0x000000000e217faeULL, 0x0007e2000c901c48ULL,
0x0000000a2300720cULL, 0x080fe40003f66070ULL, 0x0000000a2500720cULL, 0x080fe40003f46070ULL,
0x0000000a2700720cULL, 0x080fe40003f26070ULL, 0x0000000a2900720cULL, 0x000fe20003f06070ULL,
0x000000042d0a7824ULL, 0x000fe200078e00ffULL, 0x000000300c0c7812ULL, 0x000fe200078ef80bULL,
0x0000000423147824ULL, 0x004fe200078e00ffULL, 0xfffffffc04047812ULL, 0x000fe200078ee21bULL,
0x00000001200e7824ULL, 0x008fe200078e0229ULL, 0xfffffffc0a0a7812ULL, 0x000fc400078ee21bULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffffc14147812ULL, 0x100fe400078ee21bULL, 0xfffffffc1a1a7812ULL, 0x000fe200078ee21bULL,
0x0000001004157824ULL, 0x000fe200078e021dULL, 0x000000300e0b7812ULL, 0x000fe200078ef80bULL,
0x00000010141f7824ULL, 0x000fe200078e021dULL, 0xfffffffc1c1c7812ULL, 0x000fe200078ee21bULL,
0x000000101a217824ULL, 0x000fe200078e021dULL, 0xfffffffc1e1e7812ULL, 0x000fe200078ee21bULL,
0x000000100a1b7824ULL, 0x100fe200078e021dULL, 0x000063000d0d7a10ULL, 0x000fe200037fe4ffULL,
0x000000101c237824ULL, 0x100fe200078e021dULL, 0x000062000b0a7a10ULL, 0x000fe20007fde0ffULL,
0x000000101e1d7824ULL, 0x000fe200078e021dULL, 0x0000000010157faeULL, 0x0005e4000e901c48ULL,
0x000063000f0b7a10ULL, 0x000fc400037fe4ffULL, 0x00000000121b7faeULL, 0x0005e8000e101c48ULL,
0x00000000161f7faeULL, 0x0005e8000d901c48ULL, 0x0000000018217faeULL, 0x0005e8000d101c48ULL,
0x000000000c237faeULL, 0x0005e8000c901c48ULL, 0x000000000a1d7faeULL, 0x0005e2000c101c48ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000000804157811ULL, 0x040fe400078ff0ffULL,
0x00000004040e7211ULL, 0x000fc400078fe8ffULL, 0x0000001804197811ULL, 0x040fe200078ff0ffULL,
0x0000000415147824ULL, 0x000fe200078e00ffULL, 0x00000028040d7811ULL, 0x040fe400078ff0ffULL,
0x0000001004177811ULL, 0x000fe200078ff0ffULL, 0x0000000419187824ULL, 0x000fe200078e00ffULL,
0x000000030e137812ULL, 0x000fe200078ec0ffULL, 0x000000040d227824ULL, 0x000fe200078e00ffULL,
0x00000020040a7811ULL, 0x000fe200078ff0ffULL, 0x00000001200e7824ULL, 0x000fe200078e0215ULL,
0x00000030040f7811ULL, 0x000fe200078ff0ffULL, 0x0000000120107824ULL, 0x000fe200078e0217ULL,
0x00000020040c7211ULL, 0x040fe200078ff0ffULL, 0x0000000417167824ULL, 0x000fe200078e00ffULL,
0x0000003804117811ULL, 0x000fe200078ff0ffULL, 0x000000040a1a7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc131b7812ULL, 0x000fe200078ef804ULL, 0x00000001201c7824ULL, 0x000fe200078e020dULL,
0xfffffffc14047812ULL, 0x100fe200078ee213ULL, 0x000000040f247824ULL, 0x000fe200078e00ffULL,
0xfffffffc18147812ULL, 0x000fe200078ee213ULL, 0x0000000120127824ULL, 0x000fe200078e0219ULL,
0xfffffffc22187812ULL, 0x000fe200078ee213ULL, 0x0000000120157824ULL, 0x000fe200078e020aULL,
0x0000200000297811ULL, 0x000fe200078e68ffULL, 0x00000001201e7824ULL, 0x000fe200078e020fULL,
0xfffffffc160a7812ULL, 0x100fe200078ee213ULL, 0x0000000411267824ULL, 0x000fe200078e00ffULL,
0xfffffffc1a177812ULL, 0x100fe200078ee213ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffffc24197812ULL, 0x000fc400078ee213ULL, 0xfffffffc261a7812ULL, 0x000fe200078ee213ULL,
0x0000000120207824ULL, 0x000fe200078e0211ULL, 0x000000300c167812ULL, 0x000fe200078ef80bULL,
0x000001000e0e7825ULL, 0x000fc600078e00ffULL, 0x0000620016167a10ULL, 0x000fe20007f1e0ffULL,
0x0000010010107825ULL, 0x000fc800078e00ffULL, 0x0000001018257824ULL, 0x000fe200078e0229ULL,
0x000000300e187812ULL, 0x000fe200078ef80bULL, 0x000000101b2b7824ULL, 0x000fe200078e0229ULL,
0x00000030101b7812ULL, 0x000fe200078ef80bULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000620018187a10ULL, 0x000fc60007f3e0ffULL, 0x00000010041d7824ULL, 0x000fe200078e0229ULL,
0x0000003012127812ULL, 0x000fe200078ef80bULL, 0x000000100a1f7824ULL, 0x100fe400078e0229ULL,
0x0000001014217824ULL, 0x100fe400078e0229ULL, 0x0000001017237824ULL, 0x100fe200078e0229ULL,
0x000063000d177a10ULL, 0x000fe200007fe4ffULL, 0x0000001019277824ULL, 0x100fe200078e0229ULL,
0x000063000f197a10ULL, 0x000fe20000ffe4ffULL, 0x000000101a297824ULL, 0x000fe200078e0229ULL,
0x000062001b1a7a10ULL, 0x000fe20007f5e0ffULL, 0x00000100150c7825ULL, 0x000fe200078e00ffULL,
0x0000620012127a10ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000162b7faeULL, 0x0005e2000b901c48ULL, 0x00006300111b7a10ULL, 0x000fe200017fe4ffULL,
0x000001001c0e7825ULL, 0x000fe200078e00ffULL, 0x000000300c0a7812ULL, 0x100fe200078ef80bULL,
0x00000000181d7faeULL, 0x0005e2000b901c48ULL, 0x0000630013137a10ULL, 0x000fe200007fe4ffULL,
0x000001001e107825ULL, 0x000fe200078e00ffULL, 0x000000300e0c7812ULL, 0x100fe200078ef80bULL,
0x000000001a1f7faeULL, 0x0005e2000b901c48ULL, 0x000062000a0a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000010020147825ULL, 0x000fe200078e00ffULL, 0x00000030100e7812ULL, 0x000fe200078ef80bULL,
0x0000000012217faeULL, 0x0005e2000b901c48ULL, 0x000062000c0c7a10ULL, 0x000fc40007f3e0ffULL,
0x00000030140b7812ULL, 0x000fe400078ef80bULL, 0x000062000e0e7a10ULL, 0x000fe40007f5e0ffULL,
0x000062000b107a10ULL, 0x000fe40007f7e0ffULL, 0x000063000d0b7a10ULL, 0x000fe400007fe4ffULL,
0x000063000f0d7a10ULL, 0x000fe40000ffe4ffULL, 0x00006300110f7a10ULL, 0x000fe200017fe4ffULL,
0x000000000a237faeULL, 0x0005e2000b901c48ULL, 0x0000630015117a10ULL, 0x000fc60001ffe4ffULL,
0x000000000c257faeULL, 0x0005e8000b901c48ULL, 0x000000000e277faeULL, 0x0005e8000b901c48ULL,
0x0000000010297faeULL, 0x0005e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x00000000000a7805ULL, 0x004fc40000015200ULL, 0x01660400ff0d7984ULL, 0x000ea40000000800ULL,
0x800000000dff7812ULL, 0x006fc40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a0f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e0bULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc8000001140dULL, 0x0000000f04047211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e060dULL, 0x0000000204047819ULL, 0x000fc8000000120dULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01660400ff0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000060300720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000997919ULL, 0x000e620000000000ULL,
0x00005800ff957624ULL, 0x000fe200078e00ffULL, 0x8000580005947a10ULL, 0x000fe20007ffe0ffULL,
0x0000002000977824ULL, 0x040fe200078e00ffULL, 0x0001668800987811ULL, 0x000fe400078e18ffULL,
0x0000001f95047810ULL, 0x040fe40007ffe0ffULL, 0xffffffff95967810ULL, 0x000fe40007ffe0ffULL,
0x00000004ff047819ULL, 0x000fc40000011604ULL, 0x0000000995957810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff947819ULL, 0x000fe40000011694ULL, 0x0ffffffe04237812ULL, 0x000fc400078ec0ffULL,
0x0000000103097810ULL, 0x040fe20007ffe0ffULL, 0x0000010003227824ULL, 0x000fe200078e029aULL,
0x0000000000007946ULL, 0x000fe40003800000ULL, 0x000000060900720cULL, 0x000fe20003f06070ULL,
0x0000660002217a24ULL, 0x000fd800078e0222ULL, 0x0000064000008947ULL, 0x008fea0003800000ULL,
0x00000002ff167819ULL, 0x002fe20000011699ULL, 0x0000001099207824ULL, 0x000fc600078e00ffULL,
0x0000000816197810ULL, 0x040fe20007ffe0ffULL, 0x0000000116087824ULL, 0x100fe200078e0221ULL,
0x0000003020207812ULL, 0x000fe400078ec0ffULL, 0x00000020161e7810ULL, 0x000fe20007ffe0ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x00000018161c7810ULL, 0x000fe40007ffe0ffULL,
0x0000004020177812ULL, 0x000fe200078efcffULL, 0x00000001190a7824ULL, 0x100fe200078e0221ULL,
0x00000010161a7810ULL, 0x000fe20007ffe0ffULL, 0x000000011e107824ULL, 0x000fe200078e0221ULL,
0x0000001708127212ULL, 0x000fe200078efcffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000009999087211ULL, 0x000fc400078fe8ffULL, 0x0000620012127a10ULL, 0x000fe20007f3e0ffULL,
0x000000011c0e7824ULL, 0x000fe200078e0221ULL, 0x000000170a0a7212ULL, 0x080fe200078efcffULL,
0x00000001210c7824ULL, 0x000fe200078e021aULL, 0x0000630009137a10ULL, 0x000fe20000ffe4ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x000062000a0a7a10ULL, 0x000fe40007f3e0ffULL,
0x0000002205097217ULL, 0x000fe20007800000ULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001710147212ULL, 0x000fc400078efcffULL, 0x000063000b0b7a10ULL, 0x000fe20000ffe4ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x000000170e0e7212ULL, 0x080fe400078efcffULL,
0x0000620014147a10ULL, 0x000fe20007f7e0ffULL, 0x0000000109047824ULL, 0x000fe200078e0a22ULL,
0x000000170c0c7212ULL, 0x000fe200078efcffULL, 0x00000004191b7824ULL, 0x000fe200078e00ffULL,
0x000062000e0e7a10ULL, 0x000fe20007f3e0ffULL, 0x000000041a1d7824ULL, 0x000fe200078e00ffULL,
0x00000028161f7810ULL, 0x000fc40007ffe0ffULL, 0x000062000c0c7a10ULL, 0x000fe40007f5e0ffULL,
0x0000630011157a10ULL, 0x000fe40001ffe4ffULL, 0x000063000f0f7a10ULL, 0x000fe40000ffe4ffULL,
0x0ffffffc99117812ULL, 0x000fe400078ec0ffULL, 0x0000000308187812ULL, 0x000fe200078ec0ffULL,
0x000000011f087824ULL, 0x000fe200078e0221ULL, 0x000000041600720cULL, 0x000fc40003f26070ULL,
0x000063000d0d7a10ULL, 0x000fe200017fe4ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x000000041900720cULL, 0x080fe40003f46070ULL, 0x0000300000107811ULL, 0x000fe400078e68ffULL,
0x0000001118197212ULL, 0x000fe400078efcffULL, 0x000000041a00720cULL, 0x000fe40003f66070ULL,
0xfffffffc1b1b7812ULL, 0x000fe200078ee218ULL, 0x0000001019197824ULL, 0x000fe200078e0210ULL,
0x00000030161a7810ULL, 0x000fc40007ffe0ffULL, 0x0000001708087212ULL, 0x000fe200078efcffULL,
0x000000101b1b7824ULL, 0x000fe200078e0210ULL, 0xfffffffc1d1d7812ULL, 0x000fe200078ee218ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012197faeULL, 0x0003e2000c901c48ULL,
0x0000003816167810ULL, 0x000fe40007ffe0ffULL, 0x000000041c00720cULL, 0x080fe20003fa6070ULL,
0x000000101d1d7824ULL, 0x000fe200078e0210ULL, 0x000000000a1b7faeULL, 0x0005e2000d101c48ULL,
0x000000041e00720cULL, 0x080fe40003f86070ULL, 0x000000041a00720cULL, 0x080fe20003f46070ULL,
0x000000000c1d7faeULL, 0x0007e2000d901c48ULL, 0x000000041f00720cULL, 0x000fc40003f66070ULL,
0x0000620008127a10ULL, 0x002fe20007fde0ffULL, 0x000000011a087824ULL, 0x000fe200078e0221ULL,
0x000000041600720cULL, 0x000fe20003f26070ULL, 0x000000041e197824ULL, 0x000fe200078e00ffULL,
0x0000630009137a10ULL, 0x000fe200037fe4ffULL, 0x0000010008087825ULL, 0x000fc600078e00ffULL,
0xfffffffc19197812ULL, 0x100fe200078ee218ULL, 0x00000001160a7824ULL, 0x004fe200078e0221ULL,
0x0000001708087212ULL, 0x080fe200078efcffULL, 0x000000041c0d7824ULL, 0x008fe400078e00ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000620008087a10ULL, 0x000fe40007fde0ffULL,
0xfffffffc0d0d7812ULL, 0x100fe200078ee218ULL, 0x000000041f1b7824ULL, 0x000fe200078e00ffULL,
0x000000170a0a7212ULL, 0x000fe200078efcffULL, 0x000000041a1d7824ULL, 0x000fe200078e00ffULL,
0x0000630009097a10ULL, 0x000fe200037fe4ffULL, 0x00000004161f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1b1b7812ULL, 0x000fe200078ee218ULL, 0x000000100d0d7824ULL, 0x000fe200078e0210ULL,
0xfffffffc1d1d7812ULL, 0x000fe200078ee218ULL, 0x0000001019177824ULL, 0x000fe200078e0210ULL,
0xfffffffc1f1f7812ULL, 0x000fe200078ee218ULL, 0x000000101b197824ULL, 0x100fe200078e0210ULL,
0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL, 0x000000101d1b7824ULL, 0x100fe200078e0210ULL,
0x000000000e0d7faeULL, 0x0003e2000e901c48ULL, 0x000000101f1d7824ULL, 0x000fe200078e0210ULL,
0x000063000b0b7a10ULL, 0x000fc400037fe4ffULL, 0x0000000014177faeULL, 0x0003e8000e101c48ULL,
0x0000000012197faeULL, 0x0003e8000d901c48ULL, 0x00000000081b7faeULL, 0x0003e8000d101c48ULL,
0x000000000a1d7faeULL, 0x0003e2000c901c48ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x0000001899127811ULL, 0x042fe200078ff0ffULL, 0x0000001099207824ULL, 0x040fe200078e00ffULL,
0x0000009999047211ULL, 0x000fc400078fe8ffULL, 0x00000008990c7811ULL, 0x040fe200078ff0ffULL,
0x00000004120f7824ULL, 0x000fe200078e00ffULL, 0x00000020991a7811ULL, 0x040fe400078ff0ffULL,
0x0000002199087211ULL, 0x040fe200078ff0ffULL, 0x000000040c0b7824ULL, 0x000fe200078e00ffULL,
0x0000001099107811ULL, 0x040fe200078ff0ffULL, 0x000000041a137824ULL, 0x000fe200078e00ffULL,
0x00000028991c7811ULL, 0x000fe200078ff0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x00000003040e7812ULL, 0x000fc400078ec0ffULL, 0x0000003020207812ULL, 0x000fe200078ec0ffULL,
0x00000004100d7824ULL, 0x000fe200078e00ffULL, 0x00003000002b7811ULL, 0x000fe200078e68ffULL,
0x000000041c157824ULL, 0x000fe200078e00ffULL, 0xfffffffc0f147812ULL, 0x100fe200078ee20eULL,
0x000000010c0a7824ULL, 0x100fe200078e0221ULL, 0x00000030991e7811ULL, 0x040fe200078ff0ffULL,
0x00000001100c7824ULL, 0x100fe200078e0221ULL, 0x0000003899267811ULL, 0x000fe200078ff0ffULL,
0x0000000112047824ULL, 0x000fe200078e0221ULL, 0x00000040202d7812ULL, 0x000fe200078efcffULL,
0x00000010141f7824ULL, 0x000fe200078e022bULL, 0xfffffffc0b107812ULL, 0x100fe200078ee20eULL,
0x000000041e177824ULL, 0x000fe200078e00ffULL, 0xfffffffc13167812ULL, 0x100fe200078ee20eULL,
0x0000000426197824ULL, 0x000fe200078e00ffULL, 0xfffffffc0d127812ULL, 0x100fe200078ee20eULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc15187812ULL, 0x000fc400078ee20eULL,
0x0000002d08147212ULL, 0x080fe200078efcffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0ffffffc99117812ULL, 0x000fe400078ec0ffULL, 0x0000620014147a10ULL, 0x000fe20007f3e0ffULL,
0x0000001016257824ULL, 0x100fe200078e022bULL, 0xfffffffc17247812ULL, 0x100fe200078ee20eULL,
0x0000001018277824ULL, 0x100fe200078e022bULL, 0xfffffffc19287812ULL, 0x000fe200078ee20eULL,
0x00000010121d7824ULL, 0x000fe200078e022bULL, 0x0000002d0a167212ULL, 0x000fe200078efcffULL,
0x000000011a0a7824ULL, 0x100fe200078e0221ULL, 0x000000110e0e7212ULL, 0x000fe200078efcffULL,
0x0000000126127824ULL, 0x100fe200078e0221ULL, 0x0000002d0c187212ULL, 0x000fe200078efcffULL,
0x000000011c0c7824ULL, 0x000fe200078e0221ULL, 0x0000630009157a10ULL, 0x000fe20000ffe4ffULL,
0x0000010004087825ULL, 0x000fe200078e00ffULL, 0x0000620016167a10ULL, 0x000fc40007f5e0ffULL,
0x0000620018187a10ULL, 0x000fe20007f7e0ffULL, 0x000000100e2f7824ULL, 0x000fe200078e022bULL,
0x000063000b177a10ULL, 0x000fe200017fe4ffULL, 0x000000011e0e7824ULL, 0x000fe200078e0221ULL,
0x000063000d197a10ULL, 0x000fe20001ffe4ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002d08087212ULL, 0x000fe200078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000142f7faeULL, 0x0003e4000b901c48ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000620008087a10ULL, 0x000fc40007f3e0ffULL, 0x0000002d0a0a7212ULL, 0x080fe200078efcffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000002d0c0c7212ULL, 0x080fe400078efcffULL,
0x0000630009097a10ULL, 0x000fe20000ffe4ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000002d0e0e7212ULL, 0x080fe400078efcffULL, 0x000062000a0a7a10ULL, 0x000fe20007f3e0ffULL,
0x00000010101b7824ULL, 0x100fe200078e022bULL, 0x0000002d12127212ULL, 0x000fe200078efcffULL,
0x0000001024297824ULL, 0x100fe200078e022bULL, 0x000062000c0c7a10ULL, 0x000fe20007f5e0ffULL,
0x00000010282b7824ULL, 0x000fe200078e022bULL, 0x000062000e0e7a10ULL, 0x000fe20007f7e0ffULL,
0x00000000161b7faeULL, 0x0003e2000b901c48ULL, 0x0000620012127a10ULL, 0x000fc40007f9e0ffULL,
0x000063000b0b7a10ULL, 0x000fe20000ffe4ffULL, 0x00000000181d7faeULL, 0x0003e2000b901c48ULL,
0x000063000d0d7a10ULL, 0x000fe400017fe4ffULL, 0x000063000f0f7a10ULL, 0x000fe20001ffe4ffULL,
0x00000000081f7faeULL, 0x0003e2000b901c48ULL, 0x0000630013137a10ULL, 0x000fc600027fe4ffULL,
0x000000000a257faeULL, 0x0003e8000b901c48ULL, 0x000000000c277faeULL, 0x0003e8000b901c48ULL,
0x000000000e297faeULL, 0x0003e8000b901c48ULL, 0x00000000122b7faeULL, 0x0003e4000b901c48ULL,
0x0000000899047812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000004ff1b7819ULL, 0x102fe20000011699ULL, 0x0000200000717824ULL, 0x000fe200078e00ffULL,
0x00000007041f7812ULL, 0x000fc400078ef899ULL, 0x0000000799047812ULL, 0x000fe200078ec0ffULL,
0x000000081b097824ULL, 0x040fe200078e00ffULL, 0x00000003ff107819ULL, 0x000fe20000011699ULL,
0x000000011b1e7824ULL, 0x000fe200078e021fULL, 0x000000101f1c7812ULL, 0x040fe200078efcffULL,
0x000000101f157824ULL, 0x000fe200078e00ffULL, 0xfffffff809047812ULL, 0x000fe200078ee204ULL,
0x000000101f0b7824ULL, 0x000fe200078e00ffULL, 0x000000021e087810ULL, 0x000fe20007ffe0ffULL,
0x000000011b1b7824ULL, 0x000fe200078e021cULL, 0x0000000110097812ULL, 0x000fe200078ec0ffULL,
0x00000004040d7824ULL, 0x040fe200078e00ffULL, 0x00000010040a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000404277824ULL, 0x040fe200078e00ffULL, 0x0000002004127810ULL, 0x000fe20007ffe0ffULL,
0x000000101c0c7824ULL, 0x000fe200078e00ffULL, 0x0000003004147810ULL, 0x000fe20007ffe0ffULL,
0x000000040a7a7824ULL, 0x000fe200078e00ffULL, 0xfffffff015157812ULL, 0x000fe200078ee208ULL,
0x0000000412767824ULL, 0x000fe200078e00ffULL, 0x0000000904087211ULL, 0x000fe200078ff8ffULL,
0x0000000414747824ULL, 0x000fe200078e00ffULL, 0xfffffff00b047812ULL, 0x000fe200078ee21eULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000090a0b7211ULL, 0x080fe200078ff8ffULL,
0x0000001004047824ULL, 0x000fe200078e00ffULL, 0x0000000912137211ULL, 0x080fe200078ff8ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000914097211ULL, 0x000fe200078ff8ffULL,
0x000000101c257824ULL, 0x000fe200078e00ffULL, 0xfffffffc0d787812ULL, 0x000fe200078ee208ULL,
0x000000000464783bULL, 0x0003e20000000200ULL, 0x0000000208727810ULL, 0x000fe20007ffe0ffULL,
0x0000001015347824ULL, 0x000fe200078e00ffULL, 0x00002000711d7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff00c087812ULL, 0x000fe400078ee21bULL, 0xfffffffc7a7a7812ULL, 0x000fe200078ee20bULL,
0x00000010781a7824ULL, 0x000fe200078e021dULL, 0xfffffffc76767812ULL, 0x000fe200078ee213ULL,
0x0000001008087824ULL, 0x000fe200078e00ffULL, 0xfffffffc74747812ULL, 0x000fe200078ee209ULL,
0x000000107a197824ULL, 0x100fe200078e021dULL, 0x000000001a68783bULL, 0x000ea20000000200ULL,
0x0000001076187824ULL, 0x100fe200078e021dULL, 0x000000021b167810ULL, 0x000fe20007ffe0ffULL,
0x0000001074177824ULL, 0x100fe200078e021dULL, 0x00000000080c783bULL, 0x000ee20000000200ULL,
0xfffffffc27727812ULL, 0x000fe200078ee272ULL, 0x0000000412277824ULL, 0x000fe200078e00ffULL,
0xfffffff025247812ULL, 0x000fe200078ee216ULL, 0x000000001960783bULL, 0x000f220000000200ULL,
0x000000040a257824ULL, 0x000fe200078e00ffULL, 0x000000020b9c7810ULL, 0x000fe20007ffe0ffULL,
0x00000004140b7824ULL, 0x000fe200078e00ffULL, 0x00000000185c783bULL, 0x000f220000000200ULL,
0x0000000213707810ULL, 0x000fe20007ffe0ffULL, 0x0000001024547824ULL, 0x000fe200078e00ffULL,
0x0000000209047810ULL, 0x002fe20007ffe0ffULL, 0x00000000176c783bULL, 0x000e620000000200ULL,
0xfffffffc259c7812ULL, 0x000fe200078ee29cULL, 0x0000001072167824ULL, 0x100fe200078e021dULL,
0xfffffffc27707812ULL, 0x000fe200078ee270ULL, 0x000000003434783bULL, 0x000fe20000000200ULL,
0xfffffffc0b047812ULL, 0x000fe200078ee204ULL, 0x000000109c157824ULL, 0x000fc400078e021dULL,
0x0000001070147824ULL, 0x100fe200078e021dULL, 0x00000000163c783bULL, 0x000e620000000200ULL,
0x0000001004137824ULL, 0x000fc600078e021dULL, 0x000000005454783bULL, 0x000e680000000200ULL,
0x000000001544783bULL, 0x000e680000000200ULL, 0x00000000144c783bULL, 0x000e620000000200ULL,
0x000000686458723cULL, 0x084f6600000018ffULL, 0x000000001308783bULL, 0x000eaa0000000200ULL,
0x000000680c38723cULL, 0x008f7000000018ffULL, 0x0000006a6424723cULL, 0x040f7000000018ffULL,
0x000000606428723cULL, 0x050f7000000018ffULL, 0x000000626490723cULL, 0x040f7000000018ffULL,
0x0000005c648c723cULL, 0x040f7000000018ffULL, 0x0000005e642c723cULL, 0x000f7000000018ffULL,
0x000000600c40723cULL, 0x040f7000000018ffULL, 0x0000005c0c48723cULL, 0x040f7000000018ffULL,
0x0000006a0c68723cULL, 0x000f7000000018ffULL, 0x0000006c6430723cULL, 0x002f7000000018ffULL,
0x000000620c60723cULL, 0x040f7000000018ffULL, 0x0000005e0c5c723cULL, 0x040f7000000018ffULL,
0x0000006c0c50723cULL, 0x000f7000000018ffULL, 0x0000006e6464723cULL, 0x080f7000000018ffULL,
0x0000006e0c0c723cULL, 0x000f7000000018ffULL, 0x0000003c3458723cULL, 0x0a0b700000001858ULL,
0x0000003c5438723cULL, 0x000b700000001838ULL, 0x0000003e3424723cULL, 0x040b700000001824ULL,
0x000000443428723cULL, 0x040b700000001828ULL, 0x000000463490723cULL, 0x040b700000001890ULL,
0x0000004c348c723cULL, 0x040b70000000188cULL, 0x0000004e342c723cULL, 0x000b70000000182cULL,
0x000000445440723cULL, 0x040b700000001840ULL, 0x0000004c5448723cULL, 0x040b700000001848ULL,
0x0000003e543c723cULL, 0x000b700000001868ULL, 0x000000083430723cULL, 0x004b700000001830ULL,
0x000000465444723cULL, 0x040b700000001860ULL, 0x0000004e544c723cULL, 0x040b70000000185cULL,
0x000000085450723cULL, 0x000b700000001850ULL, 0x0000000a3434723cULL, 0x080b700000001864ULL,
0x0000000a5454723cULL, 0x000b62000000180cULL, 0x0000059000008947ULL, 0x000fce0003800000ULL,
0x00000002ff0a7819ULL, 0x120fe20000011699ULL, 0x0000000110107824ULL, 0x000fe200078e0299ULL,
0x0000002205097217ULL, 0x000fc40007800000ULL, 0x000000080a647810ULL, 0x040fe20007ffe0ffULL,
0x000000010a0b7824ULL, 0x140fe200078e0221ULL, 0x000000100a657810ULL, 0x000fe20007ffe0ffULL,
0x0000000109687824ULL, 0x000fe200078e0a22ULL, 0x0000008020087812ULL, 0x000fe200078efcffULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0x000000200a6a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001640d7824ULL, 0x000fe200078e0221ULL, 0x000000280a6b7810ULL, 0x040fe20007ffe0ffULL,
0x00000001210f7824ULL, 0x000fe200078e0265ULL, 0x000000180a697810ULL, 0x040fe20007ffe0ffULL,
0x000001000d0c7825ULL, 0x000fe200078e0008ULL, 0x000000300a6c7810ULL, 0x000fc40007ffe0ffULL,
0x000000380a6d7810ULL, 0x000fe20007ffe0ffULL, 0x000000016a5f7824ULL, 0x000fe200078e0221ULL,
0x000062000c0c7a10ULL, 0x000fe20007f7e0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0008ULL,
0x000000680a00720cULL, 0x000fe40003f26070ULL, 0x000063000d0d7a10ULL, 0x000fe20001ffe4ffULL,
0x000000016b617824ULL, 0x000fe200078e0221ULL, 0x000062000e0e7a10ULL, 0x000fe20007f9e0ffULL,
0x000001005f5e7825ULL, 0x000fe200078e0008ULL, 0x0000000310127812ULL, 0x000fc400078ec0ffULL,
0x000063000f0f7a10ULL, 0x000fe200027fe4ffULL, 0x0000010061607825ULL, 0x000fe200078e0008ULL,
0x000062005e5e7a10ULL, 0x000fe40007f7e0ffULL, 0x0000001112117212ULL, 0x000fe200078efcffULL,
0x00000001695d7824ULL, 0x100fe200078e0221ULL, 0x0000620060607a10ULL, 0x000fe20007f9e0ffULL,
0x000000016c637824ULL, 0x100fe200078e0221ULL, 0x000063005f5f7a10ULL, 0x000fe20001ffe4ffULL,
0x000000016d677824ULL, 0x000fe200078e0221ULL, 0x0000630061617a10ULL, 0x000fe200027fe4ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0008ULL, 0x000000686400720cULL, 0x000fc40003f66070ULL,
0x000000686500720cULL, 0x080fe20003f86070ULL, 0x000001005d5c7825ULL, 0x100fe200078e0008ULL,
0x000062000a0a7a10ULL, 0x000fe40007f5e0ffULL, 0x000000686d00720cULL, 0x080fe20003fc6070ULL,
0x0000010063627825ULL, 0x100fe200078e0008ULL, 0x000063000b0b7a10ULL, 0x000fe400017fe4ffULL,
0x000062005c5c7a10ULL, 0x000fe20007f5e0ffULL, 0x0000010067087825ULL, 0x000fe200078e0008ULL,
0x000000686c00720cULL, 0x000fc40003fa6070ULL, 0x000063005d5d7a10ULL, 0x000fe200017fe4ffULL,
0x0000000464677824ULL, 0x000fe200078e00ffULL, 0x0000620062627a10ULL, 0x000fe20007f5e0ffULL,
0x0000000465657824ULL, 0x000fe400078e00ffULL, 0x0000001011107824ULL, 0x100fe200078e021dULL,
0xfffffffc67647812ULL, 0x100fe200078ee212ULL, 0x000000046d6d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc65667812ULL, 0x000fe400078ee212ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a107faeULL, 0x0003e2000c901c48ULL, 0x0000001064657824ULL, 0x100fe200078e021dULL,
0x000000686900720cULL, 0x080fe20003f26070ULL, 0x0000001066677824ULL, 0x000fe200078e021dULL,
0x0000630063637a10ULL, 0x000fe200017fe4ffULL, 0x0000000469697824ULL, 0x000fe200078e00ffULL,
0x000000000c657faeULL, 0x0005e2000d901c48ULL, 0x000000686a00720cULL, 0x000fc40003f66070ULL,
0x0000620008087a10ULL, 0x000fe20007f5e0ffULL, 0x000000000e677faeULL, 0x0007e2000e101c48ULL,
0x000000686b00720cULL, 0x040fe20003f86070ULL, 0x000000046b6b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc69647812ULL, 0x100fe400078ee212ULL, 0x0000630009097a10ULL, 0x000fe200017fe4ffULL,
0x000000046a0d7824ULL, 0x004fe200078e00ffULL, 0xfffffffc6b0c7812ULL, 0x100fe200078ee212ULL,
0x00000010640b7824ULL, 0x002fe400078e021dULL, 0x000000046c0f7824ULL, 0x008fe200078e00ffULL,
0xfffffffc0d0a7812ULL, 0x000fc400078ee212ULL, 0xfffffffc6d0e7812ULL, 0x100fe200078ee212ULL,
0x000000005c0b7faeULL, 0x0003e4000c901c48ULL, 0x000000100a0d7824ULL, 0x100fe200078e021dULL,
0xfffffffc0f0a7812ULL, 0x000fe200078ee212ULL, 0x000000100c0f7824ULL, 0x000fc600078e021dULL,
0x000000005e0d7faeULL, 0x0005e8000d901c48ULL, 0x00000000600f7faeULL, 0x0005e2000e101c48ULL,
0x000000100a0b7824ULL, 0x102fe400078e021dULL, 0x000000100e5d7824ULL, 0x000fc600078e021dULL,
0x00000000620b7faeULL, 0x0005e8000e901c48ULL, 0x00000000085d7faeULL, 0x0005e2000f101c48ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x0000000899647811ULL, 0x060fe200078ff0ffULL,
0x000000ffff637224ULL, 0x000fe200078e00ffULL, 0x0000001099667811ULL, 0x040fe200078ff0ffULL,
0x0000000110107824ULL, 0x000fe200078e0299ULL, 0x0000001899687811ULL, 0x040fe200078ff0ffULL,
0x00000001640b7824ULL, 0x100fe200078e0221ULL, 0x00000020996a7811ULL, 0x040fe200078ff0ffULL,
0x00000001660d7824ULL, 0x100fe200078e0221ULL, 0x00000028996c7811ULL, 0x040fe200078ff0ffULL,
0x00000001680f7824ULL, 0x100fe200078e0221ULL, 0x00000030996e7811ULL, 0x040fe200078ff0ffULL,
0x000000016a5d7824ULL, 0x100fe200078e0221ULL, 0x00000038997c7811ULL, 0x040fe200078ff0ffULL,
0x000000016c5f7824ULL, 0x100fe200078e0221ULL, 0x0000008020627812ULL, 0x000fe200078efcffULL,
0x000000016e617824ULL, 0x100fe200078e0221ULL, 0x0000002199097211ULL, 0x000fe200078ff0ffULL,
0x000000017c657824ULL, 0x000fe200078e0221ULL, 0x0000000310127812ULL, 0x000fe200078ec0ffULL,
0x000001000b0a7825ULL, 0x000fc600078e0062ULL, 0x0000001112117212ULL, 0x000fe200078efcffULL,
0x0000010009087825ULL, 0x000fe200078e0062ULL, 0x000062000a0a7a10ULL, 0x000fc60007f5e0ffULL,
0x000001000d0c7825ULL, 0x100fe200078e0062ULL, 0x0000620008087a10ULL, 0x000fe40007f3e0ffULL,
0x000063000b0b7a10ULL, 0x000fe200017fe4ffULL, 0x000001000f0e7825ULL, 0x100fe200078e0062ULL,
0x0000630009097a10ULL, 0x000fe40000ffe4ffULL, 0x000062000c0c7a10ULL, 0x000fe20007f7e0ffULL,
0x000001005d5c7825ULL, 0x100fe200078e0062ULL, 0x000062000e0e7a10ULL, 0x000fe40007f3e0ffULL,
0x000063000d0d7a10ULL, 0x000fe20001ffe4ffULL, 0x000001005f5e7825ULL, 0x000fe200078e0062ULL,
0x000062005c5c7a10ULL, 0x000fc40007f5e0ffULL, 0x000063000f0f7a10ULL, 0x000fe20000ffe4ffULL,
0x0000010061607825ULL, 0x100fe200078e0062ULL, 0x000062005e5e7a10ULL, 0x000fe40007f3e0ffULL,
0x000063005d5d7a10ULL, 0x000fe200017fe4ffULL, 0x0000010065627825ULL, 0x000fe200078e0062ULL,
0x0000620060607a10ULL, 0x000fe40007f5e0ffULL, 0x000063005f5f7a10ULL, 0x000fe20000ffe4ffULL,
0x0000000464657824ULL, 0x000fe200078e00ffULL, 0x0000620062627a10ULL, 0x000fe20007f3e0ffULL,
0x0000000468697824ULL, 0x000fe200078e00ffULL, 0x0000630061617a10ULL, 0x000fe200017fe4ffULL,
0x0000000466677824ULL, 0x000fe200078e00ffULL, 0xfffffffc65647812ULL, 0x100fe200078ee212ULL,
0x000000046a6b7824ULL, 0x000fe200078e00ffULL, 0x0000630063637a10ULL, 0x000fe20000ffe4ffULL,
0x0000001011107824ULL, 0x100fe200078e021dULL, 0xfffffffc67667812ULL, 0x100fe200078ee212ULL,
0x0000001064657824ULL, 0x000fe200078e021dULL, 0xfffffffc69647812ULL, 0x000fe200078ee212ULL,
0x000000046c6d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008107faeULL, 0x0003e2000b901c48ULL, 0x000000047c6f7824ULL, 0x000fc400078e00ffULL,
0x0000001064697824ULL, 0x100fe200078e021dULL, 0xfffffffc6b647812ULL, 0x100fe200078ee212ULL,
0x000000046e6b7824ULL, 0x000fe200078e00ffULL, 0x000000000a657faeULL, 0x0005e2000b901c48ULL,
0x0000001066677824ULL, 0x100fe200078e021dULL, 0xfffffffc6d087812ULL, 0x102fe200078ee212ULL,
0x0000001064097824ULL, 0x100fe200078e021dULL, 0xfffffffc6f647812ULL, 0x100fe400078ee212ULL,
0x000000000c677faeULL, 0x0003e2000b901c48ULL, 0xfffffffc6b0a7812ULL, 0x004fe200078ee212ULL,
0x00000010080b7824ULL, 0x000fc400078e021dULL, 0x000000000e697faeULL, 0x0005e8000b901c48ULL,
0x000000005c097faeULL, 0x0007e2000b901c48ULL, 0x000000100a0d7824ULL, 0x002fc600078e021dULL,
0x000000005e0b7faeULL, 0x0007e2000b901c48ULL, 0x00000010640f7824ULL, 0x004fc600078e021dULL,
0x00000000600d7faeULL, 0x0007e8000b901c48ULL, 0x00000000620f7faeULL, 0x0007e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000101c0a7824ULL, 0x000fe200078e00ffULL,
0x000000041b097810ULL, 0x00cfe20007ffe0ffULL, 0x000000101f0b7824ULL, 0x000fe200078e00ffULL,
0x000000041e087810ULL, 0x000fe20007ffe0ffULL, 0x000000101c5d7824ULL, 0x000fe200078e00ffULL,
0x00003000710f7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff00a097812ULL, 0x000fe200078ee209ULL,
0x000000101f0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff00b087812ULL, 0x000fe200078ee208ULL,
0x00000010740b7824ULL, 0x100fe200078e020fULL, 0x000000061b5c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001009747824ULL, 0x000fe200078e00ffULL, 0x000000061e097810ULL, 0x000fe20007ffe0ffULL,
0x00000010780e7824ULL, 0x000fe200078e020fULL, 0xfffffff05d5c7812ULL, 0x000fe200078ee25cULL,
0x0000001008087824ULL, 0x000fe200078e00ffULL, 0xfffffff00a097812ULL, 0x000fe200078ee209ULL,
0x000000107a0d7824ULL, 0x000fc400078e020fULL, 0x00000010760c7824ULL, 0x000fe400078e020fULL,
0x0000001009717824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000e84783bULL, 0x000fe20000000200ULL, 0x000000105c5c7824ULL, 0x000fe400078e00ffULL,
0x00000010720a7824ULL, 0x100fe200078e020fULL, 0x000000000888783bULL, 0x0002a20000000200ULL,
0x000000109c097824ULL, 0x100fe400078e020fULL, 0x0000001004047824ULL, 0x100fe200078e020fULL,
0x000000000d80783bULL, 0x000ee80000000200ULL, 0x000000000c7c783bULL, 0x000f220000000200ULL,
0x0000001070087824ULL, 0x002fc600078e020fULL, 0x000000000b78783bULL, 0x000e680000000200ULL,
0x000000007474783bULL, 0x000e680000000200ULL, 0x000000000a6c783bULL, 0x000fe80000000200ULL,
0x000000007170783bULL, 0x000e680000000200ULL, 0x000000000968783bULL, 0x000e680000000200ULL,
0x000000000864783bULL, 0x000e680000000200ULL, 0x000000000460783bULL, 0x000e680000000200ULL,
0x000000005c5c783bULL, 0x000e620000000200ULL, 0x000000848858723cULL, 0x044f700000001858ULL,
0x000000868824723cULL, 0x040f700000001824ULL, 0x000000808828723cULL, 0x048f700000001828ULL,
0x000000828890723cULL, 0x040f700000001890ULL, 0x0000007c888c723cULL, 0x050f70000000188cULL,
0x0000007e882c723cULL, 0x040f70000000182cULL, 0x000000788830723cULL, 0x042f700000001830ULL,
0x0000007a8834723cULL, 0x000f700000001834ULL, 0x000000847438723cULL, 0x040f700000001838ULL,
0x00000086743c723cULL, 0x040f70000000183cULL, 0x000000807440723cULL, 0x040f700000001840ULL,
0x000000827444723cULL, 0x040f700000001844ULL, 0x0000007c7448723cULL, 0x040f700000001848ULL,
0x0000007e744c723cULL, 0x040f70000000184cULL, 0x000000787450723cULL, 0x040f700000001850ULL,
0x0000007a7454723cULL, 0x000f700000001854ULL, 0x0000006c7058723cULL, 0x060b700000001858ULL,
0x0000006e7024723cULL, 0x040b700000001824ULL, 0x000000687028723cULL, 0x040b700000001828ULL,
0x0000006a7090723cULL, 0x040b700000001890ULL, 0x00000064708c723cULL, 0x040b70000000188cULL,
0x00000066702c723cULL, 0x040b70000000182cULL, 0x000000607030723cULL, 0x040b700000001830ULL,
0x000000627034723cULL, 0x000b700000001834ULL, 0x0000006c5c38723cULL, 0x040b700000001838ULL,
0x0000006e5c3c723cULL, 0x040b70000000183cULL, 0x000000685c40723cULL, 0x040b700000001840ULL,
0x0000006a5c44723cULL, 0x040b700000001844ULL, 0x000000645c48723cULL, 0x040b700000001848ULL,
0x000000665c4c723cULL, 0x040b70000000184cULL, 0x000000605c50723cULL, 0x040b700000001850ULL,
0x000000625c54723cULL, 0x000b620000001854ULL, 0x0000056000008947ULL, 0x000fce0003800000ULL,
0x00000002ff6e7819ULL, 0x020fe20000011699ULL, 0x000000ffff5d7224ULL, 0x000fe200078e00ffULL,
0x000000c0205c7812ULL, 0x000fe200078efcffULL, 0x0000001011117824ULL, 0x000fe200078e020fULL,
0x000000086e6b7810ULL, 0x040fe20007ffe0ffULL, 0x000000016e5f7824ULL, 0x040fe200078e0221ULL,
0x000000106e6f7810ULL, 0x000fc40007ffe0ffULL, 0x000000206e717810ULL, 0x040fe20007ffe0ffULL,
0x000000016b617824ULL, 0x000fe200078e0221ULL, 0x000000186e707810ULL, 0x040fe20007ffe0ffULL,
0x000001005f5e7825ULL, 0x000fe200078e005cULL, 0x000000286e727810ULL, 0x000fc60007ffe0ffULL,
0x0000010061607825ULL, 0x000fe200078e005cULL, 0x000062005e647a10ULL, 0x000fc60007f1e0ffULL,
0x0000000121637824ULL, 0x000fe200078e026fULL, 0x0000620060667a10ULL, 0x000fe20007f3e0ffULL,
0x00000001716d7824ULL, 0x000fe200078e0221ULL, 0x000063005f657a10ULL, 0x000fe200007fe4ffULL,
0x00000100635e7825ULL, 0x000fe200078e005cULL, 0x0000630061677a10ULL, 0x000fe40000ffe4ffULL,
0x0000002205617217ULL, 0x000fe20007800000ULL, 0x0000000170637824ULL, 0x100fe200078e0221ULL,
0x000062005e687a10ULL, 0x000fe20007f1e0ffULL, 0x0000000172737824ULL, 0x000fc400078e0221ULL,
0x00000001616c7824ULL, 0x000fe200078e0a22ULL, 0x000063005f697a10ULL, 0x000fe200007fe4ffULL,
0x000001006d5e7825ULL, 0x000fc600078e005cULL, 0x0000006c6e00720cULL, 0x080fe20003f46070ULL,
0x000000046b6d7824ULL, 0x040fe200078e00ffULL, 0x0000006c6b00720cULL, 0x080fe20003f66070ULL,
0x0000010063607825ULL, 0x000fe200078e005cULL, 0x000062005e6a7a10ULL, 0x000fe40007f3e0ffULL,
0xfffffffc6d5e7812ULL, 0x000fe200078ee212ULL, 0x0000010073627825ULL, 0x000fe200078e005cULL,
0x000000306e737810ULL, 0x040fe40007ffe0ffULL, 0x000000386e6e7810ULL, 0x000fe20007ffe0ffULL,
0x000000105e6d7824ULL, 0x000fe200078e020fULL, 0x0000620060607a10ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064117faeULL, 0x0003e2000d101c48ULL,
0x000063005f6b7a10ULL, 0x000fe20000ffe4ffULL, 0x00000001735f7824ULL, 0x100fe200078e0221ULL,
0x0000006c6f00720cULL, 0x080fe20003fa6070ULL, 0x000000016e217824ULL, 0x000fe200078e0221ULL,
0x0000630061617a10ULL, 0x000fe200007fe4ffULL, 0x00000000666d7faeULL, 0x0005e2000d901c48ULL,
0x000000046f6f7824ULL, 0x000fe200078e00ffULL, 0x0000620062627a10ULL, 0x000fe20007f1e0ffULL,
0x000001005f5e7825ULL, 0x000fe200078e005cULL, 0x0000006c7100720cULL, 0x000fc40003f66070ULL,
0x0000006c7000720cULL, 0x0c0fe20003f86070ULL, 0x0000000470117824ULL, 0x002fe200078e00ffULL,
0x0000006c7300720cULL, 0x080fe20003f26070ULL, 0x00000100215c7825ULL, 0x000fe200078e005cULL,
0x0000630063637a10ULL, 0x000fe400007fe4ffULL, 0x0000006c7200720cULL, 0x0c0fe20003f46070ULL,
0x0000000471717824ULL, 0x000fe200078e00ffULL, 0xfffffffc6f647812ULL, 0x100fe200078ee212ULL,
0x0000000472217824ULL, 0x000fe200078e00ffULL, 0x000062005e5e7a10ULL, 0x000fe20007fde0ffULL,
0x0000000473737824ULL, 0x000fe200078e00ffULL, 0x0000006c6e00720cULL, 0x040fe20003f06070ULL,
0x000000046e657824ULL, 0x000fe200078e00ffULL, 0xfffffffc11667812ULL, 0x104fe200078ee212ULL,
0x0000001064117824ULL, 0x000fe200078e020fULL, 0xfffffffc716c7812ULL, 0x000fc400078ee212ULL,
0xfffffffc216e7812ULL, 0x100fe200078ee212ULL, 0x0000001066217824ULL, 0x100fe200078e020fULL,
0xfffffffc73707812ULL, 0x100fe200078ee212ULL, 0x0000000068117faeULL, 0x0003e2000e901c48ULL,
0x000063005f5f7a10ULL, 0x000fe200037fe4ffULL, 0x000000106e677824ULL, 0x100fe200078e020fULL,
0xfffffffc65727812ULL, 0x000fe200078ee212ULL, 0x000000106c657824ULL, 0x100fe200078e020fULL,
0x000062005c5c7a10ULL, 0x000fe20007fde0ffULL, 0x00000010706d7824ULL, 0x100fe200078e020fULL,
0x0000000060217faeULL, 0x0003e2000e101c48ULL, 0x00000010720f7824ULL, 0x000fe200078e020fULL,
0x000063005d5d7a10ULL, 0x000fc400037fe4ffULL, 0x000000006a657faeULL, 0x0003e8000d901c48ULL,
0x0000000062677faeULL, 0x0003e8000d101c48ULL, 0x000000005e6d7faeULL, 0x0003e8000c901c48ULL,
0x000000005c0f7faeULL, 0x0003e2000c101c48ULL, 0x000004a000007947ULL, 0x000fea0003800000ULL,
0x00000008996c7811ULL, 0x060fe200078ff0ffULL, 0x000000ffff6b7224ULL, 0x000fe200078e00ffULL,
0x00000010996e7811ULL, 0x000fe200078ff0ffULL, 0x0000001011757824ULL, 0x000fe200078e020fULL,
0x0000001899707811ULL, 0x040fe200078ff0ffULL, 0x000000016c5f7824ULL, 0x100fe200078e0221ULL,
0x0000002099727811ULL, 0x040fe200078ff0ffULL, 0x000000016e617824ULL, 0x100fe200078e0221ULL,
0x0000002899747811ULL, 0x040fe200078ff0ffULL, 0x0000000170637824ULL, 0x100fe200078e0221ULL,
0x0000003099767811ULL, 0x040fe200078ff0ffULL, 0x0000000172657824ULL, 0x100fe200078e0221ULL,
0x0000003899787811ULL, 0x040fe200078ff0ffULL, 0x0000000174677824ULL, 0x100fe200078e0221ULL,
0x000000c0206a7812ULL, 0x000fe200078efcffULL, 0x0000000176697824ULL, 0x100fe200078e0221ULL,
0x00000021995d7211ULL, 0x000fe200078ff0ffULL, 0x0000000178217824ULL, 0x000fc400078e0221ULL,
0x000001005f5e7825ULL, 0x000fc800078e006aULL, 0x000001005d5c7825ULL, 0x000fe200078e006aULL,
0x000062005e5e7a10ULL, 0x000fc60007f3e0ffULL, 0x0000010061607825ULL, 0x100fe200078e006aULL,
0x000062005c5c7a10ULL, 0x000fe40007f1e0ffULL, 0x000063005f5f7a10ULL, 0x000fe20000ffe4ffULL,
0x0000010063627825ULL, 0x100fe200078e006aULL, 0x0000620060607a10ULL, 0x000fe40007f5e0ffULL,
0x000063005d5d7a10ULL, 0x000fe200007fe4ffULL, 0x0000010065647825ULL, 0x100fe200078e006aULL,
0x0000620062627a10ULL, 0x000fe40007f7e0ffULL, 0x0000630061617a10ULL, 0x000fe200017fe4ffULL,
0x0000010067667825ULL, 0x100fe200078e006aULL, 0x0000620064647a10ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000005c757faeULL, 0x0003e2000b901c48ULL,
0x0000630063637a10ULL, 0x000fe20001ffe4ffULL, 0x0000010069687825ULL, 0x000fe200078e006aULL,
0x0000620066667a10ULL, 0x000fc40007f3e0ffULL, 0x0000630065657a10ULL, 0x000fe200007fe4ffULL,
0x00000100216a7825ULL, 0x000fe200078e006aULL, 0x0000620068687a10ULL, 0x000fe40007f5e0ffULL,
0x0000630067677a10ULL, 0x000fe20000ffe4ffULL, 0x000000046c117824ULL, 0x000fe200078e00ffULL,
0x000062006a6a7a10ULL, 0x000fe20007f7e0ffULL, 0x000000046e217824ULL, 0x000fe200078e00ffULL,
0x0000630069697a10ULL, 0x000fe200017fe4ffULL, 0x00000004706d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc116c7812ULL, 0x100fe200078ee212ULL, 0x00000004726f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc216e7812ULL, 0x100fe200078ee212ULL, 0x0000000474717824ULL, 0x000fe200078e00ffULL,
0xfffffffc6d707812ULL, 0x100fe200078ee212ULL, 0x0000000476737824ULL, 0x000fe200078e00ffULL,
0xfffffffc6f727812ULL, 0x100fe200078ee212ULL, 0x0000000478777824ULL, 0x000fe200078e00ffULL,
0xfffffffc71747812ULL, 0x100fe200078ee212ULL, 0x000000106c117824ULL, 0x100fe200078e020fULL,
0xfffffffc73767812ULL, 0x100fe200078ee212ULL, 0x000000106e217824ULL, 0x100fe200078e020fULL,
0xfffffffc77787812ULL, 0x000fe200078ee212ULL, 0x00000010706d7824ULL, 0x100fe200078e020fULL,
0x000000005e117faeULL, 0x0003e2000b901c48ULL, 0x00000010726f7824ULL, 0x100fe200078e020fULL,
0x000063006b6b7a10ULL, 0x000fe20001ffe4ffULL, 0x0000001074717824ULL, 0x100fe200078e020fULL,
0x0000000060217faeULL, 0x0003e2000b901c48ULL, 0x0000001076737824ULL, 0x000fc400078e020fULL,
0x00000010780f7824ULL, 0x000fe200078e020fULL, 0x00000000626d7faeULL, 0x0003e8000b901c48ULL,
0x00000000646f7faeULL, 0x0003e8000b901c48ULL, 0x0000000066717faeULL, 0x0003e8000b901c48ULL,
0x0000000068737faeULL, 0x0003e8000b901c48ULL, 0x000000006a0f7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000101f5c7824ULL, 0x002fe200078e00ffULL,
0x000000081e0f7810ULL, 0x000fe20007ffe0ffULL, 0x000000101c5e7824ULL, 0x000fe200078e00ffULL,
0x000000081b117810ULL, 0x000fe20007ffe0ffULL, 0x000000101f747824ULL, 0x000fe200078e00ffULL,
0xfffffff05c0f7812ULL, 0x000fe200078ee20fULL, 0x000000101c757824ULL, 0x000fe200078e00ffULL,
0xfffffff05e117812ULL, 0x000fc400078ee211ULL, 0x0000000a1e217810ULL, 0x000fe20007ffe0ffULL,
0x000000100f0f7824ULL, 0x000fe400078e00ffULL, 0x0000001011117824ULL, 0x000fe200078e00ffULL,
0xfffffff074217812ULL, 0x000fe400078ee221ULL, 0x0000000a1b747810ULL, 0x000fc60007ffe0ffULL,
0x0000001021217824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001a5c783bULL, 0x000fe80000000200ULL, 0x000000000f60783bULL, 0x0002a80000000200ULL,
0x000000001964783bULL, 0x000ee80000000200ULL, 0x000000001868783bULL, 0x000f220000000200ULL,
0xfffffff0750f7812ULL, 0x002fc600078ee274ULL, 0x000000001770783bULL, 0x000e640000000200ULL,
0x000000100f0f7824ULL, 0x000fe400078e00ffULL, 0x00000000116c783bULL, 0x000e680000000200ULL,
0x000000001674783bULL, 0x000fe80000000200ULL, 0x000000002178783bULL, 0x000e680000000200ULL,
0x00000000157c783bULL, 0x000e680000000200ULL, 0x000000001480783bULL, 0x000e680000000200ULL,
0x000000001388783bULL, 0x000e680000000200ULL, 0x000000000f84783bULL, 0x0006620000000200ULL,
0x0000005c6058723cULL, 0x004f620000001858ULL, 0x00000300030f7a10ULL, 0x008fce0007ffe0ffULL,
0x0000005e6024723cULL, 0x000f620000001824ULL, 0x000000010f117810ULL, 0x040fe20007ffe0ffULL,
0x000001000f1a7824ULL, 0x000fc600078e029aULL, 0x000000061100720cULL, 0x000fc60003f06070ULL,
0x000000646028723cULL, 0x040f700000001828ULL, 0x000000666090723cULL, 0x040f700000001890ULL,
0x00000068608c723cULL, 0x050f70000000188cULL, 0x0000006a602c723cULL, 0x040f70000000182cULL,
0x000000706030723cULL, 0x042f700000001830ULL, 0x000000726034723cULL, 0x000f700000001834ULL,
0x0000005c6c38723cULL, 0x040f700000001838ULL, 0x0000005e6c3c723cULL, 0x040f70000000183cULL,
0x000000646c40723cULL, 0x040b6e0000001840ULL, 0x0000660002647a24ULL, 0x020fe200078e021aULL,
0x000000666c44723cULL, 0x040f700000001844ULL, 0x000000686c48723cULL, 0x040f700000001848ULL,
0x0000006a6c4c723cULL, 0x040f70000000184cULL, 0x000000706c50723cULL, 0x040f700000001850ULL,
0x000000726c54723cULL, 0x000f700000001854ULL, 0x000000747858723cULL, 0x040b700000001858ULL,
0x000000767824723cULL, 0x040b700000001824ULL, 0x0000007c7828723cULL, 0x040b700000001828ULL,
0x0000007e7890723cULL, 0x040b700000001890ULL, 0x00000080788c723cULL, 0x040b70000000188cULL,
0x00000082782c723cULL, 0x040b70000000182cULL, 0x000000887830723cULL, 0x040b700000001830ULL,
0x0000008a7834723cULL, 0x000b700000001834ULL, 0x000000748438723cULL, 0x040b700000001838ULL,
0x00000076843c723cULL, 0x040b70000000183cULL, 0x0000007c8440723cULL, 0x040b700000001840ULL,
0x0000007e8444723cULL, 0x060b700000001844ULL, 0x000000808448723cULL, 0x040b700000001848ULL,
0x00000082844c723cULL, 0x040b70000000184cULL, 0x000000888450723cULL, 0x040b700000001850ULL,
0x0000008a8454723cULL, 0x000b620000001854ULL, 0x000005b000008947ULL, 0x000fce0003800000ULL,
0x00000002ff137819ULL, 0x000fe40000011699ULL, 0x0000001a05117217ULL, 0x000fc40007800000ULL,
0x0000000813217810ULL, 0x040fe20007ffe0ffULL, 0x0000000113147824ULL, 0x040fe200078e0264ULL,
0x0000001013657810ULL, 0x000fe20007ffe0ffULL, 0x0000000111117824ULL, 0x000fe200078e0a1aULL,
0x0000001813667810ULL, 0x040fe20007ffe0ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000002013677810ULL, 0x040fe40007ffe0ffULL, 0x0000002813687810ULL, 0x000fe20007ffe0ffULL,
0x0000000121167824ULL, 0x000fe200078e0264ULL, 0x00000020145c7212ULL, 0x000fe200078efcffULL,
0x0000000164187824ULL, 0x000fe200078e0265ULL, 0x000000116500720cULL, 0x000fe20003fa6070ULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x000062005c5c7a10ULL, 0x000fc40007f1e0ffULL,
0x000000116600720cULL, 0x0c0fe20003f86070ULL, 0x0000000166147824ULL, 0x100fe200078e0264ULL,
0x00000020165e7212ULL, 0x080fe200078efcffULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x00006300155d7a10ULL, 0x000fe400007fe4ffULL, 0x000062005e5e7a10ULL, 0x000fe20007f3e0ffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x0000002018187212ULL, 0x080fe400078efcffULL,
0x00006300175f7a10ULL, 0x000fe20000ffe4ffULL, 0x0000000167167824ULL, 0x100fe200078e0264ULL,
0x0000002014607212ULL, 0x000fe200078efcffULL, 0x0000000168147824ULL, 0x000fe200078e0264ULL,
0x0000620018187a10ULL, 0x000fe20007f1e0ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x000000112100720cULL, 0x000fc40003f26070ULL, 0x0000620060607a10ULL, 0x000fe20007f5e0ffULL,
0x0000000421217824ULL, 0x000fe200078e00ffULL, 0x0000630019197a10ULL, 0x000fe200007fe4ffULL,
0x0000000465657824ULL, 0x000fe200078e00ffULL, 0x000000111300720cULL, 0x000fe40003f06070ULL,
0x0000630015617a10ULL, 0x000fe200017fe4ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0xfffffffc211a7812ULL, 0x000fe400078ee212ULL, 0x0000002016167212ULL, 0x000fc400078efcffULL,
0x0000002014627212ULL, 0x000fe200078efcffULL, 0x000000101a217824ULL, 0x000fe200078e021dULL,
0x00000030131a7810ULL, 0x040fe40007ffe0ffULL, 0x0000620016167a10ULL, 0x000fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000005c107faeULL, 0x0003e2000c101c48ULL,
0x0000620062627a10ULL, 0x000fe40007fde0ffULL, 0x0000003813137810ULL, 0x000fe20007ffe0ffULL,
0x000000005e217faeULL, 0x0005e2000c901c48ULL, 0x0000630017177a10ULL, 0x000fc40001ffe4ffULL,
0x0000630015637a10ULL, 0x000fe200037fe4ffULL, 0x0000000466157824ULL, 0x000fe200078e00ffULL,
0x000000116700720cULL, 0x080fe20003f66070ULL, 0x0000000113147824ULL, 0x100fe200078e0264ULL,
0x000000116800720cULL, 0x080fe20003f46070ULL, 0x000000011a107824ULL, 0x042fe200078e0264ULL,
0x000000111a00720cULL, 0x080fe20003f26070ULL, 0x0000000467677824ULL, 0x000fe200078e00ffULL,
0x000000111300720cULL, 0x000fe20003f06070ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0xfffffffc155c7812ULL, 0x000fc400078ee212ULL, 0xfffffffc675e7812ULL, 0x104fe200078ee212ULL,
0x0000000468217824ULL, 0x000fe200078e00ffULL, 0x0000002010107212ULL, 0x080fe200078efcffULL,
0x000000041a5d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc651a7812ULL, 0x100fe200078ee212ULL,
0x0000000413137824ULL, 0x000fe200078e00ffULL, 0x0000620010107a10ULL, 0x000fe20007fde0ffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0xfffffffc21647812ULL, 0x100fe400078ee212ULL,
0xfffffffc5d667812ULL, 0x100fe200078ee212ULL, 0x000000101a217824ULL, 0x100fe200078e021dULL,
0xfffffffc13687812ULL, 0x000fe200078ee212ULL, 0x000000105c5d7824ULL, 0x100fe200078e021dULL,
0x0000002014127212ULL, 0x000fe200078efcffULL, 0x000000105e5f7824ULL, 0x100fe200078e021dULL,
0x0000630011117a10ULL, 0x000fe200037fe4ffULL, 0x0000001064657824ULL, 0x100fe200078e021dULL,
0x0000620012127a10ULL, 0x000fe20007fde0ffULL, 0x0000001066677824ULL, 0x100fe200078e021dULL,
0x0000000018217faeULL, 0x0003e2000e901c48ULL, 0x00000010681d7824ULL, 0x000fe200078e021dULL,
0x0000630015137a10ULL, 0x000fc400037fe4ffULL, 0x00000000605d7faeULL, 0x0003e8000e101c48ULL,
0x00000000165f7faeULL, 0x0003e8000d901c48ULL, 0x0000000062657faeULL, 0x0003e8000d101c48ULL,
0x0000000010677faeULL, 0x0003e8000c901c48ULL, 0x00000000121d7faeULL, 0x0003e2000c101c48ULL,
0x000004f000007947ULL, 0x000fea0003800000ULL, 0x0000000899117811ULL, 0x040fe400078ff0ffULL,
0x0000002899217811ULL, 0x000fc400078ff0ffULL, 0x0000001899177811ULL, 0x000fe200078ff0ffULL,
0x0000000111137824ULL, 0x100fe200078e0264ULL, 0x0000002099197811ULL, 0x000fe200078ff0ffULL,
0x0000000411617824ULL, 0x000fe200078e00ffULL, 0x00000030995d7811ULL, 0x000fe200078ff0ffULL,
0x00000001211a7824ULL, 0x100fe200078e0264ULL, 0x00000038995f7811ULL, 0x000fe200078ff0ffULL,
0x0000000421657824ULL, 0x000fe200078e00ffULL, 0x0000001099157811ULL, 0x000fe200078ff0ffULL,
0x0000000117187824ULL, 0x100fe200078e0264ULL, 0x0000006499147211ULL, 0x000fe200078ff0ffULL,
0x0000000119117824ULL, 0x000fe200078e0264ULL, 0xfffffffc61607812ULL, 0x000fe200078ee212ULL,
0x000000015d217824ULL, 0x000fe200078e0264ULL, 0xfffffffc65687812ULL, 0x000fe200078ee212ULL,
0x000000015f5c7824ULL, 0x000fc400078e0264ULL, 0x0000000415637824ULL, 0x000fe400078e00ffULL,
0x0000000417177824ULL, 0x000fe400078e00ffULL, 0x0000000419197824ULL, 0x000fe200078e00ffULL,
0xfffffffc63627812ULL, 0x100fe200078ee212ULL, 0x000000045d5d7824ULL, 0x000fe400078e00ffULL,
0x000000045f5f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc19667812ULL, 0x000fe200078ee212ULL,
0x0000000115167824ULL, 0x000fe200078e0264ULL, 0xfffffffc17647812ULL, 0x100fe200078ee212ULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0xfffffffc5d6a7812ULL, 0x000fc400078ee212ULL,
0xfffffffc5f6c7812ULL, 0x000fe200078ee212ULL, 0x0000010013127825ULL, 0x000fe200078e00ffULL,
0x00000020145e7212ULL, 0x000fc600078efcffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x000062005e5e7a10ULL, 0x000fc60007f1e0ffULL, 0x0000001060657824ULL, 0x100fe200078e021dULL,
0x0000002012607212ULL, 0x080fe200078efcffULL, 0x0000001062677824ULL, 0x000fe200078e021dULL,
0x0000002016627212ULL, 0x080fe200078efcffULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x0000620060607a10ULL, 0x000fe40007f3e0ffULL, 0x0000620062627a10ULL, 0x000fe20007f5e0ffULL,
0x000001005c5c7825ULL, 0x000fe200078e00ffULL, 0x0000630013617a10ULL, 0x000fe40000ffe4ffULL,
0x00006300155f7a10ULL, 0x000fe200007fe4ffULL, 0x0000010011127825ULL, 0x000fe200078e00ffULL,
0x0000002018187212ULL, 0x000fc400078efcffULL, 0x0000630017637a10ULL, 0x000fe200017fe4ffULL,
0x000001001a147825ULL, 0x000fe200078e00ffULL, 0x0000620018187a10ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000005e107faeULL, 0x0003e2000b901c48ULL,
0x0000002012127212ULL, 0x080fe200078efcffULL, 0x0000010021167825ULL, 0x000fe200078e00ffULL,
0x0000002014147212ULL, 0x080fe200078efcffULL, 0x0000000060657faeULL, 0x0003e2000b901c48ULL,
0x0000630019197a10ULL, 0x000fe200007fe4ffULL, 0x0000001064697824ULL, 0x100fe200078e021dULL,
0x0000002016167212ULL, 0x080fe200078efcffULL, 0x00000010666b7824ULL, 0x100fe200078e021dULL,
0x000000205c207212ULL, 0x000fe200078efcffULL, 0x00000010686d7824ULL, 0x100fe200078e021dULL,
0x0000620012127a10ULL, 0x000fe20007f1e0ffULL, 0x000000106a6f7824ULL, 0x100fe200078e021dULL,
0x0000620014147a10ULL, 0x000fe20007f3e0ffULL, 0x000000106c1d7824ULL, 0x000fe200078e021dULL,
0x0000620016167a10ULL, 0x000fe20007f5e0ffULL, 0x0000000062677faeULL, 0x0003e2000b901c48ULL,
0x0000620020207a10ULL, 0x000fc40007f7e0ffULL, 0x0000630013137a10ULL, 0x000fe200007fe4ffULL,
0x0000000018697faeULL, 0x0003e2000b901c48ULL, 0x0000630015157a10ULL, 0x000fe40000ffe4ffULL,
0x0000630017177a10ULL, 0x000fe200017fe4ffULL, 0x00000000126b7faeULL, 0x0003e2000b901c48ULL,
0x000063005d217a10ULL, 0x000fc60001ffe4ffULL, 0x00000000146d7faeULL, 0x0003e8000b901c48ULL,
0x00000000166f7faeULL, 0x0003e8000b901c48ULL, 0x00000000201d7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000101f117824ULL, 0x002fe200078e00ffULL,
0x0000000c1e107810ULL, 0x000fe20007ffe0ffULL, 0x000000101c197824ULL, 0x040fe200078e00ffULL,
0x0000000c1b187810ULL, 0x000fe20007ffe0ffULL, 0x000000101f1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff011107812ULL, 0x000fe200078ee210ULL, 0x000000101c1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff019187812ULL, 0x000fc400078ee218ULL, 0x0000000e1e1e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001010147824ULL, 0x000fe200078e00ffULL, 0x0000000e1b1b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001018187824ULL, 0x000fe200078e00ffULL, 0xfffffff01f1e7812ULL, 0x000fe400078ee21eULL,
0xfffffff01c1b7812ULL, 0x000fc600078ee21bULL, 0x000000101e6c7824ULL, 0x000fe400078e00ffULL,
0x000000101b1b7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000e10783bULL, 0x000fe80000000200ULL, 0x000000001414783bULL, 0x000e680000000200ULL,
0x000000000d5c783bULL, 0x000ea80000000200ULL, 0x000000000c70783bULL, 0x000ee80000000200ULL,
0x000000000b74783bULL, 0x000f280000000200ULL, 0x000000001878783bULL, 0x000ee80000000200ULL,
0x000000000a64783bULL, 0x000fe80000000200ULL, 0x000000006c6c783bULL, 0x000ee80000000200ULL,
0x000000000968783bULL, 0x000ee80000000200ULL, 0x000000000860783bULL, 0x000ee80000000200ULL,
0x00000000041c783bULL, 0x0005280000000200ULL, 0x000000001b18783bULL, 0x000f220000000200ULL,
0x000000121424723cULL, 0x042f700000001824ULL, 0x0000005c1428723cULL, 0x044f700000001828ULL,
0x000000101458723cULL, 0x040f700000001858ULL, 0x0000005e1490723cULL, 0x040f700000001890ULL,
0x00000070148c723cULL, 0x048ff0000000188cULL, 0x00000072142c723cULL, 0x040ff0000000182cULL,
0x000000741430723cULL, 0x050ff00000001830ULL, 0x000000761434723cULL, 0x000ff00000001834ULL,
0x000000107814723cULL, 0x040ff00000001838ULL, 0x0000005c7840723cULL, 0x040ff00000001840ULL,
0x000000707848723cULL, 0x060ff00000001848ULL, 0x00000012783c723cULL, 0x040ff0000000183cULL,
0x0000005e7844723cULL, 0x040ff00000001844ULL, 0x00000072784c723cULL, 0x040ff0000000184cULL,
0x000000747850723cULL, 0x040ff00000001850ULL, 0x000000767854723cULL, 0x000ff00000001854ULL,
0x000000666c38723cULL, 0x040f700000001824ULL, 0x000000686c5c723cULL, 0x040f700000001828ULL,
0x000000646c58723cULL, 0x040f700000001858ULL, 0x0000006a6c28723cULL, 0x000f640000001890ULL,
0x3db504f3380c7820ULL, 0x020fe20000410000ULL, 0x3db504f3390e7820ULL, 0x000fe20000410000ULL,
0x3db504f33b217820ULL, 0x000fc80000410000ULL, 0x000000606c24723cULL, 0x000f62000000188cULL,
0x3db504f35c5c7820ULL, 0x000fe20000410000ULL, 0x3db504f35d5d7820ULL, 0x000fe20000410000ULL,
0x3db504f35e5e7820ULL, 0x000fe20000410000ULL, 0x3db504f35f5f7820ULL, 0x000fc80000410000ULL,
0x000000626c10723cULL, 0x000f62000000182cULL, 0x3db504f3580d7820ULL, 0x000fe20000410000ULL,
0x3db504f359047820ULL, 0x000fe20000410000ULL, 0x3db504f35a5a7820ULL, 0x000fca0000410000ULL,
0x0000001c6c08723cULL, 0x000f620000001830ULL, 0x3db504f328287820ULL, 0x000fe20000410000ULL,
0x3db504f329297820ULL, 0x000fe20000410000ULL, 0x3db504f32a2a7820ULL, 0x000fe20000410000ULL,
0x3db504f32b2b7820ULL, 0x000fc80000410000ULL, 0x0000001e6c6c723cULL, 0x000f640000001834ULL,
0x3db504f324247820ULL, 0x020fe20000410000ULL, 0x3db504f325257820ULL, 0x000fe20000410000ULL,
0x3db504f326207820ULL, 0x000fe20000410000ULL, 0x3db504f327387820ULL, 0x000fc60000410000ULL,
0x000000641814723cULL, 0x000f620000001814ULL, 0x3db504f312397820ULL, 0x000fce0000410000ULL,
0x00000068182c723cULL, 0x000f620000001840ULL, 0x3db504f308087820ULL, 0x000fe20000410000ULL,
0x3db504f309097820ULL, 0x000fe20000410000ULL, 0x3db504f30a0a7820ULL, 0x000fe20000410000ULL,
0x3db504f30b0b7820ULL, 0x000fc80000410000ULL, 0x000000601830723cULL, 0x000b620000001848ULL,
0x3db504f36c6c7820ULL, 0x000fe20000410000ULL, 0x3db504f36d6d7820ULL, 0x000fe20000410000ULL,
0x3db504f36e6e7820ULL, 0x000fe20000410000ULL, 0x3db504f36f6f7820ULL, 0x000fc80000410000ULL,
0x000000661864723cULL, 0x000b64000000183cULL, 0x3db504f3143b7820ULL, 0x020fe20000410000ULL,
0x3db504f317487820ULL, 0x000fc80000410000ULL, 0x3db504f3153c7820ULL, 0x000fe20000410000ULL,
0x0000006a1868723cULL, 0x000b620000001844ULL, 0x3db504f32c3d7820ULL, 0x000fe20000410000ULL,
0x3db504f32d3e7820ULL, 0x000fca0000410000ULL, 0x3db504f316447820ULL, 0x020fe20000410000ULL,
0x000000621860723cULL, 0x000b62000000184cULL, 0x3db504f3303f7820ULL, 0x000fe20000410000ULL,
0x3db504f331407820ULL, 0x000fe20000410000ULL, 0x3db504f3324a7820ULL, 0x000fe20000410000ULL,
0x3db504f333437820ULL, 0x000fc60000410000ULL, 0x3db504f32e4d7820ULL, 0x020fe20000410000ULL,
0x0000001c1834723cULL, 0x040b620000001850ULL, 0x3db504f364647820ULL, 0x000fe20000410000ULL,
0x3db504f365657820ULL, 0x000fe20000410000ULL, 0x3db504f366497820ULL, 0x000fe20000410000ULL,
0x3db504f3674b7820ULL, 0x000fe20000410000ULL, 0x3db504f32f4e7820ULL, 0x000fe40000410000ULL,
0x3db504f3101c7820ULL, 0x020fe20000410000ULL, 0x0000001e1818723cULL, 0x000b620000001854ULL,
0x3db504f3111d7820ULL, 0x000fe20000410000ULL, 0x3db504f368687820ULL, 0x000fe20000410000ULL,
0x3db504f369697820ULL, 0x000fe20000410000ULL, 0x3db504f36a4f7820ULL, 0x000fe20000410000ULL,
0x3db504f36b4c7820ULL, 0x000fc40000410000ULL, 0x3db504f33a1f7820ULL, 0x020fe20000410000ULL,
0x3db504f35b1e7820ULL, 0x000fe20000410000ULL, 0x3db504f3133a7820ULL, 0x000fe20000410000ULL,
0x3db504f360607820ULL, 0x000fe20000410000ULL, 0x3db504f361617820ULL, 0x000fe20000410000ULL,
0x3db504f362627820ULL, 0x000fe20000410000ULL, 0x3db504f363637820ULL, 0x000fc60000410000ULL,
0x3db504f334417820ULL, 0x000fe20000410000ULL, 0x3db504f335427820ULL, 0x000fe20000410000ULL,
0x3db504f336467820ULL, 0x000fe20000410000ULL, 0x3db504f337477820ULL, 0x000fca0000410000ULL,
0x3db504f318187820ULL, 0x000fe20000410000ULL, 0x3db504f319457820ULL, 0x000fe20000410000ULL,
0x3db504f31a527820ULL, 0x000fe20000410000ULL, 0x3db504f31b537820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000098507f8cULL, 0x0002a2000c80043fULL,
0x000000ffff137224ULL, 0x000fe400078e0029ULL, 0x000000ffff267224ULL, 0x000fe400078e002aULL,
0x000000ffff297224ULL, 0x000fe400078e0038ULL, 0x000000ffff2a7224ULL, 0x000fc400078e0039ULL,
0x000000ffff317224ULL, 0x000fe400078e003bULL, 0x000000ffff387224ULL, 0x000fe400078e003fULL,
0x000000ffff277224ULL, 0x000fe400078e002bULL, 0x000000ffff397224ULL, 0x000fe400078e0040ULL,
0x000000ffff3f7224ULL, 0x000fe400078e0041ULL, 0x000000ffff3b7224ULL, 0x000fc400078e0043ULL,
0x000000ffff127224ULL, 0x000fe400078e0028ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0024ULL,
0x000000ffff157224ULL, 0x000fe400078e0025ULL, 0x000000ffff197224ULL, 0x000fe400078e001cULL,
0x000000ffff167224ULL, 0x000fe400078e001dULL, 0x000000ffff2b7224ULL, 0x000fc400078e003aULL,
0x000000ffff307224ULL, 0x000fe400078e003cULL, 0x000000ffff347224ULL, 0x000fe400078e003dULL,
0x000000ffff357224ULL, 0x000fe400078e003eULL, 0x000000ffff407224ULL, 0x000fe400078e0042ULL,
0x000000ffff417224ULL, 0x000fe400078e0046ULL, 0x000000ffff437224ULL, 0x000fc400078e0047ULL,
0x000000ffff107224ULL, 0x000fe400078e005cULL, 0x000000ffff117224ULL, 0x000fe400078e005dULL,
0x000000ffff177224ULL, 0x000fe400078e0008ULL, 0x000000ffff147224ULL, 0x000fe400078e0009ULL,
0x000000ffff1d7224ULL, 0x000fe400078e006cULL, 0x000000ffff1b7224ULL, 0x000fc400078e006dULL,
0x000000ffff1c7224ULL, 0x000fe400078e005aULL, 0x000000ffff247224ULL, 0x000fe400078e005eULL,
0x000000ffff257224ULL, 0x000fe400078e005fULL, 0x000000ffff287224ULL, 0x000fe400078e0020ULL,
0x000000ffff2c7224ULL, 0x000fe400078e000aULL, 0x000000ffff2d7224ULL, 0x000fc400078e000bULL,
0x000000ffff2e7224ULL, 0x000fe400078e006eULL, 0x000000ffff2f7224ULL, 0x000fe400078e006fULL,
0x000000ffff327224ULL, 0x000fe400078e0064ULL, 0x000000ffff337224ULL, 0x000fe400078e0065ULL,
0x000000ffff367224ULL, 0x000fe400078e0068ULL, 0x000000ffff377224ULL, 0x000fc400078e0069ULL,
0x000000ffff3a7224ULL, 0x000fe400078e0060ULL, 0x000000ffff3c7224ULL, 0x000fe400078e0061ULL,
0x000000ffff427224ULL, 0x000fe400078e0018ULL, 0x000000ffff3d7224ULL, 0x000fe400078e0062ULL,
0x000000ffff3e7224ULL, 0x000fe400078e0063ULL, 0x000000ffff467224ULL, 0x000fc400078e0052ULL,
0x000000ffff477224ULL, 0x000fc400078e0053ULL, 0x0000000000087805ULL, 0x006fca0000015200ULL,
0x00000400980b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804851ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a08537210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09005300780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c405300780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x000000530a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000118187810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400980b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804851ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000499207824ULL, 0x000fe200078e00ffULL, 0x000000940300720cULL, 0x000fc80003f06070ULL,
0xfffffff020097812ULL, 0x000fca00078ec0ffULL, 0x0000008000187824ULL, 0x000fca00078e0209ULL,
0x0164000018087984ULL, 0x0002a20000000c00ULL, 0x00001f5000008947ULL, 0x000fea0003800000ULL,
0x0000000299037824ULL, 0x000fe200078e00ffULL, 0x0000002205517217ULL, 0x000fe20007800000ULL,
0x00000002ff627424ULL, 0x000fe200078e00ffULL, 0x0000000799507211ULL, 0x000fe400078ff0ffULL,
0x0000000603037812ULL, 0x000fe200078ec0ffULL, 0x0000000151227824ULL, 0x000fe200078e0a22ULL,
0x0000000850517810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff537a19ULL, 0x000fe20000011650ULL,
0x0000000195557824ULL, 0x000fe200078e0203ULL, 0x00005a00ff577a19ULL, 0x000fc40000011651ULL,
0x0000580003517a10ULL, 0x000fe40007ffe0ffULL, 0x000000225500720cULL, 0x040fe20003f26070ULL,
0x0000000155557824ULL, 0x100fe200078e0a22ULL, 0x0000001050547810ULL, 0x040fe40007ffe0ffULL,
0x0000001850567810ULL, 0x000fe40007ffe0ffULL, 0x0000005396507217ULL, 0x040fe20003800000ULL,
0x0000000151537824ULL, 0x000fe200078e0a22ULL, 0x0000005596557217ULL, 0x000fc40003800000ULL,
0x000000225100720cULL, 0x000fe20003f06070ULL, 0x0000005023797224ULL, 0x000fe200078e02ffULL,
0x0000005396537217ULL, 0x000fe40003800000ULL, 0x00000004ff557819ULL, 0x000fe40000011655ULL,
0x000000ff53607207ULL, 0x000fe40000000000ULL, 0x000000ff555a7207ULL, 0x000fe40000800000ULL,
0x00005a00ff537a19ULL, 0x000fc40000011654ULL, 0x0000005796527217ULL, 0x000fe20003800000ULL,
0x0000000179577824ULL, 0x000fe200078e025aULL, 0x0000007960557211ULL, 0x000fe400078fe0ffULL,
0x0000005396507217ULL, 0x000fe20003800000ULL, 0x00000052237f7224ULL, 0x000fe200078e02ffULL,
0x00005a00ff5b7a19ULL, 0x000fe20000011656ULL, 0x0000600055547625ULL, 0x000fc600078e0062ULL,
0x0000005b96527217ULL, 0x000fe20003800000ULL, 0x0000600057567625ULL, 0x000fe200078e0062ULL,
0x0000007f60597211ULL, 0x000fc600078fe0ffULL, 0x0000005023817224ULL, 0x000fe200078e02ffULL,
0x0000000856537981ULL, 0x000722000c1e9500ULL, 0x00000010035b7812ULL, 0x000fe200078efcffULL,
0x000000015a5f7824ULL, 0x000fe400078e027fULL, 0x0000000854507981ULL, 0x000322000c1e9500ULL,
0x0000008160657211ULL, 0x000fe200078fe0ffULL, 0x000000015a677824ULL, 0x000fe200078e0281ULL,
0x000058005b5d7a10ULL, 0x000fe20007ffe0ffULL, 0x0000600059587625ULL, 0x000fc800078e0062ULL,
0x0000000195637824ULL, 0x000fe400078e025bULL, 0x0000600065647625ULL, 0x000fc800078e0062ULL,
0x000060005f5e7625ULL, 0x080fe200078e0062ULL, 0x0000000864547981ULL, 0x0062a6000c1e9500ULL,
0x0000600067667625ULL, 0x000fe200078e0062ULL, 0x000000085e577981ULL, 0x0086a6000c1e9500ULL,
0x0000005223837224ULL, 0x000fe400078e02ffULL, 0x00000001636d7824ULL, 0x100fe200078e0a22ULL,
0x0000000858527981ULL, 0x0002a2000c1e9500ULL, 0x000000015d617824ULL, 0x040fe200078e0a22ULL,
0x0000008360697211ULL, 0x000fe200078fe0ffULL, 0x000000015a6b7824ULL, 0x000fe200078e0283ULL,
0x0000006d966d7217ULL, 0x000fe20003800000ULL, 0x0000000866597981ULL, 0x0022a2000c1e9500ULL,
0x000000225d00720cULL, 0x000fc40003f06070ULL, 0x0000006196617217ULL, 0x000fe20003800000ULL,
0x0000600069687625ULL, 0x000fe200078e0062ULL, 0x000000226300720cULL, 0x000fe40003f26070ULL,
0x00000004ff6d7819ULL, 0x000fe2000001166dULL, 0x000060006b6a7625ULL, 0x080fe200078e0062ULL,
0x000000ff61767207ULL, 0x000fe20000000000ULL, 0x0000000868557981ULL, 0x0006a2000c1e9500ULL,
0x000000ff6d5c7207ULL, 0x000fe40000800000ULL, 0x0000007976657211ULL, 0x040fe200078fe0ffULL,
0x000000086a567981ULL, 0x0006a2000c1e9500ULL, 0x0000007f76677211ULL, 0x002fe200078fe0ffULL,
0x00000001795f7824ULL, 0x008fe200078e025cULL, 0x0000002003637812ULL, 0x000fe200078efcffULL,
0x0000600065647625ULL, 0x000fc800078e0062ULL, 0x000000015c697824ULL, 0x000fe200078e027fULL,
0x0000000864587981ULL, 0x0002e2000c1e9500ULL, 0x000060005f5e7625ULL, 0x000fc800078e0062ULL,
0x0000600067667625ULL, 0x080fe200078e0062ULL, 0x0000008376717211ULL, 0x000fe200078fe0ffULL,
0x000000085e5f7981ULL, 0x0002e4000c1e9500ULL, 0x0000600069687625ULL, 0x000fe200078e0062ULL,
0x0000580063657a10ULL, 0x002fe20007ffe0ffULL, 0x00000008665a7981ULL, 0x0002e4000c1e9500ULL,
0x0000000195757824ULL, 0x000fe400078e0263ULL, 0x0000000868617981ULL, 0x0002e4000c1e9500ULL,
0x0000000175777824ULL, 0x000fc400078e0a22ULL, 0x000000015c6d7824ULL, 0x000fe200078e0283ULL,
0x00000081766b7211ULL, 0x000fe200078fe0ffULL, 0x0000000165737824ULL, 0x000fe200078e0a22ULL,
0x0000007796777217ULL, 0x000fe20003800000ULL, 0x000000015c6f7824ULL, 0x000fe400078e0281ULL,
0x000060006d6c7625ULL, 0x000fe200078e0062ULL, 0x000000226500720cULL, 0x000fc60003f06070ULL,
0x0000600071707625ULL, 0x000fe200078e0062ULL, 0x0000007396737217ULL, 0x000fe20003800000ULL,
0x000000086c6d7981ULL, 0x0002e2000c1e9500ULL, 0x000000227500720cULL, 0x000fe20003f26070ULL,
0x000060006b6a7625ULL, 0x080fe200078e0062ULL, 0x00000004ff777819ULL, 0x000fe20000011677ULL,
0x00000008705e7981ULL, 0x0002e4000c1e9500ULL, 0x000060006f6e7625ULL, 0x000fe400078e0062ULL,
0x000000086a5c7981ULL, 0x0002e4000c1e9500ULL, 0x000000ff736c7207ULL, 0x002fc40000000000ULL,
0x000000086e677981ULL, 0x0002e2000c1e9500ULL, 0x000000ff77707207ULL, 0x000fca0000800000ULL,
0x0000000170717824ULL, 0x000fe200078e027fULL, 0x0000007f6c6f7211ULL, 0x002fe200078fe0ffULL,
0x00000001796b7824ULL, 0x000fe400078e0270ULL, 0x00000001707b7824ULL, 0x040fe400078e0281ULL,
0x00000001707d7824ULL, 0x000fe200078e0283ULL, 0x000000796c697211ULL, 0x000fe200078fe0ffULL,
0x000060006f6e7625ULL, 0x000fc800078e0062ULL, 0x0000600071707625ULL, 0x080fe200078e0062ULL,
0x000000086e667981ULL, 0x0002e2000c1e9500ULL, 0x000000816c737211ULL, 0x040fe400078fe0ffULL,
0x0000600069687625ULL, 0x080fe200078e0062ULL, 0x0000000870c97981ULL, 0x0002e2000c1e9500ULL,
0x000000836c757211ULL, 0x000fe400078fe0ffULL, 0x0000003003af7812ULL, 0x000fe200078efcffULL,
0x0000000868647981ULL, 0x0002e2000c1e9500ULL, 0x000060006b6a7625ULL, 0x000fc800078e0062ULL,
0x0000600073727625ULL, 0x080fe200078e0062ULL, 0x00005800afb17a10ULL, 0x000fe20007ffe0ffULL,
0x000000086a777981ULL, 0x0002e4000c1e9500ULL, 0x0000600075747625ULL, 0x080fe400078e0062ULL,
0x0000000872cd7981ULL, 0x0002e4000c1e9500ULL, 0x000060007b687625ULL, 0x082fe400078e0062ULL,
0x0000000874d17981ULL, 0x0002e4000c1e9500ULL, 0x000060007d6e7625ULL, 0x000fc400078e0062ULL,
0x0000000868807981ULL, 0x0002e4000c1e9500ULL, 0x00000001957b7824ULL, 0x000fe400078e02afULL,
0x000000086e847981ULL, 0x0002e4000c1e9500ULL, 0x000000017b7d7824ULL, 0x100fe400078e0a22ULL,
0x00000001b16b7824ULL, 0x000fc600078e0a22ULL, 0x0000007d967d7217ULL, 0x040fe40003800000ULL,
0x000000227b00720cULL, 0x080fe40003f26070ULL, 0x00000022b100720cULL, 0x000fe40003f06070ULL,
0x0000006b966b7217ULL, 0x000fe40003800000ULL, 0x00000004ff7d7819ULL, 0x000fe4000001167dULL,
0x000000ff6b787207ULL, 0x000fc40000000000ULL, 0x000000ff7d7a7207ULL, 0x000fe40000800000ULL,
0x0000007978737211ULL, 0x040fe400078fe0ffULL, 0x0000008178697211ULL, 0x002fe200078fe0ffULL,
0x0000000179757824ULL, 0x000fe400078e027aULL, 0x000000017a6b7824ULL, 0x000fe400078e0281ULL,
0x0000600073727625ULL, 0x000fc800078e0062ULL, 0x0000600075747625ULL, 0x080fe200078e0062ULL,
0x0000000872b37981ULL, 0x0002e6000c1e9500ULL, 0x0000600069687625ULL, 0x080fe200078e0062ULL,
0x00000008747c7981ULL, 0x0002e6000c1e9500ULL, 0x000060006b6a7625ULL, 0x000fe200078e0062ULL,
0x0000000868cf7981ULL, 0x0002e2000c1e9500ULL, 0x0000007f786f7211ULL, 0x000fc600078fe0ffULL,
0x000000086a827981ULL, 0x0002e2000c1e9500ULL, 0x000000017a717824ULL, 0x000fe400078e027fULL,
0x000060006f6e7625ULL, 0x000fc800078e0062ULL, 0x0000600071707625ULL, 0x080fe200078e0062ULL,
0x000000086ecb7981ULL, 0x0002e4000c1e9500ULL, 0x0000008378737211ULL, 0x002fe400078fe0ffULL,
0x00000008707e7981ULL, 0x0002e2000c1e9500ULL, 0x000000017a757824ULL, 0x000fe400078e0283ULL,
0x0000600073727625ULL, 0x000fc800078e0062ULL, 0x0000600075747625ULL, 0x000fe200078e0062ULL,
0x0000000872d37981ULL, 0x0002e8000c1e9500ULL, 0x0000000874867981ULL, 0x0002e2000c1e9500ULL,
0xfffffff060697812ULL, 0x000fe200078ec0ffULL, 0x00000001ffc77424ULL, 0x000fc800078e00ffULL,
0x0000000122607824ULL, 0x000fe200078e0269ULL, 0xfffffff076697812ULL, 0x000fc600078ec0ffULL,
0x0000000151627824ULL, 0x000fe200078e0a60ULL, 0xfffffff06c717812ULL, 0x002fe200078ec0ffULL,
0x00000001226c7824ULL, 0x040fe200078e0269ULL, 0x00000001036f7812ULL, 0x000fe400078efcffULL,
0x00000062c7697219ULL, 0x000fe400000006ffULL, 0x000058006f6b7a10ULL, 0x000fe20007ffe0ffULL,
0x00000001226e7824ULL, 0x000fe200078e0271ULL, 0x0000000803797812ULL, 0x000fc600078efcffULL,
0x000000016b687824ULL, 0x100fe200078e0a60ULL, 0x00000009037b7812ULL, 0x000fe400078efcffULL,
0x0000580079737a10ULL, 0x000fe40007ffe0ffULL, 0x00000068c7717219ULL, 0x000fe400000006ffULL,
0x000058007b7d7a10ULL, 0x000fe20007ffe0ffULL, 0x00000001736a7824ULL, 0x000fe200078e0a60ULL,
0xfffffff078757812ULL, 0x000fc600078ec0ffULL, 0x000000017d607824ULL, 0x000fe200078e0a60ULL,
0x0000001103837812ULL, 0x000fe200078efcffULL, 0x0000000122747824ULL, 0x000fe200078e0275ULL,
0x0000006ac7757219ULL, 0x040fe400000006ffULL, 0x00000060c77f7219ULL, 0x000fe400000006ffULL,
0x0000580083857a10ULL, 0x000fe20007ffe0ffULL, 0x000000015d607824ULL, 0x000fe200078e0a6cULL,
0x0000541050507816ULL, 0x010fc80000000053ULL, 0x0000005069ff7212ULL, 0x000fc800078ac0ffULL,
0x000000225100720cULL, 0x000fc80002fa1470ULL, 0x000000220300720cULL, 0x000fe40002fa1070ULL,
0x0000005071ff7212ULL, 0x000fe4000782c0ffULL, 0xff8000000d0d7808ULL, 0x000fe40002800000ULL,
0x0000541052527816ULL, 0x004fc80000000057ULL, 0x0000005269ff7212ULL, 0x080fe4000784c0ffULL,
0x0000005271ff7212ULL, 0x000fe400078ac0ffULL, 0x0000541054547816ULL, 0x000fc80000000059ULL,
0x0000005469ff7212ULL, 0x000fe4000788c0ffULL, 0x000000225100720cULL, 0x0c0fe40001741470ULL,
0x000000225100720cULL, 0x080fe40002781470ULL, 0x000000226b00720cULL, 0x0c0fe40000f21470ULL,
0x000000226b00720cULL, 0x080fe40002fa1470ULL, 0x000000220300720cULL, 0x000fc40001741070ULL,
0x000000220300720cULL, 0x080fe40002781070ULL, 0x000000226f00720cULL, 0x0c0fe40000f21070ULL,
0x000000226f00720cULL, 0x000fe40002fa1070ULL, 0x0000541055567816ULL, 0x000fe40000000056ULL,
0xff8000001c1c7808ULL, 0x000fe40001000000ULL, 0xff80000031317808ULL, 0x000fc40002000000ULL,
0xff80000004047808ULL, 0x000fe40000800000ULL, 0xff8000001e1e7808ULL, 0x000fe40002800000ULL,
0x0000005075ff7212ULL, 0x000fe4000786c0ffULL, 0x0000005669ff7212ULL, 0x000fe4000780c0ffULL,
0x0000005471ff7212ULL, 0x040fe4000784c0ffULL, 0x0000005671ff7212ULL, 0x000fc4000788c0ffULL,
0x000000527fff7212ULL, 0x000fe4000782c0ffULL, 0x0000005475ff7212ULL, 0x000fe200078ac0ffULL,
0x0000000185627824ULL, 0x000fe200078e0a6cULL, 0x000000225100720cULL, 0x080fe40000701470ULL,
0x000000226b00720cULL, 0x0c0fe40001741470ULL, 0x000000226b00720cULL, 0x080fe40002781470ULL,
0x000000227300720cULL, 0x000fc40001f61470ULL, 0x000000227300720cULL, 0x080fe40002fa1470ULL,
0x000000227d00720cULL, 0x080fe40000f21470ULL, 0x0000001803897812ULL, 0x040fe400078efcffULL,
0x00000019038f7812ULL, 0x040fe400078efcffULL, 0x000000220300720cULL, 0x080fe40000701070ULL,
0x000000226f00720cULL, 0x000fc40001741070ULL, 0x000000226f00720cULL, 0x080fe40002781070ULL,
0x000000227900720cULL, 0x0c0fe40001f61070ULL, 0x000000227900720cULL, 0x080fe40002fa1070ULL,
0x000000227b00720cULL, 0x000fe40000f21070ULL, 0x00000060c7817219ULL, 0x040fe400000006ffULL,
0x00000062c7877219ULL, 0x000fc400000006ffULL, 0x0000541058587816ULL, 0x008fe4000000005fULL,
0x000054105a5a7816ULL, 0x000fe40000000061ULL, 0x00005800898b7a10ULL, 0x000fe40007ffe0ffULL,
0x000058008f917a10ULL, 0x000fe40007ffe0ffULL, 0xff80000044447808ULL, 0x000fe40000000000ULL,
0xff80000030307808ULL, 0x000fc40001000000ULL, 0xff80000048487808ULL, 0x000fe40002000000ULL,
0xff8000000c0c7808ULL, 0x000fe40001800000ULL, 0xff80000032327808ULL, 0x000fe40002800000ULL,
0xff80000021217808ULL, 0x000fe40000800000ULL, 0x0000005275ff7212ULL, 0x000fe4000780c0ffULL,
0x000000547fff7212ULL, 0x000fc4000784c0ffULL, 0x0000005675ff7212ULL, 0x080fe4000788c0ffULL,
0x000000567fff7212ULL, 0x000fe4000786c0ffULL, 0x0000005887ff7212ULL, 0x000fe400078ac0ffULL,
0x0000005a81ff7212ULL, 0x000fe2000782c0ffULL, 0x000000018b687824ULL, 0x100fe200078e0a6cULL,
0x000000227300720cULL, 0x080fe20000701470ULL, 0x00000001916c7824ULL, 0x000fe200078e0a6cULL,
0x000000227300720cULL, 0x000fc40002781470ULL, 0x000000227d00720cULL, 0x0c0fe40001741470ULL,
0x000000227d00720cULL, 0x080fe40001f61470ULL, 0x000000225d00720cULL, 0x080fe40000f21470ULL,
0x000000228500720cULL, 0x080fe40002fa1470ULL, 0x000000227900720cULL, 0x0c0fe40000701070ULL,
0x000000227900720cULL, 0x000fc40002781070ULL, 0x000000227b00720cULL, 0x0c0fe40001741070ULL,
0x000000227b00720cULL, 0x080fe40001f61070ULL, 0x000000225b00720cULL, 0x080fe40000f21070ULL,
0x000000228300720cULL, 0x000fe40002fa1070ULL, 0x00000068c78d7219ULL, 0x040fe400000006ffULL,
0x0000006cc7937219ULL, 0x000fc400000006ffULL, 0x000054105c5c7816ULL, 0x000fe40000000067ULL,
0x000054105e5e7816ULL, 0x000fe4000000006dULL, 0xff8000001f1f7808ULL, 0x000fe40000000000ULL,
0xff80000049497808ULL, 0x000fe40002000000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff8000004b4b7808ULL, 0x000fc40001800000ULL, 0xff80000024247808ULL, 0x000fe40000800000ULL,
0xff80000011117808ULL, 0x000fe40002800000ULL, 0x0000005881ff7212ULL, 0x080fe4000780c0ffULL,
0x000000588dff7212ULL, 0x000fe4000788c0ffULL, 0x0000005c81ff7212ULL, 0x040fe4000784c0ffULL,
0x0000005e81ff7212ULL, 0x000fc4000786c0ffULL, 0x0000005c87ff7212ULL, 0x000fe4000782c0ffULL,
0x0000005a93ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001656a7824ULL, 0x000fe200078e0a6eULL,
0x000000225d00720cULL, 0x0c0fe40000701470ULL, 0x000000225d00720cULL, 0x0c0fe40001741470ULL,
0x000000225d00720cULL, 0x080fe40001f61470ULL, 0x000000228500720cULL, 0x000fc40000f21470ULL,
0x000000228b00720cULL, 0x080fe40002781470ULL, 0x000000229100720cULL, 0x080fe40002fa1470ULL,
0x00000021039d7812ULL, 0x000fe400078efcffULL, 0x000000225b00720cULL, 0x0c0fe40000701070ULL,
0x000000225b00720cULL, 0x0c0fe40001741070ULL, 0x000000225b00720cULL, 0x000fc40001f61070ULL,
0x000000228300720cULL, 0x080fe40000f21070ULL, 0x000000228900720cULL, 0x080fe40002781070ULL,
0x000000228f00720cULL, 0x000fe40002fa1070ULL, 0x0000006ac79b7219ULL, 0x000fe400000006ffULL,
0x0000541066667816ULL, 0x000fe400000000c9ULL, 0x000058009d9f7a10ULL, 0x000fc40007ffe0ffULL,
0xff80000010107808ULL, 0x000fe40000000000ULL, 0xff80000034347808ULL, 0x000fe40001000000ULL,
0xff8000004d4d7808ULL, 0x000fe40001800000ULL, 0xff80000035357808ULL, 0x000fe40000800000ULL,
0xff80000012127808ULL, 0x000fe40002000000ULL, 0xff80000027277808ULL, 0x000fc40002800000ULL,
0x0000005a87ff7212ULL, 0x040fe4000780c0ffULL, 0x0000005e87ff7212ULL, 0x000fe4000784c0ffULL,
0x0000005a8dff7212ULL, 0x000fe4000786c0ffULL, 0x0000005c93ff7212ULL, 0x040fe4000782c0ffULL,
0x0000005e93ff7212ULL, 0x000fe4000788c0ffULL, 0x000000669bff7212ULL, 0x000fe200078ac0ffULL,
0x000000019f707824ULL, 0x000fe200078e0a6eULL, 0x000000228500720cULL, 0x000fc40000701470ULL,
0x000000228500720cULL, 0x080fe40001741470ULL, 0x000000228b00720cULL, 0x080fe40001f61470ULL,
0x000000229100720cULL, 0x0c0fe40000f21470ULL, 0x000000229100720cULL, 0x080fe40002781470ULL,
0x000000226500720cULL, 0x000fe40002fa1470ULL, 0x0000002803a37812ULL, 0x000fc400078efcffULL,
0x0000002903a97812ULL, 0x000fe400078efcffULL, 0x000000228300720cULL, 0x0c0fe40000701070ULL,
0x000000228300720cULL, 0x080fe40001741070ULL, 0x000000228900720cULL, 0x080fe40001f61070ULL,
0x000000228f00720cULL, 0x0c0fe40000f21070ULL, 0x000000228f00720cULL, 0x000fc40002781070ULL,
0x000000226300720cULL, 0x000fe40002fa1070ULL, 0x00000070c7a17219ULL, 0x000fe400000006ffULL,
0x0000541064647816ULL, 0x000fe40000000077ULL, 0x00005410cd807816ULL, 0x000fe40000000080ULL,
0x00005410d1847816ULL, 0x000fe40000000084ULL, 0x00005800a3a57a10ULL, 0x000fc40007ffe0ffULL,
0x00005800a9ab7a10ULL, 0x000fe40007ffe0ffULL, 0xff80000025257808ULL, 0x000fe40000000000ULL,
0xff8000004e4e7808ULL, 0x000fe40001000000ULL, 0xff80000026267808ULL, 0x000fe40001800000ULL,
0xff80000037377808ULL, 0x000fe40000800000ULL, 0xff8000004c4c7808ULL, 0x000fc40002000000ULL,
0xff80000028287808ULL, 0x000fe40002800000ULL, 0x000000507fff7212ULL, 0x000fe400078cc0ffULL,
0x0000005c8dff7212ULL, 0x040fe4000780c0ffULL, 0x0000005e8dff7212ULL, 0x000fe4000784c0ffULL,
0x000000649bff7212ULL, 0x040fe4000786c0ffULL, 0x000000809bff7212ULL, 0x000fc4000782c0ffULL,
0x000000849bff7212ULL, 0x000fe4000788c0ffULL, 0x00000080a1ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a5727824ULL, 0x100fe200078e0a6eULL, 0x000000227d00720cULL, 0x080fe200037c1470ULL,
0x00000001ab6e7824ULL, 0x000fe200078e0a6eULL, 0x000000228b00720cULL, 0x0c0fe40000701470ULL,
0x000000228b00720cULL, 0x080fe40001741470ULL, 0x000000226500720cULL, 0x000fc40001f61470ULL,
0x000000226500720cULL, 0x0c0fe40000f21470ULL, 0x000000226500720cULL, 0x080fe40002781470ULL,
0x000000229f00720cULL, 0x080fe40002fa1470ULL, 0x000000227b00720cULL, 0x080fe400037c1070ULL,
0x000000228900720cULL, 0x0c0fe40000701070ULL, 0x000000228900720cULL, 0x000fc40001741070ULL,
0x000000226300720cULL, 0x0c0fe40001f61070ULL, 0x000000226300720cULL, 0x0c0fe40000f21070ULL,
0x000000226300720cULL, 0x080fe40002781070ULL, 0x000000229d00720cULL, 0x000fe40002fa1070ULL,
0x00000072c7a77219ULL, 0x040fe400000006ffULL, 0x0000006ec7ad7219ULL, 0x000fc400000006ffULL,
0xff8000000e0e7808ULL, 0x000fe40003000000ULL, 0xff80000036367808ULL, 0x000fe40000000000ULL,
0xff8000004f4f7808ULL, 0x000fe40001000000ULL, 0xff8000001a1a7808ULL, 0x000fe40001800000ULL,
0xff80000038387808ULL, 0x000fe40000800000ULL, 0xff8000004a4a7808ULL, 0x000fc40002000000ULL,
0xff80000039397808ULL, 0x000fe40002800000ULL, 0x0000005893ff7212ULL, 0x000fe400078cc0ffULL,
0x00000064a1ff7212ULL, 0x080fe4000780c0ffULL, 0x00000064a7ff7212ULL, 0x000fe4000784c0ffULL,
0x00000066a1ff7212ULL, 0x040fe4000786c0ffULL, 0x00000084a1ff7212ULL, 0x000fc4000782c0ffULL,
0x00000066a7ff7212ULL, 0x000fe4000788c0ffULL, 0x00000080adff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b1767824ULL, 0x000fe200078e0a74ULL, 0x000000229100720cULL, 0x080fe400037c1470ULL,
0x000000229f00720cULL, 0x0c0fe40000701470ULL, 0x000000229f00720cULL, 0x0c0fe40001f61470ULL,
0x000000229f00720cULL, 0x000fc40000f21470ULL, 0x00000022a500720cULL, 0x0c0fe40001741470ULL,
0x00000022a500720cULL, 0x080fe40002781470ULL, 0x00000022ab00720cULL, 0x000fe40002fa1470ULL,
0x0000003103b77812ULL, 0x040fe400078efcffULL, 0x0000003803bd7812ULL, 0x040fe400078efcffULL,
0x0000003903c37812ULL, 0x000fc400078efcffULL, 0x000000228f00720cULL, 0x080fe400037c1070ULL,
0x000000229d00720cULL, 0x0c0fe40000701070ULL, 0x000000229d00720cULL, 0x0c0fe40001f61070ULL,
0x000000229d00720cULL, 0x080fe40000f21070ULL, 0x00000022a300720cULL, 0x0c0fe40001741070ULL,
0x00000022a300720cULL, 0x000fc40002781070ULL, 0x00000022a900720cULL, 0x000fe40002fa1070ULL,
0x00000076c7b57219ULL, 0x000fe400000006ffULL, 0x00005410b37c7816ULL, 0x000fe4000000007cULL,
0x00005410cf827816ULL, 0x000fe40000000082ULL, 0x00005800b7b97a10ULL, 0x000fe40007ffe0ffULL,
0x00005800bdbf7a10ULL, 0x000fc40007ffe0ffULL, 0x00005800c3c57a10ULL, 0x000fe40007ffe0ffULL,
0xff80000013137808ULL, 0x000fe40003000000ULL, 0xff80000015157808ULL, 0x000fe40000000000ULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff8000003b3b7808ULL, 0x000fe40000800000ULL,
0xff80000019197808ULL, 0x000fc40001000000ULL, 0xff8000002a2a7808ULL, 0x000fe40002000000ULL,
0xff8000003c3c7808ULL, 0x000fe40002800000ULL, 0x00000064adff7212ULL, 0x040fe400078cc0ffULL,
0x00000066adff7212ULL, 0x000fe4000780c0ffULL, 0x00000080a7ff7212ULL, 0x040fe4000786c0ffULL,
0x00000084a7ff7212ULL, 0x000fc4000782c0ffULL, 0x00000084adff7212ULL, 0x000fe4000784c0ffULL,
0x0000007cb5ff7212ULL, 0x040fe4000788c0ffULL, 0x00000082b5ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b9787824ULL, 0x100fe200078e0a74ULL, 0x00000022a500720cULL, 0x080fe20001f61470ULL,
0x00000001bf7a7824ULL, 0x100fe200078e0a74ULL, 0x00000022a500720cULL, 0x080fe20000f21470ULL,
0x00000001c5747824ULL, 0x000fe200078e0a74ULL, 0x00000022ab00720cULL, 0x000fc400037c1470ULL,
0x00000022ab00720cULL, 0x0c0fe40000701470ULL, 0x00000022ab00720cULL, 0x080fe40001741470ULL,
0x00000022b100720cULL, 0x0c0fe40002781470ULL, 0x00000022b100720cULL, 0x000fe40002fa1470ULL,
0x00000078c7bb7219ULL, 0x040fe400000006ffULL, 0x0000007ac7c17219ULL, 0x000fc400000006ffULL,
0x00000022a300720cULL, 0x0c0fe40001f61070ULL, 0x00000022a300720cULL, 0x080fe40000f21070ULL,
0x00000022a900720cULL, 0x0c0fe400037c1070ULL, 0x00000022a900720cULL, 0x0c0fe40000701070ULL,
0x00000022a900720cULL, 0x080fe40001741070ULL, 0x00000022af00720cULL, 0x000fc40002781070ULL,
0x00000022af00720cULL, 0x000fe40002fa1070ULL, 0x00000074c7c77219ULL, 0x000fe400000006ffULL,
0x00005410cb7e7816ULL, 0x000fe4000000007eULL, 0xff8000003a3a7808ULL, 0x000fe40001800000ULL,
0xff8000003d3d7808ULL, 0x000fe40000800000ULL, 0xff80000016167808ULL, 0x000fc40003000000ULL,
0xff8000002b2b7808ULL, 0x000fe40000000000ULL, 0xff8000003e3e7808ULL, 0x000fe40001000000ULL,
0xff80000017177808ULL, 0x000fe40002000000ULL, 0xff8000003f3f7808ULL, 0x000fe40002800000ULL,
0x0000007cbbff7212ULL, 0x080fe4000786c0ffULL, 0x0000007cc1ff7212ULL, 0x000fc4000782c0ffULL,
0x0000007cc7ff7212ULL, 0x000fe400078cc0ffULL, 0x0000007eb5ff7212ULL, 0x080fe4000780c0ffULL,
0x0000007ebbff7212ULL, 0x080fe4000784c0ffULL, 0x0000007ec1ff7212ULL, 0x000fe4000788c0ffULL,
0x00000082bbff7212ULL, 0x000fe400078ac0ffULL, 0x00000022b100720cULL, 0x000fc40000701470ULL,
0x00000022b900720cULL, 0x0c0fe40001f61470ULL, 0x00000022b900720cULL, 0x0c0fe40001741470ULL,
0x00000022b900720cULL, 0x080fe40002fa1470ULL, 0x00000022bf00720cULL, 0x080fe40000f21470ULL,
0x00000022c500720cULL, 0x080fe400037c1470ULL, 0x00000022bf00720cULL, 0x000fc40002781470ULL,
0x00000022af00720cULL, 0x080fe40000701070ULL, 0x00000022b700720cULL, 0x0c0fe40001f61070ULL,
0x00000022b700720cULL, 0x0c0fe40001741070ULL, 0x00000022b700720cULL, 0x080fe40002fa1070ULL,
0x00000022bd00720cULL, 0x080fe40000f21070ULL, 0x00000022c300720cULL, 0x000fc400037c1070ULL,
0x00000022bd00720cULL, 0x000fe40002781070ULL, 0x00005410d3867816ULL, 0x000fe40000000086ULL,
0xff8000002c2c7808ULL, 0x000fe40000000000ULL, 0xff80000014147808ULL, 0x000fe40001800000ULL,
0xff8000002d2d7808ULL, 0x000fe40001000000ULL, 0xff80000040407808ULL, 0x000fc40002800000ULL,
0xff8000001d1d7808ULL, 0x000fe40000800000ULL, 0xff8000001b1b7808ULL, 0x000fe40003000000ULL,
0xff8000002e2e7808ULL, 0x000fe40002000000ULL, 0x0000007ec7ff7212ULL, 0x000fe4000780c0ffULL,
0x00000082c1ff7212ULL, 0x080fe4000786c0ffULL, 0x00000082c7ff7212ULL, 0x000fc4000784c0ffULL,
0x00000086b5ff7212ULL, 0x080fe400078ac0ffULL, 0x00000086bbff7212ULL, 0x080fe4000782c0ffULL,
0x00000086c1ff7212ULL, 0x080fe400078cc0ffULL, 0x00000086c7ff7212ULL, 0x000fe4000788c0ffULL,
0x00000022b100720cULL, 0x080fe40002fa1470ULL, 0x00000022b900720cULL, 0x000fc40000f21470ULL,
0x00000022bf00720cULL, 0x0c0fe40001f61470ULL, 0x00000022bf00720cULL, 0x080fe400037c1470ULL,
0x00000022c500720cULL, 0x0c0fe40000701470ULL, 0x00000022c500720cULL, 0x0c0fe40001741470ULL,
0x00000022c500720cULL, 0x080fe40002781470ULL, 0x00000022af00720cULL, 0x000fc40002fa1070ULL,
0x00000022b700720cULL, 0x080fe40000f21070ULL, 0x00000022c300720cULL, 0x080fe40000701070ULL,
0x00000022bd00720cULL, 0x0c0fe40001f61070ULL, 0x00000022bd00720cULL, 0x080fe400037c1070ULL,
0x00000022c300720cULL, 0x0c0fe40001741070ULL, 0x00000022c300720cULL, 0x000fc40002781070ULL,
0xff8000002f2f7808ULL, 0x000fe40000000000ULL, 0xff80000042427808ULL, 0x000fe40001800000ULL,
0xff80000045457808ULL, 0x000fe40001000000ULL, 0xff80000041417808ULL, 0x000fe40002800000ULL,
0xff80000043437808ULL, 0x000fe40000800000ULL, 0xff80000046467808ULL, 0x000fc40003000000ULL,
0xff80000047477808ULL, 0x000fc40002000000ULL, 0x0000000d0800720bULL, 0x004fe20003f1e000ULL,
0x0000001fff577424ULL, 0x000fe200078e00ffULL, 0x0000001c0900720bULL, 0x000fe20003f3e000ULL,
0xffffffffff587424ULL, 0x000fe200078e00ffULL, 0x000000310a00720bULL, 0x000fe40003f5e000ULL,
0x000000440b00720bULL, 0x000fe40003f7e000ULL, 0x000000080d037208ULL, 0x000fe40004000000ULL,
0x000000091c097208ULL, 0x000fc40004800000ULL, 0x0000000a31517208ULL, 0x000fe40005000000ULL,
0x0000000b440b7208ULL, 0x000fe40005800000ULL, 0x000000040300720bULL, 0x000fe40003f1e000ULL,
0x0000001e0900720bULL, 0x000fe40003f3e000ULL, 0x000000305100720bULL, 0x000fe40003f5e000ULL,
0x000000480b00720bULL, 0x000fc40003f7e000ULL, 0x0000000304037208ULL, 0x000fe40004000000ULL,
0x000000091e087208ULL, 0x000fe40004800000ULL, 0x0000005130517208ULL, 0x000fe40005000000ULL,
0x0000000b480a7208ULL, 0x000fe40005800000ULL, 0x0000000c0300720bULL, 0x000fe40003f1e000ULL,
0x0000001f0800720bULL, 0x000fc40003f3e000ULL, 0x000000325100720bULL, 0x000fe40003f5e000ULL,
0x000000490a00720bULL, 0x000fe40003f7e000ULL, 0x000000030c037208ULL, 0x000fe40004000000ULL,
0x000000081f087208ULL, 0x000fe40004800000ULL, 0x0000005132227208ULL, 0x000fe40005000000ULL,
0x0000000a490a7208ULL, 0x000fc40005800000ULL, 0x0000000e0300720bULL, 0x000fe40003f1e000ULL,
0x000000210800720bULL, 0x000fe40003f3e000ULL, 0x000000332200720bULL, 0x000fe40003f5e000ULL,
0x0000004b0a00720bULL, 0x000fe40003f7e000ULL, 0x000000030e037208ULL, 0x000fe40004000000ULL,
0x0000000821097208ULL, 0x000fc40004800000ULL, 0x00000022330b7208ULL, 0x000fe40005000000ULL,
0x0000000a4b0a7208ULL, 0x000fe40005800000ULL, 0x000000100300720bULL, 0x000fe40003f1e000ULL,
0x000000240900720bULL, 0x000fe40003f3e000ULL, 0x000000340b00720bULL, 0x000fe40003f5e000ULL,
0x0000004d0a00720bULL, 0x000fc40003f7e000ULL, 0x0000000310087208ULL, 0x000fe40004000000ULL,
0x0000000924227208ULL, 0x000fe40004800000ULL, 0x0000000b34507208ULL, 0x000fe40005000000ULL,
0x0000000a4d037208ULL, 0x000fe40005800000ULL, 0x000000110800720bULL, 0x000fe40003f1e000ULL,
0x000000252200720bULL, 0x000fc40003f3e000ULL, 0x000000355000720bULL, 0x000fe40003f5e000ULL,
0x0000004e0300720bULL, 0x000fe40003f7e000ULL, 0x0000000811097208ULL, 0x000fe40004000000ULL,
0x00000022250b7208ULL, 0x000fe40004800000ULL, 0x0000005035517208ULL, 0x000fe40005000000ULL,
0x000000034e087208ULL, 0x000fc40005800000ULL, 0x000000120900720bULL, 0x000fe40003f1e000ULL,
0x000000260b00720bULL, 0x000fe40003f3e000ULL, 0x000000365100720bULL, 0x000fe40003f5e000ULL,
0x0000004f0800720bULL, 0x000fe40003f7e000ULL, 0x00000009120a7208ULL, 0x000fe40004000000ULL,
0x0000000b26227208ULL, 0x000fc40004800000ULL, 0x0000005136507208ULL, 0x000fe40005000000ULL,
0x000000084f037208ULL, 0x000fe40005800000ULL, 0x000000130a00720bULL, 0x000fe40003f1e000ULL,
0x000000272200720bULL, 0x000fe40003f3e000ULL, 0x000000375000720bULL, 0x000fe40003f5e000ULL,
0x0000004c0300720bULL, 0x000fc40003f7e000ULL, 0x0000000a13097208ULL, 0x000fe40004000000ULL,
0x00000022270b7208ULL, 0x000fe40004800000ULL, 0x0000005037517208ULL, 0x000fe40005000000ULL,
0x000000034c037208ULL, 0x000fe40005800000ULL, 0x0000001a0900720bULL, 0x000fe40003f1e000ULL,
0x000000280b00720bULL, 0x000fc40003f3e000ULL, 0x000000385100720bULL, 0x000fe40003f5e000ULL,
0x0000004a0300720bULL, 0x000fe40003f7e000ULL, 0x000000091a087208ULL, 0x000fe40004000000ULL,
0x0000000b280a7208ULL, 0x000fe40004800000ULL, 0x0000005138227208ULL, 0x000fe40005000000ULL,
0x000000034a507208ULL, 0x000fc40005800000ULL, 0x000000150800720bULL, 0x000fe40003f1e000ULL,
0x000000290a00720bULL, 0x000fe40003f3e000ULL, 0x000000392200720bULL, 0x000fe40003f5e000ULL,
0x0000003b5000720bULL, 0x000fe40003f7e000ULL, 0x0000000815087208ULL, 0x000fe40004000000ULL,
0x0000000a29037208ULL, 0x000fc40004800000ULL, 0x0000002239097208ULL, 0x000fe40005000000ULL,
0x000000503b507208ULL, 0x000fe40005800000ULL, 0x000000190800720bULL, 0x000fe40003f1e000ULL,
0x0000002a0300720bULL, 0x000fe40003f3e000ULL, 0x0000003a0900720bULL, 0x000fe40003f5e000ULL,
0x0000003d5000720bULL, 0x000fc40003f7e000ULL, 0x00000008190b7208ULL, 0x000fe40004000000ULL,
0x000000032a087208ULL, 0x000fe40004800000ULL, 0x000000093a097208ULL, 0x000fe40005000000ULL,
0x000000503d037208ULL, 0x000fe40005800000ULL, 0x000000160b00720bULL, 0x000fe40003f1e000ULL,
0x0000002b0800720bULL, 0x000fc40003f3e000ULL, 0x0000003c0900720bULL, 0x000fe40003f5e000ULL,
0x0000003e0300720bULL, 0x000fe40003f7e000ULL, 0x0000000b160a7208ULL, 0x000fe40004000000ULL,
0x000000082b0b7208ULL, 0x000fe40004800000ULL, 0x000000093c087208ULL, 0x000fe40005000000ULL,
0x000000033e227208ULL, 0x000fc40005800000ULL, 0x000000170a00720bULL, 0x000fe40003f1e000ULL,
0x0000002c0b00720bULL, 0x000fe40003f3e000ULL, 0x0000003f0800720bULL, 0x000fe40003f5e000ULL,
0x000000412200720bULL, 0x000fe40003f7e000ULL, 0x0000000a17037208ULL, 0x000fe40004000000ULL,
0x0000000b2c0a7208ULL, 0x000fc40004800000ULL, 0x000000083f097208ULL, 0x000fe40005000000ULL,
0x0000002241227208ULL, 0x000fe40005800000ULL, 0x000000140300720bULL, 0x000fe40003f1e000ULL,
0x0000002d0a00720bULL, 0x000fe40003f3e000ULL, 0x000000400900720bULL, 0x000fe40003f5e000ULL,
0x000000432200720bULL, 0x000fc40003f7e000ULL, 0x0000000314087208ULL, 0x000fe40004000000ULL,
0x0000000a2d037208ULL, 0x000fe40004800000ULL, 0x0000000940097208ULL, 0x000fe40005000000ULL,
0x00000022430b7208ULL, 0x000fe40005800000ULL, 0x0000001d0800720bULL, 0x000fe40003f1e000ULL,
0x0000002e0300720bULL, 0x000fc40003f3e000ULL, 0x000000420900720bULL, 0x000fe40003f5e000ULL,
0x000000460b00720bULL, 0x000fe40003f7e000ULL, 0x000000081d087208ULL, 0x000fe40004000000ULL,
0x000000032e0a7208ULL, 0x000fe40004800000ULL, 0x0000000942227208ULL, 0x000fe40005000000ULL,
0x0000000b46507208ULL, 0x000fc40005800000ULL, 0x0000001b0800720bULL, 0x000fe40003f1e000ULL,
0x0000002f0a00720bULL, 0x000fe40003f3e000ULL, 0x000000452200720bULL, 0x000fe40003f5e000ULL,
0x000000475000720bULL, 0x000fe40003f7e000ULL, 0x000000081b0b7208ULL, 0x000fe40004000000ULL,
0x0000000a2f527208ULL, 0x000fc40004800000ULL, 0x0000002245537208ULL, 0x000fe40005000000ULL,
0x0000005047547208ULL, 0x000fe20005800000ULL, 0x00001fe27f007947ULL, 0x000fea000b800000ULL,
0x0c401f000b037f89ULL, 0x0004e400000e0000ULL, 0x000000030b00720bULL, 0x00cfc80003f1e000ULL,
0x0000000b03557208ULL, 0x000fe20004000000ULL, 0x00001fe27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0052037f89ULL, 0x000ea800000e0000ULL, 0x0c401f0053087f89ULL, 0x000ee800000e0000ULL,
0x0c401f0054097f89ULL, 0x000f2200000e0000ULL, 0x000000035200720bULL, 0x004fc40003f1e000ULL,
0x000000085300720bULL, 0x008fe40003f3e000ULL, 0x0000005203037208ULL, 0x000fe40004000000ULL,
0x00000053080b7208ULL, 0x002fe40004800000ULL, 0x000000095400720bULL, 0x010fe20003f1e000ULL,
0x0c201f00030a7f89ULL, 0x000e6600000e0000ULL, 0x0000005409527208ULL, 0x000fe20004000000ULL,
0x0c201f0055087f89ULL, 0x000ea800000e0000ULL, 0x0c201f000b227f89ULL, 0x000ee800000e0000ULL,
0x0c201f0052517f89ULL, 0x0002e400000e0000ULL, 0x0000000a0300720bULL, 0x002fc40003f3e000ULL,
0x000000085500720bULL, 0x004fe40003f1e000ULL, 0x000000030a097208ULL, 0x000fe40004800000ULL,
0x000000220b00720bULL, 0x008fe40003f5e000ULL, 0x0000005508087208ULL, 0x000fe40004000000ULL,
0x0000000b220a7208ULL, 0x000fc60005000000ULL, 0x3fb8aa3b080b7820ULL, 0x002fe20000410000ULL,
0x000000515200720bULL, 0x000fe20003f1e000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x3fb8aa3b04047823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b1a037823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe2000001080bULL,
0x0000000400507308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b10107823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b11117823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b12127823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b19197823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b161a7823ULL, 0x100fe2000001080bULL,
0x0000000e00537308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b17227823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b1d047823ULL, 0x102fe2000001080bULL,
0x3fb8aa3b1b1b7823ULL, 0x000fc8000001080bULL, 0x0000001300577308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b150e7823ULL, 0x004fe2000001080bULL, 0x3fb8aa3b090b7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b0a157820ULL, 0x000fc60000410000ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b24247823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b25257823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080bULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080bULL,
0x3fb8aa3b2f0b7823ULL, 0x000fe2000001080bULL, 0x0000002400587308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b31317823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b34347823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010815ULL, 0x0000000b00627308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b37377823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b38387823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe20000010815ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010815ULL, 0x0000001400597308ULL, 0x000fe20000000800ULL,
0x00000052510b7208ULL, 0x002fe20004000000ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010815ULL,
0x3fb8aa3b45157823ULL, 0x000fe20000010815ULL, 0x0000000399ff7812ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b0b247820ULL, 0x000fe40000410000ULL, 0x0000003200167308ULL, 0x0003e40000000800ULL,
0x3fb8aa3b44447823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b49497823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b48487823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010824ULL,
0x0000001f00137308ULL, 0x0005e20000000800ULL, 0x00000002ff327819ULL, 0x002fe20000011699ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010824ULL,
0x0000000832647824ULL, 0x040fe200078e00ffULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010824ULL,
0x0000002100147308ULL, 0x000e620000000800ULL, 0x00000008321d7824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010824ULL, 0x00000008321f7824ULL, 0x044fe200078e00ffULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010824ULL, 0x00000008326a7824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b43437823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010824ULL,
0x0000000d000d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b47477823ULL, 0x000fce0000010824ULL,
0x0000000c000c7308ULL, 0x000fe20000000800ULL, 0x000000131413723eULL, 0x002fe400000000ffULL,
0xffffffff32147810ULL, 0x000fca0007ffe0ffULL, 0x0000001100557308ULL, 0x000ff00000000800ULL,
0x0000001500457308ULL, 0x0003f00000000800ULL, 0x0000001c00117308ULL, 0x000fe20000000800ULL,
0x0000000332157810ULL, 0x002fc80007ffe0ffULL, 0xfffffff864647812ULL, 0x000fe400078ee215ULL,
0x0000000632157810ULL, 0x000fe20007ffe0ffULL, 0x0000001e001e7308ULL, 0x000e660000000800ULL,
0xfffffff86a6a7812ULL, 0x000fe200078ee215ULL, 0x0000000832157824ULL, 0x000fc800078e00ffULL,
0x00000026005a7308ULL, 0x000ff00000000800ULL, 0x0000004400447308ULL, 0x000fe20000000800ULL,
0x000000111e11723eULL, 0x002fce00000000ffULL, 0x0000004800177308ULL, 0x000ff00000000800ULL,
0x0000003100317308ULL, 0x000ff00000000800ULL, 0x0000003000307308ULL, 0x000ff00000000800ULL,
0x0000003300337308ULL, 0x000e700000000800ULL, 0x0000004900497308ULL, 0x000ff00000000800ULL,
0x0000004b00267308ULL, 0x000ea20000000800ULL, 0x000000163316723eULL, 0x002fe200000000ffULL,
0x0000000832337824ULL, 0x000fcc00078e00ffULL, 0x0000001000547308ULL, 0x0002f00000000800ULL,
0x0000001200567308ULL, 0x0008a20000000800ULL, 0x0000000132107810ULL, 0x002fc80007ffe0ffULL,
0xfffffff81d487812ULL, 0x040fe400078ee210ULL, 0x0000000432107810ULL, 0x040fe20007ffe0ffULL,
0x00000028005b7308ULL, 0x000fe20000000800ULL, 0x0000000232127810ULL, 0x050fe40007ffe0ffULL,
0xfffffff81d667812ULL, 0x000fe400078ee210ULL, 0xfffffff81f527812ULL, 0x040fe400078ee212ULL,
0x0000000532127810ULL, 0x000fe20007ffe0ffULL, 0x00000029005c7308ULL, 0x000fe20000000800ULL,
0x0000000d5010723eULL, 0x000fe200000000ffULL, 0x3c003c00ff0d7424ULL, 0x000fe200078e00ffULL,
0xfffffff81f687812ULL, 0x000fc400078ee212ULL, 0x0000000c5312723eULL, 0x000fe200000000ffULL,
0x3c003c00ff0c7424ULL, 0x000fe200078e00ffULL, 0xfffffff815507812ULL, 0x000fe200078ee214ULL,
0x0000002a00217308ULL, 0x000fe20000000800ULL, 0x000000441715723eULL, 0x000fe400000000ffULL,
0x000000313014723eULL, 0x000fe400000000ffULL, 0x000000492617723eULL, 0x004fe200000000ffULL,
0x0000000c101c723cULL, 0x000f6200000018ffULL, 0x000000545524723eULL, 0x008fe200000000ffULL,
0x0000002b005e7308ULL, 0x0003e20000000800ULL, 0x000000565726723eULL, 0x000fc400000000ffULL,
0x0000000832307810ULL, 0x040fe40007ffe0ffULL, 0x0000001032317810ULL, 0x000fe40007ffe0ffULL,
0x0000000c20497812ULL, 0x000fe200078ec0ffULL, 0x0000002500257308ULL, 0x000ea20000000800ULL,
0x0000000c1428723cULL, 0x002f6e00000018ffULL, 0x0000002700277308ULL, 0x000e700000000800ULL,
0x0000002c005d7308ULL, 0x000fe20000000800ULL, 0x000000582525723eULL, 0x004fce00000000ffULL,
0x0000002d00607308ULL, 0x000fe20000000800ULL, 0x0000005a2727723eULL, 0x002fce00000000ffULL,
0x0000002e005f7308ULL, 0x000fe20000000800ULL, 0x0000000c241c723cULL, 0x020f6e000000181cULL,
0x00000034002c7308ULL, 0x000ff00000000800ULL, 0x0000003500357308ULL, 0x000e700000000800ULL,
0x00000036002e7308ULL, 0x000ff00000000800ULL, 0x0000003700377308ULL, 0x000ea20000000800ULL,
0x0000002c352c723eULL, 0x002fce00000000ffULL, 0x0000004d002d7308ULL, 0x000ff00000000800ULL,
0x0000004e004e7308ULL, 0x000e620000000800ULL, 0x0000002e372e723eULL, 0x004fe400000000ffULL,
0x0000005f6237723eULL, 0x000fca00000000ffULL, 0x0000004f002f7308ULL, 0x000ff00000000800ULL,
0x0000004c004c7308ULL, 0x000ea20000000800ULL, 0x0000002d4e2d723eULL, 0x002fce00000000ffULL,
0x0000003800387308ULL, 0x000fe20000000800ULL, 0x0000002f4c2f723eULL, 0x004fce00000000ffULL,
0x0000003900397308ULL, 0x000e620000000800ULL, 0x00000008314c7824ULL, 0x000fe200078e00ffULL,
0x0000000c2c28723cULL, 0x000f680000001828ULL, 0xfffffff84c4c7812ULL, 0x000fe400078ee231ULL,
0x0000000300037308ULL, 0x000fe20000000800ULL, 0x0000005b5c31723eULL, 0x000fce00000000ffULL,
0x0000000e000e7308ULL, 0x000fe20000000800ULL, 0x000000383938723eULL, 0x002fce00000000ffULL,
0x0000001900197308ULL, 0x000ff00000000800ULL, 0x0000001a001a7308ULL, 0x000ff00000000800ULL,
0x0000004a004a7308ULL, 0x000ff00000000800ULL, 0x0000003b003b7308ULL, 0x000e700000000800ULL,
0x0000003a003a7308ULL, 0x000ff00000000800ULL, 0x0000003c00617308ULL, 0x0004e20000000800ULL,
0x0000004a3b39723eULL, 0x002fce00000000ffULL, 0x0000003d003d7308ULL, 0x000fe20000000800ULL,
0xfffffff8333c7812ULL, 0x004fe200078ee232ULL, 0x0000000830337824ULL, 0x000fe200078e00ffULL,
0x0000001832327810ULL, 0x000fc80007ffe0ffULL, 0xfffffff833447812ULL, 0x000fe200078ee230ULL,
0x0000003e003e7308ULL, 0x000e620000000800ULL, 0x0000000832357824ULL, 0x000fe200078e00ffULL,
0x000000030e30723eULL, 0x000fe400000000ffULL, 0x000000215e33723eULL, 0x000fe400000000ffULL,
0xfffffff8354e7812ULL, 0x000fe400078ee232ULL, 0x000000191a32723eULL, 0x000fe200000000ffULL,
0x0000000400047308ULL, 0x000fe20000000800ULL, 0x0000003a613a723eULL, 0x008fc400000000ffULL,
0x0000a00000037811ULL, 0x000fe400078e60ffULL, 0x0000005d6035723eULL, 0x000fe200000000ffULL,
0x0000000c301c723cULL, 0x0a0f62000000181cULL, 0x0000003d3e3b723eULL, 0x002fe200000000ffULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x00000010481a7824ULL, 0x100fe400078e0203ULL,
0x0000001064207824ULL, 0x100fe400078e0203ULL, 0x0000001066217824ULL, 0x000fe200078e0203ULL,
0x0000000c3828723cULL, 0x000fe20000001828ULL, 0x00000001491a7824ULL, 0x040fe200078e021aULL,
0x0000002200227308ULL, 0x000ea20000000800ULL, 0x0000000149207824ULL, 0x000fc400078e0220ULL,
0x00000010443d7824ULL, 0x000fe400078e0203ULL, 0x0000000149217824ULL, 0x000fe400078e0221ULL,
0x000000104c3e7824ULL, 0x100fe200078e0203ULL, 0x0000003f003f7308ULL, 0x000fe20000000800ULL,
0x000000041b36723eULL, 0x002fe200000000ffULL, 0x000000103c047824ULL, 0x100fe400078e0203ULL,
0x00000010521b7824ULL, 0x000fe400078e0203ULL, 0x0000000149197824ULL, 0x000fc400078e0204ULL,
0x0000004000407308ULL, 0x000e620000000800ULL, 0x000000225934723eULL, 0x004fe200000000ffULL,
0x0000001068227824ULL, 0x100fe200078e0203ULL, 0x0000001019007388ULL, 0x0005e20000000800ULL,
0x000000106a3c7824ULL, 0x000fe400078e0203ULL, 0x00000001491b7824ULL, 0x040fe200078e021bULL,
0x000000121a007388ULL, 0x0005e20000000800ULL, 0x0000004200427308ULL, 0x000ee20000000800ULL,
0x0000001050047824ULL, 0x000fe200078e0203ULL, 0x0000000c341c723cULL, 0x020f62000000181cULL,
0x0000000149227824ULL, 0x040fe200078e0222ULL, 0x000000241b007388ULL, 0x0005e20000000800ULL,
0x00000001493c7824ULL, 0x000fc400078e023cULL, 0x0000000149047824ULL, 0x040fe200078e0204ULL,
0x0000004100417308ULL, 0x000fe20000000800ULL, 0x0000003f4040723eULL, 0x002fe200000000ffULL,
0x0000002620007388ULL, 0x0005e20000000800ULL, 0x000000104e447824ULL, 0x000fe400078e0203ULL,
0x0000000149037824ULL, 0x040fe200078e023eULL, 0x0000003021007388ULL, 0x0005e20000000800ULL,
0x0000000149447824ULL, 0x000fe200078e0244ULL, 0x00000043000e7308ULL, 0x000e620000000800ULL,
0x000000424542723eULL, 0x008fe200000000ffULL, 0x0000003222007388ULL, 0x0005e80000000800ULL,
0x000000343c007388ULL, 0x0005e40000000800ULL, 0x0000004600467308ULL, 0x000fe40000000800ULL,
0x0000003604007388ULL, 0x0005e20000000800ULL, 0x000000ffff1d7224ULL, 0x020fca00078e001eULL,
0x0000004700477308ULL, 0x000ee20000000800ULL, 0x000000410e41723eULL, 0x002fe200000000ffULL,
0x00000001490e7824ULL, 0x000fca00078e023dULL, 0x000000110e007388ULL, 0x0005e80000000800ULL,
0x000400131a007388ULL, 0x0005e80000000800ULL, 0x000400251b007388ULL, 0x0005e20000000800ULL,
0x000000464743723eULL, 0x008fc600000000ffULL, 0x0004002720007388ULL, 0x0005e80000000800ULL,
0x0000000c4028723cULL, 0x000f620000001828ULL, 0x0004003121007388ULL, 0x0005e80000000800ULL,
0x0004003322007388ULL, 0x0005e80000000800ULL, 0x000400353c007388ULL, 0x0005e80000000800ULL,
0x0004003704007388ULL, 0x0005e80000000800ULL, 0x0000001403007388ULL, 0x0005e80000000800ULL,
0x000800161a007388ULL, 0x0005e60000000800ULL, 0x000000ffff1e7224ULL, 0x020fe200078e0028ULL,
0x0008002c1b007388ULL, 0x0005e20000000800ULL, 0x000000ffff1f7224ULL, 0x000fc600078e002aULL,
0x0008002e20007388ULL, 0x0005e80000000800ULL, 0x0008003821007388ULL, 0x0005e80000000800ULL,
0x0008003a22007388ULL, 0x0005e80000000800ULL, 0x000800403c007388ULL, 0x0005e80000000800ULL,
0x0008004204007388ULL, 0x0005e80000000800ULL, 0x0000001544007388ULL, 0x0005e80000000800ULL,
0x000c00171a007388ULL, 0x0005e80000000800ULL, 0x000c002d1b007388ULL, 0x0005e80000000800ULL,
0x000c002f20007388ULL, 0x0005e80000000800ULL, 0x000c003921007388ULL, 0x0005e80000000800ULL,
0x000c003b22007388ULL, 0x0005e80000000800ULL, 0x000c00413c007388ULL, 0x0005e80000000800ULL,
0x000c004304007388ULL, 0x0005e80000000800ULL, 0x0160000818008388ULL, 0x0005e80000000c00ULL,
0x0162001c18008388ULL, 0x0005e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0166080097ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0166100097ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0166180097ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000060f00720cULL, 0x000fe20003f06070ULL, 0x0166200097ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff037224ULL, 0x004fd600078e000fULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff7bf000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff287807ULL, 0x004fe40004000000ULL, 0x00017ff000297802ULL, 0x000fc40000000f00ULL,
0x0000107000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff127224ULL, 0x000fe200078e0028ULL,
0xfffeab6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe40005000000ULL,
0x0001804000297802ULL, 0x000fc40000000f00ULL, 0x0000102000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0028ULL, 0xfffeabd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0016ULL, 0x0001809000287802ULL, 0x000fc40000000f00ULL,
0x00000f8000007944ULL, 0x008fea0003c00000ULL, 0xfffeaca000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0016ULL, 0x000180d000287802ULL, 0x000fc40000000f00ULL,
0x00000f4000007944ULL, 0x00afea0003c00000ULL, 0xfffeadd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0016ULL, 0x0001811000287802ULL, 0x000fc40000000f00ULL,
0x00000f0000007944ULL, 0x00afea0003c00000ULL, 0xfffeaf0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0016ULL, 0x0001815000287802ULL, 0x000fc40000000f00ULL,
0x00000ec000007944ULL, 0x00afea0003c00000ULL, 0xfffeb02000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0012ULL, 0x000181a000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e0011ULL, 0x00000e7000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0xfffeb1d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0012ULL, 0x000181f000287802ULL, 0x000fc40000000f00ULL,
0x00000e2000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0x0000001011297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0012ULL,
0x0001824000287802ULL, 0x000fc40000000f00ULL, 0x00000dd000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0029ULL, 0xfffeb18000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0012ULL, 0x0001829000287802ULL, 0x000fc40000000f00ULL,
0x00000d8000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0029ULL,
0xfffeb16000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x004fe40004000000ULL,
0x000182e000297802ULL, 0x000fc40000000f00ULL, 0x00000d8000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0028ULL, 0xfffec8e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40004800000ULL, 0x0001833000297802ULL, 0x000fc40000000f00ULL,
0x00000d3000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff6c7224ULL, 0x000fe200078e0028ULL,
0xfffec93000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e006eULL,
0x0001838000287802ULL, 0x000fc40000000f00ULL, 0x00000c9000007944ULL, 0x008fea0003c00000ULL,
0xfffeca1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e006eULL,
0x000183c000287802ULL, 0x000fc40000000f00ULL, 0x00000c5000007944ULL, 0x00afea0003c00000ULL,
0xfffecb4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e006eULL,
0x0001840000287802ULL, 0x000fc40000000f00ULL, 0x00000c1000007944ULL, 0x00afea0003c00000ULL,
0xfffecc7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e006eULL,
0x0001844000287802ULL, 0x000fc40000000f00ULL, 0x00000bd000007944ULL, 0x00afea0003c00000ULL,
0xfffecd9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0011ULL,
0x0001849000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e001cULL,
0x00000b8000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0xfffecf3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0011ULL,
0x000184e000287802ULL, 0x000fc40000000f00ULL, 0x00000b3000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0x000000101c297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0011ULL, 0x0001853000287802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0029ULL,
0xfffecee000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0011ULL,
0x0001858000287802ULL, 0x000fc40000000f00ULL, 0x00000a9000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0029ULL, 0xfffecec000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x004fe40004000000ULL, 0x000185d000297802ULL, 0x000fc40000000f00ULL,
0x00000a9000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff6d7224ULL, 0x000fe200078e0028ULL,
0xfffee3f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe40004800000ULL,
0x0001862000297802ULL, 0x000fc40000000f00ULL, 0x00000a4000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff267224ULL, 0x000fe200078e0028ULL, 0xfffee44000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0070ULL, 0x0001867000287802ULL, 0x000fc40000000f00ULL,
0x000009a000007944ULL, 0x008fea0003c00000ULL, 0xfffee52000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0070ULL, 0x000186b000287802ULL, 0x000fc40000000f00ULL,
0x0000096000007944ULL, 0x00afea0003c00000ULL, 0xfffee65000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0070ULL, 0x000186f000287802ULL, 0x000fc40000000f00ULL,
0x0000092000007944ULL, 0x00afea0003c00000ULL, 0xfffee78000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0070ULL, 0x0001873000287802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x00afea0003c00000ULL, 0xfffee8a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0011ULL, 0x0001878000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e006cULL, 0x0000089000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0xfffeea5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0011ULL, 0x000187d000287802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0x000000106c297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0011ULL,
0x0001882000287802ULL, 0x000fc40000000f00ULL, 0x000007f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0029ULL, 0xfffeea0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0011ULL, 0x0001887000287802ULL, 0x000fc40000000f00ULL,
0x000007a000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0029ULL,
0xfffee9e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x008fe40004000000ULL,
0x000188c000297802ULL, 0x000fc40000000f00ULL, 0x000007a000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff217224ULL, 0x000fe200078e0028ULL, 0xfffeff4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40004800000ULL, 0x0001891000297802ULL, 0x000fc40000000f00ULL,
0x0000075000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff207224ULL, 0x000fe200078e0028ULL,
0xfffeff9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001896000287802ULL, 0x000fc40000000f00ULL, 0x000006b000007944ULL, 0x002fea0003c00000ULL,
0xffff007000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x000189a000287802ULL, 0x000fc40000000f00ULL, 0x0000067000007944ULL, 0x002fea0003c00000ULL,
0xffff01a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x000189e000287802ULL, 0x000fc40000000f00ULL, 0x0000063000007944ULL, 0x002fea0003c00000ULL,
0xffff02d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x00018a2000287802ULL, 0x000fc40000000f00ULL, 0x000005f000007944ULL, 0x002fea0003c00000ULL,
0xffff03f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000bULL,
0x00018a7000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e000cULL,
0x000005a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0xffff05a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000bULL,
0x00018ac000287802ULL, 0x000fc40000000f00ULL, 0x0000055000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0x000000100c297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000bULL, 0x00018b1000287802ULL, 0x000fc40000000f00ULL,
0x0000050000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0029ULL,
0xffff055000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000bULL,
0x00018b6000287802ULL, 0x000fc40000000f00ULL, 0x000004b000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0029ULL, 0xffff053000007947ULL, 0x000fea000383ffffULL,
0x00000002ff227424ULL, 0x000fe200078e00ffULL, 0x00018bb000507802ULL, 0x000fc40000000f00ULL,
0x0000042000007944ULL, 0x002fea0003c00000ULL, 0xffffdff000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0b7224ULL, 0x002fe200078e0052ULL, 0x00018c0000507802ULL, 0x000fe20000000f00ULL,
0x00000002ff227424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x000000035200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e0053ULL,
0x00018c6000507802ULL, 0x000fe20000000f00ULL, 0x00000002ff227424ULL, 0x000fe200078e00ffULL,
0x00000052030a7208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000035300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e0054ULL,
0x00018cc000507802ULL, 0x000fe20000000f00ULL, 0x00000002ff227424ULL, 0x000fe200078e00ffULL,
0x0000005303567208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000035400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e0055ULL,
0x00018d2000507802ULL, 0x000fe20000000f00ULL, 0x00000001ff227424ULL, 0x000fe200078e00ffULL,
0x0000005403527208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000035500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e000aULL,
0x00018d8000507802ULL, 0x000fe20000000f00ULL, 0x00000001ff227424ULL, 0x000fe200078e00ffULL,
0x0000005503087208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000030a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e0056ULL,
0x00018de000507802ULL, 0x000fe20000000f00ULL, 0x00000001ff227424ULL, 0x000fe200078e00ffULL,
0x0000000a03097208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000035600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0b7224ULL, 0x002fe200078e0052ULL,
0x00018e4000507802ULL, 0x000fe20000000f00ULL, 0x00000001ff227424ULL, 0x000fe200078e00ffULL,
0x00000056030a7208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff517224ULL, 0x004fe200078e0003ULL, 0xffffdeb000007947ULL, 0x000fea000383ffffULL,
0x0180000006037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003097812ULL, 0x000fc800078ec0ffULL, 0x018000000900780cULL, 0x000fda0003f05070ULL,
0x0000000600038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0900720cULL, 0x040fe40003f25070ULL, 0x008000000900780cULL, 0x000fe40003f02070ULL,
0x00000001ff0e7807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x000000030eff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000006067812ULL, 0x002fe400078ec0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x000000030eff7212ULL, 0x000fda000780c0ffULL,
0x0080000006030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0006ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000600037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff0d7424ULL, 0x000fc800078e00ffULL,
0xfffe70300c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff517424ULL, 0x000fe200078e00ffULL,
0x0000005800007348ULL, 0x000fe80003800000ULL, 0x0c0000220b037389ULL, 0x0002a200000e0057ULL,
0xfffe6ff050007950ULL, 0x000fea0003c3ffffULL, 0x0000008300007348ULL, 0x000fe80003800000ULL,
0x000000292a297389ULL, 0x0002a200000e0086ULL, 0x00000000ff2b7424ULL, 0x000fc400078e00ffULL,
0x000000ffff2a7224ULL, 0x002fc800078e0028ULL, 0xfffe6fa02a007950ULL, 0x000fea0003c3ffffULL,
0x000000012800780cULL, 0x000fe20003f45070ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0029ULL,
0x0000008200007348ULL, 0x000fe80003800000ULL, 0x00000000ff2b7424ULL, 0x000fce00078e00ffULL,
0x0000000000287806ULL, 0x000fc800050e0100ULL, 0x0000008228287212ULL, 0x000fe200078ec0ffULL,
0xfffe6f302a007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000200000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x00000000000004c4ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000620ULL,
0x0000000000000240ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000860ULL,
0x0000000000000340ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ba0ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c60ULL,
0x00000000000006c0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001320ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001330ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000013c0ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000013c4ULL,
0x00000000000001b8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001580ULL,
0x0000000000019180ULL, 0xd600001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001a700ULL,
0x0000000000000038ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001a740ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001aac0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000013c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000019340ULL,
0x0000000000019340ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001a700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001aac0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_0_m_32_sm_86_cubin_len = 109472;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
