/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000014540ULL, 0x00000000000141c0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x4545386a4c45386aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x36316a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL, 0x735f616475635f5fULL,
0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL, 0x695f5f2400687461ULL,
0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL, 0x5f636e79736c6668ULL,
0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL, 0x376d735f61647563ULL,
0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL, 0x245f335f6c616e72ULL,
0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL, 0x6c65722e00746f6cULL,
0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL, 0x6e72656b2e747865ULL,
0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL, 0x2e00667542657479ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x2e006d617261705fULL,
0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL,
0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL, 0x0000006e6f697463ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000c000100000362ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000003a7ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000b0022000003edULL,
0x0000000000012960ULL, 0x0000000000000170ULL, 0x000b002200000420ULL, 0x0000000000012ad0ULL,
0x0000000000000040ULL, 0x000b00220000044bULL, 0x0000000000012b10ULL, 0x0000000000000050ULL,
0x000b002200000475ULL, 0x0000000000012b60ULL, 0x0000000000000120ULL, 0x000a0003000004e3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000503ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000533ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000012c80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001296000000000ULL, 0x0000040400000000ULL, 0x810c000001200400ULL, 0x00492c0400288080ULL,
0x0000000000000000ULL, 0x0000006cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x9408288080890828ULL,
0x2880809608288080ULL, 0x8098082880809708ULL, 0x0828808099082880ULL, 0x8080a108288080a0ULL,
0x80162880808c0828ULL, 0x0000000310288082ULL, 0x808c920000000000ULL, 0x0000000022002880ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001296000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080870828808081ULL, 0x8908288080880828ULL,
0x2880808c08288080ULL, 0x8096082880809408ULL, 0x0828808098082880ULL, 0x8080a00828808099ULL,
0xb008288080a10828ULL, 0x288080ae08288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x00002200288080aeULL, 0x0000001cffffffffULL, 0x0000011000000000ULL, 0x00012ad000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000006cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x8c08288080890828ULL, 0x2880809408288080ULL, 0x8097082880809608ULL, 0x0828808098082880ULL,
0x8080a108288080a0ULL, 0x8016288080990828ULL, 0x0000000310288082ULL, 0x8099920000000000ULL,
0x0000000022002880ULL, 0x0000002cffffffffULL, 0x000001b800000000ULL, 0x00012b1000000000ULL,
0x0000005000000000ULL, 0x0000100400000000ULL, 0x808c288080990900ULL, 0x0000000000002880ULL,
0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8c08288080890828ULL, 0x2880809408288080ULL,
0x8099082880809808ULL, 0x08288080a0082880ULL, 0x80809608288080a1ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880809692ULL, 0x0000002cffffffffULL, 0x0000026800000000ULL,
0x00012b6000000000ULL, 0x0000012000000000ULL, 0x0000180400000000ULL, 0x808c288080960900ULL,
0x0000000000002880ULL, 0x0000001800082f04ULL, 0x0008230400000080ULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL,
0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL,
0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL,
0x0000001100082304ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008230400000000ULL, 0x0000000000000018ULL, 0x0000001800081204ULL, 0x0008110400000000ULL,
0x0000000000000018ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0048016000000015ULL,
0x000c170400481903ULL, 0x0040000600000000ULL, 0x000c17040021f000ULL, 0x0038000500000000ULL,
0x000c17040021f000ULL, 0x0030000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040061f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0000002000043104ULL,
0xffffffff01542904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000f001542804ULL,
0x0000034000000120ULL, 0x000021d000001290ULL, 0x0000238000002270ULL, 0x00002700000024f0ULL,
0x000027a000002730ULL, 0x00002e9000002810ULL, 0x00003da000003d00ULL, 0x0000403000003ed0ULL,
0x0000427000004240ULL, 0x00004350000042e0ULL, 0x0000550000004700ULL, 0x000056d0000055a0ULL,
0x00005a4000005830ULL, 0x00005ae000005a70ULL, 0x00005f1000005b50ULL, 0x00006dc000006d20ULL,
0x0000704000006ee0ULL, 0x0000728000007250ULL, 0x00007360000072f0ULL, 0x0000787000007860ULL,
0x00009b5000009b10ULL, 0x0000a3600000a320ULL, 0x00010e6000010e20ULL, 0x00010e8000010e70ULL,
0x00010ef000010e90ULL, 0x00010f3000010f10ULL, 0x00011bd000011b70ULL, 0x00011cb000011c40ULL,
0x00011db000011d30ULL, 0x00011e7000011e10ULL, 0x00011f5000011ee0ULL, 0x0001204000011fd0ULL,
0x00012100000120a0ULL, 0x000121d000012160ULL, 0x000122c000012250ULL, 0x0001238000012320ULL,
0x00012460000123f0ULL, 0x00012550000124e0ULL, 0x00012640000125c0ULL, 0x00012740000126c0ULL,
0x00012840000127c0ULL, 0x00012940000128c0ULL, 0x000001f002003904ULL, 0x0001b600000000ffULL,
0x00000260003f0100ULL, 0x0001b6080000000bULL, 0x00000320003f0120ULL, 0x0001b6880000000bULL,
0x00000410003f0120ULL, 0x0001b600000000ffULL, 0x00000510003f0107ULL, 0x0001b68c0000000aULL,
0x000005a0003f0102ULL, 0x0001b6880000000aULL, 0x00001ea0003f0101ULL, 0x0001b6080000000cULL,
0x00001f00003f0101ULL, 0x0001b60c00000016ULL, 0x000020d0003f0105ULL, 0x0001b60c00000016ULL,
0x00002e30003f0105ULL, 0x0001b68800000061ULL, 0x00003a60003f0101ULL, 0x0001b62800000016ULL,
0x00003a80003f0101ULL, 0x0001b62c00000016ULL, 0x00003c50003f0105ULL, 0x0001b62c00000016ULL,
0x000046b0003f0105ULL, 0x0001b69000000061ULL, 0x00005260003f0101ULL, 0x0001b64800000016ULL,
0x00005280003f0101ULL, 0x0001b64c00000016ULL, 0x00005450003f0105ULL, 0x0001b64c00000016ULL,
0x00005eb0003f0105ULL, 0x0001b69800000061ULL, 0x00006a80003f0101ULL, 0x0001b66800000016ULL,
0x00006aa0003f0101ULL, 0x0001b66c00000016ULL, 0x00006c70003f0105ULL, 0x0001b66c00000016ULL,
0x00007680003f0105ULL, 0x0001b6a000000061ULL, 0x0000aeb0003f0101ULL, 0x0001b600000000ffULL,
0x0000c4f0003f0101ULL, 0x0001b604000000ffULL, 0x0000c6c0003f0105ULL, 0x0001b604000000ffULL,
0x000102d0003f0105ULL, 0x000000000000000bULL, 0x00010370003f0101ULL, 0x000000040000000bULL,
0x00010540003f0105ULL, 0x000000040000000bULL, 0x000119c0003f0105ULL, 0x0001b60800000009ULL,
0x00011a20003f0101ULL, 0x0001b61000000009ULL, 0x00011a80003f0101ULL, 0x0001b61800000009ULL,
0x00011af0003f0101ULL, 0x0001b62000000009ULL, 0x00033803003f0101ULL, 0x0000abb000141c04ULL,
0x0000c7200000ae20ULL, 0x00011b300000c7a0ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x00000000000002ecULL, 0x0000001800000002ULL, 0x0000000000000244ULL, 0x0000001800000002ULL,
0x00000000000001a4ULL, 0x0000001800000002ULL, 0x00000000000000fcULL, 0x0000001800000002ULL,
0x0000000000000044ULL, 0x0000001800000002ULL, 0x00000000000002c8ULL, 0x0000001800000002ULL,
0x000000000000021dULL, 0x0000001800000002ULL, 0x000000000000017fULL, 0x0000001800000002ULL,
0x00000000000000d5ULL, 0x0000001800000002ULL, 0x000000000001b700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x0000000000117806ULL, 0x000fe200038e0000ULL, 0x00005800ff067624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000047919ULL, 0x000ea20000002300ULL,
0x0000001100077300ULL, 0x000ee200000e0000ULL, 0x0000000806067824ULL, 0x000fe200078e00ffULL,
0x00000000000479c3ULL, 0x000f220000002500ULL, 0x0000000000037919ULL, 0x000ea80000002200ULL,
0x00000000000f7919ULL, 0x000ee20000002600ULL, 0x0000001100137309ULL, 0x0002a60000000000ULL,
0x0000000000087919ULL, 0x000ee80000000000ULL, 0x00000000000e7919ULL, 0x000ee20000002700ULL,
0x00000005ff577819ULL, 0x002fcc000001160bULL, 0x00001fff57577589ULL, 0x000fe200000e0000ULL,
0x0000000400597c02ULL, 0x010fe20008000f00ULL, 0x0000010004007a24ULL, 0x004fe400078e0203ULL,
0x00001fff04047589ULL, 0x000e6400000e0000ULL, 0x00000000000b7a24ULL, 0x000fe400078e020bULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x000000080f057824ULL, 0x008fe200078e00ffULL,
0x000000080700720cULL, 0x000fc40003f62070ULL, 0x000000ff0b00720cULL, 0x040fe20003f05270ULL,
0x0000000e06087224ULL, 0x000fe200078e0205ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x0000007f0b00780cULL, 0x000fd20003f44070ULL, 0x3fffff8000028802ULL, 0x000fe20000000f00ULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x0000000404057824ULL, 0x002fe400078e0257ULL,
0x3fffffc0ff069424ULL, 0x000fe200078e00ffULL, 0x01b60002ff008388ULL, 0x0003e20000000a00ULL,
0x000000030b00780cULL, 0x000fe20003f04070ULL, 0x7fffffc0ff079424ULL, 0x000fe200078e00ffULL,
0x00000004ff0c7819ULL, 0x004fe20000011600ULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000105097819ULL, 0x000fe200000006ffULL, 0x00000100ff057424ULL, 0x000fe200078e00ffULL,
0x01b608060b009388ULL, 0x0005e20000008a00ULL, 0xff317217ff12a424ULL, 0x000fe200078e00ffULL,
0x00000008090a7817ULL, 0x040fe20007800000ULL, 0x00000001090d7824ULL, 0x000fe200078e020cULL,
0x000000f010117812ULL, 0x000fc400078ec0ffULL, 0x0000000a090a7210ULL, 0x000fe20007ffe1ffULL,
0x0000000108027824ULL, 0x002fe200078e020dULL, 0x000000040d147819ULL, 0x000fe200000006ffULL,
0x3fffff60ff088424ULL, 0x000fe200078e00ffULL, 0x01b400120b00a388ULL, 0x000fe20000004800ULL,
0x7fffff60ff098424ULL, 0x000fe400078e00ffULL, 0x00005c0002027625ULL, 0x000fc600078e0005ULL,
0x01b688080b008388ULL, 0x000fe20000008a00ULL, 0x000000010d077824ULL, 0x004fc600078e0200ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000a0c00720cULL, 0x000fe20003f06070ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0a13ULL, 0x0000001102067210ULL, 0x000fe40007f3e0ffULL,
0xfffffff014027812ULL, 0x000fc600078ee207ULL, 0x000000ffff077224ULL, 0x000fe400008e0603ULL,
0x00000010020d7824ULL, 0x000fe400078e00ffULL, 0x00000004ff037424ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c46ULL,
0x000060000e027625ULL, 0x000fc600078e0003ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x01b6040affff338cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000602557981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0400720cULL, 0x000fc40003f05270ULL, 0x000000ff55547810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff547819ULL, 0x000fce0000011654ULL, 0x0000a95000008947ULL, 0x000fea0003800000ULL,
0x00000008570a7824ULL, 0x002fe400078e00ffULL, 0x00000003ff037424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b68c030aff738cULL, 0x0003e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000159097810ULL, 0x000fe20007ffe0ffULL,
0x000000020e047824ULL, 0x000fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fe20000011657ULL,
0x01b688000aff7f8cULL, 0x0005e2000c80043fULL, 0x000000540900720cULL, 0x000fe40003f06070ULL,
0x000058000f077a10ULL, 0x000fe20007ffe0ffULL, 0x0000002002037824ULL, 0x002fe200078e00ffULL,
0x00000001570b7812ULL, 0x000fc600078ec0ffULL, 0x0000580004047a24ULL, 0x000fe200078e0207ULL,
0x00000003590d7211ULL, 0x000fca00078e40ffULL, 0x0000620004187a24ULL, 0x000fe200078e020dULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0000000d55067217ULL, 0x004fe20007800000ULL,
0x0000000202167824ULL, 0x000fe200078e020bULL, 0x00000003ff097819ULL, 0x100fe20000011600ULL,
0x000000080b177824ULL, 0x000fe400078e00ffULL, 0x0000000106067824ULL, 0x000fe200078e0a0dULL,
0x00000009180c7210ULL, 0x000fe20007ffe0ffULL, 0x0000000109077824ULL, 0x000fe200078e0200ULL,
0x0001300016167811ULL, 0x000fe400078e68ffULL, 0x0000002006087817ULL, 0x000fc40003800000ULL,
0x00000007070d7812ULL, 0x000fe200078ec0ffULL, 0x00005e000c067625ULL, 0x000fe200078e0005ULL,
0x000000080900720cULL, 0x000fe40003f06070ULL, 0xfffffff817177812ULL, 0x100fe400078ee200ULL,
0x0ffffff80d0d7812ULL, 0x000fe400078ef800ULL, 0x00000004090f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001017067825ULL, 0x000fe200078e0006ULL, 0x0000000809117810ULL, 0x000fc40007ffe0ffULL,
0x0000000c09137810ULL, 0x000fe20007ffe0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0216ULL,
0x0000001009157810ULL, 0x000fe20007ffe0ffULL, 0x000000010f0c7824ULL, 0x100fe200078e0200ULL,
0x00000014091f7810ULL, 0x000fe20007ffe0ffULL, 0x000000080f197824ULL, 0x000fe200078e00ffULL,
0x0000000013107210ULL, 0x000fe20007ffe0ffULL, 0x00000001110e7824ULL, 0x000fe200078e0200ULL,
0x0000001809217810ULL, 0x000fe20007ffe0ffULL, 0x00000008111b7824ULL, 0x000fe200078e00ffULL,
0x0000001c09237810ULL, 0x000fe20007ffe0ffULL, 0x00000008131d7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000c101c46ULL,
0x00000008151a7824ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee20cULL,
0x000000081f1c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee20eULL,
0x00000001180e7824ULL, 0x040fe200078e0215ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee210ULL,
0x0000000118107824ULL, 0x040fe200078e021fULL, 0x000000080f00720cULL, 0x080fe20003f06070ULL,
0x0000000118127824ULL, 0x040fe200078e0221ULL, 0x000000081100720cULL, 0x080fe20003f26070ULL,
0x0000000118147824ULL, 0x040fe200078e0223ULL, 0x000000081300720cULL, 0x080fe20003f46070ULL,
0x0000000115077824ULL, 0x142fe200078e0200ULL, 0x000000081500720cULL, 0x080fe20003f66070ULL,
0x0000000118067824ULL, 0x040fe200078e020fULL, 0x000000081f00720cULL, 0x080fe20003f86070ULL,
0x00000001210d7824ULL, 0x140fe200078e0200ULL, 0x000000082100720cULL, 0x080fe20003fa6070ULL,
0x00000001230f7824ULL, 0x040fe200078e0200ULL, 0x000000082300720cULL, 0x040fe20003fc6070ULL,
0x0000000118087824ULL, 0x040fe200078e0211ULL, 0x00000013180c7210ULL, 0x000fe20007ffe0ffULL,
0x00000008231e7824ULL, 0x000fe200078e00ffULL, 0x000000001f097210ULL, 0x000fe20007ffe0ffULL,
0x00005e0010107625ULL, 0x000fe200078e0005ULL, 0x0000000321187819ULL, 0x000fc400000006ffULL,
0xfffffff81a1f7812ULL, 0x000fe200078ee207ULL, 0x00005e0006067625ULL, 0x080fe200078e0005ULL,
0xfffffff81c217812ULL, 0x000fe400078ee209ULL, 0xfffffff818237812ULL, 0x000fe200078ee20dULL,
0x00005e0008087625ULL, 0x080fe200078e0005ULL, 0xfffffff81e257812ULL, 0x000fe400078ee20fULL,
0x000000161d1d7211ULL, 0x000fe200078e20ffULL, 0x00005e000c0c7625ULL, 0x000fc800078e0005ULL,
0x00005e000e0e7625ULL, 0x000fc800078e0005ULL, 0x00005e0012127625ULL, 0x000fc800078e0005ULL,
0x00005e0014147625ULL, 0x000fc800078e0005ULL, 0x0000001017067825ULL, 0x000fc800078e0006ULL,
0x0000001019197824ULL, 0x000fe400078e0216ULL, 0x0000001017087825ULL, 0x000fc600078e0008ULL,
0x0000000006197faeULL, 0x0003e2000c101c46ULL, 0x000000101b1b7824ULL, 0x000fe400078e0216ULL,
0x00000010170c7825ULL, 0x000fc600078e000cULL, 0x00000000081b7faeULL, 0x0003e2000c901c46ULL,
0x00000010170e7825ULL, 0x000fc600078e000eULL, 0x000000000c1d7faeULL, 0x0003e2000d101c46ULL,
0x000000101f1f7824ULL, 0x000fe400078e0216ULL, 0x0000001017107825ULL, 0x000fc600078e0010ULL,
0x000000000e1f7faeULL, 0x0003e2000d901c46ULL, 0x0000001021217824ULL, 0x000fe400078e0216ULL,
0x0000001017127825ULL, 0x000fc600078e0012ULL, 0x0000000010217faeULL, 0x0003e2000e101c46ULL,
0x0000001023237824ULL, 0x000fe400078e0216ULL, 0x0000001017147825ULL, 0x000fc600078e0014ULL,
0x0000000012237faeULL, 0x0003e2000e901c46ULL, 0x0000001025257824ULL, 0x000fca00078e0216ULL,
0x0000000014257faeULL, 0x0003e2000f101c46ULL, 0x000004e000007947ULL, 0x000fea0003800000ULL,
0x00000004000d7811ULL, 0x044fe200078fe8ffULL, 0x000000080b1f7824ULL, 0x000fe200078e00ffULL,
0x00000008000f7811ULL, 0x040fe400078fe8ffULL, 0x000000000d067210ULL, 0x0c0fe20007ffe0ffULL,
0x000000080d197824ULL, 0x000fe200078e00ffULL, 0x0000001000137811ULL, 0x040fe200078fe8ffULL,
0x000000080f177824ULL, 0x000fe200078e00ffULL, 0x0000000c00117811ULL, 0x000fe200078fe8ffULL,
0x00000001180c7824ULL, 0x000fe200078e020fULL, 0xfffffff819197812ULL, 0x000fe200078ee206ULL,
0x000000010f067824ULL, 0x100fe200078e0200ULL, 0x0000001400157811ULL, 0x040fe200078fe8ffULL,
0x0000000113087824ULL, 0x000fe200078e0200ULL, 0x00000003111c7819ULL, 0x000fe200000006ffULL,
0x00000008131b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8171a7812ULL, 0x000fe200078ee206ULL,
0x0000000111077824ULL, 0x100fe200078e0200ULL, 0x0000001800177811ULL, 0x040fe200078fe8ffULL,
0x0000000115097824ULL, 0x000fe200078e0200ULL, 0xfffffff81b1e7812ULL, 0x000fe200078ee208ULL,
0x0000000815207824ULL, 0x000fe200078e00ffULL, 0x0000001c001b7811ULL, 0x000fe200078fe8ffULL,
0x0000000118087824ULL, 0x000fe200078e020dULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee207ULL,
0x00000001170d7824ULL, 0x140fe200078e0200ULL, 0x0000000000077211ULL, 0x000fe200078fe8ffULL,
0x0000000817227824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee209ULL,
0x000000011b0f7824ULL, 0x040fe200078e0200ULL, 0x0000001800067211ULL, 0x000fe200078fe8ffULL,
0x000000081b247824ULL, 0x000fe200078e00ffULL, 0x0000000707097812ULL, 0x000fe200078ec0ffULL,
0x00000001180e7824ULL, 0x040fe200078e0211ULL, 0x0000001318107210ULL, 0x040fe20007ffe0ffULL,
0x0000000118127824ULL, 0x040fe200078e0215ULL, 0x0000001b18167210ULL, 0x040fe20007ffe0ffULL,
0x0000000118147824ULL, 0x000fe200078e0217ULL, 0x0000000b021d7211ULL, 0x000fe200078e08ffULL,
0x00005e0006067625ULL, 0x000fe200078e0005ULL, 0xfffffff822227812ULL, 0x000fc400078ee20dULL,
0xfffffff824247812ULL, 0x000fe200078ee20fULL, 0x00005e000c0c7625ULL, 0x080fe200078e0005ULL,
0x0ffffff809187812ULL, 0x100fe400078ef800ULL, 0xfffffff81f1b7812ULL, 0x000fe200078ee200ULL,
0x00005e0008087625ULL, 0x000fe200078e0005ULL, 0x000130001d257811ULL, 0x000fc600078e68ffULL,
0x00005e000e0e7625ULL, 0x000fc800078e0005ULL, 0x00005e0010107625ULL, 0x000fc800078e0005ULL,
0x00005e0012127625ULL, 0x000fc800078e0005ULL, 0x00005e0014147625ULL, 0x000fc800078e0005ULL,
0x00005e0016167625ULL, 0x000fc800078e0005ULL, 0x000000101b067825ULL, 0x000fc800078e0006ULL,
0x0000001018057824ULL, 0x000fe400078e0225ULL, 0x000000101b087825ULL, 0x000fc600078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e2000b901c46ULL,
0x000000101b0c7825ULL, 0x000fc800078e000cULL, 0x000000101b0e7825ULL, 0x000fc800078e000eULL,
0x000000101b107825ULL, 0x000fc800078e0010ULL, 0x000000101b127825ULL, 0x000fc800078e0012ULL,
0x000000101b147825ULL, 0x000fc800078e0014ULL, 0x000000101b167825ULL, 0x000fe200078e0016ULL,
0x000000251a1b7211ULL, 0x000fc600078e20ffULL, 0x0000001019197824ULL, 0x100fe400078e0225ULL,
0x000000101c1d7824ULL, 0x100fe400078e0225ULL, 0x000000101e1f7824ULL, 0x100fe200078e0225ULL,
0x0000000008197faeULL, 0x0003e2000b901c46ULL, 0x0000001020217824ULL, 0x100fe400078e0225ULL,
0x0000001022237824ULL, 0x000fe200078e0225ULL, 0x0000002524257211ULL, 0x000fe200078e20ffULL,
0x000000000c1b7faeULL, 0x0003e8000b901c46ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e8000b901c46ULL, 0x0000000016257faeULL, 0x0003e4000b901c46ULL,
0x000000545900720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff6a7424ULL, 0x000fe200078e00ffULL, 0x0000000000127805ULL, 0x002fe2000001ff00ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x000064d000000947ULL, 0x000fea0003800000ULL, 0xff317217ff6a7424ULL, 0x000fe200078e00ffULL,
0x000000ff00137202ULL, 0x000fe20000000f00ULL, 0x000000ffff6b7224ULL, 0x000fc400078e00ffULL,
0x0000010059067824ULL, 0x000fca00078e00ffULL, 0x000000550600720cULL, 0x000fda0003f06070ULL,
0x0000643000000947ULL, 0x020fea0003800000ULL, 0x00000001590d7810ULL, 0x040fe20007ffe0ffULL,
0x0000010059697824ULL, 0x000fe200078e0203ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000540d00720cULL, 0x000fe20003f06070ULL, 0x000000ffff067224ULL, 0x000fe200078e006bULL,
0x00000040690f7810ULL, 0x000fca0007ffe0ffULL, 0x00006200040d7a24ULL, 0x000fcc00078e020fULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x000010006b0e7824ULL, 0x000fe200078e00ffULL,
0x0000000f550c7217ULL, 0x000fe20007800000ULL, 0x00000100ff1f7424ULL, 0x000fe200078e00ffULL,
0x0000000b02157211ULL, 0x000fe400078e08ffULL, 0x000010000e0e7812ULL, 0x000fe200078e0cffULL,
0x000000010c0c7824ULL, 0x000fe200078e0a0fULL, 0x00000003ff197819ULL, 0x000fe20000011600ULL,
0x000000080b0f7824ULL, 0x000fe400078e00ffULL, 0x00002000150e7824ULL, 0x000fe200078e000eULL,
0x0000000019157210ULL, 0x040fe20007ffe0ffULL, 0x0000000119147824ULL, 0x000fe200078e020dULL,
0x000000200c0c7817ULL, 0x000fc40003800000ULL, 0x0000000715177812ULL, 0x000fe200078ec0ffULL,
0x00005e0014147625ULL, 0x000fe200078e001fULL, 0x0000000c1900720cULL, 0x000fe40003f06070ULL,
0xfffffff80f0f7812ULL, 0x100fe400078ee200ULL, 0x0ffffff817177812ULL, 0x000fe400078ef800ULL,
0x000130000e0e7810ULL, 0x000fe20007ffe0ffULL, 0x000000100f147825ULL, 0x000fe200078e0014ULL,
0x00000004191b7810ULL, 0x000fc40007ffe0ffULL, 0x00000008191d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001017177824ULL, 0x000fe200078e020eULL, 0x0000000c19257810ULL, 0x000fe20007ffe0ffULL,
0x000000011b167824ULL, 0x100fe200078e0200ULL, 0x0000001019297810ULL, 0x000fe20007ffe0ffULL,
0x000000081b217824ULL, 0x000fe200078e00ffULL, 0x00000014192b7810ULL, 0x000fe20007ffe0ffULL,
0x000000011d187824ULL, 0x100fe200078e0200ULL, 0x0000001819497810ULL, 0x000fe20007ffe0ffULL,
0x00000001251a7824ULL, 0x100fe200078e0200ULL, 0x0000001c19197810ULL, 0x000fe20007ffe0ffULL,
0x0000000825277824ULL, 0x000fe200078e00ffULL, 0x000000031d237819ULL, 0x000fe200000006ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014177faeULL, 0x0003e2000c101c46ULL,
0x0000000c1b00720cULL, 0x080fe20003f06070ULL, 0x0000000829207824ULL, 0x000fe200078e00ffULL,
0x0000000c1d00720cULL, 0x080fe20003f26070ULL, 0x000000082b227824ULL, 0x000fe200078e00ffULL,
0x0000000c2500720cULL, 0x080fe20003f46070ULL, 0x00000001491c7824ULL, 0x100fe200078e020dULL,
0x0000000c2900720cULL, 0x080fe20003f66070ULL, 0x00000001191e7824ULL, 0x100fe200078e020dULL,
0x0000000c2b00720cULL, 0x080fe20003f86070ULL, 0x0000000849247824ULL, 0x040fe200078e00ffULL,
0x0000000c4900720cULL, 0x080fe20003fa6070ULL, 0x0000000129157824ULL, 0x002fe200078e0200ULL,
0x0000000c1900720cULL, 0x000fe20003fc6070ULL, 0x000000011b0c7824ULL, 0x100fe200078e020dULL,
0xfffffff821217812ULL, 0x000fe200078ee216ULL, 0x0000000125167824ULL, 0x100fe200078e020dULL,
0xfffffff823237812ULL, 0x000fe200078ee218ULL, 0x0000000129187824ULL, 0x000fe200078e020dULL,
0xfffffff827277812ULL, 0x000fe200078ee21aULL, 0x000000012b177824ULL, 0x100fe200078e0200ULL,
0x0000000d1d147210ULL, 0x080fe20007ffe0ffULL, 0x00000001191b7824ULL, 0x000fe200078e0200ULL,
0x0000000d2b1a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000819267824ULL, 0x000fe200078e00ffULL,
0x00000000490d7210ULL, 0x000fe20007ffe0ffULL, 0x00005e0018187625ULL, 0x000fe200078e001fULL,
0xfffffff820257812ULL, 0x000fc400078ee215ULL, 0xfffffff822297812ULL, 0x000fe200078ee217ULL,
0x00005e0014147625ULL, 0x080fe200078e001fULL, 0xfffffff8242b7812ULL, 0x000fe400078ee20dULL,
0xfffffff826497812ULL, 0x000fe200078ee21bULL, 0x00005e000c0c7625ULL, 0x000fc800078e001fULL,
0x00005e0016167625ULL, 0x000fc800078e001fULL, 0x00005e001a1a7625ULL, 0x000fc800078e001fULL,
0x00005e001c1c7625ULL, 0x000fc800078e001fULL, 0x00005e001e1e7625ULL, 0x000fc800078e001fULL,
0x000000100f0c7825ULL, 0x000fc800078e000cULL, 0x000000100f147825ULL, 0x000fc800078e0014ULL,
0x000000100f167825ULL, 0x000fc800078e0016ULL, 0x000000100f187825ULL, 0x000fc800078e0018ULL,
0x000000100f1a7825ULL, 0x000fc800078e001aULL, 0x000000100f1c7825ULL, 0x000fc800078e001cULL,
0x000000100f1e7825ULL, 0x000fc800078e001eULL, 0x00000010210f7824ULL, 0x100fe200078e020eULL,
0x0000000e23217211ULL, 0x080fe200078e20ffULL, 0x0000001027237824ULL, 0x100fe400078e020eULL,
0x0000001025257824ULL, 0x100fe200078e020eULL, 0x000000000c0f7faeULL, 0x0003e2000c101c46ULL,
0x0000001029277824ULL, 0x100fe400078e020eULL, 0x000000102b297824ULL, 0x000fe200078e020eULL,
0x0000000e492b7211ULL, 0x000fe200078e20ffULL, 0x0000000014217faeULL, 0x0003e8000c901c46ULL,
0x0000000016237faeULL, 0x0003e8000d101c46ULL, 0x0000000018257faeULL, 0x0003e8000d901c46ULL,
0x000000001a277faeULL, 0x0003e8000e101c46ULL, 0x000000001c297faeULL, 0x0003e8000e901c46ULL,
0x000000001e2b7faeULL, 0x0003e2000f101c46ULL, 0x0000052000007947ULL, 0x000fea0003800000ULL,
0x000010006b0e7824ULL, 0x000fe200078e00ffULL, 0x0000000c00167811ULL, 0x000fe200078fe8ffULL,
0x00000002020c7824ULL, 0x000fe200078e020bULL, 0x0000000400147811ULL, 0x000fe200078fe8ffULL,
0x000000080b1d7824ULL, 0x000fe200078e00ffULL, 0x000010000e0f7812ULL, 0x000fe200078e0cffULL,
0x00000001160e7824ULL, 0x100fe200078e0200ULL, 0x0000000800157811ULL, 0x000fe200078fe8ffULL,
0x00000008161b7824ULL, 0x000fe200078e00ffULL, 0x0000001000187811ULL, 0x000fe200078fe8ffULL,
0x000020000c237824ULL, 0x000fe200078e000fULL, 0x0000000314177819ULL, 0x040fe200000006ffULL,
0x00000001141a7824ULL, 0x100fe200078e0200ULL, 0x00000000180f7210ULL, 0x080fe20007ffe0ffULL,
0x00000001150c7824ULL, 0x000fe200078e0200ULL, 0xfffffff81b267812ULL, 0x000fe200078ee20eULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0x00000000000e7211ULL, 0x000fe200078fe8ffULL,
0x0000000818287824ULL, 0x000fe200078e00ffULL, 0xfffffff8171a7812ULL, 0x000fe200078ee21aULL,
0x00000100ff217424ULL, 0x000fe200078e00ffULL, 0xfffffff819247812ULL, 0x000fe200078ee20cULL,
0x0000000116167824ULL, 0x100fe200078e020dULL, 0x0000001400177811ULL, 0x000fe200078fe8ffULL,
0x0000000118187824ULL, 0x000fe200078e020dULL, 0xfffffff828287812ULL, 0x000fc400078ee20fULL,
0x0000001800197811ULL, 0x040fe200078fe8ffULL, 0x00000001171c7824ULL, 0x100fe200078e020dULL,
0x0000001c001b7811ULL, 0x000fe400078fe8ffULL, 0x000000070e0f7812ULL, 0x000fe200078ec0ffULL,
0x00000001140e7824ULL, 0x100fe200078e020dULL, 0x0000000d15147210ULL, 0x080fe20007ffe0ffULL,
0x0000000117157824ULL, 0x140fe200078e0200ULL, 0x00000003172a7819ULL, 0x000fe200000006ffULL,
0x00000001191e7824ULL, 0x040fe200078e020dULL, 0x0000000d000c7211ULL, 0x000fe200078fe8ffULL,
0x0000000119177824ULL, 0x140fe200078e0200ULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee215ULL,
0x0000000819487824ULL, 0x000fe200078e00ffULL, 0x000000001b197210ULL, 0x040fe20007ffe0ffULL,
0x000000081b4a7824ULL, 0x000fe200078e00ffULL, 0x0ffffff80f227812ULL, 0x100fe200078ef800ULL,
0x000000011b207824ULL, 0x000fe200078e020dULL, 0xfffffff81d1b7812ULL, 0x000fe200078ee200ULL,
0x00005e000c0c7625ULL, 0x000fe200078e0021ULL, 0xfffffff848487812ULL, 0x000fc400078ee217ULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee219ULL, 0x00005e000e0e7625ULL, 0x000fe200078e0021ULL,
0x00013000234b7810ULL, 0x000fc60007ffe0ffULL, 0x00005e0014147625ULL, 0x000fe200078e0021ULL,
0x0000004b26277211ULL, 0x000fc600078e20ffULL, 0x00005e0016167625ULL, 0x000fc800078e0021ULL,
0x00005e0018187625ULL, 0x000fc800078e0021ULL, 0x00005e001c1c7625ULL, 0x000fc800078e0021ULL,
0x00005e001e1e7625ULL, 0x000fc800078e0021ULL, 0x00005e0020207625ULL, 0x000fc800078e0021ULL,
0x000000101b0c7825ULL, 0x000fc800078e000cULL, 0x000000101b0e7825ULL, 0x000fc800078e000eULL,
0x000000101b147825ULL, 0x000fc800078e0014ULL, 0x000000101b167825ULL, 0x000fc800078e0016ULL,
0x000000101b187825ULL, 0x000fc800078e0018ULL, 0x000000101b1c7825ULL, 0x000fc800078e001cULL,
0x000000101b1e7825ULL, 0x000fc800078e001eULL, 0x000000101b207825ULL, 0x000fc800078e0020ULL,
0x00000010221b7824ULL, 0x100fe400078e024bULL, 0x000000101a237824ULL, 0x100fe400078e024bULL,
0x0000001024257824ULL, 0x100fe200078e024bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c1b7faeULL, 0x0003e2000b901c46ULL, 0x0000001028297824ULL, 0x100fe400078e024bULL,
0x000000102a2b7824ULL, 0x100fe200078e024bULL, 0x000000000e237faeULL, 0x0003e2000b901c46ULL,
0x0000001048497824ULL, 0x000fc400078e024bULL, 0x000000104a4b7824ULL, 0x000fe200078e024bULL,
0x0000000014257faeULL, 0x0003e8000b901c46ULL, 0x0000000016277faeULL, 0x0003e8000b901c46ULL,
0x0000000018297faeULL, 0x0003e8000b901c46ULL, 0x000000001c2b7faeULL, 0x0003e8000b901c46ULL,
0x000000001e497faeULL, 0x0003e8000b901c46ULL, 0x00000000204b7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe00a0e7812ULL, 0x002fc400078ec0ffULL,
0x000000100a0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000d0e0c7210ULL, 0x000fca0007ffe0ffULL,
0x000000080b0c7824ULL, 0x000fe200078e020cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b608000c147f8cULL, 0x0002a4000c80043fULL, 0x00000000000c7805ULL, 0x002fc40000015200ULL,
0x00000010020f7824ULL, 0x000fca00078e00ffULL, 0x000000100f0f7812ULL, 0x000fca00078ec0ffULL,
0x000000010e0e7824ULL, 0x000fc800078e020fULL, 0x000000080b167824ULL, 0x000fca00078e020eULL,
0x01b60c00160f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x006fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ff00187202ULL, 0x000fe20000000f00ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c177210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000170e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000118187810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b60c00160f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000667824ULL, 0x000fe200078e00ffULL, 0x00000001ff647819ULL, 0x000fe20000011600ULL,
0x0000002057657824ULL, 0x000fc600078e00ffULL, 0x0000007066667812ULL, 0x000fe400078ec0ffULL,
0xffffff8065657812ULL, 0x000fe400078ec0ffULL, 0x0000000c64647812ULL, 0x000fc800078ec0ffULL,
0x00000065640c7210ULL, 0x000fca0007ffe066ULL, 0x01b000000c0f7984ULL, 0x000e680000000800ULL,
0x01b200000c0e7984ULL, 0x0004e20000000800ULL, 0x0000006a0f00720bULL, 0x002fe20003f1d000ULL,
0x0000f9727f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0c1b7812ULL, 0x000fe2000782c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff677224ULL, 0x000fd400078e006aULL,
0x0000044000009947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe40000011657ULL,
0x0000006a0f00720bULL, 0x000fe40003f54000ULL, 0x000000570c00720cULL, 0x000fe20003f25270ULL,
0x0000f9327f007947ULL, 0x000fd4000b800000ULL, 0x0000000000147806ULL, 0x000fc400010e0100ULL,
0x00000066570d9211ULL, 0x000fe200078e38ffULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000000f6a677209ULL, 0x000fc60007810000ULL, 0x00000001640c9824ULL, 0x000fe200078e020dULL,
0x00009910140d7816ULL, 0x000fc800000000ffULL, 0x01b400670c009388ULL, 0x0003e20000000800ULL,
0x000000ff0d00720cULL, 0x000fda0003f25270ULL, 0x0000030000009947ULL, 0x000fea0003800000ULL,
0x800000676a0c7221ULL, 0x002fe20000010000ULL, 0x000000ff14ff7812ULL, 0x000fe2000782c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00157308ULL, 0x0002ac0000000800ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x002fe20000011600ULL, 0x0000f8827f007947ULL, 0x000fea000b800000ULL,
0x00001f0c150c7589ULL, 0x0042a400000e0000ULL, 0x0000000c44447220ULL, 0x084fe40000410000ULL,
0x0000000c45457220ULL, 0x080fe40000410000ULL, 0x0000000c40407220ULL, 0x000fc40000410000ULL,
0x0000000c41417220ULL, 0x080fe40000410000ULL, 0x0000000c3c3c7220ULL, 0x080fe40000410000ULL,
0x0000000c3d3d7220ULL, 0x080fe40000410000ULL, 0x0000000c38387220ULL, 0x080fe40000410000ULL,
0x0000000c39397220ULL, 0x080fe40000410000ULL, 0x0000000c34347220ULL, 0x000fc40000410000ULL,
0x0000000c35357220ULL, 0x080fe40000410000ULL, 0x0000000c30307220ULL, 0x080fe40000410000ULL,
0x0000000c31317220ULL, 0x080fe40000410000ULL, 0x0000000c2c2c7220ULL, 0x080fe40000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe40000410000ULL, 0x0000000c10107220ULL, 0x000fc40000410000ULL,
0x0000000c11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0014ff7812ULL, 0x000fe2000782c0ffULL, 0x0000001505057220ULL, 0x004fd80000410000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000008000c7811ULL, 0x002fe200078ff0ffULL,
0x0000f7827f007947ULL, 0x000fea000b800000ULL, 0x00001f0c150c7589ULL, 0x0002a400000e0000ULL,
0x0000000c46467220ULL, 0x084fe40000410000ULL, 0x0000000c47477220ULL, 0x080fe40000410000ULL,
0x0000000c42427220ULL, 0x080fe40000410000ULL, 0x0000000c43437220ULL, 0x080fe40000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000c3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe40000410000ULL,
0x0000000c36367220ULL, 0x080fe40000410000ULL, 0x0000000c37377220ULL, 0x080fe40000410000ULL,
0x0000000c32327220ULL, 0x080fe40000410000ULL, 0x0000000c33337220ULL, 0x000fc40000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe40000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000c12127220ULL, 0x080fe40000410000ULL, 0x0000000c13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff1bff7812ULL, 0x000fda0007826014ULL,
0x800000670f0f1221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b0f0f1820ULL, 0x000fc80000410000ULL, 0x0000000f00071308ULL, 0x000e640000000800ULL,
0x000000070e0e1220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x000000050e057221ULL, 0x008fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000000ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011600ULL,
0x00005410080e7816ULL, 0x000fe20000000008ULL, 0x0000f5e27f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0e087589ULL, 0x0002a400000e0000ULL, 0x000000080f097810ULL, 0x000fe20007ffe0ffULL,
0x0000f6327f007947ULL, 0x000fea000b800000ULL, 0x00001f090e097589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100f0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff187424ULL, 0x000fe200078e00ffULL, 0x0000000e00177202ULL, 0x000fe20000000f00ULL,
0xffffffffff1d7424ULL, 0x000fe200078e00ffULL, 0x000027b000197802ULL, 0x000fc40000000f00ULL,
0x0001036000007944ULL, 0x00efea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180f0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e000eULL,
0xffffffff001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff187424ULL, 0x000fe200078e00ffULL,
0x0000282000197802ULL, 0x000fc40000000f00ULL, 0x000102f000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff0d7819ULL, 0x100fe20000011600ULL,
0x00000200570f7824ULL, 0x002fe200078e00ffULL, 0x0000000700637812ULL, 0x000fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x00000004020d7824ULL, 0x000fe200078e020dULL,
0x00000008630c7812ULL, 0x000fc400078ef800ULL, 0xfffff8000f157812ULL, 0x000fc600078ec0ffULL,
0x000000010c0e7824ULL, 0x048fe400078e020dULL, 0x000000080c0d7824ULL, 0x000fca00078e00ffULL,
0xfffffff80d627812ULL, 0x000fe400078ee20eULL, 0x00000008000d7812ULL, 0x000fe400078ec0ffULL,
0x0000001562627211ULL, 0x000fc600078e20ffULL, 0x0000000202687824ULL, 0x000fe200078e020bULL,
0x000000070d0d7812ULL, 0x000fe200078ef800ULL, 0x011000006228783bULL, 0x000e620000000200ULL,
0x000000020e0e7810ULL, 0x000fe20007ffe0ffULL, 0x0000200068687824ULL, 0x000fe200078e00ffULL,
0x0000000d000f7211ULL, 0x000fe200078fe0ffULL, 0x000000080d607824ULL, 0x040fe200078e00ffULL,
0x000000030d177819ULL, 0x044fe200000006ffULL, 0x000000080d167824ULL, 0x000fe200078e00ffULL,
0x000000020f5f7810ULL, 0x000fe20007ffe0ffULL, 0x000000080d187824ULL, 0x000fe200078e00ffULL,
0x000000040f5e7810ULL, 0x000fe20007ffe0ffULL, 0x000010006b147824ULL, 0x000fe200078e0268ULL,
0x000000060f5d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000257617824ULL, 0x000fe200078e00ffULL,
0xfffffff860607812ULL, 0x000fc400078ee20fULL, 0xfffffff8165f7812ULL, 0x000fe400078ee25fULL,
0x00013000141b7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8175e7812ULL, 0x000fe400078ee25eULL,
0xfffffff8185d7812ULL, 0x000fe200078ee25dULL, 0x0000001060507824ULL, 0x100fe200078e021bULL,
0x000000100d197812ULL, 0x000fe200078efcffULL, 0x000000105f4c7824ULL, 0x100fe200078e021bULL,
0x000000030c0d7819ULL, 0x000fe200000006ffULL, 0x000000105e487824ULL, 0x100fe200078e021bULL,
0x00000019005b7211ULL, 0x000fe200078fe0ffULL, 0x000000105d0c7824ULL, 0x000fe200078e021bULL,
0xfffffff80d5c7812ULL, 0x000fe200078ee20eULL, 0x000000005050783bULL, 0x000ea20000004200ULL,
0x0000000819177824ULL, 0x040fe200078e00ffULL, 0x00000003191d7819ULL, 0x040fe200000006ffULL,
0x0000000819187824ULL, 0x040fe200078e00ffULL, 0x000000004c4c783bULL, 0x000ee20000004200ULL,
0x0000000819197824ULL, 0x000fe200078e00ffULL, 0x000000025b5a7810ULL, 0x040fe20007ffe0ffULL,
0x000000105c5c7824ULL, 0x000fe200078e0215ULL, 0x000000004848783bULL, 0x000fe20000004200ULL,
0x000000045b587810ULL, 0x040fe20007ffe0ffULL, 0x0000000828280232ULL, 0x082fe20000000000ULL,
0x000000065b567810ULL, 0x000fe20007ffe0ffULL, 0x000000000c0c783bULL, 0x000fe20000004200ULL,
0xfffffff8175a7812ULL, 0x000fe200078ee25aULL, 0x000000082a2a0232ULL, 0x000fe20000000000ULL,
0xfffffff81d587812ULL, 0x000fe200078ee258ULL, 0x011000005c14783bULL, 0x000e620000000200ULL,
0xfffffff819567812ULL, 0x000fe200078ee256ULL, 0x000000105a247824ULL, 0x000fe200078e021bULL,
0xfffffff8185b7812ULL, 0x000fe200078ee25bULL, 0x0000001058207824ULL, 0x100fe200078e021bULL,
0x0000000929290232ULL, 0x080fe20000000000ULL, 0x0000001056187824ULL, 0x000fe200078e021bULL,
0x0000001b5b1c7211ULL, 0x000fe200078e20ffULL, 0x000000002424783bULL, 0x000f220000004200ULL,
0x000000092b2b0232ULL, 0x000fe20000000000ULL, 0xfffffff861617812ULL, 0x000fc400078ec0ffULL,
0x000000002020783bULL, 0x000f280000004200ULL, 0x000000001c1c783bULL, 0x000f280000004200ULL,
0x000000001818783bULL, 0x000f220000004200ULL, 0x000000502844723cULL, 0x044ff00000001844ULL,
0x000000522840723cULL, 0x040ff00000001840ULL, 0x0000004c283c723cULL, 0x008f62000000183cULL,
0x0000000814140232ULL, 0x002fc40000000000ULL, 0x0000000816160232ULL, 0x000fe40000000000ULL,
0x0000000915150232ULL, 0x080fe40000000000ULL, 0x0000000917170232ULL, 0x000fe20000000000ULL,
0x0000004e2838723cULL, 0x040f700000001838ULL, 0x000000482834723cULL, 0x040f700000001834ULL,
0x0000004a2830723cULL, 0x040f700000001830ULL, 0x0000000c282c723cULL, 0x040f70000000182cULL,
0x0000000e2810723cULL, 0x000f700000001810ULL, 0x00000024143c723cULL, 0x070b70000000183cULL,
0x000000261438723cULL, 0x040b700000001838ULL, 0x000000201434723cULL, 0x040b700000001834ULL,
0x000000221430723cULL, 0x040b700000001830ULL, 0x0000001c1444723cULL, 0x040b700000001844ULL,
0x0000001e1440723cULL, 0x040b700000001840ULL, 0x00000018142c723cULL, 0x040b70000000182cULL,
0x0000001a1410723cULL, 0x000b620000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000040590c7811ULL, 0x000fe200078e40ffULL, 0x01b6880061ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff6a7224ULL, 0x000fe200078e0067ULL, 0x000000016b6b7812ULL, 0x000fc400078e0cffULL,
0x000000550c00720cULL, 0x000fda0003f06070ULL, 0x0000482000000947ULL, 0x000fea0003800000ULL,
0x00000001590d7810ULL, 0x002fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000540d00720cULL, 0x000fe40003f06070ULL, 0x00000080690e7810ULL, 0x000fca0007ffe0ffULL,
0x00006200040f7a24ULL, 0x000fcc00078e020eULL, 0x000005d000008947ULL, 0x000fea0003800000ULL,
0x0000000e550d7217ULL, 0x000fe20007800000ULL, 0x00001000060c7824ULL, 0x000fe200078e00ffULL,
0x00000003ff197819ULL, 0x020fe20000011600ULL, 0x00000100ff207424ULL, 0x000fe200078e00ffULL,
0x000000030b147819ULL, 0x000fe200000006ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0a0eULL,
0x000010000c177812ULL, 0x000fe200078ec0ffULL, 0x00000001190c7824ULL, 0x040fe200078e0200ULL,
0xfffffff8141f7812ULL, 0x000fe200078ee263ULL, 0x0000000119157824ULL, 0x000fe200078e020fULL,
0x000000200d0e7817ULL, 0x000fc40003800000ULL, 0x000000070c1b7812ULL, 0x000fe200078ec0ffULL,
0x00005e00150c7625ULL, 0x000fe200078e0020ULL, 0x0000000e1900720cULL, 0x000fe40003f06070ULL,
0x00013000681e7810ULL, 0x000fe40007ffe017ULL, 0x0ffffff81b157812ULL, 0x000fe200078ef800ULL,
0x000000101f0c7825ULL, 0x000fe200078e000cULL, 0x0000000819277810ULL, 0x040fe40007ffe0ffULL,
0x00000004191d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001015157824ULL, 0x000fe200078e021eULL,
0x0000000c19297810ULL, 0x000fe20007ffe0ffULL, 0x0000000127257824ULL, 0x100fe200078e0200ULL,
0x0000001419497810ULL, 0x000fe20007ffe0ffULL, 0x0000000827167824ULL, 0x000fe200078e00ffULL,
0x00000018194b7810ULL, 0x000fe20007ffe0ffULL, 0x000000081d147824ULL, 0x000fe200078e00ffULL,
0x0000001c194d7810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c157faeULL, 0x0003e2000c101c46ULL, 0x00000010192b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000127177824ULL, 0x100fe200078e020fULL, 0x000000001d217210ULL, 0x000fe20007ffe0ffULL,
0x0000000129237824ULL, 0x100fe200078e0200ULL, 0x0000000e1d00720cULL, 0x080fe20003f06070ULL,
0x00000001291b7824ULL, 0x100fe200078e020fULL, 0x0000000e2700720cULL, 0x080fe20003f26070ULL,
0x0000000149197824ULL, 0x100fe200078e020fULL, 0x0000000329187819ULL, 0x000fe200000006ffULL,
0x000000014d277824ULL, 0x000fe200078e020fULL, 0xfffffff816257812ULL, 0x000fe200078ee225ULL,
0x000000011d0d7824ULL, 0x102fe200078e020fULL, 0x0000000e2900720cULL, 0x080fe20003f46070ULL,
0x000000014b157824ULL, 0x000fe200078e020fULL, 0x0000000e2b00720cULL, 0x0c0fe20003f66070ULL,
0x000000012b0c7824ULL, 0x100fe200078e0200ULL, 0x0000000e4900720cULL, 0x080fe20003f86070ULL,
0x000000082b297824ULL, 0x000fe200078e00ffULL, 0x0000000e4b00720cULL, 0x0c0fe20003fa6070ULL,
0x000000084b167824ULL, 0x000fe200078e00ffULL, 0x0000000e4d00720cULL, 0x000fe20003fc6070ULL,
0x00000001490e7824ULL, 0x100fe200078e0200ULL, 0x0000000f2b1d7210ULL, 0x000fe20007ffe0ffULL,
0x000000014b0f7824ULL, 0x000fe200078e0200ULL, 0x00000003492b7819ULL, 0x000fe200000006ffULL,
0x000000084d4b7824ULL, 0x000fe200078e00ffULL, 0xfffffff814217812ULL, 0x000fe200078ee221ULL,
0x00005e001b1a7625ULL, 0x000fe200078e0020ULL, 0x000000004d147210ULL, 0x000fc40007ffe0ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee20eULL, 0x00005e001d1c7625ULL, 0x080fe200078e0020ULL,
0xfffffff816497812ULL, 0x000fe400078ee20fULL, 0xfffffff818237812ULL, 0x000fe200078ee223ULL,
0x00005e000d0e7625ULL, 0x080fe200078e0020ULL, 0xfffffff829297812ULL, 0x000fe400078ee20cULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee214ULL, 0x00005e0017167625ULL, 0x000fc800078e0020ULL,
0x00005e0019187625ULL, 0x000fc800078e0020ULL, 0x00005e0015147625ULL, 0x000fc800078e0020ULL,
0x00005e00270c7625ULL, 0x000fc800078e0020ULL, 0x000000101f0e7825ULL, 0x000fc800078e000eULL,
0x0000001021217824ULL, 0x000fe400078e021eULL, 0x000000101f167825ULL, 0x000fc600078e0016ULL,
0x000000000e217faeULL, 0x0003e2000c101c46ULL, 0x0000001025257824ULL, 0x000fe400078e021eULL,
0x000000101f1a7825ULL, 0x000fc600078e001aULL, 0x0000000016257faeULL, 0x0003e2000c901c46ULL,
0x000000101f1c7825ULL, 0x000fc800078e001cULL, 0x000000101f187825ULL, 0x000fc800078e0018ULL,
0x000000101f147825ULL, 0x000fc800078e0014ULL, 0x000000101f0c7825ULL, 0x000fe200078e000cULL,
0x0000001e291f7211ULL, 0x000fc600078e20ffULL, 0x0000001023237824ULL, 0x100fe400078e021eULL,
0x000000102b277824ULL, 0x100fe400078e021eULL, 0x0000001049297824ULL, 0x100fe200078e021eULL,
0x000000001a237faeULL, 0x0003e2000d101c46ULL, 0x000000104b2b7824ULL, 0x000fc600078e021eULL,
0x000000001c1f7faeULL, 0x0003e8000d901c46ULL, 0x0000000018277faeULL, 0x0003e8000e101c46ULL,
0x0000000014297faeULL, 0x0003e8000e901c46ULL, 0x000000000c2b7faeULL, 0x0003e2000f101c46ULL,
0x0000050000007947ULL, 0x000fea0003800000ULL, 0x0000000400147811ULL, 0x060fe400078fe8ffULL,
0x00000010001e7811ULL, 0x000fc400078fe8ffULL, 0x00000003140d7819ULL, 0x040fe200000006ffULL,
0x0000000114227824ULL, 0x100fe200078e0200ULL, 0x0000000c001c7811ULL, 0x000fe200078fe8ffULL,
0x000000081e0e7824ULL, 0x000fe200078e00ffULL, 0x0000000800187811ULL, 0x000fe400078fe8ffULL,
0x000000001e217210ULL, 0x080fe20007ffe0ffULL, 0x000000011c247824ULL, 0x040fe200078e0200ULL,
0xfffffff80d227812ULL, 0x000fe200078ee222ULL, 0x000000081c0d7824ULL, 0x000fe200078e00ffULL,
0x00000014001a7811ULL, 0x000fe200078fe8ffULL, 0x0000000118237824ULL, 0x100fe200078e0200ULL,
0xfffffff80e217812ULL, 0x000fe200078ee221ULL, 0x00000008180c7824ULL, 0x000fe200078e00ffULL,
0x00000000000e7211ULL, 0x000fe200078fe8ffULL, 0x000000011a207824ULL, 0x000fe200078e0200ULL,
0x00000018001b7811ULL, 0x000fe200078fe8ffULL, 0x000000081a157824ULL, 0x000fe200078e00ffULL,
0xfffffff80d247812ULL, 0x000fe200078ee224ULL, 0x00001000060d7824ULL, 0x000fe200078e00ffULL,
0x0000001c001f7811ULL, 0x000fe200078fe8ffULL, 0x0000000118187824ULL, 0x100fe200078e020fULL,
0x000000070e177812ULL, 0x000fe200078ec0ffULL, 0x00000001140e7824ULL, 0x000fe200078e020fULL,
0xfffffff80c237812ULL, 0x000fe200078ee223ULL, 0x000000011c1c7824ULL, 0x100fe200078e020fULL,
0x0000000f000c7211ULL, 0x080fe200078fe8ffULL, 0x000000011a1a7824ULL, 0x100fe200078e020fULL,
0x0000000f1e1e7210ULL, 0x080fe20007ffe0ffULL, 0x000000011b167824ULL, 0x000fe200078e020fULL,
0x0000000f1f147210ULL, 0x000fe20007ffe0ffULL, 0x000000011b1d7824ULL, 0x000fe200078e0200ULL,
0x000000030b267819ULL, 0x000fe200000006ffULL, 0x000000081b287824ULL, 0x000fe200078e00ffULL,
0xfffffff815207812ULL, 0x000fe200078ee220ULL, 0x000000011f0f7824ULL, 0x000fe200078e0200ULL,
0x000010000d197812ULL, 0x000fe200078ec0ffULL, 0x000000081f2a7824ULL, 0x000fe200078e00ffULL,
0xfffffff826257812ULL, 0x000fe200078ee263ULL, 0x00000100ff157424ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fc400078ee21dULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee20fULL,
0x00005e000c0c7625ULL, 0x080fe200078e0015ULL, 0x0ffffff817267812ULL, 0x000fe400078ef800ULL,
0x00013000684b7810ULL, 0x000fe20007ffe019ULL, 0x00005e000e0e7625ULL, 0x000fc600078e0015ULL,
0x0000004b23237211ULL, 0x000fe200078e20ffULL, 0x00005e0018187625ULL, 0x000fc800078e0015ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0015ULL, 0x00005e001e1e7625ULL, 0x000fc800078e0015ULL,
0x00005e001a1a7625ULL, 0x000fc800078e0015ULL, 0x00005e0016167625ULL, 0x000fc800078e0015ULL,
0x00005e0014147625ULL, 0x000fc800078e0015ULL, 0x00000010250c7825ULL, 0x000fc800078e000cULL,
0x00000010250e7825ULL, 0x000fc800078e000eULL, 0x0000001025187825ULL, 0x000fc800078e0018ULL,
0x00000010251c7825ULL, 0x000fc800078e001cULL, 0x00000010251e7825ULL, 0x000fc800078e001eULL,
0x00000010251a7825ULL, 0x000fc800078e001aULL, 0x0000001025167825ULL, 0x000fc800078e0016ULL,
0x0000001025147825ULL, 0x000fc800078e0014ULL, 0x0000001026257824ULL, 0x100fe400078e024bULL,
0x0000001022277824ULL, 0x100fe400078e024bULL, 0x0000001024297824ULL, 0x100fe200078e024bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c257faeULL, 0x0003e2000b901c46ULL,
0x0000001021217824ULL, 0x100fe400078e024bULL, 0x00000010202b7824ULL, 0x100fe200078e024bULL,
0x000000000e277faeULL, 0x0003e2000b901c46ULL, 0x0000001028497824ULL, 0x000fe200078e024bULL,
0x0000004b2a4b7211ULL, 0x000fc400078e20ffULL, 0x0000000018237faeULL, 0x0003e8000b901c46ULL,
0x000000001c297faeULL, 0x0003e8000b901c46ULL, 0x000000001e217faeULL, 0x0003e8000b901c46ULL,
0x000000001a2b7faeULL, 0x0003e8000b901c46ULL, 0x0000000016497faeULL, 0x0003e8000b901c46ULL,
0x00000000144b7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000010020d7824ULL, 0x002fe200078e00ffULL, 0xffffffe00a0c7812ULL, 0x000fc800078ec0ffULL,
0x000000100d0d7812ULL, 0x000fca00078ec0ffULL, 0x000000010c0c7824ULL, 0x000fc800078e020dULL,
0x000000080b167824ULL, 0x000fe200078e020cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6280016147f8cULL, 0x0002a4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x01b62c00160f7984ULL, 0x000ee40000000800ULL, 0x800000000fff7812ULL, 0x00cfe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c177210ULL, 0x000fc80007f1e1ffULL,
0x0000000f0d0f7210ULL, 0x000fe400007fe5ffULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000170e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000118187810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b62c00160f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000080660d7810ULL, 0x000fca0007ffe065ULL, 0x00000001640d7824ULL, 0x000fca00078e020dULL,
0x01b000000d0e7984ULL, 0x000ea80000000800ULL, 0x01b200000d147984ULL, 0x0006620000000800ULL,
0x000000670e00720bULL, 0x004fe20003f1d000ULL, 0x0000e0e27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000f7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0fff7812ULL, 0x000fe2000782c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x00000067006a7202ULL, 0x000fd20000000f00ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x00000001570c7811ULL, 0x000fe400078ff0ffULL, 0x000000670e00720bULL, 0x000fe40003f34000ULL,
0x000000570c00720cULL, 0x000fe20003f05270ULL, 0x0000e0a27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000167806ULL, 0x002fc400008e0100ULL, 0x00000080570d8824ULL, 0x000fe200078e0266ULL,
0x000000670e0c8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x0000000164158824ULL, 0x000fe200078e020dULL, 0x00009910160d7816ULL, 0x000fc800000000ffULL,
0x01b4000c15008388ULL, 0x0003e20000000800ULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000670e0c7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff16ff7812ULL, 0x000fc6000780c0ffULL,
0x000000670c0c7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c001a7308ULL, 0x000e640000000800ULL, 0x0000001a05057220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011600ULL,
0x0000dfd27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c1a0c7589ULL, 0x0002a400000e0000ULL,
0x0000000c44447220ULL, 0x084fe40000410000ULL, 0x0000000c45457220ULL, 0x080fe40000410000ULL,
0x0000000c40407220ULL, 0x080fe40000410000ULL, 0x0000000c41417220ULL, 0x000fc40000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe40000410000ULL,
0x0000000c38387220ULL, 0x080fe40000410000ULL, 0x0000000c39397220ULL, 0x080fe40000410000ULL,
0x0000000c34347220ULL, 0x080fe40000410000ULL, 0x0000000c35357220ULL, 0x000fc40000410000ULL,
0x0000000c30307220ULL, 0x080fe40000410000ULL, 0x0000000c31317220ULL, 0x080fe40000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000c10107220ULL, 0x080fe40000410000ULL, 0x0000000c11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008000c7811ULL, 0x000fe200078ff0ffULL,
0x0000dee27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c1a0c7589ULL, 0x0004e400000e0000ULL,
0x0000000c46467220ULL, 0x088fe40000410000ULL, 0x0000000c47477220ULL, 0x080fe40000410000ULL,
0x0000000c42427220ULL, 0x080fe40000410000ULL, 0x0000000c43437220ULL, 0x080fe40000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000c3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe40000410000ULL,
0x0000000c36367220ULL, 0x080fe40000410000ULL, 0x0000000c37377220ULL, 0x080fe40000410000ULL,
0x0000000c32327220ULL, 0x080fe40000410000ULL, 0x0000000c33337220ULL, 0x000fc40000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe40000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000c12127220ULL, 0x080fe40000410000ULL, 0x0000000c13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff16ff7812ULL, 0x000fe4000780080fULL,
0x000000670e6a7209ULL, 0x000fd60007810000ULL, 0x8000006a0e0e0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0e0e0820ULL, 0x000fc80000410000ULL, 0x0000000e00070308ULL, 0x000e640000000800ULL,
0x0000000714140220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x0000000514057221ULL, 0x002fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000000ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011600ULL,
0x00005410080e7816ULL, 0x000fe20000000008ULL, 0x0000dd427f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0e087589ULL, 0x0002e400000e0000ULL, 0x000000080f0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000dd927f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0e097589ULL, 0x0002a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100f0c7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e000eULL, 0x000042f000197802ULL, 0x000fe20000000f00ULL,
0x0000001fff187424ULL, 0x000fc400078e00ffULL, 0xffffffffff1d7424ULL, 0x000fc400078e00ffULL,
0x0000e82000007944ULL, 0x00cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180f0c7810ULL, 0x002fe20007ffe0ffULL, 0x0000001fff187424ULL, 0x000fe200078e00ffULL,
0x0000000e00177202ULL, 0x004fe20000000f00ULL, 0xffffffffff1d7424ULL, 0x000fe200078e00ffULL,
0x0000436000197802ULL, 0x000fc40000000f00ULL, 0x0000e7b000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000100006677824ULL, 0x000fe200078e00ffULL, 0x011800006224783bULL, 0x000f280000000200ULL,
0x0000100067677812ULL, 0x000fe200078e0cffULL, 0x011800005c0c783bULL, 0x002e660000000200ULL,
0x0001300068677810ULL, 0x000fc80007ffe067ULL, 0x000000675f4c7211ULL, 0x080fe200078e20ffULL,
0x0000001060507824ULL, 0x100fe200078e0267ULL, 0x0000006758187211ULL, 0x000fe200078e20ffULL,
0x000000105e487824ULL, 0x100fe400078e0267ULL, 0x000000105d287824ULL, 0x100fe200078e0267ULL,
0x000000004c4c783bULL, 0x000ee20000004200ULL, 0x000000105b207824ULL, 0x100fe400078e0267ULL,
0x000000105a1c7824ULL, 0x100fe200078e0267ULL, 0x000000005050783bULL, 0x000ea20000004200ULL,
0x0000001056147824ULL, 0x000fc600078e0267ULL, 0x000000004848783bULL, 0x000ea80000004200ULL,
0x000000002828783bULL, 0x000ea80000004200ULL, 0x000000002020783bULL, 0x000ea80000004200ULL,
0x000000001c1c783bULL, 0x000ea20000004200ULL, 0x0000000824240232ULL, 0x018fc60000000000ULL,
0x000000001818783bULL, 0x004ea20000004200ULL, 0x0000000826260232ULL, 0x080fe40000000000ULL,
0x0000000925250232ULL, 0x080fe20000000000ULL, 0x000000001414783bULL, 0x000ee20000004200ULL,
0x0000000927270232ULL, 0x080fe40000000000ULL, 0x000000080c0c0232ULL, 0x082fe40000000000ULL,
0x000000080e0e0232ULL, 0x000fe40000000000ULL, 0x000000090d0d0232ULL, 0x000fc40000000000ULL,
0x000000090f0f0232ULL, 0x000fe20000000000ULL, 0x0000004c243c723cULL, 0x040ff0000000183cULL,
0x000000502444723cULL, 0x040f700000001844ULL, 0x000000522440723cULL, 0x040f700000001840ULL,
0x0000004e2438723cULL, 0x040f700000001838ULL, 0x000000482434723cULL, 0x040f700000001834ULL,
0x0000004a2430723cULL, 0x040f700000001830ULL, 0x00000028242c723cULL, 0x040f70000000182cULL,
0x0000002a2410723cULL, 0x000f700000001810ULL, 0x000000200c44723cULL, 0x060b700000001844ULL,
0x000000220c40723cULL, 0x040b700000001840ULL, 0x0000001c0c3c723cULL, 0x040b70000000183cULL,
0x0000001e0c38723cULL, 0x040b700000001838ULL, 0x000000180c34723cULL, 0x044b700000001834ULL,
0x0000001a0c30723cULL, 0x040b700000001830ULL, 0x000000140c2c723cULL, 0x048b70000000182cULL,
0x000000160c10723cULL, 0x000b620000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000080590c7811ULL, 0x020fe200078e40ffULL, 0x01b6900061ff7f8cULL, 0x0003e2000c80043fULL,
0x00000001066b7812ULL, 0x000fc400078ec0ffULL, 0x000000550c00720cULL, 0x000fda0003f06070ULL,
0x00002fb000000947ULL, 0x000fea0003800000ULL, 0x00000001590d7810ULL, 0x002fe20007ffe0ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000540d00720cULL, 0x000fe40003f06070ULL,
0x000000c069697810ULL, 0x000fca0007ffe0ffULL, 0x00006200040f7a24ULL, 0x000fcc00078e0269ULL,
0x000005a000008947ULL, 0x000fea0003800000ULL, 0x00000069550c7217ULL, 0x000fe20007800000ULL,
0x000000080b0e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff177819ULL, 0x000fe20000011600ULL,
0x00000100ff207424ULL, 0x000fe400078e00ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a69ULL,
0xfffffff80e1f7812ULL, 0x000fe200078ee263ULL, 0x00000001170d7824ULL, 0x040fe200078e020fULL,
0x0000000017147210ULL, 0x000fe40007ffe0ffULL, 0x000000200c0e7817ULL, 0x000fe20003800000ULL,
0x00005e000d0c7625ULL, 0x000fe200078e0020ULL, 0x0000000417197810ULL, 0x000fc40007ffe0ffULL,
0x00000008171b7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c171d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000119167824ULL, 0x140fe200078e0200ULL, 0x0000000714157812ULL, 0x000fe200078ec0ffULL,
0x0000000819217824ULL, 0x000fe200078e00ffULL, 0x0000000e1700720cULL, 0x000fe20003f06070ULL,
0x000000011b187824ULL, 0x100fe200078e0200ULL, 0x0ffffff815147812ULL, 0x100fe200078ef800ULL,
0x000000011d1e7824ULL, 0x000fe200078e0200ULL, 0x000000031b237819ULL, 0x000fe200000006ffULL,
0x000000081d257824ULL, 0x000fe200078e00ffULL, 0xfffffff821227812ULL, 0x000fe200078ee216ULL,
0x000000101f0c7825ULL, 0x000fe200078e000cULL, 0xfffffff823247812ULL, 0x000fc400078ee218ULL,
0xfffffff8251e7812ULL, 0x000fe200078ee21eULL, 0x0000001014157824ULL, 0x000fe200078e0267ULL,
0x0000001017217810ULL, 0x040fe40007ffe0ffULL, 0x0000001417237810ULL, 0x040fe40007ffe0ffULL,
0x0000001817257810ULL, 0x040fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c157faeULL, 0x0003e2000c101c46ULL, 0x0000001c17277810ULL, 0x000fe20007ffe0ffULL,
0x0000000821297824ULL, 0x000fe200078e00ffULL, 0x0000000e1900720cULL, 0x080fe20003f06070ULL,
0x00000008252a7824ULL, 0x000fe200078e00ffULL, 0x0000000e1b00720cULL, 0x080fe20003f26070ULL,
0x0000000127147824ULL, 0x000fe200078e0200ULL, 0x0000000e1d00720cULL, 0x0c0fe20003f46070ULL,
0x000000011d1d7824ULL, 0x000fe200078e020fULL, 0x0000000e2100720cULL, 0x000fc40003f66070ULL,
0x0000000e2300720cULL, 0x080fe20003f86070ULL, 0x00000001190d7824ULL, 0x102fe200078e020fULL,
0x0000000e2500720cULL, 0x080fe20003fa6070ULL, 0x00000001210c7824ULL, 0x100fe200078e0200ULL,
0x0000000e2700720cULL, 0x000fe20003fc6070ULL, 0x00000001230e7824ULL, 0x000fe200078e0200ULL,
0x0000000f1b177210ULL, 0x080fe20007ffe0ffULL, 0x00000001211b7824ULL, 0x100fe200078e020fULL,
0x0000000f23197210ULL, 0x040fe20007ffe0ffULL, 0x0000000823237824ULL, 0x000fe200078e00ffULL,
0xfffffff829267812ULL, 0x000fe200078ee20cULL, 0x0000000125157824ULL, 0x000fc400078e020fULL,
0x0000000127217824ULL, 0x000fe200078e020fULL, 0x00000000250f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0xfffffff823287812ULL, 0x000fe200078ee20eULL,
0x00005e0017167625ULL, 0x080fe200078e0020ULL, 0xfffffff82a2a7812ULL, 0x000fe400078ee20fULL,
0xfffffff827487812ULL, 0x000fe200078ee214ULL, 0x00005e000d0e7625ULL, 0x080fe200078e0020ULL,
0x0000006724237211ULL, 0x080fe400078e20ffULL, 0x00000067482b7211ULL, 0x000fe200078e20ffULL,
0x00005e001d1c7625ULL, 0x000fc800078e0020ULL, 0x00005e001b1a7625ULL, 0x000fc800078e0020ULL,
0x00005e0019187625ULL, 0x000fc800078e0020ULL, 0x00005e0015147625ULL, 0x000fc800078e0020ULL,
0x00005e00210c7625ULL, 0x000fc800078e0020ULL, 0x0000001022217824ULL, 0x000fe400078e0267ULL,
0x000000101f0e7825ULL, 0x000fc800078e000eULL, 0x000000101f167825ULL, 0x040fe200078e0016ULL,
0x000000000e217faeULL, 0x0003e6000c101c46ULL, 0x000000101f1c7825ULL, 0x040fe200078e001cULL,
0x0000000016237faeULL, 0x0003e6000c901c46ULL, 0x000000101f1a7825ULL, 0x000fc800078e001aULL,
0x000000101f187825ULL, 0x000fc800078e0018ULL, 0x000000101f147825ULL, 0x000fc800078e0014ULL,
0x000000101f0c7825ULL, 0x000fc800078e000cULL, 0x000000101e1f7824ULL, 0x100fe400078e0267ULL,
0x0000001026257824ULL, 0x100fe400078e0267ULL, 0x0000001028277824ULL, 0x100fe200078e0267ULL,
0x000000001c1f7faeULL, 0x0003e2000d101c46ULL, 0x000000102a297824ULL, 0x000fc600078e0267ULL,
0x000000001a257faeULL, 0x0003e8000d901c46ULL, 0x0000000018277faeULL, 0x0003e8000e101c46ULL,
0x0000000014297faeULL, 0x0003e8000e901c46ULL, 0x000000000c2b7faeULL, 0x0003e2000f101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x00000010001e7811ULL, 0x040fe200078fe8ffULL,
0x000000080b267824ULL, 0x000fe200078e00ffULL, 0x0000000400147811ULL, 0x000fc400078fe8ffULL,
0x0000000c001c7811ULL, 0x000fe200078fe8ffULL, 0x000000011e207824ULL, 0x100fe200078e0200ULL,
0x0000000800187811ULL, 0x000fe200078fe8ffULL, 0x000000081e197824ULL, 0x000fe200078e00ffULL,
0x000000001c227210ULL, 0x080fe20007ffe0ffULL, 0x00000001140c7824ULL, 0x000fe200078e0200ULL,
0x00000014000e7811ULL, 0x000fe200078fe8ffULL, 0x00000008140d7824ULL, 0x000fe200078e00ffULL,
0xfffffff819207812ULL, 0x000fe200078ee220ULL, 0x000000081c177824ULL, 0x000fe200078e00ffULL,
0x0000001800197811ULL, 0x000fe200078fe8ffULL, 0x0000000118247824ULL, 0x040fe200078e0200ULL,
0xfffffff80d287812ULL, 0x000fe200078ee20cULL, 0x0000000818157824ULL, 0x000fe200078e00ffULL,
0x0000001c001b7811ULL, 0x000fe200078fe8ffULL, 0x000000080e2a7824ULL, 0x000fe200078e00ffULL,
0x00000000000d7211ULL, 0x000fe200078fe8ffULL, 0x0000000119167824ULL, 0x100fe200078e020fULL,
0xfffffff817227812ULL, 0x000fe200078ee222ULL, 0x000000010e177824ULL, 0x140fe200078e0200ULL,
0x0000000f0e1a7210ULL, 0x080fe20007ffe0ffULL, 0x00000001190e7824ULL, 0x000fe200078e0200ULL,
0xfffffff815247812ULL, 0x000fe200078ee224ULL, 0x000000081b4a7824ULL, 0x000fe200078e00ffULL,
0x0000000f000c7211ULL, 0x000fe200078fe8ffULL, 0x0000000114147824ULL, 0x100fe200078e020fULL,
0x0000010000217802ULL, 0x000fe20000000f00ULL, 0x0000000118187824ULL, 0x100fe200078e020fULL,
0x00000003191d7819ULL, 0x000fe200000006ffULL, 0x000000011b197824ULL, 0x100fe200078e0200ULL,
0x000000070d157812ULL, 0x000fe200078ec0ffULL, 0x000000011c1c7824ULL, 0x000fe200078e020fULL,
0xfffffff826277812ULL, 0x000fe200078ee263ULL, 0x000000011e1e7824ULL, 0x100fe200078e020fULL,
0x0ffffff815267812ULL, 0x000fe200078ef800ULL, 0x000000011b0f7824ULL, 0x000fe200078e020fULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee217ULL, 0x00005e000c0c7625ULL, 0x000fe200078e0021ULL,
0xfffffff81d487812ULL, 0x000fc400078ee20eULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee219ULL,
0x00005e0014147625ULL, 0x000fe200078e0021ULL, 0x0000006728237211ULL, 0x080fe400078e20ffULL,
0x0000006748497211ULL, 0x000fe200078e20ffULL, 0x00005e0018187625ULL, 0x000fc800078e0021ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0021ULL, 0x00005e001e1e7625ULL, 0x000fc800078e0021ULL,
0x00005e001a1a7625ULL, 0x000fc800078e0021ULL, 0x00005e0016167625ULL, 0x000fc800078e0021ULL,
0x00005e000f0e7625ULL, 0x000fc800078e0021ULL, 0x00000010270c7825ULL, 0x000fc800078e000cULL,
0x0000001026217824ULL, 0x000fe400078e0267ULL, 0x0000001027147825ULL, 0x000fc600078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c217faeULL, 0x0003e2000b901c46ULL,
0x0000001024257824ULL, 0x000fe400078e0267ULL, 0x0000001027187825ULL, 0x040fe200078e0018ULL,
0x0000000014237faeULL, 0x0003e6000b901c46ULL, 0x00000010271c7825ULL, 0x040fe200078e001cULL,
0x0000000018257faeULL, 0x0003e6000b901c46ULL, 0x00000010271e7825ULL, 0x000fc800078e001eULL,
0x00000010271a7825ULL, 0x000fc800078e001aULL, 0x0000001027167825ULL, 0x000fc800078e0016ULL,
0x00000010270e7825ULL, 0x000fc800078e000eULL, 0x0000001022277824ULL, 0x100fe400078e0267ULL,
0x0000001020297824ULL, 0x100fe400078e0267ULL, 0x000000102a2b7824ULL, 0x100fe200078e0267ULL,
0x000000001c277faeULL, 0x0003e2000b901c46ULL, 0x000000104a4b7824ULL, 0x000fc600078e0267ULL,
0x000000001e297faeULL, 0x0003e8000b901c46ULL, 0x000000001a2b7faeULL, 0x0003e8000b901c46ULL,
0x0000000016497faeULL, 0x0003e8000b901c46ULL, 0x000000000e4b7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe00a0d7812ULL, 0x002fc400078ec0ffULL,
0x000000100a167812ULL, 0x040fe400078ec0ffULL, 0x000000080a0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000d0c167210ULL, 0x000fe20007ffe016ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6480016147f8cULL, 0x0002a4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x01b64c00160f7984ULL, 0x000ee40000000800ULL, 0x800000000fff7812ULL, 0x00cfe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c177210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000170e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000118187810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b64c00160f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000100660d7810ULL, 0x000fc80007ffe065ULL, 0x0000000d640d7210ULL, 0x000fca0007ffe0ffULL,
0x01b000000d0f7984ULL, 0x000ea80000000800ULL, 0x01b200000d0e7984ULL, 0x0006620000000800ULL,
0x0000006a0f00720bULL, 0x004fe20003f1d000ULL, 0x0000cb727f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x008fc800000e0100ULL, 0x0000ffff14ff7812ULL, 0x000fe2000782c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff697224ULL, 0x000fd400078e006aULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x00000002570c7811ULL, 0x000fe400078ff0ffULL, 0x0000006a0f00720bULL, 0x000fe40003f34000ULL,
0x000000570c00720cULL, 0x000fe20003f05270ULL, 0x0000cb327f007947ULL, 0x000fd4000b800000ULL,
0x0000000000157806ULL, 0x000fc400008e0100ULL, 0x00000066570d8211ULL, 0x000fe200078e38ffULL,
0x0000038000017945ULL, 0x000fe20003800000ULL, 0x0000000f6a0c8209ULL, 0x000fc60007810000ULL,
0x0000000164178824ULL, 0x000fe200078e020dULL, 0x00009910150d7816ULL, 0x000fc800000000ffULL,
0x01b4000c17008388ULL, 0x0005e20000000800ULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000f6a0d7209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff15ff7812ULL, 0x000fc6000780c0ffULL,
0x8000000d6a0c7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00167308ULL, 0x002e640000000800ULL, 0x0000001605057220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011600ULL,
0x0000ca527f007947ULL, 0x000fea000b800000ULL, 0x00001f0c160c7589ULL, 0x0002a400000e0000ULL,
0x0000000c44447220ULL, 0x084fe40000410000ULL, 0x0000000c45457220ULL, 0x080fe40000410000ULL,
0x0000000c40407220ULL, 0x080fe40000410000ULL, 0x0000000c41417220ULL, 0x000fc40000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe40000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe40000410000ULL,
0x0000000c38387220ULL, 0x080fe40000410000ULL, 0x0000000c39397220ULL, 0x080fe40000410000ULL,
0x0000000c34347220ULL, 0x080fe40000410000ULL, 0x0000000c35357220ULL, 0x000fc40000410000ULL,
0x0000000c30307220ULL, 0x080fe40000410000ULL, 0x0000000c31317220ULL, 0x080fe40000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe40000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000c10107220ULL, 0x080fe40000410000ULL, 0x0000000c11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008000c7811ULL, 0x000fe200078ff0ffULL,
0x0000c9627f007947ULL, 0x000fea000b800000ULL, 0x00001f0c160c7589ULL, 0x0004e400000e0000ULL,
0x0000000c46467220ULL, 0x088fe40000410000ULL, 0x0000000c47477220ULL, 0x080fe40000410000ULL,
0x0000000c42427220ULL, 0x080fe40000410000ULL, 0x0000000c43437220ULL, 0x080fe40000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe40000410000ULL, 0x0000000c3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe40000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe40000410000ULL,
0x0000000c36367220ULL, 0x080fe40000410000ULL, 0x0000000c37377220ULL, 0x080fe40000410000ULL,
0x0000000c32327220ULL, 0x080fe40000410000ULL, 0x0000000c33337220ULL, 0x000fc40000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe40000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000c12127220ULL, 0x080fe40000410000ULL, 0x0000000c13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff15ff7812ULL, 0x000fe40007800814ULL,
0x0000000f6a697209ULL, 0x000fd60007810000ULL, 0x800000690f0f0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL, 0x0000000f00070308ULL, 0x000ea40000000800ULL,
0x000000070e0e0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x000000050e057221ULL, 0x002fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000000ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011600ULL,
0x00005410080e7816ULL, 0x000fe20000000008ULL, 0x0000c7c27f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0e087589ULL, 0x0002a400000e0000ULL, 0x000000080f0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000c8127f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0e097589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100f0c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e000eULL, 0x0000001f00187802ULL, 0x000fe20000000f00ULL,
0xffffffffff1d7424ULL, 0x000fe200078e00ffULL, 0x00005af000197802ULL, 0x000fc40000000f00ULL,
0x0000d02000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180f0c7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e000eULL,
0x00005b6000197802ULL, 0x000fe20000000f00ULL, 0x0000001fff187424ULL, 0x000fc400078e00ffULL,
0xffffffffff1d7424ULL, 0x000fc400078e00ffULL, 0x0000cfb000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000000c060c7819ULL, 0x008fe200000006ffULL, 0x012000006224783bULL, 0x000ee60000000200ULL,
0x000010000c6d7812ULL, 0x000fe400078ec0ffULL, 0x012000005c0c783bULL, 0x002e640000000200ULL,
0x00013000686d7810ULL, 0x000fc80007ffe06dULL, 0x0000006d5b207211ULL, 0x000fe200078e20ffULL,
0x0000001060507824ULL, 0x100fe400078e026dULL, 0x000000105f4c7824ULL, 0x100fe400078e026dULL,
0x000000105e487824ULL, 0x100fe200078e026dULL, 0x000000002020783bULL, 0x000fe20000004200ULL,
0x000000105d287824ULL, 0x100fe400078e026dULL, 0x000000105a1c7824ULL, 0x100fe200078e026dULL,
0x000000005050783bULL, 0x000f220000004200ULL, 0x0000001058187824ULL, 0x000fc400078e026dULL,
0x0000001056147824ULL, 0x000fe200078e026dULL, 0x000000004c4c783bULL, 0x000ea80000004200ULL,
0x000000004848783bULL, 0x000ea80000004200ULL, 0x000000002828783bULL, 0x000ea80000004200ULL,
0x000000001c1c783bULL, 0x000ea40000004200ULL, 0x0000000824240232ULL, 0x00cfc40000000000ULL,
0x000000001818783bULL, 0x000ea20000004200ULL, 0x0000000826260232ULL, 0x080fe40000000000ULL,
0x0000000925250232ULL, 0x080fe20000000000ULL, 0x000000001414783bULL, 0x000ee20000004200ULL,
0x0000000927270232ULL, 0x080fe40000000000ULL, 0x000000080c0c0232ULL, 0x082fe40000000000ULL,
0x000000080e0e0232ULL, 0x000fe40000000000ULL, 0x000000090d0d0232ULL, 0x000fc40000000000ULL,
0x000000090f0f0232ULL, 0x000fe20000000000ULL, 0x000000502444723cULL, 0x050f700000001844ULL,
0x000000522440723cULL, 0x040f700000001840ULL, 0x0000004c243c723cULL, 0x040f70000000183cULL,
0x0000004e2438723cULL, 0x040f700000001838ULL, 0x000000482434723cULL, 0x040f700000001834ULL,
0x0000004a2430723cULL, 0x040f700000001830ULL, 0x00000028242c723cULL, 0x040f70000000182cULL,
0x0000002a2410723cULL, 0x000f700000001810ULL, 0x000000200c44723cULL, 0x060b700000001844ULL,
0x000000220c40723cULL, 0x040b700000001840ULL, 0x0000001c0c3c723cULL, 0x040b70000000183cULL,
0x0000001e0c38723cULL, 0x040b700000001838ULL, 0x000000180c34723cULL, 0x044b700000001834ULL,
0x0000001a0c30723cULL, 0x040b700000001830ULL, 0x000000140c2c723cULL, 0x048b70000000182cULL,
0x000000160c10723cULL, 0x000b620000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000c0590c7811ULL, 0x020fe200078e40ffULL, 0x01b6980061ff7f8cULL, 0x0003e2000c80043fULL,
0x00000001066b7812ULL, 0x000fe200078e0cffULL, 0x000000ffff6a7224ULL, 0x000fe200078e0069ULL,
0x000000550c00720cULL, 0x000fda0003f06070ULL, 0x000017a000000947ULL, 0x000fea0003800000ULL,
0x00000300590c7a10ULL, 0x002fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000010c0d7810ULL, 0x040fe40007ffe0ffULL, 0x000000030c157211ULL, 0x000fe400078e40ffULL,
0x000000540d00720cULL, 0x000fc60003f06070ULL, 0x00006200040f7a24ULL, 0x000fd400078e0215ULL,
0x000005a000008947ULL, 0x000fea0003800000ULL, 0x00000015550c7217ULL, 0x000fe20007800000ULL,
0x000000080b0e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff177819ULL, 0x100fe20000011600ULL,
0x00000100ff1f7424ULL, 0x000fe400078e00ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a15ULL,
0xfffffff80e637812ULL, 0x000fe200078ee263ULL, 0x00000001170d7824ULL, 0x040fe200078e0200ULL,
0x0000000f17147210ULL, 0x000fe40007ffe0ffULL, 0x000000200c0e7817ULL, 0x000fc40003800000ULL,
0x0000000417197810ULL, 0x040fe40007ffe0ffULL, 0x00000008171b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c171d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001191e7824ULL, 0x100fe200078e0200ULL,
0x000000070d157812ULL, 0x000fe200078ec0ffULL, 0x00005e00140c7625ULL, 0x000fe200078e001fULL,
0x0000000e1700720cULL, 0x000fe40003f06070ULL, 0x0ffffff815147812ULL, 0x100fe200078ef800ULL,
0x0000000819217824ULL, 0x000fe200078e00ffULL, 0x000000001d207210ULL, 0x000fe20007ffe0ffULL,
0x000000011b227824ULL, 0x040fe200078e0200ULL, 0x0000000e1b00720cULL, 0x040fe20003f26070ULL,
0x000000081b237824ULL, 0x000fe200078e00ffULL, 0xfffffff8211e7812ULL, 0x000fe200078ee21eULL,
0x000000081d257824ULL, 0x000fe200078e00ffULL, 0x0000001017217810ULL, 0x000fe20007ffe0ffULL,
0x00000010630c7825ULL, 0x000fe200078e000cULL, 0xfffffff823227812ULL, 0x000fc400078ee222ULL,
0xfffffff825207812ULL, 0x000fe200078ee220ULL, 0x0000001014157824ULL, 0x000fe200078e026dULL,
0x0000001417237810ULL, 0x000fe20007ffe0ffULL, 0x000000011b167824ULL, 0x100fe200078e020fULL,
0x0000001817257810ULL, 0x000fe20007ffe0ffULL, 0x00000001211c7824ULL, 0x100fe200078e020fULL,
0x0000001c17177810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c157faeULL, 0x0003e2000c101c46ULL, 0x0000000e1900720cULL, 0x080fe20003f06070ULL,
0x0000000123187824ULL, 0x100fe200078e020fULL, 0x0000000e1d00720cULL, 0x080fe20003f46070ULL,
0x0000000125147824ULL, 0x100fe200078e020fULL, 0x0000000e2100720cULL, 0x080fe20003f66070ULL,
0x00000008172a7824ULL, 0x000fe200078e00ffULL, 0x0000000e2300720cULL, 0x080fe20003f86070ULL,
0x0000000821247824ULL, 0x000fe200078e00ffULL, 0x0000000e2500720cULL, 0x080fe20003fa6070ULL,
0x0000000823267824ULL, 0x000fe200078e00ffULL, 0x0000000e1700720cULL, 0x000fe20003fc6070ULL,
0x00000001190e7824ULL, 0x100fe200078e020fULL, 0x0000000f1d1a7210ULL, 0x000fe20007ffe0ffULL,
0x00000001170c7824ULL, 0x002fe200078e020fULL, 0x0000000325287819ULL, 0x040fe200000006ffULL,
0x00000001250f7824ULL, 0x100fe200078e0200ULL, 0x0000000023157210ULL, 0x000fe20007ffe0ffULL,
0x0000000117197824ULL, 0x100fe200078e0200ULL, 0x0000006d20237211ULL, 0x000fe200078e20ffULL,
0x00000001210d7824ULL, 0x000fe200078e0200ULL, 0xfffffff828287812ULL, 0x000fe200078ee20fULL,
0x00005e000e0e7625ULL, 0x000fe200078e001fULL, 0xfffffff82a2a7812ULL, 0x000fc400078ee219ULL,
0xfffffff824247812ULL, 0x000fe200078ee20dULL, 0x00005e0016167625ULL, 0x000fe200078e001fULL,
0xfffffff826267812ULL, 0x000fc600078ee215ULL, 0x00005e001a1a7625ULL, 0x000fc800078e001fULL,
0x00005e001c1c7625ULL, 0x000fc800078e001fULL, 0x00005e0018187625ULL, 0x000fc800078e001fULL,
0x00005e0014147625ULL, 0x000fc800078e001fULL, 0x00005e000c0c7625ULL, 0x000fc800078e001fULL,
0x00000010630e7825ULL, 0x000fc800078e000eULL, 0x000000101e1f7824ULL, 0x000fe400078e026dULL,
0x0000001063167825ULL, 0x000fc600078e0016ULL, 0x000000000e1f7faeULL, 0x0003e2000c101c46ULL,
0x0000001022217824ULL, 0x000fe400078e026dULL, 0x00000010631a7825ULL, 0x000fc600078e001aULL,
0x0000000016217faeULL, 0x0003e2000c901c46ULL, 0x00000010631c7825ULL, 0x000fc600078e001cULL,
0x000000001a237faeULL, 0x0003e2000d101c46ULL, 0x0000001024257824ULL, 0x000fe400078e026dULL,
0x0000001063187825ULL, 0x000fc600078e0018ULL, 0x000000001c257faeULL, 0x0003e2000d901c46ULL,
0x0000001026277824ULL, 0x000fe400078e026dULL, 0x0000001063147825ULL, 0x000fc600078e0014ULL,
0x0000000018277faeULL, 0x0003e2000e101c46ULL, 0x0000001028297824ULL, 0x000fe400078e026dULL,
0x00000010630c7825ULL, 0x000fc600078e000cULL, 0x0000000014297faeULL, 0x0003e2000e901c46ULL,
0x000000102a6d7824ULL, 0x000fca00078e026dULL, 0x000000000c6d7faeULL, 0x0003e2000f101c46ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x0000000800187811ULL, 0x040fe200078fe8ffULL,
0x00000100ff217424ULL, 0x000fe200078e00ffULL, 0x0000000400147811ULL, 0x040fe400078fe8ffULL,
0x00000010001e7811ULL, 0x000fe200078fe8ffULL, 0x0000000118247824ULL, 0x100fe200078e0200ULL,
0x0000000c001c7811ULL, 0x000fe200078fe8ffULL, 0x0000000818157824ULL, 0x000fe200078e00ffULL,
0x000000030b0c7819ULL, 0x000fe200000006ffULL, 0x0000000114267824ULL, 0x000fe200078e0200ULL,
0x00000000000e7211ULL, 0x080fe200078fe8ffULL, 0x00000008140d7824ULL, 0x000fe200078e00ffULL,
0xfffffff815247812ULL, 0x000fe200078ee224ULL, 0x000000011e207824ULL, 0x000fe200078e0200ULL,
0x0000001800157811ULL, 0x000fe200078fe8ffULL, 0x000000081e197824ULL, 0x000fe200078e00ffULL,
0x0000001c001b7811ULL, 0x000fe200078fe8ffULL, 0x000000081c177824ULL, 0x000fe200078e00ffULL,
0xfffffff80d267812ULL, 0x000fe200078ee226ULL, 0x0000000115167824ULL, 0x040fe200078e020fULL,
0xfffffff80c637812ULL, 0x000fe200078ee263ULL, 0x0000000815487824ULL, 0x000fe200078e00ffULL,
0x000000001c227210ULL, 0x080fe20007ffe0ffULL, 0x000000011b1d7824ULL, 0x000fe200078e0200ULL,
0xfffffff819207812ULL, 0x000fe200078ee220ULL, 0x0000000115197824ULL, 0x000fe200078e0200ULL,
0x00000014000d7811ULL, 0x040fe200078fe8ffULL, 0x000000081b4a7824ULL, 0x000fe200078e00ffULL,
0x0000000f000c7211ULL, 0x080fe200078fe8ffULL, 0x0000000118187824ULL, 0x100fe200078e020fULL,
0x0000000f14147210ULL, 0x080fe20007ffe0ffULL, 0x000000011c1c7824ULL, 0x100fe200078e020fULL,
0x000000070e157812ULL, 0x000fe200078ec0ffULL, 0x000000011e1e7824ULL, 0x100fe200078e020fULL,
0xfffffff817227812ULL, 0x000fe200078ee222ULL, 0x000000010d1a7824ULL, 0x040fe200078e020fULL,
0x000000000d177210ULL, 0x040fe20007ffe0ffULL, 0x000000080d2a7824ULL, 0x000fe200078e00ffULL,
0x0000000f1b0f7210ULL, 0x000fe20007ffe0ffULL, 0x00005e000c0c7625ULL, 0x000fe200078e0021ULL,
0x0ffffff815287812ULL, 0x000fc400078ef800ULL, 0xfffffff848487812ULL, 0x000fe200078ee219ULL,
0x00005e0014147625ULL, 0x080fe200078e0021ULL, 0xfffffff84a4a7812ULL, 0x000fe400078ee21dULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee217ULL, 0x00005e0018187625ULL, 0x000fe200078e0021ULL,
0x0000006d24257211ULL, 0x000fc600078e20ffULL, 0x00005e001c1c7625ULL, 0x000fc800078e0021ULL,
0x00005e001e1e7625ULL, 0x000fc800078e0021ULL, 0x00005e001a1a7625ULL, 0x000fc800078e0021ULL,
0x00005e0016167625ULL, 0x000fc800078e0021ULL, 0x00005e000f0e7625ULL, 0x000fc800078e0021ULL,
0x00000010630c7825ULL, 0x000fc800078e000cULL, 0x0000001028217824ULL, 0x000fe400078e026dULL,
0x0000001063147825ULL, 0x000fc600078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c217faeULL, 0x0003e2000b901c46ULL, 0x0000001026237824ULL, 0x000fe400078e026dULL,
0x0000001063187825ULL, 0x000fc600078e0018ULL, 0x0000000014237faeULL, 0x0003e2000b901c46ULL,
0x00000010631c7825ULL, 0x000fc600078e001cULL, 0x0000000018257faeULL, 0x0003e2000b901c46ULL,
0x0000001022277824ULL, 0x000fe400078e026dULL, 0x00000010631e7825ULL, 0x000fc600078e001eULL,
0x000000001c277faeULL, 0x0003e2000b901c46ULL, 0x0000001020297824ULL, 0x000fe400078e026dULL,
0x00000010631a7825ULL, 0x000fc600078e001aULL, 0x000000001e297faeULL, 0x0003e2000b901c46ULL,
0x000000102a2b7824ULL, 0x000fe400078e026dULL, 0x0000001063167825ULL, 0x000fc600078e0016ULL,
0x000000001a2b7faeULL, 0x0003e2000b901c46ULL, 0x0000001048497824ULL, 0x000fe200078e026dULL,
0x0000006d4a6d7211ULL, 0x000fe200078e20ffULL, 0x00000010630e7825ULL, 0x000fc600078e000eULL,
0x0000000016497faeULL, 0x0003e8000b901c46ULL, 0x000000000e6d7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe00a0c7812ULL, 0x042fe400078ec0ffULL,
0x000000100a0d7812ULL, 0x040fe400078ec0ffULL, 0x000000080a0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e167210ULL, 0x000fe20007ffe00dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6680016147f8cULL, 0x0002a4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x01b66c00160f7984ULL, 0x000ee40000000800ULL, 0x800000000fff7812ULL, 0x00cfe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff187224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c177210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000170e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000118187810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b66c00160f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018066657810ULL, 0x000fca0007ffe065ULL, 0x0000000164657824ULL, 0x000fca00078e0265ULL,
0x01b00000650e7984ULL, 0x000ea80000000800ULL, 0x01b2000065147984ULL, 0x0006620000000800ULL,
0x000000690e00720bULL, 0x004fe20003f1d000ULL, 0x0000b5d27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0c1a7812ULL, 0x000fe2000782c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff6a7224ULL, 0x000fd400078e0069ULL, 0x0000044000009947ULL, 0x000fea0003800000ULL,
0x00000003570c7811ULL, 0x000fe400078ff0ffULL, 0x000000690e00720bULL, 0x000fe40003f54000ULL,
0x000000570c00720cULL, 0x000fe20003f25270ULL, 0x0000b5927f007947ULL, 0x000fd4000b800000ULL,
0x00000000000f7806ULL, 0x000fc400010e0100ULL, 0x00000066570d9211ULL, 0x000fe200078e38ffULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x000000690e6a7209ULL, 0x000fe40007810000ULL,
0x000099100f0c7816ULL, 0x000fe200000000ffULL, 0x00000001640d9824ULL, 0x000fca00078e020dULL,
0x01b4006a0d009388ULL, 0x0005e20000000800ULL, 0x000000ff0c00720cULL, 0x000fda0003f25270ULL,
0x0000030000009947ULL, 0x000fea0003800000ULL, 0x000000696a0c7221ULL, 0x004fe20000010100ULL,
0x000000ff0fff7812ULL, 0x000fe2000782c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00167308ULL, 0x002e640000000800ULL,
0x0000001605057220ULL, 0x002fc80000410000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011600ULL, 0x0000b4d27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c160c7589ULL, 0x0002a400000e0000ULL, 0x0000000c44447220ULL, 0x084fe40000410000ULL,
0x0000000c45457220ULL, 0x080fe40000410000ULL, 0x0000000c40407220ULL, 0x080fe40000410000ULL,
0x0000000c41417220ULL, 0x080fe40000410000ULL, 0x0000000c3c3c7220ULL, 0x080fe40000410000ULL,
0x0000000c3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000c38387220ULL, 0x080fe40000410000ULL,
0x0000000c39397220ULL, 0x080fe40000410000ULL, 0x0000000c34347220ULL, 0x080fe40000410000ULL,
0x0000000c35357220ULL, 0x080fe40000410000ULL, 0x0000000c30307220ULL, 0x080fe40000410000ULL,
0x0000000c31317220ULL, 0x000fc40000410000ULL, 0x0000000c2c2c7220ULL, 0x080fe40000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe40000410000ULL, 0x0000000c10107220ULL, 0x080fe40000410000ULL,
0x0000000c11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000fff7812ULL, 0x000fda000782c0ffULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000008000c7811ULL, 0x000fe200078ff0ffULL, 0x0000b3e27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c160c7589ULL, 0x0004e400000e0000ULL, 0x0000000c46467220ULL, 0x088fe40000410000ULL,
0x0000000c47477220ULL, 0x080fe40000410000ULL, 0x0000000c42427220ULL, 0x080fe40000410000ULL,
0x0000000c43437220ULL, 0x080fe40000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe40000410000ULL,
0x0000000c3f3f7220ULL, 0x000fc40000410000ULL, 0x0000000c3a3a7220ULL, 0x080fe40000410000ULL,
0x0000000c3b3b7220ULL, 0x080fe40000410000ULL, 0x0000000c36367220ULL, 0x080fe40000410000ULL,
0x0000000c37377220ULL, 0x080fe40000410000ULL, 0x0000000c32327220ULL, 0x080fe40000410000ULL,
0x0000000c33337220ULL, 0x000fc40000410000ULL, 0x0000000c2e2e7220ULL, 0x080fe40000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe40000410000ULL, 0x0000000c12127220ULL, 0x080fe40000410000ULL,
0x0000000c13137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff1aff7812ULL, 0x000fda000782600fULL, 0x0000000e6a0e1221ULL, 0x000fe20000010100ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b0e0e1820ULL, 0x000fc80000410000ULL,
0x0000000e00071308ULL, 0x000ea40000000800ULL, 0x0000000714141220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000000514057221ULL, 0x002fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000007ff08723eULL, 0x000fe400000000ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011600ULL, 0x00005410080e7816ULL, 0x000fe20000000008ULL,
0x0000b2427f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0e087589ULL, 0x0002a400000e0000ULL,
0x000000080f0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000b2927f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0e097589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100f0c7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200078e000eULL,
0x0000001f00187802ULL, 0x000fe20000000f00ULL, 0xffffffffff1d7424ULL, 0x000fe200078e00ffULL,
0x0000730000197802ULL, 0x000fc40000000f00ULL, 0x0000b81000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180f0c7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x004fe200078e000eULL, 0x0000737000197802ULL, 0x000fe20000000f00ULL,
0x0000001fff187424ULL, 0x000fc400078e00ffULL, 0xffffffffff1d7424ULL, 0x000fc400078e00ffULL,
0x0000b7a000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x012800006224783bULL, 0x000f220000000200ULL,
0x0000006760507211ULL, 0x080fe200078e20ffULL, 0x000000105f4c7824ULL, 0x100fe200078e0267ULL,
0x000000675a1c7211ULL, 0x000fe200078e20ffULL, 0x000000105e487824ULL, 0x100fe200078e0267ULL,
0x012800005c0c783bULL, 0x00ae620000000200ULL, 0x000000105d287824ULL, 0x100fe400078e0267ULL,
0x000000105b207824ULL, 0x100fe200078e0267ULL, 0x000000005050783bULL, 0x000ee20000004200ULL,
0x0000001058187824ULL, 0x000fc400078e0267ULL, 0x0000001056147824ULL, 0x000fe200078e0267ULL,
0x000000004c4c783bULL, 0x000ea80000004200ULL, 0x000000004848783bULL, 0x000ea80000004200ULL,
0x000000002828783bULL, 0x000ea80000004200ULL, 0x000000002020783bULL, 0x000ea80000004200ULL,
0x000000001c1c783bULL, 0x000ea80000004200ULL, 0x000000001818783bULL, 0x000ea80000004200ULL,
0x000000001414783bULL, 0x004ea20000004200ULL, 0x0000000824240232ULL, 0x010fc40000000000ULL,
0x0000000826260232ULL, 0x080fe40000000000ULL, 0x0000000925250232ULL, 0x080fe40000000000ULL,
0x0000000927270232ULL, 0x080fe40000000000ULL, 0x000000080c0c0232ULL, 0x082fe40000000000ULL,
0x000000080e0e0232ULL, 0x000fe40000000000ULL, 0x000000090d0d0232ULL, 0x080fe20000000000ULL,
0x000000502444723cULL, 0x008f620000001844ULL, 0x000000090f0f0232ULL, 0x000fce0000000000ULL,
0x000000522440723cULL, 0x040f700000001840ULL, 0x0000004c243c723cULL, 0x040f70000000183cULL,
0x0000004e2438723cULL, 0x040f700000001838ULL, 0x000000482434723cULL, 0x040f700000001834ULL,
0x0000004a2430723cULL, 0x040f700000001830ULL, 0x00000028242c723cULL, 0x040f70000000182cULL,
0x0000002a2410723cULL, 0x000f700000001810ULL, 0x000000200c44723cULL, 0x060b700000001844ULL,
0x000000220c40723cULL, 0x040b700000001840ULL, 0x0000001c0c3c723cULL, 0x040b70000000183cULL,
0x0000001e0c38723cULL, 0x040b700000001838ULL, 0x000000180c34723cULL, 0x040b700000001834ULL,
0x0000001a0c30723cULL, 0x040b700000001830ULL, 0x000000140c2c723cULL, 0x044b70000000182cULL,
0x000000160c10723cULL, 0x000b620000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x01b6a00061ff7f8cULL, 0x0003e2000c80043fULL, 0x00000001066b7812ULL, 0x000fce00078ec0ffULL,
0x0000030059597a10ULL, 0x002fc80007ffe0ffULL, 0x000000545900720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff9b6000007947ULL, 0x000fea000383ffffULL,
0x0000000000097919ULL, 0x000e620000002500ULL, 0x0000001100087202ULL, 0x020fe20000000f00ULL,
0x000000ffff1a7224ULL, 0x000fe400078e0013ULL, 0x000000ffff197224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fe200078e0010ULL, 0x000000540900720cULL, 0x002fda0003f06070ULL,
0x0000033000000947ULL, 0x000fea0003800000ULL, 0x0180000005007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x000077c0000c7802ULL, 0x000fc40000000f00ULL, 0x0000b1a000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000500007308ULL, 0x000e640000001000ULL,
0xbf80000000047423ULL, 0x002fc80000000005ULL, 0x800000ff04077221ULL, 0x000fc80000010100ULL,
0x0000000700007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000f280000000000ULL, 0x0000000000067919ULL, 0x000e620000000000ULL,
0x00000002ff077819ULL, 0x010fe40000011604ULL, 0x00000008060d7811ULL, 0x002fc600078ff0ffULL,
0x00001f0700047589ULL, 0x00ce6800000e0000ULL, 0x00001f0d00067589ULL, 0x000ea200000e0000ULL,
0x0000004404447220ULL, 0x042fe40000410000ULL, 0x0000004504457220ULL, 0x040fe40000410000ULL,
0x0000004004407220ULL, 0x040fe40000410000ULL, 0x0000004104417220ULL, 0x000fc40000410000ULL,
0x0000003c043c7220ULL, 0x040fe40000410000ULL, 0x0000003d043d7220ULL, 0x040fe40000410000ULL,
0x0000003804387220ULL, 0x040fe40000410000ULL, 0x0000003904397220ULL, 0x040fe40000410000ULL,
0x0000003404347220ULL, 0x040fe40000410000ULL, 0x0000003504357220ULL, 0x000fc40000410000ULL,
0x0000003004307220ULL, 0x040fe40000410000ULL, 0x0000003104317220ULL, 0x040fe40000410000ULL,
0x0000002c042c7220ULL, 0x040fe40000410000ULL, 0x0000002d042d7220ULL, 0x040fe40000410000ULL,
0x0000001104117220ULL, 0x040fe40000410000ULL, 0x0000000804087220ULL, 0x000fc40000410000ULL,
0x0000004606467220ULL, 0x044fe40000410000ULL, 0x0000004706477220ULL, 0x040fe40000410000ULL,
0x0000004206427220ULL, 0x040fe40000410000ULL, 0x0000004306437220ULL, 0x040fe40000410000ULL,
0x0000003e063e7220ULL, 0x040fe40000410000ULL, 0x0000003f063f7220ULL, 0x000fc40000410000ULL,
0x0000003a063a7220ULL, 0x040fe40000410000ULL, 0x0000003b063b7220ULL, 0x040fe40000410000ULL,
0x0000003606367220ULL, 0x040fe40000410000ULL, 0x0000003706377220ULL, 0x040fe40000410000ULL,
0x0000003206327220ULL, 0x040fe40000410000ULL, 0x0000003306337220ULL, 0x000fc40000410000ULL,
0x0000002e062e7220ULL, 0x040fe40000410000ULL, 0x0000002f062f7220ULL, 0x040fe40000410000ULL,
0x0000001906197220ULL, 0x040fe40000410000ULL, 0x0000001a061a7220ULL, 0x000fc40000410000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x000000110811723eULL, 0x000fe400000000ffULL,
0x000000191a19723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000444504723eULL, 0x000fc400000000ffULL, 0x00000040410a723eULL, 0x000fe400000000ffULL,
0x0000003c3d0c723eULL, 0x000fe400000000ffULL, 0x00000038390d723eULL, 0x000fe400000000ffULL,
0x00000034350e723eULL, 0x000fe400000000ffULL, 0x00000030310f723eULL, 0x000fe400000000ffULL,
0x0000002c2d10723eULL, 0x000fc400000000ffULL, 0x00000002ff1e7819ULL, 0x002fe40000011600ULL,
0x00000008002b7811ULL, 0x000fe400078ff0ffULL, 0x000000021e077810ULL, 0x040fe20007ffe0ffULL,
0x000000081e087824ULL, 0x040fe200078e00ffULL, 0x000000011e067810ULL, 0x040fe20007ffe0ffULL,
0x000000081e1d7824ULL, 0x040fe200078e00ffULL, 0x000000031e1c7819ULL, 0x040fe200000006ffULL,
0x000000081e257824ULL, 0x000fe200078e00ffULL, 0xfffffff8081f7812ULL, 0x000fe200078ee207ULL,
0x000000081e217824ULL, 0x040fe200078e00ffULL, 0x000000051e087810ULL, 0x040fe20007ffe0ffULL,
0x000000081e277824ULL, 0x040fe200078e00ffULL, 0x000000041e077810ULL, 0x040fe20007ffe0ffULL,
0x000000081e1b7824ULL, 0x040fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL,
0x000000081e297824ULL, 0x040fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee208ULL,
0x000000082b207824ULL, 0x000fe200078e00ffULL, 0x000000031e067810ULL, 0x000fc40007ffe0ffULL,
0x000000061e1a7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81c237812ULL, 0x000fe200078ee207ULL,
0x000010000b077824ULL, 0x000fe200078e00ffULL, 0x0000000b02087819ULL, 0x000fe400000006ffULL,
0xfffffff821217812ULL, 0x000fe400078ee206ULL, 0xfffffff827277812ULL, 0x000fe200078ee21aULL,
0x00000004001a7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee21eULL,
0x0000000107067824ULL, 0x000fe200078e0208ULL, 0xffffffff1e1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL, 0x000000101d1d7824ULL, 0x100fe200078e0206ULL,
0x000000061b1b7211ULL, 0x080fe200078e20ffULL, 0x000000101f1f7824ULL, 0x000fe200078e0206ULL,
0xfffffff829297812ULL, 0x000fe200078ee21cULL, 0x0000001021217824ULL, 0x100fe200078e0206ULL,
0xfffffff8202b7812ULL, 0x000fe200078ee22bULL, 0x0000001023237824ULL, 0x000fe200078e0206ULL,
0x0000000625257211ULL, 0x000fe200078e20ffULL, 0x000000011b1b7824ULL, 0x000fe200078e021aULL,
0x0000001d1a1d7210ULL, 0x040fe20007ffe0ffULL, 0x0000001027277824ULL, 0x100fe200078e0206ULL,
0x000000464712723eULL, 0x000fe200000000ffULL, 0x000000011a1f7824ULL, 0x040fe200078e021fULL,
0x000000041b007388ULL, 0x000fe20000000800ULL, 0x0000001029297824ULL, 0x100fe200078e0206ULL,
0x000000271a277210ULL, 0x040fe20007ffe0ffULL, 0x000000011a1c7824ULL, 0x040fe200078e0221ULL,
0x0000000a1d007388ULL, 0x000fe20000000800ULL, 0x000000102b2b7824ULL, 0x000fe200078e0206ULL,
0x000000424313723eULL, 0x000fe200000000ffULL, 0x000000011a237824ULL, 0x040fe200078e0223ULL,
0x0000000c1f007388ULL, 0x0003e20000000800ULL, 0x000000011a1e7824ULL, 0x040fe200078e0225ULL,
0x0000003e3f14723eULL, 0x000fe200000000ffULL, 0x000000011a207824ULL, 0x040fe200078e0229ULL,
0x0000000d1c007388ULL, 0x000fe20000000800ULL, 0x000000011a2b7824ULL, 0x000fe200078e022bULL,
0x0000003a3b15723eULL, 0x000fe200000000ffULL, 0x00000001031a7824ULL, 0x000fe200078e0200ULL,
0x0000000e23007388ULL, 0x000fe20000000800ULL, 0x000000363716723eULL, 0x000fc400000000ffULL,
0x000000323317723eULL, 0x000fe200000000ffULL, 0x0000000f1e007388ULL, 0x000fe20000000800ULL,
0x0000002e2f18723eULL, 0x000fe200000000ffULL, 0x000000101a0c7824ULL, 0x002fe200078e0207ULL,
0x00000300001b7a02ULL, 0x000fe20000000f00ULL, 0x0000001027007388ULL, 0x000fe60000000800ULL,
0x000000011b00780cULL, 0x000fe20003f05270ULL, 0x0000001120007388ULL, 0x000fe80000000800ULL,
0x000000122b007388ULL, 0x000fe80000000800ULL, 0x000400131d007388ULL, 0x000fe80000000800ULL,
0x000400141f007388ULL, 0x000fe80000000800ULL, 0x000400151c007388ULL, 0x000fe80000000800ULL,
0x0004001623007388ULL, 0x000fe80000000800ULL, 0x000400171e007388ULL, 0x000fe80000000800ULL,
0x0004001827007388ULL, 0x000fe80000000800ULL, 0x0004001920007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000c287984ULL, 0x000e680000000c00ULL,
0x000400000c2c7984ULL, 0x000ea80000000c00ULL, 0x000800000c107984ULL, 0x000ee80000000c00ULL,
0x000c00000c307984ULL, 0x000f220000000c00ULL, 0x200000ff2b2b7230ULL, 0x002fc40000000000ULL,
0x200000ff2a2a7230ULL, 0x000fe40000000000ULL, 0x200000ff29297230ULL, 0x000fe40000000000ULL,
0x200000ff28287230ULL, 0x000fe40000000000ULL, 0x200000ff2f2f7230ULL, 0x004fe40000000000ULL,
0x200000ff2e2e7230ULL, 0x000fe40000000000ULL, 0x200000ff2d2d7230ULL, 0x000fc40000000000ULL,
0x200000ff2c2c7230ULL, 0x000fe40000000000ULL, 0x000000132b2b7230ULL, 0x008fe40000000000ULL,
0x000000122a2a7230ULL, 0x000fe40000000000ULL, 0x0000001129297230ULL, 0x000fe40000000000ULL,
0x0000001028287230ULL, 0x000fe40000000000ULL, 0x000000332f2f7230ULL, 0x010fc40000000000ULL,
0x000000322e2e7230ULL, 0x000fe20000000000ULL, 0x000000280c007388ULL, 0x000fe20000000c00ULL,
0x000000312d2d7230ULL, 0x000fe40000000000ULL, 0x000000302c2c7230ULL, 0x000fca0000000000ULL,
0x0004002c0c007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00002a1000008947ULL, 0x000fea0003800000ULL, 0x00005800ff047624ULL, 0x000fe200078e00ffULL,
0x0000000000187919ULL, 0x000e660000002700ULL, 0x0000640004047a24ULL, 0x000fe200078e02ffULL,
0x0000000000137919ULL, 0x000e680000002600ULL, 0x0000000f04117811ULL, 0x040fe200078e10ffULL,
0x0000030004047a24ULL, 0x000fe200078e02ffULL, 0x000000000c0c7984ULL, 0x000ea40000000c00ULL,
0xfffffff011117812ULL, 0x000fca00078ec0ffULL, 0x0000008004107824ULL, 0x000fc800078e0211ULL,
0x0000008004047824ULL, 0x000fca00078e0210ULL, 0x0000007f04047810ULL, 0x000fe20007ffe0ffULL,
0x0000580018187a24ULL, 0x002fc600078e0213ULL, 0xffffff8004047812ULL, 0x000fe200078ec0ffULL,
0x00000300180a7a24ULL, 0x000fc600078e02ffULL, 0x0000680004127a10ULL, 0x000fe20007f1e0ffULL,
0x000000010a097824ULL, 0x000fc600078e0209ULL, 0x00006900ff147a10ULL, 0x000fe400007fe4ffULL,
0x0000000102ff7812ULL, 0x000fe4000780f857ULL, 0x0000001209127211ULL, 0x000fc800078258ffULL,
0x0000001409137211ULL, 0x000fe400008f5cffULL, 0x0000680011197a10ULL, 0x000fc60007f3e0ffULL,
0x000004000b127825ULL, 0x000fcc00078e0012ULL, 0x000000101a127825ULL, 0x000fc800078e0012ULL,
0x00006900ff1a7624ULL, 0x000fe200008e06ffULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x0000001000147824ULL, 0x004fe200078e00ffULL, 0x00000001ff167819ULL, 0x000fe20000011600ULL,
0x0000008009157824ULL, 0x000fe200078e00ffULL, 0x00000019ff097819ULL, 0x000fe40000011609ULL,
0x0000007014147812ULL, 0x000fe400078ec0ffULL, 0x0000000c16177812ULL, 0x000fe400078ec0ffULL,
0x0000680015167a10ULL, 0x000fc40007ebe010ULL, 0x0000001914157210ULL, 0x000fe40007a3e015ULL,
0x0000001617167210ULL, 0x000fe40007c7e014ULL, 0x00006900091c7a10ULL, 0x000fe40002fec4ffULL,
0x0000001517147210ULL, 0x000fe40007fbe0ffULL, 0x0000001aff097210ULL, 0x000fe40000fe4409ULL,
0x0000001cff177210ULL, 0x000fc60001fe84ffULL, 0x000000ffff157224ULL, 0x000fca00028e0609ULL,
0x0000006a14007986ULL, 0x0003e8000c101906ULL, 0x0000000516007986ULL, 0x0003e4000c101906ULL,
0x000000ff0000720cULL, 0x004fe20000705670ULL, 0x0000000c12007986ULL, 0x000fe2000c101d06ULL,
0x0000014000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000ff00000000000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000004000d7802ULL, 0x000fe40000000f00ULL,
0xffffffff1b057810ULL, 0x002fc60007ffe0ffULL, 0x00006800180c7625ULL, 0x000fe200078e000dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x000000050c0c79a8ULL, 0x000ea400099ee1c6ULL,
0x000000050c00720cULL, 0x004fc80003f05270ULL, 0x00000001ff097807ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000009ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000ff057984ULL, 0x002e640000000000ULL, 0x000000ff0500720cULL, 0x002fda0003f05270ULL,
0x000025d000008947ULL, 0x000fea0003800000ULL, 0x000000ff5700720cULL, 0x000fda0003f05270ULL,
0x00000a5000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x000001b000008947ULL, 0x000fea0003800000ULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x00000001ff097819ULL, 0x000fe40000011600ULL, 0x000000190a0c7211ULL, 0x040fe400078038ffULL,
0x00000070050d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fe400078ec0ffULL,
0x0000001a0a057211ULL, 0x000fe400000f3cffULL, 0x0000000c090c7210ULL, 0x000fc8000791e00dULL,
0x00000005ff0d7210ULL, 0x000fca00007e24ffULL, 0x000000060c057981ULL, 0x000328000c1e1900ULL,
0x000080060c0e7981ULL, 0x000322000c1e1900ULL, 0x000000021b00780cULL, 0x000fda0003f05270ULL,
0x000000f000008947ULL, 0x000fea0003800000ULL, 0x000100060c127981ULL, 0x002322000c1e1900ULL,
0x000000041b00780cULL, 0x000fda0003f06070ULL, 0x000000c000008947ULL, 0x000fea0003800000ULL,
0x000180060c147981ULL, 0x002322000c1e1900ULL, 0x000000041b00780cULL, 0x000fda0003f05270ULL,
0x0000009000008947ULL, 0x000fea0003800000ULL, 0x000200060c167981ULL, 0x002322000c1e1900ULL,
0x000000061b00780cULL, 0x000fda0003f06070ULL, 0x0000006000008947ULL, 0x000fea0003800000ULL,
0x000280060c187981ULL, 0x002322000c1e1900ULL, 0x000000061b00780cULL, 0x000fda0003f05270ULL,
0x0000003000008947ULL, 0x000fea0003800000ULL, 0x000000081b00780cULL, 0x002fe20003f06070ULL,
0x000300060c1a7981ULL, 0x000318000c1e1900ULL, 0x000380060c1c0981ULL, 0x000324000c1e1900ULL,
0x000000071b097810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff097819ULL, 0x000fc80000011609ULL,
0x000000ff0900720cULL, 0x000fda0003f05270ULL, 0x000007d000008947ULL, 0x000fea0003800000ULL,
0x000000110a0f7211ULL, 0x040fe200078038ffULL, 0x000000ffff157224ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1e7224ULL, 0x010fe200078e0005ULL,
0x000068000f0f7a10ULL, 0x000fe40007f3e0ffULL, 0x000000ff0a137211ULL, 0x000fe400000f3cffULL,
0x000007800f0f7810ULL, 0x000fc80007f5e0ffULL, 0x00006900ff137a10ULL, 0x000fc400017e2413ULL,
0x0000030015007a0cULL, 0x000fe20003f26070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x0000000409007c0cULL, 0x000fcc000bf03070ULL, 0x000006d000001947ULL, 0x012fea0003800000ULL,
0x00000008150c7810ULL, 0x040fe40007ffe0ffULL, 0x00000001150d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001e05057209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011600ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c0f0c7210ULL, 0x000fc80007f3e0ffULL, 0x00000013ff0d7210ULL, 0x000fca0000ffe4ffULL,
0xfffc80060c1e7981ULL, 0x000328000c1e1900ULL, 0x000005f000002947ULL, 0x000fea0003800000ULL,
0x00000009150c7810ULL, 0x042fe40007ffe0ffULL, 0x00000002150d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000000e05057209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011600ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c0f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0613ULL,
0xfffd00060c0e7981ULL, 0x000326000c1e1900ULL, 0x0000051000002947ULL, 0x000fea0003800000ULL,
0x0000000a150c7810ULL, 0x042fe40007ffe0ffULL, 0x00000003150d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001205057209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011600ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c0f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0613ULL,
0xfffd80060c127981ULL, 0x000326000c1e1900ULL, 0x0000043000002947ULL, 0x000fea0003800000ULL,
0x0000000b150c7810ULL, 0x042fe40007ffe0ffULL, 0x00000004150d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001405057209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000004000c7819ULL, 0x000fe400000006ffULL, 0x00000001ff0d7819ULL, 0x000fe40000011600ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c0f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0613ULL,
0xfffe00060c147981ULL, 0x000326000c1e1900ULL, 0x0000035000002947ULL, 0x000fea0003800000ULL,
0x0000000c150c7810ULL, 0x042fe40007ffe0ffULL, 0x00000005150d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001605057209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011600ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c0f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0613ULL,
0xfffe80060c167981ULL, 0x000326000c1e1900ULL, 0x0000027000002947ULL, 0x000fea0003800000ULL,
0x0000000d150c7810ULL, 0x042fe40007ffe0ffULL, 0x00000006150d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001805057209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011600ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c0f0c7210ULL, 0x000fc80007f3e0ffULL, 0x00000013ff0d7210ULL, 0x000fca0000ffe4ffULL,
0xffff00060c187981ULL, 0x000328000c1e1900ULL, 0x0000019000002947ULL, 0x000fea0003800000ULL,
0x0000000e150c7810ULL, 0x042fe40007ffe0ffULL, 0x00000007150d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001a05057209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011600ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c0f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0613ULL,
0xffff80060c1a7981ULL, 0x000326000c1e1900ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000000f150c7810ULL, 0x002fe40007ffe0ffULL, 0x0000001c05057209ULL, 0x000fe40007810000ULL,
0x000003000c007a0cULL, 0x000fda0003f26070ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010000c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011600ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c0f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0613ULL,
0x000000060c1c7981ULL, 0x000326000c1e1900ULL, 0x000004000f0f7810ULL, 0x000fe40007f3e0ffULL,
0x0000000815157810ULL, 0x000fe40007ffe0ffULL, 0x00000013ff137210ULL, 0x000fe20000ffe4ffULL,
0xfffff8b000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x0000001000097824ULL, 0x004fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x002fc80000011600ULL,
0x0000007009097812ULL, 0x000fe400078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fca00078ec0ffULL,
0x00000001090c7824ULL, 0x000fca00078e020cULL, 0x000000050c007388ULL, 0x0103e40000000800ULL,
0x0000680004047a10ULL, 0x000fe20007f3e0ffULL, 0x0000000102157824ULL, 0x000fe200078e020aULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x00000010000f7824ULL, 0x000fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x00006900ff057624ULL, 0x002fe200008e06ffULL,
0x0000000a0b097819ULL, 0x000fe200000006ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000800150c7825ULL, 0x000fe200078e0004ULL, 0x000000700f0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000c12147812ULL, 0x000fe200078ec0ffULL,
0x0000000202138824ULL, 0x140fe200078e020bULL, 0x00000001020e7812ULL, 0x040fe200078ec0ffULL,
0x0000000202178824ULL, 0x000fe200078e020bULL, 0x000000090c127210ULL, 0x000fe20007f3e0ffULL,
0x000000010f147824ULL, 0x000fe200078e0214ULL, 0x00000800080f7812ULL, 0x000fe200078ec0ffULL,
0x0000200002087824ULL, 0x000fe200078e0207ULL, 0x0000000e17178211ULL, 0x000fe200078e08ffULL,
0x0000000213218824ULL, 0x000fe200078e020eULL, 0x0000002000197810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200008e060dULL, 0x00006800100c7a10ULL, 0x000fe20007f3e0ffULL,
0x00000001080f7824ULL, 0x000fe200078e020fULL, 0x00006800110d7a10ULL, 0x000fe20007f5e0ffULL,
0x0000000817178824ULL, 0x100fe200078e0200ULL, 0x00006900ff0e7a10ULL, 0x000fe20000ffe4ffULL,
0x00000010001f7824ULL, 0x000fe200078e020fULL, 0x0000000c151a8211ULL, 0x040fe200078238ffULL,
0x00006900ff0f7624ULL, 0x000fe200010e06ffULL, 0x0000000d151c8211ULL, 0x000fe200078438ffULL,
0x0000000821238824ULL, 0x000fe200078e0200ULL, 0x0000000e151b8211ULL, 0x000fe200008f3cffULL,
0x0000001019187825ULL, 0x100fe200078e0012ULL, 0x0000030002007a0cULL, 0x000fe20003f26070ULL,
0x0000000014107984ULL, 0x0002a20000000800ULL, 0x0000000f151d8211ULL, 0x000fe200010f3cffULL,
0x0000001000127825ULL, 0x040fe200078e0012ULL, 0x0000458017218811ULL, 0x000fe200078e20ffULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000418023238811ULL, 0x000fe200078e20ffULL,
0x00000010001a8825ULL, 0x040fe200078e001aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000121f7faeULL, 0x0007e2000b901c46ULL, 0x000000ff00117202ULL, 0x000fe20000000f00ULL,
0x0000000000147805ULL, 0x002fe2000001ff00ULL, 0x00000010001c8825ULL, 0x000fe200078e001cULL,
0x00380000181f7faeULL, 0x0003e2000b901c46ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000000001a218faeULL, 0x0009e2000b901c46ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x000000001c238faeULL, 0x0009e2000b901c46ULL, 0x0000000000127805ULL, 0x008fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000187805ULL, 0x002fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x010fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x00000c0000001947ULL, 0x000fea0003800000ULL,
0x000000ffff117224ULL, 0x000fe400078e00ffULL, 0x000000ffff327224ULL, 0x000fca00078e0002ULL,
0x0000000132337810ULL, 0x000fc80007ffe0ffULL, 0x0000030033007a0cULL, 0x000fda0003f06070ULL,
0x0000022000000947ULL, 0x000fea0003800000ULL, 0x000000070000780cULL, 0x000fe20003f64070ULL,
0x000000010a3d7824ULL, 0x000fe200078e0233ULL, 0x0000000133367812ULL, 0x040fe200078ec0ffULL,
0x0000080033337824ULL, 0x000fe200078e00ffULL, 0x00000020003f7810ULL, 0x000fe20007ffe0ffULL,
0x000008003d347825ULL, 0x000fc600078e0004ULL, 0x0000080033337812ULL, 0x000fca00078ec0ffULL,
0x0000000b0237b211ULL, 0x040fe200078e08ffULL, 0x000000020239b824ULL, 0x000fe200078e020bULL,
0x0000000c3d3ab211ULL, 0x000fe200078238ffULL, 0x0000000108337824ULL, 0x000fe400078e0233ULL,
0x000000023939b824ULL, 0x100fe200078e0236ULL, 0x0000000e3d3bb211ULL, 0x000fe200008f3cffULL,
0x000000023741b824ULL, 0x000fe200078e0236ULL, 0x0000000934367210ULL, 0x000fe20007f1e0ffULL,
0x0000001000337824ULL, 0x040fe200078e0233ULL, 0x0000000d3d34b211ULL, 0x000fe200078438ffULL,
0x000000084141b824ULL, 0x000fe200078e0200ULL, 0x00000035ff377210ULL, 0x000fe200007fe4ffULL,
0x00000010003ab825ULL, 0x000fe200078e003aULL, 0x0000000f3d35b211ULL, 0x000fc600010f3cffULL,
0x00000008393db824ULL, 0x000fe400078e0200ULL, 0x000000103f387825ULL, 0x100fe200078e0036ULL,
0x00004180413fb811ULL, 0x000fe400078e20ffULL, 0x000045803d3db811ULL, 0x000fe200078e20ffULL,
0x0000001000367825ULL, 0x000fc800078e0036ULL, 0x000000100034b825ULL, 0x000fe200078e0034ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000036337faeULL, 0x0003e8000b901c46ULL,
0x0038000038337faeULL, 0x0003e8000b901c46ULL, 0x000000003a3dbfaeULL, 0x0003e8000b901c46ULL,
0x00000000343fbfaeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000008032337824ULL, 0x002fe200078e00ffULL, 0x0000000b02367211ULL, 0x000fe200078e08ffULL,
0x0000001000347824ULL, 0x000fe200078e00ffULL, 0x00000001ff357819ULL, 0x000fc40000011600ULL,
0x0000008033337812ULL, 0x000fe400078ec0ffULL, 0x0000007034347812ULL, 0x000fe400078ec0ffULL,
0x0000000c35357812ULL, 0x000fe200078ec0ffULL, 0x0000010036337824ULL, 0x000fe200078e0033ULL,
0x00000002ff437819ULL, 0x000fc80000011600ULL, 0x0000003335347210ULL, 0x000fe20007ffe034ULL,
0x0000000843397824ULL, 0x040fe200078e00ffULL, 0x0000000143367810ULL, 0x040fe20007ffe0ffULL,
0x0000000843387824ULL, 0x040fe200078e00ffULL, 0x0000000843457810ULL, 0x040fe20007ffe0ffULL,
0x0000000843407824ULL, 0x040fe200078e00ffULL, 0x0000000b32337819ULL, 0x000fe200000006ffULL,
0x00000008433f7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800034357984ULL, 0x000e620000000800ULL, 0xfffffff8393c7812ULL, 0x000fe200078ee236ULL,
0x0000000400367824ULL, 0x000fe200078e00ffULL, 0x0000080033337812ULL, 0x000fe200078ec0ffULL,
0x00458000343a7984ULL, 0x0007220000000800ULL, 0x00000008453e7824ULL, 0x000fe200078e00ffULL,
0x0000000243377810ULL, 0x040fe20007ffe0ffULL, 0x0000000843427824ULL, 0x040fe200078e00ffULL,
0x0000000c36467812ULL, 0x000fe200078ec0ffULL, 0x00000008434a7824ULL, 0x040fe200078e00ffULL,
0x0000018008337810ULL, 0x000fe20007ffe033ULL, 0x00000008434c7824ULL, 0x000fe200078e00ffULL,
0xfffffff838347812ULL, 0x008fc400078ee243ULL, 0xfffffff83e367812ULL, 0x000fe400078ee245ULL,
0xfffffff840407812ULL, 0x000fe200078ee237ULL, 0x0000001034347824ULL, 0x000fe200078e0233ULL,
0x0000003336367211ULL, 0x000fe400078e20ffULL, 0x00000003433b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000146347824ULL, 0x040fe200078e0234ULL, 0x00000005433d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000146387824ULL, 0x000fe200078e0236ULL, 0x0000000443367810ULL, 0x000fc40007ffe0ffULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee23dULL, 0x0000000034347984ULL, 0x000fe20000000800ULL,
0xfffffff83f487812ULL, 0x000fe400078ee236ULL, 0x00000003433d7819ULL, 0x000fe200000006ffULL,
0x00000000383e7984ULL, 0x000ee20000000800ULL, 0x0000000232327810ULL, 0x000fc80007ffe0ffULL,
0x0000030032007a0cULL, 0x000fe20003f06070ULL, 0x0000003510357221ULL, 0x006fc80000010100ULL,
0x3fb8aa3b35377820ULL, 0x000fe20000410000ULL, 0x000000333c357211ULL, 0x000fe400078e20ffULL,
0xfffffff8423c7812ULL, 0x000fe200078ee23bULL, 0x0000003700397308ULL, 0x0003220000000800ULL,
0xffffffff433b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000146357824ULL, 0x000fca00078e0235ULL,
0x0000000035367984ULL, 0x000fe20000000800ULL, 0x0000001040377824ULL, 0x002fc600078e0233ULL,
0x00040000353f7984ULL, 0x000fe20000000800ULL, 0x0000000146377824ULL, 0x000fe400078e0237ULL,
0x0000003a39427220ULL, 0x010fe20000410000ULL, 0x00000006433a7810ULL, 0x000fe20007ffe0ffULL,
0x000000103c397824ULL, 0x000fe200078e0233ULL, 0x0000000037387984ULL, 0x000fe20000000800ULL,
0x0000003142317221ULL, 0x000fe20000010000ULL, 0xfffffff83d3c7812ULL, 0x000fe200078ee23aULL,
0x00000010483a7824ULL, 0x000fe200078e0233ULL, 0x00001f4542447589ULL, 0x00066200000e0000ULL,
0x0000000146397824ULL, 0x000fe200078e0239ULL, 0xfffffff84c487812ULL, 0x000fe200078ee23bULL,
0x00000001463a7824ULL, 0x000fe200078e023aULL, 0x00001f4342437589ULL, 0x000ea200000e0000ULL,
0x000000334a3b7211ULL, 0x000fe200078e20ffULL, 0x000000103c3c7824ULL, 0x000fc400078e0233ULL,
0x0000000039357984ULL, 0x000f220000000800ULL, 0x00000010483d7824ULL, 0x000fe200078e0233ULL,
0x2000003eff457230ULL, 0x008fe20000004100ULL, 0x00000001463b7824ULL, 0x040fe200078e023bULL,
0x000000003a337984ULL, 0x000ee20000000800ULL, 0x0000003c463c7210ULL, 0x040fe20007ffe0ffULL,
0x00000001463d7824ULL, 0x000fe200078e023dULL, 0x30000034ff467230ULL, 0x000fe20000004100ULL,
0x000400003a427984ULL, 0x000ee20000000800ULL, 0x3000003eff3e7230ULL, 0x000fc60000004100ULL,
0x0004000037407984ULL, 0x0004e80000000800ULL, 0x0004000039417984ULL, 0x000ee20000000800ULL,
0x000000443e2d7223ULL, 0x082fe2000001002dULL, 0x20000036ff3e7230ULL, 0x000fe20000004100ULL,
0x00000044452e7223ULL, 0x080fe2000001002eULL, 0x20000034ff377230ULL, 0x004fe20000004100ULL,
0x000400003b397984ULL, 0x000e620000000800ULL, 0x30000036ff367230ULL, 0x000fe20000004100ULL,
0x000000433e2c7223ULL, 0x080fe2000001002cULL, 0x2000003fff457230ULL, 0x100fe20000004100ULL,
0x000000003b347984ULL, 0x000ea20000000800ULL, 0x0000004337307223ULL, 0x080fe20000010030ULL,
0x3000003fff3f7230ULL, 0x000fe20000004100ULL, 0x00000043362b7223ULL, 0x080fe2000001002bULL,
0x000000003c377984ULL, 0x000ea20000000800ULL, 0x20000038ff3e7230ULL, 0x100fe20000004100ULL,
0x00000043462f7223ULL, 0x000fe2000001002fULL, 0x30000038ff387230ULL, 0x000fe20000004100ULL,
0x000400003c3a7984ULL, 0x0008a20000000800ULL, 0x000000443f297223ULL, 0x000fc40000010029ULL,
0x00000044452a7223ULL, 0x000fe2000001002aULL, 0x000000003d367984ULL, 0x000ea20000000800ULL,
0x0000004338277223ULL, 0x080fe20000010027ULL, 0x30000035ff387230ULL, 0x110fe40000004100ULL,
0x000400003d3b7984ULL, 0x0008a20000000800ULL, 0x20000035ff3c7230ULL, 0x000fe20000004100ULL,
0x000000433e287223ULL, 0x080fe20000010028ULL, 0x20000033ff357230ULL, 0x108fe20000004100ULL,
0x0000004338237223ULL, 0x080fe20000010023ULL, 0x30000033ff387230ULL, 0x000fe20000004100ULL,
0x000000433c247223ULL, 0x000fc40000010024ULL, 0x0000004335207223ULL, 0x080fe20000010020ULL,
0x20000042ff357230ULL, 0x000fe20000004100ULL, 0x00000043381f7223ULL, 0x000fe2000001001fULL,
0x20000040ff3f7230ULL, 0x100fe40000004100ULL, 0x30000040ff407230ULL, 0x000fe20000004100ULL,
0x00000044351e7223ULL, 0x080fe2000001001eULL, 0x20000041ff3d7230ULL, 0x110fe20000004100ULL,
0x000000443f267223ULL, 0x080fe20000010026ULL, 0x30000041ff417230ULL, 0x000fe20000004100ULL,
0x0000004440257223ULL, 0x080fe20000010025ULL, 0x30000042ff427230ULL, 0x000fe20000004100ULL,
0x000000443d227223ULL, 0x080fe20000010022ULL, 0x20000039ff357230ULL, 0x102fe20000004100ULL,
0x0000004441217223ULL, 0x080fe20000010021ULL, 0x30000039ff397230ULL, 0x000fe20000004100ULL,
0x00000044421d7223ULL, 0x080fe2000001001dULL, 0x20000034ff337230ULL, 0x104fe20000004100ULL,
0x00000044351a7223ULL, 0x080fe2000001001aULL, 0x30000034ff347230ULL, 0x000fe20000004100ULL,
0x0000004439197223ULL, 0x000fc40000010019ULL, 0x00000043331c7223ULL, 0x080fe2000001001cULL,
0x20000037ff337230ULL, 0x100fe20000004100ULL, 0x00000043341b7223ULL, 0x080fe2000001001bULL,
0x2000003aff357230ULL, 0x000fe40000004100ULL, 0x30000037ff347230ULL, 0x000fe20000004100ULL,
0x0000004333187223ULL, 0x080fe20000010018ULL, 0x20000036ff337230ULL, 0x000fe20000004100ULL,
0x0000004435167223ULL, 0x080fe20000010016ULL, 0x3000003aff3a7230ULL, 0x000fe20000004100ULL,
0x0000004334177223ULL, 0x080fe20000010017ULL, 0x2000003bff357230ULL, 0x100fe20000004100ULL,
0x0000004333147223ULL, 0x000fe20000010014ULL, 0x30000036ff367230ULL, 0x000fe20000004100ULL,
0x000000443a157223ULL, 0x080fe20000010015ULL, 0x3000003bff3b7230ULL, 0x000fe20000004100ULL,
0x0000004435127223ULL, 0x000fc40000010012ULL, 0x0000004336137223ULL, 0x000fe40000010013ULL,
0x000000443b117223ULL, 0x000fe20000010011ULL, 0xfffff42000008947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x000000ff0b00720cULL, 0x000fe20003f05270ULL,
0x0000001000047824ULL, 0x002fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fc80000011600ULL,
0x0000007004087812ULL, 0x000fe400078ec0ffULL, 0x0000000c000d7812ULL, 0x000fca00078ec0ffULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e640000000000ULL,
0x0000001000047824ULL, 0x002fe200078e00ffULL, 0x00000001ff007819ULL, 0x000fc80000011600ULL,
0x0000007004057812ULL, 0x000fe400078ec0ffULL, 0x0000000c00097812ULL, 0x000fc600078ec0ffULL,
0x0000008002007824ULL, 0x000fca00078e0205ULL, 0x0000000009007210ULL, 0x000fca0007ffe0ffULL,
0x0049803100007388ULL, 0x0003e40000000800ULL, 0x0000000108087824ULL, 0x000fe200078e020dULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0049800008007984ULL, 0x002e620000000800ULL,
0x0000012000007945ULL, 0x000fe60003800000ULL, 0x004a000008057984ULL, 0x000ee20000000800ULL,
0x00000000ff007221ULL, 0x002fc80000010000ULL, 0x0000000500007221ULL, 0x008fca0000010000ULL,
0x0180000000047810ULL, 0x000fc80007ffe0ffULL, 0x7f80000004047812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0400780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x000fe200078e0000ULL,
0x0000a260000c7802ULL, 0x000fc40000000f00ULL, 0x0000870000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff047224ULL, 0x00cfe200078e0000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000000057308ULL, 0x000e640000001000ULL, 0xbf80000000047423ULL, 0x002fc80000000005ULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x0000000405047223ULL, 0x000fc40000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000ee80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff097819ULL, 0x008fc40000011600ULL,
0x00000008000d7811ULL, 0x000fe400078ff0ffULL, 0x00000004090c7810ULL, 0x040fe20007ffe0ffULL,
0x00001f0904057589ULL, 0x002e6200000e0000ULL, 0x0000000809357824ULL, 0x040fe200078e00ffULL,
0x0000000309317819ULL, 0x040fe200000006ffULL, 0x0000000809337824ULL, 0x040fe200078e00ffULL,
0x00001f0d04087589ULL, 0x00072200000e0000ULL, 0x00000003090a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000809377824ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee20cULL,
0x00000008090c7824ULL, 0x000fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe200078ee20aULL,
0x00000008093b7824ULL, 0x040fe200078e00ffULL, 0x0000000309397819ULL, 0x000fe200000006ffULL,
0x0000001035357824ULL, 0x100fe200078e0206ULL, 0xffffffff090a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001033337824ULL, 0x000fe200078e0206ULL, 0x0000000109047810ULL, 0x008fc40007ffe0ffULL,
0xfffffff80c0f7812ULL, 0x000fe200078ee209ULL, 0x000000080d0c7824ULL, 0x000fc800078e00ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0206ULL, 0xfffffff80c0d7812ULL, 0x000fe200078ee20dULL,
0x0000003005307220ULL, 0x042fe40000410000ULL, 0x0000002f052f7220ULL, 0x040fe40000410000ULL,
0x0000002c052c7220ULL, 0x040fe40000410000ULL, 0x0000002b052b7220ULL, 0x000fe20000410000ULL,
0x000000302f2f723eULL, 0x000fe200000000ffULL, 0x0000002805287220ULL, 0x000fc40000410000ULL,
0x0000002705277220ULL, 0x000fe20000410000ULL, 0x0000002c2b2b723eULL, 0x000fe200000000ffULL,
0x0000002405247220ULL, 0x040fe40000410000ULL, 0x0000002305237220ULL, 0x000fe20000410000ULL,
0x000000282727723eULL, 0x000fe200000000ffULL, 0x0000002005207220ULL, 0x040fe40000410000ULL,
0x0000001f051f7220ULL, 0x000fe20000410000ULL, 0x000000242323723eULL, 0x000fe200000000ffULL,
0x0000001c051c7220ULL, 0x000fc40000410000ULL, 0x0000001b051b7220ULL, 0x000fe20000410000ULL,
0x000000201f1f723eULL, 0x000fe200000000ffULL, 0x0000001805187220ULL, 0x040fe40000410000ULL,
0x0000001705177220ULL, 0x000fe20000410000ULL, 0x0000001c1b1b723eULL, 0x000fe200000000ffULL,
0x0000001405147220ULL, 0x040fe40000410000ULL, 0x0000001305057220ULL, 0x000fe20000410000ULL,
0x000000181717723eULL, 0x000fe200000000ffULL, 0x0000000809137824ULL, 0x000fc400078e00ffULL,
0x0000002e082e7220ULL, 0x050fe20000410000ULL, 0x000000140505723eULL, 0x000fe200000000ffULL,
0x0000002d082d7220ULL, 0x040fe20000410000ULL, 0xfffffff813137812ULL, 0x000fe200078ee204ULL,
0x0000002a082a7220ULL, 0x040fe20000410000ULL, 0x0000000509047810ULL, 0x000fe20007ffe0ffULL,
0x0000002908297220ULL, 0x040fe20000410000ULL, 0x0000000613137211ULL, 0x000fe200078e20ffULL,
0x0000002608267220ULL, 0x040fe20000410000ULL, 0x0000002e2d2d723eULL, 0x000fe200000000ffULL,
0x0000002508257220ULL, 0x040fe20000410000ULL, 0x0000002a2929723eULL, 0x000fe200000000ffULL,
0x0000002208227220ULL, 0x000fc40000410000ULL, 0x0000002108217220ULL, 0x040fe20000410000ULL,
0x000000262525723eULL, 0x000fe200000000ffULL, 0x0000001e081e7220ULL, 0x040fe40000410000ULL,
0x0000001d081d7220ULL, 0x040fe20000410000ULL, 0x000000222121723eULL, 0x000fe200000000ffULL,
0x0000001a081a7220ULL, 0x040fe40000410000ULL, 0x0000001908197220ULL, 0x040fe20000410000ULL,
0x0000001e1d1d723eULL, 0x000fe200000000ffULL, 0x0000001608167220ULL, 0x000fc40000410000ULL,
0x0000001508157220ULL, 0x040fe20000410000ULL, 0x0000001a1919723eULL, 0x000fe200000000ffULL,
0x0000001208127220ULL, 0x040fe40000410000ULL, 0x0000001108117220ULL, 0x000fe20000410000ULL,
0x0000000209087810ULL, 0x000fe20007ffe0ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0206ULL,
0x000000161515723eULL, 0x000fe400000000ffULL, 0xfffffff831317812ULL, 0x000fe400078ee208ULL,
0x0000000609087810ULL, 0x000fc40007ffe0ffULL, 0xfffffff837097812ULL, 0x000fe200078ee204ULL,
0x0000000400047824ULL, 0x000fe200078e00ffULL, 0xfffffff839377812ULL, 0x000fe200078ee208ULL,
0x0000001031317824ULL, 0x000fe200078e0206ULL, 0xfffffff83b397812ULL, 0x000fe200078ee20aULL,
0x0000001009097824ULL, 0x100fe200078e0206ULL, 0x0000000c04047812ULL, 0x000fe400078ec0ffULL,
0x0000000637377211ULL, 0x000fe200078e20ffULL, 0x0000001039397824ULL, 0x000fe200078e0206ULL,
0x00000031040a7210ULL, 0x040fe20007ffe0ffULL, 0x000000010f067824ULL, 0x000fe200078e0204ULL,
0x000000121111723eULL, 0x000fe200000000ffULL, 0x0000000104087824ULL, 0x040fe200078e0213ULL,
0x0000003904187210ULL, 0x040fe20007ffe0ffULL, 0x0000000104107824ULL, 0x044fe200078e0233ULL,
0x0000002f06007388ULL, 0x0003e20000000800ULL, 0x0000000104127824ULL, 0x000fc400078e0235ULL,
0x0000000104147824ULL, 0x040fe200078e0209ULL, 0x0000002b08007388ULL, 0x000fe20000000800ULL,
0x0000000104167824ULL, 0x040fe400078e0237ULL, 0x0000000104047824ULL, 0x000fe200078e020dULL,
0x000000270a007388ULL, 0x000fe20000000800ULL, 0x0000000103067824ULL, 0x002fc600078e0200ULL,
0x0000002310007388ULL, 0x000fe20000000800ULL, 0x0000001006067824ULL, 0x000fc600078e0207ULL,
0x0000001f12007388ULL, 0x000fe80000000800ULL, 0x0000001b14007388ULL, 0x000fe80000000800ULL,
0x0000001716007388ULL, 0x000fe80000000800ULL, 0x0000000518007388ULL, 0x000fe80000000800ULL,
0x0000002d04007388ULL, 0x000fe80000000800ULL, 0x0004002908007388ULL, 0x000fe80000000800ULL,
0x000400250a007388ULL, 0x000fe80000000800ULL, 0x0004002110007388ULL, 0x000fe80000000800ULL,
0x0004001d12007388ULL, 0x000fe80000000800ULL, 0x0004001914007388ULL, 0x000fe80000000800ULL,
0x0004001516007388ULL, 0x000fe80000000800ULL, 0x0004001118007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000060c7984ULL, 0x000e680000000c00ULL,
0x0004000006247984ULL, 0x000ea80000000c00ULL, 0x0008000006287984ULL, 0x000ee80000000c00ULL,
0x000c0000062c7984ULL, 0x000f220000000c00ULL, 0x200000ff0f0f7230ULL, 0x002fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x004fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fc40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x0000002b0f0f7230ULL, 0x008fe40000000000ULL,
0x0000002a0e0e7230ULL, 0x000fe40000000000ULL, 0x000000290d0d7230ULL, 0x000fe40000000000ULL,
0x000000280c0c7230ULL, 0x000fe40000000000ULL, 0x0000002f27277230ULL, 0x010fc40000000000ULL,
0x0000002e26267230ULL, 0x000fe20000000000ULL, 0x0000000c06007388ULL, 0x000fe20000000c00ULL,
0x0000002d25257230ULL, 0x000fe40000000000ULL, 0x0000002c24247230ULL, 0x000fca0000000000ULL,
0x0004002406007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000002000157810ULL, 0x000fe20007ffe0ffULL, 0x0000000000037919ULL, 0x000e620000002600ULL,
0x00000003ff057819ULL, 0x100fe20000011600ULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x00000003ff047819ULL, 0x000fe20000011615ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x000000080b0a7824ULL, 0x000fe200078e00ffULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000105067824ULL, 0x000fe200078e0200ULL, 0x0000000415027210ULL, 0x000fc80007ffe0ffULL,
0x0000000706097812ULL, 0x000fe400078ec0ffULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0ffffff809087812ULL, 0x100fe400078ef800ULL, 0x0ffffff802067812ULL, 0x000fe400078ef815ULL,
0x000000030b097819ULL, 0x000fe200000006ffULL, 0x0000001008027824ULL, 0x100fe400078e0207ULL,
0x0000001006067824ULL, 0x000fe200078e0207ULL, 0xfffffff809097812ULL, 0x000fe200078ee200ULL,
0x0000000803087824ULL, 0x042fe200078e00ffULL, 0x00000000020c7984ULL, 0x0002e20000000c00ULL,
0x0000000803077824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x004fc4000f8e023fULL,
0x0000000006107984ULL, 0x0005220000000c00ULL, 0xfffffff808037812ULL, 0x000fe400078ee205ULL,
0xfffffff807047812ULL, 0x000fe400078ee204ULL, 0x0000000403037c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000404057c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff80a077812ULL, 0x000fe200078ee215ULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005a0003027a11ULL, 0x002fe200078040ffULL,
0x000000ffff067224ULL, 0x004fe200008e06ffULL, 0x00005a0005047a11ULL, 0x000fc400078240ffULL,
0x00005b0003037a11ULL, 0x000fe400000f4408ULL, 0x00005b0005057a11ULL, 0x000fc600008f4406ULL,
0x0000001009027825ULL, 0x000fc800078e0002ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000000c02007986ULL, 0x008fe8000c101d06ULL, 0x0000001004007986ULL, 0x010fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000159037810ULL, 0x000fe20007ffe0ffULL, 0x000000020e027824ULL, 0x000fe200078e00ffULL,
0x0000000657047819ULL, 0x000fe200000006ffULL, 0x01b60000ff067f8cULL, 0x002e62000c80043fULL,
0x000000540300720cULL, 0x000fe20003f06070ULL, 0x0000580002027a24ULL, 0x000fc400078e020fULL,
0x0000010059097824ULL, 0x000fc800078e0204ULL, 0x0000620002037a24ULL, 0x000fcc00078e0209ULL,
0x00000b8000008947ULL, 0x000fea0003800000ULL, 0x0000000955087217ULL, 0x000fe40007800000ULL,
0x00000003ff297819ULL, 0x000fc60000011600ULL, 0x00000001081e7824ULL, 0x000fe200078e0a09ULL,
0x0000000829097810ULL, 0x000fe20007ffe0ffULL, 0x00000001030a7824ULL, 0x000fe200078e0229ULL,
0x00000004290d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c290f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000809207824ULL, 0x040fe200078e00ffULL, 0x00000000090b7210ULL, 0x000fe20007ffe0ffULL,
0x000000010d087824ULL, 0x140fe200078e0200ULL, 0x0000001e0d00720cULL, 0x0c0fe20003f86070ULL,
0x000000080d117824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee20bULL,
0x000000010f0c7824ULL, 0x000fe200078e0200ULL, 0x0000001e0900720cULL, 0x000fe20003f46070ULL,
0x000000080f137824ULL, 0x000fe200078e00ffULL, 0xfffffff811127812ULL, 0x000fe200078ee208ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0005ULL, 0x0000007010087812ULL, 0x000fc400078ec0ffULL,
0x0000001029117810ULL, 0x000fe20007ffe0ffULL, 0x00000001030e7824ULL, 0x000fe200078e0209ULL,
0xfffffff813227812ULL, 0x000fe400078ee20cULL, 0x0000000d030c7210ULL, 0x000fe20007ffe0ffULL,
0x00000001110d7824ULL, 0x040fe200078e0200ULL, 0x0000000a08147210ULL, 0x000fe20007f1e0ffULL,
0x0000000811247824ULL, 0x000fe200078e00ffULL, 0x0000001429137810ULL, 0x040fe40007ffe0ffULL,
0x0000000029097210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200000e060bULL,
0xfffffff824247812ULL, 0x000fe200078ee20dULL, 0x00005e000c0a7625ULL, 0x000fe200078e0005ULL,
0x0000001e0f00720cULL, 0x000fc40003f66070ULL, 0x0000001e1100720cULL, 0x000fe20003f06070ULL,
0x00005e000e0c7625ULL, 0x000fe200078e0005ULL, 0x0000000a08167210ULL, 0x040fe40007f3e0ffULL,
0x0000000f030e7210ULL, 0x040fe20007ffe0ffULL, 0x0000000103107824ULL, 0x040fe200078e0213ULL,
0x0000000c08187210ULL, 0x000fe20007fbe0ffULL, 0x00000001030c7824ULL, 0x000fe200078e0211ULL,
0x00000018291d7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200008e060bULL,
0x0000000709117812ULL, 0x000fe200078ec0ffULL, 0x000000ffff197224ULL, 0x000fe200028e060dULL,
0x0000100057097811ULL, 0x000fe200078e70ffULL, 0x00005e000c0c7625ULL, 0x000fe200078e0005ULL,
0x0000001c29277810ULL, 0x000fc40007ffe0ffULL, 0x00000000131c7210ULL, 0x000fe20007ffe0ffULL,
0x00005e000e0a7625ULL, 0x080fe200078e0005ULL, 0x0000000c080c7210ULL, 0x000fe40007fbe0ffULL,
0x0000002029237810ULL, 0x000fe20007ffe0ffULL, 0x00005e00100e7625ULL, 0x000fe200078e0005ULL,
0x0000000a081a7210ULL, 0x040fe40007f3e0ffULL, 0x0ffffff811107812ULL, 0x000fe200078ef800ULL,
0x000000ffff0d7224ULL, 0x000fe200028e060dULL, 0x0000000e080a7210ULL, 0x000fe20007fde0ffULL,
0x00000001030e7824ULL, 0x000fe200078e021dULL, 0x0000001e2900720cULL, 0x080fe20003fa6070ULL,
0x000000ffff1b7224ULL, 0x000fe200008e060bULL, 0x0000001e1300720cULL, 0x000fe20003f26070ULL,
0x000000ffff0b7224ULL, 0x000fc400030e060fULL, 0x00005e000e0e7625ULL, 0x000fc800078e0005ULL,
0x00000010101f7824ULL, 0x100fe200078e0209ULL, 0x0000002703107210ULL, 0x000fe20007ffe0ffULL,
0x0000001012217824ULL, 0x000fe200078e0209ULL, 0x0000000e080e7210ULL, 0x000fe20007fde0ffULL,
0x0000000813137824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141f7faeULL, 0x0005e2000e901c46ULL, 0x00005e0010107625ULL, 0x000fe200078e0005ULL,
0x0000001e1d00720cULL, 0x000fe40003fa6070ULL, 0x0000000016217faeULL, 0x0007e2000e101c46ULL,
0xfffffff813267812ULL, 0x000fe200078ee21cULL, 0x000000ffff0f7224ULL, 0x000fe200030e060fULL,
0x00000010081c7210ULL, 0x000fe20007fde0ffULL, 0x0000000103127824ULL, 0x000fe200078e0223ULL,
0x0000001e2700720cULL, 0x0c0fe20003f86070ULL, 0x0000000127107824ULL, 0x140fe200078e0200ULL,
0x0000000327277819ULL, 0x000fe200000006ffULL, 0x0000001020157824ULL, 0x104fe200078e0209ULL,
0x00000024291f7810ULL, 0x000fe20007ffe0ffULL, 0x000000011d257824ULL, 0x000fe200078e0200ULL,
0xfffffff8272a7812ULL, 0x000fe200078ee210ULL, 0x0000001022177824ULL, 0x008fe200078e0209ULL,
0x0000000018157faeULL, 0x0005e2000d101c46ULL, 0x000000081d287824ULL, 0x000fe200078e00ffULL,
0x0000001f03107210ULL, 0x000fe20007ffe0ffULL, 0x00005e0012127625ULL, 0x000fe200078e0005ULL,
0x000000001a177faeULL, 0x0007e2000d901c46ULL, 0x0000001e2300720cULL, 0x000fc40003f66070ULL,
0x0000000123147824ULL, 0x140fe200078e0200ULL, 0xfffffff828287812ULL, 0x000fe200078ee225ULL,
0x0000000823237824ULL, 0x000fe200078e00ffULL, 0x0000001e1f00720cULL, 0x040fe20003f46070ULL,
0x000000011f167824ULL, 0x040fe200078e0200ULL, 0x0000000924157211ULL, 0x084fe200078e20ffULL,
0x000000ffff1d7224ULL, 0x000fe200030e0611ULL, 0x0000001208127210ULL, 0x000fe20007fde0ffULL,
0x000000081f1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff823147812ULL, 0x000fe200078ee214ULL,
0x0000001026177824ULL, 0x108fe200078e0209ULL, 0x0000002829217810ULL, 0x000fe20007ffe0ffULL,
0x0000001028197824ULL, 0x100fe200078e0209ULL, 0xfffffff81f167812ULL, 0x000fe200078ee216ULL,
0x000000102a1b7824ULL, 0x000fe200078e0209ULL, 0x000000000c157faeULL, 0x0005e2000c101c46ULL,
0x000000ffff137224ULL, 0x000fe200030e0613ULL, 0x00000009141f7211ULL, 0x000fe200078e20ffULL,
0x00005e0010107625ULL, 0x000fe200078e0005ULL, 0x000000000a177faeULL, 0x0007e2000c901c46ULL,
0x0000002c29237810ULL, 0x000fc40007ffe0ffULL, 0x0000003029257810ULL, 0x000fe20007ffe0ffULL,
0x000000000e197faeULL, 0x0009e2000e901c46ULL, 0x0000001008107210ULL, 0x000fe20007fde0ffULL,
0x0000000823187824ULL, 0x000fe200078e00ffULL, 0x0000003829277810ULL, 0x000fe20007ffe0ffULL,
0x000000001c1b7faeULL, 0x0003e2000e101c46ULL, 0x00000023030c7210ULL, 0x004fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200030e0611ULL, 0x0000003429157810ULL, 0x000fe20007ffe0ffULL,
0x00000001210a7824ULL, 0x148fe200078e0200ULL, 0x00000000121f7faeULL, 0x0005e2000d901c46ULL,
0x00000008210b7824ULL, 0x000fe200078e00ffULL, 0x0000001e2500720cULL, 0x080fe20003f86070ULL,
0x00000001230f7824ULL, 0x010fe200078e0200ULL, 0x0000003c29177810ULL, 0x000fe20007ffe0ffULL,
0x00005e000c0c7625ULL, 0x000fe200078e0005ULL, 0x0000001e2100720cULL, 0x000fc40003fc6070ULL,
0xfffffff818187812ULL, 0x000fe200078ee20fULL, 0x00000008151c7824ULL, 0x002fe200078e00ffULL,
0x0000001e2300720cULL, 0x080fe20003fa6070ULL, 0x0000000125147824ULL, 0x000fe200078e0200ULL,
0x0000001e1500720cULL, 0x080fe20003f66070ULL, 0x0000001016137824ULL, 0x004fe200078e0209ULL,
0xfffffff80b167812ULL, 0x000fe200078ee20aULL, 0x00000001030a7824ULL, 0x000fe200078e0221ULL,
0x0000001e2700720cULL, 0x000fe20003f26070ULL, 0x0000000103127824ULL, 0x000fe200078e0225ULL,
0x0000000010137faeULL, 0x0003e2000d101c46ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0005ULL,
0x0000000325257819ULL, 0x000fc400000006ffULL, 0x0000001e1700720cULL, 0x000fe20003f06070ULL,
0x00000001031e7824ULL, 0x000fe200078e0217ULL, 0x0000000a080e7210ULL, 0x040fe40007f5e0ffULL,
0xfffffff8251a7812ULL, 0x000fe400078ee214ULL, 0x0000000327207819ULL, 0x000fe200000006ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e060bULL, 0x0000000c08107210ULL, 0x002fe20007f5e0ffULL,
0x00005e00120a7625ULL, 0x000fc600078e0005ULL, 0x0000000dff117210ULL, 0x000fe200017fe4ffULL,
0x00000001030c7824ULL, 0x000fe200078e0215ULL, 0x0000000a08127210ULL, 0x000fe20007f5e0ffULL,
0x0000000115137824ULL, 0x000fe400078e0200ULL, 0x00005e000c0c7625ULL, 0x000fc600078e0005ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee213ULL, 0x00000001030a7824ULL, 0x000fe400078e0227ULL,
0x000000ffff137224ULL, 0x000fe200010e060bULL, 0x0000000c08147210ULL, 0x000fe20007f5e0ffULL,
0x0000000127037824ULL, 0x100fe400078e0200ULL, 0x00000001170c7824ULL, 0x000fe400078e0200ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0005ULL, 0xfffffff820007812ULL, 0x000fc400078ee203ULL,
0x0000000916037211ULL, 0x000fe200078e20ffULL, 0x0000000817177824ULL, 0x000fe400078e00ffULL,
0x000000ffff157224ULL, 0x000fe200010e060dULL, 0x0000000a080a7210ULL, 0x000fe20007f5e0ffULL,
0x000000101c197824ULL, 0x000fe200078e0209ULL, 0xfffffff817207812ULL, 0x000fe200078ee20cULL,
0x00005e001e0c7625ULL, 0x000fe200078e0005ULL, 0x000000000e037faeULL, 0x0003e4000f101c46ULL,
0x00000009201d7211ULL, 0x000fe200078e20ffULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x0000000c08087210ULL, 0x000fe20007f5e0ffULL, 0x0000001018057824ULL, 0x000fc400078e0209ULL,
0x000000101a177824ULL, 0x100fe400078e0209ULL, 0x00000010001b7824ULL, 0x000fe200078e0209ULL,
0x0000000010057faeULL, 0x0003e2000e901c46ULL, 0x000000ffff097224ULL, 0x000fc600010e060dULL,
0x0000000012177faeULL, 0x0003e8000e101c46ULL, 0x0000000014197faeULL, 0x0003e8000d901c46ULL,
0x000000000a1b7faeULL, 0x0003e8000c901c46ULL, 0x00000000081d7faeULL, 0x0003e2000c101c46ULL,
0x00000a4000007947ULL, 0x000fea0003800000ULL, 0x0000000800147811ULL, 0x040fe400078fe8ffULL,
0x0000001000187811ULL, 0x000fc400078fe8ffULL, 0x0000000c00167811ULL, 0x000fe200078fe8ffULL,
0x0000000114097824ULL, 0x100fe200078e0200ULL, 0x0000000400127811ULL, 0x000fe200078fe8ffULL,
0x00000001180b7824ULL, 0x100fe200078e0200ULL, 0x00000003140c7819ULL, 0x000fe200000006ffULL,
0x00000008180e7824ULL, 0x000fe200078e00ffULL, 0x0000001800207811ULL, 0x000fe200078fe8ffULL,
0x00000001160a7824ULL, 0x100fe200078e0200ULL, 0x00000014001a7811ULL, 0x000fe200078fe8ffULL,
0x00000008162f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80c2d7812ULL, 0x000fe200078ee209ULL,
0x0000000112087824ULL, 0x100fe200078e0200ULL, 0xfffffff80e317812ULL, 0x000fe200078ee20bULL,
0x00000008122b7824ULL, 0x000fe200078e00ffULL, 0x0000002000097811ULL, 0x000fe200078fe8ffULL,
0x00000001200b7824ULL, 0x000fe200078e0200ULL, 0x0000001c00217811ULL, 0x000fe200078fe8ffULL,
0x00000008200e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee20aULL,
0x000000081a337824ULL, 0x000fe200078e00ffULL, 0x00000028000d7811ULL, 0x000fe200078fe8ffULL,
0x0000000809117824ULL, 0x000fe200078e00ffULL, 0x000000001a0a7210ULL, 0x000fe20007ffe0ffULL,
0x00000001210c7824ULL, 0x000fe200078e0200ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee208ULL,
0x0000000109087824ULL, 0x000fe200078e0200ULL, 0xfffffff80e357812ULL, 0x000fe200078ee20bULL,
0x000000080d157824ULL, 0x000fe200078e00ffULL, 0x00000024000b7811ULL, 0x000fc400078fe8ffULL,
0x0000000321377819ULL, 0x000fe400000006ffULL, 0xfffffff833337812ULL, 0x000fe200078ee20aULL,
0x000000080b137824ULL, 0x000fe200078e00ffULL, 0x0000002c000f7811ULL, 0x040fe200078fe8ffULL,
0x0000000103247824ULL, 0x000fe200078e020bULL, 0x0000003000197811ULL, 0x040fe400078fe8ffULL,
0x000000000d0a7210ULL, 0x080fe20007ffe0ffULL, 0x000000080f177824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee208ULL, 0x000000010b087824ULL, 0x000fe200078e0200ULL,
0xfffffff837377812ULL, 0x000fe200078ee20cULL, 0x000000010f0c7824ULL, 0x000fe200078e0200ULL,
0xfffffff815157812ULL, 0x000fe200078ee20aULL, 0x00000001190e7824ULL, 0x000fe200078e0200ULL,
0x00000000000a7211ULL, 0x040fe200078fe8ffULL, 0x00000001032a7824ULL, 0x000fe200078e020fULL,
0x00000003191b7819ULL, 0x000fe200000006ffULL, 0x00000001032c7824ULL, 0x000fe200078e0219ULL,
0x00000034001c7811ULL, 0x000fc400078fe8ffULL, 0x00000038001d7811ULL, 0x040fe400078fe8ffULL,
0x0000003c001e7811ULL, 0x000fe200078fe8ffULL, 0x00000001032e7824ULL, 0x000fe200078e021cULL,
0xfffffff813137812ULL, 0x000fe200078ee208ULL, 0x0000000103307824ULL, 0x000fe200078e021dULL,
0xfffffff817177812ULL, 0x000fe200078ee20cULL, 0x00000001140c7824ULL, 0x100fe200078e0203ULL,
0x0000000300087211ULL, 0x080fe200078fe8ffULL, 0x0000000103327824ULL, 0x000fe200078e021eULL,
0x000000070a1f7812ULL, 0x000fe200078ec0ffULL, 0x00000001120a7824ULL, 0x100fe200078e0203ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee20eULL, 0x00000001160e7824ULL, 0x100fe200078e0203ULL,
0x000000031a147210ULL, 0x000fe20007ffe0ffULL, 0x0000000118127824ULL, 0x100fe200078e0203ULL,
0x0000000d03267210ULL, 0x000fe20007ffe0ffULL, 0x0000000120167824ULL, 0x100fe200078e0203ULL,
0x0000007010107812ULL, 0x000fe200078ec0ffULL, 0x0000000121187824ULL, 0x000fe200078e0203ULL,
0x0ffffff81f1f7812ULL, 0x100fe200078ef800ULL, 0x00000001031a7824ULL, 0x000fe200078e0209ULL,
0x000000001e037210ULL, 0x000fe20007ffe0ffULL, 0x000000011c0b7824ULL, 0x040fe200078e0200ULL,
0x000000031c1c7819ULL, 0x000fe200000006ffULL, 0x00005e0008087625ULL, 0x000fc800078e0005ULL,
0x000000081e1e7824ULL, 0x000fe200078e00ffULL, 0x0000001008087210ULL, 0x000fe20007f1e0ffULL,
0x000000011d0d7824ULL, 0x040fe200078e0200ULL, 0xfffffff81c007812ULL, 0x000fe200078ee20bULL,
0x000000081d207824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1c7812ULL, 0x000fe200078ee203ULL,
0x00005e000a0a7625ULL, 0x080fe200078e0005ULL, 0x00001000571e7811ULL, 0x000fe400078e70ffULL,
0xfffffff820197812ULL, 0x000fe200078ee20dULL, 0x00005e000c0c7625ULL, 0x000fe200078e0005ULL,
0x0000001e2d2d7211ULL, 0x000fc400078e20ffULL, 0x0000001e37377211ULL, 0x000fe200078e20ffULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x000000100a0a7210ULL, 0x080fe20007f1e0ffULL,
0x00000010133b7824ULL, 0x100fe200078e021eULL, 0x000000100c0c7210ULL, 0x000fe20007f3e0ffULL,
0x00005e0012127625ULL, 0x000fe200078e0005ULL, 0x0000001e1b417211ULL, 0x000fe400078e20ffULL,
0x0000000dff0d7210ULL, 0x000fe20000ffe4ffULL, 0x00000010153d7824ULL, 0x000fe400078e021eULL,
0x00005e0014147625ULL, 0x000fc800078e0005ULL, 0x000000101c477824ULL, 0x100fe400078e021eULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x00000010121c7210ULL, 0x000fe20007f1e0ffULL,
0x00000010173f7824ULL, 0x100fe400078e021eULL, 0x000000101f037824ULL, 0x100fe400078e021eULL,
0x000000102b2b7824ULL, 0x100fe400078e021eULL, 0x000000102f2f7824ULL, 0x100fe200078e021eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008037faeULL, 0x0005e2000b901c46ULL,
0x0000001031317824ULL, 0x000fc400078e021eULL, 0x0000001033337824ULL, 0x100fe200078e021eULL,
0x000000000a2b7faeULL, 0x0005e2000b901c46ULL, 0x0000001035357824ULL, 0x100fe400078e021eULL,
0x0000001011397824ULL, 0x100fe200078e021eULL, 0x000000000c2d7faeULL, 0x0005e2000b901c46ULL,
0x0000001000437824ULL, 0x100fe400078e021eULL, 0x0000001019457824ULL, 0x000fe200078e021eULL,
0x00000010141e7210ULL, 0x000fe20007f3e0ffULL, 0x00005e0016167625ULL, 0x000fc800078e0005ULL,
0x00005e0018187625ULL, 0x000fc800078e0005ULL, 0x00005e000e0e7625ULL, 0x000fc800078e0005ULL,
0x000000ffff1d7224ULL, 0x000fe200000e0613ULL, 0x0000001016207210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200008e0615ULL, 0x0000001018227210ULL, 0x080fe20007f3e0ffULL,
0x00005e001a127625ULL, 0x000fe200078e0005ULL, 0x000000100e0e7210ULL, 0x000fe40007f5e0ffULL,
0x00000019ff237210ULL, 0x000fe20000ffe4ffULL, 0x00005e0024147625ULL, 0x000fc800078e0005ULL,
0x00005e00261a7625ULL, 0x000fe200078e0005ULL, 0x0000001014267210ULL, 0x000fc60007f3e0ffULL,
0x000000ffff217224ULL, 0x000fe200000e0617ULL, 0x0000001012247210ULL, 0x000fe20007f1e0ffULL,
0x00005e002a167625ULL, 0x000fc800078e0005ULL, 0x000000ffff0f7224ULL, 0x000fe200010e060fULL,
0x000000101a287210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff257224ULL, 0x000fe200000e0613ULL,
0x0000001016167210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff277224ULL, 0x000fe200008e0615ULL,
0x000000000e2f7faeULL, 0x0005e2000b901c46ULL, 0x00005e002c127625ULL, 0x000fc600078e0005ULL,
0x000000001c317faeULL, 0x0005e2000b901c46ULL, 0x00005e002e147625ULL, 0x000fc600078e0005ULL,
0x000000001e337faeULL, 0x0005e2000b901c46ULL, 0x000000ffff297224ULL, 0x000fe200010e061bULL,
0x0000001014147210ULL, 0x080fe20007f3e0ffULL, 0x00005e0030187625ULL, 0x080fe200078e0005ULL,
0x0000000020357faeULL, 0x0005e6000b901c46ULL, 0x00005e00321a7625ULL, 0x000fe200078e0005ULL,
0x0000001018187210ULL, 0x080fe20007f5e0ffULL, 0x0000000022377faeULL, 0x0005e4000b901c46ULL,
0x000000ffff177224ULL, 0x000fe200000e0617ULL, 0x0000001012127210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff157224ULL, 0x000fe200008e0615ULL, 0x000000101a107210ULL, 0x000fe20007f7e0ffULL,
0x0000000024397faeULL, 0x0005e2000b901c46ULL, 0x00000013ff137210ULL, 0x000fe200007fe4ffULL,
0x000000ffff197224ULL, 0x000fc400010e0619ULL, 0x00000000263b7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff117224ULL, 0x000fc600018e061bULL, 0x00000000283d7faeULL, 0x0005e8000b901c46ULL,
0x00000000163f7faeULL, 0x0005e8000b901c46ULL, 0x0000000012417faeULL, 0x0005e8000b901c46ULL,
0x0000000014437faeULL, 0x0005e8000b901c46ULL, 0x0000000018457faeULL, 0x0005e8000b901c46ULL,
0x0000000010477faeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x006fc40000015200ULL, 0x01b60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fc40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a08037210ULL, 0x000fc80007f1e1ffULL, 0x0000000b090a7210ULL, 0x000fe400007fe5ffULL,
0x003d09000300780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400300780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140aULL, 0x0000000300007211ULL, 0x000fca00078110ffULL,
0x000000ffff037224ULL, 0x000fca00000e060aULL, 0x0000000200007819ULL, 0x000fc80000001203ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000105057810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000545900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x000e620000000000ULL,
0x0001b688570b7811ULL, 0x040fe200078e18ffULL, 0x0000002057097824ULL, 0x000fe200078e00ffULL,
0xffffffff54567810ULL, 0x000fc40007ffe0ffULL, 0x0000010059087824ULL, 0x000fe200078e0204ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000085500720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x00cfea0003800000ULL, 0x0000000159037810ULL, 0x000fe20007ffe0ffULL,
0x0000620002057a24ULL, 0x000fc600078e0208ULL, 0x000000540300720cULL, 0x000fda0003f06070ULL,
0x00000a9000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1c7819ULL, 0x102fe2000001160aULL,
0x00000100ff677424ULL, 0x000fe200078e00ffULL, 0x0ffffff80a667812ULL, 0x000fe400078ec0ffULL,
0x000000081c107810ULL, 0x040fe40007ffe0ffULL, 0x0000001c1c1a7810ULL, 0x040fe40007ffe0ffULL,
0x0000000c1c127810ULL, 0x000fe20007ffe0ffULL, 0x0000000110037824ULL, 0x100fe200078e020aULL,
0x000000041c0e7810ULL, 0x000fe20007ffe0ffULL, 0x00000008100c7824ULL, 0x000fe200078e00ffULL,
0x000000141c167810ULL, 0x000fe20007ffe0ffULL, 0x000000011a077824ULL, 0x100fe200078e020aULL,
0x000000101c147810ULL, 0x000fe20007ffe0ffULL, 0x000000081a1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c197812ULL, 0x000fe200078ee203ULL, 0x0000000112067824ULL, 0x100fe200078e020aULL,
0x000000181c187810ULL, 0x000fe20007ffe0ffULL, 0x00000008121b7824ULL, 0x000fe200078e00ffULL,
0x000000030e177819ULL, 0x040fe200000006ffULL, 0x000000010e007824ULL, 0x100fe200078e020aULL,
0xfffffff81e237812ULL, 0x000fe200078ee207ULL, 0x0000000116037824ULL, 0x040fe200078e020aULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee206ULL, 0x00000008160c7824ULL, 0x000fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee200ULL, 0x0000000155077824ULL, 0x000fe200078e0a08ULL,
0x0000000a1c0d7210ULL, 0x080fe20007ffe0ffULL, 0x00000008141d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c1f7812ULL, 0x000fe200078ee203ULL, 0x0000000118067824ULL, 0x000fe200078e020aULL,
0x0000000a14007210ULL, 0x000fe20007ffe0ffULL, 0x000000011c0c7824ULL, 0x000fe200078e0205ULL,
0x0000000318217819ULL, 0x000fc400000006ffULL, 0x000000201c1e7810ULL, 0x000fe40007ffe0ffULL,
0x000000070a037812ULL, 0x000fe400078ec0ffULL, 0x000000071c00720cULL, 0x000fe20003f06070ULL,
0x000000011e117824ULL, 0x000fe200078e020aULL, 0x0000000766157812ULL, 0x000fe200078ef80dULL,
0x00005e000c0c7625ULL, 0x000fe200078e0067ULL, 0xfffffff81d1d7812ULL, 0x000fe400078ee200ULL,
0xfffffff821217812ULL, 0x000fc400078ee206ULL, 0x0000300057067811ULL, 0x000fe400078e70ffULL,
0x0000000803007812ULL, 0x000fe400078efcffULL, 0x000000070e00720cULL, 0x0c0fe20003f26070ULL,
0x000000010e0e7824ULL, 0x100fe200078e0205ULL, 0x000000071000720cULL, 0x0c0fe20003f46070ULL,
0x0000000110107824ULL, 0x000fe200078e0205ULL, 0x000000031e207819ULL, 0x000fe200000006ffULL,
0x00000010000c7825ULL, 0x000fe200078e000cULL, 0x000000071200720cULL, 0x000fc40003f66070ULL,
0xfffffff820257812ULL, 0x000fe200078ee211ULL, 0x0000000112127824ULL, 0x000fe200078e0205ULL,
0x000000061b1b7211ULL, 0x000fe200078e20ffULL, 0x0000001015157824ULL, 0x000fe200078e0206ULL,
0x000000071e00720cULL, 0x000fe20003f86070ULL, 0x00005e000e0e7625ULL, 0x080fe200078e0067ULL,
0x000000381c207810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c157faeULL, 0x0003e2000c101c46ULL, 0x00005e0010107625ULL, 0x000fe200078e0067ULL,
0x000000071400720cULL, 0x000fc40003f06070ULL, 0x000000072000720cULL, 0x000fe20003fa6070ULL,
0x00005e0012127625ULL, 0x000fc800078e0067ULL, 0x0000001017177824ULL, 0x000fe400078e0206ULL,
0x00000010000e7825ULL, 0x000fc800078e000eULL, 0x0000001019197824ULL, 0x000fe200078e0206ULL,
0x000000000e177faeULL, 0x0005e2000c901c46ULL, 0x0000001000107825ULL, 0x000fe200078e0010ULL,
0x000000071600720cULL, 0x000fc60003f26070ULL, 0x0000000114147824ULL, 0x000fe200078e0205ULL,
0x0000000010197faeULL, 0x0007e2000d101c46ULL, 0x0000001000127825ULL, 0x000fe200078e0012ULL,
0x000000071800720cULL, 0x000fc60003f46070ULL, 0x00005e00140c7625ULL, 0x002fe200078e0067ULL,
0x00000000121b7faeULL, 0x0003e2000d901c46ULL, 0x000000071a00720cULL, 0x000fe40003f66070ULL,
0x0000000116147824ULL, 0x100fe400078e0205ULL, 0x0000000118167824ULL, 0x100fe200078e0205ULL,
0x000000051a187210ULL, 0x000fe20007ffe0ffULL, 0x000000011e1a7824ULL, 0x000fe200078e0205ULL,
0x000000341c1e7810ULL, 0x000fe20007ffe0ffULL, 0x00005e00140e7625ULL, 0x004fc800078e0067ULL,
0x00005e0016107625ULL, 0x008fe200078e0067ULL, 0x000000281c167810ULL, 0x000fc60007ffe0ffULL,
0x00005e0018127625ULL, 0x002fe200078e0067ULL, 0x0000002c1c187810ULL, 0x000fc60007ffe0ffULL,
0x000000101d1d7824ULL, 0x000fe400078e0206ULL, 0x00000010000c7825ULL, 0x000fc800078e000cULL,
0x00005e001a147625ULL, 0x000fe200078e0067ULL, 0x000000000c1d7faeULL, 0x0003e2000c101c46ULL,
0x000000301c1a7810ULL, 0x000fe40007ffe0ffULL, 0x000000101f177824ULL, 0x000fe400078e0206ULL,
0x00000010000e7825ULL, 0x000fc800078e000eULL, 0x0000001021197824ULL, 0x000fe200078e0206ULL,
0x000000000e177faeULL, 0x0005e2000c901c46ULL, 0x0000001000107825ULL, 0x000fe200078e0010ULL,
0x00000006250d7211ULL, 0x002fe400078e20ffULL, 0x000000241c0c7810ULL, 0x000fe20007ffe0ffULL,
0x00000010231b7824ULL, 0x000fe200078e0206ULL, 0x0000000010197faeULL, 0x0003e2000d101c46ULL,
0x0000001000127825ULL, 0x000fe200078e0012ULL, 0x0000003c1c1c7810ULL, 0x000fe40007ffe0ffULL,
0x000000070c00720cULL, 0x000fe20003f06070ULL, 0x0000001000147825ULL, 0x000fe200078e0014ULL,
0x00000000121b7faeULL, 0x0007e2000d901c46ULL, 0x0000000a180f7210ULL, 0x004fc40007ffe0ffULL,
0x00000001160e7824ULL, 0x140fe200078e020aULL, 0x00000000140d7faeULL, 0x0005e2000e101c46ULL,
0x000000071600720cULL, 0x080fe20003f26070ULL, 0x000000080c107824ULL, 0x002fe200078e00ffULL,
0x000000071800720cULL, 0x080fe20003f46070ULL, 0x0000000816197824ULL, 0x000fe200078e00ffULL,
0x000000071a00720cULL, 0x080fe20003f66070ULL, 0x000000011e117824ULL, 0x040fe200078e020aULL,
0x000000071e00720cULL, 0x080fe20003f86070ULL, 0x0000000818127824ULL, 0x008fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fe200078ee20eULL, 0x00000001160e7824ULL, 0x000fe200078e0205ULL,
0x000000071c00720cULL, 0x000fe20003fc6070ULL, 0x000000010c0d7824ULL, 0x004fe200078e020aULL,
0xfffffff8120f7812ULL, 0x000fe200078ee20fULL, 0x000000010c0c7824ULL, 0x100fe200078e0205ULL,
0x000000051a127210ULL, 0x000fe20007ffe0ffULL, 0x000000011e147824ULL, 0x000fe200078e0205ULL,
0xfffffff8100d7812ULL, 0x000fe200078ee20dULL, 0x0000000118107824ULL, 0x100fe200078e0205ULL,
0x000000031e1e7819ULL, 0x000fe200000006ffULL, 0x0000000120167824ULL, 0x000fc400078e0205ULL,
0x000000011c187824ULL, 0x040fe200078e0205ULL, 0x0000000a1c057210ULL, 0x000fe20007ffe0ffULL,
0x0000000120137824ULL, 0x100fe200078e020aULL, 0xfffffff81e117812ULL, 0x000fe200078ee211ULL,
0x000000011a077824ULL, 0x000fe400078e020aULL, 0x0000000820207824ULL, 0x000fe400078e00ffULL,
0x000000081c1c7824ULL, 0x000fe400078e00ffULL, 0x000000081a1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff820137812ULL, 0x000fe200078ee213ULL, 0x0000001019197824ULL, 0x100fe200078e0206ULL,
0xfffffff81c237812ULL, 0x000fe200078ee205ULL, 0x000000100d057824ULL, 0x100fe200078e0206ULL,
0xfffffff81a077812ULL, 0x000fe200078ee207ULL, 0x000000100f1b7824ULL, 0x000fc400078e0206ULL,
0x00000010111f7824ULL, 0x100fe200078e0206ULL, 0x00000006071d7211ULL, 0x000fe200078e20ffULL,
0x0000001013217824ULL, 0x100fe400078e0206ULL, 0x0000001023237824ULL, 0x000fe400078e0206ULL,
0x00005e000c067625ULL, 0x000fc800078e0067ULL, 0x00005e000e0c7625ULL, 0x000fc800078e0067ULL,
0x00005e00100e7625ULL, 0x000fc800078e0067ULL, 0x00005e0012107625ULL, 0x000fc800078e0067ULL,
0x00005e0014127625ULL, 0x000fc800078e0067ULL, 0x00005e0016147625ULL, 0x000fc800078e0067ULL,
0x00005e0018167625ULL, 0x000fc800078e0067ULL, 0x0000001000067825ULL, 0x000fc800078e0006ULL,
0x00000010000c7825ULL, 0x040fe200078e000cULL, 0x0000000006057faeULL, 0x0003e6000c101c46ULL,
0x00000010000e7825ULL, 0x040fe200078e000eULL, 0x000000000c197faeULL, 0x0003e6000c901c46ULL,
0x0000001000107825ULL, 0x040fe200078e0010ULL, 0x000000000e1b7faeULL, 0x0003e6000d101c46ULL,
0x0000001000127825ULL, 0x040fe200078e0012ULL, 0x00000000101d7faeULL, 0x0003e6000d901c46ULL,
0x0000001000147825ULL, 0x040fe200078e0014ULL, 0x00000000121f7faeULL, 0x0003e6000e101c46ULL,
0x0000001000167825ULL, 0x000fe200078e0016ULL, 0x0000000014217faeULL, 0x0003e8000e901c46ULL,
0x0000000016237faeULL, 0x0003e2000f101c46ULL, 0x0000096000007947ULL, 0x000fea0003800000ULL,
0x000000080a0e7811ULL, 0x042fe200078fe8ffULL, 0x00000100ff677424ULL, 0x000fe200078e00ffULL,
0x0000000c0a107811ULL, 0x000fc400078fe8ffULL, 0x000000040a0c7811ULL, 0x000fe200078fe8ffULL,
0x000000010e037824ULL, 0x100fe200078e020aULL, 0x000000140a147811ULL, 0x000fe200078fe8ffULL,
0x000000080e127824ULL, 0x000fe200078e00ffULL, 0x0000001c0a187811ULL, 0x000fe200078fe8ffULL,
0x0000000110067824ULL, 0x100fe200078e020aULL, 0x000000180a167811ULL, 0x000fe200078fe8ffULL,
0x00000008102d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8122b7812ULL, 0x000fe200078ee203ULL,
0x000000010c007824ULL, 0x100fe200078e020aULL, 0x000000100a127811ULL, 0x000fe200078fe8ffULL,
0x0000000114037824ULL, 0x000fe200078e020aULL, 0x000000030c297819ULL, 0x000fe200000006ffULL,
0x00000008141a7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee206ULL,
0x0000000118077824ULL, 0x040fe200078e020aULL, 0xfffffff829297812ULL, 0x000fe200078ee200ULL,
0x00000008181c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81a317812ULL, 0x000fe200078ee203ULL,
0x00000008122f7824ULL, 0x040fe200078e00ffULL, 0x0000000a12007210ULL, 0x080fe20007ffe0ffULL,
0x0000000116067824ULL, 0x140fe200078e020aULL, 0x0000000316337819ULL, 0x000fe200000006ffULL,
0x000000010c0c7824ULL, 0x100fe200078e0205ULL, 0x000000200a1a7811ULL, 0x000fe200078fe8ffULL,
0x000000010e0e7824ULL, 0x100fe200078e0205ULL, 0x000000280a1e7811ULL, 0x000fe200078fe8ffULL,
0x0000000110107824ULL, 0x000fe200078e0205ULL, 0x0000002c0a207811ULL, 0x000fe200078fe8ffULL,
0x000000081a377824ULL, 0x000fe200078e00ffULL, 0xfffffff81c357812ULL, 0x000fe200078ee207ULL,
0x000000081e3b7824ULL, 0x000fe200078e00ffULL, 0x000000240a1c7811ULL, 0x000fe200078fe8ffULL,
0x0000000120077824ULL, 0x000fe200078e020aULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee200ULL,
0x000000011a007824ULL, 0x000fe200078e020aULL, 0xfffffff833337812ULL, 0x000fe200078ee206ULL,
0x000000011e067824ULL, 0x000fe200078e020aULL, 0x0000000320247819ULL, 0x000fe200000006ffULL,
0x000000081c227824ULL, 0x040fe200078e00ffULL, 0x0000000a1c037210ULL, 0x080fe20007ffe0ffULL,
0x0000000114147824ULL, 0x100fe200078e0205ULL, 0xfffffff837377812ULL, 0x000fe200078ee200ULL,
0x0000000116167824ULL, 0x100fe200078e0205ULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee206ULL,
0x0000000118187824ULL, 0x000fe200078e0205ULL, 0xfffffff8240f7812ULL, 0x000fe200078ee207ULL,
0x000000011a1a7824ULL, 0x100fe200078e0205ULL, 0x000000050a067211ULL, 0x000fe200078fe8ffULL,
0x000000011e1e7824ULL, 0x100fe200078e0205ULL, 0x0000000a0a077211ULL, 0x000fe200078fe8ffULL,
0x0000000120207824ULL, 0x000fe200078e0205ULL, 0x0ffffff80a667812ULL, 0x000fc400078ec0ffULL,
0x000000300a007811ULL, 0x000fe400078fe8ffULL, 0xfffffff822397812ULL, 0x000fe400078ee203ULL,
0x000000070a037812ULL, 0x000fe200078ec0ffULL, 0x0000000100227824ULL, 0x000fe200078e0205ULL,
0x00000007660d7812ULL, 0x000fe200078ef807ULL, 0x0000000100117824ULL, 0x000fe200078e020aULL,
0x000000340a137811ULL, 0x000fe200078fe8ffULL, 0x00005e0006067625ULL, 0x000fe200078e0067ULL,
0x000000380a177811ULL, 0x000fc400078fe8ffULL, 0x0000003c0a197811ULL, 0x000fe200078fe8ffULL,
0x0000000113247824ULL, 0x140fe200078e0205ULL, 0x00000003002c7819ULL, 0x000fe200000006ffULL,
0x0000000113157824ULL, 0x000fe200078e020aULL, 0x0000000803007812ULL, 0x000fe200078efcffULL,
0x00000008132e7824ULL, 0x000fe200078e00ffULL, 0x00003000572a7811ULL, 0x000fe200078e70ffULL,
0x0000000117267824ULL, 0x140fe200078e0205ULL, 0x0000000512127210ULL, 0x080fe20007ffe0ffULL,
0x0000000817307824ULL, 0x000fe200078e00ffULL, 0x000000051c1c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000119287824ULL, 0x000fe200078e0205ULL, 0x0000000a17137210ULL, 0x000fe20007ffe0ffULL,
0x0000001000067825ULL, 0x000fe200078e0006ULL, 0x0000002a0d057211ULL, 0x000fc400078e20ffULL,
0xfffffff82c117812ULL, 0x000fe200078ee211ULL, 0x0000000119177824ULL, 0x040fe200078e020aULL,
0xfffffff830137812ULL, 0x000fe200078ee213ULL, 0x0000000819327824ULL, 0x000fe200078e00ffULL,
0xfffffff82e157812ULL, 0x000fe200078ee215ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006057faeULL, 0x0003e2000b901c46ULL, 0x00000010113d7824ULL, 0x100fe200078e022aULL,
0x0000002a31317211ULL, 0x080fe200078e20ffULL, 0x0000001013417824ULL, 0x100fe200078e022aULL,
0xfffffff832177812ULL, 0x000fe200078ee217ULL, 0x00000010153f7824ULL, 0x100fe200078e022aULL,
0x0000002a3b3b7211ULL, 0x080fe200078e20ffULL, 0x0000001029297824ULL, 0x100fe200078e022aULL,
0x0000002a17437211ULL, 0x000fe200078e20ffULL, 0x000000102b2b7824ULL, 0x000fc400078e022aULL,
0x000000102d2d7824ULL, 0x000fe400078e022aULL, 0x00005e000c067625ULL, 0x002fc800078e0067ULL,
0x000000100f057824ULL, 0x000fe400078e022aULL, 0x00005e000e0c7625ULL, 0x000fc800078e0067ULL,
0x00005e00100e7625ULL, 0x000fc800078e0067ULL, 0x00005e0012107625ULL, 0x000fc800078e0067ULL,
0x00005e0014127625ULL, 0x000fc800078e0067ULL, 0x00005e0016147625ULL, 0x000fc800078e0067ULL,
0x00005e0018167625ULL, 0x000fc800078e0067ULL, 0x0000001000067825ULL, 0x000fc800078e0006ULL,
0x00005e001a187625ULL, 0x000fe200078e0067ULL, 0x0000000006297faeULL, 0x0003e6000b901c46ULL,
0x00000010000c7825ULL, 0x000fc800078e000cULL, 0x00005e001c1a7625ULL, 0x000fe200078e0067ULL,
0x000000000c2b7faeULL, 0x0003e6000b901c46ULL, 0x00000010000e7825ULL, 0x000fc800078e000eULL,
0x000000102f2f7824ULL, 0x000fe200078e022aULL, 0x000000000e2d7faeULL, 0x0003e2000b901c46ULL,
0x00005e001e1c7625ULL, 0x000fc800078e0067ULL, 0x0000001000107825ULL, 0x000fc800078e0010ULL,
0x00005e00201e7625ULL, 0x000fe200078e0067ULL, 0x00000000102f7faeULL, 0x0003e6000b901c46ULL,
0x0000001000127825ULL, 0x000fc800078e0012ULL, 0x0000001033337824ULL, 0x000fe200078e022aULL,
0x0000000012317faeULL, 0x0003e2000b901c46ULL, 0x00005e0022207625ULL, 0x000fc800078e0067ULL,
0x0000001000147825ULL, 0x000fc800078e0014ULL, 0x0000001035357824ULL, 0x000fe200078e022aULL,
0x0000000014337faeULL, 0x0003e2000b901c46ULL, 0x00005e0024227625ULL, 0x000fc800078e0067ULL,
0x0000001000167825ULL, 0x000fc800078e0016ULL, 0x0000001037377824ULL, 0x000fe200078e022aULL,
0x0000000016357faeULL, 0x0003e2000b901c46ULL, 0x00005e0026247625ULL, 0x000fc800078e0067ULL,
0x0000001000187825ULL, 0x000fc800078e0018ULL, 0x0000001039397824ULL, 0x000fe200078e022aULL,
0x0000000018377faeULL, 0x0003e2000b901c46ULL, 0x00005e0028267625ULL, 0x000fc800078e0067ULL,
0x00000010001a7825ULL, 0x000fc800078e001aULL, 0x00000010001c7825ULL, 0x040fe200078e001cULL,
0x000000001a397faeULL, 0x0003e6000b901c46ULL, 0x00000010001e7825ULL, 0x040fe200078e001eULL,
0x000000001c3b7faeULL, 0x0003e6000b901c46ULL, 0x0000001000207825ULL, 0x040fe200078e0020ULL,
0x000000001e057faeULL, 0x0003e6000b901c46ULL, 0x0000001000227825ULL, 0x040fe200078e0022ULL,
0x00000000203d7faeULL, 0x0003e6000b901c46ULL, 0x0000001000247825ULL, 0x040fe200078e0024ULL,
0x00000000223f7faeULL, 0x0003e6000b901c46ULL, 0x0000001000267825ULL, 0x000fe200078e0026ULL,
0x0000000024417faeULL, 0x0003e8000b901c46ULL, 0x0000000026437faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000004ff0c7819ULL, 0x002fc4000001160aULL,
0x0000000803077812ULL, 0x000fca00078ef80aULL, 0x000000010c067824ULL, 0x000fe400078e0207ULL,
0x0000001007057824ULL, 0x000fca00078e00ffULL, 0xfffffff005007812ULL, 0x000fca00078ee206ULL,
0x0000001000287824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x000000080c007824ULL, 0x000fe200078e00ffULL,
0x00000003ff657819ULL, 0x000fe2000001160aULL, 0x000000002828783bULL, 0x000fe20000000200ULL,
0x0000000e57687819ULL, 0x000fe200000006ffULL, 0x00000010070c7824ULL, 0x000fe200078e00ffULL,
0xfffffff800007812ULL, 0x000fe400078ee203ULL, 0x0000000165037812ULL, 0x000fe400078ec0ffULL,
0x0000100068697810ULL, 0x000fe20007ffe0ffULL, 0x00000008006a7824ULL, 0x040fe200078e00ffULL,
0x0000001000367810ULL, 0x040fe20007ffe0ffULL, 0x0000000103377824ULL, 0x000fe200078e0200ULL,
0x0000002000357810ULL, 0x000fc40007ffe0ffULL, 0x0000003000347810ULL, 0x000fe20007ffe0ffULL,
0x0000000103647824ULL, 0x040fe200078e0236ULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee237ULL,
0x00000008360d7824ULL, 0x000fe200078e00ffULL, 0x0000000206057810ULL, 0x000fe20007ffe0ffULL,
0x0000000103637824ULL, 0x000fe200078e0235ULL, 0x00000003000e7819ULL, 0x000fe200000006ffULL,
0x000000106a187824ULL, 0x000fe200078e0269ULL, 0x0000000237617810ULL, 0x000fe20007ffe0ffULL,
0x0000000103627824ULL, 0x000fe200078e0234ULL, 0xfffffff80d647812ULL, 0x000fe200078ee264ULL,
0x0000000834037824ULL, 0x000fe200078e00ffULL, 0xfffffff00c057812ULL, 0x000fe200078ee205ULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0x00000008350c7824ULL, 0x040fe200078e00ffULL,
0xfffffff80e617812ULL, 0x000fe200078ee261ULL, 0x0000000835107824ULL, 0x000fe200078e00ffULL,
0x0000006964307211ULL, 0x080fe200078e20ffULL, 0x0000001005057824ULL, 0x000fe200078e00ffULL,
0xfffffff803627812ULL, 0x000fe200078ee262ULL, 0x00000010614c7824ULL, 0x000fe200078e0269ULL,
0xfffffff80c637812ULL, 0x000fe200078ee263ULL, 0x0000000836037824ULL, 0x000fe200078e00ffULL,
0x000000003030783bULL, 0x000ea20000000200ULL, 0x00000010622c7824ULL, 0x000fe200078e0269ULL,
0x00000069630c7211ULL, 0x000fe200078e20ffULL, 0x0000000834387824ULL, 0x000fe200078e00ffULL,
0x000000000524783bULL, 0x0007e20000000200ULL, 0x0000001237607810ULL, 0x000fc40007ffe0ffULL,
0x00000022375f7810ULL, 0x000fe20007ffe0ffULL, 0x000000004c4c783bULL, 0x000f220000000200ULL,
0xfffffff803607812ULL, 0x000fe200078ee260ULL, 0x0000000834037824ULL, 0x000fe200078e00ffULL,
0xfffffff8105f7812ULL, 0x000fe200078ee25fULL, 0x000000000c0c783bULL, 0x000f220000000200ULL,
0x00000032375e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001060147824ULL, 0x000fe200078e0269ULL,
0x000000695f1c7211ULL, 0x000fe200078e20ffULL, 0x000000002c2c783bULL, 0x000f220000000200ULL,
0xfffffff8035e7812ULL, 0x000fc400078ee25eULL, 0x0000000406037810ULL, 0x000fe20007ffe0ffULL,
0x000000001414783bULL, 0x000f220000000200ULL, 0x00000014375c7810ULL, 0x040fe40007ffe0ffULL,
0x0000002437057810ULL, 0x048fe20007ffe0ffULL, 0x000000001c1c783bULL, 0x000ee20000000200ULL,
0x00000004375d7810ULL, 0x040fe40007ffe0ffULL, 0x00000026375a7810ULL, 0x040fe40007ffe0ffULL,
0x0000003637587810ULL, 0x040fe20007ffe0ffULL, 0x000000182850723cULL, 0x002f6200000018ffULL,
0x00000016375b7810ULL, 0x000fce0007ffe0ffULL, 0x0000001a2818723cULL, 0x040f7000000018ffULL,
0x000000302810723cULL, 0x044f7000000018ffULL, 0x000000322830723cULL, 0x000f7000000018ffULL,
0x0000004c2450723cULL, 0x070ff00000001850ULL, 0x0000004e244c723cULL, 0x000ff00000001818ULL,
0x0000000c2818723cULL, 0x040f7000000018ffULL, 0x0000002c2820723cULL, 0x040bee00000018ffULL,
0x000000105e2c7824ULL, 0x020fe200078e0269ULL, 0x0000000e280c723cULL, 0x040f7000000018ffULL,
0x0000002e2828723cULL, 0x000b6400000018ffULL, 0x000000002c2c783bULL, 0x020e6c0000000200ULL,
0x000000142410723cULL, 0x040f700000001810ULL, 0x000000162414723cULL, 0x040b6e0000001830ULL,
0x0000001007307824ULL, 0x020fe200078e00ffULL, 0x0000001c2418723cULL, 0x008b620000001818ULL,
0x0000000835327824ULL, 0x040fe200078e00ffULL, 0x0000000606317810ULL, 0x000fe20007ffe0ffULL,
0x0000000800337824ULL, 0x000fe200078e00ffULL, 0xfffffff030307812ULL, 0x000fe200078ee203ULL,
0x0000000835357824ULL, 0x000fe200078e00ffULL, 0x0000003437037810ULL, 0x000fe20007ffe0ffULL,
0x00000008001c7824ULL, 0x020fe200078e00ffULL, 0x00000003361d7819ULL, 0x000fe200000006ffULL,
0x0000001030307824ULL, 0x000fe200078e00ffULL, 0xfffffff832057812ULL, 0x000fe200078ee205ULL,
0x0000001007327824ULL, 0x000fe200078e00ffULL, 0xfffffff81d5c7812ULL, 0x000fc400078ee25cULL,
0xfffffff838037812ULL, 0x000fe200078ee203ULL, 0x0000001005447824ULL, 0x000fe200078e0269ULL,
0xfffffff81c5d7812ULL, 0x000fe200078ee25dULL, 0x000000105c487824ULL, 0x100fe200078e0269ULL,
0x0000001e241c723cULL, 0x040b62000000180cULL, 0x0000001003407824ULL, 0x000fe200078e0269ULL,
0x00000000303c783bULL, 0x0005e20000000200ULL, 0x0000000637007810ULL, 0x000fe40007ffe0ffULL,
0x0000000336367819ULL, 0x000fe200000006ffULL, 0x000000004848783bULL, 0x000ee20000000200ULL,
0x000000695d0c7211ULL, 0x020fe200078e20ffULL, 0x0000002c2420723cULL, 0x002b620000001820ULL,
0xfffffff833007812ULL, 0x000fe200078ee200ULL, 0x000000004444783bULL, 0x000fe20000000200ULL,
0xfffffff8355a7812ULL, 0x000fc400078ee25aULL, 0xfffffff032317812ULL, 0x000fe200078ee231ULL,
0x000000000c0c783bULL, 0x000e620000000200ULL, 0x00000008342d7824ULL, 0x020fe200078e00ffULL,
0xfffffff8365b7812ULL, 0x000fe200078ee25bULL, 0x0000002e2424723cULL, 0x000b620000001828ULL,
0x000000004040783bULL, 0x000f220000000200ULL, 0x0000001000387824ULL, 0x100fe200078e0269ULL,
0xfffffff82d587812ULL, 0x000fe200078ee258ULL, 0x000000105a307824ULL, 0x004fe200078e0269ULL,
0x000000695b347211ULL, 0x000fe200078e20ffULL, 0x00000010316b7824ULL, 0x000fc400078e00ffULL,
0x00000010582c7824ULL, 0x000fe200078e0269ULL, 0x000000003838783bULL, 0x000fe80000000200ULL,
0x000000006b28783bULL, 0x020ea80000000200ULL, 0x000000003434783bULL, 0x000ea80000000200ULL,
0x000000003030783bULL, 0x000ea80000000200ULL, 0x000000002c2c783bULL, 0x000ea20000000200ULL,
0x000000483c10723cULL, 0x048ff00000001810ULL, 0x0000000c3c50723cULL, 0x042f700000001850ULL,
0x0000000e3c4c723cULL, 0x040f70000000184cULL, 0x0000004a3c14723cULL, 0x040f700000001814ULL,
0x000000443c18723cULL, 0x040b6e0000001818ULL, 0x0000030059457a10ULL, 0x020fe20007ffe0ffULL,
0x000000463c1c723cULL, 0x000f66000000181cULL, 0x00000001450d7810ULL, 0x000fc80007ffe0ffULL,
0x000000540d00720cULL, 0x000fe20003f06070ULL, 0x000000403c20723cULL, 0x010f620000001820ULL,
0x00000100450d7824ULL, 0x000fce00078e0204ULL, 0x000000423c24723cULL, 0x000b6e0000001824ULL,
0x0000620002427a24ULL, 0x020fe200078e020dULL, 0x000000382850723cULL, 0x044b700000001850ULL,
0x0000003a284c723cULL, 0x040b70000000184cULL, 0x000000342810723cULL, 0x040b700000001810ULL,
0x000000362814723cULL, 0x040b700000001814ULL, 0x000000302818723cULL, 0x040b700000001818ULL,
0x00000032281c723cULL, 0x040b70000000181cULL, 0x0000002c2820723cULL, 0x040b700000001820ULL,
0x0000002e2824723cULL, 0x000b620000001824ULL, 0x00000b6000008947ULL, 0x000fce0003800000ULL,
0x0000000465297810ULL, 0x020fe20007ffe0ffULL, 0x000000100a307824ULL, 0x000fe200078e00ffULL,
0x0000000d55347217ULL, 0x000fe20007800000ULL, 0x00000001650f7824ULL, 0x140fe200078e020aULL,
0x0000001465317810ULL, 0x000fe20007ffe0ffULL, 0x00000001290c7824ULL, 0x000fe200078e020aULL,
0x000000340d347210ULL, 0x000fe20007ffe1ffULL, 0x00000008292b7824ULL, 0x000fe200078e00ffULL,
0x00000008650d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000129287824ULL, 0x000fe200078e0242ULL,
0x0000007030307812ULL, 0x000fe200078ec0ffULL, 0x00000001313e7824ULL, 0x000fe200078e020aULL,
0xfffffff82b407812ULL, 0x000fe200078ee20cULL, 0x000000010d3c7824ULL, 0x000fe200078e020aULL,
0x00000042650c7210ULL, 0x000fe20007ffe0ffULL, 0x000000010d2a7824ULL, 0x040fe200078e0242ULL,
0x000000030d2d7819ULL, 0x000fc400000006ffULL, 0x000000340d00720cULL, 0x000fe20003f66070ULL,
0x00005e000c0c7625ULL, 0x080fe200078e0067ULL, 0x0000000766667812ULL, 0x000fe400078ef80fULL,
0x0000000c650f7810ULL, 0x000fe20007ffe0ffULL, 0x00005e002a2a7625ULL, 0x080fe200078e0067ULL,
0x0000000c300c7210ULL, 0x000fe40007f1e0ffULL, 0x000000342900720cULL, 0x000fe20003f46070ULL,
0x00005e0028287625ULL, 0x000fe200078e0067ULL, 0xfffffff82d3c7812ULL, 0x000fc400078ee23cULL,
0x00000010652d7810ULL, 0x000fe20007ffe0ffULL, 0x000000010f0e7824ULL, 0x040fe200078e0242ULL,
0x000000340f00720cULL, 0x040fe20003fa6070ULL, 0x000000010f3a7824ULL, 0x040fe200078e020aULL,
0x0000002830287210ULL, 0x040fe20007f3e0ffULL, 0x000000080f2f7824ULL, 0x000fe200078e00ffULL,
0x000000342d00720cULL, 0x040fe20003f86070ULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000002a302c7210ULL, 0x000fe20007f1e0ffULL, 0x00005e000e0e7625ULL, 0x000fe200078e0067ULL,
0x000000422d2a7210ULL, 0x000fc40007ffe0ffULL, 0xfffffff82f3a7812ULL, 0x000fe200078ee23aULL,
0x000000012d367824ULL, 0x040fe200078e020aULL, 0x000000032d2f7819ULL, 0x000fe200000006ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e062bULL, 0x0000000e302e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff297224ULL, 0x000fe200008e0629ULL, 0x000000346500720cULL, 0x000fe20003f26070ULL,
0x00005e002a2a7625ULL, 0x000fe200078e0067ULL, 0xfffffff82f367812ULL, 0x000fe400078ee236ULL,
0x0000001865337810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2f7224ULL, 0x000fe200000e060fULL,
0x00000003310f7819ULL, 0x000fc400000006ffULL, 0x0000002a300e7210ULL, 0x000fe20007fde0ffULL,
0x00000001312a7824ULL, 0x040fe200078e0242ULL, 0x000000343100720cULL, 0x000fe20003f06070ULL,
0x0000001066317824ULL, 0x000fe200078e0269ULL, 0xfffffff80f3e7812ULL, 0x000fe200078ee23eULL,
0x000000ffff0f7224ULL, 0x000fe200030e062bULL, 0x0000000a33387210ULL, 0x040fe20007ffe0ffULL,
0x00005e002a2a7625ULL, 0x080fe200078e0067ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c317faeULL, 0x0003e2000c901c46ULL, 0x000000343300720cULL, 0x040fe40003f26070ULL,
0x0000000133327824ULL, 0x000fe200078e0242ULL, 0x0000001c65377810ULL, 0x000fe20007ffe0ffULL,
0x0000000833357824ULL, 0x000fe200078e00ffULL, 0x0000002a302a7210ULL, 0x000fe20007fde0ffULL,
0x00005e0032327625ULL, 0x000fe200078e0067ULL, 0x0000002c65397810ULL, 0x000fc40007ffe0ffULL,
0xfffffff835387812ULL, 0x000fe200078ee238ULL, 0x0000001040357824ULL, 0x000fe200078e0269ULL,
0x0000002bff2b7210ULL, 0x000fe200037fe4ffULL, 0x0000000137407824ULL, 0x040fe200078e020aULL,
0x00000032300c7210ULL, 0x002fe20007fde0ffULL, 0x00000008370d7824ULL, 0x040fe200078e00ffULL,
0x0000000028357faeULL, 0x0003e2000d101c46ULL, 0x0000000137327824ULL, 0x040fe200078e0242ULL,
0x000000343700720cULL, 0x000fe40003f46070ULL, 0xfffffff80d407812ULL, 0x000fe200078ee240ULL,
0x000000ffff0d7224ULL, 0x000fe200030e0633ULL, 0x0000002065377810ULL, 0x000fe20007ffe0ffULL,
0x00005e0032327625ULL, 0x000fe200078e0067ULL, 0x000000693c317211ULL, 0x000fc400078e20ffULL,
0x00000030653b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000137447824ULL, 0x040fe200078e020aULL,
0x0000003230287210ULL, 0x002fe20007fde0ffULL, 0x0000000837297824ULL, 0x040fe200078e00ffULL,
0x0000004237327210ULL, 0x040fe20007ffe0ffULL, 0x000000002c317faeULL, 0x0003e2000d901c46ULL,
0x000000343700720cULL, 0x000fe20003f66070ULL, 0x000000103a357824ULL, 0x000fe200078e0269ULL,
0xfffffff829447812ULL, 0x000fe200078ee244ULL, 0x000000ffff297224ULL, 0x000fe200030e0633ULL,
0x0000002465377810ULL, 0x040fe20007ffe0ffULL, 0x00005e0032327625ULL, 0x000fe200078e0067ULL,
0x000000002e357faeULL, 0x0005e2000e901c46ULL, 0x00000034653d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000337467819ULL, 0x000fe200000006ffULL, 0x00000001393a7824ULL, 0x100fe200078e020aULL,
0x00000032302c7210ULL, 0x002fe20007fde0ffULL, 0x00000001372d7824ULL, 0x040fe200078e020aULL,
0x000000343700720cULL, 0x040fe20003fa6070ULL, 0x0000000137327824ULL, 0x000fe200078e0242ULL,
0x0000002865377810ULL, 0x000fe20007ffe0ffULL, 0x0000001036317824ULL, 0x000fe200078e0269ULL,
0xfffffff846467812ULL, 0x000fe200078ee22dULL, 0x0000000839357824ULL, 0x004fe200078e00ffULL,
0x00000003372f7819ULL, 0x000fe200000006ffULL, 0x000000ffff2d7224ULL, 0x000fe200030e0633ULL,
0x000000000e317faeULL, 0x0003e2000e101c46ULL, 0x00005e0032327625ULL, 0x000fe200078e0067ULL,
0xfffffff8353a7812ULL, 0x000fc400078ee23aULL, 0x000000343700720cULL, 0x040fe20003f86070ULL,
0x0000000137367824ULL, 0x040fe200078e0242ULL, 0x00000032302e7210ULL, 0x000fe20007fde0ffULL,
0x000000103e357824ULL, 0x000fe400078e0269ULL, 0x00000001373c7824ULL, 0x000fe400078e020aULL,
0x00005e0036367625ULL, 0x000fe200078e0067ULL, 0x000000002a357faeULL, 0x0005e2000c101c46ULL,
0x000000343900720cULL, 0x040fe40003f06070ULL, 0x0000000139327824ULL, 0x000fe200078e0242ULL,
0xfffffff82f3c7812ULL, 0x000fe200078ee23cULL, 0x000000083b3e7824ULL, 0x040fe200078e00ffULL,
0x00000033ff2f7210ULL, 0x000fe200037fe4ffULL, 0x00005e0032327625ULL, 0x000fe200078e0067ULL,
0x0000000a3b397210ULL, 0x000fc40007ffe0ffULL, 0x00000036300e7210ULL, 0x002fe20007fde0ffULL,
0x0000001038317824ULL, 0x000fe200078e0269ULL, 0xfffffff83e367812ULL, 0x000fe200078ee239ULL,
0x000000013d2b7824ULL, 0x044fe200078e020aULL, 0x00000037ff0f7210ULL, 0x000fe200037fe4ffULL,
0x000000083d3e7824ULL, 0x000fe200078e00ffULL, 0x00000032302a7210ULL, 0x000fe20007fde0ffULL,
0x0000001040357824ULL, 0x000fe200078e0269ULL, 0x000000000c317faeULL, 0x0003e2000c901c46ULL,
0x000000013b327824ULL, 0x040fe200078e0242ULL, 0xfffffff83e387812ULL, 0x000fe200078ee22bULL,
0x000000ffff2b7224ULL, 0x000fe200030e0633ULL, 0x0000000028357faeULL, 0x0005e2000d101c46ULL,
0x00005e0032327625ULL, 0x000fe200078e0067ULL, 0x000000343b00720cULL, 0x000fc40003f26070ULL,
0x00000038653b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001046397824ULL, 0x000fe200078e0269ULL,
0x0000006944377211ULL, 0x000fe400078e20ffULL, 0x00000032300c7210ULL, 0x002fe40007fde0ffULL,
0x000000423b327210ULL, 0x000fe20007ffe0ffULL, 0x000000002c377faeULL, 0x0003e2000d901c46ULL,
0x000000013d287824ULL, 0x004fe200078e0242ULL, 0x0000003c65657810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200030e0633ULL, 0x000000002e397faeULL, 0x0005e2000e901c46ULL,
0x00005e0028287625ULL, 0x000fe200078e0067ULL, 0x000000343d00720cULL, 0x000fc40003fa6070ULL,
0x000000343b00720cULL, 0x000fe20003f66070ULL, 0x0000000165317824ULL, 0x140fe200078e020aULL,
0x0000002830287210ULL, 0x000fe20007fde0ffULL, 0x000000103c337824ULL, 0x000fe200078e0269ULL,
0x000000346500720cULL, 0x000fe20003f46070ULL, 0x00005e00322c7625ULL, 0x002fe200078e0067ULL,
0x000000033b327819ULL, 0x040fe400000006ffULL, 0x0000006938397211ULL, 0x004fe200078e20ffULL,
0x000000013b2f7824ULL, 0x000fe200078e020aULL, 0x000000000e337faeULL, 0x0003e2000e101c46ULL,
0x00000001652e7824ULL, 0x000fc400078e0242ULL, 0x000000ffff297224ULL, 0x000fe200030e0629ULL,
0xfffffff832327812ULL, 0x000fe200078ee22fULL, 0x0000000865347824ULL, 0x000fe200078e00ffULL,
0x0000002c302c7210ULL, 0x000fe20007fde0ffULL, 0x00005e002e2e7625ULL, 0x000fc600078e0067ULL,
0x0000002dff2d7210ULL, 0x000fe200037fe4ffULL, 0x000000103a357824ULL, 0x000fe200078e0269ULL,
0xfffffff834347812ULL, 0x000fe200078ee231ULL, 0x0000001036377824ULL, 0x100fe200078e0269ULL,
0x0000002e30307210ULL, 0x000fe20007fde0ffULL, 0x00000010323b7824ULL, 0x100fe200078e0269ULL,
0x000000002a357faeULL, 0x0003e2000c101c46ULL, 0x0000001034697824ULL, 0x000fe400078e0269ULL,
0x000000ffff317224ULL, 0x000fe200030e062fULL, 0x000000000c377faeULL, 0x0003e8000c901c46ULL,
0x0000000028397faeULL, 0x0003e8000e901c46ULL, 0x000000002c3b7faeULL, 0x0003e8000d901c46ULL,
0x0000000030697faeULL, 0x0003e2000d101c46ULL, 0x00000a3000007947ULL, 0x000fea0003800000ULL,
0x0000000865297810ULL, 0x060fe20007ffe0ffULL, 0x000000100a467824ULL, 0x000fe200078e00ffULL,
0x00000004650f7810ULL, 0x040fe20007ffe0ffULL, 0x00000001650c7824ULL, 0x040fe200078e0242ULL,
0x0000000a650d7210ULL, 0x000fe20007ffe0ffULL, 0x00000001296e7824ULL, 0x140fe200078e020aULL,
0x00000003292f7819ULL, 0x000fe200000006ffULL, 0x000000010f6c7824ULL, 0x040fe200078e020aULL,
0x00000007660e7812ULL, 0x000fe200078ef80dULL, 0x000000080f2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff82f6e7812ULL, 0x000fe200078ee26eULL, 0x000000010f2e7824ULL, 0x000fe200078e0242ULL,
0x0000000c650d7810ULL, 0x040fe20007ffe0ffULL, 0x000000100e477824ULL, 0x100fe200078e0269ULL,
0x00000010652b7810ULL, 0x040fe20007ffe0ffULL, 0x000000106e4b7824ULL, 0x000fe200078e0269ULL,
0x00000018652f7810ULL, 0x000fe20007ffe0ffULL, 0x000000010d707824ULL, 0x000fe200078e020aULL,
0xfffffff82d6c7812ULL, 0x000fe200078ee26cULL, 0x000000080d317824ULL, 0x000fe200078e00ffULL,
0x00000014652d7810ULL, 0x000fe20007ffe0ffULL, 0x000000012b7a7824ULL, 0x140fe200078e020aULL,
0x000000032b337819ULL, 0x000fe200000006ffULL, 0x000000012f767824ULL, 0x140fe200078e020aULL,
0x000000032f377819ULL, 0x000fe200000006ffULL, 0x000000012d787824ULL, 0x000fe200078e020aULL,
0xfffffff831707812ULL, 0x000fe200078ee270ULL, 0x000000082d357824ULL, 0x000fe200078e00ffULL,
0xfffffff8337a7812ULL, 0x000fe200078ee27aULL, 0x000000010d287824ULL, 0x000fe200078e0242ULL,
0xfffffff837767812ULL, 0x000fe200078ee276ULL, 0x000000012b4a7824ULL, 0x000fe200078e0242ULL,
0x0000001c65317810ULL, 0x040fe20007ffe0ffULL, 0x00005e000c0c7625ULL, 0x000fe200078e0067ULL,
0x0000002065337810ULL, 0x000fc40007ffe0ffULL, 0x0000002865377810ULL, 0x000fe20007ffe0ffULL,
0x0000000131747824ULL, 0x000fe200078e020aULL, 0xfffffff835787812ULL, 0x000fe200078ee278ULL,
0x0000000831397824ULL, 0x000fe200078e00ffULL, 0x0000002465357810ULL, 0x000fe20007ffe0ffULL,
0x0000000133727824ULL, 0x140fe200078e020aULL, 0x00000003333b7819ULL, 0x000fe200000006ffULL,
0x0000000137447824ULL, 0x140fe200078e020aULL, 0x00000003373f7819ULL, 0x000fe200000006ffULL,
0x0000000135667824ULL, 0x000fe200078e020aULL, 0xfffffff839747812ULL, 0x000fe200078ee274ULL,
0x00000008353d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83b727812ULL, 0x000fe200078ee272ULL,
0x000000012d2c7824ULL, 0x000fe200078e0242ULL, 0xfffffff83f447812ULL, 0x000fe200078ee244ULL,
0x0000000131307824ULL, 0x100fe200078e0242ULL, 0x0000002c65397810ULL, 0x000fe20007ffe0ffULL,
0x0000000133327824ULL, 0x100fe200078e0242ULL, 0x00000030653b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000135347824ULL, 0x000fe200078e0242ULL, 0x00000038653f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000139407824ULL, 0x000fe200078e020aULL, 0xfffffff83d667812ULL, 0x000fe200078ee266ULL,
0x0000000839417824ULL, 0x000fe200078e00ffULL, 0x00000034653d7810ULL, 0x000fe20007ffe0ffULL,
0x000000013b2a7824ULL, 0x000fe200078e020aULL, 0x0000003c65657810ULL, 0x000fe20007ffe0ffULL,
0x000000083f2b7824ULL, 0x000fe200078e00ffULL, 0x00000042297c7210ULL, 0x000fe20007ffe0ffULL,
0x00000001393a7824ULL, 0x100fe200078e0242ULL, 0x000000033b437819ULL, 0x040fe200000006ffULL,
0x000000013b387824ULL, 0x100fe200078e0242ULL, 0x0000007046467812ULL, 0x000fe200078ec0ffULL,
0x000000013d3c7824ULL, 0x100fe200078e0242ULL, 0x0000000a3f297210ULL, 0x000fe20007ffe0ffULL,
0x000000083d7d7824ULL, 0x000fe200078e00ffULL, 0x000000422f487210ULL, 0x080fe20007ffe0ffULL,
0x000000013f3e7824ULL, 0x100fe200078e0242ULL, 0x0000004237367210ULL, 0x000fe20007ffe0ffULL,
0x0000000165427824ULL, 0x000fe200078e0242ULL, 0x0000000a3d0f7210ULL, 0x000fe20007ffe0ffULL,
0x00000001652d7824ULL, 0x000fe200078e020aULL, 0xfffffff841407812ULL, 0x000fe200078ee240ULL,
0x0000000865657824ULL, 0x000fe200078e00ffULL, 0xfffffff8432a7812ULL, 0x000fe200078ee22aULL,
0x00005e002e2e7625ULL, 0x000fe200078e0067ULL, 0x0000000c460c7210ULL, 0x000fc40007f1e0ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee229ULL, 0x0000001044777824ULL, 0x000fe200078e0269ULL,
0xfffffff87d7d7812ULL, 0x000fe200078ee20fULL, 0x00005e007c0e7625ULL, 0x000fe200078e0067ULL,
0x0000000dff0d7210ULL, 0x000fe400007fe4ffULL, 0x0000006940797211ULL, 0x000fe200078e20ffULL,
0x000000102a7b7824ULL, 0x000fe200078e0269ULL, 0xfffffff8652d7812ULL, 0x000fe200078ee22dULL,
0x000000102b447824ULL, 0x100fe200078e0269ULL, 0x0000002e46407210ULL, 0x000fe20007f1e0ffULL,
0x00005e004a2a7625ULL, 0x000fe200078e0067ULL, 0x0000006970657211ULL, 0x080fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c477faeULL, 0x0003e2000b901c46ULL,
0x0000006974717211ULL, 0x000fe200078e20ffULL, 0x000000106c497824ULL, 0x100fe200078e0269ULL,
0x0000000e460e7210ULL, 0x000fe20007f3e0ffULL, 0x000000107a6b7824ULL, 0x000fc400078e0269ULL,
0x00000010786d7824ULL, 0x100fe400078e0269ULL, 0x00000010766f7824ULL, 0x100fe400078e0269ULL,
0x0000001072737824ULL, 0x100fe400078e0269ULL, 0x0000001066757824ULL, 0x100fe400078e0269ULL,
0x000000107d7d7824ULL, 0x000fe200078e0269ULL, 0x000000692d697211ULL, 0x000fe200078e20ffULL,
0x00005e002c2c7625ULL, 0x000fc800078e0067ULL, 0x000000ffff417224ULL, 0x000fe200000e062fULL,
0x0000002a462a7210ULL, 0x000fe20007f1e0ffULL, 0x00005e00482e7625ULL, 0x000fc600078e0067ULL,
0x0000002bff2b7210ULL, 0x000fe200007fe4ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x0000002c462c7210ULL, 0x000fe20007f3e0ffULL, 0x00005e0030307625ULL, 0x080fe200078e0067ULL,
0x0000002e462e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000040497faeULL, 0x0003e4000b901c46ULL,
0x00005e0028287625ULL, 0x080fe400078e0067ULL, 0x000000000e4b7faeULL, 0x0003e4000b901c46ULL,
0x00005e0032327625ULL, 0x000fe200078e0067ULL, 0x0000002846287210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff2d7224ULL, 0x000fe200008e062dULL, 0x0000003046307210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff2f7224ULL, 0x000fe200000e062fULL, 0x0000003246327210ULL, 0x000fe20007f1e0ffULL,
0x00005e0034347625ULL, 0x000fc600078e0067ULL, 0x00000033ff337210ULL, 0x000fe200007fe4ffULL,
0x00005e003a3a7625ULL, 0x000fc800078e0067ULL, 0x00005e0036367625ULL, 0x000fe200078e0067ULL,
0x0000003a463a7210ULL, 0x000fc60007f1e0ffULL, 0x000000ffff317224ULL, 0x000fe200008e0631ULL,
0x0000003446347210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff297224ULL, 0x000fe200010e0629ULL,
0x0000003646367210ULL, 0x000fe20007f5e0ffULL, 0x00005e0038387625ULL, 0x000fc600078e0067ULL,
0x0000000028657faeULL, 0x0003e2000b901c46ULL, 0x00005e003c3c7625ULL, 0x000fc600078e0067ULL,
0x000000002a6b7faeULL, 0x0003e2000b901c46ULL, 0x00005e003e3e7625ULL, 0x000fc600078e0067ULL,
0x000000002c6d7faeULL, 0x0003e2000b901c46ULL, 0x00005e0042427625ULL, 0x000fc600078e0067ULL,
0x000000002e6f7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff357224ULL, 0x000fe200008e0635ULL,
0x0000003c463c7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e063bULL,
0x0000003846387210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff377224ULL, 0x000fe200010e0637ULL,
0x0000003e463e7210ULL, 0x040fe20007f5e0ffULL, 0x0000000030717faeULL, 0x0003e2000b901c46ULL,
0x0000004246427210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200008e063dULL,
0x00000039ff397210ULL, 0x000fe200007fe4ffULL, 0x0000000032737faeULL, 0x0003e2000b901c46ULL,
0x000000ffff3f7224ULL, 0x000fc400010e063fULL, 0x000000ffff437224ULL, 0x000fe200018e0643ULL,
0x0000000034757faeULL, 0x0003e8000b901c46ULL, 0x0000000036777faeULL, 0x0003e8000b901c46ULL,
0x000000003a797faeULL, 0x0003e8000b901c46ULL, 0x00000000387b7faeULL, 0x0003e8000b901c46ULL,
0x000000003c7d7faeULL, 0x0003e8000b901c46ULL, 0x000000003e447faeULL, 0x0003e8000b901c46ULL,
0x0000000042697faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000008060c7810ULL, 0x002fe20007ffe0ffULL, 0x0000001007297824ULL, 0x040fe200078e00ffULL,
0x00000004070d7819ULL, 0x000fc400000006ffULL, 0x0000300068477810ULL, 0x000fe40007ffe0ffULL,
0xfffffff00d0c7812ULL, 0x000fe400078ee20cULL, 0x0000004763387211ULL, 0x000fe200078e20ffULL,
0x000000106a0d7824ULL, 0x100fe200078e0247ULL, 0x0000000a06287810ULL, 0x000fe20007ffe0ffULL,
0x000000100c307824ULL, 0x000fe400078e00ffULL, 0x00000010643c7824ULL, 0x100fe200078e0247ULL,
0xfffffff029287812ULL, 0x000fe200078ee228ULL, 0x0000001062347824ULL, 0x000fc400078e0247ULL,
0x00000010612c7824ULL, 0x100fe200078e0247ULL, 0x0000000428287819ULL, 0x000fe200000006ffULL,
0x0000001060407824ULL, 0x100fe400078e0247ULL, 0x0000001058487824ULL, 0x000fe200078e0247ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000d0c783bULL, 0x000fe80000000200ULL,
0x000000003030783bULL, 0x000e680000000200ULL, 0x000000003c3c783bULL, 0x000ea80000000200ULL,
0x000000003838783bULL, 0x000ee80000000200ULL, 0x000000003434783bULL, 0x000f280000000200ULL,
0x000000002c2c783bULL, 0x000fe80000000200ULL, 0x000000002828783bULL, 0x000ee80000000200ULL,
0x000000004040783bULL, 0x000fe80000000200ULL, 0x000000004848783bULL, 0x000fe20000000200ULL,
0x0000000c3050723cULL, 0x042b6e0000001850ULL, 0x000000105f0c7824ULL, 0x120fe200078e0247ULL,
0x0000000e304c723cULL, 0x040b6a000000184cULL, 0x000000000c0c783bULL, 0x020e660000000200ULL,
0x0000003c3010723cULL, 0x044bee0000001810ULL, 0x00000010033c7824ULL, 0x120fe200078e0247ULL,
0x0000003e3014723cULL, 0x040bea0000001814ULL, 0x000000003c3c783bULL, 0x020fe60000000200ULL,
0x000000383018723cULL, 0x048b6e0000001818ULL, 0x000000105c387824ULL, 0x020fe200078e0247ULL,
0x0000003a301c723cULL, 0x040b6a000000181cULL, 0x000000003838783bULL, 0x020fe60000000200ULL,
0x000000343020723cULL, 0x050f700000001820ULL, 0x000000363024723cULL, 0x000b6e0000001824ULL,
0x0000000c06307810ULL, 0x020fe20007ffe0ffULL, 0x0000002c2850723cULL, 0x000b620000001850ULL,
0x0000000407317819ULL, 0x000fc400000006ffULL, 0x0000000e06067810ULL, 0x000fe40007ffe0ffULL,
0xfffffff031307812ULL, 0x000fe200078ee230ULL, 0x000000105d317824ULL, 0x100fe200078e0247ULL,
0x0000000407077819ULL, 0x000fe200000006ffULL, 0x000000105e2c7824ULL, 0x120fe200078e0247ULL,
0x0000002e284c723cULL, 0x040b62000000184cULL, 0x0000001030347824ULL, 0x000fe200078e00ffULL,
0xfffffff007067812ULL, 0x000fe200078ee206ULL, 0x000000003130783bULL, 0x000fe60000000200ULL,
0x0000000406067819ULL, 0x000fe200000006ffULL, 0x000000002c2c783bULL, 0x020ea20000000200ULL,
0x0000000c2818723cULL, 0x042be60000001818ULL, 0x000000003434783bULL, 0x000e680000000200ULL,
0x00000010050c7824ULL, 0x120fe200078e0247ULL, 0x0000000e281c723cULL, 0x040bea000000181cULL,
0x000000000c0c783bULL, 0x020ee60000000200ULL, 0x000000422814723cULL, 0x040f700000001814ULL,
0x000000402810723cULL, 0x000bee0000001810ULL, 0x000000105b407824ULL, 0x020fcc00078e0247ULL,
0x000000004040783bULL, 0x000fe20000000200ULL, 0x0000002c2820723cULL, 0x044b6e0000001820ULL,
0x00000010002c7824ULL, 0x120fe200078e0247ULL, 0x0000002e2824723cULL, 0x000b640000001824ULL,
0x000000000628783bULL, 0x020ea80000000200ULL, 0x000000002c2c783bULL, 0x000fe40000000200ULL,
0x000000303450723cULL, 0x042bee0000001850ULL, 0x000000105a307824ULL, 0x020fe200078e0247ULL,
0x00000032344c723cULL, 0x040bea000000184cULL, 0x000000003030783bULL, 0x020e660000000200ULL,
0x0000003a3414723cULL, 0x040f700000001814ULL, 0x0000000c3418723cULL, 0x048f700000001818ULL,
0x0000000e341c723cULL, 0x040f70000000181cULL, 0x0000003c3420723cULL, 0x040f700000001820ULL,
0x0000003e3424723cULL, 0x040ff00000001824ULL, 0x000000383410723cULL, 0x000ff00000001810ULL,
0x000000422814723cULL, 0x064f700000001814ULL, 0x000000302818723cULL, 0x042ff00000001818ULL,
0x00000032281c723cULL, 0x040f70000000181cULL, 0x000000482820723cULL, 0x000f640000001820ULL,
0x3db504f314147820ULL, 0x020fc40000410000ULL, 0x3db504f315157820ULL, 0x000fc80000410000ULL,
0x0000004a2824723cULL, 0x040f700000001824ULL, 0x0000002c2850723cULL, 0x000b620000001850ULL,
0x3db504f31f0d7820ULL, 0x000fe40000410000ULL, 0x3db504f31e0c7820ULL, 0x000fc80000410000ULL,
0x3db504f3172c7820ULL, 0x020fe20000410000ULL, 0x0000002e284c723cULL, 0x040f62000000184cULL,
0x3db504f319177820ULL, 0x000fe40000410000ULL, 0x3db504f31a2d7820ULL, 0x000fe40000410000ULL,
0x3db504f31d1a7820ULL, 0x000fe40000410000ULL, 0x3db504f322197820ULL, 0x000fe20000410000ULL,
0x000000402810723cULL, 0x000b620000001810ULL, 0x3db504f3251f7820ULL, 0x000fc40000410000ULL,
0x3db504f3211d7820ULL, 0x000fe40000410000ULL, 0x3db504f3241e7820ULL, 0x000fe40000410000ULL,
0x3db504f3162b7820ULL, 0x020fe40000410000ULL, 0x3db504f318167820ULL, 0x000fe40000410000ULL,
0x3db504f31b287820ULL, 0x000fe40000410000ULL, 0x3db504f31c187820ULL, 0x000fc40000410000ULL,
0x3db504f350037820ULL, 0x000fe40000410000ULL, 0x3db504f351057820ULL, 0x000fe40000410000ULL,
0x3db504f352527820ULL, 0x000fe40000410000ULL, 0x3db504f353537820ULL, 0x000fe40000410000ULL,
0x3db504f34c4c7820ULL, 0x000fe40000410000ULL, 0x3db504f34d4d7820ULL, 0x000fc40000410000ULL,
0x3db504f34e4e7820ULL, 0x000fe40000410000ULL, 0x3db504f34f4f7820ULL, 0x000fe40000410000ULL,
0x3db504f310007820ULL, 0x000fe40000410000ULL, 0x3db504f311067820ULL, 0x000fe40000410000ULL,
0x3db504f312297820ULL, 0x000fe40000410000ULL, 0x3db504f3132a7820ULL, 0x000fc40000410000ULL,
0x3db504f3201c7820ULL, 0x000fe40000410000ULL, 0x3db504f3231b7820ULL, 0x000fe40000410000ULL,
0x3db504f326227820ULL, 0x000fe40000410000ULL, 0x3db504f327257820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ffff137224ULL, 0x000fe200078e0006ULL,
0x0000004c00107202ULL, 0x000fe20000000f00ULL, 0x000000000b067f8cULL, 0x0002a2000c80043fULL,
0x000000ffff117224ULL, 0x000fe200078e004dULL, 0x0000005200207202ULL, 0x000fe20000000f00ULL,
0x000000ffff127224ULL, 0x000fe200078e0000ULL, 0x0000000c00217202ULL, 0x000fe20000000f00ULL,
0x000000ffff237224ULL, 0x000fc400078e0053ULL, 0x000000ffff267224ULL, 0x000fe400078e004eULL,
0x000000ffff277224ULL, 0x000fe400078e004fULL, 0x000000ffff247224ULL, 0x000fc400078e000dULL,
0x00000000000c7805ULL, 0x002fca0000015200ULL, 0x000004000b0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x006fe40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c2f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09002f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140fULL, 0x0000002f00007211ULL, 0x000fc800078110ffULL,
0x0000000fff0f7210ULL, 0x000fc800007fe4ffULL, 0x0000000200007819ULL, 0x000fc8000000120fULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000b0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000040a067824ULL, 0x000fe200078e00ffULL,
0x000000565900720cULL, 0x000fc80003f05270ULL, 0xfffffff006007812ULL, 0x000fca00078ec0ffULL,
0x0000008057007824ULL, 0x000fca00078e0200ULL, 0x01b40000000c7984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x000000020a077824ULL, 0x000fe200078e00ffULL,
0x8000000855317210ULL, 0x000fc80007ffe0ffULL, 0x0000000607077812ULL, 0x000fc800078ec0ffULL,
0x0000000107087812ULL, 0x040fe400078efcffULL, 0x00000008072e7812ULL, 0x040fe400078efcffULL,
0x000000310800720cULL, 0x080fe40003f26070ULL, 0x0000001007087812ULL, 0x000fe400078efcffULL,
0x000000312e00720cULL, 0x080fe40003f06070ULL, 0x000000310800720cULL, 0x000fc40003fc6070ULL,
0x00000011072e7812ULL, 0x040fe400078efcffULL, 0x0000001807087812ULL, 0x040fe400078efcffULL,
0x000000310700720cULL, 0x0c0fe40003f46070ULL, 0x000000312e00720cULL, 0x080fe40003fa6070ULL,
0x000000310800720cULL, 0x000fe40003f66070ULL, 0x00000009072f7812ULL, 0x000fc400078efcffULL,
0x00000019072e7812ULL, 0x040fe400078efcffULL, 0x0000002007087812ULL, 0x000fe400078efcffULL,
0xff80000020207808ULL, 0x000fe40005000000ULL, 0xff80000003037808ULL, 0x000fe40005000000ULL,
0xff80000023237808ULL, 0x000fe40004800000ULL, 0xff80000005057808ULL, 0x000fc40004800000ULL,
0x000000312f00720cULL, 0x080fe40003f86070ULL, 0x000000312e00720cULL, 0x080fe40003f46070ULL,
0x000000310800720cULL, 0x000fe40003f26070ULL, 0x00000021072e7812ULL, 0x040fe400078efcffULL,
0x0000002807087812ULL, 0x000fe400078efcffULL, 0xff80000026267808ULL, 0x000fc40004000000ULL,
0xff80000010107808ULL, 0x000fe40004000000ULL, 0xff80000027277808ULL, 0x000fe40006000000ULL,
0xff80000011117808ULL, 0x000fe40006000000ULL, 0x000000312e00720cULL, 0x080fe40003f06070ULL,
0x000000310800720cULL, 0x000fe40003f86070ULL, 0x00000029072e7812ULL, 0x000fc400078efcffULL,
0x0000003007087812ULL, 0x000fe400078efcffULL, 0xff80000029297808ULL, 0x000fe40007000000ULL,
0xff80000012127808ULL, 0x000fe40007000000ULL, 0xff8000002a2a7808ULL, 0x000fe40006800000ULL,
0xff80000013137808ULL, 0x000fe40006800000ULL, 0x000000312e00720cULL, 0x000fc40003fc6070ULL,
0x000000310800720cULL, 0x000fe40003fa6070ULL, 0x00000031072e7812ULL, 0x040fe400078efcffULL,
0x0000003807087812ULL, 0x040fe400078efcffULL, 0x0000003907077812ULL, 0x000fe400078efcffULL,
0xff8000002b2b7808ULL, 0x000fe40005800000ULL, 0xff80000014147808ULL, 0x000fc40005800000ULL,
0xff8000002c2c7808ULL, 0x000fe40005000000ULL, 0xff80000015157808ULL, 0x000fe40005000000ULL,
0xff8000002d2d7808ULL, 0x000fe40004800000ULL, 0xff80000016167808ULL, 0x000fe40004800000ULL,
0x000000312e00720cULL, 0x080fe40003f66070ULL, 0x000000310800720cULL, 0x000fc40003f46070ULL,
0x000000310700720cULL, 0x000fe40003f26070ULL, 0xff80000028287808ULL, 0x000fe40004000000ULL,
0xff80000017177808ULL, 0x000fe40004000000ULL, 0xff80000021217808ULL, 0x000fe40006000000ULL,
0xff80000018187808ULL, 0x000fe40006000000ULL, 0xff80000024247808ULL, 0x000fc40007000000ULL,
0xff8000001a1a7808ULL, 0x000fe40007000000ULL, 0xff80000019197808ULL, 0x000fe40006800000ULL,
0xff8000001c1c7808ULL, 0x000fe40006800000ULL, 0xff8000001b1b7808ULL, 0x000fe40005800000ULL,
0xff8000001d1d7808ULL, 0x000fe40005800000ULL, 0xff80000022227808ULL, 0x000fc40005000000ULL,
0xff8000001e1e7808ULL, 0x000fe40005000000ULL, 0xff80000025257808ULL, 0x000fe40004800000ULL,
0xff8000001f1f7808ULL, 0x000fc40004800000ULL, 0x000000030c00720bULL, 0x004fe40003f1e000ULL,
0x000000200d00720bULL, 0x000fe40003f3e000ULL, 0x0000000c030c7208ULL, 0x000fe40004000000ULL,
0x0000000d20087208ULL, 0x000fc40004800000ULL, 0x000000050c00720bULL, 0x000fe40003f1e000ULL,
0x000000230800720bULL, 0x000fe40003f3e000ULL, 0x0000000c05077208ULL, 0x000fe40004000000ULL,
0x00000008230d7208ULL, 0x000fe40004800000ULL, 0x000000100700720bULL, 0x000fe40003f1e000ULL,
0x000000260d00720bULL, 0x000fc40003f3e000ULL, 0x0000000710087208ULL, 0x000fe40004000000ULL,
0x0000000d260c7208ULL, 0x000fe40004800000ULL, 0x000000110800720bULL, 0x000fe40003f1e000ULL,
0x000000270c00720bULL, 0x000fe40003f3e000ULL, 0x0000000811077208ULL, 0x000fe40004000000ULL,
0x0000000c270c7208ULL, 0x000fc40004800000ULL, 0x000000120700720bULL, 0x000fe40003f1e000ULL,
0x000000290c00720bULL, 0x000fe40003f3e000ULL, 0x0000000712087208ULL, 0x000fe40004000000ULL,
0x0000000c29077208ULL, 0x000fe40004800000ULL, 0x000000130800720bULL, 0x000fe40003f1e000ULL,
0x0000002a0700720bULL, 0x000fc40003f3e000ULL, 0x00000008130d7208ULL, 0x000fe40004000000ULL,
0x000000072a087208ULL, 0x000fe40004800000ULL, 0x000000140d00720bULL, 0x000fe40003f1e000ULL,
0x0000002b0800720bULL, 0x000fe40003f3e000ULL, 0x0000000d140c7208ULL, 0x000fe40004000000ULL,
0x000000082b077208ULL, 0x000fc40004800000ULL, 0x000000150c00720bULL, 0x000fe40003f1e000ULL,
0x0000002c0700720bULL, 0x000fe40003f3e000ULL, 0x0000000c150d7208ULL, 0x000fe40004000000ULL,
0x000000072c087208ULL, 0x000fe40004800000ULL, 0x000000160d00720bULL, 0x000fe40003f1e000ULL,
0x0000002d0800720bULL, 0x000fc40003f3e000ULL, 0x0000000d160c7208ULL, 0x000fe40004000000ULL,
0x000000082d077208ULL, 0x000fe40004800000ULL, 0x000000170c00720bULL, 0x000fe40003f1e000ULL,
0x000000280700720bULL, 0x000fe40003f3e000ULL, 0x0000000c170d7208ULL, 0x000fe40004000000ULL,
0x0000000728087208ULL, 0x000fc40004800000ULL, 0x000000180d00720bULL, 0x000fe40003f1e000ULL,
0x000000210800720bULL, 0x000fe40003f3e000ULL, 0x0000000d180d7208ULL, 0x000fe40004000000ULL,
0x0000000821077208ULL, 0x000fe40004800000ULL, 0x0000001a0d00720bULL, 0x000fe40003f1e000ULL,
0x000000240700720bULL, 0x000fc40003f3e000ULL, 0x0000000d1a0d7208ULL, 0x000fe40004000000ULL,
0x0000000724087208ULL, 0x000fe40004800000ULL, 0x0000001c0d00720bULL, 0x000fe40003f1e000ULL,
0x000000190800720bULL, 0x000fe40003f3e000ULL, 0x0000000d1c0c7208ULL, 0x000fe40004000000ULL,
0x0000000819087208ULL, 0x000fc40004800000ULL, 0x0000001d0c00720bULL, 0x000fe40003f1e000ULL,
0x0000001b0800720bULL, 0x000fe40003f3e000ULL, 0x0000000c1d077208ULL, 0x000fe40004000000ULL,
0x000000081b0d7208ULL, 0x000fe40004800000ULL, 0x0000001e0700720bULL, 0x000fe40003f1e000ULL,
0x000000220d00720bULL, 0x000fc40003f3e000ULL, 0x000000071e087208ULL, 0x000fe40004000000ULL,
0x0000000d220c7208ULL, 0x000fe40004800000ULL, 0x0000001f0800720bULL, 0x000fe40003f1e000ULL,
0x000000250c00720bULL, 0x000fe40003f3e000ULL, 0x000000081f307208ULL, 0x000fe40004000000ULL,
0x0000000c25327208ULL, 0x000fe20004800000ULL, 0x000017627f007947ULL, 0x000fec000b800000ULL,
0x0c401f0030077f89ULL, 0x0004e400000e0000ULL, 0x000000073000720bULL, 0x008fc80003f1e000ULL,
0x0000003007337208ULL, 0x000fe20004000000ULL, 0x000017927f007947ULL, 0x000fea000b800000ULL,
0x0c401f0032077f89ULL, 0x000ee800000e0000ULL, 0x0c401f000e0d7f89ULL, 0x000f2800000e0000ULL,
0x0c401f000f087f89ULL, 0x000e6800000e0000ULL, 0x0c201f00330c7f89ULL, 0x000ea200000e0000ULL,
0x000000073200720bULL, 0x008fc40003f1e000ULL, 0x0000000d0e00720bULL, 0x010fe40003f3e000ULL,
0x00000032072e7208ULL, 0x000fe40004000000ULL, 0x0000000e0d2f7208ULL, 0x000fe40004800000ULL,
0x000000080f00720bULL, 0x002fe20003f1e000ULL, 0x0c201f002e0d7f89ULL, 0x000e6600000e0000ULL,
0x0000000f08077208ULL, 0x000fe20004000000ULL, 0x0c201f002f307f89ULL, 0x004ea200000e0000ULL,
0x0000000c3300720bULL, 0x000fc60003f1e000ULL, 0x0c201f0007087f89ULL, 0x0006e200000e0000ULL,
0x000000330c0c7208ULL, 0x000fe40004000000ULL, 0x0000000d2e00720bULL, 0x002fe40003f3e000ULL,
0x000000302f00720bULL, 0x004fe40003f5e000ULL, 0x0000002e0d0d7208ULL, 0x000fe40004800000ULL,
0x0000002f300e7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b0c2f7820ULL, 0x008fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b0d3c7820ULL, 0x000fe20000410000ULL,
0x000000030aff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b11117823ULL, 0x100fe2000001082fULL,
0x000000080700720bULL, 0x004fe20003f3e000ULL, 0x3fb8aa3b13137823ULL, 0x000fc4000001082fULL,
0x3fb8aa3b14147823ULL, 0x100fe2000001082fULL, 0x0000001100347308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b03037823ULL, 0x100fe4000001082fULL, 0x3fb8aa3b05057823ULL, 0x100fe4000001082fULL,
0x3fb8aa3b10107823ULL, 0x000fe4000001082fULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001083cULL,
0x0000001300367308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b23237823ULL, 0x000fc4000001083cULL,
0x3fb8aa3b26267823ULL, 0x100fe4000001083cULL, 0x3fb8aa3b27277823ULL, 0x000fe4000001083cULL,
0x3fb8aa3b160f7823ULL, 0x100fe2000001082fULL, 0x0000001400377308ULL, 0x002fe20000000800ULL,
0x3fb8aa3b12127823ULL, 0x100fe4000001082fULL, 0x3fb8aa3b15157823ULL, 0x100fe4000001082fULL,
0x3fb8aa3b17177823ULL, 0x000fc4000001082fULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001083cULL,
0x0000000300317308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe4000001083cULL,
0x3fb8aa3b29297823ULL, 0x100fe4000001083cULL, 0x3fb8aa3b2b2b7823ULL, 0x000fe4000001083cULL,
0x3fb8aa3b1d2e7823ULL, 0x100fe2000001082fULL, 0x0000000500327308ULL, 0x0004e20000000800ULL,
0x3fb8aa3b1c037823ULL, 0x002fc4000001082fULL, 0x3fb8aa3b1f307823ULL, 0x100fe4000001082fULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe4000001082fULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001083cULL,
0x0000001000337308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b1e057823ULL, 0x004fe4000001082fULL,
0x3fb8aa3b28287823ULL, 0x100fe4000001083cULL, 0x3fb8aa3b21217823ULL, 0x000fc4000001083cULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001083cULL, 0x0000002000117308ULL, 0x0003e20000000800ULL,
0x000000313210723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b18187823ULL, 0x000fe4000001082fULL,
0x3fb8aa3b19197823ULL, 0x100fe4000001083cULL, 0x3fb8aa3b1b1b7823ULL, 0x000fe4000001083cULL,
0x0000002300147308ULL, 0x000ea20000000800ULL, 0x00000002ff207819ULL, 0x002fe2000001160aULL,
0x3fb8aa3b22227823ULL, 0x000fc4000001083cULL, 0x3fb8aa3b25257823ULL, 0x000fe4000001083cULL,
0x00000008202f7824ULL, 0x040fe400078e00ffULL, 0x0000002600137308ULL, 0x0003e20000000800ULL,
0x0000000820317824ULL, 0x040fe400078e00ffULL, 0x00000008203c7824ULL, 0x040fe400078e00ffULL,
0x00000008203e7824ULL, 0x000fc600078e00ffULL, 0x0000002700167308ULL, 0x0007220000000800ULL,
0x000000111411723eULL, 0x004fe200000000ffULL, 0x3c003c00ff267424ULL, 0x002fcc00078e00ffULL,
0x0000001200357308ULL, 0x0002a20000000800ULL, 0x3c003c00ff277424ULL, 0x008fe200078e00ffULL,
0x000000131613723eULL, 0x010fcc00000000ffULL, 0x0000001500387308ULL, 0x000ee20000000800ULL,
0x000000333412723eULL, 0x002fe400000000ffULL, 0x0000000320347819ULL, 0x000fe400000006ffULL,
0x000000353614723eULL, 0x004fc600000000ffULL, 0x00000017003a7308ULL, 0x000fe20000000800ULL,
0x00000026101c723cULL, 0x000f6200000018ffULL, 0x0000000820367824ULL, 0x000fcc00078e00ffULL,
0x0000002900157308ULL, 0x0003e20000000800ULL, 0x000000373816723eULL, 0x008fce00000000ffULL,
0x0000002a002a7308ULL, 0x000ea20000000800ULL, 0x0000000220297810ULL, 0x002fc80007ffe0ffULL,
0xfffffff834347812ULL, 0x000fe400078ee229ULL, 0x0000000620297810ULL, 0x000fe20007ffe0ffULL,
0x0000002b00177308ULL, 0x0003e60000000800ULL, 0xfffffff83c3c7812ULL, 0x000fca00078ee229ULL,
0x0000002c002c7308ULL, 0x000ee20000000800ULL, 0x000000152a15723eULL, 0x004fe400000000ffULL,
0x00000003202b7810ULL, 0x002fc80007ffe0ffULL, 0xfffffff836367812ULL, 0x000fe200078ee22bULL,
0x0000000f000f7308ULL, 0x000e620000000800ULL, 0xffffffff202b7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff83e3e7812ULL, 0x000fe400078ee22bULL, 0x000000172c17723eULL, 0x008fe200000000ffULL,
0x0000001800397308ULL, 0x0005e20000000800ULL, 0x00000004202c7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff831387812ULL, 0x000fe200078ee22cULL, 0x00000026141c723cULL, 0x020f62000000181cULL,
0x0000000c062c7812ULL, 0x000fe200078ec0ffULL, 0x0000001a001a7308ULL, 0x000ee20000000800ULL,
0x0000000120187810ULL, 0x004fc80007ffe0ffULL, 0xfffffff82f327812ULL, 0x000fe400078ee218ULL,
0x0000000f3a18723eULL, 0x002fe200000000ffULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x00000003203a7819ULL, 0x000fce00000006ffULL, 0x0000002800287308ULL, 0x000e620000000800ULL,
0x000000391a1a723eULL, 0x008fce00000000ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002400247308ULL, 0x000eb00000000800ULL, 0x0000001900237308ULL, 0x0003f00000000800ULL,
0x0000001b002a7308ULL, 0x0004e20000000800ULL, 0x0000002d2819723eULL, 0x002fe200000000ffULL,
0x00000008202d7824ULL, 0x000fca00078e00ffULL, 0xfffffff82d287812ULL, 0x000fe200078ee220ULL,
0x0000000300037308ULL, 0x000fe20000000800ULL, 0x00000021241b723eULL, 0x004fe400000000ffULL,
0x0000000520217810ULL, 0x000fc80007ffe0ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee221ULL,
0x00000026181c723cULL, 0x020f62000000181cULL, 0x0000002e002e7308ULL, 0x000e620000000800ULL,
0x000000232a21723eULL, 0x008fce00000000ffULL, 0x0000000500057308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000eb00000000800ULL, 0x00000022000f7308ULL, 0x0007f00000000800ULL,
0x0000002500247308ULL, 0x0008a20000000800ULL, 0x0000000820227810ULL, 0x008fc40007ffe0ffULL,
0x000000032e20723eULL, 0x002fe400000000ffULL, 0x0001100057037811ULL, 0x000fe200078e58ffULL,
0x00000008222d7824ULL, 0x000fc600078e00ffULL, 0x0000000338257211ULL, 0x010fe200078e20ffULL,
0x0000001032067824ULL, 0x100fe200078e0203ULL, 0xfffffff82d407812ULL, 0x000fe200078ee222ULL,
0x000000103c297824ULL, 0x100fe200078e0203ULL, 0x000000053022723eULL, 0x004fe200000000ffULL,
0x000000012c067824ULL, 0x000fe200078e0206ULL, 0x0000000328057211ULL, 0x000fe200078e20ffULL,
0x000000103a287824ULL, 0x100fe200078e0203ULL, 0x0000000f2423723eULL, 0x000fe200000000ffULL,
0x00000010340f7824ULL, 0x100fe200078e0203ULL, 0x000000033e2a7211ULL, 0x000fe200078e20ffULL,
0x0000001036247824ULL, 0x000fc400078e0203ULL, 0x000000012c057824ULL, 0x040fe200078e0205ULL,
0x0000002a2c2a7210ULL, 0x000fe20007ffe0ffULL, 0x00000026201c723cULL, 0x020b62000000181cULL,
0x00000010402b7824ULL, 0x000fe200078e0203ULL, 0x000000242c247210ULL, 0x040fe20007ffe0ffULL,
0x000000012c037824ULL, 0x040fe200078e020fULL, 0x0000001005007388ULL, 0x0003e20000000800ULL,
0x000000012c257824ULL, 0x000fe200078e0225ULL, 0x00000007080f7208ULL, 0x000fe20004800000ULL,
0x000000012c287824ULL, 0x040fe200078e0228ULL, 0x0000001206007388ULL, 0x0003e20000000800ULL,
0x000000012c297824ULL, 0x000fc400078e0229ULL, 0x000000012c267824ULL, 0x020fe200078e022bULL,
0x0000001403007388ULL, 0x0003e80000000800ULL, 0x0000001624007388ULL, 0x0003e80000000800ULL,
0x0000001825007388ULL, 0x0003e80000000800ULL, 0x0000001a28007388ULL, 0x0003e20000000800ULL,
0x000000ffff1d7224ULL, 0x000fc600078e001eULL, 0x0000002029007388ULL, 0x0003e80000000800ULL,
0x000000222a007388ULL, 0x0003e80000000800ULL, 0x0000001126007388ULL, 0x0003e80000000800ULL,
0x0004001306007388ULL, 0x0003e80000000800ULL, 0x0004001503007388ULL, 0x0003e80000000800ULL,
0x0004001724007388ULL, 0x0003e80000000800ULL, 0x0004001925007388ULL, 0x0003e80000000800ULL,
0x0004001b28007388ULL, 0x0003e80000000800ULL, 0x0004002129007388ULL, 0x0003e80000000800ULL,
0x000400232a007388ULL, 0x0003e80000000800ULL, 0x01b0000c00008388ULL, 0x0003e80000000c00ULL,
0x01b2001c00008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6080009ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6100009ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b6180009ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000544500720cULL, 0x000fe20003f06070ULL, 0x01b6200009ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff597224ULL, 0x000fd600078e0045ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffac4000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff0c7807ULL, 0x004fe40004000000ULL, 0xffffffff00157802ULL, 0x000fe40000000f00ULL,
0x00011b8000167802ULL, 0x000fc40000000f00ULL, 0x00000fe000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0015ULL, 0xffff064000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe20005000000ULL, 0xffffffffff157424ULL, 0x000fe200078e00ffULL,
0x00011be000167802ULL, 0x000fc40000000f00ULL, 0x00000f8000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0xffff068000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x004fe200078e0015ULL, 0x00011c5000197802ULL, 0x000fe20000000f00ULL,
0x0000001fff187424ULL, 0x000fc400078e00ffULL, 0xffffffffff1d7424ULL, 0x000fc400078e00ffULL,
0x00000ec000007944ULL, 0x008fea0003c00000ULL, 0x00000017000c7202ULL, 0x004fe20000000f00ULL,
0xffff072000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0015ULL,
0x00011cc000197802ULL, 0x000fe20000000f00ULL, 0x0000001fff187424ULL, 0x000fe400078e00ffULL,
0xffffffffff1d7424ULL, 0x000fc400078e00ffULL, 0x00000e5000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0017ULL, 0xffff082000007947ULL, 0x000fea000383ffffULL,
0x0000000e00177202ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000fULL,
0x00011d4000197802ULL, 0x000fe20000000f00ULL, 0x0000001fff187424ULL, 0x000fe400078e00ffULL,
0xffffffffff1d7424ULL, 0x000fc400078e00ffULL, 0x00000dd000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0017ULL, 0xffff09b000007947ULL, 0x000fea000383ffffULL,
0x00000009000c7202ULL, 0x000fe20000000f00ULL, 0x000000ffff177224ULL, 0x000fe200078e000eULL,
0x00011dc000197802ULL, 0x000fe20000000f00ULL, 0x0000001fff187424ULL, 0x000fc400078e00ffULL,
0xffffffffff1d7424ULL, 0x000fc400078e00ffULL, 0x00000d5000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0017ULL, 0xffff096000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x008fe20004000000ULL, 0xffffffffff157424ULL, 0x000fe200078e00ffULL,
0x00011e2000167802ULL, 0x002fc40000000f00ULL, 0x00000d4000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0015ULL, 0xffff1ed000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe20004800000ULL, 0xffffffffff157424ULL, 0x000fe200078e00ffULL,
0x00011e8000167802ULL, 0x002fc40000000f00ULL, 0x00000ce000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff167224ULL, 0x000fe200078e0015ULL, 0xffff1f1000007947ULL, 0x000fea000383ffffULL,
0x0000001a00177202ULL, 0x000fe20000000f00ULL, 0x0000001fff187424ULL, 0x000fe200078e00ffULL,
0x00011ef000197802ULL, 0x000fe20000000f00ULL, 0xffffffffff1d7424ULL, 0x000fc400078e00ffULL,
0x00000c2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0017ULL,
0xffff1fd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e001aULL,
0x0000001f00187802ULL, 0x000fe20000000f00ULL, 0xffffffffff1d7424ULL, 0x000fe200078e00ffULL,
0x00011f6000197802ULL, 0x000fc40000000f00ULL, 0x00000bb000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0017ULL, 0xffff20c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e000eULL, 0x0000001f00187802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fe200078e000fULL, 0x00011fe000197802ULL, 0x000fe20000000f00ULL,
0xffffffffff1d7424ULL, 0x000fc400078e00ffULL, 0x00000b3000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0017ULL, 0xffff225000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e000eULL, 0xffffffff001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff187424ULL, 0x000fe200078e00ffULL, 0x0001205000197802ULL, 0x000fc40000000f00ULL,
0x00000ac000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0017ULL,
0xffff221000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x008fe20004000000ULL,
0xffffffffff157424ULL, 0x000fe200078e00ffULL, 0x000120b000167802ULL, 0x002fc40000000f00ULL,
0x00000ab000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0xffff344000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe20004800000ULL,
0xffffffffff157424ULL, 0x000fe200078e00ffULL, 0x0001211000167802ULL, 0x002fc40000000f00ULL,
0x00000a5000007944ULL, 0x000fea0003c00000ULL, 0xffff349000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0016ULL, 0x0001217000197802ULL, 0x000fe20000000f00ULL,
0x0000001fff187424ULL, 0x000fc400078e00ffULL, 0xffffffffff1d7424ULL, 0x000fc400078e00ffULL,
0x000009a000007944ULL, 0x000fea0003c00000ULL, 0x00000017000c7202ULL, 0x004fe20000000f00ULL,
0xffff355000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0016ULL,
0x000121e000197802ULL, 0x000fe20000000f00ULL, 0x0000001fff187424ULL, 0x000fe400078e00ffULL,
0xffffffffff1d7424ULL, 0x000fc400078e00ffULL, 0x0000093000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0017ULL, 0xffff364000007947ULL, 0x000fea000383ffffULL,
0x0000000e00177202ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000fULL,
0x0001226000197802ULL, 0x000fe20000000f00ULL, 0x0000001fff187424ULL, 0x000fe400078e00ffULL,
0xffffffffff1d7424ULL, 0x000fc400078e00ffULL, 0x000008b000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0017ULL, 0xffff37d000007947ULL, 0x000fea000383ffffULL,
0x0000000e00177202ULL, 0x000fe20000000f00ULL, 0x0000001fff187424ULL, 0x000fe200078e00ffULL,
0x000122d000197802ULL, 0x000fe20000000f00ULL, 0xffffffffff1d7424ULL, 0x000fc400078e00ffULL,
0x0000084000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0017ULL,
0xffff379000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x008fe40004000000ULL,
0xffffffff00157802ULL, 0x000fc40000000f00ULL, 0x0001233000167802ULL, 0x002fc40000000f00ULL,
0x0000083000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0015ULL,
0xffff49e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe20005000000ULL,
0xffffffffff157424ULL, 0x000fe200078e00ffULL, 0x0001239000167802ULL, 0x002fc40000000f00ULL,
0x000007d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e0015ULL,
0xffff4a2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0016ULL,
0x0001240000197802ULL, 0x000fe20000000f00ULL, 0x0000001fff187424ULL, 0x000fe400078e00ffULL,
0xffffffffff1d7424ULL, 0x000fc400078e00ffULL, 0x0000071000007944ULL, 0x000fea0003c00000ULL,
0x00000017000c7202ULL, 0x004fe20000000f00ULL, 0xffff4ad000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0016ULL, 0x0001247000197802ULL, 0x000fe20000000f00ULL,
0x0000001fff187424ULL, 0x000fc400078e00ffULL, 0xffffffffff1d7424ULL, 0x000fc400078e00ffULL,
0x000006a000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0017ULL,
0xffff4bc000007947ULL, 0x000fea000383ffffULL, 0x0000000e00177202ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x000fe200078e000fULL, 0x000124f000197802ULL, 0x000fe20000000f00ULL,
0x0000001fff187424ULL, 0x000fe400078e00ffULL, 0xffffffffff1d7424ULL, 0x000fc400078e00ffULL,
0x0000062000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0017ULL,
0xffff4d5000007947ULL, 0x000fea000383ffffULL, 0x0000000e00177202ULL, 0x000fe20000000f00ULL,
0x0000001fff187424ULL, 0x000fe200078e00ffULL, 0x0001256000197802ULL, 0x000fe20000000f00ULL,
0xffffffffff1d7424ULL, 0x000fc400078e00ffULL, 0x000005b000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff097224ULL, 0x004fe200078e0017ULL, 0xffff4d1000007947ULL, 0x000fea000383ffffULL,
0x00000002ff317424ULL, 0x000fe200078e00ffULL, 0x000125d0002e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff087424ULL, 0x000fc400078e00ffULL, 0xffffffffff377424ULL, 0x000fc400078e00ffULL,
0x0000050000007944ULL, 0x002fea0003c00000ULL, 0x0000000800077202ULL, 0x004fe20000000f00ULL,
0xffffe84000007947ULL, 0x000fea000383ffffULL, 0x000000ffff307224ULL, 0x006fe200078e0032ULL,
0xffffffff00377802ULL, 0x000fe20000000f00ULL, 0x00000002ff317424ULL, 0x000fe200078e00ffULL,
0x00012650002e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff087424ULL, 0x000fc400078e00ffULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x000000083200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff307224ULL, 0x002fe200078e000eULL, 0xffffffff00377802ULL, 0x000fe20000000f00ULL,
0x00000002ff317424ULL, 0x000fe200078e00ffULL, 0x00000032080d7208ULL, 0x000fe20004000000ULL,
0x0000001fff087424ULL, 0x000fe200078e00ffULL, 0x000126d0002e7802ULL, 0x000fc40000000f00ULL,
0x0000040000007944ULL, 0x000fea0003c00000ULL, 0x000000080e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff307224ULL, 0x002fe200078e000fULL, 0xffffffff00377802ULL, 0x000fe20000000f00ULL,
0x00000002ff317424ULL, 0x000fe200078e00ffULL, 0x0000000e08357208ULL, 0x000fe20004000000ULL,
0x0000001fff087424ULL, 0x000fe200078e00ffULL, 0x00012750002e7802ULL, 0x000fc40000000f00ULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x000000080f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff307224ULL, 0x002fe200078e0033ULL, 0xffffffff00377802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fe200078e00ffULL, 0x0000000f08077208ULL, 0x000fe20004000000ULL,
0x0000001fff087424ULL, 0x000fe200078e00ffULL, 0x000127d0002e7802ULL, 0x000fc40000000f00ULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0x000000083300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff307224ULL, 0x002fe200078e000dULL, 0xffffffff00377802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fe200078e00ffULL, 0x00000033080c7208ULL, 0x000fe20004000000ULL,
0x0000001fff087424ULL, 0x000fe200078e00ffULL, 0x00012850002e7802ULL, 0x000fc40000000f00ULL,
0x0000028000007944ULL, 0x000fea0003c00000ULL, 0x000000080d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff307224ULL, 0x002fe200078e0035ULL, 0xffffffff00377802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fe200078e00ffULL, 0x0000000d080d7208ULL, 0x000fe20004000000ULL,
0x0000001fff087424ULL, 0x000fe200078e00ffULL, 0x000128d0002e7802ULL, 0x000fc40000000f00ULL,
0x0000020000007944ULL, 0x000fea0003c00000ULL, 0x000000083500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff307224ULL, 0x002fe200078e0007ULL, 0xffffffff00377802ULL, 0x000fe20000000f00ULL,
0x00000001ff317424ULL, 0x000fe200078e00ffULL, 0x00000035080e7208ULL, 0x000fe20004000000ULL,
0x0000001fff087424ULL, 0x000fe200078e00ffULL, 0x00012950002e7802ULL, 0x000fc40000000f00ULL,
0x0000018000007944ULL, 0x000fea0003c00000ULL, 0xffffe63000007947ULL, 0x000fea000383ffffULL,
0x0180000005007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000000500008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff0d7807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x000000000dff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff05ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000005047812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x000000000dff7212ULL, 0x000fda000780c0ffULL,
0x0080000004000812ULL, 0x000fe400078efcffULL, 0x0000000400008202ULL, 0x000fe20000000f00ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000500007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff0d7424ULL, 0x000fc800078e00ffULL,
0xfffed5300c007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff2f7424ULL, 0x000fe200078e00ffULL,
0x0000003700007348ULL, 0x000fe80003800000ULL, 0x0c00003130087389ULL, 0x0002a200000e0008ULL,
0xfffed4f02e007950ULL, 0x000fea0003c3ffffULL, 0x0000001d00007348ULL, 0x000fe80003800000ULL,
0x0000000c17177389ULL, 0x0002a200000e0018ULL, 0x00000000000d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff0c7224ULL, 0x002fc800078e0019ULL, 0xfffed4a00c007950ULL, 0x000fea0003c3ffffULL,
0x000000010c00780cULL, 0x000fe20003f45070ULL, 0x0000001500007348ULL, 0x000fe80003800000ULL,
0x00000000ff0d7424ULL, 0x000fd000078e00ffULL, 0x00000000000c7806ULL, 0x000fc800050e0100ULL,
0x000000150c157212ULL, 0x000fe200078ec0ffULL, 0x000000ffff0c7224ULL, 0x000fc800078e0016ULL,
0xfffed4300c007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000542ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006a0ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008f8ULL,
0x0000000000000310ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c08ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000cc8ULL,
0x0000000000000584ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001250ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001260ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012f0ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012f4ULL,
0x00000000000001a8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001500ULL,
0x0000000000012c80ULL, 0x8000001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000014180ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x00000000000141c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000014540ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000012f0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000012e90ULL,
0x0000000000012e90ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000014180ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000014540ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_8_m_8_sm_80_cubin_len = 83488;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
