/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000011f98ULL, 0x0000000000011c18ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x32666c61685f5f37ULL,
0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454536316a4cULL, 0x45454531624c4974ULL,
0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45346aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x32336a4c4545346aULL, 0x61324545386a4c45ULL,
0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x6a4c45386a4c4545ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4536316aULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x0000000000676e69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL, 0x735f616475635f5fULL, 0x5f7063725f30326dULL,
0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL, 0x6c65722e00687461ULL, 0x656b2e747865742eULL,
0x61686d5f6c656e72ULL, 0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL,
0x6d5f6c656e72656bULL, 0x426d656d73246168ULL, 0x2e00667542657479ULL, 0x72665f6775626564ULL,
0x6c65722e00656d61ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b0001000000b1ULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000b0001000000efULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000b00010000016fULL, 0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b0001000001b1ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000001f7ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000023eULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000b000100000284ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000002d2ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000b000100000320ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000366ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0001000003abULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a002200000406ULL, 0x0000000000010940ULL,
0x0000000000000240ULL, 0x000400030000047cULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000010b80ULL, 0x000d0003000004acULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001094000000000ULL,
0x0000680400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808a92ULL, 0x0000001cffffffffULL,
0x0000006000000000ULL, 0x0001094000000000ULL, 0x0000024000000000ULL, 0x0000000000000000ULL,
0x0000001400082f04ULL, 0x000823040000007fULL, 0x0000000000000012ULL, 0x0000001200081204ULL,
0x0008110400000000ULL, 0x0000000000000012ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL,
0x0040000600000000ULL, 0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL,
0x0030000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00b42904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000010000b42804ULL, 0x0000063000000110ULL, 0x0000236000001510ULL,
0x000024c0000023e0ULL, 0x0000297000002600ULL, 0x00002e9000002980ULL, 0x00003c6000003bf0ULL,
0x00003ea000003d60ULL, 0x000040b0000040a0ULL, 0x0000515000004450ULL, 0x000052c0000051c0ULL,
0x0000560000005400ULL, 0x000059d000005610ULL, 0x00006750000066d0ULL, 0x0000697000006830ULL,
0x00006b8000006b70ULL, 0x0000717000007160ULL, 0x00009200000091d0ULL, 0x00009810000097f0ULL,
0x0000fe700000fdc0ULL, 0x00010140000100a0ULL, 0x000103f0000103e0ULL, 0x000105f0000104d0ULL,
0x000001f001f03904ULL, 0x0001b600000000ffULL, 0x000002d000040100ULL, 0x0001b60800000002ULL,
0x000003e0003f0100ULL, 0x0001b68800000002ULL, 0x00000690003f0100ULL, 0x0001b6000000000cULL,
0x000007b0003f0107ULL, 0x0001b68800000000ULL, 0x000020b0003f0101ULL, 0x0001b60800000033ULL,
0x00002110003f0101ULL, 0x0001b60800000037ULL, 0x00002280003f0109ULL, 0x0001b60800000037ULL,
0x00002e00003f0109ULL, 0x0001b6880000004bULL, 0x000039e0003f0101ULL, 0x0001b62800000035ULL,
0x00003a00003f0101ULL, 0x0001b62800000035ULL, 0x00003b70003f0109ULL, 0x0001b62800000035ULL,
0x000043b0003f0109ULL, 0x0001b6900000004bULL, 0x00004f40003f0101ULL, 0x0001b64800000035ULL,
0x00004f60003f0101ULL, 0x0001b64800000035ULL, 0x000050d0003f0109ULL, 0x0001b64800000035ULL,
0x000058f0003f0109ULL, 0x0001b6980000004bULL, 0x000064c0003f0101ULL, 0x0001b66800000037ULL,
0x000064e0003f0101ULL, 0x0001b66800000037ULL, 0x00006650003f0109ULL, 0x0001b66800000037ULL,
0x00006e00003f0109ULL, 0x0001b6a00000004bULL, 0x0000a140003f0101ULL, 0x0001b6000000000cULL,
0x0000b790003f0101ULL, 0x0001b6000000000cULL, 0x0000b900003f0109ULL, 0x0001b6000000000cULL,
0x0000f250003f0109ULL, 0x0001b68800000007ULL, 0x0000f4c0003f0101ULL, 0x0001b68800000007ULL,
0x0000f630003f0109ULL, 0x0001b68800000007ULL, 0x000108e0003f0109ULL, 0x0001b60800000005ULL,
0x000108f0003f0101ULL, 0x0001b61000000005ULL, 0x00010900003f0101ULL, 0x0001b61800000005ULL,
0x00010910003f0101ULL, 0x0001b62000000005ULL, 0x00033803003f0101ULL, 0x00009e4000141c04ULL,
0x0000b9300000a0b0ULL, 0x000109300000b9a0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x00080a0400481903ULL, 0x0048021000000015ULL, 0x00000000000000bcULL,
0x0000001400000002ULL, 0x0000000000010940ULL, 0x0000000000000044ULL, 0x0000001400000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001400000002ULL, 0x0000000000000000ULL,
0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000077919ULL, 0x000eae0000002100ULL,
0x00000000000479c3ULL, 0x000ee20000002500ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x0000000000037919ULL, 0x000f220000002300ULL, 0x0000000000027919ULL, 0x000f6a0000002200ULL,
0x00000300ff0e7b82ULL, 0x000f620000000800ULL, 0x0000010000057ab9ULL, 0x000fe20000000800ULL,
0x0000000000137919ULL, 0x000f620000002700ULL, 0x0000000000157919ULL, 0x000f6a0000008800ULL,
0x00008400ff107b82ULL, 0x000f620000000800ULL, 0x00000000000b7919ULL, 0x000f6e0000000000ULL,
0x00008800ff047b82ULL, 0x000f620000000a00ULL, 0x00000004ff417e24ULL, 0x008fe2000f8e00ffULL,
0x00000005ff437819ULL, 0x004fcc0000011607ULL, 0x00000000000879c3ULL, 0x000ea20000002600ULL,
0x00001fff03007589ULL, 0x010fe800000e0000ULL, 0x00001fff43437589ULL, 0x000ee200000e0000ULL,
0x0000000503027c24ULL, 0x022fe2000f8e0202ULL, 0x0000000000057ab9ULL, 0x000fc60000000800ULL,
0x0000000502077c24ULL, 0x000fca000f8e0207ULL, 0x000000ff0700720cULL, 0x040fe40003f05270ULL,
0x0000000f0700780cULL, 0x040fe40003f24070ULL, 0x000000030700780cULL, 0x000fe20003f44070ULL,
0x0000000400037824ULL, 0x008fd000078e0243ULL, 0x0000000000240947ULL, 0x004fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01b60006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000407027c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000020612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01b60804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000407027c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01b68804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000308047899ULL, 0x000fe2000800063fULL, 0x0000000310027819ULL, 0x000fe200000006ffULL,
0x0000000203067824ULL, 0x000fe200078e00ffULL, 0x00000004ff0a7819ULL, 0x000fe2000001160bULL,
0x00008c00ff087b82ULL, 0x000e620000000a00ULL, 0x0000007f0700780cULL, 0x000fe20003f04070ULL,
0x0000000402027e24ULL, 0x000fe2000f8e0213ULL, 0x00000400000c7802ULL, 0x000fe20000000f00ULL,
0x00000001060f7824ULL, 0x000fe200078e020aULL, 0x00000008060d7848ULL, 0x000fe20007fe0000ULL,
0x000000100b037824ULL, 0x000fe200078e00ffULL, 0x00000654150c7816ULL, 0x000fe2000000000cULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000f02117210ULL, 0x000fe20007ffe0ffULL,
0x000000010d0d7824ULL, 0x000fe200078e0a06ULL, 0x000000000c0472caULL, 0x000fc400000e0000ULL,
0x000000040f127819ULL, 0x000fe200000006ffULL, 0x0000010011047825ULL, 0x000fe200078e0004ULL,
0x0000000c07028211ULL, 0x000fe400078e10ffULL, 0x000000f003117812ULL, 0x000fe200078ec0ffULL,
0x000000010f077824ULL, 0x000fe200078e020bULL, 0x0000000d0a00720cULL, 0x000fe20003f26070ULL,
0xff317217ff158424ULL, 0x000fe200078e00ffULL, 0x0000001104067210ULL, 0x000fe40007f5e0ffULL,
0xfffffff0120d7812ULL, 0x000fe200078ee207ULL, 0x0001b60004047890ULL, 0x000fe2000fffe03fULL,
0x01b4001502008388ULL, 0x0005e20000000800ULL, 0x000000ffff077224ULL, 0x000fc400010e0605ULL,
0x000000100d0d7824ULL, 0x000fe200078e020cULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000413047825ULL, 0x002fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060d7faeULL, 0x0005e2000c901c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe40008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000006040f7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0000720cULL, 0x000fe40003f05270ULL, 0x000000ff0f0d7810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff0d7819ULL, 0x000fce000001160dULL, 0x0000009800688947ULL, 0x000fea0003800000ULL,
0x00000008430a7824ULL, 0x000fe200078e00ffULL, 0x0000000141027810ULL, 0x000fe20007ffe0ffULL,
0x00000004ff037424ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe20000011643ULL,
0x0000000213077824ULL, 0x000fe200078e00ffULL, 0x0000000a0c007210ULL, 0x000fe20007ffe0ffULL,
0x00008e0000047ab9ULL, 0x000fe20000000800ULL, 0x0000000d0200720cULL, 0x000fe20003f06070ULL,
0x0000002009087824ULL, 0x000fe200078e00ffULL, 0x01b6880300ff79a7ULL, 0x0003e2000850003fULL,
0x0000000143067812ULL, 0x000fc400078ec0ffULL, 0x0000010041047824ULL, 0x000fe400078e0208ULL,
0x0000000810007c36ULL, 0x002fc80008000000ULL, 0x0000001007077224ULL, 0x000fc800078e0200ULL,
0x00000004072b7c24ULL, 0x000fe2000f8e0204ULL, 0x0000000400748947ULL, 0x000fec0003800000ULL,
0x00008a00ff027b82ULL, 0x000e620000000a00ULL, 0x00000003ff107819ULL, 0x100fe2000001160bULL,
0x0000400009117824ULL, 0x000fe200078e020cULL, 0x000000040f007248ULL, 0x000fe20007fe0000ULL,
0x0000000806147824ULL, 0x000fe200078e00ffULL, 0x000000ff04057210ULL, 0x000fe20007ffe1ffULL,
0x0000000110047824ULL, 0x000fe200078e020bULL, 0x0000001410187810ULL, 0x000fe20007ffe0ffULL,
0x0000200006117824ULL, 0x000fe200078e0211ULL, 0x0000002000007446ULL, 0x000fe20003800005ULL,
0x0000000c10157836ULL, 0x000fe20000000000ULL, 0x000000102b057210ULL, 0x000fe20007ffe0ffULL,
0x0000001010167836ULL, 0x000fe20000000000ULL, 0x0000000704127812ULL, 0x000fe200078ec0ffULL,
0x00000018101a7836ULL, 0x000fe20000000000ULL, 0x000000001000720cULL, 0x080fe20003f06070ULL,
0x0000001c101c7836ULL, 0x000fe20000000000ULL, 0xfffffff8141b7812ULL, 0x000fe200078ee20bULL,
0x0000000815177824ULL, 0x000fe200078e00ffULL, 0x0001300011117810ULL, 0x000fe20007ffe0ffULL,
0x00000008161d7824ULL, 0x000fe200078e00ffULL, 0x0ffffff812127812ULL, 0x000fe200078ef80bULL,
0x00000008181f7824ULL, 0x000fe200078e00ffULL, 0x0000000810147810ULL, 0x000fe20007ffe0ffULL,
0x0000010005047825ULL, 0x002fe200078e0002ULL, 0x000000001500720cULL, 0x000fc40003f46070ULL,
0x00000003141e7819ULL, 0x000fe200000006ffULL, 0x0000001012137824ULL, 0x000fe200078e0211ULL,
0x000000001400720cULL, 0x080fe20003f26070ULL, 0x000000101b047825ULL, 0x000fe200078e0004ULL,
0x000000001600720cULL, 0x080fe40003f66070ULL, 0x000000001800720cULL, 0x080fe20003f86070ULL,
0x0000000410127836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004137faeULL, 0x0003e2000c101c46ULL, 0x0000000115107824ULL, 0x000fe200078e020bULL,
0x000000001a00720cULL, 0x080fe20003fa6070ULL, 0x000000081c237824ULL, 0x000fe200078e00ffULL,
0x000000001200720cULL, 0x080fe20003f06070ULL, 0x000000012b157824ULL, 0x000fe200078e0215ULL,
0x000000001c00720cULL, 0x000fc40003fc6070ULL, 0xfffffff817107812ULL, 0x000fe400078ee210ULL,
0x000000162b177210ULL, 0x000fe20007ffe0ffULL, 0x0000000114057824ULL, 0x102fe200078e020bULL,
0x0000000b12047210ULL, 0x000fe20007ffe0ffULL, 0x0000000812137824ULL, 0x000fe200078e00ffULL,
0x000000182b197210ULL, 0x000fe40007ffe0ffULL, 0xfffffff81e007812ULL, 0x000fe400078ee205ULL,
0xfffffff813047812ULL, 0x000fe200078ee204ULL, 0x000000012b137824ULL, 0x000fe200078e0214ULL,
0x000000122b057210ULL, 0x000fe20007ffe0ffULL, 0x0000000116127824ULL, 0x100fe200078e020bULL,
0x000000031a217819ULL, 0x000fe200000006ffULL, 0x0000000118147824ULL, 0x100fe200078e020bULL,
0x0000001a2b277210ULL, 0x000fe20007ffe0ffULL, 0x000000011a167824ULL, 0x100fe200078e020bULL,
0xfffffff81d127812ULL, 0x000fe200078ee212ULL, 0x000000011c187824ULL, 0x000fe200078e020bULL,
0xfffffff81f147812ULL, 0x000fe200078ee214ULL, 0x00000010001f7824ULL, 0x100fe200078e0211ULL,
0xfffffff821167812ULL, 0x000fe200078ee216ULL, 0x0000001010217824ULL, 0x100fe200078e0211ULL,
0xfffffff823187812ULL, 0x000fe200078ee218ULL, 0x0000001014257824ULL, 0x100fe200078e0211ULL,
0x00000011041d7211ULL, 0x080fe200078e20ffULL, 0x0000001016297824ULL, 0x000fe200078e0211ULL,
0x0000001112237211ULL, 0x080fe200078e20ffULL, 0x0000010005047825ULL, 0x000fe200078e0002ULL,
0x00000011182d7211ULL, 0x000fc600078e20ffULL, 0x0000010013107825ULL, 0x000fc800078e0002ULL,
0x000000012b2b7824ULL, 0x000fe400078e021cULL, 0x0000010015127825ULL, 0x000fc800078e0002ULL,
0x0000010017147825ULL, 0x000fc800078e0002ULL, 0x0000010019167825ULL, 0x000fc800078e0002ULL,
0x0000010027187825ULL, 0x000fc800078e0002ULL, 0x000001002b027825ULL, 0x000fc800078e0002ULL,
0x000000101b047825ULL, 0x000fc800078e0004ULL, 0x000000101b107825ULL, 0x040fe200078e0010ULL,
0x00000000041d7faeULL, 0x0003e6000c101c46ULL, 0x000000101b127825ULL, 0x040fe200078e0012ULL,
0x00000000101f7faeULL, 0x0003e6000c901c46ULL, 0x000000101b147825ULL, 0x040fe200078e0014ULL,
0x0000000012217faeULL, 0x0003e6000d101c46ULL, 0x000000101b167825ULL, 0x040fe200078e0016ULL,
0x0000000014237faeULL, 0x0003e6000d901c46ULL, 0x000000101b187825ULL, 0x040fe200078e0018ULL,
0x0000000016257faeULL, 0x0003e6000e101c46ULL, 0x000000101b027825ULL, 0x000fe200078e0002ULL,
0x0000000018297faeULL, 0x0003e8000e901c46ULL, 0x00000000022d7faeULL, 0x0003e2000f101c46ULL,
0x0000000400407947ULL, 0x000fea0003800000ULL, 0x000000080b107811ULL, 0x040fe200078fe8ffULL,
0x00008a00ff1a7b82ULL, 0x000e620000000a00ULL, 0x0000000c0b147811ULL, 0x040fe400078fe8ffULL,
0x000000140b1c7811ULL, 0x040fe200078fe8ffULL, 0x0000000810127824ULL, 0x000fe200078e00ffULL,
0x0000000b10037210ULL, 0x000fe20007ffe0ffULL, 0x0000000114057824ULL, 0x040fe200078e020bULL,
0x0000000314187819ULL, 0x000fe200000006ffULL, 0x000000081c1e7824ULL, 0x000fe200078e00ffULL,
0x000000180b207811ULL, 0x000fe200078fe8ffULL, 0x000000012b137824ULL, 0x000fe200078e0214ULL,
0x000000040b027811ULL, 0x000fc400078fe8ffULL, 0xfffffff812127812ULL, 0x000fe200078ee203ULL,
0x000000012b297824ULL, 0x000fe200078e0220ULL, 0xfffffff818157812ULL, 0x000fe200078ee205ULL,
0x0000000120057824ULL, 0x100fe200078e020bULL, 0x0000000b1c037210ULL, 0x000fe20007ffe0ffULL,
0x0000000102007824ULL, 0x140fe200078e020bULL, 0x0000001c0b247811ULL, 0x040fe200078fe8ffULL,
0x0000000802117824ULL, 0x000fe200078e00ffULL, 0x0000000320227819ULL, 0x000fe400000006ffULL,
0x000000100b167811ULL, 0x000fe200078fe8ffULL, 0x0000000824267824ULL, 0x040fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee203ULL, 0x0000000124037824ULL, 0x000fe200078e020bULL,
0xfffffff822227812ULL, 0x000fe200078ee205ULL, 0x000000012b177824ULL, 0x000fe200078e0216ULL,
0x0000000c09057211ULL, 0x000fc400078e70ffULL, 0xfffffff811047812ULL, 0x000fe200078ee200ULL,
0x0000000116007824ULL, 0x040fe200078e020bULL, 0xfffffff826267812ULL, 0x000fe200078ee203ULL,
0x0000000816117824ULL, 0x000fe200078e00ffULL, 0x0000001c2b197210ULL, 0x000fe20007ffe0ffULL,
0x0000200006037824ULL, 0x040fe200078e0205ULL, 0x000000242b2d7210ULL, 0x000fe20007ffe0ffULL,
0x000000012b057824ULL, 0x000fe200078e0202ULL, 0xfffffff811187812ULL, 0x000fe200078ee200ULL,
0x00013000032f7836ULL, 0x000fe20000000000ULL, 0x0000000b0b007211ULL, 0x040fe200078fe8ffULL,
0x0000000806027824ULL, 0x000fe200078e00ffULL, 0x0000002b0b037211ULL, 0x000fe200078fe8ffULL,
0x0000001012217824ULL, 0x100fe200078e022fULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x0000001015237824ULL, 0x000fe200078e022fULL, 0x000000102b117210ULL, 0x000fe20007ffe0ffULL,
0x0000010013127825ULL, 0x002fe200078e001aULL, 0xfffffff802317812ULL, 0x000fc400078ee20bULL,
0x0000002f041f7211ULL, 0x080fe200078e20ffULL, 0x0000010003027825ULL, 0x100fe200078e001aULL,
0x0ffffff800007812ULL, 0x000fe400078ef80bULL, 0x0000002f18257211ULL, 0x000fe200078e20ffULL,
0x0000010005047825ULL, 0x000fc800078e001aULL, 0x0000010011107825ULL, 0x000fc800078e001aULL,
0x0000010017147825ULL, 0x000fc800078e001aULL, 0x0000010019167825ULL, 0x000fc800078e001aULL,
0x00000010001d7824ULL, 0x000fe400078e022fULL, 0x0000010029187825ULL, 0x000fc800078e001aULL,
0x0000001031027825ULL, 0x000fc800078e0002ULL, 0x000001002d1a7825ULL, 0x000fe200078e001aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000021d7faeULL, 0x0003e6000b901c46ULL,
0x0000001031047825ULL, 0x000fc800078e0004ULL, 0x0000001031107825ULL, 0x040fe200078e0010ULL,
0x00000000041f7faeULL, 0x0003e6000b901c46ULL, 0x0000001031127825ULL, 0x040fe200078e0012ULL,
0x0000000010217faeULL, 0x0003e6000b901c46ULL, 0x0000001031147825ULL, 0x040fe200078e0014ULL,
0x0000000012237faeULL, 0x0003e6000b901c46ULL, 0x000000101e277824ULL, 0x000fe200078e022fULL,
0x0000000014257faeULL, 0x0003e2000b901c46ULL, 0x0000001031167825ULL, 0x000fc800078e0016ULL,
0x00000010222b7824ULL, 0x000fe200078e022fULL, 0x0000002f262f7211ULL, 0x000fe200078e20ffULL,
0x0000001031187825ULL, 0x040fe200078e0018ULL, 0x0000000016277faeULL, 0x0003e6000b901c46ULL,
0x00000010311a7825ULL, 0x000fe200078e001aULL, 0x00000000182b7faeULL, 0x0003e8000b901c46ULL,
0x000000001a2f7faeULL, 0x0003e4000b901c46ULL, 0x0000000d4100720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff587424ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x002fe2000001ff00ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000058009c0947ULL, 0x000fec0003800000ULL,
0xff31721700587802ULL, 0x000fe20000000f00ULL, 0x000000ffff5a7224ULL, 0x000fe400078e00ffULL,
0x000000ffff2f7224ULL, 0x000fce00078e00ffULL, 0x0000000841047819ULL, 0x000fc800000006ffULL,
0x0000000f0400720cULL, 0x000fda0003f06070ULL, 0x0000005800780947ULL, 0x000fea0003800000ULL,
0x0000000141047836ULL, 0x000fe20000000000ULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x0000010041577824ULL, 0x000fc600078e0208ULL, 0x0000000d0400720cULL, 0x000fe20003f06070ULL,
0x000000ffff047224ULL, 0x000fe200078e005aULL, 0x0000004057367810ULL, 0x000fca0007ffe0ffULL,
0x0000000407347c24ULL, 0x000fe2000f8e0236ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000004007c8947ULL, 0x000fea0003800000ULL, 0x00008a00ff307b82ULL, 0x000e620000000a00ULL,
0x000000ffff337224ULL, 0x000fe200078e0a36ULL, 0x000000360f327248ULL, 0x000fe20007fe0000ULL,
0x00000008063e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff387819ULL, 0x000fe4000001160bULL,
0x0000002032337446ULL, 0x000fe20003800033ULL, 0x000010005a327824ULL, 0x000fe200078e00ffULL,
0x0000000c09357211ULL, 0x000fe200078e70ffULL, 0x0000000138377824ULL, 0x140fe200078e0234ULL,
0x0000000b38367210ULL, 0x000fe20007ffe0ffULL, 0x0000001038427836ULL, 0x000fe20000000000ULL,
0x000000333800720cULL, 0x000fe20003f06070ULL, 0x00002000063c7824ULL, 0x000fe200078e0235ULL,
0x0000100032357812ULL, 0x000fe200078e0cffULL, 0x0000001438447836ULL, 0x000fe20000000000ULL,
0x00000007363a7812ULL, 0x000fe200078ec0ffULL, 0x0000001c38487836ULL, 0x000fe20000000000ULL,
0xfffffff83e327812ULL, 0x000fe200078ee20bULL, 0x00000001443d7824ULL, 0x000fe200078e0234ULL,
0x000130003c357810ULL, 0x000fe20007ffe035ULL, 0x00000008383c7836ULL, 0x000fe20000000000ULL,
0x0ffffff83a3a7812ULL, 0x000fe200078ef80bULL, 0x0000000842457824ULL, 0x000fe200078e00ffULL,
0x0000000c383e7810ULL, 0x000fe20007ffe0ffULL, 0x0000010037367825ULL, 0x002fe200078e0030ULL,
0x000000353a397211ULL, 0x000fc400078e20ffULL, 0x0000001838467810ULL, 0x000fe20007ffe0ffULL,
0x00000004383a7836ULL, 0x000fe20000000000ULL, 0x000000333c00720cULL, 0x080fe20003f26070ULL,
0x0000001032367825ULL, 0x000fe200078e0036ULL, 0x000000333e00720cULL, 0x080fe40003f46070ULL,
0x000000033a3b7819ULL, 0x000fe200000006ffULL, 0x000000083c387824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036397faeULL, 0x0003e2000c101c46ULL,
0x000000083e407824ULL, 0x000fe200078e00ffULL, 0x000000333a00720cULL, 0x080fe20003f06070ULL,
0x00000001463f7824ULL, 0x100fe200078e0234ULL, 0x000000334200720cULL, 0x080fe20003f66070ULL,
0x0000000846497824ULL, 0x000fe200078e00ffULL, 0x000000334400720cULL, 0x080fe20003f86070ULL,
0x00000008484b7824ULL, 0x000fe200078e00ffULL, 0x000000334600720cULL, 0x080fe20003fa6070ULL,
0x0000000844477824ULL, 0x000fe200078e00ffULL, 0x000000334800720cULL, 0x000fe20003fc6070ULL,
0x000000013a337824ULL, 0x140fe200078e0234ULL, 0x0000000b3e397210ULL, 0x002fe20007ffe0ffULL,
0x000000013a367824ULL, 0x100fe200078e020bULL, 0x0000003448517210ULL, 0x000fe20007ffe0ffULL,
0x000000013c377824ULL, 0x000fe200078e020bULL, 0xfffffff840407812ULL, 0x000fe200078ee239ULL,
0x000000013e397824ULL, 0x100fe200078e0234ULL, 0xfffffff83b367812ULL, 0x000fe200078ee236ULL,
0x00000001423b7824ULL, 0x000fe200078e0234ULL, 0xfffffff838387812ULL, 0x000fc400078ee237ULL,
0x000000343c377210ULL, 0x000fe20007ffe0ffULL, 0x0000000146347824ULL, 0x000fe200078e020bULL,
0x0000000b423a7210ULL, 0x000fe40007ffe0ffULL, 0x0000000b483e7210ULL, 0x000fe40007ffe0ffULL,
0x0000000b443c7210ULL, 0x000fe40007ffe0ffULL, 0xfffffff8453a7812ULL, 0x000fe200078ee23aULL,
0x0000001036457824ULL, 0x100fe200078e0235ULL, 0xfffffff849347812ULL, 0x000fe200078ee234ULL,
0x0000001040497824ULL, 0x100fe200078e0235ULL, 0xfffffff84b3e7812ULL, 0x000fe200078ee23eULL,
0x000000103a4b7824ULL, 0x100fe200078e0235ULL, 0xfffffff8473c7812ULL, 0x000fe200078ee23cULL,
0x00000010344f7824ULL, 0x100fe200078e0235ULL, 0x0000003538477211ULL, 0x080fe200078e20ffULL,
0x000000103e537824ULL, 0x000fe200078e0235ULL, 0x000000353c4d7211ULL, 0x000fe200078e20ffULL,
0x0000010033347825ULL, 0x000fc800078e0030ULL, 0x0000010037367825ULL, 0x000fc800078e0030ULL,
0x0000010039387825ULL, 0x000fc800078e0030ULL, 0x000001003b3a7825ULL, 0x000fc800078e0030ULL,
0x000001003d3c7825ULL, 0x000fc800078e0030ULL, 0x000001003f3e7825ULL, 0x000fc800078e0030ULL,
0x0000010051307825ULL, 0x000fc800078e0030ULL, 0x0000001032347825ULL, 0x000fc800078e0034ULL,
0x0000001032367825ULL, 0x040fe200078e0036ULL, 0x0000000034457faeULL, 0x0003e6000c101c46ULL,
0x0000001032387825ULL, 0x040fe200078e0038ULL, 0x0000000036477faeULL, 0x0003e6000c901c46ULL,
0x00000010323a7825ULL, 0x040fe200078e003aULL, 0x0000000038497faeULL, 0x0003e6000d101c46ULL,
0x00000010323c7825ULL, 0x040fe200078e003cULL, 0x000000003a4b7faeULL, 0x0003e6000d901c46ULL,
0x00000010323e7825ULL, 0x040fe200078e003eULL, 0x000000003c4d7faeULL, 0x0003e6000e101c46ULL,
0x0000001032307825ULL, 0x000fe200078e0030ULL, 0x000000003e4f7faeULL, 0x0003e8000e901c46ULL,
0x0000000030537faeULL, 0x0003e2000f101c46ULL, 0x0000000400487947ULL, 0x000fea0003800000ULL,
0x0000000c09317211ULL, 0x000fe200078e70ffULL, 0x000010005a307824ULL, 0x000fe200078e00ffULL,
0x000000040b357811ULL, 0x040fe400078fe8ffULL, 0x000000080b377811ULL, 0x000fe200078fe8ffULL,
0x0000200006317824ULL, 0x000fe200078e0231ULL, 0x0000100030307812ULL, 0x000fe200078e0cffULL,
0x00000008353d7824ULL, 0x000fe200078e00ffULL, 0x0000000337387819ULL, 0x000fe400000006ffULL,
0x0001300031557810ULL, 0x000fe20007ffe030ULL, 0x0000000137317824ULL, 0x000fe200078e020bULL,
0x0000000b35307210ULL, 0x000fe20007ffe0ffULL, 0x0000000135357824ULL, 0x000fe200078e0234ULL,
0x0000000c0b397811ULL, 0x000fc400078fe8ffULL, 0xfffffff83d367812ULL, 0x000fe400078ee230ULL,
0xfffffff838387812ULL, 0x000fe200078ee231ULL, 0x0000000139327824ULL, 0x000fe200078e020bULL,
0x00008a00ff307b82ULL, 0x000e620000000a00ULL, 0x000000100b3b7811ULL, 0x000fe200078fe8ffULL,
0x00000008393f7824ULL, 0x000fe200078e00ffULL, 0x000000140b3d7811ULL, 0x000fe200078fe8ffULL,
0x0000000139397824ULL, 0x100fe200078e0234ULL, 0x0000000b3b337210ULL, 0x000fe20007ffe0ffULL,
0x000000083b3c7824ULL, 0x040fe200078e00ffULL, 0xfffffff83f3a7812ULL, 0x000fe200078ee232ULL,
0x000000013b3b7824ULL, 0x000fe200078e0234ULL, 0x0000000b0b327211ULL, 0x000fc400078fe8ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee233ULL, 0x000000013d337824ULL, 0x000fe200078e020bULL,
0x000000180b3f7811ULL, 0x040fe200078fe8ffULL, 0x000000103a4b7824ULL, 0x100fe200078e0255ULL,
0x0000001c0b537811ULL, 0x000fe200078fe8ffULL, 0x000000103c4d7824ULL, 0x000fe200078e0255ULL,
0x000000033d3e7819ULL, 0x000fe200000006ffULL, 0x000000013f407824ULL, 0x040fe200078e020bULL,
0x0000000732327812ULL, 0x000fe200078ec0ffULL, 0x000000083f457824ULL, 0x000fe200078e00ffULL,
0x0000000b53427210ULL, 0x000fe20007ffe0ffULL, 0x0000000853477824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee233ULL, 0x000000013f3f7824ULL, 0x100fe200078e0234ULL,
0x0ffffff832327812ULL, 0x000fe200078ef80bULL, 0x0000000153537824ULL, 0x000fe200078e0234ULL,
0x0000003437377210ULL, 0x000fe20007ffe0ffULL, 0x000001003b3a7825ULL, 0x002fe200078e0030ULL,
0x000000343d3d7210ULL, 0x000fc40007ffe0ffULL, 0x000000340b337211ULL, 0x000fe400078fe8ffULL,
0x0000000306347819ULL, 0x000fe200000006ffULL, 0x000001003d3c7825ULL, 0x000fe200078e0030ULL,
0xfffffff845407812ULL, 0x000fe400078ee240ULL, 0xfffffff847427812ULL, 0x000fe200078ee242ULL,
0x0000001032457824ULL, 0x000fe200078e0255ULL, 0xfffffff834597812ULL, 0x000fe200078ee20bULL,
0x0000010033327825ULL, 0x000fe200078e0030ULL, 0x0000005538497211ULL, 0x000fc400078e20ffULL,
0x000000553e4f7211ULL, 0x000fe200078e20ffULL, 0x0000001036477824ULL, 0x000fe400078e0255ULL,
0x0000010035347825ULL, 0x000fc800078e0030ULL, 0x0000010037367825ULL, 0x000fc800078e0030ULL,
0x0000010039387825ULL, 0x000fc800078e0030ULL, 0x000001003f3e7825ULL, 0x000fc800078e0030ULL,
0x0000001059327825ULL, 0x000fc800078e0032ULL, 0x0000010053307825ULL, 0x000fe200078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000032457faeULL, 0x0003e6000b901c46ULL,
0x0000001059347825ULL, 0x000fc800078e0034ULL, 0x0000001059367825ULL, 0x040fe200078e0036ULL,
0x0000000034477faeULL, 0x0003e6000b901c46ULL, 0x0000001059387825ULL, 0x040fe200078e0038ULL,
0x0000000036497faeULL, 0x0003e6000b901c46ULL, 0x00000010593a7825ULL, 0x040fe200078e003aULL,
0x00000000384b7faeULL, 0x0003e6000b901c46ULL, 0x00000010593c7825ULL, 0x040fe200078e003cULL,
0x000000003a4d7faeULL, 0x0003e6000b901c46ULL, 0x0000001040517824ULL, 0x000fe200078e0255ULL,
0x000000003c4f7faeULL, 0x0003e2000b901c46ULL, 0x00000010593e7825ULL, 0x000fc800078e003eULL,
0x0000001042557824ULL, 0x000fe200078e0255ULL, 0x000000003e517faeULL, 0x0003e2000b901c46ULL,
0x0000001059307825ULL, 0x000fca00078e0030ULL, 0x0000000030557faeULL, 0x0003e4000b901c46ULL,
0xffffffe00a317812ULL, 0x042fe200078ec0ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x000000100a337812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000310c327210ULL, 0x000fca0007ffe0ffULL, 0x0000000132337824ULL, 0x000fca00078e0233ULL,
0x0000003306337211ULL, 0x000fc800078e18ffULL, 0x01b60834333479a7ULL, 0x0002a6000850003fULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x0000001009337824ULL, 0x002fca00078e00ffULL,
0x0000001033337812ULL, 0x000fca00078ec0ffULL, 0x0000000132337824ULL, 0x000fca00078e0233ULL,
0x0000003306377211ULL, 0x000fc800078e18ffULL, 0x01b60835370075a7ULL, 0x004ee4000800017fULL,
0x00000000005c0947ULL, 0x00efea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230397210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003932327211ULL, 0x000fc800078110ffULL, 0x00000033ff337210ULL, 0x000fc800007fe4ffULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01b60835370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000002043307824ULL, 0x000fe200078e00ffULL, 0x000000040b567819ULL, 0x000fe200000006ffULL,
0x000000ffff537224ULL, 0x000fe200078e0058ULL, 0x00000001ff517819ULL, 0x000fe4000001160bULL,
0xffffff8030317812ULL, 0x000fe400078ec0ffULL, 0x0000007056567812ULL, 0x000fe400078ec0ffULL,
0x0000000c51517812ULL, 0x000fe200078ec0ffULL, 0x000000010c547824ULL, 0x000fca00078e0231ULL,
0x0000005451307210ULL, 0x000fca0007ffe056ULL, 0x01b0000030317984ULL, 0x000e680000000800ULL,
0x01b2000030597984ULL, 0x0004a20000000800ULL, 0x000000583100720bULL, 0x002fda0003f1d000ULL,
0x0000000000327806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff32337812ULL, 0x000fda000782c0ffULL, 0x0000000000f49947ULL, 0x004fea0003800000ULL,
0x00000002ff307819ULL, 0x000fe40000011643ULL, 0x000000583100720bULL, 0x000fe40003f34000ULL,
0x000000433000720cULL, 0x000fe40003f45270ULL, 0x0000003158537209ULL, 0x000fd20007810000ULL,
0x0000000000347806ULL, 0x000fe400008e0100ULL, 0x0000000c4330a211ULL, 0x000fe400078e38ffULL,
0x0000991034327816ULL, 0x000fe400000000ffULL, 0x000000305130a210ULL, 0x000fe40007ffe056ULL,
0x000000ff3200720cULL, 0x000fc60003f25270ULL, 0x01b400533000a388ULL, 0x0003f40000000800ULL,
0x0000000000b09947ULL, 0x002fea0003800000ULL, 0x8000005358307221ULL, 0x000fe20000010000ULL,
0x000000ff34ff7812ULL, 0x040fe4000782c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL, 0x0000003000357308ULL, 0x0002ac0000000800ULL,
0x0000000000489947ULL, 0x000fea0003800000ULL, 0x00000002ff307819ULL, 0x002fcc000001160bULL,
0x00001f3035307589ULL, 0x004e6400000e0000ULL, 0x0000003010107220ULL, 0x082fe20000410000ULL,
0x0000003011117220ULL, 0x080fe20000410000ULL, 0x0000003014147220ULL, 0x080fe20000410000ULL,
0x0000003015157220ULL, 0x080fe20000410000ULL, 0x0000003018187220ULL, 0x080fe20000410000ULL,
0x0000003019197220ULL, 0x080fe20000410000ULL, 0x000000301c1c7220ULL, 0x080fe20000410000ULL,
0x000000301d1d7220ULL, 0x080fe20000410000ULL, 0x0000003020207220ULL, 0x080fe20000410000ULL,
0x0000003021217220ULL, 0x080fe20000410000ULL, 0x0000003024247220ULL, 0x080fe20000410000ULL,
0x0000003025257220ULL, 0x080fe20000410000ULL, 0x0000003028287220ULL, 0x080fe20000410000ULL,
0x0000003029297220ULL, 0x080fe20000410000ULL, 0x000000302c2c7220ULL, 0x080fe20000410000ULL,
0x000000302d2d7220ULL, 0x000fce0000410000ULL, 0x0000003505057220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x000000080b307811ULL, 0x002fcc00078ff0ffULL,
0x00001f3035307589ULL, 0x000e6400000e0000ULL, 0x0000003012127220ULL, 0x082fe20000410000ULL,
0x0000003013137220ULL, 0x080fe20000410000ULL, 0x0000003016167220ULL, 0x080fe20000410000ULL,
0x0000003017177220ULL, 0x080fe20000410000ULL, 0x000000301a1a7220ULL, 0x080fe20000410000ULL,
0x000000301b1b7220ULL, 0x080fe20000410000ULL, 0x000000301e1e7220ULL, 0x080fe20000410000ULL,
0x000000301f1f7220ULL, 0x080fe20000410000ULL, 0x0000003022227220ULL, 0x080fe20000410000ULL,
0x0000003023237220ULL, 0x080fe20000410000ULL, 0x0000003026267220ULL, 0x080fe20000410000ULL,
0x0000003027277220ULL, 0x080fe20000410000ULL, 0x000000302a2a7220ULL, 0x080fe20000410000ULL,
0x000000302b2b7220ULL, 0x080fe20000410000ULL, 0x000000302e2e7220ULL, 0x080fe20000410000ULL,
0x000000302f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff33ff7812ULL, 0x000fda0007826034ULL,
0x8000005331311221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b31311820ULL, 0x000fc80000410000ULL, 0x0000003100021308ULL, 0x000ea40000000800ULL,
0x0000000259591220ULL, 0x004fce0000410000ULL, 0x000000080b407812ULL, 0x000fe200078ec0ffULL,
0x0000400009557824ULL, 0x000fe200078e020cULL, 0x0000000943307819ULL, 0x002fe200000006ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000740407812ULL, 0x000fe200078ef80bULL,
0x0000200006557824ULL, 0x000fe200078e0255ULL, 0x00000004ff347819ULL, 0x000fe4000001160bULL,
0x000000400b327211ULL, 0x040fe200078fe0ffULL, 0x0000000840317824ULL, 0x040fe200078e00ffULL,
0x000000070b527812ULL, 0x000fe200078ec0ffULL, 0x0000000840367824ULL, 0x000fe200078e00ffULL,
0xfffff80030337812ULL, 0x000fe200078ec0ffULL, 0x00000002324e7836ULL, 0x000fe20000000000ULL,
0x0000000852427812ULL, 0x000fe200078ef80bULL, 0x000010005a4b7824ULL, 0x000fe200078e0255ULL,
0x000000330c4a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000840357824ULL, 0x000fe200078e00ffULL,
0xfffffff8314e7812ULL, 0x000fe200078ee24eULL, 0x0000000409317824ULL, 0x000fe200078e0234ULL,
0x00000004324d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000842337824ULL, 0x000fe200078e00ffULL,
0x00000003404f7819ULL, 0x000fe200000006ffULL, 0x0000000142487824ULL, 0x000fe200078e0231ULL,
0xfffffff8364d7812ULL, 0x000fc400078ee24dULL, 0xfffffff84f4f7812ULL, 0x000fe400078ee232ULL,
0xfffffff833337812ULL, 0x000fe400078ee248ULL, 0x000130004b4b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160bULL,
0x00000002ff00723eULL, 0x000fc600000000ffULL, 0x0000000803317836ULL, 0x000fe20000000000ULL,
0x0000541000307816ULL, 0x000fca0000000000ULL, 0x00001f0330037589ULL, 0x0002a800000e0000ULL,
0x00001f3130007589ULL, 0x0002e400000e0000ULL, 0x0000001033507824ULL, 0x000fe200078e024aULL,
0x00000006324c7810ULL, 0x000fe20007ffe0ffULL, 0x000000104f447824ULL, 0x100fe200078e024bULL,
0x0000004b4d387211ULL, 0x000fe200078e20ffULL, 0x000000104e3c7824ULL, 0x000fe200078e024bULL,
0x011000005030783bULL, 0x0022e20000000200ULL, 0x0000000000108947ULL, 0x000fea0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000031317232ULL, 0x080fe40000000000ULL, 0x0000000033337232ULL, 0x000fce0000000000ULL,
0xfffffff8354c7812ULL, 0x000fe200078ee24cULL, 0x000000003838783bULL, 0x000f220000004200ULL,
0x0000001040407812ULL, 0x000fe400078efcffULL, 0x0000000248487810ULL, 0x000fe20007ffe0ffULL,
0x000000104c347824ULL, 0x000fe200078e024bULL, 0x000000004444783bULL, 0x000fe20000004200ULL,
0x0000000840497824ULL, 0x000fc600078e00ffULL, 0x000000003c3c783bULL, 0x000fe80000004200ULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x000000383020723cULL, 0x018fec0000001820ULL,
0x0000003a3024723cULL, 0x000fe20000001824ULL, 0x0000000842397824ULL, 0x000fe200078e00ffULL,
0x000000400b387211ULL, 0x000fc800078fe0ffULL, 0xfffffff839397812ULL, 0x000fe200078ee248ULL,
0x000000343028723cULL, 0x022fe20000001828ULL, 0x00000008403b7824ULL, 0x040fe200078e00ffULL,
0x0000000238487810ULL, 0x000fe20007ffe0ffULL, 0x0000000438427836ULL, 0x000fe20000000000ULL,
0x0000004a394a7211ULL, 0x000fe400078e20ffULL, 0xfffffff849497812ULL, 0x000fe200078ee238ULL,
0x0000000840357824ULL, 0x000fe200078e00ffULL, 0xfffffff83b427812ULL, 0x000fe200078ee242ULL,
0x000000443010723cULL, 0x000fe20000001810ULL, 0x0000000638407836ULL, 0x000fc40000000000ULL,
0xfffffff835487812ULL, 0x000fe200078ee248ULL, 0x0000001049397824ULL, 0x000fe400078e024bULL,
0x000000463014723cULL, 0x000fe20000001814ULL, 0x0000004b48447211ULL, 0x000fca00078e20ffULL,
0x0000003c3018723cULL, 0x000fec0000001818ULL, 0x0000003e301c723cULL, 0x000fe2000000181cULL,
0x00000010423c7824ULL, 0x000fca00078e024bULL, 0x00000036302c723cULL, 0x000fe2000000182cULL,
0x011000004a30783bULL, 0x0002e20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000031317232ULL, 0x080fe40000000000ULL,
0x0000000033337232ULL, 0x000fce0000000000ULL, 0xfffffff835407812ULL, 0x000fe200078ee240ULL,
0x000000004444783bULL, 0x000f220000004200ULL, 0x0000000559057221ULL, 0x000fe20000010000ULL,
0x0000005300587202ULL, 0x000fe40000000f00ULL, 0x0000001040347824ULL, 0x000fe200078e024bULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x000000015a5a7812ULL, 0x000fc600078e0cffULL,
0x000000003938783bULL, 0x000f680000004200ULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x000000443018723cULL, 0x018fec0000001818ULL, 0x00000046301c723cULL, 0x000fec000000181cULL,
0x0000003c3020723cULL, 0x022fec0000001820ULL, 0x0000003e3024723cULL, 0x000fec0000001824ULL,
0x000000383010723cULL, 0x000fe20000001810ULL, 0x00000001ff3e7424ULL, 0x000fca00078e00ffULL,
0x0000003a3014723cULL, 0x000fe20000001814ULL, 0x0000000143387819ULL, 0x000fc800000006ffULL,
0xfffffff8384b7812ULL, 0x000fe200078ec0ffULL, 0x000000343028723cULL, 0x004fe80000001828ULL,
0x000000010c4b7824ULL, 0x000fe400078e024bULL, 0x00000036302c723cULL, 0x000fe4000000182cULL,
0x01b6883e4bff79a7ULL, 0x0003ea000850003fULL, 0x0000004041307811ULL, 0x000fc800078e40ffULL,
0x0000000f3000720cULL, 0x000fda0003f06070ULL, 0x0000004000100947ULL, 0x002fea0003800000ULL,
0x0000000141307836ULL, 0x000fe20000000000ULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x0000008057327836ULL, 0x000fc60000000000ULL, 0x0000000d3000720cULL, 0x000fe20003f06070ULL,
0x0000000407347c24ULL, 0x000fe2000f8e0232ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0000000400748947ULL, 0x000fea0003800000ULL, 0x00008a00ff367b82ULL, 0x000e620000000a00ULL,
0x000000320f307248ULL, 0x000fe20007fe0000ULL, 0x00000008063f7824ULL, 0x000fe200078e00ffULL,
0x000000ff32317210ULL, 0x000fe40007ffe1ffULL, 0x00000003ff357819ULL, 0x100fe4000001160bULL,
0x0000002030327446ULL, 0x000fe20003800031ULL, 0x0000100004307824ULL, 0x000fe200078e00ffULL,
0x0000003435317210ULL, 0x000fe20007ffe0ffULL, 0x0000000135337824ULL, 0x040fe200078e020bULL,
0x000000323500720cULL, 0x000fe20003f06070ULL, 0x00000008353b7836ULL, 0x000fe20000000000ULL,
0x0000100030387812ULL, 0x000fe200078ec0ffULL, 0x0000000c353d7836ULL, 0x000fe20000000000ULL,
0x00000007333a7812ULL, 0x000fe200078ec0ffULL, 0x00000014355d7836ULL, 0x000fe20000000000ULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee252ULL, 0x00000018355f7836ULL, 0x000fe20000000000ULL,
0x0001300055387810ULL, 0x000fc40007ffe038ULL, 0x0ffffff83a337812ULL, 0x000fe200078ef80bULL,
0x000000083b3a7824ULL, 0x000fe200078e00ffULL, 0x0000000435397810ULL, 0x000fe20007ffe0ffULL,
0x0000010031307825ULL, 0x002fe200078e0036ULL, 0x00000010355b7810ULL, 0x000fe40007ffe0ffULL,
0x0000001c35637810ULL, 0x000fe20007ffe0ffULL, 0x0000001033337824ULL, 0x000fe200078e0238ULL,
0x000000033d3c7819ULL, 0x000fe200000006ffULL, 0x000000103f307825ULL, 0x000fe200078e0030ULL,
0x000000323b00720cULL, 0x000fc40003f26070ULL, 0x000000323d00720cULL, 0x080fe20003f46070ULL,
0x0000000839457824ULL, 0x040fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030337faeULL, 0x0003e2000c101c46ULL, 0x000000323900720cULL, 0x0c0fe20003f06070ULL,
0x0000000139357824ULL, 0x100fe200078e0234ULL, 0x000000325b00720cULL, 0x080fe20003f66070ULL,
0x0000000163617824ULL, 0x000fe200078e0234ULL, 0x000000325d00720cULL, 0x080fe40003f86070ULL,
0x000000325f00720cULL, 0x080fe40003fa6070ULL, 0x000000326300720cULL, 0x000fe20003fc6070ULL,
0x000000015d327824ULL, 0x000fc400078e020bULL, 0x000000013d337824ULL, 0x102fe200078e020bULL,
0x0000000b3b317210ULL, 0x000fe20007ffe0ffULL, 0x0000000139307824ULL, 0x100fe200078e020bULL,
0x000000343d3d7210ULL, 0x000fe20007ffe0ffULL, 0x000000013b3b7824ULL, 0x100fe200078e0234ULL,
0xfffffff83a477812ULL, 0x000fe200078ee231ULL, 0x000000015b397824ULL, 0x100fe200078e0234ULL,
0xfffffff83c597812ULL, 0x000fe200078ee233ULL, 0x000000015d317824ULL, 0x100fe200078e0234ULL,
0xfffffff845457812ULL, 0x000fe200078ee230ULL, 0x000000015f337824ULL, 0x000fe200078e0234ULL,
0x0000000b5f347210ULL, 0x000fe20007ffe0ffULL, 0x000000015b307824ULL, 0x140fe200078e020bULL,
0x000000035b5b7819ULL, 0x000fe200000006ffULL, 0x00000001633a7824ULL, 0x000fe200078e020bULL,
0x000000035d5d7819ULL, 0x000fe200000006ffULL, 0x000000085f5f7824ULL, 0x000fe200078e00ffULL,
0x0000000363637819ULL, 0x000fe200000006ffULL, 0x0000001045457824ULL, 0x100fe200078e0238ULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee230ULL, 0x0000001047477824ULL, 0x000fe200078e0238ULL,
0xfffffff85d5d7812ULL, 0x000fe200078ee232ULL, 0x000001003d3c7825ULL, 0x000fe200078e0036ULL,
0xfffffff863637812ULL, 0x000fc400078ee23aULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee234ULL,
0x0000010035347825ULL, 0x100fe200078e0036ULL, 0x0000003859597211ULL, 0x080fe400078e20ffULL,
0x000000385f5f7211ULL, 0x000fe200078e20ffULL, 0x000001003b3a7825ULL, 0x000fc800078e0036ULL,
0x000000105b5b7824ULL, 0x100fe400078e0238ULL, 0x000000105d5d7824ULL, 0x100fe400078e0238ULL,
0x0000001063637824ULL, 0x000fe400078e0238ULL, 0x0000010039387825ULL, 0x000fc800078e0036ULL,
0x0000010031307825ULL, 0x000fc800078e0036ULL, 0x0000010033327825ULL, 0x000fc800078e0036ULL,
0x0000010061367825ULL, 0x000fc800078e0036ULL, 0x000000103f347825ULL, 0x000fc800078e0034ULL,
0x000000103f3a7825ULL, 0x040fe200078e003aULL, 0x0000000034457faeULL, 0x0003e6000c101c46ULL,
0x000000103f3c7825ULL, 0x040fe200078e003cULL, 0x000000003a477faeULL, 0x0003e6000c901c46ULL,
0x000000103f387825ULL, 0x040fe200078e0038ULL, 0x000000003c597faeULL, 0x0003e6000d101c46ULL,
0x000000103f307825ULL, 0x040fe200078e0030ULL, 0x00000000385b7faeULL, 0x0003e6000d901c46ULL,
0x000000103f327825ULL, 0x040fe200078e0032ULL, 0x00000000305d7faeULL, 0x0003e6000e101c46ULL,
0x000000103f367825ULL, 0x000fe200078e0036ULL, 0x00000000325f7faeULL, 0x0003e8000e901c46ULL,
0x0000000036637faeULL, 0x0003e2000f101c46ULL, 0x0000000400407947ULL, 0x000fea0003800000ULL,
0x0000000c0b457811ULL, 0x040fe400078fe8ffULL, 0x000000040b377811ULL, 0x000fe400078fe8ffULL,
0x0000000b45327210ULL, 0x000fe20007ffe0ffULL, 0x0000000845357824ULL, 0x000fe200078e00ffULL,
0x0000000337337819ULL, 0x040fe200000006ffULL, 0x0000000137307824ULL, 0x000fe200078e020bULL,
0x000000100b3b7811ULL, 0x000fe200078fe8ffULL, 0x0000000137377824ULL, 0x100fe200078e0234ULL,
0xfffffff8353c7812ULL, 0x000fe200078ee232ULL, 0x0000000145457824ULL, 0x000fe200078e0234ULL,
0x000000180b357811ULL, 0x000fc400078fe8ffULL, 0xfffffff833387812ULL, 0x000fe200078ee230ULL,
0x000000013b307824ULL, 0x100fe200078e020bULL, 0x000000080b3d7811ULL, 0x000fe200078fe8ffULL,
0x00000008353f7824ULL, 0x000fe200078e00ffULL, 0x000000033b337819ULL, 0x040fe200000006ffULL,
0x000000013b3b7824ULL, 0x100fe200078e0234ULL, 0x0000000b35327210ULL, 0x000fe20007ffe0ffULL,
0x000000013d317824ULL, 0x140fe200078e020bULL, 0xfffffff833447812ULL, 0x000fe200078ee230ULL,
0x000000083d3a7824ULL, 0x000fe200078e00ffULL, 0xfffffff83f587812ULL, 0x000fe200078ee232ULL,
0x0000100004307824ULL, 0x000fe200078e00ffULL, 0x000000140b397811ULL, 0x000fe200078fe8ffULL,
0x00008a00ff327b82ULL, 0x000e620000000a00ULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee231ULL,
0x0000000135357824ULL, 0x000fe200078e0234ULL, 0x0000001c0b637811ULL, 0x000fe200078fe8ffULL,
0x0000000139317824ULL, 0x140fe200078e020bULL, 0x0000100030307812ULL, 0x000fe200078ec0ffULL,
0x0000000839467824ULL, 0x000fe200078e00ffULL, 0x00000003633f7819ULL, 0x040fe200000006ffULL,
0x0000000163367824ULL, 0x000fe200078e020bULL, 0x0001300055657810ULL, 0x000fe20007ffe030ULL,
0x0000000163637824ULL, 0x000fe200078e0234ULL, 0xfffffff846467812ULL, 0x000fc400078ee231ULL,
0x0000000b0b317211ULL, 0x000fe200078fe8ffULL, 0x000000103c5b7824ULL, 0x100fe200078e0265ULL,
0xfffffff83f5a7812ULL, 0x000fe200078ee236ULL, 0x00000010445d7824ULL, 0x100fe200078e0265ULL,
0x0000000731367812ULL, 0x000fe200078ec0ffULL, 0x0000001038477824ULL, 0x100fe200078e0265ULL,
0x000000340b317211ULL, 0x000fe200078fe8ffULL, 0x0000001058617824ULL, 0x000fe200078e0265ULL,
0x0ffffff836367812ULL, 0x000fe400078ef80bULL, 0x000000343d3d7210ULL, 0x000fe20007ffe0ffULL,
0x0000010031307825ULL, 0x002fe200078e0032ULL, 0x0000000306677819ULL, 0x000fc400000006ffULL,
0x0000003439397210ULL, 0x000fe20007ffe0ffULL, 0x00000010363f7824ULL, 0x000fe200078e0265ULL,
0xfffffff867677812ULL, 0x000fe200078ee252ULL, 0x0000010037367825ULL, 0x100fe200078e0032ULL,
0x000000653a597211ULL, 0x080fe400078e20ffULL, 0x00000065465f7211ULL, 0x000fe200078e20ffULL,
0x000001003d3c7825ULL, 0x000fc800078e0032ULL, 0x0000010045447825ULL, 0x000fc800078e0032ULL,
0x000001003b3a7825ULL, 0x000fc800078e0032ULL, 0x0000010039387825ULL, 0x000fc800078e0032ULL,
0x0000010035347825ULL, 0x000fc800078e0032ULL, 0x0000001067307825ULL, 0x000fc800078e0030ULL,
0x0000010063327825ULL, 0x000fe200078e0032ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000303f7faeULL, 0x0003e6000b901c46ULL, 0x0000001067367825ULL, 0x000fc800078e0036ULL,
0x00000010673c7825ULL, 0x040fe200078e003cULL, 0x0000000036477faeULL, 0x0003e6000b901c46ULL,
0x0000001067447825ULL, 0x040fe200078e0044ULL, 0x000000003c597faeULL, 0x0003e6000b901c46ULL,
0x00000010673a7825ULL, 0x040fe200078e003aULL, 0x00000000445b7faeULL, 0x0003e6000b901c46ULL,
0x0000001067387825ULL, 0x040fe200078e0038ULL, 0x000000003a5d7faeULL, 0x0003e6000b901c46ULL,
0x0000001067347825ULL, 0x040fe200078e0034ULL, 0x00000000385f7faeULL, 0x0003e6000b901c46ULL,
0x000000105a657824ULL, 0x000fe200078e0265ULL, 0x0000000034617faeULL, 0x0003e2000b901c46ULL,
0x0000001067327825ULL, 0x000fca00078e0032ULL, 0x0000000032657faeULL, 0x0003e4000b901c46ULL,
0x0000000409307819ULL, 0x002fe200000006ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffe00a317812ULL, 0x000fe400078ec0ffULL, 0x0000001030307812ULL, 0x000fc800078ec0ffULL,
0x0000000c30317210ULL, 0x000fca0007ffe031ULL, 0x0000000806357824ULL, 0x000fc800078e0231ULL,
0x01b6283e353e79a7ULL, 0x0002a6000850003fULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x01b6283f350075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff347224ULL, 0x000fce00078e00ffULL, 0x000000103400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230377210ULL, 0x000fc80007f1e1ffULL, 0x0000003331337210ULL, 0x000fe400007fe5ffULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003732327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000134347836ULL, 0x000fce0000000000ULL, 0x01b6283f350075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000008056307810ULL, 0x000fe20007ffe054ULL,
0x000000ffff587224ULL, 0x000fc600078e0053ULL, 0x0000003051307210ULL, 0x000fca0007ffe0ffULL,
0x01b0000030327984ULL, 0x000ea80000000800ULL, 0x01b2000030597984ULL, 0x0006e20000000800ULL,
0x000000533200720bULL, 0x004fda0003f1d000ULL, 0x0000000000337806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff33ff7812ULL, 0x000fda000782c0ffULL,
0x0000000000f89947ULL, 0x00afea0003800000ULL, 0x0000000143307811ULL, 0x000fe400078ff0ffULL,
0x000000533200720bULL, 0x000fe40003f14000ULL, 0x000000433000720cULL, 0x000fd60003f25270ULL,
0x0000000000347806ULL, 0x000fe400000e0100ULL, 0x0000008043319824ULL, 0x000fe200078e020cULL,
0x0000005332309209ULL, 0x000fc80007810000ULL, 0x0000003151359210ULL, 0x000fe40007ffe056ULL,
0x0000991034317816ULL, 0x000fc600000000ffULL, 0x01b4003035009388ULL, 0x0003e20000000800ULL,
0x000000ff3100720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005332307209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000782c0ffULL, 0x0000005330307221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL, 0x0000003000367308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x000fca000001160bULL,
0x00001f3136307589ULL, 0x006e6400000e0000ULL, 0x0000003010107220ULL, 0x082fe20000410000ULL,
0x0000003011117220ULL, 0x080fe20000410000ULL, 0x0000003014147220ULL, 0x080fe20000410000ULL,
0x0000003015157220ULL, 0x080fe20000410000ULL, 0x0000003018187220ULL, 0x080fe20000410000ULL,
0x0000003019197220ULL, 0x080fe20000410000ULL, 0x000000301c1c7220ULL, 0x080fe20000410000ULL,
0x000000301d1d7220ULL, 0x080fe20000410000ULL, 0x0000003020207220ULL, 0x080fe20000410000ULL,
0x0000003021217220ULL, 0x080fe20000410000ULL, 0x0000003024247220ULL, 0x080fe20000410000ULL,
0x0000003025257220ULL, 0x080fe20000410000ULL, 0x0000003028287220ULL, 0x080fe20000410000ULL,
0x0000003029297220ULL, 0x080fe20000410000ULL, 0x000000302c2c7220ULL, 0x080fe20000410000ULL,
0x000000302d2d7220ULL, 0x000fce0000410000ULL, 0x0000003605057220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x000000080b317811ULL, 0x000fca00078ff0ffULL,
0x00001f3136307589ULL, 0x002e6400000e0000ULL, 0x0000003012127220ULL, 0x082fe20000410000ULL,
0x0000003013137220ULL, 0x080fe20000410000ULL, 0x0000003016167220ULL, 0x080fe20000410000ULL,
0x0000003017177220ULL, 0x080fe20000410000ULL, 0x000000301a1a7220ULL, 0x080fe20000410000ULL,
0x000000301b1b7220ULL, 0x080fe20000410000ULL, 0x000000301e1e7220ULL, 0x080fe20000410000ULL,
0x000000301f1f7220ULL, 0x080fe20000410000ULL, 0x0000003022227220ULL, 0x080fe20000410000ULL,
0x0000003023237220ULL, 0x080fe20000410000ULL, 0x0000003026267220ULL, 0x080fe20000410000ULL,
0x0000003027277220ULL, 0x080fe20000410000ULL, 0x000000302a2a7220ULL, 0x080fe20000410000ULL,
0x000000302b2b7220ULL, 0x080fe20000410000ULL, 0x000000302e2e7220ULL, 0x080fe20000410000ULL,
0x000000302f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff34ff7812ULL, 0x000fe40007800833ULL,
0x0000005332587209ULL, 0x000fd60007810000ULL, 0x8000005832320221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b32320820ULL, 0x000fc80000410000ULL, 0x0000003200020308ULL, 0x000ea40000000800ULL,
0x0000000259590220ULL, 0x004fce0000410000ULL, 0x0000000c04307819ULL, 0x002fe200000006ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000100030307812ULL, 0x000fc800078e0cffULL,
0x0001300055537810ULL, 0x000fe20007ffe030ULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160bULL, 0x00000002ff00723eULL, 0x000fc600000000ffULL,
0x0000000803317836ULL, 0x000fe20000000000ULL, 0x0000541000307816ULL, 0x000fca0000000000ULL,
0x00001f0330037589ULL, 0x0002a800000e0000ULL, 0x00001f3130007589ULL, 0x0002e400000e0000ULL,
0x011800005030783bULL, 0x0022e20000000200ULL, 0x000000104f447824ULL, 0x100fe200078e0253ULL,
0x000000534e3c7211ULL, 0x000fe200078e20ffULL, 0x000000104d387824ULL, 0x000fe200078e0253ULL,
0x0000000000108947ULL, 0x000fec0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000031317232ULL, 0x080fe40000000000ULL,
0x0000000033337232ULL, 0x000fce0000000000ULL, 0x000000104c347824ULL, 0x000fe200078e0253ULL,
0x000000004444783bULL, 0x000f280000004200ULL, 0x000000003c3c783bULL, 0x000f680000004200ULL,
0x000000003838783bULL, 0x000f680000004200ULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x000000443010723cULL, 0x018fec0000001810ULL, 0x000000463014723cULL, 0x000fe20000001814ULL,
0x0000005349447211ULL, 0x000fca00078e20ffULL, 0x0000003c3018723cULL, 0x022fec0000001818ULL,
0x0000003e301c723cULL, 0x000fe2000000181cULL, 0x00000010483c7824ULL, 0x000fca00078e0253ULL,
0x000000383020723cULL, 0x000fec0000001820ULL, 0x0000003a3024723cULL, 0x000fe20000001824ULL,
0x0000001042387824ULL, 0x000fca00078e0253ULL, 0x000000343028723cULL, 0x004fec0000001828ULL,
0x00000036302c723cULL, 0x000fe2000000182cULL, 0x011800004a30783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000031317232ULL, 0x080fe40000000000ULL, 0x0000000033337232ULL, 0x000fce0000000000ULL,
0x0000005340347211ULL, 0x000fe200078e20ffULL, 0x000000004444783bULL, 0x000ee20000004200ULL,
0x0000000559057221ULL, 0x000fe20000010000ULL, 0x00000001045a7812ULL, 0x000fe400078ec0ffULL,
0x000000003c3c783bULL, 0x000f280000004200ULL, 0x000000003838783bULL, 0x000f680000004200ULL,
0x000000003434783bULL, 0x000f220000004200ULL, 0x000000443010723cULL, 0x00cfec0000001810ULL,
0x000000463014723cULL, 0x000fec0000001814ULL, 0x0000003c3018723cULL, 0x010fec0000001818ULL,
0x0000003e301c723cULL, 0x000fec000000181cULL, 0x000000383020723cULL, 0x022fec0000001820ULL,
0x0000003a3024723cULL, 0x000fec0000001824ULL, 0x000000343028723cULL, 0x000fe20000001828ULL,
0x00000001ff3a7424ULL, 0x000fc800078e00ffULL, 0x01b6903a4bff79a7ULL, 0x0003e2000850003fULL,
0x00000036302c723cULL, 0x000fee000000182cULL, 0x0000008041307811ULL, 0x000fc800078e40ffULL,
0x0000000f3000720cULL, 0x000fda0003f06070ULL, 0x0000002800a00947ULL, 0x002fea0003800000ULL,
0x0000000141307836ULL, 0x000fe20000000000ULL, 0x000000c057347810ULL, 0x000fe20007ffe0ffULL,
0x00008e0000047ab9ULL, 0x000fc60000000800ULL, 0x0000000d3000720cULL, 0x000fe20003f06070ULL,
0x0000000407307c24ULL, 0x000fe2000f8e0234ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0000000400688947ULL, 0x000fea0003800000ULL, 0x00008a00ff327b82ULL, 0x000e620000000a00ULL,
0x000000340f317248ULL, 0x000fe20007fe0000ULL, 0x000000ffff347224ULL, 0x000fe200078e0a34ULL,
0x00000003ff367819ULL, 0x000fe2000001160bULL, 0x00000008063b7824ULL, 0x000fc600078e00ffULL,
0x0000002031317446ULL, 0x000fe20003800034ULL, 0x0000000136347824ULL, 0x140fe200078e020bULL,
0x0000003036357210ULL, 0x000fe20007ffe0ffULL, 0x00000008363c7836ULL, 0x000fe20000000000ULL,
0x000000313600720cULL, 0x000fe20003f06070ULL, 0x0000000c363e7836ULL, 0x000fe20000000000ULL,
0x0000000734387812ULL, 0x000fe200078ec0ffULL, 0x00000014365e7836ULL, 0x000fe20000000000ULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee252ULL, 0x0000001836607836ULL, 0x000fe20000000000ULL,
0x0ffffff838387812ULL, 0x000fe200078ef80bULL, 0x000000083c5a7824ULL, 0x000fe200078e00ffULL,
0x00000010365c7810ULL, 0x000fe20007ffe0ffULL, 0x000000013e447824ULL, 0x000fe200078e020bULL,
0x0000001c36627810ULL, 0x000fe20007ffe0ffULL, 0x0000001038377824ULL, 0x000fe200078e0253ULL,
0x0000000436387810ULL, 0x000fe20007ffe0ffULL, 0x0000010035347825ULL, 0x002fe200078e0032ULL,
0x000000033e397819ULL, 0x000fc400000006ffULL, 0x000000313c00720cULL, 0x0c0fe20003f26070ULL,
0x000000013c3d7824ULL, 0x000fe200078e0230ULL, 0x000000313e00720cULL, 0x080fe20003f46070ULL,
0x000000103b347825ULL, 0x000fe200078e0034ULL, 0x000000315c00720cULL, 0x080fe40003f66070ULL,
0x000000315e00720cULL, 0x0c0fe20003f86070ULL, 0x000000015e367824ULL, 0x000fe200078e020bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034377faeULL, 0x0003e2000c101c46ULL,
0x000000313800720cULL, 0x080fe20003f06070ULL, 0x0000000162457824ULL, 0x100fe200078e0230ULL,
0x000000316000720cULL, 0x0c0fe20003fa6070ULL, 0x0000000860597824ULL, 0x000fe200078e00ffULL,
0x000000316200720cULL, 0x000fe20003fc6070ULL, 0x0000000138317824ULL, 0x100fe200078e0230ULL,
0xfffffff839447812ULL, 0x000fe200078ee244ULL, 0x000000015c397824ULL, 0x000fe200078e0230ULL,
0x000000303e3f7210ULL, 0x000fc40007ffe0ffULL, 0x000000035c477819ULL, 0x000fe200000006ffULL,
0x0000000138347824ULL, 0x142fe200078e020bULL, 0x0000000b3c357210ULL, 0x000fe20007ffe0ffULL,
0x0000000838377824ULL, 0x000fe200078e00ffULL, 0x000000035e577819ULL, 0x000fe200000006ffULL,
0x0000000162387824ULL, 0x100fe200078e020bULL, 0xfffffff85a5a7812ULL, 0x000fe200078ee235ULL,
0x0000000160357824ULL, 0x100fe200078e0230ULL, 0xfffffff837467812ULL, 0x000fe200078ee234ULL,
0x000000015c347824ULL, 0x000fe200078e020bULL, 0x00000003625b7819ULL, 0x000fe200000006ffULL,
0x000000015e377824ULL, 0x000fe200078e0230ULL, 0x0000000b60307210ULL, 0x000fe20007ffe0ffULL,
0x000001003d3c7825ULL, 0x000fe200078e0032ULL, 0xfffffff8475c7812ULL, 0x000fc400078ee234ULL,
0xfffffff8575e7812ULL, 0x000fe200078ee236ULL, 0x000001003f3e7825ULL, 0x100fe200078e0032ULL,
0xfffffff859607812ULL, 0x000fe400078ee230ULL, 0xfffffff85b627812ULL, 0x000fe200078ee238ULL,
0x0000010031307825ULL, 0x000fe200078e0032ULL, 0x00000053605b7211ULL, 0x000fc600078e20ffULL,
0x0000010039387825ULL, 0x000fc800078e0032ULL, 0x0000010037367825ULL, 0x000fc800078e0032ULL,
0x0000010035347825ULL, 0x000fc800078e0032ULL, 0x0000010045327825ULL, 0x000fc800078e0032ULL,
0x0000001046457824ULL, 0x000fe400078e0253ULL, 0x000000103b307825ULL, 0x000fc800078e0030ULL,
0x000000105a477824ULL, 0x000fe200078e0253ULL, 0x0000000030457faeULL, 0x0003e2000c101c46ULL,
0x000000103b3c7825ULL, 0x000fc800078e003cULL, 0x000000103b3e7825ULL, 0x040fe200078e003eULL,
0x000000003c477faeULL, 0x0003e6000c901c46ULL, 0x000000103b387825ULL, 0x000fc800078e0038ULL,
0x000000103b367825ULL, 0x000fc800078e0036ULL, 0x000000103b347825ULL, 0x000fc800078e0034ULL,
0x000000103b327825ULL, 0x000fe200078e0032ULL, 0x00000053443b7211ULL, 0x000fc600078e20ffULL,
0x000000105c577824ULL, 0x100fe400078e0253ULL, 0x000000105e597824ULL, 0x100fe200078e0253ULL,
0x000000003e3b7faeULL, 0x0003e2000d101c46ULL, 0x00000010625d7824ULL, 0x000fc600078e0253ULL,
0x0000000038577faeULL, 0x0003e8000d901c46ULL, 0x0000000036597faeULL, 0x0003e8000e101c46ULL,
0x00000000345b7faeULL, 0x0003e8000e901c46ULL, 0x00000000325d7faeULL, 0x0003e2000f101c46ULL,
0x0000000400347947ULL, 0x000fea0003800000ULL, 0x000000080b3f7811ULL, 0x040fe200078fe8ffULL,
0x0000000806597824ULL, 0x000fe200078e00ffULL, 0x000000040b377811ULL, 0x040fe400078fe8ffULL,
0x0000000c0b457811ULL, 0x000fe200078fe8ffULL, 0x000000013f647824ULL, 0x100fe200078e020bULL,
0x0000000337317819ULL, 0x000fe200000006ffULL, 0x000000083f337824ULL, 0x000fe200078e00ffULL,
0x000000100b3d7811ULL, 0x000fe200078fe8ffULL, 0x0000000137627824ULL, 0x100fe200078e020bULL,
0x000000140b397811ULL, 0x000fe200078fe8ffULL, 0x000000013f3f7824ULL, 0x100fe200078e0230ULL,
0xfffffff833647812ULL, 0x000fe200078ee264ULL, 0x000000013d5e7824ULL, 0x100fe200078e020bULL,
0x00008a00ff327b82ULL, 0x000e620000000a00ULL, 0xfffffff831627812ULL, 0x000fe200078ee262ULL,
0x0000000845317824ULL, 0x000fe200078e00ffULL, 0x0000000b45607210ULL, 0x000fe20007ffe0ffULL,
0x00000001395a7824ULL, 0x000fe200078e020bULL, 0x000000033d357819ULL, 0x000fe200000006ffULL,
0x00000008393b7824ULL, 0x000fe200078e00ffULL, 0x0000000b0b347211ULL, 0x000fe200078fe8ffULL,
0x0000000145457824ULL, 0x100fe200078e0230ULL, 0x000000180b367811ULL, 0x000fe200078fe8ffULL,
0x0000000139397824ULL, 0x000fe200078e0230ULL, 0x0000001c0b387811ULL, 0x000fc400078fe8ffULL,
0xfffffff831607812ULL, 0x000fe200078ee260ULL, 0x0000000836477824ULL, 0x000fe200078e00ffULL,
0x000000300b317211ULL, 0x000fe200078fe8ffULL, 0x0000000838577824ULL, 0x000fe200078e00ffULL,
0xfffffff8355e7812ULL, 0x000fe200078ee25eULL, 0x0000000136357824ULL, 0x000fe200078e0230ULL,
0x0000003037377210ULL, 0x000fe40007ffe0ffULL, 0x000000303d3d7210ULL, 0x000fe20007ffe0ffULL,
0x000000105e5b7824ULL, 0x000fe200078e0253ULL, 0x0000000734347812ULL, 0x000fe200078ec0ffULL,
0x000001003f3e7825ULL, 0x002fe200078e0032ULL, 0xfffffff83b5a7812ULL, 0x000fc400078ee25aULL,
0x0000000b36467210ULL, 0x000fe20007ffe0ffULL, 0x00000001383b7824ULL, 0x000fe200078e0230ULL,
0x0000000b385c7210ULL, 0x000fe20007ffe0ffULL, 0x0000010031307825ULL, 0x100fe200078e0032ULL,
0x0ffffff834667812ULL, 0x000fe400078ef80bULL, 0xfffffff859597812ULL, 0x000fe200078ee252ULL,
0x0000010037367825ULL, 0x100fe200078e0032ULL, 0xfffffff847467812ULL, 0x000fe400078ee246ULL,
0xfffffff8575c7812ULL, 0x000fe200078ee25cULL, 0x0000010045447825ULL, 0x000fe200078e0032ULL,
0x00000053465f7211ULL, 0x000fc600078e20ffULL, 0x000001003d3c7825ULL, 0x000fc800078e0032ULL,
0x0000010039387825ULL, 0x000fc800078e0032ULL, 0x0000010035347825ULL, 0x000fc800078e0032ULL,
0x000001003b327825ULL, 0x000fe200078e0032ULL, 0x00000053663b7211ULL, 0x000fc600078e20ffULL,
0x0000001059307825ULL, 0x000fc800078e0030ULL, 0x0000001062477824ULL, 0x000fe200078e0253ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000303b7faeULL, 0x0003e2000b901c46ULL,
0x0000001059367825ULL, 0x000fc800078e0036ULL, 0x0000001064577824ULL, 0x000fe200078e0253ULL,
0x0000000036477faeULL, 0x0003e2000b901c46ULL, 0x00000010593e7825ULL, 0x000fc800078e003eULL,
0x0000001059447825ULL, 0x040fe200078e0044ULL, 0x000000003e577faeULL, 0x0003e6000b901c46ULL,
0x00000010593c7825ULL, 0x000fc800078e003cULL, 0x0000001059387825ULL, 0x000fc800078e0038ULL,
0x0000001059347825ULL, 0x000fc800078e0034ULL, 0x0000001059327825ULL, 0x000fe200078e0032ULL,
0x0000005360597211ULL, 0x000fc600078e20ffULL, 0x000000105a5d7824ULL, 0x100fe400078e0253ULL,
0x000000105c617824ULL, 0x000fe200078e0253ULL, 0x0000000044597faeULL, 0x0003e8000b901c46ULL,
0x000000003c5b7faeULL, 0x0003e8000b901c46ULL, 0x00000000385d7faeULL, 0x0003e8000b901c46ULL,
0x00000000345f7faeULL, 0x0003e8000b901c46ULL, 0x0000000032617faeULL, 0x0003e4000b901c46ULL,
0xffffffe00a337812ULL, 0x042fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000100a307812ULL, 0x040fe400078ec0ffULL, 0x000000080a317812ULL, 0x000fe400078ec0ffULL,
0x0000000c30307210ULL, 0x000fca0007ffe033ULL, 0x0000000130357824ULL, 0x000fc800078e0231ULL,
0x01b6483a353a79a7ULL, 0x0002a6000850003fULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x01b6483b350075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ff00347202ULL, 0x000fce0000000f00ULL, 0x000000103400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230377210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003732327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fce0007ffe0ffULL, 0x01b6483b350075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000010056307810ULL, 0x000fe20007ffe054ULL,
0x000000ffff577224ULL, 0x000fc800078e0058ULL, 0x0000000151307824ULL, 0x000fca00078e0230ULL,
0x01b0000030317984ULL, 0x000ea80000000800ULL, 0x01b2000030597984ULL, 0x0006e20000000800ULL,
0x000000583100720bULL, 0x004fda0003f1d000ULL, 0x0000000000337806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff33ff7812ULL, 0x000fda000782c0ffULL,
0x0000000000f89947ULL, 0x00afea0003800000ULL, 0x0000000243307811ULL, 0x000fe400078ff0ffULL,
0x000000583100720bULL, 0x000fe40003f14000ULL, 0x000000433000720cULL, 0x000fd60003f25270ULL,
0x0000000000347806ULL, 0x000fe400000e0100ULL, 0x0000000c43329211ULL, 0x000fe400078e38ffULL,
0x0000003158309209ULL, 0x000fe40007810000ULL, 0x0000003251359210ULL, 0x000fe40007ffe056ULL,
0x0000991034327816ULL, 0x000fc600000000ffULL, 0x01b4003035009388ULL, 0x0003e20000000800ULL,
0x000000ff3200720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000003158357209ULL, 0x000fe40007810000ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000782c0ffULL, 0x8000003558307221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL, 0x0000003000327308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff357819ULL, 0x000fca000001160bULL,
0x00001f3532307589ULL, 0x006e6400000e0000ULL, 0x0000003010107220ULL, 0x082fe20000410000ULL,
0x0000003011117220ULL, 0x080fe20000410000ULL, 0x0000003014147220ULL, 0x080fe20000410000ULL,
0x0000003015157220ULL, 0x080fe20000410000ULL, 0x0000003018187220ULL, 0x080fe20000410000ULL,
0x0000003019197220ULL, 0x080fe20000410000ULL, 0x000000301c1c7220ULL, 0x080fe20000410000ULL,
0x000000301d1d7220ULL, 0x080fe20000410000ULL, 0x0000003020207220ULL, 0x080fe20000410000ULL,
0x0000003021217220ULL, 0x080fe20000410000ULL, 0x0000003024247220ULL, 0x080fe20000410000ULL,
0x0000003025257220ULL, 0x080fe20000410000ULL, 0x0000003028287220ULL, 0x080fe20000410000ULL,
0x0000003029297220ULL, 0x080fe20000410000ULL, 0x000000302c2c7220ULL, 0x080fe20000410000ULL,
0x000000302d2d7220ULL, 0x000fce0000410000ULL, 0x0000003205057220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x000000080b357811ULL, 0x000fca00078ff0ffULL,
0x00001f3532307589ULL, 0x002e6400000e0000ULL, 0x0000003012127220ULL, 0x082fe20000410000ULL,
0x0000003013137220ULL, 0x080fe20000410000ULL, 0x0000003016167220ULL, 0x080fe20000410000ULL,
0x0000003017177220ULL, 0x080fe20000410000ULL, 0x000000301a1a7220ULL, 0x080fe20000410000ULL,
0x000000301b1b7220ULL, 0x080fe20000410000ULL, 0x000000301e1e7220ULL, 0x080fe20000410000ULL,
0x000000301f1f7220ULL, 0x080fe20000410000ULL, 0x0000003022227220ULL, 0x080fe20000410000ULL,
0x0000003023237220ULL, 0x080fe20000410000ULL, 0x0000003026267220ULL, 0x080fe20000410000ULL,
0x0000003027277220ULL, 0x080fe20000410000ULL, 0x000000302a2a7220ULL, 0x080fe20000410000ULL,
0x000000302b2b7220ULL, 0x080fe20000410000ULL, 0x000000302e2e7220ULL, 0x080fe20000410000ULL,
0x000000302f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff34ff7812ULL, 0x000fe40007800833ULL,
0x0000003158577209ULL, 0x000fd60007810000ULL, 0x8000005731310221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL, 0x0000003100020308ULL, 0x000ea40000000800ULL,
0x0000000259590220ULL, 0x004fce0000410000ULL, 0x0000100004307824ULL, 0x002fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000100030307812ULL, 0x000fc800078ec0ffULL,
0x0001300055557810ULL, 0x000fe20007ffe030ULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160bULL, 0x00000002ff00723eULL, 0x000fc600000000ffULL,
0x0000000803317836ULL, 0x000fe20000000000ULL, 0x0000541000307816ULL, 0x000fca0000000000ULL,
0x00001f0330037589ULL, 0x0002a800000e0000ULL, 0x00001f3130007589ULL, 0x0002e400000e0000ULL,
0x012000005030783bULL, 0x0022e20000000200ULL, 0x000000554f447211ULL, 0x000fe200078e20ffULL,
0x000000104e3c7824ULL, 0x100fe400078e0255ULL, 0x000000104d387824ULL, 0x000fe200078e0255ULL,
0x0000000000108947ULL, 0x000fec0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000031317232ULL, 0x080fe40000000000ULL,
0x0000000033337232ULL, 0x000fce0000000000ULL, 0x000000554c347211ULL, 0x000fe200078e20ffULL,
0x000000004444783bULL, 0x000f280000004200ULL, 0x000000003c3c783bULL, 0x000f680000004200ULL,
0x000000003838783bULL, 0x000f680000004200ULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x000000443010723cULL, 0x018fec0000001810ULL, 0x000000463014723cULL, 0x000fe20000001814ULL,
0x0000001049447824ULL, 0x000fca00078e0255ULL, 0x0000003c3018723cULL, 0x022fec0000001818ULL,
0x0000003e301c723cULL, 0x000fe2000000181cULL, 0x00000010483d7824ULL, 0x000fca00078e0255ULL,
0x000000383020723cULL, 0x000fec0000001820ULL, 0x0000003a3024723cULL, 0x000fe20000001824ULL,
0x0000005542387211ULL, 0x000fca00078e20ffULL, 0x000000343028723cULL, 0x004fec0000001828ULL,
0x00000036302c723cULL, 0x000fe2000000182cULL, 0x012000004a30783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000031317232ULL, 0x080fe40000000000ULL, 0x0000000033337232ULL, 0x000fce0000000000ULL,
0x0000001040347824ULL, 0x000fe200078e0255ULL, 0x000000004444783bULL, 0x000ee20000004200ULL,
0x0000000559057221ULL, 0x000fe20000010000ULL, 0x00000001045a7812ULL, 0x000fe400078e0cffULL,
0x000000003d3c783bULL, 0x000f220000004200ULL, 0x0000005700587202ULL, 0x000fc60000000f00ULL,
0x000000003838783bULL, 0x000f680000004200ULL, 0x000000003434783bULL, 0x000f220000004200ULL,
0x000000443010723cULL, 0x00cfec0000001810ULL, 0x000000463014723cULL, 0x000fec0000001814ULL,
0x0000003c3018723cULL, 0x010fec0000001818ULL, 0x0000003e301c723cULL, 0x000fe2000000181cULL,
0x00000001ff3c7424ULL, 0x000fc800078e00ffULL, 0x01b6983c4bff79a7ULL, 0x0005e2000850003fULL,
0x000000383020723cULL, 0x022fec0000001820ULL, 0x0000003a3024723cULL, 0x000fec0000001824ULL,
0x000000343028723cULL, 0x000fec0000001828ULL, 0x00000036302c723cULL, 0x000fee000000182cULL,
0x000000c041307811ULL, 0x000fc800078e40ffULL, 0x0000000f3000720cULL, 0x000fda0003f06070ULL,
0x0000001400440947ULL, 0x004fea0003800000ULL, 0x000000010e317824ULL, 0x000fe200078e0241ULL,
0x00008e0000047ab9ULL, 0x000fc60000000800ULL, 0x0000000131307836ULL, 0x000fe20000000000ULL,
0x0000000831347211ULL, 0x000fc800078e40ffULL, 0x0000000d3000720cULL, 0x000fe20003f06070ULL,
0x0000000407307c24ULL, 0x000fe2000f8e0234ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0000000400688947ULL, 0x000fea0003800000ULL, 0x00008a00ff327b82ULL, 0x000e620000000a00ULL,
0x000000340f317248ULL, 0x000fe20007fe0000ULL, 0x000000ffff347224ULL, 0x000fe200078e0a34ULL,
0x00000003ff367819ULL, 0x000fe2000001160bULL, 0x00000008063d7824ULL, 0x000fc600078e00ffULL,
0x0000002031317446ULL, 0x000fe20003800034ULL, 0x0000000136347824ULL, 0x040fe200078e020bULL,
0x0000003036357210ULL, 0x000fe20007ffe0ffULL, 0x00000008363a7836ULL, 0x000fe20000000000ULL,
0x000000313600720cULL, 0x000fe20003f06070ULL, 0x0000000c363e7836ULL, 0x000fe20000000000ULL,
0x0000000734387812ULL, 0x000fe200078ec0ffULL, 0x0000001836587836ULL, 0x000fe20000000000ULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee252ULL, 0x0000001436527836ULL, 0x000fe20000000000ULL,
0x0ffffff838387812ULL, 0x000fe200078ef80bULL, 0x0000000858597824ULL, 0x000fe200078e00ffULL,
0x0000001036467810ULL, 0x000fc40007ffe0ffULL, 0x0000001c365a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001038377824ULL, 0x000fe200078e0255ULL, 0x0000000436387810ULL, 0x000fe20007ffe0ffULL,
0x0000010035347825ULL, 0x002fe200078e0032ULL, 0x000000033e447819ULL, 0x000fe400000006ffULL,
0x000000313a00720cULL, 0x080fe20003f26070ULL, 0x0000000838397824ULL, 0x000fe200078e00ffULL,
0x000000313e00720cULL, 0x080fe20003f46070ULL, 0x000000103d347825ULL, 0x000fe200078e0034ULL,
0x000000314600720cULL, 0x000fc40003f66070ULL, 0x000000315200720cULL, 0x080fe20003f86070ULL,
0x000000083a367824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034377faeULL, 0x0003e2000c101c46ULL, 0x000000313800720cULL, 0x080fe20003f06070ULL,
0x00000001463b7824ULL, 0x100fe200078e0230ULL, 0x000000315800720cULL, 0x080fe20003fa6070ULL,
0x000000015a617824ULL, 0x140fe200078e0230ULL, 0x000000315a00720cULL, 0x000fe20003fc6070ULL,
0x0000000158317824ULL, 0x000fe200078e0230ULL, 0x000000303e3f7210ULL, 0x000fe40007ffe0ffULL,
0x0000000346457819ULL, 0x000fc400000006ffULL, 0x0000000352477819ULL, 0x000fe200000006ffULL,
0x0000000138347824ULL, 0x102fe200078e020bULL, 0x0000000b3a357210ULL, 0x000fe20007ffe0ffULL,
0x000000013e377824ULL, 0x100fe200078e020bULL, 0x000000035a5b7819ULL, 0x040fe200000006ffULL,
0x000000015a3e7824ULL, 0x100fe200078e020bULL, 0xfffffff839347812ULL, 0x000fe200078ee234ULL,
0x000000013a397824ULL, 0x100fe200078e0230ULL, 0xfffffff836367812ULL, 0x000fe200078ee235ULL,
0x0000000138357824ULL, 0x000fe200078e0230ULL, 0xfffffff844447812ULL, 0x000fe200078ee237ULL,
0x0000000146387824ULL, 0x100fe200078e020bULL, 0xfffffff85b3e7812ULL, 0x000fe200078ee23eULL,
0x00000001523a7824ULL, 0x000fc400078e020bULL, 0x0000000152377824ULL, 0x000fe200078e0230ULL,
0x0000000b58307210ULL, 0x000fe40007ffe0ffULL, 0xfffffff845387812ULL, 0x000fe200078ee238ULL,
0x0000001034457824ULL, 0x100fe200078e0255ULL, 0xfffffff8473a7812ULL, 0x000fe200078ee23aULL,
0x0000001036477824ULL, 0x100fe200078e0255ULL, 0xfffffff859307812ULL, 0x000fe200078ee230ULL,
0x00000010385b7824ULL, 0x100fe200078e0255ULL, 0x0000005544597211ULL, 0x080fe200078e20ffULL,
0x000000103a5d7824ULL, 0x000fe200078e0255ULL, 0x00000055305f7211ULL, 0x000fe200078e20ffULL,
0x0000010035347825ULL, 0x000fc800078e0032ULL, 0x000000103e557824ULL, 0x000fe400078e0255ULL,
0x0000010039387825ULL, 0x000fc800078e0032ULL, 0x000001003f3e7825ULL, 0x000fc800078e0032ULL,
0x000001003b3a7825ULL, 0x000fc800078e0032ULL, 0x0000010037367825ULL, 0x000fc800078e0032ULL,
0x0000010031307825ULL, 0x000fc800078e0032ULL, 0x0000010061327825ULL, 0x000fc800078e0032ULL,
0x000000103d347825ULL, 0x000fc800078e0034ULL, 0x000000103d387825ULL, 0x040fe200078e0038ULL,
0x0000000034457faeULL, 0x0003e6000c101c46ULL, 0x000000103d3e7825ULL, 0x040fe200078e003eULL,
0x0000000038477faeULL, 0x0003e6000c901c46ULL, 0x000000103d3a7825ULL, 0x040fe200078e003aULL,
0x000000003e597faeULL, 0x0003e6000d101c46ULL, 0x000000103d367825ULL, 0x040fe200078e0036ULL,
0x000000003a5b7faeULL, 0x0003e6000d901c46ULL, 0x000000103d307825ULL, 0x040fe200078e0030ULL,
0x00000000365d7faeULL, 0x0003e6000e101c46ULL, 0x000000103d327825ULL, 0x000fe200078e0032ULL,
0x00000000305f7faeULL, 0x0003e8000e901c46ULL, 0x0000000032557faeULL, 0x0003e2000f101c46ULL,
0x0000000400347947ULL, 0x000fea0003800000ULL, 0x000000080b3f7811ULL, 0x040fe200078fe8ffULL,
0x00000008063d7824ULL, 0x000fe200078e00ffULL, 0x000000100b357811ULL, 0x040fe400078fe8ffULL,
0x0000000c0b457811ULL, 0x000fe200078fe8ffULL, 0x000000013f327824ULL, 0x140fe200078e020bULL,
0x000000033f377819ULL, 0x000fe200000006ffULL, 0x0000000835397824ULL, 0x000fe200078e00ffULL,
0x0000000b35367210ULL, 0x000fe20007ffe0ffULL, 0x0000000145337824ULL, 0x040fe200078e020bULL,
0xfffffff837387812ULL, 0x000fe200078ee232ULL, 0x00000008453a7824ULL, 0x040fe200078e00ffULL,
0xfffffff8393e7812ULL, 0x000fe200078ee236ULL, 0x0000000145457824ULL, 0x100fe200078e0230ULL,
0x00008a00ff367b82ULL, 0x000e620000000a00ULL, 0x000000040b3b7811ULL, 0x000fe200078fe8ffULL,
0x0000000135357824ULL, 0x100fe200078e0230ULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee233ULL,
0x000000103e5f7824ULL, 0x000fe200078e0255ULL, 0x000000140b337811ULL, 0x000fe200078fe8ffULL,
0x000000083b347824ULL, 0x040fe200078e00ffULL, 0x0000000b3b317210ULL, 0x000fe20007ffe0ffULL,
0x000000013b3b7824ULL, 0x000fe200078e0230ULL, 0x0000000333597819ULL, 0x040fe200000006ffULL,
0x0000000133327824ULL, 0x000fe200078e020bULL, 0xfffffff834347812ULL, 0x000fc400078ee231ULL,
0x000000180b397811ULL, 0x040fe400078fe8ffULL, 0x0000000b0b317211ULL, 0x000fe400078fe8ffULL,
0xfffffff859447812ULL, 0x000fe200078ee232ULL, 0x0000000139467824ULL, 0x000fe200078e020bULL,
0x0000000731327812ULL, 0x000fe200078ec0ffULL, 0x00000008395b7824ULL, 0x040fe200078e00ffULL,
0x0000003033317210ULL, 0x000fe20007ffe0ffULL, 0x0000000139337824ULL, 0x000fe200078e0230ULL,
0x0000001c0b657811ULL, 0x040fe200078fe8ffULL, 0x0000001044617824ULL, 0x100fe200078e0255ULL,
0x000000300b397211ULL, 0x000fe200078fe8ffULL, 0x0000001034597824ULL, 0x000fe200078e0255ULL,
0x000000303f3f7210ULL, 0x000fe20007ffe0ffULL, 0x0000010045447825ULL, 0x002fe200078e0036ULL,
0xfffffff83d3d7812ULL, 0x000fc400078ee252ULL, 0xfffffff85b467812ULL, 0x000fe200078ee246ULL,
0x0000000865527824ULL, 0x000fe200078e00ffULL, 0x0000000b65477210ULL, 0x000fe20007ffe0ffULL,
0x00000010385b7824ULL, 0x000fe200078e0255ULL, 0x000000553a5d7211ULL, 0x080fe200078e20ffULL,
0x0000010039387825ULL, 0x100fe200078e0036ULL, 0x0ffffff832327812ULL, 0x000fe400078ef80bULL,
0xfffffff852527812ULL, 0x000fe200078ee247ULL, 0x000001003b3a7825ULL, 0x000fe200078e0036ULL,
0x0000005532477211ULL, 0x000fc400078e20ffULL, 0x0000005546637211ULL, 0x000fe200078e20ffULL,
0x000001003f3e7825ULL, 0x000fc800078e0036ULL, 0x0000000165657824ULL, 0x000fe400078e0230ULL,
0x0000010035347825ULL, 0x000fc800078e0036ULL, 0x0000010031307825ULL, 0x000fc800078e0036ULL,
0x0000010033327825ULL, 0x000fc800078e0036ULL, 0x000000103d387825ULL, 0x000fc800078e0038ULL,
0x0000010065367825ULL, 0x000fe200078e0036ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038477faeULL, 0x0003e6000b901c46ULL, 0x000000103d3a7825ULL, 0x000fc800078e003aULL,
0x000000103d3e7825ULL, 0x040fe200078e003eULL, 0x000000003a597faeULL, 0x0003e6000b901c46ULL,
0x000000103d447825ULL, 0x040fe200078e0044ULL, 0x000000003e5b7faeULL, 0x0003e6000b901c46ULL,
0x000000103d347825ULL, 0x040fe200078e0034ULL, 0x00000000445d7faeULL, 0x0003e6000b901c46ULL,
0x000000103d307825ULL, 0x040fe200078e0030ULL, 0x00000000345f7faeULL, 0x0003e6000b901c46ULL,
0x000000103d327825ULL, 0x040fe200078e0032ULL, 0x0000000030617faeULL, 0x0003e6000b901c46ULL,
0x0000001052557824ULL, 0x000fe200078e0255ULL, 0x0000000032637faeULL, 0x0003e2000b901c46ULL,
0x000000103d367825ULL, 0x000fca00078e0036ULL, 0x0000000036557faeULL, 0x0003e4000b901c46ULL,
0xffffffe00a317812ULL, 0x042fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000100a307812ULL, 0x040fe400078ec0ffULL, 0x000000080a327812ULL, 0x000fe400078ec0ffULL,
0x0000000c30317210ULL, 0x000fca0007ffe031ULL, 0x0000000131377824ULL, 0x000fc800078e0232ULL,
0x01b6683c373c79a7ULL, 0x0002a6000850003fULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x01b6683d370075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ff00347202ULL, 0x000fce0000000f00ULL, 0x000000103400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230357210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003532327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fce0007ffe0ffULL, 0x01b6683d370075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000018056547810ULL, 0x000fe20007ffe054ULL,
0x000000ffff587224ULL, 0x000fc800078e0057ULL, 0x0000000151547824ULL, 0x000fca00078e0254ULL,
0x01b0000054307984ULL, 0x000ea80000000800ULL, 0x01b2000054527984ULL, 0x0006e20000000800ULL,
0x000000573000720bULL, 0x004fda0003f1d000ULL, 0x0000000000317806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff31337812ULL, 0x000fda000782c0ffULL,
0x0000000000f49947ULL, 0x00afea0003800000ULL, 0x0000000343327811ULL, 0x000fe400078ff0ffULL,
0x000000573000720bULL, 0x000fe40003f34000ULL, 0x000000433200720cULL, 0x000fe40003f45270ULL,
0x0000005730587209ULL, 0x000fd20007810000ULL, 0x0000000000327806ULL, 0x000fe400008e0100ULL,
0x0000000c4331a211ULL, 0x000fc800078e38ffULL, 0x000000315151a210ULL, 0x000fe40007ffe056ULL,
0x0000991032317816ULL, 0x000fc600000000ffULL, 0x01b400585100a388ULL, 0x0003e20000000800ULL,
0x000000ff3100720cULL, 0x000fda0003f25270ULL, 0x0000000000b09947ULL, 0x002fea0003800000ULL,
0x0000005758317221ULL, 0x000fe20000010100ULL, 0x000000ff32ff7812ULL, 0x040fe4000782c0ffULL,
0x0000ff0032ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b31317820ULL, 0x000fc80000410000ULL,
0x0000003100347308ULL, 0x0002ac0000000800ULL, 0x0000000000489947ULL, 0x000fea0003800000ULL,
0x00000002ff317819ULL, 0x002fcc000001160bULL, 0x00001f3134317589ULL, 0x004e6400000e0000ULL,
0x0000003110107220ULL, 0x082fe20000410000ULL, 0x0000003111117220ULL, 0x080fe20000410000ULL,
0x0000003114147220ULL, 0x080fe20000410000ULL, 0x0000003115157220ULL, 0x080fe20000410000ULL,
0x0000003118187220ULL, 0x080fe20000410000ULL, 0x0000003119197220ULL, 0x080fe20000410000ULL,
0x000000311c1c7220ULL, 0x080fe20000410000ULL, 0x000000311d1d7220ULL, 0x080fe20000410000ULL,
0x0000003120207220ULL, 0x080fe20000410000ULL, 0x0000003121217220ULL, 0x080fe20000410000ULL,
0x0000003124247220ULL, 0x080fe20000410000ULL, 0x0000003125257220ULL, 0x080fe20000410000ULL,
0x0000003128287220ULL, 0x080fe20000410000ULL, 0x0000003129297220ULL, 0x080fe20000410000ULL,
0x000000312c2c7220ULL, 0x080fe20000410000ULL, 0x000000312d2d7220ULL, 0x000fce0000410000ULL,
0x0000003405057220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x000000080b317811ULL, 0x002fcc00078ff0ffULL, 0x00001f3134317589ULL, 0x000e6400000e0000ULL,
0x0000003112127220ULL, 0x082fe20000410000ULL, 0x0000003113137220ULL, 0x080fe20000410000ULL,
0x0000003116167220ULL, 0x080fe20000410000ULL, 0x0000003117177220ULL, 0x080fe20000410000ULL,
0x000000311a1a7220ULL, 0x080fe20000410000ULL, 0x000000311b1b7220ULL, 0x080fe20000410000ULL,
0x000000311e1e7220ULL, 0x080fe20000410000ULL, 0x000000311f1f7220ULL, 0x080fe20000410000ULL,
0x0000003122227220ULL, 0x080fe20000410000ULL, 0x0000003123237220ULL, 0x080fe20000410000ULL,
0x0000003126267220ULL, 0x080fe20000410000ULL, 0x0000003127277220ULL, 0x080fe20000410000ULL,
0x000000312a2a7220ULL, 0x080fe20000410000ULL, 0x000000312b2b7220ULL, 0x080fe20000410000ULL,
0x000000312e2e7220ULL, 0x080fe20000410000ULL, 0x000000312f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff33ff7812ULL, 0x000fda0007826032ULL, 0x0000003058301221ULL, 0x000fe20000010100ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b30301820ULL, 0x000fc80000410000ULL,
0x0000003000021308ULL, 0x000ea40000000800ULL, 0x0000000252521220ULL, 0x004fce0000410000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000104d387824ULL, 0x100fe200078e0253ULL,
0x000000534f447211ULL, 0x000fe200078e20ffULL, 0x000000104e3c7824ULL, 0x000fe200078e0253ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160bULL,
0x00000002ff00723eULL, 0x000fc600000000ffULL, 0x0000000803317836ULL, 0x002fe20000000000ULL,
0x0000541000307816ULL, 0x000fca0000000000ULL, 0x00001f0330037589ULL, 0x0002a800000e0000ULL,
0x00001f3130007589ULL, 0x0002e400000e0000ULL, 0x012800005030783bULL, 0x0022e20000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000031317232ULL, 0x080fe40000000000ULL,
0x0000000033337232ULL, 0x000fce0000000000ULL, 0x000000104c347824ULL, 0x100fe200078e0253ULL,
0x000000004444783bULL, 0x000f280000004200ULL, 0x000000003c3c783bULL, 0x000f680000004200ULL,
0x000000003838783bULL, 0x000f680000004200ULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x000000443010723cULL, 0x018fec0000001810ULL, 0x000000463014723cULL, 0x000fe20000001814ULL,
0x0000001049447824ULL, 0x000fca00078e0253ULL, 0x0000003c3018723cULL, 0x022fec0000001818ULL,
0x0000003e301c723cULL, 0x000fe2000000181cULL, 0x00000010483c7824ULL, 0x000fca00078e0253ULL,
0x000000383020723cULL, 0x000fec0000001820ULL, 0x0000003a3024723cULL, 0x000fe20000001824ULL,
0x0000005342397211ULL, 0x000fca00078e20ffULL, 0x000000343028723cULL, 0x004fec0000001828ULL,
0x00000036302c723cULL, 0x000fe2000000182cULL, 0x012800004a30783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000031317232ULL, 0x080fe40000000000ULL, 0x0000000033337232ULL, 0x000fce0000000000ULL,
0x000000003938783bULL, 0x000ee20000004200ULL, 0x0000005340347211ULL, 0x000fe200078e20ffULL,
0x0000000552057221ULL, 0x000fe20000010000ULL, 0x00000001045a7812ULL, 0x000fe200078ec0ffULL,
0x000000004444783bULL, 0x000f280000004200ULL, 0x000000003c3c783bULL, 0x000f680000004200ULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x000000383020723cULL, 0x00cfec0000001820ULL,
0x000000443010723cULL, 0x010fe20000001810ULL, 0x00000001ff387424ULL, 0x000fc800078e00ffULL,
0x01b6a0384bff79a7ULL, 0x0005e2000850003fULL, 0x000000463014723cULL, 0x000fec0000001814ULL,
0x0000003c3018723cULL, 0x022fec0000001818ULL, 0x0000003e301c723cULL, 0x000fec000000181cULL,
0x0000003a3024723cULL, 0x000fec0000001824ULL, 0x000000343028723cULL, 0x000fec0000001828ULL,
0x00000036302c723cULL, 0x004fde000000182cULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000010e417824ULL, 0x000fca00078e0241ULL, 0x0000000d4100720cULL, 0x000fda0003f06070ULL,
0xffffffa400708947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x000e620000002500ULL,
0x0000002d00357202ULL, 0x000fe20000000f00ULL, 0x000000ffff337224ULL, 0x000fe200078e0029ULL,
0x00000025002d7202ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fe200078e0023ULL,
0x0000001f00237202ULL, 0x000fe20000000f00ULL, 0x000000ffff257224ULL, 0x000fe200078e0021ULL,
0x0000002800327202ULL, 0x000fe20000000f00ULL, 0x000000ffff317224ULL, 0x000fe200078e0026ULL,
0x0000001c00267202ULL, 0x000fe20000000f00ULL, 0x000000ffff217224ULL, 0x000fc400078e001eULL,
0x000000ffff1f7224ULL, 0x000fe400078e001dULL, 0x000000ffff1e7224ULL, 0x000fe200078e001bULL,
0x00000019001b7202ULL, 0x000fe20000000f00ULL, 0x000000ffff347224ULL, 0x000fe200078e002cULL,
0x0000001600197202ULL, 0x000fe20000000f00ULL, 0x000000ffff307224ULL, 0x000fe200078e0027ULL,
0x0000002200277202ULL, 0x000fe20000000f00ULL, 0x000000ffff1d7224ULL, 0x000fe400078e001aULL,
0x000000ffff1c7224ULL, 0x000fc400078e0018ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0024ULL,
0x000000ffff287224ULL, 0x000fe400078e0020ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0017ULL,
0x000000ffff187224ULL, 0x000fe200078e0013ULL, 0x0000000d0200720cULL, 0x002fe20003f06070ULL,
0x000000ffff0f7224ULL, 0x000fd800078e0012ULL, 0x0000000000c80947ULL, 0x000fea0003800000ULL,
0x0180000005007810ULL, 0x000fc80007ffe0ffULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x000070c0000a7802ULL, 0x000fce0000000f00ULL, 0x0000009800207944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000500007308ULL, 0x000e640000001000ULL, 0xbf80000000037423ULL, 0x002fc80000000005ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fce0000000000ULL,
0x0000000000047919ULL, 0x000ea40000000000ULL, 0x00000002ff037819ULL, 0x004fe40000011604ULL,
0x0000000804077811ULL, 0x000fe200078ff0ffULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x00001f0300037589ULL, 0x000ea800000e0000ULL, 0x00001f0700047589ULL, 0x000ee200000e0000ULL,
0x0000001003107220ULL, 0x044fe20000410000ULL, 0x0000001103117220ULL, 0x040fe20000410000ULL,
0x0000001403147220ULL, 0x040fe20000410000ULL, 0x0000001503157220ULL, 0x040fe20000410000ULL,
0x0000001c031c7220ULL, 0x040fe20000410000ULL, 0x0000001b031b7220ULL, 0x040fe20000410000ULL,
0x0000002603267220ULL, 0x040fe20000410000ULL, 0x0000001f031f7220ULL, 0x040fe20000410000ULL,
0x0000002803287220ULL, 0x040fe20000410000ULL, 0x0000002503257220ULL, 0x040fe20000410000ULL,
0x0000002c032c7220ULL, 0x040fe20000410000ULL, 0x0000002d032d7220ULL, 0x040fe20000410000ULL,
0x0000003203327220ULL, 0x040fe20000410000ULL, 0x0000003303337220ULL, 0x040fe20000410000ULL,
0x0000003403347220ULL, 0x040fe20000410000ULL, 0x0000003503357220ULL, 0x000fe20000410000ULL,
0x0000000f040f7220ULL, 0x048fe20000410000ULL, 0x0000001804187220ULL, 0x040fe20000410000ULL,
0x0000001904197220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000003104317220ULL, 0x040fe20000410000ULL, 0x0000003004307220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x000fce0000410000ULL,
0x0000000000077919ULL, 0x000ea20000000000ULL, 0x0000000f1818723eULL, 0x000fe400000000ffULL,
0x000000101110723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000001c1b12723eULL, 0x000fc400000000ffULL, 0x000000141511723eULL, 0x000fe400000000ffULL,
0x00000021231b723eULL, 0x000fe400000000ffULL, 0x000000282514723eULL, 0x000fe400000000ffULL,
0x0000002c2d15723eULL, 0x000fe400000000ffULL, 0x000000323316723eULL, 0x000fe400000000ffULL,
0x000000343517723eULL, 0x000fc400000000ffULL, 0x000000191a19723eULL, 0x000fe400000000ffULL,
0x0000001d1e1a723eULL, 0x000fe400000000ffULL, 0x00000027291c723eULL, 0x000fe400000000ffULL,
0x00000031301d723eULL, 0x000fe400000000ffULL, 0x00000003ff047819ULL, 0x104fe20000011607ULL,
0x0000000108217824ULL, 0x000fe200078e0207ULL, 0xfffffff8ff037812ULL, 0x000fc400078ee207ULL,
0x0000000304007812ULL, 0x000fe400078ec0ffULL, 0x00000003030a7819ULL, 0x000fe200000006ffULL,
0x00000008030b7836ULL, 0x000fe20000000000ULL, 0x0000002a2b1e723eULL, 0x000fe200000000ffULL,
0x0000000803137824ULL, 0x000fe200078e00ffULL, 0x000000010e00780cULL, 0x000fe20003f05270ULL,
0x0000000100037824ULL, 0x000fe200078e0203ULL, 0x0000000b000d7210ULL, 0x000fe20007ffe0ffULL,
0x000000080b227824ULL, 0x040fe400078e00ffULL, 0x000000080b247824ULL, 0x000fe200078e00ffULL,
0x0000000403007810ULL, 0x000fe20007ffe0ffULL, 0x0000000c030b7836ULL, 0x000fe20000000000ULL,
0xfffffff80a0a7812ULL, 0x000fc400078ee203ULL, 0xfffffff813207812ULL, 0x000fe200078ee200ULL,
0x0000100006007824ULL, 0x000fe200078e020cULL, 0xfffffff824247812ULL, 0x000fe400078ee20bULL,
0x0000000b090b7819ULL, 0x000fe200000006ffULL, 0x0000001021257824ULL, 0x000fe200078e0200ULL,
0xfffffff822227812ULL, 0x000fe400078ee20dULL, 0x000000261f13723eULL, 0x000fe200000000ffULL,
0x00000001000f7824ULL, 0x000fe200078e020bULL, 0x0000002e2f1f723eULL, 0x000fc600000000ffULL,
0x000000100a0a7824ULL, 0x100fe200078e020fULL, 0x0000000f20207211ULL, 0x080fe200078e20ffULL,
0x0000001022227824ULL, 0x000fe200078e020fULL, 0x0000000f24247211ULL, 0x000fe400078e20ffULL,
0x000000100a007844ULL, 0x000fe80000000200ULL, 0x0000001420007844ULL, 0x000fe80000000200ULL,
0x0000001822007844ULL, 0x000fe80000000200ULL, 0x0000001c24007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000025287984ULL, 0x000ea80000000c00ULL,
0x0004000025307984ULL, 0x000ee80000000c00ULL, 0x00080000252c7984ULL, 0x000f280000000c00ULL,
0x000c000025347984ULL, 0x000f620000000c00ULL, 0x200000ff2b2b7230ULL, 0x004fc40000000000ULL,
0x200000ff2a2a7230ULL, 0x000fe40000000000ULL, 0x200000ff29297230ULL, 0x000fe40000000000ULL,
0x200000ff28287230ULL, 0x000fe40000000000ULL, 0x200000ff33337230ULL, 0x008fe40000000000ULL,
0x200000ff32327230ULL, 0x000fe40000000000ULL, 0x200000ff31317230ULL, 0x000fc40000000000ULL,
0x200000ff30307230ULL, 0x000fe40000000000ULL, 0x0000002f2b2b7230ULL, 0x010fe40000000000ULL,
0x0000002e2a2a7230ULL, 0x000fe40000000000ULL, 0x0000002d29297230ULL, 0x000fe40000000000ULL,
0x0000002c28287230ULL, 0x000fe40000000000ULL, 0x0000003733337230ULL, 0x022fc40000000000ULL,
0x0000003632327230ULL, 0x000fe20000000000ULL, 0x0000002825007388ULL, 0x0003e20000000c00ULL,
0x0000003531317230ULL, 0x000fe40000000000ULL, 0x0000003430307230ULL, 0x000fca0000000000ULL,
0x0004003025007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000002400888947ULL, 0x000fea0003800000ULL, 0x00009000ff037b82ULL, 0x000ea20000000800ULL,
0x00000000001d7919ULL, 0x000ee20000002700ULL, 0x0000000000147919ULL, 0x000eec0000002600ULL,
0x00008400ff167b82ULL, 0x000ea20000000800ULL, 0x0000000025107984ULL, 0x00092e0000000c00ULL,
0x00009400ff0c7b82ULL, 0x000f620000000a00ULL, 0x0000000316037224ULL, 0x004fc800078e02ffULL,
0x0000000e030a7224ULL, 0x040fe200078e02ffULL, 0x0000000f03157811ULL, 0x000fe200078e10ffULL,
0x000000161d1d7224ULL, 0x008fc600078e0214ULL, 0xfffffff015157812ULL, 0x000fe200078ec0ffULL,
0x0000000e1d207224ULL, 0x000fc800078e02ffULL, 0x000000800a237824ULL, 0x000fe400078e0215ULL,
0x0000000120027824ULL, 0x000fc600078e0202ULL, 0x000000230a0a7211ULL, 0x000fca00078e38ffULL,
0x0000007f0a037836ULL, 0x000fca0000000000ULL, 0xffffff8003037812ULL, 0x000fc800078ec0ffULL,
0x0000000c03177210ULL, 0x020fc80007f1e0ffULL, 0x0000001702167211ULL, 0x040fe400078258ffULL,
0x0000000dff177210ULL, 0x000fe400007fe4ffULL, 0x0000000109ff7812ULL, 0x000fe4000780f843ULL,
0x0000001702177211ULL, 0x000fe400008f5cffULL, 0x0000000c151f7210ULL, 0x000fe20007f3e0ffULL,
0x0000040006167825ULL, 0x000fc800078e0016ULL, 0x0000001021167825ULL, 0x000fc800078e0016ULL,
0x000000ffff217224ULL, 0x000fe200008e060dULL, 0x0000000000400947ULL, 0x012fec0003800000ULL,
0x0000001007147824ULL, 0x000fe200078e00ffULL, 0x00000007020a7819ULL, 0x000fe400000006ffULL,
0x00000001ff187819ULL, 0x000fe40000011607ULL, 0x00000070141b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a1a7210ULL, 0x000fe40007ebe023ULL, 0x00000019ff027819ULL, 0x000fe40000011602ULL,
0x0000000c18197812ULL, 0x000fc400078ec0ffULL, 0x0000001f1b0a7210ULL, 0x000fe40007a3e00aULL,
0x0000000d02147210ULL, 0x000fe40002fec4ffULL, 0x0000000a19187210ULL, 0x000fe40007fbe0ffULL,
0x00000021ff027210ULL, 0x000fe40000fe4402ULL, 0x0000001a191a7210ULL, 0x000fc60007c7e01bULL,
0x000000ffff197224ULL, 0x000fe200028e0602ULL, 0x00000014ff1b7210ULL, 0x000fc80001fe84ffULL,
0x0000005818007986ULL, 0x0003e8000c101906ULL, 0x000000051a007986ULL, 0x0003e4000c101906ULL,
0x000000ff0700720cULL, 0x000fe20000705670ULL, 0x0000001016007986ULL, 0x0005e2000c101d06ULL,
0x0000000000007b1dULL, 0x000ff60000000000ULL, 0x0000000000600947ULL, 0x000fea0003800000ULL,
0x00009400ff107b82ULL, 0x004ea20000000a00ULL, 0xffffffff0e057836ULL, 0x002fe40000000000ULL,
0x000000041d107825ULL, 0x004fe200078e0010ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000000ff00798fULL, 0x000fe80002000000ULL,
0x00000005101079a8ULL, 0x00032200099ee1c6ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000000ff00798fULL, 0x000fe20002000000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000051000720cULL, 0x010fc80003f05270ULL, 0x00000001ff027807ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x004fd20008000004ULL, 0x00000002ff007988ULL, 0x0005e60008000004ULL,
0x0000000000057919ULL, 0x002e620000008800ULL, 0x0000040000227802ULL, 0x000fe20000000f00ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000065405227816ULL, 0x002fca0000000022ULL, 0x0000000022027984ULL, 0x004e640000000000ULL,
0x000000ff0200720cULL, 0x002fda0003f05270ULL, 0x00000020004c8947ULL, 0x000fea0003800000ULL,
0x000000ff4300720cULL, 0x000fda0003f05270ULL, 0x0000000800940947ULL, 0x000fea0003800000ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x00000000006c8947ULL, 0x000fea0003800000ULL,
0x0000000407027819ULL, 0x000fe400000006ffULL, 0x00000001ff0a7819ULL, 0x000fe40000011607ULL,
0x0000001f20047211ULL, 0x000fe400078038ffULL, 0x0000007002057812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000002120027211ULL, 0x000fc400000f3cffULL,
0x000000040a047210ULL, 0x000fc8000791e005ULL, 0x00000002ff057210ULL, 0x000fca00007e24ffULL,
0x0000000604027981ULL, 0x000328000c1e1900ULL, 0x0000800604117981ULL, 0x000322000c1e1900ULL,
0x000000020e00780cULL, 0x000fda0003f05270ULL, 0x00000000003c8947ULL, 0x002fea0003800000ULL,
0x0001000604137981ULL, 0x000322000c1e1900ULL, 0x000000040e00780cULL, 0x000fda0003f06070ULL,
0x0000000000308947ULL, 0x002fea0003800000ULL, 0x0001800604177981ULL, 0x000322000c1e1900ULL,
0x000000040e00780cULL, 0x000fda0003f05270ULL, 0x0000000000248947ULL, 0x002fea0003800000ULL,
0x0002000604197981ULL, 0x000322000c1e1900ULL, 0x000000060e00780cULL, 0x000fda0003f06070ULL,
0x0000000000188947ULL, 0x002fea0003800000ULL, 0x00028006041b7981ULL, 0x000322000c1e1900ULL,
0x000000060e00780cULL, 0x000fda0003f05270ULL, 0x00000000000c8947ULL, 0x002fea0003800000ULL,
0x000000080e00780cULL, 0x000fe20003f06070ULL, 0x00030006041d7981ULL, 0x000318000c1e1900ULL,
0x00038006041f0981ULL, 0x000324000c1e1900ULL, 0x000000070e047836ULL, 0x002fca0000000000ULL,
0x00000003ff0a7819ULL, 0x000fc80000011604ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x0000000400f48947ULL, 0x000fea0003800000ULL, 0x0000001520057211ULL, 0x040fe200078038ffULL,
0x000000ffff217224ULL, 0x010fe200078e0002ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x0000003f00057c82ULL, 0x000fe20008000000ULL, 0x0000000c050c7210ULL, 0x000fe40007f3e0ffULL,
0x000000ff20047211ULL, 0x000fe400000f3cffULL, 0x000007800c257810ULL, 0x000fc80007f5e0ffULL,
0x00000004ff0d7210ULL, 0x000fd200017e240dULL, 0x000000040e007c0cULL, 0x000fe2000bf23070ULL,
0x0000000105057890ULL, 0x000fcc000fffe03fULL, 0x000000050a007c0cULL, 0x000fcc000bf03070ULL,
0x0000000400b41947ULL, 0x012fee0003800000ULL, 0x0000000804087890ULL, 0x000fe2000fffe03fULL,
0x0000002102027209ULL, 0x000fca0007810000ULL, 0x000000080e007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000000407047819ULL, 0x000fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe40000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000425047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060dULL, 0xfffc800604217981ULL, 0x000326000c1e1900ULL,
0x0000000104087890ULL, 0x000fcc000fffe03fULL, 0x000000080e007c0cULL, 0x000fda000bf23070ULL,
0x00000004007c1947ULL, 0x000fea0003800000ULL, 0x0000000904087890ULL, 0x000fe2000fffe03fULL,
0x0000001102027209ULL, 0x000fca0007810000ULL, 0x000000080e007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000425047210ULL, 0x000fc80007f3e0ffULL,
0x0000000dff057210ULL, 0x000fca0000ffe4ffULL, 0xfffd000604117981ULL, 0x000328000c1e1900ULL,
0x0000000204087890ULL, 0x000fcc000fffe03fULL, 0x000000080e007c0cULL, 0x000fda000bf23070ULL,
0x0000000400441947ULL, 0x000fea0003800000ULL, 0x0000000a04087890ULL, 0x000fe2000fffe03fULL,
0x0000001302027209ULL, 0x000fca0007810000ULL, 0x000000080e007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000425047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060dULL, 0xfffd800604137981ULL, 0x000326000c1e1900ULL,
0x0000000304087890ULL, 0x000fcc000fffe03fULL, 0x000000080e007c0cULL, 0x000fda000bf23070ULL,
0x00000004000c1947ULL, 0x000fea0003800000ULL, 0x0000000b04087890ULL, 0x000fe2000fffe03fULL,
0x0000001702027209ULL, 0x000fca0007810000ULL, 0x000000080e007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000000407047819ULL, 0x002fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe40000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000425047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060dULL, 0xfffe000604177981ULL, 0x000326000c1e1900ULL,
0x0000000404087890ULL, 0x000fcc000fffe03fULL, 0x000000080e007c0cULL, 0x000fda000bf23070ULL,
0x0000000000d41947ULL, 0x000fea0003800000ULL, 0x0000000c04087890ULL, 0x000fe2000fffe03fULL,
0x0000001902027209ULL, 0x000fca0007810000ULL, 0x000000080e007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000425047210ULL, 0x000fc80007f3e0ffULL,
0x0000000dff057210ULL, 0x000fca0000ffe4ffULL, 0xfffe800604197981ULL, 0x000328000c1e1900ULL,
0x0000000504087890ULL, 0x000fcc000fffe03fULL, 0x000000080e007c0cULL, 0x000fda000bf23070ULL,
0x00000000009c1947ULL, 0x000fea0003800000ULL, 0x0000000d04087890ULL, 0x000fe2000fffe03fULL,
0x0000001b02027209ULL, 0x000fca0007810000ULL, 0x000000080e007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000425047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060dULL, 0xffff0006041b7981ULL, 0x000326000c1e1900ULL,
0x0000000604087890ULL, 0x000fcc000fffe03fULL, 0x000000080e007c0cULL, 0x000fda000bf23070ULL,
0x0000000000641947ULL, 0x000fea0003800000ULL, 0x0000000e04087890ULL, 0x000fe2000fffe03fULL,
0x0000001d02027209ULL, 0x000fca0007810000ULL, 0x000000080e007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000000407047819ULL, 0x002fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe40000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000425047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060dULL, 0xffff8006041d7981ULL, 0x000326000c1e1900ULL,
0x0000000704087890ULL, 0x000fcc000fffe03fULL, 0x000000080e007c0cULL, 0x000fda000bf23070ULL,
0x00000000002c1947ULL, 0x000fea0003800000ULL, 0x0000000f04087890ULL, 0x000fe2000fffe03fULL,
0x0000001f02027209ULL, 0x000fca0007810000ULL, 0x000000080e007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x0000001007047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011607ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x0000000425047210ULL, 0x000fc80007f3e0ffULL,
0x0000000dff057210ULL, 0x000fca0000ffe4ffULL, 0x00000006041f7981ULL, 0x000328000c1e1900ULL,
0x0000040025257810ULL, 0x000fe20007f3e0ffULL, 0x0000000804047890ULL, 0x000fc8000fffe03fULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0xfffffff8002c8947ULL, 0x000fee000383ffffULL,
0x0000000000077919ULL, 0x000ea40000000000ULL, 0x0000001007047824ULL, 0x006fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fc80000011607ULL, 0x0000007004057812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000220a057210ULL, 0x000fca0007ffe005ULL,
0x0000000205007388ULL, 0x0103e40000000800ULL, 0x00009400ff287b82ULL, 0x000ea20000000a00ULL,
0x000000070700780cULL, 0x000fe20003f04070ULL, 0x0000200009257824ULL, 0x000fe200078e0222ULL,
0x0000002009117210ULL, 0x000fe20007ffe0ffULL, 0x0000001007277824ULL, 0x000fe200078e00ffULL,
0x0000000a43217819ULL, 0x000fe200000006ffULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0x00000001090a7812ULL, 0x000fe400078ec0ffULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000040021217812ULL, 0x000fc400078ee2ffULL, 0x00000000003a7805ULL, 0x000fe4000001ff00ULL,
0x0000002506257211ULL, 0x000fe400078e60ffULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x00000001ff267819ULL, 0x000fe20000011607ULL, 0x0000020009138824ULL, 0x100fe200078e0222ULL,
0x0000007027277812ULL, 0x000fe200078ec0ffULL, 0x0000020009058824ULL, 0x002fe200078e0222ULL,
0x0000000c26267812ULL, 0x000fc400078ec0ffULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x0000001306138211ULL, 0x040fe200078e40ffULL, 0x00000100060d8824ULL, 0x000fe200078e0205ULL,
0x00000022262a7210ULL, 0x000fe20007ffe027ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000002803027210ULL, 0x004fe20007f3e0ffULL, 0x000000800a128824ULL, 0x040fe200078e020dULL,
0x0000002815247210ULL, 0x000fe20007f7e0ffULL, 0x000000800a148824ULL, 0x000fe200078e0213ULL,
0x000008000b0a7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff037224ULL, 0x000fe200008e0629ULL,
0x0000002823237210ULL, 0x000fe20007f3e0ffULL, 0x00000020070b7836ULL, 0x000fe20000000000ULL,
0x0000000a250a7210ULL, 0x000fe20007ffe0ffULL, 0x0000080011047825ULL, 0x000fe200078e0002ULL,
0x0000001207158211ULL, 0x000fe200078e20ffULL, 0x000000002a2a7984ULL, 0x000e620000000800ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff287224ULL, 0x100fe200008e0629ULL,
0x0000002104047210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff297224ULL, 0x000fe200018e0629ULL,
0x00000023110c8211ULL, 0x000fe200078238ffULL, 0x0000001007137824ULL, 0x040fe200078e020aULL,
0x00000005ff057210ULL, 0x000fe200017fe4ffULL, 0x0000001007178824ULL, 0x000fe200078e0214ULL,
0x0000002411108211ULL, 0x000fc400078438ffULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000028110d8211ULL, 0x000fe200008f3cffULL, 0x000000100b0a7825ULL, 0x100fe200078e0004ULL,
0x0000000e0900720cULL, 0x000fe40003f26070ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x0000002911118211ULL, 0x000fe200010f3cffULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000000000327805ULL, 0x000fc4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000010070c8825ULL, 0x040fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000004137faeULL, 0x0005e2000b901c46ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000001007108825ULL, 0x000fe200078e0010ULL, 0x003800000a137faeULL, 0x0005e2000b901c46ULL,
0x0000000000467805ULL, 0x000fc4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x045800000c158faeULL, 0x0005e2000b901c46ULL,
0x00000000004a7805ULL, 0x000fc6000001ff00ULL, 0x0418000010178faeULL, 0x0005e8000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000800601947ULL, 0x000fea0003800000ULL,
0x00000003ff047819ULL, 0x004fe20000011607ULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0xfffffff8ff057812ULL, 0x000fe200078ee207ULL, 0x000000ffff4d7224ULL, 0x000fe200078e0009ULL,
0x0000000304047812ULL, 0x000fe400078ec0ffULL, 0x00000008050b7810ULL, 0x000fe20007ffe0ffULL,
0x00000008050d7824ULL, 0x040fe200078e00ffULL, 0x00000002ff527819ULL, 0x000fe20000011607ULL,
0x00000008054e7824ULL, 0x000fe200078e00ffULL, 0x0000000504057210ULL, 0x000fe20007ffe0ffULL,
0x00000001044f7824ULL, 0x000fe200078e020bULL, 0x000000030b0a7819ULL, 0x040fe200000006ffULL,
0x000000080b047824ULL, 0x000fe200078e00ffULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee205ULL,
0x0000000405507836ULL, 0x000fc40000000000ULL, 0x0000000c05517836ULL, 0x000fe20000000000ULL,
0x0000002209057211ULL, 0x000fe200078e48ffULL, 0x00000008524c7836ULL, 0x000fe20000000000ULL,
0xfffffff8044f7812ULL, 0x000fe400078ee24fULL, 0xfffffff80d507812ULL, 0x000fe400078ee250ULL,
0xfffffff80a517812ULL, 0x000fe400078ee251ULL, 0x0000000506547211ULL, 0x000fce00078e40ffULL,
0x000000014d0b7836ULL, 0x000fca0000000000ULL, 0x0000000e0b00720cULL, 0x000fda0003f06070ULL,
0x0000000000880947ULL, 0x000fea0003800000ULL, 0x000000070700780cULL, 0x000fe40003f44070ULL,
0x0000000b20137210ULL, 0x000fca0007ffe0ffULL, 0x0000080013047825ULL, 0x000fc600078e0002ULL,
0x0000002104107210ULL, 0x000fc60007f1e0ffULL, 0x00000200090da824ULL, 0x100fe400078e0222ULL,
0x000008000b047824ULL, 0x000fe400078e00ffULL, 0x000002000915a824ULL, 0x000fe200078e0222ULL,
0x0000000d0654a211ULL, 0x000fe200078e40ffULL, 0x000000ffff117224ULL, 0x000fe200000e0605ULL,
0x000000010b0d7812ULL, 0x000fe400078ec0ffULL, 0x00000800040c7812ULL, 0x000fe400078ec0ffULL,
0x00000023130aa211ULL, 0x000fe200078038ffULL, 0x000000800d12a824ULL, 0x000fe200078e0254ULL,
0x000000241304a211ULL, 0x000fe200078238ffULL, 0x000001000654a824ULL, 0x000fe200078e0215ULL,
0x0000000c250c7210ULL, 0x000fc40007ffe0ffULL, 0x0000002007157810ULL, 0x000fe20007ffe0ffULL,
0x000000800d14a824ULL, 0x000fe200078e0254ULL, 0x00000028130ba211ULL, 0x040fe400000f3cffULL,
0x000000291305a211ULL, 0x000fe200008f3cffULL, 0x0000001007137824ULL, 0x000fe400078e020cULL,
0x00000010150c7825ULL, 0x000fe200078e0010ULL, 0x000000120715a211ULL, 0x000fc600078e20ffULL,
0x0000001007107825ULL, 0x000fc800078e0010ULL, 0x00000010070aa825ULL, 0x040fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000010137faeULL, 0x0005e6000b901c46ULL,
0x000000100704a825ULL, 0x040fe200078e0004ULL, 0x003800000c137faeULL, 0x0005e6000b901c46ULL,
0x000000100717a824ULL, 0x000fe200078e0214ULL, 0x045800000a15afaeULL, 0x0005e8000b901c46ULL,
0x041800000417afaeULL, 0x0005e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000804d047824ULL, 0x004fca00078e00ffULL, 0x0000008004047812ULL, 0x000fc800078ec0ffULL,
0x0000005427057210ULL, 0x000fe20007ffe004ULL, 0x000008004d047824ULL, 0x000fe200078e00ffULL,
0x000000024d4d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000526057210ULL, 0x000fe40007ffe0ffULL,
0x0000080004047812ULL, 0x000fe400078ec0ffULL, 0x0000000e4d00720cULL, 0x000fe40003f06070ULL,
0x0000018025047810ULL, 0x000fe20007ffe004ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00418000050b7984ULL, 0x000ea20000000800ULL, 0x000000104e107824ULL, 0x100fe200078e0204ULL,
0x0000000450147211ULL, 0x000fe200078e20ffULL, 0x000000104f187824ULL, 0x100fe200078e0204ULL,
0x00458000050d7984ULL, 0x000fe20000000800ULL, 0x00000010511c7824ULL, 0x000fc600078e0204ULL,
0x000000001010783bULL, 0x000ee80000000200ULL, 0x000000001414783bULL, 0x000f280000000200ULL,
0x000000001818783bULL, 0x000f680000000200ULL, 0x000000001c1c783bULL, 0x000f620000000200ULL,
0x0000000b2a0b7221ULL, 0x006fc80000010100ULL, 0x3fb8aa3b0b0c7820ULL, 0x000fe20000410000ULL,
0x20000011ff0b7230ULL, 0x008fca0000004100ULL, 0x0000000c000c7308ULL, 0x000e620000000800ULL,
0x30000011ff047230ULL, 0x000fe40000004100ULL, 0x20000013ff117230ULL, 0x000fe40000004100ULL,
0x30000013ff0a7230ULL, 0x000fe40000004100ULL, 0x20000015ff537230ULL, 0x010fe40000004100ULL,
0x20000017ff557230ULL, 0x000fe40000004100ULL, 0x30000017ff567230ULL, 0x000fc40000004100ULL,
0x20000019ff577230ULL, 0x020fe40000004100ULL, 0x0000000d0c5f7220ULL, 0x002fe20000410000ULL,
0x30000015ff0c7230ULL, 0x000fe40000004100ULL, 0x30000019ff587230ULL, 0x000fe40000004100ULL,
0x0000004b5f4b7221ULL, 0x000fe20000010000ULL, 0x00001f525f607589ULL, 0x000e6200000e0000ULL,
0x2000001cff5a7230ULL, 0x000fe40000004100ULL, 0x3000001cff5b7230ULL, 0x000fe20000004100ULL,
0x00001f4c5f617589ULL, 0x000ea200000e0000ULL, 0x20000010ff057230ULL, 0x000fc40000004100ULL,
0x20000012ff0d7230ULL, 0x000fe40000004100ULL, 0x20000014ff137230ULL, 0x000fe40000004100ULL,
0x20000016ff157230ULL, 0x000fe40000004100ULL, 0x20000018ff177230ULL, 0x000fe40000004100ULL,
0x2000001aff197230ULL, 0x000fe40000004100ULL, 0x2000001bff597230ULL, 0x000fc40000004100ULL,
0x2000001dff1c7230ULL, 0x000fe40000004100ULL, 0x2000001eff5c7230ULL, 0x000fe40000004100ULL,
0x3000001eff5d7230ULL, 0x000fe40000004100ULL, 0x00000060054a7223ULL, 0x082fe2000001004aULL,
0x30000010ff107230ULL, 0x000fe40000004100ULL, 0x000000600b487223ULL, 0x000fe20000010048ULL,
0x30000012ff127230ULL, 0x000fc40000004100ULL, 0x0000006004477223ULL, 0x080fe20000010047ULL,
0x30000014ff147230ULL, 0x000fe40000004100ULL, 0x0000006010497223ULL, 0x080fe20000010049ULL,
0x30000016ff167230ULL, 0x000fe40000004100ULL, 0x000000600d467223ULL, 0x080fe20000010046ULL,
0x30000018ff187230ULL, 0x000fe40000004100ULL, 0x0000006012457223ULL, 0x000fe20000010045ULL,
0x3000001aff1a7230ULL, 0x000fc40000004100ULL, 0x0000006011447223ULL, 0x080fe20000010044ULL,
0x3000001bff1b7230ULL, 0x000fe40000004100ULL, 0x000000600a437223ULL, 0x080fe20000010043ULL,
0x3000001dff1d7230ULL, 0x000fe40000004100ULL, 0x0000006013427223ULL, 0x080fe20000010042ULL,
0x2000001fff1e7230ULL, 0x000fe40000004100ULL, 0x0000006014417223ULL, 0x000fe20000010041ULL,
0x3000001fff5e7230ULL, 0x000fc40000004100ULL, 0x0000006053407223ULL, 0x080fe20000010040ULL,
0x000000600c3f7223ULL, 0x080fe2000001003fULL, 0x00000060153e7223ULL, 0x080fe2000001003eULL,
0x00000060163d7223ULL, 0x080fe2000001003dULL, 0x00000060553c7223ULL, 0x080fe2000001003cULL,
0x00000060563b7223ULL, 0x000fe2000001003bULL, 0x00000061172c7223ULL, 0x084fe2000001002cULL,
0x0000006118397223ULL, 0x080fe20000010039ULL, 0x0000006157387223ULL, 0x080fe20000010038ULL,
0x0000006158377223ULL, 0x080fe20000010037ULL, 0x0000006119367223ULL, 0x080fe20000010036ULL,
0x000000611a357223ULL, 0x080fe20000010035ULL, 0x0000006159347223ULL, 0x080fe20000010034ULL,
0x000000611b3a7223ULL, 0x080fe2000001003aULL, 0x000000615a337223ULL, 0x080fe20000010033ULL,
0x000000615b327223ULL, 0x080fe20000010032ULL, 0x000000611c317223ULL, 0x080fe20000010031ULL,
0x000000611d307223ULL, 0x080fe20000010030ULL, 0x000000615c2f7223ULL, 0x080fe2000001002fULL,
0x000000615d2e7223ULL, 0x080fe2000001002eULL, 0x000000611e2d7223ULL, 0x080fe2000001002dULL,
0x000000615e2b7223ULL, 0x000fe2000001002bULL, 0xfffffff400f88947ULL, 0x000fec000383ffffULL,
0x0000000000027919ULL, 0x000ee20000000000ULL, 0x000000ff0600720cULL, 0x000fe20003f05270ULL,
0x0000001002037824ULL, 0x008fe200078e00ffULL, 0x00000001ff047819ULL, 0x004fe20000011602ULL,
0x0000498022027836ULL, 0x000fc60000000000ULL, 0x0000007003077812ULL, 0x000fe400078ec0ffULL,
0x0000000c040a7812ULL, 0x000fca00078ec0ffULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea20000000000ULL, 0x0000008009227824ULL, 0x000fe200078e0222ULL,
0x0000000403047819ULL, 0x004fe400000006ffULL, 0x00000001ff057819ULL, 0x000fe40000011603ULL,
0x0000007004037812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000002205227210ULL, 0x000fca0007ffe003ULL, 0x0049804b22007388ULL, 0x0005e40000000800ULL,
0x000000020a027210ULL, 0x000fe20007ffe007ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000002037984ULL, 0x000ee80000000800ULL, 0x0000800002047984ULL, 0x000f220000000800ULL,
0x00000003ff037221ULL, 0x008fc80000010000ULL, 0x0000000403037221ULL, 0x010fc80000010000ULL,
0x0180000003047836ULL, 0x000fca0000000000ULL, 0x7f80000004047812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0400780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x0000000300057202ULL, 0x000fe40000000f00ULL,
0x00009740000a7802ULL, 0x000fce0000000f00ULL, 0x0000007000807944ULL, 0x006fea0003c00000ULL,
0x000000ffff027224ULL, 0x00cfe200078e0003ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000300027308ULL, 0x000ee40000001000ULL, 0xbf80000003047423ULL, 0x008fc80000000002ULL,
0x800000ff04057221ULL, 0x000fc80000010100ULL, 0x0000000502027223ULL, 0x000fce0000000002ULL,
0x0000000000077919ULL, 0x000ee40000000000ULL, 0x00000002ff037819ULL, 0x108fe40000011607ULL,
0x0000000807057811ULL, 0x002fe400078ff0ffULL, 0x00000003ff047819ULL, 0x000fe20000011607ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0302037589ULL, 0x000e6200000e0000ULL,
0xfffffff8ff187812ULL, 0x000fc600078ee207ULL, 0x00001f0502057589ULL, 0x00072200000e0000ULL,
0x0000000318177819ULL, 0x040fe200000006ffULL, 0x00000008181a7836ULL, 0x000fe40000000000ULL,
0x00000008181e7824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000081a207824ULL, 0x000fc400078e00ffULL, 0x000000081a1c7824ULL, 0x000fe400078e00ffULL,
0x0000004a030c7220ULL, 0x042fe20000410000ULL, 0x0000004903497220ULL, 0x040fe20000410000ULL,
0x00000048030d7220ULL, 0x040fe20000410000ULL, 0x00000047030a7220ULL, 0x040fe20000410000ULL,
0x00000046030e7220ULL, 0x040fe20000410000ULL, 0x0000004503457220ULL, 0x040fe20000410000ULL,
0x0000004403447220ULL, 0x040fe20000410000ULL, 0x0000004303437220ULL, 0x040fe20000410000ULL,
0x0000004203107220ULL, 0x040fe20000410000ULL, 0x0000004103417220ULL, 0x040fe20000410000ULL,
0x0000004003117220ULL, 0x040fe20000410000ULL, 0x0000003f03027220ULL, 0x048fe20000410000ULL,
0x0000003e03127220ULL, 0x040fe20000410000ULL, 0x0000003d033d7220ULL, 0x040fe20000410000ULL,
0x0000003c03137220ULL, 0x040fe20000410000ULL, 0x0000003b03147220ULL, 0x000fe20000410000ULL,
0x0000002c052c7220ULL, 0x050fe20000410000ULL, 0x0000003905397220ULL, 0x040fe20000410000ULL,
0x0000003805387220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003505357220ULL, 0x040fe20000410000ULL,
0x0000003405347220ULL, 0x040fe20000410000ULL, 0x0000003a05037220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003105317220ULL, 0x040fe20000410000ULL, 0x0000003005307220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002d052d7220ULL, 0x040fe20000410000ULL, 0x0000002b05167220ULL, 0x000fe20000410000ULL,
0x0000000304057812ULL, 0x000fc400078ec0ffULL, 0x00000034031b723eULL, 0x000fe400000000ffULL,
0x0000001a050b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000105187824ULL, 0x000fe200078e0218ULL,
0x0000000c490c723eULL, 0x000fe400000000ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL,
0x0000000c18157836ULL, 0x000fe20000000000ULL, 0x0000000418057810ULL, 0x000fe40007ffe0ffULL,
0xfffffff817187812ULL, 0x000fc400078ee218ULL, 0xfffffff81e1a7812ULL, 0x000fe400078ee205ULL,
0xfffffff8201e7812ULL, 0x000fe200078ee215ULL, 0x0000001018057824ULL, 0x100fe200078e020fULL,
0x0000000f1c3a7211ULL, 0x000fe200078e20ffULL, 0x000000101a0b7824ULL, 0x100fe200078e020fULL,
0x0000000d0a0d723eULL, 0x000fe200000000ffULL, 0x000000101e3b7824ULL, 0x000fe200078e020fULL,
0x0000000e450e723eULL, 0x000fe400000000ffULL, 0x00000044430f723eULL, 0x000fc400000000ffULL,
0x0000000708037210ULL, 0x000fe40007ffe0ffULL, 0x000000104110723eULL, 0x000fe200000000ffULL,
0x0000000c05007844ULL, 0x000fe20000000200ULL, 0x000000110211723eULL, 0x000fe200000000ffULL,
0x0000001003037824ULL, 0x000fe200078e0200ULL, 0x000000123d12723eULL, 0x000fe400000000ffULL,
0x000000131413723eULL, 0x000fe400000000ffULL, 0x0000002c3918723eULL, 0x000fc400000000ffULL,
0x000000383719723eULL, 0x000fe200000000ffULL, 0x000000100b007844ULL, 0x000fe20000000200ULL,
0x00000036351a723eULL, 0x000fe400000000ffULL, 0x00000033321c723eULL, 0x000fe400000000ffULL,
0x00000031301d723eULL, 0x000fe200000000ffULL, 0x000000183a007844ULL, 0x000fe20000000200ULL,
0x0000002f2e1e723eULL, 0x000fe400000000ffULL, 0x0000002d161f723eULL, 0x000fca00000000ffULL,
0x0000001c3b007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000003147984ULL, 0x000e680000000c00ULL, 0x0004000003247984ULL, 0x000ee80000000c00ULL,
0x0008000003207984ULL, 0x004ea80000000c00ULL, 0x000c000003287984ULL, 0x000f220000000c00ULL,
0x200000ff17177230ULL, 0x002fc40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fe40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x008fe40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fc40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x0000002317177230ULL, 0x004fe40000000000ULL, 0x0000002216167230ULL, 0x000fe40000000000ULL,
0x0000002115157230ULL, 0x000fe40000000000ULL, 0x0000002014147230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x010fc40000000000ULL, 0x0000002a26267230ULL, 0x000fe20000000000ULL,
0x0000001403007388ULL, 0x0003e20000000c00ULL, 0x0000002925257230ULL, 0x000fe40000000000ULL,
0x0000002824247230ULL, 0x000fca0000000000ULL, 0x0004002403007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002007127836ULL, 0x000fe20000000000ULL,
0x0000000000107919ULL, 0x000ea20000002600ULL, 0x0000000704057210ULL, 0x000fe20007ffe0ffULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x00000003ff037819ULL, 0x002fe20000011612ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000705087812ULL, 0x000fe400078ec0ffULL, 0x0000000306147819ULL, 0x000fe200000006ffULL,
0x0000000112027824ULL, 0x000fe200078e0203ULL, 0x0ffffff808097812ULL, 0x000fc400078ef807ULL,
0x0000000306137819ULL, 0x000fe400000006ffULL, 0x0000000702027812ULL, 0x000fc800078ec0ffULL,
0x0ffffff802057812ULL, 0x000fe200078ef812ULL, 0x0000001009027824ULL, 0x000fc600078e0200ULL,
0x0000000005057211ULL, 0x000fe400078e20ffULL, 0x0000000002087984ULL, 0x0003220000000c00ULL,
0x00000005040472a4ULL, 0x008fc6000f8e023fULL, 0x00000000050c7984ULL, 0x0007620000000c00ULL,
0x0000000810117824ULL, 0x044fe400078e00ffULL, 0x0000000810107824ULL, 0x000fc600078e00ffULL,
0xfffffff811047812ULL, 0x000fe400078ee204ULL, 0xfffffff810037812ULL, 0x000fe400078ee203ULL,
0x0000000404107c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000403007c10ULL, 0x000fe2000ff3e0ffULL,
0x0000860000047ab9ULL, 0x000fe20000000a00ULL, 0xfffffff814117812ULL, 0x000fe200078ee207ULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x0000000410027c11ULL, 0x002fe2000f8040ffULL,
0x000000ffff057224ULL, 0x008fe200008e06ffULL, 0x0000000400047c11ULL, 0x000fc4000f8240ffULL,
0x0000000510037c11ULL, 0x000fe400080f4403ULL, 0x0000000500057c11ULL, 0x000fe400088f4405ULL,
0xfffffff813077812ULL, 0x000fe200078ee212ULL, 0x0000001011027825ULL, 0x000fc800078e0002ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x010fe8000c101d06ULL,
0x0000000c04007986ULL, 0x020fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000141007810ULL, 0x000fe20007ffe0ffULL, 0x0000000213137824ULL, 0x000fe200078e00ffULL,
0x00008e0000047ab9ULL, 0x000fe20000000800ULL, 0x0000004043027824ULL, 0x000fe200078e00ffULL,
0x0000000d0000720cULL, 0x000fe20003f06070ULL, 0x00000001ff057424ULL, 0x000fe400078e00ffULL,
0x0000010041097824ULL, 0x000fe400078e0202ULL, 0x0000000813007e24ULL, 0x000fe4000f8e0210ULL,
0x01b600050c0479a7ULL, 0x0002a4000850003fULL, 0x0000000400087c24ULL, 0x000fc8000f8e0209ULL,
0x0000000800e88947ULL, 0x000fea0003800000ULL, 0x00008a00ff067b82ULL, 0x000ee20000000a00ULL,
0x00000003ff317819ULL, 0x100fe4000001160bULL, 0x000000090f0a7248ULL, 0x000fe40007fe0000ULL,
0x0000000431137810ULL, 0x000fe20007ffe0ffULL, 0x0000000831157836ULL, 0x000fe20000000000ULL,
0x0000000c31177810ULL, 0x000fe20007ffe0ffULL, 0x0000001031197836ULL, 0x000fe20000000000ULL,
0x0000000a090a7210ULL, 0x000fe20007ffe1ffULL, 0x0000000113107824ULL, 0x100fe200078e020bULL,
0x0000007003037812ULL, 0x000fe200078ec0ffULL, 0x0000000813117824ULL, 0x000fe200078e00ffULL,
0x0000000315247819ULL, 0x040fe200000006ffULL, 0x0000000115097824ULL, 0x100fe200078e020bULL,
0x0000000a1300720cULL, 0x080fe20003f86070ULL, 0x0000000117127824ULL, 0x040fe200078e020bULL,
0xfffffff811187812ULL, 0x000fe200078ee210ULL, 0x0000000108117824ULL, 0x040fe200078e0231ULL,
0xfffffff824247812ULL, 0x000fe200078ee209ULL, 0x00000008171b7824ULL, 0x000fe200078e00ffULL,
0x0000000b19147210ULL, 0x000fe20007ffe0ffULL, 0x0000000108097824ULL, 0x000fe200078e0213ULL,
0x0000000a1500720cULL, 0x000fe20003f46070ULL, 0x0000010011107825ULL, 0x008fe200078e0006ULL,
0xfffffff81b267812ULL, 0x000fc400078ee212ULL, 0x0000001431237810ULL, 0x000fe20007ffe0ffULL,
0x00000008191d7824ULL, 0x000fe200078e00ffULL, 0x00000010031a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000108137824ULL, 0x040fe200078e0215ULL, 0x0000000a1700720cULL, 0x000fe20003f66070ULL,
0x0000000108157824ULL, 0x000fe200078e0217ULL, 0x00000011ff1b7210ULL, 0x000fe200007fe4ffULL,
0x0000010009107825ULL, 0x100fe200078e0006ULL, 0xfffffff81d287812ULL, 0x000fe400078ee214ULL,
0x00000018312b7810ULL, 0x000fe20007ffe0ffULL, 0x0000010013127825ULL, 0x000fe200078e0006ULL,
0x00000010031c7210ULL, 0x000fc40007f3e0ffULL, 0x0000000a1900720cULL, 0x000fe20003f06070ULL,
0x0000010015147825ULL, 0x000fe200078e0006ULL, 0x00000011ff1d7210ULL, 0x000fe40000ffe4ffULL,
0x00000012031e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000108097824ULL, 0x040fe200078e0219ULL,
0x0000001403207210ULL, 0x000fe20007fbe0ffULL, 0x0000000108177824ULL, 0x000fe200078e0223ULL,
0x0000002031297810ULL, 0x000fe20007ffe0ffULL, 0x0000010009107825ULL, 0x000fe200078e0006ULL,
0x00000034312d7810ULL, 0x000fc40007ffe0ffULL, 0x0000002908197210ULL, 0x000fe20007ffe0ffULL,
0x0000010017167825ULL, 0x000fc800078e0006ULL, 0x000000ffff1f7224ULL, 0x000fe200008e0613ULL,
0x0000001003127210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff217224ULL, 0x000fe200028e0615ULL,
0x0000001603107210ULL, 0x000fe20007fbe0ffULL, 0x0000000131147824ULL, 0x000fe200078e020bULL,
0x00000011ff137210ULL, 0x000fe20000ffe4ffULL, 0x00000008232a7824ULL, 0x040fe200078e00ffULL,
0x0000000a2300720cULL, 0x080fe20003f26070ULL, 0x000000ffff117224ULL, 0x000fe200028e0617ULL,
0x0000000714167812ULL, 0x000fe200078ec0ffULL, 0x0000000108157824ULL, 0x000fe200078e022bULL,
0x0000000a3100720cULL, 0x000fe20003fa6070ULL, 0x0000400043097824ULL, 0x000fe200078e020cULL,
0x0000000b23177210ULL, 0x000fe20007ffe0ffULL, 0x0000001c31237836ULL, 0x000fe20000000000ULL,
0x0ffffff816167812ULL, 0x000fe200078ef80bULL, 0x0000010015147825ULL, 0x000fe200078e0006ULL,
0xfffffff82a2a7812ULL, 0x000fc600078ee217ULL, 0x0000100009097836ULL, 0x000fe20000000000ULL,
0x0000001403147210ULL, 0x000fe20007fde0ffULL, 0x0000000108177824ULL, 0x000fe400078e0223ULL,
0x0000001016257824ULL, 0x000fe200078e0209ULL, 0x00000015ff157210ULL, 0x000fe200037fe4ffULL,
0x0000010017167825ULL, 0x000fc600078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a257faeULL, 0x0007e2000e901c46ULL, 0x0000001018277824ULL, 0x000fe200078e0209ULL,
0x0000001603227210ULL, 0x000fe20007fde0ffULL, 0x000000012b2c7824ULL, 0x000fe200078e020bULL,
0x0000000b23167210ULL, 0x000fe20007ffe0ffULL, 0x0000010019187825ULL, 0x000fe200078e0006ULL,
0x000000001c277faeULL, 0x0009e2000e101c46ULL, 0x0000000a2b00720cULL, 0x0c0fe40003fa6070ULL,
0x000000082b2b7824ULL, 0x000fe200078e00ffULL, 0x0000000a2300720cULL, 0x000fe20003f86070ULL,
0x00000038312f7836ULL, 0x000fc40000000000ULL, 0x00000008231b7824ULL, 0x008fe200078e00ffULL,
0xfffffff82b2c7812ULL, 0x000fe200078ee22cULL, 0x0000002431257836ULL, 0x000fe40000000000ULL,
0x00000001291a7824ULL, 0x000fe200078e020bULL, 0xfffffff81b2e7812ULL, 0x000fe200078ee216ULL,
0x000000ffff237224ULL, 0x000fe200030e0617ULL, 0x00000009241b7211ULL, 0x080fe200078e20ffULL,
0x0000000108177824ULL, 0x000fe200078e0225ULL, 0x00000009261d7211ULL, 0x010fe200078e20ffULL,
0x00000001251c7824ULL, 0x040fe200078e020bULL, 0x0000002831277810ULL, 0x000fe20007ffe0ffULL,
0x000000001e1b7faeULL, 0x0007e2000d101c46ULL, 0x0000000a2500720cULL, 0x0c0fe20003f46070ULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0x0000001803187210ULL, 0x000fe20007fde0ffULL,
0x00000000201d7faeULL, 0x0009e2000d901c46ULL, 0x0000000a2900720cULL, 0x000fe20003f66070ULL,
0x0000010017167825ULL, 0x000fe200078e0006ULL, 0x0000000329297819ULL, 0x000fc400000006ffULL,
0xfffffff8251c7812ULL, 0x000fe200078ee21cULL, 0x000000ffff197224ULL, 0x000fe200030e0619ULL,
0xfffffff8291a7812ULL, 0x000fe200078ee21aULL, 0x0000002c31297836ULL, 0x000fe20000000000ULL,
0x00000009281b7211ULL, 0x088fe200078e20ffULL, 0x00000030312b7836ULL, 0x000fe20000000000ULL,
0x000000092c1f7211ULL, 0x000fe200078e20ffULL, 0x000000102a1d7824ULL, 0x110fe200078e0209ULL,
0x0000001603167210ULL, 0x000fe20007fde0ffULL, 0x00000000121b7faeULL, 0x0007e2000c101c46ULL,
0x000000102e217824ULL, 0x100fe200078e0209ULL, 0x000000032b1e7819ULL, 0x000fe200000006ffULL,
0x000000101a257824ULL, 0x000fe200078e0209ULL, 0x00000000101d7faeULL, 0x0009e2000c901c46ULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x0000000a2700720cULL, 0x000fc40003fc6070ULL,
0x00000000141f7faeULL, 0x000be2000e901c46ULL, 0x0000000a2900720cULL, 0x080fe40003fa6070ULL,
0x0000000a2f00720cULL, 0x080fe20003f26070ULL, 0x0000000022217faeULL, 0x000fe2000e101c46ULL,
0x0000000108137824ULL, 0x048fe200078e0229ULL, 0x0000000a2b00720cULL, 0x080fe20003f86070ULL,
0x00000001081b7824ULL, 0x000fe200078e022bULL, 0x0000000b27107210ULL, 0x010fe20007ffe0ffULL,
0x0000000827117824ULL, 0x000fe200078e00ffULL, 0x0000000018257faeULL, 0x0007e2000d901c46ULL,
0x0000003c311d7836ULL, 0x000fe20000000000ULL, 0x0000000a2d00720cULL, 0x000fe20003f66070ULL,
0x000000012b157824ULL, 0x022fe200078e020bULL, 0xfffffff8111a7812ULL, 0x000fe200078ee210ULL,
0x0000010013127825ULL, 0x000fe200078e0006ULL, 0x0000002708117210ULL, 0x000fc40007ffe0ffULL,
0x0000000a1d00720cULL, 0x000fe20003f06070ULL, 0x00000001290a7824ULL, 0x040fe200078e020bULL,
0x0000000329297819ULL, 0x000fe200000006ffULL, 0x0000010011107825ULL, 0x000fe200078e0006ULL,
0xfffffff81e1e7812ULL, 0x000fc600078ee215ULL, 0x000000101c197824ULL, 0x008fe200078e0209ULL,
0xfffffff8291c7812ULL, 0x000fe200078ee20aULL, 0x000000012d0a7824ULL, 0x000fe400078e020bULL,
0x00000001081f7824ULL, 0x000fe200078e021dULL, 0x0000000016197faeULL, 0x0003e2000d101c46ULL,
0x0000001003147210ULL, 0x000fca0007f5e0ffULL, 0x000000ffff157224ULL, 0x000fe400010e0611ULL,
0x000001001b107825ULL, 0x000fe200078e0006ULL, 0x0000002f081b7210ULL, 0x000fe40007ffe0ffULL,
0x0000001203167210ULL, 0x002fe40007f5e0ffULL, 0x000000032d197819ULL, 0x000fe200000006ffULL,
0x00000001082d7824ULL, 0x000fe200078e022dULL, 0x0000000b2f087210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200010e0613ULL, 0x0000001003187210ULL, 0x000fe20007f5e0ffULL,
0x000001002d127825ULL, 0x000fe200078e0006ULL, 0xfffffff819207812ULL, 0x000fc600078ee20aULL,
0x000000ffff197224ULL, 0x000fe200010e0611ULL, 0x00000012030a7210ULL, 0x000fe20007f5e0ffULL,
0x000001001b107825ULL, 0x000fc800078e0006ULL, 0x000000011d127824ULL, 0x040fe200078e020bULL,
0x000000031d1d7819ULL, 0x000fe200000006ffULL, 0x000000082f2f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fe200010e0613ULL, 0x0000001003107210ULL, 0x000fe20007f5e0ffULL,
0x000001001f067825ULL, 0x000fe200078e0006ULL, 0xfffffff82f087812ULL, 0x000fe400078ee208ULL,
0xfffffff81d127812ULL, 0x000fe200078ee212ULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0x000000091a137211ULL, 0x080fe200078e20ffULL, 0x000000101c1b7824ULL, 0x100fe200078e0209ULL,
0x0000000603067210ULL, 0x000fe20007f5e0ffULL, 0x000000101e1d7824ULL, 0x100fe200078e0209ULL,
0x0000000920037211ULL, 0x000fe200078e20ffULL, 0x00000010081f7824ULL, 0x100fe200078e0209ULL,
0x00000007ff077210ULL, 0x000fe200017fe4ffULL, 0x0000001012097824ULL, 0x000fe200078e0209ULL,
0x0000000014137faeULL, 0x0005e8000f101c46ULL, 0x00000000161b7faeULL, 0x0005e8000e901c46ULL,
0x00000000181d7faeULL, 0x0005e8000e101c46ULL, 0x000000000a037faeULL, 0x0005e8000d901c46ULL,
0x00000000101f7faeULL, 0x0005e8000c901c46ULL, 0x0000000006097faeULL, 0x0005e2000c101c46ULL,
0x0000000800987947ULL, 0x000fea0003800000ULL, 0x000000100b197811ULL, 0x000fe200078fe8ffULL,
0x00004000432a7824ULL, 0x000fe200078e020cULL, 0x000000040b137811ULL, 0x040fe400078fe8ffULL,
0x000000080b157811ULL, 0x000fe200078fe8ffULL, 0x00000001190a7824ULL, 0x100fe200078e020bULL,
0x0000001c0b1f7811ULL, 0x000fe200078fe8ffULL, 0x00000008191b7824ULL, 0x000fe200078e00ffULL,
0x0000000b15077210ULL, 0x000fe20007ffe0ffULL, 0x0000000113067824ULL, 0x100fe200078e020bULL,
0x000000300b1e7811ULL, 0x000fe200078fe8ffULL, 0x0000000813117824ULL, 0x000fe200078e00ffULL,
0xfffffff81b327812ULL, 0x000fe200078ee20aULL, 0x00000008152e7824ULL, 0x000fe200078e00ffULL,
0x000000140b1b7811ULL, 0x000fe200078fe8ffULL, 0x000000011f107824ULL, 0x100fe200078e020bULL,
0x000000200b0a7811ULL, 0x000fe200078fe8ffULL, 0x0000000108277824ULL, 0x000fe200078e021eULL,
0xfffffff8112c7812ULL, 0x000fe200078ee206ULL, 0x000000081f117824ULL, 0x000fe200078e00ffULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee207ULL, 0x000000081b347824ULL, 0x000fe200078e00ffULL,
0x0000000c0b177811ULL, 0x000fe200078fe8ffULL, 0x000000080a217824ULL, 0x000fe200078e00ffULL,
0x0000000b1b077210ULL, 0x000fe20007ffe0ffULL, 0x000010002a4f7836ULL, 0x000fe20000000000ULL,
0x0000000b0a067210ULL, 0x000fe20007ffe0ffULL, 0x0000000117097824ULL, 0x000fe200078e020bULL,
0x000000240b127811ULL, 0x040fe200078fe8ffULL, 0x0000001032337824ULL, 0x000fe200078e024fULL,
0x000000280b167811ULL, 0x000fc400078fe8ffULL, 0xfffffff811387812ULL, 0x000fe200078ee210ULL,
0x000000011e117824ULL, 0x100fe200078e020bULL, 0xfffffff834347812ULL, 0x000fe200078ee207ULL,
0x0000000116077824ULL, 0x100fe200078e020bULL, 0xfffffff821107812ULL, 0x000fe200078ee206ULL,
0x0000000112067824ULL, 0x000fe200078e020bULL, 0x000000031e207819ULL, 0x000fe200000006ffULL,
0x0000000816187824ULL, 0x000fe200078e00ffULL, 0x0000000317307819ULL, 0x000fe200000006ffULL,
0x0000000108237824ULL, 0x000fe200078e0216ULL, 0x000000180b1d7811ULL, 0x000fe200078fe8ffULL,
0x0000001034357824ULL, 0x100fe200078e024fULL, 0x0000000312217819ULL, 0x000fe200000006ffULL,
0x0000001038397824ULL, 0x100fe200078e024fULL, 0xfffffff820207812ULL, 0x000fe200078ee211ULL,
0x00000010103b7824ULL, 0x000fe200078e024fULL, 0xfffffff830307812ULL, 0x000fe200078ee209ULL,
0x000000011d097824ULL, 0x000fe200078e020bULL, 0xfffffff821147812ULL, 0x000fe200078ee206ULL,
0x0000000108217824ULL, 0x000fe200078e0212ULL, 0xfffffff818187812ULL, 0x000fc400078ee207ULL,
0x0000000b0b117211ULL, 0x040fe200078fe8ffULL, 0x00008a00ff067b82ULL, 0x000ee20000000a00ULL,
0x0000002c0b1a7811ULL, 0x000fe200078fe8ffULL, 0x00000010183f7824ULL, 0x000fe200078e024fULL,
0x000000031d367819ULL, 0x000fe400000006ffULL, 0x0000000711287812ULL, 0x000fe200078ec0ffULL,
0x0000000113117824ULL, 0x100fe200078e0208ULL, 0xfffffff836367812ULL, 0x000fe200078ee209ULL,
0x000000081a1c7824ULL, 0x000fe200078e00ffULL, 0x0000000815137210ULL, 0x000fe20007ffe0ffULL,
0x0000000117157824ULL, 0x100fe200078e0208ULL, 0x0000000b1a097210ULL, 0x000fe20007ffe0ffULL,
0x0000000119177824ULL, 0x000fe200078e0208ULL, 0x000000340b227811ULL, 0x000fc400078fe8ffULL,
0x000000380b247811ULL, 0x040fe400078fe8ffULL, 0x0000003c0b267811ULL, 0x000fe200078fe8ffULL,
0x0000000108297824ULL, 0x040fe200078e0222ULL, 0x000000081b197210ULL, 0x000fe20007ffe0ffULL,
0x000000011d1b7824ULL, 0x100fe200078e0208ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL,
0x000000011f1d7824ULL, 0x000fe200078e0208ULL, 0x000000080b097211ULL, 0x000fe200078fe8ffULL,
0x00000001082b7824ULL, 0x040fe200078e0224ULL, 0x0000000a081f7210ULL, 0x000fe20007ffe0ffULL,
0x00000001084d7824ULL, 0x000fe200078e0226ULL, 0x0000001a08257210ULL, 0x000fe20007ffe0ffULL,
0x00000008222d7824ULL, 0x000fe200078e00ffULL, 0x0000000b220a7210ULL, 0x000fe20007ffe0ffULL,
0x00000008242f7824ULL, 0x000fe200078e00ffULL, 0x0000000b24127210ULL, 0x000fe20007ffe0ffULL,
0x000000101c457824ULL, 0x000fe200078e024fULL, 0x0ffffff828087812ULL, 0x000fe200078ef80bULL,
0x0000010011107825ULL, 0x008fe200078e0006ULL, 0x0000000b260b7210ULL, 0x000fc40007ffe0ffULL,
0xfffffff82d0a7812ULL, 0x000fe200078ee20aULL, 0x0000000826267824ULL, 0x000fe200078e00ffULL,
0xfffffff82f127812ULL, 0x000fe200078ee212ULL, 0x000000102c2d7824ULL, 0x100fe200078e024fULL,
0x0000004f08087211ULL, 0x080fe200078e20ffULL, 0x000000102e2f7824ULL, 0x100fe200078e024fULL,
0xfffffff8260b7812ULL, 0x000fe200078ee20bULL, 0x000000100a497824ULL, 0x100fe200078e024fULL,
0x0000004f30317211ULL, 0x080fe200078e20ffULL, 0x00000010124b7824ULL, 0x000fe200078e024fULL,
0x0000004f36377211ULL, 0x080fe200078e20ffULL, 0x0000010013127825ULL, 0x000fe200078e0006ULL,
0x0000004f143d7211ULL, 0x000fc400078e20ffULL, 0x0000004f20477211ULL, 0x080fe200078e20ffULL,
0x0000010015147825ULL, 0x100fe200078e0006ULL, 0x0000004f0b4f7211ULL, 0x000fe400078e20ffULL,
0x0000007003037812ULL, 0x000fe200078ec0ffULL, 0x00000100090a7825ULL, 0x000fc600078e0006ULL,
0x0000000310107210ULL, 0x000fe20007f3e0ffULL, 0x0000010017167825ULL, 0x100fe200078e0006ULL,
0x000000030a0a7210ULL, 0x000fe40007f1e0ffULL, 0x0000000312127210ULL, 0x000fe20007f5e0ffULL,
0x0000010019187825ULL, 0x100fe200078e0006ULL, 0x0000000314147210ULL, 0x000fe40007f7e0ffULL,
0x00000013ff137210ULL, 0x000fe200017fe4ffULL, 0x000001001b1a7825ULL, 0x000fc800078e0006ULL,
0x000001001d1c7825ULL, 0x000fe200078e0006ULL, 0x000000031a1a7210ULL, 0x000fc60007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x0000000316167210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x0000000318187210ULL, 0x000fe20007f3e0ffULL,
0x000001001f1e7825ULL, 0x100fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a087faeULL, 0x0007e4000b901c46ULL, 0x00000019ff197210ULL, 0x000fe20000ffe4ffULL,
0x0000010021207825ULL, 0x000fe200078e0006ULL, 0x00000000102d7faeULL, 0x0007e6000b901c46ULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0x000000031c1c7210ULL, 0x000fe20007f7e0ffULL,
0x0000010023227825ULL, 0x100fe200078e0006ULL, 0x0000000320207210ULL, 0x000fe20007f3e0ffULL,
0x00000000122f7faeULL, 0x0007e4000b901c46ULL, 0x0000010025247825ULL, 0x000fc400078e0006ULL,
0x0000000014317faeULL, 0x0007e4000b901c46ULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x000000031e1e7210ULL, 0x000fe20007f1e0ffULL, 0x0000010027267825ULL, 0x000fc600078e0006ULL,
0x0000001fff1f7210ULL, 0x000fe200007fe4ffULL, 0x0000010029287825ULL, 0x000fe200078e0006ULL,
0x0000000326267210ULL, 0x000fe20007f1e0ffULL, 0x0000000016337faeULL, 0x0007e4000b901c46ULL,
0x000000ffff1b7224ULL, 0x000fe200010e061bULL, 0x0000000322227210ULL, 0x000fe20007f5e0ffULL,
0x000001002b2a7825ULL, 0x000fe200078e0006ULL, 0x0000000018357faeULL, 0x0007e6000b901c46ULL,
0x000000ffff1d7224ULL, 0x000fe200018e061dULL, 0x0000000324247210ULL, 0x000fe20007f7e0ffULL,
0x000001004d067825ULL, 0x000fe200078e0006ULL, 0x000000001a377faeULL, 0x0007e4000b901c46ULL,
0x00000025ff257210ULL, 0x000fe20001ffe4ffULL, 0x000000ffff217224ULL, 0x000fe200008e0621ULL,
0x0000000328287210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff237224ULL, 0x000fe200010e0623ULL,
0x000000032a2a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff277224ULL, 0x000fe200000e0627ULL,
0x0000000306067210ULL, 0x000fe20007f7e0ffULL, 0x000000001c397faeULL, 0x0007e2000b901c46ULL,
0x000000ffff297224ULL, 0x000fe200008e0629ULL, 0x0000002bff2b7210ULL, 0x000fc400017fe4ffULL,
0x000000001e3b7faeULL, 0x0007e2000b901c46ULL, 0x000000ffff077224ULL, 0x000fc600018e0607ULL,
0x00000000203d7faeULL, 0x0007e8000b901c46ULL, 0x00000000223f7faeULL, 0x0007e8000b901c46ULL,
0x0000000024457faeULL, 0x0007e8000b901c46ULL, 0x0000000026477faeULL, 0x0007e8000b901c46ULL,
0x0000000028497faeULL, 0x0007e8000b901c46ULL, 0x000000002a4b7faeULL, 0x0007e8000b901c46ULL,
0x00000000064f7faeULL, 0x0007e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x00cfce0000015200ULL, 0x01b600050c0075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff0a7224ULL, 0x000fce00078e00ffULL,
0x000000100a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fce0000015200ULL, 0x0000000806087210ULL, 0x000fc80007f1e1ffULL,
0x0000000907097210ULL, 0x000fe400007fe5ffULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011409ULL,
0x0000000803037211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000203037819ULL, 0x000fc80000001208ULL, 0x000000030000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010a0a7836ULL, 0x000fce0000000000ULL,
0x01b600050c0075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000000d4100720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x0000000c43077211ULL, 0x040fe200078e18ffULL,
0xffffffff0d0a7836ULL, 0x000fe40000000000ULL, 0x0000002043057824ULL, 0x000fce00078e020cULL,
0x0000000241067211ULL, 0x000fc800078e40ffULL, 0x000000060f00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x004fea0003800000ULL, 0x0000000141047836ULL, 0x000fe20000000000ULL,
0x00008e0000047ab9ULL, 0x000fe40000000800ULL, 0x0000000400037c24ULL, 0x000fe4000f8e0206ULL,
0x0000000d0400720cULL, 0x000fda0003f06070ULL, 0x0000000800b08947ULL, 0x000fea0003800000ULL,
0x00000003ff257819ULL, 0x004fe20000011608ULL, 0x000000010f1a7824ULL, 0x000fe200078e0a06ULL,
0x0ffffff808617812ULL, 0x040fe200078ec0ffULL, 0x00008a0000087ab9ULL, 0x000fe20000000a00ULL,
0x0000000825157810ULL, 0x000fe20007ffe0ffULL, 0x0000000425137836ULL, 0x000fe20000000000ULL,
0x0000001425237810ULL, 0x000fe20007ffe0ffULL, 0x0000001c25297836ULL, 0x000fe20000000000ULL,
0x0000000c435f7211ULL, 0x000fe200078e70ffULL, 0x0000000113047824ULL, 0x140fe200078e0208ULL,
0x0000000313117819ULL, 0x000fe200000006ffULL, 0x0000000c25177836ULL, 0x000fe20000000000ULL,
0x0000000829107210ULL, 0x000fe20007ffe0ffULL, 0x0000000115097824ULL, 0x140fe200078e0208ULL,
0xfffffff811187812ULL, 0x000fe200078ee204ULL, 0x00000008151c7824ULL, 0x000fe200078e00ffULL,
0x00000008170b7210ULL, 0x000fe20007ffe0ffULL, 0x0000001025217836ULL, 0x000fe20000000000ULL,
0x0000000323227819ULL, 0x000fe200000006ffULL, 0x0000000829197824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL, 0x00000008171e7824ULL, 0x000fe200078e00ffULL,
0x0000000821047210ULL, 0x000fe20007ffe0ffULL, 0x0000000821117824ULL, 0x000fe200078e00ffULL,
0xfffffff819267812ULL, 0x000fe200078ee210ULL, 0x0000001825277836ULL, 0x000fe20000000000ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20bULL, 0x0000000123097824ULL, 0x100fe200078e0208ULL,
0xfffffff811207812ULL, 0x000fe200078ee204ULL, 0x0000000125107824ULL, 0x100fe200078e0208ULL,
0x00000020252b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001270b7824ULL, 0x040fe200078e0208ULL,
0xfffffff822227812ULL, 0x000fe200078ee209ULL, 0x0000000827247824ULL, 0x000fe200078e00ffULL,
0x0000000708047812ULL, 0x000fe200078ec0ffULL, 0x0000000125117824ULL, 0x140fe200078e0203ULL,
0x000030005f097810ULL, 0x000fe20007ffe0ffULL, 0x00000008ff787e24ULL, 0x000fe2000f8e00ffULL,
0x0000000761127812ULL, 0x000fe200078ef810ULL, 0x00000009ff797e24ULL, 0x000fe2000f8e00ffULL,
0x0000001a2500720cULL, 0x080fe20003f06070ULL, 0x000000082b1b7824ULL, 0x000fe200078e00ffULL,
0x0000001a1300720cULL, 0x040fe20003f26070ULL, 0x0000000113137824ULL, 0x000fe200078e0203ULL,
0xfffffff824247812ULL, 0x000fe200078ee20bULL, 0x0000010011107825ULL, 0x000fe200078e0078ULL,
0x00000008040b7812ULL, 0x000fc400078efcffULL, 0x0000001a1500720cULL, 0x0c0fe20003f46070ULL,
0x0000000115157824ULL, 0x000fe200078e0203ULL, 0x000000082b147210ULL, 0x000fe20007ffe0ffULL,
0x0000001012197824ULL, 0x000fe200078e0209ULL, 0x0000001a1700720cULL, 0x000fe20003f66070ULL,
0x0000010013127825ULL, 0x000fe200078e0078ULL, 0x0000000317177210ULL, 0x000fe40007ffe0ffULL,
0xfffffff81b287812ULL, 0x000fe200078ee214ULL, 0x000000100b107825ULL, 0x000fe200078e0010ULL,
0x000000091e1f7211ULL, 0x000fc400078e20ffULL, 0x0000001a2b00720cULL, 0x080fe20003f86070ULL,
0x0000010015147825ULL, 0x100fe200078e0078ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010197faeULL, 0x0005e2000c101c46ULL, 0x0000001a2100720cULL, 0x000fe40003f06070ULL,
0x0000010017167825ULL, 0x000fc800078e0078ULL, 0x00000010181b7824ULL, 0x000fe400078e0209ULL,
0x000000100b127825ULL, 0x000fc800078e0012ULL, 0x000000101c1d7824ULL, 0x000fe200078e0209ULL,
0x00000000121b7faeULL, 0x0007e2000c901c46ULL, 0x000000100b147825ULL, 0x000fe200078e0014ULL,
0x0000001a2300720cULL, 0x000fc60003f26070ULL, 0x0000000121217824ULL, 0x000fe200078e0203ULL,
0x00000000141d7faeULL, 0x0009e2000d101c46ULL, 0x000000100b167825ULL, 0x000fe200078e0016ULL,
0x0000001a2700720cULL, 0x000fc60003f46070ULL, 0x0000000123197824ULL, 0x004fe200078e0203ULL,
0x0000000327237210ULL, 0x000fe20007ffe0ffULL, 0x0000010021107825ULL, 0x000fe200078e0078ULL,
0x00000000161f7faeULL, 0x0005e2000d901c46ULL, 0x0000001a2900720cULL, 0x040fe40003f66070ULL,
0x00000001291b7824ULL, 0x008fe200078e0203ULL, 0x000000032b1d7210ULL, 0x010fe20007ffe0ffULL,
0x0000010019127825ULL, 0x000fe200078e0078ULL, 0x00000034252b7810ULL, 0x000fc60007ffe0ffULL,
0x0000010023147825ULL, 0x100fe200078e0078ULL, 0x0000002825237810ULL, 0x000fe40007ffe0ffULL,
0x00000009261f7211ULL, 0x004fe200078e20ffULL, 0x000001001b167825ULL, 0x000fc800078e0078ULL,
0x0000001020217824ULL, 0x000fe200078e0209ULL, 0x0000000323207819ULL, 0x000fe200000006ffULL,
0x000000100b107825ULL, 0x000fc800078e0010ULL, 0x000001001d187825ULL, 0x000fe200078e0078ULL,
0x0000000010217faeULL, 0x0005e6000c101c46ULL, 0x00000010221b7824ULL, 0x000fe400078e0209ULL,
0x000000100b127825ULL, 0x000fc800078e0012ULL, 0x00000010241d7824ULL, 0x000fe200078e0209ULL,
0x00000000121b7faeULL, 0x0007e2000c901c46ULL, 0x000000100b147825ULL, 0x000fe200078e0014ULL,
0x0000001a2300720cULL, 0x000fc60003f26070ULL, 0x000000100b167825ULL, 0x040fe200078e0016ULL,
0x00000000141d7faeULL, 0x0009e6000d101c46ULL, 0x0000001028117824ULL, 0x004fe200078e0209ULL,
0x00000000161f7faeULL, 0x0005e2000d901c46ULL, 0x000000100b187825ULL, 0x000fc800078e0018ULL,
0x0000002425217836ULL, 0x000fe20000000000ULL, 0x0000000018117faeULL, 0x000be2000e101c46ULL,
0x0000002c25277836ULL, 0x000fe20000000000ULL, 0x0000001a2b00720cULL, 0x080fe20003f86070ULL,
0x0000000821137824ULL, 0x048fe200078e00ffULL, 0x0000000821107210ULL, 0x000fe20007ffe0ffULL,
0x0000003025297836ULL, 0x000fe20000000000ULL, 0x0000001a2100720cULL, 0x080fe20003f06070ULL,
0x0000000127127824ULL, 0x140fe200078e0208ULL, 0xfffffff8131e7812ULL, 0x000fe200078ee210ULL,
0x0000000827157824ULL, 0x010fe200078e00ffULL, 0x0000001a2900720cULL, 0x080fe20003f66070ULL,
0x00000038252d7836ULL, 0x000fe20000000000ULL, 0x0000000329177210ULL, 0x004fe20007ffe0ffULL,
0x0000000123117824ULL, 0x122fe200078e0208ULL, 0xfffffff815227812ULL, 0x000fe200078ee212ULL,
0x0000003c25257836ULL, 0x000fe20000000000ULL, 0x0000001a2d00720cULL, 0x080fe20003fa6070ULL,
0x0000000129107824ULL, 0x140fe200078e0208ULL, 0xfffffff820207812ULL, 0x000fe200078ee211ULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0x000000032b197210ULL, 0x000fe20007ffe0ffULL,
0x000000012b127824ULL, 0x100fe200078e0208ULL, 0x000000032d1b7210ULL, 0x000fe20007ffe0ffULL,
0x000000012d147824ULL, 0x100fe200078e0208ULL, 0x0000000321117210ULL, 0x000fe20007ffe0ffULL,
0x000000082b2b7824ULL, 0x000fe200078e00ffULL, 0x00000003251d7210ULL, 0x000fe20007ffe0ffULL,
0x000000082d2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff829247812ULL, 0x000fe200078ee210ULL,
0x0000000123137824ULL, 0x100fe200078e0203ULL, 0x0000001a2700720cULL, 0x0c0fe20003f46070ULL,
0x0000000127157824ULL, 0x000fe200078e0203ULL, 0x0000001a2500720cULL, 0x040fe20003fc6070ULL,
0x0000000125037824ULL, 0x040fe200078e0208ULL, 0xfffffff82b267812ULL, 0x000fe200078ee212ULL,
0x00000008252a7824ULL, 0x000fe200078e00ffULL, 0xfffffff82d287812ULL, 0x000fe200078ee214ULL,
0x0000010011107825ULL, 0x000fe200078e0078ULL, 0x0000000924217211ULL, 0x000fc400078e20ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee203ULL, 0x0000010013127825ULL, 0x100fe200078e0078ULL,
0x000000091e037211ULL, 0x080fe400078e20ffULL, 0x000000092a277211ULL, 0x000fe200078e20ffULL,
0x0000010015147825ULL, 0x000fc800078e0078ULL, 0x0000010017167825ULL, 0x000fc800078e0078ULL,
0x0000010019187825ULL, 0x000fc800078e0078ULL, 0x000001001b1a7825ULL, 0x000fc800078e0078ULL,
0x000001001d1c7825ULL, 0x000fc800078e0078ULL, 0x000000100b107825ULL, 0x000fc800078e0010ULL,
0x00000010201f7824ULL, 0x000fe200078e0209ULL, 0x0000000010037faeULL, 0x0003e2000c101c46ULL,
0x000000100b127825ULL, 0x000fc800078e0012ULL, 0x000000100b147825ULL, 0x040fe200078e0014ULL,
0x00000000121f7faeULL, 0x0003e6000c901c46ULL, 0x000000100b167825ULL, 0x000fc800078e0016ULL,
0x000000100b187825ULL, 0x000fc800078e0018ULL, 0x000000100b1a7825ULL, 0x000fc800078e001aULL,
0x000000100b1c7825ULL, 0x000fc800078e001cULL, 0x00000010220b7824ULL, 0x100fe400078e0209ULL,
0x0000001026237824ULL, 0x100fe400078e0209ULL, 0x0000001028257824ULL, 0x000fe200078e0209ULL,
0x00000000140b7faeULL, 0x0003e8000d101c46ULL, 0x0000000016217faeULL, 0x0003e8000d901c46ULL,
0x0000000018237faeULL, 0x0003e8000e101c46ULL, 0x000000001a257faeULL, 0x0003e8000e901c46ULL,
0x000000001c277faeULL, 0x0003e2000f101c46ULL, 0x00000008005c7947ULL, 0x000fea0003800000ULL,
0x0000000c08157811ULL, 0x044fe200078fe8ffULL, 0x00008a00ff787b82ULL, 0x000ea20000000a00ULL,
0x00000004080b7811ULL, 0x040fe200078fe8ffULL, 0x00004000435f7824ULL, 0x000fe200078e020cULL,
0x0000000808137811ULL, 0x040fe200078fe8ffULL, 0x0000000115447824ULL, 0x140fe200078e0208ULL,
0x0000000315177819ULL, 0x000fe200000006ffULL, 0x000000010b467824ULL, 0x140fe200078e0208ULL,
0x00000018081b7811ULL, 0x040fe200078fe8ffULL, 0x000000080b097824ULL, 0x000fe200078e00ffULL,
0x0000001c081d7811ULL, 0x040fe200078fe8ffULL, 0x0000000813117824ULL, 0x000fe200078e00ffULL,
0xfffffff817447812ULL, 0x000fe200078ee244ULL, 0x000000011b3c7824ULL, 0x100fe200078e0208ULL,
0x0000001008177811ULL, 0x040fe200078fe8ffULL, 0x000000011d3a7824ULL, 0x140fe200078e0208ULL,
0x0000000813427210ULL, 0x000fe20007ffe0ffULL, 0x000000081d217824ULL, 0x000fe200078e00ffULL,
0x0000001408197811ULL, 0x040fe200078fe8ffULL, 0x0000000117407824ULL, 0x000fe200078e0208ULL,
0x000000031b1f7819ULL, 0x000fe200000006ffULL, 0x0000000113137824ULL, 0x100fe200078e0203ULL,
0xfffffff809467812ULL, 0x000fe200078ee246ULL, 0x0000000817097824ULL, 0x000fe200078e00ffULL,
0xfffffff811427812ULL, 0x000fe200078ee242ULL, 0x0000000819117824ULL, 0x000fe200078e00ffULL,
0xfffffff81f3c7812ULL, 0x000fe200078ee23cULL, 0x0000000115157824ULL, 0x100fe200078e0203ULL,
0xfffffff8213a7812ULL, 0x000fe200078ee23aULL, 0x000000011b1b7824ULL, 0x000fe200078e0203ULL,
0x00000020081f7811ULL, 0x000fc400078fe8ffULL, 0x0000002408217811ULL, 0x040fe200078fe8ffULL,
0x000001001b1a7825ULL, 0x004fe200078e0078ULL, 0x00000008193e7210ULL, 0x000fe40007ffe0ffULL,
0xfffffff809407812ULL, 0x000fe200078ee240ULL, 0x000000081f097824ULL, 0x000fe200078e00ffULL,
0xfffffff8113e7812ULL, 0x000fe200078ee23eULL, 0x0000000121367824ULL, 0x000fe200078e0208ULL,
0x0000002c08277811ULL, 0x040fe200078fe8ffULL, 0x0000000119197824ULL, 0x100fe200078e0203ULL,
0x000000081f387210ULL, 0x000fe20007ffe0ffULL, 0x000000011f1f7824ULL, 0x100fe200078e0203ULL,
0x0000000321117819ULL, 0x000fe200000006ffULL, 0x0000000827297824ULL, 0x000fe200078e00ffULL,
0xfffffff809387812ULL, 0x000fe200078ee238ULL, 0x0000000121217824ULL, 0x000fe200078e0203ULL,
0xfffffff811367812ULL, 0x000fe200078ee236ULL, 0x000001001f1e7825ULL, 0x000fe200078e0078ULL,
0x0000002808237811ULL, 0x000fc400078fe8ffULL, 0x00000008272c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000127277824ULL, 0x000fe200078e0203ULL, 0x0000000808107211ULL, 0x040fe200078fe8ffULL,
0x0000000123327824ULL, 0x040fe200078e0208ULL, 0x0ffffff808617812ULL, 0x040fe200078ec0ffULL,
0x0000000823257824ULL, 0x000fe200078e00ffULL, 0x0000000308117211ULL, 0x040fe200078fe8ffULL,
0x0000010021207825ULL, 0x000fe200078e0078ULL, 0x0000003008097811ULL, 0x040fe400078fe8ffULL,
0x0000000708047812ULL, 0x000fc400078ec0ffULL, 0xfffffff8292c7812ULL, 0x000fe200078ee22cULL,
0x0000000109297824ULL, 0x040fe200078e0203ULL, 0x0000000761127812ULL, 0x000fe200078ef810ULL,
0x0000000809337824ULL, 0x000fe200078e00ffULL, 0x0000003408147811ULL, 0x040fe200078fe8ffULL,
0x0000010011107825ULL, 0x000fe200078e0078ULL, 0x0000003808167811ULL, 0x040fe400078fe8ffULL,
0x0000000809487210ULL, 0x000fe20007ffe0ffULL, 0x000030005f097836ULL, 0x000fe20000000000ULL,
0x0000003c08187811ULL, 0x000fe200078fe8ffULL, 0x00000001142b7824ULL, 0x100fe200078e0203ULL,
0x00000008042f7812ULL, 0x000fe200078efcffULL, 0x00000001162d7824ULL, 0x000fe200078e0203ULL,
0xfffffff825327812ULL, 0x000fe200078ee232ULL, 0x0000000814357824ULL, 0x000fe200078e00ffULL,
0x000000030b0b7210ULL, 0x000fe20007ffe0ffULL, 0x000000102f247825ULL, 0x000fe200078e0010ULL,
0x0000000317177210ULL, 0x000fc40007ffe0ffULL, 0x000000031d1d7210ULL, 0x000fe20007ffe0ffULL,
0x000001000b107825ULL, 0x000fe200078e0078ULL, 0x0000000323237210ULL, 0x000fe40007ffe0ffULL,
0x0000000318317210ULL, 0x000fe20007ffe0ffULL, 0x0000000816377824ULL, 0x000fe200078e00ffULL,
0x0000000912037211ULL, 0x000fe200078e20ffULL, 0x00000001182e7824ULL, 0x040fe200078e0208ULL,
0x00000008144a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000818397824ULL, 0x000fe200078e00ffULL,
0x0000000816347210ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024037faeULL, 0x0005e2000b901c46ULL, 0x0000010013127825ULL, 0x000fe200078e0078ULL,
0xfffffff833487812ULL, 0x000fc400078ee248ULL, 0xfffffff8354a7812ULL, 0x000fe200078ee24aULL,
0x0000010015147825ULL, 0x100fe200078e0078ULL, 0xfffffff837347812ULL, 0x000fe400078ee234ULL,
0x000000093c357211ULL, 0x080fe200078e20ffULL, 0x0000010017167825ULL, 0x100fe200078e0078ULL,
0xfffffff8392e7812ULL, 0x000fe400078ee22eULL, 0x00000009363b7211ULL, 0x000fe200078e20ffULL,
0x0000010027247825ULL, 0x004fc800078e0078ULL, 0x0000010029267825ULL, 0x000fc800078e0078ULL,
0x000001002b287825ULL, 0x000fc800078e0078ULL, 0x0000010019187825ULL, 0x000fc800078e0078ULL,
0x000001001d1c7825ULL, 0x000fc800078e0078ULL, 0x0000010023227825ULL, 0x000fc800078e0078ULL,
0x000001002d2a7825ULL, 0x000fe200078e0078ULL, 0x00000009442d7211ULL, 0x000fc600078e20ffULL,
0x0000010031307825ULL, 0x000fc800078e0078ULL, 0x000000102f107825ULL, 0x000fc800078e0010ULL,
0x0000001046037824ULL, 0x000fe400078e0209ULL, 0x000000102f127825ULL, 0x000fc600078e0012ULL,
0x0000000010037faeULL, 0x000fe2000b901c46ULL, 0x00000010420b7824ULL, 0x000fe400078e0209ULL,
0x000000102f147825ULL, 0x000fc600078e0014ULL, 0x00000000120b7faeULL, 0x0005e2000b901c46ULL,
0x000000102f167825ULL, 0x000fc600078e0016ULL, 0x00000000142d7faeULL, 0x0007e2000b901c46ULL,
0x000000102f187825ULL, 0x000fc800078e0018ULL, 0x000000102f1a7825ULL, 0x000fe200078e001aULL,
0x00000009480b7211ULL, 0x004fc600078e20ffULL, 0x000000102f1c7825ULL, 0x000fe200078e001cULL,
0x000000092e157211ULL, 0x008fc600078e20ffULL, 0x000000102f1e7825ULL, 0x000fc800078e001eULL,
0x000000102f207825ULL, 0x000fc800078e0020ULL, 0x000000102f227825ULL, 0x000fc800078e0022ULL,
0x000000102f247825ULL, 0x000fc800078e0024ULL, 0x000000102f267825ULL, 0x000fc800078e0026ULL,
0x000000102f287825ULL, 0x000fc800078e0028ULL, 0x000000102f2a7825ULL, 0x000fc800078e002aULL,
0x000000102f307825ULL, 0x000fc800078e0030ULL, 0x00000010402f7824ULL, 0x100fe400078e0209ULL,
0x000000103e337824ULL, 0x100fe400078e0209ULL, 0x000000103a377824ULL, 0x100fe200078e0209ULL,
0x00000000162f7faeULL, 0x0007e2000b901c46ULL, 0x0000001038397824ULL, 0x100fe400078e0209ULL,
0x00000010323d7824ULL, 0x100fe200078e0209ULL, 0x0000000018337faeULL, 0x0007e2000b901c46ULL,
0x000000102c037824ULL, 0x000fc400078e0209ULL, 0x000000104a117824ULL, 0x100fe200078e0209ULL,
0x000000001a357faeULL, 0x0007e2000b901c46ULL, 0x0000001034137824ULL, 0x000fc600078e0209ULL,
0x000000001c377faeULL, 0x0007e8000b901c46ULL, 0x000000001e397faeULL, 0x0007e8000b901c46ULL,
0x00000000203b7faeULL, 0x0007e8000b901c46ULL, 0x00000000223d7faeULL, 0x0007e8000b901c46ULL,
0x0000000024037faeULL, 0x0007e8000b901c46ULL, 0x00000000260b7faeULL, 0x0007e8000b901c46ULL,
0x0000000028117faeULL, 0x0007e8000b901c46ULL, 0x000000002a137faeULL, 0x0007e8000b901c46ULL,
0x0000000030157faeULL, 0x0007e4000b901c46ULL, 0x00000004ff107819ULL, 0x102fe20000011608ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000003ff037819ULL, 0x008fe40000011608ULL,
0x00000008040b7812ULL, 0x000fe200078ef808ULL, 0x0000000810117824ULL, 0x040fe200078e00ffULL,
0x0000000103137812ULL, 0x000fe400078ec0ffULL, 0x000010005f5f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001105d7824ULL, 0x000fe200078e020bULL, 0xfffffff8113c7812ULL, 0x000fc400078ee204ULL,
0x000000040b107819ULL, 0x000fe400000006ffULL, 0x000000303c387810ULL, 0x000fe20007ffe0ffULL,
0x00000001133b7824ULL, 0x000fe200078e023cULL, 0xfffffff010117812ULL, 0x000fe200078ee25dULL,
0x000000083c767824ULL, 0x000fe200078e00ffULL, 0x000000040b197819ULL, 0x000fe200000006ffULL,
0x000000103c3a7836ULL, 0x000fe20000000000ULL, 0x000000023b6e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001011117824ULL, 0x000fe200078e020cULL, 0xfffffff876767812ULL, 0x000fe200078ee23bULL,
0x0000000113747824ULL, 0x000fe200078e023aULL, 0x000000223b687810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000001076147824ULL, 0x000fe200078e025fULL,
0x000000001128783bULL, 0x0003e20000000200ULL, 0x000000203c397836ULL, 0x000fe20000000000ULL,
0x000000323b667810ULL, 0x000fe20007ffe0ffULL, 0x000000025d107836ULL, 0x000fe20000000000ULL,
0x00000003383f7819ULL, 0x000fe200000006ffULL, 0x000000001414783bULL, 0x000ea20000000200ULL,
0x0000000113727824ULL, 0x040fe200078e0239ULL, 0x000000043b6a7810ULL, 0x000fe20007ffe0ffULL,
0x000000083c1b7824ULL, 0x000fe200078e00ffULL, 0x000000033a117819ULL, 0x002fe200000006ffULL,
0x0000000113707824ULL, 0x000fe200078e0238ULL, 0xfffffff019197812ULL, 0x000fe200078ee210ULL,
0x000000123b6c7836ULL, 0x000fe20000000000ULL, 0xfffffff811747812ULL, 0x000fe200078ee274ULL,
0x0000000839117824ULL, 0x000fe200078e00ffULL, 0xfffffff81b6e7812ULL, 0x000fe200078ee26eULL,
0x0000001019197824ULL, 0x000fe200078e020cULL, 0x000000243b627810ULL, 0x000fe20007ffe0ffULL,
0x0000001074347824ULL, 0x100fe200078e025fULL, 0xfffffff811727812ULL, 0x000fe200078ee272ULL,
0x00000008383d7824ULL, 0x040fe200078e00ffULL, 0x0000000338117819ULL, 0x000fe200000006ffULL,
0x000000001920783bULL, 0x0003e20000000200ULL, 0x0000005f6e547211ULL, 0x000fe200078e20ffULL,
0x0000001072307824ULL, 0x100fe200078e025fULL, 0xfffffff811707812ULL, 0x000fe200078ee270ULL,
0x000000003434783bULL, 0x000ee20000000200ULL, 0x000000033a117819ULL, 0x000fe200000006ffULL,
0x000000343b607836ULL, 0x000fe20000000000ULL, 0xfffffff83d667812ULL, 0x000fe200078ee266ULL,
0x00000010702c7824ULL, 0x100fe200078e025fULL, 0x000000005454783bULL, 0x000f220000000200ULL,
0xfffffff8116c7812ULL, 0x000fe200078ee26cULL, 0x0000000839197824ULL, 0x042fe200078e00ffULL,
0xfffffff83f607812ULL, 0x000fe200078ee260ULL, 0x000000003030783bULL, 0x000e620000000200ULL,
0x00000008393d7824ULL, 0x040fe200078e00ffULL, 0x000000063b5e7810ULL, 0x000fe20007ffe0ffULL,
0x000000106c107824ULL, 0x100fe200078e025fULL, 0x000000002c2c783bULL, 0x000f620000000200ULL,
0xfffffff819687812ULL, 0x000fe200078ee268ULL, 0x0000001060447824ULL, 0x100fe200078e025fULL,
0xfffffff83d627812ULL, 0x000fe200078ee262ULL, 0x000000143b647836ULL, 0x000fe20000000000ULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x000000142824723cULL, 0x004fe200000018ffULL,
0x0000001068187824ULL, 0x100fe200078e025fULL, 0x000000363b407810ULL, 0x000fe20007ffe0ffULL,
0x000000004444783bULL, 0x000fe20000000200ULL, 0x0000001062487824ULL, 0x000fe200078e025fULL,
0x000000163b5c7810ULL, 0x000fe20007ffe0ffULL, 0x000000162814723cULL, 0x000fe200000018ffULL,
0x000000001818783bULL, 0x000ea20000000200ULL, 0x0000000839397824ULL, 0x000fc400078e00ffULL,
0x000000263b427836ULL, 0x000fe20000000000ULL, 0x000000004848783bULL, 0x000fe80000000200ULL,
0xfffffff839427812ULL, 0x000fe200078ee242ULL, 0x000000342850723cULL, 0x008fec00000018ffULL,
0x000000362834723cULL, 0x000fec00000018ffULL, 0x000000542024723cULL, 0x010fec0000001824ULL,
0x000000562054723cULL, 0x000fec0000001814ULL, 0x000000302814723cULL, 0x002fec00000018ffULL,
0x0000002c281c723cULL, 0x020fec00000018ffULL, 0x000000322830723cULL, 0x000fe200000018ffULL,
0x00000010662c7824ULL, 0x000fca00078e025fULL, 0x0000002e2828723cULL, 0x000fe200000018ffULL,
0x000000002c2c783bULL, 0x000e6a0000000200ULL, 0x000000102050723cULL, 0x000fec0000001850ULL,
0x000000122010723cULL, 0x000fec0000001834ULL, 0x000000182014723cULL, 0x004fe20000001814ULL,
0x000000045d347836ULL, 0x000fe20000000000ULL, 0x000000040b357819ULL, 0x000fe200000006ffULL,
0x000000083a377824ULL, 0x000fc600078e00ffULL, 0xfffffff035357812ULL, 0x000fe200078ee234ULL,
0x000000083c197824ULL, 0x000fe200078e00ffULL, 0xfffffff837647812ULL, 0x000fc600078ee264ULL,
0x0000001035357824ULL, 0x000fe200078e020cULL, 0xfffffff8196a7812ULL, 0x000fe400078ee26aULL,
0x0000001a2018723cULL, 0x000fe20000001830ULL, 0x0000005f644c7211ULL, 0x000fe400078e20ffULL,
0x000000106a587824ULL, 0x000fc800078e025fULL, 0x000000083c337824ULL, 0x000fe200078e00ffULL,
0x000000065d307810ULL, 0x000fe20007ffe0ffULL, 0x00000000353c783bULL, 0x000ea20000000200ULL,
0x000000100b317824ULL, 0x000fe200078e00ffULL, 0x0000002c201c723cULL, 0x002fe2000000181cULL,
0xfffffff8335e7812ULL, 0x000fe200078ee25eULL, 0x0000000838337824ULL, 0x000fe200078e00ffULL,
0x000000004c4c783bULL, 0x000e620000000200ULL, 0xfffffff031317812ULL, 0x000fe200078ee230ULL,
0x0000001042307824ULL, 0x000fe200078e025fULL, 0x0000002e2020723cULL, 0x000fe20000001828ULL,
0xfffffff833407812ULL, 0x000fe200078ee240ULL, 0x000000083a2d7824ULL, 0x000fe200078e00ffULL,
0x000000005858783bULL, 0x000ee20000000200ULL, 0x0000001031637824ULL, 0x000fc400078e020cULL,
0x00000010402c7824ULL, 0x100fe200078e025fULL, 0xfffffff82d5c7812ULL, 0x000fe200078ee25cULL,
0x000000105e387824ULL, 0x000fe200078e025fULL, 0x000000006328783bULL, 0x0009e40000000200ULL,
0x0000005f5c347211ULL, 0x000fe400078e20ffULL, 0x000000002c2c783bULL, 0x000f680000000200ULL,
0x000000003434783bULL, 0x000f620000000200ULL, 0x000000410e637210ULL, 0x010fc60007ffe0ffULL,
0x000000003838783bULL, 0x000f280000000200ULL, 0x000000003030783bULL, 0x000f220000000200ULL,
0x000000443c1c723cULL, 0x004fec000000181cULL, 0x000000463c20723cULL, 0x000fec0000001820ULL,
0x0000004c3c50723cULL, 0x002fec0000001850ULL, 0x000000583c24723cULL, 0x008fec0000001824ULL,
0x0000005a3c54723cULL, 0x000fec0000001854ULL, 0x0000004e3c10723cULL, 0x000fec0000001810ULL,
0x000000483c14723cULL, 0x000fec0000001814ULL, 0x0000004a3c18723cULL, 0x000fec0000001818ULL,
0x0000002c281c723cULL, 0x020fec000000181cULL, 0x0000002e282c723cULL, 0x000fec0000001820ULL,
0x000000342850723cULL, 0x000fe20000001850ULL, 0x0000000163207836ULL, 0x000fc40000000000ULL,
0x0000010063217824ULL, 0x000fc600078e0202ULL, 0x0000000d2000720cULL, 0x000fe20003f06070ULL,
0x000000382824723cULL, 0x010fe20000001824ULL, 0x0000000400347c24ULL, 0x000fca000f8e0221ULL,
0x0000003a2854723cULL, 0x000fec0000001854ULL, 0x000000362810723cULL, 0x000fec0000001810ULL,
0x000000302814723cULL, 0x000fec0000001814ULL, 0x000000322818723cULL, 0x000fe20000001818ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000800d88947ULL, 0x000fde0003800000ULL,
0x0000000403297810ULL, 0x000fe20007ffe0ffULL, 0x00000014033f7836ULL, 0x000fe20000000000ULL,
0x0000000c03317810ULL, 0x000fe20007ffe0ffULL, 0x00000008032b7836ULL, 0x000fe20000000000ULL,
0x0000000329237819ULL, 0x040fe200000006ffULL, 0x0000000129367824ULL, 0x100fe200078e0208ULL,
0x000000210f3a7248ULL, 0x000fe20007fe0000ULL, 0x00000001314e7824ULL, 0x100fe200078e0208ULL,
0x000000083f4a7210ULL, 0x000fe20007ffe0ffULL, 0x000000083f357824ULL, 0x000fe200078e00ffULL,
0xfffffff823367812ULL, 0x000fe200078ee236ULL, 0x000000013a3a7824ULL, 0x000fe200078e0a21ULL,
0x0000000331237819ULL, 0x000fe200000006ffULL, 0x000000082b217824ULL, 0x000fe200078e00ffULL,
0xfffffff8354a7812ULL, 0x000fe200078ee24aULL, 0x0000001008357824ULL, 0x000fe200078e00ffULL,
0xfffffff8234e7812ULL, 0x000fe200078ee24eULL, 0x0000001803377836ULL, 0x000fe20000000000ULL,
0x0000003403237210ULL, 0x000fe20007ffe0ffULL, 0x0000001003457836ULL, 0x000fe20000000000ULL,
0x000000082b387210ULL, 0x000fe20007ffe0ffULL, 0x0000000137487824ULL, 0x000fe200078e0208ULL,
0x0000007035357812ULL, 0x000fe200078ec0ffULL, 0x0000010023227825ULL, 0x000fe200078e0078ULL,
0xfffffff821387812ULL, 0x000fc400078ee238ULL, 0x0000003a2900720cULL, 0x0c0fe20003f26070ULL,
0x0000000129217824ULL, 0x000fe200078e0234ULL, 0x0000002235287210ULL, 0x000fe20007f1e0ffULL,
0x0000000837297824ULL, 0x000fe200078e00ffULL, 0x0000001c03397810ULL, 0x000fe20007ffe0ffULL,
0x00000001454c7824ULL, 0x000fe200078e0208ULL, 0x0000003a0300720cULL, 0x000fe20003f66070ULL,
0x0000000845337824ULL, 0x000fe200078e00ffULL, 0xfffffff829487812ULL, 0x000fe200078ee248ULL,
0x0000010021207825ULL, 0x000fe200078e0078ULL, 0x00000008393c7210ULL, 0x000fc40007ffe0ffULL,
0xfffffff8334c7812ULL, 0x000fe200078ee24cULL, 0x000000ffff297224ULL, 0x000fe200000e0623ULL,
0x0000003a2b00720cULL, 0x000fe20003f06070ULL, 0x0000000839337824ULL, 0x000fe200078e00ffULL,
0x000000342b2b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000131237824ULL, 0x000fe200078e0234ULL,
0x0000002035327210ULL, 0x000fe20007f5e0ffULL, 0x00000020033d7836ULL, 0x000fe20000000000ULL,
0xfffffff8333c7812ULL, 0x000fe200078ee23cULL, 0x000001002b2a7825ULL, 0x000fe200078e0078ULL,
0x00000021ff337210ULL, 0x000fc400017fe4ffULL, 0x0000003a3100720cULL, 0x080fe20003f46070ULL,
0x00000024033b7836ULL, 0x000fe20000000000ULL, 0x0000003a4500720cULL, 0x000fe20003fa6070ULL,
0x0000010023227825ULL, 0x000fe200078e0078ULL, 0x000000083d3e7210ULL, 0x000fe40007ffe0ffULL,
0x0000002a35307210ULL, 0x000fe20007f9e0ffULL, 0x0000000103467824ULL, 0x000fe200078e0208ULL,
0x00000022352a7210ULL, 0x000fe20007fde0ffULL, 0x000000083d317824ULL, 0x000fe400078e00ffULL,
0x0000000145217824ULL, 0x000fe200078e0234ULL, 0x000000033b457819ULL, 0x040fe200000006ffULL,
0x000000013b447824ULL, 0x000fe200078e0208ULL, 0x0000000761467812ULL, 0x000fe200078ef846ULL,
0x0000010021207825ULL, 0x000fe200078e0078ULL, 0xfffffff8313e7812ULL, 0x000fc400078ee23eULL,
0xfffffff845447812ULL, 0x000fe200078ee244ULL, 0x000000ffff317224ULL, 0x000fe200020e062bULL,
0x0000005f46457211ULL, 0x000fe200078e20ffULL, 0x000000ffff2b7224ULL, 0x000fe200030e0623ULL,
0x0000002035207210ULL, 0x000fe20007fde0ffULL, 0x000000013f237824ULL, 0x040fe200078e0234ULL,
0x0000003a3f00720cULL, 0x080fe20003f86070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028457faeULL, 0x0003e2000d901c46ULL, 0x0000003a3700720cULL, 0x000fe20003f66070ULL,
0x0000010023227825ULL, 0x000fe200078e0078ULL, 0x00000028033f7810ULL, 0x000fc60007ffe0ffULL,
0x0000000137377824ULL, 0x000fe200078e0234ULL, 0x000000033f497819ULL, 0x000fe200000006ffULL,
0x000000ffff217224ULL, 0x000fe200030e0621ULL, 0x0000002235227210ULL, 0x000fe20007fde0ffULL,
0x0000001036477824ULL, 0x000fe400078e025fULL, 0x0000010037367825ULL, 0x000fe200078e0078ULL,
0x0000005f38457211ULL, 0x002fe400078e20ffULL, 0x0000000032477faeULL, 0x0003e2000c901c46ULL,
0x000000013f467824ULL, 0x000fe200078e0208ULL, 0x0000003a3900720cULL, 0x0c0fe20003f26070ULL,
0x000000ffff237224ULL, 0x000fe200030e0623ULL, 0x0000003635287210ULL, 0x000fe20007fde0ffULL,
0x0000000139397824ULL, 0x000fe200078e0234ULL, 0xfffffff849467812ULL, 0x000fe200078ee246ULL,
0x0000000030457faeULL, 0x0005e2000c101c46ULL, 0x0000002c03497810ULL, 0x000fe20007ffe0ffULL,
0x0000010039387825ULL, 0x000fe200078e0078ULL, 0x0000003a3d00720cULL, 0x000fc40003f06070ULL,
0x0000000349587819ULL, 0x000fe200000006ffULL, 0x000000ffff297224ULL, 0x000fe200030e0637ULL,
0x0000003835327210ULL, 0x002fe20007fde0ffULL, 0x000000013d377824ULL, 0x000fe200078e0234ULL,
0x0000003003477810ULL, 0x000fe20007ffe0ffULL, 0x0000000149337824ULL, 0x000fe400078e0208ULL,
0x0000010037367825ULL, 0x000fe200078e0078ULL, 0x0000005f4c457211ULL, 0x004fe400078e20ffULL,
0x00000003474c7819ULL, 0x000fe200000006ffULL, 0x000000104e3d7824ULL, 0x000fe200078e025fULL,
0xfffffff8584e7812ULL, 0x000fe200078ee233ULL, 0x000000ffff337224ULL, 0x000fe200030e0639ULL,
0x0000003635307210ULL, 0x000fe20007fde0ffULL, 0x000000013b397824ULL, 0x040fe200078e0234ULL,
0x000000002a3d7faeULL, 0x0003e2000d101c46ULL, 0x0000003a3b00720cULL, 0x000fe20003f46070ULL,
0x000000104a3b7824ULL, 0x000fc400078e025fULL, 0x0000010039387825ULL, 0x000fe200078e0078ULL,
0x0000000020457faeULL, 0x0005e2000e901c46ULL, 0x0000003a3f00720cULL, 0x040fe40003fa6070ULL,
0x000000ffff317224ULL, 0x000fe200030e0637ULL, 0x00000000223b7faeULL, 0x0007e2000e101c46ULL,
0x000000013f377824ULL, 0x000fe200078e0234ULL, 0x00000034033f7810ULL, 0x000fe20007ffe0ffULL,
0x00000001472b7824ULL, 0x002fe200078e0208ULL, 0x00000038352a7210ULL, 0x000fe20007fde0ffULL,
0x0000010037367825ULL, 0x000fe200078e0078ULL, 0x0000005f483d7211ULL, 0x000fc400078e20ffULL,
0xfffffff84c4a7812ULL, 0x000fe200078ee22bULL, 0x000000ffff2b7224ULL, 0x000fe200030e0639ULL,
0x0000003635207210ULL, 0x004fe20007fde0ffULL, 0x0000000149397824ULL, 0x000fe200078e0234ULL,
0x000000033f487819ULL, 0x040fe200000006ffULL, 0x000000013f237824ULL, 0x008fe200078e0208ULL,
0x00000000283d7faeULL, 0x0003e2000d901c46ULL, 0x0000010039387825ULL, 0x000fe200078e0078ULL,
0x0000003a4900720cULL, 0x080fe40003f86070ULL, 0x0000003a4700720cULL, 0x040fe20003f66070ULL,
0x000000ffff217224ULL, 0x000fe200030e0637ULL, 0x0000003835227210ULL, 0x000fe20007fde0ffULL,
0x0000000147377824ULL, 0x000fe200078e0234ULL, 0xfffffff848387812ULL, 0x000fe200078ee223ULL,
0x000000103c3b7824ULL, 0x000fc400078e025fULL, 0x0000010037367825ULL, 0x000fe200078e0078ULL,
0x0000005f3e3d7211ULL, 0x082fe400078e20ffULL, 0x00000000323b7faeULL, 0x0003e2000c901c46ULL,
0x000000ffff237224ULL, 0x000fe200030e0639ULL, 0x0000003635287210ULL, 0x000fe20007fde0ffULL,
0x000000013f397824ULL, 0x040fe200078e0234ULL, 0x0000003a3f00720cULL, 0x000fe20003f26070ULL,
0x0000003803457836ULL, 0x000fe20000000000ULL, 0x0000005f443f7211ULL, 0x000fe200078e20ffULL,
0x000000ffff297224ULL, 0x000fe200030e0637ULL, 0x00000000303d7faeULL, 0x0005e2000c101c46ULL,
0x0000010039367825ULL, 0x000fe200078e0078ULL, 0x0000003445397210ULL, 0x000fc40007ffe0ffULL,
0x000000002a3f7faeULL, 0x0007e2000d101c46ULL, 0x0000003c033b7836ULL, 0x002fe20000000000ULL,
0x0000003635327210ULL, 0x000fe20007fde0ffULL, 0x0000000145367824ULL, 0x040fe200078e0208ULL,
0x0000003a4500720cULL, 0x0c0fe40003f46070ULL, 0x0000000345457819ULL, 0x000fe200000006ffULL,
0x000000ffff337224ULL, 0x000fe200030e0637ULL, 0x0000003a3b00720cULL, 0x000fe20003f06070ULL,
0x0000010039307825ULL, 0x004fe200078e0078ULL, 0xfffffff845367812ULL, 0x000fc400078ee236ULL,
0x0000005f4e397211ULL, 0x080fe200078e20ffULL, 0x000000013b377824ULL, 0x040fe200078e0234ULL,
0x000000033b347819ULL, 0x040fe200000006ffULL, 0x000000013b2b7824ULL, 0x008fe200078e0208ULL,
0x00000030352a7210ULL, 0x000fe20007fde0ffULL, 0x0000010037787825ULL, 0x000fe200078e0078ULL,
0x0000005f363d7211ULL, 0x000fe400078e20ffULL, 0xfffffff834347812ULL, 0x000fe200078ee22bULL,
0x000000ffff2b7224ULL, 0x000fe200030e0631ULL, 0x0000007835307210ULL, 0x000fe20007fde0ffULL,
0x0000001046377824ULL, 0x000fc400078e025fULL, 0x000000104a3b7824ULL, 0x100fe400078e025fULL,
0x0000001038357824ULL, 0x100fe200078e025fULL, 0x0000000020377faeULL, 0x0003e2000e901c46ULL,
0x00000010345f7824ULL, 0x000fe400078e025fULL, 0x000000ffff317224ULL, 0x000fe200030e0679ULL,
0x0000000022397faeULL, 0x0003e8000e101c46ULL, 0x00000000283b7faeULL, 0x0003e8000d901c46ULL,
0x0000000032357faeULL, 0x0003e8000c901c46ULL, 0x000000002a3d7faeULL, 0x0003e8000d101c46ULL,
0x00000000305f7faeULL, 0x0003e2000c101c46ULL, 0x00000008008c7947ULL, 0x000fea0003800000ULL,
0x0000000403237810ULL, 0x000fe20007ffe0ffULL, 0x0000000803297836ULL, 0x000fe20000000000ULL,
0x00000028034b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001c03377836ULL, 0x000fe20000000000ULL,
0x0000000323207819ULL, 0x040fe200000006ffULL, 0x0000000123697824ULL, 0x100fe200078e0208ULL,
0x00000010033d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000129677824ULL, 0x100fe200078e0208ULL,
0x000000084b4a7210ULL, 0x000fe20007ffe0ffULL, 0x0000001803397836ULL, 0x000fe20000000000ULL,
0xfffffff820697812ULL, 0x000fe200078ee269ULL, 0x0000000137587824ULL, 0x100fe200078e0208ULL,
0x0000000329207819ULL, 0x000fe200000006ffULL, 0x0000000837217824ULL, 0x000fe200078e00ffULL,
0x0000002003357810ULL, 0x000fe20007ffe0ffULL, 0x0000002403317836ULL, 0x000fe20000000000ULL,
0xfffffff820677812ULL, 0x000fe200078ee267ULL, 0x00000030036b7836ULL, 0x000fe20000000000ULL,
0x0000000339207819ULL, 0x040fe200000006ffULL, 0x0000000139597824ULL, 0x000fe200078e0208ULL,
0xfffffff821587812ULL, 0x000fe200078ee258ULL, 0x0000001008497824ULL, 0x000fe200078e00ffULL,
0x0000000331337819ULL, 0x000fe200000006ffULL, 0x0000000103217824ULL, 0x000fe200078e0234ULL,
0xfffffff820597812ULL, 0x000fe200078ee259ULL, 0x0000002c034d7836ULL, 0x000fe20000000000ULL,
0x0000007049497812ULL, 0x000fe200078ec0ffULL, 0x00000001314e7824ULL, 0x100fe200078e0208ULL,
0x00000008354f7210ULL, 0x000fe20007ffe0ffULL, 0x000000016b487824ULL, 0x000fe200078e0208ULL,
0x000000034d3f7819ULL, 0x000fe200000006ffULL, 0x000000086b457824ULL, 0x000fe200078e00ffULL,
0xfffffff8334e7812ULL, 0x000fe200078ee24eULL, 0x0000010021207825ULL, 0x000fe200078e0078ULL,
0x0000003c03717810ULL, 0x000fc40007ffe0ffULL, 0xfffffff845487812ULL, 0x000fe200078ee248ULL,
0x000000014d4c7824ULL, 0x100fe200078e0208ULL, 0x0000002049327210ULL, 0x000fe20007f1e0ffULL,
0x0000000103227824ULL, 0x000fe200078e0208ULL, 0x0000005f67677211ULL, 0x000fe200078e20ffULL,
0x0000000c032b7836ULL, 0x000fe20000000000ULL, 0xfffffff83f4c7812ULL, 0x000fe200078ee24cULL,
0x0000000123477824ULL, 0x100fe200078e0234ULL, 0x0000000761227812ULL, 0x000fe200078ef822ULL,
0x000000084b337824ULL, 0x000fe200078e00ffULL, 0x000000342b3f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000129457824ULL, 0x000fe200078e0234ULL, 0x000000083d617210ULL, 0x000fe20007ffe0ffULL,
0x0000010047467825ULL, 0x000fe200078e0078ULL, 0xfffffff8334a7812ULL, 0x000fc400078ee24aULL,
0x00000021ff337210ULL, 0x000fe200007fe4ffULL, 0x00000014033b7836ULL, 0x000fe20000000000ULL,
0x0000004649467210ULL, 0x000fe20007f1e0ffULL, 0x000000083d2a7824ULL, 0x000fe200078e00ffULL,
0x0000003439217210ULL, 0x000fe20007ffe0ffULL, 0x0000010045447825ULL, 0x000fe200078e0078ULL,
0x000000033b307819ULL, 0x000fe400000006ffULL, 0xfffffff82a617812ULL, 0x000fe200078ee261ULL,
0x000000013d3d7824ULL, 0x000fe200078e0234ULL, 0x0000004449447210ULL, 0x000fe20007f3e0ffULL,
0x000001003f3e7825ULL, 0x000fe200078e0078ULL, 0x0000005f4c4c7211ULL, 0x000fc400078e20ffULL,
0x00000045ff457210ULL, 0x000fe20000ffe4ffULL, 0x000000012b657824ULL, 0x140fe400078e0208ULL,
0x000000082b287824ULL, 0x000fe200078e00ffULL, 0x00000034312b7210ULL, 0x000fe20007ffe0ffULL,
0x000000013b5b7824ULL, 0x000fe400078e0208ULL, 0x000001003d3c7825ULL, 0x000fe200078e0078ULL,
0xfffffff828657812ULL, 0x000fe400078ee265ULL, 0xfffffff8305b7812ULL, 0x000fe200078ee25bULL,
0x000000013b3b7824ULL, 0x000fe200078e0234ULL, 0x0000003c493c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff477224ULL, 0x000fe200000e0647ULL, 0x0000003e493e7210ULL, 0x000fe20007f1e0ffULL,
0x000001003b3a7825ULL, 0x000fe200078e0078ULL, 0x0000005f5b5b7211ULL, 0x000fc600078e20ffULL,
0x0000000835287824ULL, 0x000fe400078e00ffULL, 0x0000000137237824ULL, 0x000fe400078e0234ULL,
0x0000010021207825ULL, 0x000fe200078e0078ULL, 0xfffffff8284f7812ULL, 0x000fc600078ee24fULL,
0x0000000135297824ULL, 0x000fe200078e0234ULL, 0x000000346b357210ULL, 0x000fe20007ffe0ffULL,
0x00000010226b7824ULL, 0x000fe200078e025fULL, 0x0000005f4f4f7211ULL, 0x000fe200078e20ffULL,
0x000000ffff3f7224ULL, 0x000fe200000e063fULL, 0x0000003a493a7210ULL, 0x000fe20007f1e0ffULL,
0x0000010023227825ULL, 0x000fe200078e0078ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000326b7faeULL, 0x0003e4000b901c46ULL, 0x0000003bff3b7210ULL, 0x000fe200007fe4ffULL,
0x000000ffff3d7224ULL, 0x000fe200008e063dULL, 0x0000002049207210ULL, 0x000fe20007f3e0ffULL,
0x0000010029287825ULL, 0x000fe200078e0078ULL, 0x0000002249227210ULL, 0x000fc60007f1e0ffULL,
0x000000014b317824ULL, 0x000fe400078e0234ULL, 0x000001002b2a7825ULL, 0x000fc800078e0078ULL,
0x000000ffff217224ULL, 0x000fe200008e0621ULL, 0x0000002849287210ULL, 0x000fe20007f3e0ffULL,
0x0000010031307825ULL, 0x000fc600078e0078ULL, 0x00000029ff297210ULL, 0x000fe20000ffe4ffULL,
0x00000034036d7836ULL, 0x000fe20000000000ULL, 0x0000003049307210ULL, 0x000fe20007f3e0ffULL,
0x00000038036f7836ULL, 0x000fe40000000000ULL, 0x000000014d4d7824ULL, 0x100fe400078e0234ULL,
0x000000ffff237224ULL, 0x000fe200000e0623ULL, 0x0000002a492a7210ULL, 0x000fe20007f1e0ffULL,
0x000000016d377824ULL, 0x100fe400078e0234ULL, 0x000000016f397824ULL, 0x000fc400078e0234ULL,
0x00000001714b7824ULL, 0x000fe400078e0234ULL, 0x000001004d327825ULL, 0x002fc800078e0078ULL,
0x0000010035347825ULL, 0x000fc800078e0078ULL, 0x0000001069697824ULL, 0x000fe400078e025fULL,
0x000000ffff2b7224ULL, 0x000fe200000e062bULL, 0x0000003249327210ULL, 0x000fe20007f1e0ffULL,
0x000000016d7c7824ULL, 0x040fe200078e0208ULL, 0x000000036d6d7819ULL, 0x000fe200000006ffULL,
0x0000010037367825ULL, 0x000fe200078e0078ULL, 0x0000000046697faeULL, 0x0003e2000b901c46ULL,
0x00000033ff337210ULL, 0x000fe400007fe4ffULL, 0x0000001065657824ULL, 0x000fe200078e025fULL,
0x0000000044677faeULL, 0x0003e2000b901c46ULL, 0x000000ffff317224ULL, 0x000fe200008e0631ULL,
0x0000003449347210ULL, 0x000fe20007f3e0ffULL, 0x0000010039387825ULL, 0x000fe200078e0078ULL,
0xfffffff86d7c7812ULL, 0x000fe200078ee27cULL, 0x000000003e657faeULL, 0x0003e2000b901c46ULL,
0x0000003649367210ULL, 0x000fe20007f1e0ffULL, 0x0000001061617824ULL, 0x000fc400078e025fULL,
0x000000016f7a7824ULL, 0x140fe200078e0208ULL, 0x000000036f6f7819ULL, 0x000fe200000006ffULL,
0x00000001715a7824ULL, 0x040fe200078e0208ULL, 0x0000000371717819ULL, 0x000fe200000006ffULL,
0x000001004b787825ULL, 0x000fe200078e0078ULL, 0x000000003c617faeULL, 0x0003e2000b901c46ULL,
0xfffffff86f7a7812ULL, 0x000fe400078ee27aULL, 0x0000001059597824ULL, 0x100fe200078e025fULL,
0xfffffff8715a7812ULL, 0x000fe200078ee25aULL, 0x0000001058587824ULL, 0x100fe200078e025fULL,
0x0000007849787210ULL, 0x000fe20007f5e0ffULL, 0x000000104e4e7824ULL, 0x000fe200078e025fULL,
0x000000003a5b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff357224ULL, 0x000fe200008e0635ULL,
0x0000003849387210ULL, 0x000fe20007f3e0ffULL, 0x000000104a4d7824ULL, 0x100fe200078e025fULL,
0x0000000020597faeULL, 0x0003e2000b901c46ULL, 0x00000010484b7824ULL, 0x100fe200078e025fULL,
0x0000005f7a487211ULL, 0x000fe200078e20ffULL, 0x000000107c4a7824ULL, 0x000fe200078e025fULL,
0x0000000022587faeULL, 0x0003e2000b901c46ULL, 0x000000ffff377224ULL, 0x000fe200000e0637ULL,
0x00000039ff397210ULL, 0x000fe20000ffe4ffULL, 0x000000105a5f7824ULL, 0x000fe200078e025fULL,
0x00000000284f7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff797224ULL, 0x000fc600010e0679ULL,
0x000000002a4e7faeULL, 0x0003e8000b901c46ULL, 0x00000000304d7faeULL, 0x0003e8000b901c46ULL,
0x00000000324c7faeULL, 0x0003e8000b901c46ULL, 0x00000000344b7faeULL, 0x0003e8000b901c46ULL,
0x00000000364a7faeULL, 0x0003e8000b901c46ULL, 0x0000000038487faeULL, 0x0003e8000b901c46ULL,
0x00000000785f7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000085d207836ULL, 0x002fe20000000000ULL, 0x000000040b217819ULL, 0x040fe200000006ffULL,
0x00000010763c7824ULL, 0x100fe200078e0209ULL, 0x0000000974447211ULL, 0x080fe200078e20ffULL,
0x0000001070307824ULL, 0x100fe200078e0209ULL, 0xfffffff021217812ULL, 0x000fe200078ee220ULL,
0x000000100b297824ULL, 0x000fe200078e00ffULL, 0x0000000a5d287810ULL, 0x000fe20007ffe0ffULL,
0x0000001072207824ULL, 0x100fe200078e0209ULL, 0x000000096a6a7211ULL, 0x080fe200078e20ffULL,
0x0000001021387824ULL, 0x000fe200078e020cULL, 0xfffffff029297812ULL, 0x000fe200078ee228ULL,
0x000000106e347824ULL, 0x100fe200078e0209ULL, 0x0000000960587211ULL, 0x000fe200078e20ffULL,
0x0000001068687824ULL, 0x000fe200078e0209ULL, 0x0000000c29297211ULL, 0x000fe200078e20ffULL,
0x000000100b487824ULL, 0x000fc400078e00ffULL, 0x000000105e4c7824ULL, 0x000fe200078e0209ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000003c3c783bULL, 0x000fe80000000200ULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000004444783bULL, 0x000ea80000000200ULL,
0x000000003030783bULL, 0x000ee80000000200ULL, 0x000000002020783bULL, 0x000f280000000200ULL,
0x000000003434783bULL, 0x000fe80000000200ULL, 0x000000002928783bULL, 0x000f680000000200ULL,
0x000000005858783bULL, 0x000fe80000000200ULL, 0x000000004c4c783bULL, 0x000fe20000000200ULL,
0x0000003c3824723cULL, 0x002fec0000001824ULL, 0x0000003e3854723cULL, 0x000fe20000001854ULL,
0x000000106c3c7824ULL, 0x000fca00078e0209ULL, 0x000000443850723cULL, 0x004fe20000001850ULL,
0x000000003c3c783bULL, 0x000e6a0000000200ULL, 0x00000030381c723cULL, 0x008fe2000000181cULL,
0x000000100b447824ULL, 0x000fca00078e00ffULL, 0x000000203814723cULL, 0x010fe20000001814ULL,
0x0000000c5d317810ULL, 0x000fe20007ffe0ffULL, 0x0000001066307824ULL, 0x000fe200078e0209ULL,
0x0000000e5d5d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff044457812ULL, 0x000fe200078ee231ULL,
0x000000463810723cULL, 0x000fe20000001810ULL, 0xfffffff0485d7812ULL, 0x000fc600078ee25dULL,
0x0000001045457824ULL, 0x100fe400078e020cULL, 0x000000223820723cULL, 0x000fe20000001818ULL,
0x000000105d487824ULL, 0x000fe200078e020cULL, 0x000000006818783bULL, 0x000ea80000000200ULL,
0x00000032382c723cULL, 0x000fe2000000182cULL, 0x000000004544783bULL, 0x000fe80000000200ULL,
0x000000003030783bULL, 0x000ee20000000200ULL, 0x000000342838723cULL, 0x020fe60000001824ULL,
0x000000006a24783bULL, 0x000f260000000200ULL, 0x0000003c2850723cULL, 0x002fe20000001850ULL,
0x0000001064347824ULL, 0x100fe200078e0209ULL, 0x000000004848783bULL, 0x000fe80000000200ULL,
0x000000362854723cULL, 0x000fe20000001854ULL, 0x00000010623c7824ULL, 0x000fe200078e0209ULL,
0x000000003434783bULL, 0x000e680000000200ULL, 0x0000003e2810723cULL, 0x000fe20000001810ULL,
0x000000003c3c783bULL, 0x000f6a0000000200ULL, 0x000000182814723cULL, 0x004fec0000001814ULL,
0x0000001a2820723cULL, 0x000fe20000001820ULL, 0x000000095c187211ULL, 0x000fca00078e20ffULL,
0x00000032282c723cULL, 0x008fe2000000182cULL, 0x000000001818783bULL, 0x000fea0000000200ULL,
0x000000244438723cULL, 0x010fec0000001838ULL, 0x00000030281c723cULL, 0x000fe2000000181cULL,
0x0000001040247824ULL, 0x000fca00078e0209ULL, 0x000000264454723cULL, 0x000fe20000001854ULL,
0x0000001042287824ULL, 0x000fe200078e0209ULL, 0x000000002424783bULL, 0x000ea80000000200ULL,
0x0000005a442c723cULL, 0x000fe2000000182cULL, 0x000000002828783bULL, 0x000eea0000000200ULL,
0x000000344450723cULL, 0x002fec0000001850ULL, 0x000000364410723cULL, 0x000fec0000001810ULL,
0x0000003c4414723cULL, 0x020fec0000001814ULL, 0x0000003e4420723cULL, 0x000fec0000001820ULL,
0x00000058441c723cULL, 0x000fec000000181cULL, 0x00000026482c723cULL, 0x004fec000000182cULL,
0x0000004c4838723cULL, 0x000fe20000001838ULL, 0x0000000100267802ULL, 0x000fca0000000f00ULL,
0x0000004e4854723cULL, 0x000fe20000001854ULL, 0x01b68826072679a7ULL, 0x000e6a000850003fULL,
0x000000184850723cULL, 0x000fec0000001850ULL, 0x0000001a4810723cULL, 0x000fe20000001810ULL,
0x3db504f32c2c7820ULL, 0x000fe20000410000ULL, 0x3db504f32d2d7820ULL, 0x000fe20000410000ULL,
0x3db504f32e2e7820ULL, 0x000fe20000410000ULL, 0x3db504f32f2f7820ULL, 0x000fc40000410000ULL,
0x000000284814723cULL, 0x008fe20000001814ULL, 0x3db504f3380b7820ULL, 0x000fe20000410000ULL,
0x3db504f339397820ULL, 0x000fe20000410000ULL, 0x3db504f33a3a7820ULL, 0x000fe20000410000ULL,
0x3db504f33b3b7820ULL, 0x000fe40000410000ULL, 0x0000002a4820723cULL, 0x000fe20000001820ULL,
0x3db504f354547820ULL, 0x000fe20000410000ULL, 0x3db504f355557820ULL, 0x000fe20000410000ULL,
0x3db504f356567820ULL, 0x000fe20000410000ULL, 0x3db504f357577820ULL, 0x000fc40000410000ULL,
0x00000024481c723cULL, 0x000fe2000000181cULL, 0x3db504f350507820ULL, 0x000fe20000410000ULL,
0x3db504f351517820ULL, 0x000fe20000410000ULL, 0x3db504f352527820ULL, 0x000fe20000410000ULL,
0x3db504f353537820ULL, 0x000fe40000410000ULL, 0x3db504f3101a7820ULL, 0x000fe20000410000ULL,
0x3db504f311257820ULL, 0x000fe20000410000ULL, 0x3db504f312247820ULL, 0x000fe20000410000ULL,
0x3db504f3131b7820ULL, 0x000fc60000410000ULL, 0x3db504f314147820ULL, 0x000fe20000410000ULL,
0x3db504f315157820ULL, 0x000fe20000410000ULL, 0x3db504f316197820ULL, 0x000fe20000410000ULL,
0x3db504f317187820ULL, 0x000fc60000410000ULL, 0x3db504f320207820ULL, 0x000fe20000410000ULL,
0x3db504f321217820ULL, 0x000fe20000410000ULL, 0x3db504f322227820ULL, 0x000fe20000410000ULL,
0x3db504f323237820ULL, 0x000fc60000410000ULL, 0x3db504f31c1c7820ULL, 0x000fe20000410000ULL,
0x3db504f31d1d7820ULL, 0x000fe20000410000ULL, 0x3db504f31e1e7820ULL, 0x000fe20000410000ULL,
0x3db504f31f1f7820ULL, 0x000fe20000410000ULL, 0x0000000000107805ULL, 0x000fe20000015200ULL,
0x01b68827070075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff167224ULL, 0x000fce00078e00ffULL, 0x000000101600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210127210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011413ULL, 0x0000001209097211ULL, 0x000fc800078110ffULL,
0x00000013ff127210ULL, 0x000fc800007fe4ffULL, 0x0000000209097819ULL, 0x000fc80000001212ULL,
0x000000090000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000116167836ULL, 0x000fce0000000000ULL, 0x01b68827070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000408097824ULL, 0x000fe200078e00ffULL,
0x0000000c43107211ULL, 0x000fe400078e38ffULL, 0x0000000a4100720cULL, 0x000fe40003f05270ULL,
0xfffffff009097812ULL, 0x000fca00078ec0ffULL, 0x0000000110097824ULL, 0x000fca00078e0209ULL,
0x01b4000009107984ULL, 0x0002a20000000c00ULL, 0x0000000400080947ULL, 0x000fea0003800000ULL,
0x0000000108167819ULL, 0x000fe200000006ffULL, 0x000000010f277824ULL, 0x000fc600078e0a06ULL,
0x0000000616167812ULL, 0x000fc800078ec0ffULL, 0x0000000116067812ULL, 0x040fe400078efcffULL,
0x0000000816177812ULL, 0x000fe400078efcffULL, 0x000000270600720cULL, 0x080fe40003f26070ULL,
0x0000001016067812ULL, 0x000fe400078efcffULL, 0x000000271700720cULL, 0x080fe40003f06070ULL,
0x000000270600720cULL, 0x000fc40003fc6070ULL, 0x0000001116177812ULL, 0x040fe400078efcffULL,
0x0000001816067812ULL, 0x040fe400078efcffULL, 0x000000271600720cULL, 0x080fe40003f46070ULL,
0x000000271700720cULL, 0x080fe40003fa6070ULL, 0x000000270600720cULL, 0x000fe40003f66070ULL,
0x0000000916267812ULL, 0x000fc400078efcffULL, 0x0000001916177812ULL, 0x040fe400078efcffULL,
0x0000002016067812ULL, 0x000fe400078efcffULL, 0xff8000003a3a7808ULL, 0x000fe40005000000ULL,
0xff8000000b0b7808ULL, 0x000fe40005000000ULL, 0xff8000003b3b7808ULL, 0x000fe40004800000ULL,
0xff80000039397808ULL, 0x000fc40004800000ULL, 0x000000272600720cULL, 0x080fe40003f86070ULL,
0x000000271700720cULL, 0x080fe40003f46070ULL, 0x000000270600720cULL, 0x000fe40003f26070ULL,
0x0000002116177812ULL, 0x040fe400078efcffULL, 0x0000002816067812ULL, 0x000fe400078efcffULL,
0xff80000056567808ULL, 0x000fc40004000000ULL, 0xff80000054547808ULL, 0x000fe40004000000ULL,
0xff80000057577808ULL, 0x000fe40006000000ULL, 0xff80000055557808ULL, 0x000fe40006000000ULL,
0x000000271700720cULL, 0x080fe40003f06070ULL, 0x000000270600720cULL, 0x000fe40003f86070ULL,
0x0000002916177812ULL, 0x000fc400078efcffULL, 0x0000003016067812ULL, 0x000fe400078efcffULL,
0xff80000052527808ULL, 0x000fe40007000000ULL, 0xff80000050507808ULL, 0x000fe40007000000ULL,
0xff80000053537808ULL, 0x000fe40006800000ULL, 0xff80000051517808ULL, 0x000fe40006800000ULL,
0x000000271700720cULL, 0x000fc40003fc6070ULL, 0x000000270600720cULL, 0x000fe40003fa6070ULL,
0x0000003116177812ULL, 0x040fe400078efcffULL, 0x0000003816067812ULL, 0x040fe400078efcffULL,
0x0000003916167812ULL, 0x000fe400078efcffULL, 0xff80000024247808ULL, 0x000fe40005800000ULL,
0xff8000001a1a7808ULL, 0x000fc40005800000ULL, 0xff8000001b1b7808ULL, 0x000fe40005000000ULL,
0xff80000025257808ULL, 0x000fe40005000000ULL, 0xff80000019197808ULL, 0x000fe40004800000ULL,
0xff80000014147808ULL, 0x000fe40004800000ULL, 0x000000271700720cULL, 0x080fe40003f66070ULL,
0x000000270600720cULL, 0x000fc40003f46070ULL, 0x000000271600720cULL, 0x000fe40003f26070ULL,
0xff80000018187808ULL, 0x000fe40004000000ULL, 0xff80000015157808ULL, 0x000fe40004000000ULL,
0xff80000022227808ULL, 0x000fe40006000000ULL, 0xff80000020207808ULL, 0x000fe40006000000ULL,
0xff80000023237808ULL, 0x000fc40007000000ULL, 0xff80000021217808ULL, 0x000fe40007000000ULL,
0xff8000001e1e7808ULL, 0x000fe40006800000ULL, 0xff8000001c1c7808ULL, 0x000fe40006800000ULL,
0xff8000001f1f7808ULL, 0x000fe40005800000ULL, 0xff8000001d1d7808ULL, 0x000fe40005800000ULL,
0xff8000002e2e7808ULL, 0x000fc40005000000ULL, 0xff8000002c2c7808ULL, 0x000fe40005000000ULL,
0xff8000002f2f7808ULL, 0x000fe40004800000ULL, 0xff8000002d2d7808ULL, 0x000fce0004800000ULL,
0x0000000b1000720bULL, 0x004fe20003f1e000ULL, 0x3c003c00ff297424ULL, 0x000fe200078e00ffULL,
0x3c003c0000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff417224ULL, 0x000fe200078e0063ULL,
0x000000100b107208ULL, 0x000fe40004000000ULL, 0xfffffff8ff047812ULL, 0x000fe400078ee204ULL,
0x000000391000720bULL, 0x000fc80003f1e000ULL, 0x0000001039177208ULL, 0x000fc80004000000ULL,
0x000000541700720bULL, 0x000fc80003f1e000ULL, 0x0000001754067208ULL, 0x000fc80004000000ULL,
0x000000550600720bULL, 0x000fc80003f1e000ULL, 0x0000000655177208ULL, 0x000fc80004000000ULL,
0x000000501700720bULL, 0x000fc80003f1e000ULL, 0x0000001750067208ULL, 0x000fc80004000000ULL,
0x000000510600720bULL, 0x000fc80003f1e000ULL, 0x0000000651177208ULL, 0x000fc80004000000ULL,
0x0000001a1700720bULL, 0x000fc80003f1e000ULL, 0x000000171a067208ULL, 0x000fc80004000000ULL,
0x000000250600720bULL, 0x000fc80003f1e000ULL, 0x0000000625177208ULL, 0x000fc80004000000ULL,
0x000000141700720bULL, 0x000fc80003f1e000ULL, 0x0000001714067208ULL, 0x000fc80004000000ULL,
0x000000150600720bULL, 0x000fc80003f1e000ULL, 0x0000000615177208ULL, 0x000fc80004000000ULL,
0x000000201700720bULL, 0x000fc80003f1e000ULL, 0x0000001720067208ULL, 0x000fe40004000000ULL,
0x0000003a1100720bULL, 0x000fe40003f1e000ULL, 0x000000210600720bULL, 0x000fc80003f3e000ULL,
0x0000000621177208ULL, 0x000fe40004800000ULL, 0x000000113a067208ULL, 0x000fe40004000000ULL,
0x0000001c1700720bULL, 0x000fe40003f3e000ULL, 0x0000003b0600720bULL, 0x000fe40003f1e000ULL,
0x000000171c107208ULL, 0x000fe40004800000ULL, 0x000000063b117208ULL, 0x000fc40004000000ULL,
0x0000001d1000720bULL, 0x000fe40003f3e000ULL, 0x000000561100720bULL, 0x000fe40003f1e000ULL,
0x000000101d177208ULL, 0x000fe40004800000ULL, 0x0000001156067208ULL, 0x000fe40004000000ULL,
0x0000002c1700720bULL, 0x000fe40003f3e000ULL, 0x000000570600720bULL, 0x000fc40003f1e000ULL,
0x000000172c107208ULL, 0x000fe40004800000ULL, 0x0000000657117208ULL, 0x000fe40004000000ULL,
0x0000002d1000720bULL, 0x000fe40003f3e000ULL, 0x000000521100720bULL, 0x000fe40003f1e000ULL,
0x000000102d107208ULL, 0x000fe40004800000ULL, 0x0000001152067208ULL, 0x000fc60004000000ULL,
0x0c401f0010177f89ULL, 0x000ea200000e0000ULL, 0x000000530600720bULL, 0x000fc80003f1e000ULL,
0x0000000653117208ULL, 0x000fc80004000000ULL, 0x000000241100720bULL, 0x000fc80003f1e000ULL,
0x0000001124067208ULL, 0x000fc80004000000ULL, 0x0000001b0600720bULL, 0x000fc80003f1e000ULL,
0x000000061b067208ULL, 0x000fe40004000000ULL, 0x000000171000720bULL, 0x004fe40003f3e000ULL,
0x000000190600720bULL, 0x000fe40003f1e000ULL, 0x0000001017177208ULL, 0x000fe40004800000ULL,
0x0000000619117208ULL, 0x000fc60004000000ULL, 0x0c201f0017107f89ULL, 0x000ea200000e0000ULL,
0x000000181100720bULL, 0x000fc80003f1e000ULL, 0x0000001118117208ULL, 0x000fc80004000000ULL,
0x000000221100720bULL, 0x000fc80003f1e000ULL, 0x0000001122067208ULL, 0x000fc80004000000ULL,
0x000000230600720bULL, 0x000fc80003f1e000ULL, 0x0000000623117208ULL, 0x000fe40004000000ULL,
0x000000101700720bULL, 0x004fe40003f3e000ULL, 0x0000001e1100720bULL, 0x000fe40003f1e000ULL,
0x0000001710107208ULL, 0x000fe40004800000ULL, 0x000000111e067208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b10167820ULL, 0x000fe20000410000ULL, 0x0000001f0600720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b0b117823ULL, 0x100fe20000010816ULL, 0x000000061f0b7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b54547823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b55557823ULL, 0x100fe20000010816ULL,
0x0000001100177308ULL, 0x000fe20000000800ULL, 0x0000002e0b00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010816ULL, 0x0000000b2e067208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b51517823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010816ULL,
0x0000003900267308ULL, 0x000ea20000000800ULL, 0x0000002f0600720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010816ULL, 0x000000062f067208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b21217823ULL, 0x100fe20000010816ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010816ULL,
0x0000001500317308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe20000010816ULL,
0x0c401f00060b7f89ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010816ULL,
0x3fb8aa3b2d167823ULL, 0x000fc80000010816ULL, 0x0000005400547308ULL, 0x000ff00000000800ULL,
0x0000005500557308ULL, 0x000f300000000800ULL, 0x00000014002a7308ULL, 0x0005e20000000800ULL,
0x0000000b0600720bULL, 0x008fc80003f1e000ULL, 0x000000060b067208ULL, 0x000fc60004000000ULL,
0x00000016002d7308ULL, 0x0009e20000000800ULL, 0x000000172614723eULL, 0x004fe200000000ffULL,
0x0c201f0006117f89ULL, 0x000eac00000e0000ULL, 0x00000025002b7308ULL, 0x000fe20000000800ULL,
0x000000545516723eULL, 0x010fce00000000ffULL, 0x0000005000507308ULL, 0x000ff00000000800ULL,
0x0000005100517308ULL, 0x000ee20000000800ULL, 0x000000110600720bULL, 0x004fc80003f1e000ULL,
0x0000000611117208ULL, 0x000fc60004000000ULL, 0x0000001a001a7308ULL, 0x000ea40000000800ULL,
0x3fb8aa3b11327820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b56567823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b57577823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b52527823ULL, 0x100fe20000010832ULL, 0x0000003a00157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b53537823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b18347823ULL, 0x100fe20000010832ULL, 0x000000505118723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010832ULL, 0x0000001a2b1a723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010832ULL, 0x0000003b00067308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b1e2b7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b1f357823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b2f2f7823ULL, 0x000fc80000010832ULL,
0x0000005600567308ULL, 0x000fe20000000800ULL, 0x000000150615723eULL, 0x004fce00000000ffULL,
0x0000005700577308ULL, 0x000eb00000000800ULL, 0x00000024000b7308ULL, 0x0007e20000000800ULL,
0x000000565717723eULL, 0x004fce00000000ffULL, 0x0000005200527308ULL, 0x000fe20000000800ULL,
0x000000281424723cULL, 0x008fee00000018ffULL, 0x0000005300537308ULL, 0x000ff00000000800ULL,
0x0000001b00067308ULL, 0x000eb00000000800ULL, 0x0000001c00307308ULL, 0x0007e20000000800ULL,
0x0000000b061b723eULL, 0x004fce00000000ffULL, 0x0000001d00337308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b191c7823ULL, 0x008fe20000010832ULL, 0x000000525319723eULL, 0x000fe200000000ffULL,
0x0c401f00120b7f89ULL, 0x000ea800000e0000ULL, 0x0c401f0013067f89ULL, 0x000ee200000e0000ULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x000000281824723cULL, 0x000fee0000001824ULL,
0x0000002100217308ULL, 0x000f300000000800ULL, 0x0000001c001d7308ULL, 0x000be20000000800ULL,
0x0000000b1200720bULL, 0x004fc40003f1e000ULL, 0x00000020211e723eULL, 0x010fca00000000ffULL,
0x0000003400347308ULL, 0x000ea20000000800ULL, 0x0000002a311c723eULL, 0x022fe400000000ffULL,
0x000000120b127208ULL, 0x000fe20004000000ULL, 0x00000008040b7824ULL, 0x040fe200078e00ffULL,
0x0000000303317812ULL, 0x000fe400078ec0ffULL, 0x000000061300720bULL, 0x008fe20003f3e000ULL,
0x0000002200227308ULL, 0x000fe20000000800ULL, 0x0c201f0012037f89ULL, 0x000e6200000e0000ULL,
0x000000303320723eULL, 0x000fe200000000ffULL, 0x0000000804307824ULL, 0x000fe200078e00ffULL,
0x0000001306137208ULL, 0x000fc40004800000ULL, 0x0000000431067210ULL, 0x000fe40007ffe0ffULL,
0x0000002300237308ULL, 0x000ee20000000800ULL, 0x0000001d341d723eULL, 0x004fe400000000ffULL,
0x0000000c432a7211ULL, 0x000fe400078e58ffULL, 0xfffffff80b0b7812ULL, 0x000fc600078ee206ULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x00000022231f723eULL, 0x008fce00000000ffULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x000000031200720bULL, 0x002fc80003f1e000ULL,
0x0000001203127208ULL, 0x000fe20004000000ULL, 0x000000281c24723cULL, 0x000fe20000001824ULL,
0x0000002c2d22723eULL, 0x004fe200000000ffULL, 0x0000003500367308ULL, 0x000e620000000800ULL,
0x00000008042c7810ULL, 0x000fe40007ffe0ffULL, 0x0c201f0013047f89ULL, 0x000ea200000e0000ULL,
0x0000000308ff7812ULL, 0x000fe4000780c0ffULL, 0x00000001312d7824ULL, 0x000fe200078e022cULL,
0x000000032c327819ULL, 0x040fe200000006ffULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x000000082c317824ULL, 0x000fe200078e00ffULL, 0x00000014002c7202ULL, 0x000fe20000000f00ULL,
0x000000ffff147224ULL, 0x000fe200078e0015ULL, 0xfffffff8322d7812ULL, 0x000fc400078ee22dULL,
0x0000001700157202ULL, 0x000fe40000000f00ULL, 0x0000002f002f7308ULL, 0x000ee20000000800ULL,
0x0000002b3621723eULL, 0x002fe400000000ffULL, 0x00000004062b7810ULL, 0x000fe40007ffe0ffULL,
0x0000001b00177202ULL, 0x000fe40000000f00ULL, 0xfffffff8302b7812ULL, 0x000fe400078ee22bULL,
0x000000041300720bULL, 0x004fc40003f3e000ULL, 0x0000002e2f23723eULL, 0x008fe200000000ffULL,
0x0000000c062e7836ULL, 0x000fe20000000000ULL, 0x000110002a067810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2f7224ULL, 0x000fe200078e001aULL, 0x00000020002a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff1a7224ULL, 0x000fe200078e0021ULL, 0xfffffff831317812ULL, 0x000fe200078ee22eULL,
0x000000282024723cULL, 0x000fe20000001824ULL, 0x000000100b0b7824ULL, 0x000fe200078e0206ULL,
0x00000018002e7202ULL, 0x000fe20000000f00ULL, 0x000000ffff187224ULL, 0x000fe200078e001dULL,
0x0000000631317211ULL, 0x000fc400078e20ffULL, 0x00000023001b7202ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fe200078e001eULL, 0x0000001c00287202ULL, 0x000fe40000000f00ULL,
0x0000001304137208ULL, 0x000fe40004800000ULL, 0x0000000100047802ULL, 0x000fd00000000f00ULL,
0x000000102d277824ULL, 0x000fe200078e0206ULL, 0x000000062b257211ULL, 0x000fe200078e20ffULL,
0x000000ffff2d7224ULL, 0x000fe400078e0016ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0022ULL,
0x000000ffff167224ULL, 0x000fe200078e0019ULL, 0x0000002c0b007844ULL, 0x000fe20000000200ULL,
0x0000001f00197202ULL, 0x000fc60000000f00ULL, 0x0000002825007844ULL, 0x0003e80000000200ULL,
0x0000001427007844ULL, 0x0005e80000000200ULL, 0x0000001831007844ULL, 0x0005e80000000200ULL,
0x01b0001009008388ULL, 0x0005e20000000c00ULL, 0x000000ffff257224ULL, 0x002fca00078e0026ULL,
0x01b2002409008388ULL, 0x0005e20000000a00ULL, 0x0000000d6300720cULL, 0x000fe20003f06070ULL,
0x01b6080405ff79a7ULL, 0x0005e2000850003fULL, 0x01b6100405ff79a7ULL, 0x0005e2000850003fULL,
0x01b6180405ff79a7ULL, 0x0005e2000850003fULL, 0x01b6200405ff79a7ULL, 0x0005f2000850003fULL,
0xffffffb000148947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000005037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000007945ULL, 0x000fe60003800000ULL,
0x7f80000003047812ULL, 0x000fc800078ec0ffULL, 0x018000000400780cULL, 0x000fda0003f05070ULL,
0x0000000500038308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0400720cULL, 0x040fe40003f25070ULL, 0x008000000400780cULL, 0x000fe40003f02070ULL,
0x00000001ff047807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000304ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff05ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x0000000304ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000005047812ULL, 0x000fd600078ec0ffULL,
0x0080000004030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0004ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000500037308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000b7802ULL, 0x000fc80000000f00ULL,
0xfffffef40a547950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004c5ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000640ULL, 0x0000000000000210ULL,
0x0000001400000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000850ULL, 0x00000000000000d0ULL,
0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000920ULL, 0x0000000000000054ULL,
0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000974ULL, 0x0000000000000424ULL,
0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d98ULL, 0x0000000000000000ULL,
0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d98ULL, 0x0000000000000048ULL,
0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000007bULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000de0ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL,
0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e00ULL, 0x0000000000010b80ULL,
0x0000001400000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000008dULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000011980ULL, 0x000000000000003cULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x00000000000119c0ULL, 0x0000000000000400ULL,
0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL,
0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000119c0ULL, 0x0000000000000258ULL,
0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL,
0x0000000000011f98ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000011f98ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000de0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL,
0x0000000500000001ULL, 0x0000000000000e00ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000010b80ULL, 0x0000000000010b80ULL, 0x0000000000000008ULL, 0x0000000600000001ULL,
0x0000000000011980ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x00000000000119c0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000258ULL, 0x0000000000000258ULL,
0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_nqpkv_8_m_8_sm_90_cubin_len = 73960;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
