/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000157c0ULL, 0x0000000000015440ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL,
0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL,
0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL,
0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL,
0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c00010000028dULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00010000036fULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b0022000003b5ULL, 0x0000000000013c90ULL, 0x0000000000000170ULL, 0x000b0022000003e8ULL,
0x0000000000013e00ULL, 0x0000000000000040ULL, 0x000b002200000413ULL, 0x0000000000013e40ULL,
0x0000000000000050ULL, 0x000b00220000043dULL, 0x0000000000013e90ULL, 0x00000000000000f0ULL,
0x000a0003000004abULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000004cbULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004fbULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000013f80ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00013c9000000000ULL, 0x0000040400000000ULL, 0x810c000001500400ULL,
0x004dc80400288080ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808c0828808081ULL,
0x8f082880808e0828ULL, 0x2880808808288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL,
0x0000220028808088ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL, 0x00013c9000000000ULL,
0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL,
0x8e082880808c0828ULL, 0x2880808f08288080ULL, 0x8280162880808608ULL, 0x0000000003102880ULL,
0x8080869200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL, 0x000000f000000000ULL,
0x00013e0000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0x8e082880808c0828ULL, 0x2880808f08288080ULL, 0x0003102880828016ULL,
0x9200000000000000ULL, 0x000022002880808fULL, 0x0000002cffffffffULL, 0x0000017800000000ULL,
0x00013e4000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL, 0x808e2880808f0900ULL,
0x0000000000002880ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8f082880808c0828ULL,
0x2880808e08288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x000022002880808eULL,
0x0000001cffffffffULL, 0x0000020800000000ULL, 0x00013e9000000000ULL, 0x000000f000000000ULL,
0x0000000000000000ULL, 0x0000001800082f04ULL, 0x000823040000007fULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL,
0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL,
0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL,
0x0000001100082304ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008230400000000ULL, 0x0000000000000018ULL, 0x0000001800081204ULL, 0x0008110400000000ULL,
0x0000000000000018ULL, 0x0000007b00043704ULL, 0x0000001500080a04ULL, 0x0060190300600160ULL,
0x00000000000c1704ULL, 0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0021f00000500008ULL,
0x00000000000c1704ULL, 0x0011f00000480007ULL, 0x00000000000c1704ULL, 0x0081f00000280006ULL,
0x00000000000c1704ULL, 0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL,
0x00000000000c1704ULL, 0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL,
0x00000000000c1704ULL, 0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400801b03ULL, 0x01542904000008b0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x01542804ffffffffULL, 0x00000450000002d0ULL, 0x000019b0000004e0ULL, 0x00002bb000002af0ULL,
0x00002e3000002cd0ULL, 0x0000306000003030ULL, 0x00003100000030b0ULL, 0x00004740000037f0ULL,
0x00004900000047d0ULL, 0x00004c7000004a60ULL, 0x00004cf000004ca0ULL, 0x0000512000004d40ULL,
0x000061c000006130ULL, 0x00006450000062f0ULL, 0x0000669000006660ULL, 0x00006730000066e0ULL,
0x00007b3000006b40ULL, 0x00007d0000007bd0ULL, 0x0000807000007e60ULL, 0x000080f0000080a0ULL,
0x0000869000008140ULL, 0x0000aa20000086a0ULL, 0x0000b1a00000aa60ULL, 0x000125900000b1e0ULL,
0x000125e0000125d0ULL, 0x00012600000125f0ULL, 0x0001268000012660ULL, 0x000132d0000126a0ULL,
0x0001336000013310ULL, 0x000133f0000133a0ULL, 0x0001349000013440ULL, 0x00013520000134d0ULL,
0x000135b000013560ULL, 0x0001365000013600ULL, 0x000136e000013690ULL, 0x0001377000013720ULL,
0x00013810000137c0ULL, 0x000138a000013850ULL, 0x00013930000138e0ULL, 0x000139d000013980ULL,
0x00013a9000013a30ULL, 0x00013b5000013af0ULL, 0x00013c1000013bb0ULL, 0x0200390400013c70ULL,
0x000000ff000003b0ULL, 0x003f010000013600ULL, 0x0000000b000003e0ULL, 0x003f012000013608ULL,
0x0000000b00000480ULL, 0x003f012000013688ULL, 0x000000ff000008f0ULL, 0x003f010700013600ULL,
0x0000006e00000ad0ULL, 0x003f01020001368cULL, 0x0000006e00000ba0ULL, 0x003f010100013688ULL,
0x0000000a000027f0ULL, 0x003f010100013608ULL, 0x0000000a00002810ULL, 0x003f01050001360cULL,
0x0000000a000029e0ULL, 0x003f01050001360cULL, 0x0000004e00003770ULL, 0x003f010100013688ULL,
0x00000034000044a0ULL, 0x003f010100013628ULL, 0x00000034000044c0ULL, 0x003f01050001362cULL,
0x0000003400004690ULL, 0x003f01050001362cULL, 0x0000000e000050d0ULL, 0x003f010100000000ULL,
0x0000000900005e90ULL, 0x003f010100013648ULL, 0x0000000900005eb0ULL, 0x003f01050001364cULL,
0x0000000900006080ULL, 0x003f01050001364cULL, 0x0000000c00006b20ULL, 0x003f010100000000ULL,
0x0000001e00007890ULL, 0x003f010100013668ULL, 0x0000001e000078b0ULL, 0x003f01050001366cULL,
0x0000001e00007a80ULL, 0x003f01050001366cULL, 0x0000000800008530ULL, 0x003f010100000000ULL,
0x000000ff0000c150ULL, 0x003f010100013600ULL, 0x000000ff0000cd20ULL, 0x003f010500013604ULL,
0x000000ff0000cef0ULL, 0x003f010500013604ULL, 0x0000007100010b50ULL, 0x003f010100000000ULL,
0x0000007100010b90ULL, 0x003f010500000004ULL, 0x0000007100010d60ULL, 0x003f010500000004ULL,
0x0000007200013130ULL, 0x003f010100013608ULL, 0x0000007200013190ULL, 0x003f010100013610ULL,
0x00000072000131f0ULL, 0x003f010100013618ULL, 0x0000007200013260ULL, 0x003f010100013620ULL,
0x00201c0400033803ULL, 0x0000ba500000ba20ULL, 0x0000bd900000bc30ULL, 0x0000c0200000bf20ULL,
0x000132a00000cf50ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000274ULL,
0x0000001800000002ULL, 0x00000000000001e4ULL, 0x0000001800000002ULL, 0x0000000000000164ULL,
0x0000001800000002ULL, 0x00000000000000dcULL, 0x0000001800000002ULL, 0x0000000000000044ULL,
0x0000001800000002ULL, 0x000000000000024fULL, 0x0000001800000002ULL, 0x00000000000001bfULL,
0x0000001800000002ULL, 0x000000000000013cULL, 0x0000001800000002ULL, 0x00000000000000b7ULL,
0x0000001800000002ULL, 0x0000000000013700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0c7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000097919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000c777a19ULL, 0x000fe200000006ffULL,
0x00000000000579c3ULL, 0x000f220000002500ULL, 0x0000000000077919ULL, 0x000ea20000002100ULL,
0x0000460000087ab9ULL, 0x000fc60000000a00ULL, 0x0000000000767919ULL, 0x000ea20000002700ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003737a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a73ULL, 0x0000040003007624ULL, 0x000fca00078e020cULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000173730810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000173731810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff73aa12ULL, 0x000fc800078e33ffULL,
0x0000007300007306ULL, 0x000e620000209000ULL, 0x000000ff7300720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000373047224ULL, 0x004fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x0000000000047919ULL, 0x000ee40000002200ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000000603717227ULL, 0x000fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a71ULL,
0x0000000073007224ULL, 0x000fca00078e0206ULL, 0x000000730000720cULL, 0x000fe20003f06070ULL,
0x0000010009027a24ULL, 0x008fe400078e0204ULL, 0x00001fff09097589ULL, 0x000fe400000e0000ULL,
0x00000000020b7a24ULL, 0x000fca00078e0207ULL, 0x000000ff0b00720cULL, 0x000fc60003f65270ULL,
0x0000000100000824ULL, 0x000fe200078e0a73ULL, 0x0000000171710810ULL, 0x000fe40007ffe0ffULL,
0x0000000f0b00780cULL, 0x040fe40003f84070ULL, 0x000000730000720cULL, 0x000fe40003f26070ULL,
0x000000030b00780cULL, 0x000fc60003f04070ULL, 0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03b424ULL, 0x000fc800078e00ffULL, 0x3fffffc0ff04c424ULL, 0x000fe400078e00ffULL,
0x0000000171711810ULL, 0x000fe20007ffe0ffULL, 0x7fffffc0ff05c424ULL, 0x000fe200078e00ffULL,
0x00000073ff71a212ULL, 0x000fe200078e33ffULL, 0x01360002ff00b388ULL, 0x0003e20000000a00ULL,
0x0000007f0b00780cULL, 0x000fc60003f24070ULL, 0x000000ffff007224ULL, 0x000fe200078e0a71ULL,
0x013608040b00c388ULL, 0x000fe60000008a00ULL, 0x0000000073737224ULL, 0x000fe200078e0206ULL,
0x00000005ff007819ULL, 0x000fe20000011607ULL, 0x3fffff60ff068424ULL, 0x000fe200078e00ffULL,
0x00005a0071037a19ULL, 0x002fe200000006ffULL, 0x00000010736e7824ULL, 0x000fe400078e00ffULL,
0x7fffff60ff078424ULL, 0x000fe200078e00ffULL, 0x00001fff00007589ULL, 0x000e6200000e0000ULL,
0xff317217ff089424ULL, 0x000fe200078e00ffULL, 0x000000046e027c10ULL, 0x000fc4000fffe1ffULL,
0x013688060b008388ULL, 0x000fe20000008a00ULL, 0x000000046e007c0cULL, 0x000fe4000bf03070ULL,
0x0000001002027817ULL, 0x000fe20003800000ULL, 0x013400080b009388ULL, 0x000fe60000004800ULL,
0x000000ff02727207ULL, 0x000fe20000000000ULL, 0x0000580076027a24ULL, 0x000fe200078e02ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000107200780cULL, 0x000fe20003f05270ULL,
0x0000007702047224ULL, 0x000fc400078e0203ULL, 0x00000005ff027e24ULL, 0x010fe4000f8e00ffULL,
0x0000000409057824ULL, 0x002fc800078e0200ULL, 0x0000000205057824ULL, 0x000fc800078e00ffULL,
0x000001d000008947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00000004ff087819ULL, 0x002fca0000011603ULL,
0x00000001050a7824ULL, 0x000fc800078e0208ULL, 0x000000016e067824ULL, 0x000fca00078e020aULL,
0x0000000406077c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff067a19ULL, 0x000fc60000011606ULL,
0x0000000104077824ULL, 0x000fe200078e0207ULL, 0x0000000572047217ULL, 0x000fc60007800000ULL,
0x00000077060b7224ULL, 0x000fe400078e0207ULL, 0x0000001003067824ULL, 0x000fe400078e00ffULL,
0x0000000104077824ULL, 0x000fe400078e0a05ULL, 0x000001000b047825ULL, 0x000fe200078e00ffULL,
0x000000f0060b7812ULL, 0x000fe400078ec0ffULL, 0x000000070800720cULL, 0x000fe20003f06070ULL,
0x000000010a077824ULL, 0x000fe200078e0203ULL, 0x0000000b040b7212ULL, 0x000fe200078efcffULL,
0x000000100a0a7824ULL, 0x000fc600078e00ffULL, 0x00005e000b047a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00a077812ULL, 0x000fe400078ee207ULL, 0x00005f0005057a10ULL, 0x000fc60000ffe4ffULL,
0x0000001007077824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000c101c48ULL, 0x0000018000007947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x0000000503077211ULL, 0x002fca00078fe0ffULL, 0x000000016e057824ULL, 0x000fe400078e0207ULL,
0x0000000107087824ULL, 0x040fe400078e0203ULL, 0x0000001007077824ULL, 0x000fe200078e00ffULL,
0x00000004050b7c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff067a19ULL, 0x000fe40000011605ULL,
0xfffffff007087812ULL, 0x000fe200078ee208ULL, 0x00000001040b7824ULL, 0x000fc800078e020bULL,
0x0000007706047224ULL, 0x000fe400078e020bULL, 0x0000001003067824ULL, 0x000fe400078e00ffULL,
0x0000010004047825ULL, 0x000fc600078e00ffULL, 0x000000f0060b7812ULL, 0x000fe200078ec0ffULL,
0x0000001008077824ULL, 0x000fc600078e00ffULL, 0x0000000b04047212ULL, 0x000fc800078efcffULL,
0x00005e0004047a10ULL, 0x000fc80007f1e0ffULL, 0x00005f0005057a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e8000b901c48ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x0000000000047806ULL, 0x002fc800038e0000ULL,
0x0000000400057300ULL, 0x000eb000000e0000ULL, 0x0000000400077309ULL, 0x000e620000000000ULL,
0x000000080500720cULL, 0x004fe40003f02070ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffff057224ULL, 0x002fe200078e0a07ULL, 0x0000000400077802ULL, 0x000fca0000000f00ULL,
0x0000660076627625ULL, 0x000fc800078e0007ULL, 0x01360405ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01360000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000862627981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0900720cULL, 0x000fe40003f05270ULL,
0x0000007f626d7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff62667810ULL, 0x000fc40007ffe0ffULL,
0x00000007ff6d7819ULL, 0x000fe4000001166dULL, 0x00000008ff667819ULL, 0x000fca0000011666ULL,
0x0000b62000008947ULL, 0x000fea0003800000ULL, 0x00000003ff047819ULL, 0x000fe20000011600ULL,
0x00000008006e7824ULL, 0x000fe400078e00ffULL, 0x00000003ff097424ULL, 0x000fe200078e00ffULL,
0x01ffffff040b7812ULL, 0x000fe200078ec0ffULL, 0xffffffffff597424ULL, 0x000fc800078e00ffULL,
0x00000002020b7824ULL, 0x000fca00078e020bULL, 0x0000006d0b00720cULL, 0x000fda0003f06070ULL,
0x0000000276048824ULL, 0x000fe400078e00ffULL, 0x00006800ff058624ULL, 0x002fc800078e00ffULL,
0x0000680004048624ULL, 0x000fc800078e0205ULL, 0x000000010b048824ULL, 0x000fe200078e0204ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01368c096eff738cULL, 0x0003e20000000000ULL,
0x0000640004048625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000804598981ULL, 0x000ea2000c1e1900ULL, 0x0000000102097810ULL, 0x002fe20007ffe0ffULL,
0x0000008071697824ULL, 0x000fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fe20000011600ULL,
0x00000100ff087424ULL, 0x000fe200078e00ffULL, 0x000000660900720cULL, 0x000fe20003f06070ULL,
0x013688006eff7f8cULL, 0x0003e2000c80043fULL, 0x00000001006a7812ULL, 0x000fe200078ec0ffULL,
0x000000200a6f7824ULL, 0x000fc800078e00ffULL, 0x00000100020c7824ULL, 0x000fca00078e026fULL,
0x00000060690e7812ULL, 0x000fe200078ef80cULL, 0x0000590059077a24ULL, 0x004fc800078e02ffULL,
0x0000008007077824ULL, 0x000fc800078e00ffULL, 0x0000620007047625ULL, 0x000fe200078e0008ULL,
0x0000064000008947ULL, 0x000fea0003800000ULL, 0x00000003ff187819ULL, 0x102fe20000011603ULL,
0x000000020a177824ULL, 0x000fe200078e026aULL, 0x0000000c62077217ULL, 0x000fe40007800000ULL,
0x0000000418087810ULL, 0x040fe40007ffe0ffULL, 0x0000000c18167810ULL, 0x040fe20007ffe0ffULL,
0x0000000107077824ULL, 0x000fe200078e0a0cULL, 0x0000000818107810ULL, 0x000fe20007ffe0ffULL,
0x0000000108097824ULL, 0x100fe200078e0203ULL, 0x00000014181c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000808127824ULL, 0x000fe200078e00ffULL, 0x00000020070f7817ULL, 0x000fe20003800000ULL,
0x00000001160d7824ULL, 0x000fe200078e0203ULL, 0x00000010181a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000816147824ULL, 0x000fe200078e00ffULL, 0xfffffff8121b7812ULL, 0x000fe200078ee209ULL,
0x00000001100c7824ULL, 0x000fe200078e0203ULL, 0x0000007006097812ULL, 0x000fe200078ec0ffULL,
0x00000008101d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8141f7812ULL, 0x000fe200078ee20dULL,
0x000000010e0d7824ULL, 0x000fe200078e0208ULL, 0x0000000f0800720cULL, 0x080fe20003f86070ULL,
0x000000806a067824ULL, 0x000fe200078e0209ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee20cULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x0000000f1000720cULL, 0x080fe20003f66070ULL,
0x000000010e097824ULL, 0x000fe200078e0218ULL, 0x0000000f1600720cULL, 0x080fe20003f46070ULL,
0x000001000d0c7825ULL, 0x000fe200078e0006ULL, 0x0000000f1800720cULL, 0x000fc60003fa6070ULL,
0x0000010009087825ULL, 0x000fe200078e0006ULL, 0x0000000c04147210ULL, 0x000fc60007f3e0ffULL,
0x000000011c137824ULL, 0x100fe200078e0203ULL, 0x0000000804127210ULL, 0x000fe20007f1e0ffULL,
0x000000081c207824ULL, 0x000fe400078e00ffULL, 0x000000011a117824ULL, 0x040fe400078e0203ULL,
0x000000081a1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff820257812ULL, 0x000fe200078ee213ULL,
0x0000000105157824ULL, 0x040fe200008e060dULL, 0x0000000f1a00720cULL, 0x000fe20003f26070ULL,
0x0000000105137824ULL, 0x000fe200000e0609ULL, 0xfffffff81e217812ULL, 0x000fe200078ee211ULL,
0x000000010e0d7824ULL, 0x000fc400078e0216ULL, 0x000000010e097824ULL, 0x000fe400078e0210ULL,
0x0000000118107824ULL, 0x000fe400078e0203ULL, 0x000001000d0c7825ULL, 0x000fc600078e0006ULL,
0x0000000710167812ULL, 0x000fe200078ec0ffULL, 0x0000010009087825ULL, 0x000fe200078e0006ULL,
0x0000000c040c7210ULL, 0x000fc60007fde0ffULL, 0x000000010e117824ULL, 0x000fe200078e021aULL,
0x0000000804087210ULL, 0x000fe20007f1e0ffULL, 0x000000010e237824ULL, 0x000fe200078e021cULL,
0x0000b000171a7811ULL, 0x000fe200078e68ffULL, 0x0000010011107825ULL, 0x000fe200078e0006ULL,
0x0ffffff816177812ULL, 0x000fe400078ef803ULL, 0x0000000d050d7210ULL, 0x040fe200037fe4ffULL,
0x0000000105097824ULL, 0x000fe200000e0609ULL, 0x0000001004167210ULL, 0x000fe20007fde0ffULL,
0x0000001017197824ULL, 0x100fe200078e021aULL, 0x0000000f1c00720cULL, 0x080fe20003f06070ULL,
0x000000101b1b7824ULL, 0x000fe200078e021aULL, 0x00000018181c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000105177824ULL, 0x000fe200030e0611ULL, 0x0000001c18187810ULL, 0x000fe20007ffe0ffULL,
0x0000010023107825ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012197faeULL, 0x0003e2000e901c48ULL, 0x0000000f1c00720cULL, 0x000fc40003fa6070ULL,
0x000000010e237824ULL, 0x000fe200078e021cULL, 0x00000000141b7faeULL, 0x0005e2000e101c48ULL,
0x0000001004107210ULL, 0x000fe20007fde0ffULL, 0x000000010e277824ULL, 0x000fe200078e0218ULL,
0x0000000f1800720cULL, 0x000fe20003f86070ULL, 0x00000100230e7825ULL, 0x000fc800078e0006ULL,
0x0000000105117824ULL, 0x000fe200030e0611ULL, 0x0000000e040e7210ULL, 0x000fe20007fde0ffULL,
0x000000011c127824ULL, 0x142fe400078e0203ULL, 0x000000081c137824ULL, 0x000fe400078e00ffULL,
0x0000000118147824ULL, 0x044fe400078e0203ULL, 0x0000000818157824ULL, 0x000fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee212ULL, 0x0000010027067825ULL, 0x000fc600078e0006ULL,
0xfffffff815157812ULL, 0x000fe200078ee214ULL, 0x00000001050f7824ULL, 0x000fe200030e060fULL,
0x0000000604047210ULL, 0x000fe20007fde0ffULL, 0x000000101d1d7824ULL, 0x100fe400078e021aULL,
0x000000101f1f7824ULL, 0x100fe400078e021aULL, 0x0000001021217824ULL, 0x100fe200078e021aULL,
0x00000000081d7faeULL, 0x0003e2000d901c48ULL, 0x0000001025257824ULL, 0x100fe400078e021aULL,
0x0000001013137824ULL, 0x100fe200078e021aULL, 0x000000000c1f7faeULL, 0x0003e2000d101c48ULL,
0x0000001015157824ULL, 0x000fc400078e021aULL, 0x0000000105057824ULL, 0x000fe200030e0607ULL,
0x0000000016217faeULL, 0x0003e8000c901c48ULL, 0x0000000010257faeULL, 0x0003e8000c101c48ULL,
0x000000000e137faeULL, 0x0003e8000e901c48ULL, 0x0000000004157faeULL, 0x0003e2000e101c48ULL,
0x0000057000007947ULL, 0x000fea0003800000ULL, 0x0000000403077811ULL, 0x042fe200078fe8ffULL,
0x000000020a187824ULL, 0x000fe200078e026aULL, 0x00000008030c7811ULL, 0x000fc400078fe8ffULL,
0x0000001403127811ULL, 0x000fe200078fe8ffULL, 0x0000000107087824ULL, 0x100fe200078e0203ULL,
0x0000001003107811ULL, 0x000fe200078fe8ffULL, 0x00000008070d7824ULL, 0x000fe200078e00ffULL,
0x0000001c03177811ULL, 0x040fe200078fe8ffULL, 0x000000010c097824ULL, 0x140fe200078e0203ULL,
0x0000001803147811ULL, 0x000fe200078fe8ffULL, 0x000000080c1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d1a7812ULL, 0x000fe200078ee208ULL, 0x00000001120f7824ULL, 0x040fe200078e0203ULL,
0x0000000c03087811ULL, 0x000fe200078fe8ffULL, 0x0000000812227824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL, 0x00000001100d7824ULL, 0x100fe200078e0203ULL,
0x0000b00018277811ULL, 0x000fe200078e68ffULL, 0x0000000108097824ULL, 0x000fe200078e0203ULL,
0xfffffff822227812ULL, 0x000fe200078ee20fULL, 0x00000008081e7824ULL, 0x000fe200078e00ffULL,
0x000000080e0f7210ULL, 0x000fe20007ffe0ffULL, 0x0000000810207824ULL, 0x000fc400078e00ffULL,
0x0000000117087824ULL, 0x040fe200078e0203ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee209ULL,
0x00000008171b7824ULL, 0x000fe200078e00ffULL, 0x0000007006097812ULL, 0x000fe200078ec0ffULL,
0x000000010e197824ULL, 0x000fe200078e0217ULL, 0x0000000303067211ULL, 0x040fe200078fe8ffULL,
0x0000000114117824ULL, 0x000fe200078e0203ULL, 0xfffffff820207812ULL, 0x000fe200078ee20dULL,
0x000000806a167824ULL, 0x000fe200078e0209ULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x000000010e097824ULL, 0x000fe200078e0207ULL, 0x0000000e03077211ULL, 0x000fe200078fe8ffULL,
0x0000000814247824ULL, 0x000fe200078e00ffULL, 0x0ffffff806187812ULL, 0x000fe200078ef803ULL,
0x000000ffff177224ULL, 0x000fe200078e00ffULL, 0xfffffff81b267812ULL, 0x000fe200078ee208ULL,
0x000000010e0d7824ULL, 0x000fe200078e020cULL, 0xfffffff824247812ULL, 0x000fe200078ee211ULL,
0x0000010007067825ULL, 0x000fc800078e0016ULL, 0x0000010009087825ULL, 0x000fe200078e0016ULL,
0x0000000604067210ULL, 0x000fc60007f1e0ffULL, 0x000000010e117824ULL, 0x000fe200078e0210ULL,
0x0000000804087210ULL, 0x000fe20007f3e0ffULL, 0x000000010e137824ULL, 0x040fe400078e0212ULL,
0x000000010e157824ULL, 0x000fe400078e0214ULL, 0x000001000d0c7825ULL, 0x000fc800078e0016ULL,
0x000001000f0e7825ULL, 0x000fe200078e0016ULL, 0x0000000c040c7210ULL, 0x000fc60007f5e0ffULL,
0x0000010011107825ULL, 0x000fe200078e0016ULL, 0x0000000e040e7210ULL, 0x000fc60007f7e0ffULL,
0x0000010013127825ULL, 0x000fc800078e0016ULL, 0x0000010015147825ULL, 0x000fc800078e0016ULL,
0x0000010019167825ULL, 0x000fc800078e0016ULL, 0x0000000105077824ULL, 0x040fe200000e0607ULL,
0x0000001004107210ULL, 0x040fe20007f1e0ffULL, 0x0000000105097824ULL, 0x040fe200008e0609ULL,
0x0000001204127210ULL, 0x000fe20007f3e0ffULL, 0x0000001018197824ULL, 0x000fe400078e0227ULL,
0x00000001050d7824ULL, 0x040fe200010e060dULL, 0x0000001404147210ULL, 0x000fe20007f5e0ffULL,
0x000000101a1b7824ULL, 0x000fe200078e0227ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006197faeULL, 0x0003e2000b901c48ULL, 0x00000001050f7824ULL, 0x000fe200018e060fULL,
0x0000001604047210ULL, 0x000fe20007f7e0ffULL, 0x000000101c1d7824ULL, 0x100fe200078e0227ULL,
0x00000000081b7faeULL, 0x0003e2000b901c48ULL, 0x000000101e1f7824ULL, 0x000fc400078e0227ULL,
0x0000001020217824ULL, 0x000fe200078e0227ULL, 0x000000000c1d7faeULL, 0x0003e2000b901c48ULL,
0x0000000105117824ULL, 0x040fe400000e0611ULL, 0x0000001022237824ULL, 0x000fe200078e0227ULL,
0x000000000e1f7faeULL, 0x0003e2000b901c48ULL, 0x0000000105137824ULL, 0x040fe400008e0613ULL,
0x0000001024257824ULL, 0x000fe200078e0227ULL, 0x0000000010217faeULL, 0x0003e2000b901c48ULL,
0x0000000105157824ULL, 0x000fc400010e0615ULL, 0x0000001026277824ULL, 0x000fe200078e0227ULL,
0x0000000012237faeULL, 0x0003e2000b901c48ULL, 0x0000000105057824ULL, 0x000fc600018e0617ULL,
0x0000000014257faeULL, 0x0003e8000b901c48ULL, 0x0000000004277faeULL, 0x0003e4000b901c48ULL,
0x000000660200720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff0c7424ULL, 0x002fe200078e00ffULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00006c3000000947ULL, 0x000fea0003800000ULL, 0x00000002766c7824ULL, 0x000fe400078e00ffULL,
0x00006800ff057624ULL, 0x000fc400078e00ffULL, 0xff317217ff0c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff1f7224ULL, 0x000fe400078e00ffULL, 0x000068006c6c7624ULL, 0x000fc400078e0205ULL,
0x0000001000087824ULL, 0x000fe200078e00ffULL, 0x00000001020d7810ULL, 0x000fe20007ffe0ffULL,
0x0000590059597a24ULL, 0x010fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe008097812ULL, 0x000fe200078ec0ffULL, 0x0000008059087824ULL, 0x000fe200078e00ffULL,
0x000000660d00720cULL, 0x000fc60003f06070ULL, 0x0000010002097824ULL, 0x000fca00078e0209ULL,
0x00000040090f7810ULL, 0x000fe20007ffe0ffULL, 0x00000100ff097424ULL, 0x000fc600078e00ffULL,
0x000000600f307812ULL, 0x020fe200078ec0ffULL, 0x0000620008087625ULL, 0x000fc800078e0009ULL,
0x0000000169307824ULL, 0x000fe200078e0230ULL, 0x0000068000008947ULL, 0x000fea0003800000ULL,
0x0000000f620d7217ULL, 0x000fe20007800000ULL, 0x0000001003247824ULL, 0x000fe200078e00ffULL,
0x00000003ff387819ULL, 0x000fe40000011603ULL, 0x00000007000e7819ULL, 0x000fe200000006ffULL,
0x000000010d0f7824ULL, 0x000fe200078e0a0fULL, 0x0000000438287810ULL, 0x000fe20007ffe0ffULL,
0x00002000000d7824ULL, 0x000fe200078e00ffULL, 0x0000007024257812ULL, 0x000fe400078ec0ffULL,
0x0000000838367810ULL, 0x000fe20007ffe0ffULL, 0x0000000128247824ULL, 0x140fe200078e0203ULL,
0x00000080250e7812ULL, 0x000fe200078ef80eULL, 0x0000000828397824ULL, 0x000fe200078e00ffULL,
0x000020000d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000136257824ULL, 0x000fe200078e0203ULL,
0x0000000c383a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000836267824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee224ULL, 0x000040000a347824ULL, 0x000fe200078e020dULL,
0x000000200f337817ULL, 0x000fe20003800000ULL, 0x000000013a317824ULL, 0x000fe200078e0203ULL,
0xfffffff8260d7812ULL, 0x000fe200078ee225ULL, 0x000000083a247824ULL, 0x000fe200078e00ffULL,
0x00000010383c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000138257824ULL, 0x040fe200078e0230ULL,
0x00000014383e7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0xfffffff824317812ULL, 0x000fe200078ee231ULL, 0x000000013c327824ULL, 0x000fe200078e0203ULL,
0x000000333a00720cULL, 0x080fe20003f26070ULL, 0x0000010025247825ULL, 0x000fe200078e000eULL,
0x000000332800720cULL, 0x000fc40003f66070ULL, 0x000000333600720cULL, 0x080fe20003f06070ULL,
0x000000083c277824ULL, 0x000fe200078e00ffULL, 0x00000024082a7210ULL, 0x000fe20007f5e0ffULL,
0x000000013e0a7824ULL, 0x100fe200078e0203ULL, 0x000000333800720cULL, 0x000fe20003f86070ULL,
0x000000083e297824ULL, 0x000fe200078e00ffULL, 0xfffffff827327812ULL, 0x000fe200078ee232ULL,
0x0000000138267824ULL, 0x000fe400078e0203ULL, 0x0000000128277824ULL, 0x000fe200078e0230ULL,
0xfffffff8290a7812ULL, 0x000fe200078ee20aULL, 0x0000000136297824ULL, 0x100fe200078e0230ULL,
0x0000c00034367810ULL, 0x000fe20007ffe0ffULL, 0x000000013a357824ULL, 0x000fe200078e0230ULL,
0x00000007263a7812ULL, 0x000fe200078ec0ffULL, 0x00000001092b7824ULL, 0x000fc400010e0625ULL,
0x0000010027247825ULL, 0x000fe200078e000eULL, 0x0ffffff83a377812ULL, 0x000fe400078ef803ULL,
0x00000018383a7810ULL, 0x000fe20007ffe0ffULL, 0x0000010029267825ULL, 0x100fe200078e000eULL,
0x0000002408347210ULL, 0x000fe40007f5e0ffULL, 0x0000001c38387810ULL, 0x000fe20007ffe0ffULL,
0x0000010035287825ULL, 0x000fe200078e000eULL, 0x0000002608247210ULL, 0x000fc60007fbe0ffULL,
0x0000000109357824ULL, 0x040fe200010e0625ULL, 0x0000002808267210ULL, 0x000fe20007fde0ffULL,
0x0000000109257824ULL, 0x000fe200028e0627ULL, 0x000000333c00720cULL, 0x080fe20003f46070ULL,
0x0000001037377824ULL, 0x000fe200078e0236ULL, 0x000000333e00720cULL, 0x080fe20003fa6070ULL,
0x0000000109277824ULL, 0x000fe400030e0629ULL, 0x000000013c297824ULL, 0x000fe200078e0230ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a377faeULL, 0x0003e2000e101c48ULL,
0x0000001039397824ULL, 0x000fe200078e0236ULL, 0x000000333a00720cULL, 0x000fe20003f86070ULL,
0x0000010029287825ULL, 0x000fc600078e000eULL, 0x0000000034397faeULL, 0x0005e2000d901c48ULL,
0x000000013e3b7824ULL, 0x000fe200078e0230ULL, 0x0000002808287210ULL, 0x000fe20007fde0ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0236ULL, 0x000000333800720cULL, 0x000fe20003f66070ULL,
0x000000013a337824ULL, 0x000fe400078e0230ULL, 0x000001003b2a7825ULL, 0x002fe200078e000eULL,
0x00000000240d7faeULL, 0x0003e6000c101c48ULL, 0x0000000109297824ULL, 0x000fe200030e0629ULL,
0x0000002a082a7210ULL, 0x000fe20007fde0ffULL, 0x0000010033347825ULL, 0x004fc800078e000eULL,
0x0000000138377824ULL, 0x000fe400078e0230ULL, 0x000000013a307824ULL, 0x140fe400078e0203ULL,
0x000000083a397824ULL, 0x000fe400078e00ffULL, 0x0000000138337824ULL, 0x000fe400078e0203ULL,
0x00000001092b7824ULL, 0x000fe200030e062bULL, 0x0000003408347210ULL, 0x000fe20007fde0ffULL,
0x0000000838387824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee230ULL,
0x00000100370e7825ULL, 0x000fe200078e000eULL, 0x0000003509357210ULL, 0x000fc400037fe4ffULL,
0xfffffff8383b7812ULL, 0x000fe200078ee233ULL, 0x0000001031317824ULL, 0x100fe200078e0236ULL,
0x0000000e08087210ULL, 0x000fe20007fde0ffULL, 0x0000001032337824ULL, 0x100fe400078e0236ULL,
0x000000100a377824ULL, 0x100fe200078e0236ULL, 0x0000000026317faeULL, 0x0003e2000c901c48ULL,
0x0000001039397824ULL, 0x100fe400078e0236ULL, 0x000000103b3b7824ULL, 0x000fe200078e0236ULL,
0x0000000028337faeULL, 0x0003e2000d101c48ULL, 0x0000000109097824ULL, 0x000fc600030e060fULL,
0x000000002a377faeULL, 0x0003e8000e901c48ULL, 0x0000000034397faeULL, 0x0003e8000e101c48ULL,
0x00000000083b7faeULL, 0x0003e2000d901c48ULL, 0x000005b000007947ULL, 0x000fea0003800000ULL,
0x00002000000e7824ULL, 0x040fe200078e00ffULL, 0x0000000403257811ULL, 0x040fe200078fe8ffULL,
0x00000010030d7824ULL, 0x040fe200078e00ffULL, 0x0000000803277811ULL, 0x000fe200078fe8ffULL,
0x0000008000347824ULL, 0x000fe200078e00ffULL, 0x000020000e0f7812ULL, 0x000fe200078ec0ffULL,
0x00000008252b7824ULL, 0x000fe200078e00ffULL, 0x000000700d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000827387824ULL, 0x000fe200078e00ffULL, 0x0000001403317811ULL, 0x000fe200078fe8ffULL,
0x000040000a0e7824ULL, 0x000fe200078e020fULL, 0x000000800d347812ULL, 0x000fe200078ef834ULL,
0x00000001250a7824ULL, 0x100fe200078e0203ULL, 0x0000000c03297811ULL, 0x000fe200078fe8ffULL,
0x00000001270d7824ULL, 0x100fe200078e0203ULL, 0x0000001803337811ULL, 0x000fe200078fe8ffULL,
0x00000008313e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82b367812ULL, 0x000fe200078ee20aULL,
0x00000001290f7824ULL, 0x000fe200078e0203ULL, 0xfffffff838387812ULL, 0x000fe200078ee20dULL,
0x00000001310d7824ULL, 0x000fe200078e0203ULL, 0x00000010032b7811ULL, 0x000fe200078fe8ffULL,
0x00000008293a7824ULL, 0x000fe200078e00ffULL, 0x0000c0000e437810ULL, 0x000fe20007ffe0ffULL,
0x0000000833407824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL,
0x000000012b0a7824ULL, 0x000fe200078e0203ULL, 0x0000001c030d7811ULL, 0x000fe200078fe8ffULL,
0x000000082b357824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee20fULL,
0x00000001330f7824ULL, 0x100fe200078e0203ULL, 0x0000004338397211ULL, 0x000fe200078e20ffULL,
0x000000010d247824ULL, 0x000fe200078e0203ULL, 0xfffffff8353c7812ULL, 0x000fe200078ee20aULL,
0x000000080d357824ULL, 0x000fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee20fULL,
0x0000000125257824ULL, 0x100fe200078e0230ULL, 0x00000030030f7211ULL, 0x000fe200078fe8ffULL,
0x0000000127277824ULL, 0x000fe200078e0230ULL, 0xfffffff835427812ULL, 0x000fe200078ee224ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x00000003030a7211ULL, 0x000fe200078fe8ffULL,
0x0000000129297824ULL, 0x000fc400078e0230ULL, 0x000001000f0e7825ULL, 0x000fe200078e0034ULL,
0x000000070a0a7812ULL, 0x000fc600078ec0ffULL, 0x0000010025247825ULL, 0x000fe200078e0034ULL,
0x0000000e080e7210ULL, 0x000fe40007f1e0ffULL, 0x0ffffff80a0a7812ULL, 0x000fe200078ef803ULL,
0x000000012b2b7824ULL, 0x000fe200078e0230ULL, 0x0000002408247210ULL, 0x000fe20007f3e0ffULL,
0x0000010027267825ULL, 0x000fc800078e0034ULL, 0x0000000131317824ULL, 0x000fe200078e0230ULL,
0x0000002608267210ULL, 0x000fe20007f5e0ffULL, 0x0000010029287825ULL, 0x000fc800078e0034ULL,
0x0000000133337824ULL, 0x100fe200078e0230ULL, 0x0000002808287210ULL, 0x000fe20007f7e0ffULL,
0x000000010d0d7824ULL, 0x000fe400078e0230ULL, 0x000001002b2a7825ULL, 0x000fc800078e0034ULL,
0x0000010031307825ULL, 0x000fc800078e0034ULL, 0x0000010033327825ULL, 0x000fc800078e0034ULL,
0x000001000d347825ULL, 0x000fc800078e0034ULL, 0x00000001090f7824ULL, 0x040fe200000e060fULL,
0x0000002a082a7210ULL, 0x040fe20007f1e0ffULL, 0x0000000109257824ULL, 0x040fe200008e0625ULL,
0x0000003008307210ULL, 0x000fe20007f3e0ffULL, 0x000000100a0d7824ULL, 0x000fe400078e0243ULL,
0x0000000109277824ULL, 0x040fe200010e0627ULL, 0x0000003208327210ULL, 0x000fe20007f5e0ffULL,
0x0000001036377824ULL, 0x000fe200078e0243ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0d7faeULL, 0x0003e2000b901c48ULL, 0x0000000109297824ULL, 0x000fe200018e0629ULL,
0x0000003408087210ULL, 0x000fe20007f7e0ffULL, 0x000000103a3b7824ULL, 0x100fe200078e0243ULL,
0x0000000024377faeULL, 0x0003e2000b901c48ULL, 0x000000103c3d7824ULL, 0x000fc400078e0243ULL,
0x00000001092b7824ULL, 0x040fe200000e062bULL, 0x0000000026397faeULL, 0x0003e2000b901c48ULL,
0x000000103e3f7824ULL, 0x000fe400078e0243ULL, 0x0000000109317824ULL, 0x040fe200008e0631ULL,
0x00000000283b7faeULL, 0x0003e2000b901c48ULL, 0x0000001040417824ULL, 0x000fe400078e0243ULL,
0x0000000109337824ULL, 0x000fe200010e0633ULL, 0x000000002a3d7faeULL, 0x0003e2000b901c48ULL,
0x0000001042437824ULL, 0x000fc400078e0243ULL, 0x0000000109097824ULL, 0x000fe200018e0635ULL,
0x00000000303f7faeULL, 0x0003e8000b901c48ULL, 0x0000000032417faeULL, 0x0003e8000b901c48ULL,
0x0000000008437faeULL, 0x0003e4000b901c48ULL, 0x00000300ff087624ULL, 0x002fe200078e00ffULL,
0x000000010b097812ULL, 0x000fe200078ec0ffULL, 0xffffffffff4c7424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000010900780cULL, 0x000fc40003f05070ULL,
0xffffffff08087811ULL, 0x000fc800078e08ffULL, 0x0000000108087807ULL, 0x000fca0004000000ULL,
0x00000001080b7824ULL, 0x000fca00078e020bULL, 0x0000006d0b00720cULL, 0x000fda0003f06070ULL,
0x000000016c088824ULL, 0x000fe400078e020bULL, 0x00000004ff098424ULL, 0x000fc800078e00ffULL,
0x0000640008088625ULL, 0x000fca00078e0009ULL, 0x00000008084c8981ULL, 0x000322000c1e1900ULL,
0xffffffe06e0a7812ULL, 0x040fe400078ec0ffULL, 0x000000106e0d7812ULL, 0x040fe400078ec0ffULL,
0x000000086e0e7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e0a7210ULL, 0x000fe20007ffe00dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x013608000a247f8cULL, 0x0022a4000c80043fULL,
0x0000000000087805ULL, 0x000fc40000015200ULL, 0x01360c000a0d7984ULL, 0x000ee40000000800ULL,
0x800000000dff7812ULL, 0x00cfe40007804825ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff267224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e080e7210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e09ULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc8000001140fULL, 0x0000000e0d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e060fULL, 0x000000020d0d7819ULL, 0x000fc8000000120eULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000126267810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01360c000a0d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe40007804825ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010036b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff707819ULL, 0x000fe20000011603ULL, 0x00000020005c7824ULL, 0x000fe400078e00ffULL,
0xffffffffff747424ULL, 0x000fe200078e00ffULL, 0x000000706b6b7812ULL, 0x000fc400078ec0ffULL,
0xffffff805c5c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c70707812ULL, 0x000fc800078ec0ffULL,
0x0000005c70087210ULL, 0x000fca0007ffe06bULL, 0x01300000080d7984ULL, 0x000ea80000000800ULL,
0x01320000080a7984ULL, 0x0022e20000000800ULL, 0x0000000c0d00720bULL, 0x004fe20003f1d000ULL,
0x000107c27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000097806ULL, 0x002fc800000e0100ULL,
0x0000ffff09257812ULL, 0x000fe2000782c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff087224ULL, 0x000fe400078e000cULL,
0x0000001fff767424ULL, 0x000fc400078e00ffULL, 0xffffffffff757424ULL, 0x000fcc00078e00ffULL,
0x0000043000009947ULL, 0x000fea0003800000ULL, 0x00000002ff097819ULL, 0x000fe40000011600ULL,
0x0000000c0d00720bULL, 0x000fe40003f34000ULL, 0x000000000900720cULL, 0x000fe20003f05270ULL,
0x000107427f007947ULL, 0x000fd4000b800000ULL, 0x0000000000247806ULL, 0x000fc400008e0100ULL,
0x0000008000098824ULL, 0x000fe200078e026bULL, 0x0000000c0d087209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x00009910240e7816ULL, 0x000fe200000000ffULL,
0x0000000170098824ULL, 0x000fca00078e0209ULL, 0x0134000809008388ULL, 0x0003e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000c08097221ULL, 0x002fe20000010100ULL, 0x000000ff24ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x00000009000c7308ULL, 0x000e640000000800ULL, 0x0000000c07077220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff097819ULL, 0x000fe20000011603ULL,
0x000106727f007947ULL, 0x000fea000b800000ULL, 0x00001f090c097589ULL, 0x0002a400000e0000ULL,
0x0000000910107220ULL, 0x084fe20000410000ULL, 0x0000000911117220ULL, 0x080fe20000410000ULL,
0x0000000914147220ULL, 0x080fe20000410000ULL, 0x0000000915157220ULL, 0x080fe20000410000ULL,
0x0000000918187220ULL, 0x080fe20000410000ULL, 0x0000000919197220ULL, 0x080fe20000410000ULL,
0x0000000950507220ULL, 0x080fe20000410000ULL, 0x0000000951517220ULL, 0x080fe20000410000ULL,
0x0000000954547220ULL, 0x080fe20000410000ULL, 0x0000000955557220ULL, 0x080fe20000410000ULL,
0x000000092c2c7220ULL, 0x080fe20000410000ULL, 0x000000092d2d7220ULL, 0x080fe20000410000ULL,
0x0000000920207220ULL, 0x080fe20000410000ULL, 0x0000000921217220ULL, 0x080fe20000410000ULL,
0x000000091c1c7220ULL, 0x080fe20000410000ULL, 0x000000091d1d7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0024ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803097811ULL, 0x000fe200078ff0ffULL,
0x000105527f007947ULL, 0x000fea000b800000ULL, 0x00001f090c097589ULL, 0x00046400000e0000ULL,
0x0000000912127220ULL, 0x086fe20000410000ULL, 0x0000000913137220ULL, 0x080fe20000410000ULL,
0x0000000916167220ULL, 0x080fe20000410000ULL, 0x0000000917177220ULL, 0x080fe20000410000ULL,
0x000000091a1a7220ULL, 0x080fe20000410000ULL, 0x000000091b1b7220ULL, 0x080fe20000410000ULL,
0x0000000952527220ULL, 0x080fe20000410000ULL, 0x0000000953537220ULL, 0x080fe20000410000ULL,
0x0000000956567220ULL, 0x080fe20000410000ULL, 0x0000000957577220ULL, 0x080fe20000410000ULL,
0x000000092e2e7220ULL, 0x080fe20000410000ULL, 0x000000092f2f7220ULL, 0x080fe20000410000ULL,
0x0000000922227220ULL, 0x080fe20000410000ULL, 0x0000000923237220ULL, 0x080fe20000410000ULL,
0x000000091e1e7220ULL, 0x080fe20000410000ULL, 0x000000091f1f7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff25ff7812ULL, 0x000fda0007806024ULL,
0x800000080d0d0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL,
0x0000000d00040308ULL, 0x000e640000000800ULL, 0x000000040a0a0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x000000070a077221ULL, 0x008fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000004ff05723eULL, 0x000fe400000000ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011603ULL, 0x00005410050a7816ULL, 0x000fe20000000005ULL,
0x000103927f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0a057589ULL, 0x0002a400000e0000ULL,
0x000000080d097810ULL, 0x000fe20007ffe0ffULL, 0x000103c27f007947ULL, 0x000fea000b800000ULL,
0x00001f090a067589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100d097810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000aULL,
0x000030c0000f7802ULL, 0x000fc40000000f00ULL, 0x00010d8000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180d097810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0x00003110000f7802ULL, 0x000fc40000000f00ULL,
0x00010d3000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002004e7824ULL, 0x000fe200078e00ffULL, 0x00000007030d7812ULL, 0x002fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x000000044e0a7812ULL, 0x008fc400078ec0ffULL,
0x000000080d0c7812ULL, 0x000fe400078ef803ULL, 0x0000000a03097211ULL, 0x044fe200078fe0ffULL,
0x00000200000a7824ULL, 0x000fe400078e00ffULL, 0x000000080c5d7824ULL, 0x040fe400078e00ffULL,
0x000000010c687824ULL, 0x000fe200078e0209ULL, 0xfffff8000a0e7812ULL, 0x000fe400078ec0ffULL,
0x00000008030a7812ULL, 0x000fc400078ec0ffULL, 0xfffffff85d5d7812ULL, 0x000fca00078ee268ULL,
0x000000105d5d7824ULL, 0x000fc800078e020eULL, 0x00000004ff267819ULL, 0x000fe20000011603ULL,
0x009000005d38783bULL, 0x000e620000000200ULL, 0x0000000d0a0f7212ULL, 0x000fe200078efcffULL,
0x000059004c4c7a24ULL, 0x010fe200078e02ffULL, 0x00000001ff097819ULL, 0x000fe40000011600ULL,
0x000000100a287812ULL, 0x000fe200078efe0dULL, 0x0000000126247824ULL, 0x000fe200078e020fULL,
0xfffffff84e4e7812ULL, 0x000fe200078ec0ffULL, 0x00000002090a7824ULL, 0x000fe200078e026aULL,
0x0000002803657211ULL, 0x000fe200078fe0ffULL, 0x000000080f257824ULL, 0x000fe200078e00ffULL,
0x00000002245f7810ULL, 0x040fe20007ffe0ffULL, 0x00000004090d7824ULL, 0x000fe200078e0226ULL,
0x00000004245e7810ULL, 0x000fe20007ffe0ffULL, 0x000000080f2a7824ULL, 0x000fe200078e00ffULL,
0xfffffff825607812ULL, 0x000fe200078ee224ULL, 0x000020000a0a7824ULL, 0x000fe200078e00ffULL,
0x0000000624617810ULL, 0x000fe20007ffe0ffULL, 0x000000080f277824ULL, 0x000fe200078e00ffULL,
0x000000020d0d7810ULL, 0x000fe20007ffe00cULL, 0x000000080f267824ULL, 0x000fe200078e00ffULL,
0xfffffff82a5f7812ULL, 0x000fe200078ee25fULL, 0x000000080c247824ULL, 0x000fe200078e00ffULL,
0x0000b0000a0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000828307824ULL, 0x040fe200078e00ffULL,
0xfffffff8275e7812ULL, 0x000fe200078ee25eULL, 0x00000008280f7824ULL, 0x000fe200078e00ffULL,
0xfffffff826617812ULL, 0x000fe200078ee261ULL, 0x000000105f587824ULL, 0x100fe200078e020cULL,
0xfffffff8240d7812ULL, 0x000fe200078ee20dULL, 0x000000105e447824ULL, 0x100fe200078e020cULL,
0x0000000465637810ULL, 0x040fe20007ffe0ffULL, 0x0000001060407824ULL, 0x100fe200078e020cULL,
0x0000000265647810ULL, 0x000fe20007ffe0ffULL, 0x00000010613c7824ULL, 0x000fe200078e020cULL,
0x000000005858783bULL, 0x000ea20000004200ULL, 0x000000100d4d7824ULL, 0x000fe200078e00ffULL,
0x0000000665677810ULL, 0x000fe20007ffe0ffULL, 0x00000008282a7824ULL, 0x040fe200078e00ffULL,
0x000000004444783bULL, 0x000ee20000004200ULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0x000090000e0e7810ULL, 0x000fe20007ffe04dULL, 0x0000000538380232ULL, 0x082fe20000000000ULL,
0x000000004040783bULL, 0x000fe20000004200ULL, 0xfffffff830637812ULL, 0x000fe200078ee263ULL,
0x000000053a3a0232ULL, 0x000fe20000000000ULL, 0xfffffff80f647812ULL, 0x000fe200078ee264ULL,
0x000000003c3c783bULL, 0x000fe20000004200ULL, 0xfffffff82a657812ULL, 0x000fe200078ee265ULL,
0x0000001063307824ULL, 0x100fe200078e020cULL, 0xfffffff828677812ULL, 0x000fe200078ee267ULL,
0x000000000e24783bULL, 0x000e620000000200ULL, 0x0000001064347824ULL, 0x100fe200078e020cULL,
0x0000000639390232ULL, 0x080fe20000000000ULL, 0x0000001065287824ULL, 0x100fe200078e020cULL,
0x000000003030783bULL, 0x000e620000004200ULL, 0x00000010670c7824ULL, 0x000fe200078e020cULL,
0x000000063b3b0232ULL, 0x000fc40000000000ULL, 0x000000003434783bULL, 0x000fe80000004200ULL,
0x000000002828783bULL, 0x000e680000004200ULL, 0x000000000c0c783bULL, 0x000e620000004200ULL,
0x000000583848723cULL, 0x044ff00000001818ULL, 0x000000443818723cULL, 0x048ff00000001854ULL,
0x00000046382c723cULL, 0x000f62000000182cULL, 0x0000000524240232ULL, 0x002fc40000000000ULL,
0x0000000526260232ULL, 0x000fe40000000000ULL, 0x0000000625250232ULL, 0x080fe40000000000ULL,
0x0000000627270232ULL, 0x000fe20000000000ULL, 0x000000403844723cULL, 0x040f700000001810ULL,
0x0000005a3850723cULL, 0x040f700000001850ULL, 0x000000423840723cULL, 0x040f700000001814ULL,
0x0000003c3820723cULL, 0x040f700000001820ULL, 0x0000003e3838723cULL, 0x000f70000000181cULL,
0x00000032241c723cULL, 0x060f70000000182cULL, 0x00000028242c723cULL, 0x040f700000001844ULL,
0x000000342410723cULL, 0x040f700000001848ULL, 0x000000362414723cULL, 0x040f700000001850ULL,
0x000000302418723cULL, 0x040f700000001818ULL, 0x0000002a2428723cULL, 0x040f700000001840ULL,
0x0000000c2420723cULL, 0x040b6e0000001820ULL, 0x00000008020c7824ULL, 0x020fe200078e0209ULL,
0x0000000e2424723cULL, 0x000b620000001838ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x00000001020d7810ULL, 0x000fe20007ffe0ffULL, 0x013688004eff7f8cULL, 0x0003e2000c80043fULL,
0x000000800c417811ULL, 0x000fe200078e28ffULL, 0x00000100ff0f7424ULL, 0x020fe200078e00ffULL,
0x000000660d00720cULL, 0x000fe20003f06070ULL, 0x000000804c0c7824ULL, 0x000fe200078e00ffULL,
0x00000060413c7812ULL, 0x000fc600078ec0ffULL, 0x000062000c0c7625ULL, 0x000fc800078e000fULL,
0x00000001693c7824ULL, 0x000fe200078e023cULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff407819ULL, 0x102fe20000011603ULL,
0x00002000000f7824ULL, 0x000fe200078e00ffULL, 0x00000041620e7217ULL, 0x000fe40007800000ULL,
0x0000000440307810ULL, 0x040fe20007ffe0ffULL, 0x0000000140317824ULL, 0x000fe200078e023cULL,
0x0000000e41417210ULL, 0x000fe20007ffe1ffULL, 0x00000080000e7824ULL, 0x000fe200078e00ffULL,
0x0000000840347810ULL, 0x000fe20007ffe0ffULL, 0x0000000130427824ULL, 0x140fe200078e0203ULL,
0x000020000f447812ULL, 0x000fe200078ec0ffULL, 0x00000008300f7824ULL, 0x000fe200078e00ffULL,
0x0000000c40367810ULL, 0x000fe20007ffe0ffULL, 0x00000001343d7824ULL, 0x100fe200078e0203ULL,
0x0000001040387810ULL, 0x000fe20007ffe0ffULL, 0x0000000834327824ULL, 0x000fe200078e00ffULL,
0xfffffff80f427812ULL, 0x000fe200078ee242ULL, 0x0000000130337824ULL, 0x000fe200078e023cULL,
0x000000806b0e7812ULL, 0x000fe200078ef80eULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x0000002041417817ULL, 0x000fe20003800000ULL, 0x00000001363f7824ULL, 0x000fe200078e0203ULL,
0xfffffff8323d7812ULL, 0x000fe200078ee23dULL, 0x00000008363a7824ULL, 0x000fe200078e00ffULL,
0x000000413000720cULL, 0x080fe20003f86070ULL, 0x00000001383e7824ULL, 0x000fe200078e0203ULL,
0x0000001440487810ULL, 0x000fe20007ffe0ffULL, 0x0000000838357824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3f7812ULL, 0x000fe200078ee23fULL, 0x0000010033327825ULL, 0x000fe200078e000eULL,
0x000000413600720cULL, 0x000fc40003f46070ULL, 0xfffffff8353e7812ULL, 0x000fe200078ee23eULL,
0x0000010031307825ULL, 0x000fe200078e000eULL, 0x000000320c3a7210ULL, 0x000fe40007f3e0ffULL,
0x000000413400720cULL, 0x0c0fe20003f66070ULL, 0x0000000134377824ULL, 0x100fe200078e023cULL,
0x000000300c307210ULL, 0x000fe20007f1e0ffULL, 0x0000000136357824ULL, 0x000fe200078e023cULL,
0x000000414000720cULL, 0x000fe20003fa6070ULL, 0x0000400009447824ULL, 0x000fe400078e0244ULL,
0x0000000148097824ULL, 0x000fc400078e0203ULL, 0x0000000848467824ULL, 0x000fe200078e00ffULL,
0x0000b00044447810ULL, 0x000fe20007ffe0ffULL, 0x0000010037367825ULL, 0x000fc600078e000eULL,
0xfffffff846097812ULL, 0x000fe200078ee209ULL, 0x0000000140327824ULL, 0x000fe200078e0203ULL,
0x000000443d3d7211ULL, 0x000fe200078e20ffULL, 0x0000010035347825ULL, 0x000fc600078e000eULL,
0x0000000732467812ULL, 0x000fe200078ec0ffULL, 0x000000010d3b7824ULL, 0x040fe200008e0633ULL,
0x000000413800720cULL, 0x040fe20003f26070ULL, 0x0000000138337824ULL, 0x000fe200078e023cULL,
0x0ffffff846437812ULL, 0x000fe200078ef803ULL, 0x000000010d317824ULL, 0x000fe200000e0631ULL,
0x000000360c387210ULL, 0x040fe20007f1e0ffULL, 0x0000010033327825ULL, 0x000fe200078e000eULL,
0x000000340c367210ULL, 0x000fc60007fde0ffULL, 0x000000010d397824ULL, 0x040fe200000e0637ULL,
0x000000414800720cULL, 0x000fe20003f06070ULL, 0x000000010d377824ULL, 0x040fe200030e0635ULL,
0x000000320c347210ULL, 0x000fe20007fde0ffULL, 0x0000000148477824ULL, 0x000fe400078e023cULL,
0x0000001042457824ULL, 0x100fe200078e0244ULL, 0x0000001840427810ULL, 0x040fe20007ffe0ffULL,
0x000000010d357824ULL, 0x000fe200030e0633ULL, 0x0000001c40407810ULL, 0x000fe20007ffe0ffULL,
0x0000001043437824ULL, 0x000fc400078e0244ULL, 0x0000010047327825ULL, 0x000fc600078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030437faeULL, 0x0003e2000e901c48ULL,
0x0000000142477824ULL, 0x000fe200078e023cULL, 0x000000320c327210ULL, 0x000fe20007fde0ffULL,
0x000000103f3f7824ULL, 0x100fe200078e0244ULL, 0x000000003a457faeULL, 0x0005e2000e101c48ULL,
0x000000414200720cULL, 0x080fe20003fa6070ULL, 0x0000001009097824ULL, 0x000fe200078e0244ULL,
0x000000414000720cULL, 0x040fe20003f86070ULL, 0x0000000140417824ULL, 0x000fe200078e023cULL,
0x00000000383d7faeULL, 0x0007e2000d901c48ULL, 0x000000010d337824ULL, 0x000fc400030e0633ULL,
0x0000010047307825ULL, 0x002fe200078e000eULL, 0x00000000363f7faeULL, 0x0007e6000d101c48ULL,
0x00000001423c7824ULL, 0x100fe200078e0203ULL, 0x000000300c307210ULL, 0x000fe20007fde0ffULL,
0x0000000842437824ULL, 0x000fe400078e00ffULL, 0x00000001403a7824ULL, 0x044fe400078e0203ULL,
0x00000008403b7824ULL, 0x000fc400078e00ffULL, 0x00000100410e7825ULL, 0x000fe200078e000eULL,
0xfffffff843417812ULL, 0x000fe400078ee23cULL, 0xfffffff83b437812ULL, 0x000fe200078ee23aULL,
0x000000010d317824ULL, 0x000fe200030e0631ULL, 0x0000000e0c0e7210ULL, 0x000fe20007fde0ffULL,
0x000000103e3b7824ULL, 0x100fe400078e0244ULL, 0x0000001041417824ULL, 0x100fe400078e0244ULL,
0x0000001043437824ULL, 0x000fe200078e0244ULL, 0x00000000343b7faeULL, 0x0007e2000c901c48ULL,
0x000000010d0f7824ULL, 0x000fc600030e060fULL, 0x0000000032097faeULL, 0x0007e8000c101c48ULL,
0x0000000030417faeULL, 0x0007e8000e901c48ULL, 0x000000000e437faeULL, 0x0007e2000e101c48ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x00002000000e7824ULL, 0x042fe200078e00ffULL,
0x0000000c033d7811ULL, 0x040fe200078fe8ffULL, 0x0000008000347824ULL, 0x000fe200078e00ffULL,
0x0000000403397811ULL, 0x000fc400078fe8ffULL, 0x000020000e0e7812ULL, 0x000fe200078ec0ffULL,
0x000000013d407824ULL, 0x100fe200078e0203ULL, 0x0000001803337811ULL, 0x000fe200078fe8ffULL,
0x000000083d317824ULL, 0x000fe200078e00ffULL, 0x0000000803377811ULL, 0x000fe200078fe8ffULL,
0x0000400009307824ULL, 0x000fe200078e020eULL, 0x0000001c03437811ULL, 0x000fe200078fe8ffULL,
0x0000000139427824ULL, 0x100fe200078e0203ULL, 0xfffffff831407812ULL, 0x000fe200078ee240ULL,
0x0000000839097824ULL, 0x000fe200078e00ffULL, 0x0000001403317811ULL, 0x000fe200078fe8ffULL,
0x0000000833327824ULL, 0x000fe200078e00ffULL, 0x00000010030f7811ULL, 0x000fe200078fe8ffULL,
0x0000000137417824ULL, 0x100fe200078e0203ULL, 0xfffffff809427812ULL, 0x000fe200078ee242ULL,
0x00000001313e7824ULL, 0x100fe200078e0203ULL, 0x000000806b347812ULL, 0x000fe200078ef834ULL,
0x0000000831357824ULL, 0x000fe200078e00ffULL, 0x0000003c033b7211ULL, 0x000fe200078fe8ffULL,
0x0000000133097824ULL, 0x000fe200078e0203ULL, 0x0000b000304b7810ULL, 0x000fe20007ffe0ffULL,
0x00000008370e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8353e7812ULL, 0x000fe200078ee23eULL,
0x0000000843357824ULL, 0x040fe200078e00ffULL, 0xfffffff832097812ULL, 0x000fe200078ee209ULL,
0x0000000143327824ULL, 0x000fe200078e0203ULL, 0xfffffff80e417812ULL, 0x000fe200078ee241ULL,
0x000000010f3f7824ULL, 0x000fc400078e0203ULL, 0x000000080f0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff835467812ULL, 0x000fe200078ee232ULL, 0x000000ffff357224ULL, 0x000fe400078e00ffULL,
0x0000000139397824ULL, 0x100fe200078e023cULL, 0xfffffff80e3f7812ULL, 0x000fe200078ee23fULL,
0x0000000137377824ULL, 0x100fe200078e023cULL, 0x00000003030e7211ULL, 0x000fe200078fe8ffULL,
0x000000013d3d7824ULL, 0x000fe200078e023cULL, 0x0000004b3f3f7211ULL, 0x000fe200078e20ffULL,
0x000001003b3a7825ULL, 0x000fe200078e0034ULL, 0x000000070e0e7812ULL, 0x000fc600078ec0ffULL,
0x0000010039387825ULL, 0x000fe200078e0034ULL, 0x0ffffff80e447812ULL, 0x000fe400078ef803ULL,
0x0000003a0c3a7210ULL, 0x040fe20007f1e0ffULL, 0x000000010f0f7824ULL, 0x100fe200078e023cULL,
0x000000380c387210ULL, 0x000fe20007f3e0ffULL, 0x0000000131317824ULL, 0x100fe400078e023cULL,
0x0000000133337824ULL, 0x100fe400078e023cULL, 0x0000000143437824ULL, 0x000fc400078e023cULL,
0x0000010037367825ULL, 0x000fc800078e0034ULL, 0x000001003d3c7825ULL, 0x000fe200078e0034ULL,
0x000000360c367210ULL, 0x000fc60007f5e0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0034ULL,
0x0000003c0c3c7210ULL, 0x000fc60007f7e0ffULL, 0x0000010031307825ULL, 0x000fc800078e0034ULL,
0x0000010033327825ULL, 0x000fc800078e0034ULL, 0x0000010043347825ULL, 0x000fc800078e0034ULL,
0x000000010d3b7824ULL, 0x040fe200000e063bULL, 0x0000000e0c0e7210ULL, 0x040fe20007f1e0ffULL,
0x000000010d397824ULL, 0x040fe200008e0639ULL, 0x000000300c307210ULL, 0x000fe20007f3e0ffULL,
0x0000001044437824ULL, 0x000fe400078e024bULL, 0x000000010d377824ULL, 0x040fe200010e0637ULL,
0x000000320c327210ULL, 0x000fe20007f5e0ffULL, 0x0000001042457824ULL, 0x000fe200078e024bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a437faeULL, 0x0003e2000b901c48ULL,
0x000000010d3d7824ULL, 0x000fe200018e063dULL, 0x000000340c347210ULL, 0x000fe20007f7e0ffULL,
0x0000001041417824ULL, 0x100fe200078e024bULL, 0x0000000038457faeULL, 0x0003e2000b901c48ULL,
0x0000001040477824ULL, 0x000fc400078e024bULL, 0x000000010d0f7824ULL, 0x040fe200000e060fULL,
0x0000000036417faeULL, 0x0003e2000b901c48ULL, 0x000000103e497824ULL, 0x000fe400078e024bULL,
0x000000010d317824ULL, 0x000fe200008e0631ULL, 0x000000003c477faeULL, 0x0003e2000b901c48ULL,
0x0000001009097824ULL, 0x000fe400078e024bULL, 0x000000010d337824ULL, 0x000fe200010e0633ULL,
0x000000000e3f7faeULL, 0x0003e2000b901c48ULL, 0x00000010464b7824ULL, 0x000fc400078e024bULL,
0x000000010d357824ULL, 0x000fe200018e0635ULL, 0x0000000030497faeULL, 0x0003e8000b901c48ULL,
0x0000000032097faeULL, 0x0003e8000b901c48ULL, 0x00000000344b7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe06e097812ULL, 0x00afc400078ec0ffULL,
0x000000106e0e7812ULL, 0x040fe400078ec0ffULL, 0x000000086e0f7812ULL, 0x000fc800078ec0ffULL,
0x000000090f347210ULL, 0x000fe20007ffe00eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01362800340e7f8cULL, 0x0002a4000c80043fULL, 0x0000000000307805ULL, 0x000fc40000015200ULL,
0x01362c0034097984ULL, 0x000ee40000000800ULL, 0x8000000009ff7812ULL, 0x00cfe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230327210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003200780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403200780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff097819ULL, 0x000fc80000011433ULL,
0x0000003209097211ULL, 0x000fca00078110ffULL, 0x000000ffff327224ULL, 0x000fca00000e0633ULL,
0x0000000209097819ULL, 0x000fc80000001232ULL, 0x000000090000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000135357810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01362c0034097984ULL, 0x000ea40000000800ULL,
0x8000000009ff7812ULL, 0x004fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000806b097810ULL, 0x000fca0007ffe05cULL, 0x0000000170097824ULL, 0x000fca00078e0209ULL,
0x0130000009317984ULL, 0x000ea80000000800ULL, 0x0132000009307984ULL, 0x0006620000000800ULL,
0x000000083100720bULL, 0x004fe20003f1d000ULL, 0x0000ed327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000097806ULL, 0x008fc800000e0100ULL, 0x0000ffff09337812ULL, 0x000fe2000782c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x0000000100097811ULL, 0x000fe400078ff0ffULL,
0x000000083100720bULL, 0x000fe40003f34000ULL, 0x000000000900720cULL, 0x000fe20003f05270ULL,
0x0000ece27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000327806ULL, 0x000fc400008e0100ULL,
0x00000080000f8824ULL, 0x000fe200078e026bULL, 0x0000000831098209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x00009910320e7816ULL, 0x000fe200000000ffULL,
0x0000000170348824ULL, 0x002fca00078e020fULL, 0x0134000934008388ULL, 0x0003e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000831097209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff32ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000809097221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x0000000900347308ULL, 0x000e640000000800ULL,
0x0000003407077220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff097819ULL, 0x000fe20000011603ULL, 0x0000ec027f007947ULL, 0x000fea000b800000ULL,
0x00001f0934097589ULL, 0x0002a400000e0000ULL, 0x000000092c2c7220ULL, 0x084fe20000410000ULL,
0x000000092d2d7220ULL, 0x080fe20000410000ULL, 0x0000000928287220ULL, 0x080fe20000410000ULL,
0x0000000929297220ULL, 0x080fe20000410000ULL, 0x0000000910107220ULL, 0x080fe20000410000ULL,
0x0000000911117220ULL, 0x080fe20000410000ULL, 0x0000000914147220ULL, 0x080fe20000410000ULL,
0x0000000915157220ULL, 0x080fe20000410000ULL, 0x0000000918187220ULL, 0x080fe20000410000ULL,
0x0000000919197220ULL, 0x080fe20000410000ULL, 0x000000091c1c7220ULL, 0x080fe20000410000ULL,
0x000000091d1d7220ULL, 0x080fe20000410000ULL, 0x0000000920207220ULL, 0x080fe20000410000ULL,
0x0000000921217220ULL, 0x080fe20000410000ULL, 0x0000000924247220ULL, 0x080fe20000410000ULL,
0x0000000925257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0032ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803097811ULL, 0x000fe200078ff0ffULL, 0x0000eae27f007947ULL, 0x000fea000b800000ULL,
0x00001f0934097589ULL, 0x0004e400000e0000ULL, 0x000000092e2e7220ULL, 0x08cfe20000410000ULL,
0x000000092f2f7220ULL, 0x080fe20000410000ULL, 0x000000092a2a7220ULL, 0x080fe20000410000ULL,
0x000000092b2b7220ULL, 0x080fe20000410000ULL, 0x0000000912127220ULL, 0x080fe20000410000ULL,
0x0000000913137220ULL, 0x080fe20000410000ULL, 0x0000000916167220ULL, 0x080fe20000410000ULL,
0x0000000917177220ULL, 0x080fe20000410000ULL, 0x000000091a1a7220ULL, 0x080fe20000410000ULL,
0x000000091b1b7220ULL, 0x080fe20000410000ULL, 0x000000091e1e7220ULL, 0x080fe20000410000ULL,
0x000000091f1f7220ULL, 0x080fe20000410000ULL, 0x0000000922227220ULL, 0x080fe20000410000ULL,
0x0000000923237220ULL, 0x080fe20000410000ULL, 0x0000000926267220ULL, 0x080fe20000410000ULL,
0x0000000927277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff33ff7812ULL, 0x000fe40007806032ULL, 0x0000000831087209ULL, 0x000fd60007810000ULL,
0x8000000831310221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL,
0x0000003100040308ULL, 0x000e640000000800ULL, 0x0000000430300220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x0000000730077221ULL, 0x002fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000004ff05723eULL, 0x000fe400000000ffULL,
0x00000002ff317819ULL, 0x000fe40000011603ULL, 0x0000541005307816ULL, 0x000fe20000000005ULL,
0x0000e9127f007947ULL, 0x000fea000b800000ULL, 0x00001f3130057589ULL, 0x0002a400000e0000ULL,
0x0000000831097810ULL, 0x000fe20007ffe0ffULL, 0x0000e9427f007947ULL, 0x000fea000b800000ULL,
0x00001f0930067589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001031097810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0030ULL,
0x00004d00000f7802ULL, 0x000fc40000000f00ULL, 0x0000f14000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001831097810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x00004d50000f7802ULL, 0x000fc40000000f00ULL,
0x0000f0f000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x0000c0000a0a7810ULL, 0x000fe20007ffe0ffULL,
0x009800005d44783bULL, 0x000f220000000200ULL, 0x00000002ff097819ULL, 0x00cfc40000011600ULL,
0x0000000a67347211ULL, 0x000fe200078e20ffULL, 0x0000001060547824ULL, 0x100fe200078e020aULL,
0x00013690090e7811ULL, 0x000fe200078e18ffULL, 0x000000105f507824ULL, 0x100fe400078e020aULL,
0x000000105e587824ULL, 0x100fe200078e020aULL, 0x000000003434783bULL, 0x000fe20000004200ULL,
0x0000001061487824ULL, 0x100fe400078e020aULL, 0x0000080009307824ULL, 0x002fe200078e024dULL,
0x000000005454783bULL, 0x000e620000004200ULL, 0x0000001065407824ULL, 0x000fc400078e020aULL,
0x00000010643c7824ULL, 0x100fe200078e020aULL, 0x000000005050783bULL, 0x000ea20000004200ULL,
0x0000001063387824ULL, 0x000fe200078e020aULL, 0x00000001ff0a7819ULL, 0x000fe40000011600ULL,
0x000000005858783bULL, 0x000fe60000004200ULL, 0x00000008020f7824ULL, 0x000fe200078e020aULL,
0x000000004848783bULL, 0x000fe80000004200ULL, 0x009800003030783bULL, 0x000ee80000000200ULL,
0x000000004040783bULL, 0x000ee80000004200ULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x0000000544440232ULL, 0x010fc60000000000ULL, 0x000000003838783bULL, 0x000f220000004200ULL,
0x0000000546460232ULL, 0x000fe40000000000ULL, 0x0000000645450232ULL, 0x080fe40000000000ULL,
0x0000000647470232ULL, 0x000fce0000000000ULL, 0x00000054442c723cULL, 0x042f70000000182cULL,
0x000000564428723cULL, 0x040f700000001828ULL, 0x00000050444c723cULL, 0x004f620000001810ULL,
0x0000000530300232ULL, 0x008fc40000000000ULL, 0x0000000532320232ULL, 0x000fe40000000000ULL,
0x0000000631310232ULL, 0x080fe40000000000ULL, 0x0000000633330232ULL, 0x000fe20000000000ULL,
0x000000524450723cULL, 0x040f700000001814ULL, 0x000000584454723cULL, 0x040f700000001818ULL,
0x0000005a441c723cULL, 0x040f70000000181cULL, 0x000000484420723cULL, 0x040f700000001820ULL,
0x0000004a4424723cULL, 0x000f700000001824ULL, 0x000000403010723cULL, 0x060b70000000182cULL,
0x000000423014723cULL, 0x040b700000001828ULL, 0x0000003c3018723cULL, 0x040b70000000184cULL,
0x0000003e3050723cULL, 0x040b700000001850ULL, 0x000000383054723cULL, 0x050b700000001854ULL,
0x0000003a301c723cULL, 0x040b70000000181cULL, 0x000000343020723cULL, 0x040b700000001820ULL,
0x000000363030723cULL, 0x000b620000001824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000000102257810ULL, 0x020fe20007ffe0ffULL, 0x000000000eff7f8cULL, 0x0003e2000c80043fULL,
0x000000c00f0f7811ULL, 0x000fc400078e28ffULL, 0x000000662500720cULL, 0x000fe40003f06070ULL,
0x000000600f347812ULL, 0x000fca00078ec0ffULL, 0x0000000169347824ULL, 0x000fe200078e0234ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff397819ULL, 0x002fe40000011603ULL, 0x0000000f620e7217ULL, 0x000fe40007800000ULL,
0x0000000439277810ULL, 0x040fe20007ffe0ffULL, 0x0000000139257824ULL, 0x040fe200078e0234ULL,
0x00000008392b7810ULL, 0x040fe20007ffe0ffULL, 0x000000010e0e7824ULL, 0x000fe200078e0a0fULL,
0x0000000c39297810ULL, 0x000fe20007ffe0ffULL, 0x00000001273b7824ULL, 0x100fe200078e0203ULL,
0x00000010393d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000827247824ULL, 0x000fe200078e00ffULL,
0x000000200e3a7817ULL, 0x000fe20003800000ULL, 0x000000012b367824ULL, 0x000fe200078e0203ULL,
0x0000001439417810ULL, 0x000fe20007ffe0ffULL, 0x000000082b0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8243b7812ULL, 0x000fe200078ee23bULL, 0x0000008000247824ULL, 0x000fe200078e00ffULL,
0x0000003a2700720cULL, 0x080fe20003f86070ULL, 0x0000000129357824ULL, 0x000fe200078e0203ULL,
0xfffffff80f367812ULL, 0x000fe200078ee236ULL, 0x0000000829267824ULL, 0x000fe200078e00ffULL,
0x000000806b0e7812ULL, 0x000fe200078ef824ULL, 0x0000000127277824ULL, 0x000fe200078e0234ULL,
0x0000003a2b00720cULL, 0x080fe20003f66070ULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0xfffffff826357812ULL, 0x000fe200078ee235ULL, 0x000000013d387824ULL, 0x000fe200078e0203ULL,
0x0000003a2900720cULL, 0x080fe20003f46070ULL, 0x0000010027267825ULL, 0x000fe200078e000eULL,
0x0000003a3900720cULL, 0x000fc40003fa6070ULL, 0x0000001c39437810ULL, 0x000fe20007ffe0ffULL,
0x000000083d2d7824ULL, 0x000fe200078e00ffULL, 0x000000260c2e7210ULL, 0x000fe20007f3e0ffULL,
0x0000010025247825ULL, 0x000fc600078e000eULL, 0xfffffff82d387812ULL, 0x000fe200078ee238ULL,
0x000000010d2f7824ULL, 0x000fe200008e0627ULL, 0x000000240c247210ULL, 0x000fe20007f1e0ffULL,
0x0000200000277824ULL, 0x000fe200078e00ffULL, 0x0000003a3d00720cULL, 0x000fe20003f26070ULL,
0x0000000141377824ULL, 0x040fe400078e0203ULL, 0x0000000841287824ULL, 0x000fe200078e00ffULL,
0x00002000272d7812ULL, 0x000fe200078ec0ffULL, 0x000000012b2b7824ULL, 0x100fe400078e0234ULL,
0x0000000129297824ULL, 0x000fe200078e0234ULL, 0xfffffff828377812ULL, 0x000fe200078ee237ULL,
0x0000000139267824ULL, 0x000fc400078e0203ULL, 0x000001002b2a7825ULL, 0x000fc600078e000eULL,
0x00000007263c7812ULL, 0x000fe200078ec0ffULL, 0x0000010029287825ULL, 0x000fc800078e000eULL,
0x000000013d277824ULL, 0x000fe200078e0234ULL, 0x0ffffff83c3d7812ULL, 0x000fe200078ef803ULL,
0x000040000a3e7824ULL, 0x000fe400078e022dULL, 0x000000010d257824ULL, 0x000fe200000e0625ULL,
0x0000002a0c2c7210ULL, 0x040fe20007f1e0ffULL, 0x0000010027267825ULL, 0x000fe200078e000eULL,
0x000000280c2a7210ULL, 0x000fe40007fde0ffULL, 0x0000c0003e3c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010d2d7824ULL, 0x000fe200000e062bULL, 0x0000003a4100720cULL, 0x000fe20003f06070ULL,
0x000000010d2b7824ULL, 0x000fe200030e0629ULL, 0x000000260c287210ULL, 0x000fe20007fde0ffULL,
0x000000103d3f7824ULL, 0x000fc400078e023cULL, 0x00000001413d7824ULL, 0x000fe400078e0234ULL,
0x000000010d297824ULL, 0x000fe200030e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000243f7faeULL, 0x0003e2000e901c48ULL, 0x000001003d267825ULL, 0x000fe200078e000eULL,
0x00000018393d7810ULL, 0x000fc60007ffe0ffULL, 0x000000103b417824ULL, 0x000fe200078e023cULL,
0x000000260c267210ULL, 0x000fe20007fde0ffULL, 0x000000013d397824ULL, 0x140fe200078e0234ULL,
0x0000003a3d00720cULL, 0x080fe20003fa6070ULL, 0x00000001433b7824ULL, 0x000fe200078e0234ULL,
0x000000002e417faeULL, 0x0005e2000e101c48ULL, 0x000000010d277824ULL, 0x000fe200030e0627ULL,
0x0000003a4300720cULL, 0x000fe20003f86070ULL, 0x0000010039247825ULL, 0x002fc800078e000eULL,
0x000000013d347824ULL, 0x000fe200078e0203ULL, 0x000000240c247210ULL, 0x000fe20007fde0ffULL,
0x000001003b0e7825ULL, 0x000fe200078e000eULL, 0x000000033d3d7819ULL, 0x000fc600000006ffULL,
0x00000001432e7824ULL, 0x004fe200078e0203ULL, 0xfffffff83d3b7812ULL, 0x000fe200078ee234ULL,
0x0000000843437824ULL, 0x000fe400078e00ffULL, 0x000000010d257824ULL, 0x000fe200030e0625ULL,
0x0000000e0c0c7210ULL, 0x000fe20007fde0ffULL, 0x00000010362f7824ULL, 0x000fe200078e023cULL,
0xfffffff8433d7812ULL, 0x000fe200078ee22eULL, 0x0000001035357824ULL, 0x100fe400078e023cULL,
0x0000001038397824ULL, 0x100fe200078e023cULL, 0x000000002c2f7faeULL, 0x0003e2000d901c48ULL,
0x0000001037377824ULL, 0x000fc400078e023cULL, 0x000000103b3b7824ULL, 0x100fe200078e023cULL,
0x000000002a357faeULL, 0x0003e2000d101c48ULL, 0x000000103d3d7824ULL, 0x000fe400078e023cULL,
0x000000010d0d7824ULL, 0x000fe200030e060fULL, 0x0000000028397faeULL, 0x0003e8000c901c48ULL,
0x0000000026377faeULL, 0x0003e8000c101c48ULL, 0x00000000243b7faeULL, 0x0003e8000e901c48ULL,
0x000000000c3d7faeULL, 0x0003e2000e101c48ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000000803357811ULL, 0x042fe200078fe8ffULL, 0x00000080002a7824ULL, 0x000fe200078e00ffULL,
0x0000001003257811ULL, 0x000fc400078fe8ffULL, 0x00000004032f7811ULL, 0x000fe200078fe8ffULL,
0x0000000135387824ULL, 0x100fe200078e0203ULL, 0x0000001803297811ULL, 0x000fe200078fe8ffULL,
0x00000008350f7824ULL, 0x000fe200078e00ffULL, 0x0000000c03247811ULL, 0x000fe200078fe8ffULL,
0x00000001253a7824ULL, 0x100fe200078e0203ULL, 0x0000001403277811ULL, 0x000fe200078fe8ffULL,
0x000000012f377824ULL, 0x100fe200078e0203ULL, 0xfffffff80f387812ULL, 0x000fe200078ee238ULL,
0x00000008250f7824ULL, 0x000fe200078e00ffULL, 0x0000001c033d7811ULL, 0x000fe200078fe8ffULL,
0x000000082f0e7824ULL, 0x000fe200078e00ffULL, 0x000000806b2a7812ULL, 0x000fe200078ef82aULL,
0x0000000129367824ULL, 0x000fe200078e0203ULL, 0xfffffff80f3a7812ULL, 0x000fe200078ee23aULL,
0x00000008292b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e377812ULL, 0x000fe200078ee237ULL,
0x00002000000f7824ULL, 0x000fe200078e00ffULL, 0x00000034032d7211ULL, 0x000fe200078fe8ffULL,
0x0000000124397824ULL, 0x140fe200078e0203ULL, 0xfffffff82b367812ULL, 0x000fe200078ee236ULL,
0x00000008240e7824ULL, 0x000fe200078e00ffULL, 0x000020000f2b7812ULL, 0x000fe200078ec0ffULL,
0x00000001273b7824ULL, 0x000fc400078e0203ULL, 0x0000000827267824ULL, 0x000fe200078e00ffULL,
0xfffffff80e397812ULL, 0x000fe200078ee239ULL, 0x00000001240f7824ULL, 0x100fe200078e0234ULL,
0x00000003030e7211ULL, 0x000fe200078fe8ffULL, 0x000040000a247824ULL, 0x000fe200078e022bULL,
0xfffffff8263b7812ULL, 0x000fe200078ee23bULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0x000000070e0e7812ULL, 0x000fe200078ec0ffULL, 0x000000012f2f7824ULL, 0x100fe400078e0234ULL,
0x0000000135357824ULL, 0x000fe200078e0234ULL, 0x0ffffff80e3c7812ULL, 0x100fe200078ef803ULL,
0x000000013d267824ULL, 0x000fc400078e0203ULL, 0x000000083d3f7824ULL, 0x000fe400078e00ffULL,
0x000001002d2c7825ULL, 0x000fc600078e002aULL, 0xfffffff83f3e7812ULL, 0x000fe200078ee226ULL,
0x0000000125257824ULL, 0x100fe200078e0234ULL, 0x0000c000243f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000127277824ULL, 0x100fe200078e0234ULL, 0x0000002c0c2c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000129297824ULL, 0x100fe400078e0234ULL, 0x000000013d3d7824ULL, 0x000fe400078e0234ULL,
0x000001002f2e7825ULL, 0x000fc800078e002aULL, 0x0000010035347825ULL, 0x000fe200078e002aULL,
0x0000002e0c2e7210ULL, 0x000fc60007f3e0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e002aULL,
0x000000340c347210ULL, 0x000fc60007f5e0ffULL, 0x0000010025247825ULL, 0x000fe200078e002aULL,
0x0000000e0c0e7210ULL, 0x000fc60007f7e0ffULL, 0x0000010027267825ULL, 0x000fc800078e002aULL,
0x0000010029287825ULL, 0x000fc800078e002aULL, 0x000001003d2a7825ULL, 0x000fe200078e002aULL,
0x0000003f3c3d7211ULL, 0x000fc600078e20ffULL, 0x000000010d2d7824ULL, 0x040fe200000e062dULL,
0x000000240c247210ULL, 0x040fe20007f1e0ffULL, 0x000000010d2f7824ULL, 0x040fe200008e062fULL,
0x000000260c267210ULL, 0x040fe20007f3e0ffULL, 0x000000010d357824ULL, 0x000fe200010e0635ULL,
0x000000280c287210ULL, 0x040fe20007f5e0ffULL, 0x0000001037377824ULL, 0x000fe200078e023fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c3d7faeULL, 0x0003e2000b901c48ULL,
0x000000010d0f7824ULL, 0x000fe200018e060fULL, 0x0000002a0c0c7210ULL, 0x000fe20007f7e0ffULL,
0x0000001038417824ULL, 0x100fe200078e023fULL, 0x000000002e377faeULL, 0x0003e2000b901c48ULL,
0x0000001039397824ULL, 0x000fc400078e023fULL, 0x000000103a437824ULL, 0x000fe200078e023fULL,
0x0000000034417faeULL, 0x0003e2000b901c48ULL, 0x000000010d257824ULL, 0x000fe400000e0625ULL,
0x000000103b3b7824ULL, 0x000fe200078e023fULL, 0x000000000e397faeULL, 0x0003e2000b901c48ULL,
0x000000010d277824ULL, 0x040fe400008e0627ULL, 0x0000001036457824ULL, 0x000fe200078e023fULL,
0x0000000024437faeULL, 0x0003e2000b901c48ULL, 0x000000010d297824ULL, 0x000fc400010e0629ULL,
0x000000103e3f7824ULL, 0x000fe200078e023fULL, 0x00000000263b7faeULL, 0x0003e2000b901c48ULL,
0x000000010d0d7824ULL, 0x000fc600018e062bULL, 0x0000000028457faeULL, 0x0003e8000b901c48ULL,
0x000000000c3f7faeULL, 0x0003e4000b901c48ULL, 0x00000300ff0c7624ULL, 0x002fe200078e00ffULL,
0x000000010b0d7812ULL, 0x000fe200078ec0ffULL, 0xffffffffff597424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000010d00780cULL, 0x000fe40003f05070ULL,
0xffffffff0c0c7811ULL, 0x000fc800078e08ffULL, 0x000000010c0c7807ULL, 0x000fca0004000000ULL,
0x000000010b0b7824ULL, 0x000fca00078e020cULL, 0x0000006d0b00720cULL, 0x000fda0003f06070ULL,
0x000000010b0c8824ULL, 0x000fe400078e026cULL, 0x00000004ff0d8424ULL, 0x000fc800078e00ffULL,
0x000064000c0c8625ULL, 0x000fca00078e000dULL, 0x000000080c598981ULL, 0x000322000c1e1900ULL,
0x000000106e0e7812ULL, 0x000fca00078ec0ffULL, 0x0000002009097824ULL, 0x000fe200078e020eULL,
0x000000086e0e7812ULL, 0x000fca00078ec0ffULL, 0x000000010e097824ULL, 0x000fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01364800090c7f8cULL, 0x0022a4000c80043fULL,
0x00000000000e7805ULL, 0x000fc40000015200ULL, 0x01364c0009257984ULL, 0x000ee40000000800ULL,
0x8000000025ff7812ULL, 0x00cfe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff267224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x000000240e277210ULL, 0x000fca0007f1e1ffULL, 0x0000000125257824ULL, 0x000fe200000e0e0fULL,
0x003d09002700780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402700780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011425ULL, 0x0000002724247211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x0000000224247819ULL, 0x000fc80000001225ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000126267810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01364c0009257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x004fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001006b097810ULL, 0x002fca0007ffe05cULL,
0x0000000170097824ULL, 0x000fca00078e0209ULL, 0x01300000090d7984ULL, 0x000e680000000800ULL,
0x01320000090c7984ULL, 0x0004e20000000800ULL, 0x000000080d00720bULL, 0x002fe20003f1d000ULL,
0x0000d5027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000097806ULL, 0x004fc800000e0100ULL,
0x0000ffff09257812ULL, 0x000fe2000782c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x0000000200097811ULL, 0x000fe400078ff0ffULL, 0x000000080d00720bULL, 0x000fe40003f34000ULL,
0x000000000900720cULL, 0x000fe20003f05270ULL, 0x0000d4b27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000247806ULL, 0x000fc400008e0100ULL, 0x00000080000f8824ULL, 0x000fe200078e026bULL,
0x000000080d098209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x00009910240e7816ULL, 0x000fe200000000ffULL, 0x0000000170268824ULL, 0x000fca00078e020fULL,
0x0134000926008388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000080d097209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff24ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000809097221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL,
0x0000000900267308ULL, 0x000e640000000800ULL, 0x0000002607077220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff097819ULL, 0x000fe20000011603ULL,
0x0000d3d27f007947ULL, 0x000fea000b800000ULL, 0x00001f0926097589ULL, 0x0002a400000e0000ULL,
0x0000000910107220ULL, 0x084fe20000410000ULL, 0x0000000911117220ULL, 0x080fe20000410000ULL,
0x0000000914147220ULL, 0x080fe20000410000ULL, 0x0000000915157220ULL, 0x080fe20000410000ULL,
0x0000000918187220ULL, 0x080fe20000410000ULL, 0x0000000919197220ULL, 0x080fe20000410000ULL,
0x0000000950507220ULL, 0x080fe20000410000ULL, 0x0000000951517220ULL, 0x080fe20000410000ULL,
0x0000000954547220ULL, 0x080fe20000410000ULL, 0x0000000955557220ULL, 0x080fe20000410000ULL,
0x000000091c1c7220ULL, 0x080fe20000410000ULL, 0x000000091d1d7220ULL, 0x080fe20000410000ULL,
0x0000000920207220ULL, 0x080fe20000410000ULL, 0x0000000921217220ULL, 0x080fe20000410000ULL,
0x0000000930307220ULL, 0x080fe20000410000ULL, 0x0000000931317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0024ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803097811ULL, 0x000fe200078ff0ffULL,
0x0000d2b27f007947ULL, 0x000fea000b800000ULL, 0x00001f0926097589ULL, 0x00046400000e0000ULL,
0x0000000912127220ULL, 0x086fe20000410000ULL, 0x0000000913137220ULL, 0x080fe20000410000ULL,
0x0000000916167220ULL, 0x080fe20000410000ULL, 0x0000000917177220ULL, 0x080fe20000410000ULL,
0x000000091a1a7220ULL, 0x080fe20000410000ULL, 0x000000091b1b7220ULL, 0x080fe20000410000ULL,
0x0000000952527220ULL, 0x080fe20000410000ULL, 0x0000000953537220ULL, 0x080fe20000410000ULL,
0x0000000956567220ULL, 0x080fe20000410000ULL, 0x0000000957577220ULL, 0x080fe20000410000ULL,
0x000000091e1e7220ULL, 0x080fe20000410000ULL, 0x000000091f1f7220ULL, 0x080fe20000410000ULL,
0x0000000922227220ULL, 0x080fe20000410000ULL, 0x0000000923237220ULL, 0x080fe20000410000ULL,
0x0000000932327220ULL, 0x080fe20000410000ULL, 0x0000000933337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff25ff7812ULL, 0x000fe40007806024ULL,
0x000000080d087209ULL, 0x000fd60007810000ULL, 0x800000080d0d0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL, 0x0000000d00040308ULL, 0x000e640000000800ULL,
0x000000040c0c0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x000000070c077221ULL, 0x008fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000004ff05723eULL, 0x000fe400000000ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011603ULL,
0x00005410050c7816ULL, 0x000fe20000000005ULL, 0x0000d0e27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0c057589ULL, 0x0002a400000e0000ULL, 0x000000080d097810ULL, 0x000fe20007ffe0ffULL,
0x0000d1127f007947ULL, 0x000fea000b800000ULL, 0x00001f090c067589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100d097810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x000066f0000f7802ULL, 0x000fc40000000f00ULL,
0x0000d75000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180d097810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000cULL,
0x00006740000f7802ULL, 0x000fc40000000f00ULL, 0x0000d70000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x00000007030c7812ULL, 0x00afe200078ec0ffULL, 0x000000020a487824ULL, 0x000fe200078e026aULL,
0x0000000268097810ULL, 0x004fe20007ffe0ffULL, 0x00a000005d3c783bULL, 0x000e620000000200ULL,
0x000000080c0c7812ULL, 0x000fe200078ef803ULL, 0x0000200048487824ULL, 0x000fc800078e00ffULL,
0x000000080c0c7824ULL, 0x000fe200078e00ffULL, 0x0000b00048287810ULL, 0x000fc80007ffe0ffULL,
0xfffffff80c587812ULL, 0x000fe200078ee209ULL, 0x000000105e0c7824ULL, 0x000fe200078e0228ULL,
0x00000002ff097819ULL, 0x000fe20000011600ULL, 0x00000010604c7824ULL, 0x100fe400078e0228ULL,
0x000000105f447824ULL, 0x100fe400078e0228ULL, 0x0000001061407824ULL, 0x100fe200078e0228ULL,
0x000000000c0c783bULL, 0x000ea20000004200ULL, 0x0000001058587824ULL, 0x000fe400078e00ffULL,
0x0000001065387824ULL, 0x000fe200078e0228ULL, 0x000000004c4c783bULL, 0x000ee20000004200ULL,
0x0000080009247824ULL, 0x000fc400078e0258ULL, 0x0000001064347824ULL, 0x100fe200078e0228ULL,
0x000000004444783bULL, 0x000fe20000004200ULL, 0x00000010632c7824ULL, 0x100fe400078e0228ULL,
0x0000001067287824ULL, 0x000fe200078e0228ULL, 0x000000004040783bULL, 0x000fe80000004200ULL,
0x00a000002424783bULL, 0x000ee80000000200ULL, 0x000000002c2c783bULL, 0x000ee20000004200ULL,
0x000000053c3c0232ULL, 0x002fc40000000000ULL, 0x000000053e3e0232ULL, 0x080fe20000000000ULL,
0x000000003838783bULL, 0x000e620000004200ULL, 0x000000063d3d0232ULL, 0x080fe40000000000ULL,
0x000000063f3f0232ULL, 0x000fe20000000000ULL, 0x000000003434783bULL, 0x000e680000004200ULL,
0x000000002828783bULL, 0x000e640000004200ULL, 0x0000000c3c54723cULL, 0x044f700000001854ULL,
0x0000004c3c10723cULL, 0x048f700000001810ULL, 0x0000004e3c14723cULL, 0x000f620000001814ULL,
0x0000000524240232ULL, 0x000fc40000000000ULL, 0x0000000526260232ULL, 0x000fe40000000000ULL,
0x0000000625250232ULL, 0x080fe40000000000ULL, 0x0000000627270232ULL, 0x000fe20000000000ULL,
0x000000443c18723cULL, 0x040f700000001818ULL, 0x000000463c50723cULL, 0x040f700000001850ULL,
0x0000000e3c0c723cULL, 0x040f70000000181cULL, 0x000000403c20723cULL, 0x040f700000001820ULL,
0x000000423c30723cULL, 0x000f700000001830ULL, 0x0000002c2454723cULL, 0x060f700000001854ULL,
0x000000382410723cULL, 0x042f700000001810ULL, 0x0000003a2414723cULL, 0x040f700000001814ULL,
0x000000342418723cULL, 0x040f700000001818ULL, 0x000000362450723cULL, 0x040f700000001850ULL,
0x0000002e242c723cULL, 0x040b6e000000180cULL, 0x00013698090c7811ULL, 0x020fe200078e18ffULL,
0x000000282420723cULL, 0x040b700000001820ULL, 0x0000002a2424723cULL, 0x000b620000001830ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x00000300020e7a10ULL, 0x000fe20007ffe0ffULL,
0x000000000cff7f8cULL, 0x0003e6000c80043fULL, 0x000000660e00720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x00000c9000000947ULL, 0x000fea0003800000ULL,
0x000000010e0d7810ULL, 0x042fe20007ffe0ffULL, 0x000001000e0f7824ULL, 0x000fe400078e026fULL,
0x00005900590c7a24ULL, 0x010fe200078e02ffULL, 0x000000660d00720cULL, 0x000fe20003f06070ULL,
0x00000100ff0d7424ULL, 0x000fe200078e00ffULL, 0x000000600f327812ULL, 0x020fe200078ec0ffULL,
0x000000800c0c7824ULL, 0x000fc800078e00ffULL, 0x0000000169327824ULL, 0x000fe400078e0232ULL,
0x000062000c0c7625ULL, 0x000fc800078e000dULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff387819ULL, 0x000fe20000011603ULL, 0x000000ffff2b7224ULL, 0x000fe200078e00ffULL,
0x0000000f620e7217ULL, 0x000fe40007800000ULL, 0x00000004381c7810ULL, 0x040fe20007ffe0ffULL,
0x00000001381d7824ULL, 0x040fe200078e0232ULL, 0x00000008381e7810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0e7824ULL, 0x000fe200078e0a0fULL, 0x0000000c38287810ULL, 0x000fe20007ffe0ffULL,
0x000000011c397824ULL, 0x100fe200078e0203ULL, 0x00000010383e7810ULL, 0x000fe20007ffe0ffULL,
0x000000081c2a7824ULL, 0x000fe200078e00ffULL, 0x000000200e377817ULL, 0x000fe20003800000ULL,
0x000000011e347824ULL, 0x000fe200078e0203ULL, 0x00000014383c7810ULL, 0x000fe20007ffe0ffULL,
0x000000081e0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff82a397812ULL, 0x000fe200078ee239ULL,
0x00000080002a7824ULL, 0x000fe200078e00ffULL, 0x000000371c00720cULL, 0x080fe20003f86070ULL,
0x0000000128337824ULL, 0x140fe200078e0203ULL, 0xfffffff80f347812ULL, 0x000fe200078ee234ULL,
0x0000000828307824ULL, 0x000fe200078e00ffULL, 0x000000806b2a7812ULL, 0x000fe200078ef82aULL,
0x000000011c0f7824ULL, 0x000fe200078e0232ULL, 0x000000373800720cULL, 0x080fe20003fa6070ULL,
0x000000013e367824ULL, 0x000fe200078e0203ULL, 0xfffffff830337812ULL, 0x000fe200078ee233ULL,
0x000001001d1c7825ULL, 0x000fe200078e002aULL, 0x000000371e00720cULL, 0x000fc40003f66070ULL,
0x000000372800720cULL, 0x000fe20003f46070ULL, 0x000000083e1f7824ULL, 0x000fe200078e00ffULL,
0x0000001c0c307210ULL, 0x000fe20007f1e0ffULL, 0x000000013c357824ULL, 0x040fe400078e0203ULL,
0x000000083c3a7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f367812ULL, 0x000fe200078ee236ULL,
0x000000010d317824ULL, 0x000fe400000e061dULL, 0x00002000001d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a357812ULL, 0x000fe200078ee235ULL, 0x00000001381c7824ULL, 0x000fc400078e0203ULL,
0x00000001281f7824ULL, 0x100fe200078e0232ULL, 0x000020001d3b7812ULL, 0x000fe200078ec0ffULL,
0x000000011e297824ULL, 0x000fe200078e0232ULL, 0x000000071c3a7812ULL, 0x000fe200078ec0ffULL,
0x000001001f1e7825ULL, 0x000fc800078e002aULL, 0x000040000a3d7824ULL, 0x000fe200078e023bULL,
0x0ffffff83a3b7812ULL, 0x000fe200078ef803ULL, 0x000001000f0e7825ULL, 0x100fe200078e002aULL,
0x0000001e0c1e7210ULL, 0x040fe40007fde0ffULL, 0x0000b0003d3a7810ULL, 0x000fe20007ffe0ffULL,
0x0000010029287825ULL, 0x000fe200078e002aULL, 0x0000000e0c0e7210ULL, 0x000fc60007f3e0ffULL,
0x000000013e1d7824ULL, 0x000fe200078e0232ULL, 0x000000280c287210ULL, 0x000fe20007f1e0ffULL,
0x000000103b3d7824ULL, 0x000fe200078e023aULL, 0x0000000f0d0f7210ULL, 0x000fe20000ffe4ffULL,
0x000001001d1c7825ULL, 0x000fe200078e002aULL, 0x000000373e00720cULL, 0x000fe40003f26070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000303d7faeULL, 0x0003e2000e901c48ULL,
0x000000013c3b7824ULL, 0x000fe400078e0232ULL, 0x000000010d1f7824ULL, 0x000fe200030e061fULL,
0x0000001c0c1c7210ULL, 0x000fe20007fde0ffULL, 0x00000010393f7824ULL, 0x000fc400078e023aULL,
0x000000010d297824ULL, 0x040fe200000e0629ULL, 0x000000373c00720cULL, 0x080fe20003f06070ULL,
0x000000010d1d7824ULL, 0x000fe200030e061dULL, 0x00000018383c7810ULL, 0x040fe20007ffe0ffULL,
0x000000000e3f7faeULL, 0x0005e2000e101c48ULL, 0x000001003b307825ULL, 0x002fe200078e002aULL,
0x0000001c38387810ULL, 0x000fe40007ffe0ffULL, 0x000000373c00720cULL, 0x0c0fe20003fa6070ULL,
0x000000013c397824ULL, 0x100fe200078e0232ULL, 0x000000373800720cULL, 0x040fe20003f86070ULL,
0x0000000138377824ULL, 0x000fc400078e0232ULL, 0x000000013c327824ULL, 0x040fe400078e0203ULL,
0x000000083c3b7824ULL, 0x000fe200078e00ffULL, 0x000000300c0e7210ULL, 0x004fe20007fde0ffULL,
0x0000001033337824ULL, 0x100fe400078e023aULL, 0x0000001035357824ULL, 0x000fe200078e023aULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee232ULL, 0x000000010d0f7824ULL, 0x000fe400030e0631ULL,
0x0000010039307825ULL, 0x000fc800078e002aULL, 0x0000000138397824ULL, 0x000fe200078e0203ULL,
0x000000300c307210ULL, 0x000fe20007fde0ffULL, 0x0000000838387824ULL, 0x000fe400078e00ffULL,
0x00000100372a7825ULL, 0x000fc600078e002aULL, 0xfffffff8383d7812ULL, 0x000fe200078ee239ULL,
0x000000010d317824ULL, 0x000fe200030e0631ULL, 0x0000002a0c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001034377824ULL, 0x100fe400078e023aULL, 0x0000001036397824ULL, 0x100fe400078e023aULL,
0x000000103b3b7824ULL, 0x100fe200078e023aULL, 0x0000000028377faeULL, 0x0003e2000d901c48ULL,
0x000000103d3d7824ULL, 0x000fe400078e023aULL, 0x000000010d0d7824ULL, 0x000fe200030e062bULL,
0x000000001e337faeULL, 0x0003e8000d101c48ULL, 0x000000001c397faeULL, 0x0003e8000c901c48ULL,
0x000000000e357faeULL, 0x0003e8000c101c48ULL, 0x00000000303b7faeULL, 0x0003e8000e901c48ULL,
0x000000000c3d7faeULL, 0x0003e2000e101c48ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000000403337811ULL, 0x040fe200078fe8ffULL, 0x00000080002a7824ULL, 0x000fe200078e00ffULL,
0x0000000c031c7811ULL, 0x000fc400078fe8ffULL, 0x0000000803357811ULL, 0x000fe200078fe8ffULL,
0x0000000133387824ULL, 0x100fe200078e0203ULL, 0x00000014031f7811ULL, 0x000fe200078fe8ffULL,
0x00000008330f7824ULL, 0x000fe200078e00ffULL, 0x00000010031d7811ULL, 0x000fe200078fe8ffULL,
0x000000011c3a7824ULL, 0x140fe200078e0203ULL, 0x000000031f367210ULL, 0x080fe20007ffe0ffULL,
0x0000000135397824ULL, 0x000fe200078e0203ULL, 0xfffffff80f387812ULL, 0x000fe200078ee238ULL,
0x000000081c0f7824ULL, 0x000fe200078e00ffULL, 0x0000001803297811ULL, 0x000fe200078fe8ffULL,
0x00000008350e7824ULL, 0x000fe200078e00ffULL, 0x0000001c033d7811ULL, 0x000fe200078fe8ffULL,
0x000000081f2b7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f3a7812ULL, 0x000fe200078ee23aULL,
0x00002000000f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e397812ULL, 0x000fe200078ee239ULL,
0x000000011d3b7824ULL, 0x100fe200078e0203ULL, 0xfffffff82b367812ULL, 0x000fe200078ee236ULL,
0x000000081d0e7824ULL, 0x000fe200078e00ffULL, 0x000020000f2b7812ULL, 0x000fe200078ec0ffULL,
0x0000000129377824ULL, 0x000fe200078e0203ULL, 0x000000806b2a7812ULL, 0x000fe200078ef82aULL,
0x00000008291e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e3b7812ULL, 0x000fe200078ee23bULL,
0x000000011c0f7824ULL, 0x100fe200078e0232ULL, 0x00000003030e7211ULL, 0x040fe200078fe8ffULL,
0x000040000a1c7824ULL, 0x000fe200078e022bULL, 0x0000003203317211ULL, 0x000fe200078fe8ffULL,
0x000000ffff2b7224ULL, 0x000fe200078e00ffULL, 0xfffffff81e377812ULL, 0x000fe200078ee237ULL,
0x0000000133337824ULL, 0x100fe200078e0232ULL, 0x000000070e0e7812ULL, 0x000fe200078ec0ffULL,
0x0000000135357824ULL, 0x000fc400078e0232ULL, 0x000000013d1e7824ULL, 0x140fe200078e0203ULL,
0x0ffffff80e3c7812ULL, 0x000fe200078ef803ULL, 0x000000083d3f7824ULL, 0x000fe400078e00ffULL,
0x000000011d1d7824ULL, 0x100fe400078e0232ULL, 0x000000011f1f7824ULL, 0x000fe200078e0232ULL,
0xfffffff83f3e7812ULL, 0x000fe200078ee21eULL, 0x0000000129297824ULL, 0x100fe200078e0232ULL,
0x0000b0001c3f7810ULL, 0x000fe20007ffe0ffULL, 0x000000013d3d7824ULL, 0x000fc400078e0232ULL,
0x0000010031307825ULL, 0x000fc800078e002aULL, 0x0000010033327825ULL, 0x000fe200078e002aULL,
0x000000300c307210ULL, 0x000fc60007f1e0ffULL, 0x0000010035347825ULL, 0x000fe200078e002aULL,
0x000000320c327210ULL, 0x000fc60007f3e0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e002aULL,
0x000000340c347210ULL, 0x000fc60007f5e0ffULL, 0x000001001d1c7825ULL, 0x000fe200078e002aULL,
0x0000000e0c0e7210ULL, 0x000fc60007f7e0ffULL, 0x000001001f1e7825ULL, 0x000fc800078e002aULL,
0x0000010029287825ULL, 0x000fc800078e002aULL, 0x000001003d2a7825ULL, 0x000fc800078e002aULL,
0x000000010d317824ULL, 0x040fe200000e0631ULL, 0x0000001c0c1c7210ULL, 0x040fe20007f1e0ffULL,
0x000000010d337824ULL, 0x040fe200008e0633ULL, 0x0000001e0c1e7210ULL, 0x000fe20007f3e0ffULL,
0x000000103c3d7824ULL, 0x000fe400078e023fULL, 0x000000010d357824ULL, 0x040fe200010e0635ULL,
0x000000280c287210ULL, 0x000fe20007f5e0ffULL, 0x0000001038417824ULL, 0x000fe200078e023fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000303d7faeULL, 0x0003e2000b901c48ULL,
0x000000010d0f7824ULL, 0x000fe200018e060fULL, 0x0000002a0c0c7210ULL, 0x000fe20007f7e0ffULL,
0x0000001039397824ULL, 0x100fe200078e023fULL, 0x0000000032417faeULL, 0x0003e2000b901c48ULL,
0x000000103a437824ULL, 0x000fc400078e023fULL, 0x000000103b3b7824ULL, 0x000fe200078e023fULL,
0x0000000034397faeULL, 0x0003e2000b901c48ULL, 0x000000010d1d7824ULL, 0x040fe400000e061dULL,
0x0000001036457824ULL, 0x000fe200078e023fULL, 0x000000000e437faeULL, 0x0003e2000b901c48ULL,
0x000000010d1f7824ULL, 0x000fe400008e061fULL, 0x0000001037377824ULL, 0x000fe200078e023fULL,
0x000000001c3b7faeULL, 0x0003e2000b901c48ULL, 0x000000010d297824ULL, 0x000fc400010e0629ULL,
0x000000103e3f7824ULL, 0x000fe200078e023fULL, 0x000000001e457faeULL, 0x0003e2000b901c48ULL,
0x000000010d0d7824ULL, 0x000fc600018e062bULL, 0x0000000028377faeULL, 0x0003e8000b901c48ULL,
0x000000000c3f7faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x000000106e0c7812ULL, 0x040fe400078ec0ffULL, 0x000000086e0d7812ULL, 0x000fc600078ec0ffULL,
0x00000020090c7824ULL, 0x000fc800078e020cULL, 0x000000010d1e7824ULL, 0x000fe200078e020cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x013668001e0c7f8cULL, 0x0002a4000c80043fULL,
0x00000000000e7805ULL, 0x000fc40000015200ULL, 0x01366c001e097984ULL, 0x000ee40000000800ULL,
0x8000000009ff7812ULL, 0x00cfe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c0e1c7210ULL, 0x000fc80007f1e1ffULL, 0x0000001d0f1d7210ULL, 0x000fe400007fe5ffULL,
0x003d09001c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc8000001141dULL, 0x0000001c09097211ULL, 0x000fca00078110ffULL,
0x000000ffff1c7224ULL, 0x000fca00000e061dULL, 0x0000000209097819ULL, 0x000fc8000000121cULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011f1f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01366c001e097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001806b097810ULL, 0x000fca0007ffe05cULL,
0x0000000170097824ULL, 0x000fca00078e0209ULL, 0x01300000090d7984ULL, 0x000ea80000000800ULL,
0x01320000091c7984ULL, 0x0006620000000800ULL, 0x000000080d00720bULL, 0x004fe20003f1d000ULL,
0x0000bcc27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000097806ULL, 0x008fc800000e0100ULL,
0x0000ffff091d7812ULL, 0x000fe2000782c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff0c7224ULL, 0x000fd400078e0008ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x0000000300097811ULL, 0x000fe400078ff0ffULL,
0x000000080d00720bULL, 0x000fe40003f34000ULL, 0x000000000900720cULL, 0x000fe20003f05270ULL,
0x0000bc627f007947ULL, 0x000fd4000b800000ULL, 0x00000000000c7806ULL, 0x000fc400008e0100ULL,
0x00000080006b8824ULL, 0x000fe200078e026bULL, 0x000000080d098209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x000099100c0e7816ULL, 0x000fe200000000ffULL,
0x0000000170708824ULL, 0x000fca00078e026bULL, 0x0134000970008388ULL, 0x0005e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x000000080d097209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0cff7812ULL, 0x000fc6000780c0ffULL, 0x0000000809097221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b09097820ULL, 0x000fc80000410000ULL, 0x00000009001e7308ULL, 0x002e640000000800ULL,
0x0000001e07077220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff097819ULL, 0x000fe20000011603ULL, 0x0000bb827f007947ULL, 0x000fea000b800000ULL,
0x00001f091e097589ULL, 0x0002a400000e0000ULL, 0x0000000910107220ULL, 0x084fe20000410000ULL,
0x0000000911117220ULL, 0x080fe20000410000ULL, 0x0000000914147220ULL, 0x080fe20000410000ULL,
0x0000000915157220ULL, 0x080fe20000410000ULL, 0x0000000918187220ULL, 0x080fe20000410000ULL,
0x0000000919197220ULL, 0x080fe20000410000ULL, 0x0000000950507220ULL, 0x080fe20000410000ULL,
0x0000000951517220ULL, 0x080fe20000410000ULL, 0x0000000954547220ULL, 0x080fe20000410000ULL,
0x0000000955557220ULL, 0x080fe20000410000ULL, 0x000000092c2c7220ULL, 0x080fe20000410000ULL,
0x000000092d2d7220ULL, 0x080fe20000410000ULL, 0x0000000920207220ULL, 0x0a0fe20000410000ULL,
0x0000000921217220ULL, 0x080fe20000410000ULL, 0x0000000924247220ULL, 0x080fe20000410000ULL,
0x0000000925257220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803097811ULL, 0x000fe200078ff0ffULL, 0x0000ba627f007947ULL, 0x000fea000b800000ULL,
0x00001f091e097589ULL, 0x0004e400000e0000ULL, 0x0000000912127220ULL, 0x08cfe20000410000ULL,
0x0000000913137220ULL, 0x080fe20000410000ULL, 0x0000000916167220ULL, 0x080fe20000410000ULL,
0x0000000917177220ULL, 0x080fe20000410000ULL, 0x000000091a1a7220ULL, 0x080fe20000410000ULL,
0x000000091b1b7220ULL, 0x080fe20000410000ULL, 0x0000000952527220ULL, 0x080fe20000410000ULL,
0x0000000953537220ULL, 0x080fe20000410000ULL, 0x0000000956567220ULL, 0x080fe20000410000ULL,
0x0000000957577220ULL, 0x080fe20000410000ULL, 0x000000092e2e7220ULL, 0x080fe20000410000ULL,
0x000000092f2f7220ULL, 0x080fe20000410000ULL, 0x0000000922227220ULL, 0x0a0fe20000410000ULL,
0x0000000923237220ULL, 0x080fe20000410000ULL, 0x0000000926267220ULL, 0x080fe20000410000ULL,
0x0000000927277220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff1dff7812ULL, 0x000fe4000780600cULL, 0x000000080d0c7209ULL, 0x000fd60007810000ULL,
0x8000000c0d0d0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL,
0x0000000d00040308ULL, 0x000ea40000000800ULL, 0x000000041c1c0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x000000071c077221ULL, 0x002fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000004ff05723eULL, 0x000fe400000000ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011603ULL, 0x0000541005087816ULL, 0x000fe20000000005ULL,
0x0000b8927f007947ULL, 0x000fea000b800000ULL, 0x00001f0d08057589ULL, 0x0002a400000e0000ULL,
0x000000080d097810ULL, 0x000fe20007ffe0ffULL, 0x0000b8c27f007947ULL, 0x000fea000b800000ULL,
0x00001f0908067589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100d097810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0008ULL,
0x00008100000f7802ULL, 0x000fc40000000f00ULL, 0x0000bd4000007944ULL, 0x036fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180d097810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0008ULL, 0x00008150000f7802ULL, 0x000fc40000000f00ULL,
0x0000bcf000007944ULL, 0x032fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000703087812ULL, 0x00afe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x0000000808087812ULL, 0x000fca00078ef803ULL, 0x0000000808097824ULL, 0x004fe200078e00ffULL,
0x00000002ff087819ULL, 0x000fc80000011600ULL, 0xfffffff809097812ULL, 0x000fca00078ee268ULL,
0x0000008008407824ULL, 0x000fca00078e0209ULL, 0x0000a80040407811ULL, 0x000fca00078e20ffULL,
0x0000c000480e7810ULL, 0x000fe20007ffe0ffULL, 0x000000004040783bULL, 0x000e620000000200ULL,
0x0000000300097811ULL, 0x000fe400078ff0ffULL, 0x0000030002027a10ULL, 0x000fe20007ffe0ffULL,
0x00000010604c7824ULL, 0x100fe200078e020eULL, 0x000136a008087811ULL, 0x000fe200078e18ffULL,
0x000000105f487824ULL, 0x100fe400078e020eULL, 0x000000105e3c7824ULL, 0x100fe400078e020eULL,
0x0000001061447824ULL, 0x000fe200078e020eULL, 0x000000004c4c783bULL, 0x000ea20000004200ULL,
0x00000800091c7824ULL, 0x000fc400078e0258ULL, 0x0000001065387824ULL, 0x100fe200078e020eULL,
0x000000004848783bULL, 0x000fe20000004200ULL, 0x0000001064347824ULL, 0x100fe400078e020eULL,
0x0000001063307824ULL, 0x120fe200078e020eULL, 0x000000003c3c783bULL, 0x000fe20000004200ULL,
0x0000001067287824ULL, 0x000fc600078e020eULL, 0x000000004444783bULL, 0x000fe80000004200ULL,
0x009000001c1c783bULL, 0x000ee80000000200ULL, 0x000000003838783bULL, 0x000ee80000004200ULL,
0x000000003434783bULL, 0x000ee80000004200ULL, 0x000000003030783bULL, 0x000ee20000004200ULL,
0x0000000540400232ULL, 0x002fc40000000000ULL, 0x0000000542420232ULL, 0x000fe20000000000ULL,
0x000000002828783bULL, 0x000e620000004200ULL, 0x0000000641410232ULL, 0x080fe40000000000ULL,
0x0000000643430232ULL, 0x000fce0000000000ULL, 0x0000004c4010723cULL, 0x044f700000001810ULL,
0x0000004e4014723cULL, 0x000f620000001814ULL, 0x000000051c1c0232ULL, 0x008fce0000000000ULL,
0x000000484018723cULL, 0x000f620000001818ULL, 0x000000051e1e0232ULL, 0x000fe40000000000ULL,
0x000000061d1d0232ULL, 0x080fe40000000000ULL, 0x000000061f1f0232ULL, 0x000fc60000000000ULL,
0x0000004a4050723cULL, 0x040f700000001850ULL, 0x0000003c4054723cULL, 0x040f700000001854ULL,
0x0000003e402c723cULL, 0x040f70000000182cULL, 0x000000444020723cULL, 0x040f700000001820ULL,
0x000000464024723cULL, 0x000f700000001824ULL, 0x000000381c10723cULL, 0x060b700000001810ULL,
0x0000003a1c14723cULL, 0x040b700000001814ULL, 0x000000341c18723cULL, 0x040b700000001818ULL,
0x000000361c50723cULL, 0x040b700000001850ULL, 0x000000301c54723cULL, 0x040b700000001854ULL,
0x000000321c2c723cULL, 0x040b70000000182cULL, 0x000000281c20723cULL, 0x042b700000001820ULL,
0x0000002a1c1c723cULL, 0x000b620000001824ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000660200720cULL, 0x000fe20003f06070ULL, 0x0000000008ff7f8cULL, 0x0003d8000c80043fULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff942000007947ULL, 0x000fea000383ffffULL,
0x0000000000027919ULL, 0x000e640000002500ULL, 0x000000660200720cULL, 0x002fda0003f06070ULL,
0x0000032000000947ULL, 0x000fea0003800000ULL, 0x0180000007037810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000003037812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000860000087802ULL, 0x000fc40000000f00ULL, 0x0000b69000007944ULL, 0x030fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000700047308ULL, 0x000e640000001000ULL,
0xbf80000004037423ULL, 0x002fc80000000007ULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000304037223ULL, 0x000fc40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x00000002ff047819ULL, 0x002fe40000011605ULL,
0x0000000805067811ULL, 0x000fc800078ff0ffULL, 0x00001f0403047589ULL, 0x00ce6800000e0000ULL,
0x00001f0603057589ULL, 0x000ea200000e0000ULL, 0x0000001004107220ULL, 0x062fe20000410000ULL,
0x0000001104117220ULL, 0x040fe20000410000ULL, 0x0000001404147220ULL, 0x040fe20000410000ULL,
0x0000001504157220ULL, 0x040fe20000410000ULL, 0x0000001804187220ULL, 0x040fe20000410000ULL,
0x0000001904197220ULL, 0x040fe20000410000ULL, 0x0000005004507220ULL, 0x040fe20000410000ULL,
0x0000005104517220ULL, 0x040fe20000410000ULL, 0x0000005404547220ULL, 0x040fe20000410000ULL,
0x0000005504557220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x040fe20000410000ULL, 0x0000002004207220ULL, 0x040fe20000410000ULL,
0x0000002104217220ULL, 0x040fe20000410000ULL, 0x0000001c041c7220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x000fe20000410000ULL, 0x0000001205127220ULL, 0x044fe20000410000ULL,
0x0000001305137220ULL, 0x040fe20000410000ULL, 0x0000001605167220ULL, 0x040fe20000410000ULL,
0x0000001705177220ULL, 0x040fe20000410000ULL, 0x0000001a051a7220ULL, 0x040fe20000410000ULL,
0x0000001b051b7220ULL, 0x040fe20000410000ULL, 0x0000005205527220ULL, 0x040fe20000410000ULL,
0x0000005305537220ULL, 0x040fe20000410000ULL, 0x0000005605567220ULL, 0x040fe20000410000ULL,
0x0000005705577220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x000fc20000410000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0x000000101103723eULL, 0x020fc400000000ffULL, 0x000000202110723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000141509723eULL, 0x000fe400000000ffULL,
0x0000001a1b14723eULL, 0x000fe400000000ffULL, 0x0000001c1d11723eULL, 0x000fc400000000ffULL,
0x00000018190b723eULL, 0x000fe400000000ffULL, 0x000000222318723eULL, 0x000fe400000000ffULL,
0x0000001e1f19723eULL, 0x000fe400000000ffULL, 0x00000050510d723eULL, 0x000fe400000000ffULL,
0x00000002ff207819ULL, 0x002fe40000011604ULL, 0x00000008042b7811ULL, 0x000fc400078ff0ffULL,
0x0000000120057810ULL, 0x040fe20007ffe0ffULL, 0x0000000820087824ULL, 0x040fe200078e00ffULL,
0x0000000220067810ULL, 0x040fe20007ffe0ffULL, 0x00000008201b7824ULL, 0x040fe200078e00ffULL,
0x00000006201a7810ULL, 0x040fe20007ffe0ffULL, 0x00000008201c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8081d7812ULL, 0x000fe200078ee205ULL, 0x0000000820257824ULL, 0x040fe200078e00ffULL,
0x0000000320057810ULL, 0x040fe20007ffe0ffULL, 0x0000000820277824ULL, 0x040fe200078e00ffULL,
0x0000000520087810ULL, 0x040fe20007ffe0ffULL, 0x0000000820237824ULL, 0x040fe200078e00ffULL,
0xfffffff81b1f7812ULL, 0x000fe200078ee206ULL, 0x000000082b1e7824ULL, 0x000fe200078e00ffULL,
0x0000000420067810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81c217812ULL, 0x000fe200078ee205ULL,
0x000010006a057824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee208ULL,
0x000008000a087824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee21aULL,
0x00000004041a7824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee206ULL,
0x0000000105067824ULL, 0x000fe200078e0208ULL, 0xfffffff81b1b7812ULL, 0x000fe400078ee220ULL,
0xffffffff201c7810ULL, 0x040fe20007ffe0ffULL, 0x000000101d1d7824ULL, 0x100fe200078e0206ULL,
0x0000000320297819ULL, 0x000fe200000006ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0206ULL,
0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL, 0x000000101f1f7824ULL, 0x000fe200078e0206ULL,
0xfffffff829297812ULL, 0x000fe200078ee21cULL, 0x0000001021217824ULL, 0x100fe200078e0206ULL,
0xfffffff81e2b7812ULL, 0x000fe200078ee22bULL, 0x0000001023237824ULL, 0x000fe200078e0206ULL,
0x00000054550e723eULL, 0x000fe200000000ffULL, 0x000000011b1c7824ULL, 0x000fe200078e021aULL,
0x0000002c2d0f723eULL, 0x000fe200000000ffULL, 0x0000001025257824ULL, 0x100fe200078e0206ULL,
0x000000121312723eULL, 0x000fe200000000ffULL, 0x000000011a1e7824ULL, 0x040fe200078e021dULL,
0x000000031c007388ULL, 0x000fe20000000800ULL, 0x0000001027277824ULL, 0x100fe200078e0206ULL,
0x000000161713723eULL, 0x000fe200000000ffULL, 0x000000011a1f7824ULL, 0x040fe200078e021fULL,
0x000000091e007388ULL, 0x000fe20000000800ULL, 0x0000001029297824ULL, 0x100fe200078e0206ULL,
0x000000525315723eULL, 0x000fe200000000ffULL, 0x000000011a207824ULL, 0x040fe200078e0221ULL,
0x0000000b1f007388ULL, 0x000fe20000000800ULL, 0x000000102b2b7824ULL, 0x000fe200078e0206ULL,
0x000000565716723eULL, 0x000fe200000000ffULL, 0x000000011a237824ULL, 0x040fe200078e0223ULL,
0x0000000d20007388ULL, 0x0003e20000000800ULL, 0x000000011a227824ULL, 0x040fe200078e0225ULL,
0x0000002e2f17723eULL, 0x000fe200000000ffULL, 0x000000011a277824ULL, 0x040fe200078e0227ULL,
0x0000000e23007388ULL, 0x000fe20000000800ULL, 0x000000011a247824ULL, 0x000fc400078e0229ULL,
0x000000011a2b7824ULL, 0x000fe200078e022bULL, 0x0000000f22007388ULL, 0x000fe20000000800ULL,
0x000000016f1a7824ULL, 0x000fc600078e0204ULL, 0x0000001027007388ULL, 0x000fe20000000800ULL,
0x000000101a0d7824ULL, 0x002fc600078e0205ULL, 0x0000001124007388ULL, 0x000fe80000000800ULL,
0x000000122b007388ULL, 0x000fe80000000800ULL, 0x000400131e007388ULL, 0x000fe80000000800ULL,
0x000400141f007388ULL, 0x000fe80000000800ULL, 0x0004001520007388ULL, 0x000fe80000000800ULL,
0x0004001623007388ULL, 0x000fe80000000800ULL, 0x0004001722007388ULL, 0x0003e80000000800ULL,
0x0004001827007388ULL, 0x000fe80000000800ULL, 0x0004001924007388ULL, 0x000fe20000000800ULL,
0x00000300ff227624ULL, 0x002fc600078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000d287984ULL, 0x000e620000000c00ULL, 0x000000012200780cULL, 0x000fc60003f05270ULL,
0x000400000d1c7984ULL, 0x000ea80000000c00ULL, 0x000800000d107984ULL, 0x000ee80000000c00ULL,
0x000c00000d2c7984ULL, 0x000ee20000000c00ULL, 0x200000ff2b2b7230ULL, 0x002fe40000000000ULL,
0x200000ff2a2a7230ULL, 0x000fc40000000000ULL, 0x200000ff29297230ULL, 0x000fe40000000000ULL,
0x200000ff28287230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x004fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fe40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fc40000000000ULL, 0x000000132b2b7230ULL, 0x008fe40000000000ULL,
0x000000122a2a7230ULL, 0x000fe40000000000ULL, 0x0000001129297230ULL, 0x000fe40000000000ULL,
0x0000001028287230ULL, 0x000fe40000000000ULL, 0x0000002f1f1f7230ULL, 0x000fe40000000000ULL,
0x0000002e1e1e7230ULL, 0x000fe20000000000ULL, 0x000000280d007388ULL, 0x000fe20000000c00ULL,
0x0000002d1d1d7230ULL, 0x000fc40000000000ULL, 0x0000002c1c1c7230ULL, 0x000fca0000000000ULL,
0x0004001c0d007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00002a6000008947ULL, 0x000fea0003800000ULL, 0x00000400ff037624ULL, 0x000fe200078e00ffULL,
0x00000000000f7919ULL, 0x000e660000002600ULL, 0x00006a0003037a24ULL, 0x000fe200078e02ffULL,
0x0000000000187919ULL, 0x000e680000002700ULL, 0x0000000f030e7811ULL, 0x040fe200078e10ffULL,
0x0000030003037a24ULL, 0x000fe200078e02ffULL, 0x000000000d107984ULL, 0x000ea40000000c00ULL,
0xfffffff00e0e7812ULL, 0x000fc400078ec0ffULL, 0x000400000d147984ULL, 0x0006a60000000c00ULL,
0x00000080030b7824ULL, 0x000fc800078e020eULL, 0x0000008003037824ULL, 0x000fe200078e020bULL,
0x000000401a0d7810ULL, 0x008fc80007ffe0ffULL, 0x0000007f03037810ULL, 0x000fe20007ffe0ffULL,
0x00000400180f7a24ULL, 0x002fc600078e020fULL, 0xffffff8003037812ULL, 0x000fe200078ec0ffULL,
0x000003000f097a24ULL, 0x000fc600078e02ffULL, 0x00006e0003197a10ULL, 0x000fe20007f1e0ffULL,
0x0000000109027824ULL, 0x000fca00078e0202ULL, 0x0000001902187211ULL, 0x000fe200078260ffULL,
0x00006f00ff197624ULL, 0x000fe200000e06ffULL, 0x000000010aff7812ULL, 0x000fc8000780f800ULL,
0x0000001902197211ULL, 0x000fe400008f64ffULL, 0x00006e000e207a10ULL, 0x000fc60007f3e0ffULL,
0x000008006a187825ULL, 0x000fc800078e0018ULL, 0x00006f00ff217624ULL, 0x000fe400008e06ffULL,
0x000000101a1a7825ULL, 0x000fc800078e0018ULL, 0x000000100d187825ULL, 0x000fe200078e0018ULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x00000010040d7824ULL, 0x004fe200078e00ffULL,
0x00000001ff1d7819ULL, 0x000fe20000011604ULL, 0x00000080021c7824ULL, 0x000fe200078e00ffULL,
0x00000019ff027819ULL, 0x000fe40000011602ULL, 0x000000700d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c1d1d7812ULL, 0x000fe400078ec0ffULL, 0x00006e001c1e7a10ULL, 0x000fc40007ebe00bULL,
0x000000200d1c7210ULL, 0x000fe40007a3e01cULL, 0x0000001e1d1e7210ULL, 0x040fe40007c7e00dULL,
0x00006f00020d7a10ULL, 0x000fe40002fec4ffULL, 0x0000001c1d1c7210ULL, 0x000fe40007fbe0ffULL,
0x00000021ff027210ULL, 0x000fe40000fe4402ULL, 0x0000000dff1f7210ULL, 0x000fc60001fe84ffULL,
0x000000ffff1d7224ULL, 0x000fca00028e0602ULL, 0x0000000c1c007986ULL, 0x0003e8000c101908ULL,
0x000000071e007986ULL, 0x0003e4000c101908ULL, 0x000000ff0400720cULL, 0x004fe20000705670ULL,
0x000000101a007986ULL, 0x000fe2000c101d08ULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x0000001418007986ULL, 0x000fe8000c101d08ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000004ff0c7424ULL, 0x002fe200078e00ffULL,
0xffffffff22077810ULL, 0x000fc60007ffe0ffULL, 0x00006e000f0c7625ULL, 0x000fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x000000070c0c79a8ULL, 0x000ea400099ee1c8ULL,
0x000000070c00720cULL, 0x004fc80003f05270ULL, 0x00000001ff027807ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000002ff007388ULL, 0x0003e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000ff027984ULL, 0x002e640000000000ULL, 0x000000ff0200720cULL, 0x002fda0003f05270ULL,
0x000025e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x00000a5000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x000001b000008947ULL, 0x000fea0003800000ULL, 0x0000001004007824ULL, 0x000fe200078e00ffULL,
0x00000001ff027819ULL, 0x000fe40000011604ULL, 0x00000020090c7211ULL, 0x040fe400078038ffULL,
0x00000070000d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c02027812ULL, 0x000fe400078ec0ffULL,
0x0000002109007211ULL, 0x000fe400000f3cffULL, 0x0000000c020c7210ULL, 0x000fc8000791e00dULL,
0x00000000ff0d7210ULL, 0x000fca00007e24ffULL, 0x000000080c007981ULL, 0x000328000c1e1900ULL,
0x000080080c077981ULL, 0x000322000c1e1900ULL, 0x000000022200780cULL, 0x000fda0003f05270ULL,
0x000000f000008947ULL, 0x000fea0003800000ULL, 0x000100080c0f7981ULL, 0x002322000c1e1900ULL,
0x000000042200780cULL, 0x000fda0003f06070ULL, 0x000000c000008947ULL, 0x000fea0003800000ULL,
0x000180080c117981ULL, 0x002322000c1e1900ULL, 0x000000042200780cULL, 0x000fda0003f05270ULL,
0x0000009000008947ULL, 0x000fea0003800000ULL, 0x000200080c137981ULL, 0x002322000c1e1900ULL,
0x000000062200780cULL, 0x000fda0003f06070ULL, 0x0000006000008947ULL, 0x000fea0003800000ULL,
0x000280080c157981ULL, 0x002322000c1e1900ULL, 0x000000062200780cULL, 0x000fda0003f05270ULL,
0x0000003000008947ULL, 0x000fea0003800000ULL, 0x000000082200780cULL, 0x002fe20003f06070ULL,
0x000300080c177981ULL, 0x000318000c1e1900ULL, 0x000380080c190981ULL, 0x000324000c1e1900ULL,
0x0000000722027810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff027819ULL, 0x000fc80000011602ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x000007d000008947ULL, 0x000fea0003800000ULL,
0x0000000e091d7211ULL, 0x000fe200078038ffULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x00000000001b7202ULL, 0x010fe20000000f00ULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x00006e001d1d7a10ULL, 0x000fe40007f3e0ffULL, 0x000000ff09107211ULL, 0x000fe400000f3cffULL,
0x000007801d1d7810ULL, 0x000fc80007f5e0ffULL, 0x00006f00ff107a10ULL, 0x000fc400017e2410ULL,
0x0000030012007a0cULL, 0x000fe20003f26070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x0000000402007c0cULL, 0x000fcc000bf03070ULL, 0x000006d000001947ULL, 0x012fea0003800000ULL,
0x00000008120c7810ULL, 0x040fe40007ffe0ffULL, 0x00000001120d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001b00007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010040c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011604ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0610ULL,
0xfffc80080c1b7981ULL, 0x000326000c1e1900ULL, 0x000005f000002947ULL, 0x000fea0003800000ULL,
0x00000009120c7810ULL, 0x042fe40007ffe0ffULL, 0x00000002120d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000000700007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001004077824ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fc80000011604ULL,
0x0000007007077812ULL, 0x000fc800078ec0ffULL, 0x0000000c070c7812ULL, 0x000fc800078ef80cULL,
0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0610ULL,
0xfffd00080c077981ULL, 0x000326000c1e1900ULL, 0x0000051000002947ULL, 0x000fea0003800000ULL,
0x0000000a120c7810ULL, 0x042fe40007ffe0ffULL, 0x00000003120d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000000f00007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010040c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011604ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0610ULL,
0xfffd80080c0f7981ULL, 0x000326000c1e1900ULL, 0x0000043000002947ULL, 0x000fea0003800000ULL,
0x0000000b120c7810ULL, 0x042fe40007ffe0ffULL, 0x00000004120d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001100007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010040c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011604ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0610ULL,
0xfffe00080c117981ULL, 0x000326000c1e1900ULL, 0x0000035000002947ULL, 0x000fea0003800000ULL,
0x0000000c120c7810ULL, 0x042fe40007ffe0ffULL, 0x00000005120d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001300007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010040c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011604ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0610ULL,
0xfffe80080c137981ULL, 0x000326000c1e1900ULL, 0x0000027000002947ULL, 0x000fea0003800000ULL,
0x0000000d120c7810ULL, 0x042fe40007ffe0ffULL, 0x00000006120d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001500007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010040c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011604ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0610ULL,
0xffff00080c157981ULL, 0x000326000c1e1900ULL, 0x0000019000002947ULL, 0x000fea0003800000ULL,
0x0000000e120c7810ULL, 0x042fe40007ffe0ffULL, 0x00000007120d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001700007209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010040c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011604ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0610ULL,
0xffff80080c177981ULL, 0x000326000c1e1900ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000000f120c7810ULL, 0x002fe40007ffe0ffULL, 0x0000001900007209ULL, 0x000fe40007810000ULL,
0x000003000c007a0cULL, 0x000fda0003f26070ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010040c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011604ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e0610ULL,
0x000000080c197981ULL, 0x000326000c1e1900ULL, 0x000004001d1d7810ULL, 0x000fe40007f3e0ffULL,
0x0000000812127810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200008e0610ULL,
0xfffff8b000008947ULL, 0x000fea000383ffffULL, 0x0000000000047919ULL, 0x000ea40000000000ULL,
0x0000001004027824ULL, 0x004fe200078e00ffULL, 0x00000001ff077819ULL, 0x010fc80000011604ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c07077812ULL, 0x000fca00078ec0ffULL,
0x0000000102077824ULL, 0x000fca00078e0207ULL, 0x0000000007007388ULL, 0x0005e40000000800ULL,
0x00006e0003027a10ULL, 0x000fe20007f3e0ffULL, 0x000000010a197824ULL, 0x000fe200078e0209ULL,
0x000000070400780cULL, 0x000fe20003f04070ULL, 0x000008006a007824ULL, 0x004fe200078e00ffULL,
0x000000010a077812ULL, 0x000fe200078ec0ffULL, 0x00006f00ff037624ULL, 0x000fe200008e06ffULL,
0x00000001ff0f7819ULL, 0x000fe20000011604ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00001000190c7825ULL, 0x002fe200078e0002ULL, 0x0000002004137810ULL, 0x040fe20007ffe0ffULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000004004157810ULL, 0x000fe20007ffe0ffULL,
0x000000020a128824ULL, 0x100fe200078e026aULL, 0x000000000c107210ULL, 0x000fe20007f3e0ffULL,
0x000000020a148824ULL, 0x000fe200078e026aULL, 0x00000060041b7810ULL, 0x000fe20007ffe0ffULL,
0x00000002121d8824ULL, 0x000fe200078e0207ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff117224ULL, 0x000fe200008e060dULL, 0x00000800080d7812ULL, 0x000fe200078ec0ffULL,
0x000020000a087824ULL, 0x000fe200078e0205ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000214218824ULL, 0x000fe200078e0207ULL, 0x00006e000b077a10ULL, 0x000fe20007f3e0ffULL,
0x00000001080b7824ULL, 0x000fe200078e020dULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000010040c7824ULL, 0x040fe200078e00ffULL, 0x0000000421218211ULL, 0x000fe200078e18ffULL,
0x00000010041f7824ULL, 0x000fe200078e020bULL, 0x00006e000e0b7a10ULL, 0x000fe20007f5e0ffULL,
0x00006f00ff167624ULL, 0x000fe200008e06ffULL, 0x000000700c0d7812ULL, 0x000fe200078ec0ffULL,
0x0000001013127825ULL, 0x000fe200078e0010ULL, 0x0000000c0f0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000007190e8211ULL, 0x040fe200078238ffULL,
0x00006f00ff187624ULL, 0x000fe200010e06ffULL, 0x0000000b191c8211ULL, 0x000fe200078438ffULL,
0x000000010d177824ULL, 0x000fe200078e020cULL, 0x00000016190f8211ULL, 0x000fe200008f3cffULL,
0x0000001015147825ULL, 0x100fe200078e0010ULL, 0x000003000a007a0cULL, 0x000fe20003f26070ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000418021258811ULL, 0x000fe200078e20ffULL,
0x000000101b1a7825ULL, 0x100fe200078e0010ULL, 0x0000000017177984ULL, 0x000e620000000800ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000001004107825ULL, 0x000fe200078e0010ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fc4000001ff00ULL, 0x000000081d238824ULL, 0x000fe200078e0204ULL,
0x00000018191d8211ULL, 0x000fe200010f3cffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000101f7faeULL, 0x0005e2000b901c48ULL, 0x00000010040e8825ULL, 0x000fe400078e000eULL,
0x0000458023238811ULL, 0x000fe200078e20ffULL, 0x00380000121f7faeULL, 0x0007e2000b901c48ULL,
0x000000ffff197224ULL, 0x000fe400078e00ffULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x00580000141f7faeULL, 0x0007e2000b901c48ULL, 0x000000ffff3a7224ULL, 0x000fc400078e00ffULL,
0x0000001004108825ULL, 0x004fe200078e001cULL, 0x007800001a1f7faeULL, 0x0007e2000b901c48ULL,
0x00000000001c7805ULL, 0x000fc6000001ff00ULL, 0x000000000e238faeULL, 0x0005e8000b901c48ULL,
0x0000000010258faeULL, 0x0003e8000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000001e7805ULL, 0x008fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x004fe2000001ff00ULL, 0x0000000000247805ULL, 0x002fe2000001ff00ULL,
0x00000c6000001947ULL, 0x000fea0003800000ULL, 0x000000ffff197224ULL, 0x000fe400078e00ffULL,
0x000000ffff397224ULL, 0x000fca00078e000aULL, 0x00000001390e7810ULL, 0x000fc80007ffe0ffULL,
0x000003000e007a0cULL, 0x000fda0003f06070ULL, 0x0000028000000947ULL, 0x000fea0003800000ULL,
0x0000000109417824ULL, 0x000fe200078e020eULL, 0x000000070400780cULL, 0x000fe40003f44070ULL,
0x000000010e0f7812ULL, 0x000fe200078ec0ffULL, 0x00001000410c7825ULL, 0x000fe200078e0002ULL,
0x0000002004137810ULL, 0x040fe40007ffe0ffULL, 0x0000004004157810ULL, 0x000fe40007ffe0ffULL,
0x000000000c107210ULL, 0x000fe20007f1e0ffULL, 0x000008000e0c7824ULL, 0x000fe200078e00ffULL,
0x0000006004437810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200000e060dULL,
0x000008000c0d7812ULL, 0x000fe200078ec0ffULL, 0x000000020a12a824ULL, 0x140fe200078e026aULL,
0x00000007410ea211ULL, 0x040fe200078038ffULL, 0x000000020a14a824ULL, 0x000fe200078e026aULL,
0x0000000b410ca211ULL, 0x040fe200078238ffULL, 0x00000001080d7824ULL, 0x000fe400078e020dULL,
0x00000002123fa824ULL, 0x100fe400078e020fULL, 0x000000021445a824ULL, 0x000fe200078e020fULL,
0x00000016410fa211ULL, 0x040fe200000f3cffULL, 0x00000010043b7824ULL, 0x000fe200078e020dULL,
0x00000018410da211ULL, 0x000fe200008f3cffULL, 0x000000083f3fa824ULL, 0x000fc400078e0204ULL,
0x00000010043c7825ULL, 0x000fc600078e0010ULL, 0x000045803f3fa811ULL, 0x000fe200078e20ffULL,
0x000000084541a824ULL, 0x000fe200078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800003c3b7faeULL, 0x0003e2000b901c48ULL, 0x0000001013127825ULL, 0x000fc600078e0010ULL,
0x000041804141a811ULL, 0x000fe200078e20ffULL, 0x0000001015147825ULL, 0x100fe200078e0010ULL,
0x00380000123b7faeULL, 0x0003e6000b901c48ULL, 0x0000001043107825ULL, 0x000fe200078e0010ULL,
0x00580000143b7faeULL, 0x0003e6000b901c48ULL, 0x00000010040ea825ULL, 0x040fe200078e000eULL,
0x00780000103b7faeULL, 0x0003e6000b901c48ULL, 0x00000010040ca825ULL, 0x000fe200078e000cULL,
0x000000000e3fafaeULL, 0x0003e8000b901c48ULL, 0x000000000c41afaeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000080390c7824ULL, 0x002fe200078e00ffULL,
0x00000001ff107819ULL, 0x000fe20000011604ULL, 0x000000020a0f7824ULL, 0x000fe200078e026aULL,
0x00000002ff447819ULL, 0x000fe20000011604ULL, 0x00000010040d7824ULL, 0x000fe200078e00ffULL,
0x000000800c0c7812ULL, 0x000fc400078ec0ffULL, 0x0000000844487810ULL, 0x040fe20007ffe0ffULL,
0x0000000844147824ULL, 0x000fe200078e00ffULL, 0x000000700d0d7812ULL, 0x000fe200078ec0ffULL,
0x000001000f0e7824ULL, 0x000fe200078e000cULL, 0x0000000c100c7812ULL, 0x000fe200078ec0ffULL,
0x00000008443e7824ULL, 0x040fe200078e00ffULL, 0x00000001440f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000844427824ULL, 0x000fe200078e00ffULL, 0x0000000e0c107210ULL, 0x000fe20007ffe00dULL,
0x00000800390e7824ULL, 0x000fe200078e00ffULL, 0xfffffff814137812ULL, 0x000fe200078ee20fULL,
0x00000008444a7824ULL, 0x040fe200078e00ffULL, 0x0000000244117810ULL, 0x040fe20007ffe0ffULL,
0x00000008443f7824ULL, 0x000fe200078e00ffULL, 0x000008000e0f7812ULL, 0x000fe200078ec0ffULL,
0x00000004040e7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800010127984ULL, 0x000e620000000800ULL, 0xfffffff83e3b7812ULL, 0x000fe200078ee211ULL,
0x0000000844117824ULL, 0x000fe200078e00ffULL, 0x0000000c0e467812ULL, 0x000fe200078ec0ffULL,
0x00458000103c7984ULL, 0x0004e20000000800ULL, 0x00000003443d7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff811117812ULL, 0x000fe400078ee244ULL, 0xfffffff8423d7812ULL, 0x000fe400078ee23dULL,
0x00000004443e7810ULL, 0x000fc40007ffe0ffULL, 0x0000018008107810ULL, 0x004fe20007ffe00fULL,
0x00000008480f7824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe400078ee23eULL,
0xffffffff443e7810ULL, 0x000fe20007ffe0ffULL, 0x00000010110e7824ULL, 0x000fe200078e0210ULL,
0xfffffff80f0f7812ULL, 0x000fe400078ee248ULL, 0x0000000239397810ULL, 0x000fe20007ffe0ffULL,
0x00000001460e7824ULL, 0x000fe400078e020eULL, 0x000000100f0f7824ULL, 0x000fe200078e0210ULL,
0x0000030039007a0cULL, 0x000fc40003f06070ULL, 0x000000000e117984ULL, 0x000fe20000000800ULL,
0x0000000146147824ULL, 0x000fe400078e020fULL, 0x00000010130f7824ULL, 0x100fe200078e0210ULL,
0x0000000544137810ULL, 0x000fe40007ffe0ffULL, 0x0000000014407984ULL, 0x000ea40000000800ULL,
0x0000000f460f7210ULL, 0x000fe40007ffe0ffULL, 0xfffffff84a437812ULL, 0x000fe200078ee213ULL,
0x000000103b137824ULL, 0x000fe200078e0210ULL, 0x00000006443b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001217127221ULL, 0x002fe20000010100ULL, 0x000400000f417984ULL, 0x000fe20000000800ULL,
0x0000000146137824ULL, 0x000fc400078e0213ULL, 0x3fb8aa3b12127820ULL, 0x000fc60000410000ULL,
0x0000000013147984ULL, 0x000fe20000000800ULL, 0x0000001200157308ULL, 0x0002e60000000800ULL,
0x0004000013427984ULL, 0x000fe80000000800ULL, 0x000000000f127984ULL, 0x002fe20000000800ULL,
0x0000003c15457220ULL, 0x008fe20000410000ULL, 0x00000008443c7824ULL, 0x000fc400078e00ffULL,
0x000000103d157824ULL, 0x000fe200078e0210ULL, 0x0000003a453a7221ULL, 0x000fe20000010000ULL,
0x00001f44450e7589ULL, 0x000e6200000e0000ULL, 0x00000008443d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c477812ULL, 0x000fe200078ee23bULL, 0x0000000146157824ULL, 0x040fe200078e0215ULL,
0x00001f48450f7589ULL, 0x00066200000e0000ULL, 0x000000103f3c7824ULL, 0x000fe200078e0210ULL,
0xfffffff83d3f7812ULL, 0x000fe200078ee23eULL, 0x00000010433d7824ULL, 0x000fe200078e0210ULL,
0x00000000153b7984ULL, 0x000e620000000800ULL, 0x00000001463c7824ULL, 0x000fc400078e023cULL,
0x00000010473e7824ULL, 0x100fe200078e0210ULL, 0x0004000015437984ULL, 0x000fe20000000800ULL,
0x000000103f3f7824ULL, 0x000fe400078e0210ULL, 0x00000001463d7824ULL, 0x000fe200078e023dULL,
0x000000003c107984ULL, 0x000e620000000800ULL, 0x20000040ff477230ULL, 0x104fe40000004100ULL,
0x30000011ff457230ULL, 0x008fe20000004100ULL, 0x000400003c447984ULL, 0x000ea20000000800ULL,
0x30000040ff407230ULL, 0x000fc40000004100ULL, 0x20000011ff137230ULL, 0x000fe20000004100ULL,
0x0000000e45307223ULL, 0x082fe20000010030ULL, 0x00000001463e7824ULL, 0x040fe200078e023eULL,
0x000000003d117984ULL, 0x000e620000000800ULL, 0x00000001463f7824ULL, 0x000fe200078e023fULL,
0x0000000f402f7223ULL, 0x080fe2000001002fULL, 0x20000012ff407230ULL, 0x100fe20000004100ULL,
0x0000000e131a7223ULL, 0x080fe2000001001aULL, 0x30000012ff457230ULL, 0x000fe20000004100ULL,
0x000400003d157984ULL, 0x000ee20000000800ULL, 0x20000041ff127230ULL, 0x100fe20000004100ULL,
0x0000000e401f7223ULL, 0x080fe2000001001fULL, 0x30000041ff417230ULL, 0x000fe20000004100ULL,
0x000400003e3c7984ULL, 0x000ee20000000800ULL, 0x20000014ff407230ULL, 0x100fe20000004100ULL,
0x0000000f122d7223ULL, 0x080fe2000001002dULL, 0x0000000e452e7223ULL, 0x080fe2000001002eULL,
0x000000003e137984ULL, 0x000ee20000000800ULL, 0x0000000f412c7223ULL, 0x080fe2000001002cULL,
0x30000014ff417230ULL, 0x000fe20000004100ULL, 0x0000000f47227223ULL, 0x080fe20000010022ULL,
0x000000003f127984ULL, 0x000ee20000000800ULL, 0x20000042ff457230ULL, 0x100fe20000004100ULL,
0x0000000e402b7223ULL, 0x080fe2000001002bULL, 0x30000042ff427230ULL, 0x000fe20000004100ULL,
0x000400003f3d7984ULL, 0x0004e20000000800ULL, 0x2000003bff147230ULL, 0x100fe20000004100ULL,
0x0000000e41387223ULL, 0x080fe20000010038ULL, 0x3000003bff3b7230ULL, 0x000fe20000004100ULL,
0x0000000f452a7223ULL, 0x080fe2000001002aULL, 0x0000000f42297223ULL, 0x000fe20000010029ULL,
0x0000000e14377223ULL, 0x080fe20000010037ULL, 0x20000010ff147230ULL, 0x100fe20000004100ULL,
0x0000000e3b367223ULL, 0x000fe20000010036ULL, 0x30000010ff107230ULL, 0x000fc40000004100ULL,
0x20000043ff3f7230ULL, 0x104fe20000004100ULL, 0x0000000e14277223ULL, 0x080fe20000010027ULL,
0x20000044ff147230ULL, 0x100fe20000004100ULL, 0x0000000e10257223ULL, 0x080fe20000010025ULL,
0x30000043ff437230ULL, 0x000fe20000004100ULL, 0x0000000f3f267223ULL, 0x080fe20000010026ULL,
0x30000011ff107230ULL, 0x102fe20000004100ULL, 0x0000000f14357223ULL, 0x080fe20000010035ULL,
0x20000011ff3b7230ULL, 0x000fe20000004100ULL, 0x0000000f43287223ULL, 0x080fe20000010028ULL,
0x30000044ff3f7230ULL, 0x000fe20000004100ULL, 0x0000000e10237223ULL, 0x080fe20000010023ULL,
0x20000015ff147230ULL, 0x108fe20000004100ULL, 0x0000000e3b247223ULL, 0x080fe20000010024ULL,
0x30000015ff157230ULL, 0x000fe20000004100ULL, 0x0000000f3f347223ULL, 0x080fe20000010034ULL,
0x2000003cff117230ULL, 0x100fe20000004100ULL, 0x0000000f14337223ULL, 0x080fe20000010033ULL,
0x3000003cff3c7230ULL, 0x000fe20000004100ULL, 0x0000000f15327223ULL, 0x080fe20000010032ULL,
0x20000013ff107230ULL, 0x100fe20000004100ULL, 0x0000000f11207223ULL, 0x080fe20000010020ULL,
0x30000013ff147230ULL, 0x000fe20000004100ULL, 0x0000000f3c317223ULL, 0x000fe20000010031ULL,
0x20000012ff117230ULL, 0x100fe20000004100ULL, 0x0000000e101b7223ULL, 0x080fe2000001001bULL,
0x30000012ff127230ULL, 0x000fe20000004100ULL, 0x0000000e14217223ULL, 0x080fe20000010021ULL,
0x2000003dff137230ULL, 0x100fe20000004100ULL, 0x0000000e111e7223ULL, 0x080fe2000001001eULL,
0x3000003dff107230ULL, 0x000fe20000004100ULL, 0x0000000e121d7223ULL, 0x000fc4000001001dULL,
0x0000000f131c7223ULL, 0x080fe4000001001cULL, 0x0000000f10197223ULL, 0x000fe20000010019ULL,
0xfffff3c000008947ULL, 0x000fea000383ffffULL, 0x000000ff6a00720cULL, 0x000fe20003f05270ULL,
0x0000018000007945ULL, 0x000fd80003800000ULL, 0x000000800a038824ULL, 0x000fc800078e020dULL,
0x000000010c038824ULL, 0x000fe400078e0203ULL, 0x000000010d0c7824ULL, 0x000fc600078e020cULL,
0x0049803a03008388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x004980000c007984ULL, 0x000e680000000800ULL, 0x004a00000c077984ULL, 0x000ea20000000800ULL,
0x00000000ff007221ULL, 0x002fc80000010000ULL, 0x0000000700007221ULL, 0x004fca0000010000ULL,
0x0180000000027810ULL, 0x000fc80007ffe0ffULL, 0x7f80000002027812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e0000ULL,
0x0000b0e000087802ULL, 0x000fc40000000f00ULL, 0x00008bb000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff027224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000000037308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc80000000003ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000203027223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff0b7819ULL, 0x004fc40000011604ULL,
0x00000008040d7811ULL, 0x000fe400078ff0ffULL, 0x000000020b0c7810ULL, 0x040fe20007ffe0ffULL,
0x00001f0b02007589ULL, 0x000ea200000e0000ULL, 0x000000080b117824ULL, 0x040fe200078e00ffULL,
0x000000030b0e7810ULL, 0x040fe20007ffe0ffULL, 0x000000080b137824ULL, 0x040fe200078e00ffULL,
0x00001f0d02077589ULL, 0x0022e200000e0000ULL, 0x000000080b157824ULL, 0x040fe200078e00ffULL,
0x000000040b0f7810ULL, 0x040fe20007ffe0ffULL, 0x000000080b107824ULL, 0x000fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fc400078ee20cULL, 0xfffffff815157812ULL, 0x000fe400078ee20eULL,
0xfffffff810177812ULL, 0x040fe200078ee20fULL, 0x0000001013137824ULL, 0x100fe200078e0206ULL,
0x000000060b0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001015157824ULL, 0x100fe200078e0206ULL,
0xffffffff0b0e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001017177824ULL, 0x000fe200078e0206ULL,
0xfffffff8100f7812ULL, 0x000fe200078ee20bULL, 0x000000080d107824ULL, 0x000fc800078e00ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0206ULL, 0x0000001a001a7220ULL, 0x044fe20000410000ULL,
0x0000003000037220ULL, 0x040fe20000410000ULL, 0x0000001f001f7220ULL, 0x040fe20000410000ULL,
0x0000002e002e7220ULL, 0x040fe20000410000ULL, 0x0000002b002b7220ULL, 0x040fe20000410000ULL,
0x0000003800387220ULL, 0x040fe20000410000ULL, 0x0000003700377220ULL, 0x040fe20000410000ULL,
0x0000003600367220ULL, 0x040fe20000410000ULL, 0x0000002700277220ULL, 0x040fe20000410000ULL,
0x0000002500087220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x040fe20000410000ULL,
0x0000002300237220ULL, 0x040fe20000410000ULL, 0x0000001b001b7220ULL, 0x040fe20000410000ULL,
0x0000002100027220ULL, 0x042fe20000410000ULL, 0x0000001e001e7220ULL, 0x040fe20000410000ULL,
0x0000001d001d7220ULL, 0x000fe20000410000ULL, 0x000000010b007810ULL, 0x000fe20007ffe0ffULL,
0x0000002207227220ULL, 0x048fe20000410000ULL, 0x0000002f072f7220ULL, 0x040fe20000410000ULL,
0x0000002d072d7220ULL, 0x040fe20000410000ULL, 0x0000002c072c7220ULL, 0x040fe20000410000ULL,
0x0000002a072a7220ULL, 0x040fe20000410000ULL, 0x0000002907297220ULL, 0x040fe20000410000ULL,
0x0000002607267220ULL, 0x040fe20000410000ULL, 0x0000002807097220ULL, 0x040fe20000410000ULL,
0x0000003507357220ULL, 0x040fe20000410000ULL, 0x0000003407347220ULL, 0x040fe20000410000ULL,
0x0000003307337220ULL, 0x040fe20000410000ULL, 0x0000003207327220ULL, 0x040fe20000410000ULL,
0x0000002007207220ULL, 0x040fe20000410000ULL, 0x0000003107317220ULL, 0x040fe20000410000ULL,
0x0000001c071c7220ULL, 0x040fe20000410000ULL, 0x0000001907077220ULL, 0x000fe20000410000ULL,
0xfffffff811117812ULL, 0x000fe200078ee200ULL, 0x000000080b197824ULL, 0x040fe200078e00ffULL,
0x000000050b007810ULL, 0x040fe20007ffe0ffULL, 0x000000080b217824ULL, 0x040fe200078e00ffULL,
0x000000270808723eULL, 0x000fe200000000ffULL, 0x000000080b257824ULL, 0x000fe200078e00ffULL,
0xfffffff8190b7812ULL, 0x000fe200078ee200ULL, 0x0000000404007824ULL, 0x000fe200078e00ffULL,
0xfffffff821197812ULL, 0x000fe200078ee20cULL, 0x0000001011117824ULL, 0x000fe200078e0206ULL,
0xfffffff825217812ULL, 0x000fc400078ee20eULL, 0xfffffff810257812ULL, 0x000fe200078ee20dULL,
0x000000100b0d7824ULL, 0x100fe200078e0206ULL, 0x0000000c00007812ULL, 0x000fe400078ec0ffULL,
0x0000001b0202723eULL, 0x000fe200000000ffULL, 0x00000010211b7824ULL, 0x100fe200078e0206ULL,
0x0000000619197211ULL, 0x000fe200078e20ffULL, 0x0000001025277824ULL, 0x000fe200078e0206ULL,
0x0000001a0303723eULL, 0x000fe200000000ffULL, 0x000000010f067824ULL, 0x000fe200078e0200ULL,
0x0000001f2e1f723eULL, 0x000fe200000000ffULL, 0x0000000100117824ULL, 0x000fe200078e0211ULL,
0x0000002b382b723eULL, 0x000fe200000000ffULL, 0x0000000100147824ULL, 0x000fe200078e0213ULL,
0x000000373636723eULL, 0x000fe200000000ffULL, 0x00000001000b7824ULL, 0x040fe200078e0215ULL,
0x0000001c0707723eULL, 0x000fe200000000ffULL, 0x0000000100217824ULL, 0x040fe200078e0217ULL,
0x000000242323723eULL, 0x000fe200000000ffULL, 0x00000001001c7824ULL, 0x040fe200078e020dULL,
0x0000000306007388ULL, 0x000fe20000000800ULL, 0x0000001e1d1d723eULL, 0x000fe200000000ffULL,
0x0000000100257824ULL, 0x040fe200078e0219ULL, 0x000000222f22723eULL, 0x000fe200000000ffULL,
0x0000001f11007388ULL, 0x000fe20000000800ULL, 0x00000001001e7824ULL, 0x000fe200078e021bULL,
0x0000002d2c2c723eULL, 0x000fe200000000ffULL, 0x0000000100277824ULL, 0x000fe200078e0227ULL,
0x0000002b14007388ULL, 0x000fe20000000800ULL, 0x0000002a2929723eULL, 0x000fe200000000ffULL,
0x000000016f007824ULL, 0x000fe200078e0204ULL, 0x000000260909723eULL, 0x000fe200000000ffULL,
0x000000360b007388ULL, 0x000fe20000000800ULL, 0x000000353434723eULL, 0x000fe200000000ffULL,
0x0000001000007824ULL, 0x000fe200078e0205ULL, 0x000000333232723eULL, 0x000fe200000000ffULL,
0x0000000821007388ULL, 0x000fe20000000800ULL, 0x000000203120723eULL, 0x000fc600000000ffULL,
0x000000231c007388ULL, 0x000fe80000000800ULL, 0x0000000225007388ULL, 0x000fe80000000800ULL,
0x0000001d1e007388ULL, 0x000fe80000000800ULL, 0x0000002227007388ULL, 0x000fe80000000800ULL,
0x0004002c11007388ULL, 0x000fe80000000800ULL, 0x0004002914007388ULL, 0x000fe80000000800ULL,
0x000400090b007388ULL, 0x000fe80000000800ULL, 0x0004003421007388ULL, 0x000fe80000000800ULL,
0x000400321c007388ULL, 0x000fe80000000800ULL, 0x0004002025007388ULL, 0x000fe80000000800ULL,
0x000400071e007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000000c7984ULL, 0x000e680000000c00ULL, 0x0004000000147984ULL, 0x000ea80000000c00ULL,
0x0008000000107984ULL, 0x000ee80000000c00ULL, 0x000c000000187984ULL, 0x000ee20000000c00ULL,
0x200000ff0f0f7230ULL, 0x002fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff17177230ULL, 0x004fe40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fc40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x000000130f0f7230ULL, 0x008fe40000000000ULL, 0x000000120e0e7230ULL, 0x000fe40000000000ULL,
0x000000110d0d7230ULL, 0x000fe40000000000ULL, 0x000000100c0c7230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x000fc40000000000ULL, 0x0000001a16167230ULL, 0x000fe20000000000ULL,
0x0000000c00007388ULL, 0x000fe20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fca0000000000ULL, 0x0004001400007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff037819ULL, 0x000fc80000011604ULL,
0x000000720300720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0x0000000103007824ULL, 0x100fe200078e0204ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x00005a0071717a19ULL, 0x000fe200000006ffULL,
0x00005a0000067ab9ULL, 0x000fe20000000800ULL, 0x00000020040d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000605057299ULL, 0x000fe2000800063fULL, 0x0000000700077812ULL, 0x000fe200078ec0ffULL,
0x0000001073007824ULL, 0x000fe200078e0203ULL, 0x0000580000067ab9ULL, 0x000fe40000000800ULL,
0x0ffffff807027812ULL, 0x000fc400078ef804ULL, 0x0000000500037c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff067a19ULL, 0x000fe20000011600ULL, 0x0000001002027824ULL, 0x000fe200078e0205ULL,
0x0000000704077812ULL, 0x000fe200078ec0ffULL, 0x0000000171037824ULL, 0x000fc600078e0203ULL,
0x0000000002087984ULL, 0x0004e20000000c00ULL, 0x0000007706037224ULL, 0x000fe200078e0203ULL,
0x00000006040472a4ULL, 0x002fe2000f8e023fULL, 0x000000086a077824ULL, 0x000fca00078e0207ULL,
0x0000000477007c24ULL, 0x000fca000f8e02ffULL, 0x0000000300037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x004fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fe400000f4406ULL, 0x00000003ff067819ULL, 0x000fc6000001160dULL,
0x0000001007027825ULL, 0x000fe200078e0002ULL, 0x000000720600720cULL, 0x000fc80003f06070ULL,
0x0000000802007986ULL, 0x0083f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010d027824ULL, 0x102fe200078e0206ULL, 0x00000040040f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001073067824ULL, 0x000fc600078e0206ULL, 0x0000000702027812ULL, 0x000fc800078ec0ffULL,
0x0ffffff802027812ULL, 0x000fe400078ef80dULL, 0x000000070d0d7812ULL, 0x000fc600078ec0ffULL,
0x0000001002077824ULL, 0x000fe200078e0205ULL, 0x0000000506027c12ULL, 0x000fe2000f8e30ffULL,
0x000000086a0d7824ULL, 0x000fe200078e020dULL, 0x00005a00ff067a19ULL, 0x000fe40000011606ULL,
0x0000000007087984ULL, 0x000e620000000c00ULL, 0x0000000171027824ULL, 0x000fc800078e0202ULL,
0x0000007706037224ULL, 0x000fca00078e0202ULL, 0x0000000300037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fe400000f4406ULL, 0x00000003ff067819ULL, 0x000fc6000001160fULL,
0x000000100d027825ULL, 0x000fe200078e0002ULL, 0x000000720600720cULL, 0x000fc80003f06070ULL,
0x0000000802007986ULL, 0x0023f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010f027824ULL, 0x102fe200078e0206ULL, 0x0000006004117810ULL, 0x000fe20007ffe0ffULL,
0x0000001073067824ULL, 0x000fe200078e0206ULL, 0x000000070f0d7812ULL, 0x000fc400078ec0ffULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x00000003ff047819ULL, 0x000fe20000011611ULL,
0x000000086a0d7824ULL, 0x000fe200078e020dULL, 0x0ffffff802027812ULL, 0x000fca00078ef80fULL,
0x0000001002077824ULL, 0x000fe200078e0205ULL, 0x0000000506027c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff067a19ULL, 0x000fe40000011606ULL, 0x0000000007087984ULL, 0x000e620000000c00ULL,
0x0000000171027824ULL, 0x000fc800078e0202ULL, 0x0000007706037224ULL, 0x000fca00078e0202ULL,
0x0000000300037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fe200000f4406ULL,
0x0000000111067824ULL, 0x000fe200078e0204ULL, 0x000000720400720cULL, 0x000fc60003f06070ULL,
0x000000100d027825ULL, 0x000fe200078e0002ULL, 0x0000000706067812ULL, 0x000fc800078ec0ffULL,
0xfffffff806067812ULL, 0x000fe200078ef811ULL, 0x0000000802007986ULL, 0x0023e8000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001006067824ULL, 0x000fe200078e0205ULL,
0x0000000711057812ULL, 0x000fe200078ec0ffULL, 0x0000001073047824ULL, 0x000fc600078e0204ULL,
0x0000000006087984ULL, 0x002e620000000c00ULL, 0x000000086a057824ULL, 0x000fe200078e0205ULL,
0x0000000504027c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff047a19ULL, 0x000fe40000011604ULL,
0x0000000271027210ULL, 0x000fca0007ffe0ffULL, 0x0000007704777224ULL, 0x000fca00078e0202ULL,
0x0000007700777210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005c0077027a11ULL, 0x000fc800078040ffULL, 0x00005d0077037a11ULL, 0x000fca00000f4400ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff057819ULL, 0x002fca0000011600ULL,
0x0000000202047824ULL, 0x000fca00078e0205ULL, 0x0000006d0400720cULL, 0x000fda0003f06070ULL,
0x0000000276058824ULL, 0x000fc800078e00ffULL, 0x00006800050a8a24ULL, 0x000fe400078e0204ULL,
0xffffffffff057424ULL, 0x000fe400078e00ffULL, 0x000064000a0a8625ULL, 0x000fe200078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000080a058981ULL, 0x000ea2000c1e1900ULL,
0x0000000102077810ULL, 0x000fe20007ffe0ffULL, 0x0000004000747824ULL, 0x000fe400078e00ffULL,
0x000000800c737824ULL, 0x000fe200078e00ffULL, 0x000000660700720cULL, 0x000fe20003f06070ULL,
0x00000080716a7824ULL, 0x000fe200078e00ffULL, 0x01360000ff087f8cULL, 0x000e62000c80043fULL,
0x0000010002137824ULL, 0x000fc400078e0274ULL, 0x00000100ff0c7424ULL, 0x000fc600078e00ffULL,
0x000000406a267812ULL, 0x000fe200078ef813ULL, 0x0000007305077224ULL, 0x004fc800078e02ffULL,
0x00006200070a7625ULL, 0x000fe200078e000cULL, 0x0000060000008947ULL, 0x000fea0003800000ULL,
0x00000002ff247819ULL, 0x002fe40000011603ULL, 0x0000001362077217ULL, 0x000fe40007800000ULL,
0x00000010241d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001260c7824ULL, 0x000fe200078e0224ULL,
0x0000000824187810ULL, 0x040fe20007ffe0ffULL, 0x0000000107077824ULL, 0x000fe200078e0a13ULL,
0x00000018241f7810ULL, 0x000fe20007ffe0ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x00000020241e7810ULL, 0x000fc40007ffe0ffULL, 0x00000003031a7211ULL, 0x000fe200078fe8ffULL,
0x0000000126107824ULL, 0x000fe200078e021dULL, 0x000000300c157812ULL, 0x000fe200078ef806ULL,
0x00000001260e7824ULL, 0x000fe200078e0218ULL, 0x000000031a1a7812ULL, 0x000fe200078ec0ffULL,
0x0000000126127824ULL, 0x000fe200078e021fULL, 0x000000150a147210ULL, 0x000fe20007f1e0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x0000002824207810ULL, 0x000fe40007ffe0ffULL,
0x00001000001c7811ULL, 0x000fe200078e68ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000003010177812ULL, 0x000fc400078ef806ULL, 0x0ffffffc1a037812ULL, 0x000fe200078ef803ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x000000300e197812ULL, 0x100fe400078ef806ULL,
0x000000170a0c7210ULL, 0x000fe20007f3e0ffULL, 0x000000010b157824ULL, 0x040fe200000e060dULL,
0x00000030120d7812ULL, 0x000fe200078ef806ULL, 0x0000000126107824ULL, 0x000fe200078e021eULL,
0x000000190a167210ULL, 0x000fe20007f1e0ffULL, 0x0000000418197824ULL, 0x000fe200078e00ffULL,
0x0000000d0a0e7210ULL, 0x000fe20007f5e0ffULL, 0x000000010b0d7824ULL, 0x000fe200008e0611ULL,
0x000000071800720cULL, 0x000fe20003f26070ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x0000003024227810ULL, 0x000fc40007ffe0ffULL, 0x000000071d00720cULL, 0x080fe20003fa6070ULL,
0x000000010b177824ULL, 0x040fe200000e060fULL, 0x000000072400720cULL, 0x000fe20003f06070ULL,
0x000000010b0f7824ULL, 0x000fe200010e0613ULL, 0x0000003010137812ULL, 0x000fe200078ef806ULL,
0x0000000126127824ULL, 0x000fe200078e0220ULL, 0x0000003824247810ULL, 0x000fe20007ffe0ffULL,
0x0000001003037824ULL, 0x000fe200078e021cULL, 0x000000130a107210ULL, 0x000fe40007f5e0ffULL,
0xfffffffc19137812ULL, 0x000fe200078ee21aULL, 0x0000000424217824ULL, 0x000fe200078e00ffULL,
0x000000071f00720cULL, 0x080fe20003f86070ULL, 0x000000010b117824ULL, 0x000fe200010e0611ULL,
0x000000071e00720cULL, 0x080fe20003f66070ULL, 0x00000010131b7824ULL, 0x000fe200078e021cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000014037faeULL, 0x0003e2000c101c48ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x000000072000720cULL, 0x000fc40003f46070ULL,
0x00000000161b7faeULL, 0x0005e2000c901c48ULL, 0x000000072200720cULL, 0x080fe40003f26070ULL,
0x0000003012197812ULL, 0x000fe200078ef806ULL, 0x0000000126127824ULL, 0x000fe200078e0222ULL,
0x000000072400720cULL, 0x000fe20003f06070ULL, 0x000000041f077824ULL, 0x000fe200078e00ffULL,
0x000000190a187210ULL, 0x000fe20007fde0ffULL, 0x0000000126147824ULL, 0x002fe200078e0224ULL,
0xfffffffc21217812ULL, 0x100fe200078ee21aULL, 0x000000041d037824ULL, 0x000fe200078e00ffULL,
0xfffffffc07077812ULL, 0x000fe200078ee21aULL, 0x000000010b197824ULL, 0x000fc400030e0613ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0xfffffffc03037812ULL, 0x000fc600078ee21aULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x0000003012177812ULL, 0x004fc600078ef806ULL,
0x000000041e1b7824ULL, 0x000fe200078e00ffULL, 0x000000170a127210ULL, 0x000fe20007fde0ffULL,
0x00000004201d7824ULL, 0x000fe200078e00ffULL, 0x0000003014237812ULL, 0x000fe200078ef806ULL,
0x00000004221f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1b1b7812ULL, 0x000fe200078ee21aULL,
0x0000001003037824ULL, 0x000fe200078e021cULL, 0xfffffffc1d1d7812ULL, 0x000fe200078ee21aULL,
0x0000001007177824ULL, 0x000fe200078e021cULL, 0xfffffffc1f1f7812ULL, 0x000fe200078ee21aULL,
0x000000101b1b7824ULL, 0x100fe200078e021cULL, 0x000000130b137210ULL, 0x000fe200037fe4ffULL,
0x000000101d1d7824ULL, 0x100fe200078e021cULL, 0x000000230a067210ULL, 0x000fe20007fde0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e021cULL, 0x000000000c037faeULL, 0x0003e2000e901c48ULL,
0x0000001021217824ULL, 0x000fc400078e021cULL, 0x000000010b077824ULL, 0x000fe200030e0615ULL,
0x000000000e177faeULL, 0x0003e8000e101c48ULL, 0x00000000101b7faeULL, 0x0003e8000d901c48ULL,
0x00000000181d7faeULL, 0x0003e8000d101c48ULL, 0x00000000121f7faeULL, 0x0003e8000c901c48ULL,
0x0000000006217faeULL, 0x0003e2000c101c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x00000003030e7211ULL, 0x042fe400078fe8ffULL, 0x0000000803157811ULL, 0x000fc400078ff0ffULL,
0x0000001003077811ULL, 0x040fe400078ff0ffULL, 0x00000018030d7811ULL, 0x000fe200078ff0ffULL,
0x0000000415177824ULL, 0x000fe200078e00ffULL, 0x00000020030f7811ULL, 0x040fe200078ff0ffULL,
0x0000000126107824ULL, 0x040fe200078e0207ULL, 0x0000002803117811ULL, 0x000fe200078ff0ffULL,
0x000000040d197824ULL, 0x000fe200078e00ffULL, 0x0000003003137811ULL, 0x000fe200078ff0ffULL,
0x0000000407077824ULL, 0x000fe200078e00ffULL, 0x0000003803147811ULL, 0x040fe200078ff0ffULL,
0x00000001261c7824ULL, 0x040fe200078e0211ULL, 0x00000026030c7211ULL, 0x000fe200078ff0ffULL,
0x00000001261e7824ULL, 0x000fe200078e0213ULL, 0x000000030e1a7812ULL, 0x000fe200078ec0ffULL,
0x00000001260e7824ULL, 0x000fe200078e0215ULL, 0x0000100000227811ULL, 0x000fe200078e68ffULL,
0x0000000126157824ULL, 0x000fe200078e020fULL, 0x0ffffffc1a1d7812ULL, 0x000fe200078ef803ULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc17037812ULL, 0x100fe200078ee21aULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0xfffffffc07077812ULL, 0x100fe200078ee21aULL,
0x0000000413137824ULL, 0x000fe200078e00ffULL, 0xfffffffc0f177812ULL, 0x100fe200078ee21aULL,
0x0000000126127824ULL, 0x000fe200078e020dULL, 0xfffffffc11187812ULL, 0x000fe200078ee21aULL,
0x00000004141b7824ULL, 0x000fc400078e00ffULL, 0x000001000c0c7825ULL, 0x000fc800078e00ffULL,
0x0000000126207824ULL, 0x000fe200078e0214ULL, 0xfffffffc19147812ULL, 0x100fe200078ee21aULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffffc13197812ULL, 0x100fe400078ee21aULL,
0xfffffffc1b1a7812ULL, 0x000fe200078ee21aULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000300c1b7812ULL, 0x000fc600078ef806ULL, 0x000000101d2f7824ULL, 0x100fe200078e0222ULL,
0x0000001b0a167210ULL, 0x000fe20007f1e0ffULL, 0x00000010071d7824ULL, 0x000fe200078e0222ULL,
0x000000300e077812ULL, 0x100fe200078ef806ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x00000030101b7812ULL, 0x000fc600078ef806ULL, 0x0000001018237824ULL, 0x100fe200078e0222ULL,
0x000000070a187210ULL, 0x000fe20007f3e0ffULL, 0x000000101a277824ULL, 0x100fe200078e0222ULL,
0x0000001b0a1a7210ULL, 0x000fe20007f5e0ffULL, 0x0000001017217824ULL, 0x000fe200078e0222ULL,
0x0000003012077812ULL, 0x000fe200078ef806ULL, 0x000000010b177824ULL, 0x000fe400000e060dULL,
0x0000001019257824ULL, 0x000fe200078e0222ULL, 0x000000070a127210ULL, 0x000fe20007f1e0ffULL,
0x00000100150c7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000162f7faeULL, 0x0003e6000b901c48ULL, 0x000000010b197824ULL, 0x040fe200008e060fULL,
0x000000300c2d7812ULL, 0x000fe200078ef806ULL, 0x000000010b1b7824ULL, 0x000fc400010e0611ULL,
0x00000010141f7824ULL, 0x000fe400078e0222ULL, 0x000001001c0e7825ULL, 0x000fc800078e00ffULL,
0x000001001e107825ULL, 0x000fe200078e00ffULL, 0x000000300e2b7812ULL, 0x000fc600078ef806ULL,
0x0000010020147825ULL, 0x000fe200078e00ffULL, 0x0000003010297812ULL, 0x100fe400078ef806ULL,
0x0000002b0a0c7210ULL, 0x000fe20007f3e0ffULL, 0x000000010b137824ULL, 0x000fe200000e0613ULL,
0x0000003014077812ULL, 0x000fe200078ef806ULL, 0x0000001003037824ULL, 0x000fe200078e0222ULL,
0x0000002d0a067210ULL, 0x040fe40007f1e0ffULL, 0x000000290a0e7210ULL, 0x040fe40007f5e0ffULL,
0x000000070a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000010b077824ULL, 0x040fe200000e060dULL,
0x0000000f0b0d7210ULL, 0x040fe20000ffe4ffULL, 0x000000010b0f7824ULL, 0x040fe200010e0611ULL,
0x0000000018037faeULL, 0x0003e2000b901c48ULL, 0x000000010b0b7824ULL, 0x000fc600018e0615ULL,
0x000000001a1d7faeULL, 0x0003e8000b901c48ULL, 0x00000000121f7faeULL, 0x0003e8000b901c48ULL,
0x0000000006217faeULL, 0x0003e8000b901c48ULL, 0x000000000c237faeULL, 0x0003e8000b901c48ULL,
0x000000000e257faeULL, 0x0003e8000b901c48ULL, 0x000000000a277faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000067805ULL, 0x002fc40000015200ULL,
0x01360400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fc40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a060a7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e07ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc8000001140bULL,
0x0000000a03037211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e060bULL,
0x0000000203037819ULL, 0x000fc8000000120aULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01360400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000660200720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000697919ULL, 0x000e620000000000ULL, 0x00005800ff6b7624ULL, 0x000fe200078e00ffULL,
0x80005800626f7a10ULL, 0x000fe20007ffe0ffULL, 0x0000680076767a24ULL, 0x000fe200078e02ffULL,
0x0001368800717811ULL, 0x040fe200078e18ffULL, 0x0000002000727824ULL, 0x000fe200078e00ffULL,
0x0000001f6b037810ULL, 0x040fe40007ffe0ffULL, 0xffffffff6b707810ULL, 0x000fe40007ffe0ffULL,
0x00000004ff037819ULL, 0x000fc40000011603ULL, 0x000000096b6b7810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff6f7819ULL, 0x000fe4000001166fULL, 0x0ffffffe036c7812ULL, 0x000fc400078ec0ffULL,
0x0000000102077810ULL, 0x040fe20007ffe0ffULL, 0x0000010002037824ULL, 0x000fe200078e0274ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000005734c7224ULL, 0x000fe200078e02ffULL,
0x000000660700720cULL, 0x000fe20003f06070ULL, 0x00000100ff757424ULL, 0x000fe200078e00ffULL,
0x0000004003057812ULL, 0x000fc600078ec0ffULL, 0x000062004c4c7625ULL, 0x000fc800078e0075ULL,
0x000000016a057824ULL, 0x000fc800078e0205ULL, 0x0000064000008947ULL, 0x00cfea0003800000ULL,
0x00000002ff1c7819ULL, 0x002fe20000011669ULL, 0x0000001069067824ULL, 0x040fe200078e00ffULL,
0x0ffffffc69127812ULL, 0x000fe400078ec0ffULL, 0x000000081c1e7810ULL, 0x040fe20007ffe0ffULL,
0x000000011c087824ULL, 0x000fe200078e0205ULL, 0x0000003006067812ULL, 0x000fe400078ec0ffULL,
0x000000101c207810ULL, 0x000fe20007ffe0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000004006137812ULL, 0x000fc400078efcffULL, 0x000000201c247810ULL, 0x000fe20007ffe0ffULL,
0x000000011e0a7824ULL, 0x100fe200078e0205ULL, 0x000000181c227810ULL, 0x000fe20007ffe0ffULL,
0x00000001200c7824ULL, 0x100fe200078e0205ULL, 0x0000001308157212ULL, 0x000fe200078efcffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x00002000001a7811ULL, 0x000fe400078e68ffULL,
0x000000154c147210ULL, 0x000fe20007f3e0ffULL, 0x0000000124107824ULL, 0x000fe200078e0205ULL,
0x000000130a177212ULL, 0x000fe200078efcffULL, 0x000001000c0c7825ULL, 0x000fc800078e00ffULL,
0x00000001220e7824ULL, 0x000fe200078e0205ULL, 0x000000130c197212ULL, 0x000fe200078efcffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x00000003620c7217ULL, 0x000fe40007800000ULL,
0x000000194c187210ULL, 0x000fe20007f5e0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001310077212ULL, 0x000fc600078efcffULL, 0x000000014d157824ULL, 0x040fe200008e0609ULL,
0x000000174c167210ULL, 0x000fe20007f3e0ffULL, 0x000000014d197824ULL, 0x040fe200010e060dULL,
0x000000130e097212ULL, 0x000fe400078efcffULL, 0x000000074c0a7210ULL, 0x000fe20007f7e0ffULL,
0x000000014d177824ULL, 0x040fe200008e060bULL, 0x000000281c0e7810ULL, 0x000fe20007ffe0ffULL,
0x000000010c077824ULL, 0x000fe200078e0a03ULL, 0x000000094c087210ULL, 0x000fe20007f3e0ffULL,
0x000000014d0b7824ULL, 0x000fe200018e0611ULL, 0x00000069690d7211ULL, 0x000fe200078fe8ffULL,
0x000000010e0c7824ULL, 0x000fe200078e0205ULL, 0x000000071e00720cULL, 0x0c0fe20003f46070ULL,
0x000000014d097824ULL, 0x000fe200008e060fULL, 0x000000030d1f7812ULL, 0x000fe200078ec0ffULL,
0x000000041e1e7824ULL, 0x000fe200078e00ffULL, 0x000000072000720cULL, 0x0c0fe20003f66070ULL,
0x0000000420207824ULL, 0x000fe200078e00ffULL, 0x000000071c00720cULL, 0x000fe20003f26070ULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x000000121f0f7212ULL, 0x000fc400078efcffULL,
0xfffffffc1e1b7812ULL, 0x100fe400078ee21fULL, 0xfffffffc201d7812ULL, 0x000fe200078ee21fULL,
0x000000100f0f7824ULL, 0x100fe200078e021aULL, 0x000000130c117212ULL, 0x000fe200078efcffULL,
0x000000101b1b7824ULL, 0x100fe200078e021aULL, 0x000000301c1e7810ULL, 0x000fe20007ffe0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e021aULL, 0x000000114c107210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140f7faeULL, 0x0003e2000c901c48ULL,
0x000000381c1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000011e0c7824ULL, 0x000fe200078e0205ULL,
0x000000072200720cULL, 0x080fe20003fa6070ULL, 0x00000000161b7faeULL, 0x0005e2000d101c48ULL,
0x000000014d117824ULL, 0x000fe200030e060dULL, 0x000000072400720cULL, 0x080fe20003f86070ULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x00000000181d7faeULL, 0x0007e2000d901c48ULL,
0x000000070e00720cULL, 0x000fc40003f66070ULL, 0x000000071e00720cULL, 0x000fe20003f46070ULL,
0x000000040e147824ULL, 0x002fe200078e00ffULL, 0x000000051c0e7210ULL, 0x000fe20007ffe0ffULL,
0x0000000422227824ULL, 0x000fe200078e00ffULL, 0x000000071c00720cULL, 0x000fe20003f26070ULL,
0x0000000424247824ULL, 0x000fe200078e00ffULL, 0x000000130c077212ULL, 0x000fe200078efcffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffffc22177812ULL, 0x104fe400078ee21fULL,
0x000000074c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0x000000130e157212ULL, 0x000fe200078efcffULL, 0x000000041c1c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc24197812ULL, 0x008fe200078ee21fULL, 0x000000014d0d7824ULL, 0x000fe200030e060dULL,
0xfffffffc141b7812ULL, 0x100fe200078ee21fULL, 0x0000001017077824ULL, 0x100fe200078e021aULL,
0xfffffffc1e1d7812ULL, 0x100fe200078ee21fULL, 0x0000001019137824ULL, 0x000fe200078e021aULL,
0xfffffffc1c1f7812ULL, 0x000fc400078ee21fULL, 0x000000154c0e7210ULL, 0x000fe20007fde0ffULL,
0x000000101b157824ULL, 0x100fe200078e021aULL, 0x0000000008077faeULL, 0x0003e2000e901c48ULL,
0x000000101d177824ULL, 0x100fe400078e021aULL, 0x000000101f197824ULL, 0x000fe200078e021aULL,
0x000000000a137faeULL, 0x0003e2000e101c48ULL, 0x000000014d0f7824ULL, 0x000fc600030e060fULL,
0x0000000010157faeULL, 0x0003e8000d901c48ULL, 0x000000000c177faeULL, 0x0003e8000d101c48ULL,
0x000000000e197faeULL, 0x0003e2000c901c48ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x00000008690c7811ULL, 0x042fe200078ff0ffULL, 0x0000001069067824ULL, 0x040fe200078e00ffULL,
0x00000010690e7811ULL, 0x000fc400078ff0ffULL, 0x0000001869147811ULL, 0x040fe200078ff0ffULL,
0x000000010c0a7824ULL, 0x140fe200078e0205ULL, 0x00000020691a7811ULL, 0x040fe200078ff0ffULL,
0x000000040c167824ULL, 0x000fe200078e00ffULL, 0x00000028691c7811ULL, 0x040fe200078ff0ffULL,
0x000000010e0c7824ULL, 0x140fe200078e0205ULL, 0x00000030691e7811ULL, 0x040fe200078ff0ffULL,
0x000000040e187824ULL, 0x000fe200078e00ffULL, 0x0000003869207811ULL, 0x040fe200078ff0ffULL,
0x00000001140e7824ULL, 0x040fe200078e0205ULL, 0x0000006969077211ULL, 0x040fe200078fe8ffULL,
0x0000000414147824ULL, 0x000fe200078e00ffULL, 0x0ffffffc69127812ULL, 0x000fe200078ec0ffULL,
0x000000041a227824ULL, 0x000fe200078e00ffULL, 0x0000000307077812ULL, 0x000fe200078ec0ffULL,
0x000000041c247824ULL, 0x000fe200078e00ffULL, 0x0000000569087211ULL, 0x000fe200078ff0ffULL,
0x000000041e267824ULL, 0x000fe200078e00ffULL, 0x0000003006067812ULL, 0x000fe200078ec0ffULL,
0x0000000420287824ULL, 0x000fe200078e00ffULL, 0xfffffffc160f7812ULL, 0x100fe200078ee207ULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0xfffffffc18137812ULL, 0x000fc400078ee207ULL,
0xfffffffc141b7812ULL, 0x100fe200078ee207ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffffc221d7812ULL, 0x100fe400078ee207ULL, 0xfffffffc241f7812ULL, 0x100fe200078ee207ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc26217812ULL, 0x100fe400078ee207ULL,
0xfffffffc28237812ULL, 0x000fe200078ee207ULL, 0x0000000120147824ULL, 0x000fe200078e0205ULL,
0x0000200000107811ULL, 0x000fc400078e68ffULL, 0x0000001207077212ULL, 0x000fe200078efcffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x0000004006257812ULL, 0x000fc600078efcffULL,
0x00000010072d7824ULL, 0x100fe200078e0210ULL, 0x000000250c197212ULL, 0x080fe200078efcffULL,
0x000000100f077824ULL, 0x100fe200078e0210ULL, 0x00000025080f7212ULL, 0x080fe200078efcffULL,
0x0000001013137824ULL, 0x100fe200078e0210ULL, 0x000000250a177212ULL, 0x000fe200078efcffULL,
0x000000011a0a7824ULL, 0x000fe200078e0205ULL, 0x0000000f4c087210ULL, 0x000fe20007f3e0ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x000000194c187210ULL, 0x040fe40007f7e0ffULL,
0x000000174c167210ULL, 0x000fe20007f5e0ffULL, 0x000000101b1b7824ULL, 0x000fc400078e0210ULL,
0x000000014d197824ULL, 0x000fe200018e060dULL, 0x000000250e0d7212ULL, 0x000fe200078efcffULL,
0x000000101d1d7824ULL, 0x100fe400078e0210ULL, 0x000000101f1f7824ULL, 0x100fe400078e0210ULL,
0x0000001021217824ULL, 0x100fe400078e0210ULL, 0x0000001023237824ULL, 0x000fe400078e0210ULL,
0x000000011c0c7824ULL, 0x000fc400078e0205ULL, 0x000000011e107824ULL, 0x000fe400078e0205ULL,
0x000000014d097824ULL, 0x040fe200008e0609ULL, 0x0000000d4c0e7210ULL, 0x000fe20007f3e0ffULL,
0x000000014d177824ULL, 0x040fe400010e060bULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000000f4d0f7210ULL, 0x000fe20000ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000082d7faeULL, 0x0003e4000b901c48ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x000000250a2b7212ULL, 0x080fe200078efcffULL, 0x0000000016077faeULL, 0x0003e4000b901c48ULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x000000250c297212ULL, 0x000fe200078efcffULL,
0x0000000018137faeULL, 0x0003e2000b901c48ULL, 0x0000002b4c0a7210ULL, 0x000fc40007f3e0ffULL,
0x0000002510277212ULL, 0x080fe200078efcffULL, 0x000000000e1b7faeULL, 0x0003e2000b901c48ULL,
0x0000002514257212ULL, 0x000fe200078efcffULL, 0x000000014d0b7824ULL, 0x040fe200008e060bULL,
0x000000294c0c7210ULL, 0x040fe40007f5e0ffULL, 0x000000274c107210ULL, 0x040fe40007f7e0ffULL,
0x000000254c147210ULL, 0x000fe20007f9e0ffULL, 0x000000014d0d7824ULL, 0x040fe200010e060dULL,
0x000000000a1d7faeULL, 0x0003e2000b901c48ULL, 0x000000014d117824ULL, 0x000fc400018e0611ULL,
0x000000014d157824ULL, 0x000fe200020e0615ULL, 0x000000000c1f7faeULL, 0x0003e8000b901c48ULL,
0x0000000010217faeULL, 0x0003e8000b901c48ULL, 0x0000000014237faeULL, 0x0003e4000b901c48ULL,
0x00000004ff077819ULL, 0x102fe20000011669ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000007695c7812ULL, 0x000fe200078ec0ffULL, 0x0000200000117824ULL, 0x000fe200078e00ffULL,
0x00000003ff137819ULL, 0x000fe20000011669ULL, 0x00000008070b7824ULL, 0x000fc600078e00ffULL,
0x00000001130a7812ULL, 0x000fe400078ec0ffULL, 0xfffffff80b0b7812ULL, 0x000fe400078ee25cULL,
0x000000085c5c7812ULL, 0x000fe400078ef869ULL, 0x000000100b0d7810ULL, 0x040fe20007ffe0ffULL,
0x000000040b157824ULL, 0x040fe200078e00ffULL, 0x000000200b0f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000107077824ULL, 0x000fe200078e025cULL, 0x000000300b1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000105c0c7824ULL, 0x000fe200078e00ffULL, 0x0000000a0f1c7211ULL, 0x080fe200078ff8ffULL,
0x000000040b217824ULL, 0x000fe200078e00ffULL, 0x0000000a1d1e7211ULL, 0x000fe200078ff8ffULL,
0x000000040d0e7824ULL, 0x000fe200078e00ffULL, 0xfffffff00c097812ULL, 0x000fe200078ee207ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000a0b0c7211ULL, 0x080fe200078ff8ffULL,
0x0000001009147824ULL, 0x000fe200078e00ffULL, 0x0000000a0d0b7211ULL, 0x000fe200078ff8ffULL,
0x000000040f097824ULL, 0x000fe200078e00ffULL, 0xfffffffc15107812ULL, 0x000fe200078ee20cULL,
0x000000041d157824ULL, 0x000fe200078e00ffULL, 0x0000100011087810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0xfffffffc0e0e7812ULL, 0x000fe200078ee20bULL,
0x000000040d227824ULL, 0x000fe200078e00ffULL, 0xfffffffc09097812ULL, 0x000fe200078ee21cULL,
0x00000010104e7824ULL, 0x000fe200078e0208ULL, 0xfffffffc150a7812ULL, 0x000fe200078ee21eULL,
0x000000100e4f7824ULL, 0x100fe200078e0208ULL, 0x000000001414783bULL, 0x000fe20000000200ULL,
0x00000010095f7824ULL, 0x100fe200078e0208ULL, 0x000000020c0c7810ULL, 0x000fe20007ffe0ffULL,
0x000000100a617824ULL, 0x000fe200078e0208ULL, 0x000000004e34783bULL, 0x000e620000000200ULL,
0x000000020b0d7810ULL, 0x000fe20007ffe0ffULL, 0x000000105c207824ULL, 0x000fe200078e00ffULL,
0xfffffffc210b7812ULL, 0x000fe200078ee20cULL, 0x000000004f3c783bULL, 0x000ea20000000200ULL,
0x000000021c0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000040f217824ULL, 0x000fe200078e00ffULL,
0x00000002071f7810ULL, 0x000fe20007ffe0ffULL, 0x000000005f44783bULL, 0x000ee20000000200ULL,
0x000000041d1c7824ULL, 0x000fe200078e00ffULL, 0x000000021e0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000100b637824ULL, 0x000fe200078e0208ULL, 0x000000006118783bULL, 0x000f220000000200ULL,
0xfffffff0201f7812ULL, 0x000fc400078ee21fULL, 0xfffffffc220d7812ULL, 0x000fe400078ee20dULL,
0xfffffffc210c7812ULL, 0x000fe200078ee20cULL, 0x000000101f1f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1c0f7812ULL, 0x000fe200078ee20fULL, 0x000000100d657824ULL, 0x100fe200078e0208ULL,
0x000000006320783bULL, 0x000fe20000000200ULL, 0x000000100c677824ULL, 0x100fe400078e0208ULL,
0x000000100f687824ULL, 0x000fe200078e0208ULL, 0x000000001f1c783bULL, 0x000f280000000200ULL,
0x000000006524783bULL, 0x000f280000000200ULL, 0x000000006728783bULL, 0x000f280000000200ULL,
0x00000000682c783bULL, 0x000f220000000200ULL, 0x000000341430723cULL, 0x042f7000000018ffULL,
0x0000003c1438723cULL, 0x044ff000000018ffULL, 0x000000441440723cULL, 0x048ff000000018ffULL,
0x000000361434723cULL, 0x040f7000000018ffULL, 0x0000003e143c723cULL, 0x040f7000000018ffULL,
0x000000461444723cULL, 0x040f7000000018ffULL, 0x000000181448723cULL, 0x050f7000000018ffULL,
0x0000001a1414723cULL, 0x000f7000000018ffULL, 0x000000201c30723cULL, 0x060b700000001830ULL,
0x000000221c34723cULL, 0x040b700000001834ULL, 0x000000241c38723cULL, 0x040b700000001838ULL,
0x000000261c3c723cULL, 0x040b70000000183cULL, 0x000000281c40723cULL, 0x040b700000001840ULL,
0x0000002a1c44723cULL, 0x040b700000001844ULL, 0x0000002c1c48723cULL, 0x040b700000001848ULL,
0x0000002e1c1c723cULL, 0x000b620000001814ULL, 0x0000059000008947ULL, 0x000fce0003800000ULL,
0x00000002ff2c7819ULL, 0x120fe20000011669ULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x0000008006227812ULL, 0x000fe200078efcffULL, 0x0000000113137824ULL, 0x000fe200078e0269ULL,
0x000000082c567810ULL, 0x040fe20007ffe0ffULL, 0x000000012c177824ULL, 0x040fe200078e0205ULL,
0x000000102c547810ULL, 0x000fc40007ffe0ffULL, 0x0000000362147217ULL, 0x000fe20007800000ULL,
0x00000001561b7824ULL, 0x100fe200078e0205ULL, 0x000000202c507810ULL, 0x000fe20007ffe0ffULL,
0x0000000154217824ULL, 0x000fe200078e0205ULL, 0x000000282c2e7810ULL, 0x040fe20007ffe0ffULL,
0x000001001b1a7825ULL, 0x000fe200078e0022ULL, 0x000000182c527810ULL, 0x000fe40007ffe0ffULL,
0x000000052e157210ULL, 0x000fe20007ffe0ffULL, 0x00000001142b7824ULL, 0x000fe200078e0a03ULL,
0x0000001a4c1a7210ULL, 0x000fe20007f7e0ffULL, 0x0000010021207825ULL, 0x000fe200078e0022ULL,
0x000000302c2a7810ULL, 0x000fc40007ffe0ffULL, 0x0000002b2c00720cULL, 0x080fe20003f26070ULL,
0x0000000150277824ULL, 0x000fe200078e0205ULL, 0x000000204c207210ULL, 0x000fe20007f9e0ffULL,
0x0000010015147825ULL, 0x100fe200078e0022ULL, 0x000000382c2c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000313137812ULL, 0x000fe200078ec0ffULL, 0x0000010027267825ULL, 0x000fe200078e0022ULL,
0x0000002b2a00720cULL, 0x080fe40003fa6070ULL, 0x0000002b2c00720cULL, 0x000fe20003fc6070ULL,
0x000000014d1b7824ULL, 0x000fe200018e061bULL, 0x000000264c267210ULL, 0x000fe20007f7e0ffULL,
0x0000000152257824ULL, 0x000fc400078e0205ULL, 0x000000012a197824ULL, 0x000fe400078e0205ULL,
0x000000014d217824ULL, 0x000fe200020e0621ULL, 0x000000144c287210ULL, 0x000fe20007f9e0ffULL,
0x000000012c297824ULL, 0x000fe200078e0205ULL, 0x0000001213147212ULL, 0x000fe200078efcffULL,
0x0000010017167825ULL, 0x000fc800078e0022ULL, 0x0000010025247825ULL, 0x000fe200078e0022ULL,
0x000000164c167210ULL, 0x000fc60007f5e0ffULL, 0x0000010019187825ULL, 0x000fc800078e0022ULL,
0x0000010029227825ULL, 0x000fc800078e0022ULL, 0x000000014d277824ULL, 0x040fe200018e0627ULL,
0x0000002b5600720cULL, 0x080fe20003f66070ULL, 0x000000014d297824ULL, 0x040fe200020e0615ULL,
0x0000002b5400720cULL, 0x080fe20003f86070ULL, 0x0000000456567824ULL, 0x000fe400078e00ffULL,
0x0000000454547824ULL, 0x000fe400078e00ffULL, 0x000000014d177824ULL, 0x000fe200010e0617ULL,
0xfffffffc56157812ULL, 0x100fe200078ee213ULL, 0x0000001014127824ULL, 0x100fe200078e0208ULL,
0xfffffffc542d7812ULL, 0x000fe200078ee213ULL, 0x000000042a2a7824ULL, 0x000fe200078e00ffULL,
0x000000244c247210ULL, 0x000fe20007f5e0ffULL, 0x0000001015157824ULL, 0x100fe200078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016127faeULL, 0x0003e2000c901c48ULL,
0x000000102d2d7824ULL, 0x100fe200078e0208ULL, 0x0000002b5200720cULL, 0x080fe20003f26070ULL,
0x000000014d257824ULL, 0x040fe200010e0625ULL, 0x000000184c187210ULL, 0x000fe20007f5e0ffULL,
0x000000001a157faeULL, 0x0005e2000d901c48ULL, 0x0000000452527824ULL, 0x000fe200078e00ffULL,
0x0000002b5000720cULL, 0x0c0fe20003f66070ULL, 0x0000000450507824ULL, 0x000fe200078e00ffULL,
0x00000000202d7faeULL, 0x0007e2000e101c48ULL, 0x0000002b2e00720cULL, 0x000fe20003f86070ULL,
0x000000014d197824ULL, 0x040fe200010e0619ULL, 0x000000224c167210ULL, 0x002fe20007f5e0ffULL,
0x000000042e2e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc522f7812ULL, 0x100fe200078ee213ULL,
0x000000042c2c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc50157812ULL, 0x004fe200078ee213ULL,
0x000000014d177824ULL, 0x000fe200010e0623ULL, 0xfffffffc2e1b7812ULL, 0x100fe200078ee213ULL,
0x000000102f2f7824ULL, 0x100fe200078e0208ULL, 0xfffffffc2a217812ULL, 0x108fe200078ee213ULL,
0x0000001015157824ULL, 0x100fe200078e0208ULL, 0xfffffffc2c237812ULL, 0x000fe200078ee213ULL,
0x000000101b1b7824ULL, 0x100fe200078e0208ULL, 0x00000000242f7faeULL, 0x0003e2000c901c48ULL,
0x0000001021217824ULL, 0x000fc400078e0208ULL, 0x0000001023237824ULL, 0x000fe200078e0208ULL,
0x0000000026157faeULL, 0x0003e8000d901c48ULL, 0x00000000281b7faeULL, 0x0003e8000e101c48ULL,
0x0000000018217faeULL, 0x0003e8000e901c48ULL, 0x0000000016237faeULL, 0x0003e2000f101c48ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x0000008006147812ULL, 0x020fe200078efcffULL,
0x000000ffff157224ULL, 0x000fe200078e00ffULL, 0x0000000569177211ULL, 0x000fe200078ff0ffULL,
0x0000000113137824ULL, 0x000fe200078e0269ULL, 0x0000001869527811ULL, 0x000fc400078ff0ffULL,
0x00000028692e7811ULL, 0x000fe200078ff0ffULL, 0x0000010017167825ULL, 0x000fe200078e0014ULL,
0x0000000869567811ULL, 0x040fe400078ff0ffULL, 0x0000001069547811ULL, 0x040fe200078ff0ffULL,
0x0000000152217824ULL, 0x100fe200078e0205ULL, 0x000000164c167210ULL, 0x000fe20007f3e0ffULL,
0x000000012e257824ULL, 0x000fe200078e0205ULL, 0x0000002069507811ULL, 0x000fe200078ff0ffULL,
0x0000010021207825ULL, 0x000fe200078e0014ULL, 0x00000030692a7811ULL, 0x000fc400078ff0ffULL,
0x00000038692c7811ULL, 0x000fe200078ff0ffULL, 0x0000010025247825ULL, 0x000fe200078e0014ULL,
0x000000174d177210ULL, 0x000fe40000ffe4ffULL, 0x000000204c207210ULL, 0x000fe20007f3e0ffULL,
0x0000000156197824ULL, 0x100fe200078e0205ULL, 0x0000000313137812ULL, 0x000fe200078ec0ffULL,
0x00000001541b7824ULL, 0x100fe400078e0205ULL, 0x0000000150237824ULL, 0x100fe400078e0205ULL,
0x000000012a277824ULL, 0x000fc400078e0205ULL, 0x000000012c297824ULL, 0x000fe400078e0205ULL,
0x000000014d217824ULL, 0x000fe200008e0621ULL, 0x000000244c247210ULL, 0x000fe20007f3e0ffULL,
0x0000010019187825ULL, 0x000fc800078e0014ULL, 0x000001001b1a7825ULL, 0x000fe200078e0014ULL,
0x000000184c187210ULL, 0x000fc60007f5e0ffULL, 0x0000010023227825ULL, 0x000fe200078e0014ULL,
0x0000001a4c1a7210ULL, 0x000fc60007f7e0ffULL, 0x0000010027267825ULL, 0x000fc800078e0014ULL,
0x0000010029147825ULL, 0x000fc800078e0014ULL, 0x000000014d257824ULL, 0x000fe200008e0625ULL,
0x000000144c287210ULL, 0x000fe20007f3e0ffULL, 0x0000000456567824ULL, 0x000fe200078e00ffULL,
0x0000001213147212ULL, 0x000fe200078efcffULL, 0x0000000454547824ULL, 0x000fe400078e00ffULL,
0x000000014d297824ULL, 0x040fe200008e0615ULL, 0xfffffffc56157812ULL, 0x100fe200078ee213ULL,
0x0000000452527824ULL, 0x000fe200078e00ffULL, 0xfffffffc542b7812ULL, 0x000fe200078ee213ULL,
0x000000014d197824ULL, 0x000fe200010e0619ULL, 0x000000224c227210ULL, 0x000fe20007f5e0ffULL,
0x0000001014127824ULL, 0x000fe200078e0208ULL, 0xfffffffc522d7812ULL, 0x000fe200078ee213ULL,
0x0000000450507824ULL, 0x000fc400078e00ffULL, 0x0000001015157824ULL, 0x000fe200078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016127faeULL, 0x0003e2000b901c48ULL,
0x000000042e2e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc502f7812ULL, 0x000fe200078ee213ULL,
0x000000042a2a7824ULL, 0x000fe200078e00ffULL, 0x0000000018157faeULL, 0x0005e2000b901c48ULL,
0x000000042c2c7824ULL, 0x000fe400078e00ffULL, 0x000000014d237824ULL, 0x040fe200010e0623ULL,
0x000000264c267210ULL, 0x000fe20007f5e0ffULL, 0x000000014d1b7824ULL, 0x000fc400018e061bULL,
0x000000102b2b7824ULL, 0x100fe200078e0208ULL, 0xfffffffc2e177812ULL, 0x102fe200078ee213ULL,
0x000000102d2d7824ULL, 0x100fe400078e0208ULL, 0x000000102f2f7824ULL, 0x100fe200078e0208ULL,
0xfffffffc2a157812ULL, 0x104fe200078ee213ULL, 0x0000001017177824ULL, 0x100fe200078e0208ULL,
0xfffffffc2c197812ULL, 0x000fe200078ee213ULL, 0x000000014d277824ULL, 0x000fe200010e0627ULL,
0x000000001a2b7faeULL, 0x0003e2000b901c48ULL, 0x0000001015157824ULL, 0x000fc400078e0208ULL,
0x0000001019197824ULL, 0x000fe200078e0208ULL, 0x00000000202d7faeULL, 0x0003e8000b901c48ULL,
0x00000000222f7faeULL, 0x0003e8000b901c48ULL, 0x0000000024177faeULL, 0x0003e8000b901c48ULL,
0x0000000026157faeULL, 0x0003e8000b901c48ULL, 0x0000000028197faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000105c167824ULL, 0x002fe200078e00ffULL,
0x0000000407157810ULL, 0x000fc40007ffe0ffULL, 0x0000200011117810ULL, 0x000fe40007ffe0ffULL,
0xfffffff016157812ULL, 0x000fc600078ee215ULL, 0x0000001010647824ULL, 0x100fe400078e0211ULL,
0x0000001015157824ULL, 0x000fe400078e00ffULL, 0x000000100e607824ULL, 0x100fe400078e0211ULL,
0x00000010095e7824ULL, 0x100fe200078e0211ULL, 0x0000000607097810ULL, 0x000fe20007ffe0ffULL,
0x000000100a5d7824ULL, 0x000fe400078e0211ULL, 0x000000105c0a7824ULL, 0x000fc400078e00ffULL,
0x000000100b107824ULL, 0x000fe200078e0211ULL, 0x000000110f0b7211ULL, 0x000fe200078e20ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006420783bULL, 0x000fe20000000200ULL,
0xfffffff00a097812ULL, 0x000fe200078ee209ULL, 0x000000100c0a7824ULL, 0x100fe400078e0211ULL,
0x000000001518783bULL, 0x000e640000000200ULL, 0x0000001009507824ULL, 0x000fe400078e00ffULL,
0x000000006024783bULL, 0x000ea20000000200ULL, 0x000000100d097824ULL, 0x000fc600078e0211ULL,
0x000000005e2c783bULL, 0x000ee80000000200ULL, 0x000000005d28783bULL, 0x000f280000000200ULL,
0x000000001054783bULL, 0x000fe80000000200ULL, 0x000000005050783bULL, 0x000ee80000000200ULL,
0x000000000958783bULL, 0x000ee80000000200ULL, 0x000000000a0c783bULL, 0x000ee20000000200ULL,
0x000000201830723cULL, 0x042f700000001830ULL, 0x000000221834723cULL, 0x040b640000001834ULL,
0x000000000b20783bULL, 0x020e6c0000000200ULL, 0x000000241838723cULL, 0x044f700000001838ULL,
0x00000026183c723cULL, 0x040f70000000183cULL, 0x0000002c1840723cULL, 0x048f700000001840ULL,
0x0000002e1844723cULL, 0x040f700000001844ULL, 0x000000281848723cULL, 0x050f700000001848ULL,
0x0000002a181c723cULL, 0x000f70000000181cULL, 0x000000545030723cULL, 0x040b700000001830ULL,
0x000000565034723cULL, 0x040b700000001834ULL, 0x000000585038723cULL, 0x060b700000001838ULL,
0x0000005a503c723cULL, 0x040b70000000183cULL, 0x0000000c5040723cULL, 0x040b700000001840ULL,
0x0000000e5044723cULL, 0x040b700000001844ULL, 0x000000205048723cULL, 0x042b700000001848ULL,
0x00000022501c723cULL, 0x000b62000000181cULL, 0x0000056000008947ULL, 0x000fce0003800000ULL,
0x00000002ff2c7819ULL, 0x000fe20000011669ULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0x000000c006187812ULL, 0x000fe200078efcffULL, 0x0000001014157824ULL, 0x000fe200078e0211ULL,
0x000000102c247810ULL, 0x040fe20007ffe0ffULL, 0x000000012c0f7824ULL, 0x060fe200078e0205ULL,
0x000000082c2e7810ULL, 0x000fc40007ffe0ffULL, 0x000000182c267810ULL, 0x040fe20007ffe0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0018ULL, 0x000000202c287810ULL, 0x040fe40007ffe0ffULL,
0x000000282c2a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000124177824ULL, 0x100fe200078e0205ULL,
0x0000000e4c1a7210ULL, 0x000fe20007f1e0ffULL, 0x000000012e0d7824ULL, 0x000fe200078e0205ULL,
0x00000003620e7217ULL, 0x000fe20007800000ULL, 0x0000010017167825ULL, 0x000fe200078e0018ULL,
0x000000302c147810ULL, 0x000fc60007ffe0ffULL, 0x000000010e277824ULL, 0x000fe400078e0a03ULL,
0x000000014d1b7824ULL, 0x000fe200000e060fULL, 0x000000164c167210ULL, 0x000fe20007f1e0ffULL,
0x000001000d0c7825ULL, 0x000fe200078e0018ULL, 0x000000272e00720cULL, 0x080fe40003f66070ULL,
0x000000272c00720cULL, 0x080fe20003f46070ULL, 0x00000001260f7824ULL, 0x000fe200078e0205ULL,
0x0000000c4c0c7210ULL, 0x000fe20007f3e0ffULL, 0x000000042e2e7824ULL, 0x000fe200078e00ffULL,
0x000000382c2c7810ULL, 0x000fe20007ffe0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0018ULL,
0x000000272400720cULL, 0x000fc40003fa6070ULL, 0xfffffffc2e2e7812ULL, 0x000fe200078ee213ULL,
0x0000000128237824ULL, 0x100fe200078e0205ULL, 0x000000272600720cULL, 0x080fe20003f86070ULL,
0x000000012a217824ULL, 0x000fe400078e0205ULL, 0x000000014d177824ULL, 0x000fe200000e0617ULL,
0x0000000e4c0e7210ULL, 0x000fe20007f1e0ffULL, 0x0000010023227825ULL, 0x000fe200078e0018ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a157faeULL, 0x0003e2000d101c48ULL,
0x000000272a00720cULL, 0x000fe40003f46070ULL, 0x000000014d0d7824ULL, 0x000fe200008e060dULL,
0x000000224c227210ULL, 0x000fe20007f3e0ffULL, 0x0000010021207825ULL, 0x000fc800078e0018ULL,
0x000000102e257824ULL, 0x000fe400078e0211ULL, 0x0000000114297824ULL, 0x000fe400078e0205ULL,
0x000000014d0f7824ULL, 0x000fe200000e060fULL, 0x000000204c207210ULL, 0x000fe20007f1e0ffULL,
0x000000000c257faeULL, 0x0005e2000d901c48ULL, 0x0000000424247824ULL, 0x000fe200078e00ffULL,
0x000000272800720cULL, 0x000fe20003f66070ULL, 0x000000012c057824ULL, 0x000fe400078e0205ULL,
0x00000004261a7824ULL, 0x002fc400078e00ffULL, 0x000000014d237824ULL, 0x000fe200008e0623ULL,
0x000000271400720cULL, 0x000fe20003f26070ULL, 0x0000000428287824ULL, 0x000fe200078e00ffULL,
0xfffffffc1a1a7812ULL, 0x000fe200078ee213ULL, 0x000000042a267824ULL, 0x000fe400078e00ffULL,
0x00000100290c7825ULL, 0x004fc600078e0018ULL, 0xfffffffc26267812ULL, 0x000fe200078ee213ULL,
0x000000014d217824ULL, 0x000fe200000e0621ULL, 0x0000000c4c0c7210ULL, 0x000fe20007fde0ffULL,
0x00000004142a7824ULL, 0x000fe200078e00ffULL, 0x000000272c00720cULL, 0x000fe20003f06070ULL,
0x0000010005187825ULL, 0x000fe200078e0018ULL, 0xfffffffc24147812ULL, 0x100fe400078ee213ULL,
0xfffffffc28247812ULL, 0x100fe200078ee213ULL, 0x000000042c2c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc2a287812ULL, 0x000fe200078ee213ULL, 0x000000014d0d7824ULL, 0x000fc400030e060dULL,
0x0000001014057824ULL, 0x000fe200078e0211ULL, 0xfffffffc2c2a7812ULL, 0x000fe200078ee213ULL,
0x000000101a1b7824ULL, 0x100fe200078e0211ULL, 0x000000184c147210ULL, 0x000fe20007fde0ffULL,
0x0000001024257824ULL, 0x100fe200078e0211ULL, 0x0000000016057faeULL, 0x0003e2000e901c48ULL,
0x0000001026277824ULL, 0x100fe400078e0211ULL, 0x0000001028297824ULL, 0x100fe200078e0211ULL,
0x000000000e1b7faeULL, 0x0003e2000e101c48ULL, 0x000000102a117824ULL, 0x000fc400078e0211ULL,
0x000000014d157824ULL, 0x000fe200030e0619ULL, 0x0000000022257faeULL, 0x0003e8000d901c48ULL,
0x0000000020277faeULL, 0x0003e8000d101c48ULL, 0x000000000c297faeULL, 0x0003e8000c901c48ULL,
0x0000000014117faeULL, 0x0003e2000c101c48ULL, 0x000004a000007947ULL, 0x000fea0003800000ULL,
0x0000000869267811ULL, 0x040fe200078ff0ffULL, 0x000000ffff0d7224ULL, 0x020fe200078e00ffULL,
0x0000001069287811ULL, 0x000fc400078ff0ffULL, 0x00000018692a7811ULL, 0x040fe200078ff0ffULL,
0x0000000126217824ULL, 0x100fe200078e0205ULL, 0x00000020692c7811ULL, 0x040fe400078ff0ffULL,
0x00000028692e7811ULL, 0x040fe200078ff0ffULL, 0x000000012a257824ULL, 0x100fe200078e0205ULL,
0x0000003069507811ULL, 0x040fe200078ff0ffULL, 0x000000012c0f7824ULL, 0x100fe200078e0205ULL,
0x0000003869527811ULL, 0x040fe200078ff0ffULL, 0x000000012e177824ULL, 0x100fe200078e0205ULL,
0x000000c0060c7812ULL, 0x000fe200078efcffULL, 0x0000000150197824ULL, 0x000fe200078e0205ULL,
0x00000005691b7211ULL, 0x000fc400078ff0ffULL, 0x0000000528237210ULL, 0x000fe20007ffe0ffULL,
0x0000000152057824ULL, 0x000fe400078e0205ULL, 0x000001001b1a7825ULL, 0x000fc800078e000cULL,
0x0000010021207825ULL, 0x000fc800078e000cULL, 0x0000010023227825ULL, 0x000fc800078e000cULL,
0x0000010025247825ULL, 0x000fc800078e000cULL, 0x000001000f0e7825ULL, 0x000fc800078e000cULL,
0x0000010017167825ULL, 0x000fc800078e000cULL, 0x0000010019187825ULL, 0x000fc800078e000cULL,
0x00000100050c7825ULL, 0x000fc800078e000cULL, 0x0000001014057824ULL, 0x000fe400078e0211ULL,
0x0000000426147824ULL, 0x000fe400078e00ffULL, 0x0000000428267824ULL, 0x000fe400078e00ffULL,
0x000000042a287824ULL, 0x000fe200078e00ffULL, 0xfffffffc14147812ULL, 0x100fe200078ee213ULL,
0x000000042c2a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc26267812ULL, 0x100fe200078ee213ULL,
0x000000042e2c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc28287812ULL, 0x000fe200078ee213ULL,
0x0000001014277824ULL, 0x000fe200078e0211ULL, 0x0000001a4c147210ULL, 0x000fe20007f1e0ffULL,
0x00000004502e7824ULL, 0x000fe200078e00ffULL, 0x000000204c1a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000452507824ULL, 0x000fe200078e00ffULL, 0x000000224c207210ULL, 0x040fe20007f5e0ffULL,
0x000000014d157824ULL, 0x040fe200000e061bULL, 0x000000244c227210ULL, 0x000fe20007f7e0ffULL,
0x000000014d1b7824ULL, 0x040fe200008e0621ULL, 0xfffffffc2a2a7812ULL, 0x000fe200078ee213ULL,
0x000000014d217824ULL, 0x040fe200010e0623ULL, 0x0000000e4c0e7210ULL, 0x000fe20007f1e0ffULL,
0x000000014d237824ULL, 0x040fe200018e0625ULL, 0xfffffffc2c2c7812ULL, 0x000fe200078ee213ULL,
0x0000001026297824ULL, 0x100fe200078e0211ULL, 0x000000164c167210ULL, 0x000fe20007f3e0ffULL,
0x00000010282b7824ULL, 0x000fe200078e0211ULL, 0xfffffffc2e2e7812ULL, 0x000fe200078ee213ULL,
0x000000102a2d7824ULL, 0x000fe200078e0211ULL, 0x000000184c187210ULL, 0x000fe20007f5e0ffULL,
0x000000014d0f7824ULL, 0x040fe200000e060fULL, 0xfffffffc50507812ULL, 0x000fe200078ee213ULL,
0x000000102c2f7824ULL, 0x000fe200078e0211ULL, 0x0000000c4c0c7210ULL, 0x000fe20007f7e0ffULL,
0x000000014d177824ULL, 0x000fe200008e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014057faeULL, 0x0003e2000b901c48ULL, 0x000000102e517824ULL, 0x000fc400078e0211ULL,
0x000000014d197824ULL, 0x040fe200010e0619ULL, 0x000000001a277faeULL, 0x0003e2000b901c48ULL,
0x0000001050117824ULL, 0x000fe400078e0211ULL, 0x000000014d0d7824ULL, 0x000fe200018e060dULL,
0x0000000020297faeULL, 0x0003e8000b901c48ULL, 0x00000000222b7faeULL, 0x0003e8000b901c48ULL,
0x000000000e2d7faeULL, 0x0003e8000b901c48ULL, 0x00000000162f7faeULL, 0x0003e8000b901c48ULL,
0x0000000018517faeULL, 0x0003e8000b901c48ULL, 0x000000000c117faeULL, 0x0003e4000b901c48ULL,
0x0000000204047810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff057424ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000006d0400720cULL, 0x000fda0003f06070ULL,
0x0000000276148824ULL, 0x000fe400078e0204ULL, 0x00000004ff158424ULL, 0x000fc800078e00ffULL,
0x0000640014148625ULL, 0x000fe200078e0015ULL, 0x00000008070c7810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000814058981ULL, 0x0002a2000c1e1900ULL,
0x000000105c0d7824ULL, 0x040fe200078e00ffULL, 0x0000000a07117810ULL, 0x000fe40007ffe0ffULL,
0x000000004f54783bULL, 0x000fe40000000200ULL, 0xfffffff00d0c7812ULL, 0x000fe400078ee20cULL,
0x000000005f50783bULL, 0x000fe20000000200ULL, 0x000000045c147819ULL, 0x002fe400000006ffULL,
0x000000100c2c7824ULL, 0x000fe200078e00ffULL, 0x000000006328783bULL, 0x000fe20000000200ULL,
0xfffffff014117812ULL, 0x000fc600078ee211ULL, 0x000000004e0c783bULL, 0x000fe40000000200ULL,
0x0000001011117824ULL, 0x000fe400078e00ffULL, 0x000000002c2c783bULL, 0x000e680000000200ULL,
0x00000000614c783bULL, 0x000ee80000000200ULL, 0x000000001114783bULL, 0x000f280000000200ULL,
0x000000006524783bULL, 0x000ee80000000200ULL, 0x000000006720783bULL, 0x000ee80000000200ULL,
0x000000006818783bULL, 0x000ee20000000200ULL, 0x0000000c2c30723cULL, 0x042f700000001830ULL,
0x0000000e2c34723cULL, 0x040f700000001834ULL, 0x000000542c38723cULL, 0x040f700000001838ULL,
0x000000562c3c723cULL, 0x040f70000000183cULL, 0x000000502c40723cULL, 0x040f700000001840ULL,
0x000000522c44723cULL, 0x040f700000001844ULL, 0x0000004c2c48723cULL, 0x048f700000001848ULL,
0x0000004e2c1c723cULL, 0x000b6e000000181cULL, 0x00000300022c7a10ULL, 0x020fe20007ffe0ffULL,
0x000000281430723cULL, 0x010f660000001830ULL, 0x000000012c0d7810ULL, 0x040fe20007ffe0ffULL,
0x000001002c117824ULL, 0x000fc600078e0274ULL, 0x000000660d00720cULL, 0x000fe20003f06070ULL,
0x0000002a1434723cULL, 0x000f620000001834ULL, 0x00000040110d7812ULL, 0x000fce00078ec0ffULL,
0x000000241438723cULL, 0x040f700000001838ULL, 0x00000026143c723cULL, 0x040f70000000183cULL,
0x000000201440723cULL, 0x040f700000001840ULL, 0x000000221444723cULL, 0x040b6e0000001844ULL,
0x000000016a227824ULL, 0x020fe200078e020dULL, 0x000000181448723cULL, 0x040b700000001848ULL,
0x0000001a141c723cULL, 0x000b62000000181cULL, 0x00000073050c7224ULL, 0x004fc800078e02ffULL,
0x000062000c0c7625ULL, 0x000fe200078e0075ULL, 0x000005b000008947ULL, 0x000fca0003800000ULL,
0x00000002ff247819ULL, 0x020fe40000011669ULL, 0x00000011620e7217ULL, 0x000fe40007800000ULL,
0x0000000824207810ULL, 0x040fe20007ffe0ffULL, 0x0000000124147824ULL, 0x140fe200078e0222ULL,
0x0000001024267810ULL, 0x000fe20007ffe0ffULL, 0x000000010e117824ULL, 0x000fe200078e0a11ULL,
0x0000002024287810ULL, 0x000fe20007ffe0ffULL, 0x0000000120167824ULL, 0x000fe200078e0222ULL,
0x0000001824277810ULL, 0x000fe20007ffe0ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000002824297810ULL, 0x000fc40007ffe0ffULL, 0x00000030242a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001260f7824ULL, 0x100fe200078e0222ULL, 0x00000006141b7212ULL, 0x080fe200078efcffULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x000000112600720cULL, 0x000fe40003fa6070ULL,
0x0000001b0c187210ULL, 0x000fe20007f1e0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e00ffULL,
0x0000000616197212ULL, 0x080fe400078efcffULL, 0x000000112700720cULL, 0x040fe20003f86070ULL,
0x0000000128167824ULL, 0x100fe200078e0222ULL, 0x000000060e1b7212ULL, 0x000fe200078efcffULL,
0x0000000127147824ULL, 0x000fe200078e0222ULL, 0x000000190c1a7210ULL, 0x040fe20007f3e0ffULL,
0x000000010d197824ULL, 0x000fe200000e0615ULL, 0x0000001b0c0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000010014147825ULL, 0x000fc800078e00ffULL, 0x000000010d1b7824ULL, 0x000fe200008e0617ULL,
0x000000112000720cULL, 0x000fe20003f26070ULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x0000000614237212ULL, 0x000fc600078efcffULL, 0x000000010d0f7824ULL, 0x000fe200000e060fULL,
0x0000000616217212ULL, 0x000fe200078efcffULL, 0x0000000420207824ULL, 0x000fe200078e00ffULL,
0x000000112400720cULL, 0x000fe20003f06070ULL, 0x0000000426267824ULL, 0x000fe200078e00ffULL,
0x000000210c167210ULL, 0x000fe20007f7e0ffULL, 0x00000004292e7824ULL, 0x040fe200078e00ffULL,
0xfffffffc20217812ULL, 0x000fe200078ee213ULL, 0x0000000129207824ULL, 0x000fe200078e0222ULL,
0x0000003824247810ULL, 0x000fe20007ffe0ffULL, 0x000000010d177824ULL, 0x000fe200018e0617ULL,
0x000000230c147210ULL, 0x000fe20007f5e0ffULL, 0x0000001021257824ULL, 0x000fe200078e0208ULL,
0x000000112800720cULL, 0x000fe20003f66070ULL, 0x0000010020207825ULL, 0x000fc400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018127faeULL, 0x0003e2000c101c48ULL,
0x000000112400720cULL, 0x080fe20003f06070ULL, 0x000000010d157824ULL, 0x000fe200010e0615ULL,
0x0000000620237212ULL, 0x000fe200078efcffULL, 0x000000001a257faeULL, 0x0005e2000c901c48ULL,
0x000000112900720cULL, 0x000fe20003f46070ULL, 0x0000000428287824ULL, 0x000fe200078e00ffULL,
0x000000230c207210ULL, 0x000fe40007fde0ffULL, 0x000000112a00720cULL, 0x000fe40003f26070ULL,
0xfffffffc26237812ULL, 0x100fe200078ee213ULL, 0x0000000124187824ULL, 0x102fe200078e0222ULL,
0xfffffffc2e297812ULL, 0x100fe200078ee213ULL, 0x0000000427127824ULL, 0x000fe200078e00ffULL,
0xfffffffc28277812ULL, 0x000fe200078ee213ULL, 0x000000012a1a7824ULL, 0x004fc400078e0222ULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0xfffffffc12257812ULL, 0x000fc600078ee213ULL,
0x000001001a1a7825ULL, 0x000fc800078e00ffULL, 0x000000010d217824ULL, 0x000fe200030e0621ULL,
0x000000061a117212ULL, 0x080fe200078efcffULL, 0x000000042a2a7824ULL, 0x000fe400078e00ffULL,
0x0000000424247824ULL, 0x000fe200078e00ffULL, 0x000000110c127210ULL, 0x000fe20007fde0ffULL,
0x0000001023237824ULL, 0x100fe200078e0208ULL, 0x0000000618117212ULL, 0x000fe200078efcffULL,
0x0000001025257824ULL, 0x100fe200078e0208ULL, 0xfffffffc2a2b7812ULL, 0x100fe200078ee213ULL,
0x0000001027277824ULL, 0x100fe200078e0208ULL, 0xfffffffc242d7812ULL, 0x000fe200078ee213ULL,
0x000000010d137824ULL, 0x000fe200030e061bULL, 0x000000110c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001029297824ULL, 0x100fe200078e0208ULL, 0x000000000e237faeULL, 0x0003e2000e901c48ULL,
0x000000102b2b7824ULL, 0x000fc400078e0208ULL, 0x000000102d2d7824ULL, 0x000fe200078e0208ULL,
0x0000000014257faeULL, 0x0003e2000e101c48ULL, 0x000000010d0d7824ULL, 0x000fc600030e0619ULL,
0x0000000016277faeULL, 0x0003e8000d901c48ULL, 0x0000000020297faeULL, 0x0003e8000d101c48ULL,
0x00000000122b7faeULL, 0x0003e8000c901c48ULL, 0x000000000c2d7faeULL, 0x0003e2000c101c48ULL,
0x000004f000007947ULL, 0x000fea0003800000ULL, 0x00000008690f7811ULL, 0x060fe400078ff0ffULL,
0x00000022690e7211ULL, 0x000fc400078ff0ffULL, 0x0000001069117811ULL, 0x000fe200078ff0ffULL,
0x000000040f267824ULL, 0x000fe200078e00ffULL, 0x0000002069177811ULL, 0x000fe400078ff0ffULL,
0x000000220f147210ULL, 0x000fe20007ffe0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001869157811ULL, 0x040fe400078ff0ffULL, 0x0000002869197811ULL, 0x000fe200078ff0ffULL,
0x0000000111167824ULL, 0x100fe200078e0222ULL, 0x00000030691b7811ULL, 0x000fe200078ff0ffULL,
0x0000000411287824ULL, 0x000fe200078e00ffULL, 0x0000003869217811ULL, 0x000fe200078ff0ffULL,
0x00000001171a7824ULL, 0x040fe200078e0222ULL, 0x000000060e117212ULL, 0x000fe200078efcffULL,
0x00000004172e7824ULL, 0x000fc400078e00ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x000000110c0e7210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc2e277812ULL, 0x100fe200078ee213ULL,
0x0000000115187824ULL, 0x140fe200078e0222ULL, 0x0000000616117212ULL, 0x000fe200078efcffULL,
0x00000004152a7824ULL, 0x000fe400078e00ffULL, 0x0000000119247824ULL, 0x140fe200078e0222ULL,
0x000000110c167210ULL, 0x000fe20007f5e0ffULL, 0x00000004194c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc2a257812ULL, 0x000fe200078ee213ULL, 0x000000011b237824ULL, 0x000fc400078e0222ULL,
0x000000041b4e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc261b7812ULL, 0x100fe200078ee213ULL,
0x0000000121207824ULL, 0x040fe200078e0222ULL, 0xfffffffc4c297812ULL, 0x100fe200078ee213ULL,
0x0000000421227824ULL, 0x000fe200078e00ffULL, 0xfffffffc28217812ULL, 0x100fe200078ee213ULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0xfffffffc4e517812ULL, 0x100fe400078ee213ULL,
0xfffffffc22537812ULL, 0x000fe200078ee213ULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000000618117212ULL, 0x000fc600078efcffULL, 0x000000101b2b7824ULL, 0x100fe200078e0208ULL,
0x0000000614137212ULL, 0x000fe200078efcffULL, 0x00000010252f7824ULL, 0x000fe400078e0208ULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x000000130c147210ULL, 0x000fc60007f3e0ffULL,
0x0000010024247825ULL, 0x000fc800078e00ffULL, 0x00000010212d7824ULL, 0x000fe400078e0208ULL,
0x000000010d0f7824ULL, 0x000fe200000e060fULL, 0x000000110c187210ULL, 0x000fe20007f1e0ffULL,
0x0000010023227825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e127faeULL, 0x0003e2000b901c48ULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x0000000622137212ULL, 0x000fc600078efcffULL, 0x00000010294f7824ULL, 0x100fe200078e0208ULL,
0x000000061a297212ULL, 0x080fe200078efcffULL, 0x00000010274d7824ULL, 0x100fe200078e0208ULL,
0x0000000624277212ULL, 0x080fe200078efcffULL, 0x000000010d197824ULL, 0x040fe200000e0619ULL,
0x0000000620117212ULL, 0x000fe200078efcffULL, 0x000000010d157824ULL, 0x040fe200008e0615ULL,
0x000000290c1a7210ULL, 0x040fe20007f1e0ffULL, 0x000000010d177824ULL, 0x000fe200010e0617ULL,
0x000000270c247210ULL, 0x040fe20007f3e0ffULL, 0x0000001051517824ULL, 0x000fe200078e0208ULL,
0x000000130c227210ULL, 0x040fe20007f5e0ffULL, 0x000000010d1b7824ULL, 0x040fe200000e061bULL,
0x000000110c0c7210ULL, 0x000fe20007f7e0ffULL, 0x000000010d257824ULL, 0x040fe200008e0625ULL,
0x00000000142b7faeULL, 0x0003e2000b901c48ULL, 0x000000010d237824ULL, 0x000fc400010e0623ULL,
0x0000001053537824ULL, 0x000fe200078e0208ULL, 0x00000000162d7faeULL, 0x0003e2000b901c48ULL,
0x000000010d0d7824ULL, 0x000fc600018e0621ULL, 0x00000000182f7faeULL, 0x0003e8000b901c48ULL,
0x000000001a4d7faeULL, 0x0003e8000b901c48ULL, 0x00000000244f7faeULL, 0x0003e8000b901c48ULL,
0x0000000022517faeULL, 0x0003e8000b901c48ULL, 0x000000000c537faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000105c0d7824ULL, 0x042fe200078e00ffULL,
0x0000000c07067810ULL, 0x040fe20007ffe0ffULL, 0x000000105c5c7824ULL, 0x000fe200078e00ffULL,
0x0000000e07077810ULL, 0x000fc40007ffe0ffULL, 0xfffffff00d067812ULL, 0x000fe400078ee206ULL,
0xfffffff05c077812ULL, 0x000fc600078ee207ULL, 0x0000001006067824ULL, 0x000fe400078e00ffULL,
0x0000001007077824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000000640c783bULL, 0x000fe80000000200ULL, 0x000000000614783bULL, 0x000e680000000200ULL,
0x000000005e20783bULL, 0x000fe80000000200ULL, 0x000000005d5c783bULL, 0x000ea80000000200ULL,
0x000000006018783bULL, 0x000ee80000000200ULL, 0x000000001024783bULL, 0x000fe80000000200ULL,
0x000000000928783bULL, 0x000fe80000000200ULL, 0x000000000710783bULL, 0x000f220000000200ULL,
0x0000000c1430723cULL, 0x042f700000001830ULL, 0x0000000e1434723cULL, 0x040be40000001834ULL,
0x000000000a0c783bULL, 0x020fe80000000200ULL, 0x000000000b08783bULL, 0x000e640000000200ULL,
0x0000005e141c723cULL, 0x044f70000000181cULL, 0x000000181438723cULL, 0x048f700000001838ULL,
0x0000001a143c723cULL, 0x040ff0000000183cULL, 0x000000201440723cULL, 0x040ff00000001840ULL,
0x000000221444723cULL, 0x040ff00000001844ULL, 0x0000005c1448723cULL, 0x000ff00000001848ULL,
0x000000241030723cULL, 0x050f700000001830ULL, 0x0000000a101c723cULL, 0x062f70000000181cULL,
0x000000261034723cULL, 0x040f700000001834ULL, 0x000000281038723cULL, 0x000f620000001838ULL,
0x3db504f331237820ULL, 0x000fe20000410000ULL, 0x3db504f3321a7820ULL, 0x000fcc0000410000ULL,
0x0000002a103c723cULL, 0x000b64000000183cULL, 0x3db504f31c217820ULL, 0x020fe20000410000ULL,
0x3db504f31d227820ULL, 0x000fe20000410000ULL, 0x3db504f31e1c7820ULL, 0x000fe20000410000ULL,
0x3db504f31f1d7820ULL, 0x000fc60000410000ULL, 0x0000000c1040723cULL, 0x000f620000001840ULL,
0x3db504f334247820ULL, 0x000fe20000410000ULL, 0x3db504f3352e7820ULL, 0x000fe20000410000ULL,
0x3db504f3372f7820ULL, 0x000fca0000410000ULL, 0x0000000e1044723cULL, 0x000f620000001844ULL,
0x3db504f3382a7820ULL, 0x000fe20000410000ULL, 0x3db504f339257820ULL, 0x000fe20000410000ULL,
0x3db504f33a3a7820ULL, 0x000fe20000410000ULL, 0x3db504f33b1b7820ULL, 0x000fc80000410000ULL,
0x000000081048723cULL, 0x000b620000001848ULL, 0x3db504f33c267820ULL, 0x000fe20000410000ULL,
0x3db504f33d327820ULL, 0x000fe20000410000ULL, 0x3db504f33e3e7820ULL, 0x000fe20000410000ULL,
0x3db504f33f317820ULL, 0x000fc60000410000ULL, 0x3db504f330117820ULL, 0x020fe20000410000ULL,
0x3db504f333127820ULL, 0x000fe20000410000ULL, 0x3db504f336137820ULL, 0x000fe20000410000ULL,
0x3db504f340307820ULL, 0x000fe20000410000ULL, 0x3db504f341277820ULL, 0x000fe20000410000ULL,
0x3db504f342207820ULL, 0x000fe20000410000ULL, 0x3db504f343107820ULL, 0x000fc60000410000ULL,
0x3db504f344287820ULL, 0x000fe20000410000ULL, 0x3db504f3452d7820ULL, 0x000fe20000410000ULL,
0x3db504f346187820ULL, 0x000fe20000410000ULL, 0x3db504f347197820ULL, 0x000fca0000410000ULL,
0x3db504f3482b7820ULL, 0x000fe20000410000ULL, 0x3db504f349297820ULL, 0x000fe20000410000ULL,
0x3db504f34a167820ULL, 0x000fe20000410000ULL, 0x3db504f34b177820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000071067f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1e7224ULL, 0x000fe400078e003aULL, 0x000000ffff1f7224ULL, 0x000fc400078e003eULL,
0x0000000000087805ULL, 0x000fca0000015200ULL, 0x00000400710b7984ULL, 0x000ee40000000800ULL,
0x800000000bff7812ULL, 0x00cfe40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ff000c7202ULL, 0x000fe20000000f00ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000000d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400710b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000469157824ULL, 0x000fe200078e00ffULL,
0x0000006f0200720cULL, 0x000fc80003f06070ULL, 0xfffffff015077812ULL, 0x000fca00078ec0ffULL,
0x0000008000147824ULL, 0x000fca00078e0207ULL, 0x0134000014087984ULL, 0x0004e20000000c00ULL,
0x0000135000008947ULL, 0x000fea0003800000ULL, 0x0000000269347824ULL, 0x000fe200078e00ffULL,
0x0000000362027217ULL, 0x000fe20007800000ULL, 0x00000002ff497424ULL, 0x000fc600078e00ffULL,
0x0000000634347812ULL, 0x000fe200078ec0ffULL, 0x0000000102337824ULL, 0x000fe200078e0a03ULL,
0x0000006e69027211ULL, 0x000fe400078ff0ffULL, 0x0000580034367a10ULL, 0x000fe20007ffe0ffULL,
0x000000016b067824ULL, 0x000fe200078e0234ULL, 0x00005a00ff037a19ULL, 0x000fe40000011602ULL,
0x000000333600720cULL, 0x080fe20003f06070ULL, 0x00000001060d7824ULL, 0x140fe200078e0a33ULL,
0x000000330600720cULL, 0x000fe20003f26070ULL, 0x0000000136077824ULL, 0x000fe200078e0a33ULL,
0x0000000370037217ULL, 0x000fc40003800000ULL, 0x0000000d700d7217ULL, 0x040fe40003800000ULL,
0x0000000770077217ULL, 0x000fe20003800000ULL, 0x000000036c507224ULL, 0x000fe200078e02ffULL,
0x00000004ff0d7819ULL, 0x000fe4000001160dULL, 0x0000000802027810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0d0d7207ULL, 0x000fe40000800000ULL, 0x000000ff07417207ULL, 0x000fc40000000000ULL,
0x00005a00ff037a19ULL, 0x000fe20000011602ULL, 0x0000000150067824ULL, 0x000fe200078e020dULL,
0x00000050410e7211ULL, 0x000fe400078fe0ffULL, 0x00000010343a7812ULL, 0x000fe200078efcffULL,
0x0000600006067625ULL, 0x000fe200078e0049ULL, 0x0000000370037217ULL, 0x000fe40003800000ULL,
0x000058003a387a10ULL, 0x000fe20007ffe0ffULL, 0x000060000e0e7625ULL, 0x000fe200078e0049ULL,
0x00000008064e7981ULL, 0x0048a6000c1e9500ULL, 0x000000036c527224ULL, 0x000fe200078e02ffULL,
0x000000080e477981ULL, 0x0002a2000c1e9500ULL, 0x00000020343c7812ULL, 0x000fc400078efcffULL,
0x000000010d027824ULL, 0x000fe400078e0252ULL, 0x0000000138077824ULL, 0x050fe200078e0a33ULL,
0x000000333800720cULL, 0x000fe20003f06070ULL, 0x000000016b0e7824ULL, 0x002fc600078e023aULL,
0x0000000770077217ULL, 0x000fe20003800000ULL, 0x0000600002027625ULL, 0x000fe200078e0049ULL,
0x000058003c407a10ULL, 0x000fc60007ffe0ffULL, 0x000000010e0f7824ULL, 0x100fe200078e0a33ULL,
0x000000ff07357207ULL, 0x000fe20000000000ULL, 0x00000001403b7824ULL, 0x000fe200078e0a33ULL,
0x00000052410c7211ULL, 0x000fe200078fe0ffULL, 0x00000008024c7981ULL, 0x000322000c1e9500ULL,
0x0000000f700f7217ULL, 0x000fe20003800000ULL, 0x000000016b447824ULL, 0x000fe200078e023cULL,
0x000000330e00720cULL, 0x000fe20003f26070ULL, 0x000060000c0c7625ULL, 0x000fe200078e0049ULL,
0x00000004ff0f7819ULL, 0x000fe4000001160fULL, 0x000000334000720cULL, 0x000fc40003f06070ULL,
0x0000005035027211ULL, 0x002fe400078fe0ffULL, 0x0000003b703b7217ULL, 0x000fe20003800000ULL,
0x00000001443d7824ULL, 0x000fe200078e0a33ULL, 0x000000ff0f0f7207ULL, 0x000fe20000800000ULL,
0x0000600002027625ULL, 0x000fe200078e0049ULL, 0x000000080c437981ULL, 0x000322000c1e9500ULL,
0x000000ff3b3b7207ULL, 0x000fe40000000000ULL, 0x000000334400720cULL, 0x000fe20003f26070ULL,
0x0000000802377981ULL, 0x000722000c1e9500ULL, 0x0000003034447812ULL, 0x000fe200078efcffULL,
0x0000000150067824ULL, 0x000fe200078e020fULL, 0x0000003d703d7217ULL, 0x000fe20003800000ULL,
0x000000010f0e7824ULL, 0x000fe200078e0252ULL, 0x00000052350c7211ULL, 0x002fe200078fe0ffULL,
0x000000016b547824ULL, 0x000fe200078e0244ULL, 0x000000503b027211ULL, 0x008fe200078fe0ffULL,
0x0000600006067625ULL, 0x000fe200078e0049ULL, 0x00000004ff3d7819ULL, 0x000fc6000001163dULL,
0x000060000c0c7625ULL, 0x080fe200078e0049ULL, 0x0000580044467a10ULL, 0x000fe20007ffe0ffULL,
0x00000008063e7981ULL, 0x0002e4000c1e9500ULL, 0x000060000e0e7625ULL, 0x080fe200078e0049ULL,
0x000000ff3d3f7207ULL, 0x000fe20000800000ULL, 0x000000080c397981ULL, 0x0002e4000c1e9500ULL,
0x0000600002027625ULL, 0x000fe400078e0049ULL, 0x000000080e427981ULL, 0x0002e4000c1e9500ULL,
0x0000000154457824ULL, 0x000fc400078e0a33ULL, 0x00000008023d7981ULL, 0x0002e4000c1e9500ULL,
0x0000000150067824ULL, 0x002fe200078e023fULL, 0x000000523b0c7211ULL, 0x000fe400078fe0ffULL,
0x0000004570457217ULL, 0x000fe20003800000ULL, 0x000000013f0e7824ULL, 0x000fe400078e0252ULL,
0x0000000146037824ULL, 0x040fe200078e0a33ULL, 0x000000334600720cULL, 0x000fe20003f06070ULL,
0x0000600006067625ULL, 0x000fe200078e0049ULL, 0x000000335400720cULL, 0x000fc40003f26070ULL,
0x0000000370037217ULL, 0x000fe20003800000ULL, 0x000060000c0c7625ULL, 0x080fe200078e0049ULL,
0x00000004ff027819ULL, 0x000fe20000011645ULL, 0x0000000806487981ULL, 0x0002e4000c1e9500ULL,
0x000060000e0e7625ULL, 0x000fe200078e0049ULL, 0x000000ff03457207ULL, 0x000fe20000000000ULL,
0x000000080c3f7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff024b7207ULL, 0x000fc60000800000ULL,
0x000000080e4a7981ULL, 0x0002e2000c1e9500ULL, 0x0000005045027211ULL, 0x000fe200078fe0ffULL,
0x0000000150067824ULL, 0x002fc800078e024bULL, 0x0000600002027625ULL, 0x000fc800078e0049ULL,
0x0000600006067625ULL, 0x000fe400078e0049ULL, 0x0000000802027981ULL, 0x0002e2000c1e9500ULL,
0x00000052450c7211ULL, 0x000fc600078fe0ffULL, 0x0000000806077981ULL, 0x0002e2000c1e9500ULL,
0x000000014b0e7824ULL, 0x000fe400078e0252ULL, 0x000060000c0c7625ULL, 0x000fc800078e0049ULL,
0x000060000e0e7625ULL, 0x000fe400078e0049ULL, 0x000000080c0c7981ULL, 0x0002e8000c1e9500ULL,
0x000000080e0f7981ULL, 0x0004e2000c1e9500ULL, 0xfffffff041507812ULL, 0x000fe200078ec0ffULL,
0x00000001ff417424ULL, 0x000fc800078e00ffULL, 0x0000000133037824ULL, 0x002fe200078e0250ULL,
0x0000000834507812ULL, 0x000fc600078efcffULL, 0x0000000136587824ULL, 0x100fe200078e0a03ULL,
0x0000000934547812ULL, 0x000fe400078efcffULL, 0x0000580050527a10ULL, 0x000fe40007ffe0ffULL,
0x0000005841587219ULL, 0x000fe400000006ffULL, 0x0000580054067a10ULL, 0x000fe20007ffe0ffULL,
0x00000001525a7824ULL, 0x000fc800078e0a03ULL, 0x00000001065c7824ULL, 0x000fe200078e0a03ULL,
0x0000005a415a7219ULL, 0x000fe400000006ffULL, 0xfffffff035357812ULL, 0x000fe400078ec0ffULL,
0x0000005c415c7219ULL, 0x000fe400000006ffULL, 0xfffffff045457812ULL, 0x000fe400078ec0ffULL,
0xfffffff03b4b7812ULL, 0x000fe200078ec0ffULL, 0x00000001333b7824ULL, 0x000fc400078e0235ULL,
0x0000000133537824ULL, 0x000fe400078e0245ULL, 0x0000000138457824ULL, 0x000fe200078e0a3bULL,
0x00000019347c7812ULL, 0x040fe400078efcffULL, 0x00000011340d7812ULL, 0x040fe400078efcffULL,
0x0000004541457219ULL, 0x000fe400000006ffULL, 0x0000002134607812ULL, 0x040fe400078efcffULL,
0x00000028345e7812ULL, 0x000fc400078efcffULL, 0x000058000d497a10ULL, 0x000fe40007ffe0ffULL,
0x0000004b334b7210ULL, 0x000fe40007ffe0ffULL, 0x0000580060787a10ULL, 0x000fe40007ffe0ffULL,
0x000058005e687a10ULL, 0x000fe20007ffe0ffULL, 0x00000001494d7824ULL, 0x000fe400078e0a3bULL,
0x0000000140557824ULL, 0x100fe400078e0a4bULL, 0x0000000178577824ULL, 0x000fc400078e0a4bULL,
0x0000000168597824ULL, 0x000fe400078e0a4bULL, 0x00000001465d7824ULL, 0x000fe200078e0a53ULL,
0x0000004d414d7219ULL, 0x040fe400000006ffULL, 0x0000005741577219ULL, 0x040fe400000006ffULL,
0x0000005941597219ULL, 0x040fe400000006ffULL, 0x0000005d415d7219ULL, 0x000fe400000006ffULL,
0x0000541047477816ULL, 0x004fc4000000004eULL, 0x00000001344e7812ULL, 0x000fc800078efcffULL,
0x000058004e567a10ULL, 0x000fe40007ffe0ffULL, 0x0000004758ff7212ULL, 0x000fc6000780c0ffULL,
0x00000001560e7824ULL, 0x000fe200078e0a03ULL, 0x000000333600720cULL, 0x080fe40000701470ULL,
0x0000001834037812ULL, 0x040fe400078efcffULL, 0x0000000e410e7219ULL, 0x000fe400000006ffULL,
0x000000333400720cULL, 0x000fe40000701070ULL, 0x000000470eff7212ULL, 0x080fe4000786c0ffULL,
0x000000475aff7212ULL, 0x000fc4000784c0ffULL, 0x000000475cff7212ULL, 0x000fe4000782c0ffULL,
0xff80000011117808ULL, 0x000fe40000000000ULL, 0x0000580003477a10ULL, 0x000fe40007ffe0ffULL,
0x0000541043437816ULL, 0x010fc8000000004cULL, 0x0000004358ff7212ULL, 0x080fe4000788c0ffULL,
0x000000435aff7212ULL, 0x080fe400078cc0ffULL, 0x000000435cff7212ULL, 0x000fe2000780c0ffULL,
0x00000001474f7824ULL, 0x000fe200078e0a3bULL, 0x000000333600720cULL, 0x080fe40002781470ULL,
0x000000335200720cULL, 0x080fe400037c1470ULL, 0x000000330600720cULL, 0x000fc40000701470ULL,
0x000000333400720cULL, 0x080fe40002781070ULL, 0x000000335000720cULL, 0x080fe400037c1070ULL,
0x000000335400720cULL, 0x000fe40000701070ULL, 0x0000004f414f7219ULL, 0x000fe400000006ffULL,
0x00005410373e7816ULL, 0x008fe4000000003eULL, 0x000000430eff7212ULL, 0x000fc400078ac0ffULL,
0x00000029345c7812ULL, 0x040fe400078efcffULL, 0x0000541039427816ULL, 0x000fe40000000042ULL,
0x0000003134587812ULL, 0x040fe400078efcffULL, 0x00000038344c7812ULL, 0x040fe400078efcffULL,
0x00000039340e7812ULL, 0x000fe400078efcffULL, 0x000058007c437a10ULL, 0x000fc40007ffe0ffULL,
0x000000330600720cULL, 0x000fe40000f21470ULL, 0xff8000001a1a7808ULL, 0x000fe40002000000ULL,
0xff80000013137808ULL, 0x000fe40003000000ULL, 0xff8000002f2f7808ULL, 0x000fe40000000000ULL,
0x0000003e45ff7212ULL, 0x040fe4000788c0ffULL, 0x0000004245ff7212ULL, 0x000fc400078cc0ffULL,
0x000000424fff7212ULL, 0x000fe4000780c0ffULL, 0x000058005c647a10ULL, 0x000fe20007ffe0ffULL,
0x0000000143517824ULL, 0x000fe200078e0a3bULL, 0x00005800585a7a10ULL, 0x000fe40007ffe0ffULL,
0x000058004c7a7a10ULL, 0x000fe40007ffe0ffULL, 0x000058000e357a10ULL, 0x000fe40007ffe0ffULL,
0x000000335400720cULL, 0x000fc40000f21070ULL, 0x000000335600720cULL, 0x0c0fe40001f61470ULL,
0x000000335600720cULL, 0x080fe40002fa1470ULL, 0x000000335200720cULL, 0x080fe40001741470ULL,
0x000000333800720cULL, 0x0c0fe40002781470ULL, 0x000000333800720cULL, 0x080fe400037c1470ULL,
0x000000334700720cULL, 0x080fe20000701470ULL, 0x00000001645b7824ULL, 0x000fe200078e0a4bULL,
0xff8000002e2e7808ULL, 0x000fe20000800000ULL, 0x000000015a5f7824ULL, 0x100fe200078e0a53ULL,
0x000000334e00720cULL, 0x080fe20001f61070ULL, 0x000000017a3b7824ULL, 0x100fe200078e0a53ULL,
0x000000334e00720cULL, 0x000fe20002fa1070ULL, 0x00000001354b7824ULL, 0x000fe200078e0a53ULL,
0x0000005141537219ULL, 0x000fc400000006ffULL, 0x000000335000720cULL, 0x080fe40001741070ULL,
0x000000333a00720cULL, 0x0c0fe40002721070ULL, 0x000000333a00720cULL, 0x080fe400037c1070ULL,
0x000000330300720cULL, 0x000fe40000701070ULL, 0x0000005541517219ULL, 0x000fe400000006ffULL,
0x000054103d487816ULL, 0x000fc40000000048ULL, 0x000054103f4a7816ULL, 0x000fe4000000004aULL,
0xff80000023237808ULL, 0x000fe40001800000ULL, 0xff80000012127808ULL, 0x000fe40002800000ULL,
0xff80000024247808ULL, 0x000fe40001000000ULL, 0xff8000002a2a7808ULL, 0x000fe40000800000ULL,
0xff8000001e1e7808ULL, 0x000fc40003000000ULL, 0xff8000001f1f7808ULL, 0x000fe40000000000ULL,
0x0000003e4dff7212ULL, 0x080fe4000786c0ffULL, 0x0000003e4fff7212ULL, 0x080fe400078ac0ffULL,
0x0000003e53ff7212ULL, 0x000fe4000784c0ffULL, 0x000000424dff7212ULL, 0x080fe4000788c0ffULL,
0x0000004253ff7212ULL, 0x000fc4000782c0ffULL, 0x0000004851ff7212ULL, 0x040fe400078cc0ffULL,
0x0000004a51ff7212ULL, 0x000fe4000780c0ffULL, 0x000000334900720cULL, 0x0c0fe40001f61470ULL,
0x000000334900720cULL, 0x080fe40002781470ULL, 0x000000334700720cULL, 0x080fe40002fa1470ULL,
0x000000334300720cULL, 0x000fc40001741470ULL, 0x000000334300720cULL, 0x080fe40000f21470ULL,
0x000000334000720cULL, 0x0c0fe400037c1470ULL, 0x000000334000720cULL, 0x080fe40000701470ULL,
0x000000330d00720cULL, 0x0c0fe40001f61070ULL, 0x000000330d00720cULL, 0x080fe40002781070ULL,
0x000000330300720cULL, 0x000fc40002fa1070ULL, 0x000000337c00720cULL, 0x0c0fe40001741070ULL,
0x000000337c00720cULL, 0x080fe40000f21070ULL, 0x000000333c00720cULL, 0x0c0fe400037c1070ULL,
0x000000333c00720cULL, 0x000fe40000701070ULL, 0x0000005b415b7219ULL, 0x000fe400000006ffULL,
0x0000541002027816ULL, 0x000fc40000000007ULL, 0xff80000025257808ULL, 0x000fe40001800000ULL,
0xff8000001b1b7808ULL, 0x000fe40002000000ULL, 0xff80000026267808ULL, 0x000fe40002800000ULL,
0xff80000032327808ULL, 0x000fe40001000000ULL, 0xff80000031317808ULL, 0x000fe40000800000ULL,
0xff80000030307808ULL, 0x000fc40003000000ULL, 0xff80000020207808ULL, 0x000fe40000000000ULL,
0x0000004857ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004859ff7212ULL, 0x080fe4000788c0ffULL,
0x000000485bff7212ULL, 0x000fe400078ac0ffULL, 0x0000004a57ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004a59ff7212ULL, 0x000fc4000782c0ffULL, 0x0000004a5bff7212ULL, 0x000fe400078cc0ffULL,
0x000000025dff7212ULL, 0x000fe4000780c0ffULL, 0x000000337800720cULL, 0x0c0fe40001f61470ULL,
0x000000337800720cULL, 0x080fe40001741470ULL, 0x000000336800720cULL, 0x0c0fe40002781470ULL,
0x000000336800720cULL, 0x000fc40000f21470ULL, 0x000000336400720cULL, 0x0c0fe40002fa1470ULL,
0x000000336400720cULL, 0x080fe400037c1470ULL, 0x000000334600720cULL, 0x080fe40000701470ULL,
0x000000336000720cULL, 0x0c0fe40001f61070ULL, 0x000000336000720cULL, 0x080fe40001741070ULL,
0x000000335e00720cULL, 0x000fc40002781070ULL, 0x000000335e00720cULL, 0x080fe40000f21070ULL,
0x000000335c00720cULL, 0x0c0fe40002fa1070ULL, 0x000000335c00720cULL, 0x080fe400037c1070ULL,
0x000000334400720cULL, 0x000fe40000701070ULL, 0x0000005f415f7219ULL, 0x040fe400000006ffULL,
0x0000003b413b7219ULL, 0x000fc400000006ffULL, 0x0000004b414b7219ULL, 0x000fe400000006ffULL,
0x000054100c0c7816ULL, 0x000fe4000000000fULL, 0xff80000027277808ULL, 0x000fe40001800000ULL,
0xff80000010107808ULL, 0x000fe40001000000ULL, 0xff80000028287808ULL, 0x000fe40002000000ULL,
0xff80000018187808ULL, 0x000fc40000800000ULL, 0xff8000002d2d7808ULL, 0x000fe40002800000ULL,
0xff80000019197808ULL, 0x000fe40003000000ULL, 0xff8000002b2b7808ULL, 0x000fe40000000000ULL,
0x000000025fff7212ULL, 0x080fe4000786c0ffULL, 0x000000023bff7212ULL, 0x080fe4000784c0ffULL,
0x000000024bff7212ULL, 0x000fc4000788c0ffULL, 0x0000000c5dff7212ULL, 0x080fe4000782c0ffULL,
0x0000000c5fff7212ULL, 0x080fe400078ac0ffULL, 0x0000000c3bff7212ULL, 0x080fe400078cc0ffULL,
0x0000000c4bff7212ULL, 0x000fe4000780c0ffULL, 0x000000334600720cULL, 0x080fe40000f21470ULL,
0x000000335a00720cULL, 0x000fc40001f61470ULL, 0x000000335a00720cULL, 0x080fe40002fa1470ULL,
0x000000337a00720cULL, 0x0c0fe40001741470ULL, 0x000000337a00720cULL, 0x080fe400037c1470ULL,
0x000000333500720cULL, 0x0c0fe40002781470ULL, 0x000000333500720cULL, 0x080fe40000701470ULL,
0x000000334400720cULL, 0x000fc40000f21070ULL, 0x000000335800720cULL, 0x0c0fe40001f61070ULL,
0x000000335800720cULL, 0x080fe40002fa1070ULL, 0x000000334c00720cULL, 0x0c0fe40001741070ULL,
0x000000334c00720cULL, 0x080fe400037c1070ULL, 0x000000330e00720cULL, 0x0c0fe40002781070ULL,
0x000000330e00720cULL, 0x000fc40000701070ULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff80000021217808ULL, 0x000fe40001000000ULL, 0xff80000022227808ULL, 0x000fe40002000000ULL,
0xff80000016167808ULL, 0x000fe40000800000ULL, 0xff80000017177808ULL, 0x000fe40002800000ULL,
0xff8000001c1c7808ULL, 0x000fc40003000000ULL, 0xff8000001d1d7808ULL, 0x000fc40000000000ULL,
0x000000110800720bULL, 0x008fe20003f1e000ULL, 0x0000001fff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001a0900720bULL, 0x000fe20003f3e000ULL, 0xffffffffff367424ULL, 0x000fe200078e00ffULL,
0x0000000811087208ULL, 0x000fe40004000000ULL, 0x000000091a097208ULL, 0x000fe40004800000ULL,
0x000000230800720bULL, 0x000fe40003f1e000ULL, 0x000000120900720bULL, 0x000fc40003f3e000ULL,
0x0000000823037208ULL, 0x000fe40004000000ULL, 0x0000000912027208ULL, 0x000fe40004800000ULL,
0x000000240300720bULL, 0x000fe40003f1e000ULL, 0x000000130200720bULL, 0x000fe40003f3e000ULL,
0x0000000324037208ULL, 0x000fe40004000000ULL, 0x0000000213027208ULL, 0x000fc40004800000ULL,
0x0000002e0300720bULL, 0x000fe40003f1e000ULL, 0x0000002f0200720bULL, 0x000fe40003f3e000ULL,
0x000000032e037208ULL, 0x000fe40004000000ULL, 0x000000022f077208ULL, 0x000fe40004800000ULL,
0x0000002a0300720bULL, 0x000fe40003f1e000ULL, 0x0000001e0700720bULL, 0x000fc40003f3e000ULL,
0x000000032a027208ULL, 0x000fe40004000000ULL, 0x000000071e067208ULL, 0x000fe40004800000ULL,
0x000000250200720bULL, 0x000fe40003f1e000ULL, 0x0000001b0600720bULL, 0x000fe40003f3e000ULL,
0x0000000225037208ULL, 0x000fe40004000000ULL, 0x000000061b067208ULL, 0x000fc40004800000ULL,
0x000000260300720bULL, 0x000fe40003f1e000ULL, 0x0000001f0600720bULL, 0x000fe40003f3e000ULL,
0x0000000326037208ULL, 0x000fe40004000000ULL, 0x000000061f067208ULL, 0x000fe40004800000ULL,
0x000000320300720bULL, 0x000fe40003f1e000ULL, 0x000000310600720bULL, 0x000fc40003f3e000ULL,
0x0000000332037208ULL, 0x000fe40004000000ULL, 0x0000000631077208ULL, 0x000fe40004800000ULL,
0x000000300300720bULL, 0x000fe40003f1e000ULL, 0x000000200700720bULL, 0x000fe40003f3e000ULL,
0x0000000330027208ULL, 0x000fe40004000000ULL, 0x0000000720077208ULL, 0x000fc40004800000ULL,
0x000000270200720bULL, 0x000fe40003f1e000ULL, 0x000000100700720bULL, 0x000fe40003f3e000ULL,
0x0000000227037208ULL, 0x000fe40004000000ULL, 0x0000000710077208ULL, 0x000fe40004800000ULL,
0x000000280300720bULL, 0x000fe40003f1e000ULL, 0x000000180700720bULL, 0x000fc40003f3e000ULL,
0x0000000328027208ULL, 0x000fe40004000000ULL, 0x0000000718067208ULL, 0x000fe40004800000ULL,
0x0000002d0200720bULL, 0x000fe40003f1e000ULL, 0x000000190600720bULL, 0x000fe40003f3e000ULL,
0x000000022d027208ULL, 0x000fe40004000000ULL, 0x0000000619037208ULL, 0x000fc40004800000ULL,
0x0000002b0200720bULL, 0x000fe40003f1e000ULL, 0x000000160300720bULL, 0x000fe40003f3e000ULL,
0x000000022b027208ULL, 0x000fe40004000000ULL, 0x0000000316067208ULL, 0x000fe40004800000ULL,
0x000000290200720bULL, 0x000fe40003f1e000ULL, 0x000000170600720bULL, 0x000fc40003f3e000ULL,
0x0000000229027208ULL, 0x000fe40004000000ULL, 0x0000000617037208ULL, 0x000fe40004800000ULL,
0x000000210200720bULL, 0x000fe40003f1e000ULL, 0x0000001c0300720bULL, 0x000fe40003f3e000ULL,
0x0000000221077208ULL, 0x000fe40004000000ULL, 0x000000031c027208ULL, 0x000fc40004800000ULL,
0x000000220700720bULL, 0x000fe40003f1e000ULL, 0x0000001d0200720bULL, 0x000fe40003f3e000ULL,
0x00000007220c7208ULL, 0x000fe40004000000ULL, 0x000000021d0e7208ULL, 0x000fe20004800000ULL,
0x000014227f007947ULL, 0x000fec000b800000ULL, 0x0c401f000c027f89ULL, 0x00066400000e0000ULL,
0x000000020c00720bULL, 0x002fc80003f1e000ULL, 0x0000000c02347208ULL, 0x000fe20004000000ULL,
0x000014327f007947ULL, 0x000fea000b800000ULL, 0x0c401f000e027f89ULL, 0x000e6800000e0000ULL,
0x0c401f000a037f89ULL, 0x000f2800000e0000ULL, 0x0c401f000b087f89ULL, 0x000ea800000e0000ULL,
0x0c201f0034097f89ULL, 0x000ee200000e0000ULL, 0x000000020e00720bULL, 0x002fc40003f1e000ULL,
0x000000030a00720bULL, 0x010fe40003f3e000ULL, 0x0000000e02067208ULL, 0x000fe40004000000ULL,
0x0000000a03077208ULL, 0x000fe40004800000ULL, 0x000000080b00720bULL, 0x004fe20003f1e000ULL,
0x0c201f00060d7f89ULL, 0x000e6600000e0000ULL, 0x0000000b08027208ULL, 0x000fe20004000000ULL,
0x0c201f00070c7f89ULL, 0x008ea200000e0000ULL, 0x000000093400720bULL, 0x000fc60003f1e000ULL,
0x0c201f0002037f89ULL, 0x0006e200000e0000ULL, 0x0000003409087208ULL, 0x000fe40004000000ULL,
0x0000000d0600720bULL, 0x002fe40003f3e000ULL, 0x0000000c0700720bULL, 0x004fe40003f5e000ULL,
0x000000060d097208ULL, 0x000fe40004800000ULL, 0x000000070c0a7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b08067820ULL, 0x008fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000369ff7812ULL, 0x000fc4000780c0ffULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010806ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b2a0b7823ULL, 0x100fe20000010806ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010806ULL, 0x0000002600357308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b250d7823ULL, 0x102fe20000010806ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010806ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b272a7823ULL, 0x100fe20000010806ULL,
0x3fb8aa3b28277823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010806ULL,
0x3fb8aa3b30257823ULL, 0x100fe20000010806ULL, 0x00000024000e7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b21267823ULL, 0x108fe20000010806ULL, 0x3fb8aa3b09217820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b2d287823ULL, 0x000fe20000010806ULL, 0x000000030200720bULL, 0x004fc40003f3e000ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010821ULL,
0x0000000b00337308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b29247823ULL, 0x102fe20000010806ULL,
0x3fb8aa3b22297823ULL, 0x100fe20000010806ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b182d7823ULL, 0x100fe20000010821ULL,
0x0000002e00077308ULL, 0x000e620000000800ULL, 0x3fb8aa3b2b0b7823ULL, 0x004fe20000010806ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010821ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010821ULL,
0x3fb8aa3b1d1d7823ULL, 0x000fc40000010821ULL, 0x0000000d00347308ULL, 0x000eb00000000800ULL,
0x00000013000f7308ULL, 0x000fe20000000800ULL, 0x0000000e070e723eULL, 0x002fe200000000ffULL,
0x3c003c00ff077424ULL, 0x000fcc00078e00ffULL, 0x0000002f00067308ULL, 0x0002e20000000800ULL,
0x000000333418723eULL, 0x004fce00000000ffULL, 0x00000011000c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b192f7823ULL, 0x002fce0000010821ULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x0000000f060f723eULL, 0x008fe200000000ffULL, 0x3c003c00ff067424ULL, 0x000fcc00078e00ffULL,
0x0000001a000d7308ULL, 0x000ff00000000800ULL, 0x0000001200127308ULL, 0x000ea20000000800ULL,
0x0000000c230c723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b10237823ULL, 0x000fcc0000010821ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x0000000d120d723eULL, 0x004fce00000000ffULL,
0x0000001b001b7308ULL, 0x000e620000000800ULL, 0x000000060c10723cULL, 0x000f6e00000018ffULL,
0x0000003200327308ULL, 0x000eb00000000800ULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x0000001e1b19723eULL, 0x002fc400000000ffULL, 0x00000002ff1e7819ULL, 0x000fc80000011669ULL,
0x000000031e347819ULL, 0x000fe200000006ffULL, 0x0000003100227308ULL, 0x000e620000000800ULL,
0x00000035321a723eULL, 0x004fe200000000ffULL, 0x000000081e387824ULL, 0x040fe400078e00ffULL,
0x000000081e327824ULL, 0x040fe400078e00ffULL, 0x000000081e3a7824ULL, 0x040fe400078e00ffULL,
0x00000020002b7308ULL, 0x000fe20000000800ULL, 0x000000081e3c7824ULL, 0x000fe200078e00ffULL,
0x0000001f221b723eULL, 0x002fcc00000000ffULL, 0x00000023002e7308ULL, 0x0002a20000000800ULL,
0x000000011e1f7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff832327812ULL, 0x000fc600078ee21fULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x000000061820723cULL, 0x022b6e0000001810ULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0x000000081e137824ULL, 0x060fe200078e00ffULL,
0x000000031e107810ULL, 0x000fc40007ffe0ffULL, 0x000000041e117810ULL, 0x000fe40007ffe0ffULL,
0xfffffff813367812ULL, 0x000fe400078ee210ULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0xfffffff838387812ULL, 0x000fe400078ee211ULL, 0x0000002b2e11723eULL, 0x004fe400000000ffULL,
0xffffffff1e2b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c152e7812ULL, 0x000fe200078ec0ffULL,
0x0000002800287308ULL, 0x000ea20000000800ULL, 0x000000252a10723eULL, 0x002fc400000000ffULL,
0x000000051e257810ULL, 0x000fe40007ffe0ffULL, 0xfffffff83c3c7812ULL, 0x000fc600078ee22bULL,
0x0000002d002d7308ULL, 0x000ff00000000800ULL, 0x0000002f00307308ULL, 0x0002e20000000800ULL,
0x000000272812723eULL, 0x004fe400000000ffULL, 0x000000061e277810ULL, 0x000fc80007ffe0ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee227ULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x000000021e2f7810ULL, 0x002fc80007ffe0ffULL, 0xfffffff834347812ULL, 0x000fe400078ee22fULL,
0x0000002d3013723eULL, 0x008fe200000000ffULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x000000081e2d7824ULL, 0x040fe400078e00ffULL, 0x000000081e307824ULL, 0x000fc600078e00ffULL,
0x000000061020723cULL, 0x000f620000001820ULL, 0xfffffff82d2a7812ULL, 0x000fe200078ee21eULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0xfffffff830307812ULL, 0x000fce00078ee225ULL,
0x0000002900297308ULL, 0x000e700000000800ULL, 0x0000001600167308ULL, 0x000ff00000000800ULL,
0x0000001700177308ULL, 0x000eb00000000800ULL, 0x0000001c001f7308ULL, 0x0007f00000000800ULL,
0x0000001d00287308ULL, 0x0005220000000800ULL, 0x000000081e1c7810ULL, 0x008fc40007ffe0ffULL,
0x00000026291e723eULL, 0x002fc600000000ffULL, 0x000000081c2d7824ULL, 0x000fe200078e00ffULL,
0x00000016171d723eULL, 0x004fc800000000ffULL, 0xfffffff82d3e7812ULL, 0x000fe400078ee21cULL,
0x0000000b241c723eULL, 0x000fe400000000ffULL, 0x00009000000b7811ULL, 0x000fe400078e58ffULL,
0x0000001f281f723eULL, 0x010fc600000000ffULL, 0x000000102a157824ULL, 0x100fe400078e020bULL,
0x0000001032167824ULL, 0x100fe400078e020bULL, 0x000000061c20723cULL, 0x020b620000001820ULL,
0x0000001034177824ULL, 0x100fe400078e020bULL, 0x0000001036247824ULL, 0x100fe400078e020bULL,
0x0000001038257824ULL, 0x000fe400078e020bULL, 0x000000012e157824ULL, 0x000fc400078e0215ULL,
0x0000001030267824ULL, 0x100fe400078e020bULL, 0x000000012e167824ULL, 0x000fe200078e0216ULL,
0x0000000c15007388ULL, 0x0003e20000000800ULL, 0x000000103a277824ULL, 0x000fe400078e020bULL,
0x000000012e177824ULL, 0x000fe200078e0217ULL, 0x0000000e16007388ULL, 0x0003e20000000800ULL,
0x000000103c287824ULL, 0x100fe400078e020bULL, 0x000000012e247824ULL, 0x000fe200078e0224ULL,
0x0000001817007388ULL, 0x0003e20000000800ULL, 0x000000103e0b7824ULL, 0x000fc400078e020bULL,
0x000000012e257824ULL, 0x040fe200078e0225ULL, 0x0000001a24007388ULL, 0x0003e20000000800ULL,
0x000000012e267824ULL, 0x040fe400078e0226ULL, 0x000000012e277824ULL, 0x040fe200078e0227ULL,
0x0000001025007388ULL, 0x0003e20000000800ULL, 0x000000012e287824ULL, 0x040fe400078e0228ULL,
0x000000012e067824ULL, 0x020fe200078e020bULL, 0x0000001226007388ULL, 0x0003e20000000800ULL,
0x00000002030b7208ULL, 0x000fe20004800000ULL, 0x000000ffff217224ULL, 0x000fc400078e0022ULL,
0x0000001c27007388ULL, 0x0003e80000000800ULL, 0x0000001e28007388ULL, 0x0003e80000000800ULL,
0x0000000d06007388ULL, 0x0003e80000000800ULL, 0x0004000f16007388ULL, 0x0003e80000000800ULL,
0x0004001917007388ULL, 0x0003e80000000800ULL, 0x0004001b24007388ULL, 0x0003e80000000800ULL,
0x0004001125007388ULL, 0x0003e80000000800ULL, 0x0004001326007388ULL, 0x0003e80000000800ULL,
0x0004001d27007388ULL, 0x0003e80000000800ULL, 0x0004001f28007388ULL, 0x0003e80000000800ULL,
0x0130000814008388ULL, 0x0003e80000000c00ULL, 0x0132002014008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136080072ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136100072ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136180072ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000662c00720cULL, 0x000fe20003f06070ULL,
0x0136200072ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff027224ULL, 0x000fd600078e002cULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff9d8000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff097807ULL, 0x002fe40004000000ULL,
0x000132e0000e7802ULL, 0x000fc40000000f00ULL, 0x00000bb000007944ULL, 0x018fea0003c00000ULL,
0xfffef81000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x000fe40004800000ULL,
0x00013320000e7802ULL, 0x000fc40000000f00ULL, 0x00000b7000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0009ULL, 0xfffef88000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x00013370000f7802ULL, 0x000fc40000000f00ULL,
0x00000ad000007944ULL, 0x018fea0003c00000ULL, 0xfffef96000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x000133b0000f7802ULL, 0x000fc40000000f00ULL,
0x00000a9000007944ULL, 0x01afea0003c00000ULL, 0xfffefa8000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0x00013400000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fc400078e000dULL, 0x00000a4000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0009ULL, 0xfffefc2000007947ULL, 0x000fea000383ffffULL,
0x0000000a000e7202ULL, 0x000fe40000000f00ULL, 0x00013450000f7802ULL, 0x000fc40000000f00ULL,
0x000009f000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xfffefc0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x008fe40004000000ULL,
0x000134a0000e7802ULL, 0x000fc40000000f00ULL, 0x000009f000007944ULL, 0x002fea0003c00000ULL,
0xffff12a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x000fe40004800000ULL,
0x000134e0000e7802ULL, 0x000fc40000000f00ULL, 0x000009b000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff327224ULL, 0x000fe200078e0009ULL, 0xffff12e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0034ULL, 0x00013530000f7802ULL, 0x000fc40000000f00ULL,
0x0000091000007944ULL, 0x000fea0003c00000ULL, 0xffff13d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0034ULL, 0x00013570000f7802ULL, 0x000fc40000000f00ULL,
0x000008d000007944ULL, 0x002fea0003c00000ULL, 0xffff14f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x000135c0000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fc400078e0031ULL, 0x0000088000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0009ULL, 0xffff16a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x00013610000f7802ULL, 0x000fc40000000f00ULL,
0x0000083000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xffff168000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x004fe40004000000ULL,
0x00013660000e7802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x018fea0003c00000ULL,
0xffff2ad000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x000fe40004800000ULL,
0x000136a0000e7802ULL, 0x000fc40000000f00ULL, 0x000007f000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff247224ULL, 0x000fe200078e0009ULL, 0xffff2b1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0026ULL, 0x000136f0000f7802ULL, 0x000fc40000000f00ULL,
0x0000075000007944ULL, 0x018fea0003c00000ULL, 0xffff2c0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0026ULL, 0x00013730000f7802ULL, 0x000fc40000000f00ULL,
0x0000071000007944ULL, 0x01afea0003c00000ULL, 0xffff2d2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x00013780000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fc400078e000dULL, 0x000006c000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0009ULL, 0xffff2ed000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x000137d0000f7802ULL, 0x000fc40000000f00ULL,
0x0000067000007944ULL, 0x016fea0003c00000ULL, 0x0000000900067202ULL, 0x004fe20000000f00ULL,
0xffff2eb000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x008fe40004000000ULL,
0x00013820000e7802ULL, 0x000fc40000000f00ULL, 0x0000067000007944ULL, 0x032fea0003c00000ULL,
0xffff431000007947ULL, 0x000fea000383ffffULL, 0x00000001ff097807ULL, 0x000fe40004800000ULL,
0x00013860000e7802ULL, 0x000fc40000000f00ULL, 0x0000063000007944ULL, 0x032fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0009ULL, 0xffff436000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e001eULL, 0x000138b0000f7802ULL, 0x000fc40000000f00ULL,
0x0000059000007944ULL, 0x030fea0003c00000ULL, 0xffff445000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e001eULL, 0x000138f0000f7802ULL, 0x000fc40000000f00ULL,
0x0000055000007944ULL, 0x032fea0003c00000ULL, 0xffff457000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0008ULL, 0x00013940000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fc400078e000dULL, 0x0000050000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0009ULL, 0xffff472000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0008ULL, 0x00013990000f7802ULL, 0x000fc40000000f00ULL,
0x000004b000007944ULL, 0x036fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0009ULL,
0xffff470000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0d7424ULL, 0x000fe200078e00ffULL,
0x000139e000067802ULL, 0x000fc40000000f00ULL, 0x0000042000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0003ULL, 0xffffeba000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0c7224ULL, 0x008fe200078e000eULL, 0x00013a4000067802ULL, 0x000fe20000000f00ULL,
0x00000002ff0d7424ULL, 0x000fc400078e00ffULL, 0x000003c000007944ULL, 0x004fea0003c00000ULL,
0x000000030e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x002fe200078e000aULL,
0x00013aa000067802ULL, 0x000fe20000000f00ULL, 0x00000002ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000e030e7208ULL, 0x000fc80004000000ULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0x000000030a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x002fe200078e000bULL,
0x00013b0000067802ULL, 0x000fe20000000f00ULL, 0x00000002ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000a030a7208ULL, 0x000fc80004000000ULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x000000030b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x002fe200078e0034ULL,
0x00013b6000067802ULL, 0x000fe20000000f00ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000b03027208ULL, 0x000fc80004000000ULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x000000033400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x002fe200078e000eULL,
0x00013bc000067802ULL, 0x000fe20000000f00ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003403087208ULL, 0x000fc80004000000ULL, 0x0000024000007944ULL, 0x000fea0003c00000ULL,
0x000000030e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x002fe200078e000aULL,
0x00013c2000067802ULL, 0x000fe20000000f00ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000e03097208ULL, 0x000fc80004000000ULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0x000000030a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0c7224ULL, 0x002fe200078e0002ULL,
0x00013c8000067802ULL, 0x000fe20000000f00ULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000a030a7208ULL, 0x000fc80004000000ULL, 0x0000018000007944ULL, 0x000fea0003c00000ULL,
0xffffea7000007947ULL, 0x000fea000383ffffULL, 0x0180000007037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003047812ULL, 0x000fc800078ec0ffULL,
0x018000000400780cULL, 0x000fda0003f05070ULL, 0x0000000700038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0400720cULL, 0x040fe40003f25070ULL,
0x008000000400780cULL, 0x000fe40003f02070ULL, 0x00000001ff047807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000304ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000304ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000007047812ULL, 0x000fd600078ec0ffULL, 0x0080000004030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0004ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffec20008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff077424ULL, 0x000fe200078e00ffULL, 0x0000003600007348ULL, 0x000fe80003800000ULL,
0x0c00000d0c037389ULL, 0x0002a200000e000fULL, 0xfffec1c006007950ULL, 0x000fea0003c3ffffULL,
0x0000007500007348ULL, 0x000fe80003800000ULL, 0x000000090e097389ULL, 0x0002a400000e0076ULL,
0x000000ffff0e7224ULL, 0x002fc400078e000fULL, 0x00000000ff0f7424ULL, 0x000fc800078e00ffULL,
0xfffec1700e007950ULL, 0x000fea0003c3ffffULL, 0x000000010900780cULL, 0x000fe20003f25070ULL,
0x00000000ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000007400007348ULL, 0x000ff60003800000ULL,
0x0000000000097806ULL, 0x000fc800048e0100ULL, 0x0000007409097212ULL, 0x000fe200078ec0ffULL,
0xfffec1100e007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000002ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000050aULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000668ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008c0ULL,
0x0000000000000288ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b48ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c08ULL,
0x00000000000005bcULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000011c8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000011d8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001268ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000126cULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001480ULL,
0x0000000000013f80ULL, 0x7f00001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015400ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015440ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x00000000000157c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001268ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000014198ULL,
0x0000000000014198ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000015400ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000157c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_0_m_16_sm_89_cubin_len = 88224;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
