/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001c6c0ULL, 0x000000000001c340ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL,
0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL,
0x616e7265746e695fULL, 0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL,
0x705f796c66625f63ULL, 0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL,
0x6c6668735f30376dULL, 0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL,
0x616475635f5f245fULL, 0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL,
0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL,
0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL,
0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000028ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b00220000036fULL, 0x000000000001aac0ULL, 0x0000000000000170ULL, 0x000b0022000003a2ULL,
0x000000000001ac30ULL, 0x0000000000000040ULL, 0x000b0022000003cdULL, 0x000000000001ac70ULL,
0x0000000000000050ULL, 0x000b0022000003f7ULL, 0x000000000001acc0ULL, 0x0000000000000140ULL,
0x000a000300000465ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000485ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004b5ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001ae00ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001aac000000000ULL, 0x0000040400000000ULL, 0x810c000001500400ULL,
0x0069540400288080ULL, 0x0000000000000000ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808692ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x0001aac000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080860828808081ULL, 0xa608288080a50828ULL, 0x288080d208288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080d2ULL, 0x0000001cffffffffULL,
0x000000e000000000ULL, 0x0001ac3000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080860828808081ULL, 0xa508288080a60828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x00288080a5920000ULL, 0x0000000000000022ULL, 0x0000002cffffffffULL,
0x0000016000000000ULL, 0x0001ac7000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x80a6288080a50900ULL, 0x0000000000002880ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080860828808081ULL,
0xa608288080a50828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a6920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000001f000000000ULL, 0x0001acc000000000ULL,
0x0000014000000000ULL, 0x0000000000000000ULL, 0x0000001700082f04ULL, 0x00082304000000e1ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008230400000000ULL, 0x0000000000000011ULL, 0x0000001100081204ULL, 0x0008110400000000ULL,
0x0000000000000011ULL, 0x0000001000082304ULL, 0x0008120400000000ULL, 0x0000000000000010ULL,
0x0000001000081104ULL, 0x0008230400000000ULL, 0x0000000000000017ULL, 0x0000001700081204ULL,
0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0060016000000014ULL, 0x000c170400601903ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL,
0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000ab000043104ULL, 0xffffffff01cc2904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000013001cc2804ULL, 0x000004c000000340ULL, 0x00002de000001cb0ULL,
0x00002f9000002e80ULL, 0x0000327000003100ULL, 0x000035e0000033d0ULL, 0x0000363000003620ULL,
0x00003fd000003660ULL, 0x00004fc000004f20ULL, 0x00005250000050e0ULL, 0x00005520000053c0ULL,
0x0000576000005720ULL, 0x000057a000005770ULL, 0x00006e4000005e30ULL, 0x00006ff000006ed0ULL,
0x000072d000007160ULL, 0x0000763000007430ULL, 0x0000768000007670ULL, 0x00007cc0000076b0ULL,
0x00008d5000008cc0ULL, 0x00008fe000008e70ULL, 0x000092b000009150ULL, 0x000094f0000094b0ULL,
0x0000953000009500ULL, 0x00009ca000009c90ULL, 0x00009cc000009cb0ULL, 0x0000caf00000ca50ULL,
0x0000cb300000cb00ULL, 0x0000d6e00000d6b0ULL, 0x0000d7500000d710ULL, 0x000182a000018260ULL,
0x000182c0000182b0ULL, 0x0001833000018310ULL, 0x0001836000018350ULL, 0x00019730000196d0ULL,
0x00019800000197a0ULL, 0x000198c000019860ULL, 0x000199a000019930ULL, 0x00019a8000019a10ULL,
0x00019b4000019ae0ULL, 0x00019c1000019bb0ULL, 0x00019cd000019c70ULL, 0x00019db000019d40ULL,
0x00019e9000019e20ULL, 0x00019f5000019ef0ULL, 0x0001a02000019fc0ULL, 0x0001a0e00001a080ULL,
0x0001a1c00001a150ULL, 0x0001a2a00001a230ULL, 0x0001a3600001a300ULL, 0x0001a4300001a3d0ULL,
0x0001a4f00001a490ULL, 0x0001a5d00001a560ULL, 0x0001a6b00001a640ULL, 0x0001a7a00001a720ULL,
0x0001a8a00001a820ULL, 0x0001a9a00001a920ULL, 0x0001aaa00001aa20ULL, 0x0000041002003904ULL,
0x0001e600000000ffULL, 0x00000450003f0100ULL, 0x0001e60800000007ULL, 0x00000490003f0120ULL,
0x0001e68800000007ULL, 0x00000ad0003f0120ULL, 0x0001e600000000ffULL, 0x00000cd0003f0107ULL,
0x0001e68c00000018ULL, 0x00000da0003f0102ULL, 0x0001e68800000018ULL, 0x00002af0003f0101ULL,
0x0001e60800000000ULL, 0x00002b10003f0101ULL, 0x0001e60c00000000ULL, 0x00002ce0003f0105ULL,
0x0001e60c00000000ULL, 0x00003f50003f0105ULL, 0x0001e68800000022ULL, 0x00004c60003f0101ULL,
0x0001e62800000021ULL, 0x00004c80003f0101ULL, 0x0001e62c00000021ULL, 0x00004e50003f0105ULL,
0x0001e62c00000021ULL, 0x00005de0003f0105ULL, 0x0000000000000024ULL, 0x00006b80003f0101ULL,
0x0001e64800000022ULL, 0x00006ba0003f0101ULL, 0x0001e64c00000022ULL, 0x00006d70003f0105ULL,
0x0001e64c00000022ULL, 0x00007ca0003f0105ULL, 0x0000000000000024ULL, 0x00008a10003f0101ULL,
0x0001e66800000062ULL, 0x00008a30003f0101ULL, 0x0001e66c00000062ULL, 0x00008c00003f0105ULL,
0x0001e66c00000062ULL, 0x00009af0003f0105ULL, 0x0000000000000000ULL, 0x0000f1e0003f0101ULL,
0x0001e600000000ffULL, 0x00010a10003f0101ULL, 0x0001e604000000ffULL, 0x00010be0003f0105ULL,
0x0001e604000000ffULL, 0x000155f0003f0105ULL, 0x000000000000009cULL, 0x00015880003f0101ULL,
0x000000040000009cULL, 0x00015a50003f0105ULL, 0x000000040000009cULL, 0x00019520003f0105ULL,
0x0001e6080000009eULL, 0x00019580003f0101ULL, 0x0001e6100000009eULL, 0x000195e0003f0101ULL,
0x0001e6180000009eULL, 0x00019650003f0101ULL, 0x0001e6200000009eULL, 0x00033803003f0101ULL,
0x0000e54000301c04ULL, 0x0000e7400000e570ULL, 0x0000ea000000e8a0ULL, 0x0000ecc00000eb60ULL,
0x0000efb00000ee20ULL, 0x00010c400000f0b0ULL, 0x0000040100019690ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x000000000000025cULL, 0x0000001700000002ULL, 0x00000000000001ccULL, 0x0000001700000002ULL,
0x000000000000014cULL, 0x0000001700000002ULL, 0x00000000000000ccULL, 0x0000001700000002ULL,
0x0000000000000044ULL, 0x0000001700000002ULL, 0x0000000000000232ULL, 0x0000001700000002ULL,
0x00000000000001a2ULL, 0x0000001700000002ULL, 0x0000000000000127ULL, 0x0000001700000002ULL,
0x00000000000000a8ULL, 0x0000001700000002ULL, 0x000000000001e700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0c7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000087919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000c857a19ULL, 0x000fe200000006ffULL,
0x00000000000579c3ULL, 0x000f220000002500ULL, 0x0000000000097919ULL, 0x000ea20000002100ULL,
0x0000460000087ab9ULL, 0x000fc60000000a00ULL, 0x0000000000a27919ULL, 0x000ee20000002700ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fe40007ffe0ffULL,
0x00000005001d7c02ULL, 0x010fc80008000f00ULL, 0x0000000200037305ULL, 0x000322000021f000ULL,
0x00000005ff1e7819ULL, 0x004fcc0000011609ULL, 0x00001fff1e1e7589ULL, 0x000fe200000e0000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000040003837a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a83ULL,
0x0000040003007624ULL, 0x000fca00078e020cULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x0000000183830810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x0000000183831810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff83aa12ULL, 0x000fc800078e33ffULL, 0x0000008300007306ULL, 0x000e620000209000ULL,
0x000000ff8300720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000383047224ULL, 0x004fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000000603157227ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000ee40000002200ULL,
0x000000ffff007224ULL, 0x000fc800078e0a15ULL, 0x0000000083007224ULL, 0x000fca00078e0206ULL,
0x000000830000720cULL, 0x000fda0003f06070ULL, 0x0000000100000824ULL, 0x000fe200078e0a83ULL,
0x0000000115150810ULL, 0x000fe20007ffe0ffULL, 0x0000010008027a24ULL, 0x008fc600078e0203ULL,
0x000000830000720cULL, 0x000fe20003f26070ULL, 0x0000000002077a24ULL, 0x000fe400078e0209ULL,
0x00001fff08097589ULL, 0x000e6600000e0000ULL, 0x000000ff0700720cULL, 0x040fe40003f65270ULL,
0x0000000f0700780cULL, 0x040fe40003f84070ULL, 0x000000030700780cULL, 0x000fc60003f04070ULL,
0x0000000115151810ULL, 0x000fe40007ffe0ffULL, 0x00000083ff15a212ULL, 0x000fe400078e33ffULL,
0x0000007f0700780cULL, 0x000fe40003f24070ULL, 0x3fffff800002b802ULL, 0x000fe20000000f00ULL,
0x000000ffff007224ULL, 0x000fe200078e0a15ULL, 0x00005a0015827a19ULL, 0x000fe200000006ffULL,
0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL, 0x0000000083837224ULL, 0x000fc400078e0206ULL,
0x3fffffc0ff04c424ULL, 0x000fe200078e00ffULL, 0x01e60002ff00b388ULL, 0x0005e20000000a00ULL,
0x7fffffc0ff05c424ULL, 0x000fe400078e00ffULL, 0x0000002083007824ULL, 0x000fe400078e00ffULL,
0xff317217ff069424ULL, 0x000fe200078e00ffULL, 0x01e608040700c388ULL, 0x0007e20000008a00ULL,
0x3fffff60ff028424ULL, 0x004fc600078e00ffULL, 0x01e4000607009388ULL, 0x000fe20000004800ULL,
0x7fffff60ff038424ULL, 0x000fca00078e00ffULL, 0x01e6880207008388ULL, 0x000fe20000008a00ULL,
0x0000000400047c10ULL, 0x048fe2000fffe1ffULL, 0x0000000409057824ULL, 0x002fe400078e021eULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000400007c0cULL, 0x000fe2000bf03070ULL,
0x0000000405057824ULL, 0x000fe200078e00ffULL, 0x0000002004047817ULL, 0x000fc80003800000ULL,
0x000000ff04817207ULL, 0x000fe20000000000ULL, 0x00005800a2047a24ULL, 0x000fc600078e02ffULL,
0x000000208100780cULL, 0x000fe20003f05270ULL, 0x0000008504047224ULL, 0x000fd800078e0282ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe20000000000ULL, 0x0000000581027217ULL, 0x000fe20007800000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe4000800063fULL,
0x0000000102027824ULL, 0x000fe200078e0a05ULL, 0x00000004ff037819ULL, 0x002fc8000001161cULL,
0x0000000203087810ULL, 0x000fe20007ffe0ffULL, 0x00000001050d7824ULL, 0x000fe200078e0203ULL,
0x000000020300720cULL, 0x080fe40003f06070ULL, 0x000000020800720cULL, 0x000fe20003f26070ULL,
0x00000001050f7824ULL, 0x000fe400078e0208ULL, 0x0000000100067824ULL, 0x040fe400078e020dULL,
0x00000001000a7824ULL, 0x000fe400078e020fULL, 0x000000101c057824ULL, 0x000fe200078e00ffULL,
0x0000000406077c12ULL, 0x000fe2000f8e30ffULL, 0x000000010f087824ULL, 0x040fe200078e021cULL,
0x000000040a0b7c12ULL, 0x000fe2000f8e30ffULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0x00005a00ff067a19ULL, 0x000fe20000011606ULL, 0x0000000104077824ULL, 0x040fe200078e0207ULL,
0x00005a00ff0a7a19ULL, 0x000fe2000001160aULL, 0x00000001040b7824ULL, 0x000fe200078e020bULL,
0x0000001c0d047210ULL, 0x000fe20007ffe0ffULL, 0x0000008506037224ULL, 0x080fe200078e0207ULL,
0xfffffff00f087812ULL, 0x000fe200078ee208ULL, 0x000000850a067224ULL, 0x000fe200078e020bULL,
0x000000f0050b7812ULL, 0x000fe200078ec0ffULL, 0x0000010003027825ULL, 0x000fc800078e00ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000000b02027212ULL, 0x000fc600078efcffULL,
0x000000100d0d7824ULL, 0x000fe200078e00ffULL, 0x0000000b06067212ULL, 0x000fe400078efcffULL,
0x00005e0002027a10ULL, 0x000fe40007f5e0ffULL, 0xfffffff00d047812ULL, 0x000fe200078ee204ULL,
0x00000010080d7824ULL, 0x000fe200078e00ffULL, 0x00005e0006067a10ULL, 0x000fe40007f7e0ffULL,
0x00005f0003037a10ULL, 0x000fe200017fe4ffULL, 0x00000010040b7824ULL, 0x000fe200078e00ffULL,
0x00005f0007077a10ULL, 0x000fc80001ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e8000c101c48ULL, 0x00000000060d7faeULL, 0x0003e2000c901c48ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x00000000001c7919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x000000051c0b7211ULL, 0x002fc800078fe0ffULL,
0x000000020b0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000100027824ULL, 0x000fc800078e020bULL,
0x0000000100057824ULL, 0x000fe200078e020dULL, 0x0000000402037c12ULL, 0x000fe2000f8e30ffULL,
0x000000010d087824ULL, 0x040fe200078e021cULL, 0x00005a00ff027a19ULL, 0x000fe20000011602ULL,
0x000000100d0d7824ULL, 0x000fe200078e00ffULL, 0x0000000405077c12ULL, 0x000fe2000f8e30ffULL,
0x0000000104037824ULL, 0x000fc600078e0203ULL, 0xfffffff00d087812ULL, 0x000fe200078ee208ULL,
0x0000000104077824ULL, 0x000fe200078e0207ULL, 0x00005a00ff047a19ULL, 0x000fe20000011605ULL,
0x0000008502027224ULL, 0x080fe200078e0203ULL, 0x000000041c057819ULL, 0x000fe200000006ffULL,
0x00000010080d7824ULL, 0x000fe400078e00ffULL, 0x0000008504077224ULL, 0x000fe200078e0207ULL,
0x000000f0050f7812ULL, 0x000fe200078ec0ffULL, 0x0000010002027825ULL, 0x000fc800078e00ffULL,
0x0000010007067825ULL, 0x000fe200078e00ffULL, 0x0000000f02027212ULL, 0x000fc600078efcffULL,
0x000000010b047824ULL, 0x040fe200078e021cULL, 0x0000000f06067212ULL, 0x000fe200078efcffULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x00005e0002027a10ULL, 0x000fe40007f1e0ffULL,
0x00005e0006067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff00b047812ULL, 0x000fe400078ee204ULL,
0x00005f0003037a10ULL, 0x000fe400007fe4ffULL, 0x00005f0007077a10ULL, 0x000fe20000ffe4ffULL,
0x00000010040b7824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e8000b901c48ULL, 0x00000000060d7faeULL, 0x0003e4000b901c48ULL,
0x0000000000037919ULL, 0x002e620000000000ULL, 0x0000000000047806ULL, 0x000fe200038e0000ULL,
0x00000004ff077424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400027300ULL, 0x000e7000000e0000ULL, 0x0000000400067309ULL, 0x000ea20000000000ULL,
0x000000030200720cULL, 0x002fe20003f02070ULL, 0x00006600a2027625ULL, 0x000fc800078e0007ULL,
0x000000ffff067224ULL, 0x004fd000078e0a06ULL, 0x01e60406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01e60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000008021b7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0900720cULL, 0x000fe40003f05270ULL,
0x0000007f1b1a7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff1b197810ULL, 0x000fc40007ffe0ffULL,
0x00000007ff1a7819ULL, 0x000fe4000001161aULL, 0x00000008ff197819ULL, 0x000fca0000011619ULL,
0x0000e4b000008947ULL, 0x000fea0003800000ULL, 0x00000003ff007819ULL, 0x000fe2000001161eULL,
0x000000081e187824ULL, 0x000fe400078e00ffULL, 0x00000003ff097424ULL, 0x000fe200078e00ffULL,
0x01ffffff00007812ULL, 0x000fe200078ec0ffULL, 0xffffffffff1f7424ULL, 0x000fc800078e00ffULL,
0x000000021d207824ULL, 0x000fca00078e0200ULL, 0x0000001a2000720cULL, 0x000fda0003f06070ULL,
0x00000001a2008819ULL, 0x000fe200000006ffULL, 0x00006800ff038624ULL, 0x000fc800078e00ffULL,
0x0000680000038624ULL, 0x000fc800078e0203ULL, 0x0000000120038824ULL, 0x000fe200078e0203ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e68c0918ff738cULL, 0x0005e20000000000ULL,
0x0000640003028625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000008021f8981ULL, 0x000ee2000c1e1900ULL, 0x000000011d047810ULL, 0x000fe20007ffe0ffULL,
0x0000008015157824ULL, 0x000fe200078e00ffULL, 0x00000001ff177819ULL, 0x000fe2000001161eULL,
0x00000100ff077424ULL, 0x000fe200078e00ffULL, 0x000000190400720cULL, 0x000fe20003f06070ULL,
0x01e6880018ff7f8cULL, 0x0003e2000c80043fULL, 0x000000011e147812ULL, 0x000fe200078ec0ffULL,
0x0000002017167824ULL, 0x000fc800078e00ffULL, 0x000001001d047824ULL, 0x000fca00078e0216ULL,
0x00000060152e7812ULL, 0x000fe200078ef804ULL, 0x000059001f007a24ULL, 0x008fca00078e02ffULL,
0x0000000700007819ULL, 0x000fca00000006ffULL, 0x0000620000027625ULL, 0x000fe200078e0007ULL,
0x0000064000008947ULL, 0x000fea0003800000ULL, 0x00000003ff137819ULL, 0x002fe4000001161cULL,
0x000000041b007217ULL, 0x000fe40007800000ULL, 0x0000000413097810ULL, 0x044fe40007ffe0ffULL,
0x0000000c13117810ULL, 0x040fe20007ffe0ffULL, 0x0000000100007824ULL, 0x000fe200078e0a04ULL,
0x00000008130b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000109047824ULL, 0x100fe200078e021cULL,
0x0000007005057812ULL, 0x000fe200078ec0ffULL, 0x0000000809237824ULL, 0x000fe200078e00ffULL,
0x0000002000007817ULL, 0x000fe20003800000ULL, 0x0000000111077824ULL, 0x000fe200078e021cULL,
0x00000014132b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000811087824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe200078ee204ULL, 0x000000010b067824ULL, 0x000fe200078e021cULL,
0x000000000900720cULL, 0x080fe20003f86070ULL, 0x000000080b257824ULL, 0x000fe200078e00ffULL,
0xfffffff808277812ULL, 0x000fe200078ee207ULL, 0x0000008014047824ULL, 0x000fe200078e0205ULL,
0x000000092e097210ULL, 0x040fe20007ffe0ffULL, 0x000000012e077824ULL, 0x000fe200078e0213ULL,
0xfffffff825257812ULL, 0x000fe200078ee206ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000001013217810ULL, 0x000fe20007ffe0ffULL, 0x000000012b0d7824ULL, 0x000fe200078e021cULL,
0x000000000b00720cULL, 0x080fe20003f66070ULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x000000001100720cULL, 0x000fc40003f46070ULL, 0x0000001417227211ULL, 0x000fe200078e08ffULL,
0x0000010009087825ULL, 0x000fe200078e0004ULL, 0x00000006020c7210ULL, 0x040fe40007f1e0ffULL,
0x000000001300720cULL, 0x000fe20003fa6070ULL, 0x000000082b107824ULL, 0x000fe200078e00ffULL,
0x00000008020e7210ULL, 0x000fe20007f3e0ffULL, 0x00000001210a7824ULL, 0x040fe200078e021cULL,
0x0001600022227811ULL, 0x000fe200078e68ffULL, 0x0000000821297824ULL, 0x000fe200078e00ffULL,
0xfffffff8102d7812ULL, 0x000fe200078ee20dULL, 0x00000001030d7824ULL, 0x000fe200000e0607ULL,
0x0000001c13317810ULL, 0x000fe20007ffe0ffULL, 0x000000012e077824ULL, 0x040fe200078e020bULL,
0xfffffff829297812ULL, 0x000fe200078ee20aULL, 0x00000001030f7824ULL, 0x000fe200008e0609ULL,
0x000000002100720cULL, 0x000fe20003f26070ULL, 0x000000012e097824ULL, 0x000fe200078e0211ULL,
0x0000002223237211ULL, 0x080fe200078e20ffULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x0000002225257211ULL, 0x000fc600078e20ffULL, 0x00000001130a7824ULL, 0x000fe200078e021cULL,
0x0000000602107210ULL, 0x000fe20007f1e0ffULL, 0x0000010009087825ULL, 0x000fc800078e0004ULL,
0x000000012e0b7824ULL, 0x000fe200078e0221ULL, 0x000000070a217812ULL, 0x000fe200078ec0ffULL,
0x0000000103117824ULL, 0x000fe200000e0607ULL, 0x0000000802087210ULL, 0x000fe20007fde0ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0004ULL, 0x000000002b00720cULL, 0x000fe40003f06070ULL,
0x0ffffff821217812ULL, 0x000fe200078ef81cULL, 0x000000012e077824ULL, 0x000fe200078e022bULL,
0x00000018132b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000103097824ULL, 0x000fe200030e0609ULL,
0x0000000a020a7210ULL, 0x000fe20007fde0ffULL, 0x0000010007067825ULL, 0x000fc800078e0004ULL,
0x00000001030b7824ULL, 0x000fe200030e060bULL, 0x0000000602127210ULL, 0x000fe20007fde0ffULL,
0x000000012e2f7824ULL, 0x000fe400078e022bULL, 0x0000001021217824ULL, 0x000fe400078e0222ULL,
0x0000000103137824ULL, 0x000fe400030e0607ULL, 0x000001002f067825ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c217faeULL, 0x0003e2000e901c48ULL,
0x000000002b00720cULL, 0x000fc40003fa6070ULL, 0x000000012e337824ULL, 0x000fe200078e0231ULL,
0x000000000e237faeULL, 0x0005e2000e101c48ULL, 0x000000003100720cULL, 0x000fe20003f86070ULL,
0x000000012b007824ULL, 0x000fe200078e021cULL, 0x0000000602067210ULL, 0x000fe20007fde0ffULL,
0x0000010033047825ULL, 0x000fe200078e0004ULL, 0x0000000010257faeULL, 0x0007e6000d901c48ULL,
0x000000082b0d7824ULL, 0x002fe400078e00ffULL, 0x00000001310c7824ULL, 0x000fc400078e021cULL,
0x00000008310f7824ULL, 0x004fe200078e00ffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee200ULL,
0x0000000103077824ULL, 0x000fe200030e0607ULL, 0x0000000402027210ULL, 0x000fe20007fde0ffULL,
0x0000001027277824ULL, 0x000fe200078e0222ULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee20cULL,
0x0000001029297824ULL, 0x100fe400078e0222ULL, 0x000000102d2d7824ULL, 0x100fe200078e0222ULL,
0x0000000008277faeULL, 0x0007e2000d101c48ULL, 0x000000100d0d7824ULL, 0x000fc400078e0222ULL,
0x000000100f0f7824ULL, 0x000fe200078e0222ULL, 0x000000000a297faeULL, 0x0007e2000c901c48ULL,
0x0000000103037824ULL, 0x000fc600030e0605ULL, 0x00000000122d7faeULL, 0x0007e8000c101c48ULL,
0x00000000060d7faeULL, 0x0007e8000e901c48ULL, 0x00000000020f7faeULL, 0x0007e2000e101c48ULL,
0x0000057000007947ULL, 0x000fea0003800000ULL, 0x000000041c097811ULL, 0x046fe400078fe8ffULL,
0x000000081c0b7811ULL, 0x000fc400078fe8ffULL, 0x000000181c137811ULL, 0x040fe200078fe8ffULL,
0x0000000109007824ULL, 0x000fe200078e021cULL, 0x0000001c0b047210ULL, 0x080fe20007ffe0ffULL,
0x0000000809077824ULL, 0x000fe200078e00ffULL, 0x0000000c1c0d7811ULL, 0x000fe200078fe8ffULL,
0x000000080b0f7824ULL, 0x000fe200078e00ffULL, 0x00000003132c7819ULL, 0x000fe200000006ffULL,
0x000000012e097824ULL, 0x000fe200078e0209ULL, 0xfffffff807227812ULL, 0x000fe200078ee200ULL,
0x0000000113077824ULL, 0x000fe200078e021cULL, 0xfffffff80f247812ULL, 0x000fe200078ee204ULL,
0x000000010d007824ULL, 0x140fe200078e021cULL, 0x000000101c0f7811ULL, 0x040fe200078fe8ffULL,
0x000000080d217824ULL, 0x000fe200078e00ffULL, 0x000000141c117811ULL, 0x000fe200078fe8ffULL,
0x000000012e0b7824ULL, 0x000fe200078e020bULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee207ULL,
0x000000010f047824ULL, 0x000fe200078e021cULL, 0x0000007005077812ULL, 0x000fe200078ec0ffULL,
0x000000080f237824ULL, 0x000fe200078e00ffULL, 0xfffffff821267812ULL, 0x000fe200078ee200ULL,
0x0000000111067824ULL, 0x040fe200078e021cULL, 0x0000001c1c007211ULL, 0x040fe200078fe8ffULL,
0x0000000811257824ULL, 0x000fe200078e00ffULL, 0x0000001c1c057811ULL, 0x000fe200078fe8ffULL,
0x0000008014127824ULL, 0x000fe200078e0207ULL, 0xfffffff823287812ULL, 0x000fe200078ee204ULL,
0x0000000217047824ULL, 0x000fe200078e0214ULL, 0xfffffff8252a7812ULL, 0x000fe200078ee206ULL,
0x000000012e237824ULL, 0x000fe200078e0205ULL, 0x0000000700077812ULL, 0x000fe200078ec0ffULL,
0x0000000105007824ULL, 0x040fe200078e021cULL, 0x0000000305257819ULL, 0x000fe200000006ffULL,
0x000000012e217824ULL, 0x000fe200078e0213ULL, 0x0000002e1c057211ULL, 0x000fe200078fe8ffULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0x00016000042f7811ULL, 0x000fe200078e68ffULL,
0x000000012e0d7824ULL, 0x000fc400078e020dULL, 0x000000012e0f7824ULL, 0x000fe200078e020fULL,
0x0000002f2a2b7211ULL, 0x000fe200078e20ffULL, 0x000000012e117824ULL, 0x000fe200078e0211ULL,
0xfffffff8252e7812ULL, 0x000fe200078ee200ULL, 0x0000010005047825ULL, 0x000fe200078e0012ULL,
0x0ffffff807007812ULL, 0x000fc600078ef81cULL, 0x0000010009067825ULL, 0x000fe200078e0012ULL,
0x0000000402047210ULL, 0x000fc60007f1e0ffULL, 0x000001000b087825ULL, 0x000fe200078e0012ULL,
0x0000000602067210ULL, 0x000fc60007f3e0ffULL, 0x000001000d0a7825ULL, 0x000fe200078e0012ULL,
0x0000000802087210ULL, 0x000fc60007f5e0ffULL, 0x000001000f0c7825ULL, 0x000fe200078e0012ULL,
0x0000000a020a7210ULL, 0x000fc60007f7e0ffULL, 0x00000100110e7825ULL, 0x000fc800078e0012ULL,
0x0000010021107825ULL, 0x000fc800078e0012ULL, 0x0000010023127825ULL, 0x000fc800078e0012ULL,
0x0000000103057824ULL, 0x040fe200000e0605ULL, 0x0000000c020c7210ULL, 0x040fe20007f1e0ffULL,
0x0000000103077824ULL, 0x040fe200008e0607ULL, 0x0000000e020e7210ULL, 0x000fe20007f3e0ffULL,
0x0000001000217824ULL, 0x000fe400078e022fULL, 0x0000000103097824ULL, 0x040fe200010e0609ULL,
0x0000001002107210ULL, 0x000fe20007f5e0ffULL, 0x0000001022237824ULL, 0x000fe200078e022fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004217faeULL, 0x0003e2000b901c48ULL,
0x00000001030b7824ULL, 0x040fe200018e060bULL, 0x0000001202027210ULL, 0x000fe20007f7e0ffULL,
0x0000001024257824ULL, 0x100fe200078e022fULL, 0x0000001103117210ULL, 0x000fe200017fe4ffULL,
0x0000001026277824ULL, 0x100fe200078e022fULL, 0x0000000006237faeULL, 0x0003e2000b901c48ULL,
0x0000001028297824ULL, 0x000fc400078e022fULL, 0x00000001030d7824ULL, 0x040fe200000e060dULL,
0x0000000008257faeULL, 0x0003e2000b901c48ULL, 0x00000001030f7824ULL, 0x040fe400008e060fULL,
0x000000102c2d7824ULL, 0x100fe200078e022fULL, 0x000000000a277faeULL, 0x0003e2000b901c48ULL,
0x000000102e2f7824ULL, 0x000fe400078e022fULL, 0x0000000103037824ULL, 0x000fe200018e0613ULL,
0x000000000c297faeULL, 0x0003e8000b901c48ULL, 0x000000000e2b7faeULL, 0x0003e8000b901c48ULL,
0x00000000102d7faeULL, 0x0003e8000b901c48ULL, 0x00000000022f7faeULL, 0x0003e4000b901c48ULL,
0x000000191d00720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff217424ULL, 0x002fe200078e00ffULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x008fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x00007ef000000947ULL, 0x000fea0003800000ULL, 0x00000002a2137824ULL, 0x000fe400078e00ffULL,
0x00006800ff007624ULL, 0x000fc400078e00ffULL, 0xff317217ff217424ULL, 0x000fe400078e00ffULL,
0x000000ffff637224ULL, 0x000fe400078e00ffULL, 0x0000680013137624ULL, 0x000fc400078e0200ULL,
0x000000101e007824ULL, 0x000fe200078e00ffULL, 0x000000011d027810ULL, 0x000fe20007ffe0ffULL,
0x000059001f1f7a24ULL, 0x010fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe000007812ULL, 0x000fe200078ec0ffULL, 0x00000100ff037424ULL, 0x000fe200078e00ffULL,
0x000000190200720cULL, 0x000fe20003f06070ULL, 0x000000801f027824ULL, 0x000fe200078e00ffULL,
0x000000001d007211ULL, 0x000fc600078e40ffULL, 0x0000620002027625ULL, 0x000fe200078e0003ULL,
0x0000004000057810ULL, 0x020fc80007ffe0ffULL, 0x0000006005007812ULL, 0x000fca00078ec0ffULL,
0x00000001156f7824ULL, 0x000fe200078e0200ULL, 0x0000068000008947ULL, 0x000fea0003800000ULL,
0x000000051b007217ULL, 0x000fe20007800000ULL, 0x000000101c067824ULL, 0x000fe200078e00ffULL,
0x00000003ff6b7819ULL, 0x000fe2000001161cULL, 0x000000801e047824ULL, 0x000fe400078e00ffULL,
0x0000000100007824ULL, 0x000fe200078e0a05ULL, 0x000000046b097810ULL, 0x040fe20007ffe0ffULL,
0x000020001e057824ULL, 0x000fe200078e00ffULL, 0x0000007006077812ULL, 0x000fe400078ec0ffULL,
0x000000086b0b7810ULL, 0x000fc40007ffe0ffULL, 0x0000200005067812ULL, 0x000fe200078ec0ffULL,
0x0000000109057824ULL, 0x040fe200078e021cULL, 0x00000003090c7819ULL, 0x000fe200000006ffULL,
0x000000080b127824ULL, 0x000fe200078e00ffULL, 0x0000000c6b1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000400017177824ULL, 0x000fe200078e0206ULL, 0x0000008007047812ULL, 0x000fe200078ef804ULL,
0x000000010b077824ULL, 0x100fe200078e021cULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee205ULL,
0x000000011f057824ULL, 0x100fe200078e021cULL, 0x000000106b6d7810ULL, 0x000fe20007ffe0ffULL,
0x000000081f227824ULL, 0x000fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee207ULL,
0x000000016b077824ULL, 0x040fe200078e026fULL, 0x000000146b717810ULL, 0x000fe20007ffe0ffULL,
0x000000016d067824ULL, 0x140fe200078e021cULL, 0xfffffff822227812ULL, 0x000fe200078ee205ULL,
0x000000086d257824ULL, 0x000fe200078e00ffULL, 0x0000002000007817ULL, 0x000fe20003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x0000000371277819ULL, 0x040fe200000006ffULL,
0x0000000171087824ULL, 0x000fe200078e021cULL, 0xfffffff8256c7812ULL, 0x000fe200078ee206ULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x000000000900720cULL, 0x000fc40003f66070ULL,
0xfffffff8276e7812ULL, 0x000fe200078ee208ULL, 0x0000000109097824ULL, 0x100fe200078e026fULL,
0x0000000602247210ULL, 0x000fe20007f5e0ffULL, 0x000000016b087824ULL, 0x000fe200078e021cULL,
0x000000000b00720cULL, 0x0c0fe20003f06070ULL, 0x000000010b0b7824ULL, 0x000fe200078e026fULL,
0x000000001f00720cULL, 0x080fe20003f26070ULL, 0x0000000103257824ULL, 0x000fe200010e0607ULL,
0x0000000708277812ULL, 0x000fe200078ec0ffULL, 0x0000010009067825ULL, 0x000fe200078e0004ULL,
0x000000006b00720cULL, 0x000fc40003f86070ULL, 0x0001700017177810ULL, 0x000fe20007ffe0ffULL,
0x000001000b087825ULL, 0x000fe200078e0004ULL, 0x0000000602267210ULL, 0x040fe40007f5e0ffULL,
0x0ffffff827067812ULL, 0x000fe200078ef81cULL, 0x000000011f1f7824ULL, 0x000fe200078e026fULL,
0x0000000802687210ULL, 0x000fe20007fbe0ffULL, 0x0000000103277824ULL, 0x000fe200010e0607ULL,
0x000000186b737810ULL, 0x000fe20007ffe0ffULL, 0x000001001f0a7825ULL, 0x000fe200078e0004ULL,
0x0000000903697210ULL, 0x000fc40002ffe4ffULL, 0x0000001c6b757810ULL, 0x000fe20007ffe0ffULL,
0x000000016d077824ULL, 0x040fe200078e026fULL, 0x0000000a020a7210ULL, 0x000fe20007fde0ffULL,
0x0000001006097824ULL, 0x000fe200078e0217ULL, 0x000000006d00720cULL, 0x080fe20003f46070ULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x000000007100720cULL, 0x0c0fe40003fa6070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000024097faeULL, 0x0003e2000e101c48ULL,
0x00000001716b7824ULL, 0x000fe200078e026fULL, 0x000000007300720cULL, 0x000fe20003f86070ULL,
0x00000001030b7824ULL, 0x000fe200030e060bULL, 0x00000006026a7210ULL, 0x000fe20007fde0ffULL,
0x000000100c1f7824ULL, 0x000fc400078e0217ULL, 0x00000001736d7824ULL, 0x000fe400078e026fULL,
0x00000001750c7824ULL, 0x040fe200078e021cULL, 0x00000000261f7faeULL, 0x0005e2000d901c48ULL,
0x000000007500720cULL, 0x000fe20003f66070ULL, 0x000001006b087825ULL, 0x002fe200078e0004ULL,
0x0000001c73007210ULL, 0x000fc60007ffe0ffULL, 0x00000001036b7824ULL, 0x000fe200030e0607ULL,
0x0000000802087210ULL, 0x000fe20007fde0ffULL, 0x000001006d067825ULL, 0x000fe200078e0004ULL,
0x000000176e6d7211ULL, 0x000fc600078e20ffULL, 0x00000001751f7824ULL, 0x004fe400078e026fULL,
0x0000000103097824ULL, 0x000fe200030e0609ULL, 0x0000000602067210ULL, 0x040fe20007fde0ffULL,
0x0000000873737824ULL, 0x000fe400078e00ffULL, 0x0000000875757824ULL, 0x000fe400078e00ffULL,
0x000001001f047825ULL, 0x000fe200078e0004ULL, 0xfffffff873007812ULL, 0x000fe400078ee200ULL,
0xfffffff8750c7812ULL, 0x000fe200078ee20cULL, 0x0000000103077824ULL, 0x000fe200030e0607ULL,
0x0000000402027210ULL, 0x000fe20007fde0ffULL, 0x00000010121f7824ULL, 0x000fc400078e0217ULL,
0x0000001022257824ULL, 0x100fe400078e0217ULL, 0x000000106c277824ULL, 0x100fe200078e0217ULL,
0x00000000681f7faeULL, 0x0003e2000c101c48ULL, 0x00000010006f7824ULL, 0x100fe400078e0217ULL,
0x000000100c177824ULL, 0x000fe200078e0217ULL, 0x000000000a257faeULL, 0x0003e2000c901c48ULL,
0x0000000103037824ULL, 0x000fc600030e0605ULL, 0x000000006a277faeULL, 0x0003e8000d101c48ULL,
0x00000000086d7faeULL, 0x0003e8000e901c48ULL, 0x00000000066f7faeULL, 0x0003e8000e101c48ULL,
0x0000000002177faeULL, 0x0003e2000d901c48ULL, 0x000005b000007947ULL, 0x000fea0003800000ULL,
0x000000101c007824ULL, 0x040fe200078e00ffULL, 0x000000041c077811ULL, 0x000fe200078fe8ffULL,
0x000000801e6b7824ULL, 0x000fe200078e00ffULL, 0x000000101c257811ULL, 0x000fe200078fe8ffULL,
0x000020001e047824ULL, 0x000fe200078e00ffULL, 0x0000007000007812ULL, 0x000fc400078ec0ffULL,
0x00000003076d7819ULL, 0x000fe200000006ffULL, 0x0000000825757824ULL, 0x000fe200078e00ffULL,
0x00000080006a7812ULL, 0x000fe200078ef86bULL, 0x0000000107007824ULL, 0x040fe200078e021cULL,
0x000000081c097811ULL, 0x000fe200078fe8ffULL, 0x000000ffff6b7224ULL, 0x000fe200078e00ffULL,
0x0000200004047812ULL, 0x000fe200078ec0ffULL, 0x0000000107077824ULL, 0x000fe200078e026fULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee200ULL, 0x0000000125007824ULL, 0x100fe200078e021cULL,
0x000000141c277811ULL, 0x040fe200078fe8ffULL, 0x0000000109057824ULL, 0x040fe200078e021cULL,
0x0000000c1c0b7811ULL, 0x040fe200078fe8ffULL, 0x0000000809087824ULL, 0x000fe200078e00ffULL,
0xfffffff875757812ULL, 0x000fe200078ee200ULL, 0x0000400017047824ULL, 0x000fe200078e0204ULL,
0x0000001c1c007211ULL, 0x080fe200078fe8ffULL, 0x000000010b067824ULL, 0x100fe200078e021cULL,
0xfffffff808717812ULL, 0x000fe200078ee205ULL, 0x0000000127057824ULL, 0x140fe200078e021cULL,
0x0000001c1c177811ULL, 0x040fe200078fe8ffULL, 0x0000000827087824ULL, 0x000fe200078e00ffULL,
0x000000181c697811ULL, 0x000fe200078fe8ffULL, 0x000000080b737824ULL, 0x000fe200078e00ffULL,
0x00000007001f7812ULL, 0x000fe200078ec0ffULL, 0x0000000117007824ULL, 0x040fe200078e021cULL,
0xfffffff808777812ULL, 0x000fe200078ee205ULL, 0x00000008177b7824ULL, 0x000fe200078e00ffULL,
0xfffffff873737812ULL, 0x000fe200078ee206ULL, 0x0000000869797824ULL, 0x000fe200078e00ffULL,
0x0000006f1c057211ULL, 0x000fe200078fe8ffULL, 0x0000000109097824ULL, 0x100fe200078e026fULL,
0x0000001c69067210ULL, 0x000fe20007ffe0ffULL, 0x000000010b0b7824ULL, 0x100fe200078e026fULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee200ULL, 0x0000000125257824ULL, 0x000fe200078e026fULL,
0x0001700004007810ULL, 0x000fe20007ffe0ffULL, 0x0000010005047825ULL, 0x000fe200078e006aULL,
0xfffffff879797812ULL, 0x000fc400078ee206ULL, 0x0000006f69697210ULL, 0x000fe20007ffe0ffULL,
0x0000010007067825ULL, 0x000fe200078e006aULL, 0x0000000402047210ULL, 0x040fe40007f1e0ffULL,
0x0ffffff81f1f7812ULL, 0x000fe200078ef81cULL, 0x0000010009087825ULL, 0x000fe200078e006aULL,
0x0000000602067210ULL, 0x000fc60007f3e0ffULL, 0x0000000127277824ULL, 0x000fe200078e026fULL,
0x0000000802087210ULL, 0x000fe20007f5e0ffULL, 0x000001000b0a7825ULL, 0x000fc800078e006aULL,
0x0000000117177824ULL, 0x000fe200078e026fULL, 0x0000000a020a7210ULL, 0x000fe20007f7e0ffULL,
0x0000010025247825ULL, 0x000fc800078e006aULL, 0x0000010027267825ULL, 0x000fc800078e006aULL,
0x0000010069687825ULL, 0x000fc800078e006aULL, 0x00000100176a7825ULL, 0x000fc800078e006aULL,
0x0000000103057824ULL, 0x040fe200000e0605ULL, 0x0000002402247210ULL, 0x040fe20007f1e0ffULL,
0x0000000103077824ULL, 0x000fe200008e0607ULL, 0x0000002602267210ULL, 0x040fe20007f3e0ffULL,
0x000000101f177824ULL, 0x100fe400078e0200ULL, 0x0000000103097824ULL, 0x000fe200010e0609ULL,
0x0000006802687210ULL, 0x000fe20007f5e0ffULL, 0x000000106d1f7824ULL, 0x100fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004177faeULL, 0x0003e2000b901c48ULL,
0x00000010716d7824ULL, 0x000fc400078e0200ULL, 0x00000001030b7824ULL, 0x000fe200018e060bULL,
0x0000006a02027210ULL, 0x000fe20007f7e0ffULL, 0x00000010736f7824ULL, 0x100fe200078e0200ULL,
0x00000000061f7faeULL, 0x0003e2000b901c48ULL, 0x0000001075717824ULL, 0x100fe200078e0200ULL,
0x0000000079757211ULL, 0x000fe200078e20ffULL, 0x0000000103257824ULL, 0x000fe200000e0625ULL,
0x00000000086d7faeULL, 0x0003e2000b901c48ULL, 0x0000001077737824ULL, 0x100fe400078e0200ULL,
0x0000000103277824ULL, 0x040fe200008e0627ULL, 0x000000000a6f7faeULL, 0x0003e2000b901c48ULL,
0x0000000103697824ULL, 0x040fe200010e0669ULL, 0x0000006b03037210ULL, 0x000fe20001ffe4ffULL,
0x000000107b777824ULL, 0x000fe200078e0200ULL, 0x0000000024717faeULL, 0x0003e8000b901c48ULL,
0x0000000026737faeULL, 0x0003e8000b901c48ULL, 0x0000000068757faeULL, 0x0003e8000b901c48ULL,
0x0000000002777faeULL, 0x0003e4000b901c48ULL, 0x00000300ff007624ULL, 0x000fe200078e00ffULL,
0x0000000120027812ULL, 0x002fe200078ec0ffULL, 0xffffffffff1f7424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000010200780cULL, 0x000fc40003f05070ULL,
0xffffffff00007811ULL, 0x000fc800078e08ffULL, 0x0000000100037807ULL, 0x000fca0004000000ULL,
0x0000000103207824ULL, 0x000fca00078e0220ULL, 0x0000001a2000720cULL, 0x000fda0003f06070ULL,
0x0000000113028824ULL, 0x000fe400078e0220ULL, 0x00000004ff038424ULL, 0x000fc800078e00ffULL,
0x0000640002028625ULL, 0x000fca00078e0003ULL, 0x00000008021f8981ULL, 0x000322000c1e1900ULL,
0xffffffe018007812ULL, 0x040fe400078ec0ffULL, 0x0000001018057812ULL, 0x040fe400078ec0ffULL,
0x0000000818047812ULL, 0x000fc800078ec0ffULL, 0x0000000004007210ULL, 0x000fe20007ffe005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e6080000067f8cULL, 0x0022a4000c80043fULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x01e60c0000057984ULL, 0x000ee40000000800ULL,
0x8000000005ff7812ULL, 0x00cfe40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402097210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000904047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e60c0000057984ULL, 0x000ea40000000800ULL, 0x8000000005ff7812ULL, 0x004fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000201e007824ULL, 0x002fe200078e00ffULL,
0x000000041c127819ULL, 0x000fe400000006ffULL, 0x00000001ff807819ULL, 0x000fe4000001161cULL,
0x0000007012127812ULL, 0x000fc400078ec0ffULL, 0xffffff8000037812ULL, 0x000fe400078ec0ffULL,
0x0000000c80807812ULL, 0x000fc800078ec0ffULL, 0x0000000380037210ULL, 0x000fca0007ffe012ULL,
0x01e0000003007984ULL, 0x000e680000000800ULL, 0x01e2000003027984ULL, 0x0004e20000000800ULL,
0x000000210000720bULL, 0x002fe20003f1d000ULL, 0x000168c27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000037806ULL, 0x004fc800000e0100ULL, 0x000000ff0300720cULL, 0x000fe20003f25270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff177224ULL, 0x000fd400078e0021ULL, 0x0000071000009947ULL, 0x000fea0003800000ULL,
0x00000002ff057819ULL, 0x000fe4000001161eULL, 0x000000210000720bULL, 0x000fe40003f54000ULL,
0x0000001e0500720cULL, 0x000fe20003f25270ULL, 0x000168827f007947ULL, 0x000fd4000b800000ULL,
0x0000000000047806ULL, 0x000fc400010e0100ULL, 0x000000801e059824ULL, 0x000fe200078e0212ULL,
0x0000002100177209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000180069824ULL, 0x000fca00078e0205ULL, 0x01e4001706009388ULL, 0x0003e20000000800ULL,
0x000000ff0400720cULL, 0x000fda0003f25270ULL, 0x000005e000009947ULL, 0x000fea0003800000ULL,
0x0000002117057221ULL, 0x002fe20000010100ULL, 0x000000ff04ff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b05057820ULL, 0x000fcc0000410000ULL,
0x0000000500057308ULL, 0x000e640000000800ULL, 0x0000000523237220ULL, 0x002fe40000410000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000002ff247819ULL, 0x000fe2000001161cULL,
0x000167d27f007947ULL, 0x000fea000b800000ULL, 0x00001f2405247589ULL, 0x0002a400000e0000ULL,
0x0000002464647220ULL, 0x084fe40000410000ULL, 0x0000002465657220ULL, 0x080fe40000410000ULL,
0x0000002428287220ULL, 0x080fe40000410000ULL, 0x0000002429297220ULL, 0x000fc40000410000ULL,
0x000000242c2c7220ULL, 0x080fe40000410000ULL, 0x000000242d2d7220ULL, 0x080fe40000410000ULL,
0x0000002430307220ULL, 0x080fe40000410000ULL, 0x0000002431317220ULL, 0x080fe40000410000ULL,
0x0000002434347220ULL, 0x080fe40000410000ULL, 0x0000002435357220ULL, 0x000fc40000410000ULL,
0x0000002438387220ULL, 0x080fe40000410000ULL, 0x0000002439397220ULL, 0x080fe40000410000ULL,
0x000000243c3c7220ULL, 0x080fe40000410000ULL, 0x000000243d3d7220ULL, 0x080fe40000410000ULL,
0x0000002440407220ULL, 0x080fe40000410000ULL, 0x0000002441417220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0004ff7812ULL, 0x000fe2000782c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x000000081c247811ULL, 0x000fe200078ff0ffULL, 0x000166c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2405247589ULL, 0x00046400000e0000ULL, 0x0000002466667220ULL, 0x086fe40000410000ULL,
0x0000002467677220ULL, 0x080fe40000410000ULL, 0x000000242a2a7220ULL, 0x080fe40000410000ULL,
0x000000242b2b7220ULL, 0x080fe40000410000ULL, 0x000000242e2e7220ULL, 0x080fe40000410000ULL,
0x000000242f2f7220ULL, 0x000fc40000410000ULL, 0x0000002432327220ULL, 0x080fe40000410000ULL,
0x0000002433337220ULL, 0x080fe40000410000ULL, 0x0000002436367220ULL, 0x080fe40000410000ULL,
0x0000002437377220ULL, 0x080fe40000410000ULL, 0x000000243a3a7220ULL, 0x080fe40000410000ULL,
0x000000243b3b7220ULL, 0x000fc40000410000ULL, 0x000000243e3e7220ULL, 0x080fe40000410000ULL,
0x000000243f3f7220ULL, 0x080fe40000410000ULL, 0x0000002442427220ULL, 0x080fe40000410000ULL,
0x0000002443437220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000004ff7812ULL, 0x000fe2000782c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x000000101c247811ULL, 0x000fe200078ff0ffULL,
0x000165b27f007947ULL, 0x000fea000b800000ULL, 0x00001f2405247589ULL, 0x00046400000e0000ULL,
0x0000002444447220ULL, 0x086fe40000410000ULL, 0x0000002445457220ULL, 0x080fe40000410000ULL,
0x0000002448487220ULL, 0x080fe40000410000ULL, 0x0000002449497220ULL, 0x080fe40000410000ULL,
0x000000244c4c7220ULL, 0x080fe40000410000ULL, 0x000000244d4d7220ULL, 0x000fc40000410000ULL,
0x0000002450507220ULL, 0x080fe40000410000ULL, 0x0000002451517220ULL, 0x080fe40000410000ULL,
0x0000002454547220ULL, 0x080fe40000410000ULL, 0x0000002455557220ULL, 0x080fe40000410000ULL,
0x0000002458587220ULL, 0x080fe40000410000ULL, 0x0000002459597220ULL, 0x000fc40000410000ULL,
0x000000245c5c7220ULL, 0x080fe40000410000ULL, 0x000000245d5d7220ULL, 0x080fe40000410000ULL,
0x0000002460607220ULL, 0x080fe40000410000ULL, 0x0000002461617220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000004ff7812ULL, 0x000fda000782c0ffULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x000000181c247811ULL, 0x000fe200078ff0ffULL,
0x000164b27f007947ULL, 0x000fea000b800000ULL, 0x00001f2405247589ULL, 0x00046400000e0000ULL,
0x0000002446467220ULL, 0x086fe40000410000ULL, 0x0000002447477220ULL, 0x080fe40000410000ULL,
0x000000244a4a7220ULL, 0x080fe40000410000ULL, 0x000000244b4b7220ULL, 0x080fe40000410000ULL,
0x000000244e4e7220ULL, 0x080fe40000410000ULL, 0x000000244f4f7220ULL, 0x000fc40000410000ULL,
0x0000002452527220ULL, 0x080fe40000410000ULL, 0x0000002453537220ULL, 0x080fe40000410000ULL,
0x0000002456567220ULL, 0x080fe40000410000ULL, 0x0000002457577220ULL, 0x080fe40000410000ULL,
0x000000245a5a7220ULL, 0x080fe40000410000ULL, 0x000000245b5b7220ULL, 0x000fc40000410000ULL,
0x000000245e5e7220ULL, 0x080fe40000410000ULL, 0x000000245f5f7220ULL, 0x080fe40000410000ULL,
0x0000002462627220ULL, 0x080fe40000410000ULL, 0x0000002463637220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000000403ff7212ULL, 0x000fda00078230ffULL,
0x8000001700001221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b00001820ULL, 0x000fc80000410000ULL, 0x0000000000111308ULL, 0x000e640000000800ULL,
0x0000001102021220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000002302237221ULL, 0x008fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000011ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff037819ULL, 0x000fe4000001161cULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x000163027f007947ULL, 0x000fea000b800000ULL,
0x00001f0300107589ULL, 0x0002a400000e0000ULL, 0x0000000803247810ULL, 0x000fe20007ffe0ffULL,
0x000163527f007947ULL, 0x000fea000b800000ULL, 0x0000001003057810ULL, 0x000fe20007ffe0ffULL,
0x00001f24000f7589ULL, 0x00066800000e0000ULL, 0x00001f05000e7589ULL, 0x0006a400000e0000ULL,
0x0000001803247810ULL, 0x008fe20007ffe0ffULL, 0x000163e27f007947ULL, 0x000fea000b800000ULL,
0x00001f24000d7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000021e227824ULL, 0x000fe200078e00ffULL, 0x000000081c037812ULL, 0x002fe200078ec0ffULL,
0x000020001e217824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000002c000007945ULL, 0x000fe20003800000ULL, 0x0000000422057812ULL, 0x000fc400078ec0ffULL,
0x0000000703037812ULL, 0x000fe400078ef81cULL, 0x000000051c007211ULL, 0x048fe400078fe0ffULL,
0x00000010037d7812ULL, 0x040fe200078efcffULL, 0x0000000803077824ULL, 0x040fe200078e00ffULL,
0x000000031c027211ULL, 0x000fe200078fe0ffULL, 0x00000001030c7824ULL, 0x040fe200078e0200ULL,
0x0000000303097819ULL, 0x000fe200000006ffULL, 0x00000001000b7824ULL, 0x000fe200078e027dULL,
0x00000002020a7810ULL, 0x000fe20007ffe0ffULL, 0x000004001e007824ULL, 0x000fe200078e00ffULL,
0xfffffff8070c7812ULL, 0x000fe200078ee20cULL, 0x000000087d047824ULL, 0x000fe200078e00ffULL,
0xfffffff8070a7812ULL, 0x000fe200078ee20aULL, 0x0000000803257824ULL, 0x040fe200078e00ffULL,
0xfffff00000007812ULL, 0x000fe200078ec0ffULL, 0x0000000803277824ULL, 0x000fe200078e00ffULL,
0xffffc00021077812ULL, 0x000fc400078ec0ffULL, 0xfffffff8040b7812ULL, 0x000fe400078ee20bULL,
0x00012000007c7810ULL, 0x000fe40007ffe0ffULL, 0x0000000402087810ULL, 0x000fe40007ffe0ffULL,
0xfffffff809097812ULL, 0x000fe200078ee202ULL, 0x000000100c787824ULL, 0x000fe200078e027cULL,
0x0000000602047810ULL, 0x000fe20007ffe0ffULL, 0x0000200014027824ULL, 0x000fe200078e0207ULL,
0xfffffff825087812ULL, 0x000fe200078ee208ULL, 0x000000100b247824ULL, 0x000fe200078e027cULL,
0xfffffff827077812ULL, 0x000fe200078ee204ULL, 0x000000007878783bULL, 0x000e620000000200ULL,
0x0001600002027810ULL, 0x000fc60007ffe0ffULL, 0x000000002424783bULL, 0x000ee40000000200ULL,
0x0000001009747824ULL, 0x100fe400078e0202ULL, 0x000000100a707824ULL, 0x100fe400078e0202ULL,
0x00000010086c7824ULL, 0x000fe200078e0202ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000001078787232ULL, 0x086fe40000000000ULL, 0x000000107a7a7232ULL, 0x000fe40000000000ULL,
0x0000000f79797232ULL, 0x000fc40000000000ULL, 0x0000000f7b7b7232ULL, 0x000fe40000000000ULL,
0x0000000e24247232ULL, 0x088fe40000000000ULL, 0x0000000e26267232ULL, 0x000fe40000000000ULL,
0x0000000d25257232ULL, 0x080fe40000000000ULL, 0x0000000d27277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000006c6c783bULL, 0x000ee20000004200ULL,
0x0000000207687211ULL, 0x000fe200078e20ffULL, 0x000000087d027824ULL, 0x000fe200078e00ffULL,
0x0000000205057812ULL, 0x000fe200078efcffULL, 0x000000007474783bULL, 0x000fe20000004200ULL,
0x00000001ff7e7819ULL, 0x000fe2000001161eULL, 0x0000037000007945ULL, 0x000fe20003800000ULL,
0x000000051c007211ULL, 0x000fe200078fe0ffULL, 0x000000006868783bULL, 0x000ea80000004200ULL,
0x000000007070783bULL, 0x000e620000004200ULL, 0x0000000103067824ULL, 0x000fc400078e0200ULL,
0x000000017d057824ULL, 0x000fe200078e0200ULL, 0x0000007d1c007211ULL, 0x000fc800078fe0ffULL,
0xfffffff802057812ULL, 0x000fe400078ee205ULL, 0x0000000400027810ULL, 0x000fe20007ffe0ffULL,
0x0000006c7834723cULL, 0x08af700000001834ULL, 0x0000006c2454723cULL, 0x000b6e0000001854ULL,
0x00000008036d7824ULL, 0x020fe200078e00ffULL, 0x00000068783c723cULL, 0x004f62000000183cULL,
0x000000087d037824ULL, 0x000fc400078e00ffULL, 0x000000087d6c7824ULL, 0x000fe200078e00ffULL,
0xfffffff86d067812ULL, 0x000fe400078ee206ULL, 0xfffffff803047812ULL, 0x000fe400078ee200ULL,
0x00000068245c723cULL, 0x000b62000000185cULL, 0x0000000200037810ULL, 0x040fe40007ffe0ffULL,
0x0000000600007810ULL, 0x000fe40007ffe0ffULL, 0xfffffff86c037812ULL, 0x000fc400078ee203ULL,
0x000000087d697824ULL, 0x060fe200078e00ffULL, 0x000000747864723cULL, 0x040f620000001864ULL,
0x000000147e687211ULL, 0x000fe200078e08ffULL, 0x000000087d7d7824ULL, 0x000fe400078e00ffULL,
0xfffffff869027812ULL, 0x000fe400078ee202ULL, 0x0001600068697811ULL, 0x000fe400078e68ffULL,
0x000000767828723cULL, 0x000f620000001828ULL, 0xfffffff87d007812ULL, 0x000fc400078ee200ULL,
0x00000010046c7824ULL, 0x000fca00078e0269ULL, 0x00000070782c723cULL, 0x040f70000000182cULL,
0x000000727830723cULL, 0x040f700000001830ULL, 0x0000006e7838723cULL, 0x040f700000001838ULL,
0x0000006a7840723cULL, 0x000b6e0000001840ULL, 0x0000001006787824ULL, 0x120fe200078e027cULL,
0x000000742444723cULL, 0x040b6a0000001844ULL, 0x000000007878783bULL, 0x000e640000000200ULL,
0x0000001003747824ULL, 0x120fe200078e0269ULL, 0x000000762448723cULL, 0x040f700000001848ULL,
0x00000070244c723cULL, 0x040b6e000000184cULL, 0x0000001002707824ULL, 0x020fe200078e0269ULL,
0x000000722450723cULL, 0x040f700000001850ULL, 0x0000006e2458723cULL, 0x040f700000001858ULL,
0x0000006a2460723cULL, 0x000b6e0000001860ULL, 0x0000001005247824ULL, 0x020fcc00078e027cULL,
0x000000002424783bULL, 0x000ea20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000001078787232ULL, 0x082fe40000000000ULL, 0x000000107a7a7232ULL, 0x000fe40000000000ULL,
0x0000000f79797232ULL, 0x080fe40000000000ULL, 0x0000000f7b7b7232ULL, 0x000fe40000000000ULL,
0x0000000e24247232ULL, 0x084fe40000000000ULL, 0x0000000e26267232ULL, 0x000fc40000000000ULL,
0x0000000d25257232ULL, 0x080fe40000000000ULL, 0x0000000d27277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x002fea0003800000ULL, 0x0000001000687824ULL, 0x000fe200078e0269ULL,
0x000000006c6c783bULL, 0x000e620000004200ULL, 0x000059001f1f7a24ULL, 0x010fe200078e02ffULL,
0xfffffff822227812ULL, 0x000fe400078ec0ffULL, 0x000000007474783bULL, 0x000ee80000004200ULL,
0x000000007070783bULL, 0x000ea80000004200ULL, 0x000000006868783bULL, 0x000ea20000004200ULL,
0x0000006c7864723cULL, 0x042f700000001864ULL, 0x0000006e7828723cULL, 0x040f700000001828ULL,
0x00000074782c723cULL, 0x048f70000000182cULL, 0x000000767830723cULL, 0x040f700000001830ULL,
0x000000707834723cULL, 0x044f700000001834ULL, 0x000000727838723cULL, 0x040f700000001838ULL,
0x00000068783c723cULL, 0x040f70000000183cULL, 0x0000006a7840723cULL, 0x000f700000001840ULL,
0x00000074244c723cULL, 0x040f70000000184cULL, 0x000000762450723cULL, 0x040f700000001850ULL,
0x000000702454723cULL, 0x040f700000001854ULL, 0x000000722458723cULL, 0x040f700000001858ULL,
0x0000006c2444723cULL, 0x040f700000001844ULL, 0x0000006e2448723cULL, 0x040f700000001848ULL,
0x00000068245c723cULL, 0x040f70000000185cULL, 0x0000006a2460723cULL, 0x000b6e0000001860ULL,
0x000000081d247824ULL, 0x020fe200078e027eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fcc0000008000ULL,
0x000000011d687810ULL, 0x000fe20007ffe0ffULL, 0x01e6880022ff7f8cULL, 0x0003e2000c80043fULL,
0x0000008024267811ULL, 0x000fe200078e28ffULL, 0x00000100ff6a7424ULL, 0x000fe200078e00ffULL,
0x000000196800720cULL, 0x000fc40003f06070ULL, 0x000000071f1f7819ULL, 0x000fe400000006ffULL,
0x0000006026247812ULL, 0x000fc600078ec0ffULL, 0x000062001f687625ULL, 0x000fc800078e006aULL,
0x00000001157d7824ULL, 0x000fe200078e0224ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000003ff227819ULL, 0x002fe2000001161cULL,
0x000000801e257824ULL, 0x000fe200078e00ffULL, 0x000000261b1f7217ULL, 0x000fe40007800000ULL,
0x00000008226c7810ULL, 0x040fe40007ffe0ffULL, 0x00000004226a7810ULL, 0x000fe20007ffe0ffULL,
0x000000011f1f7824ULL, 0x000fe200078e0a26ULL, 0x0000200021217812ULL, 0x000fe200078ec0ffULL,
0x000000016c247824ULL, 0x000fe200078e021cULL, 0x0000001422847810ULL, 0x000fe20007ffe0ffULL,
0x000000086c277824ULL, 0x000fe200078e00ffULL, 0x000000201f1f7817ULL, 0x000fe20003800000ULL,
0x000000016a6b7824ULL, 0x000fe200078e027dULL, 0x0000000c22727810ULL, 0x000fe20007ffe0ffULL,
0x000040007e7e7824ULL, 0x000fe200078e0221ULL, 0xfffffff827767812ULL, 0x000fe200078ee224ULL,
0x000000016a217824ULL, 0x100fe200078e021cULL, 0x0000008012247812ULL, 0x000fe200078ef825ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x0000007d22277210ULL, 0x000fe20007ffe0ffULL,
0x000000086a747824ULL, 0x040fe200078e00ffULL, 0x0000001f6a00720cULL, 0x000fe20003f86070ULL,
0x00000001846f7824ULL, 0x000fe200078e021cULL, 0x00000010227a7810ULL, 0x000fe20007ffe0ffULL,
0x0000010027267825ULL, 0x000fe200078e0024ULL, 0xfffffff874747812ULL, 0x000fc400078ee221ULL,
0x0000001f7200720cULL, 0x080fe20003f46070ULL, 0x0000000884867824ULL, 0x000fe200078e00ffULL,
0x00000026686e7210ULL, 0x000fe20007f1e0ffULL, 0x000001006b6a7825ULL, 0x000fe200078e0024ULL,
0x0000001f6c00720cULL, 0x000fe40003f66070ULL, 0xfffffff886867812ULL, 0x000fe200078ee26fULL,
0x0000000172217824ULL, 0x100fe200078e021cULL, 0x0000006a68707210ULL, 0x000fe20007f3e0ffULL,
0x0000000872787824ULL, 0x000fe200078e00ffULL, 0x00000027696f7210ULL, 0x040fe200007fe4ffULL,
0x000000016c277824ULL, 0x000fe200078e027dULL, 0x0000001f2200720cULL, 0x080fe20003fa6070ULL,
0x0000000169717824ULL, 0x000fe200008e066bULL, 0xfffffff878787812ULL, 0x000fe200078ee221ULL,
0x000000017a6d7824ULL, 0x040fe200078e021cULL, 0x0000001f7a00720cULL, 0x040fe20003f26070ULL,
0x000000087a7c7824ULL, 0x000fc400078e00ffULL, 0x00000001726b7824ULL, 0x000fe400078e027dULL,
0x0000010027267825ULL, 0x000fe200078e0024ULL, 0xfffffff87c7c7812ULL, 0x000fc600078ee26dULL,
0x0000000122217824ULL, 0x000fe200078e021cULL, 0x0000002668727210ULL, 0x000fe20007f1e0ffULL,
0x000001006b6a7825ULL, 0x000fc600078e0024ULL, 0x0000000721757812ULL, 0x000fe200078ec0ffULL,
0x000000017a6d7824ULL, 0x000fe200078e027dULL, 0x0000006a686a7210ULL, 0x000fe20007fde0ffULL,
0x0000000169737824ULL, 0x000fe200000e0627ULL, 0x000160007e217810ULL, 0x000fe20007ffe0ffULL,
0x000001006d6c7825ULL, 0x000fe200078e0024ULL, 0x0ffffff875267812ULL, 0x000fe400078ef81cULL,
0x0000007d84277210ULL, 0x000fe20007ffe0ffULL, 0x00000001696b7824ULL, 0x000fe200030e066bULL,
0x0000006c686c7210ULL, 0x000fe20007fde0ffULL, 0x0000001026777824ULL, 0x000fe200078e0221ULL,
0x00000018227a7810ULL, 0x040fe20007ffe0ffULL, 0x0000010027267825ULL, 0x000fe200078e0024ULL,
0x0000001c227e7810ULL, 0x000fc40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e777faeULL, 0x0003e2000e901c48ULL, 0x00000001696d7824ULL, 0x040fe200030e066dULL,
0x0000001f8400720cULL, 0x080fe20003f06070ULL, 0x0000001074797824ULL, 0x000fe200078e0221ULL,
0x0000002668747210ULL, 0x000fe20007fde0ffULL, 0x000000017a7b7824ULL, 0x040fe200078e027dULL,
0x0000001f7a00720cULL, 0x0c0fe20003fa6070ULL, 0x000000017a227824ULL, 0x000fe200078e021cULL,
0x0000000070797faeULL, 0x0005e2000e101c48ULL, 0x0000000169757824ULL, 0x000fe200030e0627ULL,
0x0000001f7e00720cULL, 0x000fe20003f86070ULL, 0x000001007b267825ULL, 0x000fc800078e0024ULL,
0x000000017e1f7824ULL, 0x000fe200078e027dULL, 0x0000002668267210ULL, 0x000fe20007fde0ffULL,
0x000000087a6f7824ULL, 0x002fe400078e00ffULL, 0x000000017e6e7824ULL, 0x040fe200078e021cULL,
0x000000037e717819ULL, 0x004fe200000006ffULL, 0x000001001f247825ULL, 0x000fe200078e0024ULL,
0xfffffff86f227812ULL, 0x000fe400078ee222ULL, 0xfffffff8716e7812ULL, 0x000fe200078ee26eULL,
0x0000000169277824ULL, 0x000fe200030e0627ULL, 0x0000002468247210ULL, 0x000fe20007fde0ffULL,
0x00000010761f7824ULL, 0x000fc400078e0221ULL, 0x00000010786f7824ULL, 0x100fe400078e0221ULL,
0x000000107c717824ULL, 0x100fe200078e0221ULL, 0x00000000721f7faeULL, 0x0003e2000d901c48ULL,
0x0000001086777824ULL, 0x100fe400078e0221ULL, 0x0000001022797824ULL, 0x100fe200078e0221ULL,
0x000000006a6f7faeULL, 0x0003e2000d101c48ULL, 0x000000106e217824ULL, 0x000fe400078e0221ULL,
0x0000000169257824ULL, 0x000fe200030e0625ULL, 0x000000006c717faeULL, 0x0003e8000c901c48ULL,
0x0000000074777faeULL, 0x0003e8000c101c48ULL, 0x0000000026797faeULL, 0x0003e8000e901c48ULL,
0x0000000024217faeULL, 0x0003e2000e101c48ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x000000041c277811ULL, 0x002fe200078fe8ffULL, 0x000000801e757824ULL, 0x000fe200078e00ffULL,
0x0000000c1c6d7811ULL, 0x000fc400078fe8ffULL, 0x000000101c6f7811ULL, 0x040fe200078fe8ffULL,
0x00000001271f7824ULL, 0x100fe200078e021cULL, 0x0000200021217812ULL, 0x000fe200078ec0ffULL,
0x0000000827247824ULL, 0x000fe200078e00ffULL, 0x000000081c6b7811ULL, 0x040fe200078fe8ffULL,
0x000000016d227824ULL, 0x140fe200078e021cULL, 0x000000181c737811ULL, 0x000fe200078fe8ffULL,
0x000000086d7b7824ULL, 0x000fe200078e00ffULL, 0xfffffff824777812ULL, 0x000fe200078ee21fULL,
0x000000016f1f7824ULL, 0x100fe200078e021cULL, 0x000000217e7e7211ULL, 0x000fe200078e70ffULL,
0x000000016b217824ULL, 0x000fe200078e021cULL, 0xfffffff87b7b7812ULL, 0x000fe200078ee222ULL,
0x000000086f227824ULL, 0x000fe200078e00ffULL, 0x000000141c717811ULL, 0x000fe200078fe8ffULL,
0x000000086b267824ULL, 0x000fe200078e00ffULL, 0x0000008012747812ULL, 0x000fe200078ef875ULL,
0x0000000873897824ULL, 0x040fe200078e00ffULL, 0xfffffff8227f7812ULL, 0x000fe200078ee21fULL,
0x0000000173227824ULL, 0x000fe200078e021cULL, 0xfffffff826797812ULL, 0x000fe200078ee221ULL,
0x0000000871247824ULL, 0x040fe200078e00ffULL, 0x0000001c71217210ULL, 0x080fe20007ffe0ffULL,
0x0000000127277824ULL, 0x100fe200078e027dULL, 0xfffffff889897812ULL, 0x000fe200078ee222ULL,
0x000000ffff757224ULL, 0x000fe200078e00ffULL, 0x0000001c1c227811ULL, 0x000fe200078fe8ffULL,
0x000000016b6b7824ULL, 0x000fe200078e027dULL, 0xfffffff824877812ULL, 0x000fe200078ee221ULL,
0x000000016d6d7824ULL, 0x000fe200078e027dULL, 0x0000007d1c257211ULL, 0x080fe200078fe8ffULL,
0x0000000122247824ULL, 0x000fe200078e021cULL, 0x0000001c1c1f7211ULL, 0x000fe200078fe8ffULL,
0x00000008228b7824ULL, 0x000fe200078e00ffULL, 0x0000007d71717210ULL, 0x000fe20007ffe0ffULL,
0x0000010027267825ULL, 0x000fe200078e0074ULL, 0x000000071f217812ULL, 0x000fc400078ec0ffULL,
0xfffffff88b8b7812ULL, 0x000fe200078ee224ULL, 0x0000010025247825ULL, 0x100fe200078e0074ULL,
0x0000002668267210ULL, 0x000fe40007f3e0ffULL, 0x000160007e7e7810ULL, 0x000fe20007ffe0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0074ULL, 0x0000002468247210ULL, 0x040fe40007f1e0ffULL,
0x0ffffff821217812ULL, 0x000fe200078ef81cULL, 0x000000016f6f7824ULL, 0x000fe200078e027dULL,
0x0000006a686a7210ULL, 0x000fe20007f5e0ffULL, 0x000001006d6c7825ULL, 0x000fc800078e0074ULL,
0x0000000173737824ULL, 0x100fe200078e027dULL, 0x0000006c686c7210ULL, 0x000fe20007f7e0ffULL,
0x00000001221f7824ULL, 0x000fe400078e027dULL, 0x000001006f6e7825ULL, 0x000fc800078e0074ULL,
0x0000010071707825ULL, 0x000fc800078e0074ULL, 0x0000010073727825ULL, 0x000fc800078e0074ULL,
0x000001001f747825ULL, 0x000fc800078e0074ULL, 0x0000000169257824ULL, 0x040fe200000e0625ULL,
0x0000006e686e7210ULL, 0x040fe20007f1e0ffULL, 0x0000000169277824ULL, 0x000fe200008e0627ULL,
0x0000007068707210ULL, 0x040fe20007f3e0ffULL, 0x00000010211f7824ULL, 0x100fe200078e027eULL,
0x0000006f696f7210ULL, 0x040fe200007fe4ffULL, 0x00000001696b7824ULL, 0x000fe200010e066bULL,
0x0000007268727210ULL, 0x040fe20007f5e0ffULL, 0x0000001077217824ULL, 0x100fe200078e027eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000241f7faeULL, 0x0003e2000b901c48ULL,
0x00000001696d7824ULL, 0x000fe200018e066dULL, 0x0000007468747210ULL, 0x000fe20007f7e0ffULL,
0x0000001079777824ULL, 0x100fe200078e027eULL, 0x0000007e7b797211ULL, 0x000fe200078e20ffULL,
0x000000107f7b7824ULL, 0x100fe200078e027eULL, 0x0000000026217faeULL, 0x0003e2000b901c48ULL,
0x00000010877d7824ULL, 0x000fc400078e027eULL, 0x0000000169717824ULL, 0x000fe200008e0671ULL,
0x000000006a777faeULL, 0x0003e2000b901c48ULL, 0x00000010897f7824ULL, 0x100fe400078e027eULL,
0x0000000169737824ULL, 0x000fe200010e0673ULL, 0x000000006c797faeULL, 0x0003e2000b901c48ULL,
0x000000108b877824ULL, 0x000fe400078e027eULL, 0x0000000169757824ULL, 0x000fe200018e0675ULL,
0x000000006e7b7faeULL, 0x0003e8000b901c48ULL, 0x00000000707d7faeULL, 0x0003e8000b901c48ULL,
0x00000000727f7faeULL, 0x0003e8000b901c48ULL, 0x0000000074877faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe0181f7812ULL, 0x002fc400078ec0ffULL,
0x0000001018227812ULL, 0x040fe400078ec0ffULL, 0x0000000818217812ULL, 0x000fc800078ec0ffULL,
0x0000001f21217210ULL, 0x000fe20007ffe022ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e62800216a7f8cULL, 0x0002a4000c80043fULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x01e62c00211f7984ULL, 0x000ee40000000800ULL, 0x800000001fff7812ULL, 0x00cfe4000780486bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624227210ULL, 0x000fca0007f1e1ffULL,
0x0000000127267824ULL, 0x000fe200000e0e25ULL, 0x003d09002200780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402200780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1f7819ULL, 0x000fc80000011426ULL,
0x000000221f1f7211ULL, 0x000fca00078110ffULL, 0x000000ffff227224ULL, 0x000fca00000e0626ULL,
0x000000021f1f7819ULL, 0x000fc80000001222ULL, 0x0000001f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016c6c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e62c00211f7984ULL, 0x000ea40000000800ULL,
0x800000001fff7812ULL, 0x004fe4000780486bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201e1f7824ULL, 0x000fca00078e00ffULL, 0xffffff801f1f7812ULL, 0x000fc800078ec0ffULL,
0x00000080121f7810ULL, 0x000fca0007ffe01fULL, 0x00000001801f7824ULL, 0x000fca00078e021fULL,
0x01e000001f227984ULL, 0x000ea80000000800ULL, 0x01e200001f6c7984ULL, 0x0006620000000800ULL,
0x000000172200720bULL, 0x004fe20003f1d000ULL, 0x00014b927f007947ULL, 0x000fd8000b800000ULL,
0x00000000001f7806ULL, 0x008fc800000e0100ULL, 0x000000ff1f00720cULL, 0x000fe20003f25270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff217224ULL, 0x002fd400078e0017ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x000000011e217811ULL, 0x000fe400078ff0ffULL, 0x000000172200720bULL, 0x000fe40003f34000ULL,
0x0000001e2100720cULL, 0x000fe20003f05270ULL, 0x00014b527f007947ULL, 0x000fd4000b800000ULL,
0x00000000006e7806ULL, 0x000fc400008e0100ULL, 0x000000801e258824ULL, 0x000fe200078e0212ULL,
0x0000001722218209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000180248824ULL, 0x000fca00078e0225ULL, 0x01e4002124008388ULL, 0x0003e20000000800ULL,
0x000000ff6e00720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000001722247209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff6eff7812ULL, 0x000fc6000780c0ffULL, 0x0000001724217221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b21217820ULL, 0x000fc80000410000ULL, 0x0000002100707308ULL, 0x000e640000000800ULL,
0x0000007023237220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff247819ULL, 0x000fe2000001161cULL, 0x00014a927f007947ULL, 0x000fea000b800000ULL,
0x00001f2470247589ULL, 0x0002a400000e0000ULL, 0x0000002464647220ULL, 0x084fe40000410000ULL,
0x0000002465657220ULL, 0x080fe40000410000ULL, 0x0000002428287220ULL, 0x080fe40000410000ULL,
0x0000002429297220ULL, 0x000fc40000410000ULL, 0x000000242c2c7220ULL, 0x080fe40000410000ULL,
0x000000242d2d7220ULL, 0x080fe40000410000ULL, 0x0000002430307220ULL, 0x080fe40000410000ULL,
0x0000002431317220ULL, 0x080fe40000410000ULL, 0x0000002434347220ULL, 0x080fe40000410000ULL,
0x0000002435357220ULL, 0x000fc40000410000ULL, 0x0000002438387220ULL, 0x080fe40000410000ULL,
0x0000002439397220ULL, 0x080fe40000410000ULL, 0x000000243c3c7220ULL, 0x080fe40000410000ULL,
0x000000243d3d7220ULL, 0x080fe40000410000ULL, 0x0000002440407220ULL, 0x080fe40000410000ULL,
0x0000002441417220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff006eff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081c247811ULL, 0x000fe200078ff0ffULL,
0x000149827f007947ULL, 0x000fea000b800000ULL, 0x00001f2470247589ULL, 0x0004e400000e0000ULL,
0x0000002466667220ULL, 0x08cfe40000410000ULL, 0x0000002467677220ULL, 0x080fe40000410000ULL,
0x000000242a2a7220ULL, 0x080fe40000410000ULL, 0x000000242b2b7220ULL, 0x080fe40000410000ULL,
0x000000242e2e7220ULL, 0x080fe40000410000ULL, 0x000000242f2f7220ULL, 0x000fc40000410000ULL,
0x0000002432327220ULL, 0x080fe40000410000ULL, 0x0000002433337220ULL, 0x080fe40000410000ULL,
0x0000002436367220ULL, 0x080fe40000410000ULL, 0x0000002437377220ULL, 0x080fe40000410000ULL,
0x000000243a3a7220ULL, 0x080fe40000410000ULL, 0x000000243b3b7220ULL, 0x000fc40000410000ULL,
0x000000243e3e7220ULL, 0x080fe40000410000ULL, 0x000000243f3f7220ULL, 0x080fe40000410000ULL,
0x0000002442427220ULL, 0x080fe40000410000ULL, 0x0000002443437220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00006eff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101c247811ULL, 0x000fe200078ff0ffULL, 0x000148727f007947ULL, 0x000fea000b800000ULL,
0x00001f2470247589ULL, 0x0004e400000e0000ULL, 0x0000002444447220ULL, 0x08cfe40000410000ULL,
0x0000002445457220ULL, 0x080fe40000410000ULL, 0x0000002448487220ULL, 0x080fe40000410000ULL,
0x0000002449497220ULL, 0x080fe40000410000ULL, 0x000000244c4c7220ULL, 0x080fe40000410000ULL,
0x000000244d4d7220ULL, 0x000fc40000410000ULL, 0x0000002450507220ULL, 0x080fe40000410000ULL,
0x0000002451517220ULL, 0x080fe40000410000ULL, 0x0000002454547220ULL, 0x080fe40000410000ULL,
0x0000002455557220ULL, 0x080fe40000410000ULL, 0x0000002458587220ULL, 0x080fe40000410000ULL,
0x0000002459597220ULL, 0x000fc40000410000ULL, 0x000000245c5c7220ULL, 0x080fe40000410000ULL,
0x000000245d5d7220ULL, 0x080fe40000410000ULL, 0x0000002460607220ULL, 0x080fe40000410000ULL,
0x0000002461617220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000006eff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181c247811ULL, 0x000fe200078ff0ffULL, 0x000147727f007947ULL, 0x000fea000b800000ULL,
0x00001f2470247589ULL, 0x0004e400000e0000ULL, 0x0000002446467220ULL, 0x08cfe40000410000ULL,
0x0000002447477220ULL, 0x080fe40000410000ULL, 0x000000244a4a7220ULL, 0x080fe40000410000ULL,
0x000000244b4b7220ULL, 0x080fe40000410000ULL, 0x000000244e4e7220ULL, 0x080fe40000410000ULL,
0x000000244f4f7220ULL, 0x000fc40000410000ULL, 0x0000002452527220ULL, 0x080fe40000410000ULL,
0x0000002453537220ULL, 0x080fe40000410000ULL, 0x0000002456567220ULL, 0x080fe40000410000ULL,
0x0000002457577220ULL, 0x080fe40000410000ULL, 0x000000245a5a7220ULL, 0x080fe40000410000ULL,
0x000000245b5b7220ULL, 0x000fc40000410000ULL, 0x000000245e5e7220ULL, 0x080fe40000410000ULL,
0x000000245f5f7220ULL, 0x080fe40000410000ULL, 0x0000002462627220ULL, 0x080fe40000410000ULL,
0x0000002463637220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006e1fff7212ULL, 0x000fe400078030ffULL, 0x0000001722217209ULL, 0x000fd60007810000ULL,
0x8000002122220221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL,
0x0000002200110308ULL, 0x000e640000000800ULL, 0x000000116c6c0220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000236c237221ULL, 0x000fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000011ff0d723eULL, 0x000fe400000000ffULL, 0x00000002ff227819ULL, 0x000fe4000001161cULL,
0x000054100d0d7816ULL, 0x000fe2000000000dULL, 0x000145d27f007947ULL, 0x000fea000b800000ULL,
0x00001f220d107589ULL, 0x0002a400000e0000ULL, 0x0000000822247810ULL, 0x000fe20007ffe0ffULL,
0x000146227f007947ULL, 0x000fea000b800000ULL, 0x00000010220e7810ULL, 0x000fe20007ffe0ffULL,
0x00001f240d0f7589ULL, 0x00066a00000e0000ULL, 0x00001f0e0d0e7589ULL, 0x0006a400000e0000ULL,
0x0000001822247810ULL, 0x008fe20007ffe0ffULL, 0x000146b27f007947ULL, 0x000fea000b800000ULL,
0x00001f240d0d7589ULL, 0x0022e400000e0000ULL, 0x000004001e177824ULL, 0x040fe200078e00ffULL,
0x0000000d1e1f7819ULL, 0x000fe200000006ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000016000007945ULL, 0x000fe40003800000ULL, 0xfffff00017177812ULL, 0x000fc400078ec0ffULL,
0xffffc0001f257812ULL, 0x000fe400078ec0ffULL, 0x0001300017177810ULL, 0x000fc60007ffe0ffULL,
0x0000200014227824ULL, 0x000fe400078e0225ULL, 0x000000100c7c7824ULL, 0x100fe400078e0217ULL,
0x000000100b177824ULL, 0x000fe200078e0217ULL, 0x0001700022227810ULL, 0x000fc60007ffe0ffULL,
0x000000007c7c783bULL, 0x000e640000000200ULL, 0x0000001009787824ULL, 0x100fe400078e0222ULL,
0x000000001724783bULL, 0x0022e20000000200ULL, 0x000000100a747824ULL, 0x100fe400078e0222ULL,
0x0000001008707824ULL, 0x000fe200078e0222ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x000000107c7c7232ULL, 0x084fe40000000000ULL, 0x000000107e7e7232ULL, 0x000fc40000000000ULL,
0x0000000f7d7d7232ULL, 0x080fe40000000000ULL, 0x0000000f7f7f7232ULL, 0x000fe40000000000ULL,
0x0000000e24247232ULL, 0x088fe40000000000ULL, 0x0000000e26267232ULL, 0x000fe40000000000ULL,
0x0000000d25257232ULL, 0x080fe40000000000ULL, 0x0000000d27277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010076c7824ULL, 0x000fe200078e0222ULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x00000002ff227819ULL, 0x100fe2000001161eULL,
0x0000028000007945ULL, 0x000fe20003800000ULL, 0x00000001ff177819ULL, 0x002fe2000001161eULL,
0x000000007474783bULL, 0x000e620000004200ULL, 0x00013000226a7811ULL, 0x000fc400078e60ffULL,
0x00000014176b7211ULL, 0x000fe200078e08ffULL, 0x000000007070783bULL, 0x000ee60000004200ULL,
0x000170006b6b7811ULL, 0x000fe200078e68ffULL, 0x000000006c6c783bULL, 0x000ea20000004200ULL,
0x000000787c64723cULL, 0x050f700000001864ULL, 0x0000007a7c28723cULL, 0x040f700000001828ULL,
0x000000747c2c723cULL, 0x042f70000000182cULL, 0x000000767c30723cULL, 0x040f700000001830ULL,
0x000000707c34723cULL, 0x048f700000001834ULL, 0x000000727c38723cULL, 0x040f700000001838ULL,
0x0000006c7c3c723cULL, 0x044f70000000183cULL, 0x0000006e7c40723cULL, 0x000b6e0000001840ULL,
0x00000010067c7824ULL, 0x120fe200078e026aULL, 0x000000782444723cULL, 0x040b6a0000001844ULL,
0x000000007c7c783bULL, 0x000e640000000200ULL, 0x0000001004787824ULL, 0x120fe200078e026bULL,
0x0000007a2448723cULL, 0x040f700000001848ULL, 0x00000074244c723cULL, 0x040b6e000000184cULL,
0x0000001003747824ULL, 0x120fe200078e026bULL, 0x000000762450723cULL, 0x040f700000001850ULL,
0x000000702454723cULL, 0x040b6e0000001854ULL, 0x0000001002707824ULL, 0x020fe200078e026bULL,
0x000000722458723cULL, 0x040f700000001858ULL, 0x0000006c245c723cULL, 0x040f70000000185cULL,
0x0000006e2460723cULL, 0x000b6e0000001860ULL, 0x0000001005247824ULL, 0x020fcc00078e026aULL,
0x000000002424783bULL, 0x000ea20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x000000107c7c7232ULL, 0x082fe40000000000ULL, 0x000000107e7e7232ULL, 0x000fe40000000000ULL,
0x0000000f7d7d7232ULL, 0x080fe40000000000ULL, 0x0000000f7f7f7232ULL, 0x000fe40000000000ULL,
0x0000000e24247232ULL, 0x084fe40000000000ULL, 0x0000000e26267232ULL, 0x000fc40000000000ULL,
0x0000000d25257232ULL, 0x080fe40000000000ULL, 0x0000000d27277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x002fea0003800000ULL, 0x00000010006c7824ULL, 0x000fe200078e026bULL,
0x000000007878783bULL, 0x000e680000004200ULL, 0x000000007474783bULL, 0x000ee80000004200ULL,
0x000000007070783bULL, 0x000f280000004200ULL, 0x000000006c6c783bULL, 0x000ea20000004200ULL,
0x000000787c64723cULL, 0x042f700000001864ULL, 0x0000007a7c28723cULL, 0x040f700000001828ULL,
0x000000747c2c723cULL, 0x048f70000000182cULL, 0x000000767c30723cULL, 0x040f700000001830ULL,
0x000000707c34723cULL, 0x050f700000001834ULL, 0x000000727c38723cULL, 0x040f700000001838ULL,
0x0000006c7c3c723cULL, 0x044f70000000183cULL, 0x0000006e7c40723cULL, 0x000f700000001840ULL,
0x000000782444723cULL, 0x040f700000001844ULL, 0x0000007a2448723cULL, 0x040f700000001848ULL,
0x00000074244c723cULL, 0x040f70000000184cULL, 0x000000762450723cULL, 0x040f700000001850ULL,
0x000000702454723cULL, 0x040f700000001854ULL, 0x000000722458723cULL, 0x040f700000001858ULL,
0x0000006c245c723cULL, 0x040f70000000185cULL, 0x0000006e2460723cULL, 0x000b6e0000001860ULL,
0x000000081d257824ULL, 0x020fe200078e0217ULL, 0x0001e69022247811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fcc0000008000ULL, 0x000000011d6a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000024ff7f8cULL, 0x0003e2000c80043fULL, 0x000000c025257811ULL, 0x000fc400078e28ffULL,
0x000000196a00720cULL, 0x000fe40003f06070ULL, 0x0000006025267812ULL, 0x000fca00078ec0ffULL,
0x0000000115777824ULL, 0x000fe200078e0226ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000003ff747819ULL, 0x102fe2000001161cULL,
0x000000801e277824ULL, 0x000fe200078e00ffULL, 0x000000251b247217ULL, 0x000fe40007800000ULL,
0x0000000474267810ULL, 0x040fe40007ffe0ffULL, 0x0000000c74727810ULL, 0x000fe40007ffe0ffULL,
0x0000002425257210ULL, 0x000fe20007ffe1ffULL, 0x0000000126247824ULL, 0x100fe200078e021cULL,
0x00000008746c7810ULL, 0x000fe20007ffe0ffULL, 0x00000008267b7824ULL, 0x000fe200078e00ffULL,
0x0000002025757817ULL, 0x000fe20003800000ULL, 0x00000001726b7824ULL, 0x000fe200078e021cULL,
0x0000001074787810ULL, 0x000fe20007ffe0ffULL, 0x00000008726e7824ULL, 0x000fe200078e00ffULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee224ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x0000008012247812ULL, 0x000fe200078ef827ULL, 0x0000000174277824ULL, 0x000fe200078e0277ULL,
0xfffffff86e7f7812ULL, 0x000fe200078ee26bULL, 0x000000016c6a7824ULL, 0x100fe200078e021cULL,
0x00000077266b7210ULL, 0x000fe20007ffe0ffULL, 0x000000086c7d7824ULL, 0x000fe200078e00ffULL,
0x00000014747a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001786d7824ULL, 0x000fe200078e021cULL,
0x000000752600720cULL, 0x000fe20003f86070ULL, 0x0000010027267825ULL, 0x000fe200078e0024ULL,
0xfffffff87d7d7812ULL, 0x000fc400078ee26aULL, 0x000000757200720cULL, 0x080fe20003f46070ULL,
0x0000000878707824ULL, 0x000fe200078e00ffULL, 0x00000026686e7210ULL, 0x000fe20007f1e0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0024ULL, 0x000020001f267812ULL, 0x000fe400078ec0ffULL,
0xfffffff870877812ULL, 0x000fe200078ee26dULL, 0x000000017a6f7824ULL, 0x100fe200078e021cULL,
0x0000006a68707210ULL, 0x000fe20007f3e0ffULL, 0x000000087a767824ULL, 0x000fe200078e00ffULL,
0x000000756c00720cULL, 0x080fe20003f66070ULL, 0x00000001741f7824ULL, 0x040fe200078e021cULL,
0x000000757400720cULL, 0x000fe20003fa6070ULL, 0x0000000169717824ULL, 0x040fe200008e066bULL,
0xfffffff876897812ULL, 0x000fe200078ee26fULL, 0x00000001696f7824ULL, 0x000fe200000e0627ULL,
0x0000002617767211ULL, 0x000fe200078e70ffULL, 0x000000016c277824ULL, 0x100fe200078e0277ULL,
0x000000071f1f7812ULL, 0x000fe200078ec0ffULL, 0x00000001726b7824ULL, 0x000fe200078e0277ULL,
0x0001700076767810ULL, 0x000fe20007ffe0ffULL, 0x0000010027267825ULL, 0x000fe200078e0024ULL,
0x0ffffff81f1f7812ULL, 0x000fc400078ef81cULL, 0x000000757800720cULL, 0x080fe20003f26070ULL,
0x000001006b6a7825ULL, 0x000fe200078e0024ULL, 0x0000002668727210ULL, 0x000fe40007f1e0ffULL,
0x000000767b7b7211ULL, 0x000fe200078e20ffULL, 0x00000001786d7824ULL, 0x000fe200078e0277ULL,
0x0000006a686a7210ULL, 0x000fe20007fde0ffULL, 0x0000000169737824ULL, 0x000fe200000e0627ULL,
0x0000001874787810ULL, 0x000fe20007ffe0ffULL, 0x000001006d6c7825ULL, 0x000fe200078e0024ULL,
0x000000757a00720cULL, 0x000fc40003f06070ULL, 0x000000767d7d7211ULL, 0x000fe200078e20ffULL,
0x000000017a277824ULL, 0x000fe200078e0277ULL, 0x0000001c747a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001696b7824ULL, 0x000fe200030e066bULL, 0x0000006c686c7210ULL, 0x000fe20007fde0ffULL,
0x0000010027267825ULL, 0x000fc800078e0024ULL, 0x000000101f797824ULL, 0x000fe400078e0276ULL,
0x00000001696d7824ULL, 0x040fe200030e066dULL, 0x0000002668747210ULL, 0x000fe20007fde0ffULL,
0x00000001781f7824ULL, 0x140fe200078e0277ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e797faeULL, 0x0003e2000e901c48ULL, 0x000000757800720cULL, 0x080fe20003fa6070ULL,
0x000000017a777824ULL, 0x040fe400078e0277ULL, 0x00000000707b7faeULL, 0x0005e2000e101c48ULL,
0x000000757a00720cULL, 0x000fe20003f86070ULL, 0x0000000169757824ULL, 0x000fc400030e0627ULL,
0x000001001f267825ULL, 0x000fe200078e0024ULL, 0x00000000727d7faeULL, 0x0005e6000d901c48ULL,
0x00000001781f7824ULL, 0x100fe200078e021cULL, 0x0000002668267210ULL, 0x000fe20007fde0ffULL,
0x0000000878787824ULL, 0x000fe400078e00ffULL, 0x000000017a6e7824ULL, 0x042fe400078e021cULL,
0x000000087a6f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8781f7812ULL, 0x000fe200078ee21fULL,
0x0000010077247825ULL, 0x000fc600078e0024ULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee26eULL,
0x0000000169277824ULL, 0x000fe200030e0627ULL, 0x0000002468247210ULL, 0x000fe20007fde0ffULL,
0x000000107f7f7824ULL, 0x100fe400078e0276ULL, 0x0000001087877824ULL, 0x100fe400078e0276ULL,
0x0000001089897824ULL, 0x100fe200078e0276ULL, 0x000000006a7f7faeULL, 0x0005e2000d101c48ULL,
0x000000101f1f7824ULL, 0x100fe400078e0276ULL, 0x000000106f6f7824ULL, 0x000fe200078e0276ULL,
0x000000006c877faeULL, 0x0005e2000c901c48ULL, 0x0000000169257824ULL, 0x000fc600030e0625ULL,
0x0000000074897faeULL, 0x0005e8000c101c48ULL, 0x00000000261f7faeULL, 0x0005e8000e901c48ULL,
0x00000000246f7faeULL, 0x0005e2000e101c48ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x000000081c6b7811ULL, 0x002fe200078fe8ffULL, 0x000000801e757824ULL, 0x000fe200078e00ffULL,
0x000000041c277811ULL, 0x000fc400078fe8ffULL, 0x0000001c6b257210ULL, 0x0c0fe20007ffe0ffULL,
0x000000086b267824ULL, 0x000fe200078e00ffULL, 0x000000101c6f7811ULL, 0x040fe200078fe8ffULL,
0x0000000127247824ULL, 0x140fe200078e021cULL, 0x0000000c1c6d7811ULL, 0x000fe200078fe8ffULL,
0x00000008277b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8267d7812ULL, 0x000fe200078ee225ULL,
0x000000016f257824ULL, 0x040fe200078e021cULL, 0x000000141c717811ULL, 0x040fe200078fe8ffULL,
0x000000086f6c7824ULL, 0x000fe200078e00ffULL, 0xfffffff87b7b7812ULL, 0x000fe200078ee224ULL,
0x000000016d247824ULL, 0x140fe200078e021cULL, 0x000000181c737811ULL, 0x000fe200078fe8ffULL,
0x000000086d7f7824ULL, 0x000fe200078e00ffULL, 0xfffffff86c877812ULL, 0x000fe200078ee225ULL,
0x0000000171267824ULL, 0x040fe200078e021cULL, 0x0000001c1c257811ULL, 0x040fe200078fe8ffULL,
0x0000000871897824ULL, 0x000fe200078e00ffULL, 0xfffffff87f7f7812ULL, 0x000fe200078ee224ULL,
0x00000001736a7824ULL, 0x000fe200078e021cULL, 0x000020001f247812ULL, 0x000fe200078ec0ffULL,
0x0000000127277824ULL, 0x100fe200078e0277ULL, 0x0000001c1c1f7211ULL, 0x000fe200078fe8ffULL,
0x000000016b6b7824ULL, 0x000fe200078e0277ULL, 0xfffffff889897812ULL, 0x000fe200078ee226ULL,
0x0000000125267824ULL, 0x000fe200078e021cULL, 0x0000008012747812ULL, 0x000fe200078ef875ULL,
0x0000400017247824ULL, 0x000fe200078e0224ULL, 0x0000000325757819ULL, 0x000fe200000006ffULL,
0x000000016d6d7824ULL, 0x100fe200078e0277ULL, 0x000000071f797812ULL, 0x000fe200078ec0ffULL,
0x00000001251f7824ULL, 0x100fe200078e0277ULL, 0x00000003738b7819ULL, 0x000fe200000006ffULL,
0x000000016f6f7824ULL, 0x100fe200078e0277ULL, 0x000000771c257211ULL, 0x000fe200078fe8ffULL,
0x0000000171717824ULL, 0x100fe200078e0277ULL, 0x0001700024767810ULL, 0x000fe20007ffe0ffULL,
0x0000000173737824ULL, 0x000fe200078e0277ULL, 0xfffffff875777812ULL, 0x000fe200078ee226ULL,
0x000000ffff757224ULL, 0x000fe200078e00ffULL, 0xfffffff88b8b7812ULL, 0x000fe200078ee26aULL,
0x000000107b7b7824ULL, 0x000fe200078e0276ULL, 0x0ffffff879797812ULL, 0x000fe200078ef81cULL,
0x0000010025247825ULL, 0x000fe200078e0074ULL, 0x0000007689897211ULL, 0x000fc600078e20ffULL,
0x0000010027267825ULL, 0x000fe200078e0074ULL, 0x0000002468247210ULL, 0x000fc60007f1e0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0074ULL, 0x0000002668267210ULL, 0x000fc60007f3e0ffULL,
0x000001006d6c7825ULL, 0x000fe200078e0074ULL, 0x0000006a686a7210ULL, 0x000fc60007f5e0ffULL,
0x000001006f6e7825ULL, 0x000fe200078e0074ULL, 0x0000006c686c7210ULL, 0x000fc60007f7e0ffULL,
0x0000010071707825ULL, 0x000fc800078e0074ULL, 0x0000010073727825ULL, 0x000fc800078e0074ULL,
0x000001001f747825ULL, 0x000fc800078e0074ULL, 0x0000000169257824ULL, 0x040fe200000e0625ULL,
0x0000006e686e7210ULL, 0x040fe20007f1e0ffULL, 0x0000000169277824ULL, 0x000fe200008e0627ULL,
0x0000007068707210ULL, 0x040fe20007f3e0ffULL, 0x0000001079797824ULL, 0x100fe400078e0276ULL,
0x00000001696b7824ULL, 0x040fe200010e066bULL, 0x0000007268727210ULL, 0x040fe20007f5e0ffULL,
0x00000001696d7824ULL, 0x000fe200018e066dULL, 0x0000007468687210ULL, 0x000fe20007f7e0ffULL,
0x000000107d7d7824ULL, 0x100fe200078e0276ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024797faeULL, 0x0003e2000b901c48ULL, 0x000000107f7f7824ULL, 0x100fe200078e0276ULL,
0x0000007369737210ULL, 0x000fe200017fe4ffULL, 0x0000001087877824ULL, 0x000fe200078e0276ULL,
0x00000000267b7faeULL, 0x0003e2000b901c48ULL, 0x00000001696f7824ULL, 0x000fc400000e066fULL,
0x0000000169717824ULL, 0x000fe200008e0671ULL, 0x000000006a7d7faeULL, 0x0003e2000b901c48ULL,
0x000000108b8b7824ULL, 0x100fe400078e0276ULL, 0x0000001077777824ULL, 0x000fe200078e0276ULL,
0x000000006c7f7faeULL, 0x0003e2000b901c48ULL, 0x0000000169697824ULL, 0x000fc600018e0675ULL,
0x000000006e877faeULL, 0x0003e8000b901c48ULL, 0x0000000070897faeULL, 0x0003e8000b901c48ULL,
0x00000000728b7faeULL, 0x0003e8000b901c48ULL, 0x0000000068777faeULL, 0x0003e4000b901c48ULL,
0x00000300ff1f7624ULL, 0x004fe200078e00ffULL, 0x0000000120247812ULL, 0x002fe200078ec0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000012400780cULL, 0x000fc40003f05070ULL,
0xffffffff1f1f7811ULL, 0x000fc800078e08ffULL, 0x000000011f1f7807ULL, 0x000fca0004000000ULL,
0x0000000120207824ULL, 0x000fe400078e021fULL, 0xffffffffff1f7424ULL, 0x000fc600078e00ffULL,
0x0000001a2000720cULL, 0x000fda0003f06070ULL, 0x0000000120248824ULL, 0x000fe400078e0213ULL,
0x00000004ff258424ULL, 0x000fc800078e00ffULL, 0x0000640024248625ULL, 0x000fca00078e0025ULL,
0x00000008241f8981ULL, 0x000322000c1e1900ULL, 0x0000001018277812ULL, 0x000fca00078ec0ffULL,
0x0000002022227824ULL, 0x000fe200078e0227ULL, 0x0000000818277812ULL, 0x000fca00078ec0ffULL,
0x0000000127227824ULL, 0x000fe200078e0222ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e6480022687f8cULL, 0x0022a4000c80043fULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x01e64c0022277984ULL, 0x000ee40000000800ULL, 0x8000000027ff7812ULL, 0x00cfe40007804869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ff006a7202ULL, 0x000fe20000000f00ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x00000026246b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09006b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000006b26267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e64c0022277984ULL, 0x000ea40000000800ULL,
0x8000000027ff7812ULL, 0x004fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201e227824ULL, 0x002fca00078e00ffULL, 0xffffff8022257812ULL, 0x000fc800078ec0ffULL,
0x0000010012257810ULL, 0x000fca0007ffe025ULL, 0x0000000180257824ULL, 0x000fca00078e0225ULL,
0x01e0000025227984ULL, 0x000e680000000800ULL, 0x01e2000025687984ULL, 0x0004e20000000800ULL,
0x000000212200720bULL, 0x002fe20003f1d000ULL, 0x000130827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000697806ULL, 0x004fc800000e0100ULL, 0x000000ff6900720cULL, 0x000fe20003f25270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x000000021e257811ULL, 0x000fe400078ff0ffULL,
0x000000212200720bULL, 0x000fe40003f34000ULL, 0x0000001e2500720cULL, 0x000fe20003f05270ULL,
0x000130527f007947ULL, 0x000fd4000b800000ULL, 0x00000000006c7806ULL, 0x000fc400008e0100ULL,
0x000000121e258211ULL, 0x000fe200078e38ffULL, 0x0000065000017945ULL, 0x000fe20003800000ULL,
0x0000002122248209ULL, 0x000fc60007810000ULL, 0x0000000180258824ULL, 0x000fca00078e0225ULL,
0x01e4002425008388ULL, 0x0003e20000000800ULL, 0x000000ff6c00720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000002122247209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff6cff7812ULL, 0x000fc6000780c0ffULL,
0x0000002124247221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b24247820ULL, 0x000fc80000410000ULL,
0x00000024006e7308ULL, 0x000e640000000800ULL, 0x0000006e23237220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff247819ULL, 0x000fe2000001161cULL,
0x00012f927f007947ULL, 0x000fea000b800000ULL, 0x00001f246e247589ULL, 0x0002a400000e0000ULL,
0x0000002464647220ULL, 0x084fe40000410000ULL, 0x0000002465657220ULL, 0x080fe40000410000ULL,
0x0000002428287220ULL, 0x080fe40000410000ULL, 0x0000002429297220ULL, 0x000fc40000410000ULL,
0x000000242c2c7220ULL, 0x080fe40000410000ULL, 0x000000242d2d7220ULL, 0x080fe40000410000ULL,
0x0000002430307220ULL, 0x080fe40000410000ULL, 0x0000002431317220ULL, 0x080fe40000410000ULL,
0x0000002434347220ULL, 0x080fe40000410000ULL, 0x0000002435357220ULL, 0x000fc40000410000ULL,
0x0000002438387220ULL, 0x080fe40000410000ULL, 0x0000002439397220ULL, 0x080fe40000410000ULL,
0x000000243c3c7220ULL, 0x080fe40000410000ULL, 0x000000243d3d7220ULL, 0x080fe40000410000ULL,
0x0000002440407220ULL, 0x080fe40000410000ULL, 0x0000002441417220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff006cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000081c247811ULL, 0x000fe200078ff0ffULL, 0x00012e827f007947ULL, 0x000fea000b800000ULL,
0x00001f246e247589ULL, 0x00046400000e0000ULL, 0x0000002466667220ULL, 0x086fe40000410000ULL,
0x0000002467677220ULL, 0x080fe40000410000ULL, 0x000000242a2a7220ULL, 0x080fe40000410000ULL,
0x000000242b2b7220ULL, 0x080fe40000410000ULL, 0x000000242e2e7220ULL, 0x080fe40000410000ULL,
0x000000242f2f7220ULL, 0x000fc40000410000ULL, 0x0000002432327220ULL, 0x080fe40000410000ULL,
0x0000002433337220ULL, 0x080fe40000410000ULL, 0x0000002436367220ULL, 0x080fe40000410000ULL,
0x0000002437377220ULL, 0x080fe40000410000ULL, 0x000000243a3a7220ULL, 0x080fe40000410000ULL,
0x000000243b3b7220ULL, 0x000fc40000410000ULL, 0x000000243e3e7220ULL, 0x080fe40000410000ULL,
0x000000243f3f7220ULL, 0x080fe40000410000ULL, 0x0000002442427220ULL, 0x080fe40000410000ULL,
0x0000002443437220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00006cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000101c247811ULL, 0x000fe200078ff0ffULL,
0x00012d727f007947ULL, 0x000fea000b800000ULL, 0x00001f246e247589ULL, 0x00046400000e0000ULL,
0x0000002444447220ULL, 0x086fe40000410000ULL, 0x0000002445457220ULL, 0x080fe40000410000ULL,
0x0000002448487220ULL, 0x080fe40000410000ULL, 0x0000002449497220ULL, 0x080fe40000410000ULL,
0x000000244c4c7220ULL, 0x080fe40000410000ULL, 0x000000244d4d7220ULL, 0x000fc40000410000ULL,
0x0000002450507220ULL, 0x080fe40000410000ULL, 0x0000002451517220ULL, 0x080fe40000410000ULL,
0x0000002454547220ULL, 0x080fe40000410000ULL, 0x0000002455557220ULL, 0x080fe40000410000ULL,
0x0000002458587220ULL, 0x080fe40000410000ULL, 0x0000002459597220ULL, 0x000fc40000410000ULL,
0x000000245c5c7220ULL, 0x080fe40000410000ULL, 0x000000245d5d7220ULL, 0x080fe40000410000ULL,
0x0000002460607220ULL, 0x080fe40000410000ULL, 0x0000002461617220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000006cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000181c247811ULL, 0x000fe200078ff0ffULL,
0x00012c727f007947ULL, 0x000fea000b800000ULL, 0x00001f246e247589ULL, 0x00046400000e0000ULL,
0x0000002446467220ULL, 0x086fe40000410000ULL, 0x0000002447477220ULL, 0x080fe40000410000ULL,
0x000000244a4a7220ULL, 0x080fe40000410000ULL, 0x000000244b4b7220ULL, 0x080fe40000410000ULL,
0x000000244e4e7220ULL, 0x080fe40000410000ULL, 0x000000244f4f7220ULL, 0x000fc40000410000ULL,
0x0000002452527220ULL, 0x080fe40000410000ULL, 0x0000002453537220ULL, 0x080fe40000410000ULL,
0x0000002456567220ULL, 0x080fe40000410000ULL, 0x0000002457577220ULL, 0x080fe40000410000ULL,
0x000000245a5a7220ULL, 0x080fe40000410000ULL, 0x000000245b5b7220ULL, 0x000fc40000410000ULL,
0x000000245e5e7220ULL, 0x080fe40000410000ULL, 0x000000245f5f7220ULL, 0x080fe40000410000ULL,
0x0000002462627220ULL, 0x080fe40000410000ULL, 0x0000002463637220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000006c69ff7212ULL, 0x000fe400078030ffULL,
0x0000002122217209ULL, 0x000fd60007810000ULL, 0x8000002122220221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b22220820ULL, 0x000fc80000410000ULL, 0x0000002200110308ULL, 0x000e640000000800ULL,
0x0000001168680220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000002368237221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000011ff0d723eULL, 0x000fe400000000ffULL,
0x00000002ff227819ULL, 0x000fe4000001161cULL, 0x000054100d0d7816ULL, 0x000fe2000000000dULL,
0x00012ad27f007947ULL, 0x000fea000b800000ULL, 0x00001f220d107589ULL, 0x0002a400000e0000ULL,
0x0000000822247810ULL, 0x000fe20007ffe0ffULL, 0x00012b227f007947ULL, 0x000fea000b800000ULL,
0x00000010220e7810ULL, 0x000fe20007ffe0ffULL, 0x00001f240d0f7589ULL, 0x00066a00000e0000ULL,
0x00001f0e0d0e7589ULL, 0x0006a400000e0000ULL, 0x0000001822247810ULL, 0x008fe20007ffe0ffULL,
0x00012bb27f007947ULL, 0x000fea000b800000ULL, 0x00001f240d0d7589ULL, 0x0022e400000e0000ULL,
0x000004001e227824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000217257824ULL, 0x000fe200078e0214ULL, 0x0000015000007945ULL, 0x000fe40003800000ULL,
0xfffff00022247812ULL, 0x002fe200078ec0ffULL, 0x0000200025227824ULL, 0x000fc600078e00ffULL,
0x0001400024247810ULL, 0x000fe40007ffe0ffULL, 0x00016000227d7810ULL, 0x000fc60007ffe0ffULL,
0x000000100c687824ULL, 0x100fe200078e0224ULL, 0x0000007d096c7211ULL, 0x000fe200078e20ffULL,
0x000000100b247824ULL, 0x000fe400078e0224ULL, 0x000000100a707824ULL, 0x100fe400078e027dULL,
0x000000006868783bULL, 0x000e620000000200ULL, 0x0000001008747824ULL, 0x000fc600078e027dULL,
0x000000002424783bULL, 0x000ee20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000001068687232ULL, 0x086fe40000000000ULL, 0x000000106a6a7232ULL, 0x000fe40000000000ULL,
0x0000000f69697232ULL, 0x080fe40000000000ULL, 0x0000000f6b6b7232ULL, 0x000fe40000000000ULL,
0x0000000e24247232ULL, 0x088fe40000000000ULL, 0x0000000e26267232ULL, 0x000fc40000000000ULL,
0x0000000d25257232ULL, 0x080fe40000000000ULL, 0x0000000d27277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001007787824ULL, 0x100fe200078e027dULL,
0x000000006c6c783bULL, 0x000ee20000004200ULL, 0x00000002ff7c7819ULL, 0x000fe2000001161eULL,
0x0000025000007945ULL, 0x000fe40003800000ULL, 0x000000007070783bULL, 0x000ea80000004200ULL,
0x000000007474783bULL, 0x000e680000004200ULL, 0x000000007878783bULL, 0x000e640000004200ULL,
0x0000006c6864723cULL, 0x04af700000001864ULL, 0x0000006e6828723cULL, 0x040f700000001828ULL,
0x00000070682c723cULL, 0x044f70000000182cULL, 0x000000726830723cULL, 0x040f700000001830ULL,
0x000000746834723cULL, 0x040f700000001834ULL, 0x000000766838723cULL, 0x040f700000001838ULL,
0x00000078683c723cULL, 0x040f70000000183cULL, 0x0000007a6840723cULL, 0x000b6e0000001840ULL,
0x000140007c687811ULL, 0x020fe200078e60ffULL, 0x00000078245c723cULL, 0x040f70000000185cULL,
0x0000006c2444723cULL, 0x040b6e0000001844ULL, 0x00000010036c7824ULL, 0x120fe200078e027dULL,
0x0000006e2448723cULL, 0x040f700000001848ULL, 0x00000070244c723cULL, 0x040b6e000000184cULL,
0x0000001002707824ULL, 0x020fe200078e027dULL, 0x000000722450723cULL, 0x040f700000001850ULL,
0x000000742454723cULL, 0x040f700000001854ULL, 0x000000762458723cULL, 0x040f700000001858ULL,
0x0000007a2478723cULL, 0x000b6e0000001860ULL, 0x0000001006607824ULL, 0x020fc400078e0268ULL,
0x0000001005247824ULL, 0x000fe400078e0268ULL, 0x0000001004687824ULL, 0x000fe400078e027dULL,
0x000000006060783bULL, 0x000e680000000200ULL, 0x000000002424783bULL, 0x000ea20000000200ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000001060607232ULL, 0x082fe40000000000ULL,
0x0000001062627232ULL, 0x000fc40000000000ULL, 0x0000000f61617232ULL, 0x080fe40000000000ULL,
0x0000000f63637232ULL, 0x000fe40000000000ULL, 0x0000000e24247232ULL, 0x084fe40000000000ULL,
0x0000000e26267232ULL, 0x000fe40000000000ULL, 0x0000000d25257232ULL, 0x080fe40000000000ULL,
0x0000000d27277232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000007d00747211ULL, 0x000fe200078e20ffULL, 0x000000006868783bULL, 0x000ee80000004200ULL,
0x000000006c6c783bULL, 0x000ea80000004200ULL, 0x000000007070783bULL, 0x000e680000004200ULL,
0x000000007474783bULL, 0x000e640000004200ULL, 0x000000686064723cULL, 0x04af700000001864ULL,
0x0000006a6028723cULL, 0x040f700000001828ULL, 0x0000006c602c723cULL, 0x044f70000000182cULL,
0x0000006e6030723cULL, 0x040f700000001830ULL, 0x000000706034723cULL, 0x040f700000001834ULL,
0x000000726038723cULL, 0x040f700000001838ULL, 0x00000074603c723cULL, 0x040f70000000183cULL,
0x000000766040723cULL, 0x000f700000001840ULL, 0x000000682444723cULL, 0x040f700000001844ULL,
0x0000006a2448723cULL, 0x040f700000001848ULL, 0x0000006c244c723cULL, 0x040f70000000184cULL,
0x0000006e2450723cULL, 0x040f700000001850ULL, 0x000000702454723cULL, 0x040f700000001854ULL,
0x000000722458723cULL, 0x040f700000001858ULL, 0x00000074245c723cULL, 0x040f70000000185cULL,
0x000000762478723cULL, 0x000b6e0000001878ULL, 0x0001e6987c247811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fcc0000008000ULL, 0x000003001d1d7a10ULL, 0x000fe20007ffe0ffULL,
0x0000000024ff7f8cULL, 0x0003e6000c80043fULL, 0x000000191d00720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x00000c9000000947ULL, 0x000fea0003800000ULL,
0x000000011d267810ULL, 0x002fe20007ffe0ffULL, 0x000059001f247a24ULL, 0x010fe400078e02ffULL,
0x000001001d277824ULL, 0x000fe200078e0216ULL, 0x000000192600720cULL, 0x000fe20003f06070ULL,
0x0000008024257824ULL, 0x000fe400078e00ffULL, 0x00000100ff267424ULL, 0x000fe200078e00ffULL,
0x0000006027247812ULL, 0x000fca00078ec0ffULL, 0x0000000115757824ULL, 0x000fe400078e0224ULL,
0x0000620025247625ULL, 0x000fe400078e0026ULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff707819ULL, 0x100fe4000001161cULL, 0x000000271b267217ULL, 0x000fe40007800000ULL,
0x0000000470607810ULL, 0x040fe40007ffe0ffULL, 0x0000000870687810ULL, 0x000fe20007ffe0ffULL,
0x0000000126267824ULL, 0x000fe200078e0a27ULL, 0x0000000c706e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000160277824ULL, 0x100fe200078e021cULL, 0x00000003686c7819ULL, 0x000fe200000006ffULL,
0x00000008606a7824ULL, 0x000fe200078e00ffULL, 0x0000002026717817ULL, 0x000fe20003800000ULL,
0x0000000168617824ULL, 0x100fe200078e021cULL, 0x0000001470747810ULL, 0x000fe20007ffe0ffULL,
0x000000016e627824ULL, 0x000fe200078e021cULL, 0xfffffff86a7d7812ULL, 0x000fe200078ee227ULL,
0x000000801e277824ULL, 0x000fe200078e00ffULL, 0xfffffff86c7f7812ULL, 0x000fe200078ee261ULL,
0x0000000170617824ULL, 0x000fe200078e0275ULL, 0x000000716000720cULL, 0x000fe20003f86070ULL,
0x000000086e877824ULL, 0x000fe200078e00ffULL, 0x0000008012267812ULL, 0x000fe200078ef827ULL,
0x000000ffff277224ULL, 0x000fe200078e00ffULL, 0x0000001c746b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000160637824ULL, 0x000fe200078e0275ULL, 0xfffffff887877812ULL, 0x000fe200078ee262ULL,
0x0000010061607825ULL, 0x000fe200078e0026ULL, 0x0000001070727810ULL, 0x000fc40007ffe0ffULL,
0x000000716800720cULL, 0x080fe20003f66070ULL, 0x0000010063627825ULL, 0x000fe200078e0026ULL,
0x00000060246a7210ULL, 0x000fe40007f1e0ffULL, 0x000000716e00720cULL, 0x080fe20003f46070ULL,
0x00000008747e7824ULL, 0x000fe200078e00ffULL, 0x00000062246c7210ULL, 0x000fe20007f3e0ffULL,
0x000020001e607824ULL, 0x000fe200078e00ffULL, 0x000000717000720cULL, 0x040fe20003fa6070ULL,
0x0000000170627824ULL, 0x000fe200078e021cULL, 0xfffffff87e8b7812ULL, 0x000fe200078ee26bULL,
0x00000001256b7824ULL, 0x000fc400000e0661ULL, 0x0000000168617824ULL, 0x000fe200078e0275ULL,
0x0000200060687812ULL, 0x000fe200078ec0ffULL, 0x00000001256d7824ULL, 0x000fe200008e0663ULL,
0x0000000762737812ULL, 0x000fe200078ec0ffULL, 0x0000000172697824ULL, 0x140fe200078e021cULL,
0x000000717200720cULL, 0x040fe20003f26070ULL, 0x0000000872767824ULL, 0x000fe200078e00ffULL,
0x0ffffff873737812ULL, 0x000fe200078ef81cULL, 0x000000016e637824ULL, 0x000fe400078e0275ULL,
0x0000010061607825ULL, 0x000fe200078e0026ULL, 0xfffffff876897812ULL, 0x000fc400078ee269ULL,
0x0000001c70767810ULL, 0x000fe20007ffe0ffULL, 0x0000010063627825ULL, 0x000fe200078e0026ULL,
0x00000060246e7210ULL, 0x000fc60007f1e0ffULL, 0x0000000172697824ULL, 0x000fe200078e0275ULL,
0x0000006817727211ULL, 0x000fe200078e70ffULL, 0x00000001256f7824ULL, 0x000fe200000e0661ULL,
0x0000006224627210ULL, 0x000fe20007fde0ffULL, 0x0000010069687825ULL, 0x000fe200078e0026ULL,
0x0001600072727810ULL, 0x000fe40007ffe0ffULL, 0x000000717400720cULL, 0x040fe20003f06070ULL,
0x0000000174617824ULL, 0x000fe200078e0275ULL, 0x0000001870747810ULL, 0x000fe20007ffe0ffULL,
0x0000000125637824ULL, 0x000fe200030e0663ULL, 0x0000006824687210ULL, 0x000fe20007fde0ffULL,
0x0000010061607825ULL, 0x000fe200078e0026ULL, 0x000000728b8b7211ULL, 0x000fc600078e20ffULL,
0x0000001073777824ULL, 0x100fe400078e0272ULL, 0x000000107d7d7824ULL, 0x100fe400078e0272ULL,
0x0000000125697824ULL, 0x000fe200030e0669ULL, 0x0000006024707210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a777faeULL, 0x0003e2000e901c48ULL,
0x0000000174737824ULL, 0x040fe200078e0275ULL, 0x000000717400720cULL, 0x080fe20003fa6070ULL,
0x000000107f7f7824ULL, 0x000fe200078e0272ULL, 0x000000006c7d7faeULL, 0x0005e2000e101c48ULL,
0x000000717600720cULL, 0x040fe20003f86070ULL, 0x0000000125717824ULL, 0x000fe200030e0661ULL,
0x0000007576757210ULL, 0x000fe20007ffe0ffULL, 0x0000010073607825ULL, 0x000fe200078e0026ULL,
0x000000006e7f7faeULL, 0x0007e6000d901c48ULL, 0x00000001746a7824ULL, 0x002fe200078e021cULL,
0x0000006024607210ULL, 0x000fe20007fde0ffULL, 0x00000008746b7824ULL, 0x000fc400078e00ffULL,
0x00000001766c7824ULL, 0x044fe400078e021cULL, 0x00000008766d7824ULL, 0x000fe200078e00ffULL,
0xfffffff86b6b7812ULL, 0x000fe200078ee26aULL, 0x0000010075267825ULL, 0x000fc600078e0026ULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee26cULL, 0x0000000125617824ULL, 0x000fe200030e0661ULL,
0x0000002624247210ULL, 0x000fe20007fde0ffULL, 0x0000001087877824ULL, 0x100fe400078e0272ULL,
0x0000001089897824ULL, 0x100fe400078e0272ULL, 0x000000106b6b7824ULL, 0x100fe200078e0272ULL,
0x0000000062877faeULL, 0x0007e2000d101c48ULL, 0x000000106d6d7824ULL, 0x000fe400078e0272ULL,
0x0000000125257824ULL, 0x000fe200030e0627ULL, 0x0000000068897faeULL, 0x0007e8000c901c48ULL,
0x00000000708b7faeULL, 0x0007e8000c101c48ULL, 0x00000000606b7faeULL, 0x0007e8000e901c48ULL,
0x00000000246d7faeULL, 0x0007e2000e101c48ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x000000041c617811ULL, 0x000fe200078fe8ffULL, 0x000000801e717824ULL, 0x000fe200078e00ffULL,
0x000000081c637811ULL, 0x000fc400078fe8ffULL, 0x0000000c1c697811ULL, 0x040fe200078fe8ffULL,
0x0000000161267824ULL, 0x140fe200078e021cULL, 0x000000101c6b7811ULL, 0x040fe200078fe8ffULL,
0x00000008617d7824ULL, 0x000fe200078e00ffULL, 0x000000141c6d7811ULL, 0x040fe200078fe8ffULL,
0x0000000163277824ULL, 0x000fe200078e021cULL, 0x0000000369877819ULL, 0x000fe200000006ffULL,
0x0000000863607824ULL, 0x000fe200078e00ffULL, 0xfffffff87d7d7812ULL, 0x000fe200078ee226ULL,
0x0000000169267824ULL, 0x100fe200078e021cULL, 0x0000001c1c737811ULL, 0x000fe200078fe8ffULL,
0x000000086b687824ULL, 0x040fe200078e00ffULL, 0xfffffff8607f7812ULL, 0x000fe200078ee227ULL,
0x000000016b277824ULL, 0x000fe200078e021cULL, 0xfffffff887877812ULL, 0x000fe200078ee226ULL,
0x000000016d607824ULL, 0x140fe200078e021cULL, 0x000000181c6f7811ULL, 0x000fe200078fe8ffULL,
0x000000086d8b7824ULL, 0x000fe200078e00ffULL, 0xfffffff868897812ULL, 0x000fe200078ee227ULL,
0x000020001e267824ULL, 0x000fe200078e00ffULL, 0x0000001c1c277211ULL, 0x000fe200078fe8ffULL,
0x000000016f627824ULL, 0x000fe200078e021cULL, 0xfffffff88b8b7812ULL, 0x000fe200078ee260ULL,
0x0000000173607824ULL, 0x040fe200078e021cULL, 0x0000008012707812ULL, 0x000fe200078ef871ULL,
0x0000000873717824ULL, 0x000fe200078e00ffULL, 0x0000200026267812ULL, 0x000fe200078ec0ffULL,
0x000000086f8d7824ULL, 0x000fe200078e00ffULL, 0x0000000727777812ULL, 0x000fe200078ec0ffULL,
0x0000000163637824ULL, 0x100fe200078e0275ULL, 0x0000007561617210ULL, 0x080fe20007ffe0ffULL,
0x0000000169697824ULL, 0x100fe200078e0275ULL, 0x000000751c277211ULL, 0x000fe200078fe8ffULL,
0x000000016b6b7824ULL, 0x100fe200078e0275ULL, 0x0000002617267211ULL, 0x000fe200078e70ffULL,
0x000000016d6d7824ULL, 0x100fe200078e0275ULL, 0xfffffff88d8d7812ULL, 0x000fe200078ee262ULL,
0x000000016f6f7824ULL, 0x100fe200078e0275ULL, 0x0001600026727810ULL, 0x000fe20007ffe0ffULL,
0x0000000173737824ULL, 0x000fe200078e0275ULL, 0xfffffff871757812ULL, 0x000fe200078ee260ULL,
0x000000ffff717224ULL, 0x000fe200078e00ffULL, 0x0ffffff877777812ULL, 0x000fe200078ef81cULL,
0x000000107d7d7824ULL, 0x000fe200078e0272ULL, 0x0000007275757211ULL, 0x000fe200078e20ffULL,
0x0000010027267825ULL, 0x000fc800078e0070ULL, 0x0000010061607825ULL, 0x000fe200078e0070ULL,
0x0000002624267210ULL, 0x000fc60007f1e0ffULL, 0x0000010063627825ULL, 0x000fe200078e0070ULL,
0x0000006024607210ULL, 0x000fc60007f3e0ffULL, 0x0000010069687825ULL, 0x000fe200078e0070ULL,
0x0000006224627210ULL, 0x000fc60007f5e0ffULL, 0x000001006b6a7825ULL, 0x000fe200078e0070ULL,
0x0000006824687210ULL, 0x000fc60007f7e0ffULL, 0x000001006d6c7825ULL, 0x000fc800078e0070ULL,
0x000001006f6e7825ULL, 0x000fc800078e0070ULL, 0x0000010073707825ULL, 0x000fc800078e0070ULL,
0x0000000125277824ULL, 0x040fe200000e0627ULL, 0x0000006a246a7210ULL, 0x040fe20007f1e0ffULL,
0x0000000125617824ULL, 0x000fe200008e0661ULL, 0x0000006c246c7210ULL, 0x040fe20007f3e0ffULL,
0x0000001077777824ULL, 0x100fe400078e0272ULL, 0x0000000125637824ULL, 0x040fe200010e0663ULL,
0x0000006e246e7210ULL, 0x040fe20007f5e0ffULL, 0x0000000125697824ULL, 0x000fe200018e0669ULL,
0x0000007024247210ULL, 0x000fe20007f7e0ffULL, 0x000000107f7f7824ULL, 0x100fe200078e0272ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026777faeULL, 0x0003e2000b901c48ULL,
0x0000001087877824ULL, 0x000fc400078e0272ULL, 0x0000001089897824ULL, 0x100fe200078e0272ULL,
0x00000000607d7faeULL, 0x0003e2000b901c48ULL, 0x00000001256b7824ULL, 0x000fe400000e066bULL,
0x000000108b8b7824ULL, 0x100fe200078e0272ULL, 0x00000000627f7faeULL, 0x0003e2000b901c48ULL,
0x00000001256d7824ULL, 0x000fe400008e066dULL, 0x000000108d8d7824ULL, 0x000fe200078e0272ULL,
0x0000000068877faeULL, 0x0003e2000b901c48ULL, 0x00000001256f7824ULL, 0x000fc400010e066fULL,
0x0000000125257824ULL, 0x000fe200018e0671ULL, 0x000000006a897faeULL, 0x0003e8000b901c48ULL,
0x000000006c8b7faeULL, 0x0003e8000b901c48ULL, 0x000000006e8d7faeULL, 0x0003e8000b901c48ULL,
0x0000000024757faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x0000001018257812ULL, 0x008fc400078ec0ffULL, 0x0000000818247812ULL, 0x000fe400078ec0ffULL,
0x000000257c257211ULL, 0x000fca00078e28ffULL, 0x0000000124627824ULL, 0x000fe200078e0225ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e6680062607f8cULL, 0x0002a4000c80043fULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x01e66c0062277984ULL, 0x000ee40000000800ULL,
0x8000000027ff7812ULL, 0x00cfe40007804861ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff687224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002624637210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09006300780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406300780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000006326267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000168687810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e66c0062277984ULL, 0x000ea40000000800ULL, 0x8000000027ff7812ULL, 0x004fe40007804861ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000031e257811ULL, 0x000fca00078ff0ffULL,
0x0000008025257824ULL, 0x000fc800078e0212ULL, 0x0000000180257824ULL, 0x000fca00078e0225ULL,
0x01e0000025607984ULL, 0x000ea80000000800ULL, 0x01e2000025627984ULL, 0x0022e20000000800ULL,
0x000000216000720bULL, 0x004fe20003f1d000ULL, 0x000116127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000617806ULL, 0x002fc800000e0100ULL, 0x000000ff6100720cULL, 0x000fe20003f25270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x000000031e257811ULL, 0x000fe400078ff0ffULL,
0x000000216000720bULL, 0x000fe40003f34000ULL, 0x0000001e2500720cULL, 0x000fe20003f05270ULL,
0x000115e27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000687806ULL, 0x000fc400008e0100ULL,
0x000000801e258824ULL, 0x000fe200078e0212ULL, 0x0000002160128209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x0000000180258824ULL, 0x000fca00078e0225ULL,
0x01e4001225008388ULL, 0x0003e20000000800ULL, 0x000000ff6800720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000002160127209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff68ff7812ULL, 0x000fc6000780c0ffULL,
0x0000002112127221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b12127820ULL, 0x000fcc0000410000ULL,
0x0000001200127308ULL, 0x000e640000000800ULL, 0x0000001223237220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff247819ULL, 0x000fe2000001161cULL,
0x000115227f007947ULL, 0x000fea000b800000ULL, 0x00001f2412247589ULL, 0x0002a400000e0000ULL,
0x0000002464647220ULL, 0x084fe40000410000ULL, 0x0000002465657220ULL, 0x080fe40000410000ULL,
0x0000002428287220ULL, 0x080fe40000410000ULL, 0x0000002429297220ULL, 0x000fc40000410000ULL,
0x000000242c2c7220ULL, 0x080fe40000410000ULL, 0x000000242d2d7220ULL, 0x080fe40000410000ULL,
0x0000002430307220ULL, 0x080fe40000410000ULL, 0x0000002431317220ULL, 0x080fe40000410000ULL,
0x0000002434347220ULL, 0x080fe40000410000ULL, 0x0000002435357220ULL, 0x000fc40000410000ULL,
0x0000002438387220ULL, 0x080fe40000410000ULL, 0x0000002439397220ULL, 0x080fe40000410000ULL,
0x000000243c3c7220ULL, 0x080fe40000410000ULL, 0x000000243d3d7220ULL, 0x080fe40000410000ULL,
0x0000002440407220ULL, 0x080fe40000410000ULL, 0x0000002441417220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0068ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000081c247811ULL, 0x000fe200078ff0ffULL, 0x000114127f007947ULL, 0x000fea000b800000ULL,
0x00001f2412247589ULL, 0x00046400000e0000ULL, 0x0000002466667220ULL, 0x086fe40000410000ULL,
0x0000002467677220ULL, 0x080fe40000410000ULL, 0x000000242a2a7220ULL, 0x080fe40000410000ULL,
0x000000242b2b7220ULL, 0x080fe40000410000ULL, 0x000000242e2e7220ULL, 0x080fe40000410000ULL,
0x000000242f2f7220ULL, 0x000fc40000410000ULL, 0x0000002432327220ULL, 0x080fe40000410000ULL,
0x0000002433337220ULL, 0x080fe40000410000ULL, 0x0000002436367220ULL, 0x080fe40000410000ULL,
0x0000002437377220ULL, 0x080fe40000410000ULL, 0x000000243a3a7220ULL, 0x080fe40000410000ULL,
0x000000243b3b7220ULL, 0x000fc40000410000ULL, 0x000000243e3e7220ULL, 0x080fe40000410000ULL,
0x000000243f3f7220ULL, 0x080fe40000410000ULL, 0x0000002442427220ULL, 0x080fe40000410000ULL,
0x0000002443437220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000068ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000101c247811ULL, 0x000fe200078ff0ffULL,
0x000113027f007947ULL, 0x000fea000b800000ULL, 0x00001f2412247589ULL, 0x00046400000e0000ULL,
0x0000002444447220ULL, 0x086fe40000410000ULL, 0x0000002445457220ULL, 0x080fe40000410000ULL,
0x0000002448487220ULL, 0x080fe40000410000ULL, 0x0000002449497220ULL, 0x080fe40000410000ULL,
0x000000244c4c7220ULL, 0x080fe40000410000ULL, 0x000000244d4d7220ULL, 0x000fc40000410000ULL,
0x0000002450507220ULL, 0x080fe40000410000ULL, 0x0000002451517220ULL, 0x080fe40000410000ULL,
0x0000002454547220ULL, 0x080fe40000410000ULL, 0x0000002455557220ULL, 0x080fe40000410000ULL,
0x0000002458587220ULL, 0x080fe40000410000ULL, 0x0000002459597220ULL, 0x000fc40000410000ULL,
0x000000245c5c7220ULL, 0x080fe40000410000ULL, 0x000000245d5d7220ULL, 0x080fe40000410000ULL,
0x0000002478787220ULL, 0x080fe40000410000ULL, 0x0000002479797220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000068ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000181c247811ULL, 0x000fe200078ff0ffULL,
0x000112027f007947ULL, 0x000fea000b800000ULL, 0x00001f2412247589ULL, 0x00046400000e0000ULL,
0x0000002446467220ULL, 0x086fe40000410000ULL, 0x0000002447477220ULL, 0x080fe40000410000ULL,
0x000000244a4a7220ULL, 0x080fe40000410000ULL, 0x000000244b4b7220ULL, 0x080fe40000410000ULL,
0x000000244e4e7220ULL, 0x080fe40000410000ULL, 0x000000244f4f7220ULL, 0x000fc40000410000ULL,
0x0000002452527220ULL, 0x080fe40000410000ULL, 0x0000002453537220ULL, 0x080fe40000410000ULL,
0x0000002456567220ULL, 0x080fe40000410000ULL, 0x0000002457577220ULL, 0x080fe40000410000ULL,
0x000000245a5a7220ULL, 0x080fe40000410000ULL, 0x000000245b5b7220ULL, 0x000fc40000410000ULL,
0x000000245e5e7220ULL, 0x080fe40000410000ULL, 0x000000245f5f7220ULL, 0x080fe40000410000ULL,
0x000000247a7a7220ULL, 0x080fe40000410000ULL, 0x000000247b7b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000006861ff7212ULL, 0x000fe400078030ffULL,
0x0000002160217209ULL, 0x000fd60007810000ULL, 0x8000002160600221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b60600820ULL, 0x000fc80000410000ULL, 0x0000006000110308ULL, 0x000e640000000800ULL,
0x0000001162620220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000002362237221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000011ff0d723eULL, 0x000fe400000000ffULL,
0x00000002ff127819ULL, 0x000fe4000001161cULL, 0x000054100d0d7816ULL, 0x000fe2000000000dULL,
0x000110627f007947ULL, 0x000fea000b800000ULL, 0x00001f120d107589ULL, 0x0002a400000e0000ULL,
0x0000000812247810ULL, 0x000fe20007ffe0ffULL, 0x000110b27f007947ULL, 0x000fea000b800000ULL,
0x00000010120e7810ULL, 0x000fe20007ffe0ffULL, 0x00001f240d0f7589ULL, 0x00066a00000e0000ULL,
0x00001f0e0d0e7589ULL, 0x0006a400000e0000ULL, 0x0000001812247810ULL, 0x008fe20007ffe0ffULL,
0x000111427f007947ULL, 0x000fea000b800000ULL, 0x00001f240d0d7589ULL, 0x0022e400000e0000ULL,
0x000000031e127811ULL, 0x000fe200078ff0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0001700022757810ULL, 0x000fe20007ffe0ffULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0001200012127811ULL, 0x000fc400078e60ffULL, 0x000000750a687211ULL, 0x000fe200078e20ffULL,
0x00000010096c7824ULL, 0x100fe400078e0275ULL, 0x000000100b0b7824ULL, 0x100fe400078e0212ULL,
0x000000100c0c7824ULL, 0x000fe400078e0212ULL, 0x0000001008607824ULL, 0x000fe400078e0275ULL,
0x000000000b08783bULL, 0x000e680000000200ULL, 0x000000000c70783bULL, 0x0006a20000000200ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000001070707232ULL, 0x084fe40000000000ULL,
0x0000001072727232ULL, 0x000fc40000000000ULL, 0x0000000f71717232ULL, 0x080fe40000000000ULL,
0x0000000f73737232ULL, 0x000fe40000000000ULL, 0x0000000e08087232ULL, 0x082fe40000000000ULL,
0x0000000e0a0a7232ULL, 0x000fe40000000000ULL, 0x0000000d09097232ULL, 0x088fe40000000000ULL,
0x0000000d0b0b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001007247824ULL, 0x102fe200078e0275ULL, 0x000000006c6c783bULL, 0x000e620000004200ULL,
0x0000001006067824ULL, 0x100fe200078e0212ULL, 0x0000024000007945ULL, 0x000fe20003800000ULL,
0x0000001005127824ULL, 0x000fe200078e0212ULL, 0x000000006868783bULL, 0x000fe20000004200ULL,
0x00000010040c7824ULL, 0x008fc400078e0275ULL, 0x0000001003037824ULL, 0x100fe200078e0275ULL,
0x000000006060783bULL, 0x000ee20000004200ULL, 0x0000001002027824ULL, 0x000fc600078e0275ULL,
0x000000002424783bULL, 0x000ea80000004200ULL, 0x000000000604783bULL, 0x000ea20000000200ULL,
0x0000006c0844723cULL, 0x002f700000001844ULL, 0x000000607034723cULL, 0x04cf700000001834ULL,
0x000000627038723cULL, 0x000f700000001838ULL, 0x0000006e0848723cULL, 0x040f700000001848ULL,
0x00000068084c723cULL, 0x040f70000000184cULL, 0x0000006a0850723cULL, 0x040f700000001850ULL,
0x000000600854723cULL, 0x040f700000001854ULL, 0x000000620858723cULL, 0x040b640000001858ULL,
0x000000001260783bULL, 0x0202ac0000000200ULL, 0x00000024085c723cULL, 0x000b70000000185cULL,
0x0000006c7064723cULL, 0x040b700000001864ULL, 0x0000006e7028723cULL, 0x040b700000001828ULL,
0x00000068702c723cULL, 0x040b70000000182cULL, 0x0000006a7030723cULL, 0x040b700000001830ULL,
0x00000024703c723cULL, 0x040b70000000183cULL, 0x000000267040723cULL, 0x080b700000001840ULL,
0x000000260808723cULL, 0x000b620000001878ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000008000008947ULL, 0x000fde0003800000ULL, 0x0000001004047232ULL, 0x086fe40000000000ULL,
0x0000001006067232ULL, 0x000fc40000000000ULL, 0x0000000f05057232ULL, 0x080fe40000000000ULL,
0x0000000f07077232ULL, 0x000fe40000000000ULL, 0x0000000e60607232ULL, 0x080fe40000000000ULL,
0x0000000e62627232ULL, 0x000fe40000000000ULL, 0x0000000d61617232ULL, 0x080fe40000000000ULL,
0x0000000d63637232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x006fea0003800000ULL,
0x0000001000007824ULL, 0x000fe200078e0275ULL, 0x000000000c24783bULL, 0x020e680000004200ULL,
0x000000000368783bULL, 0x000ea80000004200ULL, 0x00000000026c783bULL, 0x000ee80000004200ULL,
0x000000000070783bULL, 0x0002a40000004200ULL, 0x00000002ff007819ULL, 0x002fc8000001161eULL,
0x0001e6a000007811ULL, 0x000fe200078e18ffULL, 0x000000246044723cULL, 0x040b700000001844ULL,
0x000000266048723cULL, 0x040b700000001848ULL, 0x00000068604c723cULL, 0x044b70000000184cULL,
0x0000006a6050723cULL, 0x040b700000001850ULL, 0x0000006c6054723cULL, 0x048b700000001854ULL,
0x0000006e6058723cULL, 0x040b700000001858ULL, 0x00000070605c723cULL, 0x000b70000000185cULL,
0x000000240464723cULL, 0x040b700000001864ULL, 0x000000260428723cULL, 0x040b700000001828ULL,
0x00000068042c723cULL, 0x040b70000000182cULL, 0x0000006a0430723cULL, 0x040b700000001830ULL,
0x0000006c0434723cULL, 0x040b700000001834ULL, 0x0000006e0438723cULL, 0x040b700000001838ULL,
0x00000070043c723cULL, 0x040b70000000183cULL, 0x000000720440723cULL, 0x080b700000001840ULL,
0x000000726060723cULL, 0x000b620000001808ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000191d00720cULL, 0x000fe20003f06070ULL, 0x0000000000ff7f8cULL, 0x0003d8000c80043fULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff816000007947ULL, 0x000fea000383ffffULL,
0x0000000000047919ULL, 0x020e640000002500ULL, 0x000000190400720cULL, 0x002fda0003f06070ULL,
0x0000058000000947ULL, 0x000fea0003800000ULL, 0x0180000023007810ULL, 0x000fe20007ffe0ffULL,
0x000000d000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x0000002300057202ULL, 0x000fe40000000f00ULL, 0x00009bd000067802ULL, 0x000fc40000000f00ULL,
0x00010ef000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002300007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000023ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x0000001003057811ULL, 0x046fe400078ff0ffULL,
0x00000002ff077819ULL, 0x000fe40000011603ULL, 0x00000018030b7811ULL, 0x040fe400078ff0ffULL,
0x0000000803097811ULL, 0x000fe200078ff0ffULL, 0x00001f0700027589ULL, 0x000e6800000e0000ULL,
0x00001f0b00067589ULL, 0x000ea800000e0000ULL, 0x00001f0900037589ULL, 0x000ee800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000006402647220ULL, 0x002fc40000410000ULL,
0x0000006502657220ULL, 0x040fe40000410000ULL, 0x0000002802287220ULL, 0x040fe40000410000ULL,
0x0000002902297220ULL, 0x040fe40000410000ULL, 0x0000002c022c7220ULL, 0x040fe40000410000ULL,
0x0000002d022d7220ULL, 0x040fe40000410000ULL, 0x0000003002307220ULL, 0x000fc40000410000ULL,
0x0000003102317220ULL, 0x040fe40000410000ULL, 0x0000003402347220ULL, 0x040fe40000410000ULL,
0x0000003502357220ULL, 0x040fe40000410000ULL, 0x0000003802387220ULL, 0x040fe40000410000ULL,
0x0000003902397220ULL, 0x040fe40000410000ULL, 0x0000003c023c7220ULL, 0x000fc40000410000ULL,
0x0000003d023d7220ULL, 0x040fe40000410000ULL, 0x0000004002407220ULL, 0x040fe40000410000ULL,
0x0000004102417220ULL, 0x000fe40000410000ULL, 0x0000004606467220ULL, 0x044fe40000410000ULL,
0x0000004706477220ULL, 0x040fe40000410000ULL, 0x0000004a064a7220ULL, 0x000fc40000410000ULL,
0x0000004b064b7220ULL, 0x040fe40000410000ULL, 0x0000004e064e7220ULL, 0x040fe40000410000ULL,
0x0000004f064f7220ULL, 0x040fe40000410000ULL, 0x0000005206527220ULL, 0x040fe40000410000ULL,
0x0000005306537220ULL, 0x040fe40000410000ULL, 0x0000005606567220ULL, 0x000fc40000410000ULL,
0x0000005706577220ULL, 0x040fe40000410000ULL, 0x0000005a065a7220ULL, 0x040fe40000410000ULL,
0x0000005b065b7220ULL, 0x040fe40000410000ULL, 0x0000005e065e7220ULL, 0x040fe40000410000ULL,
0x0000005f065f7220ULL, 0x040fe40000410000ULL, 0x0000006206627220ULL, 0x000fc40000410000ULL,
0x0000006306637220ULL, 0x000fe40000410000ULL, 0x0000000366667220ULL, 0x088fe40000410000ULL,
0x0000000367677220ULL, 0x080fe40000410000ULL, 0x000000032a2a7220ULL, 0x080fe40000410000ULL,
0x000000032b2b7220ULL, 0x080fe40000410000ULL, 0x000000032e2e7220ULL, 0x000fc40000410000ULL,
0x000000032f2f7220ULL, 0x080fe40000410000ULL, 0x0000000332327220ULL, 0x080fe40000410000ULL,
0x0000000333337220ULL, 0x080fe40000410000ULL, 0x0000000336367220ULL, 0x080fe40000410000ULL,
0x0000000337377220ULL, 0x080fe40000410000ULL, 0x000000033a3a7220ULL, 0x000fc40000410000ULL,
0x000000033b3b7220ULL, 0x080fe40000410000ULL, 0x000000033e3e7220ULL, 0x080fe40000410000ULL,
0x000000033f3f7220ULL, 0x080fe40000410000ULL, 0x0000000342427220ULL, 0x080fe40000410000ULL,
0x0000000343437220ULL, 0x000fe40000410000ULL, 0x0000000544447220ULL, 0x000fc40000410000ULL,
0x0000000545457220ULL, 0x080fe40000410000ULL, 0x0000000548487220ULL, 0x080fe40000410000ULL,
0x0000000549497220ULL, 0x080fe40000410000ULL, 0x000000054c4c7220ULL, 0x080fe40000410000ULL,
0x000000054d4d7220ULL, 0x080fe40000410000ULL, 0x0000000550507220ULL, 0x000fc40000410000ULL,
0x0000000551517220ULL, 0x080fe40000410000ULL, 0x0000000554547220ULL, 0x080fe40000410000ULL,
0x0000000555557220ULL, 0x080fe40000410000ULL, 0x0000000558587220ULL, 0x080fe40000410000ULL,
0x0000000559597220ULL, 0x080fe40000410000ULL, 0x000000055c5c7220ULL, 0x000fc40000410000ULL,
0x000000055d5d7220ULL, 0x080fe40000410000ULL, 0x0000000560607220ULL, 0x080fe40000410000ULL,
0x0000000561617220ULL, 0x000fc40000410000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x000000282906723eULL, 0x000fe400000000ffULL, 0x0000002c2d07723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002a2b2a723eULL, 0x000fc400000000ffULL,
0x0000002e2f2e723eULL, 0x000fe400000000ffULL, 0x000000646505723eULL, 0x000fe400000000ffULL,
0x000000303108723eULL, 0x000fe400000000ffULL, 0x00000034350a723eULL, 0x000fe400000000ffULL,
0x00000038390b723eULL, 0x000fe400000000ffULL, 0x0000003c3d0c723eULL, 0x000fc400000000ffULL,
0x00000002ff1a7819ULL, 0x002fe40000011603ULL, 0x00000008032d7811ULL, 0x000fe400078ff0ffULL,
0x000000041a197810ULL, 0x040fe20007ffe0ffULL, 0x000000081a207824ULL, 0x040fe200078e00ffULL,
0x000000011a007810ULL, 0x040fe20007ffe0ffULL, 0x000000081a1b7824ULL, 0x040fe200078e00ffULL,
0x000000021a027810ULL, 0x040fe20007ffe0ffULL, 0x000000081a1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff820257812ULL, 0x000fe200078ee219ULL, 0x000000081a1c7824ULL, 0x040fe200078e00ffULL,
0x000000031a097810ULL, 0x040fe20007ffe0ffULL, 0x000000081a197824ULL, 0x040fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL, 0x000000081a277824ULL, 0x040fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee202ULL, 0x000000081a297824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1f7812ULL, 0x010fc400078ee209ULL, 0x000000051a007810ULL, 0x040fe40007ffe0ffULL,
0x000000061a027810ULL, 0x040fe40007ffe0ffULL, 0xffffffff1a097810ULL, 0x040fe40007ffe0ffULL,
0xfffffff819197812ULL, 0x000fe200078ee21aULL, 0x000000081a1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee200ULL, 0x0000200014007824ULL, 0x000fe200078e00ffULL,
0x000000032d1c7819ULL, 0x000fc400000006ffULL, 0xfffffff81a2b7812ULL, 0x000fe200078ee209ULL,
0x0000100017097824ULL, 0x000fe200078e00ffULL, 0x00000010032f7811ULL, 0x040fe200078ff0ffULL,
0x00000004031a7824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee202ULL,
0x0000000100027824ULL, 0x000fe200078e0209ULL, 0xfffffff81c2d7812ULL, 0x000fe200078ee22dULL,
0x000000082f1c7824ULL, 0x000fe200078e00ffULL, 0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL,
0x0000001019197824ULL, 0x100fe200078e0202ULL, 0x000000021b1b7211ULL, 0x000fe200078e20ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0202ULL, 0xfffffff81c2f7812ULL, 0x000fe200078ee22fULL,
0x000000101f1f7824ULL, 0x100fe200078e0202ULL, 0x0000001803317811ULL, 0x000fe200078ff0ffULL,
0x0000001025257824ULL, 0x000fe200078e0202ULL, 0x00000040410d723eULL, 0x000fe200000000ffULL,
0x00000001191c7824ULL, 0x000fe200078e021aULL, 0x000000666766723eULL, 0x000fe200000000ffULL,
0x0000001027277824ULL, 0x100fe200078e0202ULL, 0x000000323332723eULL, 0x000fe200000000ffULL,
0x000000011a1b7824ULL, 0x040fe200078e021bULL, 0x000000051c007388ULL, 0x0003e20000000800ULL,
0x0000001029297824ULL, 0x100fe200078e0202ULL, 0x000000363736723eULL, 0x000fe200000000ffULL,
0x000000102b2b7824ULL, 0x100fe200078e0202ULL, 0x000000061b007388ULL, 0x000fe20000000800ULL,
0x000000011a1d7824ULL, 0x040fe200078e021dULL, 0x0000003a3b3a723eULL, 0x000fe200000000ffULL,
0x000000011a1f7824ULL, 0x040fe200078e021fULL, 0x0000002b1a2b7210ULL, 0x040fe20007ffe0ffULL,
0x000000102d2d7824ULL, 0x100fe200078e0202ULL, 0x000000071d007388ULL, 0x000fe20000000800ULL,
0x000000011a257824ULL, 0x040fe200078e0225ULL, 0x0000003e3f3e723eULL, 0x000fe200000000ffULL,
0x000000011a277824ULL, 0x040fe200078e0227ULL, 0x000000081f007388ULL, 0x000fe20000000800ULL,
0x000000011a297824ULL, 0x040fe200078e0229ULL, 0x000000424342723eULL, 0x000fe200000000ffULL,
0x000000011a2d7824ULL, 0x000fe200078e022dULL, 0x0000000a25007388ULL, 0x000fe20000000800ULL,
0x0000000831207824ULL, 0x000fe200078e00ffULL, 0x000000444544723eULL, 0x000fe200000000ffULL,
0x000000102f2f7824ULL, 0x000fe200078e0202ULL, 0x0000000b27007388ULL, 0x0005e20000000800ULL,
0x000000484948723eULL, 0x000fe200000000ffULL, 0x00000300ff1c7624ULL, 0x002fe200078e00ffULL,
0xfffffff820317812ULL, 0x000fe200078ee231ULL, 0x0000000c29007388ULL, 0x000fe20000000800ULL,
0x000000011a2f7824ULL, 0x000fe200078e022fULL, 0x0000004c4d4c723eULL, 0x000fc400000000ffULL,
0x0000000d2b007388ULL, 0x000fe20000000800ULL, 0x000000505150723eULL, 0x000fe200000000ffULL,
0x00000001160b7824ULL, 0x004fe200078e0203ULL, 0x0000000231317211ULL, 0x000fe200078e20ffULL,
0x000000662d007388ULL, 0x000fe20000000800ULL, 0x000000545554723eULL, 0x000fe200000000ffULL,
0x000000100b077824ULL, 0x000fe200078e0200ULL, 0x000000585958723eULL, 0x000fe200000000ffULL,
0x0004002a1b007388ULL, 0x000fe20000000800ULL, 0x0000005c5d5c723eULL, 0x000fe200000000ffULL,
0x000000011a317824ULL, 0x000fe200078e0231ULL, 0x000000606160723eULL, 0x000fe200000000ffULL,
0x0004002e1d007388ULL, 0x000fe20000000800ULL, 0x00000046470e723eULL, 0x000fc400000000ffULL,
0x0000004a4b0f723eULL, 0x000fe200000000ffULL, 0x000400321f007388ULL, 0x000fe20000000800ULL,
0x0000004e4f10723eULL, 0x000fe400000000ffULL, 0x000000525311723eULL, 0x000fe200000000ffULL,
0x0004003625007388ULL, 0x000fe20000000800ULL, 0x000000565712723eULL, 0x000fe400000000ffULL,
0x0000005a5b13723eULL, 0x000fe200000000ffULL, 0x0004003a27007388ULL, 0x000fe20000000800ULL,
0x0000005e5f15723eULL, 0x000fc400000000ffULL, 0x000000626318723eULL, 0x000fe200000000ffULL,
0x0004003e29007388ULL, 0x000fe20000000800ULL, 0x000000011c00780cULL, 0x000fc60003f05270ULL,
0x000400422b007388ULL, 0x000fe80000000800ULL, 0x000000442f007388ULL, 0x000fe80000000800ULL,
0x000800481b007388ULL, 0x000fe80000000800ULL, 0x0008004c1d007388ULL, 0x000fe80000000800ULL,
0x000800501f007388ULL, 0x000fe80000000800ULL, 0x0008005425007388ULL, 0x000fe80000000800ULL,
0x0008005827007388ULL, 0x000fe80000000800ULL, 0x0008005c29007388ULL, 0x000fe80000000800ULL,
0x000800602b007388ULL, 0x000fe80000000800ULL, 0x0000000e31007388ULL, 0x000fe80000000800ULL,
0x000c000f1b007388ULL, 0x000fe80000000800ULL, 0x000c00101d007388ULL, 0x000fe80000000800ULL,
0x000c00111f007388ULL, 0x000fe80000000800ULL, 0x000c001225007388ULL, 0x000fe80000000800ULL,
0x000c001327007388ULL, 0x000fe80000000800ULL, 0x000c001529007388ULL, 0x000fe80000000800ULL,
0x000c00182b007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000072c7984ULL, 0x000e680000000c00ULL, 0x0004000007307984ULL, 0x000ea80000000c00ULL,
0x0008000007387984ULL, 0x000ee80000000c00ULL, 0x000c000007107984ULL, 0x000ee80000000c00ULL,
0x00100000070c7984ULL, 0x000ee80000000c00ULL, 0x0014000007347984ULL, 0x000ee80000000c00ULL,
0x00180000073c7984ULL, 0x000ee80000000c00ULL, 0x001c000007247984ULL, 0x000ee20000000c00ULL,
0x200000ff2f2f7230ULL, 0x002fc40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fe40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x200000ff33337230ULL, 0x004fe40000000000ULL, 0x200000ff32327230ULL, 0x000fe40000000000ULL,
0x200000ff31317230ULL, 0x000fc40000000000ULL, 0x200000ff30307230ULL, 0x000fe40000000000ULL,
0x200000ff3b3b7230ULL, 0x008fe40000000000ULL, 0x200000ff3a3a7230ULL, 0x000fe40000000000ULL,
0x200000ff39397230ULL, 0x000fe40000000000ULL, 0x200000ff38387230ULL, 0x000fe40000000000ULL,
0x200000ff13137230ULL, 0x000fc40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fe40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x0000000f2f2f7230ULL, 0x000fe40000000000ULL, 0x0000000e2e2e7230ULL, 0x000fe40000000000ULL,
0x0000000d2d2d7230ULL, 0x000fc40000000000ULL, 0x0000000c2c2c7230ULL, 0x000fe40000000000ULL,
0x0000003733337230ULL, 0x000fe40000000000ULL, 0x0000003632327230ULL, 0x000fe20000000000ULL,
0x0000002c07007388ULL, 0x000fe20000000c00ULL, 0x0000003531317230ULL, 0x000fe40000000000ULL,
0x0000003430307230ULL, 0x000fe40000000000ULL, 0x0000003f3b3b7230ULL, 0x000fc40000000000ULL,
0x0000003e3a3a7230ULL, 0x000fe20000000000ULL, 0x0004003007007388ULL, 0x000fe20000000c00ULL,
0x0000003d39397230ULL, 0x000fe40000000000ULL, 0x0000003c38387230ULL, 0x000fe40000000000ULL,
0x0000002713137230ULL, 0x000fe40000000000ULL, 0x0000002612127230ULL, 0x000fe20000000000ULL,
0x0008003807007388ULL, 0x000fe20000000c00ULL, 0x0000002511117230ULL, 0x000fc40000000000ULL,
0x0000002410107230ULL, 0x000fca0000000000ULL, 0x000c001007007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000395000008947ULL, 0x000fea0003800000ULL,
0x00000400ff057624ULL, 0x000fe200078e00ffULL, 0x0000000000087919ULL, 0x000e620000002600ULL,
0x000000800b0f7810ULL, 0x000fc40007ffe0ffULL, 0x00006a0005057a24ULL, 0x000fe200078e02ffULL,
0x00000000000d7919ULL, 0x000e660000002700ULL, 0x00000300050a7a24ULL, 0x040fe200078e02ffULL,
0x0000000f05067811ULL, 0x000fe200078e10ffULL, 0x0000000007287984ULL, 0x000ea60000000c00ULL,
0xfffffff006157812ULL, 0x000fe200078ec0ffULL, 0x00040000072c7984ULL, 0x000ee80000000c00ULL,
0x000000800a277824ULL, 0x040fe200078e0215ULL, 0x0008000007307984ULL, 0x000ea60000000c00ULL,
0x000000800a0a7824ULL, 0x000fe200078e0227ULL, 0x000c000007347984ULL, 0x0008a80000000c00ULL,
0x0000007f0a0a7810ULL, 0x000fe20007ffe0ffULL, 0x000004000d087a24ULL, 0x002fe200078e0208ULL,
0x000000400b0d7810ULL, 0x000fc40007ffe0ffULL, 0xffffff800a187812ULL, 0x000fe200078ec0ffULL,
0x0000030008067a24ULL, 0x000fe200078e02ffULL, 0x000000c00b077810ULL, 0x010fe40007ffe0ffULL,
0x00006e0018057a10ULL, 0x000fe40007f1e0ffULL, 0x0000000406107210ULL, 0x000fc80007ffe0ffULL,
0x0000000510047211ULL, 0x000fe200078268ffULL, 0x00006f00ff057624ULL, 0x000fe200000e06ffULL,
0x0000000117ff7812ULL, 0x000fc8000780f81eULL, 0x0000000510057211ULL, 0x000fe400008f6cffULL,
0x00006e0015197a10ULL, 0x000fc60007f3e0ffULL, 0x0000100014047825ULL, 0x000fc800078e0004ULL,
0x00006f00ff1a7624ULL, 0x000fe400008e06ffULL, 0x000000100b0a7825ULL, 0x000fc800078e0004ULL,
0x000000100d0c7825ULL, 0x000fc800078e0004ULL, 0x000000100f0e7825ULL, 0x000fc800078e0004ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x0000001003077824ULL, 0x00cfe200078e00ffULL, 0x00000001ff117819ULL, 0x000fe20000011603ULL,
0x0000008010127824ULL, 0x000fc600078e00ffULL, 0x0000007007207812ULL, 0x000fe400078ec0ffULL,
0x0000000c11117812ULL, 0x000fe400078ec0ffULL, 0x00006e0012137a10ULL, 0x000fe40007ebe027ULL,
0x00000019ff077819ULL, 0x000fe40000011610ULL, 0x0000001920107210ULL, 0x000fe40007a3e012ULL,
0x0000001311127210ULL, 0x000fc40007c7e020ULL, 0x00006f0007137a10ULL, 0x000fe40002fec4ffULL,
0x0000001011107210ULL, 0x000fe40007fbe0ffULL, 0x0000001aff077210ULL, 0x000fe40000fe4407ULL,
0x00000013ff137210ULL, 0x000fc60001fe84ffULL, 0x000000ffff117224ULL, 0x000fca00028e0607ULL,
0x0000002110007986ULL, 0x0003e8000c101908ULL, 0x0000002312007986ULL, 0x0003e4000c101908ULL,
0x000000ff0300720cULL, 0x00cfe20000705670ULL, 0x000000280a007986ULL, 0x000fe2000c101d08ULL,
0x0000017000007945ULL, 0x000fe60003800000ULL, 0x0000002c0c007986ULL, 0x000fe8000c101d08ULL,
0x000000300e007986ULL, 0x000fe8000c101d08ULL, 0x0000003404007986ULL, 0x000fe8000c101d08ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0xffffffff1c077810ULL, 0x000fc60007ffe0ffULL,
0x00006e0008047625ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000007040479a8ULL, 0x000ea400099ee1c8ULL, 0x000000070400720cULL, 0x004fc80003f05270ULL,
0x00000001ff087807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000008ff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff047984ULL, 0x000ee40000000000ULL,
0x000000ff0400720cULL, 0x008fda0003f05270ULL, 0x0000345000008947ULL, 0x000fea0003800000ULL,
0x000000ff1e00720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001003057824ULL, 0x000fe200078e00ffULL, 0x00000001ff087819ULL, 0x004fe40000011603ULL,
0x0000001906047211ULL, 0x000fe400078038ffULL, 0x0000007005077812ULL, 0x000fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fe400078ec0ffULL, 0x0000001a06057211ULL, 0x000fe400000f3cffULL,
0x0000000408047210ULL, 0x000fc8000791e007ULL, 0x00000005ff057210ULL, 0x000fca00007e24ffULL,
0x0000000804087981ULL, 0x000528000c1e1900ULL, 0x00008008040b7981ULL, 0x000522000c1e1900ULL,
0x000000021c00780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010008040d7981ULL, 0x004522000c1e1900ULL, 0x000000041c00780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x00018008040f7981ULL, 0x004522000c1e1900ULL,
0x000000041c00780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x0002000804117981ULL, 0x006322000c1e1900ULL, 0x000000061c00780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800804137981ULL, 0x002322000c1e1900ULL,
0x000000061c00780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081c00780cULL, 0x002fe20003f06070ULL, 0x0003000804197981ULL, 0x000318000c1e1900ULL,
0x00038008041b0981ULL, 0x000324000c1e1900ULL, 0x000000071c047810ULL, 0x006fc80007ffe0ffULL,
0x00000003ff077819ULL, 0x000fc80000011604ULL, 0x000000ff0700720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x00000015061f7211ULL, 0x040fe200078038ffULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x00000008001d7202ULL, 0x010fe20000000f00ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x00006e001f1f7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff060a7211ULL, 0x000fe400000f3cffULL, 0x000007801f1f7810ULL, 0x000fc80007f5e0ffULL,
0x00006f00ff0a7a10ULL, 0x000fc400017e240aULL, 0x000003000c007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000407007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x000000080c047810ULL, 0x040fe40007ffe0ffULL,
0x000000010c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001d08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011603ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041f047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffc8008041d7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x000000090c047810ULL, 0x042fe40007ffe0ffULL,
0x000000020c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000b08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011603ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041f047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffd0008040b7981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a0c047810ULL, 0x042fe40007ffe0ffULL,
0x000000030c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000d08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011603ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041f047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffd8008040d7981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b0c047810ULL, 0x042fe40007ffe0ffULL,
0x000000040c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000000f08087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011603ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041f047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffe0008040f7981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c0c047810ULL, 0x042fe40007ffe0ffULL,
0x000000050c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001108087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000403047819ULL, 0x000fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe40000011603ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041f047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xfffe800804117981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d0c047810ULL, 0x042fe40007ffe0ffULL,
0x000000060c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001308087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011603ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041f047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xffff000804137981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e0c047810ULL, 0x042fe40007ffe0ffULL,
0x000000070c057810ULL, 0x000fe40007ffe0ffULL, 0x0000030004007a0cULL, 0x000fe40003f26070ULL,
0x0000030005007a0cULL, 0x000fe40003f46070ULL, 0x0000001908087209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011603ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041f047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0xffff800804197981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f0c047810ULL, 0x002fe40007ffe0ffULL,
0x0000001b08087209ULL, 0x000fe40007810000ULL, 0x0000030004007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001003047824ULL, 0x000fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011603ULL, 0x0000007004047812ULL, 0x000fc800078ec0ffULL,
0x0000000c04047812ULL, 0x000fc800078ef805ULL, 0x000000041f047210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff057224ULL, 0x000fca00008e060aULL, 0x00000008041b7981ULL, 0x000326000c1e1900ULL,
0x000004001f1f7810ULL, 0x000fe40007f3e0ffULL, 0x000000080c0c7810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e060aULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x0000000403047819ULL, 0x006fe400000006ffULL,
0x00000001ff057819ULL, 0x000fe40000011603ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fca00078ec0ffULL, 0x0000000104057824ULL, 0x000fca00078e0205ULL,
0x0000000805007388ULL, 0x0103e40000000800ULL, 0x00006e0018047a10ULL, 0x000fe20007f3e0ffULL,
0x0000000117117824ULL, 0x002fe200078e0206ULL, 0x000000070300780cULL, 0x000fe20003f04070ULL,
0x0000100014077824ULL, 0x000fe200078e00ffULL, 0x0000000117087812ULL, 0x004fe200078ec0ffULL,
0x00006f00ff057624ULL, 0x000fe200008e06ffULL, 0x0000002003197810ULL, 0x040fe20007ffe0ffULL,
0x0000001003107824ULL, 0x040fe200078e00ffULL, 0x00000040031b7810ULL, 0x000fe20007ffe0ffULL,
0x00002000110a7825ULL, 0x000fe200078e0004ULL, 0x00000060031d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000070a0a7210ULL, 0x000fe20007f3e0ffULL,
0x00000002170d8824ULL, 0x100fe200078e0214ULL, 0x00000080031f7810ULL, 0x000fe20007ffe0ffULL,
0x00000002170f8824ULL, 0x000fe200078e0214ULL, 0x0000000bff0b7210ULL, 0x000fe20000ffe4ffULL,
0x000000020d0e8824ULL, 0x100fe200078e0208ULL, 0x000000a003217810ULL, 0x000fe20007ffe0ffULL,
0x000000020f2a8824ULL, 0x000fe200078e0208ULL, 0x000000c003237810ULL, 0x000fe20007ffe0ffULL,
0x0000400017087824ULL, 0x000fe200078e0200ULL, 0x000000e003257810ULL, 0x000fe20007ffe0ffULL,
0x0000001019187825ULL, 0x000fe200078e000aULL, 0x0000100009097812ULL, 0x000fe200078ec0ffULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000001ff0f7819ULL, 0x000fe20000011603ULL,
0x000000101b1a7825ULL, 0x100fe200078e000aULL, 0x0000007010107812ULL, 0x000fe200078ec0ffULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL,
0x000000101d1c7825ULL, 0x100fe200078e000aULL, 0x000000032a2a8211ULL, 0x000fe200078e18ffULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x000000101f1e7825ULL, 0x100fe200078e000aULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000001021207825ULL, 0x100fe200078e000aULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000001023227825ULL, 0x100fe200078e000aULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000001025247825ULL, 0x100fe200078e000aULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000001003127825ULL, 0x000fe200078e000aULL, 0x00006e00270a7a10ULL, 0x000fe20007f3e0ffULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00006e00150b7a10ULL, 0x000fe20007f5e0ffULL,
0x00000001080c7824ULL, 0x000fe200078e0209ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x0000000110097824ULL, 0x000fe200078e020fULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000010032b7824ULL, 0x000fc400078e020cULL, 0x00006f00ff0c7624ULL, 0x000fe200008e06ffULL,
0x0000000a11268211ULL, 0x040fe200078238ffULL, 0x00006f00ff0d7624ULL, 0x000fe200010e06ffULL,
0x0000000b11288211ULL, 0x040fe200078438ffULL, 0x0000000009097984ULL, 0x000e620000000800ULL,
0x0000000c11278211ULL, 0x000fe200008f3cffULL, 0x000000080e0e8824ULL, 0x000fe200078e0203ULL,
0x0000030017007a0cULL, 0x000fe20003f26070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000122b7faeULL, 0x0005e2000b901c48ULL, 0x0000000d11298211ULL, 0x000fe200010f3cffULL,
0x000000ffff157224ULL, 0x000fc400078e00ffULL, 0x00380000182b7faeULL, 0x0007e2000b901c48ULL,
0x000000ffff117224ULL, 0x000fe400078e00ffULL, 0x000000ffff527224ULL, 0x000fe200078e00ffULL,
0x005800001a2b7faeULL, 0x0009e2000b901c48ULL, 0x000000ffff547224ULL, 0x000fc600078e00ffULL,
0x007800001c2b7faeULL, 0x0009e2000b901c48ULL, 0x0000000000127805ULL, 0x004fc6000001ff00ULL,
0x009800001e2b7faeULL, 0x0005e2000b901c48ULL, 0x0000000000187805ULL, 0x008fe2000001ff00ULL,
0x000085800e1b8811ULL, 0x010fe400078e20ffULL, 0x00b80000202b7faeULL, 0x0007e2000b901c48ULL,
0x000000ffff0e7224ULL, 0x000fe400078e00ffULL, 0x00000010031c8825ULL, 0x040fe200078e0026ULL,
0x000081802a278811ULL, 0x000fe200078e20ffULL, 0x00d80000222b7faeULL, 0x0009e4000b901c48ULL,
0x00000010031e8825ULL, 0x004fc400078e0028ULL, 0x00f80000242b7faeULL, 0x0005e2000b901c48ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x008fe4000001ff00ULL,
0x000000001c1b8faeULL, 0x0007e8000b901c48ULL, 0x000000001e278faeULL, 0x0003e2000b901c48ULL,
0x0000000000227805ULL, 0x010fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000002a7805ULL, 0x004fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x008fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x002fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000012f000001947ULL, 0x000fea0003800000ULL, 0x000000ffff0e7224ULL, 0x000fe400078e00ffULL,
0x000000ffff537224ULL, 0x000fca00078e0017ULL, 0x00000001530f7810ULL, 0x000fc80007ffe0ffULL,
0x000003000f007a0cULL, 0x000fda0003f06070ULL, 0x0000034000000947ULL, 0x000fea0003800000ULL,
0x000000070300780cULL, 0x000fe20003f44070ULL, 0x0000000106557824ULL, 0x000fe200078e020fULL,
0x000000010f107812ULL, 0x040fe200078ec0ffULL, 0x000010000f0f7824ULL, 0x000fe200078e00ffULL,
0x00000040035d7810ULL, 0x000fe20007ffe0ffULL, 0x0000200055567825ULL, 0x000fe200078e0004ULL,
0x00000060035f7810ULL, 0x000fe40007ffe0ffULL, 0x000010000f0f7812ULL, 0x000fe400078ec0ffULL,
0x0000000756567210ULL, 0x000fc40007f1e0ffULL, 0x0000008003617810ULL, 0x000fe20007ffe0ffULL,
0x00000002175ba824ULL, 0x040fe200078e0214ULL, 0x000000141759a211ULL, 0x000fe200078e08ffULL,
0x000000ffff577224ULL, 0x000fe200000e0657ULL, 0x000000a003637810ULL, 0x000fe20007ffe0ffULL,
0x000000025b6ca824ULL, 0x100fe200078e0210ULL, 0x00000020035b7810ULL, 0x000fe20007ffe0ffULL,
0x00000002596aa824ULL, 0x000fe200078e0210ULL, 0x000000c003657810ULL, 0x040fe20007ffe0ffULL,
0x0000000108107824ULL, 0x000fe200078e020fULL, 0x000000e003677810ULL, 0x000fe20007ffe0ffULL,
0x000000105b5a7825ULL, 0x000fe200078e0056ULL, 0x0000000a5566a211ULL, 0x000fc400078038ffULL,
0x0000000b5568a211ULL, 0x000fe200078238ffULL, 0x00000010030f7824ULL, 0x000fe200078e0210ULL,
0x000000036c6ca211ULL, 0x000fe200078e18ffULL, 0x000000105d5c7825ULL, 0x000fe200078e0056ULL,
0x0000000d5569a211ULL, 0x000fc600008f3cffULL, 0x000000105f5e7825ULL, 0x000fc800078e0056ULL,
0x0000001061607825ULL, 0x000fc800078e0056ULL, 0x0000001003587825ULL, 0x000fc800078e0056ULL,
0x0000001063627825ULL, 0x100fe200078e0056ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000580f7faeULL, 0x0003e6000b901c48ULL, 0x0000001065647825ULL, 0x100fe200078e0056ULL,
0x003800005a0f7faeULL, 0x0005e6000b901c48ULL, 0x0000001067567825ULL, 0x000fe200078e0056ULL,
0x0000000c5567a211ULL, 0x000fe200000f3cffULL, 0x005800005c0f7faeULL, 0x0007e4000b901c48ULL,
0x000000086a55a824ULL, 0x000fc400078e0203ULL, 0x007800005e0f7faeULL, 0x0007e2000b901c48ULL,
0x000000100366a825ULL, 0x000fe400078e0066ULL, 0x000085805555a811ULL, 0x000fe200078e20ffULL,
0x00980000600f7faeULL, 0x0007e2000b901c48ULL, 0x000081806c5ba811ULL, 0x004fe200078e20ffULL,
0x000000100358a825ULL, 0x002fe400078e0068ULL, 0x00b80000620f7faeULL, 0x0007e8000b901c48ULL,
0x00d80000640f7faeULL, 0x0007e8000b901c48ULL, 0x00f80000560f7faeULL, 0x0007e8000b901c48ULL,
0x000000006655afaeULL, 0x0007e8000b901c48ULL, 0x00000000585bafaeULL, 0x0007e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000080530f7824ULL, 0x008fe200078e00ffULL,
0x00000001ff577819ULL, 0x100fe20000011603ULL, 0x0000000217567824ULL, 0x000fe200078e0214ULL,
0x00000002ff6a7819ULL, 0x000fe20000011603ULL, 0x0000001003107824ULL, 0x000fe200078e00ffULL,
0x000000800f0f7812ULL, 0x000fc400078ec0ffULL, 0x000000046a5a7810ULL, 0x040fe20007ffe0ffULL,
0x000000086a627824ULL, 0x000fe200078e00ffULL, 0x0000007010107812ULL, 0x000fe200078ec0ffULL,
0x0000010056557824ULL, 0x000fe200078e000fULL, 0x0000000c570f7812ULL, 0x000fe200078ec0ffULL,
0x000000086a607824ULL, 0x040fe200078e00ffULL, 0x000000026a577810ULL, 0x040fe20007ffe0ffULL,
0x000000086a5b7824ULL, 0x040fe200078e00ffULL, 0x000000550f567210ULL, 0x000fe20007ffe010ULL,
0x000000086a667824ULL, 0x040fe200078e00ffULL, 0x000000016a557810ULL, 0x040fe20007ffe0ffULL,
0x000000086a6e7824ULL, 0x000fe200078e00ffULL, 0xfffffff862627812ULL, 0x000fe200078ee257ULL,
0x0000000403577824ULL, 0x000fe200078e00ffULL, 0xfffffff860607812ULL, 0x000fe200078ee255ULL,
0x000000086a707824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0081800056587984ULL, 0x000e620000000800ULL, 0x0000000c53557819ULL, 0x000fe200000006ffULL,
0x000000086a5f7824ULL, 0x040fe200078e00ffULL, 0x0000000c57677812ULL, 0x000fe200078ec0ffULL,
0x00858000565e7984ULL, 0x0002a20000000800ULL, 0x000000086a577824ULL, 0x000fe200078e00ffULL,
0x0000100055557812ULL, 0x000fe400078ec0ffULL, 0xfffffff85b687812ULL, 0x000fe400078ee25aULL,
0x0000018008557810ULL, 0x000fc40007ffe055ULL, 0xfffffff8575a7812ULL, 0x000fe400078ee26aULL,
0x000000086a6c7810ULL, 0x040fe40007ffe0ffULL, 0x000000186a747810ULL, 0x040fe40007ffe0ffULL,
0x000000106a727810ULL, 0x000fe20007ffe0ffULL, 0x000000086c5b7824ULL, 0x000fe200078e00ffULL,
0x000000036a597810ULL, 0x000fe20007ffe0ffULL, 0x00000008745d7824ULL, 0x000fe200078e00ffULL,
0x0000000253537810ULL, 0x000fc40007ffe0ffULL, 0xfffffff866667812ULL, 0x000fe400078ee259ULL,
0xfffffff85d5c7812ULL, 0x000fe400078ee274ULL, 0x000000056a597810ULL, 0x000fe40007ffe0ffULL,
0x0000030053007a0cULL, 0x000fe20003f06070ULL, 0x000000105c5c7824ULL, 0x000fe200078e0255ULL,
0xfffffff86e6e7812ULL, 0x000fc600078ee259ULL, 0x00000001675d7824ULL, 0x000fe400078e025cULL,
0x00000010685c7824ULL, 0x100fe400078e0255ULL, 0x0000005809567221ULL, 0x002fe20000010100ULL,
0xfffffff85b587812ULL, 0x000fe200078ee26cULL, 0x00000008725b7824ULL, 0x000fe200078e00ffULL,
0x000000005d657984ULL, 0x000fe20000000800ULL, 0x3fb8aa3b56577820ULL, 0x000fe40000410000ULL,
0x000000105a567824ULL, 0x100fe200078e0255ULL, 0xfffffff85b5a7812ULL, 0x000fe200078ee272ULL,
0x0000001058587824ULL, 0x000fe200078e0255ULL, 0x000000066a5b7810ULL, 0x000fe20007ffe0ffULL,
0x0000005700577308ULL, 0x000ea20000000800ULL, 0x0000005667567210ULL, 0x040fe20007ffe0ffULL,
0x0000000167587824ULL, 0x000fe200078e0258ULL, 0xfffffff870707812ULL, 0x000fe200078ee25bULL,
0x000000105a5a7824ULL, 0x000fc400078e0255ULL, 0x00000010665b7824ULL, 0x000fe200078e0255ULL,
0x0000000056567984ULL, 0x000e620000000800ULL, 0x00000001675a7824ULL, 0x040fe400078e025aULL,
0x00000001675b7824ULL, 0x040fe200078e025bULL, 0x0000000058637984ULL, 0x0007220000000800ULL,
0x00000001675c7824ULL, 0x000fc600078e025cULL, 0x000000005a647984ULL, 0x000f220000000800ULL,
0x0000005e576b7220ULL, 0x004fe20000410000ULL, 0xffffffff6a5e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001060577824ULL, 0x100fe200078e0255ULL, 0x000000005c5d7984ULL, 0x000fe20000000800ULL,
0x0000001062587824ULL, 0x108fe200078e0255ULL, 0xfffffff85f607812ULL, 0x000fe200078ee25eULL,
0x00000010705f7824ULL, 0x100fe200078e0255ULL, 0x0000005767577210ULL, 0x040fe20007ffe0ffULL,
0x0000000167597824ULL, 0x040fe200078e0258ULL, 0x00001f6c6b6c7589ULL, 0x000ea200000e0000ULL,
0x000000106e5e7824ULL, 0x000fe200078e0255ULL, 0x0000005560617211ULL, 0x000fe200078e20ffULL,
0x0000000167607824ULL, 0x040fe200078e025fULL, 0x0000000057587984ULL, 0x000fe20000000800ULL,
0x00000001675e7824ULL, 0x000fc400078e025eULL, 0x0000000167617824ULL, 0x000fe200078e0261ULL,
0x00000000595a7984ULL, 0x000fe20000000800ULL, 0x000000546b547221ULL, 0x000fc60000010000ULL,
0x000000005b557984ULL, 0x000fe80000000800ULL, 0x00001f6a6b6a7589ULL, 0x000ee800000e0000ULL,
0x00001f746b6e7589ULL, 0x000ee200000e0000ULL, 0x20000056ff677230ULL, 0x102fe40000004100ULL,
0x30000056ff627230ULL, 0x000fe20000004100ULL, 0x00001f726b6d7589ULL, 0x000e6200000e0000ULL,
0x20000063ff697230ULL, 0x010fc60000004100ULL, 0x0000000060567984ULL, 0x000f220000000800ULL,
0x20000064ff667230ULL, 0x100fe20000004100ULL, 0x0000006c694e7223ULL, 0x004fe2000001004eULL,
0x20000065ff697230ULL, 0x000fe20000004100ULL, 0x000000005e5f7984ULL, 0x000ea20000000800ULL,
0x30000064ff647230ULL, 0x000fe40000004100ULL, 0x2000005dff687230ULL, 0x100fe40000004100ULL,
0x3000005dff5d7230ULL, 0x000fe20000004100ULL, 0x0000006a67507223ULL, 0x088fe20000010050ULL,
0x30000063ff677230ULL, 0x000fe20000004100ULL, 0x0000006a624f7223ULL, 0x000fe2000001004fULL,
0x0004000057637984ULL, 0x000ee20000000800ULL, 0x0000006e69307223ULL, 0x000fe20000010030ULL,
0x30000065ff697230ULL, 0x000fe20000004100ULL, 0x0000006c67327223ULL, 0x000fe20000010032ULL,
0x0000000061627984ULL, 0x000ee20000000800ULL, 0x20000058ff657230ULL, 0x100fe20000004100ULL,
0x0000006d664d7223ULL, 0x082fe2000001004dULL, 0x30000058ff677230ULL, 0x000fe20000004100ULL,
0x0000006d64317223ULL, 0x000fe20000010031ULL, 0x000400005b587984ULL, 0x000e620000000800ULL,
0x0000006a652e7223ULL, 0x080fe2000001002eULL, 0x2000005aff667230ULL, 0x100fe20000004100ULL,
0x0000006a674c7223ULL, 0x080fe2000001004cULL, 0x000400005c657984ULL, 0x000e620000000800ULL,
0x3000005aff677230ULL, 0x000fe20000004100ULL, 0x0000006a5d407223ULL, 0x080fe20000010040ULL,
0x20000055ff5a7230ULL, 0x100fe20000004100ULL, 0x0004000059647984ULL, 0x000e620000000800ULL,
0x30000055ff557230ULL, 0x000fe20000004100ULL, 0x0000006a664b7223ULL, 0x000fc4000001004bULL,
0x000400005e667984ULL, 0x000e620000000800ULL, 0x0000006a67367223ULL, 0x080fe40000010036ULL,
0x0000006a5a477223ULL, 0x080fe40000010047ULL, 0x0000006a55447223ULL, 0x080fe20000010044ULL,
0x20000056ff5a7230ULL, 0x110fe20000004100ULL, 0x0004000060557984ULL, 0x000f220000000800ULL,
0x30000056ff677230ULL, 0x000fe20000004100ULL, 0x0000006a68437223ULL, 0x080fe20000010043ULL,
0x2000005fff5d7230ULL, 0x104fe20000004100ULL, 0x0004000061567984ULL, 0x000ea20000000800ULL,
0x0000006a5a3b7223ULL, 0x080fe2000001003bULL, 0x3000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000006a67387223ULL, 0x080fe20000010038ULL, 0x00080000575a7984ULL, 0x000ea20000000800ULL,
0x0000006a5d207223ULL, 0x000fc40000010020ULL, 0x0000006a5f3c7223ULL, 0x000fe2000001003cULL,
0x30000063ff687230ULL, 0x108fe20000004100ULL, 0x000c0000575f7984ULL, 0x000ee20000000800ULL,
0x20000063ff677230ULL, 0x000fe20000004100ULL, 0x0000006e69467223ULL, 0x000fe20000010046ULL,
0x20000062ff5d7230ULL, 0x100fe20000004100ULL, 0x0000006c68497223ULL, 0x080fe20000010049ULL,
0x30000062ff627230ULL, 0x000fe20000004100ULL, 0x000800005b577984ULL, 0x000fe20000000800ULL,
0x0000006c67347223ULL, 0x000fe20000010034ULL, 0x20000058ff687230ULL, 0x102fe20000004100ULL,
0x0000006a5d4a7223ULL, 0x080fe2000001004aULL, 0x30000058ff637230ULL, 0x000fe20000004100ULL,
0x00080000595d7984ULL, 0x000e620000000800ULL, 0x20000065ff587230ULL, 0x100fe20000004100ULL,
0x0000006a62357223ULL, 0x000fe20000010035ULL, 0x30000065ff657230ULL, 0x000fe20000004100ULL,
0x0000006c68457223ULL, 0x080fe20000010045ULL, 0x20000064ff627230ULL, 0x100fe20000004100ULL,
0x0000006c583f7223ULL, 0x080fe2000001003fULL, 0x30000064ff647230ULL, 0x000fe20000004100ULL,
0x000800005c587984ULL, 0x000e620000000800ULL, 0x30000066ff677230ULL, 0x000fe20000004100ULL,
0x0000006c621b7223ULL, 0x000fc4000001001bULL, 0x0000006c642f7223ULL, 0x080fe2000001002fULL,
0x20000066ff647230ULL, 0x000fe20000004100ULL, 0x000c000059627984ULL, 0x0004620000000800ULL,
0x0000006c63267223ULL, 0x080fe20000010026ULL, 0x20000055ff667230ULL, 0x110fe20000004100ULL,
0x0000006c65247223ULL, 0x080fe20000010024ULL, 0x30000055ff687230ULL, 0x000fe20000004100ULL,
0x000c00005b637984ULL, 0x000f220000000800ULL, 0x0000006c643d7223ULL, 0x080fe2000001003dULL,
0x20000056ff597230ULL, 0x104fe40000004100ULL, 0x000800005e557984ULL, 0x000ea20000000800ULL,
0x30000056ff567230ULL, 0x000fe20000004100ULL, 0x0000006c66257223ULL, 0x000fc40000010025ULL,
0x000c00005e5b7984ULL, 0x000ea20000000800ULL, 0x0000006c591c7223ULL, 0x080fe2000001001cULL,
0x2000005aff597230ULL, 0x100fe20000004100ULL, 0x0000006c56337223ULL, 0x080fe20000010033ULL,
0x000c00005c647984ULL, 0x0002a20000000800ULL, 0x2000005fff657230ULL, 0x108fe20000004100ULL,
0x0000006c673a7223ULL, 0x000fe2000001003aULL, 0x3000005fff667230ULL, 0x000fe20000004100ULL,
0x0008000060567984ULL, 0x000ee20000000800ULL, 0x0000006d59187223ULL, 0x080fe40000010018ULL,
0x0000006e652c7223ULL, 0x000fe2000001002cULL, 0x3000005aff5c7230ULL, 0x002fe20000004100ULL,
0x0008000061597984ULL, 0x000e620000000800ULL, 0x3000005dff5e7230ULL, 0x100fe20000004100ULL,
0x0000006c68377223ULL, 0x000fe20000010037ULL, 0x2000005dff5f7230ULL, 0x000fe20000004100ULL,
0x000c0000605a7984ULL, 0x0008620000000800ULL, 0x0000006d5c2d7223ULL, 0x080fe2000001002dULL,
0x20000057ff5d7230ULL, 0x100fe20000004100ULL, 0x0000006d5e417223ULL, 0x080fe20000010041ULL,
0x000c0000615c7984ULL, 0x000e620000000800ULL, 0x30000057ff5e7230ULL, 0x000fe20000004100ULL,
0x0000006e662b7223ULL, 0x080fe2000001002bULL, 0x20000058ff577230ULL, 0x100fe20000004100ULL,
0x0000006d5d3e7223ULL, 0x080fe2000001003eULL, 0x30000058ff587230ULL, 0x000fe20000004100ULL,
0x0000006d5f2a7223ULL, 0x080fe2000001002aULL, 0x20000062ff657230ULL, 0x100fe20000004100ULL,
0x0000006d57227223ULL, 0x080fe20000010022ULL, 0x30000062ff627230ULL, 0x000fe20000004100ULL,
0x0000006d581f7223ULL, 0x000fe2000001001fULL, 0x20000063ff607230ULL, 0x010fe20000004100ULL,
0x0000006e65287223ULL, 0x000fc40000010028ULL, 0x0000006e62277223ULL, 0x080fe20000010027ULL,
0x20000055ff577230ULL, 0x104fe20000004100ULL, 0x0000006d5e297223ULL, 0x080fe20000010029ULL,
0x30000055ff587230ULL, 0x000fe20000004100ULL, 0x0000006e60217223ULL, 0x080fe20000010021ULL,
0x2000005bff557230ULL, 0x000fe20000004100ULL, 0x0000006d571e7223ULL, 0x080fe2000001001eULL,
0x30000063ff627230ULL, 0x000fe20000004100ULL, 0x0000006d581d7223ULL, 0x080fe2000001001dULL,
0x20000064ff5d7230ULL, 0x100fe20000004100ULL, 0x0000006e55487223ULL, 0x080fe20000010048ULL,
0x30000064ff647230ULL, 0x000fe20000004100ULL, 0x0000006e62237223ULL, 0x080fe20000010023ULL,
0x20000056ff587230ULL, 0x108fe20000004100ULL, 0x0000006e5d427223ULL, 0x080fe20000010042ULL,
0x30000056ff557230ULL, 0x000fe20000004100ULL, 0x0000006e64397223ULL, 0x080fe20000010039ULL,
0x3000005bff5b7230ULL, 0x000fe20000004100ULL, 0x0000006d58117223ULL, 0x080fe20000010011ULL,
0x30000059ff587230ULL, 0x102fe20000004100ULL, 0x0000006d551a7223ULL, 0x080fe2000001001aULL,
0x2000005aff567230ULL, 0x100fe20000004100ULL, 0x0000006e5b527223ULL, 0x080fe20000010052ULL,
0x3000005aff5a7230ULL, 0x000fe20000004100ULL, 0x0000006d58137223ULL, 0x000fe20000010013ULL,
0x2000005cff557230ULL, 0x100fe20000004100ULL, 0x0000006e56197223ULL, 0x080fe20000010019ULL,
0x20000059ff567230ULL, 0x000fe20000004100ULL, 0x0000006e5a517223ULL, 0x080fe20000010051ULL,
0x3000005cff577230ULL, 0x000fe20000004100ULL, 0x0000006e55127223ULL, 0x000fc40000010012ULL,
0x0000006d56157223ULL, 0x000fe40000010015ULL, 0x0000006e570e7223ULL, 0x000fe2000001000eULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffed3000007947ULL, 0x000fea000383ffffULL,
0x000000ff1400720cULL, 0x000fe20003f05270ULL, 0x0000018000007945ULL, 0x000fd80003800000ULL,
0x0000008017048824ULL, 0x000fc800078e0210ULL, 0x000000010f038824ULL, 0x000fe400078e0204ULL,
0x00000001100f7824ULL, 0x000fc600078e020fULL, 0x0089805403008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x008980000f047984ULL, 0x000e680000000800ULL,
0x008a00000f057984ULL, 0x000ea20000000800ULL, 0x00000004ff047221ULL, 0x002fc80000010000ULL,
0x0000000504047221ULL, 0x004fca0000010000ULL, 0x0180000004057810ULL, 0x000fc80007ffe0ffULL,
0x7f80000005057812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0500780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e0004ULL, 0x0000d5f000067802ULL, 0x000fc40000000f00ULL,
0x0000d4d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff057224ULL, 0x00efe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000400057308ULL, 0x000e640000001000ULL,
0xbf80000004037423ULL, 0x002fc80000000005ULL, 0x800000ff03067221ULL, 0x000fc80000010100ULL,
0x0000000605057223ULL, 0x000fc40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e680000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000803567811ULL, 0x002fc400078ff0ffULL, 0x0000001003587811ULL, 0x040fe400078ff0ffULL,
0x00000002ff547819ULL, 0x000fe20000011603ULL, 0x00001f5605047589ULL, 0x000e6200000e0000ULL,
0x00000018035a7811ULL, 0x000fe200078ff0ffULL, 0x0000000858597824ULL, 0x000fe400078e00ffULL,
0x00001f58050a7589ULL, 0x000ea200000e0000ULL, 0x0000000854557824ULL, 0x040fe400078e00ffULL,
0x0000000854537824ULL, 0x000fe200078e00ffULL, 0x00001f5405077589ULL, 0x000fe200000e0000ULL,
0x000000085a5b7824ULL, 0x000fe200078e00ffULL, 0xfffffff859597812ULL, 0x000fe200078ee258ULL,
0x0000000856577824ULL, 0x000fe200078e00ffULL, 0x00001f5a05057589ULL, 0x000ee400000e0000ULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee25aULL, 0x0000001059597824ULL, 0x000fe200078e0202ULL,
0xfffffff857577812ULL, 0x000fc600078ee256ULL, 0x000000105b5b7824ULL, 0x000fe200078e0202ULL,
0x0000000257577211ULL, 0x000fe200078e20ffULL, 0x0000004e044e7220ULL, 0x042fe40000410000ULL,
0x00000032040d7220ULL, 0x000fe20000410000ULL, 0x0000000354327810ULL, 0x000fe20007ffe0ffULL,
0x0000003404347220ULL, 0x040fe40000410000ULL, 0x0000004904497220ULL, 0x040fe20000410000ULL,
0x0000004e0d0d723eULL, 0x000fe200000000ffULL, 0x0000001b041b7220ULL, 0x000fc40000410000ULL,
0x0000002f04067220ULL, 0x000fe20000410000ULL, 0x00000001542f7810ULL, 0x000fe20007ffe0ffULL,
0x0000004504457220ULL, 0x040fe20000410000ULL, 0x000000344934723eULL, 0x000fe200000000ffULL,
0x0000002604267220ULL, 0x000fe20000410000ULL, 0x0000001b0606723eULL, 0x000fe200000000ffULL,
0x0000003f043f7220ULL, 0x040fe40000410000ULL, 0x0000002404247220ULL, 0x000fe20000410000ULL,
0x000000452626723eULL, 0x000fe200000000ffULL, 0x0000003d043d7220ULL, 0x000fc40000410000ULL,
0x0000003a043a7220ULL, 0x000fe20000410000ULL, 0x0000003f2424723eULL, 0x000fe200000000ffULL,
0x0000002504257220ULL, 0x040fe40000410000ULL, 0x0000003704087220ULL, 0x000fe20000410000ULL,
0x0000003d3a3a723eULL, 0x000fe200000000ffULL, 0x0000001c041c7220ULL, 0x040fe40000410000ULL,
0x0000003304337220ULL, 0x000fe20000410000ULL, 0x000000250808723eULL, 0x000fe200000000ffULL,
0x0000004d0a4d7220ULL, 0x004fc40000410000ULL, 0x000000310a047220ULL, 0x000fe20000410000ULL,
0x0000000254317810ULL, 0x000fe20007ffe0ffULL, 0x000000180a187220ULL, 0x040fe20000410000ULL,
0x0000001c331c723eULL, 0x000fe200000000ffULL, 0x0000002d0a2d7220ULL, 0x000fe20000410000ULL,
0x0000004d0404723eULL, 0x000fe200000000ffULL, 0x0000002a0a2a7220ULL, 0x040fe40000410000ULL,
0x000000410a417220ULL, 0x040fe20000410000ULL, 0x000000182d18723eULL, 0x000fe200000000ffULL,
0x0000003e0a3e7220ULL, 0x000fc40000410000ULL, 0x000000290a297220ULL, 0x040fe20000410000ULL,
0x0000002a412a723eULL, 0x000fe200000000ffULL, 0x000000220a227220ULL, 0x040fe40000410000ULL,
0x0000001f0a1f7220ULL, 0x040fe20000410000ULL, 0x0000003e2929723eULL, 0x000fe200000000ffULL,
0x0000001e0a1e7220ULL, 0x040fe40000410000ULL, 0x0000001d0a1d7220ULL, 0x040fe20000410000ULL,
0x000000221f1f723eULL, 0x000fe200000000ffULL, 0x000000110a117220ULL, 0x000fc40000410000ULL,
0x0000001a0a1a7220ULL, 0x040fe20000410000ULL, 0x0000001e1d1d723eULL, 0x000fe200000000ffULL,
0x000000150a157220ULL, 0x040fe40000410000ULL, 0x000000130a0a7220ULL, 0x000fe20000410000ULL,
0x000000111a11723eULL, 0x000fe200000000ffULL, 0x0000003005307220ULL, 0x048fe40000410000ULL,
0x00000046050f7220ULL, 0x040fe20000410000ULL, 0x000000150a0a723eULL, 0x000fe200000000ffULL,
0x0000002c052c7220ULL, 0x000fc40000410000ULL, 0x0000002b052b7220ULL, 0x000fe20000410000ULL,
0x000000300f0f723eULL, 0x000fe200000000ffULL, 0x0000002805287220ULL, 0x040fe40000410000ULL,
0x0000002705277220ULL, 0x000fe20000410000ULL, 0x0000002c2b2b723eULL, 0x000fe200000000ffULL,
0x0000002105217220ULL, 0x040fe40000410000ULL, 0x00000023050c7220ULL, 0x040fe20000410000ULL,
0x0000000554237810ULL, 0x000fe20007ffe0ffULL, 0x0000004205427220ULL, 0x000fe20000410000ULL,
0x000000282727723eULL, 0x000fe200000000ffULL, 0x0000003905397220ULL, 0x040fe20000410000ULL,
0x000000210c0c723eULL, 0x000fe200000000ffULL, 0x0000004805487220ULL, 0x000fc40000410000ULL,
0x0000005205137220ULL, 0x000fe20000410000ULL, 0x000000423939723eULL, 0x000fe200000000ffULL,
0x0000001905197220ULL, 0x040fe40000410000ULL, 0x0000005105107220ULL, 0x000fe20000410000ULL,
0x000000481313723eULL, 0x000fe200000000ffULL, 0x0000001205127220ULL, 0x040fe40000410000ULL,
0x0000000e05057220ULL, 0x000fe20000410000ULL, 0x00000004540e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000854377824ULL, 0x000fe200078e00ffULL, 0x000000191010723eULL, 0x000fe200000000ffULL,
0x0000005007507220ULL, 0x000fe20000410000ULL, 0x000000120505723eULL, 0x000fe200000000ffULL,
0x0000004f074f7220ULL, 0x000fe20000410000ULL, 0xfffffff837377812ULL, 0x000fe200078ee20eULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0xffffffff540e7810ULL, 0x000fe20007ffe0ffULL,
0x0000004c07097220ULL, 0x000fe20000410000ULL, 0x000000504f4f723eULL, 0x000fe200000000ffULL,
0x0000004b074b7220ULL, 0x000fc40000410000ULL, 0x0000003607367220ULL, 0x000fe20000410000ULL,
0x0000002e0909723eULL, 0x000fe200000000ffULL, 0x0000004707477220ULL, 0x040fe40000410000ULL,
0x0000004407447220ULL, 0x040fe20000410000ULL, 0x0000004b3636723eULL, 0x000fe200000000ffULL,
0x0000004307437220ULL, 0x040fe40000410000ULL, 0x0000004007407220ULL, 0x040fe20000410000ULL,
0x000000474444723eULL, 0x000fe200000000ffULL, 0x0000002007207220ULL, 0x000fc40000410000ULL,
0x0000003c070b7220ULL, 0x040fe20000410000ULL, 0x00000003543c7819ULL, 0x000fe200000006ffULL,
0x0000003b073b7220ULL, 0x040fe20000410000ULL, 0x000000434040723eULL, 0x000fe200000000ffULL,
0x0000003807387220ULL, 0x040fe20000410000ULL, 0xfffffff83c517812ULL, 0x000fe200078ee223ULL,
0x0000004a074a7220ULL, 0x000fe20000410000ULL, 0xfffffff855237812ULL, 0x000fe200078ee254ULL,
0x0000003507077220ULL, 0x000fe20000410000ULL, 0xfffffff855557812ULL, 0x000fe200078ee20eULL,
0x0000000854357824ULL, 0x040fe200078e00ffULL, 0x00000002030e7819ULL, 0x000fe200000006ffULL,
0x00000008544c7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c2f7812ULL, 0x000fe200078ee22fULL,
0x0000001023237824ULL, 0x000fe200078e0202ULL, 0xfffffff835357812ULL, 0x000fe200078ee232ULL,
0x0000001037377824ULL, 0x100fe200078e0202ULL, 0x0000000654327810ULL, 0x000fe20007ffe0ffULL,
0x000000102f2f7824ULL, 0x100fe200078e0202ULL, 0xfffffff84c317812ULL, 0x000fe200078ee231ULL,
0x0000001035357824ULL, 0x000fe200078e0202ULL, 0xfffffff853537812ULL, 0x000fe200078ee232ULL,
0x0000001051517824ULL, 0x100fe200078e0202ULL, 0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL,
0x0000001031317824ULL, 0x100fe200078e0202ULL, 0x000000200b0b723eULL, 0x000fe200000000ffULL,
0x0000001053537824ULL, 0x100fe200078e0202ULL, 0x0000003b3838723eULL, 0x000fe200000000ffULL,
0x0000001055557824ULL, 0x000fe200078e0202ULL, 0x0000004a0707723eULL, 0x000fe200000000ffULL,
0x0000000123027824ULL, 0x000fe200078e020eULL, 0x000000530e537210ULL, 0x040fe20007ffe0ffULL,
0x000000010e2f7824ULL, 0x000fc400078e022fULL, 0x000000010e317824ULL, 0x040fe200078e0231ULL,
0x0000004f02007388ULL, 0x000fe20000000800ULL, 0x000000010e357824ULL, 0x040fe400078e0235ULL,
0x000000010e377824ULL, 0x040fe200078e0237ULL, 0x000000092f007388ULL, 0x000fe20000000800ULL,
0x000000010e127824ULL, 0x040fe400078e0251ULL, 0x000000010e557824ULL, 0x040fe200078e0255ULL,
0x0000003631007388ULL, 0x000fe20000000800ULL, 0x000000010e1a7824ULL, 0x000fc400078e0257ULL,
0x000000010e597824ULL, 0x040fe200078e0259ULL, 0x0000004435007388ULL, 0x000fe20000000800ULL,
0x000000010e0e7824ULL, 0x000fc600078e025bULL, 0x0000004037007388ULL, 0x000fe80000000800ULL,
0x0000000b12007388ULL, 0x000fe80000000800ULL, 0x0000003853007388ULL, 0x000fe80000000800ULL,
0x0000000755007388ULL, 0x0003e80000000800ULL, 0x0000000d1a007388ULL, 0x000fe80000000800ULL,
0x000400342f007388ULL, 0x000fe20000000800ULL, 0x0000000116077824ULL, 0x002fc600078e0203ULL,
0x0004000631007388ULL, 0x000fe20000000800ULL, 0x0000001007077824ULL, 0x000fc600078e0200ULL,
0x0004002635007388ULL, 0x000fe80000000800ULL, 0x0004002437007388ULL, 0x000fe80000000800ULL,
0x0004003a12007388ULL, 0x000fe80000000800ULL, 0x0004000853007388ULL, 0x000fe80000000800ULL,
0x0004001c55007388ULL, 0x000fe80000000800ULL, 0x0000000459007388ULL, 0x000fe80000000800ULL,
0x000800182f007388ULL, 0x000fe80000000800ULL, 0x0008002a31007388ULL, 0x000fe80000000800ULL,
0x0008002935007388ULL, 0x000fe80000000800ULL, 0x0008001f37007388ULL, 0x000fe80000000800ULL,
0x0008001d12007388ULL, 0x000fe80000000800ULL, 0x0008001153007388ULL, 0x000fe80000000800ULL,
0x0008000a55007388ULL, 0x000fe80000000800ULL, 0x0000000f0e007388ULL, 0x000fe80000000800ULL,
0x000c002b2f007388ULL, 0x000fe80000000800ULL, 0x000c002731007388ULL, 0x000fe80000000800ULL,
0x000c000c35007388ULL, 0x000fe80000000800ULL, 0x000c003937007388ULL, 0x000fe80000000800ULL,
0x000c001312007388ULL, 0x000fe80000000800ULL, 0x000c001053007388ULL, 0x000fe80000000800ULL,
0x000c000555007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000007087984ULL, 0x000e680000000c00ULL, 0x00040000071c7984ULL, 0x000ea80000000c00ULL,
0x00080000070c7984ULL, 0x000ee80000000c00ULL, 0x000c000007287984ULL, 0x000f280000000c00ULL,
0x0010000007187984ULL, 0x000ee80000000c00ULL, 0x0014000007207984ULL, 0x000f280000000c00ULL,
0x0018000007247984ULL, 0x000f280000000c00ULL, 0x001c0000072c7984ULL, 0x000f220000000c00ULL,
0x200000ff0b0b7230ULL, 0x002fc40000000000ULL, 0x200000ff0a0a7230ULL, 0x000fe40000000000ULL,
0x200000ff09097230ULL, 0x000fe40000000000ULL, 0x200000ff08087230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x004fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fc40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff0f0f7230ULL, 0x008fe40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff2b2b7230ULL, 0x010fc40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fe40000000000ULL,
0x200000ff29297230ULL, 0x000fe40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x0000001b0b0b7230ULL, 0x000fe40000000000ULL, 0x0000001a0a0a7230ULL, 0x000fe40000000000ULL,
0x0000001909097230ULL, 0x000fc40000000000ULL, 0x0000001808087230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x000fe40000000000ULL, 0x000000221e1e7230ULL, 0x000fe20000000000ULL,
0x0000000807007388ULL, 0x000fe20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fe40000000000ULL, 0x000000270f0f7230ULL, 0x000fc40000000000ULL,
0x000000260e0e7230ULL, 0x000fe20000000000ULL, 0x0004001c07007388ULL, 0x000fe20000000c00ULL,
0x000000250d0d7230ULL, 0x000fe40000000000ULL, 0x000000240c0c7230ULL, 0x000fe40000000000ULL,
0x0000002f2b2b7230ULL, 0x000fe40000000000ULL, 0x0000002e2a2a7230ULL, 0x000fe20000000000ULL,
0x0008000c07007388ULL, 0x000fe20000000c00ULL, 0x0000002d29297230ULL, 0x000fc40000000000ULL,
0x0000002c28287230ULL, 0x000fca0000000000ULL, 0x000c002807007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff1700720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff027819ULL, 0x000fc80000011603ULL,
0x000000810200720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ee20000002700ULL, 0x0000000102047824ULL, 0x000fe200078e0203ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x0000000283027211ULL, 0x000fe200078e28ffULL,
0x00005a0000067ab9ULL, 0x000fe20000000800ULL, 0x00000020030d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000605057299ULL, 0x000fe2000800063fULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x0000580000067ab9ULL, 0x000fe20000000800ULL, 0x0000000703077812ULL, 0x000fc400078ec0ffULL,
0x0ffffff804057812ULL, 0x000fc600078ef803ULL, 0x0000000814077824ULL, 0x000fe400078e0207ULL,
0x0000001005047824ULL, 0x000fe200078e0200ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011602ULL, 0x0000000004087984ULL, 0x0045220000000c00ULL,
0x0000000182057824ULL, 0x000fe200078e0205ULL, 0x00000006040472a4ULL, 0x008fc6000f8e023fULL,
0x0000008502057224ULL, 0x000fc600078e0205ULL, 0x0000000485067c24ULL, 0x000fca000f8e02ffULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x004fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f4402ULL,
0x00000003ff027819ULL, 0x000fc6000001160dULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000810200720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0105f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d047824ULL, 0x104fe200078e0202ULL,
0x00000040030f7810ULL, 0x000fe20007ffe0ffULL, 0x0000002083027824ULL, 0x000fc600078e0202ULL,
0x0000000704047812ULL, 0x000fc800078ec0ffULL, 0x0ffffff804057812ULL, 0x000fe400078ef80dULL,
0x000000070d0d7812ULL, 0x000fc600078ec0ffULL, 0x0000001005077824ULL, 0x000fe200078e0200ULL,
0x0000000502057c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff027a19ULL, 0x000fe40000011602ULL,
0x0000000007087984ULL, 0x000ea20000000c00ULL, 0x0000000182057824ULL, 0x000fe200078e0205ULL,
0x0000000d140d7211ULL, 0x000fc600078e18ffULL, 0x0000008502057224ULL, 0x000fca00078e0205ULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f4402ULL,
0x00000003ff027819ULL, 0x000fc6000001160fULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x000000810200720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0045f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010f047824ULL, 0x104fe200078e0202ULL,
0x0000006003117810ULL, 0x002fe20007ffe0ffULL, 0x0000002083027824ULL, 0x000fe200078e0202ULL,
0x000000070f0d7812ULL, 0x000fc400078ec0ffULL, 0x0000000704047812ULL, 0x000fc600078ec0ffULL,
0x00000008140d7824ULL, 0x000fe200078e020dULL, 0x0ffffff804057812ULL, 0x000fca00078ef80fULL,
0x0000001005077824ULL, 0x000fe200078e0200ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011602ULL, 0x0000000007087984ULL, 0x000e620000000c00ULL,
0x0000000182057824ULL, 0x000fc800078e0205ULL, 0x0000008502057224ULL, 0x000fca00078e0205ULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f4402ULL,
0x00000003ff027819ULL, 0x000fc60000011611ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x000000810200720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0023f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000111047824ULL, 0x002fe200078e0202ULL,
0x0000000283027211ULL, 0x000fc400078e28ffULL, 0x00000080030f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x00000007110d7812ULL, 0x000fe400078ec0ffULL,
0x0ffffff804057812ULL, 0x000fc600078ef811ULL, 0x00000008140d7824ULL, 0x000fe400078e020dULL,
0x0000001005077824ULL, 0x000fe200078e0200ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011602ULL, 0x0000000007087984ULL, 0x000e620000000c00ULL,
0x0000000182057824ULL, 0x000fc800078e0205ULL, 0x0000008502057224ULL, 0x000fca00078e0205ULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f4402ULL,
0x00000003ff027819ULL, 0x000fc6000001160fULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x000000810200720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0023f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010f047824ULL, 0x102fe200078e0202ULL,
0x000000a003117810ULL, 0x000fe20007ffe0ffULL, 0x0000002083027824ULL, 0x000fe200078e0202ULL,
0x000000070f0d7812ULL, 0x000fc400078ec0ffULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x0000000d140d7211ULL, 0x000fe400078e18ffULL, 0x0ffffff804057812ULL, 0x000fca00078ef80fULL,
0x0000001005077824ULL, 0x000fe200078e0200ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011602ULL, 0x0000000007087984ULL, 0x000e620000000c00ULL,
0x0000000182057824ULL, 0x000fc800078e0205ULL, 0x0000008502057224ULL, 0x000fca00078e0205ULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f4402ULL,
0x00000003ff027819ULL, 0x000fc60000011611ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x000000810200720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0023f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000111047824ULL, 0x102fe200078e0202ULL,
0x000000c0030f7810ULL, 0x000fe20007ffe0ffULL, 0x0000002083027824ULL, 0x000fe200078e0202ULL,
0x00000007110d7812ULL, 0x000fc400078ec0ffULL, 0x0000000704047812ULL, 0x000fc600078ec0ffULL,
0x00000008140d7824ULL, 0x000fe200078e020dULL, 0x0ffffff804057812ULL, 0x000fca00078ef811ULL,
0x0000001005077824ULL, 0x000fe200078e0200ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011602ULL, 0x0000000007087984ULL, 0x000e620000000c00ULL,
0x0000000182057824ULL, 0x000fc800078e0205ULL, 0x0000008502057224ULL, 0x000fca00078e0205ULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff027224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f4402ULL,
0x00000003ff027819ULL, 0x000fc6000001160fULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x000000810200720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0023f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010f047824ULL, 0x002fe200078e0202ULL,
0x0000000283027211ULL, 0x000fc400078e28ffULL, 0x000000e0030d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x0000000502077c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff804057812ULL, 0x000fe400078ef80fULL, 0x00005a00ff027a19ULL, 0x000fe20000011602ULL,
0x0000000182077824ULL, 0x000fe200078e0207ULL, 0x00000003ff047819ULL, 0x000fe2000001160dULL,
0x0000001005057824ULL, 0x000fc400078e0200ULL, 0x0000008502077224ULL, 0x000fc600078e0207ULL,
0x0000000005087984ULL, 0x0002a40000000c00ULL, 0x00000007060c7210ULL, 0x000fe40007f1e0ffULL,
0x000000070f077812ULL, 0x000fc600078ec0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005c000c027a11ULL, 0x000fe200078040ffULL, 0x0000000814077824ULL, 0x000fe400078e0207ULL,
0x000000010d057824ULL, 0x002fe200078e0204ULL, 0x00005d000c037a11ULL, 0x000fe400000f4403ULL,
0x000000810400720cULL, 0x000fe40003f06070ULL, 0x0000000705057812ULL, 0x000fe200078ec0ffULL,
0x0000001007027825ULL, 0x000fc600078e0002ULL, 0xfffffff805057812ULL, 0x000fe400078ef80dULL,
0x0000000802007986ULL, 0x0043ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001005007824ULL, 0x000fe200078e0200ULL, 0x000000070d057812ULL, 0x000fe200078ec0ffULL,
0x0000002083047824ULL, 0x000fc600078e0204ULL, 0x0000000000087984ULL, 0x002e620000000c00ULL,
0x0000000514057211ULL, 0x000fe400078e18ffULL, 0x0000000504037c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fc60000011604ULL, 0x0000000182037824ULL, 0x000fc800078e0203ULL,
0x0000008504037224ULL, 0x000fca00078e0203ULL, 0x0000000306037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fca00000f4404ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff047819ULL, 0x000fca000001161eULL, 0x000000021d047824ULL, 0x000fca00078e0204ULL,
0x0000001a0400720cULL, 0x000fda0003f06070ULL, 0x00000002a2038824ULL, 0x000fc800078e00ffULL,
0x0000680003088a24ULL, 0x000fe400078e0204ULL, 0xffffffffff037424ULL, 0x000fe400078e00ffULL,
0x0000640008088625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000808038981ULL, 0x000ea2000c1e1900ULL, 0x000000011d027810ULL, 0x000fe20007ffe0ffULL,
0x000000401ea07824ULL, 0x000fe400078e00ffULL, 0x000000800c9f7824ULL, 0x000fe200078e00ffULL,
0x000000190200720cULL, 0x000fe20003f06070ULL, 0x0000008015027824ULL, 0x000fe200078e00ffULL,
0x01e60000ff067f8cULL, 0x002e62000c80043fULL, 0x000001001d0b7824ULL, 0x000fc400078e02a0ULL,
0x00000100ff0d7424ULL, 0x000fc600078e00ffULL, 0x0000004002387812ULL, 0x000fe200078ef80bULL,
0x0000009f030a7224ULL, 0x004fc800078e02ffULL, 0x000062000a087625ULL, 0x000fe200078e000dULL,
0x00000c7000008947ULL, 0x000fea0003800000ULL, 0x00000003ff377819ULL, 0x102fe4000001161cULL,
0x0000000b1b0a7217ULL, 0x000fe40007800000ULL, 0x00000004370d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000a0b187210ULL, 0x000fe20007ffe1ffULL, 0x00000001380a7824ULL, 0x040fe200078e0237ULL,
0x0000001037137810ULL, 0x000fe20007ffe0ffULL, 0x000000010d0b7824ULL, 0x000fe200078e021cULL,
0x00000008370f7810ULL, 0x000fe20007ffe0ffULL, 0x000000080d287824ULL, 0x040fe200078e00ffULL,
0x000000180d00720cULL, 0x000fe20003fa6070ULL, 0x00000001380c7824ULL, 0x000fe200078e020dULL,
0x00000018372b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000813217824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee20bULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000001437277810ULL, 0x000fc40007ffe0ffULL, 0x0000001c37337810ULL, 0x000fe20007ffe0ffULL,
0x000000010f0e7824ULL, 0x040fe200078e021cULL, 0x000000700a157812ULL, 0x000fe200078ef805ULL,
0x000000080f117824ULL, 0x000fe200078e00ffULL, 0x0000001c130a7210ULL, 0x000fe20007ffe0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000001508147210ULL, 0x000fe40007f1e0ffULL,
0xfffffff8212e7812ULL, 0x000fe200078ee20aULL, 0x00000001380a7824ULL, 0x000fe200078e020fULL,
0xfffffff8112a7812ULL, 0x000fe200078ee20eULL, 0x0000000109157824ULL, 0x000fe200000e060bULL,
0x0000000c37117810ULL, 0x000fe20007ffe0ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x000000700c177812ULL, 0x000fc400078ef805ULL, 0x000000181300720cULL, 0x080fe20003f06070ULL,
0x00000001110e7824ULL, 0x040fe200078e021cULL, 0x0000001708167210ULL, 0x000fe20007f3e0ffULL,
0x00000008111f7824ULL, 0x040fe200078e00ffULL, 0x000000700a217812ULL, 0x000fe200078ef805ULL,
0x00000001380c7824ULL, 0x040fe200078e0211ULL, 0x000000181100720cULL, 0x080fe20003f46070ULL,
0x0000000138127824ULL, 0x000fe200078e022bULL, 0xfffffff81f2c7812ULL, 0x000fe200078ee20eULL,
0x0000000109177824ULL, 0x000fe200008e060dULL, 0x0000002108207210ULL, 0x000fe20007f7e0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x000000180f00720cULL, 0x000fc40003f26070ULL,
0x0000000b09217210ULL, 0x000fe20001ffe4ffULL, 0x00000001380e7824ULL, 0x000fe200078e0213ULL,
0x000000700c237812ULL, 0x000fe200078ef805ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x00000020372d7810ULL, 0x040fe40007ffe0ffULL, 0x0000002308227210ULL, 0x000fe20007f9e0ffULL,
0x0000000138107824ULL, 0x000fe200078e0227ULL, 0x00000070120b7812ULL, 0x000fe200078ef805ULL,
0x00000001380a7824ULL, 0x000fe200078e0233ULL, 0x00000024372f7810ULL, 0x000fe20007ffe0ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000b08127210ULL, 0x000fc40007fde0ffULL,
0x0000002837317810ULL, 0x040fe20007ffe0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000700e1f7812ULL, 0x000fe400078ef805ULL, 0x0000003837357810ULL, 0x000fe20007ffe0ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000001f080e7210ULL, 0x000fe40007f7e0ffULL,
0x000020001e1f7811ULL, 0x000fe200078e70ffULL, 0x0000000109237824ULL, 0x000fe200020e060dULL,
0x00000070100d7812ULL, 0x100fe200078ef805ULL, 0x00000001370c7824ULL, 0x100fe200078e021cULL,
0x000000700a257812ULL, 0x000fe200078ef805ULL, 0x0000000109137824ULL, 0x040fe200030e0613ULL,
0x0000000d08107210ULL, 0x040fe20007f9e0ffULL, 0x00000001090f7824ULL, 0x000fe200018e060fULL,
0x0000002508247210ULL, 0x000fe20007fde0ffULL, 0x0000000127267824ULL, 0x100fe200078e021cULL,
0x000000070c0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000109117824ULL, 0x040fe200020e0611ULL,
0x0000002d380a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000109257824ULL, 0x000fe200030e060bULL,
0x000000182700720cULL, 0x0c0fe20003f66070ULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x000000183700720cULL, 0x000fe20003f86070ULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0ffffff80d0c7812ULL, 0x000fc400078ef81cULL, 0xfffffff827307812ULL, 0x000fe200078ee226ULL,
0x000000012b327824ULL, 0x040fe200078e021cULL, 0x000000700a277812ULL, 0x000fe200078ef805ULL,
0x000000100c297824ULL, 0x000fe400078e021fULL, 0x00000001380c7824ULL, 0x000fe200078e022fULL,
0x0000002708267210ULL, 0x000fe20007fde0ffULL, 0x00000001380a7824ULL, 0x000fe400078e0231ULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014297faeULL, 0x0003e2000e101c48ULL, 0x000000182b00720cULL, 0x000fc40003f86070ULL,
0x000000082b2b7824ULL, 0x000fe400078e00ffULL, 0x0000000109277824ULL, 0x000fe400030e060bULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff82b327812ULL, 0x000fc600078ee232ULL,
0x00000008332b7824ULL, 0x040fe200078e00ffULL, 0x000000700c157812ULL, 0x002fe200078ef805ULL,
0x0000001028297824ULL, 0x000fe200078e021fULL, 0x0000001c33287210ULL, 0x040fe40007ffe0ffULL,
0x00000015080c7210ULL, 0x000fe40007fde0ffULL, 0x0000000016297faeULL, 0x0003e2000e901c48ULL,
0x000000183300720cULL, 0x000fe40003fa6070ULL, 0x000000700a157812ULL, 0x000fe200078ef805ULL,
0x00000001090d7824ULL, 0x000fe200030e060dULL, 0x0000002c37337810ULL, 0x000fc40007ffe0ffULL,
0x0000001508147210ULL, 0x000fe40007fde0ffULL, 0xfffffff82b347812ULL, 0x000fe200078ee228ULL,
0x00000001380a7824ULL, 0x000fe200078e0233ULL, 0x0000001c2f287210ULL, 0x000fe20007ffe0ffULL,
0x000000102a2b7824ULL, 0x000fe400078e021fULL, 0x0000000109157824ULL, 0x000fe400030e060bULL,
0x000000102c297824ULL, 0x002fe200078e021fULL, 0x00000000202b7faeULL, 0x0003e2000c901c48ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x000000182d00720cULL, 0x000fc40003f26070ULL,
0x0000000022297faeULL, 0x0005e2000d101c48ULL, 0x000000012d177824ULL, 0x000fe200078e021cULL,
0x000000182f00720cULL, 0x000fe20003f46070ULL, 0x000000082d2a7824ULL, 0x000fe200078e00ffULL,
0x000000700a2d7812ULL, 0x000fe200078ef805ULL, 0x000000082f2f7824ULL, 0x000fc600078e00ffULL,
0x0000002d08167210ULL, 0x000fe20007fde0ffULL, 0x000000102e217824ULL, 0x002fe200078e021fULL,
0xfffffff82a0a7812ULL, 0x000fe400078ee217ULL, 0xfffffff82f287812ULL, 0x000fe200078ee228ULL,
0x0000000109177824ULL, 0x000fe200030e060bULL, 0x00000030372f7810ULL, 0x000fe20007ffe0ffULL,
0x00000010300b7824ULL, 0x100fe200078e021fULL, 0x000000000e217faeULL, 0x0003e2000c101c48ULL,
0x000000100a2b7824ULL, 0x100fe200078e021fULL, 0x0000002f380a7210ULL, 0x000fe20007ffe0ffULL,
0x0000001032237824ULL, 0x104fe200078e021fULL, 0x00000000100b7faeULL, 0x0005e2000d901c48ULL,
0x0000001034297824ULL, 0x100fe200078e021fULL, 0x000000182f00720cULL, 0x080fe20003f66070ULL,
0x00000010282d7824ULL, 0x000fe200078e021fULL, 0x0000000012237faeULL, 0x0007e2000e101c48ULL,
0x000000183300720cULL, 0x080fe20003f86070ULL, 0x000000082f207824ULL, 0x000fe200078e00ffULL,
0x0000003437217810ULL, 0x002fe20007ffe0ffULL, 0x0000000024297faeULL, 0x0003e2000e901c48ULL,
0x00000001310f7824ULL, 0x000fe200078e021cULL, 0x0000003c37377810ULL, 0x000fe20007ffe0ffULL,
0x000001000a0a7825ULL, 0x004fe200078e00ffULL, 0x00000000262b7faeULL, 0x0005e2000c901c48ULL,
0x000000183100720cULL, 0x000fc40003fa6070ULL, 0x0000000138107824ULL, 0x000fe200078e0221ULL,
0x000000000c2d7faeULL, 0x0009e2000d101c48ULL, 0x0000000831127824ULL, 0x008fe200078e00ffULL,
0x000000182100720cULL, 0x0c0fe20003f46070ULL, 0x0000000121137824ULL, 0x100fe200078e021cULL,
0x000000183500720cULL, 0x080fe20003f26070ULL, 0x0000000821227824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee20fULL, 0x0000000135217824ULL, 0x000fe200078e021cULL,
0x000000183700720cULL, 0x000fe20003f06070ULL, 0x0000000835247824ULL, 0x002fc400078e00ffULL,
0x0000000137237824ULL, 0x100fe200078e021cULL, 0x000000700a0d7812ULL, 0x010fe200078ef805ULL,
0x00000001330a7824ULL, 0x040fe400078e021cULL, 0x0000000833337824ULL, 0x000fe200078e00ffULL,
0x0000000d080e7210ULL, 0x000fe20007fde0ffULL, 0x00000100100c7825ULL, 0x000fc600078e00ffULL,
0xfffffff833187812ULL, 0x000fe200078ee20aULL, 0x00000001090f7824ULL, 0x000fe200030e060bULL,
0x000000700c117812ULL, 0x000fe200078ef805ULL, 0x000000012f0b7824ULL, 0x000fe200078e021cULL,
0x00000035380c7210ULL, 0x000fe20007ffe0ffULL, 0x0000000837267824ULL, 0x004fe200078e00ffULL,
0x0000001108107210ULL, 0x000fe40007fde0ffULL, 0xfffffff820207812ULL, 0x000fe200078ee20bULL,
0x000001000c0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff8221c7812ULL, 0x000fc400078ee213ULL,
0xfffffff824227812ULL, 0x000fe200078ee221ULL, 0x00000001380c7824ULL, 0x000fe200078e0237ULL,
0x000000700a257812ULL, 0x000fe200078ef805ULL, 0x0000000109117824ULL, 0x000fe200030e060dULL,
0xfffffff826247812ULL, 0x000fe200078ee223ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x00000025080a7210ULL, 0x000fc60007fde0ffULL, 0x0000001018137824ULL, 0x000fe200078e021fULL,
0x000000700c237812ULL, 0x000fe200078ef805ULL, 0x0000001012057824ULL, 0x100fe200078e021fULL,
0x0000000b090b7210ULL, 0x040fe200037fe4ffULL, 0x0000001020217824ULL, 0x100fe200078e021fULL,
0x0000002308087210ULL, 0x000fe20007fde0ffULL, 0x000000101c237824ULL, 0x100fe200078e021fULL,
0x0000000014057faeULL, 0x0003e2000e901c48ULL, 0x0000001022257824ULL, 0x100fe400078e021fULL,
0x00000010241f7824ULL, 0x000fe200078e021fULL, 0x0000000016137faeULL, 0x0003e2000e101c48ULL,
0x0000000109097824ULL, 0x000fc600030e060dULL, 0x000000000e217faeULL, 0x0003e8000d901c48ULL,
0x0000000010237faeULL, 0x0003e8000d101c48ULL, 0x000000000a257faeULL, 0x0003e8000c901c48ULL,
0x00000000081f7faeULL, 0x0003e2000c101c48ULL, 0x00000b3000007947ULL, 0x000fea0003800000ULL,
0x000000081c137811ULL, 0x042fe400078fe8ffULL, 0x0000000c1c2b7811ULL, 0x000fc400078fe8ffULL,
0x0000001c1c3f7811ULL, 0x040fe200078fe8ffULL, 0x00000001130b7824ULL, 0x140fe200078e021cULL,
0x000000041c117811ULL, 0x040fe200078fe8ffULL, 0x00000008130e7824ULL, 0x000fe200078e00ffULL,
0x000000141c2f7811ULL, 0x040fe200078fe8ffULL, 0x000000012b0c7824ULL, 0x140fe200078e021cULL,
0x000000181c317811ULL, 0x000fe200078fe8ffULL, 0x000000082b377824ULL, 0x000fe200078e00ffULL,
0xfffffff80e357812ULL, 0x000fe200078ee20bULL, 0x000000013f0d7824ULL, 0x100fe200078e021cULL,
0x0000000311337819ULL, 0x000fe200000006ffULL, 0x000000083f107824ULL, 0x000fe200078e00ffULL,
0x000000101c2d7811ULL, 0x000fe200078fe8ffULL, 0x00000001110a7824ULL, 0x000fe200078e021cULL,
0xfffffff837377812ULL, 0x000fe200078ee20cULL, 0x000000012f0b7824ULL, 0x040fe200078e021cULL,
0xfffffff810417812ULL, 0x000fe200078ee20dULL, 0x000000082f0e7824ULL, 0x000fe200078e00ffULL,
0x0000001c310c7210ULL, 0x040fe20007ffe0ffULL, 0x00000008313d7824ULL, 0x000fe200078e00ffULL,
0x000000241c0d7811ULL, 0x000fe200078fe8ffULL, 0x000000082d397824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee20aULL, 0x000000012d0a7824ULL, 0x000fe200078e021cULL,
0xfffffff80e3b7812ULL, 0x000fe200078ee20bULL, 0x000000080d177824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee20cULL, 0x000000010d0c7824ULL, 0x000fe200078e021cULL,
0x000000201c0b7811ULL, 0x040fe200078fe8ffULL, 0x000000012f127824ULL, 0x000fe200078e0238ULL,
0x000000281c0f7811ULL, 0x000fc400078fe8ffULL, 0x0000002c1c1f7811ULL, 0x040fe200078fe8ffULL,
0x000000080b157824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee20aULL,
0x000000010b0a7824ULL, 0x100fe200078e021cULL, 0x000000030f217819ULL, 0x040fe200000006ffULL,
0x000000010f0e7824ULL, 0x000fe200078e021cULL, 0xfffffff817167812ULL, 0x000fe200078ee20cULL,
0x000000011f107824ULL, 0x040fe200078e021cULL, 0x0000001c1c0c7211ULL, 0x000fe200078fe8ffULL,
0x000000081f237824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee20aULL,
0x00000001382a7824ULL, 0x040fe200078e020bULL, 0xfffffff821177812ULL, 0x000fe200078ee20eULL,
0x00000001382c7824ULL, 0x000fe200078e020fULL, 0x0000003c1c277811ULL, 0x040fe200078fe8ffULL,
0x00000001130e7824ULL, 0x100fe200078e0238ULL, 0x000000381c0a7211ULL, 0x040fe200078fe8ffULL,
0x0000000131137824ULL, 0x100fe200078e0238ULL, 0x000000301c217811ULL, 0x000fe200078fe8ffULL,
0x0000000827267824ULL, 0x000fe200078e00ffULL, 0x000000070c297812ULL, 0x000fe200078ec0ffULL,
0x00000001110c7824ULL, 0x000fe200078e0238ULL, 0xfffffff823207812ULL, 0x000fe200078ee210ULL,
0x000000012d117824ULL, 0x100fe200078e0238ULL, 0x000000341c237811ULL, 0x040fe200078fe8ffULL,
0x000000012b107824ULL, 0x000fe200078e0238ULL, 0x000000381c257811ULL, 0x000fe200078fe8ffULL,
0x00000001382d7824ULL, 0x040fe200078e021fULL, 0x0000001c230f7210ULL, 0x000fe20007ffe0ffULL,
0x00000001382b7824ULL, 0x000fe200078e020dULL, 0x0ffffff829297812ULL, 0x100fe200078ef81cULL,
0x00000001271f7824ULL, 0x100fe200078e021cULL, 0x000000383f187210ULL, 0x000fe20007ffe0ffULL,
0x00000001210d7824ULL, 0x000fc400078e021cULL, 0x0000000821227824ULL, 0x000fe400078e00ffULL,
0x000001000a0a7825ULL, 0x000fc800078e00ffULL, 0x0000000138347824ULL, 0x000fe400078e0223ULL,
0x0000000823247824ULL, 0x000fe200078e00ffULL, 0xfffffff826237812ULL, 0x000fe200078ee21fULL,
0x0000000125147824ULL, 0x000fe200078e021cULL, 0xfffffff8221c7812ULL, 0x000fe200078ee20dULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700a1f7812ULL, 0x000fe400078ef805ULL,
0x000020001e0a7811ULL, 0x000fe200078e70ffULL, 0x0000000138367824ULL, 0x000fc400078e0225ULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0x0000000a17457211ULL, 0x080fe200078e20ffULL,
0x0000000138327824ULL, 0x000fe200078e0221ULL, 0x000000700c177812ULL, 0x000fe200078ef805ULL,
0x0000001016437824ULL, 0x000fe200078e020aULL, 0xfffffff824217812ULL, 0x000fe200078ee20fULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff825227812ULL, 0x000fe400078ee214ULL,
0x0000001f08147210ULL, 0x040fe20007f1e0ffULL, 0x00000010413f7824ULL, 0x100fe200078e020aULL,
0x0000001708167210ULL, 0x000fe20007f3e0ffULL, 0x0000001015417824ULL, 0x100fe200078e020aULL,
0x0000000a33337211ULL, 0x000fe200078e20ffULL, 0x00000010214b7824ULL, 0x100fe200078e020aULL,
0x000000700e217812ULL, 0x000fe200078ef805ULL, 0x00000010291f7824ULL, 0x000fc400078e020aULL,
0x0000001035357824ULL, 0x100fe400078e020aULL, 0x0000001037377824ULL, 0x100fe400078e020aULL,
0x0000001039397824ULL, 0x100fe400078e020aULL, 0x000000103b3b7824ULL, 0x100fe400078e020aULL,
0x000000103d3d7824ULL, 0x100fe400078e020aULL, 0x0000001020477824ULL, 0x000fc400078e020aULL,
0x000000101c497824ULL, 0x100fe400078e020aULL, 0x00000010224d7824ULL, 0x100fe400078e020aULL,
0x00000010234f7824ULL, 0x000fe400078e020aULL, 0x0000000109157824ULL, 0x000fe200000e060bULL,
0x0000002108207210ULL, 0x000fe20007f1e0ffULL, 0x00000100100a7825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141f7faeULL, 0x0003e2000b901c48ULL,
0x0000000109177824ULL, 0x000fe200008e060dULL, 0x000000700a237812ULL, 0x000fe200078ef805ULL,
0x00000100110c7825ULL, 0x000fc600078e00ffULL, 0x0000000016337faeULL, 0x0003e2000b901c48ULL,
0x0000010012107825ULL, 0x000fe200078e00ffULL, 0x000000700c257812ULL, 0x000fc600078ef805ULL,
0x0000010013127825ULL, 0x000fe200078e00ffULL, 0x0000002508247210ULL, 0x000fc60007f3e0ffULL,
0x0000000109217824ULL, 0x040fe200000e060fULL, 0x0000002308227210ULL, 0x000fe20007f1e0ffULL,
0x0000000138387824ULL, 0x000fe200078e0227ULL, 0x0000007012297812ULL, 0x000fe200078ef805ULL,
0x0000000109257824ULL, 0x040fe200008e060dULL, 0x0000007010277812ULL, 0x100fe200078ef805ULL,
0x000001002a0c7825ULL, 0x000fe200078e00ffULL, 0x0000000b09237210ULL, 0x000fe200007fe4ffULL,
0x0000000020357faeULL, 0x0003e2000b901c48ULL, 0x0000002908287210ULL, 0x000fe20007f5e0ffULL,
0x00000100180a7825ULL, 0x000fe200078e00ffULL, 0x0000002708267210ULL, 0x000fe20007f1e0ffULL,
0x0000000022377faeULL, 0x0003e4000b901c48ULL, 0x000001002b0e7825ULL, 0x000fe200078e00ffULL,
0x000000700a2b7812ULL, 0x000fe200078ef805ULL, 0x0000000024397faeULL, 0x0003e4000b901c48ULL,
0x0000000109297824ULL, 0x000fe200010e0613ULL, 0x000000700e2f7812ULL, 0x100fe200078ef805ULL,
0x000001002d127825ULL, 0x000fe200078e00ffULL, 0x000000700c2d7812ULL, 0x000fc600078ef805ULL,
0x0000000109277824ULL, 0x040fe200000e0611ULL, 0x0000002b082a7210ULL, 0x000fe20007f1e0ffULL,
0x000001002c107825ULL, 0x000fe200078e00ffULL, 0x0000002d082c7210ULL, 0x000fe40007f3e0ffULL,
0x00000000263b7faeULL, 0x0003e2000b901c48ULL, 0x00000001092b7824ULL, 0x040fe200000e060bULL,
0x0000007010317812ULL, 0x000fe200078ef805ULL, 0x00000001092d7824ULL, 0x040fe200008e060dULL,
0x0000002f082e7210ULL, 0x000fe20007f1e0ffULL, 0x00000100320a7825ULL, 0x000fe200078e00ffULL,
0x00000070120d7812ULL, 0x000fe200078ef805ULL, 0x00000000283d7faeULL, 0x0003e2000b901c48ULL,
0x0000003108307210ULL, 0x040fe20007f5e0ffULL, 0x00000001092f7824ULL, 0x040fe200000e060fULL,
0x0000000d08127210ULL, 0x000fe20007f1e0ffULL, 0x00000100340c7825ULL, 0x000fe200078e00ffULL,
0x000000700a557812ULL, 0x000fe200078ef805ULL, 0x000000002a3f7faeULL, 0x0003e4000b901c48ULL,
0x0000000109317824ULL, 0x040fe200010e0611ULL, 0x000000700c537812ULL, 0x100fe200078ef805ULL,
0x00000100360e7825ULL, 0x000fe200078e00ffULL, 0x000000002c417faeULL, 0x0003e4000b901c48ULL,
0x00000053080c7210ULL, 0x000fe20007f3e0ffULL, 0x0000010038107825ULL, 0x000fe200078e00ffULL,
0x000000700e517812ULL, 0x000fe200078ef805ULL, 0x000000002e437faeULL, 0x0003e4000b901c48ULL,
0x0000000109137824ULL, 0x040fe200000e0613ULL, 0x0000007010057812ULL, 0x000fe200078ef805ULL,
0x00000001090d7824ULL, 0x000fe200008e060dULL, 0x00000055080a7210ULL, 0x040fe20007f1e0ffULL,
0x0000000030457faeULL, 0x0003e2000b901c48ULL, 0x00000051080e7210ULL, 0x000fc40007f5e0ffULL,
0x0000000508087210ULL, 0x000fe20007f7e0ffULL, 0x0000000012477faeULL, 0x0003e2000b901c48ULL,
0x0000000b090b7210ULL, 0x040fe200007fe4ffULL, 0x00000001090f7824ULL, 0x040fe400010e060fULL,
0x0000000109097824ULL, 0x000fe400018e0611ULL, 0x000000000a497faeULL, 0x0003e8000b901c48ULL,
0x000000000c4b7faeULL, 0x0003e8000b901c48ULL, 0x000000000e4d7faeULL, 0x0003e8000b901c48ULL,
0x00000000084f7faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fc40000015200ULL, 0x01e60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140bULL, 0x0000000a05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000205057819ULL, 0x000fc8000000120aULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000191d00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000009d7919ULL, 0x000e620000000000ULL,
0x00005800ff9a7624ULL, 0x000fe200078e00ffULL, 0x800058001b997a10ULL, 0x000fe20007ffe0ffULL,
0x00006800a2a27a24ULL, 0x000fe200078e02ffULL, 0x0001e6881e9c7811ULL, 0x040fe200078e18ffULL,
0x000000201e9e7824ULL, 0x000fe200078e00ffULL, 0x0000001f9a057810ULL, 0x040fe40007ffe0ffULL,
0xffffffff9a9b7810ULL, 0x000fe40007ffe0ffULL, 0x00000004ff057819ULL, 0x000fc40000011605ULL,
0x000000099a9a7810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff997819ULL, 0x000fe40000011699ULL,
0x0ffffffe05987812ULL, 0x000fc400078ec0ffULL, 0x000000011d067810ULL, 0x040fe20007ffe0ffULL,
0x00000100ffa17424ULL, 0x000fe200078e00ffULL, 0x000000a01d237211ULL, 0x004fe200078e40ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000190600720cULL, 0x000fe20003f06070ULL,
0x000000039f067224ULL, 0x000fe200078e02ffULL, 0x0000004023037812ULL, 0x000fc600078ec0ffULL,
0x0000620006067625ULL, 0x000fc800078e00a1ULL, 0x0000000102187824ULL, 0x000fc800078e0203ULL,
0x00000bb000008947ULL, 0x008fea0003800000ULL, 0x000000109d227824ULL, 0x002fe200078e00ffULL,
0x00000003ff1c7819ULL, 0x100fe4000001169dULL, 0x000000ff00097202ULL, 0x000fe40000000f00ULL,
0x0000007022227812ULL, 0x000fe200078ec0ffULL, 0x000000011c0b7824ULL, 0x040fe200078e0218ULL,
0x000000041c0e7810ULL, 0x000fe40007ffe0ffULL, 0x0000008022087812ULL, 0x000fe400078efcffULL,
0x000000081c107810ULL, 0x000fe20007ffe0ffULL, 0x000000010e037824ULL, 0x000fe200078e029dULL,
0x000000101c167810ULL, 0x000fe20007ffe0ffULL, 0x000001000b0a7825ULL, 0x000fe200078e0008ULL,
0x000000231b0c7217ULL, 0x000fc40007800000ULL, 0x0000000c1c147810ULL, 0x000fe20007ffe0ffULL,
0x000000080e207824ULL, 0x000fe200078e00ffULL, 0x0000000a06127210ULL, 0x000fe20007f1e0ffULL,
0x0000000110057824ULL, 0x000fe200078e029dULL, 0x00000018140f7210ULL, 0x000fe20007ffe0ffULL,
0x00000008102a7824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee203ULL,
0x00000001160d7824ULL, 0x000fe200078e029dULL, 0x000000141c267810ULL, 0x000fe20007ffe0ffULL,
0x00000008162e7824ULL, 0x000fe200078e00ffULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee205ULL,
0x0000000107137824ULL, 0x000fe200000e060bULL, 0x000000181c287810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0b7824ULL, 0x000fe200078e0218ULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee20dULL,
0x000000010c037824ULL, 0x000fe200078e0a23ULL, 0x0ffffff89d217812ULL, 0x000fe200078ec0ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0008ULL, 0x0000001c1c327810ULL, 0x000fc40007ffe0ffULL,
0x000000031400720cULL, 0x0c0fe20003f66070ULL, 0x0000000114057824ULL, 0x000fe200078e029dULL,
0x000000031600720cULL, 0x080fe20003f06070ULL, 0x00000008142c7824ULL, 0x000fe200078e00ffULL,
0x0000000a06147210ULL, 0x000fe20007f3e0ffULL, 0x00000001100d7824ULL, 0x100fe200078e0218ULL,
0x000000030e00720cULL, 0x080fe20003f86070ULL, 0x0000000126117824ULL, 0x000fe200078e0218ULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee205ULL, 0x000001000d0c7825ULL, 0x000fe200078e0008ULL,
0x000000031000720cULL, 0x000fc40003f46070ULL, 0x000000201c347810ULL, 0x000fe20007ffe0ffULL,
0x0000000116057824ULL, 0x000fe200078e0218ULL, 0x0000000c06167210ULL, 0x000fe20007fbe0ffULL,
0x0000000107157824ULL, 0x000fe200008e060bULL, 0x0000009d1c0c7210ULL, 0x000fe20007ffe0ffULL,
0x00000100050a7825ULL, 0x000fe200078e0008ULL, 0x00000003282d7819ULL, 0x000fe400000006ffULL,
0x00000007210c7812ULL, 0x000fe200078ef80cULL, 0x000001000f0e7825ULL, 0x000fc800078e0008ULL,
0x0000000107177824ULL, 0x000fe200028e060dULL, 0x0000000a06247210ULL, 0x040fe20007fbe0ffULL,
0x0000010011107825ULL, 0x000fe200078e0008ULL, 0x0000000e060e7210ULL, 0x000fc60007f3e0ffULL,
0x0000000128057824ULL, 0x000fe200078e0218ULL, 0x0000001006107210ULL, 0x000fe20007fde0ffULL,
0x0000000107257824ULL, 0x000fe200028e060bULL, 0x000000031c00720cULL, 0x000fe20003fa6070ULL,
0x00000100050a7825ULL, 0x000fe200078e0008ULL, 0x000040001e057811ULL, 0x000fc600078e70ffULL,
0x00000001070f7824ULL, 0x040fe200008e060fULL, 0x000000032600720cULL, 0x0c0fe20003f26070ULL,
0x0000000107117824ULL, 0x040fe400030e0611ULL, 0x00000001260d7824ULL, 0x040fe400078e029dULL,
0x0000000826307824ULL, 0x000fe200078e00ffULL, 0x0000000a06267210ULL, 0x000fe20007fde0ffULL,
0x000000100c1f7824ULL, 0x100fe400078e0205ULL, 0x00000010202b7824ULL, 0x000fe200078e0205ULL,
0xfffffff830307812ULL, 0x000fe200078ee20dULL, 0x0000000107277824ULL, 0x000fe200030e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000121f7faeULL, 0x0003e2000e901c48ULL,
0x00000001320b7824ULL, 0x000fe200078e0218ULL, 0x000000032800720cULL, 0x0c0fe20003fa6070ULL,
0x0000000128207824ULL, 0x000fe200078e029dULL, 0x00000000142b7faeULL, 0x0005e2000e101c48ULL,
0x000001000b0a7825ULL, 0x000fe200078e0008ULL, 0x000000033200720cULL, 0x000fc40003f86070ULL,
0xfffffff82d207812ULL, 0x000fe200078ee220ULL, 0x00000001340d7824ULL, 0x000fe200078e0218ULL,
0x0000000a06287210ULL, 0x000fe20007fde0ffULL, 0x00000001320a7824ULL, 0x000fe200078e029dULL,
0x000000241c127810ULL, 0x002fe20007ffe0ffULL, 0x000001000d0c7825ULL, 0x000fc800078e0008ULL,
0x0000000832137824ULL, 0x000fe400078e00ffULL, 0x000000102a157824ULL, 0x004fe400078e0205ULL,
0x0000000107297824ULL, 0x000fe200030e060bULL, 0x0000000c060c7210ULL, 0x000fe20007fde0ffULL,
0x000000102c1f7824ULL, 0x000fe200078e0205ULL, 0xfffffff813147812ULL, 0x000fe200078ee20aULL,
0x00000001120b7824ULL, 0x000fe200078e0218ULL, 0x0000000016157faeULL, 0x0003e2000d101c48ULL,
0x0000000134137824ULL, 0x000fe200078e029dULL, 0x000000031200720cULL, 0x080fe20003f46070ULL,
0x000001000b0a7825ULL, 0x000fe200078e0008ULL, 0x000000000e1f7faeULL, 0x0005e2000d901c48ULL,
0x000000033400720cULL, 0x000fc40003f66070ULL, 0x0000000334347819ULL, 0x000fe200000006ffULL,
0x00000001070d7824ULL, 0x000fe200030e060dULL, 0x0000003c1c2c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001122a7824ULL, 0x040fe400078e029dULL, 0x00000008122b7824ULL, 0x000fe200078e00ffULL,
0x0000000a06127210ULL, 0x000fe20007fde0ffULL, 0x000000102e157824ULL, 0x002fe200078e0205ULL,
0xfffffff8340a7812ULL, 0x000fe200078ee213ULL, 0x0000001014177824ULL, 0x000fe200078e0205ULL,
0xfffffff82b2a7812ULL, 0x000fe200078ee22aULL, 0x0000000107137824ULL, 0x000fe200030e060bULL,
0x0000000024157faeULL, 0x0003e2000c101c48ULL, 0x000000100a1f7824ULL, 0x104fe200078e0205ULL,
0x000000281c0a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010300b7824ULL, 0x100fe200078e0205ULL,
0x0000002c1c0e7810ULL, 0x000fe20007ffe0ffULL, 0x00000010200f7824ULL, 0x000fe200078e0205ULL,
0x000000030a00720cULL, 0x040fe20003fc6070ULL, 0x000000080a147824ULL, 0x000fe200078e00ffULL,
0x00000000100b7faeULL, 0x0005e2000c901c48ULL, 0x000000301c167810ULL, 0x000fc40007ffe0ffULL,
0x000000341c207810ULL, 0x040fe20007ffe0ffULL, 0x00000000260f7faeULL, 0x0007e2000e901c48ULL,
0x000000381c247810ULL, 0x002fe20007ffe0ffULL, 0x000000080e1c7824ULL, 0x040fe200078e00ffULL,
0x000000030e00720cULL, 0x080fe20003fa6070ULL, 0x0000000028177faeULL, 0x0003e2000e101c48ULL,
0x0000000316157819ULL, 0x040fe400000006ffULL, 0x000000031600720cULL, 0x000fe20003f86070ULL,
0x000000102a117824ULL, 0x004fe200078e0205ULL, 0x0000009d0a0b7210ULL, 0x000fe20007ffe0ffULL,
0x000000000c1f7faeULL, 0x0005e2000d901c48ULL, 0x0000000116107824ULL, 0x100fe200078e029dULL,
0x000000032000720cULL, 0x080fe20003f66070ULL, 0x000000010e0f7824ULL, 0x008fe200078e029dULL,
0xfffffff814147812ULL, 0x000fe200078ee20bULL, 0x000000010a0b7824ULL, 0x000fe200078e0218ULL,
0x0000000012117faeULL, 0x0007e2000d101c48ULL, 0x000000032400720cULL, 0x000fc40003f26070ULL,
0x000001000b0a7825ULL, 0x000fe200078e0008ULL, 0x000000032c00720cULL, 0x000fe40003f06070ULL,
0x0000009d24177210ULL, 0x002fe20007ffe0ffULL, 0x000000010e0d7824ULL, 0x104fe200078e0218ULL,
0x0000000a060e7210ULL, 0x000fe20007f5e0ffULL, 0x0000000116037824ULL, 0x000fe200078e0218ULL,
0xfffffff81c167812ULL, 0x000fe200078ee20fULL, 0x000001000d0c7825ULL, 0x000fe200078e0008ULL,
0xfffffff8151c7812ULL, 0x000fc600078ee210ULL, 0x00000001070f7824ULL, 0x000fe200010e060bULL,
0x0000000c06107210ULL, 0x000fe20007f5e0ffULL, 0x00000100030a7825ULL, 0x000fc800078e0008ULL,
0x00000001200c7824ULL, 0x040fe400078e029dULL, 0x0000000820137824ULL, 0x048fe400078e00ffULL,
0x0000000120037824ULL, 0x100fe400078e0218ULL, 0x0000000107117824ULL, 0x000fe200010e060dULL,
0x0000000a06127210ULL, 0x000fe20007f5e0ffULL, 0x0000000124157824ULL, 0x000fe200078e0218ULL,
0xfffffff813207812ULL, 0x000fe200078ee20cULL, 0x00000100030c7825ULL, 0x000fc600078e0008ULL,
0x00000005201f7211ULL, 0x000fe200078e20ffULL, 0x0000000107137824ULL, 0x000fe200010e060bULL,
0x0000000c060c7210ULL, 0x000fe20007f5e0ffULL, 0x00000100150a7825ULL, 0x000fc800078e0008ULL,
0x000000012c037824ULL, 0x000fe400078e0218ULL, 0x00000001070d7824ULL, 0x000fe200010e060dULL,
0x0000000a060a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000824187824ULL, 0x000fe400078e00ffULL,
0x000000012c157824ULL, 0x040fe400078e029dULL, 0x000000082c247824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee217ULL, 0x0000010003087825ULL, 0x000fc600078e0008ULL,
0xfffffff824247812ULL, 0x000fe200078ee215ULL, 0x00000001070b7824ULL, 0x040fe200010e060bULL,
0x0000000806067210ULL, 0x000fe20007f5e0ffULL, 0x0000001014037824ULL, 0x100fe400078e0205ULL,
0x0000001016157824ULL, 0x100fe400078e0205ULL, 0x000000101c177824ULL, 0x100fe200078e0205ULL,
0x000000000e037faeULL, 0x0003e2000f101c48ULL, 0x0000001018257824ULL, 0x100fe400078e0205ULL,
0x0000001024057824ULL, 0x000fe200078e0205ULL, 0x0000000010157faeULL, 0x0003e2000e901c48ULL,
0x0000000107077824ULL, 0x000fc600010e0609ULL, 0x0000000012177faeULL, 0x0003e8000e101c48ULL,
0x000000000c1f7faeULL, 0x0003e8000d901c48ULL, 0x000000000a257faeULL, 0x0003e8000c901c48ULL,
0x0000000006057faeULL, 0x0003e2000c101c48ULL, 0x00000a7000007947ULL, 0x000fea0003800000ULL,
0x000000049d0b7811ULL, 0x042fe200078fe8ffULL, 0x000000109d227824ULL, 0x040fe200078e00ffULL,
0x000000089d0d7811ULL, 0x040fe200078fe8ffULL, 0x000000ffff337224ULL, 0x000fe200078e00ffULL,
0x0000000c9d0f7811ULL, 0x000fe200078fe8ffULL, 0x000000010b037824ULL, 0x100fe200078e029dULL,
0x000000109d117811ULL, 0x000fe200078fe8ffULL, 0x000000080b0a7824ULL, 0x000fe200078e00ffULL,
0x000000149d137811ULL, 0x000fe200078fe8ffULL, 0x000000010d087824ULL, 0x000fe200078e029dULL,
0x000000189d157811ULL, 0x000fe200078fe8ffULL, 0x000000080d1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a057812ULL, 0x000fe200078ee203ULL, 0x000000010f037824ULL, 0x140fe200078e029dULL,
0x000000030f0a7819ULL, 0x000fe200000006ffULL, 0x0000000811377824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee208ULL, 0x0000000111087824ULL, 0x100fe200078e029dULL,
0x0000001c9d177811ULL, 0x000fe200078fe8ffULL, 0x0000000113097824ULL, 0x040fe200078e029dULL,
0xfffffff80a357812ULL, 0x000fe200078ee203ULL, 0x00000008130c7824ULL, 0x000fe200078e00ffULL,
0x000000209d257811ULL, 0x000fe200078fe8ffULL, 0x0000000115037824ULL, 0x100fe200078e029dULL,
0xfffffff837377812ULL, 0x000fe200078ee208ULL, 0x00000008150a7824ULL, 0x000fe200078e00ffULL,
0x000000249d277811ULL, 0x000fe200078fe8ffULL, 0x0000000117087824ULL, 0x000fe200078e029dULL,
0x000000289d297811ULL, 0x000fe200078fe8ffULL, 0x00000008173d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c397812ULL, 0x000fe200078ee209ULL, 0x00000008250c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a3b7812ULL, 0x000fe200078ee203ULL, 0x0000000127037824ULL, 0x100fe200078e029dULL,
0x0000009d25097210ULL, 0x080fe20007ffe0ffULL, 0x00000008270a7824ULL, 0x000fe200078e00ffULL,
0x0000002c9d2b7811ULL, 0x000fe200078fe8ffULL, 0x0000000829437824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee208ULL, 0x0000000129087824ULL, 0x000fe200078e029dULL,
0x000000309d2d7811ULL, 0x000fe200078fe8ffULL, 0x000000010b0b7824ULL, 0x100fe200078e0218ULL,
0x000000349d2f7811ULL, 0x000fe200078fe8ffULL, 0x000000010f0f7824ULL, 0x000fe200078e0218ULL,
0xfffffff80c3f7812ULL, 0x000fe200078ee209ULL, 0x000000012b097824ULL, 0x040fe200078e029dULL,
0xfffffff80a417812ULL, 0x000fe200078ee203ULL, 0x000000082b0c7824ULL, 0x000fe200078e00ffULL,
0x000000389d317811ULL, 0x000fe200078fe8ffULL, 0x000000012d037824ULL, 0x100fe200078e029dULL,
0xfffffff843437812ULL, 0x000fe200078ee208ULL, 0x000000012f087824ULL, 0x000fe200078e029dULL,
0x000000032d0a7819ULL, 0x000fe200000006ffULL, 0x000000082f497824ULL, 0x000fe200078e00ffULL,
0x0000003c9d4d7811ULL, 0x000fe200078fe8ffULL, 0x0000000111117824ULL, 0x000fe200078e0218ULL,
0xfffffff80c457812ULL, 0x000fe200078ee209ULL, 0x0000000131097824ULL, 0x040fe200078e029dULL,
0xfffffff80a477812ULL, 0x000fe200078ee203ULL, 0x00000008310c7824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee208ULL, 0x000000014d037824ULL, 0x040fe200078e029dULL,
0x0000007022227812ULL, 0x000fe200078ec0ffULL, 0x000000084d0a7824ULL, 0x000fe200078e00ffULL,
0x0000009d9d087211ULL, 0x000fe200078fe8ffULL, 0x0000000113137824ULL, 0x100fe200078e0218ULL,
0x0ffffff89d217812ULL, 0x000fe200078ec0ffULL, 0x0000000115157824ULL, 0x100fe200078e0218ULL,
0xfffffff80c4b7812ULL, 0x000fe200078ee209ULL, 0x0000000117177824ULL, 0x100fe200078e0218ULL,
0xfffffff80a4f7812ULL, 0x000fe200078ee203ULL, 0x0000000125257824ULL, 0x100fe200078e0218ULL,
0x000000189d097211ULL, 0x080fe200078fe8ffULL, 0x0000000127277824ULL, 0x100fe200078e0218ULL,
0x0000008022327812ULL, 0x000fe200078efcffULL, 0x0000000129297824ULL, 0x100fe200078e0218ULL,
0x000040001e0a7811ULL, 0x000fe200078e70ffULL, 0x000000012d2d7824ULL, 0x000fe200078e0218ULL,
0x0000000721037812ULL, 0x000fe200078ef808ULL, 0x0000010009087825ULL, 0x000fe200078e0032ULL,
0x000000180d0d7210ULL, 0x000fc40007ffe0ffULL, 0x0000000a37377211ULL, 0x080fe200078e20ffULL,
0x0000001003037824ULL, 0x100fe200078e020aULL, 0x0000000a49497211ULL, 0x000fe200078e20ffULL,
0x0000001005057824ULL, 0x100fe200078e020aULL, 0x0000000806087210ULL, 0x000fe20007f1e0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e020aULL, 0x000000182b2b7210ULL, 0x000fe20007ffe0ffULL,
0x0000001035357824ULL, 0x100fe400078e020aULL, 0x0000001039397824ULL, 0x100fe400078e020aULL,
0x000000103b3b7824ULL, 0x000fc400078e020aULL, 0x000000103d3d7824ULL, 0x100fe400078e020aULL,
0x000000103f3f7824ULL, 0x100fe400078e020aULL, 0x0000001041417824ULL, 0x100fe400078e020aULL,
0x0000001043437824ULL, 0x100fe400078e020aULL, 0x0000001045457824ULL, 0x100fe400078e020aULL,
0x0000001047477824ULL, 0x000fc400078e020aULL, 0x000000104b4b7824ULL, 0x100fe400078e020aULL,
0x000000104f4f7824ULL, 0x000fe400078e020aULL, 0x000001000b0a7825ULL, 0x000fc800078e0032ULL,
0x000001000d0c7825ULL, 0x000fe200078e0032ULL, 0x0000000a060a7210ULL, 0x000fc60007f3e0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0032ULL, 0x0000000c060c7210ULL, 0x000fc60007f5e0ffULL,
0x0000010011107825ULL, 0x000fe200078e0032ULL, 0x0000000e060e7210ULL, 0x000fc60007f7e0ffULL,
0x0000010013127825ULL, 0x000fc800078e0032ULL, 0x0000010015147825ULL, 0x000fc800078e0032ULL,
0x0000010017167825ULL, 0x000fc800078e0032ULL, 0x0000000107097824ULL, 0x000fe200000e0609ULL,
0x0000001006107210ULL, 0x000fe20007f1e0ffULL, 0x0000010025247825ULL, 0x000fc600078e0032ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008037faeULL, 0x0003e2000b901c48ULL,
0x00000001070b7824ULL, 0x040fe200008e060bULL, 0x0000001206127210ULL, 0x040fe20007f3e0ffULL,
0x00000001070d7824ULL, 0x000fe200010e060dULL, 0x0000001406147210ULL, 0x040fe20007f5e0ffULL,
0x0000010027267825ULL, 0x000fe200078e0032ULL, 0x0000001307137210ULL, 0x040fe20000ffe4ffULL,
0x000000000a057faeULL, 0x0003e4000b901c48ULL, 0x00000001070f7824ULL, 0x000fe200018e060fULL,
0x0000001606167210ULL, 0x040fe20007f7e0ffULL, 0x0000010029287825ULL, 0x000fe200078e0032ULL,
0x0000002606267210ULL, 0x000fe20007f3e0ffULL, 0x000000000c1f7faeULL, 0x0003e4000b901c48ULL,
0x000000012f2f7824ULL, 0x000fc400078e0218ULL, 0x000001002b2a7825ULL, 0x000fe200078e0032ULL,
0x000000000e357faeULL, 0x0003e6000b901c48ULL, 0x0000000131317824ULL, 0x100fe400078e0218ULL,
0x0000000107117824ULL, 0x000fe200000e0611ULL, 0x0000002406247210ULL, 0x040fe20007f1e0ffULL,
0x000000014d4d7824ULL, 0x000fe400078e0218ULL, 0x000001002d2c7825ULL, 0x000fe200078e0032ULL,
0x0000000010377faeULL, 0x0003e6000b901c48ULL, 0x0000000107157824ULL, 0x000fe200010e0615ULL,
0x0000002806287210ULL, 0x040fe20007f5e0ffULL, 0x000001002f2e7825ULL, 0x000fe200078e0032ULL,
0x0000000012397faeULL, 0x0003e6000b901c48ULL, 0x0000000107177824ULL, 0x000fe200018e0617ULL,
0x0000002a062a7210ULL, 0x040fe20007f7e0ffULL, 0x0000010031307825ULL, 0x100fe200078e0032ULL,
0x00000000143b7faeULL, 0x0003e6000b901c48ULL, 0x000001004d327825ULL, 0x000fe200078e0032ULL,
0x00000000163d7faeULL, 0x0003e6000b901c48ULL, 0x0000000107257824ULL, 0x040fe200000e0625ULL,
0x0000002c062c7210ULL, 0x040fe20007f1e0ffULL, 0x0000000107277824ULL, 0x040fe200008e0627ULL,
0x0000002e062e7210ULL, 0x040fe20007f3e0ffULL, 0x0000000107297824ULL, 0x040fe200010e0629ULL,
0x0000003006307210ULL, 0x040fe20007f5e0ffULL, 0x00000001072b7824ULL, 0x040fe200018e062bULL,
0x0000003206067210ULL, 0x000fe20007f7e0ffULL, 0x00000001072d7824ULL, 0x040fe200000e062dULL,
0x00000000243f7faeULL, 0x0003e2000b901c48ULL, 0x00000001072f7824ULL, 0x040fe200008e062fULL,
0x0000003107317210ULL, 0x040fe200017fe4ffULL, 0x0000000107077824ULL, 0x000fe200018e0633ULL,
0x0000000026417faeULL, 0x0003e8000b901c48ULL, 0x0000000028437faeULL, 0x0003e8000b901c48ULL,
0x000000002a457faeULL, 0x0003e8000b901c48ULL, 0x000000002c477faeULL, 0x0003e8000b901c48ULL,
0x000000002e497faeULL, 0x0003e8000b901c48ULL, 0x00000000304b7faeULL, 0x0003e8000b901c48ULL,
0x00000000064f7faeULL, 0x0003e4000b901c48ULL, 0x0000000204047810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff037424ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000001a0400720cULL, 0x000fda0003f06070ULL, 0x00000002a2068824ULL, 0x000fe400078e0204ULL,
0x00000004ff078424ULL, 0x000fc800078e00ffULL, 0x0000640006068625ULL, 0x000fe200078e0007ULL,
0x000000089d207812ULL, 0x000fe400078ec0ffULL, 0x00000004ff147819ULL, 0x000fe2000001169dULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000806038981ULL, 0x000322000c1e1900ULL,
0x0000000720207812ULL, 0x000fe200078ef89dULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000079d6c7812ULL, 0x000fc600078ec0ffULL, 0x00000001141f7824ULL, 0x000fe400078e0220ULL,
0x0000001020087824ULL, 0x000fca00078e00ffULL, 0xfffffff008057812ULL, 0x000fca00078ee21fULL,
0x0000001005647824ULL, 0x000fc400078e00ffULL, 0x0000000814057824ULL, 0x002fe200078e00ffULL,
0x00000003ff1c7819ULL, 0x000fe2000001169dULL, 0x00000010200c7824ULL, 0x040fe200078e00ffULL,
0x0000001020177812ULL, 0x000fe200078efcffULL, 0x000000006464783bULL, 0x000fe20000000200ULL,
0xfffffff8056c7812ULL, 0x000fe400078ee26cULL, 0x000000011c097812ULL, 0x000fe200078ec0ffULL,
0x0000000114147824ULL, 0x000fe200078e0217ULL, 0x000000021f077810ULL, 0x000fe20007ffe0ffULL,
0x000000086c067824ULL, 0x040fe200078e00ffULL, 0x000000106c7c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109057824ULL, 0x000fe200078e026cULL, 0xfffffff00c0c7812ULL, 0x000fe200078ee207ULL,
0x00000010170b7824ULL, 0x040fe200078e00ffULL, 0x000000206c077810ULL, 0x000fe20007ffe0ffULL,
0x000000087c0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff806157812ULL, 0x000fe200078ee205ULL,
0x00000010170d7824ULL, 0x000fe200078e00ffULL, 0xfffffff00b067812ULL, 0x000fe200078ee214ULL,
0x0000000109127824ULL, 0x040fe200078e0207ULL, 0x0000007c09137210ULL, 0x000fe20007ffe0ffULL,
0x000000086c257824ULL, 0x000fe200078e00ffULL, 0x0000000e1e187819ULL, 0x000fe200000006ffULL,
0x0000001006687824ULL, 0x000fe200078e00ffULL, 0x000000306c067810ULL, 0x000fe20007ffe0ffULL,
0x0000000807297824ULL, 0x000fe200078e00ffULL, 0x0000200018167810ULL, 0x000fe20007ffe0ffULL,
0x000000100c0c7824ULL, 0x000fe200078e00ffULL, 0x0000000214087810ULL, 0x000fe20007ffe0ffULL,
0x0000000109117824ULL, 0x000fe200078e0206ULL, 0xfffffff80a137812ULL, 0x000fe200078ee213ULL,
0x0000000807097824ULL, 0x000fe200078e00ffULL, 0xfffffff00d0d7812ULL, 0x000fe200078ee208ULL,
0x00000008060e7824ULL, 0x000fe200078e00ffULL, 0x000000006868783bULL, 0x000fe20000000200ULL,
0x0000001015607824ULL, 0x000fe200078e0216ULL, 0xfffffff809127812ULL, 0x000fe200078ee212ULL,
0x0000001013087824ULL, 0x100fe200078e0216ULL, 0xfffffff80e117812ULL, 0x000fe200078ee211ULL,
0x000000087c0e7824ULL, 0x000fe200078e00ffULL, 0x00000012050f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001012787824ULL, 0x000fe200078e0216ULL, 0x00000016113c7211ULL, 0x080fe200078e20ffULL,
0x000000006060783bULL, 0x000e620000000200ULL, 0x0000000205107810ULL, 0x000fe20007ffe0ffULL,
0x000000100d247824ULL, 0x000fe200078e00ffULL, 0xfffffff80e0f7812ULL, 0x000fe200078ee20fULL,
0x000000000808783bULL, 0x000ea20000000200ULL, 0x00000022050e7810ULL, 0x040fe20007ffe0ffULL,
0x00000008060d7824ULL, 0x000fe200078e00ffULL, 0x0000003205287810ULL, 0x000fe20007ffe0ffULL,
0x000000007878783bULL, 0x000ee20000000200ULL, 0xfffffff825107812ULL, 0x000fe200078ee210ULL,
0x000000100f5c7824ULL, 0x000fe200078e0216ULL, 0xfffffff8290e7812ULL, 0x000fe200078ee20eULL,
0x000000003c3c783bULL, 0x000ea20000000200ULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee228ULL,
0x0000001010387824ULL, 0x100fe200078e0216ULL, 0x0000002605877810ULL, 0x000fe20007ffe0ffULL,
0x000000100e747824ULL, 0x000fe200078e0216ULL, 0x000000160d287211ULL, 0x000fe200078e20ffULL,
0x000000000c54783bULL, 0x0003e20000000200ULL, 0x000000086c717824ULL, 0x000fe200078e00ffULL,
0x00000003068c7819ULL, 0x000fe200000006ffULL, 0x000000087c887824ULL, 0x000fe200078e00ffULL,
0x000000003838783bULL, 0x000ea20000000200ULL, 0x00000008078a7824ULL, 0x000fc600078e00ffULL,
0x000000002424783bULL, 0x000ea20000000200ULL, 0x000000041f0c7810ULL, 0x002fc60007ffe0ffULL,
0x000000005c5c783bULL, 0x000e680000000200ULL, 0x000000007474783bULL, 0x000e680000000200ULL,
0x000000002828783bULL, 0x000e620000000200ULL, 0x00000060642c723cULL, 0x080f7000000018ffULL,
0x000000606830723cULL, 0x000f7000000018ffULL, 0x000000626434723cULL, 0x080f7000000018ffULL,
0x000000626860723cULL, 0x000f7000000018ffULL, 0x000000086440723cULL, 0x044f7000000018ffULL,
0x0000000a6444723cULL, 0x040f7000000018ffULL, 0x000000786448723cULL, 0x048f7000000018ffULL,
0x0000007a644c723cULL, 0x040f7000000018ffULL, 0x0000003c6450723cULL, 0x040f7000000018ffULL,
0x0000003e6464723cULL, 0x000f7000000018ffULL, 0x000000086858723cULL, 0x040f7000000018ffULL,
0x0000000a6808723cULL, 0x000ff000000018ffULL, 0x00000038542c723cULL, 0x0a0ff0000000182cULL,
0x000000382430723cULL, 0x000ff00000001830ULL, 0x0000003a5434723cULL, 0x080ff00000001834ULL,
0x0000003a2438723cULL, 0x000ff00000001860ULL, 0x0000005c5440723cULL, 0x042ff00000001840ULL,
0x0000005e5444723cULL, 0x040ff00000001844ULL, 0x000000745448723cULL, 0x040ff00000001848ULL,
0x00000076544c723cULL, 0x040ff0000000184cULL, 0x000000285450723cULL, 0x000ff00000001850ULL,
0x000000786860723cULL, 0x040f7000000018ffULL, 0x0000003c6880723cULL, 0x000ff000000018ffULL,
0x0000002a5454723cULL, 0x000bee0000001864ULL, 0x0000001020657824ULL, 0x020fe200078e00ffULL,
0x0000007a6878723cULL, 0x000f6200000018ffULL, 0x0000001017677824ULL, 0x000fe200078e00ffULL,
0x0000000614667810ULL, 0x000fc40007ffe0ffULL, 0xfffffff065647812ULL, 0x000fe400078ee20cULL,
0x00000004050c7810ULL, 0x000fe40007ffe0ffULL, 0x0000003e683c723cULL, 0x000b6200000018ffULL,
0x0000000464647819ULL, 0x000fcc00000006ffULL, 0x0000001020687824ULL, 0x020fe200078e00ffULL,
0x0000005c2458723cULL, 0x000b620000001858ULL, 0x0000001017697824ULL, 0x000fca00078e00ffULL,
0xfffffff069867812ULL, 0x000fe200078ee266ULL, 0x0000000806667824ULL, 0x000fe200078e00ffULL,
0x000000061f5d7810ULL, 0x020fe20007ffe0ffULL, 0x0000000807697824ULL, 0x000fe200078e00ffULL,
0x00000004145c7810ULL, 0x000fe20007ffe0ffULL, 0x000000742460723cULL, 0x040fe20000001860ULL,
0xfffffff068857812ULL, 0x000fe400078ee25dULL, 0xfffffff067657812ULL, 0x000fe200078ee25cULL,
0x000000086c677824ULL, 0x000fe200078e00ffULL, 0x0000001605077810ULL, 0x000fe20007ffe0ffULL,
0x0000001085857824ULL, 0x000fe200078e00ffULL, 0xfffffff88a067812ULL, 0x000fe200078ee287ULL,
0x0000005e245c723cULL, 0x000be20000001808ULL, 0x00000010656c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8670c7812ULL, 0x000fc400078ee20cULL, 0xfffffff888077812ULL, 0x000fe200078ee207ULL,
0x0000001006947824ULL, 0x100fe400078e0216ULL, 0x000000087c087824ULL, 0x020fe200078e00ffULL,
0x00000014050b7810ULL, 0x040fe20007ffe0ffULL, 0x000000006c6c783bULL, 0x000fe20000000200ULL,
0x0000003405097810ULL, 0x000fe20007ffe0ffULL, 0x000000100c687824ULL, 0x100fe200078e0216ULL,
0xfffffff8080b7812ULL, 0x000fe200078ee20bULL, 0x0000001007907824ULL, 0x100fe200078e0216ULL,
0xfffffff866097812ULL, 0x000fe200078ee209ULL, 0x000000762474723cULL, 0x000fe20000001878ULL,
0x0000000605087810ULL, 0x000fe20007ffe0ffULL, 0x000000100b707824ULL, 0x100fe200078e0216ULL,
0x000000006464783bULL, 0x000fe20000000200ULL, 0x00000010097d7824ULL, 0x000fe200078e0216ULL,
0xfffffff871087812ULL, 0x000fc400078ee208ULL, 0x00000024050a7810ULL, 0x040fe20007ffe0ffULL,
0x000000007070783bULL, 0x000e620000000200ULL, 0x0000003605057810ULL, 0x000fe20007ffe0ffULL,
0x000000282480723cULL, 0x040b620000001880ULL, 0xfffffff8690a7812ULL, 0x000fe200078ee20aULL,
0x000000007d7c783bULL, 0x000ea20000000200ULL, 0xfffffff88c057812ULL, 0x000fe200078ee205ULL,
0x00000010868c7824ULL, 0x000fe400078e00ffULL, 0x000000100a847824ULL, 0x100fe200078e0216ULL,
0x000000006868783bULL, 0x000ee20000000200ULL, 0x0000001005287824ULL, 0x120fe200078e0216ULL,
0x0000002a243c723cULL, 0x000b62000000183cULL, 0x0000001008887824ULL, 0x000fe200078e0216ULL,
0x000000008478783bULL, 0x000ea80000000200ULL, 0x000000008584783bULL, 0x000fe80000000200ULL,
0x000000008c8c783bULL, 0x000fe80000000200ULL, 0x000000009090783bULL, 0x000ee80000000200ULL,
0x000000002824783bULL, 0x020ee80000000200ULL, 0x000000008888783bULL, 0x000ee80000000200ULL,
0x000000009494783bULL, 0x000ee20000000200ULL, 0x000000706440723cULL, 0x082f700000001840ULL,
0x000000706c58723cULL, 0x000f700000001858ULL, 0x0000007c6450723cULL, 0x084f700000001850ULL,
0x0000007c6c80723cULL, 0x000f700000001880ULL, 0x0000007e6454723cULL, 0x080f700000001854ULL,
0x0000007e6c3c723cULL, 0x000f70000000183cULL, 0x00000068642c723cULL, 0x088f70000000182cULL,
0x000000686c30723cULL, 0x000f700000001830ULL, 0x0000006a6434723cULL, 0x080f700000001834ULL,
0x0000006a6c38723cULL, 0x000f700000001838ULL, 0x000000726444723cULL, 0x040f700000001844ULL,
0x000000786448723cULL, 0x040f700000001848ULL, 0x0000007a644c723cULL, 0x000f70000000184cULL,
0x000000726c5c723cULL, 0x040f70000000185cULL, 0x000000786c60723cULL, 0x040f700000001860ULL,
0x0000007a6c74723cULL, 0x000f700000001874ULL, 0x000000908440723cULL, 0x0a0f700000001840ULL,
0x000000908c58723cULL, 0x000b6e0000001858ULL, 0x000003001d907a10ULL, 0x020fe20007ffe0ffULL,
0x000000248450723cULL, 0x080f700000001850ULL, 0x000000248c80723cULL, 0x000b6e0000001880ULL,
0x0000000190247810ULL, 0x020fe20007ffe0ffULL, 0x000000268454723cULL, 0x000f660000001854ULL,
0x000000192400720cULL, 0x000fe20003f06070ULL, 0x0000009f03247224ULL, 0x010fc800078e02ffULL,
0x000000268c3c723cULL, 0x000b62000000183cULL, 0x0000620024247625ULL, 0x000fcc00078e00a1ULL,
0x0000010090267824ULL, 0x020fe200078e02a0ULL, 0x00000088842c723cULL, 0x000b68000000182cULL,
0x0000004026697812ULL, 0x000fc800078ec0ffULL, 0x000000888c30723cULL, 0x000b620000001830ULL,
0x0000000102697824ULL, 0x000fce00078e0269ULL, 0x0000008a8434723cULL, 0x080b700000001834ULL,
0x0000008a8c38723cULL, 0x000b700000001838ULL, 0x000000928444723cULL, 0x040b700000001844ULL,
0x000000948448723cULL, 0x040b700000001848ULL, 0x00000096844c723cULL, 0x000b70000000184cULL,
0x000000928c5c723cULL, 0x040b70000000185cULL, 0x000000948c60723cULL, 0x040b700000001860ULL,
0x000000968c74723cULL, 0x000b620000001874ULL, 0x00000c4000008947ULL, 0x000fce0003800000ULL,
0x000000081c667810ULL, 0x040fe40007ffe0ffULL, 0x000000041c2a7810ULL, 0x000fc40007ffe0ffULL,
0x000000261b6b7217ULL, 0x000fe20007800000ULL, 0x0000000166297824ULL, 0x100fe200078e029dULL,
0x000000101c6a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000866687824ULL, 0x000fe200078e00ffULL,
0x0000009d1c287210ULL, 0x000fe20007ffe0ffULL, 0x000000012a277824ULL, 0x000fe200078e029dULL,
0x000000141c707810ULL, 0x000fe20007ffe0ffULL, 0x000000082a647824ULL, 0x000fe200078e00ffULL,
0xfffffff868797812ULL, 0x000fe200078ee229ULL, 0x000000016b6b7824ULL, 0x000fe200078e0a26ULL,
0x0000000c1c687810ULL, 0x040fe20007ffe0ffULL, 0x000000011c267824ULL, 0x000fe200078e0269ULL,
0xfffffff864737812ULL, 0x000fe200078ee227ULL, 0x000000016a297824ULL, 0x000fe200078e029dULL,
0x0000000721717812ULL, 0x000fe200078ef828ULL, 0x0000010026267825ULL, 0x000fe200078e00ffULL,
0x0000006b2a00720cULL, 0x000fc40003f46070ULL, 0x0000006b6600720cULL, 0x000fe20003f66070ULL,
0x000000086a6c7824ULL, 0x000fe200078e00ffULL, 0x0000002226657212ULL, 0x080fe200078efcffULL,
0x000000012a287824ULL, 0x000fe200078e0269ULL, 0x00000003682a7819ULL, 0x040fe200000006ffULL,
0x0000000168217824ULL, 0x000fe200078e029dULL, 0xfffffff86c7d7812ULL, 0x000fe200078ee229ULL,
0x0000010028287825ULL, 0x000fe200078e00ffULL, 0x0000006524647210ULL, 0x000fe40007f1e0ffULL,
0xfffffff82a7b7812ULL, 0x000fe200078ee221ULL, 0x0000000170267824ULL, 0x000fe200078e029dULL,
0x0000002228677212ULL, 0x000fe200078efcffULL, 0x00000008707f7824ULL, 0x000fe200078e00ffULL,
0x000000181c727810ULL, 0x000fe20007ffe0ffULL, 0x00000001682a7824ULL, 0x000fe200078e0269ULL,
0x0000006b1c00720cULL, 0x000fe20003f26070ULL, 0x0000000125657824ULL, 0x000fe200000e0627ULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee226ULL, 0x0000000166267824ULL, 0x000fe200078e0269ULL,
0x0000006724667210ULL, 0x000fe20007f1e0ffULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x0000006b6800720cULL, 0x000fc40003fa6070ULL, 0x0000002925677210ULL, 0x000fe200007fe4ffULL,
0x000000016a287824ULL, 0x000fe200078e0269ULL, 0x000000222a6f7212ULL, 0x080fe200078efcffULL,
0x0000010026267825ULL, 0x000fe200078e00ffULL, 0x0000006b6a00720cULL, 0x000fe40003f86070ULL,
0x0000006f246e7210ULL, 0x000fe20007fde0ffULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0x00000022266d7212ULL, 0x000fc600078efcffULL, 0x00000001256f7824ULL, 0x040fe200030e062bULL,
0x0000002228217212ULL, 0x000fe200078efcffULL, 0x0000000170287824ULL, 0x000fe200078e0269ULL,
0x0000006d246c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000172687824ULL, 0x000fe200078e029dULL,
0x0000002124267210ULL, 0x000fe20007fde0ffULL, 0x0000000872857824ULL, 0x020fe400078e00ffULL,
0x00000001256d7824ULL, 0x040fe200000e0627ULL, 0x0000006b7000720cULL, 0x000fe20003f06070ULL,
0x0000000125277824ULL, 0x000fe200030e0629ULL, 0xfffffff885857812ULL, 0x000fe200078ee268ULL,
0x0000010028287825ULL, 0x000fe200078e00ffULL, 0x0000001c1c687810ULL, 0x000fc40007ffe0ffULL,
0x000000201c707810ULL, 0x000fe20007ffe0ffULL, 0x00000001722a7824ULL, 0x000fe200078e0269ULL,
0x00000022282b7212ULL, 0x000fe200078efcffULL, 0x0000001071217824ULL, 0x000fe200078e0216ULL,
0x0000009d686a7210ULL, 0x040fe20007ffe0ffULL, 0x0000000868877824ULL, 0x000fe200078e00ffULL,
0x0000002b24287210ULL, 0x000fe20007fde0ffULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064217faeULL, 0x0003e2000c901c48ULL,
0x0000006b7200720cULL, 0x000fe40003f26070ULL, 0x0000000125297824ULL, 0x000fe200030e0629ULL,
0xfffffff887877812ULL, 0x000fe200078ee26aULL, 0x0000000170717824ULL, 0x000fe200078e029dULL,
0x000000241c6a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000870727824ULL, 0x000fc400078e00ffULL,
0x0000001073217824ULL, 0x102fe200078e0216ULL, 0x000000222a657212ULL, 0x080fe200078efcffULL,
0x0000000168647824ULL, 0x000fe200078e0269ULL, 0xfffffff872897812ULL, 0x000fe200078ee271ULL,
0x0000001079717824ULL, 0x000fe200078e0216ULL, 0x00000065242a7210ULL, 0x000fe20007fde0ffULL,
0x0000000066217faeULL, 0x0003e2000d101c48ULL, 0x0000010064647825ULL, 0x000fe200078e00ffULL,
0x0000006b6800720cULL, 0x000fe40003f46070ULL, 0x0000002b252b7210ULL, 0x000fe200037fe4ffULL,
0x0000000170687824ULL, 0x000fe200078e0269ULL, 0x0000002264737212ULL, 0x000fe200078efcffULL,
0x000000006c717faeULL, 0x0005e2000d901c48ULL, 0x000000086a797824ULL, 0x000fe200078e00ffULL,
0x0000006b7000720cULL, 0x000fc40003f66070ULL, 0x0000007324647210ULL, 0x000fe20007fde0ffULL,
0x0000010068667825ULL, 0x002fe200078e00ffULL, 0x000000301c727810ULL, 0x000fc60007ffe0ffULL,
0x000000016a687824ULL, 0x000fe400078e029dULL, 0x000000107b217824ULL, 0x000fe200078e0216ULL,
0x00000022666d7212ULL, 0x004fe200078efcffULL, 0x000000016a6c7824ULL, 0x000fe200078e0269ULL,
0xfffffff879797812ULL, 0x000fe200078ee268ULL, 0x0000000125657824ULL, 0x000fe200030e0665ULL,
0x0000006d24667210ULL, 0x000fe20007fde0ffULL, 0x000000107d737824ULL, 0x000fe200078e0216ULL,
0x000000281c687810ULL, 0x000fe20007ffe0ffULL, 0x000001006c6c7825ULL, 0x000fe200078e00ffULL,
0x000000006e217faeULL, 0x0003e2000e901c48ULL, 0x0000006b6a00720cULL, 0x000fc40003fa6070ULL,
0x00000003686a7819ULL, 0x000fe200000006ffULL, 0x0000000026737faeULL, 0x0005e2000e101c48ULL,
0x000000226c717212ULL, 0x000fe200078efcffULL, 0x0000000125677824ULL, 0x040fe200030e0667ULL,
0x0000006b6800720cULL, 0x000fe40003f86070ULL, 0x0000007124707210ULL, 0x000fe20007fde0ffULL,
0x0000000168217824ULL, 0x042fe400078e029dULL, 0x0000000168687824ULL, 0x000fe400078e0269ULL,
0x0000000125717824ULL, 0x000fe200030e066dULL, 0xfffffff86a7b7812ULL, 0x000fe200078ee221ULL,
0x0000010068267825ULL, 0x004fe200078e00ffULL, 0x0000002c1c6a7810ULL, 0x000fc60007ffe0ffULL,
0x00000001726e7824ULL, 0x100fe200078e0269ULL, 0x00000022266d7212ULL, 0x000fe200078efcffULL,
0x000000016a6c7824ULL, 0x000fe400078e0269ULL, 0x000000107f217824ULL, 0x000fe200078e0216ULL,
0x0000006d24267210ULL, 0x000fe20007fde0ffULL, 0x000001006c6c7825ULL, 0x000fc600078e00ffULL,
0x0000000028217faeULL, 0x0003e2000c101c48ULL, 0x000001006e6e7825ULL, 0x000fe200078e00ffULL,
0x0000002725277210ULL, 0x000fe400037fe4ffULL, 0x0000006b6a00720cULL, 0x040fe20003f06070ULL,
0x000000016a687824ULL, 0x100fe200078e029dULL, 0x000000226e737212ULL, 0x080fe200078efcffULL,
0x000000086a7d7824ULL, 0x000fe200078e00ffULL, 0x000000341c6e7810ULL, 0x000fe20007ffe0ffULL,
0x00000008727f7824ULL, 0x000fe200078e00ffULL, 0x000000226c297212ULL, 0x002fe200078efcffULL,
0x0000001085217824ULL, 0x000fe200078e0216ULL, 0xfffffff87d7d7812ULL, 0x000fe200078ee268ULL,
0x0000000172687824ULL, 0x000fe200078e029dULL, 0x0000002924287210ULL, 0x000fc40007fde0ffULL,
0x000000002a217faeULL, 0x0003e2000c901c48ULL, 0x0000006b7200720cULL, 0x000fe40003f26070ULL,
0x0000000125297824ULL, 0x000fe200030e066dULL, 0x00000073246c7210ULL, 0x000fe20007fde0ffULL,
0x0000001087737824ULL, 0x000fe200078e0216ULL, 0xfffffff87f7f7812ULL, 0x000fe400078ee268ULL,
0x000000381c687810ULL, 0x040fe20007ffe0ffULL, 0x00000001256d7824ULL, 0x000fe200030e066fULL,
0x0000003c1c727810ULL, 0x000fe20007ffe0ffULL, 0x00000010796f7824ULL, 0x100fe200078e0216ULL,
0x0000000064737faeULL, 0x0005e2000d101c48ULL, 0x000000016e2a7824ULL, 0x002fe200078e0269ULL,
0x0000006b7200720cULL, 0x000fe20003f46070ULL, 0x0000001089217824ULL, 0x000fc400078e0216ULL,
0x000001002a2a7825ULL, 0x000fc600078e00ffULL, 0x0000000066217faeULL, 0x0003e2000d901c48ULL,
0x0000006b6800720cULL, 0x000fe20003f66070ULL, 0x000000016e1c7824ULL, 0x000fe200078e029dULL,
0x000000222a797212ULL, 0x000fe200078efcffULL, 0x00000000706f7faeULL, 0x0007e2000e901c48ULL,
0x00000069682a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000172647824ULL, 0x004fe200078e0269ULL,
0x00000079246a7210ULL, 0x000fe20007fde0ffULL, 0x000000086e737824ULL, 0x040fe200078e00ffULL,
0x0000006b6e00720cULL, 0x000fe20003fa6070ULL, 0x0000010064647825ULL, 0x000fc800078e00ffULL,
0x00000001256b7824ULL, 0x000fe400030e062bULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x00000022646f7212ULL, 0x088fe400078efcffULL, 0xfffffff873717812ULL, 0x000fe200078ee21cULL,
0x0000000168667824ULL, 0x102fe200078e029dULL, 0x000000222a217212ULL, 0x000fe200078efcffULL,
0x0000000868697824ULL, 0x000fe400078e00ffULL, 0x0000000172677824ULL, 0x000fe200078e029dULL,
0x00000021242a7210ULL, 0x000fe20007fde0ffULL, 0x0000000872727824ULL, 0x000fe200078e00ffULL,
0xfffffff869737812ULL, 0x000fe200078ee266ULL, 0x000000107b217824ULL, 0x100fe200078e0216ULL,
0x0000002b252b7210ULL, 0x000fe200037fe4ffULL, 0x000000107f697824ULL, 0x100fe200078e0216ULL,
0xfffffff872797812ULL, 0x000fe200078ee267ULL, 0x000000107d677824ULL, 0x100fe200078e0216ULL,
0x0000006f24247210ULL, 0x000fe20007fde0ffULL, 0x00000010716f7824ULL, 0x100fe200078e0216ULL,
0x0000000026217faeULL, 0x0003e2000e101c48ULL, 0x0000001073717824ULL, 0x000fc400078e0216ULL,
0x0000001079737824ULL, 0x000fe200078e0216ULL, 0x0000000028677faeULL, 0x0003e2000c101c48ULL,
0x0000000125257824ULL, 0x000fc600030e0665ULL, 0x000000006c697faeULL, 0x0003e8000c901c48ULL,
0x000000006a6f7faeULL, 0x0003e8000e901c48ULL, 0x000000002a717faeULL, 0x0003e8000d901c48ULL,
0x0000000024737faeULL, 0x0003e2000d101c48ULL, 0x00000b1000007947ULL, 0x000fea0003800000ULL,
0x0000000c1c647810ULL, 0x040fe20007ffe0ffULL, 0x000000011c267824ULL, 0x040fe200078e029dULL,
0x000000081c2a7810ULL, 0x000fc40007ffe0ffULL, 0x000000041c287810ULL, 0x000fe20007ffe0ffULL,
0x0000000164667824ULL, 0x140fe200078e029dULL, 0x0000000721297812ULL, 0x000fe200078ef826ULL,
0x00000008646b7824ULL, 0x000fe200078e00ffULL, 0x0000009d28277210ULL, 0x080fe20007ffe0ffULL,
0x000000012a2b7824ULL, 0x000fe200078e029dULL, 0x0000001c1c6c7810ULL, 0x000fe20007ffe0ffULL,
0x000000082a6a7824ULL, 0x000fe200078e00ffULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee266ULL,
0x0000000828687824ULL, 0x000fe200078e00ffULL, 0x000000101c667810ULL, 0x000fe20007ffe0ffULL,
0x000000086c727824ULL, 0x000fe200078e00ffULL, 0xfffffff86a677812ULL, 0x000fe200078ee22bULL,
0x000000016c2b7824ULL, 0x100fe200078e029dULL, 0x000000181c6a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000166217824ULL, 0x000fe200078e029dULL, 0xfffffff868657812ULL, 0x000fe200078ee227ULL,
0x00000008666e7824ULL, 0x000fe200078e00ffULL, 0x000000141c687810ULL, 0x000fe20007ffe0ffULL,
0x000000016a277824ULL, 0x000fe200078e029dULL, 0xfffffff872737812ULL, 0x000fe200078ee22bULL,
0x000000086a707824ULL, 0x000fe200078e00ffULL, 0xfffffff86e6d7812ULL, 0x000fe200078ee221ULL,
0x0000000168267824ULL, 0x000fe200078e029dULL, 0x000000201c6e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000128287824ULL, 0x000fe200078e0269ULL, 0xfffffff870717812ULL, 0x000fe200078ee227ULL,
0x000000012a2a7824ULL, 0x000fe200078e0269ULL, 0x00000003686f7819ULL, 0x000fe200000006ffULL,
0x000000016e217824ULL, 0x000fe200078e029dULL, 0x000000241c707810ULL, 0x000fe20007ffe0ffULL,
0x000000086e7a7824ULL, 0x000fe200078e00ffULL, 0x000000281c727810ULL, 0x000fe20007ffe0ffULL,
0x0000000164647824ULL, 0x000fe200078e0269ULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee226ULL,
0x0000000170267824ULL, 0x000fe200078e029dULL, 0x0000002c1c787810ULL, 0x000fe20007ffe0ffULL,
0x00000008707b7824ULL, 0x000fe200078e00ffULL, 0x0000009d72277210ULL, 0x040fe20007ffe0ffULL,
0x00000008727c7824ULL, 0x000fe200078e00ffULL, 0xfffffff87a797812ULL, 0x000fe200078ee221ULL,
0x00000001782b7824ULL, 0x000fe200078e029dULL, 0x000000301c7a7810ULL, 0x000fe20007ffe0ffULL,
0x00000008787e7824ULL, 0x000fe200078e00ffULL, 0xfffffff87b7b7812ULL, 0x000fe200078ee226ULL,
0x000000011c267824ULL, 0x000fe200078e0269ULL, 0xfffffff87c7d7812ULL, 0x000fe200078ee227ULL,
0x000000017a217824ULL, 0x000fe200078e029dULL, 0x000000341c7c7810ULL, 0x000fe20007ffe0ffULL,
0x0000010026267825ULL, 0x000fe200078e00ffULL, 0x000000381c847810ULL, 0x020fc40007ffe0ffULL,
0x0000003c1c887810ULL, 0x000fe20007ffe0ffULL, 0x0000000166667824ULL, 0x100fe200078e0269ULL,
0x000000037a8c7819ULL, 0x000fe200000006ffULL, 0x000000016a6a7824ULL, 0x000fe200078e0269ULL,
0xfffffff87e7f7812ULL, 0x000fe200078ee22bULL, 0x000000016c6c7824ULL, 0x100fe200078e0269ULL,
0x0000006968687210ULL, 0x000fe20007ffe0ffULL, 0x000000016e6e7824ULL, 0x100fe200078e0269ULL,
0x0000001679977211ULL, 0x000fe200078e20ffULL, 0x0000000170707824ULL, 0x100fe200078e0269ULL,
0x0000000388ad7819ULL, 0x000fe200000006ffULL, 0x0000000172727824ULL, 0x000fc400078e0269ULL,
0x0000000178787824ULL, 0x100fe400078e0269ULL, 0x000000017a1c7824ULL, 0x100fe400078e0269ULL,
0x000000017c7e7824ULL, 0x100fe400078e0269ULL, 0x0000000184867824ULL, 0x100fe400078e0269ULL,
0x00000001888a7824ULL, 0x000fe200078e0269ULL, 0xfffffff88c697812ULL, 0x000fe200078ee221ULL,
0x000000017c2b7824ULL, 0x000fe200078e029dULL, 0x0000002226217212ULL, 0x000fe200078efcffULL,
0x000000087c8e7824ULL, 0x000fc400078e00ffULL, 0x0000001029877824ULL, 0x000fe200078e0216ULL,
0x0000002124267210ULL, 0x000fe20007f1e0ffULL, 0x0000010028287825ULL, 0x000fe200078e00ffULL,
0xfffffff88e857812ULL, 0x000fc600078ee22bULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x0000002228217212ULL, 0x000fc600078efcffULL, 0x0000001065897824ULL, 0x100fe200078e0216ULL,
0x0000002124287210ULL, 0x000fe20007f3e0ffULL, 0x0000010064647825ULL, 0x000fe200078e00ffULL,
0x000000222a217212ULL, 0x080fe400078efcffULL, 0x0000002925297210ULL, 0x000fe20000ffe4ffULL,
0x00000010678b7824ULL, 0x000fe400078e0216ULL, 0x0000000125277824ULL, 0x000fe200000e0627ULL,
0x00000021242a7210ULL, 0x000fe20007f1e0ffULL, 0x0000010066667825ULL, 0x000fe200078e00ffULL,
0x0000002264217212ULL, 0x000fc400078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026877faeULL, 0x0003e2000b901c48ULL, 0x0000001069a77824ULL, 0x100fe400078e0216ULL,
0x000000106d8f7824ULL, 0x100fe200078e0216ULL, 0x00000022666d7212ULL, 0x080fe200078efcffULL,
0x0000010068687825ULL, 0x000fe200078e00ffULL, 0x0000000028897faeULL, 0x0003e4000b901c48ULL,
0x0000006d24667210ULL, 0x040fe20007f3e0ffULL, 0x00000001252b7824ULL, 0x000fe200000e062bULL,
0x0000002124647210ULL, 0x000fe20007f1e0ffULL, 0x000000106b8d7824ULL, 0x000fe200078e0216ULL,
0x0000002268217212ULL, 0x000fe200078efcffULL, 0x000001006a6a7825ULL, 0x000fe200078e00ffULL,
0x000000002a8b7faeULL, 0x0003e6000b901c48ULL, 0x000001006c6c7825ULL, 0x000fc800078e00ffULL,
0x000000106f917824ULL, 0x100fe200078e0216ULL, 0x000000226a6f7212ULL, 0x080fe200078efcffULL,
0x0000000125657824ULL, 0x000fe200000e0665ULL, 0x0000002124687210ULL, 0x000fe20007f1e0ffULL,
0x0000001071937824ULL, 0x100fe200078e0216ULL, 0x000000226c217212ULL, 0x000fe200078efcffULL,
0x0000010070707825ULL, 0x000fe200078e00ffULL, 0x0000006f246a7210ULL, 0x000fe20007f5e0ffULL,
0x00000000648d7faeULL, 0x0003e4000b901c48ULL, 0x0000001073957824ULL, 0x000fc400078e0216ULL,
0x0000000125697824ULL, 0x000fe200000e0669ULL, 0x00000021246c7210ULL, 0x000fe20007f1e0ffULL,
0x000001006e6e7825ULL, 0x000fe200078e00ffULL, 0x0000002270217212ULL, 0x000fc600078efcffULL,
0x0000010072727825ULL, 0x000fc800078e00ffULL, 0x00000001847a7824ULL, 0x040fe400078e029dULL,
0x0000000884a97824ULL, 0x000fe400078e00ffULL, 0x000000107ba17824ULL, 0x000fe200078e0216ULL,
0x000000226e7b7212ULL, 0x000fe200078efcffULL, 0x0000010078787825ULL, 0x000fe200078e00ffULL,
0xfffffff8a9a97812ULL, 0x000fc600078ee27aULL, 0x00000001887c7824ULL, 0x000fe400078e029dULL,
0x000000107da37824ULL, 0x000fe200078e0216ULL, 0x00000022727d7212ULL, 0x080fe200078efcffULL,
0x00000001256d7824ULL, 0x040fe200000e066dULL, 0x0000002124707210ULL, 0x040fe20007f1e0ffULL,
0x0000000125677824ULL, 0x040fe200008e0667ULL, 0x0000007b246e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001256b7824ULL, 0x000fe200010e066bULL, 0x0000002278217212ULL, 0x000fe200078efcffULL,
0x000001001c7a7825ULL, 0x000fe200078e00ffULL, 0xfffffff8adad7812ULL, 0x000fe200078ee27cULL,
0x00000000668f7faeULL, 0x0003e2000b901c48ULL, 0x0000007d24727210ULL, 0x000fe20007f5e0ffULL,
0x000000107fa57824ULL, 0x000fc400078e0216ULL, 0x000001007e7c7825ULL, 0x000fe200078e00ffULL,
0x0000007325737210ULL, 0x000fe200017fe4ffULL, 0x0000000068917faeULL, 0x0003e4000b901c48ULL,
0x0000001085ab7824ULL, 0x000fe400078e0216ULL, 0x0000000125717824ULL, 0x000fe200000e0671ULL,
0x0000002124787210ULL, 0x000fe20007f1e0ffULL, 0x00000100867e7825ULL, 0x000fe200078e00ffULL,
0x000000227a217212ULL, 0x000fe200078efcffULL, 0x000000006a937faeULL, 0x0003e4000b901c48ULL,
0x000001008a847825ULL, 0x000fc400078e00ffULL, 0x000000006c957faeULL, 0x0003e4000b901c48ULL,
0x00000010a9af7824ULL, 0x100fe200078e0216ULL, 0x000000227ca97212ULL, 0x080fe200078efcffULL,
0x00000010adb37824ULL, 0x000fe200078e0216ULL, 0x000000227ead7212ULL, 0x080fe200078efcffULL,
0x0000000125797824ULL, 0x040fe200000e0679ULL, 0x0000002284b17212ULL, 0x000fe200078efcffULL,
0x00000001256f7824ULL, 0x000fe200008e066fULL, 0x00000021247a7210ULL, 0x040fe40007f1e0ffULL,
0x000000a9247c7210ULL, 0x000fc40007f3e0ffULL, 0x000000ad247e7210ULL, 0x040fe20007f5e0ffULL,
0x00000001257b7824ULL, 0x040fe200000e067bULL, 0x000000b124247210ULL, 0x000fe20007f7e0ffULL,
0x00000001257d7824ULL, 0x040fe200008e067dULL, 0x000000006e977faeULL, 0x0003e2000b901c48ULL,
0x00000001257f7824ULL, 0x040fe400010e067fULL, 0x0000000125257824ULL, 0x000fe200018e0685ULL,
0x0000000070a17faeULL, 0x0003e8000b901c48ULL, 0x0000000072a37faeULL, 0x0003e8000b901c48ULL,
0x0000000078a57faeULL, 0x0003e8000b901c48ULL, 0x000000007aa77faeULL, 0x0003e8000b901c48ULL,
0x000000007cab7faeULL, 0x0003e8000b901c48ULL, 0x000000007eaf7faeULL, 0x0003e8000b901c48ULL,
0x0000000024b37faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001017257824ULL, 0x002fe200078e00ffULL, 0x00000008141c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001020217824ULL, 0x000fe200078e00ffULL, 0x000000081f167810ULL, 0x000fc40007ffe0ffULL,
0x0000400018187810ULL, 0x000fe40007ffe0ffULL, 0xfffffff0251c7812ULL, 0x000fe400078ee21cULL,
0xfffffff021167812ULL, 0x000fe200078ee216ULL, 0x0000001015247824ULL, 0x100fe200078e0218ULL,
0x000000180f7c7211ULL, 0x000fe200078e20ffULL, 0x000000101c1c7824ULL, 0x000fe200078e00ffULL,
0x0000000416167819ULL, 0x000fe200000006ffULL, 0x00000010126c7824ULL, 0x100fe400078e0218ULL,
0x0000001011687824ULL, 0x000fe200078e0218ULL, 0x0000000a1f117810ULL, 0x000fe20007ffe0ffULL,
0x0000001020127824ULL, 0x000fc400078e00ffULL, 0x0000001017157824ULL, 0x000fe400078e00ffULL,
0x0000001010107824ULL, 0x000fe200078e0218ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000002424783bULL, 0x000fe20000000200ULL, 0xfffffff012117812ULL, 0x000fe200078ee211ULL,
0x0000001013707824ULL, 0x100fe200078e0218ULL, 0x0000000a14127810ULL, 0x000fe20007ffe0ffULL,
0x000000001628783bULL, 0x0002a20000000200ULL, 0x000000100e887824ULL, 0x000fe400078e0218ULL,
0xfffffff015157812ULL, 0x000fe200078ee212ULL, 0x000000001c64783bULL, 0x000ee20000000200ULL,
0x0000001011787824ULL, 0x000fe400078e00ffULL, 0x000000100d8c7824ULL, 0x000fe200078e0218ULL,
0x000000001010783bULL, 0x000fe20000000200ULL, 0x0000001015157824ULL, 0x000fe200078e00ffULL,
0x0000000c1f0d7810ULL, 0x000fe20007ffe0ffULL, 0x00000010200e7824ULL, 0x040fe200078e00ffULL,
0x000000007878783bULL, 0x000f220000000200ULL, 0x0000001017167824ULL, 0x002fe200078e00ffULL,
0x0000000e1f1f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001020207824ULL, 0x000fe200078e00ffULL,
0x000000001584783bULL, 0x0003220000000200ULL, 0xfffffff00e0d7812ULL, 0x000fe200078ee20dULL,
0x0000001017177824ULL, 0x000fc400078e00ffULL, 0x000000007070783bULL, 0x000f220000000200ULL,
0xfffffff0201f7812ULL, 0x000fe200078ee21fULL, 0x000000100d0d7824ULL, 0x000fe400078e00ffULL,
0x000000006c6c783bULL, 0x000f220000000200ULL, 0x0000000c14157810ULL, 0x002fe20007ffe0ffULL,
0x0000001008087824ULL, 0x100fe200078e0218ULL, 0x0000000e14147810ULL, 0x000fe20007ffe0ffULL,
0x000000006868783bULL, 0x000e620000000200ULL, 0xfffffff016157812ULL, 0x000fe200078ee215ULL,
0x0000001007167824ULL, 0x000fe200078e0218ULL, 0xfffffff017077812ULL, 0x000fe200078ee214ULL,
0x000000007c7c783bULL, 0x000e620000000200ULL, 0x000000101f1f7824ULL, 0x000fc400078e00ffULL,
0x0000001015157824ULL, 0x000fe200078e00ffULL, 0x000000008888783bULL, 0x000e620000000200ULL,
0x0000001007077824ULL, 0x000fe200078e00ffULL, 0x00000024282c723cULL, 0x084f64000000182cULL,
0x000000008c8c783bULL, 0x000eac0000000200ULL, 0x000000246430723cULL, 0x008b6e0000001830ULL,
0x000000100b247824ULL, 0x120fe200078e0218ULL, 0x000000262834723cULL, 0x080f700000001834ULL,
0x000000266438723cULL, 0x000b640000001838ULL, 0x000000002424783bULL, 0x020fec0000000200ULL,
0x00000010782c723cULL, 0x090ff0000000182cULL, 0x000000108430723cULL, 0x000bee0000001830ULL,
0x000000100c107824ULL, 0x120fe200078e0218ULL, 0x000000127834723cULL, 0x080fe20000001834ULL,
0x000000000d0c783bULL, 0x000fee0000000200ULL, 0x000000128438723cULL, 0x000be40000001838ULL,
0x000000001010783bULL, 0x020eec0000000200ULL, 0x000000702840723cULL, 0x040f700000001840ULL,
0x000000722844723cULL, 0x040f700000001844ULL, 0x0000006c2848723cULL, 0x040f700000001848ULL,
0x0000006e284c723cULL, 0x040f70000000184cULL, 0x000000682850723cULL, 0x042f700000001850ULL,
0x0000006a2854723cULL, 0x000b6e0000001854ULL, 0x000000180a287211ULL, 0x0a0fe200078e20ffULL,
0x000000706458723cULL, 0x040b6a0000001858ULL, 0x000000002828783bULL, 0x000e640000000200ULL,
0x0000001805707211ULL, 0x020fe200078e20ffULL, 0x00000072645c723cULL, 0x040b6a000000185cULL,
0x000000007070783bULL, 0x020fe60000000200ULL, 0x0000006c6460723cULL, 0x040f700000001860ULL,
0x0000006e6474723cULL, 0x040b640000001874ULL, 0x000000001f6c783bULL, 0x020fec0000000200ULL,
0x000000686480723cULL, 0x040b6e0000001880ULL, 0x0000001009687824ULL, 0x120fe200078e0218ULL,
0x0000006a643c723cULL, 0x000b62000000183cULL, 0x000000000808783bULL, 0x000fe80000000200ULL,
0x000000006868783bULL, 0x020f260000000200ULL, 0x0000007c7840723cULL, 0x040f620000001840ULL,
0x000000001564783bULL, 0x000e680000000200ULL, 0x000000001614783bULL, 0x000fe60000000200ULL,
0x0000007e7844723cULL, 0x040f700000001844ULL, 0x000000887848723cULL, 0x040f700000001848ULL,
0x0000008a784c723cULL, 0x040f70000000184cULL, 0x0000008c7850723cULL, 0x044f700000001850ULL,
0x0000008e7854723cULL, 0x000f700000001854ULL, 0x0000007c8458723cULL, 0x040f700000001858ULL,
0x0000007e845c723cULL, 0x040f70000000185cULL, 0x000000888460723cULL, 0x040f700000001860ULL,
0x0000008a8474723cULL, 0x040f700000001874ULL, 0x0000008c8480723cULL, 0x040f700000001880ULL,
0x0000008e8484723cULL, 0x000b6e000000183cULL, 0x00000010063c7824ULL, 0x020fe200078e0218ULL,
0x000000100c78723cULL, 0x048be4000000182cULL, 0x00000000072c783bULL, 0x020fe80000000200ULL,
0x000000003c3c783bULL, 0x000ea40000000200ULL, 0x000000120c34723cULL, 0x040ff00000001834ULL,
0x000000240c40723cULL, 0x040ff00000001840ULL, 0x000000260c44723cULL, 0x040ff00000001844ULL,
0x000000280c48723cULL, 0x042f700000001848ULL, 0x0000002a0c4c723cULL, 0x040ff0000000184cULL,
0x000000680c50723cULL, 0x050ff00000001850ULL, 0x0000006a0c54723cULL, 0x000ff00000001854ULL,
0x000000106430723cULL, 0x040ff00000001830ULL, 0x000000126438723cULL, 0x040ff00000001838ULL,
0x00000024640c723cULL, 0x040ff00000001858ULL, 0x00000026645c723cULL, 0x040ff0000000185cULL,
0x000000286410723cULL, 0x040ff00000001860ULL, 0x0000002a6474723cULL, 0x040ff00000001874ULL,
0x000000686424723cULL, 0x040ff00000001880ULL, 0x0000006a6484723cULL, 0x000ff00000001884ULL,
0x0000003c6c48723cULL, 0x064f700000001848ULL, 0x000000086c78723cULL, 0x040f700000001878ULL,
0x0000000a6c34723cULL, 0x040f700000001834ULL, 0x000000146c40723cULL, 0x000f640000001840ULL,
0x3db504f34a297820ULL, 0x020fc40000410000ULL, 0x3db504f34b2a7820ULL, 0x000fe40000410000ULL,
0x3db504f348487820ULL, 0x000fe40000410000ULL, 0x3db504f349497820ULL, 0x000fe20000410000ULL,
0x000000166c44723cULL, 0x000f620000001844ULL, 0x3db504f378077820ULL, 0x000fe40000410000ULL,
0x3db504f379067820ULL, 0x000fe40000410000ULL, 0x3db504f37a7a7820ULL, 0x000fc40000410000ULL,
0x3db504f37b207820ULL, 0x000fe20000410000ULL, 0x0000003e6c4c723cULL, 0x000f62000000184cULL,
0x3db504f336217820ULL, 0x000fe40000410000ULL, 0x3db504f334347820ULL, 0x000fe40000410000ULL,
0x3db504f335357820ULL, 0x000fe40000410000ULL, 0x3db504f337377820ULL, 0x000fe20000410000ULL,
0x000000082c30723cULL, 0x000f620000001830ULL, 0x3db504f340407820ULL, 0x000fc40000410000ULL,
0x3db504f341417820ULL, 0x000fe40000410000ULL, 0x3db504f342427820ULL, 0x000fe40000410000ULL,
0x3db504f343437820ULL, 0x000fe20000410000ULL, 0x000000142c0c723cULL, 0x000f64000000180cULL,
0x3db504f347287820ULL, 0x020fe40000410000ULL, 0x3db504f344447820ULL, 0x000fe40000410000ULL,
0x3db504f345457820ULL, 0x000fc40000410000ULL, 0x3db504f346467820ULL, 0x000fe20000410000ULL,
0x0000003c2c10723cULL, 0x000f620000001810ULL, 0x3db504f34c1f7820ULL, 0x000fe40000410000ULL,
0x3db504f34d187820ULL, 0x000fe40000410000ULL, 0x3db504f34e2b7820ULL, 0x000fe40000410000ULL,
0x3db504f34f4f7820ULL, 0x000fe20000410000ULL, 0x000000706c50723cULL, 0x000f620000001850ULL,
0x3db504f3334a7820ULL, 0x000fc40000410000ULL, 0x3db504f330057820ULL, 0x000fe40000410000ULL,
0x3db504f331227820ULL, 0x000fe40000410000ULL, 0x3db504f332477820ULL, 0x000fe20000410000ULL,
0x0000000a2c08723cULL, 0x000b620000001838ULL, 0x3db504f30d367820ULL, 0x000fe40000410000ULL,
0x3db504f30e4e7820ULL, 0x000fe40000410000ULL, 0x3db504f30f4d7820ULL, 0x000fc60000410000ULL,
0x000000162c14723cULL, 0x040f64000000185cULL, 0x3db504f310397820ULL, 0x020fe40000410000ULL,
0x3db504f3113a7820ULL, 0x000fe40000410000ULL, 0x3db504f312597820ULL, 0x000fe40000410000ULL,
0x3db504f3135a7820ULL, 0x000fe20000410000ULL, 0x0000003e2c3c723cULL, 0x000f620000001874ULL,
0x3db504f3501c7820ULL, 0x000fc40000410000ULL, 0x3db504f351517820ULL, 0x000fe40000410000ULL,
0x3db504f352527820ULL, 0x000fe40000410000ULL, 0x3db504f353537820ULL, 0x000fe20000410000ULL,
0x000000702c24723cULL, 0x000f620000001824ULL, 0x3db504f308337820ULL, 0x000fe40000410000ULL,
0x3db504f30a4b7820ULL, 0x000fe40000410000ULL, 0x3db504f30b4c7820ULL, 0x000fc40000410000ULL,
0x3db504f309097820ULL, 0x000fe20000410000ULL, 0x000000726c54723cULL, 0x080f620000001854ULL,
0x3db504f30c087820ULL, 0x000fe40000410000ULL, 0x3db504f3140a7820ULL, 0x000fe40000410000ULL,
0x3db504f315387820ULL, 0x000fe40000410000ULL, 0x3db504f316507820ULL, 0x000fe20000410000ULL,
0x000000722c2c723cULL, 0x000f640000001884ULL, 0x3db504f33c3b7820ULL, 0x020fc40000410000ULL,
0x3db504f33e5b7820ULL, 0x000fe40000410000ULL, 0x3db504f33f5c7820ULL, 0x000fe40000410000ULL,
0x3db504f317587820ULL, 0x000fe40000410000ULL, 0x3db504f33d3d7820ULL, 0x000fe40000410000ULL,
0x3db504f3240b7820ULL, 0x000fe40000410000ULL, 0x3db504f3253c7820ULL, 0x000fc40000410000ULL,
0x3db504f3265d7820ULL, 0x000fe40000410000ULL, 0x3db504f354547820ULL, 0x000fe40000410000ULL,
0x3db504f355557820ULL, 0x000fe40000410000ULL, 0x3db504f356567820ULL, 0x000fe40000410000ULL,
0x3db504f357577820ULL, 0x000fe40000410000ULL, 0x3db504f3275e7820ULL, 0x000fc40000410000ULL,
0x3db504f32c3e7820ULL, 0x000fe40000410000ULL, 0x3db504f32d3f7820ULL, 0x000fe40000410000ULL,
0x3db504f32e5f7820ULL, 0x000fe40000410000ULL, 0x3db504f32f607820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0052ULL,
0x0000004900177202ULL, 0x000fe20000000f00ULL, 0x000000ffff2e7224ULL, 0x000fe200078e0053ULL,
0x0000004f002c7202ULL, 0x000fe20000000f00ULL, 0x000000009c527f8cULL, 0x0002a2000c80043fULL,
0x000000ffff0f7224ULL, 0x000fc400078e0041ULL, 0x000000ffff117224ULL, 0x000fe400078e0045ULL,
0x000000ffff267224ULL, 0x000fe400078e0043ULL, 0x000000ffff277224ULL, 0x000fe400078e0046ULL,
0x000000ffff497224ULL, 0x000fe400078e004aULL, 0x000000ffff0c7224ULL, 0x000fe400078e0034ULL,
0x000000ffff0d7224ULL, 0x000fc400078e0035ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0040ULL,
0x000000ffff107224ULL, 0x000fe400078e0044ULL, 0x000000ffff137224ULL, 0x000fe400078e0048ULL,
0x000000ffff247224ULL, 0x000fe200078e0037ULL, 0x0000000a00377202ULL, 0x000fe20000000f00ULL,
0x000000ffff257224ULL, 0x000fe400078e0042ULL, 0x000000ffff417224ULL, 0x000fc400078e003cULL,
0x000000ffff437224ULL, 0x000fe400078e003eULL, 0x000000ffff457224ULL, 0x000fe400078e003fULL,
0x000000ffff467224ULL, 0x000fe400078e0047ULL, 0x000000ffff4a7224ULL, 0x000fe400078e004bULL,
0x000000ffff4f7224ULL, 0x000fe200078e004dULL, 0x00000058004d7202ULL, 0x000fe20000000f00ULL,
0x000000ffff157224ULL, 0x000fc400078e0051ULL, 0x000000ffff167224ULL, 0x000fe400078e0054ULL,
0x000000ffff147224ULL, 0x000fe400078e0055ULL, 0x000000ffff127224ULL, 0x000fe400078e007aULL,
0x000000ffff2f7224ULL, 0x000fe400078e0056ULL, 0x000000ffff307224ULL, 0x000fe400078e0057ULL,
0x000000ffff317224ULL, 0x000fc400078e0005ULL, 0x000000ffff327224ULL, 0x000fe400078e0022ULL,
0x000000ffff347224ULL, 0x000fe400078e0009ULL, 0x000000ffff357224ULL, 0x000fe400078e0008ULL,
0x000000ffff407224ULL, 0x000fe400078e000bULL, 0x000000ffff4b7224ULL, 0x000fe400078e0059ULL,
0x000000ffff3c7224ULL, 0x000fc400078e005aULL, 0x000000ffff3e7224ULL, 0x000fe400078e005bULL,
0x000000ffff3f7224ULL, 0x000fe400078e005cULL, 0x000000ffff427224ULL, 0x000fe400078e005dULL,
0x000000ffff447224ULL, 0x000fe400078e005eULL, 0x000000ffff477224ULL, 0x000fe400078e005fULL,
0x000000ffff487224ULL, 0x000fc400078e0060ULL, 0x0000000000087805ULL, 0x006fca0000015200ULL,
0x000004009c057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fc40007804853ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ff00227202ULL, 0x000fe20000000f00ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140bULL,
0x0000000a05057211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e060bULL,
0x0000000205057819ULL, 0x000fc8000000120aULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000122227810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004009c057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804853ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000049d227824ULL, 0x000fe200078e00ffULL, 0x000000991d00720cULL, 0x000fc80003f06070ULL,
0xfffffff022057812ULL, 0x000fca00078ec0ffULL, 0x000000801e057824ULL, 0x000fca00078e0205ULL,
0x01e4000005087984ULL, 0x0002a20000000c00ULL, 0x00001f5000008947ULL, 0x000fea0003800000ULL,
0x000000029d527824ULL, 0x000fe200078e00ffULL, 0x000000231b547217ULL, 0x000fe20007800000ULL,
0x00000002ff697424ULL, 0x000fe200078e00ffULL, 0x000000009d1d7211ULL, 0x000fe400078ff0ffULL,
0x0000000652527812ULL, 0x000fe200078ec0ffULL, 0x0000000154237824ULL, 0x000fe200078e0a23ULL,
0x00005a00ff567a19ULL, 0x000fe4000001161dULL, 0x0000580052547a10ULL, 0x000fe20007ffe0ffULL,
0x000000019a587824ULL, 0x000fe200078e0252ULL, 0x000000081d517810ULL, 0x000fc40007ffe0ffULL,
0x000000101d537810ULL, 0x040fe40007ffe0ffULL, 0x000000235800720cULL, 0x000fe40003f26070ULL,
0x000000181d557810ULL, 0x000fe40007ffe0ffULL, 0x0000005823587210ULL, 0x000fe40007ffe1ffULL,
0x000000569b1d7217ULL, 0x000fe20003800000ULL, 0x0000000154567824ULL, 0x000fe200078e0a23ULL,
0x00005a00ff5a7a19ULL, 0x000fc40000011651ULL, 0x000000589b587217ULL, 0x040fe20003800000ULL,
0x0000001d987c7224ULL, 0x000fe200078e02ffULL, 0x0000005a9b517217ULL, 0x040fe40003800000ULL,
0x000000235400720cULL, 0x000fe40003f06070ULL, 0x000000569b567217ULL, 0x000fe20003800000ULL,
0x0000005198827224ULL, 0x000fe200078e02ffULL, 0x00000004ff587819ULL, 0x000fe40000011658ULL,
0x00005a00ff5e7a19ULL, 0x000fc40000011655ULL, 0x000000ff56677207ULL, 0x000fe40000000000ULL,
0x00005a00ff5c7a19ULL, 0x000fe40000011653ULL, 0x000000ff58537207ULL, 0x000fe40000800000ULL,
0x0000005e9b517217ULL, 0x000fe40003800000ULL, 0x0000007c67587211ULL, 0x000fe200078fe0ffULL,
0x000000017c567824ULL, 0x000fe200078e0253ULL, 0x0000005c9b1d7217ULL, 0x000fe20003800000ULL,
0x0000005198867224ULL, 0x000fe200078e02ffULL, 0x00000082675a7211ULL, 0x000fe200078fe0ffULL,
0x0000600058587625ULL, 0x000fc800078e0069ULL, 0x0000600056567625ULL, 0x000fc800078e0069ULL,
0x0000000153647824ULL, 0x000fe400078e0286ULL, 0x0000001d98847224ULL, 0x000fe200078e02ffULL,
0x0000000856567981ULL, 0x000722000c1e9500ULL, 0x000060005a5a7625ULL, 0x000fc600078e0069ULL,
0x00000008581d7981ULL, 0x000322000c1e9500ULL, 0x00000084675c7211ULL, 0x000fe200078fe0ffULL,
0x0000000153607824ULL, 0x040fe400078e0282ULL, 0x0000000153627824ULL, 0x000fe200078e0284ULL,
0x000000085a517981ULL, 0x000522000c1e9500ULL, 0x0000600064587625ULL, 0x002fe200078e0069ULL,
0x0000001052647812ULL, 0x000fc800078efcffULL, 0x0000580064667a10ULL, 0x000fe20007ffe0ffULL,
0x0000600060607625ULL, 0x080fe200078e0069ULL, 0x00000086675e7211ULL, 0x000fe200078fe0ffULL,
0x0000000858687981ULL, 0x000324000c1e9500ULL, 0x0000600062627625ULL, 0x000fc800078e0069ULL,
0x000000019a6a7824ULL, 0x000fe200078e0264ULL, 0x0000000860607981ULL, 0x000322000c1e9500ULL,
0x000060005c5c7625ULL, 0x000fe200078e0069ULL, 0x000000236600720cULL, 0x040fe40003f06070ULL,
0x0000000862627981ULL, 0x000322000c1e9500ULL, 0x00000001665a7824ULL, 0x104fe400078e0a23ULL,
0x000000016a6c7824ULL, 0x000fe200078e0a23ULL, 0x000000085c537981ULL, 0x000524000c1e9500ULL,
0x0000005a9b5a7217ULL, 0x000fc40003800000ULL, 0x0000006c9b6c7217ULL, 0x000fe40003800000ULL,
0x000000ff5a737207ULL, 0x000fe20000000000ULL, 0x000060005e5e7625ULL, 0x000fe200078e0069ULL,
0x000000236a00720cULL, 0x000fe40003f26070ULL, 0x00000004ff6c7819ULL, 0x000fe4000001166cULL,
0x0000007c73587211ULL, 0x002fe200078fe0ffULL, 0x000000085e557981ULL, 0x000322000c1e9500ULL,
0x000000ff6c5d7207ULL, 0x004fc60000800000ULL, 0x0000600058587625ULL, 0x000fe200078e0069ULL,
0x0000005d7c6a7210ULL, 0x000fe40007ffe0ffULL, 0x00000082735a7211ULL, 0x000fe200078fe0ffULL,
0x000000015d707824ULL, 0x040fe200078e0282ULL, 0x0000002052747812ULL, 0x000fe200078efcffULL,
0x000000015d6c7824ULL, 0x000fe200078e0284ULL, 0x0000000858577981ULL, 0x0084e2000c1e9500ULL,
0x000060006a6a7625ULL, 0x000fc800078e0069ULL, 0x0000600070707625ULL, 0x080fe200078e0069ULL,
0x0000580074767a10ULL, 0x000fe20007ffe0ffULL, 0x000000086a6a7981ULL, 0x0002e4000c1e9500ULL,
0x000060005a5a7625ULL, 0x080fe400078e0069ULL, 0x0000000870707981ULL, 0x0002e4000c1e9500ULL,
0x000060006c587625ULL, 0x004fe400078e0069ULL, 0x000000085a617981ULL, 0x0004e4000c1e9500ULL,
0x000000019a6c7824ULL, 0x000fe200078e0274ULL, 0x00000084735c7211ULL, 0x000fe200078fe0ffULL,
0x000000015d787824ULL, 0x000fe200078e0286ULL, 0x00000086735e7211ULL, 0x002fe200078fe0ffULL,
0x000000016c6e7824ULL, 0x100fe200078e0a23ULL, 0x000000237600720cULL, 0x040fe20003f06070ULL,
0x0000000858727981ULL, 0x0002e2000c1e9500ULL, 0x00000001765a7824ULL, 0x004fc400078e0a23ULL,
0x0000006e9b6e7217ULL, 0x040fe20003800000ULL, 0x0000600078787625ULL, 0x000fe200078e0069ULL,
0x000000236c00720cULL, 0x000fe40003f26070ULL, 0x0000005a9b5a7217ULL, 0x000fe20003800000ULL,
0x000060005c5c7625ULL, 0x080fe200078e0069ULL, 0x00000004ff6e7819ULL, 0x000fe2000001166eULL,
0x0000000878787981ULL, 0x0004e4000c1e9500ULL, 0x000060005e5e7625ULL, 0x000fe200078e0069ULL,
0x000000ff5a777207ULL, 0x000fe20000000000ULL, 0x000000085c637981ULL, 0x0004e2000c1e9500ULL,
0x000000ff6e597207ULL, 0x002fc60000800000ULL, 0x000000085e657981ULL, 0x0002e2000c1e9500ULL,
0x00000082776e7211ULL, 0x000fe200078fe0ffULL, 0x00000001596c7824ULL, 0x000fe200078e0282ULL,
0x0000007c775a7211ULL, 0x000fc600078fe0ffULL, 0x000060006e6e7625ULL, 0x000fc800078e0069ULL,
0x000060006c6c7625ULL, 0x080fe200078e0069ULL, 0x000000086e717981ULL, 0x0004e2000c1e9500ULL,
0x00000084775e7211ULL, 0x042fe400078fe0ffULL, 0x000060005a5a7625ULL, 0x080fe200078e0069ULL,
0x000000086cd47981ULL, 0x0002e2000c1e9500ULL, 0x0000008677587211ULL, 0x000fe400078fe0ffULL,
0x000000017c7a7824ULL, 0x000fe200078e0259ULL, 0x00000084595c7210ULL, 0x044fe20007ffe0ffULL,
0x00000001597e7824ULL, 0x000fe200078e0286ULL, 0x0000003052ba7812ULL, 0x000fe200078efcffULL,
0x000000085a6b7981ULL, 0x0004e2000c1e9500ULL, 0x000060007a7a7625ULL, 0x000fc800078e0069ULL,
0x000060005e5e7625ULL, 0x080fe200078e0069ULL, 0x00005800babc7a10ULL, 0x000fe20007ffe0ffULL,
0x000000087a7a7981ULL, 0x0002e4000c1e9500ULL, 0x0000600058587625ULL, 0x080fe400078e0069ULL,
0x000000085e757981ULL, 0x0002e4000c1e9500ULL, 0x000060007e5a7625ULL, 0x084fe400078e0069ULL,
0x0000000858dc7981ULL, 0x0004e4000c1e9500ULL, 0x000060005c5c7625ULL, 0x000fc400078e0069ULL,
0x000000085a837981ULL, 0x0002e4000c1e9500ULL, 0x000000019a7e7824ULL, 0x000fe400078e02baULL,
0x000000085cd87981ULL, 0x0002e4000c1e9500ULL, 0x000000017e807824ULL, 0x100fe400078e0a23ULL,
0x00000001bc6e7824ULL, 0x000fc600078e0a23ULL, 0x000000809b807217ULL, 0x040fe40003800000ULL,
0x000000237e00720cULL, 0x080fe40003f26070ULL, 0x00000023bc00720cULL, 0x000fe40003f06070ULL,
0x0000006e9b6e7217ULL, 0x000fe40003800000ULL, 0x00000004ff807819ULL, 0x000fe40000011680ULL,
0x000000ff6e797207ULL, 0x000fc40000000000ULL, 0x000000ff807b7207ULL, 0x002fe40000800000ULL,
0x0000007c796c7211ULL, 0x040fe400078fe0ffULL, 0x00000084795a7211ULL, 0x000fe200078fe0ffULL,
0x000000017c6e7824ULL, 0x000fe400078e027bULL, 0x000000017b5e7824ULL, 0x000fe400078e0284ULL,
0x000060006c6c7625ULL, 0x000fc800078e0069ULL, 0x000060006e6e7625ULL, 0x080fe200078e0069ULL,
0x000000086cbe7981ULL, 0x0002e6000c1e9500ULL, 0x000060005a5a7625ULL, 0x080fe200078e0069ULL,
0x000000086e7d7981ULL, 0x0002e6000c1e9500ULL, 0x000060005e5e7625ULL, 0x000fe200078e0069ULL,
0x000000085ada7981ULL, 0x0002e2000c1e9500ULL, 0x0000008279587211ULL, 0x004fc600078fe0ffULL,
0x000000085e817981ULL, 0x0004e2000c1e9500ULL, 0x000000017b5c7824ULL, 0x000fe400078e0282ULL,
0x0000600058587625ULL, 0x000fc800078e0069ULL, 0x000060005c5c7625ULL, 0x000fe200078e0069ULL,
0x0000000858d67981ULL, 0x0004e2000c1e9500ULL, 0x00000086796c7211ULL, 0x002fc600078fe0ffULL,
0x000000085c7f7981ULL, 0x0002e2000c1e9500ULL, 0x000000017b6e7824ULL, 0x000fe400078e0286ULL,
0x000060006c6c7625ULL, 0x000fc800078e0069ULL, 0x000060006e6e7625ULL, 0x000fe200078e0069ULL,
0x000000086cde7981ULL, 0x0002e8000c1e9500ULL, 0x000000086e857981ULL, 0x0002e2000c1e9500ULL,
0xfffffff067587812ULL, 0x004fca00078ec0ffULL, 0x0000000123597824ULL, 0x000fe200078e0258ULL,
0x0000000100d27802ULL, 0x000fc60000000f00ULL, 0x0000000154587824ULL, 0x000fe200078e0a59ULL,
0x00000001527c7812ULL, 0x000fc800078efcffULL, 0x00000058d2587219ULL, 0x000fe400000006ffULL,
0x000058007c5a7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff0735c7812ULL, 0x002fc600078ec0ffULL,
0x000000015a5b7824ULL, 0x100fe200078e0a59ULL, 0x00000008527e7812ULL, 0x040fe200078efcffULL,
0x00000001235f7824ULL, 0x000fe200078e025cULL, 0x0000000952807812ULL, 0x000fe400078efcffULL,
0x0000005bd25c7219ULL, 0x000fe400000006ffULL, 0x000058007e5e7a10ULL, 0x000fe40007ffe0ffULL,
0x00005800806e7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff0776c7812ULL, 0x000fe200078ec0ffULL,
0x000000015e5d7824ULL, 0x100fe200078e0a59ULL, 0xfffffff079827812ULL, 0x000fe200078ec0ffULL,
0x000000016e597824ULL, 0x000fe200078e0a59ULL, 0x0000001152867812ULL, 0x000fe200078efcffULL,
0x0000000123677824ULL, 0x040fe200078e026cULL, 0x0000005dd26c7219ULL, 0x040fe200000006ffULL,
0x0000000123737824ULL, 0x000fe200078e0282ULL, 0x00000059d2827219ULL, 0x000fc400000006ffULL,
0x0000580086887a10ULL, 0x000fe40007ffe0ffULL, 0x8000005f66597210ULL, 0x000fc60007ffe0ffULL,
0x00000001885b7824ULL, 0x000fe200078e0a5fULL, 0x00000018528c7812ULL, 0x000fe400078efcffULL,
0x000054101d1d7816ULL, 0x010fc80000000056ULL, 0x0000001d58ff7212ULL, 0x000fc800078ac0ffULL,
0x000000235400720cULL, 0x000fc80002fa1470ULL, 0x000000235200720cULL, 0x000fe40002fa1070ULL,
0x0000001d5cff7212ULL, 0x000fe4000782c0ffULL, 0xff80000007077808ULL, 0x000fe40002800000ULL,
0x0000541051517816ULL, 0x000fc80000000060ULL, 0x0000005158ff7212ULL, 0x080fe4000784c0ffULL,
0x0000541053537816ULL, 0x000fe40000000062ULL, 0x000000515cff7212ULL, 0x000fe400078ac0ffULL,
0x0000005358ff7212ULL, 0x000fe4000788c0ffULL, 0x000000235400720cULL, 0x0c0fe40001741470ULL,
0x000000235400720cULL, 0x000fc40002781470ULL, 0x000000235a00720cULL, 0x0c0fe40000f21470ULL,
0x000000235a00720cULL, 0x080fe40002fa1470ULL, 0x000000235200720cULL, 0x0c0fe40001741070ULL,
0x000000235200720cULL, 0x080fe40002781070ULL, 0x000000237c00720cULL, 0x0c0fe40000f21070ULL,
0x000000237c00720cULL, 0x000fc40002fa1070ULL, 0x0000541055557816ULL, 0x000fe40000000068ULL,
0xff80000012127808ULL, 0x000fe40001000000ULL, 0xff80000031317808ULL, 0x000fe40002000000ULL,
0xff80000006067808ULL, 0x000fe40000800000ULL, 0xff80000020207808ULL, 0x000fe40002800000ULL,
0x0000001d6cff7212ULL, 0x000fc4000786c0ffULL, 0x0000005558ff7212ULL, 0x000fe4000780c0ffULL,
0x000000535cff7212ULL, 0x040fe4000784c0ffULL, 0x000000555cff7212ULL, 0x000fe4000788c0ffULL,
0x0000005182ff7212ULL, 0x000fe4000782c0ffULL, 0x000000536cff7212ULL, 0x000fe400078ac0ffULL,
0x000000235400720cULL, 0x000fc40000701470ULL, 0x000000235a00720cULL, 0x0c0fe40001741470ULL,
0x000000235a00720cULL, 0x080fe40002781470ULL, 0x000000235e00720cULL, 0x0c0fe40001f61470ULL,
0x000000235e00720cULL, 0x080fe40002fa1470ULL, 0x000000236e00720cULL, 0x000fe40000f21470ULL,
0x0000001952947812ULL, 0x000fc400078efcffULL, 0x000000235200720cULL, 0x080fe40000701070ULL,
0x000000237c00720cULL, 0x0c0fe40001741070ULL, 0x000000237c00720cULL, 0x080fe40002781070ULL,
0x000000237e00720cULL, 0x0c0fe40001f61070ULL, 0x000000237e00720cULL, 0x080fe40002fa1070ULL,
0x000000238000720cULL, 0x000fc40000f21070ULL, 0x00000059d2847219ULL, 0x040fe400000006ffULL,
0x0000005bd28a7219ULL, 0x000fe400000006ffULL, 0x0000541057577816ULL, 0x008fe4000000006aULL,
0x0000541061617816ULL, 0x000fe40000000070ULL, 0x000058008c8e7a10ULL, 0x000fe40007ffe0ffULL,
0x0000580094967a10ULL, 0x000fc40007ffe0ffULL, 0xff80000046467808ULL, 0x000fe40000000000ULL,
0xff80000032327808ULL, 0x000fe40001000000ULL, 0xff80000049497808ULL, 0x000fe40002000000ULL,
0xff8000000c0c7808ULL, 0x000fe40001800000ULL, 0xff80000033337808ULL, 0x000fe40002800000ULL,
0xff80000024247808ULL, 0x000fc40000800000ULL, 0x000000516cff7212ULL, 0x000fe4000780c0ffULL,
0x0000005382ff7212ULL, 0x000fe4000784c0ffULL, 0x000000556cff7212ULL, 0x080fe4000788c0ffULL,
0x0000005582ff7212ULL, 0x000fe4000786c0ffULL, 0x000000578aff7212ULL, 0x000fe400078ac0ffULL,
0x0000006184ff7212ULL, 0x000fe2000782c0ffULL, 0x000000018e5d7824ULL, 0x100fe200078e0a5fULL,
0x000000235e00720cULL, 0x080fe20000701470ULL, 0x00000001965f7824ULL, 0x000fe200078e0a5fULL,
0x000000235e00720cULL, 0x000fc40002781470ULL, 0x000000236e00720cULL, 0x0c0fe40001741470ULL,
0x000000236e00720cULL, 0x080fe40001f61470ULL, 0x000000236600720cULL, 0x080fe40000f21470ULL,
0x000000238800720cULL, 0x080fe40002fa1470ULL, 0x000000237e00720cULL, 0x0c0fe40000701070ULL,
0x000000237e00720cULL, 0x000fc40002781070ULL, 0x000000238000720cULL, 0x0c0fe40001741070ULL,
0x000000238000720cULL, 0x080fe40001f61070ULL, 0x000000236400720cULL, 0x080fe40000f21070ULL,
0x000000238600720cULL, 0x000fe40002fa1070ULL, 0x0000005dd2927219ULL, 0x040fe400000006ffULL,
0x0000005fd2a47219ULL, 0x000fc400000006ffULL, 0x0000541063637816ULL, 0x000fe40000000072ULL,
0x0000541065657816ULL, 0x000fe40000000078ULL, 0xff80000021217808ULL, 0x000fe40000000000ULL,
0xff8000004a4a7808ULL, 0x000fe40002000000ULL, 0xff80000034347808ULL, 0x000fe40001000000ULL,
0xff8000004c4c7808ULL, 0x000fc40001800000ULL, 0xff80000025257808ULL, 0x000fe40000800000ULL,
0xff8000000f0f7808ULL, 0x000fe40002800000ULL, 0x0000005784ff7212ULL, 0x080fe4000780c0ffULL,
0x0000005792ff7212ULL, 0x000fe4000788c0ffULL, 0x0000006384ff7212ULL, 0x040fe4000784c0ffULL,
0x0000006584ff7212ULL, 0x000fc4000786c0ffULL, 0x000000638aff7212ULL, 0x000fe4000782c0ffULL,
0x00000061a4ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000176697824ULL, 0x000fe200078e0a67ULL,
0x000000236600720cULL, 0x0c0fe40000701470ULL, 0x000000236600720cULL, 0x0c0fe40001741470ULL,
0x000000236600720cULL, 0x080fe40001f61470ULL, 0x000000238800720cULL, 0x000fc40000f21470ULL,
0x000000238e00720cULL, 0x080fe40002781470ULL, 0x000000239600720cULL, 0x080fe40002fa1470ULL,
0x0000002152a87812ULL, 0x000fe400078efcffULL, 0x000000236400720cULL, 0x0c0fe40000701070ULL,
0x000000236400720cULL, 0x0c0fe40001741070ULL, 0x000000236400720cULL, 0x000fc40001f61070ULL,
0x000000238600720cULL, 0x080fe40000f21070ULL, 0x000000238c00720cULL, 0x080fe40002781070ULL,
0x000000239400720cULL, 0x000fe40002fa1070ULL, 0x00000069d2a67219ULL, 0x000fe400000006ffULL,
0x0000541071717816ULL, 0x000fe400000000d4ULL, 0x00005800a8aa7a10ULL, 0x000fc40007ffe0ffULL,
0xff8000000e0e7808ULL, 0x000fe40000000000ULL, 0xff80000035357808ULL, 0x000fe40001000000ULL,
0xff8000004e4e7808ULL, 0x000fe40001800000ULL, 0xff80000036367808ULL, 0x000fe40000800000ULL,
0xff80000010107808ULL, 0x000fe40002000000ULL, 0xff80000028287808ULL, 0x000fc40002800000ULL,
0x000000618aff7212ULL, 0x040fe4000780c0ffULL, 0x000000658aff7212ULL, 0x000fe4000784c0ffULL,
0x0000006192ff7212ULL, 0x000fe4000786c0ffULL, 0x00000063a4ff7212ULL, 0x040fe4000782c0ffULL,
0x00000065a4ff7212ULL, 0x000fe4000788c0ffULL, 0x00000071a6ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001aa6d7824ULL, 0x000fe200078e0a67ULL, 0x000000238800720cULL, 0x000fc40000701470ULL,
0x000000238800720cULL, 0x080fe40001741470ULL, 0x000000238e00720cULL, 0x080fe40001f61470ULL,
0x000000239600720cULL, 0x0c0fe40000f21470ULL, 0x000000239600720cULL, 0x080fe40002781470ULL,
0x000000237600720cULL, 0x000fe40002fa1470ULL, 0x0000002852ae7812ULL, 0x000fc400078efcffULL,
0x0000002952b47812ULL, 0x000fe400078efcffULL, 0x000000238600720cULL, 0x0c0fe40000701070ULL,
0x000000238600720cULL, 0x080fe40001741070ULL, 0x000000238c00720cULL, 0x080fe40001f61070ULL,
0x000000239400720cULL, 0x0c0fe40000f21070ULL, 0x000000239400720cULL, 0x000fc40002781070ULL,
0x000000237400720cULL, 0x000fe40002fa1070ULL, 0x0000006dd2ac7219ULL, 0x000fe400000006ffULL,
0x000054106b6b7816ULL, 0x000fe4000000007aULL, 0x0000541075757816ULL, 0x000fe400000000d8ULL,
0x00005410dc837816ULL, 0x000fe40000000083ULL, 0x00005800aeb07a10ULL, 0x000fc40007ffe0ffULL,
0x00005800b4b67a10ULL, 0x000fe40007ffe0ffULL, 0xff80000026267808ULL, 0x000fe40000000000ULL,
0xff8000004f4f7808ULL, 0x000fe40001000000ULL, 0xff80000027277808ULL, 0x000fe40001800000ULL,
0xff80000038387808ULL, 0x000fe40000800000ULL, 0xff8000004d4d7808ULL, 0x000fc40002000000ULL,
0xff80000029297808ULL, 0x000fe40002800000ULL, 0x0000001d82ff7212ULL, 0x000fe400078cc0ffULL,
0x0000006392ff7212ULL, 0x040fe4000780c0ffULL, 0x0000006592ff7212ULL, 0x000fe4000784c0ffULL,
0x0000006ba6ff7212ULL, 0x040fe4000786c0ffULL, 0x00000075a6ff7212ULL, 0x000fc4000782c0ffULL,
0x00000083a6ff7212ULL, 0x000fe4000788c0ffULL, 0x00000075acff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b06f7824ULL, 0x100fe200078e0a67ULL, 0x000000236e00720cULL, 0x080fe200037c1470ULL,
0x00000001b6677824ULL, 0x000fe200078e0a67ULL, 0x000000238e00720cULL, 0x0c0fe40000701470ULL,
0x000000238e00720cULL, 0x080fe40001741470ULL, 0x000000237600720cULL, 0x000fc40001f61470ULL,
0x000000237600720cULL, 0x0c0fe40000f21470ULL, 0x000000237600720cULL, 0x080fe40002781470ULL,
0x00000023aa00720cULL, 0x080fe40002fa1470ULL, 0x000000238000720cULL, 0x080fe400037c1070ULL,
0x000000238c00720cULL, 0x0c0fe40000701070ULL, 0x000000238c00720cULL, 0x000fc40001741070ULL,
0x000000237400720cULL, 0x0c0fe40001f61070ULL, 0x000000237400720cULL, 0x0c0fe40000f21070ULL,
0x000000237400720cULL, 0x080fe40002781070ULL, 0x00000023a800720cULL, 0x000fe40002fa1070ULL,
0x0000006fd2b27219ULL, 0x040fe400000006ffULL, 0x00000067d2b87219ULL, 0x000fc400000006ffULL,
0xff8000000d0d7808ULL, 0x000fe40003000000ULL, 0xff80000037377808ULL, 0x000fe40000000000ULL,
0xff80000050507808ULL, 0x000fe40001000000ULL, 0xff80000013137808ULL, 0x000fe40001800000ULL,
0xff80000039397808ULL, 0x000fe40000800000ULL, 0xff8000004b4b7808ULL, 0x000fc40002000000ULL,
0xff8000003a3a7808ULL, 0x000fe40002800000ULL, 0x00000057a4ff7212ULL, 0x000fe400078cc0ffULL,
0x0000006bacff7212ULL, 0x080fe4000780c0ffULL, 0x0000006bb2ff7212ULL, 0x000fe4000784c0ffULL,
0x00000071acff7212ULL, 0x040fe4000786c0ffULL, 0x00000083acff7212ULL, 0x000fc4000782c0ffULL,
0x00000071b2ff7212ULL, 0x000fe4000788c0ffULL, 0x00000075b8ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001bc777824ULL, 0x000fe200078e0a73ULL, 0x000000239600720cULL, 0x080fe400037c1470ULL,
0x00000023aa00720cULL, 0x0c0fe40000701470ULL, 0x00000023aa00720cULL, 0x0c0fe40001f61470ULL,
0x00000023aa00720cULL, 0x000fc40000f21470ULL, 0x00000023b000720cULL, 0x0c0fe40001741470ULL,
0x00000023b000720cULL, 0x080fe40002781470ULL, 0x00000023b600720cULL, 0x000fe40002fa1470ULL,
0x0000003852c87812ULL, 0x040fe400078efcffULL, 0x0000003152c27812ULL, 0x040fe400078efcffULL,
0x0000003952ce7812ULL, 0x000fc400078efcffULL, 0x000000239400720cULL, 0x080fe400037c1070ULL,
0x00000023a800720cULL, 0x0c0fe40000701070ULL, 0x00000023a800720cULL, 0x0c0fe40001f61070ULL,
0x00000023a800720cULL, 0x080fe40000f21070ULL, 0x00000023ae00720cULL, 0x0c0fe40001741070ULL,
0x00000023ae00720cULL, 0x000fc40002781070ULL, 0x00000023b400720cULL, 0x000fe40002fa1070ULL,
0x00000077d2c07219ULL, 0x000fe400000006ffULL, 0x00005410be7d7816ULL, 0x000fe4000000007dULL,
0x00005410da817816ULL, 0x000fe40000000081ULL, 0x00005800c8ca7a10ULL, 0x000fe40007ffe0ffULL,
0x00005800c2c47a10ULL, 0x000fc40007ffe0ffULL, 0x00005800ced07a10ULL, 0x000fe40007ffe0ffULL,
0xff80000011117808ULL, 0x000fe40003000000ULL, 0xff80000017177808ULL, 0x000fe40000000000ULL,
0xff8000002a2a7808ULL, 0x000fe40001800000ULL, 0xff8000003c3c7808ULL, 0x000fe40000800000ULL,
0xff8000001f1f7808ULL, 0x000fc40001000000ULL, 0xff8000002b2b7808ULL, 0x000fe40002000000ULL,
0xff8000003d3d7808ULL, 0x000fe40002800000ULL, 0x0000006bb8ff7212ULL, 0x040fe400078cc0ffULL,
0x00000071b8ff7212ULL, 0x000fe4000780c0ffULL, 0x00000075b2ff7212ULL, 0x040fe4000786c0ffULL,
0x00000083b2ff7212ULL, 0x000fc4000782c0ffULL, 0x00000083b8ff7212ULL, 0x000fe4000784c0ffULL,
0x0000007dc0ff7212ULL, 0x040fe4000788c0ffULL, 0x00000081c0ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001ca7b7824ULL, 0x100fe200078e0a73ULL, 0x000000c473797210ULL, 0x000fe20007ffe1ffULL,
0x00000001d0737824ULL, 0x000fe200078e0a73ULL, 0x00000023b000720cULL, 0x0c0fe40001f61470ULL,
0x00000023b000720cULL, 0x000fc40000f21470ULL, 0x00000023b600720cULL, 0x0c0fe400037c1470ULL,
0x00000023b600720cULL, 0x0c0fe40000701470ULL, 0x00000023b600720cULL, 0x080fe40001741470ULL,
0x00000023bc00720cULL, 0x0c0fe40002781470ULL, 0x00000023bc00720cULL, 0x000fe40002fa1470ULL,
0x00000079d2c67219ULL, 0x000fc400000006ffULL, 0x0000007bd2cc7219ULL, 0x000fe400000006ffULL,
0x00000023ae00720cULL, 0x0c0fe40001f61070ULL, 0x00000023ae00720cULL, 0x080fe40000f21070ULL,
0x00000023b400720cULL, 0x0c0fe400037c1070ULL, 0x00000023b400720cULL, 0x0c0fe40000701070ULL,
0x00000023b400720cULL, 0x000fc40001741070ULL, 0x00000023ba00720cULL, 0x0c0fe40002781070ULL,
0x00000023ba00720cULL, 0x000fe40002fa1070ULL, 0x00000073d2d27219ULL, 0x000fe400000006ffULL,
0x00005410d67f7816ULL, 0x000fe4000000007fULL, 0xff8000003b3b7808ULL, 0x000fe40001800000ULL,
0xff8000003e3e7808ULL, 0x000fc40000800000ULL, 0xff80000018187808ULL, 0x000fe40003000000ULL,
0xff8000002c2c7808ULL, 0x000fe40000000000ULL, 0xff8000003f3f7808ULL, 0x000fe40001000000ULL,
0xff8000001c1c7808ULL, 0x000fe40002000000ULL, 0xff80000040407808ULL, 0x000fe40002800000ULL,
0x0000007dc6ff7212ULL, 0x000fc4000786c0ffULL, 0x0000007dccff7212ULL, 0x080fe4000782c0ffULL,
0x0000007dd2ff7212ULL, 0x000fe400078cc0ffULL, 0x0000007fc0ff7212ULL, 0x080fe4000780c0ffULL,
0x0000007fc6ff7212ULL, 0x080fe4000784c0ffULL, 0x0000007fccff7212ULL, 0x000fe4000788c0ffULL,
0x00000081c6ff7212ULL, 0x000fc400078ac0ffULL, 0x00000023bc00720cULL, 0x080fe40000701470ULL,
0x00000023c400720cULL, 0x0c0fe40001f61470ULL, 0x00000023c400720cULL, 0x0c0fe40001741470ULL,
0x00000023c400720cULL, 0x080fe40002fa1470ULL, 0x00000023ca00720cULL, 0x080fe40000f21470ULL,
0x00000023d000720cULL, 0x000fc400037c1470ULL, 0x00000023ca00720cULL, 0x080fe40002781470ULL,
0x00000023ba00720cULL, 0x080fe40000701070ULL, 0x00000023c200720cULL, 0x0c0fe40001f61070ULL,
0x00000023c200720cULL, 0x0c0fe40001741070ULL, 0x00000023c200720cULL, 0x080fe40002fa1070ULL,
0x00000023c800720cULL, 0x000fc40000f21070ULL, 0x00000023ce00720cULL, 0x080fe400037c1070ULL,
0x00000023c800720cULL, 0x000fe40002781070ULL, 0x00005410de857816ULL, 0x000fe40000000085ULL,
0xff8000002d2d7808ULL, 0x000fe40000000000ULL, 0xff80000015157808ULL, 0x000fe40001800000ULL,
0xff8000002e2e7808ULL, 0x000fc40001000000ULL, 0xff80000041417808ULL, 0x000fe40002800000ULL,
0xff80000016167808ULL, 0x000fe40000800000ULL, 0xff80000014147808ULL, 0x000fe40003000000ULL,
0xff8000002f2f7808ULL, 0x000fe40002000000ULL, 0x0000007fd2ff7212ULL, 0x000fe4000780c0ffULL,
0x00000081ccff7212ULL, 0x000fc4000786c0ffULL, 0x00000081d2ff7212ULL, 0x000fe4000784c0ffULL,
0x00000085c0ff7212ULL, 0x080fe400078ac0ffULL, 0x00000085c6ff7212ULL, 0x080fe4000782c0ffULL,
0x00000085ccff7212ULL, 0x080fe400078cc0ffULL, 0x00000085d2ff7212ULL, 0x000fe4000788c0ffULL,
0x00000023bc00720cULL, 0x000fc40002fa1470ULL, 0x00000023c400720cULL, 0x080fe40000f21470ULL,
0x00000023ca00720cULL, 0x0c0fe40001f61470ULL, 0x00000023ca00720cULL, 0x080fe400037c1470ULL,
0x00000023d000720cULL, 0x0c0fe40000701470ULL, 0x00000023d000720cULL, 0x0c0fe40001741470ULL,
0x00000023d000720cULL, 0x000fc40002781470ULL, 0x00000023ba00720cULL, 0x080fe40002fa1070ULL,
0x00000023c200720cULL, 0x080fe40000f21070ULL, 0x00000023ce00720cULL, 0x080fe40000701070ULL,
0x00000023c800720cULL, 0x0c0fe40001f61070ULL, 0x00000023c800720cULL, 0x080fe400037c1070ULL,
0x00000023ce00720cULL, 0x000fc40001741070ULL, 0x00000023ce00720cULL, 0x000fe40002781070ULL,
0xff80000030307808ULL, 0x000fe40000000000ULL, 0xff80000043437808ULL, 0x000fe40001800000ULL,
0xff80000045457808ULL, 0x000fe40001000000ULL, 0xff80000042427808ULL, 0x000fe40002800000ULL,
0xff80000044447808ULL, 0x000fc40000800000ULL, 0xff80000047477808ULL, 0x000fe40003000000ULL,
0xff80000048487808ULL, 0x000fc40002000000ULL, 0x000000070800720bULL, 0x004fe40003f1e000ULL,
0x000000120900720bULL, 0x000fe40003f3e000ULL, 0x000000310a00720bULL, 0x000fe40003f5e000ULL,
0x000000460b00720bULL, 0x000fe40003f7e000ULL, 0x00000008071d7208ULL, 0x000fc40004000000ULL,
0x0000000912097208ULL, 0x000fe40004800000ULL, 0x0000000a31237208ULL, 0x000fe40005000000ULL,
0x0000000b46087208ULL, 0x000fe40005800000ULL, 0x000000061d00720bULL, 0x000fe40003f1e000ULL,
0x000000200900720bULL, 0x000fe40003f3e000ULL, 0x000000322300720bULL, 0x000fc40003f5e000ULL,
0x000000490800720bULL, 0x000fe40003f7e000ULL, 0x0000001d061d7208ULL, 0x000fe40004000000ULL,
0x00000009200a7208ULL, 0x000fe40004800000ULL, 0x0000002332527208ULL, 0x000fe40005000000ULL,
0x0000000849097208ULL, 0x000fe40005800000ULL, 0x0000000c1d00720bULL, 0x000fc40003f1e000ULL,
0x000000210a00720bULL, 0x000fe40003f3e000ULL, 0x000000335200720bULL, 0x000fe40003f5e000ULL,
0x0000004a0900720bULL, 0x000fe40003f7e000ULL, 0x0000001d0c087208ULL, 0x000fe40004000000ULL,
0x0000000a210b7208ULL, 0x000fe40004800000ULL, 0x00000052331d7208ULL, 0x000fc40005000000ULL,
0x000000094a097208ULL, 0x000fe40005800000ULL, 0x0000000d0800720bULL, 0x000fe40003f1e000ULL,
0x000000240b00720bULL, 0x000fe40003f3e000ULL, 0x000000341d00720bULL, 0x000fe40003f5e000ULL,
0x0000004c0900720bULL, 0x000fe40003f7e000ULL, 0x000000080d237208ULL, 0x000fc40004000000ULL,
0x0000000b24087208ULL, 0x000fe40004800000ULL, 0x0000001d340a7208ULL, 0x000fe40005000000ULL,
0x000000094c097208ULL, 0x000fe40005800000ULL, 0x0000000e2300720bULL, 0x000fe40003f1e000ULL,
0x000000250800720bULL, 0x000fe40003f3e000ULL, 0x000000350a00720bULL, 0x000fc40003f5e000ULL,
0x0000004e0900720bULL, 0x000fe40003f7e000ULL, 0x000000230e527208ULL, 0x000fe40004000000ULL,
0x00000008250b7208ULL, 0x000fe40004800000ULL, 0x0000000a351d7208ULL, 0x000fe40005000000ULL,
0x000000094e087208ULL, 0x000fe40005800000ULL, 0x0000000f5200720bULL, 0x000fc40003f1e000ULL,
0x000000260b00720bULL, 0x000fe40003f3e000ULL, 0x000000361d00720bULL, 0x000fe40003f5e000ULL,
0x0000004f0800720bULL, 0x000fe40003f7e000ULL, 0x000000520f097208ULL, 0x000fe40004000000ULL,
0x0000000b260a7208ULL, 0x000fe40004800000ULL, 0x0000001d36527208ULL, 0x000fc40005000000ULL,
0x000000084f0b7208ULL, 0x000fe40005800000ULL, 0x000000100900720bULL, 0x000fe40003f1e000ULL,
0x000000270a00720bULL, 0x000fe40003f3e000ULL, 0x000000375200720bULL, 0x000fe40003f5e000ULL,
0x000000500b00720bULL, 0x000fe40003f7e000ULL, 0x0000000910087208ULL, 0x000fc40004000000ULL,
0x0000000a27097208ULL, 0x000fe40004800000ULL, 0x00000052371d7208ULL, 0x000fe40005000000ULL,
0x0000000b500a7208ULL, 0x000fe40005800000ULL, 0x000000110800720bULL, 0x000fe40003f1e000ULL,
0x000000280900720bULL, 0x000fe40003f3e000ULL, 0x000000381d00720bULL, 0x000fc40003f5e000ULL,
0x0000004d0a00720bULL, 0x000fe40003f7e000ULL, 0x0000000811087208ULL, 0x000fe40004000000ULL,
0x0000000928527208ULL, 0x000fe40004800000ULL, 0x0000001d38547208ULL, 0x000fe40005000000ULL,
0x0000000a4d0a7208ULL, 0x000fe40005800000ULL, 0x000000130800720bULL, 0x000fc40003f1e000ULL,
0x000000295200720bULL, 0x000fe40003f3e000ULL, 0x000000395400720bULL, 0x000fe40003f5e000ULL,
0x0000004b0a00720bULL, 0x000fe40003f7e000ULL, 0x0000000813087208ULL, 0x000fe40004000000ULL,
0x0000005229097208ULL, 0x000fe40004800000ULL, 0x00000054390b7208ULL, 0x000fc40005000000ULL,
0x0000000a4b1d7208ULL, 0x000fe40005800000ULL, 0x000000170800720bULL, 0x000fe40003f1e000ULL,
0x0000002a0900720bULL, 0x000fe40003f3e000ULL, 0x0000003a0b00720bULL, 0x000fe40003f5e000ULL,
0x0000003c1d00720bULL, 0x000fe40003f7e000ULL, 0x0000000817087208ULL, 0x000fc40004000000ULL,
0x000000092a0a7208ULL, 0x000fe40004800000ULL, 0x0000000b3a527208ULL, 0x000fe40005000000ULL,
0x0000001d3c1d7208ULL, 0x000fe40005800000ULL, 0x0000001f0800720bULL, 0x000fe40003f1e000ULL,
0x0000002b0a00720bULL, 0x000fe40003f3e000ULL, 0x0000003b5200720bULL, 0x000fc40003f5e000ULL,
0x0000003e1d00720bULL, 0x000fe40003f7e000ULL, 0x000000081f097208ULL, 0x000fe40004000000ULL,
0x0000000a2b0b7208ULL, 0x000fe40004800000ULL, 0x000000523b527208ULL, 0x000fe40005000000ULL,
0x0000001d3e087208ULL, 0x000fe40005800000ULL, 0x000000180900720bULL, 0x000fc40003f1e000ULL,
0x0000002c0b00720bULL, 0x000fe40003f3e000ULL, 0x0000003d5200720bULL, 0x000fe40003f5e000ULL,
0x0000003f0800720bULL, 0x000fe40003f7e000ULL, 0x0000000918097208ULL, 0x000fe40004000000ULL,
0x0000000b2c0a7208ULL, 0x000fe40004800000ULL, 0x000000523d0b7208ULL, 0x000fc40005000000ULL,
0x000000083f1d7208ULL, 0x000fe40005800000ULL, 0x0000001c0900720bULL, 0x000fe40003f1e000ULL,
0x0000002d0a00720bULL, 0x000fe40003f3e000ULL, 0x000000400b00720bULL, 0x000fe40003f5e000ULL,
0x000000421d00720bULL, 0x000fe40003f7e000ULL, 0x000000091c087208ULL, 0x000fc40004000000ULL,
0x0000000a2d097208ULL, 0x000fe40004800000ULL, 0x0000000b400a7208ULL, 0x000fe40005000000ULL,
0x0000001d421d7208ULL, 0x000fe40005800000ULL, 0x000000150800720bULL, 0x000fe40003f1e000ULL,
0x0000002e0900720bULL, 0x000fe40003f3e000ULL, 0x000000410a00720bULL, 0x000fc40003f5e000ULL,
0x000000441d00720bULL, 0x000fe40003f7e000ULL, 0x00000008150b7208ULL, 0x000fe40004000000ULL,
0x000000092e087208ULL, 0x000fe40004800000ULL, 0x0000000a410a7208ULL, 0x000fe40005000000ULL,
0x0000001d44527208ULL, 0x000fe40005800000ULL, 0x000000160b00720bULL, 0x000fc40003f1e000ULL,
0x0000002f0800720bULL, 0x000fe40003f3e000ULL, 0x000000430a00720bULL, 0x000fe40003f5e000ULL,
0x000000475200720bULL, 0x000fe40003f7e000ULL, 0x0000000b160b7208ULL, 0x000fe40004000000ULL,
0x000000082f097208ULL, 0x000fe40004800000ULL, 0x0000000a430a7208ULL, 0x000fc40005000000ULL,
0x00000052471d7208ULL, 0x000fe40005800000ULL, 0x000000140b00720bULL, 0x000fe40003f1e000ULL,
0x000000300900720bULL, 0x000fe40003f3e000ULL, 0x000000450a00720bULL, 0x000fe40003f5e000ULL,
0x000000481d00720bULL, 0x000fe40003f7e000ULL, 0x0000000b140b7208ULL, 0x000fc40004000000ULL,
0x0000000930237208ULL, 0x000fe40004800000ULL, 0x0000000a45517208ULL, 0x000fe40005000000ULL,
0x0000001d48577208ULL, 0x000fe20005800000ULL, 0x000024827f007947ULL, 0x000fea000b800000ULL,
0x0c401f000b087f89ULL, 0x0004e400000e0000ULL, 0x000000080b00720bULL, 0x008fc80003f1e000ULL,
0x0000000b08597208ULL, 0x000fe20004000000ULL, 0x000024b27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0023087f89ULL, 0x000ee800000e0000ULL, 0x0c401f0051097f89ULL, 0x000f2800000e0000ULL,
0x0c401f00570a7f89ULL, 0x000e6200000e0000ULL, 0x000000082300720bULL, 0x008fc40003f1e000ULL,
0x000000095100720bULL, 0x010fe40003f3e000ULL, 0x00000023080b7208ULL, 0x006fe40004000000ULL,
0x00000051091d7208ULL, 0x000fe20004800000ULL, 0x0c201f0059087f89ULL, 0x000e6200000e0000ULL,
0x0000000a5700720bULL, 0x000fc60003f1e000ULL, 0x0c201f000b527f89ULL, 0x000ea200000e0000ULL,
0x000000570a557208ULL, 0x000fc60004000000ULL, 0x0c201f001d547f89ULL, 0x000ee800000e0000ULL,
0x0c201f0055567f89ULL, 0x0002e400000e0000ULL, 0x000000085900720bULL, 0x002fe40003f1e000ULL,
0x000000520b00720bULL, 0x004fe40003f3e000ULL, 0x0000005908087208ULL, 0x000fc40004000000ULL,
0x000000541d00720bULL, 0x008fe40003f5e000ULL, 0x0000000b52097208ULL, 0x000fe40004800000ULL,
0x0000001d540a7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b080b7820ULL, 0x002fe20000410000ULL,
0x000000565500720bULL, 0x004fe20003f1e000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x3fb8aa3b18547823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b07077823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b06067823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe2000001080bULL,
0x0000005400547308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b0f0f7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b10107823ULL, 0x100fe2000001080bULL, 0x0000000c00537308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b11117823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b131d7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b17527823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe2000001080bULL,
0x0000000f005a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b15517823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b16187823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b14237823ULL, 0x000fe2000001080bULL, 0x0000000d00587308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b090b7820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b0a0c7820ULL, 0x002fe40000410000ULL,
0x3fb8aa3b12127823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001080bULL,
0x0000000700077308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b21217823ULL, 0x000fc4000001080bULL,
0x3fb8aa3b24247823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b25257823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001080bULL, 0x00000021000f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b27277823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b28287823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b29297823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001080bULL,
0x0000000600067308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe4000001080bULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe4000001080bULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080bULL, 0x0000002900217308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2f2f7823ULL, 0x000fc4000001080bULL, 0x3fb8aa3b300b7823ULL, 0x000fe2000001080bULL,
0x00000002ff307819ULL, 0x000fe2000001169dULL, 0x3fb8aa3b31317823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001080cULL, 0x0000000b00687308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b33337823ULL, 0x100fe2000001080cULL, 0x0000000330147810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b34347823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b35357823ULL, 0x000fc4000001080cULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001080cULL, 0x0000001000597308ULL, 0x000fe20000000800ULL,
0x00000055560b7208ULL, 0x002fe20004000000ULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001080cULL,
0x0000000330557819ULL, 0x000fe200000006ffULL, 0x3fb8aa3b38387823ULL, 0x100fe2000001080cULL,
0x000000039dff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b0b297820ULL, 0x000fe40000410000ULL,
0x00000011005c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b39397823ULL, 0x000fc4000001080cULL,
0x3fb8aa3b46467823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b49497823ULL, 0x100fe40000010829ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010829ULL, 0x00000012000d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b4c4c7823ULL, 0x000fe40000010829ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b3b3b7823ULL, 0x000fc4000001080cULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe2000001080cULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x3fb8aa3b40407823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b41417823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b43437823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b450c7823ULL, 0x000fe2000001080cULL, 0x0000002400247308ULL, 0x000ea20000000800ULL,
0x0000000830457824ULL, 0x000fc400078e00ffULL, 0x0000000830617824ULL, 0x040fe400078e00ffULL,
0x0000000830637824ULL, 0x040fe400078e00ffULL, 0x0000000830657824ULL, 0x040fe200078e00ffULL,
0x0000002b005b7308ULL, 0x000fe20000000800ULL, 0xfffffff861617812ULL, 0x000fe200078ee214ULL,
0x0000000830677824ULL, 0x040fe200078e00ffULL, 0x0000000630147810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010829ULL, 0x0000000d200d723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe20000010829ULL, 0xfffffff867677812ULL, 0x000fe200078ee214ULL,
0x0000003100107308ULL, 0x0003e20000000800ULL, 0x0000000f240f723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010829ULL, 0xffffffff30147810ULL, 0x040fe20007ffe0ffULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010829ULL, 0x0000000830207810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b4b4b7823ULL, 0x000fc40000010829ULL, 0x0000003200117308ULL, 0x0004e20000000800ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe20000010829ULL, 0x0000001030317810ULL, 0x002fe20007ffe0ffULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe40000010829ULL,
0x3fb8aa3b42427823ULL, 0x100fe20000010829ULL, 0x0000003300127308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b44447823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b47477823ULL, 0x000fc40000010829ULL,
0x3fb8aa3b48487823ULL, 0x000fe40000010829ULL, 0x0000000831327824ULL, 0x004fe200078e00ffULL,
0x0000003400137308ULL, 0x000e620000000800ULL, 0x000000101110723eULL, 0x008fce00000000ffULL,
0x0000004600467308ULL, 0x000ff00000000800ULL, 0x0000004900497308ULL, 0x000ea20000000800ULL,
0x000000121312723eULL, 0x002fce00000000ffULL, 0x0000004a004a7308ULL, 0x000ff00000000800ULL,
0x0000004c002b7308ULL, 0x000e620000000800ULL, 0x000000464911723eULL, 0x004fe400000000ffULL,
0x0000000c22497812ULL, 0x000fca00078ec0ffULL, 0x0000000c00567308ULL, 0x0005f00000000800ULL,
0x0000000e00577308ULL, 0x0007220000000800ULL, 0x00000001300c7810ULL, 0x004fe40007ffe0ffULL,
0x0000004a2b13723eULL, 0x002fc400000000ffULL, 0xfffffff845457812ULL, 0x000fe400078ee20cULL,
0x00000004300c7810ULL, 0x040fe20007ffe0ffULL, 0x0000002800607308ULL, 0x000fe20000000800ULL,
0x00000002300e7810ULL, 0x048fe40007ffe0ffULL, 0xfffffff863637812ULL, 0x000fe400078ee20cULL,
0xfffffff855557812ULL, 0x000fe400078ee20eULL, 0x00000005300e7810ULL, 0x000fe20007ffe0ffULL,
0x0000002a00627308ULL, 0x0003e20000000800ULL, 0x00000007060c723eULL, 0x000fe200000000ffULL,
0x3c003c00ff067424ULL, 0x000fe200078e00ffULL, 0xfffffff865657812ULL, 0x000fe200078ee20eULL,
0x3c003c00ff077424ULL, 0x000fe200078e00ffULL, 0x00000053580e723eULL, 0x000fe200000000ffULL,
0x0000000830537824ULL, 0x000fe200078e00ffULL, 0x000000575a24723eULL, 0x010fe200000000ffULL,
0x0000002c00647308ULL, 0x000ea60000000800ULL, 0xfffffff853537812ULL, 0x000fe200078ee214ULL,
0x000000061028723cULL, 0x082fe800000018ffULL, 0x0000002d005d7308ULL, 0x000fe80000000800ULL,
0x000000060c14723cULL, 0x000f6800000018ffULL, 0x0000002e00667308ULL, 0x000fe20000000800ULL,
0x0000005b6433723eULL, 0x004fce00000000ffULL, 0x0000002f005f7308ULL, 0x000ff00000000800ULL,
0x0000002500257308ULL, 0x000ff00000000800ULL, 0x00000026005e7308ULL, 0x0002b00000000800ULL,
0x0000002700277308ULL, 0x000ee20000000800ULL, 0x000000595c26723eULL, 0x002fce00000000ffULL,
0x00000035002c7308ULL, 0x0003e20000000800ULL, 0x000000255e25723eULL, 0x004fce00000000ffULL,
0x00000036002d7308ULL, 0x000ea20000000800ULL, 0x000000276027723eULL, 0x008fe400000000ffULL,
0x0000005d6635723eULL, 0x002fca00000000ffULL, 0x00000037002e7308ULL, 0x0003e20000000800ULL,
0x000000062414723cULL, 0x020f6e0000001814ULL, 0x00000038002f7308ULL, 0x000ee20000000800ULL,
0x0000002c2d2c723eULL, 0x004fe400000000ffULL, 0x0000005f6837723eULL, 0x002fca00000000ffULL,
0x0000004e004e7308ULL, 0x000ff00000000800ULL, 0x0000004f004f7308ULL, 0x000e620000000800ULL,
0x0000002e2f2e723eULL, 0x008fce00000000ffULL, 0x0000005000507308ULL, 0x000ff00000000800ULL,
0x0000004d004d7308ULL, 0x000ea20000000800ULL, 0x0000004e4f2d723eULL, 0x002fe400000000ffULL,
0xfffffff8324f7812ULL, 0x000fc400078ee231ULL, 0x000000216231723eULL, 0x000fc600000000ffULL,
0x0000003d006a7308ULL, 0x0003e20000000800ULL, 0x000000504d2f723eULL, 0x004fce00000000ffULL,
0x0000003900397308ULL, 0x000fe20000000800ULL, 0x00000008303d7824ULL, 0x002fe200078e00ffULL,
0x00000003204d7819ULL, 0x000fe200000006ffULL, 0x000000062c28723cULL, 0x000f660000001828ULL,
0xfffffff83d3d7812ULL, 0x000fe400078ee230ULL, 0x0000003a003a7308ULL, 0x000e620000000800ULL,
0x0000001830307810ULL, 0x000fe40007ffe0ffULL, 0xfffffff84d4d7812ULL, 0x000fc600078ee220ULL,
0x0000000830577824ULL, 0x000fe400078e00ffULL, 0x0000001d001d7308ULL, 0x000fe60000000800ULL,
0xfffffff857577812ULL, 0x000fca00078ee230ULL, 0x0000005200527308ULL, 0x000ea20000000800ULL,
0x000000393a38723eULL, 0x002fce00000000ffULL, 0x0000001f001f7308ULL, 0x000e700000000800ULL,
0x0000003b003b7308ULL, 0x000ee20000000800ULL, 0x0000001d5230723eULL, 0x004fce00000000ffULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x0000001f5432723eULL, 0x002fce00000000ffULL,
0x0000003c003c7308ULL, 0x000e620000000800ULL, 0x0000003b6a3a723eULL, 0x008fe200000000ffULL,
0x000000063014723cULL, 0x020f6c0000001814ULL, 0x0000003e003e7308ULL, 0x000ff00000000800ULL,
0x0000003f003f7308ULL, 0x000ea20000000800ULL, 0x0000004b3c39723eULL, 0x002fce00000000ffULL,
0x0000001800187308ULL, 0x000ff00000000800ULL, 0x0000002300237308ULL, 0x000e620000000800ULL,
0x0000003e3f3b723eULL, 0x004fce00000000ffULL, 0x0000001c001c7308ULL, 0x000fe20000000800ULL,
0x000000063828723cULL, 0x000fee0000001828ULL, 0x0000005100517308ULL, 0x000ea20000000800ULL,
0x000000182336723eULL, 0x002fe400000000ffULL, 0x000120001e187811ULL, 0x000fca00078e60ffULL,
0x0000004000407308ULL, 0x000fe20000000800ULL, 0x0000001045207824ULL, 0x100fe400078e0218ULL,
0x0000001055217824ULL, 0x100fe400078e0218ULL, 0x0000001061227824ULL, 0x100fe400078e0218ULL,
0x0000001063237824ULL, 0x100fe200078e0218ULL, 0x0000004100417308ULL, 0x000fe20000000800ULL,
0x0000001c5134723eULL, 0x004fe200000000ffULL, 0x000000103d1c7824ULL, 0x100fe200078e0218ULL,
0x00000018673d7211ULL, 0x000fe200078e20ffULL, 0x00000010653c7824ULL, 0x000fe200078e0218ULL,
0x0000002349237210ULL, 0x040fe20007ffe0ffULL, 0x00000001491f7824ULL, 0x000fc400078e021cULL,
0x0000004300437308ULL, 0x000e620000000800ULL, 0x0000000149207824ULL, 0x040fe200078e0220ULL,
0x000000063414723cULL, 0x020f620000001814ULL, 0x0000000149217824ULL, 0x000fe200078e0221ULL,
0x0000000c1f007388ULL, 0x0005e20000000800ULL, 0x00000010531c7824ULL, 0x000fe400078e0218ULL,
0x0000000149227824ULL, 0x000fe200078e0222ULL, 0x0000004200427308ULL, 0x000fe20000000800ULL,
0x000000104d3e7824ULL, 0x000fe200078e0218ULL, 0x0000000e20007388ULL, 0x0005e20000000800ULL,
0x00000001493c7824ULL, 0x000fc400078e023cULL, 0x00000001493d7824ULL, 0x040fe200078e023dULL,
0x0000002421007388ULL, 0x0005e20000000800ULL, 0x00000001491c7824ULL, 0x040fe200078e021cULL,
0x00000044001d7308ULL, 0x0007220000000800ULL, 0x000000435646723eULL, 0x002fe200000000ffULL,
0x00000001493e7824ULL, 0x000fe200078e023eULL, 0x0000002622007388ULL, 0x0005e20000000800ULL,
0x000000104f3f7824ULL, 0x100fe400078e0218ULL, 0x0000001057187824ULL, 0x000fe200078e0218ULL,
0x0000003023007388ULL, 0x0005e20000000800ULL, 0x0000004700477308ULL, 0x000fe20000000800ULL,
0x000000404144723eULL, 0x008fe200000000ffULL, 0x00000001493f7824ULL, 0x040fe200078e023fULL,
0x000000323c007388ULL, 0x0005e20000000800ULL, 0x0000000149187824ULL, 0x000fc400078e0218ULL,
0x000000ffff157224ULL, 0x020fe200078e0016ULL, 0x000000343d007388ULL, 0x0005e20000000800ULL,
0x0000004800487308ULL, 0x000e620000000800ULL, 0x000000421d45723eULL, 0x010fe400000000ffULL,
0x000000361c007388ULL, 0x0005e80000000800ULL, 0x0000000d3e007388ULL, 0x0005e80000000800ULL,
0x0004000f20007388ULL, 0x0005e80000000800ULL, 0x0004002521007388ULL, 0x0005e20000000800ULL,
0x000000474847723eULL, 0x002fc600000000ffULL, 0x0004002722007388ULL, 0x0005e80000000800ULL,
0x000000064428723cULL, 0x000f620000001828ULL, 0x0004003123007388ULL, 0x0005e80000000800ULL,
0x000400333c007388ULL, 0x0005e80000000800ULL, 0x000400353d007388ULL, 0x0005e80000000800ULL,
0x000400371c007388ULL, 0x0005e80000000800ULL, 0x000000103f007388ULL, 0x0005e80000000800ULL,
0x0008001220007388ULL, 0x0005e60000000800ULL, 0x000000ffff167224ULL, 0x020fe200078e0028ULL,
0x0008002c21007388ULL, 0x0005e20000000800ULL, 0x0000002a00177202ULL, 0x000fc60000000f00ULL,
0x0008002e22007388ULL, 0x0005e80000000800ULL, 0x0008003823007388ULL, 0x0005e80000000800ULL,
0x0008003a3c007388ULL, 0x0005e80000000800ULL, 0x000800443d007388ULL, 0x0005e80000000800ULL,
0x000800461c007388ULL, 0x0005e80000000800ULL, 0x0000001118007388ULL, 0x0005e80000000800ULL,
0x000c001320007388ULL, 0x0005e80000000800ULL, 0x000c002d21007388ULL, 0x0005e80000000800ULL,
0x000c002f22007388ULL, 0x0005e80000000800ULL, 0x000c003923007388ULL, 0x0005e80000000800ULL,
0x000c003b3c007388ULL, 0x0005e80000000800ULL, 0x000c00453d007388ULL, 0x0005e80000000800ULL,
0x000c00471c007388ULL, 0x0005e80000000800ULL, 0x01e0000805008388ULL, 0x0005e80000000c00ULL,
0x01e2001405008388ULL, 0x0005e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e608009eff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e610009eff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e618009eff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000199000720cULL, 0x000fe20003f06070ULL, 0x01e620009eff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff1d7224ULL, 0x000fd600078e0090ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff768000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff247807ULL, 0x004fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x000196e000267802ULL, 0x000fc40000000f00ULL, 0x000015e000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff037224ULL, 0x000fe200078e0024ULL, 0xfffe96f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe20005000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x0001974000267802ULL, 0x000fc40000000f00ULL, 0x0000158000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff047224ULL, 0x000fe200078e0024ULL, 0xfffe973000007947ULL, 0x000fea000383ffffULL,
0x0000000500267202ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe200078e00ffULL,
0x000197b000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x000014c000007944ULL, 0x018fea0003c00000ULL, 0xfffe97e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0005ULL, 0x0001981000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000146000007944ULL, 0x01afea0003c00000ULL, 0xfffe98f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0005ULL, 0x0001987000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000140000007944ULL, 0x01afea0003c00000ULL, 0xfffe9a0000007947ULL, 0x000fea000383ffffULL,
0x0000000500267202ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe200078e00ffULL,
0x000198d000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x000013a000007944ULL, 0x01afea0003c00000ULL, 0xfffe9b0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0000ULL, 0x0001994000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff247224ULL, 0x000fe400078e0003ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000133000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0024ULL, 0xfffe9c9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0000ULL, 0x0000001f006a7802ULL, 0x000fe20000000f00ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x000199b000257802ULL, 0x000fc40000000f00ULL,
0x000012c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0024ULL,
0x0000001003247810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0000ULL,
0x00019a2000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000125000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0024ULL, 0xfffe9c0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0000ULL, 0xffffffff00277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe200078e00ffULL, 0x00019a9000257802ULL, 0x000fc40000000f00ULL,
0x000011e000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0024ULL,
0xfffe9bc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x008fe40004000000ULL,
0xffffffff00257802ULL, 0x000fc40000000f00ULL, 0x00019af000267802ULL, 0x000fc40000000f00ULL,
0x000011d000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0024ULL,
0xfffeb42000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe20004800000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x00019b5000267802ULL, 0x000fc40000000f00ULL,
0x0000117000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff6e7224ULL, 0x000fe200078e0024ULL,
0xfffeb46000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0070ULL,
0xffffffff00277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe200078e00ffULL,
0x00019bc000257802ULL, 0x000fc40000000f00ULL, 0x000010b000007944ULL, 0x000fea0003c00000ULL,
0xfffeb52000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0070ULL,
0x00019c2000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000105000007944ULL, 0x002fea0003c00000ULL,
0xfffeb63000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0070ULL,
0x00019c8000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000ff000007944ULL, 0x002fea0003c00000ULL,
0xfffeb74000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0070ULL,
0xffffffff00277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe200078e00ffULL,
0x00019ce000257802ULL, 0x000fc40000000f00ULL, 0x00000f9000007944ULL, 0x002fea0003c00000ULL,
0xfffeb84000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000dULL,
0x00019d5000257802ULL, 0x000fe20000000f00ULL, 0x000000ffff247224ULL, 0x000fe400078e0022ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000f2000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0024ULL,
0xfffeb9c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000dULL,
0x00019dc000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000eb000007944ULL, 0x006fea0003c00000ULL,
0x00000024000f7202ULL, 0x004fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fe200078e000dULL,
0x0000001022247810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff6a7424ULL, 0x000fe200078e00ffULL,
0x00019e3000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000e4000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0024ULL,
0xfffeb93000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000dULL,
0x00019ea000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000dd000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0024ULL, 0xfffeb8f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x004fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x00019f0000267802ULL, 0x000fc40000000f00ULL, 0x00000dc000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff697224ULL, 0x000fe200078e0024ULL, 0xfffecf3000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe20004800000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x00019f6000267802ULL, 0x000fc40000000f00ULL, 0x00000d6000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff6c7224ULL, 0x000fe200078e0024ULL, 0xfffecf6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006eULL, 0x00019fd000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fc400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000ca000007944ULL, 0x018fea0003c00000ULL, 0xfffed02000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006eULL, 0x0001a03000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000c4000007944ULL, 0x01afea0003c00000ULL, 0xfffed13000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006eULL, 0x0000001f006a7802ULL, 0x000fe20000000f00ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001a09000257802ULL, 0x000fc40000000f00ULL,
0x00000be000007944ULL, 0x01afea0003c00000ULL, 0xfffed24000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006eULL, 0x0001a0f000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000b8000007944ULL, 0x01afea0003c00000ULL, 0xfffed34000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000dULL, 0x0001a16000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff247224ULL, 0x000fc400078e0022ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000b1000007944ULL, 0x010fea0003c00000ULL,
0x0000002400107202ULL, 0x004fe20000000f00ULL, 0xfffed4c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000dULL, 0x0001a1d000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000aa000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0024ULL,
0x0000001022247810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e000dULL,
0x0001a24000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000a3000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0024ULL, 0xfffed43000007947ULL, 0x000fea000383ffffULL,
0x0000000d00267202ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe200078e00ffULL,
0x0001a2b000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x000009c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0024ULL,
0xfffed3f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x002fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x0001a31000267802ULL, 0x000fc40000000f00ULL,
0x000009b000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff617224ULL, 0x000fe200078e0024ULL,
0xfffee9a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe40004800000ULL,
0xffffffff00257802ULL, 0x000fc40000000f00ULL, 0x0001a37000267802ULL, 0x000fc40000000f00ULL,
0x0000095000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff687224ULL, 0x000fe200078e0024ULL,
0xfffee9d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0012ULL,
0x0001a3e000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000089000007944ULL, 0x018fea0003c00000ULL,
0xfffeea9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0012ULL,
0xffffffff00277802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe200078e00ffULL,
0x0001a44000257802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x01afea0003c00000ULL,
0xfffeeba000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0012ULL,
0x0001a4a000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x000007d000007944ULL, 0x01afea0003c00000ULL,
0xfffeecb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0012ULL,
0x0001a50000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000077000007944ULL, 0x01afea0003c00000ULL,
0xfffeedb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000dULL,
0x0000001f006a7802ULL, 0x000fe20000000f00ULL, 0x000000ffff247224ULL, 0x000fe200078e0012ULL,
0x0001a57000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000070000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0024ULL,
0xfffeef3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000dULL,
0x0001a5e000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000069000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0024ULL, 0x0000001012247810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e000dULL, 0xffffffff00277802ULL, 0x000fe20000000f00ULL,
0x0000001fff6a7424ULL, 0x000fe200078e00ffULL, 0x0001a65000257802ULL, 0x000fc40000000f00ULL,
0x0000062000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0024ULL,
0xfffeeea000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000dULL,
0x0001a6c000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6a7424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x000005b000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0024ULL, 0xfffeee6000007947ULL, 0x000fea000383ffffULL,
0x00000002ff547424ULL, 0x000fe200078e00ffULL, 0x0001a73000527802ULL, 0x000fe20000000f00ULL,
0x0000001fff567424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000050000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0056ULL,
0xffffdb2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0b7224ULL, 0x006fe200078e0023ULL,
0x0000001f00567802ULL, 0x000fe20000000f00ULL, 0x00000002ff547424ULL, 0x000fe200078e00ffULL,
0x0001a7b000527802ULL, 0x000fe20000000f00ULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000048000007944ULL, 0x000fea0003c00000ULL, 0x000000562300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0b7224ULL, 0x002fe200078e0051ULL, 0x0001a83000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff547424ULL, 0x000fe200078e00ffULL, 0x0000002356097208ULL, 0x000fe20004000000ULL,
0x0000001fff567424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000040000007944ULL, 0x000fea0003c00000ULL, 0x000000565100720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0b7224ULL, 0x002fe200078e0057ULL, 0xffffffff005b7802ULL, 0x000fe20000000f00ULL,
0x00000002ff547424ULL, 0x000fe200078e00ffULL, 0x00000051561d7208ULL, 0x000fe20004000000ULL,
0x0000001fff567424ULL, 0x000fe200078e00ffULL, 0x0001a8b000527802ULL, 0x000fc40000000f00ULL,
0x0000038000007944ULL, 0x000fea0003c00000ULL, 0x000000565700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0b7224ULL, 0x002fe200078e0059ULL, 0x0001a93000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff547424ULL, 0x000fe200078e00ffULL, 0x0000005756557208ULL, 0x000fe20004000000ULL,
0x0000001fff567424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0x000000565900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0b7224ULL, 0x002fe200078e0009ULL, 0x0001a9b000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff547424ULL, 0x000fe200078e00ffULL, 0x0000005956087208ULL, 0x000fe20004000000ULL,
0x0000001fff567424ULL, 0x000fe400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000028000007944ULL, 0x000fea0003c00000ULL, 0x000000560900720bULL, 0x004fe20003f1e000ULL,
0x00000001ff547424ULL, 0x002fe200078e00ffULL, 0x0000001d000b7202ULL, 0x000fe20000000f00ULL,
0xffffffffff5b7424ULL, 0x000fe200078e00ffULL, 0x0000000956097208ULL, 0x000fe20004000000ULL,
0x0000001fff567424ULL, 0x000fe200078e00ffULL, 0x0001aa3000527802ULL, 0x000fc40000000f00ULL,
0x0000020000007944ULL, 0x000fea0003c00000ULL, 0x000000561d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0b7224ULL, 0x002fe200078e0055ULL, 0x0001aab000527802ULL, 0x000fe20000000f00ULL,
0x00000001ff547424ULL, 0x000fe200078e00ffULL, 0x0000001d560a7208ULL, 0x000fe20004000000ULL,
0x0000001fff567424ULL, 0x000fc400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000018000007944ULL, 0x000fea0003c00000ULL, 0xffffd91000007947ULL, 0x000fea000383ffffULL,
0x0180000005037810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000003077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000000500038308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff0a7807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x000000030aff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff05ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000005057812ULL, 0x002fe400078ec0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x000000030aff7212ULL, 0x000fda000780c0ffULL,
0x0080000005030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0005ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000500037308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff077424ULL, 0x000fc800078e00ffULL,
0xfffe53d006007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff537424ULL, 0x000fe200078e00ffULL,
0x0000005b00007348ULL, 0x000fe80003800000ULL, 0x0c0000540b567389ULL, 0x0002a200000e0056ULL,
0xfffe539052007950ULL, 0x000fea0003c3ffffULL, 0x0000002700007348ULL, 0x000fe80003800000ULL,
0x0000002426247389ULL, 0x0002a400000e006aULL, 0x000000ffff267224ULL, 0x002fc400078e0025ULL,
0x00000000ff277424ULL, 0x000fc800078e00ffULL, 0xfffe534026007950ULL, 0x000fea0003c3ffffULL,
0x000000012400780cULL, 0x000fe20003f45070ULL, 0x00000000ff277424ULL, 0x000fe200078e00ffULL,
0x0000002500007348ULL, 0x000ff60003800000ULL, 0x0000000000247806ULL, 0x000fc800050e0100ULL,
0x0000002524247212ULL, 0x000fe200078ec0ffULL, 0xfffe52e026007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000100000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x00000000000004c4ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000620ULL,
0x0000000000000240ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000860ULL,
0x0000000000000270ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ad0ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b90ULL,
0x00000000000006c0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001250ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001260ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012f0ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012f4ULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001500ULL,
0x000000000001ae00ULL, 0xe100001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c300ULL,
0x0000000000000038ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c340ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001c6c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000012f0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001b010ULL,
0x000000000001b010ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001c300ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001c6c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_0_m_32_sm_80_cubin_len = 116640;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
