/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_0_m_32_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001aec0ULL, 0x000000000001ab40ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL,
0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL,
0x616e7265746e695fULL, 0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL,
0x705f796c66625f63ULL, 0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL,
0x6c6668735f30376dULL, 0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL,
0x616475635f5f245fULL, 0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL,
0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL,
0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL,
0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000028ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b00220000036fULL, 0x0000000000019310ULL, 0x0000000000000170ULL, 0x000b0022000003a2ULL,
0x0000000000019480ULL, 0x0000000000000040ULL, 0x000b0022000003cdULL, 0x00000000000194c0ULL,
0x0000000000000040ULL, 0x000b0022000003f7ULL, 0x0000000000019500ULL, 0x0000000000000100ULL,
0x000a000300000465ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000485ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004b5ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000019600ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001931000000000ULL, 0x0000040400000000ULL, 0x810c000001500400ULL,
0x0063680400288080ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080900828808081ULL,
0x8016288080860828ULL, 0x0000000310288082ULL, 0x8086920000000000ULL, 0x0000000022002880ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x0001931000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080900828808081ULL, 0xb908288080a00828ULL,
0x288080d008288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080d0ULL,
0x0000001cffffffffULL, 0x000000e800000000ULL, 0x0001948000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080900828808081ULL, 0xa008288080b90828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a0920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x0000016800000000ULL, 0x000194c000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080900828808081ULL, 0xa008288080b90828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a0920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x000001e800000000ULL, 0x0001950000000000ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000001700082f04ULL, 0x00082304000000deULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL,
0x0000000000000011ULL, 0x0000001100081204ULL, 0x0008110400000000ULL, 0x0000000000000011ULL,
0x0000001000082304ULL, 0x0008120400000000ULL, 0x0000000000000010ULL, 0x0000001000081104ULL,
0x0008230400000000ULL, 0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL,
0x0000000000000017ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0060016000000014ULL,
0x000c170400601903ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL,
0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL,
0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00000ab000043104ULL, 0xffffffff01cc2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0000013001cc2804ULL, 0x000004c000000340ULL, 0x00002df000001c90ULL, 0x00002fc000002eb0ULL,
0x000032a000003130ULL, 0x0000361000003400ULL, 0x0000366000003650ULL, 0x00003ff000003690ULL,
0x00004fe000004f40ULL, 0x0000527000005100ULL, 0x00005540000053e0ULL, 0x0000578000005740ULL,
0x000057c000005790ULL, 0x00006e7000005e60ULL, 0x0000702000006f00ULL, 0x0000730000007190ULL,
0x0000766000007460ULL, 0x000076b0000076a0ULL, 0x00007cf0000076e0ULL, 0x00008d8000008cf0ULL,
0x0000901000008ea0ULL, 0x000092e000009180ULL, 0x00009520000094e0ULL, 0x0000956000009530ULL,
0x00009cc000009cb0ULL, 0x00009ce000009cd0ULL, 0x0000cb100000ca60ULL, 0x0000cb500000cb20ULL,
0x0000d7100000d6d0ULL, 0x0000d7300000d720ULL, 0x0001708000017040ULL, 0x000170a000017090ULL,
0x00017110000170f0ULL, 0x0001714000017130ULL, 0x000184e000018490ULL, 0x0001857000018530ULL,
0x000185f0000185b0ULL, 0x0001869000018640ULL, 0x00018730000186e0ULL, 0x000187d000018780ULL,
0x0001886000018820ULL, 0x000188e0000188a0ULL, 0x0001898000018930ULL, 0x00018a20000189d0ULL,
0x00018ac000018a70ULL, 0x00018b5000018b10ULL, 0x00018bd000018b90ULL, 0x00018c7000018c20ULL,
0x00018d1000018cc0ULL, 0x00018db000018d60ULL, 0x00018e4000018e00ULL, 0x00018ec000018e80ULL,
0x00018f6000018f10ULL, 0x0001900000018fb0ULL, 0x000190b000019050ULL, 0x0001917000019110ULL,
0x00019230000191d0ULL, 0x000192f000019290ULL, 0x0000041002003904ULL, 0x00016600000000ffULL,
0x00000460003f0100ULL, 0x000166080000000bULL, 0x000004b0003f0120ULL, 0x000166880000000bULL,
0x00000ad0003f0120ULL, 0x00016600000000ffULL, 0x00000cd0003f0107ULL, 0x0001668c00000019ULL,
0x00000d80003f0102ULL, 0x0001668800000019ULL, 0x00002af0003f0101ULL, 0x0001660800000008ULL,
0x00002b10003f0101ULL, 0x0001660c00000008ULL, 0x00002ce0003f0105ULL, 0x0001660c00000008ULL,
0x00003f70003f0105ULL, 0x000166880000001dULL, 0x00004c80003f0101ULL, 0x0001662800000068ULL,
0x00004ca0003f0101ULL, 0x0001662c00000068ULL, 0x00004e70003f0105ULL, 0x0001662c00000068ULL,
0x00005e10003f0105ULL, 0x000000000000001fULL, 0x00006bb0003f0101ULL, 0x000166480000001dULL,
0x00006bd0003f0101ULL, 0x0001664c0000001dULL, 0x00006da0003f0105ULL, 0x0001664c0000001dULL,
0x00007cd0003f0105ULL, 0x0000000000000020ULL, 0x00008a40003f0101ULL, 0x0001666800000068ULL,
0x00008a60003f0101ULL, 0x0001666c00000068ULL, 0x00008c30003f0105ULL, 0x0001666c00000068ULL,
0x00009b20003f0105ULL, 0x0000000000000002ULL, 0x0000f230003f0101ULL, 0x00016600000000ffULL,
0x0000fde0003f0101ULL, 0x00016604000000ffULL, 0x0000ffb0003f0105ULL, 0x00016604000000ffULL,
0x000144b0003f0105ULL, 0x000000000000009cULL, 0x00014640003f0101ULL, 0x000000040000009cULL,
0x00014810003f0105ULL, 0x000000040000009cULL, 0x000182f0003f0105ULL, 0x000166080000009dULL,
0x00018350003f0101ULL, 0x000166100000009dULL, 0x000183b0003f0101ULL, 0x000166180000009dULL,
0x00018420003f0101ULL, 0x000166200000009dULL, 0x00033803003f0101ULL, 0x0000e57000301c04ULL,
0x0000e7700000e5a0ULL, 0x0000ea300000e8d0ULL, 0x0000ecf00000eb90ULL, 0x0000efe00000ee50ULL,
0x000100100000f0e0ULL, 0x0000040100018460ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000254ULL,
0x0000001700000002ULL, 0x00000000000001d4ULL, 0x0000001700000002ULL, 0x0000000000000154ULL,
0x0000001700000002ULL, 0x00000000000000d4ULL, 0x0000001700000002ULL, 0x0000000000000044ULL,
0x0000001700000002ULL, 0x000000000000022aULL, 0x0000001700000002ULL, 0x00000000000001aaULL,
0x0000001700000002ULL, 0x000000000000012fULL, 0x0000001700000002ULL, 0x00000000000000adULL,
0x0000001700000002ULL, 0x0000000000016700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff9e7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000827919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000067919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a009e857a19ULL, 0x000fe200000006ffULL,
0x00000000000579c3ULL, 0x000f220000002500ULL, 0x0000000000097919ULL, 0x000ea20000002100ULL,
0x0000460000087ab9ULL, 0x000fc60000000a00ULL, 0x0000000000a17919ULL, 0x000ee20000002700ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fe40007ffe0ffULL,
0x0000000500967c02ULL, 0x010fc80008000f00ULL, 0x0000000200037305ULL, 0x000322000021f000ULL,
0x00000005ff9a7819ULL, 0x004fcc0000011609ULL, 0x00001fff9a9a7589ULL, 0x000fe200000e0000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000040003077a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a07ULL,
0x0000040003007624ULL, 0x000fca00078e029eULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff07aa12ULL, 0x000fc800078e33ffULL, 0x0000000700007306ULL, 0x000e620000209000ULL,
0x000000ff0700720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000307047224ULL, 0x004fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000008203167227ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000ee40000002200ULL,
0x000000ffff007224ULL, 0x000fc800078e0a16ULL, 0x0000000007007224ULL, 0x000fca00078e0282ULL,
0x000000070000720cULL, 0x000fda0003f06070ULL, 0x0000000100000824ULL, 0x000fe200078e0a07ULL,
0x0000000116160810ULL, 0x000fe20007ffe0ffULL, 0x0000010006027a24ULL, 0x008fc600078e0203ULL,
0x000000070000720cULL, 0x000fe20003f26070ULL, 0x00000000020b7a24ULL, 0x000fe400078e0209ULL,
0x00001fff06097589ULL, 0x000e6600000e0000ULL, 0x000000ff0b00720cULL, 0x040fe40003f65270ULL,
0x0000000f0b00780cULL, 0x040fe40003f84070ULL, 0x000000030b00780cULL, 0x000fc60003f04070ULL,
0x0000000116161810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff16a212ULL, 0x000fe400078e33ffULL,
0x0000007f0b00780cULL, 0x000fe40003f24070ULL, 0x3fffff80ff02b424ULL, 0x000fe200078e00ffULL,
0x00005a0016817a19ULL, 0x000fe200000006ffULL, 0x000000ffff007224ULL, 0x000fe400078e0a16ULL,
0x7fffff80ff03b424ULL, 0x000fc400078e00ffULL, 0x0000000007827224ULL, 0x000fe400078e0282ULL,
0x3fffffc0ff04c424ULL, 0x000fe200078e00ffULL, 0x01660002ff00b388ULL, 0x0005e20000000a00ULL,
0x0000002082977824ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff05c424ULL, 0x000fe400078e00ffULL,
0xff317217ff089424ULL, 0x000fe200078e00ffULL, 0x0000000497007c10ULL, 0x040fe4000fffe1ffULL,
0x016608040b00c388ULL, 0x000fe20000008a00ULL, 0x3fffff60ff028424ULL, 0x004fe200078e00ffULL,
0x0000002000007817ULL, 0x000fe20003800000ULL, 0x7fffff60ff038424ULL, 0x000fe200078e00ffULL,
0x016400080b009388ULL, 0x000fe80000004800ULL, 0x016688020b008388ULL, 0x000fe80000008a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000497007c0cULL, 0x000fe2000bf03070ULL,
0x0000000409047824ULL, 0x002fc600078e029aULL, 0x000000ff00807207ULL, 0x000fe20000000000ULL,
0x00005800a1007a24ULL, 0x000fe400078e02ffULL, 0x0000000404037824ULL, 0x000fe200078e00ffULL,
0x000000208000780cULL, 0x000fe20003f05270ULL, 0x0000008500027224ULL, 0x000fd800078e0281ULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe20000000000ULL, 0x0000000380047217ULL, 0x000fe20007800000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x00000004ff067819ULL, 0x002fc80000011600ULL, 0x00000002060a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000103087824ULL, 0x000fc800078e0206ULL, 0x00000001030b7824ULL, 0x000fe400078e020aULL,
0x0000000197057824ULL, 0x040fe400078e0208ULL, 0x00000001970c7824ULL, 0x000fe400078e020bULL,
0x0000000104037824ULL, 0x000fe200078e0a03ULL, 0x0000000405077c12ULL, 0x000fe4000f8e30ffULL,
0x000000040c0d7c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff047a19ULL, 0x000fe20000011605ULL,
0x0000000102077824ULL, 0x040fe200078e0207ULL, 0x00005a00ff0c7a19ULL, 0x000fe2000001160cULL,
0x00000001020d7824ULL, 0x000fe200078e020dULL, 0x000000030600720cULL, 0x000fe20003f06070ULL,
0x0000008504027224ULL, 0x000fe200078e0207ULL, 0x000000030a00720cULL, 0x000fe20003f26070ULL,
0x0000001000047824ULL, 0x000fc400078e00ffULL, 0x000000850c067224ULL, 0x000fe400078e020dULL,
0x0000010002027825ULL, 0x000fe200078e00ffULL, 0x000000f004057812ULL, 0x000fc600078ec0ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000000502027212ULL, 0x000fc600078efcffULL,
0x00000001080a7824ULL, 0x100fe200078e0200ULL, 0x0000000506057212ULL, 0x000fe200078efcffULL,
0x00000010080d7824ULL, 0x000fe200078e00ffULL, 0x00005e0002027a10ULL, 0x000fe20007f5e0ffULL,
0x000000010b087824ULL, 0x000fe200078e0200ULL, 0x00005e0005067a10ULL, 0x000fe20007f7e0ffULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff00d0a7812ULL, 0x000fe400078ee20aULL,
0x00005f0003037a10ULL, 0x000fe400017fe4ffULL, 0xfffffff00b087812ULL, 0x000fe200078ee208ULL,
0x000000100a057824ULL, 0x000fe200078e00ffULL, 0x00005f0007077a10ULL, 0x000fc60001ffe4ffULL,
0x00000010080b7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e8000c101c48ULL, 0x00000000060b7faeULL, 0x0003e2000c901c48ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x0000000300057211ULL, 0x002fc800078fe0ffULL,
0x00000002050a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000197037824ULL, 0x000fe400078e0205ULL,
0x0000000105087824ULL, 0x000fe400078e0200ULL, 0x0000000197067824ULL, 0x000fe200078e020aULL,
0x0000000403077c12ULL, 0x000fe2000f8e30ffULL, 0x00000010050d7824ULL, 0x000fe200078e00ffULL,
0x00005a00ff047a19ULL, 0x000fe20000011603ULL, 0x000000010a057824ULL, 0x000fe200078e0200ULL,
0x00000004060b7c12ULL, 0x000fe2000f8e30ffULL, 0x0000000102077824ULL, 0x000fe200078e0207ULL,
0x00005a00ff067a19ULL, 0x000fe20000011606ULL, 0x000000100a0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff00d087812ULL, 0x000fe200078ee208ULL, 0x00000001020b7824ULL, 0x000fc400078e020bULL,
0x0000008504027224ULL, 0x080fe200078e0207ULL, 0x0000000400047819ULL, 0x000fe200000006ffULL,
0x0000008506067224ULL, 0x000fe200078e020bULL, 0xfffffff00a0a7812ULL, 0x000fe200078ee205ULL,
0x0000010002027825ULL, 0x000fe200078e00ffULL, 0x000000f0040b7812ULL, 0x000fc600078ec0ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000000b02027212ULL, 0x000fc600078efcffULL,
0x0000001008057824ULL, 0x000fe200078e00ffULL, 0x0000000b06067212ULL, 0x000fe200078efcffULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0x00005e0002027a10ULL, 0x000fe40007f1e0ffULL,
0x00005e0006067a10ULL, 0x000fe40007f3e0ffULL, 0x00005f0003037a10ULL, 0x000fe400007fe4ffULL,
0x00005f0007077a10ULL, 0x000fc60000ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e8000b901c48ULL, 0x00000000060b7faeULL, 0x0003e4000b901c48ULL,
0x0000000000037919ULL, 0x002e620000000000ULL, 0x0000000000057806ULL, 0x000fe200038e0000ULL,
0x00000004ff077424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000500027300ULL, 0x000e7000000e0000ULL, 0x0000000500067309ULL, 0x000ea20000000000ULL,
0x000000030200720cULL, 0x002fe20003f02070ULL, 0x00006600a1027625ULL, 0x000fc800078e0007ULL,
0x000000ffff067224ULL, 0x004fd000078e0a06ULL, 0x01660406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01660000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000802957981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0900720cULL, 0x000fe40003f05270ULL,
0x0000007f95947810ULL, 0x044fe40007ffe0ffULL, 0x000000ff95237810ULL, 0x000fc40007ffe0ffULL,
0x00000007ff947819ULL, 0x000fe40000011694ULL, 0x00000008ff237819ULL, 0x000fca0000011623ULL,
0x0000e4e000008947ULL, 0x000fea0003800000ULL, 0x00000003ff027819ULL, 0x000fe2000001169aULL,
0x000000089a197824ULL, 0x000fe400078e00ffULL, 0x00000003ff067424ULL, 0x002fe200078e00ffULL,
0x01ffffff021b7812ULL, 0x000fe200078ec0ffULL, 0xffffffffff1a7424ULL, 0x000fc800078e00ffULL,
0x00000002961b7824ULL, 0x000fca00078e021bULL, 0x000000941b00720cULL, 0x000fda0003f06070ULL,
0x00000002a1028824ULL, 0x000fe400078e00ffULL, 0x00006800ff038624ULL, 0x000fc800078e00ffULL,
0x0000680002028624ULL, 0x000fc800078e0203ULL, 0x000000011b028824ULL, 0x000fe200078e0202ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01668c0619ff738cULL, 0x0003e20000000000ULL,
0x0000640002028625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000008021a8981ULL, 0x000ea2000c1e1900ULL, 0x0000000196067810ULL, 0x002fe20007ffe0ffULL,
0x0000008016167824ULL, 0x000fe200078e00ffULL, 0x00000001ff187819ULL, 0x000fe2000001169aULL,
0x0166880019ff7f8cULL, 0x0003e2000c80043fULL, 0x000000230600720cULL, 0x000fe20003f06070ULL,
0x00000100ff067424ULL, 0x000fe200078e00ffULL, 0x000000019a157812ULL, 0x000fe200078ec0ffULL,
0x0000002018177824ULL, 0x000fc800078e00ffULL, 0x0000010096087824ULL, 0x000fca00078e0217ULL,
0x00000060162d7812ULL, 0x000fe200078ef808ULL, 0x000059001a057a24ULL, 0x004fca00078e02ffULL,
0x0000000705057819ULL, 0x000fca00000006ffULL, 0x0000620005027625ULL, 0x000fe200078e0006ULL,
0x0000064000008947ULL, 0x000fea0003800000ULL, 0x00000003ff127819ULL, 0x002fe40000011600ULL,
0x0000000895057217ULL, 0x000fe40007800000ULL, 0x0000000412067810ULL, 0x040fe40007ffe0ffULL,
0x0000000c120b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000105057824ULL, 0x000fe200078e0a08ULL,
0x00000008120a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000106077824ULL, 0x100fe200078e0200ULL,
0x0000007004047812ULL, 0x000fe200078ec0ffULL, 0x00000008060c7824ULL, 0x000fe200078e00ffULL,
0x0000002005137817ULL, 0x000fe20003800000ULL, 0x000000010b097824ULL, 0x140fe200078e0200ULL,
0x0000001012107810ULL, 0x000fe20007ffe0ffULL, 0x000000080b0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c1f7812ULL, 0x000fe200078ee207ULL, 0x000000010a087824ULL, 0x000fe200078e0200ULL,
0x000000130600720cULL, 0x080fe20003f86070ULL, 0x000000080a217824ULL, 0x000fe200078e00ffULL,
0xfffffff80e257812ULL, 0x000fe200078ee209ULL, 0x0000008015047824ULL, 0x000fe200078e0204ULL,
0x00000014121c7810ULL, 0x000fe20007ffe0ffULL, 0x000000012d077824ULL, 0x000fe200078e0212ULL,
0xfffffff821217812ULL, 0x000fe200078ee208ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x000000130a00720cULL, 0x080fe20003f66070ULL, 0x000000012d097824ULL, 0x000fe200078e0206ULL,
0x000000130b00720cULL, 0x080fe20003f46070ULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x000000131200720cULL, 0x000fc60003fa6070ULL, 0x0000010009087825ULL, 0x000fe200078e0004ULL,
0x00000006020c7210ULL, 0x000fc60007f1e0ffULL, 0x00000001100d7824ULL, 0x100fe200078e0200ULL,
0x00000008020e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000810147824ULL, 0x000fe400078e00ffULL,
0x000000011c0f7824ULL, 0x040fe400078e0200ULL, 0x000000081c1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff814277812ULL, 0x000fe200078ee20dULL, 0x00000001030d7824ULL, 0x000fe400000e0607ULL,
0x000000012d077824ULL, 0x000fe200078e020aULL, 0xfffffff81e297812ULL, 0x000fe200078ee20fULL,
0x00000001030f7824ULL, 0x000fe200008e0609ULL, 0x0000000b2d097210ULL, 0x000fe20007ffe0ffULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x000000131000720cULL, 0x000fc40003f26070ULL,
0x0000001c121e7810ULL, 0x040fe20007ffe0ffULL, 0x00000001120a7824ULL, 0x000fe400078e0200ULL,
0x0000010009087825ULL, 0x000fc600078e0004ULL, 0x000000070a1d7812ULL, 0x000fe200078ec0ffULL,
0x000000012d0b7824ULL, 0x000fe200078e0210ULL, 0x0000000602107210ULL, 0x000fe20007f1e0ffULL,
0x0000000218147824ULL, 0x000fe200078e0215ULL, 0x0000000802087210ULL, 0x000fe20007fde0ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0004ULL, 0x0ffffff81d1d7812ULL, 0x000fe400078ef800ULL,
0x0000e00014147811ULL, 0x000fe200078e68ffULL, 0x0000000103117824ULL, 0x000fe200000e0607ULL,
0x000000131c00720cULL, 0x000fe20003f06070ULL, 0x000000012d077824ULL, 0x000fe200078e021cULL,
0x00000018121c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000103097824ULL, 0x000fe200030e0609ULL,
0x0000000a020a7210ULL, 0x000fe20007fde0ffULL, 0x0000010007067825ULL, 0x000fe200078e0004ULL,
0x0000001429297211ULL, 0x000fc600078e20ffULL, 0x000000101d1d7824ULL, 0x100fe400078e0214ULL,
0x000000101f1f7824ULL, 0x000fe400078e0214ULL, 0x00000001030b7824ULL, 0x000fe200030e060bULL,
0x0000000602127210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c1d7faeULL, 0x0003e2000e901c48ULL, 0x000000012d2b7824ULL, 0x040fe200078e021cULL,
0x000000131c00720cULL, 0x080fe20003fa6070ULL, 0x000000012d2d7824ULL, 0x000fe200078e021eULL,
0x000000000e1f7faeULL, 0x0005e2000e101c48ULL, 0x000000131e00720cULL, 0x000fe20003f86070ULL,
0x0000000103137824ULL, 0x000fc400030e0607ULL, 0x000001002b067825ULL, 0x000fc800078e0004ULL,
0x000000011c0c7824ULL, 0x102fe200078e0200ULL, 0x0000000602067210ULL, 0x000fe20007fde0ffULL,
0x000000081c0d7824ULL, 0x000fe400078e00ffULL, 0x000000011e0e7824ULL, 0x044fe400078e0200ULL,
0x000000081e0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL,
0x000001002d047825ULL, 0x000fc600078e0004ULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee20eULL,
0x0000000103077824ULL, 0x000fe200030e0607ULL, 0x0000000402027210ULL, 0x000fe20007fde0ffULL,
0x0000001021217824ULL, 0x100fe400078e0214ULL, 0x0000001025257824ULL, 0x100fe400078e0214ULL,
0x0000001027277824ULL, 0x100fe200078e0214ULL, 0x0000000010217faeULL, 0x0003e2000d901c48ULL,
0x000000100d0d7824ULL, 0x100fe400078e0214ULL, 0x000000100f0f7824ULL, 0x000fe200078e0214ULL,
0x0000000008257faeULL, 0x0003e2000d101c48ULL, 0x0000000103037824ULL, 0x000fc600030e0605ULL,
0x000000000a277faeULL, 0x0003e8000c901c48ULL, 0x0000000012297faeULL, 0x0003e8000c101c48ULL,
0x00000000060d7faeULL, 0x0003e8000e901c48ULL, 0x00000000020f7faeULL, 0x0003e2000e101c48ULL,
0x0000057000007947ULL, 0x000fea0003800000ULL, 0x00000008000b7811ULL, 0x042fe400078fe8ffULL,
0x0000000400057811ULL, 0x000fc400078fe8ffULL, 0x0000001400117811ULL, 0x040fe200078fe8ffULL,
0x000000010b077824ULL, 0x140fe200078e0200ULL, 0x00000010000f7811ULL, 0x040fe200078fe8ffULL,
0x000000080b1e7824ULL, 0x000fe200078e00ffULL, 0x0000000c000d7811ULL, 0x040fe200078fe8ffULL,
0x0000000105067824ULL, 0x140fe200078e0200ULL, 0x0000001800137811ULL, 0x000fe200078fe8ffULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee207ULL,
0x0000000111087824ULL, 0x040fe200078e0200ULL, 0x0000007004127812ULL, 0x000fe200078ec0ffULL,
0x00000008111f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8091c7812ULL, 0x000fe200078ee206ULL,
0x000000010f077824ULL, 0x040fe200078e0200ULL, 0x0000000000047211ULL, 0x040fe200078fe8ffULL,
0x000000080f227824ULL, 0x000fe200078e00ffULL, 0xfffffff81f247812ULL, 0x000fe200078ee208ULL,
0x000000010d067824ULL, 0x140fe200078e0200ULL, 0x0000001c001f7811ULL, 0x000fe200078fe8ffULL,
0x000000080d1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee207ULL,
0x0000000113097824ULL, 0x040fe200078e0200ULL, 0x0000000704077812ULL, 0x000fe200078ec0ffULL,
0x0000000813267824ULL, 0x000fe200078e00ffULL, 0xfffffff81d207812ULL, 0x000fe200078ee206ULL,
0x0000000218067824ULL, 0x000fe200078e0215ULL, 0x0000000d2d0d7210ULL, 0x000fe20007ffe0ffULL,
0x000000011f047824ULL, 0x100fe200078e0200ULL, 0xfffffff826267812ULL, 0x000fe200078ee209ULL,
0x000000012d097824ULL, 0x000fe200078e0205ULL, 0x0000002d00057211ULL, 0x000fe200078fe8ffULL,
0x000000081f217824ULL, 0x000fe200078e00ffULL, 0x0ffffff807147812ULL, 0x000fe200078ef800ULL,
0x000000012d1d7824ULL, 0x000fc400078e0213ULL, 0x0000008015127824ULL, 0x000fe200078e0212ULL,
0xfffffff821287812ULL, 0x000fe200078ee204ULL, 0x000000ffff137224ULL, 0x000fe400078e00ffULL,
0x000000012d0b7824ULL, 0x040fe400078e020bULL, 0x000000012d0f7824ULL, 0x040fe400078e020fULL,
0x000000012d117824ULL, 0x040fe400078e0211ULL, 0x000000012d1f7824ULL, 0x000fe200078e021fULL,
0x0000e000062d7811ULL, 0x000fe200078e68ffULL, 0x0000010005047825ULL, 0x000fc800078e0012ULL,
0x0000010009067825ULL, 0x000fe200078e0012ULL, 0x0000000402047210ULL, 0x000fc60007f1e0ffULL,
0x000001000b087825ULL, 0x000fe200078e0012ULL, 0x0000000602067210ULL, 0x000fc60007f3e0ffULL,
0x000001000d0a7825ULL, 0x000fe200078e0012ULL, 0x0000000802087210ULL, 0x000fc60007f5e0ffULL,
0x000001000f0c7825ULL, 0x000fe200078e0012ULL, 0x0000000a020a7210ULL, 0x000fc60007f7e0ffULL,
0x00000100110e7825ULL, 0x000fc800078e0012ULL, 0x000001001d107825ULL, 0x000fc800078e0012ULL,
0x000001001f127825ULL, 0x000fc800078e0012ULL, 0x0000000103057824ULL, 0x040fe200000e0605ULL,
0x0000000c020c7210ULL, 0x040fe20007f1e0ffULL, 0x0000000103077824ULL, 0x040fe200008e0607ULL,
0x0000000e020e7210ULL, 0x000fe20007f3e0ffULL, 0x00000010141d7824ULL, 0x000fe200078e022dULL,
0x0000000d030d7210ULL, 0x040fe200007fe4ffULL, 0x0000000103097824ULL, 0x040fe200010e0609ULL,
0x0000001002107210ULL, 0x000fe20007f5e0ffULL, 0x000000101c1f7824ULL, 0x000fe200078e022dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000041d7faeULL, 0x0003e2000b901c48ULL,
0x00000001030b7824ULL, 0x000fe200018e060bULL, 0x0000001202027210ULL, 0x000fe20007f7e0ffULL,
0x000000101e217824ULL, 0x100fe200078e022dULL, 0x00000000061f7faeULL, 0x0003e2000b901c48ULL,
0x0000001020257824ULL, 0x000fc400078e022dULL, 0x0000001022277824ULL, 0x100fe200078e022dULL,
0x0000000008217faeULL, 0x0003e2000b901c48ULL, 0x0000001024297824ULL, 0x000fe400078e022dULL,
0x00000001030f7824ULL, 0x040fe200008e060fULL, 0x000000000a257faeULL, 0x0003e2000b901c48ULL,
0x00000010262b7824ULL, 0x000fe400078e022dULL, 0x0000000103117824ULL, 0x000fe200010e0611ULL,
0x000000000c277faeULL, 0x0003e2000b901c48ULL, 0x00000010282d7824ULL, 0x000fc400078e022dULL,
0x0000000103037824ULL, 0x000fe200018e0613ULL, 0x000000000e297faeULL, 0x0003e8000b901c48ULL,
0x00000000102b7faeULL, 0x0003e8000b901c48ULL, 0x00000000022d7faeULL, 0x0003e4000b901c48ULL,
0x000000239600720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff317217ff1c7424ULL, 0x000fe200078e00ffULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff1e7224ULL, 0x000fe200078e00ffULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x002fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00007f2000000947ULL, 0x000fea0003800000ULL, 0x00000002a1147824ULL, 0x000fe400078e00ffULL,
0x00006800ff037624ULL, 0x000fc400078e00ffULL, 0xff317217ff1c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff5f7224ULL, 0x000fe400078e00ffULL, 0x0000680014147624ULL, 0x000fc400078e0203ULL,
0x000000109a027824ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe002037812ULL, 0x000fe200078ec0ffULL, 0x000059001a1a7a24ULL, 0x010fe200078e02ffULL,
0x0000000196027810ULL, 0x000fc60007ffe0ffULL, 0x0000010096037824ULL, 0x000fe200078e0203ULL,
0x000000230200720cULL, 0x000fe20003f06070ULL, 0x000000801a027824ULL, 0x000fc600078e00ffULL,
0x0000004003077810ULL, 0x020fe20007ffe0ffULL, 0x00000100ff037424ULL, 0x000fc600078e00ffULL,
0x0000006007057812ULL, 0x000fe200078ec0ffULL, 0x0000620002027625ULL, 0x000fc800078e0003ULL,
0x0000000116697824ULL, 0x000fe200078e0205ULL, 0x0000068000008947ULL, 0x000fea0003800000ULL,
0x0000001000057824ULL, 0x000fe200078e00ffULL, 0x0000000795047217ULL, 0x000fe20007800000ULL,
0x000000809a067824ULL, 0x000fe200078e00ffULL, 0x00000003ff1a7819ULL, 0x000fe40000011600ULL,
0x0000007005097812ULL, 0x000fe200078ec0ffULL, 0x0000000104057824ULL, 0x000fe200078e0a07ULL,
0x000000041a0a7810ULL, 0x000fe20007ffe0ffULL, 0x000020009a077824ULL, 0x000fe200078e00ffULL,
0x0000008009047812ULL, 0x000fc400078ef806ULL, 0x000000030a677819ULL, 0x040fe200000006ffULL,
0x000000010a067824ULL, 0x000fe200078e0200ULL, 0x0000000c1a227810ULL, 0x040fe40007ffe0ffULL,
0x0000200007077812ULL, 0x000fe400078ec0ffULL, 0x000000081a207810ULL, 0x000fe20007ffe0ffULL,
0x00000008226d7824ULL, 0x040fe200078e00ffULL, 0xfffffff867677812ULL, 0x000fe200078ee206ULL,
0x0000000122067824ULL, 0x000fe200078e0200ULL, 0x000000141a687810ULL, 0x000fe20007ffe0ffULL,
0x0000400018187824ULL, 0x000fe200078e0207ULL, 0x0000002005137817ULL, 0x000fe20003800000ULL,
0x000000011a077824ULL, 0x040fe200078e0269ULL, 0x000000101a667810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee206ULL,
0x0000000120087824ULL, 0x140fe200078e0200ULL, 0x000000132000720cULL, 0x0c0fe20003f06070ULL,
0x00000008206b7824ULL, 0x000fe200078e00ffULL, 0x000000131a00720cULL, 0x080fe20003f86070ULL,
0x0000000168097824ULL, 0x000fe200078e0200ULL, 0x000000130a00720cULL, 0x000fe20003f66070ULL,
0x00000008680c7824ULL, 0x000fe200078e00ffULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee208ULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x0000f00018187810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80c717812ULL, 0x000fe200078ee209ULL, 0x0000000166087824ULL, 0x000fe200078e0200ULL,
0x00000006020c7210ULL, 0x000fe20007f5e0ffULL, 0x00000008666f7824ULL, 0x000fe200078e00ffULL,
0x000000132200720cULL, 0x000fe20003f26070ULL, 0x000000010a097824ULL, 0x000fe400078e0269ULL,
0x00000001030d7824ULL, 0x000fe200010e0607ULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee208ULL,
0x000000011a087824ULL, 0x000fe400078e0200ULL, 0x00000001200b7824ULL, 0x000fc400078e0269ULL,
0x0000010009067825ULL, 0x000fe200078e0004ULL, 0x00000007081f7812ULL, 0x000fc600078ec0ffULL,
0x000001000b087825ULL, 0x000fe200078e0004ULL, 0x0000000602207210ULL, 0x000fe40007f5e0ffULL,
0x0ffffff81f1f7812ULL, 0x000fe200078ef800ULL, 0x00000001221d7824ULL, 0x000fe200078e0269ULL,
0x0000000802647210ULL, 0x000fe20007fbe0ffULL, 0x0000000103217824ULL, 0x000fe200010e0607ULL,
0x000000181a227810ULL, 0x040fe20007ffe0ffULL, 0x000001001d0a7825ULL, 0x000fe200078e0004ULL,
0x0000001c1a1a7810ULL, 0x000fe40007ffe0ffULL, 0x000000136600720cULL, 0x0c0fe20003f46070ULL,
0x0000000166077824ULL, 0x000fe200078e0269ULL, 0x0000000a020a7210ULL, 0x000fe20007fde0ffULL,
0x0000000103657824ULL, 0x000fe200028e0609ULL, 0x000000181f097211ULL, 0x000fe200078e20ffULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x000000136800720cULL, 0x000fc60003fa6070ULL,
0x00000010671d7824ULL, 0x000fe200078e0218ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c097faeULL, 0x0003e2000e101c48ULL, 0x00000001681f7824ULL, 0x000fe200078e0269ULL,
0x000000132200720cULL, 0x080fe20003f86070ULL, 0x00000001030b7824ULL, 0x040fe200030e060bULL,
0x0000000602667210ULL, 0x000fe20007fde0ffULL, 0x00000000201d7faeULL, 0x0005e2000d901c48ULL,
0x000000131a00720cULL, 0x000fe20003f66070ULL, 0x0000000122137824ULL, 0x000fe400078e0269ULL,
0x0000000103677824ULL, 0x000fc400030e0607ULL, 0x0000010013067825ULL, 0x000fc800078e0004ULL,
0x000001001f087825ULL, 0x002fc800078e0004ULL, 0x000000011a0d7824ULL, 0x000fe200078e0269ULL,
0x0000000802087210ULL, 0x000fe20007fde0ffULL, 0x00000001220c7824ULL, 0x140fe400078e0200ULL,
0x0000000822217824ULL, 0x004fe400078e00ffULL, 0x0000000103097824ULL, 0x000fe200030e0609ULL,
0x0000000602067210ULL, 0x000fe20007fde0ffULL, 0x000000011a137824ULL, 0x040fe200078e0200ULL,
0xfffffff821217812ULL, 0x000fe200078ee20cULL, 0x000000081a1a7824ULL, 0x000fc400078e00ffULL,
0x000001000d047825ULL, 0x000fc600078e0004ULL, 0xfffffff81a697812ULL, 0x000fe200078ee213ULL,
0x0000000103077824ULL, 0x000fe200030e0607ULL, 0x0000000402027210ULL, 0x000fe20007fde0ffULL,
0x000000106b0d7824ULL, 0x100fe400078e0218ULL, 0x000000106d137824ULL, 0x100fe400078e0218ULL,
0x000000106f1d7824ULL, 0x100fe200078e0218ULL, 0x00000000640d7faeULL, 0x0003e2000c101c48ULL,
0x00000010711f7824ULL, 0x100fe400078e0218ULL, 0x0000001021217824ULL, 0x100fe200078e0218ULL,
0x000000000a137faeULL, 0x0003e2000c901c48ULL, 0x0000001069697824ULL, 0x000fc400078e0218ULL,
0x0000000103037824ULL, 0x000fe200030e0605ULL, 0x00000000661d7faeULL, 0x0003e8000d101c48ULL,
0x00000000081f7faeULL, 0x0003e8000e901c48ULL, 0x0000000006217faeULL, 0x0003e8000e101c48ULL,
0x0000000002697faeULL, 0x0003e2000d901c48ULL, 0x000005b000007947ULL, 0x000fea0003800000ULL,
0x0000000400047819ULL, 0x000fe200000006ffULL, 0x000000809a677824ULL, 0x000fe200078e00ffULL,
0x0000000400077811ULL, 0x000fe200078fe8ffULL, 0x000020009a057824ULL, 0x000fe200078e00ffULL,
0x0000007004047812ULL, 0x000fc400078ec0ffULL, 0x0000000800097811ULL, 0x000fe200078fe8ffULL,
0x00000008071f7824ULL, 0x040fe200078e00ffULL, 0x0000008004667812ULL, 0x000fe200078ef867ULL,
0x0000000107047824ULL, 0x000fe200078e0200ULL, 0x0000200005057812ULL, 0x000fe200078ec0ffULL,
0x0000000809087824ULL, 0x000fe200078e00ffULL, 0x00000010000d7811ULL, 0x000fe200078fe8ffULL,
0x000000ffff677224ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee204ULL,
0x0000400018187824ULL, 0x000fe200078e0205ULL, 0x0000000c000b7811ULL, 0x040fe200078fe8ffULL,
0x0000000109057824ULL, 0x100fe200078e0200ULL, 0x0000001400217811ULL, 0x040fe200078fe8ffULL,
0x000000010d047824ULL, 0x140fe200078e0200ULL, 0x0000001c00137811ULL, 0x000fe200078fe8ffULL,
0x000000080d6f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8086b7812ULL, 0x000fe200078ee205ULL,
0x000000010b067824ULL, 0x040fe200078e0200ULL, 0x0000001800657811ULL, 0x040fe200078fe8ffULL,
0x000000080b6d7824ULL, 0x000fe200078e00ffULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee204ULL,
0x0000000121057824ULL, 0x040fe200078e0200ULL, 0x0000000000047211ULL, 0x000fe200078fe8ffULL,
0x0000000821087824ULL, 0x000fe200078e00ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee206ULL,
0x0000000813757824ULL, 0x040fe200078e00ffULL, 0x00000007041d7812ULL, 0x000fe200078ec0ffULL,
0x0000000113047824ULL, 0x100fe200078e0200ULL, 0xfffffff808717812ULL, 0x000fe200078ee205ULL,
0x0000000165067824ULL, 0x040fe200078e0200ULL, 0x0000006900057211ULL, 0x080fe200078fe8ffULL,
0x0000000865737824ULL, 0x000fe200078e00ffULL, 0xfffffff875757812ULL, 0x000fe200078ee204ULL,
0x0000000107077824ULL, 0x100fe200078e0269ULL, 0x0000006921217210ULL, 0x000fe20007ffe0ffULL,
0x0000000109097824ULL, 0x100fe200078e0269ULL, 0xfffffff873737812ULL, 0x000fe200078ee206ULL,
0x000000010b0b7824ULL, 0x000fe200078e0269ULL, 0x0ffffff81d1d7812ULL, 0x000fe200078ef800ULL,
0x0000010005047825ULL, 0x000fe200078e0066ULL, 0x0000f00018187810ULL, 0x000fc60007ffe0ffULL,
0x0000010007067825ULL, 0x000fe200078e0066ULL, 0x0000000402047210ULL, 0x000fc60007f1e0ffULL,
0x000000010d0d7824ULL, 0x000fe200078e0269ULL, 0x0000000602067210ULL, 0x000fe20007f3e0ffULL,
0x0000010009087825ULL, 0x000fc800078e0066ULL, 0x000001000b0a7825ULL, 0x000fe200078e0066ULL,
0x0000000802087210ULL, 0x000fc60007f5e0ffULL, 0x0000000165657824ULL, 0x100fe200078e0269ULL,
0x0000000a020a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000113137824ULL, 0x000fe400078e0269ULL,
0x000001000d0c7825ULL, 0x000fc800078e0066ULL, 0x0000010021207825ULL, 0x000fc800078e0066ULL,
0x0000010065647825ULL, 0x000fc800078e0066ULL, 0x0000010013667825ULL, 0x000fc800078e0066ULL,
0x0000000103057824ULL, 0x040fe200000e0605ULL, 0x0000000c020c7210ULL, 0x040fe20007f1e0ffULL,
0x0000000103077824ULL, 0x000fe200008e0607ULL, 0x0000002002207210ULL, 0x040fe20007f3e0ffULL,
0x000000101d137824ULL, 0x100fe400078e0218ULL, 0x0000000103097824ULL, 0x000fe200010e0609ULL,
0x0000006402647210ULL, 0x040fe20007f5e0ffULL, 0x000000101f1d7824ULL, 0x100fe200078e0218ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004137faeULL, 0x0003e2000b901c48ULL,
0x00000001030b7824ULL, 0x000fe200018e060bULL, 0x0000006602027210ULL, 0x000fe20007f7e0ffULL,
0x000000106b1f7824ULL, 0x100fe200078e0218ULL, 0x0000006503657210ULL, 0x000fe200017fe4ffULL,
0x000000106d697824ULL, 0x100fe200078e0218ULL, 0x00000000061d7faeULL, 0x0003e2000b901c48ULL,
0x000000106f6b7824ULL, 0x000fc400078e0218ULL, 0x00000001030d7824ULL, 0x000fe200000e060dULL,
0x00000000081f7faeULL, 0x0003e2000b901c48ULL, 0x00000010716d7824ULL, 0x100fe400078e0218ULL,
0x0000000103217824ULL, 0x000fe200008e0621ULL, 0x000000000a697faeULL, 0x0003e2000b901c48ULL,
0x00000010736f7824ULL, 0x100fe400078e0218ULL, 0x0000001075717824ULL, 0x000fe200078e0218ULL,
0x000000000c6b7faeULL, 0x0003e2000b901c48ULL, 0x0000000103037824ULL, 0x000fc600018e0667ULL,
0x00000000206d7faeULL, 0x0003e8000b901c48ULL, 0x00000000646f7faeULL, 0x0003e8000b901c48ULL,
0x0000000002717faeULL, 0x0003e4000b901c48ULL, 0x00000300ff027624ULL, 0x002fe200078e00ffULL,
0x000000011b037812ULL, 0x000fe200078ec0ffULL, 0xffffffffff1a7424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000010300780cULL, 0x000fc40003f05070ULL,
0xffffffff02027811ULL, 0x000fc800078e08ffULL, 0x0000000102027807ULL, 0x000fca0004000000ULL,
0x00000001021b7824ULL, 0x000fca00078e021bULL, 0x000000941b00720cULL, 0x000fda0003f06070ULL,
0x0000000114028824ULL, 0x000fe400078e021bULL, 0x00000004ff038424ULL, 0x000fc800078e00ffULL,
0x0000640002028625ULL, 0x000fca00078e0003ULL, 0x00000008021a8981ULL, 0x000322000c1e1900ULL,
0xffffffe019047812ULL, 0x040fe400078ec0ffULL, 0x0000001019057812ULL, 0x040fe400078ec0ffULL,
0x0000000819067812ULL, 0x000fc800078ec0ffULL, 0x0000000406087210ULL, 0x000fe20007ffe005ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0166080008067f8cULL, 0x0022a4000c80043fULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x01660c0008057984ULL, 0x000ee40000000800ULL,
0x8000000005ff7812ULL, 0x00cfe40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402097210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000904047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01660c0008057984ULL, 0x000ea40000000800ULL, 0x8000000005ff7812ULL, 0x004fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000137824ULL, 0x000fe200078e00ffULL,
0x00000001ff227819ULL, 0x000fe20000011600ULL, 0x000000209a027824ULL, 0x000fe400078e00ffULL,
0xffffffffff837424ULL, 0x000fe200078e00ffULL, 0x0000007013137812ULL, 0x000fc400078ec0ffULL,
0xffffff8002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c22227812ULL, 0x000fc800078ec0ffULL,
0x0000000222027210ULL, 0x000fca0007ffe013ULL, 0x0160000002037984ULL, 0x000ea80000000800ULL,
0x0162000002057984ULL, 0x0006620000000800ULL, 0x0000001c0300720bULL, 0x004fe20003f1d000ULL,
0x000156827f007947ULL, 0x000fd8000b800000ULL, 0x0000000000027806ULL, 0x008fc800000e0100ULL,
0x000000ff0200720cULL, 0x000fe20003f25270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff187224ULL, 0x000fe400078e001cULL,
0x0000001fff867424ULL, 0x000fc400078e00ffULL, 0xffffffffff847424ULL, 0x000fcc00078e00ffULL,
0x0000071000009947ULL, 0x000fea0003800000ULL, 0x00000002ff077819ULL, 0x000fe4000001169aULL,
0x0000001c0300720bULL, 0x000fe40003f54000ULL, 0x0000009a0700720cULL, 0x000fe20003f25270ULL,
0x000156127f007947ULL, 0x000fd4000b800000ULL, 0x0000000000077806ULL, 0x000fc400010e0100ULL,
0x000000809a099824ULL, 0x000fe200078e0213ULL, 0x0000001c03187209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000122099824ULL, 0x000fca00078e0209ULL,
0x0164001809009388ULL, 0x0005e20000000800ULL, 0x000000ff0700720cULL, 0x000fda0003f25270ULL,
0x000005e000009947ULL, 0x000fea0003800000ULL, 0x0000001c18047221ULL, 0x004fe20000010100ULL,
0x000000ff07ff7812ULL, 0x000fe2000782c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b04047820ULL, 0x000fcc0000410000ULL, 0x0000000400047308ULL, 0x000ea40000000800ULL,
0x000000041e1e7220ULL, 0x004fe40000410000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000002ff1f7819ULL, 0x000fe20000011600ULL, 0x000155527f007947ULL, 0x000fea000b800000ULL,
0x00001f1f041f7589ULL, 0x0004e400000e0000ULL, 0x0000001f60607220ULL, 0x08cfe20000410000ULL,
0x0000001f61617220ULL, 0x080fe20000410000ULL, 0x0000001f24247220ULL, 0x080fe20000410000ULL,
0x0000001f25257220ULL, 0x080fe20000410000ULL, 0x0000001f28287220ULL, 0x080fe20000410000ULL,
0x0000001f29297220ULL, 0x080fe20000410000ULL, 0x0000001f2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001f2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001f30307220ULL, 0x080fe20000410000ULL,
0x0000001f31317220ULL, 0x080fe20000410000ULL, 0x0000001f34347220ULL, 0x080fe20000410000ULL,
0x0000001f35357220ULL, 0x080fe20000410000ULL, 0x0000001f38387220ULL, 0x080fe20000410000ULL,
0x0000001f39397220ULL, 0x080fe20000410000ULL, 0x0000001f3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001f3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0007ff7812ULL, 0x000fe2000782c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000008001f7811ULL, 0x000fe200078ff0ffULL,
0x000154227f007947ULL, 0x000fea000b800000ULL, 0x00001f1f041f7589ULL, 0x0004e400000e0000ULL,
0x0000001f62627220ULL, 0x08cfe20000410000ULL, 0x0000001f63637220ULL, 0x080fe20000410000ULL,
0x0000001f26267220ULL, 0x080fe20000410000ULL, 0x0000001f27277220ULL, 0x080fe20000410000ULL,
0x0000001f2a2a7220ULL, 0x080fe20000410000ULL, 0x0000001f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001f32327220ULL, 0x080fe20000410000ULL, 0x0000001f33337220ULL, 0x080fe20000410000ULL,
0x0000001f36367220ULL, 0x080fe20000410000ULL, 0x0000001f37377220ULL, 0x080fe20000410000ULL,
0x0000001f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001f3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000007ff7812ULL, 0x000fe2000782c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000010001f7811ULL, 0x000fe200078ff0ffULL, 0x000152f27f007947ULL, 0x000fea000b800000ULL,
0x00001f1f041f7589ULL, 0x0004e400000e0000ULL, 0x0000001f40407220ULL, 0x08cfe20000410000ULL,
0x0000001f41417220ULL, 0x080fe20000410000ULL, 0x0000001f44447220ULL, 0x080fe20000410000ULL,
0x0000001f45457220ULL, 0x080fe20000410000ULL, 0x0000001f48487220ULL, 0x080fe20000410000ULL,
0x0000001f49497220ULL, 0x080fe20000410000ULL, 0x0000001f4c4c7220ULL, 0x080fe20000410000ULL,
0x0000001f4d4d7220ULL, 0x080fe20000410000ULL, 0x0000001f50507220ULL, 0x080fe20000410000ULL,
0x0000001f51517220ULL, 0x080fe20000410000ULL, 0x0000001f54547220ULL, 0x080fe20000410000ULL,
0x0000001f55557220ULL, 0x080fe20000410000ULL, 0x0000001f58587220ULL, 0x080fe20000410000ULL,
0x0000001f59597220ULL, 0x080fe20000410000ULL, 0x0000001f5c5c7220ULL, 0x080fe20000410000ULL,
0x0000001f5d5d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000007ff7812ULL, 0x000fda000782c0ffULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000018001f7811ULL, 0x000fe200078ff0ffULL, 0x000151d27f007947ULL, 0x000fea000b800000ULL,
0x00001f1f041f7589ULL, 0x0004e400000e0000ULL, 0x0000001f42427220ULL, 0x08cfe20000410000ULL,
0x0000001f43437220ULL, 0x080fe20000410000ULL, 0x0000001f46467220ULL, 0x080fe20000410000ULL,
0x0000001f47477220ULL, 0x080fe20000410000ULL, 0x0000001f4a4a7220ULL, 0x080fe20000410000ULL,
0x0000001f4b4b7220ULL, 0x080fe20000410000ULL, 0x0000001f4e4e7220ULL, 0x080fe20000410000ULL,
0x0000001f4f4f7220ULL, 0x080fe20000410000ULL, 0x0000001f52527220ULL, 0x080fe20000410000ULL,
0x0000001f53537220ULL, 0x080fe20000410000ULL, 0x0000001f56567220ULL, 0x080fe20000410000ULL,
0x0000001f57577220ULL, 0x080fe20000410000ULL, 0x0000001f5a5a7220ULL, 0x080fe20000410000ULL,
0x0000001f5b5b7220ULL, 0x080fe20000410000ULL, 0x0000001f5e5e7220ULL, 0x080fe20000410000ULL,
0x0000001f5f5f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000000702ff7212ULL, 0x000fda00078230ffULL, 0x8000001803031221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b03031820ULL, 0x000fc80000410000ULL,
0x0000000300121308ULL, 0x000ea40000000800ULL, 0x0000001205051220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000001e051e7221ULL, 0x002fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000012ff02723eULL, 0x000fe400000000ffULL,
0x00000002ff037819ULL, 0x000fe40000011600ULL, 0x0000541002027816ULL, 0x000fe20000000002ULL,
0x000150027f007947ULL, 0x000fea000b800000ULL, 0x00001f0302117589ULL, 0x0002a400000e0000ULL,
0x00000008031f7810ULL, 0x000fe20007ffe0ffULL, 0x000150327f007947ULL, 0x000fea000b800000ULL,
0x00000010030f7810ULL, 0x000fe20007ffe0ffULL, 0x00001f1f02107589ULL, 0x00066a00000e0000ULL,
0x00001f0f020f7589ULL, 0x0006a400000e0000ULL, 0x00000018031f7810ULL, 0x008fe20007ffe0ffULL,
0x000150827f007947ULL, 0x000fea000b800000ULL, 0x00001f1f020e7589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000029a1d7824ULL, 0x000fe200078e00ffULL,
0x0000000800037812ULL, 0x002fe200078ec0ffULL, 0x000020009a1c7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000002c000007945ULL, 0x000fe20003800000ULL,
0x000000041d1f7812ULL, 0x008fc400078ec0ffULL, 0x0000000703037812ULL, 0x000fe400078ef800ULL,
0x0000001f00027211ULL, 0x040fe400078fe0ffULL, 0x0000001003217812ULL, 0x040fe200078efcffULL,
0x0000000803067824ULL, 0x040fe200078e00ffULL, 0x0000000300047211ULL, 0x000fe200078fe0ffULL,
0x00000001030d7824ULL, 0x040fe400078e0202ULL, 0x00000001020c7824ULL, 0x000fe200078e0221ULL,
0x00000002040b7810ULL, 0x000fe20007ffe0ffULL, 0x000004009a027824ULL, 0x000fe200078e00ffULL,
0x0000000404097810ULL, 0x000fe20007ffe0ffULL, 0x0000000803207824ULL, 0x000fe200078e00ffULL,
0xfffffff8060d7812ULL, 0x000fe200078ee20dULL, 0x0000000821057824ULL, 0x000fe200078e00ffULL,
0xfffff00002027812ULL, 0x000fe200078ec0ffULL, 0x0000000803077824ULL, 0x000fe200078e00ffULL,
0xfffffff8060b7812ULL, 0x000fc400078ee20bULL, 0xffffc0001c067812ULL, 0x000fe400078ec0ffULL,
0xfffffff820097812ULL, 0x000fe400078ee209ULL, 0xfffffff8050c7812ULL, 0x000fe200078ee20cULL,
0x0000200015067824ULL, 0x000fe200078e0206ULL, 0x0000a00002207810ULL, 0x000fe40007ffe0ffULL,
0x0000000303057819ULL, 0x000fe400000006ffULL, 0x0000e00006067810ULL, 0x000fe20007ffe0ffULL,
0x000000100d747824ULL, 0x000fe200078e0220ULL, 0xfffffff8050a7812ULL, 0x000fe200078ee204ULL,
0x000000100c647824ULL, 0x000fe200078e0220ULL, 0x0000000604087810ULL, 0x000fe20007ffe0ffULL,
0x000000100b6c7824ULL, 0x000fc400078e0206ULL, 0x000000007474783bULL, 0x000e620000000200ULL,
0xfffffff807087812ULL, 0x000fe200078ee208ULL, 0x000000100a707824ULL, 0x100fe400078e0206ULL,
0x000000006464783bULL, 0x000ee20000000200ULL, 0x0000001009047824ULL, 0x000fe200078e0206ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000001174747232ULL, 0x086fe40000000000ULL,
0x0000001176767232ULL, 0x000fe40000000000ULL, 0x0000001075757232ULL, 0x000fc40000000000ULL,
0x0000001077777232ULL, 0x000fe40000000000ULL, 0x0000000f64647232ULL, 0x088fe40000000000ULL,
0x0000000f66667232ULL, 0x000fe40000000000ULL, 0x0000000e65657232ULL, 0x080fe40000000000ULL,
0x0000000e67677232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001008687824ULL, 0x000fe200078e0206ULL, 0x000000007070783bULL, 0x000ee20000004200ULL,
0x000000021f1f7812ULL, 0x000fe200078efcffULL, 0x0000039000007945ULL, 0x000fe20003800000ULL,
0x00000001ff7c7819ULL, 0x000fe2000001169aULL, 0x000000000404783bULL, 0x000ea20000004200ULL,
0x0000001f00027211ULL, 0x000fc600078fe0ffULL, 0x000000006868783bULL, 0x000e620000004200ULL,
0x000000027c1f7824ULL, 0x000fc600078e0215ULL, 0x000000006c6c783bULL, 0x000e640000004200ULL,
0x0000e0001f1f7811ULL, 0x000fe200078e68ffULL, 0x000000706440723cULL, 0x008f700000001840ULL,
0x000000047430723cULL, 0x046f700000001830ULL, 0x000000067434723cULL, 0x000f700000001834ULL,
0x000000046450723cULL, 0x040b6e0000001850ULL, 0x0000000803047824ULL, 0x020fe200078e00ffULL,
0x000000066454723cULL, 0x000b620000001854ULL, 0x0000000821057824ULL, 0x000fcc00078e00ffULL,
0x0000000103077824ULL, 0x120fe200078e0202ULL, 0x000000687438723cULL, 0x080f620000001838ULL,
0x0000000121067824ULL, 0x000fe200078e0202ULL, 0x0000002100027211ULL, 0x000fe400078fe0ffULL,
0xfffffff804077812ULL, 0x000fe400078ee207ULL, 0xfffffff805067812ULL, 0x000fe400078ee206ULL,
0x000000686458723cULL, 0x000b620000001858ULL, 0x0000000202047810ULL, 0x040fe20007ffe0ffULL,
0x0000001007787824ULL, 0x100fe200078e0220ULL, 0x0000000402037810ULL, 0x000fe20007ffe0ffULL,
0x0000001006207824ULL, 0x000fe200078e0220ULL, 0xfffffff805057812ULL, 0x000fc400078ee202ULL,
0x0000000821697824ULL, 0x060fe200078e00ffULL, 0x000000726444723cULL, 0x040f620000001844ULL,
0x0000000821687824ULL, 0x040fe200078e00ffULL, 0x0000000602027810ULL, 0x000fe20007ffe0ffULL,
0x0000000821217824ULL, 0x000fe200078e00ffULL, 0xfffffff869047812ULL, 0x000fe200078ee204ULL,
0x000000007878783bULL, 0x000e620000000200ULL, 0xfffffff868037812ULL, 0x000fe400078ee203ULL,
0x0000006c6448723cULL, 0x000f620000001848ULL, 0xfffffff821027812ULL, 0x000fce00078ee202ULL,
0x0000006e644c723cULL, 0x040f70000000184cULL, 0x0000006a645c723cULL, 0x000b64000000185cULL,
0x000000002064783bULL, 0x0204ec0000000200ULL, 0x000000707460723cULL, 0x040b6e0000001860ULL,
0x0000001003707824ULL, 0x120fe200078e021fULL, 0x000000727424723cULL, 0x040f700000001824ULL,
0x0000006c7428723cULL, 0x040b6e0000001828ULL, 0x0000001f056c7211ULL, 0x020fe200078e20ffULL,
0x0000006e742c723cULL, 0x040f70000000182cULL, 0x0000006a743c723cULL, 0x000b6e000000183cULL,
0x0000001004747824ULL, 0x020fe200078e021fULL, 0x0000008000008947ULL, 0x000fd60003800000ULL,
0x0000001178787232ULL, 0x08efe40000000000ULL, 0x000000117a7a7232ULL, 0x000fc40000000000ULL,
0x0000001079797232ULL, 0x080fe40000000000ULL, 0x000000107b7b7232ULL, 0x000fe40000000000ULL,
0x0000000f64647232ULL, 0x080fe40000000000ULL, 0x0000000f66667232ULL, 0x000fe40000000000ULL,
0x0000000e65657232ULL, 0x080fe40000000000ULL, 0x0000000e67677232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x00efea0003800000ULL, 0x0000001002687824ULL, 0x000fe200078e021fULL,
0x000000006c6c783bULL, 0x000e620000004200ULL, 0x000059001a1a7a24ULL, 0x010fe200078e02ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ec0ffULL, 0x00000008961f7824ULL, 0x000fe200078e027cULL,
0x000000007474783bULL, 0x000ea80000004200ULL, 0x000000007070783bULL, 0x000ee80000004200ULL,
0x000000006868783bULL, 0x000ea20000004200ULL, 0x0000006c7860723cULL, 0x042b700000001860ULL,
0x0000006e7824723cULL, 0x040b700000001824ULL, 0x000000747828723cULL, 0x044b700000001828ULL,
0x00000076782c723cULL, 0x040b70000000182cULL, 0x000000707830723cULL, 0x048b700000001830ULL,
0x000000727834723cULL, 0x040b700000001834ULL, 0x000000687838723cULL, 0x040b700000001838ULL,
0x0000006a783c723cULL, 0x000b70000000183cULL, 0x000000746448723cULL, 0x040b700000001848ULL,
0x00000076644c723cULL, 0x040b70000000184cULL, 0x000000706450723cULL, 0x040b700000001850ULL,
0x000000726454723cULL, 0x040b700000001854ULL, 0x0000006c6440723cULL, 0x040b700000001840ULL,
0x0000006e6444723cULL, 0x040b700000001844ULL, 0x000000686458723cULL, 0x040b700000001858ULL,
0x0000006a645c723cULL, 0x000b62000000185cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000000196647810ULL, 0x020fe20007ffe0ffULL, 0x016688001dff7f8cULL, 0x0003e2000c80043fULL,
0x000000801f207811ULL, 0x000fe200078e28ffULL, 0x00000100ff657424ULL, 0x000fe200078e00ffULL,
0x000000236400720cULL, 0x000fe20003f06070ULL, 0x000000801a1a7824ULL, 0x000fe200078e00ffULL,
0x00000060201f7812ULL, 0x000fc600078ec0ffULL, 0x000062001a647625ULL, 0x000fc800078e0065ULL,
0x0000000116797824ULL, 0x000fe200078e021fULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00000003ff717819ULL, 0x002fe40000011600ULL,
0x000020001c1d7812ULL, 0x000fe200078ec0ffULL, 0x000000809a1c7824ULL, 0x000fe200078e00ffULL,
0x00000020951a7217ULL, 0x000fe40007800000ULL, 0x0000000471677810ULL, 0x040fe20007ffe0ffULL,
0x000040007c7c7824ULL, 0x000fe200078e021dULL, 0x00000008711f7810ULL, 0x000fe20007ffe0ffULL,
0x000000011a1a7824ULL, 0x000fe200078e0a20ULL, 0x00000080131c7812ULL, 0x000fe200078ef81cULL,
0x00000001671d7824ULL, 0x100fe200078e0200ULL, 0x0000001471757810ULL, 0x000fe20007ffe0ffULL,
0x0000000867707824ULL, 0x000fe200078e00ffULL, 0x000000201a1a7817ULL, 0x000fe20003800000ULL,
0x000000011f217824ULL, 0x100fe200078e0200ULL, 0x00000010716f7810ULL, 0x000fe20007ffe0ffULL,
0x000000081f727824ULL, 0x000fe200078e00ffULL, 0xfffffff870707812ULL, 0x000fe200078ee21dULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x0000001a6700720cULL, 0x0c0fe20003f86070ULL,
0x0000000167677824ULL, 0x000fe200078e0279ULL, 0xfffffff872727812ULL, 0x000fe200078ee221ULL,
0x0000000171217824ULL, 0x040fe200078e0279ULL, 0x0000000c71697810ULL, 0x000fe20007ffe0ffULL,
0x00000001756c7824ULL, 0x000fe200078e0200ULL, 0x0000001a1f00720cULL, 0x000fe20003f66070ULL,
0x0000010021207825ULL, 0x000fe200078e001cULL, 0x00000003696d7819ULL, 0x000fc400000006ffULL,
0x0000001a6900720cULL, 0x000fe20003f46070ULL, 0x0000000875737824ULL, 0x000fe200078e00ffULL,
0x00000020646a7210ULL, 0x040fe20007f1e0ffULL, 0x0000010067667825ULL, 0x000fe200078e001cULL,
0x0000001a7100720cULL, 0x000fe40003fa6070ULL, 0xfffffff873787812ULL, 0x000fe200078ee26cULL,
0x000000016f6b7824ULL, 0x140fe200078e0200ULL, 0x00000066646c7210ULL, 0x000fe20007f3e0ffULL,
0x000000086f767824ULL, 0x000fe200078e00ffULL, 0x00000018717b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000169687824ULL, 0x000fe200078e0200ULL, 0x0000001c717d7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff876767812ULL, 0x000fe200078ee26bULL, 0x00000001656b7824ULL, 0x000fe200000e0621ULL,
0xfffffff86d747812ULL, 0x000fe200078ee268ULL, 0x000000011f217824ULL, 0x000fe400078e0279ULL,
0x00000001656d7824ULL, 0x000fe200008e0667ULL, 0x0000001a6f00720cULL, 0x000fe20003f26070ULL,
0x0000000169677824ULL, 0x000fe400078e0279ULL, 0x00000001711f7824ULL, 0x000fe400078e0200ULL,
0x0000010021207825ULL, 0x000fc600078e001cULL, 0x000000071f737812ULL, 0x000fe200078ec0ffULL,
0x0000010067667825ULL, 0x000fe200078e001cULL, 0x00000020646e7210ULL, 0x000fe40007f1e0ffULL,
0x0000e0007c1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000016f697824ULL, 0x000fe200078e0279ULL,
0x0000006664667210ULL, 0x000fe20007fde0ffULL, 0x00000001656f7824ULL, 0x000fe200000e0621ULL,
0x0ffffff873207812ULL, 0x000fe200078ef800ULL, 0x0000010069687825ULL, 0x000fe200078e001cULL,
0x0000001a7500720cULL, 0x000fc60003f06070ULL, 0x0000000175217824ULL, 0x000fe400078e0279ULL,
0x0000000165677824ULL, 0x000fe200030e0667ULL, 0x0000006864687210ULL, 0x000fe20007fde0ffULL,
0x0000001020737824ULL, 0x000fe400078e021fULL, 0x0000010021207825ULL, 0x000fc600078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a737faeULL, 0x0003e2000e901c48ULL,
0x0000000165697824ULL, 0x000fe200030e0669ULL, 0x0000001a7b00720cULL, 0x040fe20003fa6070ULL,
0x0000001070757824ULL, 0x000fe200078e021fULL, 0x0000002064707210ULL, 0x000fe20007fde0ffULL,
0x000000017b777824ULL, 0x000fe200078e0279ULL, 0x000000797d797210ULL, 0x000fe40007ffe0ffULL,
0x000000006c757faeULL, 0x0005e2000e101c48ULL, 0x0000000165717824ULL, 0x000fe200030e0621ULL,
0x0000001a7d00720cULL, 0x000fe20003f86070ULL, 0x0000010077207825ULL, 0x000fc800078e001cULL,
0x000000017b1a7824ULL, 0x140fe200078e0200ULL, 0x0000002064207210ULL, 0x000fe20007fde0ffULL,
0x000000087b7b7824ULL, 0x000fe400078e00ffULL, 0x000000017d6a7824ULL, 0x042fe400078e0200ULL,
0x000000087d7d7824ULL, 0x000fe200078e00ffULL, 0xfffffff87b1a7812ULL, 0x000fe200078ee21aULL,
0x00000100791c7825ULL, 0x000fc600078e001cULL, 0xfffffff87d6a7812ULL, 0x000fe200078ee26aULL,
0x0000000165217824ULL, 0x000fe200030e0621ULL, 0x0000001c641c7210ULL, 0x000fe20007fde0ffULL,
0x00000010726b7824ULL, 0x100fe400078e021fULL, 0x00000010746d7824ULL, 0x104fe400078e021fULL,
0x0000001076737824ULL, 0x100fe200078e021fULL, 0x000000006e6b7faeULL, 0x0003e2000d901c48ULL,
0x0000001078757824ULL, 0x100fe400078e021fULL, 0x000000101a777824ULL, 0x100fe200078e021fULL,
0x00000000666d7faeULL, 0x0003e2000d101c48ULL, 0x000000106a1f7824ULL, 0x000fc400078e021fULL,
0x00000001651d7824ULL, 0x000fe200030e061dULL, 0x0000000068737faeULL, 0x0003e8000c901c48ULL,
0x0000000070757faeULL, 0x0003e8000c101c48ULL, 0x0000000020777faeULL, 0x0003e8000e901c48ULL,
0x000000001c1f7faeULL, 0x0003e2000e101c48ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x0000000800677811ULL, 0x002fe200078fe8ffULL, 0x000000809a707824ULL, 0x000fe200078e00ffULL,
0x000020001c1d7812ULL, 0x000fc400078ec0ffULL, 0x0000000400217811ULL, 0x040fe200078fe8ffULL,
0x00000001671c7824ULL, 0x140fe200078e0200ULL, 0x0000000c00697811ULL, 0x040fe200078fe8ffULL,
0x00000008676d7824ULL, 0x000fe200078e00ffULL, 0x00000010006b7811ULL, 0x000fe200078fe8ffULL,
0x000040007c7c7824ULL, 0x000fe200078e021dULL, 0x0000000369767819ULL, 0x000fe200000006ffULL,
0x00000001211a7824ULL, 0x000fe200078e0200ULL, 0xfffffff86d747812ULL, 0x000fe200078ee21cULL,
0x00000008211f7824ULL, 0x000fe200078e00ffULL, 0x00000014006d7811ULL, 0x040fe200078fe8ffULL,
0x00000001691d7824ULL, 0x000fe200078e0200ULL, 0x00000018006f7811ULL, 0x000fe200078fe8ffULL,
0x0000000121217824ULL, 0x000fe200078e0279ULL, 0xfffffff81f727812ULL, 0x000fe200078ee21aULL,
0x000000016b1a7824ULL, 0x040fe200078e0200ULL, 0xfffffff876767812ULL, 0x000fe200078ee21dULL,
0x000000086b1d7824ULL, 0x000fe200078e00ffULL, 0x0000008013707812ULL, 0x000fe200078ef870ULL,
0x000000016d1c7824ULL, 0x040fe200078e0200ULL, 0x0000e0007c7f7810ULL, 0x000fe20007ffe0ffULL,
0x000000086d1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d787812ULL, 0x000fe200078ee21aULL,
0x000000016f1d7824ULL, 0x040fe200078e0200ULL, 0x00000000001a7211ULL, 0x040fe200078fe8ffULL,
0x000000086f7e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f7a7812ULL, 0x000fe200078ee21cULL,
0x0000000167677824ULL, 0x100fe200078e0279ULL, 0x0000001c001f7811ULL, 0x000fe200078fe8ffULL,
0x0000000169697824ULL, 0x100fe200078e0279ULL, 0x000000071a717812ULL, 0x000fe200078ec0ffULL,
0x000000016b6b7824ULL, 0x000fe200078e0279ULL, 0xfffffff87e7e7812ULL, 0x000fe200078ee21dULL,
0x000000011f1a7824ULL, 0x040fe200078e0200ULL, 0x00000079001d7211ULL, 0x000fe200078fe8ffULL,
0x000000081f737824ULL, 0x000fc400078e00ffULL, 0x000000016d6d7824ULL, 0x100fe400078e0279ULL,
0x000000016f6f7824ULL, 0x100fe200078e0279ULL, 0xfffffff873887812ULL, 0x000fe200078ee21aULL,
0x000000011f1f7824ULL, 0x000fe200078e0279ULL, 0x0ffffff8711a7812ULL, 0x000fe200078ef800ULL,
0x000000ffff717224ULL, 0x000fe200078e00ffULL, 0x0000007f72737211ULL, 0x000fe200078e20ffULL,
0x0000001074757824ULL, 0x000fe400078e027fULL, 0x000001001d1c7825ULL, 0x000fc800078e0070ULL,
0x0000010021207825ULL, 0x000fe200078e0070ULL, 0x0000001c641c7210ULL, 0x000fc60007f1e0ffULL,
0x0000010067667825ULL, 0x000fe200078e0070ULL, 0x0000002064207210ULL, 0x000fc60007f3e0ffULL,
0x0000010069687825ULL, 0x000fe200078e0070ULL, 0x0000006664667210ULL, 0x000fc60007f5e0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0070ULL, 0x0000006864687210ULL, 0x000fc60007f7e0ffULL,
0x000001006d6c7825ULL, 0x000fc800078e0070ULL, 0x000001006f6e7825ULL, 0x000fc800078e0070ULL,
0x000001001f707825ULL, 0x000fc800078e0070ULL, 0x00000001651d7824ULL, 0x040fe200000e061dULL,
0x0000006a646a7210ULL, 0x040fe20007f1e0ffULL, 0x0000000165217824ULL, 0x040fe200008e0621ULL,
0x0000006c646c7210ULL, 0x000fe20007f3e0ffULL, 0x000000101a1f7824ULL, 0x000fe400078e027fULL,
0x0000000165677824ULL, 0x040fe200010e0667ULL, 0x0000006e646e7210ULL, 0x040fe20007f5e0ffULL,
0x0000000165697824ULL, 0x000fe200018e0669ULL, 0x0000007064707210ULL, 0x000fe20007f7e0ffULL,
0x0000001076777824ULL, 0x100fe200078e027fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c1f7faeULL, 0x0003e2000b901c48ULL, 0x0000001078797824ULL, 0x000fc400078e027fULL,
0x00000001656b7824ULL, 0x040fe200000e066bULL, 0x0000000020737faeULL, 0x0003e2000b901c48ULL,
0x000000107a7b7824ULL, 0x000fe400078e027fULL, 0x00000001656d7824ULL, 0x040fe200008e066dULL,
0x0000000066757faeULL, 0x0003e2000b901c48ULL, 0x000000107e7d7824ULL, 0x000fe400078e027fULL,
0x00000001656f7824ULL, 0x000fe200010e066fULL, 0x0000000068777faeULL, 0x0003e2000b901c48ULL,
0x00000010887f7824ULL, 0x000fc400078e027fULL, 0x0000000165717824ULL, 0x000fe200018e0671ULL,
0x000000006a797faeULL, 0x0003e8000b901c48ULL, 0x000000006c7b7faeULL, 0x0003e8000b901c48ULL,
0x000000006e7d7faeULL, 0x0003e8000b901c48ULL, 0x00000000707f7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffe0191a7812ULL, 0x000fc400078ec0ffULL,
0x00000010191d7812ULL, 0x042fe400078ec0ffULL, 0x00000008191c7812ULL, 0x000fc800078ec0ffULL,
0x0000001a1c687210ULL, 0x000fe20007ffe01dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0166280068667f8cULL, 0x0002a4000c80043fULL, 0x00000000001c7805ULL, 0x000fc40000015200ULL,
0x01662c00681f7984ULL, 0x000ee40000000800ULL, 0x800000001fff7812ULL, 0x00cfe40007804867ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff697224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000201c1f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000121207824ULL, 0x000fe200000e0e1dULL, 0x003d09001f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2000720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2000720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1a7819ULL, 0x000fc80000011420ULL,
0x0000001f1a1a7211ULL, 0x000fca00078110ffULL, 0x000000ffff1f7224ULL, 0x000fca00000e0620ULL,
0x000000021a1a7819ULL, 0x000fc8000000121fULL, 0x0000001a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000169697810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01662c00681f7984ULL, 0x000ea40000000800ULL,
0x800000001fff7812ULL, 0x004fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000209a1a7824ULL, 0x000fca00078e00ffULL, 0xffffff801a1a7812ULL, 0x000fc800078ec0ffULL,
0x00000080131d7810ULL, 0x000fc80007ffe01aULL, 0x0000001d221d7210ULL, 0x000fca0007ffe0ffULL,
0x016000001d677984ULL, 0x000ea80000000800ULL, 0x016200001d697984ULL, 0x0006620000000800ULL,
0x000000186700720bULL, 0x004fe20003f1d000ULL, 0x000138227f007947ULL, 0x000fd8000b800000ULL,
0x00000000001a7806ULL, 0x008fc800000e0100ULL, 0x000000ff1a00720cULL, 0x000fe20003f25270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff1c7224ULL, 0x000fd400078e0018ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x000000019a1d7811ULL, 0x000fe400078ff0ffULL, 0x000000186700720bULL, 0x000fe40003f34000ULL,
0x0000009a1d00720cULL, 0x000fe20003f05270ULL, 0x000137d27f007947ULL, 0x000fd4000b800000ULL,
0x00000000001d7806ULL, 0x000fc400008e0100ULL, 0x000000809a1f8824ULL, 0x000fe200078e0213ULL,
0x00000018671c8209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x00000001221f8824ULL, 0x000fca00078e021fULL, 0x0164001c1f008388ULL, 0x0005e20000000800ULL,
0x000000ff1d00720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x00000018671f7209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff1dff7812ULL, 0x000fc6000780c0ffULL, 0x000000181f1c7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1c1c7820ULL, 0x000fc80000410000ULL, 0x0000001c006b7308ULL, 0x000ea40000000800ULL,
0x0000006b1e1e7220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1f7819ULL, 0x000fe20000011600ULL, 0x000137027f007947ULL, 0x000fea000b800000ULL,
0x00001f1f6b1f7589ULL, 0x0004e400000e0000ULL, 0x0000001f60607220ULL, 0x08cfe20000410000ULL,
0x0000001f61617220ULL, 0x080fe20000410000ULL, 0x0000001f24247220ULL, 0x080fe20000410000ULL,
0x0000001f25257220ULL, 0x080fe20000410000ULL, 0x0000001f28287220ULL, 0x080fe20000410000ULL,
0x0000001f29297220ULL, 0x080fe20000410000ULL, 0x0000001f2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001f2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001f30307220ULL, 0x080fe20000410000ULL,
0x0000001f31317220ULL, 0x080fe20000410000ULL, 0x0000001f34347220ULL, 0x080fe20000410000ULL,
0x0000001f35357220ULL, 0x080fe20000410000ULL, 0x0000001f38387220ULL, 0x080fe20000410000ULL,
0x0000001f39397220ULL, 0x080fe20000410000ULL, 0x0000001f3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001f3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001dff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001f7811ULL, 0x000fe200078ff0ffULL,
0x000135d27f007947ULL, 0x000fea000b800000ULL, 0x00001f1f6b1f7589ULL, 0x0004e400000e0000ULL,
0x0000001f62627220ULL, 0x08cfe20000410000ULL, 0x0000001f63637220ULL, 0x080fe20000410000ULL,
0x0000001f26267220ULL, 0x080fe20000410000ULL, 0x0000001f27277220ULL, 0x080fe20000410000ULL,
0x0000001f2a2a7220ULL, 0x080fe20000410000ULL, 0x0000001f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001f32327220ULL, 0x080fe20000410000ULL, 0x0000001f33337220ULL, 0x080fe20000410000ULL,
0x0000001f36367220ULL, 0x080fe20000410000ULL, 0x0000001f37377220ULL, 0x080fe20000410000ULL,
0x0000001f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001f3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00001dff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000010001f7811ULL, 0x000fe200078ff0ffULL, 0x000134a27f007947ULL, 0x000fea000b800000ULL,
0x00001f1f6b1f7589ULL, 0x0004e400000e0000ULL, 0x0000001f40407220ULL, 0x08cfe20000410000ULL,
0x0000001f41417220ULL, 0x080fe20000410000ULL, 0x0000001f44447220ULL, 0x080fe20000410000ULL,
0x0000001f45457220ULL, 0x080fe20000410000ULL, 0x0000001f48487220ULL, 0x080fe20000410000ULL,
0x0000001f49497220ULL, 0x080fe20000410000ULL, 0x0000001f4c4c7220ULL, 0x080fe20000410000ULL,
0x0000001f4d4d7220ULL, 0x080fe20000410000ULL, 0x0000001f50507220ULL, 0x080fe20000410000ULL,
0x0000001f51517220ULL, 0x080fe20000410000ULL, 0x0000001f54547220ULL, 0x080fe20000410000ULL,
0x0000001f55557220ULL, 0x080fe20000410000ULL, 0x0000001f58587220ULL, 0x080fe20000410000ULL,
0x0000001f59597220ULL, 0x080fe20000410000ULL, 0x0000001f5c5c7220ULL, 0x080fe20000410000ULL,
0x0000001f5d5d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000001dff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000018001f7811ULL, 0x000fe200078ff0ffULL, 0x000133827f007947ULL, 0x000fea000b800000ULL,
0x00001f1f6b1f7589ULL, 0x0004e400000e0000ULL, 0x0000001f42427220ULL, 0x08cfe20000410000ULL,
0x0000001f43437220ULL, 0x080fe20000410000ULL, 0x0000001f46467220ULL, 0x080fe20000410000ULL,
0x0000001f47477220ULL, 0x080fe20000410000ULL, 0x0000001f4a4a7220ULL, 0x080fe20000410000ULL,
0x0000001f4b4b7220ULL, 0x080fe20000410000ULL, 0x0000001f4e4e7220ULL, 0x080fe20000410000ULL,
0x0000001f4f4f7220ULL, 0x080fe20000410000ULL, 0x0000001f52527220ULL, 0x080fe20000410000ULL,
0x0000001f53537220ULL, 0x080fe20000410000ULL, 0x0000001f56567220ULL, 0x080fe20000410000ULL,
0x0000001f57577220ULL, 0x080fe20000410000ULL, 0x0000001f5a5a7220ULL, 0x080fe20000410000ULL,
0x0000001f5b5b7220ULL, 0x080fe20000410000ULL, 0x0000001f5e5e7220ULL, 0x080fe20000410000ULL,
0x0000001f5f5f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000001d1aff7212ULL, 0x000fe400078030ffULL, 0x00000018671c7209ULL, 0x000fd60007810000ULL,
0x8000001c67670221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b67670820ULL, 0x000fc80000410000ULL,
0x0000006700120308ULL, 0x000ea40000000800ULL, 0x0000001269690220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000001e691e7221ULL, 0x002fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000012ff0e723eULL, 0x000fe400000000ffULL, 0x00000002ff1d7819ULL, 0x000fe40000011600ULL,
0x000054100e0e7816ULL, 0x000fe2000000000eULL, 0x000131c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1d0e117589ULL, 0x0002a400000e0000ULL, 0x000000081d1f7810ULL, 0x000fe20007ffe0ffULL,
0x000131f27f007947ULL, 0x000fea000b800000ULL, 0x000000101d0f7810ULL, 0x000fe20007ffe0ffULL,
0x00001f1f0e107589ULL, 0x00066a00000e0000ULL, 0x00001f0f0e0f7589ULL, 0x0006a400000e0000ULL,
0x000000181d1f7810ULL, 0x008fe20007ffe0ffULL, 0x000132427f007947ULL, 0x000fea000b800000ULL,
0x00001f1f0e0e7589ULL, 0x0022e400000e0000ULL, 0x000004009a187824ULL, 0x040fe200078e00ffULL,
0x0000000d9a1a7819ULL, 0x000fe200000006ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000016000007945ULL, 0x000fe40003800000ULL, 0xfffff00018187812ULL, 0x000fc400078ec0ffULL,
0xffffc0001a207812ULL, 0x000fe400078ec0ffULL, 0x0000b00018187810ULL, 0x000fc60007ffe0ffULL,
0x00002000151d7824ULL, 0x000fe400078e0220ULL, 0x000000100d7c7824ULL, 0x100fe400078e0218ULL,
0x000000100c187824ULL, 0x000fe200078e0218ULL, 0x0000f0001d1d7810ULL, 0x000fc60007ffe0ffULL,
0x000000007c7c783bULL, 0x000e640000000200ULL, 0x000000100a787824ULL, 0x100fe400078e021dULL,
0x000000001868783bULL, 0x0006a20000000200ULL, 0x000000100b747824ULL, 0x100fe400078e021dULL,
0x0000001009707824ULL, 0x000fe200078e021dULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x000000117c7c7232ULL, 0x086fe40000000000ULL, 0x000000117e7e7232ULL, 0x000fc40000000000ULL,
0x000000107d7d7232ULL, 0x080fe40000000000ULL, 0x000000107f7f7232ULL, 0x000fe40000000000ULL,
0x0000000f68687232ULL, 0x080fe40000000000ULL, 0x0000000f6a6a7232ULL, 0x000fe40000000000ULL,
0x0000000e69697232ULL, 0x088fe40000000000ULL, 0x0000000e6b6b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010086c7824ULL, 0x000fe200078e021dULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x00000002ff1d7819ULL, 0x100fe2000001169aULL,
0x0000029000007945ULL, 0x000fe20003800000ULL, 0x00000001ff187819ULL, 0x008fe2000001169aULL,
0x000000007474783bULL, 0x000ee20000004200ULL, 0x0000b0001d1f7811ULL, 0x002fc600078e60ffULL,
0x000000007070783bULL, 0x000e620000004200ULL, 0x0000000218207824ULL, 0x000fc600078e0215ULL,
0x000000006c6c783bULL, 0x000ea40000004200ULL, 0x0000f00020207811ULL, 0x000fe200078e68ffULL,
0x000000787c60723cULL, 0x050f700000001860ULL, 0x0000007a7c24723cULL, 0x040f700000001824ULL,
0x000000747c28723cULL, 0x048f700000001828ULL, 0x000000767c2c723cULL, 0x040f70000000182cULL,
0x000000707c30723cULL, 0x042f700000001830ULL, 0x000000727c34723cULL, 0x040f700000001834ULL,
0x0000006c7c38723cULL, 0x044f700000001838ULL, 0x0000006e7c3c723cULL, 0x000b6e000000183cULL,
0x00000010077c7824ULL, 0x120fe200078e021fULL, 0x000000786840723cULL, 0x000b620000001840ULL,
0x00000010061f7824ULL, 0x000fc800078e021fULL, 0x000000007c7c783bULL, 0x000e640000000200ULL,
0x0000001005787824ULL, 0x120fe200078e0220ULL, 0x0000007a6844723cULL, 0x040f700000001844ULL,
0x000000746848723cULL, 0x040b6e0000001848ULL, 0x0000001004747824ULL, 0x120fe200078e0220ULL,
0x00000076684c723cULL, 0x040f70000000184cULL, 0x000000706850723cULL, 0x040b6e0000001850ULL,
0x0000001003707824ULL, 0x020fe200078e0220ULL, 0x000000726854723cULL, 0x040f700000001854ULL,
0x0000006c6858723cULL, 0x040f700000001858ULL, 0x0000006e685c723cULL, 0x000b64000000185cULL,
0x000000001f68783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000008947ULL, 0x000fde0003800000ULL, 0x000000117c7c7232ULL, 0x082fe40000000000ULL,
0x000000117e7e7232ULL, 0x000fc40000000000ULL, 0x000000107d7d7232ULL, 0x080fe40000000000ULL,
0x000000107f7f7232ULL, 0x000fe40000000000ULL, 0x0000000f68687232ULL, 0x088fe40000000000ULL,
0x0000000f6a6a7232ULL, 0x000fe40000000000ULL, 0x0000000e69697232ULL, 0x080fe40000000000ULL,
0x0000000e6b6b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x002fea0003800000ULL,
0x00000010026c7824ULL, 0x000fe200078e0220ULL, 0x000000007878783bULL, 0x000e620000004200ULL,
0x0000000896207824ULL, 0x000fe200078e0218ULL, 0x000166901d1f7811ULL, 0x004fc400078e18ffULL,
0x000000007474783bULL, 0x000ea80000004200ULL, 0x000000007070783bULL, 0x000f280000004200ULL,
0x000000006c6c783bULL, 0x000ee20000004200ULL, 0x000000787c60723cULL, 0x042b700000001860ULL,
0x0000007a7c24723cULL, 0x040b700000001824ULL, 0x000000747c28723cULL, 0x044b700000001828ULL,
0x000000767c2c723cULL, 0x040b70000000182cULL, 0x000000707c30723cULL, 0x050b700000001830ULL,
0x000000727c34723cULL, 0x040b700000001834ULL, 0x0000006c7c38723cULL, 0x048b700000001838ULL,
0x0000006e7c3c723cULL, 0x000b70000000183cULL, 0x000000786840723cULL, 0x040b700000001840ULL,
0x0000007a6844723cULL, 0x040b700000001844ULL, 0x000000746848723cULL, 0x040b700000001848ULL,
0x00000076684c723cULL, 0x040b70000000184cULL, 0x000000706850723cULL, 0x040b700000001850ULL,
0x000000726854723cULL, 0x040b700000001854ULL, 0x0000006c6858723cULL, 0x040b700000001858ULL,
0x0000006e685c723cULL, 0x000b62000000185cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000000196667810ULL, 0x000fe20007ffe0ffULL, 0x000000001fff7f8cULL, 0x0003e2000c80043fULL,
0x000000c020207811ULL, 0x000fc400078e28ffULL, 0x000000236600720cULL, 0x000fe40003f06070ULL,
0x0000006020217812ULL, 0x000fca00078ec0ffULL, 0x0000000116777824ULL, 0x020fe200078e0221ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000065000008947ULL, 0x000fea0003800000ULL,
0x00000003ff727819ULL, 0x002fe40000011600ULL, 0x00000020951f7217ULL, 0x000fe40007800000ULL,
0x0000000472667810ULL, 0x040fe40007ffe0ffULL, 0x00000008726a7810ULL, 0x000fe20007ffe0ffULL,
0x000000011f1f7824ULL, 0x000fe200078e0a20ULL, 0x0000000066217210ULL, 0x040fe20007ffe0ffULL,
0x00000008666c7824ULL, 0x000fe200078e00ffULL, 0x0000000c72707810ULL, 0x000fe20007ffe0ffULL,
0x000000016a677824ULL, 0x040fe200078e0200ULL, 0x000000201f1f7817ULL, 0x000fe20003800000ULL,
0x000000086a6e7824ULL, 0x000fe200078e00ffULL, 0xfffffff86c757812ULL, 0x000fe200078ee221ULL,
0x000000809a207824ULL, 0x000fe200078e00ffULL, 0x0000001072767810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0xfffffff86e7d7812ULL, 0x000fe200078ee267ULL,
0x0000000172677824ULL, 0x100fe200078e0277ULL, 0x0000008013207812ULL, 0x000fe200078ef820ULL,
0x0000000170687824ULL, 0x000fe200078e0200ULL, 0x0000001472787810ULL, 0x000fe20007ffe0ffULL,
0x00000008707f7824ULL, 0x000fe200078e00ffULL, 0x0000001f6600720cULL, 0x0c0fe20003f86070ULL,
0x0000000166697824ULL, 0x000fe200078e0277ULL, 0x0000001f7000720cULL, 0x000fe20003f46070ULL,
0x0000010067667825ULL, 0x000fe200078e0020ULL, 0xfffffff87f7f7812ULL, 0x000fc400078ee268ULL,
0x0000001f6a00720cULL, 0x080fe20003f66070ULL, 0x00000001766b7824ULL, 0x000fe200078e0200ULL,
0x00000066646c7210ULL, 0x000fe20007f1e0ffULL, 0x00000008766e7824ULL, 0x000fe200078e00ffULL,
0x0000001f7200720cULL, 0x000fe20003fa6070ULL, 0x0000010069687825ULL, 0x000fc600078e0020ULL,
0xfffffff86e877812ULL, 0x000fe200078ee26bULL, 0x00000001786d7824ULL, 0x100fe200078e0200ULL,
0x00000068646e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000878747824ULL, 0x000fe200078e00ffULL,
0x000020001a6b7812ULL, 0x000fe400078ec0ffULL, 0x00000000721a7210ULL, 0x000fe20007ffe0ffULL,
0x00000001656f7824ULL, 0x040fe200008e0669ULL, 0xfffffff874897812ULL, 0x000fe200078ee26dULL,
0x00000001656d7824ULL, 0x000fe200000e0667ULL, 0x000000071a737812ULL, 0x000fe200078ec0ffULL,
0x000000016a677824ULL, 0x100fe200078e0277ULL, 0x00000018721a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000170697824ULL, 0x000fe200078e0277ULL, 0x0ffffff873737812ULL, 0x000fe200078ef800ULL,
0x0000010067667825ULL, 0x000fe200078e0020ULL, 0x0000001f7600720cULL, 0x000fc60003f26070ULL,
0x0000010069687825ULL, 0x000fe200078e0020ULL, 0x0000006664707210ULL, 0x000fc60007f1e0ffULL,
0x0000400018747824ULL, 0x000fe200078e026bULL, 0x0000006864687210ULL, 0x000fe20007fde0ffULL,
0x00000001766b7824ULL, 0x000fe200078e0277ULL, 0x0000001c72767810ULL, 0x000fe20007ffe0ffULL,
0x0000000165717824ULL, 0x000fe200000e0667ULL, 0x0000f00074747810ULL, 0x000fe20007ffe0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0020ULL, 0x0000001f7800720cULL, 0x040fe40003f06070ULL,
0x0000007489897211ULL, 0x000fe200078e20ffULL, 0x0000000178677824ULL, 0x000fc400078e0277ULL,
0x0000000165697824ULL, 0x000fe200030e0669ULL, 0x0000006a646a7210ULL, 0x000fe20007fde0ffULL,
0x0000010067667825ULL, 0x000fc800078e0020ULL, 0x00000001656b7824ULL, 0x000fe200030e066bULL,
0x0000006664727210ULL, 0x000fe20007fde0ffULL, 0x0000001073797824ULL, 0x100fe400078e0274ULL,
0x00000010757b7824ULL, 0x000fe400078e0274ULL, 0x000000011a757824ULL, 0x040fe200078e0277ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006c797faeULL, 0x0003e2000e901c48ULL,
0x0000000165737824ULL, 0x000fe200030e0667ULL, 0x0000001f1a00720cULL, 0x080fe20003fa6070ULL,
0x0000010075667825ULL, 0x000fe200078e0020ULL, 0x000000006e7b7faeULL, 0x0005e2000e101c48ULL,
0x0000001f7600720cULL, 0x000fc40003f86070ULL, 0x00000001761f7824ULL, 0x000fe200078e0277ULL,
0x0000006664667210ULL, 0x000fe20007fde0ffULL, 0x000000107d7d7824ULL, 0x000fe400078e0274ULL,
0x000001001f207825ULL, 0x000fc600078e0020ULL, 0x00000000707d7faeULL, 0x0007e2000d901c48ULL,
0x000000011a6c7824ULL, 0x142fe400078e0200ULL, 0x000000081a6d7824ULL, 0x000fe400078e00ffULL,
0x00000001761a7824ULL, 0x040fe400078e0200ULL, 0x00000008766f7824ULL, 0x004fe200078e00ffULL,
0xfffffff86d1f7812ULL, 0x000fe200078ee26cULL, 0x0000000165677824ULL, 0x000fe200030e0667ULL,
0x0000002064207210ULL, 0x000fe20007fde0ffULL, 0x000000107f7f7824ULL, 0x000fe200078e0274ULL,
0xfffffff86f6d7812ULL, 0x000fe200078ee21aULL, 0x0000001087877824ULL, 0x000fc400078e0274ULL,
0x000000101f1f7824ULL, 0x100fe200078e0274ULL, 0x00000000687f7faeULL, 0x0007e2000d101c48ULL,
0x000000106d6d7824ULL, 0x000fe400078e0274ULL, 0x0000000165217824ULL, 0x000fe200030e0621ULL,
0x000000006a877faeULL, 0x0007e8000c901c48ULL, 0x0000000072897faeULL, 0x0007e8000c101c48ULL,
0x00000000661f7faeULL, 0x0007e8000e901c48ULL, 0x00000000206d7faeULL, 0x0007e2000e101c48ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000400677811ULL, 0x002fe200078fe8ffULL,
0x000000809a727824ULL, 0x000fe200078e00ffULL, 0x0000000800697811ULL, 0x000fc400078fe8ffULL,
0x0000000c006b7811ULL, 0x040fe200078fe8ffULL, 0x00000001671f7824ULL, 0x140fe200078e0200ULL,
0x00000014006f7811ULL, 0x040fe200078fe8ffULL, 0x0000000867747824ULL, 0x000fe200078e00ffULL,
0x00000010006d7811ULL, 0x040fe200078fe8ffULL, 0x0000000169207824ULL, 0x140fe200078e0200ULL,
0x0000001800717811ULL, 0x000fe200078fe8ffULL, 0x0000000869217824ULL, 0x000fe200078e00ffULL,
0xfffffff874747812ULL, 0x000fe200078ee21fULL, 0x000000016b1f7824ULL, 0x000fe200078e0200ULL,
0x0000008013727812ULL, 0x000fe200078ef872ULL, 0x000000086b787824ULL, 0x000fe200078e00ffULL,
0xfffffff821767812ULL, 0x000fe200078ee220ULL, 0x000000016f217824ULL, 0x100fe200078e0200ULL,
0x0000007769697210ULL, 0x000fe20007ffe0ffULL, 0x000000086f7c7824ULL, 0x000fe200078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee21fULL, 0x000000016d207824ULL, 0x140fe200078e0200ULL,
0x000020001a1f7812ULL, 0x000fe200078ec0ffULL, 0x000000086d737824ULL, 0x000fe200078e00ffULL,
0xfffffff87c7c7812ULL, 0x000fe200078ee221ULL, 0x0000000171667824ULL, 0x040fe200078e0200ULL,
0x00000000001a7211ULL, 0x040fe200078fe8ffULL, 0x0000000871757824ULL, 0x000fe200078e00ffULL,
0x0000001c00217811ULL, 0x000fe200078fe8ffULL, 0x0000000167677824ULL, 0x000fe200078e0277ULL,
0xfffffff8737a7812ULL, 0x000fe200078ee220ULL, 0x0000400018207824ULL, 0x000fe200078e021fULL,
0xfffffff8757e7812ULL, 0x000fe200078ee266ULL, 0x0000000821757824ULL, 0x040fe200078e00ffULL,
0x000000071a737812ULL, 0x000fe200078ec0ffULL, 0x00000001211a7824ULL, 0x000fc400078e0200ULL,
0x00000001211f7824ULL, 0x100fe200078e0277ULL, 0x0000007700217211ULL, 0x000fe200078fe8ffULL,
0x000000016b6b7824ULL, 0x100fe200078e0277ULL, 0xfffffff875887812ULL, 0x000fe200078ee21aULL,
0x000000016d6d7824ULL, 0x100fe200078e0277ULL, 0x0ffffff8731a7812ULL, 0x000fe200078ef800ULL,
0x000000ffff737224ULL, 0x000fe200078e00ffULL, 0x0000f00020757810ULL, 0x000fe20007ffe0ffULL,
0x000000016f6f7824ULL, 0x000fe400078e0277ULL, 0x0000010021207825ULL, 0x000fc800078e0072ULL,
0x0000010067667825ULL, 0x000fe200078e0072ULL, 0x0000002064207210ULL, 0x000fc60007f1e0ffULL,
0x0000010069687825ULL, 0x000fe200078e0072ULL, 0x0000006664667210ULL, 0x000fc60007f3e0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0072ULL, 0x0000006864687210ULL, 0x000fc60007f5e0ffULL,
0x0000000171717824ULL, 0x000fe200078e0277ULL, 0x0000006a646a7210ULL, 0x000fe20007f7e0ffULL,
0x000001006d6c7825ULL, 0x000fe200078e0072ULL, 0x0000006965697210ULL, 0x000fc600017fe4ffULL,
0x000001006f6e7825ULL, 0x000fc800078e0072ULL, 0x0000010071707825ULL, 0x000fc800078e0072ULL,
0x000001001f727825ULL, 0x000fe200078e0072ULL, 0x0000007064707210ULL, 0x000fc60007f5e0ffULL,
0x0000000165217824ULL, 0x040fe200000e0621ULL, 0x0000006c646c7210ULL, 0x040fe20007f1e0ffULL,
0x0000000165677824ULL, 0x040fe200008e0667ULL, 0x0000006e646e7210ULL, 0x000fe20007f3e0ffULL,
0x000000101a1f7824ULL, 0x100fe400078e0275ULL, 0x0000001074777824ULL, 0x000fe400078e0275ULL,
0x00000001656b7824ULL, 0x000fe200018e066bULL, 0x0000007264647210ULL, 0x000fe20007f7e0ffULL,
0x0000001076797824ULL, 0x100fe200078e0275ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000201f7faeULL, 0x0003e2000b901c48ULL, 0x00000010787b7824ULL, 0x000fc400078e0275ULL,
0x000000107a7d7824ULL, 0x000fe200078e0275ULL, 0x0000000066777faeULL, 0x0003e2000b901c48ULL,
0x00000001656d7824ULL, 0x040fe400000e066dULL, 0x000000107c7f7824ULL, 0x000fe200078e0275ULL,
0x0000000068797faeULL, 0x0003e2000b901c48ULL, 0x00000001656f7824ULL, 0x040fe400008e066fULL,
0x000000107e877824ULL, 0x000fe200078e0275ULL, 0x000000006a7b7faeULL, 0x0003e2000b901c48ULL,
0x0000000165717824ULL, 0x000fc400010e0671ULL, 0x0000001088757824ULL, 0x000fe200078e0275ULL,
0x000000006c7d7faeULL, 0x0003e2000b901c48ULL, 0x0000000165657824ULL, 0x000fc600018e0673ULL,
0x000000006e7f7faeULL, 0x0003e8000b901c48ULL, 0x0000000070877faeULL, 0x0003e8000b901c48ULL,
0x0000000064757faeULL, 0x0003e4000b901c48ULL, 0x00000300ff1a7624ULL, 0x000fe200078e00ffULL,
0x000000011b1f7812ULL, 0x00afe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000011f00780cULL, 0x000fc40003f05070ULL, 0xffffffff1a1a7811ULL, 0x000fc800078e08ffULL,
0x000000011a1a7807ULL, 0x000fca0004000000ULL, 0x000000011b1b7824ULL, 0x000fe400078e021aULL,
0xffffffffff1a7424ULL, 0x000fc600078e00ffULL, 0x000000941b00720cULL, 0x000fda0003f06070ULL,
0x000000011b208824ULL, 0x000fe400078e0214ULL, 0x00000004ff218424ULL, 0x000fc800078e00ffULL,
0x0000640020208625ULL, 0x000fca00078e0021ULL, 0x00000008201a8981ULL, 0x000322000c1e1900ULL,
0x0000001019647812ULL, 0x000fca00078ec0ffULL, 0x000000201d1d7824ULL, 0x000fe200078e0264ULL,
0x0000000819647812ULL, 0x000fca00078ec0ffULL, 0x00000001641d7824ULL, 0x000fe200078e021dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x016648001d667f8cULL, 0x0022a4000c80043fULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x01664c001d1f7984ULL, 0x000ee40000000800ULL,
0x800000001fff7812ULL, 0x00cfe40007804867ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff687224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000647805ULL, 0x000fcc0000015200ULL,
0x0000006420647210ULL, 0x000fca0007f1e1ffULL, 0x0000000165657824ULL, 0x000fe200000e0e21ULL,
0x003d09006400780cULL, 0x000fc80003f06070ULL, 0x000000ff6500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406400780cULL, 0x000fc80003f06070ULL,
0x000000ff6500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1f7819ULL, 0x000fc80000011465ULL, 0x000000641f1f7211ULL, 0x000fca00078110ffULL,
0x000000ffff647224ULL, 0x000fca00000e0665ULL, 0x000000021f1f7819ULL, 0x000fc80000001264ULL,
0x0000001f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000168687810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01664c001d1f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x004fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000209a1d7824ULL, 0x002fca00078e00ffULL,
0xffffff801d207812ULL, 0x000fc800078ec0ffULL, 0x00000100131d7810ULL, 0x000fca0007ffe020ULL,
0x00000001221d7824ULL, 0x000fca00078e021dULL, 0x016000001d657984ULL, 0x000e680000000800ULL,
0x016200001d677984ULL, 0x0004e20000000800ULL, 0x0000001c6500720bULL, 0x002fe20003f1d000ULL,
0x00011be27f007947ULL, 0x000fd8000b800000ULL, 0x00000000001d7806ULL, 0x004fc800000e0100ULL,
0x000000ff1d00720cULL, 0x000fe20003f25270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x000000029a1f7811ULL, 0x000fe400078ff0ffULL, 0x0000001c6500720bULL, 0x000fe40003f34000ULL,
0x0000009a1f00720cULL, 0x000fe20003f05270ULL, 0x00011ba27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000647806ULL, 0x000fc400008e0100ULL, 0x000000809a218824ULL, 0x000fe200078e0213ULL,
0x0000001c651f8209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000122208824ULL, 0x000fca00078e0221ULL, 0x0164001f20008388ULL, 0x0003e20000000800ULL,
0x000000ff6400720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000001c651f7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff64ff7812ULL, 0x000fc6000780c0ffULL, 0x0000001c1f1f7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b1f1f7820ULL, 0x000fc80000410000ULL, 0x0000001f00697308ULL, 0x000e640000000800ULL,
0x000000691e1e7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1f7819ULL, 0x000fe20000011600ULL, 0x00011ad27f007947ULL, 0x000fea000b800000ULL,
0x00001f1f691f7589ULL, 0x0002a400000e0000ULL, 0x0000001f60607220ULL, 0x084fe20000410000ULL,
0x0000001f61617220ULL, 0x080fe20000410000ULL, 0x0000001f24247220ULL, 0x080fe20000410000ULL,
0x0000001f25257220ULL, 0x080fe20000410000ULL, 0x0000001f28287220ULL, 0x080fe20000410000ULL,
0x0000001f29297220ULL, 0x080fe20000410000ULL, 0x0000001f2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001f2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001f30307220ULL, 0x080fe20000410000ULL,
0x0000001f31317220ULL, 0x080fe20000410000ULL, 0x0000001f34347220ULL, 0x080fe20000410000ULL,
0x0000001f35357220ULL, 0x080fe20000410000ULL, 0x0000001f38387220ULL, 0x080fe20000410000ULL,
0x0000001f39397220ULL, 0x080fe20000410000ULL, 0x0000001f3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001f3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0064ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001f7811ULL, 0x000fe200078ff0ffULL,
0x000119a27f007947ULL, 0x000fea000b800000ULL, 0x00001f1f691f7589ULL, 0x00046400000e0000ULL,
0x0000001f62627220ULL, 0x086fe20000410000ULL, 0x0000001f63637220ULL, 0x080fe20000410000ULL,
0x0000001f26267220ULL, 0x080fe20000410000ULL, 0x0000001f27277220ULL, 0x080fe20000410000ULL,
0x0000001f2a2a7220ULL, 0x080fe20000410000ULL, 0x0000001f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001f32327220ULL, 0x080fe20000410000ULL, 0x0000001f33337220ULL, 0x080fe20000410000ULL,
0x0000001f36367220ULL, 0x080fe20000410000ULL, 0x0000001f37377220ULL, 0x080fe20000410000ULL,
0x0000001f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001f3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000064ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000010001f7811ULL, 0x000fe200078ff0ffULL, 0x000118727f007947ULL, 0x000fea000b800000ULL,
0x00001f1f691f7589ULL, 0x00046400000e0000ULL, 0x0000001f40407220ULL, 0x086fe20000410000ULL,
0x0000001f41417220ULL, 0x080fe20000410000ULL, 0x0000001f44447220ULL, 0x080fe20000410000ULL,
0x0000001f45457220ULL, 0x080fe20000410000ULL, 0x0000001f48487220ULL, 0x080fe20000410000ULL,
0x0000001f49497220ULL, 0x080fe20000410000ULL, 0x0000001f4c4c7220ULL, 0x080fe20000410000ULL,
0x0000001f4d4d7220ULL, 0x080fe20000410000ULL, 0x0000001f50507220ULL, 0x080fe20000410000ULL,
0x0000001f51517220ULL, 0x080fe20000410000ULL, 0x0000001f54547220ULL, 0x080fe20000410000ULL,
0x0000001f55557220ULL, 0x080fe20000410000ULL, 0x0000001f58587220ULL, 0x080fe20000410000ULL,
0x0000001f59597220ULL, 0x080fe20000410000ULL, 0x0000001f5c5c7220ULL, 0x080fe20000410000ULL,
0x0000001f5d5d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000064ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000018001f7811ULL, 0x000fe200078ff0ffULL, 0x000117527f007947ULL, 0x000fea000b800000ULL,
0x00001f1f691f7589ULL, 0x00046400000e0000ULL, 0x0000001f42427220ULL, 0x086fe20000410000ULL,
0x0000001f43437220ULL, 0x080fe20000410000ULL, 0x0000001f46467220ULL, 0x080fe20000410000ULL,
0x0000001f47477220ULL, 0x080fe20000410000ULL, 0x0000001f4a4a7220ULL, 0x080fe20000410000ULL,
0x0000001f4b4b7220ULL, 0x080fe20000410000ULL, 0x0000001f4e4e7220ULL, 0x080fe20000410000ULL,
0x0000001f4f4f7220ULL, 0x080fe20000410000ULL, 0x0000001f52527220ULL, 0x080fe20000410000ULL,
0x0000001f53537220ULL, 0x080fe20000410000ULL, 0x0000001f56567220ULL, 0x080fe20000410000ULL,
0x0000001f57577220ULL, 0x080fe20000410000ULL, 0x0000001f5a5a7220ULL, 0x080fe20000410000ULL,
0x0000001f5b5b7220ULL, 0x080fe20000410000ULL, 0x0000001f5e5e7220ULL, 0x080fe20000410000ULL,
0x0000001f5f5f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x000000641dff7212ULL, 0x000fe400078030ffULL, 0x0000001c651c7209ULL, 0x000fd60007810000ULL,
0x8000001c65650221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b65650820ULL, 0x000fc80000410000ULL,
0x0000006500120308ULL, 0x000e640000000800ULL, 0x0000001267670220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000001e671e7221ULL, 0x008fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000012ff0e723eULL, 0x000fe400000000ffULL, 0x00000002ff1d7819ULL, 0x000fe40000011600ULL,
0x000054100e0e7816ULL, 0x000fe2000000000eULL, 0x000115927f007947ULL, 0x000fea000b800000ULL,
0x00001f1d0e117589ULL, 0x0002a400000e0000ULL, 0x000000081d1f7810ULL, 0x000fe20007ffe0ffULL,
0x000115c27f007947ULL, 0x000fea000b800000ULL, 0x000000101d0f7810ULL, 0x000fe20007ffe0ffULL,
0x00001f1f0e107589ULL, 0x00066a00000e0000ULL, 0x00001f0f0e0f7589ULL, 0x0006a400000e0000ULL,
0x000000181d1f7810ULL, 0x008fe20007ffe0ffULL, 0x000116127f007947ULL, 0x000fea000b800000ULL,
0x00001f1f0e0e7589ULL, 0x0022e400000e0000ULL, 0x000004009a1d7824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000218207824ULL, 0x000fe200078e0215ULL,
0x0000015000007945ULL, 0x000fe40003800000ULL, 0xfffff0001d1f7812ULL, 0x002fe200078ec0ffULL,
0x00002000201d7824ULL, 0x000fc600078e00ffULL, 0x0000c0001f1f7810ULL, 0x000fe40007ffe0ffULL,
0x0000e0001d207810ULL, 0x000fe40007ffe0ffULL, 0x0000001f0d687211ULL, 0x000fe200078e20ffULL,
0x000000100c1f7824ULL, 0x000fe400078e021fULL, 0x000000100a6c7824ULL, 0x100fe400078e0220ULL,
0x000000100b707824ULL, 0x100fe200078e0220ULL, 0x000000006868783bULL, 0x000e620000000200ULL,
0x0000001009747824ULL, 0x000fc600078e0220ULL, 0x000000001f64783bULL, 0x0006a20000000200ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000001168687232ULL, 0x086fe40000000000ULL,
0x000000116a6a7232ULL, 0x000fe40000000000ULL, 0x0000001069697232ULL, 0x080fe40000000000ULL,
0x000000106b6b7232ULL, 0x000fe40000000000ULL, 0x0000000f64647232ULL, 0x080fe40000000000ULL,
0x0000000f66667232ULL, 0x000fc40000000000ULL, 0x0000000e65657232ULL, 0x088fe40000000000ULL,
0x0000000e67677232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001008787824ULL, 0x000fe200078e0220ULL, 0x000000006c6c783bULL, 0x000ee40000004200ULL,
0x00000002ff1f7819ULL, 0x008fe2000001169aULL, 0x0000025000007945ULL, 0x000fe20003800000ULL,
0x000000007070783bULL, 0x000fe40000004200ULL, 0x0000c0001f217811ULL, 0x000fe400078e60ffULL,
0x000000007878783bULL, 0x000ee80000004200ULL, 0x000000007474783bULL, 0x000ea40000004200ULL,
0x0000006c6440723cULL, 0x004f700000001840ULL, 0x000000786838723cULL, 0x04af700000001838ULL,
0x0000007a683c723cULL, 0x000f70000000183cULL, 0x000000786458723cULL, 0x040f700000001858ULL,
0x0000006e6444723cULL, 0x040f700000001844ULL, 0x000000706448723cULL, 0x040f700000001848ULL,
0x00000072644c723cULL, 0x040f70000000184cULL, 0x000000746450723cULL, 0x040f700000001850ULL,
0x000000766454723cULL, 0x040f700000001854ULL, 0x0000007a6478723cULL, 0x000b6e000000185cULL,
0x0000001007647824ULL, 0x120fe200078e0221ULL, 0x0000006c6860723cULL, 0x000b620000001860ULL,
0x0000001006217824ULL, 0x000fc800078e0221ULL, 0x000000006464783bULL, 0x000e640000000200ULL,
0x00000010046c7824ULL, 0x120fe200078e0220ULL, 0x0000006e6824723cULL, 0x040f620000001824ULL,
0x00000000215c783bULL, 0x0004ee0000000200ULL, 0x000000706828723cULL, 0x040b6e0000001828ULL,
0x0000001003707824ULL, 0x120fe200078e0220ULL, 0x00000072682c723cULL, 0x040f70000000182cULL,
0x000000746830723cULL, 0x040f700000001830ULL, 0x000000766834723cULL, 0x000b6e0000001834ULL,
0x0000001005687824ULL, 0x020fe200078e0220ULL, 0x0000008000008947ULL, 0x000fd60003800000ULL,
0x0000001164647232ULL, 0x086fe40000000000ULL, 0x0000001166667232ULL, 0x000fc40000000000ULL,
0x0000001065657232ULL, 0x080fe40000000000ULL, 0x0000001067677232ULL, 0x000fe40000000000ULL,
0x0000000f5c5c7232ULL, 0x088fe40000000000ULL, 0x0000000f5e5e7232ULL, 0x000fe40000000000ULL,
0x0000000e5d5d7232ULL, 0x080fe40000000000ULL, 0x0000000e5f5f7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x006fea0003800000ULL, 0x0000001002747824ULL, 0x000fe200078e0220ULL,
0x000000006868783bULL, 0x000e620000004200ULL, 0x000166981f207811ULL, 0x000fc600078e18ffULL,
0x000000006c6c783bULL, 0x000ea80000004200ULL, 0x000000007070783bULL, 0x000ee80000004200ULL,
0x000000007474783bULL, 0x000ea20000004200ULL, 0x000000685c40723cULL, 0x04ab700000001840ULL,
0x0000006a5c44723cULL, 0x040b700000001844ULL, 0x0000006c5c48723cULL, 0x044b700000001848ULL,
0x0000006e5c4c723cULL, 0x040b70000000184cULL, 0x000000705c50723cULL, 0x040b700000001850ULL,
0x000000725c54723cULL, 0x040b700000001854ULL, 0x000000745c58723cULL, 0x000b700000001858ULL,
0x000000686460723cULL, 0x040b700000001860ULL, 0x0000006a6424723cULL, 0x040b700000001824ULL,
0x0000006c6428723cULL, 0x040b700000001828ULL, 0x0000006e642c723cULL, 0x040b70000000182cULL,
0x000000706430723cULL, 0x040b700000001830ULL, 0x000000726434723cULL, 0x040b700000001834ULL,
0x000000746438723cULL, 0x040b700000001838ULL, 0x00000076643c723cULL, 0x080b70000000183cULL,
0x000000765c5c723cULL, 0x000b620000001878ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000030096967a10ULL, 0x000fe20007ffe0ffULL, 0x0000000020ff7f8cULL, 0x0003e6000c80043fULL,
0x000000239600720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00000c9000000947ULL, 0x000fea0003800000ULL, 0x0000000196647810ULL, 0x062fe20007ffe0ffULL,
0x0000010096657824ULL, 0x000fe400078e0217ULL, 0x000059001a207a24ULL, 0x010fe200078e02ffULL,
0x000000236400720cULL, 0x000fe20003f06070ULL, 0x00000100ff677424ULL, 0x000fe200078e00ffULL,
0x0000006065217812ULL, 0x000fe200078ec0ffULL, 0x0000008020207824ULL, 0x000fc800078e00ffULL,
0x0000000116777824ULL, 0x000fe400078e0221ULL, 0x0000620020207625ULL, 0x000fc800078e0067ULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff727819ULL, 0x100fe40000011600ULL,
0x0000006595647217ULL, 0x000fe40007800000ULL, 0x0000000472687810ULL, 0x040fe40007ffe0ffULL,
0x00000008726a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000164647824ULL, 0x000fe200078e0a65ULL,
0x0000000c72707810ULL, 0x000fe20007ffe0ffULL, 0x0000000168657824ULL, 0x100fe200078e0200ULL,
0x000000006a677210ULL, 0x000fe20007ffe0ffULL, 0x0000000868667824ULL, 0x000fe200078e00ffULL,
0x0000002064737817ULL, 0x000fe20003800000ULL, 0x000000086a6c7824ULL, 0x000fe200078e00ffULL,
0x0000001472767810ULL, 0x000fe20007ffe0ffULL, 0x0000000170697824ULL, 0x000fe200078e0200ULL,
0xfffffff8667b7812ULL, 0x000fe200078ee265ULL, 0x000000809a667824ULL, 0x000fe200078e00ffULL,
0xfffffff86c7d7812ULL, 0x000fe200078ee267ULL, 0x00000008706e7824ULL, 0x000fe200078e00ffULL,
0x000000736800720cULL, 0x080fe20003f86070ULL, 0x0000000172677824ULL, 0x000fe200078e0277ULL,
0x0000008013647812ULL, 0x000fe200078ef866ULL, 0x000000ffff657224ULL, 0x000fe200078e00ffULL,
0xfffffff86e7f7812ULL, 0x000fe200078ee269ULL, 0x0000000168697824ULL, 0x000fe200078e0277ULL,
0x0000001072747810ULL, 0x000fe20007ffe0ffULL, 0x0000010067667825ULL, 0x000fe200078e0064ULL,
0x000000737000720cULL, 0x000fc40003f46070ULL, 0x000000736a00720cULL, 0x080fe20003f66070ULL,
0x0000010069687825ULL, 0x000fe200078e0064ULL, 0x00000066206c7210ULL, 0x000fe40007f1e0ffULL,
0x000000737200720cULL, 0x080fe20003fa6070ULL, 0x00000001766d7824ULL, 0x100fe200078e0200ULL,
0x00000068206e7210ULL, 0x000fe20007f3e0ffULL, 0x00000008767a7824ULL, 0x000fe400078e00ffULL,
0x000020009a667824ULL, 0x000fe400078e00ffULL, 0x0000000172687824ULL, 0x100fe200078e0200ULL,
0xfffffff87a897812ULL, 0x000fe200078ee26dULL, 0x00000001216d7824ULL, 0x040fe200000e0667ULL,
0x0000200066717812ULL, 0x000fe200078ec0ffULL, 0x000000016a677824ULL, 0x000fe200078e0277ULL,
0x0000000768757812ULL, 0x000fe200078ec0ffULL, 0x00000001216f7824ULL, 0x000fe200008e0669ULL,
0x000000737400720cULL, 0x040fe20003f26070ULL, 0x00000001746b7824ULL, 0x140fe200078e0200ULL,
0x0ffffff875757812ULL, 0x000fe200078ef800ULL, 0x0000000874787824ULL, 0x000fc400078e00ffULL,
0x0000000170697824ULL, 0x000fe400078e0277ULL, 0x0000010067667825ULL, 0x000fe200078e0064ULL,
0xfffffff878877812ULL, 0x000fe400078ee26bULL, 0x0000001c72787810ULL, 0x000fe20007ffe0ffULL,
0x0000010069687825ULL, 0x000fe200078e0064ULL, 0x0000006620707210ULL, 0x000fc60007f1e0ffULL,
0x00000001746b7824ULL, 0x000fe200078e0277ULL, 0x0000007118747211ULL, 0x000fe200078e70ffULL,
0x0000000121717824ULL, 0x000fe200000e0667ULL, 0x0000006820687210ULL, 0x000fe20007fde0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0064ULL, 0x0000e00074747810ULL, 0x000fe40007ffe0ffULL,
0x000000737600720cULL, 0x040fe20003f06070ULL, 0x0000000176677824ULL, 0x000fe200078e0277ULL,
0x0000001872767810ULL, 0x000fe20007ffe0ffULL, 0x0000000121697824ULL, 0x000fe200030e0669ULL,
0x0000006a206a7210ULL, 0x000fe20007fde0ffULL, 0x0000010067667825ULL, 0x000fc800078e0064ULL,
0x0000001075797824ULL, 0x100fe400078e0274ULL, 0x000000107b7b7824ULL, 0x000fe400078e0274ULL,
0x00000001216b7824ULL, 0x040fe200030e066bULL, 0x0000006620727210ULL, 0x000fe20007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006c797faeULL, 0x0003e2000e901c48ULL,
0x0000000176757824ULL, 0x140fe200078e0277ULL, 0x000000737600720cULL, 0x080fe20003fa6070ULL,
0x0000000178777824ULL, 0x040fe200078e0277ULL, 0x000000006e7b7faeULL, 0x0005e2000e101c48ULL,
0x000000737800720cULL, 0x000fe20003f86070ULL, 0x0000000121737824ULL, 0x000fc400030e0667ULL,
0x0000010075667825ULL, 0x000fc800078e0064ULL, 0x00000001766c7824ULL, 0x102fe200078e0200ULL,
0x0000006620667210ULL, 0x000fe20007fde0ffULL, 0x00000008766d7824ULL, 0x000fe400078e00ffULL,
0x00000001786e7824ULL, 0x044fe400078e0200ULL, 0x00000008786f7824ULL, 0x000fe200078e00ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee26cULL, 0x0000010077647825ULL, 0x000fc600078e0064ULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee26eULL, 0x0000000121677824ULL, 0x000fe200030e0667ULL,
0x0000006420207210ULL, 0x000fe20007fde0ffULL, 0x000000107d7d7824ULL, 0x100fe200078e0274ULL,
0x000000746d6d7211ULL, 0x000fe200078e20ffULL, 0x000000107f7f7824ULL, 0x100fe400078e0274ULL,
0x0000001087877824ULL, 0x100fe200078e0274ULL, 0x00000000707d7faeULL, 0x0003e2000d901c48ULL,
0x0000001089897824ULL, 0x100fe400078e0274ULL, 0x000000106f6f7824ULL, 0x000fe200078e0274ULL,
0x00000000687f7faeULL, 0x0003e2000d101c48ULL, 0x0000000121217824ULL, 0x000fc600030e0665ULL,
0x000000006a877faeULL, 0x0003e8000c901c48ULL, 0x0000000072897faeULL, 0x0003e8000c101c48ULL,
0x00000000666d7faeULL, 0x0003e8000e901c48ULL, 0x00000000206f7faeULL, 0x0003e2000e101c48ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000400677811ULL, 0x000fe200078fe8ffULL,
0x000000809a727824ULL, 0x000fe200078e00ffULL, 0x0000000800697811ULL, 0x000fc400078fe8ffULL,
0x00000010006d7811ULL, 0x040fe200078fe8ffULL, 0x0000000167647824ULL, 0x140fe200078e0200ULL,
0x00000014006f7811ULL, 0x040fe200078fe8ffULL, 0x00000008676b7824ULL, 0x000fe200078e00ffULL,
0x0000001800717811ULL, 0x040fe200078fe8ffULL, 0x0000000169657824ULL, 0x000fe200078e0200ULL,
0x0000008013727812ULL, 0x000fe200078ef872ULL, 0x0000000869787824ULL, 0x000fe200078e00ffULL,
0xfffffff86b767812ULL, 0x000fe200078ee264ULL, 0x000000086d7c7824ULL, 0x000fe200078e00ffULL,
0x0000000c006b7811ULL, 0x000fe200078fe8ffULL, 0x000000016f667824ULL, 0x100fe200078e0200ULL,
0xfffffff878787812ULL, 0x000fe200078ee265ULL, 0x000000016d657824ULL, 0x000fc400078e0200ULL,
0x000000016b647824ULL, 0x140fe400078e0200ULL, 0x000000086b737824ULL, 0x000fe200078e00ffULL,
0xfffffff87c7c7812ULL, 0x000fe200078ee265ULL, 0x000000086f757824ULL, 0x000fe200078e00ffULL,
0x0000000000657211ULL, 0x000fe200078fe8ffULL, 0x0000000171687824ULL, 0x000fe200078e0200ULL,
0xfffffff8737a7812ULL, 0x000fe200078ee264ULL, 0x0000000871797824ULL, 0x000fe200078e00ffULL,
0xfffffff8757e7812ULL, 0x000fe200078ee266ULL, 0x000020009a647824ULL, 0x000fe200078e00ffULL,
0x0000001c00757811ULL, 0x000fe200078fe8ffULL, 0x0000000167677824ULL, 0x100fe200078e0277ULL,
0x0000000765737812ULL, 0x000fe200078ec0ffULL, 0x0000000169697824ULL, 0x100fe200078e0277ULL,
0xfffffff879887812ULL, 0x000fe200078ee268ULL, 0x00000008757b7824ULL, 0x040fe200078e00ffULL,
0x0000200064797812ULL, 0x000fe200078ec0ffULL, 0x0000000175647824ULL, 0x100fe200078e0200ULL,
0x0000007700657211ULL, 0x080fe200078fe8ffULL, 0x000000016d6d7824ULL, 0x000fe200078e0277ULL,
0x0ffffff873747812ULL, 0x000fe200078ef800ULL, 0x000000ffff737224ULL, 0x000fe200078e00ffULL,
0x000000776b6b7210ULL, 0x000fe20007ffe0ffULL, 0x0000400018797824ULL, 0x000fe200078e0279ULL,
0xfffffff87b8a7812ULL, 0x000fe200078ee264ULL, 0x0000010065647825ULL, 0x000fc600078e0072ULL,
0x0000e00079797810ULL, 0x000fe20007ffe0ffULL, 0x0000010067667825ULL, 0x000fe200078e0072ULL,
0x0000006420647210ULL, 0x000fc60007f1e0ffULL, 0x000000016f6f7824ULL, 0x000fe200078e0277ULL,
0x0000006620667210ULL, 0x000fe20007f3e0ffULL, 0x0000010069687825ULL, 0x000fc800078e0072ULL,
0x000001006b6a7825ULL, 0x000fe200078e0072ULL, 0x0000006820687210ULL, 0x000fc60007f5e0ffULL,
0x0000000171717824ULL, 0x100fe200078e0277ULL, 0x0000006a206a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000175757824ULL, 0x000fe200078e0277ULL, 0x0000006921697210ULL, 0x000fe200017fe4ffULL,
0x000001006d6c7825ULL, 0x000fc800078e0072ULL, 0x000001006f6e7825ULL, 0x000fc800078e0072ULL,
0x0000010071707825ULL, 0x000fc800078e0072ULL, 0x0000010075727825ULL, 0x000fe200078e0072ULL,
0x0000007020707210ULL, 0x000fc60007f5e0ffULL, 0x0000000121657824ULL, 0x040fe200000e0665ULL,
0x0000006c206c7210ULL, 0x040fe20007f1e0ffULL, 0x0000000121677824ULL, 0x040fe200008e0667ULL,
0x0000006e206e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001074757824ULL, 0x100fe400078e0279ULL,
0x0000001076777824ULL, 0x000fe400078e0279ULL, 0x00000001216b7824ULL, 0x000fe200018e066bULL,
0x0000007220207210ULL, 0x000fe20007f7e0ffULL, 0x00000010787b7824ULL, 0x100fe200078e0279ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000064757faeULL, 0x0003e2000b901c48ULL,
0x000000107a7d7824ULL, 0x000fc400078e0279ULL, 0x000000107c7f7824ULL, 0x000fe200078e0279ULL,
0x0000000066777faeULL, 0x0003e2000b901c48ULL, 0x00000001216d7824ULL, 0x040fe400000e066dULL,
0x000000107e877824ULL, 0x000fe200078e0279ULL, 0x00000000687b7faeULL, 0x0003e2000b901c48ULL,
0x00000001216f7824ULL, 0x040fe400008e066fULL, 0x0000001088897824ULL, 0x000fe200078e0279ULL,
0x000000006a7d7faeULL, 0x0003e2000b901c48ULL, 0x0000000121717824ULL, 0x000fc400010e0671ULL,
0x000000108a797824ULL, 0x000fe200078e0279ULL, 0x000000006c7f7faeULL, 0x0003e2000b901c48ULL,
0x0000000121217824ULL, 0x000fc600018e0673ULL, 0x000000006e877faeULL, 0x0003e8000b901c48ULL,
0x0000000070897faeULL, 0x0003e8000b901c48ULL, 0x0000000020797faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x002e220000000000ULL, 0x0000001019207812ULL, 0x040fe400078ec0ffULL,
0x0000000819217812ULL, 0x000fc600078ec0ffULL, 0x000000201f207824ULL, 0x000fc800078e0220ULL,
0x0000000121687824ULL, 0x020fe200078e0220ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0166680068667f8cULL, 0x0002a4000c80043fULL, 0x0000000000207805ULL, 0x000fc40000015200ULL,
0x01666c00681f7984ULL, 0x000ee40000000800ULL, 0x800000001fff7812ULL, 0x00cfe40007804867ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff697224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000647805ULL, 0x000fcc0000015200ULL, 0x0000006420647210ULL, 0x000fca0007f1e1ffULL,
0x0000000165657824ULL, 0x000fe200000e0e21ULL, 0x003d09006400780cULL, 0x000fc80003f06070ULL,
0x000000ff6500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406400780cULL, 0x000fc80003f06070ULL, 0x000000ff6500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1f7819ULL, 0x000fc80000011465ULL,
0x000000641f1f7211ULL, 0x000fca00078110ffULL, 0x000000ffff647224ULL, 0x000fca00000e0665ULL,
0x000000021f1f7819ULL, 0x000fc80000001264ULL, 0x0000001f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000169697810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01666c00681f7984ULL, 0x000ea40000000800ULL,
0x800000001fff7812ULL, 0x004fe40007804867ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000039a207811ULL, 0x000fca00078ff0ffULL, 0x00000080201f7824ULL, 0x000fc800078e0213ULL,
0x00000001221f7824ULL, 0x000fca00078e021fULL, 0x016000001f657984ULL, 0x000ea80000000800ULL,
0x016200001f677984ULL, 0x0006620000000800ULL, 0x0000001c6500720bULL, 0x004fe20003f1d000ULL,
0x000100527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000647806ULL, 0x008fc800000e0100ULL,
0x000000ff6400720cULL, 0x000fe20003f25270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x000000039a1f7811ULL, 0x000fe400078ff0ffULL, 0x0000001c6500720bULL, 0x000fe40003f34000ULL,
0x0000009a1f00720cULL, 0x000fe20003f05270ULL, 0x000100127f007947ULL, 0x000fd4000b800000ULL,
0x0000000000697806ULL, 0x000fc400008e0100ULL, 0x000000809a1f8824ULL, 0x000fe200078e0213ULL,
0x0000001c65138209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000122228824ULL, 0x000fca00078e021fULL, 0x0164001322008388ULL, 0x0005e20000000800ULL,
0x000000ff6900720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000001c65137209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff69ff7812ULL, 0x000fc6000780c0ffULL, 0x0000001c13137221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b13137820ULL, 0x000fcc0000410000ULL, 0x0000001300137308ULL, 0x000ea40000000800ULL,
0x000000131e1e7220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff1f7819ULL, 0x000fe20000011600ULL, 0x0000ff427f007947ULL, 0x000fea000b800000ULL,
0x00001f1f131f7589ULL, 0x0004e400000e0000ULL, 0x0000001f60607220ULL, 0x08cfe20000410000ULL,
0x0000001f61617220ULL, 0x080fe20000410000ULL, 0x0000001f24247220ULL, 0x080fe20000410000ULL,
0x0000001f25257220ULL, 0x080fe20000410000ULL, 0x0000001f28287220ULL, 0x080fe20000410000ULL,
0x0000001f29297220ULL, 0x080fe20000410000ULL, 0x0000001f2c2c7220ULL, 0x080fe20000410000ULL,
0x0000001f2d2d7220ULL, 0x080fe20000410000ULL, 0x0000001f30307220ULL, 0x080fe20000410000ULL,
0x0000001f31317220ULL, 0x080fe20000410000ULL, 0x0000001f34347220ULL, 0x080fe20000410000ULL,
0x0000001f35357220ULL, 0x080fe20000410000ULL, 0x0000001f38387220ULL, 0x080fe20000410000ULL,
0x0000001f39397220ULL, 0x080fe20000410000ULL, 0x0000001f3c3c7220ULL, 0x080fe20000410000ULL,
0x0000001f3d3d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0069ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008001f7811ULL, 0x000fe200078ff0ffULL,
0x0000fe127f007947ULL, 0x000fea000b800000ULL, 0x00001f1f131f7589ULL, 0x0004e400000e0000ULL,
0x0000001f62627220ULL, 0x08cfe20000410000ULL, 0x0000001f63637220ULL, 0x080fe20000410000ULL,
0x0000001f26267220ULL, 0x080fe20000410000ULL, 0x0000001f27277220ULL, 0x080fe20000410000ULL,
0x0000001f2a2a7220ULL, 0x080fe20000410000ULL, 0x0000001f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001f32327220ULL, 0x080fe20000410000ULL, 0x0000001f33337220ULL, 0x080fe20000410000ULL,
0x0000001f36367220ULL, 0x080fe20000410000ULL, 0x0000001f37377220ULL, 0x080fe20000410000ULL,
0x0000001f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001f3f3f7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000069ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000010001f7811ULL, 0x000fe200078ff0ffULL, 0x0000fce27f007947ULL, 0x000fea000b800000ULL,
0x00001f1f131f7589ULL, 0x0004e400000e0000ULL, 0x0000001f40407220ULL, 0x08cfe20000410000ULL,
0x0000001f41417220ULL, 0x080fe20000410000ULL, 0x0000001f44447220ULL, 0x080fe20000410000ULL,
0x0000001f45457220ULL, 0x080fe20000410000ULL, 0x0000001f48487220ULL, 0x080fe20000410000ULL,
0x0000001f49497220ULL, 0x080fe20000410000ULL, 0x0000001f4c4c7220ULL, 0x080fe20000410000ULL,
0x0000001f4d4d7220ULL, 0x080fe20000410000ULL, 0x0000001f50507220ULL, 0x080fe20000410000ULL,
0x0000001f51517220ULL, 0x080fe20000410000ULL, 0x0000001f54547220ULL, 0x080fe20000410000ULL,
0x0000001f55557220ULL, 0x080fe20000410000ULL, 0x0000001f58587220ULL, 0x080fe20000410000ULL,
0x0000001f59597220ULL, 0x080fe20000410000ULL, 0x0000001f5c5c7220ULL, 0x080fe20000410000ULL,
0x0000001f5d5d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000069ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000018001f7811ULL, 0x000fe200078ff0ffULL, 0x0000fbc27f007947ULL, 0x000fea000b800000ULL,
0x00001f1f131f7589ULL, 0x0004e400000e0000ULL, 0x0000001f42427220ULL, 0x08cfe20000410000ULL,
0x0000001f43437220ULL, 0x080fe20000410000ULL, 0x0000001f46467220ULL, 0x080fe20000410000ULL,
0x0000001f47477220ULL, 0x080fe20000410000ULL, 0x0000001f4a4a7220ULL, 0x080fe20000410000ULL,
0x0000001f4b4b7220ULL, 0x080fe20000410000ULL, 0x0000001f4e4e7220ULL, 0x080fe20000410000ULL,
0x0000001f4f4f7220ULL, 0x080fe20000410000ULL, 0x0000001f52527220ULL, 0x080fe20000410000ULL,
0x0000001f53537220ULL, 0x080fe20000410000ULL, 0x0000001f56567220ULL, 0x080fe20000410000ULL,
0x0000001f57577220ULL, 0x080fe20000410000ULL, 0x0000001f5a5a7220ULL, 0x080fe20000410000ULL,
0x0000001f5b5b7220ULL, 0x080fe20000410000ULL, 0x0000001f5e5e7220ULL, 0x080fe20000410000ULL,
0x0000001f5f5f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000006964ff7212ULL, 0x000fe400078030ffULL, 0x0000001c651c7209ULL, 0x000fd60007810000ULL,
0x8000001c65650221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b65650820ULL, 0x000fc80000410000ULL,
0x0000006500120308ULL, 0x000ea40000000800ULL, 0x0000001267670220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000001e671e7221ULL, 0x002fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000012ff0e723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe40000011600ULL,
0x000054100e0e7816ULL, 0x000fe2000000000eULL, 0x0000fa027f007947ULL, 0x000fea000b800000ULL,
0x00001f130e117589ULL, 0x0002a400000e0000ULL, 0x00000008131f7810ULL, 0x000fe20007ffe0ffULL,
0x0000fa327f007947ULL, 0x000fea000b800000ULL, 0x00000010130f7810ULL, 0x000fe20007ffe0ffULL,
0x00001f1f0e107589ULL, 0x00066a00000e0000ULL, 0x00001f0f0e0f7589ULL, 0x0006a400000e0000ULL,
0x00000018131f7810ULL, 0x008fe20007ffe0ffULL, 0x0000fa827f007947ULL, 0x000fea000b800000ULL,
0x00001f1f0e0e7589ULL, 0x0022e400000e0000ULL, 0x000000039a137811ULL, 0x000fe200078ff0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000f0001d1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0x0000a00013137811ULL, 0x000fc600078e60ffULL,
0x000000100a707824ULL, 0x000fe400078e021dULL, 0x000000100d0d7824ULL, 0x100fe400078e0213ULL,
0x000000100c0c7824ULL, 0x000fe400078e0213ULL, 0x000000100b6c7824ULL, 0x100fe200078e021dULL,
0x000000000d74783bULL, 0x0002e20000000200ULL, 0x0000001009687824ULL, 0x000fc600078e021dULL,
0x000000000c64783bULL, 0x0002a20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000001174747232ULL, 0x08cfe40000000000ULL, 0x0000001176767232ULL, 0x000fe40000000000ULL,
0x0000001075757232ULL, 0x080fe40000000000ULL, 0x0000001077777232ULL, 0x000fe40000000000ULL,
0x0000000f64647232ULL, 0x080fe40000000000ULL, 0x0000000f66667232ULL, 0x000fc40000000000ULL,
0x0000000e65657232ULL, 0x080fe40000000000ULL, 0x0000000e67677232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001008087824ULL, 0x000fe200078e021dULL,
0x000000007070783bULL, 0x000e620000004200ULL, 0x0000001006067824ULL, 0x000fe200078e0213ULL,
0x0000001d050c7211ULL, 0x002fe200078e20ffULL, 0x00000010040d7824ULL, 0x100fe200078e021dULL,
0x000000006c6c783bULL, 0x000fe20000004200ULL, 0x0000021000007945ULL, 0x000fe20003800000ULL,
0x0000001003037824ULL, 0x000fe400078e021dULL, 0x000000000808783bULL, 0x000e680000004200ULL,
0x000000006868783bULL, 0x000ee40000004200ULL, 0x000000707460723cULL, 0x048f700000001860ULL,
0x000000087438723cULL, 0x082f700000001838ULL, 0x000000086458723cULL, 0x004b6e0000001858ULL,
0x0000001007087824ULL, 0x020fe200078e0213ULL, 0x0000000a743c723cULL, 0x080f62000000183cULL,
0x000000000604783bULL, 0x000e6e0000000200ULL, 0x0000000a645c723cULL, 0x000b64000000185cULL,
0x000000000808783bULL, 0x020eac0000000200ULL, 0x000000727424723cULL, 0x040b700000001824ULL,
0x0000006c7428723cULL, 0x040b700000001828ULL, 0x0000006e742c723cULL, 0x040b70000000182cULL,
0x000000687430723cULL, 0x040b700000001830ULL, 0x0000006a7434723cULL, 0x000b700000001834ULL,
0x000000706440723cULL, 0x040b700000001840ULL, 0x000000726444723cULL, 0x040b700000001844ULL,
0x0000006c6448723cULL, 0x040b700000001848ULL, 0x0000006e644c723cULL, 0x040b70000000184cULL,
0x000000686450723cULL, 0x040b700000001850ULL, 0x0000006a6454723cULL, 0x000b620000001854ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000008000008947ULL, 0x000fde0003800000ULL,
0x0000001108087232ULL, 0x086fe40000000000ULL, 0x000000110a0a7232ULL, 0x000fc40000000000ULL,
0x0000001009097232ULL, 0x080fe40000000000ULL, 0x000000100b0b7232ULL, 0x000fe40000000000ULL,
0x0000000f04047232ULL, 0x080fe40000000000ULL, 0x0000000f06067232ULL, 0x000fe40000000000ULL,
0x0000000e05057232ULL, 0x080fe40000000000ULL, 0x0000000e07077232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x006fea0003800000ULL, 0x0000001002027824ULL, 0x000fe200078e021dULL,
0x000000000c64783bULL, 0x020e680000004200ULL, 0x000000000d68783bULL, 0x000ea80000004200ULL,
0x00000000036c783bULL, 0x000ee80000004200ULL, 0x000000000270783bULL, 0x0002a40000004200ULL,
0x00000002ff027819ULL, 0x002fc8000001169aULL, 0x000166a002027811ULL, 0x000fe200078e18ffULL,
0x000000640860723cULL, 0x040b700000001860ULL, 0x000000660824723cULL, 0x040b700000001824ULL,
0x000000680828723cULL, 0x044b700000001828ULL, 0x0000006a082c723cULL, 0x040b70000000182cULL,
0x0000006c0830723cULL, 0x048b700000001830ULL, 0x0000006e0834723cULL, 0x040b700000001834ULL,
0x000000700838723cULL, 0x040b700000001838ULL, 0x00000072083c723cULL, 0x000b70000000183cULL,
0x000000640440723cULL, 0x040b700000001840ULL, 0x000000660444723cULL, 0x040b700000001844ULL,
0x000000680448723cULL, 0x040b700000001848ULL, 0x0000006a044c723cULL, 0x040b70000000184cULL,
0x0000006c0450723cULL, 0x040b700000001850ULL, 0x0000006e0454723cULL, 0x040b700000001854ULL,
0x000000700458723cULL, 0x040b700000001858ULL, 0x00000072045c723cULL, 0x000b62000000185cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000239600720cULL, 0x000fe20003f06070ULL,
0x0000000002ff7f8cULL, 0x0003d8000c80043fULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff813000007947ULL, 0x000fea000383ffffULL, 0x0000000000047919ULL, 0x020e640000002500ULL,
0x000000230400720cULL, 0x002fda0003f06070ULL, 0x0000057000000947ULL, 0x000fea0003800000ULL,
0x018000001e007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x000fe200078e001eULL,
0x00009c0000067802ULL, 0x000fc40000000f00ULL, 0x0000f71000007944ULL, 0x010fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001e00037308ULL, 0x000e640000001000ULL,
0xbf80000003007423ULL, 0x002fc8000000001eULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000001003057811ULL, 0x046fe400078ff0ffULL,
0x00000002ff077819ULL, 0x000fe40000011603ULL, 0x00000018030b7811ULL, 0x040fe400078ff0ffULL,
0x0000000803097811ULL, 0x000fe200078ff0ffULL, 0x00001f0700027589ULL, 0x008e6800000e0000ULL,
0x00001f0b00067589ULL, 0x000ea800000e0000ULL, 0x00001f0900037589ULL, 0x000ee800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000006002607220ULL, 0x042fe20000410000ULL,
0x0000006102617220ULL, 0x040fe20000410000ULL, 0x0000002402247220ULL, 0x040fe20000410000ULL,
0x0000002502257220ULL, 0x040fe20000410000ULL, 0x0000002802287220ULL, 0x040fe20000410000ULL,
0x0000002902297220ULL, 0x040fe20000410000ULL, 0x0000002c022c7220ULL, 0x040fe20000410000ULL,
0x0000002d022d7220ULL, 0x040fe20000410000ULL, 0x0000003002307220ULL, 0x040fe20000410000ULL,
0x0000003102317220ULL, 0x040fe20000410000ULL, 0x0000003402347220ULL, 0x040fe20000410000ULL,
0x0000003502357220ULL, 0x040fe20000410000ULL, 0x0000003802387220ULL, 0x040fe20000410000ULL,
0x0000003902397220ULL, 0x040fe20000410000ULL, 0x0000003c023c7220ULL, 0x040fe20000410000ULL,
0x0000003d023d7220ULL, 0x000fe20000410000ULL, 0x0000004206427220ULL, 0x044fe20000410000ULL,
0x0000004306437220ULL, 0x040fe20000410000ULL, 0x0000004606467220ULL, 0x040fe20000410000ULL,
0x0000004706477220ULL, 0x040fe20000410000ULL, 0x0000004a064a7220ULL, 0x040fe20000410000ULL,
0x0000004b064b7220ULL, 0x040fe20000410000ULL, 0x0000004e064e7220ULL, 0x040fe20000410000ULL,
0x0000004f064f7220ULL, 0x040fe20000410000ULL, 0x0000005206527220ULL, 0x040fe20000410000ULL,
0x0000005306537220ULL, 0x040fe20000410000ULL, 0x0000005606567220ULL, 0x040fe20000410000ULL,
0x0000005706577220ULL, 0x040fe20000410000ULL, 0x0000005a065a7220ULL, 0x040fe20000410000ULL,
0x0000005b065b7220ULL, 0x040fe20000410000ULL, 0x0000005e065e7220ULL, 0x040fe20000410000ULL,
0x0000005f065f7220ULL, 0x000fe20000410000ULL, 0x0000000362627220ULL, 0x088fe20000410000ULL,
0x0000000363637220ULL, 0x080fe20000410000ULL, 0x0000000326267220ULL, 0x080fe20000410000ULL,
0x0000000327277220ULL, 0x080fe20000410000ULL, 0x000000032a2a7220ULL, 0x080fe20000410000ULL,
0x000000032b2b7220ULL, 0x080fe20000410000ULL, 0x000000032e2e7220ULL, 0x080fe20000410000ULL,
0x000000032f2f7220ULL, 0x080fe20000410000ULL, 0x0000000332327220ULL, 0x080fe20000410000ULL,
0x0000000333337220ULL, 0x080fe20000410000ULL, 0x0000000336367220ULL, 0x080fe20000410000ULL,
0x0000000337377220ULL, 0x080fe20000410000ULL, 0x000000033a3a7220ULL, 0x080fe20000410000ULL,
0x000000033b3b7220ULL, 0x080fe20000410000ULL, 0x000000033e3e7220ULL, 0x080fe20000410000ULL,
0x000000033f3f7220ULL, 0x000fe20000410000ULL, 0x0000000540407220ULL, 0x080fe20000410000ULL,
0x0000000541417220ULL, 0x080fe20000410000ULL, 0x0000000544447220ULL, 0x080fe20000410000ULL,
0x0000000545457220ULL, 0x080fe20000410000ULL, 0x0000000548487220ULL, 0x080fe20000410000ULL,
0x0000000549497220ULL, 0x080fe20000410000ULL, 0x000000054c4c7220ULL, 0x080fe20000410000ULL,
0x000000054d4d7220ULL, 0x080fe20000410000ULL, 0x0000000550507220ULL, 0x080fe20000410000ULL,
0x0000000551517220ULL, 0x080fe20000410000ULL, 0x0000000554547220ULL, 0x080fe20000410000ULL,
0x0000000555557220ULL, 0x080fe20000410000ULL, 0x0000000558587220ULL, 0x080fe20000410000ULL,
0x0000000559597220ULL, 0x080fe20000410000ULL, 0x000000055c5c7220ULL, 0x080fe20000410000ULL,
0x000000055d5d7220ULL, 0x000fc20000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000262726723eULL, 0x000fc400000000ffULL, 0x000000242506723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000282907723eULL, 0x000fe400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x000000606105723eULL, 0x000fc400000000ffULL,
0x0000002c2d09723eULL, 0x000fe400000000ffULL, 0x00000030310a723eULL, 0x000fe400000000ffULL,
0x00000034350b723eULL, 0x000fe400000000ffULL, 0x00000038390c723eULL, 0x000fe400000000ffULL,
0x00000002ff1a7819ULL, 0x012fe40000011600ULL, 0x0000000800297811ULL, 0x000fc400078ff0ffULL,
0x000000021a037810ULL, 0x040fe20007ffe0ffULL, 0x000000081a207824ULL, 0x040fe200078e00ffULL,
0x000000031a087810ULL, 0x040fe20007ffe0ffULL, 0x000000081a1f7824ULL, 0x040fe200078e00ffULL,
0x000000041a197810ULL, 0x040fe20007ffe0ffULL, 0x000000081a227824ULL, 0x040fe200078e00ffULL,
0x000000011a027810ULL, 0x040fe20007ffe0ffULL, 0x000000081a1b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8201d7812ULL, 0x000fe200078ee203ULL, 0x000000081a277824ULL, 0x040fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee208ULL, 0x000000081a237824ULL, 0x040fe200078e00ffULL,
0x000000061a037810ULL, 0x000fc40007ffe0ffULL, 0xffffffff1a087810ULL, 0x000fe40007ffe0ffULL,
0xfffffff822217812ULL, 0x000fe200078ee219ULL, 0x000000081a197824ULL, 0x040fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee202ULL, 0x0000000829227824ULL, 0x000fe200078e00ffULL,
0x000000051a027810ULL, 0x000fe40007ffe0ffULL, 0xfffffff820257812ULL, 0x000fe200078ee203ULL,
0x0000200015037824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee208ULL,
0x0000100018087824ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee21aULL,
0x00000004001a7824ULL, 0x040fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee202ULL,
0x0000000103027824ULL, 0x000fe200078e0208ULL, 0x00000010002b7811ULL, 0x000fc400078ff0ffULL,
0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0202ULL,
0x0000000219197211ULL, 0x000fe200078e20ffULL, 0x000000082b207824ULL, 0x000fe200078e00ffULL,
0xfffffff822297812ULL, 0x000fe200078ee229ULL, 0x000000101d1d7824ULL, 0x100fe200078e0202ULL,
0x00000018002d7811ULL, 0x000fe200078ff0ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0202ULL,
0xfffffff8202b7812ULL, 0x000fe200078ee22bULL, 0x0000001021217824ULL, 0x000fe200078e0202ULL,
0x0000003c3d0d723eULL, 0x000fe200000000ffULL, 0x0000000119207824ULL, 0x000fe200078e021aULL,
0x000000626362723eULL, 0x000fe200000000ffULL, 0x0000001023237824ULL, 0x100fe200078e0202ULL,
0x0000002e2f2e723eULL, 0x000fe200000000ffULL, 0x000000011a1b7824ULL, 0x040fe200078e021bULL,
0x0000000520007388ULL, 0x000fe20000000800ULL, 0x0000001025257824ULL, 0x100fe200078e0202ULL,
0x000000323332723eULL, 0x000fe200000000ffULL, 0x0000001027277824ULL, 0x100fe200078e0202ULL,
0x000000061b007388ULL, 0x000fe20000000800ULL, 0x000000011a1d7824ULL, 0x040fe200078e021dULL,
0x000000363736723eULL, 0x000fe200000000ffULL, 0x000000011a1f7824ULL, 0x040fe200078e021fULL,
0x000000271a277210ULL, 0x040fe20007ffe0ffULL, 0x0000001029297824ULL, 0x100fe200078e0202ULL,
0x000000071d007388ULL, 0x000fe20000000800ULL, 0x000000011a217824ULL, 0x040fe200078e0221ULL,
0x0000003a3b3a723eULL, 0x000fe200000000ffULL, 0x000000011a237824ULL, 0x040fe200078e0223ULL,
0x000000091f007388ULL, 0x000fe20000000800ULL, 0x000000011a257824ULL, 0x040fe200078e0225ULL,
0x0000003e3f3e723eULL, 0x000fe200000000ffULL, 0x000000011a297824ULL, 0x000fe200078e0229ULL,
0x0000000a21007388ULL, 0x0003e20000000800ULL, 0x000000082d227824ULL, 0x000fe200078e00ffULL,
0x000000404140723eULL, 0x000fe200000000ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0202ULL,
0x0000000b23007388ULL, 0x000fe20000000800ULL, 0x000000444544723eULL, 0x000fc400000000ffULL,
0xfffffff8222d7812ULL, 0x000fe200078ee22dULL, 0x0000000c25007388ULL, 0x000fe20000000800ULL,
0x000000011a2b7824ULL, 0x040fe200078e022bULL, 0x000000484948723eULL, 0x000fe200000000ffULL,
0x00000001170a7824ULL, 0x002fe200078e0200ULL, 0x0000000d27007388ULL, 0x000fe20000000800ULL,
0x0000004c4d4c723eULL, 0x000fe200000000ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0202ULL,
0x000000505150723eULL, 0x000fe200000000ffULL, 0x0000006229007388ULL, 0x000fe20000000800ULL,
0x000000545554723eULL, 0x000fe200000000ffULL, 0x000000011a2d7824ULL, 0x000fe200078e022dULL,
0x000000585958723eULL, 0x000fe200000000ffULL, 0x000400261b007388ULL, 0x000fe20000000800ULL,
0x0000005c5d5c723eULL, 0x000fe200000000ffULL, 0x000000100a067824ULL, 0x000fe200078e0203ULL,
0x00000042430e723eULL, 0x000fe200000000ffULL, 0x0004002a1d007388ULL, 0x000fe20000000800ULL,
0x00000046470f723eULL, 0x000fc400000000ffULL, 0x0000004a4b10723eULL, 0x000fe200000000ffULL,
0x0004002e1f007388ULL, 0x000fe20000000800ULL, 0x0000004e4f11723eULL, 0x000fe400000000ffULL,
0x000000525312723eULL, 0x000fe200000000ffULL, 0x0004003221007388ULL, 0x000fe20000000800ULL,
0x000000565713723eULL, 0x000fe400000000ffULL, 0x0000005a5b14723eULL, 0x000fe200000000ffULL,
0x0004003623007388ULL, 0x000fe20000000800ULL, 0x0000005e5f16723eULL, 0x000fc600000000ffULL,
0x0004003a25007388ULL, 0x000fe80000000800ULL, 0x0004003e27007388ULL, 0x000fe80000000800ULL,
0x000000402b007388ULL, 0x000fe80000000800ULL, 0x000800441b007388ULL, 0x000fe80000000800ULL,
0x000800481d007388ULL, 0x000fe80000000800ULL, 0x0008004c1f007388ULL, 0x000fe80000000800ULL,
0x0008005021007388ULL, 0x000fe80000000800ULL, 0x0008005423007388ULL, 0x000fe80000000800ULL,
0x0008005825007388ULL, 0x000fe80000000800ULL, 0x0008005c27007388ULL, 0x000fe80000000800ULL,
0x0000000e2d007388ULL, 0x000fe80000000800ULL, 0x000c000f1b007388ULL, 0x000fe80000000800ULL,
0x000c00101d007388ULL, 0x0003e80000000800ULL, 0x000c00111f007388ULL, 0x000fe80000000800ULL,
0x000c001221007388ULL, 0x000fe20000000800ULL, 0x00000300ff1d7624ULL, 0x002fc600078e00ffULL,
0x000c001323007388ULL, 0x000fe40000000800ULL, 0x000000011d00780cULL, 0x000fe40003f05270ULL,
0x000c001425007388ULL, 0x000fe80000000800ULL, 0x000c001627007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000006287984ULL, 0x000e680000000c00ULL,
0x00040000062c7984ULL, 0x000ea80000000c00ULL, 0x0008000006347984ULL, 0x000ee80000000c00ULL,
0x000c000006107984ULL, 0x000ee80000000c00ULL, 0x00100000060c7984ULL, 0x000ee80000000c00ULL,
0x0014000006307984ULL, 0x000ee80000000c00ULL, 0x0018000006387984ULL, 0x000ee80000000c00ULL,
0x001c000006207984ULL, 0x000ee20000000c00ULL, 0x200000ff2b2b7230ULL, 0x002fc40000000000ULL,
0x200000ff2a2a7230ULL, 0x000fe40000000000ULL, 0x200000ff29297230ULL, 0x000fe40000000000ULL,
0x200000ff28287230ULL, 0x000fe40000000000ULL, 0x200000ff2f2f7230ULL, 0x004fe40000000000ULL,
0x200000ff2e2e7230ULL, 0x000fe40000000000ULL, 0x200000ff2d2d7230ULL, 0x000fc40000000000ULL,
0x200000ff2c2c7230ULL, 0x000fe40000000000ULL, 0x200000ff37377230ULL, 0x008fe40000000000ULL,
0x200000ff36367230ULL, 0x000fe40000000000ULL, 0x200000ff35357230ULL, 0x000fe40000000000ULL,
0x200000ff34347230ULL, 0x000fe40000000000ULL, 0x200000ff13137230ULL, 0x000fc40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fe40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x0000000f2b2b7230ULL, 0x000fe40000000000ULL,
0x0000000e2a2a7230ULL, 0x000fe40000000000ULL, 0x0000000d29297230ULL, 0x000fc40000000000ULL,
0x0000000c28287230ULL, 0x000fe40000000000ULL, 0x000000332f2f7230ULL, 0x000fe40000000000ULL,
0x000000322e2e7230ULL, 0x000fe20000000000ULL, 0x0000002806007388ULL, 0x000fe20000000c00ULL,
0x000000312d2d7230ULL, 0x000fe40000000000ULL, 0x000000302c2c7230ULL, 0x000fe40000000000ULL,
0x0000003b37377230ULL, 0x000fc40000000000ULL, 0x0000003a36367230ULL, 0x000fe20000000000ULL,
0x0004002c06007388ULL, 0x000fe20000000c00ULL, 0x0000003935357230ULL, 0x000fe40000000000ULL,
0x0000003834347230ULL, 0x000fe40000000000ULL, 0x0000002313137230ULL, 0x000fe40000000000ULL,
0x0000002212127230ULL, 0x000fe20000000000ULL, 0x0008003406007388ULL, 0x000fe20000000c00ULL,
0x0000002111117230ULL, 0x000fc40000000000ULL, 0x0000002010107230ULL, 0x000fca0000000000ULL,
0x000c001006007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000397000008947ULL, 0x000fea0003800000ULL, 0x00000400ff057624ULL, 0x000fe200078e00ffULL,
0x0000000000097919ULL, 0x000e620000002600ULL, 0x000000400a0d7810ULL, 0x000fc40007ffe0ffULL,
0x00006a0005057a24ULL, 0x000fe200078e02ffULL, 0x00000000000c7919ULL, 0x000e620000002700ULL,
0x000000800a0f7810ULL, 0x040fe40007ffe0ffULL, 0x000000c00a117810ULL, 0x000fe20007ffe0ffULL,
0x0000000006207984ULL, 0x0004e20000000c00ULL, 0x0000000f05077811ULL, 0x040fe200078e10ffULL,
0x0000030005057a24ULL, 0x000fe400078e02ffULL, 0x0004000006247984ULL, 0x0004a20000000c00ULL,
0xfffffff007147812ULL, 0x000fc600078ec0ffULL, 0x0008000006287984ULL, 0x0002a40000000c00ULL,
0x0000008005167824ULL, 0x040fe400078e0214ULL, 0x000c0000062c7984ULL, 0x0002a40000000c00ULL,
0x0000008005057824ULL, 0x000fca00078e0216ULL, 0x0000007f05057810ULL, 0x000fe20007ffe0ffULL,
0x000004000c097a24ULL, 0x002fc600078e0209ULL, 0xffffff8005197812ULL, 0x000fe200078ec0ffULL,
0x0000030009077a24ULL, 0x000fc600078e02ffULL, 0x00006e0019057a10ULL, 0x000fe20007f1e0ffULL,
0x0000000107107824ULL, 0x000fca00078e0204ULL, 0x0000000510047211ULL, 0x000fe200078268ffULL,
0x00006f00ff057624ULL, 0x000fe200000e06ffULL, 0x0000000118ff7812ULL, 0x000fc8000780f89aULL,
0x0000000510057211ULL, 0x000fe400008f6cffULL, 0x00006e00141a7a10ULL, 0x000fc60007f3e0ffULL,
0x0000100015047825ULL, 0x000fc800078e0004ULL, 0x00006f00ff1b7624ULL, 0x000fe400008e06ffULL,
0x000000100a0a7825ULL, 0x000fc800078e0004ULL, 0x000000100d0c7825ULL, 0x000fc800078e0004ULL,
0x000000100f0e7825ULL, 0x000fc800078e0004ULL, 0x0000001011047825ULL, 0x000fe200078e0004ULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x0000001000067824ULL, 0x00cfe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe20000011600ULL, 0x0000008010117824ULL, 0x000fc600078e00ffULL,
0x0000007006137812ULL, 0x000fe400078ec0ffULL, 0x0000000c12307812ULL, 0x000fe400078ec0ffULL,
0x00006e0011127a10ULL, 0x000fe40007ebe016ULL, 0x00000019ff067819ULL, 0x000fe40000011610ULL,
0x0000001a13117210ULL, 0x000fe40007a3e011ULL, 0x0000001230127210ULL, 0x000fc40007c7e013ULL,
0x00006f0006137a10ULL, 0x000fe40002fec4ffULL, 0x0000001130107210ULL, 0x000fe40007fbe0ffULL,
0x0000001bff067210ULL, 0x000fe40000fe4406ULL, 0x00000013ff137210ULL, 0x000fc60001fe84ffULL,
0x000000ffff117224ULL, 0x000fca00028e0606ULL, 0x0000001c10007986ULL, 0x0003e8000c101908ULL,
0x0000001e12007986ULL, 0x0003e4000c101908ULL, 0x000000ff0000720cULL, 0x00cfe20000705670ULL,
0x000000200a007986ULL, 0x000fe2000c101d08ULL, 0x0000017000007945ULL, 0x000fe60003800000ULL,
0x000000240c007986ULL, 0x000fe8000c101d08ULL, 0x000000280e007986ULL, 0x000fe8000c101d08ULL,
0x0000002c04007986ULL, 0x000fe8000c101d08ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000004ff047424ULL, 0x000fe200078e00ffULL,
0xffffffff1d0b7810ULL, 0x000fc60007ffe0ffULL, 0x00006e0009047625ULL, 0x000fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x0000000b040479a8ULL, 0x000ea400099ee1c8ULL,
0x0000000b0400720cULL, 0x004fc80003f05270ULL, 0x00000001ff067807ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000006ff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000ff047984ULL, 0x000ee40000000000ULL, 0x000000ff0400720cULL, 0x008fda0003f05270ULL,
0x0000347000008947ULL, 0x000fea0003800000ULL, 0x000000ff9a00720cULL, 0x000fda0003f05270ULL,
0x00000a5000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x000001b000008947ULL, 0x000fea0003800000ULL, 0x0000001000057824ULL, 0x000fe200078e00ffULL,
0x00000001ff067819ULL, 0x004fe40000011600ULL, 0x0000001a07047211ULL, 0x000fe400078038ffULL,
0x0000007005097812ULL, 0x000fe400078ec0ffULL, 0x0000000c06067812ULL, 0x000fe400078ec0ffULL,
0x0000001b07057211ULL, 0x000fe400000f3cffULL, 0x0000000406047210ULL, 0x000fc8000791e009ULL,
0x00000005ff057210ULL, 0x000fca00007e24ffULL, 0x0000000804097981ULL, 0x000528000c1e1900ULL,
0x00008008040a7981ULL, 0x000522000c1e1900ULL, 0x000000021d00780cULL, 0x000fda0003f05270ULL,
0x000000f000008947ULL, 0x000fea0003800000ULL, 0x00010008040c7981ULL, 0x004522000c1e1900ULL,
0x000000041d00780cULL, 0x000fda0003f06070ULL, 0x000000c000008947ULL, 0x000fea0003800000ULL,
0x00018008040e7981ULL, 0x004522000c1e1900ULL, 0x000000041d00780cULL, 0x000fda0003f05270ULL,
0x0000009000008947ULL, 0x000fea0003800000ULL, 0x0002000804107981ULL, 0x006322000c1e1900ULL,
0x000000061d00780cULL, 0x000fda0003f06070ULL, 0x0000006000008947ULL, 0x000fea0003800000ULL,
0x0002800804127981ULL, 0x002322000c1e1900ULL, 0x000000061d00780cULL, 0x000fda0003f05270ULL,
0x0000003000008947ULL, 0x000fea0003800000ULL, 0x000000081d00780cULL, 0x002fe20003f06070ULL,
0x00030008041a7981ULL, 0x000318000c1e1900ULL, 0x00038008041c0981ULL, 0x000324000c1e1900ULL,
0x000000071d047810ULL, 0x006fc80007ffe0ffULL, 0x00000003ff067819ULL, 0x000fc80000011604ULL,
0x000000ff0600720cULL, 0x000fda0003f05270ULL, 0x000007d000008947ULL, 0x000fea0003800000ULL,
0x00000014070b7211ULL, 0x000fe200078038ffULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1e7224ULL, 0x010fe200078e0009ULL,
0x00006e000b0b7a10ULL, 0x000fe40007f3e0ffULL, 0x000000ff070d7211ULL, 0x000fe400000f3cffULL,
0x000007800b0b7810ULL, 0x000fc80007f5e0ffULL, 0x00006f00ff0d7a10ULL, 0x000fc400017e240dULL,
0x000003000f007a0cULL, 0x000fe20003f26070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x0000000406007c0cULL, 0x000fcc000bf03070ULL, 0x000006d000001947ULL, 0x012fea0003800000ULL,
0x000000080f047810ULL, 0x040fe40007ffe0ffULL, 0x000000010f057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001e09097209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000000400047819ULL, 0x000fe400000006ffULL, 0x00000001ff057819ULL, 0x000fe40000011600ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000040b047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060dULL,
0xfffc8008041e7981ULL, 0x000326000c1e1900ULL, 0x000005f000002947ULL, 0x000fea0003800000ULL,
0x000000090f047810ULL, 0x042fe40007ffe0ffULL, 0x000000020f057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000000a09097209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011600ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000040b047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060dULL,
0xfffd0008040a7981ULL, 0x000326000c1e1900ULL, 0x0000051000002947ULL, 0x000fea0003800000ULL,
0x0000000a0f047810ULL, 0x042fe40007ffe0ffULL, 0x000000030f057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000000c09097209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011600ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000040b047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060dULL,
0xfffd8008040c7981ULL, 0x000326000c1e1900ULL, 0x0000043000002947ULL, 0x000fea0003800000ULL,
0x0000000b0f047810ULL, 0x042fe40007ffe0ffULL, 0x000000040f057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000000e09097209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011600ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000040b047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060dULL,
0xfffe0008040e7981ULL, 0x000326000c1e1900ULL, 0x0000035000002947ULL, 0x000fea0003800000ULL,
0x0000000c0f047810ULL, 0x042fe40007ffe0ffULL, 0x000000050f057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001009097209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011600ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000040b047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060dULL,
0xfffe800804107981ULL, 0x000326000c1e1900ULL, 0x0000027000002947ULL, 0x000fea0003800000ULL,
0x0000000d0f047810ULL, 0x042fe40007ffe0ffULL, 0x000000060f057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001209097209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011600ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000040b047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060dULL,
0xffff000804127981ULL, 0x000326000c1e1900ULL, 0x0000019000002947ULL, 0x000fea0003800000ULL,
0x0000000e0f047810ULL, 0x042fe40007ffe0ffULL, 0x000000070f057810ULL, 0x000fe40007ffe0ffULL,
0x0000030004007a0cULL, 0x000fe40003f26070ULL, 0x0000030005007a0cULL, 0x000fe40003f46070ULL,
0x0000001a09097209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011600ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000040b047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060dULL,
0xffff8008041a7981ULL, 0x000326000c1e1900ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000000f0f047810ULL, 0x002fe40007ffe0ffULL, 0x0000001c09097209ULL, 0x000fe40007810000ULL,
0x0000030004007a0cULL, 0x000fda0003f26070ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001000047824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011600ULL,
0x0000007004047812ULL, 0x000fc800078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ef805ULL,
0x000000040b047210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff057224ULL, 0x000fca00008e060dULL,
0x00000008041c7981ULL, 0x000326000c1e1900ULL, 0x000004000b0b7810ULL, 0x000fe40007f3e0ffULL,
0x000000080f0f7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0xfffff8b000008947ULL, 0x000fea000383ffffULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x0000001000047824ULL, 0x006fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011600ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fca00078ec0ffULL,
0x0000000104047824ULL, 0x000fca00078e0205ULL, 0x0000000904007388ULL, 0x0103e40000000800ULL,
0x00006e0019047a10ULL, 0x002fe20007f3e0ffULL, 0x0000000118117824ULL, 0x000fe200078e0207ULL,
0x000000070000780cULL, 0x040fe20003f04070ULL, 0x0000100015067824ULL, 0x004fe200078e00ffULL,
0x00006f00ff057a10ULL, 0x000fe20000ffe4ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x0000000118097812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00002000110a7825ULL, 0x000fe200078e0004ULL, 0x00000020001b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000040001d7810ULL, 0x000fe20007ffe0ffULL,
0x00000002180c8824ULL, 0x100fe200078e0215ULL, 0x000000060a0a7210ULL, 0x000fe20007f3e0ffULL,
0x00000002180e8824ULL, 0x000fe200078e0215ULL, 0x00000060001f7810ULL, 0x000fe20007ffe0ffULL,
0x000000020c198824ULL, 0x100fe200078e0209ULL, 0x0000008000217810ULL, 0x000fe20007ffe0ffULL,
0x000000020e2f8824ULL, 0x000fe200078e0209ULL, 0x000000a000237810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x000000c000257810ULL, 0x040fe20007ffe0ffULL,
0x0000000819198824ULL, 0x000fe200078e0200ULL, 0x000000e000277810ULL, 0x000fe20007ffe0ffULL,
0x000000101b1a7825ULL, 0x000fe200078e000aULL, 0x0000100008097812ULL, 0x000fe200078ec0ffULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x00000001ff0f7819ULL, 0x000fe20000011600ULL,
0x0000400018087824ULL, 0x000fe200078e0203ULL, 0x0000007010107812ULL, 0x000fe200078ec0ffULL,
0x000000101d1c7825ULL, 0x100fe200078e000aULL, 0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x000000101f1e7825ULL, 0x100fe200078e000aULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000001021207825ULL, 0x100fe200078e000aULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000001023227825ULL, 0x100fe200078e000aULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000001025247825ULL, 0x100fe200078e000aULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0000001027267825ULL, 0x000fe200078e000aULL, 0x00000000004e7805ULL, 0x000fc6000001ff00ULL,
0x0000001000127825ULL, 0x000fe200078e000aULL, 0x00006e00160a7a10ULL, 0x000fe40007f3e0ffULL,
0x00006e00140b7a10ULL, 0x000fe20007f5e0ffULL, 0x0000000108097824ULL, 0x000fe400078e0209ULL,
0x00006f00ff0c7624ULL, 0x000fe200008e06ffULL, 0x0000000a11288211ULL, 0x040fe200078238ffULL,
0x00000010002d7824ULL, 0x000fe400078e0209ULL, 0x0000000110097824ULL, 0x000fe200078e020fULL,
0x0000000c11298211ULL, 0x040fe200008f3cffULL, 0x00006f00ff0d7624ULL, 0x000fe200010e06ffULL,
0x0000000b112a8211ULL, 0x000fe200078438ffULL, 0x000000082f2f8824ULL, 0x000fe200078e0200ULL,
0x0000030018007a0cULL, 0x000fe20003f26070ULL, 0x0000000009097984ULL, 0x000e620000000800ULL,
0x0000000d112b8211ULL, 0x000fe200010f3cffULL, 0x000000ffff0e7224ULL, 0x000fc400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000122d7faeULL, 0x0005e2000b901c48ULL,
0x000000ffff147224ULL, 0x000fe400078e00ffULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x003800001a2d7faeULL, 0x0007e2000b901c48ULL, 0x000000ffff527224ULL, 0x000fe400078e00ffULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x005800001c2d7faeULL, 0x0009e2000b901c48ULL,
0x000000ffff547224ULL, 0x000fc600078e00ffULL, 0x007800001e2d7faeULL, 0x0009e2000b901c48ULL,
0x0000000000127805ULL, 0x004fc6000001ff00ULL, 0x00980000202d7faeULL, 0x0005e2000b901c48ULL,
0x00008580191b8811ULL, 0x008fe400078e20ffULL, 0x000000ff00197202ULL, 0x000fe20000000f00ULL,
0x00000010001c8825ULL, 0x050fe200078e0028ULL, 0x00b80000222d7faeULL, 0x0007e2000b901c48ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000010001e8825ULL, 0x000fe200078e002aULL,
0x00d80000242d7faeULL, 0x0009e2000b901c48ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000081802f218811ULL, 0x004fc400078e20ffULL, 0x00f80000262d7faeULL, 0x0005e2000b901c48ULL,
0x00000000002e7805ULL, 0x000fc6000001ff00ULL, 0x000000001c1b8faeULL, 0x0003e2000b901c48ULL,
0x0000000000227805ULL, 0x008fc6000001ff00ULL, 0x000000001e218faeULL, 0x0007e2000b901c48ULL,
0x0000000000247805ULL, 0x010fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000267805ULL, 0x004fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x002fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x008fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000012f000001947ULL, 0x000fea0003800000ULL, 0x000000ffff0e7224ULL, 0x000fe400078e00ffULL,
0x000000ffff537224ULL, 0x000fca00078e0018ULL, 0x0000000153107810ULL, 0x000fc80007ffe0ffULL,
0x0000030010007a0cULL, 0x000fda0003f06070ULL, 0x0000034000000947ULL, 0x000fea0003800000ULL,
0x000000070000780cULL, 0x000fe20003f44070ULL, 0x0000000107697824ULL, 0x000fe200078e0210ULL,
0x0000000110587812ULL, 0x040fe200078ec0ffULL, 0x00001000100f7824ULL, 0x000fe200078e00ffULL,
0x00000020005b7810ULL, 0x040fe20007ffe0ffULL, 0x0000200069567825ULL, 0x000fe200078e0004ULL,
0x00000040005d7810ULL, 0x000fe40007ffe0ffULL, 0x000010000f0f7812ULL, 0x000fe400078ec0ffULL,
0x0000000656567210ULL, 0x000fc40007f1e0ffULL, 0x00000060005f7810ULL, 0x000fe20007ffe0ffULL,
0x000000021855a824ULL, 0x100fe200078e0215ULL, 0x0000008000617810ULL, 0x000fe20007ffe0ffULL,
0x000000021859a824ULL, 0x000fe200078e0215ULL, 0x000000a000637810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff577224ULL, 0x000fe200000e0657ULL, 0x000000c000657810ULL, 0x000fe20007ffe0ffULL,
0x00000001080f7824ULL, 0x000fe200078e020fULL, 0x000000e000677810ULL, 0x040fe20007ffe0ffULL,
0x000000025555a824ULL, 0x100fe200078e0258ULL, 0x0000000a6966a211ULL, 0x000fe200078038ffULL,
0x00000002596ba824ULL, 0x000fe200078e0258ULL, 0x0000000b6968a211ULL, 0x000fe200078238ffULL,
0x00000010000f7824ULL, 0x000fc400078e020fULL, 0x0000001000587825ULL, 0x000fc800078e0056ULL,
0x000000105b5a7825ULL, 0x100fe200078e0056ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00180000580f7faeULL, 0x0003e6000b901c48ULL, 0x000000105d5c7825ULL, 0x100fe200078e0056ULL,
0x003800005a0f7faeULL, 0x0005e6000b901c48ULL, 0x000000105f5e7825ULL, 0x100fe200078e0056ULL,
0x005800005c0f7faeULL, 0x0007e6000b901c48ULL, 0x0000001061607825ULL, 0x100fe200078e0056ULL,
0x007800005e0f7faeULL, 0x0007e6000b901c48ULL, 0x0000001063627825ULL, 0x100fe200078e0056ULL,
0x00980000600f7faeULL, 0x0007e6000b901c48ULL, 0x0000001065647825ULL, 0x100fe200078e0056ULL,
0x00b80000620f7faeULL, 0x0007e6000b901c48ULL, 0x0000001067567825ULL, 0x000fe200078e0056ULL,
0x0000000c6967a211ULL, 0x040fe200000f3cffULL, 0x00d80000640f7faeULL, 0x0007e2000b901c48ULL,
0x0000000d6969a211ULL, 0x000fe200008f3cffULL, 0x000000085555a824ULL, 0x000fc400078e0200ULL,
0x000000086b6ba824ULL, 0x000fe200078e0200ULL, 0x00f80000560f7faeULL, 0x0007e2000b901c48ULL,
0x000000100066a825ULL, 0x040fe200078e0066ULL, 0x000085805555a811ULL, 0x000fe400078e20ffULL,
0x000081806b5ba811ULL, 0x004fe200078e20ffULL, 0x000000100058a825ULL, 0x002fe400078e0068ULL,
0x000000006655afaeULL, 0x0007e8000b901c48ULL, 0x00000000585bafaeULL, 0x0007e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000080530f7824ULL, 0x008fe200078e00ffULL,
0x0000001518567211ULL, 0x000fe200078e08ffULL, 0x0000001000107824ULL, 0x000fe200078e00ffULL,
0x00000001ff577819ULL, 0x000fc40000011600ULL, 0x000000800f0f7812ULL, 0x000fe400078ec0ffULL,
0x0000007010107812ULL, 0x000fe400078ec0ffULL, 0x00000002ff6a7819ULL, 0x000fe20000011600ULL,
0x0000010056557824ULL, 0x000fe200078e000fULL, 0x0000000c570f7812ULL, 0x000fe400078ec0ffULL,
0x000000026a577810ULL, 0x040fe20007ffe0ffULL, 0x000000086a627824ULL, 0x040fe200078e00ffULL,
0x000000550f567210ULL, 0x000fe20007ffe010ULL, 0x000000086a607824ULL, 0x040fe200078e00ffULL,
0x000000016a557810ULL, 0x040fe20007ffe0ffULL, 0x000000086a5b7824ULL, 0x000fe200078e00ffULL,
0xfffffff862627812ULL, 0x000fe200078ee257ULL, 0x0000000400577824ULL, 0x000fe200078e00ffULL,
0xfffffff860607812ULL, 0x000fe200078ee255ULL, 0x0000100053557824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0081800056587984ULL, 0x000e620000000800ULL,
0x0000000c57677812ULL, 0x000fe200078ec0ffULL, 0x000000086a577824ULL, 0x040fe200078e00ffULL,
0x000000046a5a7810ULL, 0x040fe20007ffe0ffULL, 0x00858000565e7984ULL, 0x0002a20000000800ULL,
0x0000100055557812ULL, 0x000fe200078ec0ffULL, 0x000000086a667824ULL, 0x040fe200078e00ffULL,
0xfffffff85b687812ULL, 0x000fe200078ee25aULL, 0x000000086a6e7824ULL, 0x000fe200078e00ffULL,
0x0000018008557810ULL, 0x000fe20007ffe055ULL, 0x000000086a707824ULL, 0x040fe200078e00ffULL,
0xfffffff8575a7812ULL, 0x000fe200078ee26aULL, 0x000000086a5f7824ULL, 0x040fe200078e00ffULL,
0x000000086a6c7810ULL, 0x000fc40007ffe0ffULL, 0x000000186a747810ULL, 0x040fe40007ffe0ffULL,
0x000000106a727810ULL, 0x000fe20007ffe0ffULL, 0x000000086c5b7824ULL, 0x000fe200078e00ffULL,
0x000000036a597810ULL, 0x000fe20007ffe0ffULL, 0x00000008745d7824ULL, 0x000fe200078e00ffULL,
0x0000000253537810ULL, 0x000fe40007ffe0ffULL, 0xfffffff866667812ULL, 0x000fe400078ee259ULL,
0xfffffff85d5c7812ULL, 0x000fc400078ee274ULL, 0x000000056a597810ULL, 0x000fe40007ffe0ffULL,
0x000000555c5c7211ULL, 0x000fe400078e20ffULL, 0xfffffff86e6e7812ULL, 0x000fe400078ee259ULL,
0x0000030053007a0cULL, 0x000fe20003f06070ULL, 0x00000001675d7824ULL, 0x000fe400078e025cULL,
0x00000010685c7824ULL, 0x000fc600078e0255ULL, 0x000000005d657984ULL, 0x000fe20000000800ULL,
0x0000005809567221ULL, 0x002fe20000010100ULL, 0xfffffff85b587812ULL, 0x000fe200078ee26cULL,
0x00000008725b7824ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b56577820ULL, 0x000fe20000410000ULL,
0x000000105a567824ULL, 0x100fe400078e0255ULL, 0x0000001058587824ULL, 0x100fe200078e0255ULL,
0xfffffff85b5a7812ULL, 0x000fe200078ee272ULL, 0x0000000167567824ULL, 0x040fe200078e0256ULL,
0x0000005700577308ULL, 0x000ea20000000800ULL, 0x0000000167587824ULL, 0x000fe200078e0258ULL,
0x000000066a5b7810ULL, 0x000fe20007ffe0ffULL, 0x000000105a5a7824ULL, 0x000fc400078e0255ULL,
0x0000000056567984ULL, 0x000e620000000800ULL, 0xfffffff870707812ULL, 0x000fe200078ee25bULL,
0x00000001675a7824ULL, 0x040fe400078e025aULL, 0x0000000058637984ULL, 0x0007220000000800ULL,
0x00000010665b7824ULL, 0x000fe400078e0255ULL, 0x00000001675c7824ULL, 0x040fe200078e025cULL,
0x000000005a647984ULL, 0x000f220000000800ULL, 0x00000001675b7824ULL, 0x000fe200078e025bULL,
0x0000005e576b7220ULL, 0x004fe20000410000ULL, 0x0000001060577824ULL, 0x100fe200078e0255ULL,
0xffffffff6a5e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001062587824ULL, 0x008fe200078e0255ULL,
0x000000005c5d7984ULL, 0x000fe20000000800ULL, 0x0000000167577824ULL, 0x000fe200078e0257ULL,
0xfffffff85f607812ULL, 0x000fe200078ee25eULL, 0x0000000167597824ULL, 0x000fe200078e0258ULL,
0x00001f6c6b6c7589ULL, 0x000ea200000e0000ULL, 0x00000010705f7824ULL, 0x100fe200078e0255ULL,
0x000000546b547221ULL, 0x000fe20000010000ULL, 0x000000106e5e7824ULL, 0x100fe200078e0255ULL,
0x0000000057587984ULL, 0x000fe20000000800ULL, 0x0000001060617824ULL, 0x000fc400078e0255ULL,
0x0000000167607824ULL, 0x040fe200078e025fULL, 0x00000000595a7984ULL, 0x000fe20000000800ULL,
0x00000001675e7824ULL, 0x040fe400078e025eULL, 0x0000000167617824ULL, 0x000fe200078e0261ULL,
0x000000005b557984ULL, 0x000fe80000000800ULL, 0x00001f6a6b6a7589ULL, 0x000ee800000e0000ULL,
0x00001f746b6e7589ULL, 0x000ee200000e0000ULL, 0x20000056ff677230ULL, 0x002fc40000004100ULL,
0x30000056ff627230ULL, 0x000fe20000004100ULL, 0x00001f726b6d7589ULL, 0x000e6200000e0000ULL,
0x20000063ff697230ULL, 0x010fc60000004100ULL, 0x0000000060567984ULL, 0x000f220000000800ULL,
0x20000064ff667230ULL, 0x100fe20000004100ULL, 0x0000006c694e7223ULL, 0x004fe2000001004eULL,
0x20000065ff697230ULL, 0x000fe20000004100ULL, 0x000000005e5f7984ULL, 0x000ea20000000800ULL,
0x30000064ff647230ULL, 0x000fe40000004100ULL, 0x2000005dff687230ULL, 0x100fe40000004100ULL,
0x3000005dff5d7230ULL, 0x000fe20000004100ULL, 0x0000006a67507223ULL, 0x088fe20000010050ULL,
0x0000006a624f7223ULL, 0x000fe2000001004fULL, 0x30000063ff677230ULL, 0x000fe20000004100ULL,
0x0000000061627984ULL, 0x000ee20000000800ULL, 0x0000006e69307223ULL, 0x000fe20000010030ULL,
0x30000065ff697230ULL, 0x000fe20000004100ULL, 0x0000006a5d407223ULL, 0x000fe20000010040ULL,
0x0004000057637984ULL, 0x000ee20000000800ULL, 0x20000058ff657230ULL, 0x100fe20000004100ULL,
0x0000006c67327223ULL, 0x000fe20000010032ULL, 0x30000058ff677230ULL, 0x000fe20000004100ULL,
0x0000006d664d7223ULL, 0x082fe2000001004dULL, 0x000400005b587984ULL, 0x000e620000000800ULL,
0x0000006a652e7223ULL, 0x080fe2000001002eULL, 0x0000006d64317223ULL, 0x000fe20000010031ULL,
0x0000006a674c7223ULL, 0x080fe2000001004cULL, 0x000400005c657984ULL, 0x000e620000000800ULL,
0x2000005aff667230ULL, 0x100fe20000004100ULL, 0x0000006a68437223ULL, 0x080fe20000010043ULL,
0x3000005aff677230ULL, 0x000fe20000004100ULL, 0x0004000059647984ULL, 0x000e620000000800ULL,
0x20000055ff5a7230ULL, 0x100fe20000004100ULL, 0x0000006a664b7223ULL, 0x080fe2000001004bULL,
0x30000055ff557230ULL, 0x000fe20000004100ULL, 0x000400005e667984ULL, 0x000e620000000800ULL,
0x0000006a67367223ULL, 0x080fe20000010036ULL, 0x0000006a5a477223ULL, 0x000fe20000010047ULL,
0x0000006e69467223ULL, 0x000fe20000010046ULL, 0x0000006a55447223ULL, 0x000fe20000010044ULL,
0x20000056ff5a7230ULL, 0x110fe20000004100ULL, 0x0004000060557984ULL, 0x000f220000000800ULL,
0x30000056ff677230ULL, 0x000fc40000004100ULL, 0x2000005fff5d7230ULL, 0x104fe20000004100ULL,
0x0004000061567984ULL, 0x000ea20000000800ULL, 0x0000006a5a3b7223ULL, 0x080fe2000001003bULL,
0x3000005fff5f7230ULL, 0x000fe20000004100ULL, 0x0000006a67387223ULL, 0x080fe20000010038ULL,
0x00080000575a7984ULL, 0x000ea20000000800ULL, 0x0000006a5d207223ULL, 0x080fe40000010020ULL,
0x0000006a5f3c7223ULL, 0x000fe2000001003cULL, 0x20000062ff5d7230ULL, 0x108fe20000004100ULL,
0x000c0000575f7984ULL, 0x000ee20000000800ULL, 0x30000062ff627230ULL, 0x000fc40000004100ULL,
0x30000063ff687230ULL, 0x100fe20000004100ULL, 0x0000006a5d4a7223ULL, 0x080fe2000001004aULL,
0x20000063ff677230ULL, 0x000fe20000004100ULL, 0x00080000595d7984ULL, 0x000ee20000000800ULL,
0x0000006a62357223ULL, 0x000fe20000010035ULL, 0x0000006c68497223ULL, 0x080fe20000010049ULL,
0x20000058ff687230ULL, 0x102fe20000004100ULL, 0x000800005b577984ULL, 0x000e620000000800ULL,
0x30000058ff637230ULL, 0x000fe20000004100ULL, 0x0000006c67347223ULL, 0x080fe20000010034ULL,
0x20000065ff587230ULL, 0x100fe20000004100ULL, 0x0000006c68457223ULL, 0x080fe20000010045ULL,
0x30000065ff657230ULL, 0x000fe20000004100ULL, 0x0000006c63267223ULL, 0x080fe20000010026ULL,
0x20000064ff627230ULL, 0x100fe20000004100ULL, 0x0000006c583f7223ULL, 0x080fe2000001003fULL,
0x30000064ff647230ULL, 0x000fe20000004100ULL, 0x000800005c587984ULL, 0x000e620000000800ULL,
0x30000066ff677230ULL, 0x100fe20000004100ULL, 0x0000006c621b7223ULL, 0x080fe2000001001bULL,
0x0000006c65247223ULL, 0x080fe20000010024ULL, 0x0000006c642f7223ULL, 0x080fe2000001002fULL,
0x20000066ff647230ULL, 0x000fe20000004100ULL, 0x000c000059627984ULL, 0x0004620000000800ULL,
0x20000055ff667230ULL, 0x110fe20000004100ULL, 0x0000006c673a7223ULL, 0x080fe2000001003aULL,
0x30000055ff687230ULL, 0x000fe20000004100ULL, 0x000c00005b637984ULL, 0x000f220000000800ULL,
0x0000006c643d7223ULL, 0x080fe2000001003dULL, 0x0000006c66257223ULL, 0x000fc40000010025ULL,
0x000800005e557984ULL, 0x000f220000000800ULL, 0x20000056ff597230ULL, 0x104fe20000004100ULL,
0x0000006c68377223ULL, 0x080fe20000010037ULL, 0x30000056ff567230ULL, 0x000fe20000004100ULL,
0x000c00005e5b7984ULL, 0x0005240000000800ULL, 0x0000006c591c7223ULL, 0x080fe2000001001cULL,
0x2000005aff597230ULL, 0x000fe20000004100ULL, 0x000c00005c647984ULL, 0x0005220000000800ULL,
0x0000006c56337223ULL, 0x000fe20000010033ULL, 0x2000005fff657230ULL, 0x008fc40000004100ULL,
0x0008000060567984ULL, 0x000ee20000000800ULL, 0x0000006d59167223ULL, 0x080fe20000010016ULL,
0x3000005dff5e7230ULL, 0x004fe20000004100ULL, 0x0000006e652c7223ULL, 0x080fe2000001002cULL,
0x3000005aff5c7230ULL, 0x000fe20000004100ULL, 0x0008000061597984ULL, 0x000ea20000000800ULL,
0x3000005fff667230ULL, 0x000fe20000004100ULL, 0x0000006d5e417223ULL, 0x080fe20000010041ULL,
0x2000005dff5f7230ULL, 0x000fe20000004100ULL, 0x000c0000605a7984ULL, 0x0008a20000000800ULL,
0x0000006d5c2d7223ULL, 0x080fe2000001002dULL, 0x20000057ff5d7230ULL, 0x102fe20000004100ULL,
0x0000006e662b7223ULL, 0x080fe2000001002bULL, 0x000c0000615c7984ULL, 0x000e620000000800ULL,
0x30000057ff5e7230ULL, 0x000fe20000004100ULL, 0x0000006d5f2a7223ULL, 0x080fe2000001002aULL,
0x20000058ff577230ULL, 0x100fe20000004100ULL, 0x0000006d5d3e7223ULL, 0x080fe2000001003eULL,
0x30000058ff587230ULL, 0x000fe20000004100ULL, 0x0000006d5e297223ULL, 0x080fe20000010029ULL,
0x20000062ff657230ULL, 0x100fe20000004100ULL, 0x0000006d57227223ULL, 0x080fe20000010022ULL,
0x30000062ff627230ULL, 0x000fe20000004100ULL, 0x0000006d581f7223ULL, 0x000fe2000001001fULL,
0x20000063ff607230ULL, 0x010fe20000004100ULL, 0x0000006e65287223ULL, 0x000fc40000010028ULL,
0x0000006e62277223ULL, 0x080fe20000010027ULL, 0x20000055ff577230ULL, 0x100fe20000004100ULL,
0x0000006e60217223ULL, 0x080fe20000010021ULL, 0x30000055ff587230ULL, 0x000fe40000004100ULL,
0x2000005bff557230ULL, 0x000fe20000004100ULL, 0x0000006d571e7223ULL, 0x080fe2000001001eULL,
0x30000063ff627230ULL, 0x000fe20000004100ULL, 0x0000006d581d7223ULL, 0x080fe2000001001dULL,
0x20000064ff5d7230ULL, 0x100fe20000004100ULL, 0x0000006e55487223ULL, 0x080fe20000010048ULL,
0x30000064ff647230ULL, 0x000fe20000004100ULL, 0x0000006e62237223ULL, 0x080fe20000010023ULL,
0x20000056ff587230ULL, 0x108fe20000004100ULL, 0x0000006e5d427223ULL, 0x080fe20000010042ULL,
0x30000056ff557230ULL, 0x000fe20000004100ULL, 0x0000006e64397223ULL, 0x000fe20000010039ULL,
0x3000005bff5b7230ULL, 0x000fe20000004100ULL, 0x0000006d58117223ULL, 0x000fc40000010011ULL,
0x0000006d551a7223ULL, 0x080fe2000001001aULL, 0x20000059ff557230ULL, 0x104fe20000004100ULL,
0x0000006e5b527223ULL, 0x080fe20000010052ULL, 0x2000005aff567230ULL, 0x100fe40000004100ULL,
0x3000005aff5a7230ULL, 0x000fe20000004100ULL, 0x0000006d55147223ULL, 0x000fe20000010014ULL,
0x2000005cff577230ULL, 0x102fe20000004100ULL, 0x0000006e56197223ULL, 0x080fe20000010019ULL,
0x30000059ff567230ULL, 0x000fe20000004100ULL, 0x0000006e5a517223ULL, 0x080fe20000010051ULL,
0x3000005cff597230ULL, 0x000fe20000004100ULL, 0x0000006e57127223ULL, 0x000fc40000010012ULL,
0x0000006d56137223ULL, 0x000fe40000010013ULL, 0x0000006e590e7223ULL, 0x000fe2000001000eULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffed3000007947ULL, 0x000fea000383ffffULL,
0x000000ff1500720cULL, 0x000fe20003f05270ULL, 0x0000018000007945ULL, 0x000fd80003800000ULL,
0x0000001018008211ULL, 0x000fca00078e38ffULL, 0x000000010f058824ULL, 0x000fe400078e0200ULL,
0x00000001100f7824ULL, 0x000fc600078e020fULL, 0x0089805405008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x008980000f007984ULL, 0x000e680000000800ULL,
0x008a00000f077984ULL, 0x000ea20000000800ULL, 0x00000000ff007221ULL, 0x002fc80000010000ULL,
0x0000000700007221ULL, 0x004fca0000010000ULL, 0x0180000000047810ULL, 0x000fc80007ffe0ffULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e0000ULL, 0x0000d61000067802ULL, 0x000fc40000000f00ULL,
0x0000bd0000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff047224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000057308ULL, 0x000e640000001000ULL,
0xbf80000000047423ULL, 0x002fc80000000005ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000405047223ULL, 0x000fc40000000005ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff537819ULL, 0x004fc40000011600ULL, 0x0000000800557811ULL, 0x040fe400078ff0ffULL,
0x0000001000577811ULL, 0x040fe200078ff0ffULL, 0x00001f5304057589ULL, 0x002e6200000e0000ULL,
0x0000001800597811ULL, 0x000fe200078ff0ffULL, 0x00000008535b7824ULL, 0x040fe200078e00ffULL,
0x0000000153107810ULL, 0x000fe20007ffe0ffULL, 0x00001f5504067589ULL, 0x000ea800000e0000ULL,
0x00001f57040a7589ULL, 0x000ee800000e0000ULL, 0x00001f59040d7589ULL, 0x00052200000e0000ULL,
0x0000003c05097220ULL, 0x002fe20000410000ULL, 0x00000008533c7824ULL, 0x000fe200078e00ffULL,
0x0000005005507220ULL, 0x040fe20000410000ULL, 0x0000004f054f7220ULL, 0x000fe20000410000ULL,
0x0000003706047220ULL, 0x044fe20000410000ULL, 0x00000032060b7220ULL, 0x040fe20000410000ULL,
0x0000002f06087220ULL, 0x040fe20000410000ULL, 0x0000000853377824ULL, 0x040fe200078e00ffULL,
0x0000004e064e7220ULL, 0x040fe20000410000ULL, 0x0000003406347220ULL, 0x040fe20000410000ULL,
0x0000004906497220ULL, 0x040fe20000410000ULL, 0x0000001b061b7220ULL, 0x040fe20000410000ULL,
0x0000004506457220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0x0000003f063f7220ULL, 0x040fe20000410000ULL, 0x0000002406247220ULL, 0x040fe20000410000ULL,
0x0000003d063d7220ULL, 0x040fe20000410000ULL, 0x0000003a063a7220ULL, 0x040fe20000410000ULL,
0x0000002506257220ULL, 0x040fe20000410000ULL, 0x0000001c061c7220ULL, 0x040fe20000410000ULL,
0x0000003306337220ULL, 0x000fe20000410000ULL, 0x00000002532f7810ULL, 0x040fe20007ffe0ffULL,
0x0000004d0a4d7220ULL, 0x048fe20000410000ULL, 0x0000000353327810ULL, 0x000fe20007ffe0ffULL,
0x000000310a067220ULL, 0x040fe20000410000ULL, 0x000000160a167220ULL, 0x040fe20000410000ULL,
0x0000002d0a2d7220ULL, 0x040fe20000410000ULL, 0x0000002a0a2a7220ULL, 0x040fe20000410000ULL,
0x000000410a417220ULL, 0x040fe20000410000ULL, 0x0000003e0a3e7220ULL, 0x040fe20000410000ULL,
0x000000290a297220ULL, 0x040fe20000410000ULL, 0x000000220a227220ULL, 0x040fe20000410000ULL,
0x0000001f0a1f7220ULL, 0x040fe20000410000ULL, 0x0000001e0a1e7220ULL, 0x040fe20000410000ULL,
0x0000001d0a1d7220ULL, 0x040fe20000410000ULL, 0x000000110a117220ULL, 0x040fe20000410000ULL,
0x0000001a0a1a7220ULL, 0x040fe20000410000ULL, 0x000000140a147220ULL, 0x040fe20000410000ULL,
0x000000130a137220ULL, 0x000fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000004c05077220ULL, 0x040fe20000410000ULL, 0x0000004b054b7220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000004705477220ULL, 0x040fe20000410000ULL,
0x0000004405447220ULL, 0x040fe20000410000ULL, 0x0000004305437220ULL, 0x040fe20000410000ULL,
0x0000004005407220ULL, 0x040fe20000410000ULL, 0x0000002005207220ULL, 0x040fe20000410000ULL,
0x0000003b053b7220ULL, 0x040fe20000410000ULL, 0x0000003805387220ULL, 0x040fe20000410000ULL,
0x0000004a054a7220ULL, 0x000fe20000410000ULL, 0x000000230d0a7220ULL, 0x010fe20000410000ULL,
0x0000003505057220ULL, 0x000fe20000410000ULL, 0x000000300d307220ULL, 0x040fe20000410000ULL,
0x000000460d0f7220ULL, 0x040fe20000410000ULL, 0x0000002c0d2c7220ULL, 0x040fe20000410000ULL,
0x0000002b0d2b7220ULL, 0x040fe20000410000ULL, 0x000000280d287220ULL, 0x040fe20000410000ULL,
0x000000270d277220ULL, 0x040fe20000410000ULL, 0x000000210d217220ULL, 0x040fe20000410000ULL,
0x000000420d427220ULL, 0x040fe20000410000ULL, 0x000000390d397220ULL, 0x040fe20000410000ULL,
0x000000480d487220ULL, 0x040fe20000410000ULL, 0x000000520d237220ULL, 0x040fe20000410000ULL,
0x000000190d197220ULL, 0x040fe20000410000ULL, 0x000000510d0c7220ULL, 0x040fe20000410000ULL,
0x000000120d127220ULL, 0x000fe20000410000ULL, 0x0000000853317824ULL, 0x000fe200078e00ffULL,
0x0000000e0d0d7220ULL, 0x000fe20000410000ULL, 0xfffffff83c357812ULL, 0x000fe200078ee22fULL,
0x0000000853517824ULL, 0x000fe200078e00ffULL, 0xfffffff837377812ULL, 0x000fe200078ee232ULL,
0x0000000853327824ULL, 0x040fe200078e00ffULL, 0x00000004530e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001035357824ULL, 0x000fe200078e0202ULL, 0x00000006532f7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff831317812ULL, 0x000fe400078ee210ULL, 0xfffffff851517812ULL, 0x000fe400078ee20eULL,
0xfffffff83c5d7812ULL, 0x000fe200078ee22fULL, 0x00000008593c7824ULL, 0x000fe200078e00ffULL,
0x0000000553107810ULL, 0x000fe20007ffe0ffULL, 0x0000001031317824ULL, 0x100fe200078e0202ULL,
0xffffffff530e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001051517824ULL, 0x000fe200078e0202ULL,
0xfffffff8322f7812ULL, 0x000fe200078ee253ULL, 0x0000000853537824ULL, 0x000fe200078e00ffULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee210ULL, 0x0000000855107824ULL, 0x000fe200078e00ffULL,
0xfffffff83c597812ULL, 0x000fe200078ee259ULL, 0x0000000857327824ULL, 0x000fe200078e00ffULL,
0xfffffff853537812ULL, 0x000fe200078ee20eULL, 0x00000004000e7824ULL, 0x000fe200078e00ffULL,
0xfffffff810557812ULL, 0x000fe200078ee255ULL, 0x000000102f2f7824ULL, 0x100fe200078e0202ULL,
0xfffffff832577812ULL, 0x000fe200078ee257ULL, 0x000000105b5b7824ULL, 0x100fe200078e0202ULL,
0x0000000c0e0e7812ULL, 0x000fe200078ec0ffULL, 0x000000105d5d7824ULL, 0x100fe200078e0202ULL,
0x0000000237377211ULL, 0x000fe200078e20ffULL, 0x0000001053537824ULL, 0x100fe200078e0202ULL,
0x000000504f4f723eULL, 0x000fe200000000ffULL, 0x0000001055557824ULL, 0x100fe200078e0202ULL,
0x0000002e0707723eULL, 0x000fe200000000ffULL, 0x0000001057577824ULL, 0x100fe200078e0202ULL,
0x0000004b3636723eULL, 0x000fe200000000ffULL, 0x0000001059597824ULL, 0x000fe200078e0202ULL,
0x000000474444723eULL, 0x000fe200000000ffULL, 0x000000012f027824ULL, 0x000fe200078e020eULL,
0x000000434040723eULL, 0x000fe200000000ffULL, 0x000000010e317824ULL, 0x040fe200078e0231ULL,
0x000000141313723eULL, 0x000fe200000000ffULL, 0x000000010e357824ULL, 0x040fe200078e0235ULL,
0x000000200909723eULL, 0x000fe200000000ffULL, 0x000000010e377824ULL, 0x040fe200078e0237ULL,
0x0000004f02007388ULL, 0x0003e20000000800ULL, 0x000000010e517824ULL, 0x000fe200078e0251ULL,
0x0000003b3838723eULL, 0x000fe200000000ffULL, 0x000000010e147824ULL, 0x000fe200078e025bULL,
0x000000111a11723eULL, 0x000fe200000000ffULL, 0x000000010e5d7824ULL, 0x040fe200078e025dULL,
0x0000000731007388ULL, 0x000fe20000000800ULL, 0x0000004a0505723eULL, 0x000fe200000000ffULL,
0x000000010e1a7824ULL, 0x040fe200078e0253ULL, 0x0000004e0b0b723eULL, 0x000fe200000000ffULL,
0x0000003635007388ULL, 0x000fe20000000800ULL, 0x000000010e107824ULL, 0x040fe200078e0255ULL,
0x000000344934723eULL, 0x000fe200000000ffULL, 0x000000010e577824ULL, 0x000fe200078e0257ULL,
0x0000004437007388ULL, 0x000fe20000000800ULL, 0x0000001b0808723eULL, 0x000fe200000000ffULL,
0x000000010e0e7824ULL, 0x000fe200078e0259ULL, 0x000000452626723eULL, 0x000fe200000000ffULL,
0x0000004051007388ULL, 0x000fe20000000800ULL, 0x0000003f2424723eULL, 0x000fc400000000ffULL,
0x0000003d3a3a723eULL, 0x000fe200000000ffULL, 0x0000000914007388ULL, 0x000fe20000000800ULL,
0x000000250404723eULL, 0x000fe400000000ffULL, 0x0000001c331c723eULL, 0x000fe200000000ffULL,
0x000000385d007388ULL, 0x000fe20000000800ULL, 0x0000004d0606723eULL, 0x000fe400000000ffULL,
0x000000162d16723eULL, 0x000fe200000000ffULL, 0x000000051a007388ULL, 0x000fe20000000800ULL,
0x0000002a412a723eULL, 0x000fc400000000ffULL, 0x0000003e2929723eULL, 0x000fe200000000ffULL,
0x0000000b10007388ULL, 0x000fe20000000800ULL, 0x000000221f1f723eULL, 0x000fe400000000ffULL,
0x0000001e1d1d723eULL, 0x000fe200000000ffULL, 0x0004003431007388ULL, 0x000fe20000000800ULL,
0x000000300f0f723eULL, 0x000fe400000000ffULL, 0x0000002c2b2b723eULL, 0x000fe200000000ffULL,
0x0004000835007388ULL, 0x000fe20000000800ULL, 0x000000282727723eULL, 0x000fc400000000ffULL,
0x000000210a0a723eULL, 0x000fe200000000ffULL, 0x0004002637007388ULL, 0x000fe20000000800ULL,
0x000000423939723eULL, 0x000fe400000000ffULL, 0x0000000017027210ULL, 0x002fe20007ffe0ffULL,
0x0004002451007388ULL, 0x000fe20000000800ULL, 0x000000482323723eULL, 0x000fe400000000ffULL,
0x000000190c0c723eULL, 0x000fe200000000ffULL, 0x0004003a14007388ULL, 0x000fe20000000800ULL,
0x000000120d0d723eULL, 0x000fe200000000ffULL, 0x0000001002027824ULL, 0x000fc400078e0203ULL,
0x000400045d007388ULL, 0x000fe80000000800ULL, 0x0004001c1a007388ULL, 0x000fe80000000800ULL,
0x0000000657007388ULL, 0x000fe80000000800ULL, 0x0008001631007388ULL, 0x000fe80000000800ULL,
0x0008002a35007388ULL, 0x000fe80000000800ULL, 0x0008002937007388ULL, 0x000fe80000000800ULL,
0x0008001f51007388ULL, 0x000fe80000000800ULL, 0x0008001d14007388ULL, 0x000fe80000000800ULL,
0x000800115d007388ULL, 0x000fe80000000800ULL, 0x000800131a007388ULL, 0x000fe80000000800ULL,
0x0000000f0e007388ULL, 0x000fe80000000800ULL, 0x000c002b31007388ULL, 0x000fe80000000800ULL,
0x000c002735007388ULL, 0x000fe80000000800ULL, 0x000c000a37007388ULL, 0x000fe80000000800ULL,
0x000c003951007388ULL, 0x000fe80000000800ULL, 0x000c002314007388ULL, 0x000fe80000000800ULL,
0x000c000c5d007388ULL, 0x000fe80000000800ULL, 0x000c000d1a007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000002047984ULL, 0x000e680000000c00ULL,
0x00040000021c7984ULL, 0x000ea80000000c00ULL, 0x0008000002087984ULL, 0x000ee80000000c00ULL,
0x000c000002207984ULL, 0x000f280000000c00ULL, 0x0010000002107984ULL, 0x000ee80000000c00ULL,
0x0014000002247984ULL, 0x000f280000000c00ULL, 0x0018000002287984ULL, 0x000f280000000c00ULL,
0x001c0000022c7984ULL, 0x000f220000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x004fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fc40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x200000ff0b0b7230ULL, 0x008fe40000000000ULL,
0x200000ff0a0a7230ULL, 0x000fe40000000000ULL, 0x200000ff09097230ULL, 0x000fe40000000000ULL,
0x200000ff08087230ULL, 0x000fe40000000000ULL, 0x200000ff23237230ULL, 0x010fc40000000000ULL,
0x200000ff22227230ULL, 0x000fe40000000000ULL, 0x200000ff21217230ULL, 0x000fe40000000000ULL,
0x200000ff20207230ULL, 0x000fe40000000000ULL, 0x0000001307077230ULL, 0x000fe40000000000ULL,
0x0000001206067230ULL, 0x000fe40000000000ULL, 0x0000001105057230ULL, 0x000fc40000000000ULL,
0x0000001004047230ULL, 0x000fe40000000000ULL, 0x000000271f1f7230ULL, 0x000fe40000000000ULL,
0x000000261e1e7230ULL, 0x000fe20000000000ULL, 0x0000000402007388ULL, 0x000fe20000000c00ULL,
0x000000251d1d7230ULL, 0x000fe40000000000ULL, 0x000000241c1c7230ULL, 0x000fe40000000000ULL,
0x0000002b0b0b7230ULL, 0x000fc40000000000ULL, 0x0000002a0a0a7230ULL, 0x000fe20000000000ULL,
0x0004001c02007388ULL, 0x000fe20000000c00ULL, 0x0000002909097230ULL, 0x000fe40000000000ULL,
0x0000002808087230ULL, 0x000fe40000000000ULL, 0x0000002f23237230ULL, 0x000fe40000000000ULL,
0x0000002e22227230ULL, 0x000fe20000000000ULL, 0x0008000802007388ULL, 0x000fe20000000c00ULL,
0x0000002d21217230ULL, 0x000fc40000000000ULL, 0x0000002c20207230ULL, 0x000fca0000000000ULL,
0x000c002002007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff1800720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff057819ULL, 0x000fc80000011600ULL, 0x000000800500720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000105027824ULL, 0x100fe200078e0200ULL,
0x00000000000479c3ULL, 0x000ee20000002700ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x00000020000f7810ULL, 0x000fe20007ffe0ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000000702077812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x0000002082027824ULL, 0x000fe200078e0205ULL, 0x00000003ff0d7819ULL, 0x000fe2000001160fULL,
0x0000580000067ab9ULL, 0x000fe20000000800ULL, 0x0ffffff807047812ULL, 0x000fc400078ef800ULL,
0x00000005020c7c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff067a19ULL, 0x004fe20000011602ULL,
0x0000001004047824ULL, 0x000fe400078e0203ULL, 0x00000001810c7824ULL, 0x000fc600078e020cULL,
0x0000000004087984ULL, 0x0005220000000c00ULL, 0x0000008506057224ULL, 0x000fe200078e020cULL,
0x00000007000c7812ULL, 0x000fe200078ec0ffULL, 0x00000006040472a4ULL, 0x008fc8000f8e023fULL,
0x0000000815077824ULL, 0x000fe400078e020cULL, 0x0000000485027c24ULL, 0x000fca000f8e02ffULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x004fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f4406ULL,
0x000000800d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0105ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010f047824ULL, 0x104fe200078e020dULL, 0x0000004000107810ULL, 0x002fe20007ffe0ffULL,
0x00000020820d7824ULL, 0x000fc600078e020dULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x000000050d0c7c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff804047812ULL, 0x000fc600078ef80fULL,
0x00000001810c7824ULL, 0x000fe400078e020cULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x00005a00ff047a19ULL, 0x000fe4000001160dULL, 0x00000003ff0d7819ULL, 0x000fe40000011610ULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000008504057224ULL, 0x000fe200078e020cULL,
0x000000070f0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000502057210ULL, 0x000fe20007f1e0ffULL,
0x0000000815077824ULL, 0x000fc800078e020cULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000800d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000110047824ULL, 0x102fe200078e020dULL, 0x00000060000f7810ULL, 0x000fe20007ffe0ffULL,
0x00000020820d7824ULL, 0x000fc600078e020dULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x000000050d0c7c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff804047812ULL, 0x000fc600078ef810ULL,
0x00000001810c7824ULL, 0x000fe400078e020cULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x00005a00ff047a19ULL, 0x000fe4000001160dULL, 0x00000003ff0d7819ULL, 0x000fe4000001160fULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000008504057224ULL, 0x000fe200078e020cULL,
0x00000007100c7812ULL, 0x000fc800078ec0ffULL, 0x0000000502057210ULL, 0x000fe40007f1e0ffULL,
0x0000000c15077211ULL, 0x000fc600078e18ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000800d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010f047824ULL, 0x102fe200078e020dULL, 0x0000008000107810ULL, 0x000fe20007ffe0ffULL,
0x00000020820d7824ULL, 0x000fc600078e020dULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x000000050d0c7c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff804047812ULL, 0x000fc600078ef80fULL,
0x00000001810c7824ULL, 0x000fe400078e020cULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x00005a00ff047a19ULL, 0x000fe4000001160dULL, 0x00000003ff0d7819ULL, 0x000fe40000011610ULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000008504057224ULL, 0x000fe200078e020cULL,
0x000000070f0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000502057210ULL, 0x000fe20007f1e0ffULL,
0x0000000815077824ULL, 0x000fc800078e020cULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000800d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000110047824ULL, 0x102fe200078e020dULL, 0x000000a0000f7810ULL, 0x000fe20007ffe0ffULL,
0x00000020820d7824ULL, 0x000fc600078e020dULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x000000050d0c7c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff804047812ULL, 0x000fc600078ef810ULL,
0x00000001810c7824ULL, 0x000fe400078e020cULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x00005a00ff047a19ULL, 0x000fe4000001160dULL, 0x00000003ff0d7819ULL, 0x000fe4000001160fULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000008504057224ULL, 0x000fe200078e020cULL,
0x00000007100c7812ULL, 0x000fc800078ec0ffULL, 0x0000000502057210ULL, 0x000fe20007f1e0ffULL,
0x0000000815077824ULL, 0x000fc800078e020cULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000800d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010f047824ULL, 0x102fe200078e020dULL, 0x000000c000107810ULL, 0x000fe20007ffe0ffULL,
0x00000020820d7824ULL, 0x000fc600078e020dULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x000000050d0c7c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff804047812ULL, 0x000fc600078ef80fULL,
0x00000001810c7824ULL, 0x000fe400078e020cULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x00005a00ff047a19ULL, 0x000fe4000001160dULL, 0x00000003ff0d7819ULL, 0x000fe40000011610ULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000008504057224ULL, 0x000fe200078e020cULL,
0x000000070f0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000502057210ULL, 0x000fe20007f1e0ffULL,
0x0000000815077824ULL, 0x000fc800078e020cULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000800d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0023ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000d10047210ULL, 0x002fe20007ffe0ffULL, 0x00000020820d7824ULL, 0x000fe200078e020dULL,
0x000000e0000e7810ULL, 0x000fe40007ffe0ffULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x000000050d0c7c12ULL, 0x000fc4000f8e30ffULL, 0x0ffffff804047812ULL, 0x000fe400078ef810ULL,
0x0000000710007812ULL, 0x000fe200078ec0ffULL, 0x00000001810c7824ULL, 0x000fe400078e020cULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x00005a00ff047a19ULL, 0x000fe2000001160dULL,
0x0000000815077824ULL, 0x000fe200078e0200ULL, 0x00000003ff0d7819ULL, 0x000fe4000001160eULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000008504057224ULL, 0x000fc400078e020cULL,
0x000000010e007824ULL, 0x000fc600078e020dULL, 0x0000000502057210ULL, 0x000fe40007f1e0ffULL,
0x0000000700007812ULL, 0x000fc600078ec0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x040fe400078040ffULL, 0xfffffff800007812ULL, 0x000fe400078ef80eULL,
0x00005d0005057a11ULL, 0x000fe400000f440cULL, 0x000000800d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001000047824ULL, 0x002fe400078e0203ULL,
0x00000020820d7824ULL, 0x000fc800078e020dULL, 0x0000000004047984ULL, 0x000e620000000c00ULL,
0x000000050d087c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff007a19ULL, 0x000fc6000001160dULL,
0x0000000181087824ULL, 0x000fc800078e0208ULL, 0x0000008500857224ULL, 0x000fe200078e0208ULL,
0x000000070e007812ULL, 0x000fc800078ec0ffULL, 0x0000008502857210ULL, 0x000fe20007f1e0ffULL,
0x0000000815157824ULL, 0x000fc800078e0200ULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005c0085027a11ULL, 0x000fc800078040ffULL, 0x00005d0085037a11ULL, 0x000fca00000f4408ULL,
0x0000001015027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff037819ULL, 0x000fe2000001169aULL,
0xffffffffff097424ULL, 0x000fc800078e00ffULL, 0x0000000296227824ULL, 0x000fca00078e0203ULL,
0x000000942200720cULL, 0x000fda0003f06070ULL, 0x00000002a1038824ULL, 0x000fc800078e00ffULL,
0x0000680003068a24ULL, 0x002fc800078e0222ULL, 0x0000640006068625ULL, 0x000fe200078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000806098981ULL, 0x000ea2000c1e1900ULL,
0x0000000196087810ULL, 0x000fe20007ffe0ffULL, 0x000000409a9f7824ULL, 0x000fe400078e00ffULL,
0x000000809e9e7824ULL, 0x000fe200078e00ffULL, 0x000000230800720cULL, 0x000fe20003f06070ULL,
0x0000008016217824ULL, 0x000fe200078e00ffULL, 0x0000009f96087211ULL, 0x000fe200078e40ffULL,
0x00000100ff0a7424ULL, 0x000fe200078e00ffULL, 0x01660000ff027f8cULL, 0x000e64000c80043fULL,
0x0000004021257812ULL, 0x000fe200078ef808ULL, 0x0000009e09057224ULL, 0x004fc800078e02ffULL,
0x0000620005067625ULL, 0x000fe400078e000aULL, 0x0000060000008947ULL, 0x000fea0003800000ULL,
0x00000002ff167819ULL, 0x002fe40000011600ULL, 0x0000000895057217ULL, 0x000fe40007800000ULL,
0x00000018161e7810ULL, 0x040fe20007ffe0ffULL, 0x00000001250a7824ULL, 0x000fe200078e0216ULL,
0x00000010161c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000105057824ULL, 0x000fe200078e0a08ULL,
0x0000002016187810ULL, 0x000fe20007ffe0ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000000816147810ULL, 0x000fc40007ffe0ffULL, 0x00000028161a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000125107824ULL, 0x040fe200078e021eULL, 0x000000300a137812ULL, 0x000fe200078ef804ULL,
0x00000001250e7824ULL, 0x000fe200078e021cULL, 0x0000000000197211ULL, 0x000fe200078fe8ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x0000001306127210ULL, 0x000fe40007f1e0ffULL,
0x0000000319197812ULL, 0x000fe200078ec0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000020009a1b7811ULL, 0x000fc400078e68ffULL, 0x0ffffffc19007812ULL, 0x000fe200078ef800ULL,
0x0000000107137824ULL, 0x000fe200000e060bULL, 0x00000030100b7812ULL, 0x000fe200078ef804ULL,
0x00000001250a7824ULL, 0x040fe200078e0218ULL, 0x000000300e157812ULL, 0x000fe200078ef804ULL,
0x00000001250c7824ULL, 0x000fe200078e0214ULL, 0x0000000b06107210ULL, 0x000fe20007f5e0ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x00000015060e7210ULL, 0x000fe40007f3e0ffULL,
0x000000051c00720cULL, 0x000fe20003fa6070ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x000000300a157812ULL, 0x000fc400078ef804ULL, 0x000000051e00720cULL, 0x080fe20003f86070ULL,
0x00000001070f7824ULL, 0x040fe200008e060fULL, 0x000000300c177812ULL, 0x000fe200078ef804ULL,
0x0000000107117824ULL, 0x000fe200010e0611ULL, 0x000000051400720cULL, 0x040fe20003f26070ULL,
0x0000000414087824ULL, 0x000fe200078e00ffULL, 0x0000001506147210ULL, 0x040fe20007f5e0ffULL,
0x00000001250a7824ULL, 0x000fe200078e021aULL, 0x00000017060c7210ULL, 0x000fe20007f1e0ffULL,
0x00000010001d7824ULL, 0x000fe200078e021bULL, 0xfffffffc08087812ULL, 0x000fe200078ee219ULL,
0x0000000107157824ULL, 0x000fe200010e060bULL, 0x0000003016007810ULL, 0x000fe20007ffe0ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x000000051800720cULL, 0x000fc40003f66070ULL,
0x000000051a00720cULL, 0x080fe20003f46070ULL, 0x00000001070d7824ULL, 0x000fe200000e060dULL,
0x000000051600720cULL, 0x000fe20003f06070ULL, 0x00000010081f7824ULL, 0x000fe200078e021bULL,
0x000000300a177812ULL, 0x000fe200078ef804ULL, 0x00000001250a7824ULL, 0x000fe200078e0200ULL,
0x0000003816087810ULL, 0x000fe20007ffe0ffULL, 0x000000041c1c7824ULL, 0x000fe200078e00ffULL,
0x0000001706167210ULL, 0x000fe40007fde0ffULL, 0x000000021e1e7819ULL, 0x000fe200000006ffULL,
0x0000000408207824ULL, 0x000fc400078e00ffULL, 0x0000000107177824ULL, 0x000fe400030e060bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000121d7faeULL, 0x0003e2000c101c48ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x000000050800720cULL, 0x080fe40003f06070ULL,
0x000000000c1f7faeULL, 0x0005e2000c901c48ULL, 0x000000050000720cULL, 0x000fe40003f26070ULL,
0x000000300a057812ULL, 0x000fc800078ef804ULL, 0x00000005060a7210ULL, 0x000fe20007fde0ffULL,
0x0000000418127824ULL, 0x002fe400078e00ffULL, 0x000000041a187824ULL, 0x000fe400078e00ffULL,
0x00000001250c7824ULL, 0x004fe200078e0208ULL, 0xfffffffc1e087812ULL, 0x100fe200078ee219ULL,
0x00000004001a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc1c007812ULL, 0x100fe200078ee219ULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffffc12127812ULL, 0x000fc400078ee219ULL,
0xfffffffc18187812ULL, 0x000fe200078ee219ULL, 0x00000001070b7824ULL, 0x000fe200030e060bULL,
0x000000300c057812ULL, 0x000fe200078ef804ULL, 0x0000001000137824ULL, 0x000fe200078e021bULL,
0xfffffffc1a1a7812ULL, 0x000fe200078ee219ULL, 0x00000010121d7824ULL, 0x000fe200078e021bULL,
0xfffffffc201c7812ULL, 0x000fe200078ee219ULL, 0x0000001008197824ULL, 0x100fe200078e021bULL,
0x0000000506047210ULL, 0x000fe20007fde0ffULL, 0x00000010181f7824ULL, 0x100fe200078e021bULL,
0x000000000e137faeULL, 0x0003e2000e901c48ULL, 0x000000101a257824ULL, 0x000fc400078e021bULL,
0x000000101c1b7824ULL, 0x000fe200078e021bULL, 0x0000000010197faeULL, 0x0003e2000e101c48ULL,
0x0000000107057824ULL, 0x000fc600030e060dULL, 0x00000000141d7faeULL, 0x0003e8000d901c48ULL,
0x00000000161f7faeULL, 0x0003e8000d101c48ULL, 0x000000000a257faeULL, 0x0003e8000c901c48ULL,
0x00000000041b7faeULL, 0x0003e2000c101c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000001000107811ULL, 0x042fe400078ff0ffULL, 0x00000000000c7211ULL, 0x000fc400078fe8ffULL,
0x00000008000e7811ULL, 0x000fe200078ff0ffULL, 0x0000000410167824ULL, 0x000fe200078e00ffULL,
0x00000030000b7811ULL, 0x040fe400078ff0ffULL, 0x00000025000a7211ULL, 0x000fe200078ff0ffULL,
0x000000040e147824ULL, 0x000fe200078e00ffULL, 0x0000001800127811ULL, 0x040fe200078ff0ffULL,
0x00000001251c7824ULL, 0x000fe200078e020bULL, 0x0000002000057811ULL, 0x040fe200078ff0ffULL,
0x000000040b287824ULL, 0x000fe200078e00ffULL, 0x00000038000d7811ULL, 0x000fe200078ff0ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x000000030c177812ULL, 0x000fc400078ec0ffULL,
0x0000002800087811ULL, 0x000fe200078ff0ffULL, 0x00000001250c7824ULL, 0x040fe200078e020eULL,
0x0000000212207819ULL, 0x000fe200000006ffULL, 0x00000001250e7824ULL, 0x040fe200078e0210ULL,
0x000020009a2b7811ULL, 0x000fe200078e68ffULL, 0x0000000125107824ULL, 0x040fe200078e0212ULL,
0x000000300a197812ULL, 0x000fe200078ef804ULL, 0x0000000125127824ULL, 0x000fe200078e0205ULL,
0x0ffffffc17187812ULL, 0x000fe200078ef800ULL, 0x0000000405247824ULL, 0x000fe200078e00ffULL,
0xfffffffc16057812ULL, 0x000fe200078ee217ULL, 0x00000001251e7824ULL, 0x000fe200078e020dULL,
0xfffffffc28167812ULL, 0x100fe200078ee217ULL, 0x000000040d2a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc14007812ULL, 0x000fe200078ee217ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x0000001906147210ULL, 0x000fc40007f1e0ffULL, 0xfffffffc24137812ULL, 0x000fe200078ee217ULL,
0x0000000408267824ULL, 0x000fe400078e00ffULL, 0x000001000e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffffc26157812ULL, 0x000fe200078ee217ULL, 0x00000010051d7824ULL, 0x000fe200078e022bULL,
0x000000300c057812ULL, 0x000fe200078ef804ULL, 0x00000001251a7824ULL, 0x000fe200078e0208ULL,
0xfffffffc20087812ULL, 0x100fe200078ee217ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000300e197812ULL, 0x100fe400078ef804ULL, 0xfffffffc2a177812ULL, 0x000fe200078ee217ULL,
0x0000001016297824ULL, 0x100fe200078e022bULL, 0x0000000506167210ULL, 0x000fe20007f3e0ffULL,
0x0000001018337824ULL, 0x100fe200078e022bULL, 0x0000001906187210ULL, 0x000fe20007f5e0ffULL,
0x00000010001b7824ULL, 0x100fe200078e022bULL, 0x0000003010057812ULL, 0x000fe200078ef804ULL,
0x00000010081f7824ULL, 0x100fe200078e022bULL, 0x0000000f07197210ULL, 0x000fe200017fe4ffULL,
0x0000001013257824ULL, 0x000fc400078e022bULL, 0x0000001015277824ULL, 0x100fe400078e022bULL,
0x00000010172b7824ULL, 0x000fe400078e022bULL, 0x0000000107157824ULL, 0x040fe200000e060bULL,
0x0000000506107210ULL, 0x000fe20007f1e0ffULL, 0x0000000107177824ULL, 0x000fe400008e060dULL,
0x00000100120a7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014337faeULL, 0x0003e6000b901c48ULL, 0x000001001a0c7825ULL, 0x000fe200078e00ffULL,
0x000000300a317812ULL, 0x100fe200078ef804ULL, 0x00000000161b7faeULL, 0x0003e4000b901c48ULL,
0x000001001c0e7825ULL, 0x000fe200078e00ffULL, 0x000000300c2f7812ULL, 0x100fe200078ef804ULL,
0x00000000181d7faeULL, 0x0003e4000b901c48ULL, 0x000001001e127825ULL, 0x000fe200078e00ffULL,
0x000000300e2d7812ULL, 0x000fc400078ef804ULL, 0x0000002f060a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000107117824ULL, 0x040fe200000e0611ULL, 0x0000003012057812ULL, 0x000fe400078ef804ULL,
0x0000003106047210ULL, 0x040fe40007f1e0ffULL, 0x0000002d060c7210ULL, 0x040fe20007f5e0ffULL,
0x00000000101f7faeULL, 0x0003e2000b901c48ULL, 0x0000000506067210ULL, 0x000fe20007f7e0ffULL,
0x0000000107057824ULL, 0x040fe400000e060bULL, 0x00000001070b7824ULL, 0x000fc400008e060dULL,
0x00000001070d7824ULL, 0x040fe200010e060fULL, 0x0000000004257faeULL, 0x0003e2000b901c48ULL,
0x0000000107077824ULL, 0x000fc600018e0613ULL, 0x000000000a277faeULL, 0x0003e8000b901c48ULL,
0x000000000c297faeULL, 0x0003e8000b901c48ULL, 0x00000000062b7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000047805ULL, 0x002fc40000015200ULL,
0x01660400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fc40007804803ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011407ULL,
0x0000000b00007211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000200007819ULL, 0x000fc80000001207ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01660400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000239600720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000207919ULL, 0x000e620000000000ULL, 0x00005800ff1f7624ULL, 0x000fe200078e00ffULL,
0x80005800951e7a10ULL, 0x000fe20007ffe0ffULL, 0x00006800a1a17a24ULL, 0x000fe200078e02ffULL,
0x000166889a9c7811ULL, 0x040fe200078e18ffULL, 0x000000209a9d7824ULL, 0x000fe200078e00ffULL,
0x0000001f1f007810ULL, 0x040fe40007ffe0ffULL, 0xffffffff1f9b7810ULL, 0x000fe40007ffe0ffULL,
0x00000004ff007819ULL, 0x000fc40000011600ULL, 0x000000091f1f7810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff1e7819ULL, 0x000fe4000001161eULL, 0x0ffffffe001d7812ULL, 0x000fc400078ec0ffULL,
0x0000000196007810ULL, 0x040fe20007ffe0ffULL, 0x00000100961c7824ULL, 0x000fe200078e029fULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x00000100ffa07424ULL, 0x000fe200078e00ffULL,
0x000000230000720cULL, 0x000fe20003f06070ULL, 0x000000099e997224ULL, 0x000fe200078e02ffULL,
0x000000401c007812ULL, 0x000fc600078ec0ffULL, 0x0000620099987625ULL, 0x000fc800078e00a0ULL,
0x00000001211b7824ULL, 0x000fc800078e0200ULL, 0x0000064000008947ULL, 0x00cfea0003800000ULL,
0x00000002ff107819ULL, 0x002fe20000011620ULL, 0x00000010201a7824ULL, 0x000fc600078e00ffULL,
0x0000000810147810ULL, 0x040fe20007ffe0ffULL, 0x0000000110027824ULL, 0x100fe200078e021bULL,
0x000000301a1a7812ULL, 0x000fe400078ec0ffULL, 0x0000002010187810ULL, 0x000fe20007ffe0ffULL,
0x0000010002027825ULL, 0x000fe200078e00ffULL, 0x000000401a117812ULL, 0x000fe400078efcffULL,
0x0000001010157810ULL, 0x000fe20007ffe0ffULL, 0x0000000114047824ULL, 0x000fe200078e021bULL,
0x00000011020d7212ULL, 0x000fc400078efcffULL, 0x0000001b180a7210ULL, 0x000fe20007ffe0ffULL,
0x000000011b067824ULL, 0x000fe200078e0215ULL, 0x0000001810167810ULL, 0x000fe20007ffe0ffULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x0000000d980c7210ULL, 0x000fe40007f3e0ffULL,
0x0000002810247810ULL, 0x000fe20007ffe0ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x0000001104137212ULL, 0x000fe400078efcffULL, 0x0000002020047211ULL, 0x000fe200078fe8ffULL,
0x0000000116087824ULL, 0x000fe200078e021bULL, 0x000030009a027811ULL, 0x000fe200078e68ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000000304127812ULL, 0x000fc600078ec0ffULL,
0x00000001990d7824ULL, 0x000fe200008e0603ULL, 0x000000110a037212ULL, 0x080fe200078efcffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x00000011060f7212ULL, 0x000fe400078efcffULL,
0x00000013980e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000124047824ULL, 0x000fe200078e021bULL,
0x00000003980a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000415177824ULL, 0x000fe200078e00ffULL,
0x0000001108137212ULL, 0x000fe400078efcffULL, 0x0000001c95037217ULL, 0x000fe20007800000ULL,
0x00000001990b7824ULL, 0x040fe200018e060bULL, 0x0000000f98067210ULL, 0x040fe20007f5e0ffULL,
0x00000001990f7824ULL, 0x000fe200008e0605ULL, 0x0000001398087210ULL, 0x000fe20007f3e0ffULL,
0x0000000103007824ULL, 0x000fe200078e0a1cULL, 0x0ffffffc20037812ULL, 0x000fe200078ec0ffULL,
0x0000000414057824ULL, 0x000fe200078e00ffULL, 0xfffffffc17177812ULL, 0x000fe200078ee212ULL,
0x0000000199097824ULL, 0x040fe200008e0609ULL, 0x000000001000720cULL, 0x080fe20003f26070ULL,
0x0000000199077824ULL, 0x000fe200010e0607ULL, 0x0000000312137212ULL, 0x000fe200078efcffULL,
0x0000001017177824ULL, 0x000fe200078e0202ULL, 0x000000001500720cULL, 0x000fc40003f66070ULL,
0xfffffffc05157812ULL, 0x000fe200078ee212ULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x000000001400720cULL, 0x080fe40003f46070ULL, 0x0000003010147810ULL, 0x000fe20007ffe0ffULL,
0x0000001013137824ULL, 0x100fe200078e0202ULL, 0x0000001104197212ULL, 0x000fe200078efcffULL,
0x0000001015157824ULL, 0x000fe200078e0202ULL, 0x0000003810107810ULL, 0x000fe20007ffe0ffULL,
0x0000000114047824ULL, 0x000fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c137faeULL, 0x0003e2000c901c48ULL, 0x000000001600720cULL, 0x080fe20003fa6070ULL,
0x0000000414257824ULL, 0x000fe200078e00ffULL, 0x000000001800720cULL, 0x080fe20003f86070ULL,
0x0000000410277824ULL, 0x000fe200078e00ffULL, 0x000000000e157faeULL, 0x0005e2000d101c48ULL,
0x000000001400720cULL, 0x000fc40003f46070ULL, 0x000000001000720cULL, 0x080fe20003f26070ULL,
0x0000000006177faeULL, 0x0007e2000d901c48ULL, 0x000000002400720cULL, 0x000fe40003f66070ULL,
0x00000019980c7210ULL, 0x002fe20007fde0ffULL, 0x0000000424197824ULL, 0x000fe200078e00ffULL,
0xfffffffc25257812ULL, 0x100fe400078ee212ULL, 0xfffffffc27277812ULL, 0x100fe200078ee212ULL,
0x00000001990d7824ULL, 0x000fe200030e0605ULL, 0xfffffffc19197812ULL, 0x000fe200078ee212ULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x0000001b10067210ULL, 0x008fc60007ffe0ffULL,
0x0000000416157824ULL, 0x004fe200078e00ffULL, 0x00000011040f7212ULL, 0x000fe200078efcffULL,
0x0000000418177824ULL, 0x000fe400078e00ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000f98047210ULL, 0x000fe40007fde0ffULL, 0xfffffffc15157812ULL, 0x100fe400078ee212ULL,
0x0000001106137212ULL, 0x000fe200078efcffULL, 0x0000000199057824ULL, 0x000fe200030e0605ULL,
0xfffffffc17177812ULL, 0x000fe200078ee212ULL, 0x00000010150f7824ULL, 0x100fe200078e0202ULL,
0x0000001398067210ULL, 0x000fe20007fde0ffULL, 0x0000001019137824ULL, 0x000fc400078e0202ULL,
0x0000001017117824ULL, 0x100fe200078e0202ULL, 0x00000000080f7faeULL, 0x0003e2000e901c48ULL,
0x0000001025157824ULL, 0x100fe400078e0202ULL, 0x0000001027177824ULL, 0x000fe200078e0202ULL,
0x000000000a117faeULL, 0x0003e2000e101c48ULL, 0x0000000199077824ULL, 0x000fc600030e0607ULL,
0x000000000c137faeULL, 0x0003e8000d901c48ULL, 0x0000000004157faeULL, 0x0003e8000d101c48ULL,
0x0000000006177faeULL, 0x0003e2000c901c48ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x00000010201a7824ULL, 0x042fe200078e00ffULL, 0x00000018200c7811ULL, 0x000fc400078ff0ffULL,
0x00000010200a7811ULL, 0x040fe400078ff0ffULL, 0x0000002820167811ULL, 0x000fe200078ff0ffULL,
0x000000040c0b7824ULL, 0x000fe200078e00ffULL, 0x0000001b20047211ULL, 0x000fe200078ff0ffULL,
0x000000040a097824ULL, 0x000fe200078e00ffULL, 0x0000002020007211ULL, 0x000fe200078fe8ffULL,
0x00000004160f7824ULL, 0x000fe200078e00ffULL, 0x0000000820087811ULL, 0x000fe200078ff0ffULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x000000301a1a7812ULL, 0x000fc400078ec0ffULL,
0x0000000300027812ULL, 0x000fe200078ec0ffULL, 0x0000000108067824ULL, 0x100fe200078e021bULL,
0x0000003820267811ULL, 0x000fe200078ff0ffULL, 0x0000000408077824ULL, 0x000fe200078e00ffULL,
0x000000401a2d7812ULL, 0x000fe200078efcffULL, 0x000000010a087824ULL, 0x100fe200078e021bULL,
0x0000002020147811ULL, 0x000fe200078ff0ffULL, 0x000000010c007824ULL, 0x000fe200078e021bULL,
0x000030009a2b7811ULL, 0x000fe400078e68ffULL, 0x0000003020187811ULL, 0x000fe200078ff0ffULL,
0x00000004140d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b0e7812ULL, 0x000fc400078ee202ULL,
0xfffffffc090c7812ULL, 0x100fe200078ee202ULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0xfffffffc0f127812ULL, 0x100fe400078ee202ULL, 0x0000000226137819ULL, 0x000fe200000006ffULL,
0x0000000418117824ULL, 0x000fe200078e00ffULL, 0x0000002d040f7212ULL, 0x000fe200078efcffULL,
0x000000100e197824ULL, 0x000fe200078e022bULL, 0xfffffffc070a7812ULL, 0x100fe200078ee202ULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0xfffffffc13287812ULL, 0x000fc400078ee202ULL,
0x0000000f980e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001012277824ULL, 0x100fe200078e022bULL,
0x0000002d08137212ULL, 0x080fe200078efcffULL, 0x000000100a157824ULL, 0x000fe200078e022bULL,
0xfffffffc0d107812ULL, 0x100fe200078ee202ULL, 0x00000001990f7824ULL, 0x000fe200008e0605ULL,
0xfffffffc11247812ULL, 0x000fe200078ee202ULL, 0x0000010000047825ULL, 0x000fe200078e00ffULL,
0x0000002d06117212ULL, 0x000fe400078efcffULL, 0x0000001398127210ULL, 0x000fe20007f7e0ffULL,
0x0000001010257824ULL, 0x000fe200078e022bULL, 0x0000001198107210ULL, 0x000fe20007f5e0ffULL,
0x0000000114067824ULL, 0x000fe200078e021bULL, 0x0ffffffc20037812ULL, 0x000fe200078ec0ffULL,
0x0000000199137824ULL, 0x000fe200018e0609ULL, 0x0000002d04097212ULL, 0x000fe200078efcffULL,
0x0000000116087824ULL, 0x000fe200078e021bULL, 0x0000000302027212ULL, 0x000fe200078efcffULL,
0x000000100c177824ULL, 0x000fe200078e022bULL, 0x0000000998047210ULL, 0x000fe20007f3e0ffULL,
0x00000001180a7824ULL, 0x000fc400078e021bULL, 0x0000000199117824ULL, 0x000fe400010e0607ULL,
0x00000001260c7824ULL, 0x000fe400078e021bULL, 0x0000010006067825ULL, 0x000fc800078e00ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x0000002d06337212ULL, 0x000fc600078efcffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000002d08317212ULL, 0x000fc600078efcffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000002d0a2f7212ULL, 0x000fe400078efcffULL,
0x0000003198087210ULL, 0x000fe20007f5e0ffULL, 0x0000000199057824ULL, 0x040fe200008e0605ULL,
0x0000002d0c2d7212ULL, 0x000fe200078efcffULL, 0x0000001002357824ULL, 0x000fe200078e022bULL,
0x0000003398067210ULL, 0x040fe20007f3e0ffULL, 0x0000000199097824ULL, 0x040fe200010e0609ULL,
0x0000002f980a7210ULL, 0x000fe20007f7e0ffULL, 0x0000001024297824ULL, 0x000fe200078e022bULL,
0x0000002d980c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000199077824ULL, 0x040fe200008e0607ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e357faeULL, 0x0003e2000b901c48ULL,
0x0000000b990b7210ULL, 0x000fe20001ffe4ffULL, 0x00000010282b7824ULL, 0x000fc400078e022bULL,
0x0000000010157faeULL, 0x0003e2000b901c48ULL, 0x00000001990d7824ULL, 0x000fc600020e060dULL,
0x0000000012177faeULL, 0x0003e8000b901c48ULL, 0x0000000004197faeULL, 0x0003e8000b901c48ULL,
0x0000000006257faeULL, 0x0003e8000b901c48ULL, 0x0000000008277faeULL, 0x0003e8000b901c48ULL,
0x000000000a297faeULL, 0x0003e8000b901c48ULL, 0x000000000c2b7faeULL, 0x0003e4000b901c48ULL,
0x0000000820197812ULL, 0x002fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000004ff157819ULL, 0x100fe20000011620ULL, 0x000020009a717824ULL, 0x000fe200078e00ffULL,
0x0000000719197812ULL, 0x000fc400078ef820ULL, 0x0000000720057812ULL, 0x000fe200078ec0ffULL,
0x0000000815027824ULL, 0x040fe200078e00ffULL, 0x00000003ff737819ULL, 0x000fe20000011620ULL,
0x0000000115187824ULL, 0x000fe200078e0219ULL, 0x0000001019167812ULL, 0x040fe200078efcffULL,
0x0000001019077824ULL, 0x040fe200078e00ffULL, 0xfffffff802057812ULL, 0x000fe200078ee205ULL,
0x0000001019097824ULL, 0x000fe200078e00ffULL, 0x0000000218007810ULL, 0x000fe20007ffe0ffULL,
0x0000000115157824ULL, 0x000fe200078e0216ULL, 0x0000000173047812ULL, 0x000fe200078ec0ffULL,
0x00000004050b7824ULL, 0x000fe200078e00ffULL, 0xfffffff0070c7812ULL, 0x000fe200078ee200ULL,
0x0000001016067824ULL, 0x040fe200078e00ffULL, 0x0000000405027211ULL, 0x040fe200078ff8ffULL,
0x0000000405277824ULL, 0x040fe200078e00ffULL, 0x0000001005077810ULL, 0x040fe20007ffe0ffULL,
0x0000001016257824ULL, 0x000fe200078e00ffULL, 0x00000020050d7810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000030050f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000407767824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b7a7812ULL, 0x000fe200078ee202ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000202727810ULL, 0x000fe20007ffe0ffULL,
0x000000040f0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff009007812ULL, 0x000fe200078ee218ULL,
0x000000040d097824ULL, 0x000fe200078e00ffULL, 0xfffffff006027812ULL, 0x000fe200078ee215ULL,
0x000000100c0c7824ULL, 0x000fe200078e00ffULL, 0x0000000407057211ULL, 0x080fe200078ff8ffULL,
0x0000001000007824ULL, 0x000fe200078e00ffULL, 0x000000040d067211ULL, 0x080fe200078ff8ffULL,
0x0000001002027824ULL, 0x000fe200078e00ffULL, 0x000000040f047211ULL, 0x000fe200078ff8ffULL,
0x0000000407077824ULL, 0x000fe200078e00ffULL, 0x0000200071177810ULL, 0x000fe20007ffe0ffULL,
0x000000000064783bULL, 0x0003e20000000200ULL, 0xfffffffc76767812ULL, 0x000fe200078ee205ULL,
0x000000040d0d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc09787812ULL, 0x000fe200078ee206ULL,
0x000000107a147824ULL, 0x100fe200078e0217ULL, 0xfffffffc0b747812ULL, 0x000fe200078ee204ULL,
0x0000001076137824ULL, 0x100fe200078e0217ULL, 0x0000001778127211ULL, 0x000fe200078e20ffULL,
0x000000000208783bULL, 0x0005e20000000200ULL, 0x00000002150e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001074117824ULL, 0x000fe200078e0217ULL, 0x0000000205707810ULL, 0x000fe20007ffe0ffULL,
0x000000001468783bULL, 0x000ee20000000200ULL, 0x000000040f0f7824ULL, 0x000fe200078e00ffULL,
0x0000000204007810ULL, 0x002fc40007ffe0ffULL, 0x000000001360783bULL, 0x000e620000000200ULL,
0x0000000206027810ULL, 0x004fe40007ffe0ffULL, 0xfffffff0250e7812ULL, 0x000fe200078ee20eULL,
0x00000000125c783bULL, 0x000ea20000000200ULL, 0xfffffffc27727812ULL, 0x000fe400078ee272ULL,
0xfffffffc07707812ULL, 0x000fe200078ee270ULL, 0x00000000116c783bULL, 0x000f220000000200ULL,
0xfffffffc0d027812ULL, 0x000fe200078ee202ULL, 0x000000100e547824ULL, 0x000fe200078e00ffULL,
0xfffffffc0f007812ULL, 0x000fe200078ee200ULL, 0x0000001072107824ULL, 0x100fe200078e0217ULL,
0x000000000c34783bULL, 0x000fe20000000200ULL, 0x00000010700f7824ULL, 0x000fc400078e0217ULL,
0x00000010020e7824ULL, 0x100fe200078e0217ULL, 0x00000000103c783bULL, 0x000e620000000200ULL,
0x00000010000d7824ULL, 0x000fc600078e0217ULL, 0x000000005454783bULL, 0x000ea80000000200ULL,
0x000000000f44783bULL, 0x000ea80000000200ULL, 0x000000000e4c783bULL, 0x000ea80000000200ULL,
0x000000000d04783bULL, 0x000ea20000000200ULL, 0x000000686458723cULL, 0x088f7000000018ffULL,
0x000000680838723cULL, 0x000f7000000018ffULL, 0x0000006a6424723cULL, 0x040f7000000018ffULL,
0x000000606428723cULL, 0x042f7000000018ffULL, 0x000000626490723cULL, 0x040f7000000018ffULL,
0x0000005c648c723cULL, 0x044f7000000018ffULL, 0x0000005e642c723cULL, 0x000f7000000018ffULL,
0x000000600840723cULL, 0x040f7000000018ffULL, 0x0000005c0848723cULL, 0x040f7000000018ffULL,
0x0000006a0868723cULL, 0x000f7000000018ffULL, 0x0000006c6430723cULL, 0x010f7000000018ffULL,
0x000000620860723cULL, 0x040f7000000018ffULL, 0x0000005e085c723cULL, 0x040f7000000018ffULL,
0x0000006c0850723cULL, 0x000f7000000018ffULL, 0x0000006e6464723cULL, 0x080f7000000018ffULL,
0x0000006e0808723cULL, 0x000f7000000018ffULL, 0x0000003c3458723cULL, 0x0a0b700000001858ULL,
0x0000003c5438723cULL, 0x000b700000001838ULL, 0x0000003e3424723cULL, 0x040b700000001824ULL,
0x000000443428723cULL, 0x040b700000001828ULL, 0x000000463490723cULL, 0x040b700000001890ULL,
0x0000004c348c723cULL, 0x040b70000000188cULL, 0x0000004e342c723cULL, 0x000b70000000182cULL,
0x000000445440723cULL, 0x040b700000001840ULL, 0x0000004c5448723cULL, 0x040b700000001848ULL,
0x0000003e543c723cULL, 0x000b700000001868ULL, 0x000000043430723cULL, 0x000b700000001830ULL,
0x000000465444723cULL, 0x040b700000001860ULL, 0x0000004e544c723cULL, 0x040b70000000185cULL,
0x000000045450723cULL, 0x000b700000001850ULL, 0x000000063434723cULL, 0x080b700000001864ULL,
0x000000065454723cULL, 0x000b620000001808ULL, 0x0000059000008947ULL, 0x000fce0003800000ULL,
0x00000002ff067819ULL, 0x120fe20000011620ULL, 0x00000001730c7824ULL, 0x000fe200078e0220ULL,
0x0000001c95057217ULL, 0x000fc40007800000ULL, 0x0000000806667810ULL, 0x040fe20007ffe0ffULL,
0x0000000106077824ULL, 0x140fe200078e021bULL, 0x0000001006687810ULL, 0x000fe20007ffe0ffULL,
0x0000000105697824ULL, 0x000fe200078e0a1cULL, 0x000000801a047812ULL, 0x000fe200078efcffULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x00000020066c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000166097824ULL, 0x000fe200078e021bULL, 0x00000018066a7810ULL, 0x040fe20007ffe0ffULL,
0x000000011b0b7824ULL, 0x000fe200078e0268ULL, 0x00000028066e7810ULL, 0x040fe20007ffe0ffULL,
0x0000010009087825ULL, 0x000fe200078e0004ULL, 0x00000030067c7810ULL, 0x000fc40007ffe0ffULL,
0x00000038067e7810ULL, 0x000fe20007ffe0ffULL, 0x000000016c5f7824ULL, 0x000fe200078e021bULL,
0x0000000898087210ULL, 0x000fe20007f7e0ffULL, 0x000001000b0a7825ULL, 0x100fe200078e0004ULL,
0x0000001b7c637210ULL, 0x000fe40007ffe0ffULL, 0x000000690600720cULL, 0x080fe20003f26070ULL,
0x000001005f5e7825ULL, 0x000fe200078e0004ULL, 0x0000000a98647210ULL, 0x000fe40007f9e0ffULL,
0x000000030c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000016a5d7824ULL, 0x100fe200078e021bULL,
0x000000697c00720cULL, 0x080fe20003fa6070ULL, 0x000000016e617824ULL, 0x100fe200078e021bULL,
0x000000697e00720cULL, 0x040fe20003fc6070ULL, 0x000000017e657824ULL, 0x000fc400078e021bULL,
0x0000000199097824ULL, 0x000fe200018e0609ULL, 0x0000005e985e7210ULL, 0x000fe20007f7e0ffULL,
0x0000010007067825ULL, 0x000fc800078e0004ULL, 0x000001005d5c7825ULL, 0x000fe200078e0004ULL,
0x0000000698067210ULL, 0x000fc60007f5e0ffULL, 0x0000010061607825ULL, 0x000fc800078e0004ULL,
0x0000010063627825ULL, 0x000fc800078e0004ULL, 0x0000010065047825ULL, 0x000fc800078e0004ULL,
0x0000000199657824ULL, 0x040fe200020e060bULL, 0x000000030c0b7212ULL, 0x000fe200078efcffULL,
0x0000000466037824ULL, 0x000fe200078e00ffULL, 0x0000006098607210ULL, 0x000fe20007f9e0ffULL,
0x00000001995f7824ULL, 0x000fe200018e065fULL, 0x000000696600720cULL, 0x080fe20003f66070ULL,
0x0000000468677824ULL, 0x040fe200078e00ffULL, 0xfffffffc03667812ULL, 0x100fe200078ee20cULL,
0x0000000199617824ULL, 0x040fe200020e0661ULL, 0x000000696800720cULL, 0x000fe20003f86070ULL,
0x0000000199077824ULL, 0x000fe200010e0607ULL, 0xfffffffc67687812ULL, 0x000fe200078ee20cULL,
0x000000100b0a7824ULL, 0x100fe200078e0217ULL, 0x0000005c985c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001066037824ULL, 0x000fc400078e0217ULL, 0x0000001068677824ULL, 0x000fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060a7faeULL, 0x0003e2000c901c48ULL,
0x000000046a6b7824ULL, 0x040fe200078e00ffULL, 0x000000696a00720cULL, 0x080fe20003f26070ULL,
0x00000001995d7824ULL, 0x000fe200010e065dULL, 0x0000000008037faeULL, 0x0005e2000d901c48ULL,
0x0000006298627210ULL, 0x000fe40007f5e0ffULL, 0xfffffffc6b667812ULL, 0x000fe200078ee20cULL,
0x0000000064677faeULL, 0x0007e2000e101c48ULL, 0x000000696c00720cULL, 0x080fe20003f66070ULL,
0x0000000199637824ULL, 0x000fe200010e0663ULL, 0x000000696e00720cULL, 0x000fe20003f86070ULL,
0x0000001066077824ULL, 0x002fe200078e0217ULL, 0x0000000498047210ULL, 0x000fe20007f5e0ffULL,
0x000000046c037824ULL, 0x004fe200078e00ffULL, 0x000000026e097819ULL, 0x000fc400000006ffULL,
0x000000005c077faeULL, 0x0003e2000c901c48ULL, 0x0000000199057824ULL, 0x000fe200010e0605ULL,
0xfffffffc03067812ULL, 0x100fe200078ee20cULL, 0x000000047c657824ULL, 0x008fe200078e00ffULL,
0xfffffffc09087812ULL, 0x100fe200078ee20cULL, 0x000000047e677824ULL, 0x000fe400078e00ffULL,
0x0000001006037824ULL, 0x100fe200078e0217ULL, 0xfffffffc65067812ULL, 0x100fe200078ee20cULL,
0x0000001008097824ULL, 0x000fe200078e0217ULL, 0xfffffffc67647812ULL, 0x000fc400078ee20cULL,
0x000000005e037faeULL, 0x0005e2000d901c48ULL, 0x0000001006077824ULL, 0x102fe400078e0217ULL,
0x00000010645d7824ULL, 0x000fe200078e0217ULL, 0x0000000060097faeULL, 0x0005e8000e101c48ULL,
0x0000000062077faeULL, 0x0005e8000e901c48ULL, 0x00000000045d7faeULL, 0x0005e2000f101c48ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x000000801a627812ULL, 0x020fe200078efcffULL,
0x000000ffff637224ULL, 0x000fe200078e00ffULL, 0x0000001b20057211ULL, 0x000fc400078ff0ffULL,
0x00000018206a7811ULL, 0x040fe400078ff0ffULL, 0x0000000820667811ULL, 0x040fe200078ff0ffULL,
0x0000010005047825ULL, 0x000fe200078e0062ULL, 0x0000001020687811ULL, 0x040fe400078ff0ffULL,
0x00000020206c7811ULL, 0x000fe200078ff0ffULL, 0x000000016a0b7824ULL, 0x100fe200078e021bULL,
0x00000028206e7811ULL, 0x000fe200078ff0ffULL, 0x0000000166077824ULL, 0x000fe200078e021bULL,
0x00000030207c7811ULL, 0x000fe200078ff0ffULL, 0x000001000b0a7825ULL, 0x000fe200078e0062ULL,
0x0000000498047210ULL, 0x000fc40007f3e0ffULL, 0x00000038207e7811ULL, 0x000fe200078ff0ffULL,
0x0000000168097824ULL, 0x100fe200078e021bULL, 0x00000020730c7210ULL, 0x000fe20007ffe0ffULL,
0x000000016c5d7824ULL, 0x100fe400078e021bULL, 0x000000016e5f7824ULL, 0x100fe200078e021bULL,
0x000000030c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000017c617824ULL, 0x000fe400078e021bULL,
0x0000000199057824ULL, 0x000fe200008e0605ULL, 0x0000000a98647210ULL, 0x000fe20007f3e0ffULL,
0x000000017e657824ULL, 0x000fc400078e021bULL, 0x0000010007067825ULL, 0x000fc800078e0062ULL,
0x0000010009087825ULL, 0x000fe200078e0062ULL, 0x0000000698067210ULL, 0x000fc60007f5e0ffULL,
0x000001005d5c7825ULL, 0x000fe200078e0062ULL, 0x0000000898087210ULL, 0x000fc60007f7e0ffULL,
0x000001005f5e7825ULL, 0x000fc800078e0062ULL, 0x0000010061607825ULL, 0x000fc800078e0062ULL,
0x0000000466677824ULL, 0x000fe400078e00ffULL, 0x0000010065627825ULL, 0x000fc600078e0062ULL,
0xfffffffc67667812ULL, 0x100fe200078ee20cULL, 0x0000000199657824ULL, 0x000fe200008e060bULL,
0x000000030c0b7212ULL, 0x000fe200078efcffULL, 0x0000000468037824ULL, 0x000fe200078e00ffULL,
0x0000005e985e7210ULL, 0x000fe20007f3e0ffULL, 0x000000046a677824ULL, 0x000fe400078e00ffULL,
0x000000046c6b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc03687812ULL, 0x100fe200078ee20cULL,
0x0000001066037824ULL, 0x000fe200078e0217ULL, 0xfffffffc67667812ULL, 0x000fe200078ee20cULL,
0x0000000199077824ULL, 0x000fe200010e0607ULL, 0x0000005c985c7210ULL, 0x000fe20007f5e0ffULL,
0x000000100b0a7824ULL, 0x000fc400078e0217ULL, 0x0000001066697824ULL, 0x000fe200078e0217ULL,
0xfffffffc6b667812ULL, 0x000fe200078ee20cULL, 0x000000046e6d7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040a7faeULL, 0x0003e2000b901c48ULL,
0x000000047c6b7824ULL, 0x000fe400078e00ffULL, 0x000000047e6f7824ULL, 0x000fe200078e00ffULL,
0x0000000006037faeULL, 0x0005e2000b901c48ULL, 0x00000001995d7824ULL, 0x040fe200010e065dULL,
0x0000006098607210ULL, 0x000fe20007f5e0ffULL, 0x0000000199097824ULL, 0x000fc400018e0609ULL,
0x00000001995f7824ULL, 0x000fe200008e065fULL, 0x0000006298627210ULL, 0x000fe20007f3e0ffULL,
0x0000001068677824ULL, 0x100fe200078e0217ULL, 0xfffffffc6d047812ULL, 0x102fe200078ee20cULL,
0x0000001066057824ULL, 0x000fe200078e0217ULL, 0xfffffffc6f667812ULL, 0x100fe200078ee20cULL,
0x0000000199617824ULL, 0x000fe200010e0661ULL, 0xfffffffc6b067812ULL, 0x004fe200078ee20cULL,
0x0000001004037824ULL, 0x000fe200078e0217ULL, 0x0000000008677faeULL, 0x0003e2000b901c48ULL,
0x0000000199637824ULL, 0x000fc400008e0663ULL, 0x0000001006077824ULL, 0x000fe200078e0217ULL,
0x0000000064697faeULL, 0x0005e8000b901c48ULL, 0x000000005c057faeULL, 0x0005e2000b901c48ULL,
0x0000001766097211ULL, 0x002fc600078e20ffULL, 0x000000005e037faeULL, 0x0005e8000b901c48ULL,
0x0000000060077faeULL, 0x0005e8000b901c48ULL, 0x0000000062097faeULL, 0x0005e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001016057824ULL, 0x004fe200078e00ffULL,
0x0000000415047810ULL, 0x000fe20007ffe0ffULL, 0x0000001019067824ULL, 0x040fe200078e00ffULL,
0x0000000418037810ULL, 0x000fe20007ffe0ffULL, 0x00000010195d7824ULL, 0x000fe200078e00ffULL,
0x0000300071097810ULL, 0x000fe20007ffe0ffULL, 0x00000010165e7824ULL, 0x000fe200078e00ffULL,
0xfffffff005047812ULL, 0x000fc400078ee204ULL, 0xfffffff006037812ULL, 0x000fe200078ee203ULL,
0x0000001074057824ULL, 0x100fe400078e0209ULL, 0x0000001004747824ULL, 0x000fe200078e00ffULL,
0x0000000618047810ULL, 0x000fe20007ffe0ffULL, 0x000000107a087824ULL, 0x100fe400078e0209ULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0xfffffff05d5c7812ULL, 0x000fe200078ee204ULL,
0x0000001076077824ULL, 0x100fe200078e0209ULL, 0x00000006155d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001078067824ULL, 0x000fc400078e0209ULL, 0x000000105c717824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000884783bULL, 0x000fe20000000200ULL,
0xfffffff05e5d7812ULL, 0x000fe200078ee25dULL, 0x0000001072047824ULL, 0x100fe400078e0209ULL,
0x000000000388783bULL, 0x0002a20000000200ULL, 0x0000001002027824ULL, 0x100fe400078e0209ULL,
0x000000105d5d7824ULL, 0x000fe200078e00ffULL, 0x000000000780783bULL, 0x000ee20000000200ULL,
0x0000001000007824ULL, 0x000fc600078e0209ULL, 0x00000000067c783bULL, 0x000f220000000200ULL,
0x0000001070037824ULL, 0x002fc600078e0209ULL, 0x000000000578783bULL, 0x000e680000000200ULL,
0x000000007474783bULL, 0x000e680000000200ULL, 0x00000000046c783bULL, 0x000fe80000000200ULL,
0x000000007170783bULL, 0x000e680000000200ULL, 0x000000000368783bULL, 0x000e680000000200ULL,
0x000000000264783bULL, 0x000e680000000200ULL, 0x000000000060783bULL, 0x000e680000000200ULL,
0x000000005d5c783bULL, 0x000e620000000200ULL, 0x000000848858723cULL, 0x044f700000001858ULL,
0x000000868824723cULL, 0x040f700000001824ULL, 0x000000808828723cULL, 0x048f700000001828ULL,
0x000000828890723cULL, 0x040f700000001890ULL, 0x0000007c888c723cULL, 0x050f70000000188cULL,
0x0000007e882c723cULL, 0x040f70000000182cULL, 0x000000788830723cULL, 0x042f700000001830ULL,
0x0000007a8834723cULL, 0x000f700000001834ULL, 0x000000847438723cULL, 0x040f700000001838ULL,
0x00000086743c723cULL, 0x040f70000000183cULL, 0x000000807440723cULL, 0x040f700000001840ULL,
0x000000827444723cULL, 0x040f700000001844ULL, 0x0000007c7448723cULL, 0x040f700000001848ULL,
0x0000007e744c723cULL, 0x040f70000000184cULL, 0x000000787450723cULL, 0x040f700000001850ULL,
0x0000007a7454723cULL, 0x000f700000001854ULL, 0x0000006c7058723cULL, 0x060b700000001858ULL,
0x0000006e7024723cULL, 0x040b700000001824ULL, 0x000000687028723cULL, 0x040b700000001828ULL,
0x0000006a7090723cULL, 0x040b700000001890ULL, 0x00000064708c723cULL, 0x040b70000000188cULL,
0x00000066702c723cULL, 0x040b70000000182cULL, 0x000000607030723cULL, 0x040b700000001830ULL,
0x000000627034723cULL, 0x000b700000001834ULL, 0x0000006c5c38723cULL, 0x040b700000001838ULL,
0x0000006e5c3c723cULL, 0x040b70000000183cULL, 0x000000685c40723cULL, 0x040b700000001840ULL,
0x0000006a5c44723cULL, 0x040b700000001844ULL, 0x000000645c48723cULL, 0x040b700000001848ULL,
0x000000665c4c723cULL, 0x040b70000000184cULL, 0x000000605c50723cULL, 0x040b700000001850ULL,
0x000000625c54723cULL, 0x000b620000001854ULL, 0x0000056000008947ULL, 0x000fce0003800000ULL,
0x00000002ff6e7819ULL, 0x020fe20000011620ULL, 0x000000100b0b7824ULL, 0x000fe200078e0209ULL,
0x000000c01a607812ULL, 0x000fc400078efcffULL, 0x000000086e6b7810ULL, 0x040fe20007ffe0ffULL,
0x000000016e5d7824ULL, 0x140fe200078e021bULL, 0x000000ff00617202ULL, 0x000fe40000000f00ULL,
0x000000106e6f7810ULL, 0x040fe20007ffe0ffULL, 0x000000016b5f7824ULL, 0x000fe200078e021bULL,
0x000000186e707810ULL, 0x040fe20007ffe0ffULL, 0x000001005d5c7825ULL, 0x100fe200078e0060ULL,
0x000000206e717810ULL, 0x040fe40007ffe0ffULL, 0x000000286e727810ULL, 0x000fe20007ffe0ffULL,
0x000001005f5e7825ULL, 0x000fe200078e0060ULL, 0x0000005c98667210ULL, 0x000fc40007f1e0ffULL,
0x000000306e737810ULL, 0x000fe20007ffe0ffULL, 0x000000011b637824ULL, 0x000fe200078e026fULL,
0x0000005e98687210ULL, 0x000fe20007f3e0ffULL, 0x0000000199677824ULL, 0x000fe400000e065dULL,
0x00000100635c7825ULL, 0x000fc800078e0060ULL, 0x0000000199697824ULL, 0x000fe200008e065fULL,
0x0000001c955f7217ULL, 0x000fe20007800000ULL, 0x0000000170637824ULL, 0x100fe200078e021bULL,
0x0000005c985c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000171657824ULL, 0x100fe400078e021bULL,
0x00000001726d7824ULL, 0x000fe400078e021bULL, 0x000000015f6c7824ULL, 0x000fe400078e0a1cULL,
0x00000100635e7825ULL, 0x000fc600078e0060ULL, 0x0000006c6e00720cULL, 0x0c0fe20003f46070ULL,
0x0000010065627825ULL, 0x100fe200078e0060ULL, 0x0000006c6b00720cULL, 0x000fe40003f66070ULL,
0x000000386e6e7810ULL, 0x000fe20007ffe0ffULL, 0x000001006d647825ULL, 0x000fe200078e0060ULL,
0x00000062986a7210ULL, 0x000fe40007f3e0ffULL, 0x0000006c6f00720cULL, 0x080fe20003fa6070ULL,
0x000000046b6d7824ULL, 0x000fe200078e00ffULL, 0x0000006c7000720cULL, 0x000fe20003f86070ULL,
0x00000001995d7824ULL, 0x040fe200000e065dULL, 0x0000005e985e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001996b7824ULL, 0x000fe200008e0663ULL, 0xfffffffc6d627812ULL, 0x000fe200078ee20cULL,
0x0000000173637824ULL, 0x140fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000660b7faeULL, 0x0003e2000d101c48ULL, 0x000000016e1b7824ULL, 0x000fe200078e021bULL,
0x0000006c7300720cULL, 0x080fe20003f26070ULL, 0x00000010626d7824ULL, 0x000fe200078e0209ULL,
0x0000006c7200720cULL, 0x000fe20003f46070ULL, 0x00000001995f7824ULL, 0x000fe200000e065fULL,
0x0000006498647210ULL, 0x000fe20007f1e0ffULL, 0x0000010063627825ULL, 0x000fe200078e0060ULL,
0x00000000686d7faeULL, 0x0005e2000d901c48ULL, 0x0000006c7100720cULL, 0x000fc40003f66070ULL,
0x000000046f6f7824ULL, 0x000fe200078e00ffULL, 0x00000002700b7819ULL, 0x002fe200000006ffULL,
0x000001001b607825ULL, 0x000fe200078e0060ULL, 0x0000006298627210ULL, 0x000fe40007fde0ffULL,
0xfffffffc6f667812ULL, 0x100fe200078ee20cULL, 0x0000000471717824ULL, 0x000fe400078e00ffULL,
0x00000004721b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b687812ULL, 0x004fe200078ee20cULL,
0x0000000473737824ULL, 0x000fc400078e00ffULL, 0x0000000199657824ULL, 0x000fe200000e0665ULL,
0x0000006c6e00720cULL, 0x040fe20003f06070ULL, 0x000000046e677824ULL, 0x000fe200078e00ffULL,
0xfffffffc716c7812ULL, 0x100fe200078ee20cULL, 0x0000000199637824ULL, 0x000fe200030e0663ULL,
0xfffffffc1b6e7812ULL, 0x100fe200078ee20cULL, 0x00000010660b7824ULL, 0x100fe200078e0209ULL,
0xfffffffc73707812ULL, 0x100fe200078ee20cULL, 0x00000010681b7824ULL, 0x100fe200078e0209ULL,
0xfffffffc67727812ULL, 0x000fe200078ee20cULL, 0x000000106c677824ULL, 0x100fe200078e0209ULL,
0x0000006098607210ULL, 0x000fe20007fde0ffULL, 0x000000106e697824ULL, 0x100fe200078e0209ULL,
0x000000005c0b7faeULL, 0x0003e2000e901c48ULL, 0x00000010706d7824ULL, 0x000fc400078e0209ULL,
0x0000001072097824ULL, 0x000fe200078e0209ULL, 0x000000005e1b7faeULL, 0x0003e2000e101c48ULL,
0x0000000199617824ULL, 0x000fc600030e0661ULL, 0x000000006a677faeULL, 0x0003e8000d901c48ULL,
0x0000000064697faeULL, 0x0003e8000d101c48ULL, 0x00000000626d7faeULL, 0x0003e8000c901c48ULL,
0x0000000060097faeULL, 0x0003e2000c101c48ULL, 0x000004a000007947ULL, 0x000fea0003800000ULL,
0x00000008206c7811ULL, 0x060fe200078ff0ffULL, 0x000000100b757824ULL, 0x000fe200078e0209ULL,
0x00000010206e7811ULL, 0x000fc400078ff0ffULL, 0x0000001820707811ULL, 0x000fe200078ff0ffULL,
0x000000016c5f7824ULL, 0x100fe200078e021bULL, 0x0000002020727811ULL, 0x000fe200078ff0ffULL,
0x000000016e617824ULL, 0x100fe200078e021bULL, 0x0000002820747811ULL, 0x000fe200078ff0ffULL,
0x0000000170637824ULL, 0x100fe200078e021bULL, 0x0000003020767811ULL, 0x000fe200078ff0ffULL,
0x0000000172657824ULL, 0x100fe200078e021bULL, 0x0000003820787811ULL, 0x000fe200078ff0ffULL,
0x0000000174677824ULL, 0x100fe200078e021bULL, 0x000000c01a6a7812ULL, 0x000fe200078efcffULL,
0x0000000176697824ULL, 0x100fe200078e021bULL, 0x0000001b205d7211ULL, 0x000fe200078ff0ffULL,
0x00000001781b7824ULL, 0x000fe200078e021bULL, 0x000000ff006b7202ULL, 0x000fe20000000f00ULL,
0x000000046c0b7824ULL, 0x000fc400078e00ffULL, 0x00000004706d7824ULL, 0x000fe400078e00ffULL,
0x000001005d5c7825ULL, 0x000fe200078e006aULL, 0xfffffffc0b6c7812ULL, 0x100fe400078ee20cULL,
0xfffffffc6d707812ULL, 0x000fe200078ee20cULL, 0x000001005f5e7825ULL, 0x000fe200078e006aULL,
0x0000005c985c7210ULL, 0x000fc60007f1e0ffULL, 0x0000010061607825ULL, 0x000fe200078e006aULL,
0x0000005e985e7210ULL, 0x000fc60007f3e0ffULL, 0x0000010063627825ULL, 0x000fe200078e006aULL,
0x0000006098607210ULL, 0x000fc60007f5e0ffULL, 0x0000010065647825ULL, 0x000fe200078e006aULL,
0x0000006298627210ULL, 0x000fc60007f7e0ffULL, 0x0000010067667825ULL, 0x000fe200078e006aULL,
0x0000006399637210ULL, 0x000fc60001ffe4ffULL, 0x0000010069687825ULL, 0x000fc800078e006aULL,
0x000001001b6a7825ULL, 0x000fc800078e006aULL, 0x000000046e1b7824ULL, 0x000fe200078e00ffULL,
0x0000006a986a7210ULL, 0x000fe20007f7e0ffULL, 0x00000004726f7824ULL, 0x000fe400078e00ffULL,
0x0000000474717824ULL, 0x000fe200078e00ffULL, 0xfffffffc1b6e7812ULL, 0x100fe200078ee20cULL,
0x0000000476737824ULL, 0x000fe200078e00ffULL, 0xfffffffc6f727812ULL, 0x100fe200078ee20cULL,
0x0000000478777824ULL, 0x000fe200078e00ffULL, 0xfffffffc71747812ULL, 0x100fe200078ee20cULL,
0x00000001995d7824ULL, 0x040fe200000e065dULL, 0x0000006498647210ULL, 0x040fe20007f1e0ffULL,
0x00000001995f7824ULL, 0x040fe200008e065fULL, 0x0000006698667210ULL, 0x000fe20007f3e0ffULL,
0x0000000199617824ULL, 0x000fe200010e0661ULL, 0xfffffffc73767812ULL, 0x100fe200078ee20cULL,
0x000000106c0b7824ULL, 0x100fe200078e0209ULL, 0x0000006898687210ULL, 0x000fe20007f5e0ffULL,
0x000000106e1b7824ULL, 0x100fe200078e0209ULL, 0xfffffffc77787812ULL, 0x000fe200078ee20cULL,
0x00000010706d7824ULL, 0x100fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000005c757faeULL, 0x0003e2000b901c48ULL, 0x00000010726f7824ULL, 0x000fc400078e0209ULL,
0x0000000199657824ULL, 0x040fe200000e0665ULL, 0x000000005e0b7faeULL, 0x0003e2000b901c48ULL,
0x0000001074717824ULL, 0x000fe400078e0209ULL, 0x0000000199677824ULL, 0x040fe200008e0667ULL,
0x00000000601b7faeULL, 0x0003e2000b901c48ULL, 0x0000001076737824ULL, 0x000fe400078e0209ULL,
0x0000000199697824ULL, 0x000fe200010e0669ULL, 0x00000000626d7faeULL, 0x0003e2000b901c48ULL,
0x0000001078097824ULL, 0x000fc400078e0209ULL, 0x00000001996b7824ULL, 0x000fe200018e066bULL,
0x00000000646f7faeULL, 0x0003e8000b901c48ULL, 0x0000000066717faeULL, 0x0003e8000b901c48ULL,
0x0000000068737faeULL, 0x0003e8000b901c48ULL, 0x000000006a097faeULL, 0x0003e4000b901c48ULL,
0x0000000222227810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff097424ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000942200720cULL, 0x000fda0003f06070ULL,
0x00000002a1648824ULL, 0x000fe400078e0222ULL, 0x00000004ff658424ULL, 0x000fc800078e00ffULL,
0x0000640064648625ULL, 0x000fe200078e0065ULL, 0x00000008180b7810ULL, 0x000fe40007ffe0ffULL,
0x00000008151b7810ULL, 0x000fe20007ffe0ffULL, 0x00000010195c7824ULL, 0x000fe200078e00ffULL,
0x0000000864098981ULL, 0x0002a2000c1e1900ULL, 0x00000010165e7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff05c0b7812ULL, 0x000fe200078ee20bULL,
0x0000001019757824ULL, 0x000fe200078e00ffULL, 0xfffffff05e1b7812ULL, 0x000fe200078ee21bULL,
0x000000001268783bULL, 0x000fe20000000200ULL, 0x0000000a18747810ULL, 0x000fe20007ffe0ffULL,
0x000000100b0b7824ULL, 0x000fe400078e00ffULL, 0x000000101b1b7824ULL, 0x000fe200078e00ffULL,
0x000000001364783bULL, 0x002fe20000000200ULL, 0xfffffff075747812ULL, 0x000fe400078ee274ULL,
0x0000000a15757810ULL, 0x000fe20007ffe0ffULL, 0x000000000b60783bULL, 0x000e640000000200ULL,
0x0000001074747824ULL, 0x000fc400078e00ffULL, 0x000000001b6c783bULL, 0x000ee80000000200ULL,
0x00000000145c783bULL, 0x0008e80000000200ULL, 0x000000001170783bULL, 0x000ee20000000200ULL,
0x0000001016147824ULL, 0x010fc600078e00ffULL, 0x000000000f78783bULL, 0x000fe40000000200ULL,
0xfffffff0140b7812ULL, 0x000fe400078ee275ULL, 0x000000001010783bULL, 0x000fe60000000200ULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0x000000007474783bULL, 0x000f280000000200ULL,
0x000000000b80783bULL, 0x000f280000000200ULL, 0x000000000e7c783bULL, 0x0007280000000200ULL,
0x000000000d84783bULL, 0x000f220000000200ULL, 0x000000646028723cULL, 0x082f700000001828ULL,
0x000000646c40723cULL, 0x008f700000001840ULL, 0x0000005c6058723cULL, 0x040f700000001858ULL,
0x0000005e6024723cULL, 0x040f700000001824ULL, 0x000000666090723cULL, 0x040f700000001890ULL,
0x00000068608c723cULL, 0x040f70000000188cULL, 0x0000006a602c723cULL, 0x040f70000000182cULL,
0x000000706030723cULL, 0x040f700000001830ULL, 0x000000726034723cULL, 0x000f700000001834ULL,
0x0000005c6c38723cULL, 0x040f700000001838ULL, 0x0000005e6c3c723cULL, 0x040f70000000183cULL,
0x000000666c44723cULL, 0x040f700000001844ULL, 0x000000686c48723cULL, 0x040f700000001848ULL,
0x0000006a6c4c723cULL, 0x040f70000000184cULL, 0x000000706c50723cULL, 0x040f700000001850ULL,
0x000000726c54723cULL, 0x000f700000001854ULL, 0x000000787428723cULL, 0x0b0f700000001828ULL,
0x000000788040723cULL, 0x000b6e0000001840ULL, 0x0000030096787a10ULL, 0x020fe20007ffe0ffULL,
0x000000107458723cULL, 0x000b660000001858ULL, 0x00000001780e7810ULL, 0x040fe20007ffe0ffULL,
0x0000010078147824ULL, 0x000fc600078e029fULL, 0x000000230e00720cULL, 0x000fe20003f06070ULL,
0x000000127424723cULL, 0x000b620000001824ULL, 0x00000040140e7812ULL, 0x000fca00078ec0ffULL,
0x0000000121677824ULL, 0x000fe400078e020eULL, 0x0000007a7490723cULL, 0x040b700000001890ULL,
0x0000007c748c723cULL, 0x040b70000000188cULL, 0x0000007e742c723cULL, 0x040b70000000182cULL,
0x000000847430723cULL, 0x040b700000001830ULL, 0x000000867434723cULL, 0x000b700000001834ULL,
0x000000108038723cULL, 0x040b700000001838ULL, 0x00000012803c723cULL, 0x040b70000000183cULL,
0x0000007a8044723cULL, 0x040b700000001844ULL, 0x0000007c8048723cULL, 0x040b700000001848ULL,
0x0000007e804c723cULL, 0x040b70000000184cULL, 0x000000848050723cULL, 0x000b620000001850ULL,
0x0000009e090f7224ULL, 0x004fc800078e02ffULL, 0x000062000f0e7625ULL, 0x000fc600078e00a0ULL,
0x000000868054723cULL, 0x000b620000001854ULL, 0x000005b000008947ULL, 0x000fce0003800000ULL,
0x00000002ff647819ULL, 0x000fe40000011620ULL, 0x00000014950b7217ULL, 0x000fe40007800000ULL,
0x0000000864627810ULL, 0x040fe20007ffe0ffULL, 0x0000000164107824ULL, 0x060fe200078e0267ULL,
0x0000001064667810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0b7824ULL, 0x000fe200078e0a14ULL,
0x0000006762127210ULL, 0x000fe20007ffe0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x0000001864687810ULL, 0x000fc40007ffe0ffULL, 0x00000020646a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001675c7824ULL, 0x000fe200078e0266ULL, 0x0000001a105f7212ULL, 0x080fe200078efcffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x00000028646c7810ULL, 0x000fe40007ffe0ffULL,
0x0000005f0e5e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000168107824ULL, 0x000fe200078e0267ULL,
0x0000001a12617212ULL, 0x000fe200078efcffULL, 0x000001005c5c7825ULL, 0x000fe200078e00ffULL,
0x00000038646e7810ULL, 0x000fc40007ffe0ffULL, 0x000000610e607210ULL, 0x000fe20007f3e0ffULL,
0x000000010f5f7824ULL, 0x040fe200000e0611ULL, 0x0000001a5c0d7212ULL, 0x080fe200078efcffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x0000000b6600720cULL, 0x000fe40003fa6070ULL,
0x0000000d0e5c7210ULL, 0x000fe20007f1e0ffULL, 0x000000016a127824ULL, 0x000fe200078e0267ULL,
0x0000001a10637212ULL, 0x000fe200078efcffULL, 0x000000010f617824ULL, 0x000fe200008e0613ULL,
0x0000000b6200720cULL, 0x040fe20003f26070ULL, 0x00000004621b7824ULL, 0x000fe200078e00ffULL,
0x000000630e627210ULL, 0x000fe20007f5e0ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000000b6800720cULL, 0x000fc40003f86070ULL, 0xfffffffc1b147812ULL, 0x000fe200078ee20cULL,
0x000000010f5d7824ULL, 0x040fe200000e065dULL, 0x0000000b6400720cULL, 0x080fe20003f06070ULL,
0x000000016c107824ULL, 0x000fe200078e0267ULL, 0x0000001a120d7212ULL, 0x000fe200078efcffULL,
0x000000010f637824ULL, 0x000fe200010e0611ULL, 0x0000000b6c00720cULL, 0x000fe20003f46070ULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x0000000d0e127210ULL, 0x000fc60007f7e0ffULL,
0x00000010140d7824ULL, 0x000fe200078e0217ULL, 0x0000001a10657212ULL, 0x000fe200078efcffULL,
0x000000010f137824ULL, 0x040fe200018e0613ULL, 0x0000003064147810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000005e0a7faeULL, 0x0003e2000c101c48ULL,
0x000000650e647210ULL, 0x000fe20007fde0ffULL, 0x000000016e107824ULL, 0x000fe200078e0267ULL,
0x0000000b6a00720cULL, 0x080fe20003f66070ULL, 0x00000000600d7faeULL, 0x0005e2000c901c48ULL,
0x0000000b1400720cULL, 0x080fe20003f26070ULL, 0x000000010f657824ULL, 0x000fe200030e0611ULL,
0x0000000b6e00720cULL, 0x000fe20003f06070ULL, 0x0000000468117824ULL, 0x000fc400078e00ffULL,
0x000000046a1b7824ULL, 0x000fe400078e00ffULL, 0x00000001140a7824ULL, 0x002fe200078e0267ULL,
0xfffffffc115e7812ULL, 0x000fe200078ee20cULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x0000000214617819ULL, 0x004fc600000006ffULL, 0x00000004660d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1b607812ULL, 0x100fe200078ee20cULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffffc61687812ULL, 0x100fe400078ee20cULL, 0xfffffffc0d147812ULL, 0x100fe200078ee20cULL,
0x000000046c5f7824ULL, 0x000fe200078e00ffULL, 0x0000001a0a0d7212ULL, 0x080fe200078efcffULL,
0x000000046e677824ULL, 0x000fe400078e00ffULL, 0x00000010141b7824ULL, 0x100fe200078e0217ULL,
0x0000000d0e0a7210ULL, 0x000fe20007fde0ffULL, 0x0000001060617824ULL, 0x100fe200078e0217ULL,
0x0000001a100d7212ULL, 0x000fe200078efcffULL, 0x0000001068697824ULL, 0x000fe200078e0217ULL,
0xfffffffc5f667812ULL, 0x100fe200078ee20cULL, 0x000000010f0b7824ULL, 0x000fe200030e060bULL,
0xfffffffc676a7812ULL, 0x000fe200078ee20cULL, 0x000000105e5f7824ULL, 0x100fe200078e0217ULL,
0x0000000d0e0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001066677824ULL, 0x100fe200078e0217ULL,
0x000000005c1b7faeULL, 0x0003e2000e901c48ULL, 0x000000106a177824ULL, 0x000fc400078e0217ULL,
0x000000010f0d7824ULL, 0x000fe200030e0611ULL, 0x00000000625f7faeULL, 0x0003e8000e101c48ULL,
0x0000000012617faeULL, 0x0003e8000d901c48ULL, 0x0000000064677faeULL, 0x0003e8000d101c48ULL,
0x000000000a697faeULL, 0x0003e8000c901c48ULL, 0x000000000c177faeULL, 0x0003e2000c101c48ULL,
0x000004f000007947ULL, 0x000fea0003800000ULL, 0x0000000820127811ULL, 0x060fe400078ff0ffULL,
0x0000001020147811ULL, 0x000fc400078ff0ffULL, 0x00000018205e7811ULL, 0x000fe200078ff0ffULL,
0x00000001120d7824ULL, 0x100fe200078e0267ULL, 0x0000002020607811ULL, 0x000fe200078ff0ffULL,
0x0000000412137824ULL, 0x000fe200078e00ffULL, 0x0000003020647811ULL, 0x000fe200078ff0ffULL,
0x0000000114127824ULL, 0x100fe200078e0267ULL, 0x0000003820667811ULL, 0x000fe200078ff0ffULL,
0x00000004145d7824ULL, 0x000fe200078e00ffULL, 0x0000002820627811ULL, 0x000fe200078ff0ffULL,
0x000000015e5c7824ULL, 0x100fe200078e0267ULL, 0x0000006720107211ULL, 0x080fe200078ff0ffULL,
0x000000045e5f7824ULL, 0x000fe200078e00ffULL, 0x0000006762147210ULL, 0x000fe20007ffe0ffULL,
0x00000001600b7824ULL, 0x000fc400078e0267ULL, 0x00000001641b7824ULL, 0x100fe400078e0267ULL,
0x00000001665e7824ULL, 0x000fe400078e0267ULL, 0x0000000460617824ULL, 0x000fe400078e00ffULL,
0x0000000462637824ULL, 0x000fe200078e00ffULL, 0xfffffffc13627812ULL, 0x100fe200078ee20cULL,
0x0000000464657824ULL, 0x000fe200078e00ffULL, 0xfffffffc5d647812ULL, 0x100fe200078ee20cULL,
0x0000000466677824ULL, 0x000fe200078e00ffULL, 0xfffffffc5f667812ULL, 0x100fe200078ee20cULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0xfffffffc61687812ULL, 0x000fc400078ee20cULL,
0xfffffffc636a7812ULL, 0x100fe200078ee20cULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0xfffffffc656c7812ULL, 0x100fe400078ee20cULL, 0xfffffffc676e7812ULL, 0x000fe200078ee20cULL,
0x000001000d0c7825ULL, 0x000fe200078e00ffULL, 0x0000001a10617212ULL, 0x080fe400078efcffULL,
0x0000001a12657212ULL, 0x000fe200078efcffULL, 0x000001005c5c7825ULL, 0x000fe200078e00ffULL,
0x000000610e607210ULL, 0x000fc40007f1e0ffULL, 0x0000001a0c637212ULL, 0x080fe200078efcffULL,
0x0000001062697824ULL, 0x100fe400078e0217ULL, 0x00000010646b7824ULL, 0x000fe200078e0217ULL,
0x000000630e627210ULL, 0x040fe20007f3e0ffULL, 0x000000010f617824ULL, 0x040fe200000e0611ULL,
0x000000650e647210ULL, 0x000fe20007f5e0ffULL, 0x000001005e5e7825ULL, 0x000fe200078e00ffULL,
0x0000001a5c117212ULL, 0x080fe400078efcffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000600a7faeULL, 0x0003e2000b901c48ULL, 0x000000010f637824ULL, 0x000fe200008e060dULL,
0x000000110e5c7210ULL, 0x000fe20007f1e0ffULL, 0x000001000b0c7825ULL, 0x000fe200078e00ffULL,
0x0000001a5e0b7212ULL, 0x000fc400078efcffULL, 0x0000000062697faeULL, 0x0003e2000b901c48ULL,
0x000000010f657824ULL, 0x000fe200010e0613ULL, 0x0000001a0c677212ULL, 0x000fe200078efcffULL,
0x0000010014107825ULL, 0x000fc600078e00ffULL, 0x00000000646b7faeULL, 0x0003e2000b901c48ULL,
0x000001001b127825ULL, 0x000fe200078e00ffULL, 0x0000001a101b7212ULL, 0x000fc600078efcffULL,
0x00000010666d7824ULL, 0x100fe200078e0217ULL, 0x0000001b0e107210ULL, 0x000fe20007f3e0ffULL,
0x00000010686f7824ULL, 0x100fe400078e0217ULL, 0x000000106a717824ULL, 0x100fe400078e0217ULL,
0x000000106c737824ULL, 0x100fe400078e0217ULL, 0x000000106e757824ULL, 0x000fe200078e0217ULL,
0x0000001a12177212ULL, 0x000fe200078efcffULL, 0x000000010f5d7824ULL, 0x040fe200000e065dULL,
0x000000670e0c7210ULL, 0x040fe20007f1e0ffULL, 0x000000010f117824ULL, 0x000fe200008e0611ULL,
0x000000170e127210ULL, 0x000fc40007f5e0ffULL, 0x0000000b0e0e7210ULL, 0x000fe20007f7e0ffULL,
0x000000010f0d7824ULL, 0x040fe200000e060dULL, 0x000000130f137210ULL, 0x040fe200017fe4ffULL,
0x000000005c6d7faeULL, 0x0003e4000b901c48ULL, 0x000000010f0f7824ULL, 0x000fe400018e065fULL,
0x000000000c6f7faeULL, 0x0003e8000b901c48ULL, 0x0000000010717faeULL, 0x0003e8000b901c48ULL,
0x0000000012737faeULL, 0x0003e8000b901c48ULL, 0x000000000e757faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000010190b7824ULL, 0x002fe200078e00ffULL,
0x0000000c180a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001016147824ULL, 0x000fc400078e00ffULL,
0x0000001019177824ULL, 0x000fe200078e00ffULL, 0xfffffff00b0a7812ULL, 0x000fe200078ee20aULL,
0x0000001016167824ULL, 0x000fe200078e00ffULL, 0x0000000c150b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000e15157810ULL, 0x000fe20007ffe0ffULL, 0x000000100a0a7824ULL, 0x000fe200078e00ffULL,
0xfffffff0140b7812ULL, 0x000fe400078ee20bULL, 0x0000000e18147810ULL, 0x000fc60007ffe0ffULL,
0x000000100b0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff017147812ULL, 0x000fca00078ee214ULL,
0x00000010146c7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000000080c783bULL, 0x000fe80000000200ULL, 0x000000000a10783bULL, 0x000e680000000200ULL,
0x00000000075c783bULL, 0x0004e80000000200ULL, 0x000000000b60783bULL, 0x000f280000000200ULL,
0x000000000618783bULL, 0x000ee20000000200ULL, 0xfffffff016077812ULL, 0x004fc600078ee215ULL,
0x000000000564783bULL, 0x000ea40000000200ULL, 0x0000001007087824ULL, 0x000fe400078e00ffULL,
0x000000000468783bULL, 0x0003e80000000200ULL, 0x000000006c6c783bULL, 0x000ea80000000200ULL,
0x000000000314783bULL, 0x000ea80000000200ULL, 0x000000000270783bULL, 0x000ea80000000200ULL,
0x000000000074783bULL, 0x000fe20000000200ULL, 0x0000000c107c723cULL, 0x042be60000001858ULL,
0x000000000858783bULL, 0x02026a0000000200ULL, 0x0000000e1024723cULL, 0x040f700000001824ULL,
0x0000005c1028723cULL, 0x008f700000001828ULL, 0x0000000c6038723cULL, 0x050ff00000001838ULL,
0x0000000e603c723cULL, 0x000ff0000000183cULL, 0x0000005e1090723cULL, 0x040f700000001890ULL,
0x00000018108c723cULL, 0x040ff0000000188cULL, 0x0000001a102c723cULL, 0x040ff0000000182cULL,
0x000000641030723cULL, 0x044ff00000001830ULL, 0x000000661034723cULL, 0x000ff00000001834ULL,
0x0000005c6004723cULL, 0x040ff00000001840ULL, 0x00000018600c723cULL, 0x040ff00000001848ULL,
0x0000005e6044723cULL, 0x040ff00000001844ULL, 0x0000001a604c723cULL, 0x040ff0000000184cULL,
0x000000646010723cULL, 0x040ff00000001850ULL, 0x000000666054723cULL, 0x000ff00000001854ULL,
0x0000006a6c24723cULL, 0x060f700000001824ULL, 0x000000146c28723cULL, 0x040f700000001828ULL,
0x000000686c7c723cULL, 0x040f70000000187cULL, 0x000000166c90723cULL, 0x000f640000001890ULL,
0x3db504f324087820ULL, 0x022fe20000410000ULL, 0x3db504f3250a7820ULL, 0x000fe20000410000ULL,
0x3db504f326197820ULL, 0x000fe20000410000ULL, 0x3db504f3271b7820ULL, 0x000fc60000410000ULL,
0x000000706c8c723cULL, 0x000f62000000188cULL, 0x3db504f32a247820ULL, 0x000fe20000410000ULL,
0x3db504f32b257820ULL, 0x000fe20000410000ULL, 0x3db504f3280b7820ULL, 0x000fe20000410000ULL,
0x3db504f329297820ULL, 0x000fc80000410000ULL, 0x000000726c2c723cULL, 0x000f62000000182cULL,
0x3db504f37c037820ULL, 0x000fe20000410000ULL, 0x3db504f37d027820ULL, 0x000fe20000410000ULL,
0x3db504f37e7e7820ULL, 0x000fe20000410000ULL, 0x3db504f37f187820ULL, 0x000fc80000410000ULL,
0x000000685838723cULL, 0x000f620000001838ULL, 0x3db504f390907820ULL, 0x000fe20000410000ULL,
0x3db504f391917820ULL, 0x000fe20000410000ULL, 0x3db504f392267820ULL, 0x000fe20000410000ULL,
0x3db504f393277820ULL, 0x000fc80000410000ULL, 0x000000145804723cULL, 0x000f640000001804ULL,
0x3db504f38c8c7820ULL, 0x020fe20000410000ULL, 0x3db504f38d8d7820ULL, 0x000fe20000410000ULL,
0x3db504f38e287820ULL, 0x000fe20000410000ULL, 0x3db504f38f8f7820ULL, 0x000fc60000410000ULL,
0x00000070580c723cULL, 0x000f62000000180cULL, 0x3db504f32e2a7820ULL, 0x000fe20000410000ULL,
0x3db504f32f2b7820ULL, 0x000fe20000410000ULL, 0x3db504f32c2c7820ULL, 0x000fe20000410000ULL,
0x3db504f32d2d7820ULL, 0x000fc80000410000ULL, 0x000000766c34723cULL, 0x000f620000001834ULL,
0x3db504f33b487820ULL, 0x000fe20000410000ULL, 0x3db504f338387820ULL, 0x000fe20000410000ULL,
0x3db504f339397820ULL, 0x000fca0000410000ULL, 0x0000006a5868723cULL, 0x000f62000000183cULL,
0x3db504f304047820ULL, 0x000fe20000410000ULL, 0x3db504f305057820ULL, 0x000fcc0000410000ULL,
0x000000165814723cULL, 0x000b640000001844ULL, 0x3db504f30c007820ULL, 0x020fe20000410000ULL,
0x3db504f30e4a7820ULL, 0x000fe20000410000ULL, 0x3db504f30f3b7820ULL, 0x000fc60000410000ULL,
0x3db504f33a447820ULL, 0x000fe20000410000ULL, 0x000000725870723cULL, 0x000b62000000184cULL,
0x3db504f3362e7820ULL, 0x000fe20000410000ULL, 0x3db504f3372f7820ULL, 0x000fe20000410000ULL,
0x3db504f334347820ULL, 0x000fe20000410000ULL, 0x3db504f335357820ULL, 0x000fc60000410000ULL,
0x3db504f3064d7820ULL, 0x020fe20000410000ULL, 0x000000745810723cULL, 0x080f620000001810ULL,
0x3db504f368687820ULL, 0x000fe20000410000ULL, 0x3db504f369697820ULL, 0x000fe20000410000ULL,
0x3db504f36a497820ULL, 0x000fe20000410000ULL, 0x3db504f36b4b7820ULL, 0x000fe20000410000ULL,
0x3db504f3074e7820ULL, 0x000fe20000410000ULL, 0x3db504f30d067820ULL, 0x000fe40000410000ULL,
0x000000746c30723cULL, 0x000f620000001830ULL, 0x3db504f314367820ULL, 0x000fe20000410000ULL,
0x3db504f315377820ULL, 0x000fe20000410000ULL, 0x3db504f3164f7820ULL, 0x000fe20000410000ULL,
0x3db504f3174c7820ULL, 0x000fc80000410000ULL, 0x000000765858723cULL, 0x000f620000001854ULL,
0x3db504f3703a7820ULL, 0x000fe20000410000ULL, 0x3db504f3713c7820ULL, 0x000fe20000410000ULL,
0x3db504f3723d7820ULL, 0x000fe20000410000ULL, 0x3db504f3733e7820ULL, 0x000fc80000410000ULL,
0x3db504f3103f7820ULL, 0x020fe20000410000ULL, 0x3db504f311407820ULL, 0x000fe20000410000ULL,
0x3db504f312417820ULL, 0x000fe20000410000ULL, 0x3db504f313437820ULL, 0x000fca0000410000ULL,
0x3db504f330307820ULL, 0x000fe20000410000ULL, 0x3db504f331317820ULL, 0x000fe20000410000ULL,
0x3db504f332327820ULL, 0x000fe20000410000ULL, 0x3db504f333337820ULL, 0x000fca0000410000ULL,
0x3db504f358427820ULL, 0x000fe20000410000ULL, 0x3db504f359457820ULL, 0x000fe20000410000ULL,
0x3db504f35a467820ULL, 0x000fe20000410000ULL, 0x3db504f35b477820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000009c507f8cULL, 0x0002a2000c80043fULL,
0x000000ffff177224ULL, 0x000fe200078e002cULL, 0x0000003400137202ULL, 0x000fe20000000f00ULL,
0x000000ffff157224ULL, 0x000fe400078e002dULL, 0x000000ffff167224ULL, 0x000fe400078e0030ULL,
0x000000ffff127224ULL, 0x000fc400078e0031ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0029ULL,
0x000000ffff117224ULL, 0x000fe400078e0035ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0032ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0033ULL, 0x000000ffff317224ULL, 0x000fe400078e0038ULL,
0x000000ffff307224ULL, 0x000fc400078e0039ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0090ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0091ULL, 0x000000ffff0f7224ULL, 0x000fe400078e008cULL,
0x000000ffff147224ULL, 0x000fe400078e008dULL, 0x000000ffff107224ULL, 0x000fe400078e007eULL,
0x000000ffff297224ULL, 0x000fc400078e008fULL, 0x000000ffff327224ULL, 0x000fe400078e0068ULL,
0x000000ffff337224ULL, 0x000fe400078e0069ULL, 0x000000ffff347224ULL, 0x000fe400078e0004ULL,
0x000000ffff357224ULL, 0x000fe400078e0005ULL, 0x000000ffff387224ULL, 0x000fe400078e0000ULL,
0x000000ffff397224ULL, 0x000fc400078e0006ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x000004009c077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fc40007804851ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604537210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09005300780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c405300780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011407ULL,
0x0000005300007211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000200007819ULL, 0x000fc80000001207ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011a1a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004009c077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804851ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004201a7824ULL, 0x000fe200078e00ffULL, 0x0000001e9600720cULL, 0x000fc80003f06070ULL,
0xfffffff01a057812ULL, 0x000fca00078ec0ffULL, 0x000000809a007824ULL, 0x000fca00078e0205ULL,
0x0164000000047984ULL, 0x0002a20000000c00ULL, 0x00001f5000008947ULL, 0x000fea0003800000ULL,
0x0000000120517819ULL, 0x040fe200000006ffULL, 0x00000002ff6e7424ULL, 0x000fe200078e00ffULL,
0x0000001c95537217ULL, 0x000fe40007800000ULL, 0x0000009720507211ULL, 0x000fe400078ff0ffULL,
0x0000000651517812ULL, 0x000fe200078ec0ffULL, 0x00000001531c7824ULL, 0x000fe200078e0a1cULL,
0x0000000850537810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff527a19ULL, 0x000fe20000011650ULL,
0x000000011f557824ULL, 0x000fe200078e0251ULL, 0x00005a00ff567a19ULL, 0x000fc40000011653ULL,
0x0000580051537a10ULL, 0x000fe20007ffe0ffULL, 0x0000000155547824ULL, 0x100fe200078e0a1cULL,
0x0000001050577810ULL, 0x040fe40007ffe0ffULL, 0x0000001850587810ULL, 0x000fe20007ffe0ffULL,
0x0000000153507824ULL, 0x000fe200078e0a1cULL, 0x000000549b547217ULL, 0x040fe40003800000ULL,
0x000000529b527217ULL, 0x000fe40003800000ULL, 0x0000001c5500720cULL, 0x000fc40003f26070ULL,
0x00000004ff547819ULL, 0x000fe20000011654ULL, 0x000000521d7d7224ULL, 0x000fe200078e02ffULL,
0x0000001c5300720cULL, 0x000fe40003f06070ULL, 0x000000509b507217ULL, 0x040fe40003800000ULL,
0x000000ff545a7207ULL, 0x000fe40000800000ULL, 0x000000ff50687207ULL, 0x000fe40000000000ULL,
0x000000569b567217ULL, 0x000fe20003800000ULL, 0x000000017d557824ULL, 0x000fe200078e025aULL,
0x00005a00ff507a19ULL, 0x000fc40000011657ULL, 0x0000007d68577211ULL, 0x040fe200078fe0ffULL,
0x000000561d7f7224ULL, 0x000fe200078e02ffULL, 0x000000509b507217ULL, 0x000fe20003800000ULL,
0x0000600055547625ULL, 0x080fe200078e006eULL, 0x00005a00ff587a19ULL, 0x000fe40000011658ULL,
0x0000001051637812ULL, 0x000fe200078efcffULL, 0x0000600057567625ULL, 0x000fe200078e006eULL,
0x000000589b527217ULL, 0x000fe20003800000ULL, 0x0000000854557981ULL, 0x000722000c1e9500ULL,
0x0000007f68597211ULL, 0x000fe200078fe0ffULL, 0x000000501d817224ULL, 0x000fc400078e02ffULL,
0x0000000856507981ULL, 0x000322000c1e9500ULL, 0x000000011f697824ULL, 0x000fe400078e0263ULL,
0x000000521d837224ULL, 0x000fe200078e02ffULL, 0x00000081685d7211ULL, 0x000fe200078fe0ffULL,
0x000000015a5b7824ULL, 0x040fe400078e027fULL, 0x000000015a5f7824ULL, 0x000fe400078e0281ULL,
0x0000600059587625ULL, 0x000fe200078e006eULL, 0x0000580063657a10ULL, 0x000fc60007ffe0ffULL,
0x0000000169627824ULL, 0x000fe200078e0a1cULL, 0x0000000858527981ULL, 0x000522000c1e9500ULL,
0x000000015a617824ULL, 0x000fe400078e0283ULL, 0x000060005d5c7625ULL, 0x000fe200078e006eULL,
0x000000629b627217ULL, 0x000fc60003800000ULL, 0x000060005b5a7625ULL, 0x080fe200078e006eULL,
0x000000085c547981ULL, 0x008726000c1e9500ULL, 0x000060005f5e7625ULL, 0x080fe200078e006eULL,
0x000000085a577981ULL, 0x002326000c1e9500ULL, 0x0000600061587625ULL, 0x004fe400078e006eULL,
0x000000085e617981ULL, 0x000522000c1e9500ULL, 0x0000001c6900720cULL, 0x000fe20003f26070ULL,
0x0000000165607824ULL, 0x000fe200078e0a1cULL, 0x00000004ff627819ULL, 0x000fe20000011662ULL,
0x0000000858677981ULL, 0x000322000c1e9500ULL, 0x00000083686b7211ULL, 0x000fc400078fe0ffULL,
0x0000001c6500720cULL, 0x000fe40003f06070ULL, 0x000000609b607217ULL, 0x000fe40003800000ULL,
0x000000ff625e7207ULL, 0x004fe20000800000ULL, 0x000060006b6a7625ULL, 0x000fe200078e006eULL,
0x000000ff60747207ULL, 0x000fc60000000000ULL, 0x000000017d5b7824ULL, 0x002fe200078e025eULL,
0x000000086a567981ULL, 0x0002a2000c1e9500ULL, 0x0000007d74597211ULL, 0x040fe400078fe0ffULL,
0x000060005b5a7625ULL, 0x080fe200078e006eULL, 0x0000007f745d7211ULL, 0x008fe400078fe0ffULL,
0x0000002051737812ULL, 0x000fe200078efcffULL, 0x000000015e5f7824ULL, 0x000fe200078e027fULL,
0x000000085a697981ULL, 0x0006a2000c1e9500ULL, 0x0000600059587625ULL, 0x000fc800078e006eULL,
0x000000015e6f7824ULL, 0x040fe200078e0281ULL, 0x0000000858607981ULL, 0x0002a2000c1e9500ULL,
0x000000015e717824ULL, 0x000fe400078e0283ULL, 0x000060005d5c7625ULL, 0x000fc800078e006eULL,
0x000060005f5e7625ULL, 0x080fe200078e006eULL, 0x000000085c627981ULL, 0x0002a6000c1e9500ULL,
0x000000011f5b7824ULL, 0x008fe200078e0273ULL, 0x0000580073757a10ULL, 0x000fe20007ffe0ffULL,
0x000060006f587625ULL, 0x002fe400078e006eULL, 0x000000085e6f7981ULL, 0x0002e4000c1e9500ULL,
0x000000015b707824ULL, 0x000fe200078e0a1cULL, 0x00000081746b7211ULL, 0x000fc400078fe0ffULL,
0x00000083746d7211ULL, 0x000fe400078fe0ffULL, 0x000000751c5a7210ULL, 0x000fe40007ffe1ffULL,
0x000000709b707217ULL, 0x000fe20003800000ULL, 0x000060006b6a7625ULL, 0x000fe200078e006eULL,
0x0000001c7500720cULL, 0x000fe40003f06070ULL, 0x0000005a9b5a7217ULL, 0x000fe20003800000ULL,
0x000060006d6c7625ULL, 0x000fe200078e006eULL, 0x0000001c5b00720cULL, 0x000fe20003f26070ULL,
0x000000086a647981ULL, 0x0002e2000c1e9500ULL, 0x00000004ff707819ULL, 0x000fe20000011670ULL,
0x00006000715c7625ULL, 0x000fe200078e006eULL, 0x000000ff5a7c7207ULL, 0x000fe20000000000ULL,
0x0000000858717981ULL, 0x0002e8000c1e9500ULL, 0x000000086c667981ULL, 0x0002e2000c1e9500ULL,
0x0000007f7c7b7211ULL, 0x000fc600078fe0ffULL, 0x000000085c777981ULL, 0x0002e4000c1e9500ULL,
0x000000ff70587207ULL, 0x002fe20000800000ULL, 0x000060007b7a7625ULL, 0x000fc800078e006eULL,
0x00000001586b7824ULL, 0x000fe200078e027fULL, 0x0000007d7c5b7211ULL, 0x040fe200078fe0ffULL,
0x000000017d6d7824ULL, 0x000fe200078e0258ULL, 0x000000087a727981ULL, 0x0002e2000c1e9500ULL,
0x000060006b6a7625ULL, 0x000fe200078e006eULL, 0x000000817c5f7211ULL, 0x000fc800078fe0ffULL,
0x000000086ad17981ULL, 0x0002e2000c1e9500ULL, 0x000060005b5a7625ULL, 0x080fe200078e006eULL,
0x000000837c597211ULL, 0x000fe400078fe0ffULL, 0x0000003051b77812ULL, 0x000fe200078efcffULL,
0x000060006d6c7625ULL, 0x000fe200078e006eULL, 0x000000085a707981ULL, 0x0002e6000c1e9500ULL,
0x00000001585d7824ULL, 0x040fe200078e0281ULL, 0x000000086c797981ULL, 0x0002e2000c1e9500ULL,
0x0000000158857824ULL, 0x000fc400078e0283ULL, 0x000060005f5e7625ULL, 0x000fe200078e006eULL,
0x00005800b7b97a10ULL, 0x000fc60007ffe0ffULL, 0x0000600059587625ULL, 0x080fe200078e006eULL,
0x000000085e767981ULL, 0x0002e6000c1e9500ULL, 0x000060005d5c7625ULL, 0x080fe200078e006eULL,
0x0000000858d97981ULL, 0x0002e6000c1e9500ULL, 0x00006000855a7625ULL, 0x002fe200078e006eULL,
0x000000085cd57981ULL, 0x0002e6000c1e9500ULL, 0x000000011f6d7824ULL, 0x000fe200078e02b7ULL,
0x000000085a867981ULL, 0x0002e6000c1e9500ULL, 0x000000016d7a7824ULL, 0x000fc400078e0a1cULL,
0x00000001b96c7824ULL, 0x000fc600078e0a1cULL, 0x0000007a9b7a7217ULL, 0x000fe40003800000ULL,
0x0000001c6d00720cULL, 0x080fe40003f26070ULL, 0x0000001cb900720cULL, 0x000fe40003f06070ULL,
0x0000006c9b6c7217ULL, 0x000fe40003800000ULL, 0x00000004ff587819ULL, 0x000fe4000001167aULL,
0x000000ff6c7a7207ULL, 0x000fc40000000000ULL, 0x000000ff587e7207ULL, 0x000fe40000800000ULL,
0x0000007d7a6b7211ULL, 0x040fe400078fe0ffULL, 0x000000817a5b7211ULL, 0x002fe200078fe0ffULL,
0x000000017d6d7824ULL, 0x000fe400078e027eULL, 0x000000017e5f7824ULL, 0x000fe400078e0281ULL,
0x000060006b6a7625ULL, 0x000fc800078e006eULL, 0x000060006d6c7625ULL, 0x080fe200078e006eULL,
0x000000086abb7981ULL, 0x0002e6000c1e9500ULL, 0x000060005b5a7625ULL, 0x080fe200078e006eULL,
0x000000086c807981ULL, 0x0002e6000c1e9500ULL, 0x000060005f5e7625ULL, 0x000fe200078e006eULL,
0x000000085ad77981ULL, 0x0002e2000c1e9500ULL, 0x0000007f7a597211ULL, 0x000fc600078fe0ffULL,
0x000000085e847981ULL, 0x0002e2000c1e9500ULL, 0x000000017e5d7824ULL, 0x000fe400078e027fULL,
0x0000600059587625ULL, 0x000fc800078e006eULL, 0x000060005d5c7625ULL, 0x080fe200078e006eULL,
0x0000000858d37981ULL, 0x0002e4000c1e9500ULL, 0x000000837a6b7211ULL, 0x002fe400078fe0ffULL,
0x000000085c827981ULL, 0x0002e2000c1e9500ULL, 0x000000017e6d7824ULL, 0x000fe400078e0283ULL,
0x000060006b6a7625ULL, 0x000fc800078e006eULL, 0x000060006d6c7625ULL, 0x000fe200078e006eULL,
0x000000086adb7981ULL, 0x0002e8000c1e9500ULL, 0x000000086c887981ULL, 0x0002e2000c1e9500ULL,
0xfffffff068597812ULL, 0x000fe200078ec0ffULL, 0x00000001ffcf7424ULL, 0x000fc800078e00ffULL,
0x000000011c587824ULL, 0x000fc800078e0259ULL, 0x0000000153597824ULL, 0x000fe200078e0a58ULL,
0x00000001517b7812ULL, 0x000fc800078efcffULL, 0x00000059cf597219ULL, 0x000fe400000006ffULL,
0x000058007b5b7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff0745d7812ULL, 0x002fc600078ec0ffULL,
0x000000015b5a7824ULL, 0x100fe200078e0a58ULL, 0x00000008517d7812ULL, 0x040fe200078efcffULL,
0x000000011c5e7824ULL, 0x000fe200078e025dULL, 0x00000009517f7812ULL, 0x000fe400078efcffULL,
0x0000005acf5d7219ULL, 0x000fe400000006ffULL, 0x000058007d5f7a10ULL, 0x000fe40007ffe0ffULL,
0x000058007f6d7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff07a817812ULL, 0x000fe200078ec0ffULL,
0x000000015f5c7824ULL, 0x100fe200078e0a58ULL, 0xfffffff07c6b7812ULL, 0x000fe200078ec0ffULL,
0x000000016d587824ULL, 0x000fe200078e0a58ULL, 0x0000001151857812ULL, 0x000fe200078efcffULL,
0x000000011c747824ULL, 0x040fe200078e0281ULL, 0x0000006b1c687210ULL, 0x000fc40007ffe0ffULL,
0x0000005ccf6b7219ULL, 0x040fe400000006ffULL, 0x00000058cf817219ULL, 0x000fe400000006ffULL,
0x0000580085877a10ULL, 0x000fe40007ffe0ffULL, 0x0000541050507816ULL, 0x010fc80000000055ULL,
0x0000005059ff7212ULL, 0x000fc800078ac0ffULL, 0x0000001c5300720cULL, 0x000fc80002fa1470ULL,
0x0000001c5100720cULL, 0x000fe40002fa1070ULL, 0x000000505dff7212ULL, 0x000fe4000782c0ffULL,
0xff80000003037808ULL, 0x000fe40002800000ULL, 0x0000001c5b00720cULL, 0x000fe40000f21470ULL,
0x0000541052527816ULL, 0x000fe40000000057ULL, 0x0000541054547816ULL, 0x000fc40000000061ULL,
0x0000005259ff7212ULL, 0x040fe4000784c0ffULL, 0x0000005459ff7212ULL, 0x000fe4000788c0ffULL,
0x000000525dff7212ULL, 0x000fe400078ac0ffULL, 0x0000001c5300720cULL, 0x0c0fe40001741470ULL,
0x0000001c5300720cULL, 0x080fe40002781470ULL, 0x0000001c5b00720cULL, 0x000fc40002fa1470ULL,
0x0000001c5100720cULL, 0x0c0fe40001741070ULL, 0x0000001c5100720cULL, 0x080fe40002781070ULL,
0x0000001c7b00720cULL, 0x0c0fe40000f21070ULL, 0x0000001c7b00720cULL, 0x000fe40002fa1070ULL,
0x0000541056567816ULL, 0x004fe40000000067ULL, 0xff80000010107808ULL, 0x000fc40001000000ULL,
0xff80000031317808ULL, 0x000fe40002000000ULL, 0xff80000002027808ULL, 0x000fe40000800000ULL,
0xff80000018187808ULL, 0x000fe40002800000ULL, 0x000000506bff7212ULL, 0x000fe4000786c0ffULL,
0x0000005659ff7212ULL, 0x000fe4000780c0ffULL, 0x000000545dff7212ULL, 0x000fc4000784c0ffULL,
0x000000565dff7212ULL, 0x000fe4000788c0ffULL, 0x0000005281ff7212ULL, 0x000fe4000782c0ffULL,
0x000000546bff7212ULL, 0x000fe200078ac0ffULL, 0x0000000165587824ULL, 0x100fe200078e0a5eULL,
0x0000001c5300720cULL, 0x080fe20000701470ULL, 0x00000001875a7824ULL, 0x000fe200078e0a5eULL,
0x0000001c5b00720cULL, 0x0c0fe40001741470ULL, 0x0000001c5b00720cULL, 0x000fc40002781470ULL,
0x0000001c5f00720cULL, 0x0c0fe40001f61470ULL, 0x0000001c5f00720cULL, 0x080fe40002fa1470ULL,
0x0000001c6d00720cULL, 0x080fe40000f21470ULL, 0x00000018518b7812ULL, 0x040fe400078efcffULL,
0x0000001951917812ULL, 0x040fe400078efcffULL, 0x0000001c5100720cULL, 0x000fc40000701070ULL,
0x0000001c7b00720cULL, 0x0c0fe40001741070ULL, 0x0000001c7b00720cULL, 0x080fe40002781070ULL,
0x0000001c7d00720cULL, 0x0c0fe40001f61070ULL, 0x0000001c7d00720cULL, 0x080fe40002fa1070ULL,
0x0000001c7f00720cULL, 0x000fe40000f21070ULL, 0x00000058cf837219ULL, 0x000fc400000006ffULL,
0x0000005acf897219ULL, 0x000fe400000006ffULL, 0x0000541060607816ULL, 0x000fe40000000069ULL,
0x0000541062627816ULL, 0x008fe4000000006fULL, 0x000058008b8d7a10ULL, 0x000fe40007ffe0ffULL,
0x0000580091937a10ULL, 0x000fe40007ffe0ffULL, 0xff80000044447808ULL, 0x000fc40000000000ULL,
0xff80000030307808ULL, 0x000fe40001000000ULL, 0xff80000048487808ULL, 0x000fe40002000000ULL,
0xff80000008087808ULL, 0x000fe40001800000ULL, 0xff80000032327808ULL, 0x000fe40002800000ULL,
0xff8000001b1b7808ULL, 0x000fe40000800000ULL, 0x000000526bff7212ULL, 0x000fc4000780c0ffULL,
0x0000005481ff7212ULL, 0x000fe4000784c0ffULL, 0x000000566bff7212ULL, 0x080fe4000788c0ffULL,
0x0000005681ff7212ULL, 0x000fe4000786c0ffULL, 0x0000006089ff7212ULL, 0x000fe400078ac0ffULL,
0x0000006283ff7212ULL, 0x000fe2000782c0ffULL, 0x000000018d5c7824ULL, 0x100fe200078e0a5eULL,
0x0000001c5f00720cULL, 0x080fe20000701470ULL, 0x00000001935e7824ULL, 0x000fe200078e0a5eULL,
0x0000001c5f00720cULL, 0x000fc40002781470ULL, 0x0000001c6d00720cULL, 0x0c0fe40001741470ULL,
0x0000001c6d00720cULL, 0x080fe40001f61470ULL, 0x0000001c6500720cULL, 0x080fe40000f21470ULL,
0x0000001c8700720cULL, 0x080fe40002fa1470ULL, 0x0000001c7d00720cULL, 0x0c0fe40000701070ULL,
0x0000001c7d00720cULL, 0x000fc40002781070ULL, 0x0000001c7f00720cULL, 0x0c0fe40001741070ULL,
0x0000001c7f00720cULL, 0x080fe40001f61070ULL, 0x0000001c6300720cULL, 0x080fe40000f21070ULL,
0x0000001c8500720cULL, 0x000fe40002fa1070ULL, 0x0000005ccf8f7219ULL, 0x040fe400000006ffULL,
0x0000005ecf997219ULL, 0x000fc400000006ffULL, 0x0000541064647816ULL, 0x000fe40000000071ULL,
0x0000541066667816ULL, 0x000fe40000000077ULL, 0xff80000019197808ULL, 0x000fe40000000000ULL,
0xff80000049497808ULL, 0x000fe40002000000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff8000004b4b7808ULL, 0x000fc40001800000ULL, 0xff80000024247808ULL, 0x000fe40000800000ULL,
0xff8000000c0c7808ULL, 0x000fe40002800000ULL, 0x0000006083ff7212ULL, 0x080fe4000780c0ffULL,
0x000000608fff7212ULL, 0x000fe4000788c0ffULL, 0x0000006483ff7212ULL, 0x040fe4000784c0ffULL,
0x0000006683ff7212ULL, 0x000fc4000786c0ffULL, 0x0000006489ff7212ULL, 0x000fe4000782c0ffULL,
0x0000006299ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001756a7824ULL, 0x000fe200078e0a68ULL,
0x0000001c6500720cULL, 0x0c0fe40000701470ULL, 0x0000001c6500720cULL, 0x0c0fe40001741470ULL,
0x0000001c6500720cULL, 0x080fe40001f61470ULL, 0x0000001c8700720cULL, 0x000fc40000f21470ULL,
0x0000001c8d00720cULL, 0x080fe40002781470ULL, 0x0000001c9300720cULL, 0x080fe40002fa1470ULL,
0x0000002151a57812ULL, 0x000fe400078efcffULL, 0x0000001c6300720cULL, 0x0c0fe40000701070ULL,
0x0000001c6300720cULL, 0x0c0fe40001741070ULL, 0x0000001c6300720cULL, 0x000fc40001f61070ULL,
0x0000001c8500720cULL, 0x080fe40000f21070ULL, 0x0000001c8b00720cULL, 0x080fe40002781070ULL,
0x0000001c9100720cULL, 0x000fe40002fa1070ULL, 0x0000006acfa37219ULL, 0x000fe400000006ffULL,
0x0000541072727816ULL, 0x000fe400000000d1ULL, 0x00005800a5a77a10ULL, 0x000fc40007ffe0ffULL,
0xff8000000b0b7808ULL, 0x000fe40000000000ULL, 0xff80000034347808ULL, 0x000fe40001000000ULL,
0xff8000004d4d7808ULL, 0x000fe40001800000ULL, 0xff80000035357808ULL, 0x000fe40000800000ULL,
0xff8000000d0d7808ULL, 0x000fe40002000000ULL, 0xff80000027277808ULL, 0x000fc40002800000ULL,
0x0000006289ff7212ULL, 0x040fe4000780c0ffULL, 0x0000006689ff7212ULL, 0x000fe4000784c0ffULL,
0x000000628fff7212ULL, 0x000fe4000786c0ffULL, 0x0000006499ff7212ULL, 0x040fe4000782c0ffULL,
0x0000006699ff7212ULL, 0x000fe4000788c0ffULL, 0x00000072a3ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a76c7824ULL, 0x000fe200078e0a68ULL, 0x0000001c8700720cULL, 0x000fc40000701470ULL,
0x0000001c8700720cULL, 0x080fe40001741470ULL, 0x0000001c8d00720cULL, 0x080fe40001f61470ULL,
0x0000001c9300720cULL, 0x0c0fe40000f21470ULL, 0x0000001c9300720cULL, 0x080fe40002781470ULL,
0x0000001c7500720cULL, 0x000fe40002fa1470ULL, 0x0000002851ab7812ULL, 0x000fc400078efcffULL,
0x0000002951b17812ULL, 0x000fe400078efcffULL, 0x0000001c8500720cULL, 0x0c0fe40000701070ULL,
0x0000001c8500720cULL, 0x080fe40001741070ULL, 0x0000001c8b00720cULL, 0x080fe40001f61070ULL,
0x0000001c9100720cULL, 0x0c0fe40000f21070ULL, 0x0000001c9100720cULL, 0x000fc40002781070ULL,
0x0000001c7300720cULL, 0x000fe40002fa1070ULL, 0x0000006ccfa97219ULL, 0x000fe400000006ffULL,
0x0000541070707816ULL, 0x000fe40000000079ULL, 0x0000541076767816ULL, 0x000fe400000000d5ULL,
0x00005410d9867816ULL, 0x000fe40000000086ULL, 0x00005800abad7a10ULL, 0x000fc40007ffe0ffULL,
0x00005800b1b37a10ULL, 0x000fe40007ffe0ffULL, 0xff80000025257808ULL, 0x000fe40000000000ULL,
0xff8000004e4e7808ULL, 0x000fe40001000000ULL, 0xff80000026267808ULL, 0x000fe40001800000ULL,
0xff80000037377808ULL, 0x000fe40000800000ULL, 0xff8000004c4c7808ULL, 0x000fc40002000000ULL,
0xff80000028287808ULL, 0x000fe40002800000ULL, 0x0000005081ff7212ULL, 0x000fe400078cc0ffULL,
0x000000648fff7212ULL, 0x040fe4000780c0ffULL, 0x000000668fff7212ULL, 0x000fe4000784c0ffULL,
0x00000070a3ff7212ULL, 0x040fe4000786c0ffULL, 0x00000076a3ff7212ULL, 0x000fc4000782c0ffULL,
0x00000086a3ff7212ULL, 0x000fe4000788c0ffULL, 0x00000076a9ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001ad6e7824ULL, 0x100fe200078e0a68ULL, 0x0000001c6d00720cULL, 0x080fe200037c1470ULL,
0x00000001b3687824ULL, 0x000fe200078e0a68ULL, 0x0000001c8d00720cULL, 0x0c0fe40000701470ULL,
0x0000001c8d00720cULL, 0x080fe40001741470ULL, 0x0000001c7500720cULL, 0x000fc40001f61470ULL,
0x0000001c7500720cULL, 0x0c0fe40000f21470ULL, 0x0000001c7500720cULL, 0x080fe40002781470ULL,
0x0000001ca700720cULL, 0x080fe40002fa1470ULL, 0x0000001c7f00720cULL, 0x080fe400037c1070ULL,
0x0000001c8b00720cULL, 0x0c0fe40000701070ULL, 0x0000001c8b00720cULL, 0x000fc40001741070ULL,
0x0000001c7300720cULL, 0x0c0fe40001f61070ULL, 0x0000001c7300720cULL, 0x0c0fe40000f21070ULL,
0x0000001c7300720cULL, 0x080fe40002781070ULL, 0x0000001ca500720cULL, 0x000fe40002fa1070ULL,
0x0000006ecfaf7219ULL, 0x040fe400000006ffULL, 0x00000068cfb57219ULL, 0x000fc400000006ffULL,
0xff8000000a0a7808ULL, 0x000fe40003000000ULL, 0xff80000036367808ULL, 0x000fe40000000000ULL,
0xff8000004f4f7808ULL, 0x000fe40001000000ULL, 0xff8000000f0f7808ULL, 0x000fe40001800000ULL,
0xff80000038387808ULL, 0x000fe40000800000ULL, 0xff8000004a4a7808ULL, 0x000fc40002000000ULL,
0xff80000039397808ULL, 0x000fe40002800000ULL, 0x0000006099ff7212ULL, 0x000fe400078cc0ffULL,
0x00000070a9ff7212ULL, 0x080fe4000780c0ffULL, 0x00000070afff7212ULL, 0x000fe4000784c0ffULL,
0x00000072a9ff7212ULL, 0x040fe4000786c0ffULL, 0x00000086a9ff7212ULL, 0x000fc4000782c0ffULL,
0x00000072afff7212ULL, 0x000fe4000788c0ffULL, 0x00000076b5ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b97a7824ULL, 0x000fe200078e0a74ULL, 0x0000001c9300720cULL, 0x080fe400037c1470ULL,
0x0000001ca700720cULL, 0x0c0fe40000701470ULL, 0x0000001ca700720cULL, 0x0c0fe40001f61470ULL,
0x0000001ca700720cULL, 0x000fc40000f21470ULL, 0x0000001cad00720cULL, 0x0c0fe40001741470ULL,
0x0000001cad00720cULL, 0x080fe40002781470ULL, 0x0000001cb300720cULL, 0x000fe40002fa1470ULL,
0x0000003151bf7812ULL, 0x040fe400078efcffULL, 0x0000003851c57812ULL, 0x040fe400078efcffULL,
0x0000003951cb7812ULL, 0x000fc400078efcffULL, 0x0000001c9100720cULL, 0x080fe400037c1070ULL,
0x0000001ca500720cULL, 0x0c0fe40000701070ULL, 0x0000001ca500720cULL, 0x0c0fe40001f61070ULL,
0x0000001ca500720cULL, 0x080fe40000f21070ULL, 0x0000001cab00720cULL, 0x0c0fe40001741070ULL,
0x0000001cab00720cULL, 0x000fc40002781070ULL, 0x0000001cb100720cULL, 0x000fe40002fa1070ULL,
0x0000007acfbd7219ULL, 0x000fe400000006ffULL, 0x00005410bb807816ULL, 0x000fe40000000080ULL,
0x00005410d7847816ULL, 0x000fe40000000084ULL, 0x00005800bfc17a10ULL, 0x000fe40007ffe0ffULL,
0x00005800c5c77a10ULL, 0x000fc40007ffe0ffULL, 0x00005800cbcd7a10ULL, 0x000fe40007ffe0ffULL,
0xff8000000e0e7808ULL, 0x000fe40003000000ULL, 0xff80000014147808ULL, 0x000fe40000000000ULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff8000003b3b7808ULL, 0x000fe40000800000ULL,
0xff80000017177808ULL, 0x000fc40001000000ULL, 0xff8000002a2a7808ULL, 0x000fe40002000000ULL,
0xff8000003c3c7808ULL, 0x000fe40002800000ULL, 0x00000070b5ff7212ULL, 0x040fe400078cc0ffULL,
0x00000072b5ff7212ULL, 0x000fe4000780c0ffULL, 0x00000076afff7212ULL, 0x040fe4000786c0ffULL,
0x00000086afff7212ULL, 0x000fc4000782c0ffULL, 0x00000086b5ff7212ULL, 0x000fe4000784c0ffULL,
0x00000080bdff7212ULL, 0x040fe4000788c0ffULL, 0x00000084bdff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c17c7824ULL, 0x100fe200078e0a74ULL, 0x0000001cad00720cULL, 0x080fe20001f61470ULL,
0x00000001c77e7824ULL, 0x100fe200078e0a74ULL, 0x0000001cad00720cULL, 0x080fe20000f21470ULL,
0x00000001cd747824ULL, 0x000fe200078e0a74ULL, 0x0000001cb300720cULL, 0x000fc400037c1470ULL,
0x0000001cb300720cULL, 0x0c0fe40000701470ULL, 0x0000001cb300720cULL, 0x080fe40001741470ULL,
0x0000001cb900720cULL, 0x0c0fe40002781470ULL, 0x0000001cb900720cULL, 0x000fe40002fa1470ULL,
0x0000007ccfc37219ULL, 0x040fe400000006ffULL, 0x0000007ecfc97219ULL, 0x000fc400000006ffULL,
0x0000001cab00720cULL, 0x0c0fe40001f61070ULL, 0x0000001cab00720cULL, 0x080fe40000f21070ULL,
0x0000001cb100720cULL, 0x0c0fe400037c1070ULL, 0x0000001cb100720cULL, 0x0c0fe40000701070ULL,
0x0000001cb100720cULL, 0x080fe40001741070ULL, 0x0000001cb700720cULL, 0x000fc40002781070ULL,
0x0000001cb700720cULL, 0x000fe40002fa1070ULL, 0x00000074cfcf7219ULL, 0x000fe400000006ffULL,
0x00005410d3827816ULL, 0x000fe40000000082ULL, 0xff8000003a3a7808ULL, 0x000fe40001800000ULL,
0xff8000003d3d7808ULL, 0x000fe40000800000ULL, 0xff80000015157808ULL, 0x000fc40003000000ULL,
0xff8000002b2b7808ULL, 0x000fe40000000000ULL, 0xff8000003e3e7808ULL, 0x000fe40001000000ULL,
0xff80000016167808ULL, 0x000fe40002000000ULL, 0xff8000003f3f7808ULL, 0x000fe40002800000ULL,
0x00000080c3ff7212ULL, 0x080fe4000786c0ffULL, 0x00000080c9ff7212ULL, 0x000fc4000782c0ffULL,
0x00000080cfff7212ULL, 0x000fe400078cc0ffULL, 0x00000082bdff7212ULL, 0x080fe4000780c0ffULL,
0x00000082c3ff7212ULL, 0x080fe4000784c0ffULL, 0x00000082c9ff7212ULL, 0x000fe4000788c0ffULL,
0x00000084c3ff7212ULL, 0x000fe400078ac0ffULL, 0x0000001cb900720cULL, 0x000fc40000701470ULL,
0x0000001cc100720cULL, 0x0c0fe40001f61470ULL, 0x0000001cc100720cULL, 0x0c0fe40001741470ULL,
0x0000001cc100720cULL, 0x080fe40002fa1470ULL, 0x0000001cc700720cULL, 0x080fe40000f21470ULL,
0x0000001ccd00720cULL, 0x080fe400037c1470ULL, 0x0000001cc700720cULL, 0x000fc40002781470ULL,
0x0000001cb700720cULL, 0x080fe40000701070ULL, 0x0000001cbf00720cULL, 0x0c0fe40001f61070ULL,
0x0000001cbf00720cULL, 0x0c0fe40001741070ULL, 0x0000001cbf00720cULL, 0x080fe40002fa1070ULL,
0x0000001cc500720cULL, 0x080fe40000f21070ULL, 0x0000001ccb00720cULL, 0x000fc400037c1070ULL,
0x0000001cc500720cULL, 0x000fe40002781070ULL, 0x00005410db887816ULL, 0x000fe40000000088ULL,
0xff8000002c2c7808ULL, 0x000fe40000000000ULL, 0xff80000012127808ULL, 0x000fe40001800000ULL,
0xff8000002d2d7808ULL, 0x000fe40001000000ULL, 0xff80000040407808ULL, 0x000fc40002800000ULL,
0xff80000013137808ULL, 0x000fe40000800000ULL, 0xff80000011117808ULL, 0x000fe40003000000ULL,
0xff8000002e2e7808ULL, 0x000fe40002000000ULL, 0x00000082cfff7212ULL, 0x000fe4000780c0ffULL,
0x00000084c9ff7212ULL, 0x080fe4000786c0ffULL, 0x00000084cfff7212ULL, 0x000fc4000784c0ffULL,
0x00000088bdff7212ULL, 0x080fe400078ac0ffULL, 0x00000088c3ff7212ULL, 0x080fe4000782c0ffULL,
0x00000088c9ff7212ULL, 0x080fe400078cc0ffULL, 0x00000088cfff7212ULL, 0x000fe4000788c0ffULL,
0x0000001cb900720cULL, 0x080fe40002fa1470ULL, 0x0000001cc100720cULL, 0x000fc40000f21470ULL,
0x0000001cc700720cULL, 0x0c0fe40001f61470ULL, 0x0000001cc700720cULL, 0x080fe400037c1470ULL,
0x0000001ccd00720cULL, 0x0c0fe40000701470ULL, 0x0000001ccd00720cULL, 0x0c0fe40001741470ULL,
0x0000001ccd00720cULL, 0x080fe40002781470ULL, 0x0000001cb700720cULL, 0x000fc40002fa1070ULL,
0x0000001cbf00720cULL, 0x080fe40000f21070ULL, 0x0000001ccb00720cULL, 0x080fe40000701070ULL,
0x0000001cc500720cULL, 0x0c0fe40001f61070ULL, 0x0000001cc500720cULL, 0x080fe400037c1070ULL,
0x0000001ccb00720cULL, 0x0c0fe40001741070ULL, 0x0000001ccb00720cULL, 0x000fc40002781070ULL,
0xff8000002f2f7808ULL, 0x000fe40000000000ULL, 0xff80000042427808ULL, 0x000fe40001800000ULL,
0xff80000045457808ULL, 0x000fe40001000000ULL, 0xff80000041417808ULL, 0x000fe40002800000ULL,
0xff80000043437808ULL, 0x000fe40000800000ULL, 0xff80000046467808ULL, 0x000fc40003000000ULL,
0xff80000047477808ULL, 0x000fc40002000000ULL, 0x000000030400720bULL, 0x004fe20003f1e000ULL,
0x0000001fff567424ULL, 0x000fe200078e00ffULL, 0x000000100500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff597424ULL, 0x000fe200078e00ffULL, 0x000000310600720bULL, 0x000fe40003f5e000ULL,
0x000000440700720bULL, 0x000fe40003f7e000ULL, 0x0000000403517208ULL, 0x000fe40004000000ULL,
0x0000000510057208ULL, 0x000fc40004800000ULL, 0x0000000631537208ULL, 0x000fe40005000000ULL,
0x0000000744077208ULL, 0x000fe40005800000ULL, 0x000000025100720bULL, 0x000fe40003f1e000ULL,
0x000000180500720bULL, 0x000fe40003f3e000ULL, 0x000000305300720bULL, 0x000fe40003f5e000ULL,
0x000000480700720bULL, 0x000fc40003f7e000ULL, 0x0000005102517208ULL, 0x000fe40004000000ULL,
0x0000000518047208ULL, 0x000fe40004800000ULL, 0x0000005330537208ULL, 0x000fe40005000000ULL,
0x0000000748067208ULL, 0x000fe40005800000ULL, 0x000000085100720bULL, 0x000fe40003f1e000ULL,
0x000000190400720bULL, 0x000fc40003f3e000ULL, 0x000000325300720bULL, 0x000fe40003f5e000ULL,
0x000000490600720bULL, 0x000fe40003f7e000ULL, 0x0000005108517208ULL, 0x000fe40004000000ULL,
0x0000000419047208ULL, 0x000fe40004800000ULL, 0x00000053321c7208ULL, 0x000fe40005000000ULL,
0x0000000649067208ULL, 0x000fc40005800000ULL, 0x0000000a5100720bULL, 0x000fe40003f1e000ULL,
0x0000001b0400720bULL, 0x000fe40003f3e000ULL, 0x000000331c00720bULL, 0x000fe40003f5e000ULL,
0x0000004b0600720bULL, 0x000fe40003f7e000ULL, 0x000000510a507208ULL, 0x000fe40004000000ULL,
0x000000041b057208ULL, 0x000fc40004800000ULL, 0x0000001c33077208ULL, 0x000fe40005000000ULL,
0x000000064b067208ULL, 0x000fe40005800000ULL, 0x0000000b5000720bULL, 0x000fe40003f1e000ULL,
0x000000240500720bULL, 0x000fe40003f3e000ULL, 0x000000340700720bULL, 0x000fe40003f5e000ULL,
0x0000004d0600720bULL, 0x000fc40003f7e000ULL, 0x000000500b517208ULL, 0x000fe40004000000ULL,
0x0000000524047208ULL, 0x000fe40004800000ULL, 0x00000007341c7208ULL, 0x000fe40005000000ULL,
0x000000064d057208ULL, 0x000fe40005800000ULL, 0x0000000c5100720bULL, 0x000fe40003f1e000ULL,
0x000000250400720bULL, 0x000fc40003f3e000ULL, 0x000000351c00720bULL, 0x000fe40003f5e000ULL,
0x0000004e0500720bULL, 0x000fe40003f7e000ULL, 0x000000510c067208ULL, 0x000fe40004000000ULL,
0x0000000425077208ULL, 0x000fe40004800000ULL, 0x0000001c35517208ULL, 0x000fe40005000000ULL,
0x000000054e047208ULL, 0x000fc40005800000ULL, 0x0000000d0600720bULL, 0x000fe40003f1e000ULL,
0x000000260700720bULL, 0x000fe40003f3e000ULL, 0x000000365100720bULL, 0x000fe40003f5e000ULL,
0x0000004f0400720bULL, 0x000fe40003f7e000ULL, 0x000000060d057208ULL, 0x000fe40004000000ULL,
0x0000000726067208ULL, 0x000fc40004800000ULL, 0x00000051361c7208ULL, 0x000fe40005000000ULL,
0x000000044f077208ULL, 0x000fe40005800000ULL, 0x0000000e0500720bULL, 0x000fe40003f1e000ULL,
0x000000270600720bULL, 0x000fe40003f3e000ULL, 0x000000371c00720bULL, 0x000fe40003f5e000ULL,
0x0000004c0700720bULL, 0x000fc40003f7e000ULL, 0x000000050e047208ULL, 0x000fe40004000000ULL,
0x0000000627057208ULL, 0x000fe40004800000ULL, 0x0000001c37517208ULL, 0x000fe40005000000ULL,
0x000000074c077208ULL, 0x000fe40005800000ULL, 0x0000000f0400720bULL, 0x000fe40003f1e000ULL,
0x000000280500720bULL, 0x000fc40003f3e000ULL, 0x000000385100720bULL, 0x000fe40003f5e000ULL,
0x0000004a0700720bULL, 0x000fe40003f7e000ULL, 0x000000040f537208ULL, 0x000fe40004000000ULL,
0x0000000528047208ULL, 0x000fe40004800000ULL, 0x0000005138067208ULL, 0x000fe40005000000ULL,
0x000000074a1c7208ULL, 0x000fc40005800000ULL, 0x000000145300720bULL, 0x000fe40003f1e000ULL,
0x000000290400720bULL, 0x000fe40003f3e000ULL, 0x000000390600720bULL, 0x000fe40003f5e000ULL,
0x0000003b1c00720bULL, 0x000fe40003f7e000ULL, 0x0000005314507208ULL, 0x000fe40004000000ULL,
0x0000000429057208ULL, 0x000fc40004800000ULL, 0x0000000639077208ULL, 0x000fe40005000000ULL,
0x0000001c3b1c7208ULL, 0x000fe40005800000ULL, 0x000000175000720bULL, 0x000fe40003f1e000ULL,
0x0000002a0500720bULL, 0x000fe40003f3e000ULL, 0x0000003a0700720bULL, 0x000fe40003f5e000ULL,
0x0000003d1c00720bULL, 0x000fc40003f7e000ULL, 0x0000005017507208ULL, 0x000fe40004000000ULL,
0x000000052a047208ULL, 0x000fe40004800000ULL, 0x000000073a077208ULL, 0x000fe40005000000ULL,
0x0000001c3d057208ULL, 0x000fe40005800000ULL, 0x000000155000720bULL, 0x000fe40003f1e000ULL,
0x0000002b0400720bULL, 0x000fc40003f3e000ULL, 0x0000003c0700720bULL, 0x000fe40003f5e000ULL,
0x0000003e0500720bULL, 0x000fe40003f7e000ULL, 0x0000005015517208ULL, 0x000fe40004000000ULL,
0x000000042b537208ULL, 0x000fe40004800000ULL, 0x000000073c047208ULL, 0x000fe40005000000ULL,
0x000000053e067208ULL, 0x000fc40005800000ULL, 0x000000165100720bULL, 0x000fe40003f1e000ULL,
0x0000002c5300720bULL, 0x000fe40003f3e000ULL, 0x0000003f0400720bULL, 0x000fe40003f5e000ULL,
0x000000410600720bULL, 0x000fe40003f7e000ULL, 0x0000005116517208ULL, 0x000fe40004000000ULL,
0x000000532c1c7208ULL, 0x000fc40004800000ULL, 0x000000043f057208ULL, 0x000fe40005000000ULL,
0x0000000641067208ULL, 0x000fe40005800000ULL, 0x000000125100720bULL, 0x000fe40003f1e000ULL,
0x0000002d1c00720bULL, 0x000fe40003f3e000ULL, 0x000000400500720bULL, 0x000fe40003f5e000ULL,
0x000000430600720bULL, 0x000fc40003f7e000ULL, 0x0000005112047208ULL, 0x000fe40004000000ULL,
0x0000001c2d077208ULL, 0x000fe40004800000ULL, 0x0000000540057208ULL, 0x000fe40005000000ULL,
0x0000000643517208ULL, 0x000fe40005800000ULL, 0x000000130400720bULL, 0x000fe40003f1e000ULL,
0x0000002e0700720bULL, 0x000fc40003f3e000ULL, 0x000000420500720bULL, 0x000fe40003f5e000ULL,
0x000000465100720bULL, 0x000fe40003f7e000ULL, 0x0000000413047208ULL, 0x000fe40004000000ULL,
0x000000072e067208ULL, 0x000fe40004800000ULL, 0x00000005421c7208ULL, 0x000fe40005000000ULL,
0x0000005146507208ULL, 0x000fc40005800000ULL, 0x000000110400720bULL, 0x000fe40003f1e000ULL,
0x0000002f0600720bULL, 0x000fe40003f3e000ULL, 0x000000451c00720bULL, 0x000fe40003f5e000ULL,
0x000000475000720bULL, 0x000fe40003f7e000ULL, 0x0000000411077208ULL, 0x000fe40004000000ULL,
0x000000062f527208ULL, 0x000fc40004800000ULL, 0x0000001c45547208ULL, 0x000fe40005000000ULL,
0x0000005047537208ULL, 0x000fe20005800000ULL, 0x00001ff27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0007047f89ULL, 0x0004e400000e0000ULL, 0x000000040700720bULL, 0x008fc80003f1e000ULL,
0x0000000704557208ULL, 0x000fe20004000000ULL, 0x000020027f007947ULL, 0x000fea000b800000ULL,
0x0c401f0052047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0054057f89ULL, 0x000f2800000e0000ULL,
0x0c401f0053067f89ULL, 0x000e6200000e0000ULL, 0x000000045200720bULL, 0x008fc40003f1e000ULL,
0x000000055400720bULL, 0x010fe40003f3e000ULL, 0x0000005204077208ULL, 0x006fe40004000000ULL,
0x00000054051c7208ULL, 0x000fe20004800000ULL, 0x0c201f0055047f89ULL, 0x000e6200000e0000ULL,
0x000000065300720bULL, 0x000fc60003f1e000ULL, 0x0c201f0007507f89ULL, 0x000ea200000e0000ULL,
0x0000005306527208ULL, 0x000fc60004000000ULL, 0x0c201f001c517f89ULL, 0x000ee800000e0000ULL,
0x0c201f0052577f89ULL, 0x0002e400000e0000ULL, 0x000000045500720bULL, 0x002fe40003f1e000ULL,
0x000000500700720bULL, 0x004fe40003f3e000ULL, 0x0000005504047208ULL, 0x000fc40004000000ULL,
0x000000511c00720bULL, 0x008fe40003f5e000ULL, 0x0000000750057208ULL, 0x000fe40004800000ULL,
0x0000001c51067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x000000575200720bULL, 0x004fe20003f1e000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x3fb8aa3b08087823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0b1c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b03037823ULL, 0x100fe20000010807ULL,
0x0000000800547308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b02027823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b140b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b15517823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b16507823ULL, 0x100fe20000010807ULL,
0x0000000a00597308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b0f087823ULL, 0x102fe20000010807ULL,
0x3fb8aa3b12557823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b11537823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b06117820ULL, 0x000fc80000410000ULL, 0x0000001c00567308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b130a7823ULL, 0x004fe20000010807ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010811ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010811ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010811ULL,
0x3fb8aa3b35357823ULL, 0x000fe20000010811ULL, 0x0000003000137308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b171c7823ULL, 0x002fe20000010807ULL, 0x3fb8aa3b05077820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010811ULL,
0x3fb8aa3b38387823ULL, 0x000fe20000010811ULL, 0x3fb8aa3b10107823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2f077823ULL, 0x000fe20000010807ULL, 0x00000024005a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b39397823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010811ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010811ULL,
0x3fb8aa3b40407823ULL, 0x100fe20000010811ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010811ULL,
0x00000002ff307819ULL, 0x004fe20000011620ULL, 0x0000000700647308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b45117823ULL, 0x000fc60000010811ULL, 0x0000000830147824ULL, 0x040fe400078e00ffULL,
0x0000000830657824ULL, 0x040fe400078e00ffULL, 0x00000019000f7308ULL, 0x000fe20000000800ULL,
0x0000005257077208ULL, 0x002fe20004000000ULL, 0x0000000830577824ULL, 0x000fe200078e00ffULL,
0x0000000320ff7812ULL, 0x000fe2000780c0ffULL, 0x0000000830157824ULL, 0x040fe400078e00ffULL,
0x3fb8aa3b07247820ULL, 0x000fe20000410000ULL, 0x0000000830697824ULL, 0x000fe200078e00ffULL,
0x0000001b00127308ULL, 0x000e640000000800ULL, 0x3fb8aa3b44447823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b48487823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe20000010824ULL, 0x0000000d00587308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010824ULL, 0x0000000300037308ULL, 0x000fe20000000800ULL,
0x0000000f120f723eULL, 0x002fe200000000ffULL, 0x0000000830127824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b43437823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b46467823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b47477823ULL, 0x000fc60000010824ULL, 0x0000000200027308ULL, 0x000ff00000000800ULL,
0x00000010000d7308ULL, 0x000ff00000000800ULL, 0x0000001800187308ULL, 0x000e700000000800ULL,
0x00000026005c7308ULL, 0x000ff00000000800ULL, 0x00000029005e7308ULL, 0x000fe20000000800ULL,
0x0000000d180d723eULL, 0x002fc400000000ffULL, 0x0000000830187810ULL, 0x000fca0007ffe0ffULL,
0x0000003100107308ULL, 0x0002b00000000800ULL, 0x0000003200327308ULL, 0x000fe20000000800ULL,
0x0000001030317810ULL, 0x002fce0007ffe0ffULL, 0x0000003300337308ULL, 0x000fe20000000800ULL,
0x000000101310723eULL, 0x004fce00000000ffULL, 0x0000001100457308ULL, 0x0003f00000000800ULL,
0x0000004400447308ULL, 0x000fe20000000800ULL, 0x0000000330117810ULL, 0x002fc80007ffe0ffULL,
0xfffffff814677812ULL, 0x000fe400078ee211ULL, 0x0000000630117810ULL, 0x000fe20007ffe0ffULL,
0x0000004800297308ULL, 0x000fe60000000800ULL, 0xfffffff8146b7812ULL, 0x000fe400078ee211ULL,
0xffffffff30117810ULL, 0x000fc60007ffe0ffULL, 0x0000004900497308ULL, 0x000ff00000000800ULL,
0x0000004b00267308ULL, 0x0002b00000000800ULL, 0x0000000c005b7308ULL, 0x0007220000000800ULL,
0x0000000c1a4b7812ULL, 0x002fce00078ec0ffULL, 0x0000000e005d7308ULL, 0x0003220000000800ULL,
0x00000001300c7810ULL, 0x008fe40007ffe0ffULL, 0x000000492613723eULL, 0x004fe200000000ffULL,
0x0000000830497824ULL, 0x040fe200078e00ffULL, 0xfffffff857577812ULL, 0x000fe400078ee20cULL,
0x00000004300c7810ULL, 0x040fe20007ffe0ffULL, 0x0000002d00627308ULL, 0x000fe20000000800ULL,
0x00000002300e7810ULL, 0x002fe40007ffe0ffULL, 0x000000565b24723eULL, 0x010fc400000000ffULL,
0xfffffff865657812ULL, 0x000fe400078ee20eULL, 0x00000005300e7810ULL, 0x000fe20007ffe0ffULL,
0x0000004d002d7308ULL, 0x0003e20000000800ULL, 0x000000585d26723eULL, 0x000fe400000000ffULL,
0xfffffff869697812ULL, 0x000fe400078ee20eULL, 0x00000054590e723eULL, 0x000fe200000000ffULL,
0x0000000818597824ULL, 0x000fe200078e00ffULL, 0xfffffff849497812ULL, 0x000fe200078ee230ULL,
0x0000004f002f7308ULL, 0x0005e20000000800ULL, 0xfffffff8154d7812ULL, 0x002fc400078ee20cULL,
0x00000003020c723eULL, 0x000fe200000000ffULL, 0x3c003c00ff037424ULL, 0x000fe200078e00ffULL,
0x3c003c0000027802ULL, 0x000fe40000000f00ULL, 0x0000001830307810ULL, 0x000fe20007ffe0ffULL,
0x0000002800197308ULL, 0x000e620000000800ULL, 0xfffffff8124f7812ULL, 0x004fe400078ee211ULL,
0x000000323312723eULL, 0x000fe200000000ffULL, 0x000000020c14723cULL, 0x000f6200000018ffULL,
0x000000442911723eULL, 0x000fe200000000ffULL, 0x0000000831327824ULL, 0x000fe200078e00ffULL,
0xfffffff859597812ULL, 0x000fe200078ee218ULL, 0x0000002a001b7308ULL, 0x000fe20000000800ULL,
0x00000008305d7824ULL, 0x000fc400078e00ffULL, 0xfffffff8325b7812ULL, 0x000fc600078ee231ULL,
0xfffffff85d5d7812ULL, 0x000fe400078ee230ULL, 0x0000002b00607308ULL, 0x0004e20000000800ULL,
0x000000195e31723eULL, 0x002fce00000000ffULL, 0x0000002500257308ULL, 0x000e620000000800ULL,
0x000000021028723cULL, 0x004f6e00000018ffULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0x0000001b6033723eULL, 0x008fce00000000ffULL, 0x0000002c005f7308ULL, 0x000fe20000000800ULL,
0x0000005a2525723eULL, 0x002fce00000000ffULL, 0x0000002e00617308ULL, 0x000fe20000000800ULL,
0x0000005c2727723eULL, 0x004fce00000000ffULL, 0x00000034002c7308ULL, 0x000fe20000000800ULL,
0x000000022414723cULL, 0x020f6e0000001814ULL, 0x0000003500357308ULL, 0x000e700000000800ULL,
0x00000036002e7308ULL, 0x000ff00000000800ULL, 0x0000003700377308ULL, 0x000ea20000000800ULL,
0x0000002c352c723eULL, 0x002fc400000000ffULL, 0x0000005f6235723eULL, 0x000fca00000000ffULL,
0x0000004e004e7308ULL, 0x000e700000000800ULL, 0x0000004c004c7308ULL, 0x000ee20000000800ULL,
0x0000002e372e723eULL, 0x004fe400000000ffULL, 0x000000616437723eULL, 0x000fc400000000ffULL,
0x0000002d4e2d723eULL, 0x002fc600000000ffULL, 0x0000003800387308ULL, 0x000fe20000000800ULL,
0x0000002f4c2f723eULL, 0x008fce00000000ffULL, 0x0000003900397308ULL, 0x000e620000000800ULL,
0x000000022c28723cULL, 0x000f6e0000001828ULL, 0x0000000800087308ULL, 0x000ff00000000800ULL,
0x0000000b000b7308ULL, 0x000ea20000000800ULL, 0x000000383938723eULL, 0x002fce00000000ffULL,
0x0000001c001c7308ULL, 0x000ff00000000800ULL, 0x0000005100517308ULL, 0x000e620000000800ULL,
0x000000080b30723eULL, 0x004fce00000000ffULL, 0x0000004a004a7308ULL, 0x000ff00000000800ULL,
0x0000003b003b7308ULL, 0x000ea20000000800ULL, 0x0000001c5132723eULL, 0x002fce00000000ffULL,
0x0000003a003a7308ULL, 0x000fe20000000800ULL, 0x000000023014723cULL, 0x020f6e0000001814ULL,
0x0000003c00637308ULL, 0x000e620000000800ULL, 0x0000004a3b39723eULL, 0x004fce00000000ffULL,
0x0000003d003d7308ULL, 0x000ff00000000800ULL, 0x0000003e003e7308ULL, 0x000ea20000000800ULL,
0x0000003a633a723eULL, 0x002fce00000000ffULL, 0x0000000a000a7308ULL, 0x000ff00000000800ULL,
0x0000005300537308ULL, 0x000e620000000800ULL, 0x0000003d3e3b723eULL, 0x004fce00000000ffULL,
0x0000005000507308ULL, 0x000fe20000000800ULL, 0x000000023828723cULL, 0x000fee0000001828ULL,
0x0000005500557308ULL, 0x000ea20000000800ULL, 0x0000000a5336723eULL, 0x002fe400000000ffULL,
0x0000a0009a0a7811ULL, 0x000fca00078e60ffULL, 0x0000003f003f7308ULL, 0x000fe20000000800ULL,
0x00000010490b7824ULL, 0x100fe400078e020aULL, 0x0000001057187824ULL, 0x100fe400078e020aULL,
0x0000001065197824ULL, 0x100fe400078e020aULL, 0x00000010671a7824ULL, 0x100fe200078e020aULL,
0x0000004000407308ULL, 0x000e620000000800ULL, 0x000000505534723eULL, 0x004fe200000000ffULL,
0x000000104d1b7824ULL, 0x000fe200078e020aULL, 0x000000194b197210ULL, 0x040fe20007ffe0ffULL,
0x000000014b0b7824ULL, 0x000fc400078e020bULL, 0x00000010691c7824ULL, 0x000fe400078e020aULL,
0x0000004200427308ULL, 0x000ea20000000800ULL, 0x000000014b187824ULL, 0x000fe200078e0218ULL,
0x0000000c0b007388ULL, 0x0007e20000000800ULL, 0x000000106b3c7824ULL, 0x100fe200078e020aULL,
0x000000023414723cULL, 0x020f620000001814ULL, 0x000000104f3d7824ULL, 0x000fe200078e020aULL,
0x0000000e18007388ULL, 0x0005e20000000800ULL, 0x000000014b1a7824ULL, 0x000fe200078e021aULL,
0x0000004100417308ULL, 0x000fe20000000800ULL, 0x0000003f4040723eULL, 0x002fe200000000ffULL,
0x00000010593e7824ULL, 0x000fe200078e020aULL, 0x0000002419007388ULL, 0x0003e20000000800ULL,
0x000000014b1b7824ULL, 0x000fc400078e021bULL, 0x000000014b1c7824ULL, 0x000fe200078e021cULL,
0x000000261a007388ULL, 0x0003e20000000800ULL, 0x0000004300087308ULL, 0x000f220000000800ULL,
0x000000424542723eULL, 0x004fe200000000ffULL, 0x000000014b3c7824ULL, 0x040fe200078e023cULL,
0x000000301b007388ULL, 0x0003e20000000800ULL, 0x000000014b3d7824ULL, 0x040fe400078e023dULL,
0x000000014b3e7824ULL, 0x000fe200078e023eULL, 0x000000321c007388ULL, 0x0003e20000000800ULL,
0x0000004600467308ULL, 0x000fe20000000800ULL, 0x000000105b447824ULL, 0x000fc400078e020aULL,
0x000000343c007388ULL, 0x0003e20000000800ULL, 0x000000105d0a7824ULL, 0x000fe400078e020aULL,
0x000000014b0b7824ULL, 0x048fe200078e0244ULL, 0x000000363d007388ULL, 0x0003e20000000800ULL,
0x0000004700477308ULL, 0x000ea20000000800ULL, 0x000000410841723eULL, 0x010fe200000000ffULL,
0x000000014b0a7824ULL, 0x000fe200078e020aULL, 0x0000000d3e007388ULL, 0x0003e20000000800ULL,
0x000000ffff157224ULL, 0x020fc600078e0016ULL, 0x0004000f18007388ULL, 0x0003e80000000800ULL,
0x0004002519007388ULL, 0x0003e80000000800ULL, 0x000400271a007388ULL, 0x0003e20000000800ULL,
0x000000464743723eULL, 0x004fc600000000ffULL, 0x000400311b007388ULL, 0x0003e80000000800ULL,
0x000000024028723cULL, 0x000f620000001828ULL, 0x000400331c007388ULL, 0x0003e80000000800ULL,
0x000400353c007388ULL, 0x0003e80000000800ULL, 0x000400373d007388ULL, 0x0003e80000000800ULL,
0x000000100b007388ULL, 0x0003e80000000800ULL, 0x0008001218007388ULL, 0x0003e80000000800ULL,
0x0008002c19007388ULL, 0x0003e60000000800ULL, 0x000000ffff167224ULL, 0x020fe200078e0028ULL,
0x0008002e1a007388ULL, 0x0003e20000000800ULL, 0x000000ffff177224ULL, 0x000fc600078e002aULL,
0x000800381b007388ULL, 0x0003e80000000800ULL, 0x0008003a1c007388ULL, 0x0003e80000000800ULL,
0x000800403c007388ULL, 0x0003e80000000800ULL, 0x000800423d007388ULL, 0x0003e80000000800ULL,
0x000000110a007388ULL, 0x0003e80000000800ULL, 0x000c001318007388ULL, 0x0003e80000000800ULL,
0x000c002d19007388ULL, 0x0003e80000000800ULL, 0x000c002f1a007388ULL, 0x0003e80000000800ULL,
0x000c00391b007388ULL, 0x0003e80000000800ULL, 0x000c003b1c007388ULL, 0x0003e80000000800ULL,
0x000c00413c007388ULL, 0x0003e80000000800ULL, 0x000c00433d007388ULL, 0x0003e80000000800ULL,
0x0160000400008388ULL, 0x0003e80000000c00ULL, 0x0162001400008388ULL, 0x0003e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x016608009dff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x016610009dff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x016618009dff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000237800720cULL, 0x000fe20003f06070ULL,
0x016620009dff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff967224ULL, 0x000fd600078e0078ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff7c8000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff1f7807ULL, 0x008fe40004000000ULL,
0x000184a000207802ULL, 0x000fc40000000f00ULL, 0x0000106000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff027224ULL, 0x000fe200078e001fULL, 0xfffea94000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x000fe40005000000ULL, 0x000184f000207802ULL, 0x000fc40000000f00ULL,
0x0000101000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff077224ULL, 0x000fe200078e001fULL,
0xfffea9b000007947ULL, 0x000fea000383ffffULL, 0x0000000400217202ULL, 0x000fe40000000f00ULL,
0x0001854000207802ULL, 0x000fc40000000f00ULL, 0x00000f8000007944ULL, 0x012fea0003c00000ULL,
0xfffeaa8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0004ULL,
0x0001858000207802ULL, 0x000fc40000000f00ULL, 0x00000f4000007944ULL, 0x012fea0003c00000ULL,
0xfffeabb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0004ULL,
0x000185c000207802ULL, 0x000fc40000000f00ULL, 0x00000f0000007944ULL, 0x012fea0003c00000ULL,
0xfffeace000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0004ULL,
0x0001860000207802ULL, 0x000fc40000000f00ULL, 0x00000ec000007944ULL, 0x012fea0003c00000ULL,
0xfffeae0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0002ULL,
0x0001865000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff1f7224ULL, 0x000fc400078e0003ULL,
0x00000e7000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e001fULL,
0xfffeafb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0002ULL,
0x000186a000207802ULL, 0x000fc40000000f00ULL, 0x00000e2000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e001fULL, 0x00000010031f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff217224ULL, 0x000fe200078e0002ULL, 0x000186f000207802ULL, 0x000fc40000000f00ULL,
0x00000dd000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e001fULL,
0xfffeaf6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0002ULL,
0x0001874000207802ULL, 0x000fc40000000f00ULL, 0x00000d8000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e001fULL, 0xfffeaf4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x008fe40004000000ULL, 0x0001879000207802ULL, 0x000fc40000000f00ULL,
0x00000d7000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e001fULL,
0xfffec7a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x000fe40004800000ULL,
0x000187e000207802ULL, 0x000fc40000000f00ULL, 0x00000d2000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e001fULL, 0xfffec7f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e006bULL, 0x0001883000207802ULL, 0x000fc40000000f00ULL,
0x00000c9000007944ULL, 0x002fea0003c00000ULL, 0xfffec8d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e006bULL, 0x0001887000207802ULL, 0x000fc40000000f00ULL,
0x00000c5000007944ULL, 0x002fea0003c00000ULL, 0xfffeca0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e006bULL, 0x000188b000207802ULL, 0x000fc40000000f00ULL,
0x00000c1000007944ULL, 0x002fea0003c00000ULL, 0xfffecb3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e006bULL, 0x000188f000207802ULL, 0x000fc40000000f00ULL,
0x00000bd000007944ULL, 0x002fea0003c00000ULL, 0xfffecc5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e000eULL, 0x0001894000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fc400078e001dULL, 0x00000b8000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e001fULL, 0xfffecdf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e000eULL, 0x0001899000207802ULL, 0x000fc40000000f00ULL,
0x00000b3000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e001fULL,
0x000000101d1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff217224ULL, 0x000fe200078e000eULL,
0x000189e000207802ULL, 0x000fc40000000f00ULL, 0x00000ae000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e001fULL, 0xfffecda000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e000eULL, 0x00018a3000207802ULL, 0x000fc40000000f00ULL,
0x00000a9000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e001fULL,
0xfffecd8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x004fe40004000000ULL,
0x00018a8000207802ULL, 0x000fc40000000f00ULL, 0x00000a8000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e001fULL, 0xfffee3e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x000fe40004800000ULL, 0x00018ad000207802ULL, 0x000fc40000000f00ULL,
0x00000a3000007944ULL, 0x018fea0003c00000ULL, 0x0000001f00647202ULL, 0x000fe20000000f00ULL,
0xfffee42000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0069ULL,
0x00018b2000207802ULL, 0x000fc40000000f00ULL, 0x000009a000007944ULL, 0x018fea0003c00000ULL,
0xfffee50000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0069ULL,
0x00018b6000207802ULL, 0x000fc40000000f00ULL, 0x0000096000007944ULL, 0x01afea0003c00000ULL,
0xfffee63000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0069ULL,
0x00018ba000207802ULL, 0x000fc40000000f00ULL, 0x0000092000007944ULL, 0x01afea0003c00000ULL,
0xfffee76000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0069ULL,
0x00018be000207802ULL, 0x000fc40000000f00ULL, 0x000008e000007944ULL, 0x01afea0003c00000ULL,
0xfffee88000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e000eULL,
0x00018c3000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff1f7224ULL, 0x000fc400078e001dULL,
0x0000089000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e001fULL,
0xfffeea2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e000eULL,
0x00018c8000207802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e001fULL, 0x000000101d1f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff217224ULL, 0x000fe200078e000eULL, 0x00018cd000207802ULL, 0x000fc40000000f00ULL,
0x000007f000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e001fULL,
0xfffee9d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e000eULL,
0x00018d2000207802ULL, 0x000fc40000000f00ULL, 0x000007a000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e001fULL, 0xfffee9b000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x008fe40004000000ULL, 0x00018d7000207802ULL, 0x000fc40000000f00ULL,
0x0000079000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff647224ULL, 0x000fe200078e001fULL,
0xfffeff7000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x000fe40004800000ULL,
0x00018dc000207802ULL, 0x000fc40000000f00ULL, 0x0000074000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff697224ULL, 0x000fe200078e001fULL, 0xfffeffb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0013ULL, 0x00018e1000207802ULL, 0x000fc40000000f00ULL,
0x000006b000007944ULL, 0x012fea0003c00000ULL, 0xffff009000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0013ULL, 0x00018e5000207802ULL, 0x000fc40000000f00ULL,
0x0000067000007944ULL, 0x012fea0003c00000ULL, 0xffff01c000007947ULL, 0x000fea000383ffffULL,
0x0000001300217202ULL, 0x000fe40000000f00ULL, 0x00018e9000207802ULL, 0x000fc40000000f00ULL,
0x0000063000007944ULL, 0x012fea0003c00000ULL, 0xffff02f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0013ULL, 0x00018ed000207802ULL, 0x000fc40000000f00ULL,
0x000005f000007944ULL, 0x012fea0003c00000ULL, 0xffff041000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e000eULL, 0x00018f2000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fc400078e0013ULL, 0x000005a000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e001fULL, 0xffff05b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e000eULL, 0x00018f7000207802ULL, 0x000fc40000000f00ULL,
0x0000055000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e001fULL,
0x00000010131f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff217224ULL, 0x000fe200078e000eULL,
0x00018fc000207802ULL, 0x000fc40000000f00ULL, 0x0000050000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e001fULL, 0xffff056000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e000eULL, 0x0001901000207802ULL, 0x000fc40000000f00ULL,
0x000004b000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e001fULL,
0xffff054000007947ULL, 0x000fea000383ffffULL, 0x00000002ff1c7424ULL, 0x000fe200078e00ffULL,
0x0001906000507802ULL, 0x000fc40000000f00ULL, 0x0000042000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0057ULL, 0xffffdfd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x006fe200078e0052ULL, 0x00000002001c7802ULL, 0x000fc40000000f00ULL,
0x000190c000507802ULL, 0x000fc40000000f00ULL, 0x000003c000007944ULL, 0x000fea0003c00000ULL,
0x000000575200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0054ULL,
0x0001912000507802ULL, 0x000fe20000000f00ULL, 0x00000002ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000005257067208ULL, 0x000fc80004000000ULL, 0x0000036000007944ULL, 0x000fea0003c00000ULL,
0x000000575400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0053ULL,
0x0001918000507802ULL, 0x000fe20000000f00ULL, 0x00000002ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000005457547208ULL, 0x000fc80004000000ULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x000000575300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0055ULL,
0x000191e000507802ULL, 0x000fe20000000f00ULL, 0x00000001ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000005357527208ULL, 0x000fc80004000000ULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x000000575500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0006ULL,
0x0001924000507802ULL, 0x000fe20000000f00ULL, 0x00000001ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000005557047208ULL, 0x000fc80004000000ULL, 0x0000024000007944ULL, 0x000fea0003c00000ULL,
0x000000570600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0054ULL,
0x000192a000507802ULL, 0x000fe20000000f00ULL, 0x00000001ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000000657057208ULL, 0x000fc80004000000ULL, 0x000001e000007944ULL, 0x000fea0003c00000ULL,
0x000000575400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0052ULL,
0x0001930000507802ULL, 0x000fe20000000f00ULL, 0x00000001ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000005457067208ULL, 0x000fc80004000000ULL, 0x0000018000007944ULL, 0x000fea0003c00000ULL,
0xffffdea000007947ULL, 0x000fea000383ffffULL, 0x0180000005007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000077812ULL, 0x000fc800078ec0ffULL,
0x018000000700780cULL, 0x000fda0003f05070ULL, 0x0000000500008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0700720cULL, 0x040fe40003f25070ULL,
0x008000000700780cULL, 0x000fe40003f02070ULL, 0x00000001ff077807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000007ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff05ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000005057812ULL, 0x002fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000007ff7212ULL, 0x000fda000780c0ffULL, 0x0080000005000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000500007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffe6b8006007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff517424ULL, 0x000fe200078e00ffULL, 0x0000005900007348ULL, 0x000fe80003800000ULL,
0x0c00001c07577389ULL, 0x0002a200000e0056ULL, 0xfffe6b4050007950ULL, 0x000fea0003c3ffffULL,
0x0000008400007348ULL, 0x000fe80003800000ULL, 0x0000001f211f7389ULL, 0x0002a400000e0086ULL,
0x00000000ff217424ULL, 0x002fc800078e00ffULL, 0xfffe6b0020007950ULL, 0x000fea0003c3ffffULL,
0x000000011f00780cULL, 0x000fe20003f45070ULL, 0x00000000ff217424ULL, 0x000fe200078e00ffULL,
0x0000008300007348ULL, 0x000ff60003800000ULL, 0x00000000001f7806ULL, 0x000fc800050e0100ULL,
0x000000831f1f7212ULL, 0x000fe200078ec0ffULL, 0xfffe6aa020007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000200000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x00000000000004c4ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000620ULL,
0x0000000000000240ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000860ULL,
0x0000000000000268ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ac8ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b88ULL,
0x00000000000006c0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001248ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001258ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012e8ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012ecULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001500ULL,
0x0000000000019600ULL, 0xde00001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001ab00ULL,
0x0000000000000038ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001ab40ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001aec0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000012e8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000019818ULL,
0x0000000000019818ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001ab00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001aec0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_0_m_32_sm_86_cubin_len = 110496;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
