/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000019930ULL, 0x00000000000195b0ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x346a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4532336a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45346a4c4545326aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x000000676e696469ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x6e695f5f24000000ULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x722e006874617077ULL, 0x2e747865742e6c65ULL,
0x6d5f6c656e72656bULL, 0x616c65722e006168ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL,
0x0000000000000061ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL,
0x0000000000000028ULL, 0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000017cULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000b0001000001beULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b000100000204ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000b00010000024bULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b000100000291ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000002dfULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b00010000032dULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a002200000388ULL, 0x0000000000018260ULL, 0x0000000000000220ULL, 0x00040003000003feULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL,
0x0000000000018480ULL, 0x000d00030000042eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001826000000000ULL, 0x0001080400000000ULL, 0x0000288080810c00ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000001cffffffffULL, 0x0000006000000000ULL, 0x0001826000000000ULL,
0x0000022000000000ULL, 0x0000000000000000ULL, 0x0000001300082f04ULL, 0x00082304000000d9ULL,
0x0000000000000011ULL, 0x0000001100081204ULL, 0x0008110400000000ULL, 0x0000000000000011ULL,
0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL,
0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0xffffffff010c2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000f0010c2804ULL, 0x000007d000000270ULL, 0x00002f9000001fb0ULL, 0x0000310000003010ULL,
0x0000336000003230ULL, 0x00003880000034a0ULL, 0x000038a000003890ULL, 0x00003ff0000038b0ULL,
0x00004f0000004e60ULL, 0x0000511000004fe0ULL, 0x0000538000005240ULL, 0x0000561000005600ULL,
0x0000563000005620ULL, 0x00006af000005be0ULL, 0x00006c7000006b90ULL, 0x00006ed000006da0ULL,
0x0000726000007010ULL, 0x0000728000007270ULL, 0x000077e000007290ULL, 0x0000879000008700ULL,
0x000089a000008870ULL, 0x00008c1000008ad0ULL, 0x00008e8000008e70ULL, 0x00008ea000008e90ULL,
0x000095d0000095c0ULL, 0x000095f0000095e0ULL, 0x0000c1d00000c170ULL, 0x0000c4700000c430ULL,
0x0000cba00000cb70ULL, 0x0000cbf00000cbc0ULL, 0x00016b3000016a80ULL, 0x00016f4000016e40ULL,
0x000174c000017340ULL, 0x0001786000017740ULL, 0x0000047001f03904ULL, 0x0001e600000000ffULL,
0x0000055000040100ULL, 0x0001e60800000000ULL, 0x00000660003f0100ULL, 0x0001e68800000002ULL,
0x00000dd0003f0100ULL, 0x0001e6000000001dULL, 0x00000f70003f0107ULL, 0x0001e68800000000ULL,
0x00002d20003f0101ULL, 0x0001e6080000000bULL, 0x00002d40003f0101ULL, 0x0001e6080000000bULL,
0x00002eb0003f0109ULL, 0x0001e6080000000bULL, 0x00003f60003f0109ULL, 0x0001e6880000006dULL,
0x00004c30003f0101ULL, 0x0001e62800000071ULL, 0x00004c50003f0101ULL, 0x0001e62800000071ULL,
0x00004dc0003f0109ULL, 0x0001e62800000071ULL, 0x00005b30003f0109ULL, 0x0001e6900000006dULL,
0x000068c0003f0101ULL, 0x0001e64800000025ULL, 0x000068e0003f0101ULL, 0x0001e64800000025ULL,
0x00006a50003f0109ULL, 0x0001e64800000025ULL, 0x00007760003f0109ULL, 0x0001e6980000006cULL,
0x000084e0003f0101ULL, 0x0001e6680000002bULL, 0x00008500003f0101ULL, 0x0001e6680000002bULL,
0x00008670003f0109ULL, 0x0001e6680000002bULL, 0x000092a0003f0109ULL, 0x0001e6a000000000ULL,
0x0000e3d0003f0101ULL, 0x0001e6000000001dULL, 0x0000fc70003f0101ULL, 0x0001e6000000001dULL,
0x0000fde0003f0109ULL, 0x0001e6000000001dULL, 0x00014260003f0109ULL, 0x0001e68800000099ULL,
0x00014760003f0101ULL, 0x0001e68800000099ULL, 0x000148d0003f0109ULL, 0x0001e68800000099ULL,
0x00018200003f0109ULL, 0x0001e60800000008ULL, 0x00018210003f0101ULL, 0x0001e61000000008ULL,
0x00018220003f0101ULL, 0x0001e61800000008ULL, 0x00018230003f0101ULL, 0x0001e62000000008ULL,
0x00033803003f0101ULL, 0x0000d79000301c04ULL, 0x0000d9a00000d7f0ULL, 0x0000dc600000db00ULL,
0x0000df200000ddc0ULL, 0x0000e2100000e080ULL, 0x0000fe100000e310ULL, 0x000c050400018250ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0060190300000000ULL, 0x0000001400080a04ULL,
0x0000000000600210ULL, 0x00000000000000bcULL, 0x0000001300000002ULL, 0x0000000000018260ULL,
0x0000000000000044ULL, 0x0000001300000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL,
0x0000001300000002ULL, 0x0000000000000000ULL, 0x000000000001e700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff047b82ULL, 0x000ea20000000a00ULL,
0x00000000000b7919ULL, 0x000ee20000002300ULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x0000000000247919ULL, 0x000f2a0000002600ULL, 0x00000300ff267b82ULL, 0x000f620000000800ULL,
0x0000000000097919ULL, 0x000ea20000002100ULL, 0x00000000009b7919ULL, 0x000f6c0000002700ULL,
0x00000400ff067b82ULL, 0x000ee20000000800ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x0000000500007306ULL, 0x004ea20000209000ULL, 0x000000ff0500720cULL, 0x000fca0003f45070ULL,
0x00008600ff157b82ULL, 0x000f640000000800ULL, 0x0000000000007308ULL, 0x004ea20000001000ULL,
0x00000005ff227819ULL, 0x002fcc0000011609ULL, 0x00001fff22227589ULL, 0x000f6200000e0000ULL,
0x0ffffffe00027836ULL, 0x004fc80000000000ULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff087224ULL, 0x004fc800078e0a03ULL,
0x0000000508077224ULL, 0x000fe400078e02ffULL, 0x0000000000087919ULL, 0x000e640000002200ULL,
0x0000000703037227ULL, 0x000fcc00078e0002ULL, 0x0000000603077227ULL, 0x008fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a07ULL, 0x0000000005007224ULL, 0x000fca00078e0206ULL,
0x000000050000720cULL, 0x000fda0003f06070ULL, 0x8000000500000210ULL, 0x000fe20007ffe0ffULL,
0x0000000107070836ULL, 0x000fc60000000000ULL, 0x000000050000720cULL, 0x000fda0003f26070ULL,
0x0000000107071836ULL, 0x000fe20000000000ULL, 0x00000005ff07a212ULL, 0x000fc800078e33ffULL,
0x0000000700007306ULL, 0x000ea20000209000ULL, 0x000000ff0700720cULL, 0x000fce0003f65070ULL,
0x0000000000007308ULL, 0x004ea40000001000ULL, 0x0ffffffe00027836ULL, 0x004fe40000000000ULL,
0x000000040b007c24ULL, 0x002fe2000f8e0208ULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000200037305ULL, 0x0002a2000021f000ULL, 0x00001fff0b0b7589ULL, 0x000f6200000e0000ULL,
0x000000ff00027202ULL, 0x002fe20000000f00ULL, 0x0000000307067224ULL, 0x004fc800078e02ffULL,
0x000000ffff0d7224ULL, 0x000fc800078e0a06ULL, 0x0000000d03037227ULL, 0x000fc800078e0002ULL,
0x0000000400027c24ULL, 0x000fe4000f8e0209ULL, 0x0000002403167227ULL, 0x010fc600078e00ffULL,
0x0000007f0200780cULL, 0x000fe20003f44070ULL, 0x000000ffff037224ULL, 0x000fc800078e0a16ULL,
0x0000000307007224ULL, 0x000fca00078e0224ULL, 0x000000070000720cULL, 0x000fc60003f06070ULL,
0x000000000006a919ULL, 0x000e620000008800ULL, 0x000004000003a802ULL, 0x000fd20000000f00ULL,
0x0000000100000824ULL, 0x000fe400078e0a07ULL, 0x0000000116160836ULL, 0x000fe20000000000ULL,
0x000000ff0200720cULL, 0x000fe40003f05270ULL, 0x000000070000720cULL, 0x000fda0003f26070ULL,
0x0000000116161836ULL, 0x000fe20000000000ULL, 0x00000007ff16b212ULL, 0x000fe400078e33ffULL,
0x0000000f0200780cULL, 0x000fe40003f24070ULL, 0x000000ff16007210ULL, 0x000fe40007ffe1ffULL,
0x000006540603a816ULL, 0x002fe40000000003ULL, 0x000000030200780cULL, 0x000fe20003f64070ULL,
0x0000000007247224ULL, 0x000fc400078e0224ULL, 0xff317217ff07a424ULL, 0x000fe400078e00ffULL,
0x000000040206a824ULL, 0x000fe200078e0203ULL, 0x0000000000240947ULL, 0x020fee0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01e60006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000402007c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000000612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01e60804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000402027c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000020612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01e68804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002024007824ULL, 0x000fe200078e00ffULL, 0x0000001504037219ULL, 0x080fe200000006ffULL,
0x0000000000237919ULL, 0x000e620000002500ULL, 0x0000001505207219ULL, 0x080fe200000006ffULL,
0x000000ffff027224ULL, 0x000fe200078e0a00ULL, 0x000000000300720cULL, 0x000fe20003f06070ULL,
0x01e400070600a388ULL, 0x0003e20000000800ULL, 0x00000015161f7219ULL, 0x000fe200000006ffULL,
0x000000049b047224ULL, 0x000fe200078e02ffULL, 0x0000002003217446ULL, 0x000fe20003800002ULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x000000220b027211ULL, 0x000fe200078e10ffULL,
0x0000002004047224ULL, 0x000fe200078e021fULL, 0x000000ff21217207ULL, 0x000fc60000000000ULL,
0x0000000402027824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000202100780cULL, 0x000fda0003f05270ULL, 0x0000000000c48947ULL, 0x002fea0003800000ULL,
0x00000000001e7919ULL, 0x000e620000000000ULL, 0xffffffffff087424ULL, 0x000fe200078e00ffULL,
0x0000000221037248ULL, 0x000fe20007fe0000ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000000000e7919ULL, 0x000ea20000008800ULL, 0x00000400001d7802ULL, 0x000fe40000000f00ULL,
0x0000001508077219ULL, 0x000fe200000006ffULL, 0x0000000103037824ULL, 0x000fe200078e0a02ULL,
0x00000004ff067819ULL, 0x002fc8000001161eULL, 0x000000030600720cULL, 0x000fe20003f06070ULL,
0x00000002060a7836ULL, 0x000fe20000000000ULL, 0x000006540e1d7816ULL, 0x004fe2000000001dULL,
0x00000001020f7824ULL, 0x000fc600078e0206ULL, 0x0000000a02117210ULL, 0x000fe20007ffe0ffULL,
0x0000000100087824ULL, 0x000fe200078e020fULL, 0x000000030a00720cULL, 0x000fc60003f26070ULL,
0x00000001000c7824ULL, 0x000fe200078e0211ULL, 0x0000000708097212ULL, 0x080fe200078e30ffULL,
0x0000000111067824ULL, 0x040fe200078e021eULL, 0x0000000411117819ULL, 0x000fe400000006ffULL,
0x000000070c137212ULL, 0x000fe200078e30ffULL, 0x0000000104097824ULL, 0x000fe200078e0209ULL,
0x00000015ff077219ULL, 0x080fe40000011608ULL, 0x00000015ff0d7219ULL, 0x000fe4000001160cULL,
0x0000001304137210ULL, 0x000fe20007ffe0ffULL, 0x0000002007027224ULL, 0x000fe200078e0209ULL,
0xfffffff011067812ULL, 0x000fe200078ee206ULL, 0x000000101e077824ULL, 0x000fc400078e00ffULL,
0x000000200d087224ULL, 0x000fe400078e0213ULL, 0x0000010002027825ULL, 0x000fe200078e00ffULL,
0x000000f0070d7812ULL, 0x000fc600078ec0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000d02027212ULL, 0x000fc600078efcffULL, 0x000000010f047824ULL, 0x040fe200078e021eULL,
0x0000000d08087212ULL, 0x000fe200078efcffULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0x0000000402027c10ULL, 0x000fe4000ff5e0ffULL, 0x0000000408087c10ULL, 0x000fe4000ff7e0ffULL,
0xfffffff00f047812ULL, 0x000fe200078ee204ULL, 0x00000010060f7824ULL, 0x100fe200078e021dULL,
0x0000000503037c10ULL, 0x000fe400097fe4ffULL, 0x0000000509097c10ULL, 0x000fe20009ffe4ffULL,
0x00000010040d7824ULL, 0x000fca00078e021dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020d7faeULL, 0x0003e8000c101c46ULL, 0x00000000080f7faeULL, 0x0003e2000c901c46ULL,
0x0000000000a87947ULL, 0x000fea0003800000ULL, 0x00000000001e7919ULL, 0x000e620000000000ULL,
0x00000400001d7802ULL, 0x000fe20000000f00ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000000087919ULL, 0x000ea20000008800ULL, 0x000000021e0d7211ULL, 0x002fe200078fe0ffULL,
0xffffffffff027424ULL, 0x000fe200078e00ffULL, 0x00000654081d7816ULL, 0x004fc6000000001dULL,
0x000000020d0f7836ULL, 0x000fe20000000000ULL, 0x0000001502117219ULL, 0x000fe400000006ffULL,
0x0000000d00027210ULL, 0x000fe20007ffe0ffULL, 0x0000000100067824ULL, 0x000fc600078e020fULL,
0x0000001102077212ULL, 0x080fe400078e30ffULL, 0x0000001106117212ULL, 0x000fe400078e30ffULL,
0x00000015ff037219ULL, 0x080fe20000011602ULL, 0x0000000104077824ULL, 0x040fe200078e0207ULL,
0x00000015ff097219ULL, 0x000fe20000011606ULL, 0x0000000104117824ULL, 0x000fe200078e0211ULL,
0x0000001e0d047210ULL, 0x000fe20007ffe0ffULL, 0x0000002003037224ULL, 0x000fe400078e0207ULL,
0x000000101e077824ULL, 0x000fc400078e00ffULL, 0x0000002009097224ULL, 0x000fe400078e0211ULL,
0x0000010003027825ULL, 0x000fe200078e00ffULL, 0x000000f007117812ULL, 0x000fc600078ec0ffULL,
0x0000010009087825ULL, 0x000fe200078e00ffULL, 0x0000001102027212ULL, 0x000fc600078efcffULL,
0x000000100d0d7824ULL, 0x000fe200078e00ffULL, 0x0000001108087212ULL, 0x000fe200078efcffULL,
0x000000010f067824ULL, 0x040fe200078e021eULL, 0x0000000402027c10ULL, 0x000fe2000ff1e0ffULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff00d047812ULL, 0x000fe400078ee204ULL,
0x0000000408087c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff00f067812ULL, 0x000fe200078ee206ULL,
0x00000010040d7824ULL, 0x000fe200078e021dULL, 0x0000000503037c10ULL, 0x000fc400087fe4ffULL,
0x0000000509097c10ULL, 0x000fe40008ffe4ffULL, 0x0000001d060f7211ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020d7faeULL, 0x0003e8000b901c46ULL,
0x00000000080f7faeULL, 0x0003e4000b901c46ULL, 0x000000001d0472caULL, 0x000fe200000e0000ULL,
0x00009200ff027b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0001e60004047890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x000000049b027825ULL, 0x002fe200078e0002ULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x00000006021c7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe20003f05270ULL, 0x0000007f1c1b7836ULL, 0x004fe40000000000ULL,
0x000000ff1c1a7836ULL, 0x000fc60000000000ULL, 0x00000007ff1b7819ULL, 0x000fe4000001161bULL,
0x00000008ff1a7819ULL, 0x000fca000001161aULL, 0x000000d400208947ULL, 0x000fea0003800000ULL,
0x00000003ff007819ULL, 0x000fe20000011622ULL, 0x0000000822197824ULL, 0x000fe400078e00ffULL,
0xffffffffff287424ULL, 0x000fe200078e00ffULL, 0x01ffffff00007812ULL, 0x000fe200078ec0ffULL,
0x00000004ff0b7424ULL, 0x000fc800078e00ffULL, 0x00000002232a7824ULL, 0x000fca00078e0200ULL,
0x0000001b2a00720cULL, 0x000fda0003f06070ULL, 0x00009400ff038b82ULL, 0x000e620000000800ULL,
0x000000029b008824ULL, 0x000fce00078e00ffULL, 0x00009000ff088b82ULL, 0x000ea20000000a00ULL,
0x0000000300038224ULL, 0x002fe400078e0203ULL, 0x000000011d007824ULL, 0x000fc600078e0219ULL,
0x000000032a038210ULL, 0x000fe20007ffe0ffULL, 0x01e6880b00ff79a7ULL, 0x0003e8000850003fULL,
0x0000000403088825ULL, 0x004fca00078e0008ULL, 0x0000000608288981ULL, 0x000ea2000c1e1900ULL,
0x00000001230b7810ULL, 0x002fe20007ffe0ffULL, 0x0000008016167824ULL, 0x000fe200078e00ffULL,
0x00000001ff187819ULL, 0x000fe40000011622ULL, 0x0000001a0b00720cULL, 0x000fe20003f06070ULL,
0x00008e00ff027b82ULL, 0x000e640000000a00ULL, 0x0000002018177824ULL, 0x000fe200078e00ffULL,
0x0000000122157812ULL, 0x000fc600078ec0ffULL, 0x00000100230b7824ULL, 0x000fca00078e0217ULL,
0x0000006016327812ULL, 0x000fe200078ef80bULL, 0x0000000528057224ULL, 0x004fc800078e02ffULL,
0x0000008005057824ULL, 0x000fc800078e00ffULL, 0x0000010005027825ULL, 0x002fe200078e0002ULL,
0x0000000400948947ULL, 0x000fec0003800000ULL, 0x0000007007047812ULL, 0x000fe200078ec0ffULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0x00000003ff0f7819ULL, 0x000fe4000001161eULL,
0x0000000415047211ULL, 0x000fe400078e38ffULL, 0x0000000b1c007248ULL, 0x000fe20007fe0000ULL,
0x0000000132077824ULL, 0x000fe200078e020fULL, 0x0000000c0f277810ULL, 0x000fe20007ffe0ffULL,
0x000000040f097836ULL, 0x000fe20000000000ULL, 0x0000001c0f2f7810ULL, 0x000fe20007ffe0ffULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x0000000327127819ULL, 0x000fc400000006ffULL,
0x0000001e09087210ULL, 0x000fe20007ffe0ffULL, 0x0000000809137824ULL, 0x000fe200078e00ffULL,
0x00000006020c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe400078e0a0bULL,
0x0000400018067824ULL, 0x000fe200078e021dULL, 0xfffffff813137812ULL, 0x000fe200078ee208ULL,
0x00000001030d7824ULL, 0x000fe200000e0607ULL, 0x0000002000007446ULL, 0x000fe2000380000bULL,
0x000000010f087824ULL, 0x040fe200078e021eULL, 0x00000027320b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000132077824ULL, 0x000fe200078e0209ULL, 0x000000000f00720cULL, 0x080fe20003f06070ULL,
0x00002000150e7824ULL, 0x000fe200078e0206ULL, 0x0000000708117812ULL, 0x000fe200078ec0ffULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x000000000900720cULL, 0x000fc40003f26070ULL,
0x0ffffff811117812ULL, 0x000fe200078ef81eULL, 0x000160000e107836ULL, 0x000fe20000000000ULL,
0x0000000602067210ULL, 0x000fe20007f5e0ffULL, 0x000000100f297836ULL, 0x000fe20000000000ULL,
0x000000002700720cULL, 0x000fe20003f86070ULL, 0x0000001011117824ULL, 0x000fe200078e0210ULL,
0x0000001013137211ULL, 0x000fe200078e20ffULL, 0x0000000103077824ULL, 0x000fe400010e0607ULL,
0x000000080f257836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c117faeULL, 0x0003e2000c101c46ULL, 0x000000140f2b7836ULL, 0x000fe20000000000ULL,
0x000000002f00720cULL, 0x080fe20003f06070ULL, 0x000000180f2d7836ULL, 0x000fe20000000000ULL,
0x0000000006137faeULL, 0x0005e2000c901c46ULL, 0x00000001320f7824ULL, 0x040fe200078e0229ULL,
0x000000002500720cULL, 0x080fe20003fa6070ULL, 0x0000000132097824ULL, 0x000fe200078e0225ULL,
0x000000002d00720cULL, 0x000fe20003f26070ULL, 0x000001000b0a7825ULL, 0x000fc800078e0004ULL,
0x00000001270d7824ULL, 0x002fe200078e021eULL, 0x0000000a020a7210ULL, 0x000fe20007f5e0ffULL,
0x0000010009087825ULL, 0x000fc600078e0004ULL, 0xfffffff812137812ULL, 0x004fe200078ee20dULL,
0x000001000f067825ULL, 0x000fe200078e0004ULL, 0x0000000802087210ULL, 0x000fc60007f7e0ffULL,
0x00000001320f7824ULL, 0x040fe200078e022bULL, 0x00000006020c7210ULL, 0x000fe20007fde0ffULL,
0x00000001250e7824ULL, 0x040fe400078e021eULL, 0x0000000825257824ULL, 0x000fe400078e00ffULL,
0x00000001030d7824ULL, 0x000fe400030e0607ULL, 0x000001000f067825ULL, 0x000fe200078e0004ULL,
0xfffffff825117812ULL, 0x000fe400078ee20eULL, 0x0000001e2b0f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000103097824ULL, 0x000fe200018e0609ULL, 0x000000002900720cULL, 0x080fe20003f66070ULL,
0x00000001030b7824ULL, 0x000fe200010e060bULL, 0x000000002b00720cULL, 0x040fe20003f46070ULL,
0x000000082b127824ULL, 0x000fe200078e00ffULL, 0x00000006020e7210ULL, 0x000fe20007fde0ffULL,
0x0000000129007824ULL, 0x000fe200078e021eULL, 0x0000001011117211ULL, 0x000fe200078e20ffULL,
0x0000000829257824ULL, 0x000fe200078e00ffULL, 0xfffffff812277812ULL, 0x000fe200078ee20fULL,
0x0000000132297824ULL, 0x000fc400078e022dULL, 0x00000001030f7824ULL, 0x000fe200030e0607ULL,
0xfffffff825257812ULL, 0x000fe200078ee200ULL, 0x0000010029067825ULL, 0x000fe200078e0004ULL,
0x0000001e2d007210ULL, 0x000fe20007ffe0ffULL, 0x0000000008117faeULL, 0x0003e4000e901c46ULL,
0x00000001322b7824ULL, 0x000fe200078e022fULL, 0x0000000602067210ULL, 0x000fe20007fde0ffULL,
0x000000082d297824ULL, 0x000fe400078e00ffULL, 0x000000012f127824ULL, 0x000fc400078e021eULL,
0x000001002b047825ULL, 0x000fe200078e0004ULL, 0xfffffff829297812ULL, 0x000fc600078ee200ULL,
0x000000082f2f7824ULL, 0x000fe400078e00ffULL, 0x0000000103077824ULL, 0x000fe200030e0607ULL,
0x0000000402027210ULL, 0x000fe20007fde0ffULL, 0x0000001013137824ULL, 0x100fe200078e0210ULL,
0xfffffff82f2b7812ULL, 0x000fe200078ee212ULL, 0x0000001025257824ULL, 0x100fe400078e0210ULL,
0x0000001027277824ULL, 0x100fe200078e0210ULL, 0x000000102b2b7211ULL, 0x000fe200078e20ffULL,
0x0000001029297824ULL, 0x000fe200078e0210ULL, 0x000000000a137faeULL, 0x0003e2000e101c46ULL,
0x0000000103037824ULL, 0x000fc600030e0605ULL, 0x000000000c257faeULL, 0x0003e8000d901c46ULL,
0x000000000e277faeULL, 0x0003e8000d101c46ULL, 0x0000000006297faeULL, 0x0003e8000c901c46ULL,
0x00000000022b7faeULL, 0x0003e2000c101c46ULL, 0x0000000400607947ULL, 0x000fea0003800000ULL,
0x000000041e057811ULL, 0x040fe400078fe8ffULL, 0x000000081e0b7811ULL, 0x040fe400078fe8ffULL,
0x0000000c1e0d7811ULL, 0x040fe200078fe8ffULL, 0x0000000105007824ULL, 0x140fe200078e021eULL,
0x000000181e137811ULL, 0x040fe200078fe8ffULL, 0x0000000805097824ULL, 0x000fe200078e00ffULL,
0x000000030b297819ULL, 0x040fe200000006ffULL, 0x000000010b047824ULL, 0x100fe200078e021eULL,
0x000000101e0f7811ULL, 0x040fe200078fe8ffULL, 0x000000080d2b7824ULL, 0x040fe200078e00ffULL,
0xfffffff809147812ULL, 0x000fe200078ee200ULL, 0x000000010d007824ULL, 0x100fe200078e021eULL,
0xfffffff829297812ULL, 0x000fe200078ee204ULL, 0x0000000113087824ULL, 0x140fe200078e021eULL,
0x000000141e117811ULL, 0x040fe200078fe8ffULL, 0x0000000813277824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee200ULL, 0x000000010f047824ULL, 0x140fe200078e021eULL,
0x0000001e1e007211ULL, 0x040fe200078fe8ffULL, 0x000000080f097824ULL, 0x000fe200078e00ffULL,
0xfffffff827307812ULL, 0x000fe200078ee208ULL, 0x0000000811257824ULL, 0x000fe200078e00ffULL,
0x0000001c1e277811ULL, 0x000fe200078fe8ffULL, 0x00000001320b7824ULL, 0x040fe200078e020bULL,
0x0000001e11067210ULL, 0x000fe20007ffe0ffULL, 0x00000001320d7824ULL, 0x000fe200078e020dULL,
0xfffffff8092c7812ULL, 0x000fe200078ee204ULL, 0x0000400018047824ULL, 0x000fe200078e021dULL,
0x0000007007127812ULL, 0x000fe200078ec0ffULL, 0x00000008272d7824ULL, 0x040fe200078e00ffULL,
0x0000000700077812ULL, 0x000fe200078ec0ffULL, 0x0000000127007824ULL, 0x000fe200078e021eULL,
0xfffffff8252e7812ULL, 0x000fe200078ee206ULL, 0x0000000132097824ULL, 0x000fe200078e0205ULL,
0x0000001215127211ULL, 0x040fe200078e38ffULL, 0x0000200015047824ULL, 0x000fe200078e0204ULL,
0x000000321e057211ULL, 0x000fe200078fe8ffULL, 0x0000000132257824ULL, 0x040fe200078e0213ULL,
0x0000000f320f7210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200078e00ffULL,
0x0000002732277210ULL, 0x000fe20007ffe0ffULL, 0x0000000132117824ULL, 0x000fe200078e0211ULL,
0xfffffff82d327812ULL, 0x000fe200078ee200ULL, 0x0001600004337836ULL, 0x000fe20000000000ULL,
0x0ffffff807007812ULL, 0x000fe200078ef81eULL, 0x0000010005047825ULL, 0x000fc600078e0012ULL,
0x0000003329297211ULL, 0x000fe200078e20ffULL, 0x0000010009067825ULL, 0x000fe200078e0012ULL,
0x0000000402047210ULL, 0x000fc60007f1e0ffULL, 0x000001000b087825ULL, 0x000fe200078e0012ULL,
0x0000000602067210ULL, 0x000fc60007f3e0ffULL, 0x000001000d0a7825ULL, 0x000fe200078e0012ULL,
0x0000000802087210ULL, 0x000fc60007f5e0ffULL, 0x000001000f0c7825ULL, 0x000fe200078e0012ULL,
0x0000000a020a7210ULL, 0x000fc60007f7e0ffULL, 0x00000100110e7825ULL, 0x000fc800078e0012ULL,
0x0000010025107825ULL, 0x000fc800078e0012ULL, 0x0000010027127825ULL, 0x000fc800078e0012ULL,
0x0000000103057824ULL, 0x040fe200000e0605ULL, 0x0000000c020c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000103077824ULL, 0x040fe200008e0607ULL, 0x0000000e020e7210ULL, 0x000fe20007f3e0ffULL,
0x0000001000257824ULL, 0x000fe200078e0233ULL, 0x0000000d030d7210ULL, 0x000fe200007fe4ffULL,
0x0000000103097824ULL, 0x040fe200010e0609ULL, 0x0000001002107210ULL, 0x000fe20007f5e0ffULL,
0x0000001014277824ULL, 0x000fe200078e0233ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004257faeULL, 0x0003e2000b901c46ULL, 0x00000001030b7824ULL, 0x000fe200018e060bULL,
0x0000001202027210ULL, 0x000fe20007f7e0ffULL, 0x000000102b2b7824ULL, 0x100fe200078e0233ULL,
0x0000000006277faeULL, 0x0003e2000b901c46ULL, 0x000000102c2d7824ULL, 0x000fc400078e0233ULL,
0x000000102e2f7824ULL, 0x000fe200078e0233ULL, 0x0000000008297faeULL, 0x0003e2000b901c46ULL,
0x00000001030f7824ULL, 0x040fe400008e060fULL, 0x0000001030317824ULL, 0x000fe200078e0233ULL,
0x0000003332337211ULL, 0x000fe200078e20ffULL, 0x0000000103117824ULL, 0x040fe200010e0611ULL,
0x000000000a2b7faeULL, 0x0003e2000b901c46ULL, 0x0000000103037824ULL, 0x000fc600018e0613ULL,
0x000000000c2d7faeULL, 0x0003e8000b901c46ULL, 0x000000000e2f7faeULL, 0x0003e8000b901c46ULL,
0x0000000010317faeULL, 0x0003e8000b901c46ULL, 0x0000000002337faeULL, 0x0003e4000b901c46ULL,
0x0000001a2300720cULL, 0x000fe20003f06070ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xff31721700297802ULL, 0x002fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fc4000001ff00ULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fc4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fc4000001ff00ULL,
0x00000000004e7805ULL, 0x000fe4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000527805ULL, 0x000fe4000001ff00ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x0000000000547805ULL, 0x000fc4000001ff00ULL,
0x00000000005a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000587805ULL, 0x000fe4000001ff00ULL,
0x0000000000767805ULL, 0x000fe4000001ff00ULL, 0x0000000000747805ULL, 0x000fe4000001ff00ULL,
0x00000000007a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000787805ULL, 0x000fc4000001ff00ULL,
0x0000000000667805ULL, 0x000fe4000001ff00ULL, 0x0000000000647805ULL, 0x000fe4000001ff00ULL,
0x00000000006a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000687805ULL, 0x000fe2000001ff00ULL,
0x0000007400500947ULL, 0x000fec0003800000ULL, 0x00009400ff037b82ULL, 0x000e620000000800ULL,
0x000000029b147824ULL, 0x000fe200078e00ffULL, 0x000000ff002f7202ULL, 0x000fe20000000f00ULL,
0xff317217ff297424ULL, 0x000fe400078e00ffULL, 0x0000000314147224ULL, 0x002fce00078e0203ULL,
0x00008e00ff027b82ULL, 0x000e620000000a00ULL, 0x0000001022007824ULL, 0x000fe200078e00ffULL,
0x00000001230d7810ULL, 0x000fe20007ffe0ffULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x0000000428287c24ULL, 0x010fe2000f8e02ffULL, 0xffffffe000007812ULL, 0x000fe400078ec0ffULL,
0x0000001a0d00720cULL, 0x000fe20003f06070ULL, 0x00000080280b7824ULL, 0x000fe400078e00ffULL,
0x0000010023007824ULL, 0x000fc800078e0200ULL, 0x00000040000f7836ULL, 0x000fca0000000000ULL,
0x000000600f057812ULL, 0x000fe200078ec0ffULL, 0x000001000b027825ULL, 0x002fc800078e0002ULL,
0x00000001162b7824ULL, 0x000fe200078e0205ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400a08947ULL, 0x000fea0003800000ULL, 0x000000101e067824ULL, 0x000fe200078e00ffULL,
0x00000003ff257819ULL, 0x100fe2000001161eULL, 0x0000008022047824ULL, 0x000fe200078e00ffULL,
0x0000000f1c007248ULL, 0x000fe20007fe0000ULL, 0x0000400018137824ULL, 0x000fe200078e021dULL,
0x000000ff0f057210ULL, 0x000fe20007ffe1ffULL, 0x00000004255d7836ULL, 0x000fe20000000000ULL,
0x00000070060b7812ULL, 0x000fe200078ec0ffULL, 0x00000001250d7824ULL, 0x000fe200078e022bULL,
0x0000002000007446ULL, 0x000fe20003800005ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x000000800b047812ULL, 0x000fe200078ef804ULL, 0x0000200022067824ULL, 0x000fe200078e00ffULL,
0x0000002b5d0f7210ULL, 0x000fe20007ffe0ffULL, 0x000000015d107824ULL, 0x000fe200078e021eULL,
0x0000001e250b7210ULL, 0x000fe20007ffe0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e0004ULL,
0x0000200006067812ULL, 0x000fc400078ec0ffULL, 0x000000070b0b7812ULL, 0x000fe200078ec0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0004ULL, 0x0000000c020c7210ULL, 0x000fe40007f1e0ffULL,
0x000000002500720cULL, 0x080fe20003f26070ULL, 0x0000000c255f7836ULL, 0x000fe20000000000ULL,
0x0001700013067810ULL, 0x000fe20007ffe006ULL, 0x000000085d137824ULL, 0x000fe200078e00ffULL,
0x0000000e02127210ULL, 0x000fe20007f5e0ffULL, 0x00000001030d7824ULL, 0x000fe200000e060dULL,
0x0ffffff80b0b7812ULL, 0x000fe200078ef81eULL, 0x00000014256f7836ULL, 0x000fe20000000000ULL,
0x000000005d00720cULL, 0x000fe20003f06070ULL, 0x0000001825717836ULL, 0x000fe20000000000ULL,
0xfffffff8135d7812ULL, 0x000fe200078ee210ULL, 0x0000000103137824ULL, 0x000fe200010e060fULL,
0x000000060b0b7211ULL, 0x000fe200078e20ffULL, 0x00000008250f7836ULL, 0x000fe20000000000ULL,
0x0000001025637810ULL, 0x000fe20007ffe0ffULL, 0x0000001c25737836ULL, 0x000fe20000000000ULL,
0x000000005f00720cULL, 0x080fe20003fa6070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0b7faeULL, 0x0003e2000c901c46ULL, 0x000000080f617824ULL, 0x040fe200078e00ffULL,
0x000000000f00720cULL, 0x080fe20003fc6070ULL, 0x0000000163257824ULL, 0x040fe200078e022bULL,
0x000000006300720cULL, 0x0c0fe20003f86070ULL, 0x00000008636d7824ULL, 0x000fe200078e00ffULL,
0x000000006f00720cULL, 0x000fc40003f66070ULL, 0x000000007100720cULL, 0x080fe40003f46070ULL,
0x000000007300720cULL, 0x000fe20003f26070ULL, 0x000000015f007824ULL, 0x000fe200078e021eULL,
0x0000001e0f0c7210ULL, 0x002fe20007ffe0ffULL, 0x000000010f0d7824ULL, 0x000fe200078e022bULL,
0x0000002b5f0f7210ULL, 0x000fe20007ffe0ffULL, 0x000000105d0b7824ULL, 0x000fe200078e0206ULL,
0xfffffff861617812ULL, 0x000fe200078ee20cULL, 0x000001000d0c7825ULL, 0x000fe200078e0004ULL,
0x0000001e63107210ULL, 0x000fc40007ffe0ffULL, 0x00000000120b7faeULL, 0x0003e2000c101c46ULL,
0x000001000f0e7825ULL, 0x000fe200078e0004ULL, 0x0000000c025c7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee210ULL, 0x000000085f5f7824ULL, 0x000fe200078e00ffULL,
0x0000001e73107210ULL, 0x000fe20007ffe0ffULL, 0x00000001035d7824ULL, 0x000fe400000e060dULL,
0x00000100250c7825ULL, 0x000fe200078e0004ULL, 0xfffffff85f637812ULL, 0x000fc400078ee200ULL,
0x0000000e02127210ULL, 0x002fe20007f1e0ffULL, 0x000000016f007824ULL, 0x040fe200078e021eULL,
0x000000036f257819ULL, 0x040fe200000006ffULL, 0x000000016f0b7824ULL, 0x000fe400078e022bULL,
0x0000000103137824ULL, 0x000fe200000e060fULL, 0x0000000c025e7210ULL, 0x000fe20007f1e0ffULL,
0x000001000b0e7825ULL, 0x000fe200078e0004ULL, 0xfffffff8256f7812ULL, 0x000fe400078ee200ULL,
0x0000000d035f7210ULL, 0x000fe200007fe4ffULL, 0x0000000171257824ULL, 0x100fe200078e022bULL,
0x0000000e020e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001730b7824ULL, 0x000fc400078e022bULL,
0x00000100250c7825ULL, 0x000fc800078e0004ULL, 0x00000001030f7824ULL, 0x000fe200000e060fULL,
0x0000000c020c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000171007824ULL, 0x040fe400078e021eULL,
0x0000000871717824ULL, 0x000fe400078e00ffULL, 0x0000000873737824ULL, 0x000fe400078e00ffULL,
0x000001000b047825ULL, 0x000fe200078e0004ULL, 0xfffffff871717812ULL, 0x000fe400078ee200ULL,
0xfffffff873737812ULL, 0x000fe200078ee210ULL, 0x00000001030d7824ULL, 0x000fe200000e060dULL,
0x00000006610b7211ULL, 0x080fe200078e20ffULL, 0x0000001063257824ULL, 0x100fe200078e0206ULL,
0x0000000402027210ULL, 0x000fe20007f1e0ffULL, 0x000000106d2b7824ULL, 0x100fe200078e0206ULL,
0x0000000671637211ULL, 0x000fe200078e20ffULL, 0x000000106f617824ULL, 0x100fe200078e0206ULL,
0x000000005c0b7faeULL, 0x0003e2000f101c46ULL, 0x00000010736d7824ULL, 0x000fc400078e0206ULL,
0x0000000103037824ULL, 0x000fe200000e0605ULL, 0x0000000012257faeULL, 0x0003e8000e901c46ULL,
0x000000005e2b7faeULL, 0x0003e8000e101c46ULL, 0x000000000e617faeULL, 0x0003e8000d901c46ULL,
0x000000000c637faeULL, 0x0003e8000d101c46ULL, 0x00000000026d7faeULL, 0x0003e2000c901c46ULL,
0x00000004006c7947ULL, 0x000fea0003800000ULL, 0x0000200022047824ULL, 0x000fe200078e00ffULL,
0x000000041e007819ULL, 0x000fe200000006ffULL, 0x0000400018187824ULL, 0x000fe200078e021dULL,
0x000000101e5d7811ULL, 0x000fe200078fe8ffULL, 0x0000008022637824ULL, 0x000fe200078e00ffULL,
0x0000200004057812ULL, 0x000fe400078ec0ffULL, 0x0000007000007812ULL, 0x000fe200078ec0ffULL,
0x000000085d067824ULL, 0x000fe200078e00ffULL, 0x000000081e0f7811ULL, 0x040fe400078fe8ffULL,
0x000000041e0d7811ULL, 0x000fc400078fe8ffULL, 0x0001700018187810ULL, 0x000fe20007ffe005ULL,
0x000000015d057824ULL, 0x100fe200078e021eULL, 0x0000008000627812ULL, 0x000fe200078ef863ULL,
0x000000010f007824ULL, 0x140fe200078e021eULL, 0x000000181e617811ULL, 0x040fe200078fe8ffULL,
0x000000080f637824ULL, 0x000fe200078e00ffULL, 0x000000030d257819ULL, 0x040fe200000006ffULL,
0x000000010d047824ULL, 0x100fe200078e021eULL, 0x0000000c1e137811ULL, 0x040fe200078fe8ffULL,
0x00000008610c7824ULL, 0x040fe200078e00ffULL, 0xfffffff8066f7812ULL, 0x000fe200078ee205ULL,
0x0000000161057824ULL, 0x100fe200078e021eULL, 0xfffffff863637812ULL, 0x000fe200078ee200ULL,
0x000000010d0d7824ULL, 0x100fe200078e022bULL, 0x0000001e1e007211ULL, 0x040fe200078fe8ffULL,
0x000000010f0f7824ULL, 0x100fe200078e022bULL, 0xfffffff825257812ULL, 0x000fe200078ee204ULL,
0x0000000113047824ULL, 0x040fe200078e021eULL, 0x00000003136d7819ULL, 0x040fe200000006ffULL,
0x0000000113137824ULL, 0x100fe200078e022bULL, 0x000000141e5f7811ULL, 0x040fe200078fe8ffULL,
0x0000000161617824ULL, 0x000fe200078e022bULL, 0x0000001c1e7d7811ULL, 0x000fe200078fe8ffULL,
0x0000001025257824ULL, 0x000fe200078e0218ULL, 0xfffffff80c737812ULL, 0x000fc400078ee205ULL,
0x0000000700057812ULL, 0x000fe200078ec0ffULL, 0x000000017d067824ULL, 0x100fe200078e021eULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee204ULL, 0x000000015f047824ULL, 0x040fe200078e021eULL,
0x000000035f717819ULL, 0x040fe200000006ffULL, 0x000000015f5f7824ULL, 0x100fe200078e022bULL,
0x000000037d7f7819ULL, 0x040fe200000006ffULL, 0x000000017d7d7824ULL, 0x000fe200078e022bULL,
0x0ffffff8050b7812ULL, 0x000fe200078ef81eULL, 0x000000106d6d7824ULL, 0x100fe200078e0218ULL,
0x0000002b5d5d7210ULL, 0x000fe20007ffe0ffULL, 0x0000001073737824ULL, 0x100fe200078e0218ULL,
0x0000002b1e057211ULL, 0x000fe200078fe8ffULL, 0x00000010632b7824ULL, 0x000fe200078e0218ULL,
0x000000ff00637202ULL, 0x000fc40000000f00ULL, 0xfffffff871717812ULL, 0x000fe400078ee204ULL,
0x000000180b0b7211ULL, 0x080fe200078e20ffULL, 0x0000010005047825ULL, 0x100fe200078e0062ULL,
0xfffffff87f7f7812ULL, 0x000fe400078ee206ULL, 0x000000186f6f7211ULL, 0x000fe200078e20ffULL,
0x000001000d0c7825ULL, 0x000fe200078e0062ULL, 0x0000000402047210ULL, 0x000fc60007f1e0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0062ULL, 0x0000000c020c7210ULL, 0x000fc60007f3e0ffULL,
0x0000010013127825ULL, 0x000fe200078e0062ULL, 0x0000000e020e7210ULL, 0x000fc60007f5e0ffULL,
0x000001005d5c7825ULL, 0x000fe200078e0062ULL, 0x0000001202127210ULL, 0x000fc60007f7e0ffULL,
0x000001005f5e7825ULL, 0x000fe200078e0062ULL, 0x0000001303137210ULL, 0x000fc60001ffe4ffULL,
0x0000010061607825ULL, 0x000fc800078e0062ULL, 0x000001007d627825ULL, 0x000fc800078e0062ULL,
0x0000000103057824ULL, 0x040fe200000e0605ULL, 0x0000005c025c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001030d7824ULL, 0x040fe200008e060dULL, 0x0000005e025e7210ULL, 0x000fe20007f3e0ffULL,
0x00000001030f7824ULL, 0x040fe200010e060fULL, 0x0000006002607210ULL, 0x000fe20007f5e0ffULL,
0x00000001035d7824ULL, 0x000fe200000e065dULL, 0x0000006202027210ULL, 0x000fe20007f7e0ffULL,
0x0000001071717824ULL, 0x000fe200078e0218ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040b7faeULL, 0x0003e2000b901c46ULL, 0x00000001035f7824ULL, 0x000fc400008e065fULL,
0x0000000103617824ULL, 0x000fe200010e0661ULL, 0x000000000c257faeULL, 0x0003e2000b901c46ULL,
0x000000107f7f7824ULL, 0x000fe200078e0218ULL, 0x0000006303037210ULL, 0x000fe40001ffe4ffULL,
0x000000000e2b7faeULL, 0x0003e8000b901c46ULL, 0x00000000126d7faeULL, 0x0003e8000b901c46ULL,
0x000000005c6f7faeULL, 0x0003e8000b901c46ULL, 0x000000005e717faeULL, 0x0003e8000b901c46ULL,
0x0000000060737faeULL, 0x0003e8000b901c46ULL, 0x00000000027f7faeULL, 0x0003e4000b901c46ULL,
0x000000012a027812ULL, 0x002fe200078ec0ffULL, 0xffffffffff897424ULL, 0x000fe200078e00ffULL,
0xffffffff26007811ULL, 0x000fe200078e08ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000010200780cULL, 0x000fc80003f05070ULL, 0x0000000100257807ULL, 0x000fca0004000000ULL,
0x0000000125257824ULL, 0x000fca00078e022aULL, 0x0000001b2500720cULL, 0x000fda0003f06070ULL,
0x00009000ff028b82ULL, 0x000e620000000a00ULL, 0x0000000114058824ULL, 0x000fe200078e0225ULL,
0xffffffe019007812ULL, 0x040fe400078ec0ffULL, 0x0000001019047812ULL, 0x000fe200078ec0ffULL,
0x00000001ff0c7424ULL, 0x000fc600078e00ffULL, 0x0000001d04007210ULL, 0x000fe20007ffe000ULL,
0x0000000405028825ULL, 0x002fe200078e0002ULL, 0x0000000819057812ULL, 0x000fc800078ec0ffULL,
0x00000005000b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000602898981ULL, 0x000326000c1e1900ULL,
0x01e6080c0b0c79a7ULL, 0x0002a6000850003fULL, 0x0000000000027805ULL, 0x002fce0000015200ULL,
0x01e6080d0b0075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff067224ULL, 0x000fce00078e00ffULL, 0x000000100600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fce0000015200ULL,
0x00000004020f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011405ULL, 0x0000000f00007211ULL, 0x000fc800078110ffULL,
0x00000005ff057210ULL, 0x000fc800007fe4ffULL, 0x0000000200007819ULL, 0x000fc80000001205ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000106067836ULL, 0x000fce0000000000ULL, 0x01e6080d0b0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000101e137824ULL, 0x000fe200078e00ffULL,
0x00000001ff127819ULL, 0x000fe2000001161eULL, 0x0000002022007824ULL, 0x000fe400078e00ffULL,
0x000000ffff187224ULL, 0x000fe200078e0029ULL, 0x0000007013137812ULL, 0x000fe400078ec0ffULL,
0xffffff8000007812ULL, 0x000fe400078ec0ffULL, 0x0000000c12127812ULL, 0x000fe400078ec0ffULL,
0x0000001d13037210ULL, 0x000fc80007ffe000ULL, 0x0000001203037210ULL, 0x000fca0007ffe0ffULL,
0x01e0000003007984ULL, 0x000e680000000800ULL, 0x01e20000038a7984ULL, 0x0004a20000000800ULL,
0x000000290000720bULL, 0x002fda0003f1d000ULL, 0x0000000000047806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x000000ff0400720cULL, 0x000fda0003f25270ULL,
0x0000000400909947ULL, 0x004fea0003800000ULL, 0x00000002ff037819ULL, 0x000fe40000011622ULL,
0x000000290000720bULL, 0x0c0fe40003f34000ULL, 0x000000220300720cULL, 0x000fe40003f45270ULL,
0x0000002900187209ULL, 0x000fd20007810000ULL, 0x0000000000057806ULL, 0x000fe400008e0100ULL,
0x000000802202a824ULL, 0x000fe400078e021dULL, 0x000000ff0500720cULL, 0x000fc60003f25270ULL,
0x000000021203a210ULL, 0x000fca0007ffe013ULL, 0x01e400180300a388ULL, 0x0003ea0000000800ULL,
0x0000000400509947ULL, 0x000fea0003800000ULL, 0x0000002918027221ULL, 0x000fe20000010100ULL,
0x000000ff05ff7812ULL, 0x040fe4000782c0ffULL, 0x0000ff0005ff7812ULL, 0x040fe2000784c0ffULL,
0x3fb8aa3b02027820ULL, 0x000fe20000410000ULL, 0x00ff000005ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000005ff7812ULL, 0x000fe2000788c0ffULL, 0x0000000200037308ULL, 0x0022ac0000000800ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x00000002ff027819ULL, 0x002fcc000001161eULL,
0x00001f0203027589ULL, 0x004e6400000e0000ULL, 0x0000000268687220ULL, 0x082fe20000410000ULL,
0x0000000269697220ULL, 0x080fe20000410000ULL, 0x0000000264647220ULL, 0x080fe20000410000ULL,
0x0000000265657220ULL, 0x080fe20000410000ULL, 0x0000000278787220ULL, 0x080fe20000410000ULL,
0x0000000279797220ULL, 0x080fe20000410000ULL, 0x0000000274747220ULL, 0x080fe20000410000ULL,
0x0000000275757220ULL, 0x080fe20000410000ULL, 0x0000000258587220ULL, 0x080fe20000410000ULL,
0x0000000259597220ULL, 0x080fe20000410000ULL, 0x0000000254547220ULL, 0x080fe20000410000ULL,
0x0000000255557220ULL, 0x080fe20000410000ULL, 0x0000000250507220ULL, 0x080fe20000410000ULL,
0x0000000251517220ULL, 0x080fe20000410000ULL, 0x000000024c4c7220ULL, 0x080fe20000410000ULL,
0x000000024d4d7220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000081e027811ULL, 0x002fcc00078ff0ffULL, 0x00001f0203027589ULL, 0x004e6400000e0000ULL,
0x000000026a6a7220ULL, 0x082fe20000410000ULL, 0x000000026b6b7220ULL, 0x080fe20000410000ULL,
0x0000000266667220ULL, 0x080fe20000410000ULL, 0x0000000267677220ULL, 0x080fe20000410000ULL,
0x000000027a7a7220ULL, 0x080fe20000410000ULL, 0x000000027b7b7220ULL, 0x080fe20000410000ULL,
0x0000000276767220ULL, 0x080fe20000410000ULL, 0x0000000277777220ULL, 0x080fe20000410000ULL,
0x000000025a5a7220ULL, 0x080fe20000410000ULL, 0x000000025b5b7220ULL, 0x080fe20000410000ULL,
0x0000000256567220ULL, 0x080fe20000410000ULL, 0x0000000257577220ULL, 0x080fe20000410000ULL,
0x0000000252527220ULL, 0x080fe20000410000ULL, 0x0000000253537220ULL, 0x080fe20000410000ULL,
0x000000024e4e7220ULL, 0x080fe20000410000ULL, 0x000000024f4f7220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000101e027811ULL, 0x002fcc00078ff0ffULL,
0x00001f0203027589ULL, 0x004e6400000e0000ULL, 0x0000000248487220ULL, 0x082fe20000410000ULL,
0x0000000249497220ULL, 0x080fe20000410000ULL, 0x0000000244447220ULL, 0x080fe20000410000ULL,
0x0000000245457220ULL, 0x080fe20000410000ULL, 0x0000000240407220ULL, 0x080fe20000410000ULL,
0x0000000241417220ULL, 0x080fe20000410000ULL, 0x000000023c3c7220ULL, 0x080fe20000410000ULL,
0x000000023d3d7220ULL, 0x080fe20000410000ULL, 0x0000000238387220ULL, 0x080fe20000410000ULL,
0x0000000239397220ULL, 0x080fe20000410000ULL, 0x0000000234347220ULL, 0x080fe20000410000ULL,
0x0000000235357220ULL, 0x080fe20000410000ULL, 0x0000000230307220ULL, 0x080fe20000410000ULL,
0x0000000231317220ULL, 0x080fe20000410000ULL, 0x000000022c2c7220ULL, 0x080fe20000410000ULL,
0x000000022d2d7220ULL, 0x000fce0000410000ULL, 0x0000000327277220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000181e027811ULL, 0x002fcc00078ff0ffULL,
0x00001f0203027589ULL, 0x000e6400000e0000ULL, 0x000000024a4a7220ULL, 0x082fe20000410000ULL,
0x000000024b4b7220ULL, 0x080fe20000410000ULL, 0x0000000246467220ULL, 0x080fe20000410000ULL,
0x0000000247477220ULL, 0x080fe20000410000ULL, 0x0000000242427220ULL, 0x080fe20000410000ULL,
0x0000000243437220ULL, 0x080fe20000410000ULL, 0x000000023e3e7220ULL, 0x080fe20000410000ULL,
0x000000023f3f7220ULL, 0x080fe20000410000ULL, 0x000000023a3a7220ULL, 0x080fe20000410000ULL,
0x000000023b3b7220ULL, 0x080fe20000410000ULL, 0x0000000236367220ULL, 0x080fe20000410000ULL,
0x0000000237377220ULL, 0x080fe20000410000ULL, 0x0000000232327220ULL, 0x080fe20000410000ULL,
0x0000000233337220ULL, 0x080fe20000410000ULL, 0x000000022e2e7220ULL, 0x080fe20000410000ULL,
0x000000022f2f7220ULL, 0x000fce0000410000ULL, 0x0000000504ff7212ULL, 0x000fda00078230ffULL,
0x8000001800001221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b00001820ULL, 0x000fc80000410000ULL, 0x0000000000111308ULL, 0x000ea40000000800ULL,
0x000000118a8a1220ULL, 0x004fce0000410000ULL, 0x00000002228b7824ULL, 0x000fe200078e00ffULL,
0x000000081e037812ULL, 0x002fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000048b8f7812ULL, 0x000fe400078ec0ffULL, 0x00000007038d7812ULL, 0x000fe400078ef81eULL,
0x0000008f1e007211ULL, 0x000fe400078fe0ffULL, 0x000000108d917812ULL, 0x040fe200078efcffULL,
0x000000088d037824ULL, 0x040fe200078e00ffULL, 0x0000000d22887819ULL, 0x000fe200000006ffULL,
0x000000018d107824ULL, 0x000fe200078e0200ULL, 0x0000008d1e027211ULL, 0x000fe200078fe0ffULL,
0x00000001000f7824ULL, 0x000fe200078e0291ULL, 0x0000000391007819ULL, 0x000fe200000006ffULL,
0x000000088d057824ULL, 0x040fe200078e00ffULL, 0xffffc00088047812ULL, 0x000fe200078ec0ffULL,
0x00000002020e7836ULL, 0x000fe20000000000ULL, 0xfffffff8000f7812ULL, 0x000fe200078ee20fULL,
0x0000040022007824ULL, 0x000fe200078e00ffULL, 0x000000038d0d7819ULL, 0x000fe200000006ffULL,
0x000000011d047824ULL, 0x000fe200078e0204ULL, 0x00000006020b7810ULL, 0x000fe20007ffe0ffULL,
0x000000088d067824ULL, 0x000fe200078e00ffULL, 0xfffff00000007812ULL, 0x000fe200078ec0ffULL,
0x00000004020c7836ULL, 0x000fe20000000000ULL, 0xfffffff803107812ULL, 0x000fe200078ee210ULL,
0x0000200015047824ULL, 0x000fe200078e0204ULL, 0xfffffff8050e7812ULL, 0x000fc400078ee20eULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee202ULL, 0x0001600004047836ULL, 0x000fe20000000000ULL,
0xfffffff8030c7812ULL, 0x000fe400078ee20cULL, 0xfffffff8060b7812ULL, 0x000fe400078ee20bULL,
0x000120001d8c7810ULL, 0x000fe20007ffe000ULL, 0x0000000000288947ULL, 0x000fec0003800000ULL,
0x00000002ff077819ULL, 0x000fe4000001161eULL, 0x00000011ff00723eULL, 0x000fe400000000ffULL,
0x0000001007097810ULL, 0x000fe20007ffe0ffULL, 0x0000000807037836ULL, 0x000fe20000000000ULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x0000001807057836ULL, 0x000fc80000000000ULL,
0x00001f03000a7589ULL, 0x0002a800000e0000ULL, 0x00001f0900097589ULL, 0x0002e800000e0000ULL,
0x00001f0700077589ULL, 0x00026800000e0000ULL, 0x00001f0500087589ULL, 0x00026400000e0000ULL,
0x0000001010847824ULL, 0x100fe200078e028cULL, 0x000000040d807211ULL, 0x000fe200078e20ffULL,
0x000000100f287824ULL, 0x000fe400078e028cULL, 0x000000100e7c7824ULL, 0x100fe400078e0204ULL,
0x000000008484783bULL, 0x000ee20000000200ULL, 0x000000100c707824ULL, 0x000fc600078e0204ULL,
0x000000002828783bULL, 0x000ea20000000200ULL, 0x0000000000208947ULL, 0x000fea0003800000ULL,
0x0000000784847232ULL, 0x08afe40000000000ULL, 0x0000000786867232ULL, 0x000fe40000000000ULL,
0x0000000a85857232ULL, 0x084fe40000000000ULL, 0x0000000a87877232ULL, 0x000fe40000000000ULL,
0x0000000928287232ULL, 0x080fe40000000000ULL, 0x000000092a2a7232ULL, 0x000fc40000000000ULL,
0x0000000829297232ULL, 0x080fe40000000000ULL, 0x000000082b2b7232ULL, 0x000fce0000000000ULL,
0x000000008080783bULL, 0x000f620000004200ULL, 0x000000100b6c7824ULL, 0x000fe200078e0204ULL,
0x000000028f8f7812ULL, 0x000fe200078efcffULL, 0x0000000891027824ULL, 0x000fe200078e00ffULL,
0x000000007070783bULL, 0x000fe20000004200ULL, 0x000000038d037819ULL, 0x042fe400000006ffULL,
0x0000008f1e007211ULL, 0x000fe200078fe0ffULL, 0x000000006c6c783bULL, 0x000e680000004200ULL,
0x000000007c7c783bULL, 0x000e620000004200ULL, 0x000000018d067824ULL, 0x000fc400078e0200ULL,
0x0000000191057824ULL, 0x040fe200078e0200ULL, 0x000000911e007211ULL, 0x000fe400078fe0ffULL,
0xfffffff803067812ULL, 0x000fe200078ee206ULL, 0x0000000891037824ULL, 0x000fe200078e00ffULL,
0xfffffff802057812ULL, 0x000fe200078ee205ULL, 0x0000000400027836ULL, 0x000fc60000000000ULL,
0xfffffff803047812ULL, 0x000fe200078ee200ULL, 0x0000000200037836ULL, 0x000fe40000000000ULL,
0x0000000600007836ULL, 0x000fe20000000000ULL, 0x000000808468723cULL, 0x028fec0000001868ULL,
0x000000802848723cULL, 0x004fec0000001848ULL, 0x000000828464723cULL, 0x000fe20000001864ULL,
0x00000001ff807819ULL, 0x000fca0000011622ULL, 0x000000822844723cULL, 0x000fec0000001844ULL,
0x0000006c8450723cULL, 0x002fe20000001850ULL, 0x0000001d80827211ULL, 0x000fca00078e70ffULL,
0x0000006c2830723cULL, 0x000fec0000001830ULL, 0x000000708458723cULL, 0x000fe20000001858ULL,
0x00000008916d7824ULL, 0x000fe200078e00ffULL, 0x00000082156c7211ULL, 0x000fc800078e68ffULL,
0x000000702838723cULL, 0x000fe20000001838ULL, 0xfffffff86d027812ULL, 0x000fe200078ee202ULL,
0x000160006c6d7836ULL, 0x000fc80000000000ULL, 0x0000007c8460723cULL, 0x000fe20000001878ULL,
0x0000000891707824ULL, 0x040fe200078e00ffULL, 0x0000000391917819ULL, 0x000fc800000006ffULL,
0x0000007c2840723cULL, 0x000fe20000001840ULL, 0xfffffff870037812ULL, 0x000fe400078ee203ULL,
0xfffffff891007812ULL, 0x000fe400078ee200ULL, 0x0000006d04707211ULL, 0x000fe200078e20ffULL,
0x0000007e283c723cULL, 0x000fe2000000183cULL, 0x00000010067c7824ULL, 0x000fe400078e028cULL,
0x0000001003787824ULL, 0x000fc600078e026dULL, 0x000000722834723cULL, 0x000fec0000001834ULL,
0x0000006e282c723cULL, 0x000fec000000182cULL, 0x0000007e845c723cULL, 0x000fe20000001874ULL,
0x0000001005287824ULL, 0x000fe200078e028cULL, 0x000000007c7c783bULL, 0x000e680000000200ULL,
0x000000728454723cULL, 0x000fe20000001854ULL, 0x000000002828783bULL, 0x000ea20000000200ULL,
0x0000001002747824ULL, 0x000fc800078e026dULL, 0x0000006e844c723cULL, 0x000fe2000000184cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000208947ULL, 0x000fde0003800000ULL,
0x000000077c7c7232ULL, 0x082fe40000000000ULL, 0x000000077e7e7232ULL, 0x000fe40000000000ULL,
0x0000000a7d7d7232ULL, 0x080fe40000000000ULL, 0x0000000a7f7f7232ULL, 0x000fe40000000000ULL,
0x0000000928287232ULL, 0x084fe40000000000ULL, 0x000000092a2a7232ULL, 0x000fc40000000000ULL,
0x0000000829297232ULL, 0x080fe40000000000ULL, 0x000000082b2b7232ULL, 0x000fce0000000000ULL,
0x00000010006c7824ULL, 0x000fe200078e026dULL, 0x000000007070783bULL, 0x000ee20000004200ULL,
0x00008e00ff847b82ULL, 0x000f620000000a00ULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x000000278a277221ULL, 0x000fe20000010000ULL, 0x000000007878783bULL, 0x000ee20000004200ULL,
0x0000000489897c24ULL, 0x010fc6000f8e02ffULL, 0x000000007474783bULL, 0x000f240000004200ULL,
0x0000000789897819ULL, 0x000fe400000006ffULL, 0x000000006c6c783bULL, 0x000f260000004200ULL,
0x0000010089847825ULL, 0x024fe200078e0084ULL, 0x000000702848723cULL, 0x008fec0000001848ULL,
0x000000782840723cULL, 0x002fec0000001840ULL, 0x0000007a283c723cULL, 0x000fec000000183cULL,
0x000000742838723cULL, 0x010fec0000001838ULL, 0x000000762834723cULL, 0x000fec0000001834ULL,
0x000000722844723cULL, 0x000fec0000001844ULL, 0x0000006c2830723cULL, 0x000fec0000001830ULL,
0x0000006e282c723cULL, 0x000fec000000182cULL, 0x000000707c68723cULL, 0x000fe20000001868ULL,
0x00000001232b7836ULL, 0x000fc40000000000ULL, 0x0000000823287824ULL, 0x000fc600078e0280ULL,
0x0000006c7c50723cULL, 0x000fe20000001850ULL, 0xfffffff88b707812ULL, 0x000fe400078ec0ffULL,
0x0000001a2b00720cULL, 0x000fc60003f06070ULL, 0x000000727c64723cULL, 0x000fe20000001864ULL,
0x00000001006c7802ULL, 0x000fe20000000f00ULL, 0x000000011d6d7824ULL, 0x000fc800078e0270ULL,
0x01e6886c6dff79a7ULL, 0x0003e2000850003fULL, 0x000000787c60723cULL, 0x000fec0000001860ULL,
0x0000007a7c5c723cULL, 0x000fe2000000185cULL, 0x00000080286d7811ULL, 0x002fca00078e28ffULL,
0x000000747c58723cULL, 0x000fe20000001858ULL, 0x000000606d297812ULL, 0x000fca00078ec0ffULL,
0x000000767c54723cULL, 0x000fe20000001854ULL, 0x00000001167b7824ULL, 0x000fca00078e0229ULL,
0x0000006e7c4c723cULL, 0x000fe2000000184cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000400908947ULL, 0x000fde0003800000ULL,
0x00000003ff7a7819ULL, 0x100fe2000001161eULL, 0x00000080222a7824ULL, 0x000fe200078e00ffULL,
0x0000200088297812ULL, 0x000fe400078ec0ffULL, 0x0000006d1c287248ULL, 0x000fe20007fe0000ULL,
0x000000047a6e7836ULL, 0x000fe20000000000ULL, 0x0001600082787810ULL, 0x000fe20007ffe029ULL,
0x000000ffff6d7224ULL, 0x000fe200078e0a6dULL, 0x0000001c7a887810ULL, 0x000fe20007ffe0ffULL,
0x000000086e707824ULL, 0x000fe200078e00ffULL, 0x0000001e6e2b7210ULL, 0x000fe20007ffe0ffULL,
0x000000017a297824ULL, 0x000fe200078e021eULL, 0x00000020286d7446ULL, 0x000fe2000380006dULL,
0x000000087a7c7836ULL, 0x000fe20000000000ULL, 0xfffffff8707d7812ULL, 0x000fe200078ee22bULL,
0x000000016e6f7824ULL, 0x100fe200078e027bULL, 0x0000000729777812ULL, 0x000fe200078ec0ffULL,
0x0000000c7a7e7836ULL, 0x000fe20000000000ULL, 0x0000008013287812ULL, 0x000fe200078ef82aULL,
0x000000017c717824ULL, 0x100fe200078e027bULL, 0x0000007b7a2b7210ULL, 0x000fe20007ffe0ffULL,
0x000000017e737824ULL, 0x000fe200078e027bULL, 0x000000ff00297202ULL, 0x000fe20000000f00ULL,
0x000000107a807836ULL, 0x000fe20000000000ULL, 0x0000006d6e00720cULL, 0x080fe20003f26070ULL,
0x000000147a827836ULL, 0x000fe20000000000ULL, 0x0000006d7a00720cULL, 0x000fe20003f06070ULL,
0x000001002b2a7825ULL, 0x000fe200078e0028ULL, 0x0ffffff877797812ULL, 0x000fc400078ef81eULL,
0x0000006d7c00720cULL, 0x080fe20003fa6070ULL, 0x000001006f6e7825ULL, 0x100fe200078e0028ULL,
0x0000002a84747210ULL, 0x000fe40007f5e0ffULL, 0x0000006d7e00720cULL, 0x000fe20003f86070ULL,
0x0000010071707825ULL, 0x000fe200078e0028ULL, 0x0000006e84767210ULL, 0x000fc60007f7e0ffULL,
0x0000010073727825ULL, 0x000fe200078e0028ULL, 0x0000006f85777210ULL, 0x000fc60001ffe4ffULL,
0x0000000185757824ULL, 0x000fe200010e062bULL, 0x00000070842a7210ULL, 0x000fe20007f5e0ffULL,
0x0000001079797824ULL, 0x100fe200078e0278ULL, 0x00000072846e7210ULL, 0x000fe20007f7e0ffULL,
0x000000187a867836ULL, 0x000fe40000000000ULL, 0x00000001852b7824ULL, 0x000fe200010e0671ULL,
0x00000073856f7210ULL, 0x000fe20001ffe4ffULL, 0x000000107d717824ULL, 0x000fe200078e0278ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000074797faeULL, 0x0003e2000c101c46ULL,
0x0000000180737824ULL, 0x140fe200078e027bULL, 0x0000006d8000720cULL, 0x080fe20003f66070ULL,
0x000000017c7a7824ULL, 0x040fe200078e021eULL, 0x0000000076717faeULL, 0x0005e2000c901c46ULL,
0x000000087c7d7824ULL, 0x000fe200078e00ffULL, 0x0000006d8200720cULL, 0x0c0fe20003f46070ULL,
0x0000000882817824ULL, 0x000fe200078e00ffULL, 0x0000006d8600720cULL, 0x080fe20003f26070ULL,
0x0000000888877824ULL, 0x040fe200078e00ffULL, 0x0000006d8800720cULL, 0x000fe20003f06070ULL,
0x0000000182757824ULL, 0x002fe200078e027bULL, 0x0000001e7e747210ULL, 0x000fc40007ffe0ffULL,
0xfffffff87d797812ULL, 0x000fe200078ee27aULL, 0x0000010073707825ULL, 0x004fe200078e0028ULL,
0x0000007b866d7210ULL, 0x000fc60007ffe0ffULL, 0x000000087e777824ULL, 0x000fe200078e00ffULL,
0x0000007084727210ULL, 0x000fe20007fde0ffULL, 0x0000000182767824ULL, 0x000fc600078e021eULL,
0xfffffff8777d7812ULL, 0x000fe200078ee274ULL, 0x0000000185737824ULL, 0x000fe200030e0671ULL,
0xfffffff881817812ULL, 0x000fe200078ee276ULL, 0x0000010075707825ULL, 0x000fe200078e0028ULL,
0x0000001e80757210ULL, 0x000fc60007ffe0ffULL, 0x0000000880807824ULL, 0x000fe200078e00ffULL,
0x0000007084747210ULL, 0x000fe20007fde0ffULL, 0x0000000188777824ULL, 0x040fe400078e027bULL,
0x0000000188767824ULL, 0x000fe200078e021eULL, 0xfffffff8807f7812ULL, 0x000fe200078ee275ULL,
0x0000000185757824ULL, 0x000fe400030e0671ULL, 0x000001006d707825ULL, 0x000fe200078e0028ULL,
0xfffffff887877812ULL, 0x000fc600078ee276ULL, 0x00000001866d7824ULL, 0x040fe200078e021eULL,
0x0000007084707210ULL, 0x000fe20007fde0ffULL, 0x0000010077287825ULL, 0x000fe200078e0028ULL,
0x0000000386867819ULL, 0x000fc600000006ffULL, 0x0000000185717824ULL, 0x000fe200030e0671ULL,
0xfffffff886837812ULL, 0x000fe200078ee26dULL, 0x000000107d777824ULL, 0x100fe200078e0278ULL,
0x00000078796d7211ULL, 0x080fe200078e20ffULL, 0x000000107f797824ULL, 0x100fe200078e0278ULL,
0x0000002884287210ULL, 0x000fe20007fde0ffULL, 0x00000010817b7824ULL, 0x100fe200078e0278ULL,
0x00000078837d7211ULL, 0x000fe200078e20ffULL, 0x00000010877f7824ULL, 0x000fe200078e0278ULL,
0x000000002a6d7faeULL, 0x0003e2000e901c46ULL, 0x0000000185297824ULL, 0x000fc600030e0629ULL,
0x000000006e777faeULL, 0x0003e8000e101c46ULL, 0x0000000072797faeULL, 0x0003e8000d901c46ULL,
0x00000000747b7faeULL, 0x0003e8000d101c46ULL, 0x00000000707d7faeULL, 0x0003e8000c901c46ULL,
0x00000000287f7faeULL, 0x0003e2000c101c46ULL, 0x00000004005c7947ULL, 0x000fea0003800000ULL,
0x000000041e2b7811ULL, 0x000fe200078fe8ffULL, 0x0000008022787824ULL, 0x000fe200078e00ffULL,
0x000000081e6f7811ULL, 0x000fe400078fe8ffULL, 0x000000032b6d7819ULL, 0x040fe200000006ffULL,
0x000000012b287824ULL, 0x000fe200078e021eULL, 0x0000200088297812ULL, 0x000fe200078ec0ffULL,
0x000000086f777824ULL, 0x000fe200078e00ffULL, 0x0000000c1e717811ULL, 0x040fe200078fe8ffULL,
0x000000012b2b7824ULL, 0x000fe200078e027bULL, 0x000000141e757811ULL, 0x000fc400078fe8ffULL,
0xfffffff86d7c7812ULL, 0x000fe200078ee228ULL, 0x000000016f287824ULL, 0x100fe200078e021eULL,
0x000000101e737811ULL, 0x000fe200078fe8ffULL, 0x00000001756d7824ULL, 0x100fe200078e021eULL,
0x0001600082897810ULL, 0x000fe20007ffe029ULL, 0x0000000171297824ULL, 0x140fe200078e021eULL,
0x0000000371807819ULL, 0x000fe200000006ffULL, 0x00000001732a7824ULL, 0x000fe200078e021eULL,
0x0000000375867819ULL, 0x000fe200000006ffULL, 0x0000000873797824ULL, 0x000fe200078e00ffULL,
0xfffffff8777e7812ULL, 0x000fe200078ee228ULL, 0x000000016f6f7824ULL, 0x100fe200078e027bULL,
0x0000001e1e287211ULL, 0x000fe200078fe8ffULL, 0x0000000173737824ULL, 0x100fe200078e027bULL,
0xfffffff880807812ULL, 0x000fe200078ee229ULL, 0x0000000175757824ULL, 0x000fe200078e027bULL,
0xfffffff886867812ULL, 0x000fc400078ee26dULL, 0x000000181e297811ULL, 0x000fe400078fe8ffULL,
0xfffffff879827812ULL, 0x000fe200078ee22aULL, 0x0000001086837824ULL, 0x000fe200078e0289ULL,
0x0000001c1e6d7811ULL, 0x000fe200078fe8ffULL, 0x0000000129777824ULL, 0x040fe200078e027bULL,
0x0000000728797812ULL, 0x000fe200078ec0ffULL, 0x00000008297d7824ULL, 0x000fe200078e00ffULL,
0x0000001e29287210ULL, 0x000fe20007ffe0ffULL, 0x000000016d2a7824ULL, 0x040fe200078e021eULL,
0x0000008013787812ULL, 0x000fe200078ef878ULL, 0x000000086d7f7824ULL, 0x000fe200078e00ffULL,
0x0000007b1e297211ULL, 0x000fe200078fe8ffULL, 0x0000001082817824ULL, 0x000fe200078e0289ULL,
0x0ffffff8797a7812ULL, 0x000fe200078ef81eULL, 0x000000ffff797224ULL, 0x000fe200078e00ffULL,
0x0000007b71717210ULL, 0x000fc40007ffe0ffULL, 0xfffffff87d887812ULL, 0x000fe200078ee228ULL,
0x0000010029287825ULL, 0x100fe200078e0078ULL, 0xfffffff87f8a7812ULL, 0x000fe400078ee22aULL,
0x0000007b6d6d7210ULL, 0x000fe20007ffe0ffULL, 0x000001002b2a7825ULL, 0x100fe200078e0078ULL,
0x0000002884287210ULL, 0x000fe40007f1e0ffULL, 0x000000897e7d7211ULL, 0x000fe200078e20ffULL,
0x0000010071707825ULL, 0x000fe200078e0078ULL, 0x0000002a842a7210ULL, 0x000fc40007f3e0ffULL,
0x0000008988877211ULL, 0x000fe200078e20ffULL, 0x000001006f6e7825ULL, 0x000fe200078e0078ULL,
0x0000007084707210ULL, 0x000fc60007f7e0ffULL, 0x0000010073727825ULL, 0x000fe200078e0078ULL,
0x0000006e846e7210ULL, 0x000fc60007f5e0ffULL, 0x0000010075747825ULL, 0x000fe200078e0078ULL,
0x0000006f856f7210ULL, 0x000fc600017fe4ffULL, 0x0000010077767825ULL, 0x000fc800078e0078ULL,
0x000001006d787825ULL, 0x000fe200078e0078ULL, 0x0000007684767210ULL, 0x000fc60007f5e0ffULL,
0x0000000185297824ULL, 0x040fe200000e0629ULL, 0x0000007284727210ULL, 0x000fe20007f1e0ffULL,
0x00000001852b7824ULL, 0x040fe200008e062bULL, 0x0000007484747210ULL, 0x000fe20007f3e0ffULL,
0x000000107a6d7824ULL, 0x100fe200078e0289ULL, 0x0000007785777210ULL, 0x000fe200017fe4ffULL,
0x000000107c7b7824ULL, 0x000fe400078e0289ULL, 0x0000000185717824ULL, 0x040fe200018e0671ULL,
0x0000007884787210ULL, 0x000fe20007f7e0ffULL, 0x00000010807f7824ULL, 0x000fe200078e0289ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000286d7faeULL, 0x0003e2000b901c46ULL,
0x0000000185737824ULL, 0x000fc400000e0673ULL, 0x0000000185757824ULL, 0x040fe200008e0675ULL,
0x000000002a7b7faeULL, 0x0003e2000b901c46ULL, 0x000000108a897824ULL, 0x000fe400078e0289ULL,
0x0000000185797824ULL, 0x000fe200018e0679ULL, 0x000000006e7d7faeULL, 0x0003e8000b901c46ULL,
0x00000000707f7faeULL, 0x0003e8000b901c46ULL, 0x0000000072817faeULL, 0x0003e8000b901c46ULL,
0x0000000074837faeULL, 0x0003e8000b901c46ULL, 0x0000000076877faeULL, 0x0003e8000b901c46ULL,
0x0000000078897faeULL, 0x0003e4000b901c46ULL, 0xffffffe019287812ULL, 0x042fe200078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001019297812ULL, 0x040fe400078ec0ffULL,
0x00000008192a7812ULL, 0x000fe400078ec0ffULL, 0x0000001d29297210ULL, 0x000fca0007ffe028ULL,
0x0000000129717824ULL, 0x000fc800078e022aULL, 0x01e6286c716c79a7ULL, 0x0002a6000850003fULL,
0x0000000000287805ULL, 0x000fce0000015200ULL, 0x01e6286d710075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff6e7224ULL, 0x000fce00078e00ffULL,
0x000000106e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fce0000015200ULL, 0x0000002a286f7210ULL, 0x000fc80007f1e1ffULL,
0x0000002b292b7210ULL, 0x000fe400007fe5ffULL, 0x003d09006f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c406f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x0000006f2a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000016e6e7836ULL, 0x000fce0000000000ULL,
0x01e6286d710075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x0000002022287824ULL, 0x000fe200078e00ffULL, 0x0000001800807202ULL, 0x000fc80000000f00ULL,
0xffffff8028287812ULL, 0x000fc800078ec0ffULL, 0x000000801d287810ULL, 0x000fc80007ffe028ULL,
0x0000002812287210ULL, 0x000fca0007ffe013ULL, 0x01e0000028297984ULL, 0x000ea80000000800ULL,
0x01e2000028827984ULL, 0x0006e20000000800ULL, 0x000000182900720bULL, 0x004fda0003f1d000ULL,
0x00000000002a7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x000000ff2a00720cULL, 0x000fda0003f25270ULL, 0x0000000400949947ULL, 0x00afea0003800000ULL,
0x00000001222b7811ULL, 0x000fe400078ff0ffULL, 0x000000182900720bULL, 0x000fe40003f14000ULL,
0x000000222b00720cULL, 0x000fda0003f25270ULL, 0x00000080222b9824ULL, 0x000fe200078e021dULL,
0x0000001829289209ULL, 0x000fc80007810000ULL, 0x0000002b126d9210ULL, 0x000fe40007ffe013ULL,
0x00000000002b7806ULL, 0x000fc600000e0100ULL, 0x01e400286d009388ULL, 0x0003e20000000800ULL,
0x000000ff2b00720cULL, 0x000fda0003f05270ULL, 0x0000000400548947ULL, 0x002fea0003800000ULL,
0x00000018296d7209ULL, 0x000fe40007810000ULL, 0x000000ff2bff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff002bff7812ULL, 0x000fe2000782c0ffULL, 0x000000186d287221ULL, 0x000fe20000010100ULL,
0x00ff00002bff7812ULL, 0x040fe4000784c0ffULL, 0xff0000002bff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x00000028006c7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff6d7819ULL, 0x000fca000001161eULL,
0x00001f6d6c287589ULL, 0x006e6400000e0000ULL, 0x0000006828687220ULL, 0x042fe20000410000ULL,
0x0000006928697220ULL, 0x040fe20000410000ULL, 0x0000006428647220ULL, 0x040fe20000410000ULL,
0x0000006528657220ULL, 0x040fe20000410000ULL, 0x0000006028607220ULL, 0x040fe20000410000ULL,
0x0000006128617220ULL, 0x040fe20000410000ULL, 0x0000005c285c7220ULL, 0x040fe20000410000ULL,
0x0000005d285d7220ULL, 0x040fe20000410000ULL, 0x0000005828587220ULL, 0x040fe20000410000ULL,
0x0000005928597220ULL, 0x040fe20000410000ULL, 0x0000005428547220ULL, 0x040fe20000410000ULL,
0x0000005528557220ULL, 0x040fe20000410000ULL, 0x0000005028507220ULL, 0x040fe20000410000ULL,
0x0000005128517220ULL, 0x040fe20000410000ULL, 0x0000004c284c7220ULL, 0x040fe20000410000ULL,
0x0000004d284d7220ULL, 0x000fce0000410000ULL, 0x0000000000489947ULL, 0x000fea0003800000ULL,
0x000000081e6d7811ULL, 0x000fca00078ff0ffULL, 0x00001f6d6c287589ULL, 0x006e6400000e0000ULL,
0x0000006a286a7220ULL, 0x042fe20000410000ULL, 0x0000006b286b7220ULL, 0x040fe20000410000ULL,
0x0000006628667220ULL, 0x040fe20000410000ULL, 0x0000006728677220ULL, 0x040fe20000410000ULL,
0x0000006228627220ULL, 0x040fe20000410000ULL, 0x0000006328637220ULL, 0x040fe20000410000ULL,
0x0000005e285e7220ULL, 0x040fe20000410000ULL, 0x0000005f285f7220ULL, 0x040fe20000410000ULL,
0x0000005a285a7220ULL, 0x040fe20000410000ULL, 0x0000005b285b7220ULL, 0x040fe20000410000ULL,
0x0000005628567220ULL, 0x040fe20000410000ULL, 0x0000005728577220ULL, 0x040fe20000410000ULL,
0x0000005228527220ULL, 0x040fe20000410000ULL, 0x0000005328537220ULL, 0x040fe20000410000ULL,
0x0000004e284e7220ULL, 0x040fe20000410000ULL, 0x0000004f284f7220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000101e6d7811ULL, 0x000fca00078ff0ffULL,
0x00001f6d6c287589ULL, 0x006e6400000e0000ULL, 0x0000004828487220ULL, 0x042fe20000410000ULL,
0x0000004928497220ULL, 0x040fe20000410000ULL, 0x0000004428447220ULL, 0x040fe20000410000ULL,
0x0000004528457220ULL, 0x040fe20000410000ULL, 0x0000004028407220ULL, 0x040fe20000410000ULL,
0x0000004128417220ULL, 0x040fe20000410000ULL, 0x0000003c283c7220ULL, 0x040fe20000410000ULL,
0x0000003d283d7220ULL, 0x040fe20000410000ULL, 0x0000003828387220ULL, 0x040fe20000410000ULL,
0x0000003928397220ULL, 0x040fe20000410000ULL, 0x0000003428347220ULL, 0x040fe20000410000ULL,
0x0000003528357220ULL, 0x040fe20000410000ULL, 0x0000003028307220ULL, 0x040fe20000410000ULL,
0x0000003128317220ULL, 0x040fe20000410000ULL, 0x0000002c282c7220ULL, 0x040fe20000410000ULL,
0x0000002d282d7220ULL, 0x000fce0000410000ULL, 0x0000006c27277220ULL, 0x004fe20000410000ULL,
0x000000000048b947ULL, 0x000fec0003800000ULL, 0x000000181e6d7811ULL, 0x000fca00078ff0ffULL,
0x00001f6d6c287589ULL, 0x002e6400000e0000ULL, 0x0000004a284a7220ULL, 0x042fe20000410000ULL,
0x0000004b284b7220ULL, 0x040fe20000410000ULL, 0x0000004628467220ULL, 0x040fe20000410000ULL,
0x0000004728477220ULL, 0x040fe20000410000ULL, 0x0000004228427220ULL, 0x040fe20000410000ULL,
0x0000004328437220ULL, 0x040fe20000410000ULL, 0x0000003e283e7220ULL, 0x040fe20000410000ULL,
0x0000003f283f7220ULL, 0x040fe20000410000ULL, 0x0000003a283a7220ULL, 0x040fe20000410000ULL,
0x0000003b283b7220ULL, 0x040fe20000410000ULL, 0x0000003628367220ULL, 0x040fe20000410000ULL,
0x0000003728377220ULL, 0x040fe20000410000ULL, 0x0000003228327220ULL, 0x040fe20000410000ULL,
0x0000003328337220ULL, 0x040fe20000410000ULL, 0x0000002e282e7220ULL, 0x040fe20000410000ULL,
0x0000002f282f7220ULL, 0x000fce0000410000ULL, 0x0000002b2aff7212ULL, 0x000fe400078030ffULL,
0x0000001829807209ULL, 0x000fd60007810000ULL, 0x8000008029290221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b29290820ULL, 0x000fc80000410000ULL, 0x0000002900110308ULL, 0x000ea40000000800ULL,
0x0000001182820220ULL, 0x004fce0000410000ULL, 0x0000200022817824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000040022187824ULL, 0x000fe200078e00ffULL,
0xffffc00081287812ULL, 0x002fc800078ec0ffULL, 0xfffff00018187812ULL, 0x000fe400078ec0ffULL,
0x000000281d287210ULL, 0x000fe40007ffe0ffULL, 0x000130001d187810ULL, 0x000fc60007ffe018ULL,
0x0000200015287824ULL, 0x000fe400078e0228ULL, 0x00000010107c7824ULL, 0x000fe400078e0218ULL,
0x00017000286c7836ULL, 0x000fe20000000000ULL, 0x0000000000288947ULL, 0x000fec0003800000ULL,
0x00000002ff297819ULL, 0x000fe4000001161eULL, 0x00000011ff07723eULL, 0x000fe400000000ffULL,
0x00000008292b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001029097836ULL, 0x000fe20000000000ULL,
0x0000541007287816ULL, 0x000fe20000000007ULL, 0x00000018296d7836ULL, 0x000fc80000000000ULL,
0x00001f2b280a7589ULL, 0x0002a800000e0000ULL, 0x00001f0928097589ULL, 0x0002e800000e0000ULL,
0x00001f2928077589ULL, 0x00026800000e0000ULL, 0x00001f6d28087589ULL, 0x00026400000e0000ULL,
0x000000100f187824ULL, 0x000fe200078e0218ULL, 0x000000007c7c783bULL, 0x000ee20000000200ULL,
0x0000006c0d787211ULL, 0x000fe200078e20ffULL, 0x000000100e747824ULL, 0x100fe400078e026cULL,
0x000000001828783bULL, 0x0022a20000000200ULL, 0x000000100c707824ULL, 0x000fe200078e026cULL,
0x0000000000208947ULL, 0x000fec0003800000ULL, 0x000000077c7c7232ULL, 0x088fe40000000000ULL,
0x000000077e7e7232ULL, 0x000fe40000000000ULL, 0x0000000a7d7d7232ULL, 0x084fe40000000000ULL,
0x0000000a7f7f7232ULL, 0x000fe40000000000ULL, 0x0000000928287232ULL, 0x080fe40000000000ULL,
0x000000092a2a7232ULL, 0x000fc40000000000ULL, 0x0000000829297232ULL, 0x080fe40000000000ULL,
0x000000082b2b7232ULL, 0x000fce0000000000ULL, 0x000000007070783bULL, 0x000f220000004200ULL,
0x000000100b6c7824ULL, 0x000fe200078e026cULL, 0x00000002ff867819ULL, 0x100fe40000011622ULL,
0x000000007878783bULL, 0x000fe20000004200ULL, 0x00000001ff187819ULL, 0x002fc60000011622ULL,
0x000000006c6c783bULL, 0x000e620000004200ULL, 0x0000001d18887211ULL, 0x000fc600078e70ffULL,
0x000000007474783bULL, 0x000f620000004200ULL, 0x000000707c58723cULL, 0x018fec0000001858ULL,
0x000000702838723cULL, 0x004fec0000001838ULL, 0x0000006c7c50723cULL, 0x002fe20000001850ULL,
0x0000100086707824ULL, 0x000fc800078e021dULL, 0x0001300070707836ULL, 0x000fe20000000000ULL,
0x0000006c2830723cULL, 0x000fec0000001830ULL, 0x000000787c68723cULL, 0x000fe20000001868ULL,
0x00002000156d7824ULL, 0x000fca00078e0288ULL, 0x0000007a7c64723cULL, 0x000fe20000001864ULL,
0x000170006d6d7810ULL, 0x000fca0007ffe0ffULL, 0x000000747c60723cULL, 0x020fec0000001860ULL,
0x000000767c5c723cULL, 0x000fec000000185cULL, 0x000000727c54723cULL, 0x000fec0000001854ULL,
0x0000006e7c4c723cULL, 0x000fec000000184cULL, 0x000000782848723cULL, 0x000fe20000001848ULL,
0x00000010067c7824ULL, 0x000fca00078e0270ULL, 0x0000007a2844723cULL, 0x000fe20000001844ULL,
0x000000007c7c783bULL, 0x000e620000000200ULL, 0x0000001004787824ULL, 0x000fc800078e026dULL,
0x000000742840723cULL, 0x000fec0000001840ULL, 0x00000076283c723cULL, 0x000fe2000000183cULL,
0x0000006d03747211ULL, 0x000fca00078e20ffULL, 0x000000722834723cULL, 0x000fec0000001834ULL,
0x0000006e282c723cULL, 0x000fee000000182cULL, 0x0000001005287824ULL, 0x000fc400078e0270ULL,
0x0000001002707824ULL, 0x000fc800078e026dULL, 0x000000002828783bULL, 0x000ea20000000200ULL,
0x0000000000208947ULL, 0x000ff40003800000ULL, 0x000000077c7c7232ULL, 0x082fe40000000000ULL,
0x000000077e7e7232ULL, 0x000fe40000000000ULL, 0x0000000a7d7d7232ULL, 0x080fe40000000000ULL,
0x0000000a7f7f7232ULL, 0x000fe40000000000ULL, 0x0000000928287232ULL, 0x084fe40000000000ULL,
0x000000092a2a7232ULL, 0x000fc40000000000ULL, 0x0000000829297232ULL, 0x080fe40000000000ULL,
0x000000082b2b7232ULL, 0x000fce0000000000ULL, 0x00000010006d7824ULL, 0x000fe200078e026dULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x0000002782277221ULL, 0x000fc60000010000ULL,
0x000000007474783bULL, 0x000f280000004200ULL, 0x000000007070783bULL, 0x000f680000004200ULL,
0x000000006d6c783bULL, 0x000f220000004200ULL, 0x000000782848723cULL, 0x00cfec0000001848ULL,
0x0000007a2844723cULL, 0x000fec0000001844ULL, 0x000000742840723cULL, 0x010fec0000001840ULL,
0x00000076283c723cULL, 0x000fec000000183cULL, 0x000000702838723cULL, 0x020fec0000001838ULL,
0x000000722834723cULL, 0x000fec0000001834ULL, 0x0000006c2830723cULL, 0x002fec0000001830ULL,
0x0000006e282c723cULL, 0x000fec000000182cULL, 0x0000006c7c50723cULL, 0x000fe20000001850ULL,
0x00000001232b7836ULL, 0x000fca0000000000ULL, 0x0000001a2b00720cULL, 0x000fe20003f06070ULL,
0x00000001ff6c7424ULL, 0x000fe200078e00ffULL, 0x0000001d866d7211ULL, 0x000fe200078e18ffULL,
0x000000787c68723cULL, 0x000fe60000001868ULL, 0x01e6906c6dff79a7ULL, 0x0003e6000850003fULL,
0x0000007a7c64723cULL, 0x000fec0000001864ULL, 0x000000747c60723cULL, 0x000fe20000001860ULL,
0x00000008236d7824ULL, 0x002fca00078e0218ULL, 0x000000c06d6d7811ULL, 0x000fe200078e28ffULL,
0x000000767c5c723cULL, 0x000fe6000000185cULL, 0x000000606d297812ULL, 0x000fc600078ec0ffULL,
0x000000707c58723cULL, 0x000fe40000001858ULL, 0x0000000116797824ULL, 0x000fc800078e0229ULL,
0x000000727c54723cULL, 0x000fec0000001854ULL, 0x0000006e7c4c723cULL, 0x000fe2000000184cULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000400908947ULL, 0x000fde0003800000ULL, 0x00000003ff787819ULL, 0x100fe4000001161eULL,
0x0000006d1c287248ULL, 0x000fe20007fe0000ULL, 0x000000ffff6d7224ULL, 0x000fe200078e0a6dULL,
0x00000004786e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001782b7824ULL, 0x100fe200078e0279ULL,
0x00000007222a7819ULL, 0x000fe200000006ffULL, 0x00000008787a7836ULL, 0x000fe20000000000ULL,
0x00000020286d7446ULL, 0x000fe2000380006dULL, 0x000000016e297824ULL, 0x140fe200078e021eULL,
0x0000008013287812ULL, 0x000fe200078ef82aULL, 0x000000086e707824ULL, 0x000fe200078e00ffULL,
0x0000000c787c7810ULL, 0x000fe20007ffe0ffULL, 0x000000017a717824ULL, 0x100fe200078e0279ULL,
0x0000200081817812ULL, 0x000fe200078ec0ffULL, 0x000000016e6f7824ULL, 0x000fe200078e0279ULL,
0xfffffff8707d7812ULL, 0x000fe200078ee229ULL, 0x0000000178297824ULL, 0x000fe200078e021eULL,
0x0000006d6e00720cULL, 0x000fe20003f26070ULL, 0x00000010787e7836ULL, 0x000fe20000000000ULL,
0x000000797c737210ULL, 0x000fe20007ffe0ffULL, 0x00000018788a7836ULL, 0x000fe20000000000ULL,
0x0000000729777812ULL, 0x000fe200078ec0ffULL, 0x000000ffff297224ULL, 0x000fe200078e00ffULL,
0x0001700088887810ULL, 0x000fc40007ffe081ULL, 0x0000006d7800720cULL, 0x080fe20003f06070ULL,
0x000001002b2a7825ULL, 0x100fe200078e0028ULL, 0x0000001478827810ULL, 0x000fe40007ffe0ffULL,
0x0000006d7a00720cULL, 0x080fe20003fa6070ULL, 0x0000010071707825ULL, 0x100fe200078e0028ULL,
0x0000002a84747210ULL, 0x000fe40007f5e0ffULL, 0x0000006d7c00720cULL, 0x000fe20003f86070ULL,
0x000001006f6e7825ULL, 0x000fc800078e0028ULL, 0x0000000185757824ULL, 0x000fe200010e062bULL,
0x0ffffff8772b7812ULL, 0x000fe200078ef81eULL, 0x0000010073727825ULL, 0x000fe200078e0028ULL,
0x00000070842a7210ULL, 0x000fe40007f5e0ffULL, 0x0000006e84767210ULL, 0x000fe20007f7e0ffULL,
0x000000102b7b7824ULL, 0x100fe200078e0288ULL, 0x00000071852b7210ULL, 0x000fe200017fe4ffULL,
0x000000107d7d7824ULL, 0x000fe200078e0288ULL, 0x000000797e717210ULL, 0x000fe20007ffe0ffULL,
0x0000000185777824ULL, 0x000fe200018e066fULL, 0x00000072846e7210ULL, 0x000fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000747b7faeULL, 0x0003e2000c101c46ULL,
0x0000001c78787836ULL, 0x000fe20000000000ULL, 0x0000006d8200720cULL, 0x080fe20003f46070ULL,
0x0000010071707825ULL, 0x000fe200078e0028ULL, 0x00000000767d7faeULL, 0x0005e2000c901c46ULL,
0x0000006d8a00720cULL, 0x000fc40003f26070ULL, 0x00000001856f7824ULL, 0x040fe200018e0673ULL,
0x0000007084727210ULL, 0x000fe20007fde0ffULL, 0x000000017a737824ULL, 0x100fe200078e021eULL,
0x0000006d7e00720cULL, 0x080fe20003f66070ULL, 0x000000087a7a7824ULL, 0x000fe200078e00ffULL,
0x0000007982757210ULL, 0x002fe20007ffe0ffULL, 0x000000017c747824ULL, 0x000fe200078e021eULL,
0x0000006d7800720cULL, 0x000fe20003f06070ULL, 0x000000018a6d7824ULL, 0x000fe200078e0279ULL,
0xfffffff87a7b7812ULL, 0x000fe200078ee273ULL, 0x000000087c7d7824ULL, 0x004fe200078e00ffULL,
0x0000001e82767210ULL, 0x000fe20007ffe0ffULL, 0x0000000185737824ULL, 0x000fe200030e0671ULL,
0x0000007978777210ULL, 0x000fe20007ffe0ffULL, 0x0000010075707825ULL, 0x000fe200078e0028ULL,
0xfffffff87d7d7812ULL, 0x000fc400078ee274ULL, 0x0000000378797819ULL, 0x000fe200000006ffULL,
0x000000017e757824ULL, 0x040fe200078e021eULL, 0x0000007084747210ULL, 0x000fe20007fde0ffULL,
0x000000087e7e7824ULL, 0x000fe400078e00ffULL, 0x0000000882817824ULL, 0x000fe400078e00ffULL,
0x000000107b7b7824ULL, 0x000fe200078e0288ULL, 0xfffffff87e7f7812ULL, 0x000fe200078ee275ULL,
0x0000000185757824ULL, 0x000fe200030e0671ULL, 0xfffffff881817812ULL, 0x000fe200078ee276ULL,
0x000001006d707825ULL, 0x000fe200078e0028ULL, 0x000000887f7f7211ULL, 0x000fe200078e20ffULL,
0x000000002a7b7faeULL, 0x0003e4000e901c46ULL, 0x000000018a6d7824ULL, 0x040fe200078e021eULL,
0x0000007084707210ULL, 0x000fe20007fde0ffULL, 0x000000088a8a7824ULL, 0x000fc400078e00ffULL,
0x0000000178767824ULL, 0x000fe400078e021eULL, 0x0000010077287825ULL, 0x000fe200078e0028ULL,
0xfffffff88a6d7812ULL, 0x000fe400078ee26dULL, 0xfffffff879777812ULL, 0x000fe200078ee276ULL,
0x0000000185717824ULL, 0x000fe200030e0671ULL, 0x0000002884287210ULL, 0x000fe20007fde0ffULL,
0x000000107d7d7824ULL, 0x100fe400078e0288ULL, 0x0000001081817824ULL, 0x100fe200078e0288ULL,
0x0000002985297210ULL, 0x000fe200037fe4ffULL, 0x000000106d6d7824ULL, 0x100fe200078e0288ULL,
0x000000006e7d7faeULL, 0x0003e2000e101c46ULL, 0x0000001077777824ULL, 0x000fc600078e0288ULL,
0x00000000727f7faeULL, 0x0003e8000d901c46ULL, 0x0000000074817faeULL, 0x0003e8000d101c46ULL,
0x00000000706d7faeULL, 0x0003e8000c901c46ULL, 0x0000000028777faeULL, 0x0003e2000c101c46ULL,
0x00000004005c7947ULL, 0x000fea0003800000ULL, 0x000000041e2b7811ULL, 0x000fe200078fe8ffULL,
0x0000008022787824ULL, 0x000fe200078e00ffULL, 0x000000081e6f7811ULL, 0x040fe400078fe8ffULL,
0x0000000c1e717811ULL, 0x040fe200078fe8ffULL, 0x000000012b287824ULL, 0x140fe200078e021eULL,
0x000000141e757811ULL, 0x040fe200078fe8ffULL, 0x000000082b7d7824ULL, 0x000fe200078e00ffULL,
0x0000200081817812ULL, 0x000fe200078ec0ffULL, 0x0000000171297824ULL, 0x140fe200078e021eULL,
0x000000101e737811ULL, 0x000fe200078fe8ffULL, 0x00000008716e7824ULL, 0x000fe200078e00ffULL,
0xfffffff87d7d7812ULL, 0x000fe200078ee228ULL, 0x000000016f287824ULL, 0x140fe200078e021eULL,
0x000000036f7f7819ULL, 0x000fe200000006ffULL, 0x00000001756d7824ULL, 0x140fe200078e021eULL,
0x0001700088887810ULL, 0x000fe20007ffe081ULL, 0x0000000875707824ULL, 0x000fe200078e00ffULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee228ULL, 0x00000001732a7824ULL, 0x000fe200078e021eULL,
0xfffffff86e817812ULL, 0x000fe200078ee229ULL, 0x000000016f6f7824ULL, 0x100fe200078e0279ULL,
0xfffffff870877812ULL, 0x000fe200078ee26dULL, 0x0000000171717824ULL, 0x100fe200078e0279ULL,
0x0000000373837819ULL, 0x040fe200000006ffULL, 0x0000000173737824ULL, 0x100fe200078e0279ULL,
0x0000001e1e287211ULL, 0x040fe200078fe8ffULL, 0x000000107d7d7824ULL, 0x100fe200078e0288ULL,
0x000000181e297811ULL, 0x040fe200078fe8ffULL, 0x000000107f7f7824ULL, 0x100fe200078e0288ULL,
0x0000001c1e6d7811ULL, 0x000fe200078fe8ffULL, 0x0000001081817824ULL, 0x000fe200078e0288ULL,
0xfffffff883837812ULL, 0x000fe200078ee22aULL, 0x0000000129777824ULL, 0x140fe200078e0279ULL,
0x00000007287b7812ULL, 0x000fe200078ec0ffULL, 0x0000000129287824ULL, 0x040fe200078e021eULL,
0x0000001e6d2a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000829897824ULL, 0x000fe200078e00ffULL,
0x0000008013787812ULL, 0x000fe200078ef878ULL, 0x000000086d8b7824ULL, 0x040fe200078e00ffULL,
0x000000792b2b7210ULL, 0x000fe20007ffe0ffULL, 0x000000016d6d7824ULL, 0x000fe200078e0279ULL,
0x0000007975757210ULL, 0x000fe20007ffe0ffULL, 0x0000001087877824ULL, 0x000fe200078e0288ULL,
0x000000791e297211ULL, 0x000fe200078fe8ffULL, 0x000000ffff797224ULL, 0x000fe200078e00ffULL,
0xfffffff88b8b7812ULL, 0x000fc400078ee22aULL, 0xfffffff889897812ULL, 0x000fe200078ee228ULL,
0x000001002b2a7825ULL, 0x100fe200078e0078ULL, 0x0ffffff87b7b7812ULL, 0x000fe400078ef81eULL,
0x0000008883837211ULL, 0x080fe200078e20ffULL, 0x0000010029287825ULL, 0x100fe200078e0078ULL,
0x0000002a842a7210ULL, 0x000fe40007f3e0ffULL, 0x000000887b7b7211ULL, 0x000fe200078e20ffULL,
0x000001006f6e7825ULL, 0x000fe200078e0078ULL, 0x0000002884287210ULL, 0x000fc60007f1e0ffULL,
0x0000010071707825ULL, 0x100fe200078e0078ULL, 0x0000006e846e7210ULL, 0x000fe40007f5e0ffULL,
0x0000002985297210ULL, 0x000fe200007fe4ffULL, 0x0000010073727825ULL, 0x000fe200078e0078ULL,
0x0000007084707210ULL, 0x000fc60007f7e0ffULL, 0x0000010075747825ULL, 0x100fe200078e0078ULL,
0x0000007284727210ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000287b7faeULL, 0x0003e4000b901c46ULL, 0x0000010077767825ULL, 0x000fe200078e0078ULL,
0x0000007385737210ULL, 0x000fc600007fe4ffULL, 0x000001006d787825ULL, 0x000fc800078e0078ULL,
0x00000001852b7824ULL, 0x040fe200008e062bULL, 0x0000007484747210ULL, 0x000fe20007f3e0ffULL,
0x00000001856f7824ULL, 0x040fe200010e066fULL, 0x0000007684767210ULL, 0x000fe20007f5e0ffULL,
0x0000000185717824ULL, 0x040fe200018e0671ULL, 0x0000007884787210ULL, 0x000fe20007f7e0ffULL,
0x0000000185757824ULL, 0x000fe200008e0675ULL, 0x000000002a7d7faeULL, 0x0003e2000b901c46ULL,
0x0000001089897824ULL, 0x100fe400078e0288ULL, 0x0000000185777824ULL, 0x000fe200010e0677ULL,
0x000000006e7f7faeULL, 0x0003e2000b901c46ULL, 0x000000108b8b7824ULL, 0x000fc400078e0288ULL,
0x0000000185797824ULL, 0x000fe200018e0679ULL, 0x0000000070817faeULL, 0x0003e8000b901c46ULL,
0x0000000072837faeULL, 0x0003e8000b901c46ULL, 0x0000000074877faeULL, 0x0003e8000b901c46ULL,
0x0000000076897faeULL, 0x0003e8000b901c46ULL, 0x00000000788b7faeULL, 0x0003e4000b901c46ULL,
0x0000000125287812ULL, 0x002fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff262a7811ULL, 0x000fe400078e08ffULL, 0x000000012800780cULL, 0x000fe20003f05070ULL,
0x0000002086867824ULL, 0x000fe200078e021dULL, 0x0000001019297812ULL, 0x000fe200078ec0ffULL,
0xffffffffff287424ULL, 0x000fe200078e00ffULL, 0x000000012a2a7807ULL, 0x000fc80004000000ULL,
0x0000002a252a7210ULL, 0x000fc80007ffe0ffULL, 0x0000001b2a00720cULL, 0x000fda0003f06070ULL,
0x00009000ff6e8b82ULL, 0x000e620000000a00ULL, 0x000000012a258824ULL, 0x000fc800078e0214ULL,
0x00000004256e8825ULL, 0x002fe200078e006eULL, 0x0000000819257812ULL, 0x000fc800078ec0ffULL,
0x0000008625257210ULL, 0x000fe20007ffe029ULL, 0x000000066e288981ULL, 0x000326000c1e1900ULL,
0x01e6486c257079a7ULL, 0x0002a6000850003fULL, 0x00000000006c7805ULL, 0x002fce0000015200ULL,
0x01e64871250075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ff002b7202ULL, 0x000fce0000000f00ULL, 0x000000102b00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000006e7805ULL, 0x000fce0000015200ULL,
0x0000006e6c6e7210ULL, 0x000fca0007f1e1ffULL, 0x000000016f6f7824ULL, 0x000fe200000e0e6dULL,
0x003d09006e00780cULL, 0x000fc80003f06070ULL, 0x000000ff6f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c406e00780cULL, 0x000fc80003f06070ULL,
0x000000ff6f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff297819ULL, 0x000fc8000001146fULL, 0x0000006e29297211ULL, 0x000fca00078110ffULL,
0x000000ffff6e7224ULL, 0x000fca00000e066fULL, 0x0000000229297819ULL, 0x000fc8000000126eULL,
0x000000290000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000012b2b7836ULL, 0x000fce0000000000ULL, 0x01e64871250075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000522257819ULL, 0x000fc800000006ffULL,
0xffffff80256c7812ULL, 0x000fc800078ec0ffULL, 0x000001001d257810ULL, 0x000fc80007ffe06cULL,
0x0000002512297210ULL, 0x000fe20007ffe013ULL, 0x000000ffff257224ULL, 0x000fc800078e0080ULL,
0x01e00000292b7984ULL, 0x000e680000000800ULL, 0x01e2000029867984ULL, 0x0004a20000000800ULL,
0x000000802b00720bULL, 0x002fda0003f1d000ULL, 0x00000000006c7806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x000000ff6c00720cULL, 0x000fda0003f25270ULL,
0x0000000400949947ULL, 0x004fea0003800000ULL, 0x0000000222257811ULL, 0x000fe400078ff0ffULL,
0x000000802b00720bULL, 0x000fe40003f14000ULL, 0x000000222500720cULL, 0x000fda0003f25270ULL,
0x0000008022299824ULL, 0x000fe200078e021dULL, 0x000000802b259209ULL, 0x000fc80007810000ULL,
0x00000029126e9210ULL, 0x000fe40007ffe013ULL, 0x0000000000297806ULL, 0x000fc600000e0100ULL,
0x01e400256e009388ULL, 0x0003e20000000800ULL, 0x000000ff2900720cULL, 0x000fda0003f05270ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x000000802b257209ULL, 0x000fe40007810000ULL,
0x000000ff29ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0029ff7812ULL, 0x000fe2000782c0ffULL,
0x0000008025257221ULL, 0x000fe20000010100ULL, 0x00ff000029ff7812ULL, 0x040fe4000784c0ffULL,
0xff00000029ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL,
0x00000025006e7308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff257819ULL, 0x002fcc000001161eULL, 0x00001f256e257589ULL, 0x004e6400000e0000ULL,
0x0000006825687220ULL, 0x042fe20000410000ULL, 0x0000006925697220ULL, 0x040fe20000410000ULL,
0x0000006425647220ULL, 0x040fe20000410000ULL, 0x0000006525657220ULL, 0x040fe20000410000ULL,
0x0000006025607220ULL, 0x040fe20000410000ULL, 0x0000006125617220ULL, 0x040fe20000410000ULL,
0x0000005c255c7220ULL, 0x040fe20000410000ULL, 0x0000005d255d7220ULL, 0x040fe20000410000ULL,
0x0000005825587220ULL, 0x040fe20000410000ULL, 0x0000005925597220ULL, 0x040fe20000410000ULL,
0x0000005425547220ULL, 0x040fe20000410000ULL, 0x0000005525557220ULL, 0x040fe20000410000ULL,
0x0000005025507220ULL, 0x040fe20000410000ULL, 0x0000005125517220ULL, 0x040fe20000410000ULL,
0x0000004c254c7220ULL, 0x040fe20000410000ULL, 0x0000004d254d7220ULL, 0x000fce0000410000ULL,
0x0000000000489947ULL, 0x000fea0003800000ULL, 0x000000081e257811ULL, 0x002fcc00078ff0ffULL,
0x00001f256e257589ULL, 0x004e6400000e0000ULL, 0x0000006a256a7220ULL, 0x042fe20000410000ULL,
0x0000006b256b7220ULL, 0x040fe20000410000ULL, 0x0000006625667220ULL, 0x040fe20000410000ULL,
0x0000006725677220ULL, 0x040fe20000410000ULL, 0x0000006225627220ULL, 0x040fe20000410000ULL,
0x0000006325637220ULL, 0x040fe20000410000ULL, 0x0000005e255e7220ULL, 0x040fe20000410000ULL,
0x0000005f255f7220ULL, 0x040fe20000410000ULL, 0x0000005a255a7220ULL, 0x040fe20000410000ULL,
0x0000005b255b7220ULL, 0x040fe20000410000ULL, 0x0000005625567220ULL, 0x040fe20000410000ULL,
0x0000005725577220ULL, 0x040fe20000410000ULL, 0x0000005225527220ULL, 0x040fe20000410000ULL,
0x0000005325537220ULL, 0x040fe20000410000ULL, 0x0000004e254e7220ULL, 0x040fe20000410000ULL,
0x0000004f254f7220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000101e257811ULL, 0x002fcc00078ff0ffULL, 0x00001f256e257589ULL, 0x004e6400000e0000ULL,
0x0000004825487220ULL, 0x042fe20000410000ULL, 0x0000004925497220ULL, 0x040fe20000410000ULL,
0x0000004425447220ULL, 0x040fe20000410000ULL, 0x0000004525457220ULL, 0x040fe20000410000ULL,
0x0000004025407220ULL, 0x040fe20000410000ULL, 0x0000004125417220ULL, 0x040fe20000410000ULL,
0x0000003c253c7220ULL, 0x040fe20000410000ULL, 0x0000003d253d7220ULL, 0x040fe20000410000ULL,
0x0000003825387220ULL, 0x040fe20000410000ULL, 0x0000003925397220ULL, 0x040fe20000410000ULL,
0x0000003425347220ULL, 0x040fe20000410000ULL, 0x0000003525357220ULL, 0x040fe20000410000ULL,
0x0000003025307220ULL, 0x040fe20000410000ULL, 0x0000003125317220ULL, 0x040fe20000410000ULL,
0x0000002c252c7220ULL, 0x040fe20000410000ULL, 0x0000002d252d7220ULL, 0x000fce0000410000ULL,
0x0000006e27277220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x000000181e257811ULL, 0x002fcc00078ff0ffULL, 0x00001f256e257589ULL, 0x000e6400000e0000ULL,
0x0000004a254a7220ULL, 0x042fe20000410000ULL, 0x0000004b254b7220ULL, 0x040fe20000410000ULL,
0x0000004625467220ULL, 0x040fe20000410000ULL, 0x0000004725477220ULL, 0x040fe20000410000ULL,
0x0000004225427220ULL, 0x040fe20000410000ULL, 0x0000004325437220ULL, 0x040fe20000410000ULL,
0x0000003e253e7220ULL, 0x040fe20000410000ULL, 0x0000003f253f7220ULL, 0x040fe20000410000ULL,
0x0000003a253a7220ULL, 0x040fe20000410000ULL, 0x0000003b253b7220ULL, 0x040fe20000410000ULL,
0x0000003625367220ULL, 0x040fe20000410000ULL, 0x0000003725377220ULL, 0x040fe20000410000ULL,
0x0000003225327220ULL, 0x040fe20000410000ULL, 0x0000003325337220ULL, 0x040fe20000410000ULL,
0x0000002e252e7220ULL, 0x040fe20000410000ULL, 0x0000002f252f7220ULL, 0x000fce0000410000ULL,
0x000000296cff7212ULL, 0x000fe400078030ffULL, 0x000000802b257209ULL, 0x002fd60007810000ULL,
0x800000252b2b0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b2b2b0820ULL, 0x000fc80000410000ULL,
0x0000002b00110308ULL, 0x000e640000000800ULL, 0x0000001186860220ULL, 0x002fce0000410000ULL,
0x0000040022297824ULL, 0x000fe200078e00ffULL, 0x0000001d18847211ULL, 0x000fe200078e70ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffff000296c7812ULL, 0x000fe200078ec0ffULL,
0x00002000152b7824ULL, 0x000fc600078e0284ULL, 0x000140001d297810ULL, 0x000fe20007ffe06cULL,
0x000160002b857836ULL, 0x000fe20000000000ULL, 0x0000000000288947ULL, 0x000fec0003800000ULL,
0x00000002ff6c7819ULL, 0x000fe4000001161eULL, 0x00000011ff07723eULL, 0x000fe400000000ffULL,
0x000000106c6e7810ULL, 0x000fe20007ffe0ffULL, 0x000000086c0a7836ULL, 0x000fe20000000000ULL,
0x00005410072b7816ULL, 0x000fe20000000007ULL, 0x000000186c087836ULL, 0x000fc80000000000ULL,
0x00001f0a2b0a7589ULL, 0x0002a800000e0000ULL, 0x00001f6e2b097589ULL, 0x0002e800000e0000ULL,
0x00001f6c2b077589ULL, 0x00026800000e0000ULL, 0x00001f082b087589ULL, 0x00026400000e0000ULL,
0x0000001010707824ULL, 0x100fe200078e0229ULL, 0x000000850d747211ULL, 0x000fe200078e20ffULL,
0x000000100f297824ULL, 0x000fe400078e0229ULL, 0x000000100e787824ULL, 0x100fe400078e0285ULL,
0x000000007070783bULL, 0x000ee20000000200ULL, 0x000000100c7c7824ULL, 0x000fc600078e0285ULL,
0x00000000296c783bULL, 0x0022a20000000200ULL, 0x0000000000208947ULL, 0x000fea0003800000ULL,
0x0000000770707232ULL, 0x088fe40000000000ULL, 0x0000000772727232ULL, 0x000fe40000000000ULL,
0x0000000a71717232ULL, 0x084fe40000000000ULL, 0x0000000a73737232ULL, 0x000fe40000000000ULL,
0x000000096c6c7232ULL, 0x080fe40000000000ULL, 0x000000096e6e7232ULL, 0x000fc40000000000ULL,
0x000000086d6d7232ULL, 0x080fe40000000000ULL, 0x000000086f6f7232ULL, 0x000fce0000000000ULL,
0x000000100b807824ULL, 0x000fe200078e0285ULL, 0x000000007474783bULL, 0x000f620000004200ULL,
0x00000002ff887819ULL, 0x000fc60000011622ULL, 0x000000007878783bULL, 0x000fe20000004200ULL,
0x0000001d88297211ULL, 0x002fc600078e60ffULL, 0x000000008080783bULL, 0x000e640000004200ULL,
0x0001400029297836ULL, 0x000fe40000000000ULL, 0x000000007c7c783bULL, 0x000e620000004200ULL,
0x000000746c48723cULL, 0x024fec0000001848ULL, 0x000000766c44723cULL, 0x000fec0000001844ULL,
0x000000807050723cULL, 0x00afec0000001850ULL, 0x00000082704c723cULL, 0x000fec000000184cULL,
0x000000806c30723cULL, 0x000fec0000001830ULL, 0x000000786c40723cULL, 0x000fec0000001840ULL,
0x0000007a6c3c723cULL, 0x000fec000000183cULL, 0x0000007c6c38723cULL, 0x000fec0000001838ULL,
0x0000007e6c34723cULL, 0x000fec0000001834ULL, 0x000000826c80723cULL, 0x000fec000000182cULL,
0x000000747068723cULL, 0x000fe20000001868ULL, 0x00000010066c7824ULL, 0x000fc400078e0229ULL,
0x0000001005297824ULL, 0x000fc600078e0229ULL, 0x000000767064723cULL, 0x000fe20000001864ULL,
0x000000006c6c783bULL, 0x000e620000000200ULL, 0x0000001003747824ULL, 0x000fc600078e0285ULL,
0x00000000292c783bULL, 0x0004e20000000200ULL, 0x000000787060723cULL, 0x000fec0000001860ULL,
0x0000007a705c723cULL, 0x000fe2000000185cULL, 0x0000001002787824ULL, 0x000fca00078e0285ULL,
0x0000007c7058723cULL, 0x000fec0000001858ULL, 0x0000007e7054723cULL, 0x000fee0000001854ULL,
0x0000008504707211ULL, 0x000fe200078e20ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000208947ULL, 0x004fde0003800000ULL, 0x000000076c6c7232ULL, 0x082fe40000000000ULL,
0x000000076e6e7232ULL, 0x000fe40000000000ULL, 0x0000000a6d6d7232ULL, 0x080fe40000000000ULL,
0x0000000a6f6f7232ULL, 0x000fe40000000000ULL, 0x000000092c2c7232ULL, 0x088fe40000000000ULL,
0x000000092e2e7232ULL, 0x000fc40000000000ULL, 0x000000082d2d7232ULL, 0x080fe40000000000ULL,
0x000000082f2f7232ULL, 0x000fce0000000000ULL, 0x00000010007c7824ULL, 0x000fe200078e0285ULL,
0x000000007070783bULL, 0x000ea20000004200ULL, 0x00000001262b7824ULL, 0x000fe200078e0223ULL,
0x0000000100297802ULL, 0x000fe20000000f00ULL, 0x0000002786277221ULL, 0x000fe20000010000ULL,
0x000000007474783bULL, 0x000f640000004200ULL, 0x0000001a2b00720cULL, 0x000fe40003f06070ULL,
0x000000007878783bULL, 0x000f680000004200ULL, 0x000000007c7c783bULL, 0x000f620000004200ULL,
0x000000706c68723cULL, 0x006fec0000001868ULL, 0x000000726c64723cULL, 0x000fec0000001864ULL,
0x000000746c60723cULL, 0x028fec0000001860ULL, 0x000000766c5c723cULL, 0x000fec000000185cULL,
0x000000786c58723cULL, 0x000fec0000001858ULL, 0x0000007a6c54723cULL, 0x000fec0000001854ULL,
0x0000007c6c50723cULL, 0x000fec0000001850ULL, 0x0000007e6c4c723cULL, 0x000fec000000184cULL,
0x000000702c48723cULL, 0x000fe20000001848ULL, 0x00000008886c7824ULL, 0x000fc800078e021dULL,
0x01e698296cff79a7ULL, 0x0003e2000850003fULL, 0x000000722c44723cULL, 0x000fec0000001844ULL,
0x000000742c40723cULL, 0x000fec0000001840ULL, 0x000000762c3c723cULL, 0x000fec000000183cULL,
0x000000782c38723cULL, 0x000fec0000001838ULL, 0x0000007a2c34723cULL, 0x000fec0000001834ULL,
0x0000007c2c30723cULL, 0x000fec0000001830ULL, 0x0000007e2c2c723cULL, 0x000fe20000001880ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000c00200947ULL, 0x002fde0003800000ULL, 0x00008e00ff6c7b82ULL, 0x000e620000000a00ULL,
0x000001002b6f7824ULL, 0x000fe200078e0217ULL, 0x000000012b2b7810ULL, 0x000fe20007ffe0ffULL,
0x0000850000047ab9ULL, 0x000fe40000000800ULL, 0x00000004286e7c24ULL, 0x010fe2000f8e02ffULL,
0x0000001a2b00720cULL, 0x000fe40003f06070ULL, 0x000000606f2b7812ULL, 0x000fe200078ec0ffULL,
0x000000806e717824ULL, 0x000fc800078e00ffULL, 0x00000001167d7824ULL, 0x000fe400078e022bULL,
0x00000100716c7825ULL, 0x002fc800078e006cULL, 0x0000000400948947ULL, 0x000fea0003800000ULL,
0x0000200022707824ULL, 0x000fe200078e00ffULL, 0x00000003ff7c7819ULL, 0x100fe2000001161eULL,
0x000000ffff6e7224ULL, 0x000fe200078e0a6fULL, 0x0000006f1c2b7248ULL, 0x000fe40007fe0000ULL,
0x000000047c727810ULL, 0x000fe20007ffe0ffULL, 0x000000087c7e7836ULL, 0x000fe20000000000ULL,
0x00002000706f7812ULL, 0x000fe200078ec0ffULL, 0x000000107c827836ULL, 0x000fe20000000000ULL,
0x0000000722707819ULL, 0x000fe200000006ffULL, 0x0000000172717824ULL, 0x100fe200078e021eULL,
0x0001600084847810ULL, 0x000fe20007ffe06fULL, 0x0000000872747824ULL, 0x000fe200078e00ffULL,
0x000000202b2b7446ULL, 0x000fe2000380006eULL, 0x000000017c6f7824ULL, 0x000fe200078e021eULL,
0x00000080136e7812ULL, 0x000fe200078ef870ULL, 0x000000017e757824ULL, 0x100fe200078e027dULL,
0xfffffff874817812ULL, 0x000fe200078ee271ULL, 0x000000017c717824ULL, 0x100fe200078e027dULL,
0x000000076f7b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff6f7224ULL, 0x000fe200078e00ffULL,
0x0000000c7c807810ULL, 0x000fe20007ffe0ffULL, 0x0000000172737824ULL, 0x040fe200078e027dULL,
0x0000002b7200720cULL, 0x000fe20003f26070ULL, 0x0000010071707825ULL, 0x000fe200078e006eULL,
0x0000007d80777210ULL, 0x000fc40007ffe0ffULL, 0x0000002b7c00720cULL, 0x080fe20003f06070ULL,
0x0000010075747825ULL, 0x100fe200078e006eULL, 0x000000706c787210ULL, 0x000fe40007f5e0ffULL,
0x000000147c867810ULL, 0x000fe20007ffe0ffULL, 0x0000010073727825ULL, 0x000fe200078e006eULL,
0x0000002b7e00720cULL, 0x080fe40003fa6070ULL, 0x0000002b8000720cULL, 0x000fe20003f86070ULL,
0x000000016d797824ULL, 0x000fe200010e0671ULL, 0x0ffffff87b717812ULL, 0x000fe200078ef81eULL,
0x0000010077767825ULL, 0x000fe200078e006eULL, 0x000000746c707210ULL, 0x000fc40007f5e0ffULL,
0x000000726c7a7210ULL, 0x000fe20007f7e0ffULL, 0x00000010717f7824ULL, 0x100fe200078e0284ULL,
0x000000756d717210ULL, 0x000fe200017fe4ffULL, 0x0000001081817824ULL, 0x000fe200078e0284ULL,
0x0000007d82757210ULL, 0x000fe20007ffe0ffULL, 0x000000016d7b7824ULL, 0x000fe200018e0673ULL,
0x000000766c727210ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000787f7faeULL, 0x0003e2000c101c46ULL, 0x000000187c8a7836ULL, 0x000fe20000000000ULL,
0x0000002b8600720cULL, 0x080fe20003f46070ULL, 0x0000010075747825ULL, 0x000fe200078e006eULL,
0x000000007a817faeULL, 0x0005e4000c901c46ULL, 0x0000002b8a00720cULL, 0x080fe20003f26070ULL,
0x000000016d737824ULL, 0x000fe200018e0677ULL, 0x000000746c767210ULL, 0x000fe20007fde0ffULL,
0x000000017e777824ULL, 0x100fe200078e021eULL, 0x0000002b8200720cULL, 0x000fe20003f66070ULL,
0x000000087e7e7824ULL, 0x000fe200078e00ffULL, 0x0000007d86797210ULL, 0x002fe20007ffe0ffULL,
0x0000000180787824ULL, 0x000fc400078e021eULL, 0x0000001c7c7c7836ULL, 0x000fe20000000000ULL,
0xfffffff87e7f7812ULL, 0x000fe200078ee277ULL, 0x0000000880817824ULL, 0x004fe200078e00ffULL,
0x0000001e867a7210ULL, 0x000fe20007ffe0ffULL, 0x000000016d777824ULL, 0x000fe200030e0675ULL,
0x0000002b7c00720cULL, 0x000fe20003f06070ULL, 0x0000010079747825ULL, 0x000fe200078e006eULL,
0xfffffff881817812ULL, 0x000fe400078ee278ULL, 0x0000007d7c7b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000182797824ULL, 0x040fe200078e021eULL, 0x000000746c787210ULL, 0x000fe20007fde0ffULL,
0x0000000882827824ULL, 0x000fc400078e00ffULL, 0x000000018a2b7824ULL, 0x000fe200078e027dULL,
0x000000037c7d7819ULL, 0x000fe200000006ffULL, 0x0000000886857824ULL, 0x000fe200078e00ffULL,
0xfffffff882837812ULL, 0x000fe200078ee279ULL, 0x000000016d797824ULL, 0x000fe400030e0675ULL,
0x000001002b747825ULL, 0x000fe200078e006eULL, 0xfffffff885857812ULL, 0x000fe400078ee27aULL,
0x0000008483837211ULL, 0x000fe200078e20ffULL, 0x000000018a2b7824ULL, 0x040fe200078e021eULL,
0x000000746c747210ULL, 0x000fe20007fde0ffULL, 0x000000088a8a7824ULL, 0x000fc400078e00ffULL,
0x000000017c7a7824ULL, 0x000fe400078e021eULL, 0x000001007b6e7825ULL, 0x000fe200078e006eULL,
0xfffffff88a2b7812ULL, 0x000fe400078ee22bULL, 0xfffffff87d7b7812ULL, 0x000fe200078ee27aULL,
0x000000016d757824ULL, 0x000fe200030e0675ULL, 0x0000006e6c6c7210ULL, 0x000fe20007fde0ffULL,
0x000000107f7f7824ULL, 0x100fe400078e0284ULL, 0x0000001081817824ULL, 0x100fe200078e0284ULL,
0x0000006f6d6d7210ULL, 0x000fe200037fe4ffULL, 0x0000001085857824ULL, 0x100fe200078e0284ULL,
0x00000000707f7faeULL, 0x0003e2000e901c46ULL, 0x000000102b2b7824ULL, 0x000fc400078e0284ULL,
0x000000107b7b7824ULL, 0x000fe200078e0284ULL, 0x0000000072817faeULL, 0x0003e8000e101c46ULL,
0x0000000076837faeULL, 0x0003e8000d901c46ULL, 0x0000000078857faeULL, 0x0003e8000d101c46ULL,
0x00000000742b7faeULL, 0x0003e8000c901c46ULL, 0x000000006c7b7faeULL, 0x0003e2000c101c46ULL,
0x0000000400607947ULL, 0x000fea0003800000ULL, 0x000000041e717811ULL, 0x000fe200078fe8ffULL,
0x00002000222b7824ULL, 0x000fe200078e00ffULL, 0x0000000c1e757811ULL, 0x040fe400078fe8ffULL,
0x000000081e737811ULL, 0x040fe200078fe8ffULL, 0x00000001716e7824ULL, 0x140fe200078e021eULL,
0x000000101e777811ULL, 0x040fe200078fe8ffULL, 0x0000000871817824ULL, 0x000fe200078e00ffULL,
0x000020002b2b7812ULL, 0x000fe200078ec0ffULL, 0x0000000875857824ULL, 0x000fe200078e00ffULL,
0x000000141e797811ULL, 0x000fe200078fe8ffULL, 0x0000000873727824ULL, 0x000fe200078e00ffULL,
0xfffffff881817812ULL, 0x000fe200078ee26eULL, 0x00000001756e7824ULL, 0x100fe200078e021eULL,
0x0001600084847810ULL, 0x000fe20007ffe02bULL, 0x0000000877747824ULL, 0x000fe200078e00ffULL,
0x0000001e732b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000179707824ULL, 0x040fe200078e021eULL,
0x0000001e776f7210ULL, 0x000fe20007ffe0ffULL, 0x0000000879897824ULL, 0x000fe200078e00ffULL,
0xfffffff885857812ULL, 0x000fe200078ee26eULL, 0x0000000171717824ULL, 0x100fe200078e027dULL,
0xfffffff872837812ULL, 0x000fe200078ee22bULL, 0x0000000173737824ULL, 0x100fe200078e027dULL,
0xfffffff874877812ULL, 0x000fe200078ee26fULL, 0x0000000175757824ULL, 0x100fe200078e027dULL,
0x000000181e6e7811ULL, 0x040fe200078fe8ffULL, 0x0000000179797824ULL, 0x100fe200078e027dULL,
0x0000001e1e2b7211ULL, 0x040fe200078fe8ffULL, 0x0000001081817824ULL, 0x000fe200078e0284ULL,
0x0000001c1e6f7811ULL, 0x000fe200078fe8ffULL, 0x000000016e7b7824ULL, 0x140fe200078e027dULL,
0xfffffff889897812ULL, 0x000fe200078ee270ULL, 0x000000016e707824ULL, 0x100fe200078e021eULL,
0x00000007227c7819ULL, 0x000fe200000006ffULL, 0x000000086f8d7824ULL, 0x000fe200078e00ffULL,
0x000000072b7f7812ULL, 0x000fe200078ec0ffULL, 0x000000016f2b7824ULL, 0x040fe200078e027dULL,
0x000000036e8b7819ULL, 0x000fe200000006ffULL, 0x000000016f6e7824ULL, 0x000fe200078e021eULL,
0x0000007d77777210ULL, 0x000fe20007ffe0ffULL, 0x0000001083837824ULL, 0x100fe200078e0284ULL,
0x0000007d1e6f7211ULL, 0x000fe200078fe8ffULL, 0x0000001087877824ULL, 0x100fe200078e0284ULL,
0x00000080137c7812ULL, 0x000fe200078ef87cULL, 0x0000001089897824ULL, 0x000fe200078e0284ULL,
0x000000ff007d7202ULL, 0x000fc40000000f00ULL, 0xfffffff88d8d7812ULL, 0x000fe400078ee26eULL,
0xfffffff88b8b7812ULL, 0x000fe200078ee270ULL, 0x000001006f6e7825ULL, 0x100fe200078e007cULL,
0x0ffffff87f7f7812ULL, 0x000fe400078ef81eULL, 0x0000008485857211ULL, 0x080fe200078e20ffULL,
0x0000010071707825ULL, 0x100fe200078e007cULL, 0x0000006e6c6e7210ULL, 0x000fe40007f1e0ffULL,
0x000000848d8d7211ULL, 0x000fe200078e20ffULL, 0x0000010073727825ULL, 0x000fe200078e007cULL,
0x000000706c707210ULL, 0x000fc60007f3e0ffULL, 0x0000010075747825ULL, 0x000fe200078e007cULL,
0x000000726c727210ULL, 0x000fc60007f5e0ffULL, 0x0000010077767825ULL, 0x000fe200078e007cULL,
0x000000746c747210ULL, 0x000fc60007f7e0ffULL, 0x0000010079787825ULL, 0x000fe200078e007cULL,
0x000000756d757210ULL, 0x000fc60001ffe4ffULL, 0x000001007b7a7825ULL, 0x000fc800078e007cULL,
0x000001002b7c7825ULL, 0x000fc800078e007cULL, 0x000000016d6f7824ULL, 0x040fe200000e066fULL,
0x000000766c767210ULL, 0x000fe20007f1e0ffULL, 0x000000016d717824ULL, 0x000fe200008e0671ULL,
0x000000786c787210ULL, 0x000fe20007f3e0ffULL, 0x000000107f7f7824ULL, 0x100fe400078e0284ULL,
0x000000016d737824ULL, 0x040fe200010e0673ULL, 0x0000007a6c7a7210ULL, 0x000fe20007f5e0ffULL,
0x000000016d777824ULL, 0x040fe200000e0677ULL, 0x0000007c6c6c7210ULL, 0x000fe20007f7e0ffULL,
0x000000016d797824ULL, 0x000fe200008e0679ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e7f7faeULL, 0x0003e2000b901c46ULL, 0x000000108b8b7824ULL, 0x000fc400078e0284ULL,
0x000000016d7b7824ULL, 0x000fe200010e067bULL, 0x0000000070817faeULL, 0x0003e2000b901c46ULL,
0x0000007d6d6d7210ULL, 0x000fc60001ffe4ffULL, 0x0000000072837faeULL, 0x0003e8000b901c46ULL,
0x0000000074857faeULL, 0x0003e8000b901c46ULL, 0x0000000076877faeULL, 0x0003e8000b901c46ULL,
0x0000000078897faeULL, 0x0003e8000b901c46ULL, 0x000000007a8b7faeULL, 0x0003e8000b901c46ULL,
0x000000006c8d7faeULL, 0x0003e4000b901c46ULL, 0x0000002088887824ULL, 0x000fe200078e021dULL,
0x00000010192b7812ULL, 0x042fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000008196c7812ULL, 0x000fc800078ec0ffULL, 0x000000886c2b7210ULL, 0x000fc80007ffe02bULL,
0x01e668292b7079a7ULL, 0x0002a6000850003fULL, 0x00000000006c7805ULL, 0x000fce0000015200ULL,
0x01e668712b0075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff727224ULL, 0x000fce00078e00ffULL, 0x000000107200780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000006e7805ULL, 0x000fce0000015200ULL,
0x0000006e6c6e7210ULL, 0x000fca0007f1e1ffULL, 0x000000016f6f7824ULL, 0x000fe200000e0e6dULL,
0x003d09006e00780cULL, 0x000fc80003f06070ULL, 0x000000ff6f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c406e00780cULL, 0x000fc80003f06070ULL,
0x000000ff6f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff297819ULL, 0x002fc8000001146fULL, 0x0000006e29297211ULL, 0x000fc800078110ffULL,
0x0000006fff6e7210ULL, 0x000fc800007fe4ffULL, 0x0000000229297819ULL, 0x000fc8000000126eULL,
0x000000290000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000172727836ULL, 0x000fce0000000000ULL, 0x01e668712b0075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x00000003226c7811ULL, 0x000fca00078ff0ffULL,
0x000000806c297824ULL, 0x002fca00078e021dULL, 0x00000029122b7210ULL, 0x000fe20007ffe013ULL,
0x000000ffff297224ULL, 0x000fc800078e0025ULL, 0x01e000002b6e7984ULL, 0x000e680000000800ULL,
0x01e200002b887984ULL, 0x0004a20000000800ULL, 0x000000256e00720bULL, 0x002fda0003f1d000ULL,
0x00000000006d7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x000000ff6d00720cULL, 0x000fda0003f25270ULL, 0x0000000400909947ULL, 0x004fea0003800000ULL,
0x000000226c00720cULL, 0x000fe40003f25270ULL, 0x000000256e00720bULL, 0x000fd60003f14000ULL,
0x0000001d222b9211ULL, 0x000fe400078e38ffULL, 0x000000256e299209ULL, 0x000fe40007810000ULL,
0x0000002b12129210ULL, 0x000fe40007ffe013ULL, 0x0000000000707806ULL, 0x000fc600000e0100ULL,
0x01e4002912009388ULL, 0x0003e20000000800ULL, 0x000000ff7000720cULL, 0x000fda0003f05270ULL,
0x0000000400548947ULL, 0x002fea0003800000ULL, 0x000000256e127209ULL, 0x000fe40007810000ULL,
0x000000ff70ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0070ff7812ULL, 0x000fe2000782c0ffULL,
0x0000002512127221ULL, 0x000fe20000010100ULL, 0x00ff000070ff7812ULL, 0x040fe4000784c0ffULL,
0xff00000070ff7812ULL, 0x000fe2000786c0ffULL, 0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL,
0x0000001200727308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff137819ULL, 0x000fca000001161eULL, 0x00001f1372127589ULL, 0x006e6400000e0000ULL,
0x0000006812687220ULL, 0x042fe20000410000ULL, 0x0000006912697220ULL, 0x040fe20000410000ULL,
0x0000006412647220ULL, 0x040fe20000410000ULL, 0x0000006512657220ULL, 0x040fe20000410000ULL,
0x0000006012607220ULL, 0x040fe20000410000ULL, 0x0000006112617220ULL, 0x040fe20000410000ULL,
0x0000005c125c7220ULL, 0x040fe20000410000ULL, 0x0000005d125d7220ULL, 0x040fe20000410000ULL,
0x0000005812587220ULL, 0x040fe20000410000ULL, 0x0000005912597220ULL, 0x040fe20000410000ULL,
0x0000005412547220ULL, 0x040fe20000410000ULL, 0x0000005512557220ULL, 0x040fe20000410000ULL,
0x0000005012507220ULL, 0x040fe20000410000ULL, 0x0000005112517220ULL, 0x040fe20000410000ULL,
0x0000004c124c7220ULL, 0x040fe20000410000ULL, 0x0000004d124d7220ULL, 0x000fce0000410000ULL,
0x0000000000489947ULL, 0x000fea0003800000ULL, 0x000000081e137811ULL, 0x000fca00078ff0ffULL,
0x00001f1372127589ULL, 0x006e6400000e0000ULL, 0x0000006a126a7220ULL, 0x042fe20000410000ULL,
0x0000006b126b7220ULL, 0x040fe20000410000ULL, 0x0000006612667220ULL, 0x040fe20000410000ULL,
0x0000006712677220ULL, 0x040fe20000410000ULL, 0x0000006212627220ULL, 0x040fe20000410000ULL,
0x0000006312637220ULL, 0x040fe20000410000ULL, 0x0000005e125e7220ULL, 0x040fe20000410000ULL,
0x0000005f125f7220ULL, 0x040fe20000410000ULL, 0x0000005a125a7220ULL, 0x040fe20000410000ULL,
0x0000005b125b7220ULL, 0x040fe20000410000ULL, 0x0000005612567220ULL, 0x040fe20000410000ULL,
0x0000005712577220ULL, 0x040fe20000410000ULL, 0x0000005212527220ULL, 0x040fe20000410000ULL,
0x0000005312537220ULL, 0x040fe20000410000ULL, 0x0000004e124e7220ULL, 0x040fe20000410000ULL,
0x0000004f124f7220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000101e137811ULL, 0x000fca00078ff0ffULL, 0x00001f1372127589ULL, 0x006e6400000e0000ULL,
0x0000004812487220ULL, 0x042fe20000410000ULL, 0x0000004912497220ULL, 0x040fe20000410000ULL,
0x0000004412447220ULL, 0x040fe20000410000ULL, 0x0000004512457220ULL, 0x040fe20000410000ULL,
0x0000004012407220ULL, 0x040fe20000410000ULL, 0x0000004112417220ULL, 0x040fe20000410000ULL,
0x0000003c123c7220ULL, 0x040fe20000410000ULL, 0x0000003d123d7220ULL, 0x040fe20000410000ULL,
0x0000003812387220ULL, 0x040fe20000410000ULL, 0x0000003912397220ULL, 0x040fe20000410000ULL,
0x0000003412347220ULL, 0x040fe20000410000ULL, 0x0000003512357220ULL, 0x040fe20000410000ULL,
0x0000003012307220ULL, 0x040fe20000410000ULL, 0x0000003112317220ULL, 0x040fe20000410000ULL,
0x0000002c122c7220ULL, 0x040fe20000410000ULL, 0x0000002d122d7220ULL, 0x000fce0000410000ULL,
0x0000007227277220ULL, 0x004fe20000410000ULL, 0x000000000048b947ULL, 0x000fec0003800000ULL,
0x000000181e137811ULL, 0x000fca00078ff0ffULL, 0x00001f1372127589ULL, 0x002e6400000e0000ULL,
0x0000004a124a7220ULL, 0x042fe20000410000ULL, 0x0000004b124b7220ULL, 0x040fe20000410000ULL,
0x0000004612467220ULL, 0x040fe20000410000ULL, 0x0000004712477220ULL, 0x040fe20000410000ULL,
0x0000004212427220ULL, 0x040fe20000410000ULL, 0x0000004312437220ULL, 0x040fe20000410000ULL,
0x0000003e123e7220ULL, 0x040fe20000410000ULL, 0x0000003f123f7220ULL, 0x040fe20000410000ULL,
0x0000003a123a7220ULL, 0x040fe20000410000ULL, 0x0000003b123b7220ULL, 0x040fe20000410000ULL,
0x0000003612367220ULL, 0x040fe20000410000ULL, 0x0000003712377220ULL, 0x040fe20000410000ULL,
0x0000003212327220ULL, 0x040fe20000410000ULL, 0x0000003312337220ULL, 0x040fe20000410000ULL,
0x0000002e122e7220ULL, 0x040fe20000410000ULL, 0x0000002f122f7220ULL, 0x000fce0000410000ULL,
0x000000706dff7212ULL, 0x000fe400078030ffULL, 0x000000256e297209ULL, 0x000fd60007810000ULL,
0x800000296e6e0221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b6e6e0820ULL, 0x000fc80000410000ULL,
0x0000006e00110308ULL, 0x000ea40000000800ULL, 0x0000001188880220ULL, 0x004fce0000410000ULL,
0x00004000186e7824ULL, 0x000fe200078e021dULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000010006c6c7824ULL, 0x000fe200078e021dULL, 0x0000006e156e7211ULL, 0x000fc600078e68ffULL,
0x000120006c127836ULL, 0x002fe40000000000ULL, 0x000170006e257836ULL, 0x000fe40000000000ULL,
0x0000001010107824ULL, 0x100fe400078e0212ULL, 0x000000100f0f7824ULL, 0x000fe200078e0212ULL,
0x0000000000288947ULL, 0x000fec0003800000ULL, 0x00000002ff6c7819ULL, 0x000fe4000001161eULL,
0x00000011ff07723eULL, 0x000fe400000000ffULL, 0x000000086c0a7810ULL, 0x000fe20007ffe0ffULL,
0x000000186c087836ULL, 0x000fe20000000000ULL, 0x0000541007137816ULL, 0x000fe20000000007ULL,
0x000000106c6e7836ULL, 0x000fc80000000000ULL, 0x00001f0a130a7589ULL, 0x0002a800000e0000ULL,
0x00001f6e13097589ULL, 0x0002e800000e0000ULL, 0x00001f6c13077589ULL, 0x00026800000e0000ULL,
0x00001f0813087589ULL, 0x00026400000e0000ULL, 0x000000001070783bULL, 0x0006a20000000200ULL,
0x000000100d747824ULL, 0x000fe200078e0225ULL, 0x000000250e787211ULL, 0x000fe400078e20ffULL,
0x000000000f6c783bULL, 0x0026620000000200ULL, 0x0000000000208947ULL, 0x000fea0003800000ULL,
0x0000000770707232ULL, 0x084fe40000000000ULL, 0x0000000772727232ULL, 0x000fe40000000000ULL,
0x0000000a71717232ULL, 0x080fe40000000000ULL, 0x0000000a73737232ULL, 0x000fe40000000000ULL,
0x000000096c6c7232ULL, 0x08afe40000000000ULL, 0x000000096e6e7232ULL, 0x000fc40000000000ULL,
0x000000086d6d7232ULL, 0x080fe40000000000ULL, 0x000000086f6f7232ULL, 0x000fce0000000000ULL,
0x000000100c0c7824ULL, 0x100fe200078e0225ULL, 0x000000007878783bULL, 0x000f620000004200ULL,
0x000000100b7c7824ULL, 0x000fe200078e0225ULL, 0x0000001205057211ULL, 0x000fe200078e20ffULL,
0x0000001006067824ULL, 0x000fe200078e0212ULL, 0x000000007474783bULL, 0x000f620000004200ULL,
0x0000002788277221ULL, 0x000fc60000010000ULL, 0x000000000c0c783bULL, 0x008ee80000004200ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x000000787080723cULL, 0x024fe60000001860ULL,
0x000000000660783bULL, 0x0004a60000000200ULL, 0x0000007a7084723cULL, 0x000fe2000000185cULL,
0x00000000055c783bULL, 0x0004aa0000000200ULL, 0x000000747068723cULL, 0x000fec0000001868ULL,
0x000000767064723cULL, 0x000fec0000001864ULL, 0x0000000c7058723cULL, 0x008fec0000001858ULL,
0x0000000e7054723cULL, 0x000fec0000001854ULL, 0x0000007c7050723cULL, 0x002fec0000001850ULL,
0x0000007e704c723cULL, 0x000fec000000184cULL, 0x000000746c48723cULL, 0x000fec0000001848ULL,
0x000000766c44723cULL, 0x000fec0000001844ULL, 0x000000786c40723cULL, 0x000fec0000001840ULL,
0x0000007a6c3c723cULL, 0x000fec000000183cULL, 0x0000000c6c38723cULL, 0x000fec0000001838ULL,
0x0000000e6c34723cULL, 0x000fec0000001834ULL, 0x0000007c6c30723cULL, 0x000fec0000001830ULL,
0x0000007e6c2c723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000208947ULL, 0x004fde0003800000ULL, 0x0000000760607232ULL, 0x080fe40000000000ULL,
0x0000000762627232ULL, 0x000fe40000000000ULL, 0x0000000a61617232ULL, 0x080fe40000000000ULL,
0x0000000a63637232ULL, 0x000fe40000000000ULL, 0x000000095c5c7232ULL, 0x080fe40000000000ULL,
0x000000095e5e7232ULL, 0x000fc40000000000ULL, 0x000000085d5d7232ULL, 0x080fe40000000000ULL,
0x000000085f5f7232ULL, 0x000fce0000000000ULL, 0x00000010046c7824ULL, 0x100fe200078e0225ULL,
0x00000025000c7211ULL, 0x000fe200078e20ffULL, 0x00000010037c7824ULL, 0x100fe200078e0225ULL,
0x00000002ff007819ULL, 0x000fe20000011622ULL, 0x0000001002707824ULL, 0x000fe400078e0225ULL,
0x000000006c6c783bULL, 0x000e620000004200ULL, 0x0000000126237824ULL, 0x000fe400078e0223ULL,
0x00000001ff037424ULL, 0x000fe200078e00ffULL, 0x000000007c7c783bULL, 0x000ea20000004200ULL,
0x0000000800007824ULL, 0x000fe200078e021dULL, 0x0000001a2300720cULL, 0x000fc40003f06070ULL,
0x000000007070783bULL, 0x000ee80000004200ULL, 0x000000000c0c783bULL, 0x000f620000004200ULL,
0x01e6a00300ff79a7ULL, 0x0003e4000850003fULL, 0x0000006c6068723cULL, 0x002fec0000001868ULL,
0x0000006e6064723cULL, 0x000fec0000001864ULL, 0x0000007c6078723cULL, 0x004fec0000001880ULL,
0x0000007e6074723cULL, 0x000fec0000001884ULL, 0x000000706058723cULL, 0x008fec0000001858ULL,
0x000000726054723cULL, 0x000fec0000001854ULL, 0x0000000c6050723cULL, 0x020fec0000001850ULL,
0x0000000e604c723cULL, 0x000fec000000184cULL, 0x0000006c5c48723cULL, 0x000fec0000001848ULL,
0x0000006e5c44723cULL, 0x000fec0000001844ULL, 0x0000007c5c40723cULL, 0x000fec0000001840ULL,
0x0000007e5c3c723cULL, 0x000fec000000183cULL, 0x000000705c38723cULL, 0x000fec0000001838ULL,
0x000000725c34723cULL, 0x000fec0000001834ULL, 0x0000000c5c30723cULL, 0x000fec0000001830ULL,
0x0000000e5c2c723cULL, 0x000fe2000000182cULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffff8800c48947ULL, 0x000fde000383ffffULL, 0x0000000000027919ULL, 0x000e620000002500ULL,
0x0000002f005e7202ULL, 0x000fe20000000f00ULL, 0x000000ffff617224ULL, 0x000fe200078e002eULL,
0x0000003300287202ULL, 0x010fe20000000f00ULL, 0x000000ffff5c7224ULL, 0x000fe200078e002dULL,
0x0000003700167202ULL, 0x000fe20000000f00ULL, 0x000000ffff2a7224ULL, 0x000fe400078e002cULL,
0x000000ffff5f7224ULL, 0x000fe400078e0032ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0031ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0030ULL, 0x000000ffff5d7224ULL, 0x000fe400078e0036ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0034ULL, 0x0000001a0200720cULL, 0x002fda0003f06070ULL,
0x0000000400540947ULL, 0x000fea0003800000ULL, 0x0180000027007836ULL, 0x000fca0000000000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x0000951000047802ULL, 0x000fce0000000f00ULL,
0x000000ec00547944ULL, 0x000fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000002700007308ULL, 0x000e640000001000ULL, 0xbf80000000037423ULL, 0x002fc80000000027ULL,
0x800000ff03037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fce0000000000ULL,
0x0000000000057919ULL, 0x000f240000000000ULL, 0x00000002ff037819ULL, 0x010fe40000011605ULL,
0x0000000805077811ULL, 0x040fe400078ff0ffULL, 0x0000001005097811ULL, 0x040fe400078ff0ffULL,
0x00000018050b7811ULL, 0x000fe200078ff0ffULL, 0x0000000000007948ULL, 0x00cfea0003800000ULL,
0x00001f0300037589ULL, 0x000ea800000e0000ULL, 0x00001f0700047589ULL, 0x000ee800000e0000ULL,
0x00001f0900057589ULL, 0x000f2800000e0000ULL, 0x00001f0b00067589ULL, 0x000f6200000e0000ULL,
0x0000006803687220ULL, 0x044fe20000410000ULL, 0x0000006903697220ULL, 0x040fe20000410000ULL,
0x0000006403647220ULL, 0x040fe20000410000ULL, 0x0000006503657220ULL, 0x040fe20000410000ULL,
0x0000007803787220ULL, 0x040fe20000410000ULL, 0x0000007903797220ULL, 0x040fe20000410000ULL,
0x0000007403747220ULL, 0x040fe20000410000ULL, 0x0000007503757220ULL, 0x040fe20000410000ULL,
0x0000005803587220ULL, 0x040fe20000410000ULL, 0x0000005903597220ULL, 0x040fe20000410000ULL,
0x0000005403547220ULL, 0x040fe20000410000ULL, 0x0000005503557220ULL, 0x040fe20000410000ULL,
0x0000005003507220ULL, 0x040fe20000410000ULL, 0x0000005103517220ULL, 0x040fe20000410000ULL,
0x0000004c034c7220ULL, 0x040fe20000410000ULL, 0x0000004d034d7220ULL, 0x000fe20000410000ULL,
0x0000006a046a7220ULL, 0x048fe20000410000ULL, 0x0000006b046b7220ULL, 0x040fe20000410000ULL,
0x0000006604667220ULL, 0x040fe20000410000ULL, 0x0000006704677220ULL, 0x040fe20000410000ULL,
0x0000007a047a7220ULL, 0x040fe20000410000ULL, 0x0000007b047b7220ULL, 0x040fe20000410000ULL,
0x0000007604767220ULL, 0x040fe20000410000ULL, 0x0000007704777220ULL, 0x040fe20000410000ULL,
0x0000005a045a7220ULL, 0x040fe20000410000ULL, 0x0000005b045b7220ULL, 0x040fe20000410000ULL,
0x0000005604567220ULL, 0x040fe20000410000ULL, 0x0000005704577220ULL, 0x040fe20000410000ULL,
0x0000005204527220ULL, 0x040fe20000410000ULL, 0x0000005304537220ULL, 0x040fe20000410000ULL,
0x0000004e044e7220ULL, 0x040fe20000410000ULL, 0x0000004f044f7220ULL, 0x000fe20000410000ULL,
0x0000004805487220ULL, 0x050fe20000410000ULL, 0x0000004905497220ULL, 0x040fe20000410000ULL,
0x0000004405447220ULL, 0x040fe20000410000ULL, 0x0000004505457220ULL, 0x040fe20000410000ULL,
0x0000004005407220ULL, 0x040fe20000410000ULL, 0x0000004105417220ULL, 0x040fe20000410000ULL,
0x0000003c053c7220ULL, 0x040fe20000410000ULL, 0x0000003d053d7220ULL, 0x040fe20000410000ULL,
0x0000003805387220ULL, 0x040fe20000410000ULL, 0x0000003905397220ULL, 0x040fe20000410000ULL,
0x0000000e050e7220ULL, 0x040fe20000410000ULL, 0x0000003505357220ULL, 0x040fe20000410000ULL,
0x0000001c051c7220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000005c055c7220ULL, 0x000fe20000410000ULL,
0x0000004a064a7220ULL, 0x062fe20000410000ULL, 0x0000004b064b7220ULL, 0x040fe20000410000ULL,
0x0000004606467220ULL, 0x040fe20000410000ULL, 0x0000004706477220ULL, 0x040fe20000410000ULL,
0x0000004206427220ULL, 0x040fe20000410000ULL, 0x0000004306437220ULL, 0x040fe20000410000ULL,
0x0000003e063e7220ULL, 0x040fe20000410000ULL, 0x0000003f063f7220ULL, 0x040fe20000410000ULL,
0x0000003a063a7220ULL, 0x040fe20000410000ULL, 0x0000003b063b7220ULL, 0x040fe20000410000ULL,
0x0000005d065d7220ULL, 0x040fe20000410000ULL, 0x0000001606167220ULL, 0x040fe20000410000ULL,
0x0000005f065f7220ULL, 0x040fe20000410000ULL, 0x0000002806287220ULL, 0x040fe20000410000ULL,
0x0000006106617220ULL, 0x040fe20000410000ULL, 0x0000005e065e7220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x0000001d151d7211ULL, 0x000fe200078e68ffULL,
0x00001000180c7824ULL, 0x000fe200078e00ffULL, 0x000000545509723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000011d147824ULL, 0x000fe200078e020cULL,
0x0000004c4d0b723eULL, 0x000fc400000000ffULL, 0x0000006a6b10723eULL, 0x000fe400000000ffULL,
0x000000666711723eULL, 0x000fe400000000ffULL, 0x0000007a7b12723eULL, 0x000fe400000000ffULL,
0x000000767713723eULL, 0x000fe400000000ffULL, 0x0000005a5b2c723eULL, 0x000fe400000000ffULL,
0x00000056572d723eULL, 0x000fc400000000ffULL, 0x00000052532e723eULL, 0x000fe400000000ffULL,
0x0000004e4f2f723eULL, 0x000fe400000000ffULL, 0x000000484930723eULL, 0x000fe400000000ffULL,
0x000000444531723eULL, 0x000fe400000000ffULL, 0x0000ffff00037812ULL, 0x002fe400078ec0ffULL,
0xfffffff8ff057812ULL, 0x000fc400078ee200ULL, 0x00000003ff037819ULL, 0x000fe40000011603ULL,
0x0000001805087810ULL, 0x000fe20007ffe0ffULL, 0x0000000805067836ULL, 0x000fe20000000000ULL,
0x0000000303037812ULL, 0x000fe200078ec0ffULL, 0x0000001005077836ULL, 0x000fe20000000000ULL,
0x00000003050d7819ULL, 0x000fe200000006ffULL, 0x0000000806197824ULL, 0x000fe200078e00ffULL,
0x000000404132723eULL, 0x000fe200000000ffULL, 0x0000000103037824ULL, 0x000fe200078e0200ULL,
0x0000003c3d33723eULL, 0x000fe200000000ffULL, 0x0000000807237824ULL, 0x000fe200078e00ffULL,
0x000000383934723eULL, 0x000fe200000000ffULL, 0x00000008082b7824ULL, 0x000fe200078e00ffULL,
0x0000000703047812ULL, 0x040fe200078ec0ffULL, 0x0000000806067824ULL, 0x000fe200078e00ffULL,
0x0000000403037812ULL, 0x000fe200078e3cffULL, 0x00000008070a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee204ULL, 0x0000000808087824ULL, 0x000fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fc400078ee204ULL, 0xfffffff823237812ULL, 0x000fe200078ee204ULL,
0x000000100d0d7824ULL, 0x100fe200078e0214ULL, 0xfffffff82b2b7812ULL, 0x000fe400078ee204ULL,
0x0000000305047819ULL, 0x000fe200000006ffULL, 0x0000001023237824ULL, 0x100fe200078e0214ULL,
0x0000000703037812ULL, 0x000fe200078ec0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0214ULL,
0x000000646505723eULL, 0x000fe400000000ffULL, 0xfffffff8040f7812ULL, 0x000fc400078ee203ULL,
0xfffffff8061b7812ULL, 0x000fe400078ee203ULL, 0x000000686904723eULL, 0x000fe200000000ffULL,
0x000000100f0f7824ULL, 0x100fe200078e0214ULL, 0x000000787906723eULL, 0x000fe200000000ffULL,
0x000000101b1b7824ULL, 0x000fe200078e0214ULL, 0x000000747507723eULL, 0x000fe400000000ffULL,
0xfffffff80a257812ULL, 0x000fe400078ee203ULL, 0xfffffff808037812ULL, 0x000fe200078ee203ULL,
0x000000040d007844ULL, 0x0003e20000000200ULL, 0x000000585908723eULL, 0x000fc400000000ffULL,
0x00000050510a723eULL, 0x000fe200000000ffULL, 0x0000001003037824ULL, 0x000fe200078e0214ULL,
0x0000001419197211ULL, 0x000fe400078e20ffULL, 0x0000000e3535723eULL, 0x000fe200000000ffULL,
0x000000080f007844ULL, 0x0005e20000000200ULL, 0x0000001c1e36723eULL, 0x000fe400000000ffULL,
0x0000002a5c37723eULL, 0x000fe200000000ffULL, 0x0000001019007844ULL, 0x000fe20000000200ULL,
0x0000001425257211ULL, 0x000fc400078e20ffULL, 0x000000012600780cULL, 0x000fe20003f05270ULL,
0x00000001170d7824ULL, 0x002fe200078e0200ULL, 0x0000004a4b04723eULL, 0x000fe200000000ffULL,
0x0000002c1b007844ULL, 0x000fe20000000200ULL, 0x000000464705723eULL, 0x000fe400000000ffULL,
0x000000424306723eULL, 0x000fe200000000ffULL, 0x0000003023007844ULL, 0x000fe20000000200ULL,
0x0000003e3f07723eULL, 0x000fe400000000ffULL, 0x0000003a3b08723eULL, 0x004fe200000000ffULL,
0x0000003425007844ULL, 0x000fe20000000200ULL, 0x0000005d1609723eULL, 0x000fc400000000ffULL,
0x0000005f280a723eULL, 0x000fe200000000ffULL, 0x000000042b007844ULL, 0x000fe20000000200ULL,
0x000000615e0b723eULL, 0x000fe400000000ffULL, 0x0000001d0d0e7211ULL, 0x000fc600078e20ffULL,
0x0000000803007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000e107984ULL, 0x000e680000000c00ULL, 0x000400000e387984ULL, 0x000ea80000000c00ULL,
0x000800000e407984ULL, 0x000ee80000000c00ULL, 0x000c00000e347984ULL, 0x000f280000000c00ULL,
0x001000000e2c7984ULL, 0x000f680000000c00ULL, 0x001400000e3c7984ULL, 0x000f280000000c00ULL,
0x001800000e307984ULL, 0x000f280000000c00ULL, 0x001c00000e047984ULL, 0x000f620000000c00ULL,
0x200000ff13137230ULL, 0x002fc40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fe40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x200000ff3b3b7230ULL, 0x004fe40000000000ULL, 0x200000ff3a3a7230ULL, 0x000fe40000000000ULL,
0x200000ff39397230ULL, 0x000fc40000000000ULL, 0x200000ff38387230ULL, 0x000fe40000000000ULL,
0x200000ff43437230ULL, 0x008fe40000000000ULL, 0x200000ff42427230ULL, 0x000fe40000000000ULL,
0x200000ff41417230ULL, 0x000fe40000000000ULL, 0x200000ff40407230ULL, 0x000fe40000000000ULL,
0x200000ff37377230ULL, 0x010fc40000000000ULL, 0x200000ff36367230ULL, 0x000fe40000000000ULL,
0x200000ff35357230ULL, 0x000fe40000000000ULL, 0x200000ff34347230ULL, 0x000fe40000000000ULL,
0x0000002f13137230ULL, 0x020fe40000000000ULL, 0x0000002e12127230ULL, 0x000fe40000000000ULL,
0x0000002d11117230ULL, 0x000fc40000000000ULL, 0x0000002c10107230ULL, 0x000fe40000000000ULL,
0x0000003f3b3b7230ULL, 0x000fe40000000000ULL, 0x0000003e3a3a7230ULL, 0x000fe20000000000ULL,
0x000000100e007388ULL, 0x0003e20000000c00ULL, 0x0000003d39397230ULL, 0x000fe40000000000ULL,
0x0000003c38387230ULL, 0x000fe40000000000ULL, 0x0000003343437230ULL, 0x000fc40000000000ULL,
0x0000003242427230ULL, 0x000fe20000000000ULL, 0x000400380e007388ULL, 0x0003e20000000c00ULL,
0x0000003141417230ULL, 0x000fe40000000000ULL, 0x0000003040407230ULL, 0x000fe40000000000ULL,
0x0000000737377230ULL, 0x000fe40000000000ULL, 0x0000000636367230ULL, 0x000fe20000000000ULL,
0x000800400e007388ULL, 0x0003e20000000c00ULL, 0x0000000535357230ULL, 0x000fc40000000000ULL,
0x0000000434347230ULL, 0x000fca0000000000ULL, 0x000c00340e007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000003400588947ULL, 0x000fea0003800000ULL,
0x00000400ff117b82ULL, 0x002e620000000800ULL, 0x0000000000087919ULL, 0x000ea20000002600ULL,
0x000000400d077836ULL, 0x000fe20000000000ULL, 0x000000c00d0b7810ULL, 0x000fe20007ffe0ffULL,
0x000000800d097836ULL, 0x000fe20000000000ULL, 0x0000000000057919ULL, 0x000ea60000002700ULL,
0x00009600ff047b82ULL, 0x000e620000000800ULL, 0x000000000e2c7984ULL, 0x0006e80000000c00ULL,
0x000400000e307984ULL, 0x0006e60000000c00ULL, 0x00009a00ff2a7b82ULL, 0x000f220000000a00ULL,
0x000800000e347984ULL, 0x0006e80000000c00ULL, 0x000c00000e387984ULL, 0x0006e20000000c00ULL,
0x0000000411037224ULL, 0x002fc800078e02ffULL, 0x0000002603067224ULL, 0x040fe200078e02ffULL,
0x0000000f03047811ULL, 0x000fe200078e10ffULL, 0x0000001105117224ULL, 0x004fc600078e0208ULL,
0xfffffff004137812ULL, 0x000fe200078ec0ffULL, 0x0000002611197224ULL, 0x000fc800078e02ffULL,
0x0000008006237824ULL, 0x000fe200078e0213ULL, 0x00000002190a7210ULL, 0x000fc60007ffe0ffULL,
0x0000008006067824ULL, 0x000fc800078e0223ULL, 0x0000007f06067836ULL, 0x000fca0000000000ULL,
0xffffff8006257812ULL, 0x000fc800078ec0ffULL, 0x0000002a25037210ULL, 0x010fc80007f1e0ffULL,
0x000000030a027211ULL, 0x000fe200078268ffULL, 0x000000ffff037224ULL, 0x000fe200000e062bULL,
0x0000000118ff7812ULL, 0x000fc8000780f822ULL, 0x000000030a037211ULL, 0x000fe400008f6cffULL,
0x0000002a13127210ULL, 0x000fe20007f3e0ffULL, 0x0000100015027825ULL, 0x000fc800078e0002ULL,
0x000000100d047825ULL, 0x000fc800078e0002ULL, 0x0000001007067825ULL, 0x000fc800078e0002ULL,
0x0000001009087825ULL, 0x000fc800078e0002ULL, 0x000000100b027825ULL, 0x000fc800078e0002ULL,
0x000000ffff0d7224ULL, 0x000fe200008e062bULL, 0x0000000000400947ULL, 0x008fec0003800000ULL,
0x00000010000e7824ULL, 0x000fe200078e00ffULL, 0x00000001ff107819ULL, 0x000fe20000011600ULL,
0x000000800a0b7824ULL, 0x000fc600078e00ffULL, 0x000000700e0f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c10167812ULL, 0x000fe400078ec0ffULL, 0x0000002a0b0e7210ULL, 0x000fe40007ebe023ULL,
0x00000019ff107819ULL, 0x000fe4000001160aULL, 0x000000120f0b7210ULL, 0x000fe40007a3e00bULL,
0x0000000e160e7210ULL, 0x000fc40007c7e00fULL, 0x0000002b100f7210ULL, 0x000fe40002fec4ffULL,
0x0000000b160a7210ULL, 0x000fe40007fbe0ffULL, 0x0000000dff107210ULL, 0x000fe40000fe4410ULL,
0x0000000fff0f7210ULL, 0x000fe40001fe84ffULL, 0x00000010ff0b7210ULL, 0x000fca0002ffe4ffULL,
0x000000290a007986ULL, 0x0003e8000c101906ULL, 0x000000270e007986ULL, 0x0003e4000c101906ULL,
0x000000ff0000720cULL, 0x000fe20000705670ULL, 0x0000002c04007986ULL, 0x0005e8000c101d06ULL,
0x0000003006007986ULL, 0x0005e8000c101d06ULL, 0x0000003408007986ULL, 0x0005e8000c101d06ULL,
0x0000003802007986ULL, 0x0005e2000c101d06ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000000700947ULL, 0x000fea0003800000ULL, 0x00009a00ff027b82ULL, 0x004ea20000000a00ULL,
0xffffffff26057836ULL, 0x000fe40000000000ULL, 0x0000000411027825ULL, 0x004fe200078e0002ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000005020279a8ULL, 0x00052200099ee1c6ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000050200720cULL, 0x010fc80003f05270ULL,
0x00000001ff027807ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x008fd20008000004ULL,
0x00000002ff007988ULL, 0x0007e60008000004ULL, 0x0000000000027919ULL, 0x00cea20000008800ULL,
0x00000400001b7802ULL, 0x000fe20000000f00ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000654021b7816ULL, 0x004fca000000001bULL,
0x000000001b027984ULL, 0x000ea40000000000ULL, 0x000000ff0200720cULL, 0x004fda0003f05270ULL,
0x0000002c00dc8947ULL, 0x000fea0003800000ULL, 0x000000ff2200720cULL, 0x000fda0003f05270ULL,
0x0000000800940947ULL, 0x000fea0003800000ULL, 0x000000ff2600720cULL, 0x000fda0003f05270ULL,
0x00000000006c8947ULL, 0x000fea0003800000ULL, 0x0000001000037824ULL, 0x000fe200078e00ffULL,
0x00000001ff047819ULL, 0x000fe40000011600ULL, 0x0000001219027211ULL, 0x000fe400078038ffULL,
0x0000007003057812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fe400078ec0ffULL,
0x0000000d19037211ULL, 0x000fe400000f3cffULL, 0x0000000204027210ULL, 0x000fc8000791e005ULL,
0x00000003ff037210ULL, 0x000fca00007e24ffULL, 0x0000000602067981ULL, 0x000528000c1e1900ULL,
0x0000800602077981ULL, 0x000522000c1e1900ULL, 0x000000022600780cULL, 0x000fda0003f05270ULL,
0x00000000003c8947ULL, 0x004fea0003800000ULL, 0x0001000602097981ULL, 0x000522000c1e1900ULL,
0x000000042600780cULL, 0x000fda0003f06070ULL, 0x0000000000308947ULL, 0x004fea0003800000ULL,
0x00018006020b7981ULL, 0x002322000c1e1900ULL, 0x000000042600780cULL, 0x000fda0003f05270ULL,
0x0000000000248947ULL, 0x002fea0003800000ULL, 0x00020006020d7981ULL, 0x000322000c1e1900ULL,
0x000000062600780cULL, 0x000fda0003f06070ULL, 0x0000000000188947ULL, 0x002fea0003800000ULL,
0x00028006020f7981ULL, 0x000322000c1e1900ULL, 0x000000062600780cULL, 0x000fda0003f05270ULL,
0x00000000000c8947ULL, 0x002fea0003800000ULL, 0x000000082600780cULL, 0x000fe20003f06070ULL,
0x0003000602117981ULL, 0x000318000c1e1900ULL, 0x0003800602270981ULL, 0x000324000c1e1900ULL,
0x0000000726027836ULL, 0x002fca0000000000ULL, 0x00000003ff047819ULL, 0x000fc80000011602ULL,
0x000000ff0400720cULL, 0x000fda0003f05270ULL, 0x0000000400f48947ULL, 0x000fea0003800000ULL,
0x0000001319297211ULL, 0x040fe200078038ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x0000000600057202ULL, 0x010fe20000000f00ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x0000002a29297210ULL, 0x000fe40007f3e0ffULL, 0x000000ff19087211ULL, 0x000fe400000f3cffULL,
0x0000078029297810ULL, 0x000fc80007f5e0ffULL, 0x00000008ff087210ULL, 0x000fd200017e242bULL,
0x0000000426007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x0000000504007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400b41947ULL, 0x012fee0003800000ULL,
0x0000000804087890ULL, 0x000fe2000fffe03fULL, 0x0000000506067209ULL, 0x000fca0007810000ULL,
0x0000000826007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000229027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0608ULL,
0xfffc800602057981ULL, 0x000326000c1e1900ULL, 0x0000000104087890ULL, 0x000fcc000fffe03fULL,
0x0000000826007c0cULL, 0x000fda000bf23070ULL, 0x00000004007c1947ULL, 0x000fea0003800000ULL,
0x0000000904087890ULL, 0x000fe2000fffe03fULL, 0x0000000706067209ULL, 0x000fca0007810000ULL,
0x0000000826007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000229027210ULL, 0x000fc80007f3e0ffULL, 0x00000008ff037210ULL, 0x000fca0000ffe4ffULL,
0xfffd000602077981ULL, 0x000328000c1e1900ULL, 0x0000000204087890ULL, 0x000fcc000fffe03fULL,
0x0000000826007c0cULL, 0x000fda000bf23070ULL, 0x0000000400441947ULL, 0x000fea0003800000ULL,
0x0000000a04087890ULL, 0x000fe2000fffe03fULL, 0x0000000906067209ULL, 0x000fca0007810000ULL,
0x0000000826007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000229027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0608ULL,
0xfffd800602097981ULL, 0x000326000c1e1900ULL, 0x0000000304087890ULL, 0x000fcc000fffe03fULL,
0x0000000826007c0cULL, 0x000fda000bf23070ULL, 0x00000004000c1947ULL, 0x000fea0003800000ULL,
0x0000000b04087890ULL, 0x000fe2000fffe03fULL, 0x0000000b06067209ULL, 0x000fca0007810000ULL,
0x0000000826007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000229027210ULL, 0x000fc80007f3e0ffULL, 0x00000008ff037210ULL, 0x000fca0000ffe4ffULL,
0xfffe0006020b7981ULL, 0x000328000c1e1900ULL, 0x0000000404087890ULL, 0x000fcc000fffe03fULL,
0x0000000826007c0cULL, 0x000fda000bf23070ULL, 0x0000000000d41947ULL, 0x000fea0003800000ULL,
0x0000000c04087890ULL, 0x000fe2000fffe03fULL, 0x0000000d06067209ULL, 0x000fca0007810000ULL,
0x0000000826007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000229027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0608ULL,
0xfffe8006020d7981ULL, 0x000326000c1e1900ULL, 0x0000000504087890ULL, 0x000fcc000fffe03fULL,
0x0000000826007c0cULL, 0x000fda000bf23070ULL, 0x00000000009c1947ULL, 0x000fea0003800000ULL,
0x0000000d04087890ULL, 0x000fe2000fffe03fULL, 0x0000000f06067209ULL, 0x000fca0007810000ULL,
0x0000000826007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000229027210ULL, 0x000fc80007f3e0ffULL, 0x00000008ff037210ULL, 0x000fca0000ffe4ffULL,
0xffff0006020f7981ULL, 0x000328000c1e1900ULL, 0x0000000604087890ULL, 0x000fcc000fffe03fULL,
0x0000000826007c0cULL, 0x000fda000bf23070ULL, 0x0000000000641947ULL, 0x000fea0003800000ULL,
0x0000000e04087890ULL, 0x000fe2000fffe03fULL, 0x0000001106067209ULL, 0x000fca0007810000ULL,
0x0000000826007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000229027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e0608ULL,
0xffff800602117981ULL, 0x000326000c1e1900ULL, 0x0000000704087890ULL, 0x000fcc000fffe03fULL,
0x0000000826007c0cULL, 0x000fda000bf23070ULL, 0x00000000002c1947ULL, 0x000fea0003800000ULL,
0x0000000f04087890ULL, 0x000fe2000fffe03fULL, 0x0000002706067209ULL, 0x000fca0007810000ULL,
0x0000000826007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000229027210ULL, 0x000fc80007f3e0ffULL, 0x00000008ff037210ULL, 0x000fca0000ffe4ffULL,
0x0000000602277981ULL, 0x000328000c1e1900ULL, 0x0000040029297810ULL, 0x000fe20007f3e0ffULL,
0x0000000804047890ULL, 0x000fc8000fffe03fULL, 0x000000ffff087224ULL, 0x000fe200008e0608ULL,
0xfffffff8002c8947ULL, 0x000fee000383ffffULL, 0x0000000000007919ULL, 0x000ea40000000000ULL,
0x0000001000027824ULL, 0x006fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc80000011600ULL,
0x0000007002027812ULL, 0x000fe400078ec0ffULL, 0x0000000c03037812ULL, 0x000fc800078ec0ffULL,
0x0000001b03037210ULL, 0x000fca0007ffe002ULL, 0x0000000603007388ULL, 0x0103e40000000800ULL,
0x00009a00ff287b82ULL, 0x002e620000000a00ULL, 0x000000070000780cULL, 0x000fe20003f04070ULL,
0x00000001182b7824ULL, 0x040fe200078e0219ULL, 0x0000000118067812ULL, 0x040fe200078ec0ffULL,
0x00004000181e7824ULL, 0x100fe200078e021bULL, 0x0000000c15167819ULL, 0x040fe200000006ffULL,
0x0000001000227824ULL, 0x000fe200078e00ffULL, 0x00000040000b7810ULL, 0x000fe20007ffe0ffULL,
0x00002000151e7824ULL, 0x040fe200078e021eULL, 0x000000a000117810ULL, 0x000fe20007ffe0ffULL,
0x00000060000d7836ULL, 0x000fe20000000000ULL, 0x0000007022227812ULL, 0x000fe200078ec0ffULL,
0x00000080000f7836ULL, 0x000fe20000000000ULL, 0x0000000000707805ULL, 0x000fe2000001ff00ULL,
0x0000020018048824ULL, 0x140fe200078e021bULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000020018088824ULL, 0x000fe200078e021bULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000010015078824ULL, 0x040fe200078e0204ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000010015098824ULL, 0x000fe200078e0208ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000080062f8824ULL, 0x000fe200078e0207ULL, 0x000010000c077812ULL, 0x000fe200078ec0ffULL,
0x0000008006318824ULL, 0x000fe200078e0209ULL, 0x0000002825027210ULL, 0x002fe20007f3e0ffULL,
0x0000002000097836ULL, 0x000fe20000000000ULL, 0x00000028131c7210ULL, 0x000fe20007f7e0ffULL,
0x000000011e077824ULL, 0x000fe200078e0207ULL, 0x00000029ff037210ULL, 0x000fe20000ffe4ffULL,
0x000000c000137836ULL, 0x000fe20000000000ULL, 0x00000028231a7210ULL, 0x000fe20007f3e0ffULL,
0x000000e000257836ULL, 0x000fe20000000000ULL, 0x00000001ff237819ULL, 0x000fe20000011600ULL,
0x000020002b047825ULL, 0x000fe200078e0002ULL, 0x00000007002d7211ULL, 0x000fc400078e20ffULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000000c23237812ULL, 0x000fe200078ec0ffULL,
0x000000ffff277224ULL, 0x100fe200008e0629ULL, 0x0000001604047210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff307224ULL, 0x000fe200018e0629ULL, 0x0000001a2b288211ULL, 0x000fe200078238ffULL,
0x00000010002f8824ULL, 0x000fe200078e022fULL, 0x00000005ff057210ULL, 0x000fe400017fe4ffULL,
0x00000000003c7805ULL, 0x000fc4000001ff00ULL, 0x0000001b232c7210ULL, 0x000fe40007ffe022ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x0000001c2b2a8211ULL, 0x000fe200078438ffULL,
0x0000001009067825ULL, 0x100fe200078e0004ULL, 0x000000272b298211ULL, 0x000fe400008f3cffULL,
0x0000000000407805ULL, 0x000fe4000001ff00ULL, 0x000000261800720cULL, 0x000fe20003f26070ULL,
0x000000100b087825ULL, 0x000fe200078e0004ULL, 0x000000302b2b8211ULL, 0x000fc400010f3cffULL,
0x00000000006c7805ULL, 0x000fe4000001ff00ULL, 0x0000003100318211ULL, 0x000fe200078e20ffULL,
0x000000100d0a7825ULL, 0x100fe200078e0004ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x000000100f0c7825ULL, 0x000fe200078e0004ULL, 0x0000000000487805ULL, 0x000fc4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000010110e7825ULL, 0x100fe200078e0004ULL, 0x00000000004e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000527805ULL, 0x000fe4000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000001013107825ULL, 0x000fe200078e0004ULL, 0x0000000000547805ULL, 0x000fc4000001ff00ULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000001025127825ULL, 0x100fe200078e0004ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000001000047825ULL, 0x000fe200078e0004ULL, 0x00000000006e7805ULL, 0x000fe2000001ff00ULL,
0x000000002c257984ULL, 0x0002620000000800ULL, 0x00000000005a7805ULL, 0x000fc4000001ff00ULL,
0x00000000005c7805ULL, 0x000fe4000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000042d7faeULL, 0x0005e2000b901c46ULL,
0x0000000000607805ULL, 0x000fe4000001ff00ULL, 0x0000000000627805ULL, 0x000fe4000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x00380000062d7faeULL, 0x0007e2000b901c46ULL,
0x0000000000667805ULL, 0x000fc4000001ff00ULL, 0x0000000000687805ULL, 0x000fe4000001ff00ULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x00580000082d7faeULL, 0x000fe8000b901c46ULL,
0x007800000a2d7faeULL, 0x000fe2000b901c46ULL, 0x0000001000048825ULL, 0x004fc600078e0028ULL,
0x009800000c2d7faeULL, 0x000fe2000b901c46ULL, 0x0000001000068825ULL, 0x008fc600078e002aULL,
0x00b800000e2d7faeULL, 0x000fe8000b901c46ULL, 0x00d80000102d7faeULL, 0x000fe8000b901c46ULL,
0x00f80000122d7faeULL, 0x000fe8000b901c46ULL, 0x08580000042f8faeULL, 0x000fe8000b901c46ULL,
0x0818000006318faeULL, 0x0005e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000ffff317224ULL, 0x004fe200078e00ffULL, 0x0000000c00f81947ULL, 0x002fec0003800000ULL,
0x00000003ff077819ULL, 0x100fe20000011600ULL, 0x000000ffff717224ULL, 0x000fe200078e00ffULL,
0xfffffff8ff067812ULL, 0x000fe400078ee200ULL, 0x0000000307057812ULL, 0x000fe400078ec0ffULL,
0x0000000400047810ULL, 0x000fe20007ffe007ULL, 0x0000000806077836ULL, 0x000fe20000000000ULL,
0x0000001006087810ULL, 0x000fe20007ffe0ffULL, 0x0000001806097836ULL, 0x000fe20000000000ULL,
0x0000000704047812ULL, 0x000fe200078ec0ffULL, 0x0000000806737824ULL, 0x000fe200078e00ffULL,
0x00000003080d7819ULL, 0x000fe200000006ffULL, 0x00000008070b7824ULL, 0x000fe200078e00ffULL,
0x00000002ff7c7819ULL, 0x100fe20000011600ULL, 0x0000000809757824ULL, 0x000fe200078e00ffULL,
0xfffffff873737812ULL, 0x000fe200078ee204ULL, 0x0000000105057824ULL, 0x000fe200078e0200ULL,
0xfffffff80b727812ULL, 0x000fe200078ee204ULL, 0x0000000807767824ULL, 0x000fe200078e00ffULL,
0xfffffff80d747812ULL, 0x000fe200078ee204ULL, 0x0000000806067824ULL, 0x000fe200078e00ffULL,
0xfffffff875757812ULL, 0x000fe200078ee204ULL, 0x00000008097a7824ULL, 0x000fe200078e00ffULL,
0x0000000705057812ULL, 0x000fe200078ec0ffULL, 0x0000020018047824ULL, 0x000fe200078e021bULL,
0x0000000308787819ULL, 0x000fe200000006ffULL, 0x000000087c7e7836ULL, 0x000fe20000000000ULL,
0xfffffff876767812ULL, 0x000fe200078ee205ULL, 0x00000100157d7824ULL, 0x000fe200078e0204ULL,
0xfffffff806777812ULL, 0x000fe200078ee205ULL, 0x000000107c7f7836ULL, 0x000fe20000000000ULL,
0xfffffff878787812ULL, 0x000fc400078ee205ULL, 0xfffffff87a7a7812ULL, 0x000fe400078ee205ULL,
0x00000018007b7202ULL, 0x000fe40000000f00ULL, 0x000000187c797810ULL, 0x000fce0007ffe0ffULL,
0x000000017b067836ULL, 0x000fca0000000000ULL, 0x000000260600720cULL, 0x000fda0003f06070ULL,
0x0000000000c80947ULL, 0x000fea0003800000ULL, 0x000000070000780cULL, 0x000fe20003f44070ULL,
0x00000001192b7824ULL, 0x000fe200078e0206ULL, 0x00000001062c7812ULL, 0x040fe200078ec0ffULL,
0x0000100006067824ULL, 0x000fe200078e00ffULL, 0x0000002000097810ULL, 0x000fe20007ffe0ffULL,
0x000020002b047825ULL, 0x000fc600078e0002ULL, 0x0000100006077812ULL, 0x000fe200078ec0ffULL,
0x00000040000b7836ULL, 0x000fe20000000000ULL, 0x0000001604047210ULL, 0x000fe20007f1e0ffULL,
0x00000060000d7836ULL, 0x000fe20000000000ULL, 0x000000071e077210ULL, 0x000fe20007ffe0ffULL,
0x000002001808a824ULL, 0x000fe200078e021bULL, 0x0000001c2b2aa211ULL, 0x000fe200078238ffULL,
0x000000ffff057224ULL, 0x000fe200000e0605ULL, 0x00000007002d7211ULL, 0x000fe200078e20ffULL,
0x00000080000f7836ULL, 0x000fe20000000000ULL, 0x00000008157da211ULL, 0x000fe200078e40ffULL,
0x000000a000117836ULL, 0x000fe20000000000ULL, 0x0000001a2b28a211ULL, 0x000fe200078038ffULL,
0x000000c000137836ULL, 0x000fc40000000000ULL, 0x000000e000297836ULL, 0x000fe40000000000ULL,
0x0000001000067825ULL, 0x000fc800078e0004ULL, 0x0000001009087825ULL, 0x100fe200078e0004ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000062d7faeULL, 0x0003e6000b901c46ULL,
0x000000100b0a7825ULL, 0x100fe200078e0004ULL, 0x00380000082d7faeULL, 0x0003e6000b901c46ULL,
0x000000100d0c7825ULL, 0x100fe200078e0004ULL, 0x005800000a2d7faeULL, 0x0003e6000b901c46ULL,
0x000000100f0e7825ULL, 0x100fe200078e0004ULL, 0x007800000c2d7faeULL, 0x0003e6000b901c46ULL,
0x0000001011107825ULL, 0x100fe200078e0004ULL, 0x009800000e2d7faeULL, 0x0003e6000b901c46ULL,
0x0000001013127825ULL, 0x100fe200078e0004ULL, 0x00b80000102d7faeULL, 0x0003e6000b901c46ULL,
0x0000001029047825ULL, 0x000fe200078e0004ULL, 0x000000272b29a211ULL, 0x040fe200000f3cffULL,
0x00d80000122d7faeULL, 0x0003e2000b901c46ULL, 0x000000302b2ba211ULL, 0x000fe200008f3cffULL,
0x000000802c2fa824ULL, 0x000fc400078e027dULL, 0x000000802c81a824ULL, 0x000fe200078e027dULL,
0x00f80000042d7faeULL, 0x0003e2000b901c46ULL, 0x000000100028a825ULL, 0x000fc800078e0028ULL,
0x00000010002fa824ULL, 0x040fe400078e022fULL, 0x00000010002aa825ULL, 0x000fc600078e002aULL,
0x08580000282fafaeULL, 0x0003e2000b901c46ULL, 0x000000100081a824ULL, 0x000fca00078e0281ULL,
0x081800002a81afaeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000c7b047819ULL, 0x002fc800000006ffULL, 0x0000100004057812ULL, 0x000fe200078ec0ffULL,
0x000000807b047824ULL, 0x000fe400078e00ffULL, 0x000000027b7b7836ULL, 0x000fe20000000000ULL,
0x000001801e2d7810ULL, 0x000fe40007ffe005ULL, 0x0000008004047812ULL, 0x000fe400078ec0ffULL,
0x0000002d74807211ULL, 0x000fe200078e20ffULL, 0x0000001073107824ULL, 0x100fe200078e022dULL,
0x0000007d22047210ULL, 0x000fe20007ffe004ULL, 0x0000001077287824ULL, 0x100fe200078e022dULL,
0x000000267b00720cULL, 0x000fe20003f06070ULL, 0x0000001075817824ULL, 0x100fe200078e022dULL,
0x00000004232e7210ULL, 0x000fe20007ffe0ffULL, 0x0000001076047824ULL, 0x000fc400078e022dULL,
0x0000001072087824ULL, 0x000fe200078e022dULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x00000010780c7824ULL, 0x100fe400078e022dULL,
0x000000107a2c7824ULL, 0x000fe200078e022dULL, 0x008180002e907984ULL, 0x000ea80000000800ULL,
0x000000002828783bULL, 0x000ee80000000200ULL, 0x008580002e9a7984ULL, 0x000f280000000800ULL,
0x000000000404783bULL, 0x000f680000000200ULL, 0x000000000808783bULL, 0x000f280000000200ULL,
0x000000000c0c783bULL, 0x000f280000000200ULL, 0x000000002c2c783bULL, 0x000fe20000000200ULL,
0x20000010ff897230ULL, 0x002fc40000004100ULL, 0x30000010ff8c7230ULL, 0x000fe40000004100ULL,
0x0000009025107221ULL, 0x004fe20000010100ULL, 0x20000011ff8b7230ULL, 0x000fe40000004100ULL,
0x30000011ff8e7230ULL, 0x000fe40000004100ULL, 0x3fb8aa3b10977820ULL, 0x000fe20000410000ULL,
0x20000028ff827230ULL, 0x008fe40000004100ULL, 0x30000028ff847230ULL, 0x000fe20000004100ULL,
0x0000009700997308ULL, 0x000f220000000800ULL, 0x20000029ff837230ULL, 0x000fc40000004100ULL,
0x30000029ff867230ULL, 0x000fe40000004100ULL, 0x2000002aff857230ULL, 0x000fe40000004100ULL,
0x3000002aff887230ULL, 0x000fe40000004100ULL, 0x2000002bff877230ULL, 0x000fe40000004100ULL,
0x3000002bff8a7230ULL, 0x000fe40000004100ULL, 0x000000008028783bULL, 0x0003e20000000200ULL,
0x20000012ff8d7230ULL, 0x000fc40000004100ULL, 0x0000009a99a97220ULL, 0x010fe20000410000ULL,
0x30000012ff907230ULL, 0x000fe40000004100ULL, 0x20000013ff8f7230ULL, 0x000fe40000004100ULL,
0x00000070a9707221ULL, 0x000fe20000010000ULL, 0x00001f7ca9aa7589ULL, 0x000ea200000e0000ULL,
0x30000013ff807230ULL, 0x002fe40000004100ULL, 0x20000007ff957230ULL, 0x020fe20000004100ULL,
0x000000008110783bULL, 0x0002e20000000200ULL, 0x30000007ff947230ULL, 0x000fc40000004100ULL,
0x20000008ff077230ULL, 0x000fe20000004100ULL, 0x00001f7ea9ab7589ULL, 0x000f2200000e0000ULL,
0x2000000fff9b7230ULL, 0x000fe40000004100ULL, 0x3000000fff9c7230ULL, 0x000fe40000004100ULL,
0x30000008ff817230ULL, 0x002fe40000004100ULL, 0x20000005ff937230ULL, 0x000fe40000004100ULL,
0x30000005ff927230ULL, 0x000fc40000004100ULL, 0x20000009ff087230ULL, 0x000fe40000004100ULL,
0x30000009ff967230ULL, 0x000fe40000004100ULL, 0x2000000bff977230ULL, 0x000fe40000004100ULL,
0x000000aa826d7223ULL, 0x084fe2000001006dULL, 0x3000000bff987230ULL, 0x000fe40000004100ULL,
0x000000aa846b7223ULL, 0x000fe2000001006bULL, 0x2000000dff997230ULL, 0x000fc40000004100ULL,
0x000000aa836a7223ULL, 0x080fe2000001006aULL, 0x3000000dff9a7230ULL, 0x000fe40000004100ULL,
0x000000aa86677223ULL, 0x080fe20000010067ULL, 0x2000002dffa17230ULL, 0x000fe40000004100ULL,
0x000000aa85667223ULL, 0x080fe20000010066ULL, 0x20000028ff0f7230ULL, 0x000fe40000004100ULL,
0x000000aa88637223ULL, 0x000fe20000010063ULL, 0x30000028ff9d7230ULL, 0x000fc40000004100ULL,
0x000000aa87627223ULL, 0x080fe20000010062ULL, 0x2000002aff9e7230ULL, 0x000fe40000004100ULL,
0x000000aa8a5f7223ULL, 0x080fe2000001005fULL, 0x3000002aff9f7230ULL, 0x000fe40000004100ULL,
0x000000aa895e7223ULL, 0x080fe2000001005eULL, 0x3000002dffa27230ULL, 0x000fe40000004100ULL,
0x000000aa8c5b7223ULL, 0x000fe2000001005bULL, 0x20000004ff917230ULL, 0x000fc40000004100ULL,
0x000000aa8b5a7223ULL, 0x080fe2000001005aULL, 0x20000012ffa67230ULL, 0x008fe40000004100ULL,
0x000000aa8e6f7223ULL, 0x080fe2000001006fULL, 0x30000012ffa77230ULL, 0x000fe40000004100ULL,
0x000000aa8d587223ULL, 0x080fe20000010058ULL, 0x20000013ff127230ULL, 0x000fe40000004100ULL,
0x000000aa90557223ULL, 0x000fe20000010055ULL, 0x30000013ffa87230ULL, 0x000fc40000004100ULL,
0x000000aa8f547223ULL, 0x080fe20000010054ULL, 0x00001f7fa9137589ULL, 0x000e6200000e0000ULL,
0x20000010ffa47230ULL, 0x000fe40000004100ULL, 0x000000aa80517223ULL, 0x000fe20000010051ULL,
0x30000010ffa57230ULL, 0x000fe20000004100ULL, 0x00001f79a9a97589ULL, 0x000ea200000e0000ULL,
0x20000006ff057230ULL, 0x000fe40000004100ULL, 0x000000ab91507223ULL, 0x010fe20000010050ULL,
0x2000000aff097230ULL, 0x000fc40000004100ULL, 0x000000ab93687223ULL, 0x080fe20000010068ULL,
0x2000000cff0b7230ULL, 0x000fe40000004100ULL, 0x000000ab92657223ULL, 0x080fe20000010065ULL,
0x2000000eff0d7230ULL, 0x000fe40000004100ULL, 0x000000ab05647223ULL, 0x080fe20000010064ULL,
0x20000029ff287230ULL, 0x000fe40000004100ULL, 0x000000ab95607223ULL, 0x000fe20000010060ULL,
0x2000002bff2a7230ULL, 0x000fc40000004100ULL, 0x000000ab945d7223ULL, 0x080fe2000001005dULL,
0x2000002cffa07230ULL, 0x000fe40000004100ULL, 0x000000ab075c7223ULL, 0x080fe2000001005cULL,
0x2000002eff2d7230ULL, 0x000fe40000004100ULL, 0x000000ab816e7223ULL, 0x080fe2000001006eULL,
0x2000002fffa37230ULL, 0x000fe40000004100ULL, 0x000000ab08597223ULL, 0x000fe20000010059ULL,
0x20000011ff107230ULL, 0x000fc40000004100ULL, 0x000000ab96577223ULL, 0x080fe20000010057ULL,
0x30000004ff047230ULL, 0x000fe40000004100ULL, 0x000000ab09567223ULL, 0x080fe20000010056ULL,
0x30000006ff067230ULL, 0x000fe40000004100ULL, 0x000000ab97527223ULL, 0x080fe20000010052ULL,
0x3000000aff0a7230ULL, 0x000fe40000004100ULL, 0x000000ab04697223ULL, 0x000fe20000010069ULL,
0x3000000cff0c7230ULL, 0x000fc40000004100ULL, 0x000000ab06617223ULL, 0x080fe20000010061ULL,
0x3000000eff0e7230ULL, 0x000fe40000004100ULL, 0x000000ab0a537223ULL, 0x080fe20000010053ULL,
0x30000029ff297230ULL, 0x000fe40000004100ULL, 0x000000ab984f7223ULL, 0x000fe2000001004fULL,
0x3000002bff2b7230ULL, 0x000fe40000004100ULL, 0x000000130b4e7223ULL, 0x002fe2000001004eULL,
0x3000002cff2c7230ULL, 0x000fc40000004100ULL, 0x000000130c4d7223ULL, 0x080fe2000001004dULL,
0x3000002eff2e7230ULL, 0x000fe40000004100ULL, 0x00000013994c7223ULL, 0x080fe2000001004cULL,
0x3000002fff2f7230ULL, 0x000fe40000004100ULL, 0x000000139a497223ULL, 0x080fe20000010049ULL,
0x30000011ff117230ULL, 0x000fe40000004100ULL, 0x000000130d487223ULL, 0x080fe20000010048ULL,
0x000000130e457223ULL, 0x080fe20000010045ULL, 0x000000139b447223ULL, 0x080fe20000010044ULL,
0x000000139c417223ULL, 0x080fe20000010041ULL, 0x000000130f407223ULL, 0x080fe20000010040ULL,
0x000000139d3e7223ULL, 0x080fe2000001003eULL, 0x00000013283d7223ULL, 0x080fe2000001003dULL,
0x00000013293a7223ULL, 0x080fe2000001003aULL, 0x000000139e397223ULL, 0x080fe20000010039ULL,
0x000000139f367223ULL, 0x080fe20000010036ULL, 0x000000132a357223ULL, 0x080fe20000010035ULL,
0x000000132b327223ULL, 0x000fe20000010032ULL, 0x000000a9a0317223ULL, 0x084fe20000010031ULL,
0x000000a92c4b7223ULL, 0x080fe2000001004bULL, 0x000000a9a14a7223ULL, 0x080fe2000001004aULL,
0x000000a9a2477223ULL, 0x080fe20000010047ULL, 0x000000a92d467223ULL, 0x080fe20000010046ULL,
0x000000a92e437223ULL, 0x080fe20000010043ULL, 0x000000a9a3427223ULL, 0x080fe20000010042ULL,
0x000000a92f6c7223ULL, 0x080fe2000001006cULL, 0x000000a9a43f7223ULL, 0x080fe2000001003fULL,
0x000000a9a53c7223ULL, 0x080fe2000001003cULL, 0x000000a9103b7223ULL, 0x080fe2000001003bULL,
0x000000a911387223ULL, 0x080fe20000010038ULL, 0x000000a9a6377223ULL, 0x080fe20000010037ULL,
0x000000a9a7347223ULL, 0x080fe20000010034ULL, 0x000000a912337223ULL, 0x080fe20000010033ULL,
0x000000a9a8717223ULL, 0x000fe20000010071ULL, 0xfffffff000908947ULL, 0x000fec000383ffffULL,
0x0000000000007919ULL, 0x000e620000000000ULL, 0x000000ff1500720cULL, 0x000fe40003f05270ULL,
0x0000000400027819ULL, 0x002fe400000006ffULL, 0x00000001ff037819ULL, 0x000fe20000011600ULL,
0x000089801b007836ULL, 0x000fe20000000000ULL, 0x0000007002057812ULL, 0x000fe400078ec0ffULL,
0x0000000c03067812ULL, 0x000fca00078ec0ffULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x00000080181b7824ULL, 0x000fe400078e021bULL,
0x0000001002037824ULL, 0x002fe200078e00ffULL, 0x00000001ff047819ULL, 0x000fc80000011602ULL,
0x0000007003027812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ec0ffULL,
0x0000001b041b7210ULL, 0x000fca0007ffe002ULL, 0x008980701b007388ULL, 0x0003e40000000800ULL,
0x0000000006007210ULL, 0x000fe20007ffe005ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000000027984ULL, 0x000ea80000000800ULL, 0x0000800000037984ULL, 0x000ee20000000800ULL,
0x00000002ff027221ULL, 0x004fc80000010000ULL, 0x0000000302027221ULL, 0x008fca0000010000ULL,
0x0180000002037810ULL, 0x000fc80007ffe0ffULL, 0x7f80000003037812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000000000140947ULL, 0x000fea0003800000ULL, 0x000000ffff277224ULL, 0x000fe200078e0002ULL,
0x0000cac000047802ULL, 0x000fce0000000f00ULL, 0x000000b400e87944ULL, 0x002fea0003c00000ULL,
0x000000ffff037224ULL, 0x00cfe200078e0000ULL, 0x0000000000107947ULL, 0x000fec0003800000ULL,
0x0000000200037308ULL, 0x000ea40000001000ULL, 0xbf80000002007423ULL, 0x004fc80000000003ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003037223ULL, 0x000fce0000000003ULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x00000002ff027819ULL, 0x004fe40000011600ULL,
0x00000008000c7811ULL, 0x040fe400078ff0ffULL, 0x00000010000a7811ULL, 0x040fe200078ff0ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0203027589ULL, 0x000ea200000e0000ULL,
0x00000018001a7811ULL, 0x000fc400078ff0ffULL, 0xfffffff8ff1e7812ULL, 0x000fe200078ee200ULL,
0x00001f0c030c7589ULL, 0x000ee600000e0000ULL, 0x000000081e227810ULL, 0x000fe20007ffe0ffULL,
0x00001f0a03197589ULL, 0x000fe200000e0000ULL, 0x000000101e267836ULL, 0x000fe40000000000ULL,
0x000000181e277836ULL, 0x002fe20000000000ULL, 0x00001f1a031a7589ULL, 0x00032200000e0000ULL,
0x000000081e257824ULL, 0x000fe200078e00ffULL, 0x0000000322297819ULL, 0x000fe200000006ffULL,
0x00000008262d7824ULL, 0x000fe200078e00ffULL, 0x0000000322227819ULL, 0x000fe200000006ffULL,
0x000000081e1e7824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000006a02057220ULL, 0x044fe20000410000ULL, 0x0000006702067220ULL, 0x040fe20000410000ULL,
0x0000006d02047220ULL, 0x040fe20000410000ULL, 0x0000006b026b7220ULL, 0x000fe20000410000ULL,
0x000000500c507220ULL, 0x048fe20000410000ULL, 0x000000690c697220ULL, 0x040fe20000410000ULL,
0x000000680c0d7220ULL, 0x040fe20000410000ULL, 0x000000650c0e7220ULL, 0x040fe20000410000ULL,
0x000000640c647220ULL, 0x040fe20000410000ULL, 0x000000610c617220ULL, 0x040fe20000410000ULL,
0x000000600c0f7220ULL, 0x040fe20000410000ULL, 0x0000005d0c107220ULL, 0x040fe20000410000ULL,
0x0000005c0c5c7220ULL, 0x040fe20000410000ULL, 0x0000006e0c037220ULL, 0x042fe20000410000ULL,
0x000000590c117220ULL, 0x040fe20000410000ULL, 0x000000570c127220ULL, 0x040fe20000410000ULL,
0x000000560c567220ULL, 0x040fe20000410000ULL, 0x000000530c537220ULL, 0x040fe20000410000ULL,
0x000000520c137220ULL, 0x040fe20000410000ULL, 0x0000004f0c167220ULL, 0x000fe20000410000ULL,
0x0000ffff000c7812ULL, 0x000fe200078ec0ffULL, 0x0000004b1a1c7220ULL, 0x010fe20000410000ULL,
0x00000008274b7824ULL, 0x000fc400078e00ffULL, 0x0000006602667220ULL, 0x040fe20000410000ULL,
0x00000003ff0c7819ULL, 0x000fe2000001160cULL, 0x0000006302637220ULL, 0x040fe20000410000ULL,
0x0000006202077220ULL, 0x040fe20000410000ULL, 0x0000005f02087220ULL, 0x000fe20000410000ULL,
0x000000030c237812ULL, 0x000fe200078ec0ffULL, 0x0000005e025e7220ULL, 0x040fe20000410000ULL,
0x0000005b025b7220ULL, 0x040fe20000410000ULL, 0x0000005a02097220ULL, 0x040fe20000410000ULL,
0x0000006f020a7220ULL, 0x000fe20000410000ULL, 0x0000000123237824ULL, 0x000fc400078e0200ULL,
0x0000005802587220ULL, 0x040fe20000410000ULL, 0x0000005502557220ULL, 0x040fe20000410000ULL,
0x00000054020b7220ULL, 0x000fe20000410000ULL, 0x0000000826267824ULL, 0x000fe200078e00ffULL,
0x00000007230c7812ULL, 0x040fe200078ec0ffULL, 0x0000005102027220ULL, 0x000fe20000410000ULL,
0x0000000423237812ULL, 0x000fe200078e3cffULL, 0x0000004e194e7220ULL, 0x040fe20000410000ULL,
0xfffffff825257812ULL, 0x000fe200078ee20cULL, 0x0000004d194d7220ULL, 0x000fe20000410000ULL,
0x0000000723237812ULL, 0x000fe200078ec0ffULL, 0x0000004c194c7220ULL, 0x000fe20000410000ULL,
0xfffffff829297812ULL, 0x000fe200078ee20cULL, 0x0000001025257824ULL, 0x100fe200078e0214ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee20cULL, 0x0000004919497220ULL, 0x000fe20000410000ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee20cULL, 0x00000008270c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e277812ULL, 0x000fe200078ee223ULL, 0x0000004819487220ULL, 0x040fe20000410000ULL,
0x000000050605723eULL, 0x000fe200000000ffULL, 0x0000004519457220ULL, 0x000fe20000410000ULL,
0xfffffff8222b7812ULL, 0x000fe200078ee223ULL, 0x0000001027277824ULL, 0x100fe200078e0214ULL,
0xfffffff8262f7812ULL, 0x000fe200078ee223ULL, 0x0000004419447220ULL, 0x000fe20000410000ULL,
0x000000046b04723eULL, 0x000fe200000000ffULL, 0x0000004119417220ULL, 0x000fe20000410000ULL,
0x000000666306723eULL, 0x000fe200000000ffULL, 0x0000004019407220ULL, 0x040fe20000410000ULL,
0x000000070807723eULL, 0x000fe200000000ffULL, 0x0000003e191b7220ULL, 0x040fe20000410000ULL,
0x000000090a09723eULL, 0x000fe200000000ffULL, 0x0000003d193d7220ULL, 0x040fe20000410000ULL,
0xfffffff80c237812ULL, 0x000fe200078ee223ULL, 0x0000003a193a7220ULL, 0x000fe20000410000ULL,
0x0000005e5b08723eULL, 0x000fe200000000ffULL, 0x0000003919397220ULL, 0x000fe20000410000ULL,
0x00000058550a723eULL, 0x000fe200000000ffULL, 0x0000003619367220ULL, 0x040fe20000410000ULL,
0x0000000b020b723eULL, 0x000fe200000000ffULL, 0x0000003519357220ULL, 0x040fe20000410000ULL,
0x0000000d0e0d723eULL, 0x000fe200000000ffULL, 0x0000003219327220ULL, 0x000fe20000410000ULL,
0x00000050690c723eULL, 0x000fe200000000ffULL, 0x0000004a1a4a7220ULL, 0x040fe20000410000ULL,
0x00000064610e723eULL, 0x000fe200000000ffULL, 0x000000471a477220ULL, 0x000fe20000410000ULL,
0x0000000f100f723eULL, 0x000fe200000000ffULL, 0x000000311a317220ULL, 0x040fe20000410000ULL,
0x0000001429027211ULL, 0x000fe200078e20ffULL, 0x000000461a467220ULL, 0x040fe20000410000ULL,
0x000000431a437220ULL, 0x040fe20000410000ULL, 0x000000421a427220ULL, 0x040fe20000410000ULL,
0x0000006c1a197220ULL, 0x040fe20000410000ULL, 0x0000003f1a3f7220ULL, 0x040fe20000410000ULL,
0x0000003c1a3c7220ULL, 0x040fe20000410000ULL, 0x0000003b1a3b7220ULL, 0x040fe20000410000ULL,
0x000000381a387220ULL, 0x040fe20000410000ULL, 0x000000371a377220ULL, 0x040fe20000410000ULL,
0x000000341a347220ULL, 0x040fe20000410000ULL, 0x000000331a337220ULL, 0x040fe20000410000ULL,
0x0000000425007844ULL, 0x0003e20000000200ULL, 0x000000711a1a7220ULL, 0x000fe20000410000ULL,
0x0000005c0310723eULL, 0x000fe200000000ffULL, 0x000000102f1e7824ULL, 0x100fe200078e0214ULL,
0x000000111211723eULL, 0x000fe200000000ffULL, 0x0000000827007844ULL, 0x000fe20000000200ULL,
0x000000565312723eULL, 0x000fe200000000ffULL, 0x000000104b4b7824ULL, 0x100fe200078e0214ULL,
0x000000131613723eULL, 0x000fe200000000ffULL, 0x0000000c02007844ULL, 0x0005e20000000200ULL,
0x000000142b037211ULL, 0x000fe200078e20ffULL, 0x000000102d167824ULL, 0x100fe200078e0214ULL,
0x000000401b28723eULL, 0x000fe200000000ffULL, 0x0000001023237824ULL, 0x000fe200078e0214ULL,
0x0000003d3a29723eULL, 0x000fe200000000ffULL, 0x0000001003007844ULL, 0x000fe20000000200ULL,
0x0000004e4d04723eULL, 0x002fc400000000ffULL, 0x0000004c4905723eULL, 0x000fe400000000ffULL,
0x000000484506723eULL, 0x000fe400000000ffULL, 0x000000444107723eULL, 0x000fe400000000ffULL,
0x00000039362a723eULL, 0x000fe200000000ffULL, 0x0000000117027824ULL, 0x004fe200078e0200ULL,
0x00000035322b723eULL, 0x000fe200000000ffULL, 0x0000000416007844ULL, 0x000fe20000000200ULL,
0x0000004a4745723eULL, 0x000fc400000000ffULL, 0x000000311c44723eULL, 0x000fe200000000ffULL,
0x000000281e007844ULL, 0x000fe20000000200ULL, 0x000000464346723eULL, 0x000fe400000000ffULL,
0x000000421947723eULL, 0x000fe400000000ffULL, 0x0000003f3c30723eULL, 0x000fe400000000ffULL,
0x0000003b3831723eULL, 0x000fe200000000ffULL, 0x000000444b007844ULL, 0x000fe20000000200ULL,
0x000000373432723eULL, 0x000fc400000000ffULL, 0x000000331a33723eULL, 0x000fe400000000ffULL,
0x0000001d02027211ULL, 0x000fc600078e20ffULL, 0x0000003023007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000002087984ULL, 0x000e680000000c00ULL,
0x0004000002107984ULL, 0x000ea80000000c00ULL, 0x0008000002347984ULL, 0x000ee80000000c00ULL,
0x000c000002287984ULL, 0x000f280000000c00ULL, 0x00100000020c7984ULL, 0x000f680000000c00ULL,
0x00140000022c7984ULL, 0x000f280000000c00ULL, 0x0018000002047984ULL, 0x000f280000000c00ULL,
0x001c000002387984ULL, 0x000f620000000c00ULL, 0x200000ff0b0b7230ULL, 0x002fc40000000000ULL,
0x200000ff0a0a7230ULL, 0x000fe40000000000ULL, 0x200000ff09097230ULL, 0x000fe40000000000ULL,
0x200000ff08087230ULL, 0x000fe40000000000ULL, 0x200000ff13137230ULL, 0x004fe40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fc40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x200000ff37377230ULL, 0x008fe40000000000ULL,
0x200000ff36367230ULL, 0x000fe40000000000ULL, 0x200000ff35357230ULL, 0x000fe40000000000ULL,
0x200000ff34347230ULL, 0x000fe40000000000ULL, 0x200000ff2b2b7230ULL, 0x010fc40000000000ULL,
0x200000ff2a2a7230ULL, 0x000fe40000000000ULL, 0x200000ff29297230ULL, 0x000fe40000000000ULL,
0x200000ff28287230ULL, 0x000fe40000000000ULL, 0x0000000f0b0b7230ULL, 0x020fe40000000000ULL,
0x0000000e0a0a7230ULL, 0x000fe40000000000ULL, 0x0000000d09097230ULL, 0x000fc40000000000ULL,
0x0000000c08087230ULL, 0x000fe40000000000ULL, 0x0000002f13137230ULL, 0x000fe40000000000ULL,
0x0000002e12127230ULL, 0x000fe20000000000ULL, 0x0000000802007388ULL, 0x0003e20000000c00ULL,
0x0000002d11117230ULL, 0x000fe40000000000ULL, 0x0000002c10107230ULL, 0x000fe40000000000ULL,
0x0000000737377230ULL, 0x000fc40000000000ULL, 0x0000000636367230ULL, 0x000fe20000000000ULL,
0x0004001002007388ULL, 0x0003e20000000c00ULL, 0x0000000535357230ULL, 0x000fe40000000000ULL,
0x0000000434347230ULL, 0x000fe40000000000ULL, 0x0000003b2b2b7230ULL, 0x000fe40000000000ULL,
0x0000003a2a2a7230ULL, 0x000fe20000000000ULL, 0x0008003402007388ULL, 0x0003e20000000c00ULL,
0x0000003929297230ULL, 0x000fc40000000000ULL, 0x0000003828287230ULL, 0x000fca0000000000ULL,
0x000c002802007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff1800720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000ea20000002700ULL, 0x00000003ff037819ULL, 0x000fe20000011600ULL,
0x0000840000057ab9ULL, 0x000fc60000000800ULL, 0x000000210300720cULL, 0x000fe20003f06070ULL,
0x00000005040472a4ULL, 0x004fd8000f8e023fULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000103027824ULL, 0x002fe200078e0200ULL, 0x00008600000a7ab9ULL, 0x000fe20000000800ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x0000880000087ab9ULL, 0x000fe20000000a00ULL,
0x0000000a05057299ULL, 0x000fe2000800063fULL, 0x0000000702057812ULL, 0x000fe200078ec0ffULL,
0x0000002000077836ULL, 0x000fe20000000000ULL, 0x00000007000c7812ULL, 0x000fe400078ec0ffULL,
0x0ffffff805027812ULL, 0x000fca00078ef800ULL, 0x0000001002057824ULL, 0x000fe400078e021dULL,
0x0000002024027824ULL, 0x000fc600078e0203ULL, 0x0000000005087984ULL, 0x0002a40000000c00ULL,
0x0000000502047c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff037c19ULL, 0x000fe40008011602ULL,
0x000000041f027210ULL, 0x000fe20007ffe0ffULL, 0x0000000420047c24ULL, 0x000fe4000f8e02ffULL,
0x0000000815057824ULL, 0x002fe400078e020cULL, 0x0000002003037224ULL, 0x000fca00078e0202ULL,
0x0000000304037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x0000000803027c11ULL, 0x000fc8000f8040ffULL, 0x0000000903037c11ULL, 0x000fe400080f4406ULL,
0x00000003ff067819ULL, 0x000fe20000011607ULL, 0x0000001005027825ULL, 0x000fc600078e0002ULL,
0x000000210600720cULL, 0x000fe40003f06070ULL, 0x0000000802007986ULL, 0x0043f6000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000607027210ULL, 0x002fe20007ffe0ffULL,
0x0000002024067824ULL, 0x000fc600078e0206ULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000aff037c19ULL, 0x000fe40008011606ULL, 0x0ffffff802027812ULL, 0x000fca00078ef807ULL,
0x0000001002057824ULL, 0x000fe200078e021dULL, 0x0000000506027c12ULL, 0x000fe4000f8e30ffULL,
0x0000000707067812ULL, 0x000fe200078ec0ffULL, 0x0000004000077836ULL, 0x000fe20000000000ULL,
0x0000000005087984ULL, 0x0002a20000000c00ULL, 0x000000011f027824ULL, 0x000fc800078e0202ULL,
0x0000002003037224ULL, 0x000fe400078e0202ULL, 0x0000000815057824ULL, 0x002fe200078e0206ULL,
0x00000003ff067819ULL, 0x000fe40000011607ULL, 0x0000000304037210ULL, 0x000fc80007f1e0ffULL,
0x000000ffff0c7210ULL, 0x000fe400007fe4ffULL, 0x0000000803027c11ULL, 0x000fc8000f8040ffULL,
0x0000000903037c11ULL, 0x000fe400080f440cULL, 0x000000210600720cULL, 0x000fe20003f06070ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0043ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107027824ULL, 0x102fe400078e0206ULL,
0x0000002024067824ULL, 0x000fc600078e0206ULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000aff037c19ULL, 0x000fe40008011606ULL, 0x0ffffff802027812ULL, 0x000fc800078ef807ULL,
0x0000001d02057211ULL, 0x000fe400078e20ffULL, 0x0000000506027c12ULL, 0x000fe4000f8e30ffULL,
0x0000000707067812ULL, 0x000fe200078ec0ffULL, 0x0000000005087984ULL, 0x0002a20000000c00ULL,
0x0000006000077810ULL, 0x000fe20007ffe0ffULL, 0x000000011f027824ULL, 0x000fc800078e0202ULL,
0x0000002003037224ULL, 0x000fe400078e0202ULL, 0x0000000815057824ULL, 0x002fe200078e0206ULL,
0x00000003ff067819ULL, 0x000fe40000011607ULL, 0x0000000304037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x0000000803027c11ULL, 0x000fc8000f8040ffULL,
0x0000000903037c11ULL, 0x000fe400080f440cULL, 0x000000210600720cULL, 0x000fe20003f06070ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0043ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107027824ULL, 0x002fe200078e0206ULL,
0x0000000624067211ULL, 0x000fc800078e28ffULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000aff037c19ULL, 0x000fe40008011606ULL, 0x0ffffff802027812ULL, 0x000fca00078ef807ULL,
0x0000001002057824ULL, 0x000fe200078e021dULL, 0x0000000506027c12ULL, 0x000fe4000f8e30ffULL,
0x0000000707067812ULL, 0x000fe200078ec0ffULL, 0x0000008000077836ULL, 0x000fe20000000000ULL,
0x0000000005087984ULL, 0x0002a20000000c00ULL, 0x000000011f027824ULL, 0x000fc800078e0202ULL,
0x0000002003037224ULL, 0x000fe200078e0202ULL, 0x0000000615057211ULL, 0x002fc800078e18ffULL,
0x0000000304037210ULL, 0x000fe40007f1e0ffULL, 0x00000003ff067819ULL, 0x000fc60000011607ULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x0000000803027c11ULL, 0x000fc8000f8040ffULL,
0x0000000903037c11ULL, 0x000fe400080f440cULL, 0x000000210600720cULL, 0x000fe20003f06070ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0043ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107027824ULL, 0x102fe400078e0206ULL,
0x0000002024067824ULL, 0x000fc600078e0206ULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000aff037c19ULL, 0x000fe40008011606ULL, 0x0ffffff802027812ULL, 0x000fca00078ef807ULL,
0x0000001002057824ULL, 0x000fe200078e021dULL, 0x0000000506027c12ULL, 0x000fe4000f8e30ffULL,
0x0000000707067812ULL, 0x000fe200078ec0ffULL, 0x000000a000077836ULL, 0x000fe20000000000ULL,
0x0000000005087984ULL, 0x0002a20000000c00ULL, 0x000000021f027210ULL, 0x000fca0007ffe0ffULL,
0x0000002003037224ULL, 0x000fe400078e0202ULL, 0x0000000815057824ULL, 0x002fe200078e0206ULL,
0x00000003ff067819ULL, 0x000fe40000011607ULL, 0x0000000304037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x0000000803027c11ULL, 0x000fc8000f8040ffULL,
0x0000000903037c11ULL, 0x000fe400080f440cULL, 0x000000210600720cULL, 0x000fe20003f06070ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0043ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000607027210ULL, 0x002fe20007ffe0ffULL,
0x0000002024067824ULL, 0x000fc600078e0206ULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000aff037c19ULL, 0x000fe40008011606ULL, 0x0ffffff802027812ULL, 0x000fca00078ef807ULL,
0x0000001002057824ULL, 0x000fe200078e021dULL, 0x0000000506027c12ULL, 0x000fe4000f8e30ffULL,
0x0000000707067812ULL, 0x000fe200078ec0ffULL, 0x000000c000077836ULL, 0x000fe20000000000ULL,
0x0000000005087984ULL, 0x0002a20000000c00ULL, 0x000000011f027824ULL, 0x000fc800078e0202ULL,
0x0000002003037224ULL, 0x000fe400078e0202ULL, 0x0000000815057824ULL, 0x002fe200078e0206ULL,
0x00000003ff067819ULL, 0x000fe40000011607ULL, 0x0000000304037210ULL, 0x000fc80007f1e0ffULL,
0x000000ffff0c7210ULL, 0x000fe400007fe4ffULL, 0x0000000803027c11ULL, 0x000fc8000f8040ffULL,
0x0000000903037c11ULL, 0x000fe400080f440cULL, 0x000000210600720cULL, 0x000fe20003f06070ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0043ee000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107027824ULL, 0x142fe400078e0206ULL,
0x0000002024067824ULL, 0x000fe400078e0206ULL, 0x000000e0000d7836ULL, 0x000fe20000000000ULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x0000000aff037c19ULL, 0x000fe40008011606ULL,
0x0ffffff802027812ULL, 0x000fe400078ef807ULL, 0x0000000707007812ULL, 0x000fc400078ec0ffULL,
0x0000001d02057211ULL, 0x000fe400078e20ffULL, 0x0000000506027c12ULL, 0x000fe4000f8e30ffULL,
0x00000003ff067819ULL, 0x000fe2000001160dULL, 0x0000000005087984ULL, 0x0002a40000000c00ULL,
0x000000011f027824ULL, 0x000fe400078e0202ULL, 0x000000010d077824ULL, 0x000fe400078e0206ULL,
0x0000002003037224ULL, 0x000fc400078e0202ULL, 0x0000000815057824ULL, 0x002fe200078e0200ULL,
0x0000000707077812ULL, 0x000fe400078ec0ffULL, 0x0000000304037210ULL, 0x000fe40007f1e0ffULL,
0xfffffff807007812ULL, 0x000fe400078ef80dULL, 0x000000ffff0c7210ULL, 0x000fe400007fe4ffULL,
0x0000000803027c11ULL, 0x000fc8000f8040ffULL, 0x0000000903037c11ULL, 0x000fe400080f440cULL,
0x000000210600720cULL, 0x000fe20003f06070ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x0043ee000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000010001d7824ULL, 0x000fe200078e021dULL, 0x0000000624067211ULL, 0x000fc800078e28ffULL,
0x000000001d087984ULL, 0x002e620000000c00ULL, 0x0000000506007c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff037c19ULL, 0x000fc60008011606ULL, 0x000000011f007824ULL, 0x000fc800078e0200ULL,
0x0000002003037224ULL, 0x000fe200078e0200ULL, 0x000000070d007812ULL, 0x000fc800078ec0ffULL,
0x0000000304037210ULL, 0x000fe20007f1e0ffULL, 0x0000000815157824ULL, 0x000fc800078e0200ULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x0000000803027c11ULL, 0x000fc8000f8040ffULL,
0x0000000903037c11ULL, 0x000fc600080f4404ULL, 0x0000001015027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff027819ULL, 0x000fe20000011622ULL, 0x00000001ff087424ULL, 0x000fe200078e00ffULL,
0x00008e00ff0a7b82ULL, 0x000e640000000a00ULL, 0x0000000223027211ULL, 0x000fc800078e08ffULL,
0x0000001b0200720cULL, 0x000fda0003f06070ULL, 0x00009400ff038b82ULL, 0x000ea20000000800ULL,
0x000000029b098824ULL, 0x000fce00078e00ffULL, 0x00009000ff0e8b82ULL, 0x000ee20000000a00ULL,
0x0000000309098224ULL, 0x004fe400078e0202ULL, 0xffffffffff037424ULL, 0x000fe400078e00ffULL,
0x00000004090e8825ULL, 0x008fe400078e000eULL, 0x01e600081d0879a7ULL, 0x0004a6000850003fULL,
0x000000060e038981ULL, 0x000ee2000c1e1900ULL, 0x00000001230d7810ULL, 0x000fe20007ffe0ffULL,
0x0000004022067824ULL, 0x000fc400078e00ffULL, 0x0000008005047824ULL, 0x000fe200078e00ffULL,
0x0000001a0d00720cULL, 0x000fe20003f06070ULL, 0x0000008016057824ULL, 0x000fe200078e00ffULL,
0x0000000623137211ULL, 0x000fc800078e40ffULL, 0x00000040050d7812ULL, 0x000fe200078ef813ULL,
0x0000000403117224ULL, 0x008fc800078e02ffULL, 0x00000100110a7825ULL, 0x002fe400078e000aULL,
0x0000000c00208947ULL, 0x004fea0003800000ULL, 0x00000003ff3b7819ULL, 0x100fe4000001161eULL,
0x000000131c0c7248ULL, 0x000fe40007fe0000ULL, 0x0000003b0d0e7210ULL, 0x000fe20007ffe0ffULL,
0x000000043b0f7836ULL, 0x000fe20000000000ULL, 0x0000001c3b397810ULL, 0x000fe20007ffe0ffULL,
0x000000010c0c7824ULL, 0x000fe400078e0a13ULL, 0x000000010f117824ULL, 0x040fe400078e021eULL,
0x000000080f2e7824ULL, 0x040fe200078e00ffULL, 0x0000000c0f00720cULL, 0x000fe20003fa6070ULL,
0x000000010d107824ULL, 0x000fc400078e020fULL, 0x000000083b137836ULL, 0x000fe20000000000ULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee211ULL, 0x000001000e0e7825ULL, 0x000fc600078e00ffULL,
0x0000000313157819ULL, 0x040fe200000006ffULL, 0x000000103b177836ULL, 0x000fe20000000000ULL,
0x000000700e197812ULL, 0x000fe200078ef807ULL, 0x0000000113127824ULL, 0x100fe400078e021eULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x000000190a187210ULL, 0x000fe40007f1e0ffULL,
0xfffffff815307812ULL, 0x000fe200078ee212ULL, 0x00000001170e7824ULL, 0x040fe200078e021eULL,
0x0000007010217812ULL, 0x000fe200078ef807ULL, 0x0000000817257824ULL, 0x000fe200078e00ffULL,
0x0000000f0b197210ULL, 0x000fe200007fe4ffULL, 0x0000000c3b157836ULL, 0x000fe20000000000ULL,
0x000000210a207210ULL, 0x000fe20007f3e0ffULL, 0x000000183b2f7836ULL, 0x000fe20000000000ULL,
0xfffffff825347812ULL, 0x000fe200078ee20eULL, 0x000000010d0e7824ULL, 0x000fe200078e0213ULL,
0x000000150d107210ULL, 0x000fe20007ffe0ffULL, 0x00000008151f7824ULL, 0x000fe200078e00ffULL,
0x0000001e15127210ULL, 0x000fe20007ffe0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000002f0d167210ULL, 0x000fc40007ffe0ffULL, 0xfffffff81f327812ULL, 0x000fe200078ee212ULL,
0x000000010b217824ULL, 0x000fe200008e0611ULL, 0x000000700e257812ULL, 0x000fe200078ef807ULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x0000000c1700720cULL, 0x080fe40003f06070ULL,
0x000000250a247210ULL, 0x000fe20007f7e0ffULL, 0x000000010d127824ULL, 0x000fe200078e0217ULL,
0x0000007010297812ULL, 0x000fe200078ef807ULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x0000000c1300720cULL, 0x000fc40003f26070ULL, 0x000000290a287210ULL, 0x000fe20007f9e0ffULL,
0x000000143b277836ULL, 0x000fe20000000000ULL, 0x0000000c1500720cULL, 0x000fe20003f46070ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000001e2f377210ULL, 0x000fe40007ffe0ffULL,
0x0000001e272c7210ULL, 0x000fe20007ffe0ffULL, 0x000000010b257824ULL, 0x000fe200018e060fULL,
0x00000070160f7812ULL, 0x000fe200078ef807ULL, 0x000000010d147824ULL, 0x000fe200078e0227ULL,
0x00000070121f7812ULL, 0x000fe200078ef807ULL, 0x000000010b297824ULL, 0x000fe200020e0611ULL,
0x0000000f0a167210ULL, 0x000fe20007f9e0ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000001f0a127210ULL, 0x000fc40007f7e0ffULL, 0x000000170b177210ULL, 0x000fe200027fe4ffULL,
0x00004000220e7824ULL, 0x000fe200078e021dULL, 0x0000007014117812ULL, 0x000fe200078ef807ULL,
0x000000010d0f7824ULL, 0x000fe200078e0239ULL, 0x0000000c3b00720cULL, 0x000fe20003f86070ULL,
0x000020000e1f7836ULL, 0x000fe40000000000ULL, 0x000001000f0e7825ULL, 0x000fc800078e00ffULL,
0x000000010b137824ULL, 0x000fe200018e0613ULL, 0x000000110a147210ULL, 0x000fe20007f7e0ffULL,
0x000000013b107824ULL, 0x000fe200078e021eULL, 0x000000700e2b7812ULL, 0x000fe200078ef807ULL,
0x000000203b317836ULL, 0x000fe40000000000ULL, 0x000000010b157824ULL, 0x000fe200018e0615ULL,
0x0000000710117812ULL, 0x000fe200078ec0ffULL, 0x000000010d0e7824ULL, 0x000fe200078e0231ULL,
0x0000002b0a2a7210ULL, 0x000fe20007fde0ffULL, 0x000000243b337836ULL, 0x000fe20000000000ULL,
0x0000000c2700720cULL, 0x040fe20003f66070ULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x0ffffff811107812ULL, 0x000fe200078ef81eULL, 0x000000283b357836ULL, 0x000fe20000000000ULL,
0x0000000f0b2b7210ULL, 0x000fe200037fe4ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff827367812ULL, 0x000fc600078ee22cULL, 0x0000001010277824ULL, 0x000fe200078e021fULL,
0x000000700e2d7812ULL, 0x000fe200078ef807ULL, 0x000000010d107824ULL, 0x040fe400078e0233ULL,
0x000000010d0e7824ULL, 0x000fe200078e0235ULL, 0x0000002d0a2c7210ULL, 0x000fe20007fde0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018277faeULL, 0x0003e2000e101c46ULL, 0x0000000c2f00720cULL, 0x040fe40003f86070ULL,
0x0000000f0b2d7210ULL, 0x000fe200037fe4ffULL, 0x000000082f387824ULL, 0x000fc400078e00ffULL,
0x000001000e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff838387812ULL, 0x000fe200078ee237ULL,
0x00000010302f7824ULL, 0x100fe200078e021fULL, 0x0000002c3b377810ULL, 0x000fe20007ffe0ffULL,
0x000000102e277824ULL, 0x002fe200078e021fULL, 0x0000007010197812ULL, 0x000fe200078ef807ULL,
0x00000001392e7824ULL, 0x000fe400078e021eULL, 0x0000000831307824ULL, 0x000fe200078e00ffULL,
0x000000190a107210ULL, 0x000fe20007fde0ffULL, 0x0000000020277faeULL, 0x0003e2000e901c46ULL,
0x000000700e197812ULL, 0x000fe200078ef807ULL, 0x000000010d0e7824ULL, 0x000fe200078e0237ULL,
0x0000000c3900720cULL, 0x080fe20003fa6070ULL, 0x000000010b117824ULL, 0x000fe200030e0611ULL,
0x000000190a187210ULL, 0x000fe20007fde0ffULL, 0x0000000839397824ULL, 0x000fe200078e00ffULL,
0x00000000242f7faeULL, 0x0005e2000c901c46ULL, 0x0000000c3100720cULL, 0x000fc40003f26070ULL,
0x000000010b197824ULL, 0x000fe200030e060fULL, 0xfffffff8393a7812ULL, 0x000fe200078ee22eULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000001f32277211ULL, 0x002fc600078e20ffULL,
0x0000000131217824ULL, 0x100fe200078e021eULL, 0x000000700e317812ULL, 0x000fe200078ef807ULL,
0x0000000028277faeULL, 0x0003e2000d101c46ULL, 0x0000000c3300720cULL, 0x040fe20003f46070ULL,
0x00000001332e7824ULL, 0x040fe200078e021eULL, 0x0000000333337819ULL, 0x000fe200000006ffULL,
0x0000001034257824ULL, 0x004fe200078e021fULL, 0x000000310a207210ULL, 0x000fe20007fde0ffULL,
0x000000383b397836ULL, 0x000fe20000000000ULL, 0xfffffff8300e7812ULL, 0x000fe400078ee221ULL,
0xfffffff8332e7812ULL, 0x000fe200078ee22eULL, 0x000000010b217824ULL, 0x000fe200030e060fULL,
0x000000303b337810ULL, 0x000fe20007ffe0ffULL, 0x00000010360f7824ULL, 0x100fe200078e021fULL,
0x0000001f38277211ULL, 0x002fe200078e20ffULL, 0x000000100e2f7824ULL, 0x000fe200078e021fULL,
0x0000000012257faeULL, 0x0003e2000c101c46ULL, 0x000000010d0e7824ULL, 0x000fc400078e0233ULL,
0x000000103a297824ULL, 0x100fe200078e021fULL, 0x00000000140f7faeULL, 0x0005e2000d901c46ULL,
0x000000102e317824ULL, 0x000fe200078e021fULL, 0x0000000c3300720cULL, 0x080fe40003f66070ULL,
0x0000000016277faeULL, 0x0007e2000e101c46ULL, 0x0000000c3700720cULL, 0x000fc60003f86070ULL,
0x000000002a297faeULL, 0x000fe2000e901c46ULL, 0x000000343b257836ULL, 0x002fe20000000000ULL,
0x0000003c3b3b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000135137824ULL, 0x140fe200078e021eULL,
0x000000002c2f7faeULL, 0x000fe2000c901c46ULL, 0x000001000e0e7825ULL, 0x004fe200078e00ffULL,
0x0000000c3500720cULL, 0x080fe40003fa6070ULL, 0x0000000010317faeULL, 0x0003e2000d101c46ULL,
0x000000010d147824ULL, 0x000fe200078e0225ULL, 0x0000000c2500720cULL, 0x080fe20003f46070ULL,
0x0000000835167824ULL, 0x008fe200078e00ffULL, 0x0000000c3900720cULL, 0x080fe20003f26070ULL,
0x0000000125157824ULL, 0x100fe200078e021eULL, 0x0000000c3b00720cULL, 0x000fe20003f06070ULL,
0x00000001370c7824ULL, 0x100fe200078e021eULL, 0x0000000325287819ULL, 0x000fe200000006ffULL,
0x0000000837377824ULL, 0x000fe200078e00ffULL, 0x0000001e3b257210ULL, 0x000fe20007ffe0ffULL,
0x0000000139177824ULL, 0x100fe200078e021eULL, 0x000000700e117812ULL, 0x002fe200078ef807ULL,
0x00000001330e7824ULL, 0x040fe200078e021eULL, 0x0000000333337819ULL, 0x000fe200000006ffULL,
0x00000008392a7824ULL, 0x000fe200078e00ffULL, 0x000000110a127210ULL, 0x000fe20007fde0ffULL,
0x0000010014107825ULL, 0x000fe200078e00ffULL, 0xfffffff816147812ULL, 0x000fc400078ee213ULL,
0x0000000f0b137210ULL, 0x000fe200037fe4ffULL, 0x000000083b2c7824ULL, 0x000fe200078e00ffULL,
0x00000070100f7812ULL, 0x000fe400078ef807ULL, 0xfffffff833247812ULL, 0x000fe400078ee20eULL,
0x0000000f0a107210ULL, 0x000fe20007fde0ffULL, 0x000000010d0f7824ULL, 0x040fe200078e0239ULL,
0xfffffff837167812ULL, 0x000fe200078ee20cULL, 0x000000010d0d7824ULL, 0x000fe200078e023bULL,
0xfffffff8281e7812ULL, 0x000fe200078ee215ULL, 0x000001000f0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff82a287812ULL, 0x000fc400078ee217ULL, 0xfffffff82c2a7812ULL, 0x000fe200078ee225ULL,
0x000001000d0c7825ULL, 0x000fe200078e00ffULL, 0x000000700e277812ULL, 0x000fe400078ef807ULL,
0x0000001f16157211ULL, 0x080fe200078e20ffULL, 0x000000010b117824ULL, 0x040fe200030e0611ULL,
0x000000270a0e7210ULL, 0x000fe20007fde0ffULL, 0x0000001024177824ULL, 0x100fe200078e021fULL,
0x000000700c257812ULL, 0x000fe200078ef807ULL, 0x0000001014077824ULL, 0x000fe400078e021fULL,
0x000000010b0f7824ULL, 0x040fe200030e060fULL, 0x000000250a0a7210ULL, 0x000fe20007fde0ffULL,
0x000000101e257824ULL, 0x100fe200078e021fULL, 0x0000000018077faeULL, 0x0003e2000e901c46ULL,
0x0000001028277824ULL, 0x000fe200078e021fULL, 0x0000001f2a1f7211ULL, 0x000fe200078e20ffULL,
0x000000010b0b7824ULL, 0x000fe200030e060dULL, 0x0000000020157faeULL, 0x0003e8000e101c46ULL,
0x0000000012177faeULL, 0x0003e8000d901c46ULL, 0x0000000010257faeULL, 0x0003e8000d101c46ULL,
0x000000000e277faeULL, 0x0003e8000c901c46ULL, 0x000000000a1f7faeULL, 0x0003e2000c101c46ULL,
0x0000000800d07947ULL, 0x000fea0003800000ULL, 0x0000000c1e157811ULL, 0x040fe400078fe8ffULL,
0x000000041e137811ULL, 0x040fe400078fe8ffULL, 0x0000001c1e2d7811ULL, 0x040fe200078fe8ffULL,
0x00000001150f7824ULL, 0x140fe200078e021eULL, 0x000000081e147811ULL, 0x040fe200078fe8ffULL,
0x0000000815127824ULL, 0x000fe200078e00ffULL, 0x000000101e297811ULL, 0x040fe200078fe8ffULL,
0x00000001130c7824ULL, 0x140fe200078e021eULL, 0x0000001e140e7210ULL, 0x000fe20007ffe0ffULL,
0x0000000813357824ULL, 0x000fe200078e00ffULL, 0xfffffff812397812ULL, 0x000fe200078ee20fULL,
0x000000012d117824ULL, 0x140fe200078e021eULL, 0x000000201e0f7811ULL, 0x040fe200078fe8ffULL,
0x000000082d127824ULL, 0x000fe200078e00ffULL, 0x000000141e2a7811ULL, 0x000fe200078fe8ffULL,
0x0000000814377824ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee20cULL,
0x00000008293b7824ULL, 0x000fe200078e00ffULL, 0x000000181e2c7811ULL, 0x000fe200078fe8ffULL,
0x000000080f177824ULL, 0x000fe200078e00ffULL, 0xfffffff812417812ULL, 0x000fe200078ee211ULL,
0x000000082a3d7824ULL, 0x000fe200078e00ffULL, 0x0000001e29107210ULL, 0x000fe20007ffe0ffULL,
0x000000082c3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff837377812ULL, 0x000fe200078ee20eULL,
0x000000012a0e7824ULL, 0x000fe200078e021eULL, 0x0000001e0f0c7210ULL, 0x000fc40007ffe0ffULL,
0x000000241e117811ULL, 0x040fe400078fe8ffULL, 0x000000281e167811ULL, 0x040fe400078fe8ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL, 0x0000000811197824ULL, 0x040fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fe200078ee20cULL, 0x00000001110c7824ULL, 0x000fe200078e021eULL,
0x000000301e217811ULL, 0x000fe200078fe8ffULL, 0x0000000816257824ULL, 0x000fe200078e00ffULL,
0x0000001e2c107210ULL, 0x000fe20007ffe0ffULL, 0x000000010d2e7824ULL, 0x000fe200078e0216ULL,
0x0000002c1e1f7811ULL, 0x000fe200078fe8ffULL, 0x00000008212b7824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee20eULL, 0x000000010d347824ULL, 0x000fe200078e0221ULL,
0x0000001e160e7210ULL, 0x000fe20007ffe0ffULL, 0x000000081f277824ULL, 0x040fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee210ULL, 0x000000011f107824ULL, 0x000fe200078e021eULL,
0x0000001e21127210ULL, 0x000fc40007ffe0ffULL, 0xfffffff819187812ULL, 0x000fe400078ee20cULL,
0xfffffff825197812ULL, 0x000fe400078ee20eULL, 0x0000001e1e0e7211ULL, 0x040fe400078fe8ffULL,
0x000000341e257811ULL, 0x000fe400078fe8ffULL, 0xfffffff82b247812ULL, 0x000fe400078ee212ULL,
0xfffffff827207812ULL, 0x000fe200078ee210ULL, 0x0000000114107824ULL, 0x100fe200078e020dULL,
0x0000000d15127210ULL, 0x000fe20007ffe0ffULL, 0x000000012c157824ULL, 0x000fe200078e020dULL,
0x000000381e277811ULL, 0x000fe200078fe8ffULL, 0x000000010d2c7824ULL, 0x000fe200078e020fULL,
0x000000070e2b7812ULL, 0x000fe200078ec0ffULL, 0x00000001130e7824ULL, 0x100fe200078e020dULL,
0x0000003c1e287811ULL, 0x040fe200078fe8ffULL, 0x0000000129137824ULL, 0x100fe200078e020dULL,
0x0000000d1e0c7211ULL, 0x000fe200078fe8ffULL, 0x000000012a147824ULL, 0x000fe200078e020dULL,
0x0000000d2d297210ULL, 0x000fe20007ffe0ffULL, 0x00000001250f7824ULL, 0x140fe200078e021eULL,
0x00000003252a7819ULL, 0x000fe200000006ffULL, 0x000000010d2d7824ULL, 0x040fe200078e0211ULL,
0x0000001f0d2f7210ULL, 0x000fe20007ffe0ffULL, 0x000000010d387824ULL, 0x000fe200078e0227ULL,
0x000000280d3a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000127117824ULL, 0x000fc400078e021eULL,
0x0000000827307824ULL, 0x000fe200078e00ffULL, 0x0ffffff82b277812ULL, 0x000fe200078ef81eULL,
0x000000010d367824ULL, 0x000fe400078e0225ULL, 0x0000000128167824ULL, 0x000fe200078e021eULL,
0xfffffff82a1e7812ULL, 0x000fe200078ee20fULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffff8301f7812ULL, 0x000fc600078ee211ULL, 0x00004000220f7824ULL, 0x000fe200078e021dULL,
0x000000700c257812ULL, 0x000fe200078ef807ULL, 0x0000000828217824ULL, 0x000fe400078e00ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x000020000f0c7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff821217812ULL, 0x000fe200078ee216ULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000000250a167210ULL, 0x000fe40007f1e0ffULL, 0x0000000c39397211ULL, 0x080fe200078e20ffULL,
0x0000001019477824ULL, 0x100fe200078e020cULL, 0x000000700e197812ULL, 0x000fe200078ef807ULL,
0x0000001018457824ULL, 0x100fe200078e020cULL, 0x0000000c41417211ULL, 0x080fe200078e20ffULL,
0x0000001017437824ULL, 0x100fe200078e020cULL, 0x000000190a187210ULL, 0x000fe20007f3e0ffULL,
0x000000101f4f7824ULL, 0x100fe200078e020cULL, 0x0000000c20497211ULL, 0x080fe200078e20ffULL,
0x0000001027277824ULL, 0x100fe200078e020cULL, 0x0000000c21517211ULL, 0x000fe200078e20ffULL,
0x0000001035357824ULL, 0x100fe200078e020cULL, 0x00000070101f7812ULL, 0x000fe200078ef807ULL,
0x0000001037377824ULL, 0x000fc400078e020cULL, 0x000000103b3b7824ULL, 0x100fe400078e020cULL,
0x000000103d3d7824ULL, 0x100fe400078e020cULL, 0x000000103f3f7824ULL, 0x100fe400078e020cULL,
0x00000010244b7824ULL, 0x100fe400078e020cULL, 0x000000101e4d7824ULL, 0x000fe400078e020cULL,
0x000000010b177824ULL, 0x040fe200000e060dULL, 0x0000001f0a1e7210ULL, 0x000fe20007f1e0ffULL,
0x000000010b197824ULL, 0x000fc400008e060fULL, 0x00000100120c7825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016277faeULL, 0x0003e6000b901c46ULL,
0x00000100130e7825ULL, 0x000fe200078e00ffULL, 0x000000700c217812ULL, 0x000fe200078ef807ULL,
0x0000000018357faeULL, 0x0003e4000b901c46ULL, 0x0000010014127825ULL, 0x000fe200078e00ffULL,
0x000000700e257812ULL, 0x000fc600078ef807ULL, 0x0000010015147825ULL, 0x000fe200078e00ffULL,
0x000000250a247210ULL, 0x000fc60007f3e0ffULL, 0x000000010b1f7824ULL, 0x040fe200000e0611ULL,
0x000000210a207210ULL, 0x000fe20007f1e0ffULL, 0x000000010b257824ULL, 0x000fe200008e060fULL,
0x00000070142b7812ULL, 0x000fe200078ef807ULL, 0x000001002c0e7825ULL, 0x000fe200078e00ffULL,
0x0000007012117812ULL, 0x000fe200078ef807ULL, 0x000000001e377faeULL, 0x0003e2000b901c46ULL,
0x0000000d0b217210ULL, 0x000fe200007fe4ffULL, 0x00000100290c7825ULL, 0x000fe200078e00ffULL,
0x0000002b0a2a7210ULL, 0x000fe40007f5e0ffULL, 0x000000110a287210ULL, 0x000fe20007f1e0ffULL,
0x000001002d107825ULL, 0x000fe200078e00ffULL, 0x000000700c2d7812ULL, 0x000fe200078ef807ULL,
0x0000000020397faeULL, 0x0003e4000b901c46ULL, 0x000000010b2b7824ULL, 0x000fe200010e0615ULL,
0x0000007010317812ULL, 0x000fe200078ef807ULL, 0x000001002f147825ULL, 0x000fe200078e00ffULL,
0x000000700e2f7812ULL, 0x000fe200078ef807ULL, 0x00000000243b7faeULL, 0x0003e4000b901c46ULL,
0x000000010b297824ULL, 0x000fe200000e0613ULL, 0x0000002d0a2c7210ULL, 0x000fe20007f1e0ffULL,
0x000001002e127825ULL, 0x000fe200078e00ffULL, 0x0000002f0a2e7210ULL, 0x000fc40007f3e0ffULL,
0x0000000d0b2d7210ULL, 0x000fe200007fe4ffULL, 0x00000100340c7825ULL, 0x000fe200078e00ffULL,
0x0000007012337812ULL, 0x000fe200078ef807ULL, 0x00000000283d7faeULL, 0x0003e2000b901c46ULL,
0x000000310a307210ULL, 0x000fe20007f1e0ffULL, 0x000000010b2f7824ULL, 0x040fe200008e060fULL,
0x00000070140f7812ULL, 0x000fe200078ef807ULL, 0x000000002a3f7faeULL, 0x0003e2000b901c46ULL,
0x000000330a327210ULL, 0x000fe20007f5e0ffULL, 0x000000010b317824ULL, 0x040fe200000e0611ULL,
0x0000000f0a147210ULL, 0x000fe20007f1e0ffULL, 0x00000100360e7825ULL, 0x000fe200078e00ffULL,
0x000000700c577812ULL, 0x000fe200078ef807ULL, 0x000000002c417faeULL, 0x0003e2000b901c46ULL,
0x000000150b157210ULL, 0x000fe200007fe4ffULL, 0x0000010038107825ULL, 0x000fe200078e00ffULL,
0x000000700e557812ULL, 0x000fe200078ef807ULL, 0x000000002e437faeULL, 0x0003e2000b901c46ULL,
0x000000570a0c7210ULL, 0x000fe20007f1e0ffULL, 0x000000010b337824ULL, 0x040fe200010e0613ULL,
0x0000007010537812ULL, 0x000fe200078ef807ULL, 0x000001003a127825ULL, 0x000fe200078e00ffULL,
0x000000550a0e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000030457faeULL, 0x0003e2000b901c46ULL,
0x000000530a107210ULL, 0x000fe20007f5e0ffULL, 0x000000010b0d7824ULL, 0x040fe200000e060dULL,
0x0000007012077812ULL, 0x000fe200078ef807ULL, 0x000000010b0f7824ULL, 0x040fe200008e060fULL,
0x0000000032477faeULL, 0x0003e2000b901c46ULL, 0x000000010b117824ULL, 0x000fe200010e0611ULL,
0x000000070a0a7210ULL, 0x000fc40007f7e0ffULL, 0x0000000014497faeULL, 0x0003e4000b901c46ULL,
0x000000130b0b7210ULL, 0x000fe40001ffe4ffULL, 0x000000000c4b7faeULL, 0x0003e8000b901c46ULL,
0x000000000e4d7faeULL, 0x0003e8000b901c46ULL, 0x00000000104f7faeULL, 0x0003e8000b901c46ULL,
0x000000000a517faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000000a7805ULL, 0x002fe20000015200ULL, 0x01e600091d0075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff0e7224ULL, 0x000fce00078e00ffULL,
0x000000100e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c0a0c7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0d7824ULL, 0x000fe200000e0e0bULL, 0x003d09000c00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400c00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff077819ULL, 0x000fc8000001140dULL,
0x0000000c07077211ULL, 0x000fca00078110ffULL, 0x000000ffff0c7224ULL, 0x000fca00000e060dULL,
0x0000000207077819ULL, 0x000fc8000000120cULL, 0x000000070000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fce0007ffe0ffULL,
0x01e600091d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000001a2300720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00009400ff087b82ULL, 0x000e620000000800ULL, 0x0000000000077919ULL, 0x000ea20000000000ULL,
0x0000840000097ab9ULL, 0x000fe20000000800ULL, 0x0000000822997824ULL, 0x000fe200078e021dULL,
0x0000001f09047890ULL, 0x000fe4000fffe03fULL, 0x800000091c0a7c36ULL, 0x000fe20008000000ULL,
0xffffffff09057890ULL, 0x000fe4000fffe03fULL, 0x000000043f047899ULL, 0x000fe40008011604ULL,
0x00000008ff0a7819ULL, 0x000fe2000001160aULL, 0x0000000909087890ULL, 0x000fc4000fffe03fULL,
0x0ffffffe04047892ULL, 0x000fe2000f8ec03fULL, 0x000000089b9b7224ULL, 0x002fe400078e02ffULL,
0x0000002022087824ULL, 0x000fd200078e021dULL, 0x00008e00ff9e7b82ULL, 0x002e620000000a00ULL,
0x00000001230b7810ULL, 0x000fe20007ffe0ffULL, 0x0000010023097824ULL, 0x000fe400078e0206ULL,
0x00000003040f7224ULL, 0x000fe200078e02ffULL, 0x0000001a0b00720cULL, 0x000fe40003f06070ULL,
0x00000040090c7812ULL, 0x000fca00078ec0ffULL, 0x00000001052e7824ULL, 0x000fe400078e020cULL,
0x000001000f0e7825ULL, 0x002fc800078e009eULL, 0x0000000800f08947ULL, 0x000fea0003800000ULL,
0x00000003ff307819ULL, 0x104fe20000011607ULL, 0x00000010070b7824ULL, 0x000fe200078e00ffULL,
0x000000091c127248ULL, 0x000fe20007fe0000ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x0000000430147810ULL, 0x000fe20007ffe0ffULL, 0x0000000830167836ULL, 0x000fe20000000000ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000c301e7836ULL, 0x000fe20000000000ULL,
0x0000001030207810ULL, 0x000fe20007ffe0ffULL, 0x00000008160d7824ULL, 0x000fe200078e00ffULL,
0x00000007160c7210ULL, 0x000fe20007ffe0ffULL, 0x0000000114037824ULL, 0x040fe200078e0207ULL,
0x000000800b107812ULL, 0x000fe200078efcffULL, 0x00000008142c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d327812ULL, 0x000fe200078ee20cULL, 0x00000001300d7824ULL, 0x000fe200078e022eULL,
0x0000000720137210ULL, 0x000fe20007ffe0ffULL, 0x0000000820367824ULL, 0x000fe200078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee203ULL, 0x000001000d0c7825ULL, 0x000fe200078e0010ULL,
0x00000014302a7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff836367812ULL, 0x000fe200078ee213ULL,
0x000000011e037824ULL, 0x040fe200078e0207ULL, 0x0000000c0e187210ULL, 0x000fe20007f1e0ffULL,
0x000000081e347824ULL, 0x000fe200078e00ffULL, 0x0000002e20177210ULL, 0x000fe20007ffe0ffULL,
0x0000000116137824ULL, 0x100fe200078e022eULL, 0x00000018303c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010f197824ULL, 0x000fe200000e060dULL, 0xfffffff834347812ULL, 0x000fe200078ee203ULL,
0x00000001140d7824ULL, 0x000fe200078e022eULL, 0x000000032a277819ULL, 0x000fe200000006ffULL,
0x0000000112037824ULL, 0x000fc400078e0a09ULL, 0x000001000d0c7825ULL, 0x000fc600078e0010ULL,
0x000000031e00720cULL, 0x080fe20003f46070ULL, 0x0000010013127825ULL, 0x000fe200078e0010ULL,
0x000000032000720cULL, 0x080fe40003f06070ULL, 0x000000031400720cULL, 0x080fe20003f86070ULL,
0x000000011e157824ULL, 0x100fe200078e022eULL, 0x0000000c0e1e7210ULL, 0x000fe20007f7e0ffULL,
0x000000012a217824ULL, 0x000fe200078e022eULL, 0x000000120e207210ULL, 0x000fe20007fbe0ffULL,
0x0000010015147825ULL, 0x000fe200078e0010ULL, 0x000000031600720cULL, 0x000fc60003f26070ULL,
0x000000010f1f7824ULL, 0x000fe200018e060dULL, 0x000000140e247210ULL, 0x000fe20007f7e0ffULL,
0x00000100210c7825ULL, 0x000fc800078e0010ULL, 0x000000010f217824ULL, 0x000fe200028e0613ULL,
0x0000000c0e287210ULL, 0x000fe20007fde0ffULL, 0x000000013c137824ULL, 0x000fe200078e022eULL,
0x0ffffff8070c7812ULL, 0x000fe200078ec0ffULL, 0x0000010017167825ULL, 0x000fe200078e0010ULL,
0x0000000d0f297210ULL, 0x000fc600037fe4ffULL, 0x0000010013127825ULL, 0x000fe200078e0010ULL,
0x000000160e167210ULL, 0x000fc60007fbe0ffULL, 0x000000010f257824ULL, 0x040fe200018e0615ULL,
0x000000032a00720cULL, 0x0c0fe20003f66070ULL, 0x000000012a147824ULL, 0x000fe200078e0207ULL,
0x000000120e2a7210ULL, 0x000fe20007fde0ffULL, 0x0000400022387824ULL, 0x000fe400078e021dULL,
0x0000000130157824ULL, 0x040fe200078e0207ULL, 0xfffffff8273a7812ULL, 0x000fe200078ee214ULL,
0x000000010f177824ULL, 0x000fe200028e0617ULL, 0x000000033000720cULL, 0x000fe20003fa6070ULL,
0x0000001c303e7836ULL, 0x000fe20000000000ULL, 0x000000070c127812ULL, 0x000fe200078ef815ULL,
0x00004000380d7836ULL, 0x000fc40000000000ULL, 0x000000010f2b7824ULL, 0x000fe400030e0613ULL,
0x000000013e137824ULL, 0x000fe200078e022eULL, 0x0000000d12277211ULL, 0x000fe200078e20ffULL,
0x000000102c2f7824ULL, 0x000fe400078e020dULL, 0x0000010013127825ULL, 0x000fe400078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018277faeULL, 0x0003e2000e901c46ULL,
0x000000033c00720cULL, 0x080fe20003fa6070ULL, 0x0000002030407836ULL, 0x000fe20000000000ULL,
0x000000120e2c7210ULL, 0x000fe20007fde0ffULL, 0x000000013e127824ULL, 0x100fe200078e0207ULL,
0x000000001e2f7faeULL, 0x0005e2000e101c46ULL, 0x000000013c317824ULL, 0x040fe200078e0207ULL,
0x0000002e40157210ULL, 0x000fe20007ffe0ffULL, 0x000000083c3c7824ULL, 0x000fe200078e00ffULL,
0x000000033e00720cULL, 0x040fe20003f86070ULL, 0x000000010f2d7824ULL, 0x000fe200030e0613ULL,
0x000000033e197819ULL, 0x002fe200000006ffULL, 0x0000010015147825ULL, 0x000fe200078e0010ULL,
0xfffffff83c187812ULL, 0x000fc400078ee231ULL, 0xfffffff8191e7812ULL, 0x004fe200078ee212ULL,
0x0000001032197824ULL, 0x100fe200078e020dULL, 0x0000002430327810ULL, 0x000fe20007ffe0ffULL,
0x00000010341f7824ULL, 0x000fe200078e020dULL, 0x000000140e147210ULL, 0x000fe20007fde0ffULL,
0x0000000140277824ULL, 0x100fe200078e0207ULL, 0x0000000020197faeULL, 0x0003e2000c901c46ULL,
0x0000000132137824ULL, 0x000fe200078e022eULL, 0x000000034000720cULL, 0x080fe20003f26070ULL,
0x00000001322f7824ULL, 0x040fe200078e0207ULL, 0x00000000241f7faeULL, 0x0005e2000d101c46ULL,
0x000000033200720cULL, 0x040fe20003f46070ULL, 0x0000000832327824ULL, 0x000fe200078e00ffULL,
0x0000000340407819ULL, 0x000fe200000006ffULL, 0x0000010013127825ULL, 0x000fc800078e0010ULL,
0x000000010f157824ULL, 0x000fe200030e0615ULL, 0xfffffff840207812ULL, 0x002fe200078ee227ULL,
0x0000001036197824ULL, 0x100fe200078e020dULL, 0x000000120e127210ULL, 0x000fe20007fde0ffULL,
0x0000001018217824ULL, 0x100fe200078e020dULL, 0xfffffff832247812ULL, 0x004fe200078ee22fULL,
0x000000103a1f7824ULL, 0x100fe200078e020dULL, 0x0000000d20277211ULL, 0x000fe200078e20ffULL,
0x0000002830187836ULL, 0x000fe20000000000ULL, 0x000000130f137210ULL, 0x000fe200037fe4ffULL,
0x000000101e257824ULL, 0x100fe200078e020dULL, 0x0000000016197faeULL, 0x0003e2000c101c46ULL,
0x00000010242f7824ULL, 0x000fe200078e020dULL, 0x0000003030327810ULL, 0x000fe20007ffe0ffULL,
0x0000002c30247836ULL, 0x000fe20000000000ULL, 0x00000000281f7faeULL, 0x0005e2000d901c46ULL,
0x0000003830347836ULL, 0x000fe20000000000ULL, 0x000000033200720cULL, 0x080fe20003f66070ULL,
0x00000001181e7824ULL, 0x040fe200078e0207ULL, 0x000000002a217faeULL, 0x0007e2000e901c46ULL,
0x000000031800720cULL, 0x000fc40003fa6070ULL, 0x0000002e18177210ULL, 0x002fe20007ffe0ffULL,
0x000000002c257faeULL, 0x000fe2000e101c46ULL, 0x0000002e32197210ULL, 0x000fe20007ffe0ffULL,
0x0000003430287836ULL, 0x004fe40000000000ULL, 0x0000000014277faeULL, 0x0003e2000c901c46ULL,
0x00000008181f7824ULL, 0x000fe200078e00ffULL, 0x000000032400720cULL, 0x080fe20003f86070ULL,
0x0000003c30307836ULL, 0x000fe20000000000ULL, 0x00000000122f7faeULL, 0x0005e2000d101c46ULL,
0x000000032800720cULL, 0x080fe20003f46070ULL, 0x0000000134217824ULL, 0x108fe200078e022eULL,
0xfffffff81f207812ULL, 0x000fe200078ee21eULL, 0x00000008241f7824ULL, 0x000fe200078e00ffULL,
0x000000033400720cULL, 0x080fe20003f26070ULL, 0x00000008282a7824ULL, 0x000fe200078e00ffULL,
0x000000033000720cULL, 0x000fe20003f06070ULL, 0x0000000124157824ULL, 0x002fe200078e022eULL,
0x0000002e28037210ULL, 0x000fc40007ffe0ffULL, 0x0000000732257210ULL, 0x000fe20007ffe0ffULL,
0x0000010017127825ULL, 0x004fc800078e0010ULL, 0x0000010015147825ULL, 0x000fe200078e0010ULL,
0x000000120e167210ULL, 0x000fc60007fde0ffULL, 0x0000000832327824ULL, 0x000fe400078e00ffULL,
0x000000010f177824ULL, 0x000fe200030e0613ULL, 0x000000140e187210ULL, 0x000fe20007fde0ffULL,
0x0000010019127825ULL, 0x000fc800078e0010ULL, 0x0000000124147824ULL, 0x000fe400078e0207ULL,
0x000000010f197824ULL, 0x000fe200030e0615ULL, 0x000000120e1e7210ULL, 0x000fe40007fde0ffULL,
0xfffffff81f247812ULL, 0x000fe200078ee214ULL, 0x0000010003147825ULL, 0x000fe200078e0010ULL,
0x0000002e30037210ULL, 0x000fc60007ffe0ffULL, 0x000000010f1f7824ULL, 0x000fe200030e0613ULL,
0x000000140e147210ULL, 0x000fe20007fde0ffULL, 0x0000010021127825ULL, 0x000fc800078e0010ULL,
0x0000000128217824ULL, 0x000fe200078e0207ULL, 0xfffffff832287812ULL, 0x000fe200078ee225ULL,
0x000000010f157824ULL, 0x000fe200030e0615ULL, 0x000000120e127210ULL, 0x000fe20007fde0ffULL,
0x0000010003107825ULL, 0x000fe200078e0010ULL, 0xfffffff82a2a7812ULL, 0x000fc600078ee221ULL,
0x0000000134037824ULL, 0x140fe200078e0207ULL, 0x0000000334347819ULL, 0x000fe200000006ffULL,
0x0000000130217824ULL, 0x040fe400078e0207ULL, 0x000000010f137824ULL, 0x000fe200030e0613ULL,
0x000000100e0e7210ULL, 0x000fe20007fde0ffULL, 0x0000000830307824ULL, 0x000fe200078e00ffULL,
0xfffffff834107812ULL, 0x000fe200078ee203ULL, 0x0000001020037824ULL, 0x100fe200078e020dULL,
0x000000110f0f7210ULL, 0x000fe200037fe4ffULL, 0x0000001024117824ULL, 0x100fe200078e020dULL,
0xfffffff830207812ULL, 0x000fe200078ee221ULL, 0x0000001028217824ULL, 0x100fe200078e020dULL,
0x0000000d10277211ULL, 0x000fe200078e20ffULL, 0x000000102a257824ULL, 0x100fe200078e020dULL,
0x0000000016037faeULL, 0x0003e2000e901c46ULL, 0x0000001020297824ULL, 0x000fc600078e020dULL,
0x0000000018117faeULL, 0x0003e8000e101c46ULL, 0x000000001e217faeULL, 0x0003e8000d901c46ULL,
0x0000000014257faeULL, 0x0003e8000d101c46ULL, 0x0000000012277faeULL, 0x0003e8000c901c46ULL,
0x000000000e297faeULL, 0x0003e2000c101c46ULL, 0x0000000800a07947ULL, 0x000fea0003800000ULL,
0x0000001007177811ULL, 0x044fe200078fe8ffULL, 0x0000400022387824ULL, 0x000fe200078e021dULL,
0x0000000c07157811ULL, 0x040fe400078fe8ffULL, 0x0000000807137811ULL, 0x000fe200078fe8ffULL,
0x0000000817427824ULL, 0x000fe200078e00ffULL, 0x0000002007257811ULL, 0x000fe200078fe8ffULL,
0x00000001150c7824ULL, 0x100fe200078e0207ULL, 0x0000000407117811ULL, 0x000fe200078fe8ffULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0x00000007170d7210ULL, 0x000fe20007ffe0ffULL,
0x00000008133e7824ULL, 0x000fe200078e00ffULL, 0x00000018071f7811ULL, 0x000fe200078fe8ffULL,
0x00000008254a7824ULL, 0x000fe200078e00ffULL, 0x00000007130b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000111037824ULL, 0x140fe200078e0207ULL, 0xfffffff842427812ULL, 0x000fe200078ee20dULL,
0x00000008113c7824ULL, 0x000fe200078e00ffULL, 0x00000030072f7811ULL, 0x000fe200078fe8ffULL,
0x000000081f467824ULL, 0x000fe200078e00ffULL, 0xfffffff819407812ULL, 0x000fe200078ee20cULL,
0x0000000111117824ULL, 0x100fe200078e022eULL, 0x00000007250d7210ULL, 0x000fe20007ffe0ffULL,
0x000000082f527824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee20bULL,
0x0000000117177824ULL, 0x100fe200078e022eULL, 0x0000001407197811ULL, 0x000fe200078fe8ffULL,
0x0000000115157824ULL, 0x100fe200078e022eULL, 0x00000028072b7811ULL, 0x000fe200078fe8ffULL,
0x0000000125257824ULL, 0x100fe200078e022eULL, 0x000000071f0b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000819447824ULL, 0x000fe200078e00ffULL, 0xfffffff84a4a7812ULL, 0x000fe200078ee20dULL,
0x000000082b4e7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee203ULL,
0x0000000119037824ULL, 0x040fe200078e0207ULL, 0x000000072f0d7210ULL, 0x000fe20007ffe0ffULL,
0x0000000119197824ULL, 0x100fe200078e022eULL, 0x0000001c07217811ULL, 0x000fe200078fe8ffULL,
0x000000012f2f7824ULL, 0x000fe200078e022eULL, 0xfffffff846467812ULL, 0x000fc400078ee20bULL,
0x0000002407297811ULL, 0x000fe200078fe8ffULL, 0x00000001210c7824ULL, 0x140fe200078e0207ULL,
0x000000072b0b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000821277824ULL, 0x000fe200078e00ffULL,
0xfffffff852527812ULL, 0x000fe200078ee20dULL, 0x00000008294c7824ULL, 0x000fe200078e00ffULL,
0x00000038070d7811ULL, 0x000fe200078fe8ffULL, 0x0000000121217824ULL, 0x100fe200078e022eULL,
0xfffffff844447812ULL, 0x000fe200078ee203ULL, 0x0000000129037824ULL, 0x100fe200078e0207ULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee20bULL, 0x00000010070b7824ULL, 0x040fe200078e00ffULL,
0x0000002c072d7811ULL, 0x000fe200078fe8ffULL, 0x000000010d107824ULL, 0x140fe200078e0207ULL,
0xfffffff827487812ULL, 0x000fe200078ee20cULL, 0x000000010d337824ULL, 0x140fe200078e022eULL,
0x000000030d357819ULL, 0x000fe200000006ffULL, 0x000000012d0c7824ULL, 0x040fe200078e0207ULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee203ULL, 0x000000082d277824ULL, 0x000fe200078e00ffULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000129297824ULL, 0x100fe200078e022eULL,
0x0000003407037811ULL, 0x000fe200078fe8ffULL, 0x000000012d2d7824ULL, 0x000fe200078e022eULL,
0xfffffff835567812ULL, 0x000fc400078ee210ULL, 0x000000800b347812ULL, 0x000fe200078efcffULL,
0x0000000103317824ULL, 0x040fe200078e022eULL, 0x000000ff00357202ULL, 0x000fe40000000f00ULL,
0xfffffff827507812ULL, 0x000fe200078ee20cULL, 0x0000000803277824ULL, 0x000fe200078e00ffULL,
0x0000003c07127811ULL, 0x000fe200078fe8ffULL, 0x0000010011107825ULL, 0x000fe200078e0034ULL,
0x00000007030c7210ULL, 0x000fe40007ffe0ffULL, 0x0000002e070d7211ULL, 0x000fe200078fe8ffULL,
0x0000000112147824ULL, 0x040fe200078e0207ULL, 0x0000002e13137210ULL, 0x000fe20007ffe0ffULL,
0x0000000812377824ULL, 0x000fe200078e00ffULL, 0xfffffff827547812ULL, 0x000fe200078ee20cULL,
0x000001000d0c7825ULL, 0x000fe200078e0034ULL, 0x000000100e107210ULL, 0x000fc40007f3e0ffULL,
0xfffffff837587812ULL, 0x000fe200078ee214ULL, 0x0000000112037824ULL, 0x000fe200078e022eULL,
0x0000000c0e367210ULL, 0x000fe20007f1e0ffULL, 0x0000010017167825ULL, 0x100fe200078e0034ULL,
0x0000002e1f1f7210ULL, 0x000fe40007ffe0ffULL, 0x0000002e2b2b7210ULL, 0x000fe20007ffe0ffULL,
0x0000010013127825ULL, 0x000fe200078e0034ULL, 0x0ffffff8070c7812ULL, 0x000fc600078ec0ffULL,
0x0000010015147825ULL, 0x000fe200078e0034ULL, 0x000000120e127210ULL, 0x000fc60007f5e0ffULL,
0x000000010f117824ULL, 0x000fe200008e0611ULL, 0x000000160e167210ULL, 0x000fe20007f3e0ffULL,
0x0000010025247825ULL, 0x000fc800078e0034ULL, 0x0000010019187825ULL, 0x000fc800078e0034ULL,
0x000000010f377824ULL, 0x000fe200000e060dULL, 0x000000140e147210ULL, 0x000fe20007f1e0ffULL,
0x0000010021207825ULL, 0x000fc600078e0034ULL, 0x000000150f157210ULL, 0x000fe200007fe4ffULL,
0x000000010f177824ULL, 0x040fe200008e0617ULL, 0x000000240e247210ULL, 0x000fe20007f3e0ffULL,
0x000000010f137824ULL, 0x000fe200010e0613ULL, 0x000000180e187210ULL, 0x000fe20007f5e0ffULL,
0x000001001f1e7825ULL, 0x000fe200078e0034ULL, 0x000000200e207210ULL, 0x000fc60007f1e0ffULL,
0x000001002f2e7825ULL, 0x100fe200078e0034ULL, 0x0000001e0e1e7210ULL, 0x000fe40007f7e0ffULL,
0x000000210f217210ULL, 0x000fe200007fe4ffULL, 0x0000010029287825ULL, 0x000fc800078e0034ULL,
0x000001002d2c7825ULL, 0x000fc800078e0034ULL, 0x000000010f257824ULL, 0x000fe200008e0625ULL,
0x0000002e0e2e7210ULL, 0x000fe20007f3e0ffULL, 0x000001002b2a7825ULL, 0x000fe200078e0034ULL,
0x0000002c0e2c7210ULL, 0x000fc60007f1e0ffULL, 0x0000010031307825ULL, 0x000fe200078e0034ULL,
0x0000002d0f2d7210ULL, 0x000fc600007fe4ffULL, 0x0000010033327825ULL, 0x000fe200078e0034ULL,
0x000000300e307210ULL, 0x000fc60007f1e0ffULL, 0x000000010f197824ULL, 0x000fe200010e0619ULL,
0x000000280e287210ULL, 0x000fe20007f5e0ffULL, 0x0000010003347825ULL, 0x000fe200078e0034ULL,
0x0000000707037211ULL, 0x000fe400078fe8ffULL, 0x000000310f317210ULL, 0x000fe200007fe4ffULL,
0x000000010f1f7824ULL, 0x040fe200018e061fULL, 0x0000002a0e2a7210ULL, 0x000fe20007f7e0ffULL,
0x000000010f2f7824ULL, 0x040fe200008e062fULL, 0x000000070c3a7812ULL, 0x000fe200078ef803ULL,
0x000000010f297824ULL, 0x040fe200010e0629ULL, 0x000000320e327210ULL, 0x000fe20007f3e0ffULL,
0x00004000380d7836ULL, 0x000fe20000000000ULL, 0x000000340e0e7210ULL, 0x000fe20007f5e0ffULL,
0x000000010f2b7824ULL, 0x000fc400018e062bULL, 0x000000103a037824ULL, 0x000fe200078e020dULL,
0x0000000d3c277211ULL, 0x080fe200078e20ffULL, 0x000000010f337824ULL, 0x040fe200008e0633ULL,
0x0000000d443d7211ULL, 0x000fe200078e20ffULL, 0x000000010f0f7824ULL, 0x000fe200010e0635ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036037faeULL, 0x0003e2000b901c46ULL,
0x000000103e357824ULL, 0x100fe400078e020dULL, 0x0000001040397824ULL, 0x100fe200078e020dULL,
0x0000000010277faeULL, 0x0005e2000b901c46ULL, 0x00000010423b7824ULL, 0x000fc400078e020dULL,
0x00000010463f7824ULL, 0x100fe200078e020dULL, 0x0000000012357faeULL, 0x0007e2000b901c46ULL,
0x0000001048037824ULL, 0x002fc600078e020dULL, 0x0000000014397faeULL, 0x0003e2000b901c46ULL,
0x000000104a117824ULL, 0x004fc600078e020dULL, 0x00000000163b7faeULL, 0x0005e2000b901c46ULL,
0x0000000d4c137211ULL, 0x008fc600078e20ffULL, 0x00000000183d7faeULL, 0x0007e2000b901c46ULL,
0x000000104e157824ULL, 0x002fc600078e020dULL, 0x000000001e3f7faeULL, 0x0003e2000b901c46ULL,
0x0000001050177824ULL, 0x004fc600078e020dULL, 0x0000000020037faeULL, 0x0005e2000b901c46ULL,
0x0000001052197824ULL, 0x008fc600078e020dULL, 0x0000000024117faeULL, 0x0007e2000b901c46ULL,
0x0000000d541f7211ULL, 0x002fc600078e20ffULL, 0x0000000028137faeULL, 0x0007e2000b901c46ULL,
0x0000001056037824ULL, 0x004fc600078e020dULL, 0x000000002a157faeULL, 0x0007e2000b901c46ULL,
0x0000001058217824ULL, 0x000fc600078e020dULL, 0x000000002c177faeULL, 0x0007e8000b901c46ULL,
0x000000002e197faeULL, 0x0007e8000b901c46ULL, 0x00000000301f7faeULL, 0x0007e8000b901c46ULL,
0x0000000032037faeULL, 0x0007e8000b901c46ULL, 0x000000000e217faeULL, 0x0007e4000b901c46ULL,
0x0000000202027836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff037424ULL, 0x00afc600078e00ffULL, 0x0000001b0200720cULL, 0x000fda0003f06070ULL,
0x00009000ff148b82ULL, 0x000e620000000a00ULL, 0x000000029b0f8211ULL, 0x000fe400078e08ffULL,
0x0000000807127812ULL, 0x000fe400078ec0ffULL, 0x00000004ff167819ULL, 0x100fe40000011607ULL,
0x00000003ff107819ULL, 0x000fe20000011607ULL, 0x00002000380e7836ULL, 0x000fe20000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000040f148825ULL, 0x002fca00078e0014ULL,
0x0000000614038981ULL, 0x0002a2000c1e1900ULL, 0x0000000712117812ULL, 0x000fe200078ef807ULL,
0x0000000816247824ULL, 0x000fe200078e00ffULL, 0x00000007070f7812ULL, 0x000fe200078ec0ffULL,
0x0000000126a17824ULL, 0x000fe200078e0223ULL, 0x0000001011137812ULL, 0x040fe200078efcffULL,
0x0000001011207824ULL, 0x040fe200078e00ffULL, 0x0000000110177812ULL, 0x000fe400078ec0ffULL,
0x0000001116127210ULL, 0x000fe20007ffe0ffULL, 0x0000001011157824ULL, 0x002fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee20fULL, 0x0000000116147824ULL, 0x000fe200078e0213ULL,
0x00000002121f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001013197824ULL, 0x000fe200078e00ffULL,
0xfffffff015167812ULL, 0x000fe200078ee212ULL, 0x0000000117797824ULL, 0x040fe200078e0224ULL,
0x0000001024707810ULL, 0x000fe20007ffe0ffULL, 0x0000000824187824ULL, 0x000fe200078e00ffULL,
0xfffffff020207812ULL, 0x000fe200078ee21fULL, 0x0000003024787836ULL, 0x000fe20000000000ULL,
0x00000003702a7819ULL, 0x000fe200000006ffULL, 0x00000020247a7836ULL, 0x000fe20000000000ULL,
0xfffffff818157812ULL, 0x000fe200078ee279ULL, 0x00000010165c7824ULL, 0x100fe200078e021dULL,
0xfffffff019167812ULL, 0x000fe200078ee214ULL, 0x0000000117187824ULL, 0x040fe200078e0270ULL,
0x00000078171e7210ULL, 0x000fe20007ffe0ffULL, 0x0000000117197824ULL, 0x000fe200078e027aULL,
0x0000000e15547211ULL, 0x080fe200078e20ffULL, 0x0000000870177824ULL, 0x000fe200078e00ffULL,
0x000000005c5c783bULL, 0x000fe20000000200ULL, 0x000000087a287824ULL, 0x040fe200078e00ffULL,
0x000000037a7f7819ULL, 0x000fe200000006ffULL, 0x0000000878217824ULL, 0x000fe200078e00ffULL,
0x000000005454783bULL, 0x000e620000000200ULL, 0x0000001016907824ULL, 0x100fe200078e021dULL,
0xfffffff817167812ULL, 0x000fe200078ee218ULL, 0x00000012791f7836ULL, 0x000fe20000000000ULL,
0xfffffff828177812ULL, 0x000fe200078ee219ULL, 0x0000000214197836ULL, 0x000fe20000000000ULL,
0xfffffff821187812ULL, 0x000fe200078ee21eULL, 0x0000001016587824ULL, 0x100fe200078e020eULL,
0x000000009090783bULL, 0x000ee20000000200ULL, 0x0000001017687824ULL, 0x100fe200078e020eULL,
0x0000000413287819ULL, 0x000fe200000006ffULL, 0x0000001018607824ULL, 0x100fe200078e020eULL,
0x00000002791e7810ULL, 0x000fe20007ffe0ffULL, 0x000000005858783bULL, 0x000f220000000200ULL,
0x0000000824217824ULL, 0x000fe200078e00ffULL, 0xfffffff028287812ULL, 0x000fe200078ee219ULL,
0x0000001020487824ULL, 0x100fe200078e021dULL, 0x000000006868783bULL, 0x000f620000000200ULL,
0x0000003279207836ULL, 0x000fe20000000000ULL, 0xfffffff821197812ULL, 0x000fe200078ee21eULL,
0x0000000878217824ULL, 0x000fe200078e00ffULL, 0x000000006060783bULL, 0x000f220000000200ULL,
0xfffffff82a1e7812ULL, 0x000fe200078ee21fULL, 0x00000022791f7836ULL, 0x000fe20000000000ULL,
0x0000000e19307211ULL, 0x080fe200078e20ffULL, 0x000000087a2a7824ULL, 0x000fe200078e00ffULL,
0xfffffff821207812ULL, 0x000fe200078ee220ULL, 0x0000001028887824ULL, 0x000fe200078e021dULL,
0x0000000e1e507211ULL, 0x000fe200078e20ffULL, 0x000000004848783bULL, 0x000fe20000000200ULL,
0xfffffff82a1f7812ULL, 0x000fe200078ee21fULL, 0x00000010208c7824ULL, 0x000fc400078e020eULL,
0x000000003030783bULL, 0x000f620000000200ULL, 0x0000000412217836ULL, 0x000fe40000000000ULL,
0x000000101f647824ULL, 0x000fe200078e020eULL, 0x000000008888783bULL, 0x000f620000000200ULL,
0x0000000414257836ULL, 0x000fe20000000000ULL, 0x000000545c94723cULL, 0x002fe400000018ffULL,
0x000000005050783bULL, 0x000e620000000200ULL, 0x0000000479277836ULL, 0x000fe40000000000ULL,
0x0000000679987836ULL, 0x000fe20000000000ULL, 0x000000006464783bULL, 0x000e620000000200ULL,
0x000000565c2c723cULL, 0x000fe200000018ffULL, 0x00000008707e7824ULL, 0x000fc400078e00ffULL,
0x000000008c8c783bULL, 0x000e620000000200ULL, 0x00000010137d7824ULL, 0x000fe400078e00ffULL,
0x000000549028723cULL, 0x008fe200000018ffULL, 0x0000000878817824ULL, 0x000fe400078e00ffULL,
0x00000036799a7836ULL, 0x000fe40000000000ULL, 0x00000016799d7836ULL, 0x000fe20000000000ULL,
0x000000569054723cULL, 0x000fe200000018ffULL, 0x00000026799c7836ULL, 0x000fe20000000000ULL,
0xfffffff8819a7812ULL, 0x000fc400078ee29aULL, 0xfffffff87e9d7812ULL, 0x000fe400078ee29dULL,
0x000000585c34723cULL, 0x010fe200000018ffULL, 0xfffffff87f9c7812ULL, 0x000fe400078ee29cULL,
0x0000000e9d847211ULL, 0x000fc600078e20ffULL, 0x0000005a5c38723cULL, 0x000fe200000018ffULL,
0x000000109ca07824ULL, 0x000fe400078e020eULL, 0x000000008484783bULL, 0x000fe60000000200ULL,
0x000000685c3c723cULL, 0x020fec00000018ffULL, 0x0000006a5c40723cULL, 0x000fec00000018ffULL,
0x000000605c44723cULL, 0x000fec00000018ffULL, 0x000000625c5c723cULL, 0x000fec00000018ffULL,
0x00000058904c723cULL, 0x000fec00000018ffULL, 0x0000005a9058723cULL, 0x000fec00000018ffULL,
0x000000304894723cULL, 0x000fec0000001894ULL, 0x000000308828723cULL, 0x000fec0000001828ULL,
0x00000032482c723cULL, 0x000fec000000182cULL, 0x000000328830723cULL, 0x000fec0000001854ULL,
0x000000689054723cULL, 0x000fec00000018ffULL, 0x0000006a9068723cULL, 0x000fec00000018ffULL,
0x000000504834723cULL, 0x002fec0000001834ULL, 0x000000524838723cULL, 0x000fec0000001838ULL,
0x00000064483c723cULL, 0x000fec000000183cULL, 0x000000664840723cULL, 0x000fec0000001840ULL,
0x0000008c4844723cULL, 0x000fec0000001844ULL, 0x0000008e4848723cULL, 0x000fec000000185cULL,
0x00000050884c723cULL, 0x000fe2000000184cULL, 0x00000010115c7824ULL, 0x000fc400078e00ffULL,
0x00000010135e7824ULL, 0x000fc600078e00ffULL, 0x000000609074723cULL, 0x000fe200000018ffULL,
0x0000000411517819ULL, 0x000fe400000006ffULL, 0x0000000612507810ULL, 0x000fe40007ffe0ffULL,
0xfffffff05c5c7812ULL, 0x000fe200078ee221ULL, 0x000000629090723cULL, 0x000fe200000018ffULL,
0x0000000824607824ULL, 0x000fe200078e00ffULL, 0xfffffff0517c7812ULL, 0x000fe400078ee250ULL,
0xfffffff05e5e7812ULL, 0x000fe200078ee225ULL, 0x0000003479257836ULL, 0x000fe20000000000ULL,
0x000000528850723cULL, 0x000fe20000001858ULL, 0xfffffff860217812ULL, 0x000fc400078ee227ULL,
0x0000002479277810ULL, 0x000fe20007ffe0ffULL, 0x000000105e607824ULL, 0x100fe400078e021dULL,
0x000000648854723cULL, 0x000fe20000001854ULL, 0x000000087a587824ULL, 0x000fe400078e00ffULL,
0x00000008245b7824ULL, 0x000fe200078e00ffULL, 0x0000001479247810ULL, 0x000fe20007ffe0ffULL,
0x0000000870597824ULL, 0x000fe200078e00ffULL, 0xfffffff858277812ULL, 0x000fe200078ee227ULL,
0x00000008785a7824ULL, 0x000fe200078e00ffULL, 0xfffffff85b987812ULL, 0x000fe200078ee298ULL,
0x000000105c587824ULL, 0x100fe200078e021dULL, 0xfffffff859247812ULL, 0x000fe200078ee224ULL,
0x00000010276c7824ULL, 0x100fe200078e020eULL, 0xfffffff85a257812ULL, 0x000fe200078ee225ULL,
0x000000668864723cULL, 0x000fe20000001868ULL, 0x0000000e215c7211ULL, 0x080fe200078e20ffULL,
0x00000010247b7824ULL, 0x000fe200078e020eULL, 0x0000000e25717211ULL, 0x000fe200078e20ffULL,
0x000000005858783bULL, 0x000fe20000000200ULL, 0x0000000614787810ULL, 0x000fe20007ffe0ffULL,
0x0000008c8874723cULL, 0x000fe40000001874ULL, 0x000000005c5c783bULL, 0x000e620000000200ULL,
0xfffffff07d7a7812ULL, 0x000fe200078ee278ULL, 0x000000107c787824ULL, 0x000fc400078e021dULL,
0x000000006060783bULL, 0x000ee20000000200ULL, 0x0000008e8888723cULL, 0x000fe20000001890ULL,
0x00000010987c7824ULL, 0x100fe400078e020eULL, 0x000000007b68783bULL, 0x000f220000000200ULL,
0x000000107a807824ULL, 0x000fe400078e021dULL, 0x000000109a8c7824ULL, 0x000fe200078e020eULL,
0x000000006c6c783bULL, 0x000f680000000200ULL, 0x000000007170783bULL, 0x000ea80000000200ULL,
0x000000007878783bULL, 0x000fe80000000200ULL, 0x000000007c7c783bULL, 0x000ea80000000200ULL,
0x000000008080783bULL, 0x000ea80000000200ULL, 0x000000008c8c783bULL, 0x000ea80000000200ULL,
0x00000000a090783bULL, 0x000ea20000000200ULL, 0x0000005c5894723cULL, 0x002fec0000001894ULL,
0x0000005c6028723cULL, 0x008fec0000001828ULL, 0x0000005e582c723cULL, 0x000fec000000182cULL,
0x0000005e6030723cULL, 0x000fec0000001830ULL, 0x000000685834723cULL, 0x010fec0000001834ULL,
0x0000006a5838723cULL, 0x000fec0000001838ULL, 0x0000006c583c723cULL, 0x020fec000000183cULL,
0x0000006e5840723cULL, 0x000fec0000001840ULL, 0x000000705844723cULL, 0x004fec0000001844ULL,
0x000000725848723cULL, 0x000fec0000001848ULL, 0x00000068604c723cULL, 0x000fe2000000184cULL,
0x00000001a1597810ULL, 0x000fe20007ffe0ffULL, 0x00000100a15a7824ULL, 0x000fc600078e0206ULL,
0x0000001a5900720cULL, 0x000fe20003f06070ULL, 0x0000006a6050723cULL, 0x000fe20000001850ULL,
0x000000405a587812ULL, 0x000fe200078ec0ffULL, 0x0000000403597224ULL, 0x000fc800078e02ffULL,
0x000000706074723cULL, 0x000fe20000001874ULL, 0x00000100599e7825ULL, 0x000fca00078e009eULL,
0x0000006c6054723cULL, 0x000fec0000001854ULL, 0x0000006e6064723cULL, 0x000fec0000001864ULL,
0x000000726088723cULL, 0x000fec0000001888ULL, 0x0000007c7894723cULL, 0x000fe20000001894ULL,
0x0000000105637824ULL, 0x000fca00078e0258ULL, 0x0000007c8028723cULL, 0x000fec0000001828ULL,
0x0000007e782c723cULL, 0x000fec000000182cULL, 0x0000007e8030723cULL, 0x000fec0000001830ULL,
0x000000847834723cULL, 0x000fec0000001834ULL, 0x000000867838723cULL, 0x000fec0000001838ULL,
0x0000008c7844723cULL, 0x000fec0000001844ULL, 0x00000090783c723cULL, 0x000fec000000183cULL,
0x000000927840723cULL, 0x000fec0000001840ULL, 0x0000008e7848723cULL, 0x000fec0000001848ULL,
0x00000084804c723cULL, 0x000fec000000184cULL, 0x000000868050723cULL, 0x000fec0000001850ULL,
0x000000908054723cULL, 0x000fec0000001854ULL, 0x000000928064723cULL, 0x000fec0000001864ULL,
0x0000008c8074723cULL, 0x000fec0000001874ULL, 0x0000008e8088723cULL, 0x000fe20000001888ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000c00108947ULL, 0x000fde0003800000ULL,
0x00000004105c7836ULL, 0x000fe20000000000ULL, 0x0000000810607810ULL, 0x000fe20007ffe0ffULL,
0x0000000110597824ULL, 0x100fe200078e0207ULL, 0x0000005a1c697248ULL, 0x000fe20007fe0000ULL,
0x000000015c587824ULL, 0x040fe200078e0207ULL, 0x00000007605b7210ULL, 0x000fe20007ffe0ffULL,
0x000000085c737824ULL, 0x000fe200078e00ffULL, 0x000000070c717812ULL, 0x000fe200078ef859ULL,
0x00000008605e7824ULL, 0x000fe200078e00ffULL, 0x0000000c100c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000169697824ULL, 0x000fe200078e0a5aULL, 0xfffffff873737812ULL, 0x000fe200078ee258ULL,
0x0000000110587824ULL, 0x000fe200078e0263ULL, 0xfffffff85e797812ULL, 0x000fe200078ee25bULL,
0x000000080c5e7824ULL, 0x000fe200078e00ffULL, 0x000000070c5b7210ULL, 0x000fe20007ffe0ffULL,
0x0000010058587825ULL, 0x000fe200078e00ffULL, 0x000000695c00720cULL, 0x000fc40003f46070ULL,
0xfffffff85e7b7812ULL, 0x000fe200078ee25bULL, 0x0000001010627836ULL, 0x000fe20000000000ULL,
0x0000000b585f7212ULL, 0x000fe200078efcffULL, 0x000000015c5a7824ULL, 0x000fe200078e0263ULL,
0x000000696000720cULL, 0x080fe20003f66070ULL, 0x0000001410687836ULL, 0x000fe20000000000ULL,
0x0000005f9e5e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001625c7824ULL, 0x000fe200078e0207ULL,
0x000000691000720cULL, 0x080fe20003f26070ULL, 0x00000008627d7824ULL, 0x000fe200078e00ffULL,
0x0000000768587210ULL, 0x000fe20007ffe0ffULL, 0x000001005a5a7825ULL, 0x000fe200078e00ffULL,
0x000000690c00720cULL, 0x000fc40003fa6070ULL, 0xfffffff87d7d7812ULL, 0x000fe200078ee25cULL,
0x00000008687f7824ULL, 0x000fe200078e00ffULL, 0x0000000b5a617212ULL, 0x080fe200078efcffULL,
0x000000010c5c7824ULL, 0x000fe200078e0263ULL, 0x0000000e71717211ULL, 0x000fe200078e20ffULL,
0x000000019f5f7824ULL, 0x000fe200000e0659ULL, 0xfffffff87f7f7812ULL, 0x000fe200078ee258ULL,
0x000001005c5c7825ULL, 0x000fe200078e00ffULL, 0x0000006360587210ULL, 0x000fe40007ffe0ffULL,
0x000000619e607210ULL, 0x000fe20007f1e0ffULL, 0x00000001625a7824ULL, 0x000fe200078e0263ULL,
0x0000000b5c6d7212ULL, 0x000fe200078efcffULL, 0x0000010058587825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000005e717faeULL, 0x0003e2000c901c46ULL,
0x000000696200720cULL, 0x000fc40003f86070ULL, 0x000000019f617824ULL, 0x000fe200000e065bULL,
0x0000006d9e6c7210ULL, 0x000fe20007fde0ffULL, 0x000001005a5a7825ULL, 0x000fe200078e00ffULL,
0x0000000b586b7212ULL, 0x080fe400078efcffULL, 0x0000000e79797211ULL, 0x080fe200078e20ffULL,
0x000000019f6d7824ULL, 0x000fe200030e065dULL, 0x0000000b5a6f7212ULL, 0x000fe200078efcffULL,
0x00000001685a7824ULL, 0x040fe200078e0263ULL, 0x0000006b9e6a7210ULL, 0x000fe20007f1e0ffULL,
0x00000018106e7836ULL, 0x000fe20000000000ULL, 0x0000006f9e587210ULL, 0x000fe20007fde0ffULL,
0x0000001073737824ULL, 0x100fe200078e020eULL, 0x0000000e7b7b7211ULL, 0x080fe200078e20ffULL,
0x000000019f6b7824ULL, 0x040fe200000e0659ULL, 0x000000076e0c7210ULL, 0x000fe20007ffe0ffULL,
0x000000019f597824ULL, 0x000fe200030e065bULL, 0x000000696800720cULL, 0x080fe20003f06070ULL,
0x000001005a5a7825ULL, 0x000fe200078e00ffULL, 0x0000002010687810ULL, 0x000fe20007ffe0ffULL,
0x0000000060737faeULL, 0x0005e2000d101c46ULL, 0x000000696e00720cULL, 0x040fe20003f26070ULL,
0x000000086e817824ULL, 0x000fe200078e00ffULL, 0x0000000b5a5d7212ULL, 0x080fe200078efcffULL,
0x000000016e5c7824ULL, 0x000fe200078e0263ULL, 0x000000006a797faeULL, 0x0007e2000d901c46ULL,
0x000000107d7d7824ULL, 0x000fe200078e020eULL, 0x0000005d9e5a7210ULL, 0x000fe20007fde0ffULL,
0x000001005c5c7825ULL, 0x000fe200078e00ffULL, 0xfffffff881817812ULL, 0x000fe200078ee20cULL,
0x000000006c7b7faeULL, 0x000fe2000e901c46ULL, 0x00000007686e7210ULL, 0x000fe20007ffe0ffULL,
0x0000001c100c7836ULL, 0x000fe20000000000ULL, 0x0000000b5c5f7212ULL, 0x002fe200078efcffULL,
0x000000019f5b7824ULL, 0x000fe200030e065bULL, 0x00000000587d7faeULL, 0x0003e2000e101c46ULL,
0x000000010c5e7824ULL, 0x040fe200078e0263ULL, 0x0000005f9e5c7210ULL, 0x000fe20007fde0ffULL,
0x000000010c627824ULL, 0x040fe200078e0207ULL, 0x000000690c00720cULL, 0x0c0fe20003f46070ULL,
0x000000080c837824ULL, 0x000fe200078e00ffULL, 0x000000696800720cULL, 0x000fe20003f66070ULL,
0x000001005e5e7825ULL, 0x000fe200078e00ffULL, 0x0000000e7f7f7211ULL, 0x000fc400078e20ffULL,
0xfffffff883837812ULL, 0x000fe200078ee262ULL, 0x00000001680c7824ULL, 0x000fe200078e0263ULL,
0x0000000b5e6f7212ULL, 0x080fe200078efcffULL, 0x0000002410627836ULL, 0x000fe20000000000ULL,
0x000000005a7f7faeULL, 0x0009e2000c101c46ULL, 0x000001000c607825ULL, 0x004fe200078e00ffULL,
0x0000000e81817211ULL, 0x000fe400078e20ffULL, 0x00000063626a7210ULL, 0x008fe20007ffe0ffULL,
0x000000019f5d7824ULL, 0x040fe200030e065dULL, 0x0000006f9e5e7210ULL, 0x000fe20007fde0ffULL,
0x00000001620c7824ULL, 0x000fe200078e0207ULL, 0x0000000b606b7212ULL, 0x000fe200078efcffULL,
0x0000000862737824ULL, 0x040fe200078e00ffULL, 0x000000696200720cULL, 0x000fe20003fa6070ULL,
0x000000019f5f7824ULL, 0x040fe200030e065fULL, 0x0000006b9e607210ULL, 0x000fe20007fde0ffULL,
0x000001006a6a7825ULL, 0x000fe200078e00ffULL, 0xfffffff873737812ULL, 0x000fe200078ee20cULL,
0x000000005c817faeULL, 0x0005e2000c901c46ULL, 0x00000028100c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000868857824ULL, 0x000fe200078e00ffULL, 0x0000000b6a6f7212ULL, 0x000fe200078efcffULL,
0x000000019f617824ULL, 0x000fe200030e0661ULL, 0x000000690c00720cULL, 0x040fe20003f86070ULL,
0x000000010c627824ULL, 0x040fe200078e0207ULL, 0xfffffff885857812ULL, 0x000fe200078ee26eULL,
0x000000080c797824ULL, 0x040fe200078e00ffULL, 0x0000006f9e6e7210ULL, 0x000fe20007fde0ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0263ULL, 0x0000003c10707810ULL, 0x000fe20007ffe0ffULL,
0x0000003010687836ULL, 0x000fe20000000000ULL, 0xfffffff879797812ULL, 0x000fe200078ee262ULL,
0x0000002c10627836ULL, 0x000fc40000000000ULL, 0x000001000c587825ULL, 0x002fe200078e00ffULL,
0x000000696800720cULL, 0x000fe40003f26070ULL, 0x00000063626a7210ULL, 0x000fe20007ffe0ffULL,
0x000000019f6f7824ULL, 0x000fe200030e066bULL, 0x0000000b586b7212ULL, 0x000fe200078efcffULL,
0x00000001686c7824ULL, 0x000fe200078e0263ULL, 0x000000696200720cULL, 0x040fe20003f06070ULL,
0x00000001620c7824ULL, 0x000fe200078e0207ULL, 0x0000006b9e587210ULL, 0x000fe20007fde0ffULL,
0x000001006a6a7825ULL, 0x000fc800078e00ffULL, 0x00000008627b7824ULL, 0x000fe200078e00ffULL,
0x0000000b6a5b7212ULL, 0x010fe200078efcffULL, 0x000001006c6c7825ULL, 0x000fc600078e00ffULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee20cULL, 0x0000003410627836ULL, 0x000fe20000000000ULL,
0x0000000b6c717212ULL, 0x000fe200078efcffULL, 0x000000019f597824ULL, 0x000fe200030e0659ULL,
0x0000005b9e5a7210ULL, 0x000fe20007fde0ffULL, 0x00000001625c7824ULL, 0x004fe200078e0263ULL,
0x0000000e7b7b7211ULL, 0x000fe200078e20ffULL, 0x0000001083837824ULL, 0x000fe200078e020eULL,
0x0000006b9f5b7210ULL, 0x000fe200037fe4ffULL, 0x000001005c5c7825ULL, 0x000fe200078e00ffULL,
0x000000719e6a7210ULL, 0x000fc40007fde0ffULL, 0x000000005e837faeULL, 0x0003e2000d101c46ULL,
0x0000001085857824ULL, 0x100fe200078e020eULL, 0x0000006d9f6b7210ULL, 0x000fe200037fe4ffULL,
0x0000001073737824ULL, 0x000fe200078e020eULL, 0x0000000b5c6d7212ULL, 0x000fe200078efcffULL,
0x00000038106c7836ULL, 0x000fe20000000000ULL, 0x0000000060857faeULL, 0x0005e2000d901c46ULL,
0x00000001680c7824ULL, 0x000fe200078e0207ULL, 0x000000697000720cULL, 0x080fe20003f46070ULL,
0x00000008687d7824ULL, 0x000fe200078e00ffULL, 0x0000006d9e687210ULL, 0x000fe20007fde0ffULL,
0x000000016c5c7824ULL, 0x100fe200078e0263ULL, 0x000000006e737faeULL, 0x0007e2000e901c46ULL,
0x000000696200720cULL, 0x080fe20003fa6070ULL, 0x00000001705e7824ULL, 0x002fe200078e0263ULL,
0x000000696c00720cULL, 0x000fe20003f66070ULL, 0x000000019f697824ULL, 0x000fe200030e065dULL,
0xfffffff87d717812ULL, 0x000fe200078ee20cULL, 0x000001005c5c7825ULL, 0x000fe200078e00ffULL,
0x00000003626d7819ULL, 0x000fc600000006ffULL, 0x000001005e5e7825ULL, 0x000fe200078e00ffULL,
0x0000000b5c617212ULL, 0x004fc600078efcffULL, 0x00000001620c7824ULL, 0x100fe200078e0207ULL,
0x000000619e5c7210ULL, 0x000fe20007fde0ffULL, 0x000000016c607824ULL, 0x000fe200078e0207ULL,
0x0000000b5e0b7212ULL, 0x000fe200078efcffULL, 0x000000086c637824ULL, 0x000fe200078e00ffULL,
0x0000000770627210ULL, 0x000fe20007ffe0ffULL, 0x00000008706f7824ULL, 0x008fe200078e00ffULL,
0xfffffff86d617812ULL, 0x000fe200078ee20cULL, 0x000000019f5d7824ULL, 0x000fe200030e065dULL,
0xfffffff863637812ULL, 0x000fe200078ee260ULL, 0x0000001079797824ULL, 0x100fe200078e020eULL,
0x0000000b9e5e7210ULL, 0x000fe20007fde0ffULL, 0x0000001071717824ULL, 0x100fe200078e020eULL,
0xfffffff86f6d7812ULL, 0x000fe200078ee262ULL, 0x0000001061617824ULL, 0x100fe200078e020eULL,
0x0000000058797faeULL, 0x0003e2000e101c46ULL, 0x0000001063637824ULL, 0x000fe200078e020eULL,
0x0000000e6d6d7211ULL, 0x000fe200078e20ffULL, 0x000000019f5f7824ULL, 0x000fe200030e065fULL,
0x000000005a7b7faeULL, 0x0003e8000c101c46ULL, 0x000000006a717faeULL, 0x0003e8000c901c46ULL,
0x0000000068617faeULL, 0x0003e8000e901c46ULL, 0x000000005c637faeULL, 0x0003e8000d901c46ULL,
0x000000005e6d7faeULL, 0x0003e2000d101c46ULL, 0x0000000800c47947ULL, 0x000fea0003800000ULL,
0x00000008105c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000110597824ULL, 0x100fe200078e0207ULL,
0x0000003c10827810ULL, 0x000fe20007ffe0ffULL, 0x0000000c105e7836ULL, 0x000fe20000000000ULL,
0x000000075c5d7210ULL, 0x000fe20007ffe0ffULL, 0x000000085c607824ULL, 0x000fe200078e00ffULL,
0x000000070c5b7812ULL, 0x000fe200078ef859ULL, 0x0000001810687836ULL, 0x000fe20000000000ULL,
0x00000010100c7810ULL, 0x000fe20007ffe0ffULL, 0x00000004105a7836ULL, 0x000fe20000000000ULL,
0xfffffff860697812ULL, 0x000fe200078ee25dULL, 0x000000015e5f7824ULL, 0x040fe200078e0207ULL,
0x00000007685d7210ULL, 0x000fe20007ffe0ffULL, 0x000000085e627824ULL, 0x000fe200078e00ffULL,
0x0000000e5b817211ULL, 0x000fe200078e20ffULL, 0x00000008686c7824ULL, 0x000fc400078e00ffULL,
0x000000015a587824ULL, 0x140fe200078e0207ULL, 0xfffffff8626b7812ULL, 0x000fe200078ee25fULL,
0x000000085a617824ULL, 0x000fe200078e00ffULL, 0xfffffff86c717812ULL, 0x000fe200078ee25dULL,
0x0000001c106a7836ULL, 0x000fe20000000000ULL, 0x00000020106c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001410627836ULL, 0x000fe20000000000ULL, 0xfffffff861617812ULL, 0x000fe200078ee258ULL,
0x000000016a5f7824ULL, 0x040fe200078e0207ULL, 0x000000070c587210ULL, 0x000fe20007ffe0ffULL,
0x000000086a6e7824ULL, 0x000fc400078e00ffULL, 0x000000080c6d7824ULL, 0x000fe400078e00ffULL,
0x0000002c10727836ULL, 0x000fe20000000000ULL, 0xfffffff86e737812ULL, 0x000fe200078ee25fULL,
0x0000000162597824ULL, 0x140fe200078e0207ULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee258ULL,
0x0000000862607824ULL, 0x000fe200078e00ffULL, 0x000000076c587210ULL, 0x000fe20007ffe0ffULL,
0x0000002810707836ULL, 0x000fe20000000000ULL, 0x0000000e6d8d7211ULL, 0x080fe200078e20ffULL,
0x000000086c797824ULL, 0x000fe200078e00ffULL, 0xfffffff8606f7812ULL, 0x000fe200078ee259ULL,
0x00000001725f7824ULL, 0x140fe200078e0207ULL, 0x00000007705d7210ULL, 0x000fe20007ffe0ffULL,
0x00000008727a7824ULL, 0x000fe200078e00ffULL, 0xfffffff879797812ULL, 0x000fe200078ee258ULL,
0x00000024106e7836ULL, 0x000fe20000000000ULL, 0x0000006310587210ULL, 0x000fe20007ffe0ffULL,
0x0000000870787824ULL, 0x000fe200078e00ffULL, 0xfffffff87a7f7812ULL, 0x000fe200078ee25fULL,
0x000000016e597824ULL, 0x040fe200078e0207ULL, 0x000000636c6c7210ULL, 0x000fe20007ffe0ffULL,
0x000000086e607824ULL, 0x000fe200078e00ffULL, 0xfffffff8787d7812ULL, 0x000fe200078ee25dULL,
0x00000034107a7836ULL, 0x000fe20000000000ULL, 0x0000000e79a37211ULL, 0x000fe200078e20ffULL,
0x0000003010787836ULL, 0x000fe20000000000ULL, 0xfffffff8607b7812ULL, 0x000fe200078ee259ULL,
0x000000087a867824ULL, 0x000fe200078e00ffULL, 0x000000077a5f7210ULL, 0x000fe20007ffe0ffULL,
0x0000010058587825ULL, 0x000fe200078e00ffULL, 0x000000630c607210ULL, 0x000fc40007ffe0ffULL,
0xfffffff886ab7812ULL, 0x000fe200078ee25fULL, 0x00000038107e7836ULL, 0x000fe20000000000ULL,
0x00000063780c7210ULL, 0x000fe20007ffe0ffULL, 0x000000015a5a7824ULL, 0x000fe200078e0263ULL,
0x0000000b585f7212ULL, 0x000fe200078efcffULL, 0x00000001785d7824ULL, 0x000fe200078e0207ULL,
0x000000037eaf7819ULL, 0x000fe200000006ffULL, 0x0000000878847824ULL, 0x000fe200078e00ffULL,
0x0000005f9e587210ULL, 0x000fe20007f1e0ffULL, 0x000000015c5c7824ULL, 0x000fe400078e0263ULL,
0x000001005a5a7825ULL, 0x000fe200078e00ffULL, 0x000000599f597210ULL, 0x000fc600007fe4ffULL,
0x000000017e807824ULL, 0x000fe200078e0263ULL, 0x0000000b5a5f7212ULL, 0x000fe200078efcffULL,
0x000000017e787824ULL, 0x000fe200078e0207ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000058817faeULL, 0x0003e2000b901c46ULL, 0x000000015e5e7824ULL, 0x100fe200078e0263ULL,
0x0000005f9e5a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000162627824ULL, 0x100fe200078e0263ULL,
0xfffffff8afaf7812ULL, 0x000fe200078ee278ULL, 0x0000000168687824ULL, 0x100fe400078e0263ULL,
0x000000016a6a7824ULL, 0x000fc400078e0263ULL, 0x000000016e6e7824ULL, 0x100fe400078e0263ULL,
0x0000000170707824ULL, 0x100fe400078e0263ULL, 0x0000000172727824ULL, 0x100fe400078e0263ULL,
0x000000017a7c7824ULL, 0x100fe400078e0263ULL, 0x00000001827e7824ULL, 0x000fe200078e0263ULL,
0xfffffff884637812ULL, 0x000fe200078ee25dULL, 0x000001005c5c7825ULL, 0x000fc600078e00ffULL,
0x0000000e63ad7211ULL, 0x000fe200078e20ffULL, 0x000001005e5e7825ULL, 0x000fe200078e00ffULL,
0x0000000b5c637212ULL, 0x000fc600078efcffULL, 0x000000106b877824ULL, 0x000fe200078e020eULL,
0x000000639e5c7210ULL, 0x000fe20007f1e0ffULL, 0x0000010062627825ULL, 0x000fe200078e00ffULL,
0x0000000b5e6b7212ULL, 0x000fc600078efcffULL, 0x000000019f5d7824ULL, 0x000fe200000e065dULL,
0x0000006b9e5e7210ULL, 0x000fe20007f1e0ffULL, 0x0000001069857824ULL, 0x100fe200078e020eULL,
0x0000000b626b7212ULL, 0x000fe200078efcffULL, 0x0000001061837824ULL, 0x000fe400078e020eULL,
0x0000010068687825ULL, 0x000fc800078e00ffULL, 0x0000010060607825ULL, 0x000fc800078e00ffULL,
0x000000019f5f7824ULL, 0x000fe200000e065fULL, 0x0000006b9e627210ULL, 0x000fe20007f1e0ffULL,
0x000000106f8f7824ULL, 0x000fe200078e020eULL, 0x0000000b686f7212ULL, 0x080fe200078efcffULL,
0x000001006a6a7825ULL, 0x000fe200078e00ffULL, 0x0000000b606d7212ULL, 0x080fe400078efcffULL,
0x0000006f9e687210ULL, 0x000fe20007f5e0ffULL, 0x000000019f5b7824ULL, 0x000fe200008e065bULL,
0x0000000b6a797212ULL, 0x000fe200078efcffULL, 0x000001006e6e7825ULL, 0x000fe200078e00ffULL,
0x0000006d9e607210ULL, 0x000fc40007f3e0ffULL, 0x000000005a837faeULL, 0x0003e2000b901c46ULL,
0x000001006c6c7825ULL, 0x000fe200078e00ffULL, 0x000000619f617210ULL, 0x000fe40000ffe4ffULL,
0x000000005c857faeULL, 0x0003e2000b901c46ULL, 0x000000019f637824ULL, 0x000fe200000e0663ULL,
0x000000799e6a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001073937824ULL, 0x100fe200078e020eULL,
0x0000000b6e797212ULL, 0x080fe200078efcffULL, 0x000000107ba57824ULL, 0x100fe200078e020eULL,
0x0000000b6c7b7212ULL, 0x000fe200078efcffULL, 0x0000001071917824ULL, 0x000fe200078e020eULL,
0x000000005e877faeULL, 0x0003e2000b901c46ULL, 0x0000010072727825ULL, 0x000fe200078e00ffULL,
0x0000007b9e6c7210ULL, 0x000fc40007f3e0ffULL, 0x00000000608d7faeULL, 0x0003e2000b901c46ULL,
0x0000010070707825ULL, 0x000fe200078e00ffULL, 0x0000000b727b7212ULL, 0x080fe400078efcffULL,
0x0000006d9f6d7210ULL, 0x000fe20000ffe4ffULL, 0x000000019f6b7824ULL, 0x000fe200000e066bULL,
0x000000799e6e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001827a7824ULL, 0x040fe200078e0207ULL,
0x00000000628f7faeULL, 0x0003e2000b901c46ULL, 0x0000000882b37824ULL, 0x000fe400078e00ffULL,
0x000000107da77824ULL, 0x000fe200078e020eULL, 0x0000000b707d7212ULL, 0x000fe200078efcffULL,
0x000000019f6f7824ULL, 0x040fe200000e066fULL, 0xfffffff8b3b37812ULL, 0x000fe200078ee27aULL,
0x000000019f697824ULL, 0x000fe200010e0669ULL, 0x0000007b9e727210ULL, 0x000fe20007f1e0ffULL,
0x000001000c787825ULL, 0x000fe200078e00ffULL, 0x0000007d9e707210ULL, 0x000fc40007f5e0ffULL,
0x0000000068917faeULL, 0x0003e2000b901c46ULL, 0x000001007c7a7825ULL, 0x000fc600078e00ffULL,
0x000000006a937faeULL, 0x0003e2000b901c46ULL, 0x000000107fa97824ULL, 0x100fe400078e020eULL,
0x00000100807c7825ULL, 0x000fe200078e00ffULL, 0x000000006ca37faeULL, 0x0003e6000b901c46ULL,
0x000001007e7e7825ULL, 0x000fe200078e00ffULL, 0x000000006ea57faeULL, 0x0003e6000b901c46ULL,
0x00000010abb17824ULL, 0x100fe200078e020eULL, 0x0000000b78ab7212ULL, 0x080fe200078efcffULL,
0x00000010afb57824ULL, 0x100fe200078e020eULL, 0x0000000b7aaf7212ULL, 0x080fe200078efcffULL,
0x00000010b3b77824ULL, 0x000fe200078e020eULL, 0x0000000b7cb37212ULL, 0x080fe200078efcffULL,
0x000000019f737824ULL, 0x040fe200000e0673ULL, 0x0000000b7e0b7212ULL, 0x000fe200078efcffULL,
0x000000019f717824ULL, 0x000fe200010e0671ULL, 0x000000ab9e787210ULL, 0x000fc40007f1e0ffULL,
0x000000af9e7a7210ULL, 0x000fe40007f3e0ffULL, 0x000000b39e7c7210ULL, 0x000fe20007f5e0ffULL,
0x0000000070a77faeULL, 0x0003e2000b901c46ULL, 0x0000000b9e7e7210ULL, 0x000fe20007f7e0ffULL,
0x000000019f7b7824ULL, 0x040fe200008e067bULL, 0x000000799f797210ULL, 0x000fe200007fe4ffULL,
0x000000019f7d7824ULL, 0x040fe200010e067dULL, 0x0000000072a97faeULL, 0x0003e2000b901c46ULL,
0x000000019f7f7824ULL, 0x000fc600018e067fULL, 0x0000000078ad7faeULL, 0x0003e8000b901c46ULL,
0x000000007ab17faeULL, 0x0003e8000b901c46ULL, 0x000000007cb57faeULL, 0x0003e8000b901c46ULL,
0x000000007eb77faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000010110c7824ULL, 0x000fe200078e00ffULL, 0x00000008120b7810ULL, 0x000fe20007ffe0ffULL,
0x00000008140e7836ULL, 0x000fe20000000000ULL, 0x0000000d15587211ULL, 0x082fe200078e20ffULL,
0x0000001013597824ULL, 0x000fe200078e00ffULL, 0xfffffff00c0c7812ULL, 0x000fe200078ee20bULL,
0x0000001016707824ULL, 0x100fe200078e020dULL, 0x0000000d18687211ULL, 0x080fe200078e20ffULL,
0x00000010176c7824ULL, 0x000fe200078e020dULL, 0xfffffff0590e7812ULL, 0x000fe200078ee20eULL,
0x000000100c0c7824ULL, 0x100fe200078e021dULL, 0x0000000d1e907211ULL, 0x080fe200078e20ffULL,
0x0000000a120b7836ULL, 0x000fe20000000000ULL, 0x0000000d9d157211ULL, 0x000fe200078e20ffULL,
0x000000100e0e7824ULL, 0x000fc400078e021dULL, 0x0000001011167824ULL, 0x000fe400078e00ffULL,
0x000000101f807824ULL, 0x100fe400078e020dULL, 0x0000001019787824ULL, 0x100fe200078e020dULL,
0xfffffff016167812ULL, 0x000fe200078ee20bULL, 0x00000010208c7824ULL, 0x000fe200078e020dULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000000c5c783bULL, 0x0003e20000000200ULL,
0x0000000a140b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001016167824ULL, 0x000fe400078e021dULL,
0x000000007070783bULL, 0x000ea80000000200ULL, 0x000000005858783bULL, 0x000ee20000000200ULL,
0x00000010130c7824ULL, 0x002fc600078e00ffULL, 0x000000006c6c783bULL, 0x000fe40000000200ULL,
0xfffffff00c0c7812ULL, 0x000fe400078ee20bULL, 0x000000006868783bULL, 0x000fe20000000200ULL,
0x0000000c120b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000e12127836ULL, 0x000fe40000000000ULL,
0x000000000e60783bULL, 0x0003220000000200ULL, 0x000000100c0c7824ULL, 0x000fc600078e021dULL,
0x00000000167c783bULL, 0x000fe80000000200ULL, 0x000000009090783bULL, 0x000f620000000200ULL,
0x00000010130e7824ULL, 0x042fe400078e00ffULL, 0x0000001013137824ULL, 0x000fe200078e00ffULL,
0x000000000c84783bULL, 0x0003680000000200ULL, 0x000000008080783bULL, 0x000f680000000200ULL,
0x000000007878783bULL, 0x000f620000000200ULL, 0x00000010110c7824ULL, 0x002fc400078e00ffULL,
0x0000001011117824ULL, 0x000fe200078e00ffULL, 0x000000705c34723cULL, 0x004fe20000001834ULL,
0x000000008c8c783bULL, 0x000e620000000200ULL, 0xfffffff00c0c7812ULL, 0x000fe400078ee20bULL,
0x0000000c140b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000e14147836ULL, 0x000fe20000000000ULL,
0x000000725c38723cULL, 0x000fe20000001838ULL, 0x000000100c0c7824ULL, 0x000fe200078e021dULL,
0xfffffff011127812ULL, 0x000fe400078ee212ULL, 0xfffffff00e0e7812ULL, 0x000fc400078ee20bULL,
0x000000585c94723cULL, 0x008fe20000001894ULL, 0x0000001012127824ULL, 0x100fe400078e021dULL,
0x000000100e0e7824ULL, 0x000fc600078e021dULL, 0x000000586028723cULL, 0x010fec0000001828ULL,
0x0000005a6030723cULL, 0x000fe20000001830ULL, 0x0000001021587824ULL, 0x000fca00078e020dULL,
0x00000070604c723cULL, 0x000fec000000184cULL, 0x000000726050723cULL, 0x000fec0000001850ULL,
0x0000006c6054723cULL, 0x000fec0000001854ULL, 0x0000006e6064723cULL, 0x000fec0000001864ULL,
0x000000686074723cULL, 0x000fec0000001874ULL, 0x0000006a6088723cULL, 0x000fec0000001888ULL,
0x0000005a5c2c723cULL, 0x000fe2000000182cULL, 0x0000001024607824ULL, 0x100fe200078e020dULL,
0x000000005858783bULL, 0x000fe80000000200ULL, 0x0000006c5c3c723cULL, 0x000fe2000000183cULL,
0x000000006060783bULL, 0x000fea0000000200ULL, 0x0000006e5c40723cULL, 0x000fe20000001840ULL,
0x00000010276c7824ULL, 0x000fca00078e020dULL, 0x000000685c44723cULL, 0x000fe20000001844ULL,
0x000000006c6c783bULL, 0x000fea0000000200ULL, 0x0000006a5c48723cULL, 0x000fe20000001848ULL,
0x0000000d25687211ULL, 0x000fe200078e20ffULL, 0x000000000c5c783bULL, 0x0004e80000000200ULL,
0x000000907c34723cULL, 0x020fe20000001834ULL, 0x000000006868783bULL, 0x000f220000000200ULL,
0xfffffff0130c7812ULL, 0x004fc800078ee214ULL, 0x000000927c38723cULL, 0x000fe20000001838ULL,
0x000000001514783bULL, 0x000fe20000000200ULL, 0x000000100c0c7824ULL, 0x000fc800078e021dULL,
0x00000090844c723cULL, 0x000fec000000184cULL, 0x000000928450723cULL, 0x000fec0000001850ULL,
0x000000828490723cULL, 0x000fe20000001864ULL, 0x000000001264783bULL, 0x000eaa0000000200ULL,
0x000000787c94723cULL, 0x000fec0000001894ULL, 0x0000007a7c2c723cULL, 0x000fec000000182cULL,
0x000000788428723cULL, 0x000fec0000001828ULL, 0x0000007a8430723cULL, 0x000fe20000001830ULL,
0x000000000e78783bULL, 0x000f6a0000000200ULL, 0x000000807c3c723cULL, 0x000fec000000183cULL,
0x000000827c40723cULL, 0x000fec0000001840ULL, 0x0000008c7c44723cULL, 0x002fec0000001844ULL,
0x0000008e7c48723cULL, 0x000fe20000001848ULL, 0x000000000c7c783bULL, 0x000fea0000000200ULL,
0x000000808470723cULL, 0x000fec0000001854ULL, 0x000000605c34723cULL, 0x008fe20000001834ULL,
0x0000000d98547211ULL, 0x000fe200078e20ffULL, 0x000000109c807824ULL, 0x000fc800078e020dULL,
0x0000008c84a4723cULL, 0x000fe20000001874ULL, 0x000000005454783bULL, 0x000e680000000200ULL,
0x000000008080783bULL, 0x000ee20000000200ULL, 0x0000008e8488723cULL, 0x000fe20000001888ULL,
0x000000109a747824ULL, 0x000fca00078e020dULL, 0x000000585c94723cULL, 0x000fe20000001894ULL,
0x000000007474783bULL, 0x000e6a0000000200ULL, 0x0000005a5c2c723cULL, 0x000fec000000182cULL,
0x000000625c38723cULL, 0x000fec0000001838ULL, 0x0000006c5c3c723cULL, 0x000fec000000183cULL,
0x0000006e5c40723cULL, 0x000fec0000001840ULL, 0x000000685c44723cULL, 0x010fec0000001844ULL,
0x0000006a5c5c723cULL, 0x000fec0000001848ULL, 0x000000146448723cULL, 0x004fec0000001834ULL,
0x000000587884723cULL, 0x020fec0000001828ULL, 0x00000060788c723cULL, 0x000fec000000184cULL,
0x0000006c7870723cULL, 0x000fec0000001870ULL, 0x0000005a7858723cULL, 0x000fe20000001830ULL,
0x3db504f34a197820ULL, 0x000fe20000410000ULL, 0x00000001004a7802ULL, 0x000fe20000000f00ULL,
0x3db504f34b187820ULL, 0x000fe20000410000ULL, 0x3db504f348487820ULL, 0x000fe20000410000ULL,
0x3db504f349497820ULL, 0x000fe20000410000ULL, 0x000000627850723cULL, 0x000fe40000001850ULL,
0x01e6884a994a79a7ULL, 0x000ea8000850003fULL, 0x0000006e7890723cULL, 0x000fec0000001890ULL,
0x0000006878a4723cULL, 0x000fec00000018a4ULL, 0x0000006a7888723cULL, 0x000fec0000001888ULL,
0x00000056644c723cULL, 0x002fec000000182cULL, 0x00000016642c723cULL, 0x000fec0000001838ULL,
0x000000806428723cULL, 0x008fec000000183cULL, 0x000000826430723cULL, 0x000fec0000001840ULL,
0x000000546494723cULL, 0x000fe20000001894ULL, 0x3db504f34c4c7820ULL, 0x000fe20000410000ULL,
0x3db504f34d4d7820ULL, 0x000fe20000410000ULL, 0x3db504f34e137820ULL, 0x000fe20000410000ULL,
0x3db504f34f127820ULL, 0x000fc40000410000ULL, 0x000000746434723cULL, 0x000fe20000001844ULL,
0x3db504f32c2c7820ULL, 0x000fe20000410000ULL, 0x3db504f32d2d7820ULL, 0x000fe20000410000ULL,
0x3db504f32e2e7820ULL, 0x000fe20000410000ULL, 0x3db504f32f2f7820ULL, 0x000fe40000410000ULL,
0x000000547c38723cULL, 0x000fe20000001884ULL, 0x3db504f328287820ULL, 0x000fe20000410000ULL,
0x3db504f329297820ULL, 0x000fe20000410000ULL, 0x3db504f32a2a7820ULL, 0x000fe20000410000ULL,
0x3db504f32b2b7820ULL, 0x000fc40000410000ULL, 0x000000147c3c723cULL, 0x000fe2000000188cULL,
0x3db504f330307820ULL, 0x000fe20000410000ULL, 0x3db504f331317820ULL, 0x000fe20000410000ULL,
0x3db504f332327820ULL, 0x000fe20000410000ULL, 0x3db504f333337820ULL, 0x000fe40000410000ULL,
0x000000807c40723cULL, 0x000fe20000001870ULL, 0x3db504f3941f7820ULL, 0x000fe20000410000ULL,
0x3db504f3951e7820ULL, 0x000fe20000410000ULL, 0x3db504f3960e7820ULL, 0x000fe20000410000ULL,
0x3db504f397117820ULL, 0x000fc40000410000ULL, 0x000000567c54723cULL, 0x000fe20000001858ULL,
0x3db504f334347820ULL, 0x000fe20000410000ULL, 0x3db504f335357820ULL, 0x000fe20000410000ULL,
0x3db504f336367820ULL, 0x000fe20000410000ULL, 0x3db504f337377820ULL, 0x000fe40000410000ULL,
0x000000167c14723cULL, 0x000fe20000001850ULL, 0x3db504f338217820ULL, 0x000fe20000410000ULL,
0x3db504f339397820ULL, 0x000fe20000410000ULL, 0x3db504f33a3a7820ULL, 0x000fe20000410000ULL,
0x3db504f33b3b7820ULL, 0x000fc40000410000ULL, 0x000000827c80723cULL, 0x000fe20000001890ULL,
0x3db504f33c3c7820ULL, 0x000fe20000410000ULL, 0x3db504f33d3d7820ULL, 0x000fe20000410000ULL,
0x3db504f33e3e7820ULL, 0x000fe20000410000ULL, 0x3db504f33f3f7820ULL, 0x000fe40000410000ULL,
0x000000747c44723cULL, 0x000fe200000018a4ULL, 0x3db504f340407820ULL, 0x000fe20000410000ULL,
0x3db504f341417820ULL, 0x000fe20000410000ULL, 0x3db504f342427820ULL, 0x000fe20000410000ULL,
0x3db504f343437820ULL, 0x000fc40000410000ULL, 0x000000766464723cULL, 0x000fe2000000185cULL,
0x3db504f354547820ULL, 0x000fe20000410000ULL, 0x3db504f355557820ULL, 0x000fe20000410000ULL,
0x3db504f356567820ULL, 0x000fe20000410000ULL, 0x3db504f357577820ULL, 0x000fe40000410000ULL,
0x000000767c7c723cULL, 0x000fe20000001888ULL, 0x3db504f314207820ULL, 0x000fe20000410000ULL,
0x3db504f315247820ULL, 0x000fe20000410000ULL, 0x3db504f316257820ULL, 0x000fe20000410000ULL,
0x3db504f317277820ULL, 0x000fc40000410000ULL, 0x3db504f380807820ULL, 0x000fe20000410000ULL,
0x3db504f381817820ULL, 0x000fe20000410000ULL, 0x3db504f382827820ULL, 0x000fe20000410000ULL,
0x3db504f383837820ULL, 0x000fc60000410000ULL, 0x3db504f344447820ULL, 0x000fe20000410000ULL,
0x3db504f345457820ULL, 0x000fe20000410000ULL, 0x3db504f346467820ULL, 0x000fe20000410000ULL,
0x3db504f347477820ULL, 0x000fc60000410000ULL, 0x3db504f364647820ULL, 0x000fe20000410000ULL,
0x3db504f365657820ULL, 0x000fe20000410000ULL, 0x3db504f366667820ULL, 0x000fe20000410000ULL,
0x3db504f367677820ULL, 0x000fc60000410000ULL, 0x3db504f37c7c7820ULL, 0x000fe20000410000ULL,
0x3db504f37d7d7820ULL, 0x000fe20000410000ULL, 0x3db504f37e7e7820ULL, 0x000fe20000410000ULL,
0x3db504f37f7f7820ULL, 0x000fe20000410000ULL, 0x00000000000c7805ULL, 0x000fe20000015200ULL,
0x01e6884b990075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff167224ULL, 0x000fce00078e00ffULL, 0x000000101600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x000000140c147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e0dULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc80000011415ULL, 0x000000140b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x000000020b0b7819ULL, 0x000fc80000001214ULL,
0x0000000b0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fce0007ffe0ffULL, 0x01e6884b990075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000004070b7824ULL, 0x000fe200078e00ffULL,
0x0000000a2300720cULL, 0x000fe20003f06070ULL, 0x00000080220c7824ULL, 0x000fc600078e021dULL,
0xfffffff00b0b7812ULL, 0x000fca00078ec0ffULL, 0x000000010c0b7824ULL, 0x000fca00078e020bULL,
0x01e400000b147984ULL, 0x0002a20000000c00ULL, 0x0000001c00c08947ULL, 0x000fea0003800000ULL,
0x0000000207387824ULL, 0x040fe200078e00ffULL, 0x000000091c0c7248ULL, 0x000fe20007fe0000ULL,
0x0000860000097ab9ULL, 0x000fe20000000800ULL, 0x0000000007237211ULL, 0x000fe200078ff0ffULL,
0x00008400000a7ab9ULL, 0x000fe20000000800ULL, 0x0000000638387812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097210ULL, 0x000fe20007ffe1ffULL, 0x00000008234f7836ULL, 0x000fe20000000000ULL,
0x00008c00ff0c7b82ULL, 0x000ee20000000a00ULL, 0x00000008384e7c36ULL, 0x000fe20008000000ULL,
0x00000009ff4a7c19ULL, 0x000fe20008011623ULL, 0x000000ffff877224ULL, 0x000fe200078e0a09ULL,
0x00000009ff4f7c19ULL, 0x000fe2000801164fULL, 0x0000001023507836ULL, 0x000fe20000000000ULL,
0x000000094e00720cULL, 0x000fe20003f26070ULL, 0x0000001823237836ULL, 0x000fe20000000000ULL,
0x000000054a4b7c48ULL, 0x000fc4000bfe0000ULL, 0x000000054e4e7e46ULL, 0x000fe4000b800087ULL,
0x0000000a384a7c10ULL, 0x000fe2000fffe0ffULL, 0x000000044b847c24ULL, 0x000fe2000f8e02ffULL,
0x00000004ff4e7819ULL, 0x000fe4000001164eULL, 0x000000094a00720cULL, 0x000fe40003f06070ULL,
0x000000054a6f7e46ULL, 0x000fe4000b800087ULL, 0x000000054f4f7c48ULL, 0x000fc4000bfe0000ULL,
0x000000ff4e597207ULL, 0x000fe40000800000ULL, 0x000000ff6f6f7207ULL, 0x000fe20000000000ULL,
0x000000044f867c24ULL, 0x000fe2000f8e02ffULL, 0x00000009ff507c19ULL, 0x000fe40008011650ULL,
0x00000059844f7210ULL, 0x000fe40007ffe0ffULL, 0x000000846f517211ULL, 0x000fe400078fe0ffULL,
0x00000009ff4b7c19ULL, 0x000fe20008011623ULL, 0x000000024f4e7825ULL, 0x008fe200078e000cULL,
0x0000000550237c48ULL, 0x000fc4000bfe0000ULL, 0x000000054b4b7c48ULL, 0x000fe2000bfe0000ULL,
0x0000000251507825ULL, 0x000fe200078e000cULL, 0x000000866f537211ULL, 0x000fe200078fe0ffULL,
0x000000064e4e7981ULL, 0x000724000c1e9500ULL, 0x0000000423887c24ULL, 0x000fe4000f8e02ffULL,
0x0000000650237981ULL, 0x000f22000c1e9500ULL, 0x000000044b8a7c24ULL, 0x000fe4000f8e02ffULL,
0x000000886f5b7211ULL, 0x000fe200078fe0ffULL, 0x00000001595f7824ULL, 0x000fc400078e0286ULL,
0x0000000159617824ULL, 0x040fe200078e0288ULL, 0x0000001038627812ULL, 0x000fe200078efcffULL,
0x0000000159637824ULL, 0x000fe400078e028aULL, 0x000000025f5e7825ULL, 0x000fc800078e000cULL,
0x0000000261607825ULL, 0x100fe200078e000cULL, 0x00000008626a7c10ULL, 0x000fe2000fffe0ffULL,
0x000000065e5e7981ULL, 0x000f64000c1e9500ULL, 0x0000000253527825ULL, 0x100fe200078e000cULL,
0x0000008a6f5d7211ULL, 0x000fe200078fe0ffULL, 0x0000000660607981ULL, 0x000f64000c1e9500ULL,
0x000000025b587825ULL, 0x000fe400078e000cULL, 0x00000006524b7981ULL, 0x000768000c1e9500ULL,
0x00000006584f7981ULL, 0x008ee2000c1e9500ULL, 0x0000000a62687c36ULL, 0x000fc40008000000ULL,
0x000000025d5a7825ULL, 0x100fe200078e000cULL, 0x000000056a537e46ULL, 0x002fe4000b800087ULL,
0x000000096a00720cULL, 0x080fe20003f26070ULL, 0x0000000263507825ULL, 0x000fe200078e000cULL,
0x00000004ff537819ULL, 0x000fe20000011653ULL, 0x000000065a5c7981ULL, 0x0002e2000c1e9500ULL,
0x000000096800720cULL, 0x000fe40003f06070ULL, 0x0000000568527e46ULL, 0x000fe2000b800087ULL,
0x00000006505d7981ULL, 0x0002e6000c1e9500ULL, 0x000000ff52777207ULL, 0x000fc40000000000ULL,
0x000000ff535b7207ULL, 0x002fe40000800000ULL, 0x0000008677597211ULL, 0x040fe400078fe0ffULL,
0x0000008477517211ULL, 0x004fe200078fe0ffULL, 0x0000000184537824ULL, 0x000fe400078e025bULL,
0x000000015b717824ULL, 0x000fe200078e0286ULL, 0x0000002038747812ULL, 0x000fe200078efcffULL,
0x0000000253527825ULL, 0x000fc800078e000cULL, 0x0000000271707825ULL, 0x100fe200078e000cULL,
0x00000006526e7981ULL, 0x0002a6000c1e9500ULL, 0x0000000251507825ULL, 0x100fe400078e000cULL,
0x0000000670707981ULL, 0x000ea4000c1e9500ULL, 0x0000000259587825ULL, 0x000fe400078e000cULL,
0x00000006505f7981ULL, 0x0002a4000c1e9500ULL, 0x0000000874527c36ULL, 0x002fc40008000000ULL,
0x0000000658617981ULL, 0x000ea2000c1e9500ULL, 0x000000885b737210ULL, 0x000fe20007ffe0ffULL,
0x000000015b797824ULL, 0x000fe200078e028aULL, 0x0000008877637211ULL, 0x040fe200078fe0ffULL,
0x0000000a74767c36ULL, 0x000fe20008000000ULL, 0x0000008a776b7211ULL, 0x000fe400078fe0ffULL,
0x0000000552517e46ULL, 0x000fe2000b800087ULL, 0x0000000273727825ULL, 0x100fe200078e000cULL,
0x000000097600720cULL, 0x080fe40003f06070ULL, 0x0000000576507e46ULL, 0x000fe2000b800087ULL,
0x0000000279787825ULL, 0x000fe200078e000cULL, 0x000000095200720cULL, 0x000fe20003f26070ULL,
0x0000000672727981ULL, 0x000ea2000c1e9500ULL, 0x00000004ff517819ULL, 0x000fe20000011651ULL,
0x00000002635a7825ULL, 0x000fc800078e000cULL, 0x000000026b6a7825ULL, 0x000fe200078e000cULL,
0x000000ff50857207ULL, 0x000fe20000000000ULL, 0x000000065a637981ULL, 0x000ea2000c1e9500ULL,
0x000000ff51517207ULL, 0x000fc60000800000ULL, 0x000000066a697981ULL, 0x0002a2000c1e9500ULL,
0x00000086856d7211ULL, 0x000fc600078fe0ffULL, 0x0000000678787981ULL, 0x0002a4000c1e9500ULL,
0x000000026d6c7825ULL, 0x000fc800078e000cULL, 0x00000001516b7824ULL, 0x002fe200078e0286ULL,
0x0000008485537211ULL, 0x000fe200078fe0ffULL, 0x000000066c737981ULL, 0x000ea4000c1e9500ULL,
0x000000026b6a7825ULL, 0x000fe200078e000cULL, 0x00000051847b7210ULL, 0x000fc80007ffe0ffULL,
0x000000066acc7981ULL, 0x000ea2000c1e9500ULL, 0x0000000253527825ULL, 0x000fe200078e000cULL,
0x00000088855b7211ULL, 0x040fe400078fe0ffULL, 0x0000008a85757211ULL, 0x000fe200078fe0ffULL,
0x0000000151597824ULL, 0x040fe200078e0288ULL, 0x0000000652717981ULL, 0x0002a2000c1e9500ULL,
0x0000000151797824ULL, 0x000fe400078e028aULL, 0x000000027b7a7825ULL, 0x000fe200078e000cULL,
0x0000003038b27812ULL, 0x000fc600078efcffULL, 0x000000025b5a7825ULL, 0x000fc800078e000cULL,
0x0000000275507825ULL, 0x100fe200078e000cULL, 0x000000067a7a7981ULL, 0x000ea6000c1e9500ULL,
0x0000000259587825ULL, 0x100fe200078e000cULL, 0x000000065a757981ULL, 0x0002a6000c1e9500ULL,
0x0000000279527825ULL, 0x002fe200078e000cULL, 0x0000000650d47981ULL, 0x000ea2000c1e9500ULL,
0x00000008b26c7c10ULL, 0x000fc6000fffe0ffULL, 0x0000000658d07981ULL, 0x000ea2000c1e9500ULL,
0x0000000ab2b47c36ULL, 0x000fc60008000000ULL, 0x00000006528d7981ULL, 0x0002a2000c1e9500ULL,
0x000000056c6d7e46ULL, 0x000fe4000b800087ULL, 0x000000096c00720cULL, 0x080fe40003f26070ULL,
0x00000009b400720cULL, 0x000fe40003f06070ULL, 0x00000005b45a7e46ULL, 0x000fe4000b800087ULL,
0x00000004ff6d7819ULL, 0x000fe4000001166dULL, 0x000000ff5a797207ULL, 0x000fc40000000000ULL,
0x000000ff6d7b7207ULL, 0x000fe40000800000ULL, 0x00000084796b7211ULL, 0x040fe400078fe0ffULL,
0x0000008879537211ULL, 0x002fe200078fe0ffULL, 0x00000001846d7824ULL, 0x000fe200078e027bULL,
0x000000887b5b7210ULL, 0x000fe20007ffe0ffULL, 0x000000026b6a7825ULL, 0x000fc800078e000cULL,
0x000000026d6c7825ULL, 0x100fe200078e000cULL, 0x000000066ab67981ULL, 0x0002a6000c1e9500ULL,
0x0000000253527825ULL, 0x100fe200078e000cULL, 0x000000066c877981ULL, 0x000ea6000c1e9500ULL,
0x000000025b5a7825ULL, 0x000fe200078e000cULL, 0x0000000652d27981ULL, 0x000ea2000c1e9500ULL,
0x0000008679517211ULL, 0x000fc600078fe0ffULL, 0x000000065a8b7981ULL, 0x000ea2000c1e9500ULL,
0x000000017b597824ULL, 0x000fe400078e0286ULL, 0x0000000251507825ULL, 0x000fc800078e000cULL,
0x0000000259587825ULL, 0x000fe200078e000cULL, 0x0000000650ce7981ULL, 0x000ea2000c1e9500ULL,
0x0000008a796b7211ULL, 0x002fc600078fe0ffULL, 0x0000000658897981ULL, 0x000ea2000c1e9500ULL,
0x000000017b7b7824ULL, 0x000fe400078e028aULL, 0x000000026b6a7825ULL, 0x000fc800078e000cULL,
0x000000027b0c7825ULL, 0x000fe200078e000cULL, 0x000000066ad67981ULL, 0x000ea8000c1e9500ULL,
0x000000060c8f7981ULL, 0x0002a2000c1e9500ULL, 0x00000001ffca7424ULL, 0x000fe200078e00ffULL,
0xfffffff06f0c7812ULL, 0x002fca00078ec0ffULL, 0x00000001090d7824ULL, 0x000fe200078e020cULL,
0x0000000138507812ULL, 0x000fc800078efcffULL, 0x8000000d4a0c7210ULL, 0x000fc80007ffe0ffULL,
0x0000000cca0c7219ULL, 0x000fe200000006ffULL, 0x0000000a50527c36ULL, 0x000fe20008000000ULL,
0xfffffff077587812ULL, 0x000fc600078ec0ffULL, 0x0000000152517824ULL, 0x000fe200078e0a0dULL,
0x00000008386c7812ULL, 0x040fe400078efcffULL, 0x0000000938847812ULL, 0x000fe400078efcffULL,
0x0000005809597210ULL, 0x000fe40007ffe0ffULL, 0x00000051ca587219ULL, 0x000fe400000006ffULL,
0x0000000a6c5a7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000a84867c36ULL, 0x000fe20008000000ULL,
0xfffffff0856a7812ULL, 0x000fc400078ec0ffULL, 0xfffffff079887812ULL, 0x000fe200078ec0ffULL,
0x000000015a537824ULL, 0x100fe400078e0a0dULL, 0x00000001860d7824ULL, 0x000fe200078e0a0dULL,
0x00000011388c7812ULL, 0x000fe200078efcffULL, 0x00000001095b7824ULL, 0x040fe200078e026aULL,
0x00000053ca6a7219ULL, 0x040fe200000006ffULL, 0x0000000109777824ULL, 0x000fe200078e0288ULL,
0x0000000dca887219ULL, 0x000fe200000006ffULL, 0x0000000a8c8e7c36ULL, 0x000fe20008000000ULL,
0x0000541023237816ULL, 0x010fc8000000004eULL, 0x000000230cff7212ULL, 0x000fc800078ac0ffULL,
0x000000094a00720cULL, 0x000fc80002fa1470ULL, 0x000000093800720cULL, 0x000fe40002fa1070ULL,
0x0000002358ff7212ULL, 0x000fe4000788c0ffULL, 0xff8000001f1f7808ULL, 0x000fe40002800000ULL,
0x000054104b4b7816ULL, 0x020fe4000000005eULL, 0x000054104f4f7816ULL, 0x008fe40000000060ULL,
0x0000004b0cff7212ULL, 0x000fc4000784c0ffULL, 0x0000004f0cff7212ULL, 0x000fe4000782c0ffULL,
0x0000004b58ff7212ULL, 0x000fe400078ac0ffULL, 0x000000094a00720cULL, 0x0c0fe40001741470ULL,
0x000000094a00720cULL, 0x080fe40000f21470ULL, 0x000000095200720cULL, 0x0c0fe40002781470ULL,
0x000000095200720cULL, 0x000fc40002fa1470ULL, 0x000000093800720cULL, 0x0c0fe40001741070ULL,
0x000000093800720cULL, 0x080fe40000f21070ULL, 0x000000095000720cULL, 0x0c0fe40002781070ULL,
0x000000095000720cULL, 0x000fe40002fa1070ULL, 0x000054105c5d7816ULL, 0x000fe4000000005dULL,
0xff8000000e0e7808ULL, 0x000fc40001000000ULL, 0xff80000021217808ULL, 0x000fe40000800000ULL,
0xff8000001e1e7808ULL, 0x000fe40002000000ULL, 0xff80000011117808ULL, 0x000fe40002800000ULL,
0x000000236aff7212ULL, 0x000fe4000786c0ffULL, 0x0000005d0cff7212ULL, 0x000fe4000780c0ffULL,
0x0000004f58ff7212ULL, 0x000fc4000784c0ffULL, 0x0000005d58ff7212ULL, 0x000fe4000782c0ffULL,
0x0000004b88ff7212ULL, 0x000fe4000788c0ffULL, 0x0000004f6aff7212ULL, 0x000fe200078ac0ffULL,
0x00000001680d7824ULL, 0x000fe200078e0a59ULL, 0x000000094a00720cULL, 0x080fe40000701470ULL,
0x000000095200720cULL, 0x0c0fe40001741470ULL, 0x000000095200720cULL, 0x000fc40000f21470ULL,
0x000000095a00720cULL, 0x0c0fe40001f61470ULL, 0x000000095a00720cULL, 0x080fe40002fa1470ULL,
0x000000098600720cULL, 0x000fe40002781470ULL, 0x0000008e59517210ULL, 0x000fe40007ffe1ffULL,
0x0000001838927812ULL, 0x040fe400078efcffULL, 0x0000001938987812ULL, 0x000fc400078efcffULL,
0x000000093800720cULL, 0x080fe40000701070ULL, 0x000000095000720cULL, 0x0c0fe40001741070ULL,
0x000000095000720cULL, 0x080fe40000f21070ULL, 0x000000096c00720cULL, 0x0c0fe40001f61070ULL,
0x000000096c00720cULL, 0x080fe40002fa1070ULL, 0x000000098400720cULL, 0x000fc40002781070ULL,
0x0000000dca8a7219ULL, 0x040fe400000006ffULL, 0x00000051ca907219ULL, 0x000fe400000006ffULL,
0x000054105f5f7816ULL, 0x004fe4000000006eULL, 0x0000541061617816ULL, 0x000fe20000000070ULL,
0x0000000a92947c36ULL, 0x000fe20008000000ULL, 0x0000000a989a7c10ULL, 0x000fe4000fffe0ffULL,
0xff8000003a3a7808ULL, 0x000fc40000000000ULL, 0xff80000039397808ULL, 0x000fe40001000000ULL,
0xff8000003b3b7808ULL, 0x000fe40000800000ULL, 0xff8000004c4c7808ULL, 0x000fe40001800000ULL,
0xff80000054547808ULL, 0x000fe40002800000ULL, 0xff80000012127808ULL, 0x000fe40002000000ULL,
0x0000004b6aff7212ULL, 0x000fc4000780c0ffULL, 0x0000004f88ff7212ULL, 0x000fe4000784c0ffULL,
0x0000005d6aff7212ULL, 0x080fe4000782c0ffULL, 0x0000005d88ff7212ULL, 0x000fe4000786c0ffULL,
0x0000005f90ff7212ULL, 0x000fe400078ac0ffULL, 0x000000618aff7212ULL, 0x000fe2000788c0ffULL,
0x0000000194537824ULL, 0x100fe200078e0a59ULL, 0x000000095a00720cULL, 0x080fe20000701470ULL,
0x000000019a597824ULL, 0x000fe200078e0a59ULL, 0x000000095a00720cULL, 0x000fc40000f21470ULL,
0x000000098600720cULL, 0x0c0fe40001741470ULL, 0x000000098600720cULL, 0x080fe40001f61470ULL,
0x000000096800720cULL, 0x080fe40002781470ULL, 0x000000098e00720cULL, 0x080fe40002fa1470ULL,
0x000000096c00720cULL, 0x0c0fe40000701070ULL, 0x000000096c00720cULL, 0x000fc40000f21070ULL,
0x000000098400720cULL, 0x0c0fe40001741070ULL, 0x000000098400720cULL, 0x080fe40001f61070ULL,
0x000000096200720cULL, 0x080fe40002781070ULL, 0x000000098c00720cULL, 0x000fe40002fa1070ULL,
0x00000053ca967219ULL, 0x040fe400000006ffULL, 0x00000059ca9c7219ULL, 0x000fc400000006ffULL,
0x0000541063637816ULL, 0x000fe40000000072ULL, 0x0000541069697816ULL, 0x000fe40000000078ULL,
0xff80000013137808ULL, 0x000fe40000000000ULL, 0xff80000056567808ULL, 0x000fe40000800000ULL,
0xff80000055557808ULL, 0x000fe40001000000ULL, 0xff80000057577808ULL, 0x000fc40001800000ULL,
0xff80000019197808ULL, 0x000fe40002000000ULL, 0xff80000049497808ULL, 0x000fe40002800000ULL,
0x0000005f8aff7212ULL, 0x080fe4000780c0ffULL, 0x0000005f96ff7212ULL, 0x000fe4000782c0ffULL,
0x000000638aff7212ULL, 0x040fe4000784c0ffULL, 0x000000698aff7212ULL, 0x000fc4000786c0ffULL,
0x0000006390ff7212ULL, 0x000fe4000788c0ffULL, 0x000000619cff7212ULL, 0x000fe200078ac0ffULL,
0x00000001766b7824ULL, 0x000fe200078e0a5bULL, 0x000000096800720cULL, 0x0c0fe40000701470ULL,
0x000000096800720cULL, 0x0c0fe40001741470ULL, 0x000000096800720cULL, 0x080fe40001f61470ULL,
0x000000098e00720cULL, 0x000fc40002781470ULL, 0x000000099400720cULL, 0x080fe40000f21470ULL,
0x000000099a00720cULL, 0x080fe40002fa1470ULL, 0x0000002138a07812ULL, 0x000fe400078efcffULL,
0x000000096200720cULL, 0x0c0fe40000701070ULL, 0x000000096200720cULL, 0x0c0fe40001741070ULL,
0x000000096200720cULL, 0x000fc40001f61070ULL, 0x000000098c00720cULL, 0x080fe40002781070ULL,
0x000000099200720cULL, 0x080fe40000f21070ULL, 0x000000099800720cULL, 0x000fe40002fa1070ULL,
0x0000006bca9e7219ULL, 0x000fe400000006ffULL, 0x0000541073737816ULL, 0x000fe200000000ccULL,
0x0000000aa0a27c36ULL, 0x000fe20008000000ULL, 0xff80000048487808ULL, 0x000fc40000000000ULL,
0xff8000003c3c7808ULL, 0x000fe40001000000ULL, 0xff8000003e3e7808ULL, 0x000fe40001800000ULL,
0xff8000003d3d7808ULL, 0x000fe40002000000ULL, 0xff8000002c2c7808ULL, 0x000fe40000800000ULL,
0xff8000002f2f7808ULL, 0x000fe40002800000ULL, 0x0000006190ff7212ULL, 0x000fc4000780c0ffULL,
0x0000006990ff7212ULL, 0x000fe4000784c0ffULL, 0x0000006196ff7212ULL, 0x000fe4000786c0ffULL,
0x000000639cff7212ULL, 0x040fe4000788c0ffULL, 0x000000699cff7212ULL, 0x000fe4000782c0ffULL,
0x000000739eff7212ULL, 0x000fe400078ac0ffULL, 0x000000098e00720cULL, 0x000fc40000701470ULL,
0x000000098e00720cULL, 0x080fe40001741470ULL, 0x000000099400720cULL, 0x080fe40001f61470ULL,
0x000000099a00720cULL, 0x0c0fe40002781470ULL, 0x000000099a00720cULL, 0x080fe40000f21470ULL,
0x000000097600720cULL, 0x000fe40002fa1470ULL, 0x000000a25b6d7210ULL, 0x000fc40007ffe1ffULL,
0x0000002838a67812ULL, 0x040fe400078efcffULL, 0x0000002938ac7812ULL, 0x000fe400078efcffULL,
0x000000098c00720cULL, 0x0c0fe40000701070ULL, 0x000000098c00720cULL, 0x080fe40001741070ULL,
0x000000099200720cULL, 0x080fe40001f61070ULL, 0x000000099800720cULL, 0x000fc40002781070ULL,
0x000000099800720cULL, 0x080fe40000f21070ULL, 0x000000097400720cULL, 0x000fe40002fa1070ULL,
0x0000006dcaa47219ULL, 0x000fe400000006ffULL, 0x0000541071717816ULL, 0x000fe4000000007aULL,
0x0000541075757816ULL, 0x000fe400000000d0ULL, 0x00005410d48d7816ULL, 0x000fe2000000008dULL,
0x0000000aa6a87c36ULL, 0x000fe20008000000ULL, 0xff80000018187808ULL, 0x000fe20000000000ULL,
0x0000000aacae7c36ULL, 0x000fe20008000000ULL, 0xff8000003f3f7808ULL, 0x000fc40001000000ULL,
0xff8000002e2e7808ULL, 0x000fe40001800000ULL, 0xff80000024247808ULL, 0x000fe40002000000ULL,
0xff80000027277808ULL, 0x000fe40000800000ULL, 0xff8000002a2a7808ULL, 0x000fe40002800000ULL,
0x0000002388ff7212ULL, 0x000fe400078cc0ffULL, 0x0000006396ff7212ULL, 0x000fc4000780c0ffULL,
0x0000006996ff7212ULL, 0x000fe4000784c0ffULL, 0x000000719eff7212ULL, 0x040fe4000786c0ffULL,
0x000000759eff7212ULL, 0x040fe4000788c0ffULL, 0x0000008d9eff7212ULL, 0x000fe4000782c0ffULL,
0x00000075a4ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001a86f7824ULL, 0x100fe200078e0a5bULL,
0x000000098600720cULL, 0x080fe200037c1470ULL, 0x00000001ae5b7824ULL, 0x000fe200078e0a5bULL,
0x000000099400720cULL, 0x000fc40000701470ULL, 0x000000099400720cULL, 0x080fe40001741470ULL,
0x000000097600720cULL, 0x0c0fe40001f61470ULL, 0x000000097600720cULL, 0x0c0fe40002781470ULL,
0x000000097600720cULL, 0x080fe40000f21470ULL, 0x00000009a200720cULL, 0x080fe40002fa1470ULL,
0x000000098400720cULL, 0x000fc400037c1070ULL, 0x000000099200720cULL, 0x0c0fe40000701070ULL,
0x000000099200720cULL, 0x080fe40001741070ULL, 0x000000097400720cULL, 0x0c0fe40001f61070ULL,
0x000000097400720cULL, 0x0c0fe40002781070ULL, 0x000000097400720cULL, 0x080fe40000f21070ULL,
0x00000009a000720cULL, 0x000fc40002fa1070ULL, 0x0000006fcaaa7219ULL, 0x040fe400000006ffULL,
0x0000005bcab07219ULL, 0x000fe400000006ffULL, 0xff8000004d4d7808ULL, 0x000fe40003000000ULL,
0xff80000020207808ULL, 0x000fe40000000000ULL, 0xff80000025257808ULL, 0x000fe40001000000ULL,
0xff80000028287808ULL, 0x000fc40001800000ULL, 0xff80000040407808ULL, 0x000fe40002000000ULL,
0xff80000042427808ULL, 0x000fe40000800000ULL, 0xff80000041417808ULL, 0x000fe40002800000ULL,
0x0000005f9cff7212ULL, 0x000fe400078cc0ffULL, 0x00000071a4ff7212ULL, 0x080fe4000780c0ffULL,
0x00000071aaff7212ULL, 0x000fc4000784c0ffULL, 0x00000073a4ff7212ULL, 0x040fe4000786c0ffULL,
0x0000008da4ff7212ULL, 0x000fe4000788c0ffULL, 0x00000073aaff7212ULL, 0x000fe4000782c0ffULL,
0x00000075b0ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001b4797824ULL, 0x000fe200078e0a77ULL,
0x000000099a00720cULL, 0x080fe400037c1470ULL, 0x00000009a200720cULL, 0x000fc40000701470ULL,
0x00000009a200720cULL, 0x0c0fe40001f61470ULL, 0x00000009a200720cULL, 0x080fe40002781470ULL,
0x00000009a800720cULL, 0x0c0fe40001741470ULL, 0x00000009a800720cULL, 0x080fe40000f21470ULL,
0x00000009ae00720cULL, 0x000fe40002fa1470ULL, 0x0000003838c07812ULL, 0x000fc400078efcffULL,
0x0000003138ba7812ULL, 0x040fe400078efcffULL, 0x0000003938c67812ULL, 0x000fe400078efcffULL,
0x000000099800720cULL, 0x080fe400037c1070ULL, 0x00000009a000720cULL, 0x0c0fe40000701070ULL,
0x00000009a000720cULL, 0x0c0fe40001f61070ULL, 0x00000009a000720cULL, 0x000fc40002781070ULL,
0x00000009a600720cULL, 0x0c0fe40001741070ULL, 0x00000009a600720cULL, 0x080fe40000f21070ULL,
0x00000009ac00720cULL, 0x000fe40002fa1070ULL, 0x00000079cab87219ULL, 0x000fe400000006ffULL,
0x00005410b6877816ULL, 0x000fe40000000087ULL, 0x00005410d28b7816ULL, 0x000fe2000000008bULL,
0x0000000ac0c27c36ULL, 0x000fe20008000000ULL, 0x0000000ababc7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000ac6c87c36ULL, 0x000fe20008000000ULL, 0xff8000002d2d7808ULL, 0x000fc40003000000ULL,
0xff80000029297808ULL, 0x000fe40000000000ULL, 0xff8000002b2b7808ULL, 0x000fe40001800000ULL,
0xff80000043437808ULL, 0x000fe40002000000ULL, 0xff80000030307808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fe40000800000ULL, 0xff80000081817808ULL, 0x000fc40002800000ULL,
0x00000071b0ff7212ULL, 0x040fe400078cc0ffULL, 0x00000073b0ff7212ULL, 0x000fe4000780c0ffULL,
0x00000075aaff7212ULL, 0x040fe4000786c0ffULL, 0x0000008daaff7212ULL, 0x080fe4000788c0ffULL,
0x0000008db0ff7212ULL, 0x000fe4000784c0ffULL, 0x00000087b8ff7212ULL, 0x000fc4000782c0ffULL,
0x0000008bb8ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001c2857824ULL, 0x100fe200078e0a77ULL,
0x000000bc777b7210ULL, 0x000fe20007ffe1ffULL, 0x00000001c8777824ULL, 0x000fe200078e0a77ULL,
0x00000009a800720cULL, 0x0c0fe40001f61470ULL, 0x00000009a800720cULL, 0x080fe40002781470ULL,
0x00000009ae00720cULL, 0x0c0fe400037c1470ULL, 0x00000009ae00720cULL, 0x000fc40000701470ULL,
0x00000009ae00720cULL, 0x080fe40001741470ULL, 0x00000009b400720cULL, 0x0c0fe40000f21470ULL,
0x00000009b400720cULL, 0x000fe40002fa1470ULL, 0x0000007bcabe7219ULL, 0x040fe400000006ffULL,
0x00000085cac47219ULL, 0x000fe400000006ffULL, 0x00000009a600720cULL, 0x000fc40001f61070ULL,
0x00000009a600720cULL, 0x080fe40002781070ULL, 0x00000009ac00720cULL, 0x0c0fe400037c1070ULL,
0x00000009ac00720cULL, 0x0c0fe40000701070ULL, 0x00000009ac00720cULL, 0x080fe40001741070ULL,
0x00000009b200720cULL, 0x0c0fe40000f21070ULL, 0x00000009b200720cULL, 0x000fc40002fa1070ULL,
0x00000077caca7219ULL, 0x000fe400000006ffULL, 0x00005410ce897816ULL, 0x000fe40000000089ULL,
0xff80000080807808ULL, 0x000fe40001800000ULL, 0xff80000082827808ULL, 0x000fe40002000000ULL,
0xff80000031317808ULL, 0x000fe40003000000ULL, 0xff80000033337808ULL, 0x000fc40000000000ULL,
0xff80000083837808ULL, 0x000fe40001000000ULL, 0xff80000034347808ULL, 0x000fe40000800000ULL,
0xff80000044447808ULL, 0x000fe40002800000ULL, 0x00000087beff7212ULL, 0x080fe4000786c0ffULL,
0x00000087c4ff7212ULL, 0x080fe4000788c0ffULL, 0x00000087caff7212ULL, 0x000fc400078cc0ffULL,
0x00000089b8ff7212ULL, 0x080fe4000780c0ffULL, 0x00000089beff7212ULL, 0x080fe4000784c0ffULL,
0x00000089c4ff7212ULL, 0x000fe4000782c0ffULL, 0x0000008bbeff7212ULL, 0x000fe400078ac0ffULL,
0x00000009b400720cULL, 0x080fe40000701470ULL, 0x00000009bc00720cULL, 0x000fc40001f61470ULL,
0x00000009bc00720cULL, 0x0c0fe40001741470ULL, 0x00000009bc00720cULL, 0x080fe40002fa1470ULL,
0x00000009c200720cULL, 0x080fe40002781470ULL, 0x00000009c800720cULL, 0x080fe400037c1470ULL,
0x00000009c200720cULL, 0x080fe40000f21470ULL, 0x00000009b200720cULL, 0x000fc40000701070ULL,
0x00000009ba00720cULL, 0x0c0fe40001f61070ULL, 0x00000009ba00720cULL, 0x0c0fe40001741070ULL,
0x00000009ba00720cULL, 0x080fe40002fa1070ULL, 0x00000009c000720cULL, 0x0c0fe40002781070ULL,
0x00000009c000720cULL, 0x080fe40000f21070ULL, 0x00000009c600720cULL, 0x000fc400037c1070ULL,
0x00005410d68f7816ULL, 0x000fe4000000008fULL, 0xff80000036367808ULL, 0x000fe40000000000ULL,
0xff80000035357808ULL, 0x000fe40001800000ULL, 0xff80000037377808ULL, 0x000fe40001000000ULL,
0xff80000045457808ULL, 0x000fe40002800000ULL, 0xff80000064647808ULL, 0x000fc40002000000ULL,
0xff80000066667808ULL, 0x000fe40000800000ULL, 0xff80000065657808ULL, 0x000fe40003000000ULL,
0x00000089caff7212ULL, 0x000fe4000780c0ffULL, 0x0000008bc4ff7212ULL, 0x080fe4000786c0ffULL,
0x0000008bcaff7212ULL, 0x000fe4000784c0ffULL, 0x0000008fb8ff7212ULL, 0x000fc400078ac0ffULL,
0x0000008fbeff7212ULL, 0x080fe4000788c0ffULL, 0x0000008fc4ff7212ULL, 0x080fe4000782c0ffULL,
0x0000008fcaff7212ULL, 0x000fe400078cc0ffULL, 0x00000009b400720cULL, 0x080fe40002fa1470ULL,
0x00000009bc00720cULL, 0x080fe40002781470ULL, 0x00000009c200720cULL, 0x000fc40001f61470ULL,
0x00000009c200720cULL, 0x080fe40000f21470ULL, 0x00000009c800720cULL, 0x0c0fe40000701470ULL,
0x00000009c800720cULL, 0x0c0fe40001741470ULL, 0x00000009c800720cULL, 0x080fe400037c1470ULL,
0x00000009b200720cULL, 0x080fe40002fa1070ULL, 0x00000009ba00720cULL, 0x000fc40002781070ULL,
0x00000009c600720cULL, 0x080fe40000701070ULL, 0x00000009c000720cULL, 0x0c0fe40001f61070ULL,
0x00000009c000720cULL, 0x080fe40000f21070ULL, 0x00000009c600720cULL, 0x0c0fe40001741070ULL,
0x00000009c600720cULL, 0x000fe400037c1070ULL, 0xff80000067677808ULL, 0x000fc40000000000ULL,
0xff8000007c7c7808ULL, 0x000fe40001800000ULL, 0xff8000007d7d7808ULL, 0x000fe40001000000ULL,
0xff80000046467808ULL, 0x000fe40002800000ULL, 0xff80000047477808ULL, 0x000fe40002000000ULL,
0xff8000007e7e7808ULL, 0x000fe40000800000ULL, 0xff8000007f7f7808ULL, 0x000fce0003000000ULL,
0x0000001f1400720bULL, 0x004fc80003f1e000ULL, 0x000000141f097208ULL, 0x000fc80004000000ULL,
0x0000001e0900720bULL, 0x000fc80003f1e000ULL, 0x000000091e097208ULL, 0x000fc80004000000ULL,
0x0000004c0900720bULL, 0x000fc80003f1e000ULL, 0x000000094c0c7208ULL, 0x000fc80004000000ULL,
0x0000004d0c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c4d097208ULL, 0x000fc80004000000ULL,
0x000000480900720bULL, 0x000fc80003f1e000ULL, 0x00000009480c7208ULL, 0x000fc80004000000ULL,
0x000000490c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c49097208ULL, 0x000fc80004000000ULL,
0x0000002c0900720bULL, 0x000fc80003f1e000ULL, 0x000000092c0c7208ULL, 0x000fc80004000000ULL,
0x0000002d0c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c2d097208ULL, 0x000fc80004000000ULL,
0x000000280900720bULL, 0x000fc80003f1e000ULL, 0x00000009280c7208ULL, 0x000fc80004000000ULL,
0x000000290c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c29097208ULL, 0x000fc80004000000ULL,
0x000000300900720bULL, 0x000fc80003f1e000ULL, 0x00000009300c7208ULL, 0x000fc80004000000ULL,
0x000000310c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c31097208ULL, 0x000fc80004000000ULL,
0x000000340900720bULL, 0x000fc80003f1e000ULL, 0x00000009340c7208ULL, 0x000fc80004000000ULL,
0x000000350c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c35097208ULL, 0x000fc80004000000ULL,
0x000000640900720bULL, 0x000fc80003f1e000ULL, 0x00000009640c7208ULL, 0x000fe40004000000ULL,
0x0000000e1500720bULL, 0x000fe40003f1e000ULL, 0x000000650c00720bULL, 0x000fc80003f3e000ULL,
0x0000000c650d7208ULL, 0x000fe40004800000ULL, 0x000000150e0c7208ULL, 0x000fc60004000000ULL,
0x0c401f000d147f89ULL, 0x000ea200000e0000ULL, 0x000000110c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c110c7208ULL, 0x000fc80004000000ULL, 0x000000130c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c13097208ULL, 0x000fc80004000000ULL, 0x000000120900720bULL, 0x000fc80003f1e000ULL,
0x00000009120c7208ULL, 0x000fe40004000000ULL, 0x000000140d00720bULL, 0x004fe40003f3e000ULL,
0x000000190c00720bULL, 0x000fe40003f1e000ULL, 0x0000000d14157208ULL, 0x000fe40004800000ULL,
0x0000000c19097208ULL, 0x000fc60004000000ULL, 0x0c201f0015147f89ULL, 0x000ea200000e0000ULL,
0x000000180900720bULL, 0x000fc80003f1e000ULL, 0x0000000918097208ULL, 0x000fc80004000000ULL,
0x0000002e0900720bULL, 0x000fc80003f1e000ULL, 0x000000092e0c7208ULL, 0x000fc80004000000ULL,
0x0000002f0c00720bULL, 0x000fc80003f1e000ULL, 0x0000000c2f097208ULL, 0x000fe40004000000ULL,
0x000000141500720bULL, 0x004fe40003f3e000ULL, 0x0000002a0900720bULL, 0x000fe40003f1e000ULL,
0x0000001514147208ULL, 0x000fe40004800000ULL, 0x000000092a0c7208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b14387820ULL, 0x000fe20000410000ULL, 0x0000002b0c00720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010838ULL, 0x0000000c2b097208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010838ULL,
0x0000001e004e7308ULL, 0x0005e20000000800ULL, 0x000000320900720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b48487823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b49497823ULL, 0x100fe20000010838ULL, 0x00000009320c7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b30237823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010838ULL,
0x0000004d00507308ULL, 0x000fe20000000800ULL, 0x000000330c00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b2c1e7823ULL, 0x104fe20000010838ULL, 0x3fb8aa3b314a7823ULL, 0x000fc40000010838ULL,
0x0000000c33097208ULL, 0x000fc60004000000ULL, 0x0000001e004d7308ULL, 0x0005e20000000800ULL,
0x000000360900720bULL, 0x000fc80003f1e000ULL, 0x00000009360c7208ULL, 0x000fc60004000000ULL,
0x0000001f004b7308ULL, 0x0007e20000000800ULL, 0x000000370c00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b291e7823ULL, 0x004fc60000010838ULL, 0x0000000c37097208ULL, 0x000fc60004000000ULL,
0x0000004c004f7308ULL, 0x0005e20000000800ULL, 0x000000660900720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b341f7823ULL, 0x008fc60000010838ULL, 0x00000009660c7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b28097823ULL, 0x100fe40000010838ULL, 0x0000004800517308ULL, 0x0007e20000000800ULL,
0x000000670c00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b654c7823ULL, 0x004fc60000010838ULL,
0x0000000c67157208ULL, 0x000fe40004000000ULL, 0x000000211600720bULL, 0x000fe20003f1e000ULL,
0x0000004900527308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b35487823ULL, 0x008fe20000010838ULL,
0x0c401f00152c7f89ULL, 0x000ee200000e0000ULL, 0x0000001621167208ULL, 0x000fc80004000000ULL,
0x000000391600720bULL, 0x000fe20003f1e000ULL, 0x0000002d00587308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b64497823ULL, 0x004fe40000010838ULL, 0x00000016390d7208ULL, 0x000fc80004000000ULL,
0x000000540d00720bULL, 0x000fe20003f1e000ULL, 0x0000000900097308ULL, 0x000fe60000000800ULL,
0x0000000d540c7208ULL, 0x000fc80004000000ULL, 0x000000550c00720bULL, 0x000fe20003f1e000ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x0000002c1500720bULL, 0x008fe40003f3e000ULL,
0x0000000c550d7208ULL, 0x000fe40004000000ULL, 0x000000152c157208ULL, 0x000fe40004800000ULL,
0x0000003c0d00720bULL, 0x000fe20003f1e000ULL, 0x0000002300237308ULL, 0x000fe40000000800ULL,
0x0c201f0015167f89ULL, 0x000ea200000e0000ULL, 0x0000000d3c0c7208ULL, 0x000fc80004000000ULL,
0x0000003d0c00720bULL, 0x000fe20003f1e000ULL, 0x0000004a004a7308ULL, 0x000fe60000000800ULL,
0x0000000c3d0d7208ULL, 0x000fc80004000000ULL, 0x000000200d00720bULL, 0x000fe20003f1e000ULL,
0x0000004900497308ULL, 0x000fe60000000800ULL, 0x0000000d200d7208ULL, 0x000fc80004000000ULL,
0x000000240d00720bULL, 0x000fe20003f1e000ULL, 0x0000004c004c7308ULL, 0x000fe20000000800ULL,
0x000000161500720bULL, 0x004fe40003f3e000ULL, 0x0000000d240d7208ULL, 0x000fe40004000000ULL,
0x0000001516157208ULL, 0x000fe40004800000ULL, 0x000000400d00720bULL, 0x000fe20003f1e000ULL,
0x0000001f001f7308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b15287820ULL, 0x000fe20000410000ULL,
0x0000000d400c7208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010828ULL,
0x000000410c00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010828ULL, 0x0000000e00297308ULL, 0x0005e20000000800ULL,
0x0000000c410d7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010828ULL,
0x000000800d00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010828ULL, 0x00000011002c7308ULL, 0x0007220000000800ULL,
0x0000000d800c7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b18187823ULL, 0x100fe20000010828ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010828ULL,
0x000000810c00720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010828ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010828ULL, 0x0000003200597308ULL, 0x000fe20000000800ULL,
0x0000000c810d7208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010828ULL,
0x0000003a1700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b66667823ULL, 0x100fe20000010828ULL,
0x000000440d00720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b67287823ULL, 0x000fe20000010828ULL,
0x000000173a0c7208ULL, 0x000fe20004000000ULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x0000000d440e7208ULL, 0x004fc40004800000ULL, 0x0000003b0c00720bULL, 0x000fe40003f1e000ULL,
0x000000450e00720bULL, 0x000fe40003f3e000ULL, 0x0000000c3b0d7208ULL, 0x000fe20004000000ULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x0000000e45117208ULL, 0x008fe40004800000ULL,
0x000000560d00720bULL, 0x000fe40003f1e000ULL, 0x0000007c1100720bULL, 0x000fc40003f3e000ULL,
0x0000000d560c7208ULL, 0x000fe20004000000ULL, 0x0000002e00307308ULL, 0x0005e20000000800ULL,
0x000000117c0e7208ULL, 0x000fe40004800000ULL, 0x000000570c00720bULL, 0x000fe40003f1e000ULL,
0x0000007d0e00720bULL, 0x000fe40003f3e000ULL, 0x0000000c570d7208ULL, 0x000fe20004000000ULL,
0x0000002f002f7308ULL, 0x000ee20000000800ULL, 0x0000000e7d0e7208ULL, 0x000fc40004800000ULL,
0x0000003e0d00720bULL, 0x000fe40003f1e000ULL, 0x000000292c29723eULL, 0x010fe200000000ffULL,
0x0c401f000e117f89ULL, 0x000f2200000e0000ULL, 0x0000000d3e0c7208ULL, 0x000fe20004000000ULL,
0x00000033005c7308ULL, 0x000fe20000000800ULL, 0x00000051522c723eULL, 0x000fe400000000ffULL,
0x0000003f0c00720bULL, 0x000fe40003f1e000ULL, 0x0000004d582e723eULL, 0x004fc400000000ffULL,
0x0000000c3f0c7208ULL, 0x000fe20004000000ULL, 0x0000002b005a7308ULL, 0x0005e20000000800ULL,
0x000000302f2f723eULL, 0x008fe400000000ffULL, 0x000000250c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c250c7208ULL, 0x000fe20004000000ULL, 0x0000002a00537308ULL, 0x0007e20000000800ULL,
0x00000013122b723eULL, 0x004fe200000000ffULL, 0x3c003c00ff127424ULL, 0x000fe200078e00ffULL,
0x000000270c00720bULL, 0x000fe40003f1e000ULL, 0x3c003c0000137802ULL, 0x000fe40000000f00ULL,
0x0000000c270d7208ULL, 0x000fe20004000000ULL, 0x00000036005b7308ULL, 0x000fe20000000800ULL,
0x000000110e00720bULL, 0x010fc40003f3e000ULL, 0x000000420d00720bULL, 0x000fe40003f1e000ULL,
0x0000000e110e7208ULL, 0x000fe40004800000ULL, 0x0000000d420c7208ULL, 0x000fe20004000000ULL,
0x00000037005e7308ULL, 0x000fe20000000800ULL, 0x0000004f502a723eULL, 0x008fe200000000ffULL,
0x0c201f000e117f89ULL, 0x000ea200000e0000ULL, 0x000000430c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c430d7208ULL, 0x000fe20004000000ULL, 0x0000001900197308ULL, 0x000fe60000000800ULL,
0x000000820d00720bULL, 0x000fc80003f1e000ULL, 0x0000000d820c7208ULL, 0x000fe20004000000ULL,
0x0000001800187308ULL, 0x000ee60000000800ULL, 0x000000830c00720bULL, 0x000fc80003f1e000ULL,
0x0000000c830d7208ULL, 0x000fe20004000000ULL, 0x0000004800487308ULL, 0x000f220000000800ULL,
0x000000110e00720bULL, 0x004fe40003f3e000ULL, 0x000000460d00720bULL, 0x000fe40003f1e000ULL,
0x0000000e11167208ULL, 0x000fe40004800000ULL, 0x0000000d460c7208ULL, 0x000fe20004000000ULL,
0x0000002800117308ULL, 0x0005e20000000800ULL, 0x00000019182d723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b160e7820ULL, 0x000fe20000410000ULL, 0x000000470c00720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b39397823ULL, 0x100fe2000001080eULL, 0x0000000c470d7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001080eULL,
0x0000003900327308ULL, 0x000fe20000000800ULL, 0x0000007e0d00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b54547823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b55557823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b20207823ULL, 0x100fe2000001080eULL, 0x0000000d7e0c7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe2000001080eULL, 0x0000004b4e28723eULL, 0x004fe200000000ffULL,
0x0000002400397308ULL, 0x000fe20000000800ULL, 0x0000007f0c00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b40407823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b41417823ULL, 0x100fe2000001080eULL, 0x0000000c7f0c7208ULL, 0x000fe20004000000ULL,
0x000000122834723cULL, 0x000fe200000018ffULL, 0x3fb8aa3b80807823ULL, 0x100fe2000001080eULL,
0x0000002100217308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b81817823ULL, 0x100fe2000001080eULL,
0x0c401f000c0d7f89ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b44447823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b45457823ULL, 0x100fe2000001080eULL, 0x3fb8aa3b7c7c7823ULL, 0x100fe2000001080eULL,
0x3fb8aa3b7d0e7823ULL, 0x000fe2000001080eULL, 0x0000001f4848723eULL, 0x010fe200000000ffULL,
0x0000005400547308ULL, 0x000fe20000000800ULL, 0x000000213230723eULL, 0x004fce00000000ffULL,
0x0000005500557308ULL, 0x000ea20000000800ULL, 0xfffffff8ff217812ULL, 0x000fca00078ee20fULL,
0x000000122c34723cULL, 0x000fe20000001834ULL, 0x0000001821507836ULL, 0x000fe20000000000ULL,
0x0000002000207308ULL, 0x000f220000000800ULL, 0x0000000d0c00720bULL, 0x008fc80003f1e000ULL,
0x0000000c0d0c7208ULL, 0x000fe40004000000ULL, 0x000000545532723eULL, 0x004fe200000000ffULL,
0x0000000e005f7308ULL, 0x0009e20000000800ULL, 0x000000ffff547224ULL, 0x000fe200078e0028ULL,
0x0c201f000c177f89ULL, 0x000ea200000e0000ULL, 0x0000002a00557202ULL, 0x000fe20000000f00ULL,
0x000000ffff287224ULL, 0x000fe200078e0029ULL, 0x0000002b00297202ULL, 0x000fe20000000f00ULL,
0x000000ffff2a7224ULL, 0x000fe400078e002dULL, 0x00000040005d7308ULL, 0x000fe20000000800ULL,
0x00000020390e723eULL, 0x010fe200000000ffULL, 0x000000ffff2b7224ULL, 0x000fe200078e002fULL,
0x0000000310207812ULL, 0x000fca00078ec0ffULL, 0x0000003c003c7308ULL, 0x000fe20000000800ULL,
0x0000000120207824ULL, 0x000fca00078e0207ULL, 0x0000000720517812ULL, 0x000fe400078ec0ffULL,
0x0000003d003d7308ULL, 0x000fe20000000800ULL, 0x000000170c00720bULL, 0x004fc80003f1e000ULL,
0x0000000c17177208ULL, 0x000fc60004000000ULL, 0x0000004100607308ULL, 0x000fe20000000800ULL,
0x0000000307ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b17247820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b56567823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b57577823ULL, 0x100fe20000010824ULL,
0x0000003a00317308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b25257823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b82827823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b83837823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010824ULL,
0x0000003b000c7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b47477823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b7e7e7823ULL, 0x100fe20000010824ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010824ULL, 0x3fb8aa3b7f247823ULL, 0x000fc60000010824ULL,
0x0000005600337308ULL, 0x0007e20000000800ULL, 0x000000310c31723eULL, 0x004fce00000000ffULL,
0x0000005700387308ULL, 0x0005220000000800ULL, 0x0000003c3d0c723eULL, 0x000fe200000000ffULL,
0x00000008213c7824ULL, 0x000fe200078e00ffULL, 0x000000535a3d723eULL, 0x000fe200000000ffULL,
0x000000ffff567224ULL, 0x008fe400078e002cULL, 0x000000ffff5a7224ULL, 0x000fe400078e0048ULL,
0x0000003e000d7308ULL, 0x000fe20000000800ULL, 0x000000ffff577224ULL, 0x004fe400078e002eULL,
0x000000ffff2c7224ULL, 0x000fe200078e003dULL, 0x000000333833723eULL, 0x010fc800000000ffULL,
0x0000003f00407308ULL, 0x0004e60000000800ULL, 0x000000123038723cULL, 0x000fea00000018ffULL,
0x0000002500257308ULL, 0x000fe20000000800ULL, 0x000000595c3f723eULL, 0x004fc800000000ffULL,
0x0000003f002d7202ULL, 0x000fe40000000f00ULL, 0x0000000d400d723eULL, 0x008fe200000000ffULL,
0x00000027004e7308ULL, 0x0004f00000000800ULL, 0x0000008000807308ULL, 0x000fe20000000800ULL,
0x0000000821277836ULL, 0x004fc80000000000ULL, 0x00000008273e7824ULL, 0x000fe200078e00ffULL,
0x000000254e0f723eULL, 0x008fe400000000ffULL, 0x0000008100817308ULL, 0x000ea20000000800ULL,
0x00000010214e7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff83c257812ULL, 0x000fe400078ee251ULL,
0xfffffff83e4d7812ULL, 0x000fe200078ee251ULL, 0x000000120c38723cULL, 0x000fe20000001838ULL,
0x000000084e407824ULL, 0x000fe200078e00ffULL, 0x0000004200187308ULL, 0x0007e20000000800ULL,
0x000000091e3c723eULL, 0x000fc400000000ffULL, 0x000000234a3e723eULL, 0x000fe200000000ffULL,
0x000000ffff237224ULL, 0x000fe200078e00a1ULL, 0xfffffff8404f7812ULL, 0x000fe200078ee251ULL,
0x000000ffff587224ULL, 0x000fe200078e003cULL, 0x000000494c4a723eULL, 0x000fe200000000ffULL,
0x0000004300197308ULL, 0x0009620000000800ULL, 0x0000000350427819ULL, 0x008fe400000006ffULL,
0x0000005b5e49723eULL, 0x000fe200000000ffULL, 0x000000ffff5b7224ULL, 0x000fe200078e004aULL,
0xfffffff842517812ULL, 0x000fc400078ee251ULL, 0x000000034e1f7819ULL, 0x000fe200000006ffULL,
0x0000008200827308ULL, 0x000fe20000000800ULL, 0x000000123c40723cULL, 0x010fec0000001834ULL,
0x0000003e00597202ULL, 0x000fe20000000f00ULL, 0x000000ffff2e7224ULL, 0x000fe200078e0049ULL,
0x0000008300837308ULL, 0x000ee20000000800ULL, 0x0000005d6034723eULL, 0x000fe200000000ffULL,
0x000000ffff3c7224ULL, 0x000fe200078e0030ULL, 0x000000808136723eULL, 0x004fe200000000ffULL,
0x000000ffff3e7224ULL, 0x000fe200078e000cULL, 0x000000181935723eULL, 0x022fe200000000ffULL,
0x0000000827197824ULL, 0x000fe200078e00ffULL, 0x00000032003d7202ULL, 0x000fe20000000f00ULL,
0x0000004400447308ULL, 0x000fe20000000800ULL, 0x000000ffff3f7224ULL, 0x000fc400078e000eULL,
0x000000ffff307224ULL, 0x000fe200078e0031ULL, 0x0000003300317202ULL, 0x000fe20000000f00ULL,
0x000000ffff327224ULL, 0x000fe200078e000dULL, 0x000000828337723eULL, 0x008fe400000000ffULL,
0x0000004500457308ULL, 0x000e620000000800ULL, 0x000000ffff337224ULL, 0x000fe400078e000fULL,
0x000000ffff0c7224ULL, 0x000fe200078e0035ULL, 0x00000037000d7202ULL, 0x000fe20000000f00ULL,
0x000000123438723cULL, 0x000fe60000001838ULL, 0x0000006600667308ULL, 0x000ea20000000800ULL,
0x000000444544723eULL, 0x002fce00000000ffULL, 0x0000004600207308ULL, 0x000fe20000000800ULL,
0x00000066114b723eULL, 0x004fce00000000ffULL, 0x0000004700477308ULL, 0x000e620000000800ULL,
0x0000000407117810ULL, 0x000fe20007ffe010ULL, 0x0000100022107824ULL, 0x000fe400078e021dULL,
0x000000ffff2f7224ULL, 0x000fe200078e004bULL, 0x0000000711187812ULL, 0x000fe200078ec0ffULL,
0x000000124840723cULL, 0x000fe20000001840ULL, 0x0000000821117824ULL, 0x000fe200078e00ffULL,
0x0000007c007c7308ULL, 0x000ea20000000800ULL, 0x0001200010107836ULL, 0x000fe20000000000ULL,
0xfffffff819197812ULL, 0x000fe200078ee218ULL, 0x0000000850217824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee218ULL, 0x000000104d4d7824ULL, 0x100fe200078e0210ULL,
0x0000001025257211ULL, 0x000fe200078e20ffULL, 0x0000001019197824ULL, 0x100fe200078e0210ULL,
0x0000007e007e7308ULL, 0x000fe20000000800ULL, 0x000000204745723eULL, 0x002fe200000000ffULL,
0x0000001011117824ULL, 0x100fe200078e0210ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee218ULL,
0x000000104f4f7824ULL, 0x000fe200078e0210ULL, 0xfffffff821217812ULL, 0x000fe200078ee218ULL,
0x0000005425007844ULL, 0x0003e20000000200ULL, 0x0000007c5f46723eULL, 0x004fe200000000ffULL,
0x0000002400097308ULL, 0x000ea20000000800ULL, 0x000000101f1f7211ULL, 0x000fe200078e20ffULL,
0x000000ffff487224ULL, 0x000fe200078e0034ULL, 0x0000003600497202ULL, 0x000fe20000000f00ULL,
0x000000ffff4a7224ULL, 0x000fe200078e0044ULL, 0x0000005811007844ULL, 0x0003e20000000200ULL,
0x000000ffff4b7224ULL, 0x000fc400078e0046ULL, 0x0000001051517824ULL, 0x100fe200078e0210ULL,
0x000000284d007844ULL, 0x0003e20000000200ULL, 0x0000001021217824ULL, 0x000fe400078e0210ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0045ULL, 0x0000002c19007844ULL, 0x0003e20000000200ULL,
0x000000ffff417224ULL, 0x000fe200078e0042ULL, 0x0000007e0947723eULL, 0x004fe200000000ffULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x0000003c4f007844ULL, 0x0003e60000000200ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0047ULL, 0x000000481f007844ULL, 0x0003e20000000200ULL,
0x000000124438723cULL, 0x000fe60000001838ULL, 0x0000003051007844ULL, 0x0003e80000000200ULL,
0x0000000c21007844ULL, 0x0003e80000000200ULL, 0x01e000140b008388ULL, 0x0003da0000000c00ULL,
0x0000003800427202ULL, 0x000fe20000000f00ULL, 0x000000ffff437224ULL, 0x000fca00078e003aULL,
0x01e200400b008388ULL, 0x0003e20000000c00ULL, 0x0000001aa100720cULL, 0x000fe20003f06070ULL,
0x01e6080908ff79a7ULL, 0x0003e2000850003fULL, 0x01e6100908ff79a7ULL, 0x0003e2000850003fULL,
0x01e6180908ff79a7ULL, 0x0003e2000850003fULL, 0x01e6200908ff79a7ULL, 0x0003f2000850003fULL,
0xffffff7c00288947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000027007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000007945ULL, 0x000fe60003800000ULL,
0x7f80000000037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000002700008308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff27ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000027037812ULL, 0x000fd600078ec0ffULL,
0x0080000003000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0003ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000002700007308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffffe7c040c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000100000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x0000000000000447ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005c8ULL, 0x00000000000001f8ULL, 0x0000001300000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000007c0ULL, 0x00000000000000d0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000890ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000008e4ULL, 0x0000000000000520ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e08ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e08ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000e50ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000e80ULL, 0x0000000000018480ULL, 0x0000001300000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019300ULL, 0x0000000000000038ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019340ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000019340ULL, 0x0000000000000270ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000019930ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000019930ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000000e50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000000e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000018480ULL,
0x0000000000018480ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000019300ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000019340ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000270ULL, 0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_0_m_32_sm_90_cubin_len = 105088;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
