/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000153c0ULL, 0x0000000000015040ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x4545386a4c45386aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x36316a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL, 0x735f616475635f5fULL,
0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL, 0x695f5f2400687461ULL,
0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL, 0x5f636e79736c6668ULL,
0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL, 0x376d735f61647563ULL,
0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL, 0x245f335f6c616e72ULL,
0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL, 0x6c65722e00746f6cULL,
0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL, 0x6e72656b2e747865ULL,
0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL, 0x2e00667542657479ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x2e006d617261705fULL,
0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL,
0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL, 0x0000006e6f697463ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000c000100000362ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000003a7ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000b0022000003edULL,
0x00000000000137f0ULL, 0x0000000000000170ULL, 0x000b002200000420ULL, 0x0000000000013960ULL,
0x0000000000000040ULL, 0x000b00220000044bULL, 0x00000000000139a0ULL, 0x0000000000000050ULL,
0x000b002200000475ULL, 0x00000000000139f0ULL, 0x0000000000000110ULL, 0x000a0003000004e3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000503ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000533ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000013b00ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000137f000000000ULL, 0x0000040400000000ULL, 0x810c000001200400ULL, 0x004ccc0400288080ULL,
0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8c08288080890828ULL,
0x2880809408288080ULL, 0x8097082880809608ULL, 0x0828808098082880ULL, 0x808280162880808aULL,
0x0000000000031028ULL, 0x2880808a92000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x0000007000000000ULL, 0x000137f000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL,
0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8c08288080890828ULL, 0x2880809208288080ULL,
0x8094082880809308ULL, 0x0828808097082880ULL, 0x8080ae08288080b1ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x002200288080ae92ULL, 0x0000001cffffffffULL, 0x0000010800000000ULL,
0x0001396000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0x8c08288080890828ULL, 0x2880809208288080ULL, 0x8094082880809308ULL,
0x0828808096082880ULL, 0x8082801628808097ULL, 0x0000000000031028ULL, 0x2880809792000000ULL,
0x0000000000002200ULL, 0x0000002cffffffffULL, 0x000001a000000000ULL, 0x000139a000000000ULL,
0x0000005000000000ULL, 0x0000100400000000ULL, 0x808c288080970900ULL, 0x0000000000002880ULL,
0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8c08288080890828ULL, 0x2880809208288080ULL,
0x8094082880809308ULL, 0x0828808097082880ULL, 0x8082801628808096ULL, 0x0000000000031028ULL,
0x2880809692000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL, 0x0000024800000000ULL,
0x000139f000000000ULL, 0x0000011000000000ULL, 0x0000180400000000ULL, 0x808c288080960900ULL,
0x0000000000002880ULL, 0x0000001800082f04ULL, 0x0008230400000080ULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL,
0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL,
0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL,
0x0000001100082304ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008230400000000ULL, 0x0000000000000018ULL, 0x0000001800081204ULL, 0x0008110400000000ULL,
0x0000000000000018ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0050016000000015ULL,
0x000c170400501903ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL,
0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0000002000043104ULL,
0xffffffff01542904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000f001542804ULL,
0x0000033000000120ULL, 0x000029d0000016a0ULL, 0x00002ba000002a90ULL, 0x00002f2000002d10ULL,
0x00002fa000002f50ULL, 0x000036c000002ff0ULL, 0x0000491000004870ULL, 0x00004b9000004a30ULL,
0x00004dd000004da0ULL, 0x00004e7000004e20ULL, 0x000064e000005270ULL, 0x000066b000006580ULL,
0x00006a2000006810ULL, 0x00006aa000006a50ULL, 0x00006f1000006af0ULL, 0x0000813000008090ULL,
0x000083b000008250ULL, 0x000085e0000085b0ULL, 0x0000868000008630ULL, 0x00008b0000008af0ULL,
0x0000add00000ad90ULL, 0x0000b5e00000b5a0ULL, 0x0001207000012030ULL, 0x0001209000012080ULL,
0x00012100000120e0ULL, 0x0001213000012120ULL, 0x00012dc000012d70ULL, 0x00012e6000012e10ULL,
0x00012f2000012ec0ULL, 0x00012fc000012f70ULL, 0x0001306000013010ULL, 0x00013110000130c0ULL,
0x000131b000013160ULL, 0x00013240000131f0ULL, 0x000132f0000132a0ULL, 0x0001339000013340ULL,
0x00013420000133d0ULL, 0x000134d000013480ULL, 0x0001358000013520ULL, 0x00013640000135e0ULL,
0x00013700000136a0ULL, 0x000137c000013760ULL, 0x000001f002003904ULL, 0x00013600000000ffULL,
0x00000270003f0100ULL, 0x000136080000000bULL, 0x00000310003f0120ULL, 0x000136880000000bULL,
0x00000410003f0120ULL, 0x00013600000000ffULL, 0x000005c0003f0107ULL, 0x0001368c0000000bULL,
0x00000670003f0102ULL, 0x000136880000000bULL, 0x000026d0003f0101ULL, 0x0001360800000078ULL,
0x000026f0003f0101ULL, 0x0001360c00000078ULL, 0x000028c0003f0105ULL, 0x0001360c00000078ULL,
0x00003660003f0105ULL, 0x0001368800000060ULL, 0x000045d0003f0101ULL, 0x0001362800000078ULL,
0x000045f0003f0101ULL, 0x0001362c00000078ULL, 0x000047c0003f0105ULL, 0x0001362c00000078ULL,
0x00005220003f0105ULL, 0x0001369000000060ULL, 0x00006200003f0101ULL, 0x0001364800000078ULL,
0x00006260003f0101ULL, 0x0001364c00000077ULL, 0x00006430003f0105ULL, 0x0001364c00000077ULL,
0x00006ea0003f0105ULL, 0x0001369800000060ULL, 0x00007df0003f0101ULL, 0x0001366800000077ULL,
0x00007e10003f0101ULL, 0x0001366c00000077ULL, 0x00007fe0003f0105ULL, 0x0001366c00000077ULL,
0x00008920003f0105ULL, 0x000136a000000060ULL, 0x0000c1e0003f0101ULL, 0x00013600000000ffULL,
0x0000cfb0003f0101ULL, 0x00013604000000ffULL, 0x0000d180003f0105ULL, 0x00013604000000ffULL,
0x00011430003f0105ULL, 0x0000000000000050ULL, 0x00011560003f0101ULL, 0x0000000400000050ULL,
0x00011730003f0105ULL, 0x0000000400000050ULL, 0x00012bd0003f0105ULL, 0x0001360800000000ULL,
0x00012c30003f0101ULL, 0x0001361000000000ULL, 0x00012c90003f0101ULL, 0x0001361800000000ULL,
0x00012d00003f0101ULL, 0x0001362000000000ULL, 0x00033803003f0101ULL, 0x0000be4000141c04ULL,
0x0000d1e00000c0b0ULL, 0x00012d400000d270ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x00000000000002ccULL, 0x0000001800000002ULL, 0x0000000000000224ULL, 0x0000001800000002ULL,
0x000000000000018cULL, 0x0000001800000002ULL, 0x00000000000000f4ULL, 0x0000001800000002ULL,
0x0000000000000044ULL, 0x0000001800000002ULL, 0x00000000000002a3ULL, 0x0000001800000002ULL,
0x00000000000001fbULL, 0x0000001800000002ULL, 0x0000000000000168ULL, 0x0000001800000002ULL,
0x00000000000000cbULL, 0x0000001800000002ULL, 0x0000000000013700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x00000000000b7919ULL, 0x000e620000002100ULL,
0x00000000000f7806ULL, 0x000fe200038e0000ULL, 0x00005800ff117624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000ea20000002300ULL,
0x0000000f00067300ULL, 0x000ee200000e0000ULL, 0x0000000811057824ULL, 0x000fe200078e00ffULL,
0x00000000000479c3ULL, 0x000f220000002500ULL, 0x0000000000007919ULL, 0x000ea80000002200ULL,
0x0000000000077919ULL, 0x000ee20000000000ULL, 0x0000000f00137309ULL, 0x0002a60000000000ULL,
0x00000000000e7919ULL, 0x000ee80000002600ULL, 0x0000000000557919ULL, 0x000ee20000002700ULL,
0x00000005ff5a7819ULL, 0x002fcc000001160bULL, 0x00001fff5a5a7589ULL, 0x000fe200000e0000ULL,
0x00000004ff5c7e24ULL, 0x010fe4000f8e00ffULL, 0x0000010009007a24ULL, 0x004fe400078e0200ULL,
0x00001fff09097589ULL, 0x000e6200000e0000ULL, 0x000000070600720cULL, 0x008fe20003f62070ULL,
0x00000000000b7a24ULL, 0x000fe400078e020bULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x000000080e047824ULL, 0x000fc400078e00ffULL, 0x000000ff0b00720cULL, 0x040fe40003f05270ULL,
0x0000000f0b00780cULL, 0x000fe20003f24070ULL, 0x0000005505067224ULL, 0x000fe200078e0204ULL,
0x0000007f0b00780cULL, 0x000fd20003f44070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x0000000409077824ULL, 0x002fe400078e025aULL,
0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL, 0x01360002ff008388ULL, 0x0003e20000000a00ULL,
0x000000030b00780cULL, 0x000fe20003f04070ULL, 0x0000000207077824ULL, 0x000fe200078e00ffULL,
0x00000004ff0c7819ULL, 0x004fe20000011600ULL, 0x7fffffc0ff059424ULL, 0x000fc400078e00ffULL,
0xff317217ff10a424ULL, 0x000fe200078e00ffULL, 0x0000000807087817ULL, 0x040fe20007800000ULL,
0x00000001070d7824ULL, 0x000fe200078e020cULL, 0x013608040b009388ULL, 0x0005e20000008a00ULL,
0x00000100ff037424ULL, 0x002fe400078e00ffULL, 0x00000001080a7824ULL, 0x000fe200078e0a07ULL,
0x013400100b00a388ULL, 0x000fe20000004800ULL, 0x0000000106027824ULL, 0x000fe400078e020dULL,
0x0000001000087824ULL, 0x000fc400078e00ffULL, 0x3fffff60ff068424ULL, 0x000fe400078e00ffULL,
0x7fffff60ff078424ULL, 0x000fe200078e00ffULL, 0x000000f0080f7812ULL, 0x000fe200078ec0ffULL,
0x00005c0002027625ULL, 0x000fc600078e0003ULL, 0x013688060b008388ULL, 0x000fe20000008a00ULL,
0x000000010d057824ULL, 0x004fc600078e0200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000100d127824ULL, 0x000fe200078e00ffULL, 0x0000000a0c00720cULL, 0x000fe20003f06070ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0a13ULL, 0x0000000f02047210ULL, 0x000fe20007f3e0ffULL,
0x00000004ff0c7424ULL, 0x000fe200078e00ffULL, 0xfffffff012027812ULL, 0x000fc600078ee205ULL,
0x000000ffff057224ULL, 0x000fe400008e0603ULL, 0x00000010020d7824ULL, 0x000fe400078e00ffULL,
0x0000620055027625ULL, 0x000fc600078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e8000c101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0136040affff338cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01360000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000602587981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fc40003f05270ULL, 0x0000007f58597810ULL, 0x044fe40007ffe0ffULL,
0x000000ff58537810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff597819ULL, 0x000fe40000011659ULL,
0x00000008ff537819ULL, 0x000fca0000011653ULL, 0x0000bbc000008947ULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x000fe2000001165aULL, 0x000000085a0b7824ULL, 0x000fe400078e00ffULL,
0xffffffffff0a7424ULL, 0x002fe200078e00ffULL, 0x01ffffff02037812ULL, 0x000fca00078ec0ffULL,
0x000000025c507824ULL, 0x000fca00078e0203ULL, 0x000000595000720cULL, 0x000fda0003f06070ULL,
0x0000000255028824ULL, 0x000fe400078e00ffULL, 0x00006400ff038624ULL, 0x000fc800078e00ffULL,
0x0000640002038624ULL, 0x000fe400078e0203ULL, 0x00000003ff027424ULL, 0x000fe400078e00ffULL,
0x0000000150038824ULL, 0x000fe200078e0203ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01368c020bff738cULL, 0x0003e20000000000ULL, 0x0000600003048625ULL, 0x000fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000006040a8981ULL, 0x000ea2000c1e1900ULL,
0x000000015c067810ULL, 0x000fe20007ffe0ffULL, 0x000000800e037824ULL, 0x000fe200078e00ffULL,
0x00000001ff517819ULL, 0x000fe2000001165aULL, 0x013688000bff7f8cULL, 0x0007e2000c80043fULL,
0x000000530600720cULL, 0x000fc40003f06070ULL, 0x000000015a527812ULL, 0x000fe200078ec0ffULL,
0x0000002051027824ULL, 0x002fc800078e00ffULL, 0x000001005c0d7824ULL, 0x000fca00078e0202ULL,
0x0000006003187812ULL, 0x000fe200078ef80dULL, 0x000058000a067a24ULL, 0x004fc800078e02ffULL,
0x00000080061c7824ULL, 0x000fe200078e00ffULL, 0x0000073000008947ULL, 0x000fea0003800000ULL,
0x00000003ff0f7819ULL, 0x108fe20000011600ULL, 0x0000000852197824ULL, 0x000fe200078e00ffULL,
0x0000000d58047217ULL, 0x000fe40007800000ULL, 0x000000040f077810ULL, 0x040fe40007ffe0ffULL,
0x000000080f097810ULL, 0x040fe20007ffe0ffULL, 0x0000000104047824ULL, 0x000fe200078e0a0dULL,
0x0000000c0f157810ULL, 0x000fe20007ffe0ffULL, 0x0000000107057824ULL, 0x100fe200078e0200ULL,
0x000000100f217810ULL, 0x000fe20007ffe0ffULL, 0x0000000807087824ULL, 0x000fe200078e00ffULL,
0x0000002004167817ULL, 0x000fe20003800000ULL, 0x0000000109067824ULL, 0x000fe200078e0200ULL,
0x000000140f237810ULL, 0x000fe20007ffe0ffULL, 0x00000008091d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8081b7812ULL, 0x000fe200078ee205ULL, 0x0000000118057824ULL, 0x040fe200078e020fULL,
0x000000160700720cULL, 0x080fe20003f06070ULL, 0x0000000118077824ULL, 0x040fe200078e0207ULL,
0x000000160900720cULL, 0x000fe20003f26070ULL, 0x0000000118097824ULL, 0x000fe200078e0209ULL,
0x000000051c057210ULL, 0x000fe20007f5e0ffULL, 0x0000000118047824ULL, 0x000fe200078e0215ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL, 0x00000001151a7824ULL, 0x000fe200078e0200ULL,
0x000000071c077210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff067224ULL, 0x000fe200010e06ffULL,
0x00005e0005107a11ULL, 0x000fe200078440ffULL, 0x00000008151f7824ULL, 0x000fe200078e00ffULL,
0x000000091c097210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff127224ULL, 0x000fe200018e06ffULL,
0x000000041c047210ULL, 0x000fc40007fbe0ffULL, 0x00005f0005117a11ULL, 0x000fe200010f4406ULL,
0x000000ffff0e7224ULL, 0x000fe200020e06ffULL, 0x00005e00070c7a11ULL, 0x040fe200078440ffULL,
0x000000ffff057224ULL, 0x000fe200028e06ffULL, 0x00005e0004067a11ULL, 0x040fe400078840ffULL,
0x00005f00070d7a11ULL, 0x000fe400010f4412ULL, 0x00005f0004077a11ULL, 0x000fe200020f4405ULL,
0x0000000118047824ULL, 0x040fe200078e0221ULL, 0x00005e0009087a11ULL, 0x000fe200078640ffULL,
0x0000000118057824ULL, 0x000fe200078e0223ULL, 0x000000180f257810ULL, 0x000fc40007ffe0ffULL,
0x0000001c0f277810ULL, 0x000fe40007ffe0ffULL, 0x000000041c137210ULL, 0x000fe40007f5e0ffULL,
0x00005f0009097a11ULL, 0x000fe200018f440eULL, 0x00000001180e7824ULL, 0x040fe200078e0225ULL,
0x00005e0013047a11ULL, 0x000fe200078640ffULL, 0x0000000118127824ULL, 0x000fe200078e0227ULL,
0x000000051c147210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0x0000000e1c1e7210ULL, 0x000fc40007f9e0ffULL, 0x000000121c1c7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200028e06ffULL, 0x00005f0013057a11ULL, 0x000fe200018f4418ULL,
0x0000000251187824ULL, 0x000fe200078e0252ULL, 0x000000160f00720cULL, 0x040fe20003f66070ULL,
0x000000010f0f7824ULL, 0x000fe200078e0200ULL, 0x00005e00140e7a11ULL, 0x000fe200078a40ffULL,
0x000000ffff297224ULL, 0x000fe200020e06ffULL, 0x0000b00018187811ULL, 0x000fe400078e68ffULL,
0x000000070f137812ULL, 0x000fc400078ec0ffULL, 0x00005f00140f7a11ULL, 0x000fe200028f4417ULL,
0x000000101b1b7824ULL, 0x000fe200078e0218ULL, 0x0ffffff813137812ULL, 0x000fe200078ef800ULL,
0x000000101d1d7824ULL, 0x000fe200078e0218ULL, 0xfffffff819177812ULL, 0x000fe400078ee200ULL,
0x00005e001e147a11ULL, 0x000fe200078840ffULL, 0x0000001013197824ULL, 0x000fe200078e0218ULL,
0x00005e001c127a11ULL, 0x000fe200078a40ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x000000161500720cULL, 0x000fe20003f46070ULL, 0x0000001017107825ULL, 0x000fe200078e0010ULL,
0x00005f001e157a11ULL, 0x000fc400020f4429ULL, 0x00005f001c137a11ULL, 0x000fe200028f4413ULL,
0x00000001251c7824ULL, 0x000fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010197faeULL, 0x0003e2000d901c46ULL, 0x000000162100720cULL, 0x080fe20003f66070ULL,
0x00000010170c7825ULL, 0x000fe200078e000cULL, 0x000000162300720cULL, 0x080fe40003f86070ULL,
0x000000162500720cULL, 0x0c0fe20003fa6070ULL, 0x0000000825257824ULL, 0x000fe200078e00ffULL,
0x000000162700720cULL, 0x000fe20003fc6070ULL, 0x0000000121167824ULL, 0x000fe200078e0200ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee21aULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0x000000000c1b7faeULL, 0x0005e2000c101c46ULL, 0x00000001231a7824ULL, 0x000fc400078e0200ULL,
0x0000000823237824ULL, 0x000fe200078e00ffULL, 0xfffffff821117812ULL, 0x002fe200078ee216ULL,
0x0000000127107824ULL, 0x000fe200078e0200ULL, 0xfffffff825217812ULL, 0x000fe200078ee21cULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0xfffffff823197812ULL, 0x000fe200078ee21aULL,
0x0000001017087825ULL, 0x000fc600078e0008ULL, 0xfffffff827237812ULL, 0x000fe200078ee210ULL,
0x000000101f1f7824ULL, 0x000fe200078e0218ULL, 0x00000000081d7faeULL, 0x0005e2000c901c46ULL,
0x0000001017067825ULL, 0x000fc800078e0006ULL, 0x0000001011117824ULL, 0x000fe200078e0218ULL,
0x00000000061f7faeULL, 0x0005e2000d101c46ULL, 0x0000001017047825ULL, 0x000fc800078e0004ULL,
0x0000001019197824ULL, 0x000fe200078e0218ULL, 0x0000000004117faeULL, 0x0005e2000d901c46ULL,
0x00000010170e7825ULL, 0x000fc800078e000eULL, 0x0000001021217824ULL, 0x000fe200078e0218ULL,
0x000000000e197faeULL, 0x0005e2000e101c46ULL, 0x0000001017147825ULL, 0x000fc800078e0014ULL,
0x0000001023237824ULL, 0x000fe200078e0218ULL, 0x0000000014217faeULL, 0x0005e2000e901c46ULL,
0x0000001017127825ULL, 0x000fca00078e0012ULL, 0x0000000012237faeULL, 0x0005e2000f101c46ULL,
0x0000066000007947ULL, 0x000fea0003800000ULL, 0x0000000400077811ULL, 0x008fe200078fe8ffULL,
0x0000000852297824ULL, 0x000fe200078e00ffULL, 0x0000000c000f7811ULL, 0x040fe400078fe8ffULL,
0x00000008000d7811ULL, 0x040fe200078fe8ffULL, 0x0000000107047824ULL, 0x140fe200078e0200ULL,
0x0000001800157811ULL, 0x040fe200078fe8ffULL, 0x0000000807097824ULL, 0x000fe200078e00ffULL,
0x0000001400137811ULL, 0x000fe200078fe8ffULL, 0x000000010f067824ULL, 0x000fc400078e0200ULL,
0x000000080f117824ULL, 0x000fe200078e00ffULL, 0xfffffff809097812ULL, 0x000fe200078ee204ULL,
0x000000010d057824ULL, 0x040fe200078e0200ULL, 0x0000001800047211ULL, 0x040fe200078fe8ffULL,
0x000000080d0c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8110e7812ULL, 0x000fe200078ee206ULL,
0x0000000115087824ULL, 0x140fe200078e0200ULL, 0x0000001000117811ULL, 0x000fe200078fe8ffULL,
0x00000008151b7824ULL, 0x000fe200078e00ffULL, 0x000000041c167210ULL, 0x000fe20007f1e0ffULL,
0x00000001180f7824ULL, 0x000fe200078e020fULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee205ULL,
0x0000000111057824ULL, 0x000fe200078e0200ULL, 0xfffffff81b147812ULL, 0x000fe200078ee208ULL,
0x0000000811107824ULL, 0x000fc400078e00ffULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0x00005e0016047a11ULL, 0x000fe200078040ffULL, 0x0000000113067824ULL, 0x040fe200078e0200ULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x0000000813197824ULL, 0x000fe200078e00ffULL,
0x00005f0016057a11ULL, 0x000fe200000f4417ULL, 0x0000000118117824ULL, 0x000fe200078e0211ULL,
0x0000001c00177811ULL, 0x000fe200078fe8ffULL, 0x0000000118137824ULL, 0x000fe200078e0213ULL,
0x0000000f1c167210ULL, 0x000fe20007f9e0ffULL, 0x0000000118157824ULL, 0x000fe200078e0215ULL,
0x000000111c0f7210ULL, 0x000fe20007f7e0ffULL, 0x0000000118077824ULL, 0x040fe200078e0207ULL,
0xfffffff819127812ULL, 0x000fe200078ee206ULL, 0x0000000118087824ULL, 0x000fe200078e0217ULL,
0x000000131c117210ULL, 0x000fe20007f1e0ffULL, 0x00000001180d7824ULL, 0x000fe200078e020dULL,
0x0000000000067211ULL, 0x000fe200078fe8ffULL, 0x000000ffff277224ULL, 0x000fe200020e06ffULL,
0x000000151c137210ULL, 0x000fc40007f5e0ffULL, 0x000000071c197210ULL, 0x040fe40007fde0ffULL,
0x000000081c157210ULL, 0x000fe20007f3e0ffULL, 0x0000000251087824ULL, 0x000fe200078e0252ULL,
0x0000000706077812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1a7224ULL, 0x000fe200030e06ffULL,
0x0000000d1c187210ULL, 0x000fe20007fbe0ffULL, 0x00000001170d7824ULL, 0x000fe200078e0200ULL,
0x00005e0019067a11ULL, 0x000fe200078c40ffULL, 0x00000008171c7824ULL, 0x000fe200078e00ffULL,
0x0000b00008257811ULL, 0x000fc400078e68ffULL, 0x0ffffff807087812ULL, 0x000fe400078ef800ULL,
0xfffffff81c0d7812ULL, 0x000fe200078ee20dULL, 0x000000100c1b7824ULL, 0x100fe200078e0225ULL,
0x00005f0019077a11ULL, 0x000fe200030f441aULL, 0x0000001009197824ULL, 0x100fe200078e0225ULL,
0x00005e00160c7a11ULL, 0x000fe200078840ffULL, 0x0000001008177824ULL, 0x100fe400078e0225ULL,
0x000000ffff097224ULL, 0x000fe200028e06ffULL, 0x00005e0018087a11ULL, 0x000fe200078a40ffULL,
0x000000100e1d7824ULL, 0x000fc400078e0225ULL, 0x00000010101f7824ULL, 0x000fe200078e0225ULL,
0x00005f0018097a11ULL, 0x000fe200028f4409ULL, 0x0000001012217824ULL, 0x100fe400078e0225ULL,
0x0000001014237824ULL, 0x100fe400078e0225ULL, 0x000000100d257824ULL, 0x000fe200078e0225ULL,
0x00005f00160d7a11ULL, 0x000fe200020f4427ULL, 0x000000ffff1c7224ULL, 0x000fe200018e06ffULL,
0xfffffff829277812ULL, 0x000fe200078ee200ULL, 0x000000ffff1a7224ULL, 0x000fe200000e06ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078640ffULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078040ffULL, 0x000000ffff167224ULL, 0x000fe200008e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078440ffULL, 0x0000001027047825ULL, 0x000fe200078e0004ULL,
0x00005e0015147a11ULL, 0x000fc400078240ffULL, 0x00005f000f0f7a11ULL, 0x000fe200018f441cULL,
0x0000001027067825ULL, 0x000fe200078e0006ULL, 0x00005f0011117a11ULL, 0x000fe200000f441aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004177faeULL, 0x0003e2000b901c46ULL,
0x00005f0013137a11ULL, 0x000fe200010f4418ULL, 0x0000001027087825ULL, 0x000fe200078e0008ULL,
0x00005f0015157a11ULL, 0x000fe200008f4416ULL, 0x0000000006197faeULL, 0x0003e4000b901c46ULL,
0x00000010270c7825ULL, 0x040fe400078e000cULL, 0x00000000081b7faeULL, 0x0003e4000b901c46ULL,
0x00000010270e7825ULL, 0x000fc400078e000eULL, 0x000000000c1d7faeULL, 0x0003e4000b901c46ULL,
0x0000001027107825ULL, 0x040fe400078e0010ULL, 0x000000000e1f7faeULL, 0x0003e4000b901c46ULL,
0x0000001027127825ULL, 0x040fe400078e0012ULL, 0x0000000010217faeULL, 0x0003e4000b901c46ULL,
0x0000001027147825ULL, 0x000fc400078e0014ULL, 0x0000000012237faeULL, 0x0003e8000b901c46ULL,
0x0000000014257faeULL, 0x0003e4000b901c46ULL, 0x000000535c00720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff797424ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x006fe2000001ff00ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x000073a000000947ULL, 0x000fea0003800000ULL,
0x0000000255057824ULL, 0x000fe400078e00ffULL, 0x00006400ff067624ULL, 0x000fc400078e00ffULL,
0xff317217ff797424ULL, 0x000fe400078e00ffULL, 0x000000ffff7d7224ULL, 0x000fe400078e00ffULL,
0x0000640005057624ULL, 0x000fe400078e0206ULL, 0x000000ffff137224ULL, 0x000fc400078e00ffULL,
0x000001005c0d7824ULL, 0x020fca00078e00ffULL, 0x000000580d00720cULL, 0x000fda0003f06070ULL,
0x000072d000000947ULL, 0x010fea0003800000ULL, 0x000000105a067824ULL, 0x000fe200078e00ffULL,
0x000000015c0c7810ULL, 0x000fe20007ffe0ffULL, 0x000058000a0a7a24ULL, 0x000fe200078e02ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x000000530c00720cULL, 0x000fe20003f06070ULL,
0x000000ffff7a7224ULL, 0x000fe200078e0050ULL, 0xffffffe0060d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff067224ULL, 0x000fe400078e007dULL, 0x000000800a0a7824ULL, 0x000fe400078e00ffULL,
0x000001005c0d7824ULL, 0x000fca00078e020dULL, 0x000000400d0f7810ULL, 0x000fc80007ffe0ffULL,
0x0000006003157812ULL, 0x000fe200078ef80fULL, 0x0000078000008947ULL, 0x000fea0003800000ULL,
0x000020005a0d7824ULL, 0x000fe200078e00ffULL, 0x0000000f580c7217ULL, 0x000fe20007800000ULL,
0x0000000852147824ULL, 0x000fe200078e00ffULL, 0x00000003ff1d7819ULL, 0x000fe40000011600ULL,
0x000020000d0e7812ULL, 0x000fe200078ec0ffULL, 0x000010007d0d7824ULL, 0x000fe200078e00ffULL,
0x000000041d177810ULL, 0x040fe20007ffe0ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a0fULL,
0x000000081d197810ULL, 0x000fe20007ffe0ffULL, 0x00004000510e7824ULL, 0x000fe200078e020eULL,
0x000010000d0f7812ULL, 0x000fe200078e0cffULL, 0x000000011d0d7824ULL, 0x000fe200078e0215ULL,
0x0000000700217812ULL, 0x000fe200078ec0ffULL, 0x0000000119257824ULL, 0x100fe200078e0200ULL,
0x0000b0000e207810ULL, 0x000fe20007ffe00fULL, 0x0000000117237824ULL, 0x040fe200078e0200ULL,
0x0000000d0a0e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001170d7824ULL, 0x000fe200078e0215ULL,
0x0000000c1d2b7810ULL, 0x000fc40007ffe0ffULL, 0x000000200c227817ULL, 0x000fe20003800000ULL,
0x000000ffff0f7224ULL, 0x000fe200000e06ffULL, 0x00005e000e1e7a11ULL, 0x040fe200078040ffULL,
0x00000008190c7824ULL, 0x000fe200078e00ffULL, 0x000000101d497810ULL, 0x000fe20007ffe0ffULL,
0x000000012b267824ULL, 0x040fe200078e0200ULL, 0x00005f000e1f7a11ULL, 0x000fe200000f440fULL,
0x000000012b0f7824ULL, 0x100fe200078e0215ULL, 0x0000000d0a0e7210ULL, 0x000fe20007f1e0ffULL,
0x00000001190d7824ULL, 0x000fe200078e0215ULL, 0x0000000814217812ULL, 0x000fe200078ee221ULL,
0x0000000817147824ULL, 0x040fe200078e00ffULL, 0x000000221700720cULL, 0x080fe20003f46070ULL,
0x0000000149177824ULL, 0x000fe200078e0215ULL, 0x000000221900720cULL, 0x000fe20003f26070ULL,
0x000000ffff1b7224ULL, 0x000fe200000e06ffULL, 0xfffffff80c257812ULL, 0x000fe200078ee225ULL,
0x00000010211e7825ULL, 0x000fe200078e001eULL, 0x0000000d0a197210ULL, 0x000fc40007f7e0ffULL,
0x00005e000e0c7a11ULL, 0x000fe200078040ffULL, 0x000000082b517824ULL, 0x000fe200078e00ffULL,
0x0000000f0a0f7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200018e06ffULL,
0x000000170a177210ULL, 0x000fe20007fbe0ffULL, 0x0000001025257824ULL, 0x000fe200078e0220ULL,
0x00005f000e0d7a11ULL, 0x000fe200000f441bULL, 0x000000ffff167224ULL, 0x000fe200020e06ffULL,
0xfffffff814237812ULL, 0x000fe200078ee223ULL, 0x000000ffff147224ULL, 0x000fe200028e06ffULL,
0x00005e00191a7a11ULL, 0x000fe200078040ffULL, 0x00000010210c7825ULL, 0x000fe200078e000cULL,
0x00005e000f187a11ULL, 0x000fc400078640ffULL, 0x00005e00170e7a11ULL, 0x000fe200078840ffULL,
0x0000001023237824ULL, 0x000fe200078e0220ULL, 0x000000141d4b7810ULL, 0x000fe40007ffe0ffULL,
0x00005f00191b7a11ULL, 0x000fe400000f441cULL, 0x00005f000f197a11ULL, 0x000fe200018f4416ULL,
0x000000011d167824ULL, 0x000fe200078e0200ULL, 0x00005f00170f7a11ULL, 0x000fe200020f4414ULL,
0x000000014b177824ULL, 0x000fe200078e0215ULL, 0x000000181d4d7810ULL, 0x000fe20007ffe0ffULL,
0x00000010211a7825ULL, 0x000fe200078e001aULL, 0x0000001c1d4f7810ULL, 0x000fc40007ffe0ffULL,
0x000000170a147210ULL, 0x000fe20007f1e0ffULL, 0x000000014d177824ULL, 0x100fe200078e0215ULL,
0x0000000716297812ULL, 0x000fe200078ec0ffULL, 0x000000014f157824ULL, 0x000fe200078e0215ULL,
0x000000221d00720cULL, 0x000fe20003f66070ULL, 0x000000ffff277224ULL, 0x000fe200000e06ffULL,
0x00005e0014167a11ULL, 0x000fe200078040ffULL, 0x0000001021187825ULL, 0x000fe200078e0018ULL,
0x000000150a157210ULL, 0x040fe40007fbe0ffULL, 0x0ffffff829297812ULL, 0x000fe200078ef800ULL,
0x00000010210e7825ULL, 0x000fe200078e000eULL, 0x000000170a1d7210ULL, 0x000fc40007f9e0ffULL,
0x00005f0014177a11ULL, 0x000fe200000f4427ULL, 0x0000001029277824ULL, 0x000fe200078e0220ULL,
0x000000222b00720cULL, 0x080fe20003f06070ULL, 0x000000ffff0a7224ULL, 0x000fe200028e06ffULL,
0x00005e0015147a11ULL, 0x000fe200078a40ffULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x00005e001d1c7a11ULL, 0x000fe200078840ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e277faeULL, 0x0003e2000d901c46ULL, 0x00005f0015157a11ULL, 0x000fe200028f440aULL,
0x00000001490a7824ULL, 0x000fe200078e0200ULL, 0x00005f001d1d7a11ULL, 0x000fe200020f4424ULL,
0x000000084b2b7824ULL, 0x000fe200078e00ffULL, 0x000000224900720cULL, 0x0c0fe20003f66070ULL,
0x0000000849497824ULL, 0x000fe200078e00ffULL, 0x000000224b00720cULL, 0x080fe20003f86070ULL,
0x000000014d247824ULL, 0x140fe200078e0200ULL, 0x000000224d00720cULL, 0x0c0fe20003fa6070ULL,
0x000000084d4d7824ULL, 0x000fe200078e00ffULL, 0x000000224f00720cULL, 0x000fe20003fc6070ULL,
0x000000014b227824ULL, 0x000fe200078e0200ULL, 0xfffffff851297812ULL, 0x000fe200078ee226ULL,
0x000000014f1e7824ULL, 0x002fe200078e0200ULL, 0xfffffff849277812ULL, 0x000fe200078ee20aULL,
0x000000084f4b7824ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee222ULL,
0x00000010291f7824ULL, 0x000fe200078e0220ULL, 0xfffffff84d497812ULL, 0x000fe200078ee224ULL,
0x0000001027277824ULL, 0x000fe200078e0220ULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee21eULL,
0x000000102b297824ULL, 0x000fe200078e0220ULL, 0x000000000c237faeULL, 0x0003e2000d101c46ULL,
0x0000001021167825ULL, 0x000fc600078e0016ULL, 0x000000001a257faeULL, 0x0003e2000c901c46ULL,
0x00000010492b7824ULL, 0x000fe400078e0220ULL, 0x00000010211c7825ULL, 0x000fe200078e001cULL,
0x00000000181f7faeULL, 0x0003e6000c101c46ULL, 0x000000104b497824ULL, 0x000fe200078e0220ULL,
0x000000000e277faeULL, 0x0003e2000d901c46ULL, 0x0000001021147825ULL, 0x000fc600078e0014ULL,
0x0000000016297faeULL, 0x0003e8000e101c46ULL, 0x000000001c2b7faeULL, 0x0003e8000e901c46ULL,
0x0000000014497faeULL, 0x0003e2000f101c46ULL, 0x000006b000007947ULL, 0x000fea0003800000ULL,
0x0000000800197811ULL, 0x000fe200078fe8ffULL, 0x00000008520e7824ULL, 0x000fe200078e00ffULL,
0x0000000c001b7811ULL, 0x000fe200078fe8ffULL, 0x000020005a0c7824ULL, 0x000fe200078e00ffULL,
0x0000000700217812ULL, 0x040fe200078ec0ffULL, 0x0000000119207824ULL, 0x140fe200078e0200ULL,
0x0000000400177811ULL, 0x000fe200078fe8ffULL, 0x00000008190f7824ULL, 0x000fe200078e00ffULL,
0x000000080e217812ULL, 0x000fe200078ee221ULL, 0x000000011b227824ULL, 0x040fe200078e0200ULL,
0x000020000c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000081b1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f207812ULL, 0x000fe200078ee220ULL, 0x00000001170d7824ULL, 0x040fe200078e0200ULL,
0x00000015000f7211ULL, 0x040fe200078fe8ffULL, 0x00000008170e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81d227812ULL, 0x000fe200078ee222ULL, 0x0000000117177824ULL, 0x100fe200078e0215ULL,
0x00000010001d7811ULL, 0x040fe200078fe8ffULL, 0x0000400051517824ULL, 0x000fe200078e020cULL,
0x00000014001f7811ULL, 0x040fe200078fe8ffULL, 0x0000000119197824ULL, 0x000fe200078e0215ULL,
0x0000001800257811ULL, 0x000fe200078fe8ffULL, 0x000000011d147824ULL, 0x140fe200078e0200ULL,
0x0000000f0a0f7210ULL, 0x000fe20007f1e0ffULL, 0x000000081d497824ULL, 0x000fe200078e00ffULL,
0xfffffff80e0d7812ULL, 0x000fe200078ee20dULL, 0x000000011f237824ULL, 0x140fe200078e0200ULL,
0x0000001c001c7811ULL, 0x000fe200078fe8ffULL, 0x000000081f187824ULL, 0x000fe200078e00ffULL,
0x000000170a177210ULL, 0x000fe20007f7e0ffULL, 0x0000000125167824ULL, 0x000fe200078e0200ULL,
0xfffffff849497812ULL, 0x000fe200078ee214ULL, 0x00000008254b7824ULL, 0x000fe200078e00ffULL,
0xfffffff818237812ULL, 0x000fe200078ee223ULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078040ffULL, 0x000000011b1b7824ULL, 0x100fe200078e0215ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee216ULL, 0x000000011d1d7824ULL, 0x100fe200078e0215ULL,
0x00005f000f0f7a11ULL, 0x000fe200000f440cULL, 0x000000011f1f7824ULL, 0x100fe200078e0215ULL,
0x000000190a147210ULL, 0x040fe20007f3e0ffULL, 0x0000000125257824ULL, 0x100fe200078e0215ULL,
0x0000001b0a0c7210ULL, 0x000fe20007f1e0ffULL, 0x000000011c157824ULL, 0x000fe200078e0215ULL,
0x00005e0017167a11ULL, 0x000fe200078c40ffULL, 0x000000ffff187224ULL, 0x000fe200018e06ffULL,
0x0000001d0a1b7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e06ffULL,
0x0000001f0a197210ULL, 0x000fe20007f9e0ffULL, 0x000000081c4d7824ULL, 0x000fe200078e00ffULL,
0x000000250a257210ULL, 0x040fe20007fbe0ffULL, 0x000010007d1a7824ULL, 0x000fe200078e00ffULL,
0x000000150a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x00005f0017177a11ULL, 0x000fe200030f4418ULL, 0x000000011c187824ULL, 0x000fe200078e0200ULL,
0x00005e00141e7a11ULL, 0x000fe200078240ffULL, 0x000000ffff267224ULL, 0x000fe200010e06ffULL,
0x00005e000c1c7a11ULL, 0x000fe200078040ffULL, 0x000000ffff247224ULL, 0x000fe200020e06ffULL,
0x00005f00141f7a11ULL, 0x000fe200008f441dULL, 0x000000ffff4f7224ULL, 0x000fe200018e06ffULL,
0x00005f000c1d7a11ULL, 0x000fe200000f4415ULL, 0x000000ffff0c7224ULL, 0x000fe200028e06ffULL,
0x0000000000157211ULL, 0x000fe200078fe8ffULL, 0x00000010210e7825ULL, 0x000fe200078e000eULL,
0x000010001a1a7812ULL, 0x000fc400078e0cffULL, 0x00005e0025147a11ULL, 0x000fe200078440ffULL,
0x0000001021167825ULL, 0x000fe200078e0016ULL, 0x0000000715277812ULL, 0x000fe400078ec0ffULL,
0x0000b00051287810ULL, 0x000fe20007ffe01aULL, 0x00000010211e7825ULL, 0x000fe200078e001eULL,
0x00005e001b1a7a11ULL, 0x000fe400078040ffULL, 0x00005f0025157a11ULL, 0x000fe200010f440cULL,
0x0000001020297824ULL, 0x000fe200078e0228ULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee218ULL,
0x00000010222b7824ULL, 0x000fe200078e0228ULL, 0x0ffffff827257812ULL, 0x000fe200078ef800ULL,
0x000000100d277824ULL, 0x000fe200078e0228ULL, 0x00005e0019187a11ULL, 0x000fe200078240ffULL,
0x00000010211c7825ULL, 0x000fe200078e001cULL, 0x00005f001b1b7a11ULL, 0x000fc400000f4426ULL,
0x00005e000a0c7a11ULL, 0x040fe200078040ffULL, 0x0000001025257824ULL, 0x000fe200078e0228ULL,
0x00005f0019197a11ULL, 0x000fe200008f4424ULL, 0x0000001049497824ULL, 0x000fe200078e0228ULL,
0x00005f000a0d7a11ULL, 0x000fe200000f444fULL, 0x00000010211a7825ULL, 0x000fe200078e001aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e257faeULL, 0x0003e6000b901c46ULL,
0x0000001023237824ULL, 0x000fe200078e0228ULL, 0x0000000016277faeULL, 0x0003e2000b901c46ULL,
0x0000001021187825ULL, 0x000fc600078e0018ULL, 0x000000001e297faeULL, 0x0003e2000b901c46ULL,
0x000000104b4b7824ULL, 0x000fe400078e0228ULL, 0x0000001021147825ULL, 0x000fe200078e0014ULL,
0x000000001c2b7faeULL, 0x0003e6000b901c46ULL, 0x000000104d4d7824ULL, 0x000fe200078e0228ULL,
0x000000001a497faeULL, 0x0003e2000b901c46ULL, 0x00000010210c7825ULL, 0x000fc600078e000cULL,
0x0000000018237faeULL, 0x0003e8000b901c46ULL, 0x00000000144b7faeULL, 0x0003e8000b901c46ULL,
0x000000000c4d7faeULL, 0x0003e4000b901c46ULL, 0x00000300ff777624ULL, 0x000fe200078e00ffULL,
0x00000001500a7812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000010a00780cULL, 0x000fe20003f05070ULL, 0xffffffffff0a7424ULL, 0x000fe200078e00ffULL,
0xffffffff77777811ULL, 0x000fc800078e08ffULL, 0x0000000177777807ULL, 0x000fca0004000000ULL,
0x0000000150507824ULL, 0x000fca00078e0277ULL, 0x000000595000720cULL, 0x000fda0003f06070ULL,
0x00000077050c8210ULL, 0x002fe20007ffe07aULL, 0x00000004ff0d8424ULL, 0x000fc800078e00ffULL,
0x000060000c0c8625ULL, 0x000fca00078e000dULL, 0x000000060c0a8981ULL, 0x000322000c1e1900ULL,
0xffffffe00b787812ULL, 0x040fe400078ec0ffULL, 0x000000100b0f7812ULL, 0x040fe400078ec0ffULL,
0x000000080b0e7812ULL, 0x000fc800078ec0ffULL, 0x000000780e787210ULL, 0x000fe20007ffe00fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136080078147f8cULL, 0x0022a4000c80043fULL,
0x00000000000c7805ULL, 0x000fc40000015200ULL, 0x01360c00780f7984ULL, 0x000ee40000000800ULL,
0x800000000fff7812ULL, 0x00cfe40007804815ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000e7805ULL, 0x000fcc0000015200ULL,
0x0000000e0c177210ULL, 0x000fca0007f1e1ffULL, 0x000000010f0f7824ULL, 0x000fe200000e0e0dULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001140fULL, 0x000000170e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff0f7224ULL, 0x000fca00000e060fULL, 0x000000020e0e7819ULL, 0x000fc8000000120fULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01360c00780f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x004fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000657824ULL, 0x000fe200078e00ffULL,
0x00000001ff637819ULL, 0x000fe20000011600ULL, 0x000000205a647824ULL, 0x000fe400078e00ffULL,
0xffffffffff5f7424ULL, 0x000fe200078e00ffULL, 0x0000007065657812ULL, 0x000fc400078ec0ffULL,
0xffffff8064647812ULL, 0x000fe400078ec0ffULL, 0x0000000c63637812ULL, 0x000fc800078ec0ffULL,
0x00000064630c7210ULL, 0x000fca0007ffe065ULL, 0x013000000c0e7984ULL, 0x000ea80000000800ULL,
0x013200000c0f7984ULL, 0x0006620000000800ULL, 0x000000790e00720bULL, 0x004fe20003f1d000ULL,
0x000103827f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0c197812ULL, 0x000fe2000782c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff667224ULL, 0x000fe400078e0079ULL,
0x0000001fff617424ULL, 0x000fc400078e00ffULL, 0xffffffffff5e7424ULL, 0x000fcc00078e00ffULL,
0x0000044000009947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe4000001165aULL,
0x000000790e00720bULL, 0x000fe40003f54000ULL, 0x0000005a0d00720cULL, 0x000fe20003f25270ULL,
0x000103127f007947ULL, 0x000fd4000b800000ULL, 0x0000000000147806ULL, 0x000fc400010e0100ULL,
0x000000805a0c9824ULL, 0x000fe200078e0265ULL, 0x0000000e79667209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe40003800000ULL, 0x00000001630d9824ULL, 0x000fe200078e020cULL,
0x00009910140c7816ULL, 0x000fc800000000ffULL, 0x013400660d009388ULL, 0x0005e20000000800ULL,
0x000000ff0c00720cULL, 0x000fda0003f25270ULL, 0x0000030000009947ULL, 0x000fea0003800000ULL,
0x80000066790c7221ULL, 0x004fe20000010000ULL, 0x000000ff14ff7812ULL, 0x000fe2000782c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00157308ULL, 0x0004ec0000000800ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x004fe20000011600ULL, 0x000102527f007947ULL, 0x000fea000b800000ULL,
0x00001f0c150c7589ULL, 0x0084e400000e0000ULL, 0x0000000c44447220ULL, 0x088fe20000410000ULL,
0x0000000c45457220ULL, 0x080fe20000410000ULL, 0x0000000c40407220ULL, 0x080fe20000410000ULL,
0x0000000c41417220ULL, 0x080fe20000410000ULL, 0x0000000c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000000c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000c38387220ULL, 0x080fe20000410000ULL,
0x0000000c39397220ULL, 0x080fe20000410000ULL, 0x0000000c34347220ULL, 0x080fe20000410000ULL,
0x0000000c35357220ULL, 0x080fe20000410000ULL, 0x0000000c30307220ULL, 0x080fe20000410000ULL,
0x0000000c31317220ULL, 0x080fe20000410000ULL, 0x0000000c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c10107220ULL, 0x080fe20000410000ULL,
0x0000000c11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0014ff7812ULL, 0x000fe2000782c0ffULL, 0x0000001504047220ULL, 0x008fd80000410000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000008000c7811ULL, 0x004fe200078ff0ffULL,
0x000101327f007947ULL, 0x000fea000b800000ULL, 0x00001f0c150c7589ULL, 0x0004e400000e0000ULL,
0x0000000c46467220ULL, 0x088fe20000410000ULL, 0x0000000c47477220ULL, 0x080fe20000410000ULL,
0x0000000c42427220ULL, 0x080fe20000410000ULL, 0x0000000c43437220ULL, 0x080fe20000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000c36367220ULL, 0x080fe20000410000ULL, 0x0000000c37377220ULL, 0x080fe20000410000ULL,
0x0000000c32327220ULL, 0x080fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c12127220ULL, 0x080fe20000410000ULL, 0x0000000c13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff19ff7812ULL, 0x000fda0007826014ULL,
0x800000660e0e1221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b0e0e1820ULL, 0x000fc80000410000ULL, 0x0000000e00071308ULL, 0x000ea40000000800ULL,
0x000000070f0f1220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x000000040f047221ULL, 0x002fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000000ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011600ULL,
0x00005410080f7816ULL, 0x000fe20000000008ULL, 0x0000ff727f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0f097589ULL, 0x0002a400000e0000ULL, 0x000000080e087810ULL, 0x000fe20007ffe0ffULL,
0x0000ffa27f007947ULL, 0x000fea000b800000ULL, 0x00001f080f087589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100e0c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x000fe200078e000fULL, 0x00002fb000177802ULL, 0x000fc40000000f00ULL,
0x000109f000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180e0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff167224ULL, 0x004fe200078e000fULL,
0x0000300000177802ULL, 0x000fc40000000f00ULL, 0x000109a000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000007005d7812ULL, 0x000fe200078ec0ffULL,
0x000000025a607824ULL, 0x040fe200078e00ffULL, 0x00000004ff147819ULL, 0x100fe20000011600ULL,
0x000002005a0e7824ULL, 0x002fe200078e00ffULL, 0x000000085d0c7812ULL, 0x000fe200078ef800ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004600d7812ULL, 0x000fc400078ec0ffULL,
0xfffff8000e5b7812ULL, 0x000fe200078ec0ffULL, 0x000000080c627824ULL, 0x040fe200078e00ffULL,
0x0000000d0c0d7210ULL, 0x000fc80007ffe014ULL, 0xfffffff862627812ULL, 0x000fe400078ee20dULL,
0x00000008000d7812ULL, 0x000fc600078ec0ffULL, 0x0000001062627824ULL, 0x000fc800078e025bULL,
0x000000070d0d7812ULL, 0x000fe200078ef800ULL, 0x009000006228783bULL, 0x000e620000000200ULL,
0x00000001ff517819ULL, 0x000fe2000001165aULL, 0x00002000526e7824ULL, 0x000fe200078e00ffULL,
0xfffffff860607812ULL, 0x000fe200078ec0ffULL, 0x00000001140e7824ULL, 0x000fe400078e020dULL,
0x00000004510f7824ULL, 0x048fe400078e0214ULL, 0x0000000251147824ULL, 0x000fe200078e0252ULL,
0x000000020e757810ULL, 0x040fe20007ffe0ffULL, 0x000000080d157824ULL, 0x040fe200078e00ffULL,
0x000000040e747810ULL, 0x040fe20007ffe0ffULL, 0x000000080d167824ULL, 0x044fe200078e00ffULL,
0x000000060e727810ULL, 0x000fe20007ffe0ffULL, 0x000000080d177824ULL, 0x000fe200078e00ffULL,
0xfffffff815767812ULL, 0x000fe200078ee20eULL, 0x0000000214147824ULL, 0x000fe200078e027dULL,
0x000000020f0e7810ULL, 0x000fe20007ffe00cULL, 0x000000080d197824ULL, 0x000fe200078e00ffULL,
0xfffffff816757812ULL, 0x000fe200078ee275ULL, 0x000000080c157824ULL, 0x000fe200078e00ffULL,
0x0000b000140f7811ULL, 0x000fe200078e60ffULL, 0x0000400051167824ULL, 0x000fe200078e026eULL,
0xfffffff817747812ULL, 0x000fc400078ee274ULL, 0xfffffff819727812ULL, 0x000fe200078ee272ULL,
0x0000001076547824ULL, 0x100fe200078e020fULL, 0xfffffff815147812ULL, 0x000fe200078ee20eULL,
0x00000010754c7824ULL, 0x100fe200078e020fULL, 0x000000100d157812ULL, 0x000fe200078efcffULL,
0x0000001074487824ULL, 0x100fe400078e020fULL, 0x00000010720f7824ULL, 0x000fe200078e020fULL,
0x000000005454783bULL, 0x000ea20000004200ULL, 0x00000015006d7211ULL, 0x000fe200078fe0ffULL,
0x0000000815177824ULL, 0x000fc400078e00ffULL, 0x000000004c4c783bULL, 0x000ee20000004200ULL,
0x000010007d187824ULL, 0x000fe200078e0216ULL, 0x000000026d6c7810ULL, 0x000fe20007ffe0ffULL,
0x00000008151c7824ULL, 0x040fe200078e00ffULL, 0x000000004848783bULL, 0x000fe20000004200ULL,
0x00000008151a7824ULL, 0x000fe200078e00ffULL, 0x000000046d6b7810ULL, 0x000fe20007ffe0ffULL,
0x00000008151e7824ULL, 0x000fe200078e00ffULL, 0x000000000f0c783bULL, 0x000fe20000004200ULL,
0x000000066d697810ULL, 0x000fe20007ffe0ffULL, 0x00000010145b7824ULL, 0x000fe200078e025bULL,
0xfffffff8176c7812ULL, 0x000fe200078ee26cULL, 0x0000000928280232ULL, 0x082fe20000000000ULL,
0x0000b00018187810ULL, 0x000fe20007ffe0ffULL, 0x000000092a2a0232ULL, 0x080fe20000000000ULL,
0xfffffff81c6b7812ULL, 0x000fe200078ee26bULL, 0x009000005b14783bULL, 0x000e620000000200ULL,
0xfffffff81a6d7812ULL, 0x000fe200078ee26dULL, 0x000000106c247824ULL, 0x100fe200078e0218ULL,
0xfffffff81e697812ULL, 0x000fe200078ee269ULL, 0x000000106b207824ULL, 0x100fe200078e0218ULL,
0x0000000829290232ULL, 0x080fe20000000000ULL, 0x000000106d1c7824ULL, 0x100fe200078e0218ULL,
0x000000082b2b0232ULL, 0x000fe20000000000ULL, 0x0000001069187824ULL, 0x000fe200078e0218ULL,
0x000000002424783bULL, 0x000e680000004200ULL, 0x000000002020783bULL, 0x000e680000004200ULL,
0x000000001c1c783bULL, 0x000e620000004200ULL, 0x000000542844723cULL, 0x044fe60000001844ULL,
0x000000001818783bULL, 0x000eaa0000004200ULL, 0x000000562840723cULL, 0x040ff00000001840ULL,
0x0000004c283c723cULL, 0x008f62000000183cULL, 0x0000000914140232ULL, 0x002fc40000000000ULL,
0x0000000916160232ULL, 0x000fca0000000000ULL, 0x0000004e2838723cULL, 0x000f620000001838ULL,
0x0000000815150232ULL, 0x080fe40000000000ULL, 0x0000000817170232ULL, 0x000fca0000000000ULL,
0x000000482834723cULL, 0x040f700000001834ULL, 0x0000004a2830723cULL, 0x040f700000001830ULL,
0x0000000c282c723cULL, 0x040f70000000182cULL, 0x0000000e2810723cULL, 0x000f700000001810ULL,
0x00000024143c723cULL, 0x060b70000000183cULL, 0x000000261438723cULL, 0x040b700000001838ULL,
0x000000201434723cULL, 0x040b700000001834ULL, 0x000000221430723cULL, 0x040b700000001830ULL,
0x0000001c1444723cULL, 0x040b700000001844ULL, 0x0000001e1440723cULL, 0x040b700000001840ULL,
0x00000018142c723cULL, 0x044b70000000182cULL, 0x0000001a1410723cULL, 0x000b620000001810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000405c0d7811ULL, 0x000fe200078e40ffULL,
0x0136880060ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff797224ULL, 0x000fe200078e0066ULL,
0x000000017d7d7812ULL, 0x000fc400078e0cffULL, 0x000000580d00720cULL, 0x000fda0003f06070ULL,
0x0000529000000947ULL, 0x000fea0003800000ULL, 0x000000105a0c7824ULL, 0x002fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe00c0d7812ULL, 0x000fe200078ec0ffULL,
0x000058000a7b7a24ULL, 0x010fe200078e02ffULL, 0x000000015c0c7810ULL, 0x000fc60007ffe0ffULL,
0x000001005c0d7824ULL, 0x000fe200078e020dULL, 0x000000530c00720cULL, 0x000fe20003f06070ULL,
0x000000807b7b7824ULL, 0x000fc600078e00ffULL, 0x000000800d0e7810ULL, 0x000fc80007ffe0ffULL,
0x0000006003157812ULL, 0x020fca00078ef80eULL, 0x0000077000008947ULL, 0x000fea0003800000ULL,
0x000020005a0c7824ULL, 0x000fe200078e00ffULL, 0x00000003ff217819ULL, 0x000fe40000011600ULL,
0x0000000e580d7217ULL, 0x000fe40007800000ULL, 0x000020000c147812ULL, 0x000fe200078ec0ffULL,
0x00001000060c7824ULL, 0x000fe200078e00ffULL, 0x00000004210f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010d0d7824ULL, 0x000fe200078e0a0eULL, 0x0000000821197810ULL, 0x000fe20007ffe0ffULL,
0x0000400051517824ULL, 0x000fe200078e0214ULL, 0x000010000c207812ULL, 0x000fe200078ec0ffULL,
0x00000001210c7824ULL, 0x100fe200078e0215ULL, 0x000000200d227817ULL, 0x000fe20003800000ULL,
0x000000010f257824ULL, 0x100fe200078e0200ULL, 0x0000001021297810ULL, 0x000fe20007ffe0ffULL,
0x000000080f147824ULL, 0x000fe200078e00ffULL, 0x0000000c7b0e7210ULL, 0x000fe20007f3e0ffULL,
0x000000010f0c7824ULL, 0x000fe200078e0215ULL, 0x0000001421277810ULL, 0x000fe20007ffe0ffULL,
0x0000000119237824ULL, 0x000fe200078e0200ULL, 0x000000220f00720cULL, 0x000fe20003f06070ULL,
0x0000000819167824ULL, 0x000fe200078e00ffULL, 0x0000000c7b0c7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200008e06ffULL, 0xfffffff814257812ULL, 0x000fe200078ee225ULL,
0x0000000129147824ULL, 0x000fe200078e0215ULL, 0xfffffff816237812ULL, 0x000fe200078ee223ULL,
0x000000ffff0d7224ULL, 0x000fe200010e06ffULL, 0x00005e000e1e7a11ULL, 0x000fe200078240ffULL,
0x0000000127167824ULL, 0x000fe200078e0215ULL, 0x00005e000c1c7a11ULL, 0x000fc400078440ffULL,
0x0000000c21177810ULL, 0x000fe40007ffe0ffULL, 0x00005f000e1f7a11ULL, 0x000fe400008f440fULL,
0x00005f000c1d7a11ULL, 0x000fe200010f440dULL, 0x00000001190c7824ULL, 0x100fe200078e0215ULL,
0x000000147b147210ULL, 0x000fe20007f5e0ffULL, 0x00000001170e7824ULL, 0x000fe200078e0215ULL,
0x000000167b167210ULL, 0x000fe20007f7e0ffULL, 0x0000000117287824ULL, 0x100fe200078e0200ULL,
0x000000221900720cULL, 0x000fe20003f26070ULL, 0x000000ffff0d7224ULL, 0x000fe200010e06ffULL,
0x0000000c7b1b7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200018e06ffULL,
0x0000000e7b197210ULL, 0x000fe20007fbe0ffULL, 0x00000008174b7824ULL, 0x000fe200078e00ffULL,
0x00005e00140c7a11ULL, 0x000fe200078440ffULL, 0x000000ffff267224ULL, 0x000fe200020e06ffULL,
0x00005e00160e7a11ULL, 0x000fe200078640ffULL, 0x000000ffff247224ULL, 0x000fe200028e06ffULL,
0x00005f00140d7a11ULL, 0x000fe200010f440dULL, 0x0000000121147824ULL, 0x040fe200078e0200ULL,
0x00005f00160f7a11ULL, 0x000fe200018f440fULL, 0x0000000852167824ULL, 0x000fe200078e00ffULL,
0x00000018214d7810ULL, 0x000fc40007ffe0ffULL, 0x0000001c214f7810ULL, 0x040fe40007ffe0ffULL,
0x000000222100720cULL, 0x000fe40003f66070ULL, 0x0000000816217812ULL, 0x000fe200078ee25dULL,
0x000000014f167824ULL, 0x100fe200078e0215ULL, 0x00000007142b7812ULL, 0x000fe200078ec0ffULL,
0x000000014d147824ULL, 0x000fe200078e0215ULL, 0x00005e0019187a11ULL, 0x000fe200078a40ffULL,
0x00000010211e7825ULL, 0x000fe200078e001eULL, 0x0000b00051207810ULL, 0x000fc40007ffe020ULL,
0x00005f0019197a11ULL, 0x000fe200028f4424ULL, 0x00000010211c7825ULL, 0x000fe200078e001cULL,
0x00005e001b1a7a11ULL, 0x000fe400078840ffULL, 0x0ffffff82b2b7812ULL, 0x000fe200078ef800ULL,
0x0000001025257824ULL, 0x100fe200078e0220ULL, 0x000000147b157210ULL, 0x000fe20007f5e0ffULL,
0x0000001023237824ULL, 0x100fe200078e0220ULL, 0x000000167b247210ULL, 0x000fe20007fbe0ffULL,
0x000000102b2b7824ULL, 0x000fe200078e0220ULL, 0x00005f001b1b7a11ULL, 0x000fe200020f4426ULL,
0x000000ffff267224ULL, 0x000fe200010e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078840ffULL,
0x000000ffff497224ULL, 0x000fe200028e06ffULL, 0x00005e0024167a11ULL, 0x040fe200078a40ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e2b7faeULL, 0x0003e2000d901c46ULL,
0x000000221700720cULL, 0x080fe20003f46070ULL, 0x00000010211a7825ULL, 0x000fe200078e001aULL,
0x00005f0015157a11ULL, 0x000fe200020f4426ULL, 0x000000001c257faeULL, 0x0005e2000c101c46ULL,
0x00005f0024177a11ULL, 0x000fe200028f4449ULL, 0x0000000127247824ULL, 0x100fe200078e0200ULL,
0x000000222900720cULL, 0x080fe20003f66070ULL, 0x0000000827497824ULL, 0x040fe200078e00ffULL,
0x000000222700720cULL, 0x080fe20003f86070ULL, 0x000000014d267824ULL, 0x140fe200078e0200ULL,
0x000000224d00720cULL, 0x0c0fe20003fa6070ULL, 0x000000084d4d7824ULL, 0x000fe200078e00ffULL,
0x000000224f00720cULL, 0x000fe20003fc6070ULL, 0x0000000129227824ULL, 0x000fe200078e0200ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee228ULL, 0x0000000829297824ULL, 0x000fe200078e00ffULL,
0xfffffff84d2b7812ULL, 0x002fe200078ee226ULL, 0x000000014f1e7824ULL, 0x040fe200078e0200ULL,
0x000000001a237faeULL, 0x0005e2000c901c46ULL, 0x000000084f4f7824ULL, 0x000fe200078e00ffULL,
0xfffffff829277812ULL, 0x000fe200078ee222ULL, 0x000000104b1f7824ULL, 0x000fe200078e0220ULL,
0xfffffff849297812ULL, 0x000fe200078ee224ULL, 0x0000001021187825ULL, 0x000fe200078e0018ULL,
0xfffffff84f497812ULL, 0x000fc600078ee21eULL, 0x0000001027277824ULL, 0x000fe200078e0220ULL,
0x00000000181f7faeULL, 0x0005e2000d101c46ULL, 0x00000010210c7825ULL, 0x000fc800078e000cULL,
0x0000001029297824ULL, 0x000fe200078e0220ULL, 0x000000000c277faeULL, 0x0005e2000d901c46ULL,
0x00000010210e7825ULL, 0x000fc800078e000eULL, 0x000000102b2b7824ULL, 0x000fe200078e0220ULL,
0x000000000e297faeULL, 0x0005e2000e101c46ULL, 0x0000001021147825ULL, 0x000fc800078e0014ULL,
0x0000001049497824ULL, 0x000fe200078e0220ULL, 0x00000000142b7faeULL, 0x0005e2000e901c46ULL,
0x0000001021167825ULL, 0x000fca00078e0016ULL, 0x0000000016497faeULL, 0x0005e2000f101c46ULL,
0x000006a000007947ULL, 0x000fea0003800000ULL, 0x00000008000f7811ULL, 0x000fe200078fe8ffULL,
0x000020005a0c7824ULL, 0x000fe200078e00ffULL, 0x00000004000e7811ULL, 0x040fe400078fe8ffULL,
0x0000001000187811ULL, 0x040fe200078fe8ffULL, 0x000000010f267824ULL, 0x140fe200078e0200ULL,
0x0000000c00147811ULL, 0x000fe200078fe8ffULL, 0x000000080f177824ULL, 0x000fe200078e00ffULL,
0x000020000c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000010e287824ULL, 0x000fe200078e0200ULL,
0x0000001800167811ULL, 0x000fe200078fe8ffULL, 0x000000080e0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff817267812ULL, 0x000fe200078ee226ULL, 0x0000000118227824ULL, 0x000fe200078e0200ULL,
0x00000014002a7811ULL, 0x000fe200078fe8ffULL, 0x0000000818177824ULL, 0x000fe200078e00ffULL,
0xfffffff80d287812ULL, 0x000fe200078ee228ULL, 0x0000000114247824ULL, 0x000fe200078e0200ULL,
0x0000000000257211ULL, 0x000fe200078fe8ffULL, 0x00000008140d7824ULL, 0x000fe200078e00ffULL,
0xfffffff817227812ULL, 0x000fe200078ee222ULL, 0x0000400051237824ULL, 0x000fe200078e020cULL,
0x00000015000c7211ULL, 0x000fe200078fe8ffULL, 0x0000000116217824ULL, 0x000fe200078e0200ULL,
0x0000001c00177811ULL, 0x000fe200078fe8ffULL, 0x00000008161a7824ULL, 0x040fe200078e00ffULL,
0xfffffff80d247812ULL, 0x000fe200078ee224ULL, 0x0000000116487824ULL, 0x100fe200078e0215ULL,
0x0000000c7b0d7210ULL, 0x000fe20007f1e0ffULL, 0x000000010e0c7824ULL, 0x000fe200078e0215ULL,
0xfffffff81a217812ULL, 0x000fe200078ee221ULL, 0x000000010f0e7824ULL, 0x100fe200078e0215ULL,
0x0000000725257812ULL, 0x000fe200078ec0ffULL, 0x00000001170f7824ULL, 0x000fe200078e0200ULL,
0x0000000c7b0c7210ULL, 0x000fe20007f3e0ffULL, 0x00000008171c7824ULL, 0x000fe200078e00ffULL,
0x0000000e7b0e7210ULL, 0x000fe20007f5e0ffULL, 0x0000000117167824ULL, 0x000fc400078e0215ULL,
0x000000ffff1a7224ULL, 0x000fe200000e06ffULL, 0xfffffff81c177812ULL, 0x000fe200078ee20fULL,
0x00001000060f7824ULL, 0x000fe200078e00ffULL, 0x00005e000d1e7a11ULL, 0x000fe200078040ffULL,
0x0000000114147824ULL, 0x100fe400078e0215ULL, 0x000000012a207824ULL, 0x040fe200078e0200ULL,
0x000010000f4a7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e06ffULL,
0x00005f000d1f7a11ULL, 0x000fe200000f441aULL, 0x000000082a197824ULL, 0x000fe200078e00ffULL,
0x00005e000c1c7a11ULL, 0x000fe200078040ffULL, 0x0000000118187824ULL, 0x100fe200078e0215ULL,
0x00005e000e1a7a11ULL, 0x000fe200078240ffULL, 0x000000012a2a7824ULL, 0x000fe200078e0215ULL,
0x00005f000c1d7a11ULL, 0x000fe200000f440fULL, 0x000000ffff0d7224ULL, 0x000fe200010e06ffULL,
0x000000147b157210ULL, 0x000fc40007f1e0ffULL, 0x0000b00023237810ULL, 0x000fe40007ffe04aULL,
0x00005f000e1b7a11ULL, 0x000fe200008f440dULL, 0x000000ffff4a7224ULL, 0x000fe200000e06ffULL,
0x000000187b0d7210ULL, 0x000fe20007f3e0ffULL, 0x0000001028277824ULL, 0x100fe200078e0223ULL,
0x00005e0015187a11ULL, 0x000fe200078040ffULL, 0x0000001026297824ULL, 0x100fe200078e0223ULL,
0x0000002a7b2a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff147224ULL, 0x000fe200008e06ffULL,
0xfffffff819207812ULL, 0x000fe200078ee220ULL, 0x00000010242b7824ULL, 0x100fe200078e0223ULL,
0x00005f0015197a11ULL, 0x000fe200000f444aULL, 0x000000ffff0f7224ULL, 0x000fe200010e06ffULL,
0x000000487b487210ULL, 0x000fe20007f1e0ffULL, 0x00000008524a7824ULL, 0x000fe200078e00ffULL,
0x00005e000d0c7a11ULL, 0x040fe200078240ffULL, 0x0000001022497824ULL, 0x100fe200078e0223ULL,
0x00005e002a0e7a11ULL, 0x000fe200078440ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x00005f000d0d7a11ULL, 0x000fe200008f4414ULL, 0x00000010204b7824ULL, 0x100fe200078e0223ULL,
0x00005e0048147a11ULL, 0x000fe200078040ffULL, 0x0000001021217824ULL, 0x000fe200078e0223ULL,
0x00005f002a0f7a11ULL, 0x000fc400010f440fULL, 0x000000167b2a7210ULL, 0x000fe40007f3e0ffULL,
0x00005f0048157a11ULL, 0x000fe400000f4415ULL, 0x000000084a4f7812ULL, 0x000fe200078ee25dULL,
0x000000ffff4d7224ULL, 0x000fe200008e06ffULL, 0x0ffffff825487812ULL, 0x000fe400078ef800ULL,
0x00005e002a167a11ULL, 0x000fe200078040ffULL, 0x000000104f1e7825ULL, 0x000fc800078e001eULL,
0x0000001048257824ULL, 0x100fe400078e0223ULL, 0x0000001017237824ULL, 0x000fe200078e0223ULL,
0x00005f002a177a11ULL, 0x000fe200000f444dULL, 0x000000104f1c7825ULL, 0x040fe200078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e257faeULL, 0x0003e6000b901c46ULL,
0x000000104f1a7825ULL, 0x040fe200078e001aULL, 0x000000001c277faeULL, 0x0003e6000b901c46ULL,
0x000000104f187825ULL, 0x040fe200078e0018ULL, 0x000000001a297faeULL, 0x0003e6000b901c46ULL,
0x000000104f0c7825ULL, 0x040fe200078e000cULL, 0x00000000182b7faeULL, 0x0003e6000b901c46ULL,
0x000000104f0e7825ULL, 0x040fe200078e000eULL, 0x000000000c497faeULL, 0x0003e6000b901c46ULL,
0x000000104f147825ULL, 0x040fe200078e0014ULL, 0x000000000e4b7faeULL, 0x0003e6000b901c46ULL,
0x000000104f167825ULL, 0x000fe200078e0016ULL, 0x0000000014217faeULL, 0x0003e8000b901c46ULL,
0x0000000016237faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01362800780c7f8cULL, 0x0062a4000c80043fULL,
0x00000000000e7805ULL, 0x000fc40000015200ULL, 0x01362c0078157984ULL, 0x000ee40000000800ULL,
0x8000000015ff7812ULL, 0x00cfc4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x000000140e177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e0fULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001714147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01362c0078157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x004fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000080650c7810ULL, 0x000fca0007ffe064ULL,
0x00000001630c7824ULL, 0x000fca00078e020cULL, 0x013000000c0f7984ULL, 0x000ea80000000800ULL,
0x013200000c0e7984ULL, 0x0006620000000800ULL, 0x000000660f00720bULL, 0x004fe20003f1d000ULL,
0x0000e6e27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0c197812ULL, 0x000fe2000782c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff797224ULL, 0x000fd400078e0066ULL,
0x0000044000009947ULL, 0x000fea0003800000ULL, 0x000000015a0d7811ULL, 0x000fe400078ff0ffULL,
0x000000660f00720bULL, 0x000fe40003f54000ULL, 0x0000005a0d00720cULL, 0x000fe20003f25270ULL,
0x0000e6927f007947ULL, 0x000fd4000b800000ULL, 0x0000000000147806ULL, 0x000fc400010e0100ULL,
0x000000805a0c9824ULL, 0x000fe200078e0265ULL, 0x000000660f797209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe40003800000ULL, 0x0000000163169824ULL, 0x000fe200078e020cULL,
0x00009910140c7816ULL, 0x000fc800000000ffULL, 0x0134007916009388ULL, 0x0005e20000000800ULL,
0x000000ff0c00720cULL, 0x000fda0003f25270ULL, 0x0000030000009947ULL, 0x000fea0003800000ULL,
0x00000066790c7221ULL, 0x004fe20000010100ULL, 0x000000ff14ff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00157308ULL, 0x000ea40000000800ULL, 0x0000001504047220ULL, 0x004fc80000410000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011600ULL,
0x0000e5c27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c150c7589ULL, 0x0004e400000e0000ULL,
0x0000000c44447220ULL, 0x088fe20000410000ULL, 0x0000000c45457220ULL, 0x080fe20000410000ULL,
0x0000000c40407220ULL, 0x080fe20000410000ULL, 0x0000000c41417220ULL, 0x080fe20000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000c38387220ULL, 0x080fe20000410000ULL, 0x0000000c39397220ULL, 0x080fe20000410000ULL,
0x0000000c34347220ULL, 0x080fe20000410000ULL, 0x0000000c35357220ULL, 0x080fe20000410000ULL,
0x0000000c30307220ULL, 0x080fe20000410000ULL, 0x0000000c31317220ULL, 0x080fe20000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000c10107220ULL, 0x080fe20000410000ULL, 0x0000000c11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0014ff7812ULL, 0x000fda000782c0ffULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000008000c7811ULL, 0x000fe200078ff0ffULL,
0x0000e4b27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c150c7589ULL, 0x0006a400000e0000ULL,
0x0000000c46467220ULL, 0x084fe20000410000ULL, 0x0000000c47477220ULL, 0x080fe20000410000ULL,
0x0000000c42427220ULL, 0x080fe20000410000ULL, 0x0000000c43437220ULL, 0x080fe20000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000c36367220ULL, 0x080fe20000410000ULL, 0x0000000c37377220ULL, 0x080fe20000410000ULL,
0x0000000c32327220ULL, 0x080fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c12127220ULL, 0x080fe20000410000ULL, 0x0000000c13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff19ff7812ULL, 0x000fda0007826014ULL,
0x0000000f790f1221ULL, 0x000fe20000010100ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b0f0f1820ULL, 0x000fc80000410000ULL, 0x0000000f00071308ULL, 0x000ea40000000800ULL,
0x000000070e0e1220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x000000040e047221ULL, 0x002fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000000ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011600ULL,
0x00005410080e7816ULL, 0x000fe20000000008ULL, 0x0000e2f27f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0e097589ULL, 0x0002a400000e0000ULL, 0x000000080f0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000e3227f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0e087589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100f0c7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x000fe200078e000eULL, 0x00004e3000177802ULL, 0x000fc40000000f00ULL,
0x0000eb7000007944ULL, 0x00cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180f0c7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff167224ULL, 0x004fe200078e000eULL,
0x00004e8000177802ULL, 0x000fc40000000f00ULL, 0x0000eb2000007944ULL, 0x008fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x00001000067c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff517819ULL, 0x000fe2000001165aULL,
0x009800006224783bULL, 0x000f260000000200ULL, 0x000010007c7c7812ULL, 0x000fe200078e0cffULL,
0x00000002510d7824ULL, 0x000fc400078e0252ULL, 0x0000400051157824ULL, 0x008fe400078e026eULL,
0x000020000d0c7824ULL, 0x002fc600078e007cULL, 0x0000b00015667810ULL, 0x000fe40007ffe07cULL,
0x0000b0000c6f7810ULL, 0x000fe40007ffe0ffULL, 0x009800005b0c783bULL, 0x000e620000000200ULL,
0x000000106d6a7824ULL, 0x000fe400078e0266ULL, 0x0000001076737824ULL, 0x100fe400078e026fULL,
0x0000001075717824ULL, 0x100fe200078e026fULL, 0x000000006a20783bULL, 0x000fe20000004200ULL,
0x0000001074707824ULL, 0x000fc400078e026fULL, 0x00000010726f7824ULL, 0x000fe200078e026fULL,
0x000000007354783bULL, 0x000ee20000004200ULL, 0x000000106c687824ULL, 0x100fe400078e0266ULL,
0x000000106b677824ULL, 0x100fe200078e0266ULL, 0x00000000714c783bULL, 0x000ea20000004200ULL,
0x0000001069667824ULL, 0x000fc600078e0266ULL, 0x000000007048783bULL, 0x000ea80000004200ULL,
0x000000006f28783bULL, 0x000ea40000004200ULL, 0x0000000924240232ULL, 0x094fe40000000000ULL,
0x00000000681c783bULL, 0x000ea20000004200ULL, 0x0000000926260232ULL, 0x000fe40000000000ULL,
0x0000000825250232ULL, 0x080fe20000000000ULL, 0x000000006718783bULL, 0x000f220000004200ULL,
0x0000000827270232ULL, 0x000fc60000000000ULL, 0x000000006614783bULL, 0x000ea20000004200ULL,
0x000000090c0c0232ULL, 0x082fe40000000000ULL, 0x000000090e0e0232ULL, 0x000fe40000000000ULL,
0x000000080d0d0232ULL, 0x080fe40000000000ULL, 0x000000080f0f0232ULL, 0x000fe20000000000ULL,
0x000000542444723cULL, 0x048f700000001844ULL, 0x000000562440723cULL, 0x040f700000001840ULL,
0x0000004c243c723cULL, 0x040f70000000183cULL, 0x0000004e2438723cULL, 0x040f700000001838ULL,
0x000000482434723cULL, 0x040f700000001834ULL, 0x0000004a2430723cULL, 0x040f700000001830ULL,
0x00000028242c723cULL, 0x040f70000000182cULL, 0x0000002a2410723cULL, 0x000f700000001810ULL,
0x000000200c44723cULL, 0x060b700000001844ULL, 0x000000220c40723cULL, 0x040b700000001840ULL,
0x0000001c0c3c723cULL, 0x044b70000000183cULL, 0x0000001e0c38723cULL, 0x040b700000001838ULL,
0x000000180c34723cULL, 0x050b700000001834ULL, 0x0000001a0c30723cULL, 0x040b700000001830ULL,
0x000000140c2c723cULL, 0x040b70000000182cULL, 0x000000160c10723cULL, 0x000b620000001810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000805c0d7811ULL, 0x020fe200078e40ffULL,
0x0136900060ff7f8cULL, 0x0003e2000c80043fULL, 0x00000001067d7812ULL, 0x000fc400078ec0ffULL,
0x000000580d00720cULL, 0x000fda0003f06070ULL, 0x000036e000000947ULL, 0x000fea0003800000ULL,
0x000000105a0a7824ULL, 0x002fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe00a0d7812ULL, 0x000fe400078ec0ffULL, 0x000000015c0a7810ULL, 0x000fc60007ffe0ffULL,
0x000001005c0d7824ULL, 0x000fe200078e020dULL, 0x000000530a00720cULL, 0x000fc80003f06070ULL,
0x000000c00d0f7810ULL, 0x000fc80007ffe0ffULL, 0x00000060030d7812ULL, 0x000fca00078ef80fULL,
0x0000075000008947ULL, 0x000fea0003800000ULL, 0x000020005a0c7824ULL, 0x000fe200078e00ffULL,
0x00000003ff1f7819ULL, 0x000fe20000011600ULL, 0x0000000852227824ULL, 0x000fe200078e00ffULL,
0x0000000f580a7217ULL, 0x000fe40007800000ULL, 0x000020000c0c7812ULL, 0x000fe400078ec0ffULL,
0x000000041f157810ULL, 0x040fe20007ffe0ffULL, 0x000000010a0a7824ULL, 0x000fe200078e0a0fULL,
0x000000081f177810ULL, 0x000fe20007ffe0ffULL, 0x0000400051517824ULL, 0x000fe200078e020cULL,
0x0000000c1f1d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000115237824ULL, 0x100fe200078e0200ULL,
0x000000101f277810ULL, 0x000fe20007ffe0ffULL, 0x00000008150e7824ULL, 0x000fe200078e00ffULL,
0x000000200a0a7817ULL, 0x000fe20003800000ULL, 0x000000011f0c7824ULL, 0x040fe200078e020dULL,
0x000000141f297810ULL, 0x000fe20007ffe0ffULL, 0x0000000117257824ULL, 0x140fe200078e0200ULL,
0xfffffff80e237812ULL, 0x000fe200078ee223ULL, 0x0000000817147824ULL, 0x000fe200078e00ffULL,
0x0000000c7b0e7210ULL, 0x000fe20007f1e0ffULL, 0x00000001150c7824ULL, 0x000fe200078e020dULL,
0x0000000a1700720cULL, 0x080fe20003f26070ULL, 0x000000011d247824ULL, 0x000fe200078e0200ULL,
0xfffffff814257812ULL, 0x000fe200078ee225ULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x00005e000e1a7a11ULL, 0x040fe200078040ffULL, 0x0000000127147824ULL, 0x000fe200078e020dULL,
0x0000000a1500720cULL, 0x000fe20003f46070ULL, 0x000000081d4d7824ULL, 0x040fe200078e00ffULL,
0x00005f000e1b7a11ULL, 0x000fe200000f440fULL, 0x000000011d0e7824ULL, 0x100fe200078e020dULL,
0x0000000c7b0f7210ULL, 0x000fe20007f1e0ffULL, 0x00000001170c7824ULL, 0x000fe200078e020dULL,
0x000000181f497810ULL, 0x000fc40007ffe0ffULL, 0x0000000e7b157210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff167224ULL, 0x000fe200000e06ffULL, 0x0000000c7b177210ULL, 0x000fe40007f7e0ffULL,
0x00005e000f187a11ULL, 0x000fe200078040ffULL, 0x000000ffff1c7224ULL, 0x000fe200020e06ffULL,
0x000000147b0c7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1e7224ULL, 0x000fe200018e06ffULL,
0x00005f000f197a11ULL, 0x000fe400000f4416ULL, 0x00005e0015147a11ULL, 0x000fe200078640ffULL,
0x000000ffff0f7224ULL, 0x000fe200028e06ffULL, 0x00005e000c0e7a11ULL, 0x000fc400078840ffULL,
0x00005f0015157a11ULL, 0x000fe200018f441cULL, 0x00000001491c7824ULL, 0x000fe200078e020dULL,
0x00005f000c0f7a11ULL, 0x000fe200020f440fULL, 0x00000001290c7824ULL, 0x100fe200078e020dULL,
0x00005e0017167a11ULL, 0x000fe400078040ffULL, 0x0000001c1f2b7810ULL, 0x040fe40007ffe0ffULL,
0x0000000a1f00720cULL, 0x040fe20003f66070ULL, 0x000000011f1f7824ULL, 0x000fe200078e0200ULL,
0x00005f0017177a11ULL, 0x000fe200000f441eULL, 0x000000012b1e7824ULL, 0x000fe200078e020dULL,
0x0000000c7b207210ULL, 0x000fc40007f1e0ffULL, 0x000000071f217812ULL, 0x000fe400078ec0ffULL,
0x0000001c7b1f7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x0ffffff8214b7812ULL, 0x000fe400078ef800ULL, 0x0000b000517c7810ULL, 0x000fe40007ffe07cULL,
0x00005e00200c7a11ULL, 0x000fe400078040ffULL, 0x0000001e7b7b7210ULL, 0x000fe20007fbe0ffULL,
0x000000104b4b7824ULL, 0x000fe200078e027cULL, 0x0000000822217812ULL, 0x000fe200078ee25dULL,
0x000000ffff227224ULL, 0x000fe200020e06ffULL, 0x00005f00200d7a11ULL, 0x000fe200000f440dULL,
0x000000ffff207224ULL, 0x000fe200028e06ffULL, 0x00005e001f1e7a11ULL, 0x000fe200078840ffULL,
0x00000010211a7825ULL, 0x000fe200078e001aULL, 0x00005e007b1c7a11ULL, 0x000fc400078a40ffULL,
0x0000000a1d00720cULL, 0x080fe20003f06070ULL, 0x0000001023237824ULL, 0x000fe200078e027cULL,
0x00005f001f1f7a11ULL, 0x000fe200020f4422ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a4b7faeULL, 0x0003e2000d901c46ULL, 0x00005f007b1d7a11ULL, 0x000fe200028f4420ULL,
0x0000000129207824ULL, 0x100fe200078e0200ULL, 0x0000000a2700720cULL, 0x080fe20003f66070ULL,
0x0000000149227824ULL, 0x100fe200078e0200ULL, 0x0000000a2900720cULL, 0x0c0fe20003f86070ULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0x0000000a4900720cULL, 0x0c0fe20003fa6070ULL,
0x0000000849497824ULL, 0x000fe200078e00ffULL, 0x0000000a2b00720cULL, 0x000fe20003fc6070ULL,
0x00000001270a7824ULL, 0x000fe200078e0200ULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee224ULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee220ULL,
0x000000012b1a7824ULL, 0x002fc400078e0200ULL, 0x000000082b1b7824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee20aULL, 0x0000001021187825ULL, 0x000fe200078e0018ULL,
0xfffffff8492b7812ULL, 0x000fe400078ee222ULL, 0xfffffff81b497812ULL, 0x000fe200078ee21aULL,
0x0000001025257824ULL, 0x000fe200078e027cULL, 0x0000000018237faeULL, 0x0003e2000d101c46ULL,
0x0000001021167825ULL, 0x000fc800078e0016ULL, 0x000000104d1b7824ULL, 0x000fe200078e027cULL,
0x0000000016257faeULL, 0x0003e2000c901c46ULL, 0x0000001021147825ULL, 0x000fc800078e0014ULL,
0x0000001027277824ULL, 0x000fe200078e027cULL, 0x00000000141b7faeULL, 0x0003e2000c101c46ULL,
0x00000010210e7825ULL, 0x000fc800078e000eULL, 0x0000001029297824ULL, 0x000fe200078e027cULL,
0x000000000e277faeULL, 0x0003e2000d901c46ULL, 0x00000010210c7825ULL, 0x000fc800078e000cULL,
0x000000102b2b7824ULL, 0x000fe200078e027cULL, 0x000000000c297faeULL, 0x0003e2000e101c46ULL,
0x00000010211e7825ULL, 0x000fc800078e001eULL, 0x0000001049497824ULL, 0x000fe200078e027cULL,
0x000000001e2b7faeULL, 0x0003e2000e901c46ULL, 0x00000010211c7825ULL, 0x000fca00078e001cULL,
0x000000001c497faeULL, 0x0003e2000f101c46ULL, 0x0000068000007947ULL, 0x000fea0003800000ULL,
0x000020005a0a7824ULL, 0x000fe200078e00ffULL, 0x0000000400147811ULL, 0x000fe200078fe8ffULL,
0x0000000852267824ULL, 0x000fe200078e00ffULL, 0x0000000c00167811ULL, 0x000fe400078fe8ffULL,
0x000020000a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000114217824ULL, 0x000fe200078e0200ULL,
0x0000000800157811ULL, 0x000fe200078fe8ffULL, 0x00000008140c7824ULL, 0x000fe200078e00ffULL,
0x00000018001c7811ULL, 0x040fe200078fe8ffULL, 0x0000400051517824ULL, 0x000fe200078e020aULL,
0x0000000d000a7211ULL, 0x000fe200078fe8ffULL, 0x0000000116277824ULL, 0x100fe200078e0200ULL,
0xfffffff80c217812ULL, 0x000fe200078ee221ULL, 0x0000000816187824ULL, 0x000fe200078e00ffULL,
0x0000000a7b0c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000115237824ULL, 0x140fe200078e0200ULL,
0x00000014001a7811ULL, 0x000fe200078fe8ffULL, 0x00000008150e7824ULL, 0x000fe200078e00ffULL,
0xfffffff818277812ULL, 0x000fe200078ee227ULL, 0x000000011c0a7824ULL, 0x100fe200078e0200ULL,
0x0000001000187811ULL, 0x000fe200078fe8ffULL, 0x000000081c177824ULL, 0x000fe200078e00ffULL,
0xfffffff80e237812ULL, 0x000fe200078ee223ULL, 0x000000ffff0f7224ULL, 0x000fe200000e06ffULL,
0x00005e000c0e7a11ULL, 0x000fe200078040ffULL, 0x0000000118297824ULL, 0x040fe200078e0200ULL,
0xfffffff8170a7812ULL, 0x000fe200078ee20aULL, 0x00000008181e7824ULL, 0x000fe200078e00ffULL,
0x00005f000c0f7a11ULL, 0x000fe200000f440fULL, 0x00000001140c7824ULL, 0x000fe200078e020dULL,
0x0000001c00177811ULL, 0x000fe200078fe8ffULL, 0x000000011a1b7824ULL, 0x000fe200078e0200ULL,
0xfffffff81e297812ULL, 0x000fe200078ee229ULL, 0x000000081a207824ULL, 0x000fe200078e00ffULL,
0x0000000000247211ULL, 0x000fe200078fe8ffULL, 0x0000000115147824ULL, 0x100fe200078e020dULL,
0x0000b000517c7810ULL, 0x000fe20007ffe07cULL, 0x0000000116167824ULL, 0x000fe200078e020dULL,
0xfffffff8201b7812ULL, 0x000fe200078ee21bULL, 0x0000000118187824ULL, 0x100fe200078e020dULL,
0x000000147b197210ULL, 0x040fe20007f7e0ffULL, 0x000000011a1a7824ULL, 0x100fe200078e020dULL,
0x00000007242b7812ULL, 0x000fe200078ec0ffULL, 0x000000011c1c7824ULL, 0x100fe200078e020dULL,
0x000000187b157210ULL, 0x000fe20007f3e0ffULL, 0x00000001171e7824ULL, 0x000fe200078e020dULL,
0x0000000c7b0d7210ULL, 0x000fe20007f9e0ffULL, 0x0000000117207824ULL, 0x000fe200078e0200ULL,
0x0000001a7b1f7210ULL, 0x000fe20007f5e0ffULL, 0x00000008171d7824ULL, 0x000fe200078e00ffULL,
0x000000167b177210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff147224ULL, 0x000fe200020e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078c40ffULL, 0x000000ffff227224ULL, 0x000fe200018e06ffULL,
0x0000001c7b1a7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200008e06ffULL,
0x0000001e7b7b7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1e7224ULL, 0x000fe200000e06ffULL,
0x00005e0019187a11ULL, 0x000fe200078640ffULL, 0x0000001021217824ULL, 0x000fe200078e027cULL,
0x00005f000d0d7a11ULL, 0x000fe200030f4414ULL, 0x000000101b497824ULL, 0x100fe200078e027cULL,
0x00005e0017167a11ULL, 0x000fe200078040ffULL, 0x0000001023237824ULL, 0x100fe200078e027cULL,
0x00005e0015147a11ULL, 0x000fe200078240ffULL, 0x0000001027277824ULL, 0x000fe200078e027cULL,
0x00005f0019197a11ULL, 0x000fe200018f4422ULL, 0x000000ffff227224ULL, 0x000fe200010e06ffULL,
0xfffffff81d207812ULL, 0x000fe200078ee220ULL, 0x000000ffff1d7224ULL, 0x000fe200020e06ffULL,
0x00005f0017177a11ULL, 0x000fe200000f441eULL, 0x0000001029297824ULL, 0x000fe200078e027cULL,
0x00005f0015157a11ULL, 0x000fe200008f441cULL, 0x000000100a4b7824ULL, 0x100fe200078e027cULL,
0x00005e001f1e7a11ULL, 0x000fe200078040ffULL, 0x00000010204d7824ULL, 0x000fe200078e027cULL,
0x00005e001a1c7a11ULL, 0x000fc400078240ffULL, 0x0000000826257812ULL, 0x000fe400078ee25dULL,
0x0ffffff82b2b7812ULL, 0x000fe400078ef800ULL, 0x00005f001f1f7a11ULL, 0x000fe200000f4422ULL,
0x000000ffff227224ULL, 0x000fe200028e06ffULL, 0x00005f001a1d7a11ULL, 0x000fe200008f441dULL,
0x000000102b2b7824ULL, 0x000fe200078e027cULL, 0x00005e007b1a7a11ULL, 0x000fe200078040ffULL,
0x00000010250e7825ULL, 0x000fc600078e000eULL, 0x00005f007b1b7a11ULL, 0x000fe200000f4422ULL,
0x00000010250c7825ULL, 0x040fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e2b7faeULL, 0x0003e6000b901c46ULL, 0x0000001025187825ULL, 0x040fe200078e0018ULL,
0x000000000c217faeULL, 0x0003e6000b901c46ULL, 0x0000001025167825ULL, 0x040fe200078e0016ULL,
0x0000000018237faeULL, 0x0003e6000b901c46ULL, 0x0000001025147825ULL, 0x040fe200078e0014ULL,
0x0000000016277faeULL, 0x0003e6000b901c46ULL, 0x00000010251e7825ULL, 0x040fe200078e001eULL,
0x0000000014297faeULL, 0x0003e6000b901c46ULL, 0x00000010251c7825ULL, 0x040fe200078e001cULL,
0x000000001e497faeULL, 0x0003e6000b901c46ULL, 0x00000010251a7825ULL, 0x000fe200078e001aULL,
0x000000001c4b7faeULL, 0x0003e8000b901c46ULL, 0x000000001a4d7faeULL, 0x0003e4000b901c46ULL,
0x000000017a507824ULL, 0x000fe400078e0277ULL, 0x00000300ff0a7624ULL, 0x000fc600078e00ffULL,
0x00000001500c7812ULL, 0x002fe400078ec0ffULL, 0xffffffff0a0a7811ULL, 0x000fe400078e08ffULL,
0x000000010c00780cULL, 0x000fc80003f05070ULL, 0x000000010a0d7807ULL, 0x000fe20004000000ULL,
0xffffffffff0a7424ULL, 0x000fc800078e00ffULL, 0x0000000150507824ULL, 0x000fca00078e020dULL,
0x000000595000720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00000001500c7824ULL, 0x000fe400078e0205ULL, 0x00000004ff0d7424ULL, 0x000fc800078e00ffULL,
0x000060000c0c7625ULL, 0x000fca00078e000dULL, 0x000000060c0a7981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01364800780c7f8cULL, 0x0022a4000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0xffffffe00b777812ULL, 0x040fe400078ec0ffULL, 0x000000100b0e7812ULL, 0x040fe400078ec0ffULL,
0x000000080b0f7812ULL, 0x000fc800078ec0ffULL, 0x000000770f777210ULL, 0x000fca0007ffe00eULL,
0x01364c00770f7984ULL, 0x000ee40000000800ULL, 0x800000000fff7812ULL, 0x00cfe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e14177210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e15ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000170e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01364c00770f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000100650c7810ULL, 0x000fca0007ffe064ULL, 0x00000001630c7824ULL, 0x000fca00078e020cULL,
0x013000000c0e7984ULL, 0x000ea80000000800ULL, 0x013200000c0f7984ULL, 0x0006620000000800ULL,
0x000000790e00720bULL, 0x004fe20003f1d000ULL, 0x0000cc627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x008fc800000e0100ULL, 0x0000ffff14ff7812ULL, 0x000fe2000782c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff787224ULL, 0x002fd400078e0079ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x000000025a0d7811ULL, 0x000fe400078ff0ffULL, 0x000000790e00720bULL, 0x000fe40003f34000ULL,
0x0000005a0d00720cULL, 0x000fe20003f05270ULL, 0x0000cc127f007947ULL, 0x000fd4000b800000ULL,
0x0000000000157806ULL, 0x000fc400008e0100ULL, 0x000000805a168824ULL, 0x000fe200078e0265ULL,
0x0000000e790c8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x00009910150d7816ULL, 0x000fe200000000ffULL, 0x0000000163178824ULL, 0x000fca00078e0216ULL,
0x0134000c17008388ULL, 0x0003e20000000800ULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000e790c7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff15ff7812ULL, 0x000fc6000780c0ffULL,
0x8000000c790c7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00197308ULL, 0x000e640000000800ULL, 0x0000001904047220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011600ULL,
0x0000cb227f007947ULL, 0x000fea000b800000ULL, 0x00001f0c190c7589ULL, 0x0002a400000e0000ULL,
0x0000000c44447220ULL, 0x084fe20000410000ULL, 0x0000000c45457220ULL, 0x080fe20000410000ULL,
0x0000000c40407220ULL, 0x080fe20000410000ULL, 0x0000000c41417220ULL, 0x080fe20000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000c38387220ULL, 0x080fe20000410000ULL, 0x0000000c39397220ULL, 0x080fe20000410000ULL,
0x0000000c34347220ULL, 0x080fe20000410000ULL, 0x0000000c35357220ULL, 0x080fe20000410000ULL,
0x0000000c30307220ULL, 0x080fe20000410000ULL, 0x0000000c31317220ULL, 0x080fe20000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000c10107220ULL, 0x080fe20000410000ULL, 0x0000000c11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008000c7811ULL, 0x000fe200078ff0ffULL,
0x0000ca127f007947ULL, 0x000fea000b800000ULL, 0x00001f0c190c7589ULL, 0x0004e400000e0000ULL,
0x0000000c46467220ULL, 0x088fe20000410000ULL, 0x0000000c47477220ULL, 0x080fe20000410000ULL,
0x0000000c42427220ULL, 0x080fe20000410000ULL, 0x0000000c43437220ULL, 0x080fe20000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000c36367220ULL, 0x080fe20000410000ULL, 0x0000000c37377220ULL, 0x080fe20000410000ULL,
0x0000000c32327220ULL, 0x080fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c12127220ULL, 0x080fe20000410000ULL, 0x0000000c13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff15ff7812ULL, 0x000fe40007800814ULL,
0x0000000e79787209ULL, 0x000fd60007810000ULL, 0x800000780e0e0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0e0e0820ULL, 0x000fc80000410000ULL, 0x0000000e00070308ULL, 0x000e640000000800ULL,
0x000000070f0f0220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x000000040f047221ULL, 0x000fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000000ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011600ULL,
0x00005410080e7816ULL, 0x000fe20000000008ULL, 0x0000c8527f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0e097589ULL, 0x0002e400000e0000ULL, 0x000000080f0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000c8827f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0e087589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100f0c7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x000fe200078e000eULL, 0x00006ab000177802ULL, 0x000fc40000000f00ULL,
0x0000cef000007944ULL, 0x01cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180f0c7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff167224ULL, 0x004fe200078e000eULL,
0x00006b0000177802ULL, 0x000fc40000000f00ULL, 0x0000cea000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x00001000060c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff517819ULL, 0x000fe2000001165aULL,
0x00a000006224783bULL, 0x000e660000000200ULL, 0x000010000c157812ULL, 0x000fe200078ec0ffULL,
0x00000002510c7824ULL, 0x000fc400078e0252ULL, 0x0000400051147824ULL, 0x000fe400078e026eULL,
0x000020000c0c7824ULL, 0x000fc600078e0015ULL, 0x0000b00014147810ULL, 0x000fe40007ffe015ULL,
0x0000b0000c0d7810ULL, 0x000fc60007ffe0ffULL, 0x000000106d207824ULL, 0x100fe400078e0214ULL,
0x0000001076547824ULL, 0x100fe400078e020dULL, 0x00000010754c7824ULL, 0x100fe400078e020dULL,
0x0000001074487824ULL, 0x100fe200078e020dULL, 0x000000002020783bULL, 0x000fe20000004200ULL,
0x0000001072287824ULL, 0x000fe400078e020dULL, 0x000000106c1c7824ULL, 0x100fe200078e0214ULL,
0x000000005454783bULL, 0x000ee20000004200ULL, 0x000000106b187824ULL, 0x000fc400078e0214ULL,
0x0000001069147824ULL, 0x000fe200078e0214ULL, 0x000000004c4c783bULL, 0x000ea80000004200ULL,
0x000000004848783bULL, 0x000fe80000004200ULL, 0x000000002828783bULL, 0x000fe20000004200ULL,
0x0000000924240232ULL, 0x00afc40000000000ULL, 0x0000000926260232ULL, 0x080fe20000000000ULL,
0x00a000005b0c783bULL, 0x000e620000000200ULL, 0x0000000825250232ULL, 0x084fe40000000000ULL,
0x0000000827270232ULL, 0x000fe20000000000ULL, 0x000000001c1c783bULL, 0x000ea80000004200ULL,
0x000000001818783bULL, 0x000ee80000004200ULL, 0x000000001414783bULL, 0x000ea20000004200ULL,
0x000000542444723cULL, 0x040f700000001844ULL, 0x000000562440723cULL, 0x040f700000001840ULL,
0x0000004c243c723cULL, 0x000f62000000183cULL, 0x000000090c0c0232ULL, 0x002fc40000000000ULL,
0x000000090e0e0232ULL, 0x000fe40000000000ULL, 0x000000080d0d0232ULL, 0x080fe40000000000ULL,
0x000000080f0f0232ULL, 0x000fe20000000000ULL, 0x0000004e2438723cULL, 0x040f700000001838ULL,
0x000000482434723cULL, 0x040f700000001834ULL, 0x0000004a2430723cULL, 0x040f700000001830ULL,
0x00000028242c723cULL, 0x040f70000000182cULL, 0x0000002a2410723cULL, 0x000f700000001810ULL,
0x000000200c44723cULL, 0x060b700000001844ULL, 0x000000220c40723cULL, 0x040b700000001840ULL,
0x0000001c0c3c723cULL, 0x044b70000000183cULL, 0x0000001e0c38723cULL, 0x040b700000001838ULL,
0x000000180c34723cULL, 0x048b700000001834ULL, 0x0000001a0c30723cULL, 0x040b700000001830ULL,
0x000000140c2c723cULL, 0x040b70000000182cULL, 0x000000160c10723cULL, 0x000b620000001810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000c05c0d7811ULL, 0x020fe200078e40ffULL,
0x0136980060ff7f8cULL, 0x0003e2000c80043fULL, 0x00000001067d7812ULL, 0x000fe200078e0cffULL,
0x000000ffff797224ULL, 0x000fe200078e0078ULL, 0x000000580d00720cULL, 0x000fda0003f06070ULL,
0x00001a5000000947ULL, 0x000fea0003800000ULL, 0x000003005c0d7a10ULL, 0x002fe20007ffe0ffULL,
0x000058000a157a24ULL, 0x010fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000010d0c7810ULL, 0x040fe20007ffe0ffULL, 0x000001000d0d7824ULL, 0x000fe400078e0202ULL,
0x0000008015157824ULL, 0x000fe200078e00ffULL, 0x000000530c00720cULL, 0x000fe40003f06070ULL,
0x0000006003177812ULL, 0x000fd600078ef80dULL, 0x0000077000008947ULL, 0x000fea0003800000ULL,
0x000020005a0e7824ULL, 0x000fe200078e00ffULL, 0x0000000d580c7217ULL, 0x000fe20007800000ULL,
0x0000000852147824ULL, 0x000fe200078e00ffULL, 0x00000003ff277819ULL, 0x000fe40000011600ULL,
0x000020000e0e7812ULL, 0x000fe200078ec0ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a0dULL,
0x00000004270f7810ULL, 0x000fe20007ffe0ffULL, 0x00001000060d7824ULL, 0x000fe200078e00ffULL,
0x00000008145d7812ULL, 0x000fe200078ee25dULL, 0x0000400051207824ULL, 0x000fe200078e020eULL,
0x000000200c227817ULL, 0x000fe20003800000ULL, 0x00000001270e7824ULL, 0x100fe200078e0217ULL,
0x000010000d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000010f217824ULL, 0x100fe200078e0200ULL,
0x00000008271b7810ULL, 0x000fe20007ffe0ffULL, 0x000000080f147824ULL, 0x000fe200078e00ffULL,
0x0000000e150e7210ULL, 0x000fe20007f1e0ffULL, 0x000000010f0c7824ULL, 0x000fe200078e0217ULL,
0x0000b00020207810ULL, 0x000fe20007ffe00dULL, 0x000000011b237824ULL, 0x040fe200078e0200ULL,
0xfffffff814217812ULL, 0x000fe200078ee221ULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x00005e000e1e7a11ULL, 0x040fe200078040ffULL, 0x000000081b147824ULL, 0x000fe200078e00ffULL,
0x0000000c27197810ULL, 0x000fe20007ffe0ffULL, 0x0000001021217824ULL, 0x000fe200078e0220ULL,
0x00005f000e1f7a11ULL, 0x000fc400000f440dULL, 0x0000000c150d7210ULL, 0x000fe20007f1e0ffULL,
0x000000011b0c7824ULL, 0x100fe200078e0217ULL, 0x0000001027257810ULL, 0x000fe20007ffe0ffULL,
0x00000001190e7824ULL, 0x000fe200078e0217ULL, 0xfffffff814237812ULL, 0x000fe200078ee223ULL,
0x000000ffff167224ULL, 0x000fe200000e06ffULL, 0x00005e000d1a7a11ULL, 0x000fe200078040ffULL,
0x0000000125147824ULL, 0x000fe200078e0217ULL, 0x000000221b00720cULL, 0x000fe20003f26070ULL,
0x000000105d1e7825ULL, 0x000fe200078e001eULL, 0x00005f000d1b7a11ULL, 0x000fc400000f4416ULL,
0x0000000c15187210ULL, 0x000fe20007f7e0ffULL, 0x0000000119287824ULL, 0x000fe200078e0200ULL,
0x0000000e150d7210ULL, 0x000fe20007f9e0ffULL, 0x00000008192b7824ULL, 0x000fe200078e00ffULL,
0x0000001415147210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1d7224ULL, 0x000fe200018e06ffULL,
0x000000220f00720cULL, 0x000fe20003f46070ULL, 0x000000ffff167224ULL, 0x000fe200020e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078640ffULL, 0x000000ffff0f7224ULL, 0x000fe200028e06ffULL,
0x00005e00140e7a11ULL, 0x000fe200078840ffULL, 0x000000105d1a7825ULL, 0x000fe200078e001aULL,
0x0000001427497810ULL, 0x000fc40007ffe0ffULL, 0x00005f000d0d7a11ULL, 0x000fe200018f4416ULL,
0x0000000127167824ULL, 0x000fe200078e0200ULL, 0x00005f00140f7a11ULL, 0x000fe200020f440fULL,
0x0000000149147824ULL, 0x000fe200078e0217ULL, 0x00005e00181c7a11ULL, 0x040fe200078040ffULL,
0x0000001023237824ULL, 0x000fe200078e0220ULL, 0x00000018274b7810ULL, 0x000fe20007ffe0ffULL,
0x000000105d0c7825ULL, 0x000fe200078e000cULL, 0x0000001c274d7810ULL, 0x000fe40007ffe0ffULL,
0x00005f00181d7a11ULL, 0x000fe200000f441dULL, 0x000000105d0e7825ULL, 0x000fe200078e000eULL,
0x0000001415267210ULL, 0x000fc40007f1e0ffULL, 0x0000000716297812ULL, 0x000fe200078ec0ffULL,
0x000000014b167824ULL, 0x100fe200078e0217ULL, 0x000000222700720cULL, 0x000fe20003f66070ULL,
0x000000014d187824ULL, 0x000fe200078e0217ULL, 0x0ffffff829297812ULL, 0x000fe200078ef800ULL,
0x000000ffff277224ULL, 0x000fe200000e06ffULL, 0x00005e0026147a11ULL, 0x040fe200078040ffULL,
0x000000105d1c7825ULL, 0x000fe200078e001cULL, 0x0000001615177210ULL, 0x040fe40007f9e0ffULL,
0x0000001815247210ULL, 0x000fe20007fbe0ffULL, 0x0000001029297824ULL, 0x000fe200078e0220ULL,
0x00005f0026157a11ULL, 0x000fe200000f4427ULL, 0x000000ffff267224ULL, 0x000fe200020e06ffULL,
0x00005e0017167a11ULL, 0x000fe200078840ffULL, 0x000000ffff277224ULL, 0x000fe200028e06ffULL,
0x00005e0024187a11ULL, 0x040fe200078a40ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e297faeULL, 0x0003e2000d901c46ULL, 0x000000221900720cULL, 0x080fe20003f06070ULL,
0x000000105d147825ULL, 0x000fe200078e0014ULL, 0x00005f0017177a11ULL, 0x000fe200020f4426ULL,
0x000000001a217faeULL, 0x0005e2000d101c46ULL, 0x00005f0024197a11ULL, 0x000fe200028f4427ULL,
0x0000000149247824ULL, 0x100fe200078e0200ULL, 0x000000222500720cULL, 0x080fe20003f66070ULL,
0x000000014b267824ULL, 0x100fe200078e0200ULL, 0x000000224900720cULL, 0x0c0fe20003f86070ULL,
0x0000000849497824ULL, 0x000fe200078e00ffULL, 0x000000224b00720cULL, 0x0c0fe20003fa6070ULL,
0x000000084b277824ULL, 0x000fe200078e00ffULL, 0x000000224d00720cULL, 0x000fe20003fc6070ULL,
0x0000000125227824ULL, 0x000fe200078e0200ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee228ULL,
0x0000000825257824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee226ULL,
0x000000014d1e7824ULL, 0x042fe200078e0200ULL, 0x000000001c237faeULL, 0x0005e2000c901c46ULL,
0x000000084d297824ULL, 0x000fe200078e00ffULL, 0xfffffff8251f7812ULL, 0x000fe200078ee222ULL,
0x000000102b2b7824ULL, 0x000fe200078e0220ULL, 0xfffffff849257812ULL, 0x000fe200078ee224ULL,
0x0000001027277824ULL, 0x000fe200078e0220ULL, 0xfffffff829297812ULL, 0x000fe200078ee21eULL,
0x000000101f1f7824ULL, 0x100fe200078e0220ULL, 0x000000000c2b7faeULL, 0x0005e2000c101c46ULL,
0x0000001025257824ULL, 0x000fc400078e0220ULL, 0x000000105d167825ULL, 0x000fe200078e0016ULL,
0x000000000e1f7faeULL, 0x0005e6000d901c46ULL, 0x0000001029297824ULL, 0x000fe200078e0220ULL,
0x0000000014257faeULL, 0x0005e2000e101c46ULL, 0x000000105d187825ULL, 0x000fc600078e0018ULL,
0x0000000016277faeULL, 0x0005e8000e901c46ULL, 0x0000000018297faeULL, 0x0005e2000f101c46ULL,
0x000006a000007947ULL, 0x000fea0003800000ULL, 0x00000008520c7824ULL, 0x000fe200078e00ffULL,
0x00000008000f7811ULL, 0x000fe200078fe8ffULL, 0x000020005a287824ULL, 0x000fe200078e00ffULL,
0x0000000c00147811ULL, 0x000fe400078fe8ffULL, 0x000000080c5d7812ULL, 0x000fe200078ee25dULL,
0x000000010f227824ULL, 0x140fe200078e0200ULL, 0x00000017000c7211ULL, 0x040fe200078fe8ffULL,
0x000000080f0d7824ULL, 0x000fe200078e00ffULL, 0x00000004000e7811ULL, 0x000fe200078fe8ffULL,
0x0000000114217824ULL, 0x040fe200078e0200ULL, 0x0000000c150c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000814187824ULL, 0x000fe200078e00ffULL, 0xfffffff80d227812ULL, 0x000fe200078ee222ULL,
0x000000010e237824ULL, 0x100fe200078e0200ULL, 0x00000018001c7811ULL, 0x000fe200078fe8ffULL,
0x000000080e167824ULL, 0x000fe200078e00ffULL, 0xfffffff818217812ULL, 0x000fe200078ee221ULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x00005e000c1e7a11ULL, 0x000fe200078040ffULL,
0x000000011c197824ULL, 0x100fe200078e0200ULL, 0x0000001400187811ULL, 0x000fe200078fe8ffULL,
0x000000081c1a7824ULL, 0x000fe200078e00ffULL, 0xfffffff816237812ULL, 0x000fe200078ee223ULL,
0x0000000114147824ULL, 0x000fe200078e0217ULL, 0x00005f000c1f7a11ULL, 0x000fe200000f440dULL,
0x000000010e0c7824ULL, 0x100fe200078e0217ULL, 0x0000001000167811ULL, 0x000fe200078fe8ffULL,
0x0000000118207824ULL, 0x100fe200078e0200ULL, 0x0000001c00297811ULL, 0x000fe200078fe8ffULL,
0x00000008181d7824ULL, 0x000fe200078e00ffULL, 0x0000000c150c7210ULL, 0x000fe20007f7e0ffULL,
0x000000010f0e7824ULL, 0x100fe200078e0217ULL, 0x0000200028287812ULL, 0x000fe200078ec0ffULL,
0x0000000116247824ULL, 0x040fe200078e0200ULL, 0xfffffff81d207812ULL, 0x000fe200078ee220ULL,
0x00000008161b7824ULL, 0x040fe200078e00ffULL, 0x0000000e150e7210ULL, 0x040fe20007f3e0ffULL,
0x0000000116167824ULL, 0x000fe200078e0217ULL, 0xfffffff81a197812ULL, 0x000fe200078ee219ULL,
0x0000000118187824ULL, 0x100fe200078e0217ULL, 0x0000001415147210ULL, 0x040fe20007f1e0ffULL,
0x000000011c1c7824ULL, 0x100fe200078e0217ULL, 0x00000016150f7210ULL, 0x000fe20007f5e0ffULL,
0x0000000129267824ULL, 0x000fe200078e0217ULL, 0x0000001815277210ULL, 0x040fe20007f9e0ffULL,
0x00001000061d7824ULL, 0x000fe200078e00ffULL, 0x0000001c15177210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200018e06ffULL, 0x0000002615257210ULL, 0x000fe20007f7e0ffULL,
0x0000400051287824ULL, 0x000fe200078e0228ULL, 0x00005e000c1a7a11ULL, 0x000fe200078c40ffULL,
0x000000ffff157224ULL, 0x000fe200008e06ffULL, 0x000010001d1d7812ULL, 0x000fe200078ec0ffULL,
0x0000000129167824ULL, 0x040fe200078e0200ULL, 0x00005e000e1c7a11ULL, 0x000fe200078240ffULL,
0x00000008294d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81b247812ULL, 0x000fe200078ee224ULL,
0x000000ffff267224ULL, 0x000fe200020e06ffULL, 0x00005f000c1b7a11ULL, 0x000fe200030f440dULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x0000b000282a7810ULL, 0x000fe20007ffe01dULL,
0x000000ffff287224ULL, 0x000fe200010e06ffULL, 0x00005f000e1d7a11ULL, 0x000fe200008f4415ULL,
0x000000ffff187224ULL, 0x000fe200028e06ffULL, 0x00005e00140c7a11ULL, 0x000fe200078040ffULL,
0x000000105d1e7825ULL, 0x000fe200078e001eULL, 0x0000000000157211ULL, 0x000fc400078fe8ffULL,
0x00005f00140d7a11ULL, 0x000fe200000f440dULL, 0x0000001023237824ULL, 0x100fe200078e022aULL,
0x0000000715297812ULL, 0x000fe200078ec0ffULL, 0x00000010194b7824ULL, 0x000fe200078e022aULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee216ULL, 0x000000105d1a7825ULL, 0x000fe200078e001aULL,
0x00005e0027147a11ULL, 0x000fe400078240ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078040ffULL,
0x000000105d1c7825ULL, 0x000fe200078e001cULL, 0x00005e0017167a11ULL, 0x000fc400078440ffULL,
0x0ffffff829297812ULL, 0x000fe200078ef800ULL, 0x0000001021217824ULL, 0x000fe200078e022aULL,
0x00005f0027157a11ULL, 0x000fe200008f4426ULL, 0x000000ffff267224ULL, 0x000fe200018e06ffULL,
0x00005f000f0f7a11ULL, 0x000fe200000f4428ULL, 0x0000001029297824ULL, 0x000fe200078e022aULL,
0x00005f0017177a11ULL, 0x000fe200010f4418ULL, 0x0000001022277824ULL, 0x000fe200078e022aULL,
0x00005e0025187a11ULL, 0x000fe200078040ffULL, 0x000000105d0c7825ULL, 0x000fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e297faeULL, 0x0003e4000b901c46ULL,
0x00005f0025197a11ULL, 0x000fe200000f4426ULL, 0x00000010242b7824ULL, 0x000fe200078e022aULL,
0x000000001a237faeULL, 0x0003e2000b901c46ULL, 0x000000105d0e7825ULL, 0x000fc600078e000eULL,
0x000000001c277faeULL, 0x0003e2000b901c46ULL, 0x0000001020497824ULL, 0x000fe400078e022aULL,
0x000000105d147825ULL, 0x040fe200078e0014ULL, 0x000000000c217faeULL, 0x0003e6000b901c46ULL,
0x000000105d167825ULL, 0x000fe200078e0016ULL, 0x000000000e2b7faeULL, 0x0003e6000b901c46ULL,
0x000000104d4d7824ULL, 0x000fe200078e022aULL, 0x0000000014497faeULL, 0x0003e2000b901c46ULL,
0x000000105d187825ULL, 0x000fc600078e0018ULL, 0x00000000164b7faeULL, 0x0003e8000b901c46ULL,
0x00000000184d7faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01366800770c7f8cULL, 0x0062a4000c80043fULL,
0x00000000000e7805ULL, 0x000fc40000015200ULL, 0x01366c0077157984ULL, 0x000ee40000000800ULL,
0x8000000015ff7812ULL, 0x00cfe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x000000140e177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e0fULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001714147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01366c0077157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x004fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018065647810ULL, 0x000fca0007ffe064ULL,
0x0000000163647824ULL, 0x000fca00078e0264ULL, 0x01300000640f7984ULL, 0x000ea80000000800ULL,
0x01320000640e7984ULL, 0x0006620000000800ULL, 0x000000780f00720bULL, 0x004fe20003f1d000ULL,
0x0000b2927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x008fc800000e0100ULL,
0x0000ffff14ff7812ULL, 0x000fe2000782c0ffULL, 0x0000047000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff797224ULL, 0x000fd400078e0078ULL,
0x0000043000009947ULL, 0x000fea0003800000ULL, 0x000000035a0d7811ULL, 0x000fe400078ff0ffULL,
0x000000780f00720bULL, 0x000fe40003f34000ULL, 0x0000005a0d00720cULL, 0x000fe20003f05270ULL,
0x0000b2427f007947ULL, 0x000fd4000b800000ULL, 0x0000000000157806ULL, 0x000fc400008e0100ULL,
0x000000805a0c8824ULL, 0x000fe200078e0265ULL, 0x000000780f797209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe40003800000ULL, 0x0000000163168824ULL, 0x000fe200078e020cULL,
0x00009910150c7816ULL, 0x000fc800000000ffULL, 0x0134007916008388ULL, 0x0005e20000000800ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x00000078790c7221ULL, 0x004fe20000010100ULL, 0x000000ff15ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00197308ULL, 0x000ea40000000800ULL, 0x0000001904047220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011600ULL,
0x0000b1627f007947ULL, 0x000fea000b800000ULL, 0x00001f0c190c7589ULL, 0x0004e400000e0000ULL,
0x0000000c44447220ULL, 0x088fe20000410000ULL, 0x0000000c45457220ULL, 0x080fe20000410000ULL,
0x0000000c40407220ULL, 0x080fe20000410000ULL, 0x0000000c41417220ULL, 0x080fe20000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000c38387220ULL, 0x080fe20000410000ULL, 0x0000000c39397220ULL, 0x080fe20000410000ULL,
0x0000000c34347220ULL, 0x080fe20000410000ULL, 0x0000000c35357220ULL, 0x080fe20000410000ULL,
0x0000000c30307220ULL, 0x080fe20000410000ULL, 0x0000000c31317220ULL, 0x080fe20000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000c10107220ULL, 0x080fe20000410000ULL, 0x0000000c11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008000c7811ULL, 0x000fe200078ff0ffULL,
0x0000b0527f007947ULL, 0x000fea000b800000ULL, 0x00001f0c190c7589ULL, 0x0006a400000e0000ULL,
0x0000000c46467220ULL, 0x084fe20000410000ULL, 0x0000000c47477220ULL, 0x080fe20000410000ULL,
0x0000000c42427220ULL, 0x080fe20000410000ULL, 0x0000000c43437220ULL, 0x080fe20000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000c36367220ULL, 0x080fe20000410000ULL, 0x0000000c37377220ULL, 0x080fe20000410000ULL,
0x0000000c32327220ULL, 0x080fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c12127220ULL, 0x080fe20000410000ULL, 0x0000000c13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff15ff7812ULL, 0x000fda0007800814ULL,
0x0000000f790f0221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL,
0x0000000f00070308ULL, 0x000ea40000000800ULL, 0x000000070e0e0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x000000040e047221ULL, 0x002fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000007ff08723eULL, 0x000fe400000000ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011600ULL, 0x00005410080e7816ULL, 0x000fe20000000008ULL,
0x0000aea27f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0e097589ULL, 0x0002a400000e0000ULL,
0x000000080f0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000aed27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0e087589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100f0c7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x0000864000177802ULL, 0x000fc40000000f00ULL, 0x0000b36000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180f0c7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x004fe200078e000eULL, 0x0000869000177802ULL, 0x000fc40000000f00ULL,
0x0000b31000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x00a800006224783bULL, 0x000f280000000200ULL,
0x000000007354783bULL, 0x000e680000004200ULL, 0x00000000714c783bULL, 0x000fe80000004200ULL,
0x000000007048783bULL, 0x000fe80000004200ULL, 0x000000006f28783bULL, 0x000fe80000004200ULL,
0x00a800005b0c783bULL, 0x002e680000000200ULL, 0x000000006a20783bULL, 0x000ee80000004200ULL,
0x00000000681c783bULL, 0x000ea80000004200ULL, 0x000000006718783bULL, 0x008ee80000004200ULL,
0x000000006614783bULL, 0x004ea20000004200ULL, 0x0000000924240232ULL, 0x010fc40000000000ULL,
0x0000000926260232ULL, 0x000fe40000000000ULL, 0x0000000825250232ULL, 0x080fe40000000000ULL,
0x0000000827270232ULL, 0x000fce0000000000ULL, 0x000000542444723cULL, 0x000f620000001844ULL,
0x000000090c0c0232ULL, 0x002fce0000000000ULL, 0x000000562440723cULL, 0x000f620000001840ULL,
0x000000090e0e0232ULL, 0x000fe40000000000ULL, 0x000000080d0d0232ULL, 0x080fe40000000000ULL,
0x000000080f0f0232ULL, 0x000fc60000000000ULL, 0x0000004c243c723cULL, 0x040f70000000183cULL,
0x0000004e2438723cULL, 0x040f700000001838ULL, 0x000000482434723cULL, 0x040f700000001834ULL,
0x0000004a2430723cULL, 0x040f700000001830ULL, 0x00000028242c723cULL, 0x040f70000000182cULL,
0x0000002a2410723cULL, 0x000f700000001810ULL, 0x000000200c44723cULL, 0x060b700000001844ULL,
0x000000220c40723cULL, 0x040b700000001840ULL, 0x0000001c0c3c723cULL, 0x040b70000000183cULL,
0x0000001e0c38723cULL, 0x040b700000001838ULL, 0x000000180c34723cULL, 0x048b700000001834ULL,
0x0000001a0c30723cULL, 0x040b700000001830ULL, 0x000000140c2c723cULL, 0x044b70000000182cULL,
0x000000160c10723cULL, 0x000b620000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0136a00060ff7f8cULL, 0x0003e2000c80043fULL, 0x00000001067d7812ULL, 0x000fce00078ec0ffULL,
0x000003005c5c7a10ULL, 0x002fc80007ffe0ffULL, 0x000000535c00720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff8cc000007947ULL, 0x000fea000383ffffULL,
0x0000000000087919ULL, 0x000e620000002500ULL, 0x000000ffff177224ULL, 0x020fe400078e0013ULL,
0x000000ffff187224ULL, 0x000fe200078e0012ULL, 0x000000530800720cULL, 0x002fda0003f06070ULL,
0x0000034000000947ULL, 0x000fea0003800000ULL, 0x0180000004007810ULL, 0x000fe20007ffe0ffULL,
0x000000c000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00008a40000a7802ULL, 0x010fc40000000f00ULL, 0x0000adb000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0003ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000400037308ULL, 0x000e640000001000ULL, 0xbf80000003007423ULL, 0x002fc80000000004ULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000003007223ULL, 0x000fc40000000003ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000ea80000000000ULL,
0x0000000000057919ULL, 0x000ee20000000000ULL, 0x00000002ff037819ULL, 0x004fe40000011603ULL,
0x0000000805057811ULL, 0x008fc800078ff0ffULL, 0x00001f0300037589ULL, 0x000ea800000e0000ULL,
0x00001f0500057589ULL, 0x000ee200000e0000ULL, 0x0000004403447220ULL, 0x044fe20000410000ULL,
0x0000004503457220ULL, 0x040fe20000410000ULL, 0x0000004003407220ULL, 0x040fe20000410000ULL,
0x0000004103417220ULL, 0x040fe20000410000ULL, 0x0000003c033c7220ULL, 0x040fe20000410000ULL,
0x0000003d033d7220ULL, 0x040fe20000410000ULL, 0x0000003803387220ULL, 0x040fe20000410000ULL,
0x0000003903397220ULL, 0x040fe20000410000ULL, 0x0000003403347220ULL, 0x040fe20000410000ULL,
0x0000003503357220ULL, 0x040fe20000410000ULL, 0x0000003003307220ULL, 0x040fe20000410000ULL,
0x0000003103317220ULL, 0x040fe20000410000ULL, 0x0000002c032c7220ULL, 0x040fe20000410000ULL,
0x0000002d032d7220ULL, 0x040fe20000410000ULL, 0x0000001003107220ULL, 0x040fe20000410000ULL,
0x0000001103117220ULL, 0x000fe20000410000ULL, 0x0000004605467220ULL, 0x048fe20000410000ULL,
0x0000004705477220ULL, 0x040fe20000410000ULL, 0x0000004205427220ULL, 0x040fe20000410000ULL,
0x0000004305437220ULL, 0x040fe20000410000ULL, 0x0000003e053e7220ULL, 0x040fe20000410000ULL,
0x0000003f053f7220ULL, 0x040fe20000410000ULL, 0x0000003a053a7220ULL, 0x040fe20000410000ULL,
0x0000003b053b7220ULL, 0x040fe20000410000ULL, 0x0000003605367220ULL, 0x040fe20000410000ULL,
0x0000003705377220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x040fe20000410000ULL, 0x0000002e052e7220ULL, 0x040fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000001805187220ULL, 0x040fe20000410000ULL,
0x0000001705177220ULL, 0x000fc80000410000ULL, 0x0000000000037919ULL, 0x000ea20000000000ULL,
0x000000181717723eULL, 0x000fc400000000ffULL, 0x000000444505723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000404109723eULL, 0x000fe400000000ffULL,
0x0000003c3d0a723eULL, 0x010fe400000000ffULL, 0x00000038390b723eULL, 0x000fc400000000ffULL,
0x00000034350c723eULL, 0x000fe400000000ffULL, 0x00000030310d723eULL, 0x000fe400000000ffULL,
0x0000002c2d0e723eULL, 0x000fe400000000ffULL, 0x00000010110f723eULL, 0x000fe400000000ffULL,
0x00000002ff1c7819ULL, 0x004fe40000011603ULL, 0x0000000803297811ULL, 0x000fc400078ff0ffULL,
0x000000011c007810ULL, 0x040fe20007ffe0ffULL, 0x000000081c1b7824ULL, 0x040fe200078e00ffULL,
0x000000021c067810ULL, 0x040fe20007ffe0ffULL, 0x000000081c1d7824ULL, 0x040fe200078e00ffULL,
0x000000051c077810ULL, 0x040fe20007ffe0ffULL, 0x000000081c1f7824ULL, 0x040fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL, 0x000000081c1a7824ULL, 0x040fe200078e00ffULL,
0x000000031c007810ULL, 0x040fe20007ffe0ffULL, 0x000000081c257824ULL, 0x040fe200078e00ffULL,
0x000000061c187810ULL, 0x040fe20007ffe0ffULL, 0x000000081c217824ULL, 0x040fe200078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee206ULL, 0x000000081c197824ULL, 0x040fe200078e00ffULL,
0x000000041c067810ULL, 0x040fe20007ffe0ffULL, 0x000000081c277824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee200ULL, 0x0000100052007824ULL, 0x000fe200078e00ffULL,
0xfffffff81a237812ULL, 0x000fe200078ee207ULL, 0x0000080051077824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee218ULL, 0x0000000403187824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee206ULL, 0x0000000100067824ULL, 0x000fe200078e0207ULL,
0xfffffff819197812ULL, 0x000fe200078ee21cULL, 0x00000008291e7824ULL, 0x000fe200078e00ffULL,
0xffffffff1c1a7810ULL, 0x000fe20007ffe0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0206ULL,
0x0000000c18187812ULL, 0x000fe200078ec0ffULL, 0x0000001019197824ULL, 0x000fe200078e0206ULL,
0xfffffff827277812ULL, 0x000fe200078ee21aULL, 0x000000101d1d7824ULL, 0x100fe200078e0206ULL,
0xfffffff81e297812ULL, 0x000fe200078ee229ULL, 0x000000101f1f7824ULL, 0x100fe200078e0206ULL,
0x000000464710723eULL, 0x000fe200000000ffULL, 0x0000001021217824ULL, 0x000fe200078e0206ULL,
0x000000424311723eULL, 0x000fe200000000ffULL, 0x00000001191a7824ULL, 0x000fe200078e0218ULL,
0x0000003e3f12723eULL, 0x000fe200000000ffULL, 0x0000001023237824ULL, 0x100fe200078e0206ULL,
0x0000003a3b13723eULL, 0x000fe200000000ffULL, 0x00000001181c7824ULL, 0x040fe200078e021bULL,
0x000000051a007388ULL, 0x0005e20000000800ULL, 0x0000001025257824ULL, 0x100fe200078e0206ULL,
0x000000363714723eULL, 0x000fe200000000ffULL, 0x00000001181d7824ULL, 0x040fe200078e021dULL,
0x000000091c007388ULL, 0x000fe20000000800ULL, 0x0000001027277824ULL, 0x100fe200078e0206ULL,
0x000000323315723eULL, 0x000fe200000000ffULL, 0x00000001181e7824ULL, 0x040fe200078e021fULL,
0x0000000a1d007388ULL, 0x000fe20000000800ULL, 0x0000001029297824ULL, 0x000fe200078e0206ULL,
0x0000002e2f16723eULL, 0x000fe200000000ffULL, 0x0000000118217824ULL, 0x040fe200078e0221ULL,
0x0000000b1e007388ULL, 0x000fe20000000800ULL, 0x0000000118207824ULL, 0x000fc400078e0223ULL,
0x0000000118257824ULL, 0x040fe200078e0225ULL, 0x0000000c21007388ULL, 0x0007e20000000800ULL,
0x0000000118227824ULL, 0x040fe400078e0227ULL, 0x0000000118297824ULL, 0x000fe200078e0229ULL,
0x0000000d20007388ULL, 0x000fe20000000800ULL, 0x0000000102197824ULL, 0x000fe400078e0203ULL,
0x00000300ff1a7624ULL, 0x004fe200078e00ffULL, 0x0000000e25007388ULL, 0x000fe20000000800ULL,
0x00000010190c7824ULL, 0x008fc600078e0200ULL, 0x0000000f22007388ULL, 0x000fe20000000800ULL,
0x000000011a00780cULL, 0x000fc60003f05270ULL, 0x0000001029007388ULL, 0x000fe80000000800ULL,
0x000400111c007388ULL, 0x000fe80000000800ULL, 0x000400121d007388ULL, 0x000fe80000000800ULL,
0x000400131e007388ULL, 0x000fe80000000800ULL, 0x0004001421007388ULL, 0x000fe80000000800ULL,
0x0004001520007388ULL, 0x000fe80000000800ULL, 0x0004001625007388ULL, 0x000fe80000000800ULL,
0x0004001722007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000c287984ULL, 0x000ea80000000c00ULL, 0x000400000c307984ULL, 0x000ee80000000c00ULL,
0x000800000c2c7984ULL, 0x000e680000000c00ULL, 0x000c00000c347984ULL, 0x000e620000000c00ULL,
0x200000ff2b2b7230ULL, 0x004fc40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fe40000000000ULL,
0x200000ff29297230ULL, 0x000fe40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x200000ff33337230ULL, 0x008fe40000000000ULL, 0x200000ff32327230ULL, 0x000fe40000000000ULL,
0x200000ff31317230ULL, 0x000fc40000000000ULL, 0x200000ff30307230ULL, 0x000fe40000000000ULL,
0x0000002f2b2b7230ULL, 0x002fe40000000000ULL, 0x0000002e2a2a7230ULL, 0x000fe40000000000ULL,
0x0000002d29297230ULL, 0x000fe40000000000ULL, 0x0000002c28287230ULL, 0x000fe40000000000ULL,
0x0000003733337230ULL, 0x000fc40000000000ULL, 0x0000003632327230ULL, 0x000fe20000000000ULL,
0x000000280c007388ULL, 0x000fe20000000c00ULL, 0x0000003531317230ULL, 0x000fe40000000000ULL,
0x0000003430307230ULL, 0x000fca0000000000ULL, 0x000400300c007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00002a1000008947ULL, 0x000fea0003800000ULL,
0x00005800ff057624ULL, 0x000fe200078e00ffULL, 0x00000000000b7919ULL, 0x000e660000002700ULL,
0x0000660005057a24ULL, 0x000fe200078e02ffULL, 0x0000000000127919ULL, 0x000e680000002600ULL,
0x0000000f05107811ULL, 0x040fe200078e10ffULL, 0x0000030005057a24ULL, 0x000fe200078e02ffULL,
0x000000000c0c7984ULL, 0x000ea40000000c00ULL, 0xfffffff010107812ULL, 0x000fca00078ec0ffULL,
0x00000080050a7824ULL, 0x000fc800078e0210ULL, 0x0000008005057824ULL, 0x000fca00078e020aULL,
0x0000007f05057810ULL, 0x000fe20007ffe0ffULL, 0x000058000b0b7a24ULL, 0x002fc600078e0212ULL,
0xffffff8005057812ULL, 0x000fe200078ec0ffULL, 0x000003000b097a24ULL, 0x000fc600078e02ffULL,
0x00006a0005137a10ULL, 0x000fe20007f1e0ffULL, 0x0000000109087824ULL, 0x000fc800078e0208ULL,
0x00006b00ff117624ULL, 0x000fe200000e06ffULL, 0x0000000151ff7812ULL, 0x000fe4000780f85aULL,
0x0000001308127211ULL, 0x000fc800078258ffULL, 0x0000001108137211ULL, 0x000fe400008f5cffULL,
0x00006a0010187a10ULL, 0x000fc60007f3e0ffULL, 0x0000040052127825ULL, 0x000fcc00078e0012ULL,
0x0000001019127825ULL, 0x000fc800078e0012ULL, 0x00006b00ff197624ULL, 0x000fe200008e06ffULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x0000001003147824ULL, 0x004fe200078e00ffULL,
0x00000001ff157819ULL, 0x000fe20000011603ULL, 0x0000008008117824ULL, 0x000fe200078e00ffULL,
0x00000019ff087819ULL, 0x000fe40000011608ULL, 0x0000007014177812ULL, 0x000fe400078ec0ffULL,
0x0000000c15147812ULL, 0x000fe400078ec0ffULL, 0x00006a0011167a10ULL, 0x000fc40007ebe00aULL,
0x0000001817117210ULL, 0x000fe40007a3e011ULL, 0x0000001614167210ULL, 0x000fe40007c7e017ULL,
0x00006b0008157a10ULL, 0x000fe40002fec4ffULL, 0x0000001114147210ULL, 0x000fe40007fbe0ffULL,
0x00000019ff087210ULL, 0x000fe40000fe4408ULL, 0x00000015ff177210ULL, 0x000fc60001fe84ffULL,
0x000000ffff157224ULL, 0x000fca00028e0608ULL, 0x0000007914007986ULL, 0x0003e8000c101906ULL,
0x0000000416007986ULL, 0x0003e4000c101906ULL, 0x000000ff0300720cULL, 0x004fe20000705670ULL,
0x0000000c12007986ULL, 0x000fe2000c101d06ULL, 0x0000014000007945ULL, 0x000fe60003800000ULL,
0x0000000000007b1dULL, 0x000ff00000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff0c7424ULL, 0x000fe200078e00ffULL, 0xffffffff1a0f7810ULL, 0x000fc60007ffe0ffULL,
0x00006a000b0c7625ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x0000000f0c0c79a8ULL, 0x000ea400099ee1c6ULL, 0x0000000f0c00720cULL, 0x004fc80003f05270ULL,
0x00000001ff047807ULL, 0x002fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000004ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff047984ULL, 0x002e640000000000ULL,
0x000000ff0400720cULL, 0x002fda0003f05270ULL, 0x000025d000008947ULL, 0x000fea0003800000ULL,
0x000000ff5a00720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001003047824ULL, 0x000fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fe40000011603ULL,
0x00000018090c7211ULL, 0x040fe400078038ffULL, 0x00000070040d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c08087812ULL, 0x000fe400078ec0ffULL, 0x0000001909047211ULL, 0x000fe400000f3cffULL,
0x0000000c080c7210ULL, 0x000fc8000791e00dULL, 0x00000004ff0d7210ULL, 0x000fca00007e24ffULL,
0x000000060c047981ULL, 0x000328000c1e1900ULL, 0x000080060c0f7981ULL, 0x000322000c1e1900ULL,
0x000000021a00780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x000100060c117981ULL, 0x002322000c1e1900ULL, 0x000000041a00780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x000180060c137981ULL, 0x002322000c1e1900ULL,
0x000000041a00780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x000200060c157981ULL, 0x002322000c1e1900ULL, 0x000000061a00780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x000280060c177981ULL, 0x002322000c1e1900ULL,
0x000000061a00780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000081a00780cULL, 0x002fe20003f06070ULL, 0x000300060c197981ULL, 0x000318000c1e1900ULL,
0x000380060c1b0981ULL, 0x000324000c1e1900ULL, 0x000000071a087810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff087819ULL, 0x000fc80000011608ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x00000010091d7211ULL, 0x000fe200078038ffULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff0b7224ULL, 0x010fe200078e0004ULL, 0x00006a001d1d7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff090e7211ULL, 0x000fe400000f3cffULL, 0x000007801d1d7810ULL, 0x000fc80007f5e0ffULL,
0x00006b00ff0e7a10ULL, 0x000fc400017e240eULL, 0x0000030012007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000408007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x00000008120c7810ULL, 0x040fe40007ffe0ffULL,
0x00000001120d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000000b04047209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010030b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fc80000011603ULL, 0x000000700b0b7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0b0c7812ULL, 0x000fc800078ef80cULL, 0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xfffc80060c0b7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x00000009120c7810ULL, 0x042fe40007ffe0ffULL,
0x00000002120d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000000f04047209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011603ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xfffd00060c0f7981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a120c7810ULL, 0x042fe40007ffe0ffULL,
0x00000003120d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001104047209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011603ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xfffd80060c117981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b120c7810ULL, 0x042fe40007ffe0ffULL,
0x00000004120d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001304047209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011603ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xfffe00060c137981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c120c7810ULL, 0x042fe40007ffe0ffULL,
0x00000005120d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001504047209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011603ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xfffe80060c157981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d120c7810ULL, 0x042fe40007ffe0ffULL,
0x00000006120d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001704047209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011603ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xffff00060c177981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e120c7810ULL, 0x042fe40007ffe0ffULL,
0x00000007120d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001904047209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011603ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0xffff80060c197981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f120c7810ULL, 0x002fe40007ffe0ffULL,
0x0000001b04047209ULL, 0x000fe40007810000ULL, 0x000003000c007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010030c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011603ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1d0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e060eULL, 0x000000060c1b7981ULL, 0x000326000c1e1900ULL,
0x000004001d1d7810ULL, 0x000fe40007f3e0ffULL, 0x0000000812127810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200008e060eULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000ea40000000000ULL, 0x0000001003087824ULL, 0x004fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x010fc80000011603ULL, 0x0000007008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0b7812ULL, 0x000fca00078ec0ffULL, 0x00000001080b7824ULL, 0x000fca00078e020bULL,
0x000000040b007388ULL, 0x0005e40000000800ULL, 0x00006a0005047a10ULL, 0x004fe20007f3e0ffULL,
0x0000000151137824ULL, 0x000fe200078e0209ULL, 0x000000070300780cULL, 0x040fe20003f04070ULL,
0x00000010030e7824ULL, 0x000fe200078e00ffULL, 0x00000001ff117819ULL, 0x000fe20000011603ULL,
0x00006b00ff057624ULL, 0x000fe200008e06ffULL, 0x00000001510b7812ULL, 0x000fe200078ec0ffULL,
0x0000040052087824ULL, 0x000fe200078e00ffULL, 0x000000700e0f7812ULL, 0x000fe200078ec0ffULL,
0x00000800130c7825ULL, 0x002fe200078e0004ULL, 0x0000000c11127812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000080c0e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000251168824ULL, 0x100fe200078e0252ULL, 0x00000800070c7812ULL, 0x000fe200078ec0ffULL,
0x0000000251188824ULL, 0x000fe200078e0252ULL, 0x0000002003177810ULL, 0x000fe20007ffe0ffULL,
0x000000010f147824ULL, 0x000fe200078e0212ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0f7224ULL, 0x000fe200008e060dULL, 0x00006a000a0a7a10ULL, 0x000fe20007f3e0ffULL,
0x0000200051077824ULL, 0x000fe200078e0200ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000216128824ULL, 0x100fe200078e020bULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x00000002181c8824ULL, 0x000fe200078e020bULL, 0x00006a00100b7a10ULL, 0x000fe20007f5e0ffULL,
0x0000000107107824ULL, 0x000fe200078e020cULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00006b00ff0c7624ULL, 0x000fe200008e06ffULL, 0x0000000a13188211ULL, 0x040fe200078238ffULL,
0x00006b00ff0d7624ULL, 0x000fe200010e06ffULL, 0x0000000b131a8211ULL, 0x040fe200078438ffULL,
0x0000000812128824ULL, 0x100fe200078e0203ULL, 0x0000000c13198211ULL, 0x000fe200008f3cffULL,
0x000000081c1c8824ULL, 0x000fe200078e0203ULL, 0x0000030051007a0cULL, 0x000fe20003f26070ULL,
0x00000010031d7824ULL, 0x000fe200078e0210ULL, 0x0000000d131b8211ULL, 0x000fe200010f3cffULL,
0x0000001003107825ULL, 0x100fe200078e000eULL, 0x00004580121f8811ULL, 0x000fe200078e20ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000041801c218811ULL, 0x000fe200078e20ffULL,
0x0000001017167825ULL, 0x000fe200078e000eULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x00000000140e7984ULL, 0x0002a20000000800ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000001003188825ULL, 0x040fe200078e0018ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00180000101d7faeULL, 0x0007e4000b901c46ULL,
0x00000010031a8825ULL, 0x000fc400078e001aULL, 0x00380000161d7faeULL, 0x0009e2000b901c46ULL,
0x0000000000147805ULL, 0x002fe2000001ff00ULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00000000181f8faeULL, 0x0003e8000b901c46ULL, 0x000000001a218faeULL, 0x0003e2000b901c46ULL,
0x0000000000107805ULL, 0x008fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000167805ULL, 0x010fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x002fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000c0000001947ULL, 0x000fea0003800000ULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x000000ffff307224ULL, 0x000fca00078e0051ULL, 0x0000000130327810ULL, 0x000fc80007ffe0ffULL,
0x0000030032007a0cULL, 0x000fda0003f06070ULL, 0x0000022000000947ULL, 0x000fea0003800000ULL,
0x000000070300780cULL, 0x000fe20003f64070ULL, 0x0000000109377824ULL, 0x000fe200078e0232ULL,
0x0000000132347812ULL, 0x040fe200078ec0ffULL, 0x0000080032317824ULL, 0x000fe200078e00ffULL,
0x00000020033b7810ULL, 0x000fe20007ffe0ffULL, 0x0000080037327825ULL, 0x000fc600078e0004ULL,
0x0000080031367812ULL, 0x000fca00078ec0ffULL, 0x000000025135b824ULL, 0x100fe200078e0252ULL,
0x0000000a3738b211ULL, 0x000fe200078238ffULL, 0x000000025139b824ULL, 0x000fe400078e0252ULL,
0x00000002353ab824ULL, 0x100fe400078e0234ULL, 0x00000002393cb824ULL, 0x000fe200078e0234ULL,
0x0000000832347210ULL, 0x000fe20007f1e0ffULL, 0x0000000107367824ULL, 0x000fe200078e0236ULL,
0x0000000b3732b211ULL, 0x040fe200078438ffULL, 0x000000083a3ab824ULL, 0x000fe200078e0203ULL,
0x0000000c3739b211ULL, 0x040fe200008f3cffULL, 0x000000ffff357224ULL, 0x000fe200000e0633ULL,
0x0000000d3733b211ULL, 0x000fe200010f3cffULL, 0x0000001003317824ULL, 0x000fc400078e0236ULL,
0x000000083c3cb824ULL, 0x000fe400078e0203ULL, 0x000000103b367825ULL, 0x100fe200078e0034ULL,
0x000045803a3bb811ULL, 0x000fe400078e20ffULL, 0x000041803c3db811ULL, 0x000fe200078e20ffULL,
0x0000001003347825ULL, 0x000fc800078e0034ULL, 0x000000100338b825ULL, 0x040fe200078e0038ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000034317faeULL, 0x0003e6000b901c46ULL,
0x000000100332b825ULL, 0x000fe200078e0032ULL, 0x0038000036317faeULL, 0x0003e8000b901c46ULL,
0x00000000383bbfaeULL, 0x0003e8000b901c46ULL, 0x00000000323dbfaeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000008030317824ULL, 0x002fe200078e00ffULL,
0x00000001ff337819ULL, 0x100fe20000011603ULL, 0x0000000251347824ULL, 0x000fe200078e0252ULL,
0x00000002ff417819ULL, 0x000fe20000011603ULL, 0x0000001003327824ULL, 0x000fe200078e00ffULL,
0x0000008031317812ULL, 0x000fc400078ec0ffULL, 0x0000000c33337812ULL, 0x000fe200078ec0ffULL,
0x00000008413b7824ULL, 0x040fe200078e00ffULL, 0x0000007032327812ULL, 0x000fe200078ec0ffULL,
0x0000010034317824ULL, 0x000fe200078e0031ULL, 0x0000000241347810ULL, 0x040fe20007ffe0ffULL,
0x0000000841397824ULL, 0x040fe200078e00ffULL, 0x0000000841457810ULL, 0x040fe20007ffe0ffULL,
0x00000008413f7824ULL, 0x000fe200078e00ffULL, 0x0000003133337210ULL, 0x000fe20007ffe032ULL,
0x0000080030317824ULL, 0x000fe200078e00ffULL, 0x0000000141327810ULL, 0x000fe20007ffe0ffULL,
0x0000000845367824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee234ULL,
0x0000000841347824ULL, 0x000fe200078e00ffULL, 0xfffffff839397812ULL, 0x000fe200078ee232ULL,
0x0000000841437824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0041800033357984ULL, 0x000e620000000800ULL, 0x0000080031327812ULL, 0x000fe200078ec0ffULL,
0x00000008413e7824ULL, 0x000fe200078e00ffULL, 0xfffffff834317812ULL, 0x000fe200078ee241ULL,
0x0045800033387984ULL, 0x0007220000000800ULL, 0x0000018007327810ULL, 0x000fe40007ffe032ULL,
0x0000000341347810ULL, 0x040fe40007ffe0ffULL, 0x00000004413a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001031317824ULL, 0x000fe200078e0232ULL, 0x00000005413d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000403337824ULL, 0x008fe200078e00ffULL, 0x0000000230307810ULL, 0x000fc80007ffe0ffULL,
0x0000000c33447812ULL, 0x000fe400078ec0ffULL, 0xfffffff836337812ULL, 0x000fe400078ee245ULL,
0x0000030030007a0cULL, 0x000fe20003f06070ULL, 0x0000000144317824ULL, 0x000fe400078e0231ULL,
0x0000001033337824ULL, 0x000fc800078e0232ULL, 0x0000000144367824ULL, 0x040fe200078e0233ULL,
0x0000000031317984ULL, 0x000ee20000000800ULL, 0x0000001039337824ULL, 0x000fe200078e0232ULL,
0xfffffff83f397812ULL, 0x000fe400078ee234ULL, 0x00000000363c7984ULL, 0x000ea20000000800ULL,
0x0000000144337824ULL, 0x000fe200078e0233ULL, 0xfffffff8433f7812ULL, 0x000fe400078ee23aULL,
0xffffffff413a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000033347984ULL, 0x000fe20000000800ULL,
0x000000350e357221ULL, 0x006fe20000010100ULL, 0xfffffff83e437812ULL, 0x000fc400078ee23dULL,
0x00040000333d7984ULL, 0x000e620000000800ULL, 0x3fb8aa3b35357820ULL, 0x000fc80000410000ULL,
0x0000003500377308ULL, 0x0005240000000800ULL, 0x000000103b357824ULL, 0x104fe400078e0232ULL,
0x00000008413b7824ULL, 0x000fe400078e00ffULL, 0x0000000144357824ULL, 0x040fe200078e0235ULL,
0x0000003837407220ULL, 0x010fe20000410000ULL, 0x0000000641387810ULL, 0x000fe20007ffe0ffULL,
0x0000001039377824ULL, 0x000fe400078e0232ULL, 0x0000000035367984ULL, 0x000fe20000000800ULL,
0x0000000841397824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee238ULL,
0x000000103f387824ULL, 0x000fe200078e0232ULL, 0x00001f4540427589ULL, 0x0002a200000e0000ULL,
0x0000000144377824ULL, 0x040fe200078e0237ULL, 0xfffffff8393f7812ULL, 0x000fe200078ee23aULL,
0x0000000144387824ULL, 0x000fe200078e0238ULL, 0x00001f4140417589ULL, 0x000f2200000e0000ULL,
0x0000001043397824ULL, 0x100fe200078e0232ULL, 0x0000002f402f7221ULL, 0x000fe20000010000ULL,
0x000000103b3a7824ULL, 0x100fe200078e0232ULL, 0x0000000037337984ULL, 0x000f220000000800ULL,
0x000000103f3b7824ULL, 0x000fc400078e0232ULL, 0x0000000144397824ULL, 0x040fe200078e0239ULL,
0x0000000038327984ULL, 0x000f220000000800ULL, 0x00000001443a7824ULL, 0x040fe400078e023aULL,
0x00000001443b7824ULL, 0x000fe200078e023bULL, 0x00040000353e7984ULL, 0x0005220000000800ULL,
0x30000031ff447230ULL, 0x008fe40000004100ULL, 0x2000003cff437230ULL, 0x100fe20000004100ULL,
0x00040000373f7984ULL, 0x000ee20000000800ULL, 0x3000003cff3c7230ULL, 0x000fc40000004100ULL,
0x2000003dff457230ULL, 0x002fe20000004100ULL, 0x0004000039377984ULL, 0x000e620000000800ULL,
0x20000031ff357230ULL, 0x004fe20000004100ULL, 0x00000042432c7223ULL, 0x080fe2000001002cULL,
0x20000034ff437230ULL, 0x100fe20000004100ULL, 0x0000000039317984ULL, 0x000ea20000000800ULL,
0x30000034ff347230ULL, 0x000fe20000004100ULL, 0x00000041352e7223ULL, 0x090fe2000001002eULL,
0x000000423c2b7223ULL, 0x080fe2000001002bULL, 0x0004000038407984ULL, 0x000f220000000800ULL,
0x3000003dff3c7230ULL, 0x000fe20000004100ULL, 0x0000004134297223ULL, 0x080fe20000010029ULL,
0x00000041432a7223ULL, 0x080fe2000001002aULL, 0x000000003a357984ULL, 0x000f220000000800ULL,
0x20000036ff3d7230ULL, 0x100fe20000004100ULL, 0x00000041442d7223ULL, 0x080fe2000001002dULL,
0x30000036ff367230ULL, 0x000fe20000004100ULL, 0x000400003a387984ULL, 0x000f220000000800ULL,
0x0000004245287223ULL, 0x080fe20000010028ULL, 0x000000413d267223ULL, 0x080fe20000010026ULL,
0x000000423c277223ULL, 0x000fe20000010027ULL, 0x000000003b347984ULL, 0x000f220000000800ULL,
0x0000004136257223ULL, 0x000fc60000010025ULL, 0x000400003b397984ULL, 0x0007220000000800ULL,
0x20000033ff3d7230ULL, 0x100fe40000004100ULL, 0x30000033ff367230ULL, 0x000fe40000004100ULL,
0x20000032ff337230ULL, 0x100fe20000004100ULL, 0x000000413d227223ULL, 0x080fe20000010022ULL,
0x30000032ff327230ULL, 0x000fe20000004100ULL, 0x0000004136217223ULL, 0x080fe20000010021ULL,
0x2000003eff437230ULL, 0x100fe20000004100ULL, 0x00000041331e7223ULL, 0x080fe2000001001eULL,
0x3000003eff3e7230ULL, 0x000fe20000004100ULL, 0x00000041321d7223ULL, 0x080fe2000001001dULL,
0x2000003fff3b7230ULL, 0x108fe20000004100ULL, 0x0000004243247223ULL, 0x080fe20000010024ULL,
0x3000003fff3a7230ULL, 0x000fe20000004100ULL, 0x000000423e237223ULL, 0x080fe20000010023ULL,
0x30000037ff367230ULL, 0x002fe20000004100ULL, 0x000000423b207223ULL, 0x080fe20000010020ULL,
0x20000031ff337230ULL, 0x104fe20000004100ULL, 0x000000423a1f7223ULL, 0x080fe2000001001fULL,
0x30000031ff327230ULL, 0x000fe20000004100ULL, 0x0000004236177223ULL, 0x080fe20000010017ULL,
0x20000037ff317230ULL, 0x000fe20000004100ULL, 0x00000041331a7223ULL, 0x080fe2000001001aULL,
0x20000040ff3b7230ULL, 0x010fe20000004100ULL, 0x0000004132197223ULL, 0x080fe20000010019ULL,
0x30000035ff327230ULL, 0x100fe20000004100ULL, 0x0000004231187223ULL, 0x080fe20000010018ULL,
0x20000035ff317230ULL, 0x000fe20000004100ULL, 0x000000423b1c7223ULL, 0x080fe2000001001cULL,
0x20000038ff337230ULL, 0x000fe20000004100ULL, 0x0000004132157223ULL, 0x080fe20000010015ULL,
0x30000040ff407230ULL, 0x000fe20000004100ULL, 0x0000004131167223ULL, 0x080fe20000010016ULL,
0x20000034ff317230ULL, 0x000fe20000004100ULL, 0x0000004233147223ULL, 0x080fe20000010014ULL,
0x30000038ff387230ULL, 0x000fe20000004100ULL, 0x00000042401b7223ULL, 0x080fe2000001001bULL,
0x30000034ff347230ULL, 0x000fe20000004100ULL, 0x0000004131127223ULL, 0x080fe20000010012ULL,
0x20000039ff337230ULL, 0x100fe20000004100ULL, 0x0000004238137223ULL, 0x000fe20000010013ULL,
0x30000039ff327230ULL, 0x000fe20000004100ULL, 0x0000004134117223ULL, 0x000fc40000010011ULL,
0x0000004233107223ULL, 0x080fe40000010010ULL, 0x00000042320f7223ULL, 0x000fe2000001000fULL,
0xfffff42000008947ULL, 0x000fea000383ffffULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x000000ff5200720cULL, 0x000fe20003f05270ULL, 0x0000001003047824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011603ULL, 0x0000007004057812ULL, 0x000fe400078ec0ffULL,
0x0000000c030a7812ULL, 0x000fca00078ec0ffULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000001003047824ULL, 0x002fe200078e00ffULL,
0x00000001ff037819ULL, 0x000fc80000011603ULL, 0x0000007004047812ULL, 0x000fe400078ec0ffULL,
0x0000000c03087812ULL, 0x000fc600078ec0ffULL, 0x0000008051037824ULL, 0x000fc800078e0204ULL,
0x0000000108047824ULL, 0x000fca00078e0203ULL, 0x0049802f04007388ULL, 0x0003e40000000800ULL,
0x0000000105057824ULL, 0x000fe200078e020aULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0049800005037984ULL, 0x000ee20000000800ULL, 0x0000012000007945ULL, 0x000fe60003800000ULL,
0x004a000005047984ULL, 0x002e620000000800ULL, 0x00000003ff037221ULL, 0x008fc80000010000ULL,
0x0000000403037221ULL, 0x002fca0000010000ULL, 0x0180000003047810ULL, 0x000fc80007ffe0ffULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe200078e0003ULL, 0x0000b4f0000a7802ULL, 0x000fc40000000f00ULL,
0x0000830000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff047224ULL, 0x00efe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000300047308ULL, 0x000e640000001000ULL,
0xbf80000003057423ULL, 0x002fc80000000004ULL, 0x800000ff05057221ULL, 0x000fc80000010100ULL,
0x0000000504047223ULL, 0x000fc40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e680000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000008030b7811ULL, 0x002fc400078ff0ffULL, 0x00000002ff097819ULL, 0x000fc60000011603ULL,
0x00001f0b04077589ULL, 0x000e6200000e0000ULL, 0x00000004090c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000809317824ULL, 0x040fe200078e00ffULL, 0x0000000209087810ULL, 0x040fe20007ffe0ffULL,
0x00001f0904057589ULL, 0x00072200000e0000ULL, 0x00000008092f7824ULL, 0x040fe200078e00ffULL,
0x00000003090a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000809337824ULL, 0x000fe200078e00ffULL,
0xfffffff831317812ULL, 0x000fe200078ee20cULL, 0x00000008090c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee20aULL, 0x0000000809357824ULL, 0x040fe200078e00ffULL,
0xffffffff090a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000809377824ULL, 0x040fe200078e00ffULL,
0x0000000109047810ULL, 0x008fe20007ffe0ffULL, 0x000000102f2f7824ULL, 0x000fe200078e0206ULL,
0xfffffff80c0d7812ULL, 0x000fe200078ee209ULL, 0x000000080b0c7824ULL, 0x000fc400078e00ffULL,
0x0000001031317824ULL, 0x100fe400078e0206ULL, 0x000000100d0d7824ULL, 0x000fe200078e0206ULL,
0xfffffff80c0b7812ULL, 0x000fe200078ee20bULL, 0x0000002c072c7220ULL, 0x042fe20000410000ULL,
0x0000002b072b7220ULL, 0x040fe20000410000ULL, 0x0000002807287220ULL, 0x040fe20000410000ULL,
0x0000002707277220ULL, 0x040fe20000410000ULL, 0x0000002407247220ULL, 0x040fe20000410000ULL,
0x0000002307237220ULL, 0x040fe20000410000ULL, 0x0000002007207220ULL, 0x040fe20000410000ULL,
0x0000001f071f7220ULL, 0x040fe20000410000ULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x0000001b071b7220ULL, 0x040fe20000410000ULL, 0x0000001807187220ULL, 0x040fe20000410000ULL,
0x0000001707177220ULL, 0x040fe20000410000ULL, 0x0000001407147220ULL, 0x040fe20000410000ULL,
0x0000001307137220ULL, 0x040fe20000410000ULL, 0x0000001007107220ULL, 0x040fe20000410000ULL,
0x0000000f07077220ULL, 0x000fe20000410000ULL, 0x00000008090f7824ULL, 0x000fe200078e00ffULL,
0x0000002e052e7220ULL, 0x050fe20000410000ULL, 0x0000002d052d7220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002905297220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002505257220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002105217220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001d051d7220ULL, 0x040fe20000410000ULL,
0x0000001a051a7220ULL, 0x040fe20000410000ULL, 0x0000001905197220ULL, 0x040fe20000410000ULL,
0x0000001605167220ULL, 0x040fe20000410000ULL, 0x0000001505157220ULL, 0x040fe20000410000ULL,
0x0000001205127220ULL, 0x040fe20000410000ULL, 0x0000001105057220ULL, 0x000fe20000410000ULL,
0x0000000809117824ULL, 0x000fe200078e00ffULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee204ULL,
0x000000100b0b7824ULL, 0x000fe200078e0206ULL, 0x0000000509047810ULL, 0x000fc40007ffe0ffULL,
0xfffffff811117812ULL, 0x000fe200078ee208ULL, 0x000000100f0f7824ULL, 0x000fe200078e0206ULL,
0x0000000609087810ULL, 0x000fe40007ffe0ffULL, 0xfffffff833097812ULL, 0x000fe200078ee204ULL,
0x0000000403047824ULL, 0x000fe200078e00ffULL, 0xfffffff835337812ULL, 0x000fe200078ee208ULL,
0x0000001011117824ULL, 0x000fe200078e0206ULL, 0xfffffff837357812ULL, 0x000fe200078ee20aULL,
0x0000001009097824ULL, 0x100fe200078e0206ULL, 0x0000000c04047812ULL, 0x000fe200078ec0ffULL,
0x0000001033337824ULL, 0x100fe200078e0206ULL, 0x0000002e2d2d723eULL, 0x000fe200000000ffULL,
0x0000001035357824ULL, 0x000fe200078e0206ULL, 0x0000002a2929723eULL, 0x000fe200000000ffULL,
0x000000010d067824ULL, 0x000fe200078e0204ULL, 0x000000100707723eULL, 0x000fe200000000ffULL,
0x00000001040c7824ULL, 0x040fe200078e020fULL, 0x000000262525723eULL, 0x000fe200000000ffULL,
0x0000000104107824ULL, 0x040fe200078e0211ULL, 0x000000120505723eULL, 0x000fe200000000ffULL,
0x0000000104127824ULL, 0x040fe200078e022fULL, 0x000000222121723eULL, 0x000fe200000000ffULL,
0x0000002d06007388ULL, 0x000fe20000000800ULL, 0x000000141313723eULL, 0x000fe200000000ffULL,
0x0000000104147824ULL, 0x040fe200078e0231ULL, 0x0000001e1d1d723eULL, 0x000fe200000000ffULL,
0x000000290c007388ULL, 0x000fe20000000800ULL, 0x000000161515723eULL, 0x000fe200000000ffULL,
0x0000000104167824ULL, 0x040fe200078e0209ULL, 0x0000001a1919723eULL, 0x000fe200000000ffULL,
0x00000001041a7824ULL, 0x040fe200078e0235ULL, 0x000000181717723eULL, 0x000fe200000000ffULL,
0x0000000104187824ULL, 0x040fe200078e0233ULL, 0x0000002510007388ULL, 0x000fe20000000800ULL,
0x0000002c2b2b723eULL, 0x000fe200000000ffULL, 0x0000000104047824ULL, 0x000fe200078e020bULL,
0x000000282727723eULL, 0x000fe200000000ffULL, 0x0000002112007388ULL, 0x000fe20000000800ULL,
0x000000242323723eULL, 0x000fe200000000ffULL, 0x0000000102097824ULL, 0x000fe200078e0203ULL,
0x000000201f1f723eULL, 0x000fe200000000ffULL, 0x0000001d14007388ULL, 0x000fe20000000800ULL,
0x0000001c1b1b723eULL, 0x000fe200000000ffULL, 0x0000001009027824ULL, 0x000fc400078e0200ULL,
0x0000001916007388ULL, 0x000fe80000000800ULL, 0x0000001518007388ULL, 0x000fe80000000800ULL,
0x000000051a007388ULL, 0x000fe80000000800ULL, 0x0000002b04007388ULL, 0x000fe80000000800ULL,
0x000400270c007388ULL, 0x000fe80000000800ULL, 0x0004002310007388ULL, 0x000fe80000000800ULL,
0x0004001f12007388ULL, 0x000fe80000000800ULL, 0x0004001b14007388ULL, 0x000fe80000000800ULL,
0x0004001716007388ULL, 0x000fe80000000800ULL, 0x0004001318007388ULL, 0x000fe80000000800ULL,
0x000400071a007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000002087984ULL, 0x000e680000000c00ULL, 0x0004000002207984ULL, 0x000ee80000000c00ULL,
0x00080000020c7984ULL, 0x004ea80000000c00ULL, 0x000c000002247984ULL, 0x000f220000000c00ULL,
0x200000ff0b0b7230ULL, 0x002fc40000000000ULL, 0x200000ff0a0a7230ULL, 0x000fe40000000000ULL,
0x200000ff09097230ULL, 0x000fe40000000000ULL, 0x200000ff08087230ULL, 0x000fe40000000000ULL,
0x200000ff23237230ULL, 0x008fe40000000000ULL, 0x200000ff22227230ULL, 0x000fe40000000000ULL,
0x200000ff21217230ULL, 0x000fc40000000000ULL, 0x200000ff20207230ULL, 0x000fe40000000000ULL,
0x0000000f0b0b7230ULL, 0x004fe40000000000ULL, 0x0000000e0a0a7230ULL, 0x000fe40000000000ULL,
0x0000000d09097230ULL, 0x000fe40000000000ULL, 0x0000000c08087230ULL, 0x000fe40000000000ULL,
0x0000002723237230ULL, 0x010fc40000000000ULL, 0x0000002622227230ULL, 0x000fe20000000000ULL,
0x0000000802007388ULL, 0x000fe20000000c00ULL, 0x0000002521217230ULL, 0x000fe40000000000ULL,
0x0000002420207230ULL, 0x000fca0000000000ULL, 0x0004002002007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff5100720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002003117810ULL, 0x000fe20007ffe0ffULL,
0x0000000000067919ULL, 0x000e620000002600ULL, 0x00000003ff107819ULL, 0x000fe20000011603ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x00000003ff047819ULL, 0x000fe20000011611ULL,
0x0000580000047ab9ULL, 0x000fe40000000800ULL, 0x0000000110057824ULL, 0x000fe200078e0203ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000111027824ULL, 0x000fc600078e0204ULL,
0x0000000705087812ULL, 0x000fe400078ec0ffULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0ffffff808077812ULL, 0x000fe400078ef803ULL, 0x0ffffff802057812ULL, 0x000fc600078ef811ULL,
0x0000001007027824ULL, 0x100fe400078e0200ULL, 0x0000001005057824ULL, 0x000fe400078e0200ULL,
0x0000000806077824ULL, 0x042fe200078e00ffULL, 0x0000000002087984ULL, 0x0002e20000000c00ULL,
0x0000000806137824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x004fe4000f8e023fULL,
0x00000000050c7984ULL, 0x0005220000000c00ULL, 0xfffffff807007812ULL, 0x000fc400078ee210ULL,
0xfffffff813047812ULL, 0x000fe200078ee204ULL, 0x0000000852027824ULL, 0x002fe200078e00ffULL,
0x0000000400107c10ULL, 0x000fe2000ff1e0ffULL, 0x0000000852527824ULL, 0x000fe200078e00ffULL,
0x0000000404007c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff802037812ULL, 0x000fe200078ee203ULL,
0x000000ffff057224ULL, 0x004fe200000e06ffULL, 0x00005a0010047a11ULL, 0x000fe200078040ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x00005a0000067a11ULL, 0x000fc400078240ffULL,
0x00005b0010057a11ULL, 0x000fe400000f4405ULL, 0x00005b0000077a11ULL, 0x000fe400008f4407ULL,
0xfffffff852117812ULL, 0x000fe200078ee211ULL, 0x0000001003027825ULL, 0x000fc800078e0004ULL,
0x0000001011047825ULL, 0x000fe200078e0006ULL, 0x0000000802007986ULL, 0x008fe8000c101d06ULL,
0x0000000c04007986ULL, 0x010fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff037819ULL, 0x000fe2000001165aULL, 0xffffffffff6d7424ULL, 0x000fc800078e00ffULL,
0x000000025c047824ULL, 0x002fca00078e0203ULL, 0x000000590400720cULL, 0x000fda0003f06070ULL,
0x0000000255038824ULL, 0x000fc800078e00ffULL, 0x00006400030a8a24ULL, 0x000fc800078e0204ULL,
0x000060000a0a8625ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000060a6d8981ULL, 0x000ea2000c1e1900ULL, 0x000000015c027810ULL, 0x000fe20007ffe0ffULL,
0x000000405a057824ULL, 0x000fe400078e00ffULL, 0x000000800e037824ULL, 0x000fe200078e00ffULL,
0x000000530200720cULL, 0x000fe20003f06070ULL, 0x000001005c0e7824ULL, 0x000fe200078e0205ULL,
0x01360000ff067f8cULL, 0x000e62000c80043fULL, 0x0000008011027824ULL, 0x000fc600078e00ffULL,
0x0000004003237812ULL, 0x000fe200078ef80eULL, 0x000000026d1a7224ULL, 0x004fcc00078e02ffULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1f7819ULL, 0x002fe40000011600ULL,
0x0000000e58097217ULL, 0x000fe40007800000ULL, 0x000000101f177810ULL, 0x000fe20007ffe0ffULL,
0x00000001230a7824ULL, 0x000fe200078e021fULL, 0x000000081f137810ULL, 0x000fe20007ffe0ffULL,
0x00000001090e7824ULL, 0x000fe200078e0a0eULL, 0x000000181f1c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000a1a0a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000123097824ULL, 0x040fe200078e0213ULL,
0x00000000000f7211ULL, 0x000fe200078fe8ffULL, 0x00000001230b7824ULL, 0x000fe200078e021cULL,
0x000010005a117811ULL, 0x000fe200078e68ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x00005e000a187a11ULL, 0x000fc400078040ffULL, 0x000000030f0f7812ULL, 0x000fe400078ec0ffULL,
0x00005f000a157a11ULL, 0x000fe200000f4415ULL, 0x00000001230a7824ULL, 0x000fe200078e0217ULL,
0x000000091a097210ULL, 0x040fe40007f1e0ffULL, 0x0ffffffc0f007812ULL, 0x000fe400078ef800ULL,
0x0000000a1a0a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x00005e0009107a11ULL, 0x000fc400078040ffULL, 0x0000000b1a0b7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e06ffULL, 0x00005e000a0c7a11ULL, 0x000fe400078240ffULL,
0x0000003008217812ULL, 0x000fe200078ec0ffULL, 0x000000ffff167224ULL, 0x000fe200010e06ffULL,
0x00005f000a0d7a11ULL, 0x000fe200008f440dULL, 0x00000004130a7824ULL, 0x000fe200078e00ffULL,
0x00005f0009147a11ULL, 0x000fe400000f4414ULL, 0x0000000e1f00720cULL, 0x000fc40003f06070ULL,
0x0000000e1300720cULL, 0x000fe20003f26070ULL, 0x0000001000137824ULL, 0x000fe200078e0211ULL,
0x0000001821087210ULL, 0x000fe20007f7e0ffULL, 0x0000000417187824ULL, 0x000fe200078e00ffULL,
0xfffffffc0a007812ULL, 0x000fe400078ee20fULL, 0x00005e000b127a11ULL, 0x000fe200078440ffULL,
0x000000ffff097224ULL, 0x000fe200018e0615ULL, 0x000000201f197810ULL, 0x000fe20007ffe0ffULL,
0x0000001000157824ULL, 0x000fe200078e0211ULL, 0x00005f000b167a11ULL, 0x000fc400010f4416ULL,
0x00000021100a7210ULL, 0x080fe20007f7e0ffULL, 0x0000000123007824ULL, 0x000fe200078e0219ULL,
0x000000210c0c7210ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008137faeULL, 0x0003e2000c101c46ULL, 0x0000000e1700720cULL, 0x080fe20003f46070ULL,
0x000000ffff0b7224ULL, 0x000fe200018e0614ULL, 0xfffffffc18107812ULL, 0x000fe200078ee20fULL,
0x000000ffff0d7224ULL, 0x000fe200020e060dULL, 0x0000000e1c00720cULL, 0x040fe20003f86070ULL,
0x000000041c1c7824ULL, 0x000fe200078e00ffULL, 0x000000000a157faeULL, 0x0005e2000c901c46ULL,
0x0000001010177824ULL, 0x000fe200078e0211ULL, 0x000000281f1b7810ULL, 0x000fc40007ffe0ffULL,
0x000000301f1d7810ULL, 0x040fe40007ffe0ffULL, 0x000000001a097210ULL, 0x002fe20007f1e0ffULL,
0x000000000c177faeULL, 0x0003e2000d101c46ULL, 0x000000381f1f7810ULL, 0x000fe40007ffe0ffULL,
0x00005e0009147a11ULL, 0x000fe200078c40ffULL, 0x000000ffff0a7224ULL, 0x004fe200000e06ffULL,
0x0000002112087210ULL, 0x000fe40007fbe0ffULL, 0xfffffffc1c007812ULL, 0x000fc400078ee20fULL,
0x0000000e1900720cULL, 0x080fe40003f66070ULL, 0x0000000e1b00720cULL, 0x080fe20003f46070ULL,
0x00000010000b7824ULL, 0x000fe200078e0211ULL, 0x0000000e1d00720cULL, 0x080fe20003f26070ULL,
0x0000000123007824ULL, 0x000fe200078e021bULL, 0x0000000e1f00720cULL, 0x000fe20003f06070ULL,
0x00000001230c7824ULL, 0x002fe200078e021fULL, 0x00005f00090e7a11ULL, 0x000fe200030f440aULL,
0x000000ffff097224ULL, 0x000fe200028e0616ULL, 0x000000001a127210ULL, 0x040fe20007fbe0ffULL,
0x00000001230a7824ULL, 0x000fe200078e021dULL, 0x0000000c1a0d7210ULL, 0x040fe20007fde0ffULL,
0x0000000419007824ULL, 0x000fe200078e00ffULL, 0x00000000080b7faeULL, 0x0003e2000e101c46ULL,
0x000000041d0c7824ULL, 0x000fe200078e00ffULL, 0x0000000a1a107210ULL, 0x000fe20007f9e0ffULL,
0x000000041b0a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc00007812ULL, 0x100fe200078ee20fULL,
0x000000041f167824ULL, 0x000fe200078e00ffULL, 0xfffffffc0c0c7812ULL, 0x000fc400078ee20fULL,
0xfffffffc0a0a7812ULL, 0x000fe200078ee20fULL, 0x0000001000137824ULL, 0x100fe400078e0211ULL,
0x000000100c177824ULL, 0x000fe200078e0211ULL, 0xfffffffc16087812ULL, 0x002fe200078ee20fULL,
0x000000ffff097224ULL, 0x000fe200028e06ffULL, 0x00005e00120b7a11ULL, 0x000fe200078a40ffULL,
0x000000100a157824ULL, 0x100fe400078e0211ULL, 0x0000001008117824ULL, 0x000fe200078e0211ULL,
0x00005f0012127a11ULL, 0x000fe200028f4409ULL, 0x000000ffff0f7224ULL, 0x000fe200020e06ffULL,
0x0000002114087210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff007224ULL, 0x000fe200030e06ffULL,
0x00005e00100c7a11ULL, 0x000fc600078840ffULL, 0x000000ffff097224ULL, 0x000fe200028e060eULL,
0x000000210b0a7210ULL, 0x080fe40007fbe0ffULL, 0x00005e000d0e7a11ULL, 0x040fe400078c40ffULL,
0x00005f00100f7a11ULL, 0x000fe200020f440fULL, 0x000000ffff0b7224ULL, 0x000fe200028e0612ULL,
0x000000210c0c7210ULL, 0x080fe20007f9e0ffULL, 0x0000000008137faeULL, 0x0003e2000d901c46ULL,
0x00005f000d007a11ULL, 0x000fe400030f4400ULL, 0x000000210e0e7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200020e060fULL, 0x000000000a157faeULL, 0x0003e6000d101c46ULL,
0x000000ffff0f7224ULL, 0x000fe200028e0600ULL, 0x000000000c177faeULL, 0x0003e8000c901c46ULL,
0x000000000e117faeULL, 0x0003e2000c101c46ULL, 0x0000065000007947ULL, 0x000fea0003800000ULL,
0x0000002300097211ULL, 0x042fe400078ff0ffULL, 0x0000000800187811ULL, 0x000fc400078ff0ffULL,
0x000000091a097210ULL, 0x000fe40007f1e0ffULL, 0x00000010000a7811ULL, 0x040fe400078ff0ffULL,
0x00000018000c7811ULL, 0x040fe200078ff0ffULL, 0x000000ffff247224ULL, 0x000fe200000e06ffULL,
0x00005e0009227a11ULL, 0x000fe200078040ffULL, 0x00000001230b7824ULL, 0x040fe200078e020aULL,
0x00000020000e7811ULL, 0x040fe200078ff0ffULL, 0x00000001230d7824ULL, 0x040fe200078e020cULL,
0x0000002800107811ULL, 0x000fe200078ff0ffULL, 0x000000040a0a7824ULL, 0x000fe200078e00ffULL,
0x0000003000127811ULL, 0x040fe200078ff0ffULL, 0x00000001230f7824ULL, 0x040fe200078e020eULL,
0x0000003800147811ULL, 0x040fe200078ff0ffULL, 0x0000000123117824ULL, 0x040fe200078e0210ULL,
0x0000000000177211ULL, 0x000fe200078fe8ffULL, 0x0000000123137824ULL, 0x000fe200078e0212ULL,
0x00005f0009247a11ULL, 0x000fe200000f4424ULL, 0x0000000123097824ULL, 0x000fe200078e0218ULL,
0x0000000317197812ULL, 0x000fe200078ec0ffULL, 0x0000000123157824ULL, 0x000fe200078e0214ULL,
0x0000000b1a167210ULL, 0x000fe20007fbe0ffULL, 0x000000040c0c7824ULL, 0x000fe200078e00ffULL,
0x000000091a207210ULL, 0x000fe20007fde0ffULL, 0x000000040e0e7824ULL, 0x000fe200078e00ffULL,
0x0000000d1a1c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0x0000000f1a0f7210ULL, 0x000fe20007f3e0ffULL, 0x0000000418187824ULL, 0x000fe200078e00ffULL,
0x000000111a117210ULL, 0x000fe20007f5e0ffULL, 0x0000000414147824ULL, 0x000fe200078e00ffULL,
0x000000131a137210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff177224ULL, 0x000fe200030e06ffULL,
0x000000151a157210ULL, 0x000fe20007f9e0ffULL, 0x00000004101a7824ULL, 0x000fe200078e00ffULL,
0x000010005a257811ULL, 0x000fc400078e68ffULL, 0x0ffffffc19107812ULL, 0x000fe400078ef800ULL,
0xfffffffc0a097812ULL, 0x100fe400078ee219ULL, 0xfffffffc0c0a7812ULL, 0x000fe200078ee219ULL,
0x0000001010277824ULL, 0x000fe200078e0225ULL, 0xfffffffc0e0b7812ULL, 0x000fe200078ee219ULL,
0x00000010091b7824ULL, 0x000fe200078e0225ULL, 0xfffffffc1a0c7812ULL, 0x000fe200078ee219ULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x00005e000f107a11ULL, 0x000fe200078240ffULL,
0x000000100b1f7824ULL, 0x000fe200078e0225ULL, 0xfffffffc120d7812ULL, 0x000fe200078ee219ULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x00005e001c0b7a11ULL, 0x000fe200078040ffULL,
0x000000100c217824ULL, 0x100fe200078e0225ULL, 0x00005f000f1a7a11ULL, 0x000fe200008f441aULL,
0x000000100d237824ULL, 0x000fe200078e0225ULL, 0x00000030080f7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff0d7224ULL, 0x000fe200028e06ffULL, 0xfffffffc18007812ULL, 0x000fe200078ee219ULL,
0x000000100a1d7824ULL, 0x000fe200078e0225ULL, 0x00005e00160c7a11ULL, 0x000fe200078a40ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x00005f001c1c7a11ULL, 0x000fe200000f4409ULL,
0x000000ffff0a7224ULL, 0x000fe200018e06ffULL, 0x00005e00201e7a11ULL, 0x000fc400078c40ffULL,
0xfffffffc140e7812ULL, 0x000fe200078ee219ULL, 0x0000001000197824ULL, 0x100fe200078e0225ULL,
0x000000220f087210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200020e06ffULL,
0x00005e0013147a11ULL, 0x000fe200078440ffULL, 0x000000100e257824ULL, 0x000fe200078e0225ULL,
0x00005e0011127a11ULL, 0x000fe200078240ffULL, 0x000000ffff097224ULL, 0x000fe200000e0624ULL,
0x00005f00160d7a11ULL, 0x000fe400028f440dULL, 0x00005f0020207a11ULL, 0x000fc400030f4417ULL,
0x00005e0015167a11ULL, 0x000fe200078640ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008277faeULL, 0x0003e2000b901c46ULL, 0x00005f0013177a11ULL, 0x000fe400010f440aULL,
0x00005f0011187a11ULL, 0x000fe400008f4418ULL, 0x0000001e0f0a7210ULL, 0x040fe40007f1e0ffULL,
0x0000000c0f0c7210ULL, 0x000fe40007f3e0ffULL, 0x00005f0015007a11ULL, 0x000fc400018f4400ULL,
0x0000000b0f0e7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200000e0620ULL,
0x000000100f107210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x000000120f127210ULL, 0x040fe40007f9e0ffULL, 0x000000140f147210ULL, 0x040fe20007fbe0ffULL,
0x000000ffff117224ULL, 0x000fe200018e061aULL, 0x000000160f167210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200010e061cULL, 0x000000000a197faeULL, 0x0003e2000b901c46ULL,
0x000000ffff137224ULL, 0x000fc400020e0618ULL, 0x000000ffff157224ULL, 0x000fe200028e0617ULL,
0x000000000c1b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff177224ULL, 0x000fc600000e0600ULL,
0x000000000e1d7faeULL, 0x0003e8000b901c46ULL, 0x00000000101f7faeULL, 0x0003e8000b901c46ULL,
0x0000000012217faeULL, 0x0003e8000b901c46ULL, 0x0000000014237faeULL, 0x0003e8000b901c46ULL,
0x0000000016257faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fc40000015200ULL, 0x01360400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fc40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001140bULL, 0x0000000d00007211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000200007819ULL, 0x000fc8000000120bULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01360400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000535c00720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000e620000000000ULL,
0x0000640055557a24ULL, 0x000fe200078e02ffULL, 0x000136885a507811ULL, 0x040fe200078e18ffULL,
0x000000205a007824ULL, 0x000fe200078e00ffULL, 0xffffffff53517810ULL, 0x000fc40007ffe0ffULL,
0x000001005c077824ULL, 0x000fe200078e0205ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000075800720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x000000015c087810ULL, 0x000fe20007ffe0ffULL, 0x0000006d026c7224ULL, 0x000fc600078e02ffULL,
0x000000530800720cULL, 0x000fe40003f06070ULL, 0x0000004007087812ULL, 0x000fca00078ec0ffULL,
0x00000001036d7824ULL, 0x000fcc00078e0208ULL, 0x000006a000008947ULL, 0x000fea0003800000ULL,
0x00000002ff177819ULL, 0x002fe40000011606ULL, 0x00000003066f7812ULL, 0x000fe400078ec0ffULL,
0x00000008171b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000117097824ULL, 0x140fe200078e026dULL,
0x0000001017217810ULL, 0x040fe40007ffe0ffULL, 0x0000001817237810ULL, 0x000fe20007ffe0ffULL,
0x000000041b1d7824ULL, 0x000fe200078e00ffULL, 0x000000096c097210ULL, 0x000fe20007f3e0ffULL,
0x00000001210b7824ULL, 0x100fe200078e026dULL, 0x0000002017247810ULL, 0x000fe20007ffe0ffULL,
0x00000001230d7824ULL, 0x100fe200078e026dULL, 0x0000002817257810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x00005e00090e7a11ULL, 0x000fe200078240ffULL,
0x0000000124117824ULL, 0x000fe200078e026dULL, 0x0000000b6c0b7210ULL, 0x000fc40007f7e0ffULL,
0x00005f00090f7a11ULL, 0x000fe200008f4408ULL, 0x000000011b097824ULL, 0x000fe200078e026dULL,
0x000000116c117210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff167224ULL, 0x000fe200018e06ffULL,
0x00005e000b0c7a11ULL, 0x000fe400078640ffULL, 0x000000096c137210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x0000000d6c097210ULL, 0x000fe40007f9e0ffULL,
0x00005e0011087a11ULL, 0x000fe200078240ffULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0x00005e0013147a11ULL, 0x000fe200078440ffULL, 0x000000ffff127224ULL, 0x000fe200020e06ffULL,
0x00005e00090a7a11ULL, 0x000fc400078840ffULL, 0x00005f000b0d7a11ULL, 0x000fe400018f4416ULL,
0x00005f00090b7a11ULL, 0x000fe400020f4412ULL, 0x00005f0013157a11ULL, 0x000fe200010f4418ULL,
0x0000000158187824ULL, 0x000fe200078e0a07ULL, 0x00005f0011097a11ULL, 0x000fe200008f4410ULL,
0x0000000125117824ULL, 0x000fe200078e026dULL, 0x0000000606107211ULL, 0x040fe400078fe8ffULL,
0x0ffffffc06717812ULL, 0x000fc400078ec0ffULL, 0x0000000310227812ULL, 0x000fe400078ec0ffULL,
0x0000003817277810ULL, 0x040fe40007ffe0ffULL, 0x000000181700720cULL, 0x0c0fe40003f46070ULL,
0x0000003017267810ULL, 0x000fe20007ffe0ffULL, 0x0000000127177824ULL, 0x100fe200078e026dULL,
0x000000181b00720cULL, 0x000fe40003f26070ULL, 0x000020005a1a7811ULL, 0x000fe200078e68ffULL,
0x0000000126137824ULL, 0x040fe200078e026dULL, 0x000000046f197812ULL, 0x000fe200078efcffULL,
0x0000000426297824ULL, 0x000fe200078e00ffULL, 0x00000071221b7212ULL, 0x000fc400078efcffULL,
0xfffffffc1d1d7812ULL, 0x000fe200078ee222ULL, 0x00000010190e7825ULL, 0x000fe200078e000eULL,
0x000000116c1f7210ULL, 0x040fe40007f9e0ffULL, 0x000000176c117210ULL, 0x040fe20007f7e0ffULL,
0x000000101b1b7824ULL, 0x100fe200078e021aULL, 0x000000136c137210ULL, 0x000fe20007fbe0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e021aULL, 0x000000182700720cULL, 0x080fe20003fc6070ULL,
0x0000001019147825ULL, 0x000fe200078e0014ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e1b7faeULL, 0x0003e2000d101c46ULL, 0x000000182300720cULL, 0x000fc40003f46070ULL,
0x000000ffff207224ULL, 0x000fe200020e06ffULL, 0x00005e001f167a11ULL, 0x000fe200078840ffULL,
0x000000ffff1c7224ULL, 0x000fe200018e06ffULL, 0x00000000141d7faeULL, 0x0005e2000c901c46ULL,
0x00005e0011107a11ULL, 0x000fe200078640ffULL, 0x000000ffff1e7224ULL, 0x000fe200028e06ffULL,
0x000000182100720cULL, 0x0c0fe20003f26070ULL, 0x0000000421217824ULL, 0x000fe200078e00ffULL,
0x00005e0013127a11ULL, 0x000fe200078a40ffULL, 0x0000000423237824ULL, 0x000fe200078e00ffULL,
0x00005f001f177a11ULL, 0x000fe200020f4420ULL, 0x00000004241f7824ULL, 0x040fe200078e00ffULL,
0x000000182500720cULL, 0x0c0fe20003f86070ULL, 0x0000000425257824ULL, 0x000fe200078e00ffULL,
0x00005f0011117a11ULL, 0x000fe200018f441cULL, 0x0000000427277824ULL, 0x000fe200078e00ffULL,
0x000000182400720cULL, 0x000fe20003f66070ULL, 0x00000010190c7825ULL, 0x000fe200078e000cULL,
0x00005f0013137a11ULL, 0x000fc400028f441eULL, 0xfffffffc210f7812ULL, 0x002fe200078ee222ULL,
0x00000010190a7825ULL, 0x000fe200078e000aULL, 0x000000182600720cULL, 0x000fe40003fa6070ULL,
0xfffffffc23157812ULL, 0x004fe200078ee222ULL, 0x000000100f0f7824ULL, 0x000fe200078e021aULL,
0xfffffffc1f1b7812ULL, 0x000fe200078ee222ULL, 0x0000001019087825ULL, 0x000fe200078e0008ULL,
0xfffffffc251d7812ULL, 0x100fe400078ee222ULL, 0xfffffffc291f7812ULL, 0x000fe200078ee222ULL,
0x0000001015157824ULL, 0x000fe200078e021aULL, 0xfffffffc27217812ULL, 0x000fe200078ee222ULL,
0x000000101b1b7824ULL, 0x100fe200078e021aULL, 0x000000000c0f7faeULL, 0x0003e2000c901c46ULL,
0x000000101d1d7824ULL, 0x000fc400078e021aULL, 0x0000001019167825ULL, 0x000fe200078e0016ULL,
0x000000000a157faeULL, 0x0003e6000d101c46ULL, 0x000000101f1f7824ULL, 0x000fe200078e021aULL,
0x00000000081b7faeULL, 0x0003e2000d901c46ULL, 0x0000001019127825ULL, 0x000fc600078e0012ULL,
0x00000000161d7faeULL, 0x0003e2000e101c46ULL, 0x0000001021217824ULL, 0x000fe400078e021aULL,
0x0000001019107825ULL, 0x000fe200078e0010ULL, 0x00000000121f7faeULL, 0x0003e8000e901c46ULL,
0x0000000010217faeULL, 0x0003e2000f101c46ULL, 0x000005f000007947ULL, 0x000fea0003800000ULL,
0x0000006d06097211ULL, 0x042fe400078ff0ffULL, 0x00000008060c7811ULL, 0x000fc400078ff0ffULL,
0x000000096c097210ULL, 0x000fe40007f3e0ffULL, 0x0000002006167811ULL, 0x000fe200078ff0ffULL,
0x000000040c117824ULL, 0x000fe200078e00ffULL, 0x00000010060e7811ULL, 0x000fe200078ff0ffULL,
0x000000ffff0a7224ULL, 0x000fe200008e06ffULL, 0x00005e0009087a11ULL, 0x040fe200078240ffULL,
0x0000000416177824ULL, 0x000fe200078e00ffULL, 0x0000002806187811ULL, 0x000fe200078ff0ffULL,
0x000000010e0d7824ULL, 0x000fe200078e026dULL, 0x00000006060b7211ULL, 0x000fe200078fe8ffULL,
0x000000040e137824ULL, 0x000fe200078e00ffULL, 0x00005f0009097a11ULL, 0x000fe200008f440aULL,
0x0000000418197824ULL, 0x000fe200078e00ffULL, 0x00000030061a7811ULL, 0x000fc400078ff0ffULL,
0x0000001806107811ULL, 0x040fe400078ff0ffULL, 0x00000038061e7811ULL, 0x000fe200078ff0ffULL,
0x000000041a1b7824ULL, 0x000fe200078e00ffULL, 0x000000030b0a7812ULL, 0x000fe200078ec0ffULL,
0x000000010c0b7824ULL, 0x100fe200078e026dULL, 0x000020005a257811ULL, 0x000fe200078e68ffULL,
0x0000000410157824ULL, 0x000fe200078e00ffULL, 0xfffffffc110c7812ULL, 0x100fe200078ee20aULL,
0x000000041e1d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc17127812ULL, 0x100fe200078ee20aULL,
0x00000001100f7824ULL, 0x100fe200078e026dULL, 0xfffffffc130e7812ULL, 0x100fe200078ee20aULL,
0x000000011e177824ULL, 0x000fe200078e026dULL, 0xfffffffc19147812ULL, 0x100fe200078ee20aULL,
0x00000010121f7824ULL, 0x100fe200078e0225ULL, 0x0000000d6c117210ULL, 0x000fe20007f5e0ffULL,
0x000000100c197824ULL, 0x100fe200078e0225ULL, 0x0000000b6c137210ULL, 0x000fe20007f3e0ffULL,
0x0000001014217824ULL, 0x100fe200078e0225ULL, 0x0ffffffc06717812ULL, 0x000fe200078ec0ffULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0xfffffffc1b1c7812ULL, 0x100fe200078ee20aULL,
0x000000100e1b7824ULL, 0x000fe200078e0225ULL, 0xfffffffc15107812ULL, 0x100fe200078ee20aULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0xfffffffc1d207812ULL, 0x000fe200078ee20aULL,
0x000000011a157824ULL, 0x000fe200078e026dULL, 0x000000710a0a7212ULL, 0x000fe200078efcffULL,
0x00000010101d7824ULL, 0x100fe200078e0225ULL, 0x0000000f6c0b7210ULL, 0x000fe20007f7e0ffULL,
0x000000101c237824ULL, 0x100fe200078e0225ULL, 0x00005e00110e7a11ULL, 0x000fe200078440ffULL,
0x000000100a297824ULL, 0x000fe200078e0225ULL, 0x00005e00130c7a11ULL, 0x000fe200078240ffULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x00005f00110f7a11ULL, 0x000fe200010f4412ULL,
0x0000000116117824ULL, 0x100fe200078e026dULL, 0x00005f00130d7a11ULL, 0x000fe200008f4414ULL,
0x0000000118137824ULL, 0x000fe200078e026dULL, 0x00005e000b0a7a11ULL, 0x000fe200078640ffULL,
0x0000001020257824ULL, 0x000fe200078e0225ULL, 0x000000116c117210ULL, 0x000fc40007f5e0ffULL,
0x00005f000b0b7a11ULL, 0x000fe400018f4410ULL, 0x000000136c137210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1e7224ULL, 0x000fe200010e06ffULL, 0x00000003066f7812ULL, 0x000fe400078ec0ffULL,
0x000000156c157210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff1c7224ULL, 0x000fe200018e06ffULL,
0x000000176c177210ULL, 0x000fe40007f3e0ffULL, 0x000000046f277812ULL, 0x000fe200078efcffULL,
0x000000ffff1a7224ULL, 0x000fe200020e06ffULL, 0x00005e0011107a11ULL, 0x000fe200078440ffULL,
0x000000ffff187224ULL, 0x000fe200008e06ffULL, 0x00005e0013127a11ULL, 0x000fe200078640ffULL,
0x0000001027087825ULL, 0x000fe200078e0008ULL, 0x00005e0015147a11ULL, 0x000fc400078840ffULL,
0x00005e0017167a11ULL, 0x000fe200078240ffULL, 0x00000010270c7825ULL, 0x000fe200078e000cULL,
0x00005f0011117a11ULL, 0x000fe200010f441eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008297faeULL, 0x0003e2000b901c46ULL, 0x00005f0013137a11ULL, 0x000fe200018f441cULL,
0x00000010270e7825ULL, 0x000fe200078e000eULL, 0x00005f0015157a11ULL, 0x000fe200020f441aULL,
0x000000000c197faeULL, 0x0003e2000b901c46ULL, 0x00005f0017177a11ULL, 0x000fe200008f4418ULL,
0x00000010270a7825ULL, 0x040fe400078e000aULL, 0x000000000e1b7faeULL, 0x0003e4000b901c46ULL,
0x0000001027107825ULL, 0x000fc400078e0010ULL, 0x000000000a1d7faeULL, 0x0003e4000b901c46ULL,
0x0000001027127825ULL, 0x040fe400078e0012ULL, 0x00000000101f7faeULL, 0x0003e4000b901c46ULL,
0x0000001027147825ULL, 0x040fe400078e0014ULL, 0x0000000012217faeULL, 0x0003e4000b901c46ULL,
0x0000001027167825ULL, 0x000fc400078e0016ULL, 0x0000000014237faeULL, 0x0003e8000b901c46ULL,
0x0000000016257faeULL, 0x0003e4000b901c46ULL, 0x00000004ff0b7819ULL, 0x102fe20000011606ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000706097812ULL, 0x000fe200078ec0ffULL,
0x000020005a707824ULL, 0x000fe200078e00ffULL, 0x00000003ff3d7819ULL, 0x100fe20000011606ULL,
0x000000080b0a7824ULL, 0x000fe200078e00ffULL, 0x0000000809527812ULL, 0x000fc400078ef806ULL,
0x0000100070567810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80a0a7812ULL, 0x000fe200078ee209ULL,
0x000000010b547824ULL, 0x000fe200078e0252ULL, 0x000000013d097812ULL, 0x000fe200078ec0ffULL,
0x00000010520b7824ULL, 0x000fe200078e00ffULL, 0x000000100a0c7810ULL, 0x040fe20007ffe0ffULL,
0x000000040a127824ULL, 0x040fe200078e00ffULL, 0x000000200a0e7810ULL, 0x040fe20007ffe0ffULL,
0x000000040a187824ULL, 0x000fe200078e00ffULL, 0xfffffff00b087812ULL, 0x000fe200078ee254ULL,
0x000000040c617824ULL, 0x000fe200078e00ffULL, 0x000000090a0b7211ULL, 0x080fe200078ff8ffULL,
0x0000001052167824ULL, 0x000fe200078e00ffULL, 0x000000300a107810ULL, 0x000fe20007ffe0ffULL,
0x0000001008087824ULL, 0x000fe200078e00ffULL, 0xfffffffc123b7812ULL, 0x000fe200078ee20bULL,
0x000000040e127824ULL, 0x000fe200078e00ffULL, 0x000000090c0a7211ULL, 0x080fe200078ff8ffULL,
0x0000000410147824ULL, 0x000fe200078e00ffULL, 0x000000090e0d7211ULL, 0x080fe200078ff8ffULL,
0x000000103b6e7824ULL, 0x000fe200078e0256ULL, 0x0000000910097211ULL, 0x000fe200078ff8ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffffc61617812ULL, 0x000fe200078ee20aULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0xfffffffc12397812ULL, 0x000fe200078ee20dULL,
0x000000000824783bULL, 0x000fe20000000200ULL, 0xfffffffc145f7812ULL, 0x000fe200078ee209ULL,
0x00000010616b7824ULL, 0x100fe200078e0256ULL, 0x00000002540f7810ULL, 0x000fe20007ffe0ffULL,
0x00000010396a7824ULL, 0x100fe200078e0256ULL, 0x000000006e30783bULL, 0x000e620000000200ULL,
0x000000105f697824ULL, 0x000fe200078e0256ULL, 0x000000020b737810ULL, 0x000fe20007ffe0ffULL,
0x000000040c0c7824ULL, 0x000fe200078e00ffULL, 0x000000006b2c783bULL, 0x000ea20000000200ULL,
0x000000040e0e7824ULL, 0x000fe200078e00ffULL, 0x000000020a5d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000410107824ULL, 0x000fe200078e00ffULL, 0x000000006a28783bULL, 0x000ee20000000200ULL,
0x000000020d5b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000209577810ULL, 0x000fe20007ffe0ffULL,
0x000000006934783bULL, 0x000f220000000200ULL, 0xfffffff0160f7812ULL, 0x000fe400078ee20fULL,
0xfffffffc18737812ULL, 0x000fe400078ee273ULL, 0xfffffffc0c5d7812ULL, 0x000fe200078ee25dULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc0e5b7812ULL, 0x000fe200078ee25bULL,
0x0000001073687824ULL, 0x100fe200078e0256ULL, 0xfffffffc10577812ULL, 0x000fe200078ee257ULL,
0x000000105d677824ULL, 0x100fe200078e0256ULL, 0x000000000f18783bULL, 0x0007e20000000200ULL,
0x000000105b667824ULL, 0x000fc400078e0256ULL, 0x0000001057657824ULL, 0x000fe200078e0256ULL,
0x000000006848783bULL, 0x000f280000000200ULL, 0x000000006708783bULL, 0x000f280000000200ULL,
0x000000006610783bULL, 0x000f280000000200ULL, 0x000000006520783bULL, 0x000f220000000200ULL,
0x00000030241c723cULL, 0x042f7000000018ffULL, 0x0000002c2444723cULL, 0x044f7000000018ffULL,
0x00000028240c723cULL, 0x048f7000000018ffULL, 0x000000322430723cULL, 0x040f7000000018ffULL,
0x0000002e242c723cULL, 0x040f7000000018ffULL, 0x0000002a2428723cULL, 0x040f7000000018ffULL,
0x000000342414723cULL, 0x050f7000000018ffULL, 0x000000362424723cULL, 0x000f7000000018ffULL,
0x00000048181c723cULL, 0x060b70000000181cULL, 0x000000081844723cULL, 0x040b700000001844ULL,
0x00000010180c723cULL, 0x040b70000000180cULL, 0x0000004a1848723cULL, 0x040b700000001830ULL,
0x0000000a1808723cULL, 0x040b70000000182cULL, 0x000000121810723cULL, 0x040b700000001828ULL,
0x000000201814723cULL, 0x040b700000001814ULL, 0x000000221818723cULL, 0x000b620000001824ULL,
0x0000067000008947ULL, 0x000fce0003800000ULL, 0x00000002ff3a7819ULL, 0x100fe20000011606ULL,
0x0000000158377824ULL, 0x000fe200078e0a07ULL, 0x000000086f317812ULL, 0x020fe200078efcffULL,
0x000000013d3d7824ULL, 0x000fe200078e0206ULL, 0x000000083a2e7810ULL, 0x040fe20007ffe0ffULL,
0x000000013a217824ULL, 0x040fe200078e026dULL, 0x000000103a387810ULL, 0x000fc40007ffe0ffULL,
0x000000183a307810ULL, 0x000fe20007ffe0ffULL, 0x000000012e237824ULL, 0x100fe200078e026dULL,
0x000000216c217210ULL, 0x000fe20007f3e0ffULL, 0x0000000138257824ULL, 0x100fe200078e026dULL,
0x000000203a327810ULL, 0x000fe20007ffe0ffULL, 0x00000001302b7824ULL, 0x000fe200078e026dULL,
0x000000236c237210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff207224ULL, 0x000fe200008e06ffULL,
0x00005e0021287a11ULL, 0x040fe200078240ffULL, 0x000000042e337824ULL, 0x000fe200078e00ffULL,
0x000000256c257210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff227224ULL, 0x000fe200010e06ffULL,
0x00005f0021297a11ULL, 0x000fc400008f4420ULL, 0x00005e0023267a11ULL, 0x000fe200078240ffULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0x000000283a347810ULL, 0x000fe20007ffe0ffULL,
0x0000001031287825ULL, 0x000fe200078e0028ULL, 0x00005f0023277a11ULL, 0x000fe400008f4422ULL,
0x0000002b6c2b7210ULL, 0x000fe20007f3e0ffULL, 0x0000000132237824ULL, 0x100fe200078e026dULL,
0x00005e0025207a11ULL, 0x000fe200078440ffULL, 0x00000001342d7824ULL, 0x000fe200078e026dULL,
0x000000303a367810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200008e06ffULL,
0x00005e002b227a11ULL, 0x000fe200078240ffULL, 0x0000001031267825ULL, 0x000fe200078e0026ULL,
0x00005f0025217a11ULL, 0x000fc400010f4424ULL, 0x000000236c257210ULL, 0x000fe40007f5e0ffULL,
0x00005f002b237a11ULL, 0x000fe200008f442aULL, 0x00000001362b7824ULL, 0x000fe200078e026dULL,
0x0000002d6c2d7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff2c7224ULL, 0x000fe200010e06ffULL,
0x00005e0025247a11ULL, 0x000fe200078440ffULL, 0x0000001031207825ULL, 0x000fe200078e0020ULL,
0x0000002b6c2b7210ULL, 0x000fe40007f7e0ffULL, 0x00005f0025257a11ULL, 0x000fe200010f442cULL,
0x000000ffff3c7224ULL, 0x000fe200008e06ffULL, 0x000000373a00720cULL, 0x040fe20003f26070ULL,
0x000000ffff3e7224ULL, 0x000fe200018e06ffULL, 0x000000383a3a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001031227825ULL, 0x000fe200078e0022ULL, 0x00005e002d2c7a11ULL, 0x000fc400078440ffULL,
0x00005e002b2a7a11ULL, 0x000fe200078640ffULL, 0x000000013a2f7824ULL, 0x000fe200078e026dULL,
0x000000033d647812ULL, 0x000fe200078ec0ffULL, 0x0000001031247825ULL, 0x000fe200078e0024ULL,
0x00005f002d2d7a11ULL, 0x000fe400010f443cULL, 0x00005f002b2b7a11ULL, 0x000fe400018f443eULL,
0x000000372e00720cULL, 0x000fe20003f46070ULL, 0x00000010312c7825ULL, 0x000fe200078e002cULL,
0x0000002f6c357210ULL, 0x000fc40007f7e0ffULL, 0x0000007164717212ULL, 0x000fe200078efcffULL,
0x00000010312a7825ULL, 0x000fe200078e002aULL, 0xfffffffc332f7812ULL, 0x000fe400078ee264ULL,
0x000000373400720cULL, 0x080fe20003f86070ULL, 0x000000ffff3c7224ULL, 0x000fe200018e06ffULL,
0x00005e00352e7a11ULL, 0x000fe200078640ffULL, 0x0000001071637824ULL, 0x100fe200078e0256ULL,
0x000000373600720cULL, 0x080fe20003fa6070ULL, 0x000000102f337824ULL, 0x000fe200078e0256ULL,
0x00005f00352f7a11ULL, 0x000fe200018f443cULL, 0x0000000438357824ULL, 0x040fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028637faeULL, 0x0003e2000c901c46ULL,
0x000000373800720cULL, 0x000fc40003f26070ULL, 0x00000010312e7825ULL, 0x000fe200078e002eULL,
0x0000000026337faeULL, 0x0005e2000d101c46ULL, 0x000000373000720cULL, 0x080fe40003f46070ULL,
0x0000000434317824ULL, 0x000fe200078e00ffULL, 0x000000373200720cULL, 0x080fe40003f66070ULL,
0x000000373a00720cULL, 0x040fe20003fc6070ULL, 0x000000043a377824ULL, 0x000fe200078e00ffULL,
0xfffffffc35357812ULL, 0x100fe200078ee264ULL, 0x0000000432297824ULL, 0x002fe200078e00ffULL,
0xfffffffc31317812ULL, 0x100fe200078ee264ULL, 0x0000000430277824ULL, 0x004fe200078e00ffULL,
0xfffffffc37377812ULL, 0x100fe200078ee264ULL, 0x0000000436337824ULL, 0x000fe200078e00ffULL,
0xfffffffc29297812ULL, 0x000fe200078ee264ULL, 0x0000001035357824ULL, 0x000fe200078e0256ULL,
0xfffffffc27277812ULL, 0x000fe200078ee264ULL, 0x0000001031317824ULL, 0x000fe200078e0256ULL,
0xfffffffc33337812ULL, 0x000fe200078ee264ULL, 0x0000001029297824ULL, 0x100fe200078e0256ULL,
0x0000000020357faeULL, 0x0003e2000c901c46ULL, 0x0000001027277824ULL, 0x000fc400078e0256ULL,
0x0000001033337824ULL, 0x100fe400078e0256ULL, 0x0000001037377824ULL, 0x000fe200078e0256ULL,
0x0000000022277faeULL, 0x0003e8000d101c46ULL, 0x0000000024297faeULL, 0x0003e8000d901c46ULL,
0x000000002c317faeULL, 0x0003e8000e101c46ULL, 0x000000002a337faeULL, 0x0003e8000e901c46ULL,
0x000000002e377faeULL, 0x0003e2000f101c46ULL, 0x000005c000007947ULL, 0x000fea0003800000ULL,
0x00000008062c7811ULL, 0x060fe200078ff0ffULL, 0x000000013d3d7824ULL, 0x000fe200078e0206ULL,
0x0000006d06217211ULL, 0x000fc400078ff0ffULL, 0x00000010062e7811ULL, 0x000fe200078ff0ffULL,
0x000000012c237824ULL, 0x000fe200078e026dULL, 0x000000216c217210ULL, 0x000fe20007f3e0ffULL,
0x000000042c317824ULL, 0x000fe200078e00ffULL, 0x0000001806347811ULL, 0x000fe200078ff0ffULL,
0x000000042e337824ULL, 0x000fe200078e00ffULL, 0x000000236c237210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff207224ULL, 0x000fe200008e06ffULL, 0x00005e00212a7a11ULL, 0x000fe400078240ffULL,
0x0000002006327811ULL, 0x000fe200078ff0ffULL, 0x000000ffff227224ULL, 0x000fe200010e06ffULL,
0x00005e0023287a11ULL, 0x000fc400078440ffULL, 0x00005f00212b7a11ULL, 0x000fe200008f4420ULL,
0x000000012e217824ULL, 0x100fe200078e026dULL, 0x00005f0023297a11ULL, 0x000fe200010f4422ULL,
0x0000000134237824ULL, 0x100fe200078e026dULL, 0x0000002806307811ULL, 0x000fe200078ff0ffULL,
0x0000000132257824ULL, 0x100fe200078e026dULL, 0x000000216c217210ULL, 0x040fe40007f5e0ffULL,
0x000000236c237210ULL, 0x000fe20007f7e0ffULL, 0x0000000130277824ULL, 0x000fe200078e026dULL,
0x000000256c257210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x00005e0021267a11ULL, 0x000fe200078440ffULL, 0x000000ffff387224ULL, 0x000fe200018e06ffULL,
0x000000276c2d7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff3a7224ULL, 0x000fe200020e06ffULL,
0x00005e0023207a11ULL, 0x000fc400078640ffULL, 0x00005f0021277a11ULL, 0x000fe200010f4436ULL,
0x000000ffff3c7224ULL, 0x000fe200008e06ffULL, 0x00005e0025227a11ULL, 0x000fe400078840ffULL,
0x00005f0023217a11ULL, 0x000fe400018f4438ULL, 0x00005e002d247a11ULL, 0x000fe400078240ffULL,
0x0000003006387811ULL, 0x040fe400078ff0ffULL, 0x0000003806367811ULL, 0x000fc400078ff0ffULL,
0x00005f0025237a11ULL, 0x000fe400020f443aULL, 0x00005f002d257a11ULL, 0x000fe200008f443cULL,
0x00000001382d7824ULL, 0x100fe200078e026dULL, 0x000000033d647812ULL, 0x000fe200078ec0ffULL,
0x00000001362f7824ULL, 0x000fe200078e026dULL, 0x000000086f357812ULL, 0x000fe200078efcffULL,
0x00000004383d7824ULL, 0x000fe200078e00ffULL, 0x0000002d6c2d7210ULL, 0x000fe20007f3e0ffULL,
0x00000004363f7824ULL, 0x000fe200078e00ffULL, 0x0000002f6c377210ULL, 0x000fe20007f5e0ffULL,
0x00000010352a7825ULL, 0x000fe200078e002aULL, 0x0000007164717212ULL, 0x000fc400078efcffULL,
0xfffffffc31317812ULL, 0x000fe200078ee264ULL, 0x000000ffff3a7224ULL, 0x000fe200008e06ffULL,
0x00005e002d2e7a11ULL, 0x000fe200078240ffULL, 0x000000ffff3c7224ULL, 0x000fe200010e06ffULL,
0x00005e00372c7a11ULL, 0x000fe200078440ffULL, 0x0000001071637824ULL, 0x000fe200078e0256ULL,
0x00005f002d2f7a11ULL, 0x000fe200008f443aULL, 0x0000001035287825ULL, 0x000fe200078e0028ULL,
0x00005f00372d7a11ULL, 0x000fe400010f443cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a637faeULL, 0x0003e2000b901c46ULL, 0x0000001035267825ULL, 0x000fe200078e0026ULL,
0xfffffffc33337812ULL, 0x000fc400078ee264ULL, 0xfffffffc3d3d7812ULL, 0x000fe200078ee264ULL,
0x0000001035207825ULL, 0x000fc800078e0020ULL, 0x0000001035227825ULL, 0x000fc800078e0022ULL,
0x0000001035247825ULL, 0x000fc800078e0024ULL, 0x00000010352e7825ULL, 0x000fc800078e002eULL,
0x00000010352c7825ULL, 0x000fc800078e002cULL, 0x00000004342b7824ULL, 0x002fe400078e00ffULL,
0x0000000432357824ULL, 0x000fe400078e00ffULL, 0x0000000430377824ULL, 0x000fe200078e00ffULL,
0xfffffffc2b2b7812ULL, 0x000fe200078ee264ULL, 0x0000001031317824ULL, 0x000fe200078e0256ULL,
0xfffffffc35357812ULL, 0x000fe200078ee264ULL, 0x0000001033337824ULL, 0x000fe200078e0256ULL,
0xfffffffc37377812ULL, 0x000fe200078ee264ULL, 0x000000102b2b7824ULL, 0x100fe200078e0256ULL,
0x0000000028317faeULL, 0x0003e2000b901c46ULL, 0x0000001035357824ULL, 0x000fc400078e0256ULL,
0x0000001037377824ULL, 0x100fe200078e0256ULL, 0x0000000026337faeULL, 0x0005e2000b901c46ULL,
0x000000103d3d7824ULL, 0x000fc600078e0256ULL, 0x00000000202b7faeULL, 0x0005e2000b901c46ULL,
0xfffffffc3f297812ULL, 0x002fc600078ee264ULL, 0x0000000022357faeULL, 0x0005e4000b901c46ULL,
0x0000001029297824ULL, 0x000fe400078e0256ULL, 0x0000000024377faeULL, 0x0005e8000b901c46ULL,
0x000000002e3d7faeULL, 0x0005e8000b901c46ULL, 0x000000002c297faeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001052217824ULL, 0x006fe200078e00ffULL,
0x0000000454207810ULL, 0x000fe20007ffe0ffULL, 0x0000001052227824ULL, 0x000fe200078e00ffULL,
0x0000200070707810ULL, 0x000fc40007ffe0ffULL, 0xfffffff021207812ULL, 0x000fe400078ee220ULL,
0x0000000654217810ULL, 0x000fe20007ffe0ffULL, 0x000000103b627824ULL, 0x100fe400078e0270ULL,
0x0000001020207824ULL, 0x000fe200078e00ffULL, 0xfffffff022217812ULL, 0x000fe200078ee221ULL,
0x0000001061617824ULL, 0x100fe400078e0270ULL, 0x0000001039607824ULL, 0x100fe400078e0270ULL,
0x000000105f5f7824ULL, 0x000fc400078e0270ULL, 0x0000001021217824ULL, 0x000fe400078e00ffULL,
0x00000010735e7824ULL, 0x100fe400078e0270ULL, 0x000000105d5d7824ULL, 0x000fe200078e0270ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000000624c783bULL, 0x000fe20000000200ULL,
0x000000105b5b7824ULL, 0x100fe400078e0270ULL, 0x0000001057577824ULL, 0x000fe200078e0270ULL,
0x000000002034783bULL, 0x000e680000000200ULL, 0x000000006140783bULL, 0x000ea80000000200ULL,
0x00000000603c783bULL, 0x000ee80000000200ULL, 0x000000005f38783bULL, 0x000f280000000200ULL,
0x000000005e30783bULL, 0x000fe80000000200ULL, 0x000000002120783bULL, 0x000ee80000000200ULL,
0x000000005d2c783bULL, 0x000ee80000000200ULL, 0x000000005b28783bULL, 0x000ee80000000200ULL,
0x000000005724783bULL, 0x000ee20000000200ULL, 0x0000004c341c723cULL, 0x042f70000000181cULL,
0x0000004e3448723cULL, 0x040f700000001848ULL, 0x000000403444723cULL, 0x044f700000001844ULL,
0x000000423408723cULL, 0x040f700000001808ULL, 0x0000003c340c723cULL, 0x048f70000000180cULL,
0x0000003e3410723cULL, 0x040f700000001810ULL, 0x000000383414723cULL, 0x050f700000001814ULL,
0x0000003a3418723cULL, 0x000f700000001818ULL, 0x00000030201c723cULL, 0x060b70000000181cULL,
0x000000322048723cULL, 0x040b700000001848ULL, 0x0000002c2044723cULL, 0x040b700000001844ULL,
0x0000002e2008723cULL, 0x040b700000001808ULL, 0x00000028200c723cULL, 0x040b70000000180cULL,
0x0000002a2010723cULL, 0x040b700000001810ULL, 0x000000242014723cULL, 0x040b700000001814ULL,
0x000000262020723cULL, 0x000b620000001818ULL, 0x0000064000008947ULL, 0x000fce0003800000ULL,
0x00000002ff267819ULL, 0x020fe20000011606ULL, 0x0000000158317824ULL, 0x000fe200078e0a07ULL,
0x0000000c6f6f7812ULL, 0x000fe200078efcffULL, 0x0000001071717824ULL, 0x000fe200078e0270ULL,
0x0000000826327810ULL, 0x040fe20007ffe0ffULL, 0x0000000126197824ULL, 0x040fe200078e026dULL,
0x0000001026307810ULL, 0x000fc40007ffe0ffULL, 0x0000001826347810ULL, 0x000fe20007ffe0ffULL,
0x00000001321b7824ULL, 0x100fe200078e026dULL, 0x000000196c197210ULL, 0x000fe20007f1e0ffULL,
0x0000000130257824ULL, 0x100fe200078e026dULL, 0x0000002026367810ULL, 0x000fe20007ffe0ffULL,
0x0000000434357824ULL, 0x000fe200078e00ffULL, 0x0000001b6c1b7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff287224ULL, 0x000fe200000e06ffULL, 0x000000256c277210ULL, 0x000fe20007f5e0ffULL,
0x0000000136297824ULL, 0x040fe200078e026dULL, 0x00005e0019247a11ULL, 0x000fe200078040ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x00005e001b187a11ULL, 0x000fe200078240ffULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x00005e00271a7a11ULL, 0x000fe200078440ffULL,
0x0000000436377824ULL, 0x000fe200078e00ffULL, 0x00005f0019257a11ULL, 0x000fc400000f4428ULL,
0x00005f001b197a11ULL, 0x000fe400008f442aULL, 0x00005f00271b7a11ULL, 0x000fe200010f442cULL,
0x0000000134277824ULL, 0x000fe200078e026dULL, 0x00000028263a7810ULL, 0x040fe20007ffe0ffULL,
0x000000106f247825ULL, 0x000fe200078e0024ULL, 0x00000030263e7810ULL, 0x040fe40007ffe0ffULL,
0x0000003826427810ULL, 0x000fe20007ffe0ffULL, 0x000000013a2b7824ULL, 0x100fe200078e026dULL,
0x000000276c277210ULL, 0x000fe20007f3e0ffULL, 0x000000013e2d7824ULL, 0x100fe200078e026dULL,
0x000000312600720cULL, 0x000fe20003f06070ULL, 0x00000001426d7824ULL, 0x000fe200078e026dULL,
0x000000296c297210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff287224ULL, 0x000fe200008e06ffULL,
0x0000002b6c2b7210ULL, 0x000fe20007fbe0ffULL, 0x000000043a397824ULL, 0x000fe200078e00ffULL,
0x00005e0027267a11ULL, 0x040fe200078640ffULL, 0x000000ffff387224ULL, 0x000fe200020e06ffULL,
0x0000002d6c337210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff3c7224ULL, 0x000fe200028e06ffULL,
0x0000006d6c6d7210ULL, 0x000fe20007f3e0ffULL, 0x000000043e3b7824ULL, 0x000fe200078e00ffULL,
0x00005f0027277a11ULL, 0x000fe200018f4428ULL, 0x000000ffff407224ULL, 0x000fe200010e06ffULL,
0x00005e00292e7a11ULL, 0x000fe200078640ffULL, 0x000000ffff4c7224ULL, 0x000fe200008e06ffULL,
0x00005e002b2c7a11ULL, 0x000fe200078840ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000024717faeULL, 0x0003e2000c101c46ULL, 0x00005e00332a7a11ULL, 0x000fe200078240ffULL,
0x00000004423d7824ULL, 0x000fe200078e00ffULL, 0x00005e006d287a11ULL, 0x000fe200078440ffULL,
0x000000106f187825ULL, 0x000fe200078e0018ULL, 0x00005f00292f7a11ULL, 0x000fc400018f4438ULL,
0x00005f002b2d7a11ULL, 0x000fe200020f443cULL, 0x000000106f1a7825ULL, 0x000fe200078e001aULL,
0x00005f00332b7a11ULL, 0x000fe400008f4440ULL, 0x00005f006d297a11ULL, 0x000fe200010f444cULL,
0x0000000430337824ULL, 0x000fe200078e00ffULL, 0x000000313200720cULL, 0x080fe20003f06070ULL,
0x000000106f267825ULL, 0x040fe200078e0026ULL, 0x000000313000720cULL, 0x080fe40003f26070ULL,
0x000000313400720cULL, 0x080fe20003f46070ULL, 0x000000106f2e7825ULL, 0x000fe200078e002eULL,
0x000000313600720cULL, 0x000fc40003f66070ULL, 0x000000313a00720cULL, 0x080fe20003f86070ULL,
0x000000106f2c7825ULL, 0x040fe200078e002cULL, 0x000000313e00720cULL, 0x080fe40003fa6070ULL,
0x000000314200720cULL, 0x000fe20003fc6070ULL, 0x0000000432317824ULL, 0x000fe400078e00ffULL,
0x000000106f2a7825ULL, 0x000fc600078e002aULL, 0xfffffffc31257812ULL, 0x002fe200078ee264ULL,
0x000000106f287825ULL, 0x000fe200078e0028ULL, 0xfffffffc33317812ULL, 0x100fe400078ee264ULL,
0xfffffffc35337812ULL, 0x000fe200078ee264ULL, 0x0000001025257824ULL, 0x000fe200078e0270ULL,
0xfffffffc37357812ULL, 0x000fe200078ee264ULL, 0x0000001031317824ULL, 0x000fe200078e0270ULL,
0xfffffffc39377812ULL, 0x000fe200078ee264ULL, 0x0000001033337824ULL, 0x000fe200078e0270ULL,
0xfffffffc3b397812ULL, 0x000fe200078ee264ULL, 0x0000001035357824ULL, 0x000fe200078e0270ULL,
0xfffffffc3d3b7812ULL, 0x000fe200078ee264ULL, 0x0000001037377824ULL, 0x100fe200078e0270ULL,
0x0000000018257faeULL, 0x0003e2000c101c46ULL, 0x0000001039397824ULL, 0x000fc400078e0270ULL,
0x000000103b3b7824ULL, 0x000fe200078e0270ULL, 0x000000001a317faeULL, 0x0003e8000c901c46ULL,
0x0000000026337faeULL, 0x0003e8000d101c46ULL, 0x000000002e357faeULL, 0x0003e8000d901c46ULL,
0x000000002c377faeULL, 0x0003e8000e101c46ULL, 0x000000002a397faeULL, 0x0003e8000e901c46ULL,
0x00000000283b7faeULL, 0x0003e2000f101c46ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000000806247811ULL, 0x060fe200078ff0ffULL, 0x0000001071717824ULL, 0x000fe200078e0270ULL,
0x0000006d06197211ULL, 0x000fc400078ff0ffULL, 0x0000001006287811ULL, 0x000fe200078ff0ffULL,
0x00000001241b7824ULL, 0x100fe200078e026dULL, 0x000000196c197210ULL, 0x000fe20007f1e0ffULL,
0x0000000424317824ULL, 0x000fe200078e00ffULL, 0x00000018062a7811ULL, 0x000fe200078ff0ffULL,
0x0000000128257824ULL, 0x100fe200078e026dULL, 0x0000003006347811ULL, 0x000fe200078ff0ffULL,
0x000000ffff1a7224ULL, 0x000fe200000e06ffULL, 0x0000001b6c1b7210ULL, 0x000fe20007f7e0ffULL,
0x000000012a277824ULL, 0x100fe200078e026dULL, 0x00005e0019187a11ULL, 0x040fe200078040ffULL,
0x00000001342d7824ULL, 0x100fe200078e026dULL, 0x00000020062e7811ULL, 0x040fe200078ff0ffULL,
0x000000ffff267224ULL, 0x000fe200018e06ffULL, 0x0000002806327811ULL, 0x000fe200078ff0ffULL,
0x0000000428337824ULL, 0x000fe200078e00ffULL, 0x0000003806367811ULL, 0x000fe200078ff0ffULL,
0x000000012e297824ULL, 0x100fe200078e026dULL, 0x00005f0019197a11ULL, 0x000fe200000f441aULL,
0x00000001322b7824ULL, 0x100fe200078e026dULL, 0x000000256c257210ULL, 0x000fe20007f3e0ffULL,
0x00000001366d7824ULL, 0x000fe200078e026dULL, 0x000000276c2c7210ULL, 0x000fe20007f1e0ffULL,
0x000000042a357824ULL, 0x000fe200078e00ffULL, 0x00005e001b1a7a11ULL, 0x040fe200078c40ffULL,
0x000000ffff287224ULL, 0x000fe200008e06ffULL, 0x0000002d6c307210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff2d7224ULL, 0x000fe200000e06ffULL, 0x00005f001b1b7a11ULL, 0x000fe200030f4426ULL,
0x0000000432397824ULL, 0x000fe200078e00ffULL, 0x000000296c297210ULL, 0x000fe20007f5e0ffULL,
0x000000042e377824ULL, 0x000fe200078e00ffULL, 0x00005e0025267a11ULL, 0x040fe200078240ffULL,
0x00000004343b7824ULL, 0x000fe200078e00ffULL, 0x0000002b6c2b7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff327224ULL, 0x000fe200010e06ffULL, 0x00005e002c247a11ULL, 0x000fe200078040ffULL,
0x000000ffff3f7224ULL, 0x000fe200028e06ffULL, 0x0000006d6c6c7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff347224ULL, 0x000fe200018e06ffULL, 0x00005f0025277a11ULL, 0x000fe200008f4428ULL,
0x00000004363d7824ULL, 0x000fe200078e00ffULL, 0x00005f002c257a11ULL, 0x000fe200000f442dULL,
0x000000ffff417224ULL, 0x000fe200020e06ffULL, 0x0000000c6f6f7812ULL, 0x000fc400078efcffULL,
0x00005e00292e7a11ULL, 0x000fe400078040ffULL, 0xfffffffc31317812ULL, 0x000fe200078ee264ULL,
0x000000106f187825ULL, 0x000fe200078e0018ULL, 0x00005e002b2c7a11ULL, 0x000fe400078240ffULL,
0xfffffffc33337812ULL, 0x000fe200078ee264ULL, 0x0000001031317824ULL, 0x000fe200078e0270ULL,
0x00005e00302a7a11ULL, 0x000fe200078440ffULL, 0x000000106f1a7825ULL, 0x000fe200078e001aULL,
0xfffffffc35357812ULL, 0x000fe200078ee264ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018717faeULL, 0x0003e2000b901c46ULL, 0x00005e006c287a11ULL, 0x000fe200078640ffULL,
0x0000001033337824ULL, 0x000fe200078e0270ULL, 0xfffffffc37377812ULL, 0x000fe200078ee264ULL,
0x000000106f267825ULL, 0x000fe200078e0026ULL, 0x00005f00292f7a11ULL, 0x000fe200000f4432ULL,
0x000000001a317faeULL, 0x0003e2000b901c46ULL, 0xfffffffc39397812ULL, 0x000fe200078ee264ULL,
0x0000001035357824ULL, 0x000fe200078e0270ULL, 0x00005f002b2d7a11ULL, 0x000fe200008f4434ULL,
0x000000106f247825ULL, 0x000fe200078e0024ULL, 0xfffffffc3b3b7812ULL, 0x000fe200078ee264ULL,
0x0000000026337faeULL, 0x0003e2000b901c46ULL, 0x00005f00302b7a11ULL, 0x000fe200010f443fULL,
0x0000001037377824ULL, 0x000fe200078e0270ULL, 0xfffffffc3d3d7812ULL, 0x000fe200078ee264ULL,
0x000000106f2e7825ULL, 0x000fe200078e002eULL, 0x00005f006c297a11ULL, 0x000fe200018f4441ULL,
0x0000000024357faeULL, 0x0003e4000b901c46ULL, 0x0000001039397824ULL, 0x000fc400078e0270ULL,
0x000000106f2c7825ULL, 0x000fe200078e002cULL, 0x000000002e377faeULL, 0x0003e6000b901c46ULL,
0x000000103b3b7824ULL, 0x000fe200078e0270ULL, 0x000000002c397faeULL, 0x0003e2000b901c46ULL,
0x000000106f2a7825ULL, 0x000fc800078e002aULL, 0x000000103d3d7824ULL, 0x000fe200078e0270ULL,
0x000000002a3b7faeULL, 0x0003e2000b901c46ULL, 0x000000106f287825ULL, 0x000fca00078e0028ULL,
0x00000000283d7faeULL, 0x0003e4000b901c46ULL, 0x00000300ff197624ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff6d7424ULL, 0x000fe400078e00ffULL,
0x0000000219047824ULL, 0x000fca00078e0204ULL, 0x000000590400720cULL, 0x000fda0003f06070ULL,
0x0000000255248824ULL, 0x000fe400078e0204ULL, 0x00000004ff258424ULL, 0x000fe200078e00ffULL,
0x0000000854187810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000600024248625ULL, 0x000fe200078e0025ULL, 0x00000000693c783bULL, 0x000fe80000000200ULL,
0x00000006246d8981ULL, 0x0002a2000c1e1900ULL, 0x0000001052197824ULL, 0x000fc600078e00ffULL,
0x000000006b4c783bULL, 0x000fe40000000200ULL, 0xfffffff019187812ULL, 0x000fe400078ee218ULL,
0x000000006a40783bULL, 0x000fe20000000200ULL, 0x0000001052257824ULL, 0x002fe200078e00ffULL,
0x0000000a54247810ULL, 0x000fe20007ffe0ffULL, 0x0000001018387824ULL, 0x000fe200078e00ffULL,
0x000000006528783bULL, 0x000fe40000000200ULL, 0xfffffff025247812ULL, 0x000fc400078ee224ULL,
0x000000006e18783bULL, 0x000fe60000000200ULL, 0x0000001024247824ULL, 0x000fe200078e00ffULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000006834783bULL, 0x000fe80000000200ULL,
0x000000002424783bULL, 0x000ee80000000200ULL, 0x000000006730783bULL, 0x000f280000000200ULL,
0x00000000662c783bULL, 0x000ee20000000200ULL, 0x0000003c3814723cULL, 0x042f700000001814ULL,
0x00000018381c723cULL, 0x040f70000000181cULL, 0x0000001a3848723cULL, 0x040f700000001848ULL,
0x0000004c3844723cULL, 0x040b6e0000001844ULL, 0x000003005c4c7a10ULL, 0x020fe20007ffe0ffULL,
0x0000004e3808723cULL, 0x000f660000001808ULL, 0x000000014c187810ULL, 0x000fc80007ffe0ffULL,
0x000000531800720cULL, 0x000fe20003f06070ULL, 0x00000040380c723cULL, 0x040f70000000180cULL,
0x000000423810723cULL, 0x040f700000001810ULL, 0x0000003e3820723cULL, 0x000f700000001820ULL,
0x000000282414723cULL, 0x048b6e0000001814ULL, 0x000001004c287824ULL, 0x020fe200078e0205ULL,
0x00000034241c723cULL, 0x000b68000000181cULL, 0x0000004028187812ULL, 0x000fc800078ec0ffULL,
0x000000362448723cULL, 0x000b620000001848ULL, 0x0000000103297824ULL, 0x000fce00078e0218ULL,
0x000000302444723cULL, 0x050b700000001844ULL, 0x000000322408723cULL, 0x040b700000001808ULL,
0x0000002c240c723cULL, 0x040b70000000180cULL, 0x0000002e2410723cULL, 0x040b700000001810ULL,
0x0000002a2420723cULL, 0x000b620000001820ULL, 0x000000026d187224ULL, 0x004fe200078e02ffULL,
0x000006d000008947ULL, 0x000fcc0003800000ULL, 0x00000002ff2f7819ULL, 0x020fe20000011606ULL,
0x0000001006317824ULL, 0x000fe200078e00ffULL, 0x0000002858197217ULL, 0x000fc40007800000ULL,
0x000000082f327810ULL, 0x040fe20007ffe0ffULL, 0x000000012f1b7824ULL, 0x140fe200078e0229ULL,
0x000000102f337810ULL, 0x000fe20007ffe0ffULL, 0x0000000119287824ULL, 0x000fe200078e0a28ULL,
0x000000182f347810ULL, 0x000fe20007ffe0ffULL, 0x0000000132197824ULL, 0x100fe200078e0229ULL,
0x0000001b182d7210ULL, 0x000fe20007f1e0ffULL, 0x00000001331b7824ULL, 0x100fe400078e0229ULL,
0x0000000134257824ULL, 0x000fe200078e0229ULL, 0x0000001918197210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff1a7224ULL, 0x000fe200000e06ffULL, 0x00005e002d307a11ULL, 0x000fc400078040ffULL,
0x0000001b181b7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff2e7224ULL, 0x000fe200008e06ffULL,
0x0000002518257210ULL, 0x000fe40007f7e0ffULL, 0x00005f002d2d7a11ULL, 0x000fe200000f441aULL,
0x000000ffff1a7224ULL, 0x000fe200010e06ffULL, 0x00005e0019247a11ULL, 0x000fe200078040ffULL,
0x000000ffff2c7224ULL, 0x000fe200018e06ffULL, 0x00005e001b267a11ULL, 0x000fe400078240ffULL,
0x00005e00252a7a11ULL, 0x000fc400078440ffULL, 0x00005f00192b7a11ULL, 0x000fe400000f442eULL,
0x0000003031197812ULL, 0x000fe200078ec0ffULL, 0x0000000433317824ULL, 0x000fe200078e00ffULL,
0x000000282f00720cULL, 0x000fe40003f06070ULL, 0x00005f001b277a11ULL, 0x000fe400008f441aULL,
0x00005f00252c7a11ULL, 0x000fe200010f442cULL, 0x0000000432257824ULL, 0x000fe200078e00ffULL,
0x00000019301a7210ULL, 0x000fc40007f7e0ffULL, 0x000000283200720cULL, 0x080fe40003f26070ULL,
0xfffffffc25257812ULL, 0x000fe200078ee264ULL, 0x000000ffff1b7224ULL, 0x000fe200018e062dULL,
0x0000001924247210ULL, 0x080fe40007f7e0ffULL, 0x000000202f2e7810ULL, 0x000fe20007ffe0ffULL,
0x00000010252d7824ULL, 0x000fe200078e0256ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a637faeULL, 0x0003e2000c101c46ULL, 0x000000ffff257224ULL, 0x000fe200018e062bULL,
0x000000283300720cULL, 0x000fe20003f46070ULL, 0x000000012e2b7824ULL, 0x000fe200078e0229ULL,
0x0000001926267210ULL, 0x000fc40007f9e0ffULL, 0xfffffffc31317812ULL, 0x000fe200078ee264ULL,
0x00000000242d7faeULL, 0x0005e2000c901c46ULL, 0x000000282f307810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff277224ULL, 0x000fe200020e0627ULL, 0x000000283400720cULL, 0x0c0fe20003f86070ULL,
0x0000001031317824ULL, 0x000fe200078e0256ULL, 0x000000302f327810ULL, 0x040fe20007ffe0ffULL,
0x00000004341b7824ULL, 0x002fe200078e00ffULL, 0x0000002b182b7210ULL, 0x000fe20007f1e0ffULL,
0x0000000430337824ULL, 0x000fe200078e00ffULL, 0x000000192a1a7210ULL, 0x000fe20007fbe0ffULL,
0x0000000026317faeULL, 0x0003e2000d101c46ULL, 0x000000382f2f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff247224ULL, 0x004fe200000e06ffULL, 0xfffffffc1b257812ULL, 0x000fe200078ee264ULL,
0x000000ffff1b7224ULL, 0x000fe200028e062cULL, 0x000000282e00720cULL, 0x080fe20003f66070ULL,
0x000000042f377824ULL, 0x000fe200078e00ffULL, 0x000000283000720cULL, 0x080fe20003f46070ULL,
0x00000010252d7824ULL, 0x000fe200078e0256ULL, 0x000000283200720cULL, 0x080fe20003f26070ULL,
0x0000000130257824ULL, 0x100fe200078e0229ULL, 0x000000282f00720cULL, 0x000fe20003f06070ULL,
0x0000000132277824ULL, 0x102fe200078e0229ULL, 0x00005e002b267a11ULL, 0x000fe200078c40ffULL,
0x000000012f297824ULL, 0x000fe200078e0229ULL, 0x0000002518257210ULL, 0x000fe20007fbe0ffULL,
0x000000001a2d7faeULL, 0x0003e2000e101c46ULL, 0x00005f002b2b7a11ULL, 0x000fe200030f4424ULL,
0x000000042e317824ULL, 0x000fe200078e00ffULL, 0x0000002718277210ULL, 0x000fe20007f9e0ffULL,
0x0000000432357824ULL, 0x000fe200078e00ffULL, 0x0000002918297210ULL, 0x000fe20007fde0ffULL,
0x000000ffff187224ULL, 0x000fe200028e06ffULL, 0x00005e0025247a11ULL, 0x000fe200078a40ffULL,
0x000000ffff2a7224ULL, 0x000fe200020e06ffULL, 0xfffffffc312f7812ULL, 0x000fe200078ee264ULL,
0x000000ffff287224ULL, 0x000fe200030e06ffULL, 0x00005f0025257a11ULL, 0x000fc400028f4418ULL,
0xfffffffc371b7812ULL, 0x002fe200078ee264ULL, 0x000000102f2f7824ULL, 0x100fe200078e0256ULL,
0x00000019261a7210ULL, 0x080fe40007fbe0ffULL, 0x00005e0027187a11ULL, 0x000fe200078840ffULL,
0x000000101b2d7824ULL, 0x000fe200078e0256ULL, 0x00005e0029267a11ULL, 0x000fe200078c40ffULL,
0x000000ffff1b7224ULL, 0x000fe200028e062bULL, 0x0000001924247210ULL, 0x000fe40007fbe0ffULL,
0xfffffffc33317812ULL, 0x000fc400078ee264ULL, 0x00005f00272a7a11ULL, 0x000fe200020f442aULL,
0x000000ffff257224ULL, 0x000fe200028e0625ULL, 0xfffffffc35337812ULL, 0x000fe200078ee264ULL,
0x0000001031317824ULL, 0x000fe200078e0256ULL, 0x0000001918187210ULL, 0x080fe20007f9e0ffULL,
0x000000001a2f7faeULL, 0x0003e2000d901c46ULL, 0x00005f0029277a11ULL, 0x000fe200030f4428ULL,
0x0000001033337824ULL, 0x000fe200078e0256ULL, 0x0000001926267210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff197224ULL, 0x000fe200020e062aULL, 0x0000000024317faeULL, 0x0003e6000d101c46ULL,
0x000000ffff277224ULL, 0x000fe200028e0627ULL, 0x0000000018337faeULL, 0x0003e8000c901c46ULL,
0x00000000262d7faeULL, 0x0003e2000c101c46ULL, 0x0000061000007947ULL, 0x000fea0003800000ULL,
0x0000002906197211ULL, 0x060fe400078ff0ffULL, 0x00000008061a7811ULL, 0x000fc400078ff0ffULL,
0x0000001006247811ULL, 0x040fe400078ff0ffULL, 0x0000001806267811ULL, 0x000fe200078ff0ffULL,
0x000000041a357824ULL, 0x000fe200078e00ffULL, 0x0000002006287811ULL, 0x000fe200078ff0ffULL,
0x00000001241b7824ULL, 0x100fe200078e0229ULL, 0x00000028062a7811ULL, 0x000fe200078ff0ffULL,
0x0000000126257824ULL, 0x100fe200078e0229ULL, 0x00000030062c7811ULL, 0x000fe200078ff0ffULL,
0x0000000128277824ULL, 0x100fe200078e0229ULL, 0x0000001918367210ULL, 0x000fe20007f1e0ffULL,
0x000000011a197824ULL, 0x100fe200078e0229ULL, 0x00000038062e7811ULL, 0x000fe200078ff0ffULL,
0x000000012a2b7824ULL, 0x100fe200078e0229ULL, 0xfffffffc35357812ULL, 0x000fe200078ee264ULL,
0x000000012c2d7824ULL, 0x100fe200078e0229ULL, 0x0000001918197210ULL, 0x000fe20007fde0ffULL,
0x000000ffff317224ULL, 0x000fe200000e06ffULL, 0x00005e00362f7a11ULL, 0x000fe200078040ffULL,
0x000000012e297824ULL, 0x000fe200078e0229ULL, 0x0000001b18337210ULL, 0x000fe20007fbe0ffULL,
0x0000001035377824ULL, 0x000fe200078e0256ULL, 0x00005f0036367a11ULL, 0x000fe200000f4431ULL,
0x00000004283d7824ULL, 0x000fe200078e00ffULL, 0x0000002518257210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff1a7224ULL, 0x000fe200028e06ffULL, 0x0000002718277210ULL, 0x000fe20007f3e0ffULL,
0x0000000424397824ULL, 0x000fe200078e00ffULL, 0x0000002b182b7210ULL, 0x000fe20007f5e0ffULL,
0x000000042e437824ULL, 0x000fe200078e00ffULL, 0x0000002d182d7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff307224ULL, 0x000fe200008e06ffULL, 0x0000002918297210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff187224ULL, 0x000fe200030e06ffULL, 0x00005e0019347a11ULL, 0x000fe200078c40ffULL,
0x000000ffff247224ULL, 0x000fe200018e06ffULL, 0x00005e0033327a11ULL, 0x000fe200078a40ffULL,
0x00000004263b7824ULL, 0x000fe200078e00ffULL, 0x00005f0019357a11ULL, 0x000fe200030f4418ULL,
0x000000ffff187224ULL, 0x000fe200000e06ffULL, 0x00005e00251b7a11ULL, 0x000fe200078040ffULL,
0x0000001006197824ULL, 0x000fe200078e00ffULL, 0x00005e0027287a11ULL, 0x000fe200078240ffULL,
0x000000042a3f7824ULL, 0x000fe200078e00ffULL, 0x00005f0025317a11ULL, 0x000fe200000f4418ULL,
0x000000042c417824ULL, 0x000fe200078e00ffULL, 0x0000003019257812ULL, 0x000fe200078ec0ffULL,
0x000000ffff267224ULL, 0x000fe200010e06ffULL, 0x00005f0033337a11ULL, 0x000fe200028f441aULL,
0x000000ffff1a7224ULL, 0x000fe200020e06ffULL, 0x000000252f187210ULL, 0x000fc40007f1e0ffULL,
0x00005e00292e7a11ULL, 0x000fe400078640ffULL, 0x00005f0027307a11ULL, 0x000fe200008f4430ULL,
0x000000ffff197224ULL, 0x000fe200000e0636ULL, 0x00005e002b2a7a11ULL, 0x000fe400078240ffULL,
0x00005e002d2c7a11ULL, 0x000fe400078440ffULL, 0x00005f00292f7a11ULL, 0x000fe200018f441aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018637faeULL, 0x0003e2000b901c46ULL,
0x00000025341a7210ULL, 0x000fc40007f1e0ffULL, 0x00005f002b2b7a11ULL, 0x000fe400008f4426ULL,
0x00005f002d2d7a11ULL, 0x000fe400010f4424ULL, 0xfffffffc39397812ULL, 0x100fe400078ee264ULL,
0x0000002532247210ULL, 0x080fe40007f3e0ffULL, 0xfffffffc3b3b7812ULL, 0x000fe200078ee264ULL,
0x0000001039397824ULL, 0x000fe200078e0256ULL, 0x000000251b267210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200000e0635ULL, 0xfffffffc3d3d7812ULL, 0x000fe200078ee264ULL,
0x000000103b3b7824ULL, 0x000fe200078e0256ULL, 0x0000002528287210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff277224ULL, 0x000fe200010e0631ULL, 0xfffffffc3f3f7812ULL, 0x000fe200078ee264ULL,
0x000000103d3d7824ULL, 0x000fe200078e0256ULL, 0x000000252a2a7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff297224ULL, 0x000fe200018e0630ULL, 0xfffffffc41417812ULL, 0x000fe200078ee264ULL,
0x000000103f3f7824ULL, 0x000fe200078e0256ULL, 0x000000252c2c7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff2b7224ULL, 0x000fe200020e062bULL, 0x000000252e2e7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff257224ULL, 0x000fe200008e0633ULL, 0xfffffffc43437812ULL, 0x000fe200078ee264ULL,
0x0000001041417824ULL, 0x000fe200078e0256ULL, 0x000000001a377faeULL, 0x0003e2000b901c46ULL,
0x000000ffff2d7224ULL, 0x000fc400028e062dULL, 0x0000001043437824ULL, 0x000fe200078e0256ULL,
0x0000000024397faeULL, 0x0003e2000b901c46ULL, 0x000000ffff2f7224ULL, 0x000fc600000e062fULL,
0x00000000263b7faeULL, 0x0003e8000b901c46ULL, 0x00000000283d7faeULL, 0x0003e8000b901c46ULL,
0x000000002a3f7faeULL, 0x0003e8000b901c46ULL, 0x000000002c417faeULL, 0x0003e8000b901c46ULL,
0x000000002e437faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001052197824ULL, 0x002fe200078e00ffULL, 0x0000000c54187810ULL, 0x000fc40007ffe0ffULL,
0x0000000e54547810ULL, 0x000fe40007ffe0ffULL, 0xfffffff019187812ULL, 0x040fe400078ee218ULL,
0xfffffff019547812ULL, 0x000fc600078ee254ULL, 0x0000001018287824ULL, 0x000fe400078e00ffULL,
0x0000001054187824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000006238783bULL, 0x000fe80000000200ULL, 0x000000002828783bULL, 0x000e680000000200ULL,
0x000000006134783bULL, 0x000ea80000000200ULL, 0x000000006030783bULL, 0x000ee80000000200ULL,
0x000000005f2c783bULL, 0x000f280000000200ULL, 0x000000005e24783bULL, 0x000fe80000000200ULL,
0x000000001818783bULL, 0x000ee80000000200ULL, 0x000000005d3c783bULL, 0x000ee80000000200ULL,
0x000000005740783bULL, 0x000fe20000000200ULL, 0x00000038281c723cULL, 0x042f70000000181cULL,
0x0000003a2848723cULL, 0x040be40000001848ULL, 0x000000005b38783bULL, 0x020e6c0000000200ULL,
0x000000362808723cULL, 0x044f700000001808ULL, 0x000000342844723cULL, 0x040f700000001844ULL,
0x00000030280c723cULL, 0x048ff0000000180cULL, 0x000000322810723cULL, 0x040ff00000001810ULL,
0x0000002c2814723cULL, 0x050ff00000001814ULL, 0x0000002e2820723cULL, 0x000ff00000001820ULL,
0x00000024181c723cULL, 0x040f70000000181cULL, 0x0000003e1808723cULL, 0x060f700000001808ULL,
0x000000261848723cULL, 0x040f700000001848ULL, 0x0000003c1844723cULL, 0x000f620000001844ULL,
0x3db504f31e247820ULL, 0x000fe20000410000ULL, 0x3db504f31f257820ULL, 0x000fe20000410000ULL,
0x3db504f31c1c7820ULL, 0x000fe20000410000ULL, 0x3db504f31d1d7820ULL, 0x000fc80000410000ULL,
0x00000038180c723cULL, 0x002f64000000180cULL, 0x3db504f30a2b7820ULL, 0x020fe20000410000ULL,
0x3db504f30b2c7820ULL, 0x000fe20000410000ULL, 0x3db504f308087820ULL, 0x000fe20000410000ULL,
0x3db504f309097820ULL, 0x000fc60000410000ULL, 0x0000003a1810723cULL, 0x000f620000001810ULL,
0x3db504f348487820ULL, 0x000fe20000410000ULL, 0x3db504f349497820ULL, 0x000fe20000410000ULL,
0x3db504f34a267820ULL, 0x000fe20000410000ULL, 0x3db504f34b277820ULL, 0x000fc80000410000ULL,
0x000000401814723cULL, 0x000f620000001814ULL, 0x3db504f344447820ULL, 0x000fe20000410000ULL,
0x3db504f345457820ULL, 0x000fe20000410000ULL, 0x3db504f346297820ULL, 0x000fe20000410000ULL,
0x3db504f3472a7820ULL, 0x000fc80000410000ULL, 0x000000421820723cULL, 0x000b620000001820ULL,
0x3db504f30c0a7820ULL, 0x000fe20000410000ULL, 0x3db504f30d0b7820ULL, 0x000fe20000410000ULL,
0x3db504f30e2d7820ULL, 0x000fe20000410000ULL, 0x3db504f30f287820ULL, 0x000fc80000410000ULL,
0x3db504f310187820ULL, 0x020fe20000410000ULL, 0x3db504f311197820ULL, 0x000fe20000410000ULL,
0x3db504f3122e7820ULL, 0x000fe20000410000ULL, 0x3db504f3132f7820ULL, 0x000fca0000410000ULL,
0x3db504f3141a7820ULL, 0x000fe20000410000ULL, 0x3db504f3151b7820ULL, 0x000fe20000410000ULL,
0x3db504f316307820ULL, 0x000fe20000410000ULL, 0x3db504f317317820ULL, 0x000fca0000410000ULL,
0x3db504f3201e7820ULL, 0x000fe20000410000ULL, 0x3db504f3211f7820ULL, 0x000fe20000410000ULL,
0x3db504f322227820ULL, 0x000fe20000410000ULL, 0x3db504f323327820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ffff127224ULL, 0x000fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e0009ULL, 0x0000000050087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff167224ULL, 0x000fe400078e0018ULL, 0x000000ffff177224ULL, 0x000fc400078e0019ULL,
0x000000ffff207224ULL, 0x000fe400078e0024ULL, 0x000000ffff237224ULL, 0x000fe400078e0025ULL,
0x000000ffff0d7224ULL, 0x000fe400078e001cULL, 0x000000ffff0c7224ULL, 0x000fe400078e001dULL,
0x000000ffff0e7224ULL, 0x000fe400078e0048ULL, 0x000000ffff0f7224ULL, 0x000fc400078e0049ULL,
0x000000ffff107224ULL, 0x000fe400078e0044ULL, 0x000000ffff117224ULL, 0x000fe400078e0045ULL,
0x000000ffff147224ULL, 0x000fe400078e000aULL, 0x000000ffff157224ULL, 0x000fe400078e000bULL,
0x000000ffff217224ULL, 0x000fe400078e002eULL, 0x000000ffff247224ULL, 0x000fc400078e002fULL,
0x000000ffff187224ULL, 0x000fe400078e0030ULL, 0x000000ffff197224ULL, 0x000fe400078e0031ULL,
0x000000ffff257224ULL, 0x000fc400078e0032ULL, 0x00000000000a7805ULL, 0x006fca0000015200ULL,
0x00000400501d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c0a2f7210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e0bULL, 0x003d09002f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1c7819ULL, 0x000fc8000001141dULL,
0x0000002f1c1c7211ULL, 0x000fca00078110ffULL, 0x000000ffff1d7224ULL, 0x000fca00000e061dULL,
0x000000021c1c7819ULL, 0x000fc8000000121dULL, 0x0000001c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400501d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004061d7824ULL, 0x000fe200078e00ffULL, 0x000000515c00720cULL, 0x000fc80003f05270ULL,
0xfffffff01d097812ULL, 0x000fca00078ec0ffULL, 0x000000805a1c7824ULL, 0x000fca00078e0209ULL,
0x013400001c087984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x00000002062e7824ULL, 0x000fe400078e00ffULL, 0x0000000158327824ULL, 0x000fc600078e0a07ULL,
0x000000062e2e7812ULL, 0x000fc800078ec0ffULL, 0x000000012e077812ULL, 0x040fe400078efcffULL,
0x000000082e2f7812ULL, 0x040fe400078efcffULL, 0x000000320700720cULL, 0x080fe40003f26070ULL,
0x000000102e077812ULL, 0x000fe400078efcffULL, 0x000000322f00720cULL, 0x080fe40003f06070ULL,
0x000000320700720cULL, 0x000fc40003fc6070ULL, 0x000000112e2f7812ULL, 0x040fe400078efcffULL,
0x000000182e077812ULL, 0x040fe400078efcffULL, 0x000000322e00720cULL, 0x0c0fe40003f46070ULL,
0x000000322f00720cULL, 0x080fe40003fa6070ULL, 0x000000320700720cULL, 0x000fe40003f66070ULL,
0x000000092e307812ULL, 0x000fc400078efcffULL, 0x000000192e2f7812ULL, 0x040fe400078efcffULL,
0x000000202e077812ULL, 0x000fe400078efcffULL, 0xff80000020207808ULL, 0x000fe40005000000ULL,
0xff8000000d0d7808ULL, 0x000fe40005000000ULL, 0xff80000023237808ULL, 0x000fe40004800000ULL,
0xff8000000c0c7808ULL, 0x000fc40004800000ULL, 0x000000323000720cULL, 0x080fe40003f86070ULL,
0x000000322f00720cULL, 0x080fe40003f46070ULL, 0x000000320700720cULL, 0x000fe40003f26070ULL,
0x000000212e2f7812ULL, 0x040fe400078efcffULL, 0x000000282e077812ULL, 0x000fe400078efcffULL,
0xff80000026267808ULL, 0x000fc40004000000ULL, 0xff8000000e0e7808ULL, 0x000fe40004000000ULL,
0xff80000027277808ULL, 0x000fe40006000000ULL, 0xff8000000f0f7808ULL, 0x000fe40006000000ULL,
0x000000322f00720cULL, 0x080fe40003f06070ULL, 0x000000320700720cULL, 0x000fe40003f86070ULL,
0x000000292e2f7812ULL, 0x000fc400078efcffULL, 0x000000302e077812ULL, 0x000fe400078efcffULL,
0xff80000029297808ULL, 0x000fe40007000000ULL, 0xff80000010107808ULL, 0x000fe40007000000ULL,
0xff8000002a2a7808ULL, 0x000fe40006800000ULL, 0xff80000011117808ULL, 0x000fe40006800000ULL,
0x000000322f00720cULL, 0x000fc40003fc6070ULL, 0x000000320700720cULL, 0x000fe40003fa6070ULL,
0x000000312e2f7812ULL, 0x040fe400078efcffULL, 0x000000382e077812ULL, 0x040fe400078efcffULL,
0x000000392e2e7812ULL, 0x000fe400078efcffULL, 0xff8000002b2b7808ULL, 0x000fe40005800000ULL,
0xff80000012127808ULL, 0x000fc40005800000ULL, 0xff8000002c2c7808ULL, 0x000fe40005000000ULL,
0xff80000013137808ULL, 0x000fe40005000000ULL, 0xff8000002d2d7808ULL, 0x000fe40004800000ULL,
0xff80000014147808ULL, 0x000fe40004800000ULL, 0x000000322f00720cULL, 0x080fe40003f66070ULL,
0x000000320700720cULL, 0x000fc40003f46070ULL, 0x000000322e00720cULL, 0x000fe40003f26070ULL,
0xff80000028287808ULL, 0x000fe40004000000ULL, 0xff80000015157808ULL, 0x000fe40004000000ULL,
0xff80000021217808ULL, 0x000fe40006000000ULL, 0xff80000016167808ULL, 0x000fe40006000000ULL,
0xff80000024247808ULL, 0x000fc40007000000ULL, 0xff80000017177808ULL, 0x000fe40007000000ULL,
0xff80000018187808ULL, 0x000fe40006800000ULL, 0xff8000001a1a7808ULL, 0x000fe40006800000ULL,
0xff80000019197808ULL, 0x000fe40005800000ULL, 0xff8000001b1b7808ULL, 0x000fe40005800000ULL,
0xff80000022227808ULL, 0x000fc40005000000ULL, 0xff8000001e1e7808ULL, 0x000fe40005000000ULL,
0xff80000025257808ULL, 0x000fe40004800000ULL, 0xff8000001f1f7808ULL, 0x000fc40004800000ULL,
0x0000000d0800720bULL, 0x004fe20003f1e000ULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x000000200900720bULL, 0x000fe20003f3e000ULL, 0xffffffffff367424ULL, 0x000fe200078e00ffULL,
0x000000080d077208ULL, 0x000fe40004000000ULL, 0x0000000920087208ULL, 0x000fc40004800000ULL,
0x0000000c0700720bULL, 0x000fe40003f1e000ULL, 0x000000230800720bULL, 0x000fe40003f3e000ULL,
0x000000070c077208ULL, 0x000fe40004000000ULL, 0x0000000823097208ULL, 0x000fe40004800000ULL,
0x0000000e0700720bULL, 0x000fe40003f1e000ULL, 0x000000260900720bULL, 0x000fc40003f3e000ULL,
0x000000070e087208ULL, 0x000fe40004000000ULL, 0x00000009262e7208ULL, 0x000fe40004800000ULL,
0x0000000f0800720bULL, 0x000fe40003f1e000ULL, 0x000000272e00720bULL, 0x000fe40003f3e000ULL,
0x000000080f077208ULL, 0x000fe40004000000ULL, 0x0000002e272e7208ULL, 0x000fc40004800000ULL,
0x000000100700720bULL, 0x000fe40003f1e000ULL, 0x000000292e00720bULL, 0x000fe40003f3e000ULL,
0x0000000710087208ULL, 0x000fe40004000000ULL, 0x0000002e29077208ULL, 0x000fe40004800000ULL,
0x000000110800720bULL, 0x000fe40003f1e000ULL, 0x0000002a0700720bULL, 0x000fc40003f3e000ULL,
0x0000000811097208ULL, 0x000fe40004000000ULL, 0x000000072a087208ULL, 0x000fe40004800000ULL,
0x000000120900720bULL, 0x000fe40003f1e000ULL, 0x0000002b0800720bULL, 0x000fe40003f3e000ULL,
0x00000009122e7208ULL, 0x000fe40004000000ULL, 0x000000082b077208ULL, 0x000fc40004800000ULL,
0x000000132e00720bULL, 0x000fe40003f1e000ULL, 0x0000002c0700720bULL, 0x000fe40003f3e000ULL,
0x0000002e13097208ULL, 0x000fe40004000000ULL, 0x000000072c087208ULL, 0x000fe40004800000ULL,
0x000000140900720bULL, 0x000fe40003f1e000ULL, 0x0000002d0800720bULL, 0x000fc40003f3e000ULL,
0x00000009142e7208ULL, 0x000fe40004000000ULL, 0x000000082d077208ULL, 0x000fe40004800000ULL,
0x000000152e00720bULL, 0x000fe40003f1e000ULL, 0x000000280700720bULL, 0x000fe40003f3e000ULL,
0x0000002e15097208ULL, 0x000fe40004000000ULL, 0x0000000728087208ULL, 0x000fc40004800000ULL,
0x000000160900720bULL, 0x000fe40003f1e000ULL, 0x000000210800720bULL, 0x000fe40003f3e000ULL,
0x00000009162e7208ULL, 0x000fe40004000000ULL, 0x0000000821077208ULL, 0x000fe40004800000ULL,
0x000000172e00720bULL, 0x000fe40003f1e000ULL, 0x000000240700720bULL, 0x000fc40003f3e000ULL,
0x0000002e17097208ULL, 0x000fe40004000000ULL, 0x0000000724077208ULL, 0x000fe40004800000ULL,
0x0000001a0900720bULL, 0x000fe40003f1e000ULL, 0x000000180700720bULL, 0x000fe40003f3e000ULL,
0x000000091a087208ULL, 0x000fe40004000000ULL, 0x00000007182e7208ULL, 0x000fc40004800000ULL,
0x0000001b0800720bULL, 0x000fe40003f1e000ULL, 0x000000192e00720bULL, 0x000fe40003f3e000ULL,
0x000000081b077208ULL, 0x000fe40004000000ULL, 0x0000002e19097208ULL, 0x000fe40004800000ULL,
0x0000001e0700720bULL, 0x000fe40003f1e000ULL, 0x000000220900720bULL, 0x000fc40003f3e000ULL,
0x000000071e087208ULL, 0x000fe40004000000ULL, 0x00000009222e7208ULL, 0x000fe40004800000ULL,
0x0000001f0800720bULL, 0x000fe40003f1e000ULL, 0x000000252e00720bULL, 0x000fe40003f3e000ULL,
0x000000081f317208ULL, 0x000fe40004000000ULL, 0x0000002e25337208ULL, 0x000fe20004800000ULL,
0x000014d27f007947ULL, 0x000fec000b800000ULL, 0x0c401f0031077f89ULL, 0x0004e400000e0000ULL,
0x000000073100720bULL, 0x008fc80003f1e000ULL, 0x0000003107347208ULL, 0x000fe20004000000ULL,
0x000014e27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0033077f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a097f89ULL, 0x000f2800000e0000ULL, 0x0c401f000b087f89ULL, 0x000e6200000e0000ULL,
0x000000073300720bULL, 0x008fc40003f1e000ULL, 0x000000090a00720bULL, 0x010fe40003f3e000ULL,
0x00000033072f7208ULL, 0x000fe40004000000ULL, 0x0000000a09307208ULL, 0x000fe40004800000ULL,
0x0c201f0034097f89ULL, 0x000ee200000e0000ULL, 0x000000080b00720bULL, 0x002fc60003f1e000ULL,
0x0c201f002f327f89ULL, 0x000e6200000e0000ULL, 0x0000000b08077208ULL, 0x000fc60004000000ULL,
0x0c201f0030317f89ULL, 0x004ea800000e0000ULL, 0x0c201f00072e7f89ULL, 0x0002a200000e0000ULL,
0x000000093400720bULL, 0x008fe40003f1e000ULL, 0x000000322f00720bULL, 0x002fe40003f3e000ULL,
0x0000003409087208ULL, 0x000fe40004000000ULL, 0x000000313000720bULL, 0x004fc40003f5e000ULL,
0x0000002f32097208ULL, 0x000fe40004800000ULL, 0x00000030310a7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b08327820ULL, 0x002fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000306ff7812ULL, 0x000fe4000780c0ffULL, 0x3fb8aa3b1a0b7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b091a7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b0f0f7823ULL, 0x000fe20000010832ULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b27277823ULL, 0x000fe2000001081aULL, 0x0000000d000d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b14317823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b15347823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b16337823ULL, 0x100fe20000010832ULL, 0x0000000c000c7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b17367823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b1b307823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b1e2f7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b1f327823ULL, 0x000fe20000010832ULL,
0x3c003c00ff1e7424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001081aULL,
0x3c003c00ff1f7424ULL, 0x000fe200078e00ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001081aULL, 0x0000000f000f7308ULL, 0x000ea20000000800ULL,
0x0000000d0c0c723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b22227823ULL, 0x000fe2000001081aULL,
0x0000002e0700720bULL, 0x000fca0003f3e000ULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x0000000e0f0e723eULL, 0x004fce00000000ffULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0x00000020230d723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b18207823ULL, 0x000fcc000001081aULL,
0x0000001000107308ULL, 0x000fe20000000800ULL, 0x00000026270f723eULL, 0x004fce00000000ffULL,
0x0000001100117308ULL, 0x000e620000000800ULL, 0x3fb8aa3b19267823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b25277823ULL, 0x000fe2000001081aULL, 0x0000001e0c14723cULL, 0x000f6a00000018ffULL,
0x0000001200127308ULL, 0x000ff00000000800ULL, 0x0000001300137308ULL, 0x000ea20000000800ULL,
0x000000101110723eULL, 0x002fce00000000ffULL, 0x0000002900297308ULL, 0x000ff00000000800ULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0x000000121312723eULL, 0x004fce00000000ffULL,
0x0000002b002b7308ULL, 0x000ff00000000800ULL, 0x0000002c002c7308ULL, 0x000ea20000000800ULL,
0x000000292a11723eULL, 0x002fe400000000ffULL, 0x00000002ff297819ULL, 0x000fc80000011606ULL,
0x0000000129257810ULL, 0x040fe20007ffe0ffULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0x00000008293c7824ULL, 0x040fe400078e00ffULL, 0x00000008292a7824ULL, 0x040fe400078e00ffULL,
0x0000000829387824ULL, 0x040fe400078e00ffULL, 0x00000008293e7824ULL, 0x000fe200078e00ffULL,
0x0000002b2c13723eULL, 0x004fe200000000ffULL, 0x0000003400347308ULL, 0x000e620000000800ULL,
0xfffffff82a2a7812ULL, 0x000fc400078ee225ULL, 0x00000002292b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000c1d2c7812ULL, 0x000fe200078ec0ffULL, 0x0000001e1018723cULL, 0x020b620000001814ULL,
0xfffffff838387812ULL, 0x000fe200078ee22bULL, 0x0000003300337308ULL, 0x000fe20000000800ULL,
0xffffffff292b7810ULL, 0x000fc80007ffe0ffULL, 0x0000000829177824ULL, 0x060fe200078e00ffULL,
0x0000000329147810ULL, 0x040fe40007ffe0ffULL, 0x0000003600367308ULL, 0x000ea20000000800ULL,
0x0000000429157810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8173a7812ULL, 0x000fe400078ee214ULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee215ULL, 0x000000313414723eULL, 0x002fe200000000ffULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0xfffffff83e3e7812ULL, 0x000fce00078ee22bULL,
0x0000002800287308ULL, 0x000e620000000800ULL, 0x000000333616723eULL, 0x004fe200000000ffULL,
0x0000000829367824ULL, 0x000fcc00078e00ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002400247308ULL, 0x000ea20000000800ULL, 0x0000002d2815723eULL, 0x002fe200000000ffULL,
0x0000000829287824ULL, 0x000fc400078e00ffULL, 0x00000008292d7824ULL, 0x000fc600078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee229ULL, 0x0000002000237308ULL, 0x0003e20000000800ULL,
0x000000212417723eULL, 0x004fce00000000ffULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x0000000529207810ULL, 0x042fe40007ffe0ffULL, 0x0000000629217810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82d347812ULL, 0x000fe200078ee220ULL, 0x0000001e1418723cULL, 0x000f620000001818ULL,
0xfffffff836367812ULL, 0x000fe200078ee221ULL, 0x0000000b000b7308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000e620000000800ULL, 0x000000232621723eULL, 0x004fce00000000ffULL,
0x0000002f002f7308ULL, 0x000ff00000000800ULL, 0x0000003200327308ULL, 0x000ea20000000800ULL,
0x0000000b3020723eULL, 0x002fe400000000ffULL, 0x000090005a0b7811ULL, 0x000fca00078e58ffULL,
0x0000002200257308ULL, 0x0003e20000000800ULL, 0x00000010281d7824ULL, 0x100fe400078e020bULL,
0x000000103a267824ULL, 0x000fe400078e020bULL, 0x000000012c1d7824ULL, 0x000fe400078e021dULL,
0x0000001034287824ULL, 0x000fe200078e020bULL, 0x0000002700247308ULL, 0x0007220000000800ULL,
0x0000000829227810ULL, 0x002fe20007ffe0ffULL, 0x000000012c267824ULL, 0x040fe200078e0226ULL,
0x0000000c1d007388ULL, 0x0003e20000000800ULL, 0x000000012c287824ULL, 0x000fc400078e0228ULL,
0x0000000822297824ULL, 0x000fe400078e00ffULL, 0x000000103c277824ULL, 0x008fc600078e020bULL,
0xfffffff829407812ULL, 0x000fe200078ee222ULL, 0x0000001036297824ULL, 0x000fe200078e020bULL,
0x0000002f3222723eULL, 0x004fe200000000ffULL, 0x000000012c277824ULL, 0x000fe200078e0227ULL,
0x000000252423723eULL, 0x010fe200000000ffULL, 0x000000102a247824ULL, 0x100fe400078e020bULL,
0x0000001038257824ULL, 0x000fe400078e020bULL, 0x000000012c247824ULL, 0x040fe400078e0224ULL,
0x0000001e2018723cULL, 0x020b620000001818ULL, 0x000000012c257824ULL, 0x000fc400078e0225ULL,
0x000000103e2a7824ULL, 0x100fe200078e020bULL, 0x0000000e24007388ULL, 0x0003e20000000800ULL,
0x00000010400b7824ULL, 0x000fe400078e020bULL, 0x000000012c297824ULL, 0x040fe200078e0229ULL,
0x0000001025007388ULL, 0x0003e20000000800ULL, 0x000000012c2a7824ULL, 0x040fe400078e022aULL,
0x000000012c1e7824ULL, 0x020fe200078e020bULL, 0x0000001226007388ULL, 0x0003e20000000800ULL,
0x000000072e0b7208ULL, 0x000fc60004800000ULL, 0x0000001427007388ULL, 0x0003e80000000800ULL,
0x0000001628007388ULL, 0x0003e80000000800ULL, 0x0000002029007388ULL, 0x0003e20000000800ULL,
0x000000ffff197224ULL, 0x000fc600078e001aULL, 0x000000222a007388ULL, 0x0003e80000000800ULL,
0x0000000d1e007388ULL, 0x0003e80000000800ULL, 0x0004000f24007388ULL, 0x0003e80000000800ULL,
0x0004001125007388ULL, 0x0003e80000000800ULL, 0x0004001326007388ULL, 0x0003e80000000800ULL,
0x0004001527007388ULL, 0x0003e80000000800ULL, 0x0004001728007388ULL, 0x0003e80000000800ULL,
0x0004002129007388ULL, 0x0003e80000000800ULL, 0x000400232a007388ULL, 0x0003e80000000800ULL,
0x013000081c008388ULL, 0x0003e80000000c00ULL, 0x013200181c008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136080000ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136100000ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136180000ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000534c00720cULL, 0x000fe20003f06070ULL,
0x0136200000ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff5c7224ULL, 0x000fd600078e004cULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffa50000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0c7807ULL, 0x008fe40004000000ULL,
0x00012d8000167802ULL, 0x000fc40000000f00ULL, 0x00000c7000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0015ULL, 0xfffefc4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe40005000000ULL, 0x00012dd000167802ULL, 0x000fc40000000f00ULL,
0x00000c2000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0xfffefcb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x008fe200078e0015ULL,
0x00012e2000177802ULL, 0x000fc40000000f00ULL, 0x00000b8000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0016ULL, 0xfffefd7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff167224ULL, 0x000fe200078e0015ULL, 0x00012e7000177802ULL, 0x000fc40000000f00ULL,
0x00000b3000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0016ULL,
0xfffefe9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000fULL,
0x00012ed000177802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fc400078e000eULL,
0x00000ad000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0016ULL,
0xffff004000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0c7224ULL, 0x000fe200078e0008ULL,
0x00012f3000177802ULL, 0x000fe20000000f00ULL, 0x000000ffff167224ULL, 0x000fc400078e000fULL,
0x00000a7000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0016ULL,
0xffff001000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x008fe40004000000ULL,
0x00012f8000167802ULL, 0x000fc40000000f00ULL, 0x00000a7000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0015ULL, 0xffff18e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe40005000000ULL, 0x00012fd000167802ULL, 0x000fc40000000f00ULL,
0x00000a2000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0xffff193000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e0015ULL,
0x0001302000177802ULL, 0x000fc40000000f00ULL, 0x0000098000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0016ULL, 0xffff1a0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff167224ULL, 0x000fe200078e0015ULL, 0x0001307000177802ULL, 0x000fc40000000f00ULL,
0x0000093000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0016ULL,
0xffff1b1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x000130d000177802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fc400078e000fULL,
0x000008d000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0016ULL,
0xffff1cc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x0001312000177802ULL, 0x000fc40000000f00ULL, 0x0000088000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0016ULL, 0xffff1ca000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x008fe40004000000ULL, 0x0001317000167802ULL, 0x000fc40000000f00ULL,
0x0000088000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0xffff336000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40004800000ULL,
0x000131c000167802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x010fea0003c00000ULL,
0xffff33c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e0019ULL,
0x0001320000177802ULL, 0x000fc40000000f00ULL, 0x000007a000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0016ULL, 0xffff34a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff167224ULL, 0x000fe200078e0019ULL, 0x0001325000177802ULL, 0x000fc40000000f00ULL,
0x0000075000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0016ULL,
0xffff35b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x000132b000177802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fc400078e000fULL,
0x000006f000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0016ULL,
0xffff376000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x0001330000177802ULL, 0x000fc40000000f00ULL, 0x000006a000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0016ULL, 0xffff374000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x008fe40004000000ULL, 0x0001335000167802ULL, 0x000fc40000000f00ULL,
0x000006a000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0xffff4d3000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40004800000ULL,
0x000133a000167802ULL, 0x000fc40000000f00ULL, 0x0000065000007944ULL, 0x002fea0003c00000ULL,
0xffff4d9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e0019ULL,
0x000133e000177802ULL, 0x000fc40000000f00ULL, 0x000005c000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0016ULL, 0xffff4e6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff167224ULL, 0x000fe200078e0019ULL, 0x0001343000177802ULL, 0x000fc40000000f00ULL,
0x0000057000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0016ULL,
0xffff4f7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x0001349000177802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fc400078e000fULL,
0x0000051000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0016ULL,
0xffff511000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x000134e000177802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0016ULL, 0xffff50f000007947ULL, 0x000fea000383ffffULL,
0x00000002ff327424ULL, 0x000fe200078e00ffULL, 0x00013530002e7802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0030ULL,
0xffffeaf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff317224ULL, 0x006fe200078e0033ULL,
0x00013590002e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x000fea0003c00000ULL, 0x000000303300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff317224ULL, 0x002fe200078e000aULL, 0x000135f0002e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x000fe200078e00ffULL, 0x0000003330097208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x000000300a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff317224ULL, 0x002fe200078e000bULL, 0x00013650002e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x000fe200078e00ffULL, 0x0000000a30337208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000300b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff317224ULL, 0x002fe200078e0034ULL, 0x000136b0002e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x000fe200078e00ffULL, 0x0000000b30077208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x000000303400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff317224ULL, 0x002fe200078e0009ULL, 0x00013710002e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x000fe200078e00ffULL, 0x0000003430087208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x000000300900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff317224ULL, 0x002fe200078e0033ULL, 0x00013770002e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x000fe200078e00ffULL, 0x0000000930097208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x000000303300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff317224ULL, 0x002fe200078e0007ULL, 0x000137d0002e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x000fe200078e00ffULL, 0x00000033300a7208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2e7224ULL, 0x004fe200078e0030ULL,
0xffffe9b000007947ULL, 0x000fea000383ffffULL, 0x0180000004037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000400038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff0c7807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x000000030cff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff04ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000004057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x000000030cff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000400037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff0b7424ULL, 0x000fc800078e00ffULL, 0xfffec6a00a007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2f7424ULL, 0x000fe200078e00ffULL, 0x0000003600007348ULL, 0x000fe80003800000ULL,
0x0c00003231307389ULL, 0x0002a200000e0035ULL, 0xfffec6602e007950ULL, 0x000fea0003c3ffffULL,
0x0000005e00007348ULL, 0x000fe80003800000ULL, 0x0000000c16167389ULL, 0x0002a200000e0061ULL,
0x00000000ff0d7424ULL, 0x000fc400078e00ffULL, 0x000000ffff0c7224ULL, 0x002fc800078e0017ULL,
0xfffec6100c007950ULL, 0x000fea0003c3ffffULL, 0x000000010c00780cULL, 0x000fe20003f45070ULL,
0x0000005f00007348ULL, 0x000fe80003800000ULL, 0x00000000ff0d7424ULL, 0x000fd000078e00ffULL,
0x00000000000c7806ULL, 0x000fc800050e0100ULL, 0x0000005f0c157212ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0016ULL, 0xfffec5a00c007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000002ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000542ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006a0ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008f8ULL,
0x00000000000002f0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000be8ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ca8ULL,
0x0000000000000584ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001230ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001240ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012d0ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012d4ULL,
0x00000000000001b0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001500ULL,
0x0000000000013b00ULL, 0x8000001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015000ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015040ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x00000000000153c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000012d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000013d30ULL,
0x0000000000013d30ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000015000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000153c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_8_m_8_sm_86_cubin_len = 87200;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
