/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000014620ULL, 0x00000000000142a0ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x32666c61685f5f37ULL,
0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454536316a4cULL, 0x45454531624c4974ULL,
0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45346aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x32336a4c4545346aULL, 0x61324545386a4c45ULL,
0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x6a4c45386a4c4545ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4536316aULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x0000000000676e69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL, 0x735f616475635f5fULL, 0x5f7063725f30326dULL,
0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL, 0x6c65722e00687461ULL, 0x656b2e747865742eULL,
0x61686d5f6c656e72ULL, 0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL,
0x6d5f6c656e72656bULL, 0x426d656d73246168ULL, 0x2e00667542657479ULL, 0x72665f6775626564ULL,
0x6c65722e00656d61ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b0001000000b1ULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000b0001000000efULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000b00010000016fULL, 0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b0001000001b1ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000001f7ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000023eULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000b000100000284ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000002d2ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000b000100000320ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000366ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0001000003abULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a002200000406ULL, 0x0000000000012fa0ULL,
0x0000000000000260ULL, 0x000400030000047cULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000013200ULL, 0x000d0003000004acULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00012fa000000000ULL,
0x0000a00400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000001cffffffffULL,
0x0000006000000000ULL, 0x00012fa000000000ULL, 0x0000026000000000ULL, 0x0000000000000000ULL,
0x0000001400082f04ULL, 0x000823040000007fULL, 0x0000000000000012ULL, 0x0000001200081204ULL,
0x0008110400000000ULL, 0x0000000000000012ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00b42904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000010000b42804ULL, 0x0000062000000110ULL, 0x00002b7000001950ULL,
0x00002cd000002bf0ULL, 0x000031a000002e10ULL, 0x00003720000031b0ULL, 0x0000481000004790ULL,
0x00004a30000048f0ULL, 0x00004c7000004c60ULL, 0x0000617000004fd0ULL, 0x000062e0000061e0ULL,
0x0000665000006420ULL, 0x00006a4000006660ULL, 0x00007af000007a70ULL, 0x00007d1000007bd0ULL,
0x00007ee000007ed0ULL, 0x0000848000008470ULL, 0x0000a5400000a510ULL, 0x0000ab700000ab50ULL,
0x000124b000012400ULL, 0x00012760000126d0ULL, 0x00012a6000012900ULL, 0x00012cb000012c00ULL,
0x000002d001f03904ULL, 0x0001b600000000ffULL, 0x000003b000040100ULL, 0x0001b60800000007ULL,
0x000004c0003f0100ULL, 0x0001b68800000007ULL, 0x00000670003f0100ULL, 0x0001b6000000000bULL,
0x00000810003f0107ULL, 0x0001b68800000003ULL, 0x00002900003f0101ULL, 0x0001b60800000062ULL,
0x00002920003f0101ULL, 0x0001b60800000062ULL, 0x00002a90003f0109ULL, 0x0001b60800000062ULL,
0x00003630003f0109ULL, 0x0001b68800000047ULL, 0x00004580003f0101ULL, 0x0001b62800000062ULL,
0x000045a0003f0101ULL, 0x0001b62800000062ULL, 0x00004710003f0109ULL, 0x0001b62800000062ULL,
0x00004f20003f0109ULL, 0x0001b69000000047ULL, 0x00005f10003f0101ULL, 0x0001b64800000062ULL,
0x00005f80003f0101ULL, 0x0001b64800000062ULL, 0x000060f0003f0109ULL, 0x0001b64800000062ULL,
0x00006920003f0109ULL, 0x0001b69800000047ULL, 0x00007860003f0101ULL, 0x0001b66800000062ULL,
0x00007880003f0101ULL, 0x0001b66800000062ULL, 0x000079f0003f0109ULL, 0x0001b66800000062ULL,
0x00008110003f0109ULL, 0x0001b6a000000047ULL, 0x0000b4a0003f0101ULL, 0x0001b6000000000bULL,
0x0000d170003f0101ULL, 0x0001b6000000000bULL, 0x0000d2e0003f0109ULL, 0x0001b6000000000bULL,
0x000118b0003f0109ULL, 0x0001b68800000007ULL, 0x00011b20003f0101ULL, 0x0001b68800000007ULL,
0x00011c90003f0109ULL, 0x0001b68800000007ULL, 0x00012f40003f0109ULL, 0x0001b60800000004ULL,
0x00012f50003f0101ULL, 0x0001b61000000004ULL, 0x00012f60003f0101ULL, 0x0001b61800000004ULL,
0x00012f70003f0101ULL, 0x0001b62000000004ULL, 0x00033803003f0101ULL, 0x0000b18000141c04ULL,
0x0000d3100000b3f0ULL, 0x00012f900000d3a0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x00080a0400501903ULL, 0x0050021000000015ULL, 0x00000000000000bcULL,
0x0000001400000002ULL, 0x0000000000012fa0ULL, 0x0000000000000044ULL, 0x0000001400000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001400000002ULL, 0x0000000000000000ULL,
0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e620000000800ULL, 0x0000000000067919ULL, 0x000eae0000002100ULL,
0x00008400ff147b82ULL, 0x000ee20000000800ULL, 0x00000400000b7802ULL, 0x000fe20000000f00ULL,
0x000002d000007945ULL, 0x000fe20003800000ULL, 0x0000000000087919ULL, 0x000f220000002300ULL,
0x0000000000037919ULL, 0x000f680000002200ULL, 0x00000300ff0c7b82ULL, 0x000f620000000800ULL,
0x0000010000047ab9ULL, 0x000fe20000000800ULL, 0x0000000000127919ULL, 0x000ea20000002600ULL,
0x0000000000027919ULL, 0x000eaa0000002700ULL, 0x00008800ff047b82ULL, 0x000f620000000a00ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x0000000000167919ULL, 0x000f220000008800ULL,
0x00000008140a7824ULL, 0x008fe200078e00ffULL, 0x00000005ff5c7819ULL, 0x104fe20000011606ULL,
0x00001fff080d7589ULL, 0x0105ea00000e0000ULL, 0x00001fff5c5c7589ULL, 0x000ee200000e0000ULL,
0x0000000408037c24ULL, 0x022fe2000f8e0203ULL, 0x0000000000047ab9ULL, 0x000fe20000000800ULL,
0x00008e00ff087b82ULL, 0x004e640000000a00ULL, 0x0000000403067c24ULL, 0x000fc4000f8e0206ULL,
0x0000000812077824ULL, 0x000fc600078e00ffULL, 0x000000ff0600720cULL, 0x000fe20003f05270ULL,
0x000000020a077224ULL, 0x000fe200078e0207ULL, 0x00000004ff0e7819ULL, 0x000fe40000011600ULL,
0x0000000f0600780cULL, 0x040fe40003f24070ULL, 0x000000030600780cULL, 0x040fe40003f64070ULL,
0x0000007f0600780cULL, 0x000fe40003f44070ULL, 0x00000654160b7816ULL, 0x000fe2000000000bULL,
0x000000040d037824ULL, 0x008fc800078e025cULL, 0x00000002030a7824ULL, 0x000fe400078e00ffULL,
0x0000001000037824ULL, 0x000fe400078e00ffULL, 0x000000010a107824ULL, 0x000fe200078e020eULL,
0x000000080a0f7848ULL, 0x000fe40007fe0000ULL, 0x000000f003117812ULL, 0x000fe200078ec0ffULL,
0x0000000107077824ULL, 0x000fe400078e0210ULL, 0x000000010f0f7824ULL, 0x000fc400078e0a0aULL,
0x0000010007047825ULL, 0x000fe200078e0004ULL, 0x0000000000240947ULL, 0x002fec0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01b60006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000406077c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000070612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01b60804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000406077c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000070612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01b68804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000000b0472caULL, 0x000fe200000e0000ULL, 0x0000000110077824ULL, 0x000fe200078e0200ULL,
0x0000000b060aa211ULL, 0x000fe200078e10ffULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0x0000000f0e00720cULL, 0x000fe20003f06070ULL, 0xff317217ff13a424ULL, 0x000fe200078e00ffULL,
0x0000001104067210ULL, 0x000fe20007f3e0ffULL, 0x0000820000067ab9ULL, 0x000fe20000000a00ULL,
0xfffffff0100e7812ULL, 0x000fe400078ee207ULL, 0x01b400130a00a388ULL, 0x0003e20000000800ULL,
0x000000ffff077224ULL, 0x000fc400008e0605ULL, 0x0001b60004047890ULL, 0x000fe2000fffe03fULL,
0x0000000402047825ULL, 0x000fc800078e0008ULL, 0x000000100e097824ULL, 0x000fe200078e020bULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e2000c101c46ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe40008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000006045a7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0d00720cULL, 0x000fe20003f05270ULL, 0x00000000005b7919ULL, 0x000ee20000002500ULL,
0x0000007f5a587836ULL, 0x004fe40000000000ULL, 0x000000ff5a0e7836ULL, 0x000fc60000000000ULL,
0x00000007ff587819ULL, 0x000fe40000011658ULL, 0x00000008ff0e7819ULL, 0x000fc8000001160eULL,
0x000000ac00348947ULL, 0x008fea0003800000ULL, 0x00000003ff037819ULL, 0x000fe2000001165cULL,
0x000000085c447824ULL, 0x000fe400078e00ffULL, 0xffffffffff0d7424ULL, 0x000fe200078e00ffULL,
0x01ffffff03047812ULL, 0x000fca00078ec0ffULL, 0x000000025b0f7824ULL, 0x000fca00078e0204ULL,
0x000000580f00720cULL, 0x000fda0003f06070ULL, 0x00009000ff068b82ULL, 0x002e620000000800ULL,
0x0000000102038819ULL, 0x000fce00000006ffULL, 0x00008c00ff048b82ULL, 0x000ea20000000a00ULL,
0x0000000603068224ULL, 0x002fc800078e0206ULL, 0x000000010f038824ULL, 0x000fe400078e0206ULL,
0x00000004ff067424ULL, 0x000fe400078e00ffULL, 0x0000000403048825ULL, 0x004fc800078e0004ULL,
0x000000010b037824ULL, 0x000fc800078e0244ULL, 0x01b6880603ff79a7ULL, 0x0003e2000850003fULL,
0x00000006040d8981ULL, 0x000ea2000c1e1900ULL, 0x00000001ff467819ULL, 0x000fe2000001165cULL,
0x0000008012097824ULL, 0x000fc800078e00ffULL, 0x00000020460a7824ULL, 0x000fe400078e00ffULL,
0x000000015b037836ULL, 0x002fe20000000000ULL, 0x000000015c067812ULL, 0x000fe400078ec0ffULL,
0x0000000a5b087211ULL, 0x000fe400078e40ffULL, 0x0000000e0300720cULL, 0x000fe40003f06070ULL,
0x0000006009287812ULL, 0x000fe200078ef808ULL, 0x000000140d037224ULL, 0x004fc800078e02ffULL,
0x00000080032a7824ULL, 0x000fcc00078e00ffULL, 0x0000000400d48947ULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x000fe20000011600ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x000000085a037248ULL, 0x000fe20007fe0000ULL, 0x000000ffff087224ULL, 0x000fe200078e0a08ULL,
0x0000001807257810ULL, 0x000fe20007ffe0ffULL, 0x0000000807207836ULL, 0x000fe40000000000ULL,
0x00000004071e7836ULL, 0x000fe20000000000ULL, 0x0000002003037446ULL, 0x000fe20003800008ULL,
0x0000000128087824ULL, 0x040fe400078e0220ULL, 0x0000000128047824ULL, 0x000fc400078e0207ULL,
0x0000000128057824ULL, 0x000fe200078e021eULL, 0x000000082a087210ULL, 0x000fe20007f5e0ffULL,
0x0000000c07227836ULL, 0x000fe20000000000ULL, 0x000000042a137210ULL, 0x000fe20007f1e0ffULL,
0x0000001007237836ULL, 0x000fe20000000000ULL, 0x000000052a117210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff057224ULL, 0x000fe200010e06ffULL, 0x0000000408047c11ULL, 0x040fe2000f8440ffULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x00000004131c7c11ULL, 0x000fe2000f8040ffULL,
0x0000001407247836ULL, 0x000fe20000000000ULL, 0x0000000508057c11ULL, 0x000fe200090f4405ULL,
0x0000000107087824ULL, 0x000fe200078e0200ULL, 0x00000005131d7c11ULL, 0x000fe200080f4414ULL,
0x0000001c07267836ULL, 0x000fe20000000000ULL, 0x000000030700720cULL, 0x000fe20003f06070ULL,
0x0000400046137824ULL, 0x000fe200078e020bULL, 0x000000ffff127210ULL, 0x000fe20000ffe4ffULL,
0x0000000128157824ULL, 0x000fe200078e0225ULL, 0x0000000708077812ULL, 0x000fe200078ec0ffULL,
0x0000000128087824ULL, 0x000fe200078e0222ULL, 0x0000000411107c11ULL, 0x040fe2000f8240ffULL,
0x0000200006137824ULL, 0x040fe200078e0213ULL, 0x000000152a177210ULL, 0x000fe20007f5e0ffULL,
0x0000000806217824ULL, 0x000fe200078e00ffULL, 0x0000000511117c11ULL, 0x000fe200088f4412ULL,
0x00013000131f7836ULL, 0x000fe20000000000ULL, 0x000000082a187210ULL, 0x000fe20007f3e0ffULL,
0x0000000128137824ULL, 0x040fe200078e0224ULL, 0x0ffffff807087812ULL, 0x000fe200078ef800ULL,
0x0000000128167824ULL, 0x000fe200078e0226ULL, 0x0000000418147c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x000000132a197210ULL, 0x000fe20007fbe0ffULL,
0x0000000128127824ULL, 0x000fe200078e0223ULL, 0x000000162a137210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff287224ULL, 0x000fe200010e06ffULL, 0x0000000518157c11ULL, 0x000fe200098f4407ULL,
0x000000081e277824ULL, 0x000fe200078e00ffULL, 0xfffffff821077812ULL, 0x000fe200078ee200ULL,
0x0000000820297824ULL, 0x000fe200078e00ffULL, 0x000000122a1b7210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff2a7224ULL, 0x000fe200028e06ffULL, 0x0000001f08217211ULL, 0x000fe200078e20ffULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x0000000413127c11ULL, 0x000fe2000f8440ffULL,
0x00000010071c7825ULL, 0x000fe200078e001cULL, 0x000000041b1a7c11ULL, 0x000fc4000f8640ffULL,
0x0000000417167c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff2c7224ULL, 0x000fe200020e06ffULL,
0x0000000419187c11ULL, 0x000fe2000f8840ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c217faeULL, 0x0003e2000c101c46ULL, 0x0000000513137c11ULL, 0x000fe200090f4408ULL,
0x000000011e087824ULL, 0x140fe200078e0200ULL, 0x000000031e00720cULL, 0x000fe20003f06070ULL,
0x00000001201e7824ULL, 0x000fe200078e0200ULL, 0x000000051b1b7c11ULL, 0x000fe200098f442cULL,
0x00000008222b7824ULL, 0x000fe200078e00ffULL, 0x0000000519197c11ULL, 0x000fe2000a0f442aULL,
0x0000001007107825ULL, 0x000fe200078e0010ULL, 0x0000000517177c11ULL, 0x000fc400088f4428ULL,
0x000000032000720cULL, 0x080fe20003f26070ULL, 0x00000008231c7824ULL, 0x042fe200078e00ffULL,
0x000000032200720cULL, 0x080fe20003f46070ULL, 0x00000001241d7824ULL, 0x140fe200078e0200ULL,
0x000000032300720cULL, 0x080fe20003f66070ULL, 0x0000000125217824ULL, 0x000fe200078e0200ULL,
0x000000032400720cULL, 0x080fe20003f86070ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000032500720cULL, 0x080fe40003fa6070ULL, 0x000000032600720cULL, 0x000fe20003fc6070ULL,
0x0000000123037824ULL, 0x100fe200078e0200ULL, 0x0000000022207210ULL, 0x000fe20007ffe0ffULL,
0x0000000824227824ULL, 0x000fe200078e00ffULL, 0xfffffff827087812ULL, 0x000fe200078ee208ULL,
0x0000000825247824ULL, 0x000fe200078e00ffULL, 0xfffffff8291e7812ULL, 0x000fe200078ee21eULL,
0x0000000126237824ULL, 0x040fe200078e0200ULL, 0xfffffff82b207812ULL, 0x000fe200078ee220ULL,
0x0000001007147825ULL, 0x000fe200078e0014ULL, 0x0000000326267819ULL, 0x000fc400000006ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee203ULL, 0x0000001008037824ULL, 0x100fe200078e021fULL,
0xfffffff822227812ULL, 0x000fe200078ee21dULL, 0x000000101e1d7824ULL, 0x100fe200078e021fULL,
0xfffffff824247812ULL, 0x000fe200078ee221ULL, 0x0000001020217824ULL, 0x100fe200078e021fULL,
0xfffffff826267812ULL, 0x000fe200078ee223ULL, 0x000000101c237824ULL, 0x000fe200078e021fULL,
0x0000000010037faeULL, 0x0003e2000c101c46ULL, 0x00000010071a7825ULL, 0x000fc600078e001aULL,
0x00000000041d7faeULL, 0x0003e2000c901c46ULL, 0x0000001022257824ULL, 0x000fe400078e021fULL,
0x0000001007187825ULL, 0x040fe200078e0018ULL, 0x0000000014217faeULL, 0x0003e6000d101c46ULL,
0x0000001024277824ULL, 0x000fe200078e021fULL, 0x000000001a237faeULL, 0x0003e2000d901c46ULL,
0x0000001007167825ULL, 0x000fc600078e0016ULL, 0x0000000018257faeULL, 0x0003e2000e101c46ULL,
0x00000010261f7824ULL, 0x000fe400078e021fULL, 0x0000001007127825ULL, 0x000fe200078e0012ULL,
0x0000000016277faeULL, 0x0003e8000e901c46ULL, 0x00000000121f7faeULL, 0x0003e2000f101c46ULL,
0x0000000400a07947ULL, 0x000fea0003800000ULL, 0x0000000400077811ULL, 0x040fe200078fe8ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000c00137811ULL, 0x000fe200078fe8ffULL,
0x0000400046217824ULL, 0x000fe200078e020bULL, 0x0000000307087819ULL, 0x040fe200000006ffULL,
0x0000000107037824ULL, 0x100fe200078e0200ULL, 0x0000000800117811ULL, 0x040fe200078fe8ffULL,
0x0000000113057824ULL, 0x140fe200078e0200ULL, 0x0000001400177811ULL, 0x040fe200078fe8ffULL,
0x0000000813147824ULL, 0x000fe200078e00ffULL, 0xfffffff808087812ULL, 0x000fe200078ee203ULL,
0x0000000111047824ULL, 0x140fe200078e0200ULL, 0x0000002800037211ULL, 0x000fe200078fe8ffULL,
0x0000000811157824ULL, 0x000fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee205ULL,
0x0000000117057824ULL, 0x140fe200078e0200ULL, 0x000000032a1b7210ULL, 0x000fe20007f1e0ffULL,
0x0000000817187824ULL, 0x000fe200078e00ffULL, 0xfffffff815127812ULL, 0x000fe200078ee204ULL,
0x0000000128077824ULL, 0x000fe200078e0207ULL, 0x0000001800197811ULL, 0x040fe200078fe8ffULL,
0x000000ffff1c7224ULL, 0x000fe200000e06ffULL, 0x0000001000157811ULL, 0x000fe200078fe8ffULL,
0x0000000128117824ULL, 0x000fe200078e0211ULL, 0x000000041b047c11ULL, 0x000fe2000f8040ffULL,
0x00000008191d7824ULL, 0x000fe200078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ee205ULL,
0x0000000115037824ULL, 0x000fe200078e0200ULL, 0x000000051b057c11ULL, 0x000fe200080f441cULL,
0x0000000815167824ULL, 0x000fe200078e00ffULL, 0x0000000019107210ULL, 0x000fe20007ffe0ffULL,
0x0000200006217824ULL, 0x000fe200078e0221ULL, 0x0000001c001b7811ULL, 0x000fe200078fe8ffULL,
0x0000000128137824ULL, 0x040fe200078e0213ULL, 0xfffffff81d1a7812ULL, 0x000fe200078ee210ULL,
0x0000000128157824ULL, 0x040fe200078e0215ULL, 0xfffffff816167812ULL, 0x000fe200078ee203ULL,
0x0000000128107824ULL, 0x040fe200078e021bULL, 0x000000072a1f7210ULL, 0x000fe20007fde0ffULL,
0x0000000128177824ULL, 0x000fe200078e0217ULL, 0x0000000000037211ULL, 0x000fe200078fe8ffULL,
0x000000011b077824ULL, 0x040fe200078e0200ULL, 0x0000001928197210ULL, 0x000fe20007ffe0ffULL,
0x000000081b287824ULL, 0x000fe200078e00ffULL, 0x000000102a1d7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff267224ULL, 0x000fe200030e06ffULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0001300021297836ULL, 0x000fe20000000000ULL, 0x000000112a247210ULL, 0x000fe20007fbe0ffULL,
0x00000008062b7824ULL, 0x000fe200078e00ffULL, 0x000000041f107c11ULL, 0x000fe2000f8c40ffULL,
0x0000001014217824ULL, 0x100fe200078e0229ULL, 0x000000132a1c7210ULL, 0x000fe20007f9e0ffULL,
0x0000001016237824ULL, 0x100fe200078e0229ULL, 0x0ffffff803037812ULL, 0x000fe200078ef800ULL,
0x0000001018257824ULL, 0x100fe200078e0229ULL, 0x000000172a207210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe200028e06ffULL, 0xfffffff828137812ULL, 0x000fe200078ee207ULL,
0x0000001003037824ULL, 0x100fe200078e0229ULL, 0x000000051f117c11ULL, 0x000fe2000b0f4426ULL,
0x00000010121f7824ULL, 0x100fe200078e0229ULL, 0x0000000424127c11ULL, 0x000fe2000f8a40ffULL,
0x000000101a277824ULL, 0x100fe200078e0229ULL, 0x000000152a227210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff157224ULL, 0x000fe200020e06ffULL, 0x000000192a1e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff197224ULL, 0x000fe200000e06ffULL, 0x0000002908077211ULL, 0x000fe200078e20ffULL,
0x0000001013297824ULL, 0x000fe200078e0229ULL, 0x000000041c147c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff1b7224ULL, 0x000fe200010e06ffULL, 0x0000000524137c11ULL, 0x000fe2000a8f4417ULL,
0x000000ffff087224ULL, 0x000fe200008e06ffULL, 0x000000ffff177210ULL, 0x000fc40001ffe4ffULL,
0xfffffff82b2b7812ULL, 0x000fe400078ee200ULL, 0x0000000422167c11ULL, 0x000fe4000f8640ffULL,
0x0000000420187c11ULL, 0x000fe2000f8040ffULL, 0x000000102b047825ULL, 0x040fe200078e0004ULL,
0x000000051c157c11ULL, 0x000fe4000a0f4415ULL, 0x000000041e1a7c11ULL, 0x000fe2000f8440ffULL,
0x000000102b107825ULL, 0x000fe200078e0010ULL, 0x000000041d1c7c11ULL, 0x000fe2000f8240ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e2000b901c46ULL,
0x0000000522177c11ULL, 0x000fe200098f4417ULL, 0x000000102b127825ULL, 0x040fe200078e0012ULL,
0x0000000520197c11ULL, 0x000fe200080f4419ULL, 0x0000000010077faeULL, 0x0003e2000b901c46ULL,
0x000000051e1b7c11ULL, 0x000fe200090f441bULL, 0x000000102b147825ULL, 0x000fe200078e0014ULL,
0x000000051d1d7c11ULL, 0x000fe200088f4408ULL, 0x00000000121f7faeULL, 0x0003e4000b901c46ULL,
0x000000102b167825ULL, 0x000fc400078e0016ULL, 0x0000000014217faeULL, 0x0003e4000b901c46ULL,
0x000000102b187825ULL, 0x040fe400078e0018ULL, 0x0000000016237faeULL, 0x0003e4000b901c46ULL,
0x000000102b1a7825ULL, 0x040fe400078e001aULL, 0x0000000018257faeULL, 0x0003e4000b901c46ULL,
0x000000102b1c7825ULL, 0x000fc400078e001cULL, 0x000000001a277faeULL, 0x0003e8000b901c46ULL,
0x000000001c297faeULL, 0x0003e4000b901c46ULL, 0x0000000e5b00720cULL, 0x000fe20003f06070ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xff317217ff647424ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x002fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000006800700947ULL, 0x000fec0003800000ULL,
0x00009000ff047b82ULL, 0x000e620000000800ULL, 0x0000000202057824ULL, 0x000fe200078e00ffULL,
0x000000ff002f7202ULL, 0x000fe20000000f00ULL, 0xff317217ff647424ULL, 0x000fe400078e00ffULL,
0x000000ffff677224ULL, 0x000fe400078e00ffULL, 0x0000000405057224ULL, 0x002fce00078e0204ULL,
0x000001005b077824ULL, 0x000fca00078e00ffULL, 0x0000005a0700720cULL, 0x000fda0003f06070ULL,
0x0000006800400947ULL, 0x010fea0003800000ULL, 0x000000105c077824ULL, 0x000fe200078e00ffULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x000000ffff637224ULL, 0x000fe400078e000fULL,
0x000000040d387c24ULL, 0x000fe2000f8e02ffULL, 0xffffffe007307812ULL, 0x000fe200078ec0ffULL,
0x000000015b077836ULL, 0x000fe40000000000ULL, 0x0000008038387824ULL, 0x000fe400078e00ffULL,
0x000001005b307824ULL, 0x000fe200078e0230ULL, 0x0000000e0700720cULL, 0x000fe20003f06070ULL,
0x000000ffff077224ULL, 0x000fc400078e0067ULL, 0x0000004030307836ULL, 0x000fca0000000000ULL,
0x0000006009397812ULL, 0x000fe200078ef830ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000400e88947ULL, 0x000fea0003800000ULL, 0x00000003ff3b7819ULL, 0x000fe20000011600ULL,
0x0000100067327824ULL, 0x000fe200078e00ffULL, 0x000000305a407248ULL, 0x000fe20007fe0000ULL,
0x0000400046467824ULL, 0x000fe200078e020bULL, 0x000000ff30317210ULL, 0x000fe20007ffe1ffULL,
0x000000043b497836ULL, 0x000fe20000000000ULL, 0x00000007000d7812ULL, 0x000fe200078ec0ffULL,
0x0000000806307824ULL, 0x000fe200078e00ffULL, 0x0000002040407446ULL, 0x000fe20003800031ULL,
0x0000000149357824ULL, 0x100fe200078e0239ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x000000083b4b7836ULL, 0x000fe20000000000ULL, 0x00000008300d7812ULL, 0x000fe200078ee20dULL,
0x000020005c307824ULL, 0x000fe200078e00ffULL, 0x0000003538357210ULL, 0x000fe20007f3e0ffULL,
0x000000013b317824ULL, 0x000fe200078e0239ULL, 0x0000100032347812ULL, 0x000fe200078e0cffULL,
0x0000000c3b4d7836ULL, 0x000fe20000000000ULL, 0x0000200030337812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3a7224ULL, 0x000fe200008e06ffULL, 0x000000394b377210ULL, 0x000fe20007ffe0ffULL,
0x000000103b4f7836ULL, 0x000fe20000000000ULL, 0x0000000435327c11ULL, 0x000fe2000f8240ffULL,
0x000000143b517836ULL, 0x000fe20000000000ULL, 0x0000003138317210ULL, 0x000fe20007f1e0ffULL,
0x000000183b537836ULL, 0x000fe20000000000ULL, 0x0000004634347210ULL, 0x000fc40007ffe033ULL,
0x0000003738377210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff3c7224ULL, 0x000fe200000e06ffULL,
0x0000000535337c11ULL, 0x000fe200088f443aULL, 0x000000013b357824ULL, 0x000fe200078e0200ULL,
0x00000004313e7c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x0000000437307c11ULL, 0x000fe2000f8440ffULL, 0x00000001533d7824ULL, 0x100fe200078e0239ULL,
0x0000000735437812ULL, 0x000fe200078ec0ffULL, 0x000000014d357824ULL, 0x000fe200078e0239ULL,
0x0000001c3b557810ULL, 0x000fe20007ffe0ffULL, 0x0001300034417836ULL, 0x000fe20000000000ULL,
0x00000005313f7c11ULL, 0x000fe200080f443cULL, 0x000000100d327825ULL, 0x000fe200078e0032ULL,
0x0000000537317c11ULL, 0x000fc400090f4436ULL, 0x000000403b00720cULL, 0x000fe20003f06070ULL,
0x000000014f377824ULL, 0x100fe200078e0239ULL, 0x00000035383a7210ULL, 0x000fe20007f3e0ffULL,
0x00000001513b7824ULL, 0x100fe200078e0239ULL, 0x0000003d38457210ULL, 0x000fe20007f5e0ffULL,
0x0000000155397824ULL, 0x000fe200078e0239ULL, 0x0000003738477210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff377224ULL, 0x000fe200008e06ffULL, 0x0000003b383b7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff467224ULL, 0x000fe200010e06ffULL, 0x0000003938357210ULL, 0x000fe20007f3e0ffULL,
0x000000100d3e7825ULL, 0x000fe200078e003eULL, 0x000000043a367c11ULL, 0x000fc4000f8640ffULL,
0x0ffffff843347812ULL, 0x000fe200078ef800ULL, 0x000000ffff487224ULL, 0x000fe200028e06ffULL,
0x000000053a377c11ULL, 0x000fe200098f4437ULL, 0x000000ffff427224ULL, 0x000fe200008e06ffULL,
0x000000ffff4a7210ULL, 0x000fe200027fe4ffULL, 0x0000001034437824ULL, 0x000fe200078e0241ULL,
0x000000043b3a7c11ULL, 0x000fe2000f8840ffULL, 0x00000008554c7824ULL, 0x000fe200078e00ffULL,
0x0000000445387c11ULL, 0x000fe2000f8240ffULL, 0x000000100d307825ULL, 0x000fe200078e0030ULL,
0x0000000435347c11ULL, 0x000fe2000f8440ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e437faeULL, 0x0003e2000c101c46ULL, 0x00000004473c7c11ULL, 0x000fe2000f8640ffULL,
0x000000100d367825ULL, 0x000fe200078e0036ULL, 0x000000053b3b7c11ULL, 0x000fc4000a0f4448ULL,
0x0000000545397c11ULL, 0x000fe200088f4446ULL, 0x000000014b457824ULL, 0x000fe200078e0200ULL,
0x0000000535357c11ULL, 0x000fe200090f4442ULL, 0x000000084b487824ULL, 0x000fe200078e00ffULL,
0x000000404900720cULL, 0x0c0fe20003f06070ULL, 0x0000000149427824ULL, 0x000fe200078e0200ULL,
0x00000005473d7c11ULL, 0x000fe200098f444aULL, 0x0000000849497824ULL, 0x000fe200078e00ffULL,
0x000000404b00720cULL, 0x080fe20003f26070ULL, 0x000000014d467824ULL, 0x140fe200078e0200ULL,
0x000000404d00720cULL, 0x080fe20003f46070ULL, 0x000000014f3f7824ULL, 0x142fe200078e0200ULL,
0x000000404f00720cULL, 0x080fe20003f66070ULL, 0x0000000151437824ULL, 0x140fe200078e0200ULL,
0x000000405100720cULL, 0x080fe20003f86070ULL, 0x00000008534a7824ULL, 0x040fe200078e00ffULL,
0x000000405300720cULL, 0x080fe20003fa6070ULL, 0x0000000155477824ULL, 0x040fe200078e0200ULL,
0x000000405500720cULL, 0x000fe20003fc6070ULL, 0x000000084f407824ULL, 0x000fe200078e00ffULL,
0x000000034d4d7819ULL, 0x000fe200000006ffULL, 0x000000100d3c7825ULL, 0x000fe200078e003cULL,
0xfffffff8483e7812ULL, 0x000fc400078ee245ULL, 0xfffffff849427812ULL, 0x000fe200078ee242ULL,
0x0000000851487824ULL, 0x000fe200078e00ffULL, 0xfffffff84d467812ULL, 0x000fe200078ee246ULL,
0x0000000153457824ULL, 0x000fe200078e0200ULL, 0xfffffff840407812ULL, 0x000fe200078ee23fULL,
0x000000100d3a7825ULL, 0x000fe200078e003aULL, 0xfffffff848487812ULL, 0x000fe400078ee243ULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee245ULL, 0x000000103e437824ULL, 0x100fe200078e0241ULL,
0x00000041423f7211ULL, 0x000fe200078e20ffULL, 0x0000001046457824ULL, 0x100fe200078e0241ULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee247ULL, 0x0000001040477824ULL, 0x000fc400078e0241ULL,
0x0000001048497824ULL, 0x100fe200078e0241ULL, 0x00000000323f7faeULL, 0x0003e2000c101c46ULL,
0x000000104a4b7824ULL, 0x000fe400078e0241ULL, 0x000000100d387825ULL, 0x040fe200078e0038ULL,
0x0000000030437faeULL, 0x0003e6000c901c46ULL, 0x000000104c417824ULL, 0x000fe200078e0241ULL,
0x0000000036457faeULL, 0x0003e2000d101c46ULL, 0x000000100d347825ULL, 0x000fc600078e0034ULL,
0x000000003c477faeULL, 0x0003e8000d901c46ULL, 0x000000003a497faeULL, 0x0003e8000e101c46ULL,
0x00000000384b7faeULL, 0x0003e8000e901c46ULL, 0x0000000034417faeULL, 0x0003e2000f101c46ULL,
0x0000000400b47947ULL, 0x000fea0003800000ULL, 0x00000008003b7811ULL, 0x000fe200078fe8ffULL,
0x0000000806347824ULL, 0x000fe200078e00ffULL, 0x00000010003d7811ULL, 0x000fe200078fe8ffULL,
0x000020005c317824ULL, 0x000fe200078e00ffULL, 0x00000007000d7812ULL, 0x000fe200078ec0ffULL,
0x000000013b407824ULL, 0x100fe200078e0200ULL, 0x000000033d357819ULL, 0x000fe200000006ffULL,
0x000000083b337824ULL, 0x000fe200078e00ffULL, 0x00000008340d7812ULL, 0x000fe200078ee20dULL,
0x000000013d427824ULL, 0x000fe200078e0200ULL, 0x0000000c67327819ULL, 0x000fe200000006ffULL,
0x0000400046307824ULL, 0x000fe200078e020bULL, 0xfffffff833407812ULL, 0x000fe200078ee240ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000400347811ULL, 0x040fe200078fe8ffULL,
0x000000013d3d7824ULL, 0x000fe200078e0239ULL, 0x0000003900337211ULL, 0x000fc400078fe8ffULL,
0xfffffff835427812ULL, 0x000fe400078ee242ULL, 0x0000200031317812ULL, 0x000fe400078ec0ffULL,
0x0000100032327812ULL, 0x000fe400078e0cffULL, 0x0000000c003c7811ULL, 0x000fe400078fe8ffULL,
0x0000003338357210ULL, 0x000fe20007f1e0ffULL, 0x0000000134337824ULL, 0x000fe200078e0239ULL,
0x0000003032307210ULL, 0x000fe20007ffe031ULL, 0x0000000134317824ULL, 0x100fe200078e0200ULL,
0x00000014003f7811ULL, 0x000fe200078fe8ffULL, 0x0000000834327824ULL, 0x000fe200078e00ffULL,
0x0000003338337210ULL, 0x000fe20007f3e0ffULL, 0x000000013c417824ULL, 0x100fe200078e0200ULL,
0x0000001800437811ULL, 0x000fe200078fe8ffULL, 0x000000083c367824ULL, 0x000fe200078e00ffULL,
0xfffffff832317812ULL, 0x000fe200078ee231ULL, 0x000000013f377824ULL, 0x000fc400078e0200ULL,
0x000000083f467824ULL, 0x000fe200078e00ffULL, 0xfffffff836417812ULL, 0x000fe200078ee241ULL,
0x000000ffff3a7224ULL, 0x000fe200000e06ffULL, 0x0000000435367c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff327224ULL, 0x000fe200008e06ffULL, 0x0000000433347c11ULL, 0x000fe2000f8240ffULL,
0x00000001433e7824ULL, 0x040fe200078e0200ULL, 0xfffffff8464b7812ULL, 0x000fe200078ee237ULL,
0x00000008434d7824ULL, 0x000fe200078e00ffULL, 0x0000000535377c11ULL, 0x000fe200080f443aULL,
0x000000013f3f7824ULL, 0x100fe200078e0239ULL, 0x0000000533357c11ULL, 0x000fe200088f4432ULL,
0x000000013b337824ULL, 0x100fe200078e0239ULL, 0x0000001c00327811ULL, 0x000fe200078fe8ffULL,
0x0000000143437824ULL, 0x000fe200078e0239ULL, 0x000000393c3b7210ULL, 0x000fe20007ffe0ffULL,
0x000000100d367825ULL, 0x000fe200078e0036ULL, 0x00000033383a7210ULL, 0x000fc40007f7e0ffULL,
0x0000003f38337210ULL, 0x000fe20007f1e0ffULL, 0x0000000132397824ULL, 0x040fe200078e0239ULL,
0x0000004338437210ULL, 0x000fe20007f3e0ffULL, 0x0000000132457824ULL, 0x040fe200078e0200ULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee23eULL, 0x0000000832487824ULL, 0x000fe200078e00ffULL,
0x0000003b38327210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff3f7224ULL, 0x000fe200018e06ffULL,
0x0000003d383b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff4a7224ULL, 0x000fe200000e06ffULL,
0x0000003938467210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200028e06ffULL,
0x00000004323c7c11ULL, 0x000fe2000f8a40ffULL, 0x000000100d347825ULL, 0x000fe200078e0034ULL,
0x0000000000397211ULL, 0x000fc400078fe8ffULL, 0xfffffff8484f7812ULL, 0x000fe200078ee245ULL,
0x000000ffff487224ULL, 0x000fe200008e06ffULL, 0x00000005323d7c11ULL, 0x000fe2000a8f443dULL,
0x000000ffff517224ULL, 0x000fe200018e06ffULL, 0x0000000433387c11ULL, 0x000fe4000f8040ffULL,
0x000000043a3e7c11ULL, 0x000fe2000f8840ffULL, 0x000000100d3c7825ULL, 0x000fe200078e003cULL,
0x0000000443327c11ULL, 0x000fe4000f8240ffULL, 0x0000000739457812ULL, 0x000fc400078ec0ffULL,
0x0000000533397c11ULL, 0x000fe400080f444aULL, 0x000000053a3f7c11ULL, 0x000fe4000a0f443fULL,
0x000000ffff4c7210ULL, 0x000fe200017fe4ffULL, 0x000000100d387825ULL, 0x000fe200078e0038ULL,
0x0000000543337c11ULL, 0x000fe400088f4448ULL, 0x000000043b3a7c11ULL, 0x000fe2000f8440ffULL,
0x0001300030487836ULL, 0x000fe20000000000ULL, 0x0ffffff845437812ULL, 0x000fe200078ef800ULL,
0x000000100d3e7825ULL, 0x000fe200078e003eULL, 0x0000000446307c11ULL, 0x000fc4000f8040ffULL,
0x000000053b3b7c11ULL, 0x000fe200090f444cULL, 0x0000001043437824ULL, 0x100fe200078e0248ULL,
0x0000004842497211ULL, 0x000fe200078e20ffULL, 0x0000001031457824ULL, 0x100fe200078e0248ULL,
0x0000000546317c11ULL, 0x000fe200080f4451ULL, 0x0000001040477824ULL, 0x100fe200078e0248ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036437faeULL, 0x0003e2000b901c46ULL,
0x0000001041417824ULL, 0x000fe400078e0248ULL, 0x000000100d3a7825ULL, 0x000fe200078e003aULL,
0x0000000034457faeULL, 0x0003e6000b901c46ULL, 0x000000104b4b7824ULL, 0x100fe200078e0248ULL,
0x000000003e477faeULL, 0x0003e2000b901c46ULL, 0x000000104d4d7824ULL, 0x000fc400078e0248ULL,
0x000000100d327825ULL, 0x000fe200078e0032ULL, 0x000000003c417faeULL, 0x0003e6000b901c46ULL,
0x000000104f4f7824ULL, 0x000fe200078e0248ULL, 0x000000003a497faeULL, 0x0003e2000b901c46ULL,
0x000000100d307825ULL, 0x000fc600078e0030ULL, 0x00000000384b7faeULL, 0x0003e8000b901c46ULL,
0x00000000324d7faeULL, 0x0003e8000b901c46ULL, 0x00000000304f7faeULL, 0x0003e4000b901c46ULL,
0x000000010f0d7812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffff0c5e7811ULL, 0x000fe400078e08ffULL, 0x000000010d00780cULL, 0x000fe20003f05070ULL,
0xffffffffff0d7424ULL, 0x000fc600078e00ffULL, 0x000000015e5e7807ULL, 0x000fca0004000000ULL,
0x000000010f0f7824ULL, 0x000fca00078e025eULL, 0x000000580f00720cULL, 0x000fda0003f06070ULL,
0x00008c00ff308b82ULL, 0x002e620000000a00ULL, 0x0000005e05338210ULL, 0x000fe40007ffe063ULL,
0xffffffe044327812ULL, 0x040fe200078ec0ffULL, 0x00000001ff357424ULL, 0x000fe400078e00ffULL,
0x0000000433308825ULL, 0x002fe200078e0030ULL, 0x0000001044337812ULL, 0x000fc800078ec0ffULL,
0x0000000b33327210ULL, 0x000fe20007ffe032ULL, 0x00000006300d8981ULL, 0x000322000c1e1900ULL,
0x0000000844337812ULL, 0x000fca00078ec0ffULL, 0x0000000132627824ULL, 0x000fc800078e0233ULL,
0x01b60835623479a7ULL, 0x0002a6000850003fULL, 0x0000000000307805ULL, 0x002fce0000015200ULL,
0x01b60835620075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ff00367202ULL, 0x000fce0000000f00ULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230377210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003732327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01b60835620075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000205c307824ULL, 0x000fe200078e00ffULL,
0x00000001ff4a7819ULL, 0x000fe20000011600ULL, 0x00000010004d7824ULL, 0x000fe400078e00ffULL,
0x000000ffff4f7224ULL, 0x000fe200078e0064ULL, 0xffffff8030307812ULL, 0x000fe400078ec0ffULL,
0x000000704d4d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c4a4a7812ULL, 0x000fe200078ec0ffULL,
0x000000010b4b7824ULL, 0x000fca00078e0230ULL, 0x0000004b4a307210ULL, 0x000fca0007ffe04dULL,
0x01b0000030317984ULL, 0x000e680000000800ULL, 0x01b2000030577984ULL, 0x0004a20000000800ULL,
0x000000643100720bULL, 0x002fda0003f1d000ULL, 0x0000000000327806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff32347812ULL, 0x000fda000782c0ffULL,
0x0000000000f49947ULL, 0x004fea0003800000ULL, 0x00000002ff337819ULL, 0x000fe4000001165cULL,
0x000000643100720bULL, 0x000fe40003f34000ULL, 0x0000005c3300720cULL, 0x000fe40003f45270ULL,
0x00000031644f7209ULL, 0x000fd20007810000ULL, 0x0000000000337806ULL, 0x000fe400008e0100ULL,
0x0000000b5c30a211ULL, 0x000fe400078e38ffULL, 0x0000991033327816ULL, 0x000fe400000000ffULL,
0x000000304a30a210ULL, 0x000fe40007ffe04dULL, 0x000000ff3200720cULL, 0x000fc60003f25270ULL,
0x01b4004f3000a388ULL, 0x0003f40000000800ULL, 0x0000000000b09947ULL, 0x002fea0003800000ULL,
0x8000004f64307221ULL, 0x000fe20000010000ULL, 0x000000ff33ff7812ULL, 0x040fe4000782c0ffULL,
0x0000ff0033ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL,
0x0000003000357308ULL, 0x0002ac0000000800ULL, 0x0000000000489947ULL, 0x000fea0003800000ULL,
0x00000002ff307819ULL, 0x002fcc0000011600ULL, 0x00001f3035307589ULL, 0x004e6400000e0000ULL,
0x0000003010107220ULL, 0x082fe20000410000ULL, 0x0000003011117220ULL, 0x080fe20000410000ULL,
0x0000003014147220ULL, 0x080fe20000410000ULL, 0x0000003015157220ULL, 0x080fe20000410000ULL,
0x0000003018187220ULL, 0x080fe20000410000ULL, 0x0000003019197220ULL, 0x080fe20000410000ULL,
0x000000301c1c7220ULL, 0x080fe20000410000ULL, 0x000000301d1d7220ULL, 0x080fe20000410000ULL,
0x0000003020207220ULL, 0x080fe20000410000ULL, 0x0000003021217220ULL, 0x080fe20000410000ULL,
0x0000003024247220ULL, 0x080fe20000410000ULL, 0x0000003025257220ULL, 0x080fe20000410000ULL,
0x0000003028287220ULL, 0x080fe20000410000ULL, 0x0000003029297220ULL, 0x080fe20000410000ULL,
0x000000302c2c7220ULL, 0x080fe20000410000ULL, 0x000000302d2d7220ULL, 0x000fce0000410000ULL,
0x0000003508087220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x0000000800307811ULL, 0x002fcc00078ff0ffULL, 0x00001f3035307589ULL, 0x000e6400000e0000ULL,
0x0000003012127220ULL, 0x082fe20000410000ULL, 0x0000003013137220ULL, 0x080fe20000410000ULL,
0x0000003016167220ULL, 0x080fe20000410000ULL, 0x0000003017177220ULL, 0x080fe20000410000ULL,
0x000000301a1a7220ULL, 0x080fe20000410000ULL, 0x000000301b1b7220ULL, 0x080fe20000410000ULL,
0x000000301e1e7220ULL, 0x080fe20000410000ULL, 0x000000301f1f7220ULL, 0x080fe20000410000ULL,
0x0000003022227220ULL, 0x080fe20000410000ULL, 0x0000003023237220ULL, 0x080fe20000410000ULL,
0x0000003026267220ULL, 0x080fe20000410000ULL, 0x0000003027277220ULL, 0x080fe20000410000ULL,
0x000000302a2a7220ULL, 0x080fe20000410000ULL, 0x000000302b2b7220ULL, 0x080fe20000410000ULL,
0x000000302e2e7220ULL, 0x080fe20000410000ULL, 0x000000302f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff34ff7812ULL, 0x000fda0007826033ULL, 0x8000004f31311221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b31311820ULL, 0x000fc80000410000ULL,
0x0000003100041308ULL, 0x000ea40000000800ULL, 0x0000000457571220ULL, 0x004fce0000410000ULL,
0x0000000700497812ULL, 0x000fe200078ec0ffULL, 0x000000025c477824ULL, 0x040fe200078e00ffULL,
0x00000001ff467819ULL, 0x000fe2000001165cULL, 0x000002005c327824ULL, 0x000fe200078e00ffULL,
0x0000000800457812ULL, 0x000fe200078ec0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000849507812ULL, 0x000fe200078ef800ULL, 0x0000400046557824ULL, 0x000fe200078e020bULL,
0x00000004ff517819ULL, 0x000fe40000011600ULL, 0x0000000745457812ULL, 0x000fe200078ef800ULL,
0x0000000850317824ULL, 0x000fe200078e00ffULL, 0x0000000447307812ULL, 0x002fe400078ec0ffULL,
0xfffff80032327812ULL, 0x000fe200078ec0ffULL, 0x0000000151347824ULL, 0x000fe200078e0245ULL,
0x0000003050307210ULL, 0x000fe20007ffe051ULL, 0x0000000845337824ULL, 0x040fe200078e00ffULL,
0x00000055064c7211ULL, 0x000fe200078e68ffULL, 0x0000000234607836ULL, 0x000fe20000000000ULL,
0xfffffff831317812ULL, 0x000fe200078ee230ULL, 0x0000000845307824ULL, 0x000fc400078e00ffULL,
0x00000004345f7836ULL, 0x000fe20000000000ULL, 0xfffffff833607812ULL, 0x000fe200078ee260ULL,
0x0000000845617824ULL, 0x000fe400078e00ffULL, 0x000000010b4e7824ULL, 0x000fe200078e0232ULL,
0xfffffff8305f7812ULL, 0x000fe200078ee25fULL, 0x00001000674c7824ULL, 0x000fe200078e024cULL,
0xfffffff861617812ULL, 0x000fe200078ee234ULL, 0x0000001031487824ULL, 0x000fe400078e024eULL,
0x000130004c4c7836ULL, 0x000fe20000000000ULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011600ULL, 0x00000004ff02723eULL, 0x000fe400000000ffULL,
0x0000000803317810ULL, 0x000fe40007ffe0ffULL, 0x0000541002307816ULL, 0x000fca0000000002ULL,
0x00001f0330037589ULL, 0x0002a800000e0000ULL, 0x00001f3130027589ULL, 0x0002e400000e0000ULL,
0x011000004830783bULL, 0x0022e20000000200ULL, 0x0000001061407824ULL, 0x100fe400078e024cULL,
0x00000010603c7824ULL, 0x000fe200078e024cULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000231317232ULL, 0x080fe40000000000ULL, 0x0000000233337232ULL, 0x000fce0000000000ULL,
0x0000000845367824ULL, 0x000fe200078e00ffULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x0000000634597836ULL, 0x000fe40000000000ULL, 0x000000105f387824ULL, 0x000fe200078e024cULL,
0x000000003c3c783bULL, 0x000fe20000004200ULL, 0x0000000446517824ULL, 0x000fe200078e0251ULL,
0xfffffff836597812ULL, 0x000fc600078ee259ULL, 0x000000003838783bULL, 0x000f620000004200ULL,
0x0000000251517810ULL, 0x000fe20007ffe050ULL, 0x0000001059347824ULL, 0x000fe200078e024cULL,
0x0000000350507819ULL, 0x000fc800000006ffULL, 0xfffffff850517812ULL, 0x000fe200078ee251ULL,
0x000000003434783bULL, 0x000f640000004200ULL, 0x000000403010723cULL, 0x02afec0000001810ULL,
0x000000423014723cULL, 0x000fec0000001814ULL, 0x000000383020723cULL, 0x000fec0000001820ULL,
0x000000343028723cULL, 0x004fe20000001828ULL, 0x0000001045397812ULL, 0x000fe200078efcffULL,
0x0000001051457824ULL, 0x000fc600078e024eULL, 0x0000003900537211ULL, 0x000fe200078fe0ffULL,
0x0000000839387824ULL, 0x040fe200078e00ffULL, 0x0000003c3018723cULL, 0x000fe20000001818ULL,
0x0000000839357824ULL, 0x040fe200078e00ffULL, 0x00000006534e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000839347824ULL, 0x040fe400078e00ffULL, 0x0000000253527836ULL, 0x000fe20000000000ULL,
0x0000003e301c723cULL, 0x000fe2000000181cULL, 0x0000000453517836ULL, 0x000fe20000000000ULL,
0xfffffff834537812ULL, 0x000fe200078ee253ULL, 0x0000000839397824ULL, 0x000fe200078e00ffULL,
0xfffffff835527812ULL, 0x000fc400078ee252ULL, 0xfffffff838517812ULL, 0x000fe200078ee251ULL,
0x0000003a3024723cULL, 0x000fe20000001824ULL, 0xfffffff8394e7812ULL, 0x000fe200078ee24eULL,
0x0000001053397824ULL, 0x100fe400078e024cULL, 0x0000001052407824ULL, 0x100fe400078e024cULL,
0x00000036302c723cULL, 0x000fe2000000182cULL, 0x00000010513c7824ULL, 0x000fe200078e024cULL,
0x011000004530783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000231317232ULL, 0x080fe40000000000ULL,
0x0000000233337232ULL, 0x000fce0000000000ULL, 0x000000104e347824ULL, 0x000fe200078e024cULL,
0x000000004040783bULL, 0x000ee20000004200ULL, 0x0000000857087221ULL, 0x000fe20000010000ULL,
0x000000ffff647224ULL, 0x000fe200078e004fULL, 0x0000000167677812ULL, 0x000fe200078e0cffULL,
0x000000003c3c783bULL, 0x000f680000004200ULL, 0x000000003938783bULL, 0x000f680000004200ULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x000000403018723cULL, 0x00cfec0000001818ULL,
0x00000042301c723cULL, 0x000fe2000000181cULL, 0x00000001ff407424ULL, 0x000fca00078e00ffULL,
0x0000003c3020723cULL, 0x022fec0000001820ULL, 0x0000003e3024723cULL, 0x000fec0000001824ULL,
0x000000383010723cULL, 0x000fec0000001810ULL, 0x0000003a3014723cULL, 0x000fe20000001814ULL,
0xfffffff847387812ULL, 0x000fca00078ec0ffULL, 0x000000343028723cULL, 0x000fe20000001828ULL,
0x000000010b477824ULL, 0x000fc800078e0238ULL, 0x01b6884047ff79a7ULL, 0x0003e2000850003fULL,
0x00000036302c723cULL, 0x000fee000000182cULL, 0x000000405b317811ULL, 0x000fc800078e40ffULL,
0x0000005a3100720cULL, 0x000fda0003f06070ULL, 0x0000004800c40947ULL, 0x002fea0003800000ULL,
0x000000015b337836ULL, 0x000fe20000000000ULL, 0x000000045c307819ULL, 0x000fe200000006ffULL,
0x0000840000047ab9ULL, 0x000fe40000000800ULL, 0x000000040d667c24ULL, 0x010fe2000f8e02ffULL,
0x0000000e3300720cULL, 0x000fe40003f06070ULL, 0xffffffe030307812ULL, 0x000fe200078ec0ffULL,
0x0000008066667824ULL, 0x000fc800078e00ffULL, 0x000001005b307824ULL, 0x000fc800078e0230ULL,
0x0000008030317836ULL, 0x000fca0000000000ULL, 0x0000006009347812ULL, 0x000fe200078ef831ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400e08947ULL, 0x000fea0003800000ULL,
0x000020005c327824ULL, 0x000fe200078e00ffULL, 0x000000315a427248ULL, 0x000fe20007fe0000ULL,
0x0000100007307824ULL, 0x000fe200078e00ffULL, 0x00000003ff697819ULL, 0x000fe20000011600ULL,
0x000000ffff317224ULL, 0x000fe200078e0a31ULL, 0x0000200032327812ULL, 0x000fe200078ec0ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000100030307812ULL, 0x000fe200078ec0ffULL,
0x0000000469437836ULL, 0x000fe20000000000ULL, 0x0000002042427446ULL, 0x000fe20003800031ULL,
0x0000000c69577836ULL, 0x000fe20000000000ULL, 0x0000003469317210ULL, 0x000fe20007ffe0ffULL,
0x0000001069677836ULL, 0x000fe20000000000ULL, 0x0000005530467210ULL, 0x000fe20007ffe032ULL,
0x0000000869557836ULL, 0x000fe20000000000ULL, 0x0000003166307210ULL, 0x000fe20007f1e0ffULL,
0x0000000143317824ULL, 0x000fc400078e0234ULL, 0x0000000155337824ULL, 0x100fe400078e0234ULL,
0x0000000157357824ULL, 0x100fe200078e0234ULL, 0x0000003166317210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff377224ULL, 0x000fe200000e06ffULL, 0x00000004303e7c11ULL, 0x000fe2000f8040ffULL,
0x0000001469657836ULL, 0x000fe20000000000ULL, 0x0000003366337210ULL, 0x000fe20007f5e0ffULL,
0x00000018695d7836ULL, 0x000fe20000000000ULL, 0x0000003566357210ULL, 0x000fe20007f7e0ffULL,
0x00000008064c7824ULL, 0x000fe200078e00ffULL, 0x00000005303f7c11ULL, 0x000fe200080f4437ULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0x000000ffff3a7210ULL, 0x000fe20000ffe4ffULL,
0x000000ffff367224ULL, 0x000fe200018e06ffULL, 0x00000004313c7c11ULL, 0x000fe2000f8040ffULL,
0x000000015d397824ULL, 0x100fe200078e0234ULL, 0x0000000433307c11ULL, 0x000fe2000f8240ffULL,
0x0000000165377824ULL, 0x000fe200078e0234ULL, 0x0000000435327c11ULL, 0x000fe2000f8440ffULL,
0x0001300046467836ULL, 0x000fe20000000000ULL, 0x00000005313d7c11ULL, 0x000fe200080f443aULL,
0x00000008436d7824ULL, 0x000fe200078e00ffULL, 0x0000000533317c11ULL, 0x000fc400088f4438ULL,
0x0000000535337c11ULL, 0x000fe200090f4436ULL, 0x0000000169357824ULL, 0x040fe200078e0200ULL,
0x000000426900720cULL, 0x000fe40003f06070ULL, 0x0000001c69697810ULL, 0x000fe40007ffe0ffULL,
0x00000007356b7812ULL, 0x000fe200078ec0ffULL, 0x0000000167357824ULL, 0x100fe200078e0234ULL,
0x000000084c417812ULL, 0x000fe200078ee249ULL, 0x00000001693b7824ULL, 0x000fe200078e0234ULL,
0x0ffffff86b6b7812ULL, 0x000fc400078ef800ULL, 0x0000003966397210ULL, 0x000fe20007f9e0ffULL,
0x00000010413e7825ULL, 0x000fe200078e003eULL, 0x0000003b663b7210ULL, 0x000fe40007f3e0ffULL,
0x0000003766377210ULL, 0x000fe20007f7e0ffULL, 0x000000106b6b7824ULL, 0x000fe200078e0246ULL,
0x0000003566357210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff4c7224ULL, 0x000fe200008e06ffULL,
0x000000ffff547210ULL, 0x000fe20001ffe4ffULL, 0x000000ffff507224ULL, 0x000fe200020e06ffULL,
0x000000043b3a7c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff567224ULL, 0x000fe200010e06ffULL,
0x0000000437367c11ULL, 0x000fe2000f8640ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e6b7faeULL, 0x0003e2000c101c46ULL, 0x0000000439387c11ULL, 0x000fe2000f8840ffULL,
0x00000010413c7825ULL, 0x000fe200078e003cULL, 0x0000000435347c11ULL, 0x000fc4000f8440ffULL,
0x000000053b3b7c11ULL, 0x000fe200088f444cULL, 0x00000001434c7824ULL, 0x000fe200078e0200ULL,
0x0000000537377c11ULL, 0x000fe200098f4454ULL, 0x0000000855547824ULL, 0x000fe200078e00ffULL,
0x0000000539397c11ULL, 0x000fe2000a0f4450ULL, 0x0000000157507824ULL, 0x100fe200078e0200ULL,
0x000000424300720cULL, 0x080fe20003f06070ULL, 0x0000000155437824ULL, 0x140fe200078e0200ULL,
0x000000425500720cULL, 0x000fe20003f26070ULL, 0x00000001673e7824ULL, 0x002fe200078e0200ULL,
0x0000000535357c11ULL, 0x000fe200090f4456ULL, 0x0000001041307825ULL, 0x000fe200078e0030ULL,
0x0000000357557819ULL, 0x000fc400000006ffULL, 0x000000425700720cULL, 0x080fe20003f46070ULL,
0x0000000867577824ULL, 0x040fe200078e00ffULL, 0x000000426700720cULL, 0x080fe20003f66070ULL,
0x000000085d677824ULL, 0x000fe200078e00ffULL, 0x000000426500720cULL, 0x080fe20003f86070ULL,
0x0000001041327825ULL, 0x000fe200078e0032ULL, 0x000000425d00720cULL, 0x080fe40003fa6070ULL,
0x000000426900720cULL, 0x000fe20003fc6070ULL, 0x0000000165427824ULL, 0x140fe200078e0200ULL,
0xfffffff86d3f7812ULL, 0x000fe200078ee24cULL, 0x0000000865657824ULL, 0x000fe200078e00ffULL,
0xfffffff855557812ULL, 0x000fe200078ee250ULL, 0x000000015d4c7824ULL, 0x100fe200078e0200ULL,
0xfffffff854437812ULL, 0x000fe200078ee243ULL, 0x0000000169507824ULL, 0x040fe200078e0200ULL,
0x0000000369697819ULL, 0x000fe200000006ffULL, 0x000000103f3f7824ULL, 0x100fe200078e0246ULL,
0xfffffff857577812ULL, 0x000fe200078ee23eULL, 0x0000001043437824ULL, 0x100fe200078e0246ULL,
0xfffffff8655d7812ULL, 0x000fe200078ee242ULL, 0x0000001055557824ULL, 0x100fe200078e0246ULL,
0xfffffff867657812ULL, 0x000fe200078ee24cULL, 0x0000001057577824ULL, 0x000fe200078e0246ULL,
0xfffffff869677812ULL, 0x000fe200078ee250ULL, 0x0000001041347825ULL, 0x000fe200078e0034ULL,
0x000000003c3f7faeULL, 0x0003e6000c101c46ULL, 0x000000105d5d7824ULL, 0x000fe200078e0246ULL,
0x0000000030437faeULL, 0x0003e2000c901c46ULL, 0x0000001041367825ULL, 0x000fc600078e0036ULL,
0x0000000032557faeULL, 0x0003e2000d101c46ULL, 0x0000001065657824ULL, 0x000fe400078e0246ULL,
0x0000001041387825ULL, 0x000fe200078e0038ULL, 0x0000000034577faeULL, 0x0003e6000d901c46ULL,
0x0000001067677824ULL, 0x000fe200078e0246ULL, 0x00000000365d7faeULL, 0x0003e2000e101c46ULL,
0x00000010413a7825ULL, 0x000fc600078e003aULL, 0x0000000038657faeULL, 0x0003e8000e901c46ULL,
0x000000003a677faeULL, 0x0003e2000f101c46ULL, 0x0000000400ac7947ULL, 0x000fea0003800000ULL,
0x0000100007307824ULL, 0x000fe200078e00ffULL, 0x0000000d5c317819ULL, 0x000fe200000006ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000400337811ULL, 0x000fe200078fe8ffULL,
0x0000000806647824ULL, 0x000fe200078e00ffULL, 0x0000000800357811ULL, 0x000fe400078fe8ffULL,
0x0000200031327812ULL, 0x000fe200078ec0ffULL, 0x0000000133507824ULL, 0x140fe200078e0200ULL,
0x0000100030307812ULL, 0x000fe200078ec0ffULL, 0x0000000833317824ULL, 0x000fe200078e00ffULL,
0x00000014003d7811ULL, 0x000fe200078fe8ffULL, 0x00000001354c7824ULL, 0x040fe200078e0200ULL,
0x0000005530557210ULL, 0x000fe20007ffe032ULL, 0x0000000835397824ULL, 0x000fe200078e00ffULL,
0xfffffff831507812ULL, 0x000fe200078ee250ULL, 0x000000013d417824ULL, 0x040fe200078e0200ULL,
0x0000003400317211ULL, 0x040fe200078fe8ffULL, 0x000000083d327824ULL, 0x000fe200078e00ffULL,
0x0000000c00377811ULL, 0x000fe200078fe8ffULL, 0x0001300055697836ULL, 0x000fe20000000000ULL,
0xfffffff8394c7812ULL, 0x000fc400078ee24cULL, 0x0000001000397811ULL, 0x040fe200078fe8ffULL,
0x0000000137467824ULL, 0x040fe200078e0200ULL, 0xfffffff832417812ULL, 0x000fe200078ee241ULL,
0x00000008373b7824ULL, 0x000fe200078e00ffULL, 0x0000001c003f7811ULL, 0x040fe200078fe8ffULL,
0x0000000839307824ULL, 0x000fe200078e00ffULL, 0x0000003166327210ULL, 0x000fe20007f1e0ffULL,
0x0000000133317824ULL, 0x100fe200078e0234ULL, 0x0000000039437210ULL, 0x000fe20007ffe0ffULL,
0x0000000135337824ULL, 0x100fe200078e0234ULL, 0x0000003437357210ULL, 0x000fe20007ffe0ffULL,
0x0000000139377824ULL, 0x100fe200078e0234ULL, 0x0000003166317210ULL, 0x000fe20007f3e0ffULL,
0x000000013f5d7824ULL, 0x040fe200078e0234ULL, 0xfffffff830437812ULL, 0x000fe200078ee243ULL,
0x000000013f427824ULL, 0x000fe200078e0200ULL, 0x000000ffff307210ULL, 0x000fe20000ffe4ffULL,
0x000000013d397824ULL, 0x000fe200078e0234ULL, 0x0000001800577811ULL, 0x000fe200078fe8ffULL,
0x000000083f3f7824ULL, 0x000fe200078e00ffULL, 0x00000004313c7c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff3d7224ULL, 0x000fe200000e06ffULL, 0x00000004323e7c11ULL, 0x040fe2000f8040ffULL,
0x0000000857367824ULL, 0x000fe200078e00ffULL, 0xfffffff83f427812ULL, 0x000fe200078ee242ULL,
0x0000001043437824ULL, 0x000fe200078e0269ULL, 0x00000005323f7c11ULL, 0x000fe200080f443dULL,
0x0000001041417824ULL, 0x000fe200078e0269ULL, 0x0000003366337210ULL, 0x000fc40007f1e0ffULL,
0xfffffff83b467812ULL, 0x000fe200078ee246ULL, 0x00000001573b7824ULL, 0x000fe200078e0200ULL,
0x00000005313d7c11ULL, 0x000fe200088f4430ULL, 0x000000ffff3a7224ULL, 0x000fe200000e06ffULL,
0x0000003566357210ULL, 0x000fe20007f3e0ffULL, 0x0000000157577824ULL, 0x000fe200078e0234ULL,
0x0000003766377210ULL, 0x000fe40007f5e0ffULL, 0x0000000433307c11ULL, 0x040fe2000f8040ffULL,
0x000000ffff387224ULL, 0x000fe200008e06ffULL, 0xfffffff8363b7812ULL, 0x000fe200078ee23bULL,
0x000000ffff367224ULL, 0x000fe200010e06ffULL, 0x0000000533317c11ULL, 0x000fc400080f443aULL,
0x0000000435327c11ULL, 0x000fe2000f8240ffULL, 0x000000103b677824ULL, 0x000fe200078e0269ULL,
0x0000003966397210ULL, 0x000fe40007f1e0ffULL, 0x0000000437347c11ULL, 0x000fe4000f8440ffULL,
0x0000000535337c11ULL, 0x000fe200088f4438ULL, 0x000000ffff547224ULL, 0x000fe200000e06ffULL,
0x0000000537357c11ULL, 0x000fe400090f4436ULL, 0x0000005766577210ULL, 0x000fc40007f3e0ffULL,
0x0000000000567211ULL, 0x000fe400078fe8ffULL, 0x0000000439367c11ULL, 0x040fe2000f8040ffULL,
0x000000ffff3a7224ULL, 0x000fe200008e06ffULL, 0x0000000756657812ULL, 0x000fe400078ec0ffULL,
0x0000000539377c11ULL, 0x000fe400080f4454ULL, 0x0000000457387c11ULL, 0x000fe4000f8240ffULL,
0x0000005d66547210ULL, 0x000fe20007f1e0ffULL, 0x000000104c5d7824ULL, 0x000fe200078e0269ULL,
0x00000008646d7812ULL, 0x000fc400078ee249ULL, 0x0ffffff865657812ULL, 0x000fe400078ef800ULL,
0x0000000557397c11ULL, 0x000fe200088f443aULL, 0x000000106d3e7825ULL, 0x000fe200078e003eULL,
0x000000ffff6b7210ULL, 0x000fe400007fe4ffULL, 0x00000004543a7c11ULL, 0x000fe2000f8040ffULL,
0x0000001065557824ULL, 0x100fe400078e0269ULL, 0x0000001050577824ULL, 0x000fe200078e0269ULL,
0x00000005543b7c11ULL, 0x000fe200080f446bULL, 0x000000106d3c7825ULL, 0x040fe200078e003cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e557faeULL, 0x0003e6000b901c46ULL,
0x000000106d307825ULL, 0x040fe200078e0030ULL, 0x000000003c577faeULL, 0x0003e6000b901c46ULL,
0x0000001046657824ULL, 0x000fe200078e0269ULL, 0x0000006942697211ULL, 0x000fe200078e20ffULL,
0x000000106d327825ULL, 0x040fe200078e0032ULL, 0x00000000305d7faeULL, 0x0003e6000b901c46ULL,
0x000000106d347825ULL, 0x040fe200078e0034ULL, 0x0000000032657faeULL, 0x0003e6000b901c46ULL,
0x000000106d367825ULL, 0x040fe200078e0036ULL, 0x0000000034437faeULL, 0x0003e6000b901c46ULL,
0x000000106d387825ULL, 0x040fe200078e0038ULL, 0x0000000036417faeULL, 0x0003e6000b901c46ULL,
0x000000106d3a7825ULL, 0x000fe200078e003aULL, 0x0000000038677faeULL, 0x0003e8000b901c46ULL,
0x000000003a697faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01b62840624079a7ULL, 0x0022a4000850003fULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x01b62841620075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff347224ULL, 0x000fce00078e00ffULL, 0x000000103400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230357210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003532327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000134347836ULL, 0x000fce0000000000ULL, 0x01b62841620075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x000000804d317810ULL, 0x000fe20007ffe04bULL,
0x000000ffff647224ULL, 0x000fc800078e004fULL, 0x000000014a317824ULL, 0x000fca00078e0231ULL,
0x01b0000031307984ULL, 0x000ea80000000800ULL, 0x01b2000031677984ULL, 0x0006e20000000800ULL,
0x0000004f3000720bULL, 0x004fda0003f1d000ULL, 0x0000000000327806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff32327812ULL, 0x000fda000782c0ffULL,
0x0000000000f49947ULL, 0x00afea0003800000ULL, 0x000000015c317811ULL, 0x000fe400078ff0ffULL,
0x0000004f3000720bULL, 0x0c0fe40003f34000ULL, 0x0000005c3100720cULL, 0x000fe40003f45270ULL,
0x0000004f30647209ULL, 0x000fd20007810000ULL, 0x0000000000337806ULL, 0x000fe400008e0100ULL,
0x000000805c31a824ULL, 0x000fca00078e020bULL, 0x000000314a35a210ULL, 0x000fe40007ffe04dULL,
0x0000991033317816ULL, 0x000fc600000000ffULL, 0x01b400643500a388ULL, 0x0003e20000000800ULL,
0x000000ff3100720cULL, 0x000fda0003f25270ULL, 0x0000000000b09947ULL, 0x002fea0003800000ULL,
0x0000004f64317221ULL, 0x000fe20000010100ULL, 0x000000ff33ff7812ULL, 0x040fe4000782c0ffULL,
0x0000ff0033ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b31317820ULL, 0x000fc80000410000ULL,
0x0000003100357308ULL, 0x0002ac0000000800ULL, 0x0000000000489947ULL, 0x000fea0003800000ULL,
0x00000002ff347819ULL, 0x000fca0000011600ULL, 0x00001f3435317589ULL, 0x006e6400000e0000ULL,
0x0000003110107220ULL, 0x082fe20000410000ULL, 0x0000003111117220ULL, 0x080fe20000410000ULL,
0x0000003114147220ULL, 0x080fe20000410000ULL, 0x0000003115157220ULL, 0x080fe20000410000ULL,
0x0000003118187220ULL, 0x080fe20000410000ULL, 0x0000003119197220ULL, 0x080fe20000410000ULL,
0x000000311c1c7220ULL, 0x080fe20000410000ULL, 0x000000311d1d7220ULL, 0x080fe20000410000ULL,
0x0000003120207220ULL, 0x080fe20000410000ULL, 0x0000003121217220ULL, 0x080fe20000410000ULL,
0x0000003124247220ULL, 0x080fe20000410000ULL, 0x0000003125257220ULL, 0x080fe20000410000ULL,
0x0000003128287220ULL, 0x080fe20000410000ULL, 0x0000003129297220ULL, 0x080fe20000410000ULL,
0x000000312c2c7220ULL, 0x080fe20000410000ULL, 0x000000312d2d7220ULL, 0x000fce0000410000ULL,
0x0000003508087220ULL, 0x004fe20000410000ULL, 0x000000000048a947ULL, 0x000fec0003800000ULL,
0x0000000800347811ULL, 0x000fca00078ff0ffULL, 0x00001f3435317589ULL, 0x002e6400000e0000ULL,
0x0000003112127220ULL, 0x082fe20000410000ULL, 0x0000003113137220ULL, 0x080fe20000410000ULL,
0x0000003116167220ULL, 0x080fe20000410000ULL, 0x0000003117177220ULL, 0x080fe20000410000ULL,
0x000000311a1a7220ULL, 0x080fe20000410000ULL, 0x000000311b1b7220ULL, 0x080fe20000410000ULL,
0x000000311e1e7220ULL, 0x080fe20000410000ULL, 0x000000311f1f7220ULL, 0x080fe20000410000ULL,
0x0000003122227220ULL, 0x080fe20000410000ULL, 0x0000003123237220ULL, 0x080fe20000410000ULL,
0x0000003126267220ULL, 0x080fe20000410000ULL, 0x0000003127277220ULL, 0x080fe20000410000ULL,
0x000000312a2a7220ULL, 0x080fe20000410000ULL, 0x000000312b2b7220ULL, 0x080fe20000410000ULL,
0x000000312e2e7220ULL, 0x080fe20000410000ULL, 0x000000312f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff32ff7812ULL, 0x000fda0007826033ULL, 0x0000003064301221ULL, 0x000fe20000010100ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b30301820ULL, 0x000fc80000410000ULL,
0x0000003000041308ULL, 0x000ea40000000800ULL, 0x0000000467671220ULL, 0x004fce0000410000ULL,
0x00000001ff467819ULL, 0x000fe2000001165cULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000400046657824ULL, 0x000fe200078e020bULL, 0x0000000c07687819ULL, 0x000fc600000006ffULL,
0x0000200006317824ULL, 0x002fe200078e0265ULL, 0x0000100068687812ULL, 0x000fc800078e0cffULL,
0x00013000314c7810ULL, 0x000fe20007ffe068ULL, 0x0000000000188947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe40000011600ULL, 0x00000004ff02723eULL, 0x000fc600000000ffULL,
0x0000000803317836ULL, 0x000fe20000000000ULL, 0x0000541002307816ULL, 0x000fca0000000002ULL,
0x00001f0330037589ULL, 0x0002a800000e0000ULL, 0x00001f3130027589ULL, 0x0002e400000e0000ULL,
0x011800004830783bULL, 0x0022e20000000200ULL, 0x00000010615d7824ULL, 0x100fe400078e024cULL,
0x0000001060577824ULL, 0x100fe400078e024cULL, 0x000000105f567824ULL, 0x000fe200078e024cULL,
0x0000000000108947ULL, 0x000fec0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000231317232ULL, 0x080fe40000000000ULL,
0x0000000233337232ULL, 0x000fce0000000000ULL, 0x0000001059557824ULL, 0x100fe200078e024cULL,
0x000000005d40783bULL, 0x000f220000004200ULL, 0x0000004c53547211ULL, 0x000fe200078e20ffULL,
0x0000001052507824ULL, 0x100fe400078e024cULL, 0x00000000573c783bULL, 0x000f620000004200ULL,
0x00000010514f7824ULL, 0x000fc600078e024cULL, 0x000000005638783bULL, 0x000f680000004200ULL,
0x000000005534783bULL, 0x000f620000004200ULL, 0x000000403010723cULL, 0x018fec0000001810ULL,
0x000000423014723cULL, 0x000fec0000001814ULL, 0x0000003c3018723cULL, 0x022fec0000001818ULL,
0x0000003e301c723cULL, 0x000fec000000181cULL, 0x000000383020723cULL, 0x000fec0000001820ULL,
0x0000003a3024723cULL, 0x000fec0000001824ULL, 0x000000343028723cULL, 0x004fec0000001828ULL,
0x00000036302c723cULL, 0x000fe2000000182cULL, 0x011800004530783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000231317232ULL, 0x080fe40000000000ULL, 0x0000000233337232ULL, 0x000fce0000000000ULL,
0x000000104e4c7824ULL, 0x000fe200078e024cULL, 0x000000005440783bULL, 0x000ee20000004200ULL,
0x0000000867087221ULL, 0x000fe20000010000ULL, 0x0000000107677812ULL, 0x000fe400078ec0ffULL,
0x00000000503c783bULL, 0x000f280000004200ULL, 0x000000004f38783bULL, 0x000f680000004200ULL,
0x000000004c34783bULL, 0x000f220000004200ULL, 0x000000403010723cULL, 0x00cfec0000001810ULL,
0x000000423014723cULL, 0x000fe20000001814ULL, 0x00000001ff407424ULL, 0x000fc800078e00ffULL,
0x01b6904047ff79a7ULL, 0x0005e2000850003fULL, 0x0000003c3018723cULL, 0x010fec0000001818ULL,
0x0000003e301c723cULL, 0x000fec000000181cULL, 0x000000383020723cULL, 0x022fec0000001820ULL,
0x0000003a3024723cULL, 0x000fec0000001824ULL, 0x000000343028723cULL, 0x000fec0000001828ULL,
0x00000036302c723cULL, 0x000fee000000182cULL, 0x000000805b317811ULL, 0x000fc800078e40ffULL,
0x0000005a3100720cULL, 0x000fda0003f06070ULL, 0x0000003000740947ULL, 0x004fea0003800000ULL,
0x000000015b0f7836ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000105c0d7824ULL, 0x000fc600078e00ffULL, 0x0000000e0f00720cULL, 0x000fe40003f06070ULL,
0xffffffe00d307812ULL, 0x000fca00078ec0ffULL, 0x000001005b0d7824ULL, 0x000fca00078e0230ULL,
0x000000c00d0d7810ULL, 0x000fc80007ffe0ffULL, 0x0000006009367812ULL, 0x000fe200078ef80dULL,
0x0000000400d88947ULL, 0x000fec0003800000ULL, 0x00000003ff6d7819ULL, 0x000fe20000011600ULL,
0x000020005c307824ULL, 0x000fe200078e00ffULL, 0x0000000d5a427248ULL, 0x000fe20007fe0000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0a0dULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x000000046d417836ULL, 0x000fe20000000000ULL, 0x0000200030437812ULL, 0x000fe200078ec0ffULL,
0x000000086d0f7836ULL, 0x000fe20000000000ULL, 0x0000002042427446ULL, 0x000fe2000380000dULL,
0x000000016d0d7824ULL, 0x100fe200078e0236ULL, 0x0000006568437210ULL, 0x000fe20007ffe043ULL,
0x0000000141317824ULL, 0x100fe200078e0236ULL, 0x000000186d6b7810ULL, 0x000fe20007ffe0ffULL,
0x000000010f337824ULL, 0x100fe200078e0236ULL, 0x0000000d66357210ULL, 0x000fe20007f1e0ffULL,
0x0000000c6d657836ULL, 0x000fe20000000000ULL, 0x0000003166317210ULL, 0x000fe20007f3e0ffULL,
0x000000106d677836ULL, 0x000fe20000000000ULL, 0x00000033660d7210ULL, 0x000fe20007f5e0ffULL,
0x000000146d697836ULL, 0x000fe20000000000ULL, 0x000000ffff3c7210ULL, 0x000fe200007fe4ffULL,
0x000000ffff3a7224ULL, 0x000fe200008e06ffULL, 0x0000000431327c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0x000000040d307c11ULL, 0x000fe2000f8440ffULL,
0x0000000167377824ULL, 0x000fe200078e0236ULL, 0x0000000531337c11ULL, 0x000fe200088f443aULL,
0x0000000169397824ULL, 0x000fe200078e0236ULL, 0x000000050d317c11ULL, 0x000fe200090f4438ULL,
0x000000016d0d7824ULL, 0x000fe200078e0200ULL, 0x0000000435347c11ULL, 0x000fe2000f8040ffULL,
0x000000016b3b7824ULL, 0x100fe200078e0236ULL, 0x0000003966687210ULL, 0x000fe20007fbe0ffULL,
0x0001300043437836ULL, 0x000fe20000000000ULL, 0x000000070d3f7812ULL, 0x000fe200078ec0ffULL,
0x00000001650d7824ULL, 0x000fe200078e0236ULL, 0x0000000535357c11ULL, 0x000fe200080f443cULL,
0x00000008063c7824ULL, 0x000fe200078e00ffULL, 0x000000426d00720cULL, 0x000fe20003f06070ULL,
0x0000001c6d6d7836ULL, 0x000fe20000000000ULL, 0x0000000d660d7210ULL, 0x000fe20007f3e0ffULL,
0x0000000841717824ULL, 0x000fe200078e00ffULL, 0x0ffffff83f3a7812ULL, 0x000fe200078ef800ULL,
0x000000016d3d7824ULL, 0x040fe200078e0236ULL, 0x000000ffff387210ULL, 0x000fe20000ffe4ffULL,
0x000000086d6c7824ULL, 0x000fe200078e00ffULL, 0x000000040d367c11ULL, 0x000fe2000f8640ffULL,
0x000000103a6f7824ULL, 0x000fe200078e0243ULL, 0x00000037663f7210ULL, 0x000fc40007f9e0ffULL,
0x0000003b663b7210ULL, 0x000fe40007f5e0ffULL, 0x000000050d377c11ULL, 0x000fe200098f4438ULL,
0x000000ffff6a7224ULL, 0x000fe200020e06ffULL, 0x0000003d66667210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff467224ULL, 0x000fe200010e06ffULL, 0x000000083c0d7812ULL, 0x000fe200078ee249ULL,
0x000000ffff3d7224ULL, 0x000fe200028e06ffULL, 0x0000000466387c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x000000043b3a7c11ULL, 0x000fe2000f8240ffULL,
0x000000100d347825ULL, 0x000fe200078e0034ULL, 0x00000004683c7c11ULL, 0x000fc4000f8840ffULL,
0x000000053b3b7c11ULL, 0x000fe200088f4446ULL, 0x0000000141467824ULL, 0x000fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000346f7faeULL, 0x0003e2000c101c46ULL,
0x0000000566397c11ULL, 0x000fe200090f4439ULL, 0x000000080f667824ULL, 0x000fe200078e00ffULL,
0x000000424100720cULL, 0x080fe20003f06070ULL, 0x000000100d327825ULL, 0x000fe200078e0032ULL,
0x000000043f3e7c11ULL, 0x000fe4000f8640ffULL, 0x00000005683d7c11ULL, 0x000fe2000a0f443dULL,
0x0000000865687824ULL, 0x000fe200078e00ffULL, 0x000000420f00720cULL, 0x000fe20003f26070ULL,
0x000000100d307825ULL, 0x000fe200078e0030ULL, 0x000000000f417210ULL, 0x000fc40007ffe0ffULL,
0x000000053f3f7c11ULL, 0x000fe200098f446aULL, 0x00000001650f7824ULL, 0x140fe200078e0200ULL,
0x000000426500720cULL, 0x080fe20003f46070ULL, 0x0000000169357824ULL, 0x102fe200078e0200ULL,
0x000000426700720cULL, 0x080fe20003f66070ULL, 0x000000086b6a7824ULL, 0x000fe200078e00ffULL,
0x000000426900720cULL, 0x080fe20003f86070ULL, 0x000000016d657824ULL, 0x000fe200078e0200ULL,
0x000000426b00720cULL, 0x080fe20003fa6070ULL, 0x000000100d367825ULL, 0x000fe200078e0036ULL,
0x000000426d00720cULL, 0x000fc40003fc6070ULL, 0xfffffff866347812ULL, 0x000fe200078ee241ULL,
0x0000000867667824ULL, 0x040fe200078e00ffULL, 0xfffffff868427812ULL, 0x000fe200078ee20fULL,
0x00000001670f7824ULL, 0x000fe200078e0200ULL, 0xfffffff871467812ULL, 0x000fe200078ee246ULL,
0x0000000869687824ULL, 0x000fe200078e00ffULL, 0x000000006b417210ULL, 0x000fe20007ffe0ffULL,
0x000000100d3e7825ULL, 0x040fe200078e003eULL, 0xfffffff866667812ULL, 0x000fe400078ee20fULL,
0xfffffff868687812ULL, 0x000fe200078ee235ULL, 0x00000010460f7824ULL, 0x100fe200078e0243ULL,
0xfffffff86a6a7812ULL, 0x000fe200078ee241ULL, 0x0000001034357824ULL, 0x100fe200078e0243ULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee265ULL, 0x0000001042417824ULL, 0x100fe200078e0243ULL,
0x0000004368677211ULL, 0x000fe200078e20ffULL, 0x0000001066657824ULL, 0x000fe200078e0243ULL,
0x00000000320f7faeULL, 0x0003e2000c101c46ULL, 0x000000100d3c7825ULL, 0x000fc600078e003cULL,
0x0000000030357faeULL, 0x0003e2000c901c46ULL, 0x000000106a697824ULL, 0x000fe400078e0243ULL,
0x000000100d3a7825ULL, 0x040fe200078e003aULL, 0x0000000036417faeULL, 0x0003e6000d101c46ULL,
0x000000106c437824ULL, 0x000fe200078e0243ULL, 0x000000003e657faeULL, 0x0003e2000d901c46ULL,
0x000000100d387825ULL, 0x000fc600078e0038ULL, 0x000000003c677faeULL, 0x0003e8000e101c46ULL,
0x000000003a697faeULL, 0x0003e8000e901c46ULL, 0x0000000038437faeULL, 0x0003e2000f101c46ULL,
0x0000000400a47947ULL, 0x000fea0003800000ULL, 0x000020005c0d7824ULL, 0x000fe200078e00ffULL,
0x0000000400317811ULL, 0x040fe200078fe8ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000c00397811ULL, 0x040fe400078fe8ffULL, 0x000020000d0d7812ULL, 0x000fe200078ec0ffULL,
0x00000001310f7824ULL, 0x140fe200078e0200ULL, 0x0000000800377811ULL, 0x000fe200078fe8ffULL,
0x0000000831307824ULL, 0x000fe200078e00ffULL, 0x0000006568657210ULL, 0x000fe20007ffe00dULL,
0x0000000839337824ULL, 0x000fe200078e00ffULL, 0x0000000039467210ULL, 0x000fe20007ffe0ffULL,
0x0000000137417824ULL, 0x040fe200078e0200ULL, 0xfffffff8300d7812ULL, 0x000fe200078ee20fULL,
0x0000000837327824ULL, 0x000fe200078e00ffULL, 0x00000036000f7211ULL, 0x000fc400078fe8ffULL,
0x00000014003d7811ULL, 0x040fe400078fe8ffULL, 0x0000000f660f7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff833467812ULL, 0x000fe200078ee246ULL, 0x000000013d427824ULL, 0x040fe200078e0200ULL,
0xfffffff832417812ULL, 0x000fe200078ee241ULL, 0x000000083d337824ULL, 0x000fe200078e00ffULL,
0x00000010003b7811ULL, 0x000fe400078fe8ffULL, 0x000000ffff307210ULL, 0x000fc400007fe4ffULL,
0x000000040f327c11ULL, 0x000fe2000f8040ffULL, 0x000000013b437824ULL, 0x040fe200078e0200ULL,
0x00000018003f7811ULL, 0x040fe200078fe8ffULL, 0x000000083b347824ULL, 0x000fe200078e00ffULL,
0xfffffff833427812ULL, 0x000fe400078ee242ULL, 0x000000050f337c11ULL, 0x000fe200080f4430ULL,
0x00000001310f7824ULL, 0x100fe200078e0236ULL, 0x0000001c00677811ULL, 0x000fe200078fe8ffULL,
0x0000000137317824ULL, 0x000fe200078e0236ULL, 0xfffffff834437812ULL, 0x000fe200078ee243ULL,
0x000000013f357824ULL, 0x040fe200078e0200ULL, 0x0000000f66347210ULL, 0x000fe20007f7e0ffULL,
0x000000083f387824ULL, 0x000fe200078e00ffULL, 0x00000003066a7819ULL, 0x000fe200000006ffULL,
0x0000000139377824ULL, 0x100fe200078e0236ULL, 0x0000000434307c11ULL, 0x000fe2000f8c40ffULL,
0x000000013b397824ULL, 0x100fe200078e0236ULL, 0xfffffff838357812ULL, 0x000fe200078ee235ULL,
0x000000013d3b7824ULL, 0x100fe200078e0236ULL, 0x0000003166387210ULL, 0x000fe20007f5e0ffULL,
0x000000013f3d7824ULL, 0x100fe200078e0236ULL, 0x000000ffff317210ULL, 0x000fe20001ffe4ffULL,
0x00000001673f7824ULL, 0x040fe200078e0236ULL, 0x0000003766367210ULL, 0x000fe20007f1e0ffULL,
0x0000000867687824ULL, 0x000fe200078e00ffULL, 0x0000003966397210ULL, 0x000fc40007f3e0ffULL,
0x0000003b66377210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e06ffULL,
0x0000003d660f7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200010e06ffULL,
0x0000003f66667210ULL, 0x000fe20007fbe0ffULL, 0x00000001673f7824ULL, 0x000fe200078e0200ULL,
0x0000000534317c11ULL, 0x000fe2000b0f4431ULL, 0x000000ffff347224ULL, 0x000fe200008e06ffULL,
0x00000004383e7c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff6f7224ULL, 0x000fe200028e06ffULL,
0x00000004363c7c11ULL, 0x000fc4000f8040ffULL, 0x00000004393a7c11ULL, 0x040fe4000f8240ffULL,
0xfffffff868677812ULL, 0x000fe200078ee23fULL, 0x000000ffff687224ULL, 0x000fe200018e06ffULL,
0x00000005383f7c11ULL, 0x000fe400090f443dULL, 0x00000005363d7c11ULL, 0x000fe400080f443bULL,
0x00000005393b7c11ULL, 0x000fe200088f4434ULL, 0x000000ffff347224ULL, 0x000fe200020e06ffULL,
0x0000000000397211ULL, 0x000fc400078fe8ffULL, 0x0000000437387c11ULL, 0x000fe4000f8040ffULL,
0x000000040f367c11ULL, 0x000fe4000f8240ffULL, 0x0000000739697812ULL, 0x000fe400078ec0ffULL,
0x0000000537397c11ULL, 0x000fe200080f4468ULL, 0x0001300065687836ULL, 0x000fe20000000000ULL,
0x000000050f377c11ULL, 0x000fe400088f4434ULL, 0x000000086a0f7812ULL, 0x000fe200078ee249ULL,
0x000000100d0d7824ULL, 0x100fe200078e0268ULL, 0x0ffffff869697812ULL, 0x000fe200078ef800ULL,
0x00000010356d7824ULL, 0x000fe200078e0268ULL, 0x0000000466347c11ULL, 0x000fe2000f8040ffULL,
0x000000100f327825ULL, 0x000fe200078e0032ULL, 0x00000068426b7211ULL, 0x000fc400078e20ffULL,
0x0000000566357c11ULL, 0x000fe200080f446fULL, 0x0000001069697824ULL, 0x000fe400078e0268ULL,
0x000000100f307825ULL, 0x000fc600078e0030ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000032697faeULL, 0x0003e2000b901c46ULL, 0x0000001041417824ULL, 0x000fe400078e0268ULL,
0x000000100f3e7825ULL, 0x040fe200078e003eULL, 0x00000000300d7faeULL, 0x0003e6000b901c46ULL,
0x0000001046657824ULL, 0x000fe200078e0268ULL, 0x000000003e417faeULL, 0x0003e2000b901c46ULL,
0x000000100f3c7825ULL, 0x000fc800078e003cULL, 0x0000001043437824ULL, 0x000fe200078e0268ULL,
0x000000003c657faeULL, 0x0003e2000b901c46ULL, 0x000000100f3a7825ULL, 0x000fc800078e003aULL,
0x000000100f387825ULL, 0x040fe200078e0038ULL, 0x000000003a437faeULL, 0x0003e6000b901c46ULL,
0x000000100f367825ULL, 0x000fe200078e0036ULL, 0x00000000386b7faeULL, 0x0003e6000b901c46ULL,
0x0000001067677824ULL, 0x000fe200078e0268ULL, 0x00000000366d7faeULL, 0x0003e2000b901c46ULL,
0x000000100f347825ULL, 0x000fca00078e0034ULL, 0x0000000034677faeULL, 0x0003e4000b901c46ULL,
0x00000001630f7824ULL, 0x002fe200078e025eULL, 0xffffffff0c307811ULL, 0x000fe200078e08ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000010f0d7812ULL, 0x000fc800078ec0ffULL,
0x000000010d00780cULL, 0x000fe20003f05070ULL, 0xffffffffff0d7424ULL, 0x000fc600078e00ffULL,
0x0000000130307807ULL, 0x000fca0004000000ULL, 0x000000010f0f7824ULL, 0x000fca00078e0230ULL,
0x000000580f00720cULL, 0x000fda0003f06070ULL, 0x00008c00ff308b82ULL, 0x000e620000000a00ULL,
0x000000010f338824ULL, 0x000fc800078e0205ULL, 0x0000000433308825ULL, 0x002fca00078e0030ULL,
0x00000006300d8981ULL, 0x000322000c1e1900ULL, 0x01b64840624079a7ULL, 0x0002a4000850003fULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0xffffffe044307812ULL, 0x042fe400078ec0ffULL,
0x0000001044317812ULL, 0x040fe400078ec0ffULL, 0x0000000844627812ULL, 0x000fe400078ec0ffULL,
0x0000000b31317210ULL, 0x000fca0007ffe030ULL, 0x0000000131627824ULL, 0x000fc800078e0262ULL,
0x01b64841620075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ff00347202ULL, 0x000fce0000000f00ULL, 0x000000103400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x0000003032357210ULL, 0x000fca0007f1e1ffULL, 0x0000000131317824ULL, 0x000fe200000e0e33ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff307819ULL, 0x000fc80000011431ULL, 0x0000003530307211ULL, 0x000fca00078110ffULL,
0x000000ffff317224ULL, 0x000fca00000e0631ULL, 0x0000000230307819ULL, 0x000fc80000001231ULL,
0x000000300000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000134347836ULL, 0x000fce0000000000ULL, 0x01b64841620075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000001004d317810ULL, 0x000fe20007ffe04bULL,
0x000000ffff657224ULL, 0x000fc800078e0064ULL, 0x000000014a317824ULL, 0x000fca00078e0231ULL,
0x01b0000031337984ULL, 0x000e680000000800ULL, 0x01b2000031677984ULL, 0x0004a20000000800ULL,
0x000000643300720bULL, 0x002fda0003f1d000ULL, 0x0000000000327806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff32ff7812ULL, 0x000fda000782c0ffULL,
0x0000000000f89947ULL, 0x004fea0003800000ULL, 0x000000025c317811ULL, 0x000fe400078ff0ffULL,
0x000000643300720bULL, 0x000fe40003f14000ULL, 0x0000005c3100720cULL, 0x000fd60003f25270ULL,
0x0000000000357806ULL, 0x000fe400000e0100ULL, 0x000000805c319824ULL, 0x000fe200078e020bULL,
0x0000003364309209ULL, 0x000fc80007810000ULL, 0x000000314a379210ULL, 0x000fe40007ffe04dULL,
0x0000991035317816ULL, 0x000fc600000000ffULL, 0x01b4003037009388ULL, 0x0003e20000000800ULL,
0x000000ff3100720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000003364317209ULL, 0x040fe40007810000ULL, 0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0035ff7812ULL, 0x000fe2000782c0ffULL, 0x8000003164307221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL, 0x0000003000317308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff307819ULL, 0x002fcc0000011600ULL,
0x00001f3031307589ULL, 0x004e6400000e0000ULL, 0x0000003010107220ULL, 0x082fe20000410000ULL,
0x0000003011117220ULL, 0x080fe20000410000ULL, 0x0000003014147220ULL, 0x080fe20000410000ULL,
0x0000003015157220ULL, 0x080fe20000410000ULL, 0x0000003018187220ULL, 0x080fe20000410000ULL,
0x0000003019197220ULL, 0x080fe20000410000ULL, 0x000000301c1c7220ULL, 0x080fe20000410000ULL,
0x000000301d1d7220ULL, 0x080fe20000410000ULL, 0x0000003020207220ULL, 0x080fe20000410000ULL,
0x0000003021217220ULL, 0x080fe20000410000ULL, 0x0000003024247220ULL, 0x080fe20000410000ULL,
0x0000003025257220ULL, 0x080fe20000410000ULL, 0x0000003028287220ULL, 0x080fe20000410000ULL,
0x0000003029297220ULL, 0x080fe20000410000ULL, 0x000000302c2c7220ULL, 0x080fe20000410000ULL,
0x000000302d2d7220ULL, 0x000fce0000410000ULL, 0x0000003108087220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x0000000800307811ULL, 0x002fcc00078ff0ffULL,
0x00001f3031307589ULL, 0x000e6400000e0000ULL, 0x0000003012127220ULL, 0x082fe20000410000ULL,
0x0000003013137220ULL, 0x080fe20000410000ULL, 0x0000003016167220ULL, 0x080fe20000410000ULL,
0x0000003017177220ULL, 0x080fe20000410000ULL, 0x000000301a1a7220ULL, 0x080fe20000410000ULL,
0x000000301b1b7220ULL, 0x080fe20000410000ULL, 0x000000301e1e7220ULL, 0x080fe20000410000ULL,
0x000000301f1f7220ULL, 0x080fe20000410000ULL, 0x0000003022227220ULL, 0x080fe20000410000ULL,
0x0000003023237220ULL, 0x080fe20000410000ULL, 0x0000003026267220ULL, 0x080fe20000410000ULL,
0x0000003027277220ULL, 0x080fe20000410000ULL, 0x000000302a2a7220ULL, 0x080fe20000410000ULL,
0x000000302b2b7220ULL, 0x080fe20000410000ULL, 0x000000302e2e7220ULL, 0x080fe20000410000ULL,
0x000000302f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe40007800832ULL,
0x0000003364657209ULL, 0x000fd60007810000ULL, 0x8000006533330221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b33330820ULL, 0x000fc80000410000ULL, 0x0000003300040308ULL, 0x000ea40000000800ULL,
0x0000000467670220ULL, 0x004fce0000410000ULL, 0x00000001ff467819ULL, 0x000fe2000001165cULL,
0x00001000075e7824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000b46637211ULL, 0x000fe400078e70ffULL, 0x000010005e5e7812ULL, 0x000fc600078ec0ffULL,
0x0000200006317824ULL, 0x000fca00078e0263ULL, 0x0001300031647810ULL, 0x000fe20007ffe05eULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe40000011600ULL,
0x00000004ff02723eULL, 0x000fc600000000ffULL, 0x0000000803317836ULL, 0x000fe20000000000ULL,
0x0000541002307816ULL, 0x002fca0000000002ULL, 0x00001f0330037589ULL, 0x0002a800000e0000ULL,
0x00001f3130027589ULL, 0x0002e400000e0000ULL, 0x012000004830783bULL, 0x0022e20000000200ULL,
0x0000001061407824ULL, 0x100fe400078e0264ULL, 0x00000010603c7824ULL, 0x100fe400078e0264ULL,
0x000000105f387824ULL, 0x000fe200078e0264ULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000231317232ULL, 0x080fe40000000000ULL, 0x0000000233337232ULL, 0x000fce0000000000ULL,
0x0000001059347824ULL, 0x100fe200078e0264ULL, 0x000000004040783bULL, 0x000f680000004200ULL,
0x000000003c3c783bULL, 0x000f680000004200ULL, 0x000000003838783bULL, 0x000f680000004200ULL,
0x000000003434783bULL, 0x000f640000004200ULL, 0x000000403010723cULL, 0x02afec0000001810ULL,
0x000000423014723cULL, 0x000fe20000001814ULL, 0x0000001053407824ULL, 0x000fca00078e0264ULL,
0x0000003c3018723cULL, 0x000fec0000001818ULL, 0x0000003e301c723cULL, 0x000fe2000000181cULL,
0x00000064523c7211ULL, 0x000fca00078e20ffULL, 0x000000383020723cULL, 0x004fec0000001820ULL,
0x0000003a3024723cULL, 0x000fe20000001824ULL, 0x0000001051387824ULL, 0x000fca00078e0264ULL,
0x000000343028723cULL, 0x000fec0000001828ULL, 0x00000036302c723cULL, 0x000fe2000000182cULL,
0x012000004530783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000231317232ULL, 0x080fe40000000000ULL,
0x0000000233337232ULL, 0x000fce0000000000ULL, 0x000000104e347824ULL, 0x000fe200078e0264ULL,
0x000000004040783bULL, 0x000ee20000004200ULL, 0x0000000867087221ULL, 0x000fe20000010000ULL,
0x0000000107677812ULL, 0x000fe200078e0cffULL, 0x000000ffff647224ULL, 0x000fe200078e0065ULL,
0x000000003c3c783bULL, 0x000f680000004200ULL, 0x000000003838783bULL, 0x000f680000004200ULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x000000403010723cULL, 0x00cfec0000001810ULL,
0x000000423014723cULL, 0x000fe20000001814ULL, 0x00000001ff407424ULL, 0x000fc800078e00ffULL,
0x01b6984047ff79a7ULL, 0x0005e2000850003fULL, 0x0000003c3018723cULL, 0x022fec0000001818ULL,
0x0000003e301c723cULL, 0x000fec000000181cULL, 0x000000383020723cULL, 0x000fec0000001820ULL,
0x0000003a3024723cULL, 0x000fec0000001824ULL, 0x000000343028723cULL, 0x000fec0000001828ULL,
0x00000036302c723cULL, 0x000fee000000182cULL, 0x000000c05b317811ULL, 0x000fc800078e40ffULL,
0x0000005a3100720cULL, 0x000fda0003f06070ULL, 0x0000001400f40947ULL, 0x004fea0003800000ULL,
0x000000010c317824ULL, 0x000fe200078e025bULL, 0x0000840000047ab9ULL, 0x000fe40000000800ULL,
0x000000040d377c24ULL, 0x010fe4000f8e02ffULL, 0x0000000131337836ULL, 0x000fe40000000000ULL,
0x0000010031307824ULL, 0x000fe200078e020aULL, 0x0000000737377819ULL, 0x000fe400000006ffULL,
0x0000000e3300720cULL, 0x000fc40003f06070ULL, 0x0000006009397812ULL, 0x000fe200078ef830ULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000000400d88947ULL, 0x000fea0003800000ULL,
0x00000003ff607819ULL, 0x000fe20000011600ULL, 0x0000000806327824ULL, 0x000fe200078e00ffULL,
0x000000305a417248ULL, 0x000fe20007fe0000ULL, 0x000000ffff307224ULL, 0x000fe200078e0a30ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000860427836ULL, 0x000fe20000000000ULL,
0x0000000832497812ULL, 0x000fe200078ee249ULL, 0x0000000460437836ULL, 0x000fe20000000000ULL,
0x0000002041417446ULL, 0x000fe20003800030ULL, 0x000020005c317824ULL, 0x000fe200078e00ffULL,
0x0000003942347210ULL, 0x000fe20007ffe0ffULL, 0x0000000143327824ULL, 0x100fe200078e0239ULL,
0x00000018604e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000160307824ULL, 0x100fe200078e0239ULL,
0x0000003437337210ULL, 0x000fe20007f5e0ffULL, 0x0000000c60647836ULL, 0x000fe20000000000ULL,
0x00002000313b7812ULL, 0x000fe200078ec0ffULL, 0x0000001460527836ULL, 0x000fe20000000000ULL,
0x0000003237317210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x0000003037357210ULL, 0x000fe20007f1e0ffULL, 0x000000014e3c7824ULL, 0x000fe200078e0239ULL,
0x0000000433327c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff387224ULL, 0x000fe200008e06ffULL,
0x0000000431307c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff3a7224ULL, 0x000fe200000e06ffULL,
0x0000000533337c11ULL, 0x000fe200090f4436ULL, 0x0000000160367824ULL, 0x100fe200078e0200ULL,
0x0000000435347c11ULL, 0x000fe2000f8040ffULL, 0x0000000143597824ULL, 0x000fe200078e0200ULL,
0x000000635e517210ULL, 0x000fe20007ffe03bULL, 0x00000010605e7836ULL, 0x000fe20000000000ULL,
0x0000000535357c11ULL, 0x000fe200080f443aULL, 0x00000001523a7824ULL, 0x100fe200078e0239ULL,
0x00000007363b7812ULL, 0x000fe200078ec0ffULL, 0x0000000164367824ULL, 0x100fe200078e0239ULL,
0x000000416000720cULL, 0x000fe20003f06070ULL, 0x0000001c60607836ULL, 0x000fe20000000000ULL,
0x0000000531317c11ULL, 0x000fe200088f4438ULL, 0x000000015e387824ULL, 0x100fe200078e0239ULL,
0x0000003637537210ULL, 0x000fe20007f3e0ffULL, 0x00000001603e7824ULL, 0x000fe200078e0239ULL,
0x0ffffff83b667812ULL, 0x000fe200078ef800ULL, 0x0001300051517836ULL, 0x000fe20000000000ULL,
0x0000003837397210ULL, 0x000fe20007f9e0ffULL, 0x0000001049347825ULL, 0x000fe200078e0034ULL,
0x000000ffff387210ULL, 0x000fc40000ffe4ffULL, 0x0000000453367c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff6c7224ULL, 0x000fe200020e06ffULL, 0x0000003c373d7210ULL, 0x000fe20007f5e0ffULL,
0x00000001645f7824ULL, 0x000fe200078e0200ULL, 0x0000003e373f7210ULL, 0x000fe20007f3e0ffULL,
0x0000001049307825ULL, 0x000fe200078e0030ULL, 0x0000003a373b7210ULL, 0x000fe40007fbe0ffULL,
0x0000000553377c11ULL, 0x000fe200098f4438ULL, 0x0000001066537824ULL, 0x000fe200078e0251ULL,
0x0000000439387c11ULL, 0x000fe2000f8640ffULL, 0x000000ffff687224ULL, 0x000fe200010e06ffULL,
0x000000043f3e7c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff667224ULL, 0x000fe200008e06ffULL,
0x000000043d3c7c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff6a7224ULL, 0x000fe200028e06ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034537faeULL, 0x0003e2000c101c46ULL,
0x000000043b3a7c11ULL, 0x000fe2000f8840ffULL, 0x0000001049327825ULL, 0x000fe200078e0032ULL,
0x000000053f3f7c11ULL, 0x000fc400090f4466ULL, 0x000000053d3d7c11ULL, 0x000fe200088f4468ULL,
0x0000000843667824ULL, 0x040fe200078e00ffULL, 0x000000414300720cULL, 0x080fe20003f06070ULL,
0x0000001049367825ULL, 0x000fe200078e0036ULL, 0x000000414200720cULL, 0x0c0fe40003f26070ULL,
0x0000000042437210ULL, 0x000fe20007ffe0ffULL, 0x0000000842427824ULL, 0x000fe200078e00ffULL,
0x0000000539397c11ULL, 0x000fe200098f446cULL, 0x000000015e357824ULL, 0x002fe200078e0200ULL,
0x000000416400720cULL, 0x0c0fe20003f46070ULL, 0x0000000864647824ULL, 0x000fe200078e00ffULL,
0x000000053b3b7c11ULL, 0x000fe2000a0f446aULL, 0x0000000160537824ULL, 0x000fe200078e0200ULL,
0x000000415e00720cULL, 0x0c0fe20003f66070ULL, 0x000000085e5e7824ULL, 0x000fe200078e00ffULL,
0x000000415200720cULL, 0x080fe20003f86070ULL, 0x0000001049387825ULL, 0x000fe200078e0038ULL,
0x000000414e00720cULL, 0x000fc40003fa6070ULL, 0x000000416000720cULL, 0x000fe20003fc6070ULL,
0x0000000152417824ULL, 0x040fe200078e0200ULL, 0xfffffff866347812ULL, 0x000fe200078ee259ULL,
0x0000000852527824ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee243ULL,
0x000000084e667824ULL, 0x000fe200078e00ffULL, 0x000000004e437210ULL, 0x000fe20007ffe0ffULL,
0x0000000860607824ULL, 0x000fe200078e00ffULL, 0xfffffff864647812ULL, 0x000fe200078ee25fULL,
0x00000010493a7825ULL, 0x000fe200078e003aULL, 0xfffffff85e4e7812ULL, 0x000fc400078ee235ULL,
0xfffffff852527812ULL, 0x000fe200078ee241ULL, 0x0000001034357824ULL, 0x100fe200078e0251ULL,
0xfffffff8665e7812ULL, 0x000fe200078ee243ULL, 0x0000001042417824ULL, 0x100fe200078e0251ULL,
0xfffffff860607812ULL, 0x000fe200078ee253ULL, 0x0000001064437824ULL, 0x100fe200078e0251ULL,
0x0000005152597211ULL, 0x000fe200078e20ffULL, 0x000000104e537824ULL, 0x100fe200078e0251ULL,
0x0000000030357faeULL, 0x0003e2000c101c46ULL, 0x000000105e5f7824ULL, 0x000fe400078e0251ULL,
0x00000010493c7825ULL, 0x040fe200078e003cULL, 0x0000000032417faeULL, 0x0003e6000c901c46ULL,
0x0000001060517824ULL, 0x000fe200078e0251ULL, 0x0000000036437faeULL, 0x0003e2000d101c46ULL,
0x00000010493e7825ULL, 0x000fc600078e003eULL, 0x0000000038537faeULL, 0x0003e8000d901c46ULL,
0x000000003a597faeULL, 0x0003e8000e101c46ULL, 0x000000003c5f7faeULL, 0x0003e8000e901c46ULL,
0x000000003e517faeULL, 0x0003e2000f101c46ULL, 0x0000000400a47947ULL, 0x000fea0003800000ULL,
0x000020005c307824ULL, 0x000fe200078e00ffULL, 0x0000000400317811ULL, 0x000fe200078fe8ffULL,
0x0000000806327824ULL, 0x000fe200078e00ffULL, 0x0000000c00357811ULL, 0x000fe200078fe8ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000200030307812ULL, 0x000fe200078ec0ffULL,
0x0000000131417824ULL, 0x100fe200078e0200ULL, 0x0000000832497812ULL, 0x000fe200078ee249ULL,
0x0000000135437824ULL, 0x000fe200078e0200ULL, 0x000000635e5e7210ULL, 0x000fe20007ffe030ULL,
0x0000000831307824ULL, 0x000fe200078e00ffULL, 0x0000001000367811ULL, 0x040fe200078fe8ffULL,
0x0000000835327824ULL, 0x000fe200078e00ffULL, 0x0000000800347811ULL, 0x000fe200078fe8ffULL,
0x000130005e5e7836ULL, 0x000fe20000000000ULL, 0xfffffff830417812ULL, 0x000fe200078ee241ULL,
0x00000001364e7824ULL, 0x100fe200078e0200ULL, 0x0000003900307211ULL, 0x000fe200078fe8ffULL,
0x00000008363b7824ULL, 0x000fe200078e00ffULL, 0xfffffff832437812ULL, 0x000fe200078ee243ULL,
0x0000000134427824ULL, 0x000fe200078e0200ULL, 0x0000003037327210ULL, 0x000fe20007f1e0ffULL,
0x0000000131307824ULL, 0x000fe200078e0239ULL, 0x0000001400387811ULL, 0x000fe200078fe8ffULL,
0x0000001041417824ULL, 0x100fe200078e025eULL, 0xfffffff83b4e7812ULL, 0x000fe200078ee24eULL,
0x0000001043437824ULL, 0x000fe200078e025eULL, 0x0000003037307210ULL, 0x000fe20007f3e0ffULL,
0x0000000138527824ULL, 0x000fe200078e0200ULL, 0x0000000334337819ULL, 0x000fe200000006ffULL,
0x00000008383b7824ULL, 0x000fe200078e00ffULL, 0x00000018003c7811ULL, 0x000fe200078fe8ffULL,
0x000000ffff317224ULL, 0x000fe200008e06ffULL, 0x00000004303a7c11ULL, 0x000fe2000f8240ffULL,
0x000000104e5f7824ULL, 0x000fe200078e025eULL, 0xfffffff833427812ULL, 0x000fe200078ee242ULL,
0x000000083c607824ULL, 0x000fe200078e00ffULL, 0xfffffff83b527812ULL, 0x000fe200078ee252ULL,
0x000000ffff337224ULL, 0x000fe200000e06ffULL, 0x00000005303b7c11ULL, 0x000fe200088f4431ULL,
0x0000000134307824ULL, 0x100fe200078e0239ULL, 0x000000003c517210ULL, 0x000fe20007ffe0ffULL,
0x0000000136347824ULL, 0x100fe200078e0239ULL, 0x00000004323e7c11ULL, 0x000fe2000f8040ffULL,
0x0000000138367824ULL, 0x000fe200078e0239ULL, 0x0000001c00317811ULL, 0x000fe200078fe8ffULL,
0x00000010493a7825ULL, 0x000fe200078e003aULL, 0xfffffff860517812ULL, 0x000fc400078ee251ULL,
0x00000005323f7c11ULL, 0x000fe200080f4433ULL, 0x0000000135327824ULL, 0x100fe200078e0239ULL,
0x000000393c387210ULL, 0x000fe20007ffe0ffULL, 0x0000000131607824ULL, 0x040fe200078e0239ULL,
0x0000003037397210ULL, 0x000fe20007f7e0ffULL, 0x00000001313d7824ULL, 0x040fe200078e0200ULL,
0x0000003437337210ULL, 0x000fe20007f5e0ffULL, 0x0000000831647824ULL, 0x000fe200078e00ffULL,
0x00000004393c7c11ULL, 0x000fe2000f8840ffULL, 0x000000ffff347224ULL, 0x000fe200018e06ffULL,
0x0000003237327210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff667224ULL, 0x000fe200010e06ffULL,
0xfffffff864637812ULL, 0x000fe200078ee23dULL, 0x00000010493e7825ULL, 0x000fe200078e003eULL,
0x00000005393d7c11ULL, 0x000fc4000a0f4434ULL, 0x0000003637357210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff317224ULL, 0x000fe200028e06ffULL, 0x0000000000397211ULL, 0x000fe200078fe8ffULL,
0x0000001042597824ULL, 0x000fe200078e025eULL, 0x0000003837387210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff647224ULL, 0x000fe200000e06ffULL, 0x0000000432307c11ULL, 0x000fe2000f8a40ffULL,
0x00000010493c7825ULL, 0x000fe200078e003cULL, 0x0000006037607210ULL, 0x000fe40007f7e0ffULL,
0x0000000739397812ULL, 0x000fe200078ec0ffULL, 0x0000001051517824ULL, 0x100fe200078e025eULL,
0x000000ffff377210ULL, 0x000fe20000ffe4ffULL, 0x0000001063637824ULL, 0x000fe200078e025eULL,
0x0000000435347c11ULL, 0x000fc4000f8040ffULL, 0x0000000438367c11ULL, 0x000fe4000f8240ffULL,
0x0000000532317c11ULL, 0x000fe4000a8f4431ULL, 0x0000000433327c11ULL, 0x000fe4000f8440ffULL,
0x0ffffff839537812ULL, 0x000fe200078ef800ULL, 0x000000ffff397224ULL, 0x000fe200018e06ffULL,
0x0000000535357c11ULL, 0x000fe200080f4464ULL, 0x0000001049307825ULL, 0x000fe200078e0030ULL,
0x0000000538377c11ULL, 0x000fc400088f4437ULL, 0x0000000460387c11ULL, 0x040fe2000f8040ffULL,
0x0000001053537824ULL, 0x000fe200078e025eULL, 0x0000000533337c11ULL, 0x000fe200090f4466ULL,
0x0000001049347825ULL, 0x040fe200078e0034ULL, 0x0000000560397c11ULL, 0x000fe400080f4439ULL,
0x0000005e52617211ULL, 0x000fe200078e20ffULL, 0x0000001049327825ULL, 0x040fe200078e0032ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e537faeULL, 0x0003e6000b901c46ULL,
0x0000001049367825ULL, 0x040fe200078e0036ULL, 0x000000003a417faeULL, 0x0003e6000b901c46ULL,
0x0000001049387825ULL, 0x000fe200078e0038ULL, 0x000000003c597faeULL, 0x0003e8000b901c46ULL,
0x0000000030437faeULL, 0x0003e8000b901c46ULL, 0x00000000325f7faeULL, 0x0003e8000b901c46ULL,
0x0000000034617faeULL, 0x0003e8000b901c46ULL, 0x0000000036517faeULL, 0x0003e8000b901c46ULL,
0x0000000038637faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x01b66840624079a7ULL, 0x0022a4000850003fULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x01b66841620075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff347224ULL, 0x000fce00078e00ffULL, 0x000000103400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230357210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003532327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000134347836ULL, 0x000fce0000000000ULL, 0x01b66841620075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x000001804d4b7810ULL, 0x000fe40007ffe04bULL,
0x0000006500647202ULL, 0x000fc60000000f00ULL, 0x000000014a4b7824ULL, 0x000fca00078e024bULL,
0x01b000004b307984ULL, 0x000ea80000000800ULL, 0x01b200004b497984ULL, 0x0006e20000000800ULL,
0x000000653000720bULL, 0x004fda0003f1d000ULL, 0x0000000000327806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff32ff7812ULL, 0x000fda000782c0ffULL,
0x0000000000f09947ULL, 0x00afea0003800000ULL, 0x000000035c317811ULL, 0x000fe400078ff0ffULL,
0x000000653000720bULL, 0x0c0fe40003f14000ULL, 0x0000005c3100720cULL, 0x000fe40003f25270ULL,
0x0000006530647209ULL, 0x000fd20007810000ULL, 0x0000000000337806ULL, 0x000fe400000e0100ULL,
0x000000805c319824ULL, 0x000fca00078e020bULL, 0x000000314a4d9210ULL, 0x000fe40007ffe04dULL,
0x0000991033317816ULL, 0x000fc600000000ffULL, 0x01b400644d009388ULL, 0x0003e20000000800ULL,
0x000000ff3100720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x0000006564317221ULL, 0x000fe20000010100ULL, 0x000000ff33ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0033ff7812ULL, 0x000fe2000782c0ffULL, 0x3fb8aa3b31317820ULL, 0x000fc80000410000ULL,
0x0000003100357308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff347819ULL, 0x000fca0000011600ULL, 0x00001f3435317589ULL, 0x006e6400000e0000ULL,
0x0000003110107220ULL, 0x082fe20000410000ULL, 0x0000003111117220ULL, 0x080fe20000410000ULL,
0x0000003114147220ULL, 0x080fe20000410000ULL, 0x0000003115157220ULL, 0x080fe20000410000ULL,
0x0000003118187220ULL, 0x080fe20000410000ULL, 0x0000003119197220ULL, 0x080fe20000410000ULL,
0x000000311c1c7220ULL, 0x080fe20000410000ULL, 0x000000311d1d7220ULL, 0x080fe20000410000ULL,
0x0000003120207220ULL, 0x080fe20000410000ULL, 0x0000003121217220ULL, 0x080fe20000410000ULL,
0x0000003124247220ULL, 0x080fe20000410000ULL, 0x0000003125257220ULL, 0x080fe20000410000ULL,
0x0000003128287220ULL, 0x080fe20000410000ULL, 0x0000003129297220ULL, 0x080fe20000410000ULL,
0x000000312c2c7220ULL, 0x080fe20000410000ULL, 0x000000312d2d7220ULL, 0x000fce0000410000ULL,
0x0000003508087220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x0000000800347811ULL, 0x000fca00078ff0ffULL, 0x00001f3435317589ULL, 0x002e6400000e0000ULL,
0x0000003112127220ULL, 0x082fe20000410000ULL, 0x0000003113137220ULL, 0x080fe20000410000ULL,
0x0000003116167220ULL, 0x080fe20000410000ULL, 0x0000003117177220ULL, 0x080fe20000410000ULL,
0x000000311a1a7220ULL, 0x080fe20000410000ULL, 0x000000311b1b7220ULL, 0x080fe20000410000ULL,
0x000000311e1e7220ULL, 0x080fe20000410000ULL, 0x000000311f1f7220ULL, 0x080fe20000410000ULL,
0x0000003122227220ULL, 0x080fe20000410000ULL, 0x0000003123237220ULL, 0x080fe20000410000ULL,
0x0000003126267220ULL, 0x080fe20000410000ULL, 0x0000003127277220ULL, 0x080fe20000410000ULL,
0x000000312a2a7220ULL, 0x080fe20000410000ULL, 0x000000312b2b7220ULL, 0x080fe20000410000ULL,
0x000000312e2e7220ULL, 0x080fe20000410000ULL, 0x000000312f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff33ff7812ULL, 0x000fda0007800832ULL, 0x0000003064300221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b30300820ULL, 0x000fc80000410000ULL, 0x0000003000040308ULL, 0x000ea40000000800ULL,
0x0000000449490220ULL, 0x004fce0000410000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000000188947ULL, 0x000fea0003800000ULL, 0x00000002ff037819ULL, 0x000fe40000011600ULL,
0x00000004ff02723eULL, 0x000fc600000000ffULL, 0x0000000803317836ULL, 0x002fe20000000000ULL,
0x0000541002307816ULL, 0x000fca0000000002ULL, 0x00001f0330037589ULL, 0x0002a800000e0000ULL,
0x00001f3130027589ULL, 0x0002e400000e0000ULL, 0x012800004830783bULL, 0x0022e20000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000231317232ULL, 0x080fe40000000000ULL,
0x0000000233337232ULL, 0x000fce0000000000ULL, 0x000000005d40783bULL, 0x000f280000004200ULL,
0x00000000573c783bULL, 0x000f680000004200ULL, 0x000000005638783bULL, 0x000f680000004200ULL,
0x000000005534783bULL, 0x000f620000004200ULL, 0x000000403010723cULL, 0x018fec0000001810ULL,
0x000000423014723cULL, 0x000fec0000001814ULL, 0x0000003c3018723cULL, 0x022fec0000001818ULL,
0x0000003e301c723cULL, 0x000fec000000181cULL, 0x000000383020723cULL, 0x000fec0000001820ULL,
0x0000003a3024723cULL, 0x000fec0000001824ULL, 0x000000343028723cULL, 0x004fec0000001828ULL,
0x00000036302c723cULL, 0x000fe2000000182cULL, 0x012800004530783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000231317232ULL, 0x080fe40000000000ULL, 0x0000000233337232ULL, 0x000fce0000000000ULL,
0x000000004c34783bULL, 0x000ee20000004200ULL, 0x0000000849087221ULL, 0x000fe20000010000ULL,
0x0000000107677812ULL, 0x000fe400078ec0ffULL, 0x000000005440783bULL, 0x000f280000004200ULL,
0x00000000503c783bULL, 0x000f680000004200ULL, 0x000000004f38783bULL, 0x000f620000004200ULL,
0x000000343028723cULL, 0x00cfec0000001828ULL, 0x000000403010723cULL, 0x010fe20000001810ULL,
0x00000001ff347424ULL, 0x000fc800078e00ffULL, 0x01b6a03447ff79a7ULL, 0x0005e2000850003fULL,
0x000000423014723cULL, 0x000fec0000001814ULL, 0x0000003c3018723cULL, 0x022fec0000001818ULL,
0x0000003e301c723cULL, 0x000fec000000181cULL, 0x000000383020723cULL, 0x000fec0000001820ULL,
0x0000003a3024723cULL, 0x000fec0000001824ULL, 0x00000036302c723cULL, 0x004fde000000182cULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000010c5b7824ULL, 0x000fca00078e025bULL,
0x0000000e5b00720cULL, 0x000fda0003f06070ULL, 0xffffff9400a88947ULL, 0x000fea000383ffffULL,
0x0000000000027919ULL, 0x000e620000002500ULL, 0x000000ffff317224ULL, 0x000fe400078e002dULL,
0x000000ffff307224ULL, 0x000fe200078e002cULL, 0x00000028002c7202ULL, 0x000fe20000000f00ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0029ULL, 0x000000ffff287224ULL, 0x000fe400078e0027ULL,
0x000000ffff297224ULL, 0x000fe400078e0026ULL, 0x000000ffff277224ULL, 0x000fc400078e0025ULL,
0x000000ffff267224ULL, 0x000fe400078e0024ULL, 0x000000ffff247224ULL, 0x000fe400078e0023ULL,
0x000000ffff257224ULL, 0x000fe200078e0022ULL, 0x0000002000227202ULL, 0x000fe20000000f00ULL,
0x000000ffff237224ULL, 0x000fe400078e0021ULL, 0x000000ffff207224ULL, 0x000fe400078e001fULL,
0x000000ffff217224ULL, 0x000fc400078e001eULL, 0x000000ffff1f7224ULL, 0x000fe400078e001dULL,
0x000000ffff1e7224ULL, 0x000fe400078e001cULL, 0x000000ffff1c7224ULL, 0x000fe400078e001bULL,
0x000000ffff1d7224ULL, 0x000fe200078e001aULL, 0x0000000e0200720cULL, 0x002fe20003f06070ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0019ULL, 0x00000018001a7202ULL, 0x000fe20000000f00ULL,
0x000000ffff0e7224ULL, 0x000fc400078e0017ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff187224ULL, 0x000fe400078e0013ULL, 0x000000ffff0f7224ULL, 0x000fc800078e0012ULL,
0x0000000000c80947ULL, 0x000fea0003800000ULL, 0x0180000008007836ULL, 0x000fca0000000000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x000083d000047802ULL, 0x000fce0000000f00ULL,
0x000000a800f47944ULL, 0x010fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000800037308ULL, 0x000e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000008ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fce0000000003ULL, 0x0000000000047919ULL, 0x000ea40000000000ULL,
0x00000002ff037819ULL, 0x004fe40000011604ULL, 0x0000000804057811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0300037589ULL, 0x000ea800000e0000ULL,
0x00001f0500047589ULL, 0x000ee200000e0000ULL, 0x0000001003107220ULL, 0x044fe20000410000ULL,
0x0000001103117220ULL, 0x040fe20000410000ULL, 0x0000001403147220ULL, 0x040fe20000410000ULL,
0x0000001503157220ULL, 0x040fe20000410000ULL, 0x0000001a031a7220ULL, 0x040fe20000410000ULL,
0x0000001b031b7220ULL, 0x040fe20000410000ULL, 0x0000001e031e7220ULL, 0x040fe20000410000ULL,
0x0000001f031f7220ULL, 0x040fe20000410000ULL, 0x0000002203227220ULL, 0x040fe20000410000ULL,
0x0000002303237220ULL, 0x040fe20000410000ULL, 0x0000002603267220ULL, 0x040fe20000410000ULL,
0x0000002703277220ULL, 0x040fe20000410000ULL, 0x0000002c032c7220ULL, 0x040fe20000410000ULL,
0x0000002d032d7220ULL, 0x040fe20000410000ULL, 0x0000003003307220ULL, 0x040fe20000410000ULL,
0x0000003103317220ULL, 0x000fe20000410000ULL, 0x0000000f040f7220ULL, 0x048fe20000410000ULL,
0x0000001804187220ULL, 0x040fe20000410000ULL, 0x0000001904197220ULL, 0x040fe20000410000ULL,
0x0000000e040e7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x000fce0000410000ULL, 0x0000000000077919ULL, 0x000ea20000000000ULL,
0x000000190e19723eULL, 0x000fe200000000ffULL, 0x00000800460e7824ULL, 0x000fe200078e00ffULL,
0x0000000b060b7211ULL, 0x000fe200078e60ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000101110723eULL, 0x000fc400000000ffULL, 0x0000000f1818723eULL, 0x000fe400000000ffULL,
0x000000141511723eULL, 0x000fe400000000ffULL, 0x000000222314723eULL, 0x000fe400000000ffULL,
0x000000262715723eULL, 0x000fe400000000ffULL, 0x000000303117723eULL, 0x000fe400000000ffULL,
0x000000010c00780cULL, 0x000fc40003f05270ULL, 0x00000003ff047819ULL, 0x104fe20000011607ULL,
0x000000010a0f7824ULL, 0x000fe200078e0207ULL, 0xfffffff8ff037812ULL, 0x000fe400078ee207ULL,
0x0000000304007812ULL, 0x000fe400078ec0ffULL, 0x0000000303127819ULL, 0x040fe200000006ffULL,
0x0000000803057836ULL, 0x000fe40000000000ULL, 0x0000000803137824ULL, 0x000fe400078e00ffULL,
0x0000000100037824ULL, 0x000fc400078e0203ULL, 0x0000000100097824ULL, 0x000fe400078e0205ULL,
0x0000000403007836ULL, 0x000fe40000000000ULL, 0x0000000805167824ULL, 0x040fe400078e00ffULL,
0x0000000805327824ULL, 0x000fe200078e00ffULL, 0xfffffff813057812ULL, 0x000fe200078ee200ULL,
0x0000000c030d7836ULL, 0x010fe20000000000ULL, 0xfffffff812037812ULL, 0x000fe200078ee203ULL,
0x000000010b007824ULL, 0x000fe200078e020eULL, 0xfffffff816097812ULL, 0x000fc400078ee209ULL,
0xfffffff8320d7812ULL, 0x000fe200078ee20dULL, 0x0000001003037824ULL, 0x100fe200078e0200ULL,
0x0000001a1b12723eULL, 0x000fe200000000ffULL, 0x0000001005057824ULL, 0x100fe200078e0200ULL,
0x0000001e1f13723eULL, 0x000fe200000000ffULL, 0x0000001009097824ULL, 0x100fe200078e0200ULL,
0x0000002c2d16723eULL, 0x000fe200000000ffULL, 0x000000100d0d7824ULL, 0x000fe200078e0200ULL,
0x0000001d1c1a723eULL, 0x000fe200000000ffULL, 0x0000001003007844ULL, 0x000fe20000000200ULL,
0x00000021201b723eULL, 0x000fc400000000ffULL, 0x00000025241c723eULL, 0x000fe200000000ffULL,
0x0000001405007844ULL, 0x000fe20000000200ULL, 0x00000029281d723eULL, 0x000fe400000000ffULL,
0x0000002a2b1e723eULL, 0x000fe200000000ffULL, 0x0000001809007844ULL, 0x000fe20000000200ULL,
0x0000002e2f1f723eULL, 0x000fe400000000ffULL, 0x0000000b0f207211ULL, 0x000fc600078e20ffULL,
0x0000001c0d007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000020247984ULL, 0x000ea80000000c00ULL, 0x00040000202c7984ULL, 0x000ee80000000c00ULL,
0x0008000020287984ULL, 0x000f280000000c00ULL, 0x000c000020307984ULL, 0x000f620000000c00ULL,
0x200000ff27277230ULL, 0x004fc40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fe40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x200000ff2f2f7230ULL, 0x008fe40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fc40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x012fe40000000000ULL, 0x0000002a26267230ULL, 0x000fe40000000000ULL,
0x0000002925257230ULL, 0x000fe40000000000ULL, 0x0000002824247230ULL, 0x000fe40000000000ULL,
0x000000332f2f7230ULL, 0x020fc40000000000ULL, 0x000000322e2e7230ULL, 0x000fe20000000000ULL,
0x0000002420007388ULL, 0x0003e20000000c00ULL, 0x000000312d2d7230ULL, 0x000fe40000000000ULL,
0x000000302c2c7230ULL, 0x000fca0000000000ULL, 0x0004002c20007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002400948947ULL, 0x000fea0003800000ULL,
0x00009200ff037b82ULL, 0x000ea20000000800ULL, 0x00000000001d7919ULL, 0x000ee20000002700ULL,
0x0000000000187919ULL, 0x000eec0000002600ULL, 0x00008400ff1a7b82ULL, 0x000ea20000000800ULL,
0x0000000020107984ULL, 0x00092e0000000c00ULL, 0x00009600ff147b82ULL, 0x000f620000000a00ULL,
0x000000031a037224ULL, 0x004fc800078e02ffULL, 0x0000000c03167224ULL, 0x040fe200078e02ffULL,
0x0000000f03237811ULL, 0x000fe200078e10ffULL, 0x0000001a1d1d7224ULL, 0x008fc600078e0218ULL,
0xfffffff023237812ULL, 0x000fe200078ec0ffULL, 0x0000000c1d0d7224ULL, 0x000fc800078e02ffULL,
0x0000008016057824ULL, 0x040fe400078e0223ULL, 0x000000010d027824ULL, 0x000fe400078e0202ULL,
0x0000008016167824ULL, 0x000fc800078e0205ULL, 0x0000007f16037836ULL, 0x000fca0000000000ULL,
0xffffff8003037812ULL, 0x000fc800078ec0ffULL, 0x0000001403177210ULL, 0x020fc80007f1e0ffULL,
0x0000001702167211ULL, 0x000fe200078258ffULL, 0x000000ffff097224ULL, 0x000fe200000e0615ULL,
0x0000000146ff7812ULL, 0x000fc8000780f85cULL, 0x0000000902177211ULL, 0x000fe400008f5cffULL,
0x00000014231c7210ULL, 0x000fe20007f3e0ffULL, 0x0000040006167825ULL, 0x000fc800078e0016ULL,
0x000000ffff1e7224ULL, 0x000fe400008e0615ULL, 0x000000100f167825ULL, 0x000fe200078e0016ULL,
0x0000000000400947ULL, 0x012fec0003800000ULL, 0x00000010070f7824ULL, 0x000fe200078e00ffULL,
0x00000001ff187819ULL, 0x000fe40000011607ULL, 0x0000000702097819ULL, 0x000fe400000006ffULL,
0x000000700f0f7812ULL, 0x000fe400078ec0ffULL, 0x0000000c18187812ULL, 0x000fe400078ec0ffULL,
0x00000014091a7210ULL, 0x000fe40007ebe005ULL, 0x00000019ff027819ULL, 0x000fc40000011602ULL,
0x0000001c0f097210ULL, 0x000fe40007a3e009ULL, 0x0000001a181a7210ULL, 0x000fe40007c7e00fULL,
0x00000015020f7210ULL, 0x000fe40002fec4ffULL, 0x0000000918187210ULL, 0x000fe40007fbe0ffULL,
0x0000001eff027210ULL, 0x000fe40000fe4402ULL, 0x0000000fff1b7210ULL, 0x000fc60001fe84ffULL,
0x000000ffff197224ULL, 0x000fca00028e0602ULL, 0x0000006418007986ULL, 0x0003e8000c101906ULL,
0x000000081a007986ULL, 0x0003e4000c101906ULL, 0x000000ff0700720cULL, 0x000fe20000705670ULL,
0x0000001016007986ULL, 0x0005e2000c101d06ULL, 0x0000000000007b1dULL, 0x000ff60000000000ULL,
0x0000000000700947ULL, 0x000fea0003800000ULL, 0x00009600ff087b82ULL, 0x002e620000000a00ULL,
0xffffffff0c0f7836ULL, 0x000fe40000000000ULL, 0x000000041d087825ULL, 0x002fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x0000000f080879a8ULL, 0x00032200099ee1c6ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x0000000f0800720cULL, 0x010fc80003f05270ULL,
0x00000001ff027807ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x008fd20008000004ULL,
0x00000002ff007988ULL, 0x0007e60008000004ULL, 0x0000000000027919ULL, 0x008ee20000008800ULL,
0x0000040000217802ULL, 0x000fe20000000f00ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000065402217816ULL, 0x008fca0000000021ULL,
0x0000000021027984ULL, 0x000ee40000000000ULL, 0x000000ff0200720cULL, 0x008fda0003f05270ULL,
0x0000002000488947ULL, 0x000fea0003800000ULL, 0x000000ff5c00720cULL, 0x000fda0003f05270ULL,
0x0000000800940947ULL, 0x000fea0003800000ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x00000000006c8947ULL, 0x000fea0003800000ULL, 0x0000001007027824ULL, 0x000fe200078e00ffULL,
0x00000001ff047819ULL, 0x000fe40000011607ULL, 0x0000001c0d087211ULL, 0x042fe400078038ffULL,
0x0000007002097812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fe400078ec0ffULL,
0x0000001e0d027211ULL, 0x000fe400000f3cffULL, 0x0000000804087210ULL, 0x000fc8000791e009ULL,
0x00000002ff097210ULL, 0x000fca00007e24ffULL, 0x0000000608027981ULL, 0x000328000c1e1900ULL,
0x00008006080f7981ULL, 0x000322000c1e1900ULL, 0x000000020c00780cULL, 0x000fda0003f05270ULL,
0x00000000003c8947ULL, 0x002fea0003800000ULL, 0x0001000608117981ULL, 0x004322000c1e1900ULL,
0x000000040c00780cULL, 0x000fda0003f06070ULL, 0x0000000000308947ULL, 0x002fea0003800000ULL,
0x0001800608137981ULL, 0x000322000c1e1900ULL, 0x000000040c00780cULL, 0x000fda0003f05270ULL,
0x0000000000248947ULL, 0x002fea0003800000ULL, 0x0002000608177981ULL, 0x000322000c1e1900ULL,
0x000000060c00780cULL, 0x000fda0003f06070ULL, 0x0000000000188947ULL, 0x002fea0003800000ULL,
0x0002800608197981ULL, 0x000322000c1e1900ULL, 0x000000060c00780cULL, 0x000fda0003f05270ULL,
0x00000000000c8947ULL, 0x002fea0003800000ULL, 0x000000080c00780cULL, 0x000fe20003f06070ULL,
0x00030006081b7981ULL, 0x000318000c1e1900ULL, 0x00038006081d0981ULL, 0x000324000c1e1900ULL,
0x000000070c047836ULL, 0x000fca0000000000ULL, 0x00000003ff047819ULL, 0x000fc80000011604ULL,
0x000000ff0400720cULL, 0x000fda0003f05270ULL, 0x0000000400f48947ULL, 0x000fea0003800000ULL,
0x000000230d097211ULL, 0x042fe200078038ffULL, 0x000000ffff1f7224ULL, 0x010fe200078e0002ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x0000001409147210ULL, 0x000fe40007f3e0ffULL, 0x000000ff0d087211ULL, 0x000fe400000f3cffULL,
0x0000078014257810ULL, 0x000fc80007f5e0ffULL, 0x00000008ff157210ULL, 0x000fd200017e2415ULL,
0x000000040c007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x0000000504007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400b41947ULL, 0x012fee0003800000ULL,
0x0000000804087890ULL, 0x000fe2000fffe03fULL, 0x0000001f02027209ULL, 0x000fca0007810000ULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001007087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011607ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000825087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0615ULL,
0xfffc8006081f7981ULL, 0x000326000c1e1900ULL, 0x0000000104087890ULL, 0x000fcc000fffe03fULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000004007c1947ULL, 0x000fea0003800000ULL,
0x0000000904087890ULL, 0x000fe2000fffe03fULL, 0x0000000f02027209ULL, 0x000fca0007810000ULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000000407087819ULL, 0x002fe400000006ffULL, 0x00000001ff097819ULL, 0x000fe40000011607ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000825087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0615ULL,
0xfffd0006080f7981ULL, 0x000326000c1e1900ULL, 0x0000000204087890ULL, 0x000fcc000fffe03fULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x0000000400441947ULL, 0x000fea0003800000ULL,
0x0000000a04087890ULL, 0x000fe2000fffe03fULL, 0x0000001102027209ULL, 0x000fca0007810000ULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001007087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011607ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000825087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0615ULL,
0xfffd800608117981ULL, 0x004326000c1e1900ULL, 0x0000000304087890ULL, 0x000fcc000fffe03fULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000004000c1947ULL, 0x000fea0003800000ULL,
0x0000000b04087890ULL, 0x000fe2000fffe03fULL, 0x0000001302027209ULL, 0x000fca0007810000ULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001007087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011607ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000825087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0615ULL,
0xfffe000608137981ULL, 0x004326000c1e1900ULL, 0x0000000404087890ULL, 0x000fcc000fffe03fULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x0000000000d41947ULL, 0x000fea0003800000ULL,
0x0000000c04087890ULL, 0x000fe2000fffe03fULL, 0x0000001702027209ULL, 0x000fca0007810000ULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001007087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011607ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000825087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0615ULL,
0xfffe800608177981ULL, 0x004326000c1e1900ULL, 0x0000000504087890ULL, 0x000fcc000fffe03fULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000009c1947ULL, 0x000fea0003800000ULL,
0x0000000d04087890ULL, 0x000fe2000fffe03fULL, 0x0000001902027209ULL, 0x000fca0007810000ULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000000407087819ULL, 0x002fe400000006ffULL, 0x00000001ff097819ULL, 0x000fe40000011607ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000825087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0615ULL,
0xffff000608197981ULL, 0x000326000c1e1900ULL, 0x0000000604087890ULL, 0x000fcc000fffe03fULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x0000000000641947ULL, 0x000fea0003800000ULL,
0x0000000e04087890ULL, 0x000fe2000fffe03fULL, 0x0000001b02027209ULL, 0x000fca0007810000ULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001007087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011607ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000825087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0615ULL,
0xffff8006081b7981ULL, 0x000326000c1e1900ULL, 0x0000000704087890ULL, 0x000fcc000fffe03fULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000002c1947ULL, 0x000fea0003800000ULL,
0x0000000f04087890ULL, 0x000fe2000fffe03fULL, 0x0000001d02027209ULL, 0x000fca0007810000ULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x0000001007087824ULL, 0x002fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011607ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x0000000825087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e0615ULL,
0x00000006081d7981ULL, 0x000326000c1e1900ULL, 0x0000040025257810ULL, 0x000fe20007f3e0ffULL,
0x0000000804047890ULL, 0x000fc8000fffe03fULL, 0x000000ffff157224ULL, 0x000fe200008e0615ULL,
0xfffffff8002c8947ULL, 0x000fee000383ffffULL, 0x0000000000077919ULL, 0x000ee40000000000ULL,
0x0000001007047824ULL, 0x008fe200078e00ffULL, 0x00000001ff087819ULL, 0x002fc80000011607ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ec0ffULL,
0x0000002108097210ULL, 0x000fca0007ffe004ULL, 0x0000000209007388ULL, 0x0103e40000000800ULL,
0x00009600ff147b82ULL, 0x000ee20000000a00ULL, 0x000000070700780cULL, 0x040fe20003f04070ULL,
0x0000000146117824ULL, 0x004fe200078e020dULL, 0x0000000a5c207819ULL, 0x000fe200000006ffULL,
0x0000001007267824ULL, 0x000fe200078e00ffULL, 0x00000001460f7812ULL, 0x002fe400078ec0ffULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000040020207812ULL, 0x000fe400078ee2ffULL,
0x00000000002c7805ULL, 0x000fc4000001ff00ULL, 0x00000001ff257819ULL, 0x000fe40000011607ULL,
0x00000000003a7805ULL, 0x000fe4000001ff00ULL, 0x0000007026267812ULL, 0x000fe400078ec0ffULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x0000000c25257812ULL, 0x000fe200078ec0ffULL,
0x0000020046098824ULL, 0x140fe200078e0221ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000020046138824ULL, 0x000fe200078e0221ULL, 0x0000002125297210ULL, 0x000fe20007ffe026ULL,
0x0000010006048824ULL, 0x040fe200078e0209ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000001403027210ULL, 0x008fe20007f3e0ffULL, 0x000000800f128824ULL, 0x040fe200078e0204ULL,
0x0000001423237210ULL, 0x000fe20007f7e0ffULL, 0x0000010006108824ULL, 0x000fe200078e0213ULL,
0x0000000029297984ULL, 0x000e620000000800ULL, 0x000000ffff037224ULL, 0x100fe200008e0615ULL,
0x0000001405227210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff287224ULL, 0x000fe200018e0615ULL,
0x000000100f168211ULL, 0x000fe200078e38ffULL, 0x0000080011087825ULL, 0x000fe200078e0002ULL,
0x000008000e0f7812ULL, 0x000fc400078ec0ffULL, 0x0000000000307805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff277224ULL, 0x000fe200008e0615ULL,
0x0000002008047210ULL, 0x000fe20007f5e0ffULL, 0x0000001007158824ULL, 0x000fe200078e0212ULL,
0x00000022110e8211ULL, 0x000fe200078238ffULL, 0x0000001007178824ULL, 0x000fe200078e0216ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x000000ffff057224ULL, 0x000fe200010e0609ULL,
0x0000002311108211ULL, 0x000fe200078438ffULL, 0x0000200046097824ULL, 0x000fe200078e0221ULL,
0x0000000000407805ULL, 0x000fc4000001ff00ULL, 0x0000000000387805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000100006247824ULL, 0x000fe200078e0209ULL,
0x0000002007097810ULL, 0x000fe40007ffe0ffULL, 0x0000000000347805ULL, 0x000fe4000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000000124087824ULL, 0x000fe200078e020fULL,
0x00000027110f8211ULL, 0x000fc400008f3cffULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000c4600720cULL, 0x000fe20003f26070ULL, 0x0000001007137824ULL, 0x000fe200078e0208ULL,
0x0000002811118211ULL, 0x000fe200010f3cffULL, 0x0000001009087825ULL, 0x100fe200078e0004ULL,
0x0000000000487805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000001007047825ULL, 0x000fc800078e0004ULL, 0x00000010070e8825ULL, 0x040fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000004137faeULL, 0x0005e6000b901c46ULL,
0x0000001007108825ULL, 0x000fe200078e0010ULL, 0x0038000008137faeULL, 0x0005e6000b901c46ULL,
0x000000ffff477224ULL, 0x000fe200078e00ffULL, 0x045800000e158faeULL, 0x0005e8000b901c46ULL,
0x0418000010178faeULL, 0x0005e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000800601947ULL, 0x002fea0003800000ULL, 0x00000003ff047819ULL, 0x004fe20000011607ULL,
0x0000020046537824ULL, 0x000fe200078e0221ULL, 0xfffffff8ff057812ULL, 0x000fe200078ee207ULL,
0x000000ffff2a7224ULL, 0x000fe200078e00ffULL, 0x0000000304047812ULL, 0x000fe200078ec0ffULL,
0x0000010006537824ULL, 0x000fe200078e0253ULL, 0x00000002ff527819ULL, 0x000fe20000011607ULL,
0x0000000805097836ULL, 0x000fe20000000000ULL, 0x00000046004d7202ULL, 0x000fe20000000f00ULL,
0x00000008050f7824ULL, 0x040fe400078e00ffULL, 0x00000008054e7824ULL, 0x000fe200078e00ffULL,
0x0000000504057210ULL, 0x000fe20007ffe0ffULL, 0x00000001044f7824ULL, 0x000fc400078e0209ULL,
0x0000000809047824ULL, 0x040fe200078e00ffULL, 0xfffffff84e4e7812ULL, 0x000fe200078ee205ULL,
0x0000000809087824ULL, 0x000fe400078e00ffULL, 0x0000000405507836ULL, 0x000fe20000000000ULL,
0xfffffff8044f7812ULL, 0x000fe200078ee24fULL, 0x0000000c05517836ULL, 0x000fe40000000000ULL,
0x00000008524c7836ULL, 0x000fe20000000000ULL, 0xfffffff80f507812ULL, 0x000fe400078ee250ULL,
0xfffffff808517812ULL, 0x000fce00078ee251ULL, 0x000000014d087836ULL, 0x000fca0000000000ULL,
0x0000000c0800720cULL, 0x000fda0003f06070ULL, 0x0000000000880947ULL, 0x000fea0003800000ULL,
0x000000070700780cULL, 0x000fe20003f44070ULL, 0x000000010d0f7824ULL, 0x000fe200078e0208ULL,
0x0000000108147812ULL, 0x000fc600078ec0ffULL, 0x000008000f047825ULL, 0x000fc600078e0002ULL,
0x0000002004107210ULL, 0x000fe20007f1e0ffULL, 0x0000080008047824ULL, 0x000fc800078e00ffULL,
0x000002004609a824ULL, 0x140fe200078e0221ULL, 0x00000005ff117210ULL, 0x000fe200007fe4ffULL,
0x000002004613a824ULL, 0x000fe200078e0221ULL, 0x0000080004057812ULL, 0x000fe200078ec0ffULL,
0x000001000653a824ULL, 0x000fe200078e0209ULL, 0x000000220f08a211ULL, 0x040fe400078038ffULL,
0x000000230f04a211ULL, 0x040fe200078238ffULL, 0x00000001240e7824ULL, 0x000fe200078e0205ULL,
0x000000270f09a211ULL, 0x040fe200000f3cffULL, 0x000000801412a824ULL, 0x000fe200078e0253ULL,
0x000000280f05a211ULL, 0x000fe200008f3cffULL, 0x000001000653a824ULL, 0x000fc400078e0213ULL,
0x00000020070f7836ULL, 0x000fe20000000000ULL, 0x000000120715a211ULL, 0x040fe200078e20ffULL,
0x0000001007137824ULL, 0x000fe400078e020eULL, 0x000000801414a824ULL, 0x000fe400078e0253ULL,
0x000000100f0e7825ULL, 0x000fc800078e0010ULL, 0x0000001007107825ULL, 0x000fc800078e0010ULL,
0x000000100708a825ULL, 0x040fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000010137faeULL, 0x0003e6000b901c46ULL, 0x000000100704a825ULL, 0x040fe200078e0004ULL,
0x003800000e137faeULL, 0x0003e6000b901c46ULL, 0x000000100717a824ULL, 0x000fe200078e0214ULL,
0x045800000815afaeULL, 0x0003e8000b901c46ULL, 0x041800000417afaeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000804d047824ULL, 0x002fca00078e00ffULL,
0x0000008004047812ULL, 0x000fc800078ec0ffULL, 0x0000005326047210ULL, 0x000fca0007ffe004ULL,
0x0000000125087824ULL, 0x000fe400078e0204ULL, 0x000008004d047824ULL, 0x000fe400078e00ffULL,
0x000000024d4d7836ULL, 0x000fc60000000000ULL, 0x0000080004057812ULL, 0x000fe200078ec0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00418000080e7984ULL, 0x000e620000000800ULL,
0x0000018024057810ULL, 0x000fe40007ffe005ULL, 0x0000000c4d00720cULL, 0x000fe20003f06070ULL,
0x0045800008097984ULL, 0x000fe20000000800ULL, 0x00000005511c7211ULL, 0x000fe200078e20ffULL,
0x000000104e107824ULL, 0x100fe400078e0205ULL, 0x000000104f187824ULL, 0x100fe400078e0205ULL,
0x0000001050147824ULL, 0x000fe200078e0205ULL, 0x000000001c1c783bULL, 0x000ea80000000200ULL,
0x000000001010783bULL, 0x000ee80000000200ULL, 0x000000001818783bULL, 0x000f280000000200ULL,
0x000000001414783bULL, 0x000f620000000200ULL, 0x0000000e290e7221ULL, 0x002fc80000010100ULL,
0x3fb8aa3b0e547820ULL, 0x000fcc0000410000ULL, 0x0000005400547308ULL, 0x000e620000000800ULL,
0x2000001dff5b7230ULL, 0x004fe40000004100ULL, 0x3000001dff5c7230ULL, 0x000fe40000004100ULL,
0x30000011ff047230ULL, 0x008fe40000004100ULL, 0x20000012ff087230ULL, 0x000fe40000004100ULL,
0x30000012ff0f7230ULL, 0x000fe40000004100ULL, 0x2000001aff587230ULL, 0x010fc40000004100ULL,
0x3000001aff597230ULL, 0x000fe40000004100ULL, 0x00000009545f7220ULL, 0x002fe20000410000ULL,
0x20000011ff097230ULL, 0x000fe40000004100ULL, 0x20000014ff127230ULL, 0x020fe40000004100ULL,
0x0000004b5f4b7221ULL, 0x000fe20000010000ULL, 0x00001f525f5e7589ULL, 0x000e6200000e0000ULL,
0x30000014ff117230ULL, 0x000fe40000004100ULL, 0x20000016ff547230ULL, 0x000fe20000004100ULL,
0x00001f4c5f607589ULL, 0x000ea200000e0000ULL, 0x30000016ff557230ULL, 0x000fc40000004100ULL,
0x20000018ff567230ULL, 0x000fe40000004100ULL, 0x30000018ff577230ULL, 0x000fe40000004100ULL,
0x2000001bff1a7230ULL, 0x000fe40000004100ULL, 0x3000001bff5a7230ULL, 0x000fe40000004100ULL,
0x20000010ff057230ULL, 0x000fe40000004100ULL, 0x20000013ff0e7230ULL, 0x000fc40000004100ULL,
0x20000015ff147230ULL, 0x000fe40000004100ULL, 0x20000017ff167230ULL, 0x000fe40000004100ULL,
0x20000019ff187230ULL, 0x000fe40000004100ULL, 0x0000005e054a7223ULL, 0x082fe2000001004aULL,
0x2000001cff1b7230ULL, 0x000fe40000004100ULL, 0x0000005e09487223ULL, 0x000fe20000010048ULL,
0x2000001eff1d7230ULL, 0x000fc40000004100ULL, 0x0000005e04477223ULL, 0x080fe20000010047ULL,
0x2000001fff5d7230ULL, 0x000fe40000004100ULL, 0x0000005e08457223ULL, 0x080fe20000010045ULL,
0x30000010ff107230ULL, 0x000fe40000004100ULL, 0x0000005e0f447223ULL, 0x080fe20000010044ULL,
0x30000013ff137230ULL, 0x000fe40000004100ULL, 0x0000005e0e437223ULL, 0x000fe20000010043ULL,
0x30000015ff157230ULL, 0x000fc40000004100ULL, 0x0000005e10497223ULL, 0x080fe20000010049ULL,
0x30000017ff177230ULL, 0x000fe40000004100ULL, 0x0000005e13427223ULL, 0x080fe20000010042ULL,
0x30000019ff197230ULL, 0x000fe40000004100ULL, 0x0000005e12417223ULL, 0x080fe20000010041ULL,
0x3000001cff1c7230ULL, 0x000fe40000004100ULL, 0x0000005e11407223ULL, 0x000fe20000010040ULL,
0x3000001eff1e7230ULL, 0x000fc40000004100ULL, 0x0000005e143f7223ULL, 0x080fe2000001003fULL,
0x3000001fff1f7230ULL, 0x000fe40000004100ULL, 0x0000005e153e7223ULL, 0x080fe2000001003eULL,
0x0000005e543d7223ULL, 0x080fe2000001003dULL, 0x0000005e553c7223ULL, 0x080fe2000001003cULL,
0x0000005e163b7223ULL, 0x080fe2000001003bULL, 0x0000005e173a7223ULL, 0x000fe2000001003aULL,
0x00000060562b7223ULL, 0x084fe2000001002bULL, 0x0000006057387223ULL, 0x080fe20000010038ULL,
0x0000006018377223ULL, 0x080fe20000010037ULL, 0x0000006019367223ULL, 0x080fe20000010036ULL,
0x0000006058357223ULL, 0x080fe20000010035ULL, 0x0000006059347223ULL, 0x080fe20000010034ULL,
0x000000601a337223ULL, 0x080fe20000010033ULL, 0x000000605a397223ULL, 0x080fe20000010039ULL,
0x000000601b327223ULL, 0x080fe20000010032ULL, 0x000000601c317223ULL, 0x080fe20000010031ULL,
0x000000605b307223ULL, 0x080fe20000010030ULL, 0x000000605c2f7223ULL, 0x080fe2000001002fULL,
0x000000601d2e7223ULL, 0x080fe2000001002eULL, 0x000000601e2d7223ULL, 0x080fe2000001002dULL,
0x000000605d2c7223ULL, 0x080fe2000001002cULL, 0x000000601f2a7223ULL, 0x000fe2000001002aULL,
0xfffffff400f88947ULL, 0x000fec000383ffffULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x0000498021037836ULL, 0x000fe40000000000ULL,
0x0000001002047824ULL, 0x006fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fc80000011602ULL,
0x0000007004087812ULL, 0x000fe400078ec0ffULL, 0x0000000c02077812ULL, 0x000fc600078ec0ffULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0000008046217824ULL, 0x000fe400078e0221ULL, 0x0000001002047824ULL, 0x002fe200078e00ffULL,
0x00000001ff057819ULL, 0x000fc80000011602ULL, 0x0000007004027812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fc800078ec0ffULL, 0x0000002105027210ULL, 0x000fca0007ffe002ULL,
0x0049804b02007388ULL, 0x0003e40000000800ULL, 0x0000000307037210ULL, 0x000fe20007ffe008ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000003027984ULL, 0x002e680000000800ULL,
0x0000800003057984ULL, 0x000ea20000000800ULL, 0x00000002ff027221ULL, 0x002fc80000010000ULL,
0x0000000502027221ULL, 0x004fc80000010000ULL, 0x0180000002047836ULL, 0x000fca0000000000ULL,
0x7f80000004047812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0400780cULL, 0x000fda0003f04070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e0002ULL, 0x0000aa9000047802ULL, 0x000fce0000000f00ULL,
0x0000008400447944ULL, 0x000fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000000200037308ULL, 0x000e640000001000ULL, 0xbf80000002047423ULL, 0x002fc80000000003ULL,
0x800000ff04047221ULL, 0x000fc80000010100ULL, 0x0000000403037223ULL, 0x000fce0000000003ULL,
0x0000000000077919ULL, 0x000f240000000000ULL, 0x00000002ff027819ULL, 0x110fe20000011607ULL,
0x000000010a0a7824ULL, 0x100fe200078e0207ULL, 0x0000000807147811ULL, 0x000fe400078ff0ffULL,
0x00000003ff047819ULL, 0x000fe20000011607ULL, 0x000000100a0a7824ULL, 0x000fe200078e020bULL,
0x0000000000007948ULL, 0x00cfea0003800000ULL, 0x00001f0203027589ULL, 0x000ea200000e0000ULL,
0xfffffff8ff177812ULL, 0x000fc600078ee207ULL, 0x00001f1403147589ULL, 0x000ee200000e0000ULL,
0x0000000817197810ULL, 0x000fe20007ffe0ffULL, 0x00000008171c7824ULL, 0x040fe400078e00ffULL,
0x00000008171d7824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000008191b7824ULL, 0x000fc400078e00ffULL, 0x00000008191f7824ULL, 0x000fe400078e00ffULL,
0x0000004a020c7220ULL, 0x044fe20000410000ULL, 0x0000004902497220ULL, 0x040fe20000410000ULL,
0x00000048020d7220ULL, 0x040fe20000410000ULL, 0x0000004702087220ULL, 0x002fe20000410000ULL,
0x0000002b142b7220ULL, 0x048fe20000410000ULL, 0x0000003814387220ULL, 0x040fe20000410000ULL,
0x0000003714377220ULL, 0x040fe20000410000ULL, 0x0000003614367220ULL, 0x040fe20000410000ULL,
0x0000003514357220ULL, 0x040fe20000410000ULL, 0x0000003414347220ULL, 0x040fe20000410000ULL,
0x0000003314337220ULL, 0x040fe20000410000ULL, 0x0000003914167220ULL, 0x040fe20000410000ULL,
0x0000003214327220ULL, 0x040fe20000410000ULL, 0x0000003114317220ULL, 0x040fe20000410000ULL,
0x0000003014307220ULL, 0x040fe20000410000ULL, 0x0000002f142f7220ULL, 0x040fe20000410000ULL,
0x0000002e142e7220ULL, 0x040fe20000410000ULL, 0x0000002d142d7220ULL, 0x040fe20000410000ULL,
0x0000002c142c7220ULL, 0x040fe20000410000ULL, 0x0000002a14157220ULL, 0x000fe20000410000ULL,
0x0000000304147812ULL, 0x000fe200078ec0ffULL, 0x00000045020e7220ULL, 0x040fe20000410000ULL,
0x0000004402057220ULL, 0x040fe20000410000ULL, 0x00000043020f7220ULL, 0x040fe20000410000ULL,
0x0000004202427220ULL, 0x000fe20000410000ULL, 0x0000000114177824ULL, 0x000fc400078e0217ULL,
0x0000004102107220ULL, 0x000fe20000410000ULL, 0x0000000114187824ULL, 0x000fe400078e0219ULL,
0x0000004002097220ULL, 0x040fe20000410000ULL, 0x0000000417147836ULL, 0x000fe20000000000ULL,
0x0000000c171a7810ULL, 0x000fe20007ffe0ffULL, 0x0000003f02117220ULL, 0x040fe20000410000ULL,
0x0000003e023e7220ULL, 0x040fe20000410000ULL, 0x0000003d02127220ULL, 0x040fe20000410000ULL,
0x0000003c02037220ULL, 0x040fe20000410000ULL, 0x0000003b02137220ULL, 0x040fe20000410000ULL,
0xfffffff81c177812ULL, 0x000fe200078ee217ULL, 0x0000003a02027220ULL, 0x000fe20000410000ULL,
0xfffffff81d197812ULL, 0x000fc400078ee214ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee218ULL,
0x0000001017287824ULL, 0x100fe200078e0200ULL, 0xfffffff81f1d7812ULL, 0x000fe200078ee21aULL,
0x0000001019297824ULL, 0x100fe200078e0200ULL, 0x0000000c490c723eULL, 0x000fe200000000ffULL,
0x000000101b2a7824ULL, 0x100fe200078e0200ULL, 0x0000000d080d723eULL, 0x000fe200000000ffULL,
0x000000101d007824ULL, 0x000fe200078e0200ULL, 0x0000000e050e723eULL, 0x000fe400000000ffULL,
0x0000000f420f723eULL, 0x000fc400000000ffULL, 0x000000100910723eULL, 0x000fe400000000ffULL,
0x000000113e11723eULL, 0x000fe200000000ffULL, 0x0000000c28007844ULL, 0x000fe20000000200ULL,
0x000000120312723eULL, 0x000fe400000000ffULL, 0x000000130213723eULL, 0x000fe400000000ffULL,
0x0000002b3838723eULL, 0x000fe400000000ffULL, 0x000000373639723eULL, 0x000fe200000000ffULL,
0x0000001029007844ULL, 0x000fe20000000200ULL, 0x00000035343a723eULL, 0x000fc400000000ffULL,
0x00000033163b723eULL, 0x000fe400000000ffULL, 0x000000323118723eULL, 0x000fe400000000ffULL,
0x000000302f19723eULL, 0x000fe200000000ffULL, 0x000000382a007844ULL, 0x000fe20000000200ULL,
0x0000002e2d1a723eULL, 0x000fe400000000ffULL, 0x0000002c151b723eULL, 0x000fca00000000ffULL,
0x0000001800007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000a147984ULL, 0x000e680000000c00ULL, 0x000400000a207984ULL, 0x000ea80000000c00ULL,
0x000800000a1c7984ULL, 0x000ee80000000c00ULL, 0x000c00000a247984ULL, 0x000f220000000c00ULL,
0x200000ff17177230ULL, 0x002fc40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fe40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x200000ff23237230ULL, 0x004fe40000000000ULL, 0x200000ff22227230ULL, 0x000fe40000000000ULL,
0x200000ff21217230ULL, 0x000fc40000000000ULL, 0x200000ff20207230ULL, 0x000fe40000000000ULL,
0x0000001f17177230ULL, 0x008fe40000000000ULL, 0x0000001e16167230ULL, 0x000fe40000000000ULL,
0x0000001d15157230ULL, 0x000fe40000000000ULL, 0x0000001c14147230ULL, 0x000fe40000000000ULL,
0x0000002723237230ULL, 0x010fc40000000000ULL, 0x0000002622227230ULL, 0x000fe20000000000ULL,
0x000000140a007388ULL, 0x0003e20000000c00ULL, 0x0000002521217230ULL, 0x000fe40000000000ULL,
0x0000002420207230ULL, 0x000fca0000000000ULL, 0x000400200a007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff4600720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000002007137836ULL, 0x004fe20000000000ULL,
0x0000000000057919ULL, 0x000ea20000002600ULL, 0x0000000704037210ULL, 0x000fe20007ffe0ffULL,
0x00000000000579c3ULL, 0x000ee20000002700ULL, 0x0000840000047ab9ULL, 0x000fe20000000800ULL,
0x00000003ff027819ULL, 0x000fe20000011613ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000703087812ULL, 0x002fe200078ec0ffULL, 0x0000000806127824ULL, 0x040fe400078e00ffULL,
0x0000000113007824ULL, 0x000fe200078e0202ULL, 0x0ffffff8080a7812ULL, 0x000fe200078ef807ULL,
0x0000000806067824ULL, 0x000fc600078e00ffULL, 0x0000000700007812ULL, 0x000fc800078ec0ffULL,
0x0ffffff800087812ULL, 0x000fe200078ef813ULL, 0x000000100a007824ULL, 0x000fc800078e020bULL,
0x0000001008037824ULL, 0x000fe400078e020bULL, 0x0000000000087984ULL, 0x0003220000000c00ULL,
0x00000005040472a4ULL, 0x008fc6000f8e023fULL, 0x00000000030c7984ULL, 0x0007620000000c00ULL,
0x0000000805117824ULL, 0x044fe400078e00ffULL, 0x0000000805057824ULL, 0x000fc600078e00ffULL,
0xfffffff811047812ULL, 0x000fe400078ee204ULL, 0xfffffff805027812ULL, 0x000fe400078ee202ULL,
0x0000000404107c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000402007c10ULL, 0x002fe2000ff3e0ffULL,
0x0000860000047ab9ULL, 0x000fe20000000a00ULL, 0xfffffff812117812ULL, 0x000fe200078ee207ULL,
0x000000ffff037224ULL, 0x008fe200000e06ffULL, 0x0000000410027c11ULL, 0x000fc4000f8040ffULL,
0x000000ffff057210ULL, 0x000fe40000ffe4ffULL, 0x0000000400047c11ULL, 0x000fe4000f8240ffULL,
0x0000000510037c11ULL, 0x000fe400080f4403ULL, 0x0000000500057c11ULL, 0x000fe400088f4405ULL,
0xfffffff806077812ULL, 0x000fe200078ee213ULL, 0x0000001011027825ULL, 0x000fc800078e0002ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x010fe8000c101d06ULL,
0x0000000c04007986ULL, 0x020fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff047819ULL, 0x000fe2000001165cULL, 0xffffffffff0f7424ULL, 0x000fc800078e00ffULL,
0x000000025b597824ULL, 0x000fca00078e0204ULL, 0x000000585900720cULL, 0x000fda0003f06070ULL,
0x00009000ff058b82ULL, 0x000ea20000000800ULL, 0x0000000202048824ULL, 0x000fce00078e00ffULL,
0x00008c00ff108b82ULL, 0x000ee20000000a00ULL, 0x0000000504058224ULL, 0x004fe400078e0259ULL,
0x00000001ff047424ULL, 0x000fe400078e00ffULL, 0x0000000405108825ULL, 0x008fc800078e0010ULL,
0x01b600040b0479a7ULL, 0x0004a2000850003fULL, 0x00000006100f8981ULL, 0x000ee2000c1e1900ULL,
0x000000015b077836ULL, 0x002fe20000000000ULL, 0x00000007120a7819ULL, 0x000fe200000006ffULL,
0x000000405c0d7824ULL, 0x000fe400078e00ffULL, 0x0000008014087824ULL, 0x000fe200078e00ffULL,
0x0000000e0700720cULL, 0x000fe20003f06070ULL, 0x000001005b097824ULL, 0x000fca00078e020dULL,
0x000000400a077812ULL, 0x000fe200078ef809ULL, 0x000000080f067224ULL, 0x008fcc00078e02ffULL,
0x0000000c00a88947ULL, 0x004fea0003800000ULL, 0x000000095a107248ULL, 0x000fe20007fe0000ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x00000003ff117819ULL, 0x100fe40000011600ULL,
0x0000007003037812ULL, 0x000fe200078ec0ffULL, 0x0000000110107824ULL, 0x000fe200078e0a09ULL,
0x0000001011237810ULL, 0x000fe20007ffe0ffULL, 0x0000000411137836ULL, 0x000fe40000000000ULL,
0x0000000107097824ULL, 0x000fe400078e0211ULL, 0x0000000113127824ULL, 0x140fe200078e0200ULL,
0x000000101300720cULL, 0x0c0fe20003f86070ULL, 0x0000000811157836ULL, 0x000fe20000000000ULL,
0x0000000313177819ULL, 0x000fe200000006ffULL, 0x0000000107137824ULL, 0x000fe200078e0213ULL,
0x0000000906197210ULL, 0x000fe20007f1e0ffULL, 0x0000000115147824ULL, 0x040fe200078e0200ULL,
0xfffffff817287812ULL, 0x000fe200078ee212ULL, 0x00000008151b7824ULL, 0x000fe200078e00ffULL,
0x0000001306137210ULL, 0x000fe20007f3e0ffULL, 0x0000000107097824ULL, 0x000fe200078e0215ULL,
0x000000101500720cULL, 0x000fe20003fa6070ULL, 0x0000000c111d7836ULL, 0x000fe20000000000ULL,
0xfffffff81b2a7812ULL, 0x000fe200078ee214ULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x00000004191c7c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff127224ULL, 0x000fe200008e06ffULL,
0x0000000413227c11ULL, 0x000fe2000f8240ffULL, 0x0000001411297836ULL, 0x000fe20000000000ULL,
0x0000000519197c11ULL, 0x000fe200080f4414ULL, 0x00000018112b7836ULL, 0x000fe20000000000ULL,
0x00000005131b7c11ULL, 0x000fe200088f4412ULL, 0x0000000107137824ULL, 0x040fe200078e0223ULL,
0x0000000906177210ULL, 0x000fe20007f1e0ffULL, 0x0000000107097824ULL, 0x000fc400078e021dULL,
0x0000000107157824ULL, 0x000fe200078e0229ULL, 0x0000001306137210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x0000000417167c11ULL, 0x000fe2000f8040ffULL,
0x0000001c112d7836ULL, 0x000fe20000000000ULL, 0x0000000906097210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff1a7224ULL, 0x000fe200010e06ffULL, 0x0000001506157210ULL, 0x000fe20007f7e0ffULL,
0x000000011d1f7824ULL, 0x000fe200078e0200ULL, 0x0000000517177c11ULL, 0x000fe200080f4412ULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x000000ffff127210ULL, 0x000fe20001ffe4ffULL,
0x000000081d2c7824ULL, 0x000fe200078e00ffULL, 0x00000004151e7c11ULL, 0x000fe2000f8440ffULL,
0x00000008232e7824ULL, 0x000fe200078e00ffULL, 0x0000000413187c11ULL, 0x000fe2000f8240ffULL,
0x0000000829307824ULL, 0x000fe200078e00ffULL, 0x0000000515277c11ULL, 0x000fe200090f4412ULL,
0x0000000111127824ULL, 0x000fe200078e0200ULL, 0x00000005131a7c11ULL, 0x000fe200088f441aULL,
0x0000000107137824ULL, 0x000fe200078e022bULL, 0x0000000409207c11ULL, 0x000fc4000f8040ffULL,
0x0000000712157812ULL, 0x000fe400078ec0ffULL, 0x0000001306257210ULL, 0x000fe40007fde0ffULL,
0x0000001c03127210ULL, 0x000fe40007f3e0ffULL, 0x0000000509217c11ULL, 0x000fe200080f4414ULL,
0x000000ffff147224ULL, 0x000fe200030e06ffULL, 0x000000101100720cULL, 0x000fe20003f06070ULL,
0x000000ffff137224ULL, 0x000fe200008e0619ULL, 0x00000004251c7c11ULL, 0x000fe2000f8240ffULL,
0x000040005c097824ULL, 0x000fe200078e020bULL, 0x0ffffff815247812ULL, 0x000fc400078ef800ULL,
0x0000000525257c11ULL, 0x000fe200088f4414ULL, 0x0000100009097836ULL, 0x000fe20000000000ULL,
0x0000002203147210ULL, 0x000fe20007f3e0ffULL, 0x000000082b227824ULL, 0x000fe200078e00ffULL,
0x000000101d00720cULL, 0x080fe20003f66070ULL, 0x0000001024197824ULL, 0x000fe200078e0209ULL,
0x000000102300720cULL, 0x000fe20003f46070ULL, 0x000000ffff157224ULL, 0x000fe200008e061bULL,
0x00000000231d7210ULL, 0x000fe20007ffe0ffULL, 0x00000001071b7824ULL, 0x000fe200078e022dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012197faeULL, 0x0003e2000c101c46ULL,
0x0000001603167210ULL, 0x000fc40007f3e0ffULL, 0xfffffff82e2e7812ULL, 0x000fe400078ee21dULL,
0x0000001b06237210ULL, 0x000fe20007fde0ffULL, 0x00000010281b7824ULL, 0x000fe200078e0209ULL,
0x00000000291d7210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200008e0617ULL,
0xfffffff82c2c7812ULL, 0x000fe400078ee21fULL, 0xfffffff830307812ULL, 0x000fe200078ee21dULL,
0x000000ffff127224ULL, 0x002fe200030e06ffULL, 0x0000000423267c11ULL, 0x000fe2000f8c40ffULL,
0x000000012b137824ULL, 0x000fe200078e0200ULL, 0x00000020111f7810ULL, 0x000fe20007ffe0ffULL,
0x000000102a1d7824ULL, 0x000fe200078e0209ULL, 0x0000000523237c11ULL, 0x000fe2000b0f4412ULL,
0x00000000141b7faeULL, 0x0003e2000e101c46ULL, 0x0000002003127210ULL, 0x000fe20007fde0ffULL,
0x000000012d207824ULL, 0x040fe200078e0200ULL, 0xfffffff822287812ULL, 0x000fe200078ee213ULL,
0x00000000161d7faeULL, 0x0005e2000e901c46ULL, 0x0000001803187210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff137224ULL, 0x000fe200030e0621ULL, 0x000000102d00720cULL, 0x080fe20003f86070ULL,
0x0000000107217824ULL, 0x000fe200078e021fULL, 0x000000102900720cULL, 0x080fe20003f06070ULL,
0x000000ffff197224ULL, 0x000fe200028e061aULL, 0x000000101f00720cULL, 0x0c0fe20003fa6070ULL,
0x0000002411157836ULL, 0x002fe20000000000ULL, 0x0000002106217210ULL, 0x000fe20007fde0ffULL,
0x000000011f147824ULL, 0x000fe200078e0200ULL, 0x000000102b00720cULL, 0x080fe20003f26070ULL,
0x000000081f1f7824ULL, 0x000fe200078e00ffULL, 0x000000ffff247210ULL, 0x000fe200037fe4ffULL,
0x000000102c177824ULL, 0x004fe200078e0209ULL, 0x0000000421227c11ULL, 0x000fe2000f8c40ffULL,
0x00000001071d7824ULL, 0x000fe200078e0215ULL, 0xfffffff81f1a7812ULL, 0x000fe200078ee214ULL,
0x000000102e1b7824ULL, 0x100fe200078e0209ULL, 0x0000000521247c11ULL, 0x000fe2000b0f4424ULL,
0x000000082d2d7824ULL, 0x000fe200078e00ffULL, 0x0000000012177faeULL, 0x0003e2000d901c46ULL,
0x0000001d061f7210ULL, 0x000fe20007fde0ffULL, 0x0000000115167824ULL, 0x040fe200078e0200ULL,
0x0000001e03147210ULL, 0x000fe20007f7e0ffULL, 0x00000000181b7faeULL, 0x0005e2000d101c46ULL,
0xfffffff82d2a7812ULL, 0x000fe200078ee220ULL, 0x00000008151d7824ULL, 0x040fe200078e00ffULL,
0x000000101500720cULL, 0x000fe20003f46070ULL, 0x000000ffff207224ULL, 0x000fe200030e06ffULL,
0x00000027ff157210ULL, 0x000fe20001ffe4ffULL, 0x000000102a217824ULL, 0x100fe200078e0209ULL,
0x000000041f1e7c11ULL, 0x040fe2000f8c40ffULL, 0x0000003811277836ULL, 0x000fe20000000000ULL,
0x0000001c03127210ULL, 0x002fe20007f7e0ffULL, 0x0000003c11297836ULL, 0x000fe20000000000ULL,
0xfffffff81d1c7812ULL, 0x000fe200078ee216ULL, 0x00000010301d7824ULL, 0x000fe200078e0209ULL,
0x000000051f1b7c11ULL, 0x004fe2000b0f4420ULL, 0x000000ffff137224ULL, 0x000fe200018e0625ULL,
0x000000091c257211ULL, 0x000fe200078e20ffULL, 0x00000010281f7824ULL, 0x000fe200078e0209ULL,
0x00000000141d7faeULL, 0x0003e2000c101c46ULL, 0x0000002603167210ULL, 0x000fe20007f1e0ffULL,
0x00000008271c7824ULL, 0x000fc400078e00ffULL, 0x00000000121f7faeULL, 0x0005e2000c901c46ULL,
0x0000002203187210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe400000e0623ULL,
0x000000101a237824ULL, 0x000fe200078e0209ULL, 0x0000001e031a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff197224ULL, 0x000fe200008e0624ULL, 0x0000000016217faeULL, 0x0007e2000e101c46ULL,
0x0000002c11157836ULL, 0x002fe20000000000ULL, 0x000000102700720cULL, 0x080fe20003f26070ULL,
0x00000030111d7836ULL, 0x000fe20000000000ULL, 0x0000000018237faeULL, 0x0003e2000e901c46ULL,
0x0000002811137836ULL, 0x004fe20000000000ULL, 0x000000101500720cULL, 0x080fe20003f86070ULL,
0x00000034111f7836ULL, 0x000fe20000000000ULL, 0x000000101d00720cULL, 0x080fe20003f66070ULL,
0x000000ffff1b7224ULL, 0x000fe200000e061bULL, 0x0000001307117210ULL, 0x000fe20007ffe0ffULL,
0x0000000113127824ULL, 0x140fe200078e0200ULL, 0x000000101300720cULL, 0x0c0fe20003fa6070ULL,
0x0000000813177824ULL, 0x008fe200078e00ffULL, 0x0000001106137210ULL, 0x000fe20007f1e0ffULL,
0x000000001a257faeULL, 0x0005e2000d101c46ULL, 0x0000000115117824ULL, 0x100fe200078e0200ULL,
0x000000101f00720cULL, 0x000fe20003f46070ULL, 0x0000000815167824ULL, 0x000fe200078e00ffULL,
0x0000000413187c11ULL, 0x002fe2000f8c40ffULL, 0x0000000107157824ULL, 0x000fe200078e0215ULL,
0xfffffff817147812ULL, 0x000fe200078ee212ULL, 0x000000011d127824ULL, 0x000fe200078e0200ULL,
0xfffffff816167812ULL, 0x000fc400078ee211ULL, 0x000000031d197819ULL, 0x000fe200000006ffULL,
0x00000001071d7824ULL, 0x000fe400078e021dULL, 0x000000ffff1a7224ULL, 0x004fe200000e06ffULL,
0x000000102900720cULL, 0x000fc80003f06070ULL, 0x0000000513117c11ULL, 0x000fe2000b0f441aULL,
0x000000011f137824ULL, 0x140fe200078e0200ULL, 0x0000001803107210ULL, 0x000fe20007fde0ffULL,
0x000000081f1a7824ULL, 0x000fe200078e00ffULL, 0xfffffff819187812ULL, 0x000fe400078ee212ULL,
0x0000001f071f7210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x0000001506177210ULL, 0x000fe20007fde0ffULL, 0x0000000127157824ULL, 0x000fe200078e0200ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee213ULL, 0x0000000107277824ULL, 0x000fc400078e0227ULL,
0x000000ffff207224ULL, 0x000fe200030e06ffULL, 0x00000004171e7c11ULL, 0x000fe2000f8c40ffULL,
0x0000000129007824ULL, 0x000fe200078e0200ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee215ULL,
0x000000101a197824ULL, 0x000fe200078e0209ULL, 0x0000000517137c11ULL, 0x000fe2000b0f4420ULL,
0x0000000107177824ULL, 0x000fe200078e0229ULL, 0x0000001e03127210ULL, 0x000fe20007fde0ffULL,
0x0000001014077824ULL, 0x000fe200078e0209ULL, 0x0000000916157211ULL, 0x000fe200078e20ffULL,
0x0000000829297824ULL, 0x000fc400078e00ffULL, 0x000000ffff137224ULL, 0x000fe200030e0613ULL,
0x0000001d061d7210ULL, 0x000fe20007fde0ffULL, 0x0000000010077faeULL, 0x0003e2000e901c46ULL,
0x0000001f061f7210ULL, 0x000fe20007fbe0ffULL, 0x000000101c1b7824ULL, 0x000fe200078e0209ULL,
0xfffffff829007812ULL, 0x000fe200078ee200ULL, 0x000000ffff207224ULL, 0x000fe200030e06ffULL,
0x000000041d1e7c11ULL, 0x040fe2000f8c40ffULL, 0x0000000012157faeULL, 0x0005e2000e101c46ULL,
0x0000002706277210ULL, 0x000fe40007f9e0ffULL, 0x000000051d147c11ULL, 0x000fc4000b0f4420ULL,
0x0000001706167210ULL, 0x000fe20007fde0ffULL, 0x0000001018177824ULL, 0x100fe400078e0209ULL,
0x000000ffff067224ULL, 0x000fe200028e06ffULL, 0x000000041f187c11ULL, 0x040fe2000f8a40ffULL,
0x0000001000097824ULL, 0x000fe400078e0209ULL, 0x000000ffff007224ULL, 0x000fe200020e06ffULL,
0x000000051f1a7c11ULL, 0x000fe2000a8f4406ULL, 0x000000ffff117224ULL, 0x002fe200030e06ffULL,
0x0000001e03067210ULL, 0x000fc40007fbe0ffULL, 0x0000000427127c11ULL, 0x044fe4000f8840ffULL,
0x00000014ff077210ULL, 0x000fe40002ffe4ffULL, 0x0000000416147c11ULL, 0x040fe4000f8c40ffULL,
0x0000001803107210ULL, 0x000fe20007fbe0ffULL, 0x0000000006177faeULL, 0x0003e2000d901c46ULL,
0x0000000527137c11ULL, 0x000fe4000a0f4400ULL, 0x0000000516007c11ULL, 0x000fe2000b0f4411ULL,
0x000000ffff117224ULL, 0x000fe200028e061aULL, 0x0000001203127210ULL, 0x000fc40007f9e0ffULL,
0x0000001403147210ULL, 0x000fe40007fbe0ffULL, 0x0000000010197faeULL, 0x0003e2000d101c46ULL,
0x000000ffff137224ULL, 0x000fe400020e0613ULL, 0x000000ffff157224ULL, 0x000fc600028e0600ULL,
0x00000000121b7faeULL, 0x0003e8000c901c46ULL, 0x0000000014097faeULL, 0x0003e2000c101c46ULL,
0x0000000c00587947ULL, 0x000fea0003800000ULL, 0x0000000400137811ULL, 0x040fe200078fe8ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000c00177811ULL, 0x000fe200078fe8ffULL,
0x000040005c347824ULL, 0x000fe200078e020bULL, 0x0000001000197811ULL, 0x040fe200078fe8ffULL,
0x0000000113257824ULL, 0x140fe200078e0200ULL, 0x00000014001b7811ULL, 0x040fe200078fe8ffULL,
0x0000000813107824ULL, 0x000fe200078e00ffULL, 0x0000000800157811ULL, 0x040fe200078fe8ffULL,
0x0000000817117824ULL, 0x000fe200078e00ffULL, 0x0000000017247210ULL, 0x000fe20007ffe0ffULL,
0x0000000119277824ULL, 0x140fe200078e0200ULL, 0xfffffff810257812ULL, 0x000fe200078ee225ULL,
0x0000000819107824ULL, 0x000fe200078e00ffULL, 0x0000001c002a7811ULL, 0x040fe200078fe8ffULL,
0x000000011b237824ULL, 0x140fe200078e0200ULL, 0xfffffff811247812ULL, 0x000fe200078ee224ULL,
0x000000081b127824ULL, 0x000fe200078e00ffULL, 0x0000001800297811ULL, 0x000fe200078fe8ffULL,
0x0000000115267824ULL, 0x140fe200078e0200ULL, 0xfffffff810277812ULL, 0x000fe200078ee227ULL,
0x0000000815097824ULL, 0x000fe200078e00ffULL, 0xfffffff812237812ULL, 0x000fe200078ee223ULL,
0x000000082a117824ULL, 0x000fe200078e00ffULL, 0x0000002000107811ULL, 0x040fe200078fe8ffULL,
0x0000000129227824ULL, 0x140fe200078e0200ULL, 0x0000002400127811ULL, 0x040fe200078fe8ffULL,
0x0000100034477836ULL, 0x000fe20000000000ULL, 0x0000002c00167811ULL, 0x000fe200078fe8ffULL,
0x00000001101d7824ULL, 0x140fe200078e0200ULL, 0x000000002a1c7210ULL, 0x000fe20007ffe0ffULL,
0x0000000810187824ULL, 0x000fe200078e00ffULL, 0xfffffff809267812ULL, 0x000fe200078ee226ULL,
0x0000000829097824ULL, 0x000fe200078e00ffULL, 0xfffffff8111c7812ULL, 0x000fe200078ee21cULL,
0x00000001121f7824ULL, 0x100fe200078e0200ULL, 0x0000002800147811ULL, 0x000fe200078fe8ffULL,
0x00000008121a7824ULL, 0x000fe200078e00ffULL, 0x0000000016217210ULL, 0x000fe20007ffe0ffULL,
0x00000008161e7824ULL, 0x000fe200078e00ffULL, 0x0000000000117211ULL, 0x000fe200078fe8ffULL,
0x0000000114207824ULL, 0x040fe200078e0200ULL, 0xfffffff809227812ULL, 0x000fe200078ee222ULL,
0x0000000814097824ULL, 0x000fe200078e00ffULL, 0xfffffff8181d7812ULL, 0x000fe200078ee21dULL,
0x00000001072b7824ULL, 0x040fe200078e0210ULL, 0xfffffff81a1f7812ULL, 0x000fe200078ee21fULL,
0x00000001072d7824ULL, 0x040fe200078e0212ULL, 0xfffffff81e217812ULL, 0x000fe200078ee221ULL,
0x00000001072f7824ULL, 0x000fe200078e0214ULL, 0x00000007113b7812ULL, 0x000fe200078ec0ffULL,
0x0000000113117824ULL, 0x100fe200078e0207ULL, 0x0000003000187811ULL, 0x040fe200078fe8ffULL,
0x0000000115137824ULL, 0x100fe200078e0207ULL, 0x00000034001a7811ULL, 0x040fe200078fe8ffULL,
0x0000000117157824ULL, 0x100fe200078e0207ULL, 0x00000038001e7811ULL, 0x040fe200078fe8ffULL,
0x0000000119177824ULL, 0x100fe200078e0207ULL, 0x0000003c00287811ULL, 0x040fe200078fe8ffULL,
0x000000011b197824ULL, 0x100fe200078e0207ULL, 0xfffffff809207812ULL, 0x000fe200078ee220ULL,
0x00000001291b7824ULL, 0x000fe200078e0207ULL, 0x0000000700097211ULL, 0x000fe200078fe8ffULL,
0x0000000118107824ULL, 0x100fe200078e0200ULL, 0x0ffffff83b3b7812ULL, 0x000fe200078ef800ULL,
0x000000011a127824ULL, 0x100fe200078e0200ULL, 0x000000072a297210ULL, 0x000fe20007ffe0ffULL,
0x000000011e147824ULL, 0x040fe200078e0200ULL, 0x0000001a07357210ULL, 0x000fe20007ffe0ffULL,
0x0000000107317824ULL, 0x040fe200078e0216ULL, 0x0000001106117210ULL, 0x000fe20007f3e0ffULL,
0x0000000107337824ULL, 0x040fe200078e0218ULL, 0x0000001306137210ULL, 0x000fe20007f5e0ffULL,
0x0000000107377824ULL, 0x040fe200078e021eULL, 0x0000000906097210ULL, 0x000fe20007f1e0ffULL,
0x000000081e417824ULL, 0x000fe200078e00ffULL, 0x0000002d062d7210ULL, 0x000fe20007f7e0ffULL,
0x0000000107397824ULL, 0x000fe200078e0228ULL, 0x0000000328077819ULL, 0x040fe200000006ffULL,
0x0000000128007824ULL, 0x000fe200078e0200ULL, 0xfffffff8412c7812ULL, 0x000fe200078ee214ULL,
0x00000008183d7824ULL, 0x000fe200078e00ffULL, 0x000000042d3c7c11ULL, 0x000fe2000f8c40ffULL,
0x000000081a3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8072e7812ULL, 0x000fe200078ee200ULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0xfffffff83d287812ULL, 0x000fe200078ee210ULL,
0x000000ffff007224ULL, 0x000fe200010e06ffULL, 0xfffffff83f2a7812ULL, 0x000fe200078ee212ULL,
0x000000ffff167224ULL, 0x000fe200000e06ffULL, 0x0000000411107c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff3e7224ULL, 0x000fe200018e06ffULL, 0x0000000413127c11ULL, 0x000fe2000f8440ffULL,
0x0000001028417824ULL, 0x100fe200078e0247ULL, 0x00000004091a7c11ULL, 0x000fe2000f8040ffULL,
0x000000102a437824ULL, 0x100fe200078e0247ULL, 0x0000000511117c11ULL, 0x000fe200088f4414ULL,
0x000000102c457824ULL, 0x100fe200078e0247ULL, 0x0000000513137c11ULL, 0x000fe200090f4400ULL,
0x00000010203d7824ULL, 0x000fe200078e0247ULL, 0x0000001706177210ULL, 0x000fc40007f3e0ffULL,
0x0000001906197210ULL, 0x000fe40007f5e0ffULL, 0x0000000509077c11ULL, 0x000fe200080f4416ULL,
0x000000ffff1e7224ULL, 0x000fe200008e06ffULL, 0x0000001506157210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200010e06ffULL, 0x0000000417167c11ULL, 0x000fe4000f8240ffULL,
0x0000000419187c11ULL, 0x000fe2000f8440ffULL, 0x000000ffff307224ULL, 0x000fe200000e06ffULL,
0x0000000415147c11ULL, 0x000fc4000f8040ffULL, 0x0000000517177c11ULL, 0x000fe400088f441eULL,
0x0000000519197c11ULL, 0x000fe400090f4400ULL, 0x0000002906297210ULL, 0x000fe40007f3e0ffULL,
0x0000002b062b7210ULL, 0x000fe40007f5e0ffULL, 0x0000000515157c11ULL, 0x000fe400080f4430ULL,
0x0000001b061b7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200010e06ffULL,
0x000000ffff307210ULL, 0x000fc40000ffe4ffULL, 0x0000000429407c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x000000042b1e7c11ULL, 0x000fe4000f8440ffULL,
0x000000041b427c11ULL, 0x000fe4000f8040ffULL, 0x0000000529097c11ULL, 0x000fe200088f4430ULL,
0x000000103b297824ULL, 0x100fe200078e0247ULL, 0x000000052b007c11ULL, 0x000fe200090f4400ULL,
0x00000010252b7824ULL, 0x100fe200078e0247ULL, 0x0000003306367210ULL, 0x000fe20007f3e0ffULL,
0x0000001023337824ULL, 0x100fe200078e0247ULL, 0x0000002f063a7210ULL, 0x000fe20007f5e0ffULL,
0x000000101f3b7824ULL, 0x000fe200078e0247ULL, 0x000000051b1b7c11ULL, 0x000fc400080f4432ULL,
0x0000003106387210ULL, 0x000fe20007f1e0ffULL, 0x0000001027317824ULL, 0x100fe200078e0247ULL,
0x000000052d3e7c11ULL, 0x000fe2000b0f443eULL, 0x00000010262d7824ULL, 0x100fe200078e0247ULL,
0x0000003506347210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff277224ULL, 0x000fe200008e06ffULL,
0x0000003706327210ULL, 0x000fe20007f9e0ffULL, 0x0000001022357824ULL, 0x100fe200078e0247ULL,
0x0000000436267c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff237224ULL, 0x000fe200010e06ffULL,
0x0000003906307210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff257224ULL, 0x000fe200000e06ffULL,
0x000000043a227c11ULL, 0x000fe2000f8440ffULL, 0x000000101d397824ULL, 0x100fe200078e0247ULL,
0x00000047242f7211ULL, 0x000fe200078e20ffULL, 0x000000ffff1d7224ULL, 0x000fe200020e06ffULL,
0x0000000438247c11ULL, 0x000fe2000f8040ffULL, 0x000000101c377824ULL, 0x000fe200078e0247ULL,
0x0000000536277c11ULL, 0x000fc400088f4427ULL, 0x000000053a237c11ULL, 0x000fe400090f4423ULL,
0x0000007003497812ULL, 0x000fe200078ec0ffULL, 0x000000ffff037224ULL, 0x000fe200028e06ffULL,
0x000000ffff1f7210ULL, 0x000fe40001ffe4ffULL, 0x0000000434287c11ULL, 0x000fe4000f8240ffULL,
0x00000004322a7c11ULL, 0x000fe4000f8440ffULL, 0x00000004302c7c11ULL, 0x000fc4000f8640ffULL,
0x00000047213f7211ULL, 0x000fe200078e20ffULL, 0x000000102e477824ULL, 0x000fe200078e0247ULL,
0x0000000538257c11ULL, 0x000fe400080f4425ULL, 0x0000001a49067210ULL, 0x000fe40007f1e0ffULL,
0x0000000534347c11ULL, 0x000fe400088f441fULL, 0x00000005322e7c11ULL, 0x000fe200090f441dULL,
0x000000ffff077224ULL, 0x000fe200000e0607ULL, 0x0000001049107210ULL, 0x000fc40007f3e0ffULL,
0x0000000530037c11ULL, 0x000fe400098f4403ULL, 0x0000001249127210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x0000001449147210ULL, 0x000fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006297faeULL, 0x0003e2000b901c46ULL,
0x0000001649167210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200010e0613ULL,
0x0000001849187210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0x00000042491a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff177224ULL, 0x000fe200028e0617ULL,
0x00000040491c7210ULL, 0x000fe20007f3e0ffULL, 0x00000000102b7faeULL, 0x0005e2000b901c46ULL,
0x0000001e491e7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200000e061bULL,
0x0000003c49207210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e0609ULL,
0x0000002249227210ULL, 0x000fe20007fbe0ffULL, 0x00000000122d7faeULL, 0x0007e2000b901c46ULL,
0x00000019ff197210ULL, 0x000fe200027fe4ffULL, 0x000000ffff1f7224ULL, 0x000fe200010e0600ULL,
0x0000002449247210ULL, 0x000fe20007f9e0ffULL, 0x00000000142f7faeULL, 0x0009e2000b901c46ULL,
0x0000002649267210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff217224ULL, 0x000fe200018e063eULL,
0x0000002849287210ULL, 0x000fe20007f3e0ffULL, 0x0000000016317faeULL, 0x0009e2000b901c46ULL,
0x0000002a492a7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff237224ULL, 0x000fe200028e0623ULL,
0x0000002c492c7210ULL, 0x000fe20007f7e0ffULL, 0x0000000018337faeULL, 0x0009e2000b901c46ULL,
0x000000ffff257224ULL, 0x000fe200020e0625ULL, 0x00000034ff297210ULL, 0x002fe20000ffe4ffULL,
0x000000ffff277224ULL, 0x000fe200000e0627ULL, 0x000000001a357faeULL, 0x0003e2000b901c46ULL,
0x000000ffff2b7224ULL, 0x004fc400010e062eULL, 0x000000ffff2d7224ULL, 0x008fe200018e0603ULL,
0x000000001c377faeULL, 0x0003e8000b901c46ULL, 0x000000001e397faeULL, 0x0003e8000b901c46ULL,
0x00000000203b7faeULL, 0x0003e8000b901c46ULL, 0x00000000223d7faeULL, 0x0003e8000b901c46ULL,
0x00000000243f7faeULL, 0x0003e8000b901c46ULL, 0x0000000026417faeULL, 0x0003e8000b901c46ULL,
0x0000000028437faeULL, 0x0003e8000b901c46ULL, 0x000000002a457faeULL, 0x0003e8000b901c46ULL,
0x000000002c477faeULL, 0x0103e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000067805ULL, 0x002fe20000015200ULL, 0x01b600050b0075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff097224ULL, 0x000fce00078e00ffULL,
0x000000100900780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x0000001006037210ULL, 0x000fca0007f1e1ffULL,
0x0000000111107824ULL, 0x000fe200000e0e07ULL, 0x003d09000300780cULL, 0x000fc80003f06070ULL,
0x000000ff1000720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400300780cULL, 0x000fc80003f06070ULL, 0x000000ff1000720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011410ULL,
0x0000000300007211ULL, 0x000fca00078110ffULL, 0x000000ffff037224ULL, 0x000fca00000e0610ULL,
0x0000000200007819ULL, 0x000fc80000001203ULL, 0x000000000000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000109097836ULL, 0x000fce0000000000ULL,
0x01b600050b0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000e5b00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00009000ff037b82ULL, 0x000e620000000800ULL, 0x0000000000097919ULL, 0x000ea20000000000ULL,
0x000000085c077824ULL, 0x140fe200078e020bULL, 0xffffffff0e057810ULL, 0x000fe20007ffe0ffULL,
0x000000205c047824ULL, 0x000fe400078e020bULL, 0x0000000302067224ULL, 0x002fce00078e02ffULL,
0x000001005b037824ULL, 0x004fca00078e020dULL, 0x000000035a00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x000000015b117836ULL, 0x000fe40000000000ULL,
0x0000000f080f7224ULL, 0x000fc600078e02ffULL, 0x0000000e1100720cULL, 0x000fe40003f06070ULL,
0x0000004003117812ULL, 0x000fca00078ec0ffULL, 0x000000010a1e7824ULL, 0x000fcc00078e0211ULL,
0x0000000c00688947ULL, 0x000fea0003800000ULL, 0x00000003ff1f7819ULL, 0x004fe20000011609ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0ffffff809657812ULL, 0x000fe400078ec0ffULL,
0x000000141f457810ULL, 0x000fe20007ffe0ffULL, 0x000000011f007824ULL, 0x000fe200078e021eULL,
0x0000000b5c637211ULL, 0x000fe200078e70ffULL, 0x000000081f157836ULL, 0x000fe40000000000ULL,
0x000000041f137836ULL, 0x000fe20000000000ULL, 0x000000000f027210ULL, 0x000fe20007f1e0ffULL,
0x0000000c1f3f7836ULL, 0x000fc40000000000ULL, 0x000000101f417836ULL, 0x000fe20000000000ULL,
0x00000009132e7210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00000004022c7c11ULL, 0x040fe2000f8040ffULL, 0x0000000115107824ULL, 0x100fe200078e021eULL,
0x0000000341477819ULL, 0x000fe200000006ffULL, 0x000000013f127824ULL, 0x100fe200078e021eULL,
0x00000005022d7c11ULL, 0x000fe200080f4411ULL, 0x0000000141147824ULL, 0x100fe200078e021eULL,
0x0000001e13027210ULL, 0x000fe20007ffe0ffULL, 0x000000015a007824ULL, 0x000fe200078e0a03ULL,
0x000000100f107210ULL, 0x000fe20007fbe0ffULL, 0x0000000813177824ULL, 0x000fe200078e00ffULL,
0x000000020f027210ULL, 0x000fe20007f9e0ffULL, 0x0000000115307824ULL, 0x040fe200078e0209ULL,
0x000000120f127210ULL, 0x000fe20007f5e0ffULL, 0x0000000815197824ULL, 0x040fe200078e00ffULL,
0x000000140f147210ULL, 0x000fe20007f7e0ffULL, 0x000000181f497836ULL, 0x000fe20000000000ULL,
0x000000001500720cULL, 0x080fe20003f06070ULL, 0x000000ffff157224ULL, 0x000fe200028e06ffULL,
0xfffffff8172e7812ULL, 0x000fe200078ee22eULL, 0x000000ffff177224ULL, 0x000fe200020e06ffULL,
0x000000001300720cULL, 0x000fe20003f26070ULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x0000000410287c11ULL, 0x000fe2000f8a40ffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x00000004022a7c11ULL, 0x000fe2000f8840ffULL, 0x0000001c1f3d7836ULL, 0x000fe20000000000ULL,
0x0000000412267c11ULL, 0x000fe2000f8440ffULL, 0x000000201f3b7836ULL, 0x000fe20000000000ULL,
0x0000000414247c11ULL, 0x000fe2000f8640ffULL, 0x000000241f317836ULL, 0x000fe20000000000ULL,
0x0000000510297c11ULL, 0x000fe2000a8f4415ULL, 0x0000000149107824ULL, 0x100fe200078e021eULL,
0x00000005022b7c11ULL, 0x000fe2000a0f4417ULL, 0x0000000145027824ULL, 0x100fe200078e021eULL,
0x0000000512277c11ULL, 0x000fe200090f4413ULL, 0x000000013d127824ULL, 0x100fe200078e021eULL,
0x0000000514257c11ULL, 0x000fe200098f4411ULL, 0x000000013b147824ULL, 0x100fe200078e021eULL,
0x000000100f107210ULL, 0x000fe20007fbe0ffULL, 0x000000281f337836ULL, 0x000fe20000000000ULL,
0x000000020f027210ULL, 0x000fe20007f9e0ffULL, 0x0000002c1f357836ULL, 0x000fe20000000000ULL,
0x000000120f127210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff157224ULL, 0x000fe200028e06ffULL,
0x000000140f147210ULL, 0x000fe20007f7e0ffULL, 0x000000301f377836ULL, 0x000fe20000000000ULL,
0x000000ffff177210ULL, 0x000fe200027fe4ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x0000000402227c11ULL, 0x000fe2000f8840ffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x0000000410207c11ULL, 0x000fe2000f8a40ffULL, 0x000000341f397836ULL, 0x000fe20000000000ULL,
0x00000004121c7c11ULL, 0x000fe2000f8440ffULL, 0x0000000141367824ULL, 0x000fe200078e0209ULL,
0x00000004141a7c11ULL, 0x000fe2000f8640ffULL, 0x00003000635d7836ULL, 0x000fe20000000000ULL,
0x0000000502237c11ULL, 0x000fe2000a0f4417ULL, 0x00000008454b7824ULL, 0x000fe200078e00ffULL,
0x0000000510217c11ULL, 0x000fe2000a8f4415ULL, 0x0000000133107824ULL, 0x100fe200078e021eULL,
0x00000005121d7c11ULL, 0x000fe200090f4413ULL, 0x0000000135127824ULL, 0x100fe200078e021eULL,
0x00000005141b7c11ULL, 0x000fe200098f4411ULL, 0x0000000137147824ULL, 0x000fe200078e021eULL,
0x0000001e31027210ULL, 0x000fe20007ffe0ffULL, 0x000000013b387824ULL, 0x000fe200078e0209ULL,
0x000000100f157210ULL, 0x000fc40007fbe0ffULL, 0x000000020f177210ULL, 0x000fe40007f9e0ffULL,
0x000000120f127210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff327224ULL, 0x000fe200028e06ffULL,
0x000000140f027210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff347224ULL, 0x000fe200020e06ffULL,
0x0000000417187c11ULL, 0x000fe2000f8840ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x0000000415167c11ULL, 0x000fe2000f8a40ffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x0000000412147c11ULL, 0x000fc4000f8440ffULL, 0x0000000402107c11ULL, 0x000fe4000f8640ffULL,
0xfffffff819307812ULL, 0x000fe400078ee230ULL, 0x0000000517197c11ULL, 0x000fe2000a0f4434ULL,
0x000000013f347824ULL, 0x000fe200078e0209ULL, 0x0000000515177c11ULL, 0x000fe4000a8f4432ULL,
0x0000000512157c11ULL, 0x000fe200090f4413ULL, 0x000000011f127824ULL, 0x000fe200078e0209ULL,
0x0000000502117c11ULL, 0x000fc400098f4411ULL, 0x0000000709027812ULL, 0x000fe400078ec0ffULL,
0x000000001f00720cULL, 0x080fe40003f66070ULL, 0x00000008022f7812ULL, 0x000fe400078efcffULL,
0x0000000765327812ULL, 0x000fe200078ef812ULL, 0x0000000139127824ULL, 0x000fe200078e021eULL,
0x000000004100720cULL, 0x080fe20003fa6070ULL, 0x000000102f407825ULL, 0x000fe200078e002cULL,
0x000000003f00720cULL, 0x000fc40003f46070ULL, 0x000000120f137210ULL, 0x000fe20007f9e0ffULL,
0x000000381f2d7836ULL, 0x000fe20000000000ULL, 0xfffffff847367812ULL, 0x000fe200078ee236ULL,
0x000000083f3f7824ULL, 0x000fe400078e00ffULL, 0x0000001032437824ULL, 0x000fe400078e025dULL,
0x000000012d2c7824ULL, 0x000fe200078e021eULL, 0xfffffff83f347812ULL, 0x000fe200078ee234ULL,
0x000000ffff327224ULL, 0x000fe200020e06ffULL, 0x0000000413127c11ULL, 0x000fe2000f8840ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000040437faeULL, 0x0003e2000d901c46ULL,
0x0000003c1f3f7836ULL, 0x000fe20000000000ULL, 0x0000002c0f1f7210ULL, 0x000fe20007f7e0ffULL,
0x000000102f2a7825ULL, 0x000fe200078e002aULL, 0x0000000513137c11ULL, 0x000fc4000a0f4432ULL,
0x000000004500720cULL, 0x040fe20003f86070ULL, 0x0000000145327824ULL, 0x000fe200078e0209ULL,
0x0000001e3f2c7210ULL, 0x000fe20007ffe0ffULL, 0x000000102e457824ULL, 0x100fe200078e025dULL,
0x000000041f1e7c11ULL, 0x000fe2000f8c40ffULL, 0x000000ffff2e7224ULL, 0x000fe200018e06ffULL,
0x0000002c0f2c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001030477824ULL, 0x000fe200078e025dULL,
0x000000002a457faeULL, 0x000fe2000c901c46ULL, 0x000000102f287825ULL, 0x000fe200078e0028ULL,
0x000000051f1f7c11ULL, 0x000fc4000b0f442eULL, 0x000000004900720cULL, 0x0c0fe20003f26070ULL,
0x00000001492e7824ULL, 0x140fe200078e0209ULL, 0x0000000028477faeULL, 0x0005e2000c101c46ULL,
0x0000000849497824ULL, 0x000fe200078e00ffULL, 0x000000003d00720cULL, 0x0c0fe20003f06070ULL,
0x000000013d307824ULL, 0x040fe200078e0209ULL, 0xfffffff84b327812ULL, 0x000fe200078ee232ULL,
0x000000083d417824ULL, 0x002fe200078e00ffULL, 0x000000ffff3d7210ULL, 0x000fe20001ffe4ffULL,
0x00000010340f7824ULL, 0x000fe200078e025dULL, 0x000000003b00720cULL, 0x040fe20003f66070ULL,
0x000000083b3b7824ULL, 0x000fe200078e00ffULL, 0xfffffff8492e7812ULL, 0x000fe200078ee22eULL,
0x000000102f267825ULL, 0x000fe200078e0026ULL, 0x000000042c287c11ULL, 0x004fc4000f8c40ffULL,
0xfffffff841307812ULL, 0x000fe200078ee230ULL, 0x00000010362b7824ULL, 0x000fe200078e025dULL,
0xfffffff83b387812ULL, 0x000fe200078ee238ULL, 0x000000102f247825ULL, 0x000fe200078e0024ULL,
0x000000052c297c11ULL, 0x000fe2000b0f443dULL, 0x00000000260f7faeULL, 0x0003e2000d101c46ULL,
0x0000005d38437211ULL, 0x000fe200078e20ffULL, 0x00000010323b7824ULL, 0x000fe200078e025dULL,
0x000000003500720cULL, 0x080fe20003f46070ULL, 0x000000102f227825ULL, 0x000fe200078e0022ULL,
0x00000000242b7faeULL, 0x000fe2000e901c46ULL, 0x000000002d00720cULL, 0x000fc40003fa6070ULL,
0x000000102e3d7824ULL, 0x000fe200078e025dULL, 0x00000000223b7faeULL, 0x0005e2000e101c46ULL,
0x000000102f207825ULL, 0x000fe200078e0020ULL, 0x000000003900720cULL, 0x080fe40003f86070ULL,
0x000000003f00720cULL, 0x080fe20003fc6070ULL, 0x0000001030417824ULL, 0x000fe200078e025dULL,
0x00000000203d7faeULL, 0x000fe2000c901c46ULL, 0x000000102f1c7825ULL, 0x000fe200078e001cULL,
0x000000003300720cULL, 0x000fc60003f26070ULL, 0x000000102f1a7825ULL, 0x000fe200078e001aULL,
0x000000001c417faeULL, 0x000fe2000c101c46ULL, 0x000000003100720cULL, 0x0c0fe40003f06070ULL,
0x00000001310f7824ULL, 0x142fe200078e0209ULL, 0x000000001a437faeULL, 0x0003e2000d901c46ULL,
0x00000008312a7824ULL, 0x000fe200078e00ffULL, 0x000000003700720cULL, 0x000fe20003f66070ULL,
0x0000000133267824ULL, 0x100fe400078e0209ULL, 0x0000000135227824ULL, 0x004fe200078e0209ULL,
0xfffffff82a007812ULL, 0x000fe200078ee20fULL, 0x0000000833337824ULL, 0x000fc400078e00ffULL,
0x0000000835357824ULL, 0x000fe400078e00ffULL, 0x00000001370f7824ULL, 0x140fe200078e0209ULL,
0x00000003371a7819ULL, 0x002fe200000006ffULL, 0x00000001391b7824ULL, 0x140fe200078e0209ULL,
0xfffffff833267812ULL, 0x000fe200078ee226ULL, 0x00000008391c7824ULL, 0x000fe200078e00ffULL,
0xfffffff835227812ULL, 0x000fe200078ee222ULL, 0x000000012d1d7824ULL, 0x140fe200078e0209ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee20fULL, 0x000000082d207824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee21bULL, 0x000000013f217824ULL, 0x040fe200078e0209ULL,
0x0000005d261b7211ULL, 0x000fe200078e20ffULL, 0x000000083f247824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee21dULL, 0x00000010000f7824ULL, 0x000fc400078e025dULL,
0x000000102f187825ULL, 0x000fe200078e0018ULL, 0xfffffff824247812ULL, 0x000fc600078ee221ULL,
0x000000102f167825ULL, 0x040fe200078e0016ULL, 0x00000000180f7faeULL, 0x0003e6000c101c46ULL,
0x000000102f147825ULL, 0x040fe200078e0014ULL, 0x00000000161b7faeULL, 0x0003e6000c901c46ULL,
0x00000010221d7824ULL, 0x000fe400078e025dULL, 0x000000102f107825ULL, 0x000fc600078e0010ULL,
0x00000000141d7faeULL, 0x0003e2000d101c46ULL, 0x000000101a217824ULL, 0x000fe400078e025dULL,
0x000000102f127825ULL, 0x000fc600078e0012ULL, 0x0000000010217faeULL, 0x0003e2000d901c46ULL,
0x000000101c237824ULL, 0x000fe400078e025dULL, 0x000000102f1e7825ULL, 0x000fc600078e001eULL,
0x0000000012237faeULL, 0x0003e2000e101c46ULL, 0x0000001020257824ULL, 0x000fe400078e025dULL,
0x000000102f287825ULL, 0x000fc600078e0028ULL, 0x000000001e257faeULL, 0x0003e2000e901c46ULL,
0x0000001024277824ULL, 0x000fca00078e025dULL, 0x0000000028277faeULL, 0x0003e2000f101c46ULL,
0x0000000c001c7947ULL, 0x000fea0003800000ULL, 0x0000000809127811ULL, 0x044fe200078fe8ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000409107811ULL, 0x040fe200078fe8ffULL,
0x000040005c637824ULL, 0x000fe200078e020bULL, 0x0000000912467210ULL, 0x000fe20007ffe0ffULL,
0x0000000812157824ULL, 0x000fe200078e00ffULL, 0x00000014091a7811ULL, 0x040fe200078fe8ffULL,
0x0000000110487824ULL, 0x140fe200078e0209ULL, 0x0000001009167811ULL, 0x040fe200078fe8ffULL,
0x0000000810117824ULL, 0x000fe200078e00ffULL, 0xfffffff815467812ULL, 0x000fe200078ee246ULL,
0x000000011a407824ULL, 0x140fe200078e0209ULL, 0x0000002409217811ULL, 0x040fe200078fe8ffULL,
0x000000081a157824ULL, 0x000fe200078e00ffULL, 0xfffffff811487812ULL, 0x000fe200078ee248ULL,
0x0000000116427824ULL, 0x140fe200078e0209ULL, 0x0000002009207811ULL, 0x040fe200078fe8ffULL,
0x0000000816117824ULL, 0x000fe200078e00ffULL, 0x0000001e09007211ULL, 0x000fe200078fe8ffULL,
0x0000000121387824ULL, 0x140fe200078e0209ULL, 0xfffffff815407812ULL, 0x000fe200078ee240ULL,
0x0000000821157824ULL, 0x000fe200078e00ffULL, 0x0000001c091f7811ULL, 0x040fe200078fe8ffULL,
0x00000001203a7824ULL, 0x140fe200078e0209ULL, 0xfffffff811427812ULL, 0x000fe200078ee242ULL,
0x0000000820117824ULL, 0x000fe200078e00ffULL, 0x0000000c09137811ULL, 0x000fe200078fe8ffULL,
0x000000011f3c7824ULL, 0x100fe200078e0209ULL, 0x0000003009317811ULL, 0x000fe200078fe8ffULL,
0x000000081f197824ULL, 0x000fe200078e00ffULL, 0x000000000f027210ULL, 0x000fe20007f1e0ffULL,
0x0000000113447824ULL, 0x140fe200078e0209ULL, 0xfffffff815387812ULL, 0x000fe200078ee238ULL,
0x0000000813177824ULL, 0x000fe200078e00ffULL, 0x0000002c09237811ULL, 0x000fe200078fe8ffULL,
0x0000000131327824ULL, 0x140fe200078e0209ULL, 0xfffffff8113a7812ULL, 0x000fe200078ee23aULL,
0x0000000831157824ULL, 0x000fe200078e00ffULL, 0x00000018091b7811ULL, 0x000fe200078fe8ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x0000000402147c11ULL, 0x000fe2000f8040ffULL,
0x0000000123347824ULL, 0x040fe200078e0209ULL, 0xfffffff8193c7812ULL, 0x000fe200078ee23cULL,
0x0000000823197824ULL, 0x000fe200078e00ffULL, 0xfffffff817447812ULL, 0x000fe200078ee244ULL,
0x000000081b177824ULL, 0x000fe200078e00ffULL, 0xfffffff815327812ULL, 0x000fe200078ee232ULL,
0x0000000116167824ULL, 0x000fe200078e021eULL, 0x0000003809357811ULL, 0x000fc400078fe8ffULL,
0x0000000502157c11ULL, 0x000fe200080f4411ULL, 0x0000000110027824ULL, 0x100fe200078e021eULL,
0x000000091b3e7210ULL, 0x000fe20007ffe0ffULL, 0x0000000112107824ULL, 0x100fe200078e021eULL,
0x0000002809227811ULL, 0x000fe200078fe8ffULL, 0x0000000113127824ULL, 0x000fe200078e021eULL,
0xfffffff819347812ULL, 0x000fe200078ee234ULL, 0x0000000835197824ULL, 0x000fe200078e00ffULL,
0xfffffff8173e7812ULL, 0x000fe200078ee23eULL, 0x0000000822177824ULL, 0x000fe200078e00ffULL,
0x0000000935007210ULL, 0x000fc40007ffe0ffULL, 0x000000020f027210ULL, 0x000fe40007f1e0ffULL,
0x0000000922367210ULL, 0x000fe40007ffe0ffULL, 0x0000003409337811ULL, 0x000fe400078fe8ffULL,
0xfffffff819007812ULL, 0x000fe200078ee200ULL, 0x000000ffff197224ULL, 0x000fe200000e06ffULL,
0xfffffff817367812ULL, 0x000fe200078ee236ULL, 0x0000000133307824ULL, 0x040fe200078e0209ULL,
0x000000160f167210ULL, 0x000fe20007f7e0ffULL, 0x0000000833177824ULL, 0x000fe200078e00ffULL,
0x0000000402287c11ULL, 0x000fc4000f8040ffULL, 0x000000120f127210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe200018e06ffULL, 0x000000100f107210ULL, 0x000fe40007f3e0ffULL,
0x0000000502297c11ULL, 0x000fe200080f4419ULL, 0x000000011a027824ULL, 0x100fe200078e021eULL,
0xfffffff817307812ULL, 0x000fe200078ee230ULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x000000ffff177210ULL, 0x000fe20000ffe4ffULL, 0x00000001331a7824ULL, 0x000fe200078e021eULL,
0x0000000416267c11ULL, 0x000fc4000f8640ffULL, 0x0000000410187c11ULL, 0x000fe4000f8240ffULL,
0x00000004121c7c11ULL, 0x000fe4000f8440ffULL, 0x0000000516277c11ULL, 0x000fe200098f4411ULL,
0x0000000120167824ULL, 0x100fe200078e021eULL, 0x000000020f027210ULL, 0x000fe40007f1e0ffULL,
0x0000000510197c11ULL, 0x000fe200088f4417ULL, 0x000000011b107824ULL, 0x100fe200078e021eULL,
0x00000005121d7c11ULL, 0x000fe200090f4413ULL, 0x000000011f127824ULL, 0x000fe200078e021eULL,
0x000000160f167210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200000e06ffULL,
0x00000004022e7c11ULL, 0x000fc4000f8040ffULL, 0x000000100f107210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe200018e06ffULL, 0x000000120f127210ULL, 0x000fe40007f5e0ffULL,
0x00000005022f7c11ULL, 0x000fe200080f441bULL, 0x0000000121027824ULL, 0x000fe200078e021eULL,
0x000000ffff177210ULL, 0x000fe20000ffe4ffULL, 0x000000ffff137224ULL, 0x000fe200010e06ffULL,
0x00000004102a7c11ULL, 0x000fe4000f8240ffULL, 0x0000000416247c11ULL, 0x000fc4000f8640ffULL,
0x00000004122c7c11ULL, 0x000fe4000f8440ffULL, 0x00000005102b7c11ULL, 0x000fe200088f4417ULL,
0x0000000122107824ULL, 0x100fe200078e021eULL, 0x0000000516257c11ULL, 0x000fe200098f4411ULL,
0x0000000131167824ULL, 0x100fe200078e021eULL, 0x000000020f027210ULL, 0x000fe40007f9e0ffULL,
0x00000005122d7c11ULL, 0x000fe200090f4413ULL, 0x0000000123127824ULL, 0x000fe200078e021eULL,
0x0000003c09117811ULL, 0x000fe200078fe8ffULL, 0x000000ffff1f7224ULL, 0x000fe200020e06ffULL,
0x0000001e35207210ULL, 0x000fc40007ffe0ffULL, 0x000000100f107210ULL, 0x000fe20007f3e0ffULL,
0x00000001111e7824ULL, 0x040fe200078e021eULL, 0x0000000402227c11ULL, 0x040fe2000f8c40ffULL,
0x00000001114a7824ULL, 0x040fe200078e0209ULL, 0x000000120f127210ULL, 0x000fe20007f7e0ffULL,
0x0000000811217824ULL, 0x000fe200078e00ffULL, 0x000000160f1b7210ULL, 0x000fe40007f5e0ffULL,
0x0000000909167211ULL, 0x040fe400078fe8ffULL, 0x0ffffff809657812ULL, 0x000fe200078ec0ffULL,
0x000000ffff547224ULL, 0x000fe200010e06ffULL, 0x0000000502237c11ULL, 0x000fe2000b0f441fULL,
0x000000ffff1f7224ULL, 0x000fe200008e06ffULL, 0x0000001a0f177210ULL, 0x000fc40007f1e0ffULL,
0x000000200f137210ULL, 0x000fe40007fbe0ffULL, 0x0000001e0f117210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff0f7224ULL, 0x000fe200018e06ffULL, 0x0000000709027812ULL, 0x000fe200078ec0ffULL,
0x000000ffff527224ULL, 0x000fe200000e06ffULL, 0x0000000410207c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff507224ULL, 0x000fe200028e06ffULL, 0x00000004121e7c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff4e7224ULL, 0x000fe200020e06ffULL, 0x0000000765167812ULL, 0x000fc400078ef816ULL,
0x00003000635d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8214a7812ULL, 0x000fe400078ee24aULL,
0x0000000510217c11ULL, 0x000fe200088f441fULL, 0x0000001042337824ULL, 0x100fe200078e025dULL,
0x0000000802317812ULL, 0x000fe200078efcffULL, 0x0000001040357824ULL, 0x000fe200078e025dULL,
0x00000005121f7c11ULL, 0x000fe200098f440fULL, 0x00000010160f7824ULL, 0x000fe200078e025dULL,
0x000000041b1a7c11ULL, 0x000fe2000f8240ffULL, 0x00000010314c7825ULL, 0x000fe200078e0014ULL,
0x0000000417167c11ULL, 0x000fc4000f8040ffULL, 0x0000000413127c11ULL, 0x000fe2000f8440ffULL,
0x0000001031147825ULL, 0x000fe200078e0028ULL, 0x0000000411107c11ULL, 0x000fe2000f8640ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000004c0f7faeULL, 0x0003e2000b901c46ULL,
0x000000051b1b7c11ULL, 0x000fe200088f4454ULL, 0x0000001031287825ULL, 0x000fe200078e002eULL,
0x0000000517177c11ULL, 0x000fe400080f4452ULL, 0x0000000513137c11ULL, 0x000fe200090f4450ULL,
0x0000001031187825ULL, 0x000fe200078e0018ULL, 0x0000000511117c11ULL, 0x000fc600098f444eULL,
0x00000010311c7825ULL, 0x000fc800078e001cULL, 0x00000010480f7824ULL, 0x002fe400078e025dULL,
0x0000001031267825ULL, 0x000fc600078e0026ULL, 0x00000000140f7faeULL, 0x0003e2000b901c46ULL,
0x00000010312a7825ULL, 0x000fc800078e002aULL, 0x00000010312c7825ULL, 0x000fc800078e002cULL,
0x0000001031247825ULL, 0x000fe200078e0024ULL, 0x0000005d340f7211ULL, 0x002fc600078e20ffULL,
0x0000001031227825ULL, 0x000fc800078e0022ULL, 0x0000001031207825ULL, 0x000fc800078e0020ULL,
0x00000010311e7825ULL, 0x000fc800078e001eULL, 0x00000010311a7825ULL, 0x000fc800078e001aULL,
0x0000001031167825ULL, 0x000fc800078e0016ULL, 0x0000001031127825ULL, 0x000fc800078e0012ULL,
0x0000001031107825ULL, 0x000fe200078e0010ULL, 0x0000005d44317211ULL, 0x000fc600078e20ffULL,
0x00000010462f7824ULL, 0x100fe400078e025dULL, 0x000000103e377824ULL, 0x100fe400078e025dULL,
0x000000103c397824ULL, 0x100fe200078e025dULL, 0x00000000182f7faeULL, 0x0003e2000b901c46ULL,
0x000000103a3b7824ULL, 0x100fe400078e025dULL, 0x00000010383d7824ULL, 0x100fe200078e025dULL,
0x000000001c317faeULL, 0x0005e2000b901c46ULL, 0x00000010363f7824ULL, 0x000fc400078e025dULL,
0x0000001032157824ULL, 0x100fe200078e025dULL, 0x0000000026337faeULL, 0x0007e8000b901c46ULL,
0x0000000028357faeULL, 0x0009e2000b901c46ULL, 0x0000001030197824ULL, 0x002fc600078e025dULL,
0x000000002a377faeULL, 0x0003e2000b901c46ULL, 0x00000010001d7824ULL, 0x004fc600078e025dULL,
0x000000002c397faeULL, 0x0003e2000b901c46ULL, 0x000000104a277824ULL, 0x008fc600078e025dULL,
0x00000000243b7faeULL, 0x0003e8000b901c46ULL, 0x00000000223d7faeULL, 0x0003e8000b901c46ULL,
0x00000000203f7faeULL, 0x0003e8000b901c46ULL, 0x000000001e0f7faeULL, 0x0003e8000b901c46ULL,
0x000000001a157faeULL, 0x0003e8000b901c46ULL, 0x0000000016197faeULL, 0x0003e8000b901c46ULL,
0x00000000121d7faeULL, 0x0003e8000b901c46ULL, 0x0000000010277faeULL, 0x0103e4000b901c46ULL,
0x000000020c597824ULL, 0x000fe200078e0259ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff0f7424ULL, 0x002fc600078e00ffULL, 0x000000585900720cULL, 0x000fda0003f06070ULL,
0x00008c00ff108b82ULL, 0x000e620000000a00ULL, 0x0000000206138824ULL, 0x000fe200078e0259ULL,
0x00000004ff5f7819ULL, 0x100fe40000011609ULL, 0x00000003ff007819ULL, 0x000fe40000011609ULL,
0x00000008025e7812ULL, 0x000fe200078ef809ULL, 0x0000100063637836ULL, 0x000fe20000000000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000413108825ULL, 0x002fca00078e0010ULL,
0x00000006100f8981ULL, 0x0002a2000c1e1900ULL, 0x000000035f157819ULL, 0x040fe200000006ffULL,
0x000000015f5f7824ULL, 0x000fe200078e025eULL, 0x0000000100137812ULL, 0x000fe200078ec0ffULL,
0x000000105e127824ULL, 0x000fe200078e00ffULL, 0xfffffff8153c7812ULL, 0x000fca00078ee202ULL,
0x00000001133b7824ULL, 0x040fe200078e023cULL, 0xfffffff012107812ULL, 0x002fe200078ee25fULL,
0x000000083c147824ULL, 0x000fe200078e00ffULL, 0x000000025f117810ULL, 0x000fe20007ffe0ffULL,
0x000000103c3a7836ULL, 0x000fe20000000000ULL, 0x000000123b727810ULL, 0x000fe20007ffe0ffULL,
0x0000001010107824ULL, 0x000fe200078e020bULL, 0xfffffff814677812ULL, 0x000fe200078ee23bULL,
0x00000001137c7824ULL, 0x000fe200078e023aULL, 0xfffffff012127812ULL, 0x000fe200078ee211ULL,
0x000000203c397836ULL, 0x000fe20000000000ULL, 0x000000001028783bULL, 0x0003e20000000200ULL,
0x0000001067147824ULL, 0x000fe200078e0263ULL, 0x000000033a117819ULL, 0x000fe200000006ffULL,
0x00000001137a7824ULL, 0x000fe200078e0239ULL, 0x000000243b6a7810ULL, 0x000fe20007ffe0ffULL,
0x000000083c197824ULL, 0x000fe200078e00ffULL, 0xfffffff8117c7812ULL, 0x000fe200078ee27cULL,
0x000000001414783bULL, 0x000ee20000000200ULL, 0x0000000839117824ULL, 0x000fc400078e00ffULL,
0x000000023b767836ULL, 0x000fe40000000000ULL, 0x000000303c387836ULL, 0x000fe20000000000ULL,
0xfffffff8117a7812ULL, 0x000fe200078ee27aULL, 0x000000107c347824ULL, 0x100fe200078e0263ULL,
0xfffffff819767812ULL, 0x000fe200078ee276ULL, 0x0000000113787824ULL, 0x000fe200078e0238ULL,
0x00000003383d7819ULL, 0x040fe200000006ffULL, 0x0000000838117824ULL, 0x000fe400078e00ffULL,
0x0000001076507824ULL, 0x000fe200078e0263ULL, 0x000000003434783bULL, 0x000f220000000200ULL,
0x0000001012127824ULL, 0x000fe200078e020bULL, 0xfffffff811787812ULL, 0x000fe200078ee278ULL,
0x000000107a307824ULL, 0x000fc400078e0263ULL, 0x000000005050783bULL, 0x000fe20000000200ULL,
0x000000083a117824ULL, 0x000fe400078e00ffULL, 0x00000010782c7824ULL, 0x100fe200078e0263ULL,
0x000000001220783bULL, 0x000f620000000200ULL, 0x000000223b687836ULL, 0x000fe20000000000ULL,
0xfffffff811727812ULL, 0x000fe200078ee272ULL, 0x0000000839197824ULL, 0x000fe200078e00ffULL,
0x000000003030783bULL, 0x000f620000000200ULL, 0x000000323b707836ULL, 0x000fe40000000000ULL,
0x0000001072107824ULL, 0x102fe200078e0263ULL, 0x000000002c2c783bULL, 0x000e620000000200ULL,
0xfffffff819687812ULL, 0x000fe200078ee268ULL, 0x000000343b667836ULL, 0x000fe20000000000ULL,
0xfffffff83d707812ULL, 0x000fe200078ee270ULL, 0x000000043b747836ULL, 0x000fe20000000000ULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0x0000001068187824ULL, 0x000fe200078e0263ULL,
0xfffffff83d667812ULL, 0x000fe200078ee266ULL, 0x000000143b6e7836ULL, 0x000fe20000000000ULL,
0x000000142824723cULL, 0x008fe200000018ffULL, 0x000000363b607836ULL, 0x000fc40000000000ULL,
0x000000001818783bULL, 0x000ee20000000200ULL, 0x0000001066407824ULL, 0x100fe400078e0263ULL,
0x000000162814723cULL, 0x000fe200000018ffULL, 0x000000163b647836ULL, 0x000fe40000000000ULL,
0x000000263b627836ULL, 0x000fe20000000000ULL, 0x000000004040783bULL, 0x000fe20000000200ULL,
0x000000063b6c7836ULL, 0x000fe20000000000ULL, 0x00000034284c723cULL, 0x010fec00000018ffULL,
0x000000362834723cULL, 0x000fec00000018ffULL, 0x000000502024723cULL, 0x020fec0000001824ULL,
0x000000522050723cULL, 0x000fec0000001814ULL, 0x000000302814723cULL, 0x000fec00000018ffULL,
0x0000002c281c723cULL, 0x002fec00000018ffULL, 0x000000322830723cULL, 0x000fe200000018ffULL,
0x00000010702c7824ULL, 0x000fca00078e0263ULL, 0x0000002e2828723cULL, 0x000fe200000018ffULL,
0x000000002c2c783bULL, 0x000e6a0000000200ULL, 0x00000010204c723cULL, 0x000fec000000184cULL,
0x000000122010723cULL, 0x000fec0000001834ULL, 0x000000182014723cULL, 0x008fe20000001814ULL,
0x000000105e357824ULL, 0x000fc400078e00ffULL, 0x000000045f347836ULL, 0x000fe40000000000ULL,
0x0000000839377824ULL, 0x040fe400078e00ffULL, 0x000000083c197824ULL, 0x000fe200078e00ffULL,
0xfffffff035347812ULL, 0x000fe200078ee234ULL, 0x000000083a357824ULL, 0x000fe200078e00ffULL,
0xfffffff8376a7812ULL, 0x000fe200078ee26aULL, 0x0000000839397824ULL, 0x000fe200078e00ffULL,
0xfffffff819747812ULL, 0x000fe200078ee274ULL, 0x0000001034347824ULL, 0x000fe200078e020bULL,
0x0000001a2018723cULL, 0x000fe20000001830ULL, 0xfffffff8356e7812ULL, 0x000fe200078ee26eULL,
0x000000106a447824ULL, 0x100fe200078e0263ULL, 0xfffffff839627812ULL, 0x000fe200078ee262ULL,
0x0000001074547824ULL, 0x000fe200078e0263ULL, 0x000000636e487211ULL, 0x000fc400078e20ffULL,
0x000000083c337824ULL, 0x000fe200078e00ffULL, 0x000000004444783bULL, 0x000fe20000000200ULL,
0x000000105e317824ULL, 0x000fe200078e00ffULL, 0x0000002c201c723cULL, 0x002fe2000000181cULL,
0x000000065f307836ULL, 0x000fe20000000000ULL, 0x00000000343c783bULL, 0x0002e20000000200ULL,
0xfffffff8336c7812ULL, 0x000fc600078ee26cULL, 0xfffffff031307812ULL, 0x000fe200078ee230ULL,
0x0000002e2020723cULL, 0x000fe20000001828ULL, 0x0000000338317819ULL, 0x000fe200000006ffULL,
0x000000005454783bULL, 0x000f220000000200ULL, 0x000000083a2d7824ULL, 0x000fe400078e00ffULL,
0xfffffff831607812ULL, 0x000fe200078ee260ULL, 0x000000004848783bULL, 0x000f620000000200ULL,
0x0000001030617824ULL, 0x000fe200078e020bULL, 0xfffffff82d647812ULL, 0x000fe200078ee264ULL,
0x0000001062307824ULL, 0x000fc400078e0263ULL, 0x00000010602c7824ULL, 0x100fe200078e0263ULL,
0x000000006128783bULL, 0x0003e20000000200ULL, 0x000000106c387824ULL, 0x100fe400078e0263ULL,
0x0000001064347824ULL, 0x002fe200078e0263ULL, 0x000000003030783bULL, 0x000fe80000000200ULL,
0x000000002c2c783bULL, 0x000e620000000200ULL, 0x000000010c617824ULL, 0x000fc600078e025bULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000003434783bULL, 0x000e620000000200ULL,
0x000000403c1c723cULL, 0x008fec000000181cULL, 0x000000423c20723cULL, 0x000fec0000001820ULL,
0x000000463c18723cULL, 0x000fec0000001818ULL, 0x000000543c24723cULL, 0x010fec0000001824ULL,
0x000000563c50723cULL, 0x000fec0000001850ULL, 0x000000483c4c723cULL, 0x020fec000000184cULL,
0x0000004a3c10723cULL, 0x000fec0000001810ULL, 0x000000443c14723cULL, 0x000fec0000001814ULL,
0x0000002c281c723cULL, 0x002fec000000181cULL, 0x0000002e282c723cULL, 0x000fec0000001820ULL,
0x000000322818723cULL, 0x000fe20000001818ULL, 0x0000000161217810ULL, 0x000fe20007ffe0ffULL,
0x0000010061207824ULL, 0x000fc600078e020dULL, 0x0000000e2100720cULL, 0x000fe20003f06070ULL,
0x000000382824723cULL, 0x000fe20000001824ULL, 0x0000004020337812ULL, 0x000fca00078ec0ffULL,
0x0000003a2850723cULL, 0x000fe20000001850ULL, 0x000000010a337824ULL, 0x000fca00078e0233ULL,
0x00000034284c723cULL, 0x000fec000000184cULL, 0x000000362810723cULL, 0x000fec0000001810ULL,
0x000000302814723cULL, 0x000fe20000001814ULL, 0x000000080f237224ULL, 0x004fe200078e02ffULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000c00988947ULL, 0x000fde0003800000ULL,
0x00000004002a7836ULL, 0x000fe20000000000ULL, 0x000000205a357248ULL, 0x000fe20007fe0000ULL,
0x0000001000387836ULL, 0x000fe20000000000ULL, 0x0000000800307810ULL, 0x000fe20007ffe0ffULL,
0x000000012a217824ULL, 0x140fe400078e0209ULL, 0x000000082a227824ULL, 0x000fe200078e00ffULL,
0x00000003382b7819ULL, 0x000fe200000006ffULL, 0x0000000135357824ULL, 0x000fe400078e0a20ULL,
0x00000001303e7824ULL, 0x000fe200078e0209ULL, 0xfffffff822207812ULL, 0x000fe200078ee221ULL,
0x0000000100227824ULL, 0x100fe200078e0233ULL, 0x000000352a00720cULL, 0x0c0fe20003f86070ULL,
0x000000012a2a7824ULL, 0x100fe200078e0233ULL, 0x000000353000720cULL, 0x0c0fe20003f06070ULL,
0x0000000830217824ULL, 0x040fe200078e00ffULL, 0x0000002223327210ULL, 0x000fe20007f3e0ffULL,
0x0000000130227824ULL, 0x100fe200078e0233ULL, 0x0000002a232a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000c00347836ULL, 0x000fe20000000000ULL, 0xfffffff8213e7812ULL, 0x000fe200078ee23eULL,
0x000000ffff217224ULL, 0x000fe200008e06ffULL, 0x0000000432397c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff377224ULL, 0x000fe200010e06ffULL, 0x00000022233a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000134227824ULL, 0x000fe200078e0233ULL, 0x000000042a317c11ULL, 0x000fe2000f8440ffULL,
0x00000001343c7824ULL, 0x000fe200078e0209ULL, 0x0000000532327c11ULL, 0x000fe200088f4421ULL,
0x000000ffff217224ULL, 0x000fe200018e06ffULL, 0x000000043a3d7c11ULL, 0x000fe2000f8640ffULL,
0x0000000834297824ULL, 0x000fe200078e00ffULL, 0x000000052a377c11ULL, 0x000fe200090f4437ULL,
0x0000000138367824ULL, 0x100fe200078e0209ULL, 0x00000033382a7210ULL, 0x000fe20007ffe0ffULL,
0x0000001400407836ULL, 0x000fe20000000000ULL, 0x000000353400720cULL, 0x080fe20003f26070ULL,
0x0000000100287824ULL, 0x000fe200078e0209ULL, 0x000000053a3a7c11ULL, 0x000fe200098f4421ULL,
0x0000000140307824ULL, 0x000fe200078e0233ULL, 0x000000353800720cULL, 0x000fe20003f66070ULL,
0x0000001020417824ULL, 0x100fe200078e0263ULL, 0x0000002a23347210ULL, 0x000fe20007fbe0ffULL,
0x0000001c00447836ULL, 0x000fe20000000000ULL, 0x0000002223387210ULL, 0x000fe20007f5e0ffULL,
0x0000001009227824ULL, 0x000fe200078e00ffULL, 0xfffffff82b367812ULL, 0x000fe200078ee236ULL,
0x000000ffff217224ULL, 0x000fe200028e06ffULL, 0xfffffff8293c7812ULL, 0x000fe200078ee23cULL,
0x000000ffff2b7224ULL, 0x000fe200010e06ffULL, 0x00000004343b7c11ULL, 0x000fe2000f8a40ffULL,
0x0000001036477824ULL, 0x100fe200078e0263ULL, 0x0000000438297c11ULL, 0x000fe2000f8440ffULL,
0x000000103c457824ULL, 0x000fe200078e0263ULL, 0x0000007022227812ULL, 0x000fc400078ec0ffULL,
0x0000000534347c11ULL, 0x000fe2000a8f4421ULL, 0x0000000140217824ULL, 0x000fe200078e0209ULL,
0x0000000538387c11ULL, 0x000fe400090f442bULL, 0x000000350000720cULL, 0x000fe40003fa6070ULL,
0x00000039222a7210ULL, 0x000fe40007f5e0ffULL, 0x0000000765287812ULL, 0x000fe400078ef828ULL,
0x0000003023397210ULL, 0x000fe20007fde0ffULL, 0x000000ffff2b7224ULL, 0x000fe200010e0632ULL,
0x0000003122307210ULL, 0x000fe20007f5e0ffULL, 0x00000010283f7824ULL, 0x000fe200078e0263ULL,
0x0000000340427819ULL, 0x000fe200000006ffULL, 0x000000ffff327224ULL, 0x000fc400030e06ffULL,
0x000000ffff317224ULL, 0x000fe200010e0637ULL, 0x000000354000720cULL, 0x080fe20003f46070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002a3f7faeULL, 0x0003e2000e901c46ULL,
0x0000000439377c11ULL, 0x040fe4000f8c40ffULL, 0xfffffff842407812ULL, 0x000fe200078ee221ULL,
0x0000001800427836ULL, 0x000fe20000000000ULL, 0x0000003d22207210ULL, 0x000fe20007fbe0ffULL,
0x0000000030417faeULL, 0x0005e2000e101c46ULL, 0x0000000539397c11ULL, 0x000fe2000b0f4432ULL,
0x0000000142327824ULL, 0x040fe200078e0233ULL, 0x00000009423d7210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff217224ULL, 0x000fe200028e063aULL, 0x0000002922287210ULL, 0x000fe20007fbe0ffULL,
0x00000008423a7824ULL, 0x040fe200078e00ffULL, 0x000000354200720cULL, 0x080fe20003f86070ULL,
0x00000001442b7824ULL, 0x042fe200078e0209ULL, 0x0000003223327210ULL, 0x000fe20007fde0ffULL,
0x0000000844427824ULL, 0x040fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee23dULL,
0x000000ffff297224ULL, 0x000fe200028e0638ULL, 0x0000003b222a7210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff3d7224ULL, 0x000fe200030e06ffULL, 0xfffffff842387812ULL, 0x000fe200078ee22bULL,
0x0000000144307824ULL, 0x004fe200078e0233ULL, 0x0000000432437c11ULL, 0x000fe2000f8c40ffULL,
0x000000ffff2b7224ULL, 0x000fe200028e0634ULL, 0x000000354400720cULL, 0x000fe20003fa6070ULL,
0x0000002400447836ULL, 0x000fe20000000000ULL, 0x00000005323d7c11ULL, 0x000fc4000b0f443dULL,
0x0000003023307210ULL, 0x000fe20007fde0ffULL, 0x0000000144347824ULL, 0x140fe200078e0209ULL,
0x0000002000427810ULL, 0x000fe20007ffe0ffULL, 0x0000000844417824ULL, 0x000fe400078e00ffULL,
0x000000ffff317224ULL, 0x000fe200030e06ffULL, 0x00000004303b7c11ULL, 0x000fe2000f8c40ffULL,
0x0000000142327824ULL, 0x040fe200078e0209ULL, 0xfffffff841347812ULL, 0x000fe200078ee234ULL,
0x00000008423f7824ULL, 0x000fe200078e00ffULL, 0x000000633e417211ULL, 0x000fe200078e20ffULL,
0x00000001443c7824ULL, 0x000fe200078e0233ULL, 0x00000005303e7c11ULL, 0x000fe2000b0f4431ULL,
0x0000000142307824ULL, 0x000fe200078e0233ULL, 0xfffffff83f327812ULL, 0x000fe200078ee232ULL,
0x0000000020417faeULL, 0x0003e2000c101c46ULL, 0x000000354400720cULL, 0x080fe20003f06070ULL,
0x0000003800447836ULL, 0x000fe20000000000ULL, 0x00000030233f7210ULL, 0x000fe20007fde0ffULL,
0x0000000028457faeULL, 0x0005e2000c901c46ULL, 0x000000354200720cULL, 0x000fe20003f26070ULL,
0x0000002800427836ULL, 0x000fc40000000000ULL, 0x000000002a477faeULL, 0x0007e2000d901c46ULL,
0x0000003722307210ULL, 0x000fe20007f7e0ffULL, 0x0000000142367824ULL, 0x040fe400078e0209ULL,
0x0000000842217824ULL, 0x042fe200078e00ffULL, 0x000000ffff207210ULL, 0x000fe200037fe4ffULL,
0x000000ffff317224ULL, 0x000fe200018e0639ULL, 0x0000003c233c7210ULL, 0x000fe20007fde0ffULL,
0x0000000142287824ULL, 0x004fe200078e0233ULL, 0xfffffff821367812ULL, 0x000fe200078ee236ULL,
0x0000001040377824ULL, 0x000fe200078e0263ULL, 0x000000043f2b7c11ULL, 0x008fe2000f8640ffULL,
0x000000ffff217224ULL, 0x000fe200030e06ffULL, 0x000000043c417c11ULL, 0x000fc4000f8c40ffULL,
0x0000000030377faeULL, 0x0003e2000d101c46ULL, 0x000000053f3f7c11ULL, 0x000fe400098f4420ULL,
0x0000004322207210ULL, 0x000fe40007f7e0ffULL, 0x000000053c407c11ULL, 0x000fe2000b0f4421ULL,
0x0000002c003c7836ULL, 0x000fe20000000000ULL, 0x0000002823397210ULL, 0x000fe20007fde0ffULL,
0x000000ffff217224ULL, 0x000fe200018e063dULL, 0x0000003b22287210ULL, 0x000fe20007f7e0ffULL,
0x000000013c2a7824ULL, 0x000fe200078e0233ULL, 0x000000633a3d7211ULL, 0x000fe200078e20ffULL,
0x000000ffff307224ULL, 0x002fe200030e06ffULL, 0x00000004393b7c11ULL, 0x040fe2000f8c40ffULL,
0x000000ffff297224ULL, 0x000fe200018e063eULL, 0x000000093c317210ULL, 0x000fe20007ffe0ffULL,
0x00000030003e7836ULL, 0x000fe20000000000ULL, 0x000000353c00720cULL, 0x0c0fe20003f66070ULL,
0x000000083c3c7824ULL, 0x000fe200078e00ffULL, 0x0000000539397c11ULL, 0x000fe2000b0f4430ULL,
0x000000013e307824ULL, 0x040fe200078e0209ULL, 0x0000002a232a7210ULL, 0x000fe20007fde0ffULL,
0x000000083e437824ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee231ULL,
0x00000000203d7faeULL, 0x0003e2000e101c46ULL, 0x000000354200720cULL, 0x080fe20003f46070ULL,
0x000000ffff377224ULL, 0x000fe200030e06ffULL, 0x000000042a317c11ULL, 0x000fe2000f8c40ffULL,
0x0000003400427836ULL, 0x000fe20000000000ULL, 0xfffffff843307812ULL, 0x000fe200078ee230ULL,
0x0000001038437824ULL, 0x000fe200078e0263ULL, 0x000000052a377c11ULL, 0x000fe2000b0f4437ULL,
0x000000013e2a7824ULL, 0x000fe200078e0233ULL, 0x0000000344477819ULL, 0x000fe200000006ffULL,
0x0000000842457824ULL, 0x000fe200078e00ffULL, 0x0000000028437faeULL, 0x0005e2000e901c46ULL,
0x000000353e00720cULL, 0x000fe20003fa6070ULL, 0x00000001423e7824ULL, 0x100fe200078e0209ULL,
0x0000002a23387210ULL, 0x000fe20007fde0ffULL, 0x00000001443a7824ULL, 0x000fe200078e0209ULL,
0x0000002b222a7210ULL, 0x000fc40007f9e0ffULL, 0xfffffff8453e7812ULL, 0x000fe200078ee23eULL,
0x000000ffff217224ULL, 0x002fe200030e06ffULL, 0x00000004383d7c11ULL, 0x000fe2000f8c40ffULL,
0x000000ffff2b7224ULL, 0x000fe200020e063fULL, 0x0000004122207210ULL, 0x000fe20007f9e0ffULL,
0x0000001032417824ULL, 0x000fe200078e0263ULL, 0x0000000538387c11ULL, 0x000fe2000b0f4421ULL,
0x0000000142287824ULL, 0x004fe200078e0233ULL, 0xfffffff8473a7812ULL, 0x000fe200078ee23aULL,
0x000000ffff217224ULL, 0x000fe200020e0640ULL, 0x000000002a417faeULL, 0x0003e2000c901c46ULL,
0x0000001034437824ULL, 0x000fe200078e0263ULL, 0x0000002823347210ULL, 0x000fe20007f3e0ffULL,
0x0000003c00407836ULL, 0x000fe20000000000ULL, 0x000000354200720cULL, 0x000fc40003f86070ULL,
0x0000000020437faeULL, 0x0005e2000c101c46ULL, 0x0000003b22287210ULL, 0x000fe20007f1e0ffULL,
0x0000000140327824ULL, 0x000fe200078e0233ULL, 0x000000ffff3f7210ULL, 0x000fe40000ffe4ffULL,
0x00000004343b7c11ULL, 0x000fe2000f8c40ffULL, 0x000000ffff297224ULL, 0x000fe200000e0639ULL,
0x000000354400720cULL, 0x080fe20003f26070ULL, 0x0000001036397824ULL, 0x000fe200078e0263ULL,
0x000000354000720cULL, 0x000fe20003f06070ULL, 0x00000001442a7824ULL, 0x002fe200078e0233ULL,
0x0000000534347c11ULL, 0x000fe2000b0f443fULL, 0x000000103c357824ULL, 0x000fe200078e0263ULL,
0x0000000028397faeULL, 0x0003e2000d101c46ULL, 0x0000003122207210ULL, 0x004fe20007f5e0ffULL,
0x00000001402b7824ULL, 0x040fe200078e0209ULL, 0x0000002a232a7210ULL, 0x000fe20007fde0ffULL,
0x0000000840367824ULL, 0x000fe200078e00ffULL, 0x00000037ff217210ULL, 0x000fe200017fe4ffULL,
0x0000001030377824ULL, 0x100fe200078e0263ULL, 0x0000003223327210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff337224ULL, 0x000fe200030e06ffULL, 0xfffffff836367812ULL, 0x000fe200078ee22bULL,
0x0000000020357faeULL, 0x0005e2000d901c46ULL, 0x000000042a317c11ULL, 0x000fe2000f8c40ffULL,
0x000000ffff2b7224ULL, 0x000fe200010e06ffULL, 0x0000003d22287210ULL, 0x002fe20007f7e0ffULL,
0x000000103e397824ULL, 0x100fe200078e0263ULL, 0x0000000432237c11ULL, 0x000fe2000f8440ffULL,
0x000000103a3d7824ULL, 0x000fe200078e0263ULL, 0x000000052a337c11ULL, 0x000fe2000b0f4433ULL,
0x000000ffff297224ULL, 0x000fe200018e0638ULL, 0x0000003b222a7210ULL, 0x000fe20007fde0ffULL,
0x0000001036637824ULL, 0x000fe200078e0263ULL, 0x0000003122307210ULL, 0x000fc40007f7e0ffULL,
0x0000000532207c11ULL, 0x004fe200090f442bULL, 0x0000000028377faeULL, 0x0003e2000e901c46ULL,
0x0000002322227210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff317224ULL, 0x000fe200018e0633ULL,
0x00000034ff2b7210ULL, 0x000fc600037fe4ffULL, 0x000000ffff237224ULL, 0x000fe400010e0620ULL,
0x000000002a397faeULL, 0x0003e8000e101c46ULL, 0x00000000303d7faeULL, 0x0003e8000c901c46ULL,
0x0000000022637faeULL, 0x0003e2000c101c46ULL, 0x0000000c004c7947ULL, 0x000fea0003800000ULL,
0x0000000400307836ULL, 0x000fe20000000000ULL, 0x0000000c00347810ULL, 0x000fe20007ffe0ffULL,
0x0000000800367836ULL, 0x000fe20000000000ULL, 0x0000001400327810ULL, 0x000fe20007ffe0ffULL,
0x0000000130777824ULL, 0x140fe400078e0209ULL, 0x0000000830207824ULL, 0x000fe400078e00ffULL,
0x0000000136297824ULL, 0x040fe400078e0209ULL, 0x0000000836227824ULL, 0x000fe200078e00ffULL,
0xfffffff820777812ULL, 0x000fe200078ee277ULL, 0x0000001000207836ULL, 0x000fc40000000000ULL,
0x00000001342b7824ULL, 0x140fe200078e0209ULL, 0xfffffff822297812ULL, 0x000fe200078ee229ULL,
0x0000000834287824ULL, 0x000fe400078e00ffULL, 0x0000000120317824ULL, 0x140fe400078e0209ULL,
0x0000000820387824ULL, 0x000fe200078e00ffULL, 0xfffffff8282b7812ULL, 0x000fe200078ee22bULL,
0x0000001800217836ULL, 0x000fe40000000000ULL, 0x0000000132397824ULL, 0x040fe200078e0209ULL,
0xfffffff838317812ULL, 0x000fe200078ee231ULL, 0x0000000832227824ULL, 0x000fe200078e00ffULL,
0x000000632b2b7211ULL, 0x000fe200078e20ffULL, 0x0000001c00287836ULL, 0x000fc40000000000ULL,
0x0000000121457824ULL, 0x140fe200078e0209ULL, 0xfffffff822397812ULL, 0x000fe200078ee239ULL,
0x0000000821387824ULL, 0x000fe200078e00ffULL, 0x00000003283a7819ULL, 0x040fe200000006ffULL,
0x0000002000227836ULL, 0x000fe40000000000ULL, 0x0000000128477824ULL, 0x100fe200078e0209ULL,
0xfffffff838457812ULL, 0x000fe200078ee245ULL, 0x0000003400467836ULL, 0x000fe40000000000ULL,
0x0000002400487836ULL, 0x000fe20000000000ULL, 0xfffffff83a477812ULL, 0x000fe200078ee247ULL,
0x0000000122497824ULL, 0x000fc400078e0209ULL, 0x0000000822387824ULL, 0x000fe400078e00ffULL,
0x00000028004a7836ULL, 0x000fe40000000000ULL, 0x00000001463a7824ULL, 0x140fe200078e0209ULL,
0xfffffff838497812ULL, 0x000fe200078ee249ULL, 0x00000008463b7824ULL, 0x000fe200078e00ffULL,
0x000000094a427210ULL, 0x000fe20007ffe0ffULL, 0x0000000148567824ULL, 0x040fe400078e0209ULL,
0x0000000848357824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3a7812ULL, 0x000fe200078ee23aULL,
0x0000000130307824ULL, 0x000fc400078e0233ULL, 0x000000084a377824ULL, 0x000fe200078e00ffULL,
0xfffffff835567812ULL, 0x000fe200078ee256ULL, 0x0000002c00447836ULL, 0x000fe20000000000ULL,
0x00000030233b7210ULL, 0x000fe20007f3e0ffULL, 0x0000000100387824ULL, 0x100fe200078e0233ULL,
0xfffffff837427812ULL, 0x000fe200078ee242ULL, 0x00000030003e7836ULL, 0x000fe40000000000ULL,
0x0000000136367824ULL, 0x000fe200078e0233ULL, 0x0000003823387210ULL, 0x000fe20007f1e0ffULL,
0x0000000144407824ULL, 0x100fe200078e0209ULL, 0x000000033e377819ULL, 0x000fe200000006ffULL,
0x0000000844357824ULL, 0x000fe200078e00ffULL, 0x00000036233d7210ULL, 0x000fe20007f5e0ffULL,
0x000000013e3c7824ULL, 0x000fc400078e0209ULL, 0x000000ffff367224ULL, 0x000fe200008e06ffULL,
0xfffffff835407812ULL, 0x000fe200078ee240ULL, 0x000000ffff357224ULL, 0x000fe200000e06ffULL,
0x000000043b4b7c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff3f7224ULL, 0x000fe200010e06ffULL,
0xfffffff8373c7812ULL, 0x000fe200078ee23cULL, 0x0000003800547836ULL, 0x000fe20000000000ULL,
0x0000000438377c11ULL, 0x000fe2000f8040ffULL, 0x0000000120207824ULL, 0x000fe200078e0233ULL,
0x000000043d757c11ULL, 0x000fe2000f8440ffULL, 0x0000000154417824ULL, 0x000fe200078e0209ULL,
0x000000053b3b7c11ULL, 0x000fe200088f4436ULL, 0x0000000134367824ULL, 0x000fe200078e0233ULL,
0x0000000538357c11ULL, 0x000fe200080f4435ULL, 0x0000001009347824ULL, 0x000fe200078e00ffULL,
0x000000053d387c11ULL, 0x000fe200090f443fULL, 0x00000001323d7824ULL, 0x000fe200078e0233ULL,
0x0000000354437819ULL, 0x000fe200000006ffULL, 0x00000001002a7824ULL, 0x000fe200078e0209ULL,
0x0000003623367210ULL, 0x000fe20007f1e0ffULL, 0x0000000128287824ULL, 0x100fe200078e0233ULL,
0xfffffff843307812ULL, 0x000fe200078ee241ULL, 0x0000000148487824ULL, 0x100fe200078e0233ULL,
0x0000003d23417210ULL, 0x000fe20007f5e0ffULL, 0x000000014a4a7824ULL, 0x100fe200078e0233ULL,
0x000000ffff3d7210ULL, 0x000fe200007fe4ffULL, 0x0000000144447824ULL, 0x100fe200078e0233ULL,
0x0000007034327812ULL, 0x000fe200078ec0ffULL, 0x000000ffff557224ULL, 0x000fe200010e06ffULL,
0x0000000436737c11ULL, 0x000fe2000f8040ffULL, 0x000000013e3e7824ULL, 0x100fe200078e0233ULL,
0x0000002023347210ULL, 0x000fe20007f3e0ffULL, 0x0000000154547824ULL, 0x000fe200078e0233ULL,
0x0000000536367c11ULL, 0x000fe200080f443dULL, 0x00000001213d7824ULL, 0x000fe200078e0233ULL,
0x0000003732207210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200008e06ffULL,
0x00000007652a7812ULL, 0x000fe200078ef82aULL, 0x00000010306b7824ULL, 0x000fe200078e0263ULL,
0x0000000434717c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff217224ULL, 0x000fe200000e0635ULL,
0x0000000441437c11ULL, 0x000fe2000f8440ffULL, 0x000000102a357824ULL, 0x000fe200078e0263ULL,
0x0000000534347c11ULL, 0x000fe200088f443fULL, 0x00000001222a7824ULL, 0x000fe200078e0233ULL,
0x0000002823287210ULL, 0x000fe20007f3e0ffULL, 0x0000001077777824ULL, 0x000fe200078e0263ULL,
0x0000003d23227210ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020357faeULL, 0x0003e2000b901c46ULL, 0x0000000541377c11ULL, 0x000fe200090f4455ULL,
0x000000ffff577224ULL, 0x000fe200008e06ffULL, 0x0000002a232a7210ULL, 0x000fe20007f5e0ffULL,
0x0000001029297824ULL, 0x100fe200078e0263ULL, 0x000000ffff557210ULL, 0x000fe200007fe4ffULL,
0x0000001031317824ULL, 0x100fe200078e0263ULL, 0x0000000422417c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff657224ULL, 0x000fe200010e06ffULL, 0x00000004283f7c11ULL, 0x000fe2000f8240ffULL,
0x0000001045457824ULL, 0x000fe200078e0263ULL, 0x0000000522227c11ULL, 0x000fe200080f4455ULL,
0x0000003c00207836ULL, 0x002fe20000000000ULL, 0x0000000528287c11ULL, 0x000fe200088f4457ULL,
0x0000001047477824ULL, 0x000fe200078e0263ULL, 0x0000003346217210ULL, 0x000fe20007ffe0ffULL,
0x0000000120337824ULL, 0x000fe200078e0233ULL, 0x000000042a3d7c11ULL, 0x000fe2000f8440ffULL,
0x0000000120557824ULL, 0x040fe200078e0209ULL, 0x0000004823357210ULL, 0x000fe20007fbe0ffULL,
0x0000000820577824ULL, 0x000fe200078e00ffULL, 0x0000004b32207210ULL, 0x000fe20007f1e0ffULL,
0x0000001049497824ULL, 0x000fe200078e0263ULL, 0x000000052a2a7c11ULL, 0x000fe200090f4465ULL,
0x000000103c657824ULL, 0x000fe200078e0263ULL, 0x0000004a23487210ULL, 0x000fe20007fde0ffULL,
0x000000ffff3c7224ULL, 0x000fe200028e06ffULL, 0x00000021234a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff217224ULL, 0x000fe200000e063bULL, 0x0000004423467210ULL, 0x000fe20007f9e0ffULL,
0x00000010564b7824ULL, 0x100fe200078e0263ULL, 0x00000004353b7c11ULL, 0x000fe2000f8a40ffULL,
0x000000103a697824ULL, 0x100fe200078e0263ULL, 0x0000003e23447210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff797224ULL, 0x000fe200020e06ffULL, 0x0000005423547210ULL, 0x000fe20007f3e0ffULL,
0x0000000020777faeULL, 0x0003e2000b901c46ULL, 0x0000003323237210ULL, 0x000fe20007f1e0ffULL,
0x0000001039337824ULL, 0x000fe200078e0263ULL, 0x0000000535307c11ULL, 0x000fe2000a8f443cULL,
0x000000ffff357224ULL, 0x000fe200030e06ffULL, 0x0000000446397c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff567224ULL, 0x000fe200000e06ffULL, 0x00000004486f7c11ULL, 0x000fc4000f8a40ffULL,
0x000000ffff7b7210ULL, 0x000fe40001ffe4ffULL, 0x00000004446d7c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff777224ULL, 0x002fe200008e06ffULL, 0x0000000546467c11ULL, 0x000fe2000a0f4479ULL,
0x000000ffff797224ULL, 0x000fe200010e06ffULL, 0xfffffff8573e7812ULL, 0x000fe200078ee255ULL,
0x0000001042557824ULL, 0x000fe200078e0263ULL, 0x0000000548487c11ULL, 0x000fe4000a8f4435ULL,
0x000000044a357c11ULL, 0x000fc4000f8440ffULL, 0x0000006340577211ULL, 0x000fe200078e20ffULL,
0x000000103e637824ULL, 0x000fe200078e0263ULL, 0x0000000544447c11ULL, 0x000fe400098f447bULL,
0x0000000454217c11ULL, 0x000fe4000f8240ffULL, 0x0000007532427210ULL, 0x000fe40007f7e0ffULL,
0x0000007332407210ULL, 0x000fe40007fde0ffULL, 0x000000054a4a7c11ULL, 0x000fc400090f4479ULL,
0x00000071323e7210ULL, 0x000fe40007f5e0ffULL, 0x0000000554547c11ULL, 0x000fe400088f4477ULL,
0x00000043323c7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff437224ULL, 0x000fe200018e0638ULL,
0x00000041323a7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff417224ULL, 0x000fe200030e0636ULL,
0x0000003f32387210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff3f7224ULL, 0x000fe200010e0634ULL,
0x0000003d32367210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200008e0637ULL,
0x0000003b32347210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200028e0622ULL,
0x0000003932227210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff377224ULL, 0x000fe200018e062aULL,
0x00000028ff397210ULL, 0x000fe200027fe4ffULL, 0x0000000042297faeULL, 0x0003e2000b901c46ULL,
0x00000035322a7210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff357224ULL, 0x000fe200010e0630ULL,
0x0000006f32207210ULL, 0x000fe20007f3e0ffULL, 0x00000000402b7faeULL, 0x0005e2000b901c46ULL,
0x0000006d32287210ULL, 0x000fc40007f9e0ffULL, 0x00000004236d7c11ULL, 0x040fe2000f8440ffULL,
0x000000003e317faeULL, 0x0007e2000b901c46ULL, 0x0000002132307210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff217224ULL, 0x000fe200008e0648ULL, 0x0000006d32327210ULL, 0x000fe20007fde0ffULL,
0x000000003c337faeULL, 0x0009e2000b901c46ULL, 0x0000000523567c11ULL, 0x000fe200090f4456ULL,
0x000000ffff237224ULL, 0x000fe400028e0646ULL, 0x000000003a457faeULL, 0x000be2000b901c46ULL,
0x000000ffff297224ULL, 0x002fc400020e0644ULL, 0x000000ffff2b7224ULL, 0x004fe200018e064aULL,
0x0000000038477faeULL, 0x0003e2000b901c46ULL, 0x00000054ff317210ULL, 0x008fc600007fe4ffULL,
0x0000000036497faeULL, 0x0003e2000b901c46ULL, 0x000000ffff337224ULL, 0x010fc600030e0656ULL,
0x00000000344b7faeULL, 0x0003e8000b901c46ULL, 0x0000000020557faeULL, 0x0003e8000b901c46ULL,
0x0000000022577faeULL, 0x0003e8000b901c46ULL, 0x0000000028657faeULL, 0x0003e8000b901c46ULL,
0x000000002a697faeULL, 0x0003e8000b901c46ULL, 0x00000000306b7faeULL, 0x0003e8000b901c46ULL,
0x0000000032637faeULL, 0x0203e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000085f207836ULL, 0x002fe20000000000ULL, 0x0000005d78307211ULL, 0x080fe200078e20ffULL,
0x000000105e217824ULL, 0x000fe200078e00ffULL, 0x0000005d66547211ULL, 0x000fe200078e20ffULL,
0x00000010673c7824ULL, 0x100fe400078e025dULL, 0x000000107c407824ULL, 0x000fe200078e025dULL,
0xfffffff021207812ULL, 0x000fe200078ee220ULL, 0x0000000a5f287836ULL, 0x000fe40000000000ULL,
0x000000105e297824ULL, 0x000fc400078e00ffULL, 0x0000001020387824ULL, 0x000fe400078e020bULL,
0x000000107a207824ULL, 0x100fe200078e025dULL, 0xfffffff029287812ULL, 0x000fe200078ee228ULL,
0x0000001076347824ULL, 0x100fe400078e025dULL, 0x0000001068687824ULL, 0x000fe400078e025dULL,
0x0000001028287824ULL, 0x000fe400078e020bULL, 0x0000001074747824ULL, 0x000fe200078e025dULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000003c3c783bULL, 0x000fe20000000200ULL,
0x000000105e447824ULL, 0x000fe400078e00ffULL, 0x000000106c487824ULL, 0x100fe200078e025dULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000003030783bULL, 0x000ea80000000200ULL,
0x000000004040783bULL, 0x000ee80000000200ULL, 0x000000002020783bULL, 0x000f280000000200ULL,
0x000000003434783bULL, 0x000fe80000000200ULL, 0x000000002828783bULL, 0x000f680000000200ULL,
0x000000005454783bULL, 0x000fe80000000200ULL, 0x000000004848783bULL, 0x000fe20000000200ULL,
0x0000003c3824723cULL, 0x002fec0000001824ULL, 0x0000003e3850723cULL, 0x000fe20000001850ULL,
0x00000010723c7824ULL, 0x000fca00078e025dULL, 0x00000030381c723cULL, 0x004fe2000000181cULL,
0x000000003c3c783bULL, 0x000e6a0000000200ULL, 0x00000040384c723cULL, 0x008fe2000000184cULL,
0x0000000c5f317836ULL, 0x000fe40000000000ULL, 0x0000001070307824ULL, 0x000fe400078e025dULL,
0x0000000e5f5f7836ULL, 0x000fe20000000000ULL, 0x000000203814723cULL, 0x010fe20000001814ULL,
0x000000045e407819ULL, 0x000fc600000006ffULL, 0xfffffff044447812ULL, 0x000fe400078ee25fULL,
0xfffffff040407812ULL, 0x000fe200078ee231ULL, 0x000000423810723cULL, 0x000fe40000001810ULL,
0x0000001044447824ULL, 0x100fe400078e020bULL, 0x0000001040407824ULL, 0x000fe400078e020bULL,
0x000000223820723cULL, 0x000fe20000001818ULL, 0x000000006818783bULL, 0x000eaa0000000200ULL,
0x00000032382c723cULL, 0x000fe2000000182cULL, 0x000000004040783bULL, 0x000fe80000000200ULL,
0x000000003030783bULL, 0x000ee20000000200ULL, 0x000000342838723cULL, 0x020fe60000001824ULL,
0x000000007424783bULL, 0x000f260000000200ULL, 0x0000003c284c723cULL, 0x002fe2000000184cULL,
0x000000106e347824ULL, 0x100fe200078e025dULL, 0x000000004444783bULL, 0x000fe80000000200ULL,
0x000000362850723cULL, 0x000fe20000001850ULL, 0x000000106a3c7824ULL, 0x100fe200078e025dULL,
0x000000003434783bULL, 0x000e680000000200ULL, 0x0000003e2810723cULL, 0x000fe20000001810ULL,
0x000000003c3c783bULL, 0x000f6a0000000200ULL, 0x000000182814723cULL, 0x004fec0000001814ULL,
0x0000001a2820723cULL, 0x000fe20000001820ULL, 0x0000001064187824ULL, 0x000fca00078e025dULL,
0x00000030281c723cULL, 0x008fe2000000181cULL, 0x000000001818783bULL, 0x000eaa0000000200ULL,
0x00000032282c723cULL, 0x000fec000000182cULL, 0x000000244038723cULL, 0x010fe20000001838ULL,
0x0000001062287824ULL, 0x000fca00078e025dULL, 0x000000264050723cULL, 0x000fe20000001850ULL,
0x0000001060247824ULL, 0x000fe200078e025dULL, 0x000000002828783bULL, 0x000ee80000000200ULL,
0x00000034404c723cULL, 0x002fe2000000184cULL, 0x000000002424783bULL, 0x000e6a0000000200ULL,
0x0000003c4014723cULL, 0x020fec0000001814ULL, 0x0000003e4020723cULL, 0x000fec0000001820ULL,
0x000000364010723cULL, 0x000fec0000001810ULL, 0x00000054401c723cULL, 0x000fec000000181cULL,
0x00000056402c723cULL, 0x000fec000000182cULL, 0x00000018444c723cULL, 0x004fec000000184cULL,
0x000000284414723cULL, 0x008fe20000001814ULL, 0x00000001ff187424ULL, 0x000fca00078e00ffULL,
0x0000002a4420723cULL, 0x000fe20000001820ULL, 0x01b68818071879a7ULL, 0x000eaa000850003fULL,
0x000000484438723cULL, 0x000fec0000001838ULL, 0x0000004a4450723cULL, 0x000fe20000001850ULL,
0x3db504f34c4c7820ULL, 0x000fe20000410000ULL, 0x3db504f34d4d7820ULL, 0x000fe20000410000ULL,
0x3db504f34e4e7820ULL, 0x000fe20000410000ULL, 0x3db504f34f4f7820ULL, 0x000fc40000410000ULL,
0x0000001a4410723cULL, 0x000fe20000001810ULL, 0x3db504f314147820ULL, 0x000fe20000410000ULL,
0x3db504f315157820ULL, 0x000fc80000410000ULL, 0x00000024441c723cULL, 0x002fe2000000181cULL,
0x3db504f3161a7820ULL, 0x000fe20000410000ULL, 0x3db504f320167820ULL, 0x000fe20000410000ULL,
0x3db504f322227820ULL, 0x000fe20000410000ULL, 0x3db504f323237820ULL, 0x000fe40000410000ULL,
0x00000026442c723cULL, 0x000fe2000000182cULL, 0x3db504f317257820ULL, 0x000fe20000410000ULL,
0x3db504f321177820ULL, 0x000fe20000410000ULL, 0x3db504f3381b7820ULL, 0x000fe20000410000ULL,
0x3db504f339397820ULL, 0x000fe20000410000ULL, 0x3db504f33a3a7820ULL, 0x000fe20000410000ULL,
0x3db504f33b3b7820ULL, 0x000fe20000410000ULL, 0x3db504f350507820ULL, 0x000fe20000410000ULL,
0x3db504f351517820ULL, 0x000fe20000410000ULL, 0x3db504f352527820ULL, 0x000fe20000410000ULL,
0x3db504f353537820ULL, 0x000fc40000410000ULL, 0x3db504f310287820ULL, 0x000fe20000410000ULL,
0x3db504f311297820ULL, 0x000fe20000410000ULL, 0x3db504f312277820ULL, 0x000fe20000410000ULL,
0x3db504f313267820ULL, 0x000fc60000410000ULL, 0x3db504f31c1c7820ULL, 0x000fe20000410000ULL,
0x3db504f31d1d7820ULL, 0x000fe20000410000ULL, 0x3db504f31e217820ULL, 0x000fe20000410000ULL,
0x3db504f31f207820ULL, 0x000fc60000410000ULL, 0x3db504f32c2c7820ULL, 0x000fe20000410000ULL,
0x3db504f32d2d7820ULL, 0x000fe20000410000ULL, 0x3db504f32e2e7820ULL, 0x000fe20000410000ULL,
0x3db504f32f2f7820ULL, 0x000fe20000410000ULL, 0x0000000000107805ULL, 0x000fe20000015200ULL,
0x01b68819070075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff1e7224ULL, 0x000fce00078e00ffULL, 0x000000101e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x00000012101f7210ULL, 0x000fc80007f1e1ffULL, 0x0000001311137210ULL, 0x000fe400007fe5ffULL,
0x003d09001f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001f12127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011e1e7836ULL, 0x000fce0000000000ULL, 0x01b68819070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000409107824ULL, 0x000fe200078e00ffULL,
0x000000055b00720cULL, 0x000fe20003f05270ULL, 0x000000805c117824ULL, 0x000fc600078e020bULL,
0xfffffff010107812ULL, 0x000fca00078ec0ffULL, 0x0000000111247824ULL, 0x000fca00078e0210ULL,
0x01b4000024107984ULL, 0x0002a20000000c00ULL, 0x0000000400080947ULL, 0x000fea0003800000ULL,
0x0000000209187824ULL, 0x000fe400078e00ffULL, 0x000000015a2a7824ULL, 0x000fc600078e0a03ULL,
0x0000000618187812ULL, 0x000fc800078ec0ffULL, 0x0000000118037812ULL, 0x040fe400078efcffULL,
0x0000000818197812ULL, 0x040fe400078efcffULL, 0x0000002a0300720cULL, 0x080fe40003f26070ULL,
0x0000001018037812ULL, 0x000fe400078efcffULL, 0x0000002a1900720cULL, 0x080fe40003f06070ULL,
0x0000002a0300720cULL, 0x000fc40003fc6070ULL, 0x0000001118197812ULL, 0x040fe400078efcffULL,
0x0000001818037812ULL, 0x040fe400078efcffULL, 0x0000002a1800720cULL, 0x0c0fe40003f46070ULL,
0x0000002a1900720cULL, 0x080fe40003fa6070ULL, 0x0000002a0300720cULL, 0x000fe40003f66070ULL,
0x00000009181e7812ULL, 0x000fc400078efcffULL, 0x0000001918197812ULL, 0x040fe400078efcffULL,
0x0000002018037812ULL, 0x000fe400078efcffULL, 0xff8000003a3a7808ULL, 0x000fe40005000000ULL,
0xff8000001b1b7808ULL, 0x000fe40005000000ULL, 0xff8000003b3b7808ULL, 0x000fe40004800000ULL,
0xff80000039397808ULL, 0x000fc40004800000ULL, 0x0000002a1e00720cULL, 0x080fe40003f86070ULL,
0x0000002a1900720cULL, 0x080fe40003f46070ULL, 0x0000002a0300720cULL, 0x000fe40003f26070ULL,
0x0000002118197812ULL, 0x040fe400078efcffULL, 0x0000002818037812ULL, 0x000fe400078efcffULL,
0xff80000052527808ULL, 0x000fc40004000000ULL, 0xff80000050507808ULL, 0x000fe40004000000ULL,
0xff80000053537808ULL, 0x000fe40006000000ULL, 0xff80000051517808ULL, 0x000fe40006000000ULL,
0x0000002a1900720cULL, 0x080fe40003f06070ULL, 0x0000002a0300720cULL, 0x000fe40003f86070ULL,
0x0000002918197812ULL, 0x000fc400078efcffULL, 0x0000003018037812ULL, 0x000fe400078efcffULL,
0xff8000004e4e7808ULL, 0x000fe40007000000ULL, 0xff8000004c4c7808ULL, 0x000fe40007000000ULL,
0xff8000004f4f7808ULL, 0x000fe40006800000ULL, 0xff8000004d4d7808ULL, 0x000fe40006800000ULL,
0x0000002a1900720cULL, 0x000fc40003fc6070ULL, 0x0000002a0300720cULL, 0x000fe40003fa6070ULL,
0x0000003118197812ULL, 0x040fe400078efcffULL, 0x0000003818037812ULL, 0x040fe400078efcffULL,
0x0000003918187812ULL, 0x000fe400078efcffULL, 0xff80000027277808ULL, 0x000fe40005800000ULL,
0xff80000028287808ULL, 0x000fc40005800000ULL, 0xff80000026267808ULL, 0x000fe40005000000ULL,
0xff80000029297808ULL, 0x000fe40005000000ULL, 0xff8000001a1a7808ULL, 0x000fe40004800000ULL,
0xff80000014147808ULL, 0x000fe40004800000ULL, 0x0000002a1900720cULL, 0x080fe40003f66070ULL,
0x0000002a0300720cULL, 0x000fc40003f46070ULL, 0x0000002a1800720cULL, 0x000fe40003f26070ULL,
0xff80000025257808ULL, 0x000fe40004000000ULL, 0xff80000015157808ULL, 0x000fe40004000000ULL,
0xff80000022227808ULL, 0x000fe40006000000ULL, 0xff80000016167808ULL, 0x000fe40006000000ULL,
0xff80000023237808ULL, 0x000fc40007000000ULL, 0xff80000017177808ULL, 0x000fe40007000000ULL,
0xff80000021217808ULL, 0x000fe40006800000ULL, 0xff8000001c1c7808ULL, 0x000fe40006800000ULL,
0xff80000020207808ULL, 0x000fe40005800000ULL, 0xff8000001d1d7808ULL, 0x000fe40005800000ULL,
0xff8000002e2e7808ULL, 0x000fc40005000000ULL, 0xff8000002c2c7808ULL, 0x000fe40005000000ULL,
0xff8000002f2f7808ULL, 0x000fe40004800000ULL, 0xff8000002d2d7808ULL, 0x000fce0004800000ULL,
0x0000001b1000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff5b7224ULL, 0x000fe200078e0061ULL,
0xfffffff8ff027812ULL, 0x000fe400078ee202ULL, 0x000000101b107208ULL, 0x000fc80004000000ULL,
0x000000391000720bULL, 0x000fc80003f1e000ULL, 0x0000001039037208ULL, 0x000fc80004000000ULL,
0x000000500300720bULL, 0x000fc80003f1e000ULL, 0x0000000350107208ULL, 0x000fc80004000000ULL,
0x000000511000720bULL, 0x000fc80003f1e000ULL, 0x0000001051037208ULL, 0x000fc80004000000ULL,
0x0000004c0300720bULL, 0x000fc80003f1e000ULL, 0x000000034c107208ULL, 0x000fc80004000000ULL,
0x0000004d1000720bULL, 0x000fc80003f1e000ULL, 0x000000104d037208ULL, 0x000fc80004000000ULL,
0x000000280300720bULL, 0x000fc80003f1e000ULL, 0x0000000328107208ULL, 0x000fc80004000000ULL,
0x000000291000720bULL, 0x000fc80003f1e000ULL, 0x0000001029037208ULL, 0x000fc80004000000ULL,
0x000000140300720bULL, 0x000fc80003f1e000ULL, 0x0000000314107208ULL, 0x000fc80004000000ULL,
0x000000151000720bULL, 0x000fc80003f1e000ULL, 0x0000001015037208ULL, 0x000fc80004000000ULL,
0x000000160300720bULL, 0x000fc80003f1e000ULL, 0x0000000316107208ULL, 0x000fe40004000000ULL,
0x0000003a1100720bULL, 0x000fe40003f1e000ULL, 0x000000171000720bULL, 0x000fc80003f3e000ULL,
0x0000001017037208ULL, 0x000fe40004800000ULL, 0x000000113a107208ULL, 0x000fe40004000000ULL,
0x0000001c0300720bULL, 0x000fe40003f3e000ULL, 0x0000003b1000720bULL, 0x000fe40003f1e000ULL,
0x000000031c187208ULL, 0x000fe40004800000ULL, 0x000000103b037208ULL, 0x000fc40004000000ULL,
0x0000001d1800720bULL, 0x000fe40003f3e000ULL, 0x000000520300720bULL, 0x000fe40003f1e000ULL,
0x000000181d117208ULL, 0x000fe40004800000ULL, 0x0000000352107208ULL, 0x000fe40004000000ULL,
0x0000002c1100720bULL, 0x000fe40003f3e000ULL, 0x000000531000720bULL, 0x000fc40003f1e000ULL,
0x000000112c187208ULL, 0x000fe40004800000ULL, 0x0000001053037208ULL, 0x000fe40004000000ULL,
0x0000002d1800720bULL, 0x000fe40003f3e000ULL, 0x0000004e0300720bULL, 0x000fe40003f1e000ULL,
0x000000182d187208ULL, 0x000fe40004800000ULL, 0x000000034e107208ULL, 0x000fc60004000000ULL,
0x0c401f0018117f89ULL, 0x000ea200000e0000ULL, 0x0000004f1000720bULL, 0x000fc80003f1e000ULL,
0x000000104f107208ULL, 0x000fc80004000000ULL, 0x000000271000720bULL, 0x000fc80003f1e000ULL,
0x0000001027037208ULL, 0x000fc80004000000ULL, 0x000000260300720bULL, 0x000fc80003f1e000ULL,
0x0000000326037208ULL, 0x000fe40004000000ULL, 0x000000111800720bULL, 0x004fe40003f3e000ULL,
0x0000001a0300720bULL, 0x000fe40003f1e000ULL, 0x0000001811117208ULL, 0x000fe40004800000ULL,
0x000000031a107208ULL, 0x000fc60004000000ULL, 0x0c201f00111e7f89ULL, 0x000ea200000e0000ULL,
0x000000251000720bULL, 0x000fc80003f1e000ULL, 0x0000001025037208ULL, 0x000fc80004000000ULL,
0x000000220300720bULL, 0x000fc80003f1e000ULL, 0x0000000322107208ULL, 0x000fc80004000000ULL,
0x000000231000720bULL, 0x000fc80003f1e000ULL, 0x0000001023187208ULL, 0x000fe40004000000ULL,
0x0000001e1100720bULL, 0x004fe40003f3e000ULL, 0x000000211800720bULL, 0x000fe40003f1e000ULL,
0x000000111e107208ULL, 0x000fe40004800000ULL, 0x0000001821037208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b101e7820ULL, 0x000fe20000410000ULL, 0x000000200300720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b14197823ULL, 0x100fe2000001081eULL, 0x0000000320037208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b50507823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b51517823ULL, 0x100fe2000001081eULL, 0x0000002e0300720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b15157823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b39397823ULL, 0x100fe2000001081eULL, 0x000000032e187208ULL, 0x000fe20004000000ULL,
0x0000001500327308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe2000001081eULL, 0x0000002f1800720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b16167823ULL, 0x100fe2000001081eULL, 0x000000182f187208ULL, 0x000fe20004000000ULL,
0x0000001700347308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b1d307823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b2c2c7823ULL, 0x000fc4000001081eULL, 0x0c401f0018037f89ULL, 0x000ea800000e0000ULL,
0x0000001b001b7308ULL, 0x000ff00000000800ULL, 0x00000039002a7308ULL, 0x000ef00000000800ULL,
0x0000005000507308ULL, 0x000fe20000000800ULL, 0x000000031800720bULL, 0x004fc80003f1e000ULL,
0x0000001803117208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b1c037823ULL, 0x100fe4000001081eULL,
0x0000005100517308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b2d1e7823ULL, 0x000fe2000001081eULL,
0x0c201f0011147f89ULL, 0x000f2c00000e0000ULL, 0x00000019002b7308ULL, 0x000ff00000000800ULL,
0x0000001e002d7308ULL, 0x000ff00000000800ULL, 0x0000001600317308ULL, 0x0005e20000000800ULL,
0x000000141100720bULL, 0x010fc80003f1e000ULL, 0x0000001114117208ULL, 0x000fc60004000000ULL,
0x0000004c004c7308ULL, 0x000fe20000000800ULL, 0x0000001b2a14723eULL, 0x008fe400000000ffULL,
0x000000505116723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b11337820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b52527823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010833ULL,
0x0000003a00157308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b27197823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b261e7823ULL, 0x100fe20000010833ULL, 0x3c003c0000267802ULL, 0x000fe20000000f00ULL,
0x3c003c00ff277424ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b1a357823ULL, 0x100fe20000010833ULL,
0x0000003b00187308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b25377823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010833ULL,
0x0c401f0012257f89ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b2f2f7823ULL, 0x000fc40000010833ULL, 0x0000005200177308ULL, 0x000fe20000000800ULL,
0x000000151815723eULL, 0x004fce00000000ffULL, 0x00000053001c7308ULL, 0x000eb00000000800ULL,
0x00000019001f7308ULL, 0x0009e20000000800ULL, 0x000000251200720bULL, 0x008fe40003f1e000ULL,
0x000000171c17723eULL, 0x004fca00000000ffULL, 0x0000004d004d7308ULL, 0x000ea20000000800ULL,
0x0000001225127208ULL, 0x000fe20004000000ULL, 0x000000261418723cULL, 0x010fec00000018ffULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x0000004c4d1c723eULL, 0x004fce00000000ffULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x0000004e001d7308ULL, 0x000ff00000000800ULL,
0x0000004f00367308ULL, 0x000eb00000000800ULL, 0x0000001e002a7308ULL, 0x0007220000000800ULL,
0x0000001d361d723eULL, 0x004fce00000000ffULL, 0x0000003500357308ULL, 0x000fe20000000800ULL,
0x00000028291e723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b21297823ULL, 0x000fe20000010833ULL,
0x0c401f0013287f89ULL, 0x000ea200000e0000ULL, 0x0000001f2a1f723eULL, 0x010fc800000000ffULL,
0x0000003700387308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b202a7823ULL, 0x000fe20000010833ULL,
0x0000002b3220723eULL, 0x000fe200000000ffULL, 0x0000000802327824ULL, 0x000fe200078e00ffULL,
0x000000261c18723cULL, 0x000fe80000001818ULL, 0x0000002200397308ULL, 0x0009e20000000800ULL,
0x000000353821723eULL, 0x008fce00000000ffULL, 0x0000002300367308ULL, 0x000ee20000000800ULL,
0x000000313422723eULL, 0x010fe400000000ffULL, 0x000000281300720bULL, 0x004fe40003f3e000ULL,
0x0000000300317812ULL, 0x000fe200078ec0ffULL, 0x0000000802007824ULL, 0x000fe200078e00ffULL,
0x0000001328137208ULL, 0x000fe20004800000ULL, 0x0000000300037308ULL, 0x000fe40000000800ULL,
0x0000000131257824ULL, 0x000fe200078e0202ULL, 0x000000393623723eULL, 0x008fca00000000ffULL,
0x0000003000307308ULL, 0x000eb00000000800ULL, 0x0000002900377308ULL, 0x000ff00000000800ULL,
0x0000002a003a7308ULL, 0x0007300000000800ULL, 0x0000002c002c7308ULL, 0x000f620000000800ULL,
0x000000262028723cULL, 0x008fee0000001818ULL, 0x0000002e002e7308ULL, 0x000fe20000000800ULL,
0x000000033018723eULL, 0x004fe200000000ffULL, 0x0000000c25307836ULL, 0x000fe20000000000ULL,
0x0c201f0012037f89ULL, 0x000ea200000e0000ULL, 0x000000373a19723eULL, 0x010fc400000000ffULL,
0x0000002c2d1a723eULL, 0x022fe400000000ffULL, 0x0000002f002f7308ULL, 0x000e620000000800ULL,
0x000008005c2c7824ULL, 0x000fe200078e020bULL, 0x00000004252d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff337224ULL, 0x000fe200078e001aULL, 0x0000002e2f1b723eULL, 0x002fe200000000ffULL,
0x00000008022e7836ULL, 0x000fe20000000000ULL, 0xfffffff800027812ULL, 0x000fe200078ee225ULL,
0x000110002c257836ULL, 0x000fe20000000000ULL, 0x0c201f0013007f89ULL, 0x000e6200000e0000ULL,
0x00000001312f7824ULL, 0x000fe200078e022eULL, 0x000000031200720bULL, 0x004fe20003f1e000ULL,
0x000000261828723cULL, 0x000fe20000001828ULL, 0x000000082e347824ULL, 0x000fc400078e00ffULL,
0x000000082e317824ULL, 0x000fe200078e00ffULL, 0xfffffff8322e7812ULL, 0x000fe200078ee22dULL,
0x0000001002027824ULL, 0x100fe200078e0225ULL, 0xfffffff8342c7812ULL, 0x000fe200078ee22fULL,
0x000000ffff2d7224ULL, 0x000fe200078e0016ULL, 0x0000001203127208ULL, 0x000fe20004000000ULL,
0x000000102e267824ULL, 0x100fe200078e0225ULL, 0x0000000309ff7812ULL, 0x000fe2000780c0ffULL,
0x000000102c277824ULL, 0x000fe200078e0225ULL, 0xfffffff831347812ULL, 0x000fe200078ee230ULL,
0x000000ffff2e7224ULL, 0x000fe200078e001cULL, 0x00000014002c7202ULL, 0x000fe20000000f00ULL,
0x000000ffff2f7224ULL, 0x000fe200078e001eULL, 0x0000002534347211ULL, 0x000fe200078e20ffULL,
0x000000ffff147224ULL, 0x000fc400078e0015ULL, 0x000000ffff307224ULL, 0x000fe200078e0020ULL,
0x0000002c02007844ULL, 0x0005e20000000200ULL, 0x000000001300720bULL, 0x002fe20003f3e000ULL,
0x000000ffff317224ULL, 0x000fe400078e0022ULL, 0x000000ffff327224ULL, 0x000fe200078e0018ULL,
0x0000001300137208ULL, 0x000fe20004800000ULL, 0x000000ffff157224ULL, 0x000fe400078e0017ULL,
0x000000ffff167224ULL, 0x000fe200078e001dULL, 0x0000003026007844ULL, 0x0005e20000000200ULL,
0x000000ffff177224ULL, 0x000fe200078e001fULL, 0x0000001b001f7202ULL, 0x000fe20000000f00ULL,
0x000000ffff1c7224ULL, 0x000fc400078e0021ULL, 0x000000ffff1d7224ULL, 0x000fe200078e0023ULL,
0x0000001427007844ULL, 0x0005e20000000200ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0019ULL,
0x000000ffff297224ULL, 0x000fe400078e002aULL, 0x00000001ff037424ULL, 0x000fe200078e00ffULL,
0x0000001c34007844ULL, 0x0005e80000000200ULL, 0x01b0001024008388ULL, 0x0005e80000000c00ULL,
0x01b2002824008388ULL, 0x0005e20000000a00ULL, 0x0000000e6100720cULL, 0x000fe20003f06070ULL,
0x01b6080304ff79a7ULL, 0x0005e2000850003fULL, 0x01b6100304ff79a7ULL, 0x0005e2000850003fULL,
0x01b6180304ff79a7ULL, 0x0005e2000850003fULL, 0x01b6200304ff79a7ULL, 0x0005f2000850003fULL,
0xffffffa000fc8947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000008037836ULL, 0x000fe20000000000ULL, 0x0000013000007945ULL, 0x000fe80003800000ULL,
0x7f80000003057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000000800038308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff127807ULL, 0x000fe40000800000ULL, 0x00000001ff037807ULL, 0x004fc80004000000ULL,
0x0000000312ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff08ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000008057812ULL, 0x000fe400078ec0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000312ff7212ULL, 0x000fda000780c0ffULL,
0x0080000005030812ULL, 0x000fe200078efcffULL, 0x000000ffff038224ULL, 0x000fe200078e0005ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000800037308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffffecc04bc7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL,
0x00000000000004c5ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000640ULL,
0x0000000000000210ULL, 0x0000001400000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000850ULL,
0x00000000000000d0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000920ULL,
0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000974ULL,
0x0000000000000424ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d98ULL,
0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d98ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000de0ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e00ULL,
0x0000000000013200ULL, 0x0000001400000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000008dULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000014000ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000014040ULL,
0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000014040ULL,
0x0000000000000260ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x0000000000014620ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000014620ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000de0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000e00ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000013200ULL, 0x0000000000013200ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x0000000000014040ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000260ULL,
0x0000000000000260ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_128_nqpkv_8_m_8_sm_90_cubin_len = 83824;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
