/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000017140ULL, 0x0000000000016dc0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL,
0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL,
0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL,
0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL,
0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c00010000028dULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00010000036fULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b0022000003b5ULL, 0x00000000000154f0ULL, 0x0000000000000170ULL, 0x000b0022000003e8ULL,
0x0000000000015660ULL, 0x0000000000000040ULL, 0x000b002200000413ULL, 0x00000000000156a0ULL,
0x0000000000000050ULL, 0x000b00220000043dULL, 0x00000000000156f0ULL, 0x0000000000000110ULL,
0x000a0003000004abULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000004cbULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004fbULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000015800ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000154f000000000ULL, 0x0000040400000000ULL, 0x810c000001500400ULL,
0x0053e00400288080ULL, 0x0000000000000000ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8408288080830828ULL, 0x2880808a08288080ULL, 0x808d082880808c08ULL, 0x082880808e082880ULL,
0x808098082880808fULL, 0x9d082880809a0828ULL, 0x288080a308288080ULL, 0x80aa08288080a408ULL,
0x08288080ab082880ULL, 0x8080b108288080b0ULL, 0x8016288080880828ULL, 0x0000000310288082ULL,
0x8088920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x000154f000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000094ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8408288080830828ULL, 0x2880808808288080ULL, 0x808e082880808a08ULL,
0x082880808f082880ULL, 0x8080970828808096ULL, 0x9d08288080980828ULL, 0x288080a308288080ULL,
0x80aa08288080a408ULL, 0x08288080ab082880ULL, 0x8080b108288080b0ULL, 0x80162880808c0828ULL,
0x0000000310288082ULL, 0x808c920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL,
0x0000013800000000ULL, 0x0001566000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8408288080830828ULL, 0x2880808808288080ULL,
0x808c082880808a08ULL, 0x082880808d082880ULL, 0x808096082880808eULL, 0x9808288080970828ULL,
0x2880809d08288080ULL, 0x80a408288080a308ULL, 0x08288080aa082880ULL, 0x8080b008288080abULL,
0x8f08288080b10828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880808f920000ULL,
0x0000000000000022ULL, 0x0000002cffffffffULL, 0x0000020000000000ULL, 0x000156a000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x808e2880808f0900ULL, 0x0000000000002880ULL,
0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8408288080830828ULL, 0x2880808808288080ULL,
0x808c082880808a08ULL, 0x082880808f082880ULL, 0x8080970828808096ULL, 0x9d08288080980828ULL,
0x288080a308288080ULL, 0x80aa08288080a408ULL, 0x08288080ab082880ULL, 0x8080b108288080b0ULL,
0x80162880808e0828ULL, 0x0000000310288082ULL, 0x808e920000000000ULL, 0x0000000022002880ULL,
0x0000001cffffffffULL, 0x000002e000000000ULL, 0x000156f000000000ULL, 0x0000011000000000ULL,
0x0000000000000000ULL, 0x0000001800082f04ULL, 0x0008230400000080ULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL,
0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL,
0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL,
0x0000001100082304ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008230400000000ULL, 0x0000000000000018ULL, 0x0000001800081204ULL, 0x0008110400000000ULL,
0x0000000000000018ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0060016000000015ULL,
0x000c170400601903ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL,
0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL,
0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00801b030011f000ULL, 0x000008b000043104ULL, 0xffffffff01542904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000041001542804ULL, 0x000004e000000440ULL, 0x00002ba000001a70ULL,
0x00002d5000002c30ULL, 0x000030b000002eb0ULL, 0x00003150000030e0ULL, 0x000038a0000031c0ULL,
0x0000493000004890ULL, 0x00004bc000004a60ULL, 0x00004e0000004dd0ULL, 0x00004ee000004e70ULL,
0x000062e0000052f0ULL, 0x000064b000006380ULL, 0x0000682000006610ULL, 0x000068c000006850ULL,
0x00006d3000006930ULL, 0x00007e6000007dd0ULL, 0x000080f000007f90ULL, 0x0000833000008300ULL,
0x00008410000083a0ULL, 0x000089c0000089b0ULL, 0x0000ada00000ad60ULL, 0x0000b5100000b4d0ULL,
0x00013ab000013a70ULL, 0x00013ad000013ac0ULL, 0x00013b4000013ae0ULL, 0x00013b8000013b60ULL,
0x00014810000147c0ULL, 0x000148e000014880ULL, 0x000149c000014950ULL, 0x00014a7000014a20ULL,
0x00014b4000014ae0ULL, 0x00014c2000014bb0ULL, 0x00014cd000014c80ULL, 0x00014da000014d40ULL,
0x00014e8000014e10ULL, 0x00014f3000014ee0ULL, 0x0001500000014fa0ULL, 0x000150e000015070ULL,
0x000151d000015150ULL, 0x000152d000015250ULL, 0x000153d000015350ULL, 0x000154d000015450ULL,
0x000003e002003904ULL, 0x0001b600000000ffULL, 0x00000460003f0100ULL, 0x0001b6080000000bULL,
0x00000490003f0120ULL, 0x0001b6880000000bULL, 0x00000910003f0120ULL, 0x0001b600000000ffULL,
0x00000ad0003f0107ULL, 0x0001b68c0000006eULL, 0x00000ba0003f0102ULL, 0x0001b6880000006eULL,
0x000028b0003f0101ULL, 0x0001b60800000007ULL, 0x000028d0003f0101ULL, 0x0001b60c00000007ULL,
0x00002aa0003f0105ULL, 0x0001b60c00000007ULL, 0x00003840003f0105ULL, 0x0001b68800000057ULL,
0x000045f0003f0101ULL, 0x0001b62800000012ULL, 0x00004610003f0101ULL, 0x0001b62c00000012ULL,
0x000047e0003f0105ULL, 0x0001b62c00000012ULL, 0x00005270003f0105ULL, 0x0000000000000008ULL,
0x00006040003f0101ULL, 0x0001b64800000032ULL, 0x00006060003f0101ULL, 0x0001b64c00000032ULL,
0x00006230003f0105ULL, 0x0001b64c00000032ULL, 0x00006d10003f0105ULL, 0x000000000000000dULL,
0x00007b30003f0101ULL, 0x0001b66800000034ULL, 0x00007b50003f0101ULL, 0x0001b66c00000034ULL,
0x00007d20003f0105ULL, 0x0001b66c00000034ULL, 0x000087f0003f0105ULL, 0x000000000000000aULL,
0x0000c460003f0101ULL, 0x0001b600000000ffULL, 0x0000dc90003f0101ULL, 0x0001b604000000ffULL,
0x0000de60003f0105ULL, 0x0001b604000000ffULL, 0x00011f50003f0105ULL, 0x0000000000000075ULL,
0x00012090003f0101ULL, 0x0000000400000075ULL, 0x00012260003f0105ULL, 0x0000000400000075ULL,
0x00014610003f0105ULL, 0x0001b60800000076ULL, 0x00014670003f0101ULL, 0x0001b61000000076ULL,
0x000146d0003f0101ULL, 0x0001b61800000076ULL, 0x00014740003f0101ULL, 0x0001b62000000076ULL,
0x00033803003f0101ULL, 0x0000bd5000201c04ULL, 0x0000bf600000bd80ULL, 0x0000c2500000c0c0ULL,
0x0000dec00000c350ULL, 0x0000040100014780ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000394ULL,
0x0000001800000002ULL, 0x00000000000002bcULL, 0x0000001800000002ULL, 0x00000000000001ecULL,
0x0000001800000002ULL, 0x0000000000000124ULL, 0x0000001800000002ULL, 0x0000000000000044ULL,
0x0000001800000002ULL, 0x000000000000036dULL, 0x0000001800000002ULL, 0x0000000000000292ULL,
0x0000001800000002ULL, 0x00000000000001c5ULL, 0x0000001800000002ULL, 0x00000000000000fdULL,
0x0000001800000002ULL, 0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff107624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000747919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000087919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a0010757a19ULL, 0x000fe200000006ffULL,
0x00000000000579c3ULL, 0x000f220000002500ULL, 0x0000000000097919ULL, 0x000ea20000002100ULL,
0x0000460000087ab9ULL, 0x000fc60000000a00ULL, 0x0000000000797919ULL, 0x000ea20000002700ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003077a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a07ULL, 0x0000040003007624ULL, 0x000fca00078e0210ULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff07aa12ULL, 0x000fc800078e33ffULL,
0x0000000700007306ULL, 0x000e620000209000ULL, 0x000000ff0700720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000307047224ULL, 0x004fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a04ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000007403717227ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000ee40000002200ULL, 0x000000ffff007224ULL, 0x000fc800078e0a71ULL,
0x0000000007007224ULL, 0x000fca00078e0274ULL, 0x000000070000720cULL, 0x000fda0003f06070ULL,
0x0000000100000824ULL, 0x000fe200078e0a07ULL, 0x0000000171710810ULL, 0x000fe20007ffe0ffULL,
0x0000010008027a24ULL, 0x008fc600078e0203ULL, 0x000000070000720cULL, 0x000fe20003f26070ULL,
0x00000000020b7a24ULL, 0x000fca00078e0209ULL, 0x000000ff0b00720cULL, 0x040fe40003f65270ULL,
0x0000000f0b00780cULL, 0x040fe40003f84070ULL, 0x000000030b00780cULL, 0x000fc60003f04070ULL,
0x0000000171711810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff71a212ULL, 0x000fe400078e33ffULL,
0x0000007f0b00780cULL, 0x000fe40003f24070ULL, 0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL,
0x000000ffff007224ULL, 0x000fe200078e0a71ULL, 0x3fffffc00004c802ULL, 0x000fe20000000f00ULL,
0x7fffff80ff03b424ULL, 0x000fc400078e00ffULL, 0x0000000007747224ULL, 0x000fe200078e0274ULL,
0x00000005ff007819ULL, 0x000fe20000011609ULL, 0x7fffffc0ff05c424ULL, 0x000fe200078e00ffULL,
0x01b60002ff00b388ULL, 0x0003e20000000a00ULL, 0x00000010746b7824ULL, 0x000fe400078e00ffULL,
0x3fffff60ff068424ULL, 0x000fe200078e00ffULL, 0x00001fff08097589ULL, 0x000fe200000e0000ULL,
0x7fffff60ff078424ULL, 0x000fe400078e00ffULL, 0xff317217ff0a9424ULL, 0x000fe200078e00ffULL,
0x00001fff00007589ULL, 0x000ea200000e0000ULL, 0x000000046b027c10ULL, 0x002fc6000fffe1ffULL,
0x01b608040b00c388ULL, 0x000fe20000008a00ULL, 0x00005a0071037a19ULL, 0x000fe400000006ffULL,
0x0000001002027817ULL, 0x000fe20003800000ULL, 0x01b688060b008388ULL, 0x000fe20000008a00ULL,
0x000000046b007c0cULL, 0x000fc6000bf03070ULL, 0x01b4000a0b009388ULL, 0x000fe20000004800ULL,
0x000000ff02737207ULL, 0x000fe20000000000ULL, 0x0000580079027a24ULL, 0x000fe400078e02ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000107300780cULL, 0x000fe20003f05270ULL,
0x0000007502037224ULL, 0x000fc400078e0203ULL, 0x0000000409047824ULL, 0x004fe400078e0200ULL,
0x00000005ff027e24ULL, 0x010fe4000f8e00ffULL, 0x0000000204047824ULL, 0x000fcc00078e00ffULL,
0x000001d000008947ULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00000004ff077819ULL, 0x002fca0000011606ULL,
0x0000000104087824ULL, 0x000fc800078e0207ULL, 0x000000016b057824ULL, 0x000fca00078e0208ULL,
0x00000004050c7c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0a7a19ULL, 0x000fe40000011605ULL,
0x0000000c030c7210ULL, 0x000fe40007ffe0ffULL, 0x0000000473037217ULL, 0x000fc60007800000ULL,
0x000000750a057224ULL, 0x000fe400078e020cULL, 0x00000010060c7824ULL, 0x000fe400078e00ffULL,
0x0000000103037824ULL, 0x000fe400078e0a04ULL, 0x0000010005047825ULL, 0x000fe200078e00ffULL,
0x000000f00c0b7812ULL, 0x000fe400078ec0ffULL, 0x000000030700720cULL, 0x000fe20003f06070ULL,
0x0000000108037824ULL, 0x000fe200078e0206ULL, 0x0000000b040b7212ULL, 0x000fe200078efcffULL,
0x0000001008087824ULL, 0x000fc600078e00ffULL, 0x00005e000b047a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff008037812ULL, 0x000fe400078ee203ULL, 0x00005f0005057a10ULL, 0x000fc60000ffe4ffULL,
0x0000001003037824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e2000c101c48ULL, 0x0000018000007947ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x0000000406077211ULL, 0x042fe200078fe0ffULL, 0x00000010060c7824ULL, 0x000fc800078e00ffULL,
0x000000016b047824ULL, 0x000fe200078e0207ULL, 0x000000f00c0b7812ULL, 0x000fc800078ec0ffULL,
0x0000000404087c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff047a19ULL, 0x000fc60000011604ULL,
0x0000000103087824ULL, 0x000fe400078e0208ULL, 0x0000000107037824ULL, 0x040fe400078e0206ULL,
0x0000007504047224ULL, 0x000fe400078e0208ULL, 0x0000001007087824ULL, 0x000fe400078e00ffULL,
0x0000010004047825ULL, 0x000fc600078e00ffULL, 0xfffffff008037812ULL, 0x000fe400078ee203ULL,
0x0000000b04047212ULL, 0x000fc600078efcffULL, 0x0000001003037824ULL, 0x000fe200078e00ffULL,
0x00005e0004047a10ULL, 0x000fc80007f1e0ffULL, 0x00005f0005057a10ULL, 0x000fca00007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e8000b901c48ULL,
0x0000000000057919ULL, 0x002e620000000000ULL, 0x0000000000037806ULL, 0x000fe200038e0000ULL,
0x00000004ff0a7424ULL, 0x000fc600078e00ffULL, 0x0000000300047300ULL, 0x000e6200000e0000ULL,
0x0000660079687625ULL, 0x000fce00078e000aULL, 0x0000000300077309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe40003f02070ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x80000007ff047210ULL, 0x004fd40007ffe0ffULL, 0x01b60404ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01b60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000868687981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0900720cULL, 0x000fe40003f05270ULL,
0x0000003f686c7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff685d7810ULL, 0x000fc40007ffe0ffULL,
0x00000006ff6c7819ULL, 0x000fe4000001166cULL, 0x00000008ff5d7819ULL, 0x000fca000001165dULL,
0x0000b95000008947ULL, 0x000fea0003800000ULL, 0x00000002ff6d7819ULL, 0x000fe20000011600ULL,
0x00000008006e7824ULL, 0x000fe400078e00ffULL, 0x00000003ff077424ULL, 0x000fe200078e00ffULL,
0x03ffffff6d097812ULL, 0x000fca00078ec0ffULL, 0x0000000402097824ULL, 0x000fca00078e0209ULL,
0x0000006c0900720cULL, 0x000fda0003f06070ULL, 0x0000000279038824ULL, 0x000fe400078e00ffULL,
0x00006800ff048624ULL, 0x002fc800078e00ffULL, 0x0000680003048624ULL, 0x000fe400078e0204ULL,
0xffffffffff037424ULL, 0x000fe400078e00ffULL, 0x0000000109058824ULL, 0x000fe200078e0204ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b68c076eff738cULL, 0x0003e20000000000ULL,
0x0000640005048625ULL, 0x000fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000804038981ULL, 0x000ea2000c1e1900ULL, 0x0000000102087810ULL, 0x000fe20007ffe0ffULL,
0x0000004071677824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x002fe20000011600ULL,
0x00000100ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000005d0800720cULL, 0x000fe20003f06070ULL,
0x01b688006eff7f8cULL, 0x0003e2000c80043fULL, 0x00000001006b7812ULL, 0x000fe200078ec0ffULL,
0x00000020076f7824ULL, 0x000fca00078e00ffULL, 0x0000006f020f7211ULL, 0x000fe200078e40ffULL,
0x0000590003037a24ULL, 0x004fc800078e02ffULL, 0x0000004003087824ULL, 0x000fe200078e00ffULL,
0x0000002067037812ULL, 0x000fc600078ef80fULL, 0x0000620008047625ULL, 0x000fe200078e000bULL,
0x0000064000008947ULL, 0x000fea0003800000ULL, 0x0000000f68087217ULL, 0x002fe20007800000ULL,
0x00000002071c7824ULL, 0x000fe200078e026bULL, 0x00000003ff0b7819ULL, 0x000fe40000011606ULL,
0x000000700c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000108087824ULL, 0x000fe200078e0a0fULL,
0x000000040b0d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c0b197810ULL, 0x000fe20007ffe0ffULL,
0x000000806b0c7824ULL, 0x000fe200078e020cULL, 0x000000080b137810ULL, 0x000fe20007ffe0ffULL,
0x000000010d0e7824ULL, 0x140fe200078e0206ULL, 0x0000002008087817ULL, 0x000fe20003800000ULL,
0x000000080d1b7824ULL, 0x000fe200078e00ffULL, 0x000000100b1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000119107824ULL, 0x000fe200078e0206ULL, 0x000000080d00720cULL, 0x080fe20003f86070ULL,
0x0000000819237824ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee20eULL,
0x0000000103117824ULL, 0x000fe200078e020dULL, 0x000000ff000d7202ULL, 0x000fe20000000f00ULL,
0x00000001130f7824ULL, 0x000fe200078e0206ULL, 0xfffffff823237812ULL, 0x000fe200078ee210ULL,
0x0000000813127824ULL, 0x000fe200078e00ffULL, 0x000000140b1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000010011107825ULL, 0x000fe200078e000cULL, 0x000000081300720cULL, 0x000fc40003f66070ULL,
0xfffffff812217812ULL, 0x000fe200078ee20fULL, 0x00000001030f7824ULL, 0x000fe200078e020bULL,
0x0000001004167210ULL, 0x000fe20007f3e0ffULL, 0x000000011d127824ULL, 0x000fe200078e0206ULL,
0x000000081900720cULL, 0x080fe20003f46070ULL, 0x000001000f0e7825ULL, 0x000fe200078e000cULL,
0x000130001c1c7811ULL, 0x000fe400078e68ffULL, 0x000000080b00720cULL, 0x000fe20003fa6070ULL,
0x000000081d257824ULL, 0x000fe200078e00ffULL, 0x0000000e04147210ULL, 0x000fe20007f1e0ffULL,
0x000000011f157824ULL, 0x000fe200078e0206ULL, 0x0000001c0b2b7810ULL, 0x000fe20007ffe0ffULL,
0x000000081f187824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee212ULL,
0x0000000105177824ULL, 0x000fe200008e0611ULL, 0x000000081d00720cULL, 0x000fe20003f26070ULL,
0x0000000103117824ULL, 0x000fe200078e0219ULL, 0xfffffff818297812ULL, 0x000fe200078ee215ULL,
0x0000000105157824ULL, 0x000fc400000e060fULL, 0x000000010b127824ULL, 0x000fe400078e0206ULL,
0x0000010011107825ULL, 0x000fc600078e000cULL, 0x0000000712197812ULL, 0x000fe200078ec0ffULL,
0x00000001030f7824ULL, 0x040fe200078e0213ULL, 0x0000001004107210ULL, 0x000fe20007fde0ffULL,
0x0000000103137824ULL, 0x000fe200078e021dULL, 0x0ffffff819197812ULL, 0x000fe200078ef806ULL,
0x0000000103277824ULL, 0x000fe400078e021fULL, 0x0000010013127825ULL, 0x000fc800078e000cULL,
0x0000000105117824ULL, 0x000fe200030e0611ULL, 0x0000001204187210ULL, 0x000fe20007fde0ffULL,
0x000001000f0e7825ULL, 0x000fc800078e000cULL, 0x00000010191d7824ULL, 0x000fe200078e021cULL,
0x0000000e040e7210ULL, 0x040fe20007f1e0ffULL, 0x0000000105197824ULL, 0x000fe400030e0613ULL,
0x0000010027127825ULL, 0x000fe200078e000cULL, 0x000000180b277810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000141d7faeULL, 0x0003e2000e901c48ULL,
0x0000000f050f7210ULL, 0x000fe200007fe4ffULL, 0x00000001032d7824ULL, 0x040fe200078e022bULL,
0x00000012041a7210ULL, 0x000fe20007fde0ffULL, 0x00000001030b7824ULL, 0x000fe200078e0227ULL,
0x000000081f00720cULL, 0x080fe20003f06070ULL, 0x000000101b1f7824ULL, 0x000fe200078e021cULL,
0x000000082700720cULL, 0x000fe20003fa6070ULL, 0x00000001051b7824ULL, 0x000fc400030e0613ULL,
0x000001000b127825ULL, 0x000fe200078e000cULL, 0x00000000161f7faeULL, 0x0005e2000e101c48ULL,
0x000000082b00720cULL, 0x000fe40003f86070ULL, 0x0000000127037824ULL, 0x140fe200078e0206ULL,
0x0000001204127210ULL, 0x000fe20007fde0ffULL, 0x0000000827147824ULL, 0x002fe200078e00ffULL,
0x000000032b0b7819ULL, 0x040fe200000006ffULL, 0x000000012b087824ULL, 0x000fe400078e0206ULL,
0x000001002d0c7825ULL, 0x000fe200078e000cULL, 0xfffffff814037812ULL, 0x000fc400078ee203ULL,
0xfffffff80b0b7812ULL, 0x000fe200078ee208ULL, 0x0000000105137824ULL, 0x000fe200030e0613ULL,
0x0000000c04047210ULL, 0x000fe20007fde0ffULL, 0x0000001021217824ULL, 0x100fe400078e021cULL,
0x0000001023237824ULL, 0x100fe400078e021cULL, 0x0000001025257824ULL, 0x100fe200078e021cULL,
0x000000000e217faeULL, 0x0005e2000d901c48ULL, 0x0000001029297824ULL, 0x100fe400078e021cULL,
0x0000001003037824ULL, 0x100fe200078e021cULL, 0x0000000010237faeULL, 0x0005e2000d101c48ULL,
0x000000100b0b7824ULL, 0x000fc400078e021cULL, 0x0000000105057824ULL, 0x000fe200030e060dULL,
0x0000000018257faeULL, 0x0005e8000c901c48ULL, 0x000000001a297faeULL, 0x0005e8000c101c48ULL,
0x0000000012037faeULL, 0x0005e8000e901c48ULL, 0x00000000040b7faeULL, 0x0005e2000e101c48ULL,
0x0000057000007947ULL, 0x000fea0003800000ULL, 0x00000008060e7811ULL, 0x042fe200078fe8ffULL,
0x0000000207187824ULL, 0x000fe200078e026bULL, 0x00000004060d7811ULL, 0x000fc400078fe8ffULL,
0x000000030e127819ULL, 0x040fe200000006ffULL, 0x000000010e0b7824ULL, 0x100fe200078e0206ULL,
0x0000000c06107811ULL, 0x040fe200078fe8ffULL, 0x000000010d087824ULL, 0x040fe200078e0206ULL,
0x0000001406147811ULL, 0x000fe200078fe8ffULL, 0x000000080d0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8121d7812ULL, 0x000fe200078ee20bULL, 0x0000000810137824ULL, 0x000fe200078e00ffULL,
0x0000001006127811ULL, 0x000fe200078fe8ffULL, 0x0000000814227824ULL, 0x000fe200078e00ffULL,
0xfffffff80f1c7812ULL, 0x000fe200078ee208ULL, 0x0000000110087824ULL, 0x100fe200078e0206ULL,
0x000000700c1a7812ULL, 0x000fe200078ec0ffULL, 0x00000001120b7824ULL, 0x000fe200078e0206ULL,
0x0000001c060c7811ULL, 0x000fe200078fe8ffULL, 0x0000000812207824ULL, 0x000fe200078e00ffULL,
0xfffffff8131e7812ULL, 0x000fe200078ee208ULL, 0x00000001140f7824ULL, 0x000fe200078e0206ULL,
0x0000000606087211ULL, 0x000fe200078fe8ffULL, 0x000000080c1b7824ULL, 0x000fe200078e00ffULL,
0x0000001806167811ULL, 0x000fe200078fe8ffULL, 0x000000806b1a7824ULL, 0x000fe200078e021aULL,
0xfffffff820207812ULL, 0x000fe200078ee20bULL, 0x00000001031f7824ULL, 0x000fe200078e020cULL,
0x00000007080b7812ULL, 0x000fe200078ec0ffULL, 0x000000010c087824ULL, 0x100fe200078e0206ULL,
0xfffffff822227812ULL, 0x000fe200078ee20fULL, 0x0000000116117824ULL, 0x000fe200078e0206ULL,
0x0001300018277811ULL, 0x000fe200078e68ffULL, 0x0000000816247824ULL, 0x000fe200078e00ffULL,
0xfffffff81b087812ULL, 0x000fe200078ee208ULL, 0x00000001030f7824ULL, 0x040fe200078e020dULL,
0x00000003060d7211ULL, 0x000fe200078fe8ffULL, 0x000000ffff1b7224ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee211ULL, 0x0000000103137824ULL, 0x040fe200078e0210ULL,
0x0000000e03117210ULL, 0x000fe20007ffe0ffULL, 0x000001000d0c7825ULL, 0x000fe200078e001aULL,
0x0ffffff80b0b7812ULL, 0x000fc600078ef806ULL, 0x000001000f0e7825ULL, 0x000fe200078e001aULL,
0x0000000c040c7210ULL, 0x000fc60007f1e0ffULL, 0x0000000103157824ULL, 0x000fe200078e0212ULL,
0x0000000e040e7210ULL, 0x000fe20007f3e0ffULL, 0x0000010011107825ULL, 0x000fc800078e001aULL,
0x0000000103177824ULL, 0x040fe200078e0214ULL, 0x0000001004107210ULL, 0x000fe20007f5e0ffULL,
0x0000000103197824ULL, 0x000fe400078e0216ULL, 0x0000010013127825ULL, 0x000fc800078e001aULL,
0x0000010015147825ULL, 0x000fe200078e001aULL, 0x0000001204127210ULL, 0x000fc60007f7e0ffULL,
0x0000010017167825ULL, 0x000fc800078e001aULL, 0x0000010019187825ULL, 0x000fc800078e001aULL,
0x000001001f1a7825ULL, 0x000fe200078e001aULL, 0x000000271e1f7211ULL, 0x000fc600078e20ffULL,
0x00000001050d7824ULL, 0x040fe200000e060dULL, 0x0000001404147210ULL, 0x040fe20007f1e0ffULL,
0x00000001050f7824ULL, 0x000fe200008e060fULL, 0x0000001604167210ULL, 0x040fe20007f3e0ffULL,
0x000000100b0b7824ULL, 0x000fe400078e0227ULL, 0x0000000105117824ULL, 0x000fe200010e0611ULL,
0x0000001804187210ULL, 0x000fe20007f5e0ffULL, 0x000000101c037824ULL, 0x100fe200078e0227ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c0b7faeULL, 0x0003e2000b901c48ULL,
0x000000101d1d7824ULL, 0x000fc400078e0227ULL, 0x0000000105137824ULL, 0x040fe200018e0613ULL,
0x0000001a04047210ULL, 0x000fe20007f7e0ffULL, 0x0000001020217824ULL, 0x000fe200078e0227ULL,
0x000000000e037faeULL, 0x0003e2000b901c48ULL, 0x0000000105157824ULL, 0x040fe400000e0615ULL,
0x0000001022237824ULL, 0x000fe200078e0227ULL, 0x00000000101d7faeULL, 0x0003e2000b901c48ULL,
0x0000000105177824ULL, 0x040fe400008e0617ULL, 0x0000001024257824ULL, 0x000fe200078e0227ULL,
0x00000000121f7faeULL, 0x0003e2000b901c48ULL, 0x0000000105197824ULL, 0x040fe200010e0619ULL,
0x0000001b05057210ULL, 0x000fe20001ffe4ffULL, 0x0000001008277824ULL, 0x000fe200078e0227ULL,
0x0000000014217faeULL, 0x0003e8000b901c48ULL, 0x0000000016237faeULL, 0x0003e8000b901c48ULL,
0x0000000018257faeULL, 0x0003e8000b901c48ULL, 0x0000000004277faeULL, 0x0003e4000b901c48ULL,
0x00000300ff037624ULL, 0x006fe200078e00ffULL, 0x0000000309047812ULL, 0x000fe200078ec0ffULL,
0xffffffffff087424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xfffffffd0a727424ULL, 0x000fe200078e0203ULL, 0x000000030400780cULL, 0x000fc80003f05270ULL,
0x0000000172047807ULL, 0x000fca0004000000ULL, 0x0000000109097824ULL, 0x000fca00078e0204ULL,
0x0000006c0900720cULL, 0x000fda0003f06070ULL, 0x0000000279038824ULL, 0x000fe400078e00ffULL,
0x00006800ff048624ULL, 0x000fc800078e00ffULL, 0x0000680003048624ULL, 0x000fc800078e0204ULL,
0x0000000104058824ULL, 0x000fc800078e0209ULL, 0x0000640005048625ULL, 0x000fca00078e000aULL,
0x0000000804088981ULL, 0x000322000c1e1900ULL, 0x0000005d0200720cULL, 0x000fe20003f06070ULL,
0xff317217ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00006e1000000947ULL, 0x000fea0003800000ULL, 0x0000000279697824ULL, 0x002fe200078e00ffULL,
0x000000ff00137202ULL, 0x000fe20000000f00ULL, 0x00006800ff047624ULL, 0x000fc400078e00ffULL,
0xff317217ff0c7424ULL, 0x000fe400078e00ffULL, 0x0000680069697624ULL, 0x000fc400078e0204ULL,
0x00000010000a7824ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe00a0d7812ULL, 0x000fe200078ec0ffULL, 0x0000590008087a24ULL, 0x010fe200078e02ffULL,
0x00000001020a7810ULL, 0x040fe20007ffe0ffULL, 0x00000100ff0f7424ULL, 0x000fe400078e00ffULL,
0x00000100020d7824ULL, 0x000fe200078e020dULL, 0x0000005d0a00720cULL, 0x000fe20003f06070ULL,
0x00000040080e7824ULL, 0x000fc600078e00ffULL, 0x000000400d317810ULL, 0x000fe20007ffe0ffULL,
0x000062000e0e7625ULL, 0x000fc600078e000fULL, 0x0000002031087812ULL, 0x000fca00078ec0ffULL,
0x00000001670d7824ULL, 0x000fe200078e0208ULL, 0x0000068000008947ULL, 0x020fea0003800000ULL,
0x00000010060a7824ULL, 0x000fe200078e00ffULL, 0x00000003ff3e7819ULL, 0x100fe20000011606ULL,
0x0000008000307824ULL, 0x000fe200078e00ffULL, 0x0000003168087217ULL, 0x000fe40007800000ULL,
0x000000700a337812ULL, 0x000fe200078ec0ffULL, 0x000000013e347824ULL, 0x040fe200078e0206ULL,
0x000000043e367810ULL, 0x000fe20007ffe0ffULL, 0x0000000108317824ULL, 0x000fe200078e0a31ULL,
0x0000008033307812ULL, 0x000fe200078ef830ULL, 0x0000200000087824ULL, 0x000fe200078e00ffULL,
0x0000000c3e447810ULL, 0x000fe20007ffe0ffULL, 0x00000001360a7824ULL, 0x000fe200078e0206ULL,
0x000000083e427810ULL, 0x000fe20007ffe0ffULL, 0x0000000836337824ULL, 0x000fe200078e00ffULL,
0x0000200008087812ULL, 0x000fe200078ec0ffULL, 0x00000001443b7824ULL, 0x100fe200078e020dULL,
0x000000143e487810ULL, 0x000fe20007ffe0ffULL, 0x0000000842357824ULL, 0x000fe200078e00ffULL,
0xfffffff833407812ULL, 0x000fe200078ee20aULL, 0x00000001440a7824ULL, 0x000fe200078e0206ULL,
0x00000006423c7210ULL, 0x000fe20007ffe0ffULL, 0x0000000844337824ULL, 0x000fe200078e00ffULL,
0x000000103e467810ULL, 0x000fe20007ffe0ffULL, 0x00004000073a7824ULL, 0x000fe200078e0208ULL,
0x00000020313d7817ULL, 0x000fe20003800000ULL, 0x0000000148077824ULL, 0x040fe200078e0206ULL,
0xfffffff8330a7812ULL, 0x000fe200078ee20aULL, 0x0000000848327824ULL, 0x000fe200078e00ffULL,
0xfffffff8353c7812ULL, 0x000fe200078ee23cULL, 0x000000013e337824ULL, 0x000fe200078e020dULL,
0x0000000734417812ULL, 0x000fe200078ec0ffULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0xfffffff832077812ULL, 0x000fe200078ee207ULL, 0x0000000146087824ULL, 0x000fe200078e0206ULL,
0x0000003d3600720cULL, 0x080fe20003f66070ULL, 0x0000000846357824ULL, 0x000fe200078e00ffULL,
0x000140003a3f7810ULL, 0x000fe20007ffe0ffULL, 0x0000010033327825ULL, 0x000fe200078e0030ULL,
0x0000003d3e00720cULL, 0x000fc40003f86070ULL, 0xfffffff835087812ULL, 0x000fe200078ee208ULL,
0x0000000142377824ULL, 0x000fe200078e020dULL, 0x000000320e387210ULL, 0x000fe20007f5e0ffULL,
0x0000001040437824ULL, 0x000fe200078e023fULL, 0x0000000d36357210ULL, 0x000fe20007ffe0ffULL,
0x0000000148457824ULL, 0x000fe200078e020dULL, 0x0000003d4200720cULL, 0x000fe20003f06070ULL,
0x000000010f397824ULL, 0x000fe200010e0633ULL, 0x000000183e407810ULL, 0x040fe20007ffe0ffULL,
0x0000010035327825ULL, 0x000fe200078e0030ULL, 0x0000001c3e427810ULL, 0x000fc40007ffe0ffULL,
0x0000003d4400720cULL, 0x000fe20003f26070ULL, 0x0000010037347825ULL, 0x000fe200078e0030ULL,
0x000000320e3a7210ULL, 0x000fc60007f5e0ffULL, 0x000001003b367825ULL, 0x000fe200078e0030ULL,
0x000000340e327210ULL, 0x000fc60007fbe0ffULL, 0x000000010f3b7824ULL, 0x040fe200010e0633ULL,
0x000000360e347210ULL, 0x000fe20007fde0ffULL, 0x000000010f337824ULL, 0x000fe200028e0635ULL,
0x0ffffff841367812ULL, 0x100fe200078ef806ULL, 0x00000001403e7824ULL, 0x000fe200078e0206ULL,
0x0000003d4600720cULL, 0x080fe20003f46070ULL, 0x000000010f357824ULL, 0x000fe200030e0637ULL,
0x0000003d4800720cULL, 0x000fe20003fa6070ULL, 0x0000000146377824ULL, 0x000fe400078e020dULL,
0x0000001036417824ULL, 0x000fc400078e023fULL, 0x0000010037367825ULL, 0x000fc600078e0030ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038417faeULL, 0x0003e2000e101c48ULL,
0x0000003d4000720cULL, 0x080fe20003f86070ULL, 0x0000001007077824ULL, 0x000fe200078e023fULL,
0x000000360e367210ULL, 0x000fe20007fde0ffULL, 0x000000003a437faeULL, 0x0005e2000d901c48ULL,
0x0000003d4200720cULL, 0x000fe20003f66070ULL, 0x00000001403d7824ULL, 0x100fe200078e020dULL,
0x000000370f377210ULL, 0x000fe200037fe4ffULL, 0x00000001420d7824ULL, 0x000fe400078e020dULL,
0x0000010045387825ULL, 0x002fc800078e0030ULL, 0x000001003d3a7825ULL, 0x004fe200078e0030ULL,
0x000000380e387210ULL, 0x000fc60007fde0ffULL, 0x0000000840417824ULL, 0x000fe400078e00ffULL,
0x000000010f397824ULL, 0x000fe200030e0639ULL, 0x0000003a0e3a7210ULL, 0x000fe20007fde0ffULL,
0x00000001423d7824ULL, 0x040fe200078e0206ULL, 0xfffffff8413e7812ULL, 0x000fe200078ee23eULL,
0x0000000842407824ULL, 0x000fe400078e00ffULL, 0x000001000d307825ULL, 0x000fe200078e0030ULL,
0x0000003f3e437211ULL, 0x000fe400078e20ffULL, 0xfffffff840407812ULL, 0x000fe200078ee23dULL,
0x000000010f3b7824ULL, 0x000fe200030e063bULL, 0x000000300e0e7210ULL, 0x000fe20007fde0ffULL,
0x000000103c0d7824ULL, 0x000fc400078e023fULL, 0x000000100a3d7824ULL, 0x100fe400078e023fULL,
0x0000001008417824ULL, 0x100fe200078e023fULL, 0x00000000320d7faeULL, 0x0003e2000c101c48ULL,
0x00000010403f7824ULL, 0x000fe400078e023fULL, 0x000000010f0f7824ULL, 0x000fe200030e0631ULL,
0x00000000343d7faeULL, 0x0003e8000c901c48ULL, 0x0000000036417faeULL, 0x0003e8000d101c48ULL,
0x0000000038077faeULL, 0x0003e8000e901c48ULL, 0x000000003a437faeULL, 0x0003e8000e101c48ULL,
0x000000000e3f7faeULL, 0x0003e2000d901c48ULL, 0x000005b000007947ULL, 0x000fea0003800000ULL,
0x00002000000a7824ULL, 0x000fe200078e00ffULL, 0x0000000c06377811ULL, 0x040fe200078fe8ffULL,
0x0000001006087824ULL, 0x040fe200078e00ffULL, 0x0000000406337811ULL, 0x000fe200078fe8ffULL,
0x00000080003f7824ULL, 0x000fe200078e00ffULL, 0x000020000a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000137307824ULL, 0x000fe200078e0206ULL, 0x0000007008087812ULL, 0x000fe200078ec0ffULL,
0x0000000833407824ULL, 0x000fe200078e00ffULL, 0x0000000806357811ULL, 0x000fe200078fe8ffULL,
0x00004000070a7824ULL, 0x000fe200078e020aULL, 0x00000003373b7819ULL, 0x000fe200000006ffULL,
0x0000000133077824ULL, 0x100fe200078e0206ULL, 0x00000080083e7812ULL, 0x000fe200078ef83fULL,
0x0000000135087824ULL, 0x040fe200078e0206ULL, 0x0000001006397811ULL, 0x040fe200078fe8ffULL,
0x0000000835317824ULL, 0x000fe200078e00ffULL, 0xfffffff83b447812ULL, 0x000fe200078ee230ULL,
0x0000000133337824ULL, 0x000fe200078e020dULL, 0x00000014063b7811ULL, 0x000fe200078fe8ffULL,
0x0000000839467824ULL, 0x040fe200078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee207ULL,
0x0000000139077824ULL, 0x000fe200078e0206ULL, 0x00000018063d7811ULL, 0x000fe200078fe8ffULL,
0x0000000135357824ULL, 0x000fe200078e020dULL, 0xfffffff831427812ULL, 0x000fe200078ee208ULL,
0x000000013b087824ULL, 0x140fe200078e0206ULL, 0xfffffff846467812ULL, 0x000fe200078ee207ULL,
0x000000083b317824ULL, 0x000fe200078e00ffULL, 0x0000000606077211ULL, 0x080fe200078fe8ffULL,
0x000000013d307824ULL, 0x040fe200078e0206ULL, 0x000140000a4b7810ULL, 0x000fe20007ffe0ffULL,
0x000000083d3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff831487812ULL, 0x000fe200078ee208ULL,
0x0000000137377824ULL, 0x100fe200078e020dULL, 0x0000001c06087811ULL, 0x000fe200078fe8ffULL,
0x0000000139397824ULL, 0x100fe200078e020dULL, 0xfffffff83f4a7812ULL, 0x000fe200078ee230ULL,
0x000000013b3b7824ULL, 0x100fe200078e020dULL, 0x00000007073f7812ULL, 0x000fe200078ec0ffULL,
0x0000000808417824ULL, 0x040fe200078e00ffULL, 0x0000000608307210ULL, 0x040fe20007ffe0ffULL,
0x0000000108077824ULL, 0x100fe200078e020dULL, 0x0000000d06317211ULL, 0x000fe200078fe8ffULL,
0x000000013d3d7824ULL, 0x000fe200078e020dULL, 0x0ffffff83f087812ULL, 0x000fe200078ef806ULL,
0x000000ffff3f7224ULL, 0x000fe200078e00ffULL, 0xfffffff8414c7812ULL, 0x000fe200078ee230ULL,
0x00000010400d7824ULL, 0x000fc400078e024bULL, 0x0000010031307825ULL, 0x000fc800078e003eULL,
0x0000010033327825ULL, 0x000fe200078e003eULL, 0x000000300e307210ULL, 0x000fc60007f1e0ffULL,
0x0000010035347825ULL, 0x000fe200078e003eULL, 0x000000320e327210ULL, 0x000fc60007f3e0ffULL,
0x0000010037367825ULL, 0x000fe200078e003eULL, 0x000000340e347210ULL, 0x000fc60007f5e0ffULL,
0x0000010039387825ULL, 0x000fe200078e003eULL, 0x000000360e367210ULL, 0x000fc60007f7e0ffULL,
0x000001003b3a7825ULL, 0x000fc800078e003eULL, 0x000001003d3c7825ULL, 0x000fc800078e003eULL,
0x00000100073e7825ULL, 0x000fc800078e003eULL, 0x000000010f317824ULL, 0x040fe200000e0631ULL,
0x000000380e387210ULL, 0x040fe20007f1e0ffULL, 0x000000010f337824ULL, 0x040fe200008e0633ULL,
0x0000003a0e3a7210ULL, 0x000fe20007f3e0ffULL, 0x0000001008077824ULL, 0x000fe400078e024bULL,
0x000000010f357824ULL, 0x040fe200010e0635ULL, 0x0000003c0e3c7210ULL, 0x040fe20007f5e0ffULL,
0x000000010f377824ULL, 0x000fe200018e0637ULL, 0x0000003e0e0e7210ULL, 0x000fe20007f7e0ffULL,
0x0000001042417824ULL, 0x100fe200078e024bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030077faeULL, 0x0003e2000b901c48ULL, 0x0000001044437824ULL, 0x000fc400078e024bULL,
0x0000001046457824ULL, 0x000fe200078e024bULL, 0x00000000320d7faeULL, 0x0003e2000b901c48ULL,
0x000000010f397824ULL, 0x040fe400000e0639ULL, 0x0000001048477824ULL, 0x000fe200078e024bULL,
0x0000000034417faeULL, 0x0003e2000b901c48ULL, 0x000000010f3b7824ULL, 0x040fe400008e063bULL,
0x000000104a497824ULL, 0x000fe200078e024bULL, 0x0000004b4c4b7211ULL, 0x000fe200078e20ffULL,
0x000000010f3d7824ULL, 0x040fe200010e063dULL, 0x0000000036437faeULL, 0x0003e2000b901c48ULL,
0x000000010f0f7824ULL, 0x000fc600018e063fULL, 0x0000000038457faeULL, 0x0003e8000b901c48ULL,
0x000000003a477faeULL, 0x0003e8000b901c48ULL, 0x000000003c497faeULL, 0x0003e8000b901c48ULL,
0x000000000e4b7faeULL, 0x0003e4000b901c48ULL, 0x0000000309077812ULL, 0x002fe200078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffff000a7802ULL, 0x000fc40000000f00ULL,
0x000000030700780cULL, 0x000fc80003f05270ULL, 0x0000000172087807ULL, 0x000fca0004000000ULL,
0x0000000108097824ULL, 0x000fca00078e0209ULL, 0x0000006c0900720cULL, 0x000fda0003f06070ULL,
0x00000001690e8824ULL, 0x000fe400078e0209ULL, 0x00000004ff0f8424ULL, 0x000fc800078e00ffULL,
0x000064000e0e8625ULL, 0x000fca00078e000fULL, 0x000000080e0a8981ULL, 0x000322000c1e1900ULL,
0xffffffe06e077812ULL, 0x040fe400078ec0ffULL, 0x000000106e087812ULL, 0x040fe400078ec0ffULL,
0x000000086e0d7812ULL, 0x000fc800078ec0ffULL, 0x000000070d077210ULL, 0x000fe20007ffe008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6080007327f8cULL, 0x0022a4000c80043fULL,
0x00000000000e7805ULL, 0x000fc40000015200ULL, 0x01b60c00070d7984ULL, 0x000ee40000000800ULL,
0x800000000dff7812ULL, 0x00cfe40007804833ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fcc0000015200ULL,
0x000000300e0d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000131307824ULL, 0x000fe200000e0e0fULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3000720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3000720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011430ULL, 0x0000000d08087211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e0630ULL, 0x0000000208087819ULL, 0x000fc8000000120dULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b60c00070d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe40007804833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010066a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff707819ULL, 0x000fe20000011606ULL, 0x00000020005c7824ULL, 0x000fc600078e00ffULL,
0x000000706a6a7812ULL, 0x000fe400078ec0ffULL, 0xffffff805c5c7812ULL, 0x000fe400078ec0ffULL,
0x0000000c70707812ULL, 0x000fc800078ec0ffULL, 0x0000005c70077210ULL, 0x002fca0007ffe06aULL,
0x01b0000007317984ULL, 0x000e680000000800ULL, 0x01b2000007307984ULL, 0x0004e20000000800ULL,
0x0000000c3100720bULL, 0x002fe20003f1d000ULL, 0x00011bf27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0d327812ULL, 0x000fe2000782c0ffULL,
0x0000046000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff087224ULL, 0x000fd400078e000cULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x000000006d00720cULL, 0x000fe40003f05270ULL, 0x0000000c3100720bULL, 0x000fe20003f34000ULL,
0x00011bb27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000077806ULL, 0x000fc400008e0100ULL,
0x00000080000d8824ULL, 0x000fe200078e026aULL, 0x0000000c31087209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x00009910070e7816ULL, 0x000fe200000000ffULL,
0x00000001700d8824ULL, 0x000fca00078e020dULL, 0x01b400080d008388ULL, 0x0003e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000c080c7221ULL, 0x002fe20000010100ULL, 0x000000ff07ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fcc0000410000ULL,
0x0000000c000c7308ULL, 0x000e640000000800ULL, 0x0000000c0b0b7220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011606ULL,
0x00011af27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0c0d7589ULL, 0x0002a400000e0000ULL,
0x0000000d2c2c7220ULL, 0x084fe40000410000ULL, 0x0000000d2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000d28287220ULL, 0x080fe40000410000ULL, 0x0000000d29297220ULL, 0x000fc40000410000ULL,
0x0000000d24247220ULL, 0x080fe40000410000ULL, 0x0000000d25257220ULL, 0x080fe40000410000ULL,
0x0000000d20207220ULL, 0x080fe40000410000ULL, 0x0000000d21217220ULL, 0x080fe40000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe40000410000ULL, 0x0000000d1d1d7220ULL, 0x000fc40000410000ULL,
0x0000000d18187220ULL, 0x080fe40000410000ULL, 0x0000000d19197220ULL, 0x080fe40000410000ULL,
0x0000000d14147220ULL, 0x080fe40000410000ULL, 0x0000000d15157220ULL, 0x080fe40000410000ULL,
0x0000000d10107220ULL, 0x080fe40000410000ULL, 0x0000000d11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0007ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008060d7811ULL, 0x000fe200078ff0ffULL,
0x000119f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0c0d7589ULL, 0x00046400000e0000ULL,
0x0000000d2e2e7220ULL, 0x086fe40000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000d2a2a7220ULL, 0x080fe40000410000ULL, 0x0000000d2b2b7220ULL, 0x080fe40000410000ULL,
0x0000000d26267220ULL, 0x080fe40000410000ULL, 0x0000000d27277220ULL, 0x000fc40000410000ULL,
0x0000000d22227220ULL, 0x080fe40000410000ULL, 0x0000000d23237220ULL, 0x080fe40000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe40000410000ULL, 0x0000000d1f1f7220ULL, 0x080fe40000410000ULL,
0x0000000d1a1a7220ULL, 0x080fe40000410000ULL, 0x0000000d1b1b7220ULL, 0x000fc40000410000ULL,
0x0000000d16167220ULL, 0x080fe40000410000ULL, 0x0000000d17177220ULL, 0x080fe40000410000ULL,
0x0000000d12127220ULL, 0x080fe40000410000ULL, 0x0000000d13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff32ff7812ULL, 0x000fda0007806007ULL,
0x8000000831310221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL,
0x0000003100050308ULL, 0x000e640000000800ULL, 0x0000000530300220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000000b300b7221ULL, 0x008fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000005ff03723eULL, 0x000fe400000000ffULL,
0x00000002ff077819ULL, 0x000fe40000011606ULL, 0x00005410030c7816ULL, 0x000fe20000000003ULL,
0x000118527f007947ULL, 0x000fea000b800000ULL, 0x00001f070c047589ULL, 0x0002a400000e0000ULL,
0x00000008070d7810ULL, 0x000fe20007ffe0ffULL, 0x000118a27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0c037589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010070d7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000cULL,
0x00003160000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0001254000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000018070d7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x000031d0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x000124d000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000200577824ULL, 0x000fe200078e00ffULL, 0x00000007060c7812ULL, 0x00afe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x0000000457077812ULL, 0x000fc400078ec0ffULL,
0x000000080c0d7812ULL, 0x004fe400078ef806ULL, 0x0000000706667211ULL, 0x000fe200078fe0ffULL,
0x0000020000077824ULL, 0x000fe400078e00ffULL, 0x000000080d557824ULL, 0x040fe200078e00ffULL,
0x000000660d667210ULL, 0x000fe40007ffe0ffULL, 0xfffff800070e7812ULL, 0x000fe400078ec0ffULL,
0xfffffff855557812ULL, 0x000fc400078ee266ULL, 0x0000000806077812ULL, 0x000fc600078ec0ffULL,
0x0000001055557824ULL, 0x000fc800078e020eULL, 0x00000004ff327819ULL, 0x000fe20000011606ULL,
0x011000005544783bULL, 0x000e620000000200ULL, 0x0000000c070f7212ULL, 0x040fe200078efcffULL,
0x000059000a0a7a24ULL, 0x010fe200078e02ffULL, 0x00000001ff567819ULL, 0x000fe40000011600ULL,
0x0000001007317812ULL, 0x000fe200078efe0cULL, 0x0000000132307824ULL, 0x000fe200078e020fULL,
0xfffffff857577812ULL, 0x000fe200078ec0ffULL, 0x0000000256077824ULL, 0x000fe200078e026bULL,
0x0000003106647211ULL, 0x000fe200078fe0ffULL, 0x00000004560c7824ULL, 0x000fe200078e0232ULL,
0x0000000630617810ULL, 0x040fe20007ffe0ffULL, 0x000000080f337824ULL, 0x040fe200078e00ffULL,
0x00000002305f7810ULL, 0x040fe20007ffe0ffULL, 0x000000080f327824ULL, 0x000fe200078e00ffULL,
0x00000004305e7810ULL, 0x000fe20007ffe0ffULL, 0x0000200007077824ULL, 0x000fe200078e00ffULL,
0xfffffff833607812ULL, 0x000fe200078ee230ULL, 0x000000080f347824ULL, 0x040fe200078e00ffULL,
0xfffffff832617812ULL, 0x000fe200078ee261ULL, 0x000000080f357824ULL, 0x000fe200078e00ffULL,
0x0001300007307810ULL, 0x000fe20007ffe0ffULL, 0x0000000831327824ULL, 0x040fe200078e00ffULL,
0xfffffff8345f7812ULL, 0x000fe200078ee25fULL, 0x0000000831337824ULL, 0x000fe200078e00ffULL,
0xfffffff8355e7812ULL, 0x000fe200078ee25eULL, 0x0000001061487824ULL, 0x100fe200078e0230ULL,
0x000000020c0c7810ULL, 0x000fe20007ffe00dULL, 0x000000105f507824ULL, 0x100fe200078e0230ULL,
0x000000305e4c7211ULL, 0x000fe200078e20ffULL, 0x0000001060407824ULL, 0x000fe200078e0230ULL,
0x0000000264637810ULL, 0x040fe20007ffe0ffULL, 0x000000080d0d7824ULL, 0x000fe200078e00ffULL,
0x000000004848783bULL, 0x000ea20000004200ULL, 0x0000000831357824ULL, 0x000fe200078e00ffULL,
0x0000000464627810ULL, 0x000fc40007ffe0ffULL, 0xfffffff80d0c7812ULL, 0x000fe200078ee20cULL,
0x000000005050783bULL, 0x000ee20000004200ULL, 0x0000000664657810ULL, 0x000fe20007ffe0ffULL,
0x0000000444440232ULL, 0x082fe20000000000ULL, 0xfffffff832637812ULL, 0x000fe200078ee263ULL,
0x000000004c4c783bULL, 0x000e620000004200ULL, 0x000000100c547824ULL, 0x000fe200078e00ffULL,
0xfffffff835627812ULL, 0x000fe200078ee262ULL, 0x0000000446460232ULL, 0x000fe20000000000ULL,
0x000000004040783bULL, 0x000fe20000004200ULL, 0xfffffff833647812ULL, 0x000fe200078ee264ULL,
0x00000010633c7824ULL, 0x000fe200078e0230ULL, 0x000110000e0e7810ULL, 0x000fe20007ffe054ULL,
0x0000001062387824ULL, 0x100fe200078e0230ULL, 0xfffffff832657812ULL, 0x000fe200078ee265ULL,
0x0000001064347824ULL, 0x100fe200078e0230ULL, 0x0000000345450232ULL, 0x080fe20000000000ULL,
0x000000003c3c783bULL, 0x000fe20000004200ULL, 0x0000000347470232ULL, 0x000fe20000000000ULL,
0x0000001065307824ULL, 0x000fc400078e0230ULL, 0x000000000e0c783bULL, 0x000e680000000200ULL,
0x000000003030783bULL, 0x000e680000004200ULL, 0x000000003838783bULL, 0x000e680000004200ULL,
0x000000003434783bULL, 0x000e620000004200ULL, 0x000000484414723cULL, 0x044f700000001814ULL,
0x000000504424723cULL, 0x048f700000001824ULL, 0x000000524420723cULL, 0x040f700000001820ULL,
0x0000004c441c723cULL, 0x002f62000000181cULL, 0x000000040c0c0232ULL, 0x000fc40000000000ULL,
0x000000040e0e0232ULL, 0x000fe40000000000ULL, 0x000000030d0d0232ULL, 0x080fe40000000000ULL,
0x000000030f0f0232ULL, 0x000fe20000000000ULL, 0x0000004e4418723cULL, 0x040f700000001818ULL,
0x00000040442c723cULL, 0x040f70000000182cULL, 0x000000424428723cULL, 0x040f700000001828ULL,
0x0000004a4410723cULL, 0x000f700000001810ULL, 0x000000300c14723cULL, 0x060f700000001814ULL,
0x0000003c0c24723cULL, 0x040f700000001824ULL, 0x0000003e0c20723cULL, 0x040f700000001820ULL,
0x000000380c1c723cULL, 0x040f70000000181cULL, 0x0000003a0c18723cULL, 0x040f700000001818ULL,
0x000000340c2c723cULL, 0x040f70000000182cULL, 0x000000360c28723cULL, 0x040f700000001828ULL,
0x000000320c30723cULL, 0x000b6e0000001810ULL, 0x00000008020c7824ULL, 0x020fe200078e0256ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fcc0000008000ULL, 0x0000000102107810ULL, 0x000fe20007ffe0ffULL,
0x000000400a0e7824ULL, 0x000fe200078e00ffULL, 0x000000800c0d7811ULL, 0x000fe200078e28ffULL,
0x01b6880057ff7f8cULL, 0x0003e2000c80043fULL, 0x0000005d1000720cULL, 0x000fc40003f06070ULL,
0x00000100000f7802ULL, 0x000fe40000000f00ULL, 0x000000200d0a7812ULL, 0x000fc600078ec0ffULL,
0x000062000e0e7625ULL, 0x000fc800078e000fULL, 0x00000001673d7824ULL, 0x000fe200078e020aULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff407819ULL, 0x102fe20000011606ULL, 0x00002000000c7824ULL, 0x000fe200078e00ffULL,
0x0000000d680a7217ULL, 0x000fe40007800000ULL, 0x0000000440107810ULL, 0x000fe40007ffe0ffULL,
0x000020000c117812ULL, 0x000fe200078ec0ffULL, 0x000000010a0a7824ULL, 0x000fe200078e0a0dULL,
0x0000000840387810ULL, 0x000fe20007ffe0ffULL, 0x00000001103a7824ULL, 0x000fe200078e0206ULL,
0x0000000c40427810ULL, 0x000fe20007ffe0ffULL, 0x0000000810137824ULL, 0x000fe200078e00ffULL,
0x000000200a417817ULL, 0x000fe20003800000ULL, 0x00000080000d7824ULL, 0x000fe200078e00ffULL,
0x0000001440467810ULL, 0x000fe20007ffe0ffULL, 0x0000400056437824ULL, 0x000fe200078e0211ULL,
0xfffffff8133a7812ULL, 0x000fe200078ee23aULL, 0x0000000140137824ULL, 0x000fe200078e023dULL,
0x000000806a0c7812ULL, 0x000fe200078ef80dULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x0000003d10117210ULL, 0x000fe20007ffe0ffULL, 0x00000001383c7824ULL, 0x000fe200078e0206ULL,
0x0000001040447810ULL, 0x000fe20007ffe0ffULL, 0x0000000838357824ULL, 0x000fe200078e00ffULL,
0x000000411000720cULL, 0x080fe20003f86070ULL, 0x0000010013127825ULL, 0x000fe200078e000cULL,
0x000000413800720cULL, 0x000fc40003f66070ULL, 0xfffffff8353c7812ULL, 0x000fe200078ee23cULL,
0x00000001423f7824ULL, 0x000fe200078e0206ULL, 0x000000120e367210ULL, 0x000fe20007f1e0ffULL,
0x0000000842347824ULL, 0x040fe200078e00ffULL, 0x000000414200720cULL, 0x080fe20003f46070ULL,
0x0000010011107825ULL, 0x000fe200078e000cULL, 0x0001300043437810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8343f7812ULL, 0x000fe200078ee23fULL, 0x00000001460a7824ULL, 0x100fe200078e0206ULL,
0x000000100e347210ULL, 0x000fe20007f3e0ffULL, 0x0000000846377824ULL, 0x000fe200078e00ffULL,
0x000000414000720cULL, 0x000fe20003fa6070ULL, 0x00000001443e7824ULL, 0x000fc400078e0206ULL,
0x0000000844357824ULL, 0x000fe200078e00ffULL, 0xfffffff8370a7812ULL, 0x000fe200078ee20aULL,
0x000000010f377824ULL, 0x000fe400000e0613ULL, 0x0000000138137824ULL, 0x000fe200078e023dULL,
0xfffffff8353e7812ULL, 0x000fe200078ee23eULL, 0x000000010f357824ULL, 0x000fe200008e0611ULL,
0x0000000640387210ULL, 0x000fe20007ffe0ffULL, 0x0000000142117824ULL, 0x100fe200078e023dULL,
0x000000414400720cULL, 0x040fe20003f26070ULL, 0x0000000144397824ULL, 0x000fe200078e023dULL,
0x00000007383b7812ULL, 0x000fe200078ec0ffULL, 0x0000010011107825ULL, 0x000fe200078e000cULL,
0x0000001c40447810ULL, 0x000fc40007ffe0ffULL, 0x0ffffff83b427812ULL, 0x000fe200078ef806ULL,
0x0000010039387825ULL, 0x000fe200078e000cULL, 0x000000100e107210ULL, 0x000fc60007fde0ffULL,
0x0000001042457824ULL, 0x000fe200078e0243ULL, 0x0000001840427810ULL, 0x000fe20007ffe0ffULL,
0x00000001463b7824ULL, 0x000fe400078e023dULL, 0x000000010f117824ULL, 0x000fe200030e0611ULL,
0x000000380e387210ULL, 0x000fe20007fde0ffULL, 0x000000103a477824ULL, 0x000fe200078e0243ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036457faeULL, 0x0003e2000e901c48ULL,
0x0000010013127825ULL, 0x100fe200078e000cULL, 0x000000414200720cULL, 0x000fe40003fa6070ULL,
0x0000000034477faeULL, 0x0005e2000e101c48ULL, 0x000001003b3a7825ULL, 0x000fe200078e000cULL,
0x000000120e127210ULL, 0x000fc40007f1e0ffULL, 0x000000414400720cULL, 0x000fe20003f86070ULL,
0x0000000142497824ULL, 0x000fe400078e023dULL, 0x000000010f397824ULL, 0x000fe200030e0639ULL,
0x0000003a0e3a7210ULL, 0x000fe20007fde0ffULL, 0x0000010049367825ULL, 0x002fc800078e000cULL,
0x00000001443d7824ULL, 0x040fe400078e023dULL, 0x0000000144357824ULL, 0x104fe400078e0206ULL,
0x000000010f137824ULL, 0x040fe200000e0613ULL, 0x000000414600720cULL, 0x000fe20003f06070ULL,
0x000000010f3b7824ULL, 0x000fe200030e063bULL, 0x000000360e347210ULL, 0x000fe20007fde0ffULL,
0x0000000844447824ULL, 0x000fe200078e00ffULL, 0x0000000342417819ULL, 0x040fe200000006ffULL,
0x0000000142407824ULL, 0x000fc400078e0206ULL, 0x000001003d0c7825ULL, 0x000fe200078e000cULL,
0xfffffff844367812ULL, 0x000fe400078ee235ULL, 0xfffffff841407812ULL, 0x000fe200078ee240ULL,
0x000000010f357824ULL, 0x000fe200030e0637ULL, 0x0000000c0e0c7210ULL, 0x000fe20007fde0ffULL,
0x000000103c377824ULL, 0x100fe400078e0243ULL, 0x000000103f3f7824ULL, 0x100fe400078e0243ULL,
0x000000103e3d7824ULL, 0x100fe200078e0243ULL, 0x0000000012377faeULL, 0x0003e2000d901c48ULL,
0x000000100a417824ULL, 0x000fc400078e0243ULL, 0x0000001040457824ULL, 0x100fe200078e0243ULL,
0x00000000103f7faeULL, 0x0003e2000d101c48ULL, 0x0000001036437824ULL, 0x000fe400078e0243ULL,
0x000000010f0d7824ULL, 0x000fe200030e060dULL, 0x00000000383d7faeULL, 0x0003e8000c901c48ULL,
0x000000003a417faeULL, 0x0003e8000c101c48ULL, 0x0000000034457faeULL, 0x0003e8000e901c48ULL,
0x000000000c437faeULL, 0x0003e2000e101c48ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x00002000000a7824ULL, 0x002fe200078e00ffULL, 0x0000000c06117811ULL, 0x000fc400078fe8ffULL,
0x0000000406397811ULL, 0x000fe400078fe8ffULL, 0x000020000a0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000111407824ULL, 0x140fe200078e0206ULL, 0x00000008063b7811ULL, 0x000fe200078fe8ffULL,
0x0000000811357824ULL, 0x000fe200078e00ffULL, 0x0000000d56567211ULL, 0x000fe200078e70ffULL,
0x0000000139427824ULL, 0x040fe200078e0206ULL, 0x0000001006137811ULL, 0x040fe200078fe8ffULL,
0x00000008390d7824ULL, 0x000fe200078e00ffULL, 0xfffffff835407812ULL, 0x000fe200078ee240ULL,
0x000000013b417824ULL, 0x040fe200078e0206ULL, 0x0000001406357811ULL, 0x040fe200078fe8ffULL,
0x000000083b0a7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d427812ULL, 0x000fe200078ee242ULL,
0x00000001133f7824ULL, 0x100fe200078e0206ULL, 0x0000001806437811ULL, 0x000fe200078fe8ffULL,
0x00000001353e7824ULL, 0x040fe200078e0206ULL, 0xfffffff80a417812ULL, 0x000fe200078ee241ULL,
0x00000008350d7824ULL, 0x000fe200078e00ffULL, 0x00000006060c7211ULL, 0x040fe200078fe8ffULL,
0x00000008130a7824ULL, 0x000fe200078e00ffULL, 0x0000001c06457811ULL, 0x000fe200078fe8ffULL,
0x0000000139397824ULL, 0x000fe200078e023dULL, 0xfffffff80d3e7812ULL, 0x000fe200078ee23eULL,
0x00000080000d7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a3f7812ULL, 0x000fe200078ee23fULL,
0x00000001430a7824ULL, 0x100fe200078e0206ULL, 0x000000070c477812ULL, 0x000fe200078ec0ffULL,
0x0000000845447824ULL, 0x040fe200078e00ffULL, 0x000000806a0c7812ULL, 0x000fe200078ef80dULL,
0x00000001450d7824ULL, 0x100fe200078e0206ULL, 0x0000000343377819ULL, 0x000fe200000006ffULL,
0x000000013b3b7824ULL, 0x100fe200078e023dULL, 0x0ffffff847477812ULL, 0x000fe200078ef806ULL,
0x0000000111117824ULL, 0x100fe200078e023dULL, 0xfffffff8370a7812ULL, 0x000fe200078ee20aULL,
0x0000000113137824ULL, 0x100fe200078e023dULL, 0x0000003d06377211ULL, 0x000fe200078fe8ffULL,
0x0000000135357824ULL, 0x000fe200078e023dULL, 0xfffffff844447812ULL, 0x000fe200078ee20dULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x00013000564d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000143437824ULL, 0x000fc400078e023dULL, 0x0000010037367825ULL, 0x000fc800078e000cULL,
0x0000010039387825ULL, 0x000fe200078e000cULL, 0x000000360e367210ULL, 0x000fc60007f1e0ffULL,
0x0000000145457824ULL, 0x000fe200078e023dULL, 0x000000380e387210ULL, 0x000fe20007f3e0ffULL,
0x000001003b3a7825ULL, 0x000fc800078e000cULL, 0x00000100113c7825ULL, 0x000fe200078e000cULL,
0x0000003a0e3a7210ULL, 0x000fc60007f5e0ffULL, 0x0000010013107825ULL, 0x000fe200078e000cULL,
0x0000003c0e3c7210ULL, 0x000fc60007f7e0ffULL, 0x0000010035127825ULL, 0x000fc800078e000cULL,
0x0000010043347825ULL, 0x000fe200078e000cULL, 0x0000004d47437211ULL, 0x000fc600078e20ffULL,
0x00000100450c7825ULL, 0x000fc800078e000cULL, 0x000000010f377824ULL, 0x040fe200000e0637ULL,
0x000000100e107210ULL, 0x040fe20007f1e0ffULL, 0x000000010f397824ULL, 0x040fe200008e0639ULL,
0x000000120e127210ULL, 0x040fe20007f3e0ffULL, 0x000000010f3b7824ULL, 0x040fe200010e063bULL,
0x000000340e347210ULL, 0x000fe20007f5e0ffULL, 0x0000001042457824ULL, 0x000fe200078e024dULL,
0x000000110f117210ULL, 0x040fe200007fe4ffULL, 0x000000010f3d7824ULL, 0x000fe200018e063dULL,
0x0000000c0e0c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001041417824ULL, 0x100fe200078e024dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000036437faeULL, 0x0003e2000b901c48ULL,
0x0000001040477824ULL, 0x000fc400078e024dULL, 0x000000103f3f7824ULL, 0x100fe200078e024dULL,
0x0000000038457faeULL, 0x0003e2000b901c48ULL, 0x000000103e497824ULL, 0x000fe400078e024dULL,
0x000000010f137824ULL, 0x040fe200008e0613ULL, 0x000000003a417faeULL, 0x0003e2000b901c48ULL,
0x000000100a4b7824ULL, 0x000fe400078e024dULL, 0x000000010f357824ULL, 0x000fe200010e0635ULL,
0x000000003c477faeULL, 0x0003e2000b901c48ULL, 0x00000010444d7824ULL, 0x000fc400078e024dULL,
0x000000010f0d7824ULL, 0x000fe200018e060dULL, 0x00000000103f7faeULL, 0x0003e8000b901c48ULL,
0x0000000012497faeULL, 0x0003e8000b901c48ULL, 0x00000000344b7faeULL, 0x0003e8000b901c48ULL,
0x000000000c4d7faeULL, 0x0003e4000b901c48ULL, 0x00000003090a7812ULL, 0x000fe200078ec0ffULL,
0xffffffffff4c7424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000030a00780cULL, 0x000fc80003f05270ULL, 0x00000001720a7807ULL, 0x000fca0004000000ULL,
0x0000000109097824ULL, 0x000fca00078e020aULL, 0x0000006c0900720cULL, 0x000fda0003f06070ULL,
0x00000001690c8824ULL, 0x002fe400078e0209ULL, 0x00000004ff0d8424ULL, 0x000fc800078e00ffULL,
0x000064000c0c8625ULL, 0x000fca00078e000dULL, 0x000000080c4c8981ULL, 0x000322000c1e1900ULL,
0xffffffe06e0a7812ULL, 0x040fe400078ec0ffULL, 0x000000106e0f7812ULL, 0x040fe400078ec0ffULL,
0x000000086e0e7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0e127210ULL, 0x000fe20007ffe00fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b62800120c7f8cULL, 0x0022a4000c80043fULL,
0x00000000000e7805ULL, 0x000fc40000015200ULL, 0x01b62c0012117984ULL, 0x000ee40000000800ULL,
0x8000000011ff7812ULL, 0x00cfe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x000000100e137210ULL, 0x000fca0007f1e1ffULL, 0x0000000111117824ULL, 0x000fe200000e0e0fULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc80000011411ULL, 0x000000130a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0611ULL, 0x000000020a0a7819ULL, 0x000fc80000001211ULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b62c0012117984ULL, 0x000ea40000000800ULL, 0x8000000011ff7812ULL, 0x004fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000806a0d7810ULL, 0x000fca0007ffe05cULL,
0x00000001700d7824ULL, 0x000fca00078e020dULL, 0x01b000000d117984ULL, 0x000ea80000000800ULL,
0x01b200000d0c7984ULL, 0x0006620000000800ULL, 0x000000081100720bULL, 0x004fe20003f1d000ULL,
0x000101627f007947ULL, 0x000fd8000b800000ULL, 0x00000000000d7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0d137812ULL, 0x000fe2000782c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff0a7224ULL, 0x000fd400078e0008ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x000000016d0d7810ULL, 0x000fe40007ffe0ffULL,
0x000000081100720bULL, 0x000fe40003f34000ULL, 0x000000000d00720cULL, 0x000fe20003f05270ULL,
0x000101127f007947ULL, 0x000fd4000b800000ULL, 0x00000000000a7806ULL, 0x000fc400008e0100ULL,
0x00000080000f8824ULL, 0x000fe200078e026aULL, 0x00000008110d8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x000099100a0e7816ULL, 0x000fe200000000ffULL,
0x0000000170108824ULL, 0x000fca00078e020fULL, 0x01b4000d10008388ULL, 0x0005e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x00000008110d7209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0aff7812ULL, 0x000fc6000780c0ffULL, 0x000000080d0d7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL, 0x0000000d00107308ULL, 0x000ea40000000800ULL,
0x000000100b0b7220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe20000011606ULL, 0x000100427f007947ULL, 0x000fea000b800000ULL,
0x00001f0d100d7589ULL, 0x0004e400000e0000ULL, 0x0000000d2c2c7220ULL, 0x08cfe40000410000ULL,
0x0000000d2d2d7220ULL, 0x080fe40000410000ULL, 0x0000000d28287220ULL, 0x080fe40000410000ULL,
0x0000000d29297220ULL, 0x000fc40000410000ULL, 0x0000000d24247220ULL, 0x080fe40000410000ULL,
0x0000000d25257220ULL, 0x080fe40000410000ULL, 0x0000000d20207220ULL, 0x080fe40000410000ULL,
0x0000000d21217220ULL, 0x080fe40000410000ULL, 0x0000000d1c1c7220ULL, 0x080fe40000410000ULL,
0x0000000d1d1d7220ULL, 0x000fc40000410000ULL, 0x0000000d18187220ULL, 0x080fe40000410000ULL,
0x0000000d19197220ULL, 0x080fe40000410000ULL, 0x0000000d14147220ULL, 0x080fe40000410000ULL,
0x0000000d15157220ULL, 0x080fe40000410000ULL, 0x0000000d30307220ULL, 0x080fe40000410000ULL,
0x0000000d31317220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000aff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008060d7811ULL, 0x000fe200078ff0ffULL, 0x0000ff427f007947ULL, 0x000fea000b800000ULL,
0x00001f0d100d7589ULL, 0x0004e400000e0000ULL, 0x0000000d2e2e7220ULL, 0x08cfe40000410000ULL,
0x0000000d2f2f7220ULL, 0x080fe40000410000ULL, 0x0000000d2a2a7220ULL, 0x080fe40000410000ULL,
0x0000000d2b2b7220ULL, 0x080fe40000410000ULL, 0x0000000d26267220ULL, 0x080fe40000410000ULL,
0x0000000d27277220ULL, 0x000fc40000410000ULL, 0x0000000d22227220ULL, 0x080fe40000410000ULL,
0x0000000d23237220ULL, 0x080fe40000410000ULL, 0x0000000d1e1e7220ULL, 0x080fe40000410000ULL,
0x0000000d1f1f7220ULL, 0x080fe40000410000ULL, 0x0000000d1a1a7220ULL, 0x080fe40000410000ULL,
0x0000000d1b1b7220ULL, 0x000fc40000410000ULL, 0x0000000d16167220ULL, 0x080fe40000410000ULL,
0x0000000d17177220ULL, 0x080fe40000410000ULL, 0x0000000d32327220ULL, 0x080fe40000410000ULL,
0x0000000d33337220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff13ff7812ULL, 0x000fe4000780600aULL, 0x00000008110a7209ULL, 0x000fd60007810000ULL,
0x8000000a11110221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL,
0x0000001100050308ULL, 0x000ea40000000800ULL, 0x000000050c0c0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x0000000b0c0b7221ULL, 0x002fe20000010000ULL,
0x0000016000008947ULL, 0x000fea0003800000ULL, 0x00000005ff03723eULL, 0x000fe400000000ffULL,
0x00000002ff117819ULL, 0x000fe40000011606ULL, 0x0000541003087816ULL, 0x000fe20000000003ULL,
0x0000fd927f007947ULL, 0x000fea000b800000ULL, 0x00001f1108047589ULL, 0x0002a400000e0000ULL,
0x00000008110d7810ULL, 0x000fe20007ffe0ffULL, 0x0000fde27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d08037589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000010110d7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0008ULL,
0x00004e80000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0001082000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000018110d7810ULL, 0x00cfe20007ffe0ffULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x00000008000e7202ULL, 0x000fe20000000f00ULL,
0xffffffffff347424ULL, 0x000fe200078e00ffULL, 0x00004ef0000f7802ULL, 0x000fc40000000f00ULL,
0x000107b000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x0001400007077810ULL, 0x000fe20007ffe0ffULL,
0x011800005540783bULL, 0x000ee20000000200ULL, 0x000008006d107824ULL, 0x040fe200078e0254ULL,
0x0001b6906d087811ULL, 0x00afe200078e18ffULL, 0x000059004c4c7a24ULL, 0x010fe400078e02ffULL,
0x0000001060587824ULL, 0x000fc400078e0207ULL, 0x000000105f507824ULL, 0x100fe200078e0207ULL,
0x011800001010783bULL, 0x000e620000000200ULL, 0x000000105e487824ULL, 0x100fe400078e0207ULL,
0x0000001061447824ULL, 0x100fe200078e0207ULL, 0x000000005858783bULL, 0x000ee20000004200ULL,
0x00000010643c7824ULL, 0x100fe400078e0207ULL, 0x0000001063387824ULL, 0x100fe200078e0207ULL,
0x000000005050783bULL, 0x000ea20000004200ULL, 0x0000001062347824ULL, 0x000fc400078e0207ULL,
0x00000010650c7824ULL, 0x000fe200078e0207ULL, 0x000000004848783bULL, 0x000ea20000004200ULL,
0x00000001ff077819ULL, 0x000fc60000011600ULL, 0x000000004444783bULL, 0x000ea80000004200ULL,
0x000000003c3c783bULL, 0x000ea80000004200ULL, 0x000000003838783bULL, 0x000ea80000004200ULL,
0x000000003434783bULL, 0x000ea80000004200ULL, 0x000000000c0c783bULL, 0x004ea20000004200ULL,
0x0000000440400232ULL, 0x000fc40000000000ULL, 0x0000000442420232ULL, 0x080fe40000000000ULL,
0x0000000341410232ULL, 0x080fe40000000000ULL, 0x0000000343430232ULL, 0x080fe40000000000ULL,
0x0000000410100232ULL, 0x082fe40000000000ULL, 0x0000000412120232ULL, 0x000fe40000000000ULL,
0x0000000311110232ULL, 0x080fe20000000000ULL, 0x00000058402c723cULL, 0x008f62000000182cULL,
0x0000000313130232ULL, 0x000fce0000000000ULL, 0x0000005a4028723cULL, 0x040f700000001828ULL,
0x000000504024723cULL, 0x040f700000001824ULL, 0x000000524020723cULL, 0x040f700000001820ULL,
0x00000048401c723cULL, 0x040f70000000181cULL, 0x0000004a4018723cULL, 0x040f700000001818ULL,
0x000000444014723cULL, 0x040f700000001814ULL, 0x000000464030723cULL, 0x000b6e0000001830ULL,
0x0000000702417211ULL, 0x020fe200078e18ffULL, 0x0000003c102c723cULL, 0x040b70000000182cULL,
0x0000003e1028723cULL, 0x040b700000001828ULL, 0x000000381024723cULL, 0x040b700000001824ULL,
0x0000003a1020723cULL, 0x040b700000001820ULL, 0x00000034101c723cULL, 0x040b70000000181cULL,
0x000000361018723cULL, 0x040b700000001818ULL, 0x0000000c1014723cULL, 0x044b700000001814ULL,
0x0000000e1010723cULL, 0x000b620000001830ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000000102307810ULL, 0x020fe20007ffe0ffULL, 0x0000000008ff7f8cULL, 0x0003e2000c80043fULL,
0x000000c041417811ULL, 0x000fe200078e28ffULL, 0x00000100ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000005d3000720cULL, 0x000fe20003f06070ULL, 0x000000404c0c7824ULL, 0x000fe200078e00ffULL,
0x00000020410e7812ULL, 0x000fc600078ec0ffULL, 0x000062000c0c7625ULL, 0x000fc800078e000dULL,
0x00000001673d7824ULL, 0x000fe200078e020eULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff407819ULL, 0x102fe40000011606ULL,
0x0000004168087217ULL, 0x000fe40007800000ULL, 0x0000000440307810ULL, 0x040fe40007ffe0ffULL,
0x0000000c40427810ULL, 0x000fe20007ffe0ffULL, 0x0000000108417824ULL, 0x000fe200078e0a41ULL,
0x0000000840387810ULL, 0x000fe20007ffe0ffULL, 0x00000001303a7824ULL, 0x100fe200078e0206ULL,
0x0000001040447810ULL, 0x000fe20007ffe0ffULL, 0x00000008300f7824ULL, 0x000fe200078e00ffULL,
0x0000002041417817ULL, 0x000fe20003800000ULL, 0x0000000142087824ULL, 0x000fe200078e0206ULL,
0x0000001440467810ULL, 0x000fe20007ffe0ffULL, 0x0000000842337824ULL, 0x000fe200078e00ffULL,
0xfffffff80f3a7812ULL, 0x000fe200078ee23aULL, 0x00000080000f7824ULL, 0x000fe200078e00ffULL,
0x000000413000720cULL, 0x000fe20003f86070ULL, 0x00000001383c7824ULL, 0x040fe200078e0206ULL,
0xfffffff833087812ULL, 0x000fe200078ee208ULL, 0x0000000838317824ULL, 0x000fe200078e00ffULL,
0x000000806a0e7812ULL, 0x000fe200078ef80fULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x0000003d40337210ULL, 0x000fe20007ffe0ffULL, 0x00000001443f7824ULL, 0x000fe200078e0206ULL,
0xfffffff8313c7812ULL, 0x000fe200078ee23cULL, 0x0000000130317824ULL, 0x000fe200078e023dULL,
0x000000413800720cULL, 0x000fe20003f66070ULL, 0x0000010033327825ULL, 0x000fe200078e000eULL,
0x0000003d42377210ULL, 0x000fc40007ffe0ffULL, 0x000000414200720cULL, 0x080fe20003f46070ULL,
0x0000010031307825ULL, 0x000fe200078e000eULL, 0x000000320c347210ULL, 0x000fe40007f1e0ffULL,
0x000000414000720cULL, 0x000fe20003fa6070ULL, 0x0000000844367824ULL, 0x000fe200078e00ffULL,
0x000000300c327210ULL, 0x000fe20007f3e0ffULL, 0x00000001463e7824ULL, 0x040fe400078e0206ULL,
0x0000000846357824ULL, 0x000fe200078e00ffULL, 0xfffffff8363f7812ULL, 0x000fe200078ee23fULL,
0x0000200000367824ULL, 0x000fc400078e00ffULL, 0x0000000140307824ULL, 0x000fe200078e0206ULL,
0xfffffff8353e7812ULL, 0x000fe200078ee23eULL, 0x000000010d357824ULL, 0x040fe400000e0633ULL,
0x000000010d337824ULL, 0x000fe200008e0631ULL, 0x00000007303b7812ULL, 0x000fe200078ec0ffULL,
0x0000000138317824ULL, 0x000fe200078e023dULL, 0x0000200036387812ULL, 0x000fe200078ec0ffULL,
0x0000010037367825ULL, 0x000fe200078e000eULL, 0x0ffffff83b427812ULL, 0x000fe400078ef806ULL,
0x000000414400720cULL, 0x000fe20003f26070ULL, 0x0000400007437824ULL, 0x000fe200078e0238ULL,
0x000000360c367210ULL, 0x000fe20007fde0ffULL, 0x0000000144397824ULL, 0x100fe200078e023dULL,
0x0000001c40447810ULL, 0x000fe20007ffe0ffULL, 0x00000001463b7824ULL, 0x000fe200078e023dULL,
0x0001400043437810ULL, 0x000fe20007ffe0ffULL, 0x0000010039387825ULL, 0x000fc800078e000eULL,
0x0000001042477824ULL, 0x000fe200078e0243ULL, 0x0000001840427810ULL, 0x000fe20007ffe0ffULL,
0x000000010d377824ULL, 0x000fe200030e0637ULL, 0x000000380c387210ULL, 0x000fe20007fde0ffULL,
0x0000010031307825ULL, 0x000fe200078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034477faeULL, 0x0003e2000e901c48ULL, 0x000000414200720cULL, 0x000fe40003fa6070ULL,
0x000000103a497824ULL, 0x000fe200078e0243ULL, 0x000000300c307210ULL, 0x000fe20007f1e0ffULL,
0x000001003b3a7825ULL, 0x000fe200078e000eULL, 0x0000000642407210ULL, 0x000fc40007ffe0ffULL,
0x0000000032497faeULL, 0x0005e2000e101c48ULL, 0x0000000142457824ULL, 0x000fe200078e023dULL,
0x000000414400720cULL, 0x000fe20003f86070ULL, 0x000000010d397824ULL, 0x000fe200030e0639ULL,
0x0000003a0c3a7210ULL, 0x000fe20007fde0ffULL, 0x0000010045347825ULL, 0x002fc800078e000eULL,
0x00000001443d7824ULL, 0x000fe400078e023dULL, 0x000000010d317824ULL, 0x040fe200000e0631ULL,
0x000000414600720cULL, 0x000fe20003f06070ULL, 0x0000000144337824ULL, 0x004fe400078e0206ULL,
0x000000010d3b7824ULL, 0x000fe200030e063bULL, 0x000000340c327210ULL, 0x000fe20007fde0ffULL,
0x0000000844447824ULL, 0x000fe400078e00ffULL, 0x0000000842417824ULL, 0x000fc400078e00ffULL,
0x000001003d0e7825ULL, 0x000fe200078e000eULL, 0xfffffff844347812ULL, 0x000fe400078ee233ULL,
0xfffffff841407812ULL, 0x000fe200078ee240ULL, 0x000000010d337824ULL, 0x000fe200030e0635ULL,
0x0000000e0c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000103c357824ULL, 0x100fe400078e0243ULL,
0x00000010083d7824ULL, 0x100fe400078e0243ULL, 0x000000103f3f7824ULL, 0x100fe200078e0243ULL,
0x0000000030357faeULL, 0x0003e2000d901c48ULL, 0x000000103e417824ULL, 0x000fc400078e0243ULL,
0x0000001040457824ULL, 0x100fe200078e0243ULL, 0x00000000363d7faeULL, 0x0003e2000d101c48ULL,
0x0000001034437824ULL, 0x000fe400078e0243ULL, 0x000000010d0d7824ULL, 0x000fe200030e060fULL,
0x00000000383f7faeULL, 0x0003e8000c901c48ULL, 0x000000003a417faeULL, 0x0003e8000c101c48ULL,
0x0000000032457faeULL, 0x0003e8000e901c48ULL, 0x000000000c437faeULL, 0x0003e2000e101c48ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x00000004063b7811ULL, 0x042fe400078fe8ffULL,
0x0000001006337811ULL, 0x000fc400078fe8ffULL, 0x000000063b427210ULL, 0x0c0fe20007ffe0ffULL,
0x000000083b0f7824ULL, 0x000fe200078e00ffULL, 0x0000000c06317811ULL, 0x040fe200078fe8ffULL,
0x00000001333f7824ULL, 0x040fe200078e0206ULL, 0x0000001406357811ULL, 0x040fe200078fe8ffULL,
0x00000008330e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80f427812ULL, 0x000fe200078ee242ULL,
0x0000000131407824ULL, 0x140fe200078e0206ULL, 0x0000000806307811ULL, 0x000fe200078fe8ffULL,
0x00000008310f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80e3f7812ULL, 0x000fe200078ee23fULL,
0x00000001353e7824ULL, 0x040fe200078e0206ULL, 0x00000006060e7211ULL, 0x000fe200078fe8ffULL,
0x0000000835377824ULL, 0x000fe200078e00ffULL, 0xfffffff80f407812ULL, 0x000fe200078ee240ULL,
0x0000000130417824ULL, 0x000fe200078e0206ULL, 0x0000001806437811ULL, 0x000fe200078fe8ffULL,
0x0000000830087824ULL, 0x000fe200078e00ffULL, 0xfffffff8373e7812ULL, 0x000fe200078ee23eULL,
0x0000008000377824ULL, 0x040fe200078e00ffULL, 0x0000000d000f7819ULL, 0x000fe200000006ffULL,
0x0000000843397824ULL, 0x000fe200078e00ffULL, 0x0000001c06457811ULL, 0x000fe200078fe8ffULL,
0x000000013b3b7824ULL, 0x100fe200078e023dULL, 0x000000070e477812ULL, 0x000fe200078ec0ffULL,
0x0000000131317824ULL, 0x000fe200078e023dULL, 0xfffffff808417812ULL, 0x000fe200078ee241ULL,
0x0000000143087824ULL, 0x100fe200078e0206ULL, 0x000020000f0e7812ULL, 0x000fe200078ec0ffULL,
0x00000001300f7824ULL, 0x000fe200078e023dULL, 0x000000806a367812ULL, 0x000fe200078ef837ULL,
0x0000000145307824ULL, 0x000fe200078e0206ULL, 0xfffffff839087812ULL, 0x000fe200078ee208ULL,
0x0000000845377824ULL, 0x000fe200078e00ffULL, 0x0000003d06397211ULL, 0x000fe200078fe8ffULL,
0x0000000133337824ULL, 0x100fe200078e023dULL, 0x0000000e070e7211ULL, 0x000fe200078e70ffULL,
0x0000000135357824ULL, 0x100fe200078e023dULL, 0xfffffff837447812ULL, 0x000fe200078ee230ULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x000140000e497810ULL, 0x000fe20007ffe0ffULL,
0x0000000143437824ULL, 0x000fe200078e023dULL, 0x0ffffff847477812ULL, 0x000fe200078ef806ULL,
0x0000010039387825ULL, 0x000fc800078e0036ULL, 0x0000000145457824ULL, 0x000fe200078e023dULL,
0x000000380c387210ULL, 0x000fe20007f1e0ffULL, 0x000001003b3a7825ULL, 0x000fc800078e0036ULL,
0x000001000f3c7825ULL, 0x000fe200078e0036ULL, 0x0000003a0c3a7210ULL, 0x000fc60007f3e0ffULL,
0x00000100310e7825ULL, 0x100fe200078e0036ULL, 0x0000003c0c3c7210ULL, 0x040fe40007f5e0ffULL,
0x0000003b0d3b7210ULL, 0x000fe20000ffe4ffULL, 0x0000010033307825ULL, 0x000fe200078e0036ULL,
0x0000000e0c0e7210ULL, 0x000fc60007f7e0ffULL, 0x0000010035327825ULL, 0x000fc800078e0036ULL,
0x0000010043347825ULL, 0x000fe200078e0036ULL, 0x000000320c327210ULL, 0x000fc60007f3e0ffULL,
0x0000010045367825ULL, 0x000fc800078e0036ULL, 0x000000010d397824ULL, 0x000fe200000e0639ULL,
0x000000300c307210ULL, 0x040fe20007f1e0ffULL, 0x0000001047477824ULL, 0x000fe400078e0249ULL,
0x000000010d3d7824ULL, 0x040fe200010e063dULL, 0x000000340c347210ULL, 0x000fe20007f5e0ffULL,
0x0000001042437824ULL, 0x000fe200078e0249ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038477faeULL, 0x0003e2000b901c48ULL, 0x000000010d0f7824ULL, 0x000fe200018e060fULL,
0x000000360c0c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001041417824ULL, 0x100fe200078e0249ULL,
0x000000003a437faeULL, 0x0003e2000b901c48ULL, 0x0000001040457824ULL, 0x000fc400078e0249ULL,
0x000000103f3f7824ULL, 0x000fe200078e0249ULL, 0x000000003c417faeULL, 0x0003e2000b901c48ULL,
0x000000010d317824ULL, 0x040fe400000e0631ULL, 0x000000103e4b7824ULL, 0x000fe200078e0249ULL,
0x000000000e457faeULL, 0x0003e2000b901c48ULL, 0x000000010d337824ULL, 0x040fe400008e0633ULL,
0x00000010084d7824ULL, 0x000fe200078e0249ULL, 0x00000000303f7faeULL, 0x0003e2000b901c48ULL,
0x000000010d357824ULL, 0x000fc400010e0635ULL, 0x0000001044497824ULL, 0x000fe200078e0249ULL,
0x00000000324b7faeULL, 0x0003e2000b901c48ULL, 0x000000010d0d7824ULL, 0x000fc600018e0637ULL,
0x00000000344d7faeULL, 0x0003e8000b901c48ULL, 0x000000000c497faeULL, 0x0003e4000b901c48ULL,
0x0000000309087812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000030800780cULL, 0x000fc80003f05270ULL, 0x0000000172087807ULL, 0x000fca0004000000ULL,
0x0000000109097824ULL, 0x000fe400078e0208ULL, 0xffffffffff087424ULL, 0x000fc600078e00ffULL,
0x0000006c0900720cULL, 0x000fda0003f06070ULL, 0x00000001690c8824ULL, 0x002fe400078e0209ULL,
0x00000004ff0d8424ULL, 0x000fc800078e00ffULL, 0x000064000c0c8625ULL, 0x000fca00078e000dULL,
0x000000080c088981ULL, 0x000322000c1e1900ULL, 0x000000106e0e7812ULL, 0x040fe400078ec0ffULL,
0x000000086e0f7812ULL, 0x000fe400078ec0ffULL, 0x0000000e6d0e7211ULL, 0x000fca00078e28ffULL,
0x000000010f327824ULL, 0x000fe200078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01b64800320c7f8cULL, 0x0022a4000c80043fULL, 0x00000000000e7805ULL, 0x000fc40000015200ULL,
0x01b64c0032317984ULL, 0x000ee40000000800ULL, 0x8000000031ff7812ULL, 0x00cfe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000307805ULL, 0x000fcc0000015200ULL, 0x000000300e337210ULL, 0x000fca0007f1e1ffULL,
0x0000000131317824ULL, 0x000fe200000e0e0fULL, 0x003d09003300780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403300780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff307819ULL, 0x000fc80000011431ULL,
0x0000003330307211ULL, 0x000fca00078110ffULL, 0x000000ffff317224ULL, 0x000fca00000e0631ULL,
0x0000000230307819ULL, 0x000fc80000001231ULL, 0x000000300000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01b64c0032317984ULL, 0x000ea40000000800ULL,
0x8000000031ff7812ULL, 0x004fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001006a0d7810ULL, 0x000fca0007ffe05cULL, 0x00000001700d7824ULL, 0x000fca00078e020dULL,
0x01b000000d317984ULL, 0x000ea80000000800ULL, 0x01b200000d307984ULL, 0x0006620000000800ULL,
0x0000000a3100720bULL, 0x004fe20003f1d000ULL, 0x0000e9727f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0d337812ULL, 0x000fe2000782c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff0c7224ULL, 0x000fd400078e000aULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x000000026d0d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000a3100720bULL, 0x000fe40003f34000ULL,
0x000000000d00720cULL, 0x000fe20003f05270ULL, 0x0000e9227f007947ULL, 0x000fd4000b800000ULL,
0x00000000000c7806ULL, 0x000fc400008e0100ULL, 0x00000080000f8824ULL, 0x000fe200078e026aULL,
0x0000000a310d8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x000099100c0e7816ULL, 0x000fe400000000ffULL, 0x0000000f70328210ULL, 0x002fca0007ffe0ffULL,
0x01b4000d32008388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000a310d7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0cff7812ULL, 0x000fc6000780c0ffULL,
0x0000000a0d0d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d00327308ULL, 0x000e640000000800ULL, 0x000000320b0b7220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011606ULL,
0x0000e8527f007947ULL, 0x000fea000b800000ULL, 0x00001f0d320d7589ULL, 0x0002a400000e0000ULL,
0x0000000d2c2c7220ULL, 0x084fe40000410000ULL, 0x0000000d2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000d28287220ULL, 0x080fe40000410000ULL, 0x0000000d29297220ULL, 0x000fc40000410000ULL,
0x0000000d24247220ULL, 0x080fe40000410000ULL, 0x0000000d25257220ULL, 0x080fe40000410000ULL,
0x0000000d20207220ULL, 0x080fe40000410000ULL, 0x0000000d21217220ULL, 0x080fe40000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe40000410000ULL, 0x0000000d1d1d7220ULL, 0x000fc40000410000ULL,
0x0000000d18187220ULL, 0x080fe40000410000ULL, 0x0000000d19197220ULL, 0x080fe40000410000ULL,
0x0000000d14147220ULL, 0x080fe40000410000ULL, 0x0000000d15157220ULL, 0x080fe40000410000ULL,
0x0000000d10107220ULL, 0x080fe40000410000ULL, 0x0000000d11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008060d7811ULL, 0x000fe200078ff0ffULL,
0x0000e7527f007947ULL, 0x000fea000b800000ULL, 0x00001f0d320d7589ULL, 0x0004e400000e0000ULL,
0x0000000d2e2e7220ULL, 0x08cfe40000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000d2a2a7220ULL, 0x080fe40000410000ULL, 0x0000000d2b2b7220ULL, 0x080fe40000410000ULL,
0x0000000d26267220ULL, 0x080fe40000410000ULL, 0x0000000d27277220ULL, 0x000fc40000410000ULL,
0x0000000d22227220ULL, 0x080fe40000410000ULL, 0x0000000d23237220ULL, 0x080fe40000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe40000410000ULL, 0x0000000d1f1f7220ULL, 0x080fe40000410000ULL,
0x0000000d1a1a7220ULL, 0x080fe40000410000ULL, 0x0000000d1b1b7220ULL, 0x000fc40000410000ULL,
0x0000000d16167220ULL, 0x080fe40000410000ULL, 0x0000000d17177220ULL, 0x080fe40000410000ULL,
0x0000000d12127220ULL, 0x080fe40000410000ULL, 0x0000000d13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff33ff7812ULL, 0x000fe4000780600cULL,
0x0000000a310c7209ULL, 0x000fd60007810000ULL, 0x8000000c31310221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL, 0x0000003100050308ULL, 0x000e640000000800ULL,
0x0000000530300220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x0000000b300b7221ULL, 0x002fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000005ff03723eULL, 0x000fe400000000ffULL, 0x00000002ff317819ULL, 0x000fe40000011606ULL,
0x00005410030a7816ULL, 0x000fe20000000003ULL, 0x0000e5a27f007947ULL, 0x000fea000b800000ULL,
0x00001f310a047589ULL, 0x0002a400000e0000ULL, 0x00000008310d7810ULL, 0x000fe20007ffe0ffULL,
0x0000e5f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0a037589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010310d7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0x000068d0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000edd000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000018310d7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000aULL,
0x00006940000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000ed6000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000006b070a7211ULL, 0x00afe200078e08ffULL, 0x012000005548783bULL, 0x000e620000000200ULL,
0x00000007060d7812ULL, 0x004fc600078ec0ffULL, 0x000020000a0a7824ULL, 0x000fe200078e00ffULL,
0x000000080d0e7812ULL, 0x000fe400078ef806ULL, 0x00000002660d7810ULL, 0x000fe40007ffe0ffULL,
0x000130000a0f7810ULL, 0x000fe20007ffe0ffULL, 0x000000080e0e7824ULL, 0x000fc600078e00ffULL,
0x0000000f623c7211ULL, 0x000fe200078e20ffULL, 0x0000001060307824ULL, 0x000fe200078e020fULL,
0xfffffff80e0d7812ULL, 0x000fe200078ee20dULL, 0x000000105f547824ULL, 0x100fe400078e020fULL,
0x000000105e507824ULL, 0x100fe200078e020fULL, 0x000000003c3c783bULL, 0x000fe20000004200ULL,
0x00000010614c7824ULL, 0x100fe400078e020fULL, 0x000000100d587824ULL, 0x000fe200078e00ffULL,
0x000000003030783bULL, 0x000ea20000004200ULL, 0x0000001064447824ULL, 0x100fe200078e020fULL,
0x0001b6986d0d7811ULL, 0x040fe200078e18ffULL, 0x000008006d347824ULL, 0x000fe200078e0258ULL,
0x000000005454783bULL, 0x000ee20000004200ULL, 0x0000001063407824ULL, 0x000fc400078e020fULL,
0x0000001065387824ULL, 0x000fe200078e020fULL, 0x000000005050783bULL, 0x000fe80000004200ULL,
0x000000004c4c783bULL, 0x000fe80000004200ULL, 0x012000003434783bULL, 0x000ee20000000200ULL,
0x0000000448480232ULL, 0x002fc40000000000ULL, 0x000000044a4a0232ULL, 0x080fe20000000000ULL,
0x000000004444783bULL, 0x000e620000004200ULL, 0x0000000349490232ULL, 0x080fe40000000000ULL,
0x000000034b4b0232ULL, 0x000fe20000000000ULL, 0x000000004040783bULL, 0x000e680000004200ULL,
0x000000003838783bULL, 0x000e640000004200ULL, 0x00000030482c723cULL, 0x044f70000000182cULL,
0x000000324828723cULL, 0x040f700000001828ULL, 0x000000544824723cULL, 0x008f620000001824ULL,
0x0000000434340232ULL, 0x000fc40000000000ULL, 0x0000000436360232ULL, 0x000fe40000000000ULL,
0x0000000335350232ULL, 0x080fe40000000000ULL, 0x0000000337370232ULL, 0x000fe20000000000ULL,
0x000000564820723cULL, 0x040f700000001820ULL, 0x00000050481c723cULL, 0x040f70000000181cULL,
0x000000524818723cULL, 0x040f700000001818ULL, 0x0000004c4814723cULL, 0x040f700000001814ULL,
0x0000004e4810723cULL, 0x000f700000001810ULL, 0x00000044342c723cULL, 0x062b70000000182cULL,
0x000000463428723cULL, 0x040b700000001828ULL, 0x000000403424723cULL, 0x040b700000001824ULL,
0x000000423420723cULL, 0x040b700000001820ULL, 0x0000003c341c723cULL, 0x040b70000000181cULL,
0x0000003e3418723cULL, 0x040b700000001818ULL, 0x000000383414723cULL, 0x040b700000001814ULL,
0x0000003a3410723cULL, 0x000b620000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000030002307a10ULL, 0x000fe20007ffe0ffULL, 0x000000000dff7f8cULL, 0x0003e6000c80043fULL,
0x0000005d3000720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00000d4000000947ULL, 0x000fea0003800000ULL, 0x00000001300e7810ULL, 0x002fe20007ffe0ffULL,
0x0000590008087a24ULL, 0x010fe400078e02ffULL, 0x00000100300f7824ULL, 0x000fe200078e026fULL,
0x0000005d0e00720cULL, 0x000fe20003f06070ULL, 0x0000004008307824ULL, 0x000fe400078e00ffULL,
0x00000100ff317424ULL, 0x000fe200078e00ffULL, 0x000000200f087812ULL, 0x000fc600078ec0ffULL,
0x0000620030307625ULL, 0x000fc800078e0031ULL, 0x00000001670d7824ULL, 0x000fe400078e0208ULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff417819ULL, 0x120fe40000011606ULL,
0x0000000f68087217ULL, 0x000fe40007800000ULL, 0x0000000441337810ULL, 0x040fe40007ffe0ffULL,
0x00000008413b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000108427824ULL, 0x000fe200078e0a0fULL,
0x0000000c413d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001333c7824ULL, 0x100fe200078e0206ULL,
0x0000001041437810ULL, 0x000fe20007ffe0ffULL, 0x00000008330f7824ULL, 0x000fe200078e00ffULL,
0x0000002042427817ULL, 0x000fe20003800000ULL, 0x000000013b3e7824ULL, 0x000fe200078e0206ULL,
0x000000063d087210ULL, 0x000fe20007ffe0ffULL, 0x000000083b357824ULL, 0x000fe200078e00ffULL,
0xfffffff80f3c7812ULL, 0x000fe200078ee23cULL, 0x00000080000f7824ULL, 0x000fe200078e00ffULL,
0x000000423300720cULL, 0x0c0fe20003f86070ULL, 0x0000000133337824ULL, 0x000fe200078e020dULL,
0xfffffff8353e7812ULL, 0x000fe200078ee23eULL, 0x000000083d377824ULL, 0x000fe200078e00ffULL,
0x000000806a0e7812ULL, 0x000fe200078ef80fULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x0000001441477810ULL, 0x040fe20007ffe0ffULL, 0x0000000141357824ULL, 0x000fe200078e020dULL,
0xfffffff837087812ULL, 0x000fe200078ee208ULL, 0x0000010033327825ULL, 0x000fe200078e000eULL,
0x000000423b00720cULL, 0x000fc40003f66070ULL, 0x000000423d00720cULL, 0x000fe20003f46070ULL,
0x0000000143407824ULL, 0x000fe200078e0206ULL, 0x0000003230367210ULL, 0x040fe20007f3e0ffULL,
0x0000010035347825ULL, 0x000fe200078e000eULL, 0x000000424100720cULL, 0x040fe40003fa6070ULL,
0x0000001841497810ULL, 0x000fe20007ffe0ffULL, 0x0000000843377824ULL, 0x000fe200078e00ffULL,
0x0000003430387210ULL, 0x000fe20007f1e0ffULL, 0x00000001473f7824ULL, 0x000fe200078e0206ULL,
0x0000001c414b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008473a7824ULL, 0x000fe200078e00ffULL,
0xfffffff837407812ULL, 0x000fe200078ee240ULL, 0x0000000131397824ULL, 0x040fe200000e0635ULL,
0x0000003331377210ULL, 0x000fe20000ffe4ffULL, 0x0000200000337824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3f7812ULL, 0x000fe200078ee23fULL, 0x0000000141327824ULL, 0x000fe200078e0206ULL,
0x000000424300720cULL, 0x000fe20003f26070ULL, 0x000000013b357824ULL, 0x100fe200078e020dULL,
0x00002000333a7812ULL, 0x000fe200078ec0ffULL, 0x000000013d337824ULL, 0x000fe200078e020dULL,
0x00000007323d7812ULL, 0x000fe200078ec0ffULL, 0x0000010035347825ULL, 0x000fc600078e000eULL,
0x0ffffff83d447812ULL, 0x000fe200078ef806ULL, 0x00000001433b7824ULL, 0x000fe200078e020dULL,
0x0000003430347210ULL, 0x000fe20007f1e0ffULL, 0x0000010033327825ULL, 0x000fc800078e000eULL,
0x0000400007437824ULL, 0x000fe200078e023aULL, 0x0000003230327210ULL, 0x000fe20007fde0ffULL,
0x000001003b3a7825ULL, 0x000fc600078e000eULL, 0x0001300043437810ULL, 0x000fe20007ffe0ffULL,
0x00000001473d7824ULL, 0x000fe400078e020dULL, 0x0000000131357824ULL, 0x000fe200000e0635ULL,
0x000000424700720cULL, 0x000fe20003f06070ULL, 0x0000000131337824ULL, 0x040fe200030e0633ULL,
0x0000003a303a7210ULL, 0x000fe20007fde0ffULL, 0x000000103c477824ULL, 0x100fe400078e0243ULL,
0x0000001044457824ULL, 0x000fe200078e0243ULL, 0x0000003b313b7210ULL, 0x000fe200037fe4ffULL,
0x000001003d3c7825ULL, 0x000fc600078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038457faeULL, 0x0003e2000e901c48ULL, 0x0000000149417824ULL, 0x100fe200078e020dULL,
0x0000003c303c7210ULL, 0x000fe20007fde0ffULL, 0x000000014b0d7824ULL, 0x000fe200078e020dULL,
0x0000000036477faeULL, 0x0005e2000e101c48ULL, 0x000000424900720cULL, 0x080fe20003fa6070ULL,
0x000000084b447824ULL, 0x040fe200078e00ffULL, 0x000000424b00720cULL, 0x000fe20003f86070ULL,
0x0000000849427824ULL, 0x000fe400078e00ffULL, 0x00000001313d7824ULL, 0x000fc400030e063dULL,
0x0000010041387825ULL, 0x002fc800078e000eULL, 0x0000000149417824ULL, 0x100fe200078e0206ULL,
0x0000003830367210ULL, 0x004fe20007fde0ffULL, 0x000000014b377824ULL, 0x000fe400078e0206ULL,
0x000001000d0e7825ULL, 0x000fe200078e000eULL, 0xfffffff842387812ULL, 0x000fe400078ee241ULL,
0xfffffff844427812ULL, 0x000fe200078ee237ULL, 0x0000000131377824ULL, 0x000fe200030e0639ULL,
0x0000000e300e7210ULL, 0x000fe20007fde0ffULL, 0x000000103e0d7824ULL, 0x100fe200078e0243ULL,
0x0000004308397211ULL, 0x000fe200078e20ffULL, 0x0000001040417824ULL, 0x000fc400078e0243ULL,
0x000000103f3f7824ULL, 0x100fe200078e0243ULL, 0x00000000340d7faeULL, 0x0003e2000d901c48ULL,
0x0000001038457824ULL, 0x100fe400078e0243ULL, 0x0000001042437824ULL, 0x000fe200078e0243ULL,
0x0000000032397faeULL, 0x0003e2000d101c48ULL, 0x00000001310f7824ULL, 0x000fc600030e060fULL,
0x000000003a417faeULL, 0x0003e8000c901c48ULL, 0x000000003c3f7faeULL, 0x0003e8000c101c48ULL,
0x0000000036457faeULL, 0x0003e8000e901c48ULL, 0x000000000e437faeULL, 0x0003e2000e101c48ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x00000004063b7811ULL, 0x020fe200078fe8ffULL,
0x0000200000327824ULL, 0x000fe200078e00ffULL, 0x00000008063d7811ULL, 0x000fc400078fe8ffULL,
0x0000000c063f7811ULL, 0x040fe200078fe8ffULL, 0x000000013b447824ULL, 0x140fe200078e0206ULL,
0x0000001006337811ULL, 0x040fe200078fe8ffULL, 0x000000083b0f7824ULL, 0x000fe200078e00ffULL,
0x0000001806377811ULL, 0x040fe200078fe8ffULL, 0x000000013d437824ULL, 0x040fe200078e0206ULL,
0x0000001406357811ULL, 0x000fe200078fe8ffULL, 0x000000083d087824ULL, 0x000fe200078e00ffULL,
0xfffffff80f447812ULL, 0x000fe200078ee244ULL, 0x000000013f427824ULL, 0x140fe200078e0206ULL,
0x000000033f0f7819ULL, 0x000fe200000006ffULL, 0x0000000133417824ULL, 0x040fe200078e0206ULL,
0xfffffff808437812ULL, 0x000fe200078ee243ULL, 0x00000008330e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f427812ULL, 0x000fe200078ee242ULL, 0x0000000137087824ULL, 0x140fe200078e0206ULL,
0x0000200032327812ULL, 0x000fe200078ec0ffULL, 0x0000000837457824ULL, 0x000fe200078e00ffULL,
0xfffffff80e417812ULL, 0x000fe200078ee241ULL, 0x00000080000f7824ULL, 0x000fe200078e00ffULL,
0x00000006060e7211ULL, 0x040fe200078fe8ffULL, 0x0000000135407824ULL, 0x000fe200078e0206ULL,
0xfffffff845087812ULL, 0x000fe200078ee208ULL, 0x0000000835397824ULL, 0x000fe200078e00ffULL,
0x0000001c06457811ULL, 0x000fe200078fe8ffULL, 0x000000013b3b7824ULL, 0x100fe200078e020dULL,
0x000000070e477812ULL, 0x000fe200078ec0ffULL, 0x000000013d3d7824ULL, 0x000fe200078e020dULL,
0x000000806a0e7812ULL, 0x000fe200078ef80fULL, 0x00000001450f7824ULL, 0x000fe200078e0206ULL,
0xfffffff839407812ULL, 0x000fe200078ee240ULL, 0x0000000845467824ULL, 0x000fe200078e00ffULL,
0x0000000d06397211ULL, 0x080fe200078fe8ffULL, 0x0000400007327824ULL, 0x000fe200078e0232ULL,
0x0000000d3f3f7210ULL, 0x000fe20007ffe0ffULL, 0x0000000133337824ULL, 0x000fe200078e020dULL,
0xfffffff846467812ULL, 0x000fe200078ee20fULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x0ffffff847477812ULL, 0x000fe200078ef806ULL, 0x0000000135357824ULL, 0x000fc400078e020dULL,
0x0000010039387825ULL, 0x000fc800078e000eULL, 0x000001003b3a7825ULL, 0x000fe200078e000eULL,
0x0000003830387210ULL, 0x000fc60007f1e0ffULL, 0x000001003d3c7825ULL, 0x000fe200078e000eULL,
0x0000003a303a7210ULL, 0x000fc60007f3e0ffULL, 0x000001003f3e7825ULL, 0x000fe200078e000eULL,
0x0000003c303c7210ULL, 0x000fc60007f5e0ffULL, 0x0000000137377824ULL, 0x100fe200078e020dULL,
0x0000003e303e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000145457824ULL, 0x000fe200078e020dULL,
0x00013000320d7810ULL, 0x000fe20007ffe0ffULL, 0x0000010033327825ULL, 0x000fc600078e000eULL,
0x0000000d43437211ULL, 0x000fe200078e20ffULL, 0x0000010035347825ULL, 0x000fc800078e000eULL,
0x0000010037367825ULL, 0x000fc800078e000eULL, 0x00000100450e7825ULL, 0x000fc800078e000eULL,
0x0000000131397824ULL, 0x000fe200000e0639ULL, 0x0000003230327210ULL, 0x040fe20007f1e0ffULL,
0x0000001047477824ULL, 0x000fe400078e020dULL, 0x00000001313b7824ULL, 0x040fe200008e063bULL,
0x0000003430347210ULL, 0x040fe20007f3e0ffULL, 0x00000001313d7824ULL, 0x040fe200010e063dULL,
0x0000003630367210ULL, 0x000fe20007f5e0ffULL, 0x0000001044457824ULL, 0x000fe200078e020dULL,
0x0000003531357210ULL, 0x040fe20000ffe4ffULL, 0x00000001313f7824ULL, 0x000fe200018e063fULL,
0x0000000e300e7210ULL, 0x000fe20007f7e0ffULL, 0x0000001042497824ULL, 0x100fe200078e020dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038477faeULL, 0x0003e2000b901c48ULL,
0x0000001041417824ULL, 0x000fc400078e020dULL, 0x0000000131337824ULL, 0x040fe200000e0633ULL,
0x000000003a457faeULL, 0x0003e2000b901c48ULL, 0x00000010404b7824ULL, 0x100fe400078e020dULL,
0x00000010084d7824ULL, 0x000fe200078e020dULL, 0x000000003c437faeULL, 0x0003e2000b901c48ULL,
0x0000000131377824ULL, 0x040fe400010e0637ULL, 0x00000010460d7824ULL, 0x000fe200078e020dULL,
0x000000003e497faeULL, 0x0003e2000b901c48ULL, 0x00000001310f7824ULL, 0x000fc600018e060fULL,
0x0000000032417faeULL, 0x0003e8000b901c48ULL, 0x00000000344b7faeULL, 0x0003e8000b901c48ULL,
0x00000000364d7faeULL, 0x0003e8000b901c48ULL, 0x000000000e0d7faeULL, 0x0003e4000b901c48ULL,
0x0000000309087812ULL, 0x000fc800078ec0ffULL, 0x000000030800780cULL, 0x000fc80003f05270ULL,
0x0000000172087807ULL, 0x000fca0004000000ULL, 0x0000000109097824ULL, 0x000fe400078e0208ULL,
0xffffffffff087424ULL, 0x000fc600078e00ffULL, 0x0000006c0900720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x00000001690e7824ULL, 0x002fe400078e0209ULL,
0x00000004ff0f7424ULL, 0x000fc800078e00ffULL, 0x000064000e0e7625ULL, 0x000fca00078e000fULL,
0x000000080e087981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x000000106e0e7812ULL, 0x040fe400078ec0ffULL, 0x000000086e0d7812ULL, 0x000fc600078ec0ffULL,
0x000000206d0e7824ULL, 0x000fc800078e020eULL, 0x000000010d347824ULL, 0x020fe200078e020eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b66800340e7f8cULL, 0x0002a4000c80043fULL,
0x0000000000307805ULL, 0x000fc40000015200ULL, 0x01b66c00340d7984ULL, 0x000ee40000000800ULL,
0x800000000dff7812ULL, 0x00cfe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff357224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x0000003230327210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003200780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403200780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc80000011433ULL, 0x000000320d0d7211ULL, 0x000fc800078110ffULL,
0x00000033ff327210ULL, 0x000fc800007fe4ffULL, 0x000000020d0d7819ULL, 0x000fc80000001232ULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000135357810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b66c00340d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001806a0d7810ULL, 0x000fca0007ffe05cULL,
0x00000001700d7824ULL, 0x000fca00078e020dULL, 0x01b000000d317984ULL, 0x000ea80000000800ULL,
0x01b200000d307984ULL, 0x0006620000000800ULL, 0x0000000c3100720bULL, 0x004fe20003f1d000ULL,
0x0000d0e27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000d7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0d337812ULL, 0x000fe2000782c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x000000036d0d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c3100720bULL, 0x000fe40003f34000ULL,
0x000000000d00720cULL, 0x000fe20003f05270ULL, 0x0000d0a27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000327806ULL, 0x000fc400008e0100ULL, 0x00000080000f8824ULL, 0x000fe200078e026aULL,
0x0000000c310d8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x00009910320e7816ULL, 0x000fe200000000ffULL, 0x0000000170708824ULL, 0x000fca00078e020fULL,
0x01b4000d70008388ULL, 0x0005e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000c310d7209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff32ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000c0d0d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d00367308ULL, 0x000ea40000000800ULL, 0x000000360b0b7220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011606ULL,
0x0000cfd27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d360d7589ULL, 0x0004e400000e0000ULL,
0x0000000d2c2c7220ULL, 0x08cfe40000410000ULL, 0x0000000d2d2d7220ULL, 0x080fe40000410000ULL,
0x0000000d28287220ULL, 0x080fe40000410000ULL, 0x0000000d29297220ULL, 0x000fc40000410000ULL,
0x0000000d24247220ULL, 0x080fe40000410000ULL, 0x0000000d25257220ULL, 0x080fe40000410000ULL,
0x0000000d20207220ULL, 0x080fe40000410000ULL, 0x0000000d21217220ULL, 0x080fe40000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe40000410000ULL, 0x0000000d1d1d7220ULL, 0x000fc40000410000ULL,
0x0000000d18187220ULL, 0x080fe40000410000ULL, 0x0000000d19197220ULL, 0x080fe40000410000ULL,
0x0000000d14147220ULL, 0x080fe40000410000ULL, 0x0000000d15157220ULL, 0x080fe40000410000ULL,
0x0000000d10107220ULL, 0x080fe40000410000ULL, 0x0000000d11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0032ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008060d7811ULL, 0x000fe200078ff0ffULL,
0x0000ced27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d360d7589ULL, 0x0004e400000e0000ULL,
0x0000000d2e2e7220ULL, 0x08cfe40000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe40000410000ULL,
0x0000000d2a2a7220ULL, 0x080fe40000410000ULL, 0x0000000d2b2b7220ULL, 0x080fe40000410000ULL,
0x0000000d26267220ULL, 0x080fe40000410000ULL, 0x0000000d27277220ULL, 0x000fc40000410000ULL,
0x0000000d22227220ULL, 0x080fe40000410000ULL, 0x0000000d23237220ULL, 0x080fe40000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe40000410000ULL, 0x0000000d1f1f7220ULL, 0x080fe40000410000ULL,
0x0000000d1a1a7220ULL, 0x080fe40000410000ULL, 0x0000000d1b1b7220ULL, 0x000fc40000410000ULL,
0x0000000d16167220ULL, 0x080fe40000410000ULL, 0x0000000d17177220ULL, 0x080fe40000410000ULL,
0x0000000d12127220ULL, 0x080fe40000410000ULL, 0x0000000d13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff33ff7812ULL, 0x000fe40007806032ULL,
0x0000000c310c7209ULL, 0x000fd60007810000ULL, 0x8000000c31310221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL, 0x0000003100050308ULL, 0x000ea40000000800ULL,
0x0000000530300220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x0000000b300b7221ULL, 0x002fe20000010000ULL, 0x0000016000008947ULL, 0x000fea0003800000ULL,
0x00000005ff03723eULL, 0x000fe400000000ffULL, 0x00000002ff317819ULL, 0x000fe40000011606ULL,
0x0000541003307816ULL, 0x000fe20000000003ULL, 0x0000cd227f007947ULL, 0x000fea000b800000ULL,
0x00001f3130047589ULL, 0x0002a400000e0000ULL, 0x00000008310d7810ULL, 0x000fe20007ffe0ffULL,
0x0000cd727f007947ULL, 0x000fea000b800000ULL, 0x00001f0d30037589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x00000010310d7810ULL, 0x008fe20007ffe0ffULL,
0x0000001fff357424ULL, 0x000fe200078e00ffULL, 0x00000030000e7202ULL, 0x000fe20000000f00ULL,
0xffffffffff347424ULL, 0x000fe200078e00ffULL, 0x000083b0000f7802ULL, 0x000fc40000000f00ULL,
0x0000d2f000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x00000018310d7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0030ULL,
0x00008420000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000d28000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000007060d7812ULL, 0x00cfe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x000000080d0d7812ULL, 0x000fca00078ef806ULL,
0x000000080d0d7824ULL, 0x000fca00078e00ffULL, 0xfffffff80d307812ULL, 0x002fca00078ee266ULL,
0x000000806d307824ULL, 0x000fca00078e0230ULL, 0x0001280030307811ULL, 0x000fca00078e20ffULL,
0x000140000a0a7810ULL, 0x000fe20007ffe0ffULL, 0x000000003030783bULL, 0x000e620000000200ULL,
0x000000036d0d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000a614c7211ULL, 0x000fe200078e20ffULL,
0x0000001060547824ULL, 0x100fe200078e020aULL, 0x0000030002027a10ULL, 0x000fe20007ffe0ffULL,
0x000000105f347824ULL, 0x100fe400078e020aULL, 0x000000105e507824ULL, 0x000fe200078e020aULL,
0x000000004c4c783bULL, 0x000fe20000004200ULL, 0x000008000d387824ULL, 0x000fc400078e0258ULL,
0x0000001064487824ULL, 0x100fe200078e020aULL, 0x000000005454783bULL, 0x000ea20000004200ULL,
0x0000001063447824ULL, 0x100fe400078e020aULL, 0x0000001062407824ULL, 0x100fe200078e020aULL,
0x000000003434783bULL, 0x000fe20000004200ULL, 0x00000010653c7824ULL, 0x000fe200078e020aULL,
0x0001b6a06d0a7811ULL, 0x000fe400078e18ffULL, 0x000000005050783bULL, 0x000fe80000004200ULL,
0x011000003838783bULL, 0x000ee80000000200ULL, 0x000000004848783bULL, 0x000ee80000004200ULL,
0x000000004444783bULL, 0x000ee80000004200ULL, 0x000000004040783bULL, 0x000ee20000004200ULL,
0x0000000430300232ULL, 0x002fc60000000000ULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0x0000000432320232ULL, 0x000fe40000000000ULL, 0x0000000331310232ULL, 0x080fe40000000000ULL,
0x0000000333330232ULL, 0x000fce0000000000ULL, 0x00000054302c723cULL, 0x044f70000000182cULL,
0x000000563028723cULL, 0x000f620000001828ULL, 0x0000000438380232ULL, 0x088fe40000000000ULL,
0x000000043a3a0232ULL, 0x000fca0000000000ULL, 0x000000343024723cULL, 0x000f620000001824ULL,
0x0000000339390232ULL, 0x080fe40000000000ULL, 0x000000033b3b0232ULL, 0x000fca0000000000ULL,
0x000000363020723cULL, 0x040f700000001820ULL, 0x00000050301c723cULL, 0x040f70000000181cULL,
0x000000523018723cULL, 0x040f700000001818ULL, 0x0000004c3014723cULL, 0x040f700000001814ULL,
0x0000004e3010723cULL, 0x000f700000001810ULL, 0x00000048382c723cULL, 0x060b70000000182cULL,
0x0000004a3828723cULL, 0x040b700000001828ULL, 0x000000443824723cULL, 0x040b700000001824ULL,
0x000000463820723cULL, 0x040b700000001820ULL, 0x00000040381c723cULL, 0x040b70000000181cULL,
0x000000423818723cULL, 0x040b700000001818ULL, 0x0000003c3814723cULL, 0x042b700000001814ULL,
0x0000003e3810723cULL, 0x000b620000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000005d0200720cULL, 0x000fe20003f06070ULL, 0x000000000aff7f8cULL, 0x0003d8000c80043fULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff924000007947ULL, 0x000fea000383ffffULL,
0x0000000000027919ULL, 0x002e620000002500ULL, 0x000000ffff327224ULL, 0x020fe200078e0012ULL,
0x0000001600307202ULL, 0x000fe20000000f00ULL, 0x000000ffff127224ULL, 0x000fe400078e0011ULL,
0x000000ffff337224ULL, 0x000fe400078e0013ULL, 0x000000ffff117224ULL, 0x000fe400078e0010ULL,
0x000000ffff317224ULL, 0x000fe200078e0017ULL, 0x0000005d0200720cULL, 0x002fda0003f06070ULL,
0x0000032000000947ULL, 0x000fea0003800000ULL, 0x018000000b037810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000003037812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0300780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000892000087802ULL, 0x010fc40000000f00ULL, 0x0000cbd000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000b00047308ULL, 0x000e640000001000ULL,
0xbf80000004037423ULL, 0x002fc8000000000bULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000304037223ULL, 0x000fc40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x00000002ff047819ULL, 0x002fe40000011605ULL,
0x0000000805067811ULL, 0x000fc800078ff0ffULL, 0x00001f0403047589ULL, 0x00ce6800000e0000ULL,
0x00001f0603057589ULL, 0x000ea200000e0000ULL, 0x0000002c042c7220ULL, 0x042fe40000410000ULL,
0x0000002d042d7220ULL, 0x040fe40000410000ULL, 0x0000002804287220ULL, 0x040fe40000410000ULL,
0x0000002904297220ULL, 0x000fc40000410000ULL, 0x0000002404247220ULL, 0x040fe40000410000ULL,
0x0000002504257220ULL, 0x040fe40000410000ULL, 0x0000002004207220ULL, 0x040fe40000410000ULL,
0x0000002104217220ULL, 0x040fe40000410000ULL, 0x0000001c041c7220ULL, 0x040fe40000410000ULL,
0x0000001d041d7220ULL, 0x000fc40000410000ULL, 0x0000001804187220ULL, 0x040fe40000410000ULL,
0x0000001904197220ULL, 0x040fe40000410000ULL, 0x0000001404147220ULL, 0x040fe40000410000ULL,
0x0000001504157220ULL, 0x040fe40000410000ULL, 0x0000001104117220ULL, 0x040fe40000410000ULL,
0x0000001204127220ULL, 0x000fc40000410000ULL, 0x0000002e052e7220ULL, 0x044fe40000410000ULL,
0x0000002f052f7220ULL, 0x040fe40000410000ULL, 0x0000002a052a7220ULL, 0x040fe40000410000ULL,
0x0000002b052b7220ULL, 0x040fe40000410000ULL, 0x0000002605267220ULL, 0x040fe40000410000ULL,
0x0000002705277220ULL, 0x000fc40000410000ULL, 0x0000002205227220ULL, 0x040fe40000410000ULL,
0x0000002305237220ULL, 0x040fe40000410000ULL, 0x0000001e051e7220ULL, 0x040fe40000410000ULL,
0x0000001f051f7220ULL, 0x040fe40000410000ULL, 0x0000001a051a7220ULL, 0x040fe40000410000ULL,
0x0000001b051b7220ULL, 0x000fc40000410000ULL, 0x0000003005307220ULL, 0x040fe40000410000ULL,
0x0000003105317220ULL, 0x040fe40000410000ULL, 0x0000003205327220ULL, 0x040fe40000410000ULL,
0x0000003305337220ULL, 0x000fc40000410000ULL, 0x0000000000067919ULL, 0x000e620000000000ULL,
0x00000020210d723eULL, 0x000fe400000000ffULL, 0x0000001c1d0e723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000001e1f16723eULL, 0x000fc400000000ffULL,
0x0000001a1b17723eULL, 0x000fe400000000ffULL, 0x00000024250a723eULL, 0x000fe400000000ffULL,
0x000000141510723eULL, 0x000fe400000000ffULL, 0x000000262714723eULL, 0x000fe400000000ffULL,
0x000000222315723eULL, 0x000fe400000000ffULL, 0x0000002a2b13723eULL, 0x000fc400000000ffULL,
0x00000002ff217819ULL, 0x102fe20000011606ULL, 0x000000016f237824ULL, 0x000fe200078e0206ULL,
0x00000008062a7811ULL, 0x000fe400078ff0ffULL, 0x0000000121047810ULL, 0x040fe20007ffe0ffULL,
0x0000000821097824ULL, 0x040fe200078e00ffULL, 0x00000006211a7810ULL, 0x040fe20007ffe0ffULL,
0x00000008211d7824ULL, 0x040fe200078e00ffULL, 0x0000000221057810ULL, 0x040fe20007ffe0ffULL,
0x00000008211e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8091c7812ULL, 0x000fe200078ee204ULL,
0x00000008211b7824ULL, 0x040fe200078e00ffULL, 0x0000000321047810ULL, 0x040fe20007ffe0ffULL,
0x0000000821247824ULL, 0x040fe200078e00ffULL, 0x0000000521097810ULL, 0x040fe20007ffe0ffULL,
0x0000000821227824ULL, 0x000fe200078e00ffULL, 0xfffffff81d267812ULL, 0x000fe200078ee21aULL,
0x00000008211a7824ULL, 0x040fe200078e00ffULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee205ULL,
0x000000082a1f7824ULL, 0x000fe200078e00ffULL, 0x0000000421057810ULL, 0x000fc40007ffe0ffULL,
0xfffffff81b207812ULL, 0x000fe200078ee204ULL, 0x000010006b047824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee209ULL, 0x0000080007097824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee205ULL, 0x00000004061b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee221ULL, 0x0000000104057824ULL, 0x000fe200078e0209ULL,
0x000000282908723eULL, 0x010fe400000000ffULL, 0xffffffff211d7810ULL, 0x040fe20007ffe0ffULL,
0x000000101a1a7824ULL, 0x100fe200078e0205ULL, 0x0000000321287819ULL, 0x000fe200000006ffULL,
0x000000101c1c7824ULL, 0x100fe200078e0205ULL, 0x0000000c1b1b7812ULL, 0x000fe200078ec0ffULL,
0x000000101e1e7824ULL, 0x000fe200078e0205ULL, 0xfffffff828287812ULL, 0x000fe200078ee21dULL,
0x0000001020207824ULL, 0x100fe200078e0205ULL, 0xfffffff81f2a7812ULL, 0x000fe200078ee22aULL,
0x0000001022227824ULL, 0x000fe200078e0205ULL, 0x0000002c2d03723eULL, 0x000fe200000000ffULL,
0x000000011a1a7824ULL, 0x000fe200078e021bULL, 0x0000000528287211ULL, 0x000fe200078e20ffULL,
0x0000001024247824ULL, 0x100fe200078e0205ULL, 0x00000018190f723eULL, 0x000fe200000000ffULL,
0x000000011b1c7824ULL, 0x040fe200078e021cULL, 0x000000031a007388ULL, 0x0003e20000000800ULL,
0x0000001026267824ULL, 0x100fe200078e0205ULL, 0x000000111211723eULL, 0x000fe200000000ffULL,
0x000000011b1d7824ULL, 0x040fe200078e021eULL, 0x000000081c007388ULL, 0x000fe20000000800ULL,
0x000000011b207824ULL, 0x000fe200078e0220ULL, 0x0000002e2f12723eULL, 0x000fe200000000ffULL,
0x000000102a2a7824ULL, 0x000fe200078e0205ULL, 0x0000000a1d007388ULL, 0x000fe20000000800ULL,
0x000000011b1f7824ULL, 0x000fe200078e0222ULL, 0x000000303118723eULL, 0x000fe200000000ffULL,
0x000000011b247824ULL, 0x040fe200078e0224ULL, 0x0000000d20007388ULL, 0x000fe20000000800ULL,
0x000000011b217824ULL, 0x000fe200078e0226ULL, 0x000000323319723eULL, 0x000fe200000000ffULL,
0x000000011b287824ULL, 0x040fe200078e0228ULL, 0x0000000e1f007388ULL, 0x000fe20000000800ULL,
0x000000011b1b7824ULL, 0x000fe200078e022aULL, 0x00000004231a7211ULL, 0x002fc400078e20ffULL,
0x0000000f24007388ULL, 0x000fe80000000800ULL, 0x0000001021007388ULL, 0x000fe80000000800ULL,
0x0000001128007388ULL, 0x000fe80000000800ULL, 0x000000121b007388ULL, 0x000fe80000000800ULL,
0x000400131c007388ULL, 0x000fe80000000800ULL, 0x000400141d007388ULL, 0x000fe80000000800ULL,
0x0004001520007388ULL, 0x0003e80000000800ULL, 0x000400161f007388ULL, 0x000fe80000000800ULL,
0x0004001724007388ULL, 0x000fe20000000800ULL, 0x00000300ff207624ULL, 0x002fc600078e00ffULL,
0x0004001821007388ULL, 0x000fe40000000800ULL, 0x000000012000780cULL, 0x000fe40003f05270ULL,
0x0004001928007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000001a2c7984ULL, 0x000e680000000c00ULL, 0x000400001a307984ULL, 0x000ea80000000c00ULL,
0x000800001a107984ULL, 0x000ee80000000c00ULL, 0x000c00001a347984ULL, 0x000ee20000000c00ULL,
0x200000ff2f2f7230ULL, 0x002fc40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fe40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x200000ff33337230ULL, 0x004fe40000000000ULL, 0x200000ff32327230ULL, 0x000fe40000000000ULL,
0x200000ff31317230ULL, 0x000fc40000000000ULL, 0x200000ff30307230ULL, 0x000fe40000000000ULL,
0x000000132f2f7230ULL, 0x008fe40000000000ULL, 0x000000122e2e7230ULL, 0x000fe40000000000ULL,
0x000000112d2d7230ULL, 0x000fe40000000000ULL, 0x000000102c2c7230ULL, 0x000fe40000000000ULL,
0x0000003733337230ULL, 0x000fc40000000000ULL, 0x0000003632327230ULL, 0x000fe20000000000ULL,
0x0000002c1a007388ULL, 0x000fe20000000c00ULL, 0x0000003531317230ULL, 0x000fe40000000000ULL,
0x0000003430307230ULL, 0x000fca0000000000ULL, 0x000400301a007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00002a6000008947ULL, 0x000fea0003800000ULL,
0x00000400ff037624ULL, 0x000fe200078e00ffULL, 0x00000000001e7919ULL, 0x000e620000002600ULL,
0x00000040231b7810ULL, 0x000fc40007ffe0ffULL, 0x00006a0003037a24ULL, 0x000fe200078e02ffULL,
0x00000000000f7919ULL, 0x000e680000002700ULL, 0x0000000f030d7811ULL, 0x040fe200078e10ffULL,
0x0000030003037a24ULL, 0x000fe200078e02ffULL, 0x000000001a107984ULL, 0x0004e40000000c00ULL,
0xfffffff00d0d7812ULL, 0x000fe400078ec0ffULL, 0x000400001a147984ULL, 0x0004a60000000c00ULL,
0x00000080030a7824ULL, 0x000fc800078e020dULL, 0x0000008003037824ULL, 0x000fca00078e020aULL,
0x0000007f03037810ULL, 0x000fe20007ffe0ffULL, 0x000004000f1e7a24ULL, 0x002fc600078e021eULL,
0xffffff8003037812ULL, 0x000fe200078ec0ffULL, 0x000003001e087a24ULL, 0x000fc600078e02ffULL,
0x00006e00030f7a10ULL, 0x000fe20007f1e0ffULL, 0x0000000108027824ULL, 0x000fca00078e0202ULL,
0x0000000f020e7211ULL, 0x000fe200078260ffULL, 0x00006f00ff0f7624ULL, 0x000fe200000e06ffULL,
0x0000000107ff7812ULL, 0x000fc8000780f800ULL, 0x0000000f020f7211ULL, 0x000fe400008f64ffULL,
0x00006e000d1f7a10ULL, 0x000fc60007f3e0ffULL, 0x000008006b0e7825ULL, 0x000fc800078e000eULL,
0x00006f00ff217624ULL, 0x000fe400008e06ffULL, 0x0000001023187825ULL, 0x000fc800078e000eULL,
0x000000101b0e7825ULL, 0x000fe200078e000eULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x00000010061a7824ULL, 0x00cfe200078e00ffULL, 0x00000001ff1c7819ULL, 0x000fe20000011606ULL,
0x00000080021b7824ULL, 0x000fe200078e00ffULL, 0x00000019ff027819ULL, 0x000fe40000011602ULL,
0x000000701a1a7812ULL, 0x000fe400078ec0ffULL, 0x0000000c1c1d7812ULL, 0x000fe400078ec0ffULL,
0x00006e001b1c7a10ULL, 0x000fc40007ebe00aULL, 0x0000001f1a1b7210ULL, 0x000fe40007a3e01bULL,
0x0000001c1d1c7210ULL, 0x040fe40007c7e01aULL, 0x00006f0002227a10ULL, 0x000fe40002fec4ffULL,
0x0000001b1d1a7210ULL, 0x000fe40007fbe0ffULL, 0x00000021ff027210ULL, 0x000fe40000fe4402ULL,
0x00000022ff1d7210ULL, 0x000fc60001fe84ffULL, 0x000000ffff1b7224ULL, 0x000fca00028e0602ULL,
0x0000000c1a007986ULL, 0x0003e8000c101908ULL, 0x0000000b1c007986ULL, 0x0003e4000c101908ULL,
0x000000ff0600720cULL, 0x00cfe20000705670ULL, 0x0000001018007986ULL, 0x000fe2000c101d08ULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000140e007986ULL, 0x000fe8000c101d08ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004000f7802ULL, 0x000fe40000000f00ULL, 0xffffffff200b7810ULL, 0x002fc60007ffe0ffULL,
0x00006e001e0e7625ULL, 0x000fe200078e000fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x0000000b0e0e79a8ULL, 0x000ea400099ee1c8ULL, 0x0000000b0e00720cULL, 0x004fc80003f05270ULL,
0x00000001ff027807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000002ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff027984ULL, 0x002e640000000000ULL,
0x000000ff0200720cULL, 0x002fda0003f05270ULL, 0x000025e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001006007824ULL, 0x000fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fe40000011606ULL,
0x0000001f080e7211ULL, 0x000fe400078038ffULL, 0x00000070000f7812ULL, 0x000fe400078ec0ffULL,
0x0000000c02027812ULL, 0x000fe400078ec0ffULL, 0x0000002108007211ULL, 0x000fe400000f3cffULL,
0x0000000e020e7210ULL, 0x000fc8000791e00fULL, 0x00000000ff0f7210ULL, 0x000fca00007e24ffULL,
0x000000080e007981ULL, 0x000328000c1e1900ULL, 0x000080080e0b7981ULL, 0x000322000c1e1900ULL,
0x000000022000780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x000100080e117981ULL, 0x002322000c1e1900ULL, 0x000000042000780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x000180080e137981ULL, 0x002322000c1e1900ULL,
0x000000042000780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x000200080e157981ULL, 0x002322000c1e1900ULL, 0x000000062000780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x000280080e177981ULL, 0x002322000c1e1900ULL,
0x000000062000780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000082000780cULL, 0x002fe20003f06070ULL, 0x000300080e197981ULL, 0x000318000c1e1900ULL,
0x000380080e1b0981ULL, 0x000324000c1e1900ULL, 0x0000000720027810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff027819ULL, 0x000fc80000011602ULL, 0x000000ff0200720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x0000000d081f7211ULL, 0x040fe200078038ffULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1d7224ULL, 0x010fe200078e0000ULL, 0x00006e001f1f7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff080c7211ULL, 0x000fe400000f3cffULL, 0x000007801f1f7810ULL, 0x000fc80007f5e0ffULL,
0x00006f00ff0c7a10ULL, 0x000fc400017e240cULL, 0x0000030010007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000402007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x00000008100e7810ULL, 0x040fe40007ffe0ffULL,
0x00000001100f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001d00007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010060e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011606ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060cULL, 0xfffc80080e1d7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x00000009100e7810ULL, 0x042fe40007ffe0ffULL,
0x00000002100f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000000b00007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010060b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0e7819ULL, 0x000fc80000011606ULL, 0x000000700b0b7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0b0e7812ULL, 0x000fc800078ef80eULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060cULL, 0xfffd00080e0b7981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a100e7810ULL, 0x042fe40007ffe0ffULL,
0x00000003100f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001100007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010060e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011606ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060cULL, 0xfffd80080e117981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b100e7810ULL, 0x042fe40007ffe0ffULL,
0x00000004100f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001300007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010060e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011606ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fc80007f3e0ffULL,
0x0000000cff0f7210ULL, 0x000fca0000ffe4ffULL, 0xfffe00080e137981ULL, 0x000328000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c100e7810ULL, 0x042fe40007ffe0ffULL,
0x00000005100f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001500007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010060e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011606ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060cULL, 0xfffe80080e157981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d100e7810ULL, 0x042fe40007ffe0ffULL,
0x00000006100f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001700007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010060e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011606ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060cULL, 0xffff00080e177981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e100e7810ULL, 0x042fe40007ffe0ffULL,
0x00000007100f7810ULL, 0x000fe40007ffe0ffULL, 0x000003000e007a0cULL, 0x000fe40003f26070ULL,
0x000003000f007a0cULL, 0x000fe40003f46070ULL, 0x0000001900007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010060e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011606ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060cULL, 0xffff80080e197981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f100e7810ULL, 0x002fe40007ffe0ffULL,
0x0000001b00007209ULL, 0x000fe40007810000ULL, 0x000003000e007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010060e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fc80000011606ULL, 0x000000700e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0e0e7812ULL, 0x000fc800078ef80fULL, 0x0000000e1f0e7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0f7224ULL, 0x000fca00008e060cULL, 0x000000080e1b7981ULL, 0x000326000c1e1900ULL,
0x000004001f1f7810ULL, 0x000fe40007f3e0ffULL, 0x0000000810107810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e060cULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000067919ULL, 0x000ea40000000000ULL, 0x0000001006027824ULL, 0x004fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x010fc80000011606ULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0b7812ULL, 0x000fc800078ec0ffULL, 0x0000000b020b7210ULL, 0x000fca0007ffe0ffULL,
0x000000000b007388ULL, 0x0005e40000000800ULL, 0x000000070600780cULL, 0x040fe20003f04070ULL,
0x0000000107197824ULL, 0x000fe200078e0208ULL, 0x00006e0003027a10ULL, 0x000fe20007f3e0ffULL,
0x000008006b007824ULL, 0x004fe200078e00ffULL, 0x00000001070b7812ULL, 0x040fe200078ec0ffULL,
0x0000200007147824ULL, 0x040fe200078e0204ULL, 0x0000002006137810ULL, 0x040fe20007ffe0ffULL,
0x00006f00ff037624ULL, 0x000fe200008e06ffULL, 0x0000004006157810ULL, 0x040fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002070c8824ULL, 0x140fe200078e026bULL,
0x00000060061b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000207108824ULL, 0x000fe200078e026bULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00001000190e7825ULL, 0x002fe200078e0002ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000020c1d8824ULL, 0x100fe200078e020bULL,
0x000000000e0e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000210218824ULL, 0x000fe200078e020bULL,
0x00000800090b7812ULL, 0x000fe200078ec0ffULL, 0x000000081d238824ULL, 0x100fe200078e0206ULL,
0x00000001ff0c7819ULL, 0x100fe20000011606ULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x0000000b14117210ULL, 0x000fe20007ffe0ffULL, 0x0000000821218824ULL, 0x000fe200078e0206ULL,
0x00006e000a097a10ULL, 0x000fe20007f3e0ffULL, 0x00000010060a7824ULL, 0x000fe200078e00ffULL,
0x0000000c0c0b7812ULL, 0x000fe200078ec0ffULL, 0x00000010061f7824ULL, 0x000fe200078e0211ULL,
0x0000458023238811ULL, 0x000fe200078e20ffULL, 0x0000001013107825ULL, 0x100fe200078e000eULL,
0x000000700a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000418021258811ULL, 0x000fe200078e20ffULL, 0x0000001015127825ULL, 0x000fe200078e000eULL,
0x00006e000d157a10ULL, 0x000fe20007f5e0ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x00006f00ff167624ULL, 0x000fe200008e06ffULL,
0x00000009190c8211ULL, 0x040fe200078238ffULL, 0x00006f00ff187624ULL, 0x000fe200010e06ffULL,
0x00000015191c8211ULL, 0x040fe200078438ffULL, 0x000000010a177824ULL, 0x000fe200078e020bULL,
0x00000016190d8211ULL, 0x000fe200008f3cffULL, 0x000000101b1a7825ULL, 0x100fe200078e000eULL,
0x0000030007007a0cULL, 0x000fe20003f26070ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x00000018191d8211ULL, 0x000fe200010f3cffULL, 0x00000010060e7825ULL, 0x040fe200078e000eULL,
0x0000000017177984ULL, 0x000e620000000800ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000010060c8825ULL, 0x000fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000e1f7faeULL, 0x0005e6000b901c48ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x00380000101f7faeULL, 0x0007e2000b901c48ULL,
0x000000ffff387224ULL, 0x000fc400078e00ffULL, 0x000000ffff3a7224ULL, 0x000fe200078e00ffULL,
0x00580000121f7faeULL, 0x0007e2000b901c48ULL, 0x00000010060e8825ULL, 0x004fc600078e001cULL,
0x007800001a1f7faeULL, 0x0007e2000b901c48ULL, 0x00000000001c7805ULL, 0x000fc6000001ff00ULL,
0x000000000c238faeULL, 0x0005e8000b901c48ULL, 0x000000000e258faeULL, 0x0009e8000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000001e7805ULL, 0x008fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x004fe2000001ff00ULL,
0x0000000000247805ULL, 0x010fe2000001ff00ULL, 0x00000c6000001947ULL, 0x000fea0003800000ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x0000000700397202ULL, 0x000fc80000000f00ULL,
0x00000001390d7810ULL, 0x000fc80007ffe0ffULL, 0x000003000d007a0cULL, 0x000fda0003f06070ULL,
0x0000028000000947ULL, 0x000fea0003800000ULL, 0x000000070600780cULL, 0x000fe20003f44070ULL,
0x0000000108417824ULL, 0x000fe200078e020dULL, 0x000000010d0c7812ULL, 0x000fe400078ec0ffULL,
0x0000002006117810ULL, 0x040fe20007ffe0ffULL, 0x00001000410a7825ULL, 0x000fe200078e0002ULL,
0x0000004006137810ULL, 0x040fe40007ffe0ffULL, 0x0000006006437810ULL, 0x000fe40007ffe0ffULL,
0x000000000a0e7210ULL, 0x000fe20007f1e0ffULL, 0x000008000d0a7824ULL, 0x000fc400078e00ffULL,
0x00000002070fa824ULL, 0x140fe400078e026bULL, 0x00000002073fa824ULL, 0x000fe400078e026bULL,
0x000000020f45a824ULL, 0x100fe400078e020cULL, 0x000000ffff0f7224ULL, 0x000fe200000e060bULL,
0x000008000a0b7812ULL, 0x000fe200078ec0ffULL, 0x000000023f3fa824ULL, 0x000fe200078e020cULL,
0x00000009410ca211ULL, 0x040fe200078038ffULL, 0x00000010063c7825ULL, 0x000fe200078e000eULL,
0x00000015410aa211ULL, 0x000fc400078238ffULL, 0x00000016410da211ULL, 0x000fe200000f3cffULL,
0x00000001140b7824ULL, 0x000fe400078e020bULL, 0x000000083f3fa824ULL, 0x000fe400078e0206ULL,
0x00000010063b7824ULL, 0x000fe200078e020bULL, 0x00000018410ba211ULL, 0x000fe200008f3cffULL,
0x0000001011107825ULL, 0x100fe200078e000eULL, 0x000000064541a211ULL, 0x000fe400078e18ffULL,
0x000045803f3fa811ULL, 0x000fe200078e20ffULL, 0x0000001013127825ULL, 0x000fe200078e000eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800003c3b7faeULL, 0x0005e2000b901c48ULL,
0x000041804141a811ULL, 0x000fc400078e20ffULL, 0x00000010430e7825ULL, 0x000fe200078e000eULL,
0x00380000103b7faeULL, 0x0005e6000b901c48ULL, 0x00000010060ca825ULL, 0x040fe200078e000cULL,
0x00580000123b7faeULL, 0x0005e6000b901c48ULL, 0x00000010060aa825ULL, 0x000fe200078e000aULL,
0x007800000e3b7faeULL, 0x0005e8000b901c48ULL, 0x000000000c3fafaeULL, 0x0005e8000b901c48ULL,
0x000000000a41afaeULL, 0x0005e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000080390a7824ULL, 0x004fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x100fe20000011606ULL,
0x00000002070d7824ULL, 0x000fe200078e026bULL, 0x00000002ff447819ULL, 0x000fe20000011606ULL,
0x00000010060b7824ULL, 0x000fe200078e00ffULL, 0x000000800a0a7812ULL, 0x000fc400078ec0ffULL,
0x00000002440f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000844127824ULL, 0x040fe200078e00ffULL,
0x0000000844487810ULL, 0x040fe20007ffe0ffULL, 0x000001000d0c7824ULL, 0x000fe200078e000aULL,
0x000000700b0a7812ULL, 0x000fe200078ec0ffULL, 0x00000008443e7824ULL, 0x000fe200078e00ffULL,
0x0000000c0e0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000844427824ULL, 0x040fe200078e00ffULL,
0x00000001440d7810ULL, 0x040fe20007ffe0ffULL, 0x00000008444a7824ULL, 0x000fe200078e00ffULL,
0x0000000c0b0e7210ULL, 0x000fe20007ffe00aULL, 0x00000800390c7824ULL, 0x000fe200078e00ffULL,
0xfffffff812117812ULL, 0x000fe200078ee20dULL, 0x00000008443f7824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3b7812ULL, 0x000fe200078ee20fULL, 0x00000008440f7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180000e107984ULL, 0x000ea20000000800ULL,
0x000008000c0d7812ULL, 0x000fe200078ec0ffULL, 0x00000004060c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee244ULL, 0x004580000e3c7984ULL, 0x0007220000000800ULL,
0x00000003443d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c0c467812ULL, 0x000fe400078ec0ffULL,
0xfffffff8423d7812ULL, 0x000fe400078ee23dULL, 0x00000004443e7810ULL, 0x000fc40007ffe0ffULL,
0x00000180140e7810ULL, 0x008fe20007ffe00dULL, 0x00000008480d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe400078ee23eULL, 0x0000000e0f0c7211ULL, 0x000fe400078e20ffULL,
0xfffffff80d0d7812ULL, 0x000fe400078ee248ULL, 0xffffffff443e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001460c7824ULL, 0x000fe200078e020cULL, 0x0000000239397810ULL, 0x000fe20007ffe0ffULL,
0x000000100d0d7824ULL, 0x000fc600078e020eULL, 0x000000000c0f7984ULL, 0x000ee20000000800ULL,
0x0000000146127824ULL, 0x000fe200078e020dULL, 0x0000030039007a0cULL, 0x000fe20003f06070ULL,
0x00000010110d7824ULL, 0x100fe200078e020eULL, 0x0000000544117810ULL, 0x000fe40007ffe0ffULL,
0x0000000012407984ULL, 0x000e620000000800ULL, 0x00000001460d7824ULL, 0x000fe200078e020dULL,
0xfffffff84a437812ULL, 0x000fe200078ee211ULL, 0x000000103b117824ULL, 0x000fe200078e020eULL,
0x00000006443b7810ULL, 0x000fc40007ffe0ffULL, 0x000400000d417984ULL, 0x000fe20000000800ULL,
0x0000001017107221ULL, 0x006fe40000010100ULL, 0x0000000146117824ULL, 0x000fe400078e0211ULL,
0x3fb8aa3b10107820ULL, 0x000fc60000410000ULL, 0x0000000011127984ULL, 0x000fe20000000800ULL,
0x0000001000137308ULL, 0x0003260000000800ULL, 0x0004000011427984ULL, 0x0007e80000000800ULL,
0x000000000d107984ULL, 0x002fe20000000800ULL, 0x0000003c13457220ULL, 0x010fe20000410000ULL,
0x00000003443c7819ULL, 0x040fe200000006ffULL, 0x000000103d137824ULL, 0x100fe200078e020eULL,
0x2000000fff117230ULL, 0x008fe20000004100ULL, 0x00000008443d7824ULL, 0x000fe200078e00ffULL,
0x00001f44450c7589ULL, 0x000e6200000e0000ULL, 0x0000000146137824ULL, 0x000fe200078e0213ULL,
0xfffffff83c477812ULL, 0x000fe200078ee23bULL, 0x000000103f3c7824ULL, 0x000fe200078e020eULL,
0x00001f48450d7589ULL, 0x0004e200000e0000ULL, 0xfffffff83d3f7812ULL, 0x000fe200078ee23eULL,
0x00000010433d7824ULL, 0x000fc400078e020eULL, 0x00000000133b7984ULL, 0x000f220000000800ULL,
0x00000001463c7824ULL, 0x040fe400078e023cULL, 0x000000103f3f7824ULL, 0x100fe200078e020eULL,
0x0004000013437984ULL, 0x000f220000000800ULL, 0x00000010473e7824ULL, 0x000fe400078e020eULL,
0x00000001463d7824ULL, 0x040fe200078e023dULL, 0x000000003c0e7984ULL, 0x000f220000000800ULL,
0x00000001463e7824ULL, 0x040fe200078e023eULL, 0x0000003f463f7210ULL, 0x000fe20007ffe0ffULL,
0x0000003a453a7221ULL, 0x000fe20000010000ULL, 0x3000000fff457230ULL, 0x004fe20000004100ULL,
0x000400003d137984ULL, 0x000fe20000000800ULL, 0x20000040ff467230ULL, 0x000fc40000004100ULL,
0x30000040ff407230ULL, 0x000fe20000004100ULL, 0x000000003d0f7984ULL, 0x000ea20000000800ULL,
0x0000000c45307223ULL, 0x082fe20000010030ULL, 0x30000010ff457230ULL, 0x100fe40000004100ULL,
0x0000000d402f7223ULL, 0x088fe2000001002fULL, 0x000400003c447984ULL, 0x000e620000000800ULL,
0x20000010ff407230ULL, 0x000fe20000004100ULL, 0x0000000c111a7223ULL, 0x080fe2000001001aULL,
0x20000041ff107230ULL, 0x100fe20000004100ULL, 0x000400003e3c7984ULL, 0x000ee20000000800ULL,
0x30000041ff417230ULL, 0x000fe20000004100ULL, 0x0000000c401f7223ULL, 0x000fe2000001001fULL,
0x20000012ff407230ULL, 0x000fe20000004100ULL, 0x000000003e117984ULL, 0x0008e20000000800ULL,
0x0000000d102d7223ULL, 0x000fc4000001002dULL, 0x0000000d412c7223ULL, 0x080fe2000001002cULL,
0x000000003f107984ULL, 0x000ee20000000800ULL, 0x30000012ff417230ULL, 0x000fe20000004100ULL,
0x0000000c452e7223ULL, 0x080fe2000001002eULL, 0x20000042ff457230ULL, 0x100fe20000004100ULL,
0x000400003f3d7984ULL, 0x000ee20000000800ULL, 0x30000042ff427230ULL, 0x000fe20000004100ULL,
0x0000000d46227223ULL, 0x080fe20000010022ULL, 0x2000003bff127230ULL, 0x110fe20000004100ULL,
0x0000000c402b7223ULL, 0x080fe2000001002bULL, 0x3000003bff3b7230ULL, 0x000fe20000004100ULL,
0x0000000c41387223ULL, 0x080fe20000010038ULL, 0x20000043ff3e7230ULL, 0x100fe20000004100ULL,
0x0000000c12377223ULL, 0x080fe20000010037ULL, 0x30000043ff437230ULL, 0x000fe20000004100ULL,
0x0000000c3b367223ULL, 0x000fe20000010036ULL, 0x2000000eff127230ULL, 0x100fe20000004100ULL,
0x0000000d452a7223ULL, 0x080fe2000001002aULL, 0x3000000eff0e7230ULL, 0x000fe20000004100ULL,
0x0000000d42297223ULL, 0x000fc40000010029ULL, 0x0000000c12277223ULL, 0x080fe40000010027ULL,
0x0000000c0e257223ULL, 0x080fe20000010025ULL, 0x2000000fff3b7230ULL, 0x104fe20000004100ULL,
0x0000000d3e267223ULL, 0x080fe20000010026ULL, 0x3000000fff0f7230ULL, 0x000fe20000004100ULL,
0x0000000d43287223ULL, 0x080fe20000010028ULL, 0x20000013ff0e7230ULL, 0x100fe20000004100ULL,
0x0000000c3b247223ULL, 0x080fe20000010024ULL, 0x20000044ff127230ULL, 0x102fe20000004100ULL,
0x0000000c0f237223ULL, 0x080fe20000010023ULL, 0x30000044ff447230ULL, 0x000fe20000004100ULL,
0x0000000d0e337223ULL, 0x080fe20000010033ULL, 0x2000003cff0f7230ULL, 0x008fe20000004100ULL,
0x0000000d12357223ULL, 0x080fe20000010035ULL, 0x30000013ff137230ULL, 0x000fe20000004100ULL,
0x0000000d44347223ULL, 0x080fe20000010034ULL, 0x20000011ff0e7230ULL, 0x100fe20000004100ULL,
0x0000000d0f207223ULL, 0x080fe20000010020ULL, 0x30000011ff117230ULL, 0x000fe20000004100ULL,
0x0000000d13327223ULL, 0x080fe20000010032ULL, 0x20000010ff0f7230ULL, 0x000fe20000004100ULL,
0x0000000c0e1b7223ULL, 0x080fe2000001001bULL, 0x3000003cff3c7230ULL, 0x000fe20000004100ULL,
0x0000000c11217223ULL, 0x080fe20000010021ULL, 0x30000010ff107230ULL, 0x000fe20000004100ULL,
0x0000000c0f1e7223ULL, 0x080fe2000001001eULL, 0x2000003dff0e7230ULL, 0x100fe20000004100ULL,
0x0000000d3c317223ULL, 0x000fe20000010031ULL, 0x3000003dff127230ULL, 0x000fe20000004100ULL,
0x0000000c101d7223ULL, 0x000fc4000001001dULL, 0x0000000d0e1c7223ULL, 0x080fe4000001001cULL,
0x0000000d12197223ULL, 0x000fe20000010019ULL, 0xfffff3c000008947ULL, 0x000fea000383ffffULL,
0x000000ff6b00720cULL, 0x000fe20003f05270ULL, 0x0000018000007945ULL, 0x000fd80003800000ULL,
0x0000008007008824ULL, 0x000fe400078e020aULL, 0x000000010a0a7824ULL, 0x000fe400078e020bULL,
0x000000010b038824ULL, 0x000fca00078e0200ULL, 0x0049803a03008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x004980000a007984ULL, 0x000ea80000000800ULL,
0x004a00000a097984ULL, 0x000ee20000000800ULL, 0x00000000ff007221ULL, 0x004fc80000010000ULL,
0x0000000900007221ULL, 0x008fca0000010000ULL, 0x0180000000027810ULL, 0x000fc80007ffe0ffULL,
0x7f80000002027812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0000ULL, 0x0000b41000087802ULL, 0x000fc40000000f00ULL,
0x0000a0e000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff027224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000037308ULL, 0x000ea40000001000ULL,
0xbf80000000027423ULL, 0x004fc80000000003ULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000203027223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff0d7819ULL, 0x004fc40000011606ULL, 0x00000008060f7811ULL, 0x000fe400078ff0ffULL,
0x000000020d0a7810ULL, 0x040fe20007ffe0ffULL, 0x00001f0d02007589ULL, 0x000ea200000e0000ULL,
0x000000080d157824ULL, 0x040fe200078e00ffULL, 0x000000040d117810ULL, 0x040fe20007ffe0ffULL,
0x000000080d137824ULL, 0x040fe200078e00ffULL, 0x00001f0f02097589ULL, 0x00072200000e0000ULL,
0x000000080d127824ULL, 0x000fe200078e00ffULL, 0xfffffff8150e7812ULL, 0x000fe200078ee20aULL,
0x000000080d177824ULL, 0x042fe200078e00ffULL, 0x000000050d0a7810ULL, 0x040fe20007ffe0ffULL,
0x000000080d187824ULL, 0x040fe200078e00ffULL, 0x000000030d107810ULL, 0x000fe20007ffe0ffULL,
0x000000100e0e7824ULL, 0x000fe200078e0205ULL, 0xfffffff815147812ULL, 0x000fe200078ee20aULL,
0x00000004060a7824ULL, 0x000fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fc400078ee211ULL,
0x000000060d117810ULL, 0x040fe20007ffe0ffULL, 0x0000001014147824ULL, 0x100fe200078e0205ULL,
0x000000030d167819ULL, 0x000fe200000006ffULL, 0x0000001012127824ULL, 0x000fe200078e0205ULL,
0xfffffff817107812ULL, 0x000fe400078ee210ULL, 0xfffffff816167812ULL, 0x000fe200078ee211ULL,
0x0000001a001a7220ULL, 0x044fe20000410000ULL, 0x000000066f6f7210ULL, 0x000fe20007ffe0ffULL,
0x0000003000037220ULL, 0x040fe40000410000ULL, 0x0000001f001f7220ULL, 0x000fc40000410000ULL,
0x0000002e002e7220ULL, 0x040fe20000410000ULL, 0x0000001a0303723eULL, 0x000fe200000000ffULL,
0x0000002b002b7220ULL, 0x040fe40000410000ULL, 0x0000003800387220ULL, 0x000fe20000410000ULL,
0x0000001f2e1f723eULL, 0x000fe200000000ffULL, 0x0000003700377220ULL, 0x040fe40000410000ULL,
0x0000003600367220ULL, 0x000fe20000410000ULL, 0x0000002b382b723eULL, 0x000fe200000000ffULL,
0x0000002700277220ULL, 0x000fc40000410000ULL, 0x0000002500087220ULL, 0x000fe20000410000ULL,
0x000000373636723eULL, 0x000fe200000000ffULL, 0x0000002400247220ULL, 0x040fe40000410000ULL,
0x0000002300237220ULL, 0x000fe20000410000ULL, 0x000000270808723eULL, 0x000fe200000000ffULL,
0x0000001b001b7220ULL, 0x040fe40000410000ULL, 0x0000002100027220ULL, 0x048fe20000410000ULL,
0x000000242323723eULL, 0x000fe200000000ffULL, 0x0000001e001e7220ULL, 0x000fc40000410000ULL,
0x0000001d001d7220ULL, 0x000fe20000410000ULL, 0x000000010d007810ULL, 0x000fe20007ffe0ffULL,
0x00000028090b7220ULL, 0x010fe20000410000ULL, 0x0000001b0202723eULL, 0x000fe200000000ffULL,
0x000000080f287824ULL, 0x000fe200078e00ffULL, 0xfffffff8130c7812ULL, 0x000fe200078ee200ULL,
0x000000080d007824ULL, 0x040fe200078e00ffULL, 0xffffffff0d137810ULL, 0x000fe20007ffe0ffULL,
0x0000002209227220ULL, 0x040fe20000410000ULL, 0xfffffff828287812ULL, 0x000fe200078ee20fULL,
0x0000002f092f7220ULL, 0x040fe20000410000ULL, 0xfffffff800007812ULL, 0x000fe200078ee20dULL,
0x0000002d092d7220ULL, 0x040fe20000410000ULL, 0x0000000c0a0d7812ULL, 0x000fe200078ec0ffULL,
0x0000002c092c7220ULL, 0x040fe20000410000ULL, 0xfffffff818187812ULL, 0x000fe200078ee213ULL,
0x0000002a092a7220ULL, 0x000fe20000410000ULL, 0x0000001e1d1d723eULL, 0x000fe200000000ffULL,
0x0000002909297220ULL, 0x040fe20000410000ULL, 0x0000000518187211ULL, 0x000fe200078e20ffULL,
0x0000002609267220ULL, 0x000fe20000410000ULL, 0x000000222f22723eULL, 0x000fe200000000ffULL,
0x0000003509357220ULL, 0x040fe20000410000ULL, 0x0000002d2c2c723eULL, 0x000fe200000000ffULL,
0x0000003409347220ULL, 0x000fe20000410000ULL, 0x0000002a2929723eULL, 0x000fe200000000ffULL,
0x0000003309337220ULL, 0x000fe20000410000ULL, 0x000000260b0b723eULL, 0x000fe200000000ffULL,
0x0000003209327220ULL, 0x040fe20000410000ULL, 0x000000353434723eULL, 0x000fe200000000ffULL,
0x0000002009207220ULL, 0x000fc40000410000ULL, 0x0000003109317220ULL, 0x040fe20000410000ULL,
0x000000333232723eULL, 0x000fe200000000ffULL, 0x0000001c091c7220ULL, 0x000fe40000410000ULL,
0x0000001000007824ULL, 0x100fe200078e0205ULL, 0x000000203120723eULL, 0x000fe200000000ffULL,
0x0000001909097220ULL, 0x000fe40000410000ULL, 0x000000100c0c7824ULL, 0x100fe400078e0205ULL,
0x0000001010107824ULL, 0x100fe200078e0205ULL, 0x0000001c0909723eULL, 0x000fe200000000ffULL,
0x0000001016167824ULL, 0x000fc400078e0205ULL, 0x0000001028287824ULL, 0x000fe400078e0205ULL,
0x0000000100007824ULL, 0x000fe400078e020dULL, 0x000000010d057824ULL, 0x040fe400078e020cULL,
0x000000010d0a7824ULL, 0x040fe200078e020eULL, 0x0000000300007388ULL, 0x000fe20000000800ULL,
0x000000010d1c7824ULL, 0x040fe400078e0210ULL, 0x000000010d217824ULL, 0x040fe200078e0212ULL,
0x0000001f05007388ULL, 0x000fe20000000800ULL, 0x000000010d1e7824ULL, 0x000fc400078e0214ULL,
0x000000010d257824ULL, 0x040fe200078e0216ULL, 0x0000002b0a007388ULL, 0x000fe20000000800ULL,
0x000000010d247824ULL, 0x040fe400078e0218ULL, 0x000000010d0d7824ULL, 0x000fe200078e0228ULL,
0x000000361c007388ULL, 0x000fe20000000800ULL, 0x000000106f6f7824ULL, 0x000fc600078e0204ULL,
0x0000000821007388ULL, 0x000fe80000000800ULL, 0x000000231e007388ULL, 0x000fe80000000800ULL,
0x0000000225007388ULL, 0x000fe80000000800ULL, 0x0000001d24007388ULL, 0x000fe80000000800ULL,
0x000000220d007388ULL, 0x000fe80000000800ULL, 0x0004002c05007388ULL, 0x000fe80000000800ULL,
0x000400290a007388ULL, 0x000fe80000000800ULL, 0x0004000b1c007388ULL, 0x000fe80000000800ULL,
0x0004003421007388ULL, 0x000fe80000000800ULL, 0x000400321e007388ULL, 0x000fe80000000800ULL,
0x0004002025007388ULL, 0x000fe80000000800ULL, 0x0004000924007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000006f0c7984ULL, 0x000e680000000c00ULL,
0x000400006f147984ULL, 0x000ea80000000c00ULL, 0x000800006f107984ULL, 0x000ee80000000c00ULL,
0x000c00006f187984ULL, 0x000f220000000c00ULL, 0x200000ff0f0f7230ULL, 0x002fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x004fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x000000130f0f7230ULL, 0x008fe40000000000ULL,
0x000000120e0e7230ULL, 0x000fe40000000000ULL, 0x000000110d0d7230ULL, 0x000fe40000000000ULL,
0x000000100c0c7230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x010fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000c6f007388ULL, 0x000fe20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x000400146f007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff0700720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff037819ULL, 0x000fc80000011606ULL, 0x000000730300720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000103007824ULL, 0x100fe200078e0206ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x00005a0071107a19ULL, 0x000fe200000006ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000000700057812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x0000001074007824ULL, 0x000fe200078e0203ULL, 0x00000020060d7810ULL, 0x000fe20007ffe0ffULL,
0x0000580000067ab9ULL, 0x000fe20000000800ULL, 0x0ffffff805057812ULL, 0x000fc400078ef806ULL,
0x0000000500037c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0c7a19ULL, 0x000fe20000011600ULL,
0x0000001005027824ULL, 0x000fe200078e0204ULL, 0x00000003ff077819ULL, 0x000fe2000001160dULL,
0x0000000110037824ULL, 0x000fe200078e0203ULL, 0x00000007060e7812ULL, 0x000fe400078ec0ffULL,
0x0000000002087984ULL, 0x0004e20000000c00ULL, 0x000000750c037224ULL, 0x000fe400078e0203ULL,
0x000000086b057824ULL, 0x000fe200078e020eULL, 0x00000006040472a4ULL, 0x002fcc000f8e023fULL,
0x0000000475007c24ULL, 0x000fca000f8e02ffULL, 0x0000000300037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x004fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fe400000f440cULL, 0x000000730700720cULL, 0x000fc60003f06070ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0083ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d027824ULL, 0x142fe200078e0207ULL,
0x00000040060f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001074077824ULL, 0x000fe200078e0207ULL,
0x000000070d0c7812ULL, 0x000fe400078ec0ffULL, 0x0000000702027812ULL, 0x000fc800078ec0ffULL,
0x0ffffff802037812ULL, 0x000fe400078ef80dULL, 0x00005a00ff027a19ULL, 0x000fc60000011607ULL,
0x0000001003057824ULL, 0x000fe200078e0204ULL, 0x0000000507037c12ULL, 0x000fe4000f8e30ffULL,
0x00000003ff077819ULL, 0x000fe4000001160fULL, 0x0000000005087984ULL, 0x0002a20000000c00ULL,
0x0000000310037210ULL, 0x000fca0007ffe0ffULL, 0x0000007502037224ULL, 0x000fe400078e0203ULL,
0x000000086b057824ULL, 0x002fc600078e020cULL, 0x0000000300037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fe400000f440eULL, 0x000000730700720cULL, 0x000fc60003f06070ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0043ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010f027824ULL, 0x142fe200078e0207ULL,
0x00000060060d7810ULL, 0x000fe20007ffe0ffULL, 0x0000001074077824ULL, 0x000fe200078e0207ULL,
0x000000070f067812ULL, 0x000fe400078ec0ffULL, 0x0000000702027812ULL, 0x000fc800078ec0ffULL,
0x0ffffff802037812ULL, 0x000fe400078ef80fULL, 0x00005a00ff027a19ULL, 0x000fc60000011607ULL,
0x0000001003057824ULL, 0x000fe200078e0204ULL, 0x0000000507037c12ULL, 0x000fe4000f8e30ffULL,
0x00000003ff077819ULL, 0x000fe4000001160dULL, 0x0000000005087984ULL, 0x0002a20000000c00ULL,
0x0000000110037824ULL, 0x000fc800078e0203ULL, 0x0000007502037224ULL, 0x000fe400078e0203ULL,
0x000000086b057824ULL, 0x002fc600078e0206ULL, 0x0000000300037210ULL, 0x000fe20007f1e0ffULL,
0x000000010d067824ULL, 0x000fc800078e0207ULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x040fe400078040ffULL, 0x0000000706067812ULL, 0x000fe400078ec0ffULL,
0x00005d0003037a11ULL, 0x000fe400000f440cULL, 0x000000730700720cULL, 0x000fc60003f06070ULL,
0x0000001005027825ULL, 0x000fe200078e0002ULL, 0xfffffff806057812ULL, 0x000fc800078ef80dULL,
0x0000000802007986ULL, 0x0043ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001005057824ULL, 0x000fe200078e0204ULL, 0x0000000774077211ULL, 0x000fc800078e20ffULL,
0x0000000005087984ULL, 0x002e620000000c00ULL, 0x0000000507037c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fc60000011607ULL, 0x0000000110037824ULL, 0x000fc800078e0203ULL,
0x0000007502037224ULL, 0x000fca00078e0203ULL, 0x0000000300037210ULL, 0x000fe40007f1e0ffULL,
0x000000070d007812ULL, 0x000fc600078ec0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fe200078040ffULL, 0x000000086b6b7824ULL, 0x000fc600078e0200ULL,
0x00005d0003037a11ULL, 0x000fca00000f4404ULL, 0x000000106b027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000402037824ULL, 0x000fca00078e0200ULL, 0x0000006c0300720cULL, 0x000fda0003f06070ULL,
0x0000000279048824ULL, 0x002fc800078e00ffULL, 0x00006800040f8a24ULL, 0x000fe400078e0203ULL,
0xffffffffff047424ULL, 0x000fe400078e00ffULL, 0x000064000f0e8625ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000080e048981ULL, 0x000ea2000c1e1900ULL,
0x00000001020a7810ULL, 0x000fe20007ffe0ffULL, 0x0000004010777824ULL, 0x000fe400078e00ffULL,
0x00000100ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000005d0a00720cULL, 0x000fe20003f06070ULL,
0x01b60000ff087f8cULL, 0x000e62000c80043fULL, 0x0000004000787824ULL, 0x000fc400078e00ffULL,
0x0000004071057824ULL, 0x000fe400078e00ffULL, 0x00000077040a7224ULL, 0x004fc800078e02ffULL,
0x000062000a0a7625ULL, 0x000fc600078e000bULL, 0x00000c8000008947ULL, 0x000fea0003800000ULL,
0x00000078020d7211ULL, 0x002fe400078e40ffULL, 0x00000003ff187819ULL, 0x000fe40000011606ULL,
0x0000000d680e7217ULL, 0x000fe40007800000ULL, 0x0000000418077810ULL, 0x040fe20007ffe0ffULL,
0x0000004071717824ULL, 0x000fe200078e0218ULL, 0x0000000c18107810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0d7824ULL, 0x000fe200078e0a0dULL, 0x00000008180f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001070e7824ULL, 0x140fe200078e0206ULL, 0x0000001818197810ULL, 0x000fe20007ffe0ffULL,
0x0000000807117824ULL, 0x040fe200078e00ffULL, 0x0000000d0700720cULL, 0x080fe20003f46070ULL,
0x000000010f077824ULL, 0x040fe200078e0206ULL, 0x0000000d1000720cULL, 0x0c0fe20003f86070ULL,
0x000000080f207824ULL, 0x000fe200078e00ffULL, 0xfffffff811167812ULL, 0x000fe200078ee20eULL,
0x00000001100e7824ULL, 0x140fe200078e0206ULL, 0x0000000d0f00720cULL, 0x080fe20003f66070ULL,
0x0000000810117824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee207ULL,
0x0000000118077824ULL, 0x140fe200078e0206ULL, 0x0000000d1800720cULL, 0x000fe20003f26070ULL,
0x00000001191c7824ULL, 0x000fe200078e0206ULL, 0xfffffff811247812ULL, 0x000fc400078ee20eULL,
0x00000010180e7810ULL, 0x040fe40007ffe0ffULL, 0x0000001418117810ULL, 0x000fe40007ffe0ffULL,
0x0000000d0e00720cULL, 0x0c0fe20003fa6070ULL, 0x000000010e107824ULL, 0x040fe200078e0206ULL,
0x000000030e137819ULL, 0x000fe200000006ffULL, 0x00000100710e7825ULL, 0x000fe200078e00ffULL,
0x0000000d1100720cULL, 0x000fe40003f06070ULL, 0xfffffff813267812ULL, 0x000fe200078ee210ULL,
0x0000000111127824ULL, 0x000fe200078e0206ULL, 0x0000000471107810ULL, 0x000fe20007ffe0ffULL,
0x0000000811157824ULL, 0x000fe200078e00ffULL, 0x0000000707117812ULL, 0x000fc400078ec0ffULL,
0x000000700e137812ULL, 0x000fe400078ef80cULL, 0xfffffff815287812ULL, 0x000fe400078ee212ULL,
0x0ffffff811147812ULL, 0x000fe200078ef806ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000130a127210ULL, 0x000fe40007fde0ffULL, 0x00000008710e7810ULL, 0x000fe40007ffe0ffULL,
0x0000100000077811ULL, 0x000fe200078e70ffULL, 0x000000010b137824ULL, 0x000fe200030e060fULL,
0x0000007010157812ULL, 0x000fe200078ef80cULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000c71107810ULL, 0x000fc60007ffe0ffULL, 0x0000001014177824ULL, 0x000fe200078e0207ULL,
0x000000150a147210ULL, 0x000fe40007fde0ffULL, 0x000000700e1b7812ULL, 0x100fe400078ef80cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012177faeULL, 0x0003e2000c901c48ULL,
0x000000010b157824ULL, 0x000fe200030e0611ULL, 0x0000001b0a1a7210ULL, 0x000fe20007fde0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x00000010710e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000d1900720cULL, 0x040fe20003f26070ULL, 0x0000000819197824ULL, 0x000fe200078e00ffULL,
0x00000070101d7812ULL, 0x000fe200078ef80cULL, 0x000000010b1b7824ULL, 0x000fe200030e060fULL,
0x0000001471107810ULL, 0x000fe20007ffe0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff8192a7812ULL, 0x000fc400078ee21cULL, 0x0000001c18127810ULL, 0x002fe20007ffe0ffULL,
0x0000001016137824ULL, 0x000fe200078e0207ULL, 0x0000001d0a1c7210ULL, 0x000fe40007fde0ffULL,
0x000000700e1f7812ULL, 0x000fe200078ef80cULL, 0x0000000112167824ULL, 0x040fe200078e0206ULL,
0x0000000312177819ULL, 0x000fe200000006ffULL, 0x000000010b1d7824ULL, 0x000fe200030e0611ULL,
0x0000001f0a1e7210ULL, 0x000fe20007fde0ffULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x00000018710e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000014137faeULL, 0x0003e2000d101c48ULL,
0xfffffff8172c7812ULL, 0x000fe200078ee216ULL, 0x000000010b1f7824ULL, 0x000fe200030e060fULL,
0x0000007010177812ULL, 0x000fe200078ef80cULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000d1200720cULL, 0x000fc40003f46070ULL, 0x000000170a127210ULL, 0x000fe40007fde0ffULL,
0x000000700e177812ULL, 0x000fe400078ef80cULL, 0x0000001c71107810ULL, 0x040fe20007ffe0ffULL,
0x0000001020157824ULL, 0x002fe200078e0207ULL, 0x0000002018137810ULL, 0x040fe40007ffe0ffULL,
0x00000020710e7810ULL, 0x000fe40007ffe0ffULL, 0x000000001a157faeULL, 0x0003e2000d901c48ULL,
0x0000000113147824ULL, 0x040fe200078e0206ULL, 0x0000000d1300720cULL, 0x040fe20003f66070ULL,
0x0000000813197824ULL, 0x000fe200078e00ffULL, 0x0000002818207810ULL, 0x000fe20007ffe0ffULL,
0x000000010b137824ULL, 0x000fe200030e0611ULL, 0x000000170a167210ULL, 0x000fe20007fde0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0xfffffff819227812ULL, 0x000fc600078ee214ULL,
0x000000010b177824ULL, 0x000fe200030e060fULL, 0x00000024180f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001024197824ULL, 0x000fe200078e0207ULL, 0x0000007010157812ULL, 0x002fe200078ef80cULL,
0x0000000820237824ULL, 0x000fe200078e00ffULL, 0x00000028711a7810ULL, 0x000fe20007ffe0ffULL,
0x000000010f107824ULL, 0x040fe200078e0206ULL, 0x000000001c197faeULL, 0x0003e2000e101c48ULL,
0x000000080f1b7824ULL, 0x040fe200078e00ffULL, 0x0000000d0f00720cULL, 0x000fe20003f86070ULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x000000150a147210ULL, 0x000fc40007fde0ffULL,
0xfffffff81b247812ULL, 0x000fe200078ee210ULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x0000002471107810ULL, 0x000fe40007ffe0ffULL, 0x000000110b157210ULL, 0x000fe200037fe4ffULL,
0x0000001024257824ULL, 0x000fe200078e0207ULL, 0x000000700e1d7812ULL, 0x002fe200078ef80cULL,
0x0000010010107825ULL, 0x000fc600078e00ffULL, 0x0000001d0a1c7210ULL, 0x000fe20007fde0ffULL,
0x0000001026197824ULL, 0x000fe200078e0207ULL, 0x0000007010217812ULL, 0x000fe200078ef80cULL,
0x00000001200e7824ULL, 0x040fe200078e0206ULL, 0x0000002c71107810ULL, 0x000fe20007ffe0ffULL,
0x000000010b1d7824ULL, 0x000fe200030e060fULL, 0x000000001e197faeULL, 0x0003e2000e901c48ULL,
0x0000000d2000720cULL, 0x000fe40003fa6070ULL, 0x000000210a207210ULL, 0x000fe40007fde0ffULL,
0x000000701a0f7812ULL, 0x000fc400078ef80cULL, 0xfffffff823267812ULL, 0x000fe200078ee20eULL,
0x000000010b217824ULL, 0x000fe200030e0611ULL, 0x0000000f0a0e7210ULL, 0x000fe20007fde0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x0000002c181a7810ULL, 0x000fc60007ffe0ffULL,
0x0000001028197824ULL, 0x002fe200078e0207ULL, 0x00000070101f7812ULL, 0x000fe200078ef80cULL,
0x000000010b0f7824ULL, 0x000fe200030e061bULL, 0x00000030711b7810ULL, 0x000fe20007ffe0ffULL,
0x000000011a1e7824ULL, 0x040fe200078e0206ULL, 0x0000000012197faeULL, 0x0003e2000c101c48ULL,
0x0000000d1a00720cULL, 0x040fe20003f06070ULL, 0x000000081a237824ULL, 0x000fe200078e00ffULL,
0x0000001f0a107210ULL, 0x000fe20007fde0ffULL, 0x000001001b1a7825ULL, 0x000fe200078e00ffULL,
0x00000030181f7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff8231e7812ULL, 0x000fe200078ee21eULL,
0x000000010b117824ULL, 0x000fe200030e0611ULL, 0x000000701a237812ULL, 0x000fe200078ef80cULL,
0x000000081f287824ULL, 0x000fe200078e00ffULL, 0x00000034711a7810ULL, 0x000fe20007ffe0ffULL,
0x000000011f137824ULL, 0x002fe200078e0206ULL, 0x000000230a127210ULL, 0x000fe20007fde0ffULL,
0x0000001022237824ULL, 0x000fe200078e0207ULL, 0x000000072a197211ULL, 0x000fe400078e20ffULL,
0xfffffff828287812ULL, 0x000fe200078ee213ULL, 0x000000010b137824ULL, 0x000fe200030e061bULL,
0x0000003c18227810ULL, 0x000fe20007ffe0ffULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000016197faeULL, 0x0003e2000c901c48ULL, 0x0000000d1f00720cULL, 0x000fc40003f26070ULL,
0x000000102c1f7824ULL, 0x000fca00078e0207ULL, 0x00000000141f7faeULL, 0x0005e2000d101c48ULL,
0x0000000d2200720cULL, 0x000fe40003f46070ULL, 0x000000701a197812ULL, 0x002fe200078ef80cULL,
0x000000001c237faeULL, 0x0003e2000d901c48ULL, 0x00000038711a7810ULL, 0x000fe40007ffe0ffULL,
0x0000003418167810ULL, 0x040fe20007ffe0ffULL, 0x0000000020257faeULL, 0x0007e2000e101c48ULL,
0x0000003818177810ULL, 0x000fe40007ffe0ffULL, 0x000000190a187210ULL, 0x000fe20007fde0ffULL,
0x000001001a147825ULL, 0x004fe200078e00ffULL, 0x0000000d1600720cULL, 0x000fc40003f86070ULL,
0x0000000d1700720cULL, 0x040fe20003f66070ULL, 0x00000001160d7824ULL, 0x040fe200078e0206ULL,
0x00000003171c7819ULL, 0x002fe200000006ffULL, 0x00000008161a7824ULL, 0x000fe200078e00ffULL,
0x0000003c71167810ULL, 0x000fe20007ffe0ffULL, 0x000000010b197824ULL, 0x000fe200030e061bULL,
0x00000070141d7812ULL, 0x000fe200078ef80cULL, 0x00000001171b7824ULL, 0x100fe200078e0206ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee20dULL, 0x0000000122067824ULL, 0x000fe200078e0206ULL,
0x0000001d0a147210ULL, 0x000fe20007fde0ffULL, 0x00000008221f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee21bULL, 0x0000010016167825ULL, 0x000fc600078e00ffULL,
0xfffffff81f207812ULL, 0x008fe200078ee206ULL, 0x000000010b157824ULL, 0x000fe200030e0615ULL,
0x00000070161f7812ULL, 0x000fe200078ef80cULL, 0x00000010260d7824ULL, 0x100fe400078e0207ULL,
0x000000101e1b7824ULL, 0x100fe200078e0207ULL, 0x0000001f0a067210ULL, 0x000fe20007fde0ffULL,
0x00000010281d7824ULL, 0x100fe200078e0207ULL, 0x000000000e0d7faeULL, 0x0003e2000e901c48ULL,
0x000000101a1f7824ULL, 0x100fe400078e0207ULL, 0x000000101c217824ULL, 0x100fe200078e0207ULL,
0x00000000101b7faeULL, 0x0003e2000c101c48ULL, 0x0000001020237824ULL, 0x000fc400078e0207ULL,
0x000000010b077824ULL, 0x000fe200030e0617ULL, 0x00000000121d7faeULL, 0x0003e8000c901c48ULL,
0x00000000181f7faeULL, 0x0003e8000e101c48ULL, 0x0000000014217faeULL, 0x0003e8000d901c48ULL,
0x0000000006237faeULL, 0x0003e2000d101c48ULL, 0x00000b3000007947ULL, 0x000fea0003800000ULL,
0x0000000c062a7811ULL, 0x042fe400078fe8ffULL, 0x0000000406127811ULL, 0x000fc400078fe8ffULL,
0x00000010062b7811ULL, 0x000fe200078fe8ffULL, 0x000000012a0d7824ULL, 0x100fe200078e0206ULL,
0x0000002406197811ULL, 0x000fe200078fe8ffULL, 0x000000082a1c7824ULL, 0x000fe200078e00ffULL,
0x0000000612077210ULL, 0x040fe20007ffe0ffULL, 0x0000000812147824ULL, 0x000fe200078e00ffULL,
0x0000000806157811ULL, 0x000fe200078fe8ffULL, 0x000000012b0e7824ULL, 0x140fe200078e0206ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20dULL, 0x000000082b117824ULL, 0x000fe200078e00ffULL,
0x00000018062f7811ULL, 0x000fe200078fe8ffULL, 0x00000001190d7824ULL, 0x140fe200078e0206ULL,
0xfffffff814147812ULL, 0x000fe200078ee207ULL, 0x00000008191e7824ULL, 0x000fe200078e00ffULL,
0x00000028061b7811ULL, 0x040fe200078fe8ffULL, 0x0000000115077824ULL, 0x040fe200078e0206ULL,
0x0000002006187811ULL, 0x040fe200078fe8ffULL, 0x0000000815167824ULL, 0x000fe200078e00ffULL,
0x00000014062d7811ULL, 0x000fe200078fe8ffULL, 0x000000081b207824ULL, 0x000fe200078e00ffULL,
0xfffffff8112c7812ULL, 0x000fe200078ee20eULL, 0x000000012f0e7824ULL, 0x140fe200078e0206ULL,
0x000000032f117819ULL, 0x000fe200000006ffULL, 0x0000000818107824ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20dULL, 0x000000011b0d7824ULL, 0x100fe200078e0206ULL,
0x0000002c061a7811ULL, 0x000fe200078fe8ffULL, 0x000000012d0f7824ULL, 0x140fe200078e0206ULL,
0xfffffff816167812ULL, 0x000fe200078ee207ULL, 0x0000000118077824ULL, 0x000fe200078e0206ULL,
0x0000003406317811ULL, 0x040fe200078fe8ffULL, 0x000000082d2e7824ULL, 0x000fe200078e00ffULL,
0x0000001c06177811ULL, 0x000fc400078fe8ffULL, 0xfffffff811367812ULL, 0x000fe200078ee20eULL,
0x000000011a0e7824ULL, 0x100fe200078e0206ULL, 0xfffffff820207812ULL, 0x000fe200078ee20dULL,
0x000000081a117824ULL, 0x000fe200078e00ffULL, 0xfffffff810077812ULL, 0x000fe200078ee207ULL,
0x0000000131107824ULL, 0x140fe200078e0206ULL, 0x00000006060d7211ULL, 0x000fe200078fe8ffULL,
0x0000000831137824ULL, 0x000fe200078e00ffULL, 0xfffffff82e2e7812ULL, 0x000fe200078ee20fULL,
0x00000001170f7824ULL, 0x040fe200078e0206ULL, 0x0000003006337811ULL, 0x000fe200078fe8ffULL,
0x0000000817387824ULL, 0x000fe200078e00ffULL, 0xfffffff811227812ULL, 0x000fc400078ee20eULL,
0x0000003806347811ULL, 0x040fe200078fe8ffULL, 0x0000000833247824ULL, 0x000fe200078e00ffULL,
0x0000003c06327811ULL, 0x000fe400078fe8ffULL, 0x000000070d117812ULL, 0x000fe200078ec0ffULL,
0x00000001340d7824ULL, 0x000fe200078e0206ULL, 0xfffffff813267812ULL, 0x000fe200078ee210ULL,
0x0000000105107824ULL, 0x000fe200078e0212ULL, 0xfffffff838387812ULL, 0x000fe200078ee20fULL,
0x0000000834287824ULL, 0x000fe200078e00ffULL, 0x00000006330f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000105337824ULL, 0x040fe200078e0233ULL, 0x00000005060e7211ULL, 0x000fe200078fe8ffULL,
0x00000001053a7824ULL, 0x000fe200078e0232ULL, 0x0ffffff811127812ULL, 0x100fe200078ef806ULL,
0x0000000132067824ULL, 0x000fe200078e0206ULL, 0xfffffff824247812ULL, 0x000fe200078ee20fULL,
0x0000000832117824ULL, 0x000fe200078e00ffULL, 0x0000100000137811ULL, 0x000fe200078e70ffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fc400078ee20dULL,
0xfffffff811307812ULL, 0x000fe200078ee206ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000700e0d7812ULL, 0x100fe400078ef80cULL, 0x00000013161f7211ULL, 0x000fe200078e20ffULL,
0x000000101c217824ULL, 0x100fe200078e0213ULL, 0x0000000d0a067210ULL, 0x000fe20007f1e0ffULL,
0x00000010071c7824ULL, 0x100fe200078e0213ULL, 0x0000007010077812ULL, 0x000fe200078ef80cULL,
0x00000010120d7824ULL, 0x000fe200078e0213ULL, 0x0000001326267211ULL, 0x000fe200078e20ffULL,
0x0000000105107824ULL, 0x040fe200078e0215ULL, 0x000000070a0e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000105127824ULL, 0x000fc400078e022aULL, 0x000000010b077824ULL, 0x040fe400000e060fULL,
0x000000010b0f7824ULL, 0x000fe400008e0611ULL, 0x00000010141d7824ULL, 0x100fe200078e0213ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060d7faeULL, 0x0003e2000b901c48ULL,
0x000000102c237824ULL, 0x100fe400078e0213ULL, 0x000000102e257824ULL, 0x100fe200078e0213ULL,
0x000000000e1d7faeULL, 0x0003e2000b901c48ULL, 0x0000001036277824ULL, 0x000fc400078e0213ULL,
0x0000001038297824ULL, 0x100fe400078e0213ULL, 0x000000101e1e7824ULL, 0x100fe400078e0213ULL,
0x0000001020207824ULL, 0x100fe400078e0213ULL, 0x0000001022227824ULL, 0x100fe400078e0213ULL,
0x0000001024247824ULL, 0x100fe400078e0213ULL, 0x0000001028287824ULL, 0x000fc400078e0213ULL,
0x0000001030307824ULL, 0x000fe400078e0213ULL, 0x0000010010107825ULL, 0x000fc800078e00ffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000007010377812ULL, 0x000fc600078ef80cULL,
0x00000001052a7824ULL, 0x040fe200078e022dULL, 0x000000370a107210ULL, 0x000fe20007f1e0ffULL,
0x0000000105147824ULL, 0x040fe400078e022bULL, 0x00000001052c7824ULL, 0x000fe200078e022fULL,
0x00000070122f7812ULL, 0x000fe200078ef80cULL, 0x000001002a2a7825ULL, 0x000fc600078e00ffULL,
0x0000002f0a127210ULL, 0x000fe20007f3e0ffULL, 0x000001002c2c7825ULL, 0x000fe200078e00ffULL,
0x000000702a2f7812ULL, 0x100fe400078ef80cULL, 0x000000130b137210ULL, 0x040fe20000ffe4ffULL,
0x000000010b117824ULL, 0x000fe200000e0611ULL, 0x0000002f0a167210ULL, 0x000fe20007f1e0ffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x000000702c2f7812ULL, 0x100fe400078ef80cULL,
0x00000000101f7faeULL, 0x0003e2000b901c48ULL, 0x00000001052a7824ULL, 0x000fe200078e0217ULL,
0x0000007014357812ULL, 0x000fe200078ef80cULL, 0x000000010b177824ULL, 0x000fe200000e062bULL,
0x0000000012217faeULL, 0x0003e2000b901c48ULL, 0x00000001052c7824ULL, 0x000fe200078e0218ULL,
0x0000002f0a187210ULL, 0x000fe20007f1e0ffULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x000000350a147210ULL, 0x000fc60007f5e0ffULL, 0x00000001052e7824ULL, 0x000fe200078e0219ULL,
0x000000702a357812ULL, 0x000fe200078ef80cULL, 0x000000010b197824ULL, 0x000fe400000e062dULL,
0x000001002c2c7825ULL, 0x000fc800078e00ffULL, 0x0000000105367824ULL, 0x000fe200078e021bULL,
0x000000702c1b7812ULL, 0x000fe200078ef80cULL, 0x000001002e2e7825ULL, 0x000fc600078e00ffULL,
0x0000001b0a2a7210ULL, 0x040fe20007f3e0ffULL, 0x0000000105387824ULL, 0x000fe200078e021aULL,
0x000000350a1a7210ULL, 0x000fe20007f1e0ffULL, 0x0000010036367825ULL, 0x000fe200078e00ffULL,
0x000000702e397812ULL, 0x000fc600078ef80cULL, 0x000000010b1b7824ULL, 0x040fe200000e062bULL,
0x0000007036357812ULL, 0x100fe200078ef80cULL, 0x000000010b157824ULL, 0x000fe200010e0615ULL,
0x000000390a2c7210ULL, 0x000fe20007f1e0ffULL, 0x0000010038387825ULL, 0x000fe200078e00ffULL,
0x000000350a2e7210ULL, 0x000fe40007f5e0ffULL, 0x0000000014237faeULL, 0x0003e2000b901c48ULL,
0x0000000105357824ULL, 0x040fe200078e0231ULL, 0x0000007038317812ULL, 0x000fe200078ef80cULL,
0x0000000105367824ULL, 0x000fe200078e0234ULL, 0x0000000016257faeULL, 0x0003e2000b901c48ULL,
0x000000010b2b7824ULL, 0x040fe200008e062dULL, 0x0000002f0b2d7210ULL, 0x000fe200007fe4ffULL,
0x0000010033327825ULL, 0x000fe200078e00ffULL, 0x000000310a387210ULL, 0x000fe20007f1e0ffULL,
0x0000000018277faeULL, 0x0003e4000b901c48ULL, 0x000000010b2f7824ULL, 0x000fe200010e0637ULL,
0x0000007032417812ULL, 0x100fe200078ef80cULL, 0x0000010035347825ULL, 0x000fe200078e00ffULL,
0x000000001a297faeULL, 0x0003e6000b901c48ULL, 0x0000010036367825ULL, 0x000fe200078e00ffULL,
0x00000070343f7812ULL, 0x100fe200078ef80cULL, 0x000000002a1c7faeULL, 0x0003e4000b901c48ULL,
0x000001003a3a7825ULL, 0x000fe200078e00ffULL, 0x00000070363d7812ULL, 0x100fe200078ef80cULL,
0x000000002c1e7faeULL, 0x0003e2000b901c48ULL, 0x0000003f0a347210ULL, 0x000fe20007f3e0ffULL,
0x000000010b397824ULL, 0x040fe200000e0639ULL, 0x000000703a317812ULL, 0x000fe200078ef80cULL,
0x000000002e207faeULL, 0x0003e2000b901c48ULL, 0x000000410a327210ULL, 0x040fe20007f1e0ffULL,
0x000000010b357824ULL, 0x040fe200008e0635ULL, 0x0000003d0a367210ULL, 0x040fe20007f5e0ffULL,
0x0000000038227faeULL, 0x0003e2000b901c48ULL, 0x000000310a0a7210ULL, 0x000fe20007f7e0ffULL,
0x000000010b337824ULL, 0x000fc400000e0633ULL, 0x000000010b377824ULL, 0x040fe400010e0637ULL,
0x000000010b0b7824ULL, 0x000fe200018e063bULL, 0x0000000032247faeULL, 0x0003e8000b901c48ULL,
0x0000000034267faeULL, 0x0003e8000b901c48ULL, 0x0000000036287faeULL, 0x0003e8000b901c48ULL,
0x000000000a307faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x002fc40000015200ULL, 0x01b60400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fc40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ff000c7202ULL, 0x000fe20000000f00ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a060d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e07ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000000d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01b60400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000005d0200720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000000067919ULL, 0x000e620000000000ULL,
0x00005800ff697624ULL, 0x000fe200078e00ffULL, 0x8000580068737a10ULL, 0x000fe20007ffe0ffULL,
0x0000680079797a24ULL, 0x000fe200078e02ffULL, 0x0001b68800757811ULL, 0x040fe200078e18ffULL,
0x0000002000767824ULL, 0x000fe200078e00ffULL, 0x0000001f69077810ULL, 0x040fe40007ffe0ffULL,
0xffffffff69747810ULL, 0x000fe40007ffe0ffULL, 0x00000004ff077819ULL, 0x000fc40000011607ULL,
0x0000000969697810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff737819ULL, 0x000fe40000011673ULL,
0x0ffffffe076a7812ULL, 0x000fc400078ec0ffULL, 0x0000000102087810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff6d7424ULL, 0x000fe200078e00ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x00000004770a7224ULL, 0x000fe200078e02ffULL, 0x0000005d0800720cULL, 0x000fe20003f06070ULL,
0x0000010002077824ULL, 0x000fe400078e0278ULL, 0x000062000a0a7625ULL, 0x000fd400078e006dULL,
0x00000bb000008947ULL, 0x00cfea0003800000ULL, 0x00000003ff1a7819ULL, 0x002fe20000011606ULL,
0x0000001006087824ULL, 0x000fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x000000041a107810ULL, 0x040fe20007ffe0ffULL, 0x00000001050f7824ULL, 0x000fe200078e021aULL,
0x000000101a167810ULL, 0x040fe40007ffe0ffULL, 0x000000081a127810ULL, 0x000fe20007ffe0ffULL,
0x0000000110047824ULL, 0x100fe200078e0206ULL, 0x0000007008087812ULL, 0x000fe200078ec0ffULL,
0x0000000810257824ULL, 0x000fe200078e00ffULL, 0x00000003120e7819ULL, 0x000fe200000006ffULL,
0x0000000116117824ULL, 0x000fe200078e0206ULL, 0x00000080080c7812ULL, 0x000fe200078efcffULL,
0x00000008161c7824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee204ULL,
0x0000000112097824ULL, 0x000fe200078e0206ULL, 0x0000000768047217ULL, 0x000fe20007800000ULL,
0x0000000105137824ULL, 0x040fe200078e0212ULL, 0xfffffff81c2b7812ULL, 0x000fe200078ee211ULL,
0x0000000105117824ULL, 0x000fe200078e0210ULL, 0x0000000c1a147810ULL, 0x000fe20007ffe0ffULL,
0x00000001041b7824ULL, 0x000fe200078e0a07ULL, 0xfffffff80e277812ULL, 0x000fe200078ee209ULL,
0x000001000f0e7825ULL, 0x000fe200078e000cULL, 0x000000141a047810ULL, 0x000fc40007ffe0ffULL,
0x0000001b1000720cULL, 0x080fe20003f86070ULL, 0x0000010011107825ULL, 0x000fe200078e000cULL,
0x0000000e0a0e7210ULL, 0x000fe40007f1e0ffULL, 0x0000001b1200720cULL, 0x080fe20003f46070ULL,
0x0000000114097824ULL, 0x000fe200078e0206ULL, 0x000000100a207210ULL, 0x000fe20007f3e0ffULL,
0x0000000814187824ULL, 0x040fe200078e00ffULL, 0x0000001405157210ULL, 0x000fe20007ffe0ffULL,
0x0000010013127825ULL, 0x000fe200078e000cULL, 0x0000001b1400720cULL, 0x000fc40003f66070ULL,
0xfffffff818297812ULL, 0x000fe200078ee209ULL, 0x0000000105097824ULL, 0x000fe200078e0216ULL,
0x000000181a1e7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0f7824ULL, 0x000fe200000e060fULL,
0x0000001b1600720cULL, 0x000fe20003f06070ULL, 0x00000001051d7824ULL, 0x000fe200078e0204ULL,
0x000000120a167210ULL, 0x000fe20007fbe0ffULL, 0x000000010b217824ULL, 0x000fe200008e0611ULL,
0x0000000304227819ULL, 0x000fe200000006ffULL, 0x0000010009107825ULL, 0x000fe200078e000cULL,
0x0ffffff806097812ULL, 0x000fc400078ec0ffULL, 0x0000001c1a247810ULL, 0x040fe20007ffe0ffULL,
0x0000010015147825ULL, 0x000fe200078e000cULL, 0x000000201a287810ULL, 0x000fc60007ffe0ffULL,
0x000001001d1c7825ULL, 0x000fe200078e000cULL, 0x000000140a187210ULL, 0x000fc60007f3e0ffULL,
0x000000010b177824ULL, 0x040fe200028e0613ULL, 0x000000100a127210ULL, 0x040fe20007fbe0ffULL,
0x000000010b197824ULL, 0x040fe200008e0615ULL, 0x0000001c0a107210ULL, 0x000fe20007fde0ffULL,
0x000000011a1c7824ULL, 0x000fe200078e0206ULL, 0x0000001b0400720cULL, 0x080fe20003f26070ULL,
0x000000010b137824ULL, 0x040fe200028e0611ULL, 0x0000001b1a00720cULL, 0x000fe20003fa6070ULL,
0x000000010b117824ULL, 0x000fe200030e061dULL, 0x0000000709237812ULL, 0x000fe200078ef81cULL,
0x0000000105157824ULL, 0x000fc400078e021eULL, 0x00000001041d7824ULL, 0x000fe200078e0206ULL,
0x0000300000047811ULL, 0x000fe200078e70ffULL, 0x0000010015147825ULL, 0x000fc600078e000cULL,
0xfffffff8222d7812ULL, 0x000fe200078ee21dULL, 0x0000001023237824ULL, 0x000fe200078e0204ULL,
0x000000140a147210ULL, 0x000fe20007fde0ffULL, 0x00000001051d7824ULL, 0x000fe400078e0224ULL,
0x0000001025257824ULL, 0x000fe200078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e237faeULL, 0x0003e2000e901c48ULL, 0x000001001d1c7825ULL, 0x000fe200078e000cULL,
0x0000001b1e00720cULL, 0x080fe40003fa6070ULL, 0x0000000020257faeULL, 0x0005e2000e101c48ULL,
0x00000001051f7824ULL, 0x000fe200078e0228ULL, 0x0000001b2400720cULL, 0x000fe20003f86070ULL,
0x000000010b157824ULL, 0x000fe200030e0615ULL, 0x0000001c0a1c7210ULL, 0x000fe20007fde0ffULL,
0x000000011e227824ULL, 0x000fc400078e0206ULL, 0x000000081e2f7824ULL, 0x000fe200078e00ffULL,
0x0000000427237211ULL, 0x002fe200078e20ffULL, 0x000001001f1e7825ULL, 0x000fe200078e000cULL,
0x000000241a207810ULL, 0x004fc60007ffe0ffULL, 0x0000001029257824ULL, 0x000fe200078e0204ULL,
0x0000000016237faeULL, 0x0003e2000d101c48ULL, 0x000000010b1d7824ULL, 0x000fe200030e061dULL,
0x0000001e0a1e7210ULL, 0x000fe20007fde0ffULL, 0x00000001050f7824ULL, 0x000fe200078e0220ULL,
0x0000000018257faeULL, 0x0005e2000d901c48ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee222ULL,
0x0000000128217824ULL, 0x040fe200078e0206ULL, 0x0000001b2800720cULL, 0x080fe20003f66070ULL,
0x000001000f0e7825ULL, 0x000fe200078e000cULL, 0x0000001b2000720cULL, 0x000fc60003f46070ULL,
0x0000000124267824ULL, 0x000fe200078e0206ULL, 0x0000002c1a167810ULL, 0x002fe20007ffe0ffULL,
0x0000000824317824ULL, 0x000fe200078e00ffULL, 0x000000381a247810ULL, 0x000fe20007ffe0ffULL,
0x000000010b1f7824ULL, 0x000fe200030e061fULL, 0x000000042f197211ULL, 0x004fe200078e20ffULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee226ULL,
0x0000000120227824ULL, 0x000fe200078e0206ULL, 0x000000301a187810ULL, 0x000fe20007ffe0ffULL,
0x0000000820297824ULL, 0x000fe200078e00ffULL, 0x0000000e0a207210ULL, 0x000fe20007fde0ffULL,
0x000000102b177824ULL, 0x100fe200078e0204ULL, 0xfffffff828277812ULL, 0x000fe200078ee221ULL,
0x0000001031237824ULL, 0x000fe200078e0204ULL, 0x000000281a0e7810ULL, 0x040fe20007ffe0ffULL,
0x000000010b217824ULL, 0x000fe200030e060fULL, 0xfffffff829297812ULL, 0x000fe200078ee222ULL,
0x000000102d0f7824ULL, 0x100fe200078e0204ULL, 0x0000000012177faeULL, 0x0003e2000c101c48ULL,
0x0000001027257824ULL, 0x000fe200078e0204ULL, 0x000000341a227810ULL, 0x000fc40007ffe0ffULL,
0x00000000100f7faeULL, 0x0005e2000c901c48ULL, 0x0000003c1a1a7810ULL, 0x000fe40007ffe0ffULL,
0x0000001b0e00720cULL, 0x080fe20003fc6070ULL, 0x0000000014197faeULL, 0x0007e2000e901c48ULL,
0x0000001b1600720cULL, 0x080fe40003fa6070ULL, 0x0000001b2400720cULL, 0x080fe20003f26070ULL,
0x000000001c237faeULL, 0x0009e2000e101c48ULL, 0x0000001b1800720cULL, 0x080fe20003f86070ULL,
0x0000001029137824ULL, 0x002fe200078e0204ULL, 0x0000001b1a00720cULL, 0x080fe20003f06070ULL,
0x000000010e0f7824ULL, 0x044fe200078e0206ULL, 0x000000001e257faeULL, 0x0003e2000d901c48ULL,
0x000000080e107824ULL, 0x000fe200078e00ffULL, 0x0000001b2200720cULL, 0x000fe20003f66070ULL,
0x0000000105117824ULL, 0x040fe200078e0216ULL, 0x0000000020137faeULL, 0x0005e2000d101c48ULL,
0x0000000116127824ULL, 0x000fe200078e0206ULL, 0xfffffff8101b7812ULL, 0x000fe200078ee20fULL,
0x00000001050f7824ULL, 0x000fe200078e020eULL, 0x0000000618147210ULL, 0x008fe20007ffe0ffULL,
0x00000008161d7824ULL, 0x010fc400078e00ffULL, 0x000001000f0e7825ULL, 0x000fc600078e000cULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee212ULL, 0x00000008181f7824ULL, 0x002fe200078e00ffULL,
0x0000000e0a0e7210ULL, 0x000fe20007f5e0ffULL, 0x0000010011107825ULL, 0x000fc600078e000cULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee214ULL, 0x0000000105157824ULL, 0x000fe400078e0218ULL,
0x000000010b0f7824ULL, 0x000fe200010e060fULL, 0x000000100a147210ULL, 0x000fe20007f5e0ffULL,
0x0000010015127825ULL, 0x004fc800078e000cULL, 0x0000000122107824ULL, 0x040fe400078e0206ULL,
0x0000000822217824ULL, 0x000fe400078e00ffULL, 0x0000000105177824ULL, 0x000fe400078e0222ULL,
0x000000010b157824ULL, 0x000fe200010e0611ULL, 0x000000120a167210ULL, 0x000fe20007f5e0ffULL,
0x0000000105197824ULL, 0x000fe200078e0224ULL, 0xfffffff821217812ULL, 0x000fe200078ee210ULL,
0x0000010017107825ULL, 0x000fc800078e000cULL, 0x000000010b177824ULL, 0x000fe200010e0613ULL,
0x000000100a107210ULL, 0x000fe20007f5e0ffULL, 0x0000010019127825ULL, 0x000fe200078e000cULL,
0x0000001a05197210ULL, 0x000fc60007ffe0ffULL, 0x0000000124187824ULL, 0x140fe400078e0206ULL,
0x0000000824237824ULL, 0x000fe400078e00ffULL, 0x000000010b117824ULL, 0x000fe200010e0611ULL,
0x000000120a127210ULL, 0x000fe20007f5e0ffULL, 0x000000011a1c7824ULL, 0x040fe200078e0206ULL,
0xfffffff823237812ULL, 0x000fe200078ee218ULL, 0x000000081a257824ULL, 0x000fe400078e00ffULL,
0x00000100190c7825ULL, 0x000fc600078e000cULL, 0xfffffff825257812ULL, 0x000fe200078ee21cULL,
0x000000010b137824ULL, 0x000fe200010e0613ULL, 0x0000000c0a0a7210ULL, 0x000fe20007f5e0ffULL,
0x000000101b197824ULL, 0x100fe400078e0204ULL, 0x000000101d1b7824ULL, 0x100fe200078e0204ULL,
0x0000000d0b0b7210ULL, 0x000fe200017fe4ffULL, 0x000000101f1d7824ULL, 0x100fe200078e0204ULL,
0x000000000e197faeULL, 0x0003e2000f101c48ULL, 0x00000010211f7824ULL, 0x100fe400078e0204ULL,
0x0000001023217824ULL, 0x100fe200078e0204ULL, 0x00000000141b7faeULL, 0x0003e2000e901c48ULL,
0x0000001025237824ULL, 0x000fc600078e0204ULL, 0x00000000161d7faeULL, 0x0003e8000e101c48ULL,
0x00000000101f7faeULL, 0x0003e8000d901c48ULL, 0x0000000012217faeULL, 0x0003e8000c901c48ULL,
0x000000000a237faeULL, 0x0003e2000c101c48ULL, 0x00000a7000007947ULL, 0x000fea0003800000ULL,
0x00000004060c7811ULL, 0x042fe400078fe8ffULL, 0x0000000c06117811ULL, 0x000fc400078fe8ffULL,
0x00000008060f7811ULL, 0x000fe200078fe8ffULL, 0x000000010c047824ULL, 0x100fe200078e0206ULL,
0x0000001006137811ULL, 0x000fe200078fe8ffULL, 0x000000080c097824ULL, 0x000fe200078e00ffULL,
0x0000001406157811ULL, 0x040fe200078fe8ffULL, 0x0000000111087824ULL, 0x040fe200078e0206ULL,
0x00000020061c7811ULL, 0x040fe200078fe8ffULL, 0x0000000811197824ULL, 0x000fe200078e00ffULL,
0xfffffff8090e7812ULL, 0x000fe200078ee204ULL, 0x000000010f047824ULL, 0x040fe200078e0206ULL,
0x0000002c06227811ULL, 0x040fe200078fe8ffULL, 0x000000080f177824ULL, 0x000fe200078e00ffULL,
0xfffffff819127812ULL, 0x000fe200078ee208ULL, 0x0000000113097824ULL, 0x040fe200078e0206ULL,
0x0000001c06197811ULL, 0x040fe200078fe8ffULL, 0x0000000813147824ULL, 0x000fe200078e00ffULL,
0xfffffff817107812ULL, 0x000fe200078ee204ULL, 0x00000001150d7824ULL, 0x100fe200078e0206ULL,
0x0000001806177811ULL, 0x000fe200078fe8ffULL, 0x0000000119087824ULL, 0x140fe200078e0206ULL,
0xfffffff814147812ULL, 0x000fe200078ee209ULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0x00000024061d7811ULL, 0x040fe200078fe8ffULL, 0x0000000815167824ULL, 0x000fe200078e00ffULL,
0x0000000617047210ULL, 0x0c0fe20007ffe0ffULL, 0x00000008171b7824ULL, 0x000fe200078e00ffULL,
0x0000002806207811ULL, 0x000fe200078fe8ffULL, 0x000000011c097824ULL, 0x000fe200078e0206ULL,
0x0000003006247811ULL, 0x000fe200078fe8ffULL, 0x000000081c1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1a7812ULL, 0x000fe200078ee208ULL, 0x0000000122087824ULL, 0x100fe200078e0206ULL,
0xfffffff816167812ULL, 0x000fe200078ee20dULL, 0x000000011d0d7824ULL, 0x040fe200078e0206ULL,
0x00000003221f7819ULL, 0x000fe200000006ffULL, 0x000000081d2c7824ULL, 0x000fe200078e00ffULL,
0x0000003806287811ULL, 0x000fe200078fe8ffULL, 0x0000000824327824ULL, 0x000fe200078e00ffULL,
0xfffffff81b187812ULL, 0x000fe200078ee204ULL, 0x0000000120047824ULL, 0x100fe200078e0206ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee209ULL, 0x00000008201b7824ULL, 0x000fe200078e00ffULL,
0x0000003406267811ULL, 0x000fe200078fe8ffULL, 0x0000000124097824ULL, 0x000fe200078e0206ULL,
0x0000003c062a7811ULL, 0x000fe200078fe8ffULL, 0x0000000105237824ULL, 0x000fe200078e020fULL,
0xfffffff81f307812ULL, 0x000fe200078ee208ULL, 0x0000000128087824ULL, 0x000fe200078e0206ULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee20dULL, 0x00000008281f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81b2e7812ULL, 0x000fe200078ee204ULL, 0x00000001260d7824ULL, 0x100fe200078e0206ULL,
0xfffffff832327812ULL, 0x000fe200078ee209ULL, 0x0000000826347824ULL, 0x000fe200078e00ffULL,
0x0000000606047211ULL, 0x000fe200078fe8ffULL, 0x000000012a1b7824ULL, 0x000fe200078e0206ULL,
0x0ffffff806097812ULL, 0x000fe200078ec0ffULL, 0x000000082a387824ULL, 0x000fe200078e00ffULL,
0xfffffff81f367812ULL, 0x000fe200078ee208ULL, 0x0000001006087824ULL, 0x000fe200078e00ffULL,
0xfffffff834347812ULL, 0x000fe200078ee20dULL, 0x00000001050f7824ULL, 0x000fe200078e021dULL,
0x00003000000d7811ULL, 0x000fe200078e70ffULL, 0x000000ffff1d7224ULL, 0x000fe200078e00ffULL,
0x0000000709047812ULL, 0x000fe200078ef804ULL, 0x0000000105217824ULL, 0x000fe200078e020cULL,
0xfffffff838387812ULL, 0x000fe200078ee21bULL, 0x0000001010317824ULL, 0x100fe200078e020dULL,
0x0000007008087812ULL, 0x000fe200078ec0ffULL, 0x00000010042d7824ULL, 0x100fe200078e020dULL,
0x0000000d0e2f7211ULL, 0x080fe200078e20ffULL, 0x0000001012337824ULL, 0x100fe200078e020dULL,
0x0000000d32327211ULL, 0x000fe200078e20ffULL, 0x0000001014357824ULL, 0x100fe200078e020dULL,
0x00000005061f7211ULL, 0x000fe200078fe8ffULL, 0x0000001016377824ULL, 0x000fc400078e020dULL,
0x0000001018397824ULL, 0x100fe400078e020dULL, 0x000000101a3b7824ULL, 0x100fe400078e020dULL,
0x000000101e047824ULL, 0x100fe400078e020dULL, 0x000000102c2c7824ULL, 0x100fe400078e020dULL,
0x000000102e2e7824ULL, 0x100fe400078e020dULL, 0x0000001030307824ULL, 0x000fc400078e020dULL,
0x0000001034347824ULL, 0x100fe400078e020dULL, 0x0000001036367824ULL, 0x100fe400078e020dULL,
0x0000001038387824ULL, 0x000fe200078e020dULL, 0x0000001c050d7210ULL, 0x040fe20007ffe0ffULL,
0x0000000105257824ULL, 0x040fe200078e0211ULL, 0x00000080081c7812ULL, 0x000fe200078efcffULL,
0x0000000105277824ULL, 0x040fe400078e0213ULL, 0x0000000105297824ULL, 0x000fc400078e0215ULL,
0x000001001f1e7825ULL, 0x000fc800078e001cULL, 0x0000000105117824ULL, 0x040fe200078e0220ULL,
0x0000001e0a1e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000105137824ULL, 0x040fe400078e0222ULL,
0x0000000105157824ULL, 0x000fe400078e0224ULL, 0x0000010021207825ULL, 0x000fc800078e001cULL,
0x0000010023227825ULL, 0x000fe200078e001cULL, 0x000000200a207210ULL, 0x000fc60007f3e0ffULL,
0x0000010025247825ULL, 0x000fe200078e001cULL, 0x000000220a227210ULL, 0x000fc60007f5e0ffULL,
0x00000001052b7824ULL, 0x040fe200078e0217ULL, 0x000000240a247210ULL, 0x000fe20007f7e0ffULL,
0x00000001051b7824ULL, 0x000fe200078e0219ULL, 0x000000230b237210ULL, 0x000fe200017fe4ffULL,
0x0000000105177824ULL, 0x000fe400078e0226ULL, 0x0000010027267825ULL, 0x000fc800078e001cULL,
0x0000000105197824ULL, 0x040fe400078e0228ULL, 0x00000001053d7824ULL, 0x000fe400078e022aULL,
0x0000010029287825ULL, 0x000fc800078e001cULL, 0x000001002b2a7825ULL, 0x000fc800078e001cULL,
0x000001001b1a7825ULL, 0x000fe200078e001cULL, 0x0000002a0a2a7210ULL, 0x000fc60007f5e0ffULL,
0x000000010b1f7824ULL, 0x000fe200000e061fULL, 0x000000260a267210ULL, 0x000fe20007f1e0ffULL,
0x000001000d0c7825ULL, 0x000fc600078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e2d7faeULL, 0x0003e2000b901c48ULL, 0x000000010b217824ULL, 0x040fe200008e0621ULL,
0x000000280a287210ULL, 0x040fe20007f3e0ffULL, 0x000000010b257824ULL, 0x000fe200018e0625ULL,
0x0000001a0a1a7210ULL, 0x040fe20007f7e0ffULL, 0x000001000f0e7825ULL, 0x100fe200078e001cULL,
0x00000000202f7faeULL, 0x0003e6000b901c48ULL, 0x0000010011107825ULL, 0x100fe200078e001cULL,
0x0000000022317faeULL, 0x0003e6000b901c48ULL, 0x0000010013127825ULL, 0x000fe200078e001cULL,
0x0000000024337faeULL, 0x0003e6000b901c48ULL, 0x000000010b277824ULL, 0x000fe200000e0627ULL,
0x0000000c0a0c7210ULL, 0x000fe20007f1e0ffULL, 0x0000010015147825ULL, 0x000fc600078e001cULL,
0x0000000026357faeULL, 0x0003e2000b901c48ULL, 0x000000010b297824ULL, 0x040fe200008e0629ULL,
0x0000000e0a0e7210ULL, 0x040fe20007f3e0ffULL, 0x000000010b2b7824ULL, 0x040fe200010e062bULL,
0x000000100a107210ULL, 0x040fe20007f5e0ffULL, 0x000000010b1b7824ULL, 0x000fe200018e061bULL,
0x000000120a127210ULL, 0x040fe20007f7e0ffULL, 0x0000010017167825ULL, 0x100fe200078e001cULL,
0x0000000028377faeULL, 0x0003e6000b901c48ULL, 0x0000010019187825ULL, 0x100fe200078e001cULL,
0x000000002a397faeULL, 0x0003e6000b901c48ULL, 0x000001003d1c7825ULL, 0x000fe200078e001cULL,
0x000000001a3b7faeULL, 0x0003e6000b901c48ULL, 0x000000010b0d7824ULL, 0x040fe200000e060dULL,
0x000000140a147210ULL, 0x040fe20007f1e0ffULL, 0x000000010b0f7824ULL, 0x040fe200008e060fULL,
0x000000160a167210ULL, 0x040fe20007f3e0ffULL, 0x000000010b117824ULL, 0x040fe200010e0611ULL,
0x000000180a187210ULL, 0x040fe20007f5e0ffULL, 0x000000010b137824ULL, 0x040fe200018e0613ULL,
0x0000001c0a0a7210ULL, 0x000fe20007f7e0ffULL, 0x000000010b157824ULL, 0x040fe200000e0615ULL,
0x000000170b177210ULL, 0x040fe20000ffe4ffULL, 0x000000000c047faeULL, 0x0003e2000b901c48ULL,
0x000000010b197824ULL, 0x000fc400010e0619ULL, 0x000000010b0b7824ULL, 0x000fe200018e061dULL,
0x000000000e2c7faeULL, 0x0003e8000b901c48ULL, 0x00000000102e7faeULL, 0x0003e8000b901c48ULL,
0x0000000012307faeULL, 0x0003e8000b901c48ULL, 0x0000000014327faeULL, 0x0003e8000b901c48ULL,
0x0000000016347faeULL, 0x0003e8000b901c48ULL, 0x0000000018367faeULL, 0x0003e8000b901c48ULL,
0x000000000a387faeULL, 0x0003e4000b901c48ULL, 0x0000000403037810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff047424ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000006c0300720cULL, 0x000fda0003f06070ULL, 0x00000002790c8824ULL, 0x000fe400078e0203ULL,
0x00000004ff0d8424ULL, 0x000fc800078e00ffULL, 0x000064000c0c8625ULL, 0x000fe200078e000dULL,
0x0000000706117812ULL, 0x000fe400078ec0ffULL, 0x00000004ff0f7819ULL, 0x000fe20000011606ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000080c048981ULL, 0x000322000c1e1900ULL,
0x00000008110a7812ULL, 0x000fe200078ef806ULL, 0xffffffff00007948ULL, 0x000fe80003800000ULL,
0x000000010f0b7824ULL, 0x000fe400078e020aULL, 0x000000100a0e7824ULL, 0x000fca00078e00ffULL,
0xfffffff00e0e7812ULL, 0x000fca00078ee20bULL, 0x000000100e0e7824ULL, 0x000fc400078e00ffULL,
0x000000080f367824ULL, 0x002fe200078e00ffULL, 0x00000003ff647819ULL, 0x000fe20000011606ULL,
0x00004000000c7824ULL, 0x000fe200078e00ffULL, 0x000000000e2c783bULL, 0x0003e20000000200ULL,
0x000000100a137824ULL, 0x000fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fe400078ee211ULL,
0x0000000164117812ULL, 0x000fe400078ec0ffULL, 0x000010000c0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000836107824ULL, 0x040fe200078e00ffULL, 0x00000036110f7210ULL, 0x000fe20007ffe0ffULL,
0x0000000836157824ULL, 0x040fe200078e00ffULL, 0x00000030360e7810ULL, 0x002fc40007ffe0ffULL,
0xfffffff8105b7812ULL, 0x000fe400078ee20fULL, 0x000000020b107810ULL, 0x000fe40007ffe0ffULL,
0x0000001036357810ULL, 0x000fe20007ffe0ffULL, 0x000000105b1c7824ULL, 0x000fe200078e020dULL,
0xfffffff013107812ULL, 0x000fe200078ee210ULL, 0x000000080e137824ULL, 0x000fe200078e00ffULL,
0x0000000e11607210ULL, 0x040fe20007ffe0ffULL, 0x00000001115f7824ULL, 0x000fe200078e0235ULL,
0x0000002036347810ULL, 0x000fe20007ffe0ffULL, 0x000000001c1c783bULL, 0x000e620000000200ULL,
0x0000000835127824ULL, 0x000fe200078e00ffULL, 0xfffffff813607812ULL, 0x000fe200078ee260ULL,
0x0000001010287824ULL, 0x000fe200078e00ffULL, 0x000000020f627810ULL, 0x000fe20007ffe0ffULL,
0x00000001115e7824ULL, 0x000fe200078e0234ULL, 0xfffffff8125f7812ULL, 0x000fe200078ee25fULL,
0x0000000834117824ULL, 0x000fe200078e00ffULL, 0xfffffff815627812ULL, 0x000fe200078ee262ULL,
0x0000001060307824ULL, 0x100fe200078e020dULL, 0x000000002828783bULL, 0x000fe20000000200ULL,
0x000000105f387824ULL, 0x100fe200078e020dULL, 0xfffffff8115e7812ULL, 0x000fe200078ee25eULL,
0x0000001062507824ULL, 0x100fe200078e020dULL, 0x000000120f637810ULL, 0x000fe20007ffe0ffULL,
0x000000003030783bULL, 0x000ea20000000200ULL, 0x0000000835147824ULL, 0x000fe200078e00ffULL,
0x000000220f667810ULL, 0x000fe20007ffe0ffULL, 0x000000105e107824ULL, 0x000fe200078e020dULL,
0x000000003838783bULL, 0x000ee20000000200ULL, 0x0000000834157824ULL, 0x000fe200078e00ffULL,
0xfffffff814637812ULL, 0x000fc400078ee263ULL, 0x000000005050783bULL, 0x000ee20000000200ULL,
0x000000320f657810ULL, 0x000fe40007ffe0ffULL, 0x0000001063187824ULL, 0x100fe200078e020dULL,
0x000000001010783bULL, 0x000ee20000000200ULL, 0xfffffff815667812ULL, 0x000fe400078ee266ULL,
0x000000040b377810ULL, 0x000fe40007ffe0ffULL, 0x000000001818783bULL, 0x000ee20000000200ULL,
0x0000001066207824ULL, 0x000fe200078e020dULL, 0x000000040f617810ULL, 0x000fc40007ffe0ffULL,
0x000000140f5c7810ULL, 0x040fe40007ffe0ffULL, 0x000000240f677810ULL, 0x040fe20007ffe0ffULL,
0x000000002020783bULL, 0x000ee20000000200ULL, 0x0000001c2c54723cULL, 0x002f6200000018ffULL,
0x000000340f5a7810ULL, 0x040fe40007ffe0ffULL, 0x000000060f597810ULL, 0x040fe40007ffe0ffULL,
0x000000160f587810ULL, 0x000fc60007ffe0ffULL, 0x0000001e2c1c723cULL, 0x040f7000000018ffULL,
0x000000302c24723cULL, 0x044bee00000018ffULL, 0x000000080e307824ULL, 0x020fe200078e00ffULL,
0x000000382c14723cULL, 0x008f6800000018ffULL, 0xfffffff830657812ULL, 0x000fc800078ee265ULL,
0x0000003a2c38723cULL, 0x000f6200000018ffULL, 0x0000001065307824ULL, 0x000fce00078e020dULL,
0x000000502854723cULL, 0x040ff00000001854ULL, 0x000000522850723cULL, 0x000ff0000000181cULL,
0x000000102c1c723cULL, 0x040f7000000018ffULL, 0x000000122c10723cULL, 0x040f7000000018ffULL,
0x000000322c2c723cULL, 0x000b6400000018ffULL, 0x000000003030783bULL, 0x020e6c0000000200ULL,
0x000000182814723cULL, 0x040ff00000001814ULL, 0x0000001a2818723cULL, 0x040bee0000001838ULL,
0x000000040a387819ULL, 0x020fe200000006ffULL, 0x00000020281c723cULL, 0x000b62000000181cULL,
0x000000080e397824ULL, 0x000fc400078e00ffULL, 0xfffffff038377812ULL, 0x000fe200078ee237ULL,
0x0000000834387824ULL, 0x000fe400078e00ffULL, 0xfffffff8395a7812ULL, 0x000fe200078ee25aULL,
0x0000000836207824ULL, 0x020fe400078e00ffULL, 0x0000000835217824ULL, 0x000fe200078e00ffULL,
0xfffffff838677812ULL, 0x000fe200078ee267ULL, 0x0000001037377824ULL, 0x000fe200078e00ffULL,
0xfffffff820617812ULL, 0x000fe200078ee261ULL, 0x000000100a397824ULL, 0x000fe200078e00ffULL,
0xfffffff8215c7812ULL, 0x000fe200078ee25cULL, 0x0000001067487824ULL, 0x100fe200078e020dULL,
0x000000222820723cULL, 0x040b620000001810ULL, 0x0000000d5a447211ULL, 0x000fe200078e20ffULL,
0x000000003740783bULL, 0x000fe20000000200ULL, 0x000000105c4c7824ULL, 0x100fe200078e020dULL,
0x000000060b387810ULL, 0x000fe20007ffe0ffULL, 0x0000000836367824ULL, 0x000fe200078e00ffULL,
0x000000004848783bULL, 0x000ea20000000200ULL, 0x0000001061107824ULL, 0x020fe200078e020dULL,
0x000000302824723cULL, 0x002b620000001824ULL, 0x0000000835357824ULL, 0x000fe200078e00ffULL,
0x000000004c4c783bULL, 0x000fe20000000200ULL, 0xfffffff039387812ULL, 0x000fc400078ee238ULL,
0xfffffff836597812ULL, 0x000fe200078ee259ULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x0000000834317824ULL, 0x020fe200078e00ffULL, 0x000000260f307810ULL, 0x040fe20007ffe0ffULL,
0x000000080e347824ULL, 0x000fe200078e00ffULL, 0x000000004444783bULL, 0x000ee20000000200ULL,
0x000000360f0f7810ULL, 0x000fe20007ffe0ffULL, 0x000000322828723cULL, 0x000b62000000182cULL,
0xfffffff835587812ULL, 0x000fe200078ee258ULL, 0x00000010386e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8310e7812ULL, 0x000fe200078ee230ULL, 0x00000010593c7824ULL, 0x000fe200078e020dULL,
0xfffffff8340f7812ULL, 0x000fe200078ee20fULL, 0x0000001058387824ULL, 0x100fe200078e020dULL,
0x000000006e2c783bULL, 0x020fe20000000200ULL, 0x000000100e347824ULL, 0x000fc400078e020dULL,
0x000000100f307824ULL, 0x000fe200078e020dULL, 0x000000003c3c783bULL, 0x000ee80000000200ULL,
0x000000003838783bULL, 0x000ee80000000200ULL, 0x000000003434783bULL, 0x000ee80000000200ULL,
0x000000003030783bULL, 0x000ee20000000200ULL, 0x00000048401c723cULL, 0x044bee000000181cULL,
0x0000030002487a10ULL, 0x020fe20007ffe0ffULL, 0x000000104054723cULL, 0x042b6e0000001854ULL,
0x0000000148107810ULL, 0x020fe20007ffe0ffULL, 0x000000124050723cULL, 0x000f660000001850ULL,
0x0000005d1000720cULL, 0x000fe20003f06070ULL, 0x0000007704107224ULL, 0x010fc800078e02ffULL,
0x0000004c4014723cULL, 0x000f620000001814ULL, 0x0000620010107625ULL, 0x000fce00078e006dULL,
0x0000004e4018723cULL, 0x040f700000001818ULL, 0x0000004a4020723cULL, 0x040f700000001820ULL,
0x000000444024723cULL, 0x048f700000001824ULL, 0x000000464028723cULL, 0x000f700000001828ULL,
0x0000003c2c54723cULL, 0x040b700000001854ULL, 0x0000003e2c50723cULL, 0x060b700000001850ULL,
0x000000382c14723cULL, 0x040b700000001814ULL, 0x0000003a2c18723cULL, 0x040b700000001818ULL,
0x000000342c1c723cULL, 0x040b70000000181cULL, 0x000000362c20723cULL, 0x040b700000001820ULL,
0x000000302c24723cULL, 0x040b700000001824ULL, 0x000000322c28723cULL, 0x000b620000001828ULL,
0x00000c5000008947ULL, 0x000fce0003800000ULL, 0x0000010048137824ULL, 0x000fe200078e0278ULL,
0x00000014646e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000164367824ULL, 0x060fe200078e0206ULL,
0x0000001064727810ULL, 0x000fe20007ffe0ffULL, 0x0000000105307824ULL, 0x000fe200078e0264ULL,
0x0000001368127217ULL, 0x000fe20007800000ULL, 0x000000016e4a7824ULL, 0x000fe200078e0206ULL,
0x0000000709367812ULL, 0x000fe200078ef836ULL, 0x0000000172497824ULL, 0x100fe200078e0206ULL,
0x0000001864427810ULL, 0x000fe20007ffe0ffULL, 0x0000000112097824ULL, 0x000fe200078e0a13ULL,
0x0000000864387810ULL, 0x000fe20007ffe0ffULL, 0x000000086e137824ULL, 0x000fe200078e00ffULL,
0x0000000642447210ULL, 0x000fe20007ffe0ffULL, 0x00000008722c7824ULL, 0x000fe200078e00ffULL,
0x00000028644e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000138467824ULL, 0x000fe200078e0206ULL,
0xfffffff8134a7812ULL, 0x000fe200078ee24aULL, 0x0000000842137824ULL, 0x000fe200078e00ffULL,
0x0000002c64457810ULL, 0x000fe20007ffe0ffULL, 0x00000008382f7824ULL, 0x000fe200078e00ffULL,
0x00000004643a7810ULL, 0x000fe20007ffe0ffULL, 0x000000084e2e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82c497812ULL, 0x000fe200078ee249ULL, 0x00000001452c7824ULL, 0x000fe200078e0206ULL,
0xfffffff813447812ULL, 0x000fe200078ee244ULL, 0x000000014e137824ULL, 0x000fe200078e0206ULL,
0xfffffff82f467812ULL, 0x000fe200078ee246ULL, 0x0000000105347824ULL, 0x000fe200078e023aULL,
0x00000003452f7819ULL, 0x000fe200000006ffULL, 0x0000000105327824ULL, 0x000fe200078e0238ULL,
0x0000003464417810ULL, 0x000fe20007ffe0ffULL, 0x0000010034347825ULL, 0x000fe200078e00ffULL,
0xfffffff82e137812ULL, 0x000fc400078ee213ULL, 0xfffffff82f2c7812ULL, 0x000fe200078ee22cULL,
0x00000001412e7824ULL, 0x040fe200078e0206ULL, 0x00000008343b7212ULL, 0x000fe200078efcffULL,
0x00000008412f7824ULL, 0x000fe200078e00ffULL, 0x000000096400720cULL, 0x000fe20003fa6070ULL,
0x0000010030307825ULL, 0x000fe200078e00ffULL, 0x000000063a3c7210ULL, 0x000fe40007ffe0ffULL,
0xfffffff82f2e7812ULL, 0x000fe200078ee22eULL, 0x0000010032327825ULL, 0x000fe200078e00ffULL,
0x00000008302f7212ULL, 0x000fc400078efcffULL, 0x000000093a00720cULL, 0x0c0fe20003f86070ULL,
0x000000083a2d7824ULL, 0x000fe200078e00ffULL, 0x0000000832397212ULL, 0x000fe200078efcffULL,
0x0000000105347824ULL, 0x000fe200078e0272ULL, 0x000000093800720cULL, 0x000fe20003f06070ULL,
0x00000010363d7824ULL, 0x100fe200078e020dULL, 0x0000003b103a7210ULL, 0x000fe20007f5e0ffULL,
0x0000001049497824ULL, 0x100fe200078e020dULL, 0x0000000c64707810ULL, 0x000fe20007ffe0ffULL,
0x0000001013137824ULL, 0x000fe200078e020dULL, 0x0000002f10307210ULL, 0x040fe20007f3e0ffULL,
0x00000001113b7824ULL, 0x000fe200010e0635ULL, 0x0000003910387210ULL, 0x000fe20007f7e0ffULL,
0x0000010034347825ULL, 0x000fe200078e00ffULL, 0x0000007005327210ULL, 0x000fc40007ffe0ffULL,
0x0000003864437810ULL, 0x000fe20007ffe0ffULL, 0x0000000111317824ULL, 0x040fe200008e0631ULL,
0x0000000834377212ULL, 0x080fe200078efcffULL, 0x0000000111397824ULL, 0x000fe200018e0633ULL,
0x000000096e00720cULL, 0x000fe20003f66070ULL, 0x00000001056e7824ULL, 0x000fe200078e026eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000303d7faeULL, 0x0003e2000e901c48ULL,
0x0000010032327825ULL, 0x000fe200078e00ffULL, 0x0000001c644b7810ULL, 0x000fe40007ffe0ffULL,
0x0000003710367210ULL, 0x000fe20007fde0ffULL, 0x0000000143347824ULL, 0x040fe200078e0206ULL,
0x00000008322f7212ULL, 0x000fe200078efcffULL, 0x00000008436d7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d3c7812ULL, 0x000fe200078ee23cULL, 0x0000000111377824ULL, 0x000fe200030e0635ULL,
0x0000002f10327210ULL, 0x000fe20007fbe0ffULL, 0x0000000170477824ULL, 0x000fe200078e0206ULL,
0xfffffff86d2f7812ULL, 0x000fe200078ee234ULL, 0x000001006e307825ULL, 0x002fe200078e00ffULL,
0x000000097000720cULL, 0x000fc40003f26070ULL, 0x000000097200720cULL, 0x000fe20003f46070ULL,
0x00000001053d7824ULL, 0x040fe200078e024bULL, 0x00000008304f7212ULL, 0x000fe200078efcffULL,
0x0000000870127824ULL, 0x000fe200078e00ffULL, 0x00000020644c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105307824ULL, 0x000fe200078e0242ULL, 0x0000004f10347210ULL, 0x000fe20007fde0ffULL,
0x0000000111337824ULL, 0x000fe200028e0633ULL, 0x0000000d3c4f7211ULL, 0x000fe200078e20ffULL,
0x000001003d3c7825ULL, 0x000fe200078e00ffULL, 0xfffffff812477812ULL, 0x000fc400078ee247ULL,
0x00000024644d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000111357824ULL, 0x000fe200030e0631ULL,
0x000000083c6d7212ULL, 0x080fe200078efcffULL, 0x000000003a4f7faeULL, 0x0003e2000e101c48ULL,
0x0000010030307825ULL, 0x000fe200078e00ffULL, 0x000000094200720cULL, 0x000fe40003fa6070ULL,
0x0000003064407810ULL, 0x000fe20007ffe0ffULL, 0x0000001047477824ULL, 0x100fe200078e020dULL,
0x00000008306f7212ULL, 0x000fe200078efcffULL, 0x000000014b3f7824ULL, 0x140fe200078e0206ULL,
0x0000003c64647810ULL, 0x000fe20007ffe0ffULL, 0x000000084b127824ULL, 0x000fe200078e00ffULL,
0x0000006f10307210ULL, 0x000fe20007f9e0ffULL, 0x000000014c3e7824ULL, 0x000fe200078e0206ULL,
0x0000006d103a7210ULL, 0x002fe20007fde0ffULL, 0x00000010466d7824ULL, 0x000fe200078e020dULL,
0xfffffff8123f7812ULL, 0x000fe200078ee23fULL, 0x000000084c2d7824ULL, 0x000fc400078e00ffULL,
0x00000001113b7824ULL, 0x000fe200030e063dULL, 0x00000000386d7faeULL, 0x0003e2000c101c48ULL,
0x000000104a3d7824ULL, 0x000fe200078e020dULL, 0xfffffff82d3e7812ULL, 0x000fe200078ee23eULL,
0x000000014d127824ULL, 0x040fe200078e0206ULL, 0x0000000032477faeULL, 0x0005e2000c901c48ULL,
0x000000084d2d7824ULL, 0x000fe200078e00ffULL, 0x000000094e00720cULL, 0x080fe20003f06070ULL,
0x0000000111317824ULL, 0x000fe200020e0631ULL, 0x0000000036497faeULL, 0x0007e2000d101c48ULL,
0x000000094b00720cULL, 0x080fe20003f86070ULL, 0x00000010444b7824ULL, 0x000fe200078e020dULL,
0x000000094c00720cULL, 0x080fe20003f46070ULL, 0x00000000343d7faeULL, 0x0009e2000d901c48ULL,
0x000000094d00720cULL, 0x080fe20003f66070ULL, 0x00000001054d7824ULL, 0x040fe200078e024dULL,
0x0000004e054e7210ULL, 0x040fe20007ffe0ffULL, 0x0000000105327824ULL, 0x004fe200078e0245ULL,
0x00000000304b7faeULL, 0x0005e2000e901c48ULL, 0x000001004d387825ULL, 0x002fe200078e00ffULL,
0x000000094500720cULL, 0x000fc40003f26070ULL, 0xfffffff82d127812ULL, 0x000fe200078ee212ULL,
0x00000001054c7824ULL, 0x000fe200078e024cULL, 0x00000008383d7212ULL, 0x010fe200078efcffULL,
0x0000010032327825ULL, 0x000fc600078e00ffULL, 0x0000003d10307210ULL, 0x004fe20007fbe0ffULL,
0x0000000105387824ULL, 0x000fe200078e0240ULL, 0x00000008323d7212ULL, 0x000fe200078efcffULL,
0x000001004c367825ULL, 0x008fc800078e00ffULL, 0x0000000111317824ULL, 0x000fe200028e0639ULL,
0x0000000836457212ULL, 0x080fe200078efcffULL, 0x0000010038387825ULL, 0x000fe200078e00ffULL,
0x0000003d10327210ULL, 0x040fe40007fbe0ffULL, 0x0000004510367210ULL, 0x000fe20007fde0ffULL,
0x000000103f3f7824ULL, 0x000fe200078e020dULL, 0x00000008383d7212ULL, 0x000fe200078efcffULL,
0x000001004e347825ULL, 0x000fc600078e00ffULL, 0x000000003a3f7faeULL, 0x0003e2000e101c48ULL,
0x00000001053c7824ULL, 0x000fe200078e0241ULL, 0x0000000834457212ULL, 0x000fe200078efcffULL,
0x0000000111337824ULL, 0x000fe200028e0633ULL, 0x0000003d10387210ULL, 0x000fe20007fbe0ffULL,
0x00000001053d7824ULL, 0x000fe200078e0243ULL, 0x000000094100720cULL, 0x000fe20003f86070ULL,
0x0000000111377824ULL, 0x040fe200030e0637ULL, 0x0000000d3e417211ULL, 0x000fe200078e20ffULL,
0x0000000111397824ULL, 0x000fe200028e0639ULL, 0x0000004510347210ULL, 0x000fe20007fde0ffULL,
0x0000001012457824ULL, 0x000fc400078e020dULL, 0x000001003c3a7825ULL, 0x002fe200078e00ffULL,
0x0000000036417faeULL, 0x0003e6000d101c48ULL, 0x000001003d3c7825ULL, 0x000fe200078e00ffULL,
0x000000083a477212ULL, 0x080fe200078efcffULL, 0x0000000030457faeULL, 0x0005e2000d901c48ULL,
0x000000094300720cULL, 0x000fe20003f66070ULL, 0x0000000105127824ULL, 0x000fe200078e0264ULL,
0x000000083c3f7212ULL, 0x000fe200078efcffULL, 0x00000001402d7824ULL, 0x000fc400078e0206ULL,
0x00000008407a7824ULL, 0x000fe200078e00ffULL, 0x0000004710367210ULL, 0x002fe20007fbe0ffULL,
0x0000000111357824ULL, 0x040fe200030e0635ULL, 0x000000094000720cULL, 0x000fe20003fc6070ULL,
0x0000000164427824ULL, 0x000fe200078e0206ULL, 0x0000003f103a7210ULL, 0x000fe20007f5e0ffULL,
0x0000010012307825ULL, 0x004fe200078e00ffULL, 0xfffffff87a2d7812ULL, 0x000fe200078ee22dULL,
0x0000000034137faeULL, 0x0003e4000c101c48ULL, 0x0000000111377824ULL, 0x040fe200028e063bULL,
0x000000096400720cULL, 0x040fe20003fa6070ULL, 0x0000000864717824ULL, 0x000fe200078e00ffULL,
0x0000000830097212ULL, 0x000fe200078efcffULL, 0x00000001113b7824ULL, 0x000fc400010e063dULL,
0x000000102c3d7824ULL, 0x100fe200078e020dULL, 0x0000000910087210ULL, 0x000fe20007f5e0ffULL,
0x000000102d2d7824ULL, 0x100fe200078e020dULL, 0xfffffff871427812ULL, 0x000fe200078ee242ULL,
0x000000102e3f7824ULL, 0x100fe200078e020dULL, 0x00000000323d7faeULL, 0x0003e2000c901c48ULL,
0x000000102f2f7824ULL, 0x000fe200078e020dULL, 0x0000000d420d7211ULL, 0x000fe200078e20ffULL,
0x0000000111097824ULL, 0x000fe200010e0631ULL, 0x00000000382d7faeULL, 0x0003e8000f101c48ULL,
0x00000000363f7faeULL, 0x0003e8000e101c48ULL, 0x000000003a2f7faeULL, 0x0003e8000d901c48ULL,
0x00000000080d7faeULL, 0x0003e2000e901c48ULL, 0x00000b1000007947ULL, 0x000fea0003800000ULL,
0x0000000105127824ULL, 0x000fe200078e0264ULL, 0x0000000464707810ULL, 0x000fc40007ffe0ffULL,
0x00000008646f7810ULL, 0x000fe20007ffe0ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x00000010646d7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c646e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001052e7824ULL, 0x020fe200078e0270ULL, 0x00000008122d7212ULL, 0x000fe200078efcffULL,
0x0000000164127824ULL, 0x040fe200078e0206ULL, 0x00000014644e7810ULL, 0x000fe20007ffe0ffULL,
0x000001002e2e7825ULL, 0x000fe200078e00ffULL, 0x0000002d102c7210ULL, 0x000fc40007f1e0ffULL,
0x0000000709097812ULL, 0x000fe200078ef812ULL, 0x0000000105127824ULL, 0x000fe200078e026fULL,
0x000000082e437212ULL, 0x080fe200078efcffULL, 0x00000001112d7824ULL, 0x000fe200000e0613ULL,
0x00000018644d7810ULL, 0x000fe20007ffe0ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000004310427210ULL, 0x000fe40007f1e0ffULL, 0x0000001c644c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105307824ULL, 0x040fe200078e026dULL, 0x0000000812357212ULL, 0x000fe200078efcffULL,
0x0000000105327824ULL, 0x000fe200078e026eULL, 0x0000002064497810ULL, 0x000fe20007ffe0ffULL,
0x0000010030307825ULL, 0x000fe200078e00ffULL, 0x00000024644a7810ULL, 0x000fc40007ffe0ffULL,
0x00000028644b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001052e7824ULL, 0x000fe200078e024eULL,
0x00000008303f7212ULL, 0x000fe200078efcffULL, 0x0000000111437824ULL, 0x040fe200000e062fULL,
0x0000003510127210ULL, 0x000fe20007f1e0ffULL, 0x0000010032327825ULL, 0x000fe200078e00ffULL,
0x0000002c644f7810ULL, 0x000fe40007ffe0ffULL, 0x0000001311137210ULL, 0x000fe200007fe4ffULL,
0x000001002e2e7825ULL, 0x000fe200078e00ffULL, 0x0000003f103e7210ULL, 0x000fc40007f1e0ffULL,
0x0000000832417212ULL, 0x080fe200078efcffULL, 0x0000000105347824ULL, 0x040fe200078e024dULL,
0x000000082e3d7212ULL, 0x080fe200078efcffULL, 0x0000000105307824ULL, 0x000fe200078e024cULL,
0x0000004110407210ULL, 0x000fe20007f3e0ffULL, 0x0000010034347825ULL, 0x000fe200078e00ffULL,
0x0000003464727810ULL, 0x040fe40007ffe0ffULL, 0x0000003064717810ULL, 0x000fe20007ffe0ffULL,
0x00000001113f7824ULL, 0x000fe200000e0631ULL, 0x0000003d103c7210ULL, 0x000fe20007f1e0ffULL,
0x0000010030307825ULL, 0x000fe200078e00ffULL, 0x00000008343b7212ULL, 0x000fc400078efcffULL,
0x00000038647a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000105327824ULL, 0x040fe200078e0249ULL,
0x0000000830397212ULL, 0x000fe200078efcffULL, 0x00000001052e7824ULL, 0x000fe200078e024aULL,
0x0000003c64647810ULL, 0x000fe20007ffe0ffULL, 0x0000000111417824ULL, 0x040fe200008e0633ULL,
0x0000003910387210ULL, 0x040fe20007f3e0ffULL, 0x00000001113d7824ULL, 0x000fe200000e062fULL,
0x0000003b103a7210ULL, 0x000fe20007f1e0ffULL, 0x0000010032327825ULL, 0x000fe200078e00ffULL,
0x0000006405467210ULL, 0x000fc60007ffe0ffULL, 0x000001002e2e7825ULL, 0x000fe200078e00ffULL,
0x0000000832377212ULL, 0x000fc600078efcffULL, 0x00000001113b7824ULL, 0x000fe200000e0635ULL,
0x000000082e357212ULL, 0x000fe200078efcffULL, 0x0000000105307824ULL, 0x000fe200078e024bULL,
0x0000003710367210ULL, 0x040fe20007f1e0ffULL, 0x0000000111397824ULL, 0x000fe200008e0631ULL,
0x0000003510347210ULL, 0x000fe20007f3e0ffULL, 0x0000010030307825ULL, 0x000fe200078e00ffULL,
0x0000004f052e7210ULL, 0x000fc60007ffe0ffULL, 0x0000000111377824ULL, 0x040fe200000e0633ULL,
0x0000000830337212ULL, 0x000fe200078efcffULL, 0x0000000111357824ULL, 0x000fe400008e062fULL,
0x000001002e2e7825ULL, 0x000fe200078e00ffULL, 0x0000003310327210ULL, 0x000fc60007f1e0ffULL,
0x0000001009097824ULL, 0x000fe200078e020dULL, 0x000000082e457212ULL, 0x000fe200078efcffULL,
0x0000000105447824ULL, 0x000fe400078e0272ULL, 0x0000000111337824ULL, 0x000fe200000e0631ULL,
0x0000004510307210ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c097faeULL, 0x0003e2000b901c48ULL, 0x00000001052e7824ULL, 0x000fe400078e0271ULL,
0x0000010046467825ULL, 0x000fc800078e00ffULL, 0x0000000111317824ULL, 0x000fe200000e062fULL,
0x00000008467b7212ULL, 0x000fe200078efcffULL, 0x000001002e2e7825ULL, 0x000fc800078e00ffULL,
0x00000100442c7825ULL, 0x002fe200078e00ffULL, 0x000000082e097212ULL, 0x000fc600078efcffULL,
0x0000000105447824ULL, 0x000fe200078e027aULL, 0x000000082c457212ULL, 0x000fe200078efcffULL,
0x000000016f467824ULL, 0x040fe200078e0206ULL, 0x00000009102e7210ULL, 0x040fe20007f1e0ffULL,
0x000000086f6f7824ULL, 0x000fe200078e00ffULL, 0x00000045102c7210ULL, 0x000fe20007f3e0ffULL,
0x0000010044447825ULL, 0x000fc600078e00ffULL, 0xfffffff86f467812ULL, 0x000fe200078ee246ULL,
0x00000001112f7824ULL, 0x040fe200000e062fULL, 0x0000000844097212ULL, 0x000fe200078efcffULL,
0x0000000170447824ULL, 0x100fe400078e0206ULL, 0x00000001112d7824ULL, 0x000fe200008e062dULL,
0x0000000910087210ULL, 0x040fe20007f1e0ffULL, 0x000000014f7c7824ULL, 0x040fe200078e0206ULL,
0x0000007b10107210ULL, 0x000fe20007f3e0ffULL, 0x000000084f4f7824ULL, 0x000fe400078e00ffULL,
0x0000000111097824ULL, 0x000fc400000e0645ULL, 0x0000000870457824ULL, 0x000fe200078e00ffULL,
0xfffffff84f7c7812ULL, 0x000fe200078ee27cULL, 0x0000000111117824ULL, 0x000fe400008e0647ULL,
0x000000086e477824ULL, 0x000fe200078e00ffULL, 0xfffffff845447812ULL, 0x000fe200078ee244ULL,
0x000000084e707824ULL, 0x000fe400078e00ffULL, 0x000000107c7b7824ULL, 0x100fe400078e020dULL,
0x0000001044457824ULL, 0x000fc400078e020dULL, 0x000000016e447824ULL, 0x000fe200078e0206ULL,
0x000000036d6e7819ULL, 0x000fe400000006ffULL, 0x0000000042457faeULL, 0x0003e4000b901c48ULL,
0xfffffff847447812ULL, 0x000fe200078ee244ULL, 0x000000016d477824ULL, 0x100fe400078e0206ULL,
0x000000014e6d7824ULL, 0x000fc600078e0206ULL, 0xfffffff86e4e7812ULL, 0x000fe200078ee247ULL,
0x0000000172477824ULL, 0x140fe400078e0206ULL, 0x0000000872727824ULL, 0x000fe200078e00ffULL,
0xfffffff870427812ULL, 0x002fe200078ee26dULL, 0x000000014c437824ULL, 0x140fe400078e0206ULL,
0x000000084c4c7824ULL, 0x000fe200078e00ffULL, 0xfffffff872727812ULL, 0x000fe200078ee247ULL,
0x0000000149707824ULL, 0x140fe400078e0206ULL, 0x0000000849497824ULL, 0x000fe200078e00ffULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee243ULL, 0x000000014a437824ULL, 0x000fc400078e0206ULL,
0x000000084a4a7824ULL, 0x000fe200078e00ffULL, 0xfffffff849707812ULL, 0x000fe200078ee270ULL,
0x000000014d6e7824ULL, 0x140fe400078e0206ULL, 0x000000084d4d7824ULL, 0x000fe200078e00ffULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee243ULL, 0x000000017a477824ULL, 0x040fe200078e0206ULL,
0x000000064b437210ULL, 0x040fe20007ffe0ffULL, 0x000000084b4b7824ULL, 0x000fe200078e00ffULL,
0xfffffff84d6e7812ULL, 0x000fe200078ee26eULL, 0x000000087a497824ULL, 0x000fc400078e00ffULL,
0x00000001647a7824ULL, 0x140fe200078e0206ULL, 0xfffffff84b437812ULL, 0x000fe200078ee243ULL,
0x0000000171457824ULL, 0x040fe200078e0206ULL, 0x00000003644b7819ULL, 0x000fe200000006ffULL,
0x0000000871717824ULL, 0x000fe200078e00ffULL, 0xfffffff849647812ULL, 0x000fe200078ee247ULL,
0x0000001046477824ULL, 0x100fe200078e020dULL, 0xfffffff84b7a7812ULL, 0x000fe200078ee27aULL,
0x0000001044497824ULL, 0x000fe200078e020dULL, 0xfffffff871457812ULL, 0x000fe200078ee245ULL,
0x000000104e4b7824ULL, 0x100fe200078e020dULL, 0x0000000012477faeULL, 0x0003e2000b901c48ULL,
0x00000010424d7824ULL, 0x100fe200078e020dULL, 0x0000000d45457211ULL, 0x000fe200078e20ffULL,
0x000000106e4f7824ULL, 0x100fe200078e020dULL, 0x0000000040497faeULL, 0x0003e2000b901c48ULL,
0x000000104c6d7824ULL, 0x000fc400078e020dULL, 0x00000010706f7824ULL, 0x100fe200078e020dULL,
0x000000003e4b7faeULL, 0x0003e2000b901c48ULL, 0x000000104a717824ULL, 0x100fe400078e020dULL,
0x0000001043437824ULL, 0x100fe200078e020dULL, 0x000000003c4d7faeULL, 0x0003e2000b901c48ULL,
0x00000010727d7824ULL, 0x100fe400078e020dULL, 0x0000001064647824ULL, 0x100fe200078e020dULL,
0x000000003a4f7faeULL, 0x0003e2000b901c48ULL, 0x000000107a0d7824ULL, 0x000fc600078e020dULL,
0x00000000386d7faeULL, 0x0003e8000b901c48ULL, 0x00000000366f7faeULL, 0x0003e8000b901c48ULL,
0x0000000034717faeULL, 0x0003e8000b901c48ULL, 0x0000000032437faeULL, 0x0003e8000b901c48ULL,
0x00000000307b7faeULL, 0x0003e8000b901c48ULL, 0x000000002e457faeULL, 0x0003e8000b901c48ULL,
0x000000002c7d7faeULL, 0x0003e8000b901c48ULL, 0x0000000008647faeULL, 0x0003e8000b901c48ULL,
0x00000000100d7faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000100a097824ULL, 0x042fe200078e00ffULL, 0x000000080b087810ULL, 0x000fe20007ffe0ffULL,
0x000000100a2c7824ULL, 0x000fe200078e00ffULL, 0x000030000c0c7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff009087812ULL, 0x000fe400078ee208ULL, 0x0000000a0b097810ULL, 0x000fe20007ffe0ffULL,
0x000000105b107824ULL, 0x100fe200078e020cULL, 0x0000000c62307211ULL, 0x000fe200078e20ffULL,
0x0000001008087824ULL, 0x000fe200078e00ffULL, 0xfffffff02c097812ULL, 0x000fe200078ee209ULL,
0x000000105f407824ULL, 0x100fe400078e020cULL, 0x000000105e3c7824ULL, 0x000fe400078e020cULL,
0x0000001009097824ULL, 0x000fc400078e00ffULL, 0x0000001060387824ULL, 0x100fe400078e020cULL,
0x0000001063447824ULL, 0x100fe400078e020cULL, 0x0000001059597824ULL, 0x000fe200078e020cULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000001010783bULL, 0x000fe80000000200ULL,
0x000000000834783bULL, 0x0002a80000000200ULL, 0x000000003030783bULL, 0x000fe80000000200ULL,
0x00000000092c783bULL, 0x0007e20000000200ULL, 0x0000000c0b087810ULL, 0x002fc40007ffe0ffULL,
0x0000000e0b0b7810ULL, 0x000fe20007ffe0ffULL, 0x000000004040783bULL, 0x000e680000000200ULL,
0x000000003c3c783bULL, 0x000f220000000200ULL, 0x000000100a097824ULL, 0x048fe400078e00ffULL,
0x000000100a0a7824ULL, 0x000fe200078e00ffULL, 0x000000003838783bULL, 0x000ee40000000200ULL,
0xfffffff009087812ULL, 0x000fc400078ee208ULL, 0x000000004444783bULL, 0x000ee20000000200ULL,
0xfffffff00a0d7812ULL, 0x000fe200078ee20bULL, 0x000000103454723cULL, 0x044b6e0000001854ULL,
0x0000001066107824ULL, 0x120fe200078e020cULL, 0x000000123450723cULL, 0x040b6a0000001850ULL,
0x000000001010783bULL, 0x020fe60000000200ULL, 0x000000403414723cULL, 0x002bee0000001814ULL,
0x0000001058407824ULL, 0x120fe200078e020cULL, 0x000000302c54723cULL, 0x040bee0000001854ULL,
0x0000001065307824ULL, 0x120fe200078e020cULL, 0x000000322c50723cULL, 0x000bea0000001850ULL,
0x000000003030783bULL, 0x020e660000000200ULL, 0x000000423418723cULL, 0x040b640000001818ULL,
0x000000004040783bULL, 0x020fec0000000200ULL, 0x0000003c341c723cULL, 0x050bee000000181cULL,
0x000000105c3c7824ULL, 0x120fe200078e020cULL, 0x0000003e3420723cULL, 0x040bea0000001820ULL,
0x000000003c3c783bULL, 0x020fe60000000200ULL, 0x000000383424723cULL, 0x048b6e0000001824ULL,
0x0000001008387824ULL, 0x020fe200078e00ffULL, 0x0000003a3428723cULL, 0x000b620000001828ULL,
0x0000001067087824ULL, 0x000fc800078e020cULL, 0x000000003838783bULL, 0x020fe40000000200ULL,
0x0000001061347824ULL, 0x100fe200078e020cULL, 0x000000462c18723cULL, 0x040f620000001818ULL,
0x000000000808783bULL, 0x000fe80000000200ULL, 0x000000003434783bULL, 0x000ea60000000200ULL,
0x000000302c24723cULL, 0x042bee0000001824ULL, 0x0000000c5a307211ULL, 0x020fe200078e20ffULL,
0x000000322c28723cULL, 0x040bea0000001828ULL, 0x000000003030783bULL, 0x020e660000000200ULL,
0x000000102c1c723cULL, 0x040b6e000000181cULL, 0x000000100d107824ULL, 0x020fe200078e00ffULL,
0x000000442c14723cULL, 0x040f700000001814ULL, 0x000000122c20723cULL, 0x000b640000001820ULL,
0x000000001010783bULL, 0x020ee80000000200ULL, 0x00000000592c783bULL, 0x000fe40000000200ULL,
0x000000343854723cULL, 0x044bee0000001854ULL, 0x000000100e347824ULL, 0x120fe200078e020cULL,
0x000000363850723cULL, 0x000be20000001850ULL, 0x000000100f0c7824ULL, 0x000fc800078e020cULL,
0x000000003434783bULL, 0x020ea60000000200ULL, 0x0000003e3818723cULL, 0x040f620000001818ULL,
0x000000000c0c783bULL, 0x000f2e0000000200ULL, 0x00000008381c723cULL, 0x040f70000000181cULL,
0x000000303824723cULL, 0x042f700000001824ULL, 0x0000003c3814723cULL, 0x040ff00000001814ULL,
0x0000000a3820723cULL, 0x040ff00000001820ULL, 0x000000323828723cULL, 0x000ff00000001828ULL,
0x000000421018723cULL, 0x068f700000001818ULL, 0x00000034101c723cULL, 0x044b70000000181cULL,
0x0000000c1024723cULL, 0x050f700000001824ULL, 0x0000002c1054723cULL, 0x000b640000001854ULL,
0x3db504f319357820ULL, 0x020fc40000410000ULL, 0x3db504f318187820ULL, 0x000fe40000410000ULL,
0x3db504f31a1a7820ULL, 0x000fe40000410000ULL, 0x3db504f31b347820ULL, 0x000fe20000410000ULL,
0x0000002e1050723cULL, 0x000b620000001850ULL, 0x3db504f31c337820ULL, 0x000fe40000410000ULL,
0x3db504f31d1d7820ULL, 0x000fe40000410000ULL, 0x3db504f31e0a7820ULL, 0x000fc40000410000ULL,
0x3db504f31f0b7820ULL, 0x000fe20000410000ULL, 0x000000401014723cULL, 0x000f620000001814ULL,
0x3db504f3252d7820ULL, 0x000fe40000410000ULL, 0x3db504f3260d7820ULL, 0x000fe40000410000ULL,
0x3db504f3242f7820ULL, 0x020fc60000410000ULL, 0x000000361020723cULL, 0x040f620000001820ULL,
0x3db504f354547820ULL, 0x000fe40000410000ULL, 0x3db504f355557820ULL, 0x000fe40000410000ULL,
0x3db504f356567820ULL, 0x000fe40000410000ULL, 0x3db504f357577820ULL, 0x000fe20000410000ULL,
0x0000000e1028723cULL, 0x000b620000001828ULL, 0x3db504f350507820ULL, 0x000fe40000410000ULL,
0x3db504f351317820ULL, 0x000fc40000410000ULL, 0x3db504f352527820ULL, 0x000fe40000410000ULL,
0x3db504f353327820ULL, 0x000fe40000410000ULL, 0x3db504f3142e7820ULL, 0x000fe40000410000ULL,
0x3db504f315157820ULL, 0x000fe40000410000ULL, 0x3db504f316167820ULL, 0x000fe40000410000ULL,
0x3db504f317177820ULL, 0x000fc40000410000ULL, 0x3db504f3202c7820ULL, 0x020fe40000410000ULL,
0x3db504f321307820ULL, 0x000fe40000410000ULL, 0x3db504f3220c7820ULL, 0x000fe40000410000ULL,
0x3db504f323197820ULL, 0x000fe40000410000ULL, 0x3db504f3270e7820ULL, 0x000fe40000410000ULL,
0x3db504f328257820ULL, 0x000fc40000410000ULL, 0x3db504f329267820ULL, 0x000fe40000410000ULL,
0x3db504f32a1c7820ULL, 0x000fe40000410000ULL, 0x3db504f32b0f7820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000075087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff2a7224ULL, 0x000fe200078e0018ULL, 0x0000001d002b7202ULL, 0x000fe20000000f00ULL,
0x000000ffff227224ULL, 0x000fe400078e0016ULL, 0x000000ffff217224ULL, 0x000fe200078e0017ULL,
0x0000000e00177202ULL, 0x000fe20000000f00ULL, 0x000000ffff237224ULL, 0x000fc400078e001aULL,
0x000000ffff1b7224ULL, 0x000fe400078e0054ULL, 0x000000ffff277224ULL, 0x000fe400078e0055ULL,
0x000000ffff287224ULL, 0x000fe400078e0050ULL, 0x000000ffff297224ULL, 0x000fe400078e0015ULL,
0x000000ffff207224ULL, 0x000fe400078e0056ULL, 0x000000ffff1e7224ULL, 0x000fc400078e0057ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0052ULL, 0x000000ffff247224ULL, 0x000fe400078e000aULL,
0x000000ffff1a7224ULL, 0x000fe400078e000bULL, 0x000000ffff187224ULL, 0x000fe400078e000cULL,
0x000000ffff167224ULL, 0x000fe400078e000dULL, 0x000000ffff1d7224ULL, 0x000fc400078e000fULL,
0x00000000000a7805ULL, 0x006fca0000015200ULL, 0x00000400750d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fc40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c0a0f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e0bULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc8000001140dULL, 0x0000000f0c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e060dULL, 0x000000020c0c7819ULL, 0x000fc8000000120dULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400750d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000406157824ULL, 0x000fe200078e00ffULL,
0x000000730200720cULL, 0x000fc80003f06070ULL, 0xfffffff015097812ULL, 0x000fca00078ec0ffULL,
0x0000008000147824ULL, 0x000fca00078e0209ULL, 0x01b4000014087984ULL, 0x0002a20000000c00ULL,
0x0000135000008947ULL, 0x000fea0003800000ULL, 0x0000000206027824ULL, 0x000fe200078e00ffULL,
0x00000007680c7217ULL, 0x000fe20007800000ULL, 0x00000002ff4b7424ULL, 0x000fc600078e00ffULL,
0x0000000602027812ULL, 0x000fe200078ec0ffULL, 0x000000010c077824ULL, 0x000fe200078e0a07ULL,
0x0000006b060c7211ULL, 0x000fe400078ff0ffULL, 0x0000580002367a10ULL, 0x000fe20007ffe0ffULL,
0x00000001690e7824ULL, 0x000fe200078e0202ULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160cULL,
0x00000036070f7210ULL, 0x000fe20007ffe1ffULL, 0x000000010e117824ULL, 0x040fe200078e0a07ULL,
0x000000070e00720cULL, 0x000fc40003f26070ULL, 0x0000000d740d7217ULL, 0x040fe40003800000ULL,
0x0000001174117217ULL, 0x000fe40003800000ULL, 0x000000073600720cULL, 0x000fe20003f06070ULL,
0x0000000d6a527224ULL, 0x000fe200078e02ffULL, 0x00000004ff117819ULL, 0x000fe40000011611ULL,
0x0000000f740f7217ULL, 0x000fe40003800000ULL, 0x000000ff11117207ULL, 0x000fc40000800000ULL,
0x000000080c0c7810ULL, 0x000fe40007ffe0ffULL, 0x000000ff0f437207ULL, 0x000fe20000000000ULL,
0x00000001520e7824ULL, 0x000fe200078e0211ULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160cULL,
0x0000005243127211ULL, 0x000fe200078fe0ffULL, 0x000060000e0e7625ULL, 0x000fe200078e004bULL,
0x00000010023a7812ULL, 0x000fe400078efcffULL, 0x0000000d740d7217ULL, 0x000fe20003800000ULL,
0x0000600012127625ULL, 0x000fe200078e004bULL, 0x000058003a387a10ULL, 0x000fe20007ffe0ffULL,
0x000000080e507981ULL, 0x000724000c1e9500ULL, 0x0000000d6a547224ULL, 0x000fc400078e02ffULL,
0x0000000812497981ULL, 0x000322000c1e9500ULL, 0x00000020023c7812ULL, 0x000fe200078efcffULL,
0x00000001110c7824ULL, 0x000fe400078e0254ULL, 0x00000001380f7824ULL, 0x048fe200078e0a07ULL,
0x000000073800720cULL, 0x000fe20003f06070ULL, 0x0000000169127824ULL, 0x002fc600078e023aULL,
0x0000000f740f7217ULL, 0x000fe20003800000ULL, 0x000060000c0c7625ULL, 0x000fe200078e004bULL,
0x000058003c407a10ULL, 0x000fc60007ffe0ffULL, 0x0000000112137824ULL, 0x000fe200078e0a07ULL,
0x000000ff0f377207ULL, 0x000fe20000000000ULL, 0x000000080c4e7981ULL, 0x0002e2000c1e9500ULL,
0x0000005443107211ULL, 0x000fe400078fe0ffULL, 0x0000001374137217ULL, 0x000fe40003800000ULL,
0x00000040073d7210ULL, 0x000fe20007ffe1ffULL, 0x0000600010107625ULL, 0x000fe200078e004bULL,
0x000000071200720cULL, 0x080fe40003f26070ULL, 0x00000052370c7211ULL, 0x002fe200078fe0ffULL,
0x0000000169447824ULL, 0x000fe200078e023cULL, 0x00000004ff137819ULL, 0x000fe20000011613ULL,
0x0000000810457981ULL, 0x0002e2000c1e9500ULL, 0x000000074000720cULL, 0x000fc40003f06070ULL,
0x0000003d743d7217ULL, 0x000fe20003800000ULL, 0x000060000c0c7625ULL, 0x000fe200078e004bULL,
0x000000ff13137207ULL, 0x000fe40000800000ULL, 0x000000ff3d3d7207ULL, 0x000fe20000000000ULL,
0x00000001443f7824ULL, 0x040fe200078e0a07ULL, 0x000000074400720cULL, 0x000fe20003f26070ULL,
0x000000080c397981ULL, 0x0004e2000c1e9500ULL, 0x0000003002447812ULL, 0x000fe200078efcffULL,
0x00000001520e7824ULL, 0x000fe200078e0213ULL, 0x0000005437107211ULL, 0x002fe200078fe0ffULL,
0x0000000113127824ULL, 0x000fe200078e0254ULL, 0x0000003f743f7217ULL, 0x000fe20003800000ULL,
0x0000000169567824ULL, 0x000fe200078e0244ULL, 0x000000523d0c7211ULL, 0x004fe200078fe0ffULL,
0x000060000e0e7625ULL, 0x000fe200078e004bULL, 0x00000004ff3f7819ULL, 0x000fc6000001163fULL,
0x0000600010107625ULL, 0x080fe200078e004bULL, 0x0000580044467a10ULL, 0x000fe20007ffe0ffULL,
0x000000080e3e7981ULL, 0x0002a4000c1e9500ULL, 0x0000600012127625ULL, 0x080fe200078e004bULL,
0x000000ff3f417207ULL, 0x000fe20000800000ULL, 0x00000008103b7981ULL, 0x0002a4000c1e9500ULL,
0x000060000c0c7625ULL, 0x000fe400078e004bULL, 0x0000000812427981ULL, 0x0002a4000c1e9500ULL,
0x0000000156477824ULL, 0x000fc400078e0a07ULL, 0x000000080c3f7981ULL, 0x0002a4000c1e9500ULL,
0x00000001520e7824ULL, 0x002fe200078e0241ULL, 0x000000543d107211ULL, 0x000fe400078fe0ffULL,
0x0000004774477217ULL, 0x000fe20003800000ULL, 0x0000000141127824ULL, 0x000fe400078e0254ULL,
0x00000001460d7824ULL, 0x040fe200078e0a07ULL, 0x000000074600720cULL, 0x000fe20003f06070ULL,
0x000060000e0e7625ULL, 0x000fe200078e004bULL, 0x000000075600720cULL, 0x000fc40003f26070ULL,
0x0000000d740d7217ULL, 0x000fe20003800000ULL, 0x0000600010107625ULL, 0x080fe200078e004bULL,
0x00000004ff0c7819ULL, 0x000fe20000011647ULL, 0x000000080e4a7981ULL, 0x0002a4000c1e9500ULL,
0x0000600012127625ULL, 0x000fe200078e004bULL, 0x000000ff0d477207ULL, 0x000fe20000000000ULL,
0x0000000810417981ULL, 0x0002a2000c1e9500ULL, 0x000000ff0c4d7207ULL, 0x000fc60000800000ULL,
0x00000008124c7981ULL, 0x0002a2000c1e9500ULL, 0x00000052470c7211ULL, 0x000fe200078fe0ffULL,
0x00000001520e7824ULL, 0x002fc800078e024dULL, 0x000060000c0c7625ULL, 0x000fc800078e004bULL,
0x000060000e0e7625ULL, 0x000fe400078e004bULL, 0x000000080c0c7981ULL, 0x0002a2000c1e9500ULL,
0x0000005447107211ULL, 0x000fc600078fe0ffULL, 0x000000080e0f7981ULL, 0x0002a2000c1e9500ULL,
0x000000014d127824ULL, 0x000fe400078e0254ULL, 0x0000600010107625ULL, 0x000fc800078e004bULL,
0x0000600012127625ULL, 0x000fe400078e004bULL, 0x0000000810107981ULL, 0x0002a8000c1e9500ULL,
0x0000000812137981ULL, 0x0008a2000c1e9500ULL, 0xfffffff043527812ULL, 0x000fe200078ec0ffULL,
0x00000001ff437424ULL, 0x000fc800078e00ffULL, 0x00000001070d7824ULL, 0x002fe200078e0252ULL,
0x0000000802527812ULL, 0x000fc600078efcffULL, 0x00000001365a7824ULL, 0x100fe200078e0a0dULL,
0x0000000902567812ULL, 0x000fe400078efcffULL, 0x0000580052547a10ULL, 0x000fe40007ffe0ffULL,
0x0000005a435a7219ULL, 0x000fe400000006ffULL, 0x00005800560e7a10ULL, 0x000fe20007ffe0ffULL,
0x00000001545c7824ULL, 0x000fc800078e0a0dULL, 0x000000010e5e7824ULL, 0x000fe200078e0a0dULL,
0x0000005c435c7219ULL, 0x040fe400000006ffULL, 0x00000018027a7812ULL, 0x000fe400078efcffULL,
0x0000005e435e7219ULL, 0x000fe400000006ffULL, 0xfffffff037377812ULL, 0x000fe400078ec0ffULL,
0xfffffff047477812ULL, 0x000fe400078ec0ffULL, 0x000058007a117a10ULL, 0x000fc60007ffe0ffULL,
0x0000000107517824ULL, 0x000fe200078e0247ULL, 0x0000001902727812ULL, 0x040fe400078efcffULL,
0x00000011027c7812ULL, 0x040fe400078efcffULL, 0x0000002802607812ULL, 0x040fe400078efcffULL,
0x0000002102627812ULL, 0x000fe400078efcffULL, 0x0000580060667a10ULL, 0x000fe40007ffe0ffULL,
0x00005800626e7a10ULL, 0x000fe20007ffe0ffULL, 0x00000001465b7824ULL, 0x000fca00078e0a51ULL,
0x0000005b435b7219ULL, 0x000fe400000006ffULL, 0x0000541049497816ULL, 0x010fe40000000050ULL,
0x0000000102507812ULL, 0x000fe400078efcffULL, 0x000000495aff7212ULL, 0x000fe4000780c0ffULL,
0x0000580050587a10ULL, 0x000fe40007ffe0ffULL, 0x000000073600720cULL, 0x000fc40000701470ULL,
0x000000580d127210ULL, 0x000fe40007ffe1ffULL, 0x000000070200720cULL, 0x000fe40000701070ULL,
0x0000001243127219ULL, 0x000fe400000006ffULL, 0x000000495cff7212ULL, 0x080fe4000784c0ffULL,
0x0000004912ff7212ULL, 0x080fe4000786c0ffULL, 0x000000495eff7212ULL, 0x000fc4000782c0ffULL,
0xff8000001b1b7808ULL, 0x000fe40000000000ULL, 0xfffffff03d497812ULL, 0x000fe200078ec0ffULL,
0x00000001073d7824ULL, 0x000fe200078e0237ULL, 0x0000541045457816ULL, 0x008fc8000000004eULL,
0x000000455aff7212ULL, 0x080fe4000788c0ffULL, 0x000000455cff7212ULL, 0x080fe400078cc0ffULL,
0x000000455eff7212ULL, 0x000fe2000780c0ffULL, 0x0000000138477824ULL, 0x100fe200078e0a3dULL,
0x000000073600720cULL, 0x080fe20002781470ULL, 0x00000001114d7824ULL, 0x000fe200078e0a3dULL,
0x000000075400720cULL, 0x080fe400037c1470ULL, 0x000000070e00720cULL, 0x000fc40000701470ULL,
0x000000070200720cULL, 0x080fe40002781070ULL, 0x000000075200720cULL, 0x080fe400037c1070ULL,
0x000000075600720cULL, 0x000fe40000701070ULL, 0x0000004743477219ULL, 0x040fe400000006ffULL,
0x0000004d434d7219ULL, 0x000fe400000006ffULL, 0x0000004512ff7212ULL, 0x000fc400078ac0ffULL,
0x00005410393e7816ULL, 0x004fe4000000003eULL, 0x00000029025e7812ULL, 0x040fe400078efcffULL,
0x00000031025a7812ULL, 0x040fe400078efcffULL, 0x000054103b427816ULL, 0x000fe40000000042ULL,
0x00000038024e7812ULL, 0x040fe400078efcffULL, 0x0000003902127812ULL, 0x000fc400078efcffULL,
0x00005800720d7a10ULL, 0x000fe20007ffe0ffULL, 0x0000000107497824ULL, 0x000fe200078e0249ULL,
0x000058007c457a10ULL, 0x000fe40007ffe0ffULL, 0x000000070e00720cULL, 0x000fe40000f21470ULL,
0xff80000020207808ULL, 0x000fe40002000000ULL, 0xff8000001f1f7808ULL, 0x000fe40003000000ULL,
0xff80000032327808ULL, 0x000fc40000000000ULL, 0x0000003e47ff7212ULL, 0x040fe4000788c0ffULL,
0x0000004247ff7212ULL, 0x080fe400078cc0ffULL, 0x000000424dff7212ULL, 0x000fe4000780c0ffULL,
0x000058005e647a10ULL, 0x000fe20007ffe0ffULL, 0x000000010d4f7824ULL, 0x000fe200078e0a3dULL,
0x000058005a5c7a10ULL, 0x000fe40007ffe0ffULL, 0x000058004e707a10ULL, 0x000fc40007ffe0ffULL,
0x0000580012377a10ULL, 0x000fe20007ffe0ffULL, 0x00000001454b7824ULL, 0x000fe200078e0a3dULL,
0x000000075600720cULL, 0x080fe20000f21070ULL, 0x0000000140537824ULL, 0x000fe200078e0a49ULL,
0x000000075800720cULL, 0x0c0fe40001f61470ULL, 0x000000075800720cULL, 0x080fe40002fa1470ULL,
0x000000075400720cULL, 0x080fe40001741470ULL, 0x000000073800720cULL, 0x000fc40002781470ULL,
0x000000073800720cULL, 0x080fe400037c1470ULL, 0x000000071100720cULL, 0x080fe20000701470ULL,
0x0000000166577824ULL, 0x100fe200078e0a49ULL, 0x0000006e49557210ULL, 0x000fe20007ffe1ffULL,
0x0000000164597824ULL, 0x000fe200078e0a49ULL, 0xff80000031317808ULL, 0x000fe20000800000ULL,
0x000000015c5f7824ULL, 0x100fe200078e0a51ULL, 0x000000075000720cULL, 0x080fe20001f61070ULL,
0x00000001703d7824ULL, 0x100fe200078e0a51ULL, 0x000000075000720cULL, 0x000fe20002fa1070ULL,
0x0000000137497824ULL, 0x000fe200078e0a51ULL, 0x0000004f43517219ULL, 0x000fc400000006ffULL,
0x000000075200720cULL, 0x080fe40001741070ULL, 0x000000073a00720cULL, 0x0c0fe40002721070ULL,
0x000000073a00720cULL, 0x080fe400037c1070ULL, 0x000000077a00720cULL, 0x000fe40000701070ULL,
0x0000004b434b7219ULL, 0x040fe400000006ffULL, 0x00000053434f7219ULL, 0x000fc400000006ffULL,
0x000054103f4a7816ULL, 0x000fe4000000004aULL, 0x00005410414c7816ULL, 0x000fe4000000004cULL,
0xff80000027277808ULL, 0x000fe40001800000ULL, 0xff8000001e1e7808ULL, 0x000fe40002800000ULL,
0xff80000028287808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fc40000800000ULL,
0xff80000022227808ULL, 0x000fe40003000000ULL, 0xff80000023237808ULL, 0x000fe40000000000ULL,
0x0000003e4bff7212ULL, 0x080fe4000786c0ffULL, 0x0000003e4dff7212ULL, 0x080fe400078ac0ffULL,
0x0000003e51ff7212ULL, 0x000fe4000784c0ffULL, 0x000000424bff7212ULL, 0x000fc4000788c0ffULL,
0x0000004251ff7212ULL, 0x000fe4000782c0ffULL, 0x0000004a4fff7212ULL, 0x040fe400078cc0ffULL,
0x0000004c4fff7212ULL, 0x000fe4000780c0ffULL, 0x000000074500720cULL, 0x0c0fe40001f61470ULL,
0x000000074500720cULL, 0x080fe40002781470ULL, 0x000000071100720cULL, 0x000fc40002fa1470ULL,
0x000000070d00720cULL, 0x0c0fe40001741470ULL, 0x000000070d00720cULL, 0x080fe40000f21470ULL,
0x000000074000720cULL, 0x0c0fe400037c1470ULL, 0x000000074000720cULL, 0x080fe40000701470ULL,
0x000000077c00720cULL, 0x0c0fe40001f61070ULL, 0x000000077c00720cULL, 0x000fc40002781070ULL,
0x000000077a00720cULL, 0x080fe40002fa1070ULL, 0x000000077200720cULL, 0x0c0fe40001741070ULL,
0x000000077200720cULL, 0x080fe40000f21070ULL, 0x000000073c00720cULL, 0x0c0fe400037c1070ULL,
0x000000073c00720cULL, 0x000fe40000701070ULL, 0x0000005543557219ULL, 0x000fc400000006ffULL,
0x0000005743577219ULL, 0x040fe400000006ffULL, 0x0000005943597219ULL, 0x000fe400000006ffULL,
0x000054100c0c7816ULL, 0x000fe4000000000fULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff80000021217808ULL, 0x000fe40002000000ULL, 0xff8000002a2a7808ULL, 0x000fc40002800000ULL,
0xff80000035357808ULL, 0x000fe40001000000ULL, 0xff80000034347808ULL, 0x000fe40000800000ULL,
0xff80000033337808ULL, 0x000fe40003000000ULL, 0xff80000024247808ULL, 0x000fe40000000000ULL,
0x0000004a55ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004a57ff7212ULL, 0x000fc4000788c0ffULL,
0x0000004a59ff7212ULL, 0x000fe400078ac0ffULL, 0x0000004c55ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004c57ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004c59ff7212ULL, 0x000fe400078cc0ffULL,
0x0000000c5bff7212ULL, 0x000fe4000780c0ffULL, 0x000000076e00720cULL, 0x000fc40001f61470ULL,
0x000000076e00720cULL, 0x080fe40001741470ULL, 0x000000076600720cULL, 0x0c0fe40002781470ULL,
0x000000076600720cULL, 0x080fe40000f21470ULL, 0x000000076400720cULL, 0x0c0fe40002fa1470ULL,
0x000000076400720cULL, 0x080fe400037c1470ULL, 0x000000074600720cULL, 0x000fc40000701470ULL,
0x000000076200720cULL, 0x0c0fe40001f61070ULL, 0x000000076200720cULL, 0x080fe40001741070ULL,
0x000000076000720cULL, 0x0c0fe40002781070ULL, 0x000000076000720cULL, 0x080fe40000f21070ULL,
0x000000075e00720cULL, 0x0c0fe40002fa1070ULL, 0x000000075e00720cULL, 0x000fc400037c1070ULL,
0x000000074400720cULL, 0x000fe40000701070ULL, 0x0000005f435f7219ULL, 0x040fe400000006ffULL,
0x0000003d433d7219ULL, 0x040fe400000006ffULL, 0x0000004943497219ULL, 0x000fe400000006ffULL,
0x0000541010107816ULL, 0x000fe40000000013ULL, 0xff8000002b2b7808ULL, 0x000fc40001800000ULL,
0xff8000001a1a7808ULL, 0x000fe40001000000ULL, 0xff8000002c2c7808ULL, 0x000fe40002000000ULL,
0xff80000018187808ULL, 0x000fe40000800000ULL, 0xff80000030307808ULL, 0x000fe40002800000ULL,
0xff80000019197808ULL, 0x000fe40003000000ULL, 0xff8000002f2f7808ULL, 0x000fc40000000000ULL,
0x0000000c5fff7212ULL, 0x080fe4000786c0ffULL, 0x0000000c3dff7212ULL, 0x080fe4000784c0ffULL,
0x0000000c49ff7212ULL, 0x000fe4000788c0ffULL, 0x000000105bff7212ULL, 0x080fe4000782c0ffULL,
0x000000105fff7212ULL, 0x080fe400078ac0ffULL, 0x000000103dff7212ULL, 0x000fc400078cc0ffULL,
0x0000001049ff7212ULL, 0x000fe4000780c0ffULL, 0x000000074600720cULL, 0x080fe40000f21470ULL,
0x000000075c00720cULL, 0x0c0fe40001f61470ULL, 0x000000075c00720cULL, 0x080fe40002fa1470ULL,
0x000000077000720cULL, 0x0c0fe40001741470ULL, 0x000000077000720cULL, 0x000fc400037c1470ULL,
0x000000073700720cULL, 0x0c0fe40002781470ULL, 0x000000073700720cULL, 0x080fe40000701470ULL,
0x000000074400720cULL, 0x080fe40000f21070ULL, 0x000000075a00720cULL, 0x0c0fe40001f61070ULL,
0x000000075a00720cULL, 0x080fe40002fa1070ULL, 0x000000074e00720cULL, 0x000fc40001741070ULL,
0x000000074e00720cULL, 0x080fe400037c1070ULL, 0x000000071200720cULL, 0x0c0fe40002781070ULL,
0x000000071200720cULL, 0x000fe40000701070ULL, 0xff8000002d2d7808ULL, 0x000fe40001800000ULL,
0xff80000025257808ULL, 0x000fe40001000000ULL, 0xff80000026267808ULL, 0x000fc40002000000ULL,
0xff80000016167808ULL, 0x000fe40000800000ULL, 0xff80000017177808ULL, 0x000fe40002800000ULL,
0xff8000001c1c7808ULL, 0x000fe40003000000ULL, 0xff8000001d1d7808ULL, 0x000fc40000000000ULL,
0x0000001b0800720bULL, 0x004fe40003f1e000ULL, 0x000000200900720bULL, 0x000fe40003f3e000ULL,
0x000000081b087208ULL, 0x000fc40004000000ULL, 0x0000000920097208ULL, 0x000fe40004800000ULL,
0x000000270800720bULL, 0x000fe40003f1e000ULL, 0x0000001e0900720bULL, 0x000fe40003f3e000ULL,
0x0000000827077208ULL, 0x000fe40004000000ULL, 0x000000091e027208ULL, 0x000fe40004800000ULL,
0x000000280700720bULL, 0x000fc40003f1e000ULL, 0x0000001f0200720bULL, 0x000fe40003f3e000ULL,
0x0000000728087208ULL, 0x000fe40004000000ULL, 0x000000021f077208ULL, 0x000fe40004800000ULL,
0x000000310800720bULL, 0x000fe40003f1e000ULL, 0x000000320700720bULL, 0x000fe40003f3e000ULL,
0x0000000831097208ULL, 0x000fc40004000000ULL, 0x0000000732077208ULL, 0x000fe40004800000ULL,
0x0000002e0900720bULL, 0x000fe40003f1e000ULL, 0x000000220700720bULL, 0x000fe40003f3e000ULL,
0x000000092e027208ULL, 0x000fe40004000000ULL, 0x0000000722087208ULL, 0x000fe40004800000ULL,
0x000000290200720bULL, 0x000fc40003f1e000ULL, 0x000000210800720bULL, 0x000fe40003f3e000ULL,
0x0000000229077208ULL, 0x000fe40004000000ULL, 0x0000000821087208ULL, 0x000fe40004800000ULL,
0x0000002a0700720bULL, 0x000fe40003f1e000ULL, 0x000000230800720bULL, 0x000fe40003f3e000ULL,
0x000000072a027208ULL, 0x000fc40004000000ULL, 0x0000000823077208ULL, 0x000fe40004800000ULL,
0x000000350200720bULL, 0x000fe40003f1e000ULL, 0x000000340700720bULL, 0x000fe40003f3e000ULL,
0x0000000235027208ULL, 0x000fe40004000000ULL, 0x0000000734077208ULL, 0x000fe40004800000ULL,
0x000000330200720bULL, 0x000fc40003f1e000ULL, 0x000000240700720bULL, 0x000fe40003f3e000ULL,
0x0000000233027208ULL, 0x000fe40004000000ULL, 0x0000000724077208ULL, 0x000fe40004800000ULL,
0x0000002b0200720bULL, 0x000fe40003f1e000ULL, 0x0000001a0700720bULL, 0x000fe40003f3e000ULL,
0x000000022b097208ULL, 0x000fc40004000000ULL, 0x000000071a077208ULL, 0x000fe40004800000ULL,
0x0000002c0900720bULL, 0x000fe40003f1e000ULL, 0x000000180700720bULL, 0x000fe40003f3e000ULL,
0x000000092c097208ULL, 0x000fe40004000000ULL, 0x0000000718027208ULL, 0x000fe40004800000ULL,
0x000000300900720bULL, 0x000fc40003f1e000ULL, 0x000000190200720bULL, 0x000fe40003f3e000ULL,
0x0000000930087208ULL, 0x000fe40004000000ULL, 0x0000000219077208ULL, 0x000fe40004800000ULL,
0x0000002f0800720bULL, 0x000fe40003f1e000ULL, 0x000000160700720bULL, 0x000fe40003f3e000ULL,
0x000000082f087208ULL, 0x000fc40004000000ULL, 0x0000000716027208ULL, 0x000fe40004800000ULL,
0x0000002d0800720bULL, 0x000fe40003f1e000ULL, 0x000000170200720bULL, 0x000fe40003f3e000ULL,
0x000000082d087208ULL, 0x000fe40004000000ULL, 0x0000000217077208ULL, 0x000fe40004800000ULL,
0x000000250800720bULL, 0x000fc40003f1e000ULL, 0x0000001c0700720bULL, 0x000fe40003f3e000ULL,
0x0000000825097208ULL, 0x000fe40004000000ULL, 0x000000071c027208ULL, 0x000fe40004800000ULL,
0x000000260900720bULL, 0x000fe40003f1e000ULL, 0x0000001d0200720bULL, 0x000fe40003f3e000ULL,
0x00000009260e7208ULL, 0x000fc40004000000ULL, 0x000000021d107208ULL, 0x000fe20004800000ULL,
0x000016a27f007947ULL, 0x000fec000b800000ULL, 0x0c401f000e027f89ULL, 0x0004e400000e0000ULL,
0x000000020e00720bULL, 0x008fc80003f1e000ULL, 0x0000000e02127208ULL, 0x000fe20004000000ULL,
0x000016d27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0010027f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a077f89ULL, 0x000f2800000e0000ULL, 0x0c401f000b087f89ULL, 0x000e6800000e0000ULL,
0x0c201f0012097f89ULL, 0x000ea200000e0000ULL, 0x000000021000720bULL, 0x008fc40003f1e000ULL,
0x000000070a00720bULL, 0x010fe40003f3e000ULL, 0x00000010020c7208ULL, 0x000fe40004000000ULL,
0x0000000a070d7208ULL, 0x000fe40004800000ULL, 0x000000080b00720bULL, 0x002fe20003f1e000ULL,
0x0c201f000c0f7f89ULL, 0x000e6600000e0000ULL, 0x0000000b08027208ULL, 0x000fe20004000000ULL,
0x0c201f000d0e7f89ULL, 0x004ea200000e0000ULL, 0x000000091200720bULL, 0x000fc60003f1e000ULL,
0x0c201f0002077f89ULL, 0x0006e200000e0000ULL, 0x0000001209087208ULL, 0x000fe40004000000ULL,
0x0000000f0c00720bULL, 0x002fe40003f3e000ULL, 0x0000000e0d00720bULL, 0x004fe40003f5e000ULL,
0x0000000c0f097208ULL, 0x000fe40004800000ULL, 0x0000000d0e0a7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b080c7820ULL, 0x008fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000306ff7812ULL, 0x000fc4000780c0ffULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001080cULL,
0x000000070200720bULL, 0x004fe20003f3e000ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe4000001080cULL,
0x00000028000d7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b27277823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b31317823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b29297823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b2a0b7823ULL, 0x100fe2000001080cULL, 0x0000001b001b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2d287823ULL, 0x004fc4000001080cULL, 0x3fb8aa3b092d7820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b2b2a7823ULL, 0x000fe4000001080cULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001082dULL,
0x00000027000e7308ULL, 0x0022a20000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b32327823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b1e1e7823ULL, 0x000fc4000001082dULL,
0x3fb8aa3b2c2b7823ULL, 0x100fe2000001080cULL, 0x0000003100107308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b35357823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b33277823ULL, 0x102fe4000001080cULL, 0x3fb8aa3b302c7823ULL, 0x100fe2000001080cULL,
0x0000002000207308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b26267823ULL, 0x000fc4000001080cULL,
0x3fb8aa3b22227823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b21217823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082dULL, 0x0000001e000f7308ULL, 0x0003220000000800ULL,
0x3fb8aa3b34347823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b19307823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b16167823ULL, 0x000fc4000001082dULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001082dULL,
0x0000001f001f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b241e7823ULL, 0x102fe4000001082dULL,
0x3c003c00ff247424ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b1d1d7823ULL, 0x000fe2000001082dULL, 0x0000003200327308ULL, 0x000e700000000800ULL,
0x0000002900377308ULL, 0x0003f00000000800ULL, 0x0000000b00367308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b25297823ULL, 0x002fc4000001080cULL, 0x3c003c00ff257424ULL, 0x000fca00078e00ffULL,
0x0000002e002e7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b2f0b7823ULL, 0x004fe2000001080cULL,
0x0000001b0e0c723eULL, 0x000fe400000000ffULL, 0x0000000d100e723eULL, 0x008fe400000000ffULL,
0x000000200f0d723eULL, 0x010fe200000000ffULL, 0x3fb8aa3b18207823ULL, 0x100fe2000001082dULL,
0x0000001f320f723eULL, 0x000fe200000000ffULL, 0x0000003500357308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b1a1f7823ULL, 0x000fca000001082dULL, 0x000000240c10723cULL, 0x000f6200000018ffULL,
0x0000002e3718723eULL, 0x002fe200000000ffULL, 0x0000002200227308ULL, 0x000fe20000000800ULL,
0x00000002ff2e7819ULL, 0x000fc80000011606ULL, 0x000000032e387819ULL, 0x040fe200000006ffULL,
0x000000082e327824ULL, 0x040fe200078e00ffULL, 0x000000012e2d7810ULL, 0x040fe20007ffe0ffULL,
0x0000002100217308ULL, 0x000e620000000800ULL, 0x00000036351a723eULL, 0x004fe200000000ffULL,
0x000000082e3a7824ULL, 0x000fe200078e00ffULL, 0xfffffff832327812ULL, 0x000fe200078ee22dULL,
0x000000082e2d7824ULL, 0x040fe200078e00ffULL, 0x000000022e317810ULL, 0x040fe20007ffe0ffULL,
0x000000082e3c7824ULL, 0x000fe400078e00ffULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000003400347308ULL, 0x000ea20000000800ULL, 0x000000222119723eULL, 0x002fce00000000ffULL,
0x00000020002f7308ULL, 0x0003e20000000800ULL, 0x00000023341b723eULL, 0x004fce00000000ffULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x000000082e347824ULL, 0x000fe200078e00ffULL,
0x000000241820723cULL, 0x022b680000001810ULL, 0xfffffff834347812ULL, 0x000fe400078ee231ULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0x000000082e137824ULL, 0x060fe200078e00ffULL,
0x000000032e107810ULL, 0x000fcc0007ffe0ffULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x000000042e117810ULL, 0x000fe40007ffe0ffULL, 0xfffffff813367812ULL, 0x000fe400078ee210ULL,
0xfffffff838387812ULL, 0x000fc600078ee211ULL, 0x0000002c002c7308ULL, 0x000ea20000000800ULL,
0x000000272a10723eULL, 0x002fce00000000ffULL, 0x0000001e001e7308ULL, 0x000ff00000000800ULL,
0x0000001f001f7308ULL, 0x000e620000000800ULL, 0x0000002b2c12723eULL, 0x004fe400000000ffULL,
0xfffffff82d2c7812ULL, 0x000fc400078ee22eULL, 0xffffffff2e2b7810ULL, 0x000fc60007ffe0ffULL,
0x0000003000307308ULL, 0x000ea20000000800ULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee22bULL,
0x0000001e1f11723eULL, 0x002fca00000000ffULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0x000000052e1e7810ULL, 0x040fe40007ffe0ffULL, 0x000000062e1f7810ULL, 0x000fe40007ffe0ffULL,
0x0000002f3013723eULL, 0x004fc600000000ffULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x000000082e2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe400078ee21fULL,
0x000000241020723cULL, 0x000f640000001820ULL, 0xfffffff82f307812ULL, 0x000fe400078ee21eULL,
0x0000002900297308ULL, 0x000ff00000000800ULL, 0x0000002600267308ULL, 0x000e700000000800ULL,
0x0000001600167308ULL, 0x000ff00000000800ULL, 0x0000001700177308ULL, 0x000ea20000000800ULL,
0x00000029261e723eULL, 0x002fce00000000ffULL, 0x0000001c00277308ULL, 0x0003f00000000800ULL,
0x0000001d002a7308ULL, 0x0004e20000000800ULL, 0x000000082e1c7810ULL, 0x002fe40007ffe0ffULL,
0x0000000c152e7812ULL, 0x000fc600078ec0ffULL, 0x000000081c2d7824ULL, 0x000fe200078e00ffULL,
0x00000016171d723eULL, 0x004fc800000000ffULL, 0xfffffff82d3e7812ULL, 0x000fe400078ee21cULL,
0x0000000b281c723eULL, 0x000fe400000000ffULL, 0x00011000000b7811ULL, 0x000fe400078e58ffULL,
0x000000272a1f723eULL, 0x008fc600000000ffULL, 0x000000102c157824ULL, 0x100fe400078e020bULL,
0x0000001032167824ULL, 0x100fe400078e020bULL, 0x000000241c20723cULL, 0x020b620000001820ULL,
0x0000001034177824ULL, 0x100fe200078e020bULL, 0x000000152e157210ULL, 0x000fe20007ffe0ffULL,
0x0000001036267824ULL, 0x100fe400078e020bULL, 0x0000001038277824ULL, 0x100fe400078e020bULL,
0x0000001030287824ULL, 0x000fe200078e020bULL, 0x0000000c15007388ULL, 0x0003e20000000800ULL,
0x000000012e167824ULL, 0x000fc400078e0216ULL, 0x000000103a297824ULL, 0x100fe400078e020bULL,
0x000000103c2a7824ULL, 0x000fe200078e020bULL, 0x0000000e16007388ULL, 0x0003e20000000800ULL,
0x000000012e177824ULL, 0x040fe400078e0217ULL, 0x000000012e267824ULL, 0x040fe200078e0226ULL,
0x0000002a2e2a7210ULL, 0x000fe20007ffe0ffULL, 0x000000103e0b7824ULL, 0x000fe200078e020bULL,
0x0000001817007388ULL, 0x0003e20000000800ULL, 0x000000012e277824ULL, 0x000fc400078e0227ULL,
0x000000012e287824ULL, 0x040fe200078e0228ULL, 0x0000001a26007388ULL, 0x0003e20000000800ULL,
0x000000012e297824ULL, 0x040fe400078e0229ULL, 0x000000012e247824ULL, 0x020fe200078e020bULL,
0x0000001027007388ULL, 0x0003e20000000800ULL, 0x00000002070b7208ULL, 0x000fe20004800000ULL,
0x000000ffff217224ULL, 0x000fe400078e0022ULL, 0x0000001228007388ULL, 0x0003e80000000800ULL,
0x0000001c29007388ULL, 0x0003e80000000800ULL, 0x0000001e2a007388ULL, 0x0003e80000000800ULL,
0x0000000d24007388ULL, 0x0003e80000000800ULL, 0x0004000f16007388ULL, 0x0003e80000000800ULL,
0x0004001917007388ULL, 0x0003e80000000800ULL, 0x0004001b26007388ULL, 0x0003e80000000800ULL,
0x0004001127007388ULL, 0x0003e80000000800ULL, 0x0004001328007388ULL, 0x0003e80000000800ULL,
0x0004001d29007388ULL, 0x0003e80000000800ULL, 0x0004001f2a007388ULL, 0x0003e80000000800ULL,
0x01b0000814008388ULL, 0x0003e80000000c00ULL, 0x01b2002014008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6080076ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6100076ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01b6180076ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000005d4800720cULL, 0x000fe20003f06070ULL,
0x01b6200076ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff027224ULL, 0x000fd600078e0048ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff981000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0d7807ULL, 0x004fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x000147d0000e7802ULL, 0x000fc40000000f00ULL,
0x00000f2000007944ULL, 0x018fea0003c00000ULL, 0xfffee3d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014820000e7802ULL, 0x000fc40000000f00ULL, 0x00000ed000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff077224ULL, 0x000fe200078e000dULL, 0xfffee40000007947ULL, 0x000fea000383ffffULL,
0x0000000c000e7202ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x00014890000f7802ULL, 0x000fe20000000f00ULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000e1000007944ULL, 0x018fea0003c00000ULL, 0xfffee4c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x000148f0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000db000007944ULL, 0x01afea0003c00000ULL, 0xfffee5c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x00014960000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0007ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x00000d4000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e000dULL, 0xfffee74000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000cULL, 0x0000001f00357802ULL, 0x000fe20000000f00ULL,
0xffffffffff347424ULL, 0x000fe200078e00ffULL, 0x000149d0000f7802ULL, 0x000fc40000000f00ULL,
0x00000cd000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e000dULL,
0xfffee70000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x008fe40004000000ULL,
0xffffffff000f7802ULL, 0x000fc40000000f00ULL, 0x00014a30000e7802ULL, 0x000fc40000000f00ULL,
0x00000cc000007944ULL, 0x012fea0003c00000ULL, 0xfffefe6000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014a80000e7802ULL, 0x000fc40000000f00ULL, 0x00000c7000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e000dULL, 0xfffefea000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0010ULL, 0x00014af0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000bb000007944ULL, 0x012fea0003c00000ULL, 0xfffeff7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0010ULL, 0x00014b50000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000b5000007944ULL, 0x012fea0003c00000ULL, 0xffff007000007947ULL, 0x000fea000383ffffULL,
0x00000008000e7202ULL, 0x000fe20000000f00ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0011ULL,
0x00014bc0000f7802ULL, 0x000fe20000000f00ULL, 0x0000001fff357424ULL, 0x000fc400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x00000ae000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e000dULL, 0xffff020000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0008ULL, 0x00014c30000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x00000a7000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e000dULL,
0xffff01c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x008fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00014c90000e7802ULL, 0x000fc40000000f00ULL,
0x00000a6000007944ULL, 0x012fea0003c00000ULL, 0xffff165000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014ce0000e7802ULL, 0x000fc40000000f00ULL, 0x00000a1000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e000dULL, 0xffff169000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0032ULL, 0x00014d50000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000095000007944ULL, 0x010fea0003c00000ULL, 0xffff176000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0032ULL, 0x00014db0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x000008f000007944ULL, 0x012fea0003c00000ULL, 0xffff186000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0x00014e20000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0031ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000088000007944ULL, 0x010fea0003c00000ULL,
0x0000000d00047202ULL, 0x004fe20000000f00ULL, 0xffff19f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0x00014e90000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fc400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x0000081000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e000dULL,
0xffff19b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x008fe20004000000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x00014ef0000e7802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x012fea0003c00000ULL, 0xffff2ee000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe20004800000ULL, 0xffffffffff0f7424ULL, 0x000fe200078e00ffULL,
0x00014f40000e7802ULL, 0x000fc40000000f00ULL, 0x000007b000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff327224ULL, 0x000fe200078e000dULL, 0xffff2f1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0036ULL, 0x00014fb0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x002fc400078e00ffULL,
0x000006f000007944ULL, 0x010fea0003c00000ULL, 0xffff2fe000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0036ULL, 0x0000001f00357802ULL, 0x000fe20000000f00ULL,
0xffffffffff347424ULL, 0x002fe200078e00ffULL, 0x00015010000f7802ULL, 0x000fc40000000f00ULL,
0x0000069000007944ULL, 0x010fea0003c00000ULL, 0xffff30e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x00015080000f7802ULL, 0x000fe20000000f00ULL,
0x000000ffff0d7224ULL, 0x000fc400078e0031ULL, 0x0000001fff357424ULL, 0x000fe400078e00ffULL,
0xffffffffff347424ULL, 0x000fc400078e00ffULL, 0x0000062000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e000dULL, 0xffff327000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x000150f0000f7802ULL, 0x000fe20000000f00ULL,
0x0000001fff357424ULL, 0x000fe400078e00ffULL, 0xffffffffff347424ULL, 0x000fc400078e00ffULL,
0x000005b000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e000dULL,
0xffff323000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x00015160000c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff077424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000050000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0007ULL, 0xffffe90000007947ULL, 0x000fea000383ffffULL,
0x00000010000e7202ULL, 0x006fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x000151e0000c7802ULL, 0x000fe20000000f00ULL, 0x0000001fff077424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000048000007944ULL, 0x000fea0003c00000ULL,
0x000000071000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x00015260000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001007107208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000040000007944ULL, 0x000fea0003c00000ULL,
0x000000070a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000bULL,
0xffffffff00367802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a070a7208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fe200078e00ffULL,
0x000152e0000c7802ULL, 0x000fc40000000f00ULL, 0x0000038000007944ULL, 0x000fea0003c00000ULL,
0x000000070b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0012ULL,
0x00015360000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000b07027208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000030000007944ULL, 0x000fea0003c00000ULL,
0x000000071200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0010ULL,
0x000153e0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001207087208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000028000007944ULL, 0x000fea0003c00000ULL,
0x000000071000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x00015460000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001007097208ULL, 0x000fe20004000000ULL, 0xffffffffff367424ULL, 0x000fe200078e00ffULL,
0x0000001f00077802ULL, 0x000fc40000000f00ULL, 0x0000020000007944ULL, 0x000fea0003c00000ULL,
0x000000070a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0002ULL,
0x000154e0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a070a7208ULL, 0x000fe20004000000ULL, 0x0000001fff077424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000018000007944ULL, 0x000fea0003c00000ULL,
0xffffe6f000007947ULL, 0x000fea000383ffffULL, 0x018000000b037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003067812ULL, 0x000fc800078ec0ffULL,
0x018000000600780cULL, 0x000fda0003f05070ULL, 0x0000000b00038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0600720cULL, 0x040fe40003f25070ULL,
0x008000000600780cULL, 0x000fe40003f02070ULL, 0x00000001ff067807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x0000000306ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff0bff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff037807ULL, 0x000fc80000000000ULL, 0x0000000306ff7212ULL, 0x000fe4000780c0ffULL,
0x800000000b067812ULL, 0x000fd600078ec0ffULL, 0x0080000006030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0006ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000b00037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffea9a008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000003600007348ULL, 0x000fe80003800000ULL,
0x0c00000f0e077389ULL, 0x0002a200000e0007ULL, 0xfffea9600c007950ULL, 0x000fea0003c3ffffULL,
0x0000003400007348ULL, 0x000fe80003800000ULL, 0x0000000d0e0d7389ULL, 0x0002a400000e0035ULL,
0x000000ffff0e7224ULL, 0x002fc400078e000fULL, 0x00000000ff0f7424ULL, 0x000fc800078e00ffULL,
0xfffea9100e007950ULL, 0x000fea0003c3ffffULL, 0x000000010d00780cULL, 0x000fe20003f25070ULL,
0x0000000f00007348ULL, 0x000fd80003800000ULL, 0x00000000000d7806ULL, 0x000fc800048e0100ULL,
0x0000000f0d0d7212ULL, 0x000fe200078ec0ffULL, 0x00000000ff0f7424ULL, 0x000fc800078e00ffULL,
0xfffea8b00e007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000050aULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000668ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008c0ULL,
0x00000000000003a8ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c68ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d28ULL,
0x00000000000005c0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012e8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012f8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001388ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000138cULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001580ULL,
0x0000000000015800ULL, 0x8000001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016d80ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000016dc0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000017140ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001388ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000159f8ULL,
0x00000000000159f8ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000016d80ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000017140ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_16_sm_80_cubin_len = 94752;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
