/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_16_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000159c0ULL, 0x0000000000015640ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL,
0x36316a4c4545346aULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL,
0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL,
0x735f616475635f5fULL, 0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL,
0x695f5f2400687461ULL, 0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL,
0x5f636e79736c6668ULL, 0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL,
0x376d735f61647563ULL, 0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL,
0x245f335f6c616e72ULL, 0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL,
0x6c65722e00746f6cULL, 0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL,
0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL,
0x2e00667542657479ULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x2e006d617261705fULL, 0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL,
0x65722e00656d6172ULL, 0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL,
0x0000006e6f697463ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000c000100000131ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c000100000178ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL,
0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000c00010000028dULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL,
0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x000c00010000036fULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b0022000003b5ULL, 0x0000000000013e80ULL, 0x0000000000000170ULL, 0x000b0022000003e8ULL,
0x0000000000013ff0ULL, 0x0000000000000040ULL, 0x000b002200000413ULL, 0x0000000000014030ULL,
0x0000000000000050ULL, 0x000b00220000043dULL, 0x0000000000014080ULL, 0x0000000000000100ULL,
0x000a0003000004abULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00040003000004cbULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004fbULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000014180ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00013e8000000000ULL, 0x0000040400000000ULL, 0x810c000001500400ULL,
0x004e440400288080ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL,
0x8e082880808c0828ULL, 0x2880808f08288080ULL, 0x8280162880808808ULL, 0x0000000003102880ULL,
0x8080889200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x00013e8000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080860828808081ULL, 0x8a08288080880828ULL, 0x2880808e08288080ULL, 0x808c082880808f08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x22002880808c9200ULL, 0x0000001cffffffffULL,
0x000000f800000000ULL, 0x00013ff000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080880828808081ULL, 0x8c082880808a0828ULL, 0x2880808e08288080ULL,
0x8280162880808f08ULL, 0x0000000003102880ULL, 0x80808f9200000000ULL, 0x0000000000220028ULL,
0x0000002cffffffffULL, 0x0000018000000000ULL, 0x0001403000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x808e2880808f0900ULL, 0x0000000000002880ULL, 0x00000054ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080880828808081ULL, 0x8c082880808a0828ULL, 0x2880808f08288080ULL, 0x8280162880808e08ULL,
0x0000000003102880ULL, 0x80808e9200000000ULL, 0x0000000000220028ULL, 0x0000001cffffffffULL,
0x0000021800000000ULL, 0x0001408000000000ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000001800082f04ULL, 0x000823040000007fULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL,
0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL, 0x0000000000000012ULL,
0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL, 0x0000001100082304ULL,
0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL, 0x0008230400000000ULL,
0x0000000000000018ULL, 0x0000001800081204ULL, 0x0008110400000000ULL, 0x0000000000000018ULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0060016000000015ULL, 0x000c170400601903ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040021f000ULL,
0x0048000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040081f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0x000008b000043104ULL, 0xffffffff01542904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000002f001542804ULL, 0x000004e000000410ULL, 0x00002bb000001a70ULL, 0x00002d8000002c60ULL,
0x000030e000002ee0ULL, 0x0000316000003110ULL, 0x00003890000031b0ULL, 0x0000492000004880ULL,
0x00004bb000004a50ULL, 0x00004df000004dc0ULL, 0x00004e9000004e40ULL, 0x00006290000052a0ULL,
0x0000646000006330ULL, 0x000067d0000065c0ULL, 0x0000685000006800ULL, 0x00006ca0000068a0ULL,
0x00007dd000007d40ULL, 0x0000806000007f00ULL, 0x000082a000008270ULL, 0x00008340000082f0ULL,
0x000088e0000088d0ULL, 0x0000acb00000ac70ULL, 0x0000b4300000b3f0ULL, 0x000127c000012780ULL,
0x000127e0000127d0ULL, 0x00012850000127f0ULL, 0x0001289000012870ULL, 0x00013500000134c0ULL,
0x0001359000013550ULL, 0x00013630000135e0ULL, 0x000136c000013680ULL, 0x0001375000013710ULL,
0x000137f0000137a0ULL, 0x0001388000013840ULL, 0x00013910000138d0ULL, 0x000139b000013960ULL,
0x00013a4000013a00ULL, 0x00013ad000013a90ULL, 0x00013b7000013b20ULL, 0x00013c2000013bc0ULL,
0x00013ce000013c80ULL, 0x00013da000013d40ULL, 0x00013e6000013e00ULL, 0x000003e002003904ULL,
0x00013600000000ffULL, 0x00000450003f0100ULL, 0x000136080000000bULL, 0x00000490003f0120ULL,
0x000136880000000bULL, 0x000008c0003f0120ULL, 0x00013600000000ffULL, 0x00000ad0003f0107ULL,
0x0001368c0000006eULL, 0x00000ba0003f0102ULL, 0x000136880000006eULL, 0x000028b0003f0101ULL,
0x0001360800000004ULL, 0x000028d0003f0101ULL, 0x0001360c00000004ULL, 0x00002aa0003f0105ULL,
0x0001360c00000004ULL, 0x00003830003f0105ULL, 0x0001368800000057ULL, 0x000045e0003f0101ULL,
0x0001362800000012ULL, 0x00004600003f0101ULL, 0x0001362c00000012ULL, 0x000047d0003f0105ULL,
0x0001362c00000012ULL, 0x00005220003f0105ULL, 0x000000000000000eULL, 0x00005ff0003f0101ULL,
0x0001364800000032ULL, 0x00006010003f0101ULL, 0x0001364c00000032ULL, 0x000061e0003f0105ULL,
0x0001364c00000032ULL, 0x00006c80003f0105ULL, 0x000000000000000dULL, 0x00007aa0003f0101ULL,
0x0001366800000034ULL, 0x00007ac0003f0101ULL, 0x0001366c00000034ULL, 0x00007c90003f0105ULL,
0x0001366c00000034ULL, 0x00008720003f0105ULL, 0x000000000000000aULL, 0x0000c380003f0101ULL,
0x00013600000000ffULL, 0x0000cf50003f0101ULL, 0x00013604000000ffULL, 0x0000d120003f0105ULL,
0x00013604000000ffULL, 0x00010d40003f0105ULL, 0x0000000000000072ULL, 0x00010d80003f0101ULL,
0x0000000400000072ULL, 0x00010f50003f0105ULL, 0x0000000400000072ULL, 0x00013320003f0105ULL,
0x0001360800000073ULL, 0x00013380003f0101ULL, 0x0001361000000073ULL, 0x000133e0003f0101ULL,
0x0001361800000073ULL, 0x00013450003f0101ULL, 0x0001362000000073ULL, 0x00033803003f0101ULL,
0x0000bc7000201c04ULL, 0x0000be800000bca0ULL, 0x0000c1700000bfe0ULL, 0x0000d1800000c270ULL,
0x0000040100013490ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000028cULL, 0x0000001800000002ULL,
0x00000000000001f4ULL, 0x0000001800000002ULL, 0x000000000000016cULL, 0x0000001800000002ULL,
0x00000000000000e4ULL, 0x0000001800000002ULL, 0x0000000000000044ULL, 0x0000001800000002ULL,
0x0000000000000264ULL, 0x0000001800000002ULL, 0x00000000000001ccULL, 0x0000001800000002ULL,
0x0000000000000149ULL, 0x0000001800000002ULL, 0x00000000000000bcULL, 0x0000001800000002ULL,
0x0000000000013700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0e7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000747919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000a7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000e787a19ULL, 0x000fe200000006ffULL,
0x00000000000579c3ULL, 0x000f220000002500ULL, 0x0000000000097919ULL, 0x000ea20000002100ULL,
0x0000460000087ab9ULL, 0x000fc60000000a00ULL, 0x0000000000777919ULL, 0x000ea20000002700ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003077a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a07ULL, 0x0000040003007624ULL, 0x000fca00078e020eULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff07aa12ULL, 0x000fc800078e33ffULL,
0x0000000700007306ULL, 0x000e620000209000ULL, 0x000000ff0700720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000307047224ULL, 0x004fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a04ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000007403717227ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000ee40000002200ULL, 0x000000ffff007224ULL, 0x000fc800078e0a71ULL,
0x0000000007007224ULL, 0x000fca00078e0274ULL, 0x000000070000720cULL, 0x000fda0003f06070ULL,
0x0000000100000824ULL, 0x000fe200078e0a07ULL, 0x0000000171710810ULL, 0x000fe20007ffe0ffULL,
0x000001000a027a24ULL, 0x008fe400078e0203ULL, 0x00001fff0a0a7589ULL, 0x000fe200000e0000ULL,
0x000000070000720cULL, 0x000fe20003f26070ULL, 0x00000000020b7a24ULL, 0x000fca00078e0209ULL,
0x000000ff0b00720cULL, 0x040fe40003f65270ULL, 0x0000000f0b00780cULL, 0x040fe40003f84070ULL,
0x000000030b00780cULL, 0x000fc60003f04070ULL, 0x0000000171711810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff71a212ULL, 0x000fe400078e33ffULL, 0x0000007f0b00780cULL, 0x000fe40003f24070ULL,
0x3fffff80ff02b424ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x000fe400078e0a71ULL,
0x7fffff80ff03b424ULL, 0x000fc400078e00ffULL, 0x0000000007747224ULL, 0x000fe200078e0274ULL,
0x00000005ff077819ULL, 0x000fe20000011609ULL, 0x3fffffc0ff04c424ULL, 0x000fe200078e00ffULL,
0x01360002ff00b388ULL, 0x0003e20000000a00ULL, 0x00000010746f7824ULL, 0x000fe400078e00ffULL,
0x7fffffc0ff05c424ULL, 0x000fe200078e00ffULL, 0x00001fff07077589ULL, 0x000ea200000e0000ULL,
0x3fffff60ff088424ULL, 0x000fe200078e00ffULL, 0x000000046f007c10ULL, 0x000fe2000fffe1ffULL,
0x7fffff60ff098424ULL, 0x000fe200078e00ffULL, 0x013608040b00c388ULL, 0x000fe20000008a00ULL,
0xff317217ff069424ULL, 0x000fe200078e00ffULL, 0x0000001000007817ULL, 0x000fe20003800000ULL,
0x0000580077037a24ULL, 0x002fe200078e02ffULL, 0x013688080b008388ULL, 0x000fe20000008a00ULL,
0x000000046f007c0cULL, 0x000fc6000bf03070ULL, 0x013400060b009388ULL, 0x000fe20000004800ULL,
0x000000ff00737207ULL, 0x000fe40000000000ULL, 0x00005a0071007a19ULL, 0x000fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000107300780cULL, 0x000fe20003f05270ULL,
0x00000005ff067e24ULL, 0x010fc4000f8e00ffULL, 0x000000040a027824ULL, 0x004fe400078e0207ULL,
0x0000007803007224ULL, 0x000fe400078e0200ULL, 0x0000000202027824ULL, 0x000fcc00078e00ffULL,
0x000001d000008947ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00000004ff0b7819ULL, 0x002fca0000011605ULL,
0x0000000102047824ULL, 0x000fc800078e020bULL, 0x000000016f037824ULL, 0x000fca00078e0204ULL,
0x0000000403097c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff037a19ULL, 0x000fc60000011603ULL,
0x0000000100007824ULL, 0x000fe200078e0209ULL, 0x0000000273097217ULL, 0x000fc60007800000ULL,
0x0000007803007224ULL, 0x000fe400078e0200ULL, 0x0000001005037824ULL, 0x000fe400078e00ffULL,
0x0000000109027824ULL, 0x000fe400078e0a02ULL, 0x0000010000087825ULL, 0x000fe200078e00ffULL,
0x000000f0030d7812ULL, 0x000fe400078ec0ffULL, 0x000000020b00720cULL, 0x000fe20003f06070ULL,
0x0000000104007824ULL, 0x000fe200078e0205ULL, 0x0000000d080d7212ULL, 0x000fe200078efcffULL,
0x00000010040b7824ULL, 0x000fc600078e00ffULL, 0x00005e000d087a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00b007812ULL, 0x000fe400078ee200ULL, 0x00005f0009097a10ULL, 0x000fc60000ffe4ffULL,
0x00000010000b7824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000080b7faeULL, 0x0003e2000c101c48ULL, 0x0000018000007947ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x0000000205027211ULL, 0x002fca00078fe0ffULL, 0x000000016f037824ULL, 0x000fca00078e0202ULL,
0x0000000403097c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff037a19ULL, 0x000fc60000011603ULL,
0x0000000100097824ULL, 0x000fe200078e0209ULL, 0x0000000502007210ULL, 0x000fc60007ffe0ffULL,
0x0000007803097224ULL, 0x000fe400078e0209ULL, 0x0000001005037824ULL, 0x000fe400078e00ffULL,
0x0000010009087825ULL, 0x000fc600078e00ffULL, 0x000000f0030b7812ULL, 0x000fc800078ec0ffULL,
0x0000000b08087212ULL, 0x000fe200078efcffULL, 0x00000010020b7824ULL, 0x000fc600078e00ffULL,
0x00005e0008087a10ULL, 0x000fe40007f1e0ffULL, 0xfffffff00b007812ULL, 0x000fe400078ee200ULL,
0x00005f0009097a10ULL, 0x000fc600007fe4ffULL, 0x00000010000b7824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000080b7faeULL, 0x0003e4000b901c48ULL,
0x0000000000097919ULL, 0x002e620000000000ULL, 0x0000000000027806ULL, 0x000fc600038e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000200007300ULL, 0x000e7000000e0000ULL,
0x0000000200047309ULL, 0x000ea20000000000ULL, 0x000000090000720cULL, 0x002fe20003f02070ULL,
0x00000004ff007424ULL, 0x000fc400078e00ffULL, 0x000000ffff047224ULL, 0x004fe400078e0a04ULL,
0x0000660077087625ULL, 0x000fd000078e0000ULL, 0x01360404ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01360000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000808617981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0a00720cULL, 0x000fe40003f05270ULL,
0x0000003f616c7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff61657810ULL, 0x000fc40007ffe0ffULL,
0x00000006ff6c7819ULL, 0x000fe4000001166cULL, 0x00000008ff657819ULL, 0x000fca0000011665ULL,
0x0000b87000008947ULL, 0x000fea0003800000ULL, 0x00000002ff6d7819ULL, 0x000fe20000011607ULL,
0x00000008076e7824ULL, 0x000fe400078e00ffULL, 0x00000003ff0d7424ULL, 0x000fe200078e00ffULL,
0x03ffffff6d0b7812ULL, 0x000fca00078ec0ffULL, 0x00000004060b7824ULL, 0x000fca00078e020bULL,
0x0000006c0b00720cULL, 0x000fda0003f06070ULL, 0x0000000277028824ULL, 0x000fe400078e00ffULL,
0x00006800ff098624ULL, 0x000fc800078e00ffULL, 0x0000680002048624ULL, 0x002fe400078e0209ULL,
0xffffffffff027424ULL, 0x000fe400078e00ffULL, 0x000000010b098824ULL, 0x000fe200078e0204ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01368c0d6eff738cULL, 0x0003e20000000000ULL,
0x0000640009088625ULL, 0x000fe200078e0000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000808028981ULL, 0x000ea2000c1e1900ULL, 0x00000001060a7810ULL, 0x000fe20007ffe0ffULL,
0x0000004071687824ULL, 0x000fe200078e00ffULL, 0x00000001ff047819ULL, 0x000fe20000011607ULL,
0x00000100ff0d7424ULL, 0x002fe200078e00ffULL, 0x000000650a00720cULL, 0x000fe20003f06070ULL,
0x013688006eff7f8cULL, 0x0003e2000c80043fULL, 0x00000001076b7812ULL, 0x000fe200078ec0ffULL,
0x00000020046f7824ULL, 0x000fc800078e00ffULL, 0x00000100060f7824ULL, 0x000fca00078e026fULL,
0x00000020680a7812ULL, 0x000fe200078ef80fULL, 0x0000590002027a24ULL, 0x004fc800078e02ffULL,
0x0000004002027824ULL, 0x000fc800078e00ffULL, 0x0000620002087625ULL, 0x000fe200078e000dULL,
0x0000064000008947ULL, 0x000fea0003800000ULL, 0x00000003ff187819ULL, 0x002fe20000011605ULL,
0x0000000204177824ULL, 0x000fe200078e026bULL, 0x0000000f61027217ULL, 0x000fe40007800000ULL,
0x00000004180e7810ULL, 0x040fe40007ffe0ffULL, 0x0000000c18167810ULL, 0x000fe20007ffe0ffULL,
0x0000000102027824ULL, 0x000fe200078e0a0fULL, 0x0000000818107810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0c7824ULL, 0x100fe200078e0205ULL, 0x00000014181c7810ULL, 0x000fe20007ffe0ffULL,
0x000000080e1d7824ULL, 0x000fe200078e00ffULL, 0x0000002002197817ULL, 0x000fe20003800000ULL,
0x00000001160f7824ULL, 0x100fe200078e0205ULL, 0x00000010181a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000816147824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee20cULL,
0x00000001100d7824ULL, 0x040fe200078e0205ULL, 0x00000070030c7812ULL, 0x000fe200078ec0ffULL,
0x0000000810127824ULL, 0x000fe200078e00ffULL, 0xfffffff814217812ULL, 0x000fe200078ee20fULL,
0x000000010a0f7824ULL, 0x000fe200078e020eULL, 0x000000190e00720cULL, 0x080fe20003f86070ULL,
0x000000806b027824ULL, 0x000fe200078e020cULL, 0xfffffff8121f7812ULL, 0x000fe200078ee20dULL,
0x000000ffff037224ULL, 0x000fe200078e00ffULL, 0x000000191000720cULL, 0x080fe20003f66070ULL,
0x000000010a0d7824ULL, 0x000fe200078e0218ULL, 0x000000191600720cULL, 0x080fe20003f46070ULL,
0x000001000f0e7825ULL, 0x000fe200078e0002ULL, 0x000000191800720cULL, 0x000fc60003fa6070ULL,
0x000001000d0c7825ULL, 0x000fe200078e0002ULL, 0x0000000e08147210ULL, 0x000fc60007f3e0ffULL,
0x000000011c137824ULL, 0x000fe200078e0205ULL, 0x0000000c08127210ULL, 0x000fe20007f1e0ffULL,
0x000000081c207824ULL, 0x000fe400078e00ffULL, 0x0000000109157824ULL, 0x040fe200008e060fULL,
0x000000191a00720cULL, 0x040fe20003f26070ULL, 0x000000011a117824ULL, 0x000fe200078e0205ULL,
0xfffffff820277812ULL, 0x000fe200078ee213ULL, 0x000000081a1e7824ULL, 0x000fe200078e00ffULL,
0x0000000d09137210ULL, 0x000fe200007fe4ffULL, 0x000000010a0f7824ULL, 0x000fc400078e0216ULL,
0x000000010a0d7824ULL, 0x000fe200078e0210ULL, 0xfffffff81e237812ULL, 0x000fe200078ee211ULL,
0x0000000118107824ULL, 0x040fe200078e0205ULL, 0x0000001c181e7810ULL, 0x000fe20007ffe0ffULL,
0x000001000f0e7825ULL, 0x000fc600078e0002ULL, 0x0000000710167812ULL, 0x000fe200078ec0ffULL,
0x000000010a117824ULL, 0x000fe200078e021aULL, 0x0000000e080e7210ULL, 0x000fe20007fde0ffULL,
0x000001000d0c7825ULL, 0x000fe200078e0002ULL, 0x0000b000171a7811ULL, 0x000fe400078e68ffULL,
0x0ffffff816177812ULL, 0x000fe200078ef805ULL, 0x0000010011107825ULL, 0x000fe200078e0002ULL,
0x0000000c080c7210ULL, 0x000fc60007f1e0ffULL, 0x00000001090f7824ULL, 0x000fe200030e060fULL,
0x0000001008167210ULL, 0x000fe20007fde0ffULL, 0x000000010a257824ULL, 0x000fe400078e021cULL,
0x00000010171b7824ULL, 0x000fe400078e021aULL, 0x0000000109177824ULL, 0x040fe400030e0611ULL,
0x00000001090d7824ULL, 0x000fe200000e060dULL, 0x000000191c00720cULL, 0x080fe20003f06070ULL,
0x0000010025107825ULL, 0x000fe200078e0002ULL, 0x00000018181c7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000121b7faeULL, 0x0003e4000e901c48ULL,
0x000000101d1d7824ULL, 0x000fe200078e021aULL, 0x0000001008187210ULL, 0x000fe20007fde0ffULL,
0x000000010a257824ULL, 0x000fe200078e021cULL, 0x000000191c00720cULL, 0x080fe20003fa6070ULL,
0x000000010a297824ULL, 0x000fe200078e021eULL, 0x00000000141d7faeULL, 0x0005e2000e101c48ULL,
0x000000191e00720cULL, 0x000fe20003f86070ULL, 0x0000000109197824ULL, 0x000fc400030e0611ULL,
0x0000010025107825ULL, 0x000fc800078e0002ULL, 0x000000011c0a7824ULL, 0x100fe200078e0205ULL,
0x0000001008107210ULL, 0x000fe20007fde0ffULL, 0x000000081c137824ULL, 0x002fe400078e00ffULL,
0x000000011e127824ULL, 0x040fe400078e0205ULL, 0x000000081e157824ULL, 0x004fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee20aULL, 0x0000010029027825ULL, 0x000fc600078e0002ULL,
0xfffffff815157812ULL, 0x000fe200078ee212ULL, 0x0000000109117824ULL, 0x000fe200030e0611ULL,
0x0000000208027210ULL, 0x000fe20007fde0ffULL, 0x000000101f1f7824ULL, 0x100fe400078e021aULL,
0x0000001021217824ULL, 0x100fe400078e021aULL, 0x0000001023237824ULL, 0x100fe200078e021aULL,
0x000000000c1f7faeULL, 0x0003e2000d901c48ULL, 0x0000001027277824ULL, 0x100fe400078e021aULL,
0x0000001013137824ULL, 0x100fe200078e021aULL, 0x000000000e217faeULL, 0x0003e2000d101c48ULL,
0x0000001015157824ULL, 0x000fc400078e021aULL, 0x0000000109037824ULL, 0x000fe200030e0603ULL,
0x0000000016237faeULL, 0x0003e8000c901c48ULL, 0x0000000018277faeULL, 0x0003e8000c101c48ULL,
0x0000000010137faeULL, 0x0003e8000e901c48ULL, 0x0000000002157faeULL, 0x0003e2000e101c48ULL,
0x0000057000007947ULL, 0x000fea0003800000ULL, 0x00000004050c7811ULL, 0x042fe200078fe8ffULL,
0x0000000204197824ULL, 0x000fe200078e026bULL, 0x00000008050e7811ULL, 0x000fc400078fe8ffULL,
0x0000000c05107811ULL, 0x040fe200078fe8ffULL, 0x000000010c027824ULL, 0x140fe200078e0205ULL,
0x0000001005127811ULL, 0x040fe200078fe8ffULL, 0x000000080c0f7824ULL, 0x000fe200078e00ffULL,
0x0000001405147811ULL, 0x040fe200078fe8ffULL, 0x000000010e0d7824ULL, 0x040fe200078e0205ULL,
0x0000001805167811ULL, 0x000fe200078fe8ffULL, 0x000000080e1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f1a7812ULL, 0x000fe200078ee202ULL, 0x0000000810137824ULL, 0x040fe200078e00ffULL,
0x0000000510027210ULL, 0x080fe20007ffe0ffULL, 0x0000000812207824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20dULL, 0x00000001120d7824ULL, 0x100fe200078e0205ULL,
0x0000007003187812ULL, 0x000fe200078ec0ffULL, 0x00000001140f7824ULL, 0x140fe200078e0205ULL,
0x0000001c05037811ULL, 0x000fe200078fe8ffULL, 0x0000000814227824ULL, 0x000fe200078e00ffULL,
0xfffffff8131e7812ULL, 0x000fe200078ee202ULL, 0x0000000116117824ULL, 0x040fe200078e0205ULL,
0x0000000505027211ULL, 0x000fe200078fe8ffULL, 0x0000000816247824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee20dULL, 0x000000010a0d7824ULL, 0x000fe200078e020cULL,
0x0000000702027812ULL, 0x000fe200078ec0ffULL, 0x00000001030c7824ULL, 0x000fe200078e0205ULL,
0x0000b00019297811ULL, 0x000fe200078e68ffULL, 0x00000008031d7824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee20fULL, 0x000000010a1b7824ULL, 0x000fe200078e0203ULL,
0x0000000a05037211ULL, 0x000fe200078fe8ffULL, 0x000000806b187824ULL, 0x000fe200078e0218ULL,
0xfffffff824247812ULL, 0x000fe200078ee211ULL, 0x000000ffff197224ULL, 0x000fe200078e00ffULL,
0xfffffff81d267812ULL, 0x000fe200078ee20cULL, 0x000000010a0f7824ULL, 0x000fc400078e020eULL,
0x000000010a117824ULL, 0x040fe400078e0210ULL, 0x000000010a137824ULL, 0x040fe400078e0212ULL,
0x000000010a157824ULL, 0x040fe400078e0214ULL, 0x000000010a177824ULL, 0x000fe200078e0216ULL,
0x0ffffff8020a7812ULL, 0x000fe200078ef805ULL, 0x0000010003027825ULL, 0x000fc800078e0018ULL,
0x000001000d0c7825ULL, 0x000fe200078e0018ULL, 0x0000000208027210ULL, 0x000fc60007f1e0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0018ULL, 0x0000000c080c7210ULL, 0x000fc60007f3e0ffULL,
0x0000010011107825ULL, 0x000fe200078e0018ULL, 0x0000000e080e7210ULL, 0x000fc60007f5e0ffULL,
0x0000010013127825ULL, 0x000fe200078e0018ULL, 0x0000001008107210ULL, 0x000fc60007f7e0ffULL,
0x0000010015147825ULL, 0x000fc800078e0018ULL, 0x0000010017167825ULL, 0x000fc800078e0018ULL,
0x000001001b187825ULL, 0x000fc800078e0018ULL, 0x0000000109037824ULL, 0x040fe200000e0603ULL,
0x0000001208127210ULL, 0x040fe20007f1e0ffULL, 0x00000001090d7824ULL, 0x040fe200008e060dULL,
0x0000001408147210ULL, 0x000fe20007f3e0ffULL, 0x000000100a1b7824ULL, 0x000fe200078e0229ULL,
0x0000001309137210ULL, 0x040fe200007fe4ffULL, 0x00000001090f7824ULL, 0x040fe200010e060fULL,
0x0000001608167210ULL, 0x000fe20007f5e0ffULL, 0x000000101a1d7824ULL, 0x000fe200078e0229ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000021b7faeULL, 0x0003e2000b901c48ULL,
0x0000000109117824ULL, 0x000fe200018e0611ULL, 0x0000001808087210ULL, 0x000fe20007f7e0ffULL,
0x000000101c1f7824ULL, 0x100fe200078e0229ULL, 0x000000000c1d7faeULL, 0x0003e2000b901c48ULL,
0x000000101e217824ULL, 0x000fc400078e0229ULL, 0x0000001020237824ULL, 0x100fe200078e0229ULL,
0x000000000e1f7faeULL, 0x0003e2000b901c48ULL, 0x0000001022257824ULL, 0x000fe400078e0229ULL,
0x0000000109157824ULL, 0x040fe200008e0615ULL, 0x0000000010217faeULL, 0x0003e2000b901c48ULL,
0x0000001024277824ULL, 0x000fe400078e0229ULL, 0x0000000109177824ULL, 0x000fe200010e0617ULL,
0x0000000012237faeULL, 0x0003e2000b901c48ULL, 0x0000001026297824ULL, 0x000fc400078e0229ULL,
0x0000000109097824ULL, 0x000fe200018e0619ULL, 0x0000000014257faeULL, 0x0003e8000b901c48ULL,
0x0000000016277faeULL, 0x0003e8000b901c48ULL, 0x0000000008297faeULL, 0x0003e4000b901c48ULL,
0x00000300ff037624ULL, 0x002fe200078e00ffULL, 0x000000030b027812ULL, 0x000fe200078ec0ffULL,
0xffffffffff087424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xfffffffd00727424ULL, 0x000fe200078e0203ULL, 0x000000030200780cULL, 0x000fc80003f05270ULL,
0x0000000172027807ULL, 0x000fca0004000000ULL, 0x000000010b097824ULL, 0x000fca00078e0202ULL,
0x0000006c0900720cULL, 0x000fda0003f06070ULL, 0x0000000277028824ULL, 0x000fe400078e00ffULL,
0x00006800ff038624ULL, 0x000fc800078e00ffULL, 0x0000680002028624ULL, 0x000fc800078e0203ULL,
0x0000000102038824ULL, 0x000fc800078e0209ULL, 0x0000640003028625ULL, 0x000fca00078e0000ULL,
0x0000000802088981ULL, 0x000322000c1e1900ULL, 0x000000650600720cULL, 0x000fe20003f06070ULL,
0xff317217ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00006d4000000947ULL, 0x000fea0003800000ULL, 0x0000000277697824ULL, 0x002fe400078e00ffULL,
0x00006800ff007624ULL, 0x000fc400078e00ffULL, 0xff317217ff0c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fe400078e00ffULL, 0x0000680069697624ULL, 0x000fc400078e0200ULL,
0x00000010070a7824ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe00a0d7812ULL, 0x000fe200078ec0ffULL, 0x0000590008087a24ULL, 0x010fe200078e02ffULL,
0x00000001060a7810ULL, 0x040fe20007ffe0ffULL, 0x00000100ff0f7424ULL, 0x000fe400078e00ffULL,
0x00000100060d7824ULL, 0x000fe200078e020dULL, 0x000000650a00720cULL, 0x000fe20003f06070ULL,
0x0000004008087824ULL, 0x000fc600078e00ffULL, 0x000000400d317810ULL, 0x000fe20007ffe0ffULL,
0x00006200080e7625ULL, 0x000fc600078e000fULL, 0x00000020310d7812ULL, 0x000fca00078ec0ffULL,
0x0000000168087824ULL, 0x000fe200078e020dULL, 0x0000068000008947ULL, 0x020fea0003800000ULL,
0x00000031610a7217ULL, 0x000fe20007800000ULL, 0x00000010050d7824ULL, 0x000fe200078e00ffULL,
0x00000003ff3e7819ULL, 0x000fe20000011605ULL, 0x0000008007307824ULL, 0x000fe400078e00ffULL,
0x000000010a317824ULL, 0x000fe200078e0a31ULL, 0x000000700d0d7812ULL, 0x000fe200078ec0ffULL,
0x00002000070a7824ULL, 0x000fe200078e00ffULL, 0x000000043e367810ULL, 0x040fe20007ffe0ffULL,
0x000000013e347824ULL, 0x000fe200078e0205ULL, 0x000000800d307812ULL, 0x000fc400078ef830ULL,
0x000020000a0d7812ULL, 0x000fe200078ec0ffULL, 0x00000001360a7824ULL, 0x000fe200078e0205ULL,
0x0000000c3e447810ULL, 0x000fe20007ffe0ffULL, 0x0000000836337824ULL, 0x000fe200078e00ffULL,
0x000000083e407810ULL, 0x000fe20007ffe0ffULL, 0x00004000043a7824ULL, 0x000fe200078e020dULL,
0x00000020313d7817ULL, 0x000fe20003800000ULL, 0x00000001440d7824ULL, 0x140fe200078e0205ULL,
0xfffffff833427812ULL, 0x000fe200078ee20aULL, 0x0000000844327824ULL, 0x000fe200078e00ffULL,
0x000000103e467810ULL, 0x000fe20007ffe0ffULL, 0x00000001403c7824ULL, 0x000fe200078e0205ULL,
0x000000143e487810ULL, 0x000fe20007ffe0ffULL, 0x0000000840357824ULL, 0x000fe200078e00ffULL,
0xfffffff8320d7812ULL, 0x000fe200078ee20dULL, 0x000000013e337824ULL, 0x000fe200078e0208ULL,
0x00000005460a7210ULL, 0x040fe20007ffe0ffULL, 0x000000ffff317224ULL, 0x000fe200078e00ffULL,
0xfffffff8353c7812ULL, 0x000fe200078ee23cULL, 0x0000000846357824ULL, 0x000fe200078e00ffULL,
0x0000003d4000720cULL, 0x080fe20003f06070ULL, 0x0000010033327825ULL, 0x000fe200078e0030ULL,
0x0000003d3600720cULL, 0x000fc40003f66070ULL, 0xfffffff8350a7812ULL, 0x000fe200078ee20aULL,
0x0000000148047824ULL, 0x000fe200078e0205ULL, 0x000000320e387210ULL, 0x000fe20007f5e0ffULL,
0x0000000848377824ULL, 0x000fe200078e00ffULL, 0x0000c0003a3f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000136357824ULL, 0x100fe200078e0208ULL, 0x0000003d3e00720cULL, 0x080fe20003f86070ULL,
0x00000001443b7824ULL, 0x000fe200078e0208ULL, 0xfffffff837047812ULL, 0x000fe200078ee204ULL,
0x0000000140377824ULL, 0x000fe200078e0208ULL, 0x0000000734407812ULL, 0x000fe200078ec0ffULL,
0x000000010f397824ULL, 0x000fe200010e0633ULL, 0x0000003d4400720cULL, 0x000fe20003f26070ULL,
0x0000010035327825ULL, 0x000fe200078e0030ULL, 0x0ffffff840407812ULL, 0x000fc600078ef805ULL,
0x0000010037347825ULL, 0x000fe200078e0030ULL, 0x000000320e3a7210ULL, 0x000fc60007f5e0ffULL,
0x000001003b367825ULL, 0x000fe200078e0030ULL, 0x000000340e327210ULL, 0x000fc60007fbe0ffULL,
0x000000010f3b7824ULL, 0x040fe200010e0633ULL, 0x000000360e347210ULL, 0x000fe20007fde0ffULL,
0x000000010f337824ULL, 0x040fe200028e0635ULL, 0x0000003d4600720cULL, 0x080fe20003f46070ULL,
0x0000001040417824ULL, 0x000fe200078e023fULL, 0x000000183e407810ULL, 0x040fe20007ffe0ffULL,
0x000000010f357824ULL, 0x000fe200030e0637ULL, 0x0000001c3e3e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000146377824ULL, 0x000fe200078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038417faeULL, 0x0003e2000e101c48ULL, 0x0000001042437824ULL, 0x000fe200078e023fULL,
0x0000003d4800720cULL, 0x080fe20003fa6070ULL, 0x0000010037367825ULL, 0x000fe200078e0030ULL,
0x0000003d4000720cULL, 0x000fc40003f86070ULL, 0x000000003a437faeULL, 0x0005e2000d901c48ULL,
0x0000000148457824ULL, 0x100fe200078e0208ULL, 0x000000360e367210ULL, 0x000fe20007fde0ffULL,
0x000000100d0d7824ULL, 0x000fe200078e023fULL, 0x0000003d3e00720cULL, 0x000fe20003f66070ULL,
0x00000001403d7824ULL, 0x000fe400078e0208ULL, 0x0000010045387825ULL, 0x002fc800078e0030ULL,
0x000000010f377824ULL, 0x000fe200030e0637ULL, 0x000000380e387210ULL, 0x000fe20007fde0ffULL,
0x000001003d3a7825ULL, 0x004fc800078e0030ULL, 0x000000013e417824ULL, 0x040fe400078e0208ULL,
0x000000013e3d7824ULL, 0x000fe400078e0205ULL, 0x000000010f397824ULL, 0x000fe200030e0639ULL,
0x0000003a0e3a7210ULL, 0x000fe20007fde0ffULL, 0x0000000140087824ULL, 0x040fe400078e0205ULL,
0x0000000840437824ULL, 0x000fe400078e00ffULL, 0x000000083e3e7824ULL, 0x000fc400078e00ffULL,
0x0000010041307825ULL, 0x000fe200078e0030ULL, 0xfffffff843087812ULL, 0x000fe400078ee208ULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee23dULL, 0x000000010f3b7824ULL, 0x040fe200030e063bULL,
0x000000300e0e7210ULL, 0x000fe20007fde0ffULL, 0x000000103c3d7824ULL, 0x100fe400078e023fULL,
0x000000100a417824ULL, 0x100fe400078e023fULL, 0x0000001004437824ULL, 0x100fe200078e023fULL,
0x00000000323d7faeULL, 0x0003e2000c101c48ULL, 0x0000001008457824ULL, 0x000fe200078e023fULL,
0x0000003f3e3f7211ULL, 0x000fe200078e20ffULL, 0x000000010f0f7824ULL, 0x000fe200030e0631ULL,
0x00000000340d7faeULL, 0x0003e8000c901c48ULL, 0x0000000036417faeULL, 0x0003e8000d101c48ULL,
0x0000000038437faeULL, 0x0003e8000e901c48ULL, 0x000000003a457faeULL, 0x0003e8000e101c48ULL,
0x000000000e3f7faeULL, 0x0003e2000d901c48ULL, 0x000005b000007947ULL, 0x000fea0003800000ULL,
0x00000010050a7824ULL, 0x040fe200078e00ffULL, 0x0000000c05377811ULL, 0x000fe200078fe8ffULL,
0x00002000070d7824ULL, 0x000fe200078e00ffULL, 0x0000000805357811ULL, 0x000fe200078fe8ffULL,
0x00000080073f7824ULL, 0x000fe200078e00ffULL, 0x000000700a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000137307824ULL, 0x000fe200078e0205ULL, 0x000020000d0d7812ULL, 0x000fe200078ec0ffULL,
0x00000008373b7824ULL, 0x000fe200078e00ffULL, 0x000000800a3e7812ULL, 0x000fe200078ef83fULL,
0x0000000835427824ULL, 0x000fe200078e00ffULL, 0x0000000405337811ULL, 0x000fe200078fe8ffULL,
0x00004000040a7824ULL, 0x000fe200078e020dULL, 0xfffffff83b447812ULL, 0x000fe200078ee230ULL,
0x00000001350d7824ULL, 0x100fe200078e0205ULL, 0x00000014053b7811ULL, 0x000fe200078fe8ffULL,
0x0000000133047824ULL, 0x000fe200078e0205ULL, 0x00000018053d7811ULL, 0x000fe200078fe8ffULL,
0x0000000833317824ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee20dULL,
0x000000013b0d7824ULL, 0x100fe200078e0205ULL, 0x0000001005397811ULL, 0x000fe200078fe8ffULL,
0x000000083b487824ULL, 0x000fe200078e00ffULL, 0xfffffff831407812ULL, 0x000fe200078ee204ULL,
0x000000013d307824ULL, 0x040fe200078e0205ULL, 0x0000c0000a4d7810ULL, 0x000fe20007ffe0ffULL,
0x000000083d3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff848487812ULL, 0x000fe200078ee20dULL,
0x0000000139047824ULL, 0x000fe200078e0205ULL, 0x0000001c050d7811ULL, 0x000fe200078fe8ffULL,
0x0000000839317824ULL, 0x000fe200078e00ffULL, 0xfffffff83f4a7812ULL, 0x000fe200078ee230ULL,
0x0000000133337824ULL, 0x000fc400078e0208ULL, 0x000000010d307824ULL, 0x000fe200078e0205ULL,
0xfffffff831467812ULL, 0x000fe200078ee204ULL, 0x000000080d3f7824ULL, 0x000fe200078e00ffULL,
0x0000000805317211ULL, 0x000fe200078fe8ffULL, 0x0000000135357824ULL, 0x100fe200078e0208ULL,
0x0000000505047211ULL, 0x000fe200078fe8ffULL, 0x0000000137377824ULL, 0x100fe200078e0208ULL,
0x0000004d46477211ULL, 0x000fe200078e20ffULL, 0x0000000139397824ULL, 0x100fe200078e0208ULL,
0x0000000704047812ULL, 0x000fe200078ec0ffULL, 0x000000013b3b7824ULL, 0x000fc400078e0208ULL,
0x000000013d3d7824ULL, 0x100fe200078e0208ULL, 0x0ffffff804047812ULL, 0x000fe200078ef805ULL,
0x000000010d0d7824ULL, 0x000fe200078e0208ULL, 0xfffffff83f087812ULL, 0x000fe200078ee230ULL,
0x000000ffff3f7224ULL, 0x000fe400078e00ffULL, 0x0000001040417824ULL, 0x000fe400078e024dULL,
0x0000010031307825ULL, 0x000fc800078e003eULL, 0x0000010033327825ULL, 0x000fe200078e003eULL,
0x000000300e307210ULL, 0x000fc60007f1e0ffULL, 0x0000010035347825ULL, 0x000fe200078e003eULL,
0x000000320e327210ULL, 0x000fc60007f3e0ffULL, 0x0000010037367825ULL, 0x000fe200078e003eULL,
0x000000340e347210ULL, 0x000fc60007f5e0ffULL, 0x0000010039387825ULL, 0x000fe200078e003eULL,
0x000000360e367210ULL, 0x000fc60007f7e0ffULL, 0x000001003b3a7825ULL, 0x000fc800078e003eULL,
0x000001003d3c7825ULL, 0x000fc800078e003eULL, 0x000001000d3e7825ULL, 0x000fc800078e003eULL,
0x000000010f317824ULL, 0x040fe200000e0631ULL, 0x000000380e387210ULL, 0x040fe20007f1e0ffULL,
0x000000010f337824ULL, 0x040fe200008e0633ULL, 0x0000003a0e3a7210ULL, 0x000fe20007f3e0ffULL,
0x00000010040d7824ULL, 0x000fe400078e024dULL, 0x000000010f357824ULL, 0x040fe200010e0635ULL,
0x0000003c0e3c7210ULL, 0x040fe20007f5e0ffULL, 0x000000010f377824ULL, 0x000fe200018e0637ULL,
0x0000003e0e0e7210ULL, 0x000fe20007f7e0ffULL, 0x0000001042437824ULL, 0x100fe200078e024dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000300d7faeULL, 0x0003e2000b901c48ULL,
0x0000001044457824ULL, 0x000fc400078e024dULL, 0x000000010f397824ULL, 0x040fe200000e0639ULL,
0x0000000032417faeULL, 0x0003e2000b901c48ULL, 0x0000001048497824ULL, 0x000fe400078e024dULL,
0x000000010f3b7824ULL, 0x040fe200008e063bULL, 0x0000000034437faeULL, 0x0003e2000b901c48ULL,
0x000000104a4b7824ULL, 0x000fe400078e024dULL, 0x000000010f3d7824ULL, 0x000fe200010e063dULL,
0x0000000036457faeULL, 0x0003e2000b901c48ULL, 0x00000010084d7824ULL, 0x000fc400078e024dULL,
0x000000010f0f7824ULL, 0x000fe200018e063fULL, 0x0000000038477faeULL, 0x0003e8000b901c48ULL,
0x000000003a497faeULL, 0x0003e8000b901c48ULL, 0x000000003c4b7faeULL, 0x0003e8000b901c48ULL,
0x000000000e4d7faeULL, 0x0003e4000b901c48ULL, 0x0000000309047812ULL, 0x000fe200078ec0ffULL,
0xffffffffff0a7424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000030400780cULL, 0x000fc80003f05270ULL, 0x0000000172047807ULL, 0x000fca0004000000ULL,
0x0000000104097824ULL, 0x000fca00078e0209ULL, 0x0000006c0900720cULL, 0x000fda0003f06070ULL,
0x00000001690e8824ULL, 0x002fe400078e0209ULL, 0x00000004ff0f8424ULL, 0x000fc800078e00ffULL,
0x000064000e0e8625ULL, 0x000fca00078e000fULL, 0x000000080e0a8981ULL, 0x000322000c1e1900ULL,
0xffffffe06e047812ULL, 0x040fe400078ec0ffULL, 0x000000106e0d7812ULL, 0x040fe400078ec0ffULL,
0x000000086e087812ULL, 0x000fc800078ec0ffULL, 0x0000000408047210ULL, 0x000fe20007ffe00dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136080004327f8cULL, 0x0022a4000c80043fULL,
0x00000000000e7805ULL, 0x000fc40000015200ULL, 0x01360c00040d7984ULL, 0x000ee40000000800ULL,
0x800000000dff7812ULL, 0x00cfe40007804833ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fcc0000015200ULL,
0x000000300e0d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000131307824ULL, 0x000fe200000e0e0fULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff3000720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff3000720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011430ULL, 0x0000000d08087211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e0630ULL, 0x0000000208087819ULL, 0x000fc8000000120dULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01360c00040d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe40007804833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010056a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff707819ULL, 0x000fe20000011605ULL, 0x00000020075c7824ULL, 0x000fe400078e00ffULL,
0xffffffffff757424ULL, 0x000fe200078e00ffULL, 0x000000706a6a7812ULL, 0x000fc400078ec0ffULL,
0xffffff805c5c7812ULL, 0x000fe400078ec0ffULL, 0x0000000c70707812ULL, 0x000fc800078ec0ffULL,
0x0000005c70047210ULL, 0x002fca0007ffe06aULL, 0x0130000004317984ULL, 0x000e680000000800ULL,
0x0132000004307984ULL, 0x0004e20000000800ULL, 0x0000000c3100720bULL, 0x002fe20003f1d000ULL,
0x000108f27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000d7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0d337812ULL, 0x000fe2000782c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff087224ULL, 0x000fe400078e000cULL,
0x0000001fff777424ULL, 0x000fc400078e00ffULL, 0xffffffffff767424ULL, 0x000fcc00078e00ffULL,
0x0000042000009947ULL, 0x000fea0003800000ULL, 0x000000076d00720cULL, 0x000fe40003f05270ULL,
0x0000000c3100720bULL, 0x000fe20003f34000ULL, 0x000108827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000047806ULL, 0x000fc400008e0100ULL, 0x00000080070d8824ULL, 0x000fe200078e026aULL,
0x0000000c31087209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x00009910040e7816ULL, 0x000fe200000000ffULL, 0x00000001700d8824ULL, 0x000fca00078e020dULL,
0x013400080d008388ULL, 0x0003e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000c080c7221ULL, 0x002fe20000010100ULL,
0x000000ff04ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fcc0000410000ULL, 0x0000000c000c7308ULL, 0x000e640000000800ULL,
0x0000000c0b0b7220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe20000011605ULL, 0x000107b27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0c0d7589ULL, 0x0002a400000e0000ULL, 0x0000000d2c2c7220ULL, 0x084fe20000410000ULL,
0x0000000d2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000d28287220ULL, 0x080fe20000410000ULL,
0x0000000d29297220ULL, 0x080fe20000410000ULL, 0x0000000d24247220ULL, 0x080fe20000410000ULL,
0x0000000d25257220ULL, 0x080fe20000410000ULL, 0x0000000d20207220ULL, 0x080fe20000410000ULL,
0x0000000d21217220ULL, 0x080fe20000410000ULL, 0x0000000d1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000d1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000d18187220ULL, 0x080fe20000410000ULL,
0x0000000d19197220ULL, 0x080fe20000410000ULL, 0x0000000d14147220ULL, 0x080fe20000410000ULL,
0x0000000d15157220ULL, 0x080fe20000410000ULL, 0x0000000d10107220ULL, 0x080fe20000410000ULL,
0x0000000d11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0004ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008050d7811ULL, 0x000fe200078ff0ffULL, 0x000106927f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0c0d7589ULL, 0x00046400000e0000ULL, 0x0000000d2e2e7220ULL, 0x086fe20000410000ULL,
0x0000000d2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000d2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000d2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000d26267220ULL, 0x080fe20000410000ULL,
0x0000000d27277220ULL, 0x080fe20000410000ULL, 0x0000000d22227220ULL, 0x080fe20000410000ULL,
0x0000000d23237220ULL, 0x080fe20000410000ULL, 0x0000000d1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000d1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000d1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000d1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000d16167220ULL, 0x080fe20000410000ULL,
0x0000000d17177220ULL, 0x080fe20000410000ULL, 0x0000000d12127220ULL, 0x080fe20000410000ULL,
0x0000000d13137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff33ff7812ULL, 0x000fda0007806004ULL, 0x8000000831310221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL, 0x0000003100030308ULL, 0x000e640000000800ULL,
0x0000000330300220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x0000000b300b7221ULL, 0x008fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000003ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff317819ULL, 0x000fe40000011605ULL,
0x0000541000047816ULL, 0x000fe20000000000ULL, 0x000104d27f007947ULL, 0x000fea000b800000ULL,
0x00001f3104027589ULL, 0x0002a400000e0000ULL, 0x00000008310d7810ULL, 0x000fe20007ffe0ffULL,
0x000105027f007947ULL, 0x000fea000b800000ULL, 0x00001f0d04007589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010310d7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0004ULL, 0x00003170000f7802ULL, 0x000fc40000000f00ULL,
0x00010ec000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018310d7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0004ULL,
0x000031c0000f7802ULL, 0x000fc40000000f00ULL, 0x00010e7000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000207577824ULL, 0x000fe200078e00ffULL,
0x00000007050d7812ULL, 0x00cfe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x0000000457047812ULL, 0x002fc400078ec0ffULL, 0x000000080d0c7812ULL, 0x000fe400078ef805ULL,
0x0000000405677211ULL, 0x000fe200078fe0ffULL, 0x0000020007047824ULL, 0x000fe400078e00ffULL,
0x000000080c307824ULL, 0x040fe400078e00ffULL, 0x000000010c677824ULL, 0x000fe200078e0267ULL,
0xfffff800040e7812ULL, 0x000fc800078ec0ffULL, 0xfffffff830557812ULL, 0x000fe400078ee267ULL,
0x0000000805307812ULL, 0x000fc600078ec0ffULL, 0x0000001055557824ULL, 0x000fc800078e020eULL,
0x00000004ff317819ULL, 0x000fe20000011605ULL, 0x009000005544783bULL, 0x000e620000000200ULL,
0x0000000d30047212ULL, 0x000fe200078efcffULL, 0x000059000a0a7a24ULL, 0x010fe200078e02ffULL,
0x00000001ff567819ULL, 0x000fe40000011607ULL, 0x0000001030307812ULL, 0x000fe200078efe0dULL,
0x00000001310f7824ULL, 0x000fe200078e0204ULL, 0xfffffff857577812ULL, 0x000fe200078ec0ffULL,
0x00000004560d7824ULL, 0x040fe200078e0231ULL, 0x0000003005647211ULL, 0x000fe200078fe0ffULL,
0x0000000256317824ULL, 0x000fe200078e026bULL, 0x000000060f607810ULL, 0x040fe20007ffe0ffULL,
0x0000000804337824ULL, 0x040fe200078e00ffULL, 0x000000020f5e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000804347824ULL, 0x040fe200078e00ffULL, 0x000000040f5d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000804327824ULL, 0x000fe200078e00ffULL, 0xfffffff833607812ULL, 0x000fe200078ee260ULL,
0x0000200031047824ULL, 0x000fe200078e00ffULL, 0xfffffff8335e7812ULL, 0x000fe200078ee25eULL,
0x0000000830357824ULL, 0x000fe200078e00ffULL, 0xfffffff8325f7812ULL, 0x000fe200078ee20fULL,
0x0000000830337824ULL, 0x000fe200078e00ffULL, 0x0000b00004317810ULL, 0x000fe20007ffe0ffULL,
0x0000000830377824ULL, 0x000fe200078e00ffULL, 0xfffffff8345d7812ULL, 0x000fc400078ee25dULL,
0x000000020d0d7810ULL, 0x000fe20007ffe00cULL, 0x0000001060487824ULL, 0x100fe200078e0231ULL,
0x0000000264637810ULL, 0x000fe20007ffe0ffULL, 0x000000105e507824ULL, 0x100fe200078e0231ULL,
0x0000000464627810ULL, 0x040fe20007ffe0ffULL, 0x000000105d4c7824ULL, 0x100fe200078e0231ULL,
0x0000000664667810ULL, 0x000fe20007ffe0ffULL, 0x000000105f407824ULL, 0x000fe200078e0231ULL,
0x000000004848783bULL, 0x000ea20000004200ULL, 0x000000080c0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff835627812ULL, 0x000fc400078ee262ULL, 0x000000005050783bULL, 0x000ee20000004200ULL,
0xfffffff833647812ULL, 0x000fe200078ee264ULL, 0x0000000244440232ULL, 0x082fe20000000000ULL,
0xfffffff80c0d7812ULL, 0x000fe200078ee20dULL, 0x000000004c4c783bULL, 0x000e620000004200ULL,
0x00000008300c7824ULL, 0x000fe200078e00ffULL, 0xfffffff837667812ULL, 0x000fe200078ee266ULL,
0x0000001062387824ULL, 0x000fe200078e0231ULL, 0x000000004040783bULL, 0x000fe20000004200ULL,
0x000000100d547824ULL, 0x000fe200078e00ffULL, 0xfffffff80c637812ULL, 0x000fe200078ee263ULL,
0x0000001064347824ULL, 0x100fe200078e0231ULL, 0x0000000246460232ULL, 0x000fe20000000000ULL,
0x000000003838783bULL, 0x000fe20000004200ULL, 0x000090000e0e7810ULL, 0x000fe20007ffe054ULL,
0x00000010633c7824ULL, 0x100fe200078e0231ULL, 0x0000000045450232ULL, 0x080fe20000000000ULL,
0x0000001066317824ULL, 0x000fe200078e0231ULL, 0x000000003434783bULL, 0x000fe20000004200ULL,
0x0000000047470232ULL, 0x000fc60000000000ULL, 0x000000000e0c783bULL, 0x000e680000000200ULL,
0x000000003130783bULL, 0x000e680000004200ULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0x000000484414723cULL, 0x044f700000001814ULL, 0x000000504424723cULL, 0x048f700000001824ULL,
0x000000524420723cULL, 0x040f700000001820ULL, 0x0000004c441c723cULL, 0x002f62000000181cULL,
0x000000020c0c0232ULL, 0x000fc40000000000ULL, 0x000000020e0e0232ULL, 0x000fe40000000000ULL,
0x000000000d0d0232ULL, 0x000fc60000000000ULL, 0x0000004e4418723cULL, 0x000f620000001818ULL,
0x000000000f0f0232ULL, 0x000fce0000000000ULL, 0x00000040442c723cULL, 0x040f70000000182cULL,
0x000000424428723cULL, 0x040f700000001828ULL, 0x0000004a4410723cULL, 0x000f700000001810ULL,
0x000000300c14723cULL, 0x060f700000001814ULL, 0x0000003c0c24723cULL, 0x040f700000001824ULL,
0x0000003e0c20723cULL, 0x040f700000001820ULL, 0x000000380c1c723cULL, 0x040f70000000181cULL,
0x0000003a0c18723cULL, 0x040f700000001818ULL, 0x000000340c2c723cULL, 0x040f70000000182cULL,
0x000000360c28723cULL, 0x040f700000001828ULL, 0x000000320c30723cULL, 0x000b6e0000001810ULL,
0x00000008060c7824ULL, 0x020fe200078e0256ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fcc0000008000ULL,
0x00000001060e7810ULL, 0x000fe20007ffe0ffULL, 0x000000400a0a7824ULL, 0x000fe200078e00ffULL,
0x000000800c107811ULL, 0x000fe200078e28ffULL, 0x0136880057ff7f8cULL, 0x0003e2000c80043fULL,
0x000000650e00720cULL, 0x000fc40003f06070ULL, 0x00000100000d7802ULL, 0x000fe40000000f00ULL,
0x00000020100f7812ULL, 0x000fc600078ec0ffULL, 0x000062000a0c7625ULL, 0x000fc800078e000dULL,
0x00000001680a7824ULL, 0x000fe200078e020fULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff3e7819ULL, 0x002fe20000011605ULL,
0x0000008007377824ULL, 0x000fe200078e00ffULL, 0x00000010610e7217ULL, 0x000fe20007800000ULL,
0x00002000070f7824ULL, 0x000fe200078e00ffULL, 0x000000043e127810ULL, 0x040fe40007ffe0ffULL,
0x000000083e347810ULL, 0x000fe20007ffe0ffULL, 0x000000010e0e7824ULL, 0x000fe200078e0a10ULL,
0x000000806a367812ULL, 0x000fe200078ef837ULL, 0x0000000112407824ULL, 0x100fe200078e0205ULL,
0x000000103e467810ULL, 0x000fe20007ffe0ffULL, 0x0000000812117824ULL, 0x000fe200078e00ffULL,
0x000020000f0f7812ULL, 0x000fe200078ec0ffULL, 0x00000001343b7824ULL, 0x000fe200078e0205ULL,
0x000000200e3f7817ULL, 0x000fe20003800000ULL, 0x0000000834107824ULL, 0x000fe200078e00ffULL,
0xfffffff811407812ULL, 0x000fe200078ee240ULL, 0x000000013e117824ULL, 0x040fe200078e020aULL,
0x0000000c3e447810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff377224ULL, 0x000fe200078e00ffULL,
0xfffffff8103b7812ULL, 0x000fe200078ee23bULL, 0x00000001463c7824ULL, 0x000fe200078e0205ULL,
0x0000003f1200720cULL, 0x080fe20003f86070ULL, 0x0000010011107825ULL, 0x000fe200078e0036ULL,
0x0000003f4400720cULL, 0x000fc40003f46070ULL, 0x000000143e427810ULL, 0x000fe20007ffe0ffULL,
0x0000000846137824ULL, 0x000fe200078e00ffULL, 0x000000100c387210ULL, 0x000fe20007f1e0ffULL,
0x0000400056417824ULL, 0x000fe200078e020fULL, 0x0000003f3e00720cULL, 0x0c0fe20003fa6070ULL,
0x000000013e107824ULL, 0x100fe200078e0205ULL, 0xfffffff8133c7812ULL, 0x000fe200078ee23cULL,
0x00000001120f7824ULL, 0x000fe200078e020aULL, 0x0000b00041417810ULL, 0x000fe20007ffe0ffULL,
0x00000001443d7824ULL, 0x000fe200078e0205ULL, 0x0000003f3400720cULL, 0x000fe20003f66070ULL,
0x0000000844127824ULL, 0x000fc400078e00ffULL, 0x0000000144137824ULL, 0x000fe200078e020aULL,
0x0000000710447812ULL, 0x000fe200078ec0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0036ULL,
0xfffffff8123d7812ULL, 0x000fe400078ee23dULL, 0x0ffffff844447812ULL, 0x000fe200078ef805ULL,
0x0000010013127825ULL, 0x000fe200078e0036ULL, 0x0000000e0c0e7210ULL, 0x000fc60007f3e0ffULL,
0x000000010d397824ULL, 0x000fe200000e0611ULL, 0x000000120c127210ULL, 0x000fe20007fde0ffULL,
0x0000000146117824ULL, 0x000fe400078e020aULL, 0x00000001423a7824ULL, 0x040fe400078e0205ULL,
0x0000000842357824ULL, 0x000fe400078e00ffULL, 0x0000010011107825ULL, 0x000fc600078e0036ULL,
0xfffffff8353a7812ULL, 0x000fe200078ee23aULL, 0x0000001044437824ULL, 0x000fe400078e0241ULL,
0x0000000142477824ULL, 0x100fe400078e020aULL, 0x0000000134357824ULL, 0x000fe200078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038437faeULL, 0x0003e2000e901c48ULL,
0x000000010d137824ULL, 0x040fe200030e0613ULL, 0x000000100c107210ULL, 0x000fe20007fde0ffULL,
0x000000010d0f7824ULL, 0x000fe200008e060fULL, 0x0000003f4600720cULL, 0x000fe20003f26070ULL,
0x0000001040457824ULL, 0x000fe200078e0241ULL, 0x000000183e407810ULL, 0x040fe20007ffe0ffULL,
0x0000010035347825ULL, 0x000fe200078e0036ULL, 0x0000001c3e3e7810ULL, 0x000fc40007ffe0ffULL,
0x000000000e457faeULL, 0x0005e2000e101c48ULL, 0x000000010d117824ULL, 0x000fe200030e0611ULL,
0x000000340c347210ULL, 0x000fe20007f1e0ffULL, 0x0000010047387825ULL, 0x002fe200078e0036ULL,
0x0000000a40477210ULL, 0x040fe40007ffe0ffULL, 0x0000003f4000720cULL, 0x080fe20003fa6070ULL,
0x000000010d357824ULL, 0x000fe200000e0635ULL, 0x0000003f4200720cULL, 0x080fe20003f06070ULL,
0x0000000840437824ULL, 0x000fe200078e00ffULL, 0x0000003f3e00720cULL, 0x040fe20003f86070ULL,
0x000000013e3f7824ULL, 0x000fe200078e020aULL, 0x000000380c0e7210ULL, 0x004fe20007fde0ffULL,
0x00000001400a7824ULL, 0x000fc400078e0205ULL, 0x000000013e407824ULL, 0x000fe400078e0205ULL,
0x000000010d0f7824ULL, 0x000fe200030e0639ULL, 0xfffffff8430a7812ULL, 0x000fe200078ee20aULL,
0x0000010047387825ULL, 0x000fc800078e0036ULL, 0x000000083e457824ULL, 0x000fe200078e00ffULL,
0x000000380c387210ULL, 0x000fe20007fde0ffULL, 0x000001003f367825ULL, 0x000fc600078e0036ULL,
0xfffffff845407812ULL, 0x000fe200078ee240ULL, 0x000000010d397824ULL, 0x000fe200030e0639ULL,
0x000000360c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000103b3b7824ULL, 0x100fe400078e0241ULL,
0x000000103d3d7824ULL, 0x100fe400078e0241ULL, 0x000000103c3f7824ULL, 0x100fe200078e0241ULL,
0x00000000343b7faeULL, 0x0003e2000d901c48ULL, 0x000000103a437824ULL, 0x100fe400078e0241ULL,
0x000000100a457824ULL, 0x100fe200078e0241ULL, 0x00000000123d7faeULL, 0x0003e2000d101c48ULL,
0x0000001040417824ULL, 0x000fc400078e0241ULL, 0x000000010d0d7824ULL, 0x000fe200030e0637ULL,
0x00000000103f7faeULL, 0x0003e8000c901c48ULL, 0x000000000e437faeULL, 0x0003e8000c101c48ULL,
0x0000000038457faeULL, 0x0003e8000e901c48ULL, 0x000000000c417faeULL, 0x0003e2000e101c48ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x00002000070e7824ULL, 0x002fe200078e00ffULL,
0x00000004053b7811ULL, 0x000fe200078fe8ffULL, 0x0000008007377824ULL, 0x000fe200078e00ffULL,
0x00000008053d7811ULL, 0x000fc400078fe8ffULL, 0x000020000e0f7812ULL, 0x000fe200078ec0ffULL,
0x000000013b427824ULL, 0x000fe200078e0205ULL, 0x0000001805357811ULL, 0x000fe200078fe8ffULL,
0x000000083b117824ULL, 0x000fe200078e00ffULL, 0x0000001c05457811ULL, 0x040fe200078fe8ffULL,
0x0000400056567824ULL, 0x000fe200078e020fULL, 0x0000000c050f7811ULL, 0x000fe200078fe8ffULL,
0x000000013d417824ULL, 0x100fe200078e0205ULL, 0xfffffff811427812ULL, 0x000fe200078ee242ULL,
0x000000083d0e7824ULL, 0x000fe200078e00ffULL, 0x0000001005117811ULL, 0x000fe200078fe8ffULL,
0x000000010f407824ULL, 0x040fe200078e0205ULL, 0x000000806a367812ULL, 0x000fe200078ef837ULL,
0x000000080f137824ULL, 0x000fe200078e00ffULL, 0xfffffff80e417812ULL, 0x000fe200078ee241ULL,
0x00000001113f7824ULL, 0x100fe200078e0205ULL, 0x0000000a0f0f7210ULL, 0x080fe20007ffe0ffULL,
0x00000008110e7824ULL, 0x000fe200078e00ffULL, 0xfffffff813407812ULL, 0x000fe200078ee240ULL,
0x00000001353e7824ULL, 0x000fe200078e0205ULL, 0x0000001405137811ULL, 0x000fe200078fe8ffULL,
0x0000000835397824ULL, 0x000fe200078e00ffULL, 0xfffffff80e3f7812ULL, 0x000fe200078ee23fULL,
0x0000000845377824ULL, 0x000fe200078e00ffULL, 0x00000005050e7211ULL, 0x000fe200078fe8ffULL,
0x0000000113437824ULL, 0x000fe200078e0205ULL, 0xfffffff8393e7812ULL, 0x000fe200078ee23eULL,
0x0000000813107824ULL, 0x000fe200078e00ffULL, 0x0000000a05397211ULL, 0x000fe200078fe8ffULL,
0x000000013b3b7824ULL, 0x100fe200078e020aULL, 0x000000070e0e7812ULL, 0x000fe200078ec0ffULL,
0x000000013d3d7824ULL, 0x100fe200078e020aULL, 0xfffffff810437812ULL, 0x000fe200078ee243ULL,
0x0000000145107824ULL, 0x000fe200078e0205ULL, 0x0000b000564d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111117824ULL, 0x000fc400078e020aULL, 0x0000000113137824ULL, 0x000fe200078e020aULL,
0xfffffff837447812ULL, 0x000fe200078ee210ULL, 0x000000ffff377224ULL, 0x000fe400078e00ffULL,
0x0000000135357824ULL, 0x000fe400078e020aULL, 0x0000010039387825ULL, 0x000fc800078e0036ULL,
0x0000000145457824ULL, 0x000fe200078e020aULL, 0x0ffffff80e0a7812ULL, 0x000fe200078ef805ULL,
0x000001003b3a7825ULL, 0x000fe200078e0036ULL, 0x000000380c387210ULL, 0x000fc60007f1e0ffULL,
0x000001003d3c7825ULL, 0x000fe200078e0036ULL, 0x0000003a0c3a7210ULL, 0x000fc60007f3e0ffULL,
0x000001000f0e7825ULL, 0x000fe200078e0036ULL, 0x0000003c0c3c7210ULL, 0x000fc60007f5e0ffULL,
0x0000010011107825ULL, 0x000fe200078e0036ULL, 0x0000000e0c0e7210ULL, 0x000fc60007f7e0ffULL,
0x0000010013127825ULL, 0x000fc800078e0036ULL, 0x0000010035347825ULL, 0x000fc800078e0036ULL,
0x0000010045367825ULL, 0x000fc800078e0036ULL, 0x000000010d397824ULL, 0x040fe200000e0639ULL,
0x000000100c107210ULL, 0x040fe20007f1e0ffULL, 0x000000010d3b7824ULL, 0x040fe200008e063bULL,
0x000000120c127210ULL, 0x000fe20007f3e0ffULL, 0x000000100a457824ULL, 0x000fe400078e024dULL,
0x000000010d3d7824ULL, 0x040fe200010e063dULL, 0x000000340c347210ULL, 0x000fe20007f5e0ffULL,
0x0000001042477824ULL, 0x000fe200078e024dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038457faeULL, 0x0003e2000b901c48ULL, 0x000000010d0f7824ULL, 0x000fe200018e060fULL,
0x000000360c0c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001041417824ULL, 0x100fe200078e024dULL,
0x000000003a477faeULL, 0x0003e2000b901c48ULL, 0x0000001040497824ULL, 0x000fc400078e024dULL,
0x000000103f3f7824ULL, 0x000fe200078e024dULL, 0x000000003c417faeULL, 0x0003e2000b901c48ULL,
0x000000010d117824ULL, 0x000fe400000e0611ULL, 0x0000001043437824ULL, 0x000fe200078e024dULL,
0x000000000e497faeULL, 0x0003e2000b901c48ULL, 0x000000010d137824ULL, 0x040fe400008e0613ULL,
0x000000103e4b7824ULL, 0x000fe200078e024dULL, 0x00000000103f7faeULL, 0x0003e2000b901c48ULL,
0x000000010d357824ULL, 0x000fc400010e0635ULL, 0x00000010444d7824ULL, 0x000fe200078e024dULL,
0x0000000012437faeULL, 0x0003e2000b901c48ULL, 0x000000010d0d7824ULL, 0x000fc600018e0637ULL,
0x00000000344b7faeULL, 0x0003e8000b901c48ULL, 0x000000000c4d7faeULL, 0x0003e4000b901c48ULL,
0x00000003090a7812ULL, 0x000fe200078ec0ffULL, 0xffffffffff4c7424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000030a00780cULL, 0x000fc80003f05270ULL,
0x00000001720a7807ULL, 0x000fca0004000000ULL, 0x0000000109097824ULL, 0x000fca00078e020aULL,
0x0000006c0900720cULL, 0x000fda0003f06070ULL, 0x00000001690c8824ULL, 0x002fe400078e0209ULL,
0x00000004ff0d8424ULL, 0x000fc800078e00ffULL, 0x000064000c0c8625ULL, 0x000fca00078e000dULL,
0x000000080c4c8981ULL, 0x000322000c1e1900ULL, 0xffffffe06e0a7812ULL, 0x040fe400078ec0ffULL,
0x000000106e0f7812ULL, 0x040fe400078ec0ffULL, 0x000000086e0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000a0e127210ULL, 0x000fe20007ffe00fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01362800120c7f8cULL, 0x0022a4000c80043fULL, 0x00000000000e7805ULL, 0x000fc40000015200ULL,
0x01362c0012117984ULL, 0x000ee40000000800ULL, 0x8000000011ff7812ULL, 0x00cfe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100e137210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0fULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc80000011411ULL,
0x000000130a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0611ULL,
0x000000020a0a7819ULL, 0x000fc80000001211ULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01362c0012117984ULL, 0x000ea40000000800ULL,
0x8000000011ff7812ULL, 0x004fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000806a0d7810ULL, 0x000fca0007ffe05cULL, 0x00000001700d7824ULL, 0x000fca00078e020dULL,
0x013000000d117984ULL, 0x000ea80000000800ULL, 0x013200000d0c7984ULL, 0x0006620000000800ULL,
0x000000081100720bULL, 0x004fe20003f1d000ULL, 0x0000ede27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0d137812ULL, 0x000fe2000782c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x00000008000a7202ULL, 0x000fd20000000f00ULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x000000016d0a7810ULL, 0x000fe40007ffe0ffULL, 0x000000081100720bULL, 0x000fe40003f34000ULL,
0x000000070a00720cULL, 0x000fe20003f05270ULL, 0x0000ed827f007947ULL, 0x000fd4000b800000ULL,
0x00000000000a7806ULL, 0x000fc400008e0100ULL, 0x00000080070f8824ULL, 0x000fe200078e026aULL,
0x00000008110d8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x000099100a0e7816ULL, 0x000fe200000000ffULL, 0x0000000170108824ULL, 0x000fca00078e020fULL,
0x0134000d10008388ULL, 0x0005e20000000800ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x00000008110d7209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0aff7812ULL, 0x000fc6000780c0ffULL,
0x000000080d0d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d00107308ULL, 0x000ea40000000800ULL, 0x000000100b0b7220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011605ULL,
0x0000eca27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d100d7589ULL, 0x0004e400000e0000ULL,
0x0000000d2c2c7220ULL, 0x08cfe20000410000ULL, 0x0000000d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000d28287220ULL, 0x080fe20000410000ULL, 0x0000000d29297220ULL, 0x080fe20000410000ULL,
0x0000000d24247220ULL, 0x080fe20000410000ULL, 0x0000000d25257220ULL, 0x080fe20000410000ULL,
0x0000000d20207220ULL, 0x080fe20000410000ULL, 0x0000000d21217220ULL, 0x080fe20000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000d1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000d18187220ULL, 0x080fe20000410000ULL, 0x0000000d19197220ULL, 0x080fe20000410000ULL,
0x0000000d14147220ULL, 0x080fe20000410000ULL, 0x0000000d15157220ULL, 0x080fe20000410000ULL,
0x0000000d30307220ULL, 0x080fe20000410000ULL, 0x0000000d31317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000aff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008050d7811ULL, 0x000fe200078ff0ffULL,
0x0000eb827f007947ULL, 0x000fea000b800000ULL, 0x00001f0d100d7589ULL, 0x0004e400000e0000ULL,
0x0000000d2e2e7220ULL, 0x08cfe20000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000d2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000d2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000d26267220ULL, 0x080fe20000410000ULL, 0x0000000d27277220ULL, 0x080fe20000410000ULL,
0x0000000d22227220ULL, 0x080fe20000410000ULL, 0x0000000d23237220ULL, 0x080fe20000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000d1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000d1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000d1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000d16167220ULL, 0x080fe20000410000ULL, 0x0000000d17177220ULL, 0x080fe20000410000ULL,
0x0000000d32327220ULL, 0x080fe20000410000ULL, 0x0000000d33337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff13ff7812ULL, 0x000fe4000780600aULL,
0x00000008110a7209ULL, 0x000fd60007810000ULL, 0x8000000a11110221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL, 0x0000001100030308ULL, 0x000ea40000000800ULL,
0x000000030c0c0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x0000000b0c0b7221ULL, 0x002fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000003ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff117819ULL, 0x000fe40000011605ULL,
0x0000541000087816ULL, 0x000fe20000000000ULL, 0x0000e9b27f007947ULL, 0x000fea000b800000ULL,
0x00001f1108027589ULL, 0x0002a400000e0000ULL, 0x00000008110d7810ULL, 0x000fe20007ffe0ffULL,
0x0000e9e27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d08007589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010110d7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0008ULL, 0x00004e50000f7802ULL, 0x000fc40000000f00ULL,
0x0000f1e000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018110d7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0008ULL,
0x00004ea0000f7802ULL, 0x000fc40000000f00ULL, 0x0000f19000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x0000c000040d7810ULL, 0x00cfe20007ffe0ffULL, 0x009800005540783bULL, 0x000ea20000000200ULL,
0x000008006d107824ULL, 0x000fe200078e0254ULL, 0x00000001ff047819ULL, 0x000fe20000011607ULL,
0x000059004c4c7a24ULL, 0x010fc400078e02ffULL, 0x000000105f587824ULL, 0x100fe400078e020dULL,
0x000000105e507824ULL, 0x100fe200078e020dULL, 0x009800001010783bULL, 0x002e620000000200ULL,
0x000000105d487824ULL, 0x100fe400078e020dULL, 0x0000001060447824ULL, 0x100fe200078e020dULL,
0x000000005858783bULL, 0x000ee20000004200ULL, 0x00000010643c7824ULL, 0x100fe400078e020dULL,
0x0000001063387824ULL, 0x100fe200078e020dULL, 0x000000005050783bULL, 0x000ee20000004200ULL,
0x0000001062347824ULL, 0x000fc400078e020dULL, 0x00000010660d7824ULL, 0x000fe200078e020dULL,
0x000000004848783bULL, 0x000ee80000004200ULL, 0x000000004444783bULL, 0x000ee80000004200ULL,
0x000000003c3c783bULL, 0x000ee80000004200ULL, 0x000000003838783bULL, 0x000ee80000004200ULL,
0x000000003434783bULL, 0x000ee80000004200ULL, 0x000000000d0c783bULL, 0x000ee20000004200ULL,
0x0000000240400232ULL, 0x004fc40000000000ULL, 0x0000000242420232ULL, 0x000fe40000000000ULL,
0x0000000041410232ULL, 0x080fe40000000000ULL, 0x0000000043430232ULL, 0x000fe40000000000ULL,
0x0000000210100232ULL, 0x082fe40000000000ULL, 0x0000000212120232ULL, 0x000fe40000000000ULL,
0x0000000011110232ULL, 0x080fe20000000000ULL, 0x00000058402c723cULL, 0x008f62000000182cULL,
0x0000000013130232ULL, 0x000fce0000000000ULL, 0x0000005a4028723cULL, 0x040f700000001828ULL,
0x000000504024723cULL, 0x040f700000001824ULL, 0x000000524020723cULL, 0x040f700000001820ULL,
0x00000048401c723cULL, 0x040f70000000181cULL, 0x0000004a4018723cULL, 0x040f700000001818ULL,
0x000000444014723cULL, 0x040f700000001814ULL, 0x000000464030723cULL, 0x000f700000001830ULL,
0x0000003c102c723cULL, 0x060f70000000182cULL, 0x0000003e1028723cULL, 0x040f700000001828ULL,
0x000000381024723cULL, 0x040f700000001824ULL, 0x0000003a1020723cULL, 0x040f700000001820ULL,
0x00000034101c723cULL, 0x040f70000000181cULL, 0x000000361018723cULL, 0x040f700000001818ULL,
0x0000000c1014723cULL, 0x040f700000001814ULL, 0x0000000e1010723cULL, 0x000b6e0000001830ULL,
0x000136906d0e7811ULL, 0x020fe200078e18ffULL, 0x0000000806307824ULL, 0x000fe200078e0204ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fcc0000008000ULL, 0x0000000106087810ULL, 0x000fe20007ffe0ffULL,
0x000000000eff7f8cULL, 0x0003e2000c80043fULL, 0x000000c030307811ULL, 0x000fe200078e28ffULL,
0x00000100ff0d7424ULL, 0x000fe200078e00ffULL, 0x000000650800720cULL, 0x000fe20003f06070ULL,
0x000000404c0c7824ULL, 0x000fe200078e00ffULL, 0x00000020300f7812ULL, 0x000fc600078ec0ffULL,
0x000062000c0c7625ULL, 0x000fc800078e000dULL, 0x0000000168087824ULL, 0x000fe200078e020fULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff3e7819ULL, 0x102fe20000011605ULL, 0x0000008007377824ULL, 0x000fe200078e00ffULL,
0x00000030610e7217ULL, 0x000fe40007800000ULL, 0x0000000c3e427810ULL, 0x040fe40007ffe0ffULL,
0x000000083e347810ULL, 0x000fe20007ffe0ffULL, 0x000000010e0e7824ULL, 0x000fe200078e0a30ULL,
0x0000000342317819ULL, 0x040fe200000006ffULL, 0x00000001423a7824ULL, 0x000fe200078e0205ULL,
0x000000806a367812ULL, 0x000fe200078ef837ULL, 0x00000001343b7824ULL, 0x000fe200078e0205ULL,
0x000000043e327810ULL, 0x000fe20007ffe0ffULL, 0x0000000834307824ULL, 0x000fe200078e00ffULL,
0xfffffff8313a7812ULL, 0x000fe200078ee23aULL, 0x000000013e317824ULL, 0x040fe200078e0208ULL,
0x000000143e467810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff377224ULL, 0x000fe200078e00ffULL,
0xfffffff8303b7812ULL, 0x000fe200078ee23bULL, 0x0000000132407824ULL, 0x000fe200078e0205ULL,
0x000000200e3f7817ULL, 0x000fe20003800000ULL, 0x0000010031307825ULL, 0x000fe200078e0036ULL,
0x000000103e447810ULL, 0x000fc40007ffe0ffULL, 0x0000003f3200720cULL, 0x0c0fe20003f86070ULL,
0x00000008320f7824ULL, 0x000fe200078e00ffULL, 0x000000300c387210ULL, 0x000fe20007f1e0ffULL,
0x00000001463c7824ULL, 0x000fe200078e0205ULL, 0x0000003f4200720cULL, 0x080fe20003f46070ULL,
0x0000000846337824ULL, 0x000fe200078e00ffULL, 0xfffffff80f407812ULL, 0x000fe200078ee240ULL,
0x000000010d397824ULL, 0x000fe200000e0631ULL, 0x0000003f3e00720cULL, 0x0c0fe20003fa6070ULL,
0x0000200007317824ULL, 0x000fe200078e00ffULL, 0xfffffff8333c7812ULL, 0x000fe200078ee23cULL,
0x000000013e307824ULL, 0x100fe200078e0205ULL, 0x0000003f3400720cULL, 0x000fe20003f66070ULL,
0x00000001320f7824ULL, 0x000fe200078e0208ULL, 0x0000200031417812ULL, 0x000fe200078ec0ffULL,
0x00000001443d7824ULL, 0x000fc400078e0205ULL, 0x0000000844327824ULL, 0x000fe400078e00ffULL,
0x0000000142337824ULL, 0x000fe200078e0208ULL, 0x0000000730427812ULL, 0x000fe200078ec0ffULL,
0x0000400004417824ULL, 0x000fe200078e0241ULL, 0xfffffff8323d7812ULL, 0x000fe200078ee23dULL,
0x0000010033327825ULL, 0x000fe200078e0036ULL, 0x0ffffff842427812ULL, 0x000fe400078ef805ULL,
0x0000c00041417810ULL, 0x000fe20007ffe0ffULL, 0x000001000f0e7825ULL, 0x000fe200078e0036ULL,
0x000000320c327210ULL, 0x000fc60007fde0ffULL, 0x0000000144317824ULL, 0x000fe200078e0208ULL,
0x0000000e0c0e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001042457824ULL, 0x000fe400078e0241ULL,
0x0000010031307825ULL, 0x000fc600078e0036ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038457faeULL, 0x0003e2000e901c48ULL, 0x0000000146437824ULL, 0x100fe400078e0208ULL,
0x0000000134357824ULL, 0x000fe400078e0208ULL, 0x000000010d337824ULL, 0x040fe200030e0633ULL,
0x000000300c307210ULL, 0x000fe20007fde0ffULL, 0x000000010d0f7824ULL, 0x000fe200008e060fULL,
0x0000003f4400720cULL, 0x000fe20003f26070ULL, 0x0000001040477824ULL, 0x000fe200078e0241ULL,
0x000000183e407810ULL, 0x040fe20007ffe0ffULL, 0x0000010035347825ULL, 0x000fe200078e0036ULL,
0x0000001c3e3e7810ULL, 0x000fc40007ffe0ffULL, 0x000000000e477faeULL, 0x0005e2000e101c48ULL,
0x0000010043387825ULL, 0x002fe200078e0036ULL, 0x000000340c347210ULL, 0x000fe40007f1e0ffULL,
0x0000003f4000720cULL, 0x080fe20003fa6070ULL, 0x000000010d317824ULL, 0x040fe200030e0631ULL,
0x0000003f3e00720cULL, 0x080fe20003f86070ULL, 0x0000000140437824ULL, 0x100fe400078e0208ULL,
0x000000010d357824ULL, 0x000fe200000e0635ULL, 0x0000003f4600720cULL, 0x000fe20003f06070ULL,
0x000000013e3f7824ULL, 0x000fe200078e0208ULL, 0x000000380c0e7210ULL, 0x004fe20007fde0ffULL,
0x0000000140087824ULL, 0x000fc400078e0205ULL, 0x000000083e457824ULL, 0x000fe400078e00ffULL,
0x000000010d0f7824ULL, 0x000fe400030e0639ULL, 0x0000010043387825ULL, 0x000fc800078e0036ULL,
0x0000000840437824ULL, 0x000fe200078e00ffULL, 0x000000380c387210ULL, 0x000fe20007fde0ffULL,
0x000000013e407824ULL, 0x000fe400078e0205ULL, 0x000001003f367825ULL, 0x000fe200078e0036ULL,
0xfffffff843087812ULL, 0x000fe400078ee208ULL, 0xfffffff845407812ULL, 0x000fe200078ee240ULL,
0x000000010d397824ULL, 0x000fe200030e0639ULL, 0x000000360c0c7210ULL, 0x000fe20007fde0ffULL,
0x000000103b3b7824ULL, 0x100fe200078e0241ULL, 0x000000413a3f7211ULL, 0x000fe200078e20ffULL,
0x000000103d3d7824ULL, 0x000fc400078e0241ULL, 0x000000103c437824ULL, 0x100fe200078e0241ULL,
0x00000000343b7faeULL, 0x0003e2000d901c48ULL, 0x0000001008457824ULL, 0x100fe400078e0241ULL,
0x0000001040417824ULL, 0x000fe200078e0241ULL, 0x00000000323f7faeULL, 0x0003e2000d101c48ULL,
0x000000010d0d7824ULL, 0x000fc600030e0637ULL, 0x00000000303d7faeULL, 0x0003e8000c901c48ULL,
0x000000000e437faeULL, 0x0003e8000c101c48ULL, 0x0000000038457faeULL, 0x0003e8000e901c48ULL,
0x000000000c417faeULL, 0x0003e2000e101c48ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x00000008053d7811ULL, 0x042fe400078fe8ffULL, 0x0000001005317811ULL, 0x000fc400078fe8ffULL,
0x0000001805357811ULL, 0x000fe200078fe8ffULL, 0x000000013d407824ULL, 0x100fe200078e0205ULL,
0x00000004053b7811ULL, 0x000fe200078fe8ffULL, 0x000000083d0f7824ULL, 0x000fe200078e00ffULL,
0x0000000c05307811ULL, 0x000fe200078fe8ffULL, 0x0000000131427824ULL, 0x100fe200078e0205ULL,
0x0000001c05457811ULL, 0x000fe200078fe8ffULL, 0x00000001353e7824ULL, 0x100fe200078e0205ULL,
0xfffffff80f407812ULL, 0x000fe200078ee240ULL, 0x00000008310f7824ULL, 0x000fe200078e00ffULL,
0x0000001405337811ULL, 0x000fe200078fe8ffULL, 0x0000000835377824ULL, 0x000fe200078e00ffULL,
0x0000000805397211ULL, 0x000fe200078fe8ffULL, 0x000000013b3f7824ULL, 0x000fe200078e0205ULL,
0xfffffff80f427812ULL, 0x000fe200078ee242ULL, 0x000000083b0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff8373e7812ULL, 0x000fe200078ee23eULL, 0x00002000070f7824ULL, 0x000fc400078e00ffULL,
0x0000008007377824ULL, 0x000fe200078e00ffULL, 0xfffffff80e3f7812ULL, 0x000fe200078ee23fULL,
0x0000000130417824ULL, 0x040fe200078e0205ULL, 0x000020000f477812ULL, 0x000fe200078ec0ffULL,
0x00000008300e7824ULL, 0x000fe200078e00ffULL, 0x000000806a367812ULL, 0x000fe200078ef837ULL,
0x00000001300f7824ULL, 0x100fe400078e0208ULL, 0x0000000145307824ULL, 0x040fe200078e0205ULL,
0xfffffff80e417812ULL, 0x000fe200078ee241ULL, 0x0000000845377824ULL, 0x000fe200078e00ffULL,
0x00000005050e7211ULL, 0x000fe200078fe8ffULL, 0x000000013b3b7824ULL, 0x000fc400078e0208ULL,
0x000000013d3d7824ULL, 0x000fe200078e0208ULL, 0xfffffff837447812ULL, 0x000fe200078ee230ULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x000000070e0e7812ULL, 0x000fe200078ec0ffULL,
0x0000000133437824ULL, 0x040fe400078e0205ULL, 0x0000000833327824ULL, 0x000fe400078e00ffULL,
0x0000010039387825ULL, 0x000fc600078e0036ULL, 0xfffffff832437812ULL, 0x000fe200078ee243ULL,
0x0000000131317824ULL, 0x100fe200078e0208ULL, 0x000000380c387210ULL, 0x000fe20007f1e0ffULL,
0x0000000133337824ULL, 0x100fe400078e0208ULL, 0x0000000135357824ULL, 0x100fe400078e0208ULL,
0x0000000145457824ULL, 0x000fe200078e0208ULL, 0x0ffffff80e087812ULL, 0x000fe200078ef805ULL,
0x000001003b3a7825ULL, 0x000fc800078e0036ULL, 0x0000400004477824ULL, 0x000fe200078e0247ULL,
0x0000003a0c3a7210ULL, 0x000fe20007f3e0ffULL, 0x000001003d3c7825ULL, 0x000fc600078e0036ULL,
0x0000c00047477810ULL, 0x000fe20007ffe0ffULL, 0x000001000f0e7825ULL, 0x100fe200078e0036ULL,
0x0000003c0c3c7210ULL, 0x040fe40007f5e0ffULL, 0x000000473f3f7211ULL, 0x000fe200078e20ffULL,
0x0000010031307825ULL, 0x000fe200078e0036ULL, 0x0000000e0c0e7210ULL, 0x000fc60007f7e0ffULL,
0x0000010033327825ULL, 0x000fc800078e0036ULL, 0x0000010035347825ULL, 0x000fc800078e0036ULL,
0x0000010045367825ULL, 0x000fc800078e0036ULL, 0x000000010d397824ULL, 0x040fe200000e0639ULL,
0x000000300c307210ULL, 0x040fe20007f1e0ffULL, 0x000000010d3b7824ULL, 0x040fe200008e063bULL,
0x000000320c327210ULL, 0x000fe20007f3e0ffULL, 0x0000001008457824ULL, 0x000fe400078e0247ULL,
0x000000010d3d7824ULL, 0x040fe200010e063dULL, 0x000000340c347210ULL, 0x040fe20007f5e0ffULL,
0x000000010d0f7824ULL, 0x000fe200018e060fULL, 0x000000360c0c7210ULL, 0x000fe20007f7e0ffULL,
0x0000001040497824ULL, 0x100fe200078e0247ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038457faeULL, 0x0003e2000b901c48ULL, 0x0000001041417824ULL, 0x000fc400078e0247ULL,
0x00000010424b7824ULL, 0x000fe200078e0247ULL, 0x000000003a3f7faeULL, 0x0003e2000b901c48ULL,
0x000000010d317824ULL, 0x000fe400000e0631ULL, 0x0000001043437824ULL, 0x000fe200078e0247ULL,
0x000000003c497faeULL, 0x0003e2000b901c48ULL, 0x000000010d337824ULL, 0x040fe400008e0633ULL,
0x000000103e4d7824ULL, 0x000fe200078e0247ULL, 0x000000000e417faeULL, 0x0003e2000b901c48ULL,
0x000000010d357824ULL, 0x000fc400010e0635ULL, 0x0000001044477824ULL, 0x000fe200078e0247ULL,
0x00000000304b7faeULL, 0x0003e2000b901c48ULL, 0x000000010d0d7824ULL, 0x000fc600018e0637ULL,
0x0000000032437faeULL, 0x0003e8000b901c48ULL, 0x00000000344d7faeULL, 0x0003e8000b901c48ULL,
0x000000000c477faeULL, 0x0003e4000b901c48ULL, 0x0000000309087812ULL, 0x000fe200078ec0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000030800780cULL, 0x000fc80003f05270ULL,
0x0000000172087807ULL, 0x000fca0004000000ULL, 0x0000000109097824ULL, 0x000fe400078e0208ULL,
0xffffffffff087424ULL, 0x000fc600078e00ffULL, 0x0000006c0900720cULL, 0x000fda0003f06070ULL,
0x00000001690c8824ULL, 0x002fe400078e0209ULL, 0x00000004ff0d8424ULL, 0x000fc800078e00ffULL,
0x000064000c0c8625ULL, 0x000fca00078e000dULL, 0x000000080c088981ULL, 0x000322000c1e1900ULL,
0x000000106e0e7812ULL, 0x040fe400078ec0ffULL, 0x000000086e0f7812ULL, 0x000fc600078ec0ffULL,
0x000000206d0e7824ULL, 0x000fc800078e020eULL, 0x000000010f327824ULL, 0x000fe200078e020eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01364800320c7f8cULL, 0x0022a4000c80043fULL,
0x00000000000e7805ULL, 0x000fc40000015200ULL, 0x01364c0032317984ULL, 0x000ee40000000800ULL,
0x8000000031ff7812ULL, 0x00cfe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fcc0000015200ULL,
0x000000300e337210ULL, 0x000fca0007f1e1ffULL, 0x0000000131317824ULL, 0x000fe200000e0e0fULL,
0x003d09003300780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403300780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff307819ULL, 0x000fc80000011431ULL, 0x0000003330307211ULL, 0x000fca00078110ffULL,
0x000000ffff317224ULL, 0x000fca00000e0631ULL, 0x0000000230307819ULL, 0x000fc80000001231ULL,
0x000000300000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01364c0032317984ULL, 0x000ea40000000800ULL, 0x8000000031ff7812ULL, 0x004fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001006a0d7810ULL, 0x000fca0007ffe05cULL,
0x00000001700d7824ULL, 0x000fca00078e020dULL, 0x013000000d317984ULL, 0x000ea80000000800ULL,
0x013200000d307984ULL, 0x0006620000000800ULL, 0x0000000a3100720bULL, 0x004fe20003f1d000ULL,
0x0000d5927f007947ULL, 0x000fd8000b800000ULL, 0x00000000000d7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0d337812ULL, 0x000fe2000782c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff0c7224ULL, 0x000fd400078e000aULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x000000026d0c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000a3100720bULL, 0x000fe40003f34000ULL, 0x000000070c00720cULL, 0x000fe20003f05270ULL,
0x0000d5327f007947ULL, 0x000fd4000b800000ULL, 0x00000000000c7806ULL, 0x000fc400008e0100ULL,
0x00000080070f8824ULL, 0x000fe200078e026aULL, 0x0000000a310d8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x000099100c0e7816ULL, 0x000fe200000000ffULL,
0x0000000170328824ULL, 0x002fca00078e020fULL, 0x0134000d32008388ULL, 0x0003e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000a310d7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0cff7812ULL, 0x000fc6000780c0ffULL, 0x0000000a0d0d7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL, 0x0000000d00327308ULL, 0x000e640000000800ULL,
0x000000320b0b7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe20000011605ULL, 0x0000d4527f007947ULL, 0x000fea000b800000ULL,
0x00001f0d320d7589ULL, 0x0002a400000e0000ULL, 0x0000000d2c2c7220ULL, 0x084fe20000410000ULL,
0x0000000d2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000d28287220ULL, 0x080fe20000410000ULL,
0x0000000d29297220ULL, 0x080fe20000410000ULL, 0x0000000d24247220ULL, 0x080fe20000410000ULL,
0x0000000d25257220ULL, 0x080fe20000410000ULL, 0x0000000d20207220ULL, 0x080fe20000410000ULL,
0x0000000d21217220ULL, 0x080fe20000410000ULL, 0x0000000d1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000d1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000d18187220ULL, 0x080fe20000410000ULL,
0x0000000d19197220ULL, 0x080fe20000410000ULL, 0x0000000d14147220ULL, 0x080fe20000410000ULL,
0x0000000d15157220ULL, 0x080fe20000410000ULL, 0x0000000d10107220ULL, 0x080fe20000410000ULL,
0x0000000d11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008050d7811ULL, 0x000fe200078ff0ffULL, 0x0000d3327f007947ULL, 0x000fea000b800000ULL,
0x00001f0d320d7589ULL, 0x0004e400000e0000ULL, 0x0000000d2e2e7220ULL, 0x08cfe20000410000ULL,
0x0000000d2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000d2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000d2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000d26267220ULL, 0x080fe20000410000ULL,
0x0000000d27277220ULL, 0x080fe20000410000ULL, 0x0000000d22227220ULL, 0x080fe20000410000ULL,
0x0000000d23237220ULL, 0x080fe20000410000ULL, 0x0000000d1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000d1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000d1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000d1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000d16167220ULL, 0x080fe20000410000ULL,
0x0000000d17177220ULL, 0x080fe20000410000ULL, 0x0000000d12127220ULL, 0x080fe20000410000ULL,
0x0000000d13137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff33ff7812ULL, 0x000fe4000780600cULL, 0x0000000a310c7209ULL, 0x000fd60007810000ULL,
0x8000000c31310221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL,
0x0000003100030308ULL, 0x000e640000000800ULL, 0x0000000330300220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x0000000b300b7221ULL, 0x002fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff317819ULL, 0x000fe40000011605ULL, 0x00005410000a7816ULL, 0x000fe20000000000ULL,
0x0000d1627f007947ULL, 0x000fea000b800000ULL, 0x00001f310a027589ULL, 0x0002a400000e0000ULL,
0x00000008310d7810ULL, 0x000fe20007ffe0ffULL, 0x0000d1927f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0a007589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010310d7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000aULL,
0x00006860000f7802ULL, 0x000fc40000000f00ULL, 0x0000d7d000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018310d7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e000aULL, 0x000068b0000f7802ULL, 0x000fc40000000f00ULL,
0x0000d78000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x00000002040a7824ULL, 0x00afe200078e026bULL,
0x00000007050e7812ULL, 0x000fe200078ec0ffULL, 0x00a000005548783bULL, 0x000e620000000200ULL,
0x00000002670d7810ULL, 0x004fe20007ffe0ffULL, 0x000020000a0a7824ULL, 0x000fe200078e00ffULL,
0x000000080e0e7812ULL, 0x000fc800078ef805ULL, 0x0000b0000a0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000080e0e7824ULL, 0x000fc800078e00ffULL, 0x000000105f307824ULL, 0x000fe200078e020fULL,
0xfffffff80e0d7812ULL, 0x000fe200078ee20dULL, 0x000000105e547824ULL, 0x100fe400078e020fULL,
0x000000105d507824ULL, 0x100fe400078e020fULL, 0x00000010604c7824ULL, 0x100fe200078e020fULL,
0x000000003030783bULL, 0x000ea20000004200ULL, 0x000000100d587824ULL, 0x000fe200078e00ffULL,
0x000136986d0d7811ULL, 0x040fe200078e18ffULL, 0x0000001064447824ULL, 0x000fe200078e020fULL,
0x000000005454783bULL, 0x000ee20000004200ULL, 0x000008006d347824ULL, 0x000fc400078e0258ULL,
0x0000001063407824ULL, 0x100fe200078e020fULL, 0x000000005050783bULL, 0x000fe20000004200ULL,
0x00000010623c7824ULL, 0x100fe400078e020fULL, 0x0000001066387824ULL, 0x000fe200078e020fULL,
0x000000004c4c783bULL, 0x000fe80000004200ULL, 0x00a000003434783bULL, 0x000ee80000000200ULL,
0x000000004444783bULL, 0x000ee20000004200ULL, 0x0000000248480232ULL, 0x002fc40000000000ULL,
0x000000024a4a0232ULL, 0x000fe20000000000ULL, 0x000000004040783bULL, 0x000e620000004200ULL,
0x0000000049490232ULL, 0x080fe40000000000ULL, 0x000000004b4b0232ULL, 0x000fe20000000000ULL,
0x000000003c3c783bULL, 0x000e680000004200ULL, 0x000000003838783bULL, 0x000e640000004200ULL,
0x00000030482c723cULL, 0x044f70000000182cULL, 0x000000324828723cULL, 0x040f700000001828ULL,
0x000000544824723cULL, 0x008f620000001824ULL, 0x0000000234340232ULL, 0x000fc40000000000ULL,
0x0000000236360232ULL, 0x000fe40000000000ULL, 0x0000000035350232ULL, 0x080fe40000000000ULL,
0x0000000037370232ULL, 0x000fe20000000000ULL, 0x000000564820723cULL, 0x040f700000001820ULL,
0x00000050481c723cULL, 0x040f70000000181cULL, 0x000000524818723cULL, 0x040f700000001818ULL,
0x0000004c4814723cULL, 0x040f700000001814ULL, 0x0000004e4810723cULL, 0x000f700000001810ULL,
0x00000044342c723cULL, 0x060b70000000182cULL, 0x000000463428723cULL, 0x040b700000001828ULL,
0x000000403424723cULL, 0x042b700000001824ULL, 0x000000423420723cULL, 0x040b700000001820ULL,
0x0000003c341c723cULL, 0x040b70000000181cULL, 0x0000003e3418723cULL, 0x040b700000001818ULL,
0x000000383414723cULL, 0x040b700000001814ULL, 0x0000003a3410723cULL, 0x000b620000001810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000030006307a10ULL, 0x000fe20007ffe0ffULL,
0x000000000dff7f8cULL, 0x0003e6000c80043fULL, 0x000000653000720cULL, 0x000fe20003f06070ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x00000d4000000947ULL, 0x000fea0003800000ULL,
0x00000001300e7810ULL, 0x042fe20007ffe0ffULL, 0x0000010030307824ULL, 0x000fe400078e026fULL,
0x0000590008087a24ULL, 0x010fe200078e02ffULL, 0x000000650e00720cULL, 0x000fe20003f06070ULL,
0x00000100ff0f7424ULL, 0x000fe200078e00ffULL, 0x00000020300d7812ULL, 0x000fe200078ec0ffULL,
0x00000040080e7824ULL, 0x000fc800078e00ffULL, 0x0000000168087824ULL, 0x000fe400078e020dULL,
0x000062000e0e7625ULL, 0x000fc800078e000fULL, 0x0000066000008947ULL, 0x000fea0003800000ULL,
0x00000003ff407819ULL, 0x120fe20000011605ULL, 0x0000008007397824ULL, 0x000fe200078e00ffULL,
0x00000030610d7217ULL, 0x000fe40007800000ULL, 0x0000000c40367810ULL, 0x040fe20007ffe0ffULL,
0x0000000140337824ULL, 0x040fe200078e0208ULL, 0x0000000840347810ULL, 0x040fe20007ffe0ffULL,
0x000000010d3f7824ULL, 0x000fe200078e0a30ULL, 0x0000000440327810ULL, 0x000fe20007ffe0ffULL,
0x00000001360d7824ULL, 0x100fe200078e0205ULL, 0x0000001040467810ULL, 0x000fe20007ffe0ffULL,
0x0000000836387824ULL, 0x000fe200078e00ffULL, 0x000000203f3f7817ULL, 0x000fe20003800000ULL,
0x00000001343c7824ULL, 0x000fe200078e0205ULL, 0x0000001440447810ULL, 0x000fe20007ffe0ffULL,
0x0000000834317824ULL, 0x000fe200078e00ffULL, 0xfffffff8380d7812ULL, 0x000fe200078ee20dULL,
0x0000000132417824ULL, 0x000fe200078e0205ULL, 0x000000806a387812ULL, 0x000fe200078ef839ULL,
0x000000ffff397224ULL, 0x000fe200078e00ffULL, 0xfffffff8313c7812ULL, 0x000fe200078ee23cULL,
0x0000000832307824ULL, 0x040fe200078e00ffULL, 0x0000003f3200720cULL, 0x080fe20003f86070ULL,
0x00000001463e7824ULL, 0x000fe200078e0205ULL, 0x0000000832317210ULL, 0x000fe20007ffe0ffULL,
0x0000010033327825ULL, 0x000fe200078e0038ULL, 0x0000003f4000720cULL, 0x000fc40003fa6070ULL,
0x0000003f3400720cULL, 0x080fe20003f66070ULL, 0x0000000846357824ULL, 0x000fe200078e00ffULL,
0x000000320e3a7210ULL, 0x000fe20007f1e0ffULL, 0x00000001443d7824ULL, 0x000fe200078e0205ULL,
0xfffffff830417812ULL, 0x000fe200078ee241ULL, 0x0000000844427824ULL, 0x000fe200078e00ffULL,
0xfffffff8353e7812ULL, 0x000fe200078ee23eULL, 0x000000010f3b7824ULL, 0x000fe200000e0633ULL,
0x0000003f3600720cULL, 0x000fe20003f46070ULL, 0x0000200007337824ULL, 0x000fe200078e00ffULL,
0xfffffff8423d7812ULL, 0x000fe200078ee23dULL, 0x0000000140327824ULL, 0x000fc400078e0205ULL,
0x0000000136357824ULL, 0x100fe200078e0208ULL, 0x0000200033437812ULL, 0x000fe200078ec0ffULL,
0x0000000134377824ULL, 0x000fe200078e0208ULL, 0x0000000732427812ULL, 0x000fe200078ec0ffULL,
0x0000010035347825ULL, 0x000fc800078e0038ULL, 0x0000400004457824ULL, 0x000fe200078e0243ULL,
0x0ffffff842437812ULL, 0x000fe200078ef805ULL, 0x0000010031307825ULL, 0x100fe200078e0038ULL,
0x000000340e347210ULL, 0x040fe40007fde0ffULL, 0x0000b00045427810ULL, 0x000fe20007ffe0ffULL,
0x0000010037367825ULL, 0x000fe200078e0038ULL, 0x000000300e307210ULL, 0x000fc60007f3e0ffULL,
0x0000000146337824ULL, 0x000fe200078e0208ULL, 0x000000360e367210ULL, 0x000fe20007f1e0ffULL,
0x0000001043457824ULL, 0x000fe400078e0242ULL, 0x0000010033327825ULL, 0x000fc600078e0038ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003a457faeULL, 0x0003e2000e901c48ULL,
0x0000000144437824ULL, 0x000fe400078e0208ULL, 0x000000010f357824ULL, 0x040fe200030e0635ULL,
0x000000320e327210ULL, 0x000fe20007fde0ffULL, 0x000000010f317824ULL, 0x000fe200008e0631ULL,
0x0000003f4600720cULL, 0x080fe20003f26070ULL, 0x0000001041477824ULL, 0x000fe400078e0242ULL,
0x000000010f377824ULL, 0x040fe200000e0637ULL, 0x0000003f4400720cULL, 0x000fe20003f06070ULL,
0x000000010f337824ULL, 0x000fe200030e0633ULL, 0x0000001840447810ULL, 0x040fe20007ffe0ffULL,
0x00000100433a7825ULL, 0x002fe200078e0038ULL, 0x0000000030477faeULL, 0x0003e2000e101c48ULL,
0x0000001c40407810ULL, 0x000fc40007ffe0ffULL, 0x0000000144417824ULL, 0x140fe200078e0208ULL,
0x0000003f4400720cULL, 0x0c0fe20003fa6070ULL, 0x0000000844437824ULL, 0x000fe200078e00ffULL,
0x0000003f4000720cULL, 0x040fe20003f86070ULL, 0x00000001403f7824ULL, 0x000fe400078e0208ULL,
0x0000000144087824ULL, 0x000fe400078e0205ULL, 0x000000100d0d7824ULL, 0x100fe200078e0242ULL,
0x0000003a0e307210ULL, 0x002fe20007fde0ffULL, 0x000000103d3d7824ULL, 0x000fe200078e0242ULL,
0xfffffff843437812ULL, 0x000fc600078ee208ULL, 0x000000010f317824ULL, 0x000fe200030e063bULL,
0x0000004243437211ULL, 0x000fe200078e20ffULL, 0x00000100413a7825ULL, 0x000fc800078e0038ULL,
0x0000000140417824ULL, 0x000fe200078e0205ULL, 0x0000003a0e3a7210ULL, 0x000fe20007fde0ffULL,
0x0000000840407824ULL, 0x000fe400078e00ffULL, 0x000001003f387825ULL, 0x000fc600078e0038ULL,
0xfffffff840457812ULL, 0x000fe200078ee241ULL, 0x000000010f3b7824ULL, 0x000fe200030e063bULL,
0x000000380e0e7210ULL, 0x000fe20007fde0ffULL, 0x000000103c3f7824ULL, 0x100fe400078e0242ULL,
0x000000103e417824ULL, 0x100fe400078e0242ULL, 0x0000001045457824ULL, 0x000fe200078e0242ULL,
0x00000000363f7faeULL, 0x0003e2000d901c48ULL, 0x000000010f0f7824ULL, 0x000fc600030e0639ULL,
0x00000000340d7faeULL, 0x0003e8000d101c48ULL, 0x0000000032417faeULL, 0x0003e8000c901c48ULL,
0x00000000303d7faeULL, 0x0003e8000c101c48ULL, 0x000000003a437faeULL, 0x0003e8000e901c48ULL,
0x000000000e457faeULL, 0x0003e2000e101c48ULL, 0x0000059000007947ULL, 0x000fea0003800000ULL,
0x0000001005337811ULL, 0x040fe400078fe8ffULL, 0x0000001805377811ULL, 0x020fc400078fe8ffULL,
0x00000004053d7811ULL, 0x000fe200078fe8ffULL, 0x0000000133447824ULL, 0x100fe200078e0205ULL,
0x0000000c05327811ULL, 0x000fe200078fe8ffULL, 0x0000000833317824ULL, 0x000fe200078e00ffULL,
0x0000001c05457811ULL, 0x000fe200078fe8ffULL, 0x0000000137407824ULL, 0x100fe200078e0205ULL,
0x00000008053f7811ULL, 0x000fe200078fe8ffULL, 0x0000000837397824ULL, 0x000fe200078e00ffULL,
0xfffffff831447812ULL, 0x000fe200078ee244ULL, 0x000000013d417824ULL, 0x000fe200078e0205ULL,
0x0000001405357811ULL, 0x000fe200078fe8ffULL, 0x000000083d307824ULL, 0x000fe200078e00ffULL,
0xfffffff839407812ULL, 0x000fe200078ee240ULL, 0x0000200007317824ULL, 0x000fe200078e00ffULL,
0x00000008053b7211ULL, 0x000fe200078fe8ffULL, 0x0000008007397824ULL, 0x000fe200078e00ffULL,
0xfffffff830417812ULL, 0x000fe200078ee241ULL, 0x0000000132437824ULL, 0x040fe200078e0205ULL,
0x0000200031477812ULL, 0x000fe200078ec0ffULL, 0x0000000832307824ULL, 0x000fe200078e00ffULL,
0x000000806a387812ULL, 0x000fe200078ef839ULL, 0x0000000132317824ULL, 0x000fc400078e0208ULL,
0x0000000145327824ULL, 0x040fe200078e0205ULL, 0xfffffff830437812ULL, 0x000fe200078ee243ULL,
0x0000000845397824ULL, 0x000fe200078e00ffULL, 0x0000000505307211ULL, 0x000fe200078fe8ffULL,
0x000000013f427824ULL, 0x040fe400078e0205ULL, 0x000000083f0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff839467812ULL, 0x000fe200078ee232ULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x0000000730307812ULL, 0x000fe200078ec0ffULL, 0x000000013d3d7824ULL, 0x000fe200078e0208ULL,
0xfffffff80d427812ULL, 0x000fe200078ee242ULL, 0x000000013f3f7824ULL, 0x000fc400078e0208ULL,
0x00000001350d7824ULL, 0x040fe400078e0205ULL, 0x0000000835347824ULL, 0x000fe400078e00ffULL,
0x000001003b3a7825ULL, 0x000fc600078e0038ULL, 0xfffffff8340d7812ULL, 0x000fe200078ee20dULL,
0x0000000133337824ULL, 0x100fe200078e0208ULL, 0x0000003a0e3a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000135357824ULL, 0x100fe400078e0208ULL, 0x0000000137377824ULL, 0x100fe400078e0208ULL,
0x0000000145457824ULL, 0x000fe200078e0208ULL, 0x0ffffff830087812ULL, 0x000fe200078ef805ULL,
0x000001003d3c7825ULL, 0x000fc800078e0038ULL, 0x0000400004477824ULL, 0x000fe200078e0247ULL,
0x0000003c0e3c7210ULL, 0x000fe20007f3e0ffULL, 0x000001003f3e7825ULL, 0x000fc600078e0038ULL,
0x0000b00047477810ULL, 0x000fe20007ffe0ffULL, 0x0000010031307825ULL, 0x100fe200078e0038ULL,
0x0000003e0e3e7210ULL, 0x000fe40007f5e0ffULL, 0x00000047444b7211ULL, 0x000fe200078e20ffULL,
0x0000010033327825ULL, 0x000fe200078e0038ULL, 0x000000300e307210ULL, 0x000fc60007f7e0ffULL,
0x0000010035347825ULL, 0x000fc800078e0038ULL, 0x0000010037367825ULL, 0x000fc800078e0038ULL,
0x0000010045387825ULL, 0x000fc800078e0038ULL, 0x000000010f3b7824ULL, 0x040fe200000e063bULL,
0x000000320e327210ULL, 0x040fe20007f1e0ffULL, 0x000000010f3d7824ULL, 0x040fe200008e063dULL,
0x000000340e347210ULL, 0x000fe20007f3e0ffULL, 0x0000001008457824ULL, 0x000fe400078e0247ULL,
0x000000010f3f7824ULL, 0x000fe200010e063fULL, 0x000000360e367210ULL, 0x040fe20007f5e0ffULL,
0x0000001041417824ULL, 0x000fe200078e0247ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003a457faeULL, 0x0003e2000b901c48ULL, 0x000000010f317824ULL, 0x000fe200018e0631ULL,
0x000000380e0e7210ULL, 0x000fe20007f7e0ffULL, 0x0000001042497824ULL, 0x100fe200078e0247ULL,
0x000000003c417faeULL, 0x0003e2000b901c48ULL, 0x0000001043437824ULL, 0x000fc400078e0247ULL,
0x000000010f337824ULL, 0x000fe200000e0633ULL, 0x000000003e497faeULL, 0x0003e2000b901c48ULL,
0x000000100d0d7824ULL, 0x000fe400078e0247ULL, 0x000000010f357824ULL, 0x040fe200008e0635ULL,
0x0000000030437faeULL, 0x0003e2000b901c48ULL, 0x00000010404d7824ULL, 0x000fe400078e0247ULL,
0x000000010f377824ULL, 0x000fe200010e0637ULL, 0x00000000324b7faeULL, 0x0003e2000b901c48ULL,
0x0000001046477824ULL, 0x000fc400078e0247ULL, 0x000000010f0f7824ULL, 0x000fe200018e0639ULL,
0x00000000340d7faeULL, 0x0003e8000b901c48ULL, 0x00000000364d7faeULL, 0x0003e8000b901c48ULL,
0x000000000e477faeULL, 0x0003e4000b901c48ULL, 0x0000000309087812ULL, 0x000fc800078ec0ffULL,
0x000000030800780cULL, 0x000fc80003f05270ULL, 0x0000000172087807ULL, 0x000fca0004000000ULL,
0x0000000109097824ULL, 0x000fe400078e0208ULL, 0xffffffffff087424ULL, 0x000fc600078e00ffULL,
0x0000006c0900720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00000001690e7824ULL, 0x002fe400078e0209ULL, 0x00000004ff0f7424ULL, 0x000fc800078e00ffULL,
0x000064000e0e7625ULL, 0x000fca00078e000fULL, 0x000000080e087981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x002e220000000000ULL, 0x000000106e0e7812ULL, 0x040fe400078ec0ffULL,
0x000000086e0d7812ULL, 0x000fc600078ec0ffULL, 0x000000206d0e7824ULL, 0x000fc800078e020eULL,
0x000000010d347824ULL, 0x020fe200078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01366800340e7f8cULL, 0x0002a4000c80043fULL, 0x0000000000307805ULL, 0x000fc40000015200ULL,
0x01366c00340d7984ULL, 0x000ee40000000800ULL, 0x800000000dff7812ULL, 0x00cfe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230327210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003200780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403200780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011433ULL,
0x000000320d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff327224ULL, 0x000fca00000e0633ULL,
0x000000020d0d7819ULL, 0x000fc80000001232ULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000135357810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01366c00340d7984ULL, 0x000ea40000000800ULL,
0x800000000dff7812ULL, 0x004fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001806a0d7810ULL, 0x000fca0007ffe05cULL, 0x00000001700d7824ULL, 0x000fca00078e020dULL,
0x013000000d317984ULL, 0x000ea80000000800ULL, 0x013200000d307984ULL, 0x0006620000000800ULL,
0x0000000c3100720bULL, 0x004fe20003f1d000ULL, 0x0000bca27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0d337812ULL, 0x000fe2000782c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000045000009947ULL, 0x000fea0003800000ULL, 0x000000036d0e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000c3100720bULL, 0x000fe40003f34000ULL, 0x000000070e00720cULL, 0x000fe20003f05270ULL,
0x0000bc527f007947ULL, 0x000fd4000b800000ULL, 0x0000000000327806ULL, 0x000fc400008e0100ULL,
0x00000080070f8824ULL, 0x000fe200078e026aULL, 0x0000000c310d8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x00009910320e7816ULL, 0x000fe200000000ffULL,
0x0000000170708824ULL, 0x000fca00078e020fULL, 0x0134000d70008388ULL, 0x0005e20000000800ULL,
0x000000ff0e00720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000c310d7209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff32ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000c0d0d7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL, 0x0000000d00347308ULL, 0x002e640000000800ULL,
0x000000340b0b7220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe20000011605ULL, 0x0000bb727f007947ULL, 0x000fea000b800000ULL,
0x00001f0d340d7589ULL, 0x0002a400000e0000ULL, 0x0000000d2c2c7220ULL, 0x084fe20000410000ULL,
0x0000000d2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000d28287220ULL, 0x080fe20000410000ULL,
0x0000000d29297220ULL, 0x080fe20000410000ULL, 0x0000000d24247220ULL, 0x080fe20000410000ULL,
0x0000000d25257220ULL, 0x080fe20000410000ULL, 0x0000000d20207220ULL, 0x080fe20000410000ULL,
0x0000000d21217220ULL, 0x080fe20000410000ULL, 0x0000000d1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000d1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000d18187220ULL, 0x080fe20000410000ULL,
0x0000000d19197220ULL, 0x080fe20000410000ULL, 0x0000000d14147220ULL, 0x080fe20000410000ULL,
0x0000000d15157220ULL, 0x080fe20000410000ULL, 0x0000000d10107220ULL, 0x080fe20000410000ULL,
0x0000000d11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0032ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008050d7811ULL, 0x000fe200078ff0ffULL, 0x0000ba527f007947ULL, 0x000fea000b800000ULL,
0x00001f0d340d7589ULL, 0x0004e400000e0000ULL, 0x0000000d2e2e7220ULL, 0x08cfe20000410000ULL,
0x0000000d2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000d2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000d2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000d26267220ULL, 0x080fe20000410000ULL,
0x0000000d27277220ULL, 0x080fe20000410000ULL, 0x0000000d22227220ULL, 0x080fe20000410000ULL,
0x0000000d23237220ULL, 0x080fe20000410000ULL, 0x0000000d1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000d1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000d1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000d1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000d16167220ULL, 0x080fe20000410000ULL,
0x0000000d17177220ULL, 0x080fe20000410000ULL, 0x0000000d12127220ULL, 0x080fe20000410000ULL,
0x0000000d13137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff33ff7812ULL, 0x000fe40007806032ULL, 0x0000000c310c7209ULL, 0x000fd60007810000ULL,
0x8000000c31310221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL,
0x0000003100030308ULL, 0x000ea40000000800ULL, 0x0000000330300220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x0000000b300b7221ULL, 0x002fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff317819ULL, 0x000fe40000011605ULL, 0x0000541000307816ULL, 0x000fe20000000000ULL,
0x0000b8827f007947ULL, 0x000fea000b800000ULL, 0x00001f3130027589ULL, 0x0002a400000e0000ULL,
0x00000008310d7810ULL, 0x000fe20007ffe0ffULL, 0x0000b8b27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d30007589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010310d7810ULL, 0x008fe40007ffe0ffULL, 0x00000030000e7202ULL, 0x000fc40000000f00ULL,
0x00008300000f7802ULL, 0x000fc40000000f00ULL, 0x0000bd3000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018310d7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff0e7224ULL, 0x000fe200078e0030ULL, 0x00008350000f7802ULL, 0x000fc40000000f00ULL,
0x0000bce000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000007050e7812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe60003800000ULL,
0x000000080e0e7812ULL, 0x000fca00078ef805ULL, 0x000000080e0e7824ULL, 0x000fca00078e00ffULL,
0xfffffff80e307812ULL, 0x00afca00078ee267ULL, 0x000000806d307824ULL, 0x000fca00078e0230ULL,
0x0000a80030307811ULL, 0x000fca00078e20ffULL, 0x0000c0000a0f7810ULL, 0x000fe20007ffe0ffULL,
0x000000003030783bULL, 0x000e620000000200ULL, 0x000000036d0d7810ULL, 0x004fe40007ffe0ffULL,
0x0000030006067a10ULL, 0x000fe20007ffe0ffULL, 0x000000105f547824ULL, 0x100fe200078e020fULL,
0x000136a06d0a7811ULL, 0x000fe200078e18ffULL, 0x000000105e347824ULL, 0x100fe400078e020fULL,
0x000000105d507824ULL, 0x100fe400078e020fULL, 0x00000010604c7824ULL, 0x000fe200078e020fULL,
0x000000005454783bULL, 0x000ea20000004200ULL, 0x000008000d387824ULL, 0x000fc400078e0258ULL,
0x0000001064487824ULL, 0x100fe200078e020fULL, 0x000000003434783bULL, 0x000fe20000004200ULL,
0x0000001063447824ULL, 0x100fe400078e020fULL, 0x0000001062407824ULL, 0x100fe200078e020fULL,
0x000000005050783bULL, 0x000fe20000004200ULL, 0x00000010663c7824ULL, 0x000fc600078e020fULL,
0x000000004c4c783bULL, 0x000fe80000004200ULL, 0x009000003838783bULL, 0x000ee80000000200ULL,
0x000000004848783bULL, 0x000ee80000004200ULL, 0x000000004444783bULL, 0x000ee80000004200ULL,
0x000000004040783bULL, 0x000ee20000004200ULL, 0x0000000230300232ULL, 0x002fc40000000000ULL,
0x0000000232320232ULL, 0x000fe20000000000ULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0x0000000031310232ULL, 0x080fe40000000000ULL, 0x0000000033330232ULL, 0x000fce0000000000ULL,
0x00000054302c723cULL, 0x044f70000000182cULL, 0x000000563028723cULL, 0x000f620000001828ULL,
0x0000000238380232ULL, 0x008fce0000000000ULL, 0x000000343024723cULL, 0x000f620000001824ULL,
0x000000023a3a0232ULL, 0x000fe40000000000ULL, 0x0000000039390232ULL, 0x080fe40000000000ULL,
0x000000003b3b0232ULL, 0x000fc60000000000ULL, 0x000000363020723cULL, 0x040f700000001820ULL,
0x00000050301c723cULL, 0x040f70000000181cULL, 0x000000523018723cULL, 0x040f700000001818ULL,
0x0000004c3014723cULL, 0x040f700000001814ULL, 0x0000004e3010723cULL, 0x000f700000001810ULL,
0x00000048382c723cULL, 0x060b70000000182cULL, 0x0000004a3828723cULL, 0x040b700000001828ULL,
0x000000443824723cULL, 0x040b700000001824ULL, 0x000000463820723cULL, 0x040b700000001820ULL,
0x00000040381c723cULL, 0x040b70000000181cULL, 0x000000423818723cULL, 0x040b700000001818ULL,
0x0000003c3814723cULL, 0x042b700000001814ULL, 0x0000003e3810723cULL, 0x000b620000001810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000650600720cULL, 0x000fe20003f06070ULL,
0x000000000aff7f8cULL, 0x0003d8000c80043fULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff931000007947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x002e620000002500ULL,
0x000000ffff337224ULL, 0x020fe400078e0013ULL, 0x000000ffff327224ULL, 0x000fe400078e0012ULL,
0x000000ffff067224ULL, 0x000fe400078e0010ULL, 0x000000ffff317224ULL, 0x000fe400078e0017ULL,
0x000000ffff307224ULL, 0x000fe200078e0016ULL, 0x000000650200720cULL, 0x002fda0003f06070ULL,
0x0000032000000947ULL, 0x000fea0003800000ULL, 0x018000000b007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000884000087802ULL, 0x010fc40000000f00ULL, 0x0000b64000007944ULL, 0x000fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000b00007308ULL, 0x000e640000001000ULL,
0xbf80000000037423ULL, 0x002fc8000000000bULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x00000002ff037819ULL, 0x002fe40000011605ULL,
0x0000000805057811ULL, 0x000fc800078ff0ffULL, 0x00001f0300037589ULL, 0x00ce6800000e0000ULL,
0x00001f0500057589ULL, 0x000ea200000e0000ULL, 0x0000002c032c7220ULL, 0x042fe20000410000ULL,
0x0000002d032d7220ULL, 0x040fe20000410000ULL, 0x0000002803287220ULL, 0x040fe20000410000ULL,
0x0000002903297220ULL, 0x040fe20000410000ULL, 0x0000002403247220ULL, 0x040fe20000410000ULL,
0x0000002503257220ULL, 0x040fe20000410000ULL, 0x0000002003207220ULL, 0x040fe20000410000ULL,
0x0000002103217220ULL, 0x040fe20000410000ULL, 0x0000001c031c7220ULL, 0x040fe20000410000ULL,
0x0000001d031d7220ULL, 0x040fe20000410000ULL, 0x0000001803187220ULL, 0x040fe20000410000ULL,
0x0000001903197220ULL, 0x040fe20000410000ULL, 0x0000001403147220ULL, 0x040fe20000410000ULL,
0x0000001503157220ULL, 0x040fe20000410000ULL, 0x0000000603067220ULL, 0x040fe20000410000ULL,
0x0000001103117220ULL, 0x000fe20000410000ULL, 0x0000002e052e7220ULL, 0x044fe20000410000ULL,
0x0000002f052f7220ULL, 0x040fe20000410000ULL, 0x0000002a052a7220ULL, 0x040fe20000410000ULL,
0x0000002b052b7220ULL, 0x040fe20000410000ULL, 0x0000002605267220ULL, 0x040fe20000410000ULL,
0x0000002705277220ULL, 0x040fe20000410000ULL, 0x0000002205227220ULL, 0x040fe20000410000ULL,
0x0000002305237220ULL, 0x040fe20000410000ULL, 0x0000001e051e7220ULL, 0x040fe20000410000ULL,
0x0000001f051f7220ULL, 0x040fe20000410000ULL, 0x0000001a051a7220ULL, 0x040fe20000410000ULL,
0x0000001b051b7220ULL, 0x040fe20000410000ULL, 0x0000003005307220ULL, 0x040fe20000410000ULL,
0x0000003105317220ULL, 0x040fe20000410000ULL, 0x0000003205327220ULL, 0x040fe20000410000ULL,
0x0000003305337220ULL, 0x000fc20000410000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x00000020210d723eULL, 0x000fc400000000ffULL, 0x0000001e1f16723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000024250a723eULL, 0x000fe400000000ffULL,
0x0000001c1d0e723eULL, 0x000fe400000000ffULL, 0x000000061111723eULL, 0x000fc400000000ffULL,
0x000000141510723eULL, 0x000fe400000000ffULL, 0x000000262714723eULL, 0x000fe400000000ffULL,
0x000000222315723eULL, 0x000fe400000000ffULL, 0x0000001a1b17723eULL, 0x000fe400000000ffULL,
0x00000002ff207819ULL, 0x002fe40000011600ULL, 0x0000002a2b13723eULL, 0x000fc400000000ffULL,
0x0000000120057810ULL, 0x040fe20007ffe0ffULL, 0x0000000820087824ULL, 0x050fe200078e00ffULL,
0x0000000220067810ULL, 0x040fe20007ffe0ffULL, 0x00000008201f7824ULL, 0x040fe200078e00ffULL,
0x00000006201a7810ULL, 0x040fe20007ffe0ffULL, 0x00000008201c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8081d7812ULL, 0x000fe200078ee205ULL, 0x0000000820257824ULL, 0x040fe200078e00ffULL,
0x0000000320057810ULL, 0x040fe20007ffe0ffULL, 0x0000000820277824ULL, 0x040fe200078e00ffULL,
0x0000000520087810ULL, 0x040fe20007ffe0ffULL, 0x0000000820237824ULL, 0x040fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee206ULL, 0x00000008201b7824ULL, 0x040fe200078e00ffULL,
0x0000000420067810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81c217812ULL, 0x000fe200078ee205ULL,
0x000010006b057824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee208ULL,
0x0000080004087824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee21aULL,
0x00000004001a7824ULL, 0x040fe200078e00ffULL, 0x00000008002b7811ULL, 0x000fe400078ff0ffULL,
0xfffffff823237812ULL, 0x000fe200078ee206ULL, 0x0000000105067824ULL, 0x000fe200078e0208ULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee220ULL, 0x000000082b1e7824ULL, 0x000fe200078e00ffULL,
0x000000282909723eULL, 0x000fe200000000ffULL, 0x0000000820297824ULL, 0x040fe200078e00ffULL,
0xffffffff201c7810ULL, 0x000fe20007ffe0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0206ULL,
0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0206ULL,
0x000000061d1d7211ULL, 0x000fe200078e20ffULL, 0x0000001021217824ULL, 0x000fe200078e0206ULL,
0xfffffff829297812ULL, 0x000fe200078ee21cULL, 0x0000001023237824ULL, 0x000fe200078e0206ULL,
0xfffffff81e2b7812ULL, 0x000fe200078ee22bULL, 0x000000011b1c7824ULL, 0x000fe200078e021aULL,
0x0000002c2d03723eULL, 0x000fe200000000ffULL, 0x0000001025257824ULL, 0x100fe200078e0206ULL,
0x00000018190f723eULL, 0x000fe200000000ffULL, 0x000000011a1e7824ULL, 0x040fe200078e021dULL,
0x0000002e2f12723eULL, 0x000fe200000000ffULL, 0x0000001027277824ULL, 0x100fe200078e0206ULL,
0x000000031c007388ULL, 0x000fe20000000800ULL, 0x000000011a1f7824ULL, 0x040fe200078e021fULL,
0x000000303118723eULL, 0x000fe200000000ffULL, 0x0000001029297824ULL, 0x100fe200078e0206ULL,
0x000000091e007388ULL, 0x000fe20000000800ULL, 0x000000011a207824ULL, 0x040fe200078e0221ULL,
0x000000323319723eULL, 0x000fe200000000ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0206ULL,
0x0000000a1f007388ULL, 0x000fe20000000800ULL, 0x000000011a237824ULL, 0x000fc400078e0223ULL,
0x000000011a227824ULL, 0x040fe200078e0225ULL, 0x0000000d20007388ULL, 0x0003e20000000800ULL,
0x000000011a277824ULL, 0x040fe400078e0227ULL, 0x000000011a247824ULL, 0x040fe200078e0229ULL,
0x0000000e23007388ULL, 0x000fe20000000800ULL, 0x000000011a2b7824ULL, 0x000fe400078e022bULL,
0x000000016f1a7824ULL, 0x000fe200078e0200ULL, 0x0000000f22007388ULL, 0x000fe60000000800ULL,
0x000000101a0d7824ULL, 0x002fe200078e0205ULL, 0x0000001027007388ULL, 0x000fe80000000800ULL,
0x0000001124007388ULL, 0x000fe80000000800ULL, 0x000000122b007388ULL, 0x000fe80000000800ULL,
0x000400131e007388ULL, 0x000fe80000000800ULL, 0x000400141f007388ULL, 0x000fe80000000800ULL,
0x0004001520007388ULL, 0x000fe80000000800ULL, 0x0004001623007388ULL, 0x000fe80000000800ULL,
0x0004001722007388ULL, 0x0003e80000000800ULL, 0x0004001827007388ULL, 0x000fe80000000800ULL,
0x0004001924007388ULL, 0x000fe20000000800ULL, 0x00000300ff227624ULL, 0x002fc600078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000d287984ULL, 0x000e620000000c00ULL,
0x000000012200780cULL, 0x000fc60003f05270ULL, 0x000400000d1c7984ULL, 0x000ea80000000c00ULL,
0x000800000d107984ULL, 0x000ee80000000c00ULL, 0x000c00000d2c7984ULL, 0x000ee20000000c00ULL,
0x200000ff2b2b7230ULL, 0x002fe40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fc40000000000ULL,
0x200000ff29297230ULL, 0x000fe40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x004fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fe40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fc40000000000ULL,
0x000000132b2b7230ULL, 0x008fe40000000000ULL, 0x000000122a2a7230ULL, 0x000fe40000000000ULL,
0x0000001129297230ULL, 0x000fe40000000000ULL, 0x0000001028287230ULL, 0x000fe40000000000ULL,
0x0000002f1f1f7230ULL, 0x000fe40000000000ULL, 0x0000002e1e1e7230ULL, 0x000fe20000000000ULL,
0x000000280d007388ULL, 0x000fe20000000c00ULL, 0x0000002d1d1d7230ULL, 0x000fc40000000000ULL,
0x0000002c1c1c7230ULL, 0x000fca0000000000ULL, 0x0004001c0d007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00002a6000008947ULL, 0x000fea0003800000ULL,
0x00000400ff037624ULL, 0x000fe200078e00ffULL, 0x00000000000f7919ULL, 0x000e660000002600ULL,
0x00006a0003037a24ULL, 0x000fe200078e02ffULL, 0x0000000000187919ULL, 0x000e680000002700ULL,
0x0000000f030e7811ULL, 0x040fe200078e10ffULL, 0x0000030003037a24ULL, 0x000fe200078e02ffULL,
0x000000000d107984ULL, 0x000ea40000000c00ULL, 0xfffffff00e0e7812ULL, 0x000fc400078ec0ffULL,
0x000400000d147984ULL, 0x0006a60000000c00ULL, 0x00000080030a7824ULL, 0x000fc800078e020eULL,
0x0000008003037824ULL, 0x000fe200078e020aULL, 0x000000401a0d7810ULL, 0x008fc80007ffe0ffULL,
0x0000007f03037810ULL, 0x000fe20007ffe0ffULL, 0x00000400180f7a24ULL, 0x002fc600078e020fULL,
0xffffff8003037812ULL, 0x000fe200078ec0ffULL, 0x000003000f097a24ULL, 0x000fc600078e02ffULL,
0x00006e0003197a10ULL, 0x000fe20007f1e0ffULL, 0x0000000109027824ULL, 0x000fca00078e0202ULL,
0x0000001902187211ULL, 0x000fe200078260ffULL, 0x00006f00ff197624ULL, 0x000fe200000e06ffULL,
0x0000000104ff7812ULL, 0x000fc8000780f807ULL, 0x0000001902197211ULL, 0x000fe400008f64ffULL,
0x00006e000e207a10ULL, 0x000fc60007f3e0ffULL, 0x000008006b187825ULL, 0x000fc800078e0018ULL,
0x00006f00ff217624ULL, 0x000fe400008e06ffULL, 0x000000101a1a7825ULL, 0x000fc800078e0018ULL,
0x000000100d187825ULL, 0x000fe200078e0018ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x00000010001c7824ULL, 0x004fe200078e00ffULL, 0x00000001ff1d7819ULL, 0x000fe20000011600ULL,
0x00000080020d7824ULL, 0x000fe200078e00ffULL, 0x00000019ff027819ULL, 0x000fe40000011602ULL,
0x000000701c1f7812ULL, 0x000fe400078ec0ffULL, 0x0000000c1d1c7812ULL, 0x000fe400078ec0ffULL,
0x00006e000d1e7a10ULL, 0x000fc40007ebe00aULL, 0x000000201f0d7210ULL, 0x000fe40007a3e00dULL,
0x0000001e1c1e7210ULL, 0x000fe40007c7e01fULL, 0x00006f00021d7a10ULL, 0x000fe40002fec4ffULL,
0x0000000d1c1c7210ULL, 0x000fe40007fbe0ffULL, 0x00000021ff027210ULL, 0x000fe40000fe4402ULL,
0x0000001dff1f7210ULL, 0x000fc60001fe84ffULL, 0x000000ffff1d7224ULL, 0x000fca00028e0602ULL,
0x0000000c1c007986ULL, 0x0003e8000c101908ULL, 0x0000000b1e007986ULL, 0x0003e4000c101908ULL,
0x000000ff0000720cULL, 0x004fe20000705670ULL, 0x000000101a007986ULL, 0x000fe2000c101d08ULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x0000001418007986ULL, 0x000fe8000c101d08ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff0c7424ULL, 0x002fe200078e00ffULL, 0xffffffff220b7810ULL, 0x000fc60007ffe0ffULL,
0x00006e000f0c7625ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x0000000b0c0c79a8ULL, 0x000ea400099ee1c8ULL, 0x0000000b0c00720cULL, 0x004fc80003f05270ULL,
0x00000001ff027807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000002ff007388ULL, 0x0003e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff027984ULL, 0x002e640000000000ULL,
0x000000ff0200720cULL, 0x002fda0003f05270ULL, 0x000025e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x00000001ff077819ULL, 0x000fe40000011600ULL,
0x00000020090c7211ULL, 0x000fe400078038ffULL, 0x00000070020d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c07077812ULL, 0x000fe400078ec0ffULL, 0x0000002109027211ULL, 0x000fe400000f3cffULL,
0x0000000c070c7210ULL, 0x000fc8000791e00dULL, 0x00000002ff0d7210ULL, 0x000fca00007e24ffULL,
0x000000080c027981ULL, 0x000328000c1e1900ULL, 0x000080080c077981ULL, 0x000322000c1e1900ULL,
0x000000022200780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x000100080c0b7981ULL, 0x002322000c1e1900ULL, 0x000000042200780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x000180080c0f7981ULL, 0x002322000c1e1900ULL,
0x000000042200780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x000200080c117981ULL, 0x002322000c1e1900ULL, 0x000000062200780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x000280080c137981ULL, 0x002322000c1e1900ULL,
0x000000062200780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000082200780cULL, 0x002fe20003f06070ULL, 0x000300080c157981ULL, 0x000318000c1e1900ULL,
0x000380080c170981ULL, 0x000324000c1e1900ULL, 0x00000007220c7810ULL, 0x002fc80007ffe0ffULL,
0x00000003ff107819ULL, 0x000fc8000001160cULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x0000000e091b7211ULL, 0x000fe200078038ffULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x0000000200197202ULL, 0x010fe20000000f00ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x00006e001b1b7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff09127211ULL, 0x000fe400000f3cffULL, 0x000007801b1b7810ULL, 0x000fc80007f5e0ffULL,
0x00006f00ff127a10ULL, 0x000fc400017e2412ULL, 0x0000030014007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x0000000410007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x00000008140c7810ULL, 0x040fe40007ffe0ffULL,
0x00000001140d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001902027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011600ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1b0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e0612ULL, 0xfffc80080c197981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x00000009140c7810ULL, 0x042fe40007ffe0ffULL,
0x00000002140d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000000702027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001000077824ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fc80000011600ULL, 0x0000007007077812ULL, 0x000fc800078ec0ffULL,
0x0000000c070c7812ULL, 0x000fc800078ef80cULL, 0x0000000c1b0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e0612ULL, 0xfffd00080c077981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a140c7810ULL, 0x042fe40007ffe0ffULL,
0x00000003140d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000000b02027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010000b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0c7819ULL, 0x000fc80000011600ULL, 0x000000700b0b7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0b0c7812ULL, 0x000fc800078ef80cULL, 0x0000000c1b0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e0612ULL, 0xfffd80080c0b7981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b140c7810ULL, 0x042fe40007ffe0ffULL,
0x00000004140d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000000f02027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011600ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1b0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e0612ULL, 0xfffe00080c0f7981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c140c7810ULL, 0x042fe40007ffe0ffULL,
0x00000005140d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001102027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011600ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1b0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e0612ULL, 0xfffe80080c117981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d140c7810ULL, 0x042fe40007ffe0ffULL,
0x00000006140d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001302027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011600ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1b0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e0612ULL, 0xffff00080c137981ULL, 0x000326000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e140c7810ULL, 0x042fe40007ffe0ffULL,
0x00000007140d7810ULL, 0x000fe40007ffe0ffULL, 0x000003000c007a0cULL, 0x000fe40003f26070ULL,
0x000003000d007a0cULL, 0x000fe40003f46070ULL, 0x0000001502027209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011600ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1b0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e0612ULL, 0xffff80080c157981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f140c7810ULL, 0x002fe40007ffe0ffULL,
0x0000001702027209ULL, 0x000fe40007810000ULL, 0x000003000c007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x00000010000c7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0d7819ULL, 0x000fc80000011600ULL, 0x000000700c0c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL, 0x0000000c1b0c7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0d7224ULL, 0x000fca00008e0612ULL, 0x000000080c177981ULL, 0x000326000c1e1900ULL,
0x000004001b1b7810ULL, 0x000fe40007f3e0ffULL, 0x0000000814147810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff127224ULL, 0x000fe200008e0612ULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000007919ULL, 0x000ea40000000000ULL, 0x0000001000077824ULL, 0x014fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc80000011600ULL, 0x0000007007077812ULL, 0x000fe400078ec0ffULL,
0x0000000c0b0c7812ULL, 0x002fca00078ec0ffULL, 0x0000000107077824ULL, 0x000fca00078e020cULL,
0x0000000207007388ULL, 0x0003e40000000800ULL, 0x00006e0003027a10ULL, 0x002fe20007f3e0ffULL,
0x0000000104197824ULL, 0x000fe200078e0209ULL, 0x000000070000780cULL, 0x000fe20003f04070ULL,
0x000008006b077824ULL, 0x000fe200078e00ffULL, 0x00000001040b7812ULL, 0x000fe200078ec0ffULL,
0x00006f00ff037624ULL, 0x000fe200008e06ffULL, 0x00006e000e157a10ULL, 0x000fe20007f5e0ffULL,
0x0000200004147824ULL, 0x000fe200078e0205ULL, 0x0000002000117810ULL, 0x040fe20007ffe0ffULL,
0x00001000190c7825ULL, 0x040fe200078e0002ULL, 0x0000004000137810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000204108824ULL, 0x100fe200078e026bULL,
0x000000070c0c7210ULL, 0x000fe20007f3e0ffULL, 0x0000000204128824ULL, 0x000fe200078e026bULL,
0x00000060001b7810ULL, 0x000fe20007ffe0ffULL, 0x00000002101d8824ULL, 0x100fe200078e020bULL,
0x00000001ff107819ULL, 0x000fe20000011600ULL, 0x0000000212218824ULL, 0x000fe200078e020bULL,
0x00000800080b7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x00006e000a087a10ULL, 0x000fe20007f3e0ffULL, 0x00000010000a7824ULL, 0x000fe200078e00ffULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000001140f7824ULL, 0x000fe200078e020bULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x00006f00ff167624ULL, 0x000fe200008e06ffULL,
0x000000700a0b7812ULL, 0x000fe200078ec0ffULL, 0x00006f00ff187624ULL, 0x000fe200010e06ffULL,
0x0000000c100a7812ULL, 0x000fe200078ec0ffULL, 0x00000010001f7824ULL, 0x000fe200078e020fULL,
0x00000008190e8211ULL, 0x000fe200078238ffULL, 0x0000001011107825ULL, 0x100fe200078e000cULL,
0x00000015191c8211ULL, 0x000fe200078438ffULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000a0b177210ULL, 0x000fe20007ffe0ffULL, 0x0000001013127825ULL, 0x100fe200078e000cULL,
0x00000016190f8211ULL, 0x000fe200008f3cffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000030004007a0cULL, 0x000fe20003f26070ULL, 0x000000101b1a7825ULL, 0x100fe200078e000cULL,
0x0000000017177984ULL, 0x000e620000000800ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x00000010000c7825ULL, 0x040fe200078e000cULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x000000081d238824ULL, 0x100fe200078e0200ULL,
0x00000018191d8211ULL, 0x000fe200010f3cffULL, 0x0000000821218824ULL, 0x000fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000c1f7faeULL, 0x0005e2000b901c48ULL,
0x00000010000e8825ULL, 0x000fe200078e000eULL, 0x0000458023238811ULL, 0x000fc400078e20ffULL,
0x0000418021258811ULL, 0x000fe200078e20ffULL, 0x00380000101f7faeULL, 0x0007e2000b901c48ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x00580000121f7faeULL, 0x0007e2000b901c48ULL,
0x000000ffff3a7224ULL, 0x000fe400078e00ffULL, 0x00000010000c8825ULL, 0x004fe200078e001cULL,
0x007800001a1f7faeULL, 0x0007e2000b901c48ULL, 0x00000000001c7805ULL, 0x000fc6000001ff00ULL,
0x000000000e238faeULL, 0x0005e8000b901c48ULL, 0x000000000c258faeULL, 0x0009e8000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000001e7805ULL, 0x008fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x004fe2000001ff00ULL,
0x0000000000247805ULL, 0x010fe2000001ff00ULL, 0x00000c6000001947ULL, 0x000fea0003800000ULL,
0x000000ffff197224ULL, 0x002fe400078e00ffULL, 0x000000ffff397224ULL, 0x000fca00078e0004ULL,
0x00000001390c7810ULL, 0x000fc80007ffe0ffULL, 0x000003000c007a0cULL, 0x000fda0003f06070ULL,
0x0000028000000947ULL, 0x000fea0003800000ULL, 0x0000000109417824ULL, 0x000fe200078e020cULL,
0x000000070000780cULL, 0x000fe40003f44070ULL, 0x000000010c0d7812ULL, 0x000fe200078ec0ffULL,
0x00001000410a7825ULL, 0x000fe200078e0002ULL, 0x0000002000117810ULL, 0x040fe40007ffe0ffULL,
0x0000004000137810ULL, 0x000fe40007ffe0ffULL, 0x000000070a0e7210ULL, 0x000fe20007f1e0ffULL,
0x000008000c0a7824ULL, 0x000fe200078e00ffULL, 0x0000006000437810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e060bULL, 0x000008000a0b7812ULL, 0x000fe200078ec0ffULL,
0x000000020410a824ULL, 0x140fe200078e026bULL, 0x00000008410ca211ULL, 0x040fe200078038ffULL,
0x000000020412a824ULL, 0x000fe200078e026bULL, 0x00000015410aa211ULL, 0x040fe200078238ffULL,
0x00000001140b7824ULL, 0x000fe400078e020bULL, 0x00000002103fa824ULL, 0x100fe400078e020dULL,
0x000000021245a824ULL, 0x000fe200078e020dULL, 0x00000016410da211ULL, 0x040fe200000f3cffULL,
0x00000010003b7824ULL, 0x000fe200078e020bULL, 0x00000018410ba211ULL, 0x000fe200008f3cffULL,
0x000000083f3fa824ULL, 0x000fc400078e0200ULL, 0x00000010003c7825ULL, 0x000fc600078e000eULL,
0x000045803f3fa811ULL, 0x000fe200078e20ffULL, 0x000000084541a824ULL, 0x000fe200078e0200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800003c3b7faeULL, 0x0003e2000b901c48ULL,
0x0000001011107825ULL, 0x000fc600078e000eULL, 0x000041804141a811ULL, 0x000fe200078e20ffULL,
0x0000001013127825ULL, 0x100fe200078e000eULL, 0x00380000103b7faeULL, 0x0003e6000b901c48ULL,
0x00000010430e7825ULL, 0x000fe200078e000eULL, 0x00580000123b7faeULL, 0x0003e6000b901c48ULL,
0x00000010000ca825ULL, 0x040fe200078e000cULL, 0x007800000e3b7faeULL, 0x0003e6000b901c48ULL,
0x00000010000aa825ULL, 0x000fe200078e000aULL, 0x000000000c3fafaeULL, 0x0003e8000b901c48ULL,
0x000000000a41afaeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000080390a7824ULL, 0x002fe200078e00ffULL, 0x00000001ff0e7819ULL, 0x100fe20000011600ULL,
0x00000002040d7824ULL, 0x000fe200078e026bULL, 0x00000002ff447819ULL, 0x000fe20000011600ULL,
0x00000010000b7824ULL, 0x000fe200078e00ffULL, 0x000000800a0a7812ULL, 0x000fc400078ec0ffULL,
0x0000000844487810ULL, 0x040fe20007ffe0ffULL, 0x0000000844127824ULL, 0x000fe200078e00ffULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x000001000d0c7824ULL, 0x000fe200078e000aULL,
0x0000000c0e0a7812ULL, 0x000fe200078ec0ffULL, 0x00000008443e7824ULL, 0x040fe200078e00ffULL,
0x00000001440d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000844427824ULL, 0x000fe200078e00ffULL,
0x0000000c0a0e7210ULL, 0x000fe20007ffe00bULL, 0x00000800390c7824ULL, 0x000fe200078e00ffULL,
0xfffffff812117812ULL, 0x000fe200078ee20dULL, 0x00000008444a7824ULL, 0x040fe200078e00ffULL,
0x00000002440f7810ULL, 0x040fe20007ffe0ffULL, 0x00000008443f7824ULL, 0x000fe200078e00ffULL,
0x000008000c0d7812ULL, 0x000fe200078ec0ffULL, 0x00000004000c7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x004180000e107984ULL, 0x000e620000000800ULL,
0xfffffff83e3b7812ULL, 0x000fe200078ee20fULL, 0x00000008440f7824ULL, 0x000fe200078e00ffULL,
0x0000000c0c467812ULL, 0x000fe200078ec0ffULL, 0x004580000e3c7984ULL, 0x0004e20000000800ULL,
0x00000003443d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80f0f7812ULL, 0x000fe400078ee244ULL,
0xfffffff8423d7812ULL, 0x000fe400078ee23dULL, 0x00000004443e7810ULL, 0x000fc40007ffe0ffULL,
0x00000180140e7810ULL, 0x004fe20007ffe00dULL, 0x00000008480d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe400078ee23eULL, 0xffffffff443e7810ULL, 0x000fe20007ffe0ffULL,
0x000000100f0c7824ULL, 0x000fe200078e020eULL, 0xfffffff80d0d7812ULL, 0x000fe400078ee248ULL,
0x0000000239397810ULL, 0x000fe20007ffe0ffULL, 0x00000001460c7824ULL, 0x000fe200078e020cULL,
0x0000000e0d0d7211ULL, 0x000fc400078e20ffULL, 0x0000030039007a0cULL, 0x000fe40003f06070ULL,
0x000000000c0f7984ULL, 0x000fe20000000800ULL, 0x0000000146127824ULL, 0x000fe400078e020dULL,
0x00000010110d7824ULL, 0x100fe200078e020eULL, 0x0000000544117810ULL, 0x000fe40007ffe0ffULL,
0x0000000012407984ULL, 0x000ea20000000800ULL, 0x00000001460d7824ULL, 0x000fe200078e020dULL,
0xfffffff84a437812ULL, 0x000fe200078ee211ULL, 0x000000103b117824ULL, 0x000fe200078e020eULL,
0x00000006443b7810ULL, 0x000fc40007ffe0ffULL, 0x000400000d417984ULL, 0x000fe20000000800ULL,
0x0000001017107221ULL, 0x002fe20000010100ULL, 0x0000000146117824ULL, 0x000fc600078e0211ULL,
0x3fb8aa3b10107820ULL, 0x000fe40000410000ULL, 0x0000000011127984ULL, 0x000fe40000000800ULL,
0x0000001000137308ULL, 0x0002e40000000800ULL, 0x0004000011427984ULL, 0x000fe80000000800ULL,
0x000000000d107984ULL, 0x002fe20000000800ULL, 0x0000003c13457220ULL, 0x008fe20000410000ULL,
0x00000008443c7824ULL, 0x000fc400078e00ffULL, 0x000000103d137824ULL, 0x000fe200078e020eULL,
0x0000003a453a7221ULL, 0x000fe20000010000ULL, 0x00001f44450c7589ULL, 0x000e6200000e0000ULL,
0x00000008443d7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c477812ULL, 0x000fe200078ee23bULL,
0x0000000146137824ULL, 0x040fe200078e0213ULL, 0x00001f48450d7589ULL, 0x00072200000e0000ULL,
0x000000103f3c7824ULL, 0x000fe200078e020eULL, 0xfffffff83d3f7812ULL, 0x000fe200078ee23eULL,
0x00000010433d7824ULL, 0x000fe200078e020eULL, 0x00000000133b7984ULL, 0x000f220000000800ULL,
0x00000001463c7824ULL, 0x000fc400078e023cULL, 0x00000010473e7824ULL, 0x100fe200078e020eULL,
0x0004000013437984ULL, 0x000fe20000000800ULL, 0x000000103f3f7824ULL, 0x000fe400078e020eULL,
0x00000001463d7824ULL, 0x000fe200078e023dULL, 0x000000003c0e7984ULL, 0x000f220000000800ULL,
0x20000040ff477230ULL, 0x104fe40000004100ULL, 0x3000000fff457230ULL, 0x008fe20000004100ULL,
0x000400003c447984ULL, 0x000ea20000000800ULL, 0x30000040ff407230ULL, 0x000fc40000004100ULL,
0x2000000fff117230ULL, 0x000fe20000004100ULL, 0x0000000c45307223ULL, 0x082fe20000010030ULL,
0x00000001463e7824ULL, 0x040fe200078e023eULL, 0x000000003d0f7984ULL, 0x000e620000000800ULL,
0x00000001463f7824ULL, 0x000fe200078e023fULL, 0x0000000d402f7223ULL, 0x090fe2000001002fULL,
0x20000010ff407230ULL, 0x100fe20000004100ULL, 0x0000000c111a7223ULL, 0x080fe2000001001aULL,
0x30000010ff457230ULL, 0x000fe20000004100ULL, 0x000400003d137984ULL, 0x000ee20000000800ULL,
0x20000041ff107230ULL, 0x100fe20000004100ULL, 0x0000000c401f7223ULL, 0x080fe2000001001fULL,
0x30000041ff417230ULL, 0x000fe20000004100ULL, 0x000400003e3c7984ULL, 0x000f220000000800ULL,
0x20000012ff407230ULL, 0x100fe20000004100ULL, 0x0000000d102d7223ULL, 0x080fe2000001002dULL,
0x0000000c452e7223ULL, 0x080fe2000001002eULL, 0x000000003e117984ULL, 0x000f220000000800ULL,
0x0000000d412c7223ULL, 0x080fe2000001002cULL, 0x30000012ff417230ULL, 0x000fe20000004100ULL,
0x0000000d47227223ULL, 0x080fe20000010022ULL, 0x000000003f107984ULL, 0x000f220000000800ULL,
0x20000042ff457230ULL, 0x100fe20000004100ULL, 0x0000000c402b7223ULL, 0x080fe2000001002bULL,
0x30000042ff427230ULL, 0x000fe20000004100ULL, 0x000400003f3d7984ULL, 0x0005220000000800ULL,
0x2000003bff127230ULL, 0x100fe20000004100ULL, 0x0000000c41387223ULL, 0x080fe20000010038ULL,
0x3000003bff3b7230ULL, 0x000fe20000004100ULL, 0x0000000d452a7223ULL, 0x080fe2000001002aULL,
0x0000000d42297223ULL, 0x000fe20000010029ULL, 0x0000000c12377223ULL, 0x080fe20000010037ULL,
0x2000000eff127230ULL, 0x100fe20000004100ULL, 0x0000000c3b367223ULL, 0x000fe20000010036ULL,
0x3000000eff0e7230ULL, 0x000fc40000004100ULL, 0x20000043ff3f7230ULL, 0x104fe20000004100ULL,
0x0000000c12277223ULL, 0x080fe20000010027ULL, 0x20000044ff127230ULL, 0x100fe20000004100ULL,
0x0000000c0e257223ULL, 0x080fe20000010025ULL, 0x30000043ff437230ULL, 0x000fe20000004100ULL,
0x0000000d3f267223ULL, 0x080fe20000010026ULL, 0x3000000fff0e7230ULL, 0x102fe20000004100ULL,
0x0000000d12357223ULL, 0x080fe20000010035ULL, 0x2000000fff3b7230ULL, 0x000fe20000004100ULL,
0x0000000d43287223ULL, 0x080fe20000010028ULL, 0x30000044ff3f7230ULL, 0x000fe20000004100ULL,
0x0000000c0e237223ULL, 0x080fe20000010023ULL, 0x20000013ff127230ULL, 0x108fe20000004100ULL,
0x0000000c3b247223ULL, 0x080fe20000010024ULL, 0x30000013ff137230ULL, 0x000fe20000004100ULL,
0x0000000d3f347223ULL, 0x080fe20000010034ULL, 0x2000003cff0f7230ULL, 0x110fe20000004100ULL,
0x0000000d12337223ULL, 0x080fe20000010033ULL, 0x3000003cff3c7230ULL, 0x000fe20000004100ULL,
0x0000000d13327223ULL, 0x080fe20000010032ULL, 0x20000011ff0e7230ULL, 0x100fe20000004100ULL,
0x0000000d0f207223ULL, 0x080fe20000010020ULL, 0x30000011ff127230ULL, 0x000fe20000004100ULL,
0x0000000d3c317223ULL, 0x000fe20000010031ULL, 0x20000010ff0f7230ULL, 0x100fe20000004100ULL,
0x0000000c0e1b7223ULL, 0x080fe2000001001bULL, 0x30000010ff107230ULL, 0x000fe20000004100ULL,
0x0000000c12217223ULL, 0x080fe20000010021ULL, 0x2000003dff117230ULL, 0x100fe20000004100ULL,
0x0000000c0f1e7223ULL, 0x080fe2000001001eULL, 0x3000003dff0e7230ULL, 0x000fe20000004100ULL,
0x0000000c101d7223ULL, 0x000fc4000001001dULL, 0x0000000d111c7223ULL, 0x080fe4000001001cULL,
0x0000000d0e197223ULL, 0x000fe20000010019ULL, 0xfffff3c000008947ULL, 0x000fea000383ffffULL,
0x000000ff6b00720cULL, 0x002fe20003f05270ULL, 0x0000018000007945ULL, 0x000fd80003800000ULL,
0x0000008004038824ULL, 0x000fc800078e020bULL, 0x000000010a038824ULL, 0x000fe400078e0203ULL,
0x000000010b0a7824ULL, 0x000fc600078e020aULL, 0x0049803a03008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x004980000a007984ULL, 0x000e680000000800ULL,
0x004a00000a077984ULL, 0x000ea20000000800ULL, 0x00000000ff007221ULL, 0x002fc80000010000ULL,
0x0000000700007221ULL, 0x004fca0000010000ULL, 0x0180000000027810ULL, 0x000fc80007ffe0ffULL,
0x7f80000002027812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000005000000947ULL, 0x000fea0003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e0000ULL, 0x0000b33000087802ULL, 0x000fc40000000f00ULL,
0x00008b5000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff027224ULL, 0x00cfe200078e0000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000000037308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000003ULL, 0x800000ff02027221ULL, 0x000fc80000010100ULL,
0x0000000203027223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007919ULL, 0x000ea80000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff0b7819ULL, 0x006fc40000011600ULL, 0x00000008000d7811ULL, 0x000fe400078ff0ffULL,
0x000000020b0c7810ULL, 0x040fe20007ffe0ffULL, 0x00001f0b02087589ULL, 0x000e6200000e0000ULL,
0x000000080b117824ULL, 0x040fe200078e00ffULL, 0x000000030b0e7810ULL, 0x040fe20007ffe0ffULL,
0x000000080b137824ULL, 0x040fe200078e00ffULL, 0x00001f0d02077589ULL, 0x0004e200000e0000ULL,
0x000000080b157824ULL, 0x040fe200078e00ffULL, 0x000000040b0f7810ULL, 0x040fe20007ffe0ffULL,
0x000000080b107824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fc400078ee20cULL,
0xfffffff815157812ULL, 0x000fe400078ee20eULL, 0xfffffff810177812ULL, 0x040fe200078ee20fULL,
0x0000001013137824ULL, 0x100fe200078e0206ULL, 0x000000060b0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001015157824ULL, 0x100fe200078e0206ULL, 0xffffffff0b0e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001017177824ULL, 0x000fe200078e0206ULL, 0xfffffff8100f7812ULL, 0x000fe200078ee20bULL,
0x000000080d107824ULL, 0x000fc800078e00ffULL, 0x000000100f0f7824ULL, 0x000fe200078e0206ULL,
0x0000001a081a7220ULL, 0x042fe20000410000ULL, 0x0000003008037220ULL, 0x040fe20000410000ULL,
0x0000001f081f7220ULL, 0x040fe20000410000ULL, 0x0000002e082e7220ULL, 0x040fe20000410000ULL,
0x0000002b082b7220ULL, 0x040fe20000410000ULL, 0x0000003808387220ULL, 0x040fe20000410000ULL,
0x0000003708377220ULL, 0x040fe20000410000ULL, 0x0000003608367220ULL, 0x040fe20000410000ULL,
0x0000002708277220ULL, 0x040fe20000410000ULL, 0x00000025080a7220ULL, 0x040fe20000410000ULL,
0x0000002408247220ULL, 0x040fe20000410000ULL, 0x0000002308237220ULL, 0x040fe20000410000ULL,
0x0000001b081b7220ULL, 0x040fe20000410000ULL, 0x0000002108027220ULL, 0x044fe20000410000ULL,
0x0000001e081e7220ULL, 0x040fe20000410000ULL, 0x0000001d081d7220ULL, 0x000fe20000410000ULL,
0x000000010b087810ULL, 0x000fe20007ffe0ffULL, 0x0000002207227220ULL, 0x048fe20000410000ULL,
0x0000002f072f7220ULL, 0x040fe20000410000ULL, 0x0000002d072d7220ULL, 0x040fe20000410000ULL,
0x0000002c072c7220ULL, 0x040fe20000410000ULL, 0x0000002a072a7220ULL, 0x040fe20000410000ULL,
0x0000002907297220ULL, 0x040fe20000410000ULL, 0x0000002607267220ULL, 0x040fe20000410000ULL,
0x0000002807097220ULL, 0x040fe20000410000ULL, 0x0000003507357220ULL, 0x040fe20000410000ULL,
0x0000003407347220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x040fe20000410000ULL,
0x0000003207327220ULL, 0x040fe20000410000ULL, 0x0000002007207220ULL, 0x040fe20000410000ULL,
0x0000003107317220ULL, 0x040fe20000410000ULL, 0x0000001c071c7220ULL, 0x040fe20000410000ULL,
0x0000001907077220ULL, 0x000fe20000410000ULL, 0xfffffff811117812ULL, 0x000fe200078ee208ULL,
0x000000080b217824ULL, 0x040fe200078e00ffULL, 0x000000050b087810ULL, 0x040fe20007ffe0ffULL,
0x000000080b257824ULL, 0x040fe200078e00ffULL, 0x000000030b197819ULL, 0x000fe200000006ffULL,
0x0000001011117824ULL, 0x000fe200078e0206ULL, 0x000000270a0a723eULL, 0x000fc400000000ffULL,
0xfffffff8190b7812ULL, 0x000fe200078ee208ULL, 0x0000000400087824ULL, 0x000fe200078e00ffULL,
0xfffffff821197812ULL, 0x000fe400078ee20cULL, 0xfffffff825217812ULL, 0x000fe400078ee20eULL,
0xfffffff810257812ULL, 0x000fe200078ee20dULL, 0x000000100b0d7824ULL, 0x100fe200078e0206ULL,
0x0000000c08087812ULL, 0x000fe200078ec0ffULL, 0x0000001019197824ULL, 0x100fe200078e0206ULL,
0x0000001b0202723eULL, 0x000fe200000000ffULL, 0x00000010211b7824ULL, 0x100fe200078e0206ULL,
0x0000001a0303723eULL, 0x000fe200000000ffULL, 0x0000001025277824ULL, 0x000fe200078e0206ULL,
0x0000001f2e1f723eULL, 0x000fe200000000ffULL, 0x000000010f067824ULL, 0x000fe200078e0208ULL,
0x0000002b382b723eULL, 0x000fe200000000ffULL, 0x0000000108117824ULL, 0x000fe200078e0211ULL,
0x000000373636723eULL, 0x000fe200000000ffULL, 0x0000000108147824ULL, 0x040fe200078e0213ULL,
0x0000001c0707723eULL, 0x000fe200000000ffULL, 0x00000001080b7824ULL, 0x040fe200078e0215ULL,
0x000000242323723eULL, 0x000fe200000000ffULL, 0x0000000108217824ULL, 0x040fe200078e0217ULL,
0x0000000306007388ULL, 0x0003e20000000800ULL, 0x00000001081c7824ULL, 0x040fe200078e020dULL,
0x0000001e1d1d723eULL, 0x000fe200000000ffULL, 0x0000000108257824ULL, 0x040fe200078e0219ULL,
0x0000001f11007388ULL, 0x000fe20000000800ULL, 0x00000001081e7824ULL, 0x040fe200078e021bULL,
0x000000222f22723eULL, 0x000fe200000000ffULL, 0x0000000108277824ULL, 0x000fe200078e0227ULL,
0x0000002b14007388ULL, 0x000fe20000000800ULL, 0x0000002d2c2c723eULL, 0x000fe200000000ffULL,
0x000000016f067824ULL, 0x002fe200078e0200ULL, 0x0000002a2929723eULL, 0x000fe200000000ffULL,
0x000000360b007388ULL, 0x000fe20000000800ULL, 0x000000260909723eULL, 0x000fe200000000ffULL,
0x0000001006067824ULL, 0x000fe200078e0205ULL, 0x000000353434723eULL, 0x000fe200000000ffULL,
0x0000000a21007388ULL, 0x000fe20000000800ULL, 0x000000333232723eULL, 0x000fc400000000ffULL,
0x000000203120723eULL, 0x000fe200000000ffULL, 0x000000231c007388ULL, 0x000fe80000000800ULL,
0x0000000225007388ULL, 0x000fe80000000800ULL, 0x0000001d1e007388ULL, 0x000fe80000000800ULL,
0x0000002227007388ULL, 0x000fe80000000800ULL, 0x0004002c11007388ULL, 0x000fe80000000800ULL,
0x0004002914007388ULL, 0x000fe80000000800ULL, 0x000400090b007388ULL, 0x000fe80000000800ULL,
0x0004003421007388ULL, 0x000fe80000000800ULL, 0x000400321c007388ULL, 0x000fe80000000800ULL,
0x0004002025007388ULL, 0x000fe80000000800ULL, 0x000400071e007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000060c7984ULL, 0x000e680000000c00ULL,
0x0004000006147984ULL, 0x000ea80000000c00ULL, 0x0008000006107984ULL, 0x000ee80000000c00ULL,
0x000c000006187984ULL, 0x000f220000000c00ULL, 0x200000ff0f0f7230ULL, 0x002fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x004fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x000000130f0f7230ULL, 0x008fe40000000000ULL,
0x000000120e0e7230ULL, 0x000fe40000000000ULL, 0x000000110d0d7230ULL, 0x000fe40000000000ULL,
0x000000100c0c7230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x010fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000c06007388ULL, 0x000fe20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001406007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff0400720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x000fc80000011600ULL, 0x000000730700720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0x0000000107027824ULL, 0x000fe200078e0200ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x00005a0071717a19ULL, 0x000fe200000006ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x00000020000d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x0000000702037812ULL, 0x000fe400078ec0ffULL, 0x0000580000067ab9ULL, 0x000fe20000000800ULL,
0x00000007000c7812ULL, 0x000fc400078ec0ffULL, 0x0ffffff803027812ULL, 0x000fca00078ef800ULL,
0x0000001002037824ULL, 0x000fe400078e0205ULL, 0x0000001074027824ULL, 0x000fc600078e0207ULL,
0x0000000003087984ULL, 0x0004e40000000c00ULL, 0x0000000502047c12ULL, 0x000fe2000f8e30ffULL,
0x00000006040472a4ULL, 0x002fe2000f8e023fULL, 0x00005a00ff077a19ULL, 0x000fc60000011602ULL,
0x0000000171027824ULL, 0x000fe400078e0204ULL, 0x0000000478047c24ULL, 0x000fe4000f8e02ffULL,
0x0000007807077224ULL, 0x000fca00078e0202ULL, 0x0000000704077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff067224ULL, 0x000fe200000e06ffULL, 0x00005c0007027a11ULL, 0x000fc800078040ffULL,
0x00005d0007037a11ULL, 0x004fe200000f4406ULL, 0x000000086b077824ULL, 0x000fe200078e020cULL,
0x00000003ff067819ULL, 0x000fc6000001160dULL, 0x0000001007027825ULL, 0x000fe200078e0002ULL,
0x000000730600720cULL, 0x000fc80003f06070ULL, 0x0000000802007986ULL, 0x0083f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000060d027210ULL, 0x002fe20007ffe0ffULL,
0x0000001074067824ULL, 0x000fe200078e0206ULL, 0x00000040000f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x00005a00ff037a19ULL, 0x000fe40000011606ULL,
0x0ffffff802027812ULL, 0x000fca00078ef80dULL, 0x0000001002077824ULL, 0x000fe200078e0205ULL,
0x0000000506027c12ULL, 0x000fe4000f8e30ffULL, 0x000000070d067812ULL, 0x000fe400078ec0ffULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000000171027824ULL, 0x000fc800078e0202ULL,
0x0000007803037224ULL, 0x000fe400078e0202ULL, 0x000000086b077824ULL, 0x002fc600078e0206ULL,
0x0000000304037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fe400000f440cULL,
0x00000003ff0c7819ULL, 0x000fc6000001160fULL, 0x0000001007027825ULL, 0x000fe200078e0002ULL,
0x000000730c00720cULL, 0x000fc80003f06070ULL, 0x0000000802007986ULL, 0x0043f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010f027824ULL, 0x142fe200078e020cULL,
0x00000060000d7810ULL, 0x000fe20007ffe0ffULL, 0x00000010740c7824ULL, 0x000fe200078e020cULL,
0x000000070f007812ULL, 0x000fc400078ec0ffULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff037a19ULL, 0x000fe2000001160cULL, 0x000000086b077824ULL, 0x000fe200078e0200ULL,
0x0ffffff802027812ULL, 0x000fca00078ef80fULL, 0x0000001002067824ULL, 0x000fe200078e0205ULL,
0x000000050c027c12ULL, 0x000fc8000f8e30ffULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000000171027824ULL, 0x000fc800078e0202ULL, 0x0000007803037224ULL, 0x000fe200078e0202ULL,
0x00000003ff067819ULL, 0x002fc8000001160dULL, 0x0000000304037210ULL, 0x000fe20007f1e0ffULL,
0x000000010d007824ULL, 0x000fc800078e0206ULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x040fe400078040ffULL, 0x0000000700007812ULL, 0x000fe400078ec0ffULL,
0x00005d0003037a11ULL, 0x000fe400000f440cULL, 0x000000730600720cULL, 0x000fe40003f06070ULL,
0xfffffff800007812ULL, 0x000fe200078ef80dULL, 0x0000001007027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x0043ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001000057824ULL, 0x000fe400078e0205ULL, 0x0000001074067824ULL, 0x000fc600078e0206ULL,
0x0000000005087984ULL, 0x002e640000000c00ULL, 0x0000000506007c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff037a19ULL, 0x000fc60000011606ULL, 0x0000000171007824ULL, 0x000fc800078e0200ULL,
0x0000007803037224ULL, 0x000fe200078e0200ULL, 0x000000070d007812ULL, 0x000fc800078ec0ffULL,
0x0000000304037210ULL, 0x000fe20007f1e0ffULL, 0x000000086b6b7824ULL, 0x000fc800078e0200ULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fca00000f4404ULL, 0x000000106b027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000406027824ULL, 0x000fe400078e0207ULL, 0xffffffffff107424ULL, 0x000fc600078e00ffULL,
0x0000006c0200720cULL, 0x000fda0003f06070ULL, 0x00000002770d8824ULL, 0x000fc800078e00ffULL,
0x000068000d0d8a24ULL, 0x000fc800078e0202ULL, 0x000064000d0c8625ULL, 0x000fe200078e0000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000080c108981ULL, 0x000ea2000c1e1900ULL,
0x0000000106007810ULL, 0x000fe20007ffe0ffULL, 0x000000400e747824ULL, 0x000fe400078e00ffULL,
0x00000100ff0b7424ULL, 0x000fe200078e00ffULL, 0x000000650000720cULL, 0x000fe20003f06070ULL,
0x01360000ff087f8cULL, 0x000ee2000c80043fULL, 0x0000004007757824ULL, 0x000fe400078e00ffULL,
0x0000004071007824ULL, 0x000fc400078e00ffULL, 0x00000074100a7224ULL, 0x004fc800078e02ffULL,
0x000062000a0a7625ULL, 0x000fc600078e000bULL, 0x0000061000008947ULL, 0x000fea0003800000ULL,
0x00000002ff227819ULL, 0x008fe20000011605ULL, 0x0000010006047824ULL, 0x002fe200078e0275ULL,
0x0000000505187211ULL, 0x000fe400078fe8ffULL, 0x00001000071a7811ULL, 0x000fe200078e68ffULL,
0x0000004071717824ULL, 0x000fe200078e0222ULL, 0x0000000461117217ULL, 0x000fe40007800000ULL,
0x0000000318187812ULL, 0x000fe200078ec0ffULL, 0x00000100710c7825ULL, 0x040fe200078e00ffULL,
0x00000008710e7810ULL, 0x000fc40007ffe0ffULL, 0x0000001071127810ULL, 0x000fe20007ffe0ffULL,
0x0000000111117824ULL, 0x000fe200078e0a04ULL, 0x000000300c197812ULL, 0x100fe200078ef803ULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000822047810ULL, 0x000fe40007ffe0ffULL,
0x000000190a147210ULL, 0x000fe20007f1e0ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000300e177812ULL, 0x000fe400078ef803ULL, 0x00000018710e7810ULL, 0x000fc40007ffe0ffULL,
0x0000003012157812ULL, 0x000fe400078ef803ULL, 0x000000170a167210ULL, 0x040fe40007f3e0ffULL,
0x000000150a0c7210ULL, 0x000fe20007f5e0ffULL, 0x000000010b157824ULL, 0x000fe200000e060dULL,
0x0000002071127810ULL, 0x000fe20007ffe0ffULL, 0x000000010b177824ULL, 0x040fe200008e060fULL,
0x000000110400720cULL, 0x040fe20003f26070ULL, 0x000000010b0d7824ULL, 0x000fe200010e0613ULL,
0x00000002041d7819ULL, 0x000fe200000006ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0ffffffc18057812ULL, 0x000fc400078ef805ULL, 0x000000112200720cULL, 0x000fe20003f06070ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x000000300e1b7812ULL, 0x100fe400078ef803ULL,
0x0000001022247810ULL, 0x000fe40007ffe0ffULL, 0x0000003012197812ULL, 0x000fe400078ef803ULL,
0x0000001b0a047210ULL, 0x040fe40007f5e0ffULL, 0x000000190a0e7210ULL, 0x000fe20007f7e0ffULL,
0x0000001005197824ULL, 0x000fe200078e021aULL, 0x0000002871127810ULL, 0x000fe20007ffe0ffULL,
0x000000010b057824ULL, 0x000fe200010e060fULL, 0xfffffffc1d1b7812ULL, 0x000fe200078ee218ULL,
0x000000010b0f7824ULL, 0x000fe200018e0613ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014197faeULL, 0x0003e2000c101c48ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000001822267810ULL, 0x000fc40007ffe0ffULL, 0x00000020221c7810ULL, 0x000fe20007ffe0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e021aULL, 0x00000030121d7812ULL, 0x000fe400078ef803ULL,
0x0000003071127810ULL, 0x040fe40007ffe0ffULL, 0x00000000161b7faeULL, 0x0005e2000c901c48ULL,
0x00000028221e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000426197824ULL, 0x002fe200078e00ffULL,
0x0000003022207810ULL, 0x040fe40007ffe0ffULL, 0x0000003822227810ULL, 0x000fe20007ffe0ffULL,
0x000000041e1f7824ULL, 0x000fe200078e00ffULL, 0x0000003871147810ULL, 0x000fe20007ffe0ffULL,
0x0000000420217824ULL, 0x000fe200078e00ffULL, 0x000000112400720cULL, 0x080fe20003fa6070ULL,
0x0000000422237824ULL, 0x000fe200078e00ffULL, 0x000000112600720cULL, 0x000fe20003f86070ULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x0000001d0a167210ULL, 0x004fc40007fde0ffULL,
0x000000111c00720cULL, 0x0c0fe20003f66070ULL, 0x000000041c1b7824ULL, 0x000fe200078e00ffULL,
0x000000111e00720cULL, 0x080fe20003f46070ULL, 0x000000010b177824ULL, 0x000fe200030e0613ULL,
0x000000112000720cULL, 0x080fe20003f26070ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000112200720cULL, 0x000fe40003f06070ULL, 0xfffffffc19197812ULL, 0x000fe200078ee218ULL,
0x0000000424117824ULL, 0x000fe200078e00ffULL, 0x00000030121d7812ULL, 0x000fc400078ef803ULL,
0x0000003014037812ULL, 0x000fe200078ef803ULL, 0x0000001019197824ULL, 0x000fe200078e021aULL,
0x0000001d0a127210ULL, 0x040fe40007fde0ffULL, 0xfffffffc11117812ULL, 0x100fe400078ee218ULL,
0xfffffffc1b1b7812ULL, 0x100fe200078ee218ULL, 0x000000010b137824ULL, 0x000fe200030e0613ULL,
0xfffffffc1f1d7812ULL, 0x000fe200078ee218ULL, 0x0000001011117824ULL, 0x000fe200078e021aULL,
0xfffffffc211f7812ULL, 0x000fe200078ee218ULL, 0x000000101b1b7824ULL, 0x000fe200078e021aULL,
0xfffffffc23217812ULL, 0x000fe200078ee218ULL, 0x000000101d1d7824ULL, 0x100fe200078e021aULL,
0x000000030a0a7210ULL, 0x000fe20007fde0ffULL, 0x000000101f1f7824ULL, 0x100fe200078e021aULL,
0x000000000c117faeULL, 0x0003e2000e901c48ULL, 0x0000001021217824ULL, 0x000fc400078e021aULL,
0x000000010b0b7824ULL, 0x000fe200030e0615ULL, 0x0000000004197faeULL, 0x0003e8000e101c48ULL,
0x000000000e1b7faeULL, 0x0003e8000d901c48ULL, 0x00000000161d7faeULL, 0x0003e8000d101c48ULL,
0x00000000121f7faeULL, 0x0003e8000c901c48ULL, 0x000000000a217faeULL, 0x0003e2000c101c48ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x0000000805137811ULL, 0x048fe400078ff0ffULL,
0x0000000505047211ULL, 0x002fc400078fe8ffULL, 0x0000001805117811ULL, 0x000fe200078ff0ffULL,
0x0000000413157824ULL, 0x000fe200078e00ffULL, 0x00000000050c7211ULL, 0x040fe200078ff0ffULL,
0x00000001000e7824ULL, 0x000fe200078e0213ULL, 0x00000010050f7811ULL, 0x000fe200078ff0ffULL,
0x00000004111b7824ULL, 0x000fe200078e00ffULL, 0x0000002005177811ULL, 0x040fe200078ff0ffULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000002805237811ULL, 0x040fe400078ff0ffULL,
0x0000003005277811ULL, 0x000fe200078ff0ffULL, 0x000000040f197824ULL, 0x000fe200078e00ffULL,
0x00000038052b7811ULL, 0x000fe200078ff0ffULL, 0x0000000100127824ULL, 0x000fe200078e020fULL,
0x0000000304047812ULL, 0x000fe200078ec0ffULL, 0x00000004171d7824ULL, 0x000fe200078e00ffULL,
0x00001000072d7811ULL, 0x000fe200078e68ffULL, 0x00000004231f7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc041c7812ULL, 0x000fe200078ef805ULL, 0x0000000427217824ULL, 0x000fe200078e00ffULL,
0xfffffffc15057812ULL, 0x100fe200078ee204ULL, 0x000000042b257824ULL, 0x000fe200078e00ffULL,
0xfffffffc1b157812ULL, 0x000fe200078ee204ULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000000300c1b7812ULL, 0x000fc400078ef803ULL, 0xfffffffc19147812ULL, 0x100fe200078ee204ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0xfffffffc1d167812ULL, 0x100fe400078ee204ULL,
0xfffffffc1f187812ULL, 0x100fe200078ee204ULL, 0x00000001000c7824ULL, 0x000fe200078e0211ULL,
0xfffffffc21197812ULL, 0x100fe200078ee204ULL, 0x000000101c2f7824ULL, 0x100fe200078e022dULL,
0xfffffffc251a7812ULL, 0x000fe200078ee204ULL, 0x00000010141d7824ULL, 0x100fe200078e022dULL,
0x0000002d05117211ULL, 0x000fe200078e20ffULL, 0x00000010151f7824ULL, 0x100fe200078e022dULL,
0x0000001b0a047210ULL, 0x000fe20007f1e0ffULL, 0x0000001016217824ULL, 0x000fe200078e022dULL,
0x000000300e057812ULL, 0x000fe200078ef803ULL, 0x0000001018257824ULL, 0x000fe200078e022dULL,
0x00000030121b7812ULL, 0x000fe200078ef803ULL, 0x0000001019297824ULL, 0x100fe200078e022dULL,
0x000000050a187210ULL, 0x000fe20007f3e0ffULL, 0x000000101a2d7824ULL, 0x000fe200078e022dULL,
0x0000001b0a1a7210ULL, 0x000fe20007f5e0ffULL, 0x000000010b057824ULL, 0x000fc400000e060dULL,
0x000001000c0c7825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000042f7faeULL, 0x0003e2000b901c48ULL, 0x000000010b1b7824ULL, 0x040fe200010e0613ULL,
0x000000300c137812ULL, 0x000fe200078ef803ULL, 0x00000001000e7824ULL, 0x040fe400078e0217ULL,
0x0000000100127824ULL, 0x000fe200078e0223ULL, 0x000000130a0c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000100147824ULL, 0x040fe400078e0227ULL, 0x000000010b197824ULL, 0x000fe400008e060fULL,
0x0000000100167824ULL, 0x000fc400078e022bULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000018117faeULL, 0x0003e6000b901c48ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x000000300e2b7812ULL, 0x100fe200078ef803ULL, 0x000000001a1d7faeULL, 0x0003e4000b901c48ULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x0000003012277812ULL, 0x000fc600078ef803ULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x0000003014237812ULL, 0x000fe400078ef803ULL,
0x000000270a127210ULL, 0x000fe20007f3e0ffULL, 0x000000010b0d7824ULL, 0x040fe200000e060dULL,
0x0000003016037812ULL, 0x000fe400078ef803ULL, 0x0000002b0a0e7210ULL, 0x040fe20007f1e0ffULL,
0x000000010b137824ULL, 0x040fe200008e0613ULL, 0x000000230a147210ULL, 0x040fe20007f5e0ffULL,
0x000000000c1f7faeULL, 0x0003e2000b901c48ULL, 0x000000030a0a7210ULL, 0x000fe20007f7e0ffULL,
0x000000010b0f7824ULL, 0x000fc400000e060fULL, 0x000000010b157824ULL, 0x040fe400010e0615ULL,
0x000000010b0b7824ULL, 0x000fe200018e0617ULL, 0x000000000e217faeULL, 0x0003e8000b901c48ULL,
0x0000000012257faeULL, 0x0003e8000b901c48ULL, 0x0000000014297faeULL, 0x0003e8000b901c48ULL,
0x000000000a2d7faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000047805ULL, 0x002fc40000015200ULL, 0x01360400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fc40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a040a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e05ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001140bULL, 0x0000000a03037211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000203037819ULL, 0x000fc8000000120aULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01360400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000650600720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000006b7919ULL, 0x000e620000000000ULL,
0x00005800ff6d7624ULL, 0x000fe200078e00ffULL, 0x8000580061707a10ULL, 0x000fe20007ffe0ffULL,
0x0000680077777a24ULL, 0x000fe200078e02ffULL, 0x0001368807727811ULL, 0x040fe200078e18ffULL,
0x0000002007737824ULL, 0x000fe200078e00ffULL, 0x0000001f6d037810ULL, 0x040fe40007ffe0ffULL,
0xffffffff6d717810ULL, 0x000fe40007ffe0ffULL, 0x00000004ff037819ULL, 0x000fc40000011603ULL,
0x000000096d6d7810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff707819ULL, 0x000fe40000011670ULL,
0x0ffffffe036e7812ULL, 0x000fc400078ec0ffULL, 0x0000000106047810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff767424ULL, 0x000fe200078e00ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x00000010744d7224ULL, 0x000fe200078e02ffULL, 0x000000650400720cULL, 0x000fe20003f06070ULL,
0x0000010006127824ULL, 0x000fe400078e0275ULL, 0x000062004d4c7625ULL, 0x000fd400078e0076ULL,
0x0000064000008947ULL, 0x008fea0003800000ULL, 0x00000002ff1a7819ULL, 0x002fe2000001166bULL,
0x000000106b117824ULL, 0x040fe200078e00ffULL, 0x0ffffffc6b137812ULL, 0x000fe400078ec0ffULL,
0x000000201a217810ULL, 0x000fe20007ffe0ffULL, 0x0000000100047824ULL, 0x000fe200078e021aULL,
0x0000003011117812ULL, 0x000fe400078ec0ffULL, 0x000000081a1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0x00000021000e7210ULL, 0x000fc40007ffe0ffULL,
0x000000101a1e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000100087824ULL, 0x000fe200078e021dULL,
0x00000040111b7812ULL, 0x000fe200078efcffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000000181a207810ULL, 0x000fe40007ffe0ffULL, 0x0000001b04157212ULL, 0x080fe200078efcffULL,
0x00000001000a7824ULL, 0x000fe200078e021eULL, 0x0000001b0e037212ULL, 0x000fe200078efcffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x000000154c147210ULL, 0x000fc40007f3e0ffULL,
0x0000200007107811ULL, 0x000fe200078e68ffULL, 0x00000001000c7824ULL, 0x000fe200078e0220ULL,
0x0000001b08177212ULL, 0x000fe200078efcffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x000000034c087210ULL, 0x000fe40007f7e0ffULL, 0x0000001261037217ULL, 0x000fe20007800000ULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x0000001b0a197212ULL, 0x000fe400078efcffULL,
0x0000006b6b0a7211ULL, 0x000fe200078fe8ffULL, 0x000000014d157824ULL, 0x000fe200008e0605ULL,
0x000000174c167210ULL, 0x000fe20007f3e0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a12ULL,
0x0000001b0c057212ULL, 0x000fe200078efcffULL, 0x000000041e1f7824ULL, 0x000fe200078e00ffULL,
0x000000281a0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000014d177824ULL, 0x040fe200008e0609ULL,
0x000000194c187210ULL, 0x040fe20007f5e0ffULL, 0x000000014d097824ULL, 0x000fe200018e060fULL,
0x000000054c047210ULL, 0x000fc40007f3e0ffULL, 0x000000030a1c7812ULL, 0x000fe200078ec0ffULL,
0x00000001000a7824ULL, 0x000fe200078e020cULL, 0x000000031e00720cULL, 0x080fe20003f66070ULL,
0x000000014d197824ULL, 0x000fe200010e060bULL, 0x000000031d00720cULL, 0x080fe20003f46070ULL,
0x000000014d057824ULL, 0x000fe200008e060dULL, 0x000000031a00720cULL, 0x000fe20003f26070ULL,
0x000000041d1d7824ULL, 0x000fe200078e00ffULL, 0x000000131c0d7212ULL, 0x000fe200078efcffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffffc1f1f7812ULL, 0x000fc400078ee21cULL,
0xfffffffc1d1d7812ULL, 0x000fe200078ee21cULL, 0x000000100d0d7824ULL, 0x100fe200078e0210ULL,
0x0000001b0a0f7212ULL, 0x000fe200078efcffULL, 0x000000101f1f7824ULL, 0x100fe200078e0210ULL,
0x000000301a1e7810ULL, 0x000fe20007ffe0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e0210ULL,
0x0000000f4c0e7210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140d7faeULL, 0x0003e2000c901c48ULL, 0x000000381a1a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001000a7824ULL, 0x000fe200078e021eULL, 0x000000032000720cULL, 0x080fe20003fa6070ULL,
0x00000000161d7faeULL, 0x0005e2000d101c48ULL, 0x000000014d0f7824ULL, 0x000fe200030e060bULL,
0x000000032100720cULL, 0x080fe20003f86070ULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x00000000181f7faeULL, 0x0007e2000d901c48ULL, 0x000000030c00720cULL, 0x000fc40003f66070ULL,
0x000000031e00720cULL, 0x080fe20003f46070ULL, 0x0000000420157824ULL, 0x002fe200078e00ffULL,
0x000000031a00720cULL, 0x000fe40003f26070ULL, 0x0000001b0a037212ULL, 0x000fe200078efcffULL,
0x0000000421177824ULL, 0x004fe200078e00ffULL, 0xfffffffc15157812ULL, 0x100fe200078ee21cULL,
0x000000041e1d7824ULL, 0x000fe200078e00ffULL, 0x000000034c0a7210ULL, 0x000fe20007fde0ffULL,
0x000000040c197824ULL, 0x008fe200078e00ffULL, 0xfffffffc17177812ULL, 0x000fe200078ee21cULL,
0x00000001000c7824ULL, 0x000fe200078e021aULL, 0xfffffffc1d1d7812ULL, 0x100fe200078ee21cULL,
0x000000041a1f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc19197812ULL, 0x000fe200078ee21cULL,
0x000001000c0c7825ULL, 0x000fc600078e00ffULL, 0xfffffffc1f1f7812ULL, 0x000fe200078ee21cULL,
0x000000014d0b7824ULL, 0x000fe200030e060bULL, 0x0000001b0c1b7212ULL, 0x000fe200078efcffULL,
0x0000001015037824ULL, 0x100fe400078e0210ULL, 0x0000001017157824ULL, 0x100fe200078e0210ULL,
0x0000001b4c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001019177824ULL, 0x100fe200078e0210ULL,
0x0000000004037faeULL, 0x0003e2000e901c48ULL, 0x000000101d197824ULL, 0x100fe400078e0210ULL,
0x000000101f1b7824ULL, 0x000fe200078e0210ULL, 0x0000000008157faeULL, 0x0003e2000e101c48ULL,
0x000000014d0d7824ULL, 0x000fc600030e060dULL, 0x000000000e177faeULL, 0x0003e8000d901c48ULL,
0x000000000a197faeULL, 0x0003e8000d101c48ULL, 0x000000000c1b7faeULL, 0x0003e2000c901c48ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000006b6b037211ULL, 0x042fe200078fe8ffULL,
0x000000106b117824ULL, 0x040fe200078e00ffULL, 0x000000086b057811ULL, 0x000fc400078ff0ffULL,
0x000000106b0b7811ULL, 0x040fe400078ff0ffULL, 0x000000186b0d7811ULL, 0x000fe200078ff0ffULL,
0x0000000100097824ULL, 0x040fe200078e0205ULL, 0x0000000303087812ULL, 0x000fe200078ec0ffULL,
0x0000000405037824ULL, 0x000fe200078e00ffULL, 0x0ffffffc6b137812ULL, 0x040fe200078ec0ffULL,
0x00000001000e7824ULL, 0x040fe200078e020dULL, 0x000000206b177811ULL, 0x000fe200078ff0ffULL,
0x000000040d1d7824ULL, 0x000fe200078e00ffULL, 0x000000286b197811ULL, 0x000fe200078ff0ffULL,
0x000000040b1b7824ULL, 0x000fe200078e00ffULL, 0x000000306b297811ULL, 0x000fe200078ff0ffULL,
0x00000004171f7824ULL, 0x000fe200078e00ffULL, 0x000000386b2b7811ULL, 0x000fe200078ff0ffULL,
0x0000000419217824ULL, 0x000fe200078e00ffULL, 0x0000000b000a7210ULL, 0x000fe20007ffe0ffULL,
0x0000000429237824ULL, 0x000fe200078e00ffULL, 0x0000003011117812ULL, 0x000fe200078ec0ffULL,
0x000000042b257824ULL, 0x000fe200078e00ffULL, 0xfffffffc030d7812ULL, 0x000fe200078ee208ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x00002000070c7811ULL, 0x000fc400078e68ffULL,
0x0000001308037212ULL, 0x000fe200078efcffULL, 0x0000000100147824ULL, 0x040fe200078e0219ULL,
0x000000006b047211ULL, 0x000fe200078ff0ffULL, 0x0000000100167824ULL, 0x000fe200078e0229ULL,
0x0000004011277812ULL, 0x000fe200078efcffULL, 0x00000010032f7824ULL, 0x000fe200078e020cULL,
0xfffffffc1b1b7812ULL, 0x100fe200078ee208ULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0xfffffffc1d1d7812ULL, 0x100fe400078ee208ULL, 0xfffffffc1f1f7812ULL, 0x000fe200078ee208ULL,
0x000000100d037824ULL, 0x000fe200078e020cULL, 0xfffffffc21217812ULL, 0x000fe200078ee208ULL,
0x000000101b1b7824ULL, 0x000fe200078e020cULL, 0xfffffffc23237812ULL, 0x000fe200078ee208ULL,
0x000000101d1d7824ULL, 0x000fe200078e020cULL, 0xfffffffc25257812ULL, 0x000fe200078ee208ULL,
0x0000010009087825ULL, 0x000fe200078e00ffULL, 0x000000270a0d7212ULL, 0x000fc400078efcffULL,
0x0000002704157212ULL, 0x000fe200078efcffULL, 0x000000101f1f7824ULL, 0x100fe200078e020cULL,
0x0000000d4c0a7210ULL, 0x040fe20007f7e0ffULL, 0x0000001021217824ULL, 0x100fe200078e020cULL,
0x000000154c047210ULL, 0x000fe20007f3e0ffULL, 0x0000001023237824ULL, 0x100fe200078e020cULL,
0x00000027080f7212ULL, 0x000fe200078efcffULL, 0x0000001025257824ULL, 0x000fe400078e020cULL,
0x000001000e0c7825ULL, 0x000fe200078e00ffULL, 0x0000000f4c087210ULL, 0x000fc60007f5e0ffULL,
0x00000001000e7824ULL, 0x000fe200078e0217ULL, 0x000000270c157212ULL, 0x000fe200078efcffULL,
0x0000000105057824ULL, 0x000fe400008e064dULL, 0x0000000100187824ULL, 0x000fe200078e022bULL,
0x000000154c0c7210ULL, 0x000fe20007f3e0ffULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000042f7faeULL, 0x0003e6000b901c48ULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x000000270e2d7212ULL, 0x000fc600078efcffULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x00000027142b7212ULL, 0x000fc600078efcffULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x0000002716297212ULL, 0x000fc600078efcffULL,
0x000000010d0d7824ULL, 0x100fe200008e064dULL, 0x0000002718277212ULL, 0x000fe200078efcffULL,
0x0000000109097824ULL, 0x100fe200010e064dULL, 0x0000002d4c0e7210ULL, 0x040fe20007f3e0ffULL,
0x000000010b0b7824ULL, 0x100fe200018e064dULL, 0x0000002b4c147210ULL, 0x040fe40007f5e0ffULL,
0x000000294c167210ULL, 0x040fe20007f7e0ffULL, 0x000000010f0f7824ULL, 0x100fe200008e064dULL,
0x000000274c187210ULL, 0x000fe20007f9e0ffULL, 0x0000000115157824ULL, 0x100fe200010e064dULL,
0x0000000008037faeULL, 0x0003e2000b901c48ULL, 0x0000000117177824ULL, 0x000fc400018e064dULL,
0x0000000119197824ULL, 0x000fe200020e064dULL, 0x000000000a1b7faeULL, 0x0003e8000b901c48ULL,
0x000000000c1d7faeULL, 0x0003e8000b901c48ULL, 0x000000000e1f7faeULL, 0x0003e8000b901c48ULL,
0x0000000014217faeULL, 0x0003e8000b901c48ULL, 0x0000000016237faeULL, 0x0003e8000b901c48ULL,
0x0000000018257faeULL, 0x0003e4000b901c48ULL, 0x00000004ff0e7819ULL, 0x102fe2000001166bULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000076b047812ULL, 0x000fe200078ec0ffULL,
0x0000200007107824ULL, 0x000fe200078e00ffULL, 0x00000003ff4f7819ULL, 0x100fe2000001166bULL,
0x000000080e057824ULL, 0x000fe200078e00ffULL, 0x00000008040f7812ULL, 0x000fc400078ef86bULL,
0x00001000100d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff805057812ULL, 0x000fe200078ee204ULL,
0x000000010e0e7824ULL, 0x000fe200078e020fULL, 0x000000014f047812ULL, 0x000fe200078ec0ffULL,
0x000000100f237824ULL, 0x000fe200078e00ffULL, 0x00000010051d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000405097824ULL, 0x040fe200078e00ffULL, 0x0000000405087211ULL, 0x0c0fe200078ff8ffULL,
0x0000000405257824ULL, 0x040fe200078e00ffULL, 0x00000020051f7810ULL, 0x000fe20007ffe0ffULL,
0x000000041d0a7824ULL, 0x000fe200078e00ffULL, 0x0000003005217810ULL, 0x000fe20007ffe0ffULL,
0x000000041d207824ULL, 0x000fe200078e00ffULL, 0xfffffffc090c7812ULL, 0x000fe200078ee208ULL,
0x000000041f097824ULL, 0x000fe200078e00ffULL, 0x000000041d057211ULL, 0x080fe200078ff8ffULL,
0x0000000421157824ULL, 0x000fe200078e00ffULL, 0x000000040f037819ULL, 0x000fe200000006ffULL,
0x000000100c4e7824ULL, 0x000fe200078e020dULL, 0x000000041f1c7211ULL, 0x000fe200078ff8ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000421047211ULL, 0x000fe200078ff8ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0xfffffffc0a0b7812ULL, 0x000fe200078ee205ULL,
0x000000004e34783bULL, 0x000fe20000000200ULL, 0xfffffff003037812ULL, 0x000fe200078ee20eULL,
0x000000041f1f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc090a7812ULL, 0x000fe200078ee21cULL,
0x000000100b607824ULL, 0x100fe200078e020dULL, 0xfffffffc15097812ULL, 0x000fe200078ee204ULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0x0000000205057810ULL, 0x000fe20007ffe0ffULL,
0x000000100a627824ULL, 0x100fe200078e020dULL, 0x00000000603c783bULL, 0x000fe20000000200ULL,
0x0000001009637824ULL, 0x000fe200078e020dULL, 0xfffffffc20057812ULL, 0x000fe200078ee205ULL,
0x0000000421207824ULL, 0x000fe200078e00ffULL, 0x000000000314783bULL, 0x0002a20000000200ULL,
0x000000020e1e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000208087810ULL, 0x000fe20007ffe0ffULL,
0x000000006244783bULL, 0x000ee20000000200ULL, 0x000000021c1c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001005687824ULL, 0x000fe200078e020dULL, 0xfffffff0231e7812ULL, 0x000fe200078ee21eULL,
0x000000006318783bULL, 0x000f220000000200ULL, 0x0000000204037810ULL, 0x002fe40007ffe0ffULL,
0xfffffffc25087812ULL, 0x000fe200078ee208ULL, 0x000000101e1e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1f047812ULL, 0x000fe200078ee21cULL, 0x000000006824783bULL, 0x000fe20000000200ULL,
0xfffffffc20037812ULL, 0x000fe200078ee203ULL, 0x0000001008647824ULL, 0x000fc400078e020dULL,
0x0000001004697824ULL, 0x100fe200078e020dULL, 0x000000001e1c783bULL, 0x000fe20000000200ULL,
0x00000010036a7824ULL, 0x000fc600078e020dULL, 0x000000006420783bULL, 0x000e680000000200ULL,
0x000000006928783bULL, 0x000e680000000200ULL, 0x000000006a2c783bULL, 0x000e620000000200ULL,
0x000000341430723cULL, 0x044f7000000018ffULL, 0x0000003c1438723cULL, 0x040ff000000018ffULL,
0x000000441440723cULL, 0x048ff000000018ffULL, 0x000000361434723cULL, 0x040f7000000018ffULL,
0x0000003e143c723cULL, 0x040f7000000018ffULL, 0x000000461444723cULL, 0x040f7000000018ffULL,
0x000000181448723cULL, 0x050f7000000018ffULL, 0x0000001a1414723cULL, 0x000f7000000018ffULL,
0x000000201c30723cULL, 0x062b700000001830ULL, 0x000000221c34723cULL, 0x040b700000001834ULL,
0x000000241c38723cULL, 0x040b700000001838ULL, 0x000000261c3c723cULL, 0x040b70000000183cULL,
0x000000281c40723cULL, 0x040b700000001840ULL, 0x0000002a1c44723cULL, 0x040b700000001844ULL,
0x0000002c1c48723cULL, 0x040b700000001848ULL, 0x0000002e1c1c723cULL, 0x000b620000001814ULL,
0x0000059000008947ULL, 0x000fce0003800000ULL, 0x00000002ff2d7819ULL, 0x120fe2000001166bULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x0000008011187812ULL, 0x000fe200078efcffULL,
0x000000014f4f7824ULL, 0x000fe200078e026bULL, 0x000000082d577810ULL, 0x040fe20007ffe0ffULL,
0x0000000100237824ULL, 0x000fe200078e022dULL, 0x000000102d557810ULL, 0x000fc40007ffe0ffULL,
0x000000202d517810ULL, 0x000fe20007ffe0ffULL, 0x0000000100217824ULL, 0x040fe200078e0257ULL,
0x0000001261157217ULL, 0x000fe20007800000ULL, 0x00000001001b7824ULL, 0x040fe200078e0255ULL,
0x000000282d2f7810ULL, 0x000fe20007ffe0ffULL, 0x0000010021207825ULL, 0x000fe200078e0018ULL,
0x000000182d537810ULL, 0x040fe40007ffe0ffULL, 0x000000302d2b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100277824ULL, 0x000fe200078e0251ULL, 0x000000204c207210ULL, 0x000fe20007f7e0ffULL,
0x00000001152a7824ULL, 0x000fc400078e0a12ULL, 0x000001001b1a7825ULL, 0x100fe200078e0018ULL,
0x000000214d217210ULL, 0x000fe40001ffe4ffULL, 0x0000002a2d00720cULL, 0x000fe20003f26070ULL,
0x0000010027267825ULL, 0x000fe200078e0018ULL, 0x0000001a4c1a7210ULL, 0x000fe40007f9e0ffULL,
0x000000382d2d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000100157824ULL, 0x000fe200078e022fULL,
0x000000264c267210ULL, 0x000fe20007f7e0ffULL, 0x0000000100257824ULL, 0x000fe200078e0253ULL,
0x0000002a2b00720cULL, 0x080fe20003fa6070ULL, 0x0000010015147825ULL, 0x000fe200078e0018ULL,
0x0000002a2d00720cULL, 0x000fc60003fc6070ULL, 0x0000000100177824ULL, 0x000fe400078e022bULL,
0x000000014d1b7824ULL, 0x000fe200020e061bULL, 0x000000144c287210ULL, 0x000fe20007f9e0ffULL,
0x0000000100297824ULL, 0x000fe200078e022dULL, 0x000000034f147812ULL, 0x000fe200078ec0ffULL,
0x000000014d277824ULL, 0x000fe200018e0627ULL, 0x0000002a5700720cULL, 0x000fe20003f66070ULL,
0x0000010023227825ULL, 0x000fe200078e0018ULL, 0x0000001314137212ULL, 0x000fc600078efcffULL,
0x0000000457577824ULL, 0x000fe200078e00ffULL, 0x000000224c227210ULL, 0x000fe20007f5e0ffULL,
0x0000010025247825ULL, 0x000fc600078e0018ULL, 0xfffffffc572c7812ULL, 0x000fe200078ee214ULL,
0x0000010017167825ULL, 0x000fc800078e0018ULL, 0x0000010029187825ULL, 0x000fc800078e0018ULL,
0x000000014d297824ULL, 0x000fe200020e0615ULL, 0x0000002a5500720cULL, 0x040fe20003f86070ULL,
0x0000000455557824ULL, 0x000fe400078e00ffULL, 0x000000014d237824ULL, 0x000fe200010e0623ULL,
0x000000244c247210ULL, 0x000fe20007f5e0ffULL, 0x0000001013157824ULL, 0x100fe200078e020dULL,
0xfffffffc552e7812ULL, 0x100fe200078ee214ULL, 0x000000102c4f7824ULL, 0x000fe400078e020dULL,
0x000000014d257824ULL, 0x000fe200010e0625ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022157faeULL, 0x0003e2000c901c48ULL, 0x000000102e557824ULL, 0x000fe200078e020dULL,
0x0000002a5300720cULL, 0x0c0fe20003f26070ULL, 0x0000000453537824ULL, 0x000fe200078e00ffULL,
0x00000000204f7faeULL, 0x0005e2000d901c48ULL, 0x0000002a5100720cULL, 0x040fe20003f66070ULL,
0x0000000451517824ULL, 0x000fe200078e00ffULL, 0x000000164c167210ULL, 0x000fe20007f5e0ffULL,
0x000000001a557faeULL, 0x0007e2000e101c48ULL, 0x0000002a2f00720cULL, 0x040fe20003f86070ULL,
0x000000042f2f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc532c7812ULL, 0x000fe200078ee214ULL,
0x000000042b2b7824ULL, 0x000fc400078e00ffULL, 0x000000042d2d7824ULL, 0x000fe400078e00ffULL,
0x000000102c237824ULL, 0x002fe200078e020dULL, 0xfffffffc2f207812ULL, 0x104fe200078ee214ULL,
0x000000014d177824ULL, 0x000fe200010e0617ULL, 0x000000184c187210ULL, 0x000fe40007f5e0ffULL,
0xfffffffc511a7812ULL, 0x108fe200078ee214ULL, 0x0000000024237faeULL, 0x0003e2000c901c48ULL,
0xfffffffc2d227812ULL, 0x000fe200078ee214ULL, 0x0000001020217824ULL, 0x000fc400078e020dULL,
0x000000101a1b7824ULL, 0x000fe200078e020dULL, 0xfffffffc2b1a7812ULL, 0x000fe200078ee214ULL,
0x000000014d197824ULL, 0x000fc600010e0619ULL, 0x00000000261b7faeULL, 0x0005e2000d901c48ULL,
0x000000101a237824ULL, 0x002fc600078e020dULL, 0x0000000028217faeULL, 0x0005e2000e101c48ULL,
0x0000001022257824ULL, 0x000fc600078e020dULL, 0x0000000016237faeULL, 0x0005e8000e901c48ULL,
0x0000000018257faeULL, 0x0005e2000f101c48ULL, 0x000004d000007947ULL, 0x000fea0003800000ULL,
0x000000086b577811ULL, 0x000fe200078ff0ffULL, 0x000000ffff297224ULL, 0x020fe200078e00ffULL,
0x0000008011287812ULL, 0x000fe200078efcffULL, 0x000000014f4f7824ULL, 0x000fe200078e026bULL,
0x000000206b517811ULL, 0x040fe200078ff0ffULL, 0x0000000100197824ULL, 0x000fe200078e0257ULL,
0x000000306b2b7811ULL, 0x000fe200078ff0ffULL, 0x0000000457577824ULL, 0x000fe200078e00ffULL,
0x000000006b177211ULL, 0x000fe200078ff0ffULL, 0x0000010019187825ULL, 0x000fe200078e0028ULL,
0x000000186b537811ULL, 0x000fc400078ff0ffULL, 0x000000106b557811ULL, 0x040fe200078ff0ffULL,
0x0000000100237824ULL, 0x000fe200078e0251ULL, 0x000000184c187210ULL, 0x000fe20007f5e0ffULL,
0x0000000100157824ULL, 0x000fe200078e022bULL, 0x000000286b2f7811ULL, 0x000fe200078ff0ffULL,
0x0000010023227825ULL, 0x000fe200078e0028ULL, 0x000000386b2d7811ULL, 0x000fc600078ff0ffULL,
0x000000014d197824ULL, 0x000fe200010e0619ULL, 0x000000224c227210ULL, 0x000fe20007f5e0ffULL,
0x0000010015147825ULL, 0x000fc800078e0028ULL, 0x000000014d237824ULL, 0x000fe200010e0623ULL,
0x000000144c267210ULL, 0x000fe20007f5e0ffULL, 0x0000010017167825ULL, 0x000fe200078e0028ULL,
0x000000034f147812ULL, 0x000fc600078ec0ffULL, 0x0000000100217824ULL, 0x000fe200078e0253ULL,
0xfffffffc572a7812ULL, 0x000fe200078ee214ULL, 0x0000000453537824ULL, 0x000fe200078e00ffULL,
0x000000164c167210ULL, 0x000fe20007f3e0ffULL, 0x0000010021207825ULL, 0x000fe200078e0028ULL,
0x0000001314137212ULL, 0x000fe400078efcffULL, 0x000000174d177210ULL, 0x000fe20000ffe4ffULL,
0x00000001001b7824ULL, 0x000fe200078e0255ULL, 0x000000204c207210ULL, 0x000fe20007f3e0ffULL,
0x0000000100257824ULL, 0x000fc400078e022fULL, 0x0000000100277824ULL, 0x000fe400078e022dULL,
0x0000000455557824ULL, 0x000fe400078e00ffULL, 0x000000102a4f7824ULL, 0x000fe200078e020dULL,
0xfffffffc532a7812ULL, 0x000fe200078ee214ULL, 0x000001001b1a7825ULL, 0x000fe200078e0028ULL,
0xfffffffc552c7812ULL, 0x000fc600078ee214ULL, 0x0000010025247825ULL, 0x000fe200078e0028ULL,
0x0000001a4c1a7210ULL, 0x000fc60007f7e0ffULL, 0x0000000451517824ULL, 0x000fe400078e00ffULL,
0x0000010027287825ULL, 0x000fc800078e0028ULL, 0x000000014d277824ULL, 0x000fe400010e0615ULL,
0x0000001013157824ULL, 0x000fe400078e020dULL, 0x000000014d217824ULL, 0x000fe200008e0621ULL,
0x000000244c247210ULL, 0x000fe20007f3e0ffULL, 0x000000102a557824ULL, 0x000fe200078e020dULL,
0xfffffffc512a7812ULL, 0x000fe200078ee214ULL, 0x000000042f2f7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016157faeULL, 0x0003e2000b901c48ULL,
0x000000042b2b7824ULL, 0x000fc400078e00ffULL, 0x000000042d2d7824ULL, 0x000fe200078e00ffULL,
0x00000000184f7faeULL, 0x0005e2000b901c48ULL, 0x000000014d1b7824ULL, 0x040fe400018e061bULL,
0x000000102c537824ULL, 0x000fe400078e020dULL, 0x000000014d257824ULL, 0x000fe200008e0625ULL,
0x000000284c287210ULL, 0x000fe40007f3e0ffULL, 0xfffffffc2f167812ULL, 0x102fe200078ee214ULL,
0x000000102a177824ULL, 0x100fe200078e020dULL, 0xfffffffc2d2a7812ULL, 0x100fe200078ee214ULL,
0x000000001a537faeULL, 0x0003e2000b901c48ULL, 0xfffffffc2b187812ULL, 0x004fe200078ee214ULL,
0x0000001016197824ULL, 0x000fc400078e020dULL, 0x0000000020557faeULL, 0x0005e2000b901c48ULL,
0x000000014d297824ULL, 0x000fc600008e0629ULL, 0x0000000022177faeULL, 0x0007e2000b901c48ULL,
0x00000010181b7824ULL, 0x002fc600078e020dULL, 0x0000000024197faeULL, 0x0007e2000b901c48ULL,
0x000000102a217824ULL, 0x004fc600078e020dULL, 0x00000000261b7faeULL, 0x0007e8000b901c48ULL,
0x0000000028217faeULL, 0x0007e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000100f177824ULL, 0x00cfe200078e00ffULL, 0x000000040e167810ULL, 0x000fe40007ffe0ffULL,
0x0000200010107810ULL, 0x000fe40007ffe0ffULL, 0xfffffff017167812ULL, 0x000fc600078ee216ULL,
0x000000100c677824ULL, 0x100fe200078e0210ULL, 0x00000010080c7211ULL, 0x000fe200078e20ffULL,
0x0000001016207824ULL, 0x000fe400078e00ffULL, 0x000000100b667824ULL, 0x100fe400078e0210ULL,
0x000000100a177824ULL, 0x100fe400078e0210ULL, 0x0000001009167824ULL, 0x000fe200078e0210ULL,
0x000000060e097810ULL, 0x000fe20007ffe0ffULL, 0x000000100f0a7824ULL, 0x000fc400078e00ffULL,
0x0000001005057824ULL, 0x100fe400078e0210ULL, 0x0000001004047824ULL, 0x000fe200078e0210ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006718783bULL, 0x000fe20000000200ULL,
0xfffffff00a097812ULL, 0x000fe200078ee209ULL, 0x0000001003037824ULL, 0x000fe400078e0210ULL,
0x000000002020783bULL, 0x000e640000000200ULL, 0x0000001009097824ULL, 0x000fe400078e00ffULL,
0x000000006624783bULL, 0x000ea80000000200ULL, 0x000000001728783bULL, 0x000ee80000000200ULL,
0x00000000162c783bULL, 0x000f280000000200ULL, 0x000000000c50783bULL, 0x000fe80000000200ULL,
0x000000000908783bULL, 0x000ee80000000200ULL, 0x000000000558783bULL, 0x000ee80000000200ULL,
0x000000000454783bULL, 0x000ee80000000200ULL, 0x00000000035c783bULL, 0x000ee20000000200ULL,
0x000000182030723cULL, 0x042f700000001830ULL, 0x0000001a2034723cULL, 0x040f700000001834ULL,
0x000000242038723cULL, 0x044f700000001838ULL, 0x00000026203c723cULL, 0x040f70000000183cULL,
0x000000282040723cULL, 0x048f700000001840ULL, 0x0000002a2044723cULL, 0x040f700000001844ULL,
0x0000002c2048723cULL, 0x050f700000001848ULL, 0x0000002e201c723cULL, 0x000f70000000181cULL,
0x000000500830723cULL, 0x060b700000001830ULL, 0x000000520834723cULL, 0x040b700000001834ULL,
0x000000580838723cULL, 0x040b700000001838ULL, 0x0000005a083c723cULL, 0x040b70000000183cULL,
0x000000540840723cULL, 0x040b700000001840ULL, 0x000000560844723cULL, 0x040b700000001844ULL,
0x0000005c0848723cULL, 0x040b700000001848ULL, 0x0000005e081c723cULL, 0x000b62000000181cULL,
0x0000056000008947ULL, 0x000fce0003800000ULL, 0x00000002ff4f7819ULL, 0x000fe2000001166bULL,
0x000000ffff097224ULL, 0x020fe200078e00ffULL, 0x000000c011087812ULL, 0x000fe200078efcffULL,
0x0000001013137824ULL, 0x000fe200078e0210ULL, 0x000000084f2f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000100197824ULL, 0x000fe200078e024fULL, 0x000000104f277810ULL, 0x000fc40007ffe0ffULL,
0x000000184f297810ULL, 0x000fe20007ffe0ffULL, 0x0000010019187825ULL, 0x000fe200078e0008ULL,
0x000000284f2d7810ULL, 0x040fe40007ffe0ffULL, 0x000000204f2b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001000b7824ULL, 0x000fe200078e022fULL, 0x000000184c207210ULL, 0x000fe20007f1e0ffULL,
0x00000001001b7824ULL, 0x000fe400078e0227ULL, 0x000001000b0a7825ULL, 0x000fc800078e0008ULL,
0x000000014d217824ULL, 0x000fe200000e0619ULL, 0x0000001261197217ULL, 0x000fe20007800000ULL,
0x000001001b1a7825ULL, 0x000fe200078e0008ULL, 0x0000000a4c0a7210ULL, 0x000fc60007f3e0ffULL,
0x0000000119267824ULL, 0x000fe200078e0a12ULL, 0x0000001a4c1a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000100237824ULL, 0x040fe400078e0229ULL, 0x0000000100517824ULL, 0x000fe200078e022dULL,
0x000000262f00720cULL, 0x0c0fe20003f66070ULL, 0x000000042f2f7824ULL, 0x000fe200078e00ffULL,
0x000000264f00720cULL, 0x080fe20003f46070ULL, 0x0000010023187825ULL, 0x000fe200078e0008ULL,
0x000000262700720cULL, 0x000fe40003fa6070ULL, 0xfffffffc2f2f7812ULL, 0x000fe200078ee214ULL,
0x0000010051227825ULL, 0x000fe200078e0008ULL, 0x000000304f517810ULL, 0x000fc40007ffe0ffULL,
0x000000384f4f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000100257824ULL, 0x000fe200078e022bULL,
0x000000262900720cULL, 0x000fe20003f86070ULL, 0x000000014d0b7824ULL, 0x000fe400008e060bULL,
0x000000102f2f7824ULL, 0x000fe200078e0210ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020137faeULL, 0x0003e2000d101c48ULL, 0x000000014d1b7824ULL, 0x000fe200000e061bULL,
0x000000184c187210ULL, 0x000fe20007f1e0ffULL, 0x0000010025247825ULL, 0x000fe200078e0008ULL,
0x000000000a2f7faeULL, 0x0005e2000d901c48ULL, 0x000000262b00720cULL, 0x000fc40003f66070ULL,
0x0000000100537824ULL, 0x000fe200078e0251ULL, 0x000000244c247210ULL, 0x040fe20007f3e0ffULL,
0x000000014d197824ULL, 0x000fe200000e0619ULL, 0x000000224c227210ULL, 0x000fe20007f1e0ffULL,
0x0000000427137824ULL, 0x002fe200078e00ffULL, 0x000000262d00720cULL, 0x000fe20003f46070ULL,
0x0000000429217824ULL, 0x000fe400078e00ffULL, 0x00000100530a7825ULL, 0x004fe200078e0008ULL,
0xfffffffc13137812ULL, 0x100fe400078ee214ULL, 0xfffffffc21217812ULL, 0x000fe200078ee214ULL,
0x0000000100537824ULL, 0x000fe200078e024fULL, 0x0000000a4c0a7210ULL, 0x000fe20007fde0ffULL,
0x000000042b277824ULL, 0x000fe200078e00ffULL, 0x0000001013137211ULL, 0x000fe200078e20ffULL,
0x000000042d297824ULL, 0x000fc400078e00ffULL, 0x00000004512b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc27277812ULL, 0x000fe200078ee214ULL, 0x000000014d257824ULL, 0x000fe200008e0625ULL,
0x000000265100720cULL, 0x080fe20003f26070ULL, 0x0000010053087825ULL, 0x000fe200078e0008ULL,
0xfffffffc29297812ULL, 0x100fe200078ee214ULL, 0x000000001a137faeULL, 0x0003e2000e901c48ULL,
0xfffffffc2b2b7812ULL, 0x100fe200078ee214ULL, 0x000000044f2d7824ULL, 0x000fe400078e00ffULL,
0x000000014d237824ULL, 0x000fe200000e0623ULL, 0x000000264f00720cULL, 0x000fe20003f06070ULL,
0x000000014d0b7824ULL, 0x000fe200030e060bULL, 0xfffffffc2d2d7812ULL, 0x000fe200078ee214ULL,
0x0000001021217824ULL, 0x100fe200078e0210ULL, 0x000000084c087210ULL, 0x000fe20007fde0ffULL,
0x0000001027277824ULL, 0x000fc400078e0210ULL, 0x0000001029297824ULL, 0x100fe200078e0210ULL,
0x0000000018217faeULL, 0x0003e2000e101c48ULL, 0x000000102b2b7824ULL, 0x100fe400078e0210ULL,
0x000000102d2d7824ULL, 0x000fe200078e0210ULL, 0x0000000024277faeULL, 0x0003e2000d901c48ULL,
0x000000014d097824ULL, 0x000fc600030e0609ULL, 0x0000000022297faeULL, 0x0003e8000d101c48ULL,
0x000000000a2b7faeULL, 0x0003e8000c901c48ULL, 0x00000000082d7faeULL, 0x0003e2000c101c48ULL,
0x000004a000007947ULL, 0x000fea0003800000ULL, 0x000000086b297811ULL, 0x040fe200078ff0ffULL,
0x000000ffff277224ULL, 0x000fe200078e00ffULL, 0x000000106b2b7811ULL, 0x000fe200078ff0ffULL,
0x0000001013137824ULL, 0x000fe200078e0210ULL, 0x000000186b2d7811ULL, 0x000fe200078ff0ffULL,
0x0000000100217824ULL, 0x040fe200078e0229ULL, 0x000000c011267812ULL, 0x000fe200078efcffULL,
0x0000000100237824ULL, 0x040fe200078e022bULL, 0x000000006b1b7211ULL, 0x040fe200078ff0ffULL,
0x0000000100257824ULL, 0x000fe200078e022dULL, 0x000000206b2f7811ULL, 0x000fe200078ff0ffULL,
0x0000010021207825ULL, 0x000fe200078e0026ULL, 0x000000286b4f7811ULL, 0x000fc400078ff0ffULL,
0x000000306b517811ULL, 0x020fe200078ff0ffULL, 0x000001001b1a7825ULL, 0x000fe200078e0026ULL,
0x000000386b537811ULL, 0x000fe400078ff0ffULL, 0x000000204c207210ULL, 0x000fe20007f3e0ffULL,
0x0000000100097824ULL, 0x000fe200078e022fULL, 0x0000001a4c1a7210ULL, 0x000fe20007f1e0ffULL,
0x0000010023227825ULL, 0x000fe200078e0026ULL, 0x000000214d217210ULL, 0x000fc60000ffe4ffULL,
0x00000001000b7824ULL, 0x000fe200078e024fULL, 0x000000224c227210ULL, 0x000fe20007f5e0ffULL,
0x0000010025247825ULL, 0x000fc800078e0026ULL, 0x0000000429297824ULL, 0x000fe200078e00ffULL,
0x000000244c247210ULL, 0x000fe20007f7e0ffULL, 0x0000000100197824ULL, 0x040fe400078e0251ULL,
0x000000042b2b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc29297812ULL, 0x100fe200078ee214ULL,
0x0000000100557824ULL, 0x000fe400078e0253ULL, 0x000000042d2d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc2b2b7812ULL, 0x000fe200078ee214ULL, 0x0000010009087825ULL, 0x000fc600078e0026ULL,
0xfffffffc2d2d7812ULL, 0x000fe200078ee214ULL, 0x000000042f2f7824ULL, 0x000fe400078e00ffULL,
0x000001000b0a7825ULL, 0x000fc600078e0026ULL, 0xfffffffc2f2f7812ULL, 0x000fe200078ee214ULL,
0x000000044f4f7824ULL, 0x000fe200078e00ffULL, 0x0000000a4c0a7210ULL, 0x000fe20007f3e0ffULL,
0x0000010019187825ULL, 0x000fc600078e0026ULL, 0xfffffffc4f4f7812ULL, 0x000fe200078ee214ULL,
0x0000000451517824ULL, 0x000fe400078e00ffULL, 0x0000010055267825ULL, 0x000fc600078e0026ULL,
0xfffffffc51517812ULL, 0x000fe200078ee214ULL, 0x0000000453537824ULL, 0x000fe400078e00ffULL,
0x000000014d1b7824ULL, 0x040fe200000e061bULL, 0x000000084c087210ULL, 0x040fe20007f1e0ffULL,
0x000000014d237824ULL, 0x000fe200010e0623ULL, 0x000000184c187210ULL, 0x040fe20007f5e0ffULL,
0x0000001029297824ULL, 0x000fe200078e0210ULL, 0xfffffffc53537812ULL, 0x000fe200078ee214ULL,
0x000000014d257824ULL, 0x000fe200018e0625ULL, 0x000000264c267210ULL, 0x000fe20007f7e0ffULL,
0x000000102b2b7824ULL, 0x100fe200078e0210ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a137faeULL, 0x0003e2000b901c48ULL, 0x000000102d2d7824ULL, 0x000fc400078e0210ULL,
0x000000102f2f7824ULL, 0x100fe200078e0210ULL, 0x0000000020297faeULL, 0x0003e2000b901c48ULL,
0x000000014d097824ULL, 0x000fe400000e0609ULL, 0x000000104f4f7824ULL, 0x100fe200078e0210ULL,
0x00000000222b7faeULL, 0x0003e2000b901c48ULL, 0x000000014d0b7824ULL, 0x000fe400008e060bULL,
0x0000001051517824ULL, 0x000fe200078e0210ULL, 0x00000000242d7faeULL, 0x0003e2000b901c48ULL,
0x000000014d197824ULL, 0x000fc400010e0619ULL, 0x0000001053537824ULL, 0x000fe200078e0210ULL,
0x00000000082f7faeULL, 0x0003e2000b901c48ULL, 0x000000014d277824ULL, 0x000fc600018e0627ULL,
0x000000000a4f7faeULL, 0x0003e8000b901c48ULL, 0x0000000018517faeULL, 0x0003e8000b901c48ULL,
0x0000000026537faeULL, 0x0003e4000b901c48ULL, 0x0000000402027810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff107424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000006c0200720cULL, 0x000fda0003f06070ULL, 0x0000000277188824ULL, 0x002fe400078e0202ULL,
0x00000004ff198424ULL, 0x000fc800078e00ffULL, 0x0000640018188625ULL, 0x000fe200078e0019ULL,
0x000000080e087810ULL, 0x000fe20007ffe0ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000818108981ULL, 0x0002a2000c1e1900ULL, 0x000000100f097824ULL, 0x000fe200078e00ffULL,
0x0000000a0e137810ULL, 0x000fe40007ffe0ffULL, 0x000000006058783bULL, 0x000fe40000000200ULL,
0xfffffff009087812ULL, 0x000fe400078ee208ULL, 0x000000006254783bULL, 0x000fe20000000200ULL,
0x000000100f187824ULL, 0x002fe400078e00ffULL, 0x00000010084c7824ULL, 0x000fe200078e00ffULL,
0x000000006350783bULL, 0x000fe40000000200ULL, 0xfffffff018137812ULL, 0x000fc400078ee213ULL,
0x000000004e08783bULL, 0x000fe60000000200ULL, 0x0000001013137824ULL, 0x000fe200078e00ffULL,
0x000000004c4c783bULL, 0x000e680000000200ULL, 0x00000000642c783bULL, 0x000fe80000000200ULL,
0x000000001318783bULL, 0x0007280000000200ULL, 0x000000006828783bULL, 0x000f280000000200ULL,
0x000000006924783bULL, 0x000f220000000200ULL, 0x0000030006137a10ULL, 0x008fc60007ffe0ffULL,
0x000000006a20783bULL, 0x000ee20000000200ULL, 0x000000084c30723cULL, 0x042b6e0000001830ULL,
0x0000000113087810ULL, 0x020fe20007ffe0ffULL, 0x0000000a4c34723cULL, 0x000f660000001834ULL,
0x000000650800720cULL, 0x000fca0003f06070ULL, 0x000000584c38723cULL, 0x040f700000001838ULL,
0x0000005a4c3c723cULL, 0x040f70000000183cULL, 0x000000544c40723cULL, 0x040f700000001840ULL,
0x000000564c44723cULL, 0x040f700000001844ULL, 0x000000504c48723cULL, 0x040f700000001848ULL,
0x000000524c1c723cULL, 0x000f70000000181cULL, 0x0000002c1830723cULL, 0x050b700000001830ULL,
0x0000002e1834723cULL, 0x060b700000001834ULL, 0x000000281838723cULL, 0x040b700000001838ULL,
0x0000002a183c723cULL, 0x040b70000000183cULL, 0x000000241840723cULL, 0x040b700000001840ULL,
0x000000261844723cULL, 0x040b700000001844ULL, 0x000000201848723cULL, 0x048b700000001848ULL,
0x00000022181c723cULL, 0x000b62000000181cULL, 0x0000007410097224ULL, 0x004fc800078e02ffULL,
0x0000620009087625ULL, 0x000fe200078e0076ULL, 0x000005c000008947ULL, 0x000fca0003800000ULL,
0x00000002ff297819ULL, 0x020fe2000001166bULL, 0x00000100130a7824ULL, 0x000fc600078e0275ULL,
0x00000008292b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000100187824ULL, 0x040fe200078e0229ULL,
0x00000010292d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000a610b7217ULL, 0x000fe20007800000ULL,
0x00000001001a7824ULL, 0x000fe200078e022bULL, 0x00000020294d7810ULL, 0x040fe20007ffe0ffULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x00000018292f7810ULL, 0x040fe40007ffe0ffULL,
0x00000028294f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000100207824ULL, 0x000fe200078e022dULL,
0x0000001118217212ULL, 0x000fe200078efcffULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x0000003029517810ULL, 0x000fc40007ffe0ffULL, 0x0000002108227210ULL, 0x000fe20007f1e0ffULL,
0x000000010b267824ULL, 0x000fe200078e0a0aULL, 0x000000111a237212ULL, 0x000fe200078efcffULL,
0x00000100200a7825ULL, 0x000fc600078e00ffULL, 0x0000002308207210ULL, 0x000fe20007f3e0ffULL,
0x0000000119237824ULL, 0x000fe200000e0609ULL, 0x000000110a217212ULL, 0x000fe200078efcffULL,
0x00000001001a7824ULL, 0x040fe200078e024dULL, 0x000000262d00720cULL, 0x080fe20003fa6070ULL,
0x0000000100187824ULL, 0x000fe200078e022fULL, 0x00000021080a7210ULL, 0x000fe20007f1e0ffULL,
0x000000011b217824ULL, 0x000fe200008e0609ULL, 0x000000262b00720cULL, 0x080fe20003f26070ULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x000000262f00720cULL, 0x000fc40003f86070ULL,
0x000000022d2d7819ULL, 0x000fe200000006ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0609ULL,
0x000000262900720cULL, 0x000fe20003f06070ULL, 0x000000042b2b7824ULL, 0x000fe200078e00ffULL,
0x000000111a257212ULL, 0x000fe200078efcffULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x0000003829297810ULL, 0x000fe40007ffe0ffULL, 0xfffffffc2b247812ULL, 0x100fe200078ee214ULL,
0x000000042f2f7824ULL, 0x000fe200078e00ffULL, 0x00000025081a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000100257824ULL, 0x000fe200078e024fULL, 0x0000001118277212ULL, 0x000fe200078efcffULL,
0x00000010242b7824ULL, 0x000fe200078e020dULL, 0xfffffffc2f287812ULL, 0x000fe200078ee214ULL,
0x0000010025247825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022157faeULL, 0x0003e2000c101c48ULL, 0x0000002708187210ULL, 0x000fc40007f5e0ffULL,
0x000000011b1b7824ULL, 0x100fe200018e0609ULL, 0x0000001124277212ULL, 0x000fe200078efcffULL,
0x00000000202b7faeULL, 0x0005e2000c901c48ULL, 0x0000000119197824ULL, 0x000fe200010e0609ULL,
0x000000264d00720cULL, 0x0c0fe20003f66070ULL, 0x000000044d4d7824ULL, 0x000fe200078e00ffULL,
0x0000002708247210ULL, 0x000fe20007fde0ffULL, 0x0000001028277824ULL, 0x000fe200078e020dULL,
0x000000264f00720cULL, 0x080fe20003f46070ULL, 0x0000000100227824ULL, 0x002fe200078e0251ULL,
0x000000265100720cULL, 0x080fe20003f26070ULL, 0x0000000125257824ULL, 0x000fe200030e0609ULL,
0x000000262900720cULL, 0x000fe20003f06070ULL, 0x0000010022227825ULL, 0x000fe200078e00ffULL,
0xfffffffc2d267812ULL, 0x000fc400078ee214ULL, 0xfffffffc4d2a7812ULL, 0x100fe200078ee214ULL,
0x0000000100207824ULL, 0x004fe200078e0229ULL, 0x0000001122157212ULL, 0x000fe200078efcffULL,
0x000000044f4f7824ULL, 0x000fe400078e00ffULL, 0x0000010020207825ULL, 0x000fe200078e00ffULL,
0x0000001508227210ULL, 0x000fe40007fde0ffULL, 0xfffffffc4f2c7812ULL, 0x000fe200078ee214ULL,
0x0000000451517824ULL, 0x000fe200078e00ffULL, 0x0000001120117212ULL, 0x000fe200078efcffULL,
0x0000000429297824ULL, 0x000fc400078e00ffULL, 0x0000000123237824ULL, 0x000fe200030e0609ULL,
0xfffffffc512e7812ULL, 0x100fe200078ee214ULL, 0x0000001026157824ULL, 0x100fe200078e020dULL,
0xfffffffc29147812ULL, 0x000fe200078ee214ULL, 0x000000102a297824ULL, 0x100fe200078e020dULL,
0x0000001108087210ULL, 0x000fe20007fde0ffULL, 0x000000102c117824ULL, 0x100fe200078e020dULL,
0x000000000a157faeULL, 0x0003e2000e901c48ULL, 0x000000102e2b7824ULL, 0x100fe400078e020dULL,
0x00000010140d7824ULL, 0x000fe200078e020dULL, 0x0000000018277faeULL, 0x0003e2000e101c48ULL,
0x0000000121097824ULL, 0x000fc600030e0609ULL, 0x000000001a297faeULL, 0x0003e8000d901c48ULL,
0x0000000024117faeULL, 0x0003e8000d101c48ULL, 0x00000000222b7faeULL, 0x0003e8000c901c48ULL,
0x00000000080d7faeULL, 0x0003e2000c101c48ULL, 0x000004f000007947ULL, 0x000fea0003800000ULL,
0x000000106b197811ULL, 0x060fe400078ff0ffULL, 0x000000086b0b7811ULL, 0x000fc400078ff0ffULL,
0x000000186b1b7811ULL, 0x040fe200078ff0ffULL, 0x00000001001a7824ULL, 0x040fe200078e0219ULL,
0x000000206b257811ULL, 0x000fe200078ff0ffULL, 0x000000040b217824ULL, 0x000fe200078e00ffULL,
0x000000286b277811ULL, 0x000fe200078ff0ffULL, 0x0000000419197824ULL, 0x000fe200078e00ffULL,
0x000000306b297811ULL, 0x000fe200078ff0ffULL, 0x000000041b237824ULL, 0x000fe200078e00ffULL,
0x000000386b4f7811ULL, 0x000fe200078ff0ffULL, 0x00000004252b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc21207812ULL, 0x100fe200078ee214ULL, 0x00000004272d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc19227812ULL, 0x100fe200078ee214ULL, 0x00000004292f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc23247812ULL, 0x100fe200078ee214ULL, 0x000000044f4d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc2b267812ULL, 0x100fe200078ee214ULL, 0x0000000100187824ULL, 0x000fe200078e020bULL,
0xfffffffc2d287812ULL, 0x100fe200078ee214ULL, 0x00000010222d7824ULL, 0x000fe200078e020dULL,
0xfffffffc2f2a7812ULL, 0x100fe200078ee214ULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0xfffffffc4d2c7812ULL, 0x000fc400078ee214ULL, 0x000000006b0a7211ULL, 0x000fe200078ff0ffULL,
0x0000000100147824ULL, 0x000fe200078e021bULL, 0x0000000d2c577211ULL, 0x000fe200078e20ffULL,
0x000001001a1a7825ULL, 0x000fc800078e00ffULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x000000111a237212ULL, 0x000fc600078efcffULL, 0x0000001028517824ULL, 0x000fe200078e020dULL,
0x000000110a217212ULL, 0x000fe200078efcffULL, 0x0000000100287824ULL, 0x000fe200078e0225ULL,
0x00000023081a7210ULL, 0x000fe20007f5e0ffULL, 0x0000010014227825ULL, 0x000fe200078e00ffULL,
0x00000021080a7210ULL, 0x000fe40007f1e0ffULL, 0x0000001118217212ULL, 0x000fe200078efcffULL,
0x00000010242f7824ULL, 0x000fe400078e020dULL, 0x0000000100277824ULL, 0x000fe200078e0227ULL,
0x0000002108187210ULL, 0x000fe20007f3e0ffULL, 0x00000010202b7824ULL, 0x000fc400078e020dULL,
0x00000010264d7824ULL, 0x100fe400078e020dULL, 0x000000102a557824ULL, 0x000fe200078e020dULL,
0x00000011220d7212ULL, 0x000fe200078efcffULL, 0x0000000100247824ULL, 0x040fe400078e0229ULL,
0x0000000100207824ULL, 0x000fe400078e024fULL, 0x0000010028287825ULL, 0x000fc800078e00ffULL,
0x0000010027267825ULL, 0x000fc800078e00ffULL, 0x000000010b0b7824ULL, 0x100fe200000e0609ULL,
0x0000000d08227210ULL, 0x000fe20007f1e0ffULL, 0x0000010024247825ULL, 0x000fe200078e00ffULL,
0x00000011280d7212ULL, 0x080fe400078efcffULL, 0x00000011264f7212ULL, 0x080fe200078efcffULL,
0x0000010020207825ULL, 0x000fe200078e00ffULL, 0x0000001124537212ULL, 0x080fe200078efcffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a157faeULL, 0x0003e4000b901c48ULL,
0x0000000123237824ULL, 0x100fe200000e0609ULL, 0x0000001120117212ULL, 0x000fe200078efcffULL,
0x0000000119197824ULL, 0x100fe200008e0609ULL, 0x0000000d08287210ULL, 0x040fe20007f1e0ffULL,
0x000000011b1b7824ULL, 0x000fe200010e0609ULL, 0x0000004f08267210ULL, 0x000fc40007f3e0ffULL,
0x0000005308247210ULL, 0x040fe20007f5e0ffULL, 0x0000000129297824ULL, 0x100fe200000e0609ULL,
0x0000001108087210ULL, 0x000fe20007f7e0ffULL, 0x0000000127277824ULL, 0x100fe200008e0609ULL,
0x00000000182b7faeULL, 0x0003e2000b901c48ULL, 0x0000000125257824ULL, 0x100fe400010e0609ULL,
0x0000000121097824ULL, 0x000fe200018e0609ULL, 0x000000001a2d7faeULL, 0x0003e8000b901c48ULL,
0x00000000222f7faeULL, 0x0003e8000b901c48ULL, 0x00000000284d7faeULL, 0x0003e8000b901c48ULL,
0x0000000026517faeULL, 0x0003e8000b901c48ULL, 0x0000000024557faeULL, 0x0003e8000b901c48ULL,
0x0000000008577faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000100f097824ULL, 0x042fe200078e00ffULL, 0x0000000c0e087810ULL, 0x040fe20007ffe0ffULL,
0x000000100f0f7824ULL, 0x000fe200078e00ffULL, 0x0000000e0e0e7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff009087812ULL, 0x000fe400078ee208ULL, 0xfffffff00f0e7812ULL, 0x000fc600078ee20eULL,
0x0000001008187824ULL, 0x000fe400078e00ffULL, 0x000000100e0e7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000006708783bULL, 0x000fe80000000200ULL,
0x000000001818783bULL, 0x000e680000000200ULL, 0x000000001724783bULL, 0x000fe80000000200ULL,
0x000000006620783bULL, 0x000ea80000000200ULL, 0x000000001614783bULL, 0x000ee80000000200ULL,
0x000000000c28783bULL, 0x000fe80000000200ULL, 0x000000000e0c783bULL, 0x000f280000000200ULL,
0x00000000052c783bULL, 0x000ee80000000200ULL, 0x00000000034c783bULL, 0x000fe20000000200ULL,
0x000000081830723cULL, 0x042f700000001830ULL, 0x0000000a1834723cULL, 0x040b640000001834ULL,
0x000000000408783bULL, 0x020e6c0000000200ULL, 0x000000201838723cULL, 0x044f700000001838ULL,
0x00000022183c723cULL, 0x040f70000000183cULL, 0x000000241840723cULL, 0x040ff00000001840ULL,
0x000000261844723cULL, 0x040ff00000001844ULL, 0x000000141848723cULL, 0x048ff00000001848ULL,
0x00000016181c723cULL, 0x000ff0000000181cULL, 0x000000280c30723cULL, 0x050f700000001830ULL,
0x0000002a0c34723cULL, 0x040f700000001834ULL, 0x0000002c0c38723cULL, 0x060f700000001838ULL,
0x0000002e0c3c723cULL, 0x000b62000000183cULL, 0x3db504f331277820ULL, 0x000fe20000410000ULL,
0x3db504f330177820ULL, 0x000fe20000410000ULL, 0x3db504f332207820ULL, 0x000fe20000410000ULL,
0x3db504f3331a7820ULL, 0x000fc80000410000ULL, 0x000000080c40723cULL, 0x002f620000001840ULL,
0x3db504f334287820ULL, 0x000fe20000410000ULL, 0x3db504f335317820ULL, 0x000fe20000410000ULL,
0x3db504f3361b7820ULL, 0x000fe20000410000ULL, 0x3db504f337327820ULL, 0x000fc80000410000ULL,
0x0000000a0c44723cULL, 0x000f640000001844ULL, 0x3db504f3382e7820ULL, 0x020fe20000410000ULL,
0x3db504f339297820ULL, 0x000fe20000410000ULL, 0x3db504f33a227820ULL, 0x000fe20000410000ULL,
0x3db504f33b217820ULL, 0x000fc60000410000ULL, 0x0000004c0c48723cULL, 0x000f620000001848ULL,
0x3db504f33c2a7820ULL, 0x000fe20000410000ULL, 0x3db504f33d357820ULL, 0x000fe20000410000ULL,
0x3db504f33e237820ULL, 0x000fe20000410000ULL, 0x3db504f33f347820ULL, 0x000fc80000410000ULL,
0x0000004e0c1c723cULL, 0x000f62000000181cULL, 0x3db504f340337820ULL, 0x000fe20000410000ULL,
0x3db504f3412b7820ULL, 0x000fe20000410000ULL, 0x3db504f342247820ULL, 0x000fe20000410000ULL,
0x3db504f343167820ULL, 0x000fc80000410000ULL, 0x3db504f3442c7820ULL, 0x000fe20000410000ULL,
0x3db504f345307820ULL, 0x000fe20000410000ULL, 0x3db504f346187820ULL, 0x000fe20000410000ULL,
0x3db504f347197820ULL, 0x000fca0000410000ULL, 0x3db504f3482f7820ULL, 0x020fe20000410000ULL,
0x3db504f3492d7820ULL, 0x000fe20000410000ULL, 0x3db504f34a4a7820ULL, 0x000fe20000410000ULL,
0x3db504f34b4b7820ULL, 0x000fca0000410000ULL, 0x3db504f31c257820ULL, 0x000fe20000410000ULL,
0x3db504f31d267820ULL, 0x000fe20000410000ULL, 0x3db504f31e1e7820ULL, 0x000fe20000410000ULL,
0x3db504f31f1f7820ULL, 0x000fe20000410000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000072047f8cULL, 0x0002a2000c80043fULL, 0x000000ffff1c7224ULL, 0x000fe400078e004aULL,
0x000000ffff1d7224ULL, 0x000fc400078e004bULL, 0x0000000000087805ULL, 0x000fca0000015200ULL,
0x0000040072037984ULL, 0x000ee40000000800ULL, 0x8000000003ff7812ULL, 0x00cfe40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc8000001140bULL,
0x0000000a03037211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e060bULL,
0x0000000203037819ULL, 0x000fc8000000120aULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040072037984ULL, 0x000ea40000000800ULL,
0x8000000003ff7812ULL, 0x004fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000046b117824ULL, 0x000fe200078e00ffULL, 0x000000700600720cULL, 0x000fc80003f06070ULL,
0xfffffff011047812ULL, 0x000fca00078ec0ffULL, 0x0000008007037824ULL, 0x000fca00078e0204ULL,
0x0134000003087984ULL, 0x0004e20000000c00ULL, 0x0000135000008947ULL, 0x000fea0003800000ULL,
0x000000026b067824ULL, 0x000fe200078e00ffULL, 0x0000001261377217ULL, 0x000fe20007800000ULL,
0x00000002ff4b7424ULL, 0x000fe200078e00ffULL, 0x0000006f6b047211ULL, 0x000fe400078ff0ffULL,
0x0000000606067812ULL, 0x000fe200078ec0ffULL, 0x0000000137377824ULL, 0x000fe200078e0a12ULL,
0x00005a00ff0c7a19ULL, 0x000fe40000011604ULL, 0x0000580006127a10ULL, 0x000fe20007ffe0ffULL,
0x000000016d0e7824ULL, 0x000fe200078e0206ULL, 0x0000000c71057217ULL, 0x000fc40003800000ULL,
0x000000371200720cULL, 0x080fe20003f06070ULL, 0x000000010e147824ULL, 0x140fe200078e0a37ULL,
0x000000370e00720cULL, 0x000fe20003f26070ULL, 0x00000001120e7824ULL, 0x000fe200078e0a37ULL,
0x0000000804047810ULL, 0x000fe20007ffe0ffULL, 0x000000056e507224ULL, 0x000fe200078e02ffULL,
0x0000001471147217ULL, 0x040fe40003800000ULL, 0x0000000e710e7217ULL, 0x000fe40003800000ULL,
0x00000004ff147819ULL, 0x000fc40000011614ULL, 0x000000ff0e437207ULL, 0x000fe40000000000ULL,
0x000000ff14057207ULL, 0x000fe40000800000ULL, 0x0000005043147211ULL, 0x000fe400078fe0ffULL,
0x00005a00ff047a19ULL, 0x000fe20000011604ULL, 0x00000001500c7824ULL, 0x000fe200078e0205ULL,
0x00000010063a7812ULL, 0x000fe200078efcffULL, 0x0000600014147625ULL, 0x000fe200078e004bULL,
0x00000004710f7217ULL, 0x000fc40003800000ULL, 0x000058003a367a10ULL, 0x000fe20007ffe0ffULL,
0x000060000c0c7625ULL, 0x000fe200078e004bULL, 0x0000000814497981ULL, 0x0048a6000c1e9500ULL,
0x0000000f6e527224ULL, 0x000fe200078e02ffULL, 0x000000080c4e7981ULL, 0x0002a2000c1e9500ULL,
0x00000020063c7812ULL, 0x000fc600078efcffULL, 0x0000005205047210ULL, 0x080fe20007ffe0ffULL,
0x000000016d147824ULL, 0x010fe200078e023aULL, 0x000000373600720cULL, 0x000fe40003f06070ULL,
0x00000052430e7211ULL, 0x000fe200078fe0ffULL, 0x0000000114387824ULL, 0x100fe400078e0a37ULL,
0x00000001360c7824ULL, 0x002fe200078e0a37ULL, 0x000058003c407a10ULL, 0x000fe20007ffe0ffULL,
0x0000600004047625ULL, 0x000fe200078e004bULL, 0x0000003871387217ULL, 0x000fc40003800000ULL,
0x0000000c710c7217ULL, 0x000fe20003800000ULL, 0x000060000e0e7625ULL, 0x000fe200078e004bULL,
0x00000004ff0d7819ULL, 0x000fe20000011638ULL, 0x00000008044c7981ULL, 0x000322000c1e9500ULL,
0x000000ff0c387207ULL, 0x000fe20000000000ULL, 0x0000000140447824ULL, 0x000fe200078e0a37ULL,
0x000000371400720cULL, 0x080fe20003f26070ULL, 0x000000016d467824ULL, 0x000fe200078e023cULL,
0x000000374000720cULL, 0x000fe20003f06070ULL, 0x000000080e457981ULL, 0x000722000c1e9500ULL,
0x00000044713d7217ULL, 0x000fc40003800000ULL, 0x0000005038047211ULL, 0x002fe200078fe0ffULL,
0x0000000146487824ULL, 0x000fe200078e0a37ULL, 0x000000ff3d3d7207ULL, 0x000fc60000000000ULL,
0x0000600004047625ULL, 0x000fe200078e004bULL, 0x000000ff0d0f7207ULL, 0x008fe40000800000ULL,
0x0000003006447812ULL, 0x000fe400078efcffULL, 0x00000052380e7211ULL, 0x000fe200078fe0ffULL,
0x0000000804397981ULL, 0x0002e2000c1e9500ULL, 0x00000001500c7824ULL, 0x000fe200078e020fULL,
0x0000004871487217ULL, 0x000fe20003800000ULL, 0x000000010f147824ULL, 0x000fe200078e0252ULL,
0x000000374600720cULL, 0x000fe20003f26070ULL, 0x000000016d547824ULL, 0x000fe200078e0244ULL,
0x00000004ff487819ULL, 0x000fc40000011648ULL, 0x000000503d047211ULL, 0x002fe200078fe0ffULL,
0x000060000c0c7625ULL, 0x000fe200078e004bULL, 0x0000580044467a10ULL, 0x000fc60007ffe0ffULL,
0x000060000e0e7625ULL, 0x000fc800078e004bULL, 0x0000600014147625ULL, 0x080fe200078e004bULL,
0x000000ff48417207ULL, 0x000fe20000800000ULL, 0x000000080c3e7981ULL, 0x0002e4000c1e9500ULL,
0x0000600004047625ULL, 0x000fe400078e004bULL, 0x000000080e3b7981ULL, 0x0002e4000c1e9500ULL,
0x0000000154567824ULL, 0x000fe400078e0a37ULL, 0x0000000814427981ULL, 0x0002e8000c1e9500ULL,
0x00000008043f7981ULL, 0x0002e2000c1e9500ULL, 0x0000005671567217ULL, 0x000fe20003800000ULL,
0x00000001500c7824ULL, 0x002fe200078e0241ULL, 0x000000523d0e7211ULL, 0x000fe200078fe0ffULL,
0x0000000141147824ULL, 0x000fc400078e0252ULL, 0x0000000146047824ULL, 0x040fe200078e0a37ULL,
0x000000374600720cULL, 0x000fe20003f06070ULL, 0x000060000c0c7625ULL, 0x000fe200078e004bULL,
0x000000375400720cULL, 0x000fe40003f26070ULL, 0x0000000471047217ULL, 0x000fe20003800000ULL,
0x000060000e0e7625ULL, 0x080fe200078e004bULL, 0x00000004ff567819ULL, 0x000fe20000011656ULL,
0x000000080c487981ULL, 0x0002e4000c1e9500ULL, 0x0000600014147625ULL, 0x000fe200078e004bULL,
0x000000ff04477207ULL, 0x000fe20000000000ULL, 0x000000080e417981ULL, 0x0002e2000c1e9500ULL,
0x000000ff564d7207ULL, 0x000fc60000800000ULL, 0x00000008144a7981ULL, 0x0002e2000c1e9500ULL,
0x0000005047047211ULL, 0x000fe200078fe0ffULL, 0x00000001500c7824ULL, 0x002fc800078e024dULL,
0x0000600004047625ULL, 0x000fc800078e004bULL, 0x000060000c0c7625ULL, 0x000fe400078e004bULL,
0x0000000804047981ULL, 0x0002e2000c1e9500ULL, 0x00000052470e7211ULL, 0x000fc600078fe0ffULL,
0x000000080c0d7981ULL, 0x0002e2000c1e9500ULL, 0x000000014d147824ULL, 0x000fe400078e0252ULL,
0x000060000e0e7625ULL, 0x000fc800078e004bULL, 0x0000600014147625ULL, 0x000fe400078e004bULL,
0x000000080e0e7981ULL, 0x0002e8000c1e9500ULL, 0x0000000814157981ULL, 0x0004e2000c1e9500ULL,
0xfffffff043507812ULL, 0x000fe200078ec0ffULL, 0x00000001ff437424ULL, 0x000fc800078e00ffULL,
0x0000000137057824ULL, 0x002fc800078e0250ULL, 0x0000000112587824ULL, 0x000fe200078e0a05ULL,
0x0000000806507812ULL, 0x040fe400078efcffULL, 0x0000000906547812ULL, 0x000fe400078efcffULL,
0x0000005843587219ULL, 0x000fe400000006ffULL, 0x0000580050527a10ULL, 0x000fe40007ffe0ffULL,
0x00005800540c7a10ULL, 0x000fc60007ffe0ffULL, 0x00000001525a7824ULL, 0x100fe400078e0a05ULL,
0x000000010c5c7824ULL, 0x000fe200078e0a05ULL, 0x00000018066a7812ULL, 0x000fe400078efcffULL,
0x0000005a435a7219ULL, 0x040fe400000006ffULL, 0x0000005c435c7219ULL, 0x000fe400000006ffULL,
0xfffffff03d3d7812ULL, 0x000fe400078ec0ffULL, 0x000058006a7a7a10ULL, 0x000fc40007ffe0ffULL,
0x0000001906687812ULL, 0x040fe400078efcffULL, 0x0000001106767812ULL, 0x040fe400078efcffULL,
0x0000002106607812ULL, 0x040fe400078efcffULL, 0x00000028065e7812ULL, 0x000fe400078efcffULL,
0x0000580068787a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff047477812ULL, 0x000fc400078ec0ffULL,
0x00005800767c7a10ULL, 0x000fe40007ffe0ffULL, 0x0000580060667a10ULL, 0x000fe20007ffe0ffULL,
0x00000001374d7824ULL, 0x000fe200078e0247ULL, 0x000058005e647a10ULL, 0x000fc60007ffe0ffULL,
0x0000000146577824ULL, 0x000fca00078e0a4dULL, 0x0000005743577219ULL, 0x000fe400000006ffULL,
0x0000541049497816ULL, 0x004fe4000000004eULL, 0x00000001064e7812ULL, 0x000fe400078efcffULL,
0x0000004958ff7212ULL, 0x000fe4000780c0ffULL, 0x000058004e567a10ULL, 0x000fe40007ffe0ffULL,
0x000000371200720cULL, 0x000fc60000701470ULL, 0x0000000156147824ULL, 0x000fe200078e0a05ULL,
0x000000370600720cULL, 0x000fe40000701070ULL, 0xfffffff038057812ULL, 0x000fe400078ec0ffULL,
0x0000001443147219ULL, 0x000fe400000006ffULL, 0xff80000017177808ULL, 0x000fe20000000000ULL,
0x00000001370f7824ULL, 0x000fe200078e0205ULL, 0x0000541045457816ULL, 0x010fc8000000004cULL,
0x0000004558ff7212ULL, 0x080fe4000788c0ffULL, 0x000000455aff7212ULL, 0x080fe400078cc0ffULL,
0x000000455cff7212ULL, 0x080fe4000780c0ffULL, 0x0000004514ff7212ULL, 0x040fe200078ac0ffULL,
0x0000000137457824ULL, 0x000fe200078e023dULL, 0x0000004914ff7212ULL, 0x080fe2000786c0ffULL,
0x00000001363d7824ULL, 0x000fe200078e0a0fULL, 0x000000495aff7212ULL, 0x000fc4000784c0ffULL,
0x000000495cff7212ULL, 0x000fe2000782c0ffULL, 0x000000017a497824ULL, 0x000fe200078e0a0fULL,
0x000000371200720cULL, 0x080fe40002781470ULL, 0x000000375200720cULL, 0x080fe400037c1470ULL,
0x000000370c00720cULL, 0x080fe40000701470ULL, 0x000000370600720cULL, 0x080fe40002781070ULL,
0x000000375000720cULL, 0x000fc400037c1070ULL, 0x000000375400720cULL, 0x000fe40000701070ULL,
0x0000003d433d7219ULL, 0x040fe400000006ffULL, 0x0000004943497219ULL, 0x000fe400000006ffULL,
0x00000029065c7812ULL, 0x040fe400078efcffULL, 0x00005410393e7816ULL, 0x008fe4000000003eULL,
0x0000003106587812ULL, 0x000fc400078efcffULL, 0x00000038064c7812ULL, 0x040fe400078efcffULL,
0x0000003906147812ULL, 0x000fe400078efcffULL, 0x000054103b427816ULL, 0x000fe40000000042ULL,
0x000000370c00720cULL, 0x000fe40000f21470ULL, 0xff80000020207808ULL, 0x000fe40002000000ULL,
0xff8000001b1b7808ULL, 0x000fc40003000000ULL, 0xff80000032327808ULL, 0x000fe40000000000ULL,
0x0000003e3dff7212ULL, 0x040fe4000788c0ffULL, 0x000000423dff7212ULL, 0x080fe400078cc0ffULL,
0x0000004249ff7212ULL, 0x000fe4000780c0ffULL, 0x000058005c627a10ULL, 0x000fe20007ffe0ffULL,
0x00000001784b7824ULL, 0x000fe200078e0a0fULL, 0x00005800585a7a10ULL, 0x000fc40007ffe0ffULL,
0x000058004c387a10ULL, 0x000fe40007ffe0ffULL, 0x0000580014057a10ULL, 0x000fe20007ffe0ffULL,
0x000000017c477824ULL, 0x000fe200078e0a0fULL, 0x000000375400720cULL, 0x080fe20000f21070ULL,
0x00000001404f7824ULL, 0x000fe200078e0a45ULL, 0x000000375600720cULL, 0x0c0fe40001f61470ULL,
0x000000375600720cULL, 0x080fe40002fa1470ULL, 0x000000375200720cULL, 0x000fc40001741470ULL,
0x000000373600720cULL, 0x0c0fe40002781470ULL, 0x000000373600720cULL, 0x080fe400037c1470ULL,
0x000000377a00720cULL, 0x080fe20000701470ULL, 0x0000000166517824ULL, 0x100fe200078e0a45ULL,
0x0000006445537210ULL, 0x000fe20007ffe1ffULL, 0x0000000162557824ULL, 0x000fe200078e0a45ULL,
0xff80000031317808ULL, 0x000fe20000800000ULL, 0x000000015a597824ULL, 0x100fe200078e0a4dULL,
0x000000374e00720cULL, 0x080fe20001f61070ULL, 0x00000001380f7824ULL, 0x100fe200078e0a4dULL,
0x000000374e00720cULL, 0x000fe20002fa1070ULL, 0x0000000105457824ULL, 0x000fe200078e0a4dULL,
0x0000004b434d7219ULL, 0x000fc400000006ffULL, 0x000000375000720cULL, 0x080fe40001741070ULL,
0x000000373a00720cULL, 0x0c0fe40002721070ULL, 0x000000373a00720cULL, 0x080fe400037c1070ULL,
0x000000376a00720cULL, 0x000fe40000701070ULL, 0x0000004743477219ULL, 0x040fe400000006ffULL,
0x0000004f434b7219ULL, 0x000fc400000006ffULL, 0x000054103f487816ULL, 0x000fe40000000048ULL,
0x00005410414a7816ULL, 0x000fe4000000004aULL, 0xff80000027277808ULL, 0x000fe40001800000ULL,
0xff8000001a1a7808ULL, 0x000fe40002800000ULL, 0xff80000028287808ULL, 0x000fe40001000000ULL,
0xff8000002e2e7808ULL, 0x000fc40000800000ULL, 0xff80000022227808ULL, 0x000fe40003000000ULL,
0xff80000023237808ULL, 0x000fe40000000000ULL, 0x0000003e47ff7212ULL, 0x080fe4000786c0ffULL,
0x0000003e49ff7212ULL, 0x080fe400078ac0ffULL, 0x0000003e4dff7212ULL, 0x000fe4000784c0ffULL,
0x0000004247ff7212ULL, 0x000fc4000788c0ffULL, 0x000000424dff7212ULL, 0x000fe4000782c0ffULL,
0x000000484bff7212ULL, 0x040fe400078cc0ffULL, 0x0000004a4bff7212ULL, 0x000fe4000780c0ffULL,
0x000000377c00720cULL, 0x0c0fe40001f61470ULL, 0x000000377c00720cULL, 0x080fe40002781470ULL,
0x000000377a00720cULL, 0x000fc40002fa1470ULL, 0x000000377800720cULL, 0x0c0fe40001741470ULL,
0x000000377800720cULL, 0x080fe40000f21470ULL, 0x000000374000720cULL, 0x0c0fe400037c1470ULL,
0x000000374000720cULL, 0x080fe40000701470ULL, 0x000000377600720cULL, 0x0c0fe40001f61070ULL,
0x000000377600720cULL, 0x000fc40002781070ULL, 0x000000376a00720cULL, 0x080fe40002fa1070ULL,
0x000000376800720cULL, 0x0c0fe40001741070ULL, 0x000000376800720cULL, 0x080fe40000f21070ULL,
0x000000373c00720cULL, 0x0c0fe400037c1070ULL, 0x000000373c00720cULL, 0x000fe40000701070ULL,
0x0000005143517219ULL, 0x000fc400000006ffULL, 0x0000005343537219ULL, 0x040fe400000006ffULL,
0x0000005543557219ULL, 0x000fe400000006ffULL, 0x0000541004047816ULL, 0x000fe4000000000dULL,
0xff80000029297808ULL, 0x000fe40001800000ULL, 0xff80000021217808ULL, 0x000fe40002000000ULL,
0xff8000002a2a7808ULL, 0x000fc40002800000ULL, 0xff80000035357808ULL, 0x000fe40001000000ULL,
0xff80000034347808ULL, 0x000fe40000800000ULL, 0xff80000033337808ULL, 0x000fe40003000000ULL,
0xff80000024247808ULL, 0x000fe40000000000ULL, 0x0000004851ff7212ULL, 0x080fe4000786c0ffULL,
0x0000004853ff7212ULL, 0x000fc4000788c0ffULL, 0x0000004855ff7212ULL, 0x000fe400078ac0ffULL,
0x0000004a51ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004a53ff7212ULL, 0x080fe4000782c0ffULL,
0x0000004a55ff7212ULL, 0x000fe400078cc0ffULL, 0x0000000457ff7212ULL, 0x000fe4000780c0ffULL,
0x000000376600720cULL, 0x000fc40001f61470ULL, 0x000000376600720cULL, 0x080fe40001741470ULL,
0x000000376400720cULL, 0x0c0fe40002781470ULL, 0x000000376400720cULL, 0x080fe40000f21470ULL,
0x000000376200720cULL, 0x0c0fe40002fa1470ULL, 0x000000376200720cULL, 0x080fe400037c1470ULL,
0x000000374600720cULL, 0x000fc40000701470ULL, 0x000000376000720cULL, 0x0c0fe40001f61070ULL,
0x000000376000720cULL, 0x080fe40001741070ULL, 0x000000375e00720cULL, 0x0c0fe40002781070ULL,
0x000000375e00720cULL, 0x080fe40000f21070ULL, 0x000000375c00720cULL, 0x0c0fe40002fa1070ULL,
0x000000375c00720cULL, 0x000fc400037c1070ULL, 0x000000374400720cULL, 0x000fe40000701070ULL,
0x0000005943597219ULL, 0x040fe400000006ffULL, 0x0000000f430f7219ULL, 0x040fe400000006ffULL,
0x0000004543457219ULL, 0x000fe400000006ffULL, 0x000054100e0e7816ULL, 0x000fe40000000015ULL,
0xff8000002b2b7808ULL, 0x000fc40001800000ULL, 0xff80000016167808ULL, 0x000fe40001000000ULL,
0xff8000002c2c7808ULL, 0x000fe40002000000ULL, 0xff80000018187808ULL, 0x000fe40000800000ULL,
0xff80000030307808ULL, 0x000fe40002800000ULL, 0xff80000019197808ULL, 0x000fe40003000000ULL,
0xff8000002f2f7808ULL, 0x000fc40000000000ULL, 0x0000000459ff7212ULL, 0x080fe4000786c0ffULL,
0x000000040fff7212ULL, 0x080fe4000784c0ffULL, 0x0000000445ff7212ULL, 0x000fe4000788c0ffULL,
0x0000000e57ff7212ULL, 0x080fe4000782c0ffULL, 0x0000000e59ff7212ULL, 0x080fe400078ac0ffULL,
0x0000000e0fff7212ULL, 0x000fc400078cc0ffULL, 0x0000000e45ff7212ULL, 0x000fe4000780c0ffULL,
0x000000374600720cULL, 0x080fe40000f21470ULL, 0x000000375a00720cULL, 0x0c0fe40001f61470ULL,
0x000000375a00720cULL, 0x080fe40002fa1470ULL, 0x000000373800720cULL, 0x0c0fe40001741470ULL,
0x000000373800720cULL, 0x000fc400037c1470ULL, 0x000000370500720cULL, 0x0c0fe40002781470ULL,
0x000000370500720cULL, 0x080fe40000701470ULL, 0x000000374400720cULL, 0x080fe40000f21070ULL,
0x000000375800720cULL, 0x0c0fe40001f61070ULL, 0x000000375800720cULL, 0x080fe40002fa1070ULL,
0x000000374c00720cULL, 0x000fc40001741070ULL, 0x000000374c00720cULL, 0x080fe400037c1070ULL,
0x000000371400720cULL, 0x0c0fe40002781070ULL, 0x000000371400720cULL, 0x000fe40000701070ULL,
0xff8000002d2d7808ULL, 0x000fe40001800000ULL, 0xff80000025257808ULL, 0x000fe40001000000ULL,
0xff80000026267808ULL, 0x000fc40002000000ULL, 0xff8000001c1c7808ULL, 0x000fe40000800000ULL,
0xff8000001d1d7808ULL, 0x000fe40002800000ULL, 0xff8000001e1e7808ULL, 0x000fe40003000000ULL,
0xff8000001f1f7808ULL, 0x000fc40000000000ULL, 0x000000170800720bULL, 0x008fe20003f1e000ULL,
0x0000001fff147424ULL, 0x000fe200078e00ffULL, 0x000000200900720bULL, 0x000fe20003f3e000ULL,
0xffffffffff157424ULL, 0x000fe200078e00ffULL, 0x0000000817087208ULL, 0x000fc40004000000ULL,
0x0000000920097208ULL, 0x000fe40004800000ULL, 0x000000270800720bULL, 0x000fe40003f1e000ULL,
0x0000001a0900720bULL, 0x000fe40003f3e000ULL, 0x0000000827057208ULL, 0x000fe40004000000ULL,
0x000000091a047208ULL, 0x000fe40004800000ULL, 0x000000280500720bULL, 0x000fc40003f1e000ULL,
0x0000001b0400720bULL, 0x000fe40003f3e000ULL, 0x0000000528067208ULL, 0x000fe40004000000ULL,
0x000000041b057208ULL, 0x000fe40004800000ULL, 0x000000310600720bULL, 0x000fe40003f1e000ULL,
0x000000320500720bULL, 0x000fe40003f3e000ULL, 0x0000000631097208ULL, 0x000fc40004000000ULL,
0x0000000532057208ULL, 0x000fe40004800000ULL, 0x0000002e0900720bULL, 0x000fe40003f1e000ULL,
0x000000220500720bULL, 0x000fe40003f3e000ULL, 0x000000092e047208ULL, 0x000fe40004000000ULL,
0x0000000522067208ULL, 0x000fe40004800000ULL, 0x000000290400720bULL, 0x000fc40003f1e000ULL,
0x000000210600720bULL, 0x000fe40003f3e000ULL, 0x0000000429057208ULL, 0x000fe40004000000ULL,
0x0000000621067208ULL, 0x000fe40004800000ULL, 0x0000002a0500720bULL, 0x000fe40003f1e000ULL,
0x000000230600720bULL, 0x000fe40003f3e000ULL, 0x000000052a047208ULL, 0x000fc40004000000ULL,
0x0000000623057208ULL, 0x000fe40004800000ULL, 0x000000350400720bULL, 0x000fe40003f1e000ULL,
0x000000340500720bULL, 0x000fe40003f3e000ULL, 0x0000000435047208ULL, 0x000fe40004000000ULL,
0x0000000534057208ULL, 0x000fe40004800000ULL, 0x000000330400720bULL, 0x000fc40003f1e000ULL,
0x000000240500720bULL, 0x000fe40003f3e000ULL, 0x0000000433047208ULL, 0x000fe40004000000ULL,
0x0000000524057208ULL, 0x000fe40004800000ULL, 0x0000002b0400720bULL, 0x000fe40003f1e000ULL,
0x000000160500720bULL, 0x000fe40003f3e000ULL, 0x000000042b097208ULL, 0x000fc40004000000ULL,
0x0000000516057208ULL, 0x000fe40004800000ULL, 0x0000002c0900720bULL, 0x000fe40003f1e000ULL,
0x000000180500720bULL, 0x000fe40003f3e000ULL, 0x000000092c097208ULL, 0x000fe40004000000ULL,
0x0000000518047208ULL, 0x000fe40004800000ULL, 0x000000300900720bULL, 0x000fc40003f1e000ULL,
0x000000190400720bULL, 0x000fe40003f3e000ULL, 0x0000000930067208ULL, 0x000fe40004000000ULL,
0x0000000419057208ULL, 0x000fe40004800000ULL, 0x0000002f0600720bULL, 0x000fe40003f1e000ULL,
0x0000001c0500720bULL, 0x000fe40003f3e000ULL, 0x000000062f067208ULL, 0x000fc40004000000ULL,
0x000000051c047208ULL, 0x000fe40004800000ULL, 0x0000002d0600720bULL, 0x000fe40003f1e000ULL,
0x0000001d0400720bULL, 0x000fe40003f3e000ULL, 0x000000062d067208ULL, 0x000fe40004000000ULL,
0x000000041d057208ULL, 0x000fe40004800000ULL, 0x000000250600720bULL, 0x000fc40003f1e000ULL,
0x0000001e0500720bULL, 0x000fe40003f3e000ULL, 0x0000000625097208ULL, 0x000fe40004000000ULL,
0x000000051e047208ULL, 0x000fe40004800000ULL, 0x000000260900720bULL, 0x000fe40003f1e000ULL,
0x0000001f0400720bULL, 0x000fe40003f3e000ULL, 0x0000000926067208ULL, 0x000fc40004000000ULL,
0x000000041f0e7208ULL, 0x000fe20004800000ULL, 0x000014227f007947ULL, 0x000fec000b800000ULL,
0x0c401f0006047f89ULL, 0x00066400000e0000ULL, 0x000000040600720bULL, 0x002fc80003f1e000ULL,
0x0000000604127208ULL, 0x000fe20004000000ULL, 0x000014327f007947ULL, 0x000fea000b800000ULL,
0x0c401f000e047f89ULL, 0x000e6800000e0000ULL, 0x0c401f000a057f89ULL, 0x000f2800000e0000ULL,
0x0c401f000b087f89ULL, 0x000ea800000e0000ULL, 0x0c201f0012097f89ULL, 0x000ee200000e0000ULL,
0x000000040e00720bULL, 0x002fc40003f1e000ULL, 0x000000050a00720bULL, 0x010fe40003f3e000ULL,
0x0000000e04067208ULL, 0x008fe40004000000ULL, 0x0000000a050c7208ULL, 0x000fe40004800000ULL,
0x000000080b00720bULL, 0x004fe20003f1e000ULL, 0x0c201f00060d7f89ULL, 0x000e6600000e0000ULL,
0x0000000b08047208ULL, 0x000fe20004000000ULL, 0x0c201f000c0f7f89ULL, 0x000ea200000e0000ULL,
0x000000091200720bULL, 0x000fc60003f1e000ULL, 0x0c201f0004057f89ULL, 0x0006e200000e0000ULL,
0x0000001209087208ULL, 0x000fe40004000000ULL, 0x0000000d0600720bULL, 0x002fe40003f3e000ULL,
0x0000000f0c00720bULL, 0x004fe40003f5e000ULL, 0x000000060d097208ULL, 0x000fe40004800000ULL,
0x0000000c0f0a7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b080c7820ULL, 0x008fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000036bff7812ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b2d0b7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b092d7820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b17177823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b31317823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b32327823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082dULL,
0x0000001700177308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b29067823ULL, 0x102fe2000001080cULL,
0x3fb8aa3b2b297823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b33127823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b302b7823ULL, 0x100fe2000001080cULL,
0x00000027000e7308ULL, 0x0002e20000000800ULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b22227823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b34347823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b18307823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe2000001082dULL,
0x00000028000d7308ULL, 0x0009e20000000800ULL, 0x3fb8aa3b25277823ULL, 0x002fe2000001080cULL,
0x3c003c00ff257424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b1e1e7823ULL, 0x000fe2000001082dULL,
0x000000050400720bULL, 0x004fc80003f3e000ULL, 0x0000003100147308ULL, 0x0002a20000000800ULL,
0x3fb8aa3b2c287823ULL, 0x010fce000001080cULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b19317823ULL, 0x002fce000001082dULL, 0x0000001a000f7308ULL, 0x0003300000000800ULL,
0x0000001b001b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b241a7823ULL, 0x002fe2000001082dULL,
0x3c003c00ff247424ULL, 0x000fcc00078e00ffULL, 0x0000003200327308ULL, 0x000e700000000800ULL,
0x0000000600377308ULL, 0x0003f00000000800ULL, 0x0000002e002e7308ULL, 0x000f220000000800ULL,
0x3fb8aa3b2f067823ULL, 0x002fe2000001080cULL, 0x000000170e0c723eULL, 0x008fc400000000ffULL,
0x0000000d140e723eULL, 0x004fe400000000ffULL, 0x000000200f0d723eULL, 0x010fe200000000ffULL,
0x3fb8aa3b16207823ULL, 0x000fe2000001082dULL, 0x0000001b320f723eULL, 0x000fe200000000ffULL,
0x0000002a002a7308ULL, 0x000fec0000000800ULL, 0x000000240c14723cULL, 0x000f6200000018ffULL,
0x0000002e3718723eULL, 0x000fe200000000ffULL, 0x0000003500357308ULL, 0x000fe20000000800ULL,
0x00000002ff2e7819ULL, 0x000fc8000001166bULL, 0x000000022e327810ULL, 0x040fe20007ffe0ffULL,
0x000000082e377824ULL, 0x000fe400078e00ffULL, 0x0000002200227308ULL, 0x000ff00000000800ULL,
0x0000002100217308ULL, 0x000e700000000800ULL, 0x0000002300237308ULL, 0x000ff00000000800ULL,
0x0000003400347308ULL, 0x000ea20000000800ULL, 0x000000222119723eULL, 0x002fce00000000ffULL,
0x0000001a002c7308ULL, 0x0003e20000000800ULL, 0x00000023341b723eULL, 0x004fce00000000ffULL,
0x00000020002f7308ULL, 0x0004e20000000800ULL, 0x0000002a351a723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b1d2a7823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b1f2d7823ULL, 0x000fe2000001082dULL,
0x000000012e1f7810ULL, 0x040fe20007ffe0ffULL, 0x000000082e347824ULL, 0x040fe400078e00ffULL,
0x000000082e357824ULL, 0x000fe200078e00ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x000000241820723cULL, 0x024b620000001814ULL, 0xfffffff834337812ULL, 0x000fc400078ee21fULL,
0xfffffff835357812ULL, 0x000fc800078ee232ULL, 0x0000002900297308ULL, 0x000e620000000800ULL,
0x000000082e167824ULL, 0x060fe200078e00ffULL, 0x000000032e147810ULL, 0x040fe40007ffe0ffULL,
0x000000042e157810ULL, 0x000fe40007ffe0ffULL, 0xfffffff837377812ULL, 0x000fe400078ee214ULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0xfffffff816397812ULL, 0x000fe400078ee215ULL,
0x0000002c2f15723eULL, 0x008fc400000000ffULL, 0x000000032e2f7819ULL, 0x000fc600000006ffULL,
0x0000002b002b7308ULL, 0x000ea20000000800ULL, 0x000000122914723eULL, 0x002fe200000000ffULL,
0x000000082e297824ULL, 0x000fca00078e00ffULL, 0xfffffff829297812ULL, 0x000fe200078ee22eULL,
0x0000003000307308ULL, 0x000ff00000000800ULL, 0x0000003100317308ULL, 0x000e620000000800ULL,
0x000000282b16723eULL, 0x004fc400000000ffULL, 0x000000062e287810ULL, 0x040fe40007ffe0ffULL,
0xffffffff2e2b7810ULL, 0x000fc60007ffe0ffULL, 0x0000000600067308ULL, 0x000fe20000000800ULL,
0x000000303117723eULL, 0x002fce00000000ffULL, 0x0000000b000b7308ULL, 0x000e620000000800ULL,
0x000000082e317824ULL, 0x040fe200078e00ffULL, 0x000000241420723cULL, 0x000f680000001820ULL,
0xfffffff831317812ULL, 0x000fe400078ee228ULL, 0x0000002700277308ULL, 0x000ff00000000800ULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000001c001d7308ULL, 0x0005f00000000800ULL,
0x0000002a002a7308ULL, 0x000ee20000000800ULL, 0x000000052e1c7810ULL, 0x004fc80007ffe0ffULL,
0xfffffff82f2f7812ULL, 0x000fe400078ee21cULL, 0x000000060b1c723eULL, 0x002fe200000000ffULL,
0x0000001e001f7308ULL, 0x0003e20000000800ULL, 0x0000900007067811ULL, 0x000fca00078e58ffULL,
0x00000010290b7824ULL, 0x100fe400078e0206ULL, 0x0000002d00127308ULL, 0x0005220000000800ULL,
0x000000082e1e7810ULL, 0x042fe20007ffe0ffULL, 0x000000082e2e7824ULL, 0x000fe200078e00ffULL,
0x0000001d2a1d723eULL, 0x008fe200000000ffULL, 0x000000102f287824ULL, 0x100fe400078e0206ULL,
0x000000081e3d7824ULL, 0x000fe200078e00ffULL, 0xfffffff82e3b7812ULL, 0x000fe200078ee22bULL,
0x0000001031297824ULL, 0x100fe200078e0206ULL, 0x0000000c112b7812ULL, 0x000fe200078ec0ffULL,
0x0000001033117824ULL, 0x000fe200078e0206ULL, 0xfffffff83d2d7812ULL, 0x004fe200078ee21eULL,
0x000000103b2a7824ULL, 0x100fe200078e0206ULL, 0x00000027261e723eULL, 0x000fe200000000ffULL,
0x0000001037267824ULL, 0x100fe200078e0206ULL, 0x0000001f121f723eULL, 0x010fe200000000ffULL,
0x0000001035127824ULL, 0x000fc400078e0206ULL, 0x0000001039277824ULL, 0x000fe400078e0206ULL,
0x000000012b0b7824ULL, 0x040fe400078e020bULL, 0x000000241c20723cULL, 0x020f620000001820ULL,
0x000000012b117824ULL, 0x040fe400078e0211ULL, 0x000000012b127824ULL, 0x040fe200078e0212ULL,
0x0000000c0b007388ULL, 0x0003e20000000800ULL, 0x000000012b267824ULL, 0x000fe400078e0226ULL,
0x000000102d067824ULL, 0x000fe200078e0206ULL, 0x0000000e11007388ULL, 0x0005e20000000800ULL,
0x000000012b277824ULL, 0x000fc400078e0227ULL, 0x000000012b287824ULL, 0x040fe200078e0228ULL,
0x0000001812007388ULL, 0x0005e20000000800ULL, 0x000000012b297824ULL, 0x000fe200078e0229ULL,
0x00000004050b7208ULL, 0x002fe20004800000ULL, 0x000000012b2a7824ULL, 0x040fe200078e022aULL,
0x0000001a26007388ULL, 0x0005e20000000800ULL, 0x000000012b067824ULL, 0x000fc600078e0206ULL,
0x0000001427007388ULL, 0x0005e80000000800ULL, 0x0000001628007388ULL, 0x0005e20000000800ULL,
0x000000ffff217224ULL, 0x020fc600078e0022ULL, 0x0000001c29007388ULL, 0x0005e80000000800ULL,
0x0000001e2a007388ULL, 0x0005e80000000800ULL, 0x0000000d06007388ULL, 0x0005e80000000800ULL,
0x0004000f11007388ULL, 0x0005e80000000800ULL, 0x0004001912007388ULL, 0x0005e80000000800ULL,
0x0004001b26007388ULL, 0x0005e80000000800ULL, 0x0004001527007388ULL, 0x0005e80000000800ULL,
0x0004001728007388ULL, 0x0005e80000000800ULL, 0x0004001d29007388ULL, 0x0005e80000000800ULL,
0x0004001f2a007388ULL, 0x0005e80000000800ULL, 0x0130000803008388ULL, 0x0005e80000000c00ULL,
0x0132002003008388ULL, 0x0005e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136080073ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136100073ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136180073ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000651300720cULL, 0x000fe20003f06070ULL, 0x0136200073ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff067224ULL, 0x004fd600078e0013ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff9dc000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff0d7807ULL, 0x004fe40004000000ULL, 0x000134d0000e7802ULL, 0x000fc40000000f00ULL,
0x00000bb000007944ULL, 0x018fea0003c00000ULL, 0xfffef6e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe40004800000ULL, 0x00013510000e7802ULL, 0x000fc40000000f00ULL,
0x00000b7000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff047224ULL, 0x000fe200078e000dULL,
0xfffef74000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000cULL,
0x00013560000f7802ULL, 0x000fc40000000f00ULL, 0x00000ad000007944ULL, 0x018fea0003c00000ULL,
0xfffef82000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000cULL,
0x000135a0000f7802ULL, 0x000fc40000000f00ULL, 0x00000a9000007944ULL, 0x01afea0003c00000ULL,
0xfffef94000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0004ULL,
0x000135f0000f7802ULL, 0x000fe20000000f00ULL, 0x000000ffff0d7224ULL, 0x000fc400078e0031ULL,
0x00000a4000007944ULL, 0x010fea0003c00000ULL, 0x0000000d00027202ULL, 0x004fe20000000f00ULL,
0xfffefae000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0004ULL,
0x00013640000f7802ULL, 0x000fc40000000f00ULL, 0x000009f000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e000dULL, 0xfffefac000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x008fe40004000000ULL, 0x00013690000e7802ULL, 0x000fc40000000f00ULL,
0x000009f000007944ULL, 0x012fea0003c00000ULL, 0xffff11f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe40004800000ULL, 0x000136d0000e7802ULL, 0x000fc40000000f00ULL,
0x000009b000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e000dULL,
0xffff124000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0010ULL,
0x00013720000f7802ULL, 0x000fc40000000f00ULL, 0x0000091000007944ULL, 0x012fea0003c00000ULL,
0xffff133000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0010ULL,
0x00013760000f7802ULL, 0x000fc40000000f00ULL, 0x000008d000007944ULL, 0x012fea0003c00000ULL,
0xffff145000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0008ULL,
0x000137b0000f7802ULL, 0x000fe20000000f00ULL, 0x000000ffff0d7224ULL, 0x000fc400078e0011ULL,
0x0000088000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e000dULL,
0xffff160000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0008ULL,
0x00013800000f7802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e000dULL, 0xffff15e000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x008fe40004000000ULL, 0x00013850000e7802ULL, 0x000fc40000000f00ULL,
0x0000083000007944ULL, 0x012fea0003c00000ULL, 0xffff2a4000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe40004800000ULL, 0x00013890000e7802ULL, 0x000fc40000000f00ULL,
0x000007f000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e000dULL,
0xffff2a9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0032ULL,
0x000138e0000f7802ULL, 0x000fc40000000f00ULL, 0x0000075000007944ULL, 0x010fea0003c00000ULL,
0xffff2b8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0032ULL,
0x00013920000f7802ULL, 0x000fc40000000f00ULL, 0x0000071000007944ULL, 0x012fea0003c00000ULL,
0xffff2ca000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000aULL,
0x00000031000d7202ULL, 0x000fc40000000f00ULL, 0x00013970000f7802ULL, 0x000fc40000000f00ULL,
0x000006c000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e000dULL,
0xffff2e5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x000fe200078e000aULL,
0x000139c0000f7802ULL, 0x000fc40000000f00ULL, 0x0000067000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e000dULL, 0xffff2e3000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x008fe40004000000ULL, 0x00013a10000e7802ULL, 0x000fc40000000f00ULL,
0x0000067000007944ULL, 0x012fea0003c00000ULL, 0xffff433000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0d7807ULL, 0x000fe40004800000ULL, 0x00013a50000e7802ULL, 0x000fc40000000f00ULL,
0x0000063000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff327224ULL, 0x000fe200078e000dULL,
0xffff437000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0034ULL,
0x00013aa0000f7802ULL, 0x000fc40000000f00ULL, 0x0000059000007944ULL, 0x010fea0003c00000ULL,
0xffff446000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0034ULL,
0x00013ae0000f7802ULL, 0x000fc40000000f00ULL, 0x0000055000007944ULL, 0x012fea0003c00000ULL,
0xffff458000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0030ULL,
0x00013b30000f7802ULL, 0x000fe20000000f00ULL, 0x000000ffff0d7224ULL, 0x000fc400078e0031ULL,
0x0000050000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e000dULL,
0xffff473000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0e7224ULL, 0x000fe200078e0030ULL,
0x00013b80000f7802ULL, 0x000fc40000000f00ULL, 0x000004b000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e000dULL, 0xffff471000007947ULL, 0x000fea000383ffffULL,
0x00000002ff0f7424ULL, 0x000fe200078e00ffULL, 0x00013bd0000c7802ULL, 0x000fc40000000f00ULL,
0x0000042000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0005ULL,
0xffffeba000007947ULL, 0x000fea000383ffffULL, 0x000000ffff067224ULL, 0x008fe200078e000eULL,
0x00013c30000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fc400078e00ffULL,
0x000003c000007944ULL, 0x004fea0003c00000ULL, 0x000000050e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff067224ULL, 0x002fe200078e000aULL, 0x00013c90000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000e050e7208ULL, 0x000fc80004000000ULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0x000000050a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff067224ULL, 0x002fe200078e000bULL, 0x00013cf0000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000a050a7208ULL, 0x000fc80004000000ULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0x000000050b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff067224ULL, 0x002fe200078e0012ULL, 0x00013d50000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000b05047208ULL, 0x000fc80004000000ULL,
0x000002a000007944ULL, 0x000fea0003c00000ULL, 0x000000051200720bULL, 0x004fe20003f1e000ULL,
0x000000ffff067224ULL, 0x002fe200078e000eULL, 0x00013db0000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000001205087208ULL, 0x000fc80004000000ULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x000000050e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff067224ULL, 0x002fe200078e000aULL, 0x00013e10000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000e05097208ULL, 0x000fc80004000000ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0x000000050a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff067224ULL, 0x002fe200078e0004ULL, 0x00013e70000c7802ULL, 0x000fe20000000f00ULL,
0x00000001ff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000a050a7208ULL, 0x000fc80004000000ULL,
0x0000018000007944ULL, 0x000fea0003c00000ULL, 0xffffea7000007947ULL, 0x000fea000383ffffULL,
0x018000000b007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000037812ULL, 0x000fc800078ec0ffULL, 0x018000000300780cULL, 0x000fda0003f05070ULL,
0x0000000b00008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x040fe40003f25070ULL, 0x008000000300780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0bff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fe4000780c0ffULL, 0x800000000b037812ULL, 0x000fd600078ec0ffULL,
0x0080000003000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0003ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000b00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff097424ULL, 0x000fc800078e00ffULL,
0xfffec01008007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000001500007348ULL, 0x000fe80003800000ULL, 0x0c00000f06057389ULL, 0x0002a200000e0014ULL,
0xfffebfd00c007950ULL, 0x000fea0003c3ffffULL, 0x0000007600007348ULL, 0x000fe80003800000ULL,
0x0000000d0e0d7389ULL, 0x0002a400000e0077ULL, 0x000000ffff0e7224ULL, 0x002fc400078e000fULL,
0x00000000ff0f7424ULL, 0x000fc800078e00ffULL, 0xfffebf800e007950ULL, 0x000fea0003c3ffffULL,
0x000000010d00780cULL, 0x000fe20003f25070ULL, 0x00000000ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000007500007348ULL, 0x000ff60003800000ULL, 0x00000000000d7806ULL, 0x000fc800048e0100ULL,
0x000000750d0d7212ULL, 0x000fe200078ec0ffULL, 0xfffebf200e007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000010ULL, 0x0000000100000001ULL,
0x0000000800000002ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x000000000000050aULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000668ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008c0ULL,
0x00000000000002a0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b60ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c20ULL,
0x00000000000005c0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000011e0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000011f0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001280ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001284ULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001480ULL,
0x0000000000014180ULL, 0x7f00001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015600ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015640ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x00000000000159c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001280ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000014380ULL,
0x0000000000014380ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000015600ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000159c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_16_sm_86_cubin_len = 88736;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
