/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001c840ULL, 0x000000000001c4c0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL,
0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL,
0x616e7265746e695fULL, 0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL,
0x705f796c66625f63ULL, 0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL,
0x6c6668735f30376dULL, 0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL,
0x616475635f5f245fULL, 0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL,
0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL,
0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL,
0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000028ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b00220000036fULL, 0x000000000001ac60ULL, 0x0000000000000180ULL, 0x000b0022000003a2ULL,
0x000000000001ade0ULL, 0x0000000000000040ULL, 0x000b0022000003cdULL, 0x000000000001ae20ULL,
0x0000000000000050ULL, 0x000b0022000003f7ULL, 0x000000000001ae70ULL, 0x0000000000000110ULL,
0x000a000300000465ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000485ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004b5ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x000000000001af80ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001ac6000000000ULL, 0x0000040400000000ULL, 0x810c000001500400ULL,
0x0069b80400288080ULL, 0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8a08288080860828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880808a920000ULL,
0x0000000000000022ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001ac6000000000ULL,
0x0000018000000000ULL, 0x0000480400000000ULL, 0x8082288080860900ULL, 0x0900000010042880ULL,
0x288080862880808aULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8a08288080860828ULL,
0x288080a508288080ULL, 0x80d208288080a608ULL, 0x1028808280162880ULL, 0x0000000000000003ULL,
0x2200288080d29200ULL, 0x0000001cffffffffULL, 0x0000010800000000ULL, 0x0001ade000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL,
0x8a08288080860828ULL, 0x288080a608288080ULL, 0x828016288080a508ULL, 0x0000000003102880ULL,
0x8080a59200000000ULL, 0x0000000000220028ULL, 0x0000002cffffffffULL, 0x0000019000000000ULL,
0x0001ae2000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL, 0x80a6288080a50900ULL,
0x0000000000002880ULL, 0x00000054ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080850828808081ULL, 0x8a08288080860828ULL,
0x288080a508288080ULL, 0x828016288080a608ULL, 0x0000000003102880ULL, 0x8080a69200000000ULL,
0x0000000000220028ULL, 0x0000001cffffffffULL, 0x0000022800000000ULL, 0x0001ae7000000000ULL,
0x0000011000000000ULL, 0x0000000000000000ULL, 0x0000001700082f04ULL, 0x00082304000000ddULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008230400000000ULL, 0x0000000000000011ULL, 0x0000001100081204ULL, 0x0008110400000000ULL,
0x0000000000000011ULL, 0x0000001000082304ULL, 0x0008120400000000ULL, 0x0000000000000010ULL,
0x0000001000081104ULL, 0x0008230400000000ULL, 0x0000000000000017ULL, 0x0000001700081204ULL,
0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0060016000000014ULL, 0x000c170400601903ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL,
0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000ab000043104ULL, 0xffffffff01cc2904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000032001cc2804ULL, 0x000004b000000350ULL, 0x00002ea000001d90ULL,
0x0000304000002f30ULL, 0x00003320000031b0ULL, 0x0000369000003480ULL, 0x000036e0000036d0ULL,
0x0000409000003710ULL, 0x0000512000005080ULL, 0x000053b000005240ULL, 0x0000568000005520ULL,
0x000058c000005880ULL, 0x00005900000058d0ULL, 0x00006fb000005fc0ULL, 0x0000715000007040ULL,
0x00007430000072c0ULL, 0x0000779000007590ULL, 0x000077e0000077d0ULL, 0x00007e1000007810ULL,
0x00008f5000008ec0ULL, 0x000091e000009070ULL, 0x000094b000009350ULL, 0x000096f0000096b0ULL,
0x0000973000009700ULL, 0x00009e8000009e70ULL, 0x00009ea000009e90ULL, 0x0000ccf00000cc30ULL,
0x0000cd400000cd00ULL, 0x0000d8b00000d880ULL, 0x0000d9300000d8f0ULL, 0x0001844000018400ULL,
0x0001846000018450ULL, 0x000184e0000184c0ULL, 0x00018500000184f0ULL, 0x000198c000019860ULL,
0x0001999000019930ULL, 0x00019a50000199f0ULL, 0x00019b3000019ac0ULL, 0x00019c1000019ba0ULL,
0x00019cd000019c70ULL, 0x00019da000019d40ULL, 0x00019e6000019e00ULL, 0x00019f4000019ed0ULL,
0x0001a02000019fb0ULL, 0x0001a0e00001a080ULL, 0x0001a1b00001a150ULL, 0x0001a2700001a210ULL,
0x0001a3500001a2e0ULL, 0x0001a4300001a3c0ULL, 0x0001a4f00001a490ULL, 0x0001a5c00001a560ULL,
0x0001a6800001a620ULL, 0x0001a7600001a6f0ULL, 0x0001a8400001a7d0ULL, 0x0001a9300001a8c0ULL,
0x0001aa300001a9b0ULL, 0x0001ab300001aab0ULL, 0x0001ac300001abb0ULL, 0x0000040002003904ULL,
0x0001e600000000ffULL, 0x00000440003f0100ULL, 0x0001e60800000009ULL, 0x00000480003f0120ULL,
0x0001e68800000009ULL, 0x00000b00003f0120ULL, 0x0001e600000000ffULL, 0x00000cd0003f0107ULL,
0x0001e68c0000007cULL, 0x00000d80003f0102ULL, 0x0001e6880000007cULL, 0x00002bb0003f0101ULL,
0x0001e60800000008ULL, 0x00002bd0003f0101ULL, 0x0001e60c00000008ULL, 0x00002da0003f0105ULL,
0x0001e60c00000008ULL, 0x00004010003f0105ULL, 0x0001e68800000021ULL, 0x00004dc0003f0101ULL,
0x0001e6280000006aULL, 0x00004de0003f0101ULL, 0x0001e62c0000006aULL, 0x00004fb0003f0105ULL,
0x0001e62c0000006aULL, 0x00005f40003f0105ULL, 0x000000000000001fULL, 0x00006cf0003f0101ULL,
0x0001e64800000022ULL, 0x00006d10003f0101ULL, 0x0001e64c00000022ULL, 0x00006ee0003f0105ULL,
0x0001e64c00000022ULL, 0x00007df0003f0105ULL, 0x0000000000000024ULL, 0x00008c10003f0101ULL,
0x0001e6680000004aULL, 0x00008c30003f0101ULL, 0x0001e66c0000004aULL, 0x00008e00003f0105ULL,
0x0001e66c0000004aULL, 0x00009ce0003f0105ULL, 0x000000000000000dULL, 0x0000f3b0003f0101ULL,
0x0001e600000000ffULL, 0x00010be0003f0101ULL, 0x0001e604000000ffULL, 0x00010db0003f0105ULL,
0x0001e604000000ffULL, 0x00015730003f0105ULL, 0x000000000000009cULL, 0x00015a20003f0101ULL,
0x000000040000009cULL, 0x00015bf0003f0105ULL, 0x000000040000009cULL, 0x000196b0003f0105ULL,
0x0001e6080000009eULL, 0x00019710003f0101ULL, 0x0001e6100000009eULL, 0x00019770003f0101ULL,
0x0001e6180000009eULL, 0x000197e0003f0101ULL, 0x0001e6200000009eULL, 0x00033803003f0101ULL,
0x0000e73000301c04ULL, 0x0000e9300000e760ULL, 0x0000ebf00000ea90ULL, 0x0000eeb00000ed50ULL,
0x0000f1a00000f010ULL, 0x00010e100000f2a0ULL, 0x0000040100019820ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x000000000000029cULL, 0x0000001700000002ULL, 0x0000000000000204ULL, 0x0000001700000002ULL,
0x000000000000017cULL, 0x0000001700000002ULL, 0x00000000000000dcULL, 0x0000001700000002ULL,
0x0000000000000044ULL, 0x0000001700000002ULL, 0x0000000000000274ULL, 0x0000001700000002ULL,
0x00000000000001dcULL, 0x0000001700000002ULL, 0x0000000000000159ULL, 0x0000001700000002ULL,
0x00000000000000b2ULL, 0x0000001700000002ULL, 0x000000000001e700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff147624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000807919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000067919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a0014827a19ULL, 0x000fe200000006ffULL,
0x00000000000579c3ULL, 0x000f220000002500ULL, 0x00000000000d7919ULL, 0x000ea20000002100ULL,
0x0000460000087ab9ULL, 0x000fc60000000a00ULL, 0x0000000000a27919ULL, 0x000ea20000002700ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003077a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a07ULL, 0x0000040003007624ULL, 0x000fca00078e0214ULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff07aa12ULL, 0x000fc800078e33ffULL,
0x0000000700007306ULL, 0x000e620000209000ULL, 0x000000ff0700720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000307047224ULL, 0x004fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fc800078e0a04ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x00000080030b7227ULL, 0x000fe400078e00ffULL,
0x0000000000037919ULL, 0x000ee40000002200ULL, 0x000000ffff007224ULL, 0x000fc800078e0a0bULL,
0x0000000007007224ULL, 0x000fca00078e0280ULL, 0x000000070000720cULL, 0x000fda0003f06070ULL,
0x0000000100000824ULL, 0x000fe200078e0a07ULL, 0x000000010b0b0810ULL, 0x000fe20007ffe0ffULL,
0x0000010006027a24ULL, 0x008fc600078e0203ULL, 0x000000070000720cULL, 0x000fe20003f26070ULL,
0x0000000002097a24ULL, 0x100fe200078e020dULL, 0x00000005ff007819ULL, 0x000fe4000001160dULL,
0x00001fff060d7589ULL, 0x000fe400000e0000ULL, 0x000000ff0900720cULL, 0x040fe40003f65270ULL,
0x0000000f0900780cULL, 0x040fe20003f84070ULL, 0x00001fff00007589ULL, 0x000e6200000e0000ULL,
0x000000030900780cULL, 0x000fc60003f04070ULL, 0x000000010b0b1810ULL, 0x000fe40007ffe0ffULL,
0x00000007ff0ba212ULL, 0x000fe400078e33ffULL, 0x0000007f0900780cULL, 0x000fe40003f24070ULL,
0x3fffff800002b802ULL, 0x000fe20000000f00ULL, 0x000000ffff087224ULL, 0x000fe200078e0a0bULL,
0x00005a000b7f7a19ULL, 0x000fe200000006ffULL, 0x7fffff80ff03b424ULL, 0x000fe400078e00ffULL,
0x0000000807807224ULL, 0x000fc400078e0280ULL, 0x3fffffc0ff04c424ULL, 0x000fe200078e00ffULL,
0x01e60002ff00b388ULL, 0x0005e20000000a00ULL, 0x7fffffc0ff05c424ULL, 0x000fe400078e00ffULL,
0x0000002080077824ULL, 0x000fe400078e00ffULL, 0xff317217ff089424ULL, 0x000fe200078e00ffULL,
0x01e608040900c388ULL, 0x0007e20000008a00ULL, 0x3fffff60ff028424ULL, 0x004fc600078e00ffULL,
0x01e4000809009388ULL, 0x000fe20000004800ULL, 0x7fffff60ff038424ULL, 0x000fca00078e00ffULL,
0x01e6880209008388ULL, 0x000fe20000008a00ULL, 0x0000000407047c10ULL, 0x008fe2000fffe1ffULL,
0x000000040d057824ULL, 0x002fe400078e0200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000407007c0cULL, 0x000fe2000bf03070ULL, 0x0000000405057824ULL, 0x000fe200078e00ffULL,
0x0000002004047817ULL, 0x000fc40003800000ULL, 0x0000000500027c02ULL, 0x010fe40008000f00ULL,
0x000000ff047e7207ULL, 0x000fe20000000000ULL, 0x00005800a2047a24ULL, 0x000fc600078e02ffULL,
0x000000207e00780cULL, 0x000fe20003f05270ULL, 0x0000008204047224ULL, 0x000fd800078e027fULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe20000000000ULL, 0x000000057e067217ULL, 0x000fe20007800000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe4000800063fULL,
0x0000000106067824ULL, 0x000fe200078e0a05ULL, 0x00000004ff087819ULL, 0x002fc80000011603ULL,
0x00000002080e7810ULL, 0x040fe20007ffe0ffULL, 0x00000001050a7824ULL, 0x040fe200078e0208ULL,
0x000000060800720cULL, 0x080fe40003f06070ULL, 0x000000060e00720cULL, 0x000fe20003f26070ULL,
0x0000000105107824ULL, 0x000fe200078e020eULL, 0x000000030a067210ULL, 0x000fe20007ffe0ffULL,
0x0000000107097824ULL, 0x040fe400078e020aULL, 0x00000001070c7824ULL, 0x000fc600078e0210ULL,
0x00000004090f7c12ULL, 0x000fe4000f8e30ffULL, 0x000000040c117c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff097a19ULL, 0x000fe20000011609ULL, 0x00000001040f7824ULL, 0x040fe200078e020fULL,
0x00005a00ff057a19ULL, 0x000fe2000001160cULL, 0x0000000104117824ULL, 0x000fe400078e0211ULL,
0x0000008209047224ULL, 0x000fe400078e020fULL, 0x00000010030c7824ULL, 0x000fc400078e00ffULL,
0x0000008205087224ULL, 0x000fe400078e0211ULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x000000f00c0f7812ULL, 0x000fc600078ec0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000f04047212ULL, 0x000fc600078efcffULL, 0x000000100a117824ULL, 0x000fe200078e00ffULL,
0x0000000f08087212ULL, 0x000fe200078efcffULL, 0x00000001100a7824ULL, 0x000fe200078e0203ULL,
0x00005e0004047a10ULL, 0x000fe20007f5e0ffULL, 0x00000010100f7824ULL, 0x000fe200078e00ffULL,
0xfffffff011067812ULL, 0x000fe400078ee206ULL, 0x00005e0008087a10ULL, 0x000fe40007f7e0ffULL,
0xfffffff00f0a7812ULL, 0x000fe200078ee20aULL, 0x00000010060f7824ULL, 0x000fe200078e00ffULL,
0x00005f0005057a10ULL, 0x000fc400017fe4ffULL, 0x00005f0009097a10ULL, 0x000fe20001ffe4ffULL,
0x000000100a117824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040f7faeULL, 0x0003e8000c101c48ULL, 0x0000000008117faeULL, 0x0003e2000c901c48ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fc40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x0000000503067211ULL, 0x042fe400078fe0ffULL,
0x00000004030c7819ULL, 0x000fe400000006ffULL, 0x00000002060e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000107057824ULL, 0x040fe400078e0206ULL, 0x00000001060a7824ULL, 0x040fe400078e0203ULL,
0x0000000107087824ULL, 0x000fe200078e020eULL, 0x0000000405097c12ULL, 0x000fe2000f8e30ffULL,
0x0000001006117824ULL, 0x000fe200078e00ffULL, 0x00005a00ff057a19ULL, 0x000fe20000011605ULL,
0x000000010e067824ULL, 0x000fe200078e0203ULL, 0x00000004080f7c12ULL, 0x000fe2000f8e30ffULL,
0x0000000104097824ULL, 0x000fe200078e0209ULL, 0xfffffff0110a7812ULL, 0x000fc600078ee20aULL,
0x0000000104047824ULL, 0x000fe200078e020fULL, 0x00005a00ff0f7a19ULL, 0x000fe20000011608ULL,
0x0000008205057224ULL, 0x000fc800078e0209ULL, 0x000000820f087224ULL, 0x000fe200078e0204ULL,
0x000000f00c0f7812ULL, 0x000fe200078ec0ffULL, 0x0000010005047825ULL, 0x000fc800078e00ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x0000000f04047212ULL, 0x000fc800078efcffULL,
0x0000000f08087212ULL, 0x000fe200078efcffULL, 0x000000100e0f7824ULL, 0x000fe200078e00ffULL,
0x00005e0004047a10ULL, 0x000fe40007f1e0ffULL, 0x00005e0008087a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00f067812ULL, 0x000fe200078ee206ULL, 0x000000100a0f7824ULL, 0x000fe200078e00ffULL,
0x00005f0005057a10ULL, 0x000fe400007fe4ffULL, 0x00005f0009097a10ULL, 0x000fe20000ffe4ffULL,
0x0000001006117824ULL, 0x000fc400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040f7faeULL, 0x0003e8000b901c48ULL, 0x0000000008117faeULL, 0x0003e4000b901c48ULL,
0x0000000000067919ULL, 0x000ea20000000000ULL, 0x0000000000047806ULL, 0x002fe200038e0000ULL,
0x00000004ff2f7424ULL, 0x000fc600078e00ffULL, 0x0000000400057300ULL, 0x000eb000000e0000ULL,
0x0000000400087309ULL, 0x000e620000000000ULL, 0x000000060500720cULL, 0x004fe40003f02070ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffff057224ULL, 0x002fc400078e0a08ULL,
0x00006600a2087625ULL, 0x000fd000078e002fULL, 0x01e60405ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01e60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000808047981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0d00720cULL, 0x000fe40003f05270ULL,
0x0000003f04057810ULL, 0x046fe40007ffe0ffULL, 0x000000ff04067810ULL, 0x000fc40007ffe0ffULL,
0x00000006ff057819ULL, 0x000fe40000011605ULL, 0x00000008ff067819ULL, 0x000fca0000011606ULL,
0x0000e6a000008947ULL, 0x000fea0003800000ULL, 0x00000002ff077819ULL, 0x000fe20000011600ULL,
0x00000008007c7824ULL, 0x000fe400078e00ffULL, 0xffffffffff0a7424ULL, 0x000fe200078e00ffULL,
0x03ffffff07097812ULL, 0x000fca00078ec0ffULL, 0x0000000402317824ULL, 0x000fca00078e0209ULL,
0x000000053100720cULL, 0x000fda0003f06070ULL, 0x00000001a2088819ULL, 0x000fe200000006ffULL,
0x00006800ff098624ULL, 0x000fc800078e00ffULL, 0x0000680008088624ULL, 0x000fe400078e0209ULL,
0x00000003ff097424ULL, 0x000fe400078e00ffULL, 0x0000000131088824ULL, 0x000fe200078e0208ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e68c097cff738cULL, 0x0003e20000000000ULL,
0x00006400080e8625ULL, 0x000fe200078e002fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000080e0a8981ULL, 0x000ea2000c1e1900ULL, 0x0000000102117810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff107424ULL, 0x000fe200078e00ffULL, 0x00000001ff087819ULL, 0x000fe20000011600ULL,
0x01e688007cff7f8cULL, 0x0007e2000c80043fULL, 0x000000061100720cULL, 0x000fc60003f06070ULL,
0x0000002008097824ULL, 0x002fc800078e00ffULL, 0x0000010002117824ULL, 0x000fe400078e0209ULL,
0x000059000a0d7a24ULL, 0x004fe400078e02ffULL, 0x000000400b0a7824ULL, 0x000fe200078e00ffULL,
0x00000001000b7812ULL, 0x000fe400078ec0ffULL, 0x000000060d0d7819ULL, 0x000fe400000006ffULL,
0x000000200a277812ULL, 0x000fc600078ef811ULL, 0x000062000d0e7625ULL, 0x000fe200078e0010ULL,
0x0000064000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1c7819ULL, 0x008fe20000011603ULL,
0x00000002081f7824ULL, 0x000fe200078e020bULL, 0x00000011040d7217ULL, 0x000fe40007800000ULL,
0x000000041c107810ULL, 0x040fe40007ffe0ffULL, 0x0000000c1c1a7810ULL, 0x040fe20007ffe0ffULL,
0x000000010d0d7824ULL, 0x000fe200078e0a11ULL, 0x000000081c147810ULL, 0x000fe20007ffe0ffULL,
0x0000000110117824ULL, 0x100fe200078e0203ULL, 0x000000700c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000810207824ULL, 0x000fe200078e00ffULL, 0x000000200d1d7817ULL, 0x000fe20003800000ULL,
0x000000011a137824ULL, 0x000fe200078e0203ULL, 0x000000141c287810ULL, 0x000fe20007ffe0ffULL,
0x000000081a247824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee211ULL,
0x0000000114127824ULL, 0x000fe200078e0203ULL, 0x0000001d1000720cULL, 0x080fe20003f86070ULL,
0x0000000814157824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee213ULL,
0x000000800b0c7824ULL, 0x000fe200078e020cULL, 0x0000001027137210ULL, 0x040fe20007ffe0ffULL,
0x0000000127117824ULL, 0x000fe200078e021cULL, 0xfffffff815227812ULL, 0x000fe200078ee212ULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x000000101c1e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000128177824ULL, 0x000fe200078e0203ULL, 0x0000001d1400720cULL, 0x080fe20003f66070ULL,
0x0000010011107825ULL, 0x000fe200078e000cULL, 0x0000001d1a00720cULL, 0x000fc40003f46070ULL,
0x0000001d1c00720cULL, 0x000fe20003fa6070ULL, 0x0000010013127825ULL, 0x000fe200078e000cULL,
0x000000100e167210ULL, 0x000fe40007f1e0ffULL, 0x000160001f1f7811ULL, 0x000fe200078e68ffULL,
0x00000008282a7824ULL, 0x000fe200078e00ffULL, 0x000000120e187210ULL, 0x000fe20007f3e0ffULL,
0x000000011e157824ULL, 0x040fe400078e0203ULL, 0x000000081e267824ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee217ULL, 0x000000010f177824ULL, 0x000fc400000e0611ULL,
0x0000000127117824ULL, 0x000fe200078e0214ULL, 0xfffffff826267812ULL, 0x000fe200078ee215ULL,
0x000000010f197824ULL, 0x000fe200008e0613ULL, 0x0000001a27137210ULL, 0x000fe20007ffe0ffULL,
0x0000010011107825ULL, 0x000fe200078e000cULL, 0x0000001d1e00720cULL, 0x000fc60003f26070ULL,
0x000000011c147824ULL, 0x000fe200078e0203ULL, 0x000000100e1a7210ULL, 0x000fe20007f1e0ffULL,
0x0000010013127825ULL, 0x000fc800078e000cULL, 0x0000000127157824ULL, 0x000fe200078e021eULL,
0x00000007141e7812ULL, 0x000fe200078ec0ffULL, 0x000000010f1b7824ULL, 0x000fe200000e0611ULL,
0x000000120e127210ULL, 0x000fe20007fde0ffULL, 0x0000010015147825ULL, 0x000fe200078e000cULL,
0x0ffffff81e1e7812ULL, 0x000fe400078ef803ULL, 0x0000001d2800720cULL, 0x000fe20003f06070ULL,
0x0000000127117824ULL, 0x000fe400078e0228ULL, 0x000000010f137824ULL, 0x000fe200030e0613ULL,
0x000000140e147210ULL, 0x000fe20007fde0ffULL, 0x000000101e217824ULL, 0x000fe200078e021fULL,
0x000000181c1e7810ULL, 0x000fe20007ffe0ffULL, 0x0000010011107825ULL, 0x000fc600078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000016217faeULL, 0x0003e2000e901c48ULL,
0x0000001020237824ULL, 0x000fe200078e021fULL, 0x0000001c1c207810ULL, 0x000fe20007ffe0ffULL,
0x000000010f157824ULL, 0x000fe200030e0615ULL, 0x000000100e1c7210ULL, 0x000fe20007fde0ffULL,
0x0000000127257824ULL, 0x040fe200078e021eULL, 0x0000000018237faeULL, 0x0005e2000e101c48ULL,
0x0000001d1e00720cULL, 0x080fe20003fa6070ULL, 0x0000000127277824ULL, 0x000fe200078e0220ULL,
0x0000001d2000720cULL, 0x000fe40003f86070ULL, 0x000000110f1d7210ULL, 0x000fe200037fe4ffULL,
0x0000010025107825ULL, 0x000fc800078e000cULL, 0x000000011e167824ULL, 0x102fe200078e0203ULL,
0x000000100e107210ULL, 0x000fe20007fde0ffULL, 0x000000081e217824ULL, 0x000fe200078e00ffULL,
0x0000001f2a237211ULL, 0x004fe200078e20ffULL, 0x0000000120177824ULL, 0x040fe400078e0203ULL,
0x0000000820187824ULL, 0x000fe200078e00ffULL, 0xfffffff821167812ULL, 0x000fe200078ee216ULL,
0x00000100270c7825ULL, 0x000fc600078e000cULL, 0xfffffff818187812ULL, 0x000fe200078ee217ULL,
0x000000010f117824ULL, 0x040fe200030e0611ULL, 0x0000000c0e0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001022177824ULL, 0x100fe400078e021fULL, 0x0000001024197824ULL, 0x100fe400078e021fULL,
0x0000001026217824ULL, 0x100fe200078e021fULL, 0x000000001a177faeULL, 0x0003e2000d901c48ULL,
0x0000001016257824ULL, 0x100fe400078e021fULL, 0x00000010181f7824ULL, 0x000fe200078e021fULL,
0x0000000012197faeULL, 0x0003e2000d101c48ULL, 0x000000010f0d7824ULL, 0x000fc600030e060dULL,
0x0000000014217faeULL, 0x0003e8000c901c48ULL, 0x000000001c237faeULL, 0x0003e8000c101c48ULL,
0x0000000010257faeULL, 0x0003e8000e901c48ULL, 0x000000000c1f7faeULL, 0x0003e2000e101c48ULL,
0x0000057000007947ULL, 0x000fea0003800000ULL, 0x0000000803127811ULL, 0x048fe200078fe8ffULL,
0x00000002081d7824ULL, 0x000fe200078e020bULL, 0x0000000403107811ULL, 0x000fc400078fe8ffULL,
0x0000001003167811ULL, 0x040fe200078fe8ffULL, 0x0000000112117824ULL, 0x140fe200078e0203ULL,
0x0000000c03147811ULL, 0x040fe200078fe8ffULL, 0x0000000812227824ULL, 0x000fe200078e00ffULL,
0x0000001403187811ULL, 0x040fe200078fe8ffULL, 0x00000001100d7824ULL, 0x040fe200078e0203ULL,
0x00000018031a7811ULL, 0x040fe200078fe8ffULL, 0x0000000810207824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee211ULL, 0x0000000816267824ULL, 0x040fe200078e00ffULL,
0x0000000316117210ULL, 0x080fe20007ffe0ffULL, 0x0000000814247824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee20dULL, 0x00000001140d7824ULL, 0x100fe200078e0203ULL,
0x0000001c031e7811ULL, 0x040fe200078fe8ffULL, 0x0000000118137824ULL, 0x100fe200078e0203ULL,
0x000000700c1c7812ULL, 0x000fe200078ec0ffULL, 0x0000000818287824ULL, 0x000fe200078e00ffULL,
0x00000003030c7211ULL, 0x000fe200078fe8ffULL, 0x000000011a157824ULL, 0x000fe200078e0203ULL,
0xfffffff826267812ULL, 0x000fe200078ee211ULL, 0x000000081a2a7824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee20dULL, 0x0000000127117824ULL, 0x000fe200078e0210ULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000011e107824ULL, 0x040fe200078e0203ULL,
0x00000027030d7211ULL, 0x000fe200078fe8ffULL, 0x000000081e217824ULL, 0x000fe200078e00ffULL,
0x000160001d2d7811ULL, 0x000fe200078e68ffULL, 0x000000800b1c7824ULL, 0x000fe200078e021cULL,
0xfffffff828287812ULL, 0x000fe200078ee213ULL, 0x000000ffff1d7224ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee215ULL, 0x0000000127137824ULL, 0x040fe200078e0212ULL,
0x0000001427157210ULL, 0x040fe20007ffe0ffULL, 0x00000001271f7824ULL, 0x000fe200078e021eULL,
0xfffffff8212c7812ULL, 0x000fe200078ee210ULL, 0x0000010011107825ULL, 0x000fe200078e001cULL,
0x0ffffff80c1e7812ULL, 0x000fc400078ef803ULL, 0x0000002d22237211ULL, 0x000fe200078e20ffULL,
0x000001000d0c7825ULL, 0x000fe200078e001cULL, 0x000000100e107210ULL, 0x000fc60007f3e0ffULL,
0x0000010013127825ULL, 0x000fe200078e001cULL, 0x0000000c0e0c7210ULL, 0x000fc60007f1e0ffULL,
0x0000000127177824ULL, 0x040fe200078e0216ULL, 0x000000120e127210ULL, 0x000fe20007f5e0ffULL,
0x0000000127197824ULL, 0x000fe400078e0218ULL, 0x0000010015147825ULL, 0x000fc800078e001cULL,
0x00000001271b7824ULL, 0x000fe200078e021aULL, 0x000000140e147210ULL, 0x000fe20007f7e0ffULL,
0x0000010017167825ULL, 0x000fc800078e001cULL, 0x0000010019187825ULL, 0x000fc800078e001cULL,
0x000001001b1a7825ULL, 0x000fc800078e001cULL, 0x000001001f1c7825ULL, 0x000fc800078e001cULL,
0x000000010f0d7824ULL, 0x040fe200000e060dULL, 0x000000160e167210ULL, 0x040fe20007f1e0ffULL,
0x000000010f117824ULL, 0x040fe200008e0611ULL, 0x000000180e187210ULL, 0x000fe20007f3e0ffULL,
0x000000101e1f7824ULL, 0x000fe200078e022dULL, 0x000000170f177210ULL, 0x040fe200007fe4ffULL,
0x000000010f137824ULL, 0x040fe200010e0613ULL, 0x0000001a0e1a7210ULL, 0x000fe20007f5e0ffULL,
0x0000001020217824ULL, 0x000fe200078e022dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c1f7faeULL, 0x0003e2000b901c48ULL, 0x000000010f157824ULL, 0x000fe200018e0615ULL,
0x0000001c0e0e7210ULL, 0x000fe20007f7e0ffULL, 0x0000001024257824ULL, 0x100fe200078e022dULL,
0x0000000010217faeULL, 0x0003e2000b901c48ULL, 0x0000001026277824ULL, 0x000fc400078e022dULL,
0x0000001028297824ULL, 0x000fe200078e022dULL, 0x0000000012237faeULL, 0x0003e2000b901c48ULL,
0x000000010f197824ULL, 0x040fe400008e0619ULL, 0x000000102a2b7824ULL, 0x000fe200078e022dULL,
0x0000000014257faeULL, 0x0003e2000b901c48ULL, 0x000000010f1b7824ULL, 0x040fe400010e061bULL,
0x000000102c2d7824ULL, 0x000fe200078e022dULL, 0x0000000016277faeULL, 0x0003e2000b901c48ULL,
0x000000010f0f7824ULL, 0x000fc600018e061dULL, 0x0000000018297faeULL, 0x0003e8000b901c48ULL,
0x000000001a2b7faeULL, 0x0003e8000b901c48ULL, 0x000000000e2d7faeULL, 0x0003e4000b901c48ULL,
0x00000300ff0c7624ULL, 0x002fe200078e00ffULL, 0x00000003310d7812ULL, 0x000fe200078ec0ffULL,
0xffffffffff1f7424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xfffffffd2f817424ULL, 0x000fe200078e020cULL, 0x000000030d00780cULL, 0x000fc80003f05270ULL,
0x0000000181207807ULL, 0x000fca0004000000ULL, 0x0000000131207824ULL, 0x000fca00078e0220ULL,
0x000000052000720cULL, 0x000fda0003f06070ULL, 0x00000002a20c8824ULL, 0x000fe400078e00ffULL,
0x00006800ff0d8624ULL, 0x000fc800078e00ffULL, 0x000068000c0d8624ULL, 0x000fc800078e020dULL,
0x000000010d0c8824ULL, 0x000fc800078e0220ULL, 0x000064000c0c8625ULL, 0x000fca00078e002fULL,
0x000000080c1f8981ULL, 0x000322000c1e1900ULL, 0x000000060200720cULL, 0x000fe20003f06070ULL,
0x000000ffff237224ULL, 0x000fe200078e00ffULL, 0xff31721700217802ULL, 0x000fe20000000f00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x0000800000000947ULL, 0x000fea0003800000ULL, 0x00000002a20c7824ULL, 0x002fe400078e00ffULL,
0x00006800ff0d7624ULL, 0x000fc400078e00ffULL, 0xff317217ff217424ULL, 0x000fe400078e00ffULL,
0x000000ffff2b7224ULL, 0x000fe400078e00ffULL, 0x000068000c0c7624ULL, 0x000fc400078e020dULL,
0x00000010000d7824ULL, 0x000fe200078e00ffULL, 0x0000000102137810ULL, 0x000fe20007ffe0ffULL,
0x000059001f1f7a24ULL, 0x010fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe00d0d7812ULL, 0x000fe200078ec0ffULL, 0x00000100ff157424ULL, 0x020fe200078e00ffULL,
0x000000061300720cULL, 0x000fe20003f06070ULL, 0x000000401f147824ULL, 0x000fe400078e00ffULL,
0x00000100020d7824ULL, 0x000fe400078e020dULL, 0x0000620014147625ULL, 0x000fc600078e0015ULL,
0x000000400d177810ULL, 0x000fc80007ffe0ffULL, 0x00000020170d7812ULL, 0x000fc800078ec0ffULL,
0x0000000d0a227210ULL, 0x000fe20007ffe0ffULL, 0x0000068000008947ULL, 0x000fea0003800000ULL,
0x0000001003137824ULL, 0x000fe200078e00ffULL, 0x00000003ff687819ULL, 0x000fe20000011603ULL,
0x0000008000167824ULL, 0x000fe200078e00ffULL, 0x00000017040d7217ULL, 0x000fe40007800000ULL,
0x0000007013197812ULL, 0x000fe200078ec0ffULL, 0x0000200000137824ULL, 0x000fe200078e00ffULL,
0x00000004681a7810ULL, 0x040fe20007ffe0ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0a17ULL,
0x00000008681c7810ULL, 0x000fc40007ffe0ffULL, 0x0000008019167812ULL, 0x000fe200078ef816ULL,
0x000000011a177824ULL, 0x140fe200078e0203ULL, 0x0000200013137812ULL, 0x000fe200078ec0ffULL,
0x000000081a6a7824ULL, 0x000fe200078e00ffULL, 0x0000000c68247810ULL, 0x000fe20007ffe0ffULL,
0x000000011c187824ULL, 0x000fe200078e0203ULL, 0x0000001068707810ULL, 0x000fe20007ffe0ffULL,
0x000000081c197824ULL, 0x000fe200078e00ffULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee217ULL,
0x0000400008137824ULL, 0x000fe200078e0213ULL, 0x0000001468747810ULL, 0x000fe20007ffe0ffULL,
0x0000000170177824ULL, 0x100fe200078e0203ULL, 0xfffffff8196c7812ULL, 0x000fe200078ee218ULL,
0x0000000824197824ULL, 0x040fe200078e00ffULL, 0x0000000324087210ULL, 0x000fe20007ffe0ffULL,
0x0000000870727824ULL, 0x000fe200078e00ffULL, 0x000000200d0d7817ULL, 0x000fe20003800000ULL,
0x0000000174187824ULL, 0x040fe200078e0203ULL, 0xfffffff8196e7812ULL, 0x000fe200078ee208ULL,
0x00000008741b7824ULL, 0x000fe200078e00ffULL, 0xfffffff872727812ULL, 0x000fe200078ee217ULL,
0x0000000168197824ULL, 0x000fe200078e0222ULL, 0x000000221c1d7210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e00ffULL, 0xfffffff81b767812ULL, 0x000fe200078ee218ULL,
0x000000011a1b7824ULL, 0x040fe200078e0222ULL, 0x0000000d1a00720cULL, 0x080fe20003f66070ULL,
0x0000010019187825ULL, 0x000fe200078e0016ULL, 0x0000000d2400720cULL, 0x000fc40003f26070ULL,
0x0000000d6800720cULL, 0x0c0fe20003f86070ULL, 0x0000000168087824ULL, 0x000fe200078e0203ULL,
0x00000018141e7210ULL, 0x000fe20007f5e0ffULL, 0x0000000124257824ULL, 0x100fe200078e0222ULL,
0x0000000d1c00720cULL, 0x000fe20003f06070ULL, 0x0000000174697824ULL, 0x000fe200078e0222ULL,
0x0000000708087812ULL, 0x000fe200078ec0ffULL, 0x00000001151f7824ULL, 0x000fe200010e0619ULL,
0x0001700013137810ULL, 0x000fe20007ffe0ffULL, 0x000001001b187825ULL, 0x000fe200078e0016ULL,
0x0ffffff808087812ULL, 0x000fc600078ef803ULL, 0x000001001d1a7825ULL, 0x000fe200078e0016ULL,
0x0000001814247210ULL, 0x000fc60007f5e0ffULL, 0x00000100251c7825ULL, 0x000fe200078e0016ULL,
0x0000001a14267210ULL, 0x000fc60007fbe0ffULL, 0x0000000115257824ULL, 0x040fe200010e0619ULL,
0x0000001c141c7210ULL, 0x000fe20007fde0ffULL, 0x0000000170197824ULL, 0x040fe200078e0222ULL,
0x0000000d7000720cULL, 0x080fe20003f46070ULL, 0x0000000115277824ULL, 0x000fe200028e061bULL,
0x0000000d7400720cULL, 0x080fe20003fa6070ULL, 0x00000010081b7824ULL, 0x100fe200078e0213ULL,
0x0000001868087810ULL, 0x000fe20007ffe0ffULL, 0x000000106a6b7824ULL, 0x000fe200078e0213ULL,
0x0000001c686a7810ULL, 0x000fe20007ffe0ffULL, 0x0000010019187825ULL, 0x000fe200078e0016ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e1b7faeULL, 0x0003e2000e101c48ULL,
0x0000000d0800720cULL, 0x000fc40003f86070ULL, 0x00000001151d7824ULL, 0x000fe200030e061dULL,
0x00000000246b7faeULL, 0x0005e2000d901c48ULL, 0x0000001814687210ULL, 0x000fe40007fde0ffULL,
0x0000000d6a00720cULL, 0x000fe40003f66070ULL, 0x00000022080d7210ULL, 0x000fe20007ffe0ffULL,
0x00000100691a7825ULL, 0x002fc800078e0016ULL, 0x0000000115697824ULL, 0x000fe200030e0619ULL,
0x0000001a141a7210ULL, 0x000fe20007fde0ffULL, 0x000001000d187825ULL, 0x000fc800078e0016ULL,
0x000000016a1f7824ULL, 0x000fe400078e0222ULL, 0x00000001151b7824ULL, 0x000fe200030e061bULL,
0x0000001814187210ULL, 0x000fe20007fde0ffULL, 0x00000001081e7824ULL, 0x140fe400078e0203ULL,
0x00000008080d7824ULL, 0x000fe400078e00ffULL, 0x000000016a087824ULL, 0x040fe400078e0203ULL,
0x000000086a257824ULL, 0x004fe200078e00ffULL, 0xfffffff80d1e7812ULL, 0x000fe200078ee21eULL,
0x000001001f167825ULL, 0x000fe200078e0016ULL, 0x000000136e1f7211ULL, 0x000fc400078e20ffULL,
0xfffffff825087812ULL, 0x000fe200078ee208ULL, 0x0000000115197824ULL, 0x040fe200030e0619ULL,
0x0000001614147210ULL, 0x000fe20007fde0ffULL, 0x000000106c0d7824ULL, 0x100fe400078e0213ULL,
0x0000001072257824ULL, 0x100fe400078e0213ULL, 0x00000010766b7824ULL, 0x100fe200078e0213ULL,
0x00000000260d7faeULL, 0x0003e2000c101c48ULL, 0x000000101e6d7824ULL, 0x100fe400078e0213ULL,
0x0000001008137824ULL, 0x000fe200078e0213ULL, 0x000000001c1f7faeULL, 0x0003e2000c901c48ULL,
0x0000000115157824ULL, 0x000fc600030e0617ULL, 0x0000000068257faeULL, 0x0003e8000d101c48ULL,
0x000000001a6b7faeULL, 0x0003e8000e901c48ULL, 0x00000000186d7faeULL, 0x0003e8000e101c48ULL,
0x0000000014137faeULL, 0x0003e2000d901c48ULL, 0x000005b000007947ULL, 0x000fea0003800000ULL,
0x00000010030d7824ULL, 0x040fe200078e00ffULL, 0x0000000c031d7811ULL, 0x040fe200078fe8ffULL,
0x0000008000687824ULL, 0x040fe200078e00ffULL, 0x00000008031b7811ULL, 0x000fe200078fe8ffULL,
0x0000200000137824ULL, 0x000fe200078e00ffULL, 0x000000700d0d7812ULL, 0x000fe200078ec0ffULL,
0x000000011d167824ULL, 0x100fe200078e0203ULL, 0x0000000403197811ULL, 0x000fe200078fe8ffULL,
0x000000081d257824ULL, 0x000fe200078e00ffULL, 0x000000800d687812ULL, 0x000fe200078ef868ULL,
0x000000011b0d7824ULL, 0x000fe200078e0203ULL, 0x0000200013137812ULL, 0x000fe200078ec0ffULL,
0x000000081b6c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8256e7812ULL, 0x000fe200078ee216ULL,
0x0000000819177824ULL, 0x000fe200078e00ffULL, 0x0000001403257811ULL, 0x000fe200078fe8ffULL,
0x0000400008137824ULL, 0x000fe200078e0213ULL, 0xfffffff86c6c7812ULL, 0x000fe200078ee20dULL,
0x000000011b1b7824ULL, 0x100fe200078e0222ULL, 0x0000001803277811ULL, 0x000fe200078fe8ffULL,
0x00000001250d7824ULL, 0x000fe200078e0203ULL, 0x0000000319087210ULL, 0x080fe20007ffe0ffULL,
0x0000000825727824ULL, 0x000fe200078e00ffULL, 0x00000010031f7811ULL, 0x000fe200078fe8ffULL,
0x0000000827697824ULL, 0x040fe200078e00ffULL, 0x0000000327167210ULL, 0x000fe20007ffe0ffULL,
0x0000000119197824ULL, 0x100fe200078e0222ULL, 0xfffffff872727812ULL, 0x000fe200078ee20dULL,
0x000000011d1d7824ULL, 0x100fe200078e0222ULL, 0x0000001c030d7811ULL, 0x000fe200078fe8ffULL,
0x0000000125257824ULL, 0x000fe200078e0222ULL, 0xfffffff8176a7812ULL, 0x000fe200078ee208ULL,
0x000000011f087824ULL, 0x100fe200078e0203ULL, 0xfffffff869747812ULL, 0x000fe200078ee216ULL,
0x000000081f177824ULL, 0x000fe200078e00ffULL, 0x0001700013757810ULL, 0x000fe20007ffe0ffULL,
0x000000010d167824ULL, 0x000fc400078e0203ULL, 0x000000080d697824ULL, 0x000fe200078e00ffULL,
0xfffffff817707812ULL, 0x000fe200078ee208ULL, 0x000000011f1f7824ULL, 0x100fe200078e0222ULL,
0x000000220d0d7210ULL, 0x080fe20007ffe0ffULL, 0x0000000127277824ULL, 0x000fe200078e0222ULL,
0x0000002203177211ULL, 0x000fe200078fe8ffULL, 0x000000106a137824ULL, 0x100fe200078e0275ULL,
0xfffffff869227812ULL, 0x000fe200078ee216ULL, 0x000000ffff697224ULL, 0x000fe200078e00ffULL,
0x0000000303087211ULL, 0x000fe200078fe8ffULL, 0x000000106c6b7824ULL, 0x000fc400078e0275ULL,
0x0000010017167825ULL, 0x000fe200078e0068ULL, 0x0000000708087812ULL, 0x000fc600078ec0ffULL,
0x0000010019187825ULL, 0x000fe200078e0068ULL, 0x0000001614167210ULL, 0x000fe40007f1e0ffULL,
0x0ffffff808087812ULL, 0x000fe200078ef803ULL, 0x000001001b1a7825ULL, 0x100fe200078e0068ULL,
0x0000001814187210ULL, 0x040fe40007f3e0ffULL, 0x0000001715177210ULL, 0x000fe200007fe4ffULL,
0x000001001d1c7825ULL, 0x000fe200078e0068ULL, 0x0000001a141a7210ULL, 0x000fc60007f5e0ffULL,
0x000001001f1e7825ULL, 0x000fe200078e0068ULL, 0x0000001c141c7210ULL, 0x000fc60007f7e0ffULL,
0x0000010025247825ULL, 0x000fe200078e0068ULL, 0x0000001e141e7210ULL, 0x000fc60007f1e0ffULL,
0x0000010027267825ULL, 0x000fc800078e0068ULL, 0x000001000d687825ULL, 0x000fc800078e0068ULL,
0x0000000115197824ULL, 0x040fe200008e0619ULL, 0x0000002414247210ULL, 0x000fe20007f3e0ffULL,
0x00000010080d7824ULL, 0x000fe400078e0275ULL, 0x00000001151b7824ULL, 0x040fe200010e061bULL,
0x0000002614267210ULL, 0x040fe20007f5e0ffULL, 0x00000001151d7824ULL, 0x000fe200018e061dULL,
0x0000006814147210ULL, 0x000fe20007f7e0ffULL, 0x000000106e6d7824ULL, 0x100fe200078e0275ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000160d7faeULL, 0x0003e2000b901c48ULL,
0x00000010706f7824ULL, 0x000fc400078e0275ULL, 0x00000001151f7824ULL, 0x040fe200000e061fULL,
0x0000000018137faeULL, 0x0003e2000b901c48ULL, 0x0000001072717824ULL, 0x000fe400078e0275ULL,
0x0000000115257824ULL, 0x040fe200008e0625ULL, 0x000000001a6b7faeULL, 0x0003e2000b901c48ULL,
0x0000001074737824ULL, 0x000fe400078e0275ULL, 0x0000000115277824ULL, 0x000fe200010e0627ULL,
0x000000001c6d7faeULL, 0x0003e2000b901c48ULL, 0x0000001022757824ULL, 0x000fc400078e0275ULL,
0x0000000115157824ULL, 0x000fe200018e0669ULL, 0x000000001e6f7faeULL, 0x0003e8000b901c48ULL,
0x0000000024717faeULL, 0x0003e8000b901c48ULL, 0x0000000026737faeULL, 0x0003e8000b901c48ULL,
0x0000000014757faeULL, 0x0003e4000b901c48ULL, 0x0000000320087812ULL, 0x000fe200078ec0ffULL,
0xffffffffff1f7424ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000030800780cULL, 0x000fc80003f05270ULL, 0x00000001810d7807ULL, 0x000fca0004000000ULL,
0x000000010d207824ULL, 0x000fca00078e0220ULL, 0x000000052000720cULL, 0x000fda0003f06070ULL,
0x0000000400158802ULL, 0x000fe20000000f00ULL, 0x000000010c148824ULL, 0x000fc800078e0220ULL,
0x0000640014148625ULL, 0x000fca00078e0015ULL, 0x00000008141f8981ULL, 0x000322000c1e1900ULL,
0xffffffe07c087812ULL, 0x040fe400078ec0ffULL, 0x000000107c0d7812ULL, 0x040fe400078ec0ffULL,
0x000000087c137812ULL, 0x000fc800078ec0ffULL, 0x0000000813087210ULL, 0x000fe20007ffe00dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e6080008187f8cULL, 0x0022a4000c80043fULL,
0x0000000000147805ULL, 0x000fc40000015200ULL, 0x01e60c00080d7984ULL, 0x000ee40000000800ULL,
0x800000000dff7812ULL, 0x00cfe40007804819ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff137224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614167210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09001600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc80000011417ULL, 0x000000160d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff167224ULL, 0x000fca00000e0617ULL, 0x000000020d0d7819ULL, 0x000fc80000001216ULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000113137810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e60c00080d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe40007804819ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010030d7824ULL, 0x000fe200078e00ffULL,
0x00000001ff7d7819ULL, 0x000fe20000011603ULL, 0x0000002000087824ULL, 0x002fc600078e00ffULL,
0x000000700d0d7812ULL, 0x000fe400078ec0ffULL, 0xffffff8008087812ULL, 0x000fe400078ec0ffULL,
0x0000000c7d7d7812ULL, 0x000fc800078ec0ffULL, 0x000000087d087210ULL, 0x000fca0007ffe00dULL,
0x01e0000008147984ULL, 0x000e680000000800ULL, 0x01e2000008137984ULL, 0x0004e20000000800ULL,
0x000000211400720bULL, 0x002fe20003f1d000ULL, 0x000169927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000157806ULL, 0x004fc800000e0100ULL, 0x000000ff1500720cULL, 0x000fe20003f25270ULL,
0x0000074000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff087224ULL, 0x000fd400078e0021ULL, 0x0000070000009947ULL, 0x000fea0003800000ULL,
0x000000000700720cULL, 0x000fe40003f25270ULL, 0x000000211400720bULL, 0x000fe20003f54000ULL,
0x000169627f007947ULL, 0x000fd8000b800000ULL, 0x0000000000167806ULL, 0x000fc400010e0100ULL,
0x0000008000189824ULL, 0x000fe200078e020dULL, 0x0000002114087209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000017d179824ULL, 0x000fca00078e0218ULL,
0x01e4000817009388ULL, 0x0003e20000000800ULL, 0x000000ff1600720cULL, 0x000fda0003f25270ULL,
0x000005e000009947ULL, 0x000fea0003800000ULL, 0x0000002108177221ULL, 0x002fe20000010100ULL,
0x000000ff16ff7812ULL, 0x000fe2000782c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b17177820ULL, 0x000fcc0000410000ULL, 0x0000001700177308ULL, 0x000e640000000800ULL,
0x0000001723237220ULL, 0x002fe40000410000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000002ff247819ULL, 0x000fe20000011603ULL, 0x000168b27f007947ULL, 0x000fea000b800000ULL,
0x00001f2417247589ULL, 0x0002a400000e0000ULL, 0x0000002464647220ULL, 0x084fe40000410000ULL,
0x0000002465657220ULL, 0x080fe40000410000ULL, 0x0000002460607220ULL, 0x080fe40000410000ULL,
0x0000002461617220ULL, 0x000fc40000410000ULL, 0x000000245c5c7220ULL, 0x080fe40000410000ULL,
0x000000245d5d7220ULL, 0x080fe40000410000ULL, 0x0000002458587220ULL, 0x080fe40000410000ULL,
0x0000002459597220ULL, 0x080fe40000410000ULL, 0x0000002454547220ULL, 0x080fe40000410000ULL,
0x0000002455557220ULL, 0x000fc40000410000ULL, 0x0000002450507220ULL, 0x080fe40000410000ULL,
0x0000002451517220ULL, 0x080fe40000410000ULL, 0x000000244c4c7220ULL, 0x080fe40000410000ULL,
0x000000244d4d7220ULL, 0x080fe40000410000ULL, 0x0000002448487220ULL, 0x080fe40000410000ULL,
0x0000002449497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0016ff7812ULL, 0x000fe2000782c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x0000000803247811ULL, 0x000fe200078ff0ffULL,
0x000167a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2417247589ULL, 0x00046400000e0000ULL,
0x0000002466667220ULL, 0x086fe40000410000ULL, 0x0000002467677220ULL, 0x080fe40000410000ULL,
0x0000002462627220ULL, 0x080fe40000410000ULL, 0x0000002463637220ULL, 0x080fe40000410000ULL,
0x000000245e5e7220ULL, 0x080fe40000410000ULL, 0x000000245f5f7220ULL, 0x000fc40000410000ULL,
0x000000245a5a7220ULL, 0x080fe40000410000ULL, 0x000000245b5b7220ULL, 0x080fe40000410000ULL,
0x0000002456567220ULL, 0x080fe40000410000ULL, 0x0000002457577220ULL, 0x080fe40000410000ULL,
0x0000002452527220ULL, 0x080fe40000410000ULL, 0x0000002453537220ULL, 0x000fc40000410000ULL,
0x000000244e4e7220ULL, 0x080fe40000410000ULL, 0x000000244f4f7220ULL, 0x080fe40000410000ULL,
0x000000244a4a7220ULL, 0x080fe40000410000ULL, 0x000000244b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000016ff7812ULL, 0x000fe2000782c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x0000001003247811ULL, 0x000fe200078ff0ffULL, 0x000166927f007947ULL, 0x000fea000b800000ULL,
0x00001f2417247589ULL, 0x00046400000e0000ULL, 0x0000002444447220ULL, 0x086fe40000410000ULL,
0x0000002445457220ULL, 0x080fe40000410000ULL, 0x0000002440407220ULL, 0x080fe40000410000ULL,
0x0000002441417220ULL, 0x080fe40000410000ULL, 0x000000243c3c7220ULL, 0x080fe40000410000ULL,
0x000000243d3d7220ULL, 0x000fc40000410000ULL, 0x0000002438387220ULL, 0x080fe40000410000ULL,
0x0000002439397220ULL, 0x080fe40000410000ULL, 0x0000002434347220ULL, 0x080fe40000410000ULL,
0x0000002435357220ULL, 0x080fe40000410000ULL, 0x0000002430307220ULL, 0x080fe40000410000ULL,
0x0000002431317220ULL, 0x000fc40000410000ULL, 0x000000242c2c7220ULL, 0x080fe40000410000ULL,
0x000000242d2d7220ULL, 0x080fe40000410000ULL, 0x0000002428287220ULL, 0x080fe40000410000ULL,
0x0000002429297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000016ff7812ULL, 0x000fda000782c0ffULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x0000001803247811ULL, 0x000fe200078ff0ffULL, 0x000165927f007947ULL, 0x000fea000b800000ULL,
0x00001f2417247589ULL, 0x00046400000e0000ULL, 0x0000002446467220ULL, 0x086fe40000410000ULL,
0x0000002447477220ULL, 0x080fe40000410000ULL, 0x0000002442427220ULL, 0x080fe40000410000ULL,
0x0000002443437220ULL, 0x080fe40000410000ULL, 0x000000243e3e7220ULL, 0x080fe40000410000ULL,
0x000000243f3f7220ULL, 0x000fc40000410000ULL, 0x000000243a3a7220ULL, 0x080fe40000410000ULL,
0x000000243b3b7220ULL, 0x080fe40000410000ULL, 0x0000002436367220ULL, 0x080fe40000410000ULL,
0x0000002437377220ULL, 0x080fe40000410000ULL, 0x0000002432327220ULL, 0x080fe40000410000ULL,
0x0000002433337220ULL, 0x000fc40000410000ULL, 0x000000242e2e7220ULL, 0x080fe40000410000ULL,
0x000000242f2f7220ULL, 0x080fe40000410000ULL, 0x000000242a2a7220ULL, 0x080fe40000410000ULL,
0x000000242b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000001615ff7212ULL, 0x000fda00078230ffULL, 0x8000000814141221ULL, 0x000fe20000010000ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b14141820ULL, 0x000fc80000410000ULL,
0x00000014000e1308ULL, 0x000e640000000800ULL, 0x0000000e13131220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000010000007945ULL, 0x000fe20003800000ULL, 0x0000002313237221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x0000000eff0f723eULL, 0x000fe400000000ffULL,
0x00000002ff127819ULL, 0x000fe40000011603ULL, 0x000054100f137816ULL, 0x000fe2000000000fULL,
0x000163e27f007947ULL, 0x000fea000b800000ULL, 0x00001f12130f7589ULL, 0x0002a400000e0000ULL,
0x0000000812247810ULL, 0x000fe20007ffe0ffULL, 0x000164327f007947ULL, 0x000fea000b800000ULL,
0x0000001012147810ULL, 0x000fe20007ffe0ffULL, 0x00001f2413107589ULL, 0x00066800000e0000ULL,
0x00001f1413117589ULL, 0x0006a400000e0000ULL, 0x0000001812247810ULL, 0x008fe20007ffe0ffULL,
0x000164c27f007947ULL, 0x000fea000b800000ULL, 0x00001f2413127589ULL, 0x0022e400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000200217824ULL, 0x040fe200078e00ffULL,
0x0000000803147812ULL, 0x000fe200078ec0ffULL, 0x0000040000167824ULL, 0x040fe200078e00ffULL,
0x0000000d00227819ULL, 0x000fe200000006ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004211c7812ULL, 0x000fe200078ec0ffULL, 0x000002b000007945ULL, 0x000fe20003800000ULL,
0x00000007141a7812ULL, 0x000fc400078ef803ULL, 0x0000001c03157211ULL, 0x040fe400078fe0ffULL,
0x000000101a1e7812ULL, 0x040fe200078efcffULL, 0x000000081a147824ULL, 0x040fe200078e00ffULL,
0x0000001a03177211ULL, 0x000fe200078fe0ffULL, 0x000000011a137824ULL, 0x002fe200078e0215ULL,
0xffffc00022247812ULL, 0x000fe200078ec0ffULL, 0x000000081a187824ULL, 0x000fe200078e00ffULL,
0x00000006171b7810ULL, 0x000fe20007ffe0ffULL, 0x000000081e197824ULL, 0x000fe200078e00ffULL,
0xfffffff814137812ULL, 0x000fe200078ee213ULL, 0x0000000115147824ULL, 0x000fe200078e021eULL,
0x0000000217157810ULL, 0x000fe20007ffe0ffULL, 0x000000081a267824ULL, 0x000fc400078e00ffULL,
0x000020000b247824ULL, 0x000fe200078e0224ULL, 0xfffffff818157812ULL, 0x000fe200078ee215ULL,
0x000000081a687824ULL, 0x000fe200078e00ffULL, 0xfffff00016187812ULL, 0x000fe200078ec0ffULL,
0x000000081a167824ULL, 0x000fe200078e00ffULL, 0xfffffff819147812ULL, 0x000fe400078ee214ULL,
0x0000000417197810ULL, 0x000fe40007ffe0ffULL, 0x0001200018837810ULL, 0x000fe40007ffe0ffULL,
0xfffffff816167812ULL, 0x000fc400078ee217ULL, 0xfffffff826177812ULL, 0x000fe200078ee219ULL,
0x0000001013787824ULL, 0x100fe200078e0283ULL, 0x0001600024197810ULL, 0x000fe20007ffe0ffULL,
0x0000001014247824ULL, 0x000fe200078e0283ULL, 0xfffffff868187812ULL, 0x000fc600078ee21bULL,
0x000000007878783bULL, 0x000e620000000200ULL, 0x0000001016747824ULL, 0x100fe400078e0219ULL,
0x0000001015707824ULL, 0x100fe200078e0219ULL, 0x000000002424783bULL, 0x000ee20000000200ULL,
0x00000010176c7824ULL, 0x000fe200078e0219ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000f78787232ULL, 0x086fe40000000000ULL, 0x0000000f7a7a7232ULL, 0x000fe40000000000ULL,
0x0000001079797232ULL, 0x000fc40000000000ULL, 0x000000107b7b7232ULL, 0x000fe40000000000ULL,
0x0000001124247232ULL, 0x088fe40000000000ULL, 0x0000001126267232ULL, 0x000fe40000000000ULL,
0x0000001225257232ULL, 0x080fe40000000000ULL, 0x0000001227277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001918687211ULL, 0x000fe200078e20ffULL,
0x000000006c6c783bULL, 0x000ee20000004200ULL, 0x000000021c1c7812ULL, 0x000fe200078efcffULL,
0x000000081a1d7824ULL, 0x000fe200078e00ffULL, 0x00000001ff847819ULL, 0x000fe20000011600ULL,
0x000000007474783bULL, 0x000fe20000004200ULL, 0x0000001c03197211ULL, 0x000fe200078fe0ffULL,
0x000000081e1c7824ULL, 0x000fe200078e00ffULL, 0x0000035000007945ULL, 0x000fe20003800000ULL,
0x000000006868783bULL, 0x000ea40000004200ULL, 0x000000011a1a7824ULL, 0x000fc400078e0219ULL,
0x000000007070783bULL, 0x000e620000004200ULL, 0x000000011e1b7824ULL, 0x000fe400078e0219ULL,
0xfffffff81d197812ULL, 0x000fc600078ee21aULL, 0xfffffff81c1a7812ULL, 0x000fe200078ee21bULL,
0x000000081e1b7824ULL, 0x000fe200078e00ffULL, 0x0000001e031c7211ULL, 0x000fc800078fe0ffULL,
0x000000021c1d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee21cULL,
0x0000006c7854723cULL, 0x08af700000001854ULL, 0x0000006c2434723cULL, 0x000b6e0000001834ULL,
0x000000081e6c7824ULL, 0x060fe200078e00ffULL, 0x0000006e7850723cULL, 0x000f620000001850ULL,
0x000000081e6d7824ULL, 0x000fce00078e00ffULL, 0x00000068784c723cULL, 0x004f70000000184cULL,
0x0000006e2430723cULL, 0x040b6e0000001830ULL, 0x000000081e6f7824ULL, 0x020fe200078e00ffULL,
0x00000068242c723cULL, 0x000b62000000182cULL, 0x000000041c1e7810ULL, 0x000fcc0007ffe0ffULL,
0x0000000284697824ULL, 0x020fe200078e020bULL, 0x000000747864723cULL, 0x040f620000001864ULL,
0x000000061c687810ULL, 0x000fe40007ffe0ffULL, 0xfffffff86c1c7812ULL, 0x000fe400078ee21dULL,
0xfffffff86d1d7812ULL, 0x000fe400078ee21eULL, 0x0001600069697811ULL, 0x000fe200078e68ffULL,
0x000000767860723cULL, 0x000f620000001860ULL, 0xfffffff86f1e7812ULL, 0x000fc600078ee268ULL,
0x000000101b6c7824ULL, 0x000fc800078e0269ULL, 0x00000070785c723cULL, 0x040f70000000185cULL,
0x000000727858723cULL, 0x040f700000001858ULL, 0x0000006a7848723cULL, 0x000b6e0000001848ULL,
0x0000008319787211ULL, 0x020fe200078e20ffULL, 0x000000742444723cULL, 0x040b6a0000001844ULL,
0x000000007878783bULL, 0x000e640000000200ULL, 0x000000101c747824ULL, 0x120fe200078e0269ULL,
0x000000762440723cULL, 0x040f700000001840ULL, 0x00000070243c723cULL, 0x040b6e000000183cULL,
0x000000101d707824ULL, 0x020fe200078e0269ULL, 0x000000722438723cULL, 0x040f700000001838ULL,
0x0000006a2428723cULL, 0x000b6e0000001828ULL, 0x000000101a247824ULL, 0x020fcc00078e0283ULL,
0x000000002424783bULL, 0x000ea20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000f78787232ULL, 0x082fe40000000000ULL, 0x0000000f7a7a7232ULL, 0x000fe40000000000ULL,
0x0000001079797232ULL, 0x080fe40000000000ULL, 0x000000107b7b7232ULL, 0x000fe40000000000ULL,
0x0000001124247232ULL, 0x084fe40000000000ULL, 0x0000001126267232ULL, 0x000fc40000000000ULL,
0x0000001225257232ULL, 0x080fe40000000000ULL, 0x0000001227277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x002fea0003800000ULL, 0x000000101e687824ULL, 0x000fe200078e0269ULL,
0x000000006c6c783bULL, 0x000e620000004200ULL, 0x000059001f1f7a24ULL, 0x010fe200078e02ffULL,
0xfffffff821217812ULL, 0x000fe400078ec0ffULL, 0x000000007474783bULL, 0x000ee80000004200ULL,
0x000000007070783bULL, 0x000ea80000004200ULL, 0x000000006868783bULL, 0x000ea20000004200ULL,
0x0000006c7864723cULL, 0x042f700000001864ULL, 0x0000006e7860723cULL, 0x040f700000001860ULL,
0x00000074785c723cULL, 0x048f70000000185cULL, 0x000000767858723cULL, 0x040f700000001858ULL,
0x000000707854723cULL, 0x044f700000001854ULL, 0x000000727850723cULL, 0x040f700000001850ULL,
0x00000068784c723cULL, 0x040f70000000184cULL, 0x0000006a7848723cULL, 0x000f700000001848ULL,
0x00000074243c723cULL, 0x040f70000000183cULL, 0x000000762438723cULL, 0x040f700000001838ULL,
0x000000702434723cULL, 0x040f700000001834ULL, 0x000000722430723cULL, 0x040f700000001830ULL,
0x0000006c2444723cULL, 0x040f700000001844ULL, 0x0000006e2440723cULL, 0x040f700000001840ULL,
0x00000068242c723cULL, 0x040f70000000182cULL, 0x0000006a2428723cULL, 0x000b6e0000001828ULL,
0x0000000802247824ULL, 0x020fe200078e0284ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fcc0000008000ULL,
0x0000000102257810ULL, 0x000fe20007ffe0ffULL, 0x01e6880021ff7f8cULL, 0x0003e2000c80043fULL,
0x0000008024267811ULL, 0x000fe200078e28ffULL, 0x000000401f247824ULL, 0x000fe200078e00ffULL,
0x000000062500720cULL, 0x000fe20003f06070ULL, 0x00000100ff277424ULL, 0x000fe200078e00ffULL,
0x00000020261f7812ULL, 0x000fc600078ec0ffULL, 0x0000620024247625ULL, 0x000fc800078e0027ULL,
0x000000010a767824ULL, 0x000fe200078e021fULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000065000008947ULL, 0x000fea0003800000ULL, 0x00002000221f7812ULL, 0x002fe200078ec0ffULL,
0x0000008000227824ULL, 0x000fe200078e00ffULL, 0x00000003ff747819ULL, 0x100fe40000011603ULL,
0x0000001f84847211ULL, 0x000fe400078e70ffULL, 0x00000008746c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000174697824ULL, 0x000fe200078e0276ULL, 0x00000026041f7217ULL, 0x000fe40007800000ULL,
0x0000000474687810ULL, 0x000fe20007ffe0ffULL, 0x000000016c277824ULL, 0x100fe200078e0203ULL,
0x00000014748a7810ULL, 0x000fe20007ffe0ffULL, 0x000000086c7a7824ULL, 0x000fe200078e00ffULL,
0x0000001074727810ULL, 0x000fe20007ffe0ffULL, 0x000000011f1f7824ULL, 0x000fe200078e0a26ULL,
0x000000800d267812ULL, 0x000fe200078ef822ULL, 0x0000000168217824ULL, 0x000fe200078e0203ULL,
0xfffffff87a7a7812ULL, 0x000fe200078ee227ULL, 0x000000ffff277224ULL, 0x000fe200078e00ffULL,
0x000000201f1f7817ULL, 0x000fe20003800000ULL, 0x0000000868787824ULL, 0x000fe200078e00ffULL,
0x0000000c74227810ULL, 0x000fe20007ffe0ffULL, 0x00000001686b7824ULL, 0x040fe200078e0276ULL,
0x0000001f6800720cULL, 0x000fe20003f86070ULL, 0x0000010069687825ULL, 0x000fe200078e0026ULL,
0xfffffff878787812ULL, 0x000fc400078ee221ULL, 0x0000000322217210ULL, 0x000fe20007ffe0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0026ULL, 0x00000068246e7210ULL, 0x000fe40007f1e0ffULL,
0x0000001f2200720cULL, 0x080fe20003f46070ULL, 0x000000018a6f7824ULL, 0x100fe200078e0203ULL,
0x0000006a24707210ULL, 0x000fe20007f3e0ffULL, 0x000000088a8c7824ULL, 0x000fe200078e00ffULL,
0x0000001f6c00720cULL, 0x080fe20003f66070ULL, 0x0000000822867824ULL, 0x000fe200078e00ffULL,
0x0000001f7400720cULL, 0x000fe20003fa6070ULL, 0x00000001726d7824ULL, 0x000fe200078e0203ULL,
0xfffffff88c8c7812ULL, 0x000fe200078ee26fULL, 0x00000001256f7824ULL, 0x000fe200000e0669ULL,
0xfffffff886867812ULL, 0x000fe200078ee221ULL, 0x000000016c697824ULL, 0x000fe200078e0276ULL,
0x0000000374217210ULL, 0x000fe20007ffe0ffULL, 0x0000000872887824ULL, 0x000fc400078e00ffULL,
0x0000000125717824ULL, 0x000fe200008e066bULL, 0x0000001f7200720cULL, 0x000fe20003f26070ULL,
0x00000001226b7824ULL, 0x000fe200078e0276ULL, 0xfffffff888887812ULL, 0x000fe200078ee26dULL,
0x0000010069687825ULL, 0x100fe200078e0026ULL, 0x0000000721227812ULL, 0x000fe400078ec0ffULL,
0x0001600084217810ULL, 0x000fe20007ffe0ffULL, 0x000001006b6a7825ULL, 0x000fe200078e0026ULL,
0x0ffffff822227812ULL, 0x000fc600078ef803ULL, 0x00000001726d7824ULL, 0x000fe200078e0276ULL,
0x0000006824727210ULL, 0x000fe20007f1e0ffULL, 0x0000001022777824ULL, 0x000fe200078e0221ULL,
0x0000006a246a7210ULL, 0x000fe20007fde0ffULL, 0x000001006d6c7825ULL, 0x000fe200078e0026ULL,
0x0000001874227810ULL, 0x000fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e777faeULL, 0x0003e2000e901c48ULL, 0x0000000125737824ULL, 0x040fe200000e0669ULL,
0x0000001f8a00720cULL, 0x0c0fe20003f06070ULL, 0x000000018a697824ULL, 0x000fe200078e0276ULL,
0x0000001f2200720cULL, 0x000fe20003fa6070ULL, 0x00000001256b7824ULL, 0x000fe200030e066bULL,
0x0000006c246c7210ULL, 0x000fe20007fde0ffULL, 0x0000010069687825ULL, 0x000fc800078e0026ULL,
0x0000001078797824ULL, 0x000fe200078e0221ULL, 0x0000001c74787810ULL, 0x000fe20007ffe0ffULL,
0x00000001256d7824ULL, 0x040fe200030e066dULL, 0x0000006824747210ULL, 0x000fe20007fde0ffULL,
0x00000001227b7824ULL, 0x000fe200078e0276ULL, 0x0000000070797faeULL, 0x0005e2000e101c48ULL,
0x0000001f7800720cULL, 0x000fe20003f86070ULL, 0x00000001226e7824ULL, 0x002fe200078e0203ULL,
0x00000076781f7210ULL, 0x000fe20007ffe0ffULL, 0x0000000125757824ULL, 0x000fe400030e0669ULL,
0x000001007b687825ULL, 0x000fc800078e0026ULL, 0x00000008226f7824ULL, 0x000fe200078e00ffULL,
0x0000006824687210ULL, 0x000fe20007fde0ffULL, 0x0000000178227824ULL, 0x040fe400078e0203ULL,
0x0000000878717824ULL, 0x004fe200078e00ffULL, 0xfffffff86f6e7812ULL, 0x000fe200078ee26eULL,
0x000001001f267825ULL, 0x000fc600078e0026ULL, 0xfffffff871227812ULL, 0x000fe200078ee222ULL,
0x0000000125697824ULL, 0x040fe200030e0669ULL, 0x0000002624247210ULL, 0x000fe20007fde0ffULL,
0x000000107a1f7824ULL, 0x100fe200078e0221ULL, 0x000000216e797211ULL, 0x000fe200078e20ffULL,
0x00000010866f7824ULL, 0x100fe400078e0221ULL, 0x0000001088717824ULL, 0x100fe200078e0221ULL,
0x00000000721f7faeULL, 0x0003e2000d901c48ULL, 0x000000108c777824ULL, 0x100fe400078e0221ULL,
0x0000001022217824ULL, 0x000fe200078e0221ULL, 0x000000006a6f7faeULL, 0x0003e2000d101c48ULL,
0x0000000125257824ULL, 0x000fc600030e0627ULL, 0x000000006c717faeULL, 0x0003e8000c901c48ULL,
0x0000000074777faeULL, 0x0003e8000c101c48ULL, 0x0000000068797faeULL, 0x0003e8000e901c48ULL,
0x0000000024217faeULL, 0x0003e2000e101c48ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x00000008036b7811ULL, 0x002fe200078fe8ffULL, 0x0000008000747824ULL, 0x000fe200078e00ffULL,
0x00002000221f7812ULL, 0x000fc400078ec0ffULL, 0x0000000403697811ULL, 0x000fe200078fe8ffULL,
0x000000016b217824ULL, 0x000fe200078e0203ULL, 0x0000001403717811ULL, 0x000fe200078fe8ffULL,
0x000000086b7a7824ULL, 0x000fe200078e00ffULL, 0x0000000c036d7811ULL, 0x040fe200078fe8ffULL,
0x0000400084847824ULL, 0x000fe200078e021fULL, 0x00000010036f7811ULL, 0x000fe200078fe8ffULL,
0x00000001691f7824ULL, 0x040fe200078e0203ULL, 0xfffffff87a7a7812ULL, 0x000fe200078ee221ULL,
0x0000000869787824ULL, 0x000fe200078e00ffULL, 0x0000001803737811ULL, 0x000fe200078fe8ffULL,
0x0000000171217824ULL, 0x000fe200078e0203ULL, 0x000000800d747812ULL, 0x000fe200078ef874ULL,
0x00000008718a7824ULL, 0x000fe200078e00ffULL, 0xfffffff878787812ULL, 0x000fe200078ee21fULL,
0x000000016d227824ULL, 0x000fe200078e0203ULL, 0x000000036f1f7210ULL, 0x080fe20007ffe0ffULL,
0x000000086d277824ULL, 0x000fe200078e00ffULL, 0xfffffff88a8a7812ULL, 0x000fe200078ee221ULL,
0x000000086f887824ULL, 0x000fe200078e00ffULL, 0x0000001c03217811ULL, 0x000fe200078fe8ffULL,
0x0000000169697824ULL, 0x000fe200078e0276ULL, 0xfffffff827867812ULL, 0x000fe200078ee222ULL,
0x0000000173227824ULL, 0x040fe200078e0203ULL, 0xfffffff888887812ULL, 0x000fe200078ee21fULL,
0x0000000873277824ULL, 0x000fe200078e00ffULL, 0x00000003031f7211ULL, 0x000fe200078fe8ffULL,
0x0000000121267824ULL, 0x100fe200078e0203ULL, 0x000000766f6f7210ULL, 0x080fe20007ffe0ffULL,
0x0000000821757824ULL, 0x000fe200078e00ffULL, 0xfffffff8278c7812ULL, 0x000fe200078ee222ULL,
0x000000016b6b7824ULL, 0x100fe200078e0276ULL, 0x000000071f227812ULL, 0x000fe200078ec0ffULL,
0x000000016d6d7824ULL, 0x100fe200078e0276ULL, 0x0000007603277211ULL, 0x000fe200078fe8ffULL,
0x0000000171717824ULL, 0x100fe200078e0276ULL, 0x0001600084877810ULL, 0x000fe20007ffe0ffULL,
0x0000000173737824ULL, 0x100fe200078e0276ULL, 0x0ffffff822227812ULL, 0x000fe200078ef803ULL,
0x00000001211f7824ULL, 0x000fe200078e0276ULL, 0xfffffff875767812ULL, 0x000fe200078ee226ULL,
0x000000ffff757224ULL, 0x000fe200078e00ffULL, 0x0000008786797211ULL, 0x000fe200078e20ffULL,
0x0000001078217824ULL, 0x000fc400078e0287ULL, 0x0000010027267825ULL, 0x000fc800078e0074ULL,
0x0000010069687825ULL, 0x000fe200078e0074ULL, 0x0000002624267210ULL, 0x000fc60007f1e0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0074ULL, 0x0000006824687210ULL, 0x000fc60007f3e0ffULL,
0x000001006d6c7825ULL, 0x000fe200078e0074ULL, 0x0000006a246a7210ULL, 0x000fc60007f5e0ffULL,
0x000001006f6e7825ULL, 0x000fe200078e0074ULL, 0x0000006c246c7210ULL, 0x000fc60007f7e0ffULL,
0x0000010071707825ULL, 0x000fc800078e0074ULL, 0x0000010073727825ULL, 0x000fc800078e0074ULL,
0x000001001f747825ULL, 0x000fc800078e0074ULL, 0x0000000125277824ULL, 0x040fe200000e0627ULL,
0x0000006e246e7210ULL, 0x000fe20007f1e0ffULL, 0x00000010221f7824ULL, 0x000fe400078e0287ULL,
0x0000000125697824ULL, 0x040fe200008e0669ULL, 0x0000007024707210ULL, 0x040fe20007f3e0ffULL,
0x00000001256b7824ULL, 0x040fe200010e066bULL, 0x0000007224727210ULL, 0x040fe20007f5e0ffULL,
0x00000001256d7824ULL, 0x040fe200018e066dULL, 0x0000007424247210ULL, 0x000fe20007f7e0ffULL,
0x000000107a777824ULL, 0x100fe200078e0287ULL, 0x0000007125717210ULL, 0x040fe20000ffe4ffULL,
0x00000010887b7824ULL, 0x000fe200078e0287ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000261f7faeULL, 0x0003e2000b901c48ULL, 0x00000001256f7824ULL, 0x000fc400000e066fULL,
0x000000108a837824ULL, 0x100fe200078e0287ULL, 0x0000000068217faeULL, 0x0003e2000b901c48ULL,
0x000000108c857824ULL, 0x000fe400078e0287ULL, 0x0000000125737824ULL, 0x040fe200010e0673ULL,
0x000000006a777faeULL, 0x0003e2000b901c48ULL, 0x0000001076877824ULL, 0x000fe400078e0287ULL,
0x0000000125257824ULL, 0x000fe200018e0675ULL, 0x000000006c797faeULL, 0x0003e8000b901c48ULL,
0x000000006e7b7faeULL, 0x0003e8000b901c48ULL, 0x0000000070837faeULL, 0x0003e8000b901c48ULL,
0x0000000072857faeULL, 0x0003e8000b901c48ULL, 0x0000000024877faeULL, 0x0003e4000b901c48ULL,
0x00000003201f7812ULL, 0x002fe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000031f00780cULL, 0x000fc80003f05270ULL, 0x00000001811f7807ULL, 0x000fca0004000000ULL,
0x0000000120207824ULL, 0x000fe400078e021fULL, 0xffffffffff1f7424ULL, 0x000fc600078e00ffULL,
0x000000052000720cULL, 0x000fda0003f06070ULL, 0x000000010c248824ULL, 0x000fe400078e0220ULL,
0x00000004ff258424ULL, 0x000fc800078e00ffULL, 0x0000640024248625ULL, 0x000fca00078e0025ULL,
0x00000008241f8981ULL, 0x000322000c1e1900ULL, 0xffffffe07c217812ULL, 0x040fe400078ec0ffULL,
0x000000107c227812ULL, 0x040fe400078ec0ffULL, 0x000000087c267812ULL, 0x000fc800078ec0ffULL,
0x00000021266a7210ULL, 0x000fe20007ffe022ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01e628006a687f8cULL, 0x0022a4000c80043fULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0x01e62c006a217984ULL, 0x000ee40000000800ULL, 0x8000000021ff7812ULL, 0x00cfe40007804869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624227210ULL, 0x000fca0007f1e1ffULL,
0x0000000127267824ULL, 0x000fe200000e0e25ULL, 0x003d09002200780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402200780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff217819ULL, 0x000fc80000011426ULL,
0x0000002221217211ULL, 0x000fca00078110ffULL, 0x000000ffff227224ULL, 0x000fca00000e0626ULL,
0x0000000221217819ULL, 0x000fc80000001222ULL, 0x000000210000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016b6b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e62c006a217984ULL, 0x000ea40000000800ULL,
0x8000000021ff7812ULL, 0x004fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000500217819ULL, 0x000fc800000006ffULL, 0xffffff8021227812ULL, 0x000fc800078ec0ffULL,
0x000000800d227810ULL, 0x000fca0007ffe022ULL, 0x000000017d227824ULL, 0x000fca00078e0222ULL,
0x01e0000022697984ULL, 0x000ea80000000800ULL, 0x01e20000226a7984ULL, 0x0022e20000000800ULL,
0x000000086900720bULL, 0x004fe20003f1d000ULL, 0x00014bc27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000227806ULL, 0x002fc800000e0100ULL, 0x000000ff2200720cULL, 0x000fe20003f25270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff217224ULL, 0x000fd400078e0008ULL, 0x0000072000009947ULL, 0x000fea0003800000ULL,
0x0000000107217810ULL, 0x000fe40007ffe0ffULL, 0x000000086900720bULL, 0x000fe40003f34000ULL,
0x000000002100720cULL, 0x000fe20003f05270ULL, 0x00014b827f007947ULL, 0x000fd4000b800000ULL,
0x0000000000217806ULL, 0x000fc400008e0100ULL, 0x0000008000268824ULL, 0x000fe200078e020dULL,
0x0000000869248209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x000000017d258824ULL, 0x000fca00078e0226ULL, 0x01e4002425008388ULL, 0x0003e20000000800ULL,
0x000000ff2100720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000000869257209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff21ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000825247221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b24247820ULL, 0x000fc80000410000ULL, 0x00000024006c7308ULL, 0x000e640000000800ULL,
0x0000006c23237220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff247819ULL, 0x000fe20000011603ULL, 0x00014ac27f007947ULL, 0x000fea000b800000ULL,
0x00001f246c247589ULL, 0x0002a400000e0000ULL, 0x0000002464647220ULL, 0x084fe40000410000ULL,
0x0000002465657220ULL, 0x080fe40000410000ULL, 0x0000002460607220ULL, 0x080fe40000410000ULL,
0x0000002461617220ULL, 0x000fc40000410000ULL, 0x000000245c5c7220ULL, 0x080fe40000410000ULL,
0x000000245d5d7220ULL, 0x080fe40000410000ULL, 0x0000002458587220ULL, 0x080fe40000410000ULL,
0x0000002459597220ULL, 0x080fe40000410000ULL, 0x0000002454547220ULL, 0x080fe40000410000ULL,
0x0000002455557220ULL, 0x000fc40000410000ULL, 0x0000002450507220ULL, 0x080fe40000410000ULL,
0x0000002451517220ULL, 0x080fe40000410000ULL, 0x000000244c4c7220ULL, 0x080fe40000410000ULL,
0x000000244d4d7220ULL, 0x080fe40000410000ULL, 0x0000002448487220ULL, 0x080fe40000410000ULL,
0x0000002449497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0021ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000803247811ULL, 0x000fe200078ff0ffULL,
0x000149b27f007947ULL, 0x000fea000b800000ULL, 0x00001f246c247589ULL, 0x00046400000e0000ULL,
0x0000002466667220ULL, 0x086fe40000410000ULL, 0x0000002467677220ULL, 0x080fe40000410000ULL,
0x0000002462627220ULL, 0x080fe40000410000ULL, 0x0000002463637220ULL, 0x080fe40000410000ULL,
0x000000245e5e7220ULL, 0x080fe40000410000ULL, 0x000000245f5f7220ULL, 0x000fc40000410000ULL,
0x000000245a5a7220ULL, 0x080fe40000410000ULL, 0x000000245b5b7220ULL, 0x080fe40000410000ULL,
0x0000002456567220ULL, 0x080fe40000410000ULL, 0x0000002457577220ULL, 0x080fe40000410000ULL,
0x0000002452527220ULL, 0x080fe40000410000ULL, 0x0000002453537220ULL, 0x000fc40000410000ULL,
0x000000244e4e7220ULL, 0x080fe40000410000ULL, 0x000000244f4f7220ULL, 0x080fe40000410000ULL,
0x000000244a4a7220ULL, 0x080fe40000410000ULL, 0x000000244b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000021ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001003247811ULL, 0x000fe200078ff0ffULL, 0x000148a27f007947ULL, 0x000fea000b800000ULL,
0x00001f246c247589ULL, 0x00046400000e0000ULL, 0x0000002444447220ULL, 0x086fe40000410000ULL,
0x0000002445457220ULL, 0x080fe40000410000ULL, 0x0000002440407220ULL, 0x080fe40000410000ULL,
0x0000002441417220ULL, 0x080fe40000410000ULL, 0x000000243c3c7220ULL, 0x080fe40000410000ULL,
0x000000243d3d7220ULL, 0x000fc40000410000ULL, 0x0000002438387220ULL, 0x080fe40000410000ULL,
0x0000002439397220ULL, 0x080fe40000410000ULL, 0x0000002434347220ULL, 0x080fe40000410000ULL,
0x0000002435357220ULL, 0x080fe40000410000ULL, 0x0000002430307220ULL, 0x080fe40000410000ULL,
0x0000002431317220ULL, 0x000fc40000410000ULL, 0x000000242c2c7220ULL, 0x080fe40000410000ULL,
0x000000242d2d7220ULL, 0x080fe40000410000ULL, 0x0000002428287220ULL, 0x080fe40000410000ULL,
0x0000002429297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000021ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001803247811ULL, 0x000fe200078ff0ffULL, 0x000147a27f007947ULL, 0x000fea000b800000ULL,
0x00001f246c247589ULL, 0x00046400000e0000ULL, 0x0000002446467220ULL, 0x086fe40000410000ULL,
0x0000002447477220ULL, 0x080fe40000410000ULL, 0x0000002442427220ULL, 0x080fe40000410000ULL,
0x0000002443437220ULL, 0x080fe40000410000ULL, 0x000000243e3e7220ULL, 0x080fe40000410000ULL,
0x000000243f3f7220ULL, 0x000fc40000410000ULL, 0x000000243a3a7220ULL, 0x080fe40000410000ULL,
0x000000243b3b7220ULL, 0x080fe40000410000ULL, 0x0000002436367220ULL, 0x080fe40000410000ULL,
0x0000002437377220ULL, 0x080fe40000410000ULL, 0x0000002432327220ULL, 0x080fe40000410000ULL,
0x0000002433337220ULL, 0x000fc40000410000ULL, 0x000000242e2e7220ULL, 0x080fe40000410000ULL,
0x000000242f2f7220ULL, 0x080fe40000410000ULL, 0x000000242a2a7220ULL, 0x080fe40000410000ULL,
0x000000242b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000002122ff7212ULL, 0x000fe400078030ffULL, 0x0000000869217209ULL, 0x000fd60007810000ULL,
0x8000002169690221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b69690820ULL, 0x000fc80000410000ULL,
0x00000069000e0308ULL, 0x000e640000000800ULL, 0x0000000e6a6a0220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000236a237221ULL, 0x008fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x0000000eff08723eULL, 0x000fe400000000ffULL, 0x00000002ff697819ULL, 0x000fe40000011603ULL,
0x0000541008087816ULL, 0x000fe20000000008ULL, 0x000146027f007947ULL, 0x000fea000b800000ULL,
0x00001f69080f7589ULL, 0x0002a400000e0000ULL, 0x0000000869247810ULL, 0x000fe20007ffe0ffULL,
0x000146527f007947ULL, 0x000fea000b800000ULL, 0x0000001069117810ULL, 0x000fe20007ffe0ffULL,
0x00001f2408107589ULL, 0x00066a00000e0000ULL, 0x00001f1108117589ULL, 0x0006a400000e0000ULL,
0x0000001869247810ULL, 0x008fe20007ffe0ffULL, 0x000146e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2408127589ULL, 0x0006a400000e0000ULL, 0x0000040000087824ULL, 0x04afe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000200000227824ULL, 0x000fe200078e00ffULL,
0x0000016000007945ULL, 0x000fe40003800000ULL, 0xfffff00008087812ULL, 0x000fc400078ec0ffULL,
0xffffc00022247812ULL, 0x000fe400078ec0ffULL, 0x0001300008087810ULL, 0x000fe40007ffe0ffULL,
0x000000240b247211ULL, 0x000fc600078e68ffULL, 0x0000001013787824ULL, 0x100fe200078e0208ULL,
0x0001700024687810ULL, 0x000fe20007ffe0ffULL, 0x0000001014087824ULL, 0x000fc800078e0208ULL,
0x000000007878783bULL, 0x000e620000000200ULL, 0x0000001016747824ULL, 0x100fe400078e0268ULL,
0x0000001015707824ULL, 0x100fe200078e0268ULL, 0x000000000824783bULL, 0x0006a20000000200ULL,
0x00000010176c7824ULL, 0x000fe200078e0268ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000f78787232ULL, 0x086fe40000000000ULL, 0x0000000f7a7a7232ULL, 0x000fe40000000000ULL,
0x0000001079797232ULL, 0x000fc40000000000ULL, 0x000000107b7b7232ULL, 0x000fe40000000000ULL,
0x0000001124247232ULL, 0x080fe40000000000ULL, 0x0000001126267232ULL, 0x000fe40000000000ULL,
0x0000001225257232ULL, 0x080fe40000000000ULL, 0x0000001227277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001018687824ULL, 0x000fe200078e0268ULL,
0x000000007474783bULL, 0x000ee40000004200ULL, 0x00000001ff087819ULL, 0x008fe20000011600ULL,
0x0000027000007945ULL, 0x000fe20003800000ULL, 0x000000007070783bULL, 0x000fe80000004200ULL,
0x000000006868783bULL, 0x000ee80000004200ULL, 0x000000006c6c783bULL, 0x000ea20000004200ULL,
0x000000747864723cULL, 0x042f700000001864ULL, 0x00000068784c723cULL, 0x088f70000000184cULL,
0x00000068242c723cULL, 0x004b6e000000182cULL, 0x0001300007687811ULL, 0x020fe200078e60ffULL,
0x000000767860723cULL, 0x000f620000001860ULL, 0x0000000208697824ULL, 0x000fca00078e020bULL,
0x0001700069697811ULL, 0x000fe400078e68ffULL, 0x00000070785c723cULL, 0x040f70000000185cULL,
0x000000727858723cULL, 0x040f700000001858ULL, 0x0000006c7854723cULL, 0x040f700000001854ULL,
0x0000006e7850723cULL, 0x040f700000001850ULL, 0x0000006a7848723cULL, 0x000b6e0000001848ULL,
0x0000001019787824ULL, 0x120fe200078e0268ULL, 0x000000742444723cULL, 0x040b6a0000001844ULL,
0x000000007878783bULL, 0x000e640000000200ULL, 0x000000691b747211ULL, 0x020fe200078e20ffULL,
0x000000762440723cULL, 0x040f700000001840ULL, 0x00000070243c723cULL, 0x040b6e000000183cULL,
0x000000101c707824ULL, 0x120fe200078e0269ULL, 0x000000722438723cULL, 0x040f700000001838ULL,
0x0000006c2434723cULL, 0x040b6e0000001834ULL, 0x000000101d6c7824ULL, 0x020fe200078e0269ULL,
0x0000006e2430723cULL, 0x040f700000001830ULL, 0x0000006a2428723cULL, 0x000b6e0000001828ULL,
0x000000101a247824ULL, 0x020fcc00078e0268ULL, 0x000000002424783bULL, 0x000ea20000000200ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000000f78787232ULL, 0x082fe40000000000ULL,
0x0000000f7a7a7232ULL, 0x000fe40000000000ULL, 0x0000001079797232ULL, 0x080fe40000000000ULL,
0x000000107b7b7232ULL, 0x000fe40000000000ULL, 0x0000001124247232ULL, 0x084fe40000000000ULL,
0x0000001126267232ULL, 0x000fc40000000000ULL, 0x0000001225257232ULL, 0x080fe40000000000ULL,
0x0000001227277232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x002fea0003800000ULL,
0x000000101e697824ULL, 0x000fe200078e0269ULL, 0x000000007474783bULL, 0x000e680000004200ULL,
0x000000007070783bULL, 0x000ee80000004200ULL, 0x000000006c6c783bULL, 0x000ea80000004200ULL,
0x000000006968783bULL, 0x000ea20000004200ULL, 0x000000747864723cULL, 0x042f700000001864ULL,
0x000000767860723cULL, 0x040f700000001860ULL, 0x00000070785c723cULL, 0x048f70000000185cULL,
0x000000727858723cULL, 0x040f700000001858ULL, 0x0000006c7854723cULL, 0x044f700000001854ULL,
0x0000006e7850723cULL, 0x040f700000001850ULL, 0x00000068784c723cULL, 0x040f70000000184cULL,
0x0000006a7848723cULL, 0x000f700000001848ULL, 0x000000742444723cULL, 0x040f700000001844ULL,
0x000000762440723cULL, 0x040f700000001840ULL, 0x00000070243c723cULL, 0x040f70000000183cULL,
0x000000722438723cULL, 0x040f700000001838ULL, 0x0000006c2434723cULL, 0x040f700000001834ULL,
0x0000006e2430723cULL, 0x040f700000001830ULL, 0x00000068242c723cULL, 0x040f70000000182cULL,
0x0000006a2428723cULL, 0x000b6e0000001828ULL, 0x000059001f247a24ULL, 0x030fe200078e02ffULL,
0x0001e690071f7811ULL, 0x000fe200078e18ffULL, 0x0000000802267824ULL, 0x000fe200078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fcc0000008000ULL, 0x0000000102257810ULL, 0x000fe20007ffe0ffULL,
0x000000001fff7f8cULL, 0x0003e2000c80043fULL, 0x000000c026267811ULL, 0x000fe200078e28ffULL,
0x00000100ff697424ULL, 0x000fe200078e00ffULL, 0x000000062500720cULL, 0x000fe20003f06070ULL,
0x0000004024247824ULL, 0x000fe200078e00ffULL, 0x0000002026277812ULL, 0x000fc600078ec0ffULL,
0x0000620024247625ULL, 0x000fc800078e0069ULL, 0x000000010a767824ULL, 0x000fe200078e0227ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000065000008947ULL, 0x000fea0003800000ULL,
0x00000003ff747819ULL, 0x102fe40000011603ULL, 0x00000026041f7217ULL, 0x000fe40007800000ULL,
0x0000000474687810ULL, 0x040fe40007ffe0ffULL, 0x00000008746c7810ULL, 0x040fe20007ffe0ffULL,
0x000000011f1f7824ULL, 0x000fe200078e0a26ULL, 0x0000000c74727810ULL, 0x000fe20007ffe0ffULL,
0x0000000168277824ULL, 0x140fe200078e0203ULL, 0x0000000368787819ULL, 0x000fe200000006ffULL,
0x000000016c697824ULL, 0x040fe200078e0203ULL, 0x000000201f1f7817ULL, 0x000fe20003800000ULL,
0x000000086c7a7824ULL, 0x000fe200078e00ffULL, 0xfffffff878787812ULL, 0x000fe200078ee227ULL,
0x0000008000267824ULL, 0x000fe200078e00ffULL, 0x00000014748a7810ULL, 0x000fe20007ffe0ffULL,
0x00000001726a7824ULL, 0x000fe200078e0203ULL, 0xfffffff87a7a7812ULL, 0x000fe200078ee269ULL,
0x00000008726b7824ULL, 0x000fe200078e00ffULL, 0x000000800d267812ULL, 0x000fe200078ef826ULL,
0x0000000174697824ULL, 0x000fe200078e0276ULL, 0x0000001f6800720cULL, 0x0c0fe20003f86070ULL,
0x000000ffff277224ULL, 0x000fe200078e00ffULL, 0xfffffff86b847812ULL, 0x000fe200078ee26aULL,
0x00000001686b7824ULL, 0x000fe200078e0276ULL, 0x0000001074867810ULL, 0x000fe20007ffe0ffULL,
0x0000010069687825ULL, 0x000fe200078e0026ULL, 0x0000001f7200720cULL, 0x000fc40003f46070ULL,
0x0000000386887819ULL, 0x000fe200000006ffULL, 0x000001006b6a7825ULL, 0x000fe200078e0026ULL,
0x00000068246e7210ULL, 0x000fe40007f1e0ffULL, 0x0000001f6c00720cULL, 0x080fe20003f66070ULL,
0x000000018a6f7824ULL, 0x100fe200078e0203ULL, 0x0000006a24707210ULL, 0x000fe20007f3e0ffULL,
0x000000088a8c7824ULL, 0x000fe200078e00ffULL, 0x0000001f7400720cULL, 0x080fe20003fa6070ULL,
0x00000001866d7824ULL, 0x000fe400078e0203ULL, 0x0000000125717824ULL, 0x040fe200008e066bULL,
0xfffffff88c8c7812ULL, 0x000fe200078ee26fULL, 0x00000001256f7824ULL, 0x000fe200000e0669ULL,
0xfffffff888887812ULL, 0x000fe200078ee26dULL, 0x000000016c697824ULL, 0x100fe200078e0276ULL,
0x00002000226d7812ULL, 0x000fe200078ec0ffULL, 0x00000001726b7824ULL, 0x000fe200078e0276ULL,
0x0000001f8600720cULL, 0x000fe20003f26070ULL, 0x0000010069687825ULL, 0x000fc800078e0026ULL,
0x0000000174227824ULL, 0x000fe200078e0203ULL, 0x0000006824727210ULL, 0x000fe20007f1e0ffULL,
0x000001006b6a7825ULL, 0x000fc600078e0026ULL, 0x0000000722227812ULL, 0x000fe200078ec0ffULL,
0x0000400008757824ULL, 0x000fe200078e026dULL, 0x0000006a246a7210ULL, 0x000fe20007fde0ffULL,
0x00000001866d7824ULL, 0x100fe200078e0276ULL, 0x0000006925737210ULL, 0x000fe200007fe4ffULL,
0x000000018a697824ULL, 0x000fe200078e0276ULL, 0x0001700075797810ULL, 0x000fe20007ffe0ffULL,
0x000001006d6c7825ULL, 0x000fe200078e0026ULL, 0x0ffffff822227812ULL, 0x000fe400078ef803ULL,
0x0000001f8a00720cULL, 0x000fe20003f06070ULL, 0x00000001256b7824ULL, 0x000fe200030e066bULL,
0x0000006c246c7210ULL, 0x000fe20007fde0ffULL, 0x0000010069687825ULL, 0x000fc800078e0026ULL,
0x00000010227b7824ULL, 0x100fe200078e0279ULL, 0x0000001874227810ULL, 0x000fe20007ffe0ffULL,
0x0000001078837824ULL, 0x000fe200078e0279ULL, 0x0000001c74787810ULL, 0x000fe20007ffe0ffULL,
0x00000001256d7824ULL, 0x040fe200030e066dULL, 0x0000006824747210ULL, 0x000fe20007fde0ffULL,
0x0000000122777824ULL, 0x040fe200078e0276ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e7b7faeULL, 0x0003e2000e901c48ULL, 0x0000001f2200720cULL, 0x080fe40003fa6070ULL,
0x0000000125757824ULL, 0x000fe200030e0669ULL, 0x0000000070837faeULL, 0x0005e2000e101c48ULL,
0x0000010077687825ULL, 0x000fe200078e0026ULL, 0x0000001f7800720cULL, 0x000fc60003f86070ULL,
0x00000001781f7824ULL, 0x000fe200078e0276ULL, 0x0000006824687210ULL, 0x000fe20007fde0ffULL,
0x000000108c777824ULL, 0x000fe200078e0279ULL, 0x00000003226f7819ULL, 0x042fe200000006ffULL,
0x00000001226e7824ULL, 0x000fe400078e0203ULL, 0x000001001f267825ULL, 0x000fc600078e0026ULL,
0xfffffff86f6e7812ULL, 0x000fe200078ee26eULL, 0x0000000178227824ULL, 0x040fe400078e0203ULL,
0x0000000878717824ULL, 0x004fe400078e00ffULL, 0x0000000125697824ULL, 0x000fe200030e0669ULL,
0x0000002624247210ULL, 0x000fe20007fde0ffULL, 0x000000107a1f7824ULL, 0x100fe200078e0279ULL,
0xfffffff871227812ULL, 0x000fe200078ee222ULL, 0x00000010846f7824ULL, 0x100fe400078e0279ULL,
0x0000001088717824ULL, 0x100fe200078e0279ULL, 0x00000000721f7faeULL, 0x0003e2000d901c48ULL,
0x000000106e7b7824ULL, 0x000fe200078e0279ULL, 0x0000007922797211ULL, 0x000fe200078e20ffULL,
0x0000000125257824ULL, 0x000fe200030e0627ULL, 0x000000006a6f7faeULL, 0x0003e8000d101c48ULL,
0x000000006c717faeULL, 0x0003e8000c901c48ULL, 0x0000000074777faeULL, 0x0003e8000c101c48ULL,
0x00000000687b7faeULL, 0x0003e8000e901c48ULL, 0x0000000024797faeULL, 0x0003e2000e101c48ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x00000008036b7811ULL, 0x042fe200078fe8ffULL,
0x0000008000747824ULL, 0x000fe200078e00ffULL, 0x0000000403697811ULL, 0x000fc400078fe8ffULL,
0x0000001803737811ULL, 0x000fe200078fe8ffULL, 0x000000016b267824ULL, 0x100fe200078e0203ULL,
0x0000001403717811ULL, 0x000fe200078fe8ffULL, 0x000000086b277824ULL, 0x000fe200078e00ffULL,
0x0000000c036d7811ULL, 0x000fe200078fe8ffULL, 0x00000001691f7824ULL, 0x100fe200078e0203ULL,
0x00000010036f7811ULL, 0x000fe200078fe8ffULL, 0x0000000869787824ULL, 0x000fe200078e00ffULL,
0xfffffff8277a7812ULL, 0x000fe200078ee226ULL, 0x0000000173687824ULL, 0x000fe200078e0203ULL,
0x000000036f757819ULL, 0x000fe200000006ffULL, 0x0000000873777824ULL, 0x000fe200078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee21fULL, 0x0000000171277824ULL, 0x100fe200078e0203ULL,
0x000000800d747812ULL, 0x000fe200078ef874ULL, 0x0000000871887824ULL, 0x000fe200078e00ffULL,
0xfffffff8778a7812ULL, 0x000fe200078ee268ULL, 0x000000016d1f7824ULL, 0x000fe200078e0203ULL,
0x0000001c03687811ULL, 0x000fe200078fe8ffULL, 0x000000086d847824ULL, 0x000fe200078e00ffULL,
0xfffffff888887812ULL, 0x000fe200078ee227ULL, 0x000000016f267824ULL, 0x100fe200078e0203ULL,
0x0000200022277812ULL, 0x000fe200078ec0ffULL, 0x00000001686a7824ULL, 0x000fe200078e0203ULL,
0xfffffff884847812ULL, 0x000fe200078ee21fULL, 0x0000000169697824ULL, 0x000fe200078e0276ULL,
0xfffffff875867812ULL, 0x000fe200078ee226ULL, 0x0000000868757824ULL, 0x000fe200078e00ffULL,
0x00000003031f7211ULL, 0x000fe200078fe8ffULL, 0x0000400008267824ULL, 0x000fe200078e0227ULL,
0x000000766d6d7210ULL, 0x080fe20007ffe0ffULL, 0x000000016b6b7824ULL, 0x100fe200078e0276ULL,
0x000000071f227812ULL, 0x000fe200078ec0ffULL, 0x000000016f6f7824ULL, 0x100fe200078e0276ULL,
0x0000007603277211ULL, 0x000fe200078fe8ffULL, 0x0000000171717824ULL, 0x100fe200078e0276ULL,
0x0001700026777810ULL, 0x000fe20007ffe0ffULL, 0x0000000173737824ULL, 0x100fe200078e0276ULL,
0x0ffffff822227812ULL, 0x000fe200078ef803ULL, 0x00000001681f7824ULL, 0x000fe200078e0276ULL,
0xfffffff875767812ULL, 0x000fe200078ee26aULL, 0x000000ffff757224ULL, 0x000fe200078e00ffULL,
0x0000007778797211ULL, 0x000fe200078e20ffULL, 0x000000107a7b7824ULL, 0x000fc400078e0277ULL,
0x0000010027267825ULL, 0x000fc800078e0074ULL, 0x0000010069687825ULL, 0x000fe200078e0074ULL,
0x0000002624267210ULL, 0x000fc60007f1e0ffULL, 0x000001006b6a7825ULL, 0x000fe200078e0074ULL,
0x0000006824687210ULL, 0x000fc60007f3e0ffULL, 0x000001006d6c7825ULL, 0x000fe200078e0074ULL,
0x0000006a246a7210ULL, 0x000fc60007f5e0ffULL, 0x000001006f6e7825ULL, 0x100fe200078e0074ULL,
0x0000006c246c7210ULL, 0x000fe40007f7e0ffULL, 0x0000006b256b7210ULL, 0x000fe200017fe4ffULL,
0x0000010071707825ULL, 0x000fc800078e0074ULL, 0x0000010073727825ULL, 0x000fc800078e0074ULL,
0x000001001f747825ULL, 0x000fe200078e0074ULL, 0x0000007224727210ULL, 0x000fc60007f5e0ffULL,
0x0000000125277824ULL, 0x040fe200000e0627ULL, 0x0000006e246e7210ULL, 0x040fe20007f1e0ffULL,
0x0000000125697824ULL, 0x040fe200008e0669ULL, 0x0000007024707210ULL, 0x000fe20007f3e0ffULL,
0x00000010221f7824ULL, 0x000fe400078e0277ULL, 0x00000001256d7824ULL, 0x000fe200018e066dULL,
0x0000007424247210ULL, 0x000fe20007f7e0ffULL, 0x0000001084837824ULL, 0x100fe200078e0277ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000261f7faeULL, 0x0003e2000b901c48ULL,
0x0000001086857824ULL, 0x000fc400078e0277ULL, 0x00000001256f7824ULL, 0x040fe200000e066fULL,
0x0000000068797faeULL, 0x0003e2000b901c48ULL, 0x0000001088877824ULL, 0x000fe400078e0277ULL,
0x0000000125717824ULL, 0x040fe200008e0671ULL, 0x000000006a7b7faeULL, 0x0003e2000b901c48ULL,
0x000000108a897824ULL, 0x000fe400078e0277ULL, 0x0000000125737824ULL, 0x000fe200010e0673ULL,
0x000000006c837faeULL, 0x0003e2000b901c48ULL, 0x0000001076777824ULL, 0x000fc400078e0277ULL,
0x0000000125257824ULL, 0x000fe200018e0675ULL, 0x000000006e857faeULL, 0x0003e8000b901c48ULL,
0x0000000070877faeULL, 0x0003e8000b901c48ULL, 0x0000000072897faeULL, 0x0003e8000b901c48ULL,
0x0000000024777faeULL, 0x0003e4000b901c48ULL, 0x00000003201f7812ULL, 0x002fe200078ec0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000031f00780cULL, 0x000fc80003f05270ULL,
0x00000001811f7807ULL, 0x000fca0004000000ULL, 0x0000000120207824ULL, 0x000fe200078e021fULL,
0xffffffff001f7802ULL, 0x000fc80000000f00ULL, 0x000000052000720cULL, 0x000fda0003f06070ULL,
0x000000010c248824ULL, 0x000fe400078e0220ULL, 0x00000004ff258424ULL, 0x000fc800078e00ffULL,
0x0000640024248625ULL, 0x000fca00078e0025ULL, 0x00000008241f8981ULL, 0x000322000c1e1900ULL,
0x000000107c227812ULL, 0x040fe400078ec0ffULL, 0x000000087c277812ULL, 0x000fc600078ec0ffULL,
0x0000002007227824ULL, 0x000fc800078e0222ULL, 0x0000000127227824ULL, 0x000fe200078e0222ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e6480022687f8cULL, 0x0022a4000c80043fULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x01e64c0022277984ULL, 0x000ee40000000800ULL,
0x8000000027ff7812ULL, 0x00cfe40007804869ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026246b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09006b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000006b26267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e64c0022277984ULL, 0x000ea40000000800ULL, 0x8000000027ff7812ULL, 0x004fe40007804869ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000227824ULL, 0x002fca00078e00ffULL,
0xffffff8022227812ULL, 0x000fc800078ec0ffULL, 0x000001000d227810ULL, 0x000fca0007ffe022ULL,
0x000000017d227824ULL, 0x000fca00078e0222ULL, 0x01e00000226a7984ULL, 0x000e680000000800ULL,
0x01e2000022697984ULL, 0x0004e20000000800ULL, 0x000000216a00720bULL, 0x002fe20003f1d000ULL,
0x000130a27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000227806ULL, 0x004fc800000e0100ULL,
0x000000ff2200720cULL, 0x000fe20003f25270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000071000009947ULL, 0x000fea0003800000ULL,
0x0000000207257810ULL, 0x000fe40007ffe0ffULL, 0x000000216a00720bULL, 0x000fe40003f34000ULL,
0x000000002500720cULL, 0x000fe20003f05270ULL, 0x000130727f007947ULL, 0x000fd4000b800000ULL,
0x00000000006b7806ULL, 0x000fc400008e0100ULL, 0x0000008000268824ULL, 0x000fe200078e020dULL,
0x000000216a247209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000017d258824ULL, 0x000fca00078e0226ULL, 0x01e4002425008388ULL, 0x0003e20000000800ULL,
0x000000ff6b00720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x8000002421247221ULL, 0x002fe20000010000ULL, 0x000000ff6bff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b24247820ULL, 0x000fc80000410000ULL,
0x00000024006c7308ULL, 0x000e640000000800ULL, 0x0000006c23237220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff247819ULL, 0x000fe20000011603ULL,
0x00012fc27f007947ULL, 0x000fea000b800000ULL, 0x00001f246c247589ULL, 0x0002a400000e0000ULL,
0x0000002464647220ULL, 0x084fe40000410000ULL, 0x0000002465657220ULL, 0x080fe40000410000ULL,
0x0000002460607220ULL, 0x080fe40000410000ULL, 0x0000002461617220ULL, 0x080fe40000410000ULL,
0x000000245c5c7220ULL, 0x080fe40000410000ULL, 0x000000245d5d7220ULL, 0x000fc40000410000ULL,
0x0000002458587220ULL, 0x080fe40000410000ULL, 0x0000002459597220ULL, 0x080fe40000410000ULL,
0x0000002454547220ULL, 0x080fe40000410000ULL, 0x0000002455557220ULL, 0x080fe40000410000ULL,
0x0000002450507220ULL, 0x080fe40000410000ULL, 0x0000002451517220ULL, 0x000fc40000410000ULL,
0x000000244c4c7220ULL, 0x080fe40000410000ULL, 0x000000244d4d7220ULL, 0x080fe40000410000ULL,
0x0000002448487220ULL, 0x080fe40000410000ULL, 0x0000002449497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff006bff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803247811ULL, 0x000fe200078ff0ffULL, 0x00012eb27f007947ULL, 0x000fea000b800000ULL,
0x00001f246c247589ULL, 0x00046400000e0000ULL, 0x0000002466667220ULL, 0x086fe40000410000ULL,
0x0000002467677220ULL, 0x080fe40000410000ULL, 0x0000002462627220ULL, 0x080fe40000410000ULL,
0x0000002463637220ULL, 0x080fe40000410000ULL, 0x000000245e5e7220ULL, 0x080fe40000410000ULL,
0x000000245f5f7220ULL, 0x000fc40000410000ULL, 0x000000245a5a7220ULL, 0x080fe40000410000ULL,
0x000000245b5b7220ULL, 0x080fe40000410000ULL, 0x0000002456567220ULL, 0x080fe40000410000ULL,
0x0000002457577220ULL, 0x080fe40000410000ULL, 0x0000002452527220ULL, 0x080fe40000410000ULL,
0x0000002453537220ULL, 0x000fc40000410000ULL, 0x000000244e4e7220ULL, 0x080fe40000410000ULL,
0x000000244f4f7220ULL, 0x080fe40000410000ULL, 0x000000244a4a7220ULL, 0x080fe40000410000ULL,
0x000000244b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00006bff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001003247811ULL, 0x000fe200078ff0ffULL,
0x00012da27f007947ULL, 0x000fea000b800000ULL, 0x00001f246c247589ULL, 0x00046400000e0000ULL,
0x0000002444447220ULL, 0x086fe40000410000ULL, 0x0000002445457220ULL, 0x080fe40000410000ULL,
0x0000002440407220ULL, 0x080fe40000410000ULL, 0x0000002441417220ULL, 0x080fe40000410000ULL,
0x000000243c3c7220ULL, 0x080fe40000410000ULL, 0x000000243d3d7220ULL, 0x000fc40000410000ULL,
0x0000002438387220ULL, 0x080fe40000410000ULL, 0x0000002439397220ULL, 0x080fe40000410000ULL,
0x0000002434347220ULL, 0x080fe40000410000ULL, 0x0000002435357220ULL, 0x080fe40000410000ULL,
0x0000002430307220ULL, 0x080fe40000410000ULL, 0x0000002431317220ULL, 0x000fc40000410000ULL,
0x000000242c2c7220ULL, 0x080fe40000410000ULL, 0x000000242d2d7220ULL, 0x080fe40000410000ULL,
0x0000002428287220ULL, 0x080fe40000410000ULL, 0x0000002429297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000006bff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001803247811ULL, 0x000fe200078ff0ffULL,
0x00012ca27f007947ULL, 0x000fea000b800000ULL, 0x00001f246c247589ULL, 0x00046400000e0000ULL,
0x0000002446467220ULL, 0x086fe40000410000ULL, 0x0000002447477220ULL, 0x080fe40000410000ULL,
0x0000002442427220ULL, 0x080fe40000410000ULL, 0x0000002443437220ULL, 0x080fe40000410000ULL,
0x000000243e3e7220ULL, 0x080fe40000410000ULL, 0x000000243f3f7220ULL, 0x000fc40000410000ULL,
0x000000243a3a7220ULL, 0x080fe40000410000ULL, 0x000000243b3b7220ULL, 0x080fe40000410000ULL,
0x0000002436367220ULL, 0x080fe40000410000ULL, 0x0000002437377220ULL, 0x080fe40000410000ULL,
0x0000002432327220ULL, 0x080fe40000410000ULL, 0x0000002433337220ULL, 0x000fc40000410000ULL,
0x000000242e2e7220ULL, 0x080fe40000410000ULL, 0x000000242f2f7220ULL, 0x080fe40000410000ULL,
0x000000242a2a7220ULL, 0x080fe40000410000ULL, 0x000000242b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000006b22ff7212ULL, 0x000fe400078030ffULL,
0x000000216a217209ULL, 0x000fd60007810000ULL, 0x800000216a6a0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b6a6a0820ULL, 0x000fc80000410000ULL, 0x0000006a000e0308ULL, 0x000e640000000800ULL,
0x0000000e69690220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000002369237221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x0000000eff0f723eULL, 0x000fe400000000ffULL,
0x00000002ff697819ULL, 0x000fe40000011603ULL, 0x000054100f127816ULL, 0x000fe2000000000fULL,
0x00012b027f007947ULL, 0x000fea000b800000ULL, 0x00001f69120f7589ULL, 0x0002a400000e0000ULL,
0x0000000869247810ULL, 0x000fe20007ffe0ffULL, 0x00012b527f007947ULL, 0x000fea000b800000ULL,
0x0000001069117810ULL, 0x000fe20007ffe0ffULL, 0x00001f2412107589ULL, 0x00066a00000e0000ULL,
0x00001f1112117589ULL, 0x0006a400000e0000ULL, 0x0000001869247810ULL, 0x008fe20007ffe0ffULL,
0x00012be27f007947ULL, 0x000fea000b800000ULL, 0x00001f2412127589ULL, 0x0022e400000e0000ULL,
0x0000040000227824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000208257824ULL, 0x000fe200078e020bULL, 0x0000015000007945ULL, 0x000fe40003800000ULL,
0xfffff00022247812ULL, 0x002fc400078ec0ffULL, 0x0000000d25227819ULL, 0x000fe400000006ffULL,
0x0001400024247810ULL, 0x000fe40007ffe0ffULL, 0x0001600022837810ULL, 0x000fc60007ffe0ffULL,
0x0000001013687824ULL, 0x100fe400078e0224ULL, 0x0000001014247824ULL, 0x000fe400078e0224ULL,
0x00000010166c7824ULL, 0x100fe400078e0283ULL, 0x000000006868783bULL, 0x000e620000000200ULL,
0x0000001015707824ULL, 0x100fe400078e0283ULL, 0x0000001017747824ULL, 0x000fe200078e0283ULL,
0x000000002424783bULL, 0x000ee20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000f68687232ULL, 0x086fe40000000000ULL, 0x0000000f6a6a7232ULL, 0x000fc40000000000ULL,
0x0000001069697232ULL, 0x080fe40000000000ULL, 0x000000106b6b7232ULL, 0x000fe40000000000ULL,
0x0000001124247232ULL, 0x088fe40000000000ULL, 0x0000001126267232ULL, 0x000fe40000000000ULL,
0x0000001225257232ULL, 0x080fe40000000000ULL, 0x0000001227277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001018787824ULL, 0x100fe200078e0283ULL,
0x000000006c6c783bULL, 0x000ee20000004200ULL, 0x0000025000007945ULL, 0x000fe60003800000ULL,
0x000000007070783bULL, 0x000ea80000004200ULL, 0x000000007474783bULL, 0x000e680000004200ULL,
0x000000007878783bULL, 0x000e640000004200ULL, 0x0000006c6864723cULL, 0x04af700000001864ULL,
0x0000006e6860723cULL, 0x040f700000001860ULL, 0x00000070685c723cULL, 0x044f70000000185cULL,
0x000000726858723cULL, 0x040f700000001858ULL, 0x000000746854723cULL, 0x040f700000001854ULL,
0x000000766850723cULL, 0x040f700000001850ULL, 0x00000078684c723cULL, 0x040f70000000184cULL,
0x0000007a6848723cULL, 0x000b6e0000001848ULL, 0x0001400007687811ULL, 0x020fe200078e60ffULL,
0x00000078242c723cULL, 0x040f70000000182cULL, 0x0000006c2444723cULL, 0x040b6e0000001844ULL,
0x000000101c6c7824ULL, 0x120fe200078e0283ULL, 0x0000006e2440723cULL, 0x040f700000001840ULL,
0x00000070243c723cULL, 0x040b6e000000183cULL, 0x000000101d707824ULL, 0x020fe200078e0283ULL,
0x000000722438723cULL, 0x040f700000001838ULL, 0x000000742434723cULL, 0x040f700000001834ULL,
0x000000762430723cULL, 0x040f700000001830ULL, 0x0000007a2478723cULL, 0x000b6e0000001828ULL,
0x0000001019287824ULL, 0x020fc400078e0268ULL, 0x000000101a247824ULL, 0x000fe200078e0268ULL,
0x000000831b687211ULL, 0x000fc600078e20ffULL, 0x000000002828783bULL, 0x000e680000000200ULL,
0x000000002424783bULL, 0x000ea20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000f28287232ULL, 0x082fe40000000000ULL, 0x0000000f2a2a7232ULL, 0x000fe40000000000ULL,
0x0000001029297232ULL, 0x080fe40000000000ULL, 0x000000102b2b7232ULL, 0x000fc40000000000ULL,
0x0000001124247232ULL, 0x084fe40000000000ULL, 0x0000001126267232ULL, 0x000fe40000000000ULL,
0x0000001225257232ULL, 0x080fe40000000000ULL, 0x0000001227277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000101e747824ULL, 0x000fe200078e0283ULL,
0x000000006868783bULL, 0x000ee80000004200ULL, 0x000000006c6c783bULL, 0x000ea80000004200ULL,
0x000000007070783bULL, 0x000e680000004200ULL, 0x000000007474783bULL, 0x000e640000004200ULL,
0x000000682864723cULL, 0x04af700000001864ULL, 0x0000006a2860723cULL, 0x040f700000001860ULL,
0x0000006c285c723cULL, 0x044f70000000185cULL, 0x0000006e2858723cULL, 0x040f700000001858ULL,
0x000000702854723cULL, 0x040f700000001854ULL, 0x000000722850723cULL, 0x040f700000001850ULL,
0x00000074284c723cULL, 0x040f70000000184cULL, 0x000000762828723cULL, 0x000f700000001848ULL,
0x000000682444723cULL, 0x040f700000001844ULL, 0x0000006a2440723cULL, 0x040f700000001840ULL,
0x0000006c243c723cULL, 0x040f70000000183cULL, 0x0000006e2438723cULL, 0x040f700000001838ULL,
0x000000702434723cULL, 0x040f700000001834ULL, 0x000000722430723cULL, 0x040f700000001830ULL,
0x00000074242c723cULL, 0x040f70000000182cULL, 0x000000762478723cULL, 0x000b6e0000001878ULL,
0x0001e69807247811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fcc0000008000ULL,
0x0000030002027a10ULL, 0x000fe20007ffe0ffULL, 0x0000000024ff7f8cULL, 0x0003e6000c80043fULL,
0x000000060200720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00000d4000000947ULL, 0x000fea0003800000ULL, 0x0000000102257810ULL, 0x042fe20007ffe0ffULL,
0x000059001f1f7a24ULL, 0x010fe400078e02ffULL, 0x0000010002267824ULL, 0x000fe200078e0209ULL,
0x000000062500720cULL, 0x000fe20003f06070ULL, 0x000000401f247824ULL, 0x000fe400078e00ffULL,
0x00000100ff257424ULL, 0x000fe200078e00ffULL, 0x00000020261f7812ULL, 0x000fc600078ec0ffULL,
0x0000620024247625ULL, 0x000fc800078e0025ULL, 0x000000010a727824ULL, 0x000fe400078e021fULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff707819ULL, 0x100fe40000011603ULL,
0x00000026041f7217ULL, 0x000fe40007800000ULL, 0x0000000470487810ULL, 0x040fe40007ffe0ffULL,
0x0000000870687810ULL, 0x040fe20007ffe0ffULL, 0x000000011f1f7824ULL, 0x000fe200078e0a26ULL,
0x0000000c706e7810ULL, 0x000fe20007ffe0ffULL, 0x00000008484b7824ULL, 0x040fe200078e00ffULL,
0x0000000348267210ULL, 0x000fe20007ffe0ffULL, 0x0000000168277824ULL, 0x140fe200078e0203ULL,
0x000000201f1f7817ULL, 0x000fe20003800000ULL, 0x0000000868847824ULL, 0x000fe200078e00ffULL,
0xfffffff84b767812ULL, 0x000fe200078ee226ULL, 0x000000016e497824ULL, 0x000fe200078e0203ULL,
0x0000001f4800720cULL, 0x000fe20003f86070ULL, 0x000000086e867824ULL, 0x000fe200078e00ffULL,
0xfffffff884847812ULL, 0x000fe200078ee227ULL, 0x0000008000267824ULL, 0x000fe200078e00ffULL,
0x000000ff00277202ULL, 0x000fe20000000f00ULL, 0x00000001484b7824ULL, 0x100fe200078e0272ULL,
0xfffffff886867812ULL, 0x000fe200078ee249ULL, 0x0000000170497824ULL, 0x000fe200078e0272ULL,
0x000000800d267812ULL, 0x000fc400078ef826ULL, 0x00000014708c7810ULL, 0x040fe40007ffe0ffULL,
0x0000001070887810ULL, 0x000fe20007ffe0ffULL, 0x0000010049487825ULL, 0x100fe200078e0026ULL,
0x0000001f6e00720cULL, 0x080fe40003f46070ULL, 0x0000001f6800720cULL, 0x080fe20003f66070ULL,
0x000001004b4a7825ULL, 0x000fe200078e0026ULL, 0x00000048246a7210ULL, 0x000fe40007f1e0ffULL,
0x0000001f7000720cULL, 0x000fe20003fa6070ULL, 0x000000018c6b7824ULL, 0x000fe200078e0203ULL,
0x0000004a246c7210ULL, 0x000fe20007f3e0ffULL, 0x000000088c8e7824ULL, 0x000fc400078e00ffULL,
0x0000200000487824ULL, 0x000fe400078e00ffULL, 0x00000001704a7824ULL, 0x000fe200078e0203ULL,
0xfffffff88e8e7812ULL, 0x000fe200078ee26bULL, 0x00000001256b7824ULL, 0x040fe200000e0649ULL,
0x0000007268497210ULL, 0x000fe20007ffe0ffULL, 0x00000001256d7824ULL, 0x000fe200008e064bULL,
0x00002000486f7812ULL, 0x000fe200078ec0ffULL, 0x0000000188697824ULL, 0x100fe200078e0203ULL,
0x000000074a747812ULL, 0x000fe200078ec0ffULL, 0x00000008888a7824ULL, 0x040fe200078e00ffULL,
0x0000001f8800720cULL, 0x000fe20003f26070ULL, 0x000000016e4b7824ULL, 0x000fe200078e0272ULL,
0x0ffffff874747812ULL, 0x000fe200078ef803ULL, 0x0000010049487825ULL, 0x000fe200078e0026ULL,
0xfffffff88a8a7812ULL, 0x000fc600078ee269ULL, 0x000001004b4a7825ULL, 0x000fe200078e0026ULL,
0x00000048246e7210ULL, 0x000fc60007f1e0ffULL, 0x0000000188697824ULL, 0x000fe200078e0272ULL,
0x0000004a244a7210ULL, 0x000fe20007fde0ffULL, 0x0000400008717824ULL, 0x000fe400078e026fULL,
0x0000010069687825ULL, 0x000fc600078e0026ULL, 0x0001600071757810ULL, 0x000fe20007ffe0ffULL,
0x00000001256f7824ULL, 0x040fe200000e0649ULL, 0x0000001f8c00720cULL, 0x040fe20003f06070ULL,
0x000000018c497824ULL, 0x000fe200078e0272ULL, 0x0000007576837211ULL, 0x000fe200078e20ffULL,
0x00000001254b7824ULL, 0x000fe200030e064bULL, 0x0000006824687210ULL, 0x000fe20007fde0ffULL,
0x0000010049487825ULL, 0x000fe200078e0026ULL, 0x0000001c70767810ULL, 0x000fc60007ffe0ffULL,
0x0000001074777824ULL, 0x000fe200078e0275ULL, 0x0000001870747810ULL, 0x000fe20007ffe0ffULL,
0x0000000125697824ULL, 0x040fe200030e0669ULL, 0x0000004824707210ULL, 0x000fe40007fde0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a777faeULL, 0x0003e2000e901c48ULL,
0x0000000174737824ULL, 0x040fe200078e0272ULL, 0x0000001f7400720cULL, 0x080fe20003fa6070ULL,
0x0000000125717824ULL, 0x000fe200030e0649ULL, 0x000000006c837faeULL, 0x0005e2000e101c48ULL,
0x0000010073487825ULL, 0x000fe200078e0026ULL, 0x0000001f7600720cULL, 0x000fc60003f86070ULL,
0x00000001761f7824ULL, 0x000fe200078e0272ULL, 0x0000004824487210ULL, 0x000fe20007fde0ffULL,
0x0000000874737824ULL, 0x040fe400078e00ffULL, 0x00000001746a7824ULL, 0x102fe400078e0203ULL,
0x00000001766b7824ULL, 0x040fe400078e0203ULL, 0x00000008766c7824ULL, 0x004fe200078e00ffULL,
0xfffffff8736a7812ULL, 0x000fe200078ee26aULL, 0x000001001f267825ULL, 0x000fe200078e0026ULL,
0x00000075841f7211ULL, 0x000fc400078e20ffULL, 0xfffffff86c6c7812ULL, 0x000fe200078ee26bULL,
0x0000000125497824ULL, 0x040fe200030e0649ULL, 0x0000002624247210ULL, 0x000fe20007fde0ffULL,
0x00000010866b7824ULL, 0x100fe200078e0275ULL, 0x000000006e1f7faeULL, 0x0003e2000d901c48ULL,
0x000000108a6d7824ULL, 0x100fe400078e0275ULL, 0x000000108e737824ULL, 0x100fe200078e0275ULL,
0x000000004a6b7faeULL, 0x0003e2000d101c48ULL, 0x000000106a777824ULL, 0x100fe400078e0275ULL,
0x000000106c757824ULL, 0x000fe200078e0275ULL, 0x00000000686d7faeULL, 0x0003e2000c901c48ULL,
0x0000000125257824ULL, 0x000fc600030e0627ULL, 0x0000000070737faeULL, 0x0003e8000c101c48ULL,
0x0000000048777faeULL, 0x0003e8000e901c48ULL, 0x0000000024757faeULL, 0x0003e2000e101c48ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000403497811ULL, 0x040fe200078fe8ffULL,
0x0000008000707824ULL, 0x000fe200078e00ffULL, 0x00000008034b7811ULL, 0x000fc400078fe8ffULL,
0x0000000c03697811ULL, 0x000fe200078fe8ffULL, 0x00000001491f7824ULL, 0x000fe200078e0203ULL,
0x000000034b267210ULL, 0x080fe20007ffe0ffULL, 0x0000000849747824ULL, 0x000fe200078e00ffULL,
0x00000014036d7811ULL, 0x000fe200078fe8ffULL, 0x000000084b277824ULL, 0x000fe200078e00ffULL,
0x00000010036b7811ULL, 0x000fe200078fe8ffULL, 0x0000000869847824ULL, 0x040fe200078e00ffULL,
0xfffffff874747812ULL, 0x000fe200078ee21fULL, 0x00000001691f7824ULL, 0x100fe200078e0203ULL,
0xfffffff827767812ULL, 0x000fe200078ee226ULL, 0x000000016d277824ULL, 0x000fe200078e0203ULL,
0x00000018036f7811ULL, 0x000fe200078fe8ffULL, 0x000000086d887824ULL, 0x000fe200078e00ffULL,
0xfffffff884847812ULL, 0x000fe200078ee21fULL, 0x000000016b267824ULL, 0x000fe200078e0203ULL,
0x000000036f737819ULL, 0x000fe200000006ffULL, 0x000000086b717824ULL, 0x000fe200078e00ffULL,
0xfffffff888887812ULL, 0x000fe200078ee227ULL, 0x00002000001f7824ULL, 0x000fe200078e00ffULL,
0x0000001c03277811ULL, 0x000fe200078fe8ffULL, 0x000000016f487824ULL, 0x000fe200078e0203ULL,
0xfffffff871867812ULL, 0x000fe200078ee226ULL, 0x0000000149497824ULL, 0x100fe200078e0272ULL,
0x000020001f717812ULL, 0x000fe200078ec0ffULL, 0x00000001271f7824ULL, 0x100fe200078e0272ULL,
0x0000000303267211ULL, 0x080fe200078fe8ffULL, 0x000000014b4b7824ULL, 0x000fe200078e0272ULL,
0xfffffff8738a7812ULL, 0x000fe200078ee248ULL, 0x0000000827737824ULL, 0x040fe200078e00ffULL,
0x00000003274a7210ULL, 0x000fe20007ffe0ffULL, 0x0000400008487824ULL, 0x000fe200078e0271ULL,
0x0000000726267812ULL, 0x000fe200078ec0ffULL, 0x000000ffff717224ULL, 0x000fe200078e00ffULL,
0x000000800d707812ULL, 0x000fe200078ef870ULL, 0x0000000169697824ULL, 0x100fe200078e0272ULL,
0x0000007203277211ULL, 0x000fe200078fe8ffULL, 0x000000016b6b7824ULL, 0x000fe200078e0272ULL,
0xfffffff8738c7812ULL, 0x000fe200078ee24aULL, 0x000000016d6d7824ULL, 0x100fe200078e0272ULL,
0x0001600048737810ULL, 0x000fe20007ffe0ffULL, 0x000000016f6f7824ULL, 0x000fe200078e0272ULL,
0x0ffffff826727812ULL, 0x000fe200078ef803ULL, 0x0000010027267825ULL, 0x000fe200078e0070ULL,
0x0000007386857211ULL, 0x000fc600078e20ffULL, 0x0000010049487825ULL, 0x000fe200078e0070ULL,
0x0000002624267210ULL, 0x000fc60007f1e0ffULL, 0x000001004b4a7825ULL, 0x000fe200078e0070ULL,
0x0000004824487210ULL, 0x000fc60007f3e0ffULL, 0x0000010069687825ULL, 0x000fe200078e0070ULL,
0x0000004a244a7210ULL, 0x000fc60007f5e0ffULL, 0x000001006b6a7825ULL, 0x000fe200078e0070ULL,
0x0000006824687210ULL, 0x000fc60007f7e0ffULL, 0x000001006d6c7825ULL, 0x000fc800078e0070ULL,
0x000001006f6e7825ULL, 0x000fc800078e0070ULL, 0x000001001f707825ULL, 0x000fc800078e0070ULL,
0x0000000125277824ULL, 0x040fe200000e0627ULL, 0x0000006a246a7210ULL, 0x000fe20007f1e0ffULL,
0x00000010721f7824ULL, 0x000fe400078e0273ULL, 0x0000000125497824ULL, 0x040fe200008e0649ULL,
0x0000006c246c7210ULL, 0x040fe20007f3e0ffULL, 0x00000001254b7824ULL, 0x040fe200010e064bULL,
0x0000006e246e7210ULL, 0x000fe20007f5e0ffULL, 0x0000001074757824ULL, 0x000fe200078e0273ULL,
0x0000006d256d7210ULL, 0x040fe20000ffe4ffULL, 0x0000000125697824ULL, 0x000fe200018e0669ULL,
0x0000007024247210ULL, 0x000fe20007f7e0ffULL, 0x0000001076777824ULL, 0x100fe200078e0273ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000261f7faeULL, 0x0003e2000b901c48ULL,
0x0000001084837824ULL, 0x000fc400078e0273ULL, 0x00000001256b7824ULL, 0x040fe200000e066bULL,
0x0000000048757faeULL, 0x0003e2000b901c48ULL, 0x0000001088877824ULL, 0x100fe400078e0273ULL,
0x000000108a897824ULL, 0x000fe200078e0273ULL, 0x000000004a777faeULL, 0x0003e2000b901c48ULL,
0x00000001256f7824ULL, 0x040fe400010e066fULL, 0x000000108c737824ULL, 0x000fe200078e0273ULL,
0x0000000068837faeULL, 0x0003e2000b901c48ULL, 0x0000000125257824ULL, 0x000fc600018e0671ULL,
0x000000006a857faeULL, 0x0003e8000b901c48ULL, 0x000000006c877faeULL, 0x0003e8000b901c48ULL,
0x000000006e897faeULL, 0x0003e8000b901c48ULL, 0x0000000024737faeULL, 0x0003e4000b901c48ULL,
0x00000003201f7812ULL, 0x002fc800078ec0ffULL, 0x000000031f00780cULL, 0x000fc80003f05270ULL,
0x00000001811f7807ULL, 0x000fca0004000000ULL, 0x0000000120207824ULL, 0x000fe400078e021fULL,
0xffffffffff1f7424ULL, 0x000fc600078e00ffULL, 0x000000052000720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000010c247824ULL, 0x000fe400078e0220ULL,
0x00000004ff257424ULL, 0x000fc800078e00ffULL, 0x0000640024247625ULL, 0x000fca00078e0025ULL,
0x00000008241f7981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x000000107c247812ULL, 0x040fe400078ec0ffULL, 0x000000087c257812ULL, 0x000fc600078ec0ffULL,
0x0000002007247824ULL, 0x000fc800078e0224ULL, 0x00000001254a7824ULL, 0x000fe200078e0224ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e668004a487f8cULL, 0x0002a4000c80043fULL,
0x0000000000247805ULL, 0x000fc40000015200ULL, 0x01e66c004a277984ULL, 0x000ee40000000800ULL,
0x8000000027ff7812ULL, 0x00cfe40007804849ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ff00687202ULL, 0x000fe20000000f00ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026244b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09004b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c404b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000004b26267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000168687810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01e66c004a277984ULL, 0x000ea40000000800ULL, 0x8000000027ff7812ULL, 0x004fe40007804849ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000307247810ULL, 0x000fca0007ffe0ffULL,
0x0000008024247824ULL, 0x000fc800078e020dULL, 0x000000017d247824ULL, 0x000fca00078e0224ULL,
0x01e0000024487984ULL, 0x000ea80000000800ULL, 0x01e2000024497984ULL, 0x0006620000000800ULL,
0x000000214800720bULL, 0x004fe20003f1d000ULL, 0x000115a27f007947ULL, 0x000fd8000b800000ULL,
0x00000000004a7806ULL, 0x00afc800000e0100ULL, 0x000000ff4a00720cULL, 0x000fe20003f25270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x0000000307257810ULL, 0x000fe40007ffe0ffULL,
0x000000214800720bULL, 0x000fe40003f34000ULL, 0x000000002500720cULL, 0x000fe20003f05270ULL,
0x000115727f007947ULL, 0x000fd4000b800000ULL, 0x00000000004b7806ULL, 0x000fc400008e0100ULL,
0x0000000d00248211ULL, 0x000fe200078e38ffULL, 0x0000065000017945ULL, 0x000fe20003800000ULL,
0x00000021480d8209ULL, 0x000fc60007810000ULL, 0x000000017d248824ULL, 0x000fca00078e0224ULL,
0x01e4000d24008388ULL, 0x0003e20000000800ULL, 0x000000ff4b00720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000002148247209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff4bff7812ULL, 0x000fc6000780c0ffULL,
0x00000021240d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d006a7308ULL, 0x000e640000000800ULL, 0x0000006a23237220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff247819ULL, 0x000fe20000011603ULL,
0x000114b27f007947ULL, 0x000fea000b800000ULL, 0x00001f246a247589ULL, 0x0002a400000e0000ULL,
0x0000002464647220ULL, 0x084fe40000410000ULL, 0x0000002465657220ULL, 0x080fe40000410000ULL,
0x0000002460607220ULL, 0x080fe40000410000ULL, 0x0000002461617220ULL, 0x000fc40000410000ULL,
0x000000245c5c7220ULL, 0x080fe40000410000ULL, 0x000000245d5d7220ULL, 0x080fe40000410000ULL,
0x0000002458587220ULL, 0x080fe40000410000ULL, 0x0000002459597220ULL, 0x080fe40000410000ULL,
0x0000002454547220ULL, 0x080fe40000410000ULL, 0x0000002455557220ULL, 0x000fc40000410000ULL,
0x0000002450507220ULL, 0x080fe40000410000ULL, 0x0000002451517220ULL, 0x080fe40000410000ULL,
0x000000244c4c7220ULL, 0x080fe40000410000ULL, 0x000000244d4d7220ULL, 0x080fe40000410000ULL,
0x0000002428287220ULL, 0x080fe40000410000ULL, 0x0000002429297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff004bff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803247811ULL, 0x000fe200078ff0ffULL, 0x000113a27f007947ULL, 0x000fea000b800000ULL,
0x00001f246a247589ULL, 0x0004e400000e0000ULL, 0x0000002466667220ULL, 0x08cfe40000410000ULL,
0x0000002467677220ULL, 0x080fe40000410000ULL, 0x0000002462627220ULL, 0x080fe40000410000ULL,
0x0000002463637220ULL, 0x080fe40000410000ULL, 0x000000245e5e7220ULL, 0x080fe40000410000ULL,
0x000000245f5f7220ULL, 0x000fc40000410000ULL, 0x000000245a5a7220ULL, 0x080fe40000410000ULL,
0x000000245b5b7220ULL, 0x080fe40000410000ULL, 0x0000002456567220ULL, 0x080fe40000410000ULL,
0x0000002457577220ULL, 0x080fe40000410000ULL, 0x0000002452527220ULL, 0x080fe40000410000ULL,
0x0000002453537220ULL, 0x000fc40000410000ULL, 0x000000244e4e7220ULL, 0x080fe40000410000ULL,
0x000000244f4f7220ULL, 0x080fe40000410000ULL, 0x000000242a2a7220ULL, 0x080fe40000410000ULL,
0x000000242b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00004bff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001003247811ULL, 0x000fe200078ff0ffULL,
0x000112927f007947ULL, 0x000fea000b800000ULL, 0x00001f246a247589ULL, 0x0004e400000e0000ULL,
0x0000002444447220ULL, 0x08cfe40000410000ULL, 0x0000002445457220ULL, 0x080fe40000410000ULL,
0x0000002440407220ULL, 0x080fe40000410000ULL, 0x0000002441417220ULL, 0x080fe40000410000ULL,
0x000000243c3c7220ULL, 0x080fe40000410000ULL, 0x000000243d3d7220ULL, 0x000fc40000410000ULL,
0x0000002438387220ULL, 0x080fe40000410000ULL, 0x0000002439397220ULL, 0x080fe40000410000ULL,
0x0000002434347220ULL, 0x080fe40000410000ULL, 0x0000002435357220ULL, 0x080fe40000410000ULL,
0x0000002430307220ULL, 0x080fe40000410000ULL, 0x0000002431317220ULL, 0x000fc40000410000ULL,
0x000000242c2c7220ULL, 0x080fe40000410000ULL, 0x000000242d2d7220ULL, 0x080fe40000410000ULL,
0x0000002478787220ULL, 0x080fe40000410000ULL, 0x0000002479797220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000004bff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001803247811ULL, 0x000fe200078ff0ffULL,
0x000111927f007947ULL, 0x000fea000b800000ULL, 0x00001f246a247589ULL, 0x0004e400000e0000ULL,
0x0000002446467220ULL, 0x08cfe40000410000ULL, 0x0000002447477220ULL, 0x080fe40000410000ULL,
0x0000002442427220ULL, 0x080fe40000410000ULL, 0x0000002443437220ULL, 0x080fe40000410000ULL,
0x000000243e3e7220ULL, 0x080fe40000410000ULL, 0x000000243f3f7220ULL, 0x000fc40000410000ULL,
0x000000243a3a7220ULL, 0x080fe40000410000ULL, 0x000000243b3b7220ULL, 0x080fe40000410000ULL,
0x0000002436367220ULL, 0x080fe40000410000ULL, 0x0000002437377220ULL, 0x080fe40000410000ULL,
0x0000002432327220ULL, 0x080fe40000410000ULL, 0x0000002433337220ULL, 0x000fc40000410000ULL,
0x000000242e2e7220ULL, 0x080fe40000410000ULL, 0x000000242f2f7220ULL, 0x080fe40000410000ULL,
0x000000247a7a7220ULL, 0x080fe40000410000ULL, 0x000000247b7b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000004b4aff7212ULL, 0x000fe400078030ffULL,
0x0000002148217209ULL, 0x000fd60007810000ULL, 0x8000002148480221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b48480820ULL, 0x000fc80000410000ULL, 0x00000048000e0308ULL, 0x000e640000000800ULL,
0x0000000e49490220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000002349237221ULL, 0x000fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x0000000eff0d723eULL, 0x000fe400000000ffULL,
0x00000002ff127819ULL, 0x000fe40000011603ULL, 0x000054100d0d7816ULL, 0x000fe2000000000dULL,
0x00010ff27f007947ULL, 0x000fea000b800000ULL, 0x00001f120d0f7589ULL, 0x0002a400000e0000ULL,
0x0000000812247810ULL, 0x000fe20007ffe0ffULL, 0x000110427f007947ULL, 0x000fea000b800000ULL,
0x0000001012267810ULL, 0x000fe20007ffe0ffULL, 0x00001f240d107589ULL, 0x00066800000e0000ULL,
0x00001f260d117589ULL, 0x0006a400000e0000ULL, 0x0000001812247810ULL, 0x008fe20007ffe0ffULL,
0x000110d27f007947ULL, 0x000fea000b800000ULL, 0x00001f240d127589ULL, 0x0022e400000e0000ULL,
0x00000003070d7810ULL, 0x002fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0001700022227810ULL, 0x000fe20007ffe0ffULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x000120000d0d7811ULL, 0x000fc600078e60ffULL, 0x00000010166c7824ULL, 0x100fe400078e0222ULL,
0x0000001014147824ULL, 0x100fe400078e020dULL, 0x0000001013137824ULL, 0x000fe400078e020dULL,
0x0000001015687824ULL, 0x100fe400078e0222ULL, 0x0000001017487824ULL, 0x000fe200078e0222ULL,
0x000000001370783bULL, 0x0002e80000000200ULL, 0x000000001414783bULL, 0x000ea20000000200ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000000f70707232ULL, 0x08cfe40000000000ULL,
0x0000000f72727232ULL, 0x000fc40000000000ULL, 0x0000001071717232ULL, 0x080fe40000000000ULL,
0x0000001073737232ULL, 0x000fe40000000000ULL, 0x0000001114147232ULL, 0x080fe40000000000ULL,
0x0000001116167232ULL, 0x000fe40000000000ULL, 0x0000001215157232ULL, 0x080fe40000000000ULL,
0x0000001217177232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002218247211ULL, 0x000fe200078e20ffULL, 0x000000004848783bULL, 0x000e620000004200ULL,
0x000000101a1a7824ULL, 0x100fe200078e020dULL, 0x0000024000007945ULL, 0x000fe20003800000ULL,
0x000000101c1c7824ULL, 0x100fe200078e0222ULL, 0x000000006868783bULL, 0x000ee80000004200ULL,
0x000000006c6c783bULL, 0x000ea80000004200ULL, 0x000000002424783bULL, 0x000ea20000004200ULL,
0x000000487054723cULL, 0x08af700000001854ULL, 0x000000481434723cULL, 0x004b6e0000001834ULL,
0x0000001019487824ULL, 0x020fe200078e020dULL, 0x00000068705c723cULL, 0x080f70000000185cULL,
0x00000068143c723cULL, 0x000b6e000000183cULL, 0x000000101b687824ULL, 0x120fe200078e0222ULL,
0x0000004a7050723cULL, 0x000f620000001850ULL, 0x000000001a18783bULL, 0x000e6e0000000200ULL,
0x0000006c1444723cULL, 0x040f700000001844ULL, 0x0000006e1440723cULL, 0x040f700000001840ULL,
0x0000006a1438723cULL, 0x040f700000001838ULL, 0x0000004a1430723cULL, 0x040b640000001830ULL,
0x000000004848783bULL, 0x020eac0000000200ULL, 0x00000024142c723cULL, 0x000f70000000182cULL,
0x0000006c7064723cULL, 0x040b6e0000001864ULL, 0x000000101d6c7824ULL, 0x020fe200078e0222ULL,
0x0000006e7060723cULL, 0x040b700000001860ULL, 0x0000006a7058723cULL, 0x040b700000001858ULL,
0x00000024704c723cULL, 0x040b70000000184cULL, 0x000000267028723cULL, 0x080b700000001828ULL,
0x000000261414723cULL, 0x000b620000001878ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000008000008947ULL, 0x000fde0003800000ULL, 0x0000000f48487232ULL, 0x086fe40000000000ULL,
0x0000000f4a4a7232ULL, 0x000fc40000000000ULL, 0x0000001049497232ULL, 0x080fe40000000000ULL,
0x000000104b4b7232ULL, 0x000fe40000000000ULL, 0x0000001118187232ULL, 0x080fe40000000000ULL,
0x000000111a1a7232ULL, 0x000fe40000000000ULL, 0x0000001219197232ULL, 0x080fe40000000000ULL,
0x000000121b1b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x006fea0003800000ULL,
0x000000101e247824ULL, 0x020fe200078e0222ULL, 0x000000006868783bULL, 0x000e620000004200ULL,
0x0001e6a0070d7811ULL, 0x000fc600078e18ffULL, 0x000000001c70783bULL, 0x000ea80000004200ULL,
0x000000006c6c783bULL, 0x000ee80000004200ULL, 0x000000002424783bULL, 0x000ea20000004200ULL,
0x000000684864723cULL, 0x042b700000001864ULL, 0x0000006a4860723cULL, 0x040b700000001860ULL,
0x00000070485c723cULL, 0x044b70000000185cULL, 0x000000724858723cULL, 0x040b700000001858ULL,
0x0000006c4854723cULL, 0x048b700000001854ULL, 0x0000006e4850723cULL, 0x040b700000001850ULL,
0x00000024484c723cULL, 0x040b70000000184cULL, 0x000000264848723cULL, 0x000b700000001828ULL,
0x000000681844723cULL, 0x040b700000001844ULL, 0x0000006a1840723cULL, 0x040b700000001840ULL,
0x00000070183c723cULL, 0x040b70000000183cULL, 0x000000721838723cULL, 0x040b700000001838ULL,
0x0000006c1834723cULL, 0x040b700000001834ULL, 0x0000006e1830723cULL, 0x040b700000001830ULL,
0x00000024182c723cULL, 0x040b70000000182cULL, 0x000000261828723cULL, 0x000b620000001814ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000060200720cULL, 0x000fe20003f06070ULL,
0x000000000dff7f8cULL, 0x0003d8000c80043fULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff805000007947ULL, 0x000fea000383ffffULL, 0x0000000000057919ULL, 0x002e640000002500ULL,
0x000000060500720cULL, 0x002fda0003f06070ULL, 0x0000057000000947ULL, 0x000fea0003800000ULL,
0x0180000023027810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000002027812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e0023ULL,
0x00009dc0000a7802ULL, 0x000fc40000000f00ULL, 0x00010ea000007944ULL, 0x030fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002300027308ULL, 0x000e640000001000ULL,
0xbf80000002037423ULL, 0x002fc80000000023ULL, 0x800000ff03037221ULL, 0x000fc80000010100ULL,
0x0000000302027223ULL, 0x000fc40000000002ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e640000000000ULL, 0x00000002ff037819ULL, 0x002fe40000011604ULL,
0x0000001804077811ULL, 0x040fe400078ff0ffULL, 0x00000008040d7811ULL, 0x040fe400078ff0ffULL,
0x00000010040f7811ULL, 0x000fe200078ff0ffULL, 0x00001f0302037589ULL, 0x008e6800000e0000ULL,
0x00001f0702077589ULL, 0x000ea800000e0000ULL, 0x00001f0d02047589ULL, 0x000ee800000e0000ULL,
0x00001f0f02067589ULL, 0x000ea200000e0000ULL, 0x0000006403647220ULL, 0x022fc40000410000ULL,
0x0000006503657220ULL, 0x040fe40000410000ULL, 0x0000006003607220ULL, 0x040fe40000410000ULL,
0x0000006103617220ULL, 0x040fe40000410000ULL, 0x0000005c035c7220ULL, 0x040fe40000410000ULL,
0x0000005d035d7220ULL, 0x040fe40000410000ULL, 0x0000005803587220ULL, 0x000fc40000410000ULL,
0x0000005903597220ULL, 0x040fe40000410000ULL, 0x0000005403547220ULL, 0x040fe40000410000ULL,
0x0000005503557220ULL, 0x040fe40000410000ULL, 0x0000005003507220ULL, 0x040fe40000410000ULL,
0x0000005103517220ULL, 0x040fe40000410000ULL, 0x0000004c034c7220ULL, 0x000fc40000410000ULL,
0x0000004d034d7220ULL, 0x040fe40000410000ULL, 0x0000004803487220ULL, 0x040fe40000410000ULL,
0x0000004903497220ULL, 0x000fe40000410000ULL, 0x0000004607467220ULL, 0x044fe40000410000ULL,
0x0000004707477220ULL, 0x040fe40000410000ULL, 0x0000004207427220ULL, 0x000fc40000410000ULL,
0x0000004307437220ULL, 0x040fe40000410000ULL, 0x0000003e073e7220ULL, 0x040fe40000410000ULL,
0x0000003f073f7220ULL, 0x040fe40000410000ULL, 0x0000003a073a7220ULL, 0x040fe40000410000ULL,
0x0000003b073b7220ULL, 0x040fe40000410000ULL, 0x0000003607367220ULL, 0x000fc40000410000ULL,
0x0000003707377220ULL, 0x040fe40000410000ULL, 0x0000003207327220ULL, 0x040fe40000410000ULL,
0x0000003307337220ULL, 0x040fe40000410000ULL, 0x0000002e072e7220ULL, 0x040fe40000410000ULL,
0x0000002f072f7220ULL, 0x040fe40000410000ULL, 0x0000002a072a7220ULL, 0x000fc40000410000ULL,
0x0000002b072b7220ULL, 0x000fe40000410000ULL, 0x0000000466667220ULL, 0x088fe40000410000ULL,
0x0000000467677220ULL, 0x080fe40000410000ULL, 0x0000000462627220ULL, 0x080fe40000410000ULL,
0x0000000463637220ULL, 0x080fe40000410000ULL, 0x000000045e5e7220ULL, 0x000fc40000410000ULL,
0x000000045f5f7220ULL, 0x080fe40000410000ULL, 0x000000045a5a7220ULL, 0x080fe40000410000ULL,
0x000000045b5b7220ULL, 0x080fe40000410000ULL, 0x0000000456567220ULL, 0x080fe40000410000ULL,
0x0000000457577220ULL, 0x080fe40000410000ULL, 0x0000000452527220ULL, 0x000fc40000410000ULL,
0x0000000453537220ULL, 0x080fe40000410000ULL, 0x000000044e4e7220ULL, 0x080fe40000410000ULL,
0x000000044f4f7220ULL, 0x080fe40000410000ULL, 0x000000044a4a7220ULL, 0x080fe40000410000ULL,
0x000000044b4b7220ULL, 0x000fe40000410000ULL, 0x0000000644447220ULL, 0x000fc40000410000ULL,
0x0000000645457220ULL, 0x080fe40000410000ULL, 0x0000000640407220ULL, 0x080fe40000410000ULL,
0x0000000641417220ULL, 0x080fe40000410000ULL, 0x000000063c3c7220ULL, 0x080fe40000410000ULL,
0x000000063d3d7220ULL, 0x080fe40000410000ULL, 0x0000000638387220ULL, 0x000fc40000410000ULL,
0x0000000639397220ULL, 0x080fe40000410000ULL, 0x0000000634347220ULL, 0x080fe40000410000ULL,
0x0000000635357220ULL, 0x080fe40000410000ULL, 0x0000000630307220ULL, 0x080fe40000410000ULL,
0x0000000631317220ULL, 0x080fe40000410000ULL, 0x000000062c2c7220ULL, 0x000fc40000410000ULL,
0x000000062d2d7220ULL, 0x080fe40000410000ULL, 0x0000000628287220ULL, 0x080fe40000410000ULL,
0x0000000629297220ULL, 0x000fc40000410000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0000002c2d2c723eULL, 0x020fe200000000ffULL, 0x00000300ff207624ULL, 0x000fe200078e00ffULL,
0x0000002a2b19723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000282928723eULL, 0x000fc400000000ffULL, 0x0000002e2f18723eULL, 0x000fe400000000ffULL,
0x000000303130723eULL, 0x000fe400000000ffULL, 0x000000646506723eULL, 0x000fe400000000ffULL,
0x000000606107723eULL, 0x000fe400000000ffULL, 0x0000005c5d0a723eULL, 0x000fe400000000ffULL,
0x00000058590d723eULL, 0x000fc400000000ffULL, 0x00000002ff1c7819ULL, 0x002fe40000011602ULL,
0x00000008022f7811ULL, 0x000fe400078ff0ffULL, 0x000000031c0c7810ULL, 0x040fe20007ffe0ffULL,
0x000000081c257824ULL, 0x040fe200078e00ffULL, 0x000000041c1a7810ULL, 0x040fe20007ffe0ffULL,
0x000000081c277824ULL, 0x040fe200078e00ffULL, 0x000000011c037810ULL, 0x040fe20007ffe0ffULL,
0x000000081c1e7824ULL, 0x040fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee20cULL,
0x000000081c2d7824ULL, 0x040fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee21aULL,
0x000000081c1a7824ULL, 0x040fe200078e00ffULL, 0x000000021c047810ULL, 0x040fe20007ffe0ffULL,
0x000000081c1b7824ULL, 0x040fe200078e00ffULL, 0x000000031c1f7819ULL, 0x050fe200000006ffULL,
0x000000081c2b7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1d7812ULL, 0x000fe200078ee203ULL,
0x000000082f1e7824ULL, 0x000fe200078e00ffULL, 0xffffffff1c0c7810ULL, 0x000fc40007ffe0ffULL,
0x000000051c037810ULL, 0x040fe40007ffe0ffULL, 0xfffffff81f1f7812ULL, 0x000fe400078ee204ULL,
0xfffffff82d2d7812ULL, 0x000fe400078ee20cULL, 0x000000061c047810ULL, 0x000fe40007ffe0ffULL,
0xfffffff81a297812ULL, 0x000fe200078ee203ULL, 0x000020000b037824ULL, 0x000fe200078e00ffULL,
0x0000000c080c7819ULL, 0x000fe200000006ffULL, 0x00000004021a7824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fc400078ee21cULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee204ULL,
0x0000000103047824ULL, 0x000fe200078e020cULL, 0x0000000c1a1a7812ULL, 0x000fe400078ec0ffULL,
0x0000001002317811ULL, 0x000fe200078ff0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0204ULL,
0xfffffff81e2f7812ULL, 0x000fe200078ee22fULL, 0x000000101d1d7824ULL, 0x100fe200078e0204ULL,
0x0000000427277211ULL, 0x000fe200078e20ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0204ULL,
0x00000054550e723eULL, 0x000fe200000000ffULL, 0x0000001025257824ULL, 0x000fe200078e0204ULL,
0x000000323317723eULL, 0x000fe200000000ffULL, 0x000000011b1b7824ULL, 0x000fe200078e021aULL,
0x0000001f1a1f7210ULL, 0x040fe20007ffe0ffULL, 0x0000001029297824ULL, 0x100fe200078e0204ULL,
0x00000050510f723eULL, 0x000fe200000000ffULL, 0x000000011a1d7824ULL, 0x000fe200078e021dULL,
0x0000001802337811ULL, 0x000fe200078ff0ffULL, 0x00000008311c7824ULL, 0x000fe200078e00ffULL,
0x000000061b007388ULL, 0x000fe20000000800ULL, 0x000000102b2b7824ULL, 0x100fe200078e0204ULL,
0x0000004c4d10723eULL, 0x000fe200000000ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0204ULL,
0x000000071d007388ULL, 0x000fe20000000800ULL, 0x000000011a257824ULL, 0x000fe200078e0225ULL,
0x000000484911723eULL, 0x000fe200000000ffULL, 0x000000102f2f7824ULL, 0x100fe200078e0204ULL,
0xfffffff81c317812ULL, 0x000fe200078ee231ULL, 0x000000011a277824ULL, 0x040fe200078e0227ULL,
0x0000000a1f007388ULL, 0x000fe20000000800ULL, 0x000000011a297824ULL, 0x040fe200078e0229ULL,
0x000000666766723eULL, 0x000fe200000000ffULL, 0x000000011a2b7824ULL, 0x040fe200078e022bULL,
0x0000000d25007388ULL, 0x000fe20000000800ULL, 0x000000011a2d7824ULL, 0x040fe200078e022dULL,
0x000000626362723eULL, 0x000fe200000000ffULL, 0x000000011a2f7824ULL, 0x040fe200078e022fULL,
0x0000000e27007388ULL, 0x0003e20000000800ULL, 0x0000005e5f5e723eULL, 0x000fe200000000ffULL,
0x00000008331e7824ULL, 0x000fe200078e00ffULL, 0x0000005a5b5a723eULL, 0x000fe200000000ffULL,
0x0000000f29007388ULL, 0x000fe20000000800ULL, 0x000000565756723eULL, 0x000fe200000000ffULL,
0x0000001031317824ULL, 0x000fe200078e0204ULL, 0x000000525352723eULL, 0x000fe200000000ffULL,
0x000000102b007388ULL, 0x000fe20000000800ULL, 0x0000004e4f4e723eULL, 0x000fe200000000ffULL,
0x000000011a317824ULL, 0x000fe200078e0231ULL, 0x0000004a4b4a723eULL, 0x000fe200000000ffULL,
0x000000112d007388ULL, 0x000fe20000000800ULL, 0xfffffff81e337812ULL, 0x000fc400078ee233ULL,
0x000000444544723eULL, 0x000fe200000000ffULL, 0x000000662f007388ULL, 0x000fe20000000800ULL,
0x000000404140723eULL, 0x000fe200000000ffULL, 0x0000001033337824ULL, 0x000fe200078e0204ULL,
0x0000003c3d3c723eULL, 0x000fe200000000ffULL, 0x000400621d007388ULL, 0x000fe20000000800ULL,
0x000000383938723eULL, 0x000fe200000000ffULL, 0x000000011a337824ULL, 0x000fe200078e0233ULL,
0x000000343534723eULL, 0x000fe200000000ffULL, 0x0004005e1f007388ULL, 0x000fe20000000800ULL,
0x000000464712723eULL, 0x000fc400000000ffULL, 0x000000424313723eULL, 0x000fe200000000ffULL,
0x0004005a25007388ULL, 0x000fe20000000800ULL, 0x0000003e3f14723eULL, 0x000fe400000000ffULL,
0x0000003a3b15723eULL, 0x000fe200000000ffULL, 0x0004005627007388ULL, 0x000fe20000000800ULL,
0x000000363716723eULL, 0x000fe400000000ffULL, 0x00000002090e7210ULL, 0x002fe20007ffe0ffULL,
0x0004005229007388ULL, 0x000fe20000000800ULL, 0x000000012000780cULL, 0x000fc60003f05270ULL,
0x0004004e2b007388ULL, 0x000fe20000000800ULL, 0x000000100e0d7824ULL, 0x000fc600078e0203ULL,
0x0004004a2d007388ULL, 0x000fe80000000800ULL, 0x0000004431007388ULL, 0x000fe80000000800ULL,
0x000800401d007388ULL, 0x000fe80000000800ULL, 0x0008003c1f007388ULL, 0x000fe80000000800ULL,
0x0008003825007388ULL, 0x000fe80000000800ULL, 0x0008003427007388ULL, 0x000fe80000000800ULL,
0x0008003029007388ULL, 0x000fe80000000800ULL, 0x0008002c2b007388ULL, 0x000fe80000000800ULL,
0x000800282d007388ULL, 0x000fe80000000800ULL, 0x0000001233007388ULL, 0x000fe80000000800ULL,
0x000c00131d007388ULL, 0x000fe80000000800ULL, 0x000c00141f007388ULL, 0x000fe80000000800ULL,
0x000c001525007388ULL, 0x000fe80000000800ULL, 0x000c001627007388ULL, 0x000fe80000000800ULL,
0x000c001729007388ULL, 0x000fe80000000800ULL, 0x000c00182b007388ULL, 0x000fe80000000800ULL,
0x000c00192d007388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000d307984ULL, 0x000e680000000c00ULL, 0x000400000d1c7984ULL, 0x000ea80000000c00ULL,
0x000800000d387984ULL, 0x000ee80000000c00ULL, 0x000c00000d147984ULL, 0x000ee80000000c00ULL,
0x001000000d107984ULL, 0x000ee80000000c00ULL, 0x001400000d347984ULL, 0x000ee80000000c00ULL,
0x001800000d247984ULL, 0x000ee80000000c00ULL, 0x001c00000d3c7984ULL, 0x000ee20000000c00ULL,
0x200000ff33337230ULL, 0x002fc40000000000ULL, 0x200000ff32327230ULL, 0x000fe40000000000ULL,
0x200000ff31317230ULL, 0x000fe40000000000ULL, 0x200000ff30307230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x004fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fc40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff3b3b7230ULL, 0x008fe40000000000ULL, 0x200000ff3a3a7230ULL, 0x000fe40000000000ULL,
0x200000ff39397230ULL, 0x000fe40000000000ULL, 0x200000ff38387230ULL, 0x000fe40000000000ULL,
0x200000ff17177230ULL, 0x000fc40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fe40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x0000001333337230ULL, 0x000fe40000000000ULL, 0x0000001232327230ULL, 0x000fe40000000000ULL,
0x0000001131317230ULL, 0x000fc40000000000ULL, 0x0000001030307230ULL, 0x000fe40000000000ULL,
0x000000371f1f7230ULL, 0x000fe40000000000ULL, 0x000000361e1e7230ULL, 0x000fe20000000000ULL,
0x000000300d007388ULL, 0x000fe20000000c00ULL, 0x000000351d1d7230ULL, 0x000fe40000000000ULL,
0x000000341c1c7230ULL, 0x000fe40000000000ULL, 0x000000273b3b7230ULL, 0x000fc40000000000ULL,
0x000000263a3a7230ULL, 0x000fe20000000000ULL, 0x0004001c0d007388ULL, 0x000fe20000000c00ULL,
0x0000002539397230ULL, 0x000fe40000000000ULL, 0x0000002438387230ULL, 0x000fe40000000000ULL,
0x0000003f17177230ULL, 0x000fe40000000000ULL, 0x0000003e16167230ULL, 0x000fe20000000000ULL,
0x000800380d007388ULL, 0x000fe20000000c00ULL, 0x0000003d15157230ULL, 0x000fc40000000000ULL,
0x0000003c14147230ULL, 0x000fca0000000000ULL, 0x000c00140d007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000396000008947ULL, 0x000fea0003800000ULL,
0x00000400ff067624ULL, 0x000fe200078e00ffULL, 0x0000000000187919ULL, 0x000e620000002600ULL,
0x000000400e117810ULL, 0x000fc40007ffe0ffULL, 0x00006a0006067a24ULL, 0x000fe200078e02ffULL,
0x00000000000f7919ULL, 0x000e620000002700ULL, 0x000000800e137810ULL, 0x000fc60007ffe0ffULL,
0x0000000f06077811ULL, 0x040fe200078e10ffULL, 0x0000030006067a24ULL, 0x000fe200078e02ffULL,
0x000000000d1c7984ULL, 0x000ea40000000c00ULL, 0xfffffff007257812ULL, 0x000fe400078ec0ffULL,
0x000400000d287984ULL, 0x000ee60000000c00ULL, 0x0000008006277824ULL, 0x040fe200078e0225ULL,
0x000800000d2c7984ULL, 0x000ea60000000c00ULL, 0x0000008006067824ULL, 0x000fe200078e0227ULL,
0x000c00000d307984ULL, 0x0008a80000000c00ULL, 0x0000007f06067810ULL, 0x000fe20007ffe0ffULL,
0x000004000f187a24ULL, 0x002fc600078e0218ULL, 0xffffff8006197812ULL, 0x000fe200078ec0ffULL,
0x00000300180a7a24ULL, 0x000fe200078e02ffULL, 0x000000c00e0d7810ULL, 0x010fe40007ffe0ffULL,
0x00006e0019067a10ULL, 0x000fe20007f1e0ffULL, 0x000000010a057824ULL, 0x000fc800078e0205ULL,
0x00006f00ff107624ULL, 0x000fe200000e06ffULL, 0x0000000605067211ULL, 0x040fe400078268ffULL,
0x0000000108ff7812ULL, 0x000fe4000780f800ULL, 0x0000001005077211ULL, 0x000fe400008f6cffULL,
0x00006e00251b7a10ULL, 0x000fc60007f3e0ffULL, 0x000010000b067825ULL, 0x000fc800078e0006ULL,
0x00006f00ff1a7624ULL, 0x000fe400008e06ffULL, 0x000000100e0e7825ULL, 0x000fc800078e0006ULL,
0x0000001011107825ULL, 0x000fc800078e0006ULL, 0x0000001013127825ULL, 0x000fc800078e0006ULL,
0x000000100d067825ULL, 0x000fe200078e0006ULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x00000004020d7819ULL, 0x00cfe200000006ffULL, 0x0000008005147824ULL, 0x000fe200078e00ffULL,
0x00000001ff157819ULL, 0x000fe40000011602ULL, 0x000000700d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000000c15157812ULL, 0x000fe400078ec0ffULL, 0x00006e0014167a10ULL, 0x000fe40007ebe027ULL,
0x00000019ff057819ULL, 0x000fc40000011605ULL, 0x0000001b0d147210ULL, 0x000fe40007a3e014ULL,
0x0000001615167210ULL, 0x000fe40007c7e00dULL, 0x00006f00050d7a10ULL, 0x000fe40002fec4ffULL,
0x0000001415147210ULL, 0x000fe40007fbe0ffULL, 0x0000001aff057210ULL, 0x000fe40000fe4405ULL,
0x0000000dff177210ULL, 0x000fc60001fe84ffULL, 0x000000ffff157224ULL, 0x000fca00028e0605ULL,
0x0000002114007986ULL, 0x0003e8000c101908ULL, 0x0000002316007986ULL, 0x0003e4000c101908ULL,
0x000000ff0200720cULL, 0x00cfe20000705670ULL, 0x0000001c0e007986ULL, 0x000fe2000c101d08ULL,
0x0000017000007945ULL, 0x000fe60003800000ULL, 0x0000002810007986ULL, 0x000fe8000c101d08ULL,
0x0000002c12007986ULL, 0x000fe8000c101d08ULL, 0x0000003006007986ULL, 0x000fe8000c101d08ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000011000000947ULL, 0x000fea0003800000ULL,
0x00000004ff077424ULL, 0x000fe200078e00ffULL, 0xffffffff20057810ULL, 0x000fc60007ffe0ffULL,
0x00006e0018067625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x00000005060679a8ULL, 0x000ea400099ee1c8ULL, 0x000000050600720cULL, 0x004fc80003f05270ULL,
0x00000001ff0d7807ULL, 0x000fe20000000000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000ff00798fULL, 0x000fca0002000000ULL,
0x0000000dff007388ULL, 0x0005e40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000ff057984ULL, 0x000ee40000000000ULL,
0x000000ff0500720cULL, 0x008fda0003f05270ULL, 0x0000346000008947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x00000a5000000947ULL, 0x000fea0003800000ULL,
0x00000300ff007a0cULL, 0x000fda0003f05270ULL, 0x000001b000008947ULL, 0x000fea0003800000ULL,
0x0000001002007824ULL, 0x000fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fe40000011602ULL,
0x0000001b0a067211ULL, 0x000fe400078038ffULL, 0x0000007000077812ULL, 0x000fe400078ec0ffULL,
0x0000000c05057812ULL, 0x000fe400078ec0ffULL, 0x0000001a0a007211ULL, 0x000fe400000f3cffULL,
0x0000000605067210ULL, 0x000fc8000791e007ULL, 0x00000000ff077210ULL, 0x000fca00007e24ffULL,
0x0000000806007981ULL, 0x000728000c1e1900ULL, 0x0000800806057981ULL, 0x000722000c1e1900ULL,
0x000000022000780cULL, 0x000fda0003f05270ULL, 0x000000f000008947ULL, 0x000fea0003800000ULL,
0x00010008060d7981ULL, 0x00c522000c1e1900ULL, 0x000000042000780cULL, 0x000fda0003f06070ULL,
0x000000c000008947ULL, 0x000fea0003800000ULL, 0x00018008060f7981ULL, 0x004522000c1e1900ULL,
0x000000042000780cULL, 0x000fda0003f05270ULL, 0x0000009000008947ULL, 0x000fea0003800000ULL,
0x0002000806117981ULL, 0x004522000c1e1900ULL, 0x000000062000780cULL, 0x000fda0003f06070ULL,
0x0000006000008947ULL, 0x000fea0003800000ULL, 0x0002800806137981ULL, 0x004522000c1e1900ULL,
0x000000062000780cULL, 0x000fda0003f05270ULL, 0x0000003000008947ULL, 0x000fea0003800000ULL,
0x000000082000780cULL, 0x004fe20003f06070ULL, 0x0003000806157981ULL, 0x002318000c1e1900ULL,
0x0003800806170981ULL, 0x000324000c1e1900ULL, 0x0000000720067810ULL, 0x00efc80007ffe0ffULL,
0x00000003ff0e7819ULL, 0x000fc80000011606ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x000007d000008947ULL, 0x000fea0003800000ULL, 0x000000250a1d7211ULL, 0x040fe200078038ffULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x0000003f00047c82ULL, 0x000fe20008000000ULL,
0x000000ffff1b7224ULL, 0x010fe200078e0000ULL, 0x00006e001d1d7a10ULL, 0x000fe40007f3e0ffULL,
0x000000ff0a107211ULL, 0x000fe400000f3cffULL, 0x000007801d1d7810ULL, 0x000fc80007f5e0ffULL,
0x00006f00ff107a10ULL, 0x000fc400017e2410ULL, 0x0000030012007a0cULL, 0x000fe20003f26070ULL,
0x0000000104047890ULL, 0x000fcc000fffe03fULL, 0x000000040e007c0cULL, 0x000fcc000bf03070ULL,
0x000006d000001947ULL, 0x012fea0003800000ULL, 0x0000000812067810ULL, 0x040fe40007ffe0ffULL,
0x0000000112077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001b00007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001002067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011602ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0610ULL, 0xfffc8008061b7981ULL, 0x000326000c1e1900ULL,
0x000005f000002947ULL, 0x000fea0003800000ULL, 0x0000000912067810ULL, 0x042fe40007ffe0ffULL,
0x0000000212077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000500007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000000402057819ULL, 0x000fe400000006ffULL,
0x00000001ff067819ULL, 0x000fe40000011602ULL, 0x0000007005057812ULL, 0x000fc800078ec0ffULL,
0x0000000c05067812ULL, 0x000fc800078ef806ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0610ULL, 0xfffd000806057981ULL, 0x000326000c1e1900ULL,
0x0000051000002947ULL, 0x000fea0003800000ULL, 0x0000000a12067810ULL, 0x042fe40007ffe0ffULL,
0x0000000312077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000d00007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001002067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011602ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0610ULL, 0xfffd8008060d7981ULL, 0x000326000c1e1900ULL,
0x0000043000002947ULL, 0x000fea0003800000ULL, 0x0000000b12067810ULL, 0x042fe40007ffe0ffULL,
0x0000000412077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000000f00007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001002067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011602ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0610ULL, 0xfffe0008060f7981ULL, 0x000326000c1e1900ULL,
0x0000035000002947ULL, 0x000fea0003800000ULL, 0x0000000c12067810ULL, 0x042fe40007ffe0ffULL,
0x0000000512077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001100007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001002067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011602ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0610ULL, 0xfffe800806117981ULL, 0x000326000c1e1900ULL,
0x0000027000002947ULL, 0x000fea0003800000ULL, 0x0000000d12067810ULL, 0x042fe40007ffe0ffULL,
0x0000000612077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001300007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001002067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011602ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fc80007f3e0ffULL,
0x00000010ff077210ULL, 0x000fca0000ffe4ffULL, 0xffff000806137981ULL, 0x000328000c1e1900ULL,
0x0000019000002947ULL, 0x000fea0003800000ULL, 0x0000000e12067810ULL, 0x042fe40007ffe0ffULL,
0x0000000712077810ULL, 0x000fe40007ffe0ffULL, 0x0000030006007a0cULL, 0x000fe40003f26070ULL,
0x0000030007007a0cULL, 0x000fe40003f46070ULL, 0x0000001500007209ULL, 0x000fd20007810000ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001002067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011602ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0610ULL, 0xffff800806157981ULL, 0x000326000c1e1900ULL,
0x000000b000002947ULL, 0x000fea0003800000ULL, 0x0000000f12067810ULL, 0x002fe40007ffe0ffULL,
0x0000001700007209ULL, 0x000fe40007810000ULL, 0x0000030006007a0cULL, 0x000fda0003f26070ULL,
0x0000007000001947ULL, 0x000fea0003800000ULL, 0x0000001002067824ULL, 0x000fe200078e00ffULL,
0x00000001ff077819ULL, 0x000fc80000011602ULL, 0x0000007006067812ULL, 0x000fc800078ec0ffULL,
0x0000000c06067812ULL, 0x000fc800078ef807ULL, 0x000000061d067210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff077224ULL, 0x000fca00008e0610ULL, 0x0000000806177981ULL, 0x000326000c1e1900ULL,
0x000004001d1d7810ULL, 0x000fe40007f3e0ffULL, 0x0000000812127810ULL, 0x000fc60007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200008e0610ULL, 0xfffff8b000008947ULL, 0x000fea000383ffffULL,
0x0000000000027919ULL, 0x000ea40000000000ULL, 0x0000001002057824ULL, 0x014fe200078e00ffULL,
0x00000001ff067819ULL, 0x002fc80000011602ULL, 0x0000007005057812ULL, 0x000fe400078ec0ffULL,
0x0000000c06067812ULL, 0x000fca00078ec0ffULL, 0x0000000105057824ULL, 0x000fca00078e0206ULL,
0x0000000005007388ULL, 0x0003e40000000800ULL, 0x000000070200780cULL, 0x040fe20003f04070ULL,
0x000010000b007824ULL, 0x002fe200078e00ffULL, 0x00006e0019067a10ULL, 0x000fe20007f3e0ffULL,
0x0000001002137824ULL, 0x000fe200078e00ffULL, 0x0000000a08117210ULL, 0x040fe20007ffe0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00006f00ff077624ULL, 0x000fe200008e06ffULL,
0x0000000108057812ULL, 0x040fe200078ec0ffULL, 0x0000000208108824ULL, 0x100fe200078e020bULL,
0x000010000c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000000208128824ULL, 0x000fe200078e020bULL,
0x0000002002177810ULL, 0x040fe20007ffe0ffULL, 0x00002000110e7825ULL, 0x000fe200078e0006ULL,
0x0000004002197810ULL, 0x040fe20007ffe0ffULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000060021b7810ULL, 0x000fe20007ffe0ffULL, 0x00000002102b8824ULL, 0x100fe200078e0205ULL,
0x000000000e0e7210ULL, 0x000fe20007f3e0ffULL, 0x00000002122d8824ULL, 0x000fe200078e0205ULL,
0x00000001ff127819ULL, 0x100fe20000011602ULL, 0x0000400008057824ULL, 0x000fe200078e0203ULL,
0x00000080021d7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff0f7224ULL, 0x000fe200008e060fULL,
0x000000a0021f7810ULL, 0x040fe20007ffe0ffULL, 0x000000082b2b8824ULL, 0x000fe200078e0202ULL,
0x0000000c050d7210ULL, 0x004fe20007ffe0ffULL, 0x0000001017167825ULL, 0x000fe200078e000eULL,
0x000000c002217810ULL, 0x040fe20007ffe0ffULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x000000e002237810ULL, 0x040fe20007ffe0ffULL, 0x0000001002297824ULL, 0x000fe200078e020dULL,
0x0000007013137812ULL, 0x000fe200078ec0ffULL, 0x0000001019187825ULL, 0x100fe200078e000eULL,
0x0000000c12127812ULL, 0x000fe200078ec0ffULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00006e00270d7a10ULL, 0x000fe20007f3e0ffULL, 0x000000101b1a7825ULL, 0x100fe200078e000eULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x000000101d1c7825ULL, 0x100fe200078e000eULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x000000101f1e7825ULL, 0x100fe200078e000eULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000001021207825ULL, 0x100fe200078e000eULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000001023227825ULL, 0x100fe200078e000eULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x0000001002147825ULL, 0x000fe200078e000eULL,
0x00006e00250e7a10ULL, 0x000fc40007f5e0ffULL, 0x000000ff00547202ULL, 0x000fe20000000f00ULL,
0x00000001130c7824ULL, 0x000fe400078e0212ULL, 0x00006f00ff0f7624ULL, 0x000fe200008e06ffULL,
0x0000000d11248211ULL, 0x040fe200078238ffULL, 0x00006f00ff107624ULL, 0x000fe200010e06ffULL,
0x0000000e11268211ULL, 0x040fe200078438ffULL, 0x000000000c0c7984ULL, 0x000e620000000800ULL,
0x0000000f11258211ULL, 0x000fe200008f3cffULL, 0x000000082d2d8824ULL, 0x000fe200078e0202ULL,
0x0000030008007a0cULL, 0x000fe20003f26070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000014297faeULL, 0x0005e2000b901c48ULL, 0x0000001011278211ULL, 0x000fe200010f3cffULL,
0x0000001002248825ULL, 0x000fc400078e0024ULL, 0x0038000016297faeULL, 0x0007e4000b901c48ULL,
0x0000001002268825ULL, 0x000fe400078e0026ULL, 0x0058000018297faeULL, 0x0009e4000b901c48ULL,
0x000000ffff117224ULL, 0x000fe400078e00ffULL, 0x007800001a297faeULL, 0x0009e2000b901c48ULL,
0x0000000000147805ULL, 0x004fe2000001ff00ULL, 0x000000ffff527224ULL, 0x000fc400078e00ffULL,
0x009800001c297faeULL, 0x0005e2000b901c48ULL, 0x0000000000167805ULL, 0x008fc6000001ff00ULL,
0x00b800001e297faeULL, 0x0007e2000b901c48ULL, 0x0000000000187805ULL, 0x010fe2000001ff00ULL,
0x000085802b1b8811ULL, 0x000fe400078e20ffULL, 0x00d8000020297faeULL, 0x0009e2000b901c48ULL,
0x000081802d2b8811ULL, 0x000fe200078e20ffULL, 0x00000000001c7805ULL, 0x004fe4000001ff00ULL,
0x00f8000022297faeULL, 0x0005e2000b901c48ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x008fc4000001ff00ULL, 0x00000000241b8faeULL, 0x0007e8000b901c48ULL,
0x00000000262b8faeULL, 0x0003e2000b901c48ULL, 0x0000000000207805ULL, 0x010fc6000001ff00ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000227805ULL, 0x004fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x008fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x002fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x000012f000001947ULL, 0x000fea0003800000ULL,
0x000000ffff117224ULL, 0x000fe400078e00ffULL, 0x000000ffff537224ULL, 0x000fca00078e0008ULL,
0x0000000153557810ULL, 0x000fc80007ffe0ffULL, 0x0000030055007a0cULL, 0x000fda0003f06070ULL,
0x0000034000000947ULL, 0x000fea0003800000ULL, 0x000000070200780cULL, 0x000fe20003f44070ULL,
0x000000010a677824ULL, 0x000fe200078e0255ULL, 0x0000000155567812ULL, 0x040fe200078ec0ffULL,
0x0000100055557824ULL, 0x000fe200078e00ffULL, 0x0000002002597810ULL, 0x040fe20007ffe0ffULL,
0x0000200067127825ULL, 0x000fe200078e0006ULL, 0x00000040025b7810ULL, 0x040fe40007ffe0ffULL,
0x00000060025d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000012127210ULL, 0x000fc40007f1e0ffULL,
0x00000080025f7810ULL, 0x000fe20007ffe0ffULL, 0x000000020869a824ULL, 0x140fe200078e020bULL,
0x00000013ff137210ULL, 0x000fe200007fe4ffULL, 0x000000020857a824ULL, 0x000fe200078e020bULL,
0x000000a002617810ULL, 0x040fe20007ffe0ffULL, 0x000000026969a824ULL, 0x100fe200078e0256ULL,
0x000000c002637810ULL, 0x040fe20007ffe0ffULL, 0x00000002576ba824ULL, 0x000fe200078e0256ULL,
0x0000100055567812ULL, 0x000fe200078ec0ffULL, 0x0000001059587825ULL, 0x000fe200078e0012ULL,
0x000000e002657810ULL, 0x000fc40007ffe0ffULL, 0x0000000d6764a211ULL, 0x000fe200078038ffULL,
0x0000000105557824ULL, 0x000fe200078e0256ULL, 0x0000000e6766a211ULL, 0x000fe200078238ffULL,
0x0000001002567825ULL, 0x000fc800078e0012ULL, 0x0000001002557824ULL, 0x000fe400078e0255ULL,
0x000000105b5a7825ULL, 0x000fc600078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000056557faeULL, 0x0003e2000b901c48ULL, 0x000000105d5c7825ULL, 0x000fc600078e0012ULL,
0x0038000058557faeULL, 0x0005e2000b901c48ULL, 0x000000105f5e7825ULL, 0x000fc600078e0012ULL,
0x005800005a557faeULL, 0x0007e2000b901c48ULL, 0x0000001061607825ULL, 0x000fc600078e0012ULL,
0x007800005c557faeULL, 0x0007e2000b901c48ULL, 0x0000001063627825ULL, 0x000fc600078e0012ULL,
0x009800005e557faeULL, 0x0007e2000b901c48ULL, 0x0000001065127825ULL, 0x000fe200078e0012ULL,
0x0000000f6765a211ULL, 0x040fe400000f3cffULL, 0x000000106767a211ULL, 0x000fe200008f3cffULL,
0x000000086969a824ULL, 0x100fe200078e0202ULL, 0x00b8000060557faeULL, 0x0007e2000b901c48ULL,
0x000000086b6ba824ULL, 0x000fe400078e0202ULL, 0x000000100264a825ULL, 0x040fe200078e0064ULL,
0x000085806969a811ULL, 0x000fe200078e20ffULL, 0x00d8000062557faeULL, 0x0007e2000b901c48ULL,
0x000081806b59a811ULL, 0x004fe200078e20ffULL, 0x000000100256a825ULL, 0x002fc400078e0066ULL,
0x00f8000012557faeULL, 0x0007e8000b901c48ULL, 0x000000006469afaeULL, 0x0007e8000b901c48ULL,
0x000000005659afaeULL, 0x0007e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000008053127824ULL, 0x008fe200078e00ffULL, 0x00000001ff567819ULL, 0x100fe20000011602ULL,
0x0000000208557824ULL, 0x000fe200078e020bULL, 0x00000002ff6a7819ULL, 0x000fe20000011602ULL,
0x0000001002137824ULL, 0x000fe200078e00ffULL, 0x0000008012127812ULL, 0x000fc400078ec0ffULL,
0x000000036a587819ULL, 0x040fe200000006ffULL, 0x000000086a617824ULL, 0x000fe200078e00ffULL,
0x0000007013137812ULL, 0x000fe200078ec0ffULL, 0x0000010055557824ULL, 0x000fe200078e0012ULL,
0x0000000c56127812ULL, 0x000fe200078ec0ffULL, 0x000000086a677824ULL, 0x040fe200078e00ffULL,
0x000000026a567810ULL, 0x040fe20007ffe0ffULL, 0x000000086a697824ULL, 0x000fe200078e00ffULL,
0x0000005512577210ULL, 0x000fe20007ffe013ULL, 0x000000086a607824ULL, 0x040fe200078e00ffULL,
0x000000016a557810ULL, 0x040fe20007ffe0ffULL, 0x000000086a6f7824ULL, 0x000fe200078e00ffULL,
0xfffffff861617812ULL, 0x000fc400078ee256ULL, 0xfffffff8585f7812ULL, 0x000fe200078ee255ULL,
0x0000100053557824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0081800057597984ULL, 0x000e620000000800ULL, 0x000000036a567810ULL, 0x000fe20007ffe0ffULL,
0x0000000402587824ULL, 0x000fe200078e00ffULL, 0x000000086a6c7810ULL, 0x040fe20007ffe0ffULL,
0x00858000575c7984ULL, 0x0004e20000000800ULL, 0xfffffff867677812ULL, 0x000fe400078ee256ULL,
0x0000100055567812ULL, 0x000fe200078ec0ffULL, 0x000000086a557824ULL, 0x000fe200078e00ffULL,
0x0000000c58627812ULL, 0x000fe400078ec0ffULL, 0x0000018005567810ULL, 0x000fe20007ffe056ULL,
0x000000086c577824ULL, 0x004fe200078e00ffULL, 0xfffffff855557812ULL, 0x000fc400078ee26aULL,
0x000000186a6e7810ULL, 0x040fe40007ffe0ffULL, 0xfffffff857577812ULL, 0x000fe200078ee26cULL,
0x0000001055557824ULL, 0x000fe200078e0256ULL, 0x000000046a5a7810ULL, 0x000fe20007ffe0ffULL,
0x000000086e637824ULL, 0x000fe200078e00ffULL, 0x000000106a667810ULL, 0x000fe20007ffe0ffULL,
0x0000000162557824ULL, 0x000fe200078e0255ULL, 0xfffffff869697812ULL, 0x000fe200078ee25aULL,
0x0000001057577824ULL, 0x000fe200078e0256ULL, 0x000000056a5d7810ULL, 0x000fc40007ffe0ffULL,
0x000000066a5e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000055557984ULL, 0x000ea20000000800ULL,
0x0000000162587824ULL, 0x000fe200078e0257ULL, 0xfffffff863577812ULL, 0x000fe400078ee26eULL,
0xfffffff8606d7812ULL, 0x000fe400078ee25dULL, 0x0000000058637984ULL, 0x0008a20000000800ULL,
0x0000001057577824ULL, 0x000fe200078e0256ULL, 0xfffffff86f6f7812ULL, 0x000fe400078ee25eULL,
0xffffffff6a5e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001625d7824ULL, 0x000fe200078e0257ULL,
0x0000000253537810ULL, 0x000fe20007ffe0ffULL, 0x000000590c597221ULL, 0x002fc40000010100ULL,
0x000000105f577824ULL, 0x100fe200078e0256ULL, 0x000000005d657984ULL, 0x000fe20000000800ULL,
0x3fb8aa3b595a7820ULL, 0x000fe20000410000ULL, 0x0000000366597819ULL, 0x000fe200000006ffULL,
0x0000001061587824ULL, 0x010fe200078e0256ULL, 0x0000030053007a0cULL, 0x000fe20003f06070ULL,
0x0000005a005b7308ULL, 0x0002e20000000800ULL, 0xfffffff859597812ULL, 0x000fe200078ee266ULL,
0x0000000162577824ULL, 0x000fe400078e0257ULL, 0x000000086a617824ULL, 0x000fc400078e00ffULL,
0x0000001059597824ULL, 0x100fe400078e0256ULL, 0x000000106f5f7824ULL, 0x000fe200078e0256ULL,
0xfffffff861617812ULL, 0x000fe200078ee25eULL, 0x000000106d5e7824ULL, 0x000fe200078e0256ULL,
0x00000059625a7210ULL, 0x042fe20007ffe0ffULL, 0x0000000162597824ULL, 0x040fe400078e0258ULL,
0x0000000057587984ULL, 0x000fe20000000800ULL, 0x0000001061617824ULL, 0x100fe400078e0256ULL,
0x0000005c5b6b7220ULL, 0x008fe20000410000ULL, 0x000000005a647984ULL, 0x000fe20000000800ULL,
0x00000010675b7824ULL, 0x100fe200078e0256ULL, 0x20000055ff677230ULL, 0x004fe20000004100ULL,
0x00000010695c7824ULL, 0x000fe200078e0256ULL, 0x00001f6c6b6c7589ULL, 0x000e6200000e0000ULL,
0x0000000162607824ULL, 0x040fe200078e025fULL, 0x0000005b625b7210ULL, 0x040fe20007ffe0ffULL,
0x00000001625c7824ULL, 0x040fe200078e025cULL, 0x00000000595a7984ULL, 0x000fe20000000800ULL,
0x00000001625e7824ULL, 0x040fe200078e025eULL, 0x20000063ff697230ULL, 0x000fe20000004100ULL,
0x0000000162617824ULL, 0x000fe200078e0261ULL, 0x000000005b567984ULL, 0x000fe20000000800ULL,
0x30000055ff627230ULL, 0x000fe20000004100ULL, 0x000000546b547221ULL, 0x000fc40000010000ULL,
0x000000005c5d7984ULL, 0x000fe80000000800ULL, 0x00001f6a6b6a7589ULL, 0x000ea800000e0000ULL,
0x00001f6e6b6e7589ULL, 0x000ee800000e0000ULL, 0x0000000060557984ULL, 0x000fe20000000800ULL,
0x0000006c694e7223ULL, 0x002fe2000001004eULL, 0x20000065ff697230ULL, 0x000fc40000004100ULL,
0x00001f666b6d7589ULL, 0x00032800000e0000ULL, 0x000000005e5f7984ULL, 0x000f220000000800ULL,
0x20000064ff667230ULL, 0x002fe20000004100ULL, 0x0000006a67507223ULL, 0x084fe20000010050ULL,
0x30000063ff677230ULL, 0x000fe20000004100ULL, 0x0000006a624f7223ULL, 0x000fe2000001004fULL,
0x0004000057637984ULL, 0x000e620000000800ULL, 0x0000006e69307223ULL, 0x008fe20000010030ULL,
0x30000065ff697230ULL, 0x000fe20000004100ULL, 0x0000006c67327223ULL, 0x000fe20000010032ULL,
0x0000000061627984ULL, 0x000ea20000000800ULL, 0x20000058ff657230ULL, 0x000fc40000004100ULL,
0x30000064ff647230ULL, 0x000fe20000004100ULL, 0x0000006e69467223ULL, 0x000fe20000010046ULL,
0x30000058ff677230ULL, 0x000fe20000004100ULL, 0x0000006a652e7223ULL, 0x080fe2000001002eULL,
0x000400005b587984ULL, 0x000ee20000000800ULL, 0x0000006d664d7223ULL, 0x090fe2000001004dULL,
0x2000005aff667230ULL, 0x100fe20000004100ULL, 0x0000006d64317223ULL, 0x000fe20000010031ULL,
0x000400005c657984ULL, 0x000f220000000800ULL, 0x0000006a674c7223ULL, 0x080fe2000001004cULL,
0x3000005aff677230ULL, 0x000fe20000004100ULL, 0x0000006a664b7223ULL, 0x000fe2000001004bULL,
0x0004000059647984ULL, 0x000f220000000800ULL, 0x20000056ff5a7230ULL, 0x000fc40000004100ULL,
0x30000056ff697230ULL, 0x000fe20000004100ULL, 0x000400005e667984ULL, 0x000f220000000800ULL,
0x2000005dff567230ULL, 0x000fe20000004100ULL, 0x0000006a67367223ULL, 0x080fe20000010036ULL,
0x30000055ff677230ULL, 0x100fe20000004100ULL, 0x0000006a5a477223ULL, 0x080fe20000010047ULL,
0x20000055ff5a7230ULL, 0x000fe20000004100ULL, 0x0000006a56437223ULL, 0x080fe20000010043ULL,
0x0004000061557984ULL, 0x000f220000000800ULL, 0x3000005dff5d7230ULL, 0x000fe20000004100ULL,
0x0000006a67387223ULL, 0x000fc40000010038ULL, 0x0004000060567984ULL, 0x000f220000000800ULL,
0x0000006a5a3b7223ULL, 0x080fe4000001003bULL, 0x0000006a5d407223ULL, 0x080fe20000010040ULL,
0x00080000575a7984ULL, 0x000f220000000800ULL, 0x2000005fff5d7230ULL, 0x000fe20000004100ULL,
0x0000006a69447223ULL, 0x080fe20000010044ULL, 0x30000063ff687230ULL, 0x002fe40000004100ULL,
0x3000005fff5f7230ULL, 0x000fe20000004100ULL, 0x0000006a5d207223ULL, 0x000fe20000010020ULL,
0x20000062ff5d7230ULL, 0x104fe20000004100ULL, 0x0000006c68497223ULL, 0x000fe20000010049ULL,
0x30000062ff627230ULL, 0x000fe20000004100ULL, 0x0000006a5f3c7223ULL, 0x080fe2000001003cULL,
0x20000063ff677230ULL, 0x000fe20000004100ULL, 0x0000006a5d4a7223ULL, 0x080fe2000001004aULL,
0x20000058ff687230ULL, 0x108fe20000004100ULL, 0x00080000595d7984ULL, 0x000fe20000000800ULL,
0x30000058ff637230ULL, 0x000fe20000004100ULL, 0x0000006a62357223ULL, 0x000fe20000010035ULL,
0x20000065ff587230ULL, 0x110fe20000004100ULL, 0x000c0000575f7984ULL, 0x000e620000000800ULL,
0x0000006c67347223ULL, 0x080fe20000010034ULL, 0x30000065ff657230ULL, 0x000fe20000004100ULL,
0x0000006c68457223ULL, 0x080fe20000010045ULL, 0x20000064ff627230ULL, 0x100fe20000004100ULL,
0x000800005b577984ULL, 0x000ea20000000800ULL, 0x30000064ff647230ULL, 0x000fe20000004100ULL,
0x0000006c583f7223ULL, 0x080fe2000001003fULL, 0x30000066ff677230ULL, 0x000fe20000004100ULL,
0x000800005c587984ULL, 0x000ee20000000800ULL, 0x0000006c621b7223ULL, 0x000fc4000001001bULL,
0x0000006c642f7223ULL, 0x080fe2000001002fULL, 0x20000066ff647230ULL, 0x000fe20000004100ULL,
0x000c000059627984ULL, 0x0008e20000000800ULL, 0x0000006c63267223ULL, 0x080fe20000010026ULL,
0x30000055ff6a7230ULL, 0x100fe20000004100ULL, 0x0000006c65247223ULL, 0x080fe20000010024ULL,
0x20000056ff667230ULL, 0x100fe20000004100ULL, 0x0000006c643d7223ULL, 0x080fe2000001003dULL,
0x30000056ff687230ULL, 0x000fe20000004100ULL, 0x000c00005c647984ULL, 0x0008e40000000800ULL,
0x20000055ff597230ULL, 0x010fe20000004100ULL, 0x0000006c66257223ULL, 0x080fe20000010025ULL,
0x000800005e567984ULL, 0x000f220000000800ULL, 0x0000006c673a7223ULL, 0x000fc4000001003aULL,
0x0000006c591c7223ULL, 0x080fe2000001001cULL, 0x2000005aff597230ULL, 0x100fe20000004100ULL,
0x000c00005b637984ULL, 0x000f220000000800ULL, 0x3000005aff5c7230ULL, 0x000fe20000004100ULL,
0x0000006c68377223ULL, 0x080fe40000010037ULL, 0x000c0000605a7984ULL, 0x000f220000000800ULL,
0x0000006d59187223ULL, 0x080fe40000010018ULL, 0x0000006d5c2d7223ULL, 0x000fe2000001002dULL,
0x000c00005e5b7984ULL, 0x0005220000000800ULL, 0x0000006c6a337223ULL, 0x000fe20000010033ULL,
0x2000005fff657230ULL, 0x002fc40000004100ULL, 0x0008000060557984ULL, 0x0003220000000800ULL,
0x3000005fff667230ULL, 0x000fe40000004100ULL, 0x2000005dff5f7230ULL, 0x100fe20000004100ULL,
0x0008000061597984ULL, 0x000f220000000800ULL, 0x3000005dff5e7230ULL, 0x004fe20000004100ULL,
0x0000006e652c7223ULL, 0x080fe2000001002cULL, 0x20000057ff5d7230ULL, 0x100fe20000004100ULL,
0x000c0000615c7984ULL, 0x000ea20000000800ULL, 0x0000006e662b7223ULL, 0x080fe4000001002bULL,
0x0000006d5e417223ULL, 0x080fe20000010041ULL, 0x30000057ff5e7230ULL, 0x000fe20000004100ULL,
0x0000006d5d3e7223ULL, 0x080fe2000001003eULL, 0x20000058ff577230ULL, 0x008fe20000004100ULL,
0x0000006d5f2a7223ULL, 0x080fe2000001002aULL, 0x20000062ff657230ULL, 0x000fe20000004100ULL,
0x0000006d5e297223ULL, 0x080fe20000010029ULL, 0x30000058ff587230ULL, 0x000fe20000004100ULL,
0x0000006d57227223ULL, 0x080fe20000010022ULL, 0x20000064ff5d7230ULL, 0x000fe20000004100ULL,
0x0000006e65287223ULL, 0x080fe20000010028ULL, 0x30000062ff627230ULL, 0x000fe20000004100ULL,
0x0000006d581f7223ULL, 0x080fe2000001001fULL, 0x20000056ff577230ULL, 0x110fe20000004100ULL,
0x0000006e5d427223ULL, 0x080fe20000010042ULL, 0x30000056ff567230ULL, 0x000fe20000004100ULL,
0x0000006e62277223ULL, 0x080fe20000010027ULL, 0x20000063ff607230ULL, 0x102fe20000004100ULL,
0x0000006d571e7223ULL, 0x080fe2000001001eULL, 0x30000063ff627230ULL, 0x000fe20000004100ULL,
0x0000006d561d7223ULL, 0x080fe2000001001dULL, 0x2000005aff567230ULL, 0x000fe20000004100ULL,
0x0000006e60217223ULL, 0x080fe20000010021ULL, 0x30000064ff647230ULL, 0x000fe20000004100ULL,
0x0000006e62237223ULL, 0x080fe20000010023ULL, 0x2000005bff5d7230ULL, 0x100fe20000004100ULL,
0x0000006e56197223ULL, 0x080fe20000010019ULL, 0x3000005bff5b7230ULL, 0x000fe20000004100ULL,
0x0000006e64397223ULL, 0x080fe20000010039ULL, 0x20000055ff577230ULL, 0x100fe20000004100ULL,
0x0000006e5d487223ULL, 0x080fe20000010048ULL, 0x30000055ff557230ULL, 0x000fe20000004100ULL,
0x0000006e5b527223ULL, 0x080fe20000010052ULL, 0x20000059ff567230ULL, 0x100fe20000004100ULL,
0x0000006d57147223ULL, 0x080fe20000010014ULL, 0x3000005aff5a7230ULL, 0x000fe20000004100ULL,
0x0000006d551a7223ULL, 0x080fe2000001001aULL, 0x2000005cff587230ULL, 0x104fe20000004100ULL,
0x0000006d56177223ULL, 0x000fe20000010017ULL, 0x30000059ff597230ULL, 0x000fe20000004100ULL,
0x0000006e5a517223ULL, 0x080fe20000010051ULL, 0x3000005cff5c7230ULL, 0x000fe20000004100ULL,
0x0000006e58157223ULL, 0x000fc40000010015ULL, 0x0000006d59167223ULL, 0x000fe40000010016ULL,
0x0000006e5c117223ULL, 0x000fe20000010011ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffed3000007947ULL, 0x000fea000383ffffULL, 0x000000ff0b00720cULL, 0x000fe20003f05270ULL,
0x0000018000007945ULL, 0x000fd80003800000ULL, 0x0000008008058824ULL, 0x000fca00078e0213ULL,
0x0000000512058210ULL, 0x000fe20007ffe0ffULL, 0x0000000113127824ULL, 0x000fc800078e0212ULL,
0x0089805405008388ULL, 0x000fe80000000800ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0089800012007984ULL, 0x000e680000000800ULL, 0x008a000012077984ULL, 0x000ea20000000800ULL,
0x00000000ff007221ULL, 0x002fc80000010000ULL, 0x0000000700007221ULL, 0x004fca0000010000ULL,
0x0180000000027810ULL, 0x000fc80007ffe0ffULL, 0x7f80000002027812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0200780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x000fe200078e0000ULL,
0x0000d7c0000a7802ULL, 0x000fc40000000f00ULL, 0x0000d4a000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x008fe200078e0002ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000000057308ULL, 0x000e640000001000ULL, 0xbf80000000027423ULL, 0x002fc80000000005ULL,
0x800000ff02027221ULL, 0x000fc80000010100ULL, 0x0000000205057223ULL, 0x000fc40000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e680000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000802567811ULL, 0x002fc400078ff0ffULL,
0x00000018025a7811ULL, 0x040fe400078ff0ffULL, 0x0000001002587811ULL, 0x000fe200078ff0ffULL,
0x00001f5605007589ULL, 0x000e6200000e0000ULL, 0x00000002ff547819ULL, 0x000fe20000011602ULL,
0x0000000856597824ULL, 0x000fe400078e00ffULL, 0x00001f5a050e7589ULL, 0x000ea200000e0000ULL,
0x00000008585b7824ULL, 0x000fe200078e00ffULL, 0x0000000354557819ULL, 0x040fe200000006ffULL,
0x0000000854537824ULL, 0x040fe200078e00ffULL, 0x00001f58050c7589ULL, 0x000ee200000e0000ULL,
0x0000000854577824ULL, 0x000fe200078e00ffULL, 0xfffffff859597812ULL, 0x000fe200078ee256ULL,
0x000000085a5d7824ULL, 0x000fe200078e00ffULL, 0x00001f5405077589ULL, 0x0008a200000e0000ULL,
0xfffffff85b5b7812ULL, 0x000fc400078ee258ULL, 0x0000001059597824ULL, 0x000fe200078e0204ULL,
0xfffffff85d5d7812ULL, 0x000fe400078ee25aULL, 0x000000105b5b7824ULL, 0x000fc600078e0204ULL,
0x000000105d5d7824ULL, 0x000fe400078e0204ULL, 0x00000037000a7220ULL, 0x042fe40000410000ULL,
0x0000003200137220ULL, 0x000fe20000410000ULL, 0x0000000354327810ULL, 0x040fe20007ffe0ffULL,
0x0000000854377824ULL, 0x000fe400078e00ffULL, 0x0000004e004e7220ULL, 0x040fe40000410000ULL,
0x0000003400347220ULL, 0x040fe20000410000ULL, 0xfffffff837377812ULL, 0x000fe200078ee232ULL,
0x0000004900497220ULL, 0x040fe20000410000ULL, 0x0000004e1313723eULL, 0x000fe200000000ffULL,
0x0000001b001b7220ULL, 0x000fc40000410000ULL, 0x0000002f00067220ULL, 0x040fe20000410000ULL,
0x000000344934723eULL, 0x000fe200000000ffULL, 0x0000004500457220ULL, 0x040fe40000410000ULL,
0x0000002600267220ULL, 0x000fe20000410000ULL, 0x0000001b0606723eULL, 0x000fe200000000ffULL,
0x0000003f003f7220ULL, 0x040fe40000410000ULL, 0x0000002400247220ULL, 0x000fe20000410000ULL,
0x000000452626723eULL, 0x000fe200000000ffULL, 0x0000003d003d7220ULL, 0x000fc40000410000ULL,
0x0000003a003a7220ULL, 0x000fe20000410000ULL, 0x0000003f2424723eULL, 0x000fe200000000ffULL,
0x0000002500257220ULL, 0x040fe40000410000ULL, 0x0000001c001c7220ULL, 0x000fe20000410000ULL,
0x0000003d3a3a723eULL, 0x000fe200000000ffULL, 0x0000003300337220ULL, 0x000fe20000410000ULL,
0x000000250a0a723eULL, 0x000fe200000000ffULL, 0x000000230e107220ULL, 0x004fe40000410000ULL,
0x0000004d0c4d7220ULL, 0x048fe20000410000ULL, 0x0000001c331c723eULL, 0x000fe200000000ffULL,
0x000000310c007220ULL, 0x000fc40000410000ULL, 0x000000180c187220ULL, 0x040fe40000410000ULL,
0x0000002d0c2d7220ULL, 0x000fe20000410000ULL, 0x0000004d0000723eULL, 0x000fe200000000ffULL,
0x0000002a0c2a7220ULL, 0x040fe40000410000ULL, 0x000000410c417220ULL, 0x040fe20000410000ULL,
0x000000182d18723eULL, 0x000fe200000000ffULL, 0x0000003e0c3e7220ULL, 0x040fe40000410000ULL,
0x000000290c297220ULL, 0x040fe20000410000ULL, 0x0000002a412a723eULL, 0x000fe200000000ffULL,
0x000000220c227220ULL, 0x000fc40000410000ULL, 0x0000001f0c1f7220ULL, 0x040fe20000410000ULL,
0x0000003e2929723eULL, 0x000fe200000000ffULL, 0x0000001e0c1e7220ULL, 0x040fe40000410000ULL,
0x0000001d0c1d7220ULL, 0x040fe20000410000ULL, 0x000000221f1f723eULL, 0x000fe200000000ffULL,
0x000000140c147220ULL, 0x040fe40000410000ULL, 0x0000001a0c057220ULL, 0x010fe20000410000ULL,
0x00000002541a7810ULL, 0x000fe20007ffe0ffULL, 0x000000170c177220ULL, 0x000fe20000410000ULL,
0x0000001e1d1d723eULL, 0x000fe200000000ffULL, 0x000000300e307220ULL, 0x040fe20000410000ULL,
0x000000140505723eULL, 0x000fe200000000ffULL, 0x000000460e2f7220ULL, 0x000fc40000410000ULL,
0x0000002c0e2c7220ULL, 0x040fe40000410000ULL, 0x0000002b0e2b7220ULL, 0x040fe20000410000ULL,
0x000000302f2f723eULL, 0x000fe200000000ffULL, 0x000000280e287220ULL, 0x040fe40000410000ULL,
0x000000270e277220ULL, 0x040fe20000410000ULL, 0x0000002c2b2b723eULL, 0x000fe200000000ffULL,
0x000000210e217220ULL, 0x040fe40000410000ULL, 0x000000420e427220ULL, 0x040fe20000410000ULL,
0x000000282727723eULL, 0x000fe200000000ffULL, 0x000000390e397220ULL, 0x000fe20000410000ULL,
0x000000211010723eULL, 0x000fe200000000ffULL, 0x000000480e487220ULL, 0x000fc40000410000ULL,
0x000000520e237220ULL, 0x040fe20000410000ULL, 0x000000423939723eULL, 0x000fe200000000ffULL,
0x000000190e197220ULL, 0x040fe40000410000ULL, 0x000000510e127220ULL, 0x040fe20000410000ULL,
0x000000482323723eULL, 0x000fe200000000ffULL, 0x000000150e157220ULL, 0x000fe40000410000ULL,
0x000000160c0c7220ULL, 0x000fe20000410000ULL, 0x0000000154167810ULL, 0x040fe20007ffe0ffULL,
0x0000000854317824ULL, 0x000fe200078e00ffULL, 0x000000191212723eULL, 0x000fe200000000ffULL,
0x000000110e0e7220ULL, 0x000fe20000410000ULL, 0x0000000454117810ULL, 0x040fe20007ffe0ffULL,
0x0000000854327824ULL, 0x040fe200078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee216ULL,
0x0000005007507220ULL, 0x040fe20000410000ULL, 0x0000000554167810ULL, 0x000fe20007ffe0ffULL,
0x0000004f074f7220ULL, 0x040fe20000410000ULL, 0xfffffff832517812ULL, 0x000fe200078ee211ULL,
0x0000002e072e7220ULL, 0x000fe20000410000ULL, 0xfffffff853537812ULL, 0x000fe200078ee216ULL,
0x0000004c070d7220ULL, 0x040fe20000410000ULL, 0xffffffff54167810ULL, 0x000fe20007ffe0ffULL,
0x0000004b074b7220ULL, 0x000fe20000410000ULL, 0x000000504f4f723eULL, 0x000fe200000000ffULL,
0x0000003607367220ULL, 0x000fe20000410000ULL, 0xfffffff857577812ULL, 0x000fe200078ee216ULL,
0x0000004707477220ULL, 0x000fe20000410000ULL, 0x0000002e0d0d723eULL, 0x000fe200000000ffULL,
0x0000004407447220ULL, 0x040fe20000410000ULL, 0x0000004b3636723eULL, 0x000fe200000000ffULL,
0x0000004307437220ULL, 0x040fe20000410000ULL, 0x000000170c0c723eULL, 0x000fe200000000ffULL,
0x0000004007407220ULL, 0x040fe20000410000ULL, 0x000000474444723eULL, 0x000fe200000000ffULL,
0x0000002007207220ULL, 0x040fe20000410000ULL, 0x000000150e0e723eULL, 0x000fe200000000ffULL,
0x0000003c070f7220ULL, 0x040fe20000410000ULL, 0x000000434040723eULL, 0x000fe200000000ffULL,
0x0000003b073b7220ULL, 0x000fc40000410000ULL, 0x0000003807387220ULL, 0x000fe20000410000ULL,
0x000000200f0f723eULL, 0x000fe200000000ffULL, 0x0000004a074a7220ULL, 0x040fe40000410000ULL,
0x0000003507077220ULL, 0x000fe20000410000ULL, 0x0000003b3838723eULL, 0x000fe200000000ffULL,
0x0000000854357824ULL, 0x040fe400078e00ffULL, 0x0000000854117824ULL, 0x000fe200078e00ffULL,
0x0000004a0707723eULL, 0x000fe200000000ffULL, 0x0000000402147824ULL, 0x000fe200078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee21aULL, 0x0000001031317824ULL, 0x100fe200078e0204ULL,
0x00000006541a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001037377824ULL, 0x000fe200078e0204ULL,
0xfffffff811117812ULL, 0x000fe200078ee254ULL, 0x0000001051517824ULL, 0x000fe200078e0204ULL,
0xfffffff855557812ULL, 0x000fe200078ee21aULL, 0x0000001053537824ULL, 0x100fe200078e0204ULL,
0x0000000c14147812ULL, 0x000fe200078ec0ffULL, 0x0000001011117824ULL, 0x100fe200078e0204ULL,
0x0000000435357211ULL, 0x000fe200078e20ffULL, 0x0000001055557824ULL, 0x100fe200078e0204ULL,
0x0000005b145b7210ULL, 0x040fe20007ffe0ffULL, 0x0000001057577824ULL, 0x000fe200078e0204ULL,
0x0000001411047210ULL, 0x000fe20007ffe0ffULL, 0x0000000114317824ULL, 0x000fc400078e0231ULL,
0x0000000114357824ULL, 0x040fe400078e0235ULL, 0x0000000114377824ULL, 0x040fe200078e0237ULL,
0x0000004f04007388ULL, 0x000fe20000000800ULL, 0x0000000114517824ULL, 0x040fe400078e0251ULL,
0x0000000114207824ULL, 0x040fe200078e0253ULL, 0x0000000d31007388ULL, 0x000fe20000000800ULL,
0x0000000114557824ULL, 0x040fe400078e0255ULL, 0x0000000114577824ULL, 0x040fe200078e0257ULL,
0x0000003635007388ULL, 0x000fe20000000800ULL, 0x0000000114167824ULL, 0x000fc400078e0259ULL,
0x0000000114147824ULL, 0x000fe200078e025dULL, 0x0000004437007388ULL, 0x000fe80000000800ULL,
0x0000004051007388ULL, 0x000fe80000000800ULL, 0x0000000f20007388ULL, 0x000fe80000000800ULL,
0x0000003855007388ULL, 0x000fe80000000800ULL, 0x0000000757007388ULL, 0x000fe80000000800ULL,
0x0000001316007388ULL, 0x000fe80000000800ULL, 0x0004003431007388ULL, 0x000fe80000000800ULL,
0x0004000635007388ULL, 0x000fe80000000800ULL, 0x0004002637007388ULL, 0x000fe80000000800ULL,
0x0004002451007388ULL, 0x000fe80000000800ULL, 0x0004003a20007388ULL, 0x000fe80000000800ULL,
0x0004000a55007388ULL, 0x000fe80000000800ULL, 0x0004001c57007388ULL, 0x000fe80000000800ULL,
0x000000005b007388ULL, 0x0003e80000000800ULL, 0x0008001831007388ULL, 0x000fe80000000800ULL,
0x0008002a35007388ULL, 0x000fe20000000800ULL, 0x0000000109007824ULL, 0x002fc600078e0202ULL,
0x0008002937007388ULL, 0x000fe20000000800ULL, 0x0000001000007824ULL, 0x000fc600078e0203ULL,
0x0008001f51007388ULL, 0x000fe80000000800ULL, 0x0008001d20007388ULL, 0x000fe80000000800ULL,
0x0008000555007388ULL, 0x000fe80000000800ULL, 0x0008000c57007388ULL, 0x000fe80000000800ULL,
0x0000002f14007388ULL, 0x000fe80000000800ULL, 0x000c002b31007388ULL, 0x000fe80000000800ULL,
0x000c002735007388ULL, 0x000fe80000000800ULL, 0x000c001037007388ULL, 0x000fe80000000800ULL,
0x000c003951007388ULL, 0x000fe80000000800ULL, 0x000c002320007388ULL, 0x000fe80000000800ULL,
0x000c001255007388ULL, 0x000fe80000000800ULL, 0x000c000e57007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000000047984ULL, 0x000e680000000c00ULL,
0x0004000000187984ULL, 0x000ea80000000c00ULL, 0x0008000000247984ULL, 0x000ee80000000c00ULL,
0x000c000000207984ULL, 0x000f280000000c00ULL, 0x0010000000147984ULL, 0x000ee80000000c00ULL,
0x00140000001c7984ULL, 0x000f280000000c00ULL, 0x0018000000287984ULL, 0x000f280000000c00ULL,
0x001c0000002c7984ULL, 0x000f220000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff1b1b7230ULL, 0x004fe40000000000ULL,
0x200000ff1a1a7230ULL, 0x000fe40000000000ULL, 0x200000ff19197230ULL, 0x000fc40000000000ULL,
0x200000ff18187230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x008fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fe40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x200000ff23237230ULL, 0x010fc40000000000ULL,
0x200000ff22227230ULL, 0x000fe40000000000ULL, 0x200000ff21217230ULL, 0x000fe40000000000ULL,
0x200000ff20207230ULL, 0x000fe40000000000ULL, 0x0000001707077230ULL, 0x000fe40000000000ULL,
0x0000001606067230ULL, 0x000fe40000000000ULL, 0x0000001505057230ULL, 0x000fc40000000000ULL,
0x0000001404047230ULL, 0x000fe40000000000ULL, 0x0000001f1b1b7230ULL, 0x000fe40000000000ULL,
0x0000001e1a1a7230ULL, 0x000fe20000000000ULL, 0x0000000400007388ULL, 0x000fe20000000c00ULL,
0x0000001d19197230ULL, 0x000fe40000000000ULL, 0x0000001c18187230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x000fc40000000000ULL, 0x0000002a26267230ULL, 0x000fe20000000000ULL,
0x0004001800007388ULL, 0x000fe20000000c00ULL, 0x0000002925257230ULL, 0x000fe40000000000ULL,
0x0000002824247230ULL, 0x000fe40000000000ULL, 0x0000002f23237230ULL, 0x000fe40000000000ULL,
0x0000002e22227230ULL, 0x000fe20000000000ULL, 0x0008002400007388ULL, 0x000fe20000000c00ULL,
0x0000002d21217230ULL, 0x000fc40000000000ULL, 0x0000002c20207230ULL, 0x000fca0000000000ULL,
0x000c002000007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff0800720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff057819ULL, 0x000fc80000011602ULL, 0x0000007e0500720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000105007824ULL, 0x000fe200078e0202ULL,
0x00000000000479c3ULL, 0x000ee20000002700ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x0000002002107810ULL, 0x000fe20007ffe0ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000000700077812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x0000002080007824ULL, 0x000fe200078e0205ULL, 0x00000003ff097819ULL, 0x000fe20000011610ULL,
0x0000580000067ab9ULL, 0x000fe20000000800ULL, 0x0ffffff807047812ULL, 0x000fc400078ef802ULL,
0x0000000500067c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff057a19ULL, 0x000fe20000011600ULL,
0x0000001004047824ULL, 0x000fe200078e0203ULL, 0x0000000702087812ULL, 0x000fe200078ec0ffULL,
0x000000017f067824ULL, 0x000fc600078e0206ULL, 0x00000000040c7984ULL, 0x0045220000000c00ULL,
0x0000008205057224ULL, 0x000fe200078e0206ULL, 0x000000080b077211ULL, 0x000fe200078e18ffULL,
0x00000006040472a4ULL, 0x008fcc000f8e023fULL, 0x0000000482007c24ULL, 0x000fca000f8e02ffULL,
0x0000000500057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x004fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f4406ULL,
0x0000007e0900720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fca00078e0004ULL,
0x0000000c04007986ULL, 0x0105ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000110047824ULL, 0x104fe200078e0209ULL, 0x0000004002117810ULL, 0x000fe20007ffe0ffULL,
0x0000002080097824ULL, 0x000fe200078e0209ULL, 0x0000000710087812ULL, 0x000fe400078ec0ffULL,
0x0000000704047812ULL, 0x000fc600078ec0ffULL, 0x000000080b077824ULL, 0x000fe200078e0208ULL,
0x0ffffff804047812ULL, 0x000fca00078ef810ULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x0000000509047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff097a19ULL, 0x000fe40000011609ULL,
0x00000000060c7984ULL, 0x000ea20000000c00ULL, 0x000000017f047824ULL, 0x000fc800078e0204ULL,
0x0000008209097224ULL, 0x000fca00078e0204ULL, 0x0000000900097210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x00005c0009047a11ULL, 0x000fc800078040ffULL,
0x00005d0009057a11ULL, 0x000fe400000f440aULL, 0x00000003ff097819ULL, 0x000fc60000011611ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000007e0900720cULL, 0x000fc80003f06070ULL,
0x0000000c04007986ULL, 0x0045f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000111047824ULL, 0x004fe200078e0209ULL, 0x0000000980097211ULL, 0x000fc400078e28ffULL,
0x0000006002107810ULL, 0x000fe40007ffe0ffULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x0000000711087812ULL, 0x000fe400078ec0ffULL, 0x0ffffff804047812ULL, 0x000fc600078ef811ULL,
0x000000080b077824ULL, 0x000fe400078e0208ULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x0000000509047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff097a19ULL, 0x000fe40000011609ULL,
0x00000000060c7984ULL, 0x000ea20000000c00ULL, 0x000000017f047824ULL, 0x000fc800078e0204ULL,
0x0000008209097224ULL, 0x000fca00078e0204ULL, 0x0000000900097210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x00005c0009047a11ULL, 0x000fc800078040ffULL,
0x00005d0009057a11ULL, 0x000fe400000f440aULL, 0x00000003ff097819ULL, 0x000fc60000011610ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000007e0900720cULL, 0x000fc80003f06070ULL,
0x0000000c04007986ULL, 0x0045f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000110047824ULL, 0x104fe200078e0209ULL, 0x0000008002117810ULL, 0x000fe20007ffe0ffULL,
0x0000002080097824ULL, 0x000fe200078e0209ULL, 0x0000000710087812ULL, 0x000fc400078ec0ffULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x000000080b077211ULL, 0x000fe400078e18ffULL,
0x0ffffff804047812ULL, 0x000fca00078ef810ULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x0000000509047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff097a19ULL, 0x000fe40000011609ULL,
0x00000000060c7984ULL, 0x000ea20000000c00ULL, 0x000000017f047824ULL, 0x000fc800078e0204ULL,
0x0000008209097224ULL, 0x000fca00078e0204ULL, 0x0000000900097210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x00005c0009047a11ULL, 0x000fc800078040ffULL,
0x00005d0009057a11ULL, 0x000fe400000f440aULL, 0x00000003ff097819ULL, 0x000fc60000011611ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000007e0900720cULL, 0x000fc80003f06070ULL,
0x0000000c04007986ULL, 0x0045f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000111047824ULL, 0x144fe200078e0209ULL, 0x000000a002107810ULL, 0x000fe20007ffe0ffULL,
0x0000002080097824ULL, 0x000fe200078e0209ULL, 0x0000000711087812ULL, 0x000fc400078ec0ffULL,
0x0000000704047812ULL, 0x000fc600078ec0ffULL, 0x000000080b077824ULL, 0x000fe200078e0208ULL,
0x0ffffff804047812ULL, 0x000fca00078ef811ULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x0000000509047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff097a19ULL, 0x000fe40000011609ULL,
0x00000000060c7984ULL, 0x000ea20000000c00ULL, 0x000000017f047824ULL, 0x000fc800078e0204ULL,
0x0000008209097224ULL, 0x000fca00078e0204ULL, 0x0000000900097210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x00005c0009047a11ULL, 0x000fc800078040ffULL,
0x00005d0009057a11ULL, 0x000fe400000f440aULL, 0x00000003ff097819ULL, 0x000fc60000011610ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000007e0900720cULL, 0x000fc80003f06070ULL,
0x0000000c04007986ULL, 0x0045f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000110047824ULL, 0x004fe200078e0209ULL, 0x0000000980097211ULL, 0x000fc400078e28ffULL,
0x000000c002117810ULL, 0x000fe40007ffe0ffULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x0000000710087812ULL, 0x000fe400078ec0ffULL, 0x0ffffff804047812ULL, 0x000fc600078ef810ULL,
0x000000080b077824ULL, 0x000fe400078e0208ULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x0000000509047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff097a19ULL, 0x000fe40000011609ULL,
0x00000000060c7984ULL, 0x000ea20000000c00ULL, 0x000000017f047824ULL, 0x000fc800078e0204ULL,
0x0000008209097224ULL, 0x000fca00078e0204ULL, 0x0000000900097210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200000e06ffULL, 0x00005c0009047a11ULL, 0x000fc800078040ffULL,
0x00005d0009057a11ULL, 0x000fe400000f440aULL, 0x00000003ff097819ULL, 0x000fc60000011611ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000007e0900720cULL, 0x000fc80003f06070ULL,
0x0000000c04007986ULL, 0x0045f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000111047824ULL, 0x144fe200078e0209ULL, 0x000000e0020a7810ULL, 0x000fe20007ffe0ffULL,
0x0000002080097824ULL, 0x000fe200078e0209ULL, 0x0000000711027812ULL, 0x000fc400078ec0ffULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x000000020b077211ULL, 0x000fe400078e18ffULL,
0x0ffffff804047812ULL, 0x000fca00078ef811ULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x0000000509047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff097a19ULL, 0x000fe40000011609ULL,
0x00000000060c7984ULL, 0x000ea20000000c00ULL, 0x000000017f047824ULL, 0x000fc800078e0204ULL,
0x0000008209097224ULL, 0x000fca00078e0204ULL, 0x0000000900057210ULL, 0x000fe40007f1e0ffULL,
0x00000003ff097819ULL, 0x000fc6000001160aULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fe200078040ffULL, 0x000000010a027824ULL, 0x000fc600078e0209ULL,
0x00005d0005057a11ULL, 0x000fe400000f4408ULL, 0x0000007e0900720cULL, 0x000fe40003f06070ULL,
0x0000000702027812ULL, 0x000fe200078ec0ffULL, 0x0000001007047825ULL, 0x000fc600078e0004ULL,
0xfffffff802027812ULL, 0x000fe400078ef80aULL, 0x0000000c04007986ULL, 0x0045ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001002047824ULL, 0x004fe400078e0203ULL,
0x0000002080097824ULL, 0x000fc800078e0209ULL, 0x0000000004047984ULL, 0x000ea20000000c00ULL,
0x0000000509027c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff097a19ULL, 0x000fc60000011609ULL,
0x000000017f027824ULL, 0x000fc800078e0202ULL, 0x0000008209097224ULL, 0x000fca00078e0202ULL,
0x0000000900097210ULL, 0x000fe40007f1e0ffULL, 0x000000070a007812ULL, 0x000fc600078ec0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005c0009027a11ULL, 0x000fe200078040ffULL,
0x000000080b0b7824ULL, 0x000fc600078e0200ULL, 0x00005d0009037a11ULL, 0x000fca00000f4408ULL,
0x000000100b027825ULL, 0x000fca00078e0002ULL, 0x0000000402007986ULL, 0x004fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000004020a7824ULL, 0x000fca00078e0200ULL,
0x000000050a00720cULL, 0x000fda0003f06070ULL, 0x00000002a2098824ULL, 0x000fc800078e00ffULL,
0x0000680009128a24ULL, 0x000fe200078e020aULL, 0xffffffff00097802ULL, 0x000fc60000000f00ULL,
0x0000640012128625ULL, 0x000fe200078e002fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000812098981ULL, 0x000ea2000c1e1900ULL, 0x00000001020d7810ULL, 0x000fe20007ffe0ffULL,
0x00000040149f7824ULL, 0x000fe400078e00ffULL, 0x00000100ff117424ULL, 0x000fe200078e00ffULL,
0x000000060d00720cULL, 0x000fe20003f06070ULL, 0x01e60000ff0e7f8cULL, 0x000e62000c80043fULL,
0x0000004000a07824ULL, 0x000fe400078e00ffULL, 0x000000400b087824ULL, 0x000fc400078e00ffULL,
0x0000009f09107224ULL, 0x004fc800078e02ffULL, 0x0000620010107625ULL, 0x000fc600078e0011ULL,
0x00000c8000008947ULL, 0x000fea0003800000ULL, 0x00000100020d7824ULL, 0x002fe200078e02a0ULL,
0x00000003ff287819ULL, 0x000fe40000011603ULL, 0x0000200000247811ULL, 0x000fe400078e70ffULL,
0x0000000d04127217ULL, 0x000fe20007800000ULL, 0x000000400b0b7824ULL, 0x000fe200078e0228ULL,
0x0000000428147810ULL, 0x040fe40007ffe0ffULL, 0x0000000828167810ULL, 0x000fe20007ffe0ffULL,
0x00000001120d7824ULL, 0x000fe200078e0a0dULL, 0x0000002428207810ULL, 0x000fe20007ffe0ffULL,
0x0000000114127824ULL, 0x000fe200078e0203ULL, 0x0000002828227810ULL, 0x000fe20007ffe0ffULL,
0x00000008141f7824ULL, 0x040fe200078e00ffULL, 0x0000000d1400720cULL, 0x000fe20003f46070ULL,
0x0000000816217824ULL, 0x000fe200078e00ffULL, 0x0000000c28147810ULL, 0x000fe20007ffe0ffULL,
0x00000008222d7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fc400078ee212ULL,
0x0000000316127210ULL, 0x000fe20007ffe0ffULL, 0x0000000114137824ULL, 0x000fe200078e0203ULL,
0x0000000d1600720cULL, 0x080fe20003f66070ULL, 0x0000000814187824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee212ULL, 0x000000101f1f7824ULL, 0x100fe200078e0224ULL,
0x0000001028127810ULL, 0x040fe40007ffe0ffULL, 0x0000001428167810ULL, 0x000fe20007ffe0ffULL,
0x0000001021217824ULL, 0x000fe200078e0224ULL, 0xfffffff818257812ULL, 0x000fe200078ee213ULL,
0x0000000112157824ULL, 0x100fe200078e0203ULL, 0x0000000d1400720cULL, 0x080fe20003f86070ULL,
0x0000000812187824ULL, 0x040fe200078e00ffULL, 0x0000000d1200720cULL, 0x000fe20003fa6070ULL,
0x0000000128147824ULL, 0x100fe200078e0203ULL, 0x00000003161a7819ULL, 0x040fe200000006ffULL,
0x0000000116177824ULL, 0x000fe200078e0203ULL, 0xfffffff818277812ULL, 0x000fe200078ee215ULL,
0x000001000b127825ULL, 0x000fe200078e00ffULL, 0x0000000714187812ULL, 0x000fc400078ec0ffULL,
0x000000040b147810ULL, 0x000fe40007ffe0ffULL, 0xfffffff81a2f7812ULL, 0x000fe400078ee217ULL,
0x0000007012177812ULL, 0x000fe200078ef80cULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000000d1600720cULL, 0x080fe40003f06070ULL, 0x0000000d2800720cULL, 0x000fe40003f26070ULL,
0x0000001710167210ULL, 0x000fc40007fde0ffULL, 0x000000080b127810ULL, 0x000fe40007ffe0ffULL,
0x0ffffff8181d7812ULL, 0x000fe200078ef803ULL, 0x0000000111177824ULL, 0x000fe200030e0613ULL,
0x0000007014197812ULL, 0x000fe200078ef80cULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x00000018281a7810ULL, 0x000fe40007ffe0ffULL, 0x0000001910187210ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0224ULL, 0x0000000c0b147810ULL, 0x000fe20007ffe0ffULL,
0x000000011a1c7824ULL, 0x000fe200078e0203ULL, 0x00000070121b7812ULL, 0x000fe200078ef80cULL,
0x0000000111197824ULL, 0x000fe200030e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000161d7faeULL, 0x0003e2000c901c48ULL, 0x0000000d1a00720cULL, 0x040fe20003f26070ULL,
0x000000081a317824ULL, 0x000fe200078e00ffULL, 0x0000001b101a7210ULL, 0x000fe20007fde0ffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x000000100b127810ULL, 0x000fe20007ffe0ffULL,
0x00000000181f7faeULL, 0x0005e2000d101c48ULL, 0xfffffff831317812ULL, 0x000fe200078ee21cULL,
0x00000001111b7824ULL, 0x000fe200030e0613ULL, 0x0000001c281c7810ULL, 0x000fe20007ffe0ffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000007014177812ULL, 0x002fc400078ef80cULL,
0x000000001a217faeULL, 0x0003e2000d901c48ULL, 0x000000140b147810ULL, 0x000fe20007ffe0ffULL,
0x000000011c1e7824ULL, 0x000fe200078e0203ULL, 0x0000001710167210ULL, 0x000fe40007fde0ffULL,
0x00000070121d7812ULL, 0x000fe400078ef80cULL, 0x0000000d1c00720cULL, 0x040fe20003f46070ULL,
0x0000000111177824ULL, 0x000fe200030e0615ULL, 0x000000031c337819ULL, 0x000fe200000006ffULL,
0x0000010014147825ULL, 0x000fe200078e00ffULL, 0x0000001d101c7210ULL, 0x000fc40007fde0ffULL,
0x000000180b127810ULL, 0x000fe20007ffe0ffULL, 0x0000001025217824ULL, 0x002fe200078e0224ULL,
0x0000007014197812ULL, 0x004fe200078ef80cULL, 0x00000001111d7824ULL, 0x000fe200030e0613ULL,
0xfffffff833337812ULL, 0x000fe200078ee21eULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000001910187210ULL, 0x000fe20007fde0ffULL, 0x0000000016217faeULL, 0x0003e2000e101c48ULL,
0x00000020281e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001027257824ULL, 0x000fe200078e0224ULL,
0x0000001c0b147810ULL, 0x000fe20007ffe0ffULL, 0x0000000111197824ULL, 0x040fe200030e0615ULL,
0x0000007012237812ULL, 0x100fe200078ef80cULL, 0x000000011e1f7824ULL, 0x040fe200078e0203ULL,
0x0000000d1e00720cULL, 0x040fe20003f66070ULL, 0x000000081e127824ULL, 0x000fe200078e00ffULL,
0x00000023101e7210ULL, 0x000fe20007fde0ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000000d2000720cULL, 0x000fe20003f86070ULL, 0x000000001c257faeULL, 0x0005e2000e901c48ULL,
0xfffffff812297812ULL, 0x000fe200078ee21fULL, 0x00000001111f7824ULL, 0x000fe200030e0613ULL,
0x00000070141b7812ULL, 0x000fe200078ef80cULL, 0x0000000820147824ULL, 0x040fe200078e00ffULL,
0x0000000320137210ULL, 0x000fc40007ffe0ffULL, 0x000000200b127810ULL, 0x040fe40007ffe0ffULL,
0xfffffff8142b7812ULL, 0x000fe400078ee213ULL, 0x0000001b101a7210ULL, 0x000fe20007fde0ffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x000000240b147810ULL, 0x040fe40007ffe0ffULL,
0x000000280b167810ULL, 0x002fe20007ffe0ffULL, 0x00000001111b7824ULL, 0x000fe200030e0615ULL,
0x0000007012217812ULL, 0x000fe200078ef80cULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000000d2200720cULL, 0x000fc40003fa6070ULL, 0x0000002110207210ULL, 0x000fe20007fde0ffULL,
0x0000000122127824ULL, 0x000fe200078e0203ULL, 0x0000007014237812ULL, 0x000fe200078ef80cULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x0000002c28147810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee212ULL, 0x0000000111217824ULL, 0x000fe200030e0613ULL,
0x0000002310227210ULL, 0x000fe20007fde0ffULL, 0x000000102f257824ULL, 0x004fe200078e0224ULL,
0x0000007016137812ULL, 0x000fe200078ef80cULL, 0x00000001141d7824ULL, 0x000fe200078e0203ULL,
0x0000002c0b127810ULL, 0x000fe20007ffe0ffULL, 0x0000000111237824ULL, 0x000fe200030e0615ULL,
0x0000001310167210ULL, 0x000fe20007fde0ffULL, 0x0000000018257faeULL, 0x0003e2000c101c48ULL,
0x000000300b157810ULL, 0x000fe20007ffe0ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000001711177210ULL, 0x000fc400037fe4ffULL, 0x0000000d1400720cULL, 0x040fe20003f06070ULL,
0x0000000814267824ULL, 0x000fe200078e00ffULL, 0x0000007012277812ULL, 0x000fe200078ef80cULL,
0x0000010015147825ULL, 0x000fe200078e00ffULL, 0x0000003028127810ULL, 0x000fe40007ffe0ffULL,
0x00000027101c7210ULL, 0x000fe20007fde0ffULL, 0x0000001031257824ULL, 0x102fe200078e0224ULL,
0xfffffff8262f7812ULL, 0x000fe200078ee21dULL, 0x0000001033277824ULL, 0x000fe200078e0224ULL,
0x0000007014197812ULL, 0x000fe200078ef80cULL, 0x00000001111d7824ULL, 0x000fe200030e0613ULL,
0x000000001e257faeULL, 0x0003e2000c901c48ULL, 0x0000000112137824ULL, 0x040fe200078e0203ULL,
0x0000000d1200720cULL, 0x040fe20003f26070ULL, 0x0000000812147824ULL, 0x000fe200078e00ffULL,
0x000000340b127810ULL, 0x000fe20007ffe0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0224ULL,
0x0000001910187210ULL, 0x000fe20007fde0ffULL, 0x000000001a277faeULL, 0x0005e2000d101c48ULL,
0xfffffff814317812ULL, 0x000fe200078ee213ULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000002429297211ULL, 0x000fc400078e20ffULL, 0x0000003428147810ULL, 0x000fe20007ffe0ffULL,
0x0000000111197824ULL, 0x000fe200030e0615ULL, 0x00000070121f7812ULL, 0x002fe200078ef80cULL,
0x0000000020297faeULL, 0x0003e2000d901c48ULL, 0x0000003828267810ULL, 0x000fe20007ffe0ffULL,
0x000000102d2d7824ULL, 0x100fe200078e0224ULL, 0x0000001f101e7210ULL, 0x000fe20007fde0ffULL,
0x00000000222b7faeULL, 0x0003e2000e101c48ULL, 0x0000003c28287810ULL, 0x000fe20007ffe0ffULL,
0x00000008141a7824ULL, 0x044fe200078e00ffULL, 0x000000380b127810ULL, 0x000fe20007ffe0ffULL,
0x00000001111f7824ULL, 0x000fe200030e0613ULL, 0x0000000d1400720cULL, 0x080fe20003f86070ULL,
0x000000102f2f7824ULL, 0x000fe200078e0224ULL, 0x0000000d2600720cULL, 0x080fe20003f66070ULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000000d2800720cULL, 0x000fe20003f46070ULL,
0x00000000162d7faeULL, 0x0003e4000e901c48ULL, 0x00000001140d7824ULL, 0x100fe200078e0203ULL,
0x0000003c0b147810ULL, 0x000fe20007ffe0ffULL, 0x00000001260b7824ULL, 0x100fe200078e0203ULL,
0x00000070121b7812ULL, 0x100fe200078ef80cULL, 0x0000000128037824ULL, 0x000fe200078e0203ULL,
0xfffffff81a0d7812ULL, 0x000fe200078ee20dULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0x0000001b10127210ULL, 0x000fe20007fde0ffULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x000000001c2f7faeULL, 0x0003e4000c101c48ULL, 0xfffffff8281b7812ULL, 0x000fe200078ee203ULL,
0x0000000826267824ULL, 0x000fe200078e00ffULL, 0x0000007014037812ULL, 0x000fe200078ef80cULL,
0x0000001031317824ULL, 0x100fe200078e0224ULL, 0x0000001311137210ULL, 0x000fe200037fe4ffULL,
0x000000101b1b7824ULL, 0x000fe200078e0224ULL, 0xfffffff8260b7812ULL, 0x000fc400078ee20bULL,
0x00000003100c7210ULL, 0x000fe20007fde0ffULL, 0x000000100d037824ULL, 0x100fe200078e0224ULL,
0x0000000018317faeULL, 0x0003e2000c901c48ULL, 0x000000100b0b7824ULL, 0x000fe400078e0224ULL,
0x00000001110d7824ULL, 0x000fe200030e0615ULL, 0x000000001e037faeULL, 0x0003e8000e101c48ULL,
0x00000000120b7faeULL, 0x0003e8000d901c48ULL, 0x000000000c1b7faeULL, 0x0003e2000d101c48ULL,
0x00000b3000007947ULL, 0x000fea0003800000ULL, 0x0000000403157811ULL, 0x042fe400078fe8ffULL,
0x0000000c03237811ULL, 0x000fc400078fe8ffULL, 0x0000000315207819ULL, 0x040fe200000006ffULL,
0x00000001150b7824ULL, 0x100fe200078e0203ULL, 0x0000000803217811ULL, 0x000fe200078fe8ffULL,
0x00000001230d7824ULL, 0x000fe200078e0203ULL, 0x0000001003257811ULL, 0x000fe200078fe8ffULL,
0x0000000823247824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee20bULL,
0x00000001210b7824ULL, 0x000fe200078e0203ULL, 0x0000001c032d7811ULL, 0x000fe200078fe8ffULL,
0x0000000821227824ULL, 0x000fe200078e00ffULL, 0xfffffff824247812ULL, 0x000fe200078ee20dULL,
0x0000000125127824ULL, 0x100fe200078e0203ULL, 0x00000020030d7811ULL, 0x000fe200078fe8ffULL,
0x0000000825177824ULL, 0x000fe200078e00ffULL, 0x0000001403277811ULL, 0x000fe200078fe8ffULL,
0x000000012d147824ULL, 0x000fe200078e0203ULL, 0x0000002403297811ULL, 0x000fe200078fe8ffULL,
0x000000080d167824ULL, 0x040fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee20bULL,
0x000000010d0b7824ULL, 0x100fe200078e0203ULL, 0xfffffff817267812ULL, 0x000fe200078ee212ULL,
0x000000082d177824ULL, 0x000fe200078e00ffULL, 0x00000028032a7811ULL, 0x000fe200078fe8ffULL,
0x0000000127137824ULL, 0x100fe200078e0203ULL, 0x00000018032c7811ULL, 0x000fe200078fe8ffULL,
0x0000000827287824ULL, 0x000fe200078e00ffULL, 0x0000002c032b7811ULL, 0x000fe200078fe8ffULL,
0x0000000129127824ULL, 0x040fe200078e0203ULL, 0xfffffff816167812ULL, 0x000fe200078ee20bULL,
0x0000000829197824ULL, 0x000fe200078e00ffULL, 0xfffffff817307812ULL, 0x000fe200078ee214ULL,
0x000000012a0b7824ULL, 0x000fe200078e0203ULL, 0xfffffff828287812ULL, 0x000fe200078ee213ULL,
0x000000082c2e7824ULL, 0x000fe200078e00ffULL, 0xfffffff819177812ULL, 0x000fe200078ee212ULL,
0x000000012b127824ULL, 0x040fe200078e0203ULL, 0x000000032a187819ULL, 0x000fe200000006ffULL,
0x000000082b197824ULL, 0x000fe200078e00ffULL, 0x000000032c137210ULL, 0x000fc40007ffe0ffULL,
0x0000003003327811ULL, 0x040fe400078fe8ffULL, 0xfffffff818187812ULL, 0x000fe400078ee20bULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee213ULL, 0x0000000132137824ULL, 0x040fe200078e0203ULL,
0x00000003030b7211ULL, 0x000fe200078fe8ffULL, 0x00000008321a7824ULL, 0x000fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fe400078ee212ULL, 0x0000003803367811ULL, 0x000fc400078fe8ffULL,
0x0000003403347811ULL, 0x040fe400078fe8ffULL, 0x0000000803127211ULL, 0x040fe400078fe8ffULL,
0x0000003c03387811ULL, 0x000fe200078fe8ffULL, 0x0000000134147824ULL, 0x100fe200078e0203ULL,
0x000000070b1c7812ULL, 0x000fe200078ec0ffULL, 0x00000001360b7824ULL, 0x000fe200078e0203ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee213ULL, 0x00000008341b7824ULL, 0x000fe200078e00ffULL,
0x00000003363a7819ULL, 0x000fe200000006ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0ffffff81c1e7812ULL, 0x000fc400078ef803ULL, 0xfffffff83a1d7812ULL, 0x000fe200078ee20bULL,
0x0000000138037824ULL, 0x040fe200078e0203ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee214ULL,
0x00000008381c7824ULL, 0x000fe200078e00ffULL, 0x00000070120b7812ULL, 0x000fe200078ef80cULL,
0x0000000108147824ULL, 0x000fe200078e0215ULL, 0x00002000004d7811ULL, 0x000fe400078e70ffULL,
0xfffffff81c127812ULL, 0x000fe200078ee203ULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000000b101c7210ULL, 0x000fc40007f1e0ffULL, 0x0000004d2e3b7211ULL, 0x000fe200078e20ffULL,
0x000000101e037824ULL, 0x100fe200078e024dULL, 0x00000070141f7812ULL, 0x000fe200078ef80cULL,
0x00000010200b7824ULL, 0x100fe400078e024dULL, 0x0000001022337824ULL, 0x100fe200078e024dULL,
0x0000001f101e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001024357824ULL, 0x100fe400078e024dULL,
0x0000001026377824ULL, 0x100fe400078e024dULL, 0x0000001028397824ULL, 0x000fc400078e024dULL,
0x00000010303d7824ULL, 0x100fe400078e024dULL, 0x00000010163f7824ULL, 0x100fe400078e024dULL,
0x0000001017417824ULL, 0x100fe400078e024dULL, 0x0000001018437824ULL, 0x100fe400078e024dULL,
0x0000001019457824ULL, 0x100fe400078e024dULL, 0x000000101a477824ULL, 0x000fc400078e024dULL,
0x000000101b497824ULL, 0x100fe400078e024dULL, 0x000000101d4b7824ULL, 0x000fe200078e024dULL,
0x0000004d124d7211ULL, 0x000fe200078e20ffULL, 0x0000000108127824ULL, 0x000fe400078e0221ULL,
0x00000001111d7824ULL, 0x000fe400000e0613ULL, 0x0000010012127825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c037faeULL, 0x0003e2000b901c48ULL,
0x0000000108187824ULL, 0x000fe200078e0227ULL, 0x0000007012217812ULL, 0x000fe200078ef80cULL,
0x0000000108167824ULL, 0x000fe400078e0225ULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x0000002110207210ULL, 0x000fc60007f1e0ffULL, 0x00000001081a7824ULL, 0x000fe200078e022cULL,
0x0000007018277812ULL, 0x000fe200078ef80cULL, 0x0000000108147824ULL, 0x000fe400078e0223ULL,
0x00000001111f7824ULL, 0x000fe400008e0615ULL, 0x0000010016167825ULL, 0x000fc600078e00ffULL,
0x000000001e0b7faeULL, 0x0003e2000b901c48ULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x0000007016257812ULL, 0x000fc600078ef80cULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000002510247210ULL, 0x000fc60007f5e0ffULL, 0x0000000111217824ULL, 0x040fe200000e0613ULL,
0x0000002710267210ULL, 0x000fe20007f1e0ffULL, 0x0000000108127824ULL, 0x000fe200078e022dULL,
0x000000701a137812ULL, 0x100fe200078ef80cULL, 0x0000000108167824ULL, 0x000fe200078e0229ULL,
0x0000007014237812ULL, 0x000fe200078ef80cULL, 0x0000000111277824ULL, 0x040fe200000e0619ULL,
0x0000001310287210ULL, 0x000fe20007f1e0ffULL, 0x0000010012127825ULL, 0x000fe200078e00ffULL,
0x0000002310227210ULL, 0x000fe20007f3e0ffULL, 0x0000000020337faeULL, 0x0003e4000b901c48ULL,
0x0000000108147824ULL, 0x040fe200078e020dULL, 0x0000001511237210ULL, 0x040fe20000ffe4ffULL,
0x0000000108187824ULL, 0x000fe200078e022aULL, 0x00000070120d7812ULL, 0x000fe200078ef80cULL,
0x0000000111257824ULL, 0x000fc400010e0617ULL, 0x0000010014147825ULL, 0x000fe200078e00ffULL,
0x0000000022357faeULL, 0x0003e6000b901c48ULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x00000070142d7812ULL, 0x100fe200078ef80cULL, 0x0000000024377faeULL, 0x0003e4000b901c48ULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x00000070162f7812ULL, 0x100fe200078ef80cULL,
0x0000000026397faeULL, 0x0003e2000b901c48ULL, 0x0000002d102c7210ULL, 0x040fe20007f3e0ffULL,
0x0000000111297824ULL, 0x040fe200000e061bULL, 0x0000000d102a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000108127824ULL, 0x000fe200078e022bULL, 0x0000007018317812ULL, 0x000fe200078ef80cULL,
0x0000000108147824ULL, 0x000fe200078e0232ULL, 0x00000013112b7210ULL, 0x000fe200007fe4ffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000002f102e7210ULL, 0x040fe20007f1e0ffULL,
0x00000000283b7faeULL, 0x0003e2000b901c48ULL, 0x0000003110307210ULL, 0x000fe20007f5e0ffULL,
0x0000000108167824ULL, 0x000fe200078e0234ULL, 0x00000070120d7812ULL, 0x000fe200078ef80cULL,
0x0000000108187824ULL, 0x040fe200078e0236ULL, 0x000000002a3d7faeULL, 0x0003e2000b901c48ULL,
0x00000001081a7824ULL, 0x000fc400078e0238ULL, 0x00000001112d7824ULL, 0x040fe400008e0615ULL,
0x00000001112f7824ULL, 0x040fe200000e0617ULL, 0x0000000d10127210ULL, 0x000fe20007f1e0ffULL,
0x0000000111317824ULL, 0x000fe200010e0619ULL, 0x000000002c3f7faeULL, 0x0003e2000b901c48ULL,
0x0000010014147825ULL, 0x000fc600078e00ffULL, 0x000000002e417faeULL, 0x0003e2000b901c48ULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x0000007014537812ULL, 0x100fe400078ef80cULL,
0x0000000030437faeULL, 0x0003e2000b901c48ULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x0000007016517812ULL, 0x000fc600078ef80cULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x00000070184f7812ULL, 0x100fe400078ef80cULL, 0x0000005110147210ULL, 0x000fe20007f3e0ffULL,
0x0000000111137824ULL, 0x000fe200000e0613ULL, 0x000000701a0d7812ULL, 0x000fe400078ef80cULL,
0x00000053100c7210ULL, 0x040fe40007f1e0ffULL, 0x0000004f10167210ULL, 0x040fe20007f5e0ffULL,
0x0000000012457faeULL, 0x0003e2000b901c48ULL, 0x0000000d10107210ULL, 0x000fc40007f7e0ffULL,
0x00000015110d7210ULL, 0x040fe200007fe4ffULL, 0x0000000111157824ULL, 0x040fe400008e0617ULL,
0x0000000111177824ULL, 0x040fe400010e0619ULL, 0x0000000111117824ULL, 0x000fe200018e061bULL,
0x000000000c477faeULL, 0x0003e8000b901c48ULL, 0x0000000014497faeULL, 0x0003e8000b901c48ULL,
0x00000000164b7faeULL, 0x0003e8000b901c48ULL, 0x00000000104d7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x00000000000c7805ULL, 0x002fc40000015200ULL,
0x01e60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fc4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100c107210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0dULL, 0x003d09001000780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401000780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011411ULL,
0x0000001003037211ULL, 0x000fca00078110ffULL, 0x000000ffff107224ULL, 0x000fca00000e0611ULL,
0x0000000203037819ULL, 0x000fc80000001210ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01e60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000060200720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000009d7919ULL, 0x000e620000000000ULL, 0x00005800ff9a7624ULL, 0x000fe200078e00ffULL,
0x8000580004997a10ULL, 0x000fe20007ffe0ffULL, 0x00006800a2a27a24ULL, 0x000fe200078e02ffULL,
0x0001e688009c7811ULL, 0x040fe200078e18ffULL, 0x00000020009e7824ULL, 0x000fe200078e00ffULL,
0x0000001f9a037810ULL, 0x040fe40007ffe0ffULL, 0xffffffff9a9b7810ULL, 0x000fe40007ffe0ffULL,
0x00000004ff037819ULL, 0x000fc40000011603ULL, 0x000000099a9a7810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff997819ULL, 0x000fe40000011699ULL, 0x0ffffffe03987812ULL, 0x000fc400078ec0ffULL,
0x0000000102037810ULL, 0x040fe20007ffe0ffULL, 0x000000099f0c7224ULL, 0x000fe200078e02ffULL,
0x0000010000a17802ULL, 0x000fe20000000f00ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000060300720cULL, 0x000fe20003f06070ULL, 0x0000010002237824ULL, 0x000fe400078e02a0ULL,
0x000062000c0c7625ULL, 0x000fd400078e00a1ULL, 0x00000bb000008947ULL, 0x00cfea0003800000ULL,
0x000000109d227824ULL, 0x002fe200078e00ffULL, 0x00000003ff207819ULL, 0x100fe2000001169dULL,
0x000000ffff0f7224ULL, 0x000fe200078e00ffULL, 0x0000002304127217ULL, 0x000fe40007800000ULL,
0x0000007022227812ULL, 0x000fe200078ec0ffULL, 0x0000000108117824ULL, 0x000fe200078e0220ULL,
0x0000000420147810ULL, 0x000fe40007ffe0ffULL, 0x00000080220e7812ULL, 0x000fe400078efcffULL,
0x0000000820167810ULL, 0x000fe20007ffe0ffULL, 0x0000000114037824ULL, 0x000fe200078e029dULL,
0x0000000c201a7810ULL, 0x040fe20007ffe0ffULL, 0x0000010011107825ULL, 0x000fe200078e000eULL,
0x00000010201c7810ULL, 0x000fc40007ffe0ffULL, 0x0000001420247810ULL, 0x000fe20007ffe0ffULL,
0x0000000814267824ULL, 0x000fe200078e00ffULL, 0x000000100c187210ULL, 0x000fe20007f1e0ffULL,
0x0000000116097824ULL, 0x000fe200078e029dULL, 0x0000001820307810ULL, 0x000fe20007ffe0ffULL,
0x0000000816287824ULL, 0x000fe200078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee203ULL,
0x000000010d197824ULL, 0x000fe200000e0611ULL, 0x0ffffff89d217812ULL, 0x000fe200078ec0ffULL,
0x0000000108117824ULL, 0x000fe200078e0214ULL, 0xfffffff828287812ULL, 0x000fe200078ee209ULL,
0x0000000112037824ULL, 0x000fe200078e0a23ULL, 0x0000009d1a097210ULL, 0x040fe20007ffe0ffULL,
0x000000081a2a7824ULL, 0x000fe200078e00ffULL, 0x0000001c20327810ULL, 0x000fe20007ffe0ffULL,
0x0000010011107825ULL, 0x000fe200078e000eULL, 0x000000031a00720cULL, 0x000fc40003f66070ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee209ULL, 0x0000000108137824ULL, 0x040fe200078e0216ULL,
0x0000001c08097210ULL, 0x040fe20007ffe0ffULL, 0x0000000108157824ULL, 0x000fe200078e021aULL,
0x000000100c1a7210ULL, 0x000fe20007f3e0ffULL, 0x0000010013127825ULL, 0x000fe200078e000eULL,
0x000000031c00720cULL, 0x080fe40003f06070ULL, 0x000000031400720cULL, 0x080fe20003f86070ULL,
0x000000011c0b7824ULL, 0x000fe200078e029dULL, 0x000000031600720cULL, 0x000fe20003f46070ULL,
0x000000081c2c7824ULL, 0x000fe200078e00ffULL, 0x000000120c1c7210ULL, 0x000fe20007fbe0ffULL,
0x000000010d1b7824ULL, 0x000fe200008e0611ULL, 0x0000002020347810ULL, 0x000fe20007ffe0ffULL,
0x0000010009107825ULL, 0x000fe200078e000eULL, 0xfffffff82c2c7812ULL, 0x000fc400078ee20bULL,
0x0000009d240b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000108177824ULL, 0x000fe400078e0224ULL,
0x0000010015147825ULL, 0x000fc800078e000eULL, 0x000000010d1d7824ULL, 0x000fe200028e0613ULL,
0x000000100c1e7210ULL, 0x040fe20007fbe0ffULL, 0x0000010017167825ULL, 0x000fe200078e000eULL,
0x000000140c147210ULL, 0x000fc60007f3e0ffULL, 0x0000000108097824ULL, 0x000fe200078e0230ULL,
0x000000160c167210ULL, 0x000fe20007fde0ffULL, 0x000000010d1f7824ULL, 0x000fe200028e0611ULL,
0x000000032000720cULL, 0x000fe20003fa6070ULL, 0x0000010009107825ULL, 0x000fe200078e000eULL,
0x0000400000097811ULL, 0x000fc600078e70ffULL, 0x0000000120127824ULL, 0x000fe400078e029dULL,
0x000000010d157824ULL, 0x040fe200008e0615ULL, 0x000000032400720cULL, 0x040fe20003f26070ULL,
0x000000010d177824ULL, 0x000fe200030e0617ULL, 0x0000000721127812ULL, 0x000fe200078ef812ULL,
0x00000008242e7824ULL, 0x000fe200078e00ffULL, 0x000000100c247210ULL, 0x000fe20007fde0ffULL,
0x0000001026297824ULL, 0x000fe400078e0209ULL, 0x00000001302b7824ULL, 0x000fe200078e029dULL,
0xfffffff82e2e7812ULL, 0x000fe200078ee20bULL, 0x000000010d257824ULL, 0x000fc400030e0611ULL,
0x0000000108117824ULL, 0x000fe400078e0232ULL, 0x00000010120b7824ULL, 0x000fe400078e0209ULL,
0x0000010011107825ULL, 0x000fc600078e000eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000180b7faeULL, 0x0003e2000e901c48ULL, 0x000000033000720cULL, 0x040fe20003fa6070ULL,
0x0000000830307824ULL, 0x000fe200078e00ffULL, 0x000000100c267210ULL, 0x000fe20007fde0ffULL,
0x000000001a297faeULL, 0x0005e2000e101c48ULL, 0x0000009d32107210ULL, 0x000fe20007ffe0ffULL,
0x0000000108137824ULL, 0x000fe200078e0234ULL, 0x000000033200720cULL, 0x000fe20003f86070ULL,
0x000000010d277824ULL, 0x000fe400030e0611ULL, 0x0000010013127825ULL, 0x000fe200078e000eULL,
0x0000002420187810ULL, 0x002fc60007ffe0ffULL, 0x00000008320b7824ULL, 0x000fe200078e00ffULL,
0x000000120c127210ULL, 0x000fe20007fde0ffULL, 0x000000102a1b7824ULL, 0x004fe200078e0209ULL,
0xfffffff8301a7812ULL, 0x000fe200078ee22bULL, 0x0000000108117824ULL, 0x000fe200078e0218ULL,
0xfffffff80b307812ULL, 0x000fe200078ee210ULL, 0x00000010280b7824ULL, 0x000fe200078e0209ULL,
0x0000009d18287210ULL, 0x000fe20007ffe0ffULL, 0x0000000134197824ULL, 0x000fe200078e029dULL,
0x00000034202a7810ULL, 0x000fe20007ffe0ffULL, 0x0000010011107825ULL, 0x000fe200078e000eULL,
0x000000001c0b7faeULL, 0x0003e2000d101c48ULL, 0x000000031800720cULL, 0x000fc40003f46070ULL,
0x000000010d137824ULL, 0x000fe200030e0613ULL, 0x00000000141b7faeULL, 0x0005e2000d901c48ULL,
0x000000033400720cULL, 0x040fe20003f66070ULL, 0x0000000834347824ULL, 0x000fe400078e00ffULL,
0x0000000818297824ULL, 0x000fe200078e00ffULL, 0x000000100c187210ULL, 0x000fe40007fde0ffULL,
0xfffffff834107812ULL, 0x000fe200078ee219ULL, 0x000000102c0b7824ULL, 0x002fe200078e0209ULL,
0xfffffff829287812ULL, 0x000fe200078ee228ULL, 0x000000010d197824ULL, 0x000fe200030e0611ULL,
0x00000030201c7810ULL, 0x000fe20007ffe0ffULL, 0x000000102e117824ULL, 0x100fe200078e0209ULL,
0x000000001e0b7faeULL, 0x0003e2000c101c48ULL, 0x00000010101d7824ULL, 0x100fe200078e0209ULL,
0x0000002820107810ULL, 0x000fe20007ffe0ffULL, 0x000000101a157824ULL, 0x104fe200078e0209ULL,
0x0000000016117faeULL, 0x0005e2000c901c48ULL, 0x00000010301b7824ULL, 0x000fe200078e0209ULL,
0x00000003101a7819ULL, 0x000fc400000006ffULL, 0x0000002c20147810ULL, 0x000fe20007ffe0ffULL,
0x0000000024157faeULL, 0x0007e2000e901c48ULL, 0x000000031000720cULL, 0x080fe20003fc6070ULL,
0x00000010280b7824ULL, 0x002fe400078e0209ULL, 0x00000000261b7faeULL, 0x0003e2000e101c48ULL,
0x00000038202c7810ULL, 0x000fe20007ffe0ffULL, 0x00000008141e7824ULL, 0x000fe200078e00ffULL,
0x0000003c202e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000110117824ULL, 0x104fe200078e029dULL,
0x00000000121d7faeULL, 0x0005e2000d901c48ULL, 0x000000031400720cULL, 0x080fe20003fa6070ULL,
0x000000011c167824ULL, 0x140fe200078e029dULL, 0x000000031c00720cULL, 0x080fe20003f86070ULL,
0x0000000114157824ULL, 0x008fe200078e029dULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee211ULL,
0x0000000108117824ULL, 0x000fe200078e0210ULL, 0x00000000180b7faeULL, 0x0007e2000d101c48ULL,
0x000000081c177824ULL, 0x000fe200078e00ffULL, 0x000000032a00720cULL, 0x080fe20003f66070ULL,
0x0000010011107825ULL, 0x000fe200078e000eULL, 0x000000032c00720cULL, 0x000fc40003f26070ULL,
0x000000032e00720cULL, 0x000fe20003f06070ULL, 0x0000000108137824ULL, 0x004fe200078e0214ULL,
0x000000100c147210ULL, 0x000fe20007f5e0ffULL, 0x0000000108037824ULL, 0x000fe200078e021cULL,
0xfffffff81e1c7812ULL, 0x000fe200078ee215ULL, 0x0000010013127825ULL, 0x000fe200078e000eULL,
0xfffffff8171e7812ULL, 0x000fe400078ee216ULL, 0x000000110d157210ULL, 0x000fe200017fe4ffULL,
0x0000010003107825ULL, 0x000fe200078e000eULL, 0x000000120c167210ULL, 0x000fc60007f5e0ffULL,
0x000000012a0b7824ULL, 0x048fe400078e029dULL, 0x000000082a207824ULL, 0x000fe400078e00ffULL,
0x0000000108037824ULL, 0x000fe400078e022aULL, 0x000000010d177824ULL, 0x000fe200010e0613ULL,
0x000000100c187210ULL, 0x000fe20007f5e0ffULL, 0x0000010003127825ULL, 0x000fe200078e000eULL,
0xfffffff820207812ULL, 0x000fe400078ee20bULL, 0x0000002e08037210ULL, 0x040fe20007ffe0ffULL,
0x00000001080b7824ULL, 0x000fc400078e022cULL, 0x000000010d197824ULL, 0x000fe200010e0611ULL,
0x000000120c127210ULL, 0x000fe20007f5e0ffULL, 0x000001000b107825ULL, 0x000fc800078e000eULL,
0x000000010d137824ULL, 0x000fe200010e0613ULL, 0x000000100c107210ULL, 0x000fe20007f5e0ffULL,
0x000000012c1b7824ULL, 0x142fe400078e029dULL, 0x000000082c247824ULL, 0x000fe400078e00ffULL,
0x000000012e0b7824ULL, 0x040fe400078e029dULL, 0x000000082e267824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee21bULL, 0x00000100030e7825ULL, 0x000fc600078e000eULL,
0xfffffff826267812ULL, 0x000fe200078ee20bULL, 0x000000010d117824ULL, 0x040fe200010e0611ULL,
0x0000000e0c0c7210ULL, 0x000fe20007f5e0ffULL, 0x000000101a037824ULL, 0x100fe200078e0209ULL,
0x00000009241f7211ULL, 0x000fe200078e20ffULL, 0x000000101c0b7824ULL, 0x100fe400078e0209ULL,
0x000000101e1b7824ULL, 0x100fe200078e0209ULL, 0x0000000014037faeULL, 0x0003e2000f101c48ULL,
0x00000010201d7824ULL, 0x100fe400078e0209ULL, 0x0000001026097824ULL, 0x000fe200078e0209ULL,
0x00000000160b7faeULL, 0x0003e2000e901c48ULL, 0x000000010d0d7824ULL, 0x000fc600010e060fULL,
0x00000000181b7faeULL, 0x0003e8000e101c48ULL, 0x00000000121d7faeULL, 0x0003e8000d901c48ULL,
0x00000000101f7faeULL, 0x0003e8000c901c48ULL, 0x000000000c097faeULL, 0x0003e2000c101c48ULL,
0x00000a7000007947ULL, 0x000fea0003800000ULL, 0x000000049d117811ULL, 0x042fe200078fe8ffULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x000000089d127811ULL, 0x000fc400078fe8ffULL,
0x000000249d207811ULL, 0x000fe200078fe8ffULL, 0x0000000111037824ULL, 0x100fe200078e029dULL,
0x000000109d167811ULL, 0x000fe200078fe8ffULL, 0x00000008110e7824ULL, 0x000fe200078e00ffULL,
0x000000349d2a7811ULL, 0x040fe200078fe8ffULL, 0x00000008121a7824ULL, 0x000fe200078e00ffULL,
0x000000149d187811ULL, 0x040fe200078fe8ffULL, 0x0000000120137824ULL, 0x000fe200078e029dULL,
0xfffffff80e097812ULL, 0x000fe200078ee203ULL, 0x0000000112037824ULL, 0x000fe200078e029dULL,
0x0000000c9d147811ULL, 0x040fe200078fe8ffULL, 0x0000000820247824ULL, 0x000fe200078e00ffULL,
0x0000009d160f7210ULL, 0x0c0fe20007ffe0ffULL, 0x00000008161c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a0b7812ULL, 0x000fe200078ee203ULL, 0x000000082a2c7824ULL, 0x000fe200078e00ffULL,
0x000000189d1a7811ULL, 0x040fe200078fe8ffULL, 0x0000000118107824ULL, 0x000fe200078e029dULL,
0xfffffff824137812ULL, 0x000fe200078ee213ULL, 0x0000000818377824ULL, 0x000fe200078e00ffULL,
0x000000289d247811ULL, 0x040fe200078fe8ffULL, 0x000000011a037824ULL, 0x100fe200078e029dULL,
0x0000009d2a157210ULL, 0x080fe20007ffe0ffULL, 0x000000081a227824ULL, 0x000fe200078e00ffULL,
0x000000209d1e7811ULL, 0x040fe200078fe8ffULL, 0x00000001140e7824ULL, 0x000fe200078e029dULL,
0xfffffff81c0f7812ULL, 0x000fe200078ee20fULL, 0x0000000814337824ULL, 0x000fe200078e00ffULL,
0xfffffff822397812ULL, 0x000fe200078ee203ULL, 0x0000000124037824ULL, 0x040fe200078e029dULL,
0x0000001c9d1c7811ULL, 0x040fe200078fe8ffULL, 0x0000000824227824ULL, 0x000fe200078e00ffULL,
0xfffffff82c157812ULL, 0x000fe200078ee215ULL, 0x0000000108117824ULL, 0x000fe200078e0211ULL,
0x000000389d2c7811ULL, 0x000fe200078fe8ffULL, 0x000000081c3b7824ULL, 0x000fe200078e00ffULL,
0xfffffff837377812ULL, 0x000fe200078ee210ULL, 0x000000011e107824ULL, 0x100fe200078e029dULL,
0xfffffff833337812ULL, 0x000fe200078ee20eULL, 0x000000011c0e7824ULL, 0x100fe200078e029dULL,
0x000000031e3d7819ULL, 0x000fe200000006ffULL, 0x000000012c177824ULL, 0x000fe200078e029dULL,
0x000000309d287811ULL, 0x040fe200078fe8ffULL, 0x00000001081b7824ULL, 0x000fe200078e021aULL,
0xfffffff822417812ULL, 0x000fe200078ee203ULL, 0x000000082c227824ULL, 0x000fe200078e00ffULL,
0x0000002c9d267811ULL, 0x000fe200078fe8ffULL, 0x0000000828457824ULL, 0x040fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee210ULL, 0x0000000128107824ULL, 0x100fe200078e029dULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee20eULL, 0x00000001260e7824ULL, 0x040fe200078e029dULL,
0x0000003c9d2e7811ULL, 0x040fe200078fe8ffULL, 0x0000000826437824ULL, 0x000fe200078e00ffULL,
0xfffffff822177812ULL, 0x000fe200078ee217ULL, 0x000000109d227824ULL, 0x000fe200078e00ffULL,
0xfffffff845457812ULL, 0x000fe200078ee210ULL, 0x000000012e197824ULL, 0x000fe200078e029dULL,
0x0000400000107811ULL, 0x000fe200078e70ffULL, 0x000000082e307824ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fe200078ee20eULL, 0x00000001081d7824ULL, 0x000fe200078e021cULL,
0x0000009d9d0e7211ULL, 0x000fe200078fe8ffULL, 0x000000100f357824ULL, 0x100fe200078e0210ULL,
0x0ffffff89d217812ULL, 0x000fe200078ec0ffULL, 0x00000010133f7824ULL, 0x100fe200078e0210ULL,
0x0000007022227812ULL, 0x000fe200078ec0ffULL, 0x0000001015477824ULL, 0x000fe200078e0210ULL,
0xfffffff830197812ULL, 0x000fe200078ee219ULL, 0x0000000108137824ULL, 0x000fe200078e0212ULL,
0x0000000721037812ULL, 0x000fe200078ef80eULL, 0x0000001009097824ULL, 0x100fe200078e0210ULL,
0x000000089d0f7211ULL, 0x000fe200078fe8ffULL, 0x0000001033337824ULL, 0x100fe200078e0210ULL,
0x0000008022307812ULL, 0x000fe200078efcffULL, 0x0000001003037824ULL, 0x100fe200078e0210ULL,
0x000000100b0b7211ULL, 0x080fe200078e20ffULL, 0x0000001037377824ULL, 0x100fe200078e0210ULL,
0x0000001043437211ULL, 0x000fe200078e20ffULL, 0x0000001039397824ULL, 0x100fe200078e0210ULL,
0x0000002c082f7210ULL, 0x000fe20007ffe0ffULL, 0x000000103b3b7824ULL, 0x000fc400078e0210ULL,
0x000000103d3d7824ULL, 0x100fe400078e0210ULL, 0x0000001041417824ULL, 0x100fe400078e0210ULL,
0x0000001045457824ULL, 0x100fe400078e0210ULL, 0x0000001017497824ULL, 0x100fe400078e0210ULL,
0x00000010194b7824ULL, 0x000fe200078e0210ULL, 0x0000001808197210ULL, 0x040fe20007ffe0ffULL,
0x0000000108157824ULL, 0x000fc400078e0214ULL, 0x000001000f0e7825ULL, 0x000fc800078e0030ULL,
0x0000010011107825ULL, 0x000fe200078e0030ULL, 0x0000000e0c0e7210ULL, 0x000fc60007f1e0ffULL,
0x0000000108177824ULL, 0x000fe200078e0216ULL, 0x000000100c107210ULL, 0x000fe20007f3e0ffULL,
0x0000010013127825ULL, 0x000fc800078e0030ULL, 0x0000010015147825ULL, 0x000fe200078e0030ULL,
0x000000120c127210ULL, 0x000fc60007f5e0ffULL, 0x0000010017167825ULL, 0x000fe200078e0030ULL,
0x000000140c147210ULL, 0x000fc60007f7e0ffULL, 0x0000010019187825ULL, 0x000fc800078e0030ULL,
0x00000001081f7824ULL, 0x040fe400078e021eULL, 0x0000000108257824ULL, 0x000fe400078e0220ULL,
0x000001001b1a7825ULL, 0x000fc800078e0030ULL, 0x0000000108277824ULL, 0x000fe400078e0224ULL,
0x000001001d1c7825ULL, 0x000fc800078e0030ULL, 0x000000010d0f7824ULL, 0x040fe200000e060fULL,
0x000000160c167210ULL, 0x040fe20007f1e0ffULL, 0x000000010d117824ULL, 0x000fe200008e0611ULL,
0x000000180c187210ULL, 0x000fe20007f3e0ffULL, 0x0000000108297824ULL, 0x000fe200078e0226ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e037faeULL, 0x0003e2000b901c48ULL,
0x000001001f1e7825ULL, 0x000fc600078e0030ULL, 0x0000000010097faeULL, 0x0003e2000b901c48ULL,
0x0000010025247825ULL, 0x000fc800078e0030ULL, 0x000000010d137824ULL, 0x000fe200010e0613ULL,
0x0000001a0c1a7210ULL, 0x000fe20007f5e0ffULL, 0x00000001082b7824ULL, 0x000fe400078e0228ULL,
0x0000010027267825ULL, 0x000fe200078e0030ULL, 0x0000001b0d1b7210ULL, 0x040fe200017fe4ffULL,
0x00000000120b7faeULL, 0x0003e4000b901c48ULL, 0x000000010d157824ULL, 0x000fe200018e0615ULL,
0x0000001c0c1c7210ULL, 0x000fe20007f7e0ffULL, 0x00000001082d7824ULL, 0x000fe200078e022aULL,
0x000000260c267210ULL, 0x040fe20007f5e0ffULL, 0x0000010029287825ULL, 0x000fe200078e0030ULL,
0x0000000014337faeULL, 0x0003e6000b901c48ULL, 0x000000010d177824ULL, 0x040fe200000e0617ULL,
0x0000001e0c1e7210ULL, 0x040fe20007f1e0ffULL, 0x000000010d197824ULL, 0x000fe200008e0619ULL,
0x000000240c247210ULL, 0x000fe20007f3e0ffULL, 0x00000001084d7824ULL, 0x000fe200078e022eULL,
0x0000000016357faeULL, 0x0003e2000b901c48ULL, 0x000001002b2a7825ULL, 0x000fc600078e0030ULL,
0x0000000018377faeULL, 0x0003e2000b901c48ULL, 0x000001002d2c7825ULL, 0x000fc600078e0030ULL,
0x000000001a397faeULL, 0x0003e2000b901c48ULL, 0x000001002f2e7825ULL, 0x000fc800078e0030ULL,
0x000000010d1d7824ULL, 0x000fe200018e061dULL, 0x000000280c287210ULL, 0x000fe20007f7e0ffULL,
0x000001004d307825ULL, 0x000fc600078e0030ULL, 0x000000001c3b7faeULL, 0x0003e2000b901c48ULL,
0x000000010d1f7824ULL, 0x040fe200000e061fULL, 0x0000002a0c2a7210ULL, 0x040fe20007f1e0ffULL,
0x000000010d257824ULL, 0x040fe200008e0625ULL, 0x0000002c0c2c7210ULL, 0x040fe20007f3e0ffULL,
0x000000010d277824ULL, 0x040fe200010e0627ULL, 0x0000002e0c2e7210ULL, 0x040fe20007f5e0ffULL,
0x000000010d297824ULL, 0x040fe200018e0629ULL, 0x000000300c0c7210ULL, 0x000fe20007f7e0ffULL,
0x000000010d2b7824ULL, 0x040fe200000e062bULL, 0x000000001e3d7faeULL, 0x0003e2000b901c48ULL,
0x000000010d2d7824ULL, 0x000fc400008e062dULL, 0x000000010d2f7824ULL, 0x040fe200010e062fULL,
0x00000000243f7faeULL, 0x0003e2000b901c48ULL, 0x000000310d0d7210ULL, 0x000fc60001ffe4ffULL,
0x0000000026417faeULL, 0x0003e8000b901c48ULL, 0x0000000028437faeULL, 0x0003e8000b901c48ULL,
0x000000002a457faeULL, 0x0003e8000b901c48ULL, 0x000000002c477faeULL, 0x0003e8000b901c48ULL,
0x000000002e497faeULL, 0x0003e8000b901c48ULL, 0x000000000c4b7faeULL, 0x0003e4000b901c48ULL,
0x000000040a0a7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff097424ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000050a00720cULL, 0x000fda0003f06070ULL,
0x00000002a20c8824ULL, 0x000fe400078e020aULL, 0x00000004ff0d8424ULL, 0x000fc800078e00ffULL,
0x000064000c0c8625ULL, 0x000fe200078e000dULL, 0x000000089d207812ULL, 0x000fe400078ec0ffULL,
0x00000004ff197819ULL, 0x000fe2000001169dULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000080c098981ULL, 0x000322000c1e1900ULL, 0x0000000720207812ULL, 0x000fe200078ef89dULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000079d6c7812ULL, 0x000fc600078ec0ffULL,
0x00000001191f7824ULL, 0x000fe400078e0220ULL, 0x00000010200e7824ULL, 0x000fca00078e00ffULL,
0xfffffff00e037812ULL, 0x000fca00078ee21fULL, 0x0000001003647824ULL, 0x000fc400078e00ffULL,
0x00000010201c7812ULL, 0x042fe200078efcffULL, 0x0000000819037824ULL, 0x000fe200078e00ffULL,
0x00000003ff1e7819ULL, 0x000fe2000001169dULL, 0x00000010200f7824ULL, 0x000fe200078e00ffULL,
0x000000021f0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000119197824ULL, 0x000fe200078e021cULL,
0xfffffff8036c7812ULL, 0x000fe200078ee26cULL, 0x000000101c0e7824ULL, 0x000fe200078e00ffULL,
0x000000011e0d7812ULL, 0x000fe200078ec0ffULL, 0x00004000001d7824ULL, 0x000fe200078e00ffULL,
0x000000106c7c7810ULL, 0x040fe20007ffe0ffULL, 0x000000086c1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff00e0b7812ULL, 0x000fe200078ee219ULL, 0x000000101c117824ULL, 0x000fe200078e00ffULL,
0x000000206c847810ULL, 0x040fe20007ffe0ffULL, 0x000000010d187824ULL, 0x040fe200078e027cULL,
0x0000006c0d037210ULL, 0x000fe20007ffe0ffULL, 0x000000100b687824ULL, 0x000fe200078e00ffULL,
0x000000306c0b7810ULL, 0x000fe20007ffe0ffULL, 0x00000008840e7824ULL, 0x000fe200078e00ffULL,
0xfffffff00f107812ULL, 0x000fe200078ee20cULL, 0x000000006464783bULL, 0x000fe20000000200ULL,
0x000000840d177210ULL, 0x040fe20007ffe0ffULL, 0x000000010d167824ULL, 0x000fe200078e020bULL,
0x000020001d1b7810ULL, 0x000fe20007ffe0ffULL, 0x000000087c0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee203ULL, 0x000000080b0f7824ULL, 0x000fe200078e00ffULL,
0x00000002190c7810ULL, 0x000fe20007ffe0ffULL, 0x000000006868783bULL, 0x000fe20000000200ULL,
0xfffffff80d187812ULL, 0x000fe200078ee218ULL, 0x000000101a607824ULL, 0x000fe200078e021bULL,
0xfffffff80e177812ULL, 0x000fe200078ee217ULL, 0x000000086c127824ULL, 0x000fe200078e00ffULL,
0xfffffff80f167812ULL, 0x000fe200078ee216ULL, 0x0000000884287824ULL, 0x000fe200078e00ffULL,
0xfffffff011117812ULL, 0x000fe200078ee20cULL, 0x00000010180c7824ULL, 0x100fe200078e021bULL,
0x000000006060783bULL, 0x000e620000000200ULL, 0x0000001017787824ULL, 0x100fe200078e021bULL,
0x0000000203157810ULL, 0x040fe20007ffe0ffULL, 0x00000010163c7824ULL, 0x000fe200078e021bULL,
0x0000001203147810ULL, 0x000fe20007ffe0ffULL, 0x000000000c0c783bULL, 0x000ea20000000200ULL,
0x000000037c137819ULL, 0x000fe200000006ffULL, 0x000000080b297824ULL, 0x000fe200078e00ffULL,
0xfffffff812157812ULL, 0x000fe200078ee215ULL, 0x000000007878783bULL, 0x000ee20000000200ULL,
0xfffffff813147812ULL, 0x000fe200078ee214ULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0x0000002203137810ULL, 0x040fe20007ffe0ffULL, 0x000000003c3c783bULL, 0x000ea20000000200ULL,
0x0000003203127810ULL, 0x000fe20007ffe0ffULL, 0x0000001015387824ULL, 0x000fe200078e021bULL,
0xfffffff828137812ULL, 0x000fe200078ee213ULL, 0x0000001011117824ULL, 0x000fe200078e00ffULL,
0xfffffff829127812ULL, 0x000fe200078ee212ULL, 0x00000010145c7824ULL, 0x100fe200078e021bULL,
0x000000001054783bULL, 0x0003e20000000200ULL, 0x0000001013747824ULL, 0x000fc400078e021bULL,
0x0000001012287824ULL, 0x000fe200078e021bULL, 0x000000003838783bULL, 0x000ea20000000200ULL,
0x000000087c897824ULL, 0x000fe400078e00ffULL, 0x00000008848b7824ULL, 0x000fe200078e00ffULL,
0x000000001124783bULL, 0x0002a40000000200ULL, 0x000000041f107810ULL, 0x002fe20007ffe0ffULL,
0x000000080b887824ULL, 0x000fe200078e00ffULL, 0x000000005c5c783bULL, 0x000e680000000200ULL,
0x000000007474783bULL, 0x000e620000000200ULL, 0x0000000419117810ULL, 0x000fc60007ffe0ffULL,
0x000000002828783bULL, 0x000e620000000200ULL, 0x00000060642c723cULL, 0x080f7000000018ffULL,
0x000000606830723cULL, 0x000f7000000018ffULL, 0x000000626434723cULL, 0x080f7000000018ffULL,
0x000000626860723cULL, 0x000f7000000018ffULL, 0x0000000c6440723cULL, 0x044f7000000018ffULL,
0x0000000e6444723cULL, 0x040f7000000018ffULL, 0x000000786448723cULL, 0x048f7000000018ffULL,
0x0000007a644c723cULL, 0x040f7000000018ffULL, 0x0000003c6450723cULL, 0x040f7000000018ffULL,
0x0000003e6464723cULL, 0x000f7000000018ffULL, 0x0000000c6858723cULL, 0x040f7000000018ffULL,
0x0000000e680c723cULL, 0x000ff000000018ffULL, 0x00000038542c723cULL, 0x0a0ff0000000182cULL,
0x000000382430723cULL, 0x000ff00000001830ULL, 0x0000003a5434723cULL, 0x080ff00000001834ULL,
0x0000003a2438723cULL, 0x000ff00000001860ULL, 0x000000786860723cULL, 0x040f7000000018ffULL,
0x0000003c6880723cULL, 0x000ff000000018ffULL, 0x0000005c5440723cULL, 0x042ff00000001840ULL,
0x0000005e5444723cULL, 0x040ff00000001844ULL, 0x000000745448723cULL, 0x040ff00000001848ULL,
0x00000076544c723cULL, 0x040ff0000000184cULL, 0x000000285450723cULL, 0x000ff00000001850ULL,
0x0000007a6878723cULL, 0x040f7000000018ffULL, 0x0000003e683c723cULL, 0x000b6e00000018ffULL,
0x000000101c687824ULL, 0x020fe200078e00ffULL, 0x0000002a5454723cULL, 0x000bee0000001864ULL,
0x0000001020677824ULL, 0x060fe200078e00ffULL, 0x0000005c2458723cULL, 0x000b620000001858ULL,
0x0000000420657819ULL, 0x000fe200000006ffULL, 0x000000101c667824ULL, 0x000fc600078e00ffULL,
0xfffffff065647812ULL, 0x000fe400078ee210ULL, 0x000000061f5c7810ULL, 0x020fe20007ffe0ffULL,
0x000000742460723cULL, 0x040fe20000001860ULL, 0x00000006195d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001064647824ULL, 0x000fe200078e00ffULL, 0xfffffff067867812ULL, 0x000fe200078ee25cULL,
0x000000080b677824ULL, 0x000fe200078e00ffULL, 0xfffffff068877812ULL, 0x000fe400078ee25dULL,
0x0000001403107810ULL, 0x040fe20007ffe0ffULL, 0x0000005e245c723cULL, 0x040be2000000180cULL,
0xfffffff066657812ULL, 0x000fe200078ee211ULL, 0x0000000884667824ULL, 0x000fe200078e00ffULL,
0x0000000403117810ULL, 0x040fe20007ffe0ffULL, 0x0000001086867824ULL, 0x000fe200078e00ffULL,
0x0000002603847810ULL, 0x000fe20007ffe0ffULL, 0x00000010878c7824ULL, 0x000fe200078e00ffULL,
0x00000034030e7810ULL, 0x060fe20007ffe0ffULL, 0x000000087c0d7824ULL, 0x000fe200078e00ffULL,
0x00000024030f7810ULL, 0x000fe20007ffe0ffULL, 0x000000086c0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8670e7812ULL, 0x000fe200078ee20eULL, 0x00000010656c7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d107812ULL, 0x000fe200078ee210ULL, 0x000000762474723cULL, 0x040be20000001878ULL,
0xfffffff8660f7812ULL, 0x000fe200078ee20fULL, 0x000000100e7d7824ULL, 0x100fe200078e021bULL,
0x000000006464783bULL, 0x000fe20000000200ULL, 0x0000001010707824ULL, 0x100fe200078e021bULL,
0x00000006030d7810ULL, 0x000fe20007ffe0ffULL, 0x000000100f857824ULL, 0x000fe200078e021bULL,
0x000000006c6c783bULL, 0x000fe20000000200ULL, 0xfffffff80c117812ULL, 0x040fe200078ee211ULL,
0x000000282480723cULL, 0x000b620000001880ULL, 0xfffffff80c0d7812ULL, 0x000fe200078ee20dULL,
0x000000007070783bULL, 0x000e620000000200ULL, 0x00000016030c7810ULL, 0x000fc40007ffe0ffULL,
0x0000003603037810ULL, 0x000fe20007ffe0ffULL, 0x000000007d7c783bULL, 0x000ea20000000200ULL,
0xfffffff8890c7812ULL, 0x000fe200078ee20cULL, 0x0000002a243c723cULL, 0x000b62000000183cULL,
0x0000001b11687211ULL, 0x080fe200078e20ffULL, 0x000000008578783bULL, 0x020fe20000000200ULL,
0xfffffff888037812ULL, 0x000fe200078ee203ULL, 0x000000100c907824ULL, 0x100fe200078e021bULL,
0xfffffff88b0b7812ULL, 0x000fe200078ee284ULL, 0x000000008c8c783bULL, 0x000fe20000000200ULL,
0x0000001b0d887211ULL, 0x000fe200078e20ffULL, 0x0000001003287824ULL, 0x000fc400078e021bULL,
0x000000006868783bULL, 0x000ee20000000200ULL, 0x000000100b947824ULL, 0x000fc600078e021bULL,
0x000000008684783bULL, 0x000fe80000000200ULL, 0x000000009090783bULL, 0x000ee80000000200ULL,
0x000000002824783bULL, 0x000ee80000000200ULL, 0x000000008888783bULL, 0x000ee80000000200ULL,
0x000000009494783bULL, 0x000ee20000000200ULL, 0x000000706440723cULL, 0x082f700000001840ULL,
0x000000706c58723cULL, 0x000f700000001858ULL, 0x0000007c6450723cULL, 0x084f700000001850ULL,
0x0000007c6c80723cULL, 0x000f700000001880ULL, 0x00000068642c723cULL, 0x088f70000000182cULL,
0x000000686c30723cULL, 0x000f700000001830ULL, 0x0000006a6434723cULL, 0x080f700000001834ULL,
0x0000006a6c38723cULL, 0x000f700000001838ULL, 0x000000726444723cULL, 0x040f700000001844ULL,
0x000000786448723cULL, 0x040f700000001848ULL, 0x0000007a644c723cULL, 0x040f70000000184cULL,
0x0000007e6454723cULL, 0x000f700000001854ULL, 0x000000726c5c723cULL, 0x040f70000000185cULL,
0x000000786c60723cULL, 0x040f700000001860ULL, 0x0000007a6c74723cULL, 0x040f700000001874ULL,
0x0000007e6c3c723cULL, 0x000f70000000183cULL, 0x000000908440723cULL, 0x0a0f700000001840ULL,
0x000000908c58723cULL, 0x000b6e0000001858ULL, 0x0000030002917a10ULL, 0x020fe20007ffe0ffULL,
0x000000248450723cULL, 0x080f700000001850ULL, 0x000000248c80723cULL, 0x000b6e0000001880ULL,
0x0000000191257810ULL, 0x020fe20007ffe0ffULL, 0x0000009f09247224ULL, 0x010fe200078e02ffULL,
0x00000088842c723cULL, 0x000b64000000182cULL, 0x000000062500720cULL, 0x000fe20003f06070ULL,
0x0000620024247625ULL, 0x000fca00078e00a1ULL, 0x000000888c30723cULL, 0x000b700000001830ULL,
0x0000008a8434723cULL, 0x080b700000001834ULL, 0x0000008a8c38723cULL, 0x000b700000001838ULL,
0x000000928444723cULL, 0x040b700000001844ULL, 0x000000948448723cULL, 0x040b700000001848ULL,
0x00000096844c723cULL, 0x040b70000000184cULL, 0x000000268454723cULL, 0x000b700000001854ULL,
0x000000928c5c723cULL, 0x040b70000000185cULL, 0x000000948c60723cULL, 0x040b700000001860ULL,
0x000000968c74723cULL, 0x040b700000001874ULL, 0x000000268c3c723cULL, 0x000b62000000183cULL,
0x00000c5000008947ULL, 0x000fce0003800000ULL, 0x000000011e267824ULL, 0x060fe200078e029dULL,
0x0000000c1e647810ULL, 0x040fe20007ffe0ffULL, 0x0000010091277824ULL, 0x000fe200078e02a0ULL,
0x000000041e287810ULL, 0x000fc40007ffe0ffULL, 0x00000007217e7812ULL, 0x000fe200078ef826ULL,
0x0000000164657824ULL, 0x100fe200078e029dULL, 0x0000002704267217ULL, 0x000fe20007800000ULL,
0x00000008648a7824ULL, 0x000fe200078e00ffULL, 0x000000101e8c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000128297824ULL, 0x000fe200078e029dULL, 0x000000181e947810ULL, 0x000fe20007ffe0ffULL,
0x0000000828867824ULL, 0x000fe200078e00ffULL, 0xfffffff88a8a7812ULL, 0x000fe200078ee265ULL,
0x0000000126217824ULL, 0x000fe200078e0a27ULL, 0x000000081e2a7810ULL, 0x000fe20007ffe0ffULL,
0x000000018c267824ULL, 0x000fe200078e029dULL, 0xfffffff886867812ULL, 0x000fe200078ee229ULL,
0x000000088c657824ULL, 0x000fe200078e00ffULL, 0x0000009d94297210ULL, 0x0c0fe20007ffe0ffULL,
0x0000000894967824ULL, 0x000fe200078e00ffULL, 0x000000201ea87810ULL, 0x000fe20007ffe0ffULL,
0x000000082a887824ULL, 0x000fe200078e00ffULL, 0x000000141e907810ULL, 0x000fe20007ffe0ffULL,
0x00000001087c7824ULL, 0x000fe200078e028cULL, 0xfffffff8658e7812ULL, 0x000fe200078ee226ULL,
0x00000001a8267824ULL, 0x000fe200078e029dULL, 0xfffffff896967812ULL, 0x000fe200078ee229ULL,
0x00000008a8297824ULL, 0x000fe200078e00ffULL, 0x0000009d2a2b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000190277824ULL, 0x000fe200078e029dULL, 0x0000001c1ea47810ULL, 0x000fe20007ffe0ffULL,
0x0000000890927824ULL, 0x000fe200078e00ffULL, 0x000000341eb67810ULL, 0x000fe20007ffe0ffULL,
0x000001007c7c7825ULL, 0x000fe200078e00ffULL, 0x000000241eac7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff888887812ULL, 0x000fe200078ee22bULL, 0x00000001a42b7824ULL, 0x100fe200078e029dULL,
0x0000002c1eb27810ULL, 0x000fe20007ffe0ffULL, 0x00000008a4a67824ULL, 0x000fe200078e00ffULL,
0x000000281eb07810ULL, 0x000fe20007ffe0ffULL, 0x00000001b66a7824ULL, 0x040fe200078e029dULL,
0xfffffff829aa7812ULL, 0x000fe200078ee226ULL, 0x00000008b6297824ULL, 0x000fe200078e00ffULL,
0xfffffff892927812ULL, 0x000fe200078ee227ULL, 0x00000001ac277824ULL, 0x000fe200078e029dULL,
0x000000301eb47810ULL, 0x000fe20007ffe0ffULL, 0x00000008acae7824ULL, 0x000fe200078e00ffULL,
0xfffffff8a6a67812ULL, 0x000fe200078ee22bULL, 0x00000001b2707824ULL, 0x100fe200078e029dULL,
0x0000003c1e7a7810ULL, 0x000fe20007ffe0ffULL, 0x00000008b2657824ULL, 0x000fe200078e00ffULL,
0x00000003b02b7819ULL, 0x040fe200000006ffULL, 0x00000001b06e7824ULL, 0x100fe200078e029dULL,
0x000000381e787810ULL, 0x000fe20007ffe0ffULL, 0x00000001b4727824ULL, 0x000fe200078e029dULL,
0xfffffff8296a7812ULL, 0x000fe200078ee26aULL, 0x0000000108297824ULL, 0x000fe200078e0228ULL,
0xfffffff8aeae7812ULL, 0x000fe200078ee227ULL, 0x00000008b4277824ULL, 0x000fe200078e00ffULL,
0xfffffff865707812ULL, 0x000fe200078ee270ULL, 0x000000087a657824ULL, 0x000fe200078e00ffULL,
0xfffffff82b6e7812ULL, 0x000fe200078ee26eULL, 0x00000001786c7824ULL, 0x000fe200078e029dULL,
0x000000212800720cULL, 0x000fe20003fa6070ULL, 0x00000008782b7824ULL, 0x000fe200078e00ffULL,
0x0000009d7a687210ULL, 0x000fe20007ffe0ffULL, 0x0000000108267824ULL, 0x000fe200078e021eULL,
0x000000216400720cULL, 0x080fe20003f26070ULL, 0x0000010029287825ULL, 0x000fe200078e00ffULL,
0x000000212a00720cULL, 0x000fc40003f06070ULL, 0xfffffff827727812ULL, 0x000fe200078ee272ULL,
0x0000000108647824ULL, 0x040fe200078e0264ULL, 0xfffffff865687812ULL, 0x000fe200078ee268ULL,
0x00000001082a7824ULL, 0x000fe200078e022aULL, 0xfffffff82b6c7812ULL, 0x000fe200078ee26cULL,
0x0000010026267825ULL, 0x000fe200078e00ffULL, 0x0000002228677212ULL, 0x080fe400078efcffULL,
0x000000211e00720cULL, 0x000fe20003f86070ULL, 0x0000010064647825ULL, 0x000fe200078e00ffULL,
0x0000002226857212ULL, 0x000fc400078efcffULL, 0x0000006724667210ULL, 0x000fe20007f7e0ffULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x0000002264697212ULL, 0x080fe400078efcffULL,
0x0000008524847210ULL, 0x000fe20007f5e0ffULL, 0x0000000125677824ULL, 0x040fe200018e0629ULL,
0x000000222a6b7212ULL, 0x080fe200078efcffULL, 0x00000001082a7824ULL, 0x000fe200078e0290ULL,
0x0000006924287210ULL, 0x040fe20007fde0ffULL, 0x0000000125857824ULL, 0x040fe200010e0627ULL,
0x0000006b24267210ULL, 0x000fe20007f7e0ffULL, 0x00000010866b7824ULL, 0x000fe200078e021bULL,
0x000000227c697212ULL, 0x000fe200078efcffULL, 0x0000000125297824ULL, 0x040fe200030e0665ULL,
0x0000002b25277210ULL, 0x000fe20001ffe4ffULL, 0x000001002a2a7825ULL, 0x000fe200078e00ffULL,
0x0000006924647210ULL, 0x000fc40007fde0ffULL, 0x000000218c00720cULL, 0x080fe20003f46070ULL,
0x000000107e697824ULL, 0x000fe200078e021bULL, 0x000000222a877212ULL, 0x080fe200078efcffULL,
0x00000001087e7824ULL, 0x000fe200078e02a4ULL, 0x000000219000720cULL, 0x000fe20003f66070ULL,
0x0000000125657824ULL, 0x040fe200030e067dULL, 0x0000008724867210ULL, 0x000fe20007fde0ffULL,
0x000001007e7e7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000084697faeULL, 0x0003e6000e101c48ULL, 0x00000001087c7824ULL, 0x000fe200078e0294ULL,
0x00000000666b7faeULL, 0x0005e2000e901c48ULL, 0x000000227e6d7212ULL, 0x000fe200078efcffULL,
0x0000000125877824ULL, 0x000fe200030e062bULL, 0x000000219400720cULL, 0x000fe20003fa6070ULL,
0x000001007c7c7825ULL, 0x000fe200078e00ffULL, 0x0000006d242a7210ULL, 0x000fc60007fde0ffULL,
0x0000001088697824ULL, 0x102fe200078e021bULL, 0x000000227c6f7212ULL, 0x000fe200078efcffULL,
0x00000010926d7824ULL, 0x100fe400078e021bULL, 0x000000108a677824ULL, 0x104fe200078e021bULL,
0x0000000026697faeULL, 0x0003e2000c101c48ULL, 0x000000108e6b7824ULL, 0x000fe200078e021bULL,
0x0000006f247c7210ULL, 0x000fe20007f9e0ffULL, 0x00000001252b7824ULL, 0x040fe200030e067fULL,
0x0000000028677faeULL, 0x0005e2000c901c48ULL, 0x0000000108667824ULL, 0x000fe200078e02b2ULL,
0x0000007d257d7210ULL, 0x000fc400027fe4ffULL, 0x00000000646b7faeULL, 0x0007e2000d101c48ULL,
0x00000021a800720cULL, 0x080fe20003f46070ULL, 0x0000000108a87824ULL, 0x000fe200078e02a8ULL,
0x00000021a400720cULL, 0x080fe20003f86070ULL, 0x00000000866d7faeULL, 0x0009e2000d901c48ULL,
0x00000021ac00720cULL, 0x000fe20003f66070ULL, 0x0000000108ac7824ULL, 0x000fe200078e02acULL,
0x0000001b96697211ULL, 0x002fe200078e20ffULL, 0x00000100a8267825ULL, 0x000fe200078e00ffULL,
0x00000021b000720cULL, 0x080fe40003f06070ULL, 0x00000021b200720cULL, 0x000fe20003f26070ULL,
0x00000100ac287825ULL, 0x004fe200078e00ffULL, 0x00000022267f7212ULL, 0x080fe200078efcffULL,
0x000000007c697faeULL, 0x0003e4000e901c48ULL, 0x0000010066667825ULL, 0x000fe200078e00ffULL,
0x0000002228857212ULL, 0x000fc400078efcffULL, 0x0000007f247e7210ULL, 0x000fe20007fde0ffULL,
0x0000000108267824ULL, 0x000fe200078e02b4ULL, 0x0000008524847210ULL, 0x000fe20007fbe0ffULL,
0x0000000108b07824ULL, 0x000fe200078e02b0ULL, 0x00000022666b7212ULL, 0x008fe200078efcffULL,
0x00000001257f7824ULL, 0x000fe200030e0627ULL, 0x0000007808287210ULL, 0x000fe20007ffe0ffULL,
0x0000010026267825ULL, 0x000fc800078e00ffULL, 0x0000000125857824ULL, 0x000fe200028e0629ULL,
0x0000006b24667210ULL, 0x000fe20007fbe0ffULL, 0x00000100b0647825ULL, 0x000fe200078e00ffULL,
0x00000022267d7212ULL, 0x002fc600078efcffULL, 0x0000000125677824ULL, 0x040fe200028e0667ULL,
0x0000007d247c7210ULL, 0x000fe20007fbe0ffULL, 0x0000000108267824ULL, 0x000fe200078e02b6ULL,
0x00000022646d7212ULL, 0x010fe200078efcffULL, 0x00000010a6697824ULL, 0x000fe400078e021bULL,
0x00000001257d7824ULL, 0x000fe200028e0627ULL, 0x0000006d24647210ULL, 0x000fe20007fde0ffULL,
0x0000010026267825ULL, 0x000fe200078e00ffULL, 0x000000002a697faeULL, 0x0003e2000e101c48ULL,
0x00000021b600720cULL, 0x000fc40003f86070ULL, 0x0000010028287825ULL, 0x000fc800078e00ffULL,
0x00000010aa6b7824ULL, 0x100fe400078e021bULL, 0x00000010ae6d7824ULL, 0x000fe400078e021bULL,
0x0000000125657824ULL, 0x040fe200030e0665ULL, 0x00000022262b7212ULL, 0x082fe200078efcffULL,
0x00000001082a7824ULL, 0x000fe200078e027aULL, 0x0000002228697212ULL, 0x080fe200078efcffULL,
0x000000007e6b7faeULL, 0x0003e2000d101c48ULL, 0x0000002b24267210ULL, 0x000fe20007fbe0ffULL,
0x000001002a2a7825ULL, 0x000fe200078e00ffULL, 0x00000021b400720cULL, 0x000fe20003fc6070ULL,
0x00000000846d7faeULL, 0x0005e2000d901c48ULL, 0x0000006924287210ULL, 0x000fe20007f5e0ffULL,
0x0000000125277824ULL, 0x040fe200028e0627ULL, 0x000000217800720cULL, 0x080fe20003f66070ULL,
0x0000001070697824ULL, 0x000fe200078e021bULL, 0x000000222a6f7212ULL, 0x000fe200078efcffULL,
0x0000000125297824ULL, 0x000fe200010e0629ULL, 0x000000217a00720cULL, 0x000fe20003fa6070ULL,
0x000000106e217824ULL, 0x100fe200078e021bULL, 0x0000006f24247210ULL, 0x000fe20007f5e0ffULL,
0x000000106c6f7824ULL, 0x100fe200078e021bULL, 0x0000001b726b7211ULL, 0x002fe200078e20ffULL,
0x000000106a6d7824ULL, 0x104fe200078e021bULL, 0x0000000064217faeULL, 0x0003e2000c101c48ULL,
0x00000010681b7824ULL, 0x000fc400078e021bULL, 0x0000000125257824ULL, 0x000fe200010e062bULL,
0x0000000066697faeULL, 0x0003e8000c901c48ULL, 0x000000007c6b7faeULL, 0x0003e8000f101c48ULL,
0x00000000266d7faeULL, 0x0003e8000e101c48ULL, 0x00000000286f7faeULL, 0x0003e8000d901c48ULL,
0x00000000241b7faeULL, 0x0003e2000e901c48ULL, 0x00000b1000007947ULL, 0x000fea0003800000ULL,
0x000000041e297810ULL, 0x040fe20007ffe0ffULL, 0x000000011e267824ULL, 0x060fe200078e029dULL,
0x000000081e2b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000c1e657810ULL, 0x040fe20007ffe0ffULL,
0x0000000129277824ULL, 0x100fe200078e029dULL, 0x0000000721287812ULL, 0x000fe200078ef826ULL,
0x00000008292a7824ULL, 0x000fe200078e00ffULL, 0x000000032b647819ULL, 0x040fe200000006ffULL,
0x000000012b217824ULL, 0x100fe200078e029dULL, 0x000000101e677810ULL, 0x000fe20007ffe0ffULL,
0x0000000165267824ULL, 0x040fe200078e029dULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee227ULL,
0x0000000865277824ULL, 0x000fe200078e00ffULL, 0x000000141e697810ULL, 0x000fe20007ffe0ffULL,
0x0000000867687824ULL, 0x040fe200078e00ffULL, 0xfffffff864647812ULL, 0x000fe200078ee221ULL,
0x0000000167217824ULL, 0x100fe200078e029dULL, 0xfffffff827667812ULL, 0x000fe200078ee226ULL,
0x0000000169267824ULL, 0x040fe200078e029dULL, 0x000000181e6b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000869277824ULL, 0x000fe200078e00ffULL, 0x0000001c1e6e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001082b7824ULL, 0x000fe200078e022bULL, 0xfffffff868687812ULL, 0x000fe200078ee221ULL,
0x000000016b217824ULL, 0x000fe200078e029dULL, 0xfffffff8276a7812ULL, 0x000fe200078ee226ULL,
0x000000086b6c7824ULL, 0x000fe200078e00ffULL, 0x000000201e6f7810ULL, 0x000fe20007ffe0ffULL,
0x000000086e277824ULL, 0x040fe200078e00ffULL, 0x0000009d6e267210ULL, 0x000fe20007ffe0ffULL,
0x000000102a897824ULL, 0x000fe200078e021bULL, 0x000000241e717810ULL, 0x000fe20007ffe0ffULL,
0x000000086f727824ULL, 0x040fe200078e00ffULL, 0xfffffff86c6c7812ULL, 0x000fe200078ee221ULL,
0x000000016f217824ULL, 0x100fe200078e029dULL, 0xfffffff827707812ULL, 0x000fe200078ee226ULL,
0x0000000171267824ULL, 0x040fe200078e029dULL, 0x000000281e737810ULL, 0x040fe20007ffe0ffULL,
0x0000000871277824ULL, 0x000fe200078e00ffULL, 0x0000002c1e797810ULL, 0x000fe20007ffe0ffULL,
0x000001002b2a7825ULL, 0x000fe200078e00ffULL, 0xfffffff872727812ULL, 0x000fc400078ee221ULL,
0xfffffff827787812ULL, 0x000fe200078ee226ULL, 0x0000000173217824ULL, 0x140fe200078e029dULL,
0x000000301e7b7810ULL, 0x040fe20007ffe0ffULL, 0x00000008737a7824ULL, 0x000fe200078e00ffULL,
0x0000000379277819ULL, 0x040fe200000006ffULL, 0x0000000179267824ULL, 0x000fe200078e029dULL,
0x000000341e7d7810ULL, 0x000fe20007ffe0ffULL, 0x000000087b7e7824ULL, 0x040fe200078e00ffULL,
0xfffffff87a7a7812ULL, 0x000fe200078ee221ULL, 0x000000017b217824ULL, 0x100fe200078e029dULL,
0xfffffff8277c7812ULL, 0x000fe200078ee226ULL, 0x000000017d277824ULL, 0x040fe200078e029dULL,
0x000000381e7f7810ULL, 0x040fe20007ffe0ffULL, 0x000000087d847824ULL, 0x000fe200078e00ffULL,
0x0000003c1e857810ULL, 0x000fe20007ffe0ffULL, 0x0000000108267824ULL, 0x000fe200078e021eULL,
0xfffffff87e7e7812ULL, 0x000fe200078ee221ULL, 0x000000017f1e7824ULL, 0x040fe200078e029dULL,
0xfffffff884847812ULL, 0x000fe200078ee227ULL, 0x000000087f217824ULL, 0x000fe200078e00ffULL,
0x0000000385867819ULL, 0x040fe200000006ffULL, 0x00000001856d7824ULL, 0x000fe200078e029dULL,
0x0000001b70977211ULL, 0x000fe200078e20ffULL, 0x0000010026267825ULL, 0x000fe200078e00ffULL,
0xfffffff8211e7812ULL, 0x000fc400078ee21eULL, 0xfffffff886867812ULL, 0x000fe200078ee26dULL,
0x0000000108697824ULL, 0x000fe200078e0269ULL, 0x0000002226217212ULL, 0x000fe200078efcffULL,
0x0000001028877824ULL, 0x100fe400078e021bULL, 0x00000010648b7824ULL, 0x100fe200078e021bULL,
0x0000002124267210ULL, 0x000fe20007f1e0ffULL, 0x00000010668d7824ULL, 0x100fe400078e021bULL,
0x00000010688f7824ULL, 0x100fe200078e021bULL, 0x0000002725277210ULL, 0x000fe200007fe4ffULL,
0x000000106a937824ULL, 0x000fc400078e021bULL, 0x000000106c957824ULL, 0x100fe400078e021bULL,
0x0000001072a17824ULL, 0x100fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026877faeULL, 0x0003e2000b901c48ULL, 0x0000001078a37824ULL, 0x100fe400078e021bULL,
0x000000107aa57824ULL, 0x100fe400078e021bULL, 0x000000107ca77824ULL, 0x100fe400078e021bULL,
0x000000107ea97824ULL, 0x000fc400078e021bULL, 0x0000001084ab7824ULL, 0x100fe400078e021bULL,
0x000000101eaf7824ULL, 0x100fe400078e021bULL, 0x0000001086b37824ULL, 0x000fe200078e021bULL,
0x000000222a1b7212ULL, 0x000fe200078efcffULL, 0x0000000108677824ULL, 0x000fe400078e0267ULL,
0x0000010069687825ULL, 0x000fe200078e00ffULL, 0x0000001b242a7210ULL, 0x000fc60007f1e0ffULL,
0x00000001086b7824ULL, 0x000fe200078e026bULL, 0x00000022681b7212ULL, 0x000fe200078efcffULL,
0x0000010067667825ULL, 0x000fc800078e00ffULL, 0x000001006b6a7825ULL, 0x000fe200078e00ffULL,
0x00000022666d7212ULL, 0x000fc600078efcffULL, 0x00000001252b7824ULL, 0x040fe200000e062bULL,
0x0000001b24687210ULL, 0x000fe20007f1e0ffULL, 0x00000001086c7824ULL, 0x000fe200078e026eULL,
0x0000006d24667210ULL, 0x000fe20007f5e0ffULL, 0x0000000108737824ULL, 0x000fe200078e0273ULL,
0x000000226a1b7212ULL, 0x000fe200078efcffULL, 0x0000000108297824ULL, 0x000fe200078e0229ULL,
0x0000006725677210ULL, 0x000fe200017fe4ffULL, 0x000001006c6c7825ULL, 0x000fc800078e00ffULL,
0x0000000125697824ULL, 0x000fe200000e0669ULL, 0x0000001b246a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000108717824ULL, 0x000fe200078e0271ULL, 0x000000226c1b7212ULL, 0x000fe200078efcffULL,
0x0000010073727825ULL, 0x000fc800078e00ffULL, 0x0000010029287825ULL, 0x000fc800078e00ffULL,
0x0000000108657824ULL, 0x000fe200078e0265ULL, 0x0000002228217212ULL, 0x000fe200078efcffULL,
0x0000010071707825ULL, 0x000fc600078e00ffULL, 0x0000002124287210ULL, 0x000fe20007f3e0ffULL,
0x0000000108787824ULL, 0x000fe200078e0279ULL, 0x0000002272797212ULL, 0x080fe200078efcffULL,
0x00000001256b7824ULL, 0x000fe200000e066bULL, 0x0000001b246c7210ULL, 0x000fe20007f1e0ffULL,
0x0000010065647825ULL, 0x000fe200078e00ffULL, 0x00000022701b7212ULL, 0x080fe400078efcffULL,
0x0000007924727210ULL, 0x000fe20007f5e0ffULL, 0x00000001086f7824ULL, 0x000fe200078e026fULL,
0x0000002264217212ULL, 0x000fe200078efcffULL, 0x0000010078787825ULL, 0x000fc800078e00ffULL,
0x00000001256d7824ULL, 0x000fe200000e066dULL, 0x0000001b24707210ULL, 0x000fe20007f1e0ffULL,
0x00000001087b7824ULL, 0x000fe200078e027bULL, 0x00000022781b7212ULL, 0x000fe200078efcffULL,
0x000001006f6e7825ULL, 0x000fc800078e00ffULL, 0x00000001087d7824ULL, 0x040fe400078e027dULL,
0x00000001087f7824ULL, 0x000fe400078e027fULL, 0x0000000125297824ULL, 0x000fe200008e0629ULL,
0x0000002124647210ULL, 0x000fe20007f3e0ffULL, 0x0000000108857824ULL, 0x000fe200078e0285ULL,
0x000000226e217212ULL, 0x080fe200078efcffULL, 0x000001007b7a7825ULL, 0x000fe200078e00ffULL,
0x0000000028897faeULL, 0x0003e6000b901c48ULL, 0x0000000125717824ULL, 0x000fe200000e0671ULL,
0x0000001b24787210ULL, 0x000fe20007f1e0ffULL, 0x000001007d7c7825ULL, 0x000fe200078e00ffULL,
0x000000227a1b7212ULL, 0x000fe200078efcffULL, 0x000000002a8b7faeULL, 0x0003e4000b901c48ULL,
0x000001007f7e7825ULL, 0x000fc800078e00ffULL, 0x0000010085847825ULL, 0x000fe200078e00ffULL,
0x000000227ead7212ULL, 0x000fc600078efcffULL, 0x0000000125657824ULL, 0x040fe200008e0665ULL,
0x00000021246e7210ULL, 0x000fe20007f3e0ffULL, 0x0000000125797824ULL, 0x040fe200000e0679ULL,
0x000000227c217212ULL, 0x080fe200078efcffULL, 0x0000000125737824ULL, 0x040fe200010e0673ULL,
0x0000002284b17212ULL, 0x000fe200078efcffULL, 0x00000000648d7faeULL, 0x0003e2000b901c48ULL,
0x0000001b247a7210ULL, 0x040fe40007f1e0ffULL, 0x0000006f256f7210ULL, 0x040fe20000ffe4ffULL,
0x00000000668f7faeULL, 0x0003e2000b901c48ULL, 0x00000021247c7210ULL, 0x040fe20007f3e0ffULL,
0x00000001257b7824ULL, 0x000fe200000e067bULL, 0x000000ad247e7210ULL, 0x040fe20007f5e0ffULL,
0x0000000068937faeULL, 0x0003e2000b901c48ULL, 0x000000b124247210ULL, 0x000fc40007f7e0ffULL,
0x0000007d257d7210ULL, 0x040fe20000ffe4ffULL, 0x000000006a957faeULL, 0x0003e2000b901c48ULL,
0x00000001257f7824ULL, 0x040fe400010e067fULL, 0x0000000125257824ULL, 0x000fe200018e0685ULL,
0x000000006c977faeULL, 0x0003e8000b901c48ULL, 0x000000006ea17faeULL, 0x0003e8000b901c48ULL,
0x0000000070a37faeULL, 0x0003e8000b901c48ULL, 0x0000000072a57faeULL, 0x0003e8000b901c48ULL,
0x0000000078a77faeULL, 0x0003e8000b901c48ULL, 0x000000007aa97faeULL, 0x0003e8000b901c48ULL,
0x000000007cab7faeULL, 0x0003e8000b901c48ULL, 0x000000007eaf7faeULL, 0x0003e8000b901c48ULL,
0x0000000024b37faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001020227824ULL, 0x000fe200078e00ffULL, 0x000000081f1b7810ULL, 0x002fe20007ffe0ffULL,
0x000000101c217824ULL, 0x000fe200078e00ffULL, 0x00000008191e7810ULL, 0x000fc40007ffe0ffULL,
0x000040001d1d7810ULL, 0x000fe40007ffe0ffULL, 0xfffffff0221b7812ULL, 0x000fe400078ee21bULL,
0xfffffff0211e7812ULL, 0x000fe200078ee21eULL, 0x000000101a247824ULL, 0x100fe200078e021dULL,
0x0000001d16687211ULL, 0x000fe200078e20ffULL, 0x000000101b1b7824ULL, 0x000fe200078e00ffULL,
0x0000000a1f167810ULL, 0x000fe20007ffe0ffULL, 0x000000101e1e7824ULL, 0x000fe400078e00ffULL,
0x00000010176c7824ULL, 0x000fc400078e021dULL, 0x0000001020177824ULL, 0x000fe400078e00ffULL,
0x0000001018707824ULL, 0x000fe400078e021dULL, 0x000000101c187824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000002424783bULL, 0x000fe20000000200ULL,
0xfffffff017167812ULL, 0x000fe200078ee216ULL, 0x0000001015157824ULL, 0x100fe200078e021dULL,
0x0000000a19177810ULL, 0x000fe20007ffe0ffULL, 0x000000001b28783bULL, 0x000e620000000200ULL,
0x00000010147c7824ULL, 0x000fe400078e021dULL, 0xfffffff018187812ULL, 0x000fe200078ee217ULL,
0x000000001e64783bULL, 0x000ea20000000200ULL, 0x0000001016787824ULL, 0x000fe400078e00ffULL,
0x0000000418187819ULL, 0x000fe200000006ffULL, 0x000000001514783bULL, 0x000fe20000000200ULL,
0x0000001013887824ULL, 0x000fc400078e021dULL, 0x00000010128c7824ULL, 0x100fe200078e021dULL,
0x000000007878783bULL, 0x000ee20000000200ULL, 0x0000001020137824ULL, 0x000fe200078e00ffULL,
0x0000000c1f127810ULL, 0x000fe20007ffe0ffULL, 0x0000001010107824ULL, 0x100fe200078e021dULL,
0x000000001884783bULL, 0x0008e20000000200ULL, 0x0000001020207824ULL, 0x000fe200078e00ffULL,
0xfffffff013127812ULL, 0x000fe200078ee212ULL, 0x000000100c0c7824ULL, 0x100fe200078e021dULL,
0x000000007070783bULL, 0x000ee20000000200ULL, 0x0000000e1f1f7810ULL, 0x000fe20007ffe0ffULL,
0x0000001003037824ULL, 0x000fc400078e021dULL, 0x000000006c6c783bULL, 0x000ee20000000200ULL,
0x000000101c187824ULL, 0x010fe200078e00ffULL, 0xfffffff0201f7812ULL, 0x000fe200078ee21fULL,
0x000000101c1c7824ULL, 0x000fe200078e00ffULL, 0x000000006868783bULL, 0x000f260000000200ULL,
0x000000101f1f7824ULL, 0x000fe200078e00ffULL, 0x000000007c7c783bULL, 0x000ee80000000200ULL,
0x000000008888783bULL, 0x000f220000000200ULL, 0x00000024282c723cULL, 0x082f66000000182cULL,
0x000000008c8c783bULL, 0x000e6a0000000200ULL, 0x000000246430723cULL, 0x004b6e0000001830ULL,
0x0000001011247824ULL, 0x020fe200078e021dULL, 0x000000262834723cULL, 0x000f620000001834ULL,
0x0000000c19117810ULL, 0x000fc40007ffe0ffULL, 0x0000000e19197810ULL, 0x000fe40007ffe0ffULL,
0xfffffff018187812ULL, 0x000fe400078ee211ULL, 0xfffffff01c197812ULL, 0x000fe200078ee219ULL,
0x000000266438723cULL, 0x000b620000001838ULL, 0x0000000418187819ULL, 0x000fe200000006ffULL,
0x000000002424783bULL, 0x020fe40000000200ULL, 0x00000010191c7824ULL, 0x000fc800078e00ffULL,
0x00000014782c723cULL, 0x088ff0000000182cULL, 0x000000148430723cULL, 0x000bee0000001830ULL,
0x0000001012147824ULL, 0x020fe200078e00ffULL, 0x000000167834723cULL, 0x080fe20000001834ULL,
0x000000001010783bULL, 0x000fee0000000200ULL, 0x000000168438723cULL, 0x000be40000001838ULL,
0x000000001414783bULL, 0x020eac0000000200ULL, 0x000000702840723cULL, 0x040f700000001840ULL,
0x000000722844723cULL, 0x040f700000001844ULL, 0x0000006c2848723cULL, 0x040f700000001848ULL,
0x0000006e284c723cULL, 0x040f70000000184cULL, 0x000000682850723cULL, 0x050f700000001850ULL,
0x0000006a2854723cULL, 0x000b6e0000001854ULL, 0x000000100f287824ULL, 0x120fe200078e021dULL,
0x000000706458723cULL, 0x040f6a0000001858ULL, 0x000000002828783bULL, 0x000ee60000000200ULL,
0x0000006c6460723cULL, 0x040b6e0000001860ULL, 0x000000100d6c7824ULL, 0x120fe200078e021dULL,
0x000000686480723cULL, 0x040bee0000001880ULL, 0x000000100e687824ULL, 0x120fe200078e021dULL,
0x00000072645c723cULL, 0x040b62000000185cULL, 0x000000000c0c783bULL, 0x000fe80000000200ULL,
0x000000001f70783bULL, 0x020fe60000000200ULL, 0x0000006e6474723cULL, 0x040b640000001874ULL,
0x000000006c6c783bULL, 0x020fec0000000200ULL, 0x0000006a643c723cULL, 0x000b64000000183cULL,
0x000000006868783bULL, 0x020f280000000200ULL, 0x000000001864783bULL, 0x0002a40000000200ULL,
0x0000007c7840723cULL, 0x000f620000001840ULL, 0x000000100b187824ULL, 0x002fce00078e021dULL,
0x0000007e7844723cULL, 0x040f620000001844ULL, 0x000000001c1c783bULL, 0x000fe80000000200ULL,
0x000000001818783bULL, 0x000e660000000200ULL, 0x000000887848723cULL, 0x040f700000001848ULL,
0x0000008a784c723cULL, 0x040f70000000184cULL, 0x0000008c7850723cULL, 0x040f700000001850ULL,
0x0000008e7854723cULL, 0x000f700000001854ULL, 0x0000007c8458723cULL, 0x040f700000001858ULL,
0x000000888460723cULL, 0x040f700000001860ULL, 0x0000007e845c723cULL, 0x040f70000000185cULL,
0x0000008a8474723cULL, 0x040f700000001874ULL, 0x0000008c8480723cULL, 0x040f700000001880ULL,
0x0000008e843c723cULL, 0x000f70000000183cULL, 0x000000241478723cULL, 0x044b64000000182cULL,
0x00000000032c783bULL, 0x020eac0000000200ULL, 0x000000261434723cULL, 0x040f700000001834ULL,
0x000000101440723cULL, 0x040f700000001840ULL, 0x000000121444723cULL, 0x040f700000001844ULL,
0x000000281448723cULL, 0x048ff00000001848ULL, 0x0000002a144c723cULL, 0x040ff0000000184cULL,
0x000000681450723cULL, 0x050ff00000001850ULL, 0x0000006a1454723cULL, 0x000ff00000001854ULL,
0x000000246430723cULL, 0x040ff00000001830ULL, 0x000000266438723cULL, 0x040ff00000001838ULL,
0x000000106458723cULL, 0x040ff00000001858ULL, 0x000000286414723cULL, 0x040ff00000001860ULL,
0x00000012645c723cULL, 0x040ff0000000185cULL, 0x0000002a6474723cULL, 0x040ff00000001874ULL,
0x000000686424723cULL, 0x040ff00000001880ULL, 0x0000006a643c723cULL, 0x000ff0000000183cULL,
0x0000006c7078723cULL, 0x040f700000001878ULL, 0x0000006e7034723cULL, 0x060f700000001834ULL,
0x0000000c7040723cULL, 0x040f700000001840ULL, 0x0000000e7044723cULL, 0x000f620000001844ULL,
0x3db504f3780b7820ULL, 0x000fc40000410000ULL, 0x3db504f379797820ULL, 0x000fe40000410000ULL,
0x3db504f37a7a7820ULL, 0x000fe40000410000ULL, 0x3db504f37b207820ULL, 0x000fe20000410000ULL,
0x000000187048723cULL, 0x002f640000001848ULL, 0x3db504f336217820ULL, 0x020fe40000410000ULL,
0x3db504f334347820ULL, 0x000fe40000410000ULL, 0x3db504f335357820ULL, 0x000fc40000410000ULL,
0x3db504f337377820ULL, 0x000fe20000410000ULL, 0x0000001a704c723cULL, 0x040f62000000184cULL,
0x3db504f340407820ULL, 0x000fe40000410000ULL, 0x3db504f341417820ULL, 0x000fe40000410000ULL,
0x3db504f342427820ULL, 0x000fe40000410000ULL, 0x3db504f343437820ULL, 0x000fe20000410000ULL,
0x0000002e7054723cULL, 0x004f620000001854ULL, 0x3db504f347287820ULL, 0x000fc40000410000ULL,
0x3db504f344447820ULL, 0x000fe40000410000ULL, 0x3db504f345457820ULL, 0x000fe40000410000ULL,
0x3db504f346467820ULL, 0x000fe20000410000ULL, 0x0000006c1c30723cULL, 0x000f620000001830ULL,
0x3db504f34b2a7820ULL, 0x000fe40000410000ULL, 0x3db504f34a297820ULL, 0x000fe40000410000ULL,
0x3db504f348487820ULL, 0x000fc40000410000ULL, 0x3db504f349497820ULL, 0x000fe20000410000ULL,
0x0000000c1c10723cULL, 0x040f640000001858ULL, 0x3db504f34e2b7820ULL, 0x020fe40000410000ULL,
0x3db504f34c4c7820ULL, 0x000fe40000410000ULL, 0x3db504f34d4d7820ULL, 0x000fe40000410000ULL,
0x000000181c14723cULL, 0x000f620000001814ULL, 0x3db504f354547820ULL, 0x000fc40000410000ULL,
0x3db504f355557820ULL, 0x000fe40000410000ULL, 0x3db504f357577820ULL, 0x000fc60000410000ULL,
0x0000006e1c6c723cULL, 0x000b620000001838ULL, 0x3db504f333477820ULL, 0x000fe40000410000ULL,
0x3db504f330037820ULL, 0x000fe40000410000ULL, 0x3db504f331227820ULL, 0x000fc60000410000ULL,
0x0000000e1c0c723cULL, 0x000f62000000185cULL, 0x3db504f310367820ULL, 0x000fe40000410000ULL,
0x3db504f311387820ULL, 0x020fe40000410000ULL, 0x3db504f3124e7820ULL, 0x000fc60000410000ULL,
0x0000001a1c18723cULL, 0x040f620000001874ULL, 0x3db504f314397820ULL, 0x000fe40000410000ULL,
0x3db504f3153a7820ULL, 0x000fe40000410000ULL, 0x3db504f316587820ULL, 0x000fe40000410000ULL,
0x3db504f317597820ULL, 0x000fe20000410000ULL, 0x0000002c1c24723cULL, 0x000fe20000001824ULL,
0x3db504f36c337820ULL, 0x000fe40000410000ULL, 0x3db504f36d6d7820ULL, 0x000fc40000410000ULL,
0x3db504f36e4a7820ULL, 0x000fe40000410000ULL, 0x3db504f36f6f7820ULL, 0x000fe20000410000ULL,
0x0000002c7050723cULL, 0x000b620000001850ULL, 0x3db504f30e4b7820ULL, 0x000fe40000410000ULL,
0x3db504f30c0c7820ULL, 0x000fe40000410000ULL, 0x3db504f30d0d7820ULL, 0x000fe40000410000ULL,
0x3db504f34f2c7820ULL, 0x020fe20000410000ULL, 0x0000002e1c1c723cULL, 0x000b62000000183cULL,
0x3db504f3134f7820ULL, 0x000fc40000410000ULL, 0x3db504f3183b7820ULL, 0x000fe40000410000ULL,
0x3db504f31a5a7820ULL, 0x000fe40000410000ULL, 0x3db504f3562f7820ULL, 0x020fe40000410000ULL,
0x3db504f30f567820ULL, 0x000fe40000410000ULL, 0x3db504f3323f7820ULL, 0x000fe40000410000ULL,
0x3db504f3193d7820ULL, 0x000fc40000410000ULL, 0x3db504f31b5b7820ULL, 0x000fe40000410000ULL,
0x3db504f350507820ULL, 0x000fe40000410000ULL, 0x3db504f351517820ULL, 0x000fe40000410000ULL,
0x3db504f3522d7820ULL, 0x000fe40000410000ULL, 0x3db504f3532e7820ULL, 0x000fe40000410000ULL,
0x3db504f3240e7820ULL, 0x000fc40000410000ULL, 0x3db504f3250f7820ULL, 0x000fe40000410000ULL,
0x3db504f3265c7820ULL, 0x000fe40000410000ULL, 0x3db504f3275d7820ULL, 0x000fe40000410000ULL,
0x3db504f31c3c7820ULL, 0x000fe40000410000ULL, 0x3db504f31d3e7820ULL, 0x000fe40000410000ULL,
0x3db504f31e5e7820ULL, 0x000fc40000410000ULL, 0x3db504f31f5f7820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000009c527f8cULL, 0x0002a2000c80043fULL,
0x000000ffff127224ULL, 0x000fe200078e0035ULL, 0x0000004600277202ULL, 0x000fe20000000f00ULL,
0x000000ffff167224ULL, 0x000fe200078e0045ULL, 0x0000003400117202ULL, 0x000fe20000000f00ULL,
0x000000ffff1c7224ULL, 0x000fe200078e0049ULL, 0x0000004d001d7202ULL, 0x000fe20000000f00ULL,
0x000000ffff1e7224ULL, 0x000fe400078e0050ULL, 0x000000ffff267224ULL, 0x000fc400078e0043ULL,
0x000000ffff357224ULL, 0x000fe400078e0036ULL, 0x000000ffff137224ULL, 0x000fe200078e0040ULL,
0x0000000e00407202ULL, 0x000fe20000000f00ULL, 0x000000ffff147224ULL, 0x000fe400078e0041ULL,
0x000000ffff157224ULL, 0x000fe400078e0044ULL, 0x000000ffff177224ULL, 0x000fe400078e0048ULL,
0x000000ffff1f7224ULL, 0x000fc400078e004cULL, 0x000000ffff247224ULL, 0x000fe400078e0037ULL,
0x000000ffff257224ULL, 0x000fe400078e0042ULL, 0x000000ffff367224ULL, 0x000fe400078e0038ULL,
0x000000ffff437224ULL, 0x000fe400078e003cULL, 0x000000ffff457224ULL, 0x000fe400078e003eULL,
0x000000ffff467224ULL, 0x000fc400078e003fULL, 0x000000ffff497224ULL, 0x000fe400078e0047ULL,
0x000000ffff507224ULL, 0x000fe200078e004bULL, 0x00000058004b7202ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fe400078e0079ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0051ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0054ULL, 0x000000ffff197224ULL, 0x000fc400078e0055ULL,
0x000000ffff187224ULL, 0x000fe400078e007aULL, 0x000000ffff307224ULL, 0x000fe400078e0057ULL,
0x000000ffff317224ULL, 0x000fe400078e0003ULL, 0x000000ffff327224ULL, 0x000fe400078e0022ULL,
0x000000ffff347224ULL, 0x000fe400078e006dULL, 0x000000ffff377224ULL, 0x000fc400078e000cULL,
0x000000ffff387224ULL, 0x000fe400078e000dULL, 0x000000ffff417224ULL, 0x000fe400078e000fULL,
0x000000ffff4c7224ULL, 0x000fe400078e006fULL, 0x000000ffff4d7224ULL, 0x000fe400078e0056ULL,
0x000000ffff3c7224ULL, 0x000fe400078e0059ULL, 0x000000ffff3e7224ULL, 0x000fc400078e005aULL,
0x000000ffff3f7224ULL, 0x000fe400078e005bULL, 0x000000ffff427224ULL, 0x000fe400078e005cULL,
0x000000ffff447224ULL, 0x000fe400078e005dULL, 0x000000ffff477224ULL, 0x000fe400078e005eULL,
0x000000ffff487224ULL, 0x000fc400078e005fULL, 0x00000000000c7805ULL, 0x006fca0000015200ULL,
0x000004009c037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fc40007804853ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff227224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c0e7210ULL, 0x000fc80007f1e1ffULL,
0x0000000f0d0f7210ULL, 0x000fe400007fe5ffULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc8000001140fULL,
0x0000000e03037211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e060fULL,
0x0000000203037819ULL, 0x000fc8000000120eULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000122227810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004009c037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804853ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000049d227824ULL, 0x000fe200078e00ffULL, 0x000000990200720cULL, 0x000fc80003f06070ULL,
0xfffffff022037812ULL, 0x000fca00078ec0ffULL, 0x0000008000037824ULL, 0x000fca00078e0203ULL,
0x01e40000030c7984ULL, 0x0002a20000000c00ULL, 0x00001f5000008947ULL, 0x000fea0003800000ULL,
0x000000029d027824ULL, 0x040fe200078e00ffULL, 0x0000002304527217ULL, 0x000fe20007800000ULL,
0x00000002ff6f7424ULL, 0x000fe200078e00ffULL, 0x000000079d517211ULL, 0x000fe400078ff0ffULL,
0x0000000602027812ULL, 0x000fe200078ec0ffULL, 0x0000000152237824ULL, 0x000fe200078e0a23ULL,
0x0000000851527810ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff547a19ULL, 0x000fe20000011651ULL,
0x000000019a567824ULL, 0x000fe200078e0202ULL, 0x00005a00ff587a19ULL, 0x000fc40000011652ULL,
0x0000580002527a10ULL, 0x000fe40007ffe0ffULL, 0x000000235600720cULL, 0x040fe20003f26070ULL,
0x0000000156567824ULL, 0x000fe200078e0a23ULL, 0x0000001051557810ULL, 0x040fe40007ffe0ffULL,
0x0000001851577810ULL, 0x000fe40007ffe0ffULL, 0x000000549b517217ULL, 0x040fe40003800000ULL,
0x000000569b567217ULL, 0x000fc40003800000ULL, 0x0000005223547210ULL, 0x000fe20007ffe1ffULL,
0x00000051987a7224ULL, 0x000fe200078e02ffULL, 0x00000004ff567819ULL, 0x000fe40000011656ULL,
0x000000235200720cULL, 0x000fe40003f06070ULL, 0x000000549b547217ULL, 0x000fe40003800000ULL,
0x000000ff565b7207ULL, 0x000fe40000800000ULL, 0x000000ff54697207ULL, 0x000fc40000000000ULL,
0x00005a00ff5a7a19ULL, 0x000fe20000011655ULL, 0x000000017a547824ULL, 0x000fe200078e025bULL,
0x0000007a69567211ULL, 0x000fe400078fe0ffULL, 0x000000589b537217ULL, 0x040fe20003800000ULL,
0x0000600054547625ULL, 0x080fe200078e006fULL, 0x0000005a9b517217ULL, 0x040fe40003800000ULL,
0x00005a00ff5c7a19ULL, 0x000fe20000011657ULL, 0x0000600056567625ULL, 0x000fe200078e006fULL,
0x0000001002647812ULL, 0x000fe200078efcffULL, 0x0000000854547981ULL, 0x000724000c1e9500ULL,
0x0000005398807224ULL, 0x040fe200078e02ffULL, 0x0000005c9b537217ULL, 0x000fe20003800000ULL,
0x0000005198827224ULL, 0x000fc400078e02ffULL, 0x0000000856517981ULL, 0x000322000c1e9500ULL,
0x0000008069587211ULL, 0x040fe200078fe0ffULL, 0x000000019a687824ULL, 0x000fe200078e0264ULL,
0x00000082695a7211ULL, 0x000fe200078fe0ffULL, 0x0000005398847224ULL, 0x000fe400078e02ffULL,
0x000000015b607824ULL, 0x040fe400078e0280ULL, 0x000000015b627824ULL, 0x000fe400078e0282ULL,
0x00000001686a7824ULL, 0x000fc400078e0a23ULL, 0x0000600058587625ULL, 0x000fe200078e006fULL,
0x0000580064667a10ULL, 0x000fc60007ffe0ffULL, 0x000000015b5e7824ULL, 0x000fe400078e0284ULL,
0x0000600060607625ULL, 0x000fc800078e006fULL, 0x0000600062627625ULL, 0x080fe200078e006fULL,
0x0000006a9b6a7217ULL, 0x000fe20003800000ULL, 0x0000000858537981ULL, 0x000524000c1e9500ULL,
0x000060005a5a7625ULL, 0x000fe400078e006fULL, 0x0000000860607981ULL, 0x000322000c1e9500ULL,
0x000000236800720cULL, 0x000fc60003f26070ULL, 0x000000085a557981ULL, 0x008722000c1e9500ULL,
0x000060005e587625ULL, 0x004fc600078e006fULL, 0x0000000862627981ULL, 0x000522000c1e9500ULL,
0x00000004ff6a7819ULL, 0x000fe2000001166aULL, 0x00000001665e7824ULL, 0x040fe200078e0a23ULL,
0x00000084695c7211ULL, 0x000fe200078fe0ffULL, 0x0000000858577981ULL, 0x002322000c1e9500ULL,
0x000000236600720cULL, 0x000fe40003f06070ULL, 0x0000005e9b5e7217ULL, 0x000fe40003800000ULL,
0x000000ff6a5f7207ULL, 0x000fe20000800000ULL, 0x000060005c5c7625ULL, 0x000fe200078e006fULL,
0x000000ff5e757207ULL, 0x000fc60000000000ULL, 0x000000017a5a7824ULL, 0x008fe200078e025fULL,
0x000000085c567981ULL, 0x000722000c1e9500ULL, 0x0000007a75587211ULL, 0x002fe400078fe0ffULL,
0x000060005a5a7625ULL, 0x000fe200078e006fULL, 0x000000805f5e7210ULL, 0x080fe40007ffe0ffULL,
0x0000002002727812ULL, 0x000fe400078efcffULL, 0x00000080755c7211ULL, 0x008fe200078fe0ffULL,
0x000000085a687981ULL, 0x0002e2000c1e9500ULL, 0x000000015f707824ULL, 0x000fc400078e0282ULL,
0x000000015f767824ULL, 0x000fe400078e0284ULL, 0x000060005c5c7625ULL, 0x000fe200078e006fULL,
0x0000580072747a10ULL, 0x000fc60007ffe0ffULL, 0x0000600058587625ULL, 0x080fe200078e006fULL,
0x000000085c637981ULL, 0x0044e6000c1e9500ULL, 0x000060005e5e7625ULL, 0x000fe200078e006fULL,
0x0000000858617981ULL, 0x0004e6000c1e9500ULL, 0x000000019a5a7824ULL, 0x002fe200078e0272ULL,
0x000000085e6e7981ULL, 0x0002e6000c1e9500ULL, 0x000000015a5c7824ULL, 0x004fe200078e0a23ULL,
0x00000082756a7211ULL, 0x000fc400078fe0ffULL, 0x00000084756c7211ULL, 0x000fe200078fe0ffULL,
0x0000000174587824ULL, 0x000fe200078e0a23ULL, 0x0000005c9b5c7217ULL, 0x040fe20003800000ULL,
0x0000600070707625ULL, 0x000fe200078e006fULL, 0x000000237400720cULL, 0x000fe40003f06070ULL,
0x000000589b587217ULL, 0x000fe20003800000ULL, 0x0000600076767625ULL, 0x000fe200078e006fULL,
0x000000235a00720cULL, 0x000fe20003f26070ULL, 0x0000000870707981ULL, 0x0004e2000c1e9500ULL,
0x00000004ff5c7819ULL, 0x000fe2000001165cULL, 0x000060006a6a7625ULL, 0x000fc800078e006fULL,
0x000060006c6c7625ULL, 0x000fe200078e006fULL, 0x000000ff587b7207ULL, 0x000fe20000000000ULL,
0x000000086a657981ULL, 0x0002e2000c1e9500ULL, 0x000000ff5c597207ULL, 0x000fc60000800000ULL,
0x000000086c677981ULL, 0x0004e8000c1e9500ULL, 0x0000000876767981ULL, 0x0004e2000c1e9500ULL,
0x00000001596a7824ULL, 0x002fe200078e0280ULL, 0x000000807b6c7211ULL, 0x004fc600078fe0ffULL,
0x000060006a6a7625ULL, 0x000fe200078e006fULL, 0x0000007a7b5a7211ULL, 0x000fc600078fe0ffULL,
0x000060006c6c7625ULL, 0x080fe200078e006fULL, 0x000000086ad07981ULL, 0x0002a2000c1e9500ULL,
0x00000084597c7210ULL, 0x000fe40007ffe0ffULL, 0x000060005a5a7625ULL, 0x080fe200078e006fULL,
0x000000086c737981ULL, 0x0002a2000c1e9500ULL, 0x000000827b5e7211ULL, 0x040fe400078fe0ffULL,
0x000000017a787824ULL, 0x000fe200078e0259ULL, 0x000000847b587211ULL, 0x000fe200078fe0ffULL,
0x00000001595c7824ULL, 0x000fe200078e0282ULL, 0x0000003002b67812ULL, 0x000fe200078efcffULL,
0x000000085a717981ULL, 0x0002a2000c1e9500ULL, 0x0000600078787625ULL, 0x000fc800078e006fULL,
0x000060005e5e7625ULL, 0x080fe200078e006fULL, 0x00005800b6b87a10ULL, 0x000fe20007ffe0ffULL,
0x0000000878787981ULL, 0x0002a4000c1e9500ULL, 0x0000600058587625ULL, 0x080fe400078e006fULL,
0x000000085e777981ULL, 0x0002a4000c1e9500ULL, 0x000060007c5a7625ULL, 0x082fe400078e006fULL,
0x0000000858d87981ULL, 0x0002a4000c1e9500ULL, 0x000060005c5c7625ULL, 0x000fc400078e006fULL,
0x000000085a857981ULL, 0x0002a4000c1e9500ULL, 0x000000019a7c7824ULL, 0x000fe400078e02b6ULL,
0x000000085cd47981ULL, 0x0002a4000c1e9500ULL, 0x000000017c7e7824ULL, 0x100fe400078e0a23ULL,
0x00000001b86c7824ULL, 0x000fc600078e0a23ULL, 0x0000007e9b7e7217ULL, 0x040fe40003800000ULL,
0x000000237c00720cULL, 0x080fe40003f26070ULL, 0x00000023b800720cULL, 0x000fe40003f06070ULL,
0x0000006c9b6c7217ULL, 0x000fe40003800000ULL, 0x00000004ff7e7819ULL, 0x000fe4000001167eULL,
0x000000ff6c797207ULL, 0x000fc40000000000ULL, 0x000000ff7e7d7207ULL, 0x000fe40000800000ULL,
0x0000007a796a7211ULL, 0x040fe400078fe0ffULL, 0x00000082795a7211ULL, 0x002fe200078fe0ffULL,
0x000000017a6c7824ULL, 0x000fe400078e027dULL, 0x000000017d5e7824ULL, 0x000fe400078e0282ULL,
0x000060006a6a7625ULL, 0x000fc800078e006fULL, 0x000060006c6c7625ULL, 0x080fe200078e006fULL,
0x000000086aba7981ULL, 0x0002a6000c1e9500ULL, 0x000060005a5a7625ULL, 0x080fe200078e006fULL,
0x000000086c7f7981ULL, 0x0002a6000c1e9500ULL, 0x000060005e5e7625ULL, 0x000fe200078e006fULL,
0x000000085ad67981ULL, 0x0002a2000c1e9500ULL, 0x0000008079587211ULL, 0x000fc600078fe0ffULL,
0x000000085e837981ULL, 0x0002a2000c1e9500ULL, 0x000000017d5c7824ULL, 0x000fe400078e0280ULL,
0x0000600058587625ULL, 0x000fc800078e006fULL, 0x000060005c5c7625ULL, 0x080fe200078e006fULL,
0x0000000858d27981ULL, 0x0002a4000c1e9500ULL, 0x00000084796a7211ULL, 0x002fe400078fe0ffULL,
0x000000085c817981ULL, 0x0002a2000c1e9500ULL, 0x000000017d6c7824ULL, 0x000fe400078e0284ULL,
0x000060006a6a7625ULL, 0x000fc800078e006fULL, 0x000060006c6c7625ULL, 0x000fe200078e006fULL,
0x000000086ada7981ULL, 0x0002a8000c1e9500ULL, 0x000000086c877981ULL, 0x0002a2000c1e9500ULL,
0xfffffff069587812ULL, 0x000fc800078ec0ffULL, 0x0000005823597210ULL, 0x000fe20007ffe0ffULL,
0x00000001ffce7424ULL, 0x000fc800078e00ffULL, 0x0000000152587824ULL, 0x000fe200078e0a59ULL,
0x00000001027a7812ULL, 0x000fc800078efcffULL, 0x00000058ce587219ULL, 0x000fe400000006ffULL,
0x000058007a5a7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff0755c7812ULL, 0x002fc600078ec0ffULL,
0x000000015a5b7824ULL, 0x100fe200078e0a59ULL, 0x00000008027c7812ULL, 0x040fe200078efcffULL,
0x00000001235f7824ULL, 0x000fe200078e025cULL, 0x00000009027e7812ULL, 0x000fe400078efcffULL,
0x0000005bce5c7219ULL, 0x000fe400000006ffULL, 0x000058007c5e7a10ULL, 0x000fe40007ffe0ffULL,
0x000058007e6c7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff07b6a7812ULL, 0x000fe200078ec0ffULL,
0x000000015e5d7824ULL, 0x100fe200078e0a59ULL, 0xfffffff079807812ULL, 0x000fe200078ec0ffULL,
0x000000016c597824ULL, 0x000fc400078e0a59ULL, 0x0000000123697824ULL, 0x040fe200078e026aULL,
0x0000005dce6a7219ULL, 0x040fe200000006ffULL, 0x0000000123757824ULL, 0x000fe200078e0280ULL,
0x00000059ce807219ULL, 0x000fe400000006ffULL, 0x0000001102847812ULL, 0x000fe400078efcffULL,
0x0000541051517816ULL, 0x010fc80000000054ULL, 0x0000005158ff7212ULL, 0x000fc800078ac0ffULL,
0x000000235200720cULL, 0x000fc80002fa1470ULL, 0x000000230200720cULL, 0x000fe40002fa1070ULL,
0x000000515cff7212ULL, 0x000fe4000782c0ffULL, 0xff8000000b0b7808ULL, 0x000fe40002800000ULL,
0x000000235a00720cULL, 0x000fe40000f21470ULL, 0x0000541053537816ULL, 0x000fc80000000060ULL,
0x0000005358ff7212ULL, 0x080fe4000784c0ffULL, 0x0000541055557816ULL, 0x000fe40000000062ULL,
0x000000535cff7212ULL, 0x000fe400078ac0ffULL, 0x0000005558ff7212ULL, 0x000fe4000788c0ffULL,
0x000000235200720cULL, 0x0c0fe40001741470ULL, 0x000000235200720cULL, 0x000fc40002781470ULL,
0x000000235a00720cULL, 0x080fe40002fa1470ULL, 0x000000230200720cULL, 0x0c0fe40001741070ULL,
0x000000230200720cULL, 0x080fe40002781070ULL, 0x000000237a00720cULL, 0x0c0fe40000f21070ULL,
0x000000237a00720cULL, 0x000fe40002fa1070ULL, 0x0000541056577816ULL, 0x000fc40000000057ULL,
0xff80000018187808ULL, 0x000fe40001000000ULL, 0xff80000031317808ULL, 0x000fe40002000000ULL,
0xff80000010107808ULL, 0x000fe40000800000ULL, 0xff80000020207808ULL, 0x000fe40002800000ULL,
0x000000516aff7212ULL, 0x000fe4000786c0ffULL, 0x0000005758ff7212ULL, 0x000fc4000780c0ffULL,
0x000000555cff7212ULL, 0x040fe4000784c0ffULL, 0x000000575cff7212ULL, 0x000fe4000788c0ffULL,
0x0000005380ff7212ULL, 0x000fe4000782c0ffULL, 0x000000556aff7212ULL, 0x000fe400078ac0ffULL,
0x0000580084867a10ULL, 0x000fe20007ffe0ffULL, 0x0000000166597824ULL, 0x000fe200078e0a5fULL,
0x000000235200720cULL, 0x000fc40000701470ULL, 0x000000235a00720cULL, 0x0c0fe40001741470ULL,
0x000000235a00720cULL, 0x080fe40002781470ULL, 0x000000235e00720cULL, 0x0c0fe40001f61470ULL,
0x000000235e00720cULL, 0x080fe40002fa1470ULL, 0x000000236c00720cULL, 0x000fe40000f21470ULL,
0x000000865f5b7210ULL, 0x000fc40007ffe1ffULL, 0x00000018028a7812ULL, 0x040fe400078efcffULL,
0x0000001902907812ULL, 0x040fe400078efcffULL, 0x000000230200720cULL, 0x080fe40000701070ULL,
0x000000237a00720cULL, 0x0c0fe40001741070ULL, 0x000000237a00720cULL, 0x080fe40002781070ULL,
0x000000237c00720cULL, 0x000fc40001f61070ULL, 0x000000237c00720cULL, 0x080fe40002fa1070ULL,
0x000000237e00720cULL, 0x000fe40000f21070ULL, 0x00000059ce827219ULL, 0x040fe400000006ffULL,
0x0000005bce887219ULL, 0x000fe400000006ffULL, 0x0000541061617816ULL, 0x008fe40000000068ULL,
0x0000541063637816ULL, 0x000fc4000000006eULL, 0x000058008a8c7a10ULL, 0x000fe40007ffe0ffULL,
0x0000580090927a10ULL, 0x000fe40007ffe0ffULL, 0xff80000046467808ULL, 0x000fe40000000000ULL,
0xff80000032327808ULL, 0x000fe40001000000ULL, 0xff80000049497808ULL, 0x000fe40002000000ULL,
0xff80000011117808ULL, 0x000fc40001800000ULL, 0xff80000033337808ULL, 0x000fe40002800000ULL,
0xff80000024247808ULL, 0x000fe40000800000ULL, 0x000000536aff7212ULL, 0x000fe4000780c0ffULL,
0x0000005580ff7212ULL, 0x000fe4000784c0ffULL, 0x000000576aff7212ULL, 0x080fe4000788c0ffULL,
0x0000005780ff7212ULL, 0x000fc4000786c0ffULL, 0x0000006188ff7212ULL, 0x000fe400078ac0ffULL,
0x0000006382ff7212ULL, 0x000fe2000782c0ffULL, 0x000000018c5d7824ULL, 0x100fe200078e0a5fULL,
0x000000235e00720cULL, 0x080fe20000701470ULL, 0x00000001925f7824ULL, 0x000fe200078e0a5fULL,
0x000000235e00720cULL, 0x080fe40002781470ULL, 0x000000236c00720cULL, 0x0c0fe40001741470ULL,
0x000000236c00720cULL, 0x000fc40001f61470ULL, 0x000000236600720cULL, 0x080fe40000f21470ULL,
0x000000238600720cULL, 0x080fe40002fa1470ULL, 0x000000237c00720cULL, 0x0c0fe40000701070ULL,
0x000000237c00720cULL, 0x080fe40002781070ULL, 0x000000237e00720cULL, 0x0c0fe40001741070ULL,
0x000000237e00720cULL, 0x000fc40001f61070ULL, 0x000000236400720cULL, 0x080fe40000f21070ULL,
0x000000238400720cULL, 0x000fe40002fa1070ULL, 0x0000005dce8e7219ULL, 0x040fe400000006ffULL,
0x0000005fce947219ULL, 0x000fe400000006ffULL, 0x0000541065657816ULL, 0x000fe40000000070ULL,
0x0000541067677816ULL, 0x000fc40000000076ULL, 0xff80000021217808ULL, 0x000fe40000000000ULL,
0xff8000004a4a7808ULL, 0x000fe40002000000ULL, 0xff80000034347808ULL, 0x000fe40001000000ULL,
0xff8000004c4c7808ULL, 0x000fe40001800000ULL, 0xff80000025257808ULL, 0x000fe40000800000ULL,
0xff80000014147808ULL, 0x000fc40002800000ULL, 0x0000006182ff7212ULL, 0x080fe4000780c0ffULL,
0x000000618eff7212ULL, 0x000fe4000788c0ffULL, 0x0000006582ff7212ULL, 0x040fe4000784c0ffULL,
0x0000006782ff7212ULL, 0x000fe4000786c0ffULL, 0x0000006588ff7212ULL, 0x000fe4000782c0ffULL,
0x0000006394ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001746b7824ULL, 0x000fe200078e0a69ULL,
0x000000236600720cULL, 0x000fc40000701470ULL, 0x000000236600720cULL, 0x0c0fe40001741470ULL,
0x000000236600720cULL, 0x080fe40001f61470ULL, 0x000000238600720cULL, 0x080fe40000f21470ULL,
0x000000238c00720cULL, 0x080fe40002781470ULL, 0x000000239200720cULL, 0x000fe40002fa1470ULL,
0x0000002102a47812ULL, 0x000fc400078efcffULL, 0x000000236400720cULL, 0x0c0fe40000701070ULL,
0x000000236400720cULL, 0x0c0fe40001741070ULL, 0x000000236400720cULL, 0x080fe40001f61070ULL,
0x000000238400720cULL, 0x080fe40000f21070ULL, 0x000000238a00720cULL, 0x080fe40002781070ULL,
0x000000239000720cULL, 0x000fc40002fa1070ULL, 0x0000006bce967219ULL, 0x000fe400000006ffULL,
0x0000541073737816ULL, 0x004fe400000000d0ULL, 0x00005800a4a67a10ULL, 0x000fe40007ffe0ffULL,
0xff80000013137808ULL, 0x000fe40000000000ULL, 0xff80000035357808ULL, 0x000fe40001000000ULL,
0xff8000004e4e7808ULL, 0x000fc40001800000ULL, 0xff80000036367808ULL, 0x000fe40000800000ULL,
0xff80000015157808ULL, 0x000fe40002000000ULL, 0xff80000028287808ULL, 0x000fe40002800000ULL,
0x0000006388ff7212ULL, 0x040fe4000780c0ffULL, 0x0000006788ff7212ULL, 0x000fe4000784c0ffULL,
0x000000638eff7212ULL, 0x000fc4000786c0ffULL, 0x0000006594ff7212ULL, 0x040fe4000782c0ffULL,
0x0000006794ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007396ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a66d7824ULL, 0x000fe200078e0a69ULL, 0x000000238600720cULL, 0x0c0fe40000701470ULL,
0x000000238600720cULL, 0x080fe40001741470ULL, 0x000000238c00720cULL, 0x000fc40001f61470ULL,
0x000000239200720cULL, 0x0c0fe40000f21470ULL, 0x000000239200720cULL, 0x080fe40002781470ULL,
0x000000237400720cULL, 0x080fe40002fa1470ULL, 0x0000002802aa7812ULL, 0x040fe400078efcffULL,
0x0000002902b07812ULL, 0x000fe400078efcffULL, 0x000000238400720cULL, 0x000fc40000701070ULL,
0x000000238400720cULL, 0x080fe40001741070ULL, 0x000000238a00720cULL, 0x080fe40001f61070ULL,
0x000000239000720cULL, 0x0c0fe40000f21070ULL, 0x000000239000720cULL, 0x080fe40002781070ULL,
0x000000237200720cULL, 0x000fe40002fa1070ULL, 0x0000006dcea87219ULL, 0x000fc400000006ffULL,
0x0000541071717816ULL, 0x000fe40000000078ULL, 0x0000541077777816ULL, 0x000fe400000000d4ULL,
0x00005410d8857816ULL, 0x000fe40000000085ULL, 0x00005800aaac7a10ULL, 0x000fe40007ffe0ffULL,
0x00005800b0b27a10ULL, 0x000fe40007ffe0ffULL, 0xff80000026267808ULL, 0x000fc40000000000ULL,
0xff8000004f4f7808ULL, 0x000fe40001000000ULL, 0xff80000027277808ULL, 0x000fe40001800000ULL,
0xff80000038387808ULL, 0x000fe40000800000ULL, 0xff8000004d4d7808ULL, 0x000fe40002000000ULL,
0xff80000029297808ULL, 0x000fe40002800000ULL, 0x0000005180ff7212ULL, 0x000fc400078cc0ffULL,
0x000000658eff7212ULL, 0x040fe4000780c0ffULL, 0x000000678eff7212ULL, 0x000fe4000784c0ffULL,
0x0000007196ff7212ULL, 0x040fe4000786c0ffULL, 0x0000007796ff7212ULL, 0x040fe4000782c0ffULL,
0x0000008596ff7212ULL, 0x000fe4000788c0ffULL, 0x00000077a8ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001ac6f7824ULL, 0x100fe200078e0a69ULL, 0x000000236c00720cULL, 0x080fe200037c1470ULL,
0x00000001b2697824ULL, 0x000fe200078e0a69ULL, 0x000000238c00720cULL, 0x000fc40000701470ULL,
0x000000238c00720cULL, 0x080fe40001741470ULL, 0x000000237400720cULL, 0x0c0fe40001f61470ULL,
0x000000237400720cULL, 0x0c0fe40000f21470ULL, 0x000000237400720cULL, 0x080fe40002781470ULL,
0x00000023a600720cULL, 0x080fe40002fa1470ULL, 0x000000237e00720cULL, 0x000fc400037c1070ULL,
0x000000238a00720cULL, 0x0c0fe40000701070ULL, 0x000000238a00720cULL, 0x080fe40001741070ULL,
0x000000237200720cULL, 0x0c0fe40001f61070ULL, 0x000000237200720cULL, 0x0c0fe40000f21070ULL,
0x000000237200720cULL, 0x080fe40002781070ULL, 0x00000023a400720cULL, 0x000fc40002fa1070ULL,
0x0000006fceae7219ULL, 0x040fe400000006ffULL, 0x00000069ceb47219ULL, 0x000fe400000006ffULL,
0xff80000012127808ULL, 0x000fe40003000000ULL, 0xff80000037377808ULL, 0x000fe40000000000ULL,
0xff80000050507808ULL, 0x000fe40001000000ULL, 0xff80000017177808ULL, 0x000fc40001800000ULL,
0xff80000039397808ULL, 0x000fe40000800000ULL, 0xff8000004b4b7808ULL, 0x000fe40002000000ULL,
0xff8000003a3a7808ULL, 0x000fe40002800000ULL, 0x0000006194ff7212ULL, 0x000fe400078cc0ffULL,
0x00000071a8ff7212ULL, 0x080fe4000780c0ffULL, 0x00000071aeff7212ULL, 0x000fc4000784c0ffULL,
0x00000073a8ff7212ULL, 0x040fe4000786c0ffULL, 0x00000085a8ff7212ULL, 0x000fe4000782c0ffULL,
0x00000073aeff7212ULL, 0x000fe4000788c0ffULL, 0x00000077b4ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b8797824ULL, 0x000fe200078e0a75ULL, 0x000000239200720cULL, 0x080fe400037c1470ULL,
0x00000023a600720cULL, 0x000fc40000701470ULL, 0x00000023a600720cULL, 0x0c0fe40001f61470ULL,
0x00000023a600720cULL, 0x080fe40000f21470ULL, 0x00000023ac00720cULL, 0x0c0fe40001741470ULL,
0x00000023ac00720cULL, 0x080fe40002781470ULL, 0x00000023b200720cULL, 0x000fe40002fa1470ULL,
0x0000003102be7812ULL, 0x000fc400078efcffULL, 0x0000003802c47812ULL, 0x040fe400078efcffULL,
0x0000003902ca7812ULL, 0x000fe400078efcffULL, 0x000000239000720cULL, 0x080fe400037c1070ULL,
0x00000023a400720cULL, 0x0c0fe40000701070ULL, 0x00000023a400720cULL, 0x0c0fe40001f61070ULL,
0x00000023a400720cULL, 0x000fc40000f21070ULL, 0x00000023aa00720cULL, 0x0c0fe40001741070ULL,
0x00000023aa00720cULL, 0x080fe40002781070ULL, 0x00000023b000720cULL, 0x000fe40002fa1070ULL,
0x00000079cebc7219ULL, 0x000fe400000006ffULL, 0x00005410ba7f7816ULL, 0x000fe4000000007fULL,
0x00005410d6837816ULL, 0x000fc40000000083ULL, 0x00005800bec07a10ULL, 0x000fe40007ffe0ffULL,
0x00005800c4c67a10ULL, 0x000fe40007ffe0ffULL, 0x00005800cacc7a10ULL, 0x000fe40007ffe0ffULL,
0xff80000016167808ULL, 0x000fe40003000000ULL, 0xff8000001c1c7808ULL, 0x000fe40000000000ULL,
0xff8000002a2a7808ULL, 0x000fc40001800000ULL, 0xff8000003c3c7808ULL, 0x000fe40000800000ULL,
0xff8000001f1f7808ULL, 0x000fe40001000000ULL, 0xff8000002b2b7808ULL, 0x000fe40002000000ULL,
0xff8000003d3d7808ULL, 0x000fe40002800000ULL, 0x00000071b4ff7212ULL, 0x040fe400078cc0ffULL,
0x00000073b4ff7212ULL, 0x000fc4000780c0ffULL, 0x00000077aeff7212ULL, 0x040fe4000786c0ffULL,
0x00000085aeff7212ULL, 0x080fe4000782c0ffULL, 0x00000085b4ff7212ULL, 0x000fe4000784c0ffULL,
0x0000007fbcff7212ULL, 0x040fe4000788c0ffULL, 0x00000083bcff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c07b7824ULL, 0x100fe200078e0a75ULL, 0x000000c6757d7210ULL, 0x000fe20007ffe1ffULL,
0x00000001cc757824ULL, 0x000fe200078e0a75ULL, 0x00000023ac00720cULL, 0x000fc40001f61470ULL,
0x00000023ac00720cULL, 0x080fe40000f21470ULL, 0x00000023b200720cULL, 0x0c0fe400037c1470ULL,
0x00000023b200720cULL, 0x0c0fe40000701470ULL, 0x00000023b200720cULL, 0x080fe40001741470ULL,
0x00000023b800720cULL, 0x0c0fe40002781470ULL, 0x00000023b800720cULL, 0x000fc40002fa1470ULL,
0x0000007bcec27219ULL, 0x040fe400000006ffULL, 0x0000007dcec87219ULL, 0x000fe400000006ffULL,
0x00000023aa00720cULL, 0x0c0fe40001f61070ULL, 0x00000023aa00720cULL, 0x080fe40000f21070ULL,
0x00000023b000720cULL, 0x0c0fe400037c1070ULL, 0x00000023b000720cULL, 0x000fc40000701070ULL,
0x00000023b000720cULL, 0x080fe40001741070ULL, 0x00000023b600720cULL, 0x0c0fe40002781070ULL,
0x00000023b600720cULL, 0x000fe40002fa1070ULL, 0x00000075cece7219ULL, 0x000fe400000006ffULL,
0x00005410d2817816ULL, 0x000fe40000000081ULL, 0xff8000003b3b7808ULL, 0x000fc40001800000ULL,
0xff8000003e3e7808ULL, 0x000fe40000800000ULL, 0xff8000001d1d7808ULL, 0x000fe40003000000ULL,
0xff8000002c2c7808ULL, 0x000fe40000000000ULL, 0xff8000003f3f7808ULL, 0x000fe40001000000ULL,
0xff8000001e1e7808ULL, 0x000fe40002000000ULL, 0xff80000040407808ULL, 0x000fc40002800000ULL,
0x0000007fc2ff7212ULL, 0x080fe4000786c0ffULL, 0x0000007fc8ff7212ULL, 0x080fe4000782c0ffULL,
0x0000007fceff7212ULL, 0x000fe400078cc0ffULL, 0x00000081bcff7212ULL, 0x080fe4000780c0ffULL,
0x00000081c2ff7212ULL, 0x080fe4000784c0ffULL, 0x00000081c8ff7212ULL, 0x000fc4000788c0ffULL,
0x00000083c2ff7212ULL, 0x000fe400078ac0ffULL, 0x00000023b800720cULL, 0x080fe40000701470ULL,
0x00000023c000720cULL, 0x0c0fe40001f61470ULL, 0x00000023c000720cULL, 0x0c0fe40001741470ULL,
0x00000023c000720cULL, 0x080fe40002fa1470ULL, 0x00000023c600720cULL, 0x000fc40000f21470ULL,
0x00000023cc00720cULL, 0x080fe400037c1470ULL, 0x00000023c600720cULL, 0x080fe40002781470ULL,
0x00000023b600720cULL, 0x080fe40000701070ULL, 0x00000023be00720cULL, 0x0c0fe40001f61070ULL,
0x00000023be00720cULL, 0x0c0fe40001741070ULL, 0x00000023be00720cULL, 0x000fc40002fa1070ULL,
0x00000023c400720cULL, 0x080fe40000f21070ULL, 0x00000023ca00720cULL, 0x080fe400037c1070ULL,
0x00000023c400720cULL, 0x000fe40002781070ULL, 0x00005410da877816ULL, 0x000fe40000000087ULL,
0xff8000002d2d7808ULL, 0x000fe40000000000ULL, 0xff8000001a1a7808ULL, 0x000fc40001800000ULL,
0xff8000002e2e7808ULL, 0x000fe40001000000ULL, 0xff80000041417808ULL, 0x000fe40002800000ULL,
0xff8000001b1b7808ULL, 0x000fe40000800000ULL, 0xff80000019197808ULL, 0x000fe40003000000ULL,
0xff8000002f2f7808ULL, 0x000fe40002000000ULL, 0x00000081ceff7212ULL, 0x000fc4000780c0ffULL,
0x00000083c8ff7212ULL, 0x080fe4000786c0ffULL, 0x00000083ceff7212ULL, 0x000fe4000784c0ffULL,
0x00000087bcff7212ULL, 0x080fe400078ac0ffULL, 0x00000087c2ff7212ULL, 0x080fe4000782c0ffULL,
0x00000087c8ff7212ULL, 0x080fe400078cc0ffULL, 0x00000087ceff7212ULL, 0x000fc4000788c0ffULL,
0x00000023b800720cULL, 0x080fe40002fa1470ULL, 0x00000023c000720cULL, 0x080fe40000f21470ULL,
0x00000023c600720cULL, 0x0c0fe40001f61470ULL, 0x00000023c600720cULL, 0x080fe400037c1470ULL,
0x00000023cc00720cULL, 0x0c0fe40000701470ULL, 0x00000023cc00720cULL, 0x000fc40001741470ULL,
0x00000023cc00720cULL, 0x080fe40002781470ULL, 0x00000023b600720cULL, 0x080fe40002fa1070ULL,
0x00000023be00720cULL, 0x080fe40000f21070ULL, 0x00000023ca00720cULL, 0x080fe40000701070ULL,
0x00000023c400720cULL, 0x0c0fe40001f61070ULL, 0x00000023c400720cULL, 0x000fc400037c1070ULL,
0x00000023ca00720cULL, 0x0c0fe40001741070ULL, 0x00000023ca00720cULL, 0x000fe40002781070ULL,
0xff80000030307808ULL, 0x000fe40000000000ULL, 0xff80000043437808ULL, 0x000fe40001800000ULL,
0xff80000045457808ULL, 0x000fe40001000000ULL, 0xff80000042427808ULL, 0x000fc40002800000ULL,
0xff80000044447808ULL, 0x000fe40000800000ULL, 0xff80000047477808ULL, 0x000fe40003000000ULL,
0xff80000048487808ULL, 0x000fc40002000000ULL, 0x0000000b0c00720bULL, 0x004fe40003f1e000ULL,
0x000000180d00720bULL, 0x000fe40003f3e000ULL, 0x000000310e00720bULL, 0x000fe40003f5e000ULL,
0x000000460f00720bULL, 0x000fc40003f7e000ULL, 0x0000000c0b237208ULL, 0x000fe40004000000ULL,
0x0000000d180d7208ULL, 0x000fe40004800000ULL, 0x0000000e31517208ULL, 0x000fe40005000000ULL,
0x0000000f46027208ULL, 0x000fe40005800000ULL, 0x000000102300720bULL, 0x000fe40003f1e000ULL,
0x000000200d00720bULL, 0x000fc40003f3e000ULL, 0x000000325100720bULL, 0x000fe40003f5e000ULL,
0x000000490200720bULL, 0x000fe40003f7e000ULL, 0x00000023100c7208ULL, 0x000fe40004000000ULL,
0x0000000d200e7208ULL, 0x000fe40004800000ULL, 0x0000005132527208ULL, 0x000fe40005000000ULL,
0x00000002490d7208ULL, 0x000fc40005800000ULL, 0x000000110c00720bULL, 0x000fe40003f1e000ULL,
0x000000210e00720bULL, 0x000fe40003f3e000ULL, 0x000000335200720bULL, 0x000fe40003f5e000ULL,
0x0000004a0d00720bULL, 0x000fe40003f7e000ULL, 0x0000000c110f7208ULL, 0x000fe40004000000ULL,
0x0000000e21237208ULL, 0x000fc40004800000ULL, 0x0000005233517208ULL, 0x000fe40005000000ULL,
0x0000000d4a0d7208ULL, 0x000fe40005800000ULL, 0x000000120f00720bULL, 0x000fe40003f1e000ULL,
0x000000242300720bULL, 0x000fe40003f3e000ULL, 0x000000345100720bULL, 0x000fe40003f5e000ULL,
0x0000004c0d00720bULL, 0x000fc40003f7e000ULL, 0x0000000f12027208ULL, 0x000fe40004000000ULL,
0x00000023240c7208ULL, 0x000fe40004800000ULL, 0x00000051340e7208ULL, 0x000fe40005000000ULL,
0x0000000d4c0d7208ULL, 0x000fe40005800000ULL, 0x000000130200720bULL, 0x000fe40003f1e000ULL,
0x000000250c00720bULL, 0x000fc40003f3e000ULL, 0x000000350e00720bULL, 0x000fe40003f5e000ULL,
0x0000004e0d00720bULL, 0x000fe40003f7e000ULL, 0x00000002130f7208ULL, 0x000fe40004000000ULL,
0x0000000c25237208ULL, 0x000fe40004800000ULL, 0x0000000e35517208ULL, 0x000fe40005000000ULL,
0x0000000d4e027208ULL, 0x000fc40005800000ULL, 0x000000140f00720bULL, 0x000fe40003f1e000ULL,
0x000000262300720bULL, 0x000fe40003f3e000ULL, 0x000000365100720bULL, 0x000fe40003f5e000ULL,
0x0000004f0200720bULL, 0x000fe40003f7e000ULL, 0x0000000f140c7208ULL, 0x000fe40004000000ULL,
0x00000023260e7208ULL, 0x000fc40004800000ULL, 0x0000005136527208ULL, 0x000fe40005000000ULL,
0x000000024f0d7208ULL, 0x000fe40005800000ULL, 0x000000150c00720bULL, 0x000fe40003f1e000ULL,
0x000000270e00720bULL, 0x000fe40003f3e000ULL, 0x000000375200720bULL, 0x000fe40003f5e000ULL,
0x000000500d00720bULL, 0x000fc40003f7e000ULL, 0x0000000c150f7208ULL, 0x000fe40004000000ULL,
0x0000000e27237208ULL, 0x000fe40004800000ULL, 0x0000005237517208ULL, 0x000fe40005000000ULL,
0x0000000d50027208ULL, 0x000fe40005800000ULL, 0x000000160f00720bULL, 0x000fe40003f1e000ULL,
0x000000282300720bULL, 0x000fc40003f3e000ULL, 0x000000385100720bULL, 0x000fe40003f5e000ULL,
0x0000004d0200720bULL, 0x000fe40003f7e000ULL, 0x0000000f160c7208ULL, 0x000fe40004000000ULL,
0x00000023280e7208ULL, 0x000fe40004800000ULL, 0x0000005138527208ULL, 0x000fe40005000000ULL,
0x000000024d027208ULL, 0x000fc40005800000ULL, 0x000000170c00720bULL, 0x000fe40003f1e000ULL,
0x000000290e00720bULL, 0x000fe40003f3e000ULL, 0x000000395200720bULL, 0x000fe40003f5e000ULL,
0x0000004b0200720bULL, 0x000fe40003f7e000ULL, 0x0000000c170d7208ULL, 0x000fe40004000000ULL,
0x0000000e290f7208ULL, 0x000fc40004800000ULL, 0x0000005239237208ULL, 0x000fe40005000000ULL,
0x000000024b517208ULL, 0x000fe40005800000ULL, 0x0000001c0d00720bULL, 0x000fe40003f1e000ULL,
0x0000002a0f00720bULL, 0x000fe40003f3e000ULL, 0x0000003a2300720bULL, 0x000fe40003f5e000ULL,
0x0000003c5100720bULL, 0x000fc40003f7e000ULL, 0x0000000d1c027208ULL, 0x000fe40004000000ULL,
0x0000000f2a0c7208ULL, 0x000fe40004800000ULL, 0x000000233a0e7208ULL, 0x000fe40005000000ULL,
0x000000513c517208ULL, 0x000fe40005800000ULL, 0x0000001f0200720bULL, 0x000fe40003f1e000ULL,
0x0000002b0c00720bULL, 0x000fc40003f3e000ULL, 0x0000003b0e00720bULL, 0x000fe40003f5e000ULL,
0x0000003e5100720bULL, 0x000fe40003f7e000ULL, 0x000000021f027208ULL, 0x000fe40004000000ULL,
0x0000000c2b0d7208ULL, 0x000fe40004800000ULL, 0x0000000e3b0e7208ULL, 0x000fe40005000000ULL,
0x000000513e0c7208ULL, 0x000fc40005800000ULL, 0x0000001d0200720bULL, 0x000fe40003f1e000ULL,
0x0000002c0d00720bULL, 0x000fe40003f3e000ULL, 0x0000003d0e00720bULL, 0x000fe40003f5e000ULL,
0x0000003f0c00720bULL, 0x000fe40003f7e000ULL, 0x000000021d0f7208ULL, 0x000fe40004000000ULL,
0x0000000d2c027208ULL, 0x000fc40004800000ULL, 0x0000000e3d0d7208ULL, 0x000fe40005000000ULL,
0x0000000c3f237208ULL, 0x000fe40005800000ULL, 0x0000002d0200720bULL, 0x000fe40003f3e000ULL,
0x0000001e0f00720bULL, 0x000fe40003f1e000ULL, 0x000000400d00720bULL, 0x000fe40003f5e000ULL,
0x000000422300720bULL, 0x000fc40003f7e000ULL, 0x000000022d517208ULL, 0x000fe40004800000ULL,
0x0000000f1e0f7208ULL, 0x000fe40004000000ULL, 0x0000000d40027208ULL, 0x000fe40005000000ULL,
0x0000002342237208ULL, 0x000fe40005800000ULL, 0x0000001a0f00720bULL, 0x000fe40003f1e000ULL,
0x0000002e5100720bULL, 0x000fc40003f3e000ULL, 0x000000410200720bULL, 0x000fe40003f5e000ULL,
0x000000442300720bULL, 0x000fe40003f7e000ULL, 0x0000000f1a0c7208ULL, 0x000fe40004000000ULL,
0x000000512e0e7208ULL, 0x000fe40004800000ULL, 0x0000000241027208ULL, 0x000fe40005000000ULL,
0x0000002344527208ULL, 0x000fc40005800000ULL, 0x0000001b0c00720bULL, 0x000fe40003f1e000ULL,
0x0000002f0e00720bULL, 0x000fe40003f3e000ULL, 0x000000430200720bULL, 0x000fe40003f5e000ULL,
0x000000475200720bULL, 0x000fe40003f7e000ULL, 0x0000000c1b0c7208ULL, 0x000fe40004000000ULL,
0x0000000e2f0d7208ULL, 0x000fc40004800000ULL, 0x0000000243027208ULL, 0x000fe40005000000ULL,
0x00000052470f7208ULL, 0x000fe40005800000ULL, 0x000000190c00720bULL, 0x000fe40003f1e000ULL,
0x000000300d00720bULL, 0x000fe40003f3e000ULL, 0x000000450200720bULL, 0x000fe40003f5e000ULL,
0x000000480f00720bULL, 0x000fc40003f7e000ULL, 0x0000000c19237208ULL, 0x000fe40004000000ULL,
0x0000000d30517208ULL, 0x000fe40004800000ULL, 0x0000000245577208ULL, 0x000fe40005000000ULL,
0x0000000f48567208ULL, 0x000fe20005800000ULL, 0x000024727f007947ULL, 0x000fea000b800000ULL,
0x0c401f0023027f89ULL, 0x0004e400000e0000ULL, 0x000000022300720bULL, 0x00cfc80003f1e000ULL,
0x0000002302597208ULL, 0x000fe20004000000ULL, 0x000024a27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0051027f89ULL, 0x000ea800000e0000ULL, 0x0c401f00570c7f89ULL, 0x000ee800000e0000ULL,
0x0c401f00560d7f89ULL, 0x000f2200000e0000ULL, 0x000000025100720bULL, 0x004fc40003f1e000ULL,
0x0000000c5700720bULL, 0x008fe40003f3e000ULL, 0x0000005102027208ULL, 0x000fe40004000000ULL,
0x000000570c0f7208ULL, 0x002fe40004800000ULL, 0x0000000d5600720bULL, 0x010fe20003f1e000ULL,
0x0c201f00590c7f89ULL, 0x000e6600000e0000ULL, 0x000000560d557208ULL, 0x000fe20004000000ULL,
0x0c201f0002237f89ULL, 0x000ea800000e0000ULL, 0x0c201f000f0e7f89ULL, 0x000ee800000e0000ULL,
0x0c201f0055587f89ULL, 0x0002e400000e0000ULL, 0x0000000c5900720bULL, 0x002fc40003f1e000ULL,
0x000000230200720bULL, 0x004fe40003f3e000ULL, 0x000000590c0c7208ULL, 0x000fe40004000000ULL,
0x0000000e0f00720bULL, 0x008fe40003f5e000ULL, 0x00000002230d7208ULL, 0x000fe40004800000ULL,
0x0000000f0e0e7208ULL, 0x000fc60005000000ULL, 0x3fb8aa3b0d0f7820ULL, 0x002fe20000410000ULL,
0x000000585500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b0c547820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b18187823ULL, 0x000fc4000001080fULL,
0x3fb8aa3b20207823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b21217823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001080fULL, 0x0000001800187308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b25257823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b26267823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b27277823ULL, 0x000fc4000001080fULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001080fULL,
0x0000002100217308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b29297823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080fULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2d2d7823ULL, 0x000fc4000001080fULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe4000001080fULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe4000001080fULL, 0x3fb8aa3b300f7823ULL, 0x000fe2000001080fULL,
0x0000002d00617308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b14147823ULL, 0x100fe40000010854ULL,
0x3fb8aa3b10107823ULL, 0x100fe40000010854ULL, 0x3fb8aa3b1d527823ULL, 0x000fc40000010854ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010854ULL, 0x0000000f00647308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b11117823ULL, 0x100fe20000010854ULL, 0x00000002ff2d7819ULL, 0x002fe2000001169dULL,
0x3fb8aa3b12127823ULL, 0x100fe40000010854ULL, 0x3fb8aa3b13137823ULL, 0x100fe40000010854ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010854ULL, 0x00000014005a7308ULL, 0x0003e20000000800ULL,
0x00000055580f7208ULL, 0x004fe20004000000ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010854ULL,
0x000000039dff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b17027823ULL, 0x000fc40000010854ULL,
0x000000082d677824ULL, 0x040fe400078e00ffULL, 0x00000025001d7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b0e147820ULL, 0x002fe40000410000ULL, 0x3fb8aa3b1c237823ULL, 0x000fe20000010854ULL,
0x000000032d1c7819ULL, 0x000fe200000006ffULL, 0x3fb8aa3b31317823ULL, 0x100fe40000010814ULL,
0x3fb8aa3b32327823ULL, 0x000fe20000010814ULL, 0x0000000b00577308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b0f257820ULL, 0x004fc40000410000ULL, 0x3fb8aa3b38387823ULL, 0x100fe40000010814ULL,
0x3fb8aa3b46467823ULL, 0x100fe40000010825ULL, 0x3fb8aa3b49497823ULL, 0x100fe20000010825ULL,
0x0000001000107308ULL, 0x000e620000000800ULL, 0x3fb8aa3b4c4c7823ULL, 0x000fe40000010825ULL,
0x3fb8aa3b33337823ULL, 0x100fe40000010814ULL, 0x3fb8aa3b34347823ULL, 0x000fc40000010814ULL,
0x3fb8aa3b35357823ULL, 0x100fe20000010814ULL, 0x0000001100117308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b36367823ULL, 0x100fe40000010814ULL, 0x3fb8aa3b37377823ULL, 0x100fe40000010814ULL,
0x3fb8aa3b39397823ULL, 0x100fe40000010814ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010814ULL,
0x0000001200127308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010814ULL,
0x000000571010723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b3d3d7823ULL, 0x000fc40000010814ULL,
0x3fb8aa3b40407823ULL, 0x100fe40000010814ULL, 0x3fb8aa3b41417823ULL, 0x100fe20000010814ULL,
0x0000001300597308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b43437823ULL, 0x100fe40000010814ULL,
0x3fb8aa3b45147823ULL, 0x000fe40000010814ULL, 0x3fb8aa3b4a4a7823ULL, 0x000fe40000010825ULL,
0x000000082d457824ULL, 0x000fe200078e00ffULL, 0x0000002000137308ULL, 0x0002e20000000800ULL,
0x3fb8aa3b1f517823ULL, 0x100fe20000010854ULL, 0x000000111212723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b1e537823ULL, 0x000fc40000010854ULL, 0x3fb8aa3b1a567823ULL, 0x100fe20000010854ULL,
0x000000032d1a7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b1b0b7823ULL, 0x100fe20000010854ULL,
0x00000015005b7308ULL, 0x000fe20000000800ULL, 0x000000082d577824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b19547823ULL, 0x000fe20000010854ULL, 0x000000022d197810ULL, 0x040fe20007ffe0ffULL,
0x000000082d657824ULL, 0x000fe400078e00ffULL, 0x3c003c00ff207424ULL, 0x002fe200078e00ffULL,
0x00000016005c7308ULL, 0x000e620000000800ULL, 0x000000181311723eULL, 0x008fe200000000ffULL,
0x000000082d6b7824ULL, 0x000fe200078e00ffULL, 0x000000212413723eULL, 0x000fe200000000ffULL,
0x3c003c00ff217424ULL, 0x000fe200078e00ffULL, 0xfffffff81c557812ULL, 0x000fe200078ee219ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010825ULL, 0xfffffff865657812ULL, 0x000fe200078ee21aULL,
0x00000029005d7308ULL, 0x000fe20000000800ULL, 0x000000052d197810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe20000010825ULL, 0x000000062d1a7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b50507823ULL, 0x000fe20000010825ULL, 0xfffffff81c697812ULL, 0x000fe200078ee219ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010825ULL, 0xfffffff86b6b7812ULL, 0x000fe200078ee21aULL,
0x0000003300167308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010825ULL,
0x000000201018723cULL, 0x000f6200000018ffULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe20000010825ULL,
0x000000595a1c723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010825ULL,
0x0000005b5c1e723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe20000010825ULL,
0x0000003400157308ULL, 0x000e620000000800ULL, 0x3fb8aa3b42427823ULL, 0x000fc40000010825ULL,
0x3fb8aa3b44447823ULL, 0x100fe40000010825ULL, 0x3fb8aa3b47477823ULL, 0x100fe40000010825ULL,
0x3fb8aa3b48487823ULL, 0x000fe20000010825ULL, 0x0000003800297308ULL, 0x000fe20000000800ULL,
0x000000082d307824ULL, 0x000fce00078e00ffULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0x000000161516723eULL, 0x002fce00000000ffULL, 0x0000003200327308ULL, 0x000e700000000800ULL,
0x0000001400387308ULL, 0x0005f00000000800ULL, 0x0000004600467308ULL, 0x000fe20000000800ULL,
0x000000012d147810ULL, 0x004fc80007ffe0ffULL, 0xfffffff845457812ULL, 0x000fe400078ee214ULL,
0x000000042d147810ULL, 0x000fe20007ffe0ffULL, 0x0000004900497308ULL, 0x000ea60000000800ULL,
0xfffffff867677812ULL, 0x000fe400078ee214ULL, 0xffffffff2d147810ULL, 0x000fc60007ffe0ffULL,
0x0000004a00177308ULL, 0x000fe20000000800ULL, 0xfffffff857577812ULL, 0x000fe400078ee214ULL,
0x000000313214723eULL, 0x002fca00000000ffULL, 0x0000004c004c7308ULL, 0x000e620000000800ULL,
0x000000464915723eULL, 0x004fce00000000ffULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x000000174c17723eULL, 0x002fce00000000ffULL, 0x00000027001f7308ULL, 0x0003e20000000800ULL,
0x0000000c224c7812ULL, 0x000fe400078ec0ffULL, 0x0000001d261d723eULL, 0x004fca00000000ffULL,
0x0000002a005e7308ULL, 0x000fe20000000800ULL, 0x000000201424723cULL, 0x002f6e00000018ffULL,
0x0000002800287308ULL, 0x000e700000000800ULL, 0x0000002b005f7308ULL, 0x000ff00000000800ULL,
0x0000002c00607308ULL, 0x000fe20000000800ULL, 0x0000001f281f723eULL, 0x002fce00000000ffULL,
0x00000037002a7308ULL, 0x000e620000000800ULL, 0x000000201c18723cULL, 0x020fee0000001818ULL,
0x0000003500357308ULL, 0x000ff00000000800ULL, 0x0000003600367308ULL, 0x000ea20000000800ULL,
0x0000002a292a723eULL, 0x002fce00000000ffULL, 0x0000004e004e7308ULL, 0x000ff00000000800ULL,
0x0000004f004f7308ULL, 0x000e620000000800ULL, 0x000000353628723eULL, 0x004fce00000000ffULL,
0x00000050002b7308ULL, 0x000ff00000000800ULL, 0x0000004d002c7308ULL, 0x000ea20000000800ULL,
0x0000004e4f29723eULL, 0x002fce00000000ffULL, 0x0000000200027308ULL, 0x000fe20000000800ULL,
0x0000002b2c2b723eULL, 0x004fce00000000ffULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x000000202824723cULL, 0x000f6e0000001824ULL, 0x0000005100517308ULL, 0x000ff00000000800ULL,
0x0000005200527308ULL, 0x000ff00000000800ULL, 0x0000003a00347308ULL, 0x000ff00000000800ULL,
0x0000003900397308ULL, 0x000e700000000800ULL, 0x0000003b003b7308ULL, 0x000ff00000000800ULL,
0x0000003d00667308ULL, 0x0004e20000000800ULL, 0x000000393434723eULL, 0x002fce00000000ffULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0xfffffff8303d7812ULL, 0x004fce00078ee22dULL,
0x0000003c003c7308ULL, 0x000e620000000800ULL, 0x0000003b6636723eULL, 0x008fce00000000ffULL,
0x0000003e00377308ULL, 0x000ff00000000800ULL, 0x0000003f003a7308ULL, 0x000ea20000000800ULL,
0x0000004b3c35723eULL, 0x002fce00000000ffULL, 0x0000002e00627308ULL, 0x0002f00000000800ULL,
0x0000002f00637308ULL, 0x0008e20000000800ULL, 0x000000082d2e7810ULL, 0x002fe40007ffe0ffULL,
0x000000373a37723eULL, 0x004fc600000000ffULL, 0x000000082e497824ULL, 0x000fe400078e00ffULL,
0x0000000b000b7308ULL, 0x000fe20000000800ULL, 0x000000102d2f7810ULL, 0x050fe20007ffe0ffULL,
0x000000203424723cULL, 0x020fe20000001824ULL, 0x000000182d2d7810ULL, 0x000fe40007ffe0ffULL,
0x000000032f2c7819ULL, 0x000fe400000006ffULL, 0xfffffff849497812ULL, 0x000fe200078ee22eULL,
0x000000082d307824ULL, 0x000fe200078e00ffULL, 0xfffffff82c4d7812ULL, 0x000fe200078ee22fULL,
0x0000005400547308ULL, 0x000e620000000800ULL, 0x00000002232c723eULL, 0x000fc400000000ffULL,
0xfffffff8304f7812ULL, 0x000fe400078ee22dULL, 0x00000051522e723eULL, 0x000fe400000000ffULL,
0x0000005d5e2d723eULL, 0x000fe200000000ffULL, 0x0000005300537308ULL, 0x000fe20000000800ULL,
0x0000005f602f723eULL, 0x000fe400000000ffULL, 0x0001200000027811ULL, 0x000fe400078e60ffULL,
0x000000616231723eULL, 0x008fc400000000ffULL, 0x000000636433723eULL, 0x000fe200000000ffULL,
0x000000202c18723cULL, 0x000f620000001818ULL, 0x0000005600567308ULL, 0x000ea20000000800ULL,
0x0000000b5432723eULL, 0x002fe200000000ffULL, 0x000000103d0b7824ULL, 0x100fe400078e0202ULL,
0x0000001045227824ULL, 0x100fe400078e0202ULL, 0x0000001055397824ULL, 0x100fe200078e0202ULL,
0x0000000b4c0b7210ULL, 0x000fe20007ffe0ffULL, 0x0000004000407308ULL, 0x000fe20000000800ULL,
0x00000010653a7824ULL, 0x000fc400078e0202ULL, 0x00000010673b7824ULL, 0x100fe200078e0202ULL,
0x000000100b007388ULL, 0x0003e20000000800ULL, 0x00000010693c7824ULL, 0x000fe400078e0202ULL,
0x000000014c227824ULL, 0x000fe200078e0222ULL, 0x0000004100417308ULL, 0x000fe20000000800ULL,
0x000000535630723eULL, 0x004fe200000000ffULL, 0x000000106b3d7824ULL, 0x100fe200078e0202ULL,
0x0000003c4c3c7210ULL, 0x040fe20007ffe0ffULL, 0x000000014c397824ULL, 0x000fe200078e0239ULL,
0x0000001222007388ULL, 0x0003e20000000800ULL, 0x00000010573e7824ULL, 0x000fc400078e0202ULL,
0x0000004300437308ULL, 0x000ea20000000800ULL, 0x000000014c3a7824ULL, 0x040fe200078e023aULL,
0x000000203018723cULL, 0x020f620000001818ULL, 0x00000010493f7824ULL, 0x100fe200078e0202ULL,
0x0000001c39007388ULL, 0x0003e20000000800ULL, 0x000000014c3b7824ULL, 0x040fe400078e023bULL,
0x000000014c3d7824ULL, 0x000fe200078e023dULL, 0x0000004200427308ULL, 0x000fe20000000800ULL,
0x000000104d497824ULL, 0x100fe200078e0202ULL, 0x0000001e3a007388ULL, 0x0003e20000000800ULL,
0x000000104f4a7824ULL, 0x000fc400078e0202ULL, 0x000000014c3e7824ULL, 0x040fe200078e023eULL,
0x0000002c3b007388ULL, 0x0003e20000000800ULL, 0x000000014c027824ULL, 0x000fe200078e023fULL,
0x0000004400237308ULL, 0x0007220000000800ULL, 0x000000433846723eULL, 0x004fe200000000ffULL,
0x0000002e3c007388ULL, 0x0003e20000000800ULL, 0x000000014c497824ULL, 0x040fe400078e0249ULL,
0x000000014c4a7824ULL, 0x000fe200078e024aULL, 0x000000303d007388ULL, 0x0003e40000000800ULL,
0x0000004700477308ULL, 0x000fe20000000800ULL, 0x000000404144723eULL, 0x008fe200000000ffULL,
0x000000323e007388ULL, 0x0003e20000000800ULL, 0x000000ffff197224ULL, 0x020fc600078e001aULL,
0x0000001102007388ULL, 0x0003e40000000800ULL, 0x0000004800487308ULL, 0x000ea20000000800ULL,
0x000000422345723eULL, 0x010fe200000000ffULL, 0x0004001322007388ULL, 0x0003e80000000800ULL,
0x0004001d39007388ULL, 0x0003e80000000800ULL, 0x0004001f3a007388ULL, 0x0003e80000000800ULL,
0x0004002d3b007388ULL, 0x0003e20000000800ULL, 0x000000474847723eULL, 0x004fc600000000ffULL,
0x0004002f3c007388ULL, 0x0003e80000000800ULL, 0x000400313d007388ULL, 0x0003e20000000800ULL,
0x000000204424723cULL, 0x000f660000001824ULL, 0x000400333e007388ULL, 0x0003e80000000800ULL,
0x0000001449007388ULL, 0x0003e80000000800ULL, 0x0008001622007388ULL, 0x0003e80000000800ULL,
0x0008002839007388ULL, 0x0003e80000000800ULL, 0x0008002a3a007388ULL, 0x0003e80000000800ULL,
0x000800343b007388ULL, 0x0003e20000000800ULL, 0x000000ffff1a7224ULL, 0x020fc400078e0024ULL,
0x000000ffff1b7224ULL, 0x000fe200078e0026ULL, 0x000800363c007388ULL, 0x0003e80000000800ULL,
0x000800443d007388ULL, 0x0003e80000000800ULL, 0x000800463e007388ULL, 0x0003e80000000800ULL,
0x000000154a007388ULL, 0x0003e80000000800ULL, 0x000c001722007388ULL, 0x0003e80000000800ULL,
0x000c002939007388ULL, 0x0003e80000000800ULL, 0x000c002b3a007388ULL, 0x0003e80000000800ULL,
0x000c00353b007388ULL, 0x0003e80000000800ULL, 0x000c00373c007388ULL, 0x0003e80000000800ULL,
0x000c00453d007388ULL, 0x0003e80000000800ULL, 0x000c00473e007388ULL, 0x0003e80000000800ULL,
0x01e0000c03008388ULL, 0x0003e80000000c00ULL, 0x01e2001803008388ULL, 0x0003e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e608009eff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e610009eff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01e618009eff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000069100720cULL, 0x000fe20003f06070ULL,
0x01e620009eff7f8cULL, 0x0003e4000c80043fULL, 0x0000009100027202ULL, 0x002fd40000000f00ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff76c000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff247807ULL, 0x004fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x0001987000267802ULL, 0x000fc40000000f00ULL,
0x0000160000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff157224ULL, 0x000fe200078e0024ULL,
0xfffe962000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe40005000000ULL,
0xffffffff00257802ULL, 0x000fe40000000f00ULL, 0x000198d000267802ULL, 0x000fc40000000f00ULL,
0x000015a000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff167224ULL, 0x000fe200078e0024ULL,
0xfffe965000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0017ULL,
0x0001994000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff687424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x000014e000007944ULL, 0x018fea0003c00000ULL,
0xfffe970000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0017ULL,
0x000199a000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff687424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000148000007944ULL, 0x01afea0003c00000ULL,
0xfffe981000007947ULL, 0x000fea000383ffffULL, 0x0000001700267202ULL, 0x000fe20000000f00ULL,
0x0000001fff687424ULL, 0x000fe200078e00ffULL, 0x00019a0000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000142000007944ULL, 0x01afea0003c00000ULL,
0xfffe992000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0017ULL,
0x00019a6000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff687424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x000013c000007944ULL, 0x01afea0003c00000ULL,
0xfffe9a2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0013ULL,
0x00019ad000257802ULL, 0x000fe20000000f00ULL, 0x000000ffff247224ULL, 0x000fc400078e0012ULL,
0x0000001fff687424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000135000007944ULL, 0x010fea0003c00000ULL, 0x00000024000f7202ULL, 0x004fe20000000f00ULL,
0xfffe9bb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0013ULL,
0x00019b4000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff687424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x000012e000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0024ULL, 0x0000001012247810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0013ULL, 0x00019bb000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff687424ULL, 0x000fc400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000127000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0024ULL,
0xfffe9b2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0013ULL,
0x0000001f00687802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x00019c2000257802ULL, 0x000fc40000000f00ULL, 0x0000120000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff127224ULL, 0x004fe200078e0024ULL, 0xfffe9ae000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x002fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x00019c8000267802ULL, 0x000fc40000000f00ULL, 0x000011f000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff227224ULL, 0x000fe200078e0024ULL, 0xfffeb3f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe20004800000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x00019ce000267802ULL, 0x000fc40000000f00ULL, 0x0000119000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff217224ULL, 0x000fe200078e0024ULL, 0xfffeb43000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006cULL, 0x0000001f00687802ULL, 0x000fe20000000f00ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x00019d5000257802ULL, 0x000fc40000000f00ULL,
0x000010d000007944ULL, 0x018fea0003c00000ULL, 0xfffeb4f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006cULL, 0x00019db000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff687424ULL, 0x000fc400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000107000007944ULL, 0x01afea0003c00000ULL, 0xfffeb60000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006cULL, 0x00019e1000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff687424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000101000007944ULL, 0x01afea0003c00000ULL, 0xfffeb71000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006cULL, 0xffffffff00277802ULL, 0x000fe20000000f00ULL,
0x0000001fff687424ULL, 0x000fe200078e00ffULL, 0x00019e7000257802ULL, 0x000fc40000000f00ULL,
0x00000fb000007944ULL, 0x01afea0003c00000ULL, 0xfffeb81000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0008ULL, 0x00019ee000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff247224ULL, 0x000fe400078e0069ULL, 0x0000001fff687424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000f4000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0024ULL, 0xfffeb99000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0008ULL, 0x00019f5000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff687424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000ed000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0024ULL,
0x0000001069247810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff687424ULL, 0x000fe200078e00ffULL,
0x0000000800267202ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x00019fc000257802ULL, 0x000fc40000000f00ULL, 0x00000e6000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0024ULL, 0xfffeb90000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0008ULL, 0x0001a03000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff687424ULL, 0x000fc400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000df000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff127224ULL, 0x004fe200078e0024ULL,
0xfffeb8c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x004fe20004000000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x0001a09000267802ULL, 0x000fc40000000f00ULL,
0x00000de000007944ULL, 0x018fea0003c00000ULL, 0x0000002400227202ULL, 0x000fe20000000f00ULL,
0xfffecf1000007947ULL, 0x000fea000383ffffULL, 0x00000001ff247807ULL, 0x000fe20004800000ULL,
0xffffffffff257424ULL, 0x000fe200078e00ffULL, 0x0001a0f000267802ULL, 0x000fc40000000f00ULL,
0x00000d8000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff6b7224ULL, 0x000fe200078e0024ULL,
0xfffecf4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e006cULL,
0x0001a16000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff687424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000cc000007944ULL, 0x018fea0003c00000ULL,
0xfffecff000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e006cULL,
0x0000001f00687802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0001a1c000257802ULL, 0x000fc40000000f00ULL, 0x00000c6000007944ULL, 0x01afea0003c00000ULL,
0xfffed10000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e006cULL,
0x0001a22000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff687424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000c0000007944ULL, 0x01afea0003c00000ULL,
0xfffed21000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e006cULL,
0x0001a28000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff687424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000ba000007944ULL, 0x01afea0003c00000ULL,
0xfffed31000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0012ULL,
0x0000006900247202ULL, 0x000fe20000000f00ULL, 0x0000001fff687424ULL, 0x000fe200078e00ffULL,
0x0001a2f000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x00000b3000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0024ULL,
0xfffed49000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0012ULL,
0x0001a36000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff687424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x00000ac000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0024ULL, 0x0000001069247810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0012ULL, 0x0000001f00687802ULL, 0x000fe20000000f00ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001a3d000257802ULL, 0x000fc40000000f00ULL,
0x00000a5000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff117224ULL, 0x004fe200078e0024ULL,
0xfffed40000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0012ULL,
0x0001a44000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff687424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x000009e000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff127224ULL, 0x004fe200078e0024ULL, 0xfffed3c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x008fe20004000000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x0001a4a000267802ULL, 0x000fc40000000f00ULL, 0x000009d000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e0024ULL, 0xfffeea1000007947ULL, 0x000fea000383ffffULL,
0x00000001ff247807ULL, 0x000fe20004800000ULL, 0xffffffffff257424ULL, 0x000fe200078e00ffULL,
0x0001a50000267802ULL, 0x000fc40000000f00ULL, 0x0000097000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff4b7224ULL, 0x000fe200078e0024ULL, 0xfffeea4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006aULL, 0x0001a57000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff687424ULL, 0x000fc400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x000008b000007944ULL, 0x010fea0003c00000ULL, 0xfffeeb0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006aULL, 0x0001a5d000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff687424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000085000007944ULL, 0x012fea0003c00000ULL, 0xfffeec1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006aULL, 0x0000001f00687802ULL, 0x000fe20000000f00ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001a63000257802ULL, 0x000fc40000000f00ULL,
0x000007f000007944ULL, 0x012fea0003c00000ULL, 0xfffeed2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e006aULL, 0x0001a69000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff687424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x0000079000007944ULL, 0x012fea0003c00000ULL, 0xfffeee2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000dULL, 0x0001a70000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff247224ULL, 0x000fc400078e0012ULL, 0x0000001fff687424ULL, 0x000fe400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000072000007944ULL, 0x010fea0003c00000ULL,
0x00000024000f7202ULL, 0x004fe20000000f00ULL, 0xfffeefa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e000dULL, 0x0001a77000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff687424ULL, 0x000fe400078e00ffULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x000006b000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0024ULL,
0x0000001012247810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e000dULL,
0x0001a7e000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff687424ULL, 0x000fc400078e00ffULL,
0xffffffffff277424ULL, 0x000fc400078e00ffULL, 0x0000064000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff117224ULL, 0x004fe200078e0024ULL, 0xfffeef1000007947ULL, 0x000fea000383ffffULL,
0x0000000d00267202ULL, 0x000fe20000000f00ULL, 0x0000001fff687424ULL, 0x000fe200078e00ffULL,
0x0001a85000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff277424ULL, 0x000fc400078e00ffULL,
0x000005d000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff127224ULL, 0x004fe200078e0024ULL,
0xfffeeed000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0f7224ULL, 0x000fe200078e0023ULL,
0x0001a8d000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff547424ULL, 0x000fe400078e00ffULL,
0x0000001fff027424ULL, 0x000fe400078e00ffULL, 0xffffffffff5b7424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x002fea0003c00000ULL, 0xffffdb3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0f7224ULL, 0x002fe200078e0051ULL, 0xffffffff005b7802ULL, 0x000fe20000000f00ULL,
0x00000002ff547424ULL, 0x000fe200078e00ffULL, 0x0001a94000527802ULL, 0x000fe20000000f00ULL,
0x0000001fff027424ULL, 0x000fc400078e00ffULL, 0x000004a000007944ULL, 0x000fea0003c00000ULL,
0x000000025100720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0f7224ULL, 0x002fe200078e0057ULL,
0x0001a9c000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff547424ULL, 0x000fe200078e00ffULL,
0x00000051020d7208ULL, 0x000fe20004000000ULL, 0x0000001fff027424ULL, 0x000fc400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x0000042000007944ULL, 0x000fea0003c00000ULL,
0x000000025700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0f7224ULL, 0x002fe200078e0056ULL,
0x0001aa4000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff547424ULL, 0x000fe200078e00ffULL,
0x0000005702237208ULL, 0x000fe20004000000ULL, 0x0000001fff027424ULL, 0x000fe400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x000000025600720bULL, 0x004fe20003f1e000ULL, 0x00000001ff547424ULL, 0x002fe200078e00ffULL,
0x00000059000f7202ULL, 0x000fe20000000f00ULL, 0xffffffffff5b7424ULL, 0x000fe200078e00ffULL,
0x0000005602557208ULL, 0x000fe20004000000ULL, 0x0000001fff027424ULL, 0x000fe200078e00ffULL,
0x0001aac000527802ULL, 0x000fc40000000f00ULL, 0x0000032000007944ULL, 0x000fea0003c00000ULL,
0x000000025900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0f7224ULL, 0x002fe200078e000dULL,
0x0001ab4000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff547424ULL, 0x000fe200078e00ffULL,
0x00000059020c7208ULL, 0x000fe20004000000ULL, 0x0000001fff027424ULL, 0x000fc400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x000000020d00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0f7224ULL, 0x002fe200078e0023ULL,
0x0000000100547802ULL, 0x000fe20000000f00ULL, 0xffffffffff5b7424ULL, 0x000fe200078e00ffULL,
0x0000000d020d7208ULL, 0x000fe20004000000ULL, 0x0000001fff027424ULL, 0x000fe200078e00ffULL,
0x0001abc000527802ULL, 0x000fc40000000f00ULL, 0x0000022000007944ULL, 0x000fea0003c00000ULL,
0x000000022300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0f7224ULL, 0x002fe200078e0055ULL,
0x0001ac4000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff547424ULL, 0x000fe200078e00ffULL,
0x00000023020e7208ULL, 0x000fe20004000000ULL, 0x0000001fff027424ULL, 0x000fc400078e00ffULL,
0xffffffffff5b7424ULL, 0x000fc400078e00ffULL, 0x000001a000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff587224ULL, 0x004fe200078e0002ULL, 0xffffd91000007947ULL, 0x000fea000383ffffULL,
0x0180000006027810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000002077812ULL, 0x000fc800078ec0ffULL, 0x018000000700780cULL, 0x000fda0003f05070ULL,
0x0000000600028308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0700720cULL, 0x040fe40003f25070ULL, 0x008000000700780cULL, 0x000fe40003f02070ULL,
0x00000001ff077807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000207ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff06ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000006067812ULL, 0x002fe400078ec0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000207ff7212ULL, 0x000fda000780c0ffULL,
0x0080000006020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0006ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000600027308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff067224ULL, 0x006fe400078e000aULL,
0x00000000ff077424ULL, 0x000fc800078e00ffULL, 0xfffe522006007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff537424ULL, 0x000fe200078e00ffULL, 0x0000005b00007348ULL, 0x000fe80003800000ULL,
0x0c0000540f027389ULL, 0x0002a200000e0002ULL, 0xfffe51e052007950ULL, 0x000fea0003c3ffffULL,
0x0000002700007348ULL, 0x000fe80003800000ULL, 0x0000002426247389ULL, 0x0002a400000e0068ULL,
0x000000ffff267224ULL, 0x002fc400078e0025ULL, 0x00000000ff277424ULL, 0x000fc800078e00ffULL,
0xfffe519026007950ULL, 0x000fea0003c3ffffULL, 0x000000012400780cULL, 0x000fe20003f45070ULL,
0x00000000ff277424ULL, 0x000fe200078e00ffULL, 0x0000002500007348ULL, 0x000ff60003800000ULL,
0x0000000000247806ULL, 0x000fc800050e0100ULL, 0x0000002524247212ULL, 0x000fe200078ec0ffULL,
0xfffe513026007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000100000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x00000000000004c4ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000620ULL,
0x0000000000000240ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000860ULL,
0x00000000000002b0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b10ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000bd0ULL,
0x00000000000006c0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001290ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000012a0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001330ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001334ULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001500ULL,
0x000000000001af80ULL, 0xdd00001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c480ULL,
0x0000000000000038ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001c4c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001c840ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001330ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000001b150ULL,
0x000000000001b150ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001c480ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001c840ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_32_sm_80_cubin_len = 117024;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
