/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_32_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001b0c0ULL, 0x000000000001ad40ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45346a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL,
0x4545386a4c453233ULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL,
0x6964696c53726550ULL, 0x6e695f5f2400676eULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL,
0x63725f30326d735fULL, 0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x5f24006874617077ULL,
0x616e7265746e695fULL, 0x635f5f245f315f6cULL, 0x30376d735f616475ULL, 0x6e79736c6668735fULL,
0x705f796c66625f63ULL, 0x65746e695f5f2400ULL, 0x245f325f6c616e72ULL, 0x735f616475635f5fULL,
0x6c6668735f30376dULL, 0x7864695f636e7973ULL, 0x6e695f5f2400705fULL, 0x335f6c616e726574ULL,
0x616475635f5f245fULL, 0x6f765f30376d735fULL, 0x625f636e79736574ULL, 0x722e00746f6c6c61ULL,
0x747865742e616c65ULL, 0x5f6c656e72656b2eULL, 0x6c65722e0061686dULL, 0x656b2e747865742eULL,
0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL,
0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL,
0x5f67756265642e00ULL, 0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL,
0x6265642e616c6572ULL, 0x656d6172665f6775ULL, 0x6c65722e766e2e00ULL, 0x006e6f697463612eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000028ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b00220000036fULL, 0x00000000000194e0ULL, 0x0000000000000170ULL, 0x000b0022000003a2ULL,
0x0000000000019650ULL, 0x0000000000000040ULL, 0x000b0022000003cdULL, 0x0000000000019690ULL,
0x0000000000000040ULL, 0x000b0022000003f7ULL, 0x00000000000196d0ULL, 0x0000000000000130ULL,
0x000a000300000465ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000485ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000004b5ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000019800ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000194e000000000ULL, 0x0000040400000000ULL, 0x810c000001500400ULL,
0x0063dc0400288080ULL, 0x0000000000000000ULL, 0x00000044ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080920828808081ULL,
0x80162880808a0828ULL, 0x0000000310288082ULL, 0x808a920000000000ULL, 0x0000000022002880ULL,
0x0000001cffffffffULL, 0x0000007000000000ULL, 0x000194e000000000ULL, 0x0000017000000000ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL, 0xa008288080910828ULL,
0x288080d008288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080d0ULL,
0x0000001cffffffffULL, 0x000000e800000000ULL, 0x0001965000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL, 0xa008288080910828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a0920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x0000016800000000ULL, 0x0001969000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x0000004cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x80808a0828808081ULL, 0xa008288080910828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x00288080a0920000ULL, 0x0000000000000022ULL,
0x0000001cffffffffULL, 0x000001e800000000ULL, 0x000196d000000000ULL, 0x0000013000000000ULL,
0x0000000000000000ULL, 0x0000001700082f04ULL, 0x00082304000000dfULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL,
0x0000000000000011ULL, 0x0000001100081204ULL, 0x0008110400000000ULL, 0x0000000000000011ULL,
0x0000001000082304ULL, 0x0008120400000000ULL, 0x0000000000000010ULL, 0x0000001000081104ULL,
0x0008230400000000ULL, 0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL,
0x0000000000000017ULL, 0x0000007b00043704ULL, 0x0000001400080a04ULL, 0x0060190300600160ULL,
0x00000000000c1704ULL, 0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0021f00000500008ULL,
0x00000000000c1704ULL, 0x0011f00000480007ULL, 0x00000000000c1704ULL, 0x0081f00000280006ULL,
0x00000000000c1704ULL, 0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL,
0x00000000000c1704ULL, 0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL,
0x00000000000c1704ULL, 0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL,
0x0004310400ff1b03ULL, 0x01cc290400000ab0ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01cc2804ffffffffULL,
0x0000034000000130ULL, 0x00001d70000004c0ULL, 0x00002f6000002eb0ULL, 0x000031e000003070ULL,
0x000034b000003350ULL, 0x00003700000036c0ULL, 0x0000374000003710ULL, 0x000050b0000040c0ULL,
0x0000527000005150ULL, 0x00005550000053e0ULL, 0x000058b0000056b0ULL, 0x00005900000058f0ULL,
0x0000600000005930ULL, 0x0000708000006ff0ULL, 0x0000730000007190ULL, 0x000075d000007470ULL,
0x00007810000077d0ULL, 0x0000785000007820ULL, 0x00008f0000007e50ULL, 0x000090b000008f90ULL,
0x0000939000009220ULL, 0x000096f0000094f0ULL, 0x0000974000009730ULL, 0x00009ec000009770ULL,
0x00009ee000009ed0ULL, 0x0000cc9000009ef0ULL, 0x0000cd500000cd40ULL, 0x0000d8c00000cd90ULL,
0x0000d9000000d8f0ULL, 0x000172100000d910ULL, 0x0001726000017250ULL, 0x000172c000017270ULL,
0x00017300000172e0ULL, 0x0001866000017310ULL, 0x00018700000186b0ULL, 0x0001878000018740ULL,
0x00018810000187c0ULL, 0x000188b000018860ULL, 0x0001895000018900ULL, 0x000189f0000189a0ULL,
0x00018a7000018a30ULL, 0x00018b0000018ab0ULL, 0x00018ba000018b50ULL, 0x00018c4000018bf0ULL,
0x00018ce000018c90ULL, 0x00018d6000018d20ULL, 0x00018df000018da0ULL, 0x00018e9000018e40ULL,
0x00018f3000018ee0ULL, 0x00018fd000018f80ULL, 0x0001905000019010ULL, 0x000190e000019090ULL,
0x0001918000019130ULL, 0x00019220000191d0ULL, 0x000192e000019280ULL, 0x000193a000019340ULL,
0x0001946000019400ULL, 0x02003904000194c0ULL, 0x000000ff00000410ULL, 0x003f010000016600ULL,
0x0000000700000460ULL, 0x003f012000016608ULL, 0x00000007000004b0ULL, 0x003f012000016688ULL,
0x000000ff00000ad0ULL, 0x003f010700016600ULL, 0x0000002200000cd0ULL, 0x003f01020001668cULL,
0x0000002200000d80ULL, 0x003f010100016688ULL, 0x0000000300002bb0ULL, 0x003f010100016608ULL,
0x0000000300002bd0ULL, 0x003f01050001660cULL, 0x0000000300002da0ULL, 0x003f01050001660cULL,
0x0000001c00004060ULL, 0x003f010100016688ULL, 0x0000006600004df0ULL, 0x003f010100016628ULL,
0x0000006600004e10ULL, 0x003f01050001662cULL, 0x0000006600004fe0ULL, 0x003f01050001662cULL,
0x0000001a00005fc0ULL, 0x003f010100000000ULL, 0x0000001d00006d30ULL, 0x003f010100016648ULL,
0x0000001d00006d50ULL, 0x003f01050001664cULL, 0x0000001d00006f20ULL, 0x003f01050001664cULL,
0x0000001f00007e30ULL, 0x003f010100000000ULL, 0x0000006800008c50ULL, 0x003f010100016668ULL,
0x0000006800008c70ULL, 0x003f01050001666cULL, 0x0000006800008e40ULL, 0x003f01050001666cULL,
0x0000000800009d20ULL, 0x003f010100000000ULL, 0x000000ff0000f3d0ULL, 0x003f010100016600ULL,
0x000000ff0000ffa0ULL, 0x003f010500016604ULL, 0x000000ff00010170ULL, 0x003f010500016604ULL,
0x0000009b00014630ULL, 0x003f010100000000ULL, 0x0000009b00014810ULL, 0x003f010500000004ULL,
0x0000009b000149e0ULL, 0x003f010500000004ULL, 0x0000009c000184c0ULL, 0x003f010100016608ULL,
0x0000009c00018520ULL, 0x003f010100016610ULL, 0x0000009c00018580ULL, 0x003f010100016618ULL,
0x0000009c000185f0ULL, 0x003f010100016620ULL, 0x00301c0400033803ULL, 0x0000e7800000e750ULL,
0x0000eab00000e950ULL, 0x0000ed700000ec10ULL, 0x0000f0300000eed0ULL, 0x0000f2c00000f1c0ULL,
0x00018630000101d0ULL, 0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL,
0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000254ULL,
0x0000001700000002ULL, 0x00000000000001d4ULL, 0x0000001700000002ULL, 0x0000000000000154ULL,
0x0000001700000002ULL, 0x00000000000000d4ULL, 0x0000001700000002ULL, 0x0000000000000044ULL,
0x0000001700000002ULL, 0x000000000000022aULL, 0x0000001700000002ULL, 0x00000000000001aaULL,
0x0000001700000002ULL, 0x000000000000012fULL, 0x0000001700000002ULL, 0x00000000000000adULL,
0x0000001700000002ULL, 0x0000000000016700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff107624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000087919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000a7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a0010837a19ULL, 0x000fe200000006ffULL,
0x00000000000579c3ULL, 0x000f220000002500ULL, 0x0000000000097919ULL, 0x000ea20000002100ULL,
0x0000460000087ab9ULL, 0x000fc60000000a00ULL, 0x0000000000a07919ULL, 0x000ee20000002700ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fe20007ffe0ffULL,
0x00000005ff967e24ULL, 0x010fe2000f8e00ffULL, 0x00000005ff9a7819ULL, 0x004fc80000011609ULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x00001fff9a9a7589ULL, 0x000fe200000e0000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x00000400037f7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a7fULL,
0x0000040003007624ULL, 0x000fca00078e0210ULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x000000017f7f0810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x000000017f7f1810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff7faa12ULL, 0x000fc800078e33ffULL, 0x0000007f00007306ULL, 0x000e620000209000ULL,
0x000000ff7f00720cULL, 0x000fce0003f45070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000037f047224ULL, 0x004fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000000803067227ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000ee40000002200ULL,
0x000000ffff007224ULL, 0x000fc800078e0a06ULL, 0x000000007f007224ULL, 0x000fca00078e0208ULL,
0x0000007f0000720cULL, 0x000fda0003f06070ULL, 0x0000000100000824ULL, 0x000fe200078e0a7fULL,
0x0000000106060810ULL, 0x000fe20007ffe0ffULL, 0x000001000a027a24ULL, 0x008fc600078e0203ULL,
0x0000007f0000720cULL, 0x000fe20003f26070ULL, 0x0000000002077a24ULL, 0x000fe400078e0209ULL,
0x00001fff0a097589ULL, 0x000e6600000e0000ULL, 0x000000ff0700720cULL, 0x040fe40003f65270ULL,
0x0000000f0700780cULL, 0x040fe40003f84070ULL, 0x000000030700780cULL, 0x000fc60003f04070ULL,
0x0000000106061810ULL, 0x000fe40007ffe0ffULL, 0x0000007fff06a212ULL, 0x000fe400078e33ffULL,
0x0000007f0700780cULL, 0x000fe40003f24070ULL, 0x3fffff80ff02b424ULL, 0x000fe200078e00ffULL,
0x00005a00067e7a19ULL, 0x000fe200000006ffULL, 0x000000ffff007224ULL, 0x000fe400078e0a06ULL,
0x7fffff80ff03b424ULL, 0x000fc400078e00ffULL, 0x000000007f7f7224ULL, 0x000fe400078e0208ULL,
0x3fffffc0ff04c424ULL, 0x000fe200078e00ffULL, 0x01660002ff00b388ULL, 0x0005e20000000a00ULL,
0x000000207f977824ULL, 0x000fe400078e00ffULL, 0x7fffffc0ff05c424ULL, 0x000fe400078e00ffULL,
0xff317217ff089424ULL, 0x000fe200078e00ffULL, 0x0000000497007c10ULL, 0x040fe4000fffe1ffULL,
0x016608040700c388ULL, 0x000fe20000008a00ULL, 0x3fffff60ff028424ULL, 0x004fe200078e00ffULL,
0x0000002000007817ULL, 0x000fe20003800000ULL, 0x7fffff60ff038424ULL, 0x000fe200078e00ffULL,
0x0164000807009388ULL, 0x000fe80000004800ULL, 0x0166880207008388ULL, 0x000fe80000008a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000497007c0cULL, 0x000fc4000bf03070ULL,
0x0000009a09047211ULL, 0x002fe400078e10ffULL, 0x000000ff007d7207ULL, 0x000fe20000000000ULL,
0x00005800a0007a24ULL, 0x000fe400078e02ffULL, 0x0000000404047824ULL, 0x000fe200078e00ffULL,
0x000000207d00780cULL, 0x000fe20003f05270ULL, 0x0000008300027224ULL, 0x000fd800078e027eULL,
0x000002e000008947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe20000000000ULL, 0x000000047d037217ULL, 0x000fe20007800000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe4000800063fULL,
0x0000000103037824ULL, 0x000fe200078e0a04ULL, 0x00000004ff057819ULL, 0x002fc80000011600ULL,
0x00000002050a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000104087824ULL, 0x000fe200078e0205ULL,
0x000000030500720cULL, 0x080fe40003f06070ULL, 0x000000030a00720cULL, 0x000fe20003f26070ULL,
0x00000001040c7824ULL, 0x000fe400078e020aULL, 0x0000000197077824ULL, 0x040fe400078e0208ULL,
0x00000001970d7824ULL, 0x000fe400078e020cULL, 0x00000001080a7824ULL, 0x000fe200078e0200ULL,
0x00000004070b7c12ULL, 0x000fc4000f8e30ffULL, 0x000000040d0f7c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fe20000011607ULL, 0x00000001020b7824ULL, 0x040fe200078e020bULL,
0x00005a00ff0e7a19ULL, 0x000fe2000001160dULL, 0x00000001020f7824ULL, 0x000fe400078e020fULL,
0x0000008304027224ULL, 0x080fe400078e020bULL, 0x0000001000077824ULL, 0x000fe400078e00ffULL,
0x000000830e047224ULL, 0x000fc400078e020fULL, 0x0000010002027825ULL, 0x000fe200078e00ffULL,
0x000000f0070b7812ULL, 0x000fc600078ec0ffULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x0000000b02027212ULL, 0x000fc600078efcffULL, 0x00000010080d7824ULL, 0x000fe200078e00ffULL,
0x0000000b04047212ULL, 0x000fe200078efcffULL, 0x000000010c087824ULL, 0x000fe200078e0200ULL,
0x00005e0002027a10ULL, 0x000fe20007f5e0ffULL, 0x000000100c0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff00d0a7812ULL, 0x000fe400078ee20aULL, 0x00005e0004047a10ULL, 0x000fe40007f7e0ffULL,
0xfffffff00b087812ULL, 0x000fe200078ee208ULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0x00005f0003037a10ULL, 0x000fc400017fe4ffULL, 0x00005f0005057a10ULL, 0x000fe20001ffe4ffULL,
0x00000010080d7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e8000c101c48ULL, 0x00000000040d7faeULL, 0x0003e2000c901c48ULL,
0x0000027000007947ULL, 0x000fea0003800000ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fc40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x0000000400087211ULL, 0x002fc800078fe0ffULL,
0x00000002080b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000197037824ULL, 0x040fe400078e0208ULL,
0x00000010080f7824ULL, 0x000fe400078e00ffULL, 0x0000000197077824ULL, 0x000fe200078e020bULL,
0x0000000403057c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff047a19ULL, 0x000fe40000011603ULL,
0x00000004070d7c12ULL, 0x000fc4000f8e30ffULL, 0x0000000502057210ULL, 0x040fe40007ffe0ffULL,
0x00005a00ff0a7a19ULL, 0x000fe20000011607ULL, 0x00000001020d7824ULL, 0x000fe400078e020dULL,
0x0000008304027224ULL, 0x080fe400078e0205ULL, 0x0000001000077824ULL, 0x000fe400078e00ffULL,
0x000000830a047224ULL, 0x000fe400078e020dULL, 0x0000010002027825ULL, 0x000fe200078e00ffULL,
0x000000f0070d7812ULL, 0x000fc600078ec0ffULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x0000000d02027212ULL, 0x000fc600078efcffULL, 0x00000001080a7824ULL, 0x100fe200078e0200ULL,
0x0000000d04047212ULL, 0x000fe200078efcffULL, 0x000000010b087824ULL, 0x040fe200078e0200ULL,
0x00005e0002027a10ULL, 0x000fe20007f1e0ffULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff00f0a7812ULL, 0x000fe400078ee20aULL, 0x00005e0004047a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00b087812ULL, 0x000fe200078ee208ULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0x00005f0003037a10ULL, 0x000fc400007fe4ffULL, 0x00005f0005057a10ULL, 0x000fe20000ffe4ffULL,
0x00000010080d7824ULL, 0x000fe400078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e8000b901c48ULL, 0x00000000040d7faeULL, 0x0003e4000b901c48ULL,
0x0000000000037919ULL, 0x002e620000000000ULL, 0x0000000000047806ULL, 0x000fe200038e0000ULL,
0x00000004ff2d7424ULL, 0x000fe400078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400027300ULL, 0x000e7000000e0000ULL, 0x0000000400057309ULL, 0x000ea20000000000ULL,
0x000000030200720cULL, 0x002fe20003f02070ULL, 0x00006600a0027625ULL, 0x000fc800078e002dULL,
0x000000ffff057224ULL, 0x004fd000078e0a05ULL, 0x01660405ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01660000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000802957981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0900720cULL, 0x000fe40003f05270ULL,
0x0000003f95947810ULL, 0x044fe40007ffe0ffULL, 0x000000ff95237810ULL, 0x000fc40007ffe0ffULL,
0x00000006ff947819ULL, 0x000fe40000011694ULL, 0x00000008ff237819ULL, 0x000fca0000011623ULL,
0x0000e6c000008947ULL, 0x000fea0003800000ULL, 0x00000002ff027819ULL, 0x000fe2000001169aULL,
0x000000089a227824ULL, 0x000fe400078e00ffULL, 0x00000003ff0b7424ULL, 0x000fe200078e00ffULL,
0x03ffffff02037812ULL, 0x000fe200078ec0ffULL, 0xffffffffff057424ULL, 0x002fc800078e00ffULL,
0x00000004962a7824ULL, 0x000fca00078e0203ULL, 0x000000942a00720cULL, 0x000fda0003f06070ULL,
0x00000002a0038824ULL, 0x000fe400078e00ffULL, 0x00006800ff048624ULL, 0x000fc800078e00ffULL,
0x0000680003038624ULL, 0x000fc800078e0204ULL, 0x000000012a038824ULL, 0x000fe200078e0203ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01668c0b22ff738cULL, 0x0003e20000000000ULL,
0x0000640003088625ULL, 0x000fe200078e002dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000808058981ULL, 0x000ea2000c1e1900ULL, 0x00000001960c7810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff0b7424ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fe2000001169aULL,
0x0166880022ff7f8cULL, 0x0003e2000c80043fULL, 0x000000230c00720cULL, 0x000fc60003f06070ULL,
0x0000002003047824ULL, 0x000fc800078e00ffULL, 0x00000100960e7824ULL, 0x000fe400078e0204ULL,
0x00005900050a7a24ULL, 0x004fe200078e02ffULL, 0x0000000606057819ULL, 0x000fe400000006ffULL,
0x000000019a067812ULL, 0x000fe200078ec0ffULL, 0x000000400a0a7824ULL, 0x000fe200078e00ffULL,
0x00000020052b7812ULL, 0x000fc600078ef80eULL, 0x000062000a087625ULL, 0x000fe200078e000bULL,
0x0000064000008947ULL, 0x000fea0003800000ULL, 0x00000003ff187819ULL, 0x002fe40000011600ULL,
0x0000000e950a7217ULL, 0x000fe40007800000ULL, 0x00000004180c7810ULL, 0x040fe40007ffe0ffULL,
0x0000000818107810ULL, 0x000fe20007ffe0ffULL, 0x000000010a0a7824ULL, 0x000fe200078e0a0eULL,
0x0000000c18117810ULL, 0x000fe20007ffe0ffULL, 0x000000010c0b7824ULL, 0x100fe200078e0200ULL,
0x0000001018167810ULL, 0x000fe20007ffe0ffULL, 0x000000080c127824ULL, 0x000fe200078e00ffULL,
0x00000014181c7810ULL, 0x000fe20007ffe0ffULL, 0x00000001100d7824ULL, 0x000fc400078e0200ULL,
0x0000000810147824ULL, 0x000fe200078e00ffULL, 0xfffffff8121d7812ULL, 0x000fe200078ee20bULL,
0x00000001110e7824ULL, 0x000fe200078e0200ULL, 0x00000070070b7812ULL, 0x000fe200078ec0ffULL,
0x0000000811217824ULL, 0x000fe200078e00ffULL, 0x000000200a077817ULL, 0x000fe20003800000ULL,
0x000000012b0f7824ULL, 0x040fe200078e020cULL, 0xfffffff8141f7812ULL, 0x000fe200078ee20dULL,
0x00000080060a7824ULL, 0x000fe200078e020bULL, 0x000000070c00720cULL, 0x080fe20003f86070ULL,
0x000000012b0d7824ULL, 0x000fe200078e0218ULL, 0xfffffff821217812ULL, 0x000fe200078ee20eULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000000071000720cULL, 0x080fe20003f66070ULL,
0x0000000116137824ULL, 0x000fe200078e0200ULL, 0x000000071100720cULL, 0x080fe20003f46070ULL,
0x000001000d0c7825ULL, 0x000fe200078e000aULL, 0x000000071800720cULL, 0x000fc60003fa6070ULL,
0x000001000f0e7825ULL, 0x000fe200078e000aULL, 0x0000000c08127210ULL, 0x000fc60007f1e0ffULL,
0x00000008161a7824ULL, 0x000fe200078e00ffULL, 0x0000000e08147210ULL, 0x000fe20007f3e0ffULL,
0x000000011c157824ULL, 0x040fe400078e0200ULL, 0x000000081c1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a257812ULL, 0x000fe200078ee213ULL, 0x00000002031a7824ULL, 0x000fe200078e0206ULL,
0x0000000d09137210ULL, 0x000fe200007fe4ffULL, 0x000000012b0d7824ULL, 0x000fe200078e0210ULL,
0xfffffff81e277812ULL, 0x000fe200078ee215ULL, 0x0000000109157824ULL, 0x000fe200008e060fULL,
0x000000071600720cULL, 0x000fe20003f26070ULL, 0x000000012b0f7824ULL, 0x000fe200078e0211ULL,
0x0000e0001a1a7811ULL, 0x000fe200078e68ffULL, 0x000001000d0c7825ULL, 0x000fe200078e000aULL,
0x0000001c181e7810ULL, 0x000fc60007ffe0ffULL, 0x0000000118107824ULL, 0x000fe400078e0200ULL,
0x000001000f0e7825ULL, 0x000fc600078e000aULL, 0x0000000710197812ULL, 0x000fe200078ec0ffULL,
0x000000012b117824ULL, 0x000fe200078e0216ULL, 0x0000000c08167210ULL, 0x040fe20007f1e0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e021aULL, 0x0000000e080e7210ULL, 0x000fe20007fde0ffULL,
0x0000010011107825ULL, 0x000fe200078e000aULL, 0x0ffffff819197812ULL, 0x000fc600078ef800ULL,
0x0000000109177824ULL, 0x000fe200000e060dULL, 0x000000071c00720cULL, 0x000fe20003f06070ULL,
0x000000012b0d7824ULL, 0x000fe200078e021cULL, 0x00000018181c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001090f7824ULL, 0x000fe200030e060fULL, 0x0000001008107210ULL, 0x000fe20007fde0ffULL,
0x000001000d0c7825ULL, 0x000fc800078e000aULL, 0x0000000109117824ULL, 0x000fe200030e0611ULL,
0x0000000c08187210ULL, 0x000fe20007fde0ffULL, 0x00000010191b7824ULL, 0x000fe400078e021aULL,
0x000000012b297824ULL, 0x000fe400078e021cULL, 0x0000000109197824ULL, 0x000fe200030e060dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000121b7faeULL, 0x0003e2000e901c48ULL,
0x00000100290c7825ULL, 0x000fe200078e000aULL, 0x000000071c00720cULL, 0x080fe40003fa6070ULL,
0x00000000141d7faeULL, 0x0005e2000e101c48ULL, 0x000000012b2b7824ULL, 0x000fe200078e021eULL,
0x000000071e00720cULL, 0x000fe20003f86070ULL, 0x000000011c077824ULL, 0x000fe200078e0200ULL,
0x0000000c080c7210ULL, 0x000fe20007fde0ffULL, 0x000000081c1c7824ULL, 0x000fc400078e00ffULL,
0x000001002b0a7825ULL, 0x000fe200078e000aULL, 0x000000031e137819ULL, 0x002fe400000006ffULL,
0xfffffff81c077812ULL, 0x000fe200078ee207ULL, 0x000000011e127824ULL, 0x000fe400078e0200ULL,
0x00000001090d7824ULL, 0x000fe200030e060dULL, 0x0000000a08087210ULL, 0x000fe20007fde0ffULL,
0x000000101f1f7824ULL, 0x000fe200078e021aULL, 0xfffffff813137812ULL, 0x000fe200078ee212ULL,
0x0000001021217824ULL, 0x000fc400078e021aULL, 0x0000001025257824ULL, 0x100fe200078e021aULL,
0x00000000161f7faeULL, 0x0005e2000d901c48ULL, 0x0000001027277824ULL, 0x100fe400078e021aULL,
0x0000001007077824ULL, 0x100fe200078e021aULL, 0x000000000e217faeULL, 0x0005e2000d101c48ULL,
0x0000001013137824ULL, 0x000fe400078e021aULL, 0x0000000109097824ULL, 0x000fe200030e060bULL,
0x0000000010257faeULL, 0x0005e8000c901c48ULL, 0x0000000018277faeULL, 0x0005e8000c101c48ULL,
0x000000000c077faeULL, 0x0005e8000e901c48ULL, 0x0000000008137faeULL, 0x0005e2000e101c48ULL,
0x0000057000007947ULL, 0x000fea0003800000ULL, 0x00000004000b7811ULL, 0x042fe400078fe8ffULL,
0x00000008000f7811ULL, 0x000fc400078fe8ffULL, 0x0000001400157811ULL, 0x040fe200078fe8ffULL,
0x000000010b0a7824ULL, 0x140fe200078e0200ULL, 0x0000000c00117811ULL, 0x040fe200078fe8ffULL,
0x000000080b0d7824ULL, 0x000fe200078e00ffULL, 0x0000001800177811ULL, 0x040fe200078fe8ffULL,
0x000000010f0c7824ULL, 0x040fe400078e0200ULL, 0x000000080f137824ULL, 0x000fe200078e00ffULL,
0xfffffff80d1a7812ULL, 0x000fe200078ee20aULL, 0x00000001150d7824ULL, 0x000fe200078e0200ULL,
0x00000000170e7210ULL, 0x080fe20007ffe0ffULL, 0x0000000815247824ULL, 0x000fe200078e00ffULL,
0xfffffff8131c7812ULL, 0x000fe200078ee20cULL, 0x00000001110a7824ULL, 0x140fe200078e0200ULL,
0x0000001000137811ULL, 0x000fe200078fe8ffULL, 0x0000000811197824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee20dULL, 0x00000008171d7824ULL, 0x000fe200078e00ffULL,
0x00000070070d7812ULL, 0x000fe200078ec0ffULL, 0x00000001130c7824ULL, 0x000fe200078e0200ULL,
0xfffffff8191e7812ULL, 0x000fe200078ee20aULL, 0x00000008131b7824ULL, 0x000fe200078e00ffULL,
0x0000001c00197811ULL, 0x000fe200078fe8ffULL, 0x0000008006187824ULL, 0x000fe200078e020dULL,
0xfffffff81d267812ULL, 0x000fe200078ee20eULL, 0x000000012b0d7824ULL, 0x000fe200078e020bULL,
0xfffffff81b207812ULL, 0x000fe200078ee20cULL, 0x00000001190a7824ULL, 0x040fe200078e0200ULL,
0x0000002b000b7211ULL, 0x040fe200078fe8ffULL, 0x00000008191d7824ULL, 0x000fe200078e00ffULL,
0x0000000000077211ULL, 0x000fe200078fe8ffULL, 0x00000002030c7824ULL, 0x000fc400078e0206ULL,
0x000000012b1b7824ULL, 0x000fe200078e0219ULL, 0xfffffff81d287812ULL, 0x000fe200078ee20aULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x0000e0000c297811ULL, 0x000fe200078e68ffULL,
0x000000012b0f7824ULL, 0x000fe200078e020fULL, 0x0000000707077812ULL, 0x000fe200078ec0ffULL,
0x000000012b117824ULL, 0x000fe200078e0211ULL, 0x0000002924257211ULL, 0x000fe200078e20ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0018ULL, 0x0ffffff807077812ULL, 0x000fc600078ef800ULL,
0x000001000d0c7825ULL, 0x000fe200078e0018ULL, 0x0000000a080a7210ULL, 0x000fc60007f1e0ffULL,
0x000000012b137824ULL, 0x000fe200078e0213ULL, 0x0000000c080c7210ULL, 0x000fe20007f3e0ffULL,
0x000001000f0e7825ULL, 0x000fc800078e0018ULL, 0x000000012b157824ULL, 0x000fe200078e0215ULL,
0x0000000e080e7210ULL, 0x000fe20007f5e0ffULL, 0x0000010011107825ULL, 0x000fc800078e0018ULL,
0x000000012b177824ULL, 0x000fe200078e0217ULL, 0x0000001008107210ULL, 0x000fe20007f7e0ffULL,
0x0000010013127825ULL, 0x000fc800078e0018ULL, 0x0000010015147825ULL, 0x000fc800078e0018ULL,
0x0000010017167825ULL, 0x000fc800078e0018ULL, 0x000001001b187825ULL, 0x000fc800078e0018ULL,
0x00000001090b7824ULL, 0x040fe200000e060bULL, 0x0000001208127210ULL, 0x040fe20007f1e0ffULL,
0x00000001090d7824ULL, 0x000fe200008e060dULL, 0x0000001408147210ULL, 0x040fe20007f3e0ffULL,
0x0000001007077824ULL, 0x000fe400078e0229ULL, 0x00000001090f7824ULL, 0x040fe200010e060fULL,
0x0000001608167210ULL, 0x000fe20007f5e0ffULL, 0x000000101a1b7824ULL, 0x000fe200078e0229ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a077faeULL, 0x0003e2000b901c48ULL,
0x0000000109117824ULL, 0x000fe200018e0611ULL, 0x0000001808087210ULL, 0x000fe20007f7e0ffULL,
0x000000101c1d7824ULL, 0x100fe200078e0229ULL, 0x000000000c1b7faeULL, 0x0003e2000b901c48ULL,
0x000000101e1f7824ULL, 0x000fc400078e0229ULL, 0x0000001020217824ULL, 0x000fe200078e0229ULL,
0x000000000e1d7faeULL, 0x0003e2000b901c48ULL, 0x0000000109137824ULL, 0x040fe400000e0613ULL,
0x0000000109157824ULL, 0x040fe200008e0615ULL, 0x00000000101f7faeULL, 0x0003e2000b901c48ULL,
0x0000001026277824ULL, 0x000fe400078e0229ULL, 0x0000000109177824ULL, 0x000fe200010e0617ULL,
0x0000000012217faeULL, 0x0003e2000b901c48ULL, 0x0000001028297824ULL, 0x000fc400078e0229ULL,
0x0000000109097824ULL, 0x000fe200018e0619ULL, 0x0000000014257faeULL, 0x0003e8000b901c48ULL,
0x0000000016277faeULL, 0x0003e8000b901c48ULL, 0x0000000008297faeULL, 0x0003e4000b901c48ULL,
0x00000300ff807624ULL, 0x000fe200078e00ffULL, 0x000000032a077812ULL, 0x006fe200078ec0ffULL,
0xffffffffff1a7424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xfffffffd2d807424ULL, 0x000fe200078e0280ULL, 0x000000030700780cULL, 0x000fc80003f05270ULL,
0x00000001801b7807ULL, 0x000fca0004000000ULL, 0x000000012a1b7824ULL, 0x000fca00078e021bULL,
0x000000941b00720cULL, 0x000fda0003f06070ULL, 0x00000002a0078824ULL, 0x000fe400078e00ffULL,
0x00006800ff088624ULL, 0x000fc800078e00ffULL, 0x0000680007088624ULL, 0x000fc800078e0208ULL,
0x0000000108088824ULL, 0x000fc800078e021bULL, 0x0000640008088625ULL, 0x000fca00078e002dULL,
0x00000008081a8981ULL, 0x000322000c1e1900ULL, 0x000000239600720cULL, 0x000fe20003f06070ULL,
0xff317217ff1c7424ULL, 0x000fe200078e00ffULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x000000ffff1e7224ULL, 0x000fe200078e00ffULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x0000804000000947ULL, 0x000fea0003800000ULL, 0x00000001a0077819ULL, 0x002fe200000006ffULL,
0x00006800ff087624ULL, 0x000fc400078e00ffULL, 0xff317217ff1c7424ULL, 0x000fe400078e00ffULL,
0x000000ffff277224ULL, 0x000fe400078e00ffULL, 0x0000680007077624ULL, 0x000fc400078e0208ULL,
0x000000109a087824ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0xffffffe0080f7812ULL, 0x000fe200078ec0ffULL, 0x000059001a1a7a24ULL, 0x010fe200078e02ffULL,
0x0000000196087810ULL, 0x000fc60007ffe0ffULL, 0x00000100960f7824ULL, 0x000fe200078e020fULL,
0x000000230800720cULL, 0x000fe20003f06070ULL, 0x000000401a0e7824ULL, 0x000fc600078e00ffULL,
0x000000400f117810ULL, 0x020fe20007ffe0ffULL, 0x00000100ff0f7424ULL, 0x000fc600078e00ffULL,
0x0000002011087812ULL, 0x000fe200078ec0ffULL, 0x000062000e0e7625ULL, 0x000fc800078e000fULL,
0x00000001056b7824ULL, 0x000fe200078e0208ULL, 0x0000068000008947ULL, 0x000fea0003800000ULL,
0x0000001195087217ULL, 0x000fe20007800000ULL, 0x0000001000127824ULL, 0x000fe200078e00ffULL,
0x00000003ff1f7819ULL, 0x100fe20000011600ULL, 0x000000809a107824ULL, 0x000fe400078e00ffULL,
0x0000000108087824ULL, 0x000fe200078e0a11ULL, 0x000000041f157810ULL, 0x040fe20007ffe0ffULL,
0x000020009a117824ULL, 0x000fe200078e00ffULL, 0x0000007012137812ULL, 0x000fe400078ec0ffULL,
0x000000081f177810ULL, 0x000fe20007ffe0ffULL, 0x00000008151a7824ULL, 0x000fe200078e00ffULL,
0x0000200011127812ULL, 0x000fe200078ec0ffULL, 0x0000000115117824ULL, 0x000fe200078e0200ULL,
0x0000000c1f1d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000817687824ULL, 0x000fe200078e00ffULL,
0x0000008013107812ULL, 0x000fe200078ef810ULL, 0x0000000117137824ULL, 0x100fe200078e0200ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee211ULL, 0x000000011d117824ULL, 0x000fe200078e0200ULL,
0x000000101f677810ULL, 0x000fe20007ffe0ffULL, 0x0000400003037824ULL, 0x000fe200078e0212ULL,
0x000000031d6a7819ULL, 0x000fc400000006ffULL, 0xfffffff868687812ULL, 0x000fe200078ee213ULL,
0x0000000167127824ULL, 0x040fe200078e0200ULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee211ULL,
0x0000000867197824ULL, 0x000fe200078e00ffULL, 0x000000141f697810ULL, 0x040fe20007ffe0ffULL,
0x000000011f137824ULL, 0x000fe200078e026bULL, 0x0000002008087817ULL, 0x000fe20003800000ULL,
0x000000ffff117224ULL, 0x000fe200078e00ffULL, 0xfffffff8196c7812ULL, 0x000fe200078ee212ULL,
0x0000000169147824ULL, 0x000fe200078e0200ULL, 0x000000081500720cULL, 0x080fe20003f66070ULL,
0x0000010013127825ULL, 0x000fe200078e0010ULL, 0x000000081700720cULL, 0x000fc40003f06070ULL,
0x000000081d00720cULL, 0x000fe20003f26070ULL, 0x0000000869217824ULL, 0x000fe200078e00ffULL,
0x000000120e187210ULL, 0x000fe20007f5e0ffULL, 0x0000000115157824ULL, 0x100fe200078e026bULL,
0x000000081f00720cULL, 0x000fe20003f86070ULL, 0x0000000117177824ULL, 0x000fe200078e026bULL,
0xfffffff8216e7812ULL, 0x000fe200078ee214ULL, 0x000000011f147824ULL, 0x000fe200078e0200ULL,
0x0000f00003037810ULL, 0x000fe20007ffe0ffULL, 0x000000010f197824ULL, 0x000fe200010e0613ULL,
0x000000181f6d7810ULL, 0x000fe20007ffe0ffULL, 0x0000010015127825ULL, 0x000fe200078e0010ULL,
0x0000000714217812ULL, 0x000fc400078ec0ffULL, 0x0000001c1f6f7810ULL, 0x000fe20007ffe0ffULL,
0x0000010017147825ULL, 0x000fe200078e0010ULL, 0x000000120e207210ULL, 0x040fe40007f5e0ffULL,
0x0ffffff821127812ULL, 0x000fe200078ef800ULL, 0x000000011d1d7824ULL, 0x000fe200078e026bULL,
0x000000140e647210ULL, 0x000fe20007fbe0ffULL, 0x000000010f217824ULL, 0x000fe200010e0613ULL,
0x000000086700720cULL, 0x000fe20003f46070ULL, 0x000001001d167825ULL, 0x000fc800078e0010ULL,
0x0000000167137824ULL, 0x000fe200078e026bULL, 0x000000160e167210ULL, 0x000fe20007fde0ffULL,
0x000000010f657824ULL, 0x000fe200028e0615ULL, 0x000000086900720cULL, 0x000fe20003fa6070ULL,
0x0000001012157824ULL, 0x000fe400078e0203ULL, 0x0000010013127825ULL, 0x000fc600078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018157faeULL, 0x0003e2000e101c48ULL,
0x00000001691f7824ULL, 0x000fe200078e026bULL, 0x0000006b6d697210ULL, 0x000fe20007ffe0ffULL,
0x000000010f177824ULL, 0x000fe200030e0617ULL, 0x000000120e667210ULL, 0x000fe20007fde0ffULL,
0x000000101a1d7824ULL, 0x000fe200078e0203ULL, 0x000000086d00720cULL, 0x000fc60003f86070ULL,
0x000000010f677824ULL, 0x000fe200030e0613ULL, 0x00000000201d7faeULL, 0x0005e2000d901c48ULL,
0x0000010069127825ULL, 0x000fe200078e0010ULL, 0x000000086f00720cULL, 0x000fc60003f66070ULL,
0x000001001f147825ULL, 0x002fc800078e0010ULL, 0x000000016f197824ULL, 0x000fe200078e026bULL,
0x000000140e147210ULL, 0x040fe20007fde0ffULL, 0x000000016d087824ULL, 0x140fe400078e0200ULL,
0x000000086d6d7824ULL, 0x000fe400078e00ffULL, 0x000000010f157824ULL, 0x000fe200030e0615ULL,
0x000000120e127210ULL, 0x000fe20007fde0ffULL, 0x000000016f187824ULL, 0x000fe200078e0200ULL,
0xfffffff86d087812ULL, 0x000fe200078ee208ULL, 0x000000086f6f7824ULL, 0x000fc400078e00ffULL,
0x0000010019107825ULL, 0x000fc600078e0010ULL, 0xfffffff86f187812ULL, 0x000fe200078ee218ULL,
0x000000010f137824ULL, 0x000fe200030e0613ULL, 0x000000100e0e7210ULL, 0x000fe20007fde0ffULL,
0x0000001068197824ULL, 0x100fe400078e0203ULL, 0x000000106a1d7824ULL, 0x104fe400078e0203ULL,
0x000000106c1f7824ULL, 0x100fe200078e0203ULL, 0x0000000064197faeULL, 0x0003e2000c101c48ULL,
0x000000106e217824ULL, 0x100fe400078e0203ULL, 0x0000001008697824ULL, 0x100fe200078e0203ULL,
0x00000000161d7faeULL, 0x0003e2000c901c48ULL, 0x0000001018037824ULL, 0x000fc400078e0203ULL,
0x000000010f0f7824ULL, 0x000fe200030e0611ULL, 0x00000000661f7faeULL, 0x0003e8000d101c48ULL,
0x0000000014217faeULL, 0x0003e8000e901c48ULL, 0x0000000012697faeULL, 0x0003e8000e101c48ULL,
0x000000000e037faeULL, 0x0003e2000d901c48ULL, 0x000005b000007947ULL, 0x000fea0003800000ULL,
0x0000001000087824ULL, 0x040fe200078e00ffULL, 0x0000000800157811ULL, 0x000fe200078fe8ffULL,
0x000020009a107824ULL, 0x000fe200078e00ffULL, 0x0000000400137811ULL, 0x000fe200078fe8ffULL,
0x000000809a677824ULL, 0x000fe200078e00ffULL, 0x0000007008087812ULL, 0x000fe200078ec0ffULL,
0x0000000815697824ULL, 0x000fe200078e00ffULL, 0x0000200010107812ULL, 0x000fe200078ec0ffULL,
0x0000000813127824ULL, 0x000fe200078e00ffULL, 0x0000008008667812ULL, 0x000fe200078ef867ULL,
0x0000000115087824ULL, 0x140fe200078e0200ULL, 0x0000000c00177811ULL, 0x040fe200078fe8ffULL,
0x000000ffff677224ULL, 0x000fe200078e00ffULL, 0x0000001400217811ULL, 0x040fe200078fe8ffULL,
0x0000000115157824ULL, 0x000fe200078e026bULL, 0x0000001003107211ULL, 0x000fe200078e70ffULL,
0x0000000113037824ULL, 0x100fe200078e0200ULL, 0x0000001000197811ULL, 0x040fe200078fe8ffULL,
0x0000000117117824ULL, 0x000fe200078e0200ULL, 0xfffffff869697812ULL, 0x000fe200078ee208ULL,
0x0000000817147824ULL, 0x000fe200078e00ffULL, 0x0000001800657811ULL, 0x000fe200078fe8ffULL,
0x0000000121087824ULL, 0x140fe200078e0200ULL, 0xfffffff8121f7812ULL, 0x000fe200078ee203ULL,
0x0000000821717824ULL, 0x000fe200078e00ffULL, 0xfffffff8146d7812ULL, 0x000fe200078ee211ULL,
0x0000000119037824ULL, 0x000fc400078e0200ULL, 0x0000000819127824ULL, 0x000fe200078e00ffULL,
0xfffffff871717812ULL, 0x000fe200078ee208ULL, 0x0000000165117824ULL, 0x140fe200078e0200ULL,
0x0000001c00087811ULL, 0x000fe200078fe8ffULL, 0x0000000865147824ULL, 0x000fe200078e00ffULL,
0xfffffff8126f7812ULL, 0x000fe200078ee203ULL, 0x0000000113137824ULL, 0x000fe200078e026bULL,
0x0000000000037211ULL, 0x000fe200078fe8ffULL, 0x0000000108127824ULL, 0x000fe200078e0200ULL,
0xfffffff814737812ULL, 0x000fe200078ee211ULL, 0x0000000117177824ULL, 0x100fe200078e026bULL,
0x0000006b00117211ULL, 0x000fe200078fe8ffULL, 0x0000000119197824ULL, 0x000fe200078e026bULL,
0x0000000308757819ULL, 0x000fe200000006ffULL, 0x0000010015147825ULL, 0x000fe200078e0066ULL,
0x00000007031d7812ULL, 0x000fc400078ec0ffULL, 0xfffffff875757812ULL, 0x000fe200078ee212ULL,
0x0000000108037824ULL, 0x000fe200078e026bULL, 0x0000f00010087810ULL, 0x000fe20007ffe0ffULL,
0x0000010011107825ULL, 0x000fe200078e0066ULL, 0x0ffffff81d1d7812ULL, 0x000fe400078ef800ULL,
0x000000140e147210ULL, 0x040fe20007f5e0ffULL, 0x0000010013127825ULL, 0x000fe200078e0066ULL,
0x000000100e107210ULL, 0x000fc60007f1e0ffULL, 0x0000000121217824ULL, 0x100fe200078e026bULL,
0x000000120e127210ULL, 0x000fe20007f3e0ffULL, 0x0000000165657824ULL, 0x000fe400078e026bULL,
0x0000010017167825ULL, 0x000fc800078e0066ULL, 0x0000010019187825ULL, 0x000fe200078e0066ULL,
0x000000160e167210ULL, 0x000fc60007f7e0ffULL, 0x0000010021207825ULL, 0x000fc800078e0066ULL,
0x0000010065647825ULL, 0x000fc800078e0066ULL, 0x0000010003667825ULL, 0x000fc800078e0066ULL,
0x000000010f117824ULL, 0x040fe200000e0611ULL, 0x000000180e187210ULL, 0x040fe20007f1e0ffULL,
0x000000010f137824ULL, 0x000fe200008e0613ULL, 0x000000200e207210ULL, 0x040fe20007f3e0ffULL,
0x000000101d037824ULL, 0x100fe400078e0208ULL, 0x000000010f157824ULL, 0x000fe200010e0615ULL,
0x000000640e647210ULL, 0x000fe20007f5e0ffULL, 0x000000101f1d7824ULL, 0x100fe200078e0208ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010037faeULL, 0x0003e2000b901c48ULL,
0x00000010691f7824ULL, 0x000fc400078e0208ULL, 0x000000010f177824ULL, 0x000fe200018e0617ULL,
0x000000660e0e7210ULL, 0x000fe20007f7e0ffULL, 0x000000106d697824ULL, 0x100fe200078e0208ULL,
0x00000000121d7faeULL, 0x0003e2000b901c48ULL, 0x000000106f6b7824ULL, 0x100fe400078e0208ULL,
0x000000010f197824ULL, 0x000fe200000e0619ULL, 0x00000000141f7faeULL, 0x0003e2000b901c48ULL,
0x00000010716d7824ULL, 0x100fe400078e0208ULL, 0x000000010f217824ULL, 0x000fe200008e0621ULL,
0x0000000016697faeULL, 0x0003e2000b901c48ULL, 0x00000010736f7824ULL, 0x000fc400078e0208ULL,
0x000000010f657824ULL, 0x040fe200010e0665ULL, 0x000000670f0f7210ULL, 0x000fe20001ffe4ffULL,
0x0000001075717824ULL, 0x000fe200078e0208ULL, 0x00000000186b7faeULL, 0x0003e8000b901c48ULL,
0x00000000206d7faeULL, 0x0003e8000b901c48ULL, 0x00000000646f7faeULL, 0x0003e8000b901c48ULL,
0x000000000e717faeULL, 0x0003e4000b901c48ULL, 0x000000031b037812ULL, 0x002fe200078ec0ffULL,
0xffffffffff1a7424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000030300780cULL, 0x000fc80003f05270ULL, 0x0000000180087807ULL, 0x000fca0004000000ULL,
0x00000001081b7824ULL, 0x000fca00078e021bULL, 0x000000941b00720cULL, 0x000fda0003f06070ULL,
0x00000001070e8824ULL, 0x000fe400078e021bULL, 0x00000004ff0f8424ULL, 0x000fc800078e00ffULL,
0x000064000e0e8625ULL, 0x000fca00078e000fULL, 0x000000080e1a8981ULL, 0x000322000c1e1900ULL,
0xffffffe022037812ULL, 0x040fe400078ec0ffULL, 0x0000001022087812ULL, 0x040fe400078ec0ffULL,
0x0000000822107812ULL, 0x000fc800078ec0ffULL, 0x0000000310037210ULL, 0x000fe20007ffe008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0166080003127f8cULL, 0x0022a4000c80043fULL,
0x00000000000e7805ULL, 0x000fc40000015200ULL, 0x01660c0003117984ULL, 0x000ee40000000800ULL,
0x8000000011ff7812ULL, 0x00cfe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x000000100e157210ULL, 0x000fca0007f1e1ffULL, 0x0000000111117824ULL, 0x000fe200000e0e0fULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011411ULL, 0x0000001508087211ULL, 0x000fca00078110ffULL,
0x000000ffff117224ULL, 0x000fca00000e0611ULL, 0x0000000208087819ULL, 0x000fc80000001211ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01660c0003117984ULL, 0x000ea40000000800ULL, 0x8000000011ff7812ULL, 0x004fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000087824ULL, 0x000fe200078e00ffULL,
0x00000001ff7c7819ULL, 0x000fe20000011600ULL, 0x000000209a037824ULL, 0x002fe400078e00ffULL,
0xffffffffff817424ULL, 0x000fe200078e00ffULL, 0x0000007008087812ULL, 0x000fc400078ec0ffULL,
0xffffff8003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c7c7c7812ULL, 0x000fc800078ec0ffULL,
0x000000037c037210ULL, 0x000fca0007ffe008ULL, 0x01600000030f7984ULL, 0x000e680000000800ULL,
0x01620000030e7984ULL, 0x0004e20000000800ULL, 0x0000001c0f00720bULL, 0x002fe20003f1d000ULL,
0x000157927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x004fc800000e0100ULL,
0x000000ff1000720cULL, 0x000fe20003f25270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff037224ULL, 0x000fe400078e001cULL,
0x0000001fff847424ULL, 0x000fc400078e00ffULL, 0xffffffffff827424ULL, 0x000fcc00078e00ffULL,
0x0000070000009947ULL, 0x000fea0003800000ULL, 0x0000009a0200720cULL, 0x000fe40003f25270ULL,
0x0000001c0f00720bULL, 0x000fe20003f54000ULL, 0x000157327f007947ULL, 0x000fd8000b800000ULL,
0x0000000000117806ULL, 0x000fc400010e0100ULL, 0x000000809a139824ULL, 0x000fe200078e0208ULL,
0x0000001c0f037209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000017c129824ULL, 0x000fca00078e0213ULL, 0x0164000312009388ULL, 0x0003e20000000800ULL,
0x000000ff1100720cULL, 0x000fda0003f25270ULL, 0x000005e000009947ULL, 0x000fea0003800000ULL,
0x0000001c03127221ULL, 0x002fe20000010100ULL, 0x000000ff11ff7812ULL, 0x000fe2000782c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b12127820ULL, 0x000fcc0000410000ULL,
0x0000001200127308ULL, 0x000e640000000800ULL, 0x000000121e1e7220ULL, 0x002fe40000410000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000002ff1f7819ULL, 0x000fe20000011600ULL,
0x000156727f007947ULL, 0x000fea000b800000ULL, 0x00001f1f121f7589ULL, 0x0002a400000e0000ULL,
0x0000001f60607220ULL, 0x084fe20000410000ULL, 0x0000001f61617220ULL, 0x080fe20000410000ULL,
0x0000001f5c5c7220ULL, 0x080fe20000410000ULL, 0x0000001f5d5d7220ULL, 0x080fe20000410000ULL,
0x0000001f58587220ULL, 0x080fe20000410000ULL, 0x0000001f59597220ULL, 0x080fe20000410000ULL,
0x0000001f54547220ULL, 0x080fe20000410000ULL, 0x0000001f55557220ULL, 0x080fe20000410000ULL,
0x0000001f50507220ULL, 0x080fe20000410000ULL, 0x0000001f51517220ULL, 0x080fe20000410000ULL,
0x0000001f4c4c7220ULL, 0x080fe20000410000ULL, 0x0000001f4d4d7220ULL, 0x080fe20000410000ULL,
0x0000001f48487220ULL, 0x080fe20000410000ULL, 0x0000001f49497220ULL, 0x080fe20000410000ULL,
0x0000001f44447220ULL, 0x080fe20000410000ULL, 0x0000001f45457220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0011ff7812ULL, 0x000fe2000782c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000008001f7811ULL, 0x000fe200078ff0ffULL, 0x000155427f007947ULL, 0x000fea000b800000ULL,
0x00001f1f121f7589ULL, 0x00046400000e0000ULL, 0x0000001f62627220ULL, 0x086fe20000410000ULL,
0x0000001f63637220ULL, 0x080fe20000410000ULL, 0x0000001f5e5e7220ULL, 0x080fe20000410000ULL,
0x0000001f5f5f7220ULL, 0x080fe20000410000ULL, 0x0000001f5a5a7220ULL, 0x080fe20000410000ULL,
0x0000001f5b5b7220ULL, 0x080fe20000410000ULL, 0x0000001f56567220ULL, 0x080fe20000410000ULL,
0x0000001f57577220ULL, 0x080fe20000410000ULL, 0x0000001f52527220ULL, 0x080fe20000410000ULL,
0x0000001f53537220ULL, 0x080fe20000410000ULL, 0x0000001f4e4e7220ULL, 0x080fe20000410000ULL,
0x0000001f4f4f7220ULL, 0x080fe20000410000ULL, 0x0000001f4a4a7220ULL, 0x080fe20000410000ULL,
0x0000001f4b4b7220ULL, 0x080fe20000410000ULL, 0x0000001f46467220ULL, 0x080fe20000410000ULL,
0x0000001f47477220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000011ff7812ULL, 0x000fe2000782c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000010001f7811ULL, 0x000fe200078ff0ffULL,
0x000154127f007947ULL, 0x000fea000b800000ULL, 0x00001f1f121f7589ULL, 0x00046400000e0000ULL,
0x0000001f40407220ULL, 0x086fe20000410000ULL, 0x0000001f41417220ULL, 0x080fe20000410000ULL,
0x0000001f3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001f3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001f38387220ULL, 0x080fe20000410000ULL, 0x0000001f39397220ULL, 0x080fe20000410000ULL,
0x0000001f34347220ULL, 0x080fe20000410000ULL, 0x0000001f35357220ULL, 0x080fe20000410000ULL,
0x0000001f30307220ULL, 0x080fe20000410000ULL, 0x0000001f31317220ULL, 0x080fe20000410000ULL,
0x0000001f2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001f2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001f28287220ULL, 0x080fe20000410000ULL, 0x0000001f29297220ULL, 0x080fe20000410000ULL,
0x0000001f24247220ULL, 0x080fe20000410000ULL, 0x0000001f25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000011ff7812ULL, 0x000fda000782c0ffULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000018001f7811ULL, 0x000fe200078ff0ffULL,
0x000152f27f007947ULL, 0x000fea000b800000ULL, 0x00001f1f121f7589ULL, 0x00046400000e0000ULL,
0x0000001f42427220ULL, 0x086fe20000410000ULL, 0x0000001f43437220ULL, 0x080fe20000410000ULL,
0x0000001f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001f3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001f36367220ULL, 0x080fe20000410000ULL, 0x0000001f37377220ULL, 0x080fe20000410000ULL,
0x0000001f32327220ULL, 0x080fe20000410000ULL, 0x0000001f33337220ULL, 0x080fe20000410000ULL,
0x0000001f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001f2a2a7220ULL, 0x080fe20000410000ULL, 0x0000001f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001f26267220ULL, 0x080fe20000410000ULL, 0x0000001f27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000001110ff7212ULL, 0x000fda00078230ffULL,
0x800000030f0f1221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b0f0f1820ULL, 0x000fc80000410000ULL, 0x0000000f00091308ULL, 0x000e640000000800ULL,
0x000000090e0e1220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000001e0e1e7221ULL, 0x008fe20000010000ULL, 0x000000d000008947ULL, 0x000fea0003800000ULL,
0x00000009ff0a723eULL, 0x000fe400000000ffULL, 0x00000002ff0d7819ULL, 0x000fe40000011600ULL,
0x000054100a0e7816ULL, 0x000fe2000000000aULL, 0x000151227f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0e0a7589ULL, 0x0002a400000e0000ULL, 0x000000080d1f7810ULL, 0x000fe20007ffe0ffULL,
0x000151527f007947ULL, 0x000fea000b800000ULL, 0x000000100d0f7810ULL, 0x000fe20007ffe0ffULL,
0x00001f1f0e0b7589ULL, 0x00066800000e0000ULL, 0x00001f0f0e0c7589ULL, 0x0006a400000e0000ULL,
0x000000180d1f7810ULL, 0x008fe20007ffe0ffULL, 0x000151a27f007947ULL, 0x000fea000b800000ULL,
0x00001f1f0e0d7589ULL, 0x0022e400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000029a1c7824ULL, 0x000fe200078e00ffULL, 0x00000008000f7812ULL, 0x000fe200078ec0ffULL,
0x000004009a117824ULL, 0x040fe200078e00ffULL, 0x0000000d9a1d7819ULL, 0x000fe200000006ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000041c1f7812ULL, 0x002fe200078ec0ffULL,
0x000002b000007945ULL, 0x000fe20003800000ULL, 0x000000070f197812ULL, 0x000fc400078ef800ULL,
0x0000001f00107211ULL, 0x040fe400078fe0ffULL, 0x0000001019217812ULL, 0x040fe200078efcffULL,
0x00000008190f7824ULL, 0x040fe200078e00ffULL, 0x0000001900127211ULL, 0x000fe200078fe0ffULL,
0x00000001190e7824ULL, 0x000fe200078e0210ULL, 0xffffc0001d157812ULL, 0x000fe200078ec0ffULL,
0x0000000819137824ULL, 0x000fe200078e00ffULL, 0x0000000612167810ULL, 0x000fe20007ffe0ffULL,
0x0000000821147824ULL, 0x000fe200078e00ffULL, 0xfffffff80f0e7812ULL, 0x000fe200078ee20eULL,
0x00000001100f7824ULL, 0x000fe200078e0221ULL, 0x0000000212107810ULL, 0x000fe20007ffe0ffULL,
0x0000000819177824ULL, 0x000fc400078e00ffULL, 0x0000200006157824ULL, 0x000fe200078e0215ULL,
0xfffffff813107812ULL, 0x000fe200078ee210ULL, 0x0000000819657824ULL, 0x000fe200078e00ffULL,
0xfffff00011137812ULL, 0x000fe200078ec0ffULL, 0x0000000819117824ULL, 0x000fe200078e00ffULL,
0xfffffff8140f7812ULL, 0x000fe400078ee20fULL, 0x0000a00013207810ULL, 0x000fe40007ffe0ffULL,
0x0000000412147810ULL, 0x000fe40007ffe0ffULL, 0xfffffff811117812ULL, 0x000fe200078ee212ULL,
0x000000100e747824ULL, 0x000fe200078e0220ULL, 0xfffffff817127812ULL, 0x000fe200078ee214ULL,
0x000000100f647824ULL, 0x000fe200078e0220ULL, 0x0000e00015157810ULL, 0x000fc40007ffe0ffULL,
0xfffffff865137812ULL, 0x000fe200078ee216ULL, 0x000000007474783bULL, 0x000e640000000200ULL,
0x0000001011707824ULL, 0x100fe400078e0215ULL, 0x000000006464783bULL, 0x000ee20000000200ULL,
0x00000010106c7824ULL, 0x100fe400078e0215ULL, 0x0000001012147824ULL, 0x000fe200078e0215ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000000a74747232ULL, 0x086fe40000000000ULL,
0x0000000a76767232ULL, 0x000fc40000000000ULL, 0x0000000b75757232ULL, 0x080fe40000000000ULL,
0x0000000b77777232ULL, 0x000fe40000000000ULL, 0x0000000c64647232ULL, 0x088fe40000000000ULL,
0x0000000c66667232ULL, 0x000fe40000000000ULL, 0x0000000d65657232ULL, 0x080fe40000000000ULL,
0x0000000d67677232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001013687824ULL, 0x000fe200078e0215ULL, 0x000000006c6c783bULL, 0x000ee20000004200ULL,
0x000000021f1f7812ULL, 0x000fe200078efcffULL, 0x0000000821187824ULL, 0x040fe200078e00ffULL,
0x00000001ff857819ULL, 0x000fe2000001169aULL, 0x000000001414783bULL, 0x000ea20000004200ULL,
0x0000037000007945ULL, 0x000fe60003800000ULL, 0x000000006868783bULL, 0x000e680000004200ULL,
0x000000007070783bULL, 0x000e640000004200ULL, 0x0000006c7458723cULL, 0x04af700000001858ULL,
0x000000147450723cULL, 0x084f700000001850ULL, 0x000000146430723cULL, 0x000b6e0000001830ULL,
0x0000001f00147211ULL, 0x020fe200078fe0ffULL, 0x00000016744c723cULL, 0x000f68000000184cULL,
0x0000000121157824ULL, 0x000fc800078e0214ULL, 0x00000016642c723cULL, 0x000b62000000182cULL,
0xfffffff818157812ULL, 0x000fcc00078ee215ULL, 0x0000000819167824ULL, 0x060fe200078e00ffULL,
0x0000002100177211ULL, 0x000fe200078fe0ffULL, 0x0000000119197824ULL, 0x000fe200078e0214ULL,
0x000000687448723cULL, 0x080f640000001848ULL, 0x0000000217187810ULL, 0x000fe40007ffe0ffULL,
0xfffffff816147812ULL, 0x000fe200078ee219ULL, 0x0000000821167824ULL, 0x000fe200078e00ffULL,
0x0000000417197810ULL, 0x000fe40007ffe0ffULL, 0x000000686428723cULL, 0x000b620000001828ULL,
0x0000001014787824ULL, 0x100fe200078e0220ULL, 0xfffffff816167812ULL, 0x000fe200078ee217ULL,
0x0000001015207824ULL, 0x000fe200078e0220ULL, 0x00000006171f7810ULL, 0x000fc60007ffe0ffULL,
0x0000000821697824ULL, 0x060fe200078e00ffULL, 0x0000006c6438723cULL, 0x040b620000001838ULL,
0x0000000821687824ULL, 0x000fe200078e00ffULL, 0x000000007878783bULL, 0x000e640000000200ULL,
0xfffffff869177812ULL, 0x000fe400078ee218ULL, 0xfffffff868187812ULL, 0x000fe200078ee219ULL,
0x00000008216c7824ULL, 0x020fe200078e00ffULL, 0x0000000685217211ULL, 0x000fe200078e08ffULL,
0x000000706440723cULL, 0x000f660000001840ULL, 0x0000e00021217811ULL, 0x000fc400078e68ffULL,
0xfffffff86c197812ULL, 0x000fc600078ee21fULL, 0x00000072643c723cULL, 0x000f62000000183cULL,
0x00000010166c7824ULL, 0x000fce00078e0221ULL, 0x0000006e6434723cULL, 0x040f700000001834ULL,
0x0000006a6424723cULL, 0x000b640000001824ULL, 0x000000002064783bULL, 0x0204ec0000000200ULL,
0x000000707460723cULL, 0x040b6e0000001860ULL, 0x0000001018707824ULL, 0x120fe200078e0221ULL,
0x00000072745c723cULL, 0x040f70000000185cULL, 0x0000006e7454723cULL, 0x040f700000001854ULL,
0x0000006a7444723cULL, 0x000b6e0000001844ULL, 0x0000001017747824ULL, 0x020fe200078e0221ULL,
0x0000008000008947ULL, 0x000fd60003800000ULL, 0x0000000a78787232ULL, 0x086fe40000000000ULL,
0x0000000a7a7a7232ULL, 0x000fc40000000000ULL, 0x0000000b79797232ULL, 0x080fe40000000000ULL,
0x0000000b7b7b7232ULL, 0x000fe40000000000ULL, 0x0000000c64647232ULL, 0x088fe40000000000ULL,
0x0000000c66667232ULL, 0x000fe40000000000ULL, 0x0000000d65657232ULL, 0x080fe40000000000ULL,
0x0000000d67677232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x006fea0003800000ULL,
0x0000001019687824ULL, 0x000fe200078e0221ULL, 0x000000006c6c783bULL, 0x000e620000004200ULL,
0x000059001a1a7a24ULL, 0x010fe200078e02ffULL, 0xfffffff81c1c7812ULL, 0x000fe200078ec0ffULL,
0x00000008961f7824ULL, 0x000fe200078e0285ULL, 0x000000007474783bULL, 0x000ea80000004200ULL,
0x000000007070783bULL, 0x000ee80000004200ULL, 0x000000006868783bULL, 0x000ea20000004200ULL,
0x0000006c7860723cULL, 0x042b700000001860ULL, 0x0000006e785c723cULL, 0x040b70000000185cULL,
0x000000747858723cULL, 0x044b700000001858ULL, 0x000000767854723cULL, 0x040b700000001854ULL,
0x000000707850723cULL, 0x048b700000001850ULL, 0x00000072784c723cULL, 0x040b70000000184cULL,
0x000000687848723cULL, 0x040b700000001848ULL, 0x0000006a7844723cULL, 0x000b700000001844ULL,
0x000000746438723cULL, 0x040b700000001838ULL, 0x000000766434723cULL, 0x040b700000001834ULL,
0x000000706430723cULL, 0x040b700000001830ULL, 0x00000072642c723cULL, 0x040b70000000182cULL,
0x0000006c6440723cULL, 0x040b700000001840ULL, 0x0000006e643c723cULL, 0x040b70000000183cULL,
0x000000686428723cULL, 0x040b700000001828ULL, 0x0000006a6424723cULL, 0x000b620000001824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x0000000196647810ULL, 0x020fe20007ffe0ffULL,
0x000000401a207824ULL, 0x000fe200078e00ffULL, 0x000000801f1f7811ULL, 0x000fe200078e28ffULL,
0x016688001cff7f8cULL, 0x0003e2000c80043fULL, 0x000000236400720cULL, 0x000fe20003f06070ULL,
0x00000100ff217424ULL, 0x000fe200078e00ffULL, 0x000000201f1a7812ULL, 0x000fc600078ec0ffULL,
0x0000620020207625ULL, 0x000fc800078e0021ULL, 0x0000000105797824ULL, 0x000fe200078e021aULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000065000008947ULL, 0x000fea0003800000ULL,
0x000020001d1a7812ULL, 0x002fe200078ec0ffULL, 0x000000809a1d7824ULL, 0x000fe200078e00ffULL,
0x00000003ff717819ULL, 0x000fc60000011600ULL, 0x0000400085857824ULL, 0x000fe200078e021aULL,
0x0000001f951a7217ULL, 0x000fe40007800000ULL, 0x0000000471677810ULL, 0x040fe40007ffe0ffULL,
0x0000000871697810ULL, 0x040fe20007ffe0ffULL, 0x000000011a1a7824ULL, 0x000fe200078e0a1fULL,
0x0000001471757810ULL, 0x000fe20007ffe0ffULL, 0x00000001671c7824ULL, 0x100fe200078e0200ULL,
0x00000010716f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000867657824ULL, 0x000fe200078e00ffULL,
0x000000201a1a7817ULL, 0x000fe20003800000ULL, 0x0000000169647824ULL, 0x000fe200078e0200ULL,
0x0000000c711f7810ULL, 0x000fe20007ffe0ffULL, 0x00000008696b7824ULL, 0x000fe200078e00ffULL,
0xfffffff865707812ULL, 0x000fe200078ee21cULL, 0x0000000171657824ULL, 0x000fe200078e0279ULL,
0x00000080081c7812ULL, 0x000fe200078ef81dULL, 0x000000ffff1d7224ULL, 0x000fe200078e00ffULL,
0x0000001a6700720cULL, 0x080fe20003f86070ULL, 0x00000001756c7824ULL, 0x000fe200078e0200ULL,
0x0000007967677210ULL, 0x000fe20007ffe0ffULL, 0x0000000875737824ULL, 0x000fe200078e00ffULL,
0xfffffff86b727812ULL, 0x000fe200078ee264ULL, 0x0000010065647825ULL, 0x000fe200078e001cULL,
0x0000001a1f00720cULL, 0x000fc40003f46070ULL, 0xfffffff873787812ULL, 0x000fe200078ee26cULL,
0x0000010067667825ULL, 0x000fe200078e001cULL, 0x00000064206a7210ULL, 0x040fe40007f1e0ffULL,
0x0000001a6900720cULL, 0x000fe20003f66070ULL, 0x000000016f6b7824ULL, 0x140fe200078e0200ULL,
0x00000066206c7210ULL, 0x000fe20007f3e0ffULL, 0x000000086f767824ULL, 0x000fe200078e00ffULL,
0x0000001a7100720cULL, 0x000fe20003fa6070ULL, 0x000000011f687824ULL, 0x000fe200078e0200ULL,
0x00000018717b7810ULL, 0x000fe20007ffe0ffULL, 0x000000081f6d7824ULL, 0x000fe200078e00ffULL,
0xfffffff876767812ULL, 0x000fe200078ee26bULL, 0x00000001216b7824ULL, 0x000fc400000e0665ULL,
0x0000000169657824ULL, 0x000fe200078e0279ULL, 0xfffffff86d747812ULL, 0x000fe200078ee268ULL,
0x00000001216d7824ULL, 0x000fe200008e0667ULL, 0x0000001a6f00720cULL, 0x000fe20003f26070ULL,
0x000000011f677824ULL, 0x000fe400078e0279ULL, 0x00000001711f7824ULL, 0x000fe400078e0200ULL,
0x0000010065647825ULL, 0x000fc600078e001cULL, 0x000000071f737812ULL, 0x000fe200078ec0ffULL,
0x0000010067667825ULL, 0x000fe200078e001cULL, 0x00000064206e7210ULL, 0x040fe40007f1e0ffULL,
0x0000e000851f7810ULL, 0x000fe20007ffe0ffULL, 0x000000016f697824ULL, 0x000fe200078e0279ULL,
0x0000006620667210ULL, 0x000fe20007fde0ffULL, 0x00000001216f7824ULL, 0x000fe200000e0665ULL,
0x0ffffff873647812ULL, 0x000fe200078ef800ULL, 0x0000010069687825ULL, 0x000fe200078e001cULL,
0x0000001a7500720cULL, 0x000fc40003f06070ULL, 0x0000001c71857810ULL, 0x000fe20007ffe0ffULL,
0x0000000175657824ULL, 0x000fe200078e0279ULL, 0x0000001f70757211ULL, 0x000fe200078e20ffULL,
0x0000000121677824ULL, 0x000fe200030e0667ULL, 0x0000006820687210ULL, 0x000fe20007fde0ffULL,
0x0000001064737824ULL, 0x000fe400078e021fULL, 0x0000010065647825ULL, 0x000fc600078e001cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a737faeULL, 0x0003e2000e901c48ULL,
0x0000000121697824ULL, 0x000fe200030e0669ULL, 0x0000006420707210ULL, 0x000fe20007fde0ffULL,
0x000000017b777824ULL, 0x100fe200078e0279ULL, 0x000000006c757faeULL, 0x0005e2000e101c48ULL,
0x0000000185797824ULL, 0x000fe200078e0279ULL, 0x0000001a7b00720cULL, 0x080fe20003fa6070ULL,
0x0000000121717824ULL, 0x000fe200030e0665ULL, 0x0000001a8500720cULL, 0x000fe20003f86070ULL,
0x0000010077647825ULL, 0x000fc800078e001cULL, 0x000000017b1a7824ULL, 0x140fe200078e0200ULL,
0x0000006420647210ULL, 0x000fe20007fde0ffULL, 0x000000087b7b7824ULL, 0x000fe400078e00ffULL,
0x00000001856a7824ULL, 0x042fe400078e0200ULL, 0x0000000885857824ULL, 0x000fe200078e00ffULL,
0xfffffff87b1a7812ULL, 0x000fe200078ee21aULL, 0x00000100791c7825ULL, 0x000fc600078e001cULL,
0xfffffff8856a7812ULL, 0x000fe200078ee26aULL, 0x0000000121657824ULL, 0x000fe200030e0665ULL,
0x0000001c201c7210ULL, 0x000fe20007fde0ffULL, 0x00000010726b7824ULL, 0x100fe400078e021fULL,
0x00000010746d7824ULL, 0x104fe400078e021fULL, 0x0000001076737824ULL, 0x100fe200078e021fULL,
0x000000006e6b7faeULL, 0x0003e2000d901c48ULL, 0x0000001078757824ULL, 0x100fe400078e021fULL,
0x000000101a777824ULL, 0x100fe200078e021fULL, 0x00000000666d7faeULL, 0x0003e2000d101c48ULL,
0x000000106a1f7824ULL, 0x000fc400078e021fULL, 0x00000001211d7824ULL, 0x000fe200030e061dULL,
0x0000000068737faeULL, 0x0003e8000c901c48ULL, 0x0000000070757faeULL, 0x0003e8000c101c48ULL,
0x0000000064777faeULL, 0x0003e8000e901c48ULL, 0x000000001c1f7faeULL, 0x0003e2000e101c48ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x000020001d1a7812ULL, 0x002fe200078ec0ffULL,
0x000000809a717824ULL, 0x000fe200078e00ffULL, 0x0000000c00697811ULL, 0x000fc400078fe8ffULL,
0x0000000400657811ULL, 0x040fe200078fe8ffULL, 0x0000400085857824ULL, 0x000fe200078e021aULL,
0x0000000800677811ULL, 0x040fe200078fe8ffULL, 0x00000001691d7824ULL, 0x140fe200078e0200ULL,
0x00000018006f7811ULL, 0x040fe200078fe8ffULL, 0x0000000869647824ULL, 0x000fe200078e00ffULL,
0x00000010006b7811ULL, 0x000fe200078fe8ffULL, 0x00000001651a7824ULL, 0x100fe200078e0200ULL,
0x00000000671c7210ULL, 0x080fe20007ffe0ffULL, 0x0000000865757824ULL, 0x000fe200078e00ffULL,
0xfffffff8647b7812ULL, 0x000fe200078ee21dULL, 0x0000000867777824ULL, 0x000fe200078e00ffULL,
0x00000014006d7811ULL, 0x000fe200078fe8ffULL, 0x000000016f1d7824ULL, 0x000fe200078e0200ULL,
0xfffffff875757812ULL, 0x000fe200078ee21aULL, 0x000000086f647824ULL, 0x000fe200078e00ffULL,
0xfffffff877777812ULL, 0x000fe200078ee21cULL, 0x000000016b1a7824ULL, 0x140fe200078e0200ULL,
0x0000008008707812ULL, 0x000fe200078ef871ULL, 0x000000086b877824ULL, 0x000fe200078e00ffULL,
0xfffffff8648b7812ULL, 0x000fe200078ee21dULL, 0x000000016d1c7824ULL, 0x040fe200078e0200ULL,
0x00000079001d7211ULL, 0x040fe200078fe8ffULL, 0x000000086d897824ULL, 0x000fe200078e00ffULL,
0xfffffff887877812ULL, 0x000fe200078ee21aULL, 0x000000ffff717224ULL, 0x000fe200078e00ffULL,
0x00000000001a7211ULL, 0x040fe200078fe8ffULL, 0x0000000165657824ULL, 0x100fe200078e0279ULL,
0x0000001c001f7811ULL, 0x000fe200078fe8ffULL, 0x0000000167677824ULL, 0x100fe200078e0279ULL,
0xfffffff889897812ULL, 0x000fe200078ee21cULL, 0x0000000169697824ULL, 0x000fe200078e0279ULL,
0x000000071a737812ULL, 0x000fe200078ec0ffULL, 0x000001001d1c7825ULL, 0x000fc600078e0070ULL,
0x0ffffff873737812ULL, 0x100fe200078ef800ULL, 0x000000011f1a7824ULL, 0x040fe200078e0200ULL,
0x0000001c201c7210ULL, 0x000fe20007f1e0ffULL, 0x000000081f8d7824ULL, 0x040fe200078e00ffULL,
0x000000791f1f7210ULL, 0x000fe20007ffe0ffULL, 0x0000010065647825ULL, 0x000fc600078e0070ULL,
0xfffffff88d8d7812ULL, 0x000fe200078ee21aULL, 0x000000016b6b7824ULL, 0x000fe200078e0279ULL,
0x0000006420647210ULL, 0x000fe20007f3e0ffULL, 0x0000010067667825ULL, 0x000fe200078e0070ULL,
0x0000e000851a7810ULL, 0x000fc60007ffe0ffULL, 0x000000016d6d7824ULL, 0x000fe200078e0279ULL,
0x0000006620667210ULL, 0x000fe20007f5e0ffULL, 0x0000010069687825ULL, 0x000fc800078e0070ULL,
0x000000016f6f7824ULL, 0x000fe200078e0279ULL, 0x0000006820687210ULL, 0x000fe20007f7e0ffULL,
0x000001006b6a7825ULL, 0x000fc800078e0070ULL, 0x000001006d6c7825ULL, 0x000fc800078e0070ULL,
0x000001006f6e7825ULL, 0x000fc800078e0070ULL, 0x000001001f707825ULL, 0x000fc800078e0070ULL,
0x00000001211d7824ULL, 0x040fe200000e061dULL, 0x0000006a206a7210ULL, 0x040fe20007f1e0ffULL,
0x0000000121657824ULL, 0x000fe200008e0665ULL, 0x0000006c206c7210ULL, 0x040fe20007f3e0ffULL,
0x00000010731f7824ULL, 0x100fe400078e021aULL, 0x0000000121677824ULL, 0x000fe200010e0667ULL,
0x0000006e206e7210ULL, 0x040fe20007f5e0ffULL, 0x0000001075737824ULL, 0x100fe200078e021aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c1f7faeULL, 0x0003e2000b901c48ULL,
0x0000000121697824ULL, 0x000fe200018e0669ULL, 0x0000007020207210ULL, 0x000fe20007f7e0ffULL,
0x0000001077757824ULL, 0x100fe200078e021aULL, 0x0000000064737faeULL, 0x0003e2000b901c48ULL,
0x000000107b777824ULL, 0x000fc400078e021aULL, 0x0000001087797824ULL, 0x100fe200078e021aULL,
0x0000000066757faeULL, 0x0003e2000b901c48ULL, 0x00000001216b7824ULL, 0x000fe400000e066bULL,
0x00000010897b7824ULL, 0x100fe200078e021aULL, 0x0000000068777faeULL, 0x0003e2000b901c48ULL,
0x00000001216d7824ULL, 0x000fe400008e066dULL, 0x000000108b857824ULL, 0x000fe200078e021aULL,
0x000000006a797faeULL, 0x0003e2000b901c48ULL, 0x00000001216f7824ULL, 0x000fc400010e066fULL,
0x000000108d877824ULL, 0x000fe200078e021aULL, 0x000000006c7b7faeULL, 0x0003e2000b901c48ULL,
0x0000000121217824ULL, 0x000fc600018e0671ULL, 0x000000006e857faeULL, 0x0003e8000b901c48ULL,
0x0000000020877faeULL, 0x0003e4000b901c48ULL, 0x000000031b1a7812ULL, 0x000fe200078ec0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000031a00780cULL, 0x000fc80003f05270ULL,
0x00000001801a7807ULL, 0x000fca0004000000ULL, 0x000000011b1b7824ULL, 0x000fe400078e021aULL,
0xffffffffff1a7424ULL, 0x000fc600078e00ffULL, 0x000000941b00720cULL, 0x000fda0003f06070ULL,
0x0000001b071c8210ULL, 0x002fe20007ffe0ffULL, 0x00000004ff1d8424ULL, 0x000fc800078e00ffULL,
0x000064001c1c8625ULL, 0x000fca00078e001dULL, 0x000000081c1a8981ULL, 0x000322000c1e1900ULL,
0xffffffe0221f7812ULL, 0x040fe400078ec0ffULL, 0x0000001022207812ULL, 0x040fe400078ec0ffULL,
0x0000000822217812ULL, 0x000fc800078ec0ffULL, 0x0000001f21667210ULL, 0x000fe20007ffe020ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0166280066647f8cULL, 0x0022a4000c80043fULL,
0x00000000001c7805ULL, 0x000fc40000015200ULL, 0x01662c00661f7984ULL, 0x000ee40000000800ULL,
0x800000001fff7812ULL, 0x00cfe40007804865ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff677224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106700780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x000000201c207210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e1dULL,
0x003d09002000780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402000780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1f7819ULL, 0x000fc80000011421ULL, 0x000000201f1f7211ULL, 0x000fca00078110ffULL,
0x000000ffff207224ULL, 0x000fca00000e0621ULL, 0x000000021f1f7819ULL, 0x000fc80000001220ULL,
0x0000001f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000167677810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01662c00661f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x004fe40007804865ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000209a1c7824ULL, 0x000fca00078e00ffULL,
0xffffff801c1d7812ULL, 0x000fc800078ec0ffULL, 0x00000080081d7810ULL, 0x000fca0007ffe01dULL,
0x000000017c1d7824ULL, 0x000fca00078e021dULL, 0x016000001d647984ULL, 0x000ea80000000800ULL,
0x016200001d657984ULL, 0x0006620000000800ULL, 0x000000036400720bULL, 0x004fe20003f1d000ULL,
0x000138827f007947ULL, 0x000fd8000b800000ULL, 0x00000000001d7806ULL, 0x008fc800000e0100ULL,
0x000000ff1d00720cULL, 0x000fe20003f25270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fe20003f0e170ULL, 0x000000ffff1c7224ULL, 0x000fd400078e0003ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x00000001021f7810ULL, 0x000fe40007ffe0ffULL,
0x000000036400720bULL, 0x000fe40003f34000ULL, 0x0000009a1f00720cULL, 0x000fe20003f05270ULL,
0x000138327f007947ULL, 0x000fd4000b800000ULL, 0x00000000001c7806ULL, 0x000fc400008e0100ULL,
0x000000809a218824ULL, 0x000fe200078e0208ULL, 0x00000003641f8209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x000000017c208824ULL, 0x000fca00078e0221ULL,
0x0164001f20008388ULL, 0x0005e20000000800ULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000000364207209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff1cff7812ULL, 0x000fc6000780c0ffULL,
0x00000003201f7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b1f1f7820ULL, 0x000fc80000410000ULL,
0x0000001f00677308ULL, 0x000ea40000000800ULL, 0x000000671e1e7220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1f7819ULL, 0x000fe20000011600ULL,
0x000137627f007947ULL, 0x000fea000b800000ULL, 0x00001f1f671f7589ULL, 0x0004e400000e0000ULL,
0x0000001f60607220ULL, 0x08cfe20000410000ULL, 0x0000001f61617220ULL, 0x080fe20000410000ULL,
0x0000001f5c5c7220ULL, 0x080fe20000410000ULL, 0x0000001f5d5d7220ULL, 0x080fe20000410000ULL,
0x0000001f58587220ULL, 0x080fe20000410000ULL, 0x0000001f59597220ULL, 0x080fe20000410000ULL,
0x0000001f54547220ULL, 0x080fe20000410000ULL, 0x0000001f55557220ULL, 0x080fe20000410000ULL,
0x0000001f50507220ULL, 0x080fe20000410000ULL, 0x0000001f51517220ULL, 0x080fe20000410000ULL,
0x0000001f4c4c7220ULL, 0x080fe20000410000ULL, 0x0000001f4d4d7220ULL, 0x080fe20000410000ULL,
0x0000001f48487220ULL, 0x080fe20000410000ULL, 0x0000001f49497220ULL, 0x080fe20000410000ULL,
0x0000001f44447220ULL, 0x080fe20000410000ULL, 0x0000001f45457220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff001cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008001f7811ULL, 0x000fe200078ff0ffULL, 0x000136327f007947ULL, 0x000fea000b800000ULL,
0x00001f1f671f7589ULL, 0x0004e400000e0000ULL, 0x0000001f62627220ULL, 0x08cfe20000410000ULL,
0x0000001f63637220ULL, 0x080fe20000410000ULL, 0x0000001f5e5e7220ULL, 0x080fe20000410000ULL,
0x0000001f5f5f7220ULL, 0x080fe20000410000ULL, 0x0000001f5a5a7220ULL, 0x080fe20000410000ULL,
0x0000001f5b5b7220ULL, 0x080fe20000410000ULL, 0x0000001f56567220ULL, 0x080fe20000410000ULL,
0x0000001f57577220ULL, 0x080fe20000410000ULL, 0x0000001f52527220ULL, 0x080fe20000410000ULL,
0x0000001f53537220ULL, 0x080fe20000410000ULL, 0x0000001f4e4e7220ULL, 0x080fe20000410000ULL,
0x0000001f4f4f7220ULL, 0x080fe20000410000ULL, 0x0000001f4a4a7220ULL, 0x080fe20000410000ULL,
0x0000001f4b4b7220ULL, 0x080fe20000410000ULL, 0x0000001f46467220ULL, 0x080fe20000410000ULL,
0x0000001f47477220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff00001cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000010001f7811ULL, 0x000fe200078ff0ffULL,
0x000135027f007947ULL, 0x000fea000b800000ULL, 0x00001f1f671f7589ULL, 0x0004e400000e0000ULL,
0x0000001f40407220ULL, 0x08cfe20000410000ULL, 0x0000001f41417220ULL, 0x080fe20000410000ULL,
0x0000001f3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001f3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001f38387220ULL, 0x080fe20000410000ULL, 0x0000001f39397220ULL, 0x080fe20000410000ULL,
0x0000001f34347220ULL, 0x080fe20000410000ULL, 0x0000001f35357220ULL, 0x080fe20000410000ULL,
0x0000001f30307220ULL, 0x080fe20000410000ULL, 0x0000001f31317220ULL, 0x080fe20000410000ULL,
0x0000001f2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001f2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001f28287220ULL, 0x080fe20000410000ULL, 0x0000001f29297220ULL, 0x080fe20000410000ULL,
0x0000001f24247220ULL, 0x080fe20000410000ULL, 0x0000001f25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff0000001cff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000018001f7811ULL, 0x000fe200078ff0ffULL,
0x000133e27f007947ULL, 0x000fea000b800000ULL, 0x00001f1f671f7589ULL, 0x0004e400000e0000ULL,
0x0000001f42427220ULL, 0x08cfe20000410000ULL, 0x0000001f43437220ULL, 0x080fe20000410000ULL,
0x0000001f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001f3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001f36367220ULL, 0x080fe20000410000ULL, 0x0000001f37377220ULL, 0x080fe20000410000ULL,
0x0000001f32327220ULL, 0x080fe20000410000ULL, 0x0000001f33337220ULL, 0x080fe20000410000ULL,
0x0000001f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001f2a2a7220ULL, 0x080fe20000410000ULL, 0x0000001f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001f26267220ULL, 0x080fe20000410000ULL, 0x0000001f27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000001c1dff7212ULL, 0x000fe400078030ffULL,
0x00000003641c7209ULL, 0x000fd60007810000ULL, 0x8000001c64640221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b64640820ULL, 0x000fc80000410000ULL, 0x0000006400090308ULL, 0x000ea40000000800ULL,
0x0000000965650220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000001e651e7221ULL, 0x002fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000009ff03723eULL, 0x000fe400000000ffULL,
0x00000002ff647819ULL, 0x000fe40000011600ULL, 0x0000541003037816ULL, 0x000fe20000000003ULL,
0x000132227f007947ULL, 0x000fea000b800000ULL, 0x00001f64030a7589ULL, 0x0002a400000e0000ULL,
0x00000008641f7810ULL, 0x000fe20007ffe0ffULL, 0x000132527f007947ULL, 0x000fea000b800000ULL,
0x00000010640c7810ULL, 0x000fe20007ffe0ffULL, 0x00001f1f030b7589ULL, 0x00066a00000e0000ULL,
0x00001f0c030c7589ULL, 0x0006a400000e0000ULL, 0x00000018641f7810ULL, 0x008fe20007ffe0ffULL,
0x000132a27f007947ULL, 0x000fea000b800000ULL, 0x00001f1f030d7589ULL, 0x0006a400000e0000ULL,
0x000004009a037824ULL, 0x04afe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000020009a1d7824ULL, 0x000fe200078e00ffULL, 0x0000016000007945ULL, 0x000fe40003800000ULL,
0xfffff00003037812ULL, 0x000fc400078ec0ffULL, 0xffffc0001d1f7812ULL, 0x000fe400078ec0ffULL,
0x0000b00003037810ULL, 0x000fc60007ffe0ffULL, 0x00002000061f7824ULL, 0x000fe400078e021fULL,
0x000000100e787824ULL, 0x100fe400078e0203ULL, 0x000000100f037824ULL, 0x000fe200078e0203ULL,
0x0000f0001f1f7810ULL, 0x000fc60007ffe0ffULL, 0x000000007878783bULL, 0x000e640000000200ULL,
0x0000001011747824ULL, 0x100fe400078e021fULL, 0x000000000364783bULL, 0x0006a20000000200ULL,
0x0000001010707824ULL, 0x100fe400078e021fULL, 0x00000010126c7824ULL, 0x000fe200078e021fULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000000a78787232ULL, 0x086fe40000000000ULL,
0x0000000a7a7a7232ULL, 0x000fc40000000000ULL, 0x0000000b79797232ULL, 0x080fe40000000000ULL,
0x0000000b7b7b7232ULL, 0x000fe40000000000ULL, 0x0000000c64647232ULL, 0x080fe40000000000ULL,
0x0000000c66667232ULL, 0x000fe40000000000ULL, 0x0000000d65657232ULL, 0x080fe40000000000ULL,
0x0000000d67677232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001013687824ULL, 0x000fe200078e021fULL, 0x000000007474783bULL, 0x000ee40000004200ULL,
0x00000001ff037819ULL, 0x008fe2000001169aULL, 0x0000028000007945ULL, 0x000fe20003800000ULL,
0x0000b000021f7811ULL, 0x000fe200078e60ffULL, 0x000000007070783bULL, 0x000ee40000004200ULL,
0x0000000203207824ULL, 0x000fc400078e0206ULL, 0x000000006c6c783bULL, 0x000ea60000004200ULL,
0x0000f00020207811ULL, 0x000fe200078e68ffULL, 0x000000006868783bULL, 0x000e640000004200ULL,
0x000000747860723cULL, 0x042f700000001860ULL, 0x00000076785c723cULL, 0x040f70000000185cULL,
0x000000707858723cULL, 0x048f700000001858ULL, 0x000000727854723cULL, 0x040f700000001854ULL,
0x0000006c7850723cULL, 0x044f700000001850ULL, 0x0000006e784c723cULL, 0x040f70000000184cULL,
0x000000687848723cULL, 0x040f700000001848ULL, 0x0000006a7844723cULL, 0x000b6e0000001844ULL,
0x0000001014787824ULL, 0x120fe200078e021fULL, 0x000000746440723cULL, 0x000b620000001840ULL,
0x00000010151f7824ULL, 0x000fc800078e021fULL, 0x000000007878783bULL, 0x000e640000000200ULL,
0x0000002016747211ULL, 0x020fe200078e20ffULL, 0x00000076643c723cULL, 0x040f70000000183cULL,
0x000000706438723cULL, 0x040b6e0000001838ULL, 0x0000001017707824ULL, 0x120fe200078e0220ULL,
0x000000726434723cULL, 0x040f700000001834ULL, 0x0000006c6430723cULL, 0x040b6e0000001830ULL,
0x00000010186c7824ULL, 0x020fe200078e0220ULL, 0x0000006e642c723cULL, 0x040f70000000182cULL,
0x000000686428723cULL, 0x040f700000001828ULL, 0x0000006a6424723cULL, 0x000b640000001824ULL,
0x000000001f64783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000008947ULL, 0x000fde0003800000ULL, 0x0000000a78787232ULL, 0x082fe40000000000ULL,
0x0000000a7a7a7232ULL, 0x000fc40000000000ULL, 0x0000000b79797232ULL, 0x080fe40000000000ULL,
0x0000000b7b7b7232ULL, 0x000fe40000000000ULL, 0x0000000c64647232ULL, 0x088fe40000000000ULL,
0x0000000c66667232ULL, 0x000fe40000000000ULL, 0x0000000d65657232ULL, 0x080fe40000000000ULL,
0x0000000d67677232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x002fea0003800000ULL,
0x0000001019687824ULL, 0x000fe200078e0220ULL, 0x000000007474783bULL, 0x000e620000004200ULL,
0x000059001a1f7a24ULL, 0x014fe200078e02ffULL, 0x00016690021a7811ULL, 0x000fc400078e18ffULL,
0x000000007070783bULL, 0x000ea80000004200ULL, 0x000000006c6c783bULL, 0x000ee80000004200ULL,
0x000000006868783bULL, 0x000ea20000004200ULL, 0x000000747860723cULL, 0x042f700000001860ULL,
0x00000076785c723cULL, 0x040f70000000185cULL, 0x000000707858723cULL, 0x044f700000001858ULL,
0x000000727854723cULL, 0x040f700000001854ULL, 0x0000006c7850723cULL, 0x048f700000001850ULL,
0x0000006e784c723cULL, 0x040f70000000184cULL, 0x000000687848723cULL, 0x040f700000001848ULL,
0x0000006a7844723cULL, 0x000f700000001844ULL, 0x000000746440723cULL, 0x040f700000001840ULL,
0x00000076643c723cULL, 0x040f70000000183cULL, 0x000000706438723cULL, 0x040f700000001838ULL,
0x000000726434723cULL, 0x040f700000001834ULL, 0x0000006c6430723cULL, 0x040f700000001830ULL,
0x0000006e642c723cULL, 0x040f70000000182cULL, 0x000000686428723cULL, 0x040f700000001828ULL,
0x0000006a6424723cULL, 0x000b6e0000001824ULL, 0x0000000896657824ULL, 0x020fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fcc0000008000ULL, 0x0000000196207810ULL, 0x000fe20007ffe0ffULL,
0x00000100ff667424ULL, 0x000fe200078e00ffULL, 0x000000c065657811ULL, 0x000fe200078e28ffULL,
0x000000401f1f7824ULL, 0x000fe200078e00ffULL, 0x000000232000720cULL, 0x000fe20003f06070ULL,
0x000000001aff7f8cULL, 0x0003e2000c80043fULL, 0x0000002065647812ULL, 0x000fe200078ec0ffULL,
0x000062001f207625ULL, 0x000fc800078e0066ULL, 0x00000001051f7824ULL, 0x000fe200078e0264ULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0x0000065000008947ULL, 0x000fea0003800000ULL,
0x00000003ff737819ULL, 0x102fe40000011600ULL, 0x00000065951a7217ULL, 0x000fe40007800000ULL,
0x0000000473697810ULL, 0x040fe40007ffe0ffULL, 0x0000000c73717810ULL, 0x040fe20007ffe0ffULL,
0x000000011a1a7824ULL, 0x000fe200078e0a65ULL, 0x00000008736b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000169647824ULL, 0x100fe200078e0200ULL, 0x0000001473877810ULL, 0x000fe20007ffe0ffULL,
0x0000000869777824ULL, 0x000fe200078e00ffULL, 0x000000201a1a7817ULL, 0x000fe20003800000ULL,
0x0000000171677824ULL, 0x000fe200078e0200ULL, 0x0000001073757810ULL, 0x000fe20007ffe0ffULL,
0x0000000871687824ULL, 0x000fe200078e00ffULL, 0xfffffff877777812ULL, 0x000fe200078ee264ULL,
0x000000809a657824ULL, 0x000fe200078e00ffULL, 0x0000001a6900720cULL, 0x000fe20003f86070ULL,
0x000000016b667824ULL, 0x040fe200078e0200ULL, 0xfffffff8687b7812ULL, 0x000fe200078ee267ULL,
0x000000086b797824ULL, 0x000fe200078e00ffULL, 0x0000008008647812ULL, 0x000fe200078ef865ULL,
0x0000000173677824ULL, 0x100fe200078e021fULL, 0x00000000756a7210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff657224ULL, 0x000fe200078e00ffULL, 0xfffffff879797812ULL, 0x000fe200078ee266ULL,
0x0000000169697824ULL, 0x000fe200078e021fULL, 0x0000001a6b00720cULL, 0x080fe20003f66070ULL,
0x0000010067667825ULL, 0x000fe200078e0064ULL, 0x0000001a7100720cULL, 0x000fc40003f46070ULL,
0x0000001a7300720cULL, 0x000fe20003fa6070ULL, 0x0000010069687825ULL, 0x000fe200078e0064ULL,
0x00000066206c7210ULL, 0x040fe40007f1e0ffULL, 0x000020001d667812ULL, 0x000fe200078ec0ffULL,
0x00000001876d7824ULL, 0x040fe200078e0200ULL, 0x00000068206e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000887707824ULL, 0x000fe200078e00ffULL, 0x0000001c738b7810ULL, 0x000fe20007ffe0ffULL,
0x0000400003727824ULL, 0x000fe400078e0266ULL, 0x00000001216f7824ULL, 0x040fe200008e0669ULL,
0xfffffff870897812ULL, 0x000fe200078ee26dULL, 0x00000001216d7824ULL, 0x000fe200000e0667ULL,
0x0000f00072747810ULL, 0x000fe20007ffe0ffULL, 0x000000016b677824ULL, 0x100fe200078e021fULL,
0x0000001a7500720cULL, 0x000fe20003f26070ULL, 0x0000000171697824ULL, 0x000fc400078e021fULL,
0x0000010067667825ULL, 0x000fc800078e0064ULL, 0x0000000875857824ULL, 0x000fe200078e00ffULL,
0x0000006620707210ULL, 0x000fe20007f1e0ffULL, 0x0000010069687825ULL, 0x000fc600078e0064ULL,
0xfffffff885857812ULL, 0x000fe200078ee26aULL, 0x00000001756b7824ULL, 0x000fe200078e021fULL,
0x0000006820687210ULL, 0x000fe20007fde0ffULL, 0x00000001731d7824ULL, 0x000fe400078e0200ULL,
0x000001006b6a7825ULL, 0x000fc600078e0064ULL, 0x000000071d1d7812ULL, 0x000fe200078ec0ffULL,
0x0000000121717824ULL, 0x000fe200000e0667ULL, 0x0000001a8700720cULL, 0x040fe20003f06070ULL,
0x0000000187677824ULL, 0x000fe200078e021fULL, 0x0ffffff81d1d7812ULL, 0x000fe200078ef800ULL,
0x0000000121697824ULL, 0x000fe200030e0669ULL, 0x0000006a206a7210ULL, 0x000fe20007fde0ffULL,
0x0000010067667825ULL, 0x000fe200078e0064ULL, 0x0000001873877810ULL, 0x000fc60007ffe0ffULL,
0x00000001216b7824ULL, 0x000fe200030e066bULL, 0x0000006620727210ULL, 0x000fe20007fde0ffULL,
0x000000101d757824ULL, 0x100fe400078e0274ULL, 0x00000001871d7824ULL, 0x000fe200078e021fULL,
0x0000001f8b1f7210ULL, 0x000fe20007ffe0ffULL, 0x0000001077777824ULL, 0x000fe200078e0274ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006c757faeULL, 0x0003e2000e901c48ULL,
0x0000000121737824ULL, 0x000fe200030e0667ULL, 0x0000001a8700720cULL, 0x080fe20003fa6070ULL,
0x000001001d667825ULL, 0x000fe200078e0064ULL, 0x000000006e777faeULL, 0x0005e2000e101c48ULL,
0x0000001a8b00720cULL, 0x000fc40003f86070ULL, 0x00000001871a7824ULL, 0x040fe200078e0200ULL,
0x0000006620667210ULL, 0x000fe20007fde0ffULL, 0x00000008871d7824ULL, 0x000fe400078e00ffULL,
0x000001001f647825ULL, 0x000fc600078e0064ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee21aULL,
0x000000018b6c7824ULL, 0x042fe400078e0200ULL, 0x000000088b8b7824ULL, 0x000fe400078e00ffULL,
0x0000000121677824ULL, 0x000fe200030e0667ULL, 0x0000006420207210ULL, 0x000fe20007fde0ffULL,
0x0000001079797824ULL, 0x000fe200078e0274ULL, 0xfffffff88b1f7812ULL, 0x000fe200078ee26cULL,
0x000000107b7b7824ULL, 0x100fe400078e0274ULL, 0x0000001085857824ULL, 0x100fe200078e0274ULL,
0x0000000070797faeULL, 0x0005e2000d901c48ULL, 0x0000001089897824ULL, 0x000fc400078e0274ULL,
0x000000101d1d7824ULL, 0x100fe200078e0274ULL, 0x00000000687b7faeULL, 0x0005e2000d101c48ULL,
0x000000101f1f7824ULL, 0x000fe400078e0274ULL, 0x0000000121217824ULL, 0x000fe200030e0665ULL,
0x000000006a857faeULL, 0x0005e8000c901c48ULL, 0x0000000072897faeULL, 0x0005e8000c101c48ULL,
0x00000000661d7faeULL, 0x0005e8000e901c48ULL, 0x00000000201f7faeULL, 0x0005e2000e101c48ULL,
0x0000058000007947ULL, 0x000fea0003800000ULL, 0x0000000400677811ULL, 0x002fe200078fe8ffULL,
0x000000809a737824ULL, 0x000fe200078e00ffULL, 0x0000000800697811ULL, 0x000fc400078fe8ffULL,
0x00000010006d7811ULL, 0x040fe200078fe8ffULL, 0x00000001671a7824ULL, 0x140fe200078e0200ULL,
0x0000000c006b7811ULL, 0x040fe200078fe8ffULL, 0x0000000867777824ULL, 0x000fe200078e00ffULL,
0x00000014006f7811ULL, 0x040fe200078fe8ffULL, 0x0000000169647824ULL, 0x040fe200078e0200ULL,
0x0000001800717811ULL, 0x000fe200078fe8ffULL, 0x0000000869797824ULL, 0x000fe200078e00ffULL,
0xfffffff877777812ULL, 0x000fe200078ee21aULL, 0x000000086d857824ULL, 0x000fe200078e00ffULL,
0x0000008008727812ULL, 0x000fe200078ef873ULL, 0x000000016b1a7824ULL, 0x000fe200078e0200ULL,
0xfffffff879797812ULL, 0x000fe200078ee264ULL, 0x000000086b7b7824ULL, 0x000fe200078e00ffULL,
0x000000006d647210ULL, 0x000fe20007ffe0ffULL, 0x000000016f657824ULL, 0x000fc400078e0200ULL,
0x000000086f687824ULL, 0x000fe200078e00ffULL, 0xfffffff885857812ULL, 0x000fe200078ee264ULL,
0x0000000171667824ULL, 0x000fe200078e0200ULL, 0xfffffff87b7b7812ULL, 0x000fe200078ee21aULL,
0x0000000871897824ULL, 0x000fe200078e00ffULL, 0x000020001d647812ULL, 0x000fe200078ec0ffULL,
0x0000000167677824ULL, 0x100fe200078e021fULL, 0x00000000001a7211ULL, 0x040fe200078fe8ffULL,
0x0000000169697824ULL, 0x100fe200078e021fULL, 0x0000001c001d7811ULL, 0x000fe200078fe8ffULL,
0x0000400003647824ULL, 0x000fe200078e0264ULL, 0x000000071a757812ULL, 0x000fe200078ec0ffULL,
0x000000016b6b7824ULL, 0x000fe200078e021fULL, 0xfffffff868877812ULL, 0x000fe200078ee265ULL,
0x000000011d1a7824ULL, 0x040fe200078e0200ULL, 0x0000001f00657211ULL, 0x000fe200078fe8ffULL,
0x000000081d737824ULL, 0x000fe200078e00ffULL, 0xfffffff889897812ULL, 0x000fe200078ee266ULL,
0x000000016d6d7824ULL, 0x100fe200078e021fULL, 0x0ffffff875757812ULL, 0x000fe200078ef800ULL,
0x000000016f6f7824ULL, 0x000fc400078e021fULL, 0x0000000171717824ULL, 0x100fe400078e021fULL,
0x000000011d1d7824ULL, 0x000fe200078e021fULL, 0xfffffff8731f7812ULL, 0x000fe200078ee21aULL,
0x000000ffff737224ULL, 0x000fe200078e00ffULL, 0x0000f000641a7810ULL, 0x000fc60007ffe0ffULL,
0x0000010065647825ULL, 0x000fe200078e0072ULL, 0x0000001a77777211ULL, 0x000fc600078e20ffULL,
0x0000010067667825ULL, 0x000fe200078e0072ULL, 0x0000006420647210ULL, 0x000fc60007f1e0ffULL,
0x0000010069687825ULL, 0x000fe200078e0072ULL, 0x0000006620667210ULL, 0x000fc60007f3e0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0072ULL, 0x0000006820687210ULL, 0x000fc60007f5e0ffULL,
0x000001006d6c7825ULL, 0x000fe200078e0072ULL, 0x0000006a206a7210ULL, 0x000fc60007f7e0ffULL,
0x000001006f6e7825ULL, 0x000fc800078e0072ULL, 0x0000010071707825ULL, 0x000fc800078e0072ULL,
0x000001001d727825ULL, 0x000fc800078e0072ULL, 0x0000000121657824ULL, 0x040fe200000e0665ULL,
0x0000006c206c7210ULL, 0x040fe20007f1e0ffULL, 0x0000000121677824ULL, 0x000fe200008e0667ULL,
0x0000006e206e7210ULL, 0x040fe20007f3e0ffULL, 0x0000001075757824ULL, 0x100fe400078e021aULL,
0x0000000121697824ULL, 0x040fe200010e0669ULL, 0x0000007020707210ULL, 0x040fe20007f5e0ffULL,
0x00000001216b7824ULL, 0x000fe200018e066bULL, 0x0000007220207210ULL, 0x000fe20007f7e0ffULL,
0x0000001079797824ULL, 0x100fe200078e021aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000064757faeULL, 0x0003e2000b901c48ULL, 0x000000107b7b7824ULL, 0x000fc400078e021aULL,
0x0000001085857824ULL, 0x100fe200078e021aULL, 0x0000000066777faeULL, 0x0003e2000b901c48ULL,
0x00000001216d7824ULL, 0x000fe400000e066dULL, 0x0000001087877824ULL, 0x100fe200078e021aULL,
0x0000000068797faeULL, 0x0003e2000b901c48ULL, 0x00000001216f7824ULL, 0x000fe400008e066fULL,
0x0000001089897824ULL, 0x000fe200078e021aULL, 0x000000006a7b7faeULL, 0x0003e2000b901c48ULL,
0x0000000121717824ULL, 0x000fc400010e0671ULL, 0x000000101f1f7824ULL, 0x000fe200078e021aULL,
0x000000006c857faeULL, 0x0003e2000b901c48ULL, 0x0000000121217824ULL, 0x000fc600018e0673ULL,
0x000000006e877faeULL, 0x0003e8000b901c48ULL, 0x0000000070897faeULL, 0x0003e8000b901c48ULL,
0x00000000201f7faeULL, 0x0003e4000b901c48ULL, 0x000000031b1a7812ULL, 0x000fe200078ec0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000031a00780cULL, 0x000fc80003f05270ULL,
0x00000001801a7807ULL, 0x000fca0004000000ULL, 0x000000011b1b7824ULL, 0x000fe200078e021aULL,
0xffffffff001a7802ULL, 0x000fc80000000f00ULL, 0x000000941b00720cULL, 0x000fda0003f06070ULL,
0x0000000107208824ULL, 0x006fe400078e021bULL, 0x00000004ff218424ULL, 0x000fc800078e00ffULL,
0x0000640020208625ULL, 0x000fca00078e0021ULL, 0x00000008201a8981ULL, 0x000322000c1e1900ULL,
0x00000010221d7812ULL, 0x040fe400078ec0ffULL, 0x0000000822647812ULL, 0x000fc600078ec0ffULL,
0x00000020021d7824ULL, 0x000fc800078e021dULL, 0x00000001641d7824ULL, 0x000fe200078e021dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x016648001d667f8cULL, 0x0022a4000c80043fULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x01664c001d1f7984ULL, 0x000ee40000000800ULL,
0x800000001fff7812ULL, 0x00cfe40007804867ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff687224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000647805ULL, 0x000fcc0000015200ULL,
0x0000006420647210ULL, 0x000fca0007f1e1ffULL, 0x0000000165657824ULL, 0x000fe200000e0e21ULL,
0x003d09006400780cULL, 0x000fc80003f06070ULL, 0x000000ff6500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406400780cULL, 0x000fc80003f06070ULL,
0x000000ff6500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1f7819ULL, 0x000fc80000011465ULL, 0x000000641f1f7211ULL, 0x000fca00078110ffULL,
0x000000ffff647224ULL, 0x000fca00000e0665ULL, 0x000000021f1f7819ULL, 0x000fc80000001264ULL,
0x0000001f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000168687810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01664c001d1f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x004fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000209a1d7824ULL, 0x002fca00078e00ffULL,
0xffffff801d1d7812ULL, 0x000fc800078ec0ffULL, 0x00000100081d7810ULL, 0x000fca0007ffe01dULL,
0x000000017c1d7824ULL, 0x000fca00078e021dULL, 0x016000001d657984ULL, 0x000e680000000800ULL,
0x016200001d647984ULL, 0x0004e20000000800ULL, 0x0000001c6500720bULL, 0x002fe20003f1d000ULL,
0x00011c327f007947ULL, 0x000fd8000b800000ULL, 0x00000000001d7806ULL, 0x004fc800000e0100ULL,
0x000000ff1d00720cULL, 0x000fe20003f25270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fd60003f0e170ULL, 0x0000071000009947ULL, 0x000fea0003800000ULL,
0x00000002021f7810ULL, 0x000fe40007ffe0ffULL, 0x0000001c6500720bULL, 0x000fe40003f34000ULL,
0x0000009a1f00720cULL, 0x000fe20003f05270ULL, 0x00011bf27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000667806ULL, 0x000fc400008e0100ULL, 0x000000809a218824ULL, 0x000fe200078e0208ULL,
0x0000001c651f7209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000017c208824ULL, 0x000fca00078e0221ULL, 0x0164001f20008388ULL, 0x0003e20000000800ULL,
0x000000ff6600720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x8000001f1c1f7221ULL, 0x002fe20000010000ULL, 0x000000ff66ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b1f1f7820ULL, 0x000fc80000410000ULL,
0x0000001f00677308ULL, 0x000e640000000800ULL, 0x000000671e1e7220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1f7819ULL, 0x000fe20000011600ULL,
0x00011b327f007947ULL, 0x000fea000b800000ULL, 0x00001f1f671f7589ULL, 0x0002a400000e0000ULL,
0x0000001f60607220ULL, 0x084fe20000410000ULL, 0x0000001f61617220ULL, 0x080fe20000410000ULL,
0x0000001f5c5c7220ULL, 0x080fe20000410000ULL, 0x0000001f5d5d7220ULL, 0x080fe20000410000ULL,
0x0000001f58587220ULL, 0x080fe20000410000ULL, 0x0000001f59597220ULL, 0x080fe20000410000ULL,
0x0000001f54547220ULL, 0x080fe20000410000ULL, 0x0000001f55557220ULL, 0x080fe20000410000ULL,
0x0000001f50507220ULL, 0x080fe20000410000ULL, 0x0000001f51517220ULL, 0x080fe20000410000ULL,
0x0000001f4c4c7220ULL, 0x080fe20000410000ULL, 0x0000001f4d4d7220ULL, 0x080fe20000410000ULL,
0x0000001f48487220ULL, 0x080fe20000410000ULL, 0x0000001f49497220ULL, 0x080fe20000410000ULL,
0x0000001f44447220ULL, 0x080fe20000410000ULL, 0x0000001f45457220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0066ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008001f7811ULL, 0x000fe200078ff0ffULL, 0x00011a027f007947ULL, 0x000fea000b800000ULL,
0x00001f1f671f7589ULL, 0x00046400000e0000ULL, 0x0000001f62627220ULL, 0x086fe20000410000ULL,
0x0000001f63637220ULL, 0x080fe20000410000ULL, 0x0000001f5e5e7220ULL, 0x080fe20000410000ULL,
0x0000001f5f5f7220ULL, 0x080fe20000410000ULL, 0x0000001f5a5a7220ULL, 0x080fe20000410000ULL,
0x0000001f5b5b7220ULL, 0x080fe20000410000ULL, 0x0000001f56567220ULL, 0x080fe20000410000ULL,
0x0000001f57577220ULL, 0x080fe20000410000ULL, 0x0000001f52527220ULL, 0x080fe20000410000ULL,
0x0000001f53537220ULL, 0x080fe20000410000ULL, 0x0000001f4e4e7220ULL, 0x080fe20000410000ULL,
0x0000001f4f4f7220ULL, 0x080fe20000410000ULL, 0x0000001f4a4a7220ULL, 0x080fe20000410000ULL,
0x0000001f4b4b7220ULL, 0x080fe20000410000ULL, 0x0000001f46467220ULL, 0x080fe20000410000ULL,
0x0000001f47477220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000066ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000010001f7811ULL, 0x000fe200078ff0ffULL,
0x000118d27f007947ULL, 0x000fea000b800000ULL, 0x00001f1f671f7589ULL, 0x00046400000e0000ULL,
0x0000001f40407220ULL, 0x086fe20000410000ULL, 0x0000001f41417220ULL, 0x080fe20000410000ULL,
0x0000001f3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001f3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001f38387220ULL, 0x080fe20000410000ULL, 0x0000001f39397220ULL, 0x080fe20000410000ULL,
0x0000001f34347220ULL, 0x080fe20000410000ULL, 0x0000001f35357220ULL, 0x080fe20000410000ULL,
0x0000001f30307220ULL, 0x080fe20000410000ULL, 0x0000001f31317220ULL, 0x080fe20000410000ULL,
0x0000001f2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001f2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001f28287220ULL, 0x080fe20000410000ULL, 0x0000001f29297220ULL, 0x080fe20000410000ULL,
0x0000001f24247220ULL, 0x080fe20000410000ULL, 0x0000001f25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000066ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000018001f7811ULL, 0x000fe200078ff0ffULL,
0x000117b27f007947ULL, 0x000fea000b800000ULL, 0x00001f1f671f7589ULL, 0x00046400000e0000ULL,
0x0000001f42427220ULL, 0x086fe20000410000ULL, 0x0000001f43437220ULL, 0x080fe20000410000ULL,
0x0000001f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001f3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001f36367220ULL, 0x080fe20000410000ULL, 0x0000001f37377220ULL, 0x080fe20000410000ULL,
0x0000001f32327220ULL, 0x080fe20000410000ULL, 0x0000001f33337220ULL, 0x080fe20000410000ULL,
0x0000001f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001f2a2a7220ULL, 0x080fe20000410000ULL, 0x0000001f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001f26267220ULL, 0x080fe20000410000ULL, 0x0000001f27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x000000661dff7212ULL, 0x000fe400078030ffULL,
0x0000001c651c7209ULL, 0x000fd60007810000ULL, 0x8000001c65650221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b65650820ULL, 0x000fc80000410000ULL, 0x0000006500090308ULL, 0x000e640000000800ULL,
0x0000000964640220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000001e641e7221ULL, 0x008fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000009ff0a723eULL, 0x000fe400000000ffULL,
0x00000002ff647819ULL, 0x000fe40000011600ULL, 0x000054100a0d7816ULL, 0x000fe2000000000aULL,
0x000115f27f007947ULL, 0x000fea000b800000ULL, 0x00001f640d0a7589ULL, 0x0002a400000e0000ULL,
0x00000008641f7810ULL, 0x000fe20007ffe0ffULL, 0x000116227f007947ULL, 0x000fea000b800000ULL,
0x00000010640c7810ULL, 0x000fe20007ffe0ffULL, 0x00001f1f0d0b7589ULL, 0x00066a00000e0000ULL,
0x00001f0c0d0c7589ULL, 0x0006a400000e0000ULL, 0x00000018641f7810ULL, 0x008fe20007ffe0ffULL,
0x000116727f007947ULL, 0x000fea000b800000ULL, 0x00001f1f0d0d7589ULL, 0x0022e400000e0000ULL,
0x000004009a1d7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000203207824ULL, 0x000fe200078e0206ULL, 0x0000015000007945ULL, 0x000fe40003800000ULL,
0xfffff0001d1f7812ULL, 0x002fe200078ec0ffULL, 0x00002000201d7824ULL, 0x000fc600078e00ffULL,
0x0000c0001f1f7810ULL, 0x000fe40007ffe0ffULL, 0x0000e0001d207810ULL, 0x000fc60007ffe0ffULL,
0x000000100e687824ULL, 0x100fe400078e021fULL, 0x000000100f1f7824ULL, 0x000fe400078e021fULL,
0x00000010116c7824ULL, 0x100fe400078e0220ULL, 0x000000006868783bULL, 0x000e620000000200ULL,
0x0000001010707824ULL, 0x100fe400078e0220ULL, 0x0000001012747824ULL, 0x000fe200078e0220ULL,
0x000000001f64783bULL, 0x0006a20000000200ULL, 0x0000008000008947ULL, 0x000fea0003800000ULL,
0x0000000a68687232ULL, 0x086fe40000000000ULL, 0x0000000a6a6a7232ULL, 0x000fc40000000000ULL,
0x0000000b69697232ULL, 0x080fe40000000000ULL, 0x0000000b6b6b7232ULL, 0x000fe40000000000ULL,
0x0000000c64647232ULL, 0x080fe40000000000ULL, 0x0000000c66667232ULL, 0x000fe40000000000ULL,
0x0000000d65657232ULL, 0x088fe40000000000ULL, 0x0000000d67677232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001013787824ULL, 0x000fe200078e0220ULL,
0x000000006c6c783bULL, 0x000ee40000004200ULL, 0x0000c000021f7811ULL, 0x008fe200078e60ffULL,
0x0000024000007945ULL, 0x000fe20003800000ULL, 0x000000007070783bULL, 0x000fe80000004200ULL,
0x000000007878783bULL, 0x000ee80000004200ULL, 0x000000007474783bULL, 0x000ea40000004200ULL,
0x0000006c6440723cULL, 0x004f700000001840ULL, 0x000000786848723cULL, 0x04af700000001848ULL,
0x0000007a6844723cULL, 0x000f700000001844ULL, 0x000000786428723cULL, 0x040f700000001828ULL,
0x0000006e643c723cULL, 0x040f70000000183cULL, 0x000000706438723cULL, 0x040f700000001838ULL,
0x000000726434723cULL, 0x040f700000001834ULL, 0x000000746430723cULL, 0x040f700000001830ULL,
0x00000076642c723cULL, 0x040f70000000182cULL, 0x0000007a6478723cULL, 0x000b6e0000001824ULL,
0x0000001014647824ULL, 0x120fe200078e021fULL, 0x0000006c6860723cULL, 0x000b620000001860ULL,
0x00000010151f7824ULL, 0x000fc800078e021fULL, 0x000000006464783bULL, 0x000e640000000200ULL,
0x00000010176c7824ULL, 0x120fe200078e0220ULL, 0x0000006e685c723cULL, 0x040f62000000185cULL,
0x000000001f24783bULL, 0x0004ee0000000200ULL, 0x000000706858723cULL, 0x040b6e0000001858ULL,
0x0000001018707824ULL, 0x020fe200078e0220ULL, 0x000000726854723cULL, 0x040f700000001854ULL,
0x000000746850723cULL, 0x040f700000001850ULL, 0x00000076684c723cULL, 0x000b6e000000184cULL,
0x0000002016687211ULL, 0x020fe200078e20ffULL, 0x0000008000008947ULL, 0x000fd60003800000ULL,
0x0000000a64647232ULL, 0x086fe40000000000ULL, 0x0000000a66667232ULL, 0x000fc40000000000ULL,
0x0000000b65657232ULL, 0x080fe40000000000ULL, 0x0000000b67677232ULL, 0x000fe40000000000ULL,
0x0000000c24247232ULL, 0x088fe40000000000ULL, 0x0000000c26267232ULL, 0x000fe40000000000ULL,
0x0000000d25257232ULL, 0x080fe40000000000ULL, 0x0000000d27277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x006fea0003800000ULL, 0x0000001019747824ULL, 0x000fe200078e0220ULL,
0x000000006868783bULL, 0x000e620000004200ULL, 0x00016698021f7811ULL, 0x000fc600078e18ffULL,
0x000000006c6c783bULL, 0x000ea80000004200ULL, 0x000000007070783bULL, 0x000ee80000004200ULL,
0x000000007474783bULL, 0x000ea20000004200ULL, 0x000000682440723cULL, 0x04ab700000001840ULL,
0x0000006a243c723cULL, 0x040b70000000183cULL, 0x0000006c2438723cULL, 0x044b700000001838ULL,
0x0000006e2434723cULL, 0x040b700000001834ULL, 0x000000702430723cULL, 0x040b700000001830ULL,
0x00000072242c723cULL, 0x040b70000000182cULL, 0x000000742428723cULL, 0x000b700000001828ULL,
0x000000686460723cULL, 0x040b700000001860ULL, 0x0000006a645c723cULL, 0x040b70000000185cULL,
0x0000006c6458723cULL, 0x040b700000001858ULL, 0x0000006e6454723cULL, 0x040b700000001854ULL,
0x000000706450723cULL, 0x040b700000001850ULL, 0x00000072644c723cULL, 0x040b70000000184cULL,
0x000000746448723cULL, 0x040b700000001848ULL, 0x000000766444723cULL, 0x080b700000001844ULL,
0x000000762424723cULL, 0x000b620000001878ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000030096967a10ULL, 0x000fe20007ffe0ffULL, 0x000000001fff7f8cULL, 0x0003e6000c80043fULL,
0x000000239600720cULL, 0x000fe20003f06070ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x00000d4000000947ULL, 0x000fea0003800000ULL, 0x0000000196207810ULL, 0x002fe20007ffe0ffULL,
0x000059001a1a7a24ULL, 0x010fe400078e02ffULL, 0x00000100961f7824ULL, 0x000fe200078e0204ULL,
0x000000232000720cULL, 0x000fe20003f06070ULL, 0x000000401a207824ULL, 0x000fe400078e00ffULL,
0x00000100ff217424ULL, 0x000fe200078e00ffULL, 0x000000201f1a7812ULL, 0x000fc600078ec0ffULL,
0x0000620020207625ULL, 0x000fc800078e0021ULL, 0x0000000105757824ULL, 0x020fe400078e021aULL,
0x0000066000008947ULL, 0x000fea0003800000ULL, 0x00000003ff737819ULL, 0x100fe20000011600ULL,
0x000000809a657824ULL, 0x000fe200078e00ffULL, 0x0000001f951a7217ULL, 0x000fe40007800000ULL,
0x00000008736b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000173677824ULL, 0x040fe200078e0275ULL,
0x0000000c73717810ULL, 0x040fe20007ffe0ffULL, 0x000000011a1a7824ULL, 0x000fe200078e0a1fULL,
0x0000000473697810ULL, 0x000fe20007ffe0ffULL, 0x000000016b647824ULL, 0x100fe200078e0200ULL,
0x0000001073777810ULL, 0x000fe20007ffe0ffULL, 0x000000086b7b7824ULL, 0x000fe200078e00ffULL,
0x000000201a1a7817ULL, 0x000fe20003800000ULL, 0x0000000171667824ULL, 0x000fe200078e0200ULL,
0x0000001473897810ULL, 0x000fe20007ffe0ffULL, 0x0000000871857824ULL, 0x000fe200078e00ffULL,
0xfffffff87b7b7812ULL, 0x000fe200078ee264ULL, 0x00000001691f7824ULL, 0x040fe200078e0200ULL,
0x0000008008647812ULL, 0x000fe200078ef865ULL, 0x0000000869687824ULL, 0x000fe200078e00ffULL,
0x000000ff00657202ULL, 0x000fe20000000f00ULL, 0x0000000877707824ULL, 0x000fe200078e00ffULL,
0x0000001a6900720cULL, 0x040fe20003f86070ULL, 0x0000000169697824ULL, 0x000fe200078e0275ULL,
0xfffffff885857812ULL, 0x000fe200078ee266ULL, 0x0000010067667825ULL, 0x000fe200078e0064ULL,
0xfffffff868797812ULL, 0x000fc400078ee21fULL, 0x0000001a6b00720cULL, 0x000fe20003f66070ULL,
0x00000001771f7824ULL, 0x000fe200078e0200ULL, 0x00000066206c7210ULL, 0x000fe20007f1e0ffULL,
0x0000010069687825ULL, 0x000fe200078e0064ULL, 0x0000001a7100720cULL, 0x000fe40003f46070ULL,
0xfffffff870877812ULL, 0x000fe200078ee21fULL, 0x00000001896a7824ULL, 0x140fe200078e0200ULL,
0x00000068206e7210ULL, 0x000fe20007f3e0ffULL, 0x00000008898b7824ULL, 0x000fe200078e00ffULL,
0x0000001a7300720cULL, 0x0c0fe20003fa6070ULL, 0x000020009a1f7824ULL, 0x000fe200078e00ffULL,
0x0000001c738d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000173667824ULL, 0x000fe200078e0200ULL,
0xfffffff88b8b7812ULL, 0x000fe200078ee26aULL, 0x00000001216d7824ULL, 0x000fe200000e0667ULL,
0x000020001f6a7812ULL, 0x000fe200078ec0ffULL, 0x000000016b677824ULL, 0x000fe200078e0275ULL,
0x00000007661f7812ULL, 0x000fe200078ec0ffULL, 0x00000001216f7824ULL, 0x000fe200008e0669ULL,
0x0000001a7700720cULL, 0x000fe20003f26070ULL, 0x0000000171697824ULL, 0x000fe200078e0275ULL,
0x0ffffff81f1f7812ULL, 0x000fe200078ef800ULL, 0x0000010067667825ULL, 0x000fc800078e0064ULL,
0x0000010069687825ULL, 0x000fe200078e0064ULL, 0x0000006620707210ULL, 0x000fc60007f1e0ffULL,
0x00000001776b7824ULL, 0x000fe200078e0275ULL, 0x0000006820687210ULL, 0x000fe20007fde0ffULL,
0x0000400003727824ULL, 0x000fe400078e026aULL, 0x000001006b6a7825ULL, 0x000fc600078e0064ULL,
0x0000e00072747810ULL, 0x000fe20007ffe0ffULL, 0x0000000121717824ULL, 0x000fe200000e0667ULL,
0x0000001a8900720cULL, 0x040fe20003f06070ULL, 0x0000000189677824ULL, 0x000fe200078e0275ULL,
0x0000001873897810ULL, 0x000fe20007ffe0ffULL, 0x0000000121697824ULL, 0x000fe200030e0669ULL,
0x0000006a206a7210ULL, 0x000fe20007fde0ffULL, 0x0000010067667825ULL, 0x000fe200078e0064ULL,
0x0000007479797211ULL, 0x000fc600078e20ffULL, 0x00000001216b7824ULL, 0x000fe200030e066bULL,
0x0000006620727210ULL, 0x040fe20007fde0ffULL, 0x000000101f777824ULL, 0x000fe400078e0274ULL,
0x00000001891f7824ULL, 0x000fe400078e0275ULL, 0x0000000121737824ULL, 0x000fe200030e0667ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006c777faeULL, 0x0003e2000e901c48ULL,
0x000001001f667825ULL, 0x000fe200078e0064ULL, 0x0000001a8900720cULL, 0x080fe40003fa6070ULL,
0x000000006e797faeULL, 0x0005e2000e101c48ULL, 0x000000018d757824ULL, 0x040fe200078e0275ULL,
0x0000001a8d00720cULL, 0x000fe20003f86070ULL, 0x00000001891a7824ULL, 0x040fe200078e0200ULL,
0x0000006620667210ULL, 0x000fe20007fde0ffULL, 0x00000008891f7824ULL, 0x000fc400078e00ffULL,
0x0000010075647825ULL, 0x000fc600078e0064ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee21aULL,
0x000000018d6c7824ULL, 0x042fe400078e0200ULL, 0x000000088d6d7824ULL, 0x000fe400078e00ffULL,
0x0000000121677824ULL, 0x000fe200030e0667ULL, 0x0000006420207210ULL, 0x000fe20007fde0ffULL,
0x000000107b7b7824ULL, 0x000fe200078e0274ULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee26cULL,
0x0000001085857824ULL, 0x100fe400078e0274ULL, 0x0000001087877824ULL, 0x100fe200078e0274ULL,
0x00000000707b7faeULL, 0x0005e2000d901c48ULL, 0x000000108b8b7824ULL, 0x000fc400078e0274ULL,
0x000000101f1f7824ULL, 0x100fe200078e0274ULL, 0x0000000068857faeULL, 0x0005e2000d101c48ULL,
0x000000106d6d7824ULL, 0x000fe400078e0274ULL, 0x0000000121217824ULL, 0x000fe200030e0665ULL,
0x000000006a877faeULL, 0x0005e8000c901c48ULL, 0x00000000728b7faeULL, 0x0005e8000c101c48ULL,
0x00000000661f7faeULL, 0x0005e8000e901c48ULL, 0x00000000206d7faeULL, 0x0005e2000e101c48ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000800697811ULL, 0x000fe200078fe8ffULL,
0x000000809a737824ULL, 0x000fe200078e00ffULL, 0x00000014006f7811ULL, 0x000fc400078fe8ffULL,
0x00000000691f7210ULL, 0x0c0fe20007ffe0ffULL, 0x0000000869647824ULL, 0x000fe200078e00ffULL,
0x0000000400677811ULL, 0x040fe200078fe8ffULL, 0x000000086f897824ULL, 0x000fe200078e00ffULL,
0x00000010006d7811ULL, 0x000fe200078fe8ffULL, 0x0000000169697824ULL, 0x000fe200078e0275ULL,
0xfffffff8647b7812ULL, 0x000fe200078ee21fULL, 0x000000016f647824ULL, 0x100fe200078e0200ULL,
0x0000000c006b7811ULL, 0x040fe200078fe8ffULL, 0x00000001671a7824ULL, 0x040fe200078e0200ULL,
0x0000001800717811ULL, 0x040fe200078fe8ffULL, 0x0000000867797824ULL, 0x000fe200078e00ffULL,
0xfffffff889897812ULL, 0x000fe200078ee264ULL, 0x000000016d1f7824ULL, 0x040fe200078e0200ULL,
0x0000001c00647811ULL, 0x000fe200078fe8ffULL, 0x000000086d667824ULL, 0x000fe200078e00ffULL,
0xfffffff879797812ULL, 0x000fe200078ee21aULL, 0x000000016b1a7824ULL, 0x140fe200078e0200ULL,
0x0000008008727812ULL, 0x000fe200078ef873ULL, 0x000000086b857824ULL, 0x000fe200078e00ffULL,
0xfffffff866877812ULL, 0x000fe200078ee21fULL, 0x0000000171657824ULL, 0x040fe200078e0200ULL,
0x00000000001f7211ULL, 0x080fe200078fe8ffULL, 0x0000000871687824ULL, 0x000fe200078e00ffULL,
0xfffffff885857812ULL, 0x000fe200078ee21aULL, 0x0000000864737824ULL, 0x040fe200078e00ffULL,
0x0000000064667210ULL, 0x000fe20007ffe0ffULL, 0x000020009a1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8688b7812ULL, 0x000fe200078ee265ULL, 0x0000000167677824ULL, 0x100fe200078e0275ULL,
0x000000071f777812ULL, 0x000fe200078ec0ffULL, 0x000000016b6b7824ULL, 0x100fe200078e0275ULL,
0x0000007500657211ULL, 0x000fe200078fe8ffULL, 0x000000016d6d7824ULL, 0x100fe200078e0275ULL,
0x000020001a1a7812ULL, 0x000fe200078ec0ffULL, 0x000000016f6f7824ULL, 0x100fe200078e0275ULL,
0x0ffffff877777812ULL, 0x000fe200078ef800ULL, 0x0000000171717824ULL, 0x000fc400078e0275ULL,
0x00000001641f7824ULL, 0x000fe200078e0275ULL, 0xfffffff873757812ULL, 0x000fe200078ee266ULL,
0x000000ffff737224ULL, 0x000fe400078e00ffULL, 0x00004000031a7824ULL, 0x000fe400078e021aULL,
0x0000010065647825ULL, 0x000fc600078e0072ULL, 0x0000e0001a1a7810ULL, 0x000fe20007ffe0ffULL,
0x0000010067667825ULL, 0x000fe200078e0072ULL, 0x0000006420647210ULL, 0x000fc60007f1e0ffULL,
0x0000010069687825ULL, 0x000fe200078e0072ULL, 0x0000006620667210ULL, 0x000fc60007f3e0ffULL,
0x000001006b6a7825ULL, 0x000fe200078e0072ULL, 0x0000006820687210ULL, 0x000fc60007f5e0ffULL,
0x000001006d6c7825ULL, 0x000fe200078e0072ULL, 0x0000006a206a7210ULL, 0x000fc60007f7e0ffULL,
0x000001006f6e7825ULL, 0x000fc800078e0072ULL, 0x0000010071707825ULL, 0x000fc800078e0072ULL,
0x000001001f727825ULL, 0x000fc800078e0072ULL, 0x0000000121657824ULL, 0x000fe200000e0665ULL,
0x0000006c206c7210ULL, 0x040fe20007f1e0ffULL, 0x0000001077777824ULL, 0x100fe400078e021aULL,
0x0000000121677824ULL, 0x040fe200008e0667ULL, 0x0000006e206e7210ULL, 0x040fe20007f3e0ffULL,
0x0000000121697824ULL, 0x000fe200010e0669ULL, 0x0000007020707210ULL, 0x040fe20007f5e0ffULL,
0x0000001079797824ULL, 0x100fe200078e021aULL, 0x0000006f216f7210ULL, 0x040fe20000ffe4ffULL,
0x00000001216b7824ULL, 0x000fe200018e066bULL, 0x0000007220207210ULL, 0x000fe20007f7e0ffULL,
0x000000107b7b7824ULL, 0x100fe200078e021aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000064777faeULL, 0x0003e2000b901c48ULL, 0x0000001085857824ULL, 0x000fc400078e021aULL,
0x0000001087877824ULL, 0x100fe200078e021aULL, 0x0000000066797faeULL, 0x0003e2000b901c48ULL,
0x00000001216d7824ULL, 0x000fe400000e066dULL, 0x0000001089897824ULL, 0x100fe200078e021aULL,
0x00000000687b7faeULL, 0x0003e2000b901c48ULL, 0x000000108b8b7824ULL, 0x100fe400078e021aULL,
0x0000000121717824ULL, 0x000fe200010e0671ULL, 0x000000006a857faeULL, 0x0003e2000b901c48ULL,
0x0000001075757824ULL, 0x000fc400078e021aULL, 0x0000000121217824ULL, 0x000fe200018e0673ULL,
0x000000006c877faeULL, 0x0003e8000b901c48ULL, 0x000000006e897faeULL, 0x0003e8000b901c48ULL,
0x00000000708b7faeULL, 0x0003e8000b901c48ULL, 0x0000000020757faeULL, 0x0003e4000b901c48ULL,
0x000000031b1a7812ULL, 0x000fc800078ec0ffULL, 0x000000031a00780cULL, 0x000fc80003f05270ULL,
0x00000001801a7807ULL, 0x000fca0004000000ULL, 0x000000011b1b7824ULL, 0x000fe400078e021aULL,
0xffffffffff1a7424ULL, 0x000fc600078e00ffULL, 0x000000941b00720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x0000000107207824ULL, 0x006fe400078e021bULL,
0x00000004ff217424ULL, 0x000fc800078e00ffULL, 0x0000640020207625ULL, 0x000fca00078e0021ULL,
0x00000008201a7981ULL, 0x000324000c1e1900ULL, 0x00000000000079afULL, 0x002e220000000000ULL,
0x00000010221f7812ULL, 0x044fe400078ec0ffULL, 0x0000000822207812ULL, 0x000fc600078ec0ffULL,
0x00000020021f7824ULL, 0x000fc800078e021fULL, 0x0000000120687824ULL, 0x020fe200078e021fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0166680068667f8cULL, 0x0002a4000c80043fULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x01666c00681f7984ULL, 0x000ee40000000800ULL,
0x800000001fff7812ULL, 0x00cfe40007804867ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff697224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000647805ULL, 0x000fcc0000015200ULL,
0x0000006420647210ULL, 0x000fca0007f1e1ffULL, 0x0000000165657824ULL, 0x000fe200000e0e21ULL,
0x003d09006400780cULL, 0x000fc80003f06070ULL, 0x000000ff6500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406400780cULL, 0x000fc80003f06070ULL,
0x000000ff6500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1f7819ULL, 0x000fc80000011465ULL, 0x000000641f1f7211ULL, 0x000fca00078110ffULL,
0x000000ffff647224ULL, 0x000fca00000e0665ULL, 0x000000021f1f7819ULL, 0x000fc80000001264ULL,
0x0000001f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000169697810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01666c00681f7984ULL, 0x000ea40000000800ULL, 0x800000001fff7812ULL, 0x004fe40007804867ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000003021f7810ULL, 0x000fca0007ffe0ffULL,
0x000000801f1f7824ULL, 0x000fc800078e0208ULL, 0x000000017c1f7824ULL, 0x000fca00078e021fULL,
0x016000001f657984ULL, 0x000ea80000000800ULL, 0x016200001f647984ULL, 0x0006620000000800ULL,
0x0000001c6500720bULL, 0x004fe20003f1d000ULL, 0x000100127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000667806ULL, 0x008fc800000e0100ULL, 0x000000ff6600720cULL, 0x000fe20003f25270ULL,
0x0000075000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fd60003f0e170ULL,
0x0000072000009947ULL, 0x000fea0003800000ULL, 0x00000003021f7810ULL, 0x000fe40007ffe0ffULL,
0x0000001c6500720bULL, 0x000fe40003f34000ULL, 0x0000009a1f00720cULL, 0x000fe20003f05270ULL,
0x0000ffd27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000677806ULL, 0x000fc400008e0100ULL,
0x000000809a1f8824ULL, 0x000fe200078e0208ULL, 0x0000001c65088209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x000000017c1f8824ULL, 0x000fca00078e021fULL,
0x016400081f008388ULL, 0x0005e20000000800ULL, 0x000000ff6700720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000001c651f7209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff67ff7812ULL, 0x000fc6000780c0ffULL,
0x0000001c1f087221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL,
0x0000000800697308ULL, 0x000ea40000000800ULL, 0x000000691e1e7220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff1f7819ULL, 0x000fe20000011600ULL,
0x0000ff027f007947ULL, 0x000fea000b800000ULL, 0x00001f1f691f7589ULL, 0x0004e400000e0000ULL,
0x0000001f60607220ULL, 0x08cfe20000410000ULL, 0x0000001f61617220ULL, 0x080fe20000410000ULL,
0x0000001f5c5c7220ULL, 0x080fe20000410000ULL, 0x0000001f5d5d7220ULL, 0x080fe20000410000ULL,
0x0000001f58587220ULL, 0x080fe20000410000ULL, 0x0000001f59597220ULL, 0x080fe20000410000ULL,
0x0000001f54547220ULL, 0x080fe20000410000ULL, 0x0000001f55557220ULL, 0x080fe20000410000ULL,
0x0000001f50507220ULL, 0x080fe20000410000ULL, 0x0000001f51517220ULL, 0x080fe20000410000ULL,
0x0000001f4c4c7220ULL, 0x080fe20000410000ULL, 0x0000001f4d4d7220ULL, 0x080fe20000410000ULL,
0x0000001f48487220ULL, 0x080fe20000410000ULL, 0x0000001f49497220ULL, 0x080fe20000410000ULL,
0x0000001f44447220ULL, 0x080fe20000410000ULL, 0x0000001f45457220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0067ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008001f7811ULL, 0x000fe200078ff0ffULL, 0x0000fdd27f007947ULL, 0x000fea000b800000ULL,
0x00001f1f691f7589ULL, 0x0004e400000e0000ULL, 0x0000001f62627220ULL, 0x08cfe20000410000ULL,
0x0000001f63637220ULL, 0x080fe20000410000ULL, 0x0000001f5e5e7220ULL, 0x080fe20000410000ULL,
0x0000001f5f5f7220ULL, 0x080fe20000410000ULL, 0x0000001f5a5a7220ULL, 0x080fe20000410000ULL,
0x0000001f5b5b7220ULL, 0x080fe20000410000ULL, 0x0000001f56567220ULL, 0x080fe20000410000ULL,
0x0000001f57577220ULL, 0x080fe20000410000ULL, 0x0000001f52527220ULL, 0x080fe20000410000ULL,
0x0000001f53537220ULL, 0x080fe20000410000ULL, 0x0000001f4e4e7220ULL, 0x080fe20000410000ULL,
0x0000001f4f4f7220ULL, 0x080fe20000410000ULL, 0x0000001f4a4a7220ULL, 0x080fe20000410000ULL,
0x0000001f4b4b7220ULL, 0x080fe20000410000ULL, 0x0000001f46467220ULL, 0x080fe20000410000ULL,
0x0000001f47477220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000067ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000010001f7811ULL, 0x000fe200078ff0ffULL,
0x0000fca27f007947ULL, 0x000fea000b800000ULL, 0x00001f1f691f7589ULL, 0x0004e400000e0000ULL,
0x0000001f40407220ULL, 0x08cfe20000410000ULL, 0x0000001f41417220ULL, 0x080fe20000410000ULL,
0x0000001f3c3c7220ULL, 0x080fe20000410000ULL, 0x0000001f3d3d7220ULL, 0x080fe20000410000ULL,
0x0000001f38387220ULL, 0x080fe20000410000ULL, 0x0000001f39397220ULL, 0x080fe20000410000ULL,
0x0000001f34347220ULL, 0x080fe20000410000ULL, 0x0000001f35357220ULL, 0x080fe20000410000ULL,
0x0000001f30307220ULL, 0x080fe20000410000ULL, 0x0000001f31317220ULL, 0x080fe20000410000ULL,
0x0000001f2c2c7220ULL, 0x080fe20000410000ULL, 0x0000001f2d2d7220ULL, 0x080fe20000410000ULL,
0x0000001f28287220ULL, 0x080fe20000410000ULL, 0x0000001f29297220ULL, 0x080fe20000410000ULL,
0x0000001f24247220ULL, 0x080fe20000410000ULL, 0x0000001f25257220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000067ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000018001f7811ULL, 0x000fe200078ff0ffULL,
0x0000fb827f007947ULL, 0x000fea000b800000ULL, 0x00001f1f691f7589ULL, 0x0004e400000e0000ULL,
0x0000001f42427220ULL, 0x08cfe20000410000ULL, 0x0000001f43437220ULL, 0x080fe20000410000ULL,
0x0000001f3e3e7220ULL, 0x080fe20000410000ULL, 0x0000001f3f3f7220ULL, 0x080fe20000410000ULL,
0x0000001f3a3a7220ULL, 0x080fe20000410000ULL, 0x0000001f3b3b7220ULL, 0x080fe20000410000ULL,
0x0000001f36367220ULL, 0x080fe20000410000ULL, 0x0000001f37377220ULL, 0x080fe20000410000ULL,
0x0000001f32327220ULL, 0x080fe20000410000ULL, 0x0000001f33337220ULL, 0x080fe20000410000ULL,
0x0000001f2e2e7220ULL, 0x080fe20000410000ULL, 0x0000001f2f2f7220ULL, 0x080fe20000410000ULL,
0x0000001f2a2a7220ULL, 0x080fe20000410000ULL, 0x0000001f2b2b7220ULL, 0x080fe20000410000ULL,
0x0000001f26267220ULL, 0x080fe20000410000ULL, 0x0000001f27277220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000006766ff7212ULL, 0x000fe400078030ffULL,
0x0000001c651c7209ULL, 0x000fd60007810000ULL, 0x8000001c65650221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b65650820ULL, 0x000fc80000410000ULL, 0x0000006500090308ULL, 0x000ea40000000800ULL,
0x0000000964640220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000001e641e7221ULL, 0x002fe20000010000ULL,
0x000000d000008947ULL, 0x000fea0003800000ULL, 0x00000009ff08723eULL, 0x000fe400000000ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011600ULL, 0x0000541008087816ULL, 0x000fe20000000008ULL,
0x0000f9c27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d080a7589ULL, 0x0002a400000e0000ULL,
0x000000080d1f7810ULL, 0x000fe20007ffe0ffULL, 0x0000f9f27f007947ULL, 0x000fea000b800000ULL,
0x000000100d217810ULL, 0x000fe20007ffe0ffULL, 0x00001f1f080b7589ULL, 0x00066800000e0000ULL,
0x00001f21080c7589ULL, 0x0006a400000e0000ULL, 0x000000180d1f7810ULL, 0x008fe20007ffe0ffULL,
0x0000fa427f007947ULL, 0x000fea000b800000ULL, 0x00001f1f080d7589ULL, 0x0022e400000e0000ULL,
0x0000000302087810ULL, 0x002fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000f0001d1d7810ULL, 0x000fe20007ffe0ffULL, 0x0000012000007945ULL, 0x000fe20003800000ULL,
0x0000a00008087811ULL, 0x000fc600078e60ffULL, 0x0000001011707824ULL, 0x100fe400078e021dULL,
0x000000100e0e7824ULL, 0x100fe400078e0208ULL, 0x000000100f0f7824ULL, 0x000fe400078e0208ULL,
0x00000010106c7824ULL, 0x100fe200078e021dULL, 0x000000000e74783bULL, 0x0002e20000000200ULL,
0x0000001012687824ULL, 0x000fc600078e021dULL, 0x000000000f64783bULL, 0x0002a20000000200ULL,
0x0000008000008947ULL, 0x000fea0003800000ULL, 0x0000000a74747232ULL, 0x08cfe40000000000ULL,
0x0000000a76767232ULL, 0x000fe40000000000ULL, 0x0000000b75757232ULL, 0x080fe40000000000ULL,
0x0000000b77777232ULL, 0x000fe40000000000ULL, 0x0000000c64647232ULL, 0x080fe40000000000ULL,
0x0000000c66667232ULL, 0x000fc40000000000ULL, 0x0000000d65657232ULL, 0x080fe40000000000ULL,
0x0000000d67677232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001d13137211ULL, 0x000fe200078e20ffULL, 0x000000007070783bULL, 0x000e620000004200ULL,
0x0000001014147824ULL, 0x100fe200078e0208ULL, 0x0000024000007945ULL, 0x000fe20003800000ULL,
0x0000001015087824ULL, 0x000fe200078e0208ULL, 0x000000006c6c783bULL, 0x000fe20000004200ULL,
0x00000010170e7824ULL, 0x002fc600078e021dULL, 0x000000006868783bULL, 0x000fe80000004200ULL,
0x000000001310783bULL, 0x000e620000004200ULL, 0x000000706440723cULL, 0x044f700000001840ULL,
0x00000072643c723cULL, 0x000f70000000183cULL, 0x000000107448723cULL, 0x04af700000001848ULL,
0x000000127444723cULL, 0x000f700000001844ULL, 0x0000006c6438723cULL, 0x040f700000001838ULL,
0x0000006e6434723cULL, 0x040f700000001834ULL, 0x000000686430723cULL, 0x040f700000001830ULL,
0x0000006a642c723cULL, 0x040f70000000182cULL, 0x000000106428723cULL, 0x040f700000001828ULL,
0x000000126424723cULL, 0x000b640000001824ULL, 0x000000001464783bULL, 0x0202a80000000200ULL,
0x000000000810783bULL, 0x0002e40000000200ULL, 0x000000707460723cULL, 0x040f700000001860ULL,
0x00000072745c723cULL, 0x040f70000000185cULL, 0x0000006c7458723cULL, 0x040b6e0000001858ULL,
0x00000010186c7824ULL, 0x120fe200078e021dULL, 0x0000006e7454723cULL, 0x040f700000001854ULL,
0x000000687450723cULL, 0x040b6e0000001850ULL, 0x0000001016687824ULL, 0x020fe200078e021dULL,
0x0000006a744c723cULL, 0x000b62000000184cULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000008000008947ULL, 0x000fde0003800000ULL, 0x0000000a64647232ULL, 0x08efe40000000000ULL,
0x0000000a66667232ULL, 0x000fc40000000000ULL, 0x0000000b65657232ULL, 0x080fe40000000000ULL,
0x0000000b67677232ULL, 0x000fe40000000000ULL, 0x0000000c10107232ULL, 0x080fe40000000000ULL,
0x0000000c12127232ULL, 0x000fe40000000000ULL, 0x0000000d11117232ULL, 0x080fe40000000000ULL,
0x0000000d13137232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x00efea0003800000ULL,
0x0000001019147824ULL, 0x000fe200078e021dULL, 0x000000006868783bULL, 0x020e620000004200ULL,
0x000166a002087811ULL, 0x000fc600078e18ffULL, 0x000000000e70783bULL, 0x000ea80000004200ULL,
0x000000006c6c783bULL, 0x000ee80000004200ULL, 0x000000001414783bULL, 0x000ea20000004200ULL,
0x000000686460723cULL, 0x042b700000001860ULL, 0x0000006a645c723cULL, 0x040b70000000185cULL,
0x000000706458723cULL, 0x044b700000001858ULL, 0x000000726454723cULL, 0x040b700000001854ULL,
0x0000006c6450723cULL, 0x048b700000001850ULL, 0x0000006e644c723cULL, 0x040b70000000184cULL,
0x000000146448723cULL, 0x040b700000001848ULL, 0x000000166444723cULL, 0x000b700000001844ULL,
0x000000681040723cULL, 0x040b700000001840ULL, 0x0000006a103c723cULL, 0x040b70000000183cULL,
0x000000701038723cULL, 0x040b700000001838ULL, 0x000000721034723cULL, 0x040b700000001834ULL,
0x0000006c1030723cULL, 0x040b700000001830ULL, 0x0000006e102c723cULL, 0x040b70000000182cULL,
0x000000141028723cULL, 0x040b700000001828ULL, 0x000000161024723cULL, 0x000b620000001824ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000239600720cULL, 0x000fe20003f06070ULL,
0x0000000008ff7f8cULL, 0x0003d8000c80043fULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff801000007947ULL, 0x000fea000383ffffULL, 0x0000000000087919ULL, 0x002e640000002500ULL,
0x000000230800720cULL, 0x002fda0003f06070ULL, 0x0000058000000947ULL, 0x000fea0003800000ULL,
0x018000001e007810ULL, 0x000fe20007ffe0ffULL, 0x000000d000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000005000000947ULL, 0x000fea0003800000ULL, 0x000000ffff077224ULL, 0x000fe200078e001eULL,
0x00009e00000a7802ULL, 0x000fc40000000f00ULL, 0x0000f6e000007944ULL, 0x030fea0003c00000ULL,
0x000000ffff007224ULL, 0x00cfe200078e0005ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001e00057308ULL, 0x000e640000001000ULL, 0xbf80000005007423ULL, 0x002fc8000000001eULL,
0x800000ff00007221ULL, 0x000fc80000010100ULL, 0x0000000005007223ULL, 0x000fc40000000005ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000ea40000000000ULL,
0x0000001805097811ULL, 0x044fe400078ff0ffULL, 0x0000001005077811ULL, 0x042fe400078ff0ffULL,
0x00000002ff0b7819ULL, 0x000fe40000011605ULL, 0x00000008050d7811ULL, 0x000fe200078ff0ffULL,
0x00001f0900097589ULL, 0x000e6800000e0000ULL, 0x00001f0b00027589ULL, 0x000ea800000e0000ULL,
0x00001f0d00057589ULL, 0x000ee800000e0000ULL, 0x00001f0700077589ULL, 0x000ee200000e0000ULL,
0x0000004209427220ULL, 0x062fe20000410000ULL, 0x0000004309437220ULL, 0x040fe20000410000ULL,
0x0000003e093e7220ULL, 0x040fe20000410000ULL, 0x0000003f093f7220ULL, 0x040fe20000410000ULL,
0x0000006002607220ULL, 0x044fe20000410000ULL, 0x0000006102617220ULL, 0x040fe20000410000ULL,
0x0000005c025c7220ULL, 0x040fe20000410000ULL, 0x0000005d025d7220ULL, 0x040fe20000410000ULL,
0x0000005802587220ULL, 0x040fe20000410000ULL, 0x0000005902597220ULL, 0x040fe20000410000ULL,
0x0000005402547220ULL, 0x040fe20000410000ULL, 0x0000005502557220ULL, 0x040fe20000410000ULL,
0x0000005002507220ULL, 0x040fe20000410000ULL, 0x0000005102517220ULL, 0x040fe20000410000ULL,
0x0000004c024c7220ULL, 0x040fe20000410000ULL, 0x0000004d024d7220ULL, 0x040fe20000410000ULL,
0x0000004802487220ULL, 0x040fe20000410000ULL, 0x0000004902497220ULL, 0x040fe20000410000ULL,
0x0000004402447220ULL, 0x040fe20000410000ULL, 0x0000004502457220ULL, 0x000fe20000410000ULL,
0x0000003a093a7220ULL, 0x040fe20000410000ULL, 0x0000003b093b7220ULL, 0x040fe20000410000ULL,
0x0000003609367220ULL, 0x040fe20000410000ULL, 0x0000003709377220ULL, 0x040fe20000410000ULL,
0x0000003209327220ULL, 0x040fe20000410000ULL, 0x0000003309337220ULL, 0x040fe20000410000ULL,
0x0000002e092e7220ULL, 0x040fe20000410000ULL, 0x0000002f092f7220ULL, 0x040fe20000410000ULL,
0x0000002a092a7220ULL, 0x040fe20000410000ULL, 0x0000002b092b7220ULL, 0x040fe20000410000ULL,
0x0000002609267220ULL, 0x040fe20000410000ULL, 0x0000002709277220ULL, 0x000fe20000410000ULL,
0x0000000562627220ULL, 0x088fe20000410000ULL, 0x0000000563637220ULL, 0x080fe20000410000ULL,
0x000000055e5e7220ULL, 0x080fe20000410000ULL, 0x000000055f5f7220ULL, 0x080fe20000410000ULL,
0x000000055a5a7220ULL, 0x080fe20000410000ULL, 0x000000055b5b7220ULL, 0x080fe20000410000ULL,
0x0000000556567220ULL, 0x080fe20000410000ULL, 0x0000000557577220ULL, 0x080fe20000410000ULL,
0x0000000552527220ULL, 0x080fe20000410000ULL, 0x0000000553537220ULL, 0x080fe20000410000ULL,
0x000000054e4e7220ULL, 0x080fe20000410000ULL, 0x000000054f4f7220ULL, 0x080fe20000410000ULL,
0x000000054a4a7220ULL, 0x080fe20000410000ULL, 0x000000054b4b7220ULL, 0x080fe20000410000ULL,
0x0000000546467220ULL, 0x080fe20000410000ULL, 0x0000000547477220ULL, 0x000fe20000410000ULL,
0x0000000740407220ULL, 0x080fe20000410000ULL, 0x0000000741417220ULL, 0x080fe20000410000ULL,
0x000000073c3c7220ULL, 0x080fe20000410000ULL, 0x000000073d3d7220ULL, 0x080fe20000410000ULL,
0x0000000738387220ULL, 0x080fe20000410000ULL, 0x0000000739397220ULL, 0x080fe20000410000ULL,
0x0000000734347220ULL, 0x080fe20000410000ULL, 0x0000000735357220ULL, 0x080fe20000410000ULL,
0x0000000730307220ULL, 0x080fe20000410000ULL, 0x0000000731317220ULL, 0x080fe20000410000ULL,
0x000000072c2c7220ULL, 0x080fe20000410000ULL, 0x000000072d2d7220ULL, 0x080fe20000410000ULL,
0x0000000728287220ULL, 0x080fe20000410000ULL, 0x0000000729297220ULL, 0x080fe20000410000ULL,
0x0000000724247220ULL, 0x080fe20000410000ULL, 0x0000000725257220ULL, 0x000fc80000410000ULL,
0x0000000000057919ULL, 0x000e620000000000ULL, 0x000000242524723eULL, 0x020fc400000000ffULL,
0x000000282928723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000262718723eULL, 0x000fe400000000ffULL, 0x0000002a2b17723eULL, 0x000fe400000000ffULL,
0x000000606107723eULL, 0x000fc400000000ffULL, 0x0000005c5d09723eULL, 0x000fe400000000ffULL,
0x00000058590a723eULL, 0x000fe400000000ffULL, 0x00000054550c723eULL, 0x000fe400000000ffULL,
0x00000050510d723eULL, 0x000fe400000000ffULL, 0x00000002ff1a7819ULL, 0x012fe40000011605ULL,
0x0000000805297811ULL, 0x000fc400078ff0ffULL, 0x000000041a197810ULL, 0x040fe20007ffe0ffULL,
0x000000081a227824ULL, 0x040fe200078e00ffULL, 0x000000011a007810ULL, 0x040fe20007ffe0ffULL,
0x000000081a1b7824ULL, 0x040fe200078e00ffULL, 0x000000021a027810ULL, 0x040fe20007ffe0ffULL,
0x000000081a1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff822217812ULL, 0x000fe200078ee219ULL,
0x000000081a207824ULL, 0x040fe200078e00ffULL, 0x000000031a0b7810ULL, 0x040fe20007ffe0ffULL,
0x000000081a197824ULL, 0x040fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee200ULL,
0x000000081a237824ULL, 0x040fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee202ULL,
0x000000081a257824ULL, 0x000fe200078e00ffULL, 0xfffffff8201f7812ULL, 0x000fe200078ee20bULL,
0x0000000829207824ULL, 0x000fe200078e00ffULL, 0x000000051a007810ULL, 0x000fc40007ffe0ffULL,
0x000000061a027810ULL, 0x040fe40007ffe0ffULL, 0xffffffff1a0b7810ULL, 0x040fe40007ffe0ffULL,
0xfffffff819197812ULL, 0x000fe200078ee21aULL, 0x000000081a1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff823237812ULL, 0x000fe400078ee200ULL, 0x0000000d06007819ULL, 0x000fe400000006ffULL,
0xfffffff81a277812ULL, 0x000fe200078ee20bULL, 0x00001000030b7824ULL, 0x000fe200078e00ffULL,
0x00000010052b7811ULL, 0x040fe200078ff0ffULL, 0x00000004051a7824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee202ULL, 0x0000000100027824ULL, 0x000fe200078e020bULL,
0xfffffff820297812ULL, 0x000fe200078ee229ULL, 0x000000082b207824ULL, 0x000fe200078e00ffULL,
0x0000000c1a1a7812ULL, 0x000fe200078ec0ffULL, 0x0000001019197824ULL, 0x100fe200078e0202ULL,
0x0000002c2d2c723eULL, 0x000fe200000000ffULL, 0x000000101b1b7824ULL, 0x100fe200078e0202ULL,
0xfffffff8202b7812ULL, 0x000fe200078ee22bULL, 0x000000101d1d7824ULL, 0x100fe200078e0202ULL,
0x0000004c4d0e723eULL, 0x000fe200000000ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0202ULL,
0x0000001b1a1b7210ULL, 0x040fe20007ffe0ffULL, 0x0000001021217824ULL, 0x000fe200078e0202ULL,
0x00000018052d7811ULL, 0x000fe200078ff0ffULL, 0x0000000119207824ULL, 0x000fe200078e021aULL,
0x00000048490f723eULL, 0x000fe200000000ffULL, 0x0000001023237824ULL, 0x100fe200078e0202ULL,
0x000000444510723eULL, 0x000fe200000000ffULL, 0x0000001025257824ULL, 0x100fe200078e0202ULL,
0x0000000720007388ULL, 0x000fe20000000800ULL, 0x000000011a1d7824ULL, 0x040fe200078e021dULL,
0x000000626362723eULL, 0x000fe200000000ffULL, 0x0000001027277824ULL, 0x100fe200078e0202ULL,
0x000000091b007388ULL, 0x000fe20000000800ULL, 0x000000011a1f7824ULL, 0x040fe200078e021fULL,
0x0000005e5f5e723eULL, 0x000fe200000000ffULL, 0x0000001029297824ULL, 0x100fe200078e0202ULL,
0x0000000a1d007388ULL, 0x000fe20000000800ULL, 0x000000011a217824ULL, 0x040fe200078e0221ULL,
0x0000005a5b5a723eULL, 0x000fe200000000ffULL, 0x000000011a237824ULL, 0x040fe200078e0223ULL,
0x0000000c1f007388ULL, 0x000fe20000000800ULL, 0x000000011a257824ULL, 0x040fe200078e0225ULL,
0x000000565756723eULL, 0x000fe200000000ffULL, 0x000000011a277824ULL, 0x040fe200078e0227ULL,
0x0000000d21007388ULL, 0x0003e20000000800ULL, 0x000000011a297824ULL, 0x000fe200078e0229ULL,
0x000000525352723eULL, 0x000fe200000000ffULL, 0x000000082d227824ULL, 0x000fe200078e00ffULL,
0x0000000e23007388ULL, 0x000fe20000000800ULL, 0x000000102b2b7824ULL, 0x000fe200078e0202ULL,
0x0000004e4f4e723eULL, 0x000fc400000000ffULL, 0x0000000f25007388ULL, 0x000fe20000000800ULL,
0x0000004a4b4a723eULL, 0x000fe200000000ffULL, 0x000000011a2b7824ULL, 0x000fe200078e022bULL,
0x000000464746723eULL, 0x000fe200000000ffULL, 0x0000001027007388ULL, 0x000fe20000000800ULL,
0xfffffff8222d7812ULL, 0x000fe200078ee22dULL, 0x00000001040d7824ULL, 0x002fe200078e0205ULL,
0x000000404140723eULL, 0x000fe200000000ffULL, 0x0000006229007388ULL, 0x000fe20000000800ULL,
0x0000003c3d3c723eULL, 0x000fe200000000ffULL, 0x000000102d2d7824ULL, 0x000fe200078e0202ULL,
0x000000383938723eULL, 0x000fe200000000ffULL, 0x0004005e1b007388ULL, 0x000fe20000000800ULL,
0x000000343534723eULL, 0x000fe200000000ffULL, 0x000000011a1a7824ULL, 0x000fe200078e022dULL,
0x000000303130723eULL, 0x000fe200000000ffULL, 0x0004005a1d007388ULL, 0x000fe20000000800ULL,
0x000000424311723eULL, 0x000fe200000000ffULL, 0x000000100d0a7824ULL, 0x000fe200078e0200ULL,
0x0000003e3f12723eULL, 0x000fe200000000ffULL, 0x000400561f007388ULL, 0x000fe20000000800ULL,
0x0000003a3b13723eULL, 0x000fc400000000ffULL, 0x000000363714723eULL, 0x000fe200000000ffULL,
0x0004005221007388ULL, 0x000fe20000000800ULL, 0x000000323315723eULL, 0x000fe400000000ffULL,
0x0000002e2f16723eULL, 0x000fe200000000ffULL, 0x0004004e23007388ULL, 0x000fe80000000800ULL,
0x0004004a25007388ULL, 0x000fe80000000800ULL, 0x0004004627007388ULL, 0x000fe80000000800ULL,
0x000000402b007388ULL, 0x000fe80000000800ULL, 0x0008003c1b007388ULL, 0x000fe80000000800ULL,
0x000800381d007388ULL, 0x000fe80000000800ULL, 0x000800341f007388ULL, 0x000fe80000000800ULL,
0x0008003021007388ULL, 0x000fe80000000800ULL, 0x0008002c23007388ULL, 0x000fe80000000800ULL,
0x0008002825007388ULL, 0x000fe80000000800ULL, 0x0008002427007388ULL, 0x000fe80000000800ULL,
0x000000111a007388ULL, 0x000fe80000000800ULL, 0x000c00121b007388ULL, 0x000fe80000000800ULL,
0x000c00131d007388ULL, 0x000fe80000000800ULL, 0x000c00141f007388ULL, 0x0003e80000000800ULL,
0x000c001521007388ULL, 0x000fe80000000800ULL, 0x000c001623007388ULL, 0x000fe20000000800ULL,
0x00000300ff1f7624ULL, 0x002fc600078e00ffULL, 0x000c001725007388ULL, 0x000fe40000000800ULL,
0x000000011f00780cULL, 0x000fe40003f05270ULL, 0x000c001827007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000a287984ULL, 0x000e680000000c00ULL,
0x000400000a107984ULL, 0x000ea80000000c00ULL, 0x000800000a347984ULL, 0x000ee80000000c00ULL,
0x000c00000a207984ULL, 0x000ee80000000c00ULL, 0x001000000a2c7984ULL, 0x000ee80000000c00ULL,
0x001400000a307984ULL, 0x000ee80000000c00ULL, 0x001800000a387984ULL, 0x000ee80000000c00ULL,
0x001c00000a3c7984ULL, 0x000ee20000000c00ULL, 0x200000ff2b2b7230ULL, 0x002fc40000000000ULL,
0x200000ff2a2a7230ULL, 0x000fe40000000000ULL, 0x200000ff29297230ULL, 0x000fe40000000000ULL,
0x200000ff28287230ULL, 0x000fe40000000000ULL, 0x200000ff13137230ULL, 0x004fe40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fc40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x200000ff37377230ULL, 0x008fe40000000000ULL,
0x200000ff36367230ULL, 0x000fe40000000000ULL, 0x200000ff35357230ULL, 0x000fe40000000000ULL,
0x200000ff34347230ULL, 0x000fe40000000000ULL, 0x200000ff23237230ULL, 0x000fc40000000000ULL,
0x200000ff22227230ULL, 0x000fe40000000000ULL, 0x200000ff21217230ULL, 0x000fe40000000000ULL,
0x200000ff20207230ULL, 0x000fe40000000000ULL, 0x0000002f2b2b7230ULL, 0x000fe40000000000ULL,
0x0000002e2a2a7230ULL, 0x000fe40000000000ULL, 0x0000002d29297230ULL, 0x000fc40000000000ULL,
0x0000002c28287230ULL, 0x000fe40000000000ULL, 0x0000003313137230ULL, 0x000fe40000000000ULL,
0x0000003212127230ULL, 0x000fe20000000000ULL, 0x000000280a007388ULL, 0x000fe20000000c00ULL,
0x0000003111117230ULL, 0x000fe40000000000ULL, 0x0000003010107230ULL, 0x000fe40000000000ULL,
0x0000003b37377230ULL, 0x000fc40000000000ULL, 0x0000003a36367230ULL, 0x000fe20000000000ULL,
0x000400100a007388ULL, 0x000fe20000000c00ULL, 0x0000003935357230ULL, 0x000fe40000000000ULL,
0x0000003834347230ULL, 0x000fe40000000000ULL, 0x0000003f23237230ULL, 0x000fe40000000000ULL,
0x0000003e22227230ULL, 0x000fe20000000000ULL, 0x000800340a007388ULL, 0x000fe20000000c00ULL,
0x0000003d21217230ULL, 0x000fc40000000000ULL, 0x0000003c20207230ULL, 0x000fca0000000000ULL,
0x000c00200a007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000393000008947ULL, 0x000fea0003800000ULL, 0x00000400ff077624ULL, 0x000fe200078e00ffULL,
0x0000000000167919ULL, 0x000e620000002600ULL, 0x000000800d117810ULL, 0x000fc40007ffe0ffULL,
0x00006a0007077a24ULL, 0x000fe200078e02ffULL, 0x00000000000f7919ULL, 0x000e620000002700ULL,
0x000000c00d137810ULL, 0x000fc60007ffe0ffULL, 0x0000000f07097811ULL, 0x040fe200078e10ffULL,
0x0000030007077a24ULL, 0x000fe200078e02ffULL, 0x000000000a187984ULL, 0x0004e40000000c00ULL,
0xfffffff009247812ULL, 0x000fe400078ec0ffULL, 0x000400000a207984ULL, 0x0004a60000000c00ULL,
0x0000008007267824ULL, 0x040fe200078e0224ULL, 0x000800000a287984ULL, 0x0002a60000000c00ULL,
0x0000008007077824ULL, 0x000fe200078e0226ULL, 0x000c00000a2c7984ULL, 0x0004a80000000c00ULL,
0x0000007f07097810ULL, 0x000fe20007ffe0ffULL, 0x000004000f167a24ULL, 0x002fe200078e0216ULL,
0x000000400d0f7810ULL, 0x000fc40007ffe0ffULL, 0xffffff8009177812ULL, 0x000fe200078ec0ffULL,
0x0000030016077a24ULL, 0x000fc600078e02ffULL, 0x00006e0017097a10ULL, 0x000fe20007f1e0ffULL,
0x0000000107127824ULL, 0x000fca00078e0208ULL, 0x0000000912087211ULL, 0x000fe200078268ffULL,
0x00006f00ff097624ULL, 0x000fe200000e06ffULL, 0x0000000103ff7812ULL, 0x000fc8000780f89aULL,
0x0000000912097211ULL, 0x000fe400008f6cffULL, 0x00006e0024307a10ULL, 0x000fc60007f3e0ffULL,
0x0000100006087825ULL, 0x000fe200078e0008ULL, 0x00006f00ff1d7a10ULL, 0x000fca0000ffe4ffULL,
0x000000100d0c7825ULL, 0x000fc800078e0008ULL, 0x000000100f0e7825ULL, 0x000fc800078e0008ULL,
0x0000001011107825ULL, 0x000fc800078e0008ULL, 0x0000001013087825ULL, 0x000fe200078e0008ULL,
0x0000010000000947ULL, 0x000fea0003800000ULL, 0x00000010050a7824ULL, 0x00cfe200078e00ffULL,
0x00000001ff147819ULL, 0x000fe20000011605ULL, 0x0000008012137824ULL, 0x000fc600078e00ffULL,
0x000000700a157812ULL, 0x000fe400078ec0ffULL, 0x0000000c14327812ULL, 0x000fe400078ec0ffULL,
0x00006e0013147a10ULL, 0x000fe40007ebe026ULL, 0x00000019ff0a7819ULL, 0x000fe40000011612ULL,
0x0000003015137210ULL, 0x000fe40007a3e013ULL, 0x0000001432147210ULL, 0x000fc40007c7e015ULL,
0x00006f000a157a10ULL, 0x000fe40002fec4ffULL, 0x0000001332127210ULL, 0x000fe40007fbe0ffULL,
0x0000001dff0a7210ULL, 0x000fe40000fe440aULL, 0x00000015ff157210ULL, 0x000fc60001fe84ffULL,
0x000000ffff137224ULL, 0x000fca00028e060aULL, 0x0000001c12007986ULL, 0x0003e8000c101908ULL,
0x0000001e14007986ULL, 0x0003e4000c101908ULL, 0x000000ff0500720cULL, 0x00cfe20000705670ULL,
0x000000180c007986ULL, 0x000fe2000c101d08ULL, 0x0000017000007945ULL, 0x000fe60003800000ULL,
0x000000200e007986ULL, 0x000fe8000c101d08ULL, 0x0000002810007986ULL, 0x000fe8000c101d08ULL,
0x0000002c08007986ULL, 0x000fe8000c101d08ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000004ff097424ULL, 0x000fe200078e00ffULL,
0xffffffff1f0d7810ULL, 0x000fc60007ffe0ffULL, 0x00006e0016087625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x0000000d080879a8ULL, 0x000ea400099ee1c8ULL,
0x0000000d0800720cULL, 0x004fc80003f05270ULL, 0x00000001ff0a7807ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x0000000aff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000ff087984ULL, 0x000ee40000000000ULL, 0x000000ff0800720cULL, 0x008fda0003f05270ULL,
0x0000343000008947ULL, 0x000fea0003800000ULL, 0x000000ff9a00720cULL, 0x000fda0003f05270ULL,
0x00000a5000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x000001b000008947ULL, 0x000fea0003800000ULL, 0x0000001005097824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x004fe40000011605ULL, 0x0000003007087211ULL, 0x000fe400078038ffULL,
0x00000070090d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000001d07097211ULL, 0x000fe400000f3cffULL, 0x000000080a087210ULL, 0x000fc8000791e00dULL,
0x00000009ff097210ULL, 0x000fca00007e24ffULL, 0x00000008080c7981ULL, 0x000528000c1e1900ULL,
0x00008008080d7981ULL, 0x000522000c1e1900ULL, 0x000000021f00780cULL, 0x000fda0003f05270ULL,
0x000000f000008947ULL, 0x000fea0003800000ULL, 0x00010008080f7981ULL, 0x004522000c1e1900ULL,
0x000000041f00780cULL, 0x000fda0003f06070ULL, 0x000000c000008947ULL, 0x000fea0003800000ULL,
0x0001800808117981ULL, 0x004522000c1e1900ULL, 0x000000041f00780cULL, 0x000fda0003f05270ULL,
0x0000009000008947ULL, 0x000fea0003800000ULL, 0x0002000808137981ULL, 0x006322000c1e1900ULL,
0x000000061f00780cULL, 0x000fda0003f06070ULL, 0x0000006000008947ULL, 0x000fea0003800000ULL,
0x0002800808157981ULL, 0x002322000c1e1900ULL, 0x000000061f00780cULL, 0x000fda0003f05270ULL,
0x0000003000008947ULL, 0x000fea0003800000ULL, 0x000000081f00780cULL, 0x002fe20003f06070ULL,
0x0003000808197981ULL, 0x000318000c1e1900ULL, 0x00038008081b0981ULL, 0x000324000c1e1900ULL,
0x000000071f087810ULL, 0x006fc80007ffe0ffULL, 0x00000003ff0a7819ULL, 0x000fc80000011608ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000007d000008947ULL, 0x000fea0003800000ULL,
0x00000024071f7211ULL, 0x000fe200078038ffULL, 0x000000ffff107224ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1d7224ULL, 0x010fe200078e000cULL,
0x00006e001f1f7a10ULL, 0x000fe40007f3e0ffULL, 0x000000ff070e7211ULL, 0x000fe400000f3cffULL,
0x000007801f1f7810ULL, 0x000fc80007f5e0ffULL, 0x00006f00ff0e7a10ULL, 0x000fc400017e240eULL,
0x0000030010007a0cULL, 0x000fe20003f26070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x000000040a007c0cULL, 0x000fcc000bf03070ULL, 0x000006d000001947ULL, 0x012fea0003800000ULL,
0x0000000810087810ULL, 0x040fe40007ffe0ffULL, 0x0000000110097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000001d0c0c7209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001005087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011605ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x000000081f087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e060eULL,
0xfffc8008081d7981ULL, 0x000326000c1e1900ULL, 0x000005f000002947ULL, 0x000fea0003800000ULL,
0x0000000910087810ULL, 0x042fe40007ffe0ffULL, 0x0000000210097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000d0c0c7209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001005087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011605ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x000000081f087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e060eULL,
0xfffd0008080d7981ULL, 0x000326000c1e1900ULL, 0x0000051000002947ULL, 0x000fea0003800000ULL,
0x0000000a10087810ULL, 0x042fe40007ffe0ffULL, 0x0000000310097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x0000000f0c0c7209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001005087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011605ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x000000081f087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e060eULL,
0xfffd8008080f7981ULL, 0x000326000c1e1900ULL, 0x0000043000002947ULL, 0x000fea0003800000ULL,
0x0000000b10087810ULL, 0x042fe40007ffe0ffULL, 0x0000000410097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000110c0c7209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001005087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011605ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x000000081f087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e060eULL,
0xfffe000808117981ULL, 0x000326000c1e1900ULL, 0x0000035000002947ULL, 0x000fea0003800000ULL,
0x0000000c10087810ULL, 0x042fe40007ffe0ffULL, 0x0000000510097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000130c0c7209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001005087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011605ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x000000081f087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e060eULL,
0xfffe800808137981ULL, 0x000326000c1e1900ULL, 0x0000027000002947ULL, 0x000fea0003800000ULL,
0x0000000d10087810ULL, 0x042fe40007ffe0ffULL, 0x0000000610097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000150c0c7209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000000405087819ULL, 0x000fe400000006ffULL, 0x00000001ff097819ULL, 0x000fe40000011605ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x000000081f087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e060eULL,
0xffff000808157981ULL, 0x000326000c1e1900ULL, 0x0000019000002947ULL, 0x000fea0003800000ULL,
0x0000000e10087810ULL, 0x042fe40007ffe0ffULL, 0x0000000710097810ULL, 0x000fe40007ffe0ffULL,
0x0000030008007a0cULL, 0x000fe40003f26070ULL, 0x0000030009007a0cULL, 0x000fe40003f46070ULL,
0x000000190c0c7209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001005087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011605ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x000000081f087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e060eULL,
0xffff800808197981ULL, 0x000326000c1e1900ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000000f10087810ULL, 0x002fe40007ffe0ffULL, 0x0000001b0c0c7209ULL, 0x000fe40007810000ULL,
0x0000030008007a0cULL, 0x000fda0003f26070ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x0000001005087824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011605ULL,
0x0000007008087812ULL, 0x000fc800078ec0ffULL, 0x0000000c08087812ULL, 0x000fc800078ef809ULL,
0x000000081f087210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff097224ULL, 0x000fca00008e060eULL,
0x00000008081b7981ULL, 0x000326000c1e1900ULL, 0x000004001f1f7810ULL, 0x000fe40007f3e0ffULL,
0x0000000810107810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200008e060eULL,
0xfffff8b000008947ULL, 0x000fea000383ffffULL, 0x0000000000057919ULL, 0x000ea40000000000ULL,
0x0000001005087824ULL, 0x006fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fc80000011605ULL,
0x0000007008087812ULL, 0x000fe400078ec0ffULL, 0x0000000c09097812ULL, 0x000fca00078ec0ffULL,
0x0000000108097824ULL, 0x000fca00078e0209ULL, 0x0000000c09007388ULL, 0x0103e40000000800ULL,
0x000000070500780cULL, 0x000fe20003f04070ULL, 0x0000000103117824ULL, 0x000fe200078e0207ULL,
0x00006e0017087a10ULL, 0x000fe20007f3e0ffULL, 0x00001000060a7824ULL, 0x004fe200078e00ffULL,
0x00000001030e7812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00006f00ff097624ULL, 0x002fe200008e06ffULL, 0x0000002005177810ULL, 0x000fe20007ffe0ffULL,
0x00000002030f8824ULL, 0x000fe200078e0206ULL, 0x0000004005197810ULL, 0x000fe20007ffe0ffULL,
0x00002000110c7825ULL, 0x000fe200078e0008ULL, 0x00000060051b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x00000080051d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000203138824ULL, 0x000fe200078e0206ULL, 0x0000000a0c0c7210ULL, 0x000fe20007f3e0ffULL,
0x000000020f288824ULL, 0x100fe200078e020eULL, 0x000000a0051f7810ULL, 0x000fe20007ffe0ffULL,
0x00000002132a8824ULL, 0x000fe200078e020eULL, 0x000010000b0e7812ULL, 0x000fe200078ec0ffULL,
0x00004000030b7824ULL, 0x000fe200078e0200ULL, 0x000000c005217810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x000000e005237810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0e7824ULL, 0x000fe200078e020eULL, 0x0000000405137819ULL, 0x000fe200000006ffULL,
0x0000001017167825ULL, 0x000fe200078e000cULL, 0x00000001ff127819ULL, 0x000fe20000011605ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000007013137812ULL, 0x000fe200078ec0ffULL,
0x0000001019187825ULL, 0x100fe200078e000cULL, 0x0000000c12127812ULL, 0x000fe200078ec0ffULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x000000101b1a7825ULL, 0x100fe200078e000cULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x000000101d1c7825ULL, 0x100fe200078e000cULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x000000101f1e7825ULL, 0x100fe200078e000cULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000001021207825ULL, 0x100fe200078e000cULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000001023227825ULL, 0x100fe200078e000cULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x0000001005147825ULL, 0x000fe200078e000cULL, 0x00006e00260d7a10ULL, 0x000fc60007f3e0ffULL,
0x0000001005297824ULL, 0x000fe200078e020eULL, 0x00006e00240e7a10ULL, 0x000fe20007f5e0ffULL,
0x00006f00ff0f7624ULL, 0x000fe200008e06ffULL, 0x0000000d11248211ULL, 0x000fe200078238ffULL,
0x0000000113277824ULL, 0x000fe400078e0212ULL, 0x00006f00ff107624ULL, 0x000fe200010e06ffULL,
0x0000000e11268211ULL, 0x040fe200078438ffULL, 0x0000000828288824ULL, 0x100fe200078e0205ULL,
0x0000000f11258211ULL, 0x000fe200008f3cffULL, 0x00000000270c7984ULL, 0x0002a20000000800ULL,
0x0000030003007a0cULL, 0x000fe20003f26070ULL, 0x000000082a2a8824ULL, 0x000fc400078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0018000014297faeULL, 0x0007e2000b901c48ULL,
0x0000001005248825ULL, 0x000fe400078e0024ULL, 0x000081802a2b8811ULL, 0x000fe200078e20ffULL,
0x0038000016297faeULL, 0x0009e2000b901c48ULL, 0x0000001011278211ULL, 0x002fe200010f3cffULL,
0x000000ffff117224ULL, 0x000fe400078e00ffULL, 0x0058000018297faeULL, 0x0003e2000b901c48ULL,
0x000000ffff527224ULL, 0x000fe400078e00ffULL, 0x0000001005268825ULL, 0x000fe200078e0026ULL,
0x007800001a297faeULL, 0x0003e2000b901c48ULL, 0x0000000000147805ULL, 0x008fc4000001ff00ULL,
0x000000ffff547224ULL, 0x000fe200078e00ffULL, 0x009800001c297faeULL, 0x0007e2000b901c48ULL,
0x0000000000167805ULL, 0x010fc6000001ff00ULL, 0x00b800001e297faeULL, 0x0009e2000b901c48ULL,
0x0000000000187805ULL, 0x002fe2000001ff00ULL, 0x00008580281b8811ULL, 0x000fe400078e20ffULL,
0x00d8000020297faeULL, 0x0003e2000b901c48ULL, 0x00000000001c7805ULL, 0x008fc6000001ff00ULL,
0x00f8000022297faeULL, 0x0007e2000b901c48ULL, 0x00000000001e7805ULL, 0x010fc6000001ff00ULL,
0x00000000241b8faeULL, 0x0009e8000b901c48ULL, 0x00000000262b8faeULL, 0x0005e2000b901c48ULL,
0x0000000000207805ULL, 0x002fc6000001ff00ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000000227805ULL, 0x008fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x010fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x004fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x000012f000001947ULL, 0x000fea0003800000ULL, 0x000000ffff117224ULL, 0x000fe400078e00ffULL,
0x000000ffff537224ULL, 0x000fca00078e0003ULL, 0x0000000153567810ULL, 0x000fc80007ffe0ffULL,
0x0000030056007a0cULL, 0x000fda0003f06070ULL, 0x0000034000000947ULL, 0x000fea0003800000ULL,
0x000000070500780cULL, 0x000fe20003f44070ULL, 0x0000000107677824ULL, 0x000fe200078e0256ULL,
0x0000000156577812ULL, 0x040fe200078ec0ffULL, 0x0000100056557824ULL, 0x000fe200078e00ffULL,
0x0000002005597810ULL, 0x000fe20007ffe0ffULL, 0x0000200067127825ULL, 0x000fe200078e0008ULL,
0x00000040055b7810ULL, 0x000fe40007ffe0ffULL, 0x0000100055567812ULL, 0x000fe400078ec0ffULL,
0x0000000a12127210ULL, 0x000fc40007f1e0ffULL, 0x00000060055d7810ULL, 0x000fe20007ffe0ffULL,
0x000000020358a824ULL, 0x100fe200078e0206ULL, 0x00000080055f7810ULL, 0x000fe20007ffe0ffULL,
0x000000020368a824ULL, 0x000fe200078e0206ULL, 0x000000a005617810ULL, 0x000fe20007ffe0ffULL,
0x000000010b567824ULL, 0x000fe200078e0256ULL, 0x000000c005637810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x000000e005657810ULL, 0x040fe20007ffe0ffULL,
0x000000026868a824ULL, 0x000fe200078e0257ULL, 0x00000057586aa211ULL, 0x000fe200078e08ffULL,
0x0000001005557824ULL, 0x000fe200078e0256ULL, 0x0000000d6764a211ULL, 0x000fe200078038ffULL,
0x0000001005567825ULL, 0x000fe200078e0012ULL, 0x0000000e6766a211ULL, 0x000fc600078238ffULL,
0x0000001059587825ULL, 0x100fe200078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000056557faeULL, 0x0003e6000b901c48ULL, 0x000000105b5a7825ULL, 0x100fe200078e0012ULL,
0x0038000058557faeULL, 0x0005e6000b901c48ULL, 0x000000105d5c7825ULL, 0x100fe200078e0012ULL,
0x005800005a557faeULL, 0x0007e6000b901c48ULL, 0x000000105f5e7825ULL, 0x100fe200078e0012ULL,
0x007800005c557faeULL, 0x0007e6000b901c48ULL, 0x0000001061607825ULL, 0x100fe200078e0012ULL,
0x009800005e557faeULL, 0x0007e6000b901c48ULL, 0x0000001063627825ULL, 0x100fe200078e0012ULL,
0x00b8000060557faeULL, 0x0007e6000b901c48ULL, 0x0000001065127825ULL, 0x000fe200078e0012ULL,
0x0000000f6765a211ULL, 0x040fe200000f3cffULL, 0x00d8000062557faeULL, 0x0007e2000b901c48ULL,
0x000000106767a211ULL, 0x000fe200008f3cffULL, 0x000000086868a824ULL, 0x000fc400078e0205ULL,
0x000000086a6aa824ULL, 0x000fe200078e0205ULL, 0x00f8000012557faeULL, 0x0007e2000b901c48ULL,
0x000000100564a825ULL, 0x040fe200078e0064ULL, 0x000085806869a811ULL, 0x000fe400078e20ffULL,
0x000081806a59a811ULL, 0x004fe200078e20ffULL, 0x000000100556a825ULL, 0x002fe400078e0066ULL,
0x000000006469afaeULL, 0x0007e8000b901c48ULL, 0x000000005659afaeULL, 0x0007e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000008053127824ULL, 0x008fe200078e00ffULL,
0x00000001ff567819ULL, 0x100fe20000011605ULL, 0x0000000203557824ULL, 0x000fe200078e0206ULL,
0x00000002ff6a7819ULL, 0x000fe20000011605ULL, 0x0000001005137824ULL, 0x000fe200078e00ffULL,
0x0000008012127812ULL, 0x000fc400078ec0ffULL, 0x000000086a6c7810ULL, 0x040fe20007ffe0ffULL,
0x000000086a587824ULL, 0x000fe200078e00ffULL, 0x0000007013137812ULL, 0x000fe200078ec0ffULL,
0x0000010055557824ULL, 0x000fe200078e0012ULL, 0x0000000c56127812ULL, 0x000fe200078ec0ffULL,
0x000000086a617824ULL, 0x040fe200078e00ffULL, 0x000000026a567810ULL, 0x040fe20007ffe0ffULL,
0x000000086a677824ULL, 0x000fe200078e00ffULL, 0x0000005512577210ULL, 0x000fe20007ffe013ULL,
0x000000086a697824ULL, 0x040fe200078e00ffULL, 0x000000016a557810ULL, 0x040fe20007ffe0ffULL,
0x000000086a607824ULL, 0x040fe200078e00ffULL, 0xfffffff861617812ULL, 0x000fe200078ee256ULL,
0x000000086a6f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8585f7812ULL, 0x000fe200078ee255ULL,
0x0000100053557824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0081800057597984ULL, 0x000e620000000800ULL, 0x000000036a567810ULL, 0x040fe20007ffe0ffULL,
0x0000000405587824ULL, 0x000fe200078e00ffULL, 0x000000186a6e7810ULL, 0x040fe20007ffe0ffULL,
0x00858000575c7984ULL, 0x0004e20000000800ULL, 0xfffffff867677812ULL, 0x000fe400078ee256ULL,
0x0000100055567812ULL, 0x000fe200078ec0ffULL, 0x000000086a557824ULL, 0x000fe200078e00ffULL,
0x0000000c58627812ULL, 0x000fe200078ec0ffULL, 0x000000086e637824ULL, 0x000fe200078e00ffULL,
0x000001800b567810ULL, 0x000fc40007ffe056ULL, 0xfffffff855557812ULL, 0x000fe400078ee26aULL,
0x000000036c577819ULL, 0x004fe400000006ffULL, 0x000000046a5a7810ULL, 0x040fe20007ffe0ffULL,
0x0000001055557824ULL, 0x000fe200078e0256ULL, 0xfffffff857577812ULL, 0x000fe400078ee26cULL,
0x000000106a667810ULL, 0x000fe20007ffe0ffULL, 0x0000000162557824ULL, 0x000fe200078e0255ULL,
0xfffffff869697812ULL, 0x000fe200078ee25aULL, 0x0000001057577824ULL, 0x000fe200078e0256ULL,
0x000000056a5d7810ULL, 0x000fc40007ffe0ffULL, 0x000000066a5e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000055557984ULL, 0x000ea20000000800ULL, 0x0000000162587824ULL, 0x000fe200078e0257ULL,
0xfffffff863577812ULL, 0x000fe400078ee26eULL, 0xfffffff8606d7812ULL, 0x000fe400078ee25dULL,
0x0000000058637984ULL, 0x0008a20000000800ULL, 0x0000001057577824ULL, 0x000fe200078e0256ULL,
0xfffffff86f6f7812ULL, 0x000fe400078ee25eULL, 0xffffffff6a5e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001625d7824ULL, 0x000fe200078e0257ULL, 0x000000590c597221ULL, 0x002fe20000010100ULL,
0x000000105f577824ULL, 0x100fe200078e0256ULL, 0x0000000253537810ULL, 0x000fe20007ffe0ffULL,
0x0000001061587824ULL, 0x010fe200078e0256ULL, 0x3fb8aa3b595a7820ULL, 0x000fe20000410000ULL,
0x0000000866597824ULL, 0x000fe200078e00ffULL, 0x000000005d657984ULL, 0x000fe20000000800ULL,
0x0000000162577824ULL, 0x000fe200078e0257ULL, 0x0000005a005b7308ULL, 0x0002e20000000800ULL,
0x000000086a617824ULL, 0x000fe200078e00ffULL, 0xfffffff859597812ULL, 0x000fe200078ee266ULL,
0x000000106f5f7824ULL, 0x000fe200078e0256ULL, 0x0000030053007a0cULL, 0x000fc40003f06070ULL,
0xfffffff861617812ULL, 0x000fe200078ee25eULL, 0x0000001059597824ULL, 0x100fe400078e0256ULL,
0x000000106d5e7824ULL, 0x000fe400078e0256ULL, 0x00000001625a7824ULL, 0x042fe400078e0259ULL,
0x0000000162597824ULL, 0x040fe400078e0258ULL, 0x0000000057587984ULL, 0x000fe20000000800ULL,
0x0000005c5b6b7220ULL, 0x008fe20000410000ULL, 0x00000010675b7824ULL, 0x100fe200078e0256ULL,
0x00000056695c7211ULL, 0x000fe200078e20ffULL, 0x000000005a647984ULL, 0x000fe20000000800ULL,
0x0000001061617824ULL, 0x000fe200078e0256ULL, 0x000000546b547221ULL, 0x000fe20000010000ULL,
0x00000001625b7824ULL, 0x040fe200078e025bULL, 0x00001f6c6b6c7589ULL, 0x000e6200000e0000ULL,
0x00000001625c7824ULL, 0x000fc400078e025cULL, 0x0000000162607824ULL, 0x040fe200078e025fULL,
0x00000000595a7984ULL, 0x000fe20000000800ULL, 0x00000001625e7824ULL, 0x040fe400078e025eULL,
0x0000000162617824ULL, 0x000fe200078e0261ULL, 0x000000005b567984ULL, 0x000fe20000000800ULL,
0x20000055ff677230ULL, 0x104fe40000004100ULL, 0x30000055ff627230ULL, 0x000fe20000004100ULL,
0x000000005c5d7984ULL, 0x000fe20000000800ULL, 0x20000063ff697230ULL, 0x000fc60000004100ULL,
0x00001f6a6b6a7589ULL, 0x000ea800000e0000ULL, 0x00001f6e6b6e7589ULL, 0x000ee800000e0000ULL,
0x0000000060557984ULL, 0x000fe20000000800ULL, 0x0000006c694e7223ULL, 0x002fe2000001004eULL,
0x20000065ff697230ULL, 0x000fc40000004100ULL, 0x00001f666b6d7589ULL, 0x00032800000e0000ULL,
0x000000005e5f7984ULL, 0x000f220000000800ULL, 0x20000064ff667230ULL, 0x002fe20000004100ULL,
0x0000006a67507223ULL, 0x084fe20000010050ULL, 0x30000063ff677230ULL, 0x000fe20000004100ULL,
0x0000006a624f7223ULL, 0x000fe2000001004fULL, 0x0004000057637984ULL, 0x000e620000000800ULL,
0x0000006e69307223ULL, 0x008fe20000010030ULL, 0x30000065ff697230ULL, 0x000fe20000004100ULL,
0x0000006c67327223ULL, 0x000fe20000010032ULL, 0x0000000061627984ULL, 0x000ea20000000800ULL,
0x20000058ff657230ULL, 0x000fc40000004100ULL, 0x30000064ff647230ULL, 0x000fe20000004100ULL,
0x0000006e69467223ULL, 0x000fe20000010046ULL, 0x30000058ff677230ULL, 0x000fe20000004100ULL,
0x0000006a652e7223ULL, 0x080fe2000001002eULL, 0x000400005b587984ULL, 0x000ee20000000800ULL,
0x0000006d664d7223ULL, 0x090fe2000001004dULL, 0x0000006d64317223ULL, 0x000fe20000010031ULL,
0x0000006a674c7223ULL, 0x080fe2000001004cULL, 0x000400005c657984ULL, 0x000f220000000800ULL,
0x2000005aff667230ULL, 0x100fe40000004100ULL, 0x3000005aff677230ULL, 0x000fe20000004100ULL,
0x0004000059647984ULL, 0x000f220000000800ULL, 0x20000056ff5a7230ULL, 0x100fe20000004100ULL,
0x0000006a664b7223ULL, 0x080fe2000001004bULL, 0x30000056ff697230ULL, 0x000fe20000004100ULL,
0x000400005e667984ULL, 0x000f220000000800ULL, 0x2000005dff567230ULL, 0x000fe20000004100ULL,
0x0000006a67367223ULL, 0x080fe20000010036ULL, 0x0000006a5a477223ULL, 0x080fe20000010047ULL,
0x20000055ff5a7230ULL, 0x100fe20000004100ULL, 0x0000006a69447223ULL, 0x080fe20000010044ULL,
0x0000006a56437223ULL, 0x080fe20000010043ULL, 0x30000055ff677230ULL, 0x000fe20000004100ULL,
0x0004000060567984ULL, 0x000f220000000800ULL, 0x0000006a5a3b7223ULL, 0x000fe2000001003bULL,
0x3000005dff5d7230ULL, 0x000fc40000004100ULL, 0x0004000061557984ULL, 0x000f220000000800ULL,
0x0000006a67387223ULL, 0x080fe40000010038ULL, 0x0000006a5d407223ULL, 0x080fe20000010040ULL,
0x00080000575a7984ULL, 0x000f220000000800ULL, 0x2000005fff5d7230ULL, 0x000fe40000004100ULL,
0x30000063ff687230ULL, 0x002fe40000004100ULL, 0x3000005fff5f7230ULL, 0x000fe20000004100ULL,
0x0000006a5d207223ULL, 0x000fe20000010020ULL, 0x20000062ff5d7230ULL, 0x104fe20000004100ULL,
0x0000006c68497223ULL, 0x000fe20000010049ULL, 0x30000062ff627230ULL, 0x000fe20000004100ULL,
0x0000006a5f3c7223ULL, 0x080fe2000001003cULL, 0x20000063ff677230ULL, 0x000fe20000004100ULL,
0x0000006a5d4a7223ULL, 0x080fe2000001004aULL, 0x20000058ff687230ULL, 0x108fe20000004100ULL,
0x00080000595d7984ULL, 0x000fe20000000800ULL, 0x30000058ff637230ULL, 0x000fe20000004100ULL,
0x0000006a62357223ULL, 0x000fe20000010035ULL, 0x20000065ff587230ULL, 0x010fe20000004100ULL,
0x000c0000575f7984ULL, 0x000e620000000800ULL, 0x0000006c67347223ULL, 0x080fe20000010034ULL,
0x20000064ff627230ULL, 0x100fe20000004100ULL, 0x0000006c68457223ULL, 0x080fe20000010045ULL,
0x30000064ff647230ULL, 0x000fe20000004100ULL, 0x000800005b577984ULL, 0x000ea20000000800ULL,
0x0000006c583f7223ULL, 0x080fe2000001003fULL, 0x0000006c621b7223ULL, 0x080fe2000001001bULL,
0x30000066ff677230ULL, 0x100fe20000004100ULL, 0x000800005c587984ULL, 0x000ee20000000800ULL,
0x0000006c642f7223ULL, 0x080fe2000001002fULL, 0x20000066ff647230ULL, 0x000fe20000004100ULL,
0x0000006c63267223ULL, 0x080fe20000010026ULL, 0x000c000059627984ULL, 0x0008e20000000800ULL,
0x20000056ff667230ULL, 0x100fe20000004100ULL, 0x0000006c673a7223ULL, 0x080fe2000001003aULL,
0x30000056ff687230ULL, 0x000fe20000004100ULL, 0x0000006c643d7223ULL, 0x080fe2000001003dULL,
0x000800005e567984ULL, 0x000ee20000000800ULL, 0x30000055ff6a7230ULL, 0x100fe20000004100ULL,
0x0000006c66257223ULL, 0x080fe20000010025ULL, 0x20000055ff597230ULL, 0x010fe20000004100ULL,
0x000c00005c647984ULL, 0x0008e20000000800ULL, 0x30000065ff657230ULL, 0x000fe20000004100ULL,
0x0000006c68377223ULL, 0x080fe20000010037ULL, 0x0000006c6a337223ULL, 0x080fe20000010033ULL,
0x0000006c591c7223ULL, 0x080fe2000001001cULL, 0x2000005aff597230ULL, 0x100fe20000004100ULL,
0x000c00005b637984ULL, 0x000ee20000000800ULL, 0x0000006c65247223ULL, 0x000fe20000010024ULL,
0x3000005aff5c7230ULL, 0x010fc40000004100ULL, 0x000c0000605a7984ULL, 0x000f220000000800ULL,
0x0000006d59187223ULL, 0x080fe40000010018ULL, 0x0000006d5c2d7223ULL, 0x080fe2000001002dULL,
0x000c00005e5b7984ULL, 0x0005280000000800ULL, 0x0008000060557984ULL, 0x0007220000000800ULL,
0x2000005fff657230ULL, 0x102fe40000004100ULL, 0x3000005fff667230ULL, 0x000fe20000004100ULL,
0x0008000061597984ULL, 0x000e620000000800ULL, 0x3000005dff5e7230ULL, 0x104fe20000004100ULL,
0x0000006e652c7223ULL, 0x080fe2000001002cULL, 0x2000005dff5f7230ULL, 0x000fe20000004100ULL,
0x000c0000615c7984ULL, 0x000ea20000000800ULL, 0x20000057ff5d7230ULL, 0x100fe20000004100ULL,
0x0000006d5e417223ULL, 0x080fe20000010041ULL, 0x30000057ff5e7230ULL, 0x000fe20000004100ULL,
0x0000006e662b7223ULL, 0x080fe2000001002bULL, 0x20000058ff577230ULL, 0x008fe20000004100ULL,
0x0000006d5d3e7223ULL, 0x080fe2000001003eULL, 0x20000062ff657230ULL, 0x000fe20000004100ULL,
0x0000006d5f2a7223ULL, 0x080fe2000001002aULL, 0x30000058ff587230ULL, 0x000fe20000004100ULL,
0x0000006d57227223ULL, 0x080fe20000010022ULL, 0x20000056ff577230ULL, 0x100fe20000004100ULL,
0x0000006e65287223ULL, 0x080fe20000010028ULL, 0x30000056ff567230ULL, 0x000fe20000004100ULL,
0x0000006d581f7223ULL, 0x080fe2000001001fULL, 0x20000064ff5d7230ULL, 0x000fe20000004100ULL,
0x0000006d571e7223ULL, 0x080fe2000001001eULL, 0x30000062ff627230ULL, 0x000fe20000004100ULL,
0x0000006d561d7223ULL, 0x080fe2000001001dULL, 0x30000064ff647230ULL, 0x000fe20000004100ULL,
0x0000006e5d427223ULL, 0x080fe20000010042ULL, 0x20000063ff607230ULL, 0x100fe20000004100ULL,
0x0000006e62277223ULL, 0x080fe20000010027ULL, 0x30000063ff627230ULL, 0x000fe20000004100ULL,
0x0000006d5e297223ULL, 0x080fe20000010029ULL, 0x2000005aff567230ULL, 0x110fe20000004100ULL,
0x0000006e60217223ULL, 0x080fe20000010021ULL, 0x3000005aff5a7230ULL, 0x000fe20000004100ULL,
0x0000006e62237223ULL, 0x080fe20000010023ULL, 0x2000005bff5d7230ULL, 0x100fe20000004100ULL,
0x0000006e56197223ULL, 0x080fe20000010019ULL, 0x3000005bff5b7230ULL, 0x000fe20000004100ULL,
0x0000006e64397223ULL, 0x080fe20000010039ULL, 0x20000055ff577230ULL, 0x100fe20000004100ULL,
0x0000006e5d487223ULL, 0x080fe20000010048ULL, 0x30000055ff557230ULL, 0x000fe20000004100ULL,
0x0000006e5b527223ULL, 0x080fe20000010052ULL, 0x20000059ff567230ULL, 0x102fe20000004100ULL,
0x0000006d57147223ULL, 0x080fe20000010014ULL, 0x30000059ff597230ULL, 0x000fe20000004100ULL,
0x0000006d551a7223ULL, 0x080fe2000001001aULL, 0x2000005cff587230ULL, 0x104fe20000004100ULL,
0x0000006e5a517223ULL, 0x080fe20000010051ULL, 0x3000005cff5c7230ULL, 0x000fe20000004100ULL,
0x0000006d56177223ULL, 0x080fe20000010017ULL, 0x0000006d59167223ULL, 0x000fe20000010016ULL,
0x0000006e58157223ULL, 0x000fc40000010015ULL, 0x0000006e5c117223ULL, 0x000fe20000010011ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffed3000007947ULL, 0x000fea000383ffffULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x0000017000007945ULL, 0x000fd80003800000ULL,
0x0000008003058824ULL, 0x000fc800078e0213ULL, 0x0000000112058824ULL, 0x000fe400078e0205ULL,
0x0000000113127824ULL, 0x000fc600078e0212ULL, 0x0089805405008388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0089800012077984ULL, 0x000e680000000800ULL,
0x008a000012087984ULL, 0x000ea20000000800ULL, 0x00000007ff077221ULL, 0x002fc80000010000ULL,
0x0000000807077221ULL, 0x004fca0000010000ULL, 0x0180000007087810ULL, 0x000fc80007ffe0ffULL,
0x7f80000008087812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0800780cULL, 0x000fda0003f04070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000d800000a7802ULL, 0x000fc40000000f00ULL, 0x0000bce000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff087224ULL, 0x00cfe200078e0005ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000700087308ULL, 0x000e640000001000ULL, 0xbf80000007057423ULL, 0x002fc80000000008ULL,
0x800000ff05057221ULL, 0x000fc80000010100ULL, 0x0000000508087223ULL, 0x000fc40000000008ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000ea80000000000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000002ff537819ULL, 0x004fc40000011605ULL,
0x0000000805557811ULL, 0x040fe400078ff0ffULL, 0x0000001005577811ULL, 0x040fe200078ff0ffULL,
0x00001f5308077589ULL, 0x002e6200000e0000ULL, 0x0000001805597811ULL, 0x000fe200078ff0ffULL,
0x00000008535b7824ULL, 0x000fe400078e00ffULL, 0x00001f55080a7589ULL, 0x000ea800000e0000ULL,
0x00001f57080e7589ULL, 0x000ee800000e0000ULL, 0x00001f5908107589ULL, 0x0008a200000e0000ULL,
0x0000005007507220ULL, 0x042fe20000410000ULL, 0x0000004f074f7220ULL, 0x040fe20000410000ULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0x0000004c07097220ULL, 0x040fe20000410000ULL,
0x0000004b074b7220ULL, 0x040fe20000410000ULL, 0x0000003607367220ULL, 0x040fe20000410000ULL,
0x0000004707477220ULL, 0x040fe20000410000ULL, 0x0000004407447220ULL, 0x040fe20000410000ULL,
0x0000004307437220ULL, 0x040fe20000410000ULL, 0x0000004007407220ULL, 0x040fe20000410000ULL,
0x0000002007207220ULL, 0x040fe20000410000ULL, 0x0000003c070b7220ULL, 0x040fe20000410000ULL,
0x0000003b073b7220ULL, 0x040fe20000410000ULL, 0x0000003807387220ULL, 0x040fe20000410000ULL,
0x0000004a074a7220ULL, 0x040fe20000410000ULL, 0x0000003507077220ULL, 0x000fe20000410000ULL,
0x0000002f0a0c7220ULL, 0x044fe20000410000ULL, 0x0000004e0a4e7220ULL, 0x040fe20000410000ULL,
0x000000320a0d7220ULL, 0x040fe20000410000ULL, 0x000000340a347220ULL, 0x040fe20000410000ULL,
0x000000490a497220ULL, 0x040fe20000410000ULL, 0x0000001b0a1b7220ULL, 0x040fe20000410000ULL,
0x000000450a457220ULL, 0x040fe20000410000ULL, 0x000000260a267220ULL, 0x040fe20000410000ULL,
0x0000003f0a3f7220ULL, 0x040fe20000410000ULL, 0x000000240a247220ULL, 0x040fe20000410000ULL,
0x0000003d0a3d7220ULL, 0x040fe20000410000ULL, 0x0000003a0a3a7220ULL, 0x040fe20000410000ULL,
0x000000250a257220ULL, 0x040fe20000410000ULL, 0x000000370a087220ULL, 0x050fe20000410000ULL,
0x0000001c0a1c7220ULL, 0x040fe20000410000ULL, 0x000000330a337220ULL, 0x000fe20000410000ULL,
0x0000001a0e0f7220ULL, 0x048fe20000410000ULL, 0x00000008532f7824ULL, 0x040fe200078e00ffULL,
0x0000004d0e4d7220ULL, 0x040fe20000410000ULL, 0x0000000853357824ULL, 0x040fe200078e00ffULL,
0x000000310e0a7220ULL, 0x040fe20000410000ULL, 0x000000180e187220ULL, 0x040fe20000410000ULL,
0x0000002d0e2d7220ULL, 0x040fe20000410000ULL, 0x0000002a0e2a7220ULL, 0x040fe20000410000ULL,
0x000000410e417220ULL, 0x040fe20000410000ULL, 0x0000003e0e3e7220ULL, 0x040fe20000410000ULL,
0x000000290e297220ULL, 0x040fe20000410000ULL, 0x000000220e227220ULL, 0x040fe20000410000ULL,
0x0000001f0e1f7220ULL, 0x040fe20000410000ULL, 0x0000001e0e1e7220ULL, 0x040fe20000410000ULL,
0x0000001d0e1d7220ULL, 0x040fe20000410000ULL, 0x000000140e147220ULL, 0x040fe20000410000ULL,
0x000000170e177220ULL, 0x040fe20000410000ULL, 0x00000001531a7810ULL, 0x040fe20007ffe0ffULL,
0x000000160e0e7220ULL, 0x000fe20000410000ULL, 0x0000000353327810ULL, 0x040fe20007ffe0ffULL,
0x0000002310127220ULL, 0x040fe20000410000ULL, 0x0000003010307220ULL, 0x040fe20000410000ULL,
0x0000004610137220ULL, 0x040fe20000410000ULL, 0x0000002c102c7220ULL, 0x040fe20000410000ULL,
0x0000002b102b7220ULL, 0x040fe20000410000ULL, 0x0000002810287220ULL, 0x040fe20000410000ULL,
0x0000002710277220ULL, 0x040fe20000410000ULL, 0x0000002110217220ULL, 0x040fe20000410000ULL,
0x0000004210427220ULL, 0x040fe20000410000ULL, 0x0000003910397220ULL, 0x040fe20000410000ULL,
0x0000004810487220ULL, 0x040fe20000410000ULL, 0x0000005210237220ULL, 0x040fe20000410000ULL,
0x0000001910197220ULL, 0x040fe20000410000ULL, 0x0000005110167220ULL, 0x040fe20000410000ULL,
0x0000001510157220ULL, 0x040fe20000410000ULL, 0x00000008533c7824ULL, 0x000fe200078e00ffULL,
0x0000001110107220ULL, 0x000fe20000410000ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee21aULL,
0x0000000853517824ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee232ULL,
0x0000000859467824ULL, 0x000fe200078e00ffULL, 0x0000000453117810ULL, 0x000fe20007ffe0ffULL,
0x000000102f2f7824ULL, 0x100fe200078e0202ULL, 0x0000000253317810ULL, 0x000fe20007ffe0ffULL,
0x0000001035357824ULL, 0x000fe200078e0202ULL, 0x00000005531a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000653327810ULL, 0x000fe40007ffe0ffULL, 0xfffffff83c377812ULL, 0x040fe400078ee211ULL,
0xfffffff83c317812ULL, 0x040fe400078ee231ULL, 0xfffffff851517812ULL, 0x000fe200078ee21aULL,
0x0000001037377824ULL, 0x000fe200078e0202ULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee232ULL,
0x0000000855327824ULL, 0x000fe200078e00ffULL, 0xfffffff83c117812ULL, 0x000fe200078ee253ULL,
0x00000008573c7824ULL, 0x000fe200078e00ffULL, 0xffffffff531a7810ULL, 0x000fe20007ffe0ffULL,
0x0000001031317824ULL, 0x100fe200078e0202ULL, 0x000000140f0f723eULL, 0x000fe200000000ffULL,
0x0000000405147824ULL, 0x000fe200078e00ffULL, 0x0000000353537819ULL, 0x000fe200000006ffULL,
0x0000001011117824ULL, 0x100fe200078e0202ULL, 0xfffffff832557812ULL, 0x000fe200078ee255ULL,
0x0000001051517824ULL, 0x000fe200078e0202ULL, 0xfffffff853537812ULL, 0x000fe200078ee21aULL,
0x000000105b5b7824ULL, 0x100fe200078e0202ULL, 0xfffffff83c577812ULL, 0x000fe200078ee257ULL,
0x0000001055557824ULL, 0x100fe200078e0202ULL, 0xfffffff846597812ULL, 0x000fe200078ee259ULL,
0x0000001053537824ULL, 0x100fe200078e0202ULL, 0x0000000c14147812ULL, 0x000fe200078ec0ffULL,
0x0000001057577824ULL, 0x100fe200078e0202ULL, 0x000000504f4f723eULL, 0x000fe200000000ffULL,
0x0000001059597824ULL, 0x000fe200078e0202ULL, 0x0000002e0909723eULL, 0x000fe200000000ffULL,
0x0000000111027824ULL, 0x000fe200078e0214ULL, 0x0000004b3636723eULL, 0x000fe200000000ffULL,
0x00000001142f7824ULL, 0x040fe200078e022fULL, 0x0000003114317210ULL, 0x040fe20007ffe0ffULL,
0x0000000114357824ULL, 0x000fe200078e0235ULL, 0x000000474444723eULL, 0x000fe200000000ffULL,
0x0000000114377824ULL, 0x000fe200078e0237ULL, 0x000000434040723eULL, 0x000fe200000000ffULL,
0x0000004f02007388ULL, 0x000fe20000000800ULL, 0x000000200b0b723eULL, 0x000fe200000000ffULL,
0x0000000114207824ULL, 0x000fe200078e0251ULL, 0x0000003b3838723eULL, 0x000fe200000000ffULL,
0x00000001145b7824ULL, 0x040fe200078e025bULL, 0x000000092f007388ULL, 0x000fe20000000800ULL,
0x0000004a0707723eULL, 0x000fe200000000ffULL, 0x0000000114537824ULL, 0x040fe200078e0253ULL,
0x0000004e0d0d723eULL, 0x000fe200000000ffULL, 0x0000003631007388ULL, 0x000fe20000000800ULL,
0x00000001141a7824ULL, 0x040fe200078e0255ULL, 0x000000344934723eULL, 0x000fe200000000ffULL,
0x0000000114577824ULL, 0x000fe200078e0257ULL, 0x0000004435007388ULL, 0x000fe20000000800ULL,
0x0000001b0c0c723eULL, 0x000fe200000000ffULL, 0x0000000114147824ULL, 0x000fe200078e0259ULL,
0x000000452626723eULL, 0x000fe200000000ffULL, 0x0000004037007388ULL, 0x000fe20000000800ULL,
0x0000003f2424723eULL, 0x000fc400000000ffULL, 0x0000003d3a3a723eULL, 0x000fe200000000ffULL,
0x0000000b20007388ULL, 0x000fe20000000800ULL, 0x000000250808723eULL, 0x000fe400000000ffULL,
0x0000001c331c723eULL, 0x000fe200000000ffULL, 0x000000385b007388ULL, 0x000fe20000000800ULL,
0x0000004d0a0a723eULL, 0x000fe400000000ffULL, 0x000000182d18723eULL, 0x000fe200000000ffULL,
0x0000000753007388ULL, 0x0003e20000000800ULL, 0x0000002a412a723eULL, 0x000fc400000000ffULL,
0x0000003e2929723eULL, 0x000fe200000000ffULL, 0x0000000d1a007388ULL, 0x000fe20000000800ULL,
0x000000221f1f723eULL, 0x000fe400000000ffULL, 0x0000001e1d1d723eULL, 0x000fe200000000ffULL,
0x000400342f007388ULL, 0x000fe20000000800ULL, 0x000000170e0e723eULL, 0x000fe200000000ffULL,
0x0000000104077824ULL, 0x002fe200078e0205ULL, 0x000000301313723eULL, 0x000fe200000000ffULL,
0x0004000c31007388ULL, 0x000fe20000000800ULL, 0x0000002c2b2b723eULL, 0x000fe200000000ffULL,
0x0000001007077824ULL, 0x000fe200078e0200ULL, 0x000000282727723eULL, 0x000fe200000000ffULL,
0x0004002635007388ULL, 0x000fe20000000800ULL, 0x000000211212723eULL, 0x000fc400000000ffULL,
0x000000423939723eULL, 0x000fe200000000ffULL, 0x0004002437007388ULL, 0x000fe20000000800ULL,
0x000000482323723eULL, 0x000fe400000000ffULL, 0x000000191616723eULL, 0x000fe200000000ffULL,
0x0004003a20007388ULL, 0x000fe20000000800ULL, 0x000000151010723eULL, 0x000fc600000000ffULL,
0x000400085b007388ULL, 0x000fe80000000800ULL, 0x0004001c53007388ULL, 0x000fe80000000800ULL,
0x0000000a57007388ULL, 0x000fe80000000800ULL, 0x000800182f007388ULL, 0x000fe80000000800ULL,
0x0008002a31007388ULL, 0x000fe80000000800ULL, 0x0008002935007388ULL, 0x000fe80000000800ULL,
0x0008001f37007388ULL, 0x000fe80000000800ULL, 0x0008001d20007388ULL, 0x000fe80000000800ULL,
0x0008000f5b007388ULL, 0x000fe80000000800ULL, 0x0008000e53007388ULL, 0x000fe80000000800ULL,
0x0000001314007388ULL, 0x000fe80000000800ULL, 0x000c002b2f007388ULL, 0x000fe80000000800ULL,
0x000c002731007388ULL, 0x000fe80000000800ULL, 0x000c001235007388ULL, 0x000fe80000000800ULL,
0x000c003937007388ULL, 0x000fe80000000800ULL, 0x000c002320007388ULL, 0x000fe80000000800ULL,
0x000c00165b007388ULL, 0x000fe80000000800ULL, 0x000c001053007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000007087984ULL, 0x000e680000000c00ULL,
0x0004000007187984ULL, 0x000ea80000000c00ULL, 0x0008000007247984ULL, 0x000ee80000000c00ULL,
0x000c000007207984ULL, 0x000f280000000c00ULL, 0x00100000070c7984ULL, 0x000ee80000000c00ULL,
0x00140000071c7984ULL, 0x000f280000000c00ULL, 0x0018000007287984ULL, 0x000f280000000c00ULL,
0x001c0000072c7984ULL, 0x000f220000000c00ULL, 0x200000ff0b0b7230ULL, 0x002fc40000000000ULL,
0x200000ff0a0a7230ULL, 0x000fe40000000000ULL, 0x200000ff09097230ULL, 0x000fe40000000000ULL,
0x200000ff08087230ULL, 0x000fe40000000000ULL, 0x200000ff1b1b7230ULL, 0x004fe40000000000ULL,
0x200000ff1a1a7230ULL, 0x000fe40000000000ULL, 0x200000ff19197230ULL, 0x000fc40000000000ULL,
0x200000ff18187230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x008fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fe40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x200000ff23237230ULL, 0x010fc40000000000ULL,
0x200000ff22227230ULL, 0x000fe40000000000ULL, 0x200000ff21217230ULL, 0x000fe40000000000ULL,
0x200000ff20207230ULL, 0x000fe40000000000ULL, 0x0000000f0b0b7230ULL, 0x000fe40000000000ULL,
0x0000000e0a0a7230ULL, 0x000fe40000000000ULL, 0x0000000d09097230ULL, 0x000fc40000000000ULL,
0x0000000c08087230ULL, 0x000fe40000000000ULL, 0x0000001f1b1b7230ULL, 0x000fe40000000000ULL,
0x0000001e1a1a7230ULL, 0x000fe20000000000ULL, 0x0000000807007388ULL, 0x000fe20000000c00ULL,
0x0000001d19197230ULL, 0x000fe40000000000ULL, 0x0000001c18187230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x000fc40000000000ULL, 0x0000002a26267230ULL, 0x000fe20000000000ULL,
0x0004001807007388ULL, 0x000fe20000000c00ULL, 0x0000002925257230ULL, 0x000fe40000000000ULL,
0x0000002824247230ULL, 0x000fe40000000000ULL, 0x0000002f23237230ULL, 0x000fe40000000000ULL,
0x0000002e22227230ULL, 0x000fe20000000000ULL, 0x0008002407007388ULL, 0x000fe20000000c00ULL,
0x0000002d21217230ULL, 0x000fc40000000000ULL, 0x0000002c20207230ULL, 0x000fca0000000000ULL,
0x000c002007007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff027819ULL, 0x000fc80000011605ULL, 0x0000007d0200720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ee20000002700ULL,
0x0000000102037824ULL, 0x000fe200078e0205ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x000000207f027824ULL, 0x000fe200078e0202ULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x00000020050f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x0000000703047812ULL, 0x000fe400078ec0ffULL, 0x0000580000067ab9ULL, 0x000fe20000000800ULL,
0x00000007050d7812ULL, 0x000fc400078ec0ffULL, 0x0ffffff804037812ULL, 0x000fe400078ef805ULL,
0x0000000502077c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff027a19ULL, 0x000fe20000011602ULL,
0x0000001003037824ULL, 0x000fe400078e0200ULL, 0x000000017e077824ULL, 0x000fc600078e0207ULL,
0x0000000003087984ULL, 0x0045220000000c00ULL, 0x0000008302077224ULL, 0x000fe200078e0207ULL,
0x00000006040472a4ULL, 0x008fcc000f8e023fULL, 0x0000000483047c24ULL, 0x000fca000f8e02ffULL,
0x0000000704077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0007027a11ULL, 0x000fc800078040ffULL, 0x00005d0007037a11ULL, 0x004fe200000f440cULL,
0x0000000806077824ULL, 0x000fe200078e020dULL, 0x00000003ff0c7819ULL, 0x000fc6000001160fULL,
0x0000001007027825ULL, 0x000fe200078e0002ULL, 0x0000007d0c00720cULL, 0x000fc80003f06070ULL,
0x0000000802007986ULL, 0x0105f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010f027824ULL, 0x104fe200078e020cULL, 0x0000004005117810ULL, 0x000fe20007ffe0ffULL,
0x000000207f0c7824ULL, 0x000fe200078e020cULL, 0x000000070f0d7812ULL, 0x000fc400078ec0ffULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x00000008060d7824ULL, 0x000fe200078e020dULL,
0x0ffffff802037812ULL, 0x000fc800078ef80fULL, 0x0000000003077211ULL, 0x000fe400078e20ffULL,
0x000000050c037c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0c7a19ULL, 0x000fe2000001160cULL,
0x0000000007087984ULL, 0x000ea40000000c00ULL, 0x000000017e037824ULL, 0x000fc800078e0203ULL,
0x000000830c037224ULL, 0x000fca00078e0203ULL, 0x0000000304037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fe400000f440cULL, 0x00000003ff0c7819ULL, 0x000fc60000011611ULL,
0x000000100d027825ULL, 0x000fe200078e0002ULL, 0x0000007d0c00720cULL, 0x000fc80003f06070ULL,
0x0000000802007986ULL, 0x0045f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000111027824ULL, 0x104fe200078e020cULL, 0x00000060050f7810ULL, 0x000fe20007ffe0ffULL,
0x000000207f0c7824ULL, 0x000fe200078e020cULL, 0x00000007110d7812ULL, 0x000fc400078ec0ffULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x00000008060d7824ULL, 0x000fe200078e020dULL,
0x0ffffff802037812ULL, 0x000fca00078ef811ULL, 0x0000001003077824ULL, 0x000fe200078e0200ULL,
0x000000050c037c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0c7a19ULL, 0x000fe4000001160cULL,
0x0000000007087984ULL, 0x000ea20000000c00ULL, 0x000000017e037824ULL, 0x000fc800078e0203ULL,
0x000000830c037224ULL, 0x000fca00078e0203ULL, 0x0000000304037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fe400000f440cULL, 0x00000003ff0c7819ULL, 0x000fc6000001160fULL,
0x000000100d027825ULL, 0x000fe200078e0002ULL, 0x0000007d0c00720cULL, 0x000fc80003f06070ULL,
0x0000000802007986ULL, 0x0045f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010f027824ULL, 0x104fe200078e020cULL, 0x0000008005117810ULL, 0x000fe20007ffe0ffULL,
0x000000207f0c7824ULL, 0x000fe200078e020cULL, 0x000000070f0d7812ULL, 0x000fc400078ec0ffULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x00000008060d7824ULL, 0x000fe200078e020dULL,
0x0ffffff802037812ULL, 0x000fca00078ef80fULL, 0x0000001003077824ULL, 0x000fe200078e0200ULL,
0x000000050c037c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0c7a19ULL, 0x000fe4000001160cULL,
0x0000000007087984ULL, 0x000ea20000000c00ULL, 0x000000017e037824ULL, 0x000fc800078e0203ULL,
0x000000830c037224ULL, 0x000fca00078e0203ULL, 0x0000000304037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fe400000f440cULL, 0x00000003ff0c7819ULL, 0x000fc60000011611ULL,
0x000000100d027825ULL, 0x000fe200078e0002ULL, 0x0000007d0c00720cULL, 0x000fc80003f06070ULL,
0x0000000802007986ULL, 0x0045f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000111027824ULL, 0x104fe200078e020cULL, 0x000000a0050f7810ULL, 0x000fe20007ffe0ffULL,
0x000000207f0c7824ULL, 0x000fe200078e020cULL, 0x00000007110d7812ULL, 0x000fc400078ec0ffULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x00000008060d7824ULL, 0x000fe200078e020dULL,
0x0ffffff802037812ULL, 0x000fc800078ef811ULL, 0x0000000003077211ULL, 0x000fe400078e20ffULL,
0x000000050c037c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0c7a19ULL, 0x000fe2000001160cULL,
0x0000000007087984ULL, 0x000ea40000000c00ULL, 0x000000017e037824ULL, 0x000fc800078e0203ULL,
0x000000830c037224ULL, 0x000fca00078e0203ULL, 0x0000000304037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fe400000f440cULL, 0x00000003ff0c7819ULL, 0x000fc6000001160fULL,
0x000000100d027825ULL, 0x000fe200078e0002ULL, 0x0000007d0c00720cULL, 0x000fc80003f06070ULL,
0x0000000802007986ULL, 0x0045f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010f027824ULL, 0x104fe200078e020cULL, 0x000000c005117810ULL, 0x000fe20007ffe0ffULL,
0x000000207f0c7824ULL, 0x000fe200078e020cULL, 0x000000070f0d7812ULL, 0x000fc400078ec0ffULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x00000008060d7824ULL, 0x000fe200078e020dULL,
0x0ffffff802037812ULL, 0x000fca00078ef80fULL, 0x0000001003077824ULL, 0x000fe200078e0200ULL,
0x000000050c037c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0c7a19ULL, 0x000fe4000001160cULL,
0x0000000007087984ULL, 0x000ea20000000c00ULL, 0x000000017e037824ULL, 0x000fc800078e0203ULL,
0x000000830c037224ULL, 0x000fca00078e0203ULL, 0x0000000304037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fe400000f440cULL, 0x00000003ff0c7819ULL, 0x000fc60000011611ULL,
0x000000100d027825ULL, 0x000fe200078e0002ULL, 0x0000007d0c00720cULL, 0x000fc80003f06070ULL,
0x0000000802007986ULL, 0x0045f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000111027824ULL, 0x104fe200078e020cULL, 0x000000e0050d7810ULL, 0x000fe20007ffe0ffULL,
0x000000207f0c7824ULL, 0x000fe200078e020cULL, 0x0000000711057812ULL, 0x000fc400078ec0ffULL,
0x0000000702027812ULL, 0x000fc600078ec0ffULL, 0x0000000806057824ULL, 0x000fe200078e0205ULL,
0x0ffffff802037812ULL, 0x000fca00078ef811ULL, 0x0000001003077824ULL, 0x000fe200078e0200ULL,
0x000000050c037c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0c7a19ULL, 0x000fe4000001160cULL,
0x0000000007087984ULL, 0x0004e20000000c00ULL, 0x000000017e037824ULL, 0x000fc800078e0203ULL,
0x000000830c037224ULL, 0x000fe200078e0203ULL, 0x00000003ff0c7819ULL, 0x000fc8000001160dULL,
0x0000000304037210ULL, 0x000fe20007f1e0ffULL, 0x000000010d077824ULL, 0x004fc800078e020cULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fe400078040ffULL,
0x0000000707077812ULL, 0x000fe400078ec0ffULL, 0x00005d0003037a11ULL, 0x000fe400000f440eULL,
0x0000007d0c00720cULL, 0x000fe40003f06070ULL, 0xfffffff807077812ULL, 0x000fe200078ef80dULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x0085ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000007077211ULL, 0x000fe200078e20ffULL,
0x000000207f0c7824ULL, 0x000fe200078e020cULL, 0x000000070d057812ULL, 0x000fc600078ec0ffULL,
0x0000000007087984ULL, 0x004ea20000000c00ULL, 0x000000050c037c12ULL, 0x000fe2000f8e30ffULL,
0x0000000806057824ULL, 0x000fe200078e0205ULL, 0x00005a00ff0c7a19ULL, 0x000fc6000001160cULL,
0x000000017e037824ULL, 0x000fc800078e0203ULL, 0x000000830c037224ULL, 0x000fca00078e0203ULL,
0x0000000304037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x000fc800078040ffULL, 0x00005d0003037a11ULL, 0x000fca00000f4400ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x004fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000496227824ULL, 0x000fe400078e029aULL,
0xffffffffff887424ULL, 0x000fc600078e00ffULL, 0x000000942200720cULL, 0x000fda0003f06070ULL,
0x00000002a0038824ULL, 0x000fc800078e00ffULL, 0x0000680003088a24ULL, 0x000fc800078e0222ULL,
0x0000640008088625ULL, 0x000fe200078e002dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000808888981ULL, 0x000ea2000c1e1900ULL, 0x0000000196047810ULL, 0x000fe20007ffe0ffULL,
0x00000040109d7824ULL, 0x000fe400078e00ffULL, 0x00000100ff057424ULL, 0x002fe200078e00ffULL,
0x000000230400720cULL, 0x000fe20003f06070ULL, 0x01660000ff027f8cULL, 0x000e62000c80043fULL,
0x000000409a9e7824ULL, 0x000fe400078e00ffULL, 0x0000004006217824ULL, 0x000fc400078e00ffULL,
0x0000009d88047224ULL, 0x004fc800078e02ffULL, 0x0000620004047625ULL, 0x000fc600078e0005ULL,
0x0000061000008947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x002fe40000011600ULL,
0x0000000000177211ULL, 0x000fe400078fe8ffULL, 0x00000008271b7810ULL, 0x000fe20007ffe0ffULL,
0x0000004006167824ULL, 0x000fe200078e0227ULL, 0x0000000317177812ULL, 0x000fe200078ec0ffULL,
0x0000010096067824ULL, 0x000fe200078e029eULL, 0x000020009a197811ULL, 0x000fe200078e68ffULL,
0x0000010016087825ULL, 0x040fe200078e00ffULL, 0x00000008160a7810ULL, 0x000fc40007ffe0ffULL,
0x00000010160c7810ULL, 0x000fe40007ffe0ffULL, 0x0000003008157812ULL, 0x100fe200078ef807ULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x00000006950f7217ULL, 0x000fe40007800000ULL,
0x00000015040e7210ULL, 0x000fe20007f1e0ffULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0x000000300a137812ULL, 0x100fe400078ef807ULL, 0x0000001816087810ULL, 0x000fe20007ffe0ffULL,
0x000000010f067824ULL, 0x000fe200078e0a06ULL, 0x000000300c117812ULL, 0x000fe200078ef807ULL,
0x00000001050f7824ULL, 0x000fe200000e0609ULL, 0x0000001304107210ULL, 0x000fe20007f3e0ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x00000020160a7810ULL, 0x000fc40007ffe0ffULL,
0x00000011040c7210ULL, 0x000fe20007f5e0ffULL, 0x0000000105117824ULL, 0x000fe200008e060bULL,
0x0000003008137812ULL, 0x000fe200078ef807ULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x000000021b087819ULL, 0x000fe400000006ffULL, 0x000000062700720cULL, 0x000fe20003f06070ULL,
0x00000001050d7824ULL, 0x000fe200010e060dULL, 0x000000300a157812ULL, 0x000fe400078ef807ULL,
0xfffffffc08087812ULL, 0x000fc400078ee217ULL, 0x0000001504147210ULL, 0x040fe40007f7e0ffULL,
0x0000001304127210ULL, 0x000fe40007f5e0ffULL, 0x0ffffffc17007812ULL, 0x000fe200078ef800ULL,
0x0000000105157824ULL, 0x000fe200018e060bULL, 0x000000061b00720cULL, 0x000fe20003f26070ULL,
0x00000010080b7824ULL, 0x000fe200078e0219ULL, 0x0000002816087810ULL, 0x000fe20007ffe0ffULL,
0x0000000105137824ULL, 0x000fe200010e0609ULL, 0x00000010272b7810ULL, 0x040fe20007ffe0ffULL,
0x00000010001b7824ULL, 0x000fe200078e0219ULL, 0x00000018272d7810ULL, 0x040fe20007ffe0ffULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x00000020271d7810ULL, 0x000fc40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e1b7faeULL, 0x0003e2000c101c48ULL,
0x00000028271f7810ULL, 0x000fe20007ffe0ffULL, 0x000000042b007824ULL, 0x000fe200078e00ffULL,
0x0000003008297812ULL, 0x000fe200078ef807ULL, 0x00000000100b7faeULL, 0x0005e2000c901c48ULL,
0x0000003016087810ULL, 0x040fe20007ffe0ffULL, 0x000000041f187824ULL, 0x000fe200078e00ffULL,
0x0000003027257810ULL, 0x040fe40007ffe0ffULL, 0x0000003827277810ULL, 0x000fe40007ffe0ffULL,
0x00000038160a7810ULL, 0x000fe20007ffe0ffULL, 0x00000004251a7824ULL, 0x000fe200078e00ffULL,
0x00000029040e7210ULL, 0x002fe20007fde0ffULL, 0x00000004271c7824ULL, 0x000fe200078e00ffULL,
0x000000062b00720cULL, 0x080fe20003fa6070ULL, 0x000001000a0a7825ULL, 0x004fe200078e00ffULL,
0x000000062d00720cULL, 0x000fc40003f86070ULL, 0x000000061d00720cULL, 0x080fe20003f66070ULL,
0x00000001050f7824ULL, 0x000fe200030e0609ULL, 0x000000061f00720cULL, 0x080fe20003f46070ULL,
0x0000010008087825ULL, 0x000fe200078e00ffULL, 0x000000062500720cULL, 0x080fe40003f26070ULL,
0x000000062700720cULL, 0x000fe20003f06070ULL, 0x000000042d067824ULL, 0x000fe200078e00ffULL,
0x0000003008117812ULL, 0x000fe200078ef807ULL, 0x000000041d107824ULL, 0x000fe200078e00ffULL,
0xfffffffc00007812ULL, 0x000fc400078ee217ULL, 0x0000001104087210ULL, 0x000fe40007fde0ffULL,
0xfffffffc06067812ULL, 0x000fe400078ee217ULL, 0x000000300a1b7812ULL, 0x000fe200078ef807ULL,
0x0000000105097824ULL, 0x000fe200030e0609ULL, 0xfffffffc10107812ULL, 0x000fe200078ee217ULL,
0x0000001000077824ULL, 0x000fe200078e0219ULL, 0xfffffffc18167812ULL, 0x000fe200078ee217ULL,
0x0000001006117824ULL, 0x000fe200078e0219ULL, 0xfffffffc1a187812ULL, 0x000fc400078ee217ULL,
0x0000001b04047210ULL, 0x000fe20007fde0ffULL, 0x00000010161b7824ULL, 0x000fe200078e0219ULL,
0xfffffffc1c1a7812ULL, 0x000fe200078ee217ULL, 0x0000001010177824ULL, 0x100fe200078e0219ULL,
0x000000000c077faeULL, 0x0003e2000e901c48ULL, 0x00000010181d7824ULL, 0x000fe200078e0219ULL,
0x000000191a197211ULL, 0x000fe200078e20ffULL, 0x0000000105057824ULL, 0x000fe200030e060bULL,
0x0000000012117faeULL, 0x0003e8000e101c48ULL, 0x0000000014177faeULL, 0x0003e8000d901c48ULL,
0x000000000e1b7faeULL, 0x0003e8000d101c48ULL, 0x00000000081d7faeULL, 0x0003e8000c901c48ULL,
0x0000000004197faeULL, 0x0003e2000c101c48ULL, 0x0000054000007947ULL, 0x000fea0003800000ULL,
0x0000002100087211ULL, 0x042fe400078ff0ffULL, 0x0000000000067211ULL, 0x000fc400078fe8ffULL,
0x00000008000a7811ULL, 0x000fe200078ff0ffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x00000010000c7811ULL, 0x040fe400078ff0ffULL, 0x0000001800127811ULL, 0x040fe400078ff0ffULL,
0x0000002000107811ULL, 0x000fe200078ff0ffULL, 0x000000040c0e7824ULL, 0x000fe200078e00ffULL,
0x0000002800187811ULL, 0x040fe200078ff0ffULL, 0x00000001210c7824ULL, 0x000fe200078e020cULL,
0x00000030001a7811ULL, 0x000fe200078ff0ffULL, 0x0000000412147824ULL, 0x000fe200078e00ffULL,
0x00000038001c7811ULL, 0x000fe200078ff0ffULL, 0x00000004101e7824ULL, 0x000fe200078e00ffULL,
0x00000003060b7812ULL, 0x000fe200078ec0ffULL, 0x000000040a067824ULL, 0x000fe200078e00ffULL,
0x0000003008157812ULL, 0x000fe200078ef807ULL, 0x0000000418207824ULL, 0x000fe200078e00ffULL,
0x0ffffffc0b167812ULL, 0x000fe200078ef800ULL, 0x000000041a247824ULL, 0x000fe200078e00ffULL,
0xfffffffc06007812ULL, 0x100fe200078ee20bULL, 0x000000041c267824ULL, 0x000fe200078e00ffULL,
0xfffffffc0e067812ULL, 0x100fe200078ee20bULL, 0x00000001210a7824ULL, 0x000fe200078e020aULL,
0xfffffffc140e7812ULL, 0x100fe200078ee20bULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffffc1e0f7812ULL, 0x000fc400078ee20bULL, 0xfffffffc20117812ULL, 0x100fe200078ee20bULL,
0x0000000121087824ULL, 0x000fe200078e0212ULL, 0xfffffffc24137812ULL, 0x100fe400078ee20bULL,
0xfffffffc26147812ULL, 0x000fe200078ee20bULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0x000020009a297811ULL, 0x000fe400078e68ffULL, 0x0000001504127210ULL, 0x000fe40007f1e0ffULL,
0x000000300c177812ULL, 0x000fe200078ef807ULL, 0x0000001016317824ULL, 0x000fe200078e0229ULL,
0x0000002913277211ULL, 0x000fe200078e20ffULL, 0x0000000105137824ULL, 0x000fe200000e0609ULL,
0x000000300a157812ULL, 0x000fe200078ef807ULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000001704167210ULL, 0x000fc40007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012317faeULL, 0x0003e2000b901c48ULL, 0x0000001000197824ULL, 0x100fe400078e0229ULL,
0x00000010061b7824ULL, 0x100fe400078e0229ULL, 0x000000100e1d7824ULL, 0x100fe400078e0229ULL,
0x000000100f1f7824ULL, 0x100fe400078e0229ULL, 0x0000001011257824ULL, 0x100fe400078e0229ULL,
0x0000001014297824ULL, 0x000fe200078e0229ULL, 0x0000001504147210ULL, 0x000fe20007f3e0ffULL,
0x0000000105177824ULL, 0x000fe200010e060dULL, 0x00000030080d7812ULL, 0x000fe200078ef807ULL,
0x00000001210a7824ULL, 0x000fc400078e0210ULL, 0x00000001210c7824ULL, 0x040fe200078e0218ULL,
0x0000000d04087210ULL, 0x000fe20007f1e0ffULL, 0x00000001210e7824ULL, 0x000fe400078e021aULL,
0x0000000105157824ULL, 0x000fe400008e060bULL, 0x0000000121107824ULL, 0x000fe400078e021cULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000000014197faeULL, 0x0003e6000b901c48ULL,
0x000001000c0c7825ULL, 0x000fe200078e00ffULL, 0x000000300a2f7812ULL, 0x100fe200078ef807ULL,
0x00000000161b7faeULL, 0x0003e4000b901c48ULL, 0x000001000e0e7825ULL, 0x000fe200078e00ffULL,
0x000000300c2d7812ULL, 0x000fc600078ef807ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x000000300e2b7812ULL, 0x000fe400078ef807ULL, 0x0000002d040a7210ULL, 0x000fe20007f3e0ffULL,
0x0000000105097824ULL, 0x040fe200000e0609ULL, 0x0000003010077812ULL, 0x000fe400078ef807ULL,
0x0000002f04067210ULL, 0x040fe40007f1e0ffULL, 0x0000002b040c7210ULL, 0x040fe20007f5e0ffULL,
0x00000000081d7faeULL, 0x0003e2000b901c48ULL, 0x0000000704047210ULL, 0x000fe20007f7e0ffULL,
0x0000000105077824ULL, 0x000fc400000e060bULL, 0x00000001050b7824ULL, 0x040fe400008e060dULL,
0x00000001050d7824ULL, 0x040fe200010e060fULL, 0x00000000061f7faeULL, 0x0003e2000b901c48ULL,
0x0000000105057824ULL, 0x000fc600018e0611ULL, 0x000000000a257faeULL, 0x0003e8000b901c48ULL,
0x000000000c277faeULL, 0x0003e8000b901c48ULL, 0x0000000004297faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000047805ULL, 0x002fc40000015200ULL,
0x01660400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fc40007804803ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc80000011407ULL,
0x0000000900007211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000200007819ULL, 0x000fc80000001207ULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01660400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000239600720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000207919ULL, 0x000e620000000000ULL, 0x00005800ff1e7624ULL, 0x000fe200078e00ffULL,
0x80005800951d7a10ULL, 0x000fe20007ffe0ffULL, 0x00006800a0a07a24ULL, 0x000fe200078e02ffULL,
0x000166889a9b7811ULL, 0x000fe400078e18ffULL, 0x0000001f1e007810ULL, 0x040fe40007ffe0ffULL,
0xffffffff1e1f7810ULL, 0x000fe40007ffe0ffULL, 0x00000004ff007819ULL, 0x000fc40000011600ULL,
0x000000059a9c7819ULL, 0x000fe400000006ffULL, 0x000000091e1e7810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff1d7819ULL, 0x000fe4000001161dULL, 0x0ffffffe001c7812ULL, 0x000fc400078ec0ffULL,
0x0000000196007810ULL, 0x008fe20007ffe0ffULL, 0x00000100ff9f7424ULL, 0x000fe200078e00ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000889d987224ULL, 0x000fe200078e02ffULL,
0x000000230000720cULL, 0x000fe20003f06070ULL, 0x00000100961b7824ULL, 0x000fc400078e029eULL,
0x0000620098987625ULL, 0x000fd400078e009fULL, 0x0000064000008947ULL, 0x004fea0003800000ULL,
0x00000002ff107819ULL, 0x002fe20000011620ULL, 0x00000010201a7824ULL, 0x000fe200078e00ffULL,
0x0000001b95007217ULL, 0x000fe40007800000ULL, 0x0000000810147810ULL, 0x000fe20007ffe0ffULL,
0x0000000121027824ULL, 0x000fe200078e0210ULL, 0x000000301a1a7812ULL, 0x000fe200078ec0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a1bULL, 0x0000001010157810ULL, 0x000fe20007ffe0ffULL,
0x0000010002027825ULL, 0x000fe200078e00ffULL, 0x000000401a117812ULL, 0x000fc400078efcffULL,
0x0000001810167810ULL, 0x000fe20007ffe0ffULL, 0x0000000121047824ULL, 0x040fe200078e0214ULL,
0x00000011020d7212ULL, 0x000fe200078efcffULL, 0x0000000121067824ULL, 0x040fe200078e0215ULL,
0x0000002010187810ULL, 0x000fe20007ffe0ffULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x0000000d980c7210ULL, 0x000fe40007f3e0ffULL, 0x0000002810247810ULL, 0x000fe20007ffe0ffULL,
0x0000000121087824ULL, 0x000fe200078e0216ULL, 0x0000001104137212ULL, 0x000fe200078efcffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000002020047211ULL, 0x000fc400078fe8ffULL,
0x000030009a027811ULL, 0x000fe200078e68ffULL, 0x00000001210a7824ULL, 0x000fe200078e0218ULL,
0x00000011060f7212ULL, 0x000fe200078efcffULL, 0x0000010008087825ULL, 0x000fe200078e00ffULL,
0x0000000304127812ULL, 0x000fe400078ec0ffULL, 0x0000000f98067210ULL, 0x040fe20007f5e0ffULL,
0x00000001990d7824ULL, 0x000fe200008e0603ULL, 0x00000013980e7210ULL, 0x000fe20007f3e0ffULL,
0x000001000a0a7825ULL, 0x000fe200078e00ffULL, 0x0000001108137212ULL, 0x000fc400078efcffULL,
0x0000002421047210ULL, 0x000fe20007ffe0ffULL, 0x00000001990f7824ULL, 0x000fe200008e0605ULL,
0x000000110a037212ULL, 0x000fe200078efcffULL, 0x0000000414057824ULL, 0x000fe200078e00ffULL,
0x0000001398087210ULL, 0x040fe20007f3e0ffULL, 0x0000000415177824ULL, 0x000fe200078e00ffULL,
0x00000003980a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000199077824ULL, 0x040fe200010e0607ULL,
0x0ffffffc20037812ULL, 0x000fe200078ec0ffULL, 0x0000000199097824ULL, 0x040fe200008e0609ULL,
0x000000001000720cULL, 0x000fe20003f26070ULL, 0x00000001990b7824ULL, 0x000fe200018e060bULL,
0x0000000312137212ULL, 0x000fc400078efcffULL, 0x000000001500720cULL, 0x080fe40003f66070ULL,
0xfffffffc05157812ULL, 0x100fe200078ee212ULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0x000000001400720cULL, 0x000fe40003f46070ULL, 0xfffffffc17177812ULL, 0x000fe200078ee212ULL,
0x0000001013137824ULL, 0x100fe200078e0202ULL, 0x0000001104197212ULL, 0x000fe200078efcffULL,
0x0000001015157824ULL, 0x100fe200078e0202ULL, 0x0000003010147810ULL, 0x040fe20007ffe0ffULL,
0x0000001017177824ULL, 0x000fe200078e0202ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c137faeULL, 0x0003e2000c901c48ULL, 0x0000003810107810ULL, 0x000fc40007ffe0ffULL,
0x0000000121047824ULL, 0x000fe200078e0214ULL, 0x000000001600720cULL, 0x080fe20003fa6070ULL,
0x000000000e157faeULL, 0x0005e2000d101c48ULL, 0x000000001800720cULL, 0x080fe20003f86070ULL,
0x0000000414257824ULL, 0x040fe200078e00ffULL, 0x000000001400720cULL, 0x080fe20003f46070ULL,
0x0000000006177faeULL, 0x0007e2000d901c48ULL, 0x000000002400720cULL, 0x080fe20003f66070ULL,
0x0000000410277824ULL, 0x000fe200078e00ffULL, 0x00000019980c7210ULL, 0x002fe20007fde0ffULL,
0x0000000424197824ULL, 0x000fe200078e00ffULL, 0x000000001000720cULL, 0x000fc40003f26070ULL,
0xfffffffc25257812ULL, 0x100fe200078ee212ULL, 0x00000001990d7824ULL, 0x000fe200030e0605ULL,
0xfffffffc19197812ULL, 0x100fe200078ee212ULL, 0x0000010004047825ULL, 0x000fe200078e00ffULL,
0xfffffffc27277812ULL, 0x000fc600078ee212ULL, 0x0000000121067824ULL, 0x008fe200078e0210ULL,
0x00000011040f7212ULL, 0x004fe200078efcffULL, 0x0000000416157824ULL, 0x000fe400078e00ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000000f98047210ULL, 0x000fe40007fde0ffULL,
0xfffffffc15157812ULL, 0x000fe200078ee212ULL, 0x0000000418177824ULL, 0x000fe200078e00ffULL,
0x0000001106137212ULL, 0x000fe200078efcffULL, 0x0000000199057824ULL, 0x000fc400030e0605ULL,
0x00000010150f7824ULL, 0x000fe200078e0202ULL, 0xfffffffc17177812ULL, 0x000fe200078ee212ULL,
0x0000001025157824ULL, 0x100fe200078e0202ULL, 0x0000001398067210ULL, 0x000fe20007fde0ffULL,
0x0000001019137824ULL, 0x100fe200078e0202ULL, 0x00000000080f7faeULL, 0x0003e2000e901c48ULL,
0x0000001017117824ULL, 0x100fe400078e0202ULL, 0x0000001027177824ULL, 0x000fe400078e0202ULL,
0x0000000199077824ULL, 0x000fe200030e0607ULL, 0x000000000a117faeULL, 0x0003e8000e101c48ULL,
0x000000000c137faeULL, 0x0003e8000d901c48ULL, 0x0000000004157faeULL, 0x0003e8000d101c48ULL,
0x0000000006177faeULL, 0x0003e2000c901c48ULL, 0x0000058000007947ULL, 0x000fea0003800000ULL,
0x0000001020087811ULL, 0x042fe400078ff0ffULL, 0x00000004201a7819ULL, 0x000fc400000006ffULL,
0x0000002020007211ULL, 0x000fe200078fe8ffULL, 0x0000000121097824ULL, 0x000fe200078e0208ULL,
0x000000301a1a7812ULL, 0x000fe200078ec0ffULL, 0x00000004080b7824ULL, 0x000fe200078e00ffULL,
0x0000000820027811ULL, 0x040fe200078ff0ffULL, 0x0000010009087825ULL, 0x000fe200078e00ffULL,
0x00000018200a7811ULL, 0x040fe400078ff0ffULL, 0x0000002020107811ULL, 0x000fe200078ff0ffULL,
0x0000000402077824ULL, 0x000fe200078e00ffULL, 0x0000002120047211ULL, 0x000fe200078ff0ffULL,
0x00000001210c7824ULL, 0x000fe200078e020aULL, 0x0000000300007812ULL, 0x000fe200078ec0ffULL,
0x000000040a0d7824ULL, 0x000fe200078e00ffULL, 0x000000401a2d7812ULL, 0x000fe200078efcffULL,
0x00000004100f7824ULL, 0x000fe200078e00ffULL, 0x000030009a2b7811ULL, 0x000fe200078e68ffULL,
0x0000010004047825ULL, 0x000fe200078e00ffULL, 0xfffffffc0b0a7812ULL, 0x000fc400078ee200ULL,
0x0000002d080b7212ULL, 0x080fe200078efcffULL, 0x0000000121067824ULL, 0x000fe200078e0202ULL,
0xfffffffc07027812ULL, 0x100fe200078ee200ULL, 0x000000100a177824ULL, 0x000fe200078e022bULL,
0xfffffffc0f127812ULL, 0x000fe200078ee200ULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000002d040f7212ULL, 0x000fe400078efcffULL, 0x0000000b98087210ULL, 0x000fe20007f7e0ffULL,
0x000001000c0a7825ULL, 0x000fe200078e00ffULL, 0x0000002820147811ULL, 0x000fc400078ff0ffULL,
0xfffffffc0d0e7812ULL, 0x000fe200078ee200ULL, 0x00000001210c7824ULL, 0x040fe200078e0210ULL,
0x0000003020187811ULL, 0x000fe200078ff0ffULL, 0x0000000414117824ULL, 0x000fe200078e00ffULL,
0x0000003820267811ULL, 0x000fe200078ff0ffULL, 0x000000100e197824ULL, 0x100fe200078e022bULL,
0x0000000f98047210ULL, 0x000fe20007f3e0ffULL, 0x0000000418137824ULL, 0x000fe200078e00ffULL,
0x0000002d060d7212ULL, 0x080fe200078efcffULL, 0x00000001210e7824ULL, 0x040fe200078e0214ULL,
0x0000002d0a0f7212ULL, 0x000fe200078efcffULL, 0x0000001012257824ULL, 0x000fe200078e022bULL,
0x0000000d98067210ULL, 0x000fe20007f5e0ffULL, 0x0000000121107824ULL, 0x000fe200078e0218ULL,
0x0ffffffc20037812ULL, 0x000fe200078ec0ffULL, 0x0000000426157824ULL, 0x000fe200078e00ffULL,
0xfffffffc11167812ULL, 0x000fe200078ee200ULL, 0x0000000105057824ULL, 0x000fe200008e0699ULL,
0x0000000f980a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000121127824ULL, 0x000fe200078e0226ULL,
0xfffffffc13247812ULL, 0x100fe200078ee200ULL, 0x000001000c0c7825ULL, 0x000fe200078e00ffULL,
0xfffffffc15287812ULL, 0x000fc400078ee200ULL, 0x0000000300007212ULL, 0x000fe200078efcffULL,
0x000001000e0e7825ULL, 0x000fe200078e00ffULL, 0x0000002d0c337212ULL, 0x000fc600078efcffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x0000002d0e317212ULL, 0x000fc600078efcffULL,
0x0000010012127825ULL, 0x000fe200078e00ffULL, 0x0000002d102f7212ULL, 0x000fc600078efcffULL,
0x000000010b0b7824ULL, 0x100fe200008e0699ULL, 0x0000002d122d7212ULL, 0x000fe200078efcffULL,
0x0000000107077824ULL, 0x000fe200010e0699ULL, 0x00000033980c7210ULL, 0x000fe20007f3e0ffULL,
0x0000001000357824ULL, 0x000fe200078e022bULL, 0x00000031980e7210ULL, 0x040fe20007f5e0ffULL,
0x0000000109097824ULL, 0x000fe200018e0699ULL, 0x0000002f98107210ULL, 0x000fe20007f7e0ffULL,
0x0000001002157824ULL, 0x000fe200078e022bULL, 0x0000002d98127210ULL, 0x000fe20007f9e0ffULL,
0x000000010d0d7824ULL, 0x000fe200008e0699ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004357faeULL, 0x0003e2000b901c48ULL, 0x0000001016277824ULL, 0x000fc400078e022bULL,
0x000000010f0f7824ULL, 0x000fe200010e0699ULL, 0x0000000006157faeULL, 0x0003e2000b901c48ULL,
0x0000001024297824ULL, 0x000fe200078e022bULL, 0x0000002b282b7211ULL, 0x000fe200078e20ffULL,
0x0000000111117824ULL, 0x100fe200018e0699ULL, 0x0000000008177faeULL, 0x0003e2000b901c48ULL,
0x0000000113137824ULL, 0x000fc600020e0699ULL, 0x000000000a197faeULL, 0x0003e8000b901c48ULL,
0x000000000c257faeULL, 0x0003e8000b901c48ULL, 0x000000000e277faeULL, 0x0003e8000b901c48ULL,
0x0000000010297faeULL, 0x0003e8000b901c48ULL, 0x00000000122b7faeULL, 0x0003e4000b901c48ULL,
0x0000000820197812ULL, 0x002fe200078ec0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000004ff157819ULL, 0x100fe20000011620ULL, 0x000020009a717824ULL, 0x000fe200078e00ffULL,
0x0000000719197812ULL, 0x000fc400078ef820ULL, 0x0000000720057812ULL, 0x000fe200078ec0ffULL,
0x0000000815027824ULL, 0x040fe200078e00ffULL, 0x00000003ff737819ULL, 0x000fe20000011620ULL,
0x0000000115187824ULL, 0x000fe200078e0219ULL, 0x0000001019167812ULL, 0x040fe200078efcffULL,
0x0000001019077824ULL, 0x040fe200078e00ffULL, 0xfffffff802057812ULL, 0x000fe200078ee205ULL,
0x0000001019097824ULL, 0x000fe200078e00ffULL, 0x0000000218007810ULL, 0x000fe20007ffe0ffULL,
0x0000000115157824ULL, 0x000fe200078e0216ULL, 0x0000000173047812ULL, 0x000fe200078ec0ffULL,
0x0000001016067824ULL, 0x040fe200078e00ffULL, 0xfffffff0070c7812ULL, 0x000fe200078ee200ULL,
0x0000000405277824ULL, 0x040fe200078e00ffULL, 0x0000000405027211ULL, 0x040fe200078ff8ffULL,
0x0000001016257824ULL, 0x000fe200078e00ffULL, 0x00000002050b7819ULL, 0x040fe200000006ffULL,
0x000000100c0c7824ULL, 0x000fe200078e00ffULL, 0x0000001005077810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000020050d7810ULL, 0x000fe20007ffe0ffULL,
0x00000004077a7824ULL, 0x000fe200078e00ffULL, 0x00000030050f7810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0xfffffff009007812ULL, 0x000fe200078ee218ULL,
0x000000040d097824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b787812ULL, 0x000fe200078ee202ULL,
0x000000040f0b7824ULL, 0x000fe200078e00ffULL, 0x0000000202727810ULL, 0x000fe20007ffe0ffULL,
0x0000001000007824ULL, 0x000fe200078e00ffULL, 0xfffffff006027812ULL, 0x000fe200078ee215ULL,
0x000000000c34783bULL, 0x000fe20000000200ULL, 0x0000000407057211ULL, 0x0c0fe200078ff8ffULL,
0x0000000407077824ULL, 0x000fe200078e00ffULL, 0x000000040d067211ULL, 0x080fe200078ff8ffULL,
0x0000001002027824ULL, 0x000fe200078e00ffULL, 0x000000040f047211ULL, 0x000fe200078ff8ffULL,
0x000000000064783bULL, 0x0003e20000000200ULL, 0x0000200071177810ULL, 0x000fe20007ffe0ffULL,
0x000000040d0d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc7a7a7812ULL, 0x000fe200078ee205ULL,
0x000000040f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc09767812ULL, 0x000fe200078ee206ULL,
0x0000001078147824ULL, 0x100fe200078e0217ULL, 0xfffffffc0b747812ULL, 0x000fe200078ee204ULL,
0x000000107a137824ULL, 0x100fe200078e0217ULL, 0x000000000208783bULL, 0x0005e20000000200ULL,
0x0000001076127824ULL, 0x100fe200078e0217ULL, 0x00000002150e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001074117824ULL, 0x000fe200078e0217ULL, 0x000000001468783bULL, 0x000ee20000000200ULL,
0x0000000205707810ULL, 0x000fc40007ffe0ffULL, 0x0000000204007810ULL, 0x002fe20007ffe0ffULL,
0x000000001360783bULL, 0x000e620000000200ULL, 0x0000000206027810ULL, 0x004fe40007ffe0ffULL,
0xfffffff0250e7812ULL, 0x000fe200078ee20eULL, 0x00000000125c783bULL, 0x000ea20000000200ULL,
0xfffffffc07707812ULL, 0x000fe400078ee270ULL, 0xfffffffc0d027812ULL, 0x000fe200078ee202ULL,
0x00000000116c783bULL, 0x000f220000000200ULL, 0xfffffffc27727812ULL, 0x000fe200078ee272ULL,
0x000000100e547824ULL, 0x000fe200078e00ffULL, 0xfffffffc0f007812ULL, 0x000fe200078ee200ULL,
0x00000010700f7824ULL, 0x100fe200078e0217ULL, 0x0000001772107211ULL, 0x000fe200078e20ffULL,
0x00000010020e7824ULL, 0x000fc400078e0217ULL, 0x00000010000d7824ULL, 0x000fe200078e0217ULL,
0x000000005454783bULL, 0x000fe80000000200ULL, 0x00000000103c783bULL, 0x000ea80000000200ULL,
0x000000000f44783bULL, 0x000ea80000000200ULL, 0x000000000e4c783bULL, 0x000ea80000000200ULL,
0x000000000d04783bULL, 0x000ea20000000200ULL, 0x000000686458723cULL, 0x088f7000000018ffULL,
0x000000680838723cULL, 0x000f7000000018ffULL, 0x0000006a6424723cULL, 0x040f7000000018ffULL,
0x000000606428723cULL, 0x042f7000000018ffULL, 0x000000626490723cULL, 0x040f7000000018ffULL,
0x0000005c648c723cULL, 0x044f7000000018ffULL, 0x0000005e642c723cULL, 0x000f7000000018ffULL,
0x000000600840723cULL, 0x040f7000000018ffULL, 0x0000005c0848723cULL, 0x040f7000000018ffULL,
0x0000006a0868723cULL, 0x000f7000000018ffULL, 0x0000006c6430723cULL, 0x010f7000000018ffULL,
0x000000620860723cULL, 0x040f7000000018ffULL, 0x0000005e085c723cULL, 0x040f7000000018ffULL,
0x0000006c0850723cULL, 0x000f7000000018ffULL, 0x0000006e6464723cULL, 0x080f7000000018ffULL,
0x0000006e0808723cULL, 0x000f7000000018ffULL, 0x0000003c3458723cULL, 0x0a0b700000001858ULL,
0x0000003c5438723cULL, 0x000b700000001838ULL, 0x0000003e3424723cULL, 0x040b700000001824ULL,
0x000000443428723cULL, 0x040b700000001828ULL, 0x000000463490723cULL, 0x040b700000001890ULL,
0x0000004c348c723cULL, 0x040b70000000188cULL, 0x0000004e342c723cULL, 0x000b70000000182cULL,
0x000000445440723cULL, 0x040b700000001840ULL, 0x0000004c5448723cULL, 0x040b700000001848ULL,
0x0000003e543c723cULL, 0x000b700000001868ULL, 0x000000043430723cULL, 0x000b700000001830ULL,
0x000000465444723cULL, 0x040b700000001860ULL, 0x0000004e544c723cULL, 0x040b70000000185cULL,
0x000000045450723cULL, 0x000b700000001850ULL, 0x000000063434723cULL, 0x080b700000001864ULL,
0x000000065454723cULL, 0x000b620000001808ULL, 0x0000059000008947ULL, 0x000fce0003800000ULL,
0x00000002ff087819ULL, 0x020fe20000011620ULL, 0x000000ffff057224ULL, 0x000fe200078e00ffULL,
0x0000001b95067217ULL, 0x000fc40007800000ULL, 0x0000000808667810ULL, 0x040fe20007ffe0ffULL,
0x0000000121077824ULL, 0x040fe200078e0208ULL, 0x0000001008687810ULL, 0x000fe20007ffe0ffULL,
0x0000000106697824ULL, 0x000fe200078e0a1bULL, 0x000000801a047812ULL, 0x000fe200078efcffULL,
0x0000000121097824ULL, 0x040fe200078e0266ULL, 0x00000020086c7810ULL, 0x040fe20007ffe0ffULL,
0x00000001210b7824ULL, 0x000fe200078e0268ULL, 0x00000018086a7810ULL, 0x040fe20007ffe0ffULL,
0x0000010007067825ULL, 0x000fe200078e0004ULL, 0x00000028086e7810ULL, 0x000fc40007ffe0ffULL,
0x00000030087c7810ULL, 0x040fe20007ffe0ffULL, 0x00000001215f7824ULL, 0x000fe200078e026cULL,
0x000000690800720cULL, 0x040fe20003f26070ULL, 0x000001000b0a7825ULL, 0x100fe200078e0004ULL,
0x00000038087e7810ULL, 0x000fe40007ffe0ffULL, 0x00000020730c7210ULL, 0x000fe20007ffe0ffULL,
0x0000010009087825ULL, 0x100fe200078e0004ULL, 0x0000000a98647210ULL, 0x000fe40007f9e0ffULL,
0x000000030c0c7812ULL, 0x000fe200078ec0ffULL, 0x000001005f5e7825ULL, 0x000fe200078e0004ULL,
0x0000000898087210ULL, 0x000fc40007f7e0ffULL, 0x0000000698067210ULL, 0x000fe20007f5e0ffULL,
0x00000001215d7824ULL, 0x040fe200078e026aULL, 0x000000697c00720cULL, 0x080fe20003fa6070ULL,
0x0000000121617824ULL, 0x040fe200078e026eULL, 0x000000697e00720cULL, 0x000fe20003fc6070ULL,
0x0000000121637824ULL, 0x040fe400078e027cULL, 0x0000000121657824ULL, 0x000fe400078e027eULL,
0x0000000199097824ULL, 0x000fe200018e0609ULL, 0x0000005e985e7210ULL, 0x000fe20007f7e0ffULL,
0x000001005d5c7825ULL, 0x000fc800078e0004ULL, 0x0000010061607825ULL, 0x000fc800078e0004ULL,
0x0000010063627825ULL, 0x000fc800078e0004ULL, 0x0000010065047825ULL, 0x000fc800078e0004ULL,
0x0000000199657824ULL, 0x040fe200020e060bULL, 0x000000030c0b7212ULL, 0x000fe200078efcffULL,
0x0000000466037824ULL, 0x000fe200078e00ffULL, 0x0000006098607210ULL, 0x000fe20007f9e0ffULL,
0x00000001995f7824ULL, 0x000fe200018e065fULL, 0x000000696600720cULL, 0x080fe20003f66070ULL,
0x0000000468677824ULL, 0x040fe200078e00ffULL, 0xfffffffc03667812ULL, 0x100fe200078ee20cULL,
0x0000000199617824ULL, 0x040fe200020e0661ULL, 0x000000696800720cULL, 0x000fe20003f86070ULL,
0x0000000199077824ULL, 0x000fe200010e0607ULL, 0xfffffffc67687812ULL, 0x000fe200078ee20cULL,
0x000000100b0a7824ULL, 0x100fe200078e0217ULL, 0x0000005c985c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001066037824ULL, 0x000fc400078e0217ULL, 0x0000001068677824ULL, 0x000fe200078e0217ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000060a7faeULL, 0x0003e2000c901c48ULL,
0x000000046a6b7824ULL, 0x040fe200078e00ffULL, 0x000000696a00720cULL, 0x080fe20003f26070ULL,
0x00000001995d7824ULL, 0x000fe200010e065dULL, 0x0000000008037faeULL, 0x0005e2000d901c48ULL,
0x0000006298627210ULL, 0x000fe40007f5e0ffULL, 0xfffffffc6b667812ULL, 0x000fe200078ee20cULL,
0x0000000064677faeULL, 0x0007e2000e101c48ULL, 0x000000696c00720cULL, 0x080fe20003f66070ULL,
0x0000000199637824ULL, 0x000fe200010e0663ULL, 0x000000696e00720cULL, 0x000fe20003f86070ULL,
0x0000001066077824ULL, 0x002fe200078e0217ULL, 0x0000000498047210ULL, 0x000fe20007f5e0ffULL,
0x000000046c037824ULL, 0x004fc600078e00ffULL, 0x000000005c077faeULL, 0x0003e2000c901c48ULL,
0x000000046e097824ULL, 0x000fe400078e00ffULL, 0x000000047c657824ULL, 0x008fe200078e00ffULL,
0xfffffffc03067812ULL, 0x100fe200078ee20cULL, 0x000000047e677824ULL, 0x000fe200078e00ffULL,
0xfffffffc09087812ULL, 0x100fe200078ee20cULL, 0x0000000199057824ULL, 0x000fe400010e0605ULL,
0x0000001006037824ULL, 0x000fe200078e0217ULL, 0xfffffffc65067812ULL, 0x000fc400078ee20cULL,
0xfffffffc67647812ULL, 0x000fe400078ee20cULL, 0x0000001708097211ULL, 0x000fe200078e20ffULL,
0x0000001006077824ULL, 0x102fe200078e0217ULL, 0x000000005e037faeULL, 0x0003e2000d901c48ULL,
0x00000010645d7824ULL, 0x000fc600078e0217ULL, 0x0000000060097faeULL, 0x0003e8000e101c48ULL,
0x0000000062077faeULL, 0x0003e8000e901c48ULL, 0x00000000045d7faeULL, 0x0003e2000f101c48ULL,
0x000004d000007947ULL, 0x000fea0003800000ULL, 0x000000801a627812ULL, 0x020fe200078efcffULL,
0x000000ffff637224ULL, 0x000fe200078e00ffULL, 0x0000002120057211ULL, 0x040fe200078ff0ffULL,
0x00000001730c7824ULL, 0x000fe200078e0220ULL, 0x00000018206a7811ULL, 0x000fc400078ff0ffULL,
0x0000000820667811ULL, 0x040fe200078ff0ffULL, 0x0000010005047825ULL, 0x000fe200078e0062ULL,
0x0000001020687811ULL, 0x040fe400078ff0ffULL, 0x00000020206c7811ULL, 0x040fe200078ff0ffULL,
0x00000001210b7824ULL, 0x040fe200078e026aULL, 0x00000028206e7811ULL, 0x040fe200078ff0ffULL,
0x0000000121077824ULL, 0x000fe200078e0266ULL, 0x00000030207c7811ULL, 0x000fe200078ff0ffULL,
0x000001000b0a7825ULL, 0x000fe200078e0062ULL, 0x0000000498047210ULL, 0x000fc40007f3e0ffULL,
0x00000038207e7811ULL, 0x000fe200078ff0ffULL, 0x0000000121097824ULL, 0x040fe200078e0268ULL,
0x000000030c0c7812ULL, 0x000fe200078ec0ffULL, 0x00000001215d7824ULL, 0x040fe400078e026cULL,
0x00000001215f7824ULL, 0x040fe400078e026eULL, 0x0000000121617824ULL, 0x000fe400078e027cULL,
0x0000000199057824ULL, 0x000fe200008e0605ULL, 0x0000000a98647210ULL, 0x000fe20007f3e0ffULL,
0x0000000121657824ULL, 0x000fc400078e027eULL, 0x0000010007067825ULL, 0x000fc800078e0062ULL,
0x0000010009087825ULL, 0x000fe200078e0062ULL, 0x0000000698067210ULL, 0x000fc60007f5e0ffULL,
0x000001005d5c7825ULL, 0x000fe200078e0062ULL, 0x0000000898087210ULL, 0x000fc60007f7e0ffULL,
0x000001005f5e7825ULL, 0x000fc800078e0062ULL, 0x0000010061607825ULL, 0x000fc800078e0062ULL,
0x0000000466677824ULL, 0x000fe400078e00ffULL, 0x0000010065627825ULL, 0x000fc600078e0062ULL,
0xfffffffc67667812ULL, 0x100fe200078ee20cULL, 0x0000000199657824ULL, 0x000fe200008e060bULL,
0x000000030c0b7212ULL, 0x000fe200078efcffULL, 0x0000000468037824ULL, 0x000fe200078e00ffULL,
0x0000005e985e7210ULL, 0x000fe20007f3e0ffULL, 0x000000046a677824ULL, 0x000fe400078e00ffULL,
0x000000046c6b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc03687812ULL, 0x100fe200078ee20cULL,
0x0000001066037824ULL, 0x100fe200078e0217ULL, 0xfffffffc67667812ULL, 0x000fe200078ee20cULL,
0x000000100b0a7824ULL, 0x000fc400078e0217ULL, 0x0000000199077824ULL, 0x000fe200010e0607ULL,
0x0000005c985c7210ULL, 0x000fe20007f5e0ffULL, 0x0000001066697824ULL, 0x000fe200078e0217ULL,
0xfffffffc6b667812ULL, 0x000fe200078ee20cULL, 0x000000046e6d7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040a7faeULL, 0x0003e2000b901c48ULL,
0x000000047c6b7824ULL, 0x000fe400078e00ffULL, 0x000000047e6f7824ULL, 0x000fe200078e00ffULL,
0x0000000006037faeULL, 0x0005e2000b901c48ULL, 0x0000000199097824ULL, 0x000fc400018e0609ULL,
0x00000001995d7824ULL, 0x040fe200010e065dULL, 0x0000006098607210ULL, 0x040fe20007f5e0ffULL,
0x00000001995f7824ULL, 0x000fe200008e065fULL, 0x0000006298627210ULL, 0x000fe20007f3e0ffULL,
0x0000001068677824ULL, 0x100fe200078e0217ULL, 0xfffffffc6d047812ULL, 0x102fe200078ee20cULL,
0x0000001066057824ULL, 0x000fe200078e0217ULL, 0xfffffffc6f667812ULL, 0x100fe200078ee20cULL,
0x0000000199637824ULL, 0x000fe200008e0663ULL, 0xfffffffc6b067812ULL, 0x004fe200078ee20cULL,
0x0000001004037824ULL, 0x100fe200078e0217ULL, 0x0000006199617210ULL, 0x000fe200017fe4ffULL,
0x0000000008677faeULL, 0x0003e4000b901c48ULL, 0x0000001006077824ULL, 0x000fc400078e0217ULL,
0x0000000064697faeULL, 0x0005e8000b901c48ULL, 0x000000005c057faeULL, 0x0005e2000b901c48ULL,
0x0000001066097824ULL, 0x002fc600078e0217ULL, 0x000000005e037faeULL, 0x0005e8000b901c48ULL,
0x0000000060077faeULL, 0x0005e8000b901c48ULL, 0x0000000062097faeULL, 0x0005e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001019067824ULL, 0x000fe200078e00ffULL,
0x0000000415047810ULL, 0x002fe20007ffe0ffULL, 0x00000010195d7824ULL, 0x004fe200078e00ffULL,
0x0000000416057819ULL, 0x040fe200000006ffULL, 0x00000010165e7824ULL, 0x000fe200078e00ffULL,
0x0000000418037810ULL, 0x000fc40007ffe0ffULL, 0x0000300071097810ULL, 0x000fe40007ffe0ffULL,
0xfffffff005047812ULL, 0x000fe400078ee204ULL, 0xfffffff006037812ULL, 0x000fe200078ee203ULL,
0x0000001074057824ULL, 0x100fe400078e0209ULL, 0x0000001004747824ULL, 0x000fe200078e00ffULL,
0x0000000618047810ULL, 0x000fe20007ffe0ffULL, 0x0000001078087824ULL, 0x100fe400078e0209ULL,
0x0000001003037824ULL, 0x000fe200078e00ffULL, 0xfffffff05d5c7812ULL, 0x000fe200078ee204ULL,
0x000000107a077824ULL, 0x100fe200078e0209ULL, 0x00000006155d7810ULL, 0x000fe20007ffe0ffULL,
0x0000001076067824ULL, 0x000fe200078e0209ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000884783bULL, 0x000fe20000000200ULL, 0xfffffff05e5d7812ULL, 0x000fe200078ee25dULL,
0x000000105c717824ULL, 0x000fe400078e00ffULL, 0x000000000388783bULL, 0x0002a20000000200ULL,
0x0000001072047824ULL, 0x100fe400078e0209ULL, 0x000000105d5d7824ULL, 0x000fe200078e00ffULL,
0x000000000780783bULL, 0x000ee20000000200ULL, 0x0000001002027824ULL, 0x100fe400078e0209ULL,
0x0000001000007824ULL, 0x100fe200078e0209ULL, 0x00000000067c783bULL, 0x000f220000000200ULL,
0x0000001070037824ULL, 0x002fc600078e0209ULL, 0x000000000578783bULL, 0x000e680000000200ULL,
0x000000007474783bULL, 0x000e680000000200ULL, 0x00000000046c783bULL, 0x000fe80000000200ULL,
0x000000007170783bULL, 0x000e680000000200ULL, 0x000000000368783bULL, 0x000e680000000200ULL,
0x000000000264783bULL, 0x000e680000000200ULL, 0x000000000060783bULL, 0x000e680000000200ULL,
0x000000005d5c783bULL, 0x000e620000000200ULL, 0x000000848858723cULL, 0x044f700000001858ULL,
0x000000868824723cULL, 0x040f700000001824ULL, 0x000000808828723cULL, 0x048f700000001828ULL,
0x000000828890723cULL, 0x040f700000001890ULL, 0x0000007c888c723cULL, 0x050f70000000188cULL,
0x0000007e882c723cULL, 0x040f70000000182cULL, 0x000000788830723cULL, 0x042f700000001830ULL,
0x0000007a8834723cULL, 0x000f700000001834ULL, 0x000000847438723cULL, 0x040f700000001838ULL,
0x00000086743c723cULL, 0x040f70000000183cULL, 0x000000807440723cULL, 0x040f700000001840ULL,
0x000000827444723cULL, 0x040f700000001844ULL, 0x0000007c7448723cULL, 0x040f700000001848ULL,
0x0000007e744c723cULL, 0x040f70000000184cULL, 0x000000787450723cULL, 0x040f700000001850ULL,
0x0000007a7454723cULL, 0x000f700000001854ULL, 0x0000006c7058723cULL, 0x060b700000001858ULL,
0x0000006e7024723cULL, 0x040b700000001824ULL, 0x000000687028723cULL, 0x040b700000001828ULL,
0x0000006a7090723cULL, 0x040b700000001890ULL, 0x00000064708c723cULL, 0x040b70000000188cULL,
0x00000066702c723cULL, 0x040b70000000182cULL, 0x000000607030723cULL, 0x040b700000001830ULL,
0x000000627034723cULL, 0x000b700000001834ULL, 0x0000006c5c38723cULL, 0x040b700000001838ULL,
0x0000006e5c3c723cULL, 0x040b70000000183cULL, 0x000000685c40723cULL, 0x040b700000001840ULL,
0x0000006a5c44723cULL, 0x040b700000001844ULL, 0x000000645c48723cULL, 0x040b700000001848ULL,
0x000000665c4c723cULL, 0x040b70000000184cULL, 0x000000605c50723cULL, 0x040b700000001850ULL,
0x000000625c54723cULL, 0x000b620000001854ULL, 0x0000056000008947ULL, 0x000fce0003800000ULL,
0x00000002ff6e7819ULL, 0x020fe20000011620ULL, 0x000000ffff5f7224ULL, 0x000fe200078e00ffULL,
0x000000c01a5e7812ULL, 0x000fe200078efcffULL, 0x000000100b0b7824ULL, 0x000fe200078e0209ULL,
0x000000086e6b7810ULL, 0x040fe20007ffe0ffULL, 0x00000001215d7824ULL, 0x000fe200078e026eULL,
0x000000106e6f7810ULL, 0x000fc40007ffe0ffULL, 0x000000186e707810ULL, 0x040fe20007ffe0ffULL,
0x0000000121617824ULL, 0x040fe200078e026bULL, 0x0000006f21637210ULL, 0x000fe20007ffe0ffULL,
0x000001005d5c7825ULL, 0x100fe200078e005eULL, 0x000000206e717810ULL, 0x040fe40007ffe0ffULL,
0x000000286e727810ULL, 0x000fe20007ffe0ffULL, 0x0000010061607825ULL, 0x000fe200078e005eULL,
0x0000005c98667210ULL, 0x000fe40007f1e0ffULL, 0x000000306e737810ULL, 0x000fe20007ffe0ffULL,
0x000000046b6d7824ULL, 0x000fe200078e00ffULL, 0x0000006098687210ULL, 0x000fe20007f3e0ffULL,
0x0000000199677824ULL, 0x000fe200000e065dULL, 0x0000001b95607217ULL, 0x000fe20007800000ULL,
0x00000100635c7825ULL, 0x000fc800078e005eULL, 0x0000000199697824ULL, 0x000fe200008e0661ULL,
0x0000005c985c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000121617824ULL, 0x000fe400078e0270ULL,
0x00000001606c7824ULL, 0x000fe400078e0a1bULL, 0x0000010061607825ULL, 0x000fc600078e005eULL,
0x0000006c6e00720cULL, 0x080fe20003f46070ULL, 0x0000000121637824ULL, 0x000fe200078e0271ULL,
0x0000006c6b00720cULL, 0x000fe20003f66070ULL, 0x00000001995d7824ULL, 0x000fe200000e065dULL,
0x00000060986a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000121657824ULL, 0x000fe200078e0272ULL,
0xfffffffc6d607812ULL, 0x000fe200078ee20cULL, 0x0000010063627825ULL, 0x000fe200078e005eULL,
0x000000386e6e7810ULL, 0x000fe40007ffe0ffULL, 0x0000006c6f00720cULL, 0x000fe20003fa6070ULL,
0x00000001996b7824ULL, 0x000fe200000e0661ULL, 0x0000006298627210ULL, 0x000fe20007f3e0ffULL,
0x0000010065647825ULL, 0x000fe200078e005eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000660b7faeULL, 0x0003e2000d101c48ULL, 0x0000006c7000720cULL, 0x000fc40003f86070ULL,
0x00000010606d7824ULL, 0x000fe200078e0209ULL, 0x0000006498647210ULL, 0x000fe20007f1e0ffULL,
0x0000000121617824ULL, 0x000fe200078e0273ULL, 0x0000006c7200720cULL, 0x080fe20003f46070ULL,
0x000000046f6f7824ULL, 0x000fe200078e00ffULL, 0x00000000686d7faeULL, 0x0005e2000d901c48ULL,
0x0000010061607825ULL, 0x000fe200078e005eULL, 0x0000006c7100720cULL, 0x000fe40003f66070ULL,
0x00000002700b7819ULL, 0x002fe200000006ffULL, 0x0000000121757824ULL, 0x000fe200078e026eULL,
0x0000006098607210ULL, 0x000fe20007fde0ffULL, 0x0000000199637824ULL, 0x000fe200008e0663ULL,
0x0000006c7300720cULL, 0x000fe20003f26070ULL, 0x0000000471717824ULL, 0x000fe200078e00ffULL,
0xfffffffc6f667812ULL, 0x100fe200078ee20cULL, 0x0000000472677824ULL, 0x000fe200078e00ffULL,
0xfffffffc0b687812ULL, 0x004fe200078ee20cULL, 0x0000000473737824ULL, 0x000fc400078e00ffULL,
0x0000000199657824ULL, 0x000fe200000e0665ULL, 0x0000006c6e00720cULL, 0x040fe20003f06070ULL,
0x00000100755e7825ULL, 0x000fe200078e005eULL, 0xfffffffc716c7812ULL, 0x100fe400078ee20cULL,
0xfffffffc73707812ULL, 0x100fe200078ee20cULL, 0x000000046e697824ULL, 0x000fe200078e00ffULL,
0xfffffffc676e7812ULL, 0x100fe200078ee20cULL, 0x0000000199617824ULL, 0x000fe200030e0661ULL,
0x0000005e985e7210ULL, 0x000fe20007fde0ffULL, 0x00000010660b7824ULL, 0x100fe200078e0209ULL,
0xfffffffc69727812ULL, 0x000fe200078ee20cULL, 0x0000001068677824ULL, 0x000fc400078e0209ULL,
0x000000106c697824ULL, 0x100fe200078e0209ULL, 0x000000005c0b7faeULL, 0x0003e2000e901c48ULL,
0x000000106e6d7824ULL, 0x100fe400078e0209ULL, 0x00000010706f7824ULL, 0x100fe200078e0209ULL,
0x000000006a677faeULL, 0x0003e2000e101c48ULL, 0x0000001072097824ULL, 0x000fe400078e0209ULL,
0x00000001995f7824ULL, 0x000fe200030e065fULL, 0x0000000062697faeULL, 0x0003e8000d901c48ULL,
0x00000000646d7faeULL, 0x0003e8000d101c48ULL, 0x00000000606f7faeULL, 0x0003e8000c901c48ULL,
0x000000005e097faeULL, 0x0003e2000c101c48ULL, 0x000004a000007947ULL, 0x000fea0003800000ULL,
0x00000008206c7811ULL, 0x060fe200078ff0ffULL, 0x000000ffff6b7224ULL, 0x000fe200078e00ffULL,
0x00000010206e7811ULL, 0x040fe200078ff0ffULL, 0x000000100b777824ULL, 0x000fe200078e0209ULL,
0x0000001820707811ULL, 0x040fe200078ff0ffULL, 0x00000001215f7824ULL, 0x040fe200078e026cULL,
0x0000002020727811ULL, 0x040fe200078ff0ffULL, 0x0000000121617824ULL, 0x040fe200078e026eULL,
0x0000002820747811ULL, 0x040fe200078ff0ffULL, 0x0000000121637824ULL, 0x040fe200078e0270ULL,
0x0000003020767811ULL, 0x040fe200078ff0ffULL, 0x0000000121657824ULL, 0x040fe200078e0272ULL,
0x0000003820787811ULL, 0x000fe200078ff0ffULL, 0x0000000121677824ULL, 0x040fe200078e0274ULL,
0x000000c01a6a7812ULL, 0x000fe200078efcffULL, 0x000000046c0b7824ULL, 0x000fe200078e00ffULL,
0x00000021205d7211ULL, 0x000fe200078ff0ffULL, 0x00000001216d7824ULL, 0x040fe200078e0278ULL,
0x0000007621697210ULL, 0x000fe20007ffe0ffULL, 0x000001005f5e7825ULL, 0x000fe200078e006aULL,
0xfffffffc0b6c7812ULL, 0x000fc600078ee20cULL, 0x000001005d5c7825ULL, 0x000fe200078e006aULL,
0x0000005e985e7210ULL, 0x000fc60007f3e0ffULL, 0x0000010061607825ULL, 0x100fe200078e006aULL,
0x0000005c985c7210ULL, 0x040fe40007f1e0ffULL, 0x0000005f995f7210ULL, 0x000fe20000ffe4ffULL,
0x0000010063627825ULL, 0x000fe200078e006aULL, 0x0000006098607210ULL, 0x000fc60007f5e0ffULL,
0x0000010065647825ULL, 0x000fe200078e006aULL, 0x0000006298627210ULL, 0x000fc60007f7e0ffULL,
0x0000010067667825ULL, 0x000fc800078e006aULL, 0x0000010069687825ULL, 0x000fe200078e006aULL,
0x0000006698667210ULL, 0x000fc60007f3e0ffULL, 0x000001006d6a7825ULL, 0x000fc800078e006aULL,
0x000000046e6d7824ULL, 0x000fe400078e00ffULL, 0x00000004706f7824ULL, 0x000fe400078e00ffULL,
0x0000000472717824ULL, 0x000fe200078e00ffULL, 0xfffffffc6d6e7812ULL, 0x100fe200078ee20cULL,
0x0000000474737824ULL, 0x000fe200078e00ffULL, 0xfffffffc6f707812ULL, 0x100fe200078ee20cULL,
0x0000000476757824ULL, 0x000fe200078e00ffULL, 0xfffffffc71727812ULL, 0x100fe200078ee20cULL,
0x0000000478797824ULL, 0x000fe200078e00ffULL, 0xfffffffc73747812ULL, 0x100fe200078ee20cULL,
0x00000001995d7824ULL, 0x040fe200000e065dULL, 0x0000006498647210ULL, 0x000fe20007f1e0ffULL,
0x0000000199617824ULL, 0x000fe200010e0661ULL, 0xfffffffc75767812ULL, 0x100fe200078ee20cULL,
0x000000106c0b7824ULL, 0x000fe200078e0209ULL, 0x0000006898687210ULL, 0x000fe20007f5e0ffULL,
0x0000000199637824ULL, 0x000fe200018e0663ULL, 0xfffffffc79787812ULL, 0x000fe200078ee20cULL,
0x000000106e6d7824ULL, 0x100fe200078e0209ULL, 0x0000006a986a7210ULL, 0x000fe20007f7e0ffULL,
0x00000010706f7824ULL, 0x100fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000005c777faeULL, 0x0003e2000b901c48ULL, 0x0000001072717824ULL, 0x000fc400078e0209ULL,
0x0000000199657824ULL, 0x040fe200000e0665ULL, 0x000000005e0b7faeULL, 0x0003e2000b901c48ULL,
0x0000001074737824ULL, 0x000fe400078e0209ULL, 0x0000000199677824ULL, 0x040fe200008e0667ULL,
0x00000000606d7faeULL, 0x0003e2000b901c48ULL, 0x0000001076757824ULL, 0x000fe400078e0209ULL,
0x0000000199697824ULL, 0x000fe200010e0669ULL, 0x00000000626f7faeULL, 0x0003e2000b901c48ULL,
0x0000001078097824ULL, 0x000fc400078e0209ULL, 0x00000001996b7824ULL, 0x000fe200018e066bULL,
0x0000000064717faeULL, 0x0003e8000b901c48ULL, 0x0000000066737faeULL, 0x0003e8000b901c48ULL,
0x0000000068757faeULL, 0x0003e8000b901c48ULL, 0x000000006a097faeULL, 0x0003e4000b901c48ULL,
0x0000000422227810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff887424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000942200720cULL, 0x000fda0003f06070ULL,
0x00000002a0648824ULL, 0x002fe400078e0222ULL, 0x00000004ff658424ULL, 0x000fc800078e00ffULL,
0x0000640064648625ULL, 0x000fe200078e0065ULL, 0x0000000818097810ULL, 0x000fe40007ffe0ffULL,
0x00000008150b7810ULL, 0x000fe20007ffe0ffULL, 0x00000010195c7824ULL, 0x000fe200078e00ffULL,
0x0000000864888981ULL, 0x0002a2000c1e1900ULL, 0x00000010165e7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff05c097812ULL, 0x000fe200078ee209ULL,
0x0000001019757824ULL, 0x000fe200078e00ffULL, 0xfffffff05e0b7812ULL, 0x000fe200078ee20bULL,
0x000000001268783bULL, 0x000fe20000000200ULL, 0x0000000a18747810ULL, 0x000fe20007ffe0ffULL,
0x0000001009097824ULL, 0x000fe400078e00ffULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0x000000001364783bULL, 0x002fe20000000200ULL, 0xfffffff075747812ULL, 0x000fe400078ee274ULL,
0x0000000a15757810ULL, 0x000fe20007ffe0ffULL, 0x000000000960783bULL, 0x000e640000000200ULL,
0x0000001074747824ULL, 0x000fc400078e00ffULL, 0x000000000b6c783bULL, 0x000ee80000000200ULL,
0x00000000145c783bULL, 0x0008e80000000200ULL, 0x000000001170783bULL, 0x000ee20000000200ULL,
0x0000001016147824ULL, 0x010fc600078e00ffULL, 0x000000000f78783bULL, 0x000fe40000000200ULL,
0xfffffff014097812ULL, 0x000fe400078ee275ULL, 0x000000001010783bULL, 0x000fe60000000200ULL,
0x0000001009097824ULL, 0x000fe200078e00ffULL, 0x000000007474783bULL, 0x000f280000000200ULL,
0x000000000980783bULL, 0x000f280000000200ULL, 0x000000000e7c783bULL, 0x0007280000000200ULL,
0x000000000d84783bULL, 0x000f220000000200ULL, 0x000000646028723cULL, 0x082f700000001828ULL,
0x000000646c40723cULL, 0x008f700000001840ULL, 0x0000005c6058723cULL, 0x040f700000001858ULL,
0x0000005e6024723cULL, 0x040f700000001824ULL, 0x000000666090723cULL, 0x040f700000001890ULL,
0x00000068608c723cULL, 0x040f70000000188cULL, 0x0000006a602c723cULL, 0x040f70000000182cULL,
0x000000706030723cULL, 0x040f700000001830ULL, 0x000000726034723cULL, 0x000f700000001834ULL,
0x0000005c6c38723cULL, 0x040f700000001838ULL, 0x0000005e6c3c723cULL, 0x040f70000000183cULL,
0x000000666c44723cULL, 0x040f700000001844ULL, 0x000000686c48723cULL, 0x040f700000001848ULL,
0x0000006a6c4c723cULL, 0x040f70000000184cULL, 0x000000706c50723cULL, 0x040f700000001850ULL,
0x000000726c54723cULL, 0x000f700000001854ULL, 0x000000787428723cULL, 0x0b0f700000001828ULL,
0x000000788040723cULL, 0x000b6e0000001840ULL, 0x0000030096787a10ULL, 0x020fe20007ffe0ffULL,
0x000000107458723cULL, 0x000b660000001858ULL, 0x00000001780e7810ULL, 0x000fc80007ffe0ffULL,
0x000000230e00720cULL, 0x000fe20003f06070ULL, 0x000000127424723cULL, 0x040b700000001824ULL,
0x0000007a7490723cULL, 0x040b700000001890ULL, 0x0000007c748c723cULL, 0x040b70000000188cULL,
0x0000007e742c723cULL, 0x040b70000000182cULL, 0x000000847430723cULL, 0x040b700000001830ULL,
0x000000867434723cULL, 0x000b700000001834ULL, 0x000000108038723cULL, 0x040b700000001838ULL,
0x00000012803c723cULL, 0x040b70000000183cULL, 0x0000007a8044723cULL, 0x040b700000001844ULL,
0x0000007c8048723cULL, 0x040b700000001848ULL, 0x0000007e804c723cULL, 0x040b70000000184cULL,
0x000000848050723cULL, 0x000b620000001850ULL, 0x0000009d880e7224ULL, 0x004fc800078e02ffULL,
0x000062000e0e7625ULL, 0x000fc600078e009fULL, 0x000000868054723cULL, 0x000b620000001854ULL,
0x000005c000008947ULL, 0x000fce0003800000ULL, 0x00000002ff147819ULL, 0x000fe40000011620ULL,
0x0000009e78127211ULL, 0x020fe400078e40ffULL, 0x0000001014647810ULL, 0x040fe20007ffe0ffULL,
0x0000000121107824ULL, 0x000fe200078e0214ULL, 0x0000000814627810ULL, 0x000fe40007ffe0ffULL,
0x0000001295097217ULL, 0x000fe20007800000ULL, 0x0000010010107825ULL, 0x000fe200078e00ffULL,
0x0000001814667810ULL, 0x000fc40007ffe0ffULL, 0x0000002014687810ULL, 0x000fe20007ffe0ffULL,
0x00000001215c7824ULL, 0x040fe200078e0264ULL, 0x0000001a100b7212ULL, 0x080fe200078efcffULL,
0x0000000121137824ULL, 0x000fe200078e0262ULL, 0x00000028146a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109097824ULL, 0x000fe200078e0a12ULL, 0x0000000b0e107210ULL, 0x000fe20007f1e0ffULL,
0x000001005c5c7825ULL, 0x000fe200078e00ffULL, 0x00000030146c7810ULL, 0x000fe40007ffe0ffULL,
0x000000096400720cULL, 0x000fe20003fa6070ULL, 0x0000010013127825ULL, 0x000fe200078e00ffULL,
0x0000001a5c0b7212ULL, 0x000fc400078efcffULL, 0x000000096600720cULL, 0x000fe20003f86070ULL,
0x00000001215e7824ULL, 0x000fe200078e0266ULL, 0x0000001a120d7212ULL, 0x000fe200078efcffULL,
0x0000000111117824ULL, 0x000fe200000e060fULL, 0x0000000b0e5c7210ULL, 0x040fe20007f1e0ffULL,
0x0000000121607824ULL, 0x000fe200078e0268ULL, 0x0000000d0e127210ULL, 0x000fe20007f3e0ffULL,
0x000001005e5e7825ULL, 0x000fc800078e00ffULL, 0x0000000462637824ULL, 0x000fe200078e00ffULL,
0x0000001a5e0d7212ULL, 0x080fe200078efcffULL, 0x000000015d5d7824ULL, 0x100fe200000e060fULL,
0x000000091400720cULL, 0x080fe20003f06070ULL, 0x0000000113137824ULL, 0x000fe200008e060fULL,
0x000000096200720cULL, 0x000fe20003f26070ULL, 0x0000010060607825ULL, 0x000fe200078e00ffULL,
0xfffffffc63627812ULL, 0x000fe400078ee20cULL, 0x0000000d0e5e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000121637824ULL, 0x000fe200078e026aULL, 0x0000001a600b7212ULL, 0x080fe200078efcffULL,
0x00000010620d7824ULL, 0x000fe200078e0217ULL, 0x0000003814147810ULL, 0x000fe20007ffe0ffULL,
0x0000010063627825ULL, 0x000fe200078e00ffULL, 0x0000000b0e607210ULL, 0x000fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000100a7faeULL, 0x0003e2000c101c48ULL,
0x000000091400720cULL, 0x080fe20003f06070ULL, 0x000000015f5f7824ULL, 0x100fe200010e060fULL,
0x0000001a620b7212ULL, 0x000fe200078efcffULL, 0x0000000161617824ULL, 0x000fe200018e060fULL,
0x00000000120d7faeULL, 0x0005e2000c901c48ULL, 0x000000096800720cULL, 0x080fe20003f66070ULL,
0x000000046c657824ULL, 0x000fe200078e00ffULL, 0x000000096a00720cULL, 0x080fe20003f46070ULL,
0x0000000414677824ULL, 0x000fe200078e00ffULL, 0x000000096c00720cULL, 0x000fe20003f26070ULL,
0x0000000464097824ULL, 0x000fe200078e00ffULL, 0x0000000b0e627210ULL, 0x000fe20007fde0ffULL,
0x00000001210a7824ULL, 0x002fc400078e026cULL, 0x0000000468117824ULL, 0x000fe200078e00ffULL,
0xfffffffc65687812ULL, 0x100fe200078ee20cULL, 0x000001000a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffffc09127812ULL, 0x104fe400078ee20cULL, 0xfffffffc11647812ULL, 0x000fe200078ee20cULL,
0x0000000121107824ULL, 0x000fe200078e0214ULL, 0x0000001a0a097212ULL, 0x000fe200078efcffULL,
0x0000000163637824ULL, 0x000fe200030e060fULL, 0x00000002660d7819ULL, 0x000fe200000006ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x000000090e0a7210ULL, 0x000fc40007fde0ffULL,
0xfffffffc0d147812ULL, 0x100fe200078ee20cULL, 0x000000046a137824ULL, 0x000fe200078e00ffULL,
0x0000001a100d7212ULL, 0x000fe200078efcffULL, 0x000000010b0b7824ULL, 0x000fe200030e060fULL,
0xfffffffc676a7812ULL, 0x100fe200078ee20cULL, 0x0000001012097824ULL, 0x100fe200078e0217ULL,
0xfffffffc13667812ULL, 0x000fe200078ee20cULL, 0x0000001014137824ULL, 0x100fe200078e0217ULL,
0x0000000d0e0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001064657824ULL, 0x100fe200078e0217ULL,
0x000000005c097faeULL, 0x0003e2000e901c48ULL, 0x0000001066677824ULL, 0x000fc400078e0217ULL,
0x0000001068697824ULL, 0x100fe200078e0217ULL, 0x000000005e137faeULL, 0x0003e2000e101c48ULL,
0x000000106a177824ULL, 0x000fe400078e0217ULL, 0x00000001110d7824ULL, 0x000fe200030e060fULL,
0x0000000060657faeULL, 0x0003e8000d901c48ULL, 0x0000000062677faeULL, 0x0003e8000d101c48ULL,
0x000000000a697faeULL, 0x0003e8000c901c48ULL, 0x000000000c177faeULL, 0x0003e2000c101c48ULL,
0x000004f000007947ULL, 0x000fea0003800000ULL, 0x0000002020647811ULL, 0x040fe400078ff0ffULL,
0x0000002120107211ULL, 0x020fc400078ff0ffULL, 0x0000000820127811ULL, 0x000fe200078ff0ffULL,
0x00000004645d7824ULL, 0x000fe200078e00ffULL, 0x0000001020147811ULL, 0x000fe200078ff0ffULL,
0x0000010010107825ULL, 0x000fe200078e00ffULL, 0x0000001820607811ULL, 0x040fe400078ff0ffULL,
0x0000002820687811ULL, 0x040fe200078ff0ffULL, 0x0000000121137824ULL, 0x040fe200078e0212ULL,
0x00000030206c7811ULL, 0x040fe200078ff0ffULL, 0x00000001215c7824ULL, 0x000fe200078e0214ULL,
0x0000003820707811ULL, 0x000fe200078ff0ffULL, 0x0000000412097824ULL, 0x000fe200078e00ffULL,
0x00000002600d7819ULL, 0x000fe200000006ffULL, 0x00000004140b7824ULL, 0x000fe200078e00ffULL,
0xfffffffc5d667812ULL, 0x100fe200078ee20cULL, 0x00000004685f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0d627812ULL, 0x100fe200078ee20cULL, 0x000000046c617824ULL, 0x000fe200078e00ffULL,
0x0000001a100d7212ULL, 0x000fe200078efcffULL, 0x0000000470637824ULL, 0x000fe200078e00ffULL,
0xfffffffc09147812ULL, 0x100fe200078ee20cULL, 0x0000010013127825ULL, 0x000fe200078e00ffULL,
0xfffffffc0b5e7812ULL, 0x000fc400078ee20cULL, 0xfffffffc5f6a7812ULL, 0x100fe200078ee20cULL,
0x000001005c5c7825ULL, 0x000fe200078e00ffULL, 0xfffffffc616e7812ULL, 0x100fe400078ee20cULL,
0xfffffffc63727812ULL, 0x000fe200078ee20cULL, 0x00000001215f7824ULL, 0x000fe200078e0260ULL,
0x0000000d0e0c7210ULL, 0x000fe20007f1e0ffULL, 0x000000105e697824ULL, 0x000fe200078e0217ULL,
0x0000001a12097212ULL, 0x080fe200078efcffULL, 0x000001005f5e7825ULL, 0x000fe200078e00ffULL,
0x0000001a5c0d7212ULL, 0x000fc400078efcffULL, 0x000000090e107210ULL, 0x000fe20007f3e0ffULL,
0x00000010626b7824ULL, 0x000fe200078e0217ULL, 0x0000000d0e127210ULL, 0x000fe20007f5e0ffULL,
0x00000001110d7824ULL, 0x100fe400000e060fULL, 0x0000000113117824ULL, 0x100fe400008e060fULL,
0x000000015d137824ULL, 0x000fe200010e060fULL, 0x0000001a5e5d7212ULL, 0x000fe200078efcffULL,
0x0000000121607824ULL, 0x040fe200078e0264ULL, 0x0000006c21647210ULL, 0x040fe20007ffe0ffULL,
0x0000000121627824ULL, 0x040fe200078e0268ULL, 0x0000005d0e5c7210ULL, 0x000fe20007f1e0ffULL,
0x00000010666d7824ULL, 0x000fe200078e0217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0a7faeULL, 0x0003e2000b901c48ULL, 0x0000000121667824ULL, 0x000fc400078e0270ULL,
0x0000010060607825ULL, 0x000fc800078e00ffULL, 0x0000010062627825ULL, 0x000fc800078e00ffULL,
0x0000010064647825ULL, 0x000fe200078e00ffULL, 0x0000001a62097212ULL, 0x000fc600078efcffULL,
0x0000010066667825ULL, 0x000fc800078e00ffULL, 0x000000015f5d7824ULL, 0x000fe200000e060fULL,
0x0000001a605f7212ULL, 0x080fe200078efcffULL, 0x00000010140b7824ULL, 0x100fe200078e0217ULL,
0x0000001a66737212ULL, 0x080fe200078efcffULL, 0x000000106a6f7824ULL, 0x100fe200078e0217ULL,
0x0000005f0e5e7210ULL, 0x000fe20007f1e0ffULL, 0x000000106e717824ULL, 0x100fe200078e0217ULL,
0x000000090e607210ULL, 0x000fe20007f3e0ffULL, 0x0000001072757824ULL, 0x000fe200078e0217ULL,
0x0000001a64177212ULL, 0x000fe200078efcffULL, 0x00000001615f7824ULL, 0x100fe200000e060fULL,
0x00000000100b7faeULL, 0x0003e2000b901c48ULL, 0x0000000163617824ULL, 0x000fe200008e060fULL,
0x000000170e627210ULL, 0x000fc40007f5e0ffULL, 0x000000730e0e7210ULL, 0x000fe20007f7e0ffULL,
0x0000000012697faeULL, 0x0003e4000b901c48ULL, 0x0000000165637824ULL, 0x100fe400010e060fULL,
0x00000001670f7824ULL, 0x000fe200018e060fULL, 0x000000005c6b7faeULL, 0x0003e8000b901c48ULL,
0x000000005e6d7faeULL, 0x0003e8000b901c48ULL, 0x00000000606f7faeULL, 0x0003e8000b901c48ULL,
0x0000000062717faeULL, 0x0003e8000b901c48ULL, 0x000000000e757faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000010190a7824ULL, 0x002fe200078e00ffULL,
0x0000000c18097810ULL, 0x000fe20007ffe0ffULL, 0x0000001016117824ULL, 0x000fe200078e00ffULL,
0x0000000c15107810ULL, 0x000fe20007ffe0ffULL, 0x0000001019197824ULL, 0x000fe200078e00ffULL,
0xfffffff00a097812ULL, 0x000fe200078ee209ULL, 0x0000001016167824ULL, 0x000fe200078e00ffULL,
0xfffffff011147812ULL, 0x000fc400078ee210ULL, 0x0000000e18187810ULL, 0x000fe20007ffe0ffULL,
0x00000010090c7824ULL, 0x000fe200078e00ffULL, 0x0000000e15157810ULL, 0x000fe20007ffe0ffULL,
0x0000001014607824ULL, 0x000fe200078e00ffULL, 0xfffffff019187812ULL, 0x000fca00078ee218ULL,
0x0000001018187824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000000808783bULL, 0x000fe80000000200ULL, 0x000000000c0c783bULL, 0x000e680000000200ULL,
0x000000006060783bULL, 0x000ea80000000200ULL, 0x000000000710783bULL, 0x0007280000000200ULL,
0x00000000065c783bULL, 0x000ea80000000200ULL, 0x000000000564783bULL, 0x000ea20000000200ULL,
0xfffffff016077812ULL, 0x008fc600078ee215ULL, 0x000000000468783bULL, 0x0007e40000000200ULL,
0x0000001007197824ULL, 0x000fe400078e00ffULL, 0x00000000186c783bULL, 0x000ee80000000200ULL,
0x000000000314783bULL, 0x000ee80000000200ULL, 0x000000000270783bULL, 0x0002e80000000200ULL,
0x000000000074783bULL, 0x000ee20000000200ULL, 0x000000080c7c723cULL, 0x042b660000001858ULL,
0x000000001958783bULL, 0x020e6a0000000200ULL, 0x0000000a0c24723cULL, 0x000f700000001824ULL,
0x000000086038723cULL, 0x044ff00000001838ULL, 0x0000000a603c723cULL, 0x000ff0000000183cULL,
0x000000100c28723cULL, 0x050f700000001828ULL, 0x000000120c90723cULL, 0x040f700000001890ULL,
0x0000005c0c8c723cULL, 0x040ff0000000188cULL, 0x0000005e0c2c723cULL, 0x040ff0000000182cULL,
0x000000640c30723cULL, 0x040ff00000001830ULL, 0x000000660c34723cULL, 0x000ff00000001834ULL,
0x000000106004723cULL, 0x048ff00000001840ULL, 0x0000005c6008723cULL, 0x040ff00000001848ULL,
0x000000126044723cULL, 0x040ff00000001844ULL, 0x0000005e604c723cULL, 0x040ff0000000184cULL,
0x00000064600c723cULL, 0x040ff00000001850ULL, 0x000000666054723cULL, 0x000ff00000001854ULL,
0x000000686c7c723cULL, 0x040f70000000187cULL, 0x0000006a6c24723cULL, 0x060f700000001824ULL,
0x000000146c28723cULL, 0x040f700000001828ULL, 0x000000166c90723cULL, 0x000f620000001890ULL,
0x3db504f37c037820ULL, 0x000fe20000410000ULL, 0x3db504f37d027820ULL, 0x000fe20000410000ULL,
0x3db504f37e7e7820ULL, 0x000fe20000410000ULL, 0x3db504f37f7f7820ULL, 0x000fc80000410000ULL,
0x000000706c8c723cULL, 0x000f64000000188cULL, 0x3db504f326187820ULL, 0x020fe20000410000ULL,
0x3db504f3271a7820ULL, 0x000fe20000410000ULL, 0x3db504f324247820ULL, 0x000fe20000410000ULL,
0x3db504f325257820ULL, 0x000fc60000410000ULL, 0x000000726c2c723cULL, 0x000f62000000182cULL,
0x3db504f328287820ULL, 0x000fe20000410000ULL, 0x3db504f329297820ULL, 0x000fe20000410000ULL,
0x3db504f32a2a7820ULL, 0x000fe20000410000ULL, 0x3db504f32b2b7820ULL, 0x000fc80000410000ULL,
0x000000746c30723cULL, 0x000f620000001830ULL, 0x3db504f390907820ULL, 0x000fe20000410000ULL,
0x3db504f391917820ULL, 0x000fe20000410000ULL, 0x3db504f392267820ULL, 0x000fe20000410000ULL,
0x3db504f393277820ULL, 0x000fc80000410000ULL, 0x000000766c34723cULL, 0x000f620000001834ULL,
0x3db504f38c8c7820ULL, 0x000fe20000410000ULL, 0x3db504f38d137820ULL, 0x000fe20000410000ULL,
0x3db504f38e8e7820ULL, 0x000fe20000410000ULL, 0x3db504f38f8f7820ULL, 0x000fc80000410000ULL,
0x000000685838723cULL, 0x002f640000001838ULL, 0x3db504f32c2c7820ULL, 0x020fe20000410000ULL,
0x3db504f32d2d7820ULL, 0x000fe20000410000ULL, 0x3db504f32e2e7820ULL, 0x000fe20000410000ULL,
0x3db504f32f2f7820ULL, 0x000fc60000410000ULL, 0x000000145804723cULL, 0x000f620000001804ULL,
0x3db504f331117820ULL, 0x000fe20000410000ULL, 0x3db504f330307820ULL, 0x000fe20000410000ULL,
0x3db504f332327820ULL, 0x000fe20000410000ULL, 0x3db504f333337820ULL, 0x000fc80000410000ULL,
0x000000705808723cULL, 0x000f620000001808ULL, 0x3db504f334127820ULL, 0x000fe20000410000ULL,
0x3db504f335107820ULL, 0x000fe20000410000ULL, 0x3db504f336367820ULL, 0x000fe20000410000ULL,
0x3db504f337377820ULL, 0x000fc80000410000ULL, 0x0000006a5868723cULL, 0x000f62000000183cULL,
0x3db504f338317820ULL, 0x000fe20000410000ULL, 0x3db504f33b487820ULL, 0x000fe20000410000ULL,
0x3db504f339397820ULL, 0x000fca0000410000ULL, 0x000000165814723cULL, 0x000b640000001844ULL,
0x3db504f304347820ULL, 0x020fe20000410000ULL, 0x3db504f305357820ULL, 0x000fc80000410000ULL,
0x3db504f33a447820ULL, 0x000fe20000410000ULL, 0x000000725870723cULL, 0x000b62000000184cULL,
0x3db504f308387820ULL, 0x000fe20000410000ULL, 0x3db504f309057820ULL, 0x000fe20000410000ULL,
0x3db504f30a4a7820ULL, 0x000fe20000410000ULL, 0x3db504f30b3b7820ULL, 0x000fc60000410000ULL,
0x3db504f3064d7820ULL, 0x020fe20000410000ULL, 0x00000074580c723cULL, 0x000f62000000180cULL,
0x3db504f368687820ULL, 0x000fe20000410000ULL, 0x3db504f369697820ULL, 0x000fe20000410000ULL,
0x3db504f36a497820ULL, 0x000fe20000410000ULL, 0x3db504f36b4b7820ULL, 0x000fe20000410000ULL,
0x3db504f3074e7820ULL, 0x000fc60000410000ULL, 0x000000765858723cULL, 0x000f620000001854ULL,
0x3db504f314007820ULL, 0x000fe20000410000ULL, 0x3db504f315047820ULL, 0x000fe20000410000ULL,
0x3db504f3164f7820ULL, 0x000fe20000410000ULL, 0x3db504f3174c7820ULL, 0x000fc80000410000ULL,
0x3db504f3703a7820ULL, 0x000fe20000410000ULL, 0x3db504f3713c7820ULL, 0x000fe20000410000ULL,
0x3db504f3723d7820ULL, 0x000fe20000410000ULL, 0x3db504f3733e7820ULL, 0x000fca0000410000ULL,
0x3db504f30c3f7820ULL, 0x020fe20000410000ULL, 0x3db504f30d407820ULL, 0x000fe20000410000ULL,
0x3db504f30e417820ULL, 0x000fe20000410000ULL, 0x3db504f30f437820ULL, 0x000fca0000410000ULL,
0x3db504f358427820ULL, 0x000fe20000410000ULL, 0x3db504f359457820ULL, 0x000fe20000410000ULL,
0x3db504f35a467820ULL, 0x000fe20000410000ULL, 0x3db504f35b477820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000009b507f8cULL, 0x0002a2000c80043fULL,
0x000000ffff087224ULL, 0x000fe200078e0024ULL, 0x00000029000b7202ULL, 0x000fe20000000f00ULL,
0x000000ffff097224ULL, 0x000fe400078e0025ULL, 0x000000ffff247224ULL, 0x000fe400078e002aULL,
0x000000ffff257224ULL, 0x000fc400078e002bULL, 0x000000ffff167224ULL, 0x000fe400078e002cULL,
0x000000ffff147224ULL, 0x000fe400078e002dULL, 0x000000ffff157224ULL, 0x000fe400078e0030ULL,
0x000000ffff2a7224ULL, 0x000fe400078e002eULL, 0x000000ffff2b7224ULL, 0x000fe200078e002fULL,
0x00000037002f7202ULL, 0x000fe20000000f00ULL, 0x000000ffff0a7224ULL, 0x000fc400078e0028ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0032ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0033ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0036ULL, 0x000000ffff307224ULL, 0x000fe400078e0039ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0090ULL, 0x000000ffff0d7224ULL, 0x000fc400078e0091ULL,
0x000000ffff0f7224ULL, 0x000fe400078e008cULL, 0x000000ffff0e7224ULL, 0x000fe400078e007eULL,
0x000000ffff177224ULL, 0x000fe400078e007fULL, 0x000000ffff287224ULL, 0x000fe400078e008eULL,
0x000000ffff297224ULL, 0x000fe400078e008fULL, 0x000000ffff327224ULL, 0x000fc400078e0068ULL,
0x000000ffff337224ULL, 0x000fe400078e0069ULL, 0x000000ffff367224ULL, 0x000fe400078e0000ULL,
0x000000ffff377224ULL, 0x000fe400078e0004ULL, 0x000000ffff397224ULL, 0x000fc400078e0005ULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x000004009b077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804851ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff527224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000105200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604197210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09001900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011407ULL, 0x0000001900007211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000200007819ULL, 0x000fc80000001207ULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000152527810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004009b077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804851ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000420197824ULL, 0x000fe200078e00ffULL,
0x0000001d9600720cULL, 0x000fc80003f06070ULL, 0xfffffff019057812ULL, 0x000fca00078ec0ffULL,
0x000000809a007824ULL, 0x000fca00078e0205ULL, 0x0164000000047984ULL, 0x0002a20000000c00ULL,
0x00001f5000008947ULL, 0x000fea0003800000ULL, 0x0000000220507824ULL, 0x040fe200078e00ffULL,
0x0000001b95527217ULL, 0x000fe20007800000ULL, 0x00000002ff6f7424ULL, 0x000fe200078e00ffULL,
0x0000009720517211ULL, 0x000fe400078ff0ffULL, 0x0000000650507812ULL, 0x000fe200078ec0ffULL,
0x00000001521b7824ULL, 0x000fe200078e0a1bULL, 0x0000000851527810ULL, 0x000fe40007ffe0ffULL,
0x00005a00ff547a19ULL, 0x000fe20000011651ULL, 0x000000011e567824ULL, 0x000fe200078e0250ULL,
0x00005a00ff587a19ULL, 0x000fc40000011652ULL, 0x0000580050527a10ULL, 0x000fe40007ffe0ffULL,
0x0000001b5600720cULL, 0x040fe20003f26070ULL, 0x0000000156567824ULL, 0x100fe200078e0a1bULL,
0x0000001051557810ULL, 0x040fe40007ffe0ffULL, 0x0000001851577810ULL, 0x000fe40007ffe0ffULL,
0x000000541f517217ULL, 0x040fe20003800000ULL, 0x0000000152547824ULL, 0x000fe200078e0a1bULL,
0x000000561f567217ULL, 0x000fc40003800000ULL, 0x0000001b5200720cULL, 0x000fe20003f06070ULL,
0x000000511c7c7224ULL, 0x000fe200078e02ffULL, 0x00000004ff567819ULL, 0x000fe40000011656ULL,
0x000000541f547217ULL, 0x000fe40003800000ULL, 0x000000ff565b7207ULL, 0x000fe40000800000ULL,
0x000000ff54697207ULL, 0x000fe40000000000ULL, 0x00005a00ff5a7a19ULL, 0x000fc40000011655ULL,
0x0000005b7c547210ULL, 0x000fe40007ffe0ffULL, 0x0000007c69567211ULL, 0x000fe400078fe0ffULL,
0x000000581f537217ULL, 0x040fe20003800000ULL, 0x0000600054547625ULL, 0x080fe200078e006fULL,
0x0000005a1f517217ULL, 0x040fe40003800000ULL, 0x00005a00ff5c7a19ULL, 0x000fe20000011657ULL,
0x0000600056567625ULL, 0x000fe200078e006fULL, 0x0000001050647812ULL, 0x000fe200078efcffULL,
0x0000000854547981ULL, 0x000724000c1e9500ULL, 0x000000531c827224ULL, 0x040fe200078e02ffULL,
0x0000005c1f537217ULL, 0x000fe20003800000ULL, 0x000000511c847224ULL, 0x000fc400078e02ffULL,
0x0000000856517981ULL, 0x000322000c1e9500ULL, 0x0000008269587211ULL, 0x040fe200078fe0ffULL,
0x000000011e687824ULL, 0x000fe200078e0264ULL, 0x00000084695a7211ULL, 0x000fe200078fe0ffULL,
0x000000531c867224ULL, 0x000fe400078e02ffULL, 0x000000015b607824ULL, 0x040fe400078e0282ULL,
0x000000015b627824ULL, 0x000fe400078e0284ULL, 0x00000001686a7824ULL, 0x000fc400078e0a1bULL,
0x0000600058587625ULL, 0x000fe200078e006fULL, 0x0000580064667a10ULL, 0x000fc60007ffe0ffULL,
0x000000015b5e7824ULL, 0x000fe400078e0286ULL, 0x0000600060607625ULL, 0x000fc800078e006fULL,
0x0000600062627625ULL, 0x080fe200078e006fULL, 0x0000006a1f6a7217ULL, 0x000fe20003800000ULL,
0x0000000858537981ULL, 0x000524000c1e9500ULL, 0x000060005a5a7625ULL, 0x000fe400078e006fULL,
0x0000000860607981ULL, 0x000322000c1e9500ULL, 0x0000001b6800720cULL, 0x000fc60003f26070ULL,
0x000000085a557981ULL, 0x008722000c1e9500ULL, 0x000060005e587625ULL, 0x004fc600078e006fULL,
0x0000000862627981ULL, 0x000522000c1e9500ULL, 0x00000004ff6a7819ULL, 0x000fe2000001166aULL,
0x00000001665e7824ULL, 0x040fe200078e0a1bULL, 0x00000086695c7211ULL, 0x000fe200078fe0ffULL,
0x0000000858577981ULL, 0x002322000c1e9500ULL, 0x0000001b6600720cULL, 0x000fe40003f06070ULL,
0x0000005e1f5e7217ULL, 0x000fe40003800000ULL, 0x000000ff6a5f7207ULL, 0x000fe20000800000ULL,
0x000060005c5c7625ULL, 0x000fe200078e006fULL, 0x000000ff5e757207ULL, 0x000fc60000000000ULL,
0x000000017c5a7824ULL, 0x008fe200078e025fULL, 0x000000085c567981ULL, 0x000722000c1e9500ULL,
0x0000007c75587211ULL, 0x002fe400078fe0ffULL, 0x000060005a5a7625ULL, 0x000fe200078e006fULL,
0x0000002050727812ULL, 0x000fc600078efcffULL, 0x000000015f5e7824ULL, 0x000fe200078e0282ULL,
0x000000085a687981ULL, 0x000322000c1e9500ULL, 0x00000082755c7211ULL, 0x008fe200078fe0ffULL,
0x000000015f707824ULL, 0x040fe400078e0284ULL, 0x000000015f767824ULL, 0x000fe400078e0286ULL,
0x000060005c5c7625ULL, 0x000fe200078e006fULL, 0x0000580072747a10ULL, 0x000fc60007ffe0ffULL,
0x0000600058587625ULL, 0x080fe200078e006fULL, 0x000000085c637981ULL, 0x0044e6000c1e9500ULL,
0x000060005e5e7625ULL, 0x000fe200078e006fULL, 0x0000000858617981ULL, 0x0004e6000c1e9500ULL,
0x000000011e5a7824ULL, 0x002fe200078e0272ULL, 0x000000085e6e7981ULL, 0x0002e6000c1e9500ULL,
0x000000015a5c7824ULL, 0x004fe200078e0a1bULL, 0x00000084756a7211ULL, 0x000fc400078fe0ffULL,
0x00000086756c7211ULL, 0x000fe200078fe0ffULL, 0x0000000174587824ULL, 0x000fe200078e0a1bULL,
0x0000005c1f5c7217ULL, 0x040fe20003800000ULL, 0x0000600070707625ULL, 0x000fe200078e006fULL,
0x0000001b7400720cULL, 0x000fe40003f06070ULL, 0x000000581f587217ULL, 0x000fe20003800000ULL,
0x0000600076767625ULL, 0x000fe200078e006fULL, 0x0000001b5a00720cULL, 0x000fe20003f26070ULL,
0x0000000870707981ULL, 0x0004e2000c1e9500ULL, 0x00000004ff5c7819ULL, 0x000fe2000001165cULL,
0x000060006a6a7625ULL, 0x000fc800078e006fULL, 0x000060006c6c7625ULL, 0x000fe200078e006fULL,
0x000000ff58797207ULL, 0x000fe20000000000ULL, 0x000000086a657981ULL, 0x0002e2000c1e9500ULL,
0x000000ff5c597207ULL, 0x000fc60000800000ULL, 0x000000086c677981ULL, 0x0004e8000c1e9500ULL,
0x0000000876767981ULL, 0x0004e2000c1e9500ULL, 0x00000001596a7824ULL, 0x002fe200078e0282ULL,
0x00000082796c7211ULL, 0x004fc600078fe0ffULL, 0x000060006a6a7625ULL, 0x000fe200078e006fULL,
0x0000007c795a7211ULL, 0x000fc600078fe0ffULL, 0x000060006c6c7625ULL, 0x080fe200078e006fULL,
0x000000086ad27981ULL, 0x0002a6000c1e9500ULL, 0x000060005a5a7625ULL, 0x080fe200078e006fULL,
0x000000086c737981ULL, 0x0002a2000c1e9500ULL, 0x00000084795e7211ULL, 0x000fe400078fe0ffULL,
0x00000001597e7824ULL, 0x000fe200078e0286ULL, 0x0000008679587211ULL, 0x000fe200078fe0ffULL,
0x000000017c7a7824ULL, 0x000fe200078e0259ULL, 0x0000003050b87812ULL, 0x000fe200078efcffULL,
0x00000001595c7824ULL, 0x000fe200078e0284ULL, 0x000000085a717981ULL, 0x0002a2000c1e9500ULL,
0x000060007a7a7625ULL, 0x000fe200078e006fULL, 0x00005800b8ba7a10ULL, 0x000fc60007ffe0ffULL,
0x000060005e5e7625ULL, 0x080fe400078e006fULL, 0x000000087a7a7981ULL, 0x0002a4000c1e9500ULL,
0x000060007e5a7625ULL, 0x082fe200078e006fULL, 0x000000b81e7e7210ULL, 0x000fe20007ffe0ffULL,
0x000000085e777981ULL, 0x0002a4000c1e9500ULL, 0x0000600058587625ULL, 0x080fe400078e006fULL,
0x000000085a857981ULL, 0x0002a4000c1e9500ULL, 0x000060005c5c7625ULL, 0x000fc400078e006fULL,
0x0000000858da7981ULL, 0x0002a4000c1e9500ULL, 0x000000017e807824ULL, 0x100fe400078e0a1bULL,
0x000000085cd67981ULL, 0x0002a2000c1e9500ULL, 0x00000001ba6c7824ULL, 0x000fe400078e0a1bULL,
0x000000801f807217ULL, 0x000fe40003800000ULL, 0x0000001b7e00720cULL, 0x080fe40003f26070ULL,
0x0000001bba00720cULL, 0x000fc40003f06070ULL, 0x0000006c1f6c7217ULL, 0x000fe40003800000ULL,
0x00000004ff807819ULL, 0x000fe40000011680ULL, 0x000000ff6c7b7207ULL, 0x000fe40000000000ULL,
0x000000ff807d7207ULL, 0x000fe40000800000ULL, 0x0000007c7b6a7211ULL, 0x040fe400078fe0ffULL,
0x000000847b5a7211ULL, 0x002fe200078fe0ffULL, 0x000000017c6c7824ULL, 0x000fc400078e027dULL,
0x000000017d5e7824ULL, 0x000fe400078e0284ULL, 0x000060006a6a7625ULL, 0x000fc800078e006fULL,
0x000060006c6c7625ULL, 0x080fe200078e006fULL, 0x000000086abc7981ULL, 0x0002a6000c1e9500ULL,
0x000060005a5a7625ULL, 0x080fe200078e006fULL, 0x000000086c7f7981ULL, 0x0002a6000c1e9500ULL,
0x000060005e5e7625ULL, 0x000fe200078e006fULL, 0x000000085ad87981ULL, 0x0002a2000c1e9500ULL,
0x000000827b587211ULL, 0x000fc600078fe0ffULL, 0x000000085e837981ULL, 0x0002a2000c1e9500ULL,
0x000000017d5c7824ULL, 0x000fe400078e0282ULL, 0x0000600058587625ULL, 0x000fc800078e006fULL,
0x000060005c5c7625ULL, 0x080fe200078e006fULL, 0x0000000858d47981ULL, 0x0002a4000c1e9500ULL,
0x000000867b6a7211ULL, 0x002fe400078fe0ffULL, 0x000000085c817981ULL, 0x0002a2000c1e9500ULL,
0x000000017d6c7824ULL, 0x000fe400078e0286ULL, 0x000060006a6a7625ULL, 0x000fc800078e006fULL,
0x000060006c6c7625ULL, 0x000fe200078e006fULL, 0x000000086adc7981ULL, 0x0002a8000c1e9500ULL,
0x000000086c877981ULL, 0x0002a2000c1e9500ULL, 0xfffffff069587812ULL, 0x000fe200078ec0ffULL,
0x00000001ffd07424ULL, 0x000fc800078e00ffULL, 0x000000011b597824ULL, 0x000fc800078e0258ULL,
0x0000000152587824ULL, 0x000fe200078e0a59ULL, 0x00000001507c7812ULL, 0x000fc800078efcffULL,
0x00000058d0587219ULL, 0x000fe400000006ffULL, 0x000058007c5a7a10ULL, 0x000fe40007ffe0ffULL,
0xfffffff0755c7812ULL, 0x002fc600078ec0ffULL, 0x000000015a5b7824ULL, 0x100fe200078e0a59ULL,
0x00000008507e7812ULL, 0x040fe200078efcffULL, 0x000000011b5f7824ULL, 0x000fe200078e025cULL,
0x0000000950807812ULL, 0x000fe400078efcffULL, 0x0000005bd05c7219ULL, 0x000fe400000006ffULL,
0x000058007e5e7a10ULL, 0x000fe40007ffe0ffULL, 0x00005800806c7a10ULL, 0x000fe40007ffe0ffULL,
0xfffffff0796a7812ULL, 0x000fe200078ec0ffULL, 0x000000015e5d7824ULL, 0x100fe200078e0a59ULL,
0xfffffff07b827812ULL, 0x000fe200078ec0ffULL, 0x000000016c597824ULL, 0x000fe200078e0a59ULL,
0x0000001150867812ULL, 0x000fe200078efcffULL, 0x000000011b697824ULL, 0x040fe200078e026aULL,
0x0000005dd06a7219ULL, 0x040fe200000006ffULL, 0x000000011b757824ULL, 0x000fe200078e0282ULL,
0x00000059d0827219ULL, 0x000fc400000006ffULL, 0x00005800868a7a10ULL, 0x000fe40007ffe0ffULL,
0x0000541051517816ULL, 0x010fc80000000054ULL, 0x0000005158ff7212ULL, 0x000fc800078ac0ffULL,
0x0000001b5200720cULL, 0x000fc80002fa1470ULL, 0x0000001b5000720cULL, 0x000fe40002fa1070ULL,
0x000000515cff7212ULL, 0x000fe4000782c0ffULL, 0xff80000003037808ULL, 0x000fe40002800000ULL,
0x0000001b5a00720cULL, 0x000fe40000f21470ULL, 0x0000541053537816ULL, 0x000fc80000000060ULL,
0x0000005358ff7212ULL, 0x080fe4000784c0ffULL, 0x0000541055557816ULL, 0x000fe40000000062ULL,
0x000000535cff7212ULL, 0x000fe400078ac0ffULL, 0x0000005558ff7212ULL, 0x000fe4000788c0ffULL,
0x0000001b5200720cULL, 0x0c0fe40001741470ULL, 0x0000001b5200720cULL, 0x000fc40002781470ULL,
0x0000001b5a00720cULL, 0x080fe40002fa1470ULL, 0x0000001b5000720cULL, 0x0c0fe40001741070ULL,
0x0000001b5000720cULL, 0x080fe40002781070ULL, 0x0000001b7c00720cULL, 0x0c0fe40000f21070ULL,
0x0000001b7c00720cULL, 0x000fe40002fa1070ULL, 0x0000541056577816ULL, 0x000fc40000000057ULL,
0xff8000000e0e7808ULL, 0x000fe40001000000ULL, 0xff80000031317808ULL, 0x000fe40002000000ULL,
0xff80000002027808ULL, 0x000fe40000800000ULL, 0xff80000017177808ULL, 0x000fe40002800000ULL,
0x000000516aff7212ULL, 0x000fe4000786c0ffULL, 0x0000005758ff7212ULL, 0x000fc4000780c0ffULL,
0x000000555cff7212ULL, 0x040fe4000784c0ffULL, 0x000000575cff7212ULL, 0x000fe4000788c0ffULL,
0x0000005382ff7212ULL, 0x000fe4000782c0ffULL, 0x000000556aff7212ULL, 0x000fe200078ac0ffULL,
0x0000000166597824ULL, 0x100fe200078e0a5fULL, 0x0000001b5200720cULL, 0x080fe20000701470ULL,
0x000000018a5b7824ULL, 0x000fe200078e0a5fULL, 0x0000001b5a00720cULL, 0x000fc40001741470ULL,
0x0000001b5a00720cULL, 0x080fe40002781470ULL, 0x0000001b5e00720cULL, 0x0c0fe40001f61470ULL,
0x0000001b5e00720cULL, 0x080fe40002fa1470ULL, 0x0000001b6c00720cULL, 0x000fe40000f21470ULL,
0x00000018508e7812ULL, 0x040fe400078efcffULL, 0x0000001950967812ULL, 0x000fc400078efcffULL,
0x0000001b5000720cULL, 0x080fe40000701070ULL, 0x0000001b7c00720cULL, 0x0c0fe40001741070ULL,
0x0000001b7c00720cULL, 0x080fe40002781070ULL, 0x0000001b7e00720cULL, 0x0c0fe40001f61070ULL,
0x0000001b7e00720cULL, 0x080fe40002fa1070ULL, 0x0000001b8000720cULL, 0x000fc40000f21070ULL,
0x00000059d0847219ULL, 0x040fe400000006ffULL, 0x0000005bd08c7219ULL, 0x000fe400000006ffULL,
0x0000541061617816ULL, 0x008fe40000000068ULL, 0x0000541063637816ULL, 0x000fe4000000006eULL,
0x000058008e907a10ULL, 0x000fe40007ffe0ffULL, 0x0000580096987a10ULL, 0x000fc40007ffe0ffULL,
0xff80000044447808ULL, 0x000fe40000000000ULL, 0xff80000030307808ULL, 0x000fe40001000000ULL,
0xff80000048487808ULL, 0x000fe40002000000ULL, 0xff80000008087808ULL, 0x000fe40001800000ULL,
0xff80000032327808ULL, 0x000fe40002800000ULL, 0xff8000001a1a7808ULL, 0x000fc40000800000ULL,
0x000000536aff7212ULL, 0x000fe4000780c0ffULL, 0x0000005582ff7212ULL, 0x000fe4000784c0ffULL,
0x000000576aff7212ULL, 0x080fe4000788c0ffULL, 0x0000005782ff7212ULL, 0x000fe4000786c0ffULL,
0x000000618cff7212ULL, 0x000fe400078ac0ffULL, 0x0000006384ff7212ULL, 0x000fc4000782c0ffULL,
0x000000905f5d7210ULL, 0x000fe20007ffe1ffULL, 0x00000001985f7824ULL, 0x000fe200078e0a5fULL,
0x0000001b5e00720cULL, 0x0c0fe40000701470ULL, 0x0000001b5e00720cULL, 0x080fe40002781470ULL,
0x0000001b6c00720cULL, 0x0c0fe40001741470ULL, 0x0000001b6c00720cULL, 0x080fe40001f61470ULL,
0x0000001b6600720cULL, 0x000fc40000f21470ULL, 0x0000001b8a00720cULL, 0x080fe40002fa1470ULL,
0x0000001b7e00720cULL, 0x0c0fe40000701070ULL, 0x0000001b7e00720cULL, 0x080fe40002781070ULL,
0x0000001b8000720cULL, 0x0c0fe40001741070ULL, 0x0000001b8000720cULL, 0x080fe40001f61070ULL,
0x0000001b6400720cULL, 0x000fc40000f21070ULL, 0x0000001b8600720cULL, 0x000fe40002fa1070ULL,
0x0000005dd0927219ULL, 0x040fe400000006ffULL, 0x0000005fd0a27219ULL, 0x000fe400000006ffULL,
0x0000541065657816ULL, 0x000fe40000000070ULL, 0x0000541067677816ULL, 0x000fe40000000076ULL,
0xff80000018187808ULL, 0x000fc40000000000ULL, 0xff80000049497808ULL, 0x000fe40002000000ULL,
0xff80000033337808ULL, 0x000fe40001000000ULL, 0xff8000004b4b7808ULL, 0x000fe40001800000ULL,
0xff80000024247808ULL, 0x000fe40000800000ULL, 0xff8000000b0b7808ULL, 0x000fe40002800000ULL,
0x0000006184ff7212ULL, 0x000fc4000780c0ffULL, 0x0000006192ff7212ULL, 0x000fe4000788c0ffULL,
0x0000006584ff7212ULL, 0x040fe4000784c0ffULL, 0x0000006784ff7212ULL, 0x000fe4000786c0ffULL,
0x000000658cff7212ULL, 0x000fe4000782c0ffULL, 0x00000063a2ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001746b7824ULL, 0x000fe200078e0a69ULL, 0x0000001b6600720cULL, 0x000fc40000701470ULL,
0x0000001b6600720cULL, 0x0c0fe40001741470ULL, 0x0000001b6600720cULL, 0x080fe40001f61470ULL,
0x0000001b8a00720cULL, 0x080fe40000f21470ULL, 0x0000001b9000720cULL, 0x080fe40002781470ULL,
0x0000001b9800720cULL, 0x000fe40002fa1470ULL, 0x0000002150a67812ULL, 0x000fc400078efcffULL,
0x0000001b6400720cULL, 0x0c0fe40000701070ULL, 0x0000001b6400720cULL, 0x0c0fe40001741070ULL,
0x0000001b6400720cULL, 0x080fe40001f61070ULL, 0x0000001b8600720cULL, 0x080fe40000f21070ULL,
0x0000001b8e00720cULL, 0x080fe40002781070ULL, 0x0000001b9600720cULL, 0x000fc40002fa1070ULL,
0x0000006bd0a47219ULL, 0x000fe400000006ffULL, 0x0000541073737816ULL, 0x004fe400000000d2ULL,
0x00005800a6a87a10ULL, 0x000fe40007ffe0ffULL, 0xff8000000a0a7808ULL, 0x000fe40000000000ULL,
0xff80000034347808ULL, 0x000fe40001000000ULL, 0xff8000004d4d7808ULL, 0x000fc40001800000ULL,
0xff80000035357808ULL, 0x000fe40000800000ULL, 0xff8000000c0c7808ULL, 0x000fe40002000000ULL,
0xff80000027277808ULL, 0x000fe40002800000ULL, 0x000000638cff7212ULL, 0x040fe4000780c0ffULL,
0x000000678cff7212ULL, 0x000fe4000784c0ffULL, 0x0000006392ff7212ULL, 0x000fc4000786c0ffULL,
0x00000065a2ff7212ULL, 0x040fe4000782c0ffULL, 0x00000067a2ff7212ULL, 0x000fe4000788c0ffULL,
0x00000073a4ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001a86d7824ULL, 0x000fe200078e0a69ULL,
0x0000001b8a00720cULL, 0x0c0fe40000701470ULL, 0x0000001b8a00720cULL, 0x080fe40001741470ULL,
0x0000001b9000720cULL, 0x000fc40001f61470ULL, 0x0000001b9800720cULL, 0x0c0fe40000f21470ULL,
0x0000001b9800720cULL, 0x080fe40002781470ULL, 0x0000001b7400720cULL, 0x080fe40002fa1470ULL,
0x0000002850ac7812ULL, 0x040fe400078efcffULL, 0x0000002950b27812ULL, 0x000fe400078efcffULL,
0x0000001b8600720cULL, 0x000fc40000701070ULL, 0x0000001b8600720cULL, 0x080fe40001741070ULL,
0x0000001b8e00720cULL, 0x080fe40001f61070ULL, 0x0000001b9600720cULL, 0x0c0fe40000f21070ULL,
0x0000001b9600720cULL, 0x080fe40002781070ULL, 0x0000001b7200720cULL, 0x000fe40002fa1070ULL,
0x0000006dd0aa7219ULL, 0x000fc400000006ffULL, 0x0000541071717816ULL, 0x000fe4000000007aULL,
0x0000541077777816ULL, 0x000fe400000000d6ULL, 0x00005410da857816ULL, 0x000fe40000000085ULL,
0x00005800acae7a10ULL, 0x000fe40007ffe0ffULL, 0x00005800b2b47a10ULL, 0x000fe40007ffe0ffULL,
0xff80000025257808ULL, 0x000fc40000000000ULL, 0xff8000004e4e7808ULL, 0x000fe40001000000ULL,
0xff80000026267808ULL, 0x000fe40001800000ULL, 0xff80000037377808ULL, 0x000fe40000800000ULL,
0xff8000004c4c7808ULL, 0x000fe40002000000ULL, 0xff80000028287808ULL, 0x000fe40002800000ULL,
0x0000005182ff7212ULL, 0x000fc400078cc0ffULL, 0x0000006592ff7212ULL, 0x040fe4000780c0ffULL,
0x0000006792ff7212ULL, 0x000fe4000784c0ffULL, 0x00000071a4ff7212ULL, 0x040fe4000786c0ffULL,
0x00000077a4ff7212ULL, 0x040fe4000782c0ffULL, 0x00000085a4ff7212ULL, 0x000fe4000788c0ffULL,
0x00000077aaff7212ULL, 0x000fe200078ac0ffULL, 0x00000001ae6f7824ULL, 0x100fe200078e0a69ULL,
0x0000001b6c00720cULL, 0x080fe200037c1470ULL, 0x00000001b4697824ULL, 0x000fe200078e0a69ULL,
0x0000001b9000720cULL, 0x000fc40000701470ULL, 0x0000001b9000720cULL, 0x080fe40001741470ULL,
0x0000001b7400720cULL, 0x0c0fe40001f61470ULL, 0x0000001b7400720cULL, 0x0c0fe40000f21470ULL,
0x0000001b7400720cULL, 0x080fe40002781470ULL, 0x0000001ba800720cULL, 0x080fe40002fa1470ULL,
0x0000001b8000720cULL, 0x000fc400037c1070ULL, 0x0000001b8e00720cULL, 0x0c0fe40000701070ULL,
0x0000001b8e00720cULL, 0x080fe40001741070ULL, 0x0000001b7200720cULL, 0x0c0fe40001f61070ULL,
0x0000001b7200720cULL, 0x0c0fe40000f21070ULL, 0x0000001b7200720cULL, 0x080fe40002781070ULL,
0x0000001ba600720cULL, 0x000fc40002fa1070ULL, 0x0000006fd0b07219ULL, 0x040fe400000006ffULL,
0x00000069d0b67219ULL, 0x000fe400000006ffULL, 0xff80000009097808ULL, 0x000fe40003000000ULL,
0xff80000036367808ULL, 0x000fe40000000000ULL, 0xff8000004f4f7808ULL, 0x000fe40001000000ULL,
0xff8000000f0f7808ULL, 0x000fc40001800000ULL, 0xff80000038387808ULL, 0x000fe40000800000ULL,
0xff8000004a4a7808ULL, 0x000fe40002000000ULL, 0xff80000039397808ULL, 0x000fe40002800000ULL,
0x00000061a2ff7212ULL, 0x000fe400078cc0ffULL, 0x00000071aaff7212ULL, 0x080fe4000780c0ffULL,
0x00000071b0ff7212ULL, 0x000fc4000784c0ffULL, 0x00000073aaff7212ULL, 0x040fe4000786c0ffULL,
0x00000085aaff7212ULL, 0x000fe4000782c0ffULL, 0x00000073b0ff7212ULL, 0x000fe4000788c0ffULL,
0x00000077b6ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001ba797824ULL, 0x000fe200078e0a75ULL,
0x0000001b9800720cULL, 0x080fe400037c1470ULL, 0x0000001ba800720cULL, 0x000fc40000701470ULL,
0x0000001ba800720cULL, 0x0c0fe40001f61470ULL, 0x0000001ba800720cULL, 0x080fe40000f21470ULL,
0x0000001bae00720cULL, 0x0c0fe40001741470ULL, 0x0000001bae00720cULL, 0x080fe40002781470ULL,
0x0000001bb400720cULL, 0x000fe40002fa1470ULL, 0x0000003150c07812ULL, 0x000fc400078efcffULL,
0x0000003850c67812ULL, 0x040fe400078efcffULL, 0x0000003950cc7812ULL, 0x000fe400078efcffULL,
0x0000001b9600720cULL, 0x080fe400037c1070ULL, 0x0000001ba600720cULL, 0x0c0fe40000701070ULL,
0x0000001ba600720cULL, 0x0c0fe40001f61070ULL, 0x0000001ba600720cULL, 0x000fc40000f21070ULL,
0x0000001bac00720cULL, 0x0c0fe40001741070ULL, 0x0000001bac00720cULL, 0x080fe40002781070ULL,
0x0000001bb200720cULL, 0x000fe40002fa1070ULL, 0x00000079d0be7219ULL, 0x000fe400000006ffULL,
0x00005410bc7f7816ULL, 0x000fe4000000007fULL, 0x00005410d8837816ULL, 0x000fc40000000083ULL,
0x00005800c0c27a10ULL, 0x000fe40007ffe0ffULL, 0x00005800c6c87a10ULL, 0x000fe40007ffe0ffULL,
0x00005800ccce7a10ULL, 0x000fe40007ffe0ffULL, 0xff8000000d0d7808ULL, 0x000fe40003000000ULL,
0xff80000013137808ULL, 0x000fe40000000000ULL, 0xff80000029297808ULL, 0x000fc40001800000ULL,
0xff8000003b3b7808ULL, 0x000fe40000800000ULL, 0xff80000016167808ULL, 0x000fe40001000000ULL,
0xff8000002a2a7808ULL, 0x000fe40002000000ULL, 0xff8000003c3c7808ULL, 0x000fe40002800000ULL,
0x00000071b6ff7212ULL, 0x040fe400078cc0ffULL, 0x00000073b6ff7212ULL, 0x000fc4000780c0ffULL,
0x00000077b0ff7212ULL, 0x040fe4000786c0ffULL, 0x00000085b0ff7212ULL, 0x080fe4000782c0ffULL,
0x00000085b6ff7212ULL, 0x000fe4000784c0ffULL, 0x0000007fbeff7212ULL, 0x040fe4000788c0ffULL,
0x00000083beff7212ULL, 0x000fe200078ac0ffULL, 0x00000001c27b7824ULL, 0x100fe200078e0a75ULL,
0x0000001bae00720cULL, 0x080fe20001f61470ULL, 0x00000001c87d7824ULL, 0x100fe200078e0a75ULL,
0x0000001bae00720cULL, 0x080fe20000f21470ULL, 0x00000001ce757824ULL, 0x000fe200078e0a75ULL,
0x0000001bb400720cULL, 0x000fc400037c1470ULL, 0x0000001bb400720cULL, 0x0c0fe40000701470ULL,
0x0000001bb400720cULL, 0x080fe40001741470ULL, 0x0000001bba00720cULL, 0x0c0fe40002781470ULL,
0x0000001bba00720cULL, 0x000fe40002fa1470ULL, 0x0000007bd0c47219ULL, 0x040fe400000006ffULL,
0x0000007dd0ca7219ULL, 0x000fc400000006ffULL, 0x0000001bac00720cULL, 0x0c0fe40001f61070ULL,
0x0000001bac00720cULL, 0x080fe40000f21070ULL, 0x0000001bb200720cULL, 0x0c0fe400037c1070ULL,
0x0000001bb200720cULL, 0x0c0fe40000701070ULL, 0x0000001bb200720cULL, 0x080fe40001741070ULL,
0x0000001bb800720cULL, 0x000fc40002781070ULL, 0x0000001bb800720cULL, 0x000fe40002fa1070ULL,
0x00000075d0d07219ULL, 0x000fe400000006ffULL, 0x00005410d4817816ULL, 0x000fe40000000081ULL,
0xff8000003a3a7808ULL, 0x000fe40001800000ULL, 0xff8000003d3d7808ULL, 0x000fe40000800000ULL,
0xff80000014147808ULL, 0x000fc40003000000ULL, 0xff8000002b2b7808ULL, 0x000fe40000000000ULL,
0xff8000003e3e7808ULL, 0x000fe40001000000ULL, 0xff80000015157808ULL, 0x000fe40002000000ULL,
0xff8000003f3f7808ULL, 0x000fe40002800000ULL, 0x0000007fc4ff7212ULL, 0x080fe4000786c0ffULL,
0x0000007fcaff7212ULL, 0x000fc4000782c0ffULL, 0x0000007fd0ff7212ULL, 0x000fe400078cc0ffULL,
0x00000081beff7212ULL, 0x080fe4000780c0ffULL, 0x00000081c4ff7212ULL, 0x080fe4000784c0ffULL,
0x00000081caff7212ULL, 0x000fe4000788c0ffULL, 0x00000083c4ff7212ULL, 0x000fe400078ac0ffULL,
0x0000001bba00720cULL, 0x000fc40000701470ULL, 0x0000001bc200720cULL, 0x0c0fe40001f61470ULL,
0x0000001bc200720cULL, 0x0c0fe40001741470ULL, 0x0000001bc200720cULL, 0x080fe40002fa1470ULL,
0x0000001bc800720cULL, 0x080fe40000f21470ULL, 0x0000001bce00720cULL, 0x080fe400037c1470ULL,
0x0000001bc800720cULL, 0x000fc40002781470ULL, 0x0000001bb800720cULL, 0x080fe40000701070ULL,
0x0000001bc000720cULL, 0x0c0fe40001f61070ULL, 0x0000001bc000720cULL, 0x0c0fe40001741070ULL,
0x0000001bc000720cULL, 0x080fe40002fa1070ULL, 0x0000001bc600720cULL, 0x080fe40000f21070ULL,
0x0000001bcc00720cULL, 0x000fc400037c1070ULL, 0x0000001bc600720cULL, 0x000fe40002781070ULL,
0x00005410dc877816ULL, 0x000fe40000000087ULL, 0xff8000002c2c7808ULL, 0x000fe40000000000ULL,
0xff80000011117808ULL, 0x000fe40001800000ULL, 0xff8000002d2d7808ULL, 0x000fe40001000000ULL,
0xff80000040407808ULL, 0x000fc40002800000ULL, 0xff80000012127808ULL, 0x000fe40000800000ULL,
0xff80000010107808ULL, 0x000fe40003000000ULL, 0xff8000002e2e7808ULL, 0x000fe40002000000ULL,
0x00000081d0ff7212ULL, 0x000fe4000780c0ffULL, 0x00000083caff7212ULL, 0x080fe4000786c0ffULL,
0x00000083d0ff7212ULL, 0x000fc4000784c0ffULL, 0x00000087beff7212ULL, 0x080fe400078ac0ffULL,
0x00000087c4ff7212ULL, 0x080fe4000782c0ffULL, 0x00000087caff7212ULL, 0x080fe400078cc0ffULL,
0x00000087d0ff7212ULL, 0x000fe4000788c0ffULL, 0x0000001bba00720cULL, 0x080fe40002fa1470ULL,
0x0000001bc200720cULL, 0x000fc40000f21470ULL, 0x0000001bc800720cULL, 0x0c0fe40001f61470ULL,
0x0000001bc800720cULL, 0x080fe400037c1470ULL, 0x0000001bce00720cULL, 0x0c0fe40000701470ULL,
0x0000001bce00720cULL, 0x0c0fe40001741470ULL, 0x0000001bce00720cULL, 0x080fe40002781470ULL,
0x0000001bb800720cULL, 0x000fc40002fa1070ULL, 0x0000001bc000720cULL, 0x080fe40000f21070ULL,
0x0000001bcc00720cULL, 0x080fe40000701070ULL, 0x0000001bc600720cULL, 0x0c0fe40001f61070ULL,
0x0000001bc600720cULL, 0x080fe400037c1070ULL, 0x0000001bcc00720cULL, 0x0c0fe40001741070ULL,
0x0000001bcc00720cULL, 0x000fc40002781070ULL, 0xff8000002f2f7808ULL, 0x000fe40000000000ULL,
0xff80000042427808ULL, 0x000fe40001800000ULL, 0xff80000045457808ULL, 0x000fe40001000000ULL,
0xff80000041417808ULL, 0x000fe40002800000ULL, 0xff80000043437808ULL, 0x000fe40000800000ULL,
0xff80000046467808ULL, 0x000fc40003000000ULL, 0xff80000047477808ULL, 0x000fc40002000000ULL,
0x000000030400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff567424ULL, 0x000fe200078e00ffULL,
0x0000000e0500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff5b7424ULL, 0x000fe200078e00ffULL,
0x000000310600720bULL, 0x000fe40003f5e000ULL, 0x000000440700720bULL, 0x000fe40003f7e000ULL,
0x00000004031b7208ULL, 0x000fe40004000000ULL, 0x000000050e047208ULL, 0x000fc40004800000ULL,
0x0000000631057208ULL, 0x000fe40005000000ULL, 0x0000000744077208ULL, 0x000fe40005800000ULL,
0x000000021b00720bULL, 0x000fe40003f1e000ULL, 0x000000170400720bULL, 0x000fe40003f3e000ULL,
0x000000300500720bULL, 0x000fe40003f5e000ULL, 0x000000480700720bULL, 0x000fc40003f7e000ULL,
0x0000001b021b7208ULL, 0x000fe40004000000ULL, 0x0000000417517208ULL, 0x000fe40004800000ULL,
0x0000000530057208ULL, 0x000fe40005000000ULL, 0x0000000748047208ULL, 0x000fe40005800000ULL,
0x000000081b00720bULL, 0x000fe40003f1e000ULL, 0x000000185100720bULL, 0x000fc40003f3e000ULL,
0x000000320500720bULL, 0x000fe40003f5e000ULL, 0x000000490400720bULL, 0x000fe40003f7e000ULL,
0x0000001b08067208ULL, 0x000fe40004000000ULL, 0x0000005118517208ULL, 0x000fe40004800000ULL,
0x0000000532507208ULL, 0x000fe40005000000ULL, 0x0000000449047208ULL, 0x000fc40005800000ULL,
0x000000090600720bULL, 0x000fe40003f1e000ULL, 0x0000001a5100720bULL, 0x000fe40003f3e000ULL,
0x000000335000720bULL, 0x000fe40003f5e000ULL, 0x0000004b0400720bULL, 0x000fe40003f7e000ULL,
0x0000000609057208ULL, 0x000fe40004000000ULL, 0x000000511a517208ULL, 0x000fc40004800000ULL,
0x0000005033077208ULL, 0x000fe40005000000ULL, 0x000000044b047208ULL, 0x000fe40005800000ULL,
0x0000000a0500720bULL, 0x000fe40003f1e000ULL, 0x000000245100720bULL, 0x000fe40003f3e000ULL,
0x000000340700720bULL, 0x000fe40003f5e000ULL, 0x0000004d0400720bULL, 0x000fc40003f7e000ULL,
0x000000050a067208ULL, 0x000fe40004000000ULL, 0x0000005124507208ULL, 0x000fe40004800000ULL,
0x0000000734527208ULL, 0x000fe40005000000ULL, 0x000000044d057208ULL, 0x000fe40005800000ULL,
0x0000000b0600720bULL, 0x000fe40003f1e000ULL, 0x000000255000720bULL, 0x000fc40003f3e000ULL,
0x000000355200720bULL, 0x000fe40003f5e000ULL, 0x0000004e0500720bULL, 0x000fe40003f7e000ULL,
0x000000060b077208ULL, 0x000fe40004000000ULL, 0x00000050251b7208ULL, 0x000fe40004800000ULL,
0x0000005235517208ULL, 0x000fe40005000000ULL, 0x000000054e047208ULL, 0x000fc40005800000ULL,
0x0000000c0700720bULL, 0x000fe40003f1e000ULL, 0x000000261b00720bULL, 0x000fe40003f3e000ULL,
0x000000365100720bULL, 0x000fe40003f5e000ULL, 0x0000004f0400720bULL, 0x000fe40003f7e000ULL,
0x000000070c067208ULL, 0x000fe40004000000ULL, 0x0000001b26507208ULL, 0x000fc40004800000ULL,
0x0000005136527208ULL, 0x000fe40005000000ULL, 0x000000044f057208ULL, 0x000fe40005800000ULL,
0x0000000d0600720bULL, 0x000fe40003f1e000ULL, 0x000000275000720bULL, 0x000fe40003f3e000ULL,
0x000000375200720bULL, 0x000fe40003f5e000ULL, 0x0000004c0500720bULL, 0x000fc40003f7e000ULL,
0x000000060d067208ULL, 0x000fe40004000000ULL, 0x0000005027077208ULL, 0x000fe40004800000ULL,
0x00000052371b7208ULL, 0x000fe40005000000ULL, 0x000000054c057208ULL, 0x000fe40005800000ULL,
0x0000000f0600720bULL, 0x000fe40003f1e000ULL, 0x000000280700720bULL, 0x000fc40003f3e000ULL,
0x000000381b00720bULL, 0x000fe40003f5e000ULL, 0x0000004a0500720bULL, 0x000fe40003f7e000ULL,
0x000000060f067208ULL, 0x000fe40004000000ULL, 0x0000000728047208ULL, 0x000fe40004800000ULL,
0x0000001b38507208ULL, 0x000fe40005000000ULL, 0x000000054a527208ULL, 0x000fc40005800000ULL,
0x000000130600720bULL, 0x000fe40003f1e000ULL, 0x000000290400720bULL, 0x000fe40003f3e000ULL,
0x000000395000720bULL, 0x000fe40003f5e000ULL, 0x0000003b5200720bULL, 0x000fe40003f7e000ULL,
0x0000000613057208ULL, 0x000fe40004000000ULL, 0x0000000429077208ULL, 0x000fc40004800000ULL,
0x00000050391b7208ULL, 0x000fe40005000000ULL, 0x000000523b527208ULL, 0x000fe40005800000ULL,
0x000000160500720bULL, 0x000fe40003f1e000ULL, 0x0000002a0700720bULL, 0x000fe40003f3e000ULL,
0x0000003a1b00720bULL, 0x000fe40003f5e000ULL, 0x0000003d5200720bULL, 0x000fc40003f7e000ULL,
0x0000000516057208ULL, 0x000fe40004000000ULL, 0x000000072a047208ULL, 0x000fe40004800000ULL,
0x0000001b3a1b7208ULL, 0x000fe40005000000ULL, 0x000000523d077208ULL, 0x000fe40005800000ULL,
0x000000140500720bULL, 0x000fe40003f1e000ULL, 0x0000002b0400720bULL, 0x000fc40003f3e000ULL,
0x0000003c1b00720bULL, 0x000fe40003f5e000ULL, 0x0000003e0700720bULL, 0x000fe40003f7e000ULL,
0x0000000514067208ULL, 0x000fe40004000000ULL, 0x000000042b057208ULL, 0x000fe40004800000ULL,
0x0000001b3c047208ULL, 0x000fe40005000000ULL, 0x000000073e507208ULL, 0x000fc40005800000ULL,
0x0000002c0500720bULL, 0x000fe40003f3e000ULL, 0x000000150600720bULL, 0x000fe40003f1e000ULL,
0x0000003f0400720bULL, 0x000fe40003f5e000ULL, 0x000000415000720bULL, 0x000fe40003f7e000ULL,
0x000000052c527208ULL, 0x000fe40004800000ULL, 0x0000000615067208ULL, 0x000fc40004000000ULL,
0x000000043f057208ULL, 0x000fe40005000000ULL, 0x0000005041507208ULL, 0x000fe40005800000ULL,
0x000000110600720bULL, 0x000fe40003f1e000ULL, 0x0000002d5200720bULL, 0x000fe40003f3e000ULL,
0x000000400500720bULL, 0x000fe40003f5e000ULL, 0x000000435000720bULL, 0x000fc40003f7e000ULL,
0x0000000611077208ULL, 0x000fe40004000000ULL, 0x000000522d1b7208ULL, 0x000fe40004800000ULL,
0x0000000540057208ULL, 0x000fe40005000000ULL, 0x0000005043517208ULL, 0x000fe40005800000ULL,
0x000000120700720bULL, 0x000fe40003f1e000ULL, 0x0000002e1b00720bULL, 0x000fc40003f3e000ULL,
0x000000420500720bULL, 0x000fe40003f5e000ULL, 0x000000465100720bULL, 0x000fe40003f7e000ULL,
0x0000000712077208ULL, 0x000fe40004000000ULL, 0x0000001b2e047208ULL, 0x000fe40004800000ULL,
0x0000000542067208ULL, 0x000fe40005000000ULL, 0x0000005146507208ULL, 0x000fc40005800000ULL,
0x000000100700720bULL, 0x000fe40003f1e000ULL, 0x0000002f0400720bULL, 0x000fe40003f3e000ULL,
0x000000450600720bULL, 0x000fe40003f5e000ULL, 0x000000475000720bULL, 0x000fe40003f7e000ULL,
0x0000000710077208ULL, 0x000fe40004000000ULL, 0x000000042f537208ULL, 0x000fc40004800000ULL,
0x0000000645547208ULL, 0x000fe40005000000ULL, 0x0000005047557208ULL, 0x000fe20005800000ULL,
0x00001ff27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0007047f89ULL, 0x0004e400000e0000ULL,
0x000000040700720bULL, 0x008fc80003f1e000ULL, 0x0000000704597208ULL, 0x000fe20004000000ULL,
0x000020027f007947ULL, 0x000fea000b800000ULL, 0x0c401f0053047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0054057f89ULL, 0x000f2800000e0000ULL, 0x0c401f0055067f89ULL, 0x000e6200000e0000ULL,
0x000000045300720bULL, 0x008fc40003f1e000ULL, 0x000000055400720bULL, 0x010fe40003f3e000ULL,
0x0000005304077208ULL, 0x006fe40004000000ULL, 0x00000054051b7208ULL, 0x000fe20004800000ULL,
0x0c201f0059047f89ULL, 0x000e6200000e0000ULL, 0x000000065500720bULL, 0x000fc60003f1e000ULL,
0x0c201f0007507f89ULL, 0x000ea200000e0000ULL, 0x0000005506577208ULL, 0x000fc60004000000ULL,
0x0c201f001b527f89ULL, 0x000ee800000e0000ULL, 0x0c201f0057587f89ULL, 0x0002e400000e0000ULL,
0x000000045900720bULL, 0x002fe40003f1e000ULL, 0x000000500700720bULL, 0x004fe40003f3e000ULL,
0x0000005904047208ULL, 0x000fc40004000000ULL, 0x000000521b00720bULL, 0x008fe40003f5e000ULL,
0x0000000750057208ULL, 0x000fe40004800000ULL, 0x0000001b52067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL, 0x000000585700720bULL, 0x004fe20003f1e000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x3fb8aa3b03037823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b02027823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b08087823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b09097823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0a0a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0b0b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0c0c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b0f1b7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b13527823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b16517823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b14547823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b15557823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b11567823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b12507823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b10537823ULL, 0x000fe20000010807ULL, 0x3fb8aa3b05077820ULL, 0x000fe20000410000ULL,
0x0000000300037308ULL, 0x000fe60000000800ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b17177823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b27277823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b29297823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2f077823ULL, 0x000fe20000010807ULL, 0x0000002c00657308ULL, 0x0003f00000000800ULL,
0x0000000700687308ULL, 0x0005e20000000800ULL, 0x00000002ff2c7819ULL, 0x002fca0000011620ULL,
0x000000082c6b7824ULL, 0x000fe400078e00ffULL, 0x0000000200027308ULL, 0x000fe20000000800ULL,
0x0000005758077208ULL, 0x004fe20004000000ULL, 0x000000082c577824ULL, 0x000fe200078e00ffULL,
0x0000000320ff7812ULL, 0x000fe2000780c0ffULL, 0x000000082c117824ULL, 0x040fe400078e00ffULL,
0x3fb8aa3b07147820ULL, 0x000fe20000410000ULL, 0x000000082c107824ULL, 0x040fe200078e00ffULL,
0x00000009005a7308ULL, 0x000fe20000000800ULL, 0x000000082c6f7824ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b44447823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b49497823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b48487823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010814ULL,
0x0000000b005c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b41417823ULL, 0x100fe20000010814ULL,
0x0000000c005d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b47477823ULL, 0x000fca0000010814ULL,
0x0000000800597308ULL, 0x0003f00000000800ULL, 0x0000000d005e7308ULL, 0x0005e20000000800ULL,
0x000000012c087810ULL, 0x002fc80007ffe0ffULL, 0xfffffff857577812ULL, 0x000fe400078ee208ULL,
0x000000042c087810ULL, 0x000fe20007ffe0ffULL, 0x0000000e00097308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b060d7820ULL, 0x004fc80000410000ULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001080dULL,
0x00000017000c7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b34347823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b36367823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b37377823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b38387823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b39397823ULL, 0x100fe2000001080dULL,
0x00000018000b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b40407823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b42427823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b450d7823ULL, 0x000fc4000001080dULL, 0x0000001a001a7308ULL, 0x000ea20000000800ULL,
0x000000090c09723eULL, 0x002fe400000000ffULL, 0xffffffff2c0c7810ULL, 0x000fca0007ffe0ffULL,
0x0000000a005b7308ULL, 0x0002f00000000800ULL, 0x0000000d00457308ULL, 0x0009e20000000800ULL,
0x000000022c0a7810ULL, 0x002fe40007ffe0ffULL, 0x0000000b1a0b723eULL, 0x004fc400000000ffULL,
0xfffffff86b6b7812ULL, 0x000fe400078ee20aULL, 0x000000052c0a7810ULL, 0x040fe20007ffe0ffULL,
0x0000004400447308ULL, 0x000fe20000000800ULL, 0x000000032c0d7810ULL, 0x010fe40007ffe0ffULL,
0xfffffff86f6f7812ULL, 0x000fe400078ee20aULL, 0xfffffff8106d7812ULL, 0x000fe400078ee20dULL,
0x000000062c0d7810ULL, 0x000fe20007ffe0ffULL, 0x00000048000f7308ULL, 0x000fe20000000800ULL,
0x000000595a0a723eULL, 0x000fc400000000ffULL, 0xfffffff810717812ULL, 0x000fe200078ee20dULL,
0x000000082c0d7824ULL, 0x000fe200078e00ffULL, 0x0000005b5c14723eULL, 0x008fe400000000ffULL,
0x000000082c1a7810ULL, 0x000fe20007ffe0ffULL, 0x0000002900617308ULL, 0x000fe80000000800ULL,
0x000000081a597824ULL, 0x000fc800078e00ffULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0xfffffff859597812ULL, 0x000fce00078ee21aULL, 0x0000003000307308ULL, 0x000ff00000000800ULL,
0x00000032000e7308ULL, 0x000ff00000000800ULL, 0x0000003300337308ULL, 0x000e700000000800ULL,
0x0000004900497308ULL, 0x000ff00000000800ULL, 0x0000004b00167308ULL, 0x0005e20000000800ULL,
0x0000000e330e723eULL, 0x002fce00000000ffULL, 0x0000004d00297308ULL, 0x0003e20000000800ULL,
0x0000000c194b7812ULL, 0x004fce00078ec0ffULL, 0x0000002400157308ULL, 0x000fe20000000800ULL,
0xfffffff8114d7812ULL, 0x002fe400078ee208ULL, 0x000000030208723eULL, 0x000fe200000000ffULL,
0x3c003c00ff027424ULL, 0x000fe400078e00ffULL, 0x3c003c00ff037424ULL, 0x000fe400078e00ffULL,
0x0000002500607308ULL, 0x000e6a0000000800ULL, 0x000000020810723cULL, 0x000f6600000018ffULL,
0x00000026005f7308ULL, 0x000ff00000000800ULL, 0x0000002700627308ULL, 0x000ea20000000800ULL,
0x000000156015723eULL, 0x002fce00000000ffULL, 0x0000002b00647308ULL, 0x000ff00000000800ULL,
0x0000004f002b7308ULL, 0x0003e20000000800ULL, 0x0000005f6217723eULL, 0x004fce00000000ffULL,
0x0000002800187308ULL, 0x000fe20000000800ULL, 0xfffffff80d4f7812ULL, 0x002fe400078ee20cULL,
0x000000440f0d723eULL, 0x000fe400000000ffULL, 0x00000031300c723eULL, 0x000fe400000000ffULL,
0x00000049160f723eULL, 0x000fe200000000ffULL, 0x0000002a00637308ULL, 0x000e620000000800ULL,
0x0000005d5e16723eULL, 0x000fe400000000ffULL, 0x000000032c497819ULL, 0x000fc600000006ffULL,
0x000000020c24723cULL, 0x080f6200000018ffULL, 0xfffffff849497812ULL, 0x000fe200078ee22cULL,
0x0000003400287308ULL, 0x000fec0000000800ULL, 0x000000021410723cULL, 0x020f640000001810ULL,
0x0000003500357308ULL, 0x000ea20000000800ULL, 0x00000063642f723eULL, 0x002fce00000000ffULL,
0x00000036002a7308ULL, 0x000ff00000000800ULL, 0x0000003700377308ULL, 0x000e620000000800ULL,
0x000000283528723eULL, 0x004fce00000000ffULL, 0x0000004e004e7308ULL, 0x000eb00000000800ULL,
0x0000004c004c7308ULL, 0x000ee20000000800ULL, 0x0000002a372a723eULL, 0x002fce00000000ffULL,
0x0000001b001b7308ULL, 0x000fe20000000800ULL, 0x000000294e29723eULL, 0x004fce00000000ffULL,
0x0000005200527308ULL, 0x000fe20000000800ULL, 0x0000002b4c2b723eULL, 0x008fce00000000ffULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x000000022824723cULL, 0x000f6e0000001824ULL,
0x0000005400547308ULL, 0x000ff00000000800ULL, 0x0000002d00667308ULL, 0x0002b00000000800ULL,
0x0000002e00677308ULL, 0x0007220000000800ULL, 0x000000102c2d7810ULL, 0x002fc40007ffe0ffULL,
0x000000182c2c7810ULL, 0x000fca0007ffe0ffULL, 0x000000082c5d7824ULL, 0x000fe200078e00ffULL,
0x0000003800387308ULL, 0x000fe20000000800ULL, 0x000000082d2e7824ULL, 0x008fe200078e00ffULL,
0x000000656631723eULL, 0x004fe400000000ffULL, 0xfffffff85d5d7812ULL, 0x000fe400078ee22cULL,
0xfffffff82e5b7812ULL, 0x000fe400078ee22dULL, 0x0000003900397308ULL, 0x000e620000000800ULL,
0x0000001b522c723eULL, 0x000fc400000000ffULL, 0x00000051542e723eULL, 0x000fe400000000ffULL,
0x00000018612d723eULL, 0x000fe400000000ffULL, 0x000000676833723eULL, 0x010fe200000000ffULL,
0x0000003a003a7308ULL, 0x000fe20000000800ULL, 0x0000a0009a187811ULL, 0x000fc600078e60ffULL,
0x000000022c10723cULL, 0x020f640000001810ULL, 0x0000001049197824ULL, 0x100fe400078e0218ULL,
0x0000003c00697308ULL, 0x0004e20000000800ULL, 0x000000383934723eULL, 0x002fe200000000ffULL,
0x00000010571b7824ULL, 0x100fe400078e0218ULL, 0x000000106b387824ULL, 0x100fe400078e0218ULL,
0x000000106d397824ULL, 0x000fc400078e0218ULL, 0x0000004a004a7308ULL, 0x000fe20000000800ULL,
0x000000014b197824ULL, 0x040fe400078e0219ULL, 0x000000014b1b7824ULL, 0x040fe200078e021bULL,
0x000000394b397210ULL, 0x000fe20007ffe0ffULL, 0x00000010713c7824ULL, 0x004fe200078e0218ULL,
0x0000000819007388ULL, 0x000fe20000000800ULL, 0x000000014b387824ULL, 0x000fe200078e0238ULL,
0x0000003b003b7308ULL, 0x000e620000000800ULL, 0x0000003a6936723eULL, 0x008fe200000000ffULL,
0x000000104d3a7824ULL, 0x000fe200078e0218ULL, 0x0000000a1b007388ULL, 0x000fe20000000800ULL,
0x000000014b3c7824ULL, 0x000fc400078e023cULL, 0x000000014b3a7824ULL, 0x000fe200078e023aULL,
0x0000001438007388ULL, 0x000fe20000000800ULL, 0x0000003d003d7308ULL, 0x000fe20000000800ULL,
0x000000105b447824ULL, 0x100fe400078e0218ULL, 0x0000001639007388ULL, 0x000fe80000000800ULL,
0x0000002c3a007388ULL, 0x000fe20000000800ULL, 0x0000003e003e7308ULL, 0x000ea20000000800ULL,
0x0000004a3b35723eULL, 0x002fe200000000ffULL, 0x000000106f3b7824ULL, 0x000fc800078e0218ULL,
0x000000014b3b7824ULL, 0x000fe400078e023bULL, 0x0000005500557308ULL, 0x000fe60000000800ULL,
0x0000002e3b007388ULL, 0x000fea0000000800ULL, 0x0000005600567308ULL, 0x000e620000000800ULL,
0x0000003d3e37723eULL, 0x004fe200000000ffULL, 0x000000104f3d7824ULL, 0x000fc400078e0218ULL,
0x00000010593e7824ULL, 0x000fe400078e0218ULL, 0x000000014b3d7824ULL, 0x040fe400078e023dULL,
0x0000005000507308ULL, 0x000fe20000000800ULL, 0x000000023424723cULL, 0x000fe20000001824ULL,
0x000000014b3e7824ULL, 0x000fe400078e023eULL, 0x000000105d187824ULL, 0x000fc800078e0218ULL,
0x0000005300537308ULL, 0x000ea20000000800ULL, 0x000000555630723eULL, 0x002fe200000000ffULL,
0x000000014b187824ULL, 0x000fc800078e0218ULL, 0x000000303c007388ULL, 0x000fe40000000800ULL,
0x0000003f003f7308ULL, 0x000ff00000000800ULL, 0x0000004000407308ULL, 0x000e620000000800ULL,
0x000000505332723eULL, 0x004fca00000000ffULL, 0x000000323d007388ULL, 0x000fe40000000800ULL,
0x0000004200427308ULL, 0x000ea20000000800ULL, 0x000000023010723cULL, 0x020f620000001810ULL,
0x000000093e007388ULL, 0x000fe80000000800ULL, 0x0004000b1b007388ULL, 0x000fe40000000800ULL,
0x0000004100417308ULL, 0x000fe20000000800ULL, 0x0000003f4040723eULL, 0x002fe200000000ffULL,
0x0004001538007388ULL, 0x000fe80000000800ULL, 0x0004001739007388ULL, 0x000fe40000000800ULL,
0x00000043001a7308ULL, 0x000e620000000800ULL, 0x000000424542723eULL, 0x004fe200000000ffULL,
0x0004002d3a007388ULL, 0x000fe60000000800ULL, 0x000000014b117824ULL, 0x020fe200078e0244ULL,
0x0004002f3b007388ULL, 0x000fe40000000800ULL, 0x0000004600467308ULL, 0x000fe40000000800ULL,
0x000400313c007388ULL, 0x000fe80000000800ULL, 0x000400333d007388ULL, 0x000fe40000000800ULL,
0x0000004700477308ULL, 0x000ea20000000800ULL, 0x000000411a41723eULL, 0x002fe200000000ffULL,
0x0000000c11007388ULL, 0x0003e80000000800ULL, 0x0008000e1b007388ULL, 0x0007e80000000800ULL,
0x0008002838007388ULL, 0x0007e20000000800ULL, 0x000000ffff117224ULL, 0x002fc600078e0012ULL,
0x0008002a39007388ULL, 0x0007e20000000800ULL, 0x000000464743723eULL, 0x004fc600000000ffULL,
0x000800343a007388ULL, 0x0007e80000000800ULL, 0x000800363b007388ULL, 0x0007e20000000800ULL,
0x000000024024723cULL, 0x000f660000001824ULL, 0x000800403c007388ULL, 0x0007e80000000800ULL,
0x000800423d007388ULL, 0x0007e80000000800ULL, 0x0000000d18007388ULL, 0x0007e80000000800ULL,
0x000c000f1b007388ULL, 0x0007e80000000800ULL, 0x000c002938007388ULL, 0x0007e80000000800ULL,
0x000c002b39007388ULL, 0x0007e20000000800ULL, 0x000000ffff127224ULL, 0x020fc400078e0024ULL,
0x000000ffff137224ULL, 0x000fe200078e0026ULL, 0x000c00353a007388ULL, 0x0007e80000000800ULL,
0x000c00373b007388ULL, 0x0007e80000000800ULL, 0x000c00413c007388ULL, 0x0007e80000000800ULL,
0x000c00433d007388ULL, 0x0007e80000000800ULL, 0x0160000400008388ULL, 0x0007e80000000c00ULL,
0x0162001000008388ULL, 0x0007e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x016608009cff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x016610009cff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x016618009cff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000237800720cULL, 0x000fe20003f06070ULL, 0x016620009cff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff967224ULL, 0x000fd600078e0078ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff7c7000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff1f7807ULL, 0x004fe40004000000ULL, 0x0001867000207802ULL, 0x000fc40000000f00ULL,
0x0000106000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e001fULL,
0xfffea83000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x000fe40005000000ULL,
0x000186c000207802ULL, 0x000fc40000000f00ULL, 0x0000101000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff117224ULL, 0x000fe200078e001fULL, 0xfffea89000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0012ULL, 0x0001871000207802ULL, 0x000fc40000000f00ULL,
0x00000f8000007944ULL, 0x018fea0003c00000ULL, 0xfffea96000007947ULL, 0x000fea000383ffffULL,
0x0000001200217202ULL, 0x000fe40000000f00ULL, 0x0001875000207802ULL, 0x000fc40000000f00ULL,
0x00000f4000007944ULL, 0x01afea0003c00000ULL, 0xfffeaa9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0012ULL, 0x0001879000207802ULL, 0x000fc40000000f00ULL,
0x00000f0000007944ULL, 0x01afea0003c00000ULL, 0xfffeabc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0012ULL, 0x000187d000207802ULL, 0x000fc40000000f00ULL,
0x00000ec000007944ULL, 0x01afea0003c00000ULL, 0xfffeace000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e000eULL, 0x0001882000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fc400078e000dULL, 0x00000e7000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e001fULL, 0xfffeae9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e000eULL, 0x0001887000207802ULL, 0x000fc40000000f00ULL,
0x00000e2000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e001fULL,
0x000000100d1f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff217224ULL, 0x000fe200078e000eULL,
0x000188c000207802ULL, 0x000fc40000000f00ULL, 0x00000dd000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e001fULL, 0xfffeae4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e000eULL, 0x0001891000207802ULL, 0x000fc40000000f00ULL,
0x00000d8000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e001fULL,
0xfffeae2000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x008fe40004000000ULL,
0x0001896000207802ULL, 0x000fc40000000f00ULL, 0x00000d7000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e001fULL, 0xfffec74000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x000fe40004800000ULL, 0x000189b000207802ULL, 0x000fc40000000f00ULL,
0x00000d2000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e001fULL,
0xfffec79000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0067ULL,
0x00018a0000207802ULL, 0x000fc40000000f00ULL, 0x00000c9000007944ULL, 0x012fea0003c00000ULL,
0xfffec87000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0067ULL,
0x00018a4000207802ULL, 0x000fc40000000f00ULL, 0x00000c5000007944ULL, 0x012fea0003c00000ULL,
0xfffec9a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0067ULL,
0x00018a8000207802ULL, 0x000fc40000000f00ULL, 0x00000c1000007944ULL, 0x012fea0003c00000ULL,
0xfffecad000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0067ULL,
0x00018ac000207802ULL, 0x000fc40000000f00ULL, 0x00000bd000007944ULL, 0x012fea0003c00000ULL,
0xfffecbf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0003ULL,
0x00018b1000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff1f7224ULL, 0x000fc400078e0064ULL,
0x00000b8000007944ULL, 0x010fea0003c00000ULL, 0x0000001f000a7202ULL, 0x004fe20000000f00ULL,
0xfffecd9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0003ULL,
0x00018b6000207802ULL, 0x000fc40000000f00ULL, 0x00000b3000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e001fULL, 0x00000010641f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff217224ULL, 0x000fe200078e0003ULL, 0x00018bb000207802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e001fULL,
0xfffecd4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0003ULL,
0x00018c0000207802ULL, 0x000fc40000000f00ULL, 0x00000a9000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e001fULL, 0xfffecd2000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x004fe40004000000ULL, 0x00018c5000207802ULL, 0x000fc40000000f00ULL,
0x00000a8000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff1d7224ULL, 0x000fe200078e001fULL,
0xfffee39000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x000fe40004800000ULL,
0x00018ca000207802ULL, 0x000fc40000000f00ULL, 0x00000a3000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff667224ULL, 0x000fe200078e001fULL, 0xfffee3d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0067ULL, 0x00018cf000207802ULL, 0x000fc40000000f00ULL,
0x000009a000007944ULL, 0x018fea0003c00000ULL, 0xfffee4a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0067ULL, 0x00018d3000207802ULL, 0x000fc40000000f00ULL,
0x0000096000007944ULL, 0x01afea0003c00000ULL, 0xfffee5d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0067ULL, 0x00018d7000207802ULL, 0x000fc40000000f00ULL,
0x0000092000007944ULL, 0x01afea0003c00000ULL, 0xfffee70000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e0067ULL, 0x00018db000207802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x01afea0003c00000ULL, 0xfffee82000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e000dULL, 0x00018e0000207802ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fc400078e0064ULL, 0x0000089000007944ULL, 0x010fea0003c00000ULL,
0x0000001f000a7202ULL, 0x004fe20000000f00ULL, 0xfffee9c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e000dULL, 0x00018e5000207802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0b7224ULL, 0x004fe200078e001fULL,
0x00000010641f7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff217224ULL, 0x000fe200078e000dULL,
0x00018ea000207802ULL, 0x000fc40000000f00ULL, 0x000007f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e001fULL, 0xfffee97000007947ULL, 0x000fea000383ffffULL,
0x000000ffff217224ULL, 0x000fe200078e000dULL, 0x00018ef000207802ULL, 0x000fc40000000f00ULL,
0x000007a000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e001fULL,
0xfffee95000007947ULL, 0x000fea000383ffffULL, 0x00000001ff1f7807ULL, 0x008fe40004000000ULL,
0x00018f4000207802ULL, 0x000fc40000000f00ULL, 0x0000079000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff667224ULL, 0x000fe200078e001fULL, 0xfffeffb000007947ULL, 0x000fea000383ffffULL,
0x00000001ff1f7807ULL, 0x000fe40004800000ULL, 0x00018f9000207802ULL, 0x000fc40000000f00ULL,
0x0000074000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff677224ULL, 0x000fe200078e001fULL,
0xfffefff000007947ULL, 0x000fea000383ffffULL, 0x0000006900217202ULL, 0x000fe40000000f00ULL,
0x00018fe000207802ULL, 0x000fc40000000f00ULL, 0x000006b000007944ULL, 0x012fea0003c00000ULL,
0xffff00d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0069ULL,
0x0001902000207802ULL, 0x000fc40000000f00ULL, 0x0000067000007944ULL, 0x012fea0003c00000ULL,
0xffff020000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0069ULL,
0x0001906000207802ULL, 0x000fc40000000f00ULL, 0x0000063000007944ULL, 0x012fea0003c00000ULL,
0xffff033000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0069ULL,
0x000190a000207802ULL, 0x000fc40000000f00ULL, 0x000005f000007944ULL, 0x012fea0003c00000ULL,
0xffff045000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0008ULL,
0x000190f000207802ULL, 0x000fe20000000f00ULL, 0x000000ffff1f7224ULL, 0x000fc400078e000dULL,
0x000005a000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0a7224ULL, 0x004fe200078e001fULL,
0xffff05f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0008ULL,
0x0001914000207802ULL, 0x000fc40000000f00ULL, 0x0000055000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0b7224ULL, 0x004fe200078e001fULL, 0x000000100d1f7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff217224ULL, 0x000fe200078e0008ULL, 0x0001919000207802ULL, 0x000fc40000000f00ULL,
0x0000050000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e001fULL,
0xffff05a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff217224ULL, 0x000fe200078e0008ULL,
0x000191e000207802ULL, 0x000fc40000000f00ULL, 0x000004b000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e001fULL, 0xffff058000007947ULL, 0x000fea000383ffffULL,
0x00000002ff527424ULL, 0x000fe200078e00ffULL, 0x0001923000507802ULL, 0x000fc40000000f00ULL,
0x0000042000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0058ULL,
0xffffdfd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x006fe200078e0053ULL,
0x0001929000507802ULL, 0x000fe20000000f00ULL, 0x00000002ff527424ULL, 0x000fc400078e00ffULL,
0x000003c000007944ULL, 0x000fea0003c00000ULL, 0x000000585300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0054ULL, 0x000192f000507802ULL, 0x000fe20000000f00ULL,
0x00000002ff527424ULL, 0x000fe200078e00ffULL, 0x0000005358057208ULL, 0x000fc80004000000ULL,
0x0000036000007944ULL, 0x000fea0003c00000ULL, 0x000000585400720bULL, 0x004fe20003f1e000ULL,
0x00000002ff527424ULL, 0x002fe200078e00ffULL, 0x0000005500077202ULL, 0x000fc40000000f00ULL,
0x00000054581b7208ULL, 0x000fe40004000000ULL, 0x0001935000507802ULL, 0x000fc40000000f00ULL,
0x0000030000007944ULL, 0x000fea0003c00000ULL, 0x000000585500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0059ULL, 0x000193b000507802ULL, 0x000fe20000000f00ULL,
0x00000001ff527424ULL, 0x000fe200078e00ffULL, 0x0000005558577208ULL, 0x000fc80004000000ULL,
0x000002a000007944ULL, 0x000fea0003c00000ULL, 0x000000585900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0005ULL, 0x0001941000507802ULL, 0x000fe20000000f00ULL,
0x00000001ff527424ULL, 0x000fe200078e00ffULL, 0x0000005958047208ULL, 0x000fc80004000000ULL,
0x0000024000007944ULL, 0x000fea0003c00000ULL, 0x000000580500720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e001bULL, 0x0001947000507802ULL, 0x000fe20000000f00ULL,
0x00000001ff527424ULL, 0x000fe200078e00ffULL, 0x0000000558057208ULL, 0x000fc80004000000ULL,
0x000001e000007944ULL, 0x000fea0003c00000ULL, 0x000000581b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0057ULL, 0x000194d000507802ULL, 0x000fe20000000f00ULL,
0x00000001ff527424ULL, 0x000fe200078e00ffULL, 0x0000001b58067208ULL, 0x000fc80004000000ULL,
0x0000018000007944ULL, 0x000fea0003c00000ULL, 0xffffdea000007947ULL, 0x000fea000383ffffULL,
0x0180000007057810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000005097812ULL, 0x000fc800078ec0ffULL, 0x018000000900780cULL, 0x000fda0003f05070ULL,
0x0000000700058308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0900720cULL, 0x040fe40003f25070ULL, 0x008000000900780cULL, 0x000fe40003f02070ULL,
0x00000001ff0e7807ULL, 0x000fe40000800000ULL, 0x00000001ff057807ULL, 0x004fc80004000000ULL,
0x000000050eff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000007077812ULL, 0x002fe400078ec0ffULL,
0x00000001ff057807ULL, 0x000fc80000000000ULL, 0x000000050eff7212ULL, 0x000fda000780c0ffULL,
0x0080000007050812ULL, 0x000fe200078efcffULL, 0x000000ffff058224ULL, 0x000fe200078e0007ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000700057308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000000ff0b7424ULL, 0x000fc800078e00ffULL,
0xfffe69b00a007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff517424ULL, 0x000fe200078e00ffULL,
0x0000005b00007348ULL, 0x000fe80003800000ULL, 0x0c00005207587389ULL, 0x0002a200000e0056ULL,
0xfffe697050007950ULL, 0x000fea0003c3ffffULL, 0x0000008200007348ULL, 0x000fe80003800000ULL,
0x0000001f211f7389ULL, 0x0002a400000e0084ULL, 0x00000000ff217424ULL, 0x002fc800078e00ffULL,
0xfffe693020007950ULL, 0x000fea0003c3ffffULL, 0x000000011f00780cULL, 0x000fe20003f45070ULL,
0x00000000ff217424ULL, 0x000fe200078e00ffULL, 0x0000008100007348ULL, 0x000ff60003800000ULL,
0x00000000001f7806ULL, 0x000fc800050e0100ULL, 0x000000811f1f7212ULL, 0x000fe200078ec0ffULL,
0xfffe68d020007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000200000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x00000000000004c4ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000620ULL,
0x0000000000000240ULL, 0x0000001700000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000860ULL,
0x0000000000000268ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ac8ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000b88ULL,
0x00000000000006bcULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001248ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001258ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012e8ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012ecULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001500ULL,
0x0000000000019800ULL, 0xdf00001700000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001ad00ULL,
0x0000000000000038ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001ad40ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001b0c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000012e8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000019a18ULL,
0x0000000000019a18ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001ad00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001b0c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_32_sm_89_cubin_len = 111008;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
