/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000019a30ULL, 0x00000000000196b0ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x346a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4532336a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45326a4c497461ULL, 0x45346a4c4545326aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5633494432796172ULL, 0x45346a4c6a496365ULL,
0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL,
0x6c5372655073776fULL, 0x000000676e696469ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x6e695f5f24000000ULL, 0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL,
0x7a74665f6e725f70ULL, 0x6f6c735f3233665fULL, 0x722e006874617077ULL, 0x2e747865742e6c65ULL,
0x6d5f6c656e72656bULL, 0x616c65722e006168ULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL,
0x6c656e72656b2400ULL, 0x656d732461686d5fULL, 0x667542657479426dULL, 0x5f67756265642e00ULL,
0x722e00656d617266ULL, 0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL,
0x656d6172665f6775ULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL, 0x686d5f6c656e7265ULL,
0x0000000000000061ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000010ULL,
0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00090001000000b5ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL,
0x0000000000000028ULL, 0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL,
0x000b00010000017cULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000b0001000001beULL,
0x000000000000001cULL, 0x0000000000000004ULL, 0x000b000100000204ULL, 0x0000000000000008ULL,
0x0000000000000004ULL, 0x000b00010000024bULL, 0x0000000000000024ULL, 0x0000000000000004ULL,
0x000b000100000291ULL, 0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000002dfULL,
0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b00010000032dULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a002200000388ULL, 0x0000000000018370ULL, 0x0000000000000210ULL, 0x00040003000003feULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL,
0x0000000000018580ULL, 0x000d00030000042eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001837000000000ULL, 0x0001080400000000ULL, 0x0000288080810c00ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x80808c0828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808c92ULL, 0x0000001cffffffffULL, 0x0000006000000000ULL, 0x0001837000000000ULL,
0x0000021000000000ULL, 0x0000000000000000ULL, 0x0000001300082f04ULL, 0x00082304000000d9ULL,
0x0000000000000011ULL, 0x0000001100081204ULL, 0x0008110400000000ULL, 0x0000000000000011ULL,
0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL,
0x0004370400000000ULL, 0x000c17040000007bULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL,
0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0xffffffff010c2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000002b0010c2804ULL, 0x000007c000000400ULL, 0x0000306000002090ULL, 0x000031c0000030e0ULL,
0x00003420000032f0ULL, 0x0000395000003560ULL, 0x0000397000003960ULL, 0x000040b000003980ULL,
0x0000504000004fa0ULL, 0x0000525000005120ULL, 0x000054c000005380ULL, 0x0000575000005740ULL,
0x0000577000005760ULL, 0x00006c5000005d70ULL, 0x00006dc000006cd0ULL, 0x0000702000006ef0ULL,
0x000073c000007160ULL, 0x000073e0000073d0ULL, 0x00007920000073f0ULL, 0x00008980000088f0ULL,
0x00008b9000008a60ULL, 0x00008e0000008cc0ULL, 0x0000907000009060ULL, 0x0000909000009080ULL,
0x0000972000009710ULL, 0x0000974000009730ULL, 0x0000c3400000c2e0ULL, 0x0000c5e00000c5a0ULL,
0x0000cd300000ccf0ULL, 0x0000cd800000cd50ULL, 0x00016c4000016b90ULL, 0x0001704000016f40ULL,
0x0001755000017450ULL, 0x000178e000017810ULL, 0x0000047001f03904ULL, 0x0001e600000000ffULL,
0x0000055000040100ULL, 0x0001e60800000005ULL, 0x00000660003f0100ULL, 0x0001e68800000004ULL,
0x00000dd0003f0100ULL, 0x0001e6000000000aULL, 0x00000f80003f0107ULL, 0x0001e6880000000eULL,
0x00002df0003f0101ULL, 0x0001e60800000017ULL, 0x00002e10003f0101ULL, 0x0001e60800000017ULL,
0x00002f80003f0109ULL, 0x0001e60800000017ULL, 0x00003fa0003f0109ULL, 0x0001e68800000038ULL,
0x00004d80003f0101ULL, 0x0001e6280000003bULL, 0x00004da0003f0101ULL, 0x0001e6280000003bULL,
0x00004f10003f0109ULL, 0x0001e6280000003bULL, 0x00005c70003f0109ULL, 0x0001e6900000005dULL,
0x00006a30003f0101ULL, 0x0001e6480000003dULL, 0x00006a50003f0101ULL, 0x0001e6480000003dULL,
0x00006bc0003f0109ULL, 0x0001e6480000003dULL, 0x000078b0003f0109ULL, 0x0001e6980000003dULL,
0x000086d0003f0101ULL, 0x0001e66800000065ULL, 0x000086f0003f0101ULL, 0x0001e66800000065ULL,
0x00008860003f0109ULL, 0x0001e66800000065ULL, 0x00009470003f0109ULL, 0x0001e6a000000014ULL,
0x0000e4d0003f0101ULL, 0x0001e6000000000aULL, 0x0000fdc0003f0101ULL, 0x0001e6000000000aULL,
0x0000ff30003f0109ULL, 0x0001e6000000000aULL, 0x00014470003f0109ULL, 0x0001e68800000099ULL,
0x00014870003f0101ULL, 0x0001e68800000099ULL, 0x000149e0003f0109ULL, 0x0001e68800000099ULL,
0x00018300003f0109ULL, 0x0001e6080000000eULL, 0x00018310003f0101ULL, 0x0001e6100000000eULL,
0x00018320003f0101ULL, 0x0001e6180000000eULL, 0x00018330003f0101ULL, 0x0001e6200000000eULL,
0x00033803003f0101ULL, 0x0000d90000301c04ULL, 0x0000db100000d960ULL, 0x0000ddd00000dc70ULL,
0x0000e0900000df30ULL, 0x0000e3800000e1f0ULL, 0x0000ff600000e480ULL, 0x000c050400018360ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0060190300000000ULL, 0x0000001400080a04ULL,
0x0000000000600210ULL, 0x00000000000000bcULL, 0x0000001300000002ULL, 0x0000000000018370ULL,
0x0000000000000044ULL, 0x0000001300000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL,
0x0000001300000002ULL, 0x0000000000000000ULL, 0x000000000001e700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff127b82ULL, 0x000ea20000000a00ULL,
0x00000000000c7919ULL, 0x000ee20000002300ULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x0000000000077919ULL, 0x000eea0000002200ULL, 0x00000300ff007b82ULL, 0x000f220000000800ULL,
0x00000000000a7919ULL, 0x000f620000002100ULL, 0x00000000009b7919ULL, 0x000f2c0000002700ULL,
0x00000400ff067b82ULL, 0x000ee20000000800ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x0000001300047306ULL, 0x004ea20000209000ULL, 0x000000ff1300720cULL, 0x000fca0003f45070ULL,
0x00008600ff117b82ULL, 0x000f240000000800ULL, 0x0000000400047308ULL, 0x004ea40000001000ULL,
0x0ffffffe04027836ULL, 0x004fcc0000000000ULL, 0x0000000200037305ULL, 0x0004e4000021f000ULL,
0x000000ffff027224ULL, 0x004fe400078e00ffULL, 0x000000ffff087224ULL, 0x00afc800078e0a03ULL,
0x0000001308057224ULL, 0x000fe400078e02ffULL, 0x0000000000087919ULL, 0x000e640000002600ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000000603057227ULL, 0x000fc800078e00ffULL,
0x000000ffff047224ULL, 0x000fc800078e0a05ULL, 0x0000000413047224ULL, 0x000fca00078e0206ULL,
0x000000130400720cULL, 0x000fda0003f06070ULL, 0x8000001304040210ULL, 0x000fe20007ffe0ffULL,
0x0000000105050836ULL, 0x000fc60000000000ULL, 0x000000130400720cULL, 0x000fda0003f26070ULL,
0x0000000105051836ULL, 0x000fe20000000000ULL, 0x00000013ff05a212ULL, 0x000fc800078e33ffULL,
0x0000000500047306ULL, 0x000ea20000209000ULL, 0x000000ff0500720cULL, 0x000fce0003f65070ULL,
0x0000000400047308ULL, 0x004ea40000001000ULL, 0x0ffffffe04027836ULL, 0x004fcc0000000000ULL,
0x0000000200037305ULL, 0x0004e4000021f000ULL, 0x000000ff00027202ULL, 0x004fe20000000f00ULL,
0x0000000305067224ULL, 0x008fc800078e02ffULL, 0x000000ffff097224ULL, 0x000fc800078e0a06ULL,
0x0000000903037227ULL, 0x000fcc00078e0002ULL, 0x0000000803187227ULL, 0x002fc800078e00ffULL,
0x000000040c037c24ULL, 0x000fe2000f8e0207ULL, 0x0000000000047ab9ULL, 0x000fe20000000800ULL,
0x000000ffff027224ULL, 0x000fe200078e0a18ULL, 0x00001fff0c0c7589ULL, 0x000f2200000e0000ULL,
0x0000000403047c24ULL, 0x020fe4000f8e020aULL, 0x0000000205027224ULL, 0x000fc600078e0208ULL,
0x0000007f0400780cULL, 0x000fe40003f44070ULL, 0x000000050200720cULL, 0x000fd60003f06070ULL,
0x000000000006a919ULL, 0x000e620000008800ULL, 0x000004000003a802ULL, 0x000fe20000000f00ULL,
0x0000000102020824ULL, 0x000fe400078e0a05ULL, 0x0000000118180836ULL, 0x000fe20000000000ULL,
0x000000ff0400720cULL, 0x000fe40003f05270ULL, 0x000000050200720cULL, 0x000fda0003f26070ULL,
0x0000000118181836ULL, 0x000fe20000000000ULL, 0x00000005ff18b212ULL, 0x000fe400078e33ffULL,
0x0000000f0400780cULL, 0x040fe40003f24070ULL, 0x000000ff18027210ULL, 0x000fe40007ffe1ffULL,
0x000000030400780cULL, 0x000fc60003f64070ULL, 0x0000000205027224ULL, 0x000fe200078e0208ULL,
0x000006540607a816ULL, 0x002fe40000000003ULL, 0x00000005ff037819ULL, 0x000fe2000001160aULL,
0xff317217ff0aa424ULL, 0x000fe400078e00ffULL, 0x000000040407a824ULL, 0x000fc600078e0207ULL,
0x00001fff03037589ULL, 0x000ea200000e0000ULL, 0x0000000000240947ULL, 0x010fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01e60006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404057c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000050612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01e60804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000383947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000040612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01e68804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020020d7824ULL, 0x000fe200078e00ffULL, 0x0000001112047219ULL, 0x080fe200000006ffULL,
0x0000000000057919ULL, 0x000e620000002500ULL, 0x0000001113067219ULL, 0x000fe200000006ffULL,
0x000000ffff097224ULL, 0x000fe200078e0a0dULL, 0x0000000d0400720cULL, 0x000fe20003f06070ULL,
0x01e4000a0700a388ULL, 0x0007e20000000800ULL, 0x000000030c087211ULL, 0x004fe200078e10ffULL,
0x000000129b127224ULL, 0x000fe200078e02ffULL, 0x0000002004047446ULL, 0x000fe20003800009ULL,
0x0000820000067ab9ULL, 0x000fc40000000a00ULL, 0x0000000408097824ULL, 0x000fe200078e00ffULL,
0x000000ff04047207ULL, 0x000fe40000000000ULL, 0x0000001118077219ULL, 0x008fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000200400780cULL, 0x000fe20003f05270ULL,
0x0000000612127224ULL, 0x000fd800078e0207ULL, 0x0000000000c48947ULL, 0x002fea0003800000ULL,
0x0000000000087919ULL, 0x000e620000000000ULL, 0xffffffffff107424ULL, 0x000fe200078e00ffULL,
0x00000009040a7248ULL, 0x000fe20007fe0000ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000000001c7919ULL, 0x000ea20000008800ULL, 0x0000040000177802ULL, 0x000fe40000000f00ULL,
0x00000011100b7219ULL, 0x000fe400000006ffULL, 0x00000004ff0e7819ULL, 0x002fca0000011608ULL,
0x000000020e167836ULL, 0x000fe40000000000ULL, 0x0000000109147824ULL, 0x000fc600078e020eULL,
0x0000001609157210ULL, 0x000fe20007ffe0ffULL, 0x000000010d107824ULL, 0x040fe400078e0214ULL,
0x000000010a097824ULL, 0x000fe200078e0a09ULL, 0x000006541c0a7816ULL, 0x004fe20000000017ULL,
0x000000010d1a7824ULL, 0x000fe200078e0215ULL, 0x0000000b100f7212ULL, 0x000fe400078e30ffULL,
0x000000090e00720cULL, 0x000fe40003f06070ULL, 0x0000000b1a177212ULL, 0x000fe200078e30ffULL,
0x00000001120f7824ULL, 0x000fe200078e020fULL, 0x00000011ff0b7219ULL, 0x000fc40000011610ULL,
0x00000011ff117219ULL, 0x000fe4000001161aULL, 0x0000001712177210ULL, 0x000fe20007ffe0ffULL,
0x000000060b0f7224ULL, 0x080fe200078e020fULL, 0x000000091600720cULL, 0x000fe20003f26070ULL,
0x0000001008127824ULL, 0x000fe400078e00ffULL, 0x0000000611117224ULL, 0x000fe400078e0217ULL,
0x000001000f0e7825ULL, 0x000fe200078e00ffULL, 0x000000f012097812ULL, 0x000fc600078ec0ffULL,
0x0000010011107825ULL, 0x000fe200078e00ffULL, 0x000000090e0e7212ULL, 0x000fc600078efcffULL,
0x00000001140b7824ULL, 0x100fe200078e0208ULL, 0x0000000910097212ULL, 0x000fe200078efcffULL,
0x0000001014167824ULL, 0x000fe200078e00ffULL, 0x000000040e0e7c10ULL, 0x000fe2000ff5e0ffULL,
0x0000000115147824ULL, 0x040fe200078e0208ULL, 0x0000000415157819ULL, 0x000fe400000006ffULL,
0xfffffff0160b7812ULL, 0x000fe400078ee20bULL, 0x0000000409107c10ULL, 0x000fe4000ff7e0ffULL,
0xfffffff015097812ULL, 0x000fe200078ee214ULL, 0x000000100b0b7824ULL, 0x000fe200078e020aULL,
0x000000050f0f7c10ULL, 0x000fc400097fe4ffULL, 0x0000000511117c10ULL, 0x000fe20009ffe4ffULL,
0x0000001009097824ULL, 0x000fe400078e020aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0b7faeULL, 0x0003e8000c101c46ULL, 0x0000000010097faeULL, 0x0003e2000c901c46ULL,
0x0000000000a87947ULL, 0x000fea0003800000ULL, 0x0000000000087919ULL, 0x000e620000000000ULL,
0xffffffffff0a7424ULL, 0x000fe200078e00ffULL, 0x0000040000107802ULL, 0x000fe20000000f00ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000177919ULL, 0x000ea40000008800ULL,
0x000000110a157219ULL, 0x000fe400000006ffULL, 0x0000000908097211ULL, 0x002fc800078fe0ffULL,
0x000000090d0a7210ULL, 0x000fe20007ffe0ffULL, 0x0000000209147836ULL, 0x000fe40000000000ULL,
0x0000001009167824ULL, 0x000fe200078e00ffULL, 0x000000150a0f7212ULL, 0x000fe200078e30ffULL,
0x000000010d0e7824ULL, 0x000fe200078e0214ULL, 0x00000011ff0b7219ULL, 0x000fe4000001160aULL,
0x00000654170a7816ULL, 0x004fe20000000010ULL, 0x00000001120f7824ULL, 0x000fe200078e020fULL,
0x000000150e157212ULL, 0x000fc400078e30ffULL, 0x00000011ff117219ULL, 0x000fe2000001160eULL,
0x000000060b0f7224ULL, 0x080fe200078e020fULL, 0x00000008090b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000112157824ULL, 0x000fe400078e0215ULL, 0x0000001008127824ULL, 0x000fe200078e00ffULL,
0xfffffff0160b7812ULL, 0x000fe200078ee20bULL, 0x0000000611117224ULL, 0x000fe400078e0215ULL,
0x000001000f0e7825ULL, 0x000fe200078e00ffULL, 0x000000f012157812ULL, 0x000fc400078ec0ffULL,
0x0000000a0b0b7211ULL, 0x000fe200078e20ffULL, 0x0000010011107825ULL, 0x000fe200078e00ffULL,
0x000000150e0e7212ULL, 0x000fc600078efcffULL, 0x0000000114097824ULL, 0x000fe200078e0208ULL,
0x0000001510107212ULL, 0x000fe200078efcffULL, 0x0000001014147824ULL, 0x000fe200078e00ffULL,
0x000000040e0e7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000410107c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff014097812ULL, 0x000fe400078ee209ULL, 0x000000050f0f7c10ULL, 0x000fe400087fe4ffULL,
0x0000000511117c10ULL, 0x000fe20008ffe4ffULL, 0x0000001009097824ULL, 0x000fc400078e020aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0b7faeULL, 0x0003e8000b901c46ULL,
0x0000000010097faeULL, 0x0003e4000b901c46ULL, 0x000000000a0472caULL, 0x000fe200000e0000ULL,
0x00009200ff0e7b82ULL, 0x002e620000000a00ULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x0001e60004047890ULL, 0x000fd2000fffe03fULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x000000049b0e7825ULL, 0x002fe200078e000eULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x000000060e097981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0c00720cULL, 0x000fe20003f05270ULL, 0x0000003f090b7836ULL, 0x004fe40000000000ULL,
0x000000ff090c7836ULL, 0x000fc60000000000ULL, 0x00000006ff0b7819ULL, 0x000fe4000001160bULL,
0x00000008ff0c7819ULL, 0x000fca000001160cULL, 0x000000d4007c8947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe20000011603ULL, 0xffffffffff107424ULL, 0x000fe200078e00ffULL,
0x0000000400157802ULL, 0x000fe40000000f00ULL, 0x03ffffff0d0e7812ULL, 0x000fc800078ec0ffULL,
0x0000000e05377211ULL, 0x000fc800078e10ffULL, 0x0000000b3700720cULL, 0x000fda0003f06070ULL,
0x00009400ff0f8b82ULL, 0x000e620000000800ULL, 0x000000029b0e8824ULL, 0x000fce00078e00ffULL,
0x00009000ff168b82ULL, 0x000ea20000000a00ULL, 0x0000000f0e0e8224ULL, 0x002fe400078e020fULL,
0x00000008030f7824ULL, 0x000fe400078e00ffULL, 0x0000000137118824ULL, 0x000fe400078e020eULL,
0x000000010a0e7824ULL, 0x000fe400078e020fULL, 0x0000000411168825ULL, 0x004fe400078e0016ULL,
0x01e688150eff79a7ULL, 0x0003e6000850003fULL, 0x0000000616108981ULL, 0x000ea2000c1e1900ULL,
0x00000001ff277819ULL, 0x000fc80000011603ULL, 0x00000005270e7819ULL, 0x002fca00000006ffULL,
0x00000100051b7824ULL, 0x000fe200078e020eULL, 0x00008e00ff147b82ULL, 0x000e620000000a00ULL,
0x0000001310107224ULL, 0x004fe400078e02ffULL, 0x0000000105137836ULL, 0x000fe40000000000ULL,
0x0000004010117824ULL, 0x000fe400078e00ffULL, 0x0000004018107824ULL, 0x000fe200078e00ffULL,
0x0000000c1300720cULL, 0x000fe20003f06070ULL, 0x0000010011147825ULL, 0x002fe200078e0014ULL,
0x0000000103117812ULL, 0x000fc400078ec0ffULL, 0x0000002010247812ULL, 0x000fd200078ef81bULL,
0x0000000400948947ULL, 0x000fea0003800000ULL, 0x0000007012127812ULL, 0x000fe200078ec0ffULL,
0x000000ffff137224ULL, 0x000fe200078e00ffULL, 0x00000003ff1f7819ULL, 0x000fe40000011608ULL,
0x0000001211127211ULL, 0x000fe400078e38ffULL, 0x0000001b09187248ULL, 0x000fe20007fe0000ULL,
0x0000000124177824ULL, 0x000fe200078e021fULL, 0x000000ff1b1b7210ULL, 0x000fe20007ffe1ffULL,
0x000000041f197836ULL, 0x000fe20000000000ULL, 0x000000181f317810ULL, 0x000fe20007ffe0ffULL,
0x0000010017167825ULL, 0x000fe200078e0012ULL, 0x00000020181e7446ULL, 0x000fc6000380001bULL,
0x000000011f187824ULL, 0x100fe200078e0208ULL, 0x00000016141c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001191a7824ULL, 0x000fe200078e0208ULL, 0x0000000a27167211ULL, 0x000fe200078e70ffULL,
0x0000000819237824ULL, 0x000fe200078e00ffULL, 0x0000000718217812ULL, 0x000fe200078ec0ffULL,
0x00000001151d7824ULL, 0x000fe200000e0617ULL, 0x0000001611207211ULL, 0x000fe200078e68ffULL,
0x0000000124177824ULL, 0x000fe200078e0219ULL, 0x0000001e1f00720cULL, 0x080fe20003f06070ULL,
0x000000101f2b7836ULL, 0x000fe20000000000ULL, 0x0000001e1900720cULL, 0x000fe20003f26070ULL,
0x0000010017167825ULL, 0x000fe200078e0012ULL, 0x0001600020207810ULL, 0x000fc40007ffe0ffULL,
0x0ffffff821217812ULL, 0x000fe200078ef808ULL, 0x000000081f257836ULL, 0x000fe20000000000ULL,
0x0000001614167210ULL, 0x000fe20007f5e0ffULL, 0x0000000c1f297836ULL, 0x000fe20000000000ULL,
0xfffffff823237812ULL, 0x000fe200078ee21aULL, 0x0000001021217824ULL, 0x000fe200078e0220ULL,
0x0000001e2500720cULL, 0x000fe20003fa6070ULL, 0x0000000115177824ULL, 0x000fe200010e0617ULL,
0x0000002023237211ULL, 0x000fe200078e20ffULL, 0x00000001242d7824ULL, 0x040fe200078e022bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c217faeULL, 0x0003e2000c101c46ULL,
0x0000000124197824ULL, 0x040fe200078e0225ULL, 0x0000000325227819ULL, 0x000fe200000006ffULL,
0x00000001241b7824ULL, 0x000fe200078e0229ULL, 0x0000000016237faeULL, 0x0005e2000c901c46ULL,
0x000000141f2f7836ULL, 0x000fe20000000000ULL, 0x0000001e2900720cULL, 0x080fe20003f86070ULL,
0x0000010019187825ULL, 0x000fe200078e0012ULL, 0x0000001e3100720cULL, 0x000fc60003f26070ULL,
0x000001001b1a7825ULL, 0x000fe200078e0012ULL, 0x0000001814187210ULL, 0x000fc60007f7e0ffULL,
0x00000001291d7824ULL, 0x002fe200078e0208ULL, 0x0000001a141a7210ULL, 0x000fe20007f5e0ffULL,
0x000001002d167825ULL, 0x004fc800078e0012ULL, 0x0000000829267824ULL, 0x000fe200078e00ffULL,
0x00000016141c7210ULL, 0x000fe20007fde0ffULL, 0x0000001c1f337836ULL, 0x000fe20000000000ULL,
0x000000032f297819ULL, 0x000fe200000006ffULL, 0x00000001251f7824ULL, 0x000fe200078e0208ULL,
0xfffffff826237812ULL, 0x000fe200078ee21dULL, 0x0000000124257824ULL, 0x000fe200078e022fULL,
0x00000017151d7210ULL, 0x000fe200037fe4ffULL, 0x0000000115197824ULL, 0x000fe200018e0619ULL,
0xfffffff822217812ULL, 0x000fe200078ee21fULL, 0x0000010025167825ULL, 0x000fe200078e0012ULL,
0x0000001e2b00720cULL, 0x000fc40003f66070ULL, 0x0000001e3300720cULL, 0x080fe20003f06070ULL,
0x00000001151b7824ULL, 0x000fe200010e061bULL, 0x0000001e2f00720cULL, 0x000fe20003f46070ULL,
0x000000012b1f7824ULL, 0x140fe200078e0208ULL, 0x00000016141e7210ULL, 0x000fe20007fde0ffULL,
0x000000082b267824ULL, 0x000fe400078e00ffULL, 0x00000001242b7824ULL, 0x000fe400078e0231ULL,
0x000000012f227824ULL, 0x000fe200078e0208ULL, 0xfffffff826257812ULL, 0x000fe200078ee21fULL,
0x00000001151f7824ULL, 0x000fc400030e0617ULL, 0x000001002b167825ULL, 0x000fe200078e0012ULL,
0xfffffff829297812ULL, 0x000fe400078ee222ULL, 0x0000000831227210ULL, 0x000fe20007ffe0ffULL,
0x00000001242d7824ULL, 0x000fe200078e0233ULL, 0x0000001614167210ULL, 0x000fe20007fde0ffULL,
0x00000008312b7824ULL, 0x000fe200078e00ffULL, 0x0000002029297211ULL, 0x000fe200078e20ffULL,
0x0000000133247824ULL, 0x040fe200078e0208ULL, 0x0000001715177210ULL, 0x000fe200037fe4ffULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee222ULL,
0x000001002d127825ULL, 0x000fc600078e0012ULL, 0xfffffff8332d7812ULL, 0x000fe200078ee224ULL,
0x0000001021217824ULL, 0x100fe200078e0220ULL, 0x0000001214127210ULL, 0x000fe20007fde0ffULL,
0x0000001023237824ULL, 0x100fe400078e0220ULL, 0x0000001025257824ULL, 0x100fe200078e0220ULL,
0x0000000018217faeULL, 0x0003e2000e901c46ULL, 0x000000102b2b7824ULL, 0x100fe400078e0220ULL,
0x000000102d2d7824ULL, 0x000fe200078e0220ULL, 0x000000001a237faeULL, 0x0003e2000e101c46ULL,
0x0000000115137824ULL, 0x000fc600030e0613ULL, 0x000000001c257faeULL, 0x0003e8000d901c46ULL,
0x000000001e297faeULL, 0x0003e8000d101c46ULL, 0x00000000162b7faeULL, 0x0003e8000c901c46ULL,
0x00000000122d7faeULL, 0x0003e2000c101c46ULL, 0x0000000400607947ULL, 0x000fea0003800000ULL,
0x0000000408137811ULL, 0x040fe400078fe8ffULL, 0x00000008081b7811ULL, 0x040fe400078fe8ffULL,
0x0000001408217811ULL, 0x040fe200078fe8ffULL, 0x0000000813197824ULL, 0x000fe200078e00ffULL,
0x0000000c081d7811ULL, 0x040fe200078fe8ffULL, 0x000000011b177824ULL, 0x140fe200078e0208ULL,
0x0000000813167210ULL, 0x000fe20007ffe0ffULL, 0x000000081b287824ULL, 0x000fe200078e00ffULL,
0x00000010081f7811ULL, 0x040fe200078fe8ffULL, 0x0000000821297824ULL, 0x000fe200078e00ffULL,
0x0000001808237811ULL, 0x000fe200078fe8ffULL, 0x000000081d257824ULL, 0x000fe200078e00ffULL,
0xfffffff819267812ULL, 0x000fe200078ee216ULL, 0x000000081f2c7824ULL, 0x000fe200078e00ffULL,
0x0000000821187210ULL, 0x000fe20007ffe0ffULL, 0x0000000123197824ULL, 0x140fe200078e0208ULL,
0x000000081d167210ULL, 0x000fe20007ffe0ffULL, 0x0000000823307824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee217ULL, 0x000000011f177824ULL, 0x000fe200078e0208ULL,
0xfffffff8292e7812ULL, 0x000fe200078ee218ULL, 0x00000001241d7824ULL, 0x040fe200078e021dULL,
0xfffffff8252a7812ULL, 0x000fe200078ee216ULL, 0x0000000124257824ULL, 0x000fe200078e0223ULL,
0x0000007012227812ULL, 0x000fe200078ec0ffULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x0000001c08297811ULL, 0x000fe200078fe8ffULL, 0x00000001241f7824ULL, 0x000fe200078e021fULL,
0x0000000808127211ULL, 0x000fe200078fe8ffULL, 0x0000008011227824ULL, 0x000fe200078e0222ULL,
0x0000000a27167211ULL, 0x000fe200078e70ffULL, 0x00000008292b7824ULL, 0x000fe200078e00ffULL,
0xfffffff82c2c7812ULL, 0x000fe200078ee217ULL, 0x0000000124217824ULL, 0x040fe200078e0221ULL,
0xfffffff830307812ULL, 0x000fe200078ee219ULL, 0x0000000124197824ULL, 0x000fe200078e0213ULL,
0x0000000712177812ULL, 0x000fe200078ec0ffULL, 0x0000200011167824ULL, 0x000fe200078e0216ULL,
0x0000000829127210ULL, 0x000fe20007ffe0ffULL, 0x0000000124297824ULL, 0x000fe200078e0229ULL,
0x0000002408137211ULL, 0x000fc400078fe8ffULL, 0x0000001b241b7210ULL, 0x000fe40007ffe0ffULL,
0xfffffff82b327812ULL, 0x000fe200078ee212ULL, 0x0000010013127825ULL, 0x100fe200078e0022ULL,
0x0ffffff817247812ULL, 0x000fe400078ef808ULL, 0x0001600016357810ULL, 0x000fe20007ffe0ffULL,
0x0000010019167825ULL, 0x100fe200078e0022ULL, 0x0000001214127210ULL, 0x000fe40007f1e0ffULL,
0x00000035282b7211ULL, 0x000fe200078e20ffULL, 0x000001001b187825ULL, 0x000fe200078e0022ULL,
0x0000001614167210ULL, 0x000fc40007f3e0ffULL, 0x0000003530337211ULL, 0x000fe200078e20ffULL,
0x000001001d1a7825ULL, 0x000fe200078e0022ULL, 0x0000001814187210ULL, 0x000fc60007f5e0ffULL,
0x000001001f1c7825ULL, 0x100fe200078e0022ULL, 0x0000001a141a7210ULL, 0x000fe40007f7e0ffULL,
0x0000001915197210ULL, 0x000fe200017fe4ffULL, 0x00000100211e7825ULL, 0x000fc800078e0022ULL,
0x0000010025207825ULL, 0x000fc800078e0022ULL, 0x0000010029227825ULL, 0x000fe200078e0022ULL,
0x0000002014207210ULL, 0x000fc60007f5e0ffULL, 0x0000000115137824ULL, 0x040fe200000e0613ULL,
0x0000001c141c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000115177824ULL, 0x040fe200008e0617ULL,
0x0000001e141e7210ULL, 0x000fe20007f3e0ffULL, 0x0000001024257824ULL, 0x100fe200078e0235ULL,
0x0000002115217210ULL, 0x000fe200017fe4ffULL, 0x0000001026297824ULL, 0x000fe400078e0235ULL,
0x00000001151b7824ULL, 0x000fe200018e061bULL, 0x0000002214147210ULL, 0x000fe20007f7e0ffULL,
0x000000102a2d7824ULL, 0x100fe200078e0235ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012257faeULL, 0x0003e2000b901c46ULL, 0x000000102c2f7824ULL, 0x000fc400078e0235ULL,
0x00000001151d7824ULL, 0x040fe200000e061dULL, 0x0000000016297faeULL, 0x0003e2000b901c46ULL,
0x000000102e317824ULL, 0x000fe400078e0235ULL, 0x00000001151f7824ULL, 0x040fe200008e061fULL,
0x00000000182b7faeULL, 0x0003e2000b901c46ULL, 0x0000001032357824ULL, 0x000fe400078e0235ULL,
0x0000000115157824ULL, 0x000fe200018e0623ULL, 0x000000001a2d7faeULL, 0x0003e8000b901c46ULL,
0x000000001c2f7faeULL, 0x0003e8000b901c46ULL, 0x000000001e317faeULL, 0x0003e8000b901c46ULL,
0x0000000020337faeULL, 0x0003e8000b901c46ULL, 0x0000000014357faeULL, 0x0003e4000b901c46ULL,
0x0000000337137812ULL, 0x002fe200078ec0ffULL, 0xffffffffff847424ULL, 0x000fe200078e00ffULL,
0xfffffffd00127811ULL, 0x000fe200078e10ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000031300780cULL, 0x000fc80003f05270ULL, 0x0000000112867807ULL, 0x000fca0004000000ULL,
0x0000000137867824ULL, 0x000fca00078e0286ULL, 0x0000000b8600720cULL, 0x000fda0003f06070ULL,
0x00009400ff168b82ULL, 0x000e620000000800ULL, 0x000000029b138824ULL, 0x000fce00078e00ffULL,
0x00009000ff148b82ULL, 0x000ea20000000a00ULL, 0x0000001613138224ULL, 0x002fca00078e0216ULL,
0x0000008613138210ULL, 0x000fca0007ffe0ffULL, 0x0000000413148825ULL, 0x004fca00078e0014ULL,
0x0000000614848981ULL, 0x000322000c1e1900ULL, 0x0000000c0500720cULL, 0x000fe20003f06070ULL,
0xff317217ff887424ULL, 0x000fe200078e00ffULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff857224ULL, 0x000fe200078e00ffULL, 0x00000000003c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fc4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x00000000004a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fe4000001ff00ULL,
0x00000000004e7805ULL, 0x000fe4000001ff00ULL, 0x00000000004c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000527805ULL, 0x000fc4000001ff00ULL, 0x0000000000507805ULL, 0x000fe4000001ff00ULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x0000000000547805ULL, 0x000fe4000001ff00ULL,
0x00000000005a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000587805ULL, 0x000fe4000001ff00ULL,
0x00000000005e7805ULL, 0x000fc4000001ff00ULL, 0x00000000005c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000627805ULL, 0x000fe4000001ff00ULL, 0x0000000000607805ULL, 0x000fe4000001ff00ULL,
0x00000000007a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000787805ULL, 0x000fe4000001ff00ULL,
0x00000000007e7805ULL, 0x000fc4000001ff00ULL, 0x00000000007c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000767805ULL, 0x000fe4000001ff00ULL, 0x0000000000747805ULL, 0x000fe4000001ff00ULL,
0x00000000006a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000687805ULL, 0x000fe4000001ff00ULL,
0x00000000002e7805ULL, 0x000fc4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000327805ULL, 0x000fe4000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000074008c0947ULL, 0x002fec0003800000ULL, 0x00009400ff147b82ULL, 0x000e620000000800ULL,
0x000000019b137819ULL, 0x000fe200000006ffULL, 0xff317217ff887424ULL, 0x000fe400078e00ffULL,
0x000000ffff3f7224ULL, 0x000fe400078e00ffULL, 0x0000001413137224ULL, 0x002fce00078e0214ULL,
0x00008e00ff147b82ULL, 0x000e620000000a00ULL, 0x0000001003177824ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x00000001051b7836ULL, 0x000fe40000000000ULL,
0x0000000484847c24ULL, 0x010fe2000f8e02ffULL, 0xffffffe017187812ULL, 0x000fe400078ec0ffULL,
0x0000000c1b00720cULL, 0x000fe20003f06070ULL, 0x0000004084197824ULL, 0x000fe200078e00ffULL,
0x0000001805187211ULL, 0x000fca00078e40ffULL, 0x0000004018187836ULL, 0x000fca0000000000ULL,
0x0000002018177812ULL, 0x000fe200078ec0ffULL, 0x0000010019147825ULL, 0x002fc600078e0014ULL,
0x0000001710357210ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400a08947ULL, 0x000fea0003800000ULL, 0x0000001008197824ULL, 0x000fe200078e00ffULL,
0x0000001809177248ULL, 0x000fe20007fe0000ULL, 0x000000ffff1a7224ULL, 0x000fe200078e0a18ULL,
0x00000003ff267819ULL, 0x100fe20000011608ULL, 0x0000008003187824ULL, 0x000fe200078e00ffULL,
0x0000007019197812ULL, 0x000fe200078ec0ffULL, 0x00002000031c7824ULL, 0x000fe200078e00ffULL,
0x00000035261b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000126217824ULL, 0x000fe200078e0208ULL,
0x0000008019187812ULL, 0x000fe200078ef818ULL, 0x0000000426287836ULL, 0x000fe20000000000ULL,
0x000000ff00197202ULL, 0x000fe20000000f00ULL, 0x0000400027277824ULL, 0x000fe200078e020aULL,
0x0000002017177446ULL, 0x000fe2000380001aULL, 0x0000000128237824ULL, 0x000fe200078e0235ULL,
0x000020001c1c7812ULL, 0x000fe200078ec0ffULL, 0x000001001b1a7825ULL, 0x000fe200078e0018ULL,
0x0000000721217812ULL, 0x000fc400078ec0ffULL, 0x000000172600720cULL, 0x080fe20003f26070ULL,
0x0000010023227825ULL, 0x000fe200078e0018ULL, 0x0000001a141a7210ULL, 0x000fe40007f1e0ffULL,
0x00017000271c7810ULL, 0x000fe20007ffe01cULL, 0x00000008282a7824ULL, 0x040fe200078e00ffULL,
0x0ffffff821217812ULL, 0x000fe200078ef808ULL, 0x00000001151b7824ULL, 0x000fe200000e061bULL,
0x0000002214247210ULL, 0x000fe20007f5e0ffULL, 0x0000001426347836ULL, 0x000fe20000000000ULL,
0x0000000826227810ULL, 0x000fe20007ffe0ffULL, 0x0000001021217824ULL, 0x000fe200078e021cULL,
0x0000000828257210ULL, 0x000fe20007ffe0ffULL, 0x0000001c26387836ULL, 0x000fe20000000000ULL,
0x000000172800720cULL, 0x080fe20003f06070ULL, 0x00000008222b7824ULL, 0x040fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a217faeULL, 0x0003e2000c901c46ULL,
0xfffffff82a277812ULL, 0x000fe200078ee225ULL, 0x0000000c26287836ULL, 0x000fe20000000000ULL,
0x0000001826367810ULL, 0x000fe20007ffe0ffULL, 0x0000000115257824ULL, 0x000fe200010e0623ULL,
0x000000172200720cULL, 0x080fe20003fc6070ULL, 0x00000010262a7836ULL, 0x000fe20000000000ULL,
0x00000003283a7819ULL, 0x040fe200000006ffULL, 0x0000000128237824ULL, 0x140fe200078e0235ULL,
0x000000172800720cULL, 0x080fe20003fa6070ULL, 0x000000082a397824ULL, 0x040fe200078e00ffULL,
0x000000172a00720cULL, 0x080fe20003f86070ULL, 0x00000001221a7824ULL, 0x142fe200078e0208ULL,
0x0000001c27217211ULL, 0x000fe200078e20ffULL, 0x00000001221b7824ULL, 0x000fe200078e0235ULL,
0x000000173400720cULL, 0x080fe20003f66070ULL, 0x0000000128277824ULL, 0x000fe200078e0208ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee21aULL, 0x000001001b1a7825ULL, 0x000fe200078e0018ULL,
0x0000000024217faeULL, 0x0003e2000c101c46ULL, 0x000000173600720cULL, 0x000fc40003f46070ULL,
0x0000010023227825ULL, 0x000fe200078e0018ULL, 0x0000001a14267210ULL, 0x000fe40007f1e0ffULL,
0x000000173800720cULL, 0x000fe20003f26070ULL, 0x000000012a177824ULL, 0x040fe200078e0235ULL,
0xfffffff83a377812ULL, 0x000fe200078ee227ULL, 0x000000012a287824ULL, 0x000fe200078e0208ULL,
0x0000001b15277210ULL, 0x000fe200007fe4ffULL, 0x00000100171a7825ULL, 0x000fe200078e0018ULL,
0x0000002214247210ULL, 0x002fe40007f1e0ffULL, 0xfffffff839397812ULL, 0x000fe200078ee228ULL,
0x0000000134217824ULL, 0x040fe200078e0208ULL, 0x0000002315257210ULL, 0x000fe200007fe4ffULL,
0x0000000834227824ULL, 0x040fe200078e00ffULL, 0x0000001a14287210ULL, 0x000fe20007f1e0ffULL,
0x0000000134177824ULL, 0x000fe200078e0235ULL, 0x00000008362a7210ULL, 0x000fe20007ffe0ffULL,
0x0000000836657824ULL, 0x000fe200078e00ffULL, 0xfffffff8223b7812ULL, 0x000fe200078ee221ULL,
0x0000010017227825ULL, 0x000fc600078e0018ULL, 0xfffffff865657812ULL, 0x000fe200078ee22aULL,
0x0000000136217824ULL, 0x000fe400078e0235ULL, 0x0000000115297824ULL, 0x000fe200000e061bULL,
0x0000002214227210ULL, 0x000fe20007f1e0ffULL, 0x00000100211a7825ULL, 0x000fc600078e0018ULL,
0x0000002315237210ULL, 0x000fe200007fe4ffULL, 0x0000000138177824ULL, 0x040fe200078e0235ULL,
0x0000001a141a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000138217824ULL, 0x040fe400078e0208ULL,
0x0000000838387824ULL, 0x000fe400078e00ffULL, 0x0000010017187825ULL, 0x000fc600078e0018ULL,
0xfffffff838677812ULL, 0x000fe200078ee221ULL, 0x00000001151b7824ULL, 0x000fe200000e061bULL,
0x0000001814147210ULL, 0x000fe20007f1e0ffULL, 0x000000102b177824ULL, 0x100fe200078e021cULL,
0x0000001c392b7211ULL, 0x000fe200078e20ffULL, 0x0000001037217824ULL, 0x100fe200078e021cULL,
0x0000001915157210ULL, 0x000fe200007fe4ffULL, 0x000000103b357824ULL, 0x100fe200078e021cULL,
0x0000000026177faeULL, 0x0003e2000f101c46ULL, 0x0000001065377824ULL, 0x100fe400078e021cULL,
0x0000001067397824ULL, 0x000fe200078e021cULL, 0x0000000024217faeULL, 0x0003e8000e901c46ULL,
0x00000000282b7faeULL, 0x0003e8000e101c46ULL, 0x0000000022357faeULL, 0x0003e8000d901c46ULL,
0x000000001a377faeULL, 0x0003e8000d101c46ULL, 0x0000000014397faeULL, 0x0003e2000c901c46ULL,
0x00000004006c7947ULL, 0x000fea0003800000ULL, 0x0000200003187824ULL, 0x040fe200078e00ffULL,
0x00000004081b7811ULL, 0x040fe200078fe8ffULL, 0x0000001008177824ULL, 0x000fe200078e00ffULL,
0x0000000703347819ULL, 0x000fe200000006ffULL, 0x0000400027277824ULL, 0x000fe200078e020aULL,
0x0000200018187812ULL, 0x000fe200078ec0ffULL, 0x000000011b197824ULL, 0x000fe200078e0208ULL,
0x0000007017177812ULL, 0x000fe200078ec0ffULL, 0x000000081b1a7824ULL, 0x040fe200078e00ffULL,
0x0000000808237811ULL, 0x000fe200078fe8ffULL, 0x000000011b1b7824ULL, 0x000fe200078e0235ULL,
0x0001700027187810ULL, 0x000fc40007ffe018ULL, 0x0000000c08257811ULL, 0x040fe400078fe8ffULL,
0x0000008017347812ULL, 0x000fe200078ef834ULL, 0x0000000123177824ULL, 0x100fe200078e0208ULL,
0x0000001008277811ULL, 0x040fe200078fe8ffULL, 0x0000000825227824ULL, 0x000fe200078e00ffULL,
0x00000003231c7819ULL, 0x000fe400000006ffULL, 0xfffffff81a217812ULL, 0x000fe200078ee219ULL,
0x0000000125197824ULL, 0x100fe200078e0208ULL, 0x0000001408297811ULL, 0x040fe200078fe8ffULL,
0x00000001271a7824ULL, 0x100fe200078e0208ULL, 0x0000001c086d7811ULL, 0x040fe200078fe8ffULL,
0x0000000125257824ULL, 0x100fe200078e0235ULL, 0x00000003273b7819ULL, 0x040fe200000006ffULL,
0x0000000127277824ULL, 0x100fe200078e0235ULL, 0xfffffff81c377812ULL, 0x000fe200078ee217ULL,
0x000000016d1c7824ULL, 0x140fe200078e0208ULL, 0x00000018082b7811ULL, 0x040fe200078fe8ffULL,
0x000000086d6f7824ULL, 0x040fe200078e00ffULL, 0x0000000808177211ULL, 0x040fe200078fe8ffULL,
0x000000016d6d7824ULL, 0x100fe200078e0235ULL, 0xfffffff822397812ULL, 0x000fe200078ee219ULL,
0x0000000129197824ULL, 0x140fe200078e0208ULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee21aULL,
0x0000000829227824ULL, 0x000fe200078e00ffULL, 0x0000000717177812ULL, 0x000fe200078ec0ffULL,
0x000000012b1a7824ULL, 0x040fe200078e0208ULL, 0x000000032b677819ULL, 0x000fe200000006ffULL,
0x0000000129297824ULL, 0x000fe200078e0235ULL, 0xfffffff822657812ULL, 0x000fe200078ee219ULL,
0x0000001021217824ULL, 0x100fe200078e0218ULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee21cULL,
0x0000001039397824ULL, 0x100fe200078e0218ULL, 0x0ffffff817177812ULL, 0x000fe200078ef808ULL,
0x000000103b3b7824ULL, 0x100fe200078e0218ULL, 0xfffffff867677812ULL, 0x000fe200078ee21aULL,
0x0000001065657824ULL, 0x100fe200078e0218ULL, 0x0000003523237210ULL, 0x000fe20007ffe0ffULL,
0x0000001017177824ULL, 0x100fe200078e0218ULL, 0x000000352b2b7210ULL, 0x000fe20007ffe0ffULL,
0x000000106f6f7824ULL, 0x000fe200078e0218ULL, 0x0000003508197211ULL, 0x000fe200078fe8ffULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x0000001837377211ULL, 0x000fc400078e20ffULL,
0x0000001867677211ULL, 0x000fe200078e20ffULL, 0x0000010019187825ULL, 0x000fc800078e0034ULL,
0x0000010023227825ULL, 0x000fe200078e0034ULL, 0x0000001814187210ULL, 0x000fc60007f1e0ffULL,
0x000001001b1a7825ULL, 0x000fe200078e0034ULL, 0x0000002214227210ULL, 0x000fc60007f5e0ffULL,
0x0000010025247825ULL, 0x000fe200078e0034ULL, 0x0000001a141a7210ULL, 0x000fc60007f3e0ffULL,
0x0000010027267825ULL, 0x100fe200078e0034ULL, 0x0000002414247210ULL, 0x000fe40007f7e0ffULL,
0x0000001b151b7210ULL, 0x000fe20000ffe4ffULL, 0x0000010029287825ULL, 0x000fc800078e0034ULL,
0x000001002b2a7825ULL, 0x000fe200078e0034ULL, 0x0000002814287210ULL, 0x000fc60007f3e0ffULL,
0x000001006d347825ULL, 0x000fe200078e0034ULL, 0x0000002915297210ULL, 0x000fc60000ffe4ffULL,
0x0000000115197824ULL, 0x040fe200000e0619ULL, 0x0000002614267210ULL, 0x000fe20007f1e0ffULL,
0x0000000115237824ULL, 0x040fe200010e0623ULL, 0x0000002a142a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000115257824ULL, 0x040fe200018e0625ULL, 0x0000003414147210ULL, 0x000fe20007f7e0ffULL,
0x0000000115277824ULL, 0x040fe200000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018177faeULL, 0x0003e2000b901c46ULL, 0x00000001152b7824ULL, 0x040fe400010e062bULL,
0x0000000115157824ULL, 0x000fe200018e0635ULL, 0x000000001a217faeULL, 0x0003e8000b901c46ULL,
0x0000000022377faeULL, 0x0003e8000b901c46ULL, 0x0000000024397faeULL, 0x0003e8000b901c46ULL,
0x00000000263b7faeULL, 0x0003e8000b901c46ULL, 0x0000000028657faeULL, 0x0003e8000b901c46ULL,
0x000000002a677faeULL, 0x0003e8000b901c46ULL, 0x00000000146f7faeULL, 0x0003e4000b901c46ULL,
0x0000000386147812ULL, 0x002fe200078ec0ffULL, 0xffffffffff827424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000031400780cULL, 0x000fc80003f05270ULL,
0x0000000112157807ULL, 0x000fca0004000000ULL, 0x0000000115867824ULL, 0x000fca00078e0286ULL,
0x0000000b8600720cULL, 0x000fda0003f06070ULL, 0x00009000ff148b82ULL, 0x000e620000000a00ULL,
0x0000008613178210ULL, 0x000fe40007ffe0ffULL, 0x000000100f187812ULL, 0x000fe200078ec0ffULL,
0x00000001ff1a7424ULL, 0x000fe400078e00ffULL, 0x0000000417148825ULL, 0x002fe200078e0014ULL,
0xffffffe00f177812ULL, 0x000fc800078ec0ffULL, 0x0000000a18177210ULL, 0x000fe20007ffe017ULL,
0x0000000614828981ULL, 0x000322000c1e1900ULL, 0x000000080f187812ULL, 0x000fca00078ec0ffULL,
0x0000000117177824ULL, 0x000fc800078e0218ULL, 0x01e6081a171a79a7ULL, 0x0002a6000850003fULL,
0x0000000000147805ULL, 0x002fce0000015200ULL, 0x01e6081b170075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ff001c7202ULL, 0x000fce0000000f00ULL,
0x000000101c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000187805ULL, 0x000fce0000015200ULL, 0x0000001814217210ULL, 0x000fca0007f1e1ffULL,
0x0000000119197824ULL, 0x000fe200000e0e15ULL, 0x003d09002100780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c402100780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff187819ULL, 0x000fc80000011419ULL,
0x0000002118187211ULL, 0x000fca00078110ffULL, 0x000000ffff197224ULL, 0x000fca00000e0619ULL,
0x0000000218187819ULL, 0x000fc80000001219ULL, 0x000000180000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000011c1c7836ULL, 0x000fce0000000000ULL,
0x01e6081b170075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000002003147824ULL, 0x000fe200078e00ffULL, 0x0000000408157819ULL, 0x000fe200000006ffULL,
0x000000ffff817224ULL, 0x000fe200078e0088ULL, 0x00000001ff187819ULL, 0x000fe40000011608ULL,
0x0000007015157812ULL, 0x000fe400078ec0ffULL, 0xffffff8014177812ULL, 0x000fe400078ec0ffULL,
0x0000000c18147812ULL, 0x000fe400078ec0ffULL, 0x0000000a15177210ULL, 0x000fca0007ffe017ULL,
0x0000000117177824ULL, 0x000fca00078e0214ULL, 0x01e0000017197984ULL, 0x000e680000000800ULL,
0x01e2000017847984ULL, 0x0004a20000000800ULL, 0x000000881900720bULL, 0x002fda0003f1d000ULL,
0x00000000001a7806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x000000ff1a00720cULL, 0x000fda0003f25270ULL, 0x00000004008c9947ULL, 0x004fea0003800000ULL,
0x000000030d00720cULL, 0x000fe40003f45270ULL, 0x000000881900720bULL, 0x0c0fe40003f34000ULL,
0x0000008819817209ULL, 0x000fd20007810000ULL, 0x0000000a0317a211ULL, 0x000fe400078e38ffULL,
0x00000000001b7806ULL, 0x000fe400008e0100ULL, 0x000000171418a210ULL, 0x000fe40007ffe015ULL,
0x000000ff1b00720cULL, 0x000fc60003f25270ULL, 0x01e400811800a388ULL, 0x0003f40000000800ULL,
0x0000000400509947ULL, 0x002fea0003800000ULL, 0x0000008881177221ULL, 0x000fe20000010100ULL,
0x000000ff1bff7812ULL, 0x040fe4000782c0ffULL, 0x0000ff001bff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b17177820ULL, 0x000fe20000410000ULL, 0x00ff00001bff7812ULL, 0x040fe4000786c0ffULL,
0xff0000001bff7812ULL, 0x000fe2000788c0ffULL, 0x0000001700187308ULL, 0x0002ac0000000800ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x00000002ff177819ULL, 0x002fcc0000011608ULL,
0x00001f1718177589ULL, 0x004e6400000e0000ULL, 0x0000001730307220ULL, 0x082fe20000410000ULL,
0x0000001731317220ULL, 0x080fe20000410000ULL, 0x000000172c2c7220ULL, 0x080fe20000410000ULL,
0x000000172d2d7220ULL, 0x080fe20000410000ULL, 0x0000001768687220ULL, 0x080fe20000410000ULL,
0x0000001769697220ULL, 0x080fe20000410000ULL, 0x0000001774747220ULL, 0x080fe20000410000ULL,
0x0000001775757220ULL, 0x080fe20000410000ULL, 0x000000177c7c7220ULL, 0x080fe20000410000ULL,
0x000000177d7d7220ULL, 0x080fe20000410000ULL, 0x0000001778787220ULL, 0x080fe20000410000ULL,
0x0000001779797220ULL, 0x080fe20000410000ULL, 0x0000001760607220ULL, 0x080fe20000410000ULL,
0x0000001761617220ULL, 0x080fe20000410000ULL, 0x000000175c5c7220ULL, 0x080fe20000410000ULL,
0x000000175d5d7220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x0000000808177811ULL, 0x002fcc00078ff0ffULL, 0x00001f1718177589ULL, 0x004e6400000e0000ULL,
0x0000001732327220ULL, 0x082fe20000410000ULL, 0x0000001733337220ULL, 0x080fe20000410000ULL,
0x000000172e2e7220ULL, 0x080fe20000410000ULL, 0x000000172f2f7220ULL, 0x080fe20000410000ULL,
0x000000176a6a7220ULL, 0x080fe20000410000ULL, 0x000000176b6b7220ULL, 0x080fe20000410000ULL,
0x0000001776767220ULL, 0x080fe20000410000ULL, 0x0000001777777220ULL, 0x080fe20000410000ULL,
0x000000177e7e7220ULL, 0x080fe20000410000ULL, 0x000000177f7f7220ULL, 0x080fe20000410000ULL,
0x000000177a7a7220ULL, 0x080fe20000410000ULL, 0x000000177b7b7220ULL, 0x080fe20000410000ULL,
0x0000001762627220ULL, 0x080fe20000410000ULL, 0x0000001763637220ULL, 0x080fe20000410000ULL,
0x000000175e5e7220ULL, 0x080fe20000410000ULL, 0x000000175f5f7220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x0000001008177811ULL, 0x002fcc00078ff0ffULL,
0x00001f1718177589ULL, 0x004e6400000e0000ULL, 0x0000001758587220ULL, 0x082fe20000410000ULL,
0x0000001759597220ULL, 0x080fe20000410000ULL, 0x0000001754547220ULL, 0x080fe20000410000ULL,
0x0000001755557220ULL, 0x080fe20000410000ULL, 0x0000001750507220ULL, 0x080fe20000410000ULL,
0x0000001751517220ULL, 0x080fe20000410000ULL, 0x000000174c4c7220ULL, 0x080fe20000410000ULL,
0x000000174d4d7220ULL, 0x080fe20000410000ULL, 0x0000001748487220ULL, 0x080fe20000410000ULL,
0x0000001749497220ULL, 0x080fe20000410000ULL, 0x0000001744447220ULL, 0x080fe20000410000ULL,
0x0000001745457220ULL, 0x080fe20000410000ULL, 0x0000001740407220ULL, 0x080fe20000410000ULL,
0x0000001741417220ULL, 0x080fe20000410000ULL, 0x000000173c3c7220ULL, 0x080fe20000410000ULL,
0x000000173d3d7220ULL, 0x000fce0000410000ULL, 0x0000001885857220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x0000001808177811ULL, 0x002fcc00078ff0ffULL,
0x00001f1718177589ULL, 0x000e6400000e0000ULL, 0x000000175a5a7220ULL, 0x082fe20000410000ULL,
0x000000175b5b7220ULL, 0x080fe20000410000ULL, 0x0000001756567220ULL, 0x080fe20000410000ULL,
0x0000001757577220ULL, 0x080fe20000410000ULL, 0x0000001752527220ULL, 0x080fe20000410000ULL,
0x0000001753537220ULL, 0x080fe20000410000ULL, 0x000000174e4e7220ULL, 0x080fe20000410000ULL,
0x000000174f4f7220ULL, 0x080fe20000410000ULL, 0x000000174a4a7220ULL, 0x080fe20000410000ULL,
0x000000174b4b7220ULL, 0x080fe20000410000ULL, 0x0000001746467220ULL, 0x080fe20000410000ULL,
0x0000001747477220ULL, 0x080fe20000410000ULL, 0x0000001742427220ULL, 0x080fe20000410000ULL,
0x0000001743437220ULL, 0x080fe20000410000ULL, 0x000000173e3e7220ULL, 0x080fe20000410000ULL,
0x000000173f3f7220ULL, 0x000fce0000410000ULL, 0x0000001b1aff7212ULL, 0x000fda00078230ffULL,
0x8000008119191221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b19191820ULL, 0x000fc80000410000ULL, 0x0000001900161308ULL, 0x000ea40000000800ULL,
0x0000001684841220ULL, 0x004fce0000410000ULL, 0x0000000203837824ULL, 0x040fe200078e00ffULL,
0x0000000808177812ULL, 0x002fe200078ec0ffULL, 0x0000200003807824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000000483877812ULL, 0x000fe400078ec0ffULL,
0x0000000717237812ULL, 0x000fe400078ef808ULL, 0x0000008708187211ULL, 0x040fe400078fe0ffULL,
0x00000010238b7812ULL, 0x040fe200078efcffULL, 0x0000000823227824ULL, 0x040fe200078e00ffULL,
0x00000023081c7211ULL, 0x000fe200078fe0ffULL, 0x00000008231a7824ULL, 0x000fe200078e00ffULL,
0x0000001823177210ULL, 0x000fe20007ffe0ffULL, 0x0000000118187824ULL, 0x000fe200078e028bULL,
0x000000021c197810ULL, 0x000fe20007ffe0ffULL, 0x000000088b1b7824ULL, 0x000fe200078e00ffULL,
0xffffc00080217812ULL, 0x000fe200078ec0ffULL, 0x0000000823257824ULL, 0x000fe200078e00ffULL,
0xfffffff822197812ULL, 0x000fe200078ee219ULL, 0x000000041c247836ULL, 0x000fe20000000000ULL,
0xfffffff81b187812ULL, 0x000fe200078ee218ULL, 0x000000010a227824ULL, 0x000fe200078e0221ULL,
0xfffffff81a177812ULL, 0x000fe200078ee217ULL, 0x00000400031b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8251a7812ULL, 0x000fe200078ee21cULL, 0x0000000823297824ULL, 0x040fe200078e00ffULL,
0x0000000323277819ULL, 0x000fe200000006ffULL, 0x000000061c1c7836ULL, 0x000fe20000000000ULL,
0x0000002211227211ULL, 0x000fc400078e68ffULL, 0xfffff0001b217812ULL, 0x000fe400078ec0ffULL,
0xfffffff8271b7812ULL, 0x000fe200078ee224ULL, 0x0001600022247836ULL, 0x000fe20000000000ULL,
0xfffffff8291c7812ULL, 0x000fe400078ee21cULL, 0x000120000a897810ULL, 0x000fe20007ffe021ULL,
0x0000000000288947ULL, 0x000fec0003800000ULL, 0x00000002ff267819ULL, 0x000fe40000011608ULL,
0x00000016ff1d723eULL, 0x000fe400000000ffULL, 0x0000001826207810ULL, 0x000fe20007ffe0ffULL,
0x00000008261e7836ULL, 0x000fe20000000000ULL, 0x000054101d217816ULL, 0x000fe2000000001dULL,
0x0000001026227836ULL, 0x000fc80000000000ULL, 0x00001f1e211e7589ULL, 0x0002a800000e0000ULL,
0x00001f22211d7589ULL, 0x0002e800000e0000ULL, 0x00001f26211f7589ULL, 0x00026800000e0000ULL,
0x00001f2021207589ULL, 0x00026400000e0000ULL, 0x0000001017707824ULL, 0x100fe200078e0289ULL,
0x0000002419647211ULL, 0x000fe200078e20ffULL, 0x0000001018347824ULL, 0x000fe400078e0289ULL,
0x000000101a6c7824ULL, 0x100fe400078e0224ULL, 0x000000007070783bULL, 0x000ee20000000200ULL,
0x000000101b257824ULL, 0x000fc600078e0224ULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x0000000000208947ULL, 0x000fea0003800000ULL, 0x0000001f70707232ULL, 0x08afe40000000000ULL,
0x0000001f72727232ULL, 0x000fe40000000000ULL, 0x0000001e71717232ULL, 0x084fe40000000000ULL,
0x0000001e73737232ULL, 0x000fe40000000000ULL, 0x0000001d34347232ULL, 0x080fe40000000000ULL,
0x0000001d36367232ULL, 0x000fc40000000000ULL, 0x0000002035357232ULL, 0x080fe40000000000ULL,
0x0000002037377232ULL, 0x000fce0000000000ULL, 0x000000101c387824ULL, 0x000fe200078e0224ULL,
0x000000006464783bULL, 0x000f620000004200ULL, 0x0000000287877812ULL, 0x000fc600078efcffULL,
0x000000002524783bULL, 0x002e620000004200ULL, 0x0000008708227211ULL, 0x000fe400078fe0ffULL,
0x00000001ff877819ULL, 0x000fe20000011603ULL, 0x000000003838783bULL, 0x000e640000004200ULL,
0x0000000123217824ULL, 0x100fe400078e0222ULL, 0x000000006c6c783bULL, 0x000e620000004200ULL,
0x000000018b227824ULL, 0x000fe400078e0222ULL, 0x0000400087887824ULL, 0x000fe200078e020aULL,
0x000000647028723cULL, 0x028fec0000001868ULL, 0x00000024707c723cULL, 0x002fec000000187cULL,
0x000000243448723cULL, 0x004fec0000001848ULL, 0x000000643450723cULL, 0x000fe20000001850ULL,
0x0000000823247824ULL, 0x000fe200078e00ffULL, 0x000000038b257819ULL, 0x000fc400000006ffULL,
0x000000038b237819ULL, 0x040fe400000006ffULL, 0xfffffff824217812ULL, 0x000fe200078ee221ULL,
0x000000267078723cULL, 0x000fe20000001878ULL, 0x0000008b08247211ULL, 0x000fe200078fe0ffULL,
0x000000088b647824ULL, 0x000fe200078e00ffULL, 0xfffffff825227812ULL, 0x000fe400078ee222ULL,
0x0000000224257810ULL, 0x000fe20007ffe0ffULL, 0x000000387060723cULL, 0x000fe20000001860ULL,
0xfffffff823237812ULL, 0x000fca00078ee224ULL, 0x000000263444723cULL, 0x000fec0000001844ULL,
0x000000383440723cULL, 0x000fe20000001840ULL, 0x0000000424267836ULL, 0x000fe40000000000ULL,
0x0000000624277836ULL, 0x000fe20000000000ULL, 0xfffffff864247812ULL, 0x000fc400078ee225ULL,
0x0000006c7030723cULL, 0x000fe20000001830ULL, 0x000000088b397824ULL, 0x000fe400078e00ffULL,
0x0000200011387824ULL, 0x000fc600078e0288ULL, 0x0000006e702c723cULL, 0x000fe2000000182cULL,
0xfffffff839257812ULL, 0x000fe400078ee226ULL, 0x0001600038387810ULL, 0x000fc60007ffe0ffULL,
0x000000667074723cULL, 0x000fe40000001874ULL, 0x0000001023647824ULL, 0x100fe400078e0238ULL,
0x0000001025687824ULL, 0x000fe400078e0238ULL, 0x0000003a705c723cULL, 0x000fec000000185cULL,
0x0000006c3458723cULL, 0x000fe20000001858ULL, 0x0000001021707824ULL, 0x000fca00078e0289ULL,
0x0000006e3454723cULL, 0x000fe20000001854ULL, 0x000000007070783bULL, 0x000e620000000200ULL,
0x00000038246c7211ULL, 0x000fc800078e20ffULL, 0x00000066344c723cULL, 0x000fec000000184cULL,
0x0000003a343c723cULL, 0x000fe2000000183cULL, 0x000000088b667824ULL, 0x000fca00078e00ffULL,
0xfffffff866267812ULL, 0x000fe200078ee227ULL, 0x0000001022347824ULL, 0x000fcc00078e0289ULL,
0x000000003434783bULL, 0x000ea20000000200ULL, 0x0000000000208947ULL, 0x000ff40003800000ULL,
0x0000001f70707232ULL, 0x082fe40000000000ULL, 0x0000001f72727232ULL, 0x000fe40000000000ULL,
0x0000001e71717232ULL, 0x080fe40000000000ULL, 0x0000001e73737232ULL, 0x000fe40000000000ULL,
0x0000001d34347232ULL, 0x084fe40000000000ULL, 0x0000001d36367232ULL, 0x000fc40000000000ULL,
0x0000002035357232ULL, 0x080fe40000000000ULL, 0x0000002037377232ULL, 0x000fce0000000000ULL,
0x0000001026387824ULL, 0x000fe200078e0238ULL, 0x000000006464783bULL, 0x000ee20000004200ULL,
0xfffffff883837812ULL, 0x000fe200078ec0ffULL, 0x00000001ff277424ULL, 0x000fe200078e00ffULL,
0x0000850000047ab9ULL, 0x000fe20000000800ULL, 0x000000006c6c783bULL, 0x000fe20000004200ULL,
0x0000000482827c24ULL, 0x010fe4000f8e02ffULL, 0x0000008584847221ULL, 0x000fe20000010000ULL,
0x000000003838783bULL, 0x000f280000004200ULL, 0x000000006868783bULL, 0x000f620000004200ULL,
0x000000647030723cULL, 0x00afec0000001830ULL, 0x000000643458723cULL, 0x004fe20000001858ULL,
0x00008e00ff647b82ULL, 0x000e6a0000000a00ULL, 0x000000387060723cULL, 0x010fec0000001860ULL,
0x000000383440723cULL, 0x000fec0000001840ULL, 0x0000006c3450723cULL, 0x000fe20000001850ULL,
0x0000000105397836ULL, 0x000fe20000000000ULL, 0x000000830a387210ULL, 0x000fc80007ffe0ffULL,
0x0000000c3900720cULL, 0x000fe20003f06070ULL, 0x0000006e344c723cULL, 0x000fe2000000184cULL,
0x01e6882738ff79a7ULL, 0x0005ea000850003fULL, 0x000000683448723cULL, 0x020fec0000001848ULL,
0x0000006a3444723cULL, 0x000fec0000001844ULL, 0x000000663454723cULL, 0x000fec0000001854ULL,
0x0000003a343c723cULL, 0x000fec000000183cULL, 0x00000066702c723cULL, 0x000fe2000000182cULL,
0x0000000805347824ULL, 0x000fc400078e0287ULL, 0x0000004082357824ULL, 0x000fc600078e00ffULL,
0x0000008034387811ULL, 0x004fe200078e28ffULL, 0x0000006c7028723cULL, 0x000fe20000001828ULL,
0x0000010035347825ULL, 0x002fe400078e0064ULL, 0x0000002038377812ULL, 0x000fc600078ec0ffULL,
0x0000006e7074723cULL, 0x000fec0000001874ULL, 0x00000068707c723cULL, 0x000fec000000187cULL,
0x0000006a7078723cULL, 0x000fec0000001878ULL, 0x0000003a705c723cULL, 0x000fee000000185cULL,
0x0000003710717210ULL, 0x000fe20007ffe0ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400908947ULL, 0x000fde0003800000ULL, 0x000000ffff377224ULL, 0x000fe200078e0a38ULL,
0x00000003ff6f7819ULL, 0x100fe40000011608ULL, 0x0000003809367248ULL, 0x000fe20007fe0000ULL,
0x0000008003387824ULL, 0x000fe200078e00ffULL, 0x0000200080397812ULL, 0x000fe200078ec0ffULL,
0x000000046f3b7836ULL, 0x000fe20000000000ULL, 0x00000020366c7446ULL, 0x000fe20003800037ULL,
0x000000016f377824ULL, 0x100fe200078e0208ULL, 0x0001600088887810ULL, 0x000fe20007ffe039ULL,
0x000000013b3a7824ULL, 0x000fe200078e0208ULL, 0x0000008015367812ULL, 0x000fe200078ef838ULL,
0x000000016f397824ULL, 0x000fe200078e0271ULL, 0x00000007376b7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x000000033b737819ULL, 0x000fe200000006ffULL,
0x0000000c6f857836ULL, 0x000fe20000000000ULL, 0x000000086f837810ULL, 0x000fe20007ffe0ffULL,
0x0000010039387825ULL, 0x000fe200078e0036ULL, 0x0000006c3b00720cULL, 0x000fc40003f26070ULL,
0xfffffff873737812ULL, 0x000fe200078ee23aULL, 0x000000013b3b7824ULL, 0x100fe200078e0271ULL,
0x0000007183657210ULL, 0x000fe20007ffe0ffULL, 0x0000000185677824ULL, 0x000fe200078e0271ULL,
0x0000003834687210ULL, 0x000fe20007f5e0ffULL, 0x000001003b3a7825ULL, 0x100fe200078e0036ULL,
0x0000006c6f00720cULL, 0x000fe40003f06070ULL, 0x0ffffff86b6d7812ULL, 0x000fe200078ef808ULL,
0x0000010065647825ULL, 0x000fe200078e0036ULL, 0x0000003a346a7210ULL, 0x000fc40007f7e0ffULL,
0x000000106f877810ULL, 0x000fe20007ffe0ffULL, 0x0000010067667825ULL, 0x000fe200078e0036ULL,
0x000000886d6d7211ULL, 0x000fe400078e20ffULL, 0x0000006c8300720cULL, 0x080fe20003fa6070ULL,
0x0000000135697824ULL, 0x040fe200010e0639ULL, 0x0000006434387210ULL, 0x000fe20007f5e0ffULL,
0x00000001356b7824ULL, 0x040fe200018e063bULL, 0x00000066343a7210ULL, 0x000fe20007f7e0ffULL,
0x000000146f897836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000686d7faeULL, 0x0003e2000c101c46ULL, 0x0000000135397824ULL, 0x000fe200010e0665ULL,
0x0000006c8500720cULL, 0x080fe20003f86070ULL, 0x0000001073657824ULL, 0x000fe200078e0288ULL,
0x0000000385737819ULL, 0x000fe200000006ffULL, 0x00000001353b7824ULL, 0x000fe200018e0667ULL,
0x0000006c8700720cULL, 0x0c0fe20003f66070ULL, 0x0000000187677824ULL, 0x100fe200078e0271ULL,
0x000000006a657faeULL, 0x0005e2000c901c46ULL, 0x000000186f8b7836ULL, 0x000fe20000000000ULL,
0x0000006c8900720cULL, 0x0c0fe20003f46070ULL, 0x0000001c6f8d7836ULL, 0x000fe20000000000ULL,
0x00000008836e7210ULL, 0x000fe20007ffe0ffULL, 0x0000000189697824ULL, 0x002fe200078e0271ULL,
0x0000006c8b00720cULL, 0x080fe20003f26070ULL, 0x0000000185687824ULL, 0x000fe200078e0208ULL,
0x0000006c8d00720cULL, 0x000fe20003f06070ULL, 0x00000008836f7824ULL, 0x000fe200078e00ffULL,
0x00000003876c7819ULL, 0x000fe200000006ffULL, 0x0000000889857824ULL, 0x000fe200078e00ffULL,
0xfffffff873737812ULL, 0x000fe200078ee268ULL, 0x0000010067647825ULL, 0x004fe200078e0036ULL,
0xfffffff86f6f7812ULL, 0x000fc600078ee26eULL, 0x000000018b6b7824ULL, 0x100fe200078e0271ULL,
0x0000006434667210ULL, 0x000fe20007fde0ffULL, 0x00000001896a7824ULL, 0x000fe400078e0208ULL,
0x000000018d6d7824ULL, 0x000fe400078e0271ULL, 0x0000000135677824ULL, 0x000fe200030e0665ULL,
0xfffffff885857812ULL, 0x000fe200078ee26aULL, 0x0000010069647825ULL, 0x000fc800078e0036ULL,
0x0000000187697824ULL, 0x100fe200078e0208ULL, 0x0000006434687210ULL, 0x000fe20007fde0ffULL,
0x000000018b6a7824ULL, 0x040fe400078e0208ULL, 0x000000088b877824ULL, 0x000fe200078e00ffULL,
0xfffffff86c837812ULL, 0x000fe200078ee269ULL, 0x000000088d6c7824ULL, 0x000fe200078e00ffULL,
0x0000006535697210ULL, 0x000fe200037fe4ffULL, 0x000001006b647825ULL, 0x100fe200078e0036ULL,
0x000000088d6b7210ULL, 0x000fe40007ffe0ffULL, 0xfffffff887877812ULL, 0x000fe200078ee26aULL,
0x000001006d367825ULL, 0x000fe200078e0036ULL, 0x0000006434647210ULL, 0x000fc40007fde0ffULL,
0xfffffff86c897812ULL, 0x000fe200078ee26bULL, 0x000000106f6b7824ULL, 0x100fe200078e0288ULL,
0x00000088736d7211ULL, 0x080fe200078e20ffULL, 0x0000000135657824ULL, 0x000fe200030e0665ULL,
0x0000003634347210ULL, 0x000fe20007fde0ffULL, 0x00000010836f7824ULL, 0x100fe200078e0288ULL,
0x0000008889837211ULL, 0x000fe200078e20ffULL, 0x0000001085717824ULL, 0x100fe200078e0288ULL,
0x00000000386b7faeULL, 0x0003e2000e901c46ULL, 0x0000001087737824ULL, 0x000fe400078e0288ULL,
0x0000000135357824ULL, 0x000fe200030e0637ULL, 0x000000003a6d7faeULL, 0x0003e8000e101c46ULL,
0x00000000666f7faeULL, 0x0003e8000d901c46ULL, 0x0000000068717faeULL, 0x0003e8000d101c46ULL,
0x0000000064737faeULL, 0x0003e8000c901c46ULL, 0x0000000034837faeULL, 0x0003e2000c101c46ULL,
0x00000004005c7947ULL, 0x000fea0003800000ULL, 0x0000000408397811ULL, 0x040fe400078fe8ffULL,
0x00000008083b7811ULL, 0x000fe400078fe8ffULL, 0x0000200080377812ULL, 0x000fe200078ec0ffULL,
0x0000000139367824ULL, 0x140fe200078e0208ULL, 0x0000001008677811ULL, 0x040fe200078fe8ffULL,
0x0000000839657824ULL, 0x000fe200078e00ffULL, 0x0000001408697811ULL, 0x000fe200078fe8ffULL,
0x000000083b6b7824ULL, 0x000fe200078e00ffULL, 0x00016000888b7810ULL, 0x000fe20007ffe037ULL,
0x00000008676d7824ULL, 0x000fe200078e00ffULL, 0xfffffff865707812ULL, 0x000fe200078ee236ULL,
0x00000001693a7824ULL, 0x140fe200078e0208ULL, 0x0000000c08657811ULL, 0x040fe200078fe8ffULL,
0x00000008696f7824ULL, 0x000fe200078e00ffULL, 0x000000083b367210ULL, 0x000fe20007ffe0ffULL,
0x0000000139397824ULL, 0x100fe200078e0271ULL, 0x0000000867387210ULL, 0x000fe20007ffe0ffULL,
0x0000000165377824ULL, 0x040fe200078e0208ULL, 0xfffffff86b727812ULL, 0x000fe200078ee236ULL,
0x0000000865807824ULL, 0x000fe200078e00ffULL, 0x0000000808367211ULL, 0x000fe200078fe8ffULL,
0x000000013b3b7824ULL, 0x100fe200078e0271ULL, 0xfffffff86d827812ULL, 0x000fe200078ee238ULL,
0x0000000165657824ULL, 0x100fe200078e0271ULL, 0xfffffff880807812ULL, 0x000fe200078ee237ULL,
0x0000000169697824ULL, 0x000fe200078e0271ULL, 0xfffffff86f887812ULL, 0x000fe200078ee23aULL,
0x0000001082857824ULL, 0x000fe200078e028bULL, 0x0000001808377811ULL, 0x000fc400078fe8ffULL,
0x0000001c086f7811ULL, 0x000fe200078fe8ffULL, 0x0000001088877824ULL, 0x000fe200078e028bULL,
0x00000007366d7812ULL, 0x000fe200078ec0ffULL, 0x00000001376b7824ULL, 0x100fe200078e0271ULL,
0x00000007036c7819ULL, 0x000fe200000006ffULL, 0x0000000137367824ULL, 0x140fe200078e0208ULL,
0x0000000337737819ULL, 0x000fe200000006ffULL, 0x000000016f387824ULL, 0x040fe200078e0208ULL,
0x0ffffff86d6e7812ULL, 0x000fe200078ef808ULL, 0x000000086f837824ULL, 0x040fe200078e00ffULL,
0x00000080156c7812ULL, 0x000fe200078ef86cULL, 0x000000016f6f7824ULL, 0x000fe200078e0271ULL,
0x0000007108377211ULL, 0x000fc400078fe8ffULL, 0x000000ff006d7202ULL, 0x000fe40000000f00ULL,
0xfffffff8738a7812ULL, 0x000fe200078ee236ULL, 0x0000001072737824ULL, 0x000fe200078e028bULL,
0xfffffff8838c7812ULL, 0x000fe200078ee238ULL, 0x0000010037367825ULL, 0x100fe200078e006cULL,
0x0000007167677210ULL, 0x000fe40007ffe0ffULL, 0x0000008b80837211ULL, 0x000fe200078e20ffULL,
0x0000010039387825ULL, 0x000fe200078e006cULL, 0x0000003634367210ULL, 0x000fc60007f1e0ffULL,
0x000001003b3a7825ULL, 0x000fe200078e006cULL, 0x0000003834387210ULL, 0x000fc60007f3e0ffULL,
0x0000010065647825ULL, 0x000fe200078e006cULL, 0x0000003a343a7210ULL, 0x000fc60007f5e0ffULL,
0x0000010067667825ULL, 0x000fe200078e006cULL, 0x0000006434647210ULL, 0x000fc60007f7e0ffULL,
0x0000010069687825ULL, 0x000fe200078e006cULL, 0x0000006535657210ULL, 0x000fc60001ffe4ffULL,
0x000001006b6a7825ULL, 0x000fc800078e006cULL, 0x000001006f6c7825ULL, 0x000fc800078e006cULL,
0x0000000135377824ULL, 0x040fe200000e0637ULL, 0x0000006634667210ULL, 0x000fe20007f1e0ffULL,
0x0000000135397824ULL, 0x040fe200008e0639ULL, 0x0000006834687210ULL, 0x000fe20007f3e0ffULL,
0x000000106e6f7824ULL, 0x000fe400078e028bULL, 0x00000001353b7824ULL, 0x040fe200010e063bULL,
0x0000006a346a7210ULL, 0x000fe20007f5e0ffULL, 0x0000001070717824ULL, 0x000fe200078e028bULL,
0x0000006c34347210ULL, 0x000fe20007f7e0ffULL, 0x0000000135677824ULL, 0x040fe200000e0667ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000366f7faeULL, 0x0003e2000b901c46ULL,
0x0000000135697824ULL, 0x000fc400008e0669ULL, 0x000000108a897824ULL, 0x000fe200078e028bULL,
0x0000000038717faeULL, 0x0003e2000b901c46ULL, 0x00000001356b7824ULL, 0x000fe200010e066bULL,
0x0000008b8c8b7211ULL, 0x000fe400078e20ffULL, 0x0000006d35357210ULL, 0x000fe20001ffe4ffULL,
0x000000003a737faeULL, 0x0003e8000b901c46ULL, 0x0000000064837faeULL, 0x0003e8000b901c46ULL,
0x0000000066857faeULL, 0x0003e8000b901c46ULL, 0x0000000068877faeULL, 0x0003e8000b901c46ULL,
0x000000006a897faeULL, 0x0003e8000b901c46ULL, 0x00000000348b7faeULL, 0x0003e4000b901c46ULL,
0x0000000386347812ULL, 0x002fe200078ec0ffULL, 0xffffffffff827424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000033400780cULL, 0x000fc80003f05270ULL,
0x0000000112357807ULL, 0x000fca0004000000ULL, 0x0000000186867824ULL, 0x000fca00078e0235ULL,
0x0000000b8600720cULL, 0x000fda0003f06070ULL, 0x00009000ff348b82ULL, 0x000e620000000a00ULL,
0x0000000113378824ULL, 0x000fe200078e0286ULL, 0x000000100f367812ULL, 0x000fc600078ec0ffULL,
0x0000000437348825ULL, 0x002fe200078e0034ULL, 0xffffffe00f377812ULL, 0x000fc800078ec0ffULL,
0x0000000a36377210ULL, 0x000fe20007ffe037ULL, 0x0000000634828981ULL, 0x000322000c1e1900ULL,
0x000000080f367812ULL, 0x000fc800078ec0ffULL, 0x00000036373b7210ULL, 0x000fc80007ffe0ffULL,
0x01e628273b3879a7ULL, 0x0002a6000850003fULL, 0x0000000000347805ULL, 0x002fce0000015200ULL,
0x01e628393b0075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fce0000015200ULL,
0x0000003634367210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff277819ULL, 0x000fc80000011437ULL, 0x0000003627277211ULL, 0x000fca00078110ffULL,
0x000000ffff367224ULL, 0x000fca00000e0637ULL, 0x0000000227277819ULL, 0x000fc80000001236ULL,
0x000000270000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7810ULL, 0x000fce0007ffe0ffULL, 0x01e628393b0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000002003277824ULL, 0x000fca00078e00ffULL,
0xffffff8027277812ULL, 0x000fc800078ec0ffULL, 0x000000800a277810ULL, 0x000fc80007ffe027ULL,
0x0000002714277210ULL, 0x000fca0007ffe015ULL, 0x01e0000027347984ULL, 0x000e680000000800ULL,
0x01e2000027837984ULL, 0x0004a20000000800ULL, 0x000000813400720bULL, 0x002fda0003f1d000ULL,
0x0000000000357806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x000000ff3500720cULL, 0x000fda0003f25270ULL, 0x0000000400949947ULL, 0x004fea0003800000ULL,
0x000000010d367836ULL, 0x000fe20000000000ULL, 0x000000813400720bULL, 0x000fc80003f14000ULL,
0x000000033600720cULL, 0x000fda0003f25270ULL, 0x0000008003369824ULL, 0x000fe200078e020aULL,
0x0000008134279209ULL, 0x000fc80007810000ULL, 0x0000003614389210ULL, 0x000fe40007ffe015ULL,
0x0000000000367806ULL, 0x000fc600000e0100ULL, 0x01e4002738009388ULL, 0x0003e20000000800ULL,
0x000000ff3600720cULL, 0x000fda0003f05270ULL, 0x0000000400548947ULL, 0x002fea0003800000ULL,
0x0000008134387209ULL, 0x000fe40007810000ULL, 0x000000ff36ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0036ff7812ULL, 0x000fe2000782c0ffULL, 0x0000008138277221ULL, 0x000fe20000010100ULL,
0x00ff000036ff7812ULL, 0x040fe4000784c0ffULL, 0xff00000036ff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b27277820ULL, 0x000fc80000410000ULL, 0x0000002700377308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff387819ULL, 0x000fca0000011608ULL,
0x00001f3837277589ULL, 0x006e6400000e0000ULL, 0x0000003027307220ULL, 0x042fe20000410000ULL,
0x0000003127317220ULL, 0x040fe20000410000ULL, 0x0000002c272c7220ULL, 0x040fe20000410000ULL,
0x0000002d272d7220ULL, 0x040fe20000410000ULL, 0x0000002827287220ULL, 0x040fe20000410000ULL,
0x0000002927297220ULL, 0x040fe20000410000ULL, 0x0000007427747220ULL, 0x040fe20000410000ULL,
0x0000007527757220ULL, 0x040fe20000410000ULL, 0x0000007c277c7220ULL, 0x040fe20000410000ULL,
0x0000007d277d7220ULL, 0x040fe20000410000ULL, 0x0000007827787220ULL, 0x040fe20000410000ULL,
0x0000007927797220ULL, 0x040fe20000410000ULL, 0x0000006027607220ULL, 0x040fe20000410000ULL,
0x0000006127617220ULL, 0x040fe20000410000ULL, 0x0000005c275c7220ULL, 0x040fe20000410000ULL,
0x0000005d275d7220ULL, 0x000fce0000410000ULL, 0x0000000000489947ULL, 0x000fea0003800000ULL,
0x0000000808387811ULL, 0x000fca00078ff0ffULL, 0x00001f3837277589ULL, 0x006e6400000e0000ULL,
0x0000003227327220ULL, 0x042fe20000410000ULL, 0x0000003327337220ULL, 0x040fe20000410000ULL,
0x0000002e272e7220ULL, 0x040fe20000410000ULL, 0x0000002f272f7220ULL, 0x040fe20000410000ULL,
0x0000002a272a7220ULL, 0x040fe20000410000ULL, 0x0000002b272b7220ULL, 0x040fe20000410000ULL,
0x0000007627767220ULL, 0x040fe20000410000ULL, 0x0000007727777220ULL, 0x040fe20000410000ULL,
0x0000007e277e7220ULL, 0x040fe20000410000ULL, 0x0000007f277f7220ULL, 0x040fe20000410000ULL,
0x0000007a277a7220ULL, 0x040fe20000410000ULL, 0x0000007b277b7220ULL, 0x040fe20000410000ULL,
0x0000006227627220ULL, 0x040fe20000410000ULL, 0x0000006327637220ULL, 0x040fe20000410000ULL,
0x0000005e275e7220ULL, 0x040fe20000410000ULL, 0x0000005f275f7220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x0000001008387811ULL, 0x000fca00078ff0ffULL,
0x00001f3837277589ULL, 0x006e6400000e0000ULL, 0x0000005827587220ULL, 0x042fe20000410000ULL,
0x0000005927597220ULL, 0x040fe20000410000ULL, 0x0000005427547220ULL, 0x040fe20000410000ULL,
0x0000005527557220ULL, 0x040fe20000410000ULL, 0x0000005027507220ULL, 0x040fe20000410000ULL,
0x0000005127517220ULL, 0x040fe20000410000ULL, 0x0000004c274c7220ULL, 0x040fe20000410000ULL,
0x0000004d274d7220ULL, 0x040fe20000410000ULL, 0x0000004827487220ULL, 0x040fe20000410000ULL,
0x0000004927497220ULL, 0x040fe20000410000ULL, 0x0000004427447220ULL, 0x040fe20000410000ULL,
0x0000004527457220ULL, 0x040fe20000410000ULL, 0x0000004027407220ULL, 0x040fe20000410000ULL,
0x0000004127417220ULL, 0x040fe20000410000ULL, 0x0000003c273c7220ULL, 0x040fe20000410000ULL,
0x0000003d273d7220ULL, 0x000fce0000410000ULL, 0x0000003784847220ULL, 0x004fe20000410000ULL,
0x000000000048b947ULL, 0x000fec0003800000ULL, 0x0000001808387811ULL, 0x000fca00078ff0ffULL,
0x00001f3837277589ULL, 0x002e6400000e0000ULL, 0x0000005a275a7220ULL, 0x042fe20000410000ULL,
0x0000005b275b7220ULL, 0x040fe20000410000ULL, 0x0000005627567220ULL, 0x040fe20000410000ULL,
0x0000005727577220ULL, 0x040fe20000410000ULL, 0x0000005227527220ULL, 0x040fe20000410000ULL,
0x0000005327537220ULL, 0x040fe20000410000ULL, 0x0000004e274e7220ULL, 0x040fe20000410000ULL,
0x0000004f274f7220ULL, 0x040fe20000410000ULL, 0x0000004a274a7220ULL, 0x040fe20000410000ULL,
0x0000004b274b7220ULL, 0x040fe20000410000ULL, 0x0000004627467220ULL, 0x040fe20000410000ULL,
0x0000004727477220ULL, 0x040fe20000410000ULL, 0x0000004227427220ULL, 0x040fe20000410000ULL,
0x0000004327437220ULL, 0x040fe20000410000ULL, 0x0000003e273e7220ULL, 0x040fe20000410000ULL,
0x0000003f273f7220ULL, 0x000fce0000410000ULL, 0x0000003635ff7212ULL, 0x000fe400078030ffULL,
0x0000008134817209ULL, 0x000fd60007810000ULL, 0x8000008134340221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b34340820ULL, 0x000fc80000410000ULL, 0x0000003400160308ULL, 0x000ea40000000800ULL,
0x0000001683830220ULL, 0x004fce0000410000ULL, 0x0000000d03807819ULL, 0x040fe200000006ffULL,
0x0000040003277824ULL, 0x002fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xffffc00080357812ULL, 0x000fe400078ec0ffULL, 0xfffff00027277812ULL, 0x000fc600078ec0ffULL,
0x000000010a347824ULL, 0x040fe200078e0235ULL, 0x000130000a277810ULL, 0x000fc60007ffe027ULL,
0x0000200011347824ULL, 0x000fe200078e0234ULL, 0x0000002717707211ULL, 0x000fc600078e20ffULL,
0x0001700034387836ULL, 0x000fe20000000000ULL, 0x0000000000288947ULL, 0x000fec0003800000ULL,
0x00000002ff1f7819ULL, 0x000fe40000011608ULL, 0x00000016ff1d723eULL, 0x000fe400000000ffULL,
0x000000181f397810ULL, 0x000fe20007ffe0ffULL, 0x000000081f357836ULL, 0x000fe20000000000ULL,
0x000054101d347816ULL, 0x000fe2000000001dULL, 0x000000101f377836ULL, 0x000fc80000000000ULL,
0x00001f35341e7589ULL, 0x0002a800000e0000ULL, 0x00001f37341d7589ULL, 0x0002e800000e0000ULL,
0x00001f1f341f7589ULL, 0x00026800000e0000ULL, 0x00001f3934207589ULL, 0x00026400000e0000ULL,
0x0000001018277824ULL, 0x000fe200078e0227ULL, 0x000000007070783bULL, 0x000ee20000000200ULL,
0x000000101a6c7824ULL, 0x100fe200078e0238ULL, 0x000000381b647211ULL, 0x000fe200078e20ffULL,
0x0000001019687824ULL, 0x000fe200078e0238ULL, 0x000000002734783bULL, 0x0022a20000000200ULL,
0x0000000000208947ULL, 0x000fea0003800000ULL, 0x0000001f70707232ULL, 0x088fe40000000000ULL,
0x0000001f72727232ULL, 0x000fe40000000000ULL, 0x0000001e71717232ULL, 0x084fe40000000000ULL,
0x0000001e73737232ULL, 0x000fe40000000000ULL, 0x0000001d34347232ULL, 0x080fe40000000000ULL,
0x0000001d36367232ULL, 0x000fc40000000000ULL, 0x0000002035357232ULL, 0x080fe40000000000ULL,
0x0000002037377232ULL, 0x000fce0000000000ULL, 0x000000006464783bULL, 0x000f620000004200ULL,
0x000000101c387824ULL, 0x000fe200078e0238ULL, 0x00000001ff277819ULL, 0x002fe40000011603ULL,
0x000000006c6c783bULL, 0x000fe60000004200ULL, 0x0000400027887824ULL, 0x100fe200078e020aULL,
0x000000006868783bULL, 0x000e680000004200ULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x00000064707c723cULL, 0x028fec000000187cULL, 0x000000643448723cULL, 0x004fec0000001848ULL,
0x000000687028723cULL, 0x002fe20000001828ULL, 0x000010000d647824ULL, 0x000fc800078e020aULL,
0x0001300064647836ULL, 0x000fe20000000000ULL, 0x000000387060723cULL, 0x000fec0000001860ULL,
0x0000006c3458723cULL, 0x000fec0000001858ULL, 0x0000006e3454723cULL, 0x000fec0000001854ULL,
0x000000683450723cULL, 0x000fec0000001850ULL, 0x0000006a344c723cULL, 0x000fe2000000184cULL,
0x0000008811687211ULL, 0x000fca00078e68ffULL, 0x000000663444723cULL, 0x000fe20000001844ULL,
0x0001700068687836ULL, 0x000fc80000000000ULL, 0x0000001024697824ULL, 0x000fe200078e0268ULL,
0x000000383440723cULL, 0x000fec0000001840ULL, 0x0000003a343c723cULL, 0x000fe2000000183cULL,
0x0000001021387824ULL, 0x000fca00078e0264ULL, 0x0000003a705c723cULL, 0x000fe2000000185cULL,
0x0000006422347211ULL, 0x000fe200078e20ffULL, 0x000000003838783bULL, 0x000e620000000200ULL,
0x0000001023647824ULL, 0x000fc600078e0268ULL, 0x0000006c7030723cULL, 0x000fe20000001830ULL,
0x000000003434783bULL, 0x000eaa0000000200ULL, 0x0000006e702c723cULL, 0x000fe2000000182cULL,
0x00000010256c7824ULL, 0x000fca00078e0268ULL, 0x0000006a7074723cULL, 0x000fec0000001874ULL,
0x000000667078723cULL, 0x000fe20000001878ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000208947ULL, 0x000fde0003800000ULL, 0x0000001f38387232ULL, 0x082fe40000000000ULL,
0x0000001f3a3a7232ULL, 0x000fe40000000000ULL, 0x0000001e39397232ULL, 0x080fe40000000000ULL,
0x0000001e3b3b7232ULL, 0x000fe40000000000ULL, 0x0000001d34347232ULL, 0x084fe40000000000ULL,
0x0000001d36367232ULL, 0x000fc40000000000ULL, 0x0000002035357232ULL, 0x080fe40000000000ULL,
0x0000002037377232ULL, 0x000fce0000000000ULL, 0x0000006826707211ULL, 0x000fe200078e20ffULL,
0x000000006464783bULL, 0x000ee20000004200ULL, 0x0000850000047ab9ULL, 0x000fe40000000800ULL,
0x0000000482827c24ULL, 0x010fe2000f8e02ffULL, 0x000000006968783bULL, 0x000f280000004200ULL,
0x000000006c6c783bULL, 0x000f680000004200ULL, 0x000000007070783bULL, 0x000f220000004200ULL,
0x000000643830723cULL, 0x00afec0000001830ULL, 0x00000066382c723cULL, 0x000fec000000182cULL,
0x000000683828723cULL, 0x014fec0000001828ULL, 0x0000006a3874723cULL, 0x000fec0000001874ULL,
0x0000006c387c723cULL, 0x020fec000000187cULL, 0x0000006e3878723cULL, 0x000fec0000001878ULL,
0x000000703860723cULL, 0x000fec0000001860ULL, 0x000000723838723cULL, 0x000fe2000000185cULL,
0x00008e00ff5e7b82ULL, 0x000e6a0000000a00ULL, 0x000000703440723cULL, 0x000fe20000001840ULL,
0x000000080d5d7824ULL, 0x000fc400078e020aULL, 0x00000001ff5c7424ULL, 0x000fc600078e00ffULL,
0x000000723470723cULL, 0x000fe2000000183cULL, 0x01e6905c5dff79a7ULL, 0x0005ea000850003fULL,
0x000000643458723cULL, 0x000fe20000001858ULL, 0x00000001053d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008053c7824ULL, 0x000fc600078e0227ULL, 0x0000000c3d00720cULL, 0x000fe20003f06070ULL,
0x000000663454723cULL, 0x000fe20000001854ULL, 0x000000c03c3c7811ULL, 0x000fca00078e28ffULL,
0x000000683450723cULL, 0x000fec0000001850ULL, 0x0000006a344c723cULL, 0x000fec000000184cULL,
0x0000006c3448723cULL, 0x000fec0000001848ULL, 0x0000006e3444723cULL, 0x000fee0000001844ULL,
0x000000203c377812ULL, 0x000fe200078ec0ffULL, 0x0000004082357824ULL, 0x000fc400078e00ffULL,
0x0000008483827221ULL, 0x000fe40000010000ULL, 0x0000010035347825ULL, 0x002fc800078e005eULL,
0x00000001106b7824ULL, 0x000fe200078e0237ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400908947ULL, 0x004fec0003800000ULL, 0x00000003ff6a7819ULL, 0x100fe40000011608ULL,
0x0000200080377812ULL, 0x000fe400078ec0ffULL, 0x0000003c09367248ULL, 0x000fe20007fe0000ULL,
0x000000046a3e7836ULL, 0x000fe20000000000ULL, 0x000000ff3c5d7210ULL, 0x000fe20007ffe1ffULL,
0x00000080033c7824ULL, 0x000fe200078e00ffULL, 0x0001700088887810ULL, 0x000fe20007ffe037ULL,
0x000000013e3d7824ULL, 0x040fe200078e0208ULL, 0x000000086a377210ULL, 0x000fe20007ffe0ffULL,
0x000000083e5e7824ULL, 0x000fe200078e00ffULL, 0x00000020365d7446ULL, 0x000fe2000380005dULL,
0x000000086a6c7836ULL, 0x000fe20000000000ULL, 0x0000008015367812ULL, 0x000fe200078ef83cULL,
0x0000000c6a6e7836ULL, 0x000fe20000000000ULL, 0xfffffff85e6f7812ULL, 0x000fe200078ee23dULL,
0x000000016a3d7824ULL, 0x100fe200078e026bULL, 0x0000000737697812ULL, 0x000fe200078ec0ffULL,
0x000000ffff377224ULL, 0x000fe200078e00ffULL, 0x0000006b3e3f7210ULL, 0x000fe20007ffe0ffULL,
0x000000016c5f7824ULL, 0x000fe200078e026bULL, 0x0000005d3e00720cULL, 0x080fe20003f26070ULL,
0x000001003d3c7825ULL, 0x000fe200078e0036ULL, 0x0000005d6a00720cULL, 0x000fc40003f06070ULL,
0x000000886f6f7211ULL, 0x000fe200078e20ffULL, 0x000001005f5e7825ULL, 0x100fe200078e0036ULL,
0x0000003c34667210ULL, 0x000fe40007f5e0ffULL, 0x0000005d6c00720cULL, 0x000fe20003fa6070ULL,
0x000001003f3e7825ULL, 0x000fe200078e0036ULL, 0x0000003d35677210ULL, 0x000fe400017fe4ffULL,
0x0ffffff8693d7812ULL, 0x000fe200078ef808ULL, 0x000000016e657824ULL, 0x000fe200078e026bULL,
0x0000005e343c7210ULL, 0x000fe20007f5e0ffULL, 0x000000106a807836ULL, 0x000fe20000000000ULL,
0x0000003e34687210ULL, 0x000fe20007f7e0ffULL, 0x0000010065647825ULL, 0x000fe200078e0036ULL,
0x000000186a8a7810ULL, 0x000fc40007ffe0ffULL, 0x0000005d6e00720cULL, 0x080fe20003f86070ULL,
0x000000103d6d7824ULL, 0x000fe400078e0288ULL, 0x00000001353d7824ULL, 0x040fe400010e065fULL,
0x0000000135697824ULL, 0x000fe200018e063fULL, 0x00000064343e7210ULL, 0x000fe20007f7e0ffULL,
0x00000001805f7824ULL, 0x000fe200078e026bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000666d7faeULL, 0x0003e2000c101c46ULL, 0x000000146a847836ULL, 0x000fe40000000000ULL,
0x000001005f5e7825ULL, 0x000fe200078e0036ULL, 0x00000000686f7faeULL, 0x0005e2000c901c46ULL,
0x0000005d8a00720cULL, 0x000fc40003f26070ULL, 0x00000001353f7824ULL, 0x000fe200018e0665ULL,
0x0000005e34647210ULL, 0x000fe20007fde0ffULL, 0x000000016c657824ULL, 0x140fe200078e0208ULL,
0x000000036c6c7819ULL, 0x000fe200000006ffULL, 0x0000001c6a6a7836ULL, 0x000fe20000000000ULL,
0x0000005d8000720cULL, 0x080fe20003f66070ULL, 0x0000000184677824ULL, 0x002fe200078e026bULL,
0xfffffff86c6d7812ULL, 0x000fe200078ee265ULL, 0x000000016e667824ULL, 0x040fe200078e0208ULL,
0x0000005f35657210ULL, 0x000fe200037fe4ffULL, 0x000000086e6f7824ULL, 0x004fe200078e00ffULL,
0x0000005d8400720cULL, 0x080fe20003f46070ULL, 0x00000100675e7825ULL, 0x000fe200078e0036ULL,
0x0000005d6a00720cULL, 0x000fc40003f06070ULL, 0xfffffff86f6f7812ULL, 0x000fe200078ee266ULL,
0x0000000180677824ULL, 0x140fe200078e0208ULL, 0x0000005e34667210ULL, 0x000fe20007fde0ffULL,
0x0000000880807824ULL, 0x000fe200078e00ffULL, 0x0000000384857819ULL, 0x000fe200000006ffULL,
0x000000018a5d7824ULL, 0x000fe400078e026bULL, 0x0000000184687824ULL, 0x000fe200078e0208ULL,
0xfffffff880837812ULL, 0x000fe200078ee267ULL, 0x0000000135677824ULL, 0x000fe400030e065fULL,
0x000001005d5e7825ULL, 0x000fe200078e0036ULL, 0x000000088a5d7210ULL, 0x000fc40007ffe0ffULL,
0xfffffff885857812ULL, 0x000fe200078ee268ULL, 0x000000016a697824ULL, 0x000fe200078e026bULL,
0x0000005e345e7210ULL, 0x000fe20007fde0ffULL, 0x000000088a8a7824ULL, 0x000fe200078e00ffULL,
0x0000008885857211ULL, 0x000fe200078e20ffULL, 0x000000016a687824ULL, 0x040fe200078e0208ULL,
0x0000005f355f7210ULL, 0x000fe200037fe4ffULL, 0x000000086a6b7824ULL, 0x000fe200078e00ffULL,
0xfffffff88a5d7812ULL, 0x000fe200078ee25dULL, 0x0000010069367825ULL, 0x000fc600078e0036ULL,
0xfffffff86b697812ULL, 0x000fe200078ee268ULL, 0x000000106d6d7824ULL, 0x100fe200078e0288ULL,
0x0000003634347210ULL, 0x000fe20007fde0ffULL, 0x000000106f6f7824ULL, 0x100fe400078e0288ULL,
0x0000001083837824ULL, 0x100fe200078e0288ULL, 0x000000003c6d7faeULL, 0x0003e2000e901c46ULL,
0x000000105d5d7824ULL, 0x100fe400078e0288ULL, 0x0000001069697824ULL, 0x000fe200078e0288ULL,
0x000000003e6f7faeULL, 0x0003e2000e101c46ULL, 0x0000000135357824ULL, 0x000fc600030e0637ULL,
0x0000000064837faeULL, 0x0003e8000d901c46ULL, 0x0000000066857faeULL, 0x0003e8000d101c46ULL,
0x000000005e5d7faeULL, 0x0003e8000c901c46ULL, 0x0000000034697faeULL, 0x0003e2000c101c46ULL,
0x00000004005c7947ULL, 0x000fea0003800000ULL, 0x00000004083d7811ULL, 0x040fe200078fe8ffULL,
0x00000080036a7824ULL, 0x000fe200078e00ffULL, 0x00000008083f7811ULL, 0x040fe400078fe8ffULL,
0x000000083d367210ULL, 0x000fe20007ffe0ffULL, 0x000000083d6f7824ULL, 0x000fe200078e00ffULL,
0x0000000c085f7811ULL, 0x000fe200078fe8ffULL, 0x000000083f837824ULL, 0x000fe200078e00ffULL,
0x0000200080377812ULL, 0x000fe200078ec0ffULL, 0x000000013d3d7824ULL, 0x000fe200078e026bULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee236ULL, 0x000000013f367824ULL, 0x000fe200078e0208ULL,
0x0001700088887810ULL, 0x000fe20007ffe037ULL, 0x000000085f5e7824ULL, 0x000fe200078e00ffULL,
0x0000001008657811ULL, 0x000fc400078fe8ffULL, 0x000000085f377210ULL, 0x000fe20007ffe0ffULL,
0x000000015f5f7824ULL, 0x100fe200078e026bULL, 0xfffffff883837812ULL, 0x000fe200078ee236ULL,
0x00000001653c7824ULL, 0x040fe200078e0208ULL, 0xfffffff85e857812ULL, 0x000fe200078ee237ULL,
0x0000000865877824ULL, 0x040fe200078e00ffULL, 0x0000001408677811ULL, 0x040fe200078fe8ffULL,
0x0000000165657824ULL, 0x100fe200078e026bULL, 0x0000000808367211ULL, 0x040fe200078fe8ffULL,
0x0000001083837824ULL, 0x100fe200078e0288ULL, 0x0000001808377811ULL, 0x040fe200078fe8ffULL,
0x0000000867897824ULL, 0x000fe200078e00ffULL, 0x0000001c085d7811ULL, 0x000fe200078fe8ffULL,
0x0000001085857824ULL, 0x000fe200078e0288ULL, 0xfffffff887877812ULL, 0x000fe200078ee23cULL,
0x00000008378b7824ULL, 0x040fe200078e00ffULL, 0x00000007366d7812ULL, 0x000fe200078ec0ffULL,
0x0000000137367824ULL, 0x100fe200078e0208ULL, 0x00000008673e7210ULL, 0x000fe20007ffe0ffULL,
0x000000015d3c7824ULL, 0x000fe200078e0208ULL, 0x0000006b37697210ULL, 0x000fe20007ffe0ffULL,
0x0000000167677824ULL, 0x100fe200078e026bULL, 0x000000035d8d7819ULL, 0x040fe200000006ffULL,
0x000000015d5d7824ULL, 0x000fe200078e026bULL, 0x00000080156a7812ULL, 0x000fe200078ef86aULL,
0x0000001087877824ULL, 0x000fe200078e0288ULL, 0x0000006b3f3f7210ULL, 0x000fc40007ffe0ffULL,
0x0000006b08377211ULL, 0x000fe200078fe8ffULL, 0x000000ffff6b7224ULL, 0x000fe200078e00ffULL,
0xfffffff88b8b7812ULL, 0x000fe400078ee236ULL, 0xfffffff889897812ULL, 0x000fe200078ee23eULL,
0x0000010037367825ULL, 0x100fe200078e006aULL, 0xfffffff88d8d7812ULL, 0x000fe400078ee23cULL,
0x0ffffff86d6d7812ULL, 0x000fe200078ef808ULL, 0x000001003f3e7825ULL, 0x000fe200078e006aULL,
0x0000003634367210ULL, 0x000fc40007f1e0ffULL, 0x000000886f6f7211ULL, 0x080fe200078e20ffULL,
0x000001003d3c7825ULL, 0x100fe200078e006aULL, 0x0000003e343e7210ULL, 0x000fe40007f5e0ffULL,
0x0000008889897211ULL, 0x000fe200078e20ffULL, 0x000001005f5e7825ULL, 0x000fe200078e006aULL,
0x0000003c343c7210ULL, 0x000fc60007f3e0ffULL, 0x0000010065647825ULL, 0x100fe200078e006aULL,
0x0000005e345e7210ULL, 0x000fe40007f7e0ffULL, 0x0000003d353d7210ULL, 0x000fe20000ffe4ffULL,
0x0000010067667825ULL, 0x000fc800078e006aULL, 0x0000010069687825ULL, 0x000fe200078e006aULL,
0x0000006634667210ULL, 0x000fc60007f3e0ffULL, 0x000001005d6a7825ULL, 0x000fe200078e006aULL,
0x0000006735677210ULL, 0x000fc60000ffe4ffULL, 0x0000000135377824ULL, 0x000fe200000e0637ULL,
0x0000006434647210ULL, 0x000fe20007f1e0ffULL, 0x000000106d6d7824ULL, 0x100fe400078e0288ULL,
0x00000001353f7824ULL, 0x040fe200010e063fULL, 0x0000006834687210ULL, 0x000fe20007f5e0ffULL,
0x00000001355f7824ULL, 0x040fe200018e065fULL, 0x0000006a34347210ULL, 0x000fe20007f7e0ffULL,
0x0000000135657824ULL, 0x000fe200000e0665ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000366d7faeULL, 0x0003e2000b901c46ULL, 0x000000108b8b7824ULL, 0x000fc400078e0288ULL,
0x0000000135697824ULL, 0x000fe200010e0669ULL, 0x000000003c6f7faeULL, 0x0003e2000b901c46ULL,
0x000000108d8d7824ULL, 0x000fe400078e0288ULL, 0x0000000135357824ULL, 0x000fe200018e066bULL,
0x000000003e837faeULL, 0x0003e8000b901c46ULL, 0x000000005e857faeULL, 0x0003e8000b901c46ULL,
0x0000000064877faeULL, 0x0003e8000b901c46ULL, 0x0000000066897faeULL, 0x0003e8000b901c46ULL,
0x00000000688b7faeULL, 0x0003e8000b901c46ULL, 0x00000000348d7faeULL, 0x0003e4000b901c46ULL,
0x0000000386347812ULL, 0x002fe200078ec0ffULL, 0xffffffffff847424ULL, 0x000fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x000000033400780cULL, 0x000fc80003f05270ULL,
0x0000000112357807ULL, 0x000fca0004000000ULL, 0x0000000186867824ULL, 0x000fca00078e0235ULL,
0x0000000b8600720cULL, 0x000fda0003f06070ULL, 0x00009000ff348b82ULL, 0x000e620000000a00ULL,
0x0000008613378210ULL, 0x000fe20007ffe0ffULL, 0x000000200d367824ULL, 0x000fe200078e020aULL,
0x000000080f3d7812ULL, 0x000fc600078ec0ffULL, 0x0000000437348825ULL, 0x002fe200078e0034ULL,
0x000000100f377812ULL, 0x000fc800078ec0ffULL, 0x000000363d3d7210ULL, 0x000fe20007ffe037ULL,
0x0000000634848981ULL, 0x000326000c1e1900ULL, 0x01e6485c3d5c79a7ULL, 0x0002a6000850003fULL,
0x0000000000347805ULL, 0x002fce0000015200ULL, 0x01e6485d3d0075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff3c7224ULL, 0x000fce00078e00ffULL,
0x000000103c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343f7210ULL, 0x000fc80007f1e1ffULL,
0x0000003735377210ULL, 0x000fe400007fe5ffULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003f36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013c3c7836ULL, 0x000fce0000000000ULL,
0x01e6485d3d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000002003347824ULL, 0x000fca00078e00ffULL, 0xffffff8034357812ULL, 0x000fc800078ec0ffULL,
0x000001000a347810ULL, 0x000fc80007ffe035ULL, 0x0000003414347210ULL, 0x000fca0007ffe015ULL,
0x01e0000034367984ULL, 0x000e680000000800ULL, 0x01e2000034837984ULL, 0x0004a20000000800ULL,
0x000000813600720bULL, 0x002fda0003f1d000ULL, 0x0000000000357806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x000000ff3500720cULL, 0x000fda0003f25270ULL,
0x0000000400949947ULL, 0x004fea0003800000ULL, 0x000000020d347810ULL, 0x000fe40007ffe0ffULL,
0x000000813600720bULL, 0x000fe40003f14000ULL, 0x000000033400720cULL, 0x000fe40003f25270ULL,
0x0000008136377209ULL, 0x000fd20007810000ULL, 0x00000000003c7806ULL, 0x000fe400000e0100ULL,
0x0000008003349824ULL, 0x000fe400078e020aULL, 0x000000ff3c00720cULL, 0x000fc60003f05270ULL,
0x0000003414349210ULL, 0x000fca0007ffe015ULL, 0x01e4003734009388ULL, 0x0003ea0000000800ULL,
0x0000000400508947ULL, 0x000fea0003800000ULL, 0x8000003781817221ULL, 0x000fe20000010000ULL,
0x000000ff3cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff003cff7812ULL, 0x040fe2000782c0ffULL,
0x3fb8aa3b81817820ULL, 0x000fe20000410000ULL, 0x00ff00003cff7812ULL, 0x040fe4000784c0ffULL,
0xff0000003cff7812ULL, 0x000fc6000786c0ffULL, 0x0000008100817308ULL, 0x000ea80000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff347819ULL, 0x002fcc0000011608ULL,
0x00001f3481347589ULL, 0x004e6400000e0000ULL, 0x0000003034307220ULL, 0x042fe20000410000ULL,
0x0000003134317220ULL, 0x040fe20000410000ULL, 0x0000002c342c7220ULL, 0x040fe20000410000ULL,
0x0000002d342d7220ULL, 0x040fe20000410000ULL, 0x0000002834287220ULL, 0x040fe20000410000ULL,
0x0000002934297220ULL, 0x040fe20000410000ULL, 0x0000007434747220ULL, 0x040fe20000410000ULL,
0x0000007534757220ULL, 0x040fe20000410000ULL, 0x0000007c347c7220ULL, 0x040fe20000410000ULL,
0x0000007d347d7220ULL, 0x040fe20000410000ULL, 0x0000007834787220ULL, 0x040fe20000410000ULL,
0x0000007934797220ULL, 0x040fe20000410000ULL, 0x0000006034607220ULL, 0x040fe20000410000ULL,
0x0000006134617220ULL, 0x040fe20000410000ULL, 0x0000003834387220ULL, 0x040fe20000410000ULL,
0x0000003934397220ULL, 0x000fce0000410000ULL, 0x0000000000489947ULL, 0x000fea0003800000ULL,
0x0000000808347811ULL, 0x002fcc00078ff0ffULL, 0x00001f3481347589ULL, 0x004e6400000e0000ULL,
0x0000003234327220ULL, 0x042fe20000410000ULL, 0x0000003334337220ULL, 0x040fe20000410000ULL,
0x0000002e342e7220ULL, 0x040fe20000410000ULL, 0x0000002f342f7220ULL, 0x040fe20000410000ULL,
0x0000002a342a7220ULL, 0x040fe20000410000ULL, 0x0000002b342b7220ULL, 0x040fe20000410000ULL,
0x0000007634767220ULL, 0x040fe20000410000ULL, 0x0000007734777220ULL, 0x040fe20000410000ULL,
0x0000007e347e7220ULL, 0x040fe20000410000ULL, 0x0000007f347f7220ULL, 0x040fe20000410000ULL,
0x0000007a347a7220ULL, 0x040fe20000410000ULL, 0x0000007b347b7220ULL, 0x040fe20000410000ULL,
0x0000006234627220ULL, 0x040fe20000410000ULL, 0x0000006334637220ULL, 0x040fe20000410000ULL,
0x0000003a343a7220ULL, 0x040fe20000410000ULL, 0x0000003b343b7220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x0000001008347811ULL, 0x002fcc00078ff0ffULL,
0x00001f3481347589ULL, 0x004e6400000e0000ULL, 0x0000005834587220ULL, 0x042fe20000410000ULL,
0x0000005934597220ULL, 0x040fe20000410000ULL, 0x0000005434547220ULL, 0x040fe20000410000ULL,
0x0000005534557220ULL, 0x040fe20000410000ULL, 0x0000005034507220ULL, 0x040fe20000410000ULL,
0x0000005134517220ULL, 0x040fe20000410000ULL, 0x0000004c344c7220ULL, 0x040fe20000410000ULL,
0x0000004d344d7220ULL, 0x040fe20000410000ULL, 0x0000004834487220ULL, 0x040fe20000410000ULL,
0x0000004934497220ULL, 0x040fe20000410000ULL, 0x0000004434447220ULL, 0x040fe20000410000ULL,
0x0000004534457220ULL, 0x040fe20000410000ULL, 0x0000004034407220ULL, 0x040fe20000410000ULL,
0x0000004134417220ULL, 0x040fe20000410000ULL, 0x0000007034707220ULL, 0x040fe20000410000ULL,
0x0000007134717220ULL, 0x000fce0000410000ULL, 0x0000008182827220ULL, 0x004fe20000410000ULL,
0x000000000048b947ULL, 0x000fec0003800000ULL, 0x0000001808347811ULL, 0x002fcc00078ff0ffULL,
0x00001f3481347589ULL, 0x000e6400000e0000ULL, 0x0000005a345a7220ULL, 0x042fe20000410000ULL,
0x0000005b345b7220ULL, 0x040fe20000410000ULL, 0x0000005634567220ULL, 0x040fe20000410000ULL,
0x0000005734577220ULL, 0x040fe20000410000ULL, 0x0000005234527220ULL, 0x040fe20000410000ULL,
0x0000005334537220ULL, 0x040fe20000410000ULL, 0x0000004e344e7220ULL, 0x040fe20000410000ULL,
0x0000004f344f7220ULL, 0x040fe20000410000ULL, 0x0000004a344a7220ULL, 0x040fe20000410000ULL,
0x0000004b344b7220ULL, 0x040fe20000410000ULL, 0x0000004634467220ULL, 0x040fe20000410000ULL,
0x0000004734477220ULL, 0x040fe20000410000ULL, 0x0000004234427220ULL, 0x040fe20000410000ULL,
0x0000004334437220ULL, 0x040fe20000410000ULL, 0x0000007234727220ULL, 0x040fe20000410000ULL,
0x0000007334737220ULL, 0x000fce0000410000ULL, 0x0000003c35ff7212ULL, 0x000fe200078030ffULL,
0x000000ffff817224ULL, 0x000fd800078e0037ULL, 0x8000003736360221ULL, 0x100fe20000010000ULL,
0x000000ffff810224ULL, 0x000fc600078e0037ULL, 0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL,
0x0000003600160308ULL, 0x000ea40000000800ULL, 0x0000001683830220ULL, 0x004fce0000410000ULL,
0x0000000a03347819ULL, 0x002fe200000006ffULL, 0x0000400027807824ULL, 0x000fe200078e020aULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffff00034357812ULL, 0x000fe200078ec0ffULL,
0x0000200011367824ULL, 0x000fc600078e0280ULL, 0x000140000a347810ULL, 0x000fe20007ffe035ULL,
0x0001600036857836ULL, 0x000fe20000000000ULL, 0x0000000000288947ULL, 0x000fec0003800000ULL,
0x00000002ff367819ULL, 0x000fe40000011608ULL, 0x00000016ff1d723eULL, 0x000fe400000000ffULL,
0x00000008361e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001836207836ULL, 0x000fe20000000000ULL,
0x000054101d357816ULL, 0x000fe2000000001dULL, 0x00000010363c7836ULL, 0x000fc80000000000ULL,
0x00001f1e351e7589ULL, 0x0002a800000e0000ULL, 0x00001f3c351d7589ULL, 0x0002e800000e0000ULL,
0x00001f36351f7589ULL, 0x00026800000e0000ULL, 0x00001f2035207589ULL, 0x00026400000e0000ULL,
0x00000010173c7824ULL, 0x002fe200078e0234ULL, 0x0000003418347211ULL, 0x000fe200078e20ffULL,
0x000000101a5c7824ULL, 0x100fe400078e0285ULL, 0x0000001019647824ULL, 0x100fe400078e0285ULL,
0x000000003c3c783bULL, 0x000e620000000200ULL, 0x000000101b687824ULL, 0x000fc600078e0285ULL,
0x000000003434783bULL, 0x000ee20000000200ULL, 0x0000000000208947ULL, 0x000fea0003800000ULL,
0x0000001f3c3c7232ULL, 0x082fe40000000000ULL, 0x0000001f3e3e7232ULL, 0x000fe40000000000ULL,
0x0000001e3d3d7232ULL, 0x084fe40000000000ULL, 0x0000001e3f3f7232ULL, 0x000fe40000000000ULL,
0x0000001d34347232ULL, 0x088fe40000000000ULL, 0x0000001d36367232ULL, 0x000fc40000000000ULL,
0x0000002035357232ULL, 0x080fe40000000000ULL, 0x0000002037377232ULL, 0x000fce0000000000ULL,
0x000000851c6c7211ULL, 0x000fe200078e20ffULL, 0x000000005c5c783bULL, 0x000f680000004200ULL,
0x000000006464783bULL, 0x000f680000004200ULL, 0x000000006868783bULL, 0x000f680000004200ULL,
0x000000006c6c783bULL, 0x000f640000004200ULL, 0x0000005c3c30723cULL, 0x02afec0000001830ULL,
0x0000005e3c2c723cULL, 0x000fec000000182cULL, 0x000000643c28723cULL, 0x004fec0000001828ULL,
0x000000663c74723cULL, 0x000fec0000001874ULL, 0x000000683c7c723cULL, 0x000fec000000187cULL,
0x0000006a3c78723cULL, 0x000fec0000001878ULL, 0x0000006c3c60723cULL, 0x000fec0000001860ULL,
0x0000006e3c38723cULL, 0x000fec0000001838ULL, 0x0000005c3458723cULL, 0x000fe20000001858ULL,
0x000010000d3c7824ULL, 0x000fc800078e020aULL, 0x000140003c3c7836ULL, 0x000fe20000000000ULL,
0x0000005e3454723cULL, 0x000fe20000001854ULL, 0x00000010235c7824ULL, 0x000fe400078e0285ULL,
0x00000010213d7824ULL, 0x000fc600078e023cULL, 0x000000643450723cULL, 0x000fec0000001850ULL,
0x00000066344c723cULL, 0x000fe2000000184cULL, 0x0000001024647824ULL, 0x000fca00078e0285ULL,
0x000000683448723cULL, 0x000fec0000001848ULL, 0x0000006a3444723cULL, 0x000fe20000001844ULL,
0x0000001025687824ULL, 0x000fca00078e0285ULL, 0x0000006c3440723cULL, 0x000fec0000001840ULL,
0x0000006e3470723cULL, 0x000fee0000001870ULL, 0x0000003c22347211ULL, 0x000fc400078e20ffULL,
0x000000003d3c783bULL, 0x000e680000000200ULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x0000000000208947ULL, 0x000ff40003800000ULL, 0x0000001f3c3c7232ULL, 0x082fe40000000000ULL,
0x0000001f3e3e7232ULL, 0x000fe40000000000ULL, 0x0000001e3d3d7232ULL, 0x080fe40000000000ULL,
0x0000001e3f3f7232ULL, 0x000fe40000000000ULL, 0x0000001d34347232ULL, 0x084fe40000000000ULL,
0x0000001d36367232ULL, 0x000fc40000000000ULL, 0x0000002035357232ULL, 0x080fe40000000000ULL,
0x0000002037377232ULL, 0x000fce0000000000ULL, 0x00000085266c7211ULL, 0x000fe200078e20ffULL,
0x000000005c5c783bULL, 0x000ee20000004200ULL, 0x0000000100057824ULL, 0x000fe400078e0205ULL,
0x0000008283857221ULL, 0x000fe20000010000ULL, 0x000000006464783bULL, 0x000f640000004200ULL,
0x0000000c0500720cULL, 0x000fe40003f06070ULL, 0x000000006868783bULL, 0x000f680000004200ULL,
0x000000006c6c783bULL, 0x000f620000004200ULL, 0x0000005c3c30723cULL, 0x00afec0000001830ULL,
0x0000005e3c2c723cULL, 0x000fec000000182cULL, 0x000000643c28723cULL, 0x024fec0000001828ULL,
0x000000663c74723cULL, 0x000fec0000001874ULL, 0x000000683c7c723cULL, 0x000fec000000187cULL,
0x0000006a3c78723cULL, 0x000fec0000001878ULL, 0x0000006c3c60723cULL, 0x000fec0000001860ULL,
0x0000006e3c38723cULL, 0x000fec0000001838ULL, 0x0000005c3458723cULL, 0x000fe20000001858ULL,
0x000000080d3d7824ULL, 0x000fc400078e020aULL, 0x00000001ff3e7424ULL, 0x000fc600078e00ffULL,
0x0000005e3454723cULL, 0x000fe20000001854ULL, 0x01e6983e3dff79a7ULL, 0x0003ea000850003fULL,
0x000000643450723cULL, 0x000fec0000001850ULL, 0x00000066344c723cULL, 0x000fec000000184cULL,
0x000000683448723cULL, 0x000fec0000001848ULL, 0x0000006a3444723cULL, 0x000fec0000001844ULL,
0x0000006c3440723cULL, 0x000fec0000001840ULL, 0x0000006e3434723cULL, 0x000fe20000001870ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000c004c0947ULL, 0x002fde0003800000ULL, 0x00008e00ff3c7b82ULL, 0x000e620000000a00ULL,
0x00000001053f7810ULL, 0x000fe20007ffe0ffULL, 0x0000850000047ab9ULL, 0x000fe20000000800ULL,
0x00000100055c7824ULL, 0x000fe400078e020eULL, 0x0000000c3f00720cULL, 0x000fe20003f06070ULL,
0x0000000484847c24ULL, 0x010fe4000f8e02ffULL, 0x000000205c3f7812ULL, 0x000fe400078ec0ffULL,
0x00000040845d7824ULL, 0x000fc600078e00ffULL, 0x00000001106f7824ULL, 0x000fe400078e023fULL,
0x000001005d3c7825ULL, 0x002fc600078e003cULL, 0x0000000400948947ULL, 0x000fea0003800000ULL,
0x00000003ff6e7819ULL, 0x000fe20000011608ULL, 0x00000080035e7824ULL, 0x040fe200078e00ffULL,
0x0000000d035d7819ULL, 0x000fe400000006ffULL, 0x0000005c093f7248ULL, 0x000fe20007fe0000ULL,
0x000000046e647836ULL, 0x000fe20000000000ULL, 0x000020005d5d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff5c7224ULL, 0x000fe200078e0a5cULL, 0x000000086e707810ULL, 0x000fe20007ffe0ffULL,
0x00000001645f7824ULL, 0x100fe200078e0208ULL, 0x0001600080807810ULL, 0x000fe20007ffe05dULL,
0x000000016e5d7824ULL, 0x000fe200078e0208ULL, 0x0000000364667819ULL, 0x040fe200000006ffULL,
0x0000000164657824ULL, 0x100fe200078e026fULL, 0x000000203f3f7446ULL, 0x000fe2000380005cULL,
0x0000000c6e727836ULL, 0x000fe20000000000ULL, 0xfffffff866737812ULL, 0x000fe200078ee25fULL,
0x000000016e5f7824ULL, 0x100fe200078e026fULL, 0x00000080155c7812ULL, 0x000fe200078ef85eULL,
0x0000000172697824ULL, 0x000fe200078e026fULL, 0x000000075d6d7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff5d7224ULL, 0x000fe200078e00ffULL, 0x0000006f70677210ULL, 0x000fe20007ffe0ffULL,
0x000000146e847836ULL, 0x000fe20000000000ULL, 0x0000003f6400720cULL, 0x000fe20003f26070ULL,
0x000001005f5e7825ULL, 0x000fe200078e005cULL, 0x000000106e827810ULL, 0x000fc40007ffe0ffULL,
0x0000003f6e00720cULL, 0x080fe20003f06070ULL, 0x0000010067667825ULL, 0x100fe200078e005cULL,
0x0000005e3c6a7210ULL, 0x000fe40007f5e0ffULL, 0x0000003f7000720cULL, 0x080fe20003fa6070ULL,
0x0000010065647825ULL, 0x000fe200078e005cULL, 0x0000003f7200720cULL, 0x000fc60003f86070ULL,
0x000000013d6b7824ULL, 0x000fe200010e065fULL, 0x0ffffff86d5f7812ULL, 0x000fe200078ef808ULL,
0x0000010069687825ULL, 0x000fe200078e005cULL, 0x000000663c5e7210ULL, 0x000fe40007f5e0ffULL,
0x000000643c6c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001073737824ULL, 0x000fe200078e0280ULL,
0x000000805f717211ULL, 0x000fe200078e20ffULL, 0x000000013d5f7824ULL, 0x040fe200010e0667ULL,
0x0000003f8400720cULL, 0x000fe20003f46070ULL, 0x000000013d6d7824ULL, 0x000fe200018e0665ULL,
0x000000683c647210ULL, 0x000fe20007f7e0ffULL, 0x0000000182677824ULL, 0x000fe200078e026fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a717faeULL, 0x0003e2000c101c46ULL,
0x000000186e887836ULL, 0x000fc40000000000ULL, 0x0000010067667825ULL, 0x000fe200078e005cULL,
0x000000006c737faeULL, 0x0005e4000c901c46ULL, 0x0000003f8800720cULL, 0x080fe20003f26070ULL,
0x000000013d657824ULL, 0x040fe200018e0669ULL, 0x0000000870697210ULL, 0x000fe20007ffe0ffULL,
0x0000000870707824ULL, 0x000fe200078e00ffULL, 0x000000663c687210ULL, 0x000fe20007fde0ffULL,
0x0000001c6e6e7836ULL, 0x000fe20000000000ULL, 0x0000003f8200720cULL, 0x080fe20003f66070ULL,
0x00000001846b7824ULL, 0x002fe200078e026fULL, 0xfffffff870717812ULL, 0x000fe200078ee269ULL,
0x00000001726a7824ULL, 0x040fe200078e0208ULL, 0x0000000372737819ULL, 0x004fe200000006ffULL,
0x000000013d697824ULL, 0x000fe200030e0667ULL, 0x0000003f6e00720cULL, 0x000fe20003f06070ULL,
0x000001006b667825ULL, 0x000fe200078e005cULL, 0xfffffff873737812ULL, 0x000fc600078ee26aULL,
0x00000001826b7824ULL, 0x140fe200078e0208ULL, 0x0000000382827819ULL, 0x000fe200000006ffULL,
0x00000001883f7824ULL, 0x000fe200078e026fULL, 0x000000663c6a7210ULL, 0x000fe20007fde0ffULL,
0x00000001846c7824ULL, 0x040fe200078e0208ULL, 0xfffffff882837812ULL, 0x000fe200078ee26bULL,
0x0000000884877824ULL, 0x000fe200078e00ffULL, 0x000000673d6b7210ULL, 0x000fe200037fe4ffULL,
0x000001003f667825ULL, 0x000fe200078e005cULL, 0x0000008073737211ULL, 0x000fe400078e20ffULL,
0xfffffff887877812ULL, 0x000fe200078ee26cULL, 0x000000016e6d7824ULL, 0x000fe200078e026fULL,
0x000000663c667210ULL, 0x000fe20007fde0ffULL, 0x00000001883f7824ULL, 0x040fe200078e0208ULL,
0x000000086e6c7210ULL, 0x000fe20007ffe0ffULL, 0x0000000888887824ULL, 0x000fc400078e00ffULL,
0x000001006d5c7825ULL, 0x000fc600078e005cULL, 0xfffffff8883f7812ULL, 0x000fe200078ee23fULL,
0x000000086e6f7824ULL, 0x000fe400078e00ffULL, 0x000000013d677824ULL, 0x000fe200030e0667ULL,
0x0000005c3c3c7210ULL, 0x000fe20007fde0ffULL, 0x0000001071717824ULL, 0x100fe200078e0280ULL,
0xfffffff86f6d7812ULL, 0x000fe200078ee26cULL, 0x0000001083837824ULL, 0x100fe400078e0280ULL,
0x0000001087877824ULL, 0x100fe200078e0280ULL, 0x000000806d6d7211ULL, 0x000fe200078e20ffULL,
0x000000103f3f7824ULL, 0x000fe200078e0280ULL, 0x000000005e717faeULL, 0x0003e2000e901c46ULL,
0x000000013d3d7824ULL, 0x000fc600030e065dULL, 0x0000000064737faeULL, 0x0003e8000e101c46ULL,
0x0000000068837faeULL, 0x0003e8000d901c46ULL, 0x000000006a877faeULL, 0x0003e8000d101c46ULL,
0x00000000663f7faeULL, 0x0003e8000c901c46ULL, 0x000000003c6d7faeULL, 0x0003e2000c101c46ULL,
0x0000000400607947ULL, 0x000fea0003800000ULL, 0x00000004085f7811ULL, 0x040fe200078fe8ffULL,
0x00002000033f7824ULL, 0x040fe200078e00ffULL, 0x0000000c08677811ULL, 0x040fe200078fe8ffULL,
0x00000080036e7824ULL, 0x000fe200078e00ffULL, 0x000000035f737819ULL, 0x040fe200000006ffULL,
0x000000015f5c7824ULL, 0x000fe200078e0208ULL, 0x000020003f3f7812ULL, 0x000fe200078ec0ffULL,
0x000000015f5f7824ULL, 0x000fe200078e026fULL, 0x0000000808657811ULL, 0x040fe400078fe8ffULL,
0x0000001008697811ULL, 0x000fc400078fe8ffULL, 0xfffffff873737812ULL, 0x000fe200078ee25cULL,
0x00000001675c7824ULL, 0x100fe200078e0208ULL, 0x0001600080807810ULL, 0x000fe20007ffe03fULL,
0x00000001653f7824ULL, 0x140fe200078e0208ULL, 0x00000014086b7811ULL, 0x040fe200078fe8ffULL,
0x0000000865647824ULL, 0x000fe200078e00ffULL, 0x0000000367877819ULL, 0x000fe200000006ffULL,
0x00000001695d7824ULL, 0x100fe200078e0208ULL, 0x000000036b8b7819ULL, 0x000fe200000006ffULL,
0x0000000869667824ULL, 0x000fe200078e00ffULL, 0xfffffff887877812ULL, 0x000fe200078ee25cULL,
0x000000016b5e7824ULL, 0x000fe200078e0208ULL, 0xfffffff864837812ULL, 0x000fe200078ee23fULL,
0x0000000165657824ULL, 0x100fe200078e026fULL, 0xfffffff866897812ULL, 0x000fe200078ee25dULL,
0x0000000169697824ULL, 0x100fe200078e026fULL, 0x00000018085c7811ULL, 0x040fe200078fe8ffULL,
0x000000016b6b7824ULL, 0x100fe200078e026fULL, 0x00000008083f7211ULL, 0x040fe200078fe8ffULL,
0x0000001073737824ULL, 0x000fe200078e0280ULL, 0x0000001c085d7811ULL, 0x000fe200078fe8ffULL,
0x000000015c6d7824ULL, 0x040fe200078e026fULL, 0xfffffff88b8b7812ULL, 0x000fe200078ee25eULL,
0x000000085c8d7824ULL, 0x000fe200078e00ffULL, 0x000000073f717812ULL, 0x000fe200078ec0ffULL,
0x000000085d8f7824ULL, 0x040fe200078e00ffULL, 0x000000085c5e7210ULL, 0x000fe20007ffe0ffULL,
0x000000015d5c7824ULL, 0x000fe200078e0208ULL, 0x0000006f5d3f7210ULL, 0x000fe20007ffe0ffULL,
0x0000001087877824ULL, 0x100fe200078e0280ULL, 0x00000080156e7812ULL, 0x000fe200078ef86eULL,
0x0000001089897824ULL, 0x100fe200078e0280ULL, 0x0000006f67677210ULL, 0x000fe20007ffe0ffULL,
0x000000108b8b7824ULL, 0x000fe200078e0280ULL, 0x0000006f085d7211ULL, 0x000fe200078fe8ffULL,
0x000000ffff6f7224ULL, 0x000fe200078e00ffULL, 0xfffffff88f8f7812ULL, 0x000fc400078ee25cULL,
0xfffffff88d8d7812ULL, 0x000fe200078ee25eULL, 0x000001005d5c7825ULL, 0x100fe200078e006eULL,
0x0ffffff871717812ULL, 0x000fe400078ef808ULL, 0x0000008083837211ULL, 0x080fe200078e20ffULL,
0x000001005f5e7825ULL, 0x100fe200078e006eULL, 0x0000005c3c5c7210ULL, 0x000fe40007f1e0ffULL,
0x000000808d8d7211ULL, 0x000fe200078e20ffULL, 0x0000010065647825ULL, 0x000fe200078e006eULL,
0x0000005e3c5e7210ULL, 0x000fc60007f3e0ffULL, 0x0000010067667825ULL, 0x000fe200078e006eULL,
0x000000643c647210ULL, 0x000fc60007f5e0ffULL, 0x0000010069687825ULL, 0x100fe200078e006eULL,
0x000000663c667210ULL, 0x000fe40007f7e0ffULL, 0x000000653d657210ULL, 0x000fe200017fe4ffULL,
0x000001006b6a7825ULL, 0x000fc800078e006eULL, 0x000001006d6c7825ULL, 0x000fc800078e006eULL,
0x000001003f6e7825ULL, 0x000fe200078e006eULL, 0x0000006c3c6c7210ULL, 0x000fc60007f5e0ffULL,
0x000000013d5d7824ULL, 0x040fe200000e065dULL, 0x000000683c687210ULL, 0x000fe20007f1e0ffULL,
0x000000013d5f7824ULL, 0x000fe200008e065fULL, 0x0000006a3c6a7210ULL, 0x000fe20007f3e0ffULL,
0x0000001071717824ULL, 0x000fe200078e0280ULL, 0x0000006d3d6d7210ULL, 0x000fe200017fe4ffULL,
0x000000013d677824ULL, 0x040fe200018e0667ULL, 0x0000006e3c3c7210ULL, 0x000fe20007f7e0ffULL,
0x000000013d697824ULL, 0x040fe200000e0669ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000005c717faeULL, 0x0003e2000b901c46ULL, 0x000000013d6b7824ULL, 0x000fc400008e066bULL,
0x000000108f8f7824ULL, 0x000fe200078e0280ULL, 0x000000005e737faeULL, 0x0003e2000b901c46ULL,
0x000000013d3d7824ULL, 0x000fc600018e066fULL, 0x0000000064837faeULL, 0x0003e8000b901c46ULL,
0x0000000066877faeULL, 0x0003e8000b901c46ULL, 0x0000000068897faeULL, 0x0003e8000b901c46ULL,
0x000000006a8b7faeULL, 0x0003e8000b901c46ULL, 0x000000006c8d7faeULL, 0x0003e8000b901c46ULL,
0x000000003c8f7faeULL, 0x0003e4000b901c46ULL, 0x00000003863c7812ULL, 0x002fe200078ec0ffULL,
0xffffffffff847424ULL, 0x000fc600078e00ffULL, 0x000000033c00780cULL, 0x000fc80003f05270ULL,
0x00000001123d7807ULL, 0x000fca0004000000ULL, 0x0000000186867824ULL, 0x000fca00078e023dULL,
0x0000000b8600720cULL, 0x000fda0003f06070ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x00009000ff3c7b82ULL, 0x000e620000000a00ULL, 0x00000086133f7210ULL, 0x000fca0007ffe0ffULL,
0x000000043f3c7825ULL, 0x002fca00078e003cULL, 0x000000063c847981ULL, 0x000324000c1e1900ULL,
0x000000200d3d7824ULL, 0x002fe200078e020aULL, 0x000000100f3c7812ULL, 0x040fe200078ec0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000080f3f7812ULL, 0x000fc800078ec0ffULL,
0x0000003d3f657210ULL, 0x000fc80007ffe03cULL, 0x01e6683e655c79a7ULL, 0x0002a6000850003fULL,
0x00000000003c7805ULL, 0x000fce0000015200ULL, 0x01e6685d650075a7ULL, 0x004ea4000800017fULL,
0x00000000005c0947ULL, 0x004fea0003800000ULL, 0x000000ffff5e7224ULL, 0x000fce00078e00ffULL,
0x000000105e00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003e7805ULL, 0x002fce0000015200ULL, 0x0000003e3c5f7210ULL, 0x000fca0007f1e1ffULL,
0x000000013f3f7824ULL, 0x000fe200000e0e3dULL, 0x003d09005f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c405f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff3e7819ULL, 0x000fc8000001143fULL,
0x0000005f3e3e7211ULL, 0x000fc800078110ffULL, 0x0000003fff3f7210ULL, 0x000fc800007fe4ffULL,
0x000000023e3e7819ULL, 0x000fc8000000123fULL, 0x0000003e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000015e5e7836ULL, 0x000fce0000000000ULL,
0x01e6685d650075a7ULL, 0x000ea4000800017fULL, 0xfffffffc00a88947ULL, 0x004fea000383ffffULL,
0x000000030d3d7836ULL, 0x000fe20000000000ULL, 0x0000008100887202ULL, 0x000fc60000000f00ULL,
0x000000803d3c7824ULL, 0x000fca00078e020aULL, 0x0000003c143c7210ULL, 0x000fca0007ffe015ULL,
0x01e000003c3e7984ULL, 0x002e680000000800ULL, 0x01e200003c877984ULL, 0x0004a20000000800ULL,
0x000000813e00720bULL, 0x002fda0003f1d000ULL, 0x00000000003f7806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x000000ff3f00720cULL, 0x000fda0003f25270ULL,
0x0000000400909947ULL, 0x004fea0003800000ULL, 0x000000033d00720cULL, 0x000fe40003f25270ULL,
0x000000813e00720bULL, 0x000fd60003f14000ULL, 0x00000080035c9824ULL, 0x000fe200078e020aULL,
0x000000813e3c9209ULL, 0x000fc80007810000ULL, 0x0000005c14159210ULL, 0x000fe40007ffe015ULL,
0x00000000005c7806ULL, 0x000fc600000e0100ULL, 0x01e4003c15009388ULL, 0x0003e20000000800ULL,
0x000000ff5c00720cULL, 0x000fda0003f05270ULL, 0x0000000400548947ULL, 0x002fea0003800000ULL,
0x000000813e147209ULL, 0x000fe40007810000ULL, 0x000000ff5cff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff005cff7812ULL, 0x000fe2000782c0ffULL, 0x0000008114147221ULL, 0x000fe20000010100ULL,
0x00ff00005cff7812ULL, 0x040fe4000784c0ffULL, 0xff0000005cff7812ULL, 0x000fe2000786c0ffULL,
0x3fb8aa3b14147820ULL, 0x000fc80000410000ULL, 0x00000014003c7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff157819ULL, 0x000fca0000011608ULL,
0x00001f153c147589ULL, 0x006e6400000e0000ULL, 0x0000003014307220ULL, 0x042fe20000410000ULL,
0x0000003114317220ULL, 0x040fe20000410000ULL, 0x0000002c142c7220ULL, 0x040fe20000410000ULL,
0x0000002d142d7220ULL, 0x040fe20000410000ULL, 0x0000002814287220ULL, 0x040fe20000410000ULL,
0x0000002914297220ULL, 0x040fe20000410000ULL, 0x0000007414747220ULL, 0x040fe20000410000ULL,
0x0000007514757220ULL, 0x040fe20000410000ULL, 0x0000007c147c7220ULL, 0x040fe20000410000ULL,
0x0000007d147d7220ULL, 0x040fe20000410000ULL, 0x0000007814787220ULL, 0x040fe20000410000ULL,
0x0000007914797220ULL, 0x040fe20000410000ULL, 0x0000006014607220ULL, 0x040fe20000410000ULL,
0x0000006114617220ULL, 0x040fe20000410000ULL, 0x0000003814387220ULL, 0x040fe20000410000ULL,
0x0000003914397220ULL, 0x000fce0000410000ULL, 0x0000000000489947ULL, 0x000fea0003800000ULL,
0x0000000808157811ULL, 0x000fca00078ff0ffULL, 0x00001f153c147589ULL, 0x006e6400000e0000ULL,
0x0000003214327220ULL, 0x042fe20000410000ULL, 0x0000003314337220ULL, 0x040fe20000410000ULL,
0x0000002e142e7220ULL, 0x040fe20000410000ULL, 0x0000002f142f7220ULL, 0x040fe20000410000ULL,
0x0000002a142a7220ULL, 0x040fe20000410000ULL, 0x0000002b142b7220ULL, 0x040fe20000410000ULL,
0x0000007614767220ULL, 0x040fe20000410000ULL, 0x0000007714777220ULL, 0x040fe20000410000ULL,
0x0000007e147e7220ULL, 0x040fe20000410000ULL, 0x0000007f147f7220ULL, 0x040fe20000410000ULL,
0x0000007a147a7220ULL, 0x040fe20000410000ULL, 0x0000007b147b7220ULL, 0x040fe20000410000ULL,
0x0000006214627220ULL, 0x040fe20000410000ULL, 0x0000006314637220ULL, 0x040fe20000410000ULL,
0x0000003a143a7220ULL, 0x040fe20000410000ULL, 0x0000003b143b7220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x0000001008157811ULL, 0x000fca00078ff0ffULL,
0x00001f153c147589ULL, 0x006e6400000e0000ULL, 0x0000005814587220ULL, 0x042fe20000410000ULL,
0x0000005914597220ULL, 0x040fe20000410000ULL, 0x0000005414547220ULL, 0x040fe20000410000ULL,
0x0000005514557220ULL, 0x040fe20000410000ULL, 0x0000005014507220ULL, 0x040fe20000410000ULL,
0x0000005114517220ULL, 0x040fe20000410000ULL, 0x0000004c144c7220ULL, 0x040fe20000410000ULL,
0x0000004d144d7220ULL, 0x040fe20000410000ULL, 0x0000004814487220ULL, 0x040fe20000410000ULL,
0x0000004914497220ULL, 0x040fe20000410000ULL, 0x0000004414447220ULL, 0x040fe20000410000ULL,
0x0000004514457220ULL, 0x040fe20000410000ULL, 0x0000004014407220ULL, 0x040fe20000410000ULL,
0x0000004114417220ULL, 0x040fe20000410000ULL, 0x0000003414347220ULL, 0x040fe20000410000ULL,
0x0000003514357220ULL, 0x000fce0000410000ULL, 0x0000003c85857220ULL, 0x004fe20000410000ULL,
0x000000000048b947ULL, 0x000fec0003800000ULL, 0x0000001808157811ULL, 0x000fca00078ff0ffULL,
0x00001f153c147589ULL, 0x002e6400000e0000ULL, 0x0000005a145a7220ULL, 0x042fe20000410000ULL,
0x0000005b145b7220ULL, 0x040fe20000410000ULL, 0x0000005614567220ULL, 0x040fe20000410000ULL,
0x0000005714577220ULL, 0x040fe20000410000ULL, 0x0000005214527220ULL, 0x040fe20000410000ULL,
0x0000005314537220ULL, 0x040fe20000410000ULL, 0x0000004e144e7220ULL, 0x040fe20000410000ULL,
0x0000004f144f7220ULL, 0x040fe20000410000ULL, 0x0000004a144a7220ULL, 0x040fe20000410000ULL,
0x0000004b144b7220ULL, 0x040fe20000410000ULL, 0x0000004614467220ULL, 0x040fe20000410000ULL,
0x0000004714477220ULL, 0x040fe20000410000ULL, 0x0000004214427220ULL, 0x040fe20000410000ULL,
0x0000004314437220ULL, 0x040fe20000410000ULL, 0x0000003614367220ULL, 0x040fe20000410000ULL,
0x0000003714377220ULL, 0x000fce0000410000ULL, 0x0000005c3fff7212ULL, 0x000fe400078030ffULL,
0x000000813e887209ULL, 0x000fd60007810000ULL, 0x800000883e3e0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b3e3e0820ULL, 0x000fc80000410000ULL, 0x0000003e00160308ULL, 0x000ea40000000800ULL,
0x0000001687870220ULL, 0x004fce0000410000ULL, 0x000010003d3d7824ULL, 0x000fe200078e020aULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00004000273c7824ULL, 0x000fe200078e020aULL,
0x000120003d147810ULL, 0x002fc60007ffe0ffULL, 0x00002000113c7824ULL, 0x000fe400078e023cULL,
0x0000001017177824ULL, 0x100fe400078e0214ULL, 0x0000001018187824ULL, 0x000fe200078e0214ULL,
0x000170003c897810ULL, 0x000fe20007ffe0ffULL, 0x0000000000288947ULL, 0x000fec0003800000ULL,
0x00000002ff3c7819ULL, 0x000fe40000011608ULL, 0x00000016ff15723eULL, 0x000fc600000000ffULL,
0x000000083c1e7836ULL, 0x000fe20000000000ULL, 0x0000541015157816ULL, 0x000fe20000000015ULL,
0x000000183c207836ULL, 0x000fe40000000000ULL, 0x000000103c3e7836ULL, 0x000fe40000000000ULL,
0x00001f1e151e7589ULL, 0x0002a800000e0000ULL, 0x00001f3e151d7589ULL, 0x0002e800000e0000ULL,
0x00001f3c151f7589ULL, 0x00026800000e0000ULL, 0x00001f2015207589ULL, 0x00026400000e0000ULL,
0x00000000175c783bULL, 0x0006a20000000200ULL, 0x000000891a647211ULL, 0x000fe200078e20ffULL,
0x0000001019687824ULL, 0x000fe400078e0289ULL, 0x00000000183c783bULL, 0x0026620000000200ULL,
0x0000000000208947ULL, 0x000fea0003800000ULL, 0x0000001f5c5c7232ULL, 0x084fe40000000000ULL,
0x0000001f5e5e7232ULL, 0x000fe40000000000ULL, 0x0000001e5d5d7232ULL, 0x080fe40000000000ULL,
0x0000001e5f5f7232ULL, 0x000fe40000000000ULL, 0x0000001d3c3c7232ULL, 0x08afe40000000000ULL,
0x0000001d3e3e7232ULL, 0x000fc40000000000ULL, 0x000000203d3d7232ULL, 0x080fe40000000000ULL,
0x000000203f3f7232ULL, 0x000fce0000000000ULL, 0x000000101b1b7824ULL, 0x100fe200078e0289ULL,
0x000000006464783bULL, 0x000f620000004200ULL, 0x000000101c6c7824ULL, 0x000fe200078e0289ULL,
0x0000001421217211ULL, 0x000fe200078e20ffULL, 0x0000001022147824ULL, 0x000fe200078e0214ULL,
0x000000006868783bULL, 0x000f620000004200ULL, 0x0000008587857221ULL, 0x000fc60000010000ULL,
0x000000001b18783bULL, 0x008ee80000004200ULL, 0x000000006c6c783bULL, 0x000ee80000004200ULL,
0x000000002170783bULL, 0x0006e20000000200ULL, 0x000000645c30723cULL, 0x024fec0000001830ULL,
0x000000665c2c723cULL, 0x000fec000000182cULL, 0x000000685c80723cULL, 0x000fe20000001828ULL,
0x000000001428783bULL, 0x0004aa0000000200ULL, 0x0000006a5c74723cULL, 0x000fec0000001874ULL,
0x000000185c7c723cULL, 0x008fec000000187cULL, 0x0000001a5c78723cULL, 0x000fec0000001878ULL,
0x0000006c5c60723cULL, 0x002fec0000001860ULL, 0x000000643c58723cULL, 0x000fec0000001858ULL,
0x000000663c54723cULL, 0x000fec0000001854ULL, 0x000000683c50723cULL, 0x000fec0000001850ULL,
0x0000006a3c4c723cULL, 0x000fec000000184cULL, 0x000000183c48723cULL, 0x000fec0000001848ULL,
0x0000001a3c44723cULL, 0x000fec0000001844ULL, 0x0000006c3c40723cULL, 0x000fec0000001840ULL,
0x0000006e5c5c723cULL, 0x000fec0000001838ULL, 0x0000006e3c3c723cULL, 0x000fe20000001834ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000000208947ULL, 0x004fde0003800000ULL,
0x0000001f70707232ULL, 0x080fe40000000000ULL, 0x0000001f72727232ULL, 0x000fe40000000000ULL,
0x0000001e71717232ULL, 0x080fe40000000000ULL, 0x0000001e73737232ULL, 0x000fe40000000000ULL,
0x0000001d28287232ULL, 0x080fe40000000000ULL, 0x0000001d2a2a7232ULL, 0x000fc40000000000ULL,
0x0000002029297232ULL, 0x080fe40000000000ULL, 0x000000202b2b7232ULL, 0x000fce0000000000ULL,
0x0000001023387824ULL, 0x100fe200078e0289ULL, 0x0000008925347211ULL, 0x000fe200078e20ffULL,
0x0000001024647824ULL, 0x100fe200078e0289ULL, 0x0000000c0500720cULL, 0x000fe20003f06070ULL,
0x0000001026187824ULL, 0x000fe400078e0289ULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x000000080d147824ULL, 0x000fe400078e020aULL, 0x00000001ff157424ULL, 0x000fe200078e00ffULL,
0x000000006464783bULL, 0x000ea80000004200ULL, 0x000000003434783bULL, 0x000ee80000004200ULL,
0x000000001818783bULL, 0x000f620000004200ULL, 0x01e6a01514ff79a7ULL, 0x0003e4000850003fULL,
0x000000387030723cULL, 0x002fec0000001830ULL, 0x0000003a702c723cULL, 0x000fec000000182cULL,
0x000000647068723cULL, 0x004fec0000001880ULL, 0x000000667074723cULL, 0x000fec0000001874ULL,
0x00000034707c723cULL, 0x008fec000000187cULL, 0x000000367078723cULL, 0x000fec0000001878ULL,
0x000000187060723cULL, 0x020fec0000001860ULL, 0x0000001a705c723cULL, 0x000fec000000185cULL,
0x000000382858723cULL, 0x000fec0000001858ULL, 0x0000003a2854723cULL, 0x000fec0000001854ULL,
0x000000642850723cULL, 0x000fec0000001850ULL, 0x00000066284c723cULL, 0x000fec000000184cULL,
0x000000342848723cULL, 0x000fec0000001848ULL, 0x000000362844723cULL, 0x000fec0000001844ULL,
0x000000182840723cULL, 0x000fec0000001840ULL, 0x0000001a283c723cULL, 0x000fe2000000183cULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0xffffff8800888947ULL, 0x000fde000383ffffULL,
0x0000000000097919ULL, 0x000e620000002500ULL, 0x00000033001c7202ULL, 0x000fe20000000f00ULL,
0x000000ffff157224ULL, 0x000fe200078e0031ULL, 0x0000000c0900720cULL, 0x002fda0003f06070ULL,
0x0000000400580947ULL, 0x000fea0003800000ULL, 0x0180000085057836ULL, 0x000fca0000000000ULL,
0x7f80000005057812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0500780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x00009650000c7802ULL, 0x000fce0000000f00ULL,
0x000000ec00487944ULL, 0x010fea0003c00000ULL, 0x000000ffff057224ULL, 0x00cfe200078e0008ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000008500087308ULL, 0x000e640000001000ULL,
0xbf80000008057423ULL, 0x002fc80000000085ULL, 0x800000ff05057221ULL, 0x000fc80000010100ULL,
0x0000000508057223ULL, 0x000fce0000000008ULL, 0x00000000000c7919ULL, 0x000ea40000000000ULL,
0x00000002ff087819ULL, 0x004fe4000001160cULL, 0x000000080c107811ULL, 0x040fe400078ff0ffULL,
0x000000100c127811ULL, 0x040fe400078ff0ffULL, 0x000000180c147811ULL, 0x000fe200078ff0ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0805087589ULL, 0x000ea800000e0000ULL,
0x00001f10050b7589ULL, 0x000ee800000e0000ULL, 0x00001f12050c7589ULL, 0x000f6800000e0000ULL,
0x00001f14050d7589ULL, 0x000ee200000e0000ULL, 0x0000003008307220ULL, 0x044fe20000410000ULL,
0x0000001508157220ULL, 0x040fe20000410000ULL, 0x0000002c082c7220ULL, 0x040fe20000410000ULL,
0x0000002d082d7220ULL, 0x040fe20000410000ULL, 0x0000006808687220ULL, 0x040fe20000410000ULL,
0x0000006908697220ULL, 0x040fe20000410000ULL, 0x0000007408747220ULL, 0x040fe20000410000ULL,
0x0000007508757220ULL, 0x040fe20000410000ULL, 0x0000007c087c7220ULL, 0x040fe20000410000ULL,
0x0000007d087d7220ULL, 0x040fe20000410000ULL, 0x0000007808787220ULL, 0x040fe20000410000ULL,
0x0000007908797220ULL, 0x040fe20000410000ULL, 0x0000006008607220ULL, 0x040fe20000410000ULL,
0x0000006108617220ULL, 0x040fe20000410000ULL, 0x0000005c085c7220ULL, 0x040fe20000410000ULL,
0x0000005d085d7220ULL, 0x000fe20000410000ULL, 0x000000320b327220ULL, 0x048fe20000410000ULL,
0x0000001c0b1c7220ULL, 0x040fe20000410000ULL, 0x0000002e0b2e7220ULL, 0x040fe20000410000ULL,
0x0000002f0b2f7220ULL, 0x040fe20000410000ULL, 0x0000006a0b6a7220ULL, 0x040fe20000410000ULL,
0x0000006b0b6b7220ULL, 0x040fe20000410000ULL, 0x000000760b767220ULL, 0x040fe20000410000ULL,
0x000000770b777220ULL, 0x040fe20000410000ULL, 0x0000007e0b7e7220ULL, 0x040fe20000410000ULL,
0x0000007f0b7f7220ULL, 0x040fe20000410000ULL, 0x0000007a0b7a7220ULL, 0x040fe20000410000ULL,
0x0000007b0b7b7220ULL, 0x040fe20000410000ULL, 0x000000620b627220ULL, 0x040fe20000410000ULL,
0x000000630b637220ULL, 0x040fe20000410000ULL, 0x0000005e0b5e7220ULL, 0x040fe20000410000ULL,
0x0000005f0b5f7220ULL, 0x000fe20000410000ULL, 0x000000580c587220ULL, 0x062fe20000410000ULL,
0x000000590c597220ULL, 0x040fe20000410000ULL, 0x000000540c547220ULL, 0x040fe20000410000ULL,
0x000000550c557220ULL, 0x040fe20000410000ULL, 0x000000500c507220ULL, 0x040fe20000410000ULL,
0x000000510c517220ULL, 0x040fe20000410000ULL, 0x0000004c0c4c7220ULL, 0x040fe20000410000ULL,
0x0000004d0c4d7220ULL, 0x040fe20000410000ULL, 0x000000480c487220ULL, 0x040fe20000410000ULL,
0x000000490c497220ULL, 0x040fe20000410000ULL, 0x000000440c447220ULL, 0x040fe20000410000ULL,
0x000000450c457220ULL, 0x040fe20000410000ULL, 0x000000400c407220ULL, 0x040fe20000410000ULL,
0x000000410c417220ULL, 0x040fe20000410000ULL, 0x0000003c0c3c7220ULL, 0x040fe20000410000ULL,
0x0000003d0c3d7220ULL, 0x000fe20000410000ULL, 0x0000005a0d5a7220ULL, 0x040fe20000410000ULL,
0x0000005b0d5b7220ULL, 0x040fe20000410000ULL, 0x000000560d567220ULL, 0x040fe20000410000ULL,
0x000000570d577220ULL, 0x040fe20000410000ULL, 0x000000520d527220ULL, 0x040fe20000410000ULL,
0x000000530d537220ULL, 0x040fe20000410000ULL, 0x0000004e0d4e7220ULL, 0x040fe20000410000ULL,
0x0000004f0d4f7220ULL, 0x040fe20000410000ULL, 0x0000004a0d4a7220ULL, 0x040fe20000410000ULL,
0x0000004b0d4b7220ULL, 0x040fe20000410000ULL, 0x000000460d467220ULL, 0x040fe20000410000ULL,
0x000000470d477220ULL, 0x040fe20000410000ULL, 0x000000420d427220ULL, 0x040fe20000410000ULL,
0x000000430d437220ULL, 0x040fe20000410000ULL, 0x0000003e0d3e7220ULL, 0x040fe20000410000ULL,
0x0000003f0d3f7220ULL, 0x000fce0000410000ULL, 0x00000000000f7919ULL, 0x000e620000000000ULL,
0x000000747517723eULL, 0x000fe400000000ffULL, 0x000000787919723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000005c5d1b723eULL, 0x000fc400000000ffULL,
0x000000321c1c723eULL, 0x000fe400000000ffULL, 0x0000002e2f1d723eULL, 0x000fe400000000ffULL,
0x0000006a6b1e723eULL, 0x000fe400000000ffULL, 0x00000076771f723eULL, 0x000fe400000000ffULL,
0x0000007e7f20723eULL, 0x000fe400000000ffULL, 0x0000007a7b21723eULL, 0x000fc400000000ffULL,
0x000000626322723eULL, 0x000fe400000000ffULL, 0x0000005e5f23723eULL, 0x000fe400000000ffULL,
0x000000585928723eULL, 0x000fe400000000ffULL, 0x000000545529723eULL, 0x000fe400000000ffULL,
0x0000ffff0f057812ULL, 0x002fe400078ec0ffULL, 0xfffffff8ff0b7812ULL, 0x000fc400078ee20fULL,
0x00000003ff057819ULL, 0x000fe40000011605ULL, 0x000000180b127810ULL, 0x000fe20007ffe0ffULL,
0x000000080b0c7836ULL, 0x000fe20000000000ULL, 0x0000000305087812ULL, 0x000fe200078ec0ffULL,
0x000000100b107836ULL, 0x000fe20000000000ULL, 0x000000030b147819ULL, 0x040fe200000006ffULL,
0x000000080c167824ULL, 0x000fe200078e00ffULL, 0x000000030b0b7819ULL, 0x000fe200000006ffULL,
0x0000000108087824ULL, 0x100fe200078e020fULL, 0x00000050512a723eULL, 0x000fe200000000ffULL,
0x0000000810187824ULL, 0x000fe200078e00ffULL, 0x0000004c4d2b723eULL, 0x000fe200000000ffULL,
0x00000008121a7824ULL, 0x000fe200078e00ffULL, 0x0000000708057812ULL, 0x000fe200078ec0ffULL,
0x000000080c257824ULL, 0x000fe200078e00ffULL, 0x0000000408087812ULL, 0x000fe200078e3cffULL,
0x0000000810337824ULL, 0x000fe200078e00ffULL, 0xfffffff8140d7812ULL, 0x000fe200078ee205ULL,
0x0000000812377824ULL, 0x000fe200078e00ffULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x000000010e0c7824ULL, 0x000fe200078e020fULL, 0xfffffff816137812ULL, 0x000fc400078ee205ULL,
0xfffffff818317812ULL, 0x000fe400078ee205ULL, 0xfffffff81a357812ULL, 0x000fe400078ee205ULL,
0xfffffff80b0b7812ULL, 0x000fe400078ee208ULL, 0xfffffff825257812ULL, 0x000fe400078ee208ULL,
0xfffffff833337812ULL, 0x000fe400078ee208ULL, 0xfffffff837377812ULL, 0x000fe200078ee208ULL,
0x0000100027087824ULL, 0x000fe200078e00ffULL, 0x0000000a11057211ULL, 0x000fc400078e68ffULL,
0x000000301514723eULL, 0x000fe400000000ffULL, 0x0000002c2d15723eULL, 0x000fe200000000ffULL,
0x0000000105107824ULL, 0x000fe200078e0208ULL, 0x000000686916723eULL, 0x000fe400000000ffULL,
0x0000007c7d18723eULL, 0x000fe200000000ffULL, 0x000000100d0d7824ULL, 0x100fe200078e0210ULL,
0x00000060611a723eULL, 0x000fe200000000ffULL, 0x000000100b0b7824ULL, 0x100fe200078e0210ULL,
0x0000001013137211ULL, 0x000fe200078e20ffULL, 0x0000001025257824ULL, 0x100fe200078e0210ULL,
0x000000140d007844ULL, 0x0003e20000000200ULL, 0x0000001031317824ULL, 0x100fe200078e0210ULL,
0x00000048492c723eULL, 0x000fe200000000ffULL, 0x0000001035357824ULL, 0x100fe200078e0210ULL,
0x00000044452d723eULL, 0x000fe200000000ffULL, 0x000000180b007844ULL, 0x0005e20000000200ULL,
0x00000040412e723eULL, 0x000fe200000000ffULL, 0x0000001037377824ULL, 0x000fe200078e0210ULL,
0x0000003c3d2f723eULL, 0x000fe200000000ffULL, 0x0000001c13007844ULL, 0x000fe20000000200ULL,
0x0000001033337211ULL, 0x000fc400078e20ffULL, 0x000000010000780cULL, 0x000fe20003f05270ULL,
0x0000002025007844ULL, 0x000fe20000000200ULL, 0x0000005a5b14723eULL, 0x002fc600000000ffULL,
0x0000002831007844ULL, 0x000fe20000000200ULL, 0x000000565715723eULL, 0x000fe400000000ffULL,
0x000000525316723eULL, 0x000fe200000000ffULL, 0x0000002c33007844ULL, 0x000fe20000000200ULL,
0x0000004e4f17723eULL, 0x000fe400000000ffULL, 0x0000004a4b18723eULL, 0x004fe400000000ffULL,
0x000000464719723eULL, 0x000fe200000000ffULL, 0x0000001435007844ULL, 0x000fe20000000200ULL,
0x00000042431a723eULL, 0x000fc400000000ffULL, 0x0000003e3f1b723eULL, 0x000fe400000000ffULL,
0x000000050c0d7211ULL, 0x000fc600078e20ffULL, 0x0000001837007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000d1c7984ULL, 0x000e680000000c00ULL,
0x000400000d387984ULL, 0x000ea80000000c00ULL, 0x000800000d407984ULL, 0x000ee80000000c00ULL,
0x000c00000d2c7984ULL, 0x000f680000000c00ULL, 0x001000000d207984ULL, 0x000ee80000000c00ULL,
0x001400000d3c7984ULL, 0x000f680000000c00ULL, 0x001800000d287984ULL, 0x000f680000000c00ULL,
0x001c00000d147984ULL, 0x000f620000000c00ULL, 0x200000ff1f1f7230ULL, 0x002fc40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fe40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x200000ff3b3b7230ULL, 0x004fe40000000000ULL,
0x200000ff3a3a7230ULL, 0x000fe40000000000ULL, 0x200000ff39397230ULL, 0x000fc40000000000ULL,
0x200000ff38387230ULL, 0x000fe40000000000ULL, 0x200000ff43437230ULL, 0x008fe40000000000ULL,
0x200000ff42427230ULL, 0x000fe40000000000ULL, 0x200000ff41417230ULL, 0x000fe40000000000ULL,
0x200000ff40407230ULL, 0x000fe40000000000ULL, 0x200000ff2f2f7230ULL, 0x020fc40000000000ULL,
0x200000ff2e2e7230ULL, 0x000fe40000000000ULL, 0x200000ff2d2d7230ULL, 0x000fe40000000000ULL,
0x200000ff2c2c7230ULL, 0x000fe40000000000ULL, 0x000000231f1f7230ULL, 0x000fe40000000000ULL,
0x000000221e1e7230ULL, 0x000fe40000000000ULL, 0x000000211d1d7230ULL, 0x000fc40000000000ULL,
0x000000201c1c7230ULL, 0x000fe40000000000ULL, 0x0000003f3b3b7230ULL, 0x000fe40000000000ULL,
0x0000003e3a3a7230ULL, 0x000fe20000000000ULL, 0x0000001c0d007388ULL, 0x0003e20000000c00ULL,
0x0000003d39397230ULL, 0x000fe40000000000ULL, 0x0000003c38387230ULL, 0x000fe40000000000ULL,
0x0000002b43437230ULL, 0x000fc40000000000ULL, 0x0000002a42427230ULL, 0x000fe20000000000ULL,
0x000400380d007388ULL, 0x0003e20000000c00ULL, 0x0000002941417230ULL, 0x000fe40000000000ULL,
0x0000002840407230ULL, 0x000fe40000000000ULL, 0x000000172f2f7230ULL, 0x000fe40000000000ULL,
0x000000162e2e7230ULL, 0x000fe20000000000ULL, 0x000800400d007388ULL, 0x0003e20000000c00ULL,
0x000000152d2d7230ULL, 0x000fc40000000000ULL, 0x000000142c2c7230ULL, 0x000fca0000000000ULL,
0x000c002c0d007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000003400608947ULL, 0x000fea0003800000ULL, 0x00000400ff137b82ULL, 0x000ea20000000800ULL,
0x0000000000147919ULL, 0x000ee20000002600ULL, 0x000000800c177836ULL, 0x000fe20000000000ULL,
0x000000c00c197810ULL, 0x000fe20007ffe0ffULL, 0x0000000000157919ULL, 0x000ee80000002700ULL,
0x00009600ff0a7b82ULL, 0x000ea20000000800ULL, 0x000000000d207984ULL, 0x000f680000000c00ULL,
0x000400000d287984ULL, 0x000f660000000c00ULL, 0x00009a00ff387b82ULL, 0x002e620000000a00ULL,
0x000800000d2c7984ULL, 0x000f680000000c00ULL, 0x000c00000d307984ULL, 0x0003620000000c00ULL,
0x0000000a130b7224ULL, 0x004fc800078e02ffULL, 0x000000000b127224ULL, 0x040fe200078e02ffULL,
0x0000000f0b0a7811ULL, 0x000fe200078e10ffULL, 0x0000001315137224ULL, 0x008fe400078e0214ULL,
0x000000400c157836ULL, 0x000fe20000000000ULL, 0xfffffff00a257812ULL, 0x000fca00078ec0ffULL,
0x00000080121d7824ULL, 0x000fc800078e0225ULL, 0x0000008012127824ULL, 0x000fc800078e021dULL,
0x0000007f120a7836ULL, 0x000fe40000000000ULL, 0x0000000013127224ULL, 0x000fc600078e02ffULL,
0xffffff800a1f7812ULL, 0x000fe400078ec0ffULL, 0x0000000912097210ULL, 0x000fe40007ffe0ffULL,
0x000000381f0a7210ULL, 0x002fc80007f1e0ffULL, 0x0000000a090a7211ULL, 0x000fe200078268ffULL,
0x000000ffff147224ULL, 0x000fe200000e0639ULL, 0x0000000127ff7812ULL, 0x000fc8000780f803ULL,
0x00000014090b7211ULL, 0x000fe400008f6cffULL, 0x0000003825357210ULL, 0x000fe20007f3e0ffULL,
0x00001000110a7825ULL, 0x000fc800078e000aULL, 0x000000ffff377224ULL, 0x000fe400008e0639ULL,
0x000000100c0c7825ULL, 0x000fc800078e000aULL, 0x0000001015147825ULL, 0x000fc800078e000aULL,
0x0000001017167825ULL, 0x000fc800078e000aULL, 0x00000010190a7825ULL, 0x000fe200078e000aULL,
0x0000000000400947ULL, 0x020fec0003800000ULL, 0x000000100f197824ULL, 0x000fe200078e00ffULL,
0x00000001ff1a7819ULL, 0x000fe2000001160fULL, 0x0000008009187824ULL, 0x000fe200078e00ffULL,
0x00000019ff1c7819ULL, 0x000fe40000011609ULL, 0x0000007019197812ULL, 0x000fe400078ec0ffULL,
0x0000000c1a1b7812ULL, 0x000fe400078ec0ffULL, 0x00000038181a7210ULL, 0x000fe40007ebe01dULL,
0x0000003519187210ULL, 0x000fc40007a3e018ULL, 0x000000391c097210ULL, 0x000fe40002fec4ffULL,
0x000000181b187210ULL, 0x000fe40007fbe0ffULL, 0x00000037ff1c7210ULL, 0x000fe40000fe441cULL,
0x0000001a1b1a7210ULL, 0x000fe40007c7e019ULL, 0x0000001cff197210ULL, 0x000fe40002ffe4ffULL,
0x00000009ff1b7210ULL, 0x000fc60001fe84ffULL, 0x0000008818007986ULL, 0x0003e8000c101906ULL,
0x000000851a007986ULL, 0x0003e4000c101906ULL, 0x000000ff0f00720cULL, 0x000fe20000705670ULL,
0x000000200c007986ULL, 0x0005e8000c101d06ULL, 0x0000002814007986ULL, 0x0005e8000c101d06ULL,
0x0000002c16007986ULL, 0x0005e8000c101d06ULL, 0x000000300a007986ULL, 0x0005e2000c101d06ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000000700947ULL, 0x000fea0003800000ULL,
0x00009a00ff0a7b82ULL, 0x004ea20000000a00ULL, 0xffffffff00097836ULL, 0x000fe40000000000ULL,
0x00000004130a7825ULL, 0x004fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000000ff00798fULL, 0x000fe20002000000ULL,
0x000000090a0a79a8ULL, 0x00052200099ee1c6ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000000075abULL, 0x000fec0000000000ULL, 0x00000000ff00798fULL, 0x000fe20002000000ULL,
0x00000000000579c3ULL, 0x000ee20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000090a00720cULL, 0x010fc80003f05270ULL, 0x00000001ff097807ULL, 0x004fe20000000000ULL,
0x0000065405047896ULL, 0x008fd20008000004ULL, 0x00000009ff007988ULL, 0x0005e60008000004ULL,
0x0000000000097919ULL, 0x004ea20000008800ULL, 0x0000040000247802ULL, 0x000fe20000000f00ULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000065409247816ULL, 0x004fca0000000024ULL, 0x0000000024097984ULL, 0x000ea40000000000ULL,
0x000000ff0900720cULL, 0x004fda0003f05270ULL, 0x0000002c00e48947ULL, 0x000fea0003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x0000000800940947ULL, 0x000fea0003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x00000000006c8947ULL, 0x000fea0003800000ULL,
0x000000100f037824ULL, 0x000fe200078e00ffULL, 0x00000001ff097819ULL, 0x000fe4000001160fULL,
0x00000035120a7211ULL, 0x040fe400078038ffULL, 0x00000070030b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097812ULL, 0x000fe400078ec0ffULL, 0x0000003712037211ULL, 0x000fe400000f3cffULL,
0x0000000a090a7210ULL, 0x000fc8000791e00bULL, 0x00000003ff0b7210ULL, 0x000fca00007e24ffULL,
0x000000060a037981ULL, 0x000528000c1e1900ULL, 0x000080060a147981ULL, 0x000522000c1e1900ULL,
0x000000020000780cULL, 0x000fda0003f05270ULL, 0x00000000003c8947ULL, 0x004fea0003800000ULL,
0x000100060a167981ULL, 0x000522000c1e1900ULL, 0x000000040000780cULL, 0x000fda0003f06070ULL,
0x0000000000308947ULL, 0x004fea0003800000ULL, 0x000180060a187981ULL, 0x002322000c1e1900ULL,
0x000000040000780cULL, 0x000fda0003f05270ULL, 0x0000000000248947ULL, 0x002fea0003800000ULL,
0x000200060a1a7981ULL, 0x000322000c1e1900ULL, 0x000000060000780cULL, 0x000fda0003f06070ULL,
0x0000000000188947ULL, 0x002fea0003800000ULL, 0x000280060a1c7981ULL, 0x000322000c1e1900ULL,
0x000000060000780cULL, 0x000fda0003f05270ULL, 0x00000000000c8947ULL, 0x002fea0003800000ULL,
0x000000080000780cULL, 0x000fe20003f06070ULL, 0x000300060a1e7981ULL, 0x000318000c1e1900ULL,
0x000380060a200981ULL, 0x000324000c1e1900ULL, 0x0000000700097836ULL, 0x000fca0000000000ULL,
0x00000003ff097819ULL, 0x000fc80000011609ULL, 0x000000ff0900720cULL, 0x000fda0003f05270ULL,
0x0000000400f48947ULL, 0x000fea0003800000ULL, 0x00000025120d7211ULL, 0x040fe200078038ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x00000003000c7202ULL, 0x010fe20000000f00ULL,
0x0000003f00057c82ULL, 0x000fe20008000000ULL, 0x000000380d0d7210ULL, 0x000fe40007f3e0ffULL,
0x000000ff120a7211ULL, 0x002fe400000f3cffULL, 0x000007800d0d7810ULL, 0x000fc80007f5e0ffULL,
0x0000000aff137210ULL, 0x000fd200017e2439ULL, 0x0000000400007c0cULL, 0x000fe2000bf23070ULL,
0x0000000105057890ULL, 0x000fcc000fffe03fULL, 0x0000000509007c0cULL, 0x000fcc000bf03070ULL,
0x0000000400b41947ULL, 0x012fee0003800000ULL, 0x0000000804087890ULL, 0x000fe2000fffe03fULL,
0x0000000c03037209ULL, 0x000fca0007810000ULL, 0x0000000800007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x000000100f0a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc8000001160fULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ef80bULL, 0x0000000a0d0a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fca00008e0613ULL, 0xfffc80060a0c7981ULL, 0x000326000c1e1900ULL,
0x0000000104087890ULL, 0x000fcc000fffe03fULL, 0x0000000800007c0cULL, 0x000fda000bf23070ULL,
0x00000004007c1947ULL, 0x000fea0003800000ULL, 0x0000000904087890ULL, 0x000fe2000fffe03fULL,
0x0000001403037209ULL, 0x000fca0007810000ULL, 0x0000000800007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x000000100f0a7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc8000001160fULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ef80bULL, 0x0000000a0d0a7210ULL, 0x000fc80007f3e0ffULL,
0x00000013ff0b7210ULL, 0x000fca0000ffe4ffULL, 0xfffd00060a147981ULL, 0x000328000c1e1900ULL,
0x0000000204087890ULL, 0x000fcc000fffe03fULL, 0x0000000800007c0cULL, 0x000fda000bf23070ULL,
0x0000000400441947ULL, 0x000fea0003800000ULL, 0x0000000a04087890ULL, 0x000fe2000fffe03fULL,
0x0000001603037209ULL, 0x000fca0007810000ULL, 0x0000000800007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x000000100f0a7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc8000001160fULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ef80bULL, 0x0000000a0d0a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fca00008e0613ULL, 0xfffd80060a167981ULL, 0x000326000c1e1900ULL,
0x0000000304087890ULL, 0x000fcc000fffe03fULL, 0x0000000800007c0cULL, 0x000fda000bf23070ULL,
0x00000004000c1947ULL, 0x000fea0003800000ULL, 0x0000000b04087890ULL, 0x000fe2000fffe03fULL,
0x0000001803037209ULL, 0x000fca0007810000ULL, 0x0000000800007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x000000100f0a7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc8000001160fULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ef80bULL, 0x0000000a0d0a7210ULL, 0x000fc80007f3e0ffULL,
0x00000013ff0b7210ULL, 0x000fca0000ffe4ffULL, 0xfffe00060a187981ULL, 0x000328000c1e1900ULL,
0x0000000404087890ULL, 0x000fcc000fffe03fULL, 0x0000000800007c0cULL, 0x000fda000bf23070ULL,
0x0000000000d41947ULL, 0x000fea0003800000ULL, 0x0000000c04087890ULL, 0x000fe2000fffe03fULL,
0x0000001a03037209ULL, 0x000fca0007810000ULL, 0x0000000800007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x000000100f0a7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc8000001160fULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ef80bULL, 0x0000000a0d0a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fca00008e0613ULL, 0xfffe80060a1a7981ULL, 0x000326000c1e1900ULL,
0x0000000504087890ULL, 0x000fcc000fffe03fULL, 0x0000000800007c0cULL, 0x000fda000bf23070ULL,
0x00000000009c1947ULL, 0x000fea0003800000ULL, 0x0000000d04087890ULL, 0x000fe2000fffe03fULL,
0x0000001c03037209ULL, 0x000fca0007810000ULL, 0x0000000800007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x000000100f0a7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc8000001160fULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ef80bULL, 0x0000000a0d0a7210ULL, 0x000fc80007f3e0ffULL,
0x00000013ff0b7210ULL, 0x000fca0000ffe4ffULL, 0xffff00060a1c7981ULL, 0x000328000c1e1900ULL,
0x0000000604087890ULL, 0x000fcc000fffe03fULL, 0x0000000800007c0cULL, 0x000fda000bf23070ULL,
0x0000000000641947ULL, 0x000fea0003800000ULL, 0x0000000e04087890ULL, 0x000fe2000fffe03fULL,
0x0000001e03037209ULL, 0x000fca0007810000ULL, 0x0000000800007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x000000100f0a7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc8000001160fULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ef80bULL, 0x0000000a0d0a7210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fca00008e0613ULL, 0xffff80060a1e7981ULL, 0x000326000c1e1900ULL,
0x0000000704087890ULL, 0x000fcc000fffe03fULL, 0x0000000800007c0cULL, 0x000fda000bf23070ULL,
0x00000000002c1947ULL, 0x000fea0003800000ULL, 0x0000000f04087890ULL, 0x000fe2000fffe03fULL,
0x0000002003037209ULL, 0x000fca0007810000ULL, 0x0000000800007c0cULL, 0x000fda000bf23070ULL,
0x00000000001c1947ULL, 0x000fea0003800000ULL, 0x000000100f0a7824ULL, 0x002fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fc8000001160fULL, 0x000000700a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ef80bULL, 0x0000000a0d0a7210ULL, 0x000fc80007f3e0ffULL,
0x00000013ff0b7210ULL, 0x000fca0000ffe4ffULL, 0x000000060a207981ULL, 0x000328000c1e1900ULL,
0x000004000d0d7810ULL, 0x000fe20007f3e0ffULL, 0x0000000804047890ULL, 0x000fc8000fffe03fULL,
0x000000ffff137224ULL, 0x000fe200008e0613ULL, 0xfffffff8002c8947ULL, 0x000fee000383ffffULL,
0x00000000000f7919ULL, 0x000ea40000000000ULL, 0x000000100f097824ULL, 0x004fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x002fc8000001160fULL, 0x0000007009097812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000240a0a7210ULL, 0x000fca0007ffe009ULL,
0x000000030a007388ULL, 0x0103e40000000800ULL, 0x00009a00ff227b82ULL, 0x000ea20000000a00ULL,
0x000000070f00780cULL, 0x000fe20003f04070ULL, 0x0000000127287824ULL, 0x040fe200078e0212ULL,
0x0000000127097812ULL, 0x040fe200078ec0ffULL, 0x0000400027267824ULL, 0x000fe200078e0224ULL,
0x0000000c11037819ULL, 0x002fe200000006ffULL, 0x000000100f2d7824ULL, 0x000fe200078e00ffULL,
0x000000400f177810ULL, 0x000fe20007ffe0ffULL, 0x0000200011267824ULL, 0x000fe200078e0226ULL,
0x00000001ff2c7819ULL, 0x000fe2000001160fULL, 0x000000200f157836ULL, 0x000fe20000000000ULL,
0x000000702d2d7812ULL, 0x000fe200078ec0ffULL, 0x000000600f197836ULL, 0x000fe20000000000ULL,
0x0000000c2c2c7812ULL, 0x000fe200078ec0ffULL, 0x00000200270a8824ULL, 0x140fe200078e0224ULL,
0x0000000000707805ULL, 0x000fe2000001ff00ULL, 0x0000020027168824ULL, 0x000fe200078e0224ULL,
0x000000242c2e7210ULL, 0x000fe20007ffe02dULL, 0x0000010011148824ULL, 0x040fe200078e020aULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000221f0c7210ULL, 0x004fe20007f3e0ffULL,
0x0000010011168824ULL, 0x000fe200078e0216ULL, 0x0000002225257210ULL, 0x000fe20007f7e0ffULL,
0x00000080092a8824ULL, 0x040fe200078e0214ULL, 0x00000023ff0d7210ULL, 0x000fe20000ffe4ffULL,
0x0000008009328824ULL, 0x000fe200078e0216ULL, 0x0000100008097812ULL, 0x000fe200078ec0ffULL,
0x000000800f1b7836ULL, 0x000fe20000000000ULL, 0x000000221d137210ULL, 0x000fe20007f3e0ffULL,
0x00002000280a7825ULL, 0x000fe200078e000cULL, 0x000000a00f1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000002e2e7984ULL, 0x000e620000000800ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x0000000126087824ULL, 0x000fe200078e0209ULL, 0x000000030a0a7210ULL, 0x000fe20007f5e0ffULL,
0x000000c00f1f7836ULL, 0x000fe20000000000ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x000000e00f217836ULL, 0x000fe20000000000ULL, 0x0000000bff0b7210ULL, 0x000fe200017fe4ffULL,
0x000000ffff2f7224ULL, 0x100fe200008e0623ULL, 0x000000080f297211ULL, 0x000fe200078e20ffULL,
0x000000ffff307224ULL, 0x000fe200018e0623ULL, 0x0000001328208211ULL, 0x040fe200078238ffULL,
0x0000001015087825ULL, 0x000fe200078e000aULL, 0x0000002528228211ULL, 0x000fc400078438ffULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000001017147825ULL, 0x100fe200078e000aULL, 0x0000003028238211ULL, 0x000fe400010f3cffULL,
0x00000000003c7805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x0000001019167825ULL, 0x000fe200078e000aULL, 0x0000000000407805ULL, 0x000fc4000001ff00ULL,
0x00000000006c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x000000101b187825ULL, 0x100fe200078e000aULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x0000000000467805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x000000101d1a7825ULL, 0x000fe200078e000aULL, 0x00000000004a7805ULL, 0x000fc4000001ff00ULL,
0x00000000004c7805ULL, 0x000fe4000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x000000101f1c7825ULL, 0x100fe200078e000aULL, 0x0000000000527805ULL, 0x000fe4000001ff00ULL,
0x0000000000507805ULL, 0x000fe4000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x00000010211e7825ULL, 0x000fe200078e000aULL, 0x0000002f28218211ULL, 0x000fc400008f3cffULL,
0x0000000000567805ULL, 0x000fe4000001ff00ULL, 0x000000002700720cULL, 0x000fe20003f26070ULL,
0x000000100f0a7825ULL, 0x000fe200078e000aULL, 0x0000000000587805ULL, 0x000fe4000001ff00ULL,
0x00000000006e7805ULL, 0x000fe4000001ff00ULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a297faeULL, 0x0005e2000b901c46ULL, 0x00000000005c7805ULL, 0x000fc4000001ff00ULL,
0x00000000005e7805ULL, 0x000fe4000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x0038000008297faeULL, 0x0007e2000b901c46ULL, 0x0000000000627805ULL, 0x000fe4000001ff00ULL,
0x0000000000647805ULL, 0x000fe4000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0058000014297faeULL, 0x000be2000b901c46ULL, 0x0000000000687805ULL, 0x000fc4000001ff00ULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x0078000016297faeULL, 0x0003e2000b901c46ULL,
0x000000100f0a8825ULL, 0x004fc600078e0022ULL, 0x0098000018297faeULL, 0x0005e2000b901c46ULL,
0x000000100f088825ULL, 0x008fc600078e0020ULL, 0x00b800001a297faeULL, 0x0005e2000b901c46ULL,
0x000000100f158824ULL, 0x060fe200078e022aULL, 0x000000320f178211ULL, 0x002fe400078e20ffULL,
0x00d800001c297faeULL, 0x0005e2000b901c46ULL, 0x0000000000327805ULL, 0x000fc6000001ff00ULL,
0x00f800001e297faeULL, 0x0005e8000b901c46ULL, 0x0858000008158faeULL, 0x0005e8000b901c46ULL,
0x081800000a178faeULL, 0x0005e8000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001000001947ULL, 0x000fea0003800000ULL, 0x00000003ff0a7819ULL, 0x104fe2000001160fULL,
0x00000200277e7824ULL, 0x000fe200078e0224ULL, 0xfffffff8ff0b7812ULL, 0x000fe200078ee20fULL,
0x000000ffff717224ULL, 0x000fe200078e00ffULL, 0x000000030a087812ULL, 0x000fe200078ec0ffULL,
0x00000100117e7824ULL, 0x000fe200078e027eULL, 0x000000040f097810ULL, 0x000fe20007ffe00aULL,
0x000000080b0a7836ULL, 0x000fe20000000000ULL, 0x000000100b147810ULL, 0x000fe20007ffe0ffULL,
0x000000180b157836ULL, 0x000fe20000000000ULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x000000080b167824ULL, 0x000fe200078e00ffULL, 0x0000000314747819ULL, 0x000fe200000006ffULL,
0x000000080a727824ULL, 0x000fe200078e00ffULL, 0x00000002ff7c7819ULL, 0x100fe2000001160fULL,
0x0000000815187824ULL, 0x000fe200078e00ffULL, 0xfffffff816737812ULL, 0x000fe200078ee209ULL,
0x0000000108087824ULL, 0x000fe200078e020fULL, 0xfffffff872727812ULL, 0x000fe200078ee209ULL,
0x000000080b777824ULL, 0x000fe200078e00ffULL, 0xfffffff874747812ULL, 0x000fe200078ee209ULL,
0x0000000815157824ULL, 0x000fe200078e00ffULL, 0xfffffff818757812ULL, 0x000fe200078ee209ULL,
0x000000080a097824ULL, 0x000fe200078e00ffULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x000000087c7d7836ULL, 0x000fe20000000000ULL, 0x00000003140b7819ULL, 0x000fe200000006ffULL,
0x000000107c7f7836ULL, 0x000fe20000000000ULL, 0xfffffff809767812ULL, 0x000fc400078ee208ULL,
0xfffffff877777812ULL, 0x000fe400078ee208ULL, 0xfffffff80b787812ULL, 0x000fe400078ee208ULL,
0xfffffff8157a7812ULL, 0x000fe400078ee208ULL, 0x00000027007b7202ULL, 0x000fe40000000f00ULL,
0x000000187c797810ULL, 0x000fce0007ffe0ffULL, 0x000000017b0b7836ULL, 0x000fca0000000000ULL,
0x000000000b00720cULL, 0x000fda0003f06070ULL, 0x0000000000d00947ULL, 0x000fea0003800000ULL,
0x000000070f00780cULL, 0x000fe20003f44070ULL, 0x00000001122a7824ULL, 0x000fe200078e020bULL,
0x000000010b2b7812ULL, 0x000fe200078ec0ffULL, 0x000000200f157836ULL, 0x000fe20000000000ULL,
0x000000600f197810ULL, 0x000fe20007ffe0ffULL, 0x000020002a087825ULL, 0x000fe200078e000cULL,
0x000000c00f1f7810ULL, 0x000fc60007ffe0ffULL, 0x000000400f177836ULL, 0x000fe20000000000ULL,
0x0000000308087210ULL, 0x000fe20007f1e0ffULL, 0x000000800f1b7836ULL, 0x000fe40000000000ULL,
0x00000200270aa824ULL, 0x140fe200078e0224ULL, 0x000000252a22a211ULL, 0x040fe200078238ffULL,
0x000002002714a824ULL, 0x000fe400078e0224ULL, 0x000000ffff097224ULL, 0x000fe200000e0609ULL,
0x0000000a117ea211ULL, 0x000fe200078e40ffULL, 0x000010000b0a7824ULL, 0x000fe200078e00ffULL,
0x000000132a20a211ULL, 0x000fe200078038ffULL, 0x000000a00f1d7836ULL, 0x000fe20000000000ULL,
0x0000007e2b28a211ULL, 0x000fe200078e38ffULL, 0x000000e00f217836ULL, 0x000fe20000000000ULL,
0x000010000a0b7812ULL, 0x000fe200078ec0ffULL, 0x00000100117ea824ULL, 0x000fe200078e0214ULL,
0x000000302a23a211ULL, 0x000fe200008f3cffULL, 0x0000001015147825ULL, 0x000fc800078e0008ULL,
0x00000001260a7824ULL, 0x000fe400078e020bULL, 0x0000001017167825ULL, 0x000fc800078e0008ULL,
0x000000100f297824ULL, 0x040fe400078e020aULL, 0x000000100f0a7825ULL, 0x000fc800078e0008ULL,
0x0000001019187825ULL, 0x100fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000a297faeULL, 0x0003e6000b901c46ULL, 0x000000101b1a7825ULL, 0x100fe200078e0008ULL,
0x0038000014297faeULL, 0x0005e6000b901c46ULL, 0x000000101d1c7825ULL, 0x100fe200078e0008ULL,
0x0058000016297faeULL, 0x0005e6000b901c46ULL, 0x000000101f1e7825ULL, 0x100fe200078e0008ULL,
0x0078000018297faeULL, 0x0005e6000b901c46ULL, 0x0000001021087825ULL, 0x000fe200078e0008ULL,
0x0000002f2a21a211ULL, 0x000fe200000f3cffULL, 0x009800001a297faeULL, 0x0005e4000b901c46ULL,
0x000000802b2aa824ULL, 0x000fe200078e027eULL, 0x000000280f2ba211ULL, 0x040fe200078e20ffULL,
0x000000100f20a825ULL, 0x040fe200078e0020ULL, 0x00b800001c297faeULL, 0x0005e6000b901c46ULL,
0x000000100f22a825ULL, 0x040fe200078e0022ULL, 0x00d800001e297faeULL, 0x0005e6000b901c46ULL,
0x000000100f0ba824ULL, 0x002fe200078e022aULL, 0x00f8000008297faeULL, 0x0005e8000b901c46ULL,
0x08580000202bafaeULL, 0x0005e8000b901c46ULL, 0x08180000220bafaeULL, 0x0005e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000010007b087824ULL, 0x004fca00078e00ffULL,
0x0000100008097812ULL, 0x000fe200078ec0ffULL, 0x000000807b087824ULL, 0x000fe400078e00ffULL,
0x000000027b7b7836ULL, 0x000fe20000000000ULL, 0x0000018026297810ULL, 0x000fe40007ffe009ULL,
0x0000008008087812ULL, 0x000fe400078ec0ffULL, 0x0000002977207211ULL, 0x080fe200078e20ffULL,
0x00000010731c7824ULL, 0x100fe200078e0229ULL, 0x0000007e2d097210ULL, 0x000fe20007ffe008ULL,
0x0000001074807824ULL, 0x100fe200078e0229ULL, 0x0000002975817211ULL, 0x080fe200078e20ffULL,
0x0000001076087824ULL, 0x000fe200078e0229ULL, 0x0000002972147211ULL, 0x000fe200078e20ffULL,
0x000000012c2a7824ULL, 0x000fe200078e0209ULL, 0x000000007b00720cULL, 0x000fe20003f06070ULL,
0x0000001078187824ULL, 0x000fe200078e0229ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000001c1c783bULL, 0x000e620000000200ULL, 0x000000107a287824ULL, 0x000fc600078e0229ULL,
0x008180002a8f7984ULL, 0x000ea80000000800ULL, 0x000000002020783bULL, 0x000ee80000000200ULL,
0x008580002a9a7984ULL, 0x000f680000000800ULL, 0x000000000808783bULL, 0x000f680000000200ULL,
0x000000001414783bULL, 0x000f680000000200ULL, 0x000000001818783bULL, 0x000f680000000200ULL,
0x000000002828783bULL, 0x000fe20000000200ULL, 0x2000001cff897230ULL, 0x002fc40000004100ULL,
0x3000001cff8c7230ULL, 0x000fe40000004100ULL, 0x0000008f2e1c7221ULL, 0x004fe20000010100ULL,
0x2000001dff8b7230ULL, 0x000fe40000004100ULL, 0x3000001dff8e7230ULL, 0x000fe40000004100ULL,
0x3fb8aa3b1c977820ULL, 0x000fe20000410000ULL, 0x20000020ff827230ULL, 0x008fe40000004100ULL,
0x30000020ff847230ULL, 0x010fe20000004100ULL, 0x0000009700997308ULL, 0x000f620000000800ULL,
0x20000021ff837230ULL, 0x000fc40000004100ULL, 0x30000021ff867230ULL, 0x000fe40000004100ULL,
0x20000022ff857230ULL, 0x000fe40000004100ULL, 0x30000022ff887230ULL, 0x000fe40000004100ULL,
0x20000023ff877230ULL, 0x000fe40000004100ULL, 0x30000023ff8a7230ULL, 0x000fe40000004100ULL,
0x000000008020783bULL, 0x0003e20000000200ULL, 0x2000001eff8d7230ULL, 0x000fc40000004100ULL,
0x0000009a99aa7220ULL, 0x020fe20000410000ULL, 0x3000001eff907230ULL, 0x000fe40000004100ULL,
0x2000001fff8f7230ULL, 0x000fe40000004100ULL, 0x00000070aa707221ULL, 0x000fe20000010000ULL,
0x00001f7caaa97589ULL, 0x000ea200000e0000ULL, 0x3000001fff807230ULL, 0x002fe40000004100ULL,
0x2000000bff957230ULL, 0x000fe20000004100ULL, 0x00000000811c783bULL, 0x0002e20000000200ULL,
0x3000000bff947230ULL, 0x000fc40000004100ULL, 0x20000014ff0b7230ULL, 0x000fe20000004100ULL,
0x00001f7daaab7589ULL, 0x000f2200000e0000ULL, 0x2000001bff9b7230ULL, 0x000fe40000004100ULL,
0x3000001bff9c7230ULL, 0x000fe40000004100ULL, 0x30000014ff817230ULL, 0x002fe40000004100ULL,
0x20000009ff937230ULL, 0x000fe40000004100ULL, 0x30000009ff927230ULL, 0x000fc40000004100ULL,
0x20000015ff147230ULL, 0x000fe40000004100ULL, 0x30000015ff967230ULL, 0x000fe40000004100ULL,
0x20000017ff977230ULL, 0x000fe40000004100ULL, 0x000000a9826d7223ULL, 0x084fe2000001006dULL,
0x30000017ff987230ULL, 0x000fe40000004100ULL, 0x000000a9846b7223ULL, 0x000fe2000001006bULL,
0x20000019ff997230ULL, 0x000fc40000004100ULL, 0x000000a9836a7223ULL, 0x080fe2000001006aULL,
0x30000019ff9a7230ULL, 0x000fe40000004100ULL, 0x000000a986677223ULL, 0x080fe20000010067ULL,
0x20000029ffa17230ULL, 0x000fe40000004100ULL, 0x000000a985667223ULL, 0x080fe20000010066ULL,
0x20000020ff1b7230ULL, 0x000fe40000004100ULL, 0x000000a988637223ULL, 0x000fe20000010063ULL,
0x30000020ff9d7230ULL, 0x000fc40000004100ULL, 0x000000a987627223ULL, 0x080fe20000010062ULL,
0x20000022ff9e7230ULL, 0x000fe40000004100ULL, 0x000000a98a5f7223ULL, 0x080fe2000001005fULL,
0x30000022ff9f7230ULL, 0x000fe40000004100ULL, 0x000000a9895e7223ULL, 0x080fe2000001005eULL,
0x30000029ffa27230ULL, 0x000fe40000004100ULL, 0x000000a98c5b7223ULL, 0x000fe2000001005bULL,
0x20000008ff917230ULL, 0x000fc40000004100ULL, 0x000000a98b5a7223ULL, 0x080fe2000001005aULL,
0x2000001effa67230ULL, 0x008fe40000004100ULL, 0x000000a98e6f7223ULL, 0x080fe2000001006fULL,
0x3000001effa77230ULL, 0x000fe40000004100ULL, 0x000000a98d587223ULL, 0x080fe20000010058ULL,
0x2000001fff1e7230ULL, 0x000fe40000004100ULL, 0x000000a990557223ULL, 0x000fe20000010055ULL,
0x3000001fffa87230ULL, 0x000fc40000004100ULL, 0x000000a98f547223ULL, 0x080fe20000010054ULL,
0x00001f7faa1f7589ULL, 0x000e6200000e0000ULL, 0x2000001cffa47230ULL, 0x000fe40000004100ULL,
0x000000a980517223ULL, 0x000fe20000010051ULL, 0x3000001cffa57230ULL, 0x000fe20000004100ULL,
0x00001f79aaaa7589ULL, 0x000ea200000e0000ULL, 0x2000000aff097230ULL, 0x000fe40000004100ULL,
0x000000ab91507223ULL, 0x010fe20000010050ULL, 0x20000016ff157230ULL, 0x000fc40000004100ULL,
0x000000ab93687223ULL, 0x080fe20000010068ULL, 0x20000018ff177230ULL, 0x000fe40000004100ULL,
0x000000ab92657223ULL, 0x080fe20000010065ULL, 0x2000001aff197230ULL, 0x000fe40000004100ULL,
0x000000ab09647223ULL, 0x080fe20000010064ULL, 0x20000021ff207230ULL, 0x000fe40000004100ULL,
0x000000ab95607223ULL, 0x000fe20000010060ULL, 0x20000023ff227230ULL, 0x000fc40000004100ULL,
0x000000ab945d7223ULL, 0x080fe2000001005dULL, 0x20000028ffa07230ULL, 0x000fe40000004100ULL,
0x000000ab0b5c7223ULL, 0x080fe2000001005cULL, 0x2000002aff297230ULL, 0x000fe40000004100ULL,
0x000000ab816e7223ULL, 0x080fe2000001006eULL, 0x2000002bffa37230ULL, 0x000fe40000004100ULL,
0x000000ab14597223ULL, 0x000fe20000010059ULL, 0x2000001dff1c7230ULL, 0x000fc40000004100ULL,
0x000000ab96577223ULL, 0x080fe20000010057ULL, 0x30000008ff087230ULL, 0x000fe40000004100ULL,
0x000000ab15567223ULL, 0x080fe20000010056ULL, 0x3000000aff0a7230ULL, 0x000fe40000004100ULL,
0x000000ab97527223ULL, 0x080fe20000010052ULL, 0x30000016ff167230ULL, 0x000fe40000004100ULL,
0x000000ab08697223ULL, 0x000fe20000010069ULL, 0x30000018ff187230ULL, 0x000fc40000004100ULL,
0x000000ab0a617223ULL, 0x080fe20000010061ULL, 0x3000001aff1a7230ULL, 0x000fe40000004100ULL,
0x000000ab16537223ULL, 0x080fe20000010053ULL, 0x30000021ff217230ULL, 0x000fe40000004100ULL,
0x000000ab984f7223ULL, 0x000fe2000001004fULL, 0x30000023ff237230ULL, 0x000fe40000004100ULL,
0x0000001f174e7223ULL, 0x002fe2000001004eULL, 0x30000028ff287230ULL, 0x000fc40000004100ULL,
0x0000001f184d7223ULL, 0x080fe2000001004dULL, 0x3000002aff2a7230ULL, 0x000fe40000004100ULL,
0x0000001f994c7223ULL, 0x080fe2000001004cULL, 0x3000002bff2b7230ULL, 0x000fe40000004100ULL,
0x0000001f9a497223ULL, 0x080fe20000010049ULL, 0x3000001dff1d7230ULL, 0x000fe40000004100ULL,
0x0000001f19487223ULL, 0x080fe20000010048ULL, 0x0000001f1a457223ULL, 0x080fe20000010045ULL,
0x0000001f9b447223ULL, 0x080fe20000010044ULL, 0x0000001f9c417223ULL, 0x080fe20000010041ULL,
0x0000001f1b407223ULL, 0x080fe20000010040ULL, 0x0000001f9d3e7223ULL, 0x080fe2000001003eULL,
0x0000001f203d7223ULL, 0x080fe2000001003dULL, 0x0000001f213a7223ULL, 0x080fe2000001003aULL,
0x0000001f9e397223ULL, 0x080fe20000010039ULL, 0x0000001f9f367223ULL, 0x080fe20000010036ULL,
0x0000001f22357223ULL, 0x080fe20000010035ULL, 0x0000001f23327223ULL, 0x000fe20000010032ULL,
0x000000aaa0317223ULL, 0x084fe20000010031ULL, 0x000000aa284b7223ULL, 0x080fe2000001004bULL,
0x000000aaa14a7223ULL, 0x080fe2000001004aULL, 0x000000aaa2477223ULL, 0x080fe20000010047ULL,
0x000000aa29467223ULL, 0x080fe20000010046ULL, 0x000000aa2a437223ULL, 0x080fe20000010043ULL,
0x000000aaa3427223ULL, 0x080fe20000010042ULL, 0x000000aa2b6c7223ULL, 0x080fe2000001006cULL,
0x000000aaa43f7223ULL, 0x080fe2000001003fULL, 0x000000aaa53c7223ULL, 0x080fe2000001003cULL,
0x000000aa1c3b7223ULL, 0x080fe2000001003bULL, 0x000000aa1d387223ULL, 0x080fe20000010038ULL,
0x000000aaa6377223ULL, 0x080fe20000010037ULL, 0x000000aaa7347223ULL, 0x080fe20000010034ULL,
0x000000aa1e337223ULL, 0x080fe20000010033ULL, 0x000000aaa8717223ULL, 0x000fe20000010071ULL,
0xfffffff000888947ULL, 0x000fec000383ffffULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x000000ff1100720cULL, 0x000fe20003f05270ULL, 0x0000001000037824ULL, 0x002fe200078e00ffULL,
0x00000001ff087819ULL, 0x004fe20000011600ULL, 0x0000898024007836ULL, 0x000fc60000000000ULL,
0x00000070030b7812ULL, 0x000fe400078ec0ffULL, 0x0000000c080a7812ULL, 0x000fca00078ec0ffULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x0000008027247824ULL, 0x000fe200078e0224ULL, 0x0000000403087819ULL, 0x002fe400000006ffULL,
0x00000001ff097819ULL, 0x000fe40000011603ULL, 0x0000007008037812ULL, 0x000fe400078ec0ffULL,
0x0000000c09097812ULL, 0x000fc800078ec0ffULL, 0x0000002409037210ULL, 0x000fca0007ffe003ULL,
0x0089807003007388ULL, 0x0003e40000000800ULL, 0x000000000a007210ULL, 0x000fe20007ffe00bULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000000037984ULL, 0x002e680000000800ULL,
0x0000800000087984ULL, 0x000ea20000000800ULL, 0x00000003ff037221ULL, 0x002fc80000010000ULL,
0x0000000803037221ULL, 0x004fc80000010000ULL, 0x0180000003087836ULL, 0x000fca0000000000ULL,
0x7f80000008087812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x01ffffff0800780cULL, 0x000fda0003f04070ULL, 0x0000000000140947ULL, 0x000fea0003800000ULL,
0x000000ffff857224ULL, 0x000fe200078e0003ULL, 0x0000cc30000c7802ULL, 0x000fce0000000f00ULL,
0x000000b400d07944ULL, 0x010fea0003c00000ULL, 0x0000000800007202ULL, 0x00cfe20000000f00ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000300007308ULL, 0x000e640000001000ULL,
0xbf80000003087423ULL, 0x002fc80000000000ULL, 0x800000ff08097221ULL, 0x000fc80000010100ULL,
0x0000000900007223ULL, 0x000fce0000000000ULL, 0x00000000000f7919ULL, 0x000ea40000000000ULL,
0x00000002ff0b7819ULL, 0x104fe2000001160fULL, 0x000000010e0e7824ULL, 0x000fe200078e020fULL,
0x000000080f037811ULL, 0x040fe400078ff0ffULL, 0x000000100f137811ULL, 0x040fe200078ff0ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0b00087589ULL, 0x000ea200000e0000ULL,
0x000000180f0d7811ULL, 0x000fe200078ff0ffULL, 0x000000100e0e7824ULL, 0x000fe200078e0205ULL,
0xfffffff8ff237812ULL, 0x000fe200078ee20fULL, 0x00001f0300037589ULL, 0x000ee600000e0000ULL,
0x0000001023287810ULL, 0x000fe20007ffe0ffULL, 0x00001f1300137589ULL, 0x000f6200000e0000ULL,
0x0000000823267836ULL, 0x000fc40000000000ULL, 0x00000018232a7836ULL, 0x000fe20000000000ULL,
0x00001f0d00227589ULL, 0x0004e200000e0000ULL, 0x00000008232c7824ULL, 0x000fe400078e00ffULL,
0x00000008262e7824ULL, 0x000fe200078e00ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000828307824ULL, 0x000fc400078e00ffULL, 0x0000006d086d7220ULL, 0x044fe20000410000ULL,
0x0000006b080a7220ULL, 0x040fe20000410000ULL, 0x0000006a08097220ULL, 0x040fe20000410000ULL,
0x00000067080c7220ULL, 0x040fe20000410000ULL, 0x0000006608667220ULL, 0x040fe20000410000ULL,
0x0000006308637220ULL, 0x040fe20000410000ULL, 0x00000062080b7220ULL, 0x040fe20000410000ULL,
0x0000005f08127220ULL, 0x040fe20000410000ULL, 0x0000005e08147220ULL, 0x040fe20000410000ULL,
0x0000005b085b7220ULL, 0x040fe20000410000ULL, 0x0000005a08157220ULL, 0x040fe20000410000ULL,
0x0000006f08007220ULL, 0x042fe20000410000ULL, 0x0000005808167220ULL, 0x040fe20000410000ULL,
0x0000005508557220ULL, 0x040fe20000410000ULL, 0x0000005408177220ULL, 0x040fe20000410000ULL,
0x0000005108187220ULL, 0x000fe20000410000ULL, 0x0000ffff0f087812ULL, 0x000fe200078ec0ffULL,
0x0000005003507220ULL, 0x048fe20000410000ULL, 0x0000006903697220ULL, 0x040fe20000410000ULL,
0x0000006803197220ULL, 0x040fe20000410000ULL, 0x00000003ff087819ULL, 0x000fe20000011608ULL,
0x00000065031a7220ULL, 0x040fe20000410000ULL, 0x0000006403647220ULL, 0x040fe20000410000ULL,
0x0000006103617220ULL, 0x040fe20000410000ULL, 0x0000000308087812ULL, 0x000fe200078ec0ffULL,
0x00000060031b7220ULL, 0x040fe20000410000ULL, 0x0000005d031c7220ULL, 0x040fe20000410000ULL,
0x0000005c035c7220ULL, 0x040fe20000410000ULL, 0x0000006e030d7220ULL, 0x000fe20000410000ULL,
0x0000000108087824ULL, 0x000fc400078e020fULL, 0x00000059031d7220ULL, 0x040fe20000410000ULL,
0x00000057031e7220ULL, 0x040fe20000410000ULL, 0x0000005603567220ULL, 0x040fe20000410000ULL,
0x0000005303537220ULL, 0x040fe20000410000ULL, 0x00000052031f7220ULL, 0x040fe20000410000ULL,
0x0000004f03207220ULL, 0x000fe20000410000ULL, 0x0000003e13037220ULL, 0x060fe20000410000ULL,
0x0000000708217812ULL, 0x000fe200078ec0ffULL, 0x0000004b22247220ULL, 0x000fe20000410000ULL,
0x000000032a3e7819ULL, 0x000fe200000006ffULL, 0x00000008282d7824ULL, 0x000fe200078e00ffULL,
0x0000000408087812ULL, 0x000fe200078e3cffULL, 0x0000004e134e7220ULL, 0x040fe20000410000ULL,
0xfffffff82c257812ULL, 0x000fe200078ee221ULL, 0x0000004d134d7220ULL, 0x040fe20000410000ULL,
0xfffffff82e297812ULL, 0x000fe200078ee221ULL, 0x0000004c134c7220ULL, 0x000fe20000410000ULL,
0xfffffff8302b7812ULL, 0x000fe200078ee221ULL, 0x0000001025257824ULL, 0x100fe200078e0210ULL,
0xfffffff83e2f7812ULL, 0x000fe200078ee221ULL, 0x0000000823217824ULL, 0x000fe200078e00ffULL,
0x0000000708087812ULL, 0x000fe200078ec0ffULL, 0x0000000826237824ULL, 0x000fe200078e00ffULL,
0x000000032a4b7819ULL, 0x000fe200000006ffULL, 0x0000004913497220ULL, 0x040fe20000410000ULL,
0xfffffff821217812ULL, 0x000fe200078ee208ULL, 0x0000004813487220ULL, 0x040fe20000410000ULL,
0xfffffff823237812ULL, 0x000fe200078ee208ULL, 0x0000004513457220ULL, 0x040fe20000410000ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee208ULL, 0x0000004413447220ULL, 0x040fe20000410000ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee208ULL, 0x0000004113417220ULL, 0x040fe20000410000ULL,
0x0000006d0a08723eULL, 0x000fe200000000ffULL, 0x0000004013407220ULL, 0x040fe20000410000ULL,
0x000000090c09723eULL, 0x000fe200000000ffULL, 0x0000003d133d7220ULL, 0x000fe20000410000ULL,
0x00000066630a723eULL, 0x000fe200000000ffULL, 0x0000003a133a7220ULL, 0x040fe20000410000ULL,
0x0000000b120b723eULL, 0x000fe200000000ffULL, 0x0000003913397220ULL, 0x040fe20000410000ULL,
0x0000003613367220ULL, 0x040fe20000410000ULL, 0x0000003513357220ULL, 0x040fe20000410000ULL,
0x0000003213327220ULL, 0x000fe20000410000ULL, 0x0000004a224a7220ULL, 0x040fe20000410000ULL,
0x0000004722477220ULL, 0x040fe20000410000ULL, 0x0000003122317220ULL, 0x040fe20000410000ULL,
0x0000004622467220ULL, 0x040fe20000410000ULL, 0x0000004322437220ULL, 0x040fe20000410000ULL,
0x0000004222427220ULL, 0x040fe20000410000ULL, 0x0000006c22137220ULL, 0x040fe20000410000ULL,
0x0000003f223f7220ULL, 0x040fe20000410000ULL, 0x0000003c223c7220ULL, 0x040fe20000410000ULL,
0x0000003b223b7220ULL, 0x040fe20000410000ULL, 0x0000003822387220ULL, 0x040fe20000410000ULL,
0x0000003722377220ULL, 0x040fe20000410000ULL, 0x0000003422347220ULL, 0x040fe20000410000ULL,
0x0000003322337220ULL, 0x040fe20000410000ULL, 0x000000145b14723eULL, 0x000fe200000000ffULL,
0x0000007122227220ULL, 0x000fe20000410000ULL, 0x000000150015723eULL, 0x000fe200000000ffULL,
0x0000001029007824ULL, 0x100fe200078e0210ULL, 0x000000165516723eULL, 0x000fe200000000ffULL,
0x0000000825007844ULL, 0x0003e20000000200ULL, 0x000000171817723eULL, 0x000fe200000000ffULL,
0x0000001023237824ULL, 0x100fe200078e0210ULL, 0x000000191a19723eULL, 0x000fe200000000ffULL,
0x000000102b0c7824ULL, 0x100fe200078e0210ULL, 0x0000001021217211ULL, 0x000fe200078e20ffULL,
0x000000102f127824ULL, 0x000fe200078e0210ULL, 0x000000506918723eULL, 0x000fc400000000ffULL,
0x00000064611a723eULL, 0x000fe200000000ffULL, 0x0000001421007844ULL, 0x000fe20000000200ULL,
0x0000001b1c1b723eULL, 0x000fe400000000ffULL, 0x0000001d1e1d723eULL, 0x000fe400000000ffULL,
0x0000005c0d1c723eULL, 0x000fe200000000ffULL, 0x000000102d0d7824ULL, 0x000fe200078e0210ULL,
0x00000056531e723eULL, 0x000fe200000000ffULL, 0x0000001800007844ULL, 0x000fe20000000200ULL,
0x0000001f201f723eULL, 0x000fc400000000ffULL, 0x0000004e4d08723eULL, 0x002fe400000000ffULL,
0x0000004c4909723eULL, 0x000fe200000000ffULL, 0x0000001c23007844ULL, 0x000fe20000000200ULL,
0x00000048450a723eULL, 0x000fe400000000ffULL, 0x00000044410b723eULL, 0x000fe400000000ffULL,
0x000000400328723eULL, 0x000fe400000000ffULL, 0x0000003d3a29723eULL, 0x000fe200000000ffULL,
0x000000080c007844ULL, 0x000fe20000000200ULL, 0x00000039362a723eULL, 0x000fc400000000ffULL,
0x00000035322b723eULL, 0x000fe400000000ffULL, 0x0000004a4745723eULL, 0x000fe400000000ffULL,
0x000000312444723eULL, 0x000fe200000000ffULL, 0x000000280d007844ULL, 0x000fe20000000200ULL,
0x000000464346723eULL, 0x000fe400000000ffULL, 0x000000421347723eULL, 0x000fe400000000ffULL,
0x000000104b4b7211ULL, 0x000fc400078e20ffULL, 0x0000003f3c30723eULL, 0x000fe200000000ffULL,
0x0000004412007844ULL, 0x000fe20000000200ULL, 0x0000003b3831723eULL, 0x000fe400000000ffULL,
0x000000373432723eULL, 0x000fe400000000ffULL, 0x000000332233723eULL, 0x000fca00000000ffULL,
0x000000304b007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000e147984ULL, 0x000e680000000c00ULL, 0x000400000e1c7984ULL, 0x000ea80000000c00ULL,
0x000800000e2c7984ULL, 0x000ee80000000c00ULL, 0x000c00000e287984ULL, 0x000f680000000c00ULL,
0x001000000e187984ULL, 0x000ee80000000c00ULL, 0x001400000e207984ULL, 0x000f680000000c00ULL,
0x001800000e087984ULL, 0x000f680000000c00ULL, 0x001c00000e347984ULL, 0x000f620000000c00ULL,
0x200000ff17177230ULL, 0x002fc40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fe40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x004fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fc40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff2f2f7230ULL, 0x008fe40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fe40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x200000ff2b2b7230ULL, 0x020fc40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fe40000000000ULL,
0x200000ff29297230ULL, 0x000fe40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x000fe40000000000ULL, 0x0000001a16167230ULL, 0x000fe40000000000ULL,
0x0000001915157230ULL, 0x000fc40000000000ULL, 0x0000001814147230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x000fe40000000000ULL, 0x000000221e1e7230ULL, 0x000fe20000000000ULL,
0x000000140e007388ULL, 0x0003e20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fe40000000000ULL, 0x0000000b2f2f7230ULL, 0x000fc40000000000ULL,
0x0000000a2e2e7230ULL, 0x000fe20000000000ULL, 0x0004001c0e007388ULL, 0x0003e20000000c00ULL,
0x000000092d2d7230ULL, 0x000fe40000000000ULL, 0x000000082c2c7230ULL, 0x000fe40000000000ULL,
0x000000372b2b7230ULL, 0x000fe40000000000ULL, 0x000000362a2a7230ULL, 0x000fe20000000000ULL,
0x0008002c0e007388ULL, 0x0003e20000000c00ULL, 0x0000003529297230ULL, 0x000fc40000000000ULL,
0x0000003428287230ULL, 0x000fca0000000000ULL, 0x000c00280e007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ff2700720cULL, 0x000fda0003f05270ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x00000003ff097819ULL, 0x000fe2000001160fULL, 0x0000840000057ab9ULL, 0x000fc60000000800ULL,
0x000000040900720cULL, 0x000fe20003f06070ULL, 0x00000005040472a4ULL, 0x004fd8000f8e023fULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000109007824ULL, 0x000fe200078e020fULL,
0x00008600000a7ab9ULL, 0x000fe20000000800ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x000000200f0e7810ULL, 0x002fe20007ffe0ffULL, 0x0000000a05057299ULL, 0x000fe2000800063fULL,
0x0000000700007812ULL, 0x000fe200078ec0ffULL, 0x0000880000087ab9ULL, 0x000fe20000000a00ULL,
0x00000003ff0b7819ULL, 0x000fe4000001160eULL, 0x0ffffff800007812ULL, 0x000fe400078ef80fULL,
0x000000070f0c7812ULL, 0x000fc400078ec0ffULL, 0x0000000500037211ULL, 0x000fe200078e20ffULL,
0x0000002002007824ULL, 0x000fc800078e0209ULL, 0x0000000003147984ULL, 0x0002a20000000c00ULL,
0x0000000500087c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff097c19ULL, 0x000fe20008011600ULL,
0x0000000406007c24ULL, 0x000fe4000f8e02ffULL, 0x0000000107087824ULL, 0x000fe400078e0208ULL,
0x0000000811037824ULL, 0x002fe400078e020cULL, 0x0000000609097224ULL, 0x000fca00078e0208ULL,
0x0000000900097210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200000e06ffULL,
0x0000000809087c11ULL, 0x000fc8000f8040ffULL, 0x0000000909097c11ULL, 0x000fe400080f440aULL,
0x000000040b00720cULL, 0x000fe20003f06070ULL, 0x0000001003087825ULL, 0x000fca00078e0008ULL,
0x0000001408007986ULL, 0x0043ee000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010e037824ULL, 0x000fe200078e020bULL, 0x0000000b020b7211ULL, 0x000fe400078e28ffULL,
0x000000070e0a7812ULL, 0x000fe400078ec0ffULL, 0x0000000703037812ULL, 0x000fc800078ec0ffULL,
0x0ffffff803087812ULL, 0x002fe200078ef80eULL, 0x000000400f0e7836ULL, 0x000fc80000000000ULL,
0x0000001008037824ULL, 0x000fe200078e0205ULL, 0x000000050b087c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff0b7c19ULL, 0x000fe4000801160bULL, 0x0000000003147984ULL, 0x0002a20000000c00ULL,
0x0000000107087824ULL, 0x000fc800078e0208ULL, 0x000000060b0b7224ULL, 0x000fe200078e0208ULL,
0x0000000a11037211ULL, 0x002fc800078e18ffULL, 0x0000000b000b7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x000000080b087c11ULL, 0x000fc8000f8040ffULL,
0x000000090b097c11ULL, 0x000fe400080f440cULL, 0x00000003ff0b7819ULL, 0x000fe2000001160eULL,
0x0000001003087825ULL, 0x000fc600078e0008ULL, 0x000000040b00720cULL, 0x000fe40003f06070ULL,
0x0000001408007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010e037824ULL, 0x140fe200078e020bULL, 0x000000070e0a7812ULL, 0x000fe200078ec0ffULL,
0x00000020020b7824ULL, 0x000fc600078e020bULL, 0x0000000703037812ULL, 0x000fc800078ec0ffULL,
0x0ffffff803087812ULL, 0x002fe200078ef80eULL, 0x000000600f0e7836ULL, 0x000fc80000000000ULL,
0x0000001008037824ULL, 0x000fe200078e0205ULL, 0x000000050b087c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff0b7c19ULL, 0x000fe4000801160bULL, 0x0000000003147984ULL, 0x0002a20000000c00ULL,
0x0000000807087210ULL, 0x000fca0007ffe0ffULL, 0x000000060b0b7224ULL, 0x000fe400078e0208ULL,
0x0000000811037824ULL, 0x002fc600078e020aULL, 0x0000000b000b7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x000000080b087c11ULL, 0x000fc8000f8040ffULL,
0x000000090b097c11ULL, 0x000fe400080f440cULL, 0x00000003ff0b7819ULL, 0x000fe2000001160eULL,
0x0000001003087825ULL, 0x000fc600078e0008ULL, 0x000000040b00720cULL, 0x000fe40003f06070ULL,
0x0000001408007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000b0e037210ULL, 0x000fe20007ffe0ffULL, 0x00000020020b7824ULL, 0x000fe200078e020bULL,
0x000000070e0a7812ULL, 0x000fe400078ec0ffULL, 0x0000000703037812ULL, 0x000fc800078ec0ffULL,
0x0ffffff803087812ULL, 0x002fe200078ef80eULL, 0x000000800f0e7836ULL, 0x000fc80000000000ULL,
0x0000001008037824ULL, 0x000fe200078e0205ULL, 0x000000050b087c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff0b7c19ULL, 0x000fe4000801160bULL, 0x0000000003147984ULL, 0x0002a20000000c00ULL,
0x0000000107087824ULL, 0x000fc800078e0208ULL, 0x000000060b0b7224ULL, 0x000fe400078e0208ULL,
0x0000000811037824ULL, 0x002fc600078e020aULL, 0x0000000b000b7210ULL, 0x000fc80007f1e0ffULL,
0x000000ffff0c7210ULL, 0x000fe400007fe4ffULL, 0x000000080b087c11ULL, 0x000fc8000f8040ffULL,
0x000000090b097c11ULL, 0x000fe400080f440cULL, 0x00000003ff0b7819ULL, 0x000fe2000001160eULL,
0x0000001003087825ULL, 0x000fc600078e0008ULL, 0x000000040b00720cULL, 0x000fe40003f06070ULL,
0x0000001408007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010e037824ULL, 0x140fe200078e020bULL, 0x000000070e0a7812ULL, 0x000fe200078ec0ffULL,
0x00000020020b7824ULL, 0x000fc600078e020bULL, 0x0000000703037812ULL, 0x000fc800078ec0ffULL,
0x0ffffff803087812ULL, 0x002fe400078ef80eULL, 0x000000a00f0e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000508037211ULL, 0x000fe400078e20ffULL, 0x000000050b087c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff0b7c19ULL, 0x000fe2000801160bULL, 0x0000000003147984ULL, 0x0002a40000000c00ULL,
0x0000000107087824ULL, 0x000fc800078e0208ULL, 0x000000060b0b7224ULL, 0x000fe400078e0208ULL,
0x0000000811037824ULL, 0x002fc600078e020aULL, 0x0000000b000b7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x000000080b087c11ULL, 0x000fc8000f8040ffULL,
0x000000090b097c11ULL, 0x000fe400080f440cULL, 0x00000003ff0b7819ULL, 0x000fe2000001160eULL,
0x0000001003087825ULL, 0x000fc600078e0008ULL, 0x000000040b00720cULL, 0x000fe40003f06070ULL,
0x0000001408007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010e037824ULL, 0x000fe200078e020bULL, 0x0000000b020b7211ULL, 0x000fe400078e28ffULL,
0x000000070e0a7812ULL, 0x000fe400078ec0ffULL, 0x0000000703037812ULL, 0x000fc800078ec0ffULL,
0x0ffffff803087812ULL, 0x002fe200078ef80eULL, 0x000000c00f0e7836ULL, 0x000fc80000000000ULL,
0x0000001008037824ULL, 0x000fe200078e0205ULL, 0x000000050b087c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff0b7c19ULL, 0x000fe4000801160bULL, 0x0000000003147984ULL, 0x0002a20000000c00ULL,
0x0000000107087824ULL, 0x000fc800078e0208ULL, 0x000000060b0b7224ULL, 0x000fe200078e0208ULL,
0x0000000a11037211ULL, 0x002fc800078e18ffULL, 0x0000000b000b7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x000000080b087c11ULL, 0x000fc8000f8040ffULL,
0x000000090b097c11ULL, 0x000fe400080f440cULL, 0x00000003ff0b7819ULL, 0x000fe2000001160eULL,
0x0000001003087825ULL, 0x000fc600078e0008ULL, 0x000000040b00720cULL, 0x000fe40003f06070ULL,
0x0000001408007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010e037824ULL, 0x140fe200078e020bULL, 0x000000070e0a7812ULL, 0x000fe200078ec0ffULL,
0x00000020020b7824ULL, 0x000fe400078e020bULL, 0x000000e00f107836ULL, 0x000fe20000000000ULL,
0x0000000703037812ULL, 0x000fc800078ec0ffULL, 0x0ffffff803087812ULL, 0x002fca00078ef80eULL,
0x0000001008037824ULL, 0x000fe200078e0205ULL, 0x000000050b087c12ULL, 0x000fe4000f8e30ffULL,
0x0000000aff0b7c19ULL, 0x000fe4000801160bULL, 0x0000000003147984ULL, 0x0002a20000000c00ULL,
0x0000000807087210ULL, 0x000fca0007ffe0ffULL, 0x000000060b0b7224ULL, 0x000fe200078e0208ULL,
0x0000000a11037211ULL, 0x002fc800078e18ffULL, 0x0000000b00097210ULL, 0x000fe40007f1e0ffULL,
0x00000003ff0b7819ULL, 0x000fc60000011610ULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x0000000809087c11ULL, 0x000fc8000f8040ffULL, 0x0000000909097c11ULL, 0x000fe200080f440cULL,
0x00000001100c7824ULL, 0x000fe200078e020bULL, 0x000000040b00720cULL, 0x000fe20003f06070ULL,
0x0000001003087825ULL, 0x000fc600078e0008ULL, 0x000000070c0c7812ULL, 0x000fc800078ec0ffULL,
0xfffffff80c0c7812ULL, 0x000fe200078ef810ULL, 0x0000001408007986ULL, 0x0043e8000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000100c0c7824ULL, 0x000fe400078e0205ULL,
0x0000002002027824ULL, 0x000fc800078e020bULL, 0x000000000c0c7984ULL, 0x000e620000000c00ULL,
0x0000000502047c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff037c19ULL, 0x000fc60008011602ULL,
0x0000000107047824ULL, 0x000fc800078e0204ULL, 0x0000000603037224ULL, 0x000fca00078e0204ULL,
0x0000000300037210ULL, 0x000fe40007f1e0ffULL, 0x0000000710007812ULL, 0x000fe400078ec0ffULL,
0x000000ffff047210ULL, 0x000fe400007fe4ffULL, 0x0000000803027c11ULL, 0x000fe2000f8040ffULL,
0x0000000811117824ULL, 0x000fc600078e0200ULL, 0x0000000903037c11ULL, 0x000fc600080f4404ULL,
0x0000001011027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0000000405027824ULL, 0x000fe200078e0203ULL,
0x0000000100117802ULL, 0x000fe20000000f00ULL, 0x00008e00ff147b82ULL, 0x000e660000000a00ULL,
0x0000000b0200720cULL, 0x000fe40003f06070ULL, 0x01e600110a1079a7ULL, 0x0004b6000850003fULL,
0x00009400ff048b82ULL, 0x000ee20000000800ULL, 0x000000029b078824ULL, 0x000fce00078e00ffULL,
0x00009000ff168b82ULL, 0x000f220000000a00ULL, 0x0000000407078224ULL, 0x008fe400078e0202ULL,
0xffffffffff047424ULL, 0x000fe400078e00ffULL, 0x0000000407168825ULL, 0x010fca00078e0016ULL,
0x0000000616048981ULL, 0x000ee2000c1e1900ULL, 0x00000001050f7836ULL, 0x000fe20000000000ULL,
0x0000000603067819ULL, 0x000fe200000006ffULL, 0x0000004013077824ULL, 0x000fc600078e00ffULL,
0x0000000c0f00720cULL, 0x000fe20003f06070ULL, 0x00000007040f7224ULL, 0x008fc800078e02ffULL,
0x000001000f147825ULL, 0x002fc800078e0014ULL, 0x00000040180f7824ULL, 0x000fc800078e00ffULL,
0x0000000c00248947ULL, 0x004fea0003800000ULL, 0x00000100050e7824ULL, 0x000fe200078e0206ULL,
0x00000003ff377819ULL, 0x000fc80000011608ULL, 0x0000000e09137248ULL, 0x000fe20007fe0000ULL,
0x0000000437167836ULL, 0x000fe20000000000ULL, 0x0000002837267810ULL, 0x000fe20007ffe0ffULL,
0x0000000837177836ULL, 0x000fe20000000000ULL, 0x000000130e137210ULL, 0x000fe20007ffe1ffULL,
0x00000001160e7824ULL, 0x100fe200078e0208ULL, 0x0000000326317819ULL, 0x000fe200000006ffULL,
0x0000000816237824ULL, 0x040fe200078e00ffULL, 0x000000131600720cULL, 0x080fe20003f46070ULL,
0x0000000817257824ULL, 0x040fe200078e00ffULL, 0x0000000c37167810ULL, 0x000fe20007ffe0ffULL,
0x0000001037197836ULL, 0x000fe20000000000ULL, 0xfffffff823237812ULL, 0x000fe200078ee20eULL,
0x00000001170e7824ULL, 0x140fe200078e0208ULL, 0x000000131700720cULL, 0x080fe20003f66070ULL,
0x0000000116177824ULL, 0x140fe200078e0208ULL, 0x00000003161a7819ULL, 0x040fe200000006ffULL,
0x00000008192b7824ULL, 0x040fe200078e00ffULL, 0x000000131600720cULL, 0x000fe20003f86070ULL,
0x0000000119167824ULL, 0x000fe200078e0208ULL, 0xfffffff81a297812ULL, 0x000fe200078ee217ULL,
0x00000018371e7836ULL, 0x000fe20000000000ULL, 0x00000014371a7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff825257812ULL, 0x000fe200078ee20eULL, 0x00000040180e7824ULL, 0x000fe200078e0237ULL,
0x000000131900720cULL, 0x080fe20003fa6070ULL, 0x000000011a187824ULL, 0x040fe200078e0208ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee216ULL, 0x000000081a337824ULL, 0x000fe200078e00ffULL,
0x0000000837197210ULL, 0x000fe20007ffe0ffULL, 0x000001000e167825ULL, 0x000fe200078e00ffULL,
0x000000131a00720cULL, 0x080fe40003f06070ULL, 0xfffffff833337812ULL, 0x000fe200078ee218ULL,
0x0000400003187824ULL, 0x000fe200078e020aULL, 0x00000007191d7812ULL, 0x000fe200078ec0ffULL,
0x000000040e197836ULL, 0x000fe20000000000ULL, 0x00000070161b7812ULL, 0x000fe200078ef812ULL,
0x0000200018287836ULL, 0x000fe20000000000ULL, 0x0ffffff81d1d7812ULL, 0x000fe200078ef808ULL,
0x0000010019187825ULL, 0x000fe200078e00ffULL, 0x000000133700720cULL, 0x000fc40003f26070ULL,
0x0000001b141a7210ULL, 0x000fe20007fde0ffULL, 0x000000101d217824ULL, 0x000fe200078e0228ULL,
0x000000080e167810ULL, 0x000fe20007ffe0ffULL, 0x000000081e357824ULL, 0x000fe200078e00ffULL,
0x00000070181d7812ULL, 0x000fe200078ef812ULL, 0x00000001151b7824ULL, 0x040fe200030e0617ULL,
0x000000081e207210ULL, 0x000fe20007ffe0ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x0000001d141c7210ULL, 0x000fe40007fde0ffULL, 0xfffffff835357812ULL, 0x000fe200078ee220ULL,
0x0000000c0e187836ULL, 0x000fe20000000000ULL, 0x00000070161f7812ULL, 0x000fe200078ef812ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a217faeULL, 0x0003e2000c901c46ULL,
0x000000131e00720cULL, 0x000fe20003f26070ULL, 0x00000001151d7824ULL, 0x000fe200030e0619ULL,
0x0000001f141e7210ULL, 0x000fe20007fde0ffULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x000000100e167810ULL, 0x000fc60007ffe0ffULL, 0x00000001151f7824ULL, 0x000fe400030e0617ULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x00000070181b7812ULL, 0x002fc600078ef812ULL,
0x0000001023237824ULL, 0x000fe200078e0228ULL, 0x0000007016217812ULL, 0x000fe200078ef812ULL,
0x0000001c37207836ULL, 0x000fe20000000000ULL, 0x0000001b141a7210ULL, 0x000fe20007fde0ffULL,
0x000000140e187836ULL, 0x000fe20000000000ULL, 0x000000001c237faeULL, 0x0003e2000d101c46ULL,
0x0000000820397824ULL, 0x040fe200078e00ffULL, 0x0000000820227210ULL, 0x000fe20007ffe0ffULL,
0x00000001151b7824ULL, 0x000fe200030e0619ULL, 0x000000132000720cULL, 0x000fe20003f46070ULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x0000002114207210ULL, 0x000fc40007fde0ffULL,
0x000000180e167810ULL, 0x000fe20007ffe0ffULL, 0x0000001025257824ULL, 0x000fe200078e0228ULL,
0x0000007018277812ULL, 0x000fe200078ef812ULL, 0x0000000115217824ULL, 0x000fe200030e0617ULL,
0xfffffff839397812ULL, 0x000fe200078ee222ULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0x00000027141c7210ULL, 0x002fe20007fde0ffULL, 0x000000001e257faeULL, 0x0003e2000d901c46ULL,
0x0000001c0e187810ULL, 0x000fe20007ffe0ffULL, 0x00000020371d7836ULL, 0x000fe20000000000ULL,
0x0000007016277812ULL, 0x000fc600078ef812ULL, 0x000000011d237824ULL, 0x040fe200078e0208ULL,
0x000000131d00720cULL, 0x040fe20003f66070ULL, 0x000000081d167824ULL, 0x000fe400078e00ffULL,
0x00000001151d7824ULL, 0x000fe200030e0619ULL, 0x0000002714227210ULL, 0x000fe20007fde0ffULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0xfffffff8162d7812ULL, 0x000fe400078ee223ULL,
0x0000002829257211ULL, 0x002fe200078e20ffULL, 0x0000000115237824ULL, 0x000fe200030e0617ULL,
0x00000070181f7812ULL, 0x000fe200078ef812ULL, 0x0000002437177836ULL, 0x000fc40000000000ULL,
0x000000200e167836ULL, 0x000fe20000000000ULL, 0x000000001a257faeULL, 0x0003e2000e101c46ULL,
0x0000000117187824ULL, 0x040fe200078e0208ULL, 0x00000003172f7819ULL, 0x000fe200000006ffULL,
0x000000102b297824ULL, 0x000fe200078e0228ULL, 0x000000131700720cULL, 0x080fe20003f86070ULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x0000001f141e7210ULL, 0x000fe40007fde0ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee218ULL, 0x000000240e187836ULL, 0x000fe20000000000ULL,
0x0000000020297faeULL, 0x0005e2000e901c46ULL, 0x00000001151f7824ULL, 0x000fe200030e0619ULL,
0x0000007016257812ULL, 0x002fe200078ef812ULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x000000132600720cULL, 0x000fc40003fa6070ULL, 0x0000002514247210ULL, 0x000fe20007fde0ffULL,
0x000000280e1a7836ULL, 0x000fe20000000000ULL, 0x0000007018277812ULL, 0x000fe200078ef812ULL,
0x0000000126167824ULL, 0x000fe400078e0208ULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x0000002833297211ULL, 0x004fe400078e20ffULL, 0xfffffff831317812ULL, 0x000fe200078ee216ULL,
0x0000000115257824ULL, 0x040fe200030e0617ULL, 0x0000002714267210ULL, 0x000fe20007fde0ffULL,
0x0000002c0e167836ULL, 0x000fe20000000000ULL, 0x000000701a177812ULL, 0x000fe200078ef812ULL,
0x0000002c37187836ULL, 0x000fe20000000000ULL, 0x000000001c297faeULL, 0x0003e2000c101c46ULL,
0x0000000115277824ULL, 0x000fe200030e0619ULL, 0x00000017141a7210ULL, 0x000fe20007fde0ffULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x000000300e197810ULL, 0x000fc40007ffe0ffULL,
0x000000131800720cULL, 0x0c0fe20003f06070ULL, 0x00000001151b7824ULL, 0x000fe200030e061bULL,
0x00000070162b7812ULL, 0x000fe200078ef812ULL, 0x0000000118217824ULL, 0x140fe400078e0208ULL,
0x00000008182a7824ULL, 0x000fe200078e00ffULL, 0x0000002b14207210ULL, 0x000fe20007fde0ffULL,
0x0000010019187825ULL, 0x000fe200078e00ffULL, 0x0000002835297211ULL, 0x002fe400078e20ffULL,
0xfffffff82a337812ULL, 0x000fe200078ee221ULL, 0x0000003037167836ULL, 0x000fe20000000000ULL,
0x00000070181d7812ULL, 0x000fe200078ef812ULL, 0x0000000115217824ULL, 0x000fe200030e0617ULL,
0x0000000022297faeULL, 0x0003e2000c901c46ULL, 0x0000000116177824ULL, 0x040fe200078e0208ULL,
0x000000131600720cULL, 0x040fe20003f26070ULL, 0x0000000816187824ULL, 0x000fe200078e00ffULL,
0x0000001d141c7210ULL, 0x000fe20007fde0ffULL, 0x000000340e167836ULL, 0x000fc40000000000ULL,
0x00000010392b7824ULL, 0x100fe200078e0228ULL, 0xfffffff818357812ULL, 0x000fe200078ee217ULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x00000019151d7210ULL, 0x000fe400037fe4ffULL,
0x0000003437187810ULL, 0x000fe20007ffe0ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0228ULL,
0x0000007016237812ULL, 0x002fe200078ef812ULL, 0x000000102f2f7824ULL, 0x100fe200078e0228ULL,
0x000000001e2b7faeULL, 0x0003e2000d101c46ULL, 0x0000003837197836ULL, 0x000fe20000000000ULL,
0x0000002314227210ULL, 0x000fe20007fde0ffULL, 0x0000003c37297836ULL, 0x000fe20000000000ULL,
0x00000000242d7faeULL, 0x0005e2000d901c46ULL, 0x000000380e167836ULL, 0x000fe20000000000ULL,
0x000000131900720cULL, 0x080fe20003f66070ULL, 0x0000001031317824ULL, 0x100fe200078e0228ULL,
0x00000000262f7faeULL, 0x0007e2000e101c46ULL, 0x000000131800720cULL, 0x0c0fe20003f86070ULL,
0x0000001033337824ULL, 0x000fe200078e0228ULL, 0x000000132900720cULL, 0x000fe20003f46070ULL,
0x0000000118137824ULL, 0x100fe200078e0208ULL, 0x0000001715237210ULL, 0x000fe200037fe4ffULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x000000001a317faeULL, 0x0009e6000e901c46ULL,
0x00000008181e7824ULL, 0x002fe200078e00ffULL, 0x00000070161f7812ULL, 0x000fe200078ef812ULL,
0x0000003c0e187836ULL, 0x000fe20000000000ULL, 0x00000008190e7210ULL, 0x000fe20007ffe0ffULL,
0x0000000819257824ULL, 0x004fe200078e00ffULL, 0x0000001f14167210ULL, 0x000fe20007fde0ffULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0xfffffff81e137812ULL, 0x000fe200078ee213ULL,
0x0000000020337faeULL, 0x0003e2000c101c46ULL, 0xfffffff825257812ULL, 0x000fe200078ee20eULL,
0x0000000129087824ULL, 0x040fe200078e0208ULL, 0x00000070181f7812ULL, 0x000fe200078ef812ULL,
0x0000000829277824ULL, 0x008fe200078e00ffULL, 0x0000001715177210ULL, 0x000fe200037fe4ffULL,
0x0000001035357824ULL, 0x100fe200078e0228ULL, 0x0000001f14127210ULL, 0x000fe20007fde0ffULL,
0x0000001025257824ULL, 0x000fe200078e0228ULL, 0xfffffff827277812ULL, 0x000fc400078ee208ULL,
0x00000028131f7211ULL, 0x000fe200078e20ffULL, 0x0000000115137824ULL, 0x000fe200030e0619ULL,
0x000000001c357faeULL, 0x0003e2000c901c46ULL, 0x0000001027277824ULL, 0x000fc600078e0228ULL,
0x00000000221f7faeULL, 0x0003e8000e101c46ULL, 0x0000000016257faeULL, 0x0003e8000d901c46ULL,
0x0000000012277faeULL, 0x0003e2000d101c46ULL, 0x0000000800d07947ULL, 0x010fea0003800000ULL,
0x0000000408217811ULL, 0x040fe200078fe8ffULL, 0x0000400003207824ULL, 0x000fe200078e020aULL,
0x0000000808247811ULL, 0x040fe400078fe8ffULL, 0x00000008210e7210ULL, 0x000fe20007ffe0ffULL,
0x0000000821397824ULL, 0x000fe200078e00ffULL, 0x0000000c08257811ULL, 0x000fe200078fe8ffULL,
0x00000008243b7824ULL, 0x000fe200078e00ffULL, 0x0000001408277811ULL, 0x000fe400078fe8ffULL,
0xfffffff839397812ULL, 0x000fe200078ee20eULL, 0x00000001240e7824ULL, 0x100fe200078e0208ULL,
0x0000001008267811ULL, 0x000fe200078fe8ffULL, 0x0000000825187824ULL, 0x000fe200078e00ffULL,
0x0000000825137210ULL, 0x000fe20007ffe0ffULL, 0x00000008271a7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee20eULL, 0x0000000126167824ULL, 0x000fe200078e0208ULL,
0x00000020080e7811ULL, 0x000fe200078fe8ffULL, 0x00000008263f7824ULL, 0x000fe200078e00ffULL,
0x0000000827177210ULL, 0x000fc40007ffe0ffULL, 0x0000001808287811ULL, 0x000fe200078fe8ffULL,
0x000000080e1c7824ULL, 0x000fe200078e00ffULL, 0x00000024082d7811ULL, 0x000fe400078fe8ffULL,
0xfffffff8183d7812ULL, 0x000fe200078ee213ULL, 0x000000010e137824ULL, 0x100fe200078e0208ULL,
0xfffffff81a417812ULL, 0x000fe200078ee217ULL, 0x0000000128177824ULL, 0x000fe200078e0208ULL,
0x0000002c082f7811ULL, 0x000fe200078fe8ffULL, 0x00000008281a7824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee216ULL, 0x000000082d197824ULL, 0x000fe200078e00ffULL,
0x000000082d167210ULL, 0x000fc40007ffe0ffULL, 0x00000028082e7811ULL, 0x040fe400078fe8ffULL,
0xfffffff81c137812ULL, 0x000fe200078ee213ULL, 0x000000082f1c7824ULL, 0x000fe200078e00ffULL,
0x0000001c082c7811ULL, 0x000fe200078fe8ffULL, 0x000000082e1b7824ULL, 0x040fe200078e00ffULL,
0xfffffff81a437812ULL, 0x000fe400078ee217ULL, 0xfffffff8191a7812ULL, 0x000fe200078ee216ULL,
0x000000012e167824ULL, 0x000fe200078e0208ULL, 0x000000082f177210ULL, 0x000fe20007ffe0ffULL,
0x000000082c457824ULL, 0x000fe200078e00ffULL, 0x0000003408387811ULL, 0x000fc400078fe8ffULL,
0xfffffff81c1c7812ULL, 0x000fe400078ee217ULL, 0x000000082c187210ULL, 0x000fe20007ffe0ffULL,
0x00000008381e7824ULL, 0x000fe200078e00ffULL, 0x0000003008367811ULL, 0x040fe400078fe8ffULL,
0x0000000808177211ULL, 0x000fe400078fe8ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee216ULL,
0x00000008361d7824ULL, 0x000fe200078e00ffULL, 0x0000000f08167211ULL, 0x000fc400078fe8ffULL,
0x00000038083a7811ULL, 0x000fe400078fe8ffULL, 0xfffffff845457812ULL, 0x000fe200078ee218ULL,
0x0000000136187824ULL, 0x000fe200078e0208ULL, 0x0000000838197210ULL, 0x000fe20007ffe0ffULL,
0x000000083a227824ULL, 0x000fe200078e00ffULL, 0x0000003c083c7811ULL, 0x000fe400078fe8ffULL,
0x00000007171f7812ULL, 0x000fe200078ec0ffULL, 0x0000010016167825ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fc400078ee219ULL, 0x0ffffff81f377812ULL, 0x000fe200078ef808ULL,
0x000000013c1f7824ULL, 0x040fe200078e0208ULL, 0x000000083a197210ULL, 0x000fe20007ffe0ffULL,
0x000000083c2a7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee218ULL,
0x000000010f187824ULL, 0x000fe200078e0221ULL, 0x0000007016217812ULL, 0x000fe400078ef812ULL,
0xfffffff822087812ULL, 0x000fe200078ee219ULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x0000200020167810ULL, 0x000fc40007ffe0ffULL, 0xfffffff82a1f7812ULL, 0x000fe400078ee21fULL,
0x0000002114207210ULL, 0x000fe20007f1e0ffULL, 0x0000001037377824ULL, 0x100fe200078e0216ULL,
0x000000163d3d7211ULL, 0x080fe200078e20ffULL, 0x0000001039397824ULL, 0x100fe200078e0216ULL,
0x0000001645457211ULL, 0x080fe200078e20ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0216ULL,
0x000000161c4d7211ULL, 0x080fe200078e20ffULL, 0x000000103f3f7824ULL, 0x100fe200078e0216ULL,
0x000000161f557211ULL, 0x000fe200078e20ffULL, 0x0000001041417824ULL, 0x100fe200078e0216ULL,
0x0000007018237812ULL, 0x000fe200078ef812ULL, 0x0000001043437824ULL, 0x000fc400078e0216ULL,
0x0000001013477824ULL, 0x100fe200078e0216ULL, 0x0000002314227210ULL, 0x000fe20007f3e0ffULL,
0x000000101a497824ULL, 0x100fe400078e0216ULL, 0x000000101b4b7824ULL, 0x100fe200078e0216ULL,
0x0000001915237210ULL, 0x000fe20000ffe4ffULL, 0x000000101d4f7824ULL, 0x100fe400078e0216ULL,
0x000000101e517824ULL, 0x100fe400078e0216ULL, 0x0000001008537824ULL, 0x000fc400078e0216ULL,
0x000000010f167824ULL, 0x000fe400078e0224ULL, 0x0000000115217824ULL, 0x000fe400000e0617ULL,
0x0000010016167825ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020377faeULL, 0x0003e2000b901c46ULL, 0x000000010f1c7824ULL, 0x040fe400078e0227ULL,
0x000000010f187824ULL, 0x040fe200078e0225ULL, 0x0000007016257812ULL, 0x000fe200078ef812ULL,
0x000000010f1a7824ULL, 0x000fe200078e0226ULL, 0x0000000022397faeULL, 0x0003e2000b901c46ULL,
0x000001001c1c7825ULL, 0x000fe200078e00ffULL, 0x0000002514247210ULL, 0x000fc60007f1e0ffULL,
0x0000010018187825ULL, 0x000fe200078e00ffULL, 0x000000701c2b7812ULL, 0x000fe400078ef812ULL,
0x0000001715257210ULL, 0x000fe200007fe4ffULL, 0x000000010f1e7824ULL, 0x000fe200078e0228ULL,
0x0000007018277812ULL, 0x000fe200078ef812ULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x0000002b142a7210ULL, 0x000fe20007f1e0ffULL, 0x00000000243b7faeULL, 0x0003e2000b901c46ULL,
0x0000002714267210ULL, 0x000fe20007f3e0ffULL, 0x000001001e1e7825ULL, 0x000fe200078e00ffULL,
0x000000701a297812ULL, 0x000fc400078ef812ULL, 0x0000001d152b7210ULL, 0x000fe200007fe4ffULL,
0x000000010f167824ULL, 0x040fe200078e022cULL, 0x000000701e137812ULL, 0x000fe200078ef812ULL,
0x000000010f187824ULL, 0x000fe200078e020eULL, 0x0000002914287210ULL, 0x000fe20007f5e0ffULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x00000013142c7210ULL, 0x000fc60007f1e0ffULL,
0x000000010f1c7824ULL, 0x000fe200078e022eULL, 0x0000007016137812ULL, 0x000fe200078ef812ULL,
0x0000000115277824ULL, 0x000fe400008e0619ULL, 0x000000010f1a7824ULL, 0x000fe200078e022dULL,
0x0000001f152d7210ULL, 0x000fe200007fe4ffULL, 0x0000010018187825ULL, 0x000fe200078e00ffULL,
0x00000013142e7210ULL, 0x000fe20007f1e0ffULL, 0x00000000263d7faeULL, 0x0003e4000b901c46ULL,
0x0000000115297824ULL, 0x000fe200010e061bULL, 0x0000007018317812ULL, 0x000fe200078ef812ULL,
0x000001001c1c7825ULL, 0x000fc600078e00ffULL, 0x0000003114307210ULL, 0x000fe20007f3e0ffULL,
0x000001001a1a7825ULL, 0x000fe200078e00ffULL, 0x000000701c357812ULL, 0x000fe200078ef812ULL,
0x00000000283f7faeULL, 0x0003e2000b901c46ULL, 0x0000003a0f1c7210ULL, 0x000fe20007ffe0ffULL,
0x000000010f167824ULL, 0x000fe200078e022fULL, 0x000000701a337812ULL, 0x000fe200078ef812ULL,
0x00000001152f7824ULL, 0x000fe200000e0617ULL, 0x0000003514347210ULL, 0x000fe20007f5e0ffULL,
0x0000010016167825ULL, 0x000fe200078e00ffULL, 0x0000003314327210ULL, 0x000fe20007f1e0ffULL,
0x000000002a417faeULL, 0x0003e4000b901c46ULL, 0x000000010f187824ULL, 0x040fe200078e0236ULL,
0x0000007016137812ULL, 0x000fe200078ef812ULL, 0x000000010f1a7824ULL, 0x000fe200078e0238ULL,
0x0000001b15337210ULL, 0x000fe200007fe4ffULL, 0x0000000115317824ULL, 0x000fe200008e0619ULL,
0x0000001314167210ULL, 0x000fe20007f1e0ffULL, 0x000000010f1e7824ULL, 0x000fe200078e023cULL,
0x000000002c437faeULL, 0x0003e2000b901c46ULL, 0x0000010018187825ULL, 0x000fc600078e00ffULL,
0x000000002e457faeULL, 0x0003e2000b901c46ULL, 0x0000000115357824ULL, 0x040fe200010e061dULL,
0x00000070185b7812ULL, 0x000fe200078ef812ULL, 0x000001001a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000030477faeULL, 0x0003e6000b901c46ULL, 0x000001001c1c7825ULL, 0x000fe200078e00ffULL,
0x000000701a597812ULL, 0x000fe200078ef812ULL, 0x0000000032497faeULL, 0x0003e4000b901c46ULL,
0x000001001e1e7825ULL, 0x000fe200078e00ffULL, 0x000000701c577812ULL, 0x000fe200078ef812ULL,
0x00000000344b7faeULL, 0x0003e2000b901c46ULL, 0x0000005914187210ULL, 0x000fe20007f3e0ffULL,
0x0000000115177824ULL, 0x000fe200000e0617ULL, 0x000000701e137812ULL, 0x000fc400078ef812ULL,
0x0000005b14127210ULL, 0x000fe40007f1e0ffULL, 0x00000057141a7210ULL, 0x000fe20007f5e0ffULL,
0x00000000164d7faeULL, 0x0003e2000b901c46ULL, 0x0000001314147210ULL, 0x000fe20007f7e0ffULL,
0x0000000115137824ULL, 0x040fe200000e0619ULL, 0x0000001b15197210ULL, 0x000fe20000ffe4ffULL,
0x00000001151b7824ULL, 0x040fe400010e061dULL, 0x0000000115157824ULL, 0x000fe200018e061fULL,
0x00000000124f7faeULL, 0x0003e8000b901c46ULL, 0x0000000018517faeULL, 0x0003e8000b901c46ULL,
0x000000001a537faeULL, 0x0003e8000b901c46ULL, 0x0000000014557faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000127805ULL, 0x002fe20000015200ULL,
0x01e600110a0075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff0e7224ULL, 0x000fce00078e00ffULL, 0x000000100e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001412177210ULL, 0x000fc80007f1e1ffULL, 0x0000001513157210ULL, 0x000fe400007fe5ffULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011415ULL, 0x0000001708087211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000208087819ULL, 0x000fc80000001215ULL,
0x000000080000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010e0e7836ULL, 0x000fce0000000000ULL, 0x01e600110a0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000c0500720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00009400ff0e7b82ULL, 0x000e620000000800ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x0000840000097ab9ULL, 0x000fe20000000800ULL,
0x0000000a03997211ULL, 0x000fe200078e18ffULL, 0x0000001f09047890ULL, 0x000fe4000fffe03fULL,
0x8000000909107c36ULL, 0x000fe20008000000ULL, 0xffffffff09057890ULL, 0x000fe4000fffe03fULL,
0x000000043f047899ULL, 0x000fe40008011604ULL, 0x00000008ff107819ULL, 0x000fe20000011610ULL,
0x0000000909087890ULL, 0x000fc4000fffe03fULL, 0x0ffffffe04047892ULL, 0x000fe2000f8ec03fULL,
0x0000000e9b9b7224ULL, 0x002fe400078e02ffULL, 0x00000020030e7824ULL, 0x000fd200078e020aULL,
0x00008e00ff9e7b82ULL, 0x000e620000000a00ULL, 0x0000000105117836ULL, 0x000fe40000000000ULL,
0x0000000407177224ULL, 0x000fe400078e02ffULL, 0x0000010005127824ULL, 0x000fe200078e0206ULL,
0x0000000c1100720cULL, 0x000fe20003f06070ULL, 0x0000010017167825ULL, 0x002fd800078e009eULL,
0x0000000800f08947ULL, 0x000fea0003800000ULL, 0x00000003ff317819ULL, 0x004fe20000011608ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x0000000408117819ULL, 0x000fe200000006ffULL,
0x0000400003387824ULL, 0x000fe200078e020aULL, 0x0000000c311f7810ULL, 0x000fe20007ffe0ffULL,
0x00000008311d7836ULL, 0x000fe20000000000ULL, 0x0000007011117812ULL, 0x000fe200078ec0ffULL,
0x00000004311b7836ULL, 0x000fe20000000000ULL, 0x000000031f357819ULL, 0x000fe200000006ffULL,
0x000000011d137824ULL, 0x100fe200078e0208ULL, 0x0000008011187812ULL, 0x000fe200078efcffULL,
0x000000081d147824ULL, 0x000fe200078e00ffULL, 0x000000031b2f7819ULL, 0x000fe200000006ffULL,
0x000000010f157824ULL, 0x000fe200078e0231ULL, 0x0000001c313b7810ULL, 0x000fe20007ffe0ffULL,
0x000000011b047824ULL, 0x000fe200078e0208ULL, 0xfffffff814337812ULL, 0x000fe200078ee213ULL,
0x0000010015147825ULL, 0x000fe200078e0018ULL, 0x0000001209137248ULL, 0x000fc40007fe0000ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee204ULL, 0x000000011f047824ULL, 0x000fe200078e0208ULL,
0x0000001416207210ULL, 0x000fe20007f1e0ffULL, 0x0000001031237836ULL, 0x000fe40000000000ULL,
0x00000014312b7836ULL, 0x000fe20000000000ULL, 0x0000001517217210ULL, 0x000fe200007fe4ffULL,
0x000000010f157824ULL, 0x000fe200078e021bULL, 0xfffffff835357812ULL, 0x000fe200078ee204ULL,
0x0000000113047824ULL, 0x000fe400078e0a12ULL, 0x0000010015147825ULL, 0x000fc600078e0018ULL,
0x000000041b00720cULL, 0x080fe20003f86070ULL, 0x00000001231a7824ULL, 0x040fe200078e0208ULL,
0x0000001416227210ULL, 0x000fe20007f7e0ffULL, 0x0000000823377824ULL, 0x000fe200078e00ffULL,
0x000000041d00720cULL, 0x080fe20003f26070ULL, 0x000000010f1b7824ULL, 0x000fe200078e021dULL,
0x000000041f00720cULL, 0x000fe20003f46070ULL, 0x000000010f137824ULL, 0x000fe200078e022bULL,
0xfffffff837377812ULL, 0x000fe200078ee21aULL, 0x000001001b1a7825ULL, 0x000fe200078e0018ULL,
0x0000001f0f1d7210ULL, 0x000fc40007ffe0ffULL, 0x000000042300720cULL, 0x000fe20003f06070ULL,
0x000000010f1f7824ULL, 0x000fe200078e0223ULL, 0x0000001a16247210ULL, 0x000fe20007fbe0ffULL,
0x0000000117237824ULL, 0x000fe400018e0615ULL, 0x0000010013147825ULL, 0x100fe200078e0018ULL,
0x0000001b17257210ULL, 0x000fe40002ffe4ffULL, 0x0ffffff808137812ULL, 0x000fe200078ec0ffULL,
0x00000018312d7836ULL, 0x000fe20000000000ULL, 0x0000001416287210ULL, 0x000fe20007fde0ffULL,
0x000001001f1e7825ULL, 0x000fc600078e0018ULL, 0x0000002d0f1b7210ULL, 0x000fe20007ffe0ffULL,
0x000001001d1c7825ULL, 0x000fe200078e0018ULL, 0x0000001e161e7210ULL, 0x000fc60007fbe0ffULL,
0x0000000117297824ULL, 0x000fe200030e0615ULL, 0x0000001c16267210ULL, 0x000fe20007f7e0ffULL,
0x000001001b147825ULL, 0x000fe200078e0018ULL, 0x000000082b1c7210ULL, 0x000fc60007ffe0ffULL,
0x00000001311a7824ULL, 0x000fe200078e0208ULL, 0x00000014162a7210ULL, 0x000fe20007fde0ffULL,
0x00000001171f7824ULL, 0x000fe200028e061fULL, 0x000000043100720cULL, 0x080fe20003fa6070ULL,
0x0000400038147836ULL, 0x000fe20000000000ULL, 0x00000007131b7812ULL, 0x000fe200078ef81aULL,
0x0000000117277824ULL, 0x000fe200018e061dULL, 0x000000042b00720cULL, 0x040fe20003f66070ULL,
0x000000082b397824ULL, 0x000fe400078e00ffULL, 0x00000001172b7824ULL, 0x000fc400030e0615ULL,
0x000000101b157824ULL, 0x100fe200078e0214ULL, 0x0000003b0f1b7210ULL, 0x000fe20007ffe0ffULL,
0x00000020313d7836ULL, 0x000fe20000000000ULL, 0xfffffff839397812ULL, 0x000fe200078ee21cULL,
0x000000102f2f7824ULL, 0x000fe200078e0214ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020157faeULL, 0x0003e2000e901c46ULL, 0x000001001b1a7825ULL, 0x000fe200078e0018ULL,
0x000000042d00720cULL, 0x080fe40003fa6070ULL, 0x00000000222f7faeULL, 0x0005e2000e101c46ULL,
0x000000010f1d7824ULL, 0x000fe200078e023dULL, 0x0000001a162c7210ULL, 0x000fe20007fde0ffULL,
0x000000012d2e7824ULL, 0x000fe200078e0208ULL, 0x000000043b00720cULL, 0x000fe20003f86070ULL,
0x000000082d3f7824ULL, 0x000fe200078e00ffULL, 0x000000083b1a7210ULL, 0x000fe20007ffe0ffULL,
0x000000083b3b7824ULL, 0x000fe200078e00ffULL, 0x000000083d207210ULL, 0x002fe20007ffe0ffULL,
0x0000001033157824ULL, 0x000fc400078e0214ULL, 0x0000002431337836ULL, 0x000fe20000000000ULL,
0xfffffff83b2f7812ULL, 0x004fe200078ee21aULL, 0x000001001d1c7825ULL, 0x000fe200078e0018ULL,
0x0000000024157faeULL, 0x0003e2000c901c46ULL, 0x000000043d00720cULL, 0x080fe40003f26070ULL,
0x00000001172d7824ULL, 0x000fe200030e061bULL, 0x0000001c161c7210ULL, 0x000fe20007fde0ffULL,
0x0000001035217824ULL, 0x000fe200078e0214ULL, 0xfffffff83f237812ULL, 0x000fe200078ee22eULL,
0x000000010f1b7824ULL, 0x000fe200078e0233ULL, 0x0000001d171d7210ULL, 0x000fe200037fe4ffULL,
0x000000083d3d7824ULL, 0x000fe200078e00ffULL, 0x0000000026217faeULL, 0x0005e2000d101c46ULL,
0x000001001b1a7825ULL, 0x000fe200078e0018ULL, 0x000000043300720cULL, 0x000fc40003f46070ULL,
0x0000001437157211ULL, 0x082fe200078e20ffULL, 0x0000000133227824ULL, 0x040fe200078e0208ULL,
0x0000001a161a7210ULL, 0x000fe20007fde0ffULL, 0x0000000833357824ULL, 0x000fe200078e00ffULL,
0xfffffff83d337812ULL, 0x000fe200078ee220ULL, 0x0000001023237824ULL, 0x100fe200078e0214ULL,
0x000000142f257211ULL, 0x000fe200078e20ffULL, 0x00000001171b7824ULL, 0x000fe200030e061bULL,
0xfffffff835357812ULL, 0x000fe200078ee222ULL, 0x0000001039217824ULL, 0x104fe200078e0214ULL,
0x000000001e157faeULL, 0x0003e2000c101c46ULL, 0x0000001033277824ULL, 0x000fc400078e0214ULL,
0x0000002831337836ULL, 0x000fe20000000000ULL, 0x0000000028217faeULL, 0x000fe2000d901c46ULL,
0x00000010352f7824ULL, 0x000fe200078e0214ULL, 0x0000002c31357810ULL, 0x000fe20007ffe0ffULL,
0x0000003031377836ULL, 0x000fe20000000000ULL, 0x000000002a237faeULL, 0x000fe2000e901c46ULL,
0x0000000833207824ULL, 0x040fe200078e00ffULL, 0x000000043300720cULL, 0x080fe20003fa6070ULL,
0x0000003431397836ULL, 0x000fe20000000000ULL, 0x000000002c257faeULL, 0x0005e2000e101c46ULL,
0x000000010f157824ULL, 0x002fe200078e0233ULL, 0x000000043500720cULL, 0x080fe20003f86070ULL,
0x00000001331f7824ULL, 0x100fe200078e0208ULL, 0x000000001c277faeULL, 0x0003e2000c901c46ULL,
0x00000038313b7836ULL, 0x000fe20000000000ULL, 0x0000003c31317810ULL, 0x000fe20007ffe0ffULL,
0x0000000139247824ULL, 0x000fe200078e0208ULL, 0x000000001a2f7faeULL, 0x0007e2000d101c46ULL,
0x000000043700720cULL, 0x000fc40003f66070ULL, 0x000000043900720cULL, 0x080fe20003f46070ULL,
0x000000010f257824ULL, 0x004fe200078e023bULL, 0x000000043b00720cULL, 0x0c0fe20003f26070ULL,
0x000000083b2d7824ULL, 0x000fe200078e00ffULL, 0x000000043100720cULL, 0x000fe20003f06070ULL,
0x0000000135047824ULL, 0x000fe200078e0208ULL, 0x000000350f1d7210ULL, 0x002fe40007ffe0ffULL,
0xfffffff820277812ULL, 0x000fe200078ee21fULL, 0x00000100151a7825ULL, 0x008fe200078e0018ULL,
0x0000000335297819ULL, 0x000fc400000006ffULL, 0x00000003392b7819ULL, 0x000fe200000006ffULL,
0x000001001d1c7825ULL, 0x000fe200078e0018ULL, 0x0000001a161e7210ULL, 0x000fe40007fde0ffULL,
0xfffffff829297812ULL, 0x000fe200078ee204ULL, 0x000000010f157824ULL, 0x000fe200078e0237ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee224ULL, 0x00000001171f7824ULL, 0x000fe200030e061bULL,
0x0000001c16207210ULL, 0x000fe20007fde0ffULL, 0x00000100151a7825ULL, 0x000fc800078e0018ULL,
0x000000010f157824ULL, 0x000fe400078e0239ULL, 0x0000000117217824ULL, 0x000fe200030e061dULL,
0x0000001a16227210ULL, 0x000fe20007fde0ffULL, 0x00000100151c7825ULL, 0x000fc600078e0018ULL,
0x0000001b17237210ULL, 0x000fe200037fe4ffULL, 0x00000100251a7825ULL, 0x000fe200078e0018ULL,
0x0000001c161c7210ULL, 0x000fc60007fde0ffULL, 0x000000010f157824ULL, 0x000fe400078e0231ULL,
0x0000000137047824ULL, 0x000fe400078e0208ULL, 0x00000001171d7824ULL, 0x000fe200030e061dULL,
0x0000001a161a7210ULL, 0x000fe20007fde0ffULL, 0x0000000837377824ULL, 0x000fe400078e00ffULL,
0x0000010015187825ULL, 0x000fe200078e0018ULL, 0x0000001427157211ULL, 0x080fe400078e20ffULL,
0xfffffff837257812ULL, 0x000fe200078ee204ULL, 0x00000001171b7824ULL, 0x000fe200030e061bULL,
0x000000083b047210ULL, 0x000fe20007ffe0ffULL, 0x0000000131247824ULL, 0x040fe200078e0208ULL,
0x0000001816167210ULL, 0x000fe20007fde0ffULL, 0x00000008312f7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee204ULL, 0x0000001025257824ULL, 0x100fe200078e0214ULL,
0x000000142b277211ULL, 0x000fe200078e20ffULL, 0x0000000117177824ULL, 0x000fe200030e0619ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee224ULL, 0x0000001029197824ULL, 0x100fe200078e0214ULL,
0x000000001e157faeULL, 0x0003e2000e901c46ULL, 0x000000102d297824ULL, 0x000fc400078e0214ULL,
0x000000102f2b7824ULL, 0x000fe200078e0214ULL, 0x0000000020197faeULL, 0x0003e8000e101c46ULL,
0x0000000022257faeULL, 0x0003e8000d901c46ULL, 0x000000001c277faeULL, 0x0003e8000d101c46ULL,
0x000000001a297faeULL, 0x0003e8000c901c46ULL, 0x00000000162b7faeULL, 0x0003e2000c101c46ULL,
0x0000000800a07947ULL, 0x000fea0003800000ULL, 0x0000000808137811ULL, 0x044fe200078fe8ffULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x0000000408047811ULL, 0x040fe200078fe8ffULL,
0x0000400003387824ULL, 0x000fe200078e020aULL, 0x0000000c08187811ULL, 0x000fe200078fe8ffULL,
0x0000000113147824ULL, 0x140fe200078e0208ULL, 0x00000003041a7819ULL, 0x000fe200000006ffULL,
0x00000008133b7824ULL, 0x000fe200078e00ffULL, 0x00000003181c7819ULL, 0x000fe200000006ffULL,
0x0000000104117824ULL, 0x100fe200078e0208ULL, 0x000000180f1d7210ULL, 0x000fe20007ffe0ffULL,
0x0000000118157824ULL, 0x000fe200078e0208ULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee214ULL,
0x000000010f1b7824ULL, 0x000fe200078e0213ULL, 0x0000001008147811ULL, 0x000fc400078fe8ffULL,
0xfffffff81a397812ULL, 0x000fe400078ee211ULL, 0xfffffff81c3d7812ULL, 0x000fe200078ee215ULL,
0x0000000114117824ULL, 0x000fe200078e0208ULL, 0x00000014081a7811ULL, 0x000fe200078fe8ffULL,
0x00000008141e7824ULL, 0x000fe200078e00ffULL, 0x00000018081c7811ULL, 0x000fe200078fe8ffULL,
0x000000010f1f7824ULL, 0x040fe200078e0214ULL, 0x000000031a207819ULL, 0x040fe200000006ffULL,
0x000000011a157824ULL, 0x100fe200078e0208ULL, 0xfffffff81e3f7812ULL, 0x000fe200078ee211ULL,
0x000000011c197824ULL, 0x000fe200078e0208ULL, 0x0000001c081e7811ULL, 0x000fe200078fe8ffULL,
0x000000081c227824ULL, 0x000fe200078e00ffULL, 0xfffffff820417812ULL, 0x000fe200078ee215ULL,
0x000000010f237824ULL, 0x040fe200078e021cULL, 0x000000031e247819ULL, 0x040fe200000006ffULL,
0x000000011e117824ULL, 0x000fe200078e0208ULL, 0xfffffff822437812ULL, 0x000fe200078ee219ULL,
0x000000010f217824ULL, 0x000fe200078e021aULL, 0x0000002008207811ULL, 0x000fc400078fe8ffULL,
0x0000002408227811ULL, 0x000fe400078fe8ffULL, 0xfffffff824457812ULL, 0x000fe200078ee211ULL,
0x0000000120157824ULL, 0x100fe200078e0208ULL, 0x0000002808247811ULL, 0x000fe200078fe8ffULL,
0x0000000820267824ULL, 0x000fe200078e00ffULL, 0x0000000322287819ULL, 0x040fe200000006ffULL,
0x0000000122197824ULL, 0x100fe200078e0208ULL, 0x0000001e0f257210ULL, 0x000fe20007ffe0ffULL,
0x0000000124117824ULL, 0x040fe200078e0208ULL, 0xfffffff826477812ULL, 0x000fe200078ee215ULL,
0x00000008242a7824ULL, 0x000fe200078e00ffULL, 0xfffffff828497812ULL, 0x000fe200078ee219ULL,
0x000000010f277824ULL, 0x040fe200078e0220ULL, 0x0000002c08267811ULL, 0x040fe200078fe8ffULL,
0x000000010f2b7824ULL, 0x040fe200078e0224ULL, 0x0000003008287811ULL, 0x000fe200078fe8ffULL,
0x000000010f297824ULL, 0x040fe200078e0222ULL, 0xfffffff82a4b7812ULL, 0x000fe200078ee211ULL,
0x0000000126157824ULL, 0x100fe200078e0208ULL, 0x00000034082a7811ULL, 0x000fe200078fe8ffULL,
0x0000000128197824ULL, 0x100fe200078e0208ULL, 0x00000003262c7819ULL, 0x000fe200000006ffULL,
0x00000008282e7824ULL, 0x000fe200078e00ffULL, 0x000000032a307819ULL, 0x040fe200000006ffULL,
0x000000012a117824ULL, 0x000fe200078e0208ULL, 0xfffffff82c4d7812ULL, 0x000fe200078ee215ULL,
0x000000010f2f7824ULL, 0x040fe200078e0228ULL, 0xfffffff82e4f7812ULL, 0x000fe200078ee219ULL,
0x000000010f317824ULL, 0x000fe200078e022aULL, 0x00000038082c7811ULL, 0x000fc400078fe8ffULL,
0x0000003c082e7811ULL, 0x040fe400078fe8ffULL, 0xfffffff830517812ULL, 0x000fe200078ee211ULL,
0x0000001008117824ULL, 0x000fe200078e00ffULL, 0x000000032e347819ULL, 0x000fe200000006ffULL,
0x000000012c157824ULL, 0x140fe200078e0208ULL, 0x000000260f2d7210ULL, 0x000fe20007ffe0ffULL,
0x000000082c327824ULL, 0x000fe200078e00ffULL, 0x0000007011117812ULL, 0x000fe200078ec0ffULL,
0x000000012e197824ULL, 0x000fe200078e0208ULL, 0x0000002e0f137210ULL, 0x000fe20007ffe0ffULL,
0x000000010f337824ULL, 0x000fe200078e022cULL, 0xfffffff832537812ULL, 0x000fc400078ee215ULL,
0xfffffff834557812ULL, 0x000fe200078ee219ULL, 0x000000010f197824ULL, 0x000fe200078e0204ULL,
0x0000000f08157211ULL, 0x040fe400078fe8ffULL, 0x0000008011347812ULL, 0x000fe400078efcffULL,
0x0000000808047211ULL, 0x000fc600078fe8ffULL, 0x0000010015147825ULL, 0x000fc800078e0034ULL,
0x0000010019187825ULL, 0x100fe200078e0034ULL, 0x0000001416367210ULL, 0x000fe40007f1e0ffULL,
0x0000400038147810ULL, 0x000fe20007ffe0ffULL, 0x000001001d1c7825ULL, 0x000fe200078e0034ULL,
0x0000001816187210ULL, 0x000fc60007f3e0ffULL, 0x000001001f1e7825ULL, 0x000fc800078e0034ULL,
0x000001001b1a7825ULL, 0x000fc800078e0034ULL, 0x0000000117377824ULL, 0x040fe200000e0615ULL,
0x0000001c161c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000117197824ULL, 0x000fe200008e0619ULL,
0x0000001e161e7210ULL, 0x000fe20007f3e0ffULL, 0x0000010025247825ULL, 0x000fe200078e0034ULL,
0x0000001a161a7210ULL, 0x000fc60007f5e0ffULL, 0x0000010027267825ULL, 0x000fe200078e0034ULL,
0x0000001b171b7210ULL, 0x000fc600017fe4ffULL, 0x0000010021207825ULL, 0x000fc800078e0034ULL,
0x00000001171d7824ULL, 0x040fe200000e061dULL, 0x0000002416247210ULL, 0x000fe20007f1e0ffULL,
0x00000001171f7824ULL, 0x000fe200008e061fULL, 0x0000002616267210ULL, 0x000fe20007f3e0ffULL,
0x000001002d2c7825ULL, 0x000fe200078e0034ULL, 0x0000002016207210ULL, 0x000fc60007f5e0ffULL,
0x000001002f2e7825ULL, 0x000fc800078e0034ULL, 0x0000010023227825ULL, 0x000fc800078e0034ULL,
0x0000010029287825ULL, 0x000fe200078e0034ULL, 0x0000002216227210ULL, 0x000fc60007f7e0ffULL,
0x0000000117257824ULL, 0x040fe200000e0625ULL, 0x0000002c162c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000117277824ULL, 0x000fe200008e0627ULL, 0x0000002e162e7210ULL, 0x000fe20007f3e0ffULL,
0x000001002b2a7825ULL, 0x000fe200078e0034ULL, 0x0000002317237210ULL, 0x000fc60001ffe4ffULL,
0x0000010031307825ULL, 0x000fe200078e0034ULL, 0x0000002a162a7210ULL, 0x000fc60007f7e0ffULL,
0x0000010033327825ULL, 0x000fe200078e0034ULL, 0x0000002b172b7210ULL, 0x000fc60001ffe4ffULL,
0x0000000117217824ULL, 0x000fe200010e0621ULL, 0x0000002816287210ULL, 0x000fe20007f5e0ffULL,
0x0000010013347825ULL, 0x000fe200078e0034ULL, 0x0ffffff808137812ULL, 0x000fc600078ec0ffULL,
0x00000001172d7824ULL, 0x040fe200000e062dULL, 0x0000003016307210ULL, 0x000fe20007f1e0ffULL,
0x00000001172f7824ULL, 0x040fe200008e062fULL, 0x0000003216327210ULL, 0x000fe20007f3e0ffULL,
0x0000000117297824ULL, 0x040fe200010e0629ULL, 0x0000000713157812ULL, 0x000fe200078ef804ULL,
0x0000000117317824ULL, 0x040fe200000e0631ULL, 0x0000003416167210ULL, 0x000fe20007f5e0ffULL,
0x0000000117337824ULL, 0x000fe400008e0633ULL, 0x0000001015157824ULL, 0x100fe200078e0214ULL,
0x0000003517177210ULL, 0x000fe200017fe4ffULL, 0x0000001039357824ULL, 0x000fc400078e0214ULL,
0x000000103b397824ULL, 0x100fe200078e0214ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000036157faeULL, 0x0003e2000b901c46ULL, 0x000000103d3b7824ULL, 0x100fe200078e0214ULL,
0x000000143f3d7211ULL, 0x000fe200078e20ffULL, 0x00000010413f7824ULL, 0x100fe200078e0214ULL,
0x0000000018357faeULL, 0x0005e2000b901c46ULL, 0x0000001043417824ULL, 0x000fc600078e0214ULL,
0x000000001a397faeULL, 0x0007e2000b901c46ULL, 0x0000001045157824ULL, 0x002fc600078e0214ULL,
0x000000001c3b7faeULL, 0x0003e2000b901c46ULL, 0x0000001447197211ULL, 0x004fc600078e20ffULL,
0x000000001e3d7faeULL, 0x0005e2000b901c46ULL, 0x00000010491b7824ULL, 0x008fc600078e0214ULL,
0x00000000203f7faeULL, 0x0007e2000b901c46ULL, 0x000000104b1d7824ULL, 0x002fc600078e0214ULL,
0x0000000022417faeULL, 0x0003e2000b901c46ULL, 0x000000104d1f7824ULL, 0x004fc600078e0214ULL,
0x0000000024157faeULL, 0x0005e2000b901c46ULL, 0x000000144f217211ULL, 0x008fc600078e20ffULL,
0x0000000026197faeULL, 0x0007e2000b901c46ULL, 0x0000001051237824ULL, 0x002fc600078e0214ULL,
0x00000000281b7faeULL, 0x0007e2000b901c46ULL, 0x0000001053157824ULL, 0x004fc600078e0214ULL,
0x000000002a1d7faeULL, 0x0007e2000b901c46ULL, 0x0000001055257824ULL, 0x000fc600078e0214ULL,
0x000000002c1f7faeULL, 0x0007e8000b901c46ULL, 0x000000002e217faeULL, 0x0007e8000b901c46ULL,
0x0000000030237faeULL, 0x0007e8000b901c46ULL, 0x0000000032157faeULL, 0x0007e8000b901c46ULL,
0x0000000016257faeULL, 0x0007e4000b901c46ULL, 0x0000000402027810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff047424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000b0200720cULL, 0x000fda0003f06070ULL, 0x00009000ff1a8b82ULL, 0x00ae620000000a00ULL,
0x000000029b158824ULL, 0x000fe200078e0202ULL, 0x0000000808197812ULL, 0x040fe400078ec0ffULL,
0x00000004ff1d7819ULL, 0x100fe40000011608ULL, 0x0000000708167812ULL, 0x000fe400078ec0ffULL,
0x00000003ff177819ULL, 0x000fe20000011608ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000004151a8825ULL, 0x002fca00078e001aULL, 0x000000061a048981ULL, 0x0002a2000c1e1900ULL,
0x0000000719187812ULL, 0x000fe200078ef808ULL, 0x0000200038157836ULL, 0x000fe20000000000ULL,
0x000000031d217819ULL, 0x000fe400000006ffULL, 0x00000001171f7812ULL, 0x000fe200078ec0ffULL,
0x000000011d197824ULL, 0x000fe200078e0218ULL, 0xfffffff821687812ULL, 0x000fe200078ee216ULL,
0x00000010181c7824ULL, 0x040fe200078e00ffULL, 0x00000010181a7812ULL, 0x042fe200078efcffULL,
0x0000001018247824ULL, 0x000fc400078e00ffULL, 0x00000010686c7836ULL, 0x000fe20000000000ULL,
0x0000001a1d1b7210ULL, 0x000fe20007ffe0ffULL, 0x0000002068767836ULL, 0x000fe20000000000ULL,
0xfffffff01c1d7812ULL, 0x000fe200078ee219ULL, 0x0000003068747836ULL, 0x000fe20000000000ULL,
0x000000041a1e7819ULL, 0x000fe200000006ffULL, 0x000000011f757824ULL, 0x000fe200078e0268ULL,
0x0000000a1d587211ULL, 0x080fe200078e20ffULL, 0x00000008681c7824ULL, 0x000fe200078e00ffULL,
0xfffffff01e1d7812ULL, 0x000fe200078ee21bULL, 0x000000011f1e7824ULL, 0x040fe200078e026cULL,
0x0000000374227819ULL, 0x000fe200000006ffULL, 0x000000011f207824ULL, 0x000fe200078e0276ULL,
0x0000000a1d8c7211ULL, 0x080fe200078e20ffULL, 0x000000086c1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee275ULL, 0x0000000876257824ULL, 0x000fe200078e00ffULL,
0x000000005858783bULL, 0x000fe20000000200ULL, 0x000000011f1f7824ULL, 0x000fe200078e0274ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee21eULL, 0x000000101c507824ULL, 0x100fe200078e0215ULL,
0xfffffff8251e7812ULL, 0x000fe200078ee220ULL, 0x0000000219217836ULL, 0x000fe20000000000ULL,
0xfffffff8221f7812ULL, 0x000fe200078ee21fULL, 0x000000101a257824ULL, 0x000fe200078e00ffULL,
0x000000151d547211ULL, 0x080fe200078e20ffULL, 0x000000101e647824ULL, 0x100fe200078e0215ULL,
0x000000151f5c7211ULL, 0x000fe200078e20ffULL, 0x000000005050783bULL, 0x000e620000000200ULL,
0xfffffff024237812ULL, 0x000fe200078ee221ULL, 0x000000021b207836ULL, 0x000fe20000000000ULL,
0x00000003747f7819ULL, 0x000fe200000006ffULL, 0x000000005454783bULL, 0x000ee20000000200ULL,
0x0000000868247824ULL, 0x000fe200078e00ffULL, 0x0000000a23447211ULL, 0x000fe200078e20ffULL,
0x0000000275217836ULL, 0x000fe20000000000ULL, 0x000000006464783bULL, 0x000f220000000200ULL,
0x0000001275227836ULL, 0x000fe20000000000ULL, 0xfffffff025257812ULL, 0x000fe200078ee220ULL,
0x000000086c277824ULL, 0x000fe200078e00ffULL, 0x000000005c5c783bULL, 0x000f620000000200ULL,
0xfffffff824207812ULL, 0x000fe200078ee221ULL, 0x0000003275237836ULL, 0x000fe20000000000ULL,
0x0000000374247819ULL, 0x000fe200000006ffULL, 0x000000008c8c783bULL, 0x000f220000000200ULL,
0xfffffff827217812ULL, 0x000fe200078ee222ULL, 0x0000002275227836ULL, 0x000fe20000000000ULL,
0xfffffff824237812ULL, 0x000fe200078ee223ULL, 0x0000000876277824ULL, 0x000fe200078e00ffULL,
0x000000004444783bULL, 0x000fe20000000200ULL, 0x00000010202c7824ULL, 0x100fe200078e0215ULL,
0x00000036759a7810ULL, 0x000fe20007ffe0ffULL, 0x00000010214c7824ULL, 0x100fe200078e0215ULL,
0xfffffff827227812ULL, 0x000fe200078ee222ULL, 0x0000001023887824ULL, 0x100fe200078e0215ULL,
0xfffffff87f9a7812ULL, 0x000fe200078ee29aULL, 0x0000001025847824ULL, 0x000fe200078e020aULL,
0x000000002c2c783bULL, 0x000f620000000200ULL, 0x0000001022607824ULL, 0x000fc400078e0215ULL,
0x0000003475967836ULL, 0x000fe20000000000ULL, 0x000000004c4c783bULL, 0x000f620000000200ULL,
0x0000001475957836ULL, 0x000fe40000000000ULL, 0x0000000475947836ULL, 0x000fe20000000000ULL,
0x000000006060783bULL, 0x000f620000000200ULL, 0x0000002475977836ULL, 0x000fe20000000000ULL,
0x000000505890723cULL, 0x002fe400000018ffULL, 0x000000008888783bULL, 0x000e620000000200ULL,
0x0000000675987836ULL, 0x000fc40000000000ULL, 0x000000086c787824ULL, 0x000fe200078e00ffULL,
0x000000008484783bULL, 0x000e620000000200ULL, 0x000000525828723cULL, 0x000fe200000018ffULL,
0x0000001018797824ULL, 0x000fe400078e00ffULL, 0x000000101a7b7824ULL, 0x000fe400078e00ffULL,
0x00000016759d7836ULL, 0x000fe20000000000ULL, 0x000000545830723cULL, 0x008fe200000018ffULL,
0x00000026759c7836ULL, 0x000fe40000000000ULL, 0x00000008767d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8789d7812ULL, 0x000fc400078ee29dULL, 0x000000565834723cULL, 0x000fe400000018ffULL,
0xfffffff87d9c7812ULL, 0x000fe200078ee29cULL, 0x000000109d807824ULL, 0x000fc600078e0215ULL,
0x000000645838723cULL, 0x010fe200000018ffULL, 0x000000109ca07824ULL, 0x000fe400078e0215ULL,
0x000000008080783bULL, 0x000fe60000000200ULL, 0x00000066583c723cULL, 0x000fec00000018ffULL,
0x0000005c5840723cULL, 0x020fec00000018ffULL, 0x0000005e5858723cULL, 0x000fec00000018ffULL,
0x000000548c48723cULL, 0x000fec00000018ffULL, 0x000000568c54723cULL, 0x000fec00000018ffULL,
0x000000508c24723cULL, 0x000fec00000018ffULL, 0x000000528c50723cULL, 0x000fec00000018ffULL,
0x0000002c4490723cULL, 0x000fec0000001890ULL, 0x0000002e4428723cULL, 0x000fec0000001828ULL,
0x0000004c4430723cULL, 0x000fec0000001830ULL, 0x0000004e4434723cULL, 0x000fec0000001834ULL,
0x000000604438723cULL, 0x000fec0000001838ULL, 0x00000062443c723cULL, 0x000fec000000183cULL,
0x000000884440723cULL, 0x002fec0000001840ULL, 0x0000008a4444723cULL, 0x000fec0000001858ULL,
0x0000004c8448723cULL, 0x000fe20000001848ULL, 0x000000101a5a7824ULL, 0x000fe200078e00ffULL,
0x0000000418597819ULL, 0x000fe200000006ffULL, 0x0000000619587836ULL, 0x000fc60000000000ULL,
0x0000005c8c70723cULL, 0x000fe200000018ffULL, 0x00000004194c7836ULL, 0x000fe20000000000ULL,
0xfffffff079797812ULL, 0x000fe200078ee258ULL, 0x000000041b4d7836ULL, 0x000fc60000000000ULL,
0xfffffff059597812ULL, 0x000fe200078ee24cULL, 0x0000002c8424723cULL, 0x000fe20000001824ULL,
0xfffffff05a5b7812ULL, 0x000fe400078ee24dULL, 0x00000003685d7819ULL, 0x000fc600000006ffULL,
0x0000004e844c723cULL, 0x000fe20000001854ULL, 0x000000105b5c7824ULL, 0x000fe200078e020aULL,
0xfffffff85d947812ULL, 0x000fc800078ee294ULL, 0x0000002e842c723cULL, 0x000fe20000001850ULL,
0x0000000374557819ULL, 0x000fe200000006ffULL, 0x000000086c547824ULL, 0x000fe200078e00ffULL,
0x0000000368577819ULL, 0x000fe200000006ffULL, 0x0000000876567824ULL, 0x000fe200078e00ffULL,
0xfffffff855967812ULL, 0x000fe200078ee296ULL, 0x000000648c50723cULL, 0x000fe200000018ffULL,
0xfffffff854957812ULL, 0x000fe200078ee295ULL, 0x000000061b747836ULL, 0x000fe20000000000ULL,
0x0000000a59547211ULL, 0x080fe200078e20ffULL, 0x00000010966d7824ULL, 0x100fe200078e0215ULL,
0xfffffff856977812ULL, 0x000fe200078ee297ULL, 0x000000668c64723cULL, 0x000fe200000018ffULL,
0xfffffff857987812ULL, 0x000fe200078ee298ULL, 0x0000001094587824ULL, 0x100fe200078e0215ULL,
0x000000005454783bULL, 0x000fe20000000200ULL, 0xfffffff07b757812ULL, 0x000fe200078ee274ULL,
0x0000001095777824ULL, 0x100fe200078e0215ULL, 0x0000005e8c8c723cULL, 0x000fe200000018ffULL,
0x000000006d6c783bULL, 0x000e620000000200ULL, 0x0000001597687211ULL, 0x000fe200078e20ffULL,
0x0000001079747824ULL, 0x000fe200078e020aULL, 0x0000000a757c7211ULL, 0x000fe200078e20ffULL,
0x000000005c5c783bULL, 0x000ee20000000200ULL, 0x000000888470723cULL, 0x000fe20000001870ULL,
0x0000001098787824ULL, 0x000fc400078e0215ULL, 0x000000005858783bULL, 0x000f260000000200ULL,
0x000000608450723cULL, 0x000fe20000001850ULL, 0x000000109a887824ULL, 0x000fe200078e0215ULL,
0x000000006868783bULL, 0x000fe80000000200ULL, 0x000000628460723cULL, 0x000fe20000001864ULL,
0x000000007c7c783bULL, 0x000fe80000000200ULL, 0x000000007764783bULL, 0x000f620000000200ULL,
0x0000008a8484723cULL, 0x000fe6000000188cULL, 0x000000007474783bULL, 0x000fe80000000200ULL,
0x000000008888783bULL, 0x000ea80000000200ULL, 0x000000007878783bULL, 0x000ea80000000200ULL,
0x00000000a08c783bULL, 0x000ea20000000200ULL, 0x0000006c5440723cULL, 0x002fec0000001840ULL,
0x0000006c5c70723cULL, 0x008fec0000001870ULL, 0x000000585490723cULL, 0x010fec0000001890ULL,
0x000000585c24723cULL, 0x000fec0000001824ULL, 0x0000005a5428723cULL, 0x000fec0000001828ULL,
0x0000005a5c2c723cULL, 0x000fec000000182cULL, 0x000000645430723cULL, 0x020fec0000001830ULL,
0x000000665434723cULL, 0x000fec0000001834ULL, 0x000000685438723cULL, 0x000fec0000001838ULL,
0x0000006a543c723cULL, 0x000fec000000183cULL, 0x0000006e5444723cULL, 0x000fec0000001844ULL,
0x000000645c48723cULL, 0x000fec0000001848ULL, 0x000000665c4c723cULL, 0x000fec000000184cULL,
0x000000685c50723cULL, 0x000fec0000001850ULL, 0x0000006a5c60723cULL, 0x000fec0000001860ULL,
0x0000006e5c84723cULL, 0x000fec0000001884ULL, 0x000000887440723cULL, 0x004fec0000001840ULL,
0x000000887c70723cULL, 0x000fec0000001870ULL, 0x000000787490723cULL, 0x000fe20000001890ULL,
0x0000000500897210ULL, 0x000fca0007ffe0ffULL, 0x0000000189557836ULL, 0x000fe20000000000ULL,
0x000000787c24723cULL, 0x000fe80000001824ULL, 0x0000000c5500720cULL, 0x000fe20003f06070ULL,
0x0000000704557224ULL, 0x000fe200078e02ffULL, 0x0000007a7428723cULL, 0x000fe60000001828ULL,
0x00000100559e7825ULL, 0x000fc600078e009eULL, 0x0000007a7c2c723cULL, 0x000fec000000182cULL,
0x000000807430723cULL, 0x000fec0000001830ULL, 0x000000827434723cULL, 0x000fec0000001834ULL,
0x0000008c7438723cULL, 0x000fec0000001838ULL, 0x0000008e743c723cULL, 0x000fec000000183cULL,
0x0000008a7444723cULL, 0x000fec0000001844ULL, 0x000000807c48723cULL, 0x000fec0000001848ULL,
0x000000827c4c723cULL, 0x000fec000000184cULL, 0x0000008c7c50723cULL, 0x000fec0000001850ULL,
0x0000008e7c60723cULL, 0x000fec0000001860ULL, 0x0000008a7c84723cULL, 0x000fe20000001884ULL,
0x0000000000007918ULL, 0x000fd00000000000ULL, 0x0000000c00148947ULL, 0x000fde0003800000ULL,
0x0000000117547824ULL, 0x000fe200078e0208ULL, 0x0000000417557810ULL, 0x000fe20007ffe0ffULL,
0x0000000817577836ULL, 0x000fe20000000000ULL, 0x00000018176d7810ULL, 0x000fe20007ffe0ffULL,
0x00000100895e7824ULL, 0x000fe200078e0206ULL, 0x0000000713767812ULL, 0x000fe200078ef854ULL,
0x0000000155547824ULL, 0x140fe200078e0208ULL, 0x00000003555b7819ULL, 0x000fe200000006ffULL,
0x0000000157567824ULL, 0x040fe200078e0208ULL, 0x0000005e09137248ULL, 0x000fe20007fe0000ULL,
0x00000008575d7824ULL, 0x000fe200078e00ffULL, 0xfffffff85b7a7812ULL, 0x000fe200078ee254ULL,
0x0000001417697836ULL, 0x000fe20000000000ULL, 0x0000002817817810ULL, 0x000fe20007ffe0ffULL,
0x0000000c17597836ULL, 0x000fe20000000000ULL, 0xfffffff85d7c7812ULL, 0x000fe200078ee256ULL,
0x00000010175b7836ULL, 0x000fe20000000000ULL, 0x0000000869547210ULL, 0x000fe20007ffe0ffULL,
0x00000008695d7824ULL, 0x000fe200078e00ffULL, 0x00000003595f7819ULL, 0x000fe200000006ffULL,
0x00000024177f7836ULL, 0x000fc40000000000ULL, 0x0000000159587824ULL, 0x000fe200078e0208ULL,
0xfffffff85d827812ULL, 0x000fe200078ee254ULL, 0x00000001135e7824ULL, 0x000fe200078e0a5eULL,
0x000000087f547210ULL, 0x000fe20007ffe0ffULL, 0x000000015b137824ULL, 0x140fe200078e0208ULL,
0xfffffff85f7e7812ULL, 0x000fe200078ee258ULL, 0x000000085b807824ULL, 0x000fe200078e00ffULL,
0x0000005e5500720cULL, 0x080fe20003f86070ULL, 0x00000020177d7836ULL, 0x000fe20000000000ULL,
0x0000005e5900720cULL, 0x080fe20003f26070ULL, 0x000000087f5d7824ULL, 0x000fe200078e00ffULL,
0xfffffff880807812ULL, 0x000fe200078ee213ULL, 0x0000001c176f7836ULL, 0x000fe20000000000ULL,
0x0000005e5700720cULL, 0x080fe20003f06070ULL, 0x000000016d567824ULL, 0x140fe200078e0208ULL,
0xfffffff85d8e7812ULL, 0x000fe200078ee254ULL, 0x000000086d5f7824ULL, 0x000fe200078e00ffULL,
0x000000086f587210ULL, 0x000fe20007ffe0ffULL, 0x000000017d137824ULL, 0x000fe200078e0208ULL,
0x0000005e5b00720cULL, 0x000fe20003f46070ULL, 0x000000087d8c7824ULL, 0x000fe200078e00ffULL,
0xfffffff85f887812ULL, 0x000fe200078ee256ULL, 0x000000086f657824ULL, 0x000fc400078e00ffULL,
0x000000010f547824ULL, 0x040fe200078e0217ULL, 0xfffffff88c8c7812ULL, 0x000fe200078ee213ULL,
0x0000002c17837836ULL, 0x000fe20000000000ULL, 0xfffffff8658a7812ULL, 0x000fe200078ee258ULL,
0x000000010f567824ULL, 0x000fe200078e0255ULL, 0x0000003817137810ULL, 0x000fe20007ffe0ffULL,
0x0000010054547825ULL, 0x000fe200078e00ffULL, 0x000000570f587210ULL, 0x000fe40007ffe0ffULL,
0x00000008836c7210ULL, 0x000fe20007ffe0ffULL, 0x0000000883657824ULL, 0x000fe200078e00ffULL,
0x0000001154797212ULL, 0x000fe200078efcffULL, 0x00000030178b7836ULL, 0x000fc40000000000ULL,
0x00000034178d7836ULL, 0x000fe20000000000ULL, 0xfffffff8656c7812ULL, 0x000fe200078ee26cULL,
0x000000010f5a7824ULL, 0x000fe200078e0259ULL, 0x000000799e787210ULL, 0x000fe20007f7e0ffULL,
0x0000000113687824ULL, 0x040fe200078e0208ULL, 0x000000088d667210ULL, 0x000fe20007ffe0ffULL,
0x0000000813677824ULL, 0x000fe400078e00ffULL, 0x0000010058587825ULL, 0x000fc600078e00ffULL,
0xfffffff867687812ULL, 0x000fe200078ee268ULL, 0x000000018b6e7824ULL, 0x040fe200078e0208ULL,
0x0000001158677212ULL, 0x000fe200078efcffULL, 0x000000088b5d7824ULL, 0x000fe400078e00ffULL,
0x000000088d657824ULL, 0x000fe400078e00ffULL, 0x000000010f747824ULL, 0x000fe200078e025bULL,
0xfffffff85d6e7812ULL, 0x000fe200078ee26eULL, 0x0000010056567825ULL, 0x000fe200078e00ffULL,
0xfffffff865667812ULL, 0x000fc600078ee266ULL, 0x000001005a5a7825ULL, 0x000fe200078e00ffULL,
0x00000011565d7212ULL, 0x000fc600078efcffULL, 0x00000001816a7824ULL, 0x040fe200078e0208ULL,
0x000000115a657212ULL, 0x080fe200078efcffULL, 0x00000008815f7824ULL, 0x000fe200078e00ffULL,
0x0000005d9e5c7210ULL, 0x000fe20007fbe0ffULL, 0x0000010074747825ULL, 0x000fe200078e00ffULL,
0x000000659e567210ULL, 0x000fe40007fde0ffULL, 0xfffffff85f6a7812ULL, 0x000fe200078ee26aULL,
0x000000019f797824ULL, 0x000fe200018e0655ULL, 0x000000679e547210ULL, 0x000fe20007f7e0ffULL,
0x000000010f587824ULL, 0x000fe200078e0269ULL, 0x0000001174657212ULL, 0x000fe200078efcffULL,
0x0000003c175f7836ULL, 0x000fe20000000000ULL, 0x000000579f5d7210ULL, 0x000fe20002ffe4ffULL,
0x000000019f557824ULL, 0x000fe200018e0659ULL, 0x0000005e6900720cULL, 0x080fe20003f66070ULL,
0x0000010058587825ULL, 0x000fe200078e00ffULL, 0x0000005e1700720cULL, 0x000fc40003fa6070ULL,
0x000000085f647210ULL, 0x000fe20007ffe0ffULL, 0x000000019f577824ULL, 0x000fe200030e065bULL,
0x000000659e5a7210ULL, 0x000fe20007fde0ffULL, 0x0000001076697824ULL, 0x000fe200078e0215ULL,
0x0000006d0f747210ULL, 0x000fe20007ffe0ffULL, 0x000000085f6b7824ULL, 0x000fe200078e00ffULL,
0x00000011587b7212ULL, 0x000fe200078efcffULL, 0x000000010f767824ULL, 0x000fe400078e026fULL,
0x000000019f5b7824ULL, 0x000fe200030e0675ULL, 0xfffffff86b647812ULL, 0x000fe200078ee264ULL,
0x0000010076767825ULL, 0x000fe200078e00ffULL, 0x000000157a6b7211ULL, 0x000fe200078e20ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000078697faeULL, 0x0003e2000e901c46ULL,
0x0000007b9e7a7210ULL, 0x000fe20007fde0ffULL, 0x0000010074747825ULL, 0x000fe200078e00ffULL,
0x0000001176657212ULL, 0x080fe200078efcffULL, 0x000000005c6b7faeULL, 0x0005e2000e101c46ULL,
0x0000005e6d00720cULL, 0x000fe20003fa6070ULL, 0x000000019f7b7824ULL, 0x000fe200030e0659ULL,
0x0000001174677212ULL, 0x000fc400078efcffULL, 0x000000659e587210ULL, 0x000fe20007fde0ffULL,
0x000000107c657824ULL, 0x100fe200078e0215ULL, 0x000000679e747210ULL, 0x000fe20007f9e0ffULL,
0x0000001080677824ULL, 0x100fe200078e0215ULL, 0x000000779f597210ULL, 0x000fe200037fe4ffULL,
0x0000001082697824ULL, 0x102fe200078e0215ULL, 0x0000000054657faeULL, 0x0003e2000c101c46ULL,
0x000000107e5d7824ULL, 0x004fe200078e0215ULL, 0x000000830f5c7210ULL, 0x000fe20007ffe0ffULL,
0x000000019f757824ULL, 0x000fe200020e0675ULL, 0x0000005e6f00720cULL, 0x080fe20003f86070ULL,
0x00000010886b7824ULL, 0x000fe200078e0215ULL, 0x00000000565d7faeULL, 0x0005e2000c901c46ULL,
0x0000005e8100720cULL, 0x080fe20003f06070ULL, 0x000000010f817824ULL, 0x000fe200078e0281ULL,
0x0000005e8300720cULL, 0x080fe20003f26070ULL, 0x000000005a677faeULL, 0x0007e2000d101c46ULL,
0x0000005e7d00720cULL, 0x000fc40003f46070ULL, 0x0000007d0f7d7210ULL, 0x000fe20007ffe0ffULL,
0x000000007a697faeULL, 0x000fe2000d901c46ULL, 0x0000005e7f00720cULL, 0x000fe20003f66070ULL,
0x000000010f7f7824ULL, 0x000fe400078e027fULL, 0x000001007d547825ULL, 0x002fe200078e00ffULL,
0x00000000746b7faeULL, 0x0003e6000e901c46ULL, 0x000001007f567825ULL, 0x004fe200078e00ffULL,
0x0000001154777212ULL, 0x000fc600078efcffULL, 0x000001005c5c7825ULL, 0x000fe200078e00ffULL,
0x0000001156797212ULL, 0x080fe400078efcffULL, 0x000000779e767210ULL, 0x000fe20007fde0ffULL,
0x000000010f547824ULL, 0x000fe200078e028bULL, 0x000000799e787210ULL, 0x000fe20007fbe0ffULL,
0x00000100815a7825ULL, 0x008fe200078e00ffULL, 0x000000115c657212ULL, 0x080fe400078efcffULL,
0x000000130f567210ULL, 0x000fe20007ffe0ffULL, 0x000000019f777824ULL, 0x000fe200030e0655ULL,
0x000000115a677212ULL, 0x000fe200078efcffULL, 0x0000010054547825ULL, 0x000fc600078e00ffULL,
0x000000679e5a7210ULL, 0x000fe20007fde0ffULL, 0x000000019f797824ULL, 0x000fe200028e0657ULL,
0x000000659e5c7210ULL, 0x000fe20007fbe0ffULL, 0x000000108a657824ULL, 0x000fe200078e0215ULL,
0x0000001154757212ULL, 0x002fe200078efcffULL, 0x000000010f547824ULL, 0x000fe200078e028dULL,
0x0000005b9f5b7210ULL, 0x000fe200037fe4ffULL, 0x000000019f5d7824ULL, 0x000fe200028e065dULL,
0x000000759e747210ULL, 0x000fe20007fbe0ffULL, 0x0000000058657faeULL, 0x0003e2000e101c46ULL,
0x0000010056567825ULL, 0x000fe200078e00ffULL, 0x0000005e8b00720cULL, 0x000fc40003fc6070ULL,
0x0000005e8d00720cULL, 0x000fe20003f86070ULL, 0x000000019f757824ULL, 0x000fe400028e0655ULL,
0x0000010054547825ULL, 0x000fc800078e00ffULL, 0x000000108c677824ULL, 0x100fe200078e0215ULL,
0x0000005f0f587210ULL, 0x002fe20007ffe0ffULL, 0x000000108e697824ULL, 0x000fe200078e0215ULL,
0x0000001154597212ULL, 0x080fe400078efcffULL, 0x0000001156657212ULL, 0x080fe200078efcffULL,
0x0000000076677faeULL, 0x0003e2000d101c46ULL, 0x000000599e547210ULL, 0x000fe20007fbe0ffULL,
0x0000010058587825ULL, 0x000fe200078e00ffULL, 0x000000659e567210ULL, 0x000fe20007f5e0ffULL,
0x0000000078697faeULL, 0x0005e2000d901c46ULL, 0x0000005e1300720cULL, 0x080fe20003f66070ULL,
0x000000019f557824ULL, 0x040fe200028e0655ULL, 0x0000001158117212ULL, 0x000fe200078efcffULL,
0x000000019f577824ULL, 0x000fe200010e0657ULL, 0x0000005e5f00720cULL, 0x000fe20003fa6070ULL,
0x000000106a137824ULL, 0x100fe200078e0215ULL, 0x000000119e587210ULL, 0x000fe20007f5e0ffULL,
0x000000106e657824ULL, 0x100fe200078e0215ULL, 0x000000156c5f7211ULL, 0x080fe200078e20ffULL,
0x0000001066117824ULL, 0x100fe200078e0215ULL, 0x000000005a137faeULL, 0x0005e2000c101c46ULL,
0x0000001068677824ULL, 0x002fe200078e0215ULL, 0x0000001564157211ULL, 0x000fe200078e20ffULL,
0x000000019f597824ULL, 0x000fe200010e0659ULL, 0x000000005c5f7faeULL, 0x0005e8000c901c46ULL,
0x0000000074657faeULL, 0x0005e8000f101c46ULL, 0x0000000054117faeULL, 0x0005e8000e101c46ULL,
0x0000000056677faeULL, 0x0005e8000d901c46ULL, 0x0000000058157faeULL, 0x0005e2000e901c46ULL,
0x0000000800c47947ULL, 0x000fea0003800000ULL, 0x0000000417577836ULL, 0x000fe20000000000ULL,
0x00000010175d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000117547824ULL, 0x100fe200078e0208ULL,
0x0000002017697810ULL, 0x000fe20007ffe0ffULL, 0x0000000857587824ULL, 0x000fe200078e00ffULL,
0x0000000857557210ULL, 0x000fe20007ffe0ffULL, 0x0000000817597836ULL, 0x000fe20000000000ULL,
0x0000000713567812ULL, 0x000fe200078ef854ULL, 0x0000000c175b7836ULL, 0x000fe20000000000ULL,
0xfffffff858587812ULL, 0x000fe200078ee255ULL, 0x00000008595a7824ULL, 0x000fe200078e00ffULL,
0x0000000859137210ULL, 0x000fe20007ffe0ffULL, 0x000000015b547824ULL, 0x140fe200078e0208ULL,
0x0000003017757810ULL, 0x000fe20007ffe0ffULL, 0x000000085b557824ULL, 0x000fe200078e00ffULL,
0xfffffff85a5a7812ULL, 0x000fe200078ee213ULL, 0x00000014175f7836ULL, 0x000fe20000000000ULL,
0x0000003c177b7810ULL, 0x000fe20007ffe0ffULL, 0x000000015d137824ULL, 0x140fe200078e0208ULL,
0xfffffff8555c7812ULL, 0x000fe200078ee254ULL, 0x000000085d5e7824ULL, 0x000fe200078e00ffULL,
0x000000085f547210ULL, 0x000fe20007ffe0ffULL, 0x000000085f557824ULL, 0x000fe200078e00ffULL,
0x000000037b7e7819ULL, 0x000fe200000006ffULL, 0x0000001817657836ULL, 0x000fe20000000000ULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee213ULL, 0x0000001c17687836ULL, 0x000fe20000000000ULL,
0xfffffff855647812ULL, 0x000fe200078ee254ULL, 0x0000000865667824ULL, 0x000fe200078e00ffULL,
0x0000000865137210ULL, 0x000fe20007ffe0ffULL, 0x0000000168547824ULL, 0x140fe200078e0208ULL,
0x000000650f657210ULL, 0x000fe20007ffe0ffULL, 0x0000000868557824ULL, 0x000fe200078e00ffULL,
0xfffffff866667812ULL, 0x000fe200078ee213ULL, 0x00000024176b7836ULL, 0x000fe20000000000ULL,
0x0000005b0f5b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000169137824ULL, 0x140fe200078e0208ULL,
0xfffffff8556a7812ULL, 0x000fe200078ee254ULL, 0x00000008696c7824ULL, 0x000fe200078e00ffULL,
0x000000086b547210ULL, 0x000fe20007ffe0ffULL, 0x000000086b557824ULL, 0x000fe200078e00ffULL,
0x00000015668f7211ULL, 0x080fe200078e20ffULL, 0x00000028176d7836ULL, 0x000fe20000000000ULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee213ULL, 0x0000002c176f7836ULL, 0x000fe20000000000ULL,
0xfffffff8556e7812ULL, 0x000fe200078ee254ULL, 0x000000086d747824ULL, 0x000fe200078e00ffULL,
0x000000086d137210ULL, 0x000fe20007ffe0ffULL, 0x000000016f547824ULL, 0x140fe200078e0208ULL,
0x000000680f667210ULL, 0x000fe20007ffe0ffULL, 0x000000086f557824ULL, 0x000fe200078e00ffULL,
0xfffffff874747812ULL, 0x000fe200078ee213ULL, 0x0000003417777836ULL, 0x000fe20000000000ULL,
0x0000006d0f6d7210ULL, 0x000fe20007ffe0ffULL, 0x0000000175137824ULL, 0x140fe200078e0208ULL,
0xfffffff855767812ULL, 0x000fe200078ee254ULL, 0x0000000875787824ULL, 0x000fe200078e00ffULL,
0x0000000877557210ULL, 0x000fe20007ffe0ffULL, 0x00000008777a7824ULL, 0x000fe200078e00ffULL,
0x000000155a817211ULL, 0x080fe200078e20ffULL, 0x0000003817797836ULL, 0x000fe20000000000ULL,
0xfffffff878787812ULL, 0x000fe200078ee213ULL, 0x000000010f547824ULL, 0x000fe200078e0217ULL,
0xfffffff87a7a7812ULL, 0x000fe200078ee255ULL, 0x0000000179137824ULL, 0x040fe200078e0208ULL,
0x0000001574a77211ULL, 0x000fe200078e20ffULL, 0x00000008797c7824ULL, 0x000fe200078e00ffULL,
0x000000770f777210ULL, 0x000fe20007ffe0ffULL, 0x0000010054547825ULL, 0x000fc600078e00ffULL,
0xfffffff87c7c7812ULL, 0x000fe200078ee213ULL, 0x000000010f577824ULL, 0x000fe200078e0257ULL,
0x0000001154137212ULL, 0x000fe200078efcffULL, 0x00000010567d7824ULL, 0x000fe200078e0215ULL,
0x000000157cb17211ULL, 0x000fe200078e20ffULL, 0x0000010057567825ULL, 0x000fe200078e00ffULL,
0x000000139e547210ULL, 0x000fc60007f1e0ffULL, 0x000000010f597824ULL, 0x000fe200078e0259ULL,
0x0000001156137212ULL, 0x000fe200078efcffULL, 0x00000010587f7824ULL, 0x000fe400078e0215ULL,
0x0000010059587825ULL, 0x000fe200078e00ffULL, 0x000000139e567210ULL, 0x000fc60007f3e0ffULL,
0x000000010f5f7824ULL, 0x040fe200078e025fULL, 0x0000001158137212ULL, 0x000fe200078efcffULL,
0x000000010f5d7824ULL, 0x000fe400078e025dULL, 0x000000105e8b7824ULL, 0x000fe400078e0215ULL,
0x000001005f5e7825ULL, 0x000fc800078e00ffULL, 0x000000017b677824ULL, 0x000fe400078e0208ULL,
0x000000105c837824ULL, 0x000fe400078e0215ULL, 0x000000019f557824ULL, 0x000fe200000e0655ULL,
0x000000139e587210ULL, 0x000fe20007f1e0ffULL, 0x000001005d5c7825ULL, 0x000fe200078e00ffULL,
0x000000115e137212ULL, 0x080fe400078efcffULL, 0xfffffff87e7e7812ULL, 0x000fe200078ee267ULL,
0x00000010648d7824ULL, 0x000fe200078e0215ULL, 0x000000115c677212ULL, 0x080fe200078efcffULL,
0x0000010065647825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000547d7faeULL, 0x0003e4000b901c46ULL, 0x000000679e5c7210ULL, 0x000fe20007f5e0ffULL,
0x000000019f597824ULL, 0x000fe200000e0659ULL, 0x000000139e5e7210ULL, 0x000fe20007f1e0ffULL,
0x0000010066667825ULL, 0x000fe200078e00ffULL, 0x0000001164137212ULL, 0x000fc600078efcffULL,
0x000000106ca37824ULL, 0x000fe400078e0215ULL, 0x000000019f5f7824ULL, 0x000fe200000e065fULL,
0x000000139e647210ULL, 0x000fe20007f1e0ffULL, 0x000000010f6b7824ULL, 0x000fe200078e026bULL,
0x0000001166137212ULL, 0x000fe200078efcffULL, 0x000001006d6c7825ULL, 0x000fc800078e00ffULL,
0x000000106aa17824ULL, 0x100fe400078e0215ULL, 0x000000106ea57824ULL, 0x000fe400078e0215ULL,
0x000001006b6a7825ULL, 0x000fc800078e00ffULL, 0x000000010f6e7824ULL, 0x000fe200078e026fULL,
0x000000116c6f7212ULL, 0x000fe200078efcffULL, 0x000001005b5a7825ULL, 0x000fc800078e00ffULL,
0x000000019f657824ULL, 0x000fe200000e0665ULL, 0x000000139e667210ULL, 0x000fe20007f1e0ffULL,
0x000000010f697824ULL, 0x000fe200078e0269ULL, 0x000000116a137212ULL, 0x000fe200078efcffULL,
0x000000019f5d7824ULL, 0x000fe200010e065dULL, 0x0000006f9e6c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001076a97824ULL, 0x100fe400078e0215ULL, 0x0000001078ab7824ULL, 0x100fe400078e0215ULL,
0x000000107aad7824ULL, 0x000fc400078e0215ULL, 0x000000107eb37824ULL, 0x000fe200078e0215ULL,
0x000000115a157212ULL, 0x000fe200078efcffULL, 0x000001006e6e7825ULL, 0x000fc800078e00ffULL,
0x0000010069687825ULL, 0x000fc800078e00ffULL, 0x000000019f677824ULL, 0x000fe200000e0667ULL,
0x000000139e6a7210ULL, 0x000fe20007f1e0ffULL, 0x000000010f757824ULL, 0x000fe200078e0275ULL,
0x000000116e137212ULL, 0x080fe200078efcffULL, 0x000000019f577824ULL, 0x000fe200008e0657ULL,
0x000000159e5a7210ULL, 0x000fe20007f3e0ffULL, 0x000000010f797824ULL, 0x040fe200078e0279ULL,
0x0000001168157212ULL, 0x000fe200078efcffULL, 0x000000010f7b7824ULL, 0x000fe200078e027bULL,
0x00000000567f7faeULL, 0x0003e2000b901c46ULL, 0x0000010075747825ULL, 0x000fc600078e00ffULL,
0x0000000058817faeULL, 0x0003e2000b901c46ULL, 0x0000010077767825ULL, 0x000fc800078e00ffULL,
0x0000010079787825ULL, 0x000fc800078e00ffULL, 0x000000019f6b7824ULL, 0x000fe200000e066bULL,
0x000000139e6e7210ULL, 0x000fe20007f1e0ffULL, 0x000001007b7a7825ULL, 0x000fe200078e00ffULL,
0x0000001174137212ULL, 0x080fe400078efcffULL, 0x0000001178af7212ULL, 0x080fe200078efcffULL,
0x000000019f5b7824ULL, 0x040fe200008e065bULL, 0x000000159e687210ULL, 0x000fe20007f3e0ffULL,
0x000000019f6f7824ULL, 0x040fe200000e066fULL, 0x0000001176157212ULL, 0x080fe200078efcffULL,
0x000000019f6d7824ULL, 0x000fe200010e066dULL, 0x000000117a117212ULL, 0x000fe200078efcffULL,
0x000000005a837faeULL, 0x0003e2000b901c46ULL, 0x000000699f697210ULL, 0x000fc40000ffe4ffULL,
0x000000139e747210ULL, 0x000fe20007f1e0ffULL, 0x000000005c8b7faeULL, 0x0003e2000b901c46ULL,
0x000000159e767210ULL, 0x000fe40007f3e0ffULL, 0x000000af9e787210ULL, 0x000fe20007f5e0ffULL,
0x000000005e8d7faeULL, 0x0003e2000b901c46ULL, 0x000000119e7a7210ULL, 0x000fe20007f7e0ffULL,
0x000000019f777824ULL, 0x040fe200008e0677ULL, 0x000000759f757210ULL, 0x000fe200007fe4ffULL,
0x00000000648f7faeULL, 0x0003e2000b901c46ULL, 0x000000019f797824ULL, 0x000fc400010e0679ULL,
0x000000019f7b7824ULL, 0x000fe200018e067bULL, 0x0000000066a17faeULL, 0x0003e8000b901c46ULL,
0x0000000068a37faeULL, 0x0003e8000b901c46ULL, 0x000000006aa57faeULL, 0x0003e8000b901c46ULL,
0x000000006ca77faeULL, 0x0003e8000b901c46ULL, 0x000000006ea97faeULL, 0x0003e8000b901c46ULL,
0x0000000074ab7faeULL, 0x0003e8000b901c46ULL, 0x0000000076ad7faeULL, 0x0003e8000b901c46ULL,
0x0000000078b17faeULL, 0x0003e8000b901c46ULL, 0x000000007ab37faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000001018547824ULL, 0x006fe200078e00ffULL,
0x0000000819117810ULL, 0x000fe20007ffe0ffULL, 0x000000081b137836ULL, 0x000fe20000000000ULL,
0x000000141f5c7211ULL, 0x080fe200078e20ffULL, 0x000000101a567824ULL, 0x000fe200078e00ffULL,
0xfffffff054117812ULL, 0x000fe200078ee211ULL, 0x000000101d687824ULL, 0x100fe200078e0214ULL,
0x000000141c547211ULL, 0x080fe200078e20ffULL, 0x000000101e647824ULL, 0x000fe200078e0214ULL,
0xfffffff056137812ULL, 0x000fe200078ee213ULL, 0x0000001011117824ULL, 0x000fe200078e020aULL,
0x0000001421807211ULL, 0x000fe200078e20ffULL, 0x0000000a19157836ULL, 0x000fc40000000000ULL,
0x0000001013137824ULL, 0x000fe400078e020aULL, 0x00000010186c7824ULL, 0x000fe400078e00ffULL,
0x00000010206d7824ULL, 0x100fe400078e0214ULL, 0x0000001022227824ULL, 0x100fe200078e0214ULL,
0xfffffff06c157812ULL, 0x000fe200078ee215ULL, 0x00000010237c7824ULL, 0x000fe200078e0214ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x000000005454783bULL, 0x000fe20000000200ULL,
0x0000000a1b6c7810ULL, 0x000fe20007ffe0ffULL, 0x0000001015157824ULL, 0x000fe400078e020aULL,
0x000000001158783bULL, 0x0002a80000000200ULL, 0x00000000131c783bULL, 0x0007280000000200ULL,
0x000000006868783bULL, 0x000f620000000200ULL, 0x000000101a117824ULL, 0x002fc600078e00ffULL,
0x000000006464783bULL, 0x000e620000000200ULL, 0x0000000c1b137810ULL, 0x008fe20007ffe0ffULL,
0x0000000e1b1b7836ULL, 0x000fe20000000000ULL, 0xfffffff011117812ULL, 0x000fe200078ee26cULL,
0x000000005c5c783bULL, 0x000ee80000000200ULL, 0x0000001011117824ULL, 0x000fe200078e020aULL,
0x000000006d6c783bULL, 0x000fe80000000200ULL, 0x000000001574783bULL, 0x000e680000000200ULL,
0x000000001178783bULL, 0x0004680000000200ULL, 0x000000008080783bULL, 0x000e680000000200ULL,
0x000000002220783bULL, 0x000ee20000000200ULL, 0x0000000c19117810ULL, 0x004fe20007ffe0ffULL,
0x0000000e19197836ULL, 0x000fe20000000000ULL, 0x000000545890723cULL, 0x000fe20000001890ULL,
0x000000007c7c783bULL, 0x000eaa0000000200ULL, 0x000000565828723cULL, 0x000fec0000001828ULL,
0x000000541c24723cULL, 0x010fec0000001824ULL, 0x000000561c2c723cULL, 0x000fec000000182cULL,
0x000000681c48723cULL, 0x020fec0000001848ULL, 0x0000006a1c4c723cULL, 0x000fec000000184cULL,
0x000000641c50723cULL, 0x002fec0000001850ULL, 0x000000661c60723cULL, 0x000fec0000001860ULL,
0x0000005c1c70723cULL, 0x008fec0000001870ULL, 0x0000005e1c84723cULL, 0x000fec0000001884ULL,
0x000000685830723cULL, 0x000fe20000001830ULL, 0x00000010181c7824ULL, 0x000fc400078e00ffULL,
0x0000001018187824ULL, 0x000fc600078e00ffULL, 0x0000006a5834723cULL, 0x000fe20000001834ULL,
0xfffffff01c117812ULL, 0x000fe200078ee211ULL, 0x00000010941c7824ULL, 0x000fe200078e0214ULL,
0xfffffff018197812ULL, 0x000fe400078ee219ULL, 0x000000149d187211ULL, 0x080fe200078e20ffULL,
0x000000645838723cULL, 0x000fe20000001838ULL, 0x0000001011117824ULL, 0x000fe200078e020aULL,
0x000000001c1c783bULL, 0x000fe80000000200ULL, 0x00000066583c723cULL, 0x000fe2000000183cULL,
0x0000001097647824ULL, 0x000fe200078e0214ULL, 0x000000001154783bULL, 0x0003e80000000200ULL,
0x0000005c5840723cULL, 0x000fe20000001840ULL, 0x000000006464783bULL, 0x000fea0000000200ULL,
0x0000005e5844723cULL, 0x000fe20000001844ULL, 0x00000014965c7211ULL, 0x000fca00078e20ffULL,
0x0000006c7490723cULL, 0x000fe20000001890ULL, 0x000000101a587824ULL, 0x040fe200078e00ffULL,
0x000000005c5c783bULL, 0x000fe20000000200ULL, 0x000000101a1a7824ULL, 0x000fc600078e00ffULL,
0xfffffff058137812ULL, 0x000fe200078ee213ULL, 0x0000001095587824ULL, 0x000fe200078e0214ULL,
0x0000006e7428723cULL, 0x000fe20000001828ULL, 0xfffffff01a117812ULL, 0x002fe400078ee21bULL,
0x0000001013137824ULL, 0x100fe400078e020aULL, 0x000000005858783bULL, 0x000e620000000200ULL,
0x0000006c7824723cULL, 0x000fe20000001824ULL, 0x0000001011117824ULL, 0x000fca00078e020aULL,
0x0000006e782c723cULL, 0x000fe2000000182cULL, 0x00000000136c783bULL, 0x000eea0000000200ULL,
0x000000827434723cULL, 0x000fec0000001834ULL, 0x000000807430723cULL, 0x000fec0000001830ULL,
0x000000807848723cULL, 0x000fec0000001848ULL, 0x000000207868723cULL, 0x000fec0000001850ULL,
0x000000207438723cULL, 0x000fe20000001838ULL, 0x0000001019507824ULL, 0x000fc400078e020aULL,
0x000000001818783bULL, 0x000fe60000000200ULL, 0x00000082784c723cULL, 0x000fe2000000184cULL,
0x0000001498207211ULL, 0x000fe200078e20ffULL, 0x000000005050783bULL, 0x000f280000000200ULL,
0x00000022743c723cULL, 0x000fec000000183cULL, 0x0000007c7440723cULL, 0x004fec0000001840ULL,
0x0000007e7444723cULL, 0x000fec0000001844ULL, 0x000000227880723cULL, 0x000fe20000001860ULL,
0x000000109c747824ULL, 0x100fe200078e0214ULL, 0x000000002020783bULL, 0x000fe80000000200ULL,
0x0000007c788c723cULL, 0x000fe20000001870ULL, 0x000000109a607824ULL, 0x000fe200078e0214ULL,
0x000000001170783bULL, 0x000ea80000000200ULL, 0x0000007e7884723cULL, 0x000fe20000001884ULL,
0x000000007474783bULL, 0x000f680000000200ULL, 0x000000006060783bULL, 0x000ea20000000200ULL,
0x0000005a5434723cULL, 0x002fec0000001834ULL, 0x000000585430723cULL, 0x000fec0000001830ULL,
0x000000586c94723cULL, 0x008fec0000001848ULL, 0x0000001e5428723cULL, 0x000fec0000001828ULL,
0x000000645438723cULL, 0x000fec0000001838ULL, 0x0000005a6c4c723cULL, 0x000fec000000184cULL,
0x0000001c5490723cULL, 0x000fec0000001890ULL, 0x00000066543c723cULL, 0x000fec000000183cULL,
0x0000001c6c78723cULL, 0x000fec0000001824ULL, 0x000000646c68723cULL, 0x000fec0000001868ULL,
0x0000005c5440723cULL, 0x000fec0000001840ULL, 0x0000001e6c7c723cULL, 0x000fec000000182cULL,
0x000000666c80723cULL, 0x000fec0000001880ULL, 0x0000005c6c8c723cULL, 0x000fec000000188cULL,
0x0000005e5454723cULL, 0x000fec0000001844ULL, 0x0000005e6c84723cULL, 0x000fec0000001884ULL,
0x0000001a5024723cULL, 0x010fec0000001834ULL, 0x000000185044723cULL, 0x000fec0000001830ULL,
0x000000187034723cULL, 0x004fec0000001894ULL, 0x000000225048723cULL, 0x000fec0000001828ULL,
0x00000074501c723cULL, 0x020fe20000001838ULL, 0x3db504f324247820ULL, 0x000fe20000410000ULL,
0x3db504f325257820ULL, 0x000fe20000410000ULL, 0x3db504f326267820ULL, 0x000fe20000410000ULL,
0x3db504f327277820ULL, 0x000fc40000410000ULL, 0x0000001a7018723cULL, 0x000fe2000000184cULL,
0x3db504f344447820ULL, 0x000fe20000410000ULL, 0x3db504f345457820ULL, 0x000fc80000410000ULL,
0x000000205090723cULL, 0x000fe20000001890ULL, 0x00000001004e7802ULL, 0x000fe20000000f00ULL,
0x3db504f334347820ULL, 0x000fe20000410000ULL, 0x3db504f335357820ULL, 0x000fe20000410000ULL,
0x3db504f336367820ULL, 0x000fe20000410000ULL, 0x3db504f337377820ULL, 0x000fe20000410000ULL,
0x000000765028723cULL, 0x000fe2000000183cULL, 0x01e6884e994e79a7ULL, 0x000e62000850003fULL,
0x3db504f348487820ULL, 0x000fe20000410000ULL, 0x3db504f349497820ULL, 0x000fc60000410000ULL,
0x000000207030723cULL, 0x000fe20000001878ULL, 0x3db504f31c1c7820ULL, 0x000fe20000410000ULL,
0x3db504f31d1d7820ULL, 0x000fe20000410000ULL, 0x3db504f31e1e7820ULL, 0x000fe20000410000ULL,
0x3db504f31f1f7820ULL, 0x000fe40000410000ULL, 0x000000747038723cULL, 0x000fec0000001868ULL,
0x00000060502c723cULL, 0x000fe20000001840ULL, 0x3db504f3904d7820ULL, 0x000fe20000410000ULL,
0x3db504f3914c7820ULL, 0x000fe20000410000ULL, 0x3db504f392147820ULL, 0x000fe20000410000ULL,
0x3db504f393157820ULL, 0x000fc40000410000ULL, 0x000000227020723cULL, 0x000fe2000000187cULL,
0x3db504f347427820ULL, 0x000fe20000410000ULL, 0x3db504f34a417820ULL, 0x000fe20000410000ULL,
0x3db504f34b407820ULL, 0x000fe20000410000ULL, 0x3db504f346437820ULL, 0x000fe20000410000ULL,
0x3db504f328287820ULL, 0x000fe20000410000ULL, 0x000000767074723cULL, 0x000fe20000001880ULL,
0x3db504f330477820ULL, 0x000fe20000410000ULL, 0x3db504f329297820ULL, 0x000fe20000410000ULL,
0x3db504f32a2a7820ULL, 0x000fe20000410000ULL, 0x3db504f32b2b7820ULL, 0x000fe20000410000ULL,
0x3db504f331317820ULL, 0x000fe20000410000ULL, 0x00000060703c723cULL, 0x000fe2000000188cULL,
0x3db504f332327820ULL, 0x000fe20000410000ULL, 0x3db504f333337820ULL, 0x000fe20000410000ULL,
0x3db504f318307820ULL, 0x000fe20000410000ULL, 0x3db504f319467820ULL, 0x000fe20000410000ULL,
0x3db504f31a4a7820ULL, 0x000fe20000410000ULL, 0x000000625050723cULL, 0x000fe20000001854ULL,
0x3db504f32c2c7820ULL, 0x000fe20000410000ULL, 0x3db504f32d2d7820ULL, 0x000fe20000410000ULL,
0x3db504f32e2e7820ULL, 0x000fe20000410000ULL, 0x3db504f32f2f7820ULL, 0x000fe20000410000ULL,
0x3db504f31b4b7820ULL, 0x000fe20000410000ULL, 0x000000627070723cULL, 0x000fe20000001884ULL,
0x3db504f320207820ULL, 0x000fe20000410000ULL, 0x3db504f321217820ULL, 0x000fe20000410000ULL,
0x3db504f322227820ULL, 0x000fe20000410000ULL, 0x3db504f323237820ULL, 0x000fe20000410000ULL,
0x3db504f338387820ULL, 0x000fe20000410000ULL, 0x3db504f339397820ULL, 0x000fe20000410000ULL,
0x3db504f33a3a7820ULL, 0x000fe20000410000ULL, 0x3db504f33b3b7820ULL, 0x000fe20000410000ULL,
0x3db504f374747820ULL, 0x000fe20000410000ULL, 0x3db504f375757820ULL, 0x000fe20000410000ULL,
0x3db504f376767820ULL, 0x000fe20000410000ULL, 0x3db504f377777820ULL, 0x000fe20000410000ULL,
0x3db504f33c3c7820ULL, 0x000fe20000410000ULL, 0x3db504f33d3d7820ULL, 0x000fe20000410000ULL,
0x3db504f33e3e7820ULL, 0x000fe20000410000ULL, 0x3db504f33f3f7820ULL, 0x000fc40000410000ULL,
0x3db504f350507820ULL, 0x000fe20000410000ULL, 0x3db504f351517820ULL, 0x000fe20000410000ULL,
0x3db504f352527820ULL, 0x000fe20000410000ULL, 0x3db504f353537820ULL, 0x000fc60000410000ULL,
0x3db504f370707820ULL, 0x000fe20000410000ULL, 0x3db504f371717820ULL, 0x000fe20000410000ULL,
0x3db504f372727820ULL, 0x000fe20000410000ULL, 0x3db504f373737820ULL, 0x000fe20000410000ULL,
0x0000000000187805ULL, 0x000fe20000015200ULL, 0x01e6884f990075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff137224ULL, 0x000fce00078e00ffULL,
0x000000101300780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000001a7805ULL, 0x000fcc0000015200ULL, 0x0000001a181a7210ULL, 0x000fca0007f1e1ffULL,
0x000000011b1b7824ULL, 0x000fe200000e0e19ULL, 0x003d09001a00780cULL, 0x000fc80003f06070ULL,
0x000000ff1b00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c401a00780cULL, 0x000fc80003f06070ULL, 0x000000ff1b00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff117819ULL, 0x000fc8000001141bULL,
0x0000001a11117211ULL, 0x000fca00078110ffULL, 0x000000ffff1a7224ULL, 0x000fca00000e061bULL,
0x0000000211117819ULL, 0x000fc8000000121aULL, 0x000000110000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000113137810ULL, 0x000fce0007ffe0ffULL,
0x01e6884f990075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000408117824ULL, 0x000fe200078e00ffULL, 0x000000100500720cULL, 0x000fe20003f06070ULL,
0x0000008003187824ULL, 0x000fc600078e020aULL, 0xfffffff011117812ULL, 0x000fca00078ec0ffULL,
0x0000000118117824ULL, 0x000fca00078e0211ULL, 0x01e4000011187984ULL, 0x0002a20000000c00ULL,
0x0000001c00c08947ULL, 0x000fea0003800000ULL, 0x00000002084e7824ULL, 0x040fe200078e00ffULL,
0x0000001209057248ULL, 0x000fe20007fe0000ULL, 0x0000860000097ab9ULL, 0x000fe20000000800ULL,
0x0000000d084f7211ULL, 0x000fe200078ff0ffULL, 0x00008400000a7ab9ULL, 0x000fe20000000800ULL,
0x000000064e4e7812ULL, 0x000fe400078ec0ffULL, 0x0000000512057210ULL, 0x000fe20007ffe1ffULL,
0x000000084f577836ULL, 0x000fe20000000000ULL, 0x00008c00ff127b82ULL, 0x000ee20000000a00ULL,
0x000000084e567c36ULL, 0x000fe20008000000ULL, 0x00000009ff547c19ULL, 0x000fe2000801164fULL,
0x000000ffff877224ULL, 0x000fe200078e0a05ULL, 0x00000009ff577c19ULL, 0x000fe20008011657ULL,
0x000000104f587836ULL, 0x000fe20000000000ULL, 0x000000055600720cULL, 0x000fe20003f26070ULL,
0x000000184f4f7836ULL, 0x000fe20000000000ULL, 0x0000000554557c48ULL, 0x000fc4000bfe0000ULL,
0x0000000556567e46ULL, 0x000fe4000b800087ULL, 0x0000000a4e547c10ULL, 0x000fe2000fffe0ffULL,
0x0000000455847c24ULL, 0x000fe2000f8e02ffULL, 0x00000004ff567819ULL, 0x000fe40000011656ULL,
0x000000055400720cULL, 0x000fe40003f06070ULL, 0x00000005546f7e46ULL, 0x000fe4000b800087ULL,
0x0000000557577c48ULL, 0x000fc4000bfe0000ULL, 0x000000ff565d7207ULL, 0x000fe40000800000ULL,
0x000000ff6f6f7207ULL, 0x000fe20000000000ULL, 0x0000000457867c24ULL, 0x000fe2000f8e02ffULL,
0x00000009ff587c19ULL, 0x000fe40008011658ULL, 0x0000005d84577210ULL, 0x000fe40007ffe0ffULL,
0x000000846f597211ULL, 0x000fe400078fe0ffULL, 0x00000009ff557c19ULL, 0x000fe2000801164fULL,
0x0000000257567825ULL, 0x008fe200078e0012ULL, 0x00000005584f7c48ULL, 0x000fc4000bfe0000ULL,
0x0000000555557c48ULL, 0x000fe2000bfe0000ULL, 0x0000000259587825ULL, 0x000fe200078e0012ULL,
0x000000866f5b7211ULL, 0x000fe200078fe0ffULL, 0x0000000656567981ULL, 0x000724000c1e9500ULL,
0x000000044f887c24ULL, 0x000fe4000f8e02ffULL, 0x00000006584f7981ULL, 0x000f22000c1e9500ULL,
0x00000004558a7c24ULL, 0x000fe4000f8e02ffULL, 0x000000886f5f7211ULL, 0x000fe200078fe0ffULL,
0x000000015d637824ULL, 0x000fc400078e0286ULL, 0x000000015d657824ULL, 0x040fe200078e0288ULL,
0x000000104e667812ULL, 0x000fe200078efcffULL, 0x000000015d677824ULL, 0x000fe400078e028aULL,
0x0000000263627825ULL, 0x000fc800078e0012ULL, 0x0000000265647825ULL, 0x100fe200078e0012ULL,
0x00000008666a7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000662627981ULL, 0x000f64000c1e9500ULL,
0x000000025b5a7825ULL, 0x100fe200078e0012ULL, 0x0000008a6f617211ULL, 0x000fe200078fe0ffULL,
0x0000000664647981ULL, 0x000f64000c1e9500ULL, 0x000000025f5c7825ULL, 0x000fe400078e0012ULL,
0x000000065a557981ULL, 0x000768000c1e9500ULL, 0x000000065c577981ULL, 0x008ee2000c1e9500ULL,
0x0000000a66687c36ULL, 0x000fc40008000000ULL, 0x00000002615e7825ULL, 0x100fe200078e0012ULL,
0x000000056a5b7e46ULL, 0x002fe4000b800087ULL, 0x000000056a00720cULL, 0x080fe20003f26070ULL,
0x0000000267587825ULL, 0x000fe200078e0012ULL, 0x00000004ff5b7819ULL, 0x000fe2000001165bULL,
0x000000065e607981ULL, 0x0002e2000c1e9500ULL, 0x000000056800720cULL, 0x000fe40003f06070ULL,
0x00000005685a7e46ULL, 0x000fe2000b800087ULL, 0x0000000658617981ULL, 0x0002e6000c1e9500ULL,
0x000000ff5a7f7207ULL, 0x000fc40000000000ULL, 0x000000ff5b5f7207ULL, 0x002fe40000800000ULL,
0x000000867f5d7211ULL, 0x040fe400078fe0ffULL, 0x000000847f597211ULL, 0x004fe200078fe0ffULL,
0x00000001845b7824ULL, 0x000fe400078e025fULL, 0x000000015f797824ULL, 0x000fe200078e0286ULL,
0x000000204e7c7812ULL, 0x000fe200078efcffULL, 0x000000025b5a7825ULL, 0x000fc800078e0012ULL,
0x0000000279787825ULL, 0x100fe200078e0012ULL, 0x000000065a6e7981ULL, 0x0002a6000c1e9500ULL,
0x0000000259587825ULL, 0x100fe400078e0012ULL, 0x0000000678787981ULL, 0x000ea4000c1e9500ULL,
0x000000025d5c7825ULL, 0x000fe400078e0012ULL, 0x0000000658637981ULL, 0x0002a4000c1e9500ULL,
0x000000087c5a7c36ULL, 0x002fc40008000000ULL, 0x000000065c657981ULL, 0x000ea2000c1e9500ULL,
0x000000885f7b7210ULL, 0x000fe20007ffe0ffULL, 0x000000015f817824ULL, 0x000fe200078e028aULL,
0x000000887f677211ULL, 0x040fe200078fe0ffULL, 0x0000000a7c7e7c36ULL, 0x000fe20008000000ULL,
0x0000008a7f6b7211ULL, 0x000fe400078fe0ffULL, 0x000000055a597e46ULL, 0x000fe2000b800087ULL,
0x000000027b7a7825ULL, 0x100fe200078e0012ULL, 0x000000057e00720cULL, 0x080fe40003f06070ULL,
0x000000057e587e46ULL, 0x000fe2000b800087ULL, 0x0000000281807825ULL, 0x000fe200078e0012ULL,
0x000000055a00720cULL, 0x000fe20003f26070ULL, 0x000000067a7a7981ULL, 0x000ea2000c1e9500ULL,
0x00000004ff597819ULL, 0x000fe20000011659ULL, 0x00000002675e7825ULL, 0x000fc800078e0012ULL,
0x000000026b6a7825ULL, 0x000fe200078e0012ULL, 0x000000ff58857207ULL, 0x000fe20000000000ULL,
0x000000065e677981ULL, 0x000ea2000c1e9500ULL, 0x000000ff59597207ULL, 0x000fc60000800000ULL,
0x000000066a697981ULL, 0x0002a2000c1e9500ULL, 0x00000086856d7211ULL, 0x000fc600078fe0ffULL,
0x0000000680807981ULL, 0x0002a4000c1e9500ULL, 0x000000026d6c7825ULL, 0x000fc800078e0012ULL,
0x00000001596b7824ULL, 0x002fe200078e0286ULL, 0x00000084855b7211ULL, 0x000fe200078fe0ffULL,
0x000000066c7b7981ULL, 0x000ea4000c1e9500ULL, 0x000000026b6a7825ULL, 0x000fe200078e0012ULL,
0x0000005984837210ULL, 0x000fc80007ffe0ffULL, 0x000000066acc7981ULL, 0x000ea2000c1e9500ULL,
0x000000025b5a7825ULL, 0x000fe200078e0012ULL, 0x00000088855f7211ULL, 0x040fe400078fe0ffULL,
0x0000008a857d7211ULL, 0x000fe200078fe0ffULL, 0x00000001595d7824ULL, 0x040fe200078e0288ULL,
0x000000065a797981ULL, 0x0002a2000c1e9500ULL, 0x0000000159817824ULL, 0x000fe400078e028aULL,
0x0000000283827825ULL, 0x000fe200078e0012ULL, 0x000000304eb27812ULL, 0x000fc600078efcffULL,
0x000000025f5e7825ULL, 0x000fc800078e0012ULL, 0x000000027d587825ULL, 0x100fe200078e0012ULL,
0x0000000682827981ULL, 0x000ea6000c1e9500ULL, 0x000000025d5c7825ULL, 0x100fe200078e0012ULL,
0x000000065e7d7981ULL, 0x0002a6000c1e9500ULL, 0x00000002815a7825ULL, 0x002fe200078e0012ULL,
0x0000000658d47981ULL, 0x000ea2000c1e9500ULL, 0x00000008b26c7c10ULL, 0x000fc6000fffe0ffULL,
0x000000065cd07981ULL, 0x000ea2000c1e9500ULL, 0x0000000ab2b47c36ULL, 0x000fc60008000000ULL,
0x000000065a8f7981ULL, 0x0002a2000c1e9500ULL, 0x000000056c6d7e46ULL, 0x000fe4000b800087ULL,
0x000000056c00720cULL, 0x080fe40003f26070ULL, 0x00000005b400720cULL, 0x000fe40003f06070ULL,
0x00000005b45e7e46ULL, 0x000fe4000b800087ULL, 0x00000004ff6d7819ULL, 0x000fe4000001166dULL,
0x000000ff5e817207ULL, 0x000fc40000000000ULL, 0x000000ff6d837207ULL, 0x000fe40000800000ULL,
0x00000084816b7211ULL, 0x040fe400078fe0ffULL, 0x00000088815b7211ULL, 0x002fe200078fe0ffULL,
0x00000001846d7824ULL, 0x000fe200078e0283ULL, 0x00000088835f7210ULL, 0x000fe20007ffe0ffULL,
0x000000026b6a7825ULL, 0x000fc800078e0012ULL, 0x000000026d6c7825ULL, 0x100fe200078e0012ULL,
0x000000066ab67981ULL, 0x0002a6000c1e9500ULL, 0x000000025b5a7825ULL, 0x100fe200078e0012ULL,
0x000000066c877981ULL, 0x000ea6000c1e9500ULL, 0x000000025f5e7825ULL, 0x000fe200078e0012ULL,
0x000000065ad27981ULL, 0x000ea2000c1e9500ULL, 0x0000008681597211ULL, 0x000fc600078fe0ffULL,
0x000000065e8d7981ULL, 0x000ea2000c1e9500ULL, 0x00000001835d7824ULL, 0x000fe400078e0286ULL,
0x0000000259587825ULL, 0x000fc800078e0012ULL, 0x000000025d5c7825ULL, 0x000fe200078e0012ULL,
0x0000000658ce7981ULL, 0x000ea2000c1e9500ULL, 0x0000008a816b7211ULL, 0x002fc600078fe0ffULL,
0x000000065c8b7981ULL, 0x000ea2000c1e9500ULL, 0x0000000183837824ULL, 0x000fe400078e028aULL,
0x000000026b6a7825ULL, 0x000fc800078e0012ULL, 0x0000000283127825ULL, 0x000fe200078e0012ULL,
0x000000066ad67981ULL, 0x000ea8000c1e9500ULL, 0x0000000612917981ULL, 0x0002a2000c1e9500ULL,
0x00000001ffca7424ULL, 0x000fe200078e00ffULL, 0xfffffff06f127812ULL, 0x002fca00078ec0ffULL,
0x0000000105137824ULL, 0x000fe200078e0212ULL, 0x000000014e587812ULL, 0x000fc800078efcffULL,
0x8000001354127210ULL, 0x000fc80007ffe0ffULL, 0x00000012ca127219ULL, 0x000fe200000006ffULL,
0x0000000a585a7c36ULL, 0x000fe20008000000ULL, 0xfffffff07f5c7812ULL, 0x000fc600078ec0ffULL,
0x000000015a597824ULL, 0x000fe200078e0a13ULL, 0x000000084e6c7812ULL, 0x040fe400078efcffULL,
0x000000094e847812ULL, 0x000fe400078efcffULL, 0x0000005c055d7210ULL, 0x000fe40007ffe0ffULL,
0x00000059ca5c7219ULL, 0x000fe400000006ffULL, 0x0000000a6c5e7c10ULL, 0x000fe2000fffe0ffULL,
0x0000000a84867c36ULL, 0x000fe20008000000ULL, 0xfffffff0856a7812ULL, 0x000fc400078ec0ffULL,
0xfffffff081887812ULL, 0x000fe200078ec0ffULL, 0x000000015e5b7824ULL, 0x100fe400078e0a13ULL,
0x0000000186137824ULL, 0x000fe200078e0a13ULL, 0x000000114e8c7812ULL, 0x000fe200078efcffULL,
0x00000001055f7824ULL, 0x040fe200078e026aULL, 0x0000005bca6a7219ULL, 0x040fe200000006ffULL,
0x00000001057f7824ULL, 0x000fe200078e0288ULL, 0x00000013ca887219ULL, 0x000fe200000006ffULL,
0x0000000a8c8e7c36ULL, 0x000fe20008000000ULL, 0x000054104f4f7816ULL, 0x010fc80000000056ULL,
0x0000004f12ff7212ULL, 0x000fc800078ac0ffULL, 0x000000055400720cULL, 0x000fc80002fa1470ULL,
0x000000054e00720cULL, 0x000fe40002fa1070ULL, 0x0000004f5cff7212ULL, 0x000fe4000788c0ffULL,
0xff8000004d4d7808ULL, 0x000fe40002800000ULL, 0x0000541055557816ULL, 0x020fe40000000062ULL,
0x0000541057577816ULL, 0x008fe40000000064ULL, 0x0000005512ff7212ULL, 0x000fc4000784c0ffULL,
0x0000005712ff7212ULL, 0x000fe4000782c0ffULL, 0x000000555cff7212ULL, 0x000fe400078ac0ffULL,
0x000000055400720cULL, 0x0c0fe40001741470ULL, 0x000000055400720cULL, 0x080fe40000f21470ULL,
0x000000055a00720cULL, 0x0c0fe40002781470ULL, 0x000000055a00720cULL, 0x000fc40002fa1470ULL,
0x000000054e00720cULL, 0x0c0fe40001741070ULL, 0x000000054e00720cULL, 0x080fe40000f21070ULL,
0x000000055800720cULL, 0x0c0fe40002781070ULL, 0x000000055800720cULL, 0x000fe40002fa1070ULL,
0x0000541060617816ULL, 0x000fe40000000061ULL, 0xff80000014147808ULL, 0x000fc40001000000ULL,
0xff80000047477808ULL, 0x000fe40000800000ULL, 0xff8000004c4c7808ULL, 0x000fe40002000000ULL,
0xff80000015157808ULL, 0x000fe40002800000ULL, 0x0000004f6aff7212ULL, 0x000fe4000786c0ffULL,
0x0000006112ff7212ULL, 0x000fe4000780c0ffULL, 0x000000575cff7212ULL, 0x000fc4000784c0ffULL,
0x000000615cff7212ULL, 0x000fe4000782c0ffULL, 0x0000005588ff7212ULL, 0x000fe4000788c0ffULL,
0x000000576aff7212ULL, 0x000fe200078ac0ffULL, 0x0000000168137824ULL, 0x000fe200078e0a5dULL,
0x000000055400720cULL, 0x080fe40000701470ULL, 0x000000055a00720cULL, 0x0c0fe40001741470ULL,
0x000000055a00720cULL, 0x000fc40000f21470ULL, 0x000000055e00720cULL, 0x0c0fe40001f61470ULL,
0x000000055e00720cULL, 0x080fe40002fa1470ULL, 0x000000058600720cULL, 0x000fe40002781470ULL,
0x0000008e5d597210ULL, 0x000fe40007ffe1ffULL, 0x000000184e927812ULL, 0x040fe400078efcffULL,
0x000000194e987812ULL, 0x000fc400078efcffULL, 0x000000054e00720cULL, 0x080fe40000701070ULL,
0x000000055800720cULL, 0x0c0fe40001741070ULL, 0x000000055800720cULL, 0x080fe40000f21070ULL,
0x000000056c00720cULL, 0x0c0fe40001f61070ULL, 0x000000056c00720cULL, 0x080fe40002fa1070ULL,
0x000000058400720cULL, 0x000fc40002781070ULL, 0x00000013ca8a7219ULL, 0x040fe400000006ffULL,
0x00000059ca907219ULL, 0x000fe400000006ffULL, 0x0000541063637816ULL, 0x004fe4000000006eULL,
0x0000541065657816ULL, 0x000fe20000000078ULL, 0x0000000a92947c36ULL, 0x000fe20008000000ULL,
0x0000000a989a7c10ULL, 0x000fe4000fffe0ffULL, 0xff80000032327808ULL, 0x000fc40000000000ULL,
0xff80000031317808ULL, 0x000fe40001000000ULL, 0xff80000033337808ULL, 0x000fe40000800000ULL,
0xff80000048487808ULL, 0x000fe40001800000ULL, 0xff80000020207808ULL, 0x000fe40002800000ULL,
0xff80000040407808ULL, 0x000fe40002000000ULL, 0x000000556aff7212ULL, 0x000fc4000780c0ffULL,
0x0000005788ff7212ULL, 0x000fe4000784c0ffULL, 0x000000616aff7212ULL, 0x080fe4000782c0ffULL,
0x0000006188ff7212ULL, 0x000fe4000786c0ffULL, 0x0000006390ff7212ULL, 0x000fe400078ac0ffULL,
0x000000658aff7212ULL, 0x000fe2000788c0ffULL, 0x00000001945b7824ULL, 0x100fe200078e0a5dULL,
0x000000055e00720cULL, 0x080fe20000701470ULL, 0x000000019a5d7824ULL, 0x000fe200078e0a5dULL,
0x000000055e00720cULL, 0x000fc40000f21470ULL, 0x000000058600720cULL, 0x0c0fe40001741470ULL,
0x000000058600720cULL, 0x080fe40001f61470ULL, 0x000000056800720cULL, 0x080fe40002781470ULL,
0x000000058e00720cULL, 0x080fe40002fa1470ULL, 0x000000056c00720cULL, 0x0c0fe40000701070ULL,
0x000000056c00720cULL, 0x000fc40000f21070ULL, 0x000000058400720cULL, 0x0c0fe40001741070ULL,
0x000000058400720cULL, 0x080fe40001f61070ULL, 0x000000056600720cULL, 0x080fe40002781070ULL,
0x000000058c00720cULL, 0x000fe40002fa1070ULL, 0x0000005bca967219ULL, 0x040fe400000006ffULL,
0x0000005dca9c7219ULL, 0x000fc400000006ffULL, 0x0000541067677816ULL, 0x000fe4000000007aULL,
0x0000541069697816ULL, 0x000fe40000000080ULL, 0xff80000041417808ULL, 0x000fe40000000000ULL,
0xff80000022227808ULL, 0x000fe40000800000ULL, 0xff80000021217808ULL, 0x000fe40001000000ULL,
0xff80000023237808ULL, 0x000fc40001800000ULL, 0xff80000043437808ULL, 0x000fe40002000000ULL,
0xff80000045457808ULL, 0x000fe40002800000ULL, 0x000000638aff7212ULL, 0x080fe4000780c0ffULL,
0x0000006396ff7212ULL, 0x000fe4000782c0ffULL, 0x000000678aff7212ULL, 0x040fe4000784c0ffULL,
0x000000698aff7212ULL, 0x000fc4000786c0ffULL, 0x0000006790ff7212ULL, 0x000fe4000788c0ffULL,
0x000000659cff7212ULL, 0x000fe200078ac0ffULL, 0x000000017e6b7824ULL, 0x000fe200078e0a5fULL,
0x000000056800720cULL, 0x0c0fe40000701470ULL, 0x000000056800720cULL, 0x0c0fe40001741470ULL,
0x000000056800720cULL, 0x080fe40001f61470ULL, 0x000000058e00720cULL, 0x000fc40002781470ULL,
0x000000059400720cULL, 0x080fe40000f21470ULL, 0x000000059a00720cULL, 0x080fe40002fa1470ULL,
0x000000214ea07812ULL, 0x000fe400078efcffULL, 0x000000056600720cULL, 0x0c0fe40000701070ULL,
0x000000056600720cULL, 0x0c0fe40001741070ULL, 0x000000056600720cULL, 0x000fc40001f61070ULL,
0x000000058c00720cULL, 0x080fe40002781070ULL, 0x000000059200720cULL, 0x080fe40000f21070ULL,
0x000000059800720cULL, 0x000fe40002fa1070ULL, 0x0000006bca9e7219ULL, 0x000fe400000006ffULL,
0x000054107b7b7816ULL, 0x000fe200000000ccULL, 0x0000000aa0a27c36ULL, 0x000fe20008000000ULL,
0xff80000044447808ULL, 0x000fc40000000000ULL, 0xff80000034347808ULL, 0x000fe40001000000ULL,
0xff80000036367808ULL, 0x000fe40001800000ULL, 0xff80000035357808ULL, 0x000fe40002000000ULL,
0xff80000024247808ULL, 0x000fe40000800000ULL, 0xff80000027277808ULL, 0x000fe40002800000ULL,
0x0000006590ff7212ULL, 0x000fc4000780c0ffULL, 0x0000006990ff7212ULL, 0x000fe4000784c0ffULL,
0x0000006596ff7212ULL, 0x000fe4000786c0ffULL, 0x000000679cff7212ULL, 0x040fe4000788c0ffULL,
0x000000699cff7212ULL, 0x000fe4000782c0ffULL, 0x0000007b9eff7212ULL, 0x000fe400078ac0ffULL,
0x000000058e00720cULL, 0x000fc40000701470ULL, 0x000000058e00720cULL, 0x080fe40001741470ULL,
0x000000059400720cULL, 0x080fe40001f61470ULL, 0x000000059a00720cULL, 0x0c0fe40002781470ULL,
0x000000059a00720cULL, 0x080fe40000f21470ULL, 0x000000057e00720cULL, 0x000fe40002fa1470ULL,
0x000000a25f6d7210ULL, 0x000fc40007ffe1ffULL, 0x000000284ea67812ULL, 0x040fe400078efcffULL,
0x000000294eac7812ULL, 0x000fe400078efcffULL, 0x000000058c00720cULL, 0x0c0fe40000701070ULL,
0x000000058c00720cULL, 0x080fe40001741070ULL, 0x000000059200720cULL, 0x080fe40001f61070ULL,
0x000000059800720cULL, 0x000fc40002781070ULL, 0x000000059800720cULL, 0x080fe40000f21070ULL,
0x000000057c00720cULL, 0x000fe40002fa1070ULL, 0x0000006dcaa47219ULL, 0x000fe400000006ffULL,
0x0000541079797816ULL, 0x000fe40000000082ULL, 0x000054107d7d7816ULL, 0x000fe400000000d0ULL,
0x00005410d48f7816ULL, 0x000fe2000000008fULL, 0x0000000aa6a87c36ULL, 0x000fe20008000000ULL,
0xff80000042427808ULL, 0x000fe20000000000ULL, 0x0000000aacae7c36ULL, 0x000fe20008000000ULL,
0xff80000037377808ULL, 0x000fc40001000000ULL, 0xff80000026267808ULL, 0x000fe40001800000ULL,
0xff80000046467808ULL, 0x000fe40002000000ULL, 0xff8000004b4b7808ULL, 0x000fe40000800000ULL,
0xff8000001e1e7808ULL, 0x000fe40002800000ULL, 0x0000004f88ff7212ULL, 0x000fe400078cc0ffULL,
0x0000006796ff7212ULL, 0x000fc4000780c0ffULL, 0x0000006996ff7212ULL, 0x000fe4000784c0ffULL,
0x000000799eff7212ULL, 0x040fe4000786c0ffULL, 0x0000007d9eff7212ULL, 0x040fe4000788c0ffULL,
0x0000008f9eff7212ULL, 0x000fe4000782c0ffULL, 0x0000007da4ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001a86f7824ULL, 0x100fe200078e0a5fULL, 0x000000058600720cULL, 0x080fe200037c1470ULL,
0x00000001ae5f7824ULL, 0x000fe200078e0a5fULL, 0x000000059400720cULL, 0x000fc40000701470ULL,
0x000000059400720cULL, 0x080fe40001741470ULL, 0x000000057e00720cULL, 0x0c0fe40001f61470ULL,
0x000000057e00720cULL, 0x0c0fe40002781470ULL, 0x000000057e00720cULL, 0x080fe40000f21470ULL,
0x00000005a200720cULL, 0x080fe40002fa1470ULL, 0x000000058400720cULL, 0x000fc400037c1070ULL,
0x000000059200720cULL, 0x0c0fe40000701070ULL, 0x000000059200720cULL, 0x080fe40001741070ULL,
0x000000057c00720cULL, 0x0c0fe40001f61070ULL, 0x000000057c00720cULL, 0x0c0fe40002781070ULL,
0x000000057c00720cULL, 0x080fe40000f21070ULL, 0x00000005a000720cULL, 0x000fc40002fa1070ULL,
0x0000006fcaaa7219ULL, 0x040fe400000006ffULL, 0x0000005fcab07219ULL, 0x000fe400000006ffULL,
0xff80000049497808ULL, 0x000fe40003000000ULL, 0xff80000030307808ULL, 0x000fe40000000000ULL,
0xff8000004a4a7808ULL, 0x000fe40001000000ULL, 0xff8000001c1c7808ULL, 0x000fc40001800000ULL,
0xff80000038387808ULL, 0x000fe40002000000ULL, 0xff8000003a3a7808ULL, 0x000fe40000800000ULL,
0xff80000039397808ULL, 0x000fe40002800000ULL, 0x000000639cff7212ULL, 0x000fe400078cc0ffULL,
0x00000079a4ff7212ULL, 0x080fe4000780c0ffULL, 0x00000079aaff7212ULL, 0x000fc4000784c0ffULL,
0x0000007ba4ff7212ULL, 0x040fe4000786c0ffULL, 0x0000008fa4ff7212ULL, 0x000fe4000788c0ffULL,
0x0000007baaff7212ULL, 0x000fe4000782c0ffULL, 0x0000007db0ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b4817824ULL, 0x000fe200078e0a7fULL, 0x000000059a00720cULL, 0x080fe400037c1470ULL,
0x00000005a200720cULL, 0x000fc40000701470ULL, 0x00000005a200720cULL, 0x0c0fe40001f61470ULL,
0x00000005a200720cULL, 0x080fe40002781470ULL, 0x00000005a800720cULL, 0x0c0fe40001741470ULL,
0x00000005a800720cULL, 0x080fe40000f21470ULL, 0x00000005ae00720cULL, 0x000fe40002fa1470ULL,
0x000000384ec07812ULL, 0x000fc400078efcffULL, 0x000000314eba7812ULL, 0x040fe400078efcffULL,
0x000000394ec67812ULL, 0x000fe400078efcffULL, 0x000000059800720cULL, 0x080fe400037c1070ULL,
0x00000005a000720cULL, 0x0c0fe40000701070ULL, 0x00000005a000720cULL, 0x0c0fe40001f61070ULL,
0x00000005a000720cULL, 0x000fc40002781070ULL, 0x00000005a600720cULL, 0x0c0fe40001741070ULL,
0x00000005a600720cULL, 0x080fe40000f21070ULL, 0x00000005ac00720cULL, 0x000fe40002fa1070ULL,
0x00000081cab87219ULL, 0x000fe400000006ffULL, 0x00005410b6877816ULL, 0x000fe40000000087ULL,
0x00005410d28d7816ULL, 0x000fe2000000008dULL, 0x0000000ac0c27c36ULL, 0x000fe20008000000ULL,
0x0000000ababc7c10ULL, 0x000fe2000fffe0ffULL, 0x0000000ac6c87c36ULL, 0x000fe20008000000ULL,
0xff80000025257808ULL, 0x000fc40003000000ULL, 0xff8000001d1d7808ULL, 0x000fe40000000000ULL,
0xff8000001f1f7808ULL, 0x000fe40001800000ULL, 0xff8000003b3b7808ULL, 0x000fe40002000000ULL,
0xff80000028287808ULL, 0x000fe40001000000ULL, 0xff8000002a2a7808ULL, 0x000fe40000800000ULL,
0xff80000075757808ULL, 0x000fc40002800000ULL, 0x00000079b0ff7212ULL, 0x040fe400078cc0ffULL,
0x0000007bb0ff7212ULL, 0x000fe4000780c0ffULL, 0x0000007daaff7212ULL, 0x040fe4000786c0ffULL,
0x0000008faaff7212ULL, 0x080fe4000788c0ffULL, 0x0000008fb0ff7212ULL, 0x000fe4000784c0ffULL,
0x00000087b8ff7212ULL, 0x000fc4000782c0ffULL, 0x0000008db8ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c2857824ULL, 0x100fe200078e0a7fULL, 0x000000bc7f837210ULL, 0x000fe20007ffe1ffULL,
0x00000001c87f7824ULL, 0x000fe200078e0a7fULL, 0x00000005a800720cULL, 0x0c0fe40001f61470ULL,
0x00000005a800720cULL, 0x080fe40002781470ULL, 0x00000005ae00720cULL, 0x0c0fe400037c1470ULL,
0x00000005ae00720cULL, 0x000fc40000701470ULL, 0x00000005ae00720cULL, 0x080fe40001741470ULL,
0x00000005b400720cULL, 0x0c0fe40000f21470ULL, 0x00000005b400720cULL, 0x000fe40002fa1470ULL,
0x00000083cabe7219ULL, 0x040fe400000006ffULL, 0x00000085cac47219ULL, 0x000fe400000006ffULL,
0x00000005a600720cULL, 0x000fc40001f61070ULL, 0x00000005a600720cULL, 0x080fe40002781070ULL,
0x00000005ac00720cULL, 0x0c0fe400037c1070ULL, 0x00000005ac00720cULL, 0x0c0fe40000701070ULL,
0x00000005ac00720cULL, 0x080fe40001741070ULL, 0x00000005b200720cULL, 0x0c0fe40000f21070ULL,
0x00000005b200720cULL, 0x000fc40002fa1070ULL, 0x0000007fcaca7219ULL, 0x000fe400000006ffULL,
0x00005410ce8b7816ULL, 0x000fe4000000008bULL, 0xff80000074747808ULL, 0x000fe40001800000ULL,
0xff80000076767808ULL, 0x000fe40002000000ULL, 0xff80000029297808ULL, 0x000fe40003000000ULL,
0xff8000002b2b7808ULL, 0x000fc40000000000ULL, 0xff80000077777808ULL, 0x000fe40001000000ULL,
0xff8000002c2c7808ULL, 0x000fe40000800000ULL, 0xff8000003c3c7808ULL, 0x000fe40002800000ULL,
0x00000087beff7212ULL, 0x080fe4000786c0ffULL, 0x00000087c4ff7212ULL, 0x080fe4000788c0ffULL,
0x00000087caff7212ULL, 0x000fc400078cc0ffULL, 0x0000008bb8ff7212ULL, 0x080fe4000780c0ffULL,
0x0000008bbeff7212ULL, 0x080fe4000784c0ffULL, 0x0000008bc4ff7212ULL, 0x000fe4000782c0ffULL,
0x0000008dbeff7212ULL, 0x000fe400078ac0ffULL, 0x00000005b400720cULL, 0x080fe40000701470ULL,
0x00000005bc00720cULL, 0x000fc40001f61470ULL, 0x00000005bc00720cULL, 0x0c0fe40001741470ULL,
0x00000005bc00720cULL, 0x080fe40002fa1470ULL, 0x00000005c200720cULL, 0x080fe40002781470ULL,
0x00000005c800720cULL, 0x080fe400037c1470ULL, 0x00000005c200720cULL, 0x080fe40000f21470ULL,
0x00000005b200720cULL, 0x000fc40000701070ULL, 0x00000005ba00720cULL, 0x0c0fe40001f61070ULL,
0x00000005ba00720cULL, 0x0c0fe40001741070ULL, 0x00000005ba00720cULL, 0x080fe40002fa1070ULL,
0x00000005c000720cULL, 0x0c0fe40002781070ULL, 0x00000005c000720cULL, 0x080fe40000f21070ULL,
0x00000005c600720cULL, 0x000fc400037c1070ULL, 0x00005410d6917816ULL, 0x000fe40000000091ULL,
0xff8000002e2e7808ULL, 0x000fe40000000000ULL, 0xff8000002d2d7808ULL, 0x000fe40001800000ULL,
0xff8000002f2f7808ULL, 0x000fe40001000000ULL, 0xff8000003d3d7808ULL, 0x000fe40002800000ULL,
0xff80000050507808ULL, 0x000fc40002000000ULL, 0xff80000052527808ULL, 0x000fe40000800000ULL,
0xff80000051517808ULL, 0x000fe40003000000ULL, 0x0000008bcaff7212ULL, 0x000fe4000780c0ffULL,
0x0000008dc4ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008dcaff7212ULL, 0x000fe4000784c0ffULL,
0x00000091b8ff7212ULL, 0x000fc400078ac0ffULL, 0x00000091beff7212ULL, 0x080fe4000788c0ffULL,
0x00000091c4ff7212ULL, 0x080fe4000782c0ffULL, 0x00000091caff7212ULL, 0x000fe400078cc0ffULL,
0x00000005b400720cULL, 0x080fe40002fa1470ULL, 0x00000005bc00720cULL, 0x080fe40002781470ULL,
0x00000005c200720cULL, 0x000fc40001f61470ULL, 0x00000005c200720cULL, 0x080fe40000f21470ULL,
0x00000005c800720cULL, 0x0c0fe40000701470ULL, 0x00000005c800720cULL, 0x0c0fe40001741470ULL,
0x00000005c800720cULL, 0x080fe400037c1470ULL, 0x00000005b200720cULL, 0x080fe40002fa1070ULL,
0x00000005ba00720cULL, 0x000fc40002781070ULL, 0x00000005c600720cULL, 0x080fe40000701070ULL,
0x00000005c000720cULL, 0x0c0fe40001f61070ULL, 0x00000005c000720cULL, 0x080fe40000f21070ULL,
0x00000005c600720cULL, 0x0c0fe40001741070ULL, 0x00000005c600720cULL, 0x000fe400037c1070ULL,
0xff80000053537808ULL, 0x000fc40000000000ULL, 0xff80000070707808ULL, 0x000fe40001800000ULL,
0xff80000071717808ULL, 0x000fe40001000000ULL, 0xff8000003e3e7808ULL, 0x000fe40002800000ULL,
0xff8000003f3f7808ULL, 0x000fe40002000000ULL, 0xff80000072727808ULL, 0x000fe40000800000ULL,
0xff80000073737808ULL, 0x000fce0003000000ULL, 0x0000004d1800720bULL, 0x004fc80003f1e000ULL,
0x000000184d057208ULL, 0x000fc80004000000ULL, 0x0000004c0500720bULL, 0x000fc80003f1e000ULL,
0x000000054c057208ULL, 0x000fc80004000000ULL, 0x000000480500720bULL, 0x000fc80003f1e000ULL,
0x0000000548127208ULL, 0x000fc80004000000ULL, 0x000000491200720bULL, 0x000fc80003f1e000ULL,
0x0000001249057208ULL, 0x000fc80004000000ULL, 0x000000440500720bULL, 0x000fc80003f1e000ULL,
0x0000000544127208ULL, 0x000fc80004000000ULL, 0x000000451200720bULL, 0x000fc80003f1e000ULL,
0x0000001245057208ULL, 0x000fc80004000000ULL, 0x000000240500720bULL, 0x000fc80003f1e000ULL,
0x0000000524127208ULL, 0x000fc80004000000ULL, 0x000000251200720bULL, 0x000fc80003f1e000ULL,
0x0000001225057208ULL, 0x000fc80004000000ULL, 0x0000001c0500720bULL, 0x000fc80003f1e000ULL,
0x000000051c127208ULL, 0x000fc80004000000ULL, 0x0000001d1200720bULL, 0x000fc80003f1e000ULL,
0x000000121d057208ULL, 0x000fc80004000000ULL, 0x000000280500720bULL, 0x000fc80003f1e000ULL,
0x0000000528127208ULL, 0x000fc80004000000ULL, 0x000000291200720bULL, 0x000fc80003f1e000ULL,
0x0000001229057208ULL, 0x000fc80004000000ULL, 0x0000002c0500720bULL, 0x000fc80003f1e000ULL,
0x000000052c127208ULL, 0x000fc80004000000ULL, 0x0000002d1200720bULL, 0x000fc80003f1e000ULL,
0x000000122d057208ULL, 0x000fc80004000000ULL, 0x000000500500720bULL, 0x000fc80003f1e000ULL,
0x0000000550127208ULL, 0x000fe40004000000ULL, 0x000000141900720bULL, 0x000fe40003f1e000ULL,
0x000000511200720bULL, 0x000fc80003f3e000ULL, 0x0000001251137208ULL, 0x000fe40004800000ULL,
0x0000001914127208ULL, 0x000fc60004000000ULL, 0x0c401f0013187f89ULL, 0x000ea200000e0000ULL,
0x000000151200720bULL, 0x000fc80003f1e000ULL, 0x0000001215127208ULL, 0x000fc80004000000ULL,
0x000000411200720bULL, 0x000fc80003f1e000ULL, 0x0000001241057208ULL, 0x000fc80004000000ULL,
0x000000400500720bULL, 0x000fc80003f1e000ULL, 0x0000000540127208ULL, 0x000fe40004000000ULL,
0x000000181300720bULL, 0x004fe40003f3e000ULL, 0x000000431200720bULL, 0x000fe40003f1e000ULL,
0x0000001318197208ULL, 0x000fe40004800000ULL, 0x0000001243057208ULL, 0x000fc60004000000ULL,
0x0c201f0019187f89ULL, 0x000ea200000e0000ULL, 0x000000420500720bULL, 0x000fc80003f1e000ULL,
0x0000000542057208ULL, 0x000fc80004000000ULL, 0x000000260500720bULL, 0x000fc80003f1e000ULL,
0x0000000526127208ULL, 0x000fc80004000000ULL, 0x000000271200720bULL, 0x000fc80003f1e000ULL,
0x0000001227057208ULL, 0x000fe40004000000ULL, 0x000000181900720bULL, 0x004fe40003f3e000ULL,
0x0000001e0500720bULL, 0x000fe40003f1e000ULL, 0x0000001918187208ULL, 0x000fe40004800000ULL,
0x000000051e127208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b184e7820ULL, 0x000fe20000410000ULL,
0x0000001f1200720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b48487823ULL, 0x100fe2000001084eULL,
0x000000121f057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001084eULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe2000001084eULL, 0x00000048004f7308ULL, 0x0005e20000000800ULL,
0x0000002a0500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b49497823ULL, 0x100fe2000001084eULL,
0x3fb8aa3b44447823ULL, 0x100fe2000001084eULL, 0x3fb8aa3b45457823ULL, 0x100fe2000001084eULL,
0x000000052a127208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b4d4d7823ULL, 0x000fc4000001084eULL,
0x00000025005a7308ULL, 0x000fe20000000800ULL, 0x0000002b1200720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b24487823ULL, 0x004fc6000001084eULL, 0x000000122b057208ULL, 0x000fc60004000000ULL,
0x0000004c00547308ULL, 0x0005e20000000800ULL, 0x0000002e0500720bULL, 0x000fc80003f1e000ULL,
0x000000052e127208ULL, 0x000fc60004000000ULL, 0x0000004900567308ULL, 0x0007e20000000800ULL,
0x0000002f1200720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b514c7823ULL, 0x004fc6000001084eULL,
0x000000122f057208ULL, 0x000fc60004000000ULL, 0x0000004400557308ULL, 0x0005e20000000800ULL,
0x000000520500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b50497823ULL, 0x008fc6000001084eULL,
0x0000000552127208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b1c057823ULL, 0x100fe4000001084eULL,
0x0000004500587308ULL, 0x0007e20000000800ULL, 0x000000531200720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b28447823ULL, 0x004fc6000001084eULL, 0x0000001253197208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b1d127823ULL, 0x100fe2000001084eULL, 0x000000471a00720bULL, 0x000fe20003f1e000ULL,
0x0000004800577308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b29457823ULL, 0x008fe2000001084eULL,
0x0c401f0019247f89ULL, 0x000ee200000e0000ULL, 0x0000001a471a7208ULL, 0x000fc80004000000ULL,
0x000000311a00720bULL, 0x000fe20003f1e000ULL, 0x0000004d004d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2d487823ULL, 0x004fe4000001084eULL, 0x0000001a31137208ULL, 0x000fc80004000000ULL,
0x000000201300720bULL, 0x000fe20003f1e000ULL, 0x0000000500057308ULL, 0x000fe60000000800ULL,
0x00000013201a7208ULL, 0x000fc80004000000ULL, 0x000000211a00720bULL, 0x000fe20003f1e000ULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x000000241900720bULL, 0x008fe40003f3e000ULL,
0x0000001a21137208ULL, 0x000fe40004000000ULL, 0x0000001924247208ULL, 0x000fe40004800000ULL,
0x000000341300720bULL, 0x000fe20003f1e000ULL, 0x0000004400447308ULL, 0x000fe40000000800ULL,
0x0c201f0024257f89ULL, 0x000ea200000e0000ULL, 0x00000013341a7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b2c137823ULL, 0x000fc6000001084eULL, 0x000000351a00720bULL, 0x000fe20003f1e000ULL,
0x0000004500457308ULL, 0x000fe60000000800ULL, 0x0000001a35197208ULL, 0x000fc80004000000ULL,
0x000000301900720bULL, 0x000fe20003f1e000ULL, 0x0000004900497308ULL, 0x000fe60000000800ULL,
0x0000001930197208ULL, 0x000fc80004000000ULL, 0x000000461900720bULL, 0x000fe20003f1e000ULL,
0x0000004c004c7308ULL, 0x000fe20000000800ULL, 0x000000252400720bULL, 0x004fe40003f3e000ULL,
0x00000019461d7208ULL, 0x000fe40004000000ULL, 0x0000002425197208ULL, 0x000fe40004800000ULL,
0x000000381d00720bULL, 0x000fe20003f1e000ULL, 0x0000001300137308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b191c7820ULL, 0x000fe20000410000ULL, 0x0000001d381a7208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b14247823ULL, 0x100fe2000001081cULL, 0x000000391a00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b15257823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b41417823ULL, 0x100fe2000001081cULL, 0x0000001a391d7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b40407823ULL, 0x100fe2000001081cULL, 0x0000001e004e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001081cULL, 0x000000741d00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001081cULL, 0x0000001d74147208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b43437823ULL, 0x100fe2000001081cULL, 0x0000002400247308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b42427823ULL, 0x100fe2000001081cULL, 0x000000751400720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b1f1f7823ULL, 0x100fe2000001081cULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001081cULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001081cULL, 0x0000001475157208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b52527823ULL, 0x100fe2000001081cULL, 0x000000321b00720bULL, 0x000fe20003f1e000ULL,
0x00000025001d7308ULL, 0x000ea20000000800ULL, 0x0000003c1500720bULL, 0x000fe20003f3e000ULL,
0x3fb8aa3b531c7823ULL, 0x000fe2000001081cULL, 0x0000001b32147208ULL, 0x000fc40004000000ULL,
0x000000153c1a7208ULL, 0x000fe40004800000ULL, 0x000000331400720bULL, 0x000fe20003f1e000ULL,
0x0000004100417308ULL, 0x000fe20000000800ULL, 0x0000003d1a00720bULL, 0x000fe40003f3e000ULL,
0x0000001433157208ULL, 0x000fe40004000000ULL, 0x0000001a3d1b7208ULL, 0x000fe40004800000ULL,
0x000000221500720bULL, 0x000fe20003f1e000ULL, 0x0000004000407308ULL, 0x000ee20000000800ULL,
0x000000701b00720bULL, 0x000fc40003f3e000ULL, 0x0000001522147208ULL, 0x000fe40004000000ULL,
0x0000001b701a7208ULL, 0x000fe40004800000ULL, 0x000000231400720bULL, 0x000fe20003f1e000ULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x000000711a00720bULL, 0x000fe40003f3e000ULL,
0x0000001423157208ULL, 0x000fe40004000000ULL, 0x0000001a711a7208ULL, 0x000fc40004800000ULL,
0x000000361500720bULL, 0x000fe20003f1e000ULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x000000241d1d723eULL, 0x004fe200000000ffULL, 0x0c401f001a1b7f89ULL, 0x000ea200000e0000ULL,
0x0000001536147208ULL, 0x000fc80004000000ULL, 0x000000371400720bULL, 0x000fe20003f1e000ULL,
0x0000002e005b7308ULL, 0x000fe60000000800ULL, 0x0000001437157208ULL, 0x000fc80004000000ULL,
0x0000004a1500720bULL, 0x000fe20003f1e000ULL, 0x0000002f005c7308ULL, 0x000fe60000000800ULL,
0x000000154a147208ULL, 0x000fc80004000000ULL, 0x0000004b1400720bULL, 0x000fe20003f1e000ULL,
0x0000001f00517308ULL, 0x0007e20000000800ULL, 0x0000001b1a00720bULL, 0x004fe40003f3e000ULL,
0x000000144b157208ULL, 0x000fe40004000000ULL, 0x0000001a1b1a7208ULL, 0x000fe40004800000ULL,
0x0000003a1500720bULL, 0x000fe20003f1e000ULL, 0x0000001c00537308ULL, 0x0005e20000000800ULL,
0x00000041401f723eULL, 0x008fe200000000ffULL, 0x0c201f001a1b7f89ULL, 0x000ee200000e0000ULL,
0x000000153a147208ULL, 0x000fc80004000000ULL, 0x0000003b1400720bULL, 0x000fe20003f1e000ULL,
0x0000002a00507308ULL, 0x000fe20000000800ULL, 0x0000004d541c723eULL, 0x004fe400000000ffULL,
0x000000143b157208ULL, 0x000fc80004000000ULL, 0x000000761500720bULL, 0x000fe20003f1e000ULL,
0x0000002b00597308ULL, 0x000fe60000000800ULL, 0x0000001576147208ULL, 0x000fc80004000000ULL,
0x000000771400720bULL, 0x000fe20003f1e000ULL, 0x0000004300437308ULL, 0x000fe20000000800ULL,
0x0000001b1a00720bULL, 0x008fe40003f3e000ULL, 0x0000001477157208ULL, 0x000fe40004000000ULL,
0x0000001a1b1a7208ULL, 0x000fe40004800000ULL, 0x0000003e1500720bULL, 0x000fe20003f1e000ULL,
0x0000004200427308ULL, 0x000ea40000000800ULL, 0x3fb8aa3b1a1e7820ULL, 0x000fe20000410000ULL,
0x000000153e147208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b38387823ULL, 0x100fe2000001081eULL,
0x0000003f1400720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b47477823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b46467823ULL, 0x100fe2000001081eULL, 0x00000038005d7308ULL, 0x000fe20000000800ULL,
0x000000143f157208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b21217823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b31317823ULL, 0x100fe2000001081eULL,
0x000000721500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b30307823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b34347823ULL, 0x100fe2000001081eULL, 0x0000002000257308ULL, 0x0007e20000000800ULL,
0x0000001572147208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b35357823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b39397823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b74747823ULL, 0x100fe2000001081eULL,
0x000000731400720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b75757823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe2000001081eULL, 0x00000021002e7308ULL, 0x0005e20000000800ULL,
0x0000001473147208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b70707823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b711e7823ULL, 0x000fe2000001081eULL,
0x000000555820723eULL, 0x008fe200000000ffULL, 0x0c401f0014157f89ULL, 0x000ee400000e0000ULL,
0x00000046002d7308ULL, 0x000fe20000000800ULL, 0x000000434221723eULL, 0x004fc400000000ffULL,
0xfffffff8ff427812ULL, 0x000fc800078ee216ULL, 0x00000010424d7810ULL, 0x000fe20007ffe0ffULL,
0x0000004700477308ULL, 0x000fe20000000800ULL, 0x0000001842547836ULL, 0x000fe40000000000ULL,
0x0000000842167824ULL, 0x000fca00078e00ffULL, 0x00000031002c7308ULL, 0x000ea20000000800ULL,
0x000000151400720bULL, 0x008fce0003f1e000ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x0000001415147208ULL, 0x000fe40004000000ULL, 0x3c003c0000157802ULL, 0x000fc60000000f00ULL,
0x0c201f00141b7f89ULL, 0x000ee400000e0000ULL, 0x0000001e005f7308ULL, 0x0009e20000000800ULL,
0x000000472c24723eULL, 0x004fce00000000ffULL, 0x0000003400347308ULL, 0x000fe20000000800ULL,
0x0000004f561e723eULL, 0x010fce00000000ffULL, 0x0000003500357308ULL, 0x000ea20000000800ULL,
0x0000001b1400720bULL, 0x008fce0003f1e000ULL, 0x00000039005e7308ULL, 0x000fe20000000800ULL,
0x000000141b1b7208ULL, 0x000fe20004000000ULL, 0x3c003c00ff147424ULL, 0x000fe200078e00ffULL,
0x0000000308ff7812ULL, 0x000fe4000780c0ffULL, 0x00000034352c723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b1b387820ULL, 0x000fe20000410000ULL, 0x0000000317357812ULL, 0x000fe200078ec0ffULL,
0x0000007400747308ULL, 0x000fe20000000800ULL, 0x000000141c28723cULL, 0x000fe200000018ffULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b37377823ULL, 0x100fe20000010838ULL,
0x0000003200327308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4a4a7823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b76767823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b77777823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b3b3b7823ULL, 0x000fe20000010838ULL, 0x0000000135357824ULL, 0x000fe200078e0208ULL,
0x0000003300337308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010838ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010838ULL, 0x3fb8aa3b72727823ULL, 0x100fe20000010838ULL,
0x0000000735357812ULL, 0x000fe200078ec0ffULL, 0x3fb8aa3b73737823ULL, 0x000fe20000010838ULL,
0x0000000408177810ULL, 0x000fc40007ffe017ULL, 0x00000022002f7308ULL, 0x0007e20000000800ULL,
0xfffffff816437812ULL, 0x000fce00078ee235ULL, 0x0000002300467308ULL, 0x0009620000000800ULL,
0x000000575a22723eULL, 0x008fce00000000ffULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x000000262723723eULL, 0x010fe400000000ffULL, 0x000000252e26723eULL, 0x000fe400000000ffULL,
0x000000323325723eULL, 0x004fe400000000ffULL, 0x0000002f4627723eULL, 0x022fe200000000ffULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x000000302d2e723eULL, 0x000fe200000000ffULL,
0x000000142028723cULL, 0x000fe20000001828ULL, 0x0000000842467836ULL, 0x000fc40000000000ULL,
0x0000000842427824ULL, 0x000fe400078e00ffULL, 0x0000000846347824ULL, 0x040fe200078e00ffULL,
0x000000142430723cULL, 0x000fe200000018ffULL, 0x0000004a004a7308ULL, 0x000fe20000000800ULL,
0x0000000846467824ULL, 0x000fe400078e00ffULL, 0xfffffff834477812ULL, 0x000fe400078ee235ULL,
0x000000051234723eULL, 0x000fe200000000ffULL, 0x0000100003057824ULL, 0x000fe200078e020aULL,
0x00000036372d723eULL, 0x002fe200000000ffULL, 0x0000004b004b7308ULL, 0x000e620000000800ULL,
0x000000084d367824ULL, 0x000fe200078e00ffULL, 0x000000505937723eULL, 0x000fe200000000ffULL,
0x000000ffff507224ULL, 0x000fe200078e001cULL, 0x000000034d127819ULL, 0x000fe200000006ffULL,
0x000000ffff1c7224ULL, 0x000fe200078e001dULL, 0xfffffff8364f7812ULL, 0x000fe200078ee235ULL,
0x000000ffff587224ULL, 0x000fe200078e0034ULL, 0x0000007500757308ULL, 0x000ea20000000800ULL,
0x000000444536723eULL, 0x000fc400000000ffULL, 0x0000000717457812ULL, 0x000fe400078ec0ffULL,
0x0000003600597202ULL, 0x000fe40000000f00ULL, 0x0000004a4b2f723eULL, 0x002fe200000000ffULL,
0x0000003a00407308ULL, 0x0003e20000000800ULL, 0x000000494c4a723eULL, 0x000fe400000000ffULL,
0x0000005b5c49723eULL, 0x000fe400000000ffULL, 0xfffffff846177812ULL, 0x000fe200078ee245ULL,
0x000000142c30723cULL, 0x000fe20000001830ULL, 0x000000ffff5b7224ULL, 0x000fe200078e004aULL,
0x0000003b00417308ULL, 0x0007220000000800ULL, 0x00000003543a7819ULL, 0x042fe200000006ffULL,
0x0000000854547824ULL, 0x000fe200078e00ffULL, 0x0000001f001d7202ULL, 0x000fe20000000f00ULL,
0x000000ffff1f7224ULL, 0x000fe200078e0023ULL, 0xfffffff83a557812ULL, 0x000fc400078ee235ULL,
0x0000004e5135723eULL, 0x000fe200000000ffULL, 0x0000007600767308ULL, 0x000fe20000000800ULL,
0x0000001e00517202ULL, 0x000fe20000000f00ULL, 0x000000ffff1e7224ULL, 0x000fe200078e0021ULL,
0x0000003700217202ULL, 0x000fc60000000f00ULL, 0x000000143438723cULL, 0x008fe40000001828ULL,
0x0000007700777308ULL, 0x000e6a0000000800ULL, 0x0000005d5e28723eULL, 0x000fe200000000ffULL,
0x000000ffff347224ULL, 0x000fe200078e0024ULL, 0x00000074752a723eULL, 0x004fe200000000ffULL,
0x0000003c003c7308ULL, 0x000fe20000000800ULL, 0x000000404129723eULL, 0x010fe200000000ffULL,
0x000000ffff367224ULL, 0x000fe200078e002cULL, 0xfffffff812417812ULL, 0x000fe200078ee245ULL,
0x0001200005127836ULL, 0x000fc40000000000ULL, 0x000000ffff377224ULL, 0x000fe200078e002eULL,
0x00000076772b723eULL, 0x002fe200000000ffULL, 0x0000003d003d7308ULL, 0x000e620000000800ULL,
0x0000001243437211ULL, 0x080fe200078e20ffULL, 0x0000001047477824ULL, 0x100fe200078e0212ULL,
0x0000001241417211ULL, 0x000fe200078e20ffULL, 0x0000001017177824ULL, 0x100fe400078e0212ULL,
0x000000142830723cULL, 0x000fe20000001830ULL, 0x000000104f4f7824ULL, 0x100fe200078e0212ULL,
0x0000004800487308ULL, 0x000ea20000000800ULL, 0x000000ffff247224ULL, 0x000fe200078e0025ULL,
0x0000002700257202ULL, 0x000fe20000000f00ULL, 0x0000001055557824ULL, 0x000fc400078e0212ULL,
0x000000ffff277224ULL, 0x000fe200078e002fULL, 0x0000003c3d3c723eULL, 0x002fe400000000ffULL,
0x0000005200527308ULL, 0x000e620000000800ULL, 0x00000001ff057424ULL, 0x000fe200078e00ffULL,
0x000000134848723eULL, 0x004fcc00000000ffULL, 0x0000003e00167308ULL, 0x000fe20000000800ULL,
0xfffffff842137812ULL, 0x000fe400078ee245ULL, 0xfffffff854457812ULL, 0x000fe200078ee245ULL,
0x000000ffff5a7224ULL, 0x000fe400078e0048ULL, 0x0000001013137824ULL, 0x000fe200078e0212ULL,
0x00000052534b723eULL, 0x002fe200000000ffULL, 0x0000003f003f7308ULL, 0x000e620000000800ULL,
0x000000ffff527224ULL, 0x000fe400078e0020ULL, 0x000000ffff537224ULL, 0x000fc400078e0022ULL,
0x000000ffff207224ULL, 0x000fe200078e0035ULL, 0x000000144838723cULL, 0x000fec0000001838ULL,
0x000000ffff227224ULL, 0x000fe200078e0049ULL, 0x0000007000707308ULL, 0x000ea20000000800ULL,
0x000000ffff237224ULL, 0x000fe200078e004bULL, 0x0000005043007844ULL, 0x000fe20000000200ULL,
0x0000002600357202ULL, 0x000fe20000000f00ULL, 0x000000ffff267224ULL, 0x000fe200078e002dULL,
0x0000002a00497202ULL, 0x000fe20000000f00ULL, 0x0000005813007844ULL, 0x000fe20000000200ULL,
0x000000163f3d723eULL, 0x002fe200000000ffULL, 0x0000007200727308ULL, 0x000fe20000000800ULL,
0x000000ffff487224ULL, 0x000fe200078e0028ULL, 0x0000001c47007844ULL, 0x000fe20000000200ULL,
0x000000ffff4a7224ULL, 0x000fc400078e003cULL, 0x0000001045457824ULL, 0x000fe200078e0212ULL,
0x0000002017007844ULL, 0x0003e20000000200ULL, 0x000000705f3e723eULL, 0x004fe200000000ffULL,
0x0000007300737308ULL, 0x000ea20000000800ULL, 0x000000ffff167224ULL, 0x000fe200078e003dULL,
0x000000344f007844ULL, 0x0007e40000000200ULL, 0x000000ffff4b7224ULL, 0x000fe400078e003eULL,
0x000000ffff397224ULL, 0x000fc600078e003aULL, 0x0000004841007844ULL, 0x0007e80000000200ULL,
0x0000002455007844ULL, 0x0007e20000000200ULL, 0x00000072733f723eULL, 0x004fca00000000ffULL,
0x000000ffff177224ULL, 0x002fe400078e003fULL, 0x000000143c30723cULL, 0x000fee0000001830ULL,
0x000000ffff147224ULL, 0x000fe200078e0029ULL, 0x0000002b00157202ULL, 0x000fca0000000f00ULL,
0x0000001445007844ULL, 0x0007e80000000200ULL, 0x01e0001811008388ULL, 0x0007ee0000000c00ULL,
0x00000030003a7202ULL, 0x000fe20000000f00ULL, 0x000000ffff3b7224ULL, 0x000fca00078e0032ULL,
0x01e2003811008388ULL, 0x0007e20000000c00ULL, 0x0000000c8900720cULL, 0x000fe20003f06070ULL,
0x01e608050eff79a7ULL, 0x000fe2000850003fULL, 0x01e610050eff79a7ULL, 0x000fe2000850003fULL,
0x01e618050eff79a7ULL, 0x000fe2000850003fULL, 0x01e620050eff79a7ULL, 0x0003e4000850003fULL,
0x000000ffff057224ULL, 0x002fce00078e0089ULL, 0xffffff7c00388947ULL, 0x008fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000085087810ULL, 0x000fe20007ffe0ffULL,
0x0000013000007945ULL, 0x000fe60003800000ULL, 0x7f800000080b7812ULL, 0x000fc800078ec0ffULL,
0x018000000b00780cULL, 0x000fda0003f05070ULL, 0x0000008500088308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0b00720cULL, 0x040fe40003f25070ULL,
0x008000000b00780cULL, 0x000fe40003f02070ULL, 0x00000001ff0b7807ULL, 0x000fe40000800000ULL,
0x00000001ff087807ULL, 0x004fc80004000000ULL, 0x000000080bff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff85ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff087807ULL, 0x000fc80000000000ULL, 0x000000080bff7212ULL, 0x000fe4000780c0ffULL,
0x80000000850b7812ULL, 0x000fd600078ec0ffULL, 0x008000000b080812ULL, 0x000fe200078efcffULL,
0x000000ffff088224ULL, 0x000fe200078e000bULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000008500087308ULL, 0x0004e40000001000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000ff0d7424ULL, 0x000fc800078e00ffULL, 0xfffffe780cc87950ULL, 0x000fea0003c3ffffULL,
0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000001ULL, 0x0000000800000001ULL, 0x0000000400000020ULL, 0x0000000100000008ULL,
0x0000000100000001ULL, 0x0000000400000003ULL, 0x0000000300000004ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x0000000000000447ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000005c8ULL, 0x00000000000001f8ULL, 0x0000001300000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000007c0ULL, 0x00000000000000d0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000890ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000008e4ULL, 0x0000000000000520ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e08ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e08ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000000e50ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000000e80ULL, 0x0000000000018580ULL, 0x0000001300000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019400ULL, 0x0000000000000038ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000019440ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000019440ULL, 0x0000000000000270ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000019a30ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000019a30ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000000e50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000000e80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000018580ULL,
0x0000000000018580ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000019400ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000019440ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000270ULL, 0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_0_m_32_sm_90_cubin_len = 105344;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
