/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000015540ULL, 0x00000000000151c0ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45326a4c497461ULL, 0x45346a4c4545326aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x5633494432796172ULL, 0x45346a4c6a496365ULL, 0x6a4c4532336a4c45ULL, 0x4c49746132454538ULL,
0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL,
0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x4545386a4c45386aULL,
0x4530624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x36316a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL, 0x735f616475635f5fULL,
0x5f7063725f30326dULL, 0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL, 0x695f5f2400687461ULL,
0x5f6c616e7265746eULL, 0x6475635f5f245f31ULL, 0x735f30376d735f61ULL, 0x5f636e79736c6668ULL,
0x2400705f796c6662ULL, 0x6e7265746e695f5fULL, 0x5f5f245f325f6c61ULL, 0x376d735f61647563ULL,
0x79736c6668735f30ULL, 0x705f7864695f636eULL, 0x65746e695f5f2400ULL, 0x245f335f6c616e72ULL,
0x735f616475635f5fULL, 0x65746f765f30376dULL, 0x6c61625f636e7973ULL, 0x6c65722e00746f6cULL,
0x6b2e747865742e61ULL, 0x686d5f6c656e7265ULL, 0x742e6c65722e0061ULL, 0x6e72656b2e747865ULL,
0x240061686d5f6c65ULL, 0x6d5f6c656e72656bULL, 0x426d656d73246168ULL, 0x2e00667542657479ULL,
0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL, 0x2e006d617261705fULL,
0x72665f6775626564ULL, 0x6c65722e00656d61ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL,
0x67756265642e616cULL, 0x2e00656d6172665fULL, 0x612e6c65722e766eULL, 0x0000006e6f697463ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x0000000000000018ULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000c000100000362ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000003a7ULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x000b0022000003edULL,
0x0000000000013950ULL, 0x0000000000000170ULL, 0x000b002200000420ULL, 0x0000000000013ac0ULL,
0x0000000000000040ULL, 0x000b00220000044bULL, 0x0000000000013b00ULL, 0x0000000000000050ULL,
0x000b002200000475ULL, 0x0000000000013b50ULL, 0x0000000000000130ULL, 0x000a0003000004e3ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0004000300000503ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0007000300000533ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000b101200000040ULL, 0x0000000000000000ULL, 0x0000000000013c80ULL, 0x00000024ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL,
0x0000002880808108ULL, 0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0001395000000000ULL, 0x0000040400000000ULL, 0x810c000001200400ULL, 0x004d240400288080ULL,
0x0000000000000000ULL, 0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080870828808081ULL, 0x8c08288080890828ULL,
0x2880809408288080ULL, 0x8097082880809608ULL, 0x1628808088082880ULL, 0x0000031028808280ULL,
0x8892000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL, 0x0000007000000000ULL,
0x0001395000000000ULL, 0x0000017000000000ULL, 0x0000000000000000ULL, 0x0000006cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080870828808081ULL, 0x8908288080880828ULL, 0x2880808c08288080ULL, 0x8093082880809208ULL,
0x0828808094082880ULL, 0x8080b10828808097ULL, 0x8016288080ae0828ULL, 0x0000000310288082ULL,
0x80ae920000000000ULL, 0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000010000000000ULL,
0x00013ac000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000064ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080870828808081ULL, 0x8908288080880828ULL, 0x2880808c08288080ULL, 0x8093082880809208ULL,
0x0828808094082880ULL, 0x8080970828808096ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880809792ULL, 0x0000002cffffffffULL, 0x000001a000000000ULL, 0x00013b0000000000ULL,
0x0000005000000000ULL, 0x0000100400000000ULL, 0x808c288080970900ULL, 0x0000000000002880ULL,
0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080870828808081ULL, 0x8908288080880828ULL, 0x2880808c08288080ULL,
0x8093082880809208ULL, 0x0828808094082880ULL, 0x8080960828808097ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880809692ULL, 0x0000002cffffffffULL, 0x0000024800000000ULL,
0x00013b5000000000ULL, 0x0000013000000000ULL, 0x0000180400000000ULL, 0x808c288080960900ULL,
0x0000000000002880ULL, 0x0000001800082f04ULL, 0x000823040000007fULL, 0x0000000000000014ULL,
0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001300082304ULL,
0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL, 0x0008230400000000ULL,
0x0000000000000012ULL, 0x0000001200081204ULL, 0x0008110400000000ULL, 0x0000000000000012ULL,
0x0000001100082304ULL, 0x0008120400000000ULL, 0x0000000000000011ULL, 0x0000001100081104ULL,
0x0008230400000000ULL, 0x0000000000000018ULL, 0x0000001800081204ULL, 0x0008110400000000ULL,
0x0000000000000018ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0050016000000015ULL,
0x000c170400501903ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL,
0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0000002000043104ULL,
0xffffffff01542904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000f001542804ULL,
0x0000033000000120ULL, 0x00002a8000001760ULL, 0x00002c4000002b30ULL, 0x00002fc000002db0ULL,
0x0000304000002ff0ULL, 0x0000376000003090ULL, 0x00004a60000049c0ULL, 0x00004ce000004b80ULL,
0x00004f2000004ef0ULL, 0x00004fc000004f70ULL, 0x00006620000053c0ULL, 0x000067f0000066c0ULL,
0x00006b6000006950ULL, 0x00006be000006b90ULL, 0x0000705000006c30ULL, 0x0000832000008280ULL,
0x000085a000008440ULL, 0x000087d0000087a0ULL, 0x0000887000008820ULL, 0x00008cf000008ce0ULL,
0x0000afd00000af90ULL, 0x0000b7d00000b790ULL, 0x000121d000012190ULL, 0x000121f0000121e0ULL,
0x0001226000012240ULL, 0x0001229000012280ULL, 0x00012f2000012ed0ULL, 0x00012fc000012f70ULL,
0x0001308000013020ULL, 0x00013120000130d0ULL, 0x000131c000013170ULL, 0x0001327000013220ULL,
0x00013310000132c0ULL, 0x000133a000013350ULL, 0x0001345000013400ULL, 0x000134f0000134a0ULL,
0x0001358000013530ULL, 0x00013630000135e0ULL, 0x000136e000013680ULL, 0x000137a000013740ULL,
0x0001386000013800ULL, 0x00013920000138c0ULL, 0x000001f002003904ULL, 0x00013600000000ffULL,
0x00000270003f0100ULL, 0x0001360800000009ULL, 0x00000310003f0120ULL, 0x0001368800000009ULL,
0x00000410003f0120ULL, 0x00013600000000ffULL, 0x000005c0003f0107ULL, 0x0001368c00000056ULL,
0x00000670003f0102ULL, 0x0001368800000056ULL, 0x00002780003f0101ULL, 0x0001360800000079ULL,
0x000027a0003f0101ULL, 0x0001360c00000079ULL, 0x00002970003f0105ULL, 0x0001360c00000079ULL,
0x00003700003f0105ULL, 0x0001368800000062ULL, 0x00004720003f0101ULL, 0x0001362800000079ULL,
0x00004740003f0101ULL, 0x0001362c00000079ULL, 0x00004910003f0105ULL, 0x0001362c00000079ULL,
0x00005370003f0105ULL, 0x0001369000000062ULL, 0x00006340003f0101ULL, 0x0001364800000079ULL,
0x000063a0003f0101ULL, 0x0001364c00000079ULL, 0x00006570003f0105ULL, 0x0001364c00000079ULL,
0x00006fe0003f0105ULL, 0x0001369800000062ULL, 0x00007fe0003f0101ULL, 0x0001366800000079ULL,
0x00008000003f0101ULL, 0x0001366c00000079ULL, 0x000081d0003f0105ULL, 0x0001366c00000079ULL,
0x00008b10003f0105ULL, 0x000136a000000062ULL, 0x0000c370003f0101ULL, 0x00013600000000ffULL,
0x0000d160003f0101ULL, 0x00013604000000ffULL, 0x0000d330003f0105ULL, 0x00013604000000ffULL,
0x00011590003f0105ULL, 0x0000000000000050ULL, 0x000116c0003f0101ULL, 0x0000000400000050ULL,
0x00011890003f0105ULL, 0x0000000400000050ULL, 0x00012d30003f0105ULL, 0x0001360800000000ULL,
0x00012d90003f0101ULL, 0x0001361000000000ULL, 0x00012df0003f0101ULL, 0x0001361800000000ULL,
0x00012e60003f0101ULL, 0x0001362000000000ULL, 0x00033803003f0101ULL, 0x0000c01000141c04ULL,
0x0000d3900000c280ULL, 0x00012ea00000d420ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x00000000000002ccULL, 0x0000001800000002ULL, 0x0000000000000224ULL, 0x0000001800000002ULL,
0x000000000000018cULL, 0x0000001800000002ULL, 0x00000000000000ecULL, 0x0000001800000002ULL,
0x0000000000000044ULL, 0x0000001800000002ULL, 0x00000000000002a8ULL, 0x0000001800000002ULL,
0x0000000000000200ULL, 0x0000001800000002ULL, 0x0000000000000165ULL, 0x0000001800000002ULL,
0x00000000000000c6ULL, 0x0000001800000002ULL, 0x0000000000013700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000097919ULL, 0x000e620000002100ULL,
0x0000000000117806ULL, 0x000fe200038e0000ULL, 0x00005800ff107624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000077919ULL, 0x000ea20000002300ULL,
0x0000001100067300ULL, 0x000ee200000e0000ULL, 0x0000000810057824ULL, 0x000fe200078e00ffULL,
0x00000000000479c3ULL, 0x000f220000002500ULL, 0x0000000000007919ULL, 0x000ea80000002200ULL,
0x00000000000c7919ULL, 0x000ee20000002600ULL, 0x0000001100137309ULL, 0x0002a60000000000ULL,
0x00000000000b7919ULL, 0x000ee80000000000ULL, 0x0000000000537919ULL, 0x000ee20000002700ULL,
0x00000005ff5c7819ULL, 0x002fcc0000011609ULL, 0x00001fff5c5c7589ULL, 0x000fe200000e0000ULL,
0x00000004ff5e7e24ULL, 0x010fe4000f8e00ffULL, 0x0000010007007a24ULL, 0x004fe400078e0200ULL,
0x00001fff07077589ULL, 0x000e6200000e0000ULL, 0x000000080c047824ULL, 0x008fe400078e00ffULL,
0x0000000000097a24ULL, 0x000fe400078e0209ULL, 0x0000000000007919ULL, 0x000ea20000000000ULL,
0x0000000b0600720cULL, 0x000fc40003f62070ULL, 0x000000ff0900720cULL, 0x000fe20003f05270ULL,
0x0000005305067224ULL, 0x000fe200078e0204ULL, 0x0000000f0900780cULL, 0x040fe40003f24070ULL,
0x0000007f0900780cULL, 0x000fd20003f44070ULL, 0x3fffff80ff028424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff038424ULL, 0x000fe400078e00ffULL, 0x0000000407087824ULL, 0x002fe400078e025cULL,
0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL, 0x01360002ff008388ULL, 0x0003e20000000a00ULL,
0x000000030900780cULL, 0x000fe20003f04070ULL, 0x0000000208087824ULL, 0x000fe200078e00ffULL,
0x00000004ff0d7819ULL, 0x004fe20000011600ULL, 0x7fffffc0ff059424ULL, 0x000fc400078e00ffULL,
0xff317217ff0ea424ULL, 0x000fe200078e00ffULL, 0x00000008080b7817ULL, 0x040fe20007800000ULL,
0x00000001080f7824ULL, 0x000fe200078e020dULL, 0x0136080409009388ULL, 0x0005e20000008a00ULL,
0x00000100ff037424ULL, 0x002fe400078e00ffULL, 0x0000000106027824ULL, 0x000fe200078e020fULL,
0x0134000e0900a388ULL, 0x000fe20000004800ULL, 0x000000010b067824ULL, 0x000fe400078e0a08ULL,
0x0000001000087824ULL, 0x000fc400078e00ffULL, 0x3fffff60ff0a8424ULL, 0x000fe400078e00ffULL,
0x7fffff60ff0b8424ULL, 0x000fe200078e00ffULL, 0x000000f008117812ULL, 0x000fe200078ec0ffULL,
0x00005c0002027625ULL, 0x000fc600078e0003ULL, 0x0136880a09008388ULL, 0x000fe20000008a00ULL,
0x000000010f057824ULL, 0x004fc600078e0200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000100f127824ULL, 0x000fe200078e00ffULL, 0x000000060d00720cULL, 0x000fe20003f06070ULL,
0x000000ffff0e7224ULL, 0x000fe200078e0a13ULL, 0x0000001102047210ULL, 0x000fe20007f3e0ffULL,
0x00000004ff067424ULL, 0x000fe200078e00ffULL, 0xfffffff012027812ULL, 0x000fc600078ee205ULL,
0x000000ffff057224ULL, 0x000fe400008e0603ULL, 0x00000010020d7824ULL, 0x000fe400078e00ffULL,
0x0000620053027625ULL, 0x000fc600078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e8000c101c46ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0136040effff338cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01360000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000006025a7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0700720cULL, 0x000fc40003f05270ULL, 0x0000003f5a5b7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff5a597810ULL, 0x000fe40007ffe0ffULL, 0x00000006ff5b7819ULL, 0x000fe4000001165bULL,
0x00000008ff597819ULL, 0x000fca0000011659ULL, 0x0000bd9000008947ULL, 0x000fea0003800000ULL,
0x00000002ff557819ULL, 0x000fe2000001165cULL, 0x000000085c567824ULL, 0x000fe400078e00ffULL,
0x00000003ff077424ULL, 0x000fe200078e00ffULL, 0x03ffffff55037812ULL, 0x000fca00078ec0ffULL,
0x000000045e027824ULL, 0x000fca00078e0203ULL, 0x0000005b0200720cULL, 0x000fda0003f06070ULL,
0x0000000253038824ULL, 0x000fe400078e00ffULL, 0x00006400ff048624ULL, 0x002fc800078e00ffULL,
0x0000640003058624ULL, 0x000fe400078e0204ULL, 0xffffffffff037424ULL, 0x000fe400078e00ffULL,
0x0000000102058824ULL, 0x000fe200078e0205ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01368c0756ff738cULL, 0x0003e20000000000ULL, 0x0000600005048625ULL, 0x000fe200078e0006ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000604038981ULL, 0x000ea2000c1e1900ULL,
0x000000015e087810ULL, 0x000fe20007ffe0ffULL, 0x000000400c0b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff577819ULL, 0x000fe2000001165cULL, 0x0136880056ff7f8cULL, 0x0007e2000c80043fULL,
0x000000590800720cULL, 0x000fc40003f06070ULL, 0x000000015c587812ULL, 0x000fe200078ec0ffULL,
0x0000002057547824ULL, 0x000fc800078e00ffULL, 0x000001005e0a7824ULL, 0x000fca00078e0254ULL,
0x000000200b207812ULL, 0x000fe200078ef80aULL, 0x0000580003037a24ULL, 0x004fc800078e02ffULL,
0x0000004003247824ULL, 0x000fe200078e00ffULL, 0x0000073000008947ULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x00afe20000011600ULL, 0x0000000257197824ULL, 0x000fe200078e0258ULL,
0x0000000a5a037217ULL, 0x000fe40007800000ULL, 0x0000000407057810ULL, 0x040fe40007ffe0ffULL,
0x0000000807087810ULL, 0x000fe20007ffe0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a0aULL,
0x0000000c07157810ULL, 0x000fe20007ffe0ffULL, 0x0000000105047824ULL, 0x100fe200078e0200ULL,
0x00000010071c7810ULL, 0x000fe20007ffe0ffULL, 0x00000008050d7824ULL, 0x000fe200078e00ffULL,
0x0000002003037817ULL, 0x000fe20003800000ULL, 0x0000000108097824ULL, 0x040fe200078e0200ULL,
0x00000014071d7810ULL, 0x000fe20007ffe0ffULL, 0x00000008081a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d187812ULL, 0x000fe200078ee204ULL, 0x0000000120047824ULL, 0x040fe200078e0207ULL,
0x000000030500720cULL, 0x000fe20003f06070ULL, 0x0000000120057824ULL, 0x000fe200078e0205ULL,
0xfffffff81a1a7812ULL, 0x000fc400078ee209ULL, 0x0000000424097210ULL, 0x000fe20007f5e0ffULL,
0x0000000120047824ULL, 0x000fe200078e0215ULL, 0x000000030800720cULL, 0x000fe20003f26070ULL,
0x0000000120087824ULL, 0x000fe200078e0208ULL, 0x00000005240d7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0a7224ULL, 0x000fe200010e06ffULL, 0x00005e0009127a11ULL, 0x040fe400078440ffULL,
0x0000000424047210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff107224ULL, 0x000fe200018e06ffULL,
0x00005f0009137a11ULL, 0x000fc400010f440aULL, 0x0000000824097210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff057224ULL, 0x000fe200028e06ffULL, 0x00005e000d0e7a11ULL, 0x000fe400078440ffULL,
0x00005e00090c7a11ULL, 0x000fe200078640ffULL, 0x000000ffff0a7224ULL, 0x000fe200020e06ffULL,
0x00005e0004087a11ULL, 0x000fe400078840ffULL, 0x00005f000d0f7a11ULL, 0x000fe400010f4410ULL,
0x00005f00090d7a11ULL, 0x000fc400018f440aULL, 0x00005f0004097a11ULL, 0x000fe200020f4405ULL,
0x0000000120047824ULL, 0x040fe200078e021cULL, 0x00000018071e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000120057824ULL, 0x000fe200078e021dULL, 0x0000001c071f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000424147210ULL, 0x000fe20007f5e0ffULL, 0x00000001200a7824ULL, 0x000fe200078e021eULL,
0x0000000524117210ULL, 0x000fe20007fbe0ffULL, 0x0000000120107824ULL, 0x000fe200078e021fULL,
0x00005e0014047a11ULL, 0x000fe200078640ffULL, 0x000000ffff177224ULL, 0x000fe200010e06ffULL,
0x0000000a24227210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff0a7224ULL, 0x000fe200028e06ffULL,
0x0000001024207210ULL, 0x000fe20007f5e0ffULL, 0x0000000815247824ULL, 0x000fe200078e00ffULL,
0x00005f0014057a11ULL, 0x000fe200018f4417ULL, 0x0000000858177824ULL, 0x000fe200078e00ffULL,
0x000000030700720cULL, 0x040fe20003f66070ULL, 0x0000000107077824ULL, 0x000fe200078e0200ULL,
0x00005e0011107a11ULL, 0x000fe200078a40ffULL, 0x000000ffff237224ULL, 0x000fe200020e06ffULL,
0x0000b00019197811ULL, 0x000fe200078e68ffULL, 0x000000ffff217224ULL, 0x000fe200010e06ffULL,
0x0000000707077812ULL, 0x000fc400078ec0ffULL, 0x00005f0011117a11ULL, 0x000fe400028f440aULL,
0x0ffffff8070a7812ULL, 0x100fe400078ef800ULL, 0xfffffff817077812ULL, 0x100fe200078ee200ULL,
0x0000000115177824ULL, 0x000fe200078e0200ULL, 0x00005e0022167a11ULL, 0x000fe200078840ffULL,
0x000000100a1b7824ULL, 0x000fe200078e0219ULL, 0x00005e0020147a11ULL, 0x000fe200078a40ffULL,
0x0000001007127825ULL, 0x000fe200078e0012ULL, 0x000000031500720cULL, 0x000fc40003f46070ULL,
0xfffffff8240a7812ULL, 0x000fe200078ee217ULL, 0x00000010070e7825ULL, 0x000fe200078e000eULL,
0x00005f0022177a11ULL, 0x000fe200020f4423ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121b7faeULL, 0x0003e2000d901c46ULL, 0x00005f0020157a11ULL, 0x000fe200028f4421ULL,
0x000000081c207824ULL, 0x040fe200078e00ffULL, 0x000000031c00720cULL, 0x080fe20003f66070ULL,
0x000000081d217824ULL, 0x040fe200078e00ffULL, 0x000000031d00720cULL, 0x080fe20003f86070ULL,
0x000000081f227824ULL, 0x000fe200078e00ffULL, 0x000000031e00720cULL, 0x080fe20003fa6070ULL,
0x00000010070c7825ULL, 0x000fe200078e000cULL, 0x000000031f00720cULL, 0x000fc60003fc6070ULL,
0x000000011c037824ULL, 0x100fe400078e0200ULL, 0x000000011d1c7824ULL, 0x100fe400078e0200ULL,
0x000000011e1d7824ULL, 0x000fe200078e0200ULL, 0xfffffff820127812ULL, 0x002fe200078ee203ULL,
0x000000081e1e7824ULL, 0x000fe200078e00ffULL, 0xfffffff8211c7812ULL, 0x000fe200078ee21cULL,
0x000000011f137824ULL, 0x000fe400078e0200ULL, 0x0000001018037824ULL, 0x000fe200078e0219ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee21dULL, 0x000000100a1b7824ULL, 0x000fe200078e0219ULL,
0xfffffff822207812ULL, 0x000fe200078ee213ULL, 0x000000101a137824ULL, 0x000fe200078e0219ULL,
0x000000000e037faeULL, 0x0003e2000c101c46ULL, 0x0000001007087825ULL, 0x000fc600078e0008ULL,
0x000000000c137faeULL, 0x0003e2000c901c46ULL, 0x00000010121d7824ULL, 0x000fe400078e0219ULL,
0x0000001007047825ULL, 0x040fe200078e0004ULL, 0x00000000081b7faeULL, 0x0003e6000d101c46ULL,
0x000000101c1f7824ULL, 0x000fe200078e0219ULL, 0x00000000041d7faeULL, 0x0003e2000d901c46ULL,
0x0000001007107825ULL, 0x000fc800078e0010ULL, 0x000000101e217824ULL, 0x000fe200078e0219ULL,
0x00000000101f7faeULL, 0x0003e2000e101c46ULL, 0x0000001007167825ULL, 0x000fc800078e0016ULL,
0x0000001020197824ULL, 0x000fe200078e0219ULL, 0x0000000016217faeULL, 0x0003e2000e901c46ULL,
0x0000001007147825ULL, 0x000fca00078e0014ULL, 0x0000000014197faeULL, 0x0003e2000f101c46ULL,
0x0000066000007947ULL, 0x000fea0003800000ULL, 0x0000000400077811ULL, 0x00afe200078fe8ffULL,
0x0000000858257824ULL, 0x000fe200078e00ffULL, 0x0000000c000d7811ULL, 0x040fe400078fe8ffULL,
0x0000000800097811ULL, 0x040fe200078fe8ffULL, 0x0000000107037824ULL, 0x140fe200078e0200ULL,
0x0000001400117811ULL, 0x040fe200078fe8ffULL, 0x00000008070a7824ULL, 0x000fe200078e00ffULL,
0x0000001800137811ULL, 0x000fe200078fe8ffULL, 0x000000010d057824ULL, 0x100fe200078e0200ULL,
0xfffffff825257812ULL, 0x100fe200078ee200ULL, 0x000000080d0e7824ULL, 0x000fe200078e00ffULL,
0xfffffff80a0a7812ULL, 0x000fe200078ee203ULL, 0x0000000109047824ULL, 0x140fe200078e0200ULL,
0x0000002000037211ULL, 0x000fe200078fe8ffULL, 0x00000008090f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee205ULL, 0x0000000111057824ULL, 0x040fe200078e0200ULL,
0x0000000324157210ULL, 0x000fe20007f1e0ffULL, 0x0000000811127824ULL, 0x000fe200078e00ffULL,
0xfffffff80f0c7812ULL, 0x000fe200078ee204ULL, 0x0000000113087824ULL, 0x100fe200078e0200ULL,
0x00000010000f7811ULL, 0x000fe200078fe8ffULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x00005e0015047a11ULL, 0x000fe200078040ffULL, 0x0000000813177824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee205ULL, 0x000000010f037824ULL, 0x000fe200078e0200ULL,
0x00005f0015057a11ULL, 0x000fe200000f4416ULL, 0x000000080f107824ULL, 0x000fe200078e00ffULL,
0x0000001c00157811ULL, 0x000fe200078fe8ffULL, 0x0000000120077824ULL, 0x040fe200078e0207ULL,
0xfffffff817147812ULL, 0x000fe200078ee208ULL, 0x0000000120097824ULL, 0x000fe200078e0209ULL,
0xfffffff810107812ULL, 0x000fe200078ee203ULL, 0x0000000120087824ULL, 0x000fe200078e0215ULL,
0x0000000724197210ULL, 0x000fe20007fde0ffULL, 0x00000001200d7824ULL, 0x000fe200078e020dULL,
0x00000009241e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000257097824ULL, 0x000fe200078e0258ULL,
0x0000000000037211ULL, 0x000fe200078fe8ffULL, 0x00000001200f7824ULL, 0x000fe200078e020fULL,
0x0000000824177210ULL, 0x000fe20007f3e0ffULL, 0x0000000120117824ULL, 0x040fe200078e0211ULL,
0x0000000703037812ULL, 0x000fe200078ec0ffULL, 0x0000000120137824ULL, 0x000fe200078e0213ULL,
0x0000b00009237811ULL, 0x000fe200078e68ffULL, 0x0000000115077824ULL, 0x140fe200078e0200ULL,
0x0000000d24167210ULL, 0x000fe20007f9e0ffULL, 0x0000000815227824ULL, 0x000fe200078e00ffULL,
0x0ffffff803037812ULL, 0x000fe200078ef800ULL, 0x000000ffff207224ULL, 0x000fe200030e06ffULL,
0x00005e0019087a11ULL, 0x000fe200078c40ffULL, 0x000000100e1b7824ULL, 0x000fe200078e0223ULL,
0x00000011241a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200028e06ffULL,
0xfffffff8220d7812ULL, 0x000fe200078ee207ULL, 0x0000001003037824ULL, 0x100fe200078e0223ULL,
0x00005f0019097a11ULL, 0x000fe200030f4420ULL, 0x000000100c197824ULL, 0x100fe200078e0223ULL,
0x0000000f241c7210ULL, 0x000fe20007f7e0ffULL, 0x000000100a077824ULL, 0x100fe200078e0223ULL,
0x00005e001e0c7a11ULL, 0x000fe200078a40ffULL, 0x00000010101d7824ULL, 0x100fe200078e0223ULL,
0x0000001324187210ULL, 0x000fe20007f5e0ffULL, 0x00000010121f7824ULL, 0x000fc400078e0223ULL,
0x0000001014217824ULL, 0x100fe400078e0223ULL, 0x000000ffff0f7224ULL, 0x000fe200020e06ffULL,
0x00005e00160e7a11ULL, 0x000fe200078840ffULL, 0x000000100d237824ULL, 0x000fe200078e0223ULL,
0x00005f001e0d7a11ULL, 0x000fe200028f4411ULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x00005e001c107a11ULL, 0x000fe200078640ffULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0x00005e001a127a11ULL, 0x000fe200078040ffULL, 0x000000ffff157224ULL, 0x000fe200010e06ffULL,
0x00005f00160f7a11ULL, 0x000fe200020f440fULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e0018147a11ULL, 0x000fe200078440ffULL, 0x0000001025047825ULL, 0x000fe200078e0004ULL,
0x00005e0017167a11ULL, 0x000fc400078240ffULL, 0x00005f001c117a11ULL, 0x000fe200018f4411ULL,
0x0000001025087825ULL, 0x040fe200078e0008ULL, 0x00005f001a137a11ULL, 0x000fe200000f4413ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e2000b901c46ULL,
0x00005f0018157a11ULL, 0x000fe200010f4415ULL, 0x00000010250c7825ULL, 0x000fe200078e000cULL,
0x00005f0017177a11ULL, 0x000fe200008f440aULL, 0x0000000008077faeULL, 0x0003e4000b901c46ULL,
0x00000010250e7825ULL, 0x040fe400078e000eULL, 0x000000000c197faeULL, 0x0003e4000b901c46ULL,
0x0000001025107825ULL, 0x000fc400078e0010ULL, 0x000000000e1b7faeULL, 0x0003e4000b901c46ULL,
0x0000001025127825ULL, 0x040fe400078e0012ULL, 0x00000000101d7faeULL, 0x0003e4000b901c46ULL,
0x0000001025147825ULL, 0x040fe400078e0014ULL, 0x00000000121f7faeULL, 0x0003e4000b901c46ULL,
0x0000001025167825ULL, 0x000fc400078e0016ULL, 0x0000000014217faeULL, 0x0003e8000b901c46ULL,
0x0000000016237faeULL, 0x0003e4000b901c46ULL, 0x00000003ff037424ULL, 0x002fe200078e00ffULL,
0x0000000302047812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x00000300060a7a24ULL, 0x000fe200078e0a03ULL, 0x000000030400780cULL, 0x000fc80003f05270ULL,
0x000000010a037807ULL, 0x000fca0004000000ULL, 0x0000000102027824ULL, 0x000fca00078e0203ULL,
0x0000005b0200720cULL, 0x000fda0003f06070ULL, 0x0000000253038824ULL, 0x000fe400078e00ffULL,
0x00006400ff048624ULL, 0x000fc800078e00ffULL, 0x0000640003038624ULL, 0x000fc800078e0204ULL,
0x0000000103078824ULL, 0x000fe400078e0202ULL, 0xffffffffff037424ULL, 0x000fe400078e00ffULL,
0x0000600007068625ULL, 0x000fca00078e0006ULL, 0x0000000606038981ULL, 0x000322000c1e1900ULL,
0x000000595e00720cULL, 0x000fe20003f06070ULL, 0xff317217ff7a7424ULL, 0x000fe200078e00ffULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x000074b000000947ULL, 0x000fea0003800000ULL,
0x0000000253057824ULL, 0x002fe400078e00ffULL, 0x00006400ff067624ULL, 0x000fc400078e00ffULL,
0xff317217ff7a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff7c7224ULL, 0x000fe400078e00ffULL,
0x0000640005057624ULL, 0x000fe400078e0206ULL, 0x000000ffff137224ULL, 0x000fc400078e00ffULL,
0x000001005e0d7824ULL, 0x020fca00078e00ffULL, 0x0000005a0d00720cULL, 0x000fda0003f06070ULL,
0x000073e000000947ULL, 0x000fea0003800000ULL, 0x000000105c067824ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe0060d7812ULL, 0x000fe200078ec0ffULL,
0x00005800030e7a24ULL, 0x010fe200078e02ffULL, 0x000000015e067810ULL, 0x000fc60007ffe0ffULL,
0x000001005e0d7824ULL, 0x000fe200078e020dULL, 0x000000590600720cULL, 0x000fe20003f06070ULL,
0x000000ffff067224ULL, 0x000fe400078e007cULL, 0x000000400e0e7824ULL, 0x000fe200078e00ffULL,
0x000000400d0c7810ULL, 0x000fc80007ffe0ffULL, 0x000000200b0f7812ULL, 0x000fca00078ef80cULL,
0x0000078000008947ULL, 0x000fea0003800000ULL, 0x000020005c0d7824ULL, 0x000fe200078e00ffULL,
0x00000003ff1d7819ULL, 0x000fe20000011600ULL, 0x0000000858167824ULL, 0x000fe200078e00ffULL,
0x0000000c5a037217ULL, 0x000fe40007800000ULL, 0x000020000d147812ULL, 0x000fe200078ec0ffULL,
0x000010007c0d7824ULL, 0x000fe200078e00ffULL, 0x000000041d177810ULL, 0x000fe20007ffe0ffULL,
0x00000001030c7824ULL, 0x000fe200078e0a0cULL, 0x000000081d197810ULL, 0x000fe20007ffe0ffULL,
0x0000400057147824ULL, 0x000fe200078e0214ULL, 0x000010000d157812ULL, 0x000fe200078e0cffULL,
0x000000011d0d7824ULL, 0x000fe200078e020fULL, 0x000000200c227817ULL, 0x000fe20003800000ULL,
0x0000000119237824ULL, 0x140fe200078e0200ULL, 0x0000b00014207810ULL, 0x000fe20007ffe015ULL,
0x00000008190c7824ULL, 0x000fe200078e00ffULL, 0x0000000d0e147210ULL, 0x000fe20007f1e0ffULL,
0x00000001170d7824ULL, 0x000fe200078e020fULL, 0x0000000c1d297810ULL, 0x000fe20007ffe0ffULL,
0x0000000117217824ULL, 0x100fe200078e0200ULL, 0x0000000700037812ULL, 0x000fe200078ec0ffULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005e00141e7a11ULL, 0x040fe200078040ffULL,
0x0000000129287824ULL, 0x000fe200078e0200ULL, 0x000000101d2b7810ULL, 0x000fe20007ffe0ffULL,
0x00000008294f7824ULL, 0x040fe200078e00ffULL, 0x00005f00141f7a11ULL, 0x000fe200000f4415ULL,
0x0000000129157824ULL, 0x100fe200078e020fULL, 0x0000000d0e147210ULL, 0x000fe20007f1e0ffULL,
0x00000001190d7824ULL, 0x040fe200078e020fULL, 0x000000221900720cULL, 0x000fc40003f26070ULL,
0xfffffff80c237812ULL, 0x000fe200078ee223ULL, 0x000000ffff197224ULL, 0x000fe200000e06ffULL,
0x00005e00140c7a11ULL, 0x000fe400078040ffULL, 0x0000000816037812ULL, 0x000fe200078ee203ULL,
0x0000000817167824ULL, 0x040fe200078e00ffULL, 0x000000221700720cULL, 0x000fe20003f46070ULL,
0x000000012b177824ULL, 0x000fe200078e020fULL, 0x0000000d0e1b7210ULL, 0x000fe20007f7e0ffULL,
0x00000010031e7825ULL, 0x000fe200078e001eULL, 0x00005f00140d7a11ULL, 0x000fc400000f4419ULL,
0x000000150e197210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x000000170e157210ULL, 0x000fe20007fbe0ffULL, 0x00000010030c7825ULL, 0x000fe200078e000cULL,
0xfffffff816217812ULL, 0x000fe400078ee221ULL, 0x00005e0019167a11ULL, 0x000fe200078640ffULL,
0x000000ffff1c7224ULL, 0x000fe200020e06ffULL, 0x000000141d497810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff187224ULL, 0x000fe200028e06ffULL, 0x00005e0015147a11ULL, 0x000fe200078840ffULL,
0x0000001021217824ULL, 0x000fe200078e0220ULL, 0x00005f0019177a11ULL, 0x000fe200018f441cULL,
0x0000000149197824ULL, 0x000fe200078e020fULL, 0x00005e001b1a7a11ULL, 0x000fe200078040ffULL,
0x0000001023237824ULL, 0x000fe200078e0220ULL, 0x000000181d4b7810ULL, 0x000fe20007ffe0ffULL,
0x0000001003167825ULL, 0x000fe200078e0016ULL, 0x00005f0015157a11ULL, 0x000fc400020f4418ULL,
0x0000001c1d4d7810ULL, 0x040fe20007ffe0ffULL, 0x000000011d187824ULL, 0x000fe200078e0200ULL,
0x00005f001b1b7a11ULL, 0x000fe200000f4424ULL, 0x0000001003147825ULL, 0x000fe200078e0014ULL,
0x000000190e1c7210ULL, 0x000fe40007f1e0ffULL, 0x0000000718277812ULL, 0x000fe200078ec0ffULL,
0x000000014b197824ULL, 0x100fe200078e020fULL, 0x000000221d00720cULL, 0x000fe20003f66070ULL,
0x000000014d0f7824ULL, 0x000fe200078e020fULL, 0x0ffffff827277812ULL, 0x000fe200078ef800ULL,
0x000000ffff257224ULL, 0x000fe200000e06ffULL, 0x00005e001c187a11ULL, 0x000fe200078040ffULL,
0x00000010031a7825ULL, 0x000fe200078e001aULL, 0x000000190e1d7210ULL, 0x000fc40007f9e0ffULL,
0x0000000f0e0f7210ULL, 0x000fe40007fbe0ffULL, 0x00005f001c197a11ULL, 0x000fe200000f4425ULL,
0x0000001027257824ULL, 0x000fe200078e0220ULL, 0x000000222900720cULL, 0x080fe20003f06070ULL,
0x000000ffff267224ULL, 0x000fe200020e06ffULL, 0x00005e001d1c7a11ULL, 0x000fe200078840ffULL,
0x000000ffff247224ULL, 0x000fe200028e06ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078a40ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e257faeULL, 0x0003e2000d901c46ULL,
0x00005f001d1d7a11ULL, 0x000fe200020f4426ULL, 0x0000000849297824ULL, 0x000fe200078e00ffULL,
0x00005f000f0f7a11ULL, 0x000fe200028f4424ULL, 0x0000000149247824ULL, 0x100fe200078e0200ULL,
0x000000222b00720cULL, 0x080fe20003f66070ULL, 0x000000014b267824ULL, 0x100fe200078e0200ULL,
0x000000224900720cULL, 0x080fe20003f86070ULL, 0x000000084d497824ULL, 0x000fe200078e00ffULL,
0x000000224b00720cULL, 0x0c0fe20003fa6070ULL, 0x000000084b4b7824ULL, 0x000fe200078e00ffULL,
0x000000224d00720cULL, 0x000fe20003fc6070ULL, 0x000000012b227824ULL, 0x000fe200078e0200ULL,
0xfffffff84f277812ULL, 0x000fe200078ee228ULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee224ULL, 0x000000014d1e7824ULL, 0x002fe200078e0200ULL,
0x000000000c217faeULL, 0x0003e2000d101c46ULL, 0x00000010271f7824ULL, 0x000fe200078e0220ULL,
0xfffffff82b257812ULL, 0x000fe200078ee222ULL, 0x0000001029277824ULL, 0x000fe200078e0220ULL,
0xfffffff84b2b7812ULL, 0x000fe200078ee226ULL, 0x0000001003187825ULL, 0x000fe200078e0018ULL,
0xfffffff849497812ULL, 0x000fe200078ee21eULL, 0x000000001a237faeULL, 0x0003e4000c901c46ULL,
0x0000001025257824ULL, 0x000fc400078e0220ULL, 0x000000102b297824ULL, 0x000fe200078e0220ULL,
0x00000000161f7faeULL, 0x0003e2000c101c46ULL, 0x00000010031c7825ULL, 0x000fc600078e001cULL,
0x0000000014257faeULL, 0x0003e2000d901c46ULL, 0x00000010492b7824ULL, 0x000fe400078e0220ULL,
0x00000010030e7825ULL, 0x000fe200078e000eULL, 0x0000000018277faeULL, 0x0003e8000e101c46ULL,
0x000000001c297faeULL, 0x0003e8000e901c46ULL, 0x000000000e2b7faeULL, 0x0003e2000f101c46ULL,
0x000006b000007947ULL, 0x000fea0003800000ULL, 0x0000000800197811ULL, 0x000fe200078fe8ffULL,
0x0000000858147824ULL, 0x000fe200078e00ffULL, 0x0000000700037812ULL, 0x000fe200078ec0ffULL,
0x000020005c0c7824ULL, 0x000fe200078e00ffULL, 0x0000000400177811ULL, 0x040fe200078fe8ffULL,
0x0000000119207824ULL, 0x140fe200078e0200ULL, 0x0000000c001b7811ULL, 0x000fe200078fe8ffULL,
0x0000000819157824ULL, 0x000fe200078e00ffULL, 0x0000000814037812ULL, 0x000fe200078ee203ULL,
0x00000001170d7824ULL, 0x040fe200078e0200ULL, 0x000020000c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000817147824ULL, 0x000fe200078e00ffULL, 0xfffffff815207812ULL, 0x000fe200078ee220ULL,
0x000000011b217824ULL, 0x040fe200078e0200ULL, 0x0000000f00157211ULL, 0x040fe200078fe8ffULL,
0x000000081b167824ULL, 0x000fe200078e00ffULL, 0x0000001800257811ULL, 0x000fe200078fe8ffULL,
0x0000000117177824ULL, 0x000fe200078e020fULL, 0x000000150e157210ULL, 0x000fe20007f1e0ffULL,
0x0000400057577824ULL, 0x000fe200078e020cULL, 0xfffffff8140d7812ULL, 0x000fe200078ee20dULL,
0x000000011b1b7824ULL, 0x000fe200078e020fULL, 0xfffffff816217812ULL, 0x000fe200078ee221ULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00000010001d7811ULL, 0x040fe200078fe8ffULL,
0x0000000125237824ULL, 0x140fe200078e0200ULL, 0x00000014001f7811ULL, 0x000fe200078fe8ffULL,
0x0000000825167824ULL, 0x000fe200078e00ffULL, 0x00005e0015147a11ULL, 0x000fe200078040ffULL,
0x0000000119197824ULL, 0x000fe200078e020fULL, 0x000000170e187210ULL, 0x000fe20007f7e0ffULL,
0x000000011d247824ULL, 0x040fe200078e0200ULL, 0x0000001c001e7811ULL, 0x000fe200078fe8ffULL,
0x000000081d277824ULL, 0x000fe200078e00ffULL, 0x00005f0015157a11ULL, 0x000fe200000f440cULL,
0x000000011f227824ULL, 0x140fe200078e0200ULL, 0x0000001b0e0c7210ULL, 0x000fe20007f1e0ffULL,
0x000000081f297824ULL, 0x000fe200078e00ffULL, 0xfffffff816237812ULL, 0x000fe200078ee223ULL,
0x000000011d1d7824ULL, 0x100fe200078e020fULL, 0x000000190e167210ULL, 0x000fe20007f3e0ffULL,
0x000000011f1f7824ULL, 0x100fe200078e020fULL, 0x00005e00181a7a11ULL, 0x000fe200078c40ffULL,
0x0000000125257824ULL, 0x100fe200078e020fULL, 0x0000001d0e197210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e06ffULL, 0x0000001f0e177210ULL, 0x000fe20007f9e0ffULL,
0x000000011e0f7824ULL, 0x000fe200078e020fULL, 0x000000250e257210ULL, 0x000fe20007fbe0ffULL,
0x000010007c1c7824ULL, 0x000fe200078e00ffULL, 0x00005f00181b7a11ULL, 0x000fe200030f441bULL,
0x000000011e187824ULL, 0x000fe200078e0200ULL, 0x0000000f0e267210ULL, 0x000fe20007f7e0ffULL,
0x000000081e4b7824ULL, 0x000fe200078e00ffULL, 0x000010001c0e7812ULL, 0x000fe200078e0cffULL,
0x000000ffff1d7224ULL, 0x000fe200008e06ffULL, 0x00005e00161e7a11ULL, 0x000fe200078240ffULL,
0x000000ffff0f7224ULL, 0x000fe200000e06ffULL, 0x00005e000c1c7a11ULL, 0x000fe200078040ffULL,
0x000000ffff2a7224ULL, 0x000fe200010e06ffULL, 0x00005f00161f7a11ULL, 0x000fe200008f441dULL,
0x000000ffff287224ULL, 0x000fe200020e06ffULL, 0x00005f000c1d7a11ULL, 0x000fe200000f440fULL,
0x000000ffff0c7224ULL, 0x000fe200028e06ffULL, 0x00000000000f7211ULL, 0x000fe200078fe8ffULL,
0x000000ffff4d7224ULL, 0x000fe200018e06ffULL, 0x0000b00057487810ULL, 0x000fe20007ffe00eULL,
0x0000001003147825ULL, 0x000fe200078e0014ULL, 0xfffffff827247812ULL, 0x000fc400078ee224ULL,
0x00005e00250e7a11ULL, 0x000fe200078440ffULL, 0x00000010031a7825ULL, 0x000fe200078e001aULL,
0x000000070f277812ULL, 0x000fe400078ec0ffULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee218ULL,
0x00000010031e7825ULL, 0x000fe200078e001eULL, 0x00005e0019187a11ULL, 0x000fe400078040ffULL,
0x00005f00250f7a11ULL, 0x000fe200010f440cULL, 0x0000001021217824ULL, 0x000fe200078e0248ULL,
0x0ffffff827257812ULL, 0x000fe200078ef800ULL, 0x000000100d277824ULL, 0x000fe200078e0248ULL,
0x00005e0017167a11ULL, 0x000fe200078240ffULL, 0x00000010031c7825ULL, 0x000fe200078e001cULL,
0x00005f0019197a11ULL, 0x000fc400000f442aULL, 0x00005e00260c7a11ULL, 0x000fe200078040ffULL,
0x0000001025257824ULL, 0x000fe200078e0248ULL, 0xfffffff829227812ULL, 0x000fe200078ee222ULL,
0x0000001020297824ULL, 0x000fe200078e0248ULL, 0x00005f0017177a11ULL, 0x000fe200008f4428ULL,
0x00000010242b7824ULL, 0x000fe200078e0248ULL, 0x00005f00260d7a11ULL, 0x000fe200000f444dULL,
0x0000001003187825ULL, 0x040fe200078e0018ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014257faeULL, 0x0003e6000b901c46ULL, 0x0000001022497824ULL, 0x000fe200078e0248ULL,
0x000000001a277faeULL, 0x0003e2000b901c46ULL, 0x0000001003167825ULL, 0x000fc600078e0016ULL,
0x000000001e297faeULL, 0x0003e2000b901c46ULL, 0x0000001023237824ULL, 0x000fe400078e0248ULL,
0x00000010030e7825ULL, 0x000fe200078e000eULL, 0x000000001c217faeULL, 0x0003e6000b901c46ULL,
0x000000104b4b7824ULL, 0x000fe200078e0248ULL, 0x00000000182b7faeULL, 0x0003e2000b901c46ULL,
0x00000010030c7825ULL, 0x000fc600078e000cULL, 0x0000000016497faeULL, 0x0003e8000b901c46ULL,
0x000000000e237faeULL, 0x0003e8000b901c46ULL, 0x000000000c4b7faeULL, 0x0003e4000b901c46ULL,
0x0000000302037812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000030300780cULL, 0x000fc80003f05270ULL, 0x000000010a037807ULL, 0x000fca0004000000ULL,
0x0000000102027824ULL, 0x000fe400078e0203ULL, 0xffffffffff037424ULL, 0x000fc600078e00ffULL,
0x0000005b0200720cULL, 0x000fda0003f06070ULL, 0x00000001050c8824ULL, 0x002fe400078e0202ULL,
0x00000004ff0d8424ULL, 0x000fc800078e00ffULL, 0x000060000c0c8625ULL, 0x000fca00078e000dULL,
0x000000060c038981ULL, 0x000322000c1e1900ULL, 0xffffffe056797812ULL, 0x040fe400078ec0ffULL,
0x00000010560e7812ULL, 0x040fe400078ec0ffULL, 0x00000008560f7812ULL, 0x000fc800078ec0ffULL,
0x000000790f797210ULL, 0x000fe20007ffe00eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0136080079147f8cULL, 0x0022a4000c80043fULL, 0x00000000000c7805ULL, 0x000fc40000015200ULL,
0x01360c00790f7984ULL, 0x000ee40000000800ULL, 0x800000000fff7812ULL, 0x00cfe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e0c177210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e0dULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000170e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01360c00790f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x004fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000677824ULL, 0x000fe200078e00ffULL, 0x00000001ff657819ULL, 0x000fe20000011600ULL,
0x000000205c667824ULL, 0x000fe400078e00ffULL, 0xffffffffff617424ULL, 0x000fe200078e00ffULL,
0x0000007067677812ULL, 0x000fc400078ec0ffULL, 0xffffff8066667812ULL, 0x000fe400078ec0ffULL,
0x0000000c65657812ULL, 0x000fc800078ec0ffULL, 0x00000066650c7210ULL, 0x000fca0007ffe067ULL,
0x013000000c0f7984ULL, 0x000ea80000000800ULL, 0x013200000c0e7984ULL, 0x0006620000000800ULL,
0x0000007a0f00720bULL, 0x004fe20003f1d000ULL, 0x000104327f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0c197812ULL, 0x000fe2000782c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff697224ULL, 0x000fe400078e007aULL, 0x0000001fff637424ULL, 0x000fc400078e00ffULL,
0xffffffffff607424ULL, 0x000fcc00078e00ffULL, 0x0000043000009947ULL, 0x000fea0003800000ULL,
0x0000005c5500720cULL, 0x000fe40003f25270ULL, 0x0000007a0f00720bULL, 0x000fe20003f54000ULL,
0x000103d27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x000fc400010e0100ULL,
0x000000805c0c9824ULL, 0x000fe200078e0267ULL, 0x0000000f7a697209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x00009910140d7816ULL, 0x000fe200000000ffULL,
0x00000001650c9824ULL, 0x000fca00078e020cULL, 0x013400690c009388ULL, 0x0005e20000000800ULL,
0x000000ff0d00720cULL, 0x000fda0003f25270ULL, 0x0000030000009947ULL, 0x000fea0003800000ULL,
0x800000697a0c7221ULL, 0x004fe20000010000ULL, 0x000000ff14ff7812ULL, 0x000fe2000782c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00157308ULL, 0x0004ec0000000800ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x004fe20000011600ULL, 0x000103127f007947ULL, 0x000fea000b800000ULL,
0x00001f0c150c7589ULL, 0x0084e400000e0000ULL, 0x0000000c44447220ULL, 0x088fe20000410000ULL,
0x0000000c45457220ULL, 0x080fe20000410000ULL, 0x0000000c40407220ULL, 0x080fe20000410000ULL,
0x0000000c41417220ULL, 0x080fe20000410000ULL, 0x0000000c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000000c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000c38387220ULL, 0x080fe20000410000ULL,
0x0000000c39397220ULL, 0x080fe20000410000ULL, 0x0000000c34347220ULL, 0x080fe20000410000ULL,
0x0000000c35357220ULL, 0x080fe20000410000ULL, 0x0000000c30307220ULL, 0x080fe20000410000ULL,
0x0000000c31317220ULL, 0x080fe20000410000ULL, 0x0000000c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c10107220ULL, 0x080fe20000410000ULL,
0x0000000c11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0014ff7812ULL, 0x000fe2000782c0ffULL, 0x0000001504047220ULL, 0x008fd80000410000ULL,
0x0000013000009947ULL, 0x000fea0003800000ULL, 0x00000008000c7811ULL, 0x004fe200078ff0ffULL,
0x000101f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c150c7589ULL, 0x0004e400000e0000ULL,
0x0000000c46467220ULL, 0x088fe20000410000ULL, 0x0000000c47477220ULL, 0x080fe20000410000ULL,
0x0000000c42427220ULL, 0x080fe20000410000ULL, 0x0000000c43437220ULL, 0x080fe20000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000c36367220ULL, 0x080fe20000410000ULL, 0x0000000c37377220ULL, 0x080fe20000410000ULL,
0x0000000c32327220ULL, 0x080fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c12127220ULL, 0x080fe20000410000ULL, 0x0000000c13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff19ff7812ULL, 0x000fda0007826014ULL,
0x800000690f0f1221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b0f0f1820ULL, 0x000fc80000410000ULL, 0x0000000f00071308ULL, 0x000ea40000000800ULL,
0x000000070e0e1220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x000000040e047221ULL, 0x002fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000000ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011600ULL,
0x00005410080f7816ULL, 0x000fe20000000008ULL, 0x000100327f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0f097589ULL, 0x0002a400000e0000ULL, 0x000000080e087810ULL, 0x000fe20007ffe0ffULL,
0x000100627f007947ULL, 0x000fea000b800000ULL, 0x00001f080f087589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100e0c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x000fe200078e000fULL, 0x0000305000177802ULL, 0x000fc40000000f00ULL,
0x00010ab000007944ULL, 0x01efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180e0c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff167224ULL, 0x004fe200078e000fULL,
0x000030a000177802ULL, 0x000fc40000000f00ULL, 0x00010a6000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000007005f7812ULL, 0x000fe200078ec0ffULL,
0x000000025c627824ULL, 0x040fe200078e00ffULL, 0x00000004ff167819ULL, 0x104fe20000011600ULL,
0x000002005c0e7824ULL, 0x002fe200078e00ffULL, 0x000000085f0c7812ULL, 0x000fe200078ef800ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000004620d7812ULL, 0x000fc400078ec0ffULL,
0xfffff8000e5d7812ULL, 0x000fe200078ec0ffULL, 0x000000080c647824ULL, 0x040fe200078e00ffULL,
0x0000000d0c0d7210ULL, 0x000fc80007ffe016ULL, 0xfffffff864647812ULL, 0x000fe400078ee20dULL,
0x00000008000d7812ULL, 0x000fc600078ec0ffULL, 0x0000001064647824ULL, 0x000fc800078e025dULL,
0x000000070d0d7812ULL, 0x000fe200078ef800ULL, 0x009000006428783bULL, 0x000e620000000200ULL,
0x00000001ff577819ULL, 0x000fe2000001165cULL, 0x0000200058707824ULL, 0x000fe200078e00ffULL,
0xfffffff862627812ULL, 0x000fe200078ec0ffULL, 0x00000001160e7824ULL, 0x000fe400078e020dULL,
0x000000080d147824ULL, 0x000fe400078e00ffULL, 0x0000000257157824ULL, 0x000fe200078e0258ULL,
0x000000020e777810ULL, 0x040fe20007ffe0ffULL, 0x000000080d177824ULL, 0x000fe200078e00ffULL,
0x000000040e767810ULL, 0x000fe20007ffe0ffULL, 0x00000004570f7824ULL, 0x008fe200078e0216ULL,
0xfffffff814777812ULL, 0x000fe200078ee277ULL, 0x000000080d197824ULL, 0x000fe200078e00ffULL,
0x000000060e747810ULL, 0x000fe20007ffe0ffULL, 0x0000000215147824ULL, 0x000fe200078e027cULL,
0xfffffff817787812ULL, 0x000fe200078ee20eULL, 0x000000080d1b7824ULL, 0x000fe200078e00ffULL,
0x000000020f0e7810ULL, 0x000fe20007ffe00cULL, 0x000000080c157824ULL, 0x000fe200078e00ffULL,
0x0000b000140f7811ULL, 0x000fe200078e60ffULL, 0x0000400057177824ULL, 0x000fe200078e0270ULL,
0xfffffff819767812ULL, 0x000fc400078ee276ULL, 0xfffffff81b747812ULL, 0x000fe200078ee274ULL,
0x0000001078507824ULL, 0x100fe200078e020fULL, 0xfffffff815147812ULL, 0x000fe200078ee20eULL,
0x00000010774c7824ULL, 0x100fe200078e020fULL, 0x000000100d157812ULL, 0x000fe200078efcffULL,
0x0000001076487824ULL, 0x100fe400078e020fULL, 0x00000010740f7824ULL, 0x000fe200078e020fULL,
0x000000005050783bULL, 0x000ea20000004200ULL, 0x00000001166f7824ULL, 0x000fe400078e0215ULL,
0x0000000815197824ULL, 0x000fe200078e00ffULL, 0x000000004c4c783bULL, 0x000ee20000004200ULL,
0x000010007c187824ULL, 0x000fe200078e0217ULL, 0x000000026f6e7810ULL, 0x000fe20007ffe0ffULL,
0x00000008151c7824ULL, 0x040fe200078e00ffULL, 0x000000004848783bULL, 0x000fe20000004200ULL,
0x00000008151a7824ULL, 0x000fe200078e00ffULL, 0x000000046f6d7810ULL, 0x000fe20007ffe0ffULL,
0x00000008151e7824ULL, 0x000fe200078e00ffULL, 0x000000000f0c783bULL, 0x000fe20000004200ULL,
0x000000066f6b7810ULL, 0x000fe20007ffe0ffULL, 0x00000010145d7824ULL, 0x000fe200078e025dULL,
0xfffffff8196e7812ULL, 0x000fe200078ee26eULL, 0x0000000928280232ULL, 0x082fe20000000000ULL,
0x0000b00018187810ULL, 0x000fe20007ffe0ffULL, 0x000000092a2a0232ULL, 0x080fe20000000000ULL,
0xfffffff81c6d7812ULL, 0x000fe200078ee26dULL, 0x009000005d14783bULL, 0x000e620000000200ULL,
0xfffffff81a6f7812ULL, 0x000fe200078ee26fULL, 0x000000106e247824ULL, 0x100fe200078e0218ULL,
0xfffffff81e6b7812ULL, 0x000fe200078ee26bULL, 0x000000106d207824ULL, 0x100fe200078e0218ULL,
0x0000000829290232ULL, 0x080fe20000000000ULL, 0x000000106f1c7824ULL, 0x100fe200078e0218ULL,
0x000000082b2b0232ULL, 0x000fe20000000000ULL, 0x000000106b187824ULL, 0x000fe200078e0218ULL,
0x000000002424783bULL, 0x000e680000004200ULL, 0x000000002020783bULL, 0x000e680000004200ULL,
0x000000001c1c783bULL, 0x000e620000004200ULL, 0x000000502844723cULL, 0x044fe60000001844ULL,
0x000000001818783bULL, 0x000eaa0000004200ULL, 0x000000522840723cULL, 0x040ff00000001840ULL,
0x0000004c283c723cULL, 0x008f62000000183cULL, 0x0000000914140232ULL, 0x002fc40000000000ULL,
0x0000000916160232ULL, 0x000fca0000000000ULL, 0x0000004e2838723cULL, 0x000f620000001838ULL,
0x0000000815150232ULL, 0x080fe40000000000ULL, 0x0000000817170232ULL, 0x000fca0000000000ULL,
0x000000482834723cULL, 0x040f700000001834ULL, 0x0000004a2830723cULL, 0x040f700000001830ULL,
0x0000000c282c723cULL, 0x040f70000000182cULL, 0x0000000e2810723cULL, 0x000f700000001810ULL,
0x00000024143c723cULL, 0x060b70000000183cULL, 0x000000261438723cULL, 0x040b700000001838ULL,
0x000000201434723cULL, 0x040b700000001834ULL, 0x000000221430723cULL, 0x040b700000001830ULL,
0x0000001c1444723cULL, 0x040b700000001844ULL, 0x0000001e1440723cULL, 0x040b700000001840ULL,
0x00000018142c723cULL, 0x044b70000000182cULL, 0x0000001a1410723cULL, 0x000b620000001810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000405e0d7811ULL, 0x000fe200078e40ffULL,
0x0136880062ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff7a7224ULL, 0x000fe200078e0069ULL,
0x000000017c7c7812ULL, 0x000fc400078e0cffULL, 0x0000005a0d00720cULL, 0x000fda0003f06070ULL,
0x000053e000000947ULL, 0x000fea0003800000ULL, 0x000000105c0c7824ULL, 0x002fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe00c0d7812ULL, 0x000fe200078ec0ffULL,
0x0000580003037a24ULL, 0x010fe200078e02ffULL, 0x000000015e0c7810ULL, 0x000fc60007ffe0ffULL,
0x000001005e0d7824ULL, 0x000fe200078e020dULL, 0x000000590c00720cULL, 0x000fe20003f06070ULL,
0x0000004003037824ULL, 0x000fc600078e00ffULL, 0x000000800d0e7810ULL, 0x000fc80007ffe0ffULL,
0x000000200b177812ULL, 0x020fca00078ef80eULL, 0x0000077000008947ULL, 0x000fea0003800000ULL,
0x000020005c0c7824ULL, 0x000fe200078e00ffULL, 0x00000003ff1b7819ULL, 0x000fe20000011600ULL,
0x0000000858287824ULL, 0x000fe200078e00ffULL, 0x0000000e5a0d7217ULL, 0x000fe40007800000ULL,
0x000020000c147812ULL, 0x000fe200078ec0ffULL, 0x00001000060c7824ULL, 0x000fe200078e00ffULL,
0x000000041b0f7810ULL, 0x000fe20007ffe0ffULL, 0x000000010d0d7824ULL, 0x000fe200078e0a0eULL,
0x000000081b157810ULL, 0x000fe20007ffe0ffULL, 0x0000400057577824ULL, 0x000fe200078e0214ULL,
0x000010000c207812ULL, 0x000fe200078ec0ffULL, 0x000000010f217824ULL, 0x100fe200078e0200ULL,
0x000000200d227817ULL, 0x000fe20003800000ULL, 0x000000080f0e7824ULL, 0x000fe200078e00ffULL,
0x0000000c1b197810ULL, 0x040fe20007ffe0ffULL, 0x000000011b0c7824ULL, 0x000fe200078e0217ULL,
0x000000220f00720cULL, 0x000fe20003f46070ULL, 0x0000000115237824ULL, 0x040fe200078e0200ULL,
0xfffffff80e217812ULL, 0x000fe200078ee221ULL, 0x0000000815147824ULL, 0x000fe200078e00ffULL,
0x0000000c030e7210ULL, 0x000fe20007f1e0ffULL, 0x000000010f0c7824ULL, 0x000fe200078e0217ULL,
0x000000101b257810ULL, 0x000fe20007ffe0ffULL, 0x00000008194b7824ULL, 0x000fe200078e00ffULL,
0xfffffff814237812ULL, 0x000fe200078ee223ULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x00005e000e1e7a11ULL, 0x000fe200078040ffULL, 0x0000000125147824ULL, 0x000fe200078e0217ULL,
0x000000221500720cULL, 0x000fc40003f26070ULL, 0x00005f000e1f7a11ULL, 0x000fe200000f440dULL,
0x00000001190e7824ULL, 0x100fe200078e0217ULL, 0x0000000c030f7210ULL, 0x000fe20007f1e0ffULL,
0x00000001150c7824ULL, 0x000fe200078e0217ULL, 0x0000001403157210ULL, 0x000fe40007fbe0ffULL,
0x000000141b277810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x00005e000f1c7a11ULL, 0x000fe400078040ffULL, 0x0000000c030d7210ULL, 0x000fc40007f7e0ffULL,
0x00005f000f1d7a11ULL, 0x000fe200000f4416ULL, 0x000000ffff167224ULL, 0x000fe200028e06ffULL,
0x0000000e030f7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff1a7224ULL, 0x000fe200018e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe400078040ffULL, 0x00005e000f0e7a11ULL, 0x000fe200078640ffULL,
0x000000ffff187224ULL, 0x000fe200020e06ffULL, 0x00005e0015147a11ULL, 0x000fe400078840ffULL,
0x000000181b4d7810ULL, 0x000fc40007ffe0ffULL, 0x00005f0015157a11ULL, 0x000fe200020f4416ULL,
0x0000000127167824ULL, 0x100fe200078e0217ULL, 0x00005f000f0f7a11ULL, 0x000fe200018f4418ULL,
0x000000014d187824ULL, 0x100fe200078e0217ULL, 0x0000001c1b297810ULL, 0x040fe40007ffe0ffULL,
0x000000221b00720cULL, 0x040fe20003f66070ULL, 0x000000011b1b7824ULL, 0x000fe200078e0200ULL,
0x00005f000d0d7a11ULL, 0x000fe200000f441aULL, 0x00000001291a7824ULL, 0x000fe200078e0217ULL,
0x0000001603247210ULL, 0x000fc40007f1e0ffULL, 0x000000071b2b7812ULL, 0x000fe400078ec0ffULL,
0x0000001803267210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff177224ULL, 0x000fe200000e06ffULL,
0x0000001a031b7210ULL, 0x000fe40007fbe0ffULL, 0x0000b00057207810ULL, 0x000fe20007ffe020ULL,
0x000000ffff497224ULL, 0x000fe200020e06ffULL, 0x00005e0024167a11ULL, 0x000fe400078040ffULL,
0x0ffffff82b2b7812ULL, 0x000fe200078ef800ULL, 0x0000001021217824ULL, 0x000fe200078e0220ULL,
0x0000000828037812ULL, 0x000fe200078ee25fULL, 0x0000000119287824ULL, 0x000fe200078e0200ULL,
0x00005f0024177a11ULL, 0x000fe200000f4417ULL, 0x000000102b2b7824ULL, 0x000fe200078e0220ULL,
0x00005e0026187a11ULL, 0x000fe200078840ffULL, 0x000000ffff247224ULL, 0x000fe200028e06ffULL,
0x00005e001b1a7a11ULL, 0x000fe200078a40ffULL, 0x00000010031e7825ULL, 0x000fe200078e001eULL,
0x000000221900720cULL, 0x000fc40003f06070ULL, 0x00005f0026197a11ULL, 0x000fe200020f4449ULL,
0x000000014d267824ULL, 0x000fe200078e0200ULL, 0x00005f001b1b7a11ULL, 0x000fe200028f4424ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e2b7faeULL, 0x0003e2000d901c46ULL,
0x000000222500720cULL, 0x080fe20003f66070ULL, 0x0000000127247824ULL, 0x140fe200078e0200ULL,
0x000000222700720cULL, 0x0c0fe20003f86070ULL, 0x0000000827277824ULL, 0x000fe200078e00ffULL,
0x000000224d00720cULL, 0x0c0fe20003fa6070ULL, 0x000000084d4d7824ULL, 0x000fe200078e00ffULL,
0x000000222900720cULL, 0x000fe20003fc6070ULL, 0x0000000125227824ULL, 0x000fe200078e0200ULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee228ULL, 0x0000000825257824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee224ULL, 0x00000001291e7824ULL, 0x002fc400078e0200ULL,
0x00000008292b7824ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe200078ee222ULL,
0x00000010031c7825ULL, 0x000fe200078e001cULL, 0xfffffff84d297812ULL, 0x000fe400078ee226ULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee21eULL, 0x0000001023237824ULL, 0x000fe200078e0220ULL,
0x000000001c217faeULL, 0x0003e2000d101c46ULL, 0x00000010030c7825ULL, 0x000fc800078e000cULL,
0x000000104b1f7824ULL, 0x000fe200078e0220ULL, 0x000000000c237faeULL, 0x0003e2000c901c46ULL,
0x00000010030e7825ULL, 0x000fc800078e000eULL, 0x0000001025257824ULL, 0x000fe200078e0220ULL,
0x000000000e1f7faeULL, 0x0003e2000c101c46ULL, 0x0000001003147825ULL, 0x000fc800078e0014ULL,
0x0000001027277824ULL, 0x000fe200078e0220ULL, 0x0000000014257faeULL, 0x0003e2000d901c46ULL,
0x0000001003167825ULL, 0x000fc800078e0016ULL, 0x0000001029297824ULL, 0x000fe200078e0220ULL,
0x0000000016277faeULL, 0x0003e2000e101c46ULL, 0x0000001003187825ULL, 0x000fc800078e0018ULL,
0x000000102b2b7824ULL, 0x000fe200078e0220ULL, 0x0000000018297faeULL, 0x0003e2000e901c46ULL,
0x00000010031a7825ULL, 0x000fca00078e001aULL, 0x000000001a2b7faeULL, 0x0003e2000f101c46ULL,
0x000006a000007947ULL, 0x000fea0003800000ULL, 0x000020005c0c7824ULL, 0x000fe200078e00ffULL,
0x00000004000e7811ULL, 0x000fe200078fe8ffULL, 0x0000100006197824ULL, 0x000fe200078e00ffULL,
0x00000008000f7811ULL, 0x000fe200078fe8ffULL, 0x00000008582a7824ULL, 0x000fe200078e00ffULL,
0x000020000c0c7812ULL, 0x000fe200078ec0ffULL, 0x000000010e247824ULL, 0x000fe200078e0200ULL,
0x0000000c00147811ULL, 0x000fe200078fe8ffULL, 0x000000080e0d7824ULL, 0x000fe200078e00ffULL,
0x00000018001a7811ULL, 0x040fe200078fe8ffULL, 0x0000400057577824ULL, 0x000fe200078e020cULL,
0x00000017000c7211ULL, 0x000fe200078fe8ffULL, 0x000000010f237824ULL, 0x000fe200078e0200ULL,
0xfffffff80d247812ULL, 0x000fe200078ee224ULL, 0x000000080f167824ULL, 0x000fe200078e00ffULL,
0x0000000c030c7210ULL, 0x000fe20007f1e0ffULL, 0x0000000114227824ULL, 0x100fe200078e0200ULL,
0x0000001400187811ULL, 0x000fe200078fe8ffULL, 0x0000000814157824ULL, 0x000fe200078e00ffULL,
0xfffffff816237812ULL, 0x000fe200078ee223ULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x00005e000c1e7a11ULL, 0x000fe200078040ffULL, 0x000000011a1b7824ULL, 0x000fe200078e0200ULL,
0x0000001000167811ULL, 0x000fe200078fe8ffULL, 0x000000081a267824ULL, 0x000fe200078e00ffULL,
0x00005f000c1f7a11ULL, 0x000fe200000f440dULL, 0x000000010e0c7824ULL, 0x000fe200078e0217ULL,
0xfffffff815227812ULL, 0x000fe200078ee222ULL, 0x0000000118207824ULL, 0x100fe200078e0200ULL,
0x0000001c000d7811ULL, 0x000fe200078fe8ffULL, 0x0000000818157824ULL, 0x000fe200078e00ffULL,
0x0000000c030c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000116217824ULL, 0x000fe200078e0200ULL,
0xfffffff8261b7812ULL, 0x000fe200078ee21bULL, 0x00000008161c7824ULL, 0x000fe200078e00ffULL,
0xfffffff815207812ULL, 0x000fe200078ee220ULL, 0x000000010f0e7824ULL, 0x100fe200078e0217ULL,
0x0000000000277211ULL, 0x000fe200078fe8ffULL, 0x0000000114147824ULL, 0x000fe200078e0217ULL,
0xfffffff81c217812ULL, 0x000fe200078ee221ULL, 0x0000000116167824ULL, 0x100fe200078e0217ULL,
0x00005e000c1c7a11ULL, 0x000fe200078c40ffULL, 0x0000000118187824ULL, 0x100fe200078e0217ULL,
0x00000014030f7210ULL, 0x040fe20007f1e0ffULL, 0x000000011a1a7824ULL, 0x100fe200078e0217ULL,
0x0000001603167210ULL, 0x000fe20007f3e0ffULL, 0x000000010d267824ULL, 0x000fe200078e0217ULL,
0x0000001803177210ULL, 0x000fe20007f5e0ffULL, 0x000000010d257824ULL, 0x000fe200078e0200ULL,
0x0000000727277812ULL, 0x000fe200078ec0ffULL, 0x000000080d287824ULL, 0x000fe200078e00ffULL,
0x0000000e030d7210ULL, 0x040fe20007f7e0ffULL, 0x000000ffff157224ULL, 0x000fe200020e06ffULL,
0x0000001a031a7210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x0000002603037210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff267224ULL, 0x000fe200018e06ffULL,
0x00005f000c1d7a11ULL, 0x000fe200030f4415ULL, 0x000000ffff157224ULL, 0x000fe200008e06ffULL,
0x00005e000d0c7a11ULL, 0x000fc400078640ffULL, 0x00005e000f0e7a11ULL, 0x000fe400078040ffULL,
0x00005e0016147a11ULL, 0x000fe400078240ffULL, 0xfffffff828257812ULL, 0x000fe400078ee225ULL,
0x00005f000d0d7a11ULL, 0x000fe200018f4426ULL, 0x000000ffff267224ULL, 0x000fe200010e06ffULL,
0x0000100019287812ULL, 0x000fe200078ec0ffULL, 0x000000ffff197224ULL, 0x000fe200020e06ffULL,
0x00005f000f0f7a11ULL, 0x000fc400000f4418ULL, 0x00005f0016157a11ULL, 0x000fe400008f4415ULL,
0x00005e0017167a11ULL, 0x000fe400078040ffULL, 0x00005e001a187a11ULL, 0x000fe400078240ffULL,
0x0000b00057287810ULL, 0x000fe40007ffe028ULL, 0x000000082a4d7812ULL, 0x000fe400078ee25fULL,
0x0ffffff827277812ULL, 0x000fe200078ef800ULL, 0x0000001024297824ULL, 0x000fe200078e0228ULL,
0x00005f0017177a11ULL, 0x000fe200000f4426ULL, 0x000000ffff267224ULL, 0x000fe200028e06ffULL,
0x00005f001a197a11ULL, 0x000fe200008f4419ULL, 0x0000001027277824ULL, 0x000fe200078e0228ULL,
0x00005e00031a7a11ULL, 0x000fe200078040ffULL, 0x000000104d1e7825ULL, 0x000fc800078e001eULL,
0x000000101b4b7824ULL, 0x000fe200078e0228ULL, 0x00005f00031b7a11ULL, 0x000fe200000f4426ULL,
0x000000104d1c7825ULL, 0x000fe200078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e277faeULL, 0x0003e6000b901c46ULL, 0x0000001023237824ULL, 0x000fe200078e0228ULL,
0x000000001c297faeULL, 0x0003e2000b901c46ULL, 0x000000104d0c7825ULL, 0x000fc800078e000cULL,
0x00000010222b7824ULL, 0x000fe200078e0228ULL, 0x000000000c237faeULL, 0x0003e2000b901c46ULL,
0x000000104d0e7825ULL, 0x000fc800078e000eULL, 0x0000001021217824ULL, 0x000fe200078e0228ULL,
0x000000000e2b7faeULL, 0x0003e2000b901c46ULL, 0x000000104d147825ULL, 0x000fc800078e0014ULL,
0x0000001020497824ULL, 0x000fe200078e0228ULL, 0x0000000014217faeULL, 0x0003e2000b901c46ULL,
0x000000104d167825ULL, 0x000fc800078e0016ULL, 0x000000104d187825ULL, 0x000fe200078e0018ULL,
0x0000000016497faeULL, 0x0003e6000b901c46ULL, 0x0000001025257824ULL, 0x000fe200078e0228ULL,
0x00000000184b7faeULL, 0x0003e2000b901c46ULL, 0x000000104d1a7825ULL, 0x000fca00078e001aULL,
0x000000001a257faeULL, 0x0003e4000b901c46ULL, 0x0000000302037812ULL, 0x000fc800078ec0ffULL,
0x000000030300780cULL, 0x000fc80003f05270ULL, 0x000000010a037807ULL, 0x000fca0004000000ULL,
0x0000000102027824ULL, 0x000fe400078e0203ULL, 0xffffffffff037424ULL, 0x000fc600078e00ffULL,
0x0000005b0200720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00000001050c7824ULL, 0x002fe400078e0202ULL, 0x00000004ff0d7424ULL, 0x000fc800078e00ffULL,
0x000060000c0c7625ULL, 0x000fca00078e000dULL, 0x000000060c037981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01362800790c7f8cULL, 0x0022a4000c80043fULL, 0x00000000000e7805ULL, 0x000fc40000015200ULL,
0x01362c0079157984ULL, 0x000ee40000000800ULL, 0x8000000015ff7812ULL, 0x00cfe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x000000140e177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e0fULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001714147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01362c0079157984ULL, 0x000ea40000000800ULL,
0x8000000015ff7812ULL, 0x004fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000080670c7810ULL, 0x000fca0007ffe066ULL, 0x00000001650c7824ULL, 0x000fca00078e020cULL,
0x013000000c0e7984ULL, 0x000ea80000000800ULL, 0x013200000c0f7984ULL, 0x0006620000000800ULL,
0x000000690e00720bULL, 0x004fe20003f1d000ULL, 0x0000e6f27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0c197812ULL, 0x000fe2000782c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff7a7224ULL, 0x000fd400078e0069ULL, 0x0000044000009947ULL, 0x000fea0003800000ULL,
0x00000001550d7810ULL, 0x000fe40007ffe0ffULL, 0x000000690e00720bULL, 0x000fe40003f54000ULL,
0x0000005c0d00720cULL, 0x000fe20003f25270ULL, 0x0000e6a27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000147806ULL, 0x000fc400010e0100ULL, 0x000000805c0c9824ULL, 0x000fe200078e0267ULL,
0x000000690e7a7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x00000001650d9824ULL, 0x000fe200078e020cULL, 0x00009910140c7816ULL, 0x000fc800000000ffULL,
0x0134007a0d009388ULL, 0x0005e20000000800ULL, 0x000000ff0c00720cULL, 0x000fda0003f25270ULL,
0x0000030000009947ULL, 0x000fea0003800000ULL, 0x000000697a0c7221ULL, 0x004fe20000010100ULL,
0x000000ff14ff7812ULL, 0x000fe2000782c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00157308ULL, 0x000ea40000000800ULL,
0x0000001504047220ULL, 0x004fc80000410000ULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011600ULL, 0x0000e5d27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c150c7589ULL, 0x0004e400000e0000ULL, 0x0000000c44447220ULL, 0x088fe20000410000ULL,
0x0000000c45457220ULL, 0x080fe20000410000ULL, 0x0000000c40407220ULL, 0x080fe20000410000ULL,
0x0000000c41417220ULL, 0x080fe20000410000ULL, 0x0000000c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000000c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000c38387220ULL, 0x080fe20000410000ULL,
0x0000000c39397220ULL, 0x080fe20000410000ULL, 0x0000000c34347220ULL, 0x080fe20000410000ULL,
0x0000000c35357220ULL, 0x080fe20000410000ULL, 0x0000000c30307220ULL, 0x080fe20000410000ULL,
0x0000000c31317220ULL, 0x080fe20000410000ULL, 0x0000000c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c10107220ULL, 0x080fe20000410000ULL,
0x0000000c11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0014ff7812ULL, 0x000fda000782c0ffULL, 0x0000013000009947ULL, 0x000fea0003800000ULL,
0x00000008000c7811ULL, 0x000fe200078ff0ffULL, 0x0000e4c27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c150c7589ULL, 0x0006a400000e0000ULL, 0x0000000c46467220ULL, 0x084fe20000410000ULL,
0x0000000c47477220ULL, 0x080fe20000410000ULL, 0x0000000c42427220ULL, 0x080fe20000410000ULL,
0x0000000c43437220ULL, 0x080fe20000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000000c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000000c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000c36367220ULL, 0x080fe20000410000ULL,
0x0000000c37377220ULL, 0x080fe20000410000ULL, 0x0000000c32327220ULL, 0x080fe20000410000ULL,
0x0000000c33337220ULL, 0x080fe20000410000ULL, 0x0000000c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c12127220ULL, 0x080fe20000410000ULL,
0x0000000c13137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff19ff7812ULL, 0x000fda0007826014ULL, 0x0000000e7a0e1221ULL, 0x000fe20000010100ULL,
0x000000000000181cULL, 0x000fc60003f0f070ULL, 0x3fb8aa3b0e0e1820ULL, 0x000fc80000410000ULL,
0x0000000e00071308ULL, 0x000ea40000000800ULL, 0x000000070f0f1220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000015000007945ULL, 0x000fe20003800000ULL, 0x000000040f047221ULL, 0x002fe20000010000ULL,
0x0000012000008947ULL, 0x000fea0003800000ULL, 0x00000007ff08723eULL, 0x000fe400000000ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011600ULL, 0x00005410080e7816ULL, 0x000fe20000000008ULL,
0x0000e3027f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0e097589ULL, 0x0002a400000e0000ULL,
0x000000080f0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000e3327f007947ULL, 0x000fea000b800000ULL,
0x00001f0c0e087589ULL, 0x0002e400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100f0c7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x00004f8000177802ULL, 0x000fc40000000f00ULL, 0x0000eb8000007944ULL, 0x01cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180f0c7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x004fe200078e000eULL, 0x00004fd000177802ULL, 0x000fc40000000f00ULL,
0x0000eb3000007944ULL, 0x018fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x00001000067b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff577819ULL, 0x000fe2000001165cULL, 0x009800006424783bULL, 0x000e660000000200ULL,
0x000010007b7b7812ULL, 0x000fe200078e0cffULL, 0x00000002570c7824ULL, 0x002fc400078e0258ULL,
0x0000400057687824ULL, 0x000fe400078e0270ULL, 0x000020000c0c7824ULL, 0x000fc600078e007bULL,
0x0000b00068687810ULL, 0x000fe40007ffe07bULL, 0x0000b0000c717810ULL, 0x000fe40007ffe0ffULL,
0x009800005d0c783bULL, 0x000e620000000200ULL, 0x000000106f6c7824ULL, 0x000fe400078e0268ULL,
0x0000001078757824ULL, 0x100fe400078e0271ULL, 0x0000001077737824ULL, 0x100fe200078e0271ULL,
0x000000006c20783bULL, 0x000fe20000004200ULL, 0x0000001076727824ULL, 0x000fc400078e0271ULL,
0x0000001074717824ULL, 0x000fe200078e0271ULL, 0x000000007550783bULL, 0x000ee20000004200ULL,
0x000000106e6a7824ULL, 0x100fe400078e0268ULL, 0x000000106d697824ULL, 0x100fe200078e0268ULL,
0x00000000734c783bULL, 0x000ea20000004200ULL, 0x000000106b687824ULL, 0x000fc600078e0268ULL,
0x000000007248783bULL, 0x000ea80000004200ULL, 0x000000007128783bULL, 0x000ea40000004200ULL,
0x0000000924240232ULL, 0x084fe40000000000ULL, 0x000000006a1c783bULL, 0x000ea20000004200ULL,
0x0000000926260232ULL, 0x000fe40000000000ULL, 0x0000000825250232ULL, 0x088fe20000000000ULL,
0x000000006918783bULL, 0x000ee20000004200ULL, 0x0000000827270232ULL, 0x000fc60000000000ULL,
0x000000006814783bULL, 0x000ea20000004200ULL, 0x000000090c0c0232ULL, 0x082fe40000000000ULL,
0x000000090e0e0232ULL, 0x000fe40000000000ULL, 0x000000080d0d0232ULL, 0x080fe40000000000ULL,
0x000000080f0f0232ULL, 0x000fe20000000000ULL, 0x000000502444723cULL, 0x040f700000001844ULL,
0x000000522440723cULL, 0x040f700000001840ULL, 0x0000004c243c723cULL, 0x040f70000000183cULL,
0x0000004e2438723cULL, 0x040f700000001838ULL, 0x000000482434723cULL, 0x040f700000001834ULL,
0x0000004a2430723cULL, 0x040f700000001830ULL, 0x00000028242c723cULL, 0x040f70000000182cULL,
0x0000002a2410723cULL, 0x000f700000001810ULL, 0x000000200c44723cULL, 0x060b700000001844ULL,
0x000000220c40723cULL, 0x040b700000001840ULL, 0x0000001c0c3c723cULL, 0x044b70000000183cULL,
0x0000001e0c38723cULL, 0x040b700000001838ULL, 0x000000180c34723cULL, 0x048b700000001834ULL,
0x0000001a0c30723cULL, 0x040b700000001830ULL, 0x000000140c2c723cULL, 0x040b70000000182cULL,
0x000000160c10723cULL, 0x000b620000001810ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000805e0d7811ULL, 0x020fe200078e40ffULL, 0x0136900062ff7f8cULL, 0x0003e2000c80043fULL,
0x00000001067c7812ULL, 0x000fc400078ec0ffULL, 0x0000005a0d00720cULL, 0x000fda0003f06070ULL,
0x0000378000000947ULL, 0x000fea0003800000ULL, 0x000000105c0c7824ULL, 0x002fe200078e00ffULL,
0x0000000000007918ULL, 0x000fcc0000000000ULL, 0xffffffe00c0d7812ULL, 0x000fe200078ec0ffULL,
0x0000580003037a24ULL, 0x010fe200078e02ffULL, 0x000000015e0c7810ULL, 0x000fc60007ffe0ffULL,
0x000001005e0d7824ULL, 0x000fe200078e020dULL, 0x000000590c00720cULL, 0x000fe20003f06070ULL,
0x0000004003037824ULL, 0x000fc600078e00ffULL, 0x000000c00d0f7810ULL, 0x000fc80007ffe0ffULL,
0x000000200b0d7812ULL, 0x000fca00078ef80fULL, 0x0000075000008947ULL, 0x000fea0003800000ULL,
0x000020005c147824ULL, 0x000fe200078e00ffULL, 0x00000003ff0c7819ULL, 0x000fe20000011600ULL,
0x00000008584c7824ULL, 0x000fe200078e00ffULL, 0x0000000f5a0e7217ULL, 0x000fe40007800000ULL,
0x0000200014147812ULL, 0x000fe400078ec0ffULL, 0x000000040c187810ULL, 0x000fe20007ffe0ffULL,
0x000000010e0e7824ULL, 0x000fe200078e0a0fULL, 0x0000000c0c247810ULL, 0x040fe20007ffe0ffULL,
0x0000400057167824ULL, 0x000fe200078e0214ULL, 0x000000100c267810ULL, 0x040fe20007ffe0ffULL,
0x000000010c147824ULL, 0x000fe200078e020dULL, 0x000000200e217817ULL, 0x000fe20003800000ULL,
0x0000000118207824ULL, 0x100fe200078e0200ULL, 0x0000b000167b7810ULL, 0x000fe20007ffe07bULL,
0x00000008180f7824ULL, 0x040fe200078e00ffULL, 0x0000001403147210ULL, 0x000fe20007f1e0ffULL,
0x00000001180e7824ULL, 0x000fe200078e020dULL, 0x000000080c167810ULL, 0x000fe20007ffe0ffULL,
0x0000000124257824ULL, 0x000fe200078e0200ULL, 0xfffffff80f207812ULL, 0x000fe200078ee220ULL,
0x000000ffff0f7224ULL, 0x000fe200000e06ffULL, 0x00005e00141e7a11ULL, 0x000fe200078040ffULL,
0x0000000116227824ULL, 0x000fe200078e0200ULL, 0x000000211800720cULL, 0x080fe20003f46070ULL,
0x0000000816157824ULL, 0x000fe200078e00ffULL, 0x00005f00141f7a11ULL, 0x000fe200000f440fULL,
0x0000000124147824ULL, 0x100fe200078e020dULL, 0x0000000e030f7210ULL, 0x040fe20007f1e0ffULL,
0x00000001160e7824ULL, 0x140fe200078e020dULL, 0x000000211600720cULL, 0x000fe20003f26070ULL,
0x0000000126167824ULL, 0x000fe200078e020dULL, 0x0000001403147210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff187224ULL, 0x000fe200000e06ffULL, 0x0000000e03177210ULL, 0x000fe20007f7e0ffULL,
0x00000008244e7824ULL, 0x000fe200078e00ffULL, 0x00005e000f1c7a11ULL, 0x000fc400078040ffULL,
0x00000016030e7210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff287224ULL, 0x000fe200018e06ffULL,
0x00005f000f1d7a11ULL, 0x000fe400000f4418ULL, 0x00005e00171a7a11ULL, 0x000fe200078040ffULL,
0x000000ffff0f7224ULL, 0x000fe200028e06ffULL, 0xfffffff815227812ULL, 0x000fe200078ee222ULL,
0x000000ffff157224ULL, 0x000fe200020e06ffULL, 0x00005f00171b7a11ULL, 0x000fe400000f4428ULL,
0x00005e000e167a11ULL, 0x000fc400078840ffULL, 0x000000140c287810ULL, 0x000fe40007ffe0ffULL,
0x00005f000e177a11ULL, 0x000fe200020f440fULL, 0x000000010c0f7824ULL, 0x100fe200078e0200ULL,
0x00005e0014187a11ULL, 0x000fe200078640ffULL, 0x00000001280e7824ULL, 0x000fe200078e020dULL,
0x000000180c487810ULL, 0x040fe40007ffe0ffULL, 0x0000001c0c2a7810ULL, 0x000fe40007ffe0ffULL,
0x00005f0014197a11ULL, 0x000fe200018f4415ULL, 0x0000000148277824ULL, 0x000fe200078e0200ULL,
0x000000210c00720cULL, 0x000fe20003f66070ULL, 0x00000001480c7824ULL, 0x100fe200078e020dULL,
0x0000000e03157210ULL, 0x000fe20007f1e0ffULL, 0x000000012a0e7824ULL, 0x000fe200078e020dULL,
0x000000070f237812ULL, 0x000fc400078ec0ffULL, 0x0000000c030f7210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200000e06ffULL, 0x0000000e030d7210ULL, 0x000fe40007fbe0ffULL,
0x00005e0015147a11ULL, 0x000fe400078040ffULL, 0x0ffffff8230c7812ULL, 0x000fe400078ef800ULL,
0x000000084c037812ULL, 0x000fe200078ee25fULL, 0x000000ffff4c7224ULL, 0x000fe200020e06ffULL,
0x00005f0015157a11ULL, 0x000fe200000f444aULL, 0x000000100c237824ULL, 0x000fe200078e027bULL,
0x00005e000f0e7a11ULL, 0x000fe200078840ffULL, 0x000000ffff4a7224ULL, 0x000fe200028e06ffULL,
0x00005e000d0c7a11ULL, 0x000fe200078a40ffULL, 0x00000010031e7825ULL, 0x000fe200078e001eULL,
0x00005f000f0f7a11ULL, 0x000fc400020f444cULL, 0x00005f000d0d7a11ULL, 0x000fe200028f444aULL,
0x00000010031c7825ULL, 0x040fe200078e001cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e237faeULL, 0x0003e2000d901c46ULL, 0x000000212400720cULL, 0x080fe40003f06070ULL,
0x000000212600720cULL, 0x080fe20003f66070ULL, 0x00000010031a7825ULL, 0x000fe200078e001aULL,
0x000000212800720cULL, 0x080fe40003f86070ULL, 0x000000214800720cULL, 0x0c0fe20003fa6070ULL,
0x0000000848487824ULL, 0x000fe200078e00ffULL, 0x000000212a00720cULL, 0x000fe20003fc6070ULL,
0x0000000126217824ULL, 0x000fe200078e0200ULL, 0xfffffff84e247812ULL, 0x000fe200078ee225ULL,
0x0000000826267824ULL, 0x000fc400078e00ffULL, 0x0000000128257824ULL, 0x100fe400078e0200ULL,
0x000000012a1f7824ULL, 0x002fe200078e0200ULL, 0xfffffff8261e7812ULL, 0x000fe200078ee221ULL,
0x0000000828287824ULL, 0x000fe400078e00ffULL, 0x000000082a2a7824ULL, 0x000fe400078e00ffULL,
0x0000001022217824ULL, 0x000fe200078e027bULL, 0xfffffff828267812ULL, 0x000fe200078ee225ULL,
0x0000001024237824ULL, 0x000fe200078e027bULL, 0xfffffff82a2a7812ULL, 0x000fe200078ee21fULL,
0x00000010201f7824ULL, 0x000fe200078e027bULL, 0xfffffff848287812ULL, 0x000fe200078ee227ULL,
0x0000001003187825ULL, 0x000fc600078e0018ULL, 0x000000001c1f7faeULL, 0x0003e2000d101c46ULL,
0x000000101e257824ULL, 0x000fe400078e027bULL, 0x0000001003167825ULL, 0x040fe200078e0016ULL,
0x000000001a217faeULL, 0x0003e6000c901c46ULL, 0x0000001026277824ULL, 0x000fe200078e027bULL,
0x0000000018237faeULL, 0x0003e2000c101c46ULL, 0x0000001003147825ULL, 0x000fc600078e0014ULL,
0x0000000016257faeULL, 0x0003e2000d901c46ULL, 0x0000001028297824ULL, 0x000fe400078e027bULL,
0x00000010030e7825ULL, 0x040fe200078e000eULL, 0x0000000014277faeULL, 0x0003e6000e101c46ULL,
0x000000102a7b7824ULL, 0x000fe200078e027bULL, 0x000000000e297faeULL, 0x0003e2000e901c46ULL,
0x00000010030c7825ULL, 0x000fca00078e000cULL, 0x000000000c7b7faeULL, 0x0003e2000f101c46ULL,
0x0000068000007947ULL, 0x000fea0003800000ULL, 0x000020005c0c7824ULL, 0x000fe200078e00ffULL,
0x00000004000e7811ULL, 0x000fe200078fe8ffULL, 0x0000000858487824ULL, 0x000fe200078e00ffULL,
0x0000000c00157811ULL, 0x000fe400078fe8ffULL, 0x000020000c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000010e227824ULL, 0x000fe200078e0200ULL, 0x0000000800147811ULL, 0x000fe200078fe8ffULL,
0x000000080e0f7824ULL, 0x000fe200078e00ffULL, 0x00000018001c7811ULL, 0x040fe200078fe8ffULL,
0x0000400057287824ULL, 0x000fe200078e020cULL, 0x0000000d000c7211ULL, 0x000fe200078fe8ffULL,
0x0000000115257824ULL, 0x000fe200078e0200ULL, 0xfffffff80f227812ULL, 0x000fe200078ee222ULL,
0x0000000815187824ULL, 0x000fe200078e00ffULL, 0x0000000c030c7210ULL, 0x040fe20007f1e0ffULL,
0x0000000114217824ULL, 0x100fe200078e0200ULL, 0x00000014001a7811ULL, 0x000fe200078fe8ffULL,
0x0000000814167824ULL, 0x000fe200078e00ffULL, 0xfffffff818257812ULL, 0x000fe200078ee225ULL,
0x000000ffff0f7224ULL, 0x000fe200000e06ffULL, 0x00005e000c187a11ULL, 0x000fe200078040ffULL,
0x000000011c1b7824ULL, 0x100fe200078e0200ULL, 0xfffffff816217812ULL, 0x000fe200078ee221ULL,
0x000000081c247824ULL, 0x000fe200078e00ffULL, 0x0000001000167811ULL, 0x000fe200078fe8ffULL,
0x000000011a207824ULL, 0x100fe200078e0200ULL, 0x00005f000c197a11ULL, 0x000fe200000f440fULL,
0x000000010e0c7824ULL, 0x100fe200078e020dULL, 0x0000001c000f7811ULL, 0x000fe200078fe8ffULL,
0x00000001140e7824ULL, 0x000fe200078e020dULL, 0xfffffff8241b7812ULL, 0x000fe200078ee21bULL,
0x0000000116277824ULL, 0x040fe200078e0200ULL, 0x0000000c030c7210ULL, 0x000fe20007f9e0ffULL,
0x00000008161e7824ULL, 0x000fe200078e00ffULL, 0x0000b00028287810ULL, 0x000fe20007ffe07bULL,
0x000000081a177824ULL, 0x000fe200078e00ffULL, 0x0000000848237812ULL, 0x000fe200078ee25fULL,
0x0000000115147824ULL, 0x100fe200078e020dULL, 0x0000000e03157210ULL, 0x000fe20007f7e0ffULL,
0x0000000116167824ULL, 0x100fe200078e020dULL, 0xfffffff817207812ULL, 0x000fe200078ee220ULL,
0x000000011a1a7824ULL, 0x000fe200078e020dULL, 0xfffffff81e277812ULL, 0x000fe200078ee227ULL,
0x000000010f247824ULL, 0x000fc400078e020dULL, 0x000000010f267824ULL, 0x000fe200078e0200ULL,
0x0000001a031d7210ULL, 0x000fe20007f5e0ffULL, 0x000000080f1f7824ULL, 0x000fe200078e00ffULL,
0x00000014030f7210ULL, 0x040fe20007f1e0ffULL, 0x000000011c1c7824ULL, 0x000fe200078e020dULL,
0x00000016030d7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff177224ULL, 0x000fe200020e06ffULL,
0x00005e000c167a11ULL, 0x040fe200078c40ffULL, 0x000000ffff2a7224ULL, 0x000fe200018e06ffULL,
0x0000001c031a7210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff1e7224ULL, 0x000fe200000e06ffULL,
0xfffffff81f267812ULL, 0x000fe200078ee226ULL, 0x000000ffff1c7224ULL, 0x000fe200008e06ffULL,
0x00005e0015147a11ULL, 0x000fe200078640ffULL, 0x0000001023187825ULL, 0x000fe200078e0018ULL,
0x00005f000c177a11ULL, 0x000fc400030f4417ULL, 0x00005e000f0e7a11ULL, 0x000fe200078040ffULL,
0x000000101b497824ULL, 0x000fe200078e0228ULL, 0x00000000001f7211ULL, 0x000fe200078fe8ffULL,
0x0000001023167825ULL, 0x000fe200078e0016ULL, 0x00005e000d0c7a11ULL, 0x000fe400078240ffULL,
0x00005f0015157a11ULL, 0x000fe200018f442aULL, 0x000000ffff2a7224ULL, 0x000fe200010e06ffULL,
0x0000002403247210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff037224ULL, 0x000fe200020e06ffULL,
0x00005f000f0f7a11ULL, 0x000fe200000f441eULL, 0x0000001021217824ULL, 0x000fe200078e0228ULL,
0x000000071f297812ULL, 0x000fe200078ec0ffULL, 0x000000ffff4d7224ULL, 0x000fe200028e06ffULL,
0x00005f000d0d7a11ULL, 0x000fe200008f441cULL, 0x0000001023147825ULL, 0x000fe200078e0014ULL,
0x00005e001d1e7a11ULL, 0x000fc400078040ffULL, 0x00005e001a1c7a11ULL, 0x040fe200078240ffULL,
0x0000001025257824ULL, 0x000fe200078e0228ULL, 0x0ffffff829297812ULL, 0x000fe200078ef800ULL,
0x00000010230e7825ULL, 0x000fe200078e000eULL, 0x00005f001d1f7a11ULL, 0x000fe400000f442aULL,
0x00005f001a1d7a11ULL, 0x000fe200008f4403ULL, 0x0000001029297824ULL, 0x100fe200078e0228ULL,
0x00005e00241a7a11ULL, 0x000fe200078040ffULL, 0x0000001022037824ULL, 0x100fe400078e0228ULL,
0x0000001027277824ULL, 0x000fe200078e0228ULL, 0x00005f00241b7a11ULL, 0x000fe200000f444dULL,
0x00000010230c7825ULL, 0x040fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018297faeULL, 0x0003e6000b901c46ULL, 0x00000010202b7824ULL, 0x000fe200078e0228ULL,
0x0000000016037faeULL, 0x0003e2000b901c46ULL, 0x00000010231e7825ULL, 0x000fc600078e001eULL,
0x0000000014217faeULL, 0x0003e2000b901c46ULL, 0x00000010231c7825ULL, 0x000fc600078e001cULL,
0x000000000e257faeULL, 0x0003e2000b901c46ULL, 0x00000010264b7824ULL, 0x000fe400078e0228ULL,
0x00000010231a7825ULL, 0x000fe200078e001aULL, 0x000000000c277faeULL, 0x0003e8000b901c46ULL,
0x000000001e2b7faeULL, 0x0003e8000b901c46ULL, 0x000000001c497faeULL, 0x0003e8000b901c46ULL,
0x000000001a4b7faeULL, 0x0003e4000b901c46ULL, 0x0000000302037812ULL, 0x002fc800078ec0ffULL,
0x000000030300780cULL, 0x000fc80003f05270ULL, 0x000000010a037807ULL, 0x000fca0004000000ULL,
0x0000000102027824ULL, 0x000fe400078e0203ULL, 0xffffffffff037424ULL, 0x000fc600078e00ffULL,
0x0000005b0200720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00000001050c7824ULL, 0x000fe400078e0202ULL, 0x00000004ff0d7424ULL, 0x000fc800078e00ffULL,
0x000060000c0c7625ULL, 0x000fca00078e000dULL, 0x000000060c037981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01364800790c7f8cULL, 0x0022a4000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0xffffffe056797812ULL, 0x042fe400078ec0ffULL, 0x00000010560e7812ULL, 0x040fe400078ec0ffULL,
0x00000008560f7812ULL, 0x000fc800078ec0ffULL, 0x000000790f797210ULL, 0x000fca0007ffe00eULL,
0x01364c00790f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x006fe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000e7805ULL, 0x000fcc0000015200ULL, 0x0000000e14177210ULL, 0x000fca0007f1e1ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0e15ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff0f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff0f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc8000001140fULL,
0x000000170e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e060fULL,
0x000000020e0e7819ULL, 0x000fc8000000120fULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01364c00790f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000100670c7810ULL, 0x000fca0007ffe066ULL, 0x00000001650c7824ULL, 0x000fca00078e020cULL,
0x013000000c0f7984ULL, 0x000e680000000800ULL, 0x013200000c0e7984ULL, 0x0004e20000000800ULL,
0x0000007a0f00720bULL, 0x002fe20003f1d000ULL, 0x0000cc827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x004fc800000e0100ULL, 0x0000ffff14ff7812ULL, 0x000fe2000782c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff7b7224ULL, 0x000fd400078e007aULL, 0x0000045000009947ULL, 0x000fea0003800000ULL,
0x00000002550d7810ULL, 0x000fe40007ffe0ffULL, 0x0000007a0f00720bULL, 0x000fe40003f34000ULL,
0x0000005c0d00720cULL, 0x000fe20003f05270ULL, 0x0000cc327f007947ULL, 0x000fd4000b800000ULL,
0x0000000000157806ULL, 0x000fc400008e0100ULL, 0x000000805c168824ULL, 0x000fe200078e0267ULL,
0x0000000f7a0c8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x00009910150d7816ULL, 0x000fe200000000ffULL, 0x0000000165178824ULL, 0x000fca00078e0216ULL,
0x0134000c17008388ULL, 0x0003e20000000800ULL, 0x000000ff0d00720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000f7a0d7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff15ff7812ULL, 0x000fc6000780c0ffULL,
0x8000000d7a0c7221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL,
0x0000000c00197308ULL, 0x000e640000000800ULL, 0x0000001904047220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0c7819ULL, 0x000fe20000011600ULL,
0x0000cb427f007947ULL, 0x000fea000b800000ULL, 0x00001f0c190c7589ULL, 0x0002a400000e0000ULL,
0x0000000c44447220ULL, 0x084fe20000410000ULL, 0x0000000c45457220ULL, 0x080fe20000410000ULL,
0x0000000c40407220ULL, 0x080fe20000410000ULL, 0x0000000c41417220ULL, 0x080fe20000410000ULL,
0x0000000c3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000c3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000c38387220ULL, 0x080fe20000410000ULL, 0x0000000c39397220ULL, 0x080fe20000410000ULL,
0x0000000c34347220ULL, 0x080fe20000410000ULL, 0x0000000c35357220ULL, 0x080fe20000410000ULL,
0x0000000c30307220ULL, 0x080fe20000410000ULL, 0x0000000c31317220ULL, 0x080fe20000410000ULL,
0x0000000c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000c10107220ULL, 0x080fe20000410000ULL, 0x0000000c11117220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008000c7811ULL, 0x000fe200078ff0ffULL,
0x0000ca327f007947ULL, 0x000fea000b800000ULL, 0x00001f0c190c7589ULL, 0x00046400000e0000ULL,
0x0000000c46467220ULL, 0x082fe20000410000ULL, 0x0000000c47477220ULL, 0x080fe20000410000ULL,
0x0000000c42427220ULL, 0x080fe20000410000ULL, 0x0000000c43437220ULL, 0x080fe20000410000ULL,
0x0000000c3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000c3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000c3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000c36367220ULL, 0x080fe20000410000ULL, 0x0000000c37377220ULL, 0x080fe20000410000ULL,
0x0000000c32327220ULL, 0x080fe20000410000ULL, 0x0000000c33337220ULL, 0x080fe20000410000ULL,
0x0000000c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000c12127220ULL, 0x080fe20000410000ULL, 0x0000000c13137220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff15ff7812ULL, 0x000fe40007800814ULL,
0x0000000f7a7b7209ULL, 0x000fd60007810000ULL, 0x8000007b0f0f0221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL, 0x0000000f00070308ULL, 0x000e640000000800ULL,
0x000000070e0e0220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x000000040e047221ULL, 0x008fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000000ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011600ULL,
0x00005410080e7816ULL, 0x000fe20000000008ULL, 0x0000c8727f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0e097589ULL, 0x0002e400000e0000ULL, 0x000000080f0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000c8a27f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0e087589ULL, 0x0002a400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100f0c7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x000fe200078e000eULL, 0x00006bf000177802ULL, 0x000fc40000000f00ULL,
0x0000cf1000007944ULL, 0x01cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180f0c7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff167224ULL, 0x004fe200078e000eULL,
0x00006c4000177802ULL, 0x000fc40000000f00ULL, 0x0000cec000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x00001000060c7824ULL, 0x002fe200078e00ffULL, 0x00000001ff577819ULL, 0x000fe2000001165cULL,
0x00a000006424783bULL, 0x000e660000000200ULL, 0x000010000c157812ULL, 0x000fe200078ec0ffULL,
0x00000002570c7824ULL, 0x000fc400078e0258ULL, 0x0000400057147824ULL, 0x000fe400078e0270ULL,
0x000020000c0c7824ULL, 0x000fc600078e0015ULL, 0x0000b00014147810ULL, 0x000fe40007ffe015ULL,
0x0000b0000c0d7810ULL, 0x000fc60007ffe0ffULL, 0x000000106f207824ULL, 0x100fe400078e0214ULL,
0x0000001078507824ULL, 0x100fe400078e020dULL, 0x00000010774c7824ULL, 0x100fe400078e020dULL,
0x0000001076487824ULL, 0x100fe200078e020dULL, 0x000000002020783bULL, 0x000fe20000004200ULL,
0x0000001074287824ULL, 0x000fe400078e020dULL, 0x000000106e1c7824ULL, 0x100fe200078e0214ULL,
0x000000005050783bULL, 0x000ee20000004200ULL, 0x000000106d187824ULL, 0x000fc400078e0214ULL,
0x000000106b147824ULL, 0x000fe200078e0214ULL, 0x000000004c4c783bULL, 0x000ea80000004200ULL,
0x000000004848783bULL, 0x000fe80000004200ULL, 0x000000002828783bULL, 0x000fe20000004200ULL,
0x0000000924240232ULL, 0x00afc40000000000ULL, 0x0000000926260232ULL, 0x080fe20000000000ULL,
0x00a000005d0c783bULL, 0x000e620000000200ULL, 0x0000000825250232ULL, 0x084fe40000000000ULL,
0x0000000827270232ULL, 0x000fe20000000000ULL, 0x000000001c1c783bULL, 0x000ea80000004200ULL,
0x000000001818783bULL, 0x000ee80000004200ULL, 0x000000001414783bULL, 0x000ea20000004200ULL,
0x000000502444723cULL, 0x040f700000001844ULL, 0x000000522440723cULL, 0x040f700000001840ULL,
0x0000004c243c723cULL, 0x000f62000000183cULL, 0x000000090c0c0232ULL, 0x002fc40000000000ULL,
0x000000090e0e0232ULL, 0x000fe40000000000ULL, 0x000000080d0d0232ULL, 0x080fe40000000000ULL,
0x000000080f0f0232ULL, 0x000fe20000000000ULL, 0x0000004e2438723cULL, 0x040f700000001838ULL,
0x000000482434723cULL, 0x040f700000001834ULL, 0x0000004a2430723cULL, 0x040f700000001830ULL,
0x00000028242c723cULL, 0x040f70000000182cULL, 0x0000002a2410723cULL, 0x000f700000001810ULL,
0x000000200c44723cULL, 0x060b700000001844ULL, 0x000000220c40723cULL, 0x040b700000001840ULL,
0x0000001c0c3c723cULL, 0x044b70000000183cULL, 0x0000001e0c38723cULL, 0x040b700000001838ULL,
0x000000180c34723cULL, 0x048b700000001834ULL, 0x0000001a0c30723cULL, 0x040b700000001830ULL,
0x000000140c2c723cULL, 0x040b70000000182cULL, 0x000000160c10723cULL, 0x000b620000001810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fce0000008000ULL, 0x000000c05e0d7811ULL, 0x020fe200078e40ffULL,
0x0136980062ff7f8cULL, 0x0003e2000c80043fULL, 0x00000001067c7812ULL, 0x000fe200078e0cffULL,
0x000000ffff7a7224ULL, 0x000fe200078e007bULL, 0x0000005a0d00720cULL, 0x000fda0003f06070ULL,
0x00001b0000000947ULL, 0x000fea0003800000ULL, 0x000003005e0d7a10ULL, 0x002fe20007ffe0ffULL,
0x0000580003037a24ULL, 0x010fe200078e02ffULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x000000010d0c7810ULL, 0x040fe20007ffe0ffULL, 0x000001000d0d7824ULL, 0x000fe400078e0254ULL,
0x0000004003037824ULL, 0x000fe200078e00ffULL, 0x000000590c00720cULL, 0x000fe40003f06070ULL,
0x000000200b197812ULL, 0x000fd600078ef80dULL, 0x0000077000008947ULL, 0x000fea0003800000ULL,
0x000020005c0e7824ULL, 0x000fe200078e00ffULL, 0x0000000d5a0c7217ULL, 0x000fe20007800000ULL,
0x0000000858147824ULL, 0x000fe200078e00ffULL, 0x00000003ff1d7819ULL, 0x000fe40000011600ULL,
0x000020000e0e7812ULL, 0x000fe200078ec0ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a0dULL,
0x000000041d0f7810ULL, 0x000fe20007ffe0ffULL, 0x00001000060d7824ULL, 0x000fe200078e00ffULL,
0x00000008145f7812ULL, 0x000fe200078ee25fULL, 0x0000400057207824ULL, 0x000fe200078e020eULL,
0x000000081d157810ULL, 0x040fe20007ffe0ffULL, 0x000000011d0e7824ULL, 0x000fe200078e0219ULL,
0x000010000d0d7812ULL, 0x000fe200078ec0ffULL, 0x000000010f217824ULL, 0x140fe200078e0200ULL,
0x000000200c227817ULL, 0x000fe20003800000ULL, 0x000000080f147824ULL, 0x000fe200078e00ffULL,
0x0000000e030e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000115237824ULL, 0x000fe200078e0200ULL,
0x0000b00020207810ULL, 0x000fe20007ffe00dULL, 0x000000010f0c7824ULL, 0x000fe200078e0219ULL,
0xfffffff814217812ULL, 0x000fe200078ee221ULL, 0x0000000815147824ULL, 0x000fe200078e00ffULL,
0x0000000c1d1b7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x00005e000e1e7a11ULL, 0x000fe200078040ffULL, 0x0000001021217824ULL, 0x000fe200078e0220ULL,
0x000000101d257810ULL, 0x000fe20007ffe0ffULL, 0x000000011b287824ULL, 0x040fe200078e0200ULL,
0xfffffff814237812ULL, 0x000fe200078ee223ULL, 0x000000011b147824ULL, 0x000fe200078e0219ULL,
0x00005f000e1f7a11ULL, 0x000fe200000f440dULL, 0x00000001150e7824ULL, 0x100fe200078e0219ULL,
0x0000000c030d7210ULL, 0x000fe20007f1e0ffULL, 0x0000000125167824ULL, 0x000fe200078e0219ULL,
0x000000220f00720cULL, 0x080fe20003f46070ULL, 0x000000105f1e7825ULL, 0x000fe200078e001eULL,
0x000000221500720cULL, 0x000fc40003f26070ULL, 0x0000000e030f7210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff187224ULL, 0x000fe200000e06ffULL, 0x0000001403157210ULL, 0x000fe20007f9e0ffULL,
0x000000081b297824ULL, 0x000fe200078e00ffULL, 0x00005e000d0c7a11ULL, 0x000fe200078040ffULL,
0x000000ffff1c7224ULL, 0x000fe200018e06ffULL, 0x0000001603177210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff1a7224ULL, 0x000fe200020e06ffULL, 0x00005f000d0d7a11ULL, 0x000fe200000f4418ULL,
0x0000001023237824ULL, 0x000fe200078e0220ULL, 0x00005e0015147a11ULL, 0x000fe200078640ffULL,
0x000000ffff187224ULL, 0x000fe200028e06ffULL, 0x00005e0017167a11ULL, 0x000fe200078840ffULL,
0x000000105f0c7825ULL, 0x000fe200078e000cULL, 0x000000141d2b7810ULL, 0x000fc40007ffe0ffULL,
0x00005f0015157a11ULL, 0x000fe200018f441aULL, 0x000000011d1a7824ULL, 0x000fe200078e0200ULL,
0x00005f0017177a11ULL, 0x000fe200020f4418ULL, 0x000000012b187824ULL, 0x000fe200078e0219ULL,
0x00005e000f0e7a11ULL, 0x000fe200078040ffULL, 0x000000105f147825ULL, 0x000fe200078e0014ULL,
0x000000181d497810ULL, 0x040fe40007ffe0ffULL, 0x0000001c1d4b7810ULL, 0x000fe20007ffe0ffULL,
0x000000105f167825ULL, 0x000fe200078e0016ULL, 0x00005f000f0f7a11ULL, 0x000fc400000f441cULL,
0x000000071a277812ULL, 0x000fe200078ec0ffULL, 0x00000001491a7824ULL, 0x100fe200078e0219ULL,
0x0000001803247210ULL, 0x000fe20007f1e0ffULL, 0x000000014b1c7824ULL, 0x000fe200078e0219ULL,
0x000000221d00720cULL, 0x000fe20003f66070ULL, 0x000000105f0e7825ULL, 0x000fe200078e000eULL,
0x0000001a031d7210ULL, 0x040fe40007f9e0ffULL, 0x0000001c03037210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff197224ULL, 0x000fe200000e06ffULL, 0x00005e0024187a11ULL, 0x000fe200078040ffULL,
0x000000ffff267224ULL, 0x000fe200020e06ffULL, 0x0ffffff827277812ULL, 0x000fc400078ef800ULL,
0x00005f0024197a11ULL, 0x000fe200000f4419ULL, 0x000000ffff247224ULL, 0x000fe200028e06ffULL,
0x00005e001d1a7a11ULL, 0x000fe200078840ffULL, 0x0000001027277824ULL, 0x000fe200078e0220ULL,
0x00005e00031c7a11ULL, 0x000fe200078a40ffULL, 0x000000105f187825ULL, 0x000fe200078e0018ULL,
0x000000221b00720cULL, 0x080fe40003f06070ULL, 0x00005f001d1b7a11ULL, 0x000fe200020f4426ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e277faeULL, 0x0003e2000d901c46ULL,
0x00005f00031d7a11ULL, 0x000fe200028f4424ULL, 0x0000000125037824ULL, 0x140fe200078e0200ULL,
0x000000222500720cULL, 0x0c0fe20003f66070ULL, 0x0000000825267824ULL, 0x000fe200078e00ffULL,
0x000000222b00720cULL, 0x080fe20003f86070ULL, 0x0000000149247824ULL, 0x140fe200078e0200ULL,
0x000000224900720cULL, 0x0c0fe20003fa6070ULL, 0x0000000849257824ULL, 0x000fe200078e00ffULL,
0x000000224b00720cULL, 0x000fe20003fc6070ULL, 0x000000012b227824ULL, 0x000fe200078e0200ULL,
0xfffffff829297812ULL, 0x000fe200078ee228ULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff826037812ULL, 0x000fe200078ee203ULL, 0x000000014b1e7824ULL, 0x002fe200078e0200ULL,
0xfffffff825257812ULL, 0x000fe200078ee224ULL, 0x000000084b277824ULL, 0x000fe200078e00ffULL,
0xfffffff82b1f7812ULL, 0x000fe200078ee222ULL, 0x0000001029297824ULL, 0x100fe200078e0220ULL,
0x000000000c217faeULL, 0x0003e2000d101c46ULL, 0x0000001003037824ULL, 0x000fe200078e0220ULL,
0xfffffff827277812ULL, 0x000fe200078ee21eULL, 0x000000101f1f7824ULL, 0x100fe200078e0220ULL,
0x000000000e237faeULL, 0x0003e2000c901c46ULL, 0x0000001025257824ULL, 0x000fc400078e0220ULL,
0x000000105f1a7825ULL, 0x000fe200078e001aULL, 0x0000000014297faeULL, 0x0003e6000c101c46ULL,
0x0000001027277824ULL, 0x000fe200078e0220ULL, 0x0000000016037faeULL, 0x0003e2000d901c46ULL,
0x000000105f1c7825ULL, 0x000fc600078e001cULL, 0x00000000181f7faeULL, 0x0003e8000e101c46ULL,
0x000000001a257faeULL, 0x0003e8000e901c46ULL, 0x000000001c277faeULL, 0x0003e2000f101c46ULL,
0x000006a000007947ULL, 0x000fea0003800000ULL, 0x00000008580c7824ULL, 0x000fe200078e00ffULL,
0x00000008000f7811ULL, 0x000fe200078fe8ffULL, 0x000020005c267824ULL, 0x000fe200078e00ffULL,
0x00000004000e7811ULL, 0x000fe200078fe8ffULL, 0x0000100006257824ULL, 0x000fe200078e00ffULL,
0x000000080c5f7812ULL, 0x000fe200078ee25fULL, 0x000000010f227824ULL, 0x140fe200078e0200ULL,
0x00000019000c7211ULL, 0x040fe200078fe8ffULL, 0x000000080f0d7824ULL, 0x000fe200078e00ffULL,
0x0000000c00147811ULL, 0x000fe200078fe8ffULL, 0x000000010e237824ULL, 0x040fe200078e0200ULL,
0x0000000c030c7210ULL, 0x000fe20007f1e0ffULL, 0x000000080e167824ULL, 0x000fe200078e00ffULL,
0xfffffff80d227812ULL, 0x000fe200078ee222ULL, 0x0000000114217824ULL, 0x100fe200078e0200ULL,
0x00000018001a7811ULL, 0x000fe200078fe8ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e06ffULL,
0x00005e000c1e7a11ULL, 0x000fe200078040ffULL, 0x0000000814187824ULL, 0x000fe200078e00ffULL,
0xfffffff816237812ULL, 0x000fe200078ee223ULL, 0x0000000114147824ULL, 0x000fe200078e0219ULL,
0x00005f000c1f7a11ULL, 0x000fe200000f440dULL, 0x000000010e0c7824ULL, 0x100fe200078e0219ULL,
0x0000001000167811ULL, 0x000fe200078fe8ffULL, 0x000000010f0e7824ULL, 0x000fe200078e0219ULL,
0xfffffff818217812ULL, 0x000fe200078ee221ULL, 0x000000011a1d7824ULL, 0x100fe200078e0200ULL,
0x0000001400187811ULL, 0x000fe200078fe8ffULL, 0x0000000116247824ULL, 0x140fe200078e0200ULL,
0x0000000c030d7210ULL, 0x040fe20007f7e0ffULL, 0x0000000816157824ULL, 0x000fe200078e00ffULL,
0x0000200026267812ULL, 0x000fe200078ec0ffULL, 0x000000081a1c7824ULL, 0x000fe200078e00ffULL,
0x0000001c00277811ULL, 0x000fe200078fe8ffULL, 0x0000000118207824ULL, 0x040fe200078e0200ULL,
0x0000000e030f7210ULL, 0x000fe20007f3e0ffULL, 0x0000000818177824ULL, 0x040fe200078e00ffULL,
0xfffffff815247812ULL, 0x000fe200078ee224ULL, 0x0000000118187824ULL, 0x100fe200078e0219ULL,
0x0000001403157210ULL, 0x000fe20007f1e0ffULL, 0x0000000116167824ULL, 0x100fe200078e0219ULL,
0x00005e000d0c7a11ULL, 0x000fe200078c40ffULL, 0x000000011a1a7824ULL, 0x000fe200078e0219ULL,
0x0000100025257812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0e7224ULL, 0x000fe200018e06ffULL,
0xfffffff81c1d7812ULL, 0x000fe200078ee21dULL, 0x0000400057267824ULL, 0x000fe200078e0226ULL,
0xfffffff817207812ULL, 0x000fe200078ee220ULL, 0x00000001271c7824ULL, 0x000fe200078e0219ULL,
0x0000001803197210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff187224ULL, 0x000fe200008e06ffULL,
0x0000001603177210ULL, 0x000fe20007f5e0ffULL, 0x00000008274b7824ULL, 0x000fe200078e00ffULL,
0x0000001a031b7210ULL, 0x000fe20007fbe0ffULL, 0x00000001271a7824ULL, 0x000fe200078e0200ULL,
0x00005f000d0d7a11ULL, 0x000fe200030f440eULL, 0x000000ffff167224ULL, 0x000fe200000e06ffULL,
0x0000b000262a7810ULL, 0x000fe20007ffe025ULL, 0x000000ffff267224ULL, 0x000fe200020e06ffULL,
0x00005e000f0e7a11ULL, 0x000fe200078240ffULL, 0x000000ffff287224ULL, 0x000fe200010e06ffULL,
0x0000000000257211ULL, 0x000fe200078fe8ffULL, 0x000000105f1e7825ULL, 0x000fe200078e001eULL,
0x00005e0015147a11ULL, 0x000fc400078040ffULL, 0x0000001c03037210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1c7224ULL, 0x000fe200028e06ffULL, 0x00005f000f0f7a11ULL, 0x000fe200008f4418ULL,
0x0000001023237824ULL, 0x100fe200078e022aULL, 0x0000000725257812ULL, 0x000fe200078ec0ffULL,
0x000000101d497824ULL, 0x000fe200078e022aULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee21aULL,
0x000000105f0c7825ULL, 0x000fe200078e000cULL, 0x00005f0015157a11ULL, 0x000fe400000f4416ULL,
0x00005e0019187a11ULL, 0x000fe200078240ffULL, 0x0000001022277824ULL, 0x000fe200078e022aULL,
0x00005e0017167a11ULL, 0x000fe200078040ffULL, 0x000000105f0e7825ULL, 0x000fe200078e000eULL,
0x00005e001b1a7a11ULL, 0x000fc400078440ffULL, 0x0ffffff825257812ULL, 0x000fe200078ef800ULL,
0x0000001021217824ULL, 0x000fe200078e022aULL, 0x00005f0019197a11ULL, 0x000fe200008f4426ULL,
0x000000ffff267224ULL, 0x000fe200018e06ffULL, 0x00005f0017177a11ULL, 0x000fe200000f4428ULL,
0x0000001025257824ULL, 0x000fe200078e022aULL, 0x00005f001b1b7a11ULL, 0x000fe200010f441cULL,
0x000000105f147825ULL, 0x000fe200078e0014ULL, 0x00005e00031c7a11ULL, 0x040fe400078040ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e257faeULL, 0x0003e2000b901c46ULL,
0x0000001024297824ULL, 0x000fe200078e022aULL, 0x00005f00031d7a11ULL, 0x000fe200000f4426ULL,
0x000000105f167825ULL, 0x040fe200078e0016ULL, 0x000000000c237faeULL, 0x0003e6000b901c46ULL,
0x00000010202b7824ULL, 0x000fe200078e022aULL, 0x000000000e277faeULL, 0x0003e2000b901c46ULL,
0x000000105f187825ULL, 0x000fc600078e0018ULL, 0x0000000014217faeULL, 0x0003e2000b901c46ULL,
0x000000105f1a7825ULL, 0x000fc600078e001aULL, 0x0000000016297faeULL, 0x0003e2000b901c46ULL,
0x000000104b4b7824ULL, 0x000fe400078e022aULL, 0x000000105f1c7825ULL, 0x000fe200078e001cULL,
0x00000000182b7faeULL, 0x0003e8000b901c46ULL, 0x000000001a497faeULL, 0x0003e8000b901c46ULL,
0x000000001c4b7faeULL, 0x0003e4000b901c46ULL, 0x0000000302037812ULL, 0x002fc800078ec0ffULL,
0x000000030300780cULL, 0x000fc80003f05270ULL, 0x000000010a037807ULL, 0x000fca0004000000ULL,
0x0000000102027824ULL, 0x000fe400078e0203ULL, 0xffffffffff037424ULL, 0x000fc600078e00ffULL,
0x0000005b0200720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x00000001050c7824ULL, 0x000fe400078e0202ULL, 0x00000004ff0d7424ULL, 0x000fc800078e00ffULL,
0x000060000c0c7625ULL, 0x000fca00078e000dULL, 0x000000060c037981ULL, 0x000324000c1e1900ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01366800790c7f8cULL, 0x0022a4000c80043fULL, 0x00000000000e7805ULL, 0x000fc40000015200ULL,
0x01366c0079157984ULL, 0x000ee40000000800ULL, 0x8000000015ff7812ULL, 0x00cfe4000780480dULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x000000140e177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e0fULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001714147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01366c0079157984ULL, 0x000ea40000000800ULL,
0x8000000015ff7812ULL, 0x004fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018067667810ULL, 0x000fca0007ffe066ULL, 0x0000000165667824ULL, 0x000fca00078e0266ULL,
0x01300000660e7984ULL, 0x000ea80000000800ULL, 0x01320000660f7984ULL, 0x0006620000000800ULL,
0x0000007b0e00720bULL, 0x004fe20003f1d000ULL, 0x0000b2027f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x008fc800000e0100ULL, 0x0000ffff14ff7812ULL, 0x000fe2000782c0ffULL,
0x0000047000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fe20003f0e170ULL,
0x000000ffff7a7224ULL, 0x000fd400078e007bULL, 0x0000043000009947ULL, 0x000fea0003800000ULL,
0x00000003550d7810ULL, 0x000fe40007ffe0ffULL, 0x0000007b0e00720bULL, 0x000fe40003f34000ULL,
0x0000005c0d00720cULL, 0x000fe20003f05270ULL, 0x0000b1b27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000157806ULL, 0x000fc400008e0100ULL, 0x000000805c0c8824ULL, 0x000fe200078e0267ULL,
0x0000007b0e7a7209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x0000000165658824ULL, 0x000fe200078e020cULL, 0x00009910150c7816ULL, 0x000fc800000000ffULL,
0x0134007a65008388ULL, 0x0005e20000000800ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000007b7a0c7221ULL, 0x004fe20000010100ULL,
0x000000ff15ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0c0c7820ULL, 0x000fc80000410000ULL, 0x0000000c00197308ULL, 0x000ea40000000800ULL,
0x0000001904047220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0c7819ULL, 0x000fe20000011600ULL, 0x0000b0d27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c190c7589ULL, 0x0004e400000e0000ULL, 0x0000000c44447220ULL, 0x088fe20000410000ULL,
0x0000000c45457220ULL, 0x080fe20000410000ULL, 0x0000000c40407220ULL, 0x080fe20000410000ULL,
0x0000000c41417220ULL, 0x080fe20000410000ULL, 0x0000000c3c3c7220ULL, 0x080fe20000410000ULL,
0x0000000c3d3d7220ULL, 0x080fe20000410000ULL, 0x0000000c38387220ULL, 0x080fe20000410000ULL,
0x0000000c39397220ULL, 0x080fe20000410000ULL, 0x0000000c34347220ULL, 0x080fe20000410000ULL,
0x0000000c35357220ULL, 0x080fe20000410000ULL, 0x0000000c30307220ULL, 0x080fe20000410000ULL,
0x0000000c31317220ULL, 0x080fe20000410000ULL, 0x0000000c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000c10107220ULL, 0x080fe20000410000ULL,
0x0000000c11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008000c7811ULL, 0x000fe200078ff0ffULL, 0x0000afc27f007947ULL, 0x000fea000b800000ULL,
0x00001f0c190c7589ULL, 0x0006a400000e0000ULL, 0x0000000c46467220ULL, 0x084fe20000410000ULL,
0x0000000c47477220ULL, 0x080fe20000410000ULL, 0x0000000c42427220ULL, 0x080fe20000410000ULL,
0x0000000c43437220ULL, 0x080fe20000410000ULL, 0x0000000c3e3e7220ULL, 0x080fe20000410000ULL,
0x0000000c3f3f7220ULL, 0x080fe20000410000ULL, 0x0000000c3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000c36367220ULL, 0x080fe20000410000ULL,
0x0000000c37377220ULL, 0x080fe20000410000ULL, 0x0000000c32327220ULL, 0x080fe20000410000ULL,
0x0000000c33337220ULL, 0x080fe20000410000ULL, 0x0000000c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000c12127220ULL, 0x080fe20000410000ULL,
0x0000000c13137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff15ff7812ULL, 0x000fda0007800814ULL, 0x0000000e7a0e0221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0e0e0820ULL, 0x000fc80000410000ULL, 0x0000000e00070308ULL, 0x000ea40000000800ULL,
0x000000070f0f0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000015000007945ULL, 0x000fe20003800000ULL,
0x000000040f047221ULL, 0x002fe20000010000ULL, 0x0000012000008947ULL, 0x000fea0003800000ULL,
0x00000007ff08723eULL, 0x000fe400000000ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011600ULL,
0x00005410080e7816ULL, 0x000fe20000000008ULL, 0x0000ae127f007947ULL, 0x000fea000b800000ULL,
0x00001f0f0e097589ULL, 0x0002a400000e0000ULL, 0x000000080f0c7810ULL, 0x000fe20007ffe0ffULL,
0x0000ae427f007947ULL, 0x000fea000b800000ULL, 0x00001f0c0e087589ULL, 0x0002e400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100f0c7810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff167224ULL, 0x000fe200078e000eULL, 0x0000883000177802ULL, 0x000fc40000000f00ULL,
0x0000b2d000007944ULL, 0x01cfea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180f0c7810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff167224ULL, 0x004fe200078e000eULL,
0x0000888000177802ULL, 0x000fc40000000f00ULL, 0x0000b28000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x00a800006424783bULL, 0x000e680000000200ULL, 0x000000007550783bULL, 0x000ee80000004200ULL,
0x00000000734c783bULL, 0x000fe80000004200ULL, 0x000000007248783bULL, 0x000fe80000004200ULL,
0x000000007128783bULL, 0x000fe80000004200ULL, 0x00a800005d0c783bULL, 0x002e680000000200ULL,
0x000000006c20783bULL, 0x000ea80000004200ULL, 0x000000006a1c783bULL, 0x000ea80000004200ULL,
0x000000006918783bULL, 0x008ee80000004200ULL, 0x000000006814783bULL, 0x004ea20000004200ULL,
0x0000000924240232ULL, 0x000fc40000000000ULL, 0x0000000926260232ULL, 0x000fe40000000000ULL,
0x0000000825250232ULL, 0x080fe40000000000ULL, 0x0000000827270232ULL, 0x000fce0000000000ULL,
0x000000502444723cULL, 0x000f620000001844ULL, 0x000000090c0c0232ULL, 0x002fce0000000000ULL,
0x000000522440723cULL, 0x000f620000001840ULL, 0x000000090e0e0232ULL, 0x000fe40000000000ULL,
0x000000080d0d0232ULL, 0x080fe40000000000ULL, 0x000000080f0f0232ULL, 0x000fc60000000000ULL,
0x0000004c243c723cULL, 0x040f70000000183cULL, 0x0000004e2438723cULL, 0x040f700000001838ULL,
0x000000482434723cULL, 0x040f700000001834ULL, 0x0000004a2430723cULL, 0x040f700000001830ULL,
0x00000028242c723cULL, 0x040f70000000182cULL, 0x0000002a2410723cULL, 0x000f700000001810ULL,
0x000000200c44723cULL, 0x060b700000001844ULL, 0x000000220c40723cULL, 0x040b700000001840ULL,
0x0000001c0c3c723cULL, 0x040b70000000183cULL, 0x0000001e0c38723cULL, 0x040b700000001838ULL,
0x000000180c34723cULL, 0x048b700000001834ULL, 0x0000001a0c30723cULL, 0x040b700000001830ULL,
0x000000140c2c723cULL, 0x044b70000000182cULL, 0x000000160c10723cULL, 0x000b620000001810ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0136a00062ff7f8cULL, 0x0003e2000c80043fULL,
0x00000001067c7812ULL, 0x000fce00078ec0ffULL, 0x000003005e5e7a10ULL, 0x002fc80007ffe0ffULL,
0x000000595e00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff8bb000007947ULL, 0x000fea000383ffffULL, 0x0000000000027919ULL, 0x002e620000002500ULL,
0x000000ffff077224ULL, 0x020fe400078e0013ULL, 0x000000ffff167224ULL, 0x000fe200078e0012ULL,
0x000000590200720cULL, 0x002fda0003f06070ULL, 0x0000034000000947ULL, 0x000fea0003800000ULL,
0x0180000004007810ULL, 0x000fe20007ffe0ffULL, 0x000000c000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x00008c3000087802ULL, 0x000fc40000000f00ULL,
0x0000ad2000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0003ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000400037308ULL, 0x010e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000004ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000ea80000000000ULL, 0x0000000000057919ULL, 0x000ee20000000000ULL,
0x00000002ff037819ULL, 0x004fe40000011603ULL, 0x0000000805057811ULL, 0x008fc800078ff0ffULL,
0x00001f0300037589ULL, 0x000ea800000e0000ULL, 0x00001f0500057589ULL, 0x000ee200000e0000ULL,
0x0000004403447220ULL, 0x044fe20000410000ULL, 0x0000004503457220ULL, 0x040fe20000410000ULL,
0x0000004003407220ULL, 0x040fe20000410000ULL, 0x0000004103417220ULL, 0x040fe20000410000ULL,
0x0000003c033c7220ULL, 0x040fe20000410000ULL, 0x0000003d033d7220ULL, 0x040fe20000410000ULL,
0x0000003803387220ULL, 0x040fe20000410000ULL, 0x0000003903397220ULL, 0x040fe20000410000ULL,
0x0000003403347220ULL, 0x040fe20000410000ULL, 0x0000003503357220ULL, 0x040fe20000410000ULL,
0x0000003003307220ULL, 0x040fe20000410000ULL, 0x0000003103317220ULL, 0x040fe20000410000ULL,
0x0000002c032c7220ULL, 0x040fe20000410000ULL, 0x0000002d032d7220ULL, 0x040fe20000410000ULL,
0x0000001003107220ULL, 0x040fe20000410000ULL, 0x0000001103117220ULL, 0x000fe20000410000ULL,
0x0000004605467220ULL, 0x048fe20000410000ULL, 0x0000004705477220ULL, 0x040fe20000410000ULL,
0x0000004205427220ULL, 0x040fe20000410000ULL, 0x0000004305437220ULL, 0x040fe20000410000ULL,
0x0000003e053e7220ULL, 0x040fe20000410000ULL, 0x0000003f053f7220ULL, 0x040fe20000410000ULL,
0x0000003a053a7220ULL, 0x040fe20000410000ULL, 0x0000003b053b7220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000003205327220ULL, 0x040fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000001605167220ULL, 0x040fe20000410000ULL, 0x0000000705077220ULL, 0x000fc80000410000ULL,
0x0000000000057919ULL, 0x000ea20000000000ULL, 0x000000160716723eULL, 0x000fc400000000ffULL,
0x000000444503723eULL, 0x010fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000404108723eULL, 0x000fe400000000ffULL, 0x0000003c3d09723eULL, 0x000fe400000000ffULL,
0x00000038390a723eULL, 0x000fc400000000ffULL, 0x00000034350b723eULL, 0x000fe400000000ffULL,
0x00000030310c723eULL, 0x000fe400000000ffULL, 0x0000002c2d0d723eULL, 0x000fe400000000ffULL,
0x00000010110e723eULL, 0x000fe400000000ffULL, 0x00000002ff187819ULL, 0x004fe40000011605ULL,
0x0000000805277811ULL, 0x000fc400078ff0ffULL, 0x0000000118007810ULL, 0x040fe20007ffe0ffULL,
0x0000000818197824ULL, 0x040fe200078e00ffULL, 0x0000000618177810ULL, 0x040fe20007ffe0ffULL,
0x00000008181c7824ULL, 0x040fe200078e00ffULL, 0x0000000218067810ULL, 0x040fe20007ffe0ffULL,
0x00000008181b7824ULL, 0x040fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fe200078ee200ULL,
0x00000008181d7824ULL, 0x040fe200078e00ffULL, 0x0000000318007810ULL, 0x040fe20007ffe0ffULL,
0x00000008181a7824ULL, 0x040fe200078e00ffULL, 0x0000000518077810ULL, 0x040fe20007ffe0ffULL,
0x00000008181f7824ULL, 0x000fe200078e00ffULL, 0xfffffff81c237812ULL, 0x000fe200078ee217ULL,
0x0000000818177824ULL, 0x040fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee206ULL,
0x0000000818257824ULL, 0x040fe200078e00ffULL, 0x0000000418067810ULL, 0x000fe20007ffe0ffULL,
0x00000008271c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee200ULL,
0x0000100058007824ULL, 0x000fe200078e00ffULL, 0xfffffff81a217812ULL, 0x000fe200078ee207ULL,
0x0000080057077824ULL, 0x000fe200078e00ffULL, 0xffffffff181a7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff817177812ULL, 0x000fe200078ee218ULL, 0x0000000405187824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee206ULL, 0x0000000100067824ULL, 0x000fe200078e0207ULL,
0xfffffff825257812ULL, 0x000fe400078ee21aULL, 0x0000000c18187812ULL, 0x000fe200078ec0ffULL,
0x0000001017177824ULL, 0x100fe200078e0206ULL, 0xfffffff81c277812ULL, 0x000fe200078ee227ULL,
0x0000001019197824ULL, 0x100fe200078e0206ULL, 0x00000046470f723eULL, 0x000fe200000000ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0206ULL, 0x000000424310723eULL, 0x000fe200000000ffULL,
0x000000101d1d7824ULL, 0x100fe200078e0206ULL, 0x0000003e3f11723eULL, 0x000fe200000000ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0206ULL, 0x0000003a3b12723eULL, 0x000fe200000000ffULL,
0x00000001171a7824ULL, 0x000fe200078e0218ULL, 0x000000363713723eULL, 0x000fe200000000ffULL,
0x0000001021217824ULL, 0x100fe200078e0206ULL, 0x000000323314723eULL, 0x000fe200000000ffULL,
0x0000000118197824ULL, 0x040fe200078e0219ULL, 0x000000031a007388ULL, 0x000fe20000000800ULL,
0x0000001023237824ULL, 0x100fe200078e0206ULL, 0x0000002e2f15723eULL, 0x000fe200000000ffULL,
0x00000001181c7824ULL, 0x000fe200078e021bULL, 0x0000000819007388ULL, 0x000fe20000000800ULL,
0x0000001025257824ULL, 0x000fc400078e0206ULL, 0x00000001181d7824ULL, 0x040fe200078e021dULL,
0x000000091c007388ULL, 0x000fe20000000800ULL, 0x0000001027277824ULL, 0x000fe400078e0206ULL,
0x00000001181e7824ULL, 0x040fe200078e021fULL, 0x0000000a1d007388ULL, 0x0005e20000000800ULL,
0x0000000118217824ULL, 0x040fe400078e0221ULL, 0x0000000118207824ULL, 0x040fe200078e0223ULL,
0x0000000b1e007388ULL, 0x000fe20000000800ULL, 0x0000000118257824ULL, 0x000fc400078e0225ULL,
0x0000000118187824ULL, 0x000fe200078e0227ULL, 0x0000000c21007388ULL, 0x000fe20000000800ULL,
0x0000000154177824ULL, 0x000fc600078e0205ULL, 0x0000000d20007388ULL, 0x000fe20000000800ULL,
0x00000010170a7824ULL, 0x004fc600078e0200ULL, 0x0000000e25007388ULL, 0x000fe80000000800ULL,
0x0000000f18007388ULL, 0x000fe80000000800ULL, 0x0004001019007388ULL, 0x000fe80000000800ULL,
0x000400111c007388ULL, 0x000fe80000000800ULL, 0x000400121d007388ULL, 0x000fe80000000800ULL,
0x000400131e007388ULL, 0x000fe80000000800ULL, 0x0004001421007388ULL, 0x000fe80000000800ULL,
0x0004001520007388ULL, 0x000fe80000000800ULL, 0x0004001625007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000a0c7984ULL, 0x000ea80000000c00ULL,
0x000800000a187984ULL, 0x000ee80000000c00ULL, 0x000400000a287984ULL, 0x000e680000000c00ULL,
0x000c00000a2c7984ULL, 0x000e620000000c00ULL, 0x200000ff0c0c7230ULL, 0x004fc40000000000ULL,
0x200000ff0f0f7230ULL, 0x000fe40000000000ULL, 0x000000180c0c7230ULL, 0x008fe20000000000ULL,
0x00000300ff187624ULL, 0x000fe200078e00ffULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x000000011800780cULL, 0x000fe20003f05270ULL,
0x200000ff2b2b7230ULL, 0x002fe40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fc40000000000ULL,
0x200000ff29297230ULL, 0x000fe40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x0000001b0f0f7230ULL, 0x000fe40000000000ULL, 0x0000001a0e0e7230ULL, 0x000fe40000000000ULL,
0x000000190d0d7230ULL, 0x000fe40000000000ULL, 0x0000002f2b2b7230ULL, 0x000fc40000000000ULL,
0x0000002e2a2a7230ULL, 0x000fe20000000000ULL, 0x0000000c0a007388ULL, 0x000fe20000000c00ULL,
0x0000002d29297230ULL, 0x000fe40000000000ULL, 0x0000002c28287230ULL, 0x000fca0000000000ULL,
0x000400280a007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000029f000008947ULL, 0x000fea0003800000ULL, 0x00005800ff037624ULL, 0x000fe200078e00ffULL,
0x0000000000167919ULL, 0x000e660000002700ULL, 0x0000660003037a24ULL, 0x000fe200078e02ffULL,
0x0000000000117919ULL, 0x000e660000002600ULL, 0x0000030003087a24ULL, 0x040fe200078e02ffULL,
0x0000000f030b7811ULL, 0x000fe200078e10ffULL, 0x000000000a0c7984ULL, 0x0004e60000000c00ULL,
0xfffffff00b0b7812ULL, 0x000fca00078ec0ffULL, 0x0000008008097824ULL, 0x000fc800078e020bULL,
0x0000008008087824ULL, 0x000fca00078e0209ULL, 0x0000007f08037810ULL, 0x000fe20007ffe0ffULL,
0x0000580016167a24ULL, 0x002fc600078e0211ULL, 0xffffff8003037812ULL, 0x000fe200078ec0ffULL,
0x0000030016087a24ULL, 0x000fc600078e02ffULL, 0x00006a0003117a10ULL, 0x000fe20007f1e0ffULL,
0x0000000108027824ULL, 0x000fca00078e0202ULL, 0x0000001102107211ULL, 0x000fe200078258ffULL,
0x00006b00ff117624ULL, 0x000fe200000e06ffULL, 0x0000000157ff7812ULL, 0x000fc8000780f85cULL,
0x0000001102117211ULL, 0x000fe400008f5cffULL, 0x00006a000b197a10ULL, 0x000fc60007f3e0ffULL,
0x0000040058107825ULL, 0x000fcc00078e0010ULL, 0x0000001017107825ULL, 0x000fc800078e0010ULL,
0x00006b00ff177624ULL, 0x000fe200008e06ffULL, 0x0000010000000947ULL, 0x000fea0003800000ULL,
0x0000001005127824ULL, 0x00cfe200078e00ffULL, 0x00000001ff137819ULL, 0x000fe20000011605ULL,
0x00000080020a7824ULL, 0x000fe200078e00ffULL, 0x00000019ff027819ULL, 0x000fe40000011602ULL,
0x0000007012157812ULL, 0x000fe400078ec0ffULL, 0x0000000c13137812ULL, 0x000fe400078ec0ffULL,
0x00006a000a147a10ULL, 0x000fc40007ebe009ULL, 0x00000019150a7210ULL, 0x000fe40007a3e00aULL,
0x0000001413147210ULL, 0x040fe40007c7e015ULL, 0x00006b0002157a10ULL, 0x000fe40002fec4ffULL,
0x0000000a13127210ULL, 0x000fe40007fbe0ffULL, 0x00000017ff027210ULL, 0x000fe40000fe4402ULL,
0x00000015ff157210ULL, 0x000fc60001fe84ffULL, 0x000000ffff137224ULL, 0x000fca00028e0602ULL,
0x0000007a12007986ULL, 0x0003e8000c101906ULL, 0x0000000414007986ULL, 0x0003e4000c101906ULL,
0x000000ff0500720cULL, 0x00cfe20000705670ULL, 0x0000000c10007986ULL, 0x000fe2000c101d06ULL,
0x0000014000007945ULL, 0x000fe60003800000ULL, 0x0000000000007b1dULL, 0x000ff00000000000ULL,
0x0000011000000947ULL, 0x000fea0003800000ULL, 0x00000004ff0d7424ULL, 0x000fe200078e00ffULL,
0xffffffff180f7810ULL, 0x000fc60007ffe0ffULL, 0x00006a00160c7625ULL, 0x000fe200078e000dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x0000000f0c0c79a8ULL, 0x000ea400099ee1c6ULL,
0x0000000f0c00720cULL, 0x004fc80003f05270ULL, 0x00000001ff027807ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec000000a000ULL, 0x00000000000079abULL, 0x000fc00000000000ULL,
0x00000000ff00798fULL, 0x000fca0002000000ULL, 0x00000002ff007388ULL, 0x0005e40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000ff027984ULL, 0x004ea40000000000ULL, 0x000000ff0200720cULL, 0x004fda0003f05270ULL,
0x000025b000008947ULL, 0x000fea0003800000ULL, 0x000000ff5c00720cULL, 0x000fda0003f05270ULL,
0x00000a5000000947ULL, 0x000fea0003800000ULL, 0x00000300ff007a0cULL, 0x000fda0003f05270ULL,
0x000001b000008947ULL, 0x000fea0003800000ULL, 0x0000001005027824ULL, 0x000fe200078e00ffULL,
0x00000001ff047819ULL, 0x002fe40000011605ULL, 0x00000019080c7211ULL, 0x000fe400078038ffULL,
0x00000070020d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fe400078ec0ffULL,
0x0000001708027211ULL, 0x000fe400000f3cffULL, 0x0000000c040c7210ULL, 0x000fc8000791e00dULL,
0x00000002ff0d7210ULL, 0x000fca00007e24ffULL, 0x000000060c027981ULL, 0x000328000c1e1900ULL,
0x000080060c0f7981ULL, 0x000322000c1e1900ULL, 0x000000021800780cULL, 0x000fda0003f05270ULL,
0x000000f000008947ULL, 0x000fea0003800000ULL, 0x000100060c117981ULL, 0x002322000c1e1900ULL,
0x000000041800780cULL, 0x000fda0003f06070ULL, 0x000000c000008947ULL, 0x000fea0003800000ULL,
0x000180060c137981ULL, 0x002322000c1e1900ULL, 0x000000041800780cULL, 0x000fda0003f05270ULL,
0x0000009000008947ULL, 0x000fea0003800000ULL, 0x000200060c157981ULL, 0x002322000c1e1900ULL,
0x000000061800780cULL, 0x000fda0003f06070ULL, 0x0000006000008947ULL, 0x000fea0003800000ULL,
0x000280060c177981ULL, 0x002322000c1e1900ULL, 0x000000061800780cULL, 0x000fda0003f05270ULL,
0x0000003000008947ULL, 0x000fea0003800000ULL, 0x000000081800780cULL, 0x002fe20003f06070ULL,
0x000300060c197981ULL, 0x000318000c1e1900ULL, 0x000380060c1b0981ULL, 0x000324000c1e1900ULL,
0x0000000718047810ULL, 0x002fc80007ffe0ffULL, 0x00000003ff047819ULL, 0x000fc80000011604ULL,
0x000000ff0400720cULL, 0x000fda0003f05270ULL, 0x000007d000008947ULL, 0x000fea0003800000ULL,
0x0000000b081f7211ULL, 0x040fe200078038ffULL, 0x000000ffff0e7224ULL, 0x000fe200078e00ffULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x000000ffff1d7224ULL, 0x010fe200078e0002ULL,
0x00006a001f1f7a10ULL, 0x000fe40007f3e0ffULL, 0x000000ff080a7211ULL, 0x000fe400000f3cffULL,
0x000007801f1f7810ULL, 0x000fc80007f5e0ffULL, 0x00006b00ff0a7a10ULL, 0x000fc400017e240aULL,
0x000003000e007a0cULL, 0x000fe20003f26070ULL, 0x0000000104047890ULL, 0x000fcc000fffe03fULL,
0x0000000404007c0cULL, 0x000fcc000bf03070ULL, 0x000006d000001947ULL, 0x012fea0003800000ULL,
0x000000080e0c7810ULL, 0x040fe40007ffe0ffULL, 0x000000010e0d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001d02027209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010050c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011605ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e060aULL,
0xfffc80060c1d7981ULL, 0x000326000c1e1900ULL, 0x000005f000002947ULL, 0x000fea0003800000ULL,
0x000000090e0c7810ULL, 0x042fe40007ffe0ffULL, 0x000000020e0d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000000f02027209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010050c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011605ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e060aULL,
0xfffd00060c0f7981ULL, 0x000326000c1e1900ULL, 0x0000051000002947ULL, 0x000fea0003800000ULL,
0x0000000a0e0c7810ULL, 0x042fe40007ffe0ffULL, 0x000000030e0d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001102027209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010050c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011605ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e060aULL,
0xfffd80060c117981ULL, 0x000326000c1e1900ULL, 0x0000043000002947ULL, 0x000fea0003800000ULL,
0x0000000b0e0c7810ULL, 0x042fe40007ffe0ffULL, 0x000000040e0d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001302027209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010050c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011605ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e060aULL,
0xfffe00060c137981ULL, 0x000326000c1e1900ULL, 0x0000035000002947ULL, 0x000fea0003800000ULL,
0x0000000c0e0c7810ULL, 0x042fe40007ffe0ffULL, 0x000000050e0d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001502027209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010050c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011605ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e060aULL,
0xfffe80060c157981ULL, 0x000326000c1e1900ULL, 0x0000027000002947ULL, 0x000fea0003800000ULL,
0x0000000d0e0c7810ULL, 0x042fe40007ffe0ffULL, 0x000000060e0d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001702027209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010050c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011605ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e060aULL,
0xffff00060c177981ULL, 0x000326000c1e1900ULL, 0x0000019000002947ULL, 0x000fea0003800000ULL,
0x0000000e0e0c7810ULL, 0x042fe40007ffe0ffULL, 0x000000070e0d7810ULL, 0x000fe40007ffe0ffULL,
0x000003000c007a0cULL, 0x000fe40003f26070ULL, 0x000003000d007a0cULL, 0x000fe40003f46070ULL,
0x0000001902027209ULL, 0x000fd20007810000ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010050c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011605ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e060aULL,
0xffff80060c197981ULL, 0x000326000c1e1900ULL, 0x000000b000002947ULL, 0x000fea0003800000ULL,
0x0000000f0e0c7810ULL, 0x002fe40007ffe0ffULL, 0x0000001b02027209ULL, 0x000fe40007810000ULL,
0x000003000c007a0cULL, 0x000fda0003f26070ULL, 0x0000007000001947ULL, 0x000fea0003800000ULL,
0x00000010050c7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0d7819ULL, 0x000fc80000011605ULL,
0x000000700c0c7812ULL, 0x000fc800078ec0ffULL, 0x0000000c0c0c7812ULL, 0x000fc800078ef80dULL,
0x0000000c1f0c7210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fca00008e060aULL,
0x000000060c1b7981ULL, 0x000326000c1e1900ULL, 0x000004001f1f7810ULL, 0x000fe40007f3e0ffULL,
0x000000080e0e7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e060aULL,
0xfffff8b000008947ULL, 0x000fea000383ffffULL, 0x0000000000057919ULL, 0x000ea40000000000ULL,
0x0000001005047824ULL, 0x004fe200078e00ffULL, 0x00000001ff0a7819ULL, 0x000fc80000011605ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c0a0d7812ULL, 0x002fca00078ec0ffULL,
0x00000001040d7824ULL, 0x000fca00078e020dULL, 0x000000020d007388ULL, 0x0103e40000000800ULL,
0x00006a0003027a10ULL, 0x002fe20007f3e0ffULL, 0x0000000157117824ULL, 0x000fe200078e0208ULL,
0x000000070500780cULL, 0x040fe20003f04070ULL, 0x00000010050e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0f7819ULL, 0x000fe20000011605ULL, 0x00006b00ff037624ULL, 0x000fe200008e06ffULL,
0x00000001570a7812ULL, 0x000fe200078ec0ffULL, 0x0000040058047824ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fe200078ec0ffULL, 0x00000800110c7825ULL, 0x000fe200078e0002ULL,
0x0000000c0f0f7812ULL, 0x000fe200078ec0ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000040c0c7210ULL, 0x000fe20007f3e0ffULL, 0x000000010e127824ULL, 0x000fe200078e020fULL,
0x00000800070e7812ULL, 0x000fe200078ec0ffULL, 0x0000000257138824ULL, 0x100fe200078e0258ULL,
0x0000002005177810ULL, 0x000fe20007ffe0ffULL, 0x0000000257158824ULL, 0x040fe200078e0258ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000200057077824ULL, 0x000fe200078e0200ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x00006a0009097a10ULL, 0x000fe20007f3e0ffULL, 0x0000000213108824ULL, 0x100fe200078e020aULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000215148824ULL, 0x000fe200078e020aULL,
0x00006a000b0a7a10ULL, 0x000fe20007f5e0ffULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x00006b00ff0b7624ULL, 0x000fe200008e06ffULL,
0x0000000911188211ULL, 0x000fe200078238ffULL, 0x0000001005157824ULL, 0x000fe200078e020eULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000001017167825ULL, 0x100fe200078e000cULL,
0x0000000b11198211ULL, 0x000fe200008f3cffULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000030057007a0cULL, 0x000fe20003f26070ULL, 0x00000010050e7825ULL, 0x000fe200078e000cULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000120d7984ULL, 0x0002a40000000800ULL,
0x00006b00ff0c7624ULL, 0x000fe200010e06ffULL, 0x0000000a111a8211ULL, 0x040fe200078438ffULL,
0x0000000810108824ULL, 0x100fe200078e0205ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x001800000e157faeULL, 0x0007e2000b901c46ULL, 0x0000000814148824ULL, 0x000fe200078e0205ULL,
0x0000000c111b8211ULL, 0x000fe200010f3cffULL, 0x0000001005188825ULL, 0x040fe200078e0018ULL,
0x00004580101d8811ULL, 0x000fe200078e20ffULL, 0x0038000016157faeULL, 0x0009e2000b901c46ULL,
0x00004180141f8811ULL, 0x000fe200078e20ffULL, 0x00000010051a8825ULL, 0x000fe200078e001aULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000181d8faeULL, 0x0009e2000b901c46ULL,
0x0000000000127805ULL, 0x002fe2000001ff00ULL, 0x000000ffff2e7224ULL, 0x000fe200078e00ffULL,
0x00000000000e7805ULL, 0x008fe2000001ff00ULL, 0x000000001a1f8faeULL, 0x0003e8000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000147805ULL, 0x010fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x002fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000c0000001947ULL, 0x000fea0003800000ULL,
0x000000ffff0e7224ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fca00078e0057ULL,
0x000000012f317810ULL, 0x000fc80007ffe0ffULL, 0x0000030031007a0cULL, 0x000fda0003f06070ULL,
0x0000022000000947ULL, 0x000fea0003800000ULL, 0x000000070500780cULL, 0x000fe20003f64070ULL,
0x0000000108357824ULL, 0x000fe200078e0231ULL, 0x0000000131337812ULL, 0x040fe200078ec0ffULL,
0x0000080031327824ULL, 0x000fe200078e00ffULL, 0x00000020053b7810ULL, 0x000fe20007ffe0ffULL,
0x0000080035307825ULL, 0x000fd000078e0002ULL, 0x000000025734b824ULL, 0x100fe200078e0258ULL,
0x000000093536b211ULL, 0x000fe200078238ffULL, 0x000000025738b824ULL, 0x000fe400078e0258ULL,
0x00000002343ab824ULL, 0x100fe200078e0233ULL, 0x0000080032347812ULL, 0x000fe200078ec0ffULL,
0x000000023838b824ULL, 0x000fe200078e0233ULL, 0x0000000430327210ULL, 0x000fe20007f1e0ffULL,
0x000000083a3ab824ULL, 0x000fe200078e0205ULL, 0x0000000a3530b211ULL, 0x000fe200078438ffULL,
0x0000000107347824ULL, 0x000fe200078e0234ULL, 0x0000000b3537b211ULL, 0x040fe200008f3cffULL,
0x000000ffff337224ULL, 0x000fe200000e0631ULL, 0x0000000c3531b211ULL, 0x000fe200010f3cffULL,
0x000000083838b824ULL, 0x000fe200078e0205ULL, 0x000041803a3db811ULL, 0x000fe200078e20ffULL,
0x0000001005397824ULL, 0x000fc400078e0234ULL, 0x000000103b347825ULL, 0x000fe200078e0032ULL,
0x00004580383bb811ULL, 0x000fc600078e20ffULL, 0x0000001005327825ULL, 0x000fc800078e0032ULL,
0x000000100536b825ULL, 0x040fe200078e0036ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000032397faeULL, 0x0003e6000b901c46ULL, 0x000000100530b825ULL, 0x000fe200078e0030ULL,
0x0038000034397faeULL, 0x0003e8000b901c46ULL, 0x00000000363bbfaeULL, 0x0003e8000b901c46ULL,
0x00000000303dbfaeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000802f307824ULL, 0x002fe200078e00ffULL, 0x00000001ff327819ULL, 0x100fe20000011605ULL,
0x0000000257337824ULL, 0x000fe200078e0258ULL, 0x00000002ff407819ULL, 0x000fe20000011605ULL,
0x0000001005317824ULL, 0x000fe200078e00ffULL, 0x0000008030307812ULL, 0x000fc400078ec0ffULL,
0x0000000c32327812ULL, 0x000fe200078ec0ffULL, 0x0000000840367824ULL, 0x040fe200078e00ffULL,
0x0000007031317812ULL, 0x000fe200078ec0ffULL, 0x0000010033307824ULL, 0x000fe200078e0030ULL,
0x0000000140337810ULL, 0x040fe20007ffe0ffULL, 0x0000000840357824ULL, 0x040fe200078e00ffULL,
0x0000000840427810ULL, 0x040fe20007ffe0ffULL, 0x00000008403d7824ULL, 0x000fe200078e00ffULL,
0x0000003032317210ULL, 0x000fe20007ffe031ULL, 0x000008002f307824ULL, 0x000fe200078e00ffULL,
0xfffffff836397812ULL, 0x000fe200078ee233ULL, 0x0000000405337824ULL, 0x000fe200078e00ffULL,
0x0000000240347810ULL, 0x000fe20007ffe0ffULL, 0x00000008423b7824ULL, 0x000fe200078e00ffULL,
0x0000080030307812ULL, 0x000fe200078ec0ffULL, 0x00000008403c7824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0041800031327984ULL, 0x000e620000000800ULL,
0x0000018007307810ULL, 0x000fe20007ffe030ULL, 0x00000008403f7824ULL, 0x040fe200078e00ffULL,
0x0000000c33437812ULL, 0x000fe200078ec0ffULL, 0x0045800031377984ULL, 0x0007220000000800ULL,
0xfffffff83b337812ULL, 0x000fe200078ee242ULL, 0x0000000840477824ULL, 0x040fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee234ULL, 0x0000000840497824ULL, 0x040fe200078e00ffULL,
0x0000000340387810ULL, 0x040fe20007ffe0ffULL, 0x0000001033337824ULL, 0x000fe200078e0230ULL,
0x00000005403a7810ULL, 0x000fc40007ffe0ffULL, 0xfffffff835317812ULL, 0x008fe200078ee240ULL,
0x0000000143357824ULL, 0x000fe200078e0233ULL, 0x0000000440337810ULL, 0x000fe40007ffe0ffULL,
0xfffffff847477812ULL, 0x000fe200078ee23aULL, 0x0000001031317824ULL, 0x000fe200078e0230ULL,
0x00000000353b7984ULL, 0x000fe20000000800ULL, 0xfffffff83c457812ULL, 0x000fe200078ee233ULL,
0x00000008403a7824ULL, 0x000fe200078e00ffULL, 0x000000022f2f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000143317824ULL, 0x000fc600078e0231ULL, 0x000003002f007a0cULL, 0x000fc60003f06070ULL,
0x0000000031317984ULL, 0x000ee20000000800ULL, 0x000000320d327221ULL, 0x006fc80000010100ULL,
0x3fb8aa3b32347820ULL, 0x000fe20000410000ULL, 0x0000001039327824ULL, 0x000fe200078e0230ULL,
0xfffffff83f397812ULL, 0x000fe400078ee238ULL, 0x0000003400367308ULL, 0x0003220000000800ULL,
0x0000000143327824ULL, 0x000fe200078e0232ULL, 0xffffffff40387810ULL, 0x000fc80007ffe0ffULL,
0x0000000032337984ULL, 0x000fe20000000800ULL, 0x000000103d347824ULL, 0x002fc600078e0230ULL,
0x00040000323c7984ULL, 0x000fe20000000800ULL, 0x0000000143347824ULL, 0x000fe200078e0234ULL,
0x00000037363f7220ULL, 0x010fe20000410000ULL, 0x0000000640377810ULL, 0x000fe20007ffe0ffULL,
0x0000001039367824ULL, 0x000fe400078e0230ULL, 0x0000000034357984ULL, 0x000fe20000000800ULL,
0x0000002e3f2e7221ULL, 0x000fe20000010000ULL, 0xfffffff83a397812ULL, 0x000fe200078ee237ULL,
0x0000001045377824ULL, 0x000fe200078e0230ULL, 0x00001f423f417589ULL, 0x0002a200000e0000ULL,
0x0000000143367824ULL, 0x000fe200078e0236ULL, 0xfffffff849457812ULL, 0x000fe200078ee238ULL,
0x0000000143377824ULL, 0x000fe200078e0237ULL, 0x00001f403f407589ULL, 0x000f2200000e0000ULL,
0x0000001047387824ULL, 0x000fc400078e0230ULL, 0x0000001039397824ULL, 0x100fe200078e0230ULL,
0x0000000036327984ULL, 0x000f220000000800ULL, 0x00000010453a7824ULL, 0x000fe400078e0230ULL,
0x0000000143387824ULL, 0x040fe200078e0238ULL, 0x0000000037307984ULL, 0x000f220000000800ULL,
0x0000000143397824ULL, 0x040fe400078e0239ULL, 0x00000001433a7824ULL, 0x000fe200078e023aULL,
0x00040000373f7984ULL, 0x000f220000000800ULL, 0x30000031ff437230ULL, 0x008fc40000004100ULL,
0x2000003bff427230ULL, 0x102fe20000004100ULL, 0x00040000343d7984ULL, 0x0002e20000000800ULL,
0x3000003bff3b7230ULL, 0x000fc60000004100ULL, 0x00040000363e7984ULL, 0x000ee20000000800ULL,
0x00000041422b7223ULL, 0x084fe2000001002bULL, 0x20000033ff427230ULL, 0x000fe20000004100ULL,
0x000000413b2a7223ULL, 0x080fe2000001002aULL, 0x20000031ff347230ULL, 0x002fe20000004100ULL,
0x0004000038367984ULL, 0x000e620000000800ULL, 0x30000033ff337230ULL, 0x000fe20000004100ULL,
0x0000004042297223ULL, 0x090fe20000010029ULL, 0x2000003cff447230ULL, 0x100fe20000004100ULL,
0x0000000038317984ULL, 0x000ea20000000800ULL, 0x00000040342d7223ULL, 0x080fe2000001002dULL,
0x0000004033287223ULL, 0x080fe20000010028ULL, 0x3000003cff3b7230ULL, 0x000fe20000004100ULL,
0x0000000039347984ULL, 0x000f220000000800ULL, 0x20000035ff3c7230ULL, 0x100fe20000004100ULL,
0x00000040432c7223ULL, 0x080fe2000001002cULL, 0x30000035ff357230ULL, 0x000fe20000004100ULL,
0x0004000039377984ULL, 0x000f220000000800ULL, 0x0000004144277223ULL, 0x080fe20000010027ULL,
0x000000403c257223ULL, 0x080fe20000010025ULL, 0x000000413b267223ULL, 0x000fe20000010026ULL,
0x000000003a337984ULL, 0x000f220000000800ULL, 0x0000004035247223ULL, 0x000fe20000010024ULL,
0x20000032ff3c7230ULL, 0x000fc40000004100ULL, 0x000400003a387984ULL, 0x0007220000000800ULL,
0x30000032ff357230ULL, 0x000fe40000004100ULL, 0x20000030ff327230ULL, 0x100fe20000004100ULL,
0x000000403c217223ULL, 0x080fe40000010021ULL, 0x0000004035207223ULL, 0x080fe20000010020ULL,
0x30000030ff357230ULL, 0x000fe20000004100ULL, 0x00000040321d7223ULL, 0x080fe2000001001dULL,
0x2000003fff327230ULL, 0x000fe40000004100ULL, 0x2000003dff427230ULL, 0x108fe20000004100ULL,
0x00000040351c7223ULL, 0x000fe2000001001cULL, 0x3000003dff3d7230ULL, 0x000fe20000004100ULL,
0x00000041321b7223ULL, 0x080fe2000001001bULL, 0x2000003eff3a7230ULL, 0x100fe20000004100ULL,
0x0000004142237223ULL, 0x080fe20000010023ULL, 0x3000003eff397230ULL, 0x000fe20000004100ULL,
0x000000413d227223ULL, 0x080fe20000010022ULL, 0x3000003fff3f7230ULL, 0x000fe20000004100ULL,
0x000000413a1f7223ULL, 0x080fe2000001001fULL, 0x20000036ff327230ULL, 0x102fe20000004100ULL,
0x00000041391e7223ULL, 0x080fe2000001001eULL, 0x30000036ff357230ULL, 0x000fe20000004100ULL,
0x000000413f1a7223ULL, 0x080fe2000001001aULL, 0x20000031ff307230ULL, 0x104fe20000004100ULL,
0x0000004132177223ULL, 0x080fe20000010017ULL, 0x30000031ff317230ULL, 0x000fe20000004100ULL,
0x0000004135167223ULL, 0x000fc40000010016ULL, 0x0000004030197223ULL, 0x080fe20000010019ULL,
0x20000034ff307230ULL, 0x110fe20000004100ULL, 0x0000004031187223ULL, 0x080fe20000010018ULL,
0x30000034ff317230ULL, 0x000fe40000004100ULL, 0x20000037ff327230ULL, 0x000fe20000004100ULL,
0x0000004030157223ULL, 0x080fe20000010015ULL, 0x20000033ff307230ULL, 0x000fe20000004100ULL,
0x0000004031147223ULL, 0x080fe20000010014ULL, 0x30000037ff377230ULL, 0x000fe20000004100ULL,
0x0000004132137223ULL, 0x080fe20000010013ULL, 0x30000033ff337230ULL, 0x000fe20000004100ULL,
0x0000004030117223ULL, 0x080fe20000010011ULL, 0x20000038ff327230ULL, 0x100fe20000004100ULL,
0x0000004137127223ULL, 0x000fe20000010012ULL, 0x30000038ff317230ULL, 0x000fe20000004100ULL,
0x0000004033107223ULL, 0x000fc40000010010ULL, 0x00000041320f7223ULL, 0x080fe4000001000fULL,
0x00000041310e7223ULL, 0x000fe2000001000eULL, 0xfffff42000008947ULL, 0x000fea000383ffffULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x000000ff5800720cULL, 0x000fe20003f05270ULL,
0x0000001002037824ULL, 0x002fe200078e00ffULL, 0x00000001ff027819ULL, 0x000fc80000011602ULL,
0x0000007003057812ULL, 0x000fe400078ec0ffULL, 0x0000000c02087812ULL, 0x000fca00078ec0ffULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e640000000000ULL,
0x0000001002037824ULL, 0x002fe200078e00ffULL, 0x00000001ff047819ULL, 0x000fc80000011602ULL,
0x0000007003027812ULL, 0x000fe400078ec0ffULL, 0x0000000c04037812ULL, 0x000fc600078ec0ffULL,
0x0000008057027824ULL, 0x000fc800078e0202ULL, 0x0000000103037824ULL, 0x000fca00078e0202ULL,
0x0049802e03007388ULL, 0x0003e40000000800ULL, 0x0000000105057824ULL, 0x000fe200078e0208ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0049800005027984ULL, 0x000ee20000000800ULL,
0x0000011000007945ULL, 0x000fe60003800000ULL, 0x004a000005037984ULL, 0x002e620000000800ULL,
0x00000002ff027221ULL, 0x008fc80000010000ULL, 0x0000000302027221ULL, 0x002fca0000010000ULL,
0x0180000002037810ULL, 0x000fc80007ffe0ffULL, 0x7f80000003037812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0300780cULL, 0x000fda0003f04070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000ffff047224ULL, 0x000fe200078e0002ULL,
0x0000b6e000087802ULL, 0x000fc40000000f00ULL, 0x0000827000007944ULL, 0x004fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000200037308ULL, 0x000e640000001000ULL,
0xbf80000002047423ULL, 0x002fc80000000003ULL, 0x800000ff04047221ULL, 0x000fc80000010100ULL,
0x0000000403037223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000f280000000000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000002ff087819ULL, 0x010fc40000011605ULL, 0x00000008050a7811ULL, 0x000fe400078ff0ffULL,
0x0000000208077810ULL, 0x040fe20007ffe0ffULL, 0x00001f0803027589ULL, 0x00cea200000e0000ULL,
0x00000008082e7824ULL, 0x040fe200078e00ffULL, 0x00000003080c7810ULL, 0x040fe20007ffe0ffULL,
0x00000008080d7824ULL, 0x040fe200078e00ffULL, 0x00001f0a03047589ULL, 0x0022e200000e0000ULL,
0x00000008082f7824ULL, 0x000fe200078e00ffULL, 0xfffffff82e0b7812ULL, 0x000fe200078ee207ULL,
0x0000000808337824ULL, 0x040fe200078e00ffULL, 0x0000000508077810ULL, 0x040fe20007ffe0ffULL,
0x0000000808357824ULL, 0x000fe200078e00ffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL,
0x000000080a377824ULL, 0x000fe200078e00ffULL, 0x00000006080c7810ULL, 0x040fe20007ffe0ffULL,
0x000000100b0b7824ULL, 0x100fe200078e0206ULL, 0x0000000108037810ULL, 0x002fe20007ffe0ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0206ULL, 0xfffffff833337812ULL, 0x000fc400078ee20cULL,
0xfffffff837377812ULL, 0x000fc600078ee20aULL, 0x0000001033337824ULL, 0x100fe400078e0206ULL,
0x0000001037377824ULL, 0x100fe200078e0206ULL, 0x0000002d022d7220ULL, 0x044fe20000410000ULL,
0x0000002c022c7220ULL, 0x040fe20000410000ULL, 0x0000002902297220ULL, 0x040fe20000410000ULL,
0x0000002802287220ULL, 0x040fe20000410000ULL, 0x0000002502257220ULL, 0x040fe20000410000ULL,
0x0000002402247220ULL, 0x040fe20000410000ULL, 0x0000002102217220ULL, 0x040fe20000410000ULL,
0x0000002002207220ULL, 0x040fe20000410000ULL, 0x0000001d021d7220ULL, 0x040fe20000410000ULL,
0x0000001c021c7220ULL, 0x040fe20000410000ULL, 0x0000001902197220ULL, 0x040fe20000410000ULL,
0x0000001802187220ULL, 0x040fe20000410000ULL, 0x0000001502157220ULL, 0x040fe20000410000ULL,
0x0000001402147220ULL, 0x040fe20000410000ULL, 0x0000001102117220ULL, 0x040fe20000410000ULL,
0x0000001002027220ULL, 0x000fe20000410000ULL, 0x0000000808107824ULL, 0x000fe200078e00ffULL,
0x0000002b042b7220ULL, 0x048fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x000fe20000410000ULL,
0xfffffff810097812ULL, 0x000fe200078ee203ULL, 0x0000000808037824ULL, 0x000fe200078e00ffULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x0000001f041f7220ULL, 0x040fe20000410000ULL, 0x0000001e041e7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x040fe20000410000ULL, 0x0000001604167220ULL, 0x040fe20000410000ULL,
0x0000001304137220ULL, 0x040fe20000410000ULL, 0x0000001204127220ULL, 0x040fe20000410000ULL,
0x0000000f040f7220ULL, 0x040fe20000410000ULL, 0x0000000e04047220ULL, 0x000fe20000410000ULL,
0x00000004080e7810ULL, 0x000fe20007ffe0ffULL, 0x0000001009097824ULL, 0x000fe200078e0206ULL,
0xfffffff810317812ULL, 0x000fe200078ee207ULL, 0x0000000405077824ULL, 0x000fe200078e00ffULL,
0xfffffff803037812ULL, 0x000fc400078ee208ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee20eULL,
0x0000001031317824ULL, 0x100fe200078e0206ULL, 0xffffffff080e7810ULL, 0x000fe20007ffe0ffULL,
0x0000001003037824ULL, 0x100fe200078e0206ULL, 0x0000000c07087812ULL, 0x000fe200078ec0ffULL,
0x000000102f2f7824ULL, 0x000fe200078e0206ULL, 0xfffffff835357812ULL, 0x000fe400078ee20eULL,
0x0000002d2c2c723eULL, 0x000fe200000000ffULL, 0x0000000103037824ULL, 0x000fe200078e0208ULL,
0x000000292828723eULL, 0x000fe200000000ffULL, 0x0000000108077824ULL, 0x000fe200078e0209ULL,
0x000000110202723eULL, 0x000fe200000000ffULL, 0x0000000108117824ULL, 0x000fe200078e020bULL,
0x000000252424723eULL, 0x000fe200000000ffULL, 0x0000001035357824ULL, 0x000fe200078e0206ULL,
0x000000131212723eULL, 0x000fe200000000ffULL, 0x0000000108137824ULL, 0x000fe200078e020dULL,
0x000000212020723eULL, 0x000fe200000000ffULL, 0x00000001082f7824ULL, 0x000fe200078e022fULL,
0x0000001d1c1c723eULL, 0x000fe200000000ffULL, 0x0000000108317824ULL, 0x000fe200078e0231ULL,
0x000000191818723eULL, 0x000fe200000000ffULL, 0x0000002c03007388ULL, 0x0003e20000000800ULL,
0x000000151414723eULL, 0x000fe200000000ffULL, 0x0000000108337824ULL, 0x000fe200078e0233ULL,
0x0000002b2a2a723eULL, 0x000fe200000000ffULL, 0x0000002807007388ULL, 0x000fe20000000800ULL,
0x0000000108357824ULL, 0x000fe200078e0235ULL, 0x000000272626723eULL, 0x000fe200000000ffULL,
0x0000000108377824ULL, 0x000fe200078e0237ULL, 0x0000002411007388ULL, 0x000fe20000000800ULL,
0x000000232222723eULL, 0x000fe200000000ffULL, 0x0000000154037824ULL, 0x002fe200078e0205ULL,
0x0000001f1e1e723eULL, 0x000fe200000000ffULL, 0x0000002013007388ULL, 0x000fe20000000800ULL,
0x0000001b1a1a723eULL, 0x000fe200000000ffULL, 0x0000001003037824ULL, 0x000fe200078e0200ULL,
0x000000171616723eULL, 0x000fe200000000ffULL, 0x0000001c2f007388ULL, 0x000fe20000000800ULL,
0x0000000f0404723eULL, 0x000fc600000000ffULL, 0x0000001831007388ULL, 0x000fe80000000800ULL,
0x0000001433007388ULL, 0x000fe80000000800ULL, 0x0000000235007388ULL, 0x000fe80000000800ULL,
0x0000002a37007388ULL, 0x000fe80000000800ULL, 0x0004002607007388ULL, 0x000fe80000000800ULL,
0x0004002211007388ULL, 0x000fe80000000800ULL, 0x0004001e13007388ULL, 0x000fe80000000800ULL,
0x0004001a2f007388ULL, 0x000fe80000000800ULL, 0x0004001631007388ULL, 0x000fe80000000800ULL,
0x0004001233007388ULL, 0x000fe80000000800ULL, 0x0004000435007388ULL, 0x000fe80000000800ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000003087984ULL, 0x000e680000000c00ULL,
0x0004000003207984ULL, 0x000ea80000000c00ULL, 0x00080000030c7984ULL, 0x000ee80000000c00ULL,
0x000c000003247984ULL, 0x000f220000000c00ULL, 0x200000ff0b0b7230ULL, 0x002fc40000000000ULL,
0x200000ff0a0a7230ULL, 0x000fe40000000000ULL, 0x200000ff09097230ULL, 0x000fe40000000000ULL,
0x200000ff08087230ULL, 0x000fe40000000000ULL, 0x200000ff23237230ULL, 0x004fe40000000000ULL,
0x200000ff22227230ULL, 0x000fe40000000000ULL, 0x200000ff21217230ULL, 0x000fc40000000000ULL,
0x200000ff20207230ULL, 0x000fe40000000000ULL, 0x0000000f0b0b7230ULL, 0x008fe40000000000ULL,
0x0000000e0a0a7230ULL, 0x000fe40000000000ULL, 0x0000000d09097230ULL, 0x000fe40000000000ULL,
0x0000000c08087230ULL, 0x000fe40000000000ULL, 0x0000002723237230ULL, 0x010fc40000000000ULL,
0x0000002622227230ULL, 0x000fe20000000000ULL, 0x0000000803007388ULL, 0x000fe20000000c00ULL,
0x0000002521217230ULL, 0x000fe40000000000ULL, 0x0000002420207230ULL, 0x000fca0000000000ULL,
0x0004002003007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff5700720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000002005107810ULL, 0x000fe20007ffe0ffULL, 0x0000000000047919ULL, 0x002e620000002600ULL,
0x00000003ff067819ULL, 0x100fe20000011605ULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x00000003ff037819ULL, 0x000fe20000011610ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x0000000858127824ULL, 0x000fe200078e00ffULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000106077824ULL, 0x000fe400078e0205ULL, 0x0000000110027824ULL, 0x000fc400078e0203ULL,
0x0000000858137824ULL, 0x000fe200078e00ffULL, 0x0000000707087812ULL, 0x000fe400078ec0ffULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x0ffffff808097812ULL, 0x000fe400078ef805ULL,
0x0ffffff802077812ULL, 0x000fc600078ef810ULL, 0x0000001009027824ULL, 0x100fe400078e0200ULL,
0x0000001007077824ULL, 0x000fe400078e0200ULL, 0x0000000804117824ULL, 0x042fe200078e00ffULL,
0x0000000002087984ULL, 0x0002e20000000c00ULL, 0x0000000804047824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x004fe4000f8e023fULL, 0x00000000070c7984ULL, 0x0005220000000c00ULL,
0xfffffff811007812ULL, 0x000fc400078ee206ULL, 0xfffffff804037812ULL, 0x000fe400078ee203ULL,
0x0000000400067c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000403007c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff812117812ULL, 0x000fe200078ee205ULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005a0006027a11ULL, 0x002fe200078040ffULL, 0x000000ffff077224ULL, 0x004fe200008e06ffULL,
0x00005a0000047a11ULL, 0x000fc400078240ffULL, 0x00005b0006037a11ULL, 0x000fe400000f4403ULL,
0x00005b0000057a11ULL, 0x000fe400008f4407ULL, 0xfffffff813077812ULL, 0x000fe200078ee210ULL,
0x0000001011027825ULL, 0x000fc800078e0002ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x008fe8000c101d06ULL, 0x0000000c04007986ULL, 0x010fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x000000045e047824ULL, 0x002fe400078e025cULL,
0xffffffffff6f7424ULL, 0x000fc600078e00ffULL, 0x0000005b0400720cULL, 0x000fda0003f06070ULL,
0x00000002530b8824ULL, 0x000fc800078e00ffULL, 0x000064000b0b8a24ULL, 0x000fc800078e0204ULL,
0x000060000b0a8625ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000060a6f8981ULL, 0x000ea2000c1e1900ULL, 0x000000015e027810ULL, 0x000fe20007ffe0ffULL,
0x000000405c057824ULL, 0x000fe400078e00ffULL, 0x01360000ff067f8cULL, 0x000e62000c80043fULL,
0x000000590200720cULL, 0x000fe20003f06070ULL, 0x0000004010027824ULL, 0x000fe400078e00ffULL,
0x000000400c037824ULL, 0x000fe400078e00ffULL, 0x000000026f1a7224ULL, 0x004fd000078e02ffULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x000001005e097824ULL, 0x002fe200078e0205ULL,
0x00000002ff1f7819ULL, 0x000fe40000011600ULL, 0x0000000000117211ULL, 0x000fe400078fe8ffULL,
0x000000095a0a7217ULL, 0x000fe20007800000ULL, 0x000000400c0b7824ULL, 0x000fe200078e021fULL,
0x0000000311117812ULL, 0x000fe400078ec0ffULL, 0x0000003008217812ULL, 0x000fe200078ec0ffULL,
0x000000010a107824ULL, 0x000fe200078e0a09ULL, 0x000000080b097810ULL, 0x000fc40007ffe0ffULL,
0x000000100b0a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000b1a147210ULL, 0x040fe40007f1e0ffULL,
0x000000091a197210ULL, 0x040fe40007f3e0ffULL, 0x0000000a1a0a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0x00005e00140e7a11ULL, 0x000fe200078040ffULL,
0x000000ffff0c7224ULL, 0x000fe200008e06ffULL, 0x00005e0019177a11ULL, 0x000fe200078240ffULL,
0x000000ffff097224ULL, 0x000fe200010e06ffULL, 0x00005e000a0f7a11ULL, 0x000fc400078440ffULL,
0x000000180b087810ULL, 0x000fe40007ffe0ffULL, 0x000000101f00720cULL, 0x000fe40003f66070ULL,
0x00005f0014147a11ULL, 0x000fe400000f440dULL, 0x00005f0019197a11ULL, 0x000fe400008f440cULL,
0x000010005c137811ULL, 0x000fe400078e68ffULL, 0x0ffffffc11007812ULL, 0x000fc400078ef800ULL,
0x00005f000a127a11ULL, 0x000fe400010f4409ULL, 0x000000081a0d7210ULL, 0x000fe20007f3e0ffULL,
0x0000001000157824ULL, 0x000fe200078e0213ULL, 0x000000200b097810ULL, 0x000fe40007ffe0ffULL,
0x0000000e21087210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x000000091a1c7210ULL, 0x000fe40007f5e0ffULL, 0x000000300b0c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0614ULL, 0x00005e000d0e7a11ULL, 0x000fc400078840ffULL,
0x000000280b0a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c1a167210ULL, 0x040fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008157faeULL, 0x0003e2000d901c46ULL,
0x00005f000d007a11ULL, 0x000fe400020f4400ULL, 0x0000000a1a187210ULL, 0x000fe40007fde0ffULL,
0x000000210f0c7210ULL, 0x000fe40007f9e0ffULL, 0x000000081f1b7810ULL, 0x000fc40007ffe0ffULL,
0x00000021170a7210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200020e0612ULL,
0x000000380b0b7810ULL, 0x000fe20007ffe0ffULL, 0x000000041b127824ULL, 0x000fe200078e00ffULL,
0x000000101f177810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x002fe200010e06ffULL,
0x000000210e0e7210ULL, 0x000fe40007fbe0ffULL, 0x0000000b1a147210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200018e0619ULL, 0x000000181f1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000417087824ULL, 0x000fe200078e00ffULL, 0x000000101b00720cULL, 0x080fe20003f66070ULL,
0x000000ffff0f7224ULL, 0x000fe200028e0600ULL, 0x000000101700720cULL, 0x000fe20003f86070ULL,
0x000000041d1e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc12007812ULL, 0x000fc400078ee211ULL,
0x00005e001c1a7a11ULL, 0x000fe400078440ffULL, 0xfffffffc08087812ULL, 0x000fe200078ee211ULL,
0x0000001000097824ULL, 0x000fe200078e0213ULL, 0x000000201f197810ULL, 0x000fe40007ffe0ffULL,
0x000000101d00720cULL, 0x000fe40003fa6070ULL, 0x00005f001c1c7a11ULL, 0x000fe200010f4415ULL,
0x0000001008157824ULL, 0x000fe200078e0213ULL, 0x000000281f1b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000419007824ULL, 0x000fe200078e00ffULL, 0x000000301f1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000000a097faeULL, 0x0003e2000d901c46ULL, 0xfffffffc1e127812ULL, 0x100fe200078ee211ULL,
0x000000041b087824ULL, 0x000fe200078e00ffULL, 0x000000381f1f7810ULL, 0x000fe20007ffe0ffULL,
0x000000000c157faeULL, 0x0005e2000e101c46ULL, 0xfffffffc00007812ULL, 0x000fe200078ee211ULL,
0x0000001012177824ULL, 0x000fe200078e0213ULL, 0xfffffffc08087812ULL, 0x000fc400078ee211ULL,
0x000000101900720cULL, 0x080fe40003f46070ULL, 0x000000000e177faeULL, 0x0007e2000e901c46ULL,
0x000000041d0a7824ULL, 0x002fe200078e00ffULL, 0x000000101b00720cULL, 0x080fe20003f66070ULL,
0x000000ffff0b7224ULL, 0x000fe200008e06ffULL, 0x000000101d00720cULL, 0x080fe20003f86070ULL,
0x000000041f0c7824ULL, 0x044fe200078e00ffULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee211ULL,
0x0000001008157824ULL, 0x000fe200078e0213ULL, 0x000000101f00720cULL, 0x000fe20003fa6070ULL,
0x000000ffff0d7224ULL, 0x000fe200000e06ffULL, 0xfffffffc0c0c7812ULL, 0x000fe200078ee211ULL,
0x0000001000117824ULL, 0x000fc400078e0213ULL, 0x000000ffff0f7224ULL, 0x008fe200030e06ffULL,
0x00005e0018007a11ULL, 0x000fe200078c40ffULL, 0x000000100a177824ULL, 0x100fe400078e0213ULL,
0x000000100c137824ULL, 0x000fe200078e0213ULL, 0x00005f00180f7a11ULL, 0x000fe400030f440fULL,
0x000000211a087210ULL, 0x080fe40007fde0ffULL, 0x00005e00160c7a11ULL, 0x000fe400078040ffULL,
0x00000021000a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff097224ULL, 0x000fe200030e061cULL,
0x00005e00140e7a11ULL, 0x000fc400078c40ffULL, 0x00005f00160d7a11ULL, 0x000fe400000f440dULL,
0x00005f0014007a11ULL, 0x000fe200030f440bULL, 0x000000ffff0b7224ULL, 0x000fe200008e060fULL,
0x000000210c0c7210ULL, 0x080fe20007f1e0ffULL, 0x0000000008117faeULL, 0x0003e2000d101c46ULL,
0x000000210e0e7210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x000000000a157faeULL, 0x0003e2000d901c46ULL, 0x000000ffff0f7224ULL, 0x000fc600008e0600ULL,
0x000000000c177faeULL, 0x0003e8000e101c46ULL, 0x000000000e137faeULL, 0x0003e2000e901c46ULL,
0x0000065000007947ULL, 0x000fea0003800000ULL, 0x0000000300097211ULL, 0x042fe400078ff0ffULL,
0x0000000800187811ULL, 0x000fe400078ff0ffULL, 0x000000091a097210ULL, 0x000fe40007f1e0ffULL,
0x00000010000a7811ULL, 0x000fc400078ff0ffULL, 0x00000018000c7811ULL, 0x040fe200078ff0ffULL,
0x000000ffff247224ULL, 0x000fe200000e06ffULL, 0x00005e0009227a11ULL, 0x000fe200078040ffULL,
0x00000001030b7824ULL, 0x040fe200078e020aULL, 0x00000020000e7811ULL, 0x040fe200078ff0ffULL,
0x00000001030d7824ULL, 0x040fe200078e020cULL, 0x0000002800107811ULL, 0x000fe200078ff0ffULL,
0x000000040a0a7824ULL, 0x000fe200078e00ffULL, 0x0000003000127811ULL, 0x040fe200078ff0ffULL,
0x00000001030f7824ULL, 0x040fe200078e020eULL, 0x0000003800147811ULL, 0x040fe200078ff0ffULL,
0x0000000103117824ULL, 0x040fe200078e0210ULL, 0x0000000000177211ULL, 0x000fe200078fe8ffULL,
0x0000000103137824ULL, 0x000fe200078e0212ULL, 0x00005f0009247a11ULL, 0x000fe200000f4424ULL,
0x0000000103097824ULL, 0x000fe200078e0218ULL, 0x0000000317197812ULL, 0x000fe200078ec0ffULL,
0x0000000103157824ULL, 0x000fe200078e0214ULL, 0x0000000b1a167210ULL, 0x000fe20007fbe0ffULL,
0x000000040c0c7824ULL, 0x000fe200078e00ffULL, 0x000000091a207210ULL, 0x000fe20007fde0ffULL,
0x000000040e0e7824ULL, 0x000fe200078e00ffULL, 0x0000000d1a1c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000412127824ULL, 0x000fe200078e00ffULL, 0x0000000f1a0f7210ULL, 0x000fe20007f3e0ffULL,
0x0000000418187824ULL, 0x000fe200078e00ffULL, 0x000000111a117210ULL, 0x000fe20007f5e0ffULL,
0x0000000414147824ULL, 0x000fe200078e00ffULL, 0x000000131a137210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe200030e06ffULL, 0x000000151a157210ULL, 0x000fe20007f9e0ffULL,
0x00000004101a7824ULL, 0x000fe200078e00ffULL, 0x000010005c257811ULL, 0x000fc400078e68ffULL,
0x0ffffffc19107812ULL, 0x000fe400078ef800ULL, 0xfffffffc0a097812ULL, 0x100fe400078ee219ULL,
0xfffffffc0c0a7812ULL, 0x000fe200078ee219ULL, 0x0000001010277824ULL, 0x000fe200078e0225ULL,
0xfffffffc0e0b7812ULL, 0x000fe200078ee219ULL, 0x00000010091b7824ULL, 0x000fe200078e0225ULL,
0xfffffffc1a0c7812ULL, 0x000fe200078ee219ULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x00005e000f107a11ULL, 0x000fe200078240ffULL, 0x000000100b1f7824ULL, 0x000fe200078e0225ULL,
0xfffffffc120d7812ULL, 0x000fe200078ee219ULL, 0x000000ffff097224ULL, 0x000fe200000e06ffULL,
0x00005e001c0b7a11ULL, 0x000fe200078040ffULL, 0x000000100c217824ULL, 0x100fe200078e0225ULL,
0x00005f000f1a7a11ULL, 0x000fe200008f441aULL, 0x000000100d237824ULL, 0x000fe200078e0225ULL,
0x00000030080f7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff0d7224ULL, 0x000fe200028e06ffULL,
0xfffffffc18007812ULL, 0x000fe200078ee219ULL, 0x000000100a1d7824ULL, 0x000fe200078e0225ULL,
0x00005e00160c7a11ULL, 0x000fe200078a40ffULL, 0x000000ffff187224ULL, 0x000fe200010e06ffULL,
0x00005f001c1c7a11ULL, 0x000fe200000f4409ULL, 0x000000ffff0a7224ULL, 0x000fe200018e06ffULL,
0x00005e00201e7a11ULL, 0x000fc400078c40ffULL, 0xfffffffc140e7812ULL, 0x000fe200078ee219ULL,
0x0000001000197824ULL, 0x100fe200078e0225ULL, 0x000000220f087210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200020e06ffULL, 0x00005e0013147a11ULL, 0x000fe200078440ffULL,
0x000000100e257824ULL, 0x000fe200078e0225ULL, 0x00005e0011127a11ULL, 0x000fe200078240ffULL,
0x000000ffff097224ULL, 0x000fe200000e0624ULL, 0x00005f00160d7a11ULL, 0x000fe400028f440dULL,
0x00005f0020207a11ULL, 0x000fc400030f4417ULL, 0x00005e0015167a11ULL, 0x000fe200078640ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008277faeULL, 0x0003e2000b901c46ULL,
0x00005f0013177a11ULL, 0x000fe400010f440aULL, 0x00005f0011187a11ULL, 0x000fe400008f4418ULL,
0x0000001e0f0a7210ULL, 0x040fe40007f1e0ffULL, 0x0000000c0f0c7210ULL, 0x000fe40007f3e0ffULL,
0x00005f0015007a11ULL, 0x000fc400018f4400ULL, 0x0000000b0f0e7210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff0b7224ULL, 0x000fe200000e0620ULL, 0x000000100f107210ULL, 0x040fe20007f7e0ffULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x000000120f127210ULL, 0x040fe40007f9e0ffULL,
0x000000140f147210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200018e061aULL,
0x000000160f167210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0f7224ULL, 0x000fe200010e061cULL,
0x000000000a197faeULL, 0x0003e2000b901c46ULL, 0x000000ffff137224ULL, 0x000fc400020e0618ULL,
0x000000ffff157224ULL, 0x000fe200028e0617ULL, 0x000000000c1b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff177224ULL, 0x000fc600000e0600ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c46ULL,
0x00000000101f7faeULL, 0x0003e8000b901c46ULL, 0x0000000012217faeULL, 0x0003e8000b901c46ULL,
0x0000000014237faeULL, 0x0003e8000b901c46ULL, 0x0000000016257faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000087805ULL, 0x002fc40000015200ULL,
0x01360400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001140bULL,
0x0000000d00007211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x0000000200007819ULL, 0x000fc8000000120bULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01360400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000595e00720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000000067919ULL, 0x000e620000000000ULL, 0x0000640053537a24ULL, 0x000fe200078e02ffULL,
0x000136885c507811ULL, 0x040fe200078e18ffULL, 0x000000205c007824ULL, 0x000fe200078e00ffULL,
0xffffffff59517810ULL, 0x000fc40007ffe0ffULL, 0x000001005e077824ULL, 0x000fe200078e0205ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000075a00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x00cfea0003800000ULL, 0x000000015e087810ULL, 0x000fe20007ffe0ffULL,
0x0000006f026c7224ULL, 0x000fc600078e02ffULL, 0x000000590800720cULL, 0x000fda0003f06070ULL,
0x000006a000008947ULL, 0x000fea0003800000ULL, 0x00000002ff157819ULL, 0x002fe40000011606ULL,
0x00000003066e7812ULL, 0x000fe400078ec0ffULL, 0x00000008151b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000103097824ULL, 0x000fe200078e0215ULL, 0x0000001015217810ULL, 0x040fe40007ffe0ffULL,
0x0000001815237810ULL, 0x000fe20007ffe0ffULL, 0x000000041b1d7824ULL, 0x000fe200078e00ffULL,
0x000000096c097210ULL, 0x040fe20007f3e0ffULL, 0x00000001030b7824ULL, 0x000fe200078e0221ULL,
0x0000002015247810ULL, 0x000fe20007ffe0ffULL, 0x00000001030d7824ULL, 0x000fe200078e0223ULL,
0x0000002815257810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff087224ULL, 0x000fe200008e06ffULL,
0x00005e00090e7a11ULL, 0x000fe200078240ffULL, 0x0000000103117824ULL, 0x000fe200078e0224ULL,
0x0000000b6c0b7210ULL, 0x000fc40007f7e0ffULL, 0x00005f00090f7a11ULL, 0x000fe200008f4408ULL,
0x0000000103097824ULL, 0x000fe200078e021bULL, 0x000000116c117210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff147224ULL, 0x000fe200018e06ffULL, 0x00005e000b0c7a11ULL, 0x000fe400078640ffULL,
0x000000096c137210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff107224ULL, 0x000fe200008e06ffULL,
0x0000000d6c097210ULL, 0x000fe40007f9e0ffULL, 0x00005e0011087a11ULL, 0x000fe200078240ffULL,
0x000000ffff187224ULL, 0x000fe200010e06ffULL, 0x00005e0013167a11ULL, 0x000fe200078440ffULL,
0x000000ffff127224ULL, 0x000fe200020e06ffULL, 0x00005e00090a7a11ULL, 0x000fc400078840ffULL,
0x00005f000b0d7a11ULL, 0x000fe400018f4414ULL, 0x00005f00090b7a11ULL, 0x000fe400020f4412ULL,
0x00005f0013177a11ULL, 0x000fe200010f4418ULL, 0x000000015a187824ULL, 0x000fe200078e0a07ULL,
0x00005f0011097a11ULL, 0x000fe200008f4410ULL, 0x0000000103117824ULL, 0x000fe200078e0225ULL,
0x0000000606107211ULL, 0x040fe400078fe8ffULL, 0x0ffffffc06397812ULL, 0x000fc400078ec0ffULL,
0x0000000310227812ULL, 0x000fe400078ec0ffULL, 0x0000003815277810ULL, 0x040fe40007ffe0ffULL,
0x000000181500720cULL, 0x0c0fe40003f46070ULL, 0x0000003015267810ULL, 0x000fe20007ffe0ffULL,
0x0000000103157824ULL, 0x000fe200078e0227ULL, 0x000000181b00720cULL, 0x000fe40003f26070ULL,
0x000020005c1a7811ULL, 0x000fe200078e68ffULL, 0x0000000103137824ULL, 0x000fe200078e0226ULL,
0x000000046e197812ULL, 0x000fe200078efcffULL, 0x0000000426297824ULL, 0x000fe200078e00ffULL,
0x00000039221b7212ULL, 0x000fc400078efcffULL, 0xfffffffc1d1d7812ULL, 0x000fe200078ee222ULL,
0x00000010190e7825ULL, 0x000fe200078e000eULL, 0x000000116c1f7210ULL, 0x040fe40007f9e0ffULL,
0x000000156c117210ULL, 0x040fe20007f7e0ffULL, 0x000000101b1b7824ULL, 0x100fe200078e021aULL,
0x000000136c137210ULL, 0x000fe20007fbe0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e021aULL,
0x000000182700720cULL, 0x080fe20003fc6070ULL, 0x0000001019167825ULL, 0x000fe200078e0016ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e1b7faeULL, 0x0003e2000d101c46ULL,
0x000000182300720cULL, 0x000fc40003f46070ULL, 0x000000ffff207224ULL, 0x000fe200020e06ffULL,
0x00005e001f147a11ULL, 0x000fe200078840ffULL, 0x000000ffff1c7224ULL, 0x000fe200018e06ffULL,
0x00000000161d7faeULL, 0x0005e2000c901c46ULL, 0x00005e0011107a11ULL, 0x000fe200078640ffULL,
0x000000ffff1e7224ULL, 0x000fe200028e06ffULL, 0x000000182100720cULL, 0x0c0fe20003f26070ULL,
0x0000000421217824ULL, 0x000fe200078e00ffULL, 0x00005e0013127a11ULL, 0x000fe200078a40ffULL,
0x0000000423237824ULL, 0x000fe200078e00ffULL, 0x00005f001f157a11ULL, 0x000fe200020f4420ULL,
0x00000004241f7824ULL, 0x040fe200078e00ffULL, 0x000000182500720cULL, 0x0c0fe20003f86070ULL,
0x0000000425257824ULL, 0x000fe200078e00ffULL, 0x00005f0011117a11ULL, 0x000fe200018f441cULL,
0x0000000427277824ULL, 0x000fe200078e00ffULL, 0x000000182400720cULL, 0x000fe20003f66070ULL,
0x00000010190c7825ULL, 0x000fe200078e000cULL, 0x00005f0013137a11ULL, 0x000fc400028f441eULL,
0xfffffffc210f7812ULL, 0x002fe200078ee222ULL, 0x00000010190a7825ULL, 0x000fe200078e000aULL,
0x000000182600720cULL, 0x000fe40003fa6070ULL, 0xfffffffc23177812ULL, 0x004fe200078ee222ULL,
0x000000100f0f7824ULL, 0x000fe200078e021aULL, 0xfffffffc1f1b7812ULL, 0x000fe200078ee222ULL,
0x0000001019087825ULL, 0x000fe200078e0008ULL, 0xfffffffc251d7812ULL, 0x100fe400078ee222ULL,
0xfffffffc291f7812ULL, 0x000fe200078ee222ULL, 0x0000001017177824ULL, 0x000fe200078e021aULL,
0xfffffffc27217812ULL, 0x000fe200078ee222ULL, 0x000000101b1b7824ULL, 0x100fe200078e021aULL,
0x000000000c0f7faeULL, 0x0003e2000c901c46ULL, 0x000000101d1d7824ULL, 0x000fc400078e021aULL,
0x0000001019147825ULL, 0x000fe200078e0014ULL, 0x000000000a177faeULL, 0x0003e6000d101c46ULL,
0x000000101f1f7824ULL, 0x000fe200078e021aULL, 0x00000000081b7faeULL, 0x0003e2000d901c46ULL,
0x0000001019127825ULL, 0x000fc600078e0012ULL, 0x00000000141d7faeULL, 0x0003e2000e101c46ULL,
0x0000001021217824ULL, 0x000fe400078e021aULL, 0x0000001019107825ULL, 0x000fe200078e0010ULL,
0x00000000121f7faeULL, 0x0003e8000e901c46ULL, 0x0000000010217faeULL, 0x0003e2000f101c46ULL,
0x000005f000007947ULL, 0x000fea0003800000ULL, 0x0000000306097211ULL, 0x042fe400078ff0ffULL,
0x0000002006167811ULL, 0x000fc400078ff0ffULL, 0x0000006c09097210ULL, 0x000fe40007f3e0ffULL,
0x00000008060c7811ULL, 0x000fe200078ff0ffULL, 0x0000000416177824ULL, 0x000fe200078e00ffULL,
0x00000010060e7811ULL, 0x000fe200078ff0ffULL, 0x000000ffff0a7224ULL, 0x000fe200008e06ffULL,
0x00005e0009087a11ULL, 0x000fe200078240ffULL, 0x000000040c117824ULL, 0x000fe200078e00ffULL,
0x0000001806107811ULL, 0x040fe200078ff0ffULL, 0x00000001030d7824ULL, 0x040fe200078e020eULL,
0x00000006060b7211ULL, 0x000fe200078fe8ffULL, 0x000000040e137824ULL, 0x000fe200078e00ffULL,
0x0000002806187811ULL, 0x000fe200078ff0ffULL, 0x0000000410157824ULL, 0x000fe200078e00ffULL,
0x00000030061a7811ULL, 0x040fe200078ff0ffULL, 0x00000001030f7824ULL, 0x000fe200078e0210ULL,
0x00000038061e7811ULL, 0x000fe200078ff0ffULL, 0x0000000418197824ULL, 0x000fe200078e00ffULL,
0x00005f0009097a11ULL, 0x000fe200008f440aULL, 0x000000041a1b7824ULL, 0x000fe200078e00ffULL,
0x000000030b0a7812ULL, 0x000fe200078ec0ffULL, 0x000000041e1d7824ULL, 0x000fe200078e00ffULL,
0x0ffffffc06397812ULL, 0x000fe200078ec0ffULL, 0x00000001030b7824ULL, 0x000fe200078e020cULL,
0x000020005c257811ULL, 0x000fc400078e68ffULL, 0xfffffffc17127812ULL, 0x000fe200078ee20aULL,
0x0000000103177824ULL, 0x000fe200078e021eULL, 0xfffffffc110c7812ULL, 0x000fe200078ee20aULL,
0x0000000103117824ULL, 0x000fe200078e0216ULL, 0xfffffffc15107812ULL, 0x000fe200078ee20aULL,
0x00000010121f7824ULL, 0x100fe200078e0225ULL, 0x0000006c0d0d7210ULL, 0x080fe20007f5e0ffULL,
0x0000000103157824ULL, 0x000fe200078e021aULL, 0xfffffffc130e7812ULL, 0x000fe200078ee20aULL,
0x0000000103137824ULL, 0x000fe200078e0218ULL, 0x0000006c0f0f7210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0xfffffffc19147812ULL, 0x100fe200078ee20aULL,
0x000000100c197824ULL, 0x100fe200078e0225ULL, 0xfffffffc1b1c7812ULL, 0x100fe200078ee20aULL,
0x000000100e1b7824ULL, 0x100fe200078e0225ULL, 0xfffffffc1d207812ULL, 0x000fe200078ee20aULL,
0x00000010101d7824ULL, 0x100fe200078e0225ULL, 0x000000390a0a7212ULL, 0x000fe200078efcffULL,
0x000000ffff107224ULL, 0x000fe200018e06ffULL, 0x0000006c0b0b7210ULL, 0x000fe20007f3e0ffULL,
0x0000001014217824ULL, 0x100fe200078e0225ULL, 0x00005e000d0c7a11ULL, 0x000fe200078440ffULL,
0x000000100a297824ULL, 0x100fe200078e0225ULL, 0x00005e000f0e7a11ULL, 0x000fe200078640ffULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x00005e000b0a7a11ULL, 0x000fe200078240ffULL,
0x000000101c237824ULL, 0x100fe200078e0225ULL, 0x00005f000d0d7a11ULL, 0x000fe200010f4412ULL,
0x0000001020257824ULL, 0x000fe200078e0225ULL, 0x00005f000f0f7a11ULL, 0x000fc400018f4410ULL,
0x0000006c11117210ULL, 0x080fe40007f5e0ffULL, 0x0000006c13137210ULL, 0x080fe40007f7e0ffULL,
0x00005f000b0b7a11ULL, 0x000fe200008f4414ULL, 0x000000ffff1e7224ULL, 0x000fe200010e06ffULL,
0x00000003066e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1c7224ULL, 0x000fe200018e06ffULL,
0x0000006c15157210ULL, 0x080fe40007f9e0ffULL, 0x0000006c17177210ULL, 0x000fc40007f3e0ffULL,
0x000000046e277812ULL, 0x000fe200078efcffULL, 0x000000ffff1a7224ULL, 0x000fe200020e06ffULL,
0x00005e0011107a11ULL, 0x000fe200078440ffULL, 0x000000ffff187224ULL, 0x000fe200008e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078640ffULL, 0x0000001027087825ULL, 0x000fe200078e0008ULL,
0x00005e0015147a11ULL, 0x000fe400078840ffULL, 0x00005e0017167a11ULL, 0x000fe200078240ffULL,
0x00000010270a7825ULL, 0x000fe200078e000aULL, 0x00005f0011117a11ULL, 0x000fe200010f441eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008297faeULL, 0x0003e2000b901c46ULL,
0x00005f0013137a11ULL, 0x000fe200018f441cULL, 0x00000010270c7825ULL, 0x000fe200078e000cULL,
0x00005f0015157a11ULL, 0x000fe200020f441aULL, 0x000000000a197faeULL, 0x0003e2000b901c46ULL,
0x00005f0017177a11ULL, 0x000fe200008f4418ULL, 0x00000010270e7825ULL, 0x000fc400078e000eULL,
0x000000000c1b7faeULL, 0x0003e4000b901c46ULL, 0x0000001027107825ULL, 0x040fe400078e0010ULL,
0x000000000e1d7faeULL, 0x0003e4000b901c46ULL, 0x0000001027127825ULL, 0x040fe400078e0012ULL,
0x00000000101f7faeULL, 0x0003e4000b901c46ULL, 0x0000001027147825ULL, 0x000fc400078e0014ULL,
0x0000000012217faeULL, 0x0003e4000b901c46ULL, 0x0000001027167825ULL, 0x000fe400078e0016ULL,
0x0000000014237faeULL, 0x0003e8000b901c46ULL, 0x0000000016257faeULL, 0x0003e4000b901c46ULL,
0x00000004ff0b7819ULL, 0x102fe20000011606ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000000706097812ULL, 0x000fe200078ec0ffULL, 0x000020005c6f7824ULL, 0x000fe200078e00ffULL,
0x00000003ff3b7819ULL, 0x100fe20000011606ULL, 0x000000080b0a7824ULL, 0x000fe200078e00ffULL,
0x0000000809527812ULL, 0x000fc400078ef806ULL, 0x000010006f557810ULL, 0x000fe40007ffe0ffULL,
0xfffffff80a0a7812ULL, 0x000fe200078ee209ULL, 0x000000010b547824ULL, 0x000fe200078e0252ULL,
0x000000013b097812ULL, 0x000fe200078ec0ffULL, 0x00000010520b7824ULL, 0x000fe200078e00ffULL,
0x000000100a0c7810ULL, 0x040fe20007ffe0ffULL, 0x000000040a627824ULL, 0x040fe200078e00ffULL,
0x000000200a0e7810ULL, 0x040fe20007ffe0ffULL, 0x000000040a117824ULL, 0x040fe200078e00ffULL,
0x000000300a107810ULL, 0x000fe20007ffe0ffULL, 0x000000040c0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff00b087812ULL, 0x000fe200078ee254ULL, 0x000000040e607824ULL, 0x000fe200078e00ffULL,
0x000000090a0b7211ULL, 0x080fe200078ff8ffULL, 0x0000000410387824ULL, 0x000fe200078e00ffULL,
0x000000090c0a7211ULL, 0x080fe200078ff8ffULL, 0x0000001008087824ULL, 0x000fe200078e00ffULL,
0x000000090e0d7211ULL, 0x000fe200078ff8ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000910097211ULL, 0x000fe200078ff8ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0xfffffffc62627812ULL, 0x000fe200078ee20bULL, 0x000000000824783bULL, 0x000fe20000000200ULL,
0xfffffffc0f3a7812ULL, 0x000fe200078ee20aULL, 0x0000001052127824ULL, 0x000fe200078e00ffULL,
0xfffffffc60607812ULL, 0x000fe200078ee20dULL, 0x00000010626d7824ULL, 0x000fe200078e0255ULL,
0xfffffffc38387812ULL, 0x000fe200078ee209ULL, 0x000000103a6b7824ULL, 0x100fe200078e0255ULL,
0x000000020b747810ULL, 0x000fe20007ffe0ffULL, 0x00000010606a7824ULL, 0x100fe200078e0255ULL,
0x000000006d30783bULL, 0x000e620000000200ULL, 0x0000001038697824ULL, 0x000fe200078e0255ULL,
0x000000020a587810ULL, 0x000fe20007ffe0ffULL, 0x000000040c0b7824ULL, 0x000fe200078e00ffULL,
0x000000006b2c783bULL, 0x000ea20000000200ULL, 0x000000020d727810ULL, 0x000fe20007ffe0ffULL,
0x00000004100d7824ULL, 0x000fe200078e00ffULL, 0x00000002540f7810ULL, 0x000fe20007ffe0ffULL,
0x000000006a28783bULL, 0x000ee20000000200ULL, 0xfffffffc0b587812ULL, 0x000fe200078ee258ULL,
0x000000040e0b7824ULL, 0x000fe200078e00ffULL, 0x0000000209567810ULL, 0x000fe20007ffe0ffULL,
0x000000006934783bULL, 0x000f220000000200ULL, 0xfffffff0120f7812ULL, 0x000fe200078ee20fULL,
0x0000001058677824ULL, 0x000fe200078e0255ULL, 0xfffffffc11747812ULL, 0x000fc400078ee274ULL,
0xfffffffc0b727812ULL, 0x000fe200078ee272ULL, 0x000000100f0f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0d567812ULL, 0x000fe200078ee256ULL, 0x0000001074687824ULL, 0x100fe200078e0255ULL,
0x000000006708783bULL, 0x000fe20000000200ULL, 0x0000001072667824ULL, 0x100fe400078e0255ULL,
0x0000001056657824ULL, 0x000fe200078e0255ULL, 0x000000000f18783bULL, 0x0007e80000000200ULL,
0x000000006848783bULL, 0x000f280000000200ULL, 0x000000006610783bULL, 0x000f280000000200ULL,
0x000000006520783bULL, 0x000f220000000200ULL, 0x00000030241c723cULL, 0x042f7000000018ffULL,
0x0000002c2444723cULL, 0x044f7000000018ffULL, 0x00000028240c723cULL, 0x048f7000000018ffULL,
0x000000322430723cULL, 0x040f7000000018ffULL, 0x0000002e242c723cULL, 0x040f7000000018ffULL,
0x0000002a2428723cULL, 0x040f7000000018ffULL, 0x000000342414723cULL, 0x050f7000000018ffULL,
0x000000362424723cULL, 0x000f7000000018ffULL, 0x00000048181c723cULL, 0x060b70000000181cULL,
0x000000081844723cULL, 0x040b700000001844ULL, 0x00000010180c723cULL, 0x040b70000000180cULL,
0x0000004a1848723cULL, 0x040b700000001830ULL, 0x0000000a1808723cULL, 0x040b70000000182cULL,
0x000000121810723cULL, 0x040b700000001828ULL, 0x000000201814723cULL, 0x040b700000001814ULL,
0x000000221818723cULL, 0x000b620000001824ULL, 0x0000067000008947ULL, 0x000fce0003800000ULL,
0x00000002ff3e7819ULL, 0x100fe20000011606ULL, 0x000000015a357824ULL, 0x000fe200078e0a07ULL,
0x000000086e317812ULL, 0x020fe200078efcffULL, 0x000000013b3b7824ULL, 0x000fe200078e0206ULL,
0x000000083e2e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000103217824ULL, 0x000fe200078e023eULL,
0x000000103e3c7810ULL, 0x000fc40007ffe0ffULL, 0x000000183e307810ULL, 0x000fe20007ffe0ffULL,
0x0000000103237824ULL, 0x040fe200078e022eULL, 0x000000216c217210ULL, 0x000fe20007f3e0ffULL,
0x0000000103257824ULL, 0x040fe200078e023cULL, 0x000000203e327810ULL, 0x000fe20007ffe0ffULL,
0x0000000103277824ULL, 0x000fe200078e0230ULL, 0x000000236c237210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff207224ULL, 0x000fe200008e06ffULL, 0x00005e0021287a11ULL, 0x000fe200078240ffULL,
0x00000001032b7824ULL, 0x000fe200078e0232ULL, 0x000000256c257210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff247224ULL, 0x000fe200010e06ffULL, 0x00005f0021297a11ULL, 0x000fe200008f4420ULL,
0x000000042e337824ULL, 0x000fe200078e00ffULL, 0x00005e0023207a11ULL, 0x000fe200078240ffULL,
0x000000ffff267224ULL, 0x000fe200018e06ffULL, 0x000000283e347810ULL, 0x000fe20007ffe0ffULL,
0x0000001031287825ULL, 0x000fe200078e0028ULL, 0x00005f0023217a11ULL, 0x000fc400008f4424ULL,
0x000000276c277210ULL, 0x000fe20007f3e0ffULL, 0x00000001032d7824ULL, 0x000fe200078e0234ULL,
0x000000303e367810ULL, 0x000fe20007ffe0ffULL, 0x0000001031207825ULL, 0x000fe200078e0020ULL,
0x00005e0025227a11ULL, 0x000fe400078440ffULL, 0x000000033b647812ULL, 0x000fe200078ec0ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x00005e0027247a11ULL, 0x000fe200078240ffULL,
0x00000001032f7824ULL, 0x000fe200078e0236ULL, 0x00005f0025237a11ULL, 0x000fe200010f4426ULL,
0x000000043c377824ULL, 0x000fe200078e00ffULL, 0x00005f0027257a11ULL, 0x000fc400008f442aULL,
0x0000002b6c2b7210ULL, 0x040fe20007f5e0ffULL, 0x0000001031227825ULL, 0x000fe200078e0022ULL,
0x0000002d6c2d7210ULL, 0x040fe40007f3e0ffULL, 0x0000002f6c2f7210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x00005e002b267a11ULL, 0x000fe200078440ffULL,
0x000000ffff407224ULL, 0x000fe200008e06ffULL, 0x000000353e00720cULL, 0x040fe20003f26070ULL,
0x000000ffff427224ULL, 0x000fe200018e06ffULL, 0x00005e002f2a7a11ULL, 0x000fe200078640ffULL,
0x0000001031247825ULL, 0x000fe200078e0024ULL, 0x000000383e3e7810ULL, 0x000fc40007ffe0ffULL,
0x00005f002b277a11ULL, 0x000fe400010f442cULL, 0x00005f002f2b7a11ULL, 0x000fe200018f4442ULL,
0x00000001032f7824ULL, 0x000fe200078e023eULL, 0x00005e002d2c7a11ULL, 0x000fe200078440ffULL,
0x0000001031267825ULL, 0x000fe200078e0026ULL, 0x0000003964707212ULL, 0x000fe400078efcffULL,
0x00005f002d2d7a11ULL, 0x000fe200010f4440ULL, 0x00000010312a7825ULL, 0x000fe200078e002aULL,
0x000000352e00720cULL, 0x000fc40003f46070ULL, 0x0000002f6c2f7210ULL, 0x000fe20007f7e0ffULL,
0x0000001070637824ULL, 0x000fe200078e0255ULL, 0xfffffffc33407812ULL, 0x000fe200078ee264ULL,
0x00000010312c7825ULL, 0x000fe200078e002cULL, 0x000000353400720cULL, 0x080fe40003f86070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028637faeULL, 0x0003e2000c901c46ULL,
0x000000ffff427224ULL, 0x000fe200018e06ffULL, 0x00005e002f2e7a11ULL, 0x000fe200078640ffULL,
0x0000001040337824ULL, 0x000fe200078e0255ULL, 0x000000353c00720cULL, 0x000fc40003f26070ULL,
0x00005f002f2f7a11ULL, 0x000fe400018f4442ULL, 0x0000000020337faeULL, 0x0005e2000d101c46ULL,
0xfffffffc373c7812ULL, 0x000fe200078ee264ULL, 0x000000043e377824ULL, 0x000fe200078e00ffULL,
0x000000353000720cULL, 0x080fe20003f46070ULL, 0x00000010312e7825ULL, 0x000fe200078e002eULL,
0x000000353200720cULL, 0x080fe40003f66070ULL, 0x000000353600720cULL, 0x080fe20003fa6070ULL,
0x0000000432297824ULL, 0x002fe200078e00ffULL, 0x000000353e00720cULL, 0x000fe20003fc6070ULL,
0x0000000434317824ULL, 0x000fe200078e00ffULL, 0xfffffffc37347812ULL, 0x100fe200078ee264ULL,
0x0000000430217824ULL, 0x004fe200078e00ffULL, 0xfffffffc29287812ULL, 0x100fe200078ee264ULL,
0x0000000436337824ULL, 0x000fe200078e00ffULL, 0xfffffffc31307812ULL, 0x100fe200078ee264ULL,
0x000000103c357824ULL, 0x000fe200078e0255ULL, 0xfffffffc21207812ULL, 0x000fc400078ee264ULL,
0xfffffffc33327812ULL, 0x000fe200078ee264ULL, 0x0000001030297824ULL, 0x100fe200078e0255ULL,
0x0000000022357faeULL, 0x0003e2000c901c46ULL, 0x0000001020217824ULL, 0x100fe400078e0255ULL,
0x0000001032317824ULL, 0x100fe400078e0255ULL, 0x0000001034337824ULL, 0x100fe200078e0255ULL,
0x0000000024217faeULL, 0x0005e2000d101c46ULL, 0x0000001028237824ULL, 0x002fca00078e0255ULL,
0x0000000026237faeULL, 0x0005e8000d901c46ULL, 0x000000002c297faeULL, 0x0005e8000e101c46ULL,
0x000000002a317faeULL, 0x0005e8000e901c46ULL, 0x000000002e337faeULL, 0x0005e2000f101c46ULL,
0x000005c000007947ULL, 0x000fea0003800000ULL, 0x00000008062c7811ULL, 0x060fe200078ff0ffULL,
0x000000013b3b7824ULL, 0x000fe200078e0206ULL, 0x0000000306217211ULL, 0x000fc400078ff0ffULL,
0x0000001806347811ULL, 0x000fe200078ff0ffULL, 0x0000000103237824ULL, 0x000fe200078e022cULL,
0x0000006c21217210ULL, 0x080fe20007f3e0ffULL, 0x000000042c337824ULL, 0x000fe200078e00ffULL,
0x00000010062e7811ULL, 0x000fe400078ff0ffULL, 0x0000006c23237210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff207224ULL, 0x000fe200008e06ffULL, 0x00005e00212a7a11ULL, 0x000fe200078240ffULL,
0x000000042e377824ULL, 0x000fe200078e00ffULL, 0x0000002806307811ULL, 0x000fe200078ff0ffULL,
0x000000ffff227224ULL, 0x000fe200010e06ffULL, 0x00005e0023287a11ULL, 0x000fc400078440ffULL,
0x00005f00212b7a11ULL, 0x000fe200008f4420ULL, 0x0000000103217824ULL, 0x000fe200078e022eULL,
0x00005f0023297a11ULL, 0x000fe200010f4422ULL, 0x0000000103237824ULL, 0x040fe200078e0234ULL,
0x0000002006327811ULL, 0x000fe200078ff0ffULL, 0x0000000103277824ULL, 0x000fe200078e0230ULL,
0x0000006c21217210ULL, 0x080fe40007f5e0ffULL, 0x0000006c23237210ULL, 0x080fe20007f7e0ffULL,
0x0000000103257824ULL, 0x000fe200078e0232ULL, 0x0000006c27277210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff367224ULL, 0x000fe200010e06ffULL, 0x00005e0021207a11ULL, 0x000fe200078440ffULL,
0x000000ffff3c7224ULL, 0x000fe200018e06ffULL, 0x00005e0023227a11ULL, 0x000fe200078640ffULL,
0x000000ffff407224ULL, 0x000fe200008e06ffULL, 0x00005f0021217a11ULL, 0x000fc400010f4436ULL,
0x00005f0023237a11ULL, 0x000fe400018f443cULL, 0x00000030063c7811ULL, 0x040fe400078ff0ffULL,
0x0000003806367811ULL, 0x000fe400078ff0ffULL, 0x0000006c25257210ULL, 0x000fe20007f9e0ffULL,
0x00000001032d7824ULL, 0x000fe200078e023cULL, 0x00005e0027267a11ULL, 0x000fe200078240ffULL,
0x00000001032f7824ULL, 0x000fe200078e0236ULL, 0x000000033b647812ULL, 0x000fe200078ec0ffULL,
0x000000ffff3e7224ULL, 0x000fe200020e06ffULL, 0x00005f0027277a11ULL, 0x000fe200008f4440ULL,
0x00000004363b7824ULL, 0x000fe200078e00ffULL, 0x00005e0025247a11ULL, 0x000fc400078840ffULL,
0x0000006c2d2d7210ULL, 0x080fe40007f3e0ffULL, 0x0000006c2f317210ULL, 0x000fe40007f5e0ffULL,
0x00005f0025257a11ULL, 0x000fe200020f443eULL, 0x000000ffff3e7224ULL, 0x000fe200008e06ffULL,
0x000000086e357812ULL, 0x000fe200078efcffULL, 0x000000ffff427224ULL, 0x000fe200010e06ffULL,
0x0000003964707212ULL, 0x000fe200078efcffULL, 0x000000043c397824ULL, 0x000fe200078e00ffULL,
0x00005e002d2e7a11ULL, 0x000fe200078240ffULL, 0x00000010352a7825ULL, 0x000fe200078e002aULL,
0x00005e00312c7a11ULL, 0x000fc400078440ffULL, 0x00005f002d2f7a11ULL, 0x000fe200008f443eULL,
0x0000001070637824ULL, 0x000fe200078e0255ULL, 0x00005f00312d7a11ULL, 0x000fe200010f4442ULL,
0x0000001035287825ULL, 0x000fe200078e0028ULL, 0xfffffffc333e7812ULL, 0x100fe400078ee264ULL,
0xfffffffc37407812ULL, 0x000fe200078ee264ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002a637faeULL, 0x0003e2000b901c46ULL, 0x0000001035207825ULL, 0x000fc800078e0020ULL,
0x0000001035227825ULL, 0x000fc800078e0022ULL, 0x0000001035247825ULL, 0x000fc800078e0024ULL,
0x0000001035267825ULL, 0x000fc800078e0026ULL, 0x00000010352e7825ULL, 0x000fc800078e002eULL,
0x00000010352c7825ULL, 0x000fc800078e002cULL, 0x00000004342b7824ULL, 0x002fe200078e00ffULL,
0xfffffffc39347812ULL, 0x100fe200078ee264ULL, 0x0000000432357824ULL, 0x000fe400078e00ffULL,
0x0000000430377824ULL, 0x000fe200078e00ffULL, 0xfffffffc2b2a7812ULL, 0x100fe200078ee264ULL,
0x000000103e317824ULL, 0x100fe200078e0255ULL, 0xfffffffc35307812ULL, 0x100fe200078ee264ULL,
0x0000001040337824ULL, 0x100fe200078e0255ULL, 0xfffffffc37327812ULL, 0x100fe400078ee264ULL,
0x0000000028317faeULL, 0x0003e6000b901c46ULL, 0x00000010322b7824ULL, 0x100fe200078e0255ULL,
0x0000000020337faeULL, 0x0005e2000b901c46ULL, 0xfffffffc3b287812ULL, 0x002fe200078ee264ULL,
0x0000001030297824ULL, 0x000fc400078e0255ULL, 0x0000001034317824ULL, 0x100fe400078e0255ULL,
0x000000102a217824ULL, 0x104fe400078e0255ULL, 0x0000001028337824ULL, 0x000fc600078e0255ULL,
0x0000000022217faeULL, 0x0003e8000b901c46ULL, 0x0000000024297faeULL, 0x0003e8000b901c46ULL,
0x00000000262b7faeULL, 0x0003e8000b901c46ULL, 0x000000002e317faeULL, 0x0003e8000b901c46ULL,
0x000000002c337faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001052217824ULL, 0x006fe200078e00ffULL, 0x0000000454207810ULL, 0x000fe20007ffe0ffULL,
0x0000001052227824ULL, 0x000fe200078e00ffULL, 0x000020006f6f7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff021207812ULL, 0x000fe400078ee220ULL, 0x0000000654217810ULL, 0x000fe20007ffe0ffULL,
0x0000001062627824ULL, 0x000fe400078e026fULL, 0x0000001020207824ULL, 0x000fe200078e00ffULL,
0xfffffff022217812ULL, 0x000fe200078ee221ULL, 0x000000103a617824ULL, 0x100fe400078e026fULL,
0x0000001060607824ULL, 0x100fe400078e026fULL, 0x00000010385f7824ULL, 0x000fc400078e026fULL,
0x0000001021217824ULL, 0x000fe400078e00ffULL, 0x00000010745d7824ULL, 0x100fe400078e026fULL,
0x0000001058587824ULL, 0x000fe200078e026fULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000000624c783bULL, 0x000fe20000000200ULL, 0x0000001072577824ULL, 0x100fe400078e026fULL,
0x0000001056567824ULL, 0x000fe200078e026fULL, 0x000000002034783bULL, 0x000e680000000200ULL,
0x000000006140783bULL, 0x000ea80000000200ULL, 0x00000000603c783bULL, 0x000ee80000000200ULL,
0x000000005f38783bULL, 0x000f280000000200ULL, 0x000000005d30783bULL, 0x000fe80000000200ULL,
0x000000002120783bULL, 0x000ee80000000200ULL, 0x00000000582c783bULL, 0x000ee80000000200ULL,
0x000000005728783bULL, 0x000ee80000000200ULL, 0x000000005624783bULL, 0x000ee20000000200ULL,
0x0000004c341c723cULL, 0x042f70000000181cULL, 0x0000004e3448723cULL, 0x040f700000001848ULL,
0x000000403444723cULL, 0x044f700000001844ULL, 0x000000423408723cULL, 0x040f700000001808ULL,
0x0000003c340c723cULL, 0x048f70000000180cULL, 0x0000003e3410723cULL, 0x040f700000001810ULL,
0x000000383414723cULL, 0x050f700000001814ULL, 0x0000003a3418723cULL, 0x000f700000001818ULL,
0x00000030201c723cULL, 0x060b70000000181cULL, 0x000000322048723cULL, 0x040b700000001848ULL,
0x0000002c2044723cULL, 0x040b700000001844ULL, 0x0000002e2008723cULL, 0x040b700000001808ULL,
0x00000028200c723cULL, 0x040b70000000180cULL, 0x0000002a2010723cULL, 0x040b700000001810ULL,
0x000000242014723cULL, 0x040b700000001814ULL, 0x000000262020723cULL, 0x000b620000001818ULL,
0x0000064000008947ULL, 0x000fce0003800000ULL, 0x00000002ff247819ULL, 0x020fe20000011606ULL,
0x000000015a357824ULL, 0x000fe200078e0a07ULL, 0x0000000c6e317812ULL, 0x000fe200078efcffULL,
0x0000001070337824ULL, 0x000fe200078e026fULL, 0x0000000824327810ULL, 0x040fe20007ffe0ffULL,
0x0000000103197824ULL, 0x000fe200078e0224ULL, 0x0000001024307810ULL, 0x000fc40007ffe0ffULL,
0x0000001824347810ULL, 0x000fe20007ffe0ffULL, 0x00000001031b7824ULL, 0x040fe200078e0232ULL,
0x000000196c197210ULL, 0x000fe20007f1e0ffULL, 0x0000000103257824ULL, 0x040fe200078e0230ULL,
0x0000002024367810ULL, 0x000fe40007ffe0ffULL, 0x0000001b6c1b7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff287224ULL, 0x000fe200000e06ffULL, 0x000000256c257210ULL, 0x000fe20007f5e0ffULL,
0x0000000103297824ULL, 0x000fe200078e0236ULL, 0x00005e0019267a11ULL, 0x000fe200078040ffULL,
0x000000ffff2a7224ULL, 0x000fe200008e06ffULL, 0x00005e001b187a11ULL, 0x000fe200078240ffULL,
0x000000ffff2c7224ULL, 0x000fe200010e06ffULL, 0x00005e00251a7a11ULL, 0x000fc400078440ffULL,
0x00005f0019277a11ULL, 0x000fe400000f4428ULL, 0x00005f001b197a11ULL, 0x000fe400008f442aULL,
0x00005f00251b7a11ULL, 0x000fe200010f442cULL, 0x0000000103257824ULL, 0x000fe200078e0234ULL,
0x00000028243a7810ULL, 0x040fe20007ffe0ffULL, 0x0000001031267825ULL, 0x000fe200078e0026ULL,
0x00000030243e7810ULL, 0x040fe40007ffe0ffULL, 0x0000003824427810ULL, 0x000fe20007ffe0ffULL,
0x00000001032b7824ULL, 0x040fe200078e023aULL, 0x000000256c257210ULL, 0x000fe20007f3e0ffULL,
0x00000001032d7824ULL, 0x040fe200078e023eULL, 0x000000352400720cULL, 0x000fe20003f06070ULL,
0x00000001032f7824ULL, 0x000fe200078e0242ULL, 0x000000296c297210ULL, 0x040fe20007f9e0ffULL,
0x000000ffff287224ULL, 0x000fe200008e06ffULL, 0x0000002b6c2b7210ULL, 0x000fe20007fbe0ffULL,
0x000000043e3b7824ULL, 0x000fe200078e00ffULL, 0x0000002d6c377210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff387224ULL, 0x000fe200020e06ffULL, 0x00005e0025247a11ULL, 0x040fe200078640ffULL,
0x000000ffff3c7224ULL, 0x000fe200028e06ffULL, 0x0000002f6c6c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff407224ULL, 0x000fe200010e06ffULL, 0x00005f0025257a11ULL, 0x000fe200018f4428ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026337faeULL, 0x0003e2000c101c46ULL,
0x00005e00292e7a11ULL, 0x000fe200078640ffULL, 0x000000ffff397224ULL, 0x000fe200008e06ffULL,
0x00005e002b2c7a11ULL, 0x000fe200078840ffULL, 0x00000004423d7824ULL, 0x000fe200078e00ffULL,
0x00005e00372a7a11ULL, 0x000fe200078440ffULL, 0x0000001031187825ULL, 0x000fe200078e0018ULL,
0x00005e006c287a11ULL, 0x000fc400078240ffULL, 0x00005f00292f7a11ULL, 0x000fe200018f4438ULL,
0x00000010311a7825ULL, 0x000fe200078e001aULL, 0x00005f002b2d7a11ULL, 0x000fe400020f443cULL,
0x00005f00372b7a11ULL, 0x000fe200010f4440ULL, 0x0000000430377824ULL, 0x000fe200078e00ffULL,
0x00005f006c297a11ULL, 0x000fe200008f4439ULL, 0x0000000434397824ULL, 0x000fe200078e00ffULL,
0x000000353200720cULL, 0x080fe20003f06070ULL, 0x0000000436277824ULL, 0x002fe200078e00ffULL,
0x000000353000720cULL, 0x080fe20003f26070ULL, 0x000000043a337824ULL, 0x000fe200078e00ffULL,
0x000000353400720cULL, 0x080fe20003f46070ULL, 0x0000001031247825ULL, 0x000fe200078e0024ULL,
0x000000353600720cULL, 0x000fc40003f66070ULL, 0x000000353a00720cULL, 0x080fe20003f86070ULL,
0x00000010312e7825ULL, 0x000fe200078e002eULL, 0x000000353e00720cULL, 0x080fe40003fa6070ULL,
0x000000354200720cULL, 0x000fe20003fc6070ULL, 0x0000000432357824ULL, 0x000fe200078e00ffULL,
0xfffffffc37307812ULL, 0x000fe200078ee264ULL, 0x00000010312c7825ULL, 0x000fe200078e002cULL,
0xfffffffc39327812ULL, 0x100fe400078ee264ULL, 0xfffffffc35267812ULL, 0x000fe200078ee264ULL,
0x00000010312a7825ULL, 0x000fe200078e002aULL, 0xfffffffc27347812ULL, 0x000fc400078ee264ULL,
0xfffffffc33367812ULL, 0x100fe200078ee264ULL, 0x0000001026277824ULL, 0x100fe200078e026fULL,
0xfffffffc3b387812ULL, 0x100fe200078ee264ULL, 0x0000001030337824ULL, 0x100fe200078e026fULL,
0xfffffffc3d3a7812ULL, 0x000fe200078ee264ULL, 0x0000001032357824ULL, 0x100fe200078e026fULL,
0x0000000018277faeULL, 0x0003e2000c101c46ULL, 0x0000001034377824ULL, 0x100fe400078e026fULL,
0x0000001036397824ULL, 0x100fe200078e026fULL, 0x000000001a337faeULL, 0x0003e2000c901c46ULL,
0x00000010383b7824ULL, 0x000fc400078e026fULL, 0x000000103a6f7824ULL, 0x000fe200078e026fULL,
0x0000000024357faeULL, 0x0003e2000d101c46ULL, 0x0000001031287825ULL, 0x000fc600078e0028ULL,
0x000000002e377faeULL, 0x0003e8000d901c46ULL, 0x000000002c397faeULL, 0x0003e8000e101c46ULL,
0x000000002a3b7faeULL, 0x0003e8000e901c46ULL, 0x00000000286f7faeULL, 0x0003e2000f101c46ULL,
0x0000059000007947ULL, 0x000fea0003800000ULL, 0x0000000306197211ULL, 0x020fe200078ff0ffULL,
0x0000001070397824ULL, 0x000fe200078e026fULL, 0x0000000806247811ULL, 0x000fc400078ff0ffULL,
0x0000006c19197210ULL, 0x080fe40007f1e0ffULL, 0x0000001006287811ULL, 0x040fe400078ff0ffULL,
0x00000018062a7811ULL, 0x040fe200078ff0ffULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x00005e00191a7a11ULL, 0x000fe200078040ffULL, 0x0000000103257824ULL, 0x040fe200078e0228ULL,
0x00000020062e7811ULL, 0x040fe200078ff0ffULL, 0x0000000103277824ULL, 0x000fe200078e022aULL,
0x00005f00191b7a11ULL, 0x000fe200000f4418ULL, 0x0000000103197824ULL, 0x040fe200078e0224ULL,
0x0000002806327811ULL, 0x040fe200078ff0ffULL, 0x0000000103297824ULL, 0x040fe200078e022eULL,
0x0000003006347811ULL, 0x000fe200078ff0ffULL, 0x000000042e317824ULL, 0x000fe200078e00ffULL,
0x0000003806367811ULL, 0x000fe200078ff0ffULL, 0x00000001032b7824ULL, 0x000fe200078e0232ULL,
0x0000006c19197210ULL, 0x080fe20007f7e0ffULL, 0x00000001032d7824ULL, 0x000fe200078e0234ULL,
0x0000006c25257210ULL, 0x080fe20007f3e0ffULL, 0x00000001032f7824ULL, 0x000fe200078e0236ULL,
0x0000006c272c7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff267224ULL, 0x000fe200018e06ffULL,
0x0000006c29297210ULL, 0x080fe20007f5e0ffULL, 0x0000000424277824ULL, 0x000fe200078e00ffULL,
0x0000006c2b2b7210ULL, 0x080fe20007f7e0ffULL, 0x0000000434357824ULL, 0x000fe200078e00ffULL,
0x0000006c2d307210ULL, 0x080fe20007fbe0ffULL, 0x00000004282d7824ULL, 0x000fe200078e00ffULL,
0x0000006c2f6c7210ULL, 0x000fe20007f9e0ffULL, 0x000000042a2f7824ULL, 0x000fe200078e00ffULL,
0x00005e0019187a11ULL, 0x000fe200078c40ffULL, 0x0000000432337824ULL, 0x000fe200078e00ffULL,
0xfffffffc27247812ULL, 0x000fe200078ee264ULL, 0x0000000436377824ULL, 0x000fe200078e00ffULL,
0x00005f0019197a11ULL, 0x000fe200030f4426ULL, 0x000000ffff417224ULL, 0x000fe200028e06ffULL,
0xfffffffc2f287812ULL, 0x100fe200078ee264ULL, 0x000000ffff437224ULL, 0x000fe200020e06ffULL,
0xfffffffc2d267812ULL, 0x100fe200078ee264ULL, 0x000000ffff2d7224ULL, 0x000fe200000e06ffULL,
0xfffffffc35327812ULL, 0x100fe200078ee264ULL, 0x0000001028357824ULL, 0x100fe200078e026fULL,
0xfffffffc332e7812ULL, 0x100fe200078ee264ULL, 0x0000001026337824ULL, 0x100fe200078e026fULL,
0xfffffffc312a7812ULL, 0x100fe200078ee264ULL, 0x000000ffff287224ULL, 0x000fe200008e06ffULL,
0xfffffffc37347812ULL, 0x000fe200078ee264ULL, 0x0000001024317824ULL, 0x100fe200078e026fULL,
0x00005e0025267a11ULL, 0x040fe200078240ffULL, 0x000000102a377824ULL, 0x100fe200078e026fULL,
0x00005e002c247a11ULL, 0x000fe200078040ffULL, 0x000000102e3b7824ULL, 0x100fe200078e026fULL,
0x00005f0025277a11ULL, 0x000fe200008f4428ULL, 0x00000010323d7824ULL, 0x000fe200078e026fULL,
0x00005f002c257a11ULL, 0x000fe200000f442dULL, 0x00000010346f7824ULL, 0x000fe200078e026fULL,
0x0000000c6e3f7812ULL, 0x000fe200078efcffULL, 0x000000ffff327224ULL, 0x000fe200010e06ffULL,
0x00005e00292e7a11ULL, 0x000fe200078040ffULL, 0x000000ffff347224ULL, 0x000fe200018e06ffULL,
0x00005e002b2c7a11ULL, 0x000fe200078240ffULL, 0x000000103f1a7825ULL, 0x000fe200078e001aULL,
0x00005e00302a7a11ULL, 0x000fc400078440ffULL, 0x00005e006c287a11ULL, 0x000fe200078640ffULL,
0x000000103f187825ULL, 0x000fe200078e0018ULL, 0x00005f00292f7a11ULL, 0x000fe200000f4432ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001a397faeULL, 0x0003e2000b901c46ULL,
0x00005f002b2d7a11ULL, 0x000fe200008f4434ULL, 0x000000103f267825ULL, 0x040fe200078e0026ULL,
0x00005f00302b7a11ULL, 0x000fe200010f4441ULL, 0x0000000018317faeULL, 0x0003e2000b901c46ULL,
0x00005f006c297a11ULL, 0x000fe200018f4443ULL, 0x000000103f247825ULL, 0x040fe400078e0024ULL,
0x0000000026337faeULL, 0x0003e4000b901c46ULL, 0x000000103f2e7825ULL, 0x000fc400078e002eULL,
0x0000000024357faeULL, 0x0003e4000b901c46ULL, 0x000000103f2c7825ULL, 0x040fe400078e002cULL,
0x000000002e377faeULL, 0x0003e4000b901c46ULL, 0x000000103f2a7825ULL, 0x040fe400078e002aULL,
0x000000002c3b7faeULL, 0x0003e4000b901c46ULL, 0x000000103f287825ULL, 0x000fc400078e0028ULL,
0x000000002a3d7faeULL, 0x0003e8000b901c46ULL, 0x00000000286f7faeULL, 0x0003e4000b901c46ULL,
0x00000004ff257424ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff6f7424ULL, 0x000fe400078e00ffULL, 0x0000030025047a24ULL, 0x000fca00078e0204ULL,
0x0000005b0400720cULL, 0x000fda0003f06070ULL, 0x0000000253248824ULL, 0x000fe200078e0204ULL,
0x0000000854187810ULL, 0x000fe20007ffe0ffULL, 0x0000001052197824ULL, 0x000fe200078e00ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x0000600024248625ULL, 0x000fe200078e0025ULL,
0xfffffff019187812ULL, 0x000fe200078ee218ULL, 0x000000006b4c783bULL, 0x000fe80000000200ULL,
0x00000006246f8981ULL, 0x0002a2000c1e1900ULL, 0x0000001018387824ULL, 0x000fc600078e00ffULL,
0x000000006d18783bULL, 0x000fe80000000200ULL, 0x000000003838783bULL, 0x000ee20000000200ULL,
0x0000001052257824ULL, 0x002fe200078e00ffULL, 0x0000000a54247810ULL, 0x000fe40007ffe0ffULL,
0x000000006a40783bULL, 0x000e640000000200ULL, 0xfffffff025247812ULL, 0x000fc400078ee224ULL,
0x00000000693c783bULL, 0x000f260000000200ULL, 0x0000001024247824ULL, 0x000fe200078e00ffULL,
0x000000006834783bULL, 0x000fe80000000200ULL, 0x000000006730783bULL, 0x000fe80000000200ULL,
0x000000002424783bULL, 0x000e680000000200ULL, 0x00000000662c783bULL, 0x000e680000000200ULL,
0x000000006528783bULL, 0x000e620000000200ULL, 0x00000018381c723cULL, 0x048f70000000181cULL,
0x0000001a3848723cULL, 0x040f700000001848ULL, 0x0000004c3844723cULL, 0x040b6e0000001844ULL,
0x000003005e4c7a10ULL, 0x020fe20007ffe0ffULL, 0x0000004e3808723cULL, 0x000f660000001808ULL,
0x000000014c187810ULL, 0x000fc80007ffe0ffULL, 0x000000591800720cULL, 0x000fe20003f06070ULL,
0x00000040380c723cULL, 0x042f70000000180cULL, 0x000000423810723cULL, 0x040f700000001810ULL,
0x0000003c3814723cULL, 0x050f700000001814ULL, 0x0000003e3820723cULL, 0x000f700000001820ULL,
0x00000034241c723cULL, 0x040f70000000181cULL, 0x000000362448723cULL, 0x040f700000001848ULL,
0x000000302444723cULL, 0x040f700000001844ULL, 0x000000322408723cULL, 0x060f700000001808ULL,
0x0000002c240c723cULL, 0x040f70000000180cULL, 0x0000002e2410723cULL, 0x040f700000001810ULL,
0x000000282414723cULL, 0x040f700000001814ULL, 0x0000002a2420723cULL, 0x000b6e0000001820ULL,
0x000000026f247224ULL, 0x024fe200078e02ffULL, 0x000006e000008947ULL, 0x000fca0003800000ULL,
0x000001004c197824ULL, 0x000fe200078e0205ULL, 0x00000002ff2b7819ULL, 0x000fe20000011606ULL,
0x0000001006257824ULL, 0x000fc600078e00ffULL, 0x000000195a187217ULL, 0x000fe20007800000ULL,
0x00000001031b7824ULL, 0x000fe200078e022bULL, 0x000000082b2d7810ULL, 0x040fe40007ffe0ffULL,
0x000000102b2f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000118287824ULL, 0x000fe200078e0a19ULL,
0x000000241b197210ULL, 0x080fe20007f1e0ffULL, 0x00000001031b7824ULL, 0x000fe200078e022dULL,
0x000000182b317810ULL, 0x000fe20007ffe0ffULL, 0x0000000103277824ULL, 0x000fe200078e022fULL,
0x0000003025257812ULL, 0x000fe200078ec0ffULL, 0x000000ffff187224ULL, 0x000fe200000e06ffULL,
0x000000241b1b7210ULL, 0x080fe20007f3e0ffULL, 0x0000000103297824ULL, 0x000fe200078e0231ULL,
0x0000002427277210ULL, 0x000fc40007f5e0ffULL, 0x00005e0019307a11ULL, 0x000fe200078040ffULL,
0x000000ffff2e7224ULL, 0x000fe200008e06ffULL, 0x00005e0027267a11ULL, 0x000fe200078240ffULL,
0x000000ffff1a7224ULL, 0x000fe200010e06ffULL, 0x0000002429297210ULL, 0x000fe40007f7e0ffULL,
0x00005f0019197a11ULL, 0x000fe400000f4418ULL, 0x00005f0027277a11ULL, 0x000fe200008f441aULL,
0x000000ffff187224ULL, 0x000fe200018e06ffULL, 0x000000282d00720cULL, 0x040fe20003f26070ULL,
0x000000042d2d7824ULL, 0x000fe200078e00ffULL, 0x00005e001b2a7a11ULL, 0x000fc400078040ffULL,
0x00005e00292c7a11ULL, 0x000fe400078440ffULL, 0x00005f001b1b7a11ULL, 0x000fe400000f442eULL,
0xfffffffc2d2e7812ULL, 0x000fe400078ee264ULL, 0x000000282b00720cULL, 0x000fe40003f06070ULL,
0x00005f0029297a11ULL, 0x000fe200010f4418ULL, 0x000000102e2d7824ULL, 0x000fe200078e0255ULL,
0x0000002530187210ULL, 0x000fc40007f7e0ffULL, 0x000000202b2e7810ULL, 0x000fe40007ffe0ffULL,
0x000000282f00720cULL, 0x040fe20003f46070ULL, 0x000000ffff197224ULL, 0x000fe200018e0619ULL,
0x000000252a1a7210ULL, 0x000fe20007f7e0ffULL, 0x000000042f2f7824ULL, 0x000fe200078e00ffULL,
0x000000282b307810ULL, 0x000fe20007ffe0ffULL, 0x0000000103337824ULL, 0x000fe200078e022eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018637faeULL, 0x0003e2000c101c46ULL,
0x000000ffff1b7224ULL, 0x000fe200018e061bULL, 0x000000302b327810ULL, 0x000fc40007ffe0ffULL,
0x000000382b347810ULL, 0x000fe20007ffe0ffULL, 0x00000001032b7824ULL, 0x000fe200078e0230ULL,
0xfffffffc2f2a7812ULL, 0x000fe200078ee264ULL, 0x000000001a2d7faeULL, 0x0005e2000c901c46ULL,
0x0000002526267210ULL, 0x000fe20007f9e0ffULL, 0x0000000434357824ULL, 0x000fe200078e00ffULL,
0x000000242b2b7210ULL, 0x080fe20007fbe0ffULL, 0x000000102a2f7824ULL, 0x000fe200078e0255ULL,
0x0000002433187210ULL, 0x002fe20007f1e0ffULL, 0x000000ffff277224ULL, 0x000fe200020e0627ULL,
0x000000283100720cULL, 0x0c0fe20003f86070ULL, 0x0000000431317824ULL, 0x000fe200078e00ffULL,
0x00005e00182a7a11ULL, 0x000fe200078c40ffULL, 0x0000000432337824ULL, 0x000fe200078e00ffULL,
0x00000000262f7faeULL, 0x0003e2000d101c46ULL, 0x000000ffff1b7224ULL, 0x004fe200000e06ffULL,
0x000000282e00720cULL, 0x080fe20003f66070ULL, 0x000000ffff1a7224ULL, 0x000fe200028e06ffULL,
0x000000283000720cULL, 0x000fe20003f46070ULL, 0x00000001032d7824ULL, 0x000fe200078e0234ULL,
0x00005f00181b7a11ULL, 0x000fc400030f441bULL, 0x000000252c187210ULL, 0x000fe40007fbe0ffULL,
0x000000283200720cULL, 0x080fe40003f26070ULL, 0x00005e002b267a11ULL, 0x002fe200078c40ffULL,
0x0000000103277824ULL, 0x000fe200078e0232ULL, 0x000000283400720cULL, 0x000fe20003f06070ULL,
0x000000ffff197224ULL, 0x000fe200028e0629ULL, 0x00005f002b2b7a11ULL, 0x000fe200030f441aULL,
0x00000004302f7824ULL, 0x000fe200078e00ffULL, 0x0000002427297210ULL, 0x000fc40007fde0ffULL,
0x000000242d277210ULL, 0x000fe20007fbe0ffULL, 0x000000042e2d7824ULL, 0x000fe200078e00ffULL,
0xfffffffc31287812ULL, 0x100fe200078ee264ULL, 0x000000ffff1a7224ULL, 0x000fe200030e06ffULL,
0x00005e0029247a11ULL, 0x000fe400078c40ffULL, 0xfffffffc2d2c7812ULL, 0x100fe200078ee264ULL,
0x00000010282d7824ULL, 0x000fe200078e0255ULL, 0xfffffffc33287812ULL, 0x000fe400078ee264ULL,
0x00005f0029297a11ULL, 0x000fc400030f441aULL, 0x000000252a1a7210ULL, 0x080fe20007fde0ffULL,
0x00000000182d7faeULL, 0x0003e2000e101c46ULL, 0x0000001028337824ULL, 0x000fe200078e0255ULL,
0x00005e0027287a11ULL, 0x000fe200078840ffULL, 0x000000ffff2a7224ULL, 0x000fe200028e06ffULL,
0xfffffffc2f2e7812ULL, 0x100fe200078ee264ULL, 0x000000ffff1b7224ULL, 0x000fe200030e061bULL,
0x0000002526267210ULL, 0x080fe20007fde0ffULL, 0x000000102c2f7824ULL, 0x100fe200078e0255ULL,
0x0000002524247210ULL, 0x000fe20007fbe0ffULL, 0x000000102e317824ULL, 0x000fe200078e0255ULL,
0xfffffffc35647812ULL, 0x000fc400078ee264ULL, 0x00005f0027197a11ULL, 0x002fe200020f442aULL,
0x000000ffff277224ULL, 0x000fe200030e062bULL, 0x0000002528187210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff257224ULL, 0x000fe200028e0629ULL, 0x000000001a2f7faeULL, 0x0003e2000d901c46ULL,
0x0000001064557824ULL, 0x000fe400078e0255ULL, 0x000000ffff197224ULL, 0x000fe200020e0619ULL,
0x0000000026317faeULL, 0x0003e8000d101c46ULL, 0x0000000024337faeULL, 0x0003e8000c901c46ULL,
0x0000000018557faeULL, 0x0003e2000c101c46ULL, 0x0000061000007947ULL, 0x000fea0003800000ULL,
0x0000000306197211ULL, 0x040fe400078ff0ffULL, 0x0000000806267811ULL, 0x000fc400078ff0ffULL,
0x0000002419197210ULL, 0x080fe40007f1e0ffULL, 0x0000001006287811ULL, 0x040fe200078ff0ffULL,
0x0000000103337824ULL, 0x000fe200078e0226ULL, 0x00000020062a7811ULL, 0x040fe200078ff0ffULL,
0x000000ffff1a7224ULL, 0x000fe200000e06ffULL, 0x00005e0019187a11ULL, 0x000fe200078040ffULL,
0x0000000103317824ULL, 0x040fe200078e0228ULL, 0x00000028062c7811ULL, 0x000fe200078ff0ffULL,
0x0000000103297824ULL, 0x000fe200078e022aULL, 0x00005f0019197a11ULL, 0x000fe200000f441aULL,
0x000000042a2f7824ULL, 0x000fe200078e00ffULL, 0x00000018061a7811ULL, 0x040fe200078ff0ffULL,
0x00000001032b7824ULL, 0x040fe200078e022cULL, 0x00000030062e7811ULL, 0x000fe200078ff0ffULL,
0x000000042c357824ULL, 0x000fe200078e00ffULL, 0x0000003806327811ULL, 0x000fe200078ff0ffULL,
0x00000001031b7824ULL, 0x000fe200078e021aULL, 0x0000002433337210ULL, 0x080fe20007fde0ffULL,
0x00000001032d7824ULL, 0x000fe200078e022eULL, 0x0000002431317210ULL, 0x080fe20007fbe0ffULL,
0x0000000103257824ULL, 0x000fe200078e0232ULL, 0x000000241b307210ULL, 0x080fe20007f1e0ffULL,
0x00000004261b7824ULL, 0x000fe200078e00ffULL, 0x0000002429297210ULL, 0x080fe20007f3e0ffULL,
0x000000041a277824ULL, 0x000fe200078e00ffULL, 0x000000242b2b7210ULL, 0x080fe20007f5e0ffULL,
0x000000042e377824ULL, 0x000fe200078e00ffULL, 0x000000242d2d7210ULL, 0x080fe20007f7e0ffULL,
0x0000000432397824ULL, 0x000fe200078e00ffULL, 0x0000002425247210ULL, 0x000fe20007f9e0ffULL,
0x0000000428257824ULL, 0x000fe200078e00ffULL, 0xfffffffc1b1a7812ULL, 0x100fe200078ee264ULL,
0x000000ffff1b7224ULL, 0x000fe200000e06ffULL, 0xfffffffc2f2a7812ULL, 0x100fe200078ee264ULL,
0x000000ffff2f7224ULL, 0x000fe200020e06ffULL, 0xfffffffc372e7812ULL, 0x100fe200078ee264ULL,
0x000000101a377824ULL, 0x100fe200078e0255ULL, 0xfffffffc25267812ULL, 0x100fe200078ee264ULL,
0x000000ffff1a7224ULL, 0x000fe200030e06ffULL, 0xfffffffc27287812ULL, 0x100fe200078ee264ULL,
0x000000102a3d7824ULL, 0x100fe200078e0255ULL, 0x00005e0033327a11ULL, 0x000fe200078c40ffULL,
0x00000010062a7824ULL, 0x000fe200078e00ffULL, 0xfffffffc352c7812ULL, 0x100fe200078ee264ULL,
0x00000010283b7824ULL, 0x100fe200078e0255ULL, 0xfffffffc39647812ULL, 0x000fe200078ee264ULL,
0x0000001026397824ULL, 0x100fe200078e0255ULL, 0x00005f0033337a11ULL, 0x000fe200030f441aULL,
0x000000ffff267224ULL, 0x000fe200028e06ffULL, 0x00005e0031257a11ULL, 0x000fe200078a40ffULL,
0x000000ffff1a7224ULL, 0x000fe200008e06ffULL, 0x00005e0030277a11ULL, 0x000fe200078040ffULL,
0x000000102c3f7824ULL, 0x100fe200078e0255ULL, 0x00005e0029287a11ULL, 0x000fe200078240ffULL,
0x000000102e417824ULL, 0x100fe200078e0255ULL, 0x000000302a357812ULL, 0x000fe200078ec0ffULL,
0x0000001064557824ULL, 0x000fe200078e0255ULL, 0x00005f0031317a11ULL, 0x000fe200028f4426ULL,
0x000000ffff267224ULL, 0x000fe200010e06ffULL, 0x00005f0030307a11ULL, 0x000fc400000f441bULL,
0x00005f0029297a11ULL, 0x000fe200008f441aULL, 0x000000ffff1a7224ULL, 0x000fe200018e06ffULL,
0x0000003518187210ULL, 0x000fe40007f1e0ffULL, 0x00005e002d2c7a11ULL, 0x000fe400078440ffULL,
0x00005e002b2a7a11ULL, 0x000fe200078240ffULL, 0x000000ffff197224ULL, 0x000fe200000e0619ULL,
0x00005e00242e7a11ULL, 0x000fe400078640ffULL, 0x00005f002d2d7a11ULL, 0x000fc400010f441aULL,
0x00005f002b2b7a11ULL, 0x000fe200008f4426ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018637faeULL, 0x0003e2000b901c46ULL, 0x00005f00242f7a11ULL, 0x000fe400018f442fULL,
0x00000035321a7210ULL, 0x080fe40007f1e0ffULL, 0x0000003525247210ULL, 0x080fe40007f3e0ffULL,
0x0000003527267210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200000e0633ULL,
0x0000003528287210ULL, 0x080fe20007f7e0ffULL, 0x000000ffff257224ULL, 0x000fe200008e0631ULL,
0x000000352a2a7210ULL, 0x080fe20007f9e0ffULL, 0x000000ffff277224ULL, 0x000fe200010e0630ULL,
0x000000352c2c7210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff297224ULL, 0x000fe200018e0629ULL,
0x000000352e2e7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff2b7224ULL, 0x000fe200020e062bULL,
0x000000001a377faeULL, 0x0003e2000b901c46ULL, 0x000000ffff2d7224ULL, 0x000fc400028e062dULL,
0x000000ffff2f7224ULL, 0x000fe200000e062fULL, 0x0000000024397faeULL, 0x0003e8000b901c46ULL,
0x00000000263b7faeULL, 0x0003e8000b901c46ULL, 0x00000000283d7faeULL, 0x0003e8000b901c46ULL,
0x000000002a3f7faeULL, 0x0003e8000b901c46ULL, 0x000000002c417faeULL, 0x0003e8000b901c46ULL,
0x000000002e557faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000001052197824ULL, 0x002fe200078e00ffULL, 0x0000000c54187810ULL, 0x000fc40007ffe0ffULL,
0x0000000e54547810ULL, 0x000fe40007ffe0ffULL, 0xfffffff019187812ULL, 0x040fe400078ee218ULL,
0xfffffff019547812ULL, 0x000fc600078ee254ULL, 0x0000001018287824ULL, 0x000fe400078e00ffULL,
0x0000001054187824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000006238783bULL, 0x000fe80000000200ULL, 0x000000002828783bULL, 0x000e680000000200ULL,
0x000000006134783bULL, 0x000ea80000000200ULL, 0x000000006030783bULL, 0x000ee80000000200ULL,
0x000000005f2c783bULL, 0x000f280000000200ULL, 0x000000005d24783bULL, 0x000fe80000000200ULL,
0x000000001818783bULL, 0x000ee80000000200ULL, 0x00000000583c783bULL, 0x000ee80000000200ULL,
0x000000005640783bULL, 0x000fe20000000200ULL, 0x00000038281c723cULL, 0x042f70000000181cULL,
0x0000003a2848723cULL, 0x040be40000001848ULL, 0x000000005738783bULL, 0x020e6c0000000200ULL,
0x000000362808723cULL, 0x044f700000001808ULL, 0x000000342844723cULL, 0x040f700000001844ULL,
0x00000030280c723cULL, 0x048ff0000000180cULL, 0x000000322810723cULL, 0x040ff00000001810ULL,
0x0000002c2814723cULL, 0x050ff00000001814ULL, 0x0000002e2820723cULL, 0x000ff00000001820ULL,
0x00000024181c723cULL, 0x040f70000000181cULL, 0x0000003e1808723cULL, 0x060f700000001808ULL,
0x000000261848723cULL, 0x040f700000001848ULL, 0x0000003c1844723cULL, 0x000f620000001844ULL,
0x3db504f31e247820ULL, 0x000fe20000410000ULL, 0x3db504f31f257820ULL, 0x000fe20000410000ULL,
0x3db504f31c1c7820ULL, 0x000fe20000410000ULL, 0x3db504f31d1d7820ULL, 0x000fc80000410000ULL,
0x00000038180c723cULL, 0x002f64000000180cULL, 0x3db504f30a2b7820ULL, 0x020fe20000410000ULL,
0x3db504f30b2c7820ULL, 0x000fe20000410000ULL, 0x3db504f308087820ULL, 0x000fe20000410000ULL,
0x3db504f309097820ULL, 0x000fc60000410000ULL, 0x0000003a1810723cULL, 0x000f620000001810ULL,
0x3db504f348487820ULL, 0x000fe20000410000ULL, 0x3db504f349497820ULL, 0x000fe20000410000ULL,
0x3db504f34a267820ULL, 0x000fe20000410000ULL, 0x3db504f34b277820ULL, 0x000fc80000410000ULL,
0x000000401814723cULL, 0x000f620000001814ULL, 0x3db504f344447820ULL, 0x000fe20000410000ULL,
0x3db504f345457820ULL, 0x000fe20000410000ULL, 0x3db504f346297820ULL, 0x000fe20000410000ULL,
0x3db504f3472a7820ULL, 0x000fc80000410000ULL, 0x000000421820723cULL, 0x000b620000001820ULL,
0x3db504f30c0a7820ULL, 0x000fe20000410000ULL, 0x3db504f30d0b7820ULL, 0x000fe20000410000ULL,
0x3db504f30e2d7820ULL, 0x000fe20000410000ULL, 0x3db504f30f287820ULL, 0x000fc80000410000ULL,
0x3db504f310187820ULL, 0x020fe20000410000ULL, 0x3db504f311197820ULL, 0x000fe20000410000ULL,
0x3db504f3122e7820ULL, 0x000fe20000410000ULL, 0x3db504f3132f7820ULL, 0x000fca0000410000ULL,
0x3db504f3141a7820ULL, 0x000fe20000410000ULL, 0x3db504f3151b7820ULL, 0x000fe20000410000ULL,
0x3db504f316307820ULL, 0x000fe20000410000ULL, 0x3db504f317317820ULL, 0x000fca0000410000ULL,
0x3db504f3201e7820ULL, 0x000fe20000410000ULL, 0x3db504f3211f7820ULL, 0x000fe20000410000ULL,
0x3db504f322227820ULL, 0x000fe20000410000ULL, 0x3db504f323327820ULL, 0x000fe20000410000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000ffff127224ULL, 0x000fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fe400078e0009ULL, 0x0000000050087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff167224ULL, 0x000fe400078e0018ULL, 0x000000ffff177224ULL, 0x000fc400078e0019ULL,
0x000000ffff207224ULL, 0x000fe400078e0024ULL, 0x000000ffff237224ULL, 0x000fe400078e0025ULL,
0x000000ffff0d7224ULL, 0x000fe400078e001cULL, 0x000000ffff0c7224ULL, 0x000fe400078e001dULL,
0x000000ffff0e7224ULL, 0x000fe400078e0048ULL, 0x000000ffff0f7224ULL, 0x000fc400078e0049ULL,
0x000000ffff107224ULL, 0x000fe400078e0044ULL, 0x000000ffff117224ULL, 0x000fe400078e0045ULL,
0x000000ffff147224ULL, 0x000fe400078e000aULL, 0x000000ffff157224ULL, 0x000fe400078e000bULL,
0x000000ffff217224ULL, 0x000fe400078e002eULL, 0x000000ffff247224ULL, 0x000fc400078e002fULL,
0x000000ffff187224ULL, 0x000fe400078e0030ULL, 0x000000ffff197224ULL, 0x000fe400078e0031ULL,
0x000000ffff257224ULL, 0x000fc400078e0032ULL, 0x00000000000a7805ULL, 0x006fca0000015200ULL,
0x00000400501d7984ULL, 0x000e640000000800ULL, 0x800000001dff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff2e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c0a2f7210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e0bULL, 0x003d09002f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1c7819ULL, 0x000fc8000001141dULL,
0x0000002f1c1c7211ULL, 0x000fca00078110ffULL, 0x000000ffff1d7224ULL, 0x000fca00000e061dULL,
0x000000021c1c7819ULL, 0x000fc8000000121dULL, 0x0000001c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000012e2e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400501d7984ULL, 0x000e640000000800ULL,
0x800000001dff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004061d7824ULL, 0x000fe200078e00ffULL, 0x000000515e00720cULL, 0x000fc80003f05270ULL,
0xfffffff01d097812ULL, 0x000fca00078ec0ffULL, 0x000000805c1c7824ULL, 0x000fca00078e0209ULL,
0x013400001c087984ULL, 0x0002a20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x00000002062e7824ULL, 0x000fe400078e00ffULL, 0x000000015a327824ULL, 0x000fc600078e0a07ULL,
0x000000062e2e7812ULL, 0x000fc800078ec0ffULL, 0x000000012e077812ULL, 0x040fe400078efcffULL,
0x000000082e2f7812ULL, 0x040fe400078efcffULL, 0x000000320700720cULL, 0x080fe40003f26070ULL,
0x000000102e077812ULL, 0x000fe400078efcffULL, 0x000000322f00720cULL, 0x080fe40003f06070ULL,
0x000000320700720cULL, 0x000fc40003fc6070ULL, 0x000000112e2f7812ULL, 0x040fe400078efcffULL,
0x000000182e077812ULL, 0x040fe400078efcffULL, 0x000000322e00720cULL, 0x0c0fe40003f46070ULL,
0x000000322f00720cULL, 0x080fe40003fa6070ULL, 0x000000320700720cULL, 0x000fe40003f66070ULL,
0x000000092e307812ULL, 0x000fc400078efcffULL, 0x000000192e2f7812ULL, 0x040fe400078efcffULL,
0x000000202e077812ULL, 0x000fe400078efcffULL, 0xff80000020207808ULL, 0x000fe40005000000ULL,
0xff8000000d0d7808ULL, 0x000fe40005000000ULL, 0xff80000023237808ULL, 0x000fe40004800000ULL,
0xff8000000c0c7808ULL, 0x000fc40004800000ULL, 0x000000323000720cULL, 0x080fe40003f86070ULL,
0x000000322f00720cULL, 0x080fe40003f46070ULL, 0x000000320700720cULL, 0x000fe40003f26070ULL,
0x000000212e2f7812ULL, 0x040fe400078efcffULL, 0x000000282e077812ULL, 0x000fe400078efcffULL,
0xff80000026267808ULL, 0x000fc40004000000ULL, 0xff8000000e0e7808ULL, 0x000fe40004000000ULL,
0xff80000027277808ULL, 0x000fe40006000000ULL, 0xff8000000f0f7808ULL, 0x000fe40006000000ULL,
0x000000322f00720cULL, 0x080fe40003f06070ULL, 0x000000320700720cULL, 0x000fe40003f86070ULL,
0x000000292e2f7812ULL, 0x000fc400078efcffULL, 0x000000302e077812ULL, 0x000fe400078efcffULL,
0xff80000029297808ULL, 0x000fe40007000000ULL, 0xff80000010107808ULL, 0x000fe40007000000ULL,
0xff8000002a2a7808ULL, 0x000fe40006800000ULL, 0xff80000011117808ULL, 0x000fe40006800000ULL,
0x000000322f00720cULL, 0x000fc40003fc6070ULL, 0x000000320700720cULL, 0x000fe40003fa6070ULL,
0x000000312e2f7812ULL, 0x040fe400078efcffULL, 0x000000382e077812ULL, 0x040fe400078efcffULL,
0x000000392e2e7812ULL, 0x000fe400078efcffULL, 0xff8000002b2b7808ULL, 0x000fe40005800000ULL,
0xff80000012127808ULL, 0x000fc40005800000ULL, 0xff8000002c2c7808ULL, 0x000fe40005000000ULL,
0xff80000013137808ULL, 0x000fe40005000000ULL, 0xff8000002d2d7808ULL, 0x000fe40004800000ULL,
0xff80000014147808ULL, 0x000fe40004800000ULL, 0x000000322f00720cULL, 0x080fe40003f66070ULL,
0x000000320700720cULL, 0x000fc40003f46070ULL, 0x000000322e00720cULL, 0x000fe40003f26070ULL,
0xff80000028287808ULL, 0x000fe40004000000ULL, 0xff80000015157808ULL, 0x000fe40004000000ULL,
0xff80000021217808ULL, 0x000fe40006000000ULL, 0xff80000016167808ULL, 0x000fe40006000000ULL,
0xff80000024247808ULL, 0x000fc40007000000ULL, 0xff80000017177808ULL, 0x000fe40007000000ULL,
0xff80000018187808ULL, 0x000fe40006800000ULL, 0xff8000001a1a7808ULL, 0x000fe40006800000ULL,
0xff80000019197808ULL, 0x000fe40005800000ULL, 0xff8000001b1b7808ULL, 0x000fe40005800000ULL,
0xff80000022227808ULL, 0x000fc40005000000ULL, 0xff8000001e1e7808ULL, 0x000fe40005000000ULL,
0xff80000025257808ULL, 0x000fe40004800000ULL, 0xff8000001f1f7808ULL, 0x000fc40004800000ULL,
0x0000000d0800720bULL, 0x004fe20003f1e000ULL, 0x0000001fff357424ULL, 0x000fe200078e00ffULL,
0x000000200900720bULL, 0x000fe20003f3e000ULL, 0xffffffffff367424ULL, 0x000fe200078e00ffULL,
0x000000080d077208ULL, 0x000fe40004000000ULL, 0x0000000920087208ULL, 0x000fc40004800000ULL,
0x0000000c0700720bULL, 0x000fe40003f1e000ULL, 0x000000230800720bULL, 0x000fe40003f3e000ULL,
0x000000070c077208ULL, 0x000fe40004000000ULL, 0x0000000823097208ULL, 0x000fe40004800000ULL,
0x0000000e0700720bULL, 0x000fe40003f1e000ULL, 0x000000260900720bULL, 0x000fc40003f3e000ULL,
0x000000070e087208ULL, 0x000fe40004000000ULL, 0x00000009262e7208ULL, 0x000fe40004800000ULL,
0x0000000f0800720bULL, 0x000fe40003f1e000ULL, 0x000000272e00720bULL, 0x000fe40003f3e000ULL,
0x000000080f077208ULL, 0x000fe40004000000ULL, 0x0000002e272e7208ULL, 0x000fc40004800000ULL,
0x000000100700720bULL, 0x000fe40003f1e000ULL, 0x000000292e00720bULL, 0x000fe40003f3e000ULL,
0x0000000710087208ULL, 0x000fe40004000000ULL, 0x0000002e29077208ULL, 0x000fe40004800000ULL,
0x000000110800720bULL, 0x000fe40003f1e000ULL, 0x0000002a0700720bULL, 0x000fc40003f3e000ULL,
0x0000000811097208ULL, 0x000fe40004000000ULL, 0x000000072a087208ULL, 0x000fe40004800000ULL,
0x000000120900720bULL, 0x000fe40003f1e000ULL, 0x0000002b0800720bULL, 0x000fe40003f3e000ULL,
0x00000009122e7208ULL, 0x000fe40004000000ULL, 0x000000082b077208ULL, 0x000fc40004800000ULL,
0x000000132e00720bULL, 0x000fe40003f1e000ULL, 0x0000002c0700720bULL, 0x000fe40003f3e000ULL,
0x0000002e13097208ULL, 0x000fe40004000000ULL, 0x000000072c087208ULL, 0x000fe40004800000ULL,
0x000000140900720bULL, 0x000fe40003f1e000ULL, 0x0000002d0800720bULL, 0x000fc40003f3e000ULL,
0x00000009142e7208ULL, 0x000fe40004000000ULL, 0x000000082d077208ULL, 0x000fe40004800000ULL,
0x000000152e00720bULL, 0x000fe40003f1e000ULL, 0x000000280700720bULL, 0x000fe40003f3e000ULL,
0x0000002e15097208ULL, 0x000fe40004000000ULL, 0x0000000728087208ULL, 0x000fc40004800000ULL,
0x000000160900720bULL, 0x000fe40003f1e000ULL, 0x000000210800720bULL, 0x000fe40003f3e000ULL,
0x00000009162e7208ULL, 0x000fe40004000000ULL, 0x0000000821077208ULL, 0x000fe40004800000ULL,
0x000000172e00720bULL, 0x000fe40003f1e000ULL, 0x000000240700720bULL, 0x000fc40003f3e000ULL,
0x0000002e17097208ULL, 0x000fe40004000000ULL, 0x0000000724077208ULL, 0x000fe40004800000ULL,
0x0000001a0900720bULL, 0x000fe40003f1e000ULL, 0x000000180700720bULL, 0x000fe40003f3e000ULL,
0x000000091a087208ULL, 0x000fe40004000000ULL, 0x00000007182e7208ULL, 0x000fc40004800000ULL,
0x0000001b0800720bULL, 0x000fe40003f1e000ULL, 0x000000192e00720bULL, 0x000fe40003f3e000ULL,
0x000000081b077208ULL, 0x000fe40004000000ULL, 0x0000002e19097208ULL, 0x000fe40004800000ULL,
0x0000001e0700720bULL, 0x000fe40003f1e000ULL, 0x000000220900720bULL, 0x000fc40003f3e000ULL,
0x000000071e087208ULL, 0x000fe40004000000ULL, 0x00000009222e7208ULL, 0x000fe40004800000ULL,
0x0000001f0800720bULL, 0x000fe40003f1e000ULL, 0x000000252e00720bULL, 0x000fe40003f3e000ULL,
0x000000081f317208ULL, 0x000fe40004000000ULL, 0x0000002e25337208ULL, 0x000fe20004800000ULL,
0x000014d27f007947ULL, 0x000fec000b800000ULL, 0x0c401f0031077f89ULL, 0x0004e400000e0000ULL,
0x000000073100720bULL, 0x008fc80003f1e000ULL, 0x0000003107347208ULL, 0x000fe20004000000ULL,
0x000014e27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0033077f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a097f89ULL, 0x000f2800000e0000ULL, 0x0c401f000b087f89ULL, 0x000e6200000e0000ULL,
0x000000073300720bULL, 0x008fc40003f1e000ULL, 0x000000090a00720bULL, 0x010fe40003f3e000ULL,
0x00000033072f7208ULL, 0x000fe40004000000ULL, 0x0000000a09307208ULL, 0x000fe40004800000ULL,
0x0c201f0034097f89ULL, 0x000ee200000e0000ULL, 0x000000080b00720bULL, 0x002fc60003f1e000ULL,
0x0c201f002f327f89ULL, 0x000e6200000e0000ULL, 0x0000000b08077208ULL, 0x000fc60004000000ULL,
0x0c201f0030317f89ULL, 0x004ea800000e0000ULL, 0x0c201f00072e7f89ULL, 0x0002a200000e0000ULL,
0x000000093400720bULL, 0x008fe40003f1e000ULL, 0x000000322f00720bULL, 0x002fe40003f3e000ULL,
0x0000003409087208ULL, 0x000fe40004000000ULL, 0x000000313000720bULL, 0x004fc40003f5e000ULL,
0x0000002f32097208ULL, 0x000fe40004800000ULL, 0x00000030310a7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b08327820ULL, 0x002fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000306ff7812ULL, 0x000fe4000780c0ffULL, 0x3fb8aa3b1a0b7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b091a7820ULL, 0x000fe20000410000ULL, 0x3fb8aa3b0d0d7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b0c0c7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b0f0f7823ULL, 0x000fe20000010832ULL, 0x3fb8aa3b20207823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b23237823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b26267823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b27277823ULL, 0x000fe2000001081aULL, 0x0000000d000d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b10107823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b14317823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b15347823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b16337823ULL, 0x100fe20000010832ULL, 0x0000000c000c7308ULL, 0x000e620000000800ULL,
0x3fb8aa3b17367823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b1b307823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b1e2f7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b1f327823ULL, 0x000fe20000010832ULL,
0x3c003c00ff1e7424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001081aULL,
0x3c003c00ff1f7424ULL, 0x000fe200078e00ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b28287823ULL, 0x100fe2000001081aULL, 0x3fb8aa3b21217823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b24247823ULL, 0x100fe2000001081aULL, 0x0000000f000f7308ULL, 0x000ea20000000800ULL,
0x0000000d0c0c723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b22227823ULL, 0x000fe2000001081aULL,
0x0000002e0700720bULL, 0x000fca0003f3e000ULL, 0x0000002000207308ULL, 0x000ff00000000800ULL,
0x0000002300237308ULL, 0x000e620000000800ULL, 0x0000000e0f0e723eULL, 0x004fce00000000ffULL,
0x0000002600267308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0x00000020230d723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b18207823ULL, 0x000fcc000001081aULL,
0x0000001000107308ULL, 0x000fe20000000800ULL, 0x00000026270f723eULL, 0x004fce00000000ffULL,
0x0000001100117308ULL, 0x000e620000000800ULL, 0x3fb8aa3b19267823ULL, 0x100fe2000001081aULL,
0x3fb8aa3b25277823ULL, 0x000fe2000001081aULL, 0x0000001e0c14723cULL, 0x000f6a00000018ffULL,
0x0000001200127308ULL, 0x000ff00000000800ULL, 0x0000001300137308ULL, 0x000ea20000000800ULL,
0x000000101110723eULL, 0x002fce00000000ffULL, 0x0000002900297308ULL, 0x000ff00000000800ULL,
0x0000002a002a7308ULL, 0x000e620000000800ULL, 0x000000121312723eULL, 0x004fce00000000ffULL,
0x0000002b002b7308ULL, 0x000ff00000000800ULL, 0x0000002c002c7308ULL, 0x000ea20000000800ULL,
0x000000292a11723eULL, 0x002fe400000000ffULL, 0x00000002ff297819ULL, 0x000fc80000011606ULL,
0x0000000129257810ULL, 0x040fe20007ffe0ffULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0x00000008293c7824ULL, 0x040fe400078e00ffULL, 0x00000008292a7824ULL, 0x040fe400078e00ffULL,
0x0000000829387824ULL, 0x040fe400078e00ffULL, 0x00000008293e7824ULL, 0x000fe200078e00ffULL,
0x0000002b2c13723eULL, 0x004fe200000000ffULL, 0x0000003400347308ULL, 0x000e620000000800ULL,
0xfffffff82a2a7812ULL, 0x000fc400078ee225ULL, 0x00000002292b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000c1d2c7812ULL, 0x000fe200078ec0ffULL, 0x0000001e1018723cULL, 0x020b620000001814ULL,
0xfffffff838387812ULL, 0x000fe200078ee22bULL, 0x0000003300337308ULL, 0x000fe20000000800ULL,
0xffffffff292b7810ULL, 0x000fc80007ffe0ffULL, 0x0000000829177824ULL, 0x060fe200078e00ffULL,
0x0000000329147810ULL, 0x040fe40007ffe0ffULL, 0x0000003600367308ULL, 0x000ea20000000800ULL,
0x0000000429157810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8173a7812ULL, 0x000fe400078ee214ULL,
0xfffffff83c3c7812ULL, 0x000fe400078ee215ULL, 0x000000313414723eULL, 0x002fe200000000ffULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0xfffffff83e3e7812ULL, 0x000fce00078ee22bULL,
0x0000002800287308ULL, 0x000e620000000800ULL, 0x000000333616723eULL, 0x004fe200000000ffULL,
0x0000000829367824ULL, 0x000fcc00078e00ffULL, 0x0000002100217308ULL, 0x000ff00000000800ULL,
0x0000002400247308ULL, 0x000ea20000000800ULL, 0x0000002d2815723eULL, 0x002fe200000000ffULL,
0x0000000829287824ULL, 0x000fc400078e00ffULL, 0x00000008292d7824ULL, 0x000fc600078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee229ULL, 0x0000002000237308ULL, 0x0003e20000000800ULL,
0x000000212417723eULL, 0x004fce00000000ffULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x0000000529207810ULL, 0x042fe40007ffe0ffULL, 0x0000000629217810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82d347812ULL, 0x000fe200078ee220ULL, 0x0000001e1418723cULL, 0x000f620000001818ULL,
0xfffffff836367812ULL, 0x000fe200078ee221ULL, 0x0000000b000b7308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000e620000000800ULL, 0x000000232621723eULL, 0x004fce00000000ffULL,
0x0000002f002f7308ULL, 0x000ff00000000800ULL, 0x0000003200327308ULL, 0x000ea20000000800ULL,
0x0000000b3020723eULL, 0x002fe400000000ffULL, 0x000090005c0b7811ULL, 0x000fca00078e58ffULL,
0x0000002200257308ULL, 0x0003e20000000800ULL, 0x00000010281d7824ULL, 0x100fe400078e020bULL,
0x000000103a267824ULL, 0x000fe400078e020bULL, 0x000000012c1d7824ULL, 0x000fe400078e021dULL,
0x0000001034287824ULL, 0x000fe200078e020bULL, 0x0000002700247308ULL, 0x0007220000000800ULL,
0x0000000829227810ULL, 0x002fe20007ffe0ffULL, 0x000000012c267824ULL, 0x040fe200078e0226ULL,
0x0000000c1d007388ULL, 0x0003e20000000800ULL, 0x000000012c287824ULL, 0x000fc400078e0228ULL,
0x0000000822297824ULL, 0x000fe400078e00ffULL, 0x000000103c277824ULL, 0x008fc600078e020bULL,
0xfffffff829407812ULL, 0x000fe200078ee222ULL, 0x0000001036297824ULL, 0x000fe200078e020bULL,
0x0000002f3222723eULL, 0x004fe200000000ffULL, 0x000000012c277824ULL, 0x000fe200078e0227ULL,
0x000000252423723eULL, 0x010fe200000000ffULL, 0x000000102a247824ULL, 0x100fe400078e020bULL,
0x0000001038257824ULL, 0x000fe400078e020bULL, 0x000000012c247824ULL, 0x040fe400078e0224ULL,
0x0000001e2018723cULL, 0x020b620000001818ULL, 0x000000012c257824ULL, 0x000fc400078e0225ULL,
0x000000103e2a7824ULL, 0x100fe200078e020bULL, 0x0000000e24007388ULL, 0x0003e20000000800ULL,
0x00000010400b7824ULL, 0x000fe400078e020bULL, 0x000000012c297824ULL, 0x040fe200078e0229ULL,
0x0000001025007388ULL, 0x0003e20000000800ULL, 0x000000012c2a7824ULL, 0x040fe400078e022aULL,
0x000000012c1e7824ULL, 0x020fe200078e020bULL, 0x0000001226007388ULL, 0x0003e20000000800ULL,
0x000000072e0b7208ULL, 0x000fc60004800000ULL, 0x0000001427007388ULL, 0x0003e80000000800ULL,
0x0000001628007388ULL, 0x0003e80000000800ULL, 0x0000002029007388ULL, 0x0003e20000000800ULL,
0x000000ffff197224ULL, 0x000fc600078e001aULL, 0x000000222a007388ULL, 0x0003e80000000800ULL,
0x0000000d1e007388ULL, 0x0003e80000000800ULL, 0x0004000f24007388ULL, 0x0003e80000000800ULL,
0x0004001125007388ULL, 0x0003e80000000800ULL, 0x0004001326007388ULL, 0x0003e80000000800ULL,
0x0004001527007388ULL, 0x0003e80000000800ULL, 0x0004001728007388ULL, 0x0003e80000000800ULL,
0x0004002129007388ULL, 0x0003e80000000800ULL, 0x000400232a007388ULL, 0x0003e80000000800ULL,
0x013000081c008388ULL, 0x0003e80000000c00ULL, 0x013200181c008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136080000ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136100000ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0136180000ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000594c00720cULL, 0x000fe20003f06070ULL,
0x0136200000ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff5e7224ULL, 0x000fd600078e004cULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffa55000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0c7807ULL, 0x008fe40004000000ULL,
0x00012ee000167802ULL, 0x000fc40000000f00ULL, 0x00000c7000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0015ULL, 0xfffefb9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe40005000000ULL, 0x00012f3000167802ULL, 0x000fc40000000f00ULL,
0x00000c2000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0xfffefbf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x008fe200078e0015ULL,
0x00012f8000177802ULL, 0x000fc40000000f00ULL, 0x00000b8000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0016ULL, 0xfffefcb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff167224ULL, 0x000fe200078e0015ULL, 0x00012fd000177802ULL, 0x000fc40000000f00ULL,
0x00000b3000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0016ULL,
0xfffefdd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000fULL,
0x0001303000177802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fc400078e000eULL,
0x00000ad000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0016ULL,
0xfffeff8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0c7224ULL, 0x000fe200078e0008ULL,
0x0001309000177802ULL, 0x000fe20000000f00ULL, 0x000000ffff167224ULL, 0x000fc400078e000fULL,
0x00000a7000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff087224ULL, 0x004fe200078e0016ULL,
0xfffeff5000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x008fe40004000000ULL,
0x000130e000167802ULL, 0x000fc40000000f00ULL, 0x00000a7000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e0015ULL, 0xffff18d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x000fe40005000000ULL, 0x0001313000167802ULL, 0x000fc40000000f00ULL,
0x00000a2000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0xffff192000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e0015ULL,
0x0001318000177802ULL, 0x000fc40000000f00ULL, 0x0000098000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0016ULL, 0xffff19f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff167224ULL, 0x000fe200078e0015ULL, 0x000131d000177802ULL, 0x000fc40000000f00ULL,
0x0000093000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0016ULL,
0xffff1b0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x0001323000177802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fc400078e000fULL,
0x000008d000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0016ULL,
0xffff1cb000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x0001328000177802ULL, 0x000fc40000000f00ULL, 0x0000088000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0016ULL, 0xffff1c9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x004fe40004000000ULL, 0x000132d000167802ULL, 0x000fc40000000f00ULL,
0x0000088000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0xffff334000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40004800000ULL,
0x0001332000167802ULL, 0x000fc40000000f00ULL, 0x0000083000007944ULL, 0x018fea0003c00000ULL,
0xffff33a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e0019ULL,
0x0001336000177802ULL, 0x000fc40000000f00ULL, 0x000007a000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0016ULL, 0xffff348000007947ULL, 0x000fea000383ffffULL,
0x000000ffff167224ULL, 0x000fe200078e0019ULL, 0x000133b000177802ULL, 0x000fc40000000f00ULL,
0x0000075000007944ULL, 0x01afea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0016ULL,
0xffff359000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x0001341000177802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fc400078e000fULL,
0x000006f000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0016ULL,
0xffff374000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x0001346000177802ULL, 0x000fc40000000f00ULL, 0x000006a000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0016ULL, 0xffff372000007947ULL, 0x000fea000383ffffULL,
0x00000001ff0c7807ULL, 0x008fe40004000000ULL, 0x000134b000167802ULL, 0x000fc40000000f00ULL,
0x000006a000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0xffff4dc000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0c7807ULL, 0x000fe40004800000ULL,
0x0001350000167802ULL, 0x000fc40000000f00ULL, 0x0000065000007944ULL, 0x012fea0003c00000ULL,
0xffff4e2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e0019ULL,
0x0001354000177802ULL, 0x000fc40000000f00ULL, 0x000005c000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0016ULL, 0xffff4ef000007947ULL, 0x000fea000383ffffULL,
0x000000ffff167224ULL, 0x000fe200078e0019ULL, 0x0001359000177802ULL, 0x000fc40000000f00ULL,
0x0000057000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0016ULL,
0xffff500000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x000135f000177802ULL, 0x000fe20000000f00ULL, 0x000000ffff0c7224ULL, 0x000fc400078e000fULL,
0x0000051000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0016ULL,
0xffff51a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff167224ULL, 0x000fe200078e000eULL,
0x0001364000177802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0016ULL, 0xffff518000007947ULL, 0x000fea000383ffffULL,
0x00000002ff327424ULL, 0x000fe200078e00ffULL, 0x00013690002e7802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0030ULL,
0xffffeaf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff317224ULL, 0x006fe200078e0033ULL,
0x000136f0002e7802ULL, 0x000fe20000000f00ULL, 0x00000002ff327424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x000fea0003c00000ULL, 0x000000303300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff317224ULL, 0x002fe200078e000aULL, 0x00013750002e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x000fe200078e00ffULL, 0x0000003330097208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x000000300a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff317224ULL, 0x002fe200078e000bULL, 0x000137b0002e7802ULL, 0x000fe20000000f00ULL,
0x00000002ff327424ULL, 0x000fe200078e00ffULL, 0x0000000a30337208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000300b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff317224ULL, 0x002fe200078e0034ULL, 0x00013810002e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x000fe200078e00ffULL, 0x0000000b30077208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x000000303400720bULL, 0x004fe20003f1e000ULL,
0x000000ffff317224ULL, 0x002fe200078e0009ULL, 0x00013870002e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x000fe200078e00ffULL, 0x0000003430087208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x000000300900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff317224ULL, 0x002fe200078e0033ULL, 0x000138d0002e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x000fe200078e00ffULL, 0x0000000930097208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x000000303300720bULL, 0x004fe20003f1e000ULL,
0x000000ffff317224ULL, 0x002fe200078e0007ULL, 0x00013930002e7802ULL, 0x000fe20000000f00ULL,
0x00000001ff327424ULL, 0x000fe200078e00ffULL, 0x00000033300a7208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff2e7224ULL, 0x004fe200078e0030ULL,
0xffffe9b000007947ULL, 0x000fea000383ffffULL, 0x0180000004037810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000003057812ULL, 0x000fc800078ec0ffULL,
0x018000000500780cULL, 0x000fda0003f05070ULL, 0x0000000400038308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0500720cULL, 0x040fe40003f25070ULL,
0x008000000500780cULL, 0x000fe40003f02070ULL, 0x00000001ff0a7807ULL, 0x000fe40000800000ULL,
0x00000001ff037807ULL, 0x004fc80004000000ULL, 0x000000030aff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff04ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000004057812ULL, 0x000fe400078ec0ffULL, 0x00000001ff037807ULL, 0x000fc80000000000ULL,
0x000000030aff7212ULL, 0x000fda000780c0ffULL, 0x0080000005030812ULL, 0x000fe200078efcffULL,
0x000000ffff038224ULL, 0x000fe200078e0005ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000400037308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000000ff097424ULL, 0x000fc800078e00ffULL, 0xfffec54008007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff2f7424ULL, 0x000fe200078e00ffULL, 0x0000003600007348ULL, 0x000fe80003800000ULL,
0x0c00003231307389ULL, 0x0002a200000e0035ULL, 0xfffec5002e007950ULL, 0x000fea0003c3ffffULL,
0x0000006000007348ULL, 0x000fe80003800000ULL, 0x0000000c16167389ULL, 0x0002a200000e0063ULL,
0x00000000ff0d7424ULL, 0x000fc400078e00ffULL, 0x000000ffff0c7224ULL, 0x002fc800078e0017ULL,
0xfffec4b00c007950ULL, 0x000fea0003c3ffffULL, 0x000000010c00780cULL, 0x000fe20003f45070ULL,
0x0000006100007348ULL, 0x000fe80003800000ULL, 0x00000000ff0d7424ULL, 0x000fd000078e00ffULL,
0x00000000000c7806ULL, 0x000fc800050e0100ULL, 0x000000610c157212ULL, 0x000fe200078ec0ffULL,
0x000000ffff0c7224ULL, 0x000fc800078e0016ULL, 0xfffec4400c007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000002ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000542ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006a0ULL,
0x0000000000000258ULL, 0x0000001800000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000008f8ULL,
0x00000000000002f0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000be8ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000ca8ULL,
0x0000000000000584ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001230ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001240ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012d0ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000012d4ULL,
0x00000000000001b0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001500ULL,
0x0000000000013c80ULL, 0x7f00001800000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x0000000100000089ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000015180ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x00000000000151c0ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x0000000000015540ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000012d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000013eb0ULL,
0x0000000000013eb0ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000015180ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000015540ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_8_m_8_sm_86_cubin_len = 87584;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
