/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000147a0ULL, 0x0000000000014420ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x32666c61685f5f37ULL,
0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454536316a4cULL, 0x45454531624c4974ULL,
0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545326a4c4532ULL, 0x4545316a4c45346aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x32336a4c4545346aULL, 0x61324545386a4c45ULL,
0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x6a4c45386a4c4545ULL,
0x4c49746132454538ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4536316aULL, 0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x0000000000676e69ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x65746e695f5f2400ULL, 0x245f305f6c616e72ULL, 0x735f616475635f5fULL, 0x5f7063725f30326dULL,
0x665f7a74665f6e72ULL, 0x70776f6c735f3233ULL, 0x6c65722e00687461ULL, 0x656b2e747865742eULL,
0x61686d5f6c656e72ULL, 0x742e616c65722e00ULL, 0x6e72656b2e747865ULL, 0x240061686d5f6c65ULL,
0x6d5f6c656e72656bULL, 0x426d656d73246168ULL, 0x2e00667542657479ULL, 0x72665f6775626564ULL,
0x6c65722e00656d61ULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x67756265642e616cULL,
0x2e00656d6172665fULL, 0x74736e6f632e766eULL, 0x72656b2e30746e61ULL, 0x0061686d5f6c656eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b0001000000b1ULL,
0x000000000000002cULL, 0x0000000000000010ULL, 0x000b0001000000efULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x000b00010000016fULL, 0x0000000000000018ULL, 0x0000000000000004ULL, 0x000b0001000001b1ULL,
0x0000000000000010ULL, 0x0000000000000004ULL, 0x000b0001000001f7ULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000023eULL, 0x0000000000000008ULL, 0x0000000000000004ULL,
0x000b000100000284ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000002d2ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000b000100000320ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b000100000366ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0001000003abULL, 0x0000000000000014ULL, 0x0000000000000004ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a002200000406ULL, 0x0000000000013160ULL,
0x0000000000000220ULL, 0x000400030000047cULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a101200000040ULL, 0x0000000000000000ULL, 0x0000000000013380ULL, 0x000d0003000004acULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000024ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001316000000000ULL,
0x0000580400000000ULL, 0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL,
0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000001cffffffffULL,
0x0000006000000000ULL, 0x0001316000000000ULL, 0x0000022000000000ULL, 0x0000000000000000ULL,
0x0000001400082f04ULL, 0x0008230400000080ULL, 0x0000000000000012ULL, 0x0000001200081204ULL,
0x0008110400000000ULL, 0x0000000000000012ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL,
0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL, 0x000c17040021f000ULL,
0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040081f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00b42904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000000e000b42804ULL, 0x0000061000000120ULL, 0x00002c3000001a20ULL,
0x00002d8000002cb0ULL, 0x0000325000002ec0ULL, 0x000037d000003260ULL, 0x00004960000048e0ULL,
0x00004b8000004a40ULL, 0x00004dc000004db0ULL, 0x000062d0000051b0ULL, 0x0000644000006340ULL,
0x000067b000006580ULL, 0x00006ba0000067c0ULL, 0x00007cf000007c70ULL, 0x00007f1000007dd0ULL,
0x000080e0000080d0ULL, 0x0000868000008670ULL, 0x0000a7600000a730ULL, 0x0000ad700000ad40ULL,
0x00012670000125c0ULL, 0x0001293000012890ULL, 0x00012c5000012bf0ULL, 0x00012e5000012d90ULL,
0x000001b001f03904ULL, 0x0001b600000000ffULL, 0x0000029000040100ULL, 0x0001b60800000004ULL,
0x000003a0003f0100ULL, 0x0001b68800000004ULL, 0x00000670003f0100ULL, 0x0001b6000000000aULL,
0x00000800003f0107ULL, 0x0001b68800000004ULL, 0x000029c0003f0101ULL, 0x0001b60800000063ULL,
0x000029e0003f0101ULL, 0x0001b60800000063ULL, 0x00002b50003f0109ULL, 0x0001b60800000063ULL,
0x00003690003f0109ULL, 0x0001b68800000049ULL, 0x000046d0003f0101ULL, 0x0001b62800000063ULL,
0x000046f0003f0101ULL, 0x0001b62800000063ULL, 0x00004860003f0109ULL, 0x0001b62800000063ULL,
0x00005070003f0109ULL, 0x0001b69000000049ULL, 0x00006070003f0101ULL, 0x0001b64800000063ULL,
0x000060e0003f0101ULL, 0x0001b64800000067ULL, 0x00006250003f0109ULL, 0x0001b64800000067ULL,
0x00006a80003f0109ULL, 0x0001b69800000049ULL, 0x00007a60003f0101ULL, 0x0001b66800000067ULL,
0x00007a80003f0101ULL, 0x0001b66800000067ULL, 0x00007bf0003f0109ULL, 0x0001b66800000067ULL,
0x00008310003f0109ULL, 0x0001b6a000000049ULL, 0x0000b6a0003f0101ULL, 0x0001b6000000000aULL,
0x0000d360003f0101ULL, 0x0001b6000000000aULL, 0x0000d4d0003f0109ULL, 0x0001b6000000000aULL,
0x00011a70003f0109ULL, 0x0001b68800000007ULL, 0x00011ce0003f0101ULL, 0x0001b68800000007ULL,
0x00011e50003f0109ULL, 0x0001b68800000007ULL, 0x00013100003f0109ULL, 0x0001b60800000004ULL,
0x00013110003f0101ULL, 0x0001b61000000004ULL, 0x00013120003f0101ULL, 0x0001b61800000004ULL,
0x00013130003f0101ULL, 0x0001b62000000004ULL, 0x00033803003f0101ULL, 0x0000b39000141c04ULL,
0x0000d5000000b600ULL, 0x000131500000d590ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x00080a0400501903ULL, 0x0050021000000015ULL, 0x00000000000000bcULL,
0x0000001400000002ULL, 0x0000000000013160ULL, 0x0000000000000044ULL, 0x0000001400000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001400000002ULL, 0x0000000000000000ULL,
0x000000000001b700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e640000000800ULL, 0x0000000000107919ULL, 0x000ea20000002300ULL,
0x00000300ff0c7b82ULL, 0x000ee20000000800ULL, 0x0000010000047ab9ULL, 0x000fe20000000800ULL,
0x000001b000007945ULL, 0x000fe20003800000ULL, 0x0000000000057919ULL, 0x000ea20000002200ULL,
0x00000000005b7919ULL, 0x000f280000002100ULL, 0x00008800ff027b82ULL, 0x000e620000000a00ULL,
0x0000000000067919ULL, 0x000e620000002700ULL, 0x0000000000127919ULL, 0x000e620000002600ULL,
0x0000000000117919ULL, 0x000e620000008800ULL, 0x0000000000007919ULL, 0x000e620000000000ULL,
0x0000000410047c24ULL, 0x004fe2000f8e0205ULL, 0x0000000000047ab9ULL, 0x000fe20000000800ULL,
0x00001fff10107589ULL, 0x000ea400000e0000ULL, 0x0000000404057c24ULL, 0x110fe2000f8e025bULL,
0x00000005ff5b7819ULL, 0x000fc8000001165bULL, 0x000000ff0500720cULL, 0x040fe40003f05270ULL,
0x00001fff5b5b7589ULL, 0x000e6200000e0000ULL, 0x0000000f0500780cULL, 0x040fe40003f24070ULL,
0x000000030500780cULL, 0x000fd00003f44070ULL, 0x0000000000240947ULL, 0x008fea0003800000ULL,
0x00000000000579c3ULL, 0x000ee20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x008fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000ef40000000000ULL, 0x01b60006043f75b2ULL, 0x0006e40008000100ULL,
0x0000000000007918ULL, 0x00cfe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ee20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x008fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000405047c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000040612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000ee40000000000ULL,
0x01b60804063f75b2ULL, 0x0006f00008000100ULL, 0xfffffffd00e81947ULL, 0x00cfea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x008fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000405047c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000040612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ee40000000000ULL, 0x01b68804063f75b2ULL, 0x0006f00008000100ULL,
0xfffffffd00e81947ULL, 0x00cfea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000840000057ab9ULL, 0x000fe20000000800ULL, 0x0000000410047824ULL, 0x006fe200078e025bULL,
0x0000000305047899ULL, 0x000fe2000800063fULL, 0x00000004ff0b7819ULL, 0x000fe20000011600ULL,
0x0000000812077824ULL, 0x000fe200078e00ffULL, 0x00000400000a7802ULL, 0x000fe20000000f00ULL,
0x0000000204087824ULL, 0x000fe200078e00ffULL, 0x0000007f0500780cULL, 0x000fe20003f04070ULL,
0x0000000406077c24ULL, 0x000fe2000f8e0207ULL, 0x00000654110a7816ULL, 0x000fe2000000000aULL,
0x00000001080d7824ULL, 0x000fe200078e020bULL, 0x0000000808097848ULL, 0x000fe20007fe0000ULL,
0x0000001000047824ULL, 0x000fe200078e00ffULL, 0x000000000a0472caULL, 0x000fe200000e0000ULL,
0x0000000107077824ULL, 0x000fe200078e020dULL, 0x0000820000067ab9ULL, 0x000fe20000000a00ULL,
0x0000000109097824ULL, 0x000fe200078e0a08ULL, 0x000000f004117812ULL, 0x000fe200078ec0ffULL,
0x0000010007027825ULL, 0x000fe200078e0002ULL, 0x00008e00ff0e7b82ULL, 0x000e620000000a00ULL,
0x0000000a05058211ULL, 0x000fc400078e10ffULL, 0x000000010d077824ULL, 0x000fe200078e0200ULL,
0x000000090b00720cULL, 0x000fe20003f26070ULL, 0x000000100d167824ULL, 0x000fe200078e00ffULL,
0x0000001102087210ULL, 0x000fe20007f5e0ffULL, 0xff317217ff148424ULL, 0x000fe200078e00ffULL,
0x0001b60004047890ULL, 0x000fe4000fffe03fULL, 0xfffffff016077812ULL, 0x000fe200078ee207ULL,
0x000000ffff097224ULL, 0x000fe200010e0603ULL, 0x01b4001405008388ULL, 0x0005e60000000800ULL,
0x0000001007077824ULL, 0x000fe200078e020aULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008077faeULL, 0x0005e2000c901c46ULL,
0x0000000406027825ULL, 0x002fe200078e000eULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x00000006025a7981ULL, 0x000ee2000c1e1900ULL,
0x000000ff1000720cULL, 0x000fe20003f05270ULL, 0x0000000000597919ULL, 0x000e620000002500ULL,
0x0000003f5a587836ULL, 0x008fe40000000000ULL, 0x000000ff5a0e7836ULL, 0x000fc60000000000ULL,
0x00000006ff587819ULL, 0x000fe40000011658ULL, 0x00000008ff0e7819ULL, 0x000fc8000001160eULL,
0x000000ac00b88947ULL, 0x002fea0003800000ULL, 0x00000002ff467819ULL, 0x000fe2000001165bULL,
0x000000085b457824ULL, 0x000fe400078e00ffULL, 0x00000004ff077424ULL, 0x004fe200078e00ffULL,
0x03ffffff46027812ULL, 0x000fc800078ec0ffULL, 0x00000002590b7211ULL, 0x000fc800078e10ffULL,
0x000000580b00720cULL, 0x000fda0003f06070ULL, 0x00009000ff058b82ULL, 0x000e620000000800ULL,
0x0000000206048824ULL, 0x000fce00078e00ffULL, 0x00008c00ff028b82ULL, 0x000ea20000000a00ULL,
0x0000000504048224ULL, 0x002fc800078e0205ULL, 0x000000010b058824ULL, 0x000fe400078e0204ULL,
0x000000010a047824ULL, 0x000fe400078e0245ULL, 0x0000000405028825ULL, 0x004fe400078e0002ULL,
0x01b6880704ff79a7ULL, 0x0003e4000850003fULL, 0xffffffffff057424ULL, 0x000fcc00078e00ffULL,
0x0000000602058981ULL, 0x000ea2000c1e1900ULL, 0x00000001ff477819ULL, 0x000fe2000001165bULL,
0x0000000159077836ULL, 0x002fe40000000000ULL, 0x00000040120f7824ULL, 0x000fe200078e00ffULL,
0x0000000547447819ULL, 0x000fe400000006ffULL, 0x0000000e0700720cULL, 0x000fe40003f06070ULL,
0x000000015b077812ULL, 0x000fe200078ec0ffULL, 0x00000100590d7824ULL, 0x000fca00078e0244ULL,
0x000000200f1e7812ULL, 0x000fe200078ef80dULL, 0x0000000505057c24ULL, 0x004fc8000f8e02ffULL,
0x00000040051d7824ULL, 0x000fe200078e00ffULL, 0x0000000400d48947ULL, 0x000fec0003800000ULL,
0x00000003ff087819ULL, 0x000fe20000011600ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000d5a027248ULL, 0x000fe20007fe0000ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0a0dULL,
0x000000011e037824ULL, 0x040fe400078e0208ULL, 0x00000004081c7836ULL, 0x000fe20000000000ULL,
0x00000020020d7446ULL, 0x000fe2000380000dULL, 0x00000008081f7836ULL, 0x000fe20000000000ULL,
0x000000031d097210ULL, 0x000fe20007f1e0ffULL, 0x0000000c08207836ULL, 0x000fe20000000000ULL,
0x0000001c1e027210ULL, 0x000fe20007ffe0ffULL, 0x000000011e047824ULL, 0x000fc400078e021fULL,
0x000000ffff107224ULL, 0x000fe200000e06ffULL, 0x0000000409187c11ULL, 0x040fe2000f8040ffULL,
0x0000001008217836ULL, 0x000fe20000000000ULL, 0x000000021d057210ULL, 0x000fe20007f3e0ffULL,
0x0000001408227836ULL, 0x000fe20000000000ULL, 0x0000000509197c11ULL, 0x000fe200080f4410ULL,
0x0000400047107824ULL, 0x000fe200078e020aULL, 0x000000041d037210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x0000000008097210ULL, 0x000fe20007ffe0ffULL,
0x0000001808237836ULL, 0x000fe20000000000ULL, 0x0000000d0800720cULL, 0x000fe20003f06070ULL,
0x0000001c08247836ULL, 0x000fe20000000000ULL, 0x0000000405047c11ULL, 0x000fe2000f8240ffULL,
0x000000011e087824ULL, 0x040fe200078e0220ULL, 0x0000000709097812ULL, 0x000fe200078ec0ffULL,
0x0000200007107824ULL, 0x000fe200078e0210ULL, 0x0000000505057c11ULL, 0x000fe200088f4414ULL,
0x000000ffff127224ULL, 0x000fe200010e06ffULL, 0x000000081d147210ULL, 0x000fe20007f3e0ffULL,
0x00013000101a7836ULL, 0x000fe20000000000ULL, 0x000000211e107210ULL, 0x000fe20007ffe0ffULL,
0x000000011e117824ULL, 0x040fe200078e0222ULL, 0x0000000403027c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e06ffULL, 0x000000101d177210ULL, 0x000fe20007f9e0ffULL,
0x0000000807257824ULL, 0x000fe200078e00ffULL, 0x0000000503037c11ULL, 0x000fe200090f4412ULL,
0x000000011e087824ULL, 0x000fe200078e0224ULL, 0x0000000414107c11ULL, 0x000fe2000f8640ffULL,
0x000000011e127824ULL, 0x000fe200078e0223ULL, 0x000000111d157210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200020e06ffULL, 0x0ffffff809097812ULL, 0x000fe200078ef800ULL,
0x000000081f277824ULL, 0x000fe200078e00ffULL, 0x0000000514117c11ULL, 0x000fe200098f441bULL,
0x000000ffff287224ULL, 0x000fe200028e06ffULL, 0x000000081d1e7210ULL, 0x000fc40007f3e0ffULL,
0xfffffff8251b7812ULL, 0x000fe200078ee200ULL, 0x000000081c257824ULL, 0x000fe200078e00ffULL,
0x000000121d137210ULL, 0x000fe20007f5e0ffULL, 0x00000010091d7824ULL, 0x000fe200078e021aULL,
0x0000000417167c11ULL, 0x000fe2000f8640ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x000000ffff267210ULL, 0x000fe200017fe4ffULL, 0x000000101b187825ULL, 0x000fe200078e0018ULL,
0x000000041e087c11ULL, 0x040fe4000f8440ffULL, 0x0000000413127c11ULL, 0x000fe2000f8240ffULL,
0x000000101b047825ULL, 0x000fe200078e0004ULL, 0x000000051e097c11ULL, 0x000fe200090f4409ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000181d7faeULL, 0x0003e2000c101c46ULL,
0x0000000415147c11ULL, 0x000fe2000f8840ffULL, 0x000000011c1e7824ULL, 0x040fe200078e0200ULL,
0x0000000513137c11ULL, 0x000fe200088f4426ULL, 0x000000101b027825ULL, 0x000fe200078e0002ULL,
0x0000000d1c00720cULL, 0x000fc40003f06070ULL, 0x0000000d1f00720cULL, 0x0c0fe20003f26070ULL,
0x000000011f1c7824ULL, 0x100fe200078e0200ULL, 0x0000000d2000720cULL, 0x0c0fe20003f46070ULL,
0x00000001201f7824ULL, 0x040fe200078e0200ULL, 0x0000000517177c11ULL, 0x000fe200098f442aULL,
0x0000000820207824ULL, 0x000fe200078e00ffULL, 0x0000000515157c11ULL, 0x000fe2000a0f4428ULL,
0x00000008211d7824ULL, 0x042fe200078e00ffULL, 0x0000000d2100720cULL, 0x080fe20003f66070ULL,
0x000000101b107825ULL, 0x000fe200078e0010ULL, 0x0000000d2200720cULL, 0x000fc40003f86070ULL,
0x0000000d2300720cULL, 0x080fe20003fa6070ULL, 0x000000101b167825ULL, 0x000fe200078e0016ULL,
0x0000000d2400720cULL, 0x000fe40003fc6070ULL, 0xfffffff8250d7812ULL, 0x000fe200078ee21eULL,
0x00000001231e7824ULL, 0x140fe200078e0200ULL, 0xfffffff827197812ULL, 0x000fe200078ee21cULL,
0x00000001221c7824ULL, 0x140fe200078e0200ULL, 0x0000000021187210ULL, 0x000fe20007ffe0ffULL,
0x0000000822217824ULL, 0x000fe200078e00ffULL, 0xfffffff8201f7812ULL, 0x000fe200078ee21fULL,
0x0000000823237824ULL, 0x000fe200078e00ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee218ULL,
0x0000000124207824ULL, 0x040fe200078e0200ULL, 0xfffffff821217812ULL, 0x000fe200078ee21cULL,
0x0000000824257824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee21eULL,
0x0000001019197824ULL, 0x100fe200078e021aULL, 0x0000001a0d0d7211ULL, 0x000fe200078e20ffULL,
0x000000101f1f7824ULL, 0x100fe200078e021aULL, 0xfffffff825257812ULL, 0x000fe200078ee220ULL,
0x000000101d1d7824ULL, 0x000fc400078e021aULL, 0x0000001021217824ULL, 0x000fe200078e021aULL,
0x00000000040d7faeULL, 0x0003e2000c101c46ULL, 0x000000101b147825ULL, 0x000fc600078e0014ULL,
0x0000000002197faeULL, 0x0003e2000c901c46ULL, 0x0000001023237824ULL, 0x000fe400078e021aULL,
0x000000101b127825ULL, 0x000fe200078e0012ULL, 0x00000000101f7faeULL, 0x0003e6000d101c46ULL,
0x0000001025257824ULL, 0x000fe200078e021aULL, 0x00000000161d7faeULL, 0x0003e2000d901c46ULL,
0x000000101b087825ULL, 0x000fc600078e0008ULL, 0x0000000014217faeULL, 0x0003e8000e101c46ULL,
0x0000000012237faeULL, 0x0003e8000e901c46ULL, 0x0000000008257faeULL, 0x0003e2000f101c46ULL,
0x0000000400a07947ULL, 0x000fea0003800000ULL, 0x0000000400057811ULL, 0x040fe200078fe8ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000c00117811ULL, 0x040fe200078fe8ffULL,
0x0000400047207824ULL, 0x000fe200078e020aULL, 0x0000000305097819ULL, 0x040fe200000006ffULL,
0x0000000105027824ULL, 0x100fe200078e0200ULL, 0x00000008000d7811ULL, 0x040fe200078fe8ffULL,
0x0000000111047824ULL, 0x140fe200078e0200ULL, 0x0000001400157811ULL, 0x040fe200078fe8ffULL,
0x0000000811137824ULL, 0x000fe200078e00ffULL, 0xfffffff809097812ULL, 0x000fe200078ee202ULL,
0x000000010d037824ULL, 0x140fe200078e0200ULL, 0x0000001e00027211ULL, 0x040fe200078fe8ffULL,
0x000000080d107824ULL, 0x000fe200078e00ffULL, 0xfffffff813127812ULL, 0x000fe200078ee204ULL,
0x0000000115047824ULL, 0x100fe200078e0200ULL, 0x0000001000137811ULL, 0x000fe200078fe8ffULL,
0x000000011e057824ULL, 0x040fe200078e0205ULL, 0x000000021d197210ULL, 0x000fe20007f1e0ffULL,
0x000000011e117824ULL, 0x000fe200078e0211ULL, 0xfffffff810107812ULL, 0x000fe200078ee203ULL,
0x0000000113037824ULL, 0x140fe200078e0200ULL, 0x0000001800177811ULL, 0x000fe200078fe8ffULL,
0x0000000813147824ULL, 0x000fe200078e00ffULL, 0x00000003151b7819ULL, 0x000fe200000006ffULL,
0x000000ffff1a7224ULL, 0x000fe200000e06ffULL, 0x0000000419027c11ULL, 0x000fe2000f8040ffULL,
0x0000000117087824ULL, 0x040fe200078e0200ULL, 0xfffffff814147812ULL, 0x000fe200078ee203ULL,
0x00000008171f7824ULL, 0x000fe200078e00ffULL, 0x0000000519037c11ULL, 0x000fe200080f441aULL,
0x000000011e0d7824ULL, 0x000fe200078e020dULL, 0x0000001c00197811ULL, 0x000fe200078fe8ffULL,
0x000000011e157824ULL, 0x040fe200078e0215ULL, 0xfffffff81b167812ULL, 0x000fe200078ee204ULL,
0x000000011e177824ULL, 0x000fe200078e0217ULL, 0x0000000000047211ULL, 0x000fe200078fe8ffULL,
0x0000000819227824ULL, 0x000fe200078e00ffULL, 0xfffffff81f187812ULL, 0x000fe200078ee208ULL,
0x000000011e087824ULL, 0x000fe200078e0219ULL, 0x000000051d1b7210ULL, 0x000fe20007fde0ffULL,
0x0000000807297824ULL, 0x040fe200078e00ffULL, 0x000000111d1c7210ULL, 0x000fe20007f9e0ffULL,
0x0000200007117824ULL, 0x000fe200078e0220ULL, 0x0000000704057812ULL, 0x000fe200078ec0ffULL,
0x000000ffff207224ULL, 0x000fe200030e06ffULL, 0x000000131e137210ULL, 0x000fc40007ffe0ffULL,
0x0000000d1d1e7210ULL, 0x000fe20007fbe0ffULL, 0x00000001190d7824ULL, 0x000fe200078e0200ULL,
0x000000081d1a7210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff197224ULL, 0x000fe200020e06ffULL,
0x000000041b047c11ULL, 0x040fe4000f8c40ffULL, 0x0001300011277810ULL, 0x000fe40007ffe0ffULL,
0x0ffffff805087812ULL, 0x000fe400078ef800ULL, 0x000000051b057c11ULL, 0x000fe2000b0f4420ULL,
0x00000010091b7824ULL, 0x100fe200078e0227ULL, 0xfffffff822117812ULL, 0x000fe200078ee20dULL,
0x00000010080d7824ULL, 0x100fe200078e0227ULL, 0x000000131d137210ULL, 0x000fe20007f7e0ffULL,
0x00000010121f7824ULL, 0x100fe200078e0227ULL, 0x000000151d157210ULL, 0x000fe20007f1e0ffULL,
0x0000001014217824ULL, 0x100fe200078e0227ULL, 0x000000171d177210ULL, 0x000fe20007f5e0ffULL,
0x00000010101d7824ULL, 0x100fe200078e0227ULL, 0x000000ffff097210ULL, 0x000fe20002ffe4ffULL,
0x0000001016237824ULL, 0x100fe200078e0227ULL, 0x000000041e087c11ULL, 0x000fe2000f8a40ffULL,
0x0000001018257824ULL, 0x100fe200078e0227ULL, 0x000000041c107c11ULL, 0x000fe2000f8840ffULL,
0x0000001011277824ULL, 0x000fe200078e0227ULL, 0x000000051e097c11ULL, 0x000fe2000a8f4409ULL,
0x000000ffff207224ULL, 0x000fe200018e06ffULL, 0x000000051c117c11ULL, 0x000fe2000a0f4419ULL,
0x000000ffff1e7224ULL, 0x000fe200000e06ffULL, 0xfffffff829297812ULL, 0x000fe200078ee200ULL,
0x000000ffff1c7224ULL, 0x000fe200010e06ffULL, 0x0000000413127c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff197224ULL, 0x000fe200008e06ffULL, 0x0000000415147c11ULL, 0x000fe2000f8040ffULL,
0x0000001029027825ULL, 0x000fe200078e0002ULL, 0x0000000417167c11ULL, 0x000fc4000f8440ffULL,
0x000000041a187c11ULL, 0x040fe2000f8240ffULL, 0x0000001029047825ULL, 0x000fe200078e0004ULL,
0x0000000513137c11ULL, 0x000fe200098f4420ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020d7faeULL, 0x0003e2000b901c46ULL, 0x0000000515157c11ULL, 0x000fe200080f441eULL,
0x0000001029087825ULL, 0x000fe200078e0008ULL, 0x0000000517177c11ULL, 0x000fe200090f441cULL,
0x00000000041b7faeULL, 0x0003e2000b901c46ULL, 0x000000051a197c11ULL, 0x000fe200088f4419ULL,
0x0000001029107825ULL, 0x040fe400078e0010ULL, 0x00000000081d7faeULL, 0x0003e4000b901c46ULL,
0x0000001029127825ULL, 0x000fc400078e0012ULL, 0x00000000101f7faeULL, 0x0003e4000b901c46ULL,
0x0000001029147825ULL, 0x040fe400078e0014ULL, 0x0000000012217faeULL, 0x0003e4000b901c46ULL,
0x0000001029167825ULL, 0x040fe400078e0016ULL, 0x0000000014237faeULL, 0x0003e4000b901c46ULL,
0x0000001029187825ULL, 0x000fc400078e0018ULL, 0x0000000016257faeULL, 0x0003e8000b901c46ULL,
0x0000000018277faeULL, 0x0003e4000b901c46ULL, 0x000000030b027812ULL, 0x002fe200078ec0ffULL,
0xffffffffff097424ULL, 0x000fe200078e00ffULL, 0xfffffffd0c0d7811ULL, 0x000fe200078e10ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000030200780cULL, 0x000fc80003f05270ULL,
0x000000010d027807ULL, 0x000fc80004000000ULL, 0x000000020b0b7210ULL, 0x000fc80007ffe0ffULL,
0x000000580b00720cULL, 0x000fda0003f06070ULL, 0x00009000ff058b82ULL, 0x000e620000000800ULL,
0x0000000206048824ULL, 0x000fce00078e00ffULL, 0x00008c00ff028b82ULL, 0x000ea20000000a00ULL,
0x0000000504048224ULL, 0x002fc800078e0205ULL, 0x0000000104058824ULL, 0x000fc800078e020bULL,
0x0000000405028825ULL, 0x004fca00078e0002ULL, 0x0000000602098981ULL, 0x000322000c1e1900ULL,
0x0000000e5900720cULL, 0x000fe20003f06070ULL, 0xff317217ff647424ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fc4000001ff00ULL,
0x0000000000247805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fe4000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x0000006800b80947ULL, 0x002fec0003800000ULL,
0x00009000ff027b82ULL, 0x000e620000000800ULL, 0x0000000206057824ULL, 0x000fe200078e00ffULL,
0x000000ff00657202ULL, 0x000fe20000000f00ULL, 0xff317217ff647424ULL, 0x000fe400078e00ffULL,
0x000000ffff2f7224ULL, 0x000fe400078e00ffULL, 0x0000000205057224ULL, 0x002fce00078e0202ULL,
0x0000010059317824ULL, 0x000fca00078e00ffULL, 0x0000005a3100720cULL, 0x000fda0003f06070ULL,
0x0000006800880947ULL, 0x000fea0003800000ULL, 0x0000000159317836ULL, 0x000fe20000000000ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x000000105b067824ULL, 0x000fe400078e00ffULL,
0x0000000409367c24ULL, 0x010fe2000f8e02ffULL, 0x0000000e3100720cULL, 0x000fe40003f06070ULL,
0xffffffe006067812ULL, 0x000fe400078ec0ffULL, 0x0000000636367819ULL, 0x000fc600000006ffULL,
0x0000010059067824ULL, 0x000fc800078e0206ULL, 0x0000004006097836ULL, 0x000fe40000000000ULL,
0x000000ffff067224ULL, 0x000fc600078e0065ULL, 0x000000200f377812ULL, 0x000fe200078ef809ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000400e88947ULL, 0x000fea0003800000ULL,
0x00000003ff3b7819ULL, 0x000fe20000011600ULL, 0x000000ffff317224ULL, 0x000fe200078e0a09ULL,
0x000000095a407248ULL, 0x000fe20007fe0000ULL, 0x0000000807307824ULL, 0x000fe200078e00ffULL,
0x0000000700097812ULL, 0x000fe200078ec0ffULL, 0x000000043b4b7836ULL, 0x000fe20000000000ULL,
0x0000002040407446ULL, 0x000fe20003800031ULL, 0x0000100065327824ULL, 0x000fe200078e00ffULL,
0x0000000830097812ULL, 0x000fe200078ee209ULL, 0x000000014b357824ULL, 0x100fe200078e0237ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x000020005b307824ULL, 0x000fe200078e00ffULL,
0x000000373b317210ULL, 0x000fe20007ffe0ffULL, 0x000000083b4d7836ULL, 0x000fe20000000000ULL,
0x0000003536357210ULL, 0x000fe20007f3e0ffULL, 0x0000400047477824ULL, 0x000fe200078e020aULL,
0x0000200030337812ULL, 0x000fe200078ec0ffULL, 0x000000014d397824ULL, 0x000fe200078e0237ULL,
0x0000100032347812ULL, 0x000fe200078e0cffULL, 0x000000ffff3a7224ULL, 0x000fe200008e06ffULL,
0x0000000435327c11ULL, 0x040fe2000f8240ffULL, 0x0000000c3b4f7836ULL, 0x000fe20000000000ULL,
0x0000003136317210ULL, 0x000fe20007f1e0ffULL, 0x000000143b537836ULL, 0x000fe20000000000ULL,
0x0000004734347210ULL, 0x000fe20007ffe033ULL, 0x000000183b557836ULL, 0x000fe20000000000ULL,
0x0000003936397210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff3c7224ULL, 0x000fe200000e06ffULL,
0x0000000535337c11ULL, 0x000fe200088f443aULL, 0x000000013b357824ULL, 0x000fe200078e0200ULL,
0x00000004313e7c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff387224ULL, 0x000fe200010e06ffULL,
0x0000000439307c11ULL, 0x000fe2000f8440ffULL, 0x0000001c3b577836ULL, 0x000fe20000000000ULL,
0x000000103b517810ULL, 0x000fe20007ffe0ffULL, 0x00000001553d7824ULL, 0x100fe200078e0237ULL,
0x0000000735437812ULL, 0x000fe200078ec0ffULL, 0x000000014f357824ULL, 0x100fe200078e0237ULL,
0x00000005313f7c11ULL, 0x000fe200080f443cULL, 0x0001300034417836ULL, 0x000fe20000000000ULL,
0x0000000539317c11ULL, 0x000fe200090f4438ULL, 0x0000000151397824ULL, 0x100fe200078e0237ULL,
0x000000403b00720cULL, 0x000fe20003f06070ULL, 0x00000001533b7824ULL, 0x000fe200078e0237ULL,
0x00000035363a7210ULL, 0x000fe20007f3e0ffULL, 0x00000010093e7825ULL, 0x000fe200078e003eULL,
0x0000003757377210ULL, 0x000fc40007ffe0ffULL, 0x0000003936497210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x0000003b363b7210ULL, 0x000fe20007fbe0ffULL,
0x00000008574e7824ULL, 0x000fe200078e00ffULL, 0x0000003d36477210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff4c7224ULL, 0x000fe200020e06ffULL, 0x0000003736357210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff4a7224ULL, 0x000fe200028e06ffULL, 0x0ffffff843347812ULL, 0x000fe200078ef800ULL,
0x000000ffff487224ULL, 0x000fe200010e06ffULL, 0x000000043a387c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff427224ULL, 0x000fe200008e06ffULL, 0x0000000447367c11ULL, 0x000fe2000f8240ffULL,
0x0000001034437824ULL, 0x000fe200078e0241ULL, 0x000000053a397c11ULL, 0x000fe200098f4439ULL,
0x0000001009327825ULL, 0x000fe200078e0032ULL, 0x000000043b3a7c11ULL, 0x000fc4000f8840ffULL,
0x0000000435347c11ULL, 0x000fe2000f8440ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e437faeULL, 0x0003e2000c101c46ULL, 0x00000004493c7c11ULL, 0x000fe2000f8640ffULL,
0x0000001009307825ULL, 0x000fe200078e0030ULL, 0x000000053b3b7c11ULL, 0x000fe4000a0f444aULL,
0x0000000547377c11ULL, 0x000fe200088f4448ULL, 0x000000014d477824ULL, 0x000fe200078e0200ULL,
0x0000000535357c11ULL, 0x000fe200090f4442ULL, 0x000000084d4a7824ULL, 0x000fe200078e00ffULL,
0x000000404b00720cULL, 0x080fe20003f06070ULL, 0x000000014f487824ULL, 0x000fe200078e0200ULL,
0x000000004b427210ULL, 0x000fe20007ffe0ffULL, 0x000000084b4b7824ULL, 0x000fe200078e00ffULL,
0x00000005493d7c11ULL, 0x000fe200098f444cULL, 0x00000001513f7824ULL, 0x102fe200078e0200ULL,
0x000000404d00720cULL, 0x080fe20003f26070ULL, 0x00000008554c7824ULL, 0x000fe200078e00ffULL,
0x000000404f00720cULL, 0x0c0fe20003f46070ULL, 0x000000084f4f7824ULL, 0x000fe200078e00ffULL,
0x000000405100720cULL, 0x080fe20003f66070ULL, 0x0000000157497824ULL, 0x000fe200078e0200ULL,
0x000000405300720cULL, 0x080fe20003f86070ULL, 0x0000001009387825ULL, 0x000fe200078e0038ULL,
0x000000405500720cULL, 0x000fc40003fa6070ULL, 0x000000405700720cULL, 0x000fe20003fc6070ULL,
0x0000000851407824ULL, 0x000fe200078e00ffULL, 0xfffffff84a3e7812ULL, 0x000fe200078ee247ULL,
0x00000008534a7824ULL, 0x000fe200078e00ffULL, 0xfffffff84b427812ULL, 0x000fe200078ee242ULL,
0x0000000155477824ULL, 0x000fe200078e0200ULL, 0x0000000053437210ULL, 0x000fe20007ffe0ffULL,
0x00000010093c7825ULL, 0x040fe200078e003cULL, 0xfffffff84f487812ULL, 0x000fe400078ee248ULL,
0xfffffff840407812ULL, 0x000fe200078ee23fULL, 0x00000010423f7824ULL, 0x100fe200078e0241ULL,
0xfffffff84a4a7812ULL, 0x000fe200078ee243ULL, 0x000000103e437824ULL, 0x000fe200078e0241ULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee247ULL, 0x00000010093a7825ULL, 0x000fe200078e003aULL,
0xfffffff84e4e7812ULL, 0x000fe200078ee249ULL, 0x00000000323f7faeULL, 0x0003e2000c101c46ULL,
0x0000004148477211ULL, 0x000fe200078e20ffULL, 0x0000001040497824ULL, 0x000fc400078e0241ULL,
0x000000104a4b7824ULL, 0x100fe200078e0241ULL, 0x0000000030437faeULL, 0x0003e2000c901c46ULL,
0x000000104c4d7824ULL, 0x000fe400078e0241ULL, 0x0000001009367825ULL, 0x040fe200078e0036ULL,
0x0000000038477faeULL, 0x0003e6000d101c46ULL, 0x000000104e417824ULL, 0x000fe200078e0241ULL,
0x000000003c497faeULL, 0x0003e2000d901c46ULL, 0x0000001009347825ULL, 0x000fc600078e0034ULL,
0x000000003a4b7faeULL, 0x0003e8000e101c46ULL, 0x00000000364d7faeULL, 0x0003e8000e901c46ULL,
0x0000000034417faeULL, 0x0003e2000f101c46ULL, 0x0000000400b47947ULL, 0x000fea0003800000ULL,
0x00000008003b7811ULL, 0x040fe200078fe8ffULL, 0x000020005b317824ULL, 0x000fe200078e00ffULL,
0x00000010003d7811ULL, 0x040fe200078fe8ffULL, 0x0000100065327824ULL, 0x000fe200078e00ffULL,
0x0000000700097812ULL, 0x040fe200078ec0ffULL, 0x000000013b407824ULL, 0x100fe200078e0200ULL,
0x0000000307347819ULL, 0x000fe200000006ffULL, 0x000000083b337824ULL, 0x000fe200078e00ffULL,
0x000000033d357819ULL, 0x040fe200000006ffULL, 0x000000013d427824ULL, 0x000fe200078e0200ULL,
0x0000000834097812ULL, 0x000fe200078ee209ULL, 0x0000400047307824ULL, 0x000fe200078e020aULL,
0xfffffff833407812ULL, 0x000fe200078ee240ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000400347811ULL, 0x040fe200078fe8ffULL, 0x000000013d3d7824ULL, 0x000fe200078e0237ULL,
0x0000003700337211ULL, 0x000fc400078fe8ffULL, 0xfffffff835427812ULL, 0x000fe400078ee242ULL,
0x0000200031317812ULL, 0x000fe400078ec0ffULL, 0x0000100032327812ULL, 0x000fe400078e0cffULL,
0x0000000c003c7811ULL, 0x000fe400078fe8ffULL, 0x0000003336357210ULL, 0x000fe20007f1e0ffULL,
0x0000000134337824ULL, 0x000fe200078e0237ULL, 0x0000003032307210ULL, 0x000fe20007ffe031ULL,
0x0000000134317824ULL, 0x100fe200078e0200ULL, 0x00000014003f7811ULL, 0x000fe200078fe8ffULL,
0x0000000834327824ULL, 0x000fe200078e00ffULL, 0x0000003336337210ULL, 0x000fe20007f3e0ffULL,
0x000000013c417824ULL, 0x100fe200078e0200ULL, 0x0000001800437811ULL, 0x000fe200078fe8ffULL,
0x000000083c387824ULL, 0x000fe200078e00ffULL, 0xfffffff832317812ULL, 0x000fe200078ee231ULL,
0x000000013f397824ULL, 0x000fc400078e0200ULL, 0x000000083f487824ULL, 0x000fe200078e00ffULL,
0xfffffff838417812ULL, 0x000fe200078ee241ULL, 0x000000ffff3a7224ULL, 0x000fe200000e06ffULL,
0x0000000435387c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x0000000433347c11ULL, 0x000fe2000f8240ffULL, 0x00000001433e7824ULL, 0x040fe200078e0200ULL,
0xfffffff8484d7812ULL, 0x000fe200078ee239ULL, 0x00000008434f7824ULL, 0x000fe200078e00ffULL,
0x0000000535397c11ULL, 0x000fe200080f443aULL, 0x000000013f3f7824ULL, 0x100fe200078e0237ULL,
0x0000000533357c11ULL, 0x000fe200088f4432ULL, 0x0000000143437824ULL, 0x000fe200078e0237ULL,
0x0000001c00327811ULL, 0x000fe200078fe8ffULL, 0x0000001009387825ULL, 0x000fe200078e0038ULL,
0x000000373b337210ULL, 0x000fc40007ffe0ffULL, 0x0000004336437210ULL, 0x000fe20007f3e0ffULL,
0x000000013c3b7824ULL, 0x100fe200078e0237ULL, 0x00000033363a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000132377824ULL, 0x040fe200078e0237ULL, 0x0000003f36337210ULL, 0x000fe20007f1e0ffULL,
0x0000000132477824ULL, 0x040fe200078e0200ULL, 0x000000ffff3f7210ULL, 0x000fe20001ffe4ffULL,
0x00000008324a7824ULL, 0x000fe200078e00ffULL, 0x0000003b36327210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff4c7224ULL, 0x000fe200000e06ffULL, 0x0000003d363b7210ULL, 0x000fe20007f5e0ffULL,
0x0000001009347825ULL, 0x000fe200078e0034ULL, 0x0000003736487210ULL, 0x000fc40007f7e0ffULL,
0x0000000000377211ULL, 0x000fe200078fe8ffULL, 0x000000ffff3d7224ULL, 0x000fe200028e06ffULL,
0x00000004323c7c11ULL, 0x040fe2000f8a40ffULL, 0x000000ffff4e7224ULL, 0x000fe200010e06ffULL,
0xfffffff84a517812ULL, 0x000fe200078ee247ULL, 0x000000ffff4a7224ULL, 0x000fe200008e06ffULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee23eULL, 0x000000ffff537224ULL, 0x000fe200018e06ffULL,
0x00000005323d7c11ULL, 0x000fe4000a8f443dULL, 0x0000000433367c11ULL, 0x000fc4000f8040ffULL,
0x000000043a3e7c11ULL, 0x040fe2000f8840ffULL, 0x00000010093c7825ULL, 0x000fe200078e003cULL,
0x0000000443327c11ULL, 0x000fe4000f8240ffULL, 0x0000000737477812ULL, 0x000fe400078ec0ffULL,
0x0000000533377c11ULL, 0x000fe400080f444cULL, 0x000000053a3f7c11ULL, 0x000fe4000a0f443fULL,
0x0000000543337c11ULL, 0x000fe200088f444aULL, 0x00013000304a7836ULL, 0x000fe20000000000ULL,
0x000000043b3a7c11ULL, 0x000fe2000f8440ffULL, 0x00000010093e7825ULL, 0x000fe200078e003eULL,
0x0ffffff847437812ULL, 0x000fc400078ef800ULL, 0x0000000448307c11ULL, 0x000fe2000f8040ffULL,
0x0000001040497824ULL, 0x000fe200078e024aULL, 0x000000053b3b7c11ULL, 0x000fe200090f444eULL,
0x0000001043437824ULL, 0x100fe200078e024aULL, 0x0000004a31477211ULL, 0x000fe200078e20ffULL,
0x0000001041417824ULL, 0x100fe200078e024aULL, 0x0000000548317c11ULL, 0x000fe200080f4453ULL,
0x00000010424b7824ULL, 0x000fe200078e024aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000038437faeULL, 0x0003e2000b901c46ULL, 0x00000010093a7825ULL, 0x000fc600078e003aULL,
0x0000000034477faeULL, 0x0003e2000b901c46ULL, 0x000000104d4d7824ULL, 0x000fe400078e024aULL,
0x0000001009367825ULL, 0x000fe200078e0036ULL, 0x000000003e497faeULL, 0x0003e6000b901c46ULL,
0x000000104f4f7824ULL, 0x000fe200078e024aULL, 0x000000003c417faeULL, 0x0003e2000b901c46ULL,
0x0000001009327825ULL, 0x000fc600078e0032ULL, 0x000000003a4b7faeULL, 0x0003e2000b901c46ULL,
0x0000001051517824ULL, 0x000fe400078e024aULL, 0x0000001009307825ULL, 0x000fe200078e0030ULL,
0x00000000364d7faeULL, 0x0003e8000b901c46ULL, 0x00000000324f7faeULL, 0x0003e8000b901c46ULL,
0x0000000030517faeULL, 0x0003e4000b901c46ULL, 0x000000030b097812ULL, 0x000fe200078ec0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000030900780cULL, 0x000fe20003f05270ULL,
0xffffffffff097424ULL, 0x000fc600078e00ffULL, 0x000000010d307807ULL, 0x002fca0004000000ULL,
0x000000010b0b7824ULL, 0x000fca00078e0230ULL, 0x000000580b00720cULL, 0x000fda0003f06070ULL,
0x00008c00ff308b82ULL, 0x000e620000000a00ULL, 0x0000000b05338210ULL, 0x000fe40007ffe0ffULL,
0x0000001045327812ULL, 0x040fe400078ec0ffULL, 0x0000000845637812ULL, 0x000fe200078ec0ffULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x0000000433308825ULL, 0x002fe200078e0030ULL,
0xffffffe045337812ULL, 0x000fc800078ec0ffULL, 0x0000000a32327210ULL, 0x000fe20007ffe033ULL,
0x0000000630098981ULL, 0x000328000c1e1900ULL, 0x0000000132637824ULL, 0x000fc800078e0263ULL,
0x01b60834633479a7ULL, 0x0002a6000850003fULL, 0x0000000000307805ULL, 0x002fce0000015200ULL,
0x01b60835630075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230377210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003732327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01b60835630075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000055b307819ULL, 0x000fe200000006ffULL,
0x00000010004f7824ULL, 0x000fe200078e00ffULL, 0x00000001ff4c7819ULL, 0x000fe20000011600ULL,
0x000000ffff517224ULL, 0x000fe200078e0064ULL, 0xffffff80304d7812ULL, 0x000fe400078ec0ffULL,
0x000000704f4f7812ULL, 0x000fe400078ec0ffULL, 0x0000000c4c4c7812ULL, 0x000fe200078ec0ffULL,
0x000000010a4d7824ULL, 0x000fca00078e024dULL, 0x0000004d4c307210ULL, 0x000fca0007ffe04fULL,
0x01b0000030317984ULL, 0x000e680000000800ULL, 0x01b2000030577984ULL, 0x0004a20000000800ULL,
0x000000643100720bULL, 0x002fda0003f1d000ULL, 0x0000000000327806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff32337812ULL, 0x000fda000782c0ffULL,
0x0000000000f09947ULL, 0x004fea0003800000ULL, 0x0000005b4600720cULL, 0x000fe40003f45270ULL,
0x000000643100720bULL, 0x000fe40003f34000ULL, 0x0000003164517209ULL, 0x000fd20007810000ULL,
0x000000805b30a824ULL, 0x000fe400078e020aULL, 0x0000000000347806ULL, 0x000fc600008e0100ULL,
0x000000304c30a210ULL, 0x000fe40007ffe04fULL, 0x0000991034327816ULL, 0x000fc600000000ffULL,
0x01b400513000a388ULL, 0x0003e20000000800ULL, 0x000000ff3200720cULL, 0x000fda0003f25270ULL,
0x0000000000b09947ULL, 0x002fea0003800000ULL, 0x8000005164307221ULL, 0x000fe20000010000ULL,
0x000000ff34ff7812ULL, 0x040fe4000782c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL, 0x0000003000357308ULL, 0x0002ac0000000800ULL,
0x0000000000489947ULL, 0x000fea0003800000ULL, 0x00000002ff307819ULL, 0x002fcc0000011600ULL,
0x00001f3035307589ULL, 0x004e6400000e0000ULL, 0x0000003010107220ULL, 0x082fe20000410000ULL,
0x0000003011117220ULL, 0x080fe20000410000ULL, 0x0000003014147220ULL, 0x080fe20000410000ULL,
0x0000003015157220ULL, 0x080fe20000410000ULL, 0x0000003018187220ULL, 0x080fe20000410000ULL,
0x0000003019197220ULL, 0x080fe20000410000ULL, 0x000000301c1c7220ULL, 0x080fe20000410000ULL,
0x000000301d1d7220ULL, 0x080fe20000410000ULL, 0x0000003020207220ULL, 0x080fe20000410000ULL,
0x0000003021217220ULL, 0x080fe20000410000ULL, 0x0000003024247220ULL, 0x080fe20000410000ULL,
0x0000003025257220ULL, 0x080fe20000410000ULL, 0x0000003028287220ULL, 0x080fe20000410000ULL,
0x0000003029297220ULL, 0x080fe20000410000ULL, 0x000000302c2c7220ULL, 0x080fe20000410000ULL,
0x000000302d2d7220ULL, 0x000fce0000410000ULL, 0x0000003508087220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x0000000800307811ULL, 0x002fcc00078ff0ffULL,
0x00001f3035307589ULL, 0x000e6400000e0000ULL, 0x0000003012127220ULL, 0x082fe20000410000ULL,
0x0000003013137220ULL, 0x080fe20000410000ULL, 0x0000003016167220ULL, 0x080fe20000410000ULL,
0x0000003017177220ULL, 0x080fe20000410000ULL, 0x000000301a1a7220ULL, 0x080fe20000410000ULL,
0x000000301b1b7220ULL, 0x080fe20000410000ULL, 0x000000301e1e7220ULL, 0x080fe20000410000ULL,
0x000000301f1f7220ULL, 0x080fe20000410000ULL, 0x0000003022227220ULL, 0x080fe20000410000ULL,
0x0000003023237220ULL, 0x080fe20000410000ULL, 0x0000003026267220ULL, 0x080fe20000410000ULL,
0x0000003027277220ULL, 0x080fe20000410000ULL, 0x000000302a2a7220ULL, 0x080fe20000410000ULL,
0x000000302b2b7220ULL, 0x080fe20000410000ULL, 0x000000302e2e7220ULL, 0x080fe20000410000ULL,
0x000000302f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff33ff7812ULL, 0x000fda0007826034ULL,
0x8000005131311221ULL, 0x000fe20000010000ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b31311820ULL, 0x000fc80000410000ULL, 0x0000003100041308ULL, 0x000ea40000000800ULL,
0x0000000457571220ULL, 0x004fce0000410000ULL, 0x00000007004b7812ULL, 0x040fe200078ec0ffULL,
0x000000025b497824ULL, 0x040fe200078e00ffULL, 0x0000000800537812ULL, 0x000fe200078ec0ffULL,
0x000002005b327824ULL, 0x000fe200078e00ffULL, 0x000000084b557812ULL, 0x000fe200078ef800ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0x00000004ff507819ULL, 0x000fe20000011600ULL,
0x0000000855317824ULL, 0x000fe200078e00ffULL, 0x0000000449307812ULL, 0x002fe400078ec0ffULL,
0x00000001ff477819ULL, 0x000fe4000001165bULL, 0x0000000753537812ULL, 0x000fe400078ef800ULL,
0x0000003055307210ULL, 0x000fe20007ffe050ULL, 0x00004000474e7824ULL, 0x000fe200078e020aULL,
0xfffff80032337812ULL, 0x000fe200078ec0ffULL, 0x0000000150347824ULL, 0x000fe200078e0253ULL,
0xfffffff831317812ULL, 0x000fe200078ee230ULL, 0x0000200007307824ULL, 0x000fe200078e024eULL,
0x000000330a487210ULL, 0x000fe20007ffe0ffULL, 0x0000000234617836ULL, 0x000fe20000000000ULL,
0x0000000353367819ULL, 0x040fe200000006ffULL, 0x0000000853377824ULL, 0x000fc400078e00ffULL,
0x0000000434607836ULL, 0x000fe20000000000ULL, 0xfffffff836617812ULL, 0x000fe200078ee261ULL,
0x0000000853357824ULL, 0x000fe400078e00ffULL, 0x00001000655d7824ULL, 0x000fe200078e0230ULL,
0xfffffff837607812ULL, 0x000fe200078ee260ULL, 0x00000010314a7824ULL, 0x000fe200078e0248ULL,
0xfffffff835627812ULL, 0x000fe200078ee234ULL, 0x000130005d5d7836ULL, 0x000fe20000000000ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe40000011600ULL,
0x00000004ff02723eULL, 0x000fc600000000ffULL, 0x0000000803317836ULL, 0x000fe20000000000ULL,
0x0000541002307816ULL, 0x000fca0000000002ULL, 0x00001f0330037589ULL, 0x0002a800000e0000ULL,
0x00001f3130027589ULL, 0x0002e400000e0000ULL, 0x011000004a30783bULL, 0x0022e20000000200ULL,
0x0000001062407824ULL, 0x100fe400078e025dULL, 0x00000010613c7824ULL, 0x000fe200078e025dULL,
0x0000000000108947ULL, 0x000fec0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000231317232ULL, 0x080fe40000000000ULL,
0x0000000233337232ULL, 0x000fce0000000000ULL, 0x0000001060387824ULL, 0x100fe200078e025dULL,
0x000000003c3c783bULL, 0x000f620000004200ULL, 0x00000006345e7836ULL, 0x000fe20000000000ULL,
0x0000000353357819ULL, 0x040fe400000006ffULL, 0x000000004040783bULL, 0x000f620000004200ULL,
0x0000001053537812ULL, 0x000fe400078efcffULL, 0xfffffff8355e7812ULL, 0x000fe200078ee25eULL,
0x000000003838783bULL, 0x000f680000004200ULL, 0x000000105e347824ULL, 0x000fcc00078e025dULL,
0x000000003434783bULL, 0x000f640000004200ULL, 0x0000003c3018723cULL, 0x02afec0000001818ULL,
0x000000403010723cULL, 0x000fe20000001810ULL, 0x00000004473c7824ULL, 0x000fe400078e0250ULL,
0x0000000150507824ULL, 0x000fc600078e0253ULL, 0x000000383020723cULL, 0x004fe20000001820ULL,
0x000000023c3c7810ULL, 0x000fe20007ffe055ULL, 0x0000000250547836ULL, 0x000fc80000000000ULL,
0x000000343028723cULL, 0x000fe20000001828ULL, 0x0000000855397824ULL, 0x000fe200078e00ffULL,
0x0000000353387819ULL, 0x040fe200000006ffULL, 0x0000000853557824ULL, 0x000fc600078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee23cULL, 0x0000000853357824ULL, 0x000fe200078e00ffULL,
0xfffffff855557812ULL, 0x000fe200078ee250ULL, 0x0000000650347836ULL, 0x000fe20000000000ULL,
0x000000423014723cULL, 0x000fe20000001814ULL, 0x0000001039487824ULL, 0x000fe200078e0248ULL,
0xfffffff835547812ULL, 0x000fe200078ee254ULL, 0x0000000853397824ULL, 0x000fe400078e00ffULL,
0x0000000450537836ULL, 0x000fe20000000000ULL, 0x0000003e301c723cULL, 0x000fe2000000181cULL,
0x0000001054407824ULL, 0x000fe200078e025dULL, 0xfffffff839507812ULL, 0x000fc400078ee234ULL,
0xfffffff838537812ULL, 0x000fe200078ee253ULL, 0x0000001055387824ULL, 0x000fe200078e025dULL,
0x0000003a3024723cULL, 0x000fe40000001824ULL, 0x0000005d533c7211ULL, 0x000fc800078e20ffULL,
0x00000036302c723cULL, 0x000fe2000000182cULL, 0x011000004830783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000231317232ULL, 0x080fe40000000000ULL, 0x0000000233337232ULL, 0x000fce0000000000ULL,
0x0000001050347824ULL, 0x000fe200078e025dULL, 0x000000004040783bULL, 0x000ee20000004200ULL,
0xfffffff849497812ULL, 0x000fe200078ec0ffULL, 0x0000000857087221ULL, 0x000fe20000010000ULL,
0x000000ffff647224ULL, 0x000fe200078e0051ULL, 0x000000003c3c783bULL, 0x000f620000004200ULL,
0x0000000165657812ULL, 0x000fe200078e0cffULL, 0x000000010a497824ULL, 0x000fe400078e0249ULL,
0x000000003838783bULL, 0x000f680000004200ULL, 0x000000003434783bULL, 0x000f620000004200ULL,
0x000000403018723cULL, 0x00cfec0000001818ULL, 0x00000042301c723cULL, 0x000fe2000000181cULL,
0x00000001ff407424ULL, 0x000fc800078e00ffULL, 0x01b6884049ff79a7ULL, 0x0005e2000850003fULL,
0x0000003c3020723cULL, 0x022fec0000001820ULL, 0x0000003e3024723cULL, 0x000fec0000001824ULL,
0x000000383010723cULL, 0x000fec0000001810ULL, 0x0000003a3014723cULL, 0x000fec0000001814ULL,
0x000000343028723cULL, 0x000fec0000001828ULL, 0x00000036302c723cULL, 0x000fee000000182cULL,
0x0000004059317811ULL, 0x000fc800078e40ffULL, 0x0000005a3100720cULL, 0x000fda0003f06070ULL,
0x0000004c00180947ULL, 0x004fea0003800000ULL, 0x0000000159317836ULL, 0x000fe20000000000ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x000000105b307824ULL, 0x000fe400078e00ffULL,
0x0000000409097c24ULL, 0x010fe2000f8e02ffULL, 0x0000000e3100720cULL, 0x000fe40003f06070ULL,
0xffffffe030307812ULL, 0x000fe200078ec0ffULL, 0x0000004009097824ULL, 0x000fc800078e00ffULL,
0x0000010059307824ULL, 0x000fca00078e0230ULL, 0x0000008030307810ULL, 0x000fc80007ffe0ffULL,
0x000000200f377812ULL, 0x000fe200078ef830ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400e08947ULL, 0x000fea0003800000ULL, 0x00000003ff5c7819ULL, 0x000fe20000011600ULL,
0x000020005b317824ULL, 0x000fe200078e00ffULL, 0x000000305a417248ULL, 0x000fe20007fe0000ULL,
0x000000ffff307224ULL, 0x000fe200078e0a30ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x000000085c427836ULL, 0x000fe20000000000ULL, 0x0000200031477812ULL, 0x000fe200078ec0ffULL,
0x000000045c437836ULL, 0x000fe20000000000ULL, 0x0000002041417446ULL, 0x000fe20003800030ULL,
0x0000000142367824ULL, 0x100fe200078e0237ULL, 0x000000105c567810ULL, 0x000fe20007ffe0ffULL,
0x000000015c327824ULL, 0x000fe200078e0237ULL, 0x0000003743347210ULL, 0x000fe20007ffe0ffULL,
0x0000100006307824ULL, 0x000fe200078e00ffULL, 0x0000003609367210ULL, 0x000fe20007f5e0ffULL,
0x0000000c5c647836ULL, 0x000fe20000000000ULL, 0x0000003209357210ULL, 0x000fe20007f1e0ffULL,
0x000000145c527836ULL, 0x000fe20000000000ULL, 0x0000003409387210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff337224ULL, 0x000fe200010e06ffULL, 0x0000000436327c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff3a7224ULL, 0x000fe200000e06ffULL, 0x0000100030317812ULL, 0x000fe200078ec0ffULL,
0x000000ffff397224ULL, 0x000fe200008e06ffULL, 0x0000000536337c11ULL, 0x000fe200090f4433ULL,
0x000000015c367824ULL, 0x100fe200078e0200ULL, 0x0000000438307c11ULL, 0x000fe2000f8240ffULL,
0x00000008076a7824ULL, 0x000fe200078e00ffULL, 0x0000000435347c11ULL, 0x000fe2000f8040ffULL,
0x00000001645f7824ULL, 0x000fe200078e0200ULL, 0x0000004e31477210ULL, 0x000fe20007ffe047ULL,
0x000000185c4e7836ULL, 0x000fe20000000000ULL, 0x0000000538317c11ULL, 0x000fe200088f4439ULL,
0x0000000156387824ULL, 0x100fe200078e0237ULL, 0x0000000736397812ULL, 0x000fe200078ec0ffULL,
0x0000000164367824ULL, 0x100fe200078e0237ULL, 0x0000000535357c11ULL, 0x000fe200080f443aULL,
0x00000001523a7824ULL, 0x100fe200078e0237ULL, 0x000000415c00720cULL, 0x000fe20003f06070ULL,
0x0000001c5c5c7836ULL, 0x000fe20000000000ULL, 0x0000003609367210ULL, 0x000fe20007f3e0ffULL,
0x000000014e3c7824ULL, 0x000fe200078e0237ULL, 0x0ffffff839687812ULL, 0x000fe200078ef800ULL,
0x0001300047477836ULL, 0x000fe20000000000ULL, 0x000000375c667210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff377224ULL, 0x000fe200008e06ffULL, 0x00000038093d7210ULL, 0x000fe20007f9e0ffULL,
0x0000001068577824ULL, 0x000fe200078e0247ULL, 0x0000003a093b7210ULL, 0x000fc40007fbe0ffULL,
0x0000003c09397210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff6c7224ULL, 0x000fe200020e06ffULL,
0x0000006609667210ULL, 0x000fe40007f3e0ffULL, 0x00000004363e7c11ULL, 0x040fe2000f8640ffULL,
0x000000ffff687224ULL, 0x000fe200010e06ffULL, 0x000000086a097812ULL, 0x000fe200078ee24bULL,
0x000000ffff6a7224ULL, 0x000fe200028e06ffULL, 0x00000005363f7c11ULL, 0x000fe200098f4437ULL,
0x000000ffff377224ULL, 0x000fe200008e06ffULL, 0x0000000466367c11ULL, 0x000fe2000f8440ffULL,
0x0000001009347825ULL, 0x000fe200078e0034ULL, 0x0000000439387c11ULL, 0x000fc4000f8240ffULL,
0x0000000566377c11ULL, 0x000fe200090f4437ULL, 0x0000000843667824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034577faeULL, 0x0003e2000c101c46ULL,
0x000000043d3c7c11ULL, 0x000fe2000f8640ffULL, 0x0000001009307825ULL, 0x000fe200078e0030ULL,
0x000000043b3a7c11ULL, 0x000fe4000f8840ffULL, 0x0000000539397c11ULL, 0x000fe200088f4468ULL,
0x0000001009327825ULL, 0x000fe200078e0032ULL, 0x000000414300720cULL, 0x080fe40003f06070ULL,
0x00000000435d7210ULL, 0x000fe20007ffe0ffULL, 0x0000000142437824ULL, 0x040fe200078e0200ULL,
0x000000414200720cULL, 0x0c0fe20003f26070ULL, 0x0000000842427824ULL, 0x000fe200078e00ffULL,
0x000000053d3d7c11ULL, 0x000fe200098f446cULL, 0x0000000156357824ULL, 0x002fe200078e0200ULL,
0x000000053b3b7c11ULL, 0x000fe2000a0f446aULL, 0x000000015c577824ULL, 0x000fe200078e0200ULL,
0x000000416400720cULL, 0x0c0fe20003f46070ULL, 0x0000000864647824ULL, 0x000fe200078e00ffULL,
0x000000415600720cULL, 0x0c0fe20003f66070ULL, 0x0000000856567824ULL, 0x000fe200078e00ffULL,
0x000000415200720cULL, 0x080fe20003f86070ULL, 0x00000010093e7825ULL, 0x000fe200078e003eULL,
0x000000414e00720cULL, 0x000fc40003fa6070ULL, 0x000000415c00720cULL, 0x040fe20003fc6070ULL,
0x000000085c5c7824ULL, 0x000fe200078e00ffULL, 0x0000000052417210ULL, 0x000fe20007ffe0ffULL,
0x0000000852527824ULL, 0x000fe200078e00ffULL, 0xfffffff866347812ULL, 0x000fe200078ee25dULL,
0x000000084e667824ULL, 0x040fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee243ULL,
0x000000014e437824ULL, 0x000fe200078e0200ULL, 0xfffffff864647812ULL, 0x000fe200078ee25fULL,
0x00000010093c7825ULL, 0x000fe200078e003cULL, 0xfffffff8564e7812ULL, 0x000fc400078ee235ULL,
0xfffffff852527812ULL, 0x000fe200078ee241ULL, 0x0000001034357824ULL, 0x100fe200078e0247ULL,
0xfffffff866567812ULL, 0x000fe200078ee243ULL, 0x0000001042417824ULL, 0x100fe200078e0247ULL,
0xfffffff85c5c7812ULL, 0x000fe200078ee257ULL, 0x000000104e577824ULL, 0x100fe200078e0247ULL,
0x0000004764437211ULL, 0x000fe200078e20ffULL, 0x00000010525d7824ULL, 0x000fe200078e0247ULL,
0x0000000030357faeULL, 0x0003e2000c101c46ULL, 0x00000010093a7825ULL, 0x000fc600078e003aULL,
0x0000000032417faeULL, 0x0003e2000c901c46ULL, 0x00000010565f7824ULL, 0x000fe400078e0247ULL,
0x0000001009387825ULL, 0x040fe200078e0038ULL, 0x000000003e437faeULL, 0x0003e6000d101c46ULL,
0x000000105c477824ULL, 0x000fe200078e0247ULL, 0x000000003c577faeULL, 0x0003e2000d901c46ULL,
0x0000001009367825ULL, 0x000fc600078e0036ULL, 0x000000003a5d7faeULL, 0x0003e8000e101c46ULL,
0x00000000385f7faeULL, 0x0003e8000e901c46ULL, 0x0000000036477faeULL, 0x0003e2000f101c46ULL,
0x0000000400ac7947ULL, 0x000fea0003800000ULL, 0x000020005b317824ULL, 0x000fe200078e00ffULL,
0x0000000400347811ULL, 0x000fe200078fe8ffULL, 0x0000100006307824ULL, 0x000fe200078e00ffULL,
0x0000000800357811ULL, 0x000fe200078fe8ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000200031317812ULL, 0x000fe200078ec0ffULL, 0x0000000134327824ULL, 0x100fe200078e0200ULL,
0x0000100030307812ULL, 0x000fe200078ec0ffULL, 0x0000000135477824ULL, 0x040fe200078e0200ULL,
0x0000000334337819ULL, 0x000fe200000006ffULL, 0x0000000835387824ULL, 0x000fe200078e00ffULL,
0x0000004e30307210ULL, 0x000fc40007ffe031ULL, 0xfffffff8334e7812ULL, 0x000fe400078ee232ULL,
0x0000003700327211ULL, 0x040fe400078fe8ffULL, 0x0000000c00367811ULL, 0x000fe400078fe8ffULL,
0x0000003209327210ULL, 0x000fe40007f1e0ffULL, 0xfffffff838477812ULL, 0x000fe200078ee247ULL,
0x0000000136437824ULL, 0x100fe200078e0200ULL, 0x0000001000387811ULL, 0x000fe200078fe8ffULL,
0x00000008363a7824ULL, 0x000fe200078e00ffULL, 0x0000001800527811ULL, 0x000fe200078fe8ffULL,
0x000000ffff337224ULL, 0x000fe200000e06ffULL, 0x00000004323e7c11ULL, 0x000fe2000f8040ffULL,
0x0000000138427824ULL, 0x140fe200078e0200ULL, 0xfffffff83a437812ULL, 0x000fe200078ee243ULL,
0x0000000838397824ULL, 0x000fe200078e00ffULL, 0x00000005323f7c11ULL, 0x000fe200080f4433ULL,
0x0000000134327824ULL, 0x100fe200078e0237ULL, 0x00000014003a7811ULL, 0x000fe200078fe8ffULL,
0x0000000152317824ULL, 0x140fe200078e0200ULL, 0xfffffff839427812ULL, 0x000fe200078ee242ULL,
0x0000000852567824ULL, 0x000fe200078e00ffULL, 0x0000001c00397811ULL, 0x000fe200078fe8ffULL,
0x000000013a417824ULL, 0x140fe200078e0200ULL, 0x0000003209327210ULL, 0x000fe20007f7e0ffULL,
0x0000000135347824ULL, 0x100fe200078e0237ULL, 0x000000033a3c7819ULL, 0x000fe200000006ffULL,
0x0000000136367824ULL, 0x100fe200078e0237ULL, 0xfffffff856317812ULL, 0x000fe200078ee231ULL,
0x0000000138387824ULL, 0x100fe200078e0237ULL, 0x000000373a3a7210ULL, 0x000fe20007ffe0ffULL,
0x0000000152527824ULL, 0x100fe200078e0237ULL, 0xfffffff83c417812ULL, 0x000fe200078ee241ULL,
0x0000000139567824ULL, 0x040fe200078e0237ULL, 0x0000003409337210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff357224ULL, 0x000fe200018e06ffULL, 0x0000003609367210ULL, 0x000fe20007f1e0ffULL,
0x00000001393b7824ULL, 0x040fe200078e0200ULL, 0x00000004323c7c11ULL, 0x000fe2000f8c40ffULL,
0x00000008395c7824ULL, 0x000fe200078e00ffULL, 0x0000003809347210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff397224ULL, 0x000fe200000e06ffULL, 0x0000003a09377210ULL, 0x000fc40007f7e0ffULL,
0x0000005209527210ULL, 0x000fe40007f9e0ffULL, 0x0000005609097210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff567224ULL, 0x000fe200010e06ffULL, 0x00000005323d7c11ULL, 0x000fe4000b0f4435ULL,
0x0000000433327c11ULL, 0x000fe4000f8440ffULL, 0x00000004363a7c11ULL, 0x000fe4000f8040ffULL,
0x000000ffff357210ULL, 0x000fc40000ffe4ffULL, 0x0000000434387c11ULL, 0x000fe4000f8240ffULL,
0x0000000000577211ULL, 0x000fe400078fe8ffULL, 0xfffffff85c677812ULL, 0x000fe200078ee23bULL,
0x00000008075c7824ULL, 0x000fe200078e00ffULL, 0x0000000533337c11ULL, 0x000fe200090f4456ULL,
0x000000ffff567224ULL, 0x000fe200018e06ffULL, 0x00000005363b7c11ULL, 0x000fe400080f4439ULL,
0x0000000534397c11ULL, 0x000fe200088f4435ULL, 0x000000ffff357224ULL, 0x000fe200020e06ffULL,
0x0000000437367c11ULL, 0x000fc4000f8040ffULL, 0x0000000757577812ULL, 0x000fe400078ec0ffULL,
0x0000000452347c11ULL, 0x000fe4000f8240ffULL, 0x0000000537377c11ULL, 0x000fe200080f4456ULL,
0x0001300030567836ULL, 0x000fe20000000000ULL, 0x000000085c697812ULL, 0x000fe400078ee24bULL,
0x0ffffff857577812ULL, 0x000fe200078ef800ULL, 0x000000104e5d7824ULL, 0x100fe200078e0256ULL,
0x0000000552357c11ULL, 0x000fe200088f4435ULL, 0x000000ffff527224ULL, 0x000fe200028e06ffULL,
0x0000000409307c11ULL, 0x000fe2000f8040ffULL, 0x0000001057577824ULL, 0x000fe200078e0256ULL,
0x0000005647477211ULL, 0x000fe200078e20ffULL, 0x00000010693e7825ULL, 0x000fc800078e003eULL,
0x0000001031657824ULL, 0x000fe200078e0256ULL, 0x0000000509317c11ULL, 0x000fe200080f4452ULL,
0x00000010693c7825ULL, 0x040fe200078e003cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000003e577faeULL, 0x0003e6000b901c46ULL, 0x0000001069327825ULL, 0x000fe200078e0032ULL,
0x000000003c5d7faeULL, 0x0003e6000b901c46ULL, 0x0000001043437824ULL, 0x000fe200078e0256ULL,
0x0000000032477faeULL, 0x0003e2000b901c46ULL, 0x00000010693a7825ULL, 0x000fc800078e003aULL,
0x00000010425f7824ULL, 0x000fe200078e0256ULL, 0x000000003a437faeULL, 0x0003e2000b901c46ULL,
0x0000001069387825ULL, 0x000fc800078e0038ULL, 0x0000001041417824ULL, 0x000fe200078e0256ULL,
0x00000000385f7faeULL, 0x0003e2000b901c46ULL, 0x0000001069367825ULL, 0x000fc800078e0036ULL,
0x0000001069347825ULL, 0x000fe200078e0034ULL, 0x0000000036417faeULL, 0x0003e6000b901c46ULL,
0x0000001067677824ULL, 0x000fe200078e0256ULL, 0x0000000034657faeULL, 0x0003e2000b901c46ULL,
0x0000001069307825ULL, 0x000fca00078e0030ULL, 0x0000000030677faeULL, 0x0003e4000b901c46ULL,
0x000000030b097812ULL, 0x000fe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000030900780cULL, 0x000fe40003f05270ULL, 0xffffffff00097802ULL, 0x000fe40000000f00ULL,
0x000000010d307807ULL, 0x002fca0004000000ULL, 0x000000010b0b7824ULL, 0x000fca00078e0230ULL,
0x000000580b00720cULL, 0x000fda0003f06070ULL, 0x00008c00ff308b82ULL, 0x000e620000000a00ULL,
0x0000000105338824ULL, 0x000fc800078e020bULL, 0x0000000433308825ULL, 0x002fca00078e0030ULL,
0x0000000630098981ULL, 0x000322000c1e1900ULL, 0x01b62840634079a7ULL, 0x0002a4000850003fULL,
0x0000000000307805ULL, 0x002fce0000015200ULL, 0x01b62841630075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff347224ULL, 0x000fce00078e00ffULL,
0x000000103400780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0x0000003230357210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003532327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000134347836ULL, 0x000fce0000000000ULL,
0x01b62841630075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000804f317810ULL, 0x000fe20007ffe04dULL, 0x000000ffff647224ULL, 0x000fc800078e0051ULL,
0x000000014c317824ULL, 0x000fca00078e0231ULL, 0x01b0000031307984ULL, 0x000e680000000800ULL,
0x01b2000031657984ULL, 0x0004a20000000800ULL, 0x000000513000720bULL, 0x002fda0003f1d000ULL,
0x0000000000327806ULL, 0x000fe400000e0100ULL, 0x000000000000781cULL, 0x000fe40003f0e170ULL,
0x0000ffff32337812ULL, 0x000fda000782c0ffULL, 0x0000000000f49947ULL, 0x004fea0003800000ULL,
0x0000000146327836ULL, 0x000fe20000000000ULL, 0x000000513000720bULL, 0x0c0fe40003f34000ULL,
0x0000005130647209ULL, 0x000fe40007810000ULL, 0x0000005b3200720cULL, 0x000fd20003f45270ULL,
0x0000000000327806ULL, 0x000fc800008e0100ULL, 0x0000000a5b31a211ULL, 0x000fc800078e38ffULL,
0x000000314c35a210ULL, 0x000fe40007ffe04fULL, 0x0000991032317816ULL, 0x000fc600000000ffULL,
0x01b400643500a388ULL, 0x0003e20000000800ULL, 0x000000ff3100720cULL, 0x000fda0003f25270ULL,
0x0000000000b09947ULL, 0x002fea0003800000ULL, 0x0000005164317221ULL, 0x000fe20000010100ULL,
0x000000ff32ff7812ULL, 0x040fe4000782c0ffULL, 0x0000ff0032ff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b31317820ULL, 0x000fc80000410000ULL, 0x0000003100357308ULL, 0x0002ac0000000800ULL,
0x0000000000489947ULL, 0x000fea0003800000ULL, 0x00000002ff347819ULL, 0x000fca0000011600ULL,
0x00001f3435317589ULL, 0x006e6400000e0000ULL, 0x0000003110107220ULL, 0x082fe20000410000ULL,
0x0000003111117220ULL, 0x080fe20000410000ULL, 0x0000003114147220ULL, 0x080fe20000410000ULL,
0x0000003115157220ULL, 0x080fe20000410000ULL, 0x0000003118187220ULL, 0x080fe20000410000ULL,
0x0000003119197220ULL, 0x080fe20000410000ULL, 0x000000311c1c7220ULL, 0x080fe20000410000ULL,
0x000000311d1d7220ULL, 0x080fe20000410000ULL, 0x0000003120207220ULL, 0x080fe20000410000ULL,
0x0000003121217220ULL, 0x080fe20000410000ULL, 0x0000003124247220ULL, 0x080fe20000410000ULL,
0x0000003125257220ULL, 0x080fe20000410000ULL, 0x0000003128287220ULL, 0x080fe20000410000ULL,
0x0000003129297220ULL, 0x080fe20000410000ULL, 0x000000312c2c7220ULL, 0x080fe20000410000ULL,
0x000000312d2d7220ULL, 0x000fce0000410000ULL, 0x0000003508087220ULL, 0x004fe20000410000ULL,
0x000000000048a947ULL, 0x000fec0003800000ULL, 0x0000000800347811ULL, 0x000fca00078ff0ffULL,
0x00001f3435317589ULL, 0x002e6400000e0000ULL, 0x0000003112127220ULL, 0x082fe20000410000ULL,
0x0000003113137220ULL, 0x080fe20000410000ULL, 0x0000003116167220ULL, 0x080fe20000410000ULL,
0x0000003117177220ULL, 0x080fe20000410000ULL, 0x000000311a1a7220ULL, 0x080fe20000410000ULL,
0x000000311b1b7220ULL, 0x080fe20000410000ULL, 0x000000311e1e7220ULL, 0x080fe20000410000ULL,
0x000000311f1f7220ULL, 0x080fe20000410000ULL, 0x0000003122227220ULL, 0x080fe20000410000ULL,
0x0000003123237220ULL, 0x080fe20000410000ULL, 0x0000003126267220ULL, 0x080fe20000410000ULL,
0x0000003127277220ULL, 0x080fe20000410000ULL, 0x000000312a2a7220ULL, 0x080fe20000410000ULL,
0x000000312b2b7220ULL, 0x080fe20000410000ULL, 0x000000312e2e7220ULL, 0x080fe20000410000ULL,
0x000000312f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff33ff7812ULL, 0x000fda0007826032ULL,
0x0000003064301221ULL, 0x000fe20000010100ULL, 0x000000000000181cULL, 0x000fc60003f0f070ULL,
0x3fb8aa3b30301820ULL, 0x000fc80000410000ULL, 0x0000003000041308ULL, 0x000ea40000000800ULL,
0x0000000465651220ULL, 0x004fce0000410000ULL, 0x00000001ff477819ULL, 0x000fe2000001165bULL,
0x0000100006677824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000400047667824ULL, 0x000fe200078e020aULL, 0x0000100067677812ULL, 0x000fc600078e0cffULL,
0x0000200007307824ULL, 0x000fca00078e0266ULL, 0x0001300030697810ULL, 0x000fe20007ffe067ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe40000011600ULL,
0x00000004ff02723eULL, 0x000fc600000000ffULL, 0x0000000803317836ULL, 0x002fe20000000000ULL,
0x0000541002307816ULL, 0x000fca0000000002ULL, 0x00001f0330037589ULL, 0x0002a800000e0000ULL,
0x00001f3130027589ULL, 0x0002e400000e0000ULL, 0x011800004a30783bULL, 0x0022e20000000200ULL,
0x00000010625f7824ULL, 0x100fe400078e0269ULL, 0x00000010615d7824ULL, 0x100fe400078e0269ULL,
0x00000010605c7824ULL, 0x000fe200078e0269ULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000231317232ULL, 0x080fe40000000000ULL, 0x0000000233337232ULL, 0x000fce0000000000ULL,
0x000000695e577211ULL, 0x000fe200078e20ffULL, 0x000000005f40783bULL, 0x000f620000004200ULL,
0x0000001055567824ULL, 0x100fe400078e0269ULL, 0x0000001054527824ULL, 0x100fe200078e0269ULL,
0x000000005d3c783bULL, 0x000f620000004200ULL, 0x0000001053517824ULL, 0x000fc600078e0269ULL,
0x000000005c38783bULL, 0x000f680000004200ULL, 0x000000005734783bULL, 0x000f640000004200ULL,
0x000000403010723cULL, 0x02afec0000001810ULL, 0x000000423014723cULL, 0x000fec0000001814ULL,
0x0000003c3018723cULL, 0x000fec0000001818ULL, 0x0000003e301c723cULL, 0x000fec000000181cULL,
0x000000383020723cULL, 0x004fec0000001820ULL, 0x0000003a3024723cULL, 0x000fec0000001824ULL,
0x000000343028723cULL, 0x000fec0000001828ULL, 0x00000036302c723cULL, 0x000fe2000000182cULL,
0x011800004830783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000231317232ULL, 0x080fe40000000000ULL,
0x0000000233337232ULL, 0x000fce0000000000ULL, 0x00000010504e7824ULL, 0x000fe200078e0269ULL,
0x000000005640783bULL, 0x000ee20000004200ULL, 0x0000000865087221ULL, 0x000fe20000010000ULL,
0x0000000106657812ULL, 0x000fe400078ec0ffULL, 0x00000000523c783bULL, 0x000f680000004200ULL,
0x000000005138783bULL, 0x000f680000004200ULL, 0x000000004e34783bULL, 0x000f620000004200ULL,
0x000000403010723cULL, 0x00cfec0000001810ULL, 0x000000423014723cULL, 0x000fe20000001814ULL,
0x00000001ff407424ULL, 0x000fc800078e00ffULL, 0x01b6904049ff79a7ULL, 0x0005e2000850003fULL,
0x0000003c3018723cULL, 0x022fec0000001818ULL, 0x0000003e301c723cULL, 0x000fec000000181cULL,
0x000000383020723cULL, 0x000fec0000001820ULL, 0x0000003a3024723cULL, 0x000fec0000001824ULL,
0x000000343028723cULL, 0x000fec0000001828ULL, 0x00000036302c723cULL, 0x000fee000000182cULL,
0x0000008059317811ULL, 0x000fc800078e40ffULL, 0x0000005a3100720cULL, 0x000fda0003f06070ULL,
0x0000003000a00947ULL, 0x004fea0003800000ULL, 0x000000105b307824ULL, 0x000fe200078e00ffULL,
0x0000000159337810ULL, 0x000fe20007ffe0ffULL, 0x0000840000047ab9ULL, 0x000fe40000000800ULL,
0x0000000409097c24ULL, 0x010fe2000f8e02ffULL, 0x0000000e3300720cULL, 0x000fe40003f06070ULL,
0xffffffe030307812ULL, 0x000fe200078ec0ffULL, 0x0000004009097824ULL, 0x000fc800078e00ffULL,
0x0000010059307824ULL, 0x000fc800078e0230ULL, 0x000000c030317836ULL, 0x000fca0000000000ULL,
0x000000200f367812ULL, 0x000fe200078ef831ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000400d88947ULL, 0x000fea0003800000ULL, 0x00000003ff657819ULL, 0x000fe20000011600ULL,
0x000020005b337824ULL, 0x000fe200078e00ffULL, 0x000000315a427248ULL, 0x000fe20007fe0000ULL,
0x000000ffff317224ULL, 0x000fe200078e0a31ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000865417836ULL, 0x000fe20000000000ULL, 0x0000200033477812ULL, 0x000fe200078ec0ffULL,
0x0000000465437836ULL, 0x000fe20000000000ULL, 0x0000002042427446ULL, 0x000fe20003800031ULL,
0x0000000141347824ULL, 0x100fe200078e0236ULL, 0x0000006667477210ULL, 0x000fe20007ffe047ULL,
0x0000000165307824ULL, 0x040fe200078e0236ULL, 0x0000003643327210ULL, 0x000fe20007ffe0ffULL,
0x0000000c656d7836ULL, 0x000fe20000000000ULL, 0x0000003409317210ULL, 0x000fe20007f5e0ffULL,
0x0000000165377824ULL, 0x000fe200078e0200ULL, 0x0000003009357210ULL, 0x000fe20007f1e0ffULL,
0x0000001465697836ULL, 0x000fe20000000000ULL, 0x0000003209337210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff387224ULL, 0x000fe200010e06ffULL, 0x0000000431307c11ULL, 0x000fe2000f8440ffULL,
0x000000ffff3c7224ULL, 0x000fe200000e06ffULL, 0x0000000435347c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff3a7224ULL, 0x000fe200008e06ffULL, 0x0000000531317c11ULL, 0x000fe200090f4438ULL,
0x000000016d387824ULL, 0x000fe200078e0236ULL, 0x0000000433327c11ULL, 0x000fe2000f8240ffULL,
0x0000001865677836ULL, 0x000fe20000000000ULL, 0x0000000535357c11ULL, 0x000fe200080f443cULL,
0x00000001693c7824ULL, 0x100fe200078e0236ULL, 0x00000010656b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000167667824ULL, 0x000fe200078e0236ULL, 0x000000426500720cULL, 0x000fe20003f06070ULL,
0x0000001c65657836ULL, 0x000fe20000000000ULL, 0x0000000533337c11ULL, 0x000fe200088f443aULL,
0x000000016b3a7824ULL, 0x000fe200078e0236ULL, 0x0000003809387210ULL, 0x000fe20007f3e0ffULL,
0x00000008076a7824ULL, 0x000fe200078e00ffULL, 0x0000000737377812ULL, 0x000fe200078ec0ffULL,
0x0001300047477836ULL, 0x000fe20000000000ULL, 0x0000003665367210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff3f7224ULL, 0x000fe200008e06ffULL, 0x0ffffff837687812ULL, 0x000fe200078ef800ULL,
0x0000000843717824ULL, 0x000fe200078e00ffULL, 0x0000003a093d7210ULL, 0x000fe20007f9e0ffULL,
0x00000008656e7824ULL, 0x000fe200078e00ffULL, 0x0000003c093b7210ULL, 0x000fe20007fbe0ffULL,
0x00000010686f7824ULL, 0x000fe200078e0247ULL, 0x0000006609397210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff6c7224ULL, 0x000fe200020e06ffULL, 0x0000003609377210ULL, 0x000fc40007f3e0ffULL,
0x000000086a097812ULL, 0x000fe200078ee24bULL, 0x000000ffff687224ULL, 0x000fe200010e06ffULL,
0x00000004383e7c11ULL, 0x040fe2000f8640ffULL, 0x000000ffff667224ULL, 0x000fe200008e06ffULL,
0x0000000437367c11ULL, 0x000fe2000f8440ffULL, 0x0000001009347825ULL, 0x000fe200078e0034ULL,
0x00000005383f7c11ULL, 0x000fe400098f443fULL, 0x0000000439387c11ULL, 0x000fe2000f8240ffULL,
0x000000ffff6a7224ULL, 0x000fe200028e06ffULL, 0x000000043b3a7c11ULL, 0x000fe2000f8840ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000346f7faeULL, 0x0003e2000c101c46ULL,
0x0000000537377c11ULL, 0x000fe200090f4466ULL, 0x0000001009327825ULL, 0x000fe200078e0032ULL,
0x0000000539397c11ULL, 0x000fc400088f4468ULL, 0x000000424300720cULL, 0x080fe20003f06070ULL,
0x0000000841687824ULL, 0x040fe200078e00ffULL, 0x0000000043667210ULL, 0x000fe20007ffe0ffULL,
0x0000000141437824ULL, 0x000fe200078e0200ULL, 0x000000043d3c7c11ULL, 0x000fe2000f8640ffULL,
0x0000001009307825ULL, 0x000fe200078e0030ULL, 0x000000053b3b7c11ULL, 0x000fe4000a0f446aULL,
0x000000424100720cULL, 0x080fe20003f26070ULL, 0x000000016d417824ULL, 0x000fe200078e0200ULL,
0x000000053d3d7c11ULL, 0x000fe200098f446cULL, 0x000000086d6a7824ULL, 0x040fe200078e00ffULL,
0x000000426d00720cULL, 0x080fe20003f46070ULL, 0x000000016b357824ULL, 0x042fe200078e0200ULL,
0x000000426b00720cULL, 0x080fe20003f66070ULL, 0x00000008676c7824ULL, 0x000fe200078e00ffULL,
0x000000426900720cULL, 0x080fe20003f86070ULL, 0x00000010093e7825ULL, 0x000fe200078e003eULL,
0x000000426700720cULL, 0x000fc40003fa6070ULL, 0x000000426500720cULL, 0x000fe20003fc6070ULL,
0x00000010093c7825ULL, 0x000fe200078e003cULL, 0xfffffff868347812ULL, 0x000fe400078ee243ULL,
0xfffffff86a427812ULL, 0x000fe200078ee241ULL, 0x000000086b687824ULL, 0x000fe200078e00ffULL,
0xfffffff871667812ULL, 0x000fe200078ee266ULL, 0x00000008696a7824ULL, 0x000fe200078e00ffULL,
0x0000000069417210ULL, 0x000fe20007ffe0ffULL, 0x0000000167437824ULL, 0x100fe200078e0200ULL,
0xfffffff868687812ULL, 0x000fe200078ee235ULL, 0x0000000165677824ULL, 0x000fe200078e0200ULL,
0xfffffff86a6a7812ULL, 0x000fe200078ee241ULL, 0x0000001066357824ULL, 0x100fe200078e0247ULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee243ULL, 0x0000001034417824ULL, 0x100fe200078e0247ULL,
0xfffffff86e6e7812ULL, 0x000fe200078ee267ULL, 0x0000001068657824ULL, 0x100fe200078e0247ULL,
0x0000004742437211ULL, 0x000fe200078e20ffULL, 0x000000106a677824ULL, 0x000fe200078e0247ULL,
0x0000000032357faeULL, 0x0003e2000c101c46ULL, 0x00000010093a7825ULL, 0x000fc600078e003aULL,
0x0000000030417faeULL, 0x0003e2000c901c46ULL, 0x000000106c697824ULL, 0x000fe400078e0247ULL,
0x0000001009387825ULL, 0x040fe200078e0038ULL, 0x000000003e437faeULL, 0x0003e6000d101c46ULL,
0x000000106e477824ULL, 0x000fe200078e0247ULL, 0x000000003c657faeULL, 0x0003e2000d901c46ULL,
0x0000001009367825ULL, 0x000fc600078e0036ULL, 0x000000003a677faeULL, 0x0003e8000e101c46ULL,
0x0000000038697faeULL, 0x0003e8000e901c46ULL, 0x0000000036477faeULL, 0x0003e2000f101c46ULL,
0x0000000400a47947ULL, 0x000fea0003800000ULL, 0x000020005b307824ULL, 0x000fe200078e00ffULL,
0x0000000400357811ULL, 0x040fe200078fe8ffULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x0000000800377811ULL, 0x000fe200078fe8ffULL, 0x00000008076e7824ULL, 0x000fe200078e00ffULL,
0x0000200030307812ULL, 0x000fe200078ec0ffULL, 0x0000000135317824ULL, 0x040fe200078e0200ULL,
0x0000000c00397811ULL, 0x040fe200078fe8ffULL, 0x0000000835327824ULL, 0x000fe200078e00ffULL,
0x0000006667307210ULL, 0x000fe20007ffe030ULL, 0x0000000837347824ULL, 0x000fe200078e00ffULL,
0x00000014003d7811ULL, 0x040fe200078fe8ffULL, 0x0000000139477824ULL, 0x140fe200078e0200ULL,
0xfffffff832667812ULL, 0x000fe200078ee231ULL, 0x0000000839387824ULL, 0x000fe200078e00ffULL,
0x0000003600327211ULL, 0x040fe200078fe8ffULL, 0x000000013d427824ULL, 0x040fe200078e0200ULL,
0x0000000037437210ULL, 0x000fe20007ffe0ffULL, 0x000000083d3f7824ULL, 0x040fe200078e00ffULL,
0x0000003209327210ULL, 0x000fe20007f1e0ffULL, 0x000000013d687824ULL, 0x000fe200078e0236ULL,
0x00000010003b7811ULL, 0x000fc400078fe8ffULL, 0x0000001800417811ULL, 0x000fe200078fe8ffULL,
0x000000ffff337224ULL, 0x000fe200000e06ffULL, 0x00000004323e7c11ULL, 0x000fe2000f8040ffULL,
0x000000013b657824ULL, 0x040fe200078e0200ULL, 0xfffffff834437812ULL, 0x000fe200078ee243ULL,
0x000000083b347824ULL, 0x000fe200078e00ffULL, 0xfffffff838477812ULL, 0x000fe200078ee247ULL,
0x0000000841387824ULL, 0x000fe200078e00ffULL, 0xfffffff83f427812ULL, 0x000fe200078ee242ULL,
0x000000013b3a7824ULL, 0x000fe200078e0236ULL, 0x0000000041317210ULL, 0x000fc40007ffe0ffULL,
0x00000005323f7c11ULL, 0x000fe200080f4433ULL, 0x0000000135327824ULL, 0x100fe200078e0236ULL,
0xfffffff834657812ULL, 0x000fe200078ee265ULL, 0x0000000137347824ULL, 0x100fe200078e0236ULL,
0xfffffff838317812ULL, 0x000fe200078ee231ULL, 0x0000000139387824ULL, 0x000fe200078e0236ULL,
0x0000003209357210ULL, 0x000fe40007f7e0ffULL, 0x0000003409377210ULL, 0x000fe40007f5e0ffULL,
0x0000001c00697811ULL, 0x000fc400078fe8ffULL, 0x0000003809347210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff387224ULL, 0x000fe200018e06ffULL, 0x00000004353c7c11ULL, 0x000fe2000f8c40ffULL,
0x000000ffff6c7224ULL, 0x000fe200010e06ffULL, 0x00000036416a7210ULL, 0x000fe20007ffe0ffULL,
0x0000000169367824ULL, 0x000fe200078e0236ULL, 0x0000003a09327210ULL, 0x000fe40007f3e0ffULL,
0x00000005353d7c11ULL, 0x000fe2000b0f4438ULL, 0x000000ffff357224ULL, 0x000fe200000e06ffULL,
0x0000000434387c11ULL, 0x000fc4000f8040ffULL, 0x0000006809337210ULL, 0x000fe20007f7e0ffULL,
0x0000000169687824ULL, 0x040fe200078e0200ULL, 0x0000006a096a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000869697824ULL, 0x000fe200078e00ffULL, 0x0000003609677210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x00000004373a7c11ULL, 0x000fe4000f8440ffULL,
0x0000000432367c11ULL, 0x000fe4000f8240ffULL, 0x0000000534397c11ULL, 0x000fc400080f4435ULL,
0x0000000000357211ULL, 0x000fe400078fe8ffULL, 0x00000005373b7c11ULL, 0x000fe400090f446cULL,
0xfffffff869687812ULL, 0x000fe400078ee268ULL, 0x0000000532377c11ULL, 0x000fe200088f4409ULL,
0x000000ffff097224ULL, 0x000fe200020e06ffULL, 0x000000ffff6c7210ULL, 0x000fe40001ffe4ffULL,
0x0000000433347c11ULL, 0x000fc4000f8040ffULL, 0x0000000735697812ULL, 0x000fe400078ec0ffULL,
0x000000046a327c11ULL, 0x040fe4000f8240ffULL, 0x0000000533357c11ULL, 0x000fe200080f446cULL,
0x00013000306c7836ULL, 0x000fe20000000000ULL, 0x000000086e417812ULL, 0x000fe400078ee24bULL,
0x0ffffff869697812ULL, 0x000fe200078ef800ULL, 0x00000010316d7824ULL, 0x100fe200078e026cULL,
0x000000056a337c11ULL, 0x000fe200088f4409ULL, 0x000000ffff6a7224ULL, 0x000fe200028e06ffULL,
0x0000000467307c11ULL, 0x000fe2000f8040ffULL, 0x0000001069697824ULL, 0x000fe200078e026cULL,
0x0000006c47477211ULL, 0x000fe200078e20ffULL, 0x00000010413e7825ULL, 0x000fe200078e003eULL,
0x0000000567317c11ULL, 0x000fc600080f446aULL, 0x0000001066097824ULL, 0x000fe200078e026cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e697faeULL, 0x0003e2000b901c46ULL,
0x00000010413c7825ULL, 0x000fc800078e003cULL, 0x0000001043437824ULL, 0x000fe200078e026cULL,
0x000000003c097faeULL, 0x0003e2000b901c46ULL, 0x00000010413a7825ULL, 0x000fc800078e003aULL,
0x0000001041387825ULL, 0x000fe200078e0038ULL, 0x000000003a437faeULL, 0x0003e6000b901c46ULL,
0x0000001065657824ULL, 0x000fe200078e026cULL, 0x0000000038477faeULL, 0x0003e2000b901c46ULL,
0x0000001041367825ULL, 0x000fc800078e0036ULL, 0x00000010426b7824ULL, 0x000fe200078e026cULL,
0x0000000036657faeULL, 0x0003e2000b901c46ULL, 0x0000001041347825ULL, 0x000fc800078e0034ULL,
0x0000001041327825ULL, 0x040fe200078e0032ULL, 0x00000000346b7faeULL, 0x0003e6000b901c46ULL,
0x00000010686f7824ULL, 0x000fe200078e026cULL, 0x00000000326d7faeULL, 0x0003e2000b901c46ULL,
0x0000001041307825ULL, 0x000fca00078e0030ULL, 0x00000000306f7faeULL, 0x0003e4000b901c46ULL,
0x000000030b097812ULL, 0x002fe200078ec0ffULL, 0x00000000000079afULL, 0x000e260000000000ULL,
0x000000030900780cULL, 0x000fe20003f05270ULL, 0xffffffffff097424ULL, 0x000fc600078e00ffULL,
0x000000010d307807ULL, 0x000fca0004000000ULL, 0x000000010b0b7824ULL, 0x000fca00078e0230ULL,
0x000000580b00720cULL, 0x000fda0003f06070ULL, 0x00008c00ff308b82ULL, 0x000e620000000a00ULL,
0x0000000105338824ULL, 0x000fc800078e020bULL, 0x0000000433308825ULL, 0x002fca00078e0030ULL,
0x0000000630098981ULL, 0x000322000c1e1900ULL, 0x01b64840634079a7ULL, 0x0002a4000850003fULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0xffffffe045317812ULL, 0x042fe400078ec0ffULL,
0x0000001045307812ULL, 0x040fe400078ec0ffULL, 0x0000000845677812ULL, 0x000fe400078ec0ffULL,
0x0000000a30307210ULL, 0x000fc80007ffe031ULL, 0x0000006730677210ULL, 0x000fc80007ffe0ffULL,
0x01b64841670075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff347224ULL, 0x000fce00078e00ffULL, 0x000000103400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fce0000015200ULL,
0x0000003032357210ULL, 0x000fca0007f1e1ffULL, 0x0000000131317824ULL, 0x000fe200000e0e33ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff307819ULL, 0x000fc80000011431ULL, 0x0000003530307211ULL, 0x000fca00078110ffULL,
0x000000ffff317224ULL, 0x000fca00000e0631ULL, 0x0000000230307819ULL, 0x000fc80000001231ULL,
0x000000300000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000134347836ULL, 0x000fce0000000000ULL, 0x01b64841670075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000001004f317810ULL, 0x000fe20007ffe04dULL,
0x000000ffff697224ULL, 0x000fc800078e0064ULL, 0x000000014c317824ULL, 0x000fca00078e0231ULL,
0x01b0000031337984ULL, 0x000e680000000800ULL, 0x01b2000031657984ULL, 0x0004a20000000800ULL,
0x000000643300720bULL, 0x002fda0003f1d000ULL, 0x0000000000327806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff32ff7812ULL, 0x000fda000782c0ffULL,
0x0000000000f89947ULL, 0x004fea0003800000ULL, 0x0000000246307836ULL, 0x000fe20000000000ULL,
0x000000643300720bULL, 0x000fc80003f14000ULL, 0x0000005b3000720cULL, 0x000fd20003f25270ULL,
0x0000000000357806ULL, 0x000fc800000e0100ULL, 0x0000000a5b319211ULL, 0x000fe400078e38ffULL,
0x0000003364309209ULL, 0x000fe40007810000ULL, 0x000000314c379210ULL, 0x000fe40007ffe04fULL,
0x0000991035317816ULL, 0x000fc600000000ffULL, 0x01b4003037009388ULL, 0x0003e20000000800ULL,
0x000000ff3100720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000003364317209ULL, 0x040fe40007810000ULL, 0x000000ff35ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0035ff7812ULL, 0x000fe2000782c0ffULL, 0x8000003164307221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b30307820ULL, 0x000fc80000410000ULL, 0x0000003000317308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff307819ULL, 0x002fcc0000011600ULL,
0x00001f3031307589ULL, 0x004e6400000e0000ULL, 0x0000003010107220ULL, 0x082fe20000410000ULL,
0x0000003011117220ULL, 0x080fe20000410000ULL, 0x0000003014147220ULL, 0x080fe20000410000ULL,
0x0000003015157220ULL, 0x080fe20000410000ULL, 0x0000003018187220ULL, 0x080fe20000410000ULL,
0x0000003019197220ULL, 0x080fe20000410000ULL, 0x000000301c1c7220ULL, 0x080fe20000410000ULL,
0x000000301d1d7220ULL, 0x080fe20000410000ULL, 0x0000003020207220ULL, 0x080fe20000410000ULL,
0x0000003021217220ULL, 0x080fe20000410000ULL, 0x0000003024247220ULL, 0x080fe20000410000ULL,
0x0000003025257220ULL, 0x080fe20000410000ULL, 0x0000003028287220ULL, 0x080fe20000410000ULL,
0x0000003029297220ULL, 0x080fe20000410000ULL, 0x000000302c2c7220ULL, 0x080fe20000410000ULL,
0x000000302d2d7220ULL, 0x000fce0000410000ULL, 0x0000003108087220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x0000000800307811ULL, 0x002fcc00078ff0ffULL,
0x00001f3031307589ULL, 0x000e6400000e0000ULL, 0x0000003012127220ULL, 0x082fe20000410000ULL,
0x0000003013137220ULL, 0x080fe20000410000ULL, 0x0000003016167220ULL, 0x080fe20000410000ULL,
0x0000003017177220ULL, 0x080fe20000410000ULL, 0x000000301a1a7220ULL, 0x080fe20000410000ULL,
0x000000301b1b7220ULL, 0x080fe20000410000ULL, 0x000000301e1e7220ULL, 0x080fe20000410000ULL,
0x000000301f1f7220ULL, 0x080fe20000410000ULL, 0x0000003022227220ULL, 0x080fe20000410000ULL,
0x0000003023237220ULL, 0x080fe20000410000ULL, 0x0000003026267220ULL, 0x080fe20000410000ULL,
0x0000003027277220ULL, 0x080fe20000410000ULL, 0x000000302a2a7220ULL, 0x080fe20000410000ULL,
0x000000302b2b7220ULL, 0x080fe20000410000ULL, 0x000000302e2e7220ULL, 0x080fe20000410000ULL,
0x000000302f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff35ff7812ULL, 0x000fe40007800832ULL,
0x0000003364697209ULL, 0x000fd60007810000ULL, 0x8000006933330221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b33330820ULL, 0x000fc80000410000ULL, 0x0000003300040308ULL, 0x000ea40000000800ULL,
0x0000000465650220ULL, 0x004fce0000410000ULL, 0x00000001ff477819ULL, 0x000fe2000001165bULL,
0x0000100006637824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000400047667824ULL, 0x000fe200078e020aULL, 0x0000100063637812ULL, 0x000fc600078ec0ffULL,
0x0000200007307824ULL, 0x002fca00078e0266ULL, 0x00013000306b7810ULL, 0x000fe20007ffe063ULL,
0x0000000000188947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe40000011600ULL,
0x00000004ff02723eULL, 0x000fc600000000ffULL, 0x0000000803317836ULL, 0x000fe20000000000ULL,
0x0000541002307816ULL, 0x000fca0000000002ULL, 0x00001f0330037589ULL, 0x0002a800000e0000ULL,
0x00001f3130027589ULL, 0x0002e400000e0000ULL, 0x012000004a30783bULL, 0x0022e20000000200ULL,
0x0000001062407824ULL, 0x100fe400078e026bULL, 0x00000010613c7824ULL, 0x100fe400078e026bULL,
0x0000001060387824ULL, 0x000fe200078e026bULL, 0x0000000000108947ULL, 0x000fec0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000231317232ULL, 0x080fe40000000000ULL, 0x0000000233337232ULL, 0x000fce0000000000ULL,
0x0000006b5e347211ULL, 0x000fe200078e20ffULL, 0x000000004040783bULL, 0x000f680000004200ULL,
0x000000003c3c783bULL, 0x000f680000004200ULL, 0x000000003838783bULL, 0x000f680000004200ULL,
0x000000003434783bULL, 0x000f640000004200ULL, 0x000000403010723cULL, 0x02afec0000001810ULL,
0x000000423014723cULL, 0x000fe20000001814ULL, 0x0000001055407824ULL, 0x000fca00078e026bULL,
0x0000003c3018723cULL, 0x000fec0000001818ULL, 0x0000003e301c723cULL, 0x000fe2000000181cULL,
0x00000010543c7824ULL, 0x000fca00078e026bULL, 0x000000383020723cULL, 0x004fec0000001820ULL,
0x0000003a3024723cULL, 0x000fe20000001824ULL, 0x0000001053387824ULL, 0x000fca00078e026bULL,
0x000000343028723cULL, 0x000fec0000001828ULL, 0x00000036302c723cULL, 0x000fe2000000182cULL,
0x012000004830783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000108947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000231317232ULL, 0x080fe40000000000ULL,
0x0000000233337232ULL, 0x000fce0000000000ULL, 0x0000001050347824ULL, 0x000fe200078e026bULL,
0x000000004040783bULL, 0x000ee20000004200ULL, 0x0000000865087221ULL, 0x000fe20000010000ULL,
0x0000000106657812ULL, 0x000fe200078e0cffULL, 0x000000ffff647224ULL, 0x000fe200078e0069ULL,
0x000000003c3c783bULL, 0x000f680000004200ULL, 0x000000003838783bULL, 0x000f680000004200ULL,
0x000000003434783bULL, 0x000f620000004200ULL, 0x000000403010723cULL, 0x00cfec0000001810ULL,
0x000000423014723cULL, 0x000fe20000001814ULL, 0x00000001ff407424ULL, 0x000fc800078e00ffULL,
0x01b6984049ff79a7ULL, 0x0005e2000850003fULL, 0x0000003c3018723cULL, 0x022fec0000001818ULL,
0x0000003e301c723cULL, 0x000fec000000181cULL, 0x000000383020723cULL, 0x000fec0000001820ULL,
0x0000003a3024723cULL, 0x000fec0000001824ULL, 0x000000343028723cULL, 0x000fec0000001828ULL,
0x00000036302c723cULL, 0x000fee000000182cULL, 0x000000c059317811ULL, 0x000fc800078e40ffULL,
0x0000005a3100720cULL, 0x000fda0003f06070ULL, 0x00000018001c0947ULL, 0x004fea0003800000ULL,
0x000000010c317824ULL, 0x000fe200078e0259ULL, 0x0000840000047ab9ULL, 0x000fe40000000800ULL,
0x0000000409327c24ULL, 0x010fe4000f8e02ffULL, 0x0000000131097810ULL, 0x000fe20007ffe0ffULL,
0x0000010031307824ULL, 0x000fc600078e0244ULL, 0x0000000e0900720cULL, 0x000fe20003f06070ULL,
0x0000004032097824ULL, 0x000fe200078e00ffULL, 0x000000200f377812ULL, 0x000fe200078ef830ULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000000400d88947ULL, 0x000fea0003800000ULL,
0x00000003ff607819ULL, 0x000fe20000011600ULL, 0x0000000807327824ULL, 0x000fe200078e00ffULL,
0x000000305a417248ULL, 0x000fe20007fe0000ULL, 0x000000ffff307224ULL, 0x000fe200078e0a30ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000860427836ULL, 0x000fe20000000000ULL,
0x00000008324b7812ULL, 0x000fe200078ee24bULL, 0x0000000460437836ULL, 0x000fe20000000000ULL,
0x0000002041417446ULL, 0x000fe20003800030ULL, 0x0000000142347824ULL, 0x100fe200078e0237ULL,
0x0000003760307210ULL, 0x000fe20007ffe0ffULL, 0x000020005b317824ULL, 0x000fe200078e00ffULL,
0x00000010605e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000143327824ULL, 0x000fe200078e0237ULL,
0x0000003409337210ULL, 0x000fe20007f5e0ffULL, 0x0000000c60627836ULL, 0x000fe20000000000ULL,
0x0000200031397812ULL, 0x000fe200078ec0ffULL, 0x0000001460547836ULL, 0x000fe20000000000ULL,
0x0000003209317210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff367224ULL, 0x000fe200010e06ffULL,
0x0000000433327c11ULL, 0x040fe2000f8440ffULL, 0x0000001860507836ULL, 0x000fe20000000000ULL,
0x0000003009357210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff387224ULL, 0x000fe200008e06ffULL,
0x0000000533337c11ULL, 0x000fe200090f4436ULL, 0x0000000160367824ULL, 0x000fe200078e0200ULL,
0x0000006663537210ULL, 0x000fe20007ffe039ULL, 0x000000ffff3a7224ULL, 0x000fe200000e06ffULL,
0x0000000435347c11ULL, 0x000fe2000f8040ffULL, 0x00000001503c7824ULL, 0x100fe200078e0237ULL,
0x0000000736397812ULL, 0x000fe200078ec0ffULL, 0x0000000162367824ULL, 0x100fe200078e0237ULL,
0x0000000431307c11ULL, 0x000fe2000f8240ffULL, 0x0001300053537836ULL, 0x000fe20000000000ULL,
0x0000000535357c11ULL, 0x000fe200080f443aULL, 0x00000001543a7824ULL, 0x100fe200078e0237ULL,
0x000000416000720cULL, 0x000fe20003f06070ULL, 0x0000001c60607836ULL, 0x000fe20000000000ULL,
0x0000000531317c11ULL, 0x000fe200088f4438ULL, 0x000000015e387824ULL, 0x000fe200078e0237ULL,
0x0000003609367210ULL, 0x000fe20007f3e0ffULL, 0x000000104b347825ULL, 0x000fe200078e0034ULL,
0x0000003760647210ULL, 0x000fc40007ffe0ffULL, 0x0ffffff839667812ULL, 0x000fe200078ef800ULL,
0x000000ffff3d7224ULL, 0x000fe200008e06ffULL, 0x00000038093b7210ULL, 0x000fe20007f9e0ffULL,
0x0000000162617824ULL, 0x000fe200078e0200ULL, 0x00000004363e7c11ULL, 0x000fe2000f8640ffULL,
0x0000001066557824ULL, 0x000fe200078e0253ULL, 0x0000003a09397210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff6a7224ULL, 0x000fe200020e06ffULL, 0x0000003c09377210ULL, 0x000fe20007f5e0ffULL,
0x000000104b307825ULL, 0x000fe200078e0030ULL, 0x0000006409647210ULL, 0x000fe20007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000034557faeULL, 0x0003e2000c101c46ULL,
0x00000005363f7c11ULL, 0x000fe200098f443dULL, 0x000000ffff687224ULL, 0x000fe200028e06ffULL,
0x000000043b3c7c11ULL, 0x000fe2000f8640ffULL, 0x000000ffff667224ULL, 0x000fe200010e06ffULL,
0x00000004393a7c11ULL, 0x000fe2000f8840ffULL, 0x000000ffff097224ULL, 0x000fe200008e06ffULL,
0x0000000437387c11ULL, 0x000fe2000f8240ffULL, 0x000000104b327825ULL, 0x000fe200078e0032ULL,
0x0000000464367c11ULL, 0x000fc4000f8440ffULL, 0x000000053b3d7c11ULL, 0x000fe200098f446aULL,
0x000000104b3e7825ULL, 0x000fe200078e003eULL, 0x00000005393b7c11ULL, 0x000fe4000a0f4468ULL,
0x0000000537397c11ULL, 0x000fe200088f4466ULL, 0x000000104b3c7825ULL, 0x000fe200078e003cULL,
0x0000000564377c11ULL, 0x000fe400090f4409ULL, 0x000000414300720cULL, 0x0c0fe20003f06070ULL,
0x0000000843647824ULL, 0x000fe200078e00ffULL, 0x0000000043097210ULL, 0x000fe20007ffe0ffULL,
0x0000000142437824ULL, 0x140fe200078e0200ULL, 0x000000414200720cULL, 0x0c0fe20003f26070ULL,
0x0000000842427824ULL, 0x000fe200078e00ffULL, 0xfffffff864347812ULL, 0x002fe200078ee209ULL,
0x000000015e097824ULL, 0x000fe200078e0200ULL, 0x000000416200720cULL, 0x0c0fe20003f46070ULL,
0x0000000862627824ULL, 0x000fe200078e00ffULL, 0x000000415e00720cULL, 0x0c0fe20003f66070ULL,
0x000000085e5e7824ULL, 0x000fe200078e00ffULL, 0x000000415400720cULL, 0x080fe20003f86070ULL,
0x0000000850647824ULL, 0x000fe200078e00ffULL, 0x0000000054357210ULL, 0x000fe20007ffe0ffULL,
0x0000000854547824ULL, 0x000fe200078e00ffULL, 0x000000415000720cULL, 0x080fe20003fa6070ULL,
0x000000104b3a7825ULL, 0x000fe200078e003aULL, 0x000000416000720cULL, 0x000fc40003fc6070ULL,
0xfffffff842427812ULL, 0x000fe200078ee243ULL, 0x0000000150417824ULL, 0x100fe200078e0200ULL,
0xfffffff862627812ULL, 0x000fe200078ee261ULL, 0x0000000160437824ULL, 0x040fe200078e0200ULL,
0xfffffff85e507812ULL, 0x000fe200078ee209ULL, 0x0000000860607824ULL, 0x000fe200078e00ffULL,
0xfffffff854547812ULL, 0x000fe200078ee235ULL, 0x0000001034097824ULL, 0x100fe200078e0253ULL,
0xfffffff8645e7812ULL, 0x000fe200078ee241ULL, 0x0000001042357824ULL, 0x100fe200078e0253ULL,
0xfffffff860607812ULL, 0x000fe200078ee243ULL, 0x0000001050437824ULL, 0x100fe200078e0253ULL,
0x0000005362417211ULL, 0x000fe200078e20ffULL, 0x0000001054557824ULL, 0x100fe200078e0253ULL,
0x0000000030097faeULL, 0x0003e2000c101c46ULL, 0x000000105e617824ULL, 0x000fc400078e0253ULL,
0x000000104b387825ULL, 0x040fe200078e0038ULL, 0x0000000032357faeULL, 0x0003e6000c901c46ULL,
0x0000001060537824ULL, 0x000fe200078e0253ULL, 0x000000003e417faeULL, 0x0003e2000d101c46ULL,
0x000000104b367825ULL, 0x000fc600078e0036ULL, 0x000000003c437faeULL, 0x0003e8000d901c46ULL,
0x000000003a557faeULL, 0x0003e8000e101c46ULL, 0x0000000038617faeULL, 0x0003e8000e901c46ULL,
0x0000000036537faeULL, 0x0003e2000f101c46ULL, 0x0000000400a47947ULL, 0x000fea0003800000ULL,
0x000020005b307824ULL, 0x000fe200078e00ffULL, 0x0000000400317811ULL, 0x040fe200078fe8ffULL,
0x0000000807327824ULL, 0x000fe200078e00ffULL, 0x0000000800347811ULL, 0x000fe200078fe8ffULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000200030307812ULL, 0x000fe200078ec0ffULL,
0x0000000131537824ULL, 0x100fe200078e0200ULL, 0x00000008324b7812ULL, 0x000fe200078ee24bULL,
0x0000000134437824ULL, 0x040fe200078e0200ULL, 0x0000006663637210ULL, 0x000fe20007ffe030ULL,
0x0000000834327824ULL, 0x000fe200078e00ffULL, 0x0000000331307819ULL, 0x000fc400000006ffULL,
0x0000000c00367811ULL, 0x040fe400078fe8ffULL, 0xfffffff830537812ULL, 0x000fe400078ee253ULL,
0x0000003700307211ULL, 0x000fe200078fe8ffULL, 0x0000000136427824ULL, 0x140fe200078e0200ULL,
0xfffffff832437812ULL, 0x000fe200078ee243ULL, 0x0000000836337824ULL, 0x000fe200078e00ffULL,
0x0000001000387811ULL, 0x000fe400078fe8ffULL, 0x0000003009327210ULL, 0x000fe20007f1e0ffULL,
0x0000000131307824ULL, 0x000fe200078e0237ULL, 0xfffffff833427812ULL, 0x000fe200078ee242ULL,
0x0000000138417824ULL, 0x000fe200078e0200ULL, 0x0000001400397811ULL, 0x000fe200078fe8ffULL,
0x00000008383a7824ULL, 0x000fe200078e00ffULL, 0x0000003009307210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff357224ULL, 0x000fe200000e06ffULL, 0x00000004323e7c11ULL, 0x000fe2000f8040ffULL,
0x00000008393b7824ULL, 0x000fe200078e00ffULL, 0xfffffff83a417812ULL, 0x000fe200078ee241ULL,
0x000000ffff337224ULL, 0x000fe200008e06ffULL, 0x00000018003a7811ULL, 0x000fc400078fe8ffULL,
0x00000004303c7c11ULL, 0x000fe4000f8240ffULL, 0x00000005323f7c11ULL, 0x000fe200080f4435ULL,
0x0000000136327824ULL, 0x000fe200078e0237ULL, 0x00000005303d7c11ULL, 0x000fe200088f4433ULL,
0x000000013a317824ULL, 0x140fe200078e0200ULL, 0x0000000039507210ULL, 0x000fe20007ffe0ffULL,
0x000000083a547824ULL, 0x000fe200078e00ffULL, 0x0000001c00337811ULL, 0x000fe200078fe8ffULL,
0x0000000134307824ULL, 0x100fe200078e0237ULL, 0x0000003738347210ULL, 0x000fe20007ffe0ffULL,
0x0000000139367824ULL, 0x100fe200078e0237ULL, 0x0000003209397210ULL, 0x000fe20007fbe0ffULL,
0x000000013a387824ULL, 0x100fe200078e0237ULL, 0xfffffff83b507812ULL, 0x000fe200078ee250ULL,
0x00000001333b7824ULL, 0x040fe200078e0200ULL, 0xfffffff854317812ULL, 0x000fe200078ee231ULL,
0x0000000133547824ULL, 0x040fe200078e0237ULL, 0x0000003409377210ULL, 0x000fe20007f5e0ffULL,
0x00000008335e7824ULL, 0x000fe200078e00ffULL, 0x0000003009337210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff347224ULL, 0x000fe200028e06ffULL, 0x00000004393a7c11ULL, 0x000fe2000f8a40ffULL,
0x000000104b3e7825ULL, 0x000fe200078e003eULL, 0x0000003609357210ULL, 0x000fc40007f1e0ffULL,
0xfffffff85e6b7812ULL, 0x000fe200078ee23bULL, 0x000000ffff367224ULL, 0x000fe200018e06ffULL,
0x0000003809307210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff5e7224ULL, 0x000fe200000e06ffULL,
0x0000000433327c11ULL, 0x000fe2000f8840ffULL, 0x000000104b3c7825ULL, 0x000fe200078e003cULL,
0x00000005393b7c11ULL, 0x000fe4000a8f4434ULL, 0x0000000000397211ULL, 0x000fe400078fe8ffULL,
0x000000ffff607210ULL, 0x000fe200017fe4ffULL, 0x000000104b3a7825ULL, 0x000fe200078e003aULL,
0x0000005409547210ULL, 0x000fc40007f7e0ffULL, 0x0000000533337c11ULL, 0x000fe2000a0f4436ULL,
0x000000ffff097224ULL, 0x000fe200008e06ffULL, 0x0000000437387c11ULL, 0x000fe4000f8440ffULL,
0x0000000435367c11ULL, 0x000fe2000f8040ffULL, 0x000000104b327825ULL, 0x000fe200078e0032ULL,
0x0000000739557812ULL, 0x000fe400078ec0ffULL, 0x0000000430347c11ULL, 0x000fe4000f8240ffULL,
0x0000000537397c11ULL, 0x000fc400090f4460ULL, 0x0000000535377c11ULL, 0x000fe200080f445eULL,
0x00013000635e7836ULL, 0x000fe20000000000ULL, 0x0ffffff855557812ULL, 0x000fe200078ef800ULL,
0x000000104b387825ULL, 0x000fe200078e0038ULL, 0x0000000530357c11ULL, 0x000fe400088f4409ULL,
0x0000000454307c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff097224ULL, 0x000fe200018e06ffULL,
0x0000005e42617211ULL, 0x000fe200078e20ffULL, 0x0000001055557824ULL, 0x100fe400078e025eULL,
0x0000001053537824ULL, 0x000fc400078e025eULL, 0x0000001031657824ULL, 0x100fe200078e025eULL,
0x0000000554317c11ULL, 0x000fe200080f4409ULL, 0x0000001043437824ULL, 0x100fe200078e025eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000003e557faeULL, 0x0003e2000b901c46ULL,
0x0000001041417824ULL, 0x100fe400078e025eULL, 0x0000001050637824ULL, 0x000fe200078e025eULL,
0x000000003c537faeULL, 0x0003e2000b901c46ULL, 0x000000104b367825ULL, 0x000fc600078e0036ULL,
0x0000000032437faeULL, 0x0003e2000b901c46ULL, 0x000000104b347825ULL, 0x000fc600078e0034ULL,
0x000000003a617faeULL, 0x0003e2000b901c46ULL, 0x000000106b6b7824ULL, 0x000fe400078e025eULL,
0x000000104b307825ULL, 0x000fe200078e0030ULL, 0x0000000038417faeULL, 0x0003e8000b901c46ULL,
0x0000000036637faeULL, 0x0003e8000b901c46ULL, 0x0000000034657faeULL, 0x0003e8000b901c46ULL,
0x00000000306b7faeULL, 0x0003e4000b901c46ULL, 0x000000030b097812ULL, 0x002fe200078ec0ffULL,
0x00000000000079afULL, 0x000e260000000000ULL, 0x000000030900780cULL, 0x000fe20003f05270ULL,
0xffffffffff097424ULL, 0x000fc600078e00ffULL, 0x000000010d307807ULL, 0x000fca0004000000ULL,
0x000000010b0b7824ULL, 0x000fca00078e0230ULL, 0x000000580b00720cULL, 0x000fda0003f06070ULL,
0x00008c00ff308b82ULL, 0x000e620000000a00ULL, 0x0000000105338824ULL, 0x000fc800078e020bULL,
0x0000000433308825ULL, 0x002fca00078e0030ULL, 0x0000000630098981ULL, 0x000322000c1e1900ULL,
0x01b66840674079a7ULL, 0x0002a4000850003fULL, 0x0000000000307805ULL, 0x002fce0000015200ULL,
0x01b66841670075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ff00347202ULL, 0x000fce0000000f00ULL, 0x000000103400780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fce0000015200ULL,
0x0000003230357210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003532327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000134347836ULL, 0x000fce0000000000ULL, 0x01b66841670075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000001804f4d7810ULL, 0x000fe20007ffe04dULL,
0x000000ffff647224ULL, 0x000fc800078e0069ULL, 0x000000014c4d7824ULL, 0x000fca00078e024dULL,
0x01b000004d307984ULL, 0x000e680000000800ULL, 0x01b200004d4b7984ULL, 0x0004a20000000800ULL,
0x000000693000720bULL, 0x002fda0003f1d000ULL, 0x0000000000337806ULL, 0x000fe400000e0100ULL,
0x000000000000781cULL, 0x000fe40003f0e170ULL, 0x0000ffff33ff7812ULL, 0x000fda000782c0ffULL,
0x0000000000f09947ULL, 0x004fea0003800000ULL, 0x0000000346327836ULL, 0x000fe20000000000ULL,
0x000000693000720bULL, 0x0c0fe40003f14000ULL, 0x0000006930647209ULL, 0x000fe40007810000ULL,
0x0000005b3200720cULL, 0x000fd20003f25270ULL, 0x0000000000327806ULL, 0x000fc800000e0100ULL,
0x000000805b319824ULL, 0x000fca00078e020aULL, 0x000000314c4f9210ULL, 0x000fe40007ffe04fULL,
0x0000991032317816ULL, 0x000fc600000000ffULL, 0x01b400644f009388ULL, 0x0003e20000000800ULL,
0x000000ff3100720cULL, 0x000fda0003f05270ULL, 0x0000000000b08947ULL, 0x002fea0003800000ULL,
0x0000006964317221ULL, 0x000fe20000010100ULL, 0x000000ff32ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0032ff7812ULL, 0x000fe2000782c0ffULL, 0x3fb8aa3b31317820ULL, 0x000fc80000410000ULL,
0x0000003100357308ULL, 0x0002ac0000000800ULL, 0x0000000000488947ULL, 0x000fea0003800000ULL,
0x00000002ff347819ULL, 0x000fca0000011600ULL, 0x00001f3435317589ULL, 0x006e6400000e0000ULL,
0x0000003110107220ULL, 0x082fe20000410000ULL, 0x0000003111117220ULL, 0x080fe20000410000ULL,
0x0000003114147220ULL, 0x080fe20000410000ULL, 0x0000003115157220ULL, 0x080fe20000410000ULL,
0x0000003118187220ULL, 0x080fe20000410000ULL, 0x0000003119197220ULL, 0x080fe20000410000ULL,
0x000000311c1c7220ULL, 0x080fe20000410000ULL, 0x000000311d1d7220ULL, 0x080fe20000410000ULL,
0x0000003120207220ULL, 0x080fe20000410000ULL, 0x0000003121217220ULL, 0x080fe20000410000ULL,
0x0000003124247220ULL, 0x080fe20000410000ULL, 0x0000003125257220ULL, 0x080fe20000410000ULL,
0x0000003128287220ULL, 0x080fe20000410000ULL, 0x0000003129297220ULL, 0x080fe20000410000ULL,
0x000000312c2c7220ULL, 0x080fe20000410000ULL, 0x000000312d2d7220ULL, 0x000fce0000410000ULL,
0x0000003508087220ULL, 0x004fe20000410000ULL, 0x0000000000489947ULL, 0x000fec0003800000ULL,
0x0000000800347811ULL, 0x000fca00078ff0ffULL, 0x00001f3435317589ULL, 0x002e6400000e0000ULL,
0x0000003112127220ULL, 0x082fe20000410000ULL, 0x0000003113137220ULL, 0x080fe20000410000ULL,
0x0000003116167220ULL, 0x080fe20000410000ULL, 0x0000003117177220ULL, 0x080fe20000410000ULL,
0x000000311a1a7220ULL, 0x080fe20000410000ULL, 0x000000311b1b7220ULL, 0x080fe20000410000ULL,
0x000000311e1e7220ULL, 0x080fe20000410000ULL, 0x000000311f1f7220ULL, 0x080fe20000410000ULL,
0x0000003122227220ULL, 0x080fe20000410000ULL, 0x0000003123237220ULL, 0x080fe20000410000ULL,
0x0000003126267220ULL, 0x080fe20000410000ULL, 0x0000003127277220ULL, 0x080fe20000410000ULL,
0x000000312a2a7220ULL, 0x080fe20000410000ULL, 0x000000312b2b7220ULL, 0x080fe20000410000ULL,
0x000000312e2e7220ULL, 0x080fe20000410000ULL, 0x000000312f2f7220ULL, 0x000fce0000410000ULL,
0x0000ffff32ff7812ULL, 0x000fda0007800833ULL, 0x0000003064300221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b30300820ULL, 0x000fc80000410000ULL, 0x0000003000040308ULL, 0x000ea40000000800ULL,
0x000000044b4b0220ULL, 0x004fce0000410000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000000188947ULL, 0x000fea0003800000ULL, 0x00000002ff037819ULL, 0x000fe40000011600ULL,
0x00000004ff02723eULL, 0x000fe400000000ffULL, 0x0000000803317810ULL, 0x002fe40007ffe0ffULL,
0x0000541002307816ULL, 0x000fca0000000002ULL, 0x00001f0330037589ULL, 0x0002a800000e0000ULL,
0x00001f3130027589ULL, 0x0002e400000e0000ULL, 0x012800004a30783bULL, 0x0022e20000000200ULL,
0x0000000000108947ULL, 0x000fea0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000231317232ULL, 0x080fe40000000000ULL,
0x0000000233337232ULL, 0x000fce0000000000ULL, 0x000000005f40783bULL, 0x000f680000004200ULL,
0x000000005d3c783bULL, 0x000f680000004200ULL, 0x000000005c38783bULL, 0x000f680000004200ULL,
0x000000005734783bULL, 0x000f640000004200ULL, 0x000000403010723cULL, 0x02afec0000001810ULL,
0x000000423014723cULL, 0x000fec0000001814ULL, 0x0000003c3018723cULL, 0x000fec0000001818ULL,
0x0000003e301c723cULL, 0x000fec000000181cULL, 0x000000383020723cULL, 0x004fec0000001820ULL,
0x0000003a3024723cULL, 0x000fec0000001824ULL, 0x000000343028723cULL, 0x000fec0000001828ULL,
0x00000036302c723cULL, 0x000fe2000000182cULL, 0x012800004830783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000108947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000231317232ULL, 0x080fe40000000000ULL, 0x0000000233337232ULL, 0x000fce0000000000ULL,
0x000000004e34783bULL, 0x000ee20000004200ULL, 0x000000084b087221ULL, 0x000fe20000010000ULL,
0x0000000106657812ULL, 0x000fe400078ec0ffULL, 0x000000005640783bULL, 0x000f680000004200ULL,
0x00000000523c783bULL, 0x000f680000004200ULL, 0x000000005138783bULL, 0x000f620000004200ULL,
0x000000343028723cULL, 0x00cfec0000001828ULL, 0x000000403010723cULL, 0x022fe20000001810ULL,
0x00000001ff347424ULL, 0x000fc800078e00ffULL, 0x01b6a03449ff79a7ULL, 0x0003e2000850003fULL,
0x000000423014723cULL, 0x000fec0000001814ULL, 0x0000003c3018723cULL, 0x000fec0000001818ULL,
0x0000003e301c723cULL, 0x000fec000000181cULL, 0x000000383020723cULL, 0x000fec0000001820ULL,
0x0000003a3024723cULL, 0x000fec0000001824ULL, 0x00000036302c723cULL, 0x002fde000000182cULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000010c597824ULL, 0x000fca00078e0259ULL,
0x0000000e5900720cULL, 0x000fda0003f06070ULL, 0xffffff9400608947ULL, 0x000fea000383ffffULL,
0x0000000000037919ULL, 0x000e620000002500ULL, 0x000000ffff337224ULL, 0x000fe200078e0028ULL,
0x0000002600317202ULL, 0x000fe20000000f00ULL, 0x000000ffff307224ULL, 0x000fe400078e002dULL,
0x000000ffff287224ULL, 0x000fe400078e0027ULL, 0x000000ffff267224ULL, 0x000fe200078e0025ULL,
0x0000001e00257202ULL, 0x000fe20000000f00ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0024ULL,
0x000000ffff277224ULL, 0x000fc400078e0020ULL, 0x000000ffff357224ULL, 0x000fe400078e002cULL,
0x000000ffff247224ULL, 0x000fe400078e0023ULL, 0x000000ffff207224ULL, 0x000fe400078e001fULL,
0x000000ffff2c7224ULL, 0x000fe400078e0029ULL, 0x000000ffff1e7224ULL, 0x000fe400078e001dULL,
0x000000ffff237224ULL, 0x000fc400078e001cULL, 0x000000ffff1f7224ULL, 0x000fe400078e001aULL,
0x000000ffff297224ULL, 0x000fe400078e0022ULL, 0x000000ffff1c7224ULL, 0x000fe200078e001bULL,
0x00000016001b7202ULL, 0x000fe20000000f00ULL, 0x000000ffff1a7224ULL, 0x000fe200078e0019ULL,
0x0000000e0300720cULL, 0x002fe20003f06070ULL, 0x000000ffff1d7224ULL, 0x000fe400078e0018ULL,
0x000000ffff227224ULL, 0x000fc400078e0021ULL, 0x000000ffff0e7224ULL, 0x000fe400078e0017ULL,
0x000000ffff187224ULL, 0x000fe400078e0013ULL, 0x000000ffff197224ULL, 0x000fc800078e0012ULL,
0x0000000000c80947ULL, 0x000fea0003800000ULL, 0x0180000008007836ULL, 0x000fca0000000000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x000085d000047802ULL, 0x000fce0000000f00ULL,
0x000000a800e47944ULL, 0x010fea0003c00000ULL, 0x000000ffff007224ULL, 0x00cfe200078e0002ULL,
0x0000000000107947ULL, 0x000fec0003800000ULL, 0x0000000800057308ULL, 0x000e640000001000ULL,
0xbf80000005007423ULL, 0x002fc80000000008ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000005007223ULL, 0x000fce0000000005ULL, 0x0000000000047919ULL, 0x000ea40000000000ULL,
0x00000002ff057819ULL, 0x004fe40000011604ULL, 0x0000000804097811ULL, 0x010fe200078ff0ffULL,
0x0000000000007948ULL, 0x000fea0003800000ULL, 0x00001f0500027589ULL, 0x000ea800000e0000ULL,
0x00001f0900047589ULL, 0x000ee200000e0000ULL, 0x0000001002107220ULL, 0x044fe20000410000ULL,
0x0000001102117220ULL, 0x040fe20000410000ULL, 0x0000001402147220ULL, 0x040fe20000410000ULL,
0x0000001502157220ULL, 0x040fe20000410000ULL, 0x0000001d021d7220ULL, 0x040fe20000410000ULL,
0x0000001a021a7220ULL, 0x040fe20000410000ULL, 0x0000002302237220ULL, 0x040fe20000410000ULL,
0x0000001e021e7220ULL, 0x040fe20000410000ULL, 0x0000002702277220ULL, 0x040fe20000410000ULL,
0x0000002202227220ULL, 0x040fe20000410000ULL, 0x0000002d022d7220ULL, 0x040fe20000410000ULL,
0x0000002602267220ULL, 0x040fe20000410000ULL, 0x0000003302337220ULL, 0x040fe20000410000ULL,
0x0000002c022c7220ULL, 0x040fe20000410000ULL, 0x0000003502357220ULL, 0x040fe20000410000ULL,
0x0000003002307220ULL, 0x000fe20000410000ULL, 0x0000001904197220ULL, 0x048fe20000410000ULL,
0x0000001804187220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000000e040e7220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002a042a7220ULL, 0x040fe20000410000ULL,
0x0000002b042b7220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x000fce0000410000ULL, 0x00000000000d7919ULL, 0x000ea20000000000ULL,
0x000000101110723eULL, 0x000fe400000000ffULL, 0x000000141511723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000231e13723eULL, 0x000fc400000000ffULL,
0x000000191818723eULL, 0x000fe400000000ffULL, 0x000000272214723eULL, 0x000fe400000000ffULL,
0x0000002d2615723eULL, 0x000fe400000000ffULL, 0x000000332c16723eULL, 0x000fe400000000ffULL,
0x000000353017723eULL, 0x000fe400000000ffULL, 0x0000001b0e19723eULL, 0x000fc400000000ffULL,
0x00000025201b723eULL, 0x000fe400000000ffULL, 0x0000002a2b1e723eULL, 0x000fe400000000ffULL,
0x000000010c00780cULL, 0x000fe40003f05270ULL, 0x00000003ff027819ULL, 0x104fe2000001160dULL,
0x0000000144237824ULL, 0x000fe200078e020dULL, 0xfffffff8ff057812ULL, 0x000fe400078ee20dULL,
0x0000000302007812ULL, 0x000fc600078ec0ffULL, 0x0000000805097836ULL, 0x010fe40000000000ULL,
0x0000000805127824ULL, 0x040fe400078e00ffULL, 0x00000008050b7824ULL, 0x000fe200078e00ffULL,
0x0000000500057210ULL, 0x000fe20007ffe0ffULL, 0x0000000100047824ULL, 0x000fe400078e0209ULL,
0x00000008090f7824ULL, 0x000fe400078e00ffULL, 0x0000000405007836ULL, 0x000fc40000000000ULL,
0x0000000809217824ULL, 0x000fe200078e00ffULL, 0xfffffff812097812ULL, 0x000fe200078ee205ULL,
0x0000000c05067836ULL, 0x000fe20000000000ULL, 0xfffffff80b0b7812ULL, 0x000fe200078ee200ULL,
0x0000100007007824ULL, 0x000fe200078e020aULL, 0xfffffff80f0f7812ULL, 0x000fe200078ee204ULL,
0x0000080047057824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee206ULL,
0x0000001023047824ULL, 0x000fe200078e0200ULL, 0x0000001d1a12723eULL, 0x000fe400000000ffULL,
0x0000000500067210ULL, 0x000fc40007ffe0ffULL, 0x0000001f1c1a723eULL, 0x000fe400000000ffULL,
0x00000029241c723eULL, 0x000fe200000000ffULL, 0x0000001009097824ULL, 0x100fe200078e0206ULL,
0x00000031281d723eULL, 0x000fe200000000ffULL, 0x000000100b0b7824ULL, 0x100fe200078e0206ULL,
0x0000002e2f1f723eULL, 0x000fe200000000ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0206ULL,
0x0000001009007844ULL, 0x000fe20000000200ULL, 0x0000001021217824ULL, 0x000fc600078e0206ULL,
0x000000140b007844ULL, 0x000fe80000000200ULL, 0x000000180f007844ULL, 0x000fe80000000200ULL,
0x0000001c21007844ULL, 0x000fe20000000200ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000004247984ULL, 0x000ea80000000c00ULL, 0x00040000042c7984ULL, 0x000ee80000000c00ULL,
0x0008000004287984ULL, 0x000f280000000c00ULL, 0x000c000004307984ULL, 0x000f620000000c00ULL,
0x200000ff27277230ULL, 0x004fc40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fe40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x200000ff2f2f7230ULL, 0x008fe40000000000ULL, 0x200000ff2e2e7230ULL, 0x000fe40000000000ULL,
0x200000ff2d2d7230ULL, 0x000fc40000000000ULL, 0x200000ff2c2c7230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x012fe40000000000ULL, 0x0000002a26267230ULL, 0x000fe40000000000ULL,
0x0000002925257230ULL, 0x000fe40000000000ULL, 0x0000002824247230ULL, 0x000fe40000000000ULL,
0x000000332f2f7230ULL, 0x020fc40000000000ULL, 0x000000322e2e7230ULL, 0x000fe20000000000ULL,
0x0000002404007388ULL, 0x0003e20000000c00ULL, 0x000000312d2d7230ULL, 0x000fe40000000000ULL,
0x000000302c2c7230ULL, 0x000fca0000000000ULL, 0x0004002c04007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002400988947ULL, 0x000fea0003800000ULL,
0x00009200ff097b82ULL, 0x000ea20000000800ULL, 0x00000000001b7919ULL, 0x000ee20000002700ULL,
0x0000000000167919ULL, 0x000eec0000002600ULL, 0x00008400ff187b82ULL, 0x000ea20000000800ULL,
0x0000000004107984ULL, 0x00092e0000000c00ULL, 0x00009600ff0a7b82ULL, 0x000f620000000a00ULL,
0x0000000918097224ULL, 0x004fc800078e02ffULL, 0x0000000c09147224ULL, 0x040fe200078e02ffULL,
0x0000000f090e7811ULL, 0x000fe200078e10ffULL, 0x000000181b1b7224ULL, 0x008fc600078e0216ULL,
0xfffffff00e097812ULL, 0x000fe200078ec0ffULL, 0x0000000c1b1c7224ULL, 0x000fc800078e02ffULL,
0x00000080141f7824ULL, 0x000fe400078e0209ULL, 0x000000011c037824ULL, 0x000fc600078e0203ULL,
0x0000001f14147211ULL, 0x000fca00078e38ffULL, 0x0000007f140f7836ULL, 0x000fca0000000000ULL,
0xffffff800f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000a0f147210ULL, 0x020fc80007f1e0ffULL,
0x0000001403147211ULL, 0x000fe200078258ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e060bULL,
0x0000000147ff7812ULL, 0x000fc8000780f85bULL, 0x0000000e03157211ULL, 0x000fe400008f5cffULL,
0x0000000a091d7210ULL, 0x000fe20007f3e0ffULL, 0x0000040007147825ULL, 0x000fc800078e0014ULL,
0x000000ffff217224ULL, 0x000fe400008e060bULL, 0x0000001023147825ULL, 0x000fe200078e0014ULL,
0x0000000000400947ULL, 0x012fec0003800000ULL, 0x000000100d0e7824ULL, 0x000fe200078e00ffULL,
0x00000001ff167819ULL, 0x000fe2000001160dULL, 0x0000008003047824ULL, 0x000fc600078e00ffULL,
0x000000700e197812ULL, 0x000fe400078ec0ffULL, 0x0000000a04187210ULL, 0x000fe40007ebe01fULL,
0x00000019ff0e7819ULL, 0x000fe40000011603ULL, 0x0000000c16177812ULL, 0x000fe400078ec0ffULL,
0x0000001d19047210ULL, 0x000fe40007a3e004ULL, 0x0000000b0e037210ULL, 0x000fc40002fec4ffULL,
0x0000000417167210ULL, 0x000fe40007fbe0ffULL, 0x00000021ff0e7210ULL, 0x000fe40000fe440eULL,
0x0000001817187210ULL, 0x000fc60007c7e019ULL, 0x000000ffff177224ULL, 0x000fe200028e060eULL,
0x00000003ff197210ULL, 0x000fc80001fe84ffULL, 0x0000006416007986ULL, 0x0003e8000c101906ULL,
0x0000000818007986ULL, 0x0003e4000c101906ULL, 0x000000ff0d00720cULL, 0x000fe20000705670ULL,
0x0000001014007986ULL, 0x0005e2000c101d06ULL, 0x0000000000007b1dULL, 0x000ff60000000000ULL,
0x0000000000700947ULL, 0x000fea0003800000ULL, 0x00009600ff107b82ULL, 0x004ea20000000a00ULL,
0xffffffff0c037810ULL, 0x000fe20007ffe0ffULL, 0x000000041b107825ULL, 0x004fe200078e0010ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000003101079a8ULL, 0x00052200099ee1c6ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000000007992ULL, 0x000fec000000a000ULL,
0x00000000000079abULL, 0x000fc00000000000ULL, 0x00000000000075abULL, 0x000fec0000000000ULL,
0x00000000ff00798fULL, 0x000fe20002000000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000031000720cULL, 0x010fc80003f05270ULL,
0x00000001ff037807ULL, 0x004fe20000000000ULL, 0x0000065405047896ULL, 0x008fd20008000004ULL,
0x00000003ff007988ULL, 0x0005e60008000004ULL, 0x0000000000037919ULL, 0x004ea20000008800ULL,
0x00000400001e7802ULL, 0x000fe20000000f00ULL, 0x0000000000007948ULL, 0x000fea0003800000ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000654031e7816ULL, 0x004fca000000001eULL,
0x000000001e037984ULL, 0x000ea40000000000ULL, 0x000000ff0300720cULL, 0x004fda0003f05270ULL,
0x00000020004c8947ULL, 0x000fea0003800000ULL, 0x000000ff5b00720cULL, 0x000fda0003f05270ULL,
0x0000000800940947ULL, 0x000fea0003800000ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x00000000006c8947ULL, 0x000fea0003800000ULL, 0x000000100d037824ULL, 0x000fe200078e00ffULL,
0x00000001ff047819ULL, 0x000fe4000001160dULL, 0x0000001d1c027211ULL, 0x000fe400078038ffULL,
0x0000007003117812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fe400078ec0ffULL,
0x000000211c037211ULL, 0x000fe400000f3cffULL, 0x0000000204027210ULL, 0x000fc8000791e011ULL,
0x00000003ff037210ULL, 0x000fca00007e24ffULL, 0x0000000602087981ULL, 0x002328000c1e1900ULL,
0x0000800602117981ULL, 0x000322000c1e1900ULL, 0x000000020c00780cULL, 0x000fda0003f05270ULL,
0x00000000003c8947ULL, 0x002fea0003800000ULL, 0x0001000602137981ULL, 0x000322000c1e1900ULL,
0x000000040c00780cULL, 0x000fda0003f06070ULL, 0x0000000000308947ULL, 0x002fea0003800000ULL,
0x0001800602157981ULL, 0x000322000c1e1900ULL, 0x000000040c00780cULL, 0x000fda0003f05270ULL,
0x0000000000248947ULL, 0x002fea0003800000ULL, 0x0002000602177981ULL, 0x000322000c1e1900ULL,
0x000000060c00780cULL, 0x000fda0003f06070ULL, 0x0000000000188947ULL, 0x002fea0003800000ULL,
0x0002800602197981ULL, 0x000322000c1e1900ULL, 0x000000060c00780cULL, 0x000fda0003f05270ULL,
0x00000000000c8947ULL, 0x002fea0003800000ULL, 0x000000080c00780cULL, 0x000fe20003f06070ULL,
0x00030006021b7981ULL, 0x000318000c1e1900ULL, 0x00038006021d0981ULL, 0x000324000c1e1900ULL,
0x000000070c027836ULL, 0x002fca0000000000ULL, 0x00000003ff047819ULL, 0x000fc80000011602ULL,
0x000000ff0400720cULL, 0x000fda0003f05270ULL, 0x0000000400f48947ULL, 0x000fea0003800000ULL,
0x000000091c037211ULL, 0x040fe200078038ffULL, 0x000000ffff217224ULL, 0x010fe200078e0008ULL,
0x0000003f00047c82ULL, 0x000fe20008000000ULL, 0x0000003f00057c82ULL, 0x000fe20008000000ULL,
0x0000000a030a7210ULL, 0x000fe40007f3e0ffULL, 0x000000ff1c027211ULL, 0x000fe400000f3cffULL,
0x000007800a237810ULL, 0x000fc80007f5e0ffULL, 0x00000002ff0b7210ULL, 0x000fd200017e240bULL,
0x000000040c007c0cULL, 0x000fe2000bf23070ULL, 0x0000000105057890ULL, 0x000fcc000fffe03fULL,
0x0000000504007c0cULL, 0x000fcc000bf03070ULL, 0x0000000400b41947ULL, 0x012fee0003800000ULL,
0x0000000804087890ULL, 0x000fe2000fffe03fULL, 0x0000002108087209ULL, 0x000fca0007810000ULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000100d027824ULL, 0x000fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc8000001160dULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000223027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e060bULL,
0xfffc800602217981ULL, 0x000326000c1e1900ULL, 0x0000000104087890ULL, 0x000fcc000fffe03fULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000004007c1947ULL, 0x000fea0003800000ULL,
0x0000000904087890ULL, 0x000fe2000fffe03fULL, 0x0000001108087209ULL, 0x000fca0007810000ULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000100d027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc8000001160dULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000223027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e060bULL,
0xfffd000602117981ULL, 0x000326000c1e1900ULL, 0x0000000204087890ULL, 0x000fcc000fffe03fULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x0000000400441947ULL, 0x000fea0003800000ULL,
0x0000000a04087890ULL, 0x000fe2000fffe03fULL, 0x0000001308087209ULL, 0x000fca0007810000ULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000040d027819ULL, 0x002fe400000006ffULL, 0x00000001ff037819ULL, 0x000fe4000001160dULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000223027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e060bULL,
0xfffd800602137981ULL, 0x000326000c1e1900ULL, 0x0000000304087890ULL, 0x000fcc000fffe03fULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000004000c1947ULL, 0x000fea0003800000ULL,
0x0000000b04087890ULL, 0x000fe2000fffe03fULL, 0x0000001508087209ULL, 0x000fca0007810000ULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000100d027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc8000001160dULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000223027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e060bULL,
0xfffe000602157981ULL, 0x000326000c1e1900ULL, 0x0000000404087890ULL, 0x000fcc000fffe03fULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x0000000000d41947ULL, 0x000fea0003800000ULL,
0x0000000c04087890ULL, 0x000fe2000fffe03fULL, 0x0000001708087209ULL, 0x000fca0007810000ULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000100d027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc8000001160dULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000223027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e060bULL,
0xfffe800602177981ULL, 0x000326000c1e1900ULL, 0x0000000504087890ULL, 0x000fcc000fffe03fULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000009c1947ULL, 0x000fea0003800000ULL,
0x0000000d04087890ULL, 0x000fe2000fffe03fULL, 0x0000001908087209ULL, 0x000fca0007810000ULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000100d027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc8000001160dULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000223027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e060bULL,
0xffff000602197981ULL, 0x000326000c1e1900ULL, 0x0000000604087890ULL, 0x000fcc000fffe03fULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x0000000000641947ULL, 0x000fea0003800000ULL,
0x0000000e04087890ULL, 0x000fe2000fffe03fULL, 0x0000001b08087209ULL, 0x000fca0007810000ULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000040d027819ULL, 0x002fe400000006ffULL, 0x00000001ff037819ULL, 0x000fe4000001160dULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000223027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e060bULL,
0xffff8006021b7981ULL, 0x000326000c1e1900ULL, 0x0000000704087890ULL, 0x000fcc000fffe03fULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000002c1947ULL, 0x000fea0003800000ULL,
0x0000000f04087890ULL, 0x000fe2000fffe03fULL, 0x0000001d08087209ULL, 0x000fca0007810000ULL,
0x000000080c007c0cULL, 0x000fda000bf23070ULL, 0x00000000001c1947ULL, 0x000fea0003800000ULL,
0x000000100d027824ULL, 0x002fe200078e00ffULL, 0x00000001ff037819ULL, 0x000fc8000001160dULL,
0x0000007002027812ULL, 0x000fc800078ec0ffULL, 0x0000000c02027812ULL, 0x000fc800078ef803ULL,
0x0000000223027210ULL, 0x000fca0007f3e0ffULL, 0x000000ffff037224ULL, 0x000fca00008e060bULL,
0x00000006021d7981ULL, 0x000326000c1e1900ULL, 0x0000040023237810ULL, 0x000fe20007f3e0ffULL,
0x0000000804047890ULL, 0x000fc8000fffe03fULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0xfffffff8002c8947ULL, 0x000fee000383ffffULL, 0x00000000000d7919ULL, 0x000ea40000000000ULL,
0x000000100d027824ULL, 0x006fe200078e00ffULL, 0x00000001ff047819ULL, 0x000fc8000001160dULL,
0x0000007002037812ULL, 0x000fe400078ec0ffULL, 0x0000000c04047812ULL, 0x000fc800078ec0ffULL,
0x0000001e04037210ULL, 0x000fca0007ffe003ULL, 0x0000000803007388ULL, 0x0103e40000000800ULL,
0x00009600ff247b82ULL, 0x000ea20000000a00ULL, 0x000000070d00780cULL, 0x000fe20003f04070ULL,
0x000004005b1d7824ULL, 0x000fe200078e00ffULL, 0x0000000147047812ULL, 0x000fe200078ec0ffULL,
0x000000100d237824ULL, 0x000fe200078e00ffULL, 0x00000001ff227819ULL, 0x000fe2000001160dULL,
0x000000ffff277224ULL, 0x000fe200078e00ffULL, 0x000004001d1d7812ULL, 0x000fe400078ee2ffULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x0000007023237812ULL, 0x000fc400078ec0ffULL,
0x0000000000367805ULL, 0x000fe4000001ff00ULL, 0x0000000c22227812ULL, 0x000fe400078ec0ffULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000020047088824ULL, 0x142fe200078e021eULL, 0x0000001e22267210ULL, 0x080fe20007ffe023ULL,
0x00000200470e8824ULL, 0x000fe200078e021eULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000010007118824ULL, 0x000fe200078e0208ULL, 0x000000240f027210ULL, 0x004fe20007f3e0ffULL,
0x00000001470f7824ULL, 0x000fe200078e021cULL, 0x0000002409207210ULL, 0x000fe20007f7e0ffULL,
0x0000010007138824ULL, 0x000fe200078e020eULL, 0x00000025ff037210ULL, 0x000fe20000ffe4ffULL,
0x0000008004108824ULL, 0x040fe200078e0211ULL, 0x000000241f1f7210ULL, 0x000fe20007f3e0ffULL,
0x0000008004128824ULL, 0x000fe200078e0213ULL, 0x0000001e47047211ULL, 0x000fe200078e68ffULL,
0x000008000f0a7825ULL, 0x000fe200078e0002ULL, 0x000000100d138211ULL, 0x000fe200078e20ffULL,
0x0000000026267984ULL, 0x000e620000000800ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000100007217824ULL, 0x000fe200078e0204ULL, 0x0000001d0a087210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff247224ULL, 0x100fe200008e0625ULL, 0x00000800050a7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff257224ULL, 0x000fe200018e0625ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff097224ULL, 0x000fe200010e060bULL, 0x000000200f0e8211ULL, 0x000fe200078438ffULL,
0x0000000121047824ULL, 0x000fe200078e020aULL, 0x0000001f0f0a8211ULL, 0x000fe200078238ffULL,
0x000000200d057836ULL, 0x000fe20000000000ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x000000100d117824ULL, 0x000fe200078e0204ULL, 0x000000240f0b8211ULL, 0x000fe200008f3cffULL,
0x0000001005047825ULL, 0x000fe200078e0008ULL, 0x0000000c4700720cULL, 0x000fc40003f26070ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x000000250f0f8211ULL, 0x000fe200010f3cffULL,
0x000000100d087825ULL, 0x040fe200078e0008ULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x000000100d0a8825ULL, 0x000fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0018000008117faeULL, 0x0005e2000b901c46ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x000000100d158824ULL, 0x040fe200078e0212ULL,
0x0038000004117faeULL, 0x0005e2000b901c46ULL, 0x000000100d0e8825ULL, 0x000fe200078e000eULL,
0x0000000000347805ULL, 0x000fe4000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x045800000a138faeULL, 0x0005e2000b901c46ULL, 0x000000ffff457224ULL, 0x000fe400078e00ffULL,
0x000000ffff467224ULL, 0x000fe200078e00ffULL, 0x041800000e158faeULL, 0x0005e8000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000800601947ULL, 0x002fea0003800000ULL,
0x00000003ff047819ULL, 0x104fe2000001160dULL, 0x0000020047527824ULL, 0x000fe200078e021eULL,
0xfffffff8ff057812ULL, 0x000fe200078ee20dULL, 0x000000ffff277224ULL, 0x000fe200078e00ffULL,
0x0000000304047812ULL, 0x000fe200078ec0ffULL, 0x0000010007527824ULL, 0x000fe200078e0252ULL,
0x00000002ff507819ULL, 0x000fe2000001160dULL, 0x0000000805097836ULL, 0x000fe20000000000ULL,
0x00000047004b7202ULL, 0x000fe20000000f00ULL, 0x00000008050b7824ULL, 0x040fe400078e00ffULL,
0x00000008054c7824ULL, 0x000fe200078e00ffULL, 0x0000000504057210ULL, 0x000fe20007ffe0ffULL,
0x00000001044d7824ULL, 0x000fc400078e0209ULL, 0x0000000809047824ULL, 0x040fe200078e00ffULL,
0xfffffff84c4c7812ULL, 0x000fe200078ee205ULL, 0x0000000809087824ULL, 0x000fe400078e00ffULL,
0x00000004054e7836ULL, 0x000fe20000000000ULL, 0xfffffff8044d7812ULL, 0x000fe200078ee24dULL,
0x0000000c054f7836ULL, 0x000fe40000000000ULL, 0x00000008504a7836ULL, 0x000fe20000000000ULL,
0xfffffff80b4e7812ULL, 0x000fe400078ee24eULL, 0xfffffff8084f7812ULL, 0x000fce00078ee24fULL,
0x000000014b097836ULL, 0x000fca0000000000ULL, 0x0000000c0900720cULL, 0x000fda0003f06070ULL,
0x0000000000880947ULL, 0x000fea0003800000ULL, 0x000000070d00780cULL, 0x000fe20003f44070ULL,
0x000000011c117824ULL, 0x000fe200078e0209ULL, 0x00000001090b7812ULL, 0x000fe200078ec0ffULL,
0x000000200d137836ULL, 0x000fe40000000000ULL, 0x0000080011047825ULL, 0x000fc600078e0002ULL,
0x0000001d040e7210ULL, 0x000fe20007f1e0ffULL, 0x0000080009047824ULL, 0x000fc800078e00ffULL,
0x000002004708a824ULL, 0x140fe200078e021eULL, 0x00000005ff0f7210ULL, 0x000fe200007fe4ffULL,
0x000002004712a824ULL, 0x000fe200078e021eULL, 0x00000800040a7812ULL, 0x000fe200078ec0ffULL,
0x000001000752a824ULL, 0x000fe200078e0208ULL, 0x0000001f1108a211ULL, 0x040fe400078038ffULL,
0x000000201104a211ULL, 0x000fe200078238ffULL, 0x000000800b10a824ULL, 0x000fe200078e0252ULL,
0x000000241109a211ULL, 0x000fe200000f3cffULL, 0x00000001210a7824ULL, 0x000fe200078e020aULL,
0x000000251105a211ULL, 0x000fe200008f3cffULL, 0x000001000752a824ULL, 0x000fc400078e0212ULL,
0x000000100d117824ULL, 0x000fe400078e020aULL, 0x000000800b12a824ULL, 0x000fe400078e0252ULL,
0x00000010130a7825ULL, 0x000fe200078e000eULL, 0x000000100d13a211ULL, 0x000fc600078e20ffULL,
0x000000100d0e7825ULL, 0x000fc800078e000eULL, 0x000000100d08a825ULL, 0x040fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x001800000e117faeULL, 0x0003e6000b901c46ULL,
0x000000100d04a825ULL, 0x040fe200078e0004ULL, 0x003800000a117faeULL, 0x0003e6000b901c46ULL,
0x000000100d15a824ULL, 0x000fe200078e0212ULL, 0x045800000813afaeULL, 0x0003e8000b901c46ULL,
0x041800000415afaeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000804b047824ULL, 0x002fca00078e00ffULL, 0x0000008004047812ULL, 0x000fc800078ec0ffULL,
0x0000005223057210ULL, 0x000fe20007ffe004ULL, 0x000008004b047824ULL, 0x000fe400078e00ffULL,
0x000000024b4b7836ULL, 0x000fe40000000000ULL, 0x0000000122057824ULL, 0x000fe200078e0205ULL,
0x0000080004047812ULL, 0x000fe400078ec0ffULL, 0x0000000c4b00720cULL, 0x000fe40003f06070ULL,
0x0000018021047810ULL, 0x000fe20007ffe004ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00418000050f7984ULL, 0x000e620000000800ULL, 0x000000104c087824ULL, 0x100fe200078e0204ULL,
0x000000044f187211ULL, 0x000fe200078e20ffULL, 0x000000104e107824ULL, 0x100fe200078e0204ULL,
0x00458000050e7984ULL, 0x000fe20000000800ULL, 0x000000104d147824ULL, 0x000fc600078e0204ULL,
0x000000000808783bULL, 0x000ea80000000200ULL, 0x000000001010783bULL, 0x000ee80000000200ULL,
0x000000001414783bULL, 0x000f280000000200ULL, 0x000000001818783bULL, 0x000f620000000200ULL,
0x0000000f260f7221ULL, 0x002fc80000010100ULL, 0x3fb8aa3b0f537820ULL, 0x000fe20000410000ULL,
0x20000008ff057230ULL, 0x004fca0000004100ULL, 0x0000005300537308ULL, 0x000e620000000800ULL,
0x30000008ff0f7230ULL, 0x000fe40000004100ULL, 0x20000009ff047230ULL, 0x000fe40000004100ULL,
0x30000009ff087230ULL, 0x000fe40000004100ULL, 0x2000000bff517230ULL, 0x000fe40000004100ULL,
0x30000011ff547230ULL, 0x008fe40000004100ULL, 0x20000013ff557230ULL, 0x000fc40000004100ULL,
0x30000013ff567230ULL, 0x000fe40000004100ULL, 0x0000000e535f7220ULL, 0x002fe20000410000ULL,
0x3000000bff0e7230ULL, 0x000fe40000004100ULL, 0x20000011ff537230ULL, 0x000fe40000004100ULL,
0x000000495f497221ULL, 0x000fe20000010000ULL, 0x00001f505f607589ULL, 0x000e6200000e0000ULL,
0x20000015ff577230ULL, 0x010fe40000004100ULL, 0x30000015ff587230ULL, 0x000fe20000004100ULL,
0x00001f4a5f617589ULL, 0x000ea200000e0000ULL, 0x20000018ff5a7230ULL, 0x020fc40000004100ULL,
0x30000018ff5b7230ULL, 0x000fe40000004100ULL, 0x2000000aff097230ULL, 0x000fe40000004100ULL,
0x20000010ff0b7230ULL, 0x000fe40000004100ULL, 0x20000012ff117230ULL, 0x000fe40000004100ULL,
0x20000014ff137230ULL, 0x000fe40000004100ULL, 0x20000016ff157230ULL, 0x000fc40000004100ULL,
0x20000017ff597230ULL, 0x000fe40000004100ULL, 0x20000019ff187230ULL, 0x000fe40000004100ULL,
0x2000001aff5c7230ULL, 0x000fe40000004100ULL, 0x0000006005487223ULL, 0x082fe20000010048ULL,
0x3000001aff5d7230ULL, 0x000fe40000004100ULL, 0x000000600f467223ULL, 0x000fe20000010046ULL,
0x3000000aff0a7230ULL, 0x000fc40000004100ULL, 0x0000006004457223ULL, 0x080fe20000010045ULL,
0x30000010ff107230ULL, 0x000fe40000004100ULL, 0x0000006008437223ULL, 0x080fe20000010043ULL,
0x30000012ff127230ULL, 0x000fe40000004100ULL, 0x0000006009427223ULL, 0x080fe20000010042ULL,
0x30000014ff147230ULL, 0x000fe40000004100ULL, 0x000000600a417223ULL, 0x000fe20000010041ULL,
0x30000016ff167230ULL, 0x000fc40000004100ULL, 0x0000006051407223ULL, 0x080fe20000010040ULL,
0x30000017ff177230ULL, 0x000fe40000004100ULL, 0x000000600e3f7223ULL, 0x080fe2000001003fULL,
0x30000019ff197230ULL, 0x000fe40000004100ULL, 0x000000600b3e7223ULL, 0x080fe2000001003eULL,
0x2000001bff1a7230ULL, 0x000fe40000004100ULL, 0x00000060103d7223ULL, 0x000fe2000001003dULL,
0x3000001bff5e7230ULL, 0x000fc40000004100ULL, 0x00000060533c7223ULL, 0x080fe2000001003cULL,
0x00000060543b7223ULL, 0x080fe2000001003bULL, 0x00000060113a7223ULL, 0x080fe2000001003aULL,
0x0000006012397223ULL, 0x080fe20000010039ULL, 0x0000006055387223ULL, 0x080fe20000010038ULL,
0x0000006056377223ULL, 0x000fe20000010037ULL, 0x0000006113287223ULL, 0x084fe20000010028ULL,
0x0000006114357223ULL, 0x080fe20000010035ULL, 0x0000006157347223ULL, 0x080fe20000010034ULL,
0x0000006158337223ULL, 0x080fe20000010033ULL, 0x0000006115327223ULL, 0x080fe20000010032ULL,
0x0000006116317223ULL, 0x080fe20000010031ULL, 0x0000006159307223ULL, 0x080fe20000010030ULL,
0x0000006117367223ULL, 0x080fe20000010036ULL, 0x000000615a2f7223ULL, 0x080fe2000001002fULL,
0x000000615b2e7223ULL, 0x080fe2000001002eULL, 0x00000061182d7223ULL, 0x080fe2000001002dULL,
0x00000061192c7223ULL, 0x080fe2000001002cULL, 0x000000615c2b7223ULL, 0x080fe2000001002bULL,
0x000000615d2a7223ULL, 0x080fe2000001002aULL, 0x000000611a297223ULL, 0x080fe20000010029ULL,
0x000000615e277223ULL, 0x000fe20000010027ULL, 0xfffffff400f88947ULL, 0x000fec000383ffffULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x000000ff0700720cULL, 0x000fe20003f05270ULL,
0x0000001002037824ULL, 0x002fe200078e00ffULL, 0x00000001ff047819ULL, 0x004fe20000011602ULL,
0x000049801e027836ULL, 0x000fc60000000000ULL, 0x0000007003097812ULL, 0x000fe400078ec0ffULL,
0x0000000c04087812ULL, 0x000fca00078ec0ffULL, 0x0000000000200947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x00000080471e7824ULL, 0x000fe400078e021eULL,
0x0000001003047824ULL, 0x002fe200078e00ffULL, 0x00000001ff057819ULL, 0x000fc80000011603ULL,
0x0000007004037812ULL, 0x000fe400078ec0ffULL, 0x0000000c05057812ULL, 0x000fc800078ec0ffULL,
0x0000001e051e7210ULL, 0x000fca0007ffe003ULL, 0x004980491e007388ULL, 0x0003e40000000800ULL,
0x0000000208027210ULL, 0x000fe20007ffe009ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000002037984ULL, 0x000ea80000000800ULL, 0x0000800002047984ULL, 0x000ee20000000800ULL,
0x00000003ff037221ULL, 0x004fc80000010000ULL, 0x0000000403037221ULL, 0x008fc80000010000ULL,
0x0180000003047836ULL, 0x000fca0000000000ULL, 0x7f80000004047812ULL, 0x000fe200078ec0ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x01ffffff0400780cULL, 0x000fda0003f04070ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e0003ULL,
0x0000aca000047802ULL, 0x000fce0000000f00ULL, 0x0000008400307944ULL, 0x002fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000000300027308ULL, 0x000ea40000001000ULL,
0xbf80000003047423ULL, 0x004fc80000000002ULL, 0x800000ff04057221ULL, 0x000fc80000010100ULL,
0x0000000502027223ULL, 0x000fce0000000002ULL, 0x00000000000d7919ULL, 0x000f240000000000ULL,
0x00000002ff037819ULL, 0x010fe4000001160dULL, 0x000000080d0f7811ULL, 0x000fe400078ff0ffULL,
0xfffffff8ff187812ULL, 0x000fe200078ee20dULL, 0x0000000000007948ULL, 0x00cfea0003800000ULL,
0x00001f0302037589ULL, 0x000ea200000e0000ULL, 0x00000008181a7810ULL, 0x000fe20007ffe0ffULL,
0x00000008181b7824ULL, 0x000fc400078e00ffULL, 0x00001f0f020f7589ULL, 0x00072200000e0000ULL,
0x00000008181c7824ULL, 0x000fe400078e00ffULL, 0x000000081a1e7824ULL, 0x002fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000003ff027819ULL, 0x008fe2000001160dULL,
0x0000004803087220ULL, 0x044fe20000410000ULL, 0x0000004603057220ULL, 0x040fe20000410000ULL,
0x0000004503097220ULL, 0x040fe20000410000ULL, 0x0000004303047220ULL, 0x040fe20000410000ULL,
0x00000042030a7220ULL, 0x040fe20000410000ULL, 0x0000004103417220ULL, 0x040fe20000410000ULL,
0x00000040030b7220ULL, 0x040fe20000410000ULL, 0x0000003f030c7220ULL, 0x040fe20000410000ULL,
0x0000003e03107220ULL, 0x040fe20000410000ULL, 0x0000003d033d7220ULL, 0x040fe20000410000ULL,
0x0000003c03117220ULL, 0x040fe20000410000ULL, 0x0000003b030e7220ULL, 0x040fe20000410000ULL,
0x0000003a03127220ULL, 0x040fe20000410000ULL, 0x0000003903397220ULL, 0x040fe20000410000ULL,
0x0000003803137220ULL, 0x040fe20000410000ULL, 0x0000003703147220ULL, 0x000fe20000410000ULL,
0x000000280f287220ULL, 0x050fe20000410000ULL, 0x000000350f357220ULL, 0x040fe20000410000ULL,
0x000000340f347220ULL, 0x040fe20000410000ULL, 0x000000330f337220ULL, 0x040fe20000410000ULL,
0x000000320f327220ULL, 0x040fe20000410000ULL, 0x000000310f317220ULL, 0x040fe20000410000ULL,
0x000000300f307220ULL, 0x040fe20000410000ULL, 0x000000360f037220ULL, 0x040fe20000410000ULL,
0x0000002f0f2f7220ULL, 0x040fe20000410000ULL, 0x0000002e0f2e7220ULL, 0x040fe20000410000ULL,
0x0000002d0f2d7220ULL, 0x040fe20000410000ULL, 0x0000002c0f2c7220ULL, 0x040fe20000410000ULL,
0x0000002b0f2b7220ULL, 0x040fe20000410000ULL, 0x0000002a0f2a7220ULL, 0x040fe20000410000ULL,
0x000000290f297220ULL, 0x040fe20000410000ULL, 0x000000270f167220ULL, 0x000fe20000410000ULL,
0x00000003020f7812ULL, 0x000fc400078ec0ffULL, 0x000000080508723eULL, 0x000fe400000000ffULL,
0x000000090409723eULL, 0x000fe200000000ffULL, 0x000000010f187824ULL, 0x000fe200078e0218ULL,
0x0000000a410a723eULL, 0x000fe200000000ffULL, 0x000000010f177824ULL, 0x000fe200078e021aULL,
0x0000000b0c0b723eULL, 0x000fe200000000ffULL, 0x0000000418157836ULL, 0x000fe20000000000ULL,
0x0000000c18197810ULL, 0x000fe20007ffe0ffULL, 0x000000081a1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff81b0f7812ULL, 0x000fc400078ee218ULL, 0xfffffff81e177812ULL, 0x000fe400078ee217ULL,
0xfffffff81c157812ULL, 0x000fe200078ee215ULL, 0x000000100f0f7824ULL, 0x100fe200078e0206ULL,
0xfffffff81a197812ULL, 0x000fe200078ee219ULL, 0x0000001017377824ULL, 0x100fe200078e0206ULL,
0x00000030031b723eULL, 0x000fe200000000ffULL, 0x0000001015367824ULL, 0x100fe200078e0206ULL,
0x000000103d10723eULL, 0x000fe200000000ffULL, 0x0000001019067824ULL, 0x000fe200078e0206ULL,
0x000000110e11723eULL, 0x000fe200000000ffULL, 0x0000000144037824ULL, 0x000fe200078e020dULL,
0x000000123912723eULL, 0x000fe200000000ffULL, 0x000000080f007844ULL, 0x000fe20000000200ULL,
0x000000131413723eULL, 0x000fe200000000ffULL, 0x0000001003037824ULL, 0x000fe200078e0200ULL,
0x000000283518723eULL, 0x000fc400000000ffULL, 0x000000343319723eULL, 0x000fe200000000ffULL,
0x0000001036007844ULL, 0x000fe20000000200ULL, 0x00000032311a723eULL, 0x000fe400000000ffULL,
0x0000002f2e1c723eULL, 0x000fe400000000ffULL, 0x0000002d2c1d723eULL, 0x000fe200000000ffULL,
0x0000001837007844ULL, 0x000fe20000000200ULL, 0x0000002b2a1e723eULL, 0x000fe400000000ffULL,
0x00000029161f723eULL, 0x000fca00000000ffULL, 0x0000001c06007844ULL, 0x000fe20000000200ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000003147984ULL, 0x000e680000000c00ULL,
0x0004000003247984ULL, 0x000ea80000000c00ULL, 0x0008000003207984ULL, 0x000ee80000000c00ULL,
0x000c000003287984ULL, 0x000f220000000c00ULL, 0x200000ff17177230ULL, 0x002fc40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fe40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x004fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fc40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x0000002317177230ULL, 0x008fe40000000000ULL,
0x0000002216167230ULL, 0x000fe40000000000ULL, 0x0000002115157230ULL, 0x000fe40000000000ULL,
0x0000002014147230ULL, 0x000fe40000000000ULL, 0x0000002b27277230ULL, 0x010fc40000000000ULL,
0x0000002a26267230ULL, 0x000fe20000000000ULL, 0x0000001403007388ULL, 0x0003e20000000c00ULL,
0x0000002925257230ULL, 0x000fe40000000000ULL, 0x0000002824247230ULL, 0x000fca0000000000ULL,
0x0004002403007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000ff4700720cULL, 0x000fda0003f05270ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000200d0c7836ULL, 0x000fe20000000000ULL, 0x0000000000067919ULL, 0x000ea20000002600ULL,
0x0000000d02057210ULL, 0x000fe20007ffe0ffULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x00000003ff047819ULL, 0x002fe2000001160cULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000705087812ULL, 0x000fe200078ec0ffULL,
0x00000008070e7824ULL, 0x040fe400078e00ffULL, 0x000000010c037824ULL, 0x000fe200078e0204ULL,
0x0ffffff808097812ULL, 0x000fe200078ef80dULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0xfffffff80e0d7812ULL, 0x000fc400078ee20dULL, 0x0000000703037812ULL, 0x000fe400078ec0ffULL,
0xfffffff807077812ULL, 0x000fe400078ee20cULL, 0x0ffffff803057812ULL, 0x000fe200078ef80cULL,
0x0000001009037824ULL, 0x000fc800078e0200ULL, 0x0000001005057824ULL, 0x000fe200078e0200ULL,
0x0000000003087984ULL, 0x0003220000000c00ULL, 0x00000005040472a4ULL, 0x008fc6000f8e023fULL,
0x0000000005107984ULL, 0x0007620000000c00ULL, 0x00000008060f7824ULL, 0x044fe400078e00ffULL,
0x0000000806157824ULL, 0x000fc600078e00ffULL, 0xfffffff80f027812ULL, 0x000fe400078ee202ULL,
0xfffffff815047812ULL, 0x000fe400078ee204ULL, 0x0000000402067c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000404007c10ULL, 0x000fe2000ff3e0ffULL, 0x0000860000047ab9ULL, 0x000fe40000000a00ULL,
0x000000ffff037224ULL, 0x002fe200000e06ffULL, 0x0000000406027c11ULL, 0x000fc4000f8040ffULL,
0x000000ffff057210ULL, 0x008fe40000ffe4ffULL, 0x0000000400047c11ULL, 0x000fe4000f8240ffULL,
0x0000000506037c11ULL, 0x000fe400080f4403ULL, 0x0000000500057c11ULL, 0x000fe200088f4405ULL,
0x000000100d027825ULL, 0x000fc800078e0002ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000000802007986ULL, 0x010fe8000c101d06ULL, 0x0000001004007986ULL, 0x020fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000004590f7824ULL, 0x000fe400078e025bULL,
0xffffffffff0d7424ULL, 0x000fe400078e00ffULL, 0x00000001ff057424ULL, 0x004fe200078e00ffULL,
0x000000580f00720cULL, 0x000fda0003f06070ULL, 0x00009000ff038b82ULL, 0x000e620000000800ULL,
0x0000000206028824ULL, 0x000fce00078e00ffULL, 0x00008c00ff108b82ULL, 0x000ea20000000a00ULL,
0x0000000302038224ULL, 0x002fc800078e020fULL, 0x0000000403108825ULL, 0x004fe400078e0010ULL,
0x01b600050a0279a7ULL, 0x0002a6000850003fULL, 0x00000006100d8981ULL, 0x000ee2000c1e1900ULL,
0x0000000605047899ULL, 0x000fe2000800063fULL, 0x000000405b087824ULL, 0x000fe200078e00ffULL,
0x00000006120b7819ULL, 0x000fe200000006ffULL, 0x0000000159057836ULL, 0x002fca0000000000ULL,
0x0000000e0500720cULL, 0x000fe20003f06070ULL, 0x000000040d057c24ULL, 0x008fd8000f8e02ffULL,
0x0000000c00ac8947ULL, 0x004fea0003800000ULL, 0x0000010059097824ULL, 0x000fe200078e0208ULL,
0x00000003ff117819ULL, 0x000fe20000011600ULL, 0x00008a0000087ab9ULL, 0x000fe20000000a00ULL,
0x0000007004047812ULL, 0x000fe400078ec0ffULL, 0x000000095a107248ULL, 0x000fe20007fe0000ULL,
0x0000000411077836ULL, 0x000fe40000000000ULL, 0x0000000811137836ULL, 0x000fe40000000000ULL,
0x0000000110097824ULL, 0x000fc400078e0a09ULL, 0x0000000107107824ULL, 0x140fe400078e0200ULL,
0x0000000807157824ULL, 0x040fe200078e00ffULL, 0x000000090700720cULL, 0x080fe20003f86070ULL,
0x0000000c11147836ULL, 0x000fe20000000000ULL, 0x0000000013077210ULL, 0x000fe20007ffe0ffULL,
0x00000008131e7824ULL, 0x040fe200078e00ffULL, 0xfffffff8151c7812ULL, 0x000fe200078ee210ULL,
0x0000004012107824ULL, 0x000fe200078e0211ULL, 0x000000091300720cULL, 0x080fe20003f66070ULL,
0x0000000114137824ULL, 0x140fe200078e0200ULL, 0xfffffff81e1e7812ULL, 0x000fe200078ee207ULL,
0x0000000410127836ULL, 0x000fe20000000000ULL, 0x000000091400720cULL, 0x0c0fe20003f46070ULL,
0x0000000814207824ULL, 0x000fe200078e00ffULL, 0x0000001005187210ULL, 0x000fe20007f3e0ffULL,
0x0000001011077836ULL, 0x000fe20000000000ULL, 0x0000001205127210ULL, 0x000fe20007fbe0ffULL,
0x00000014111d7836ULL, 0x000fe20000000000ULL, 0xfffffff820207812ULL, 0x000fe200078ee213ULL,
0x0000000107147824ULL, 0x140fe200078e0200ULL, 0x0000000307197819ULL, 0x000fe200000006ffULL,
0x000000ffff137224ULL, 0x000fe200028e06ffULL, 0x0000000812157c11ULL, 0x040fe2000f8a40ffULL,
0x000000081d247824ULL, 0x000fe200078e00ffULL, 0x000000090700720cULL, 0x000fe20003f06070ULL,
0x000000ffff077224ULL, 0x000fe200008e06ffULL, 0x0000000912167c11ULL, 0x000fe2000a8f4413ULL,
0x0000000111127824ULL, 0x000fe200078e0200ULL, 0x0000000818177c11ULL, 0x000fc4000f8240ffULL,
0xfffffff819227812ULL, 0x000fe200078ee214ULL, 0x0000000810147836ULL, 0x000fe20000000000ULL,
0x0000000918187c11ULL, 0x000fe200088f4407ULL, 0x000040005b077824ULL, 0x000fe200078e020aULL,
0x0000000712197812ULL, 0x000fe400078ec0ffULL, 0x0000001704127210ULL, 0x000fe20007f3e0ffULL,
0x0000100007077836ULL, 0x000fe20000000000ULL, 0x00000014051a7210ULL, 0x000fe40007fde0ffULL,
0x000000091100720cULL, 0x000fe20003fa6070ULL, 0x000000ffff137224ULL, 0x000fe200008e0618ULL,
0x0ffffff819187812ULL, 0x000fe200078ef800ULL, 0x000000ffff1b7224ULL, 0x000fe200030e06ffULL,
0x0000001504147210ULL, 0x000fc40007f3e0ffULL, 0x000000081a177c11ULL, 0x000fe2000f8c40ffULL,
0x0000001018197824ULL, 0x000fe200078e0207ULL, 0x000000001d1f7210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200008e0616ULL, 0x000000091a1a7c11ULL, 0x000fe2000b0f441bULL,
0x000000101c1b7824ULL, 0x000fe200078e0207ULL, 0x000000091d00720cULL, 0x080fe20003f26070ULL,
0x0000001811187836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012197faeULL, 0x0003e2000e901c46ULL, 0x0000000c10167836ULL, 0x000fe20000000000ULL,
0x0000001c111d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001181c7824ULL, 0x040fe200078e0200ULL,
0x00000000141b7faeULL, 0x0005e2000e101c46ULL, 0x000000091800720cULL, 0x040fe20003f86070ULL,
0x0000000818217824ULL, 0x000fe200078e00ffULL, 0x0000001605187210ULL, 0x000fe20007fde0ffULL,
0x000000081d287824ULL, 0x000fe200078e00ffULL, 0x0000001704167210ULL, 0x000fc40007fbe0ffULL,
0xfffffff824247812ULL, 0x000fe200078ee21fULL, 0x000000ffff197224ULL, 0x002fe200030e06ffULL,
0x0000000818137c11ULL, 0x000fe2000f8c40ffULL, 0x000000ffff177224ULL, 0x000fe200028e061aULL,
0xfffffff821267812ULL, 0x000fe200078ee21cULL, 0x0000001010147836ULL, 0x004fe20000000000ULL,
0x000000071e157211ULL, 0x000fe200078e20ffULL, 0x000000011d1f7824ULL, 0x040fe200078e0200ULL,
0x0000000918187c11ULL, 0x000fe2000b0f4419ULL, 0x0000001020197824ULL, 0x000fe200078e0207ULL,
0x0000001304127210ULL, 0x000fe20007fde0ffULL, 0x0000000016157faeULL, 0x0003e2000d901c46ULL,
0x00000014051c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001410147836ULL, 0x000fe20000000000ULL,
0xfffffff828287812ULL, 0x000fe200078ee21fULL, 0x000000ffff137224ULL, 0x000fe200030e0618ULL,
0x000000091d00720cULL, 0x080fe20003fa6070ULL, 0x0000002011187836ULL, 0x000fe20000000000ULL,
0x00000014051b7210ULL, 0x000fe20007fde0ffULL, 0x000000ffff1f7224ULL, 0x000fe200018e06ffULL,
0x000000081c1d7c11ULL, 0x000fe2000f8640ffULL, 0x0000000012197faeULL, 0x0005e2000d101c46ULL,
0x00000001181a7824ULL, 0x040fe200078e0200ULL, 0x000000091800720cULL, 0x040fe20003f46070ULL,
0x0000001810147836ULL, 0x000fe20000000000ULL, 0x0000000318217819ULL, 0x000fe200000006ffULL,
0x000000ffff187224ULL, 0x000fe200030e06ffULL, 0x000000091c177c11ULL, 0x002fe200098f441fULL,
0x0000002411167836ULL, 0x000fe20000000000ULL, 0x000000081b157c11ULL, 0x000fc4000f8c40ffULL,
0xfffffff8211a7812ULL, 0x000fe200078ee21aULL, 0x00000008161c7824ULL, 0x000fe200078e00ffULL,
0x0000001d04127210ULL, 0x004fe20007f7e0ffULL, 0x0000001022197824ULL, 0x000fe200078e0207ULL,
0x000000091b187c11ULL, 0x000fe2000b0f4418ULL, 0x0000002c111d7836ULL, 0x000fe20000000000ULL,
0x0000001405207210ULL, 0x000fe20007fde0ffULL, 0x000000ffff137224ULL, 0x000fe200018e0617ULL,
0x0000001504147210ULL, 0x000fe20007f7e0ffULL, 0x0000000116177824ULL, 0x040fe200078e0200ULL,
0x000000001d1e7210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200030e06ffULL,
0x00000018ff157210ULL, 0x000fe20001ffe4ffULL, 0x0000000012197faeULL, 0x0003e2000c101c46ULL,
0x000000091600720cULL, 0x000fe20003f66070ULL, 0x0000001c10167836ULL, 0x000fe20000000000ULL,
0x0000000820217c11ULL, 0x000fc4000f8c40ffULL, 0xfffffff81c187812ULL, 0x000fe200078ee217ULL,
0x0000002811177836ULL, 0x000fe20000000000ULL, 0x0000000920207c11ULL, 0x000fe2000b0f441bULL,
0x00000010241b7824ULL, 0x000fe200078e0207ULL, 0x00000016051f7210ULL, 0x000fe20007fde0ffULL,
0x00000001171c7824ULL, 0x040fe200078e0200ULL, 0x0000002104167210ULL, 0x000fe20007f1e0ffULL,
0x0000000817237824ULL, 0x000fe200078e00ffULL, 0x00000000141b7faeULL, 0x0005e2000c901c46ULL,
0x000000ffff127224ULL, 0x002fe200030e06ffULL, 0x000000081f137c11ULL, 0x000fe2000f8c40ffULL,
0x000000081d197824ULL, 0x000fe200078e00ffULL, 0x000000091700720cULL, 0x000fe20003f26070ULL,
0x000000ffff177224ULL, 0x000fe200000e0620ULL, 0xfffffff8231c7812ULL, 0x000fc400078ee21cULL,
0x000000091d00720cULL, 0x000fe40003f06070ULL, 0xfffffff8191e7812ULL, 0x000fe200078ee21eULL,
0x0000001028197824ULL, 0x100fe200078e0207ULL, 0x000000091f1b7c11ULL, 0x004fe2000b0f4412ULL,
0x0000001026157824ULL, 0x000fe200078e0207ULL, 0x0000001304127210ULL, 0x000fe20007fde0ffULL,
0x0000002010147836ULL, 0x000fc60000000000ULL, 0x0000000016157faeULL, 0x0003e2000e101c46ULL,
0x000000ffff137224ULL, 0x000fe200030e061bULL, 0x0000001405207210ULL, 0x000fe20007f9e0ffULL,
0x0000002410147836ULL, 0x000fe20000000000ULL, 0x00000030111b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000012197faeULL, 0x0005e2000e901c46ULL, 0x000000ffff237224ULL, 0x000fe200020e06ffULL,
0x00000014051f7210ULL, 0x000fe20007fde0ffULL, 0x000000011b1d7824ULL, 0x040fe200078e0200ULL,
0x0000000820217c11ULL, 0x040fe2000f8840ffULL, 0x000000081b147824ULL, 0x040fe200078e00ffULL,
0x000000091b00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff167224ULL, 0x002fe200030e06ffULL,
0x0000000920177c11ULL, 0x000fc4000a0f4423ULL, 0xfffffff814207812ULL, 0x000fe200078ee21dULL,
0x0000002810147836ULL, 0x000fe20000000000ULL, 0x000000081f157c11ULL, 0x040fe4000f8c40ffULL,
0x0000002104127210ULL, 0x004fe40007f9e0ffULL, 0x000000091f197c11ULL, 0x000fe2000b0f4416ULL,
0x0000003411167836ULL, 0x000fe20000000000ULL, 0x00000014051b7210ULL, 0x000fe40007fde0ffULL,
0x00000017ff137210ULL, 0x000fe200027fe4ffULL, 0x0000000116177824ULL, 0x040fe200078e0200ULL,
0x0000001504147210ULL, 0x000fe20007f9e0ffULL, 0x0000000816227824ULL, 0x000fc400078e00ffULL,
0x000000ffff247224ULL, 0x000fe200030e06ffULL, 0x000000081b1d7c11ULL, 0x040fe2000f8c40ffULL,
0x000000ffff157224ULL, 0x000fe200020e0619ULL, 0xfffffff822227812ULL, 0x000fe200078ee217ULL,
0x000000101a197824ULL, 0x100fe200078e0207ULL, 0x000000091b177c11ULL, 0x000fe2000b0f4424ULL,
0x00000010181b7824ULL, 0x000fe200078e0207ULL, 0x000000091600720cULL, 0x000fe20003f86070ULL,
0x0000002c10167836ULL, 0x000fe20000000000ULL, 0x0000000012197faeULL, 0x0003e2000d101c46ULL,
0x0000003811187810ULL, 0x000fe20007ffe0ffULL, 0x0000003c111a7836ULL, 0x000fc40000000000ULL,
0x00000000141b7faeULL, 0x0005e2000d901c46ULL, 0x00000016051f7210ULL, 0x000fe20007f7e0ffULL,
0x000000101c117824ULL, 0x000fe200078e0207ULL, 0x0000001d04167210ULL, 0x000fe40007f5e0ffULL,
0x000000081f1d7c11ULL, 0x040fe2000f8c40ffULL, 0x000000ffff247224ULL, 0x000fe200018e06ffULL,
0x000000091800720cULL, 0x080fe20003f66070ULL, 0x000000ffff177224ULL, 0x000fe200010e0617ULL,
0x000000091a00720cULL, 0x000fe20003f46070ULL, 0x0000003010127836ULL, 0x002fe20000000000ULL,
0x000000091f197c11ULL, 0x000fe2000b0f4424ULL, 0x0000000118097824ULL, 0x000fe200078e0200ULL,
0x0000000016117faeULL, 0x0003e2000c901c46ULL, 0x000000081a1b7824ULL, 0x004fe200078e00ffULL,
0x0000001205137210ULL, 0x000fe20007f3e0ffULL, 0x0000000818187824ULL, 0x000fe200078e00ffULL,
0x000000001a007210ULL, 0x000fc40007ffe0ffULL, 0x0000000813157c11ULL, 0x040fe2000f8c40ffULL,
0x000000ffff147224ULL, 0x000fe200008e06ffULL, 0x0000001d04127210ULL, 0x000fe40007f3e0ffULL,
0xfffffff81b1a7812ULL, 0x000fe200078ee200ULL, 0x0000003410007836ULL, 0x000fe20000000000ULL,
0x0000000913167c11ULL, 0x002fe2000b0f4414ULL, 0x0000003810147836ULL, 0x000fe20000000000ULL,
0xfffffff818187812ULL, 0x000fe200078ee209ULL, 0x000000ffff137224ULL, 0x000fe200008e0619ULL,
0x0000000005117210ULL, 0x000fe20007f3e0ffULL, 0x0000003c10107836ULL, 0x000fe20000000000ULL,
0x0000000720177211ULL, 0x000fe200078e20ffULL, 0x000000101e097824ULL, 0x000fc400078e0207ULL,
0x00000010181b7824ULL, 0x100fe200078e0207ULL, 0x0000001005007210ULL, 0x000fe20007fde0ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x00000008111d7c11ULL, 0x040fe2000f8240ffULL,
0x0000000012097faeULL, 0x0003e2000c101c46ULL, 0x0000001405147210ULL, 0x000fe20007f1e0ffULL,
0x0000001022197824ULL, 0x100fe200078e0207ULL, 0x0000000911187c11ULL, 0x000fe200088f4410ULL,
0x000000101a077824ULL, 0x000fe200078e0207ULL, 0x0000001504107210ULL, 0x000fca0007f3e0ffULL,
0x000000ffff117224ULL, 0x000fe400008e0616ULL, 0x000000ffff137224ULL, 0x002fe200000e06ffULL,
0x0000000814157c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff097224ULL, 0x000fe200030e06ffULL,
0x0000001d04127210ULL, 0x000fe20007f3e0ffULL, 0x0000000010177faeULL, 0x0003e2000e901c46ULL,
0x0000000800057c11ULL, 0x000fe4000f8c40ffULL, 0x0000000914167c11ULL, 0x000fe400080f4413ULL,
0x0000001504147210ULL, 0x000fc40007f1e0ffULL, 0x00000018ff137210ULL, 0x000fe40000ffe4ffULL,
0x0000000900007c11ULL, 0x000fe2000b0f4409ULL, 0x000000ffff157224ULL, 0x000fe200000e0616ULL,
0x0000000504047210ULL, 0x000fe20007f3e0ffULL, 0x0000000012197faeULL, 0x0003e8000e101c46ULL,
0x000000ffff057224ULL, 0x000fe200008e0600ULL, 0x00000000141b7faeULL, 0x0003e8000d901c46ULL,
0x0000000004077faeULL, 0x0003e2000d101c46ULL, 0x0000000c00587947ULL, 0x000fea0003800000ULL,
0x0000000400127811ULL, 0x040fe200078fe8ffULL, 0x00008a0000087ab9ULL, 0x000fe20000000a00ULL,
0x0000000800147811ULL, 0x040fe400078fe8ffULL, 0x0000000c00167811ULL, 0x000fe200078fe8ffULL,
0x00000001122a7824ULL, 0x100fe200078e0200ULL, 0x0000001000177811ULL, 0x000fe200078fe8ffULL,
0x0000000812077824ULL, 0x000fe200078e00ffULL, 0x0000001400197811ULL, 0x000fe200078fe8ffULL,
0x0000000114297824ULL, 0x100fe200078e0200ULL, 0x0000001c00307811ULL, 0x000fe200078fe8ffULL,
0x0000000814107824ULL, 0x000fe200078e00ffULL, 0xfffffff8072a7812ULL, 0x000fe200078ee22aULL,
0x00000001162b7824ULL, 0x100fe200078e0200ULL, 0x00000028002f7811ULL, 0x000fe200078fe8ffULL,
0x00000001172c7824ULL, 0x140fe200078e0200ULL, 0xfffffff810297812ULL, 0x000fe200078ee229ULL,
0x0000000817077824ULL, 0x000fe200078e00ffULL, 0x0000000316107819ULL, 0x000fe200000006ffULL,
0x00000001192d7824ULL, 0x140fe200078e0200ULL, 0x0000000330097819ULL, 0x040fe200000006ffULL,
0x0000000130207824ULL, 0x100fe200078e0200ULL, 0xfffffff8102b7812ULL, 0x000fe200078ee22bULL,
0x0000000819107824ULL, 0x000fe200078e00ffULL, 0xfffffff8072c7812ULL, 0x000fe200078ee22cULL,
0x000000012f237824ULL, 0x000fe200078e0200ULL, 0x0000002000077811ULL, 0x040fe200078fe8ffULL,
0x000000010b127824ULL, 0x040fe200078e0212ULL, 0xfffffff8102d7812ULL, 0x000fe200078ee22dULL,
0x000000010b167824ULL, 0x000fe200078e0216ULL, 0x00000024002e7811ULL, 0x040fe200078fe8ffULL,
0x0000000107217824ULL, 0x140fe200078e0200ULL, 0x0000003000337811ULL, 0x000fe200078fe8ffULL,
0x0000000807107824ULL, 0x000fe200078e00ffULL, 0xfffffff809207812ULL, 0x000fe200078ee220ULL,
0x000000012e227824ULL, 0x100fe200078e0200ULL, 0x0000002c00317811ULL, 0x000fe200078fe8ffULL,
0x000000082e097824ULL, 0x000fe200078e00ffULL, 0xfffffff810217812ULL, 0x000fe200078ee221ULL,
0x000000082f107824ULL, 0x000fe200078e00ffULL, 0x0000003800377811ULL, 0x040fe200078fe8ffULL,
0x0000000133257824ULL, 0x100fe200078e0200ULL, 0x00000018001b7811ULL, 0x040fe200078fe8ffULL,
0x0000000131247824ULL, 0x100fe200078e0200ULL, 0xfffffff810237812ULL, 0x000fe200078ee223ULL,
0x0000000833107824ULL, 0x000fe200078e00ffULL, 0xfffffff809227812ULL, 0x000fe200078ee222ULL,
0x0000000137287824ULL, 0x100fe200078e0200ULL, 0x0000000331097819ULL, 0x000fe200000006ffULL,
0x0000000837117824ULL, 0x000fe200078e00ffULL, 0x0000003400357811ULL, 0x040fe200078fe8ffULL,
0x000000011b277824ULL, 0x140fe200078e0200ULL, 0xfffffff810257812ULL, 0x000fe200078ee225ULL,
0x000000081b187824ULL, 0x000fe200078e00ffULL, 0x0000000b00107211ULL, 0x000fe200078fe8ffULL,
0x0000000135267824ULL, 0x040fe200078e0200ULL, 0xfffffff809247812ULL, 0x000fe200078ee224ULL,
0x0000000835097824ULL, 0x000fe200078e00ffULL, 0xfffffff811287812ULL, 0x000fe200078ee228ULL,
0x000000010b2e7824ULL, 0x040fe200078e022eULL, 0x0000001205117210ULL, 0x000fe20007f3e0ffULL,
0x000000010b367824ULL, 0x040fe200078e0235ULL, 0x0000001005107210ULL, 0x000fe20007f1e0ffULL,
0x000000010b387824ULL, 0x000fe200078e0237ULL, 0xfffffff818277812ULL, 0x000fe200078ee227ULL,
0x000000ffff187224ULL, 0x000fe200008e06ffULL, 0xfffffff809267812ULL, 0x000fe200078ee226ULL,
0x000000ffff097224ULL, 0x000fe200000e06ffULL, 0x0000000811127c11ULL, 0x000fc4000f8240ffULL,
0x00000008101f7c11ULL, 0x040fe4000f8040ffULL, 0x000000140b147210ULL, 0x000fe40007ffe0ffULL,
0x0000000911117c11ULL, 0x000fe200088f4418ULL, 0x000000010b187824ULL, 0x040fe200078e0219ULL,
0x0000000910107c11ULL, 0x000fe400080f4409ULL, 0x0000001605157210ULL, 0x000fe20007f3e0ffULL,
0x000000010b167824ULL, 0x000fe200078e0217ULL, 0x0000001405137210ULL, 0x000fc40007f1e0ffULL,
0x0000000a5b347211ULL, 0x000fe200078e70ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x0000000815147c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x00000008131d7c11ULL, 0x000fe2000f8040ffULL, 0x0000100034477836ULL, 0x000fe20000000000ULL,
0x0000001605177210ULL, 0x000fe20007f5e0ffULL, 0x000000010b347824ULL, 0x000fe200078e0233ULL,
0x0000000915157c11ULL, 0x000fe200088f441aULL, 0x000000010b1a7824ULL, 0x000fe200078e021bULL,
0x0000000913137c11ULL, 0x000fe200080f441cULL, 0x0000001027357824ULL, 0x100fe200078e0247ULL,
0x0000001805197210ULL, 0x000fe20007f3e0ffULL, 0x00000010243f7824ULL, 0x100fe200078e0247ULL,
0x000000ffff1c7210ULL, 0x000fe200017fe4ffULL, 0x0000001026437824ULL, 0x100fe200078e0247ULL,
0x0000000817167c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff1e7224ULL, 0x000fe200008e06ffULL,
0x0000000819187c11ULL, 0x000fe2000f8240ffULL, 0x0000001029297824ULL, 0x000fe200078e0247ULL,
0x0000000917177c11ULL, 0x000fe200080f441cULL, 0x000000010b1c7824ULL, 0x000fe200078e0230ULL,
0x0000000919197c11ULL, 0x000fe200088f441eULL, 0x000000010b1e7824ULL, 0x000fe200078e0207ULL,
0x0000001a051b7210ULL, 0x000fe20007f1e0ffULL, 0x000000102b2b7824ULL, 0x100fe200078e0247ULL,
0x0000001c05097210ULL, 0x000fe20007f3e0ffULL, 0x000000102d2d7824ULL, 0x100fe200078e0247ULL,
0x0000001e05077210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff307224ULL, 0x000fe200000e06ffULL,
0x000000081b1a7c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff327224ULL, 0x000fe200008e06ffULL,
0x00000008091c7c11ULL, 0x000fe2000f8240ffULL, 0x0000001020377824ULL, 0x100fe200078e0247ULL,
0x000000091b1b7c11ULL, 0x000fe200080f4430ULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0x0000000909097c11ULL, 0x000fe200088f4432ULL, 0x00000010233d7824ULL, 0x100fe200078e0247ULL,
0x0000000000327211ULL, 0x000fe200078fe8ffULL, 0x0000001028457824ULL, 0x000fe200078e0247ULL,
0x00000008071e7c11ULL, 0x000fc4000f8040ffULL, 0x0000003c00397811ULL, 0x000fe400078fe8ffULL,
0x00000007323b7812ULL, 0x000fe200078ec0ffULL, 0x000000010b327824ULL, 0x000fe200078e0231ULL,
0x0000000907077c11ULL, 0x000fe200080f4430ULL, 0x000000010b307824ULL, 0x000fe200078e022fULL,
0x0000002e052e7210ULL, 0x000fe20007f9e0ffULL, 0x00000008393a7824ULL, 0x000fe200078e00ffULL,
0x0ffffff83b3b7812ULL, 0x000fe400078ef800ULL, 0x00000000392f7210ULL, 0x000fe20007ffe0ffULL,
0x000000010b007824ULL, 0x000fe200078e0239ULL, 0x0000003005307210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff317224ULL, 0x000fe200020e06ffULL, 0x0000003205327210ULL, 0x000fe20007f1e0ffULL,
0x0000001021397824ULL, 0x000fe200078e0247ULL, 0x0000003405347210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff217224ULL, 0x000fe200018e06ffULL, 0x0000003605367210ULL, 0x000fc40007f5e0ffULL,
0x0000003805387210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff277224ULL, 0x000fe200008e06ffULL,
0x0000000005057210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff237224ULL, 0x000fe200010e06ffULL,
0x000000082e3c7c11ULL, 0x000fe4000f8c40ffULL, 0xfffffff83a007812ULL, 0x000fe200078ee22fULL,
0x000000103b2f7824ULL, 0x100fe200078e0247ULL, 0x0000004725417211ULL, 0x000fe200078e20ffULL,
0x00000010223b7824ULL, 0x000fe200078e0247ULL, 0x0000000830227c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff257224ULL, 0x000fe200000e06ffULL, 0x0000000832247c11ULL, 0x000fc4000f8040ffULL,
0x000000092e3e7c11ULL, 0x000fe2000b0f4431ULL, 0x000000102a317824ULL, 0x100fe200078e0247ULL,
0x0000000834267c11ULL, 0x000fe4000f8240ffULL, 0x0000007004497812ULL, 0x000fe400078ec0ffULL,
0x000000472c337211ULL, 0x000fe200078e20ffULL, 0x0000001000477824ULL, 0x000fe200078e0247ULL,
0x00000009303a7c11ULL, 0x000fe200098f4421ULL, 0x000000ffff007224ULL, 0x000fe200028e06ffULL,
0x0000000932257c11ULL, 0x000fc400080f4425ULL, 0x0000000934277c11ULL, 0x000fe400088f4427ULL,
0x00000008052c7c11ULL, 0x000fe4000f8640ffULL, 0x0000001f49047210ULL, 0x000fe40007f1e0ffULL,
0x0000000836287c11ULL, 0x000fe4000f8240ffULL, 0x000000ffff217210ULL, 0x000fe400027fe4ffULL,
0x00000008382a7c11ULL, 0x000fc4000f8440ffULL, 0x0000000905007c11ULL, 0x000fe200098f4400ULL,
0x000000ffff057224ULL, 0x000fe200000e0610ULL, 0x0000000936307c11ULL, 0x000fe400088f4423ULL,
0x00000009382e7c11ULL, 0x000fe400090f4421ULL, 0x0000001249107210ULL, 0x000fe20007f3e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000042f7faeULL, 0x000fe2000b901c46ULL,
0x0000001d49127210ULL, 0x000fe40007f5e0ffULL, 0x0000001449147210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x0000001649167210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff137224ULL, 0x000fe200010e0613ULL, 0x0000001849187210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff157224ULL, 0x000fe200018e0615ULL, 0x0000001a491a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff177224ULL, 0x000fe200028e0617ULL, 0x0000001c491c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff197224ULL, 0x000fe200020e0619ULL, 0x0000001e491e7210ULL, 0x000fe20007f5e0ffULL,
0x0000000010317faeULL, 0x000fe2000b901c46ULL, 0x0000003c49207210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200008e0609ULL, 0x0000002249227210ULL, 0x000fe20007fbe0ffULL,
0x0000000012297faeULL, 0x0005e2000b901c46ULL, 0x0000002449247210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200010e0607ULL, 0x0000001bff1b7210ULL, 0x000fe200007fe4ffULL,
0x00000000142b7faeULL, 0x0007e2000b901c46ULL, 0x0000002649267210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff217224ULL, 0x000fe200018e063eULL, 0x0000002849287210ULL, 0x000fe20007f3e0ffULL,
0x0000000016337faeULL, 0x000fe2000b901c46ULL, 0x0000002a492a7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff237224ULL, 0x000fe200028e063aULL, 0x0000002c492c7210ULL, 0x000fe20007f7e0ffULL,
0x00000000182d7faeULL, 0x0009e2000b901c46ULL, 0x000000ffff257224ULL, 0x000fc400020e0625ULL,
0x000000ffff277224ULL, 0x000fe200000e0627ULL, 0x000000001a357faeULL, 0x0003e2000b901c46ULL,
0x000000ffff297224ULL, 0x004fe200008e0630ULL, 0x0000002eff2b7210ULL, 0x008fe400017fe4ffULL,
0x000000001c377faeULL, 0x0003e8000b901c46ULL, 0x000000001e397faeULL, 0x0003e2000b901c46ULL,
0x000000ffff2d7224ULL, 0x010fc600018e0600ULL, 0x00000000203b7faeULL, 0x0003e8000b901c46ULL,
0x00000000223d7faeULL, 0x0003e8000b901c46ULL, 0x00000000243f7faeULL, 0x0003e8000b901c46ULL,
0x0000000026417faeULL, 0x0003e8000b901c46ULL, 0x0000000028437faeULL, 0x0003e8000b901c46ULL,
0x000000002a457faeULL, 0x0003e8000b901c46ULL, 0x000000002c477faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000000047805ULL, 0x002fe20000015200ULL,
0x01b600030a0075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x006fea0003800000ULL,
0x000000ffff097224ULL, 0x000fce00078e00ffULL, 0x000000100900780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x0000001004077210ULL, 0x000fca0007f1e1ffULL, 0x0000000111107824ULL, 0x000fe200000e0e05ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff1000720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff1000720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc80000011410ULL, 0x0000000700007211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0610ULL, 0x0000000200007819ULL, 0x000fc80000001207ULL,
0x000000000000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000109097836ULL, 0x000fce0000000000ULL, 0x01b600030a0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000e5900720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00009000ff037b82ULL, 0x000e620000000800ULL,
0x0000000000097919ULL, 0x000ea20000000000ULL, 0x000000085b077824ULL, 0x040fe200078e020aULL,
0x0000000a5b047211ULL, 0x000fe200078e28ffULL, 0xffffffff0e057836ULL, 0x000fe40000000000ULL,
0x0000000306067224ULL, 0x002fce00078e02ffULL, 0x0000010059037824ULL, 0x002fca00078e0208ULL,
0x000000035a00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000159117836ULL, 0x000fe40000000000ULL, 0x000000040d0d7c24ULL, 0x000fc6000f8e02ffULL,
0x0000000e1100720cULL, 0x000fda0003f06070ULL, 0x0000000c00688947ULL, 0x000fea0003800000ULL,
0x00000003ff3c7819ULL, 0x104fe20000011609ULL, 0x00008a0000087ab9ULL, 0x000fe20000000a00ULL,
0x0ffffff809627812ULL, 0x000fe200078ec0ffULL, 0x000040005b607824ULL, 0x000fe200078e020aULL,
0x0000001c3c447810ULL, 0x000fe20007ffe0ffULL, 0x000000010b007824ULL, 0x000fe400078e023cULL,
0x000000043c107836ULL, 0x000fe40000000000ULL, 0x000000083c127836ULL, 0x000fe20000000000ULL,
0x000000000d027210ULL, 0x000fe20007f1e0ffULL, 0x00000001102f7824ULL, 0x000fc400078e0209ULL,
0x0000000810007824ULL, 0x000fe200078e00ffULL, 0x0000000912317210ULL, 0x000fe20007ffe0ffULL,
0x000000ffff117224ULL, 0x000fe200000e06ffULL, 0x0000000802187c11ULL, 0x000fe2000f8040ffULL,
0x0000000812147824ULL, 0x000fe200078e00ffULL, 0xfffffff8002f7812ULL, 0x000fe200078ee22fULL,
0x000000015a007824ULL, 0x000fe200078e0a03ULL, 0x0000000902197c11ULL, 0x000fe200080f4411ULL,
0x000000010b027824ULL, 0x040fe200078e0210ULL, 0xfffffff814317812ULL, 0x000fe200078ee231ULL,
0x000000103c3e7836ULL, 0x000fe20000000000ULL, 0x000000001000720cULL, 0x080fe20003f06070ULL,
0x000000010b107824ULL, 0x040fe200078e0212ULL, 0x000000020d027210ULL, 0x000fe20007f9e0ffULL,
0x0000000c3c3a7836ULL, 0x000fe20000000000ULL, 0x000000001200720cULL, 0x000fe20003f26070ULL,
0x000000010b147824ULL, 0x040fe200078e023eULL, 0x000000100d107210ULL, 0x000fe20007fbe0ffULL,
0x000000ffff177224ULL, 0x000fe200020e06ffULL, 0x0000003a0b127210ULL, 0x000fe20007ffe0ffULL,
0x000000143c407836ULL, 0x000fe20000000000ULL, 0x000000140d147210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff157224ULL, 0x000fe200028e06ffULL, 0x000000120d127210ULL, 0x000fe20007f5e0ffULL,
0x000000183c427836ULL, 0x000fe20000000000ULL, 0x00000008022a7c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff117224ULL, 0x000fe200018e06ffULL, 0x0000000810287c11ULL, 0x000fe2000f8a40ffULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x00000009022b7c11ULL, 0x000fe2000a0f4417ULL,
0x000000010b027824ULL, 0x040fe200078e0240ULL, 0x0000000814207c11ULL, 0x000fe2000f8640ffULL,
0x000000203c367836ULL, 0x000fe20000000000ULL, 0x0000000910297c11ULL, 0x000fe2000a8f4415ULL,
0x000000010b107824ULL, 0x040fe200078e0242ULL, 0x0000000812267c11ULL, 0x000fe2000f8440ffULL,
0x000000243c2c7836ULL, 0x000fe20000000000ULL, 0x0000000914217c11ULL, 0x000fe200098f4411ULL,
0x000000010b147824ULL, 0x040fe200078e0236ULL, 0x0000000912277c11ULL, 0x000fe200090f4413ULL,
0x000000010b127824ULL, 0x040fe200078e0244ULL, 0x000000020d027210ULL, 0x000fe20007f9e0ffULL,
0x000000283c2e7836ULL, 0x000fe20000000000ULL, 0x000000100d107210ULL, 0x000fe20007fbe0ffULL,
0x0000002c3c307836ULL, 0x000fe20000000000ULL, 0x000000140d147210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff177224ULL, 0x000fe200020e06ffULL, 0x000000120d127210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff157224ULL, 0x000fe200028e06ffULL, 0x0000000802247c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff117224ULL, 0x000fe200018e06ffULL, 0x0000000810227c11ULL, 0x000fe2000f8a40ffULL,
0x000000303c327836ULL, 0x000fe20000000000ULL, 0x000000ffff137210ULL, 0x000fe200017fe4ffULL,
0x000000083e397824ULL, 0x000fe200078e00ffULL, 0x0000000902257c11ULL, 0x000fe2000a0f4417ULL,
0x000000010b027824ULL, 0x040fe200078e022cULL, 0x00000008121e7c11ULL, 0x000fe2000f8440ffULL,
0x000000013a357824ULL, 0x000fe200078e0209ULL, 0x00000008141c7c11ULL, 0x000fe2000f8640ffULL,
0x000000083a467824ULL, 0x000fe200078e00ffULL, 0x0000000910237c11ULL, 0x000fe2000a8f4415ULL,
0x000000010b107824ULL, 0x040fe200078e022eULL, 0x00000009121f7c11ULL, 0x000fe200090f4413ULL,
0x00003000605c7836ULL, 0x000fe20000000000ULL, 0x00000009141d7c11ULL, 0x000fe200098f4411ULL,
0x000000010b147824ULL, 0x000fe200078e0232ULL, 0x000000300b127210ULL, 0x000fe20007ffe0ffULL,
0x000000102f2f7824ULL, 0x000fe200078e025cULL, 0x000000020d177210ULL, 0x000fe20007f9e0ffULL,
0x00000001403b7824ULL, 0x100fe200078e0209ULL, 0x000000100d157210ULL, 0x000fe20007fbe0ffULL,
0x00000001363d7824ULL, 0x000fe200078e0209ULL, 0x000000120d107210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff387224ULL, 0x000fe200020e06ffULL, 0x000000140d027210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff347224ULL, 0x000fe200028e06ffULL, 0x00000008171a7c11ULL, 0x000fe2000f8840ffULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x0000000815167c11ULL, 0x000fe2000f8a40ffULL,
0x000000ffff117224ULL, 0x000fe200018e06ffULL, 0x0000000810147c11ULL, 0x000fc4000f8440ffULL,
0x00000009171b7c11ULL, 0x000fe2000a0f4438ULL, 0x000000013e387824ULL, 0x000fe200078e0209ULL,
0x0000000802127c11ULL, 0x000fe4000f8640ffULL, 0x0000000915177c11ULL, 0x000fe4000a8f4434ULL,
0x000000343c347810ULL, 0x000fe40007ffe0ffULL, 0x0000000910157c11ULL, 0x000fe400090f4413ULL,
0x0000000902137c11ULL, 0x000fe200098f4411ULL, 0x000000013c117824ULL, 0x040fe200078e0209ULL,
0x0000000709027812ULL, 0x000fe200078ec0ffULL, 0x000000010b107824ULL, 0x000fe200078e0234ULL,
0x000000003c00720cULL, 0x000fc40003f46070ULL, 0x0000000762337812ULL, 0x000fe400078ef811ULL,
0x000000100d117210ULL, 0x000fe40007f7e0ffULL, 0x000000003a00720cULL, 0x000fe20003fa6070ULL,
0x0000001033337824ULL, 0x000fe200078e025cULL, 0x000000ffff3a7210ULL, 0x000fe40001ffe4ffULL,
0x00000008022d7812ULL, 0x000fe400078efcffULL, 0x0000000811107c11ULL, 0x000fc4000f8640ffULL,
0xfffffff839397812ULL, 0x000fe200078ee238ULL, 0x000000383c387836ULL, 0x000fe20000000000ULL,
0x0000000911117c11ULL, 0x000fe200098f443aULL, 0x000000102d187825ULL, 0x000fe200078e0018ULL,
0xfffffff846377812ULL, 0x000fe400078ee235ULL, 0x000000003e00720cULL, 0x000fe20003f86070ULL,
0x0000003c3c3a7836ULL, 0x000fe20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000018337faeULL, 0x0003e2000d101c46ULL, 0x000000010b3c7824ULL, 0x000fe200078e0238ULL,
0x0000005c31317211ULL, 0x000fe200078e20ffULL, 0x000000102d2a7825ULL, 0x000fe200078e002aULL,
0x000000004000720cULL, 0x000fc40003f66070ULL, 0x0000003c0d357210ULL, 0x000fe20007f5e0ffULL,
0x000000102d287825ULL, 0x000fe200078e0028ULL, 0x000000002a2f7faeULL, 0x000fe2000c101c46ULL,
0x000000003600720cULL, 0x080fe40003f06070ULL, 0x000000ffff3e7224ULL, 0x000fe200010e06ffULL,
0x0000000835187c11ULL, 0x042fe2000f8c40ffULL, 0x0000000840407824ULL, 0x000fe200078e00ffULL,
0x0000000028317faeULL, 0x0003e2000c901c46ULL, 0x0000000142337824ULL, 0x100fe200078e0209ULL,
0x0000000935197c11ULL, 0x000fe2000b0f443eULL, 0x0000000144357824ULL, 0x000fe200078e0209ULL,
0x000000004200720cULL, 0x0c0fe20003fc6070ULL, 0x0000000842427824ULL, 0x000fe200078e00ffULL,
0x000000004400720cULL, 0x040fe20003f26070ULL, 0x000000010b3c7824ULL, 0x000fe200078e023aULL,
0xfffffff8403b7812ULL, 0x000fe200078ee23bULL, 0x0000000844447824ULL, 0x000fc400078e00ffULL,
0x0000000836367824ULL, 0x000fe200078e00ffULL, 0xfffffff842317812ULL, 0x002fe200078ee233ULL,
0x000000102d267825ULL, 0x000fe200078e0026ULL, 0x0000003c0d3c7210ULL, 0x000fe40007f5e0ffULL,
0xfffffff844337812ULL, 0x000fe200078ee235ULL, 0x00000010392b7824ULL, 0x000fe200078e025cULL,
0x0000005c370d7211ULL, 0x000fe200078e20ffULL, 0x000000102d207825ULL, 0x000fe200078e0020ULL,
0xfffffff836357812ULL, 0x000fc600078ee23dULL, 0x000000103b2f7824ULL, 0x000fe200078e025cULL,
0x00000000260d7faeULL, 0x000fe2000e901c46ULL, 0x000000102d247825ULL, 0x000fe200078e0024ULL,
0x000000003800720cULL, 0x080fe40003fa6070ULL, 0x00000000202b7faeULL, 0x0003e2000e101c46ULL,
0x0000001031317824ULL, 0x000fe200078e025cULL, 0x000000003400720cULL, 0x080fe20003f86070ULL,
0x000000102d227825ULL, 0x000fe200078e0022ULL, 0x00000000242f7faeULL, 0x000fe2000d901c46ULL,
0x000000003200720cULL, 0x000fc40003f66070ULL, 0x0000001033337824ULL, 0x000fe200078e025cULL,
0x0000000022317faeULL, 0x000fe2000f101c46ULL, 0x000000102d1e7825ULL, 0x000fe200078e001eULL,
0x000000003a00720cULL, 0x000fc60003fc6070ULL, 0x0000001035357824ULL, 0x000fe200078e025cULL,
0x000000001e337faeULL, 0x0005e2000c901c46ULL, 0x000000102d1c7825ULL, 0x000fe200078e001cULL,
0x000000002e00720cULL, 0x000fc60003f26070ULL, 0x000000ffff297224ULL, 0x000fe200010e06ffULL,
0x000000083c287c11ULL, 0x000fe2000f8440ffULL, 0x0000000130207824ULL, 0x142fe200078e0209ULL,
0x000000001c357faeULL, 0x0003e2000c101c46ULL, 0x0000000830217824ULL, 0x000fe200078e00ffULL,
0x000000002c00720cULL, 0x0c0fe20003f06070ULL, 0x000000012c0d7824ULL, 0x140fe200078e0209ULL,
0x000000032c2c7819ULL, 0x000fe200000006ffULL, 0x000000012e267824ULL, 0x000fe200078e0209ULL,
0x000000093c297c11ULL, 0x000fe200090f4429ULL, 0x000000082e277824ULL, 0x000fe200078e00ffULL,
0x000000003000720cULL, 0x000fe20003f46070ULL, 0x0000000132007824ULL, 0x140fe200078e0209ULL,
0xfffffff8211f7812ULL, 0x004fe200078ee220ULL, 0x0000000832217824ULL, 0x000fe200078e00ffULL,
0xfffffff82c0d7812ULL, 0x000fe200078ee20dULL, 0x00000001341c7824ULL, 0x102fe200078e0209ULL,
0xfffffff8271d7812ULL, 0x000fe200078ee226ULL, 0x00000001381e7824ULL, 0x100fe200078e0209ULL,
0x0000000334237819ULL, 0x000fe200000006ffULL, 0x0000000838257824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee200ULL, 0x000000013a207824ULL, 0x040fe200078e0209ULL,
0xfffffff823237812ULL, 0x000fe200078ee21cULL, 0x000000083a277824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee21eULL, 0x000000100d0d7824ULL, 0x000fe200078e025cULL,
0x0000005c21217211ULL, 0x000fe200078e20ffULL, 0x000000102d1a7825ULL, 0x000fe200078e001aULL,
0xfffffff827277812ULL, 0x000fc600078ee220ULL, 0x000000101d1d7824ULL, 0x000fe200078e025cULL,
0x000000001a0d7faeULL, 0x0003e2000c101c46ULL, 0x000000102d167825ULL, 0x000fc800078e0016ULL,
0x000000102d147825ULL, 0x000fe200078e0014ULL, 0x00000000161d7faeULL, 0x0003e6000c901c46ULL,
0x000000101f1f7824ULL, 0x000fe400078e025cULL, 0x000000102d127825ULL, 0x000fc600078e0012ULL,
0x00000000141f7faeULL, 0x0003e2000d101c46ULL, 0x000000102d107825ULL, 0x000fc600078e0010ULL,
0x0000000012217faeULL, 0x0003e2000d901c46ULL, 0x0000001023237824ULL, 0x000fe400078e025cULL,
0x000000102d187825ULL, 0x000fc600078e0018ULL, 0x0000000010237faeULL, 0x0003e2000e101c46ULL,
0x0000001025257824ULL, 0x000fe400078e025cULL, 0x000000102d287825ULL, 0x000fc600078e0028ULL,
0x0000000018257faeULL, 0x0003e2000e901c46ULL, 0x0000001027277824ULL, 0x000fca00078e025cULL,
0x0000000028277faeULL, 0x0003e2000f101c46ULL, 0x0000000c001c7947ULL, 0x000fea0003800000ULL,
0x0000000809107811ULL, 0x044fe200078fe8ffULL, 0x00008a0000087ab9ULL, 0x000fe20000000a00ULL,
0x0000000c09147811ULL, 0x000fe200078fe8ffULL, 0x000040005b607824ULL, 0x000fe200078e020aULL,
0x0000000409027811ULL, 0x040fe200078fe8ffULL, 0x0000000110497824ULL, 0x140fe200078e0209ULL,
0x0000000914477210ULL, 0x000fe20007ffe0ffULL, 0x0000000810127824ULL, 0x000fe200078e00ffULL,
0x00000014091a7811ULL, 0x040fe200078fe8ffULL, 0x0000000814167824ULL, 0x000fe200078e00ffULL,
0x00000024092a7811ULL, 0x040fe200078fe8ffULL, 0x00000001024b7824ULL, 0x140fe200078e0209ULL,
0xfffffff812497812ULL, 0x000fe200078ee249ULL, 0x0000000802007824ULL, 0x000fe200078e00ffULL,
0xfffffff816477812ULL, 0x000fe200078ee247ULL, 0x000000011a437824ULL, 0x140fe200078e0209ULL,
0x0000001009167811ULL, 0x040fe200078fe8ffULL, 0x000000081a127824ULL, 0x000fe200078e00ffULL,
0xfffffff8004b7812ULL, 0x000fe200078ee24bULL, 0x000000012a3b7824ULL, 0x100fe200078e0209ULL,
0x0000002009247811ULL, 0x040fe200078fe8ffULL, 0x0000000116457824ULL, 0x140fe200078e0209ULL,
0xfffffff812437812ULL, 0x000fe200078ee243ULL, 0x0000000816007824ULL, 0x000fe200078e00ffULL,
0x0000001c09227811ULL, 0x040fe200078fe8ffULL, 0x000000082a127824ULL, 0x000fe200078e00ffULL,
0x0000003009327811ULL, 0x040fe200078fe8ffULL, 0x00000001243d7824ULL, 0x140fe200078e0209ULL,
0xfffffff800457812ULL, 0x000fe200078ee245ULL, 0x0000000824007824ULL, 0x000fe200078e00ffULL,
0xfffffff8123b7812ULL, 0x000fe200078ee23bULL, 0x00000008221e7824ULL, 0x000fe200078e00ffULL,
0x00000009223f7210ULL, 0x000fe20007ffe0ffULL, 0x0000000132357824ULL, 0x040fe200078e0209ULL,
0x0000002c09307811ULL, 0x000fe200078fe8ffULL, 0x0000000832127824ULL, 0x000fe200078e00ffULL,
0xfffffff8003d7812ULL, 0x000fe200078ee23dULL, 0x000000010b107824ULL, 0x000fe200078e0210ULL,
0xfffffff81e3f7812ULL, 0x000fe200078ee23fULL, 0x00000008301e7824ULL, 0x000fe200078e00ffULL,
0x0000000b09007211ULL, 0x000fe200078fe8ffULL, 0x000000010b327824ULL, 0x040fe200078e0232ULL,
0xfffffff812357812ULL, 0x000fe200078ee235ULL, 0x000000010b127824ULL, 0x040fe200078e0202ULL,
0x0000000930377210ULL, 0x000fe20007ffe0ffULL, 0x000000010b027824ULL, 0x000fe200078e0214ULL,
0x0000003809367811ULL, 0x040fe200078fe8ffULL, 0x00003000605c7836ULL, 0x000fe20000000000ULL,
0x00000018091c7811ULL, 0x000fc400078fe8ffULL, 0x0000000d00007210ULL, 0x000fe20007f1e0ffULL,
0x0000000136317824ULL, 0x140fe200078e0209ULL, 0xfffffff81e377812ULL, 0x000fe200078ee237ULL,
0x00000008361e7824ULL, 0x000fe200078e00ffULL, 0x0000000d02027210ULL, 0x000fe20007f5e0ffULL,
0x000000011c417824ULL, 0x040fe200078e0209ULL, 0x000000ffff117210ULL, 0x000fe200007fe4ffULL,
0x000000081c187824ULL, 0x000fe200078e00ffULL, 0x00000008002e7c11ULL, 0x040fe2000f8040ffULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0x00000028092c7811ULL, 0x000fe200078fe8ffULL,
0x000000010b367824ULL, 0x000fe200078e0236ULL, 0xfffffff81e317812ULL, 0x000fe200078ee231ULL,
0x000000104b4b7824ULL, 0x000fe200078e025cULL, 0x00000009002f7c11ULL, 0x000fe200080f4411ULL,
0x000000010b007824ULL, 0x000fe200078e0216ULL, 0x00000008021e7c11ULL, 0x000fe2000f8440ffULL,
0x000000012c397824ULL, 0x040fe200078e0209ULL, 0xfffffff818417812ULL, 0x000fe200078ee241ULL,
0x000000082c187824ULL, 0x000fe200078e00ffULL, 0x0000003409347811ULL, 0x000fe200078fe8ffULL,
0x0000001049497824ULL, 0x000fe200078e025cULL, 0x00000009021f7c11ULL, 0x000fe200090f4413ULL,
0x000000010b027824ULL, 0x000fe200078e0222ULL, 0x0000000d12127210ULL, 0x000fe20007f1e0ffULL,
0x0000000134337824ULL, 0x040fe200078e0209ULL, 0x0000000d00007210ULL, 0x000fe20007f7e0ffULL,
0x0000001047477824ULL, 0x000fe200078e025cULL, 0xfffffff818397812ULL, 0x000fe200078ee239ULL,
0x0000000834187824ULL, 0x000fe200078e00ffULL, 0x0000000d10107210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x000000ffff117210ULL, 0x000fe20001ffe4ffULL,
0x000000010b347824ULL, 0x000fe200078e0234ULL, 0x0000000d02027210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff177224ULL, 0x000fe200008e06ffULL, 0x0000000800207c11ULL, 0x000fe2000f8640ffULL,
0x0000001045457824ULL, 0x100fe200078e025cULL, 0x0000000812147c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff137224ULL, 0x000fe200010e06ffULL, 0xfffffff818337812ULL, 0x000fe200078ee233ULL,
0x0000001041417824ULL, 0x100fe200078e025cULL, 0x0000000810187c11ULL, 0x000fe2000f8240ffULL,
0x000000103f3f7824ULL, 0x000fe200078e025cULL, 0x0000000900217c11ULL, 0x000fe200098f4411ULL,
0x000000010b007824ULL, 0x040fe200078e0224ULL, 0x0000000912157c11ULL, 0x000fe200080f4415ULL,
0x000000010b127824ULL, 0x000fe200078e021aULL, 0x0000000802267c11ULL, 0x000fe2000f8440ffULL,
0x000000103d3d7824ULL, 0x000fe200078e025cULL, 0x0000000910197c11ULL, 0x000fe200088f4417ULL,
0x000000010b107824ULL, 0x040fe200078e021cULL, 0x0000000902277c11ULL, 0x000fe200090f4413ULL,
0x000000010b027824ULL, 0x000fe200078e022aULL, 0x0000000d00007210ULL, 0x000fe20007f7e0ffULL,
0x000000103b3b7824ULL, 0x100fe200078e025cULL, 0x0000000d12127210ULL, 0x000fe20007f1e0ffULL,
0x0000001039397824ULL, 0x100fe200078e025cULL, 0x0000000d10107210ULL, 0x000fe20007f3e0ffULL,
0x0000001037377824ULL, 0x100fe200078e025cULL, 0x000000ffff117210ULL, 0x000fe20001ffe4ffULL,
0x000000ffff1b7224ULL, 0x000fe200000e06ffULL, 0x0000000800287c11ULL, 0x000fe2000f8640ffULL,
0x000000ffff177224ULL, 0x000fe200008e06ffULL, 0x0000000d02027210ULL, 0x000fe20007f9e0ffULL,
0x0000001035357824ULL, 0x100fe200078e025cULL, 0x0000000812227c11ULL, 0x000fe2000f8040ffULL,
0x0000001031317824ULL, 0x000fe200078e025cULL, 0x0000000810247c11ULL, 0x000fc4000f8240ffULL,
0x0000000900297c11ULL, 0x000fe200098f4411ULL, 0x000000ffff117224ULL, 0x000fe200020e06ffULL,
0x0000003c09007811ULL, 0x000fe400078fe8ffULL, 0x0000000912237c11ULL, 0x000fe200080f441bULL,
0x000000010b127824ULL, 0x040fe200078e022cULL, 0x00000008022a7c11ULL, 0x000fe2000f8c40ffULL,
0x000000010b167824ULL, 0x040fe200078e0200ULL, 0x0000000910257c11ULL, 0x000fe200088f4417ULL,
0x000000010b107824ULL, 0x000fe200078e0230ULL, 0x00000009022b7c11ULL, 0x000fe2000b0f4411ULL,
0x00000008001d7824ULL, 0x000fe200078e00ffULL, 0x0000000709027812ULL, 0x000fc400078ec0ffULL,
0x00000009092d7211ULL, 0x040fe400078fe8ffULL, 0x0ffffff809627812ULL, 0x000fe400078ec0ffULL,
0x00000009001a7210ULL, 0x000fe40007ffe0ffULL, 0x0000000d12127210ULL, 0x000fe40007f3e0ffULL,
0x0000000d10107210ULL, 0x000fe40007f7e0ffULL, 0x0000000d321b7210ULL, 0x000fc40007f5e0ffULL,
0x0000000d34177210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff117224ULL, 0x000fe200018e06ffULL,
0x0000000d36137210ULL, 0x000fe40007fbe0ffULL, 0x0000000d16007210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x00000007624d7812ULL, 0x000fe200078ef82dULL,
0x000000ffff307224ULL, 0x000fe200028e06ffULL, 0x00000008024f7812ULL, 0x000fe400078efcffULL,
0xfffffff81d0d7812ULL, 0x000fe200078ee21aULL, 0x000000ffff1d7224ULL, 0x000fe200008e06ffULL,
0x00000008122c7c11ULL, 0x000fe2000f8240ffULL, 0x000000104d4d7824ULL, 0x000fe200078e025cULL,
0x00000008101c7c11ULL, 0x000fe2000f8640ffULL, 0x000000104f2e7825ULL, 0x000fe200078e002eULL,
0x00000009122d7c11ULL, 0x000fc400088f441dULL, 0x000000ffff347210ULL, 0x000fe200017fe4ffULL,
0x000000104f147825ULL, 0x000fe200078e0014ULL, 0x000000081b1a7c11ULL, 0x000fe2000f8240ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e4d7faeULL, 0x0003e2000b901c46ULL,
0x00000009101d7c11ULL, 0x000fe200098f4411ULL, 0x000000104f187825ULL, 0x000fe200078e0018ULL,
0x0000000817167c11ULL, 0x000fe2000f8040ffULL, 0x00000000144b7faeULL, 0x0003e2000b901c46ULL,
0x0000000813127c11ULL, 0x000fe2000f8440ffULL, 0x000000104f1e7825ULL, 0x000fe200078e001eULL,
0x0000005c43437211ULL, 0x080fe200078e20ffULL, 0x0000000018497faeULL, 0x0003e2000b901c46ULL,
0x0000000800107c11ULL, 0x000fe2000f8640ffULL, 0x000000104f207825ULL, 0x000fe200078e0020ULL,
0x000000091b1b7c11ULL, 0x000fe200088f4434ULL, 0x000000001e477faeULL, 0x0003e2000b901c46ULL,
0x0000000917177c11ULL, 0x000fe200080f4432ULL, 0x000000ffff117224ULL, 0x000fe200020e06ffULL,
0x0000000913137c11ULL, 0x000fe200090f4430ULL, 0x000000104f227825ULL, 0x000fe200078e0022ULL,
0x0000000020457faeULL, 0x0003e2000b901c46ULL, 0x0000005c33337211ULL, 0x000fc400078e20ffULL,
0x000000104f247825ULL, 0x040fe200078e0024ULL, 0x0000000900117c11ULL, 0x000fe200098f4411ULL,
0x0000000022437faeULL, 0x0003e4000b901c46ULL, 0x000000104f267825ULL, 0x040fe400078e0026ULL,
0x0000000024417faeULL, 0x0003e4000b901c46ULL, 0x000000104f287825ULL, 0x040fe400078e0028ULL,
0x00000000263f7faeULL, 0x0003e4000b901c46ULL, 0x000000104f2a7825ULL, 0x000fc400078e002aULL,
0x00000000283d7faeULL, 0x0003e4000b901c46ULL, 0x000000104f2c7825ULL, 0x040fe400078e002cULL,
0x000000002a3b7faeULL, 0x0003e4000b901c46ULL, 0x000000104f1c7825ULL, 0x040fe400078e001cULL,
0x000000002c397faeULL, 0x0003e4000b901c46ULL, 0x000000104f1a7825ULL, 0x000fc400078e001aULL,
0x000000001c377faeULL, 0x0003e4000b901c46ULL, 0x000000104f167825ULL, 0x040fe400078e0016ULL,
0x000000001a357faeULL, 0x0003e4000b901c46ULL, 0x000000104f127825ULL, 0x040fe400078e0012ULL,
0x0000000016337faeULL, 0x0003e4000b901c46ULL, 0x000000104f107825ULL, 0x000fc400078e0010ULL,
0x0000000012317faeULL, 0x0003e4000b901c46ULL, 0x000000100d0d7824ULL, 0x000fca00078e025cULL,
0x00000000100d7faeULL, 0x0003e4000b901c46ULL, 0x000000040c0f7824ULL, 0x000fe200078e020fULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff0d7424ULL, 0x002fc600078e00ffULL,
0x000000580f00720cULL, 0x000fda0003f06070ULL, 0x00008c00ff108b82ULL, 0x000e620000000a00ULL,
0x0000000206138824ULL, 0x000fe200078e020fULL, 0x00000004ff5e7819ULL, 0x100fe40000011609ULL,
0x00000003ff007819ULL, 0x000fe40000011609ULL, 0x00000008025d7812ULL, 0x000fe200078ef809ULL,
0x0000100060607836ULL, 0x000fe20000000000ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000413108825ULL, 0x002fca00078e0010ULL, 0x00000006100d8981ULL, 0x0002a2000c1e1900ULL,
0x000000085e157824ULL, 0x000fe200078e00ffULL, 0x0000000100137812ULL, 0x000fe200078ec0ffULL,
0x000000015e5e7824ULL, 0x000fe400078e025dULL, 0x000000105d197824ULL, 0x040fe200078e00ffULL,
0xfffffff8153c7812ULL, 0x000fe200078ee202ULL, 0x000000010c757824ULL, 0x000fe200078e0259ULL,
0x000000045d157819ULL, 0x000fe200000006ffULL, 0x000000025e107836ULL, 0x002fe20000000000ULL,
0x000000033c127819ULL, 0x040fe200000006ffULL, 0x00000001133b7824ULL, 0x000fe200078e023cULL,
0xfffffff015117812ULL, 0x000fe200078ee25eULL, 0x000000083c647824ULL, 0x000fe200078e00ffULL,
0xfffffff019197812ULL, 0x000fe200078ee210ULL, 0x000000103c3a7836ULL, 0x000fe20000000000ULL,
0x000000363b5f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001011117824ULL, 0x000fe200078e020aULL,
0xfffffff864647812ULL, 0x000fe200078ee23bULL, 0x00000001137d7824ULL, 0x000fc400078e023aULL,
0x000000083a107824ULL, 0x000fe200078e00ffULL, 0x000000001128783bULL, 0x000fe20000000200ULL,
0x0000001064147824ULL, 0x000fe400078e0260ULL, 0x000000203c397836ULL, 0x000fe20000000000ULL,
0xfffffff8107d7812ULL, 0x000fe200078ee27dULL, 0x000000303c387836ULL, 0x000fe40000000000ULL,
0x000000001414783bULL, 0x000e620000000200ULL, 0x0000000839107824ULL, 0x000fe200078e00ffULL,
0x00000039137b7210ULL, 0x000fe20007ffe0ffULL, 0x0000000113797824ULL, 0x000fc400078e0238ULL,
0x000000023b777836ULL, 0x000fe20000000000ULL, 0xfffffff8107b7812ULL, 0x000fe200078ee27bULL,
0x0000000838107824ULL, 0x000fe400078e00ffULL, 0x000000107d347824ULL, 0x000fe200078e0260ULL,
0xfffffff812777812ULL, 0x000fe200078ee277ULL, 0x0000001019197824ULL, 0x000fe200078e020aULL,
0xfffffff810797812ULL, 0x000fe200078ee279ULL, 0x000000107b307824ULL, 0x100fe200078e0260ULL,
0x000000033a107819ULL, 0x000fe200000006ffULL, 0x0000001077507824ULL, 0x100fe200078e0260ULL,
0x000000003434783bULL, 0x000ee20000000200ULL, 0x00000010792c7824ULL, 0x000fc400078e0260ULL,
0x000000123b717836ULL, 0x000fe20000000000ULL, 0x000000001920783bULL, 0x000fe20000000200ULL,
0x000000223b677836ULL, 0x000fe40000000000ULL, 0x0000000839187824ULL, 0x000fe200078e00ffULL,
0x000000002c2c783bULL, 0x000f220000000200ULL, 0xfffffff810717812ULL, 0x000fe200078ee271ULL,
0x000000323b6f7836ULL, 0x000fe40000000000ULL, 0x000000005050783bULL, 0x000f620000000200ULL,
0xfffffff818677812ULL, 0x000fe200078ee267ULL, 0x0000001071107824ULL, 0x000fc400078e0260ULL,
0x000000003030783bULL, 0x000f620000000200ULL, 0x00000008383e7824ULL, 0x000fe400078e00ffULL,
0x0000001067187824ULL, 0x000fe200078e0260ULL, 0x000000001010783bULL, 0x000f620000000200ULL,
0x000000343b657836ULL, 0x000fe20000000000ULL, 0xfffffff83e6f7812ULL, 0x000fe200078ee26fULL,
0x000000043b737836ULL, 0x000fe20000000000ULL, 0x000000142824723cULL, 0x002fe200000018ffULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0xfffffff83e657812ULL, 0x000fe200078ee265ULL,
0x000000143b6d7836ULL, 0x000fc40000000000ULL, 0x000000243b697836ULL, 0x000fe20000000000ULL,
0x000000162814723cULL, 0x000fe200000018ffULL, 0x0000001065407824ULL, 0x000fe400078e0260ULL,
0x0000000838387824ULL, 0x000fe400078e00ffULL, 0x000000263b617836ULL, 0x000fe40000000000ULL,
0x000000004040783bULL, 0x000fe20000000200ULL, 0xfffffff8385f7812ULL, 0x000fe200078ee25fULL,
0x000000063b6b7836ULL, 0x000fe20000000000ULL, 0x00000034284c723cULL, 0x008fe200000018ffULL,
0x000000163b637836ULL, 0x000fca0000000000ULL, 0x000000362834723cULL, 0x000fec00000018ffULL,
0x0000002c281c723cULL, 0x010fec00000018ffULL, 0x000000502024723cULL, 0x020fe20000001824ULL,
0x000000606f2c7211ULL, 0x000fca00078e20ffULL, 0x000000522050723cULL, 0x000fec0000001814ULL,
0x000000302814723cULL, 0x000fec00000018ffULL, 0x000000322830723cULL, 0x000fec00000018ffULL,
0x0000002e2828723cULL, 0x000fe200000018ffULL, 0x000000002c2c783bULL, 0x000eea0000000200ULL,
0x00000010204c723cULL, 0x000fec000000184cULL, 0x000000122010723cULL, 0x000fec0000001834ULL,
0x000000182014723cULL, 0x002fe20000001814ULL, 0x000000105d357824ULL, 0x000fe200078e00ffULL,
0x0000000339367819ULL, 0x000fe200000006ffULL, 0x000000045e347836ULL, 0x000fc60000000000ULL,
0xfffffff836697812ULL, 0x000fe200078ee269ULL, 0x000000083c187824ULL, 0x000fe200078e00ffULL,
0xfffffff035357812ULL, 0x000fe200078ee234ULL, 0x000000083a347824ULL, 0x040fe200078e00ffULL,
0x0000006069447211ULL, 0x000fe200078e20ffULL, 0x000000083a3a7824ULL, 0x000fe200078e00ffULL,
0xfffffff818737812ULL, 0x000fe200078ee273ULL, 0x0000001035357824ULL, 0x000fe200078e020aULL,
0x0000001a2018723cULL, 0x000fe20000001830ULL, 0xfffffff8346d7812ULL, 0x000fe200078ee26dULL,
0x000000004444783bULL, 0x000fe20000000200ULL, 0x0000001073547824ULL, 0x000fe200078e0260ULL,
0xfffffff83a637812ULL, 0x000fc400078ee263ULL, 0x000000106d487824ULL, 0x100fe400078e0260ULL,
0x000000083c327824ULL, 0x000fe200078e00ffULL, 0x000000005454783bULL, 0x000fe20000000200ULL,
0x000000105d317824ULL, 0x000fe200078e00ffULL, 0x0000002c201c723cULL, 0x008fe2000000181cULL,
0x000000065e307836ULL, 0x000fe20000000000ULL, 0x00000000353c783bULL, 0x000e620000000200ULL,
0xfffffff8326b7812ULL, 0x000fe200078ee26bULL, 0x0000001063347824ULL, 0x100fe400078e0260ULL,
0xfffffff031317812ULL, 0x000fe200078ee230ULL, 0x00000008392c7824ULL, 0x000fe200078e00ffULL,
0x0000002e2020723cULL, 0x000fe20000001828ULL, 0x000000004848783bULL, 0x000ee20000000200ULL,
0x000000106b387824ULL, 0x000fc400078e0260ULL, 0xfffffff82c617812ULL, 0x000fe200078ee261ULL,
0x000000105f2c7824ULL, 0x000fe200078e0260ULL, 0x000000003434783bULL, 0x000fe20000000200ULL,
0x0000001031667824ULL, 0x000fe400078e020aULL, 0x0000001061307824ULL, 0x000fe200078e0260ULL,
0x000000003838783bULL, 0x000fe80000000200ULL, 0x000000006628783bULL, 0x000fe80000000200ULL,
0x000000002c2c783bULL, 0x000f280000000200ULL, 0x000000003030783bULL, 0x000f620000000200ULL,
0x000000403c1c723cULL, 0x002fec000000181cULL, 0x000000423c20723cULL, 0x000fec0000001820ULL,
0x000000543c24723cULL, 0x000fec0000001824ULL, 0x000000563c50723cULL, 0x000fec0000001850ULL,
0x000000483c4c723cULL, 0x008fec000000184cULL, 0x0000004a3c10723cULL, 0x000fec0000001810ULL,
0x000000443c14723cULL, 0x000fec0000001814ULL, 0x000000463c18723cULL, 0x000fec0000001818ULL,
0x0000002c281c723cULL, 0x010fec000000181cULL, 0x0000002e282c723cULL, 0x000fec0000001820ULL,
0x000000382824723cULL, 0x000fe20000001824ULL, 0x0000000175217836ULL, 0x000fca0000000000ULL,
0x0000000e2100720cULL, 0x000fe20003f06070ULL, 0x0000003a2850723cULL, 0x000fec0000001850ULL,
0x00000034284c723cULL, 0x000fec000000184cULL, 0x000000362810723cULL, 0x000fec0000001810ULL,
0x000000302814723cULL, 0x020fe20000001814ULL, 0x000000040d667c24ULL, 0x004fca000f8e02ffULL,
0x000000322818723cULL, 0x000fe20000001818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000c009c8947ULL, 0x000fde0003800000ULL, 0x0000000875357211ULL, 0x000fe200078e40ffULL,
0x0000000c00287836ULL, 0x000fe40000000000ULL, 0x0000001400427836ULL, 0x000fe20000000000ULL,
0x000000355a227248ULL, 0x000fe20007fe0000ULL, 0x0000000128497824ULL, 0x040fe400078e0209ULL,
0x00000008282a7824ULL, 0x000fe400078e00ffULL, 0x0000000122357824ULL, 0x000fe400078e0a35ULL,
0x0000001000227836ULL, 0x000fe20000000000ULL, 0xfffffff82a497812ULL, 0x000fe200078ee249ULL,
0x00000018004a7836ULL, 0x000fe20000000000ULL, 0x000000352800720cULL, 0x000fe20003f66070ULL,
0x0000000122477824ULL, 0x140fe200078e0209ULL, 0x00000003222a7819ULL, 0x000fe200000006ffULL,
0x0000000142457824ULL, 0x000fc400078e0209ULL, 0x0000000842307824ULL, 0x000fe200078e00ffULL,
0xfffffff82a477812ULL, 0x000fe200078ee247ULL, 0x00000020002a7836ULL, 0x000fe40000000000ULL,
0x000000014a437824ULL, 0x140fe200078e0209ULL, 0xfffffff830457812ULL, 0x000fe200078ee245ULL,
0x000000084a347824ULL, 0x000fe400078e00ffULL, 0x000000012a417824ULL, 0x040fe400078e0209ULL,
0x000000082a367824ULL, 0x000fe200078e00ffULL, 0xfffffff834437812ULL, 0x000fe200078ee243ULL,
0x0000001c00307836ULL, 0x000fc40000000000ULL, 0x00000024003e7836ULL, 0x000fe20000000000ULL,
0xfffffff836417812ULL, 0x000fe200078ee241ULL, 0x0000000830347824ULL, 0x000fe200078e00ffULL,
0x00000009302b7210ULL, 0x000fe20007ffe0ffULL, 0x000000010b297824ULL, 0x000fe200078e0200ULL,
0x0000006043437211ULL, 0x000fe200078e20ffULL, 0x0000000400207836ULL, 0x000fe20000000000ULL,
0xfffffff8342b7812ULL, 0x000fe200078ee22bULL, 0x0000002c00367836ULL, 0x000fe20000000000ULL,
0x0000006629297210ULL, 0x000fe20007f1e0ffULL, 0x000000013e3f7824ULL, 0x000fe200078e0209ULL,
0x000000352000720cULL, 0x000fe20003fa6070ULL, 0x000000083e387824ULL, 0x000fc400078e00ffULL,
0x00000028003c7836ULL, 0x000fe40000000000ULL, 0x0000000120487824ULL, 0x140fe200078e0209ULL,
0xfffffff8383f7812ULL, 0x000fe200078ee23fULL, 0x0000000820217824ULL, 0x000fe200078e00ffULL,
0x000000093c3d7210ULL, 0x000fe20007ffe0ffULL, 0x00000001363b7824ULL, 0x040fe400078e0209ULL,
0x00000008363a7824ULL, 0x000fe200078e00ffULL, 0xfffffff821487812ULL, 0x000fe200078ee248ULL,
0x000000083c347824ULL, 0x000fc400078e00ffULL, 0x0000000800327836ULL, 0x000fe20000000000ULL,
0xfffffff83a3b7812ULL, 0x000fe200078ee23bULL, 0x0000003000387836ULL, 0x000fe20000000000ULL,
0xfffffff8343d7812ULL, 0x000fe200078ee23dULL, 0x000000ffff407224ULL, 0x000fe200000e06ffULL,
0x00000034003a7810ULL, 0x000fe20007ffe0ffULL, 0x000000010b217824ULL, 0x000fe200078e0220ULL,
0x0000000829317c11ULL, 0x040fe2000f8040ffULL, 0x0000000832237824ULL, 0x000fe200078e00ffULL,
0x0000000932467210ULL, 0x000fe20007ffe0ffULL, 0x0000000138397824ULL, 0x140fe200078e0209ULL,
0x0000000929297c11ULL, 0x000fe200080f4440ULL, 0x0000000838347824ULL, 0x000fe200078e00ffULL,
0x0000006621217210ULL, 0x000fe20007f1e0ffULL, 0x000000013a377824ULL, 0x140fe200078e0209ULL,
0xfffffff823467812ULL, 0x000fe200078ee246ULL, 0x000000083a447824ULL, 0x000fe200078e00ffULL,
0xfffffff834397812ULL, 0x000fe200078ee239ULL, 0x000000010b4b7824ULL, 0x000fe200078e0228ULL,
0x000000320b237210ULL, 0x000fe20007ffe0ffULL, 0x0000003800347836ULL, 0x000fe20000000000ULL,
0x000000353200720cULL, 0x080fe20003f86070ULL, 0x000000ffff327224ULL, 0x000fe200000e06ffULL,
0xfffffff844377812ULL, 0x000fe200078ee237ULL, 0x0000000134337824ULL, 0x140fe200078e0209ULL,
0x0000000821207c11ULL, 0x000fe2000f8040ffULL, 0x0000000834547824ULL, 0x000fe200078e00ffULL,
0x0000006623237210ULL, 0x000fe20007f3e0ffULL, 0x000000010b567824ULL, 0x000fe200078e0222ULL,
0x000000664b447210ULL, 0x000fe20007f5e0ffULL, 0x0000000100577824ULL, 0x000fe200078e0209ULL,
0x0000000921217c11ULL, 0x000fe200080f4432ULL, 0x0000001009327824ULL, 0x000fe200078e00ffULL,
0xfffffff854337812ULL, 0x000fe200078ee233ULL, 0x000000ffff287224ULL, 0x000fe200008e06ffULL,
0x0000000844547c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff4b7224ULL, 0x000fe200010e06ffULL,
0x0000000823557c11ULL, 0x000fe2000f8040ffULL, 0x000000010b407824ULL, 0x000fe200078e0242ULL,
0x0000007032327812ULL, 0x000fe200078ec0ffULL, 0x0000001047477824ULL, 0x100fe200078e0260ULL,
0x0000000944447c11ULL, 0x000fe200088f444bULL, 0x0000001045457824ULL, 0x100fe200078e0260ULL,
0x0000006656567210ULL, 0x000fe20007f3e0ffULL, 0x0000001041417824ULL, 0x100fe200078e0260ULL,
0x000000350000720cULL, 0x000fe20003f46070ULL, 0x000000103b3b7824ULL, 0x000fe200078e0260ULL,
0x0000000923237c11ULL, 0x000fe200080f4428ULL, 0x0000001039397824ULL, 0x100fe200078e0260ULL,
0x0000003132287210ULL, 0x000fe20007f1e0ffULL, 0x0000001037377824ULL, 0x000fe200078e0260ULL,
0x0000000762577812ULL, 0x000fc400078ef857ULL, 0x000000ffff317210ULL, 0x000fe20000ffe4ffULL,
0x000000ffff297224ULL, 0x000fe200000e0629ULL, 0x00000008564b7c11ULL, 0x040fe2000f8240ffULL,
0x0000001057687824ULL, 0x000fe200078e0260ULL, 0x0000006640407210ULL, 0x000fe40007fde0ffULL,
0x0000000956317c11ULL, 0x000fe200088f4431ULL, 0x000000010b567824ULL, 0x000fe200078e024aULL,
0x000000352200720cULL, 0x000fe20003f06070ULL, 0x000000ffff227224ULL, 0x000fe200030e06ffULL,
0x0000000840577c11ULL, 0x000fe2000f8240ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028687faeULL, 0x0003e2000d101c46ULL, 0x0000006656567210ULL, 0x000fc40007f5e0ffULL,
0x0000002032207210ULL, 0x000fe40007fde0ffULL, 0x0000000940407c11ULL, 0x000fe200088f4422ULL,
0x000000ffff627224ULL, 0x000fe200010e06ffULL, 0x0000005532227210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff217224ULL, 0x000fe200030e0621ULL, 0x0000000856557c11ULL, 0x000fe4000f8c40ffULL,
0x000000354a00720cULL, 0x080fe20003f46070ULL, 0x000000ffff237224ULL, 0x000fe200008e0623ULL,
0x0000006048687211ULL, 0x002fe200078e20ffULL, 0x000000010b297824ULL, 0x040fe200078e0230ULL,
0x000000354200720cULL, 0x000fe20003f26070ULL, 0x000000010b4a7824ULL, 0x000fe200078e022aULL,
0x0000000956427c11ULL, 0x000fe2000b0f4462ULL, 0x0000001046567824ULL, 0x000fe200078e0260ULL,
0x0000000020687faeULL, 0x0003e2000e901c46ULL, 0x0000006629487210ULL, 0x000fc40007fbe0ffULL,
0x000000664a4a7210ULL, 0x000fe20007fde0ffULL, 0x0000000022567faeULL, 0x0005e2000e101c46ULL,
0x0000005432287210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff547224ULL, 0x000fe200028e06ffULL,
0x0000000848467c11ULL, 0x000fc6000f8a40ffULL, 0x000000ffff297224ULL, 0x000fe200020e0644ULL,
0x0000000948447c11ULL, 0x000fe2000a8f4454ULL, 0x0000001049547824ULL, 0x100fe200078e0260ULL,
0x0000003e0b497210ULL, 0x000fe20007ffe0ffULL, 0x000000ffff217224ULL, 0x002fe200030e06ffULL,
0x000000084a487c11ULL, 0x000fe4000f8a40ffULL, 0x000000353000720cULL, 0x000fe20003f86070ULL,
0x0000000028547faeULL, 0x0003e2000d901c46ULL, 0x0000006649207210ULL, 0x000fe40007fde0ffULL,
0x0000004b32307210ULL, 0x000fe20007f7e0ffULL, 0x000000102b4b7824ULL, 0x000fe200078e0260ULL,
0x000000094a4a7c11ULL, 0x000fe2000a8f4421ULL, 0x000000ffff217224ULL, 0x000fe200030e06ffULL,
0x0000005732227210ULL, 0x004fe20007fbe0ffULL, 0x000000ffff317224ULL, 0x000fe200018e0631ULL,
0x0000000820497c11ULL, 0x000fc4000f8640ffULL, 0x000000352a00720cULL, 0x080fe20003fc6070ULL,
0x000000ffff237224ULL, 0x000fe200028e0640ULL, 0x000000353e00720cULL, 0x000fe20003fa6070ULL,
0x0000000030477faeULL, 0x0005e2000c101c46ULL, 0x00000009203e7c11ULL, 0x000fe400098f4421ULL,
0x0000005532207210ULL, 0x000fe20007f1e0ffULL, 0x0000000022457faeULL, 0x0007e2000c901c46ULL,
0x0000004632287210ULL, 0x002fe20007f3e0ffULL, 0x000000010b557824ULL, 0x000fe400078e0234ULL,
0x000000ffff217224ULL, 0x000fe200000e0642ULL, 0x00000048322a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff297224ULL, 0x000fc400008e0644ULL, 0x0000003c00307836ULL, 0x004fe20000000000ULL,
0x0000000020437faeULL, 0x0003e2000d101c46ULL, 0x000000ffff2b7224ULL, 0x000fe200000e064aULL,
0x0000003c0b237210ULL, 0x008fe20007ffe0ffULL, 0x0000000130227824ULL, 0x040fe200078e0209ULL,
0x00000000284b7faeULL, 0x0005e2000e101c46ULL, 0x000000010b317824ULL, 0x040fe400078e0236ULL,
0x000000010b457824ULL, 0x040fe200078e0238ULL, 0x000000002a417faeULL, 0x0007e2000f101c46ULL,
0x0000006623407210ULL, 0x000fe20007fde0ffULL, 0x000000010b477824ULL, 0x040fe200078e023aULL,
0x0000000330437819ULL, 0x002fe200000006ffULL, 0x000000010b577824ULL, 0x000fe200078e0230ULL,
0x0000004932207210ULL, 0x000fc40007f7e0ffULL, 0x0000006631237210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff317224ULL, 0x000fe200030e06ffULL, 0xfffffff843297812ULL, 0x004fe200078ee222ULL,
0x000000ffff217224ULL, 0x000fe200018e063eULL, 0x0000006655287210ULL, 0x000fe20007f5e0ffULL,
0x000000103f437824ULL, 0x000fe200078e0260ULL, 0x0000000840417c11ULL, 0x008fe2000f8c40ffULL,
0x000000ffff3e7224ULL, 0x000fe200020e06ffULL, 0x00000066452b7210ULL, 0x000fe40007f1e0ffULL,
0x0000000020437faeULL, 0x0003e2000e901c46ULL, 0x000000353c00720cULL, 0x000fc40003fa6070ULL,
0x0000000940407c11ULL, 0x000fe2000b0f4431ULL, 0x000000ffff3c7224ULL, 0x000fe200000e06ffULL,
0x0000000823317c11ULL, 0x040fe4000f8840ffULL, 0x0000004132227210ULL, 0x000fe40007fde0ffULL,
0x00000009233e7c11ULL, 0x000fe4000a0f443eULL, 0x00000066472a7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff237224ULL, 0x000fe200030e0640ULL, 0x000000603d417211ULL, 0x000fc400078e20ffULL,
0x000000082b3f7c11ULL, 0x040fe2000f8040ffULL, 0x000000ffff217224ULL, 0x002fe200008e06ffULL,
0x000000353600720cULL, 0x080fe20003f86070ULL, 0x0000000022417faeULL, 0x0003e2000e901c46ULL,
0x000000353800720cULL, 0x000fe40003fc6070ULL, 0x000000092b387c11ULL, 0x000fe200080f443cULL,
0x000000ffff2b7224ULL, 0x000fe200010e06ffULL, 0x000000082a3d7c11ULL, 0x000fe4000f8040ffULL,
0x0000003132207210ULL, 0x000fc40007fbe0ffULL, 0x000000092a367c11ULL, 0x000fe400080f4421ULL,
0x0000006657667210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff217224ULL, 0x000fe200028e063eULL,
0x0000000828317c11ULL, 0x000fe4000f8040ffULL, 0x000000353000720cULL, 0x080fe40003f46070ULL,
0x00000000203b7faeULL, 0x0005e2000e101c46ULL, 0x0000003f32227210ULL, 0x002fe40007f9e0ffULL,
0x000000353a00720cULL, 0x000fc40003f26070ULL, 0x000000353400720cULL, 0x000fe20003fa6070ULL,
0x000000ffff237224ULL, 0x000fe200020e0638ULL, 0x0000000928307c11ULL, 0x000fe200080f442bULL,
0x000000ffff2b7224ULL, 0x000fe200018e06ffULL, 0x0000006033357211ULL, 0x000fe400078e20ffULL,
0x0000000866337c11ULL, 0x000fe2000f8040ffULL, 0x0000000022397faeULL, 0x0005e2000f101c46ULL,
0x0000003d32287210ULL, 0x000fe20007f9e0ffULL, 0x00000010293d7824ULL, 0x000fe200078e0260ULL,
0x00000031322a7210ULL, 0x000fc40007f7e0ffULL, 0x0000000966667c11ULL, 0x000fe200080f442bULL,
0x000000ffff297224ULL, 0x000fe200020e0636ULL, 0x0000003332327210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff2b7224ULL, 0x000fc600018e0630ULL, 0x0000000028377faeULL, 0x0005e2000c901c46ULL,
0x000000ffff337224ULL, 0x000fc600000e0666ULL, 0x000000002a357faeULL, 0x0005e8000e901c46ULL,
0x00000000323d7faeULL, 0x0005e2000d101c46ULL, 0x0000000c004c7947ULL, 0x000fea0003800000ULL,
0x0000000c00327836ULL, 0x000fe20000000000ULL, 0x0000000400347810ULL, 0x000fe20007ffe0ffULL,
0x0000000800367836ULL, 0x000fe40000000000ULL, 0x0000000132317824ULL, 0x140fe400078e0209ULL,
0x0000000832227824ULL, 0x000fe200078e00ffULL, 0x00000009362b7210ULL, 0x000fe20007ffe0ffULL,
0x0000000836207824ULL, 0x000fe400078e00ffULL, 0x0000001400307836ULL, 0x000fe20000000000ULL,
0xfffffff822317812ULL, 0x000fe200078ee231ULL, 0x0000002c00467836ULL, 0x000fe20000000000ULL,
0xfffffff8202b7812ULL, 0x000fe200078ee22bULL, 0x0000000130357824ULL, 0x140fe200078e0209ULL,
0x0000001800227810ULL, 0x000fe20007ffe0ffULL, 0x0000000830207824ULL, 0x000fe200078e00ffULL,
0x0000006031317211ULL, 0x000fe200078e20ffULL, 0x0000000146577824ULL, 0x000fc400078e0209ULL,
0x0000000122457824ULL, 0x140fe200078e0209ULL, 0xfffffff820357812ULL, 0x000fe200078ee235ULL,
0x00000008223a7824ULL, 0x000fe400078e00ffULL, 0x0000002000207836ULL, 0x000fe40000000000ULL,
0x0000003800547836ULL, 0x000fe20000000000ULL, 0xfffffff83a457812ULL, 0x000fe200078ee245ULL,
0x0000000120497824ULL, 0x140fe400078e0209ULL, 0x00000008203a7824ULL, 0x000fe200078e00ffULL,
0x0000000954237210ULL, 0x000fe20007ffe0ffULL, 0x0000000134387824ULL, 0x000fc400078e0209ULL,
0x0000000834217824ULL, 0x000fe200078e00ffULL, 0xfffffff83a497812ULL, 0x000fe200078ee249ULL,
0x0000001000287836ULL, 0x000fe20000000000ULL, 0x00000003463a7819ULL, 0x000fe200000006ffULL,
0x000000010b377824ULL, 0x040fe200078e0234ULL, 0xfffffff821387812ULL, 0x000fe200078ee238ULL,
0x000000010b3b7824ULL, 0x040fe200078e0236ULL, 0xfffffff83a577812ULL, 0x000fe200078ee257ULL,
0x00000008543a7824ULL, 0x000fe400078e00ffULL, 0x0000000128337824ULL, 0x140fe200078e0209ULL,
0x000000663b367210ULL, 0x000fe20007f5e0ffULL, 0x00000008282a7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a237812ULL, 0x000fe200078ee223ULL, 0x000000010b217824ULL, 0x000fe200078e0200ULL,
0x00000066373a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000100297824ULL, 0x100fe200078e0209ULL,
0xfffffff82a337812ULL, 0x000fe200078ee233ULL, 0x0000001c002a7836ULL, 0x000fe20000000000ULL,
0x0000006621217210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff3b7224ULL, 0x000fe200008e06ffULL,
0x000000083a447c11ULL, 0x000fe2000f8240ffULL, 0x000000ffff3f7224ULL, 0x000fe200010e06ffULL,
0x0000000762297812ULL, 0x000fe200078ef829ULL, 0x000000012a477824ULL, 0x000fe200078e0209ULL,
0x0000000836427c11ULL, 0x000fe2000f8440ffULL, 0x0000002800567836ULL, 0x000fe20000000000ULL,
0x000000032a3c7819ULL, 0x000fe200000006ffULL, 0x0000002400627836ULL, 0x000fe20000000000ULL,
0x000000093a3a7c11ULL, 0x000fe200088f443bULL, 0x000000ffff347224ULL, 0x000fe200000e06ffULL,
0x0000000821377c11ULL, 0x000fe2000f8040ffULL, 0x0000000156557824ULL, 0x040fe200078e0209ULL,
0x000000320b3b7210ULL, 0x000fe20007ffe0ffULL, 0x00000008563e7824ULL, 0x000fe200078e00ffULL,
0x0000000936367c11ULL, 0x000fe200090f443fULL, 0x00000001624b7824ULL, 0x140fe200078e0209ULL,
0xfffffff83c477812ULL, 0x000fe200078ee247ULL, 0x000000010b3f7824ULL, 0x000fe200078e0228ULL,
0x00000003623c7819ULL, 0x000fe200000006ffULL, 0x00000034004a7836ULL, 0x000fe20000000000ULL,
0x0000000921217c11ULL, 0x000fe200080f4434ULL, 0x000000010b417824ULL, 0x040fe200078e0230ULL,
0x000000663b3b7210ULL, 0x000fe20007f1e0ffULL, 0x0000003000487836ULL, 0x000fe20000000000ULL,
0xfffffff83e557812ULL, 0x000fe200078ee255ULL, 0x000000014a397824ULL, 0x140fe200078e0209ULL,
0xfffffff83c4b7812ULL, 0x000fe200078ee24bULL, 0x000000084a3e7824ULL, 0x000fe200078e00ffULL,
0x000000663f3f7210ULL, 0x000fe20007f3e0ffULL, 0x00000001483d7824ULL, 0x040fe200078e0209ULL,
0x0000006641417210ULL, 0x000fe20007f5e0ffULL, 0x00000008483c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83e397812ULL, 0x000fe200078ee239ULL, 0x000000010b437824ULL, 0x000fe200078e0222ULL,
0x0000000409347819ULL, 0x000fe200000006ffULL, 0x000000ffff227224ULL, 0x000fe200000e06ffULL,
0x000000083b407c11ULL, 0x000fe2000f8040ffULL, 0x000000ffff287224ULL, 0x000fe200008e06ffULL,
0xfffffff83c3d7812ULL, 0x000fe200078ee23dULL, 0x000000ffff307224ULL, 0x000fe200010e06ffULL,
0x000000083f3e7c11ULL, 0x000fe2000f8240ffULL, 0x000000010b207824ULL, 0x000fe200078e0220ULL,
0x00000008413c7c11ULL, 0x000fe2000f8440ffULL, 0x000000010b567824ULL, 0x000fe200078e0256ULL,
0x000000093b3b7c11ULL, 0x000fe200080f4422ULL, 0x000000010b467824ULL, 0x040fe200078e0246ULL,
0x0000006643327210ULL, 0x000fe20007f1e0ffULL, 0x000000010b487824ULL, 0x000fe200078e0248ULL,
0x000000093f227c11ULL, 0x000fe200088f4428ULL, 0x000000010b4a7824ULL, 0x000fe200078e024aULL,
0x0000000941287c11ULL, 0x000fe200090f4430ULL, 0x000000010b417824ULL, 0x000fe200078e022aULL,
0x0000007034347812ULL, 0x000fe200078ec0ffULL, 0x000000ffff3f7224ULL, 0x000fe200000e06ffULL,
0x0000000832437c11ULL, 0x000fe2000f8040ffULL, 0x0000001038387824ULL, 0x100fe200078e0260ULL,
0x0000006641307210ULL, 0x000fe20007f3e0ffULL, 0x000000102b2b7824ULL, 0x100fe200078e0260ULL,
0x00000009322a7c11ULL, 0x000fe200080f443fULL, 0x0000001033337824ULL, 0x100fe200078e0260ULL,
0x0000006620327210ULL, 0x000fe20007f5e0ffULL, 0x0000001035357824ULL, 0x000fe200078e0260ULL,
0x0000003734207210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff377224ULL, 0x000fe200008e06ffULL,
0x0000000830417c11ULL, 0x040fe2000f8240ffULL, 0x000000ffff687224ULL, 0x000fe200010e06ffULL,
0x0000006029297211ULL, 0x080fe200078e20ffULL, 0x000000ffff217224ULL, 0x000fe200000e0621ULL,
0x0000000930307c11ULL, 0x000fe200088f4437ULL, 0x000000010b377824ULL, 0x000fe200078e0262ULL,
0x00000008323f7c11ULL, 0x040fe2000f8040ffULL, 0x0000001045457824ULL, 0x100fe200078e0260ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020297faeULL, 0x0003e2000b901c46ULL,
0x000000540b627210ULL, 0x000fe20007ffe0ffULL, 0x0000001047477824ULL, 0x000fe200078e0260ULL,
0x0000000932327c11ULL, 0x000fe200080f4468ULL, 0x0000003c00687836ULL, 0x000fe20000000000ULL,
0x0000006648547210ULL, 0x000fe20007f5e0ffULL, 0x0000001023487824ULL, 0x000fe200078e0260ULL,
0x000000664a4a7210ULL, 0x000fe20007f7e0ffULL, 0x000000010b6a7824ULL, 0x000fe200078e0268ULL,
0x0000006055557211ULL, 0x000fe200078e20ffULL, 0x00000001686e7824ULL, 0x040fe200078e0209ULL,
0x0000006637297210ULL, 0x002fe20007f9e0ffULL, 0x0000000868687824ULL, 0x000fe200078e00ffULL,
0x0000006656377210ULL, 0x000fe20007f1e0ffULL, 0x0000001049497824ULL, 0x100fe200078e0260ULL,
0x00000008296c7c11ULL, 0x000fe2000f8c40ffULL, 0x000000ffff207224ULL, 0x000fe200020e06ffULL,
0x0000006646567210ULL, 0x000fe20007f3e0ffULL, 0x000000104b4b7824ULL, 0x100fe200078e0260ULL,
0x0000006662627210ULL, 0x000fe20007f9e0ffULL, 0x0000001057577824ULL, 0x000fe200078e0260ULL,
0x0000000929297c11ULL, 0x000fe2000b0f4420ULL, 0x0000001039467824ULL, 0x100fe200078e0260ULL,
0x000000666a667210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff6a7224ULL, 0x000fe200000e06ffULL,
0x0000004434207210ULL, 0x000fe20007fde0ffULL, 0x000000103d447824ULL, 0x000fe200078e0260ULL,
0x00000008373d7c11ULL, 0x000fc4000f8040ffULL, 0xfffffff868687812ULL, 0x000fe200078ee26eULL,
0x000000ffff217224ULL, 0x000fe200030e063aULL, 0x0000000937237c11ULL, 0x000fe200080f446aULL,
0x000000ffff3a7224ULL, 0x000fe200008e06ffULL, 0x00000008566a7c11ULL, 0x000fe2000f8040ffULL,
0x000000ffff6e7224ULL, 0x000fe200018e06ffULL, 0x0000006068607211ULL, 0x000fe200078e20ffULL,
0x000000ffff687224ULL, 0x000fe200010e06ffULL, 0x0000000854397c11ULL, 0x000fe2000f8240ffULL,
0x0000000020387faeULL, 0x0003e2000b901c46ULL, 0x000000084a377c11ULL, 0x000fc4000f8440ffULL,
0x0000000956567c11ULL, 0x000fe200080f443aULL, 0x000000ffff3a7224ULL, 0x000fe200020e06ffULL,
0x0000000954547c11ULL, 0x000fe400088f4468ULL, 0x000000094a4a7c11ULL, 0x000fe400090f446eULL,
0x0000000866687c11ULL, 0x000fe4000f8240ffULL, 0x0000004234427210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff207224ULL, 0x002fe200028e06ffULL, 0x0000000862217c11ULL, 0x000fc4000f8040ffULL,
0x0000004034407210ULL, 0x000fe40007f7e0ffULL, 0x0000000962627c11ULL, 0x000fe400080f443aULL,
0x0000003e343e7210ULL, 0x000fe40007f9e0ffULL, 0x00000043343a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff437224ULL, 0x000fe200010e0636ULL, 0x0000000966667c11ULL, 0x000fe400088f4420ULL,
0x0000003c343c7210ULL, 0x000fc40007fbe0ffULL, 0x0000004134387210ULL, 0x000fe20007f3e0ffULL,
0x00000000422b7faeULL, 0x0003e2000b901c46ULL, 0x0000003f34367210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff3f7224ULL, 0x000fe200020e0622ULL, 0x0000003bff417210ULL, 0x000fe20001ffe4ffULL,
0x000000ffff3b7224ULL, 0x000fe200000e062aULL, 0x0000006c34207210ULL, 0x000fe40007f7e0ffULL,
0x0000003d34227210ULL, 0x000fe20007f9e0ffULL, 0x000000ffff3d7224ULL, 0x000fe200028e0628ULL,
0x00000039342a7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff397224ULL, 0x000fe200008e0630ULL,
0x0000006a34287210ULL, 0x000fe20007fbe0ffULL, 0x0000000040317faeULL, 0x0005e2000b901c46ULL,
0x0000003734307210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff377224ULL, 0x000fe200010e0632ULL,
0x0000002134327210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff217224ULL, 0x000fe200018e0629ULL,
0x000000003e337faeULL, 0x0007e2000b901c46ULL, 0x0000006834347210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff297224ULL, 0x000fe200028e0656ULL, 0x00000023ff237210ULL, 0x000fe200027fe4ffULL,
0x000000003c357faeULL, 0x0009e2000b901c46ULL, 0x000000ffff2b7224ULL, 0x002fc400000e0654ULL,
0x000000ffff317224ULL, 0x004fe200008e064aULL, 0x000000003a457faeULL, 0x0003e8000b901c46ULL,
0x0000000038477faeULL, 0x0003e2000b901c46ULL, 0x000000ffff337224ULL, 0x008fc600010e0662ULL,
0x0000000036497faeULL, 0x0003e2000b901c46ULL, 0x000000ffff357224ULL, 0x010fc600018e0666ULL,
0x00000000204b7faeULL, 0x0003e8000b901c46ULL, 0x0000000022557faeULL, 0x0003e8000b901c46ULL,
0x0000000028577faeULL, 0x0003e8000b901c46ULL, 0x000000002a447faeULL, 0x0003e8000b901c46ULL,
0x0000000030467faeULL, 0x0003e8000b901c46ULL, 0x0000000032487faeULL, 0x0003e8000b901c46ULL,
0x0000000034607faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000085e207836ULL, 0x006fe20000000000ULL, 0x000000045d217819ULL, 0x040fe200000006ffULL,
0x00000010643c7824ULL, 0x100fe200078e025cULL, 0x000000045d297819ULL, 0x000fe200000006ffULL,
0x000000107d407824ULL, 0x100fe200078e025cULL, 0xfffffff021217812ULL, 0x000fe200078ee220ULL,
0x0000001079307824ULL, 0x000fe200078e025cULL, 0x0000005c65547211ULL, 0x000fe200078e20ffULL,
0x0000000a5e287836ULL, 0x000fe40000000000ULL, 0x0000001021387824ULL, 0x000fc400078e020aULL,
0x000000107b207824ULL, 0x100fe200078e025cULL, 0xfffffff029297812ULL, 0x000fe200078ee228ULL,
0x0000001077347824ULL, 0x100fe400078e025cULL, 0x0000001067677824ULL, 0x000fe400078e025cULL,
0x0000001029297824ULL, 0x000fe400078e020aULL, 0x0000001073737824ULL, 0x000fe400078e025cULL,
0x000000105d457824ULL, 0x000fe200078e00ffULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000003c3c783bULL, 0x000fe20000000200ULL, 0x000000106b487824ULL, 0x000fc600078e025cULL,
0x000000003838783bULL, 0x000e680000000200ULL, 0x000000004040783bULL, 0x000ea80000000200ULL,
0x000000003030783bULL, 0x000ee80000000200ULL, 0x000000002020783bULL, 0x000f280000000200ULL,
0x000000003434783bULL, 0x000fe80000000200ULL, 0x000000002928783bULL, 0x000f680000000200ULL,
0x000000005454783bULL, 0x000fe80000000200ULL, 0x000000004848783bULL, 0x000fe20000000200ULL,
0x0000003c3824723cULL, 0x002fec0000001824ULL, 0x0000003e3850723cULL, 0x000fe20000001850ULL,
0x00000010713c7824ULL, 0x000fca00078e025cULL, 0x00000040384c723cULL, 0x004fe2000000184cULL,
0x000000003c3c783bULL, 0x000e6a0000000200ULL, 0x00000030381c723cULL, 0x008fe2000000181cULL,
0x000000105d407824ULL, 0x000fca00078e00ffULL, 0x000000203814723cULL, 0x010fe20000001814ULL,
0x0000000c5e317836ULL, 0x000fe20000000000ULL, 0x0000005c6f307211ULL, 0x000fe200078e20ffULL,
0x0000000e5e5e7836ULL, 0x000fc60000000000ULL, 0xfffffff040417812ULL, 0x000fe200078ee231ULL,
0x000000423810723cULL, 0x000fe20000001810ULL, 0xfffffff045457812ULL, 0x000fc600078ee25eULL,
0x0000001041417824ULL, 0x100fe400078e020aULL, 0x000000223820723cULL, 0x000fe20000001818ULL,
0x0000001045457824ULL, 0x000fe200078e020aULL, 0x000000006718783bULL, 0x000ea80000000200ULL,
0x00000032382c723cULL, 0x000fe2000000182cULL, 0x000000004140783bULL, 0x000fe80000000200ULL,
0x000000003030783bULL, 0x000ee20000000200ULL, 0x000000342838723cULL, 0x020fe60000001824ULL,
0x000000007324783bULL, 0x000f260000000200ULL, 0x0000003c284c723cULL, 0x002fe2000000184cULL,
0x000000106d347824ULL, 0x100fe200078e025cULL, 0x000000004544783bULL, 0x000fe80000000200ULL,
0x000000362850723cULL, 0x000fe20000001850ULL, 0x00000010693c7824ULL, 0x100fe200078e025cULL,
0x000000003434783bULL, 0x000e680000000200ULL, 0x0000003e2810723cULL, 0x000fe20000001810ULL,
0x000000003c3c783bULL, 0x000f6a0000000200ULL, 0x000000182814723cULL, 0x004fec0000001814ULL,
0x0000001a2820723cULL, 0x000fe20000001820ULL, 0x0000001063187824ULL, 0x000fca00078e025cULL,
0x00000030281c723cULL, 0x008fe2000000181cULL, 0x000000001818783bULL, 0x000eaa0000000200ULL,
0x00000032282c723cULL, 0x000fec000000182cULL, 0x000000244038723cULL, 0x010fe20000001838ULL,
0x0000001061287824ULL, 0x000fca00078e025cULL, 0x000000264050723cULL, 0x000fe20000001850ULL,
0x000000105f247824ULL, 0x000fe200078e025cULL, 0x000000002828783bULL, 0x000ee80000000200ULL,
0x00000034404c723cULL, 0x002fe2000000184cULL, 0x000000002424783bULL, 0x000e6a0000000200ULL,
0x0000003c4014723cULL, 0x020fec0000001814ULL, 0x0000003e4020723cULL, 0x000fec0000001820ULL,
0x000000364010723cULL, 0x000fec0000001810ULL, 0x00000054401c723cULL, 0x000fec000000181cULL,
0x00000056402c723cULL, 0x000fec000000182cULL, 0x00000018444c723cULL, 0x004fec000000184cULL,
0x000000284414723cULL, 0x008fe20000001814ULL, 0x00000001ff187424ULL, 0x000fca00078e00ffULL,
0x0000002a4420723cULL, 0x000fe20000001820ULL, 0x01b68818071879a7ULL, 0x000eaa000850003fULL,
0x000000484438723cULL, 0x000fec0000001838ULL, 0x0000004a4450723cULL, 0x000fe20000001850ULL,
0x3db504f34c4c7820ULL, 0x000fe20000410000ULL, 0x3db504f34d4d7820ULL, 0x000fe20000410000ULL,
0x3db504f34e4e7820ULL, 0x000fe20000410000ULL, 0x3db504f34f4f7820ULL, 0x000fc40000410000ULL,
0x0000001a4410723cULL, 0x000fe20000001810ULL, 0x3db504f314147820ULL, 0x000fe20000410000ULL,
0x3db504f315157820ULL, 0x000fc80000410000ULL, 0x00000024441c723cULL, 0x002fe2000000181cULL,
0x3db504f3161a7820ULL, 0x000fe20000410000ULL, 0x3db504f320167820ULL, 0x000fe20000410000ULL,
0x3db504f322227820ULL, 0x000fc60000410000ULL, 0x00000026442c723cULL, 0x000fe2000000182cULL,
0x3db504f317247820ULL, 0x000fe20000410000ULL, 0x3db504f321177820ULL, 0x000fe20000410000ULL,
0x3db504f323257820ULL, 0x000fe20000410000ULL, 0x3db504f3381b7820ULL, 0x000fe20000410000ULL,
0x3db504f339397820ULL, 0x000fe20000410000ULL, 0x3db504f33a3a7820ULL, 0x000fe20000410000ULL,
0x3db504f33b3b7820ULL, 0x000fe20000410000ULL, 0x3db504f350507820ULL, 0x000fe20000410000ULL,
0x3db504f351517820ULL, 0x000fe20000410000ULL, 0x3db504f352527820ULL, 0x000fe20000410000ULL,
0x3db504f353537820ULL, 0x000fe20000410000ULL, 0x3db504f310277820ULL, 0x000fe20000410000ULL,
0x3db504f311297820ULL, 0x000fe20000410000ULL, 0x3db504f312287820ULL, 0x000fe20000410000ULL,
0x3db504f313267820ULL, 0x000fc60000410000ULL, 0x3db504f31c1c7820ULL, 0x000fe20000410000ULL,
0x3db504f31d1d7820ULL, 0x000fe20000410000ULL, 0x3db504f31e237820ULL, 0x000fe20000410000ULL,
0x3db504f31f217820ULL, 0x000fc60000410000ULL, 0x3db504f32c2c7820ULL, 0x000fe20000410000ULL,
0x3db504f32d2d7820ULL, 0x000fe20000410000ULL, 0x3db504f32e2e7820ULL, 0x000fe20000410000ULL,
0x3db504f32f2f7820ULL, 0x000fe20000410000ULL, 0x0000000000107805ULL, 0x000fe20000015200ULL,
0x01b68819070075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ff001e7202ULL, 0x000fce0000000f00ULL, 0x000000101e00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x00000012101f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001f12127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000011e1e7836ULL, 0x000fce0000000000ULL, 0x01b68819070075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000409107824ULL, 0x000fe200078e00ffULL,
0x000000055900720cULL, 0x000fe20003f05270ULL, 0x000000805b117824ULL, 0x000fc600078e020aULL,
0xfffffff010107812ULL, 0x000fca00078ec0ffULL, 0x0000000111207824ULL, 0x000fca00078e0210ULL,
0x01b4000020107984ULL, 0x0002a20000000c00ULL, 0x0000000400080947ULL, 0x000fea0003800000ULL,
0x0000000109187819ULL, 0x000fe200000006ffULL, 0x000000015a2a7824ULL, 0x000fc600078e0a03ULL,
0x0000000618187812ULL, 0x000fc800078ec0ffULL, 0x0000000118037812ULL, 0x040fe400078efcffULL,
0x0000000818197812ULL, 0x040fe400078efcffULL, 0x0000002a0300720cULL, 0x080fe40003f26070ULL,
0x0000001018037812ULL, 0x000fe400078efcffULL, 0x0000002a1900720cULL, 0x080fe40003f06070ULL,
0x0000002a0300720cULL, 0x000fc40003fc6070ULL, 0x0000001118197812ULL, 0x040fe400078efcffULL,
0x0000001818037812ULL, 0x040fe400078efcffULL, 0x0000002a1800720cULL, 0x0c0fe40003f46070ULL,
0x0000002a1900720cULL, 0x080fe40003fa6070ULL, 0x0000002a0300720cULL, 0x000fe40003f66070ULL,
0x00000009181e7812ULL, 0x000fc400078efcffULL, 0x0000001918197812ULL, 0x040fe400078efcffULL,
0x0000002018037812ULL, 0x000fe400078efcffULL, 0xff8000003a3a7808ULL, 0x000fe40005000000ULL,
0xff8000001b1b7808ULL, 0x000fe40005000000ULL, 0xff8000003b3b7808ULL, 0x000fe40004800000ULL,
0xff80000039397808ULL, 0x000fc40004800000ULL, 0x0000002a1e00720cULL, 0x080fe40003f86070ULL,
0x0000002a1900720cULL, 0x080fe40003f46070ULL, 0x0000002a0300720cULL, 0x000fe40003f26070ULL,
0x0000002118197812ULL, 0x040fe400078efcffULL, 0x0000002818037812ULL, 0x000fe400078efcffULL,
0xff80000052527808ULL, 0x000fc40004000000ULL, 0xff80000050507808ULL, 0x000fe40004000000ULL,
0xff80000053537808ULL, 0x000fe40006000000ULL, 0xff80000051517808ULL, 0x000fe40006000000ULL,
0x0000002a1900720cULL, 0x080fe40003f06070ULL, 0x0000002a0300720cULL, 0x000fe40003f86070ULL,
0x0000002918197812ULL, 0x000fc400078efcffULL, 0x0000003018037812ULL, 0x000fe400078efcffULL,
0xff8000004e4e7808ULL, 0x000fe40007000000ULL, 0xff8000004c4c7808ULL, 0x000fe40007000000ULL,
0xff8000004f4f7808ULL, 0x000fe40006800000ULL, 0xff8000004d4d7808ULL, 0x000fe40006800000ULL,
0x0000002a1900720cULL, 0x000fc40003fc6070ULL, 0x0000002a0300720cULL, 0x000fe40003fa6070ULL,
0x0000003118197812ULL, 0x040fe400078efcffULL, 0x0000003818037812ULL, 0x040fe400078efcffULL,
0x0000003918187812ULL, 0x000fe400078efcffULL, 0xff80000028287808ULL, 0x000fe40005800000ULL,
0xff80000027277808ULL, 0x000fc40005800000ULL, 0xff80000026267808ULL, 0x000fe40005000000ULL,
0xff80000029297808ULL, 0x000fe40005000000ULL, 0xff8000001a1a7808ULL, 0x000fe40004800000ULL,
0xff80000014147808ULL, 0x000fe40004800000ULL, 0x0000002a1900720cULL, 0x080fe40003f66070ULL,
0x0000002a0300720cULL, 0x000fc40003f46070ULL, 0x0000002a1800720cULL, 0x000fe40003f26070ULL,
0xff80000024247808ULL, 0x000fe40004000000ULL, 0xff80000015157808ULL, 0x000fe40004000000ULL,
0xff80000022227808ULL, 0x000fe40006000000ULL, 0xff80000016167808ULL, 0x000fe40006000000ULL,
0xff80000025257808ULL, 0x000fc40007000000ULL, 0xff80000017177808ULL, 0x000fe40007000000ULL,
0xff80000023237808ULL, 0x000fe40006800000ULL, 0xff8000001c1c7808ULL, 0x000fe40006800000ULL,
0xff80000021217808ULL, 0x000fe40005800000ULL, 0xff8000001d1d7808ULL, 0x000fe40005800000ULL,
0xff8000002e2e7808ULL, 0x000fc40005000000ULL, 0xff8000002c2c7808ULL, 0x000fe40005000000ULL,
0xff8000002f2f7808ULL, 0x000fe40004800000ULL, 0xff8000002d2d7808ULL, 0x000fce0004800000ULL,
0x0000001b1000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff597224ULL, 0x000fe200078e0075ULL,
0xfffffff8ff027812ULL, 0x000fe400078ee202ULL, 0x000000101b107208ULL, 0x000fc80004000000ULL,
0x000000391000720bULL, 0x000fc80003f1e000ULL, 0x0000001039037208ULL, 0x000fc80004000000ULL,
0x000000500300720bULL, 0x000fc80003f1e000ULL, 0x0000000350107208ULL, 0x000fc80004000000ULL,
0x000000511000720bULL, 0x000fc80003f1e000ULL, 0x0000001051037208ULL, 0x000fc80004000000ULL,
0x0000004c0300720bULL, 0x000fc80003f1e000ULL, 0x000000034c107208ULL, 0x000fc80004000000ULL,
0x0000004d1000720bULL, 0x000fc80003f1e000ULL, 0x000000104d107208ULL, 0x000fc80004000000ULL,
0x000000271000720bULL, 0x000fc80003f1e000ULL, 0x0000001027107208ULL, 0x000fc80004000000ULL,
0x000000291000720bULL, 0x000fc80003f1e000ULL, 0x0000001029037208ULL, 0x000fc80004000000ULL,
0x000000140300720bULL, 0x000fc80003f1e000ULL, 0x0000000314107208ULL, 0x000fc80004000000ULL,
0x000000151000720bULL, 0x000fc80003f1e000ULL, 0x0000001015037208ULL, 0x000fc80004000000ULL,
0x000000160300720bULL, 0x000fc80003f1e000ULL, 0x0000000316107208ULL, 0x000fe40004000000ULL,
0x0000003a1100720bULL, 0x000fe40003f1e000ULL, 0x000000171000720bULL, 0x000fc80003f3e000ULL,
0x0000001017037208ULL, 0x000fe40004800000ULL, 0x000000113a107208ULL, 0x000fe40004000000ULL,
0x0000001c0300720bULL, 0x000fe40003f3e000ULL, 0x0000003b1000720bULL, 0x000fe40003f1e000ULL,
0x000000031c187208ULL, 0x000fe40004800000ULL, 0x000000103b037208ULL, 0x000fc40004000000ULL,
0x0000001d1800720bULL, 0x000fe40003f3e000ULL, 0x000000520300720bULL, 0x000fe40003f1e000ULL,
0x000000181d117208ULL, 0x000fe40004800000ULL, 0x0000000352107208ULL, 0x000fe40004000000ULL,
0x0000002c1100720bULL, 0x000fe40003f3e000ULL, 0x000000531000720bULL, 0x000fc40003f1e000ULL,
0x000000112c187208ULL, 0x000fe40004800000ULL, 0x0000001053037208ULL, 0x000fe40004000000ULL,
0x0000002d1800720bULL, 0x000fe40003f3e000ULL, 0x0000004e0300720bULL, 0x000fe40003f1e000ULL,
0x000000182d187208ULL, 0x000fe40004800000ULL, 0x000000034e107208ULL, 0x000fc60004000000ULL,
0x0c401f0018117f89ULL, 0x000ea200000e0000ULL, 0x0000004f1000720bULL, 0x000fc80003f1e000ULL,
0x000000104f037208ULL, 0x000fc80004000000ULL, 0x000000280300720bULL, 0x000fc80003f1e000ULL,
0x0000000328037208ULL, 0x000fc80004000000ULL, 0x000000260300720bULL, 0x000fc80003f1e000ULL,
0x0000000326037208ULL, 0x000fe40004000000ULL, 0x000000111800720bULL, 0x004fe40003f3e000ULL,
0x0000001a0300720bULL, 0x000fe40003f1e000ULL, 0x0000001811117208ULL, 0x000fe40004800000ULL,
0x000000031a037208ULL, 0x000fc60004000000ULL, 0x0c201f00111e7f89ULL, 0x000ea200000e0000ULL,
0x000000240300720bULL, 0x000fc80003f1e000ULL, 0x0000000324037208ULL, 0x000fc80004000000ULL,
0x000000220300720bULL, 0x000fc80003f1e000ULL, 0x0000000322107208ULL, 0x000fc80004000000ULL,
0x000000251000720bULL, 0x000fc80003f1e000ULL, 0x0000001025187208ULL, 0x000fe40004000000ULL,
0x0000001e1100720bULL, 0x004fe40003f3e000ULL, 0x000000231800720bULL, 0x000fe40003f1e000ULL,
0x000000111e107208ULL, 0x000fe40004800000ULL, 0x0000001823187208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b101e7820ULL, 0x000fe20000410000ULL, 0x000000211800720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b14197823ULL, 0x100fe2000001081eULL, 0x0000001821037208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b50507823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b51517823ULL, 0x100fe2000001081eULL, 0x0000002e0300720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b15157823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b17177823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b39397823ULL, 0x100fe2000001081eULL, 0x000000032e187208ULL, 0x000fe20004000000ULL,
0x0000001500327308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b16167823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe2000001081eULL, 0x0000002f1800720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe2000001081eULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b27277823ULL, 0x100fe2000001081eULL, 0x000000182f187208ULL, 0x000fe20004000000ULL,
0x0000001700347308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b29297823ULL, 0x100fe2000001081eULL,
0x3fb8aa3b1d1d7823ULL, 0x000fc4000001081eULL, 0x0c401f0018037f89ULL, 0x000ea800000e0000ULL,
0x0000001b001b7308ULL, 0x000ff00000000800ULL, 0x00000039002a7308ULL, 0x000ff00000000800ULL,
0x0000005000507308ULL, 0x000fe20000000800ULL, 0x000000031800720bULL, 0x004fc80003f1e000ULL,
0x0000001803117208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b1c037823ULL, 0x100fe4000001081eULL,
0x0000005100517308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b2d1e7823ULL, 0x000fe2000001081eULL,
0x3c003c00ff2d7424ULL, 0x000fe200078e00ffULL, 0x0c201f0011147f89ULL, 0x000eea00000e0000ULL,
0x0000001600317308ULL, 0x0005f00000000800ULL, 0x0000002c00337308ULL, 0x0009e20000000800ULL,
0x000000505116723eULL, 0x004fce00000000ffULL, 0x0000002900307308ULL, 0x0005e20000000800ULL,
0x3c003c00ff2c7424ULL, 0x010fe200078e00ffULL, 0x000000141100720bULL, 0x008fc80003f1e000ULL,
0x0000001114117208ULL, 0x000fe40004000000ULL, 0x00000019002b7308ULL, 0x000fe20000000800ULL,
0x0000001b2a14723eULL, 0x000fe400000000ffULL, 0x3fb8aa3b11357820ULL, 0x000fc80000410000ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b3b3b7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b52527823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010835ULL,
0x0000003a00157308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b1a297823ULL, 0x104fe20000010835ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b25397823ULL, 0x100fe20000010835ULL,
0x0000003b00187308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010835ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010835ULL,
0x3fb8aa3b21217823ULL, 0x000fc80000010835ULL, 0x0000005200177308ULL, 0x000fe20000000800ULL,
0x000000151815723eULL, 0x004fce00000000ffULL, 0x00000053001c7308ULL, 0x000eb00000000800ULL,
0x0000001d00367308ULL, 0x000fe20000000800ULL, 0x000000171c17723eULL, 0x004fce00000000ffULL,
0x0000004c004c7308ULL, 0x000fe20000000800ULL, 0x0000002c1418723cULL, 0x000fee00000018ffULL,
0x0000004d004d7308ULL, 0x000eb00000000800ULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x0000004c4d1c723eULL, 0x004fce00000000ffULL, 0x0000004e001d7308ULL, 0x000ff00000000800ULL,
0x0000004f003c7308ULL, 0x000eb00000000800ULL, 0x00000028001f7308ULL, 0x0007e20000000800ULL,
0x0000001d3c1d723eULL, 0x004fce00000000ffULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b22287823ULL, 0x008fe40000010835ULL, 0x0c401f0013227f89ULL, 0x000eea00000e0000ULL,
0x0000001e00387308ULL, 0x0009e20000000800ULL, 0x0000001f261f723eULL, 0x004fce00000000ffULL,
0x00000029002a7308ULL, 0x0005e20000000800ULL, 0x00000027301e723eULL, 0x010fce00000000ffULL,
0x0000002400377308ULL, 0x0009620000000800ULL, 0x0c401f0012297f89ULL, 0x004ea200000e0000ULL,
0x000000221300720bULL, 0x008fc80003f3e000ULL, 0x0000001322137208ULL, 0x000fe40004800000ULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x0000002c1c24723cULL, 0x010fe20000001818ULL,
0x000008005b227824ULL, 0x000fcc00078e020aULL, 0x0000003900397308ULL, 0x000ee20000000800ULL,
0x0000002b3218723eULL, 0x000fe400000000ffULL, 0x00000031341a723eULL, 0x000fe400000000ffULL,
0x0000002a3719723eULL, 0x022fe400000000ffULL, 0x0000000300317812ULL, 0x000fe200078ec0ffULL,
0x0000000300037308ULL, 0x000e620000000800ULL, 0x000000291200720bULL, 0x004fe20003f1e000ULL,
0x0000000802007824ULL, 0x000fc600078e00ffULL, 0x0000001229127208ULL, 0x000fe40004000000ULL,
0x00000028391b723eULL, 0x008fe200000000ffULL, 0x0000002300237308ULL, 0x000fec0000000800ULL,
0x0000002c1828723cULL, 0x000fe40000001824ULL, 0x0000002100307308ULL, 0x0004ea0000000800ULL,
0x000000033624723eULL, 0x002fc400000000ffULL, 0x0c201f0012037f89ULL, 0x000e6200000e0000ULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x0000000131217824ULL, 0x004fe200078e0202ULL,
0x000000333826723eULL, 0x000fe400000000ffULL, 0x000000233025723eULL, 0x008fc800000000ffULL,
0x0000002f002f7308ULL, 0x000ea20000000800ULL, 0x0000000302307819ULL, 0x000fe200000006ffULL,
0x0000000421237836ULL, 0x000fe40000000000ULL, 0x000000ffff337224ULL, 0x000fe200078e0026ULL,
0x0000002e2f27723eULL, 0x004fe200000000ffULL, 0x00000008022e7836ULL, 0x000fe20000000000ULL,
0xfffffff800027812ULL, 0x000fe400078ee221ULL, 0x0c201f0013007f89ULL, 0x000ea200000e0000ULL,
0x00000001312f7824ULL, 0x000fe200078e022eULL, 0x000000031200720bULL, 0x002fe20003f1e000ULL,
0x0000002c2428723cULL, 0x000fe20000001828ULL, 0x000000082e327824ULL, 0x000fc400078e00ffULL,
0x000000082e347824ULL, 0x000fe200078e00ffULL, 0xfffffff8302e7812ULL, 0x000fe200078ee223ULL,
0x0000000c21317836ULL, 0x000fe20000000000ULL, 0x0001100022217810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2c7224ULL, 0x000fe200078e0014ULL, 0xfffffff832307812ULL, 0x000fe200078ee22fULL,
0x000000ffff2d7224ULL, 0x000fe200078e0016ULL, 0x0000001203127208ULL, 0x000fe20004000000ULL,
0x000000102e227824ULL, 0x100fe200078e0221ULL, 0x0000000309ff7812ULL, 0x000fe2000780c0ffULL,
0x0000001030237824ULL, 0x100fe200078e0221ULL, 0xfffffff834347812ULL, 0x000fe200078ee231ULL,
0x0000001002027824ULL, 0x000fe200078e0221ULL, 0x0000001e002f7202ULL, 0x000fe20000000f00ULL,
0x000000ffff2e7224ULL, 0x000fc400078e001cULL, 0x000000ffff307224ULL, 0x000fe200078e0018ULL,
0x000000001300720bULL, 0x004fe20003f3e000ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0x0000001700157202ULL, 0x000fe20000000f00ULL, 0x000000ffff317224ULL, 0x000fe200078e001aULL,
0x0000001300137208ULL, 0x000fe20004800000ULL, 0x000000ffff327224ULL, 0x000fe200078e0024ULL,
0x0000002a00297202ULL, 0x000fe20000000f00ULL, 0x000000ffff187224ULL, 0x000fe200078e0019ULL,
0x0000002c02007844ULL, 0x0003e20000000200ULL, 0x000000ffff167224ULL, 0x000fc400078e001dULL,
0x000000ffff177224ULL, 0x000fe200078e001fULL, 0x0000003022007844ULL, 0x0003e20000000200ULL,
0x000000ffff197224ULL, 0x000fe400078e001bULL, 0x0000001034347824ULL, 0x000fe200078e0221ULL,
0x0000001423007844ULL, 0x0003e20000000200ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0025ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0027ULL, 0x00000001ff037424ULL, 0x000fc600078e00ffULL,
0x0000001834007844ULL, 0x0003e80000000200ULL, 0x01b0001020008388ULL, 0x0003e80000000c00ULL,
0x01b2002820008388ULL, 0x0003e20000000a00ULL, 0x0000000e7500720cULL, 0x000fe20003f06070ULL,
0x01b6080304ff79a7ULL, 0x0003e2000850003fULL, 0x01b6100304ff79a7ULL, 0x0003e2000850003fULL,
0x01b6180304ff79a7ULL, 0x0003e2000850003fULL, 0x01b6200304ff79a7ULL, 0x0003f2000850003fULL,
0xffffffa400088947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0180000008027836ULL, 0x000fe20000000000ULL, 0x0000013000007945ULL, 0x000fe80003800000ULL,
0x7f80000002057812ULL, 0x000fc800078ec0ffULL, 0x018000000500780cULL, 0x000fda0003f05070ULL,
0x0000000800028308ULL, 0x0002a20000001000ULL, 0x0000000000388947ULL, 0x000fea0003800000ULL,
0x000000ff0500720cULL, 0x040fe40003f25070ULL, 0x008000000500780cULL, 0x000fe40003f02070ULL,
0x00000001ff057807ULL, 0x000fe40000800000ULL, 0x00000001ff027807ULL, 0x004fc80004000000ULL,
0x0000000205ff7212ULL, 0x000fda000780fcffULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x007fffff08ff7812ULL, 0x000fc8000780c0ffULL, 0x00000001ff027807ULL, 0x000fc80000000000ULL,
0x0000000205ff7212ULL, 0x000fe4000780c0ffULL, 0x8000000008057812ULL, 0x000fd600078ec0ffULL,
0x0080000005020812ULL, 0x000fe200078efcffULL, 0x000000ffff028224ULL, 0x000fe200078e0005ULL,
0x0000000000047947ULL, 0x000fec0003800000ULL, 0x0000000800027308ULL, 0x0004e40000001000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000ff057424ULL, 0x000fc800078e00ffULL,
0xfffffecc044c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000001ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000800000004ULL,
0x0000001000000001ULL, 0x0000000300000001ULL, 0x0000000400000004ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000017bULL,
0x00000000000004c5ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000640ULL,
0x0000000000000210ULL, 0x0000001400000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000850ULL,
0x00000000000000d0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000920ULL,
0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000974ULL,
0x0000000000000424ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d98ULL,
0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d98ULL,
0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000000de0ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000000e00ULL,
0x0000000000013380ULL, 0x0000001400000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000008dULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000014180ULL,
0x000000000000003cULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x00000000000141c0ULL,
0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x00000000000141c0ULL,
0x0000000000000260ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000400000006ULL, 0x00000000000147a0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x00000000000147a0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL,
0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000000de0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000000e00ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000013380ULL, 0x0000000000013380ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000440ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x00000000000141c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000260ULL,
0x0000000000000260ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_fp16_pagedKV_64_nqpkv_8_m_8_sm_90_cubin_len = 84208;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
