/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000016350ULL, 0x0000000000015fd0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL,
0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL,
0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL,
0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL,
0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000030ULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000001baULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000034ULL,
0x0000000000000004ULL, 0x000c00010000028dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000002dbULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000329ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c0001000003c5ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c00010000040bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000459ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000049fULL, 0x0000000000014340ULL,
0x0000000000000180ULL, 0x000b0022000004d2ULL, 0x00000000000144c0ULL, 0x0000000000000040ULL,
0x000b0022000004fdULL, 0x0000000000014500ULL, 0x0000000000000050ULL, 0x000b002200000527ULL,
0x0000000000014550ULL, 0x0000000000000130ULL, 0x000a000300000595ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005b5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005e5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000014680ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001434000000000ULL,
0x0000040400000000ULL, 0x810c000000180400ULL, 0x0050a80408288080ULL, 0x0000000000000000ULL,
0x000000a4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8508288080820828ULL, 0x2880808608288080ULL,
0x808f082880808808ULL, 0x0828808090082880ULL, 0x8080930828808092ULL, 0x9508288080940828ULL,
0x288080a808288080ULL, 0x80aa08288080a908ULL, 0x08288080ab082880ULL, 0x8080b008288080acULL,
0xb408288080b10828ULL, 0x288080b508288080ULL, 0x808408288080cc08ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x2200288080849200ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x0001434000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808084ULL, 0x000000a4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x2880808508288080ULL, 0x808d082880808808ULL, 0x082880808f082880ULL,
0x8080920828808090ULL, 0x9508288080940828ULL, 0x288080a808288080ULL, 0x80aa08288080a908ULL,
0x08288080ab082880ULL, 0x8080b008288080acULL, 0xb408288080b10828ULL, 0x288080b508288080ULL,
0x808608288080cc08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080869200ULL,
0x0000001cffffffffULL, 0x0000016000000000ULL, 0x000144c000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x000000a4ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808508288080ULL, 0x8088082880808608ULL, 0x082880808f082880ULL, 0x8080920828808090ULL,
0x9408288080930828ULL, 0x2880809508288080ULL, 0x80a908288080a808ULL, 0x08288080aa082880ULL,
0x8080ac08288080abULL, 0xb108288080b00828ULL, 0x288080b408288080ULL, 0x80b508288080cc08ULL,
0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080b59200ULL, 0x0000002cffffffffULL,
0x0000023800000000ULL, 0x0001450000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x80b4288080b50900ULL, 0x0000000000002880ULL, 0x000000a4ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x2880808508288080ULL, 0x8088082880808608ULL, 0x082880808f082880ULL,
0x8080920828808090ULL, 0x9408288080930828ULL, 0x2880809508288080ULL, 0x80a908288080a808ULL,
0x08288080aa082880ULL, 0x8080ac08288080abULL, 0xb108288080b00828ULL, 0x288080b508288080ULL,
0x80b408288080cc08ULL, 0x1028808280162880ULL, 0x0000000000000003ULL, 0x2200288080b49200ULL,
0x0000001cffffffffULL, 0x0000032000000000ULL, 0x0001455000000000ULL, 0x0000013000000000ULL,
0x0000000000000000ULL, 0x0000001b00082f04ULL, 0x0008230400000080ULL, 0x0000000000000017ULL,
0x0000001700081204ULL, 0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL,
0x0008120400000000ULL, 0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0008230400000000ULL, 0x000000000000001bULL, 0x0000001b00081204ULL, 0x0008110400000008ULL,
0x000000080000001bULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0058016000000018ULL,
0x000c170400581903ULL, 0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL,
0x000c17040021f000ULL, 0x0040000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL,
0x000c17040061f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00801b030011f000ULL, 0x0000092000043104ULL, 0xffffffff01342904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000044001342804ULL, 0x000005a000000470ULL, 0x00002470000023e0ULL,
0x000026f000002590ULL, 0x00002b9000002b60ULL, 0x00002c7000002c00ULL, 0x00004b7000004ae0ULL,
0x00004df000004c90ULL, 0x000052a000005270ULL, 0x0000538000005310ULL, 0x0000722000007190ULL,
0x000074b000007350ULL, 0x0000796000007930ULL, 0x00007a40000079d0ULL, 0x00009840000097a0ULL,
0x00009ac000009960ULL, 0x00009fb000009f80ULL, 0x0000a0900000a020ULL, 0x0000b2a00000b290ULL,
0x000128e0000128a0ULL, 0x00012900000128f0ULL, 0x0001297000012910ULL, 0x000129b000012990ULL,
0x0001365000013600ULL, 0x00013720000136c0ULL, 0x0001380000013790ULL, 0x000138b000013860ULL,
0x0001398000013920ULL, 0x00013a60000139f0ULL, 0x00013b1000013ac0ULL, 0x00013be000013b80ULL,
0x00013cc000013c50ULL, 0x00013d7000013d20ULL, 0x00013e4000013de0ULL, 0x00013f2000013eb0ULL,
0x0001401000013f90ULL, 0x0001411000014090ULL, 0x0001421000014190ULL, 0x0001431000014290ULL,
0x000003d004403904ULL, 0x00017600000000ffULL, 0x000004a0003f0100ULL, 0x000176080000000bULL,
0x000004f0003f0120ULL, 0x000176880000000bULL, 0x00000520003f0120ULL, 0x000176a80000000bULL,
0x00000550003f0120ULL, 0x000176c80000000bULL, 0x00000930003f0120ULL, 0x00017600000000ffULL,
0x00000a90003f0107ULL, 0x0001768c0000000cULL, 0x00000b20003f0102ULL, 0x000176880000000cULL,
0x00001350003f0101ULL, 0x00000000000000ffULL, 0x000013d000040107ULL, 0x00000000000000ffULL,
0x0000143000040101ULL, 0x0000002000000002ULL, 0x00001590003f0101ULL, 0x000176cc0000000fULL,
0x00001760003f0105ULL, 0x000176cc0000000fULL, 0x00001fb0003f0105ULL, 0x000176b00000000eULL,
0x00002050003f0107ULL, 0x000176b00000000eULL, 0x000020b0003f0101ULL, 0x0001760800000016ULL,
0x000020f0003f0101ULL, 0x0001760c00000008ULL, 0x000022d0003f0105ULL, 0x0001760c00000008ULL,
0x000028c0003f0105ULL, 0x000176ac00000024ULL, 0x00002a90003f0105ULL, 0x000176ac00000024ULL,
0x00003d50003f0105ULL, 0x0000000000000036ULL, 0x00003db0003f0101ULL, 0x0001768800000010ULL,
0x00003de0003f0101ULL, 0x000000040000000aULL, 0x00003fa0003f0105ULL, 0x000000040000000aULL,
0x000046f0003f0105ULL, 0x00000000000000ffULL, 0x000047c000040107ULL, 0x00000000000000ffULL,
0x0000482000040101ULL, 0x0001762800000010ULL, 0x00004840003f0101ULL, 0x0001762c00000008ULL,
0x00004a10003f0105ULL, 0x0001762c00000008ULL, 0x00004fd0003f0105ULL, 0x000176b400000038ULL,
0x000051a0003f0105ULL, 0x000176b400000038ULL, 0x000063f0003f0105ULL, 0x0000000000000020ULL,
0x00006450003f0101ULL, 0x0001769000000068ULL, 0x00006480003f0101ULL, 0x000000040000000aULL,
0x00006640003f0105ULL, 0x000000040000000aULL, 0x00006da0003f0105ULL, 0x00000008000000ffULL,
0x00006e3000040107ULL, 0x000176b000000020ULL, 0x00006e90003f0101ULL, 0x0001764800000008ULL,
0x00006ef0003f0101ULL, 0x0001764c00000008ULL, 0x000070c0003f0105ULL, 0x0001764c00000008ULL,
0x00007690003f0105ULL, 0x000176ac00000037ULL, 0x00007860003f0105ULL, 0x000176ac00000037ULL,
0x000089d0003f0105ULL, 0x000000000000000aULL, 0x00008a30003f0101ULL, 0x0000000000000004ULL,
0x00008a60003f0101ULL, 0x000000040000000aULL, 0x00008c20003f0105ULL, 0x000000040000000aULL,
0x000093c0003f0105ULL, 0x00000000000000ffULL, 0x0000949000040107ULL, 0x00000000000000ffULL,
0x000094f000040101ULL, 0x0001766800000009ULL, 0x00009520003f0101ULL, 0x0001766c00000009ULL,
0x000096f0003f0105ULL, 0x0001766c00000009ULL, 0x00009ca0003f0105ULL, 0x000176b400000013ULL,
0x00009ea0003f0105ULL, 0x000176b400000013ULL, 0x0000b060003f0105ULL, 0x000000000000000aULL,
0x0000b0e0003f0101ULL, 0x0000000000000008ULL, 0x0000c1e0003f0101ULL, 0x00017600000000ffULL,
0x0000d9f0003f0101ULL, 0x00017604000000ffULL, 0x0000dbc0003f0105ULL, 0x00017604000000ffULL,
0x0000ddf0003f0105ULL, 0x00017600000000ffULL, 0x0000de20003f0101ULL, 0x00017604000000ffULL,
0x0000dfe0003f0105ULL, 0x00017604000000ffULL, 0x00010dd0003f0105ULL, 0x0000000000000071ULL,
0x00010eb0003f0101ULL, 0x0000000400000071ULL, 0x00011080003f0105ULL, 0x0000000400000071ULL,
0x00013440003f0105ULL, 0x0000000000000077ULL, 0x000134a0003f0101ULL, 0x0000000800000077ULL,
0x00013500003f0101ULL, 0x0000001000000077ULL, 0x00013570003f0101ULL, 0x0000001800000077ULL,
0x00053803003f0101ULL, 0x0000bb0000201c04ULL, 0x0000bd400000bb30ULL, 0x0000c0300000bea0ULL,
0x0000e0400000c130ULL, 0x00000401000135c0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000003e4ULL,
0x0000001b00000002ULL, 0x00000000000002fcULL, 0x0000001b00000002ULL, 0x0000000000000224ULL,
0x0000001b00000002ULL, 0x0000000000000134ULL, 0x0000001b00000002ULL, 0x0000000000000044ULL,
0x0000001b00000002ULL, 0x00000000000003c1ULL, 0x0000001b00000002ULL, 0x00000000000002d9ULL,
0x0000001b00000002ULL, 0x0000000000000201ULL, 0x0000001b00000002ULL, 0x0000000000000111ULL,
0x0000001b00000002ULL, 0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0e7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0xfffffff801017810ULL, 0x000fe20007ffe0ffULL, 0x00005a0000057ab9ULL, 0x000fe20000000800ULL,
0x00000000000c7919ULL, 0x000ee20000002300ULL, 0x0000000504047299ULL, 0x000fe4000800063fULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000f280000002100ULL,
0x00000000000a7919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000040003077a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a07ULL,
0x0000040003007624ULL, 0x000fca00078e020eULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff07aa12ULL, 0x000fc800078e33ffULL, 0x0000000700007306ULL, 0x000e620000209000ULL,
0x000000ff0700720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000307047224ULL, 0x004fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x00000006037c7227ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000ee40000002200ULL,
0x000000ffff007224ULL, 0x000fc800078e0a7cULL, 0x0000000007007224ULL, 0x000fca00078e0206ULL,
0x000000070000720cULL, 0x000fda0003f66070ULL, 0x0000000100003824ULL, 0x000fe200078e0a07ULL,
0x000000017c7c3810ULL, 0x000fe20007ffe0ffULL, 0x000001000c027a24ULL, 0x008fc600078e0203ULL,
0x000000070000720cULL, 0x000fe20003f86070ULL, 0x00000000020b7a24ULL, 0x010fca00078e0209ULL,
0x000000ff0b00720cULL, 0x040fe40003f45270ULL, 0x0000007f0b00780cULL, 0x040fe40003f04070ULL,
0x0000000f0b00780cULL, 0x040fe40003f24070ULL, 0x000000030b00780cULL, 0x000fe40003f64070ULL,
0x000000017c7c4810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff7cd212ULL, 0x000fc400078e33ffULL,
0x000000010b00780cULL, 0x000fe20003f84070ULL, 0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL,
0x000000ffff007224ULL, 0x000fe400078e0a7cULL, 0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL,
0x00000000070d7224ULL, 0x000fe200078e0206ULL, 0x00000005ff007819ULL, 0x000fe20000011609ULL,
0xff317217ff088424ULL, 0x000fe200078e00ffULL, 0x01760002ff00a388ULL, 0x0003e20000000a00ULL,
0x000000100d627824ULL, 0x000fc400078e00ffULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x017400080b008388ULL, 0x0005e20000004800ULL, 0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL,
0x0000000462007c0cULL, 0x040fe2000bf03070ULL, 0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL,
0x00001fff0c097589ULL, 0x0007e200000e0000ULL, 0x7fffff60ff07b424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff02b424ULL, 0x002fe200078e00ffULL, 0x00001fff00007589ULL, 0x000e6200000e0000ULL,
0x7fffff80ff03b424ULL, 0x000fe200078e00ffULL, 0x0000000462087c10ULL, 0x004fc4000fffe1ffULL,
0x017608040b009388ULL, 0x0005e20000008a00ULL, 0x00005a000e0c7a19ULL, 0x008fe400000006ffULL,
0x0000001008087817ULL, 0x000fe20003800000ULL, 0x0000000d01007387ULL, 0x0007e60000100800ULL,
0x000000ff087d7207ULL, 0x000fe20000000000ULL, 0x017688060b00b388ULL, 0x0009e60000008a00ULL,
0x000000107d00780cULL, 0x000fe20003f05270ULL, 0x3fffffc0ff04c424ULL, 0x004fe200078e00ffULL,
0x0176a8020b00b388ULL, 0x0003e20000008a00ULL, 0x7fffffc0ff05c424ULL, 0x000fe200078e00ffULL,
0x00005a007c0d7a19ULL, 0x008fc800000006ffULL, 0x0176c8040b00c388ULL, 0x0005e20000008a00ULL,
0x000058000a067a24ULL, 0x010fc800078e02ffULL, 0x0000000c06067224ULL, 0x000fe400078e020dULL,
0x0000000409027824ULL, 0x002fc800078e0200ULL, 0x0000000202047824ULL, 0x004fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000001d000008947ULL, 0x000fea0003800000ULL,
0x00000000000d7919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fc40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x00000004ff077819ULL, 0x002fca000001160dULL, 0x0000000104087824ULL, 0x000fc800078e0207ULL,
0x0000000162027824ULL, 0x000fca00078e0208ULL, 0x0000000402037c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fc60000011602ULL, 0x0000000106057824ULL, 0x000fe200078e0203ULL,
0x000000047d037217ULL, 0x000fc60007800000ULL, 0x0000000c02057224ULL, 0x000fe400078e0205ULL,
0x000000100d027824ULL, 0x000fe400078e00ffULL, 0x0000000103037824ULL, 0x000fe400078e0a04ULL,
0x0000010005047825ULL, 0x000fe200078e00ffULL, 0x000000f0020b7812ULL, 0x000fe400078ec0ffULL,
0x000000030700720cULL, 0x000fe20003f06070ULL, 0x0000000108037824ULL, 0x000fe200078e020dULL,
0x0000000b040b7212ULL, 0x000fe200078efcffULL, 0x0000001008087824ULL, 0x000fc600078e00ffULL,
0x00005e000b047a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff008037812ULL, 0x000fe400078ee203ULL,
0x00005f0005057a10ULL, 0x000fc60000ffe4ffULL, 0x0000001003037824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004037faeULL, 0x0003e2000c101c48ULL,
0x0000018000007947ULL, 0x000fea0003800000ULL, 0x00000000000d7919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x000000040d037211ULL, 0x002fca00078fe0ffULL,
0x0000000162027824ULL, 0x000fca00078e0203ULL, 0x0000000402057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fc60000011602ULL, 0x0000000106057824ULL, 0x000fe400078e0205ULL,
0x0000000103067824ULL, 0x000fe400078e020dULL, 0x0000000c02057224ULL, 0x000fe400078e0205ULL,
0x000000100d027824ULL, 0x000fe400078e00ffULL, 0x0000010005047825ULL, 0x000fc600078e00ffULL,
0x000000f002077812ULL, 0x000fe200078ec0ffULL, 0x0000001003037824ULL, 0x000fc600078e00ffULL,
0x0000000704047212ULL, 0x000fe400078efcffULL, 0xfffffff003067812ULL, 0x000fe400078ee206ULL,
0x00005e0004047a10ULL, 0x000fc60007f1e0ffULL, 0x0000001006037824ULL, 0x000fe200078e00ffULL,
0x00005f0005057a10ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e8000b901c48ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000037806ULL, 0x000fc600038e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000300047300ULL, 0x000e7000000e0000ULL, 0x0000000300067309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe20003f02070ULL, 0x00000004ff057424ULL, 0x000fc400078e00ffULL,
0x000000ffff067224ULL, 0x004fe400078e0a06ULL, 0x000064000a047625ULL, 0x000fd000078e0005ULL,
0x01760406ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01760000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000804617981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe40003f05270ULL, 0x000000ff61067810ULL, 0x006fc80007ffe0ffULL,
0x00000008ff757819ULL, 0x000fce0000011606ULL, 0x0000b6e000008947ULL, 0x000fea0003800000ULL,
0x00000008000c7824ULL, 0x000fe400078e00ffULL, 0x00000003ff037424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01768c030cff738cULL, 0x0003e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0600780cULL, 0x000fe20003f04070ULL,
0x000000020a037824ULL, 0x002fe200078e00ffULL, 0x00000001ff6e7819ULL, 0x000fe20000011600ULL,
0x017688000cff7f8cULL, 0x0003e2000c80043fULL, 0x0000000100747812ULL, 0x000fe200078ec0ffULL,
0x0000590003037624ULL, 0x000fe400078e020eULL, 0x000000206e077824ULL, 0x000fc400078e00ffULL,
0x000000017c767824ULL, 0x000fc800078e0203ULL, 0x0000660076037a24ULL, 0x000fe200078e0207ULL,
0x000003e000000947ULL, 0x000fea0003800000ULL, 0x0000000761047217ULL, 0x002fe20007800000ULL,
0x0000001074057824ULL, 0x000fe200078e00ffULL, 0x00000003ff067819ULL, 0x000fc6000001160dULL,
0x0000000104047824ULL, 0x000fe200078e0a07ULL, 0x0000000406097810ULL, 0x040fe20007ffe0ffULL,
0x0000000105087824ULL, 0x000fe200078e0206ULL, 0x0000000c060b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000504047217ULL, 0x000fe20007800000ULL, 0x0000000108077824ULL, 0x040fe400078e020dULL,
0x00000008080e7824ULL, 0x000fe400078e00ffULL, 0x0000000104047824ULL, 0x000fc400078e0a05ULL,
0x0000000103087824ULL, 0x000fe200078e0208ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL,
0x0000000105107824ULL, 0x040fe200078e020bULL, 0x0000000806077810ULL, 0x040fe40007ffe0ffULL,
0x000000040600720cULL, 0x080fe20003f66070ULL, 0x0000000105067824ULL, 0x000fe200078e0209ULL,
0x000000040900720cULL, 0x080fe20003f46070ULL, 0x00000001050a7824ULL, 0x000fe200078e0207ULL,
0x000000040700720cULL, 0x080fe20003f26070ULL, 0x0000000103077824ULL, 0x000fe200078e0206ULL,
0x000000040b00720cULL, 0x000fe20003f06070ULL, 0x0000008008047825ULL, 0x000fc800078e00ffULL,
0x0000000106087824ULL, 0x100fe200078e020dULL, 0x00000070040b7812ULL, 0x000fe200078ef802ULL,
0x00000008060f7824ULL, 0x000fe400078e00ffULL, 0x0000000103067824ULL, 0x040fe400078e020aULL,
0x0000000103097824ULL, 0x000fe400078e0210ULL, 0x000000010a037824ULL, 0x140fe400078e020dULL,
0x000000080a127824ULL, 0x000fe200078e00ffULL, 0x000062000b0a7a10ULL, 0x000fe20007f9e0ffULL,
0x0000000110047824ULL, 0x000fc400078e020dULL, 0x0000000810117824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe400078ee203ULL, 0x00006300050b7a10ULL, 0x000fe400027fe4ffULL,
0xfffffff811147812ULL, 0x000fe200078ee204ULL, 0x0000008007047825ULL, 0x000fe200078e00ffULL,
0x000130006e037811ULL, 0x000fe400078e68ffULL, 0xfffffff80f107812ULL, 0x000fe200078ee208ULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x0000008009087825ULL, 0x000fc800078e00ffULL,
0x000000100e0f7824ULL, 0x100fe200078e0203ULL, 0x00000070040e7812ULL, 0x100fe200078ef802ULL,
0x0000001010117824ULL, 0x100fe200078e0203ULL, 0x0000007006047812ULL, 0x100fe200078ef802ULL,
0x0000001012137824ULL, 0x100fe200078e0203ULL, 0x0000007008067812ULL, 0x000fe200078ef802ULL,
0x0000001014157824ULL, 0x000fe200078e0203ULL, 0x000062000e027a10ULL, 0x000fe20007f9e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0f7faeULL, 0x0003e2000d901c48ULL,
0x0000620004047a10ULL, 0x000fe40007fbe0ffULL, 0x0000620006067a10ULL, 0x000fc40007fde0ffULL,
0x0000630005037a10ULL, 0x000fe400027fe4ffULL, 0x0000630007057a10ULL, 0x000fe40002ffe4ffULL,
0x0000630009077a10ULL, 0x000fe200037fe4ffULL, 0x0000000002117faeULL, 0x0003e8000d101c48ULL,
0x0000000004137faeULL, 0x0003e8000c901c48ULL, 0x0000000006157faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001074047824ULL, 0x002fe200078e00ffULL,
0x000130006e157811ULL, 0x000fc800078e68ffULL, 0x000000040d047211ULL, 0x000fc800078fe8ffULL,
0x0000000404087810ULL, 0x040fe20007ffe0ffULL, 0x0000000103057824ULL, 0x000fe200078e0204ULL,
0x00000008040a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000104067824ULL, 0x040fe200078e020dULL,
0x0000000c04107810ULL, 0x040fe20007ffe0ffULL, 0x0000000804077824ULL, 0x000fe400078e00ffULL,
0x0000008005047825ULL, 0x000fc600078e00ffULL, 0xfffffff8070e7812ULL, 0x000fe200078ee206ULL,
0x0000000103067824ULL, 0x040fe200078e0208ULL, 0x00000070040b7812ULL, 0x000fe200078ef802ULL,
0x0000000108077824ULL, 0x140fe400078e020dULL, 0x0000000808127824ULL, 0x000fe400078e00ffULL,
0x0000000103087824ULL, 0x000fe400078e020aULL, 0x000000010a097824ULL, 0x140fe400078e020dULL,
0x000000080a147824ULL, 0x000fe200078e00ffULL, 0x000062000b0a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000110047824ULL, 0x000fc400078e020dULL, 0x0000000810117824ULL, 0x000fe200078e00ffULL,
0x00006300050b7a10ULL, 0x000fe200007fe4ffULL, 0x00000001030f7824ULL, 0x000fe200078e0210ULL,
0xfffffff812037812ULL, 0x000fe400078ee207ULL, 0xfffffff811127812ULL, 0x000fe200078ee204ULL,
0x0000008006047825ULL, 0x000fe200078e00ffULL, 0xfffffff814107812ULL, 0x000fc600078ee209ULL,
0x0000008008067825ULL, 0x000fc800078e00ffULL, 0x000000800f087825ULL, 0x000fc800078e00ffULL,
0x0000001003117824ULL, 0x100fe200078e0215ULL, 0x0000007004037812ULL, 0x100fe200078ef802ULL,
0x000000100e0f7824ULL, 0x100fe200078e0215ULL, 0x0000007006047812ULL, 0x100fe200078ef802ULL,
0x0000001010137824ULL, 0x100fe200078e0215ULL, 0x0000007008067812ULL, 0x000fe200078ef802ULL,
0x0000001012157824ULL, 0x000fe200078e0215ULL, 0x0000620003027a10ULL, 0x000fe20007f1e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a0f7faeULL, 0x0003e2000b901c48ULL,
0x0000620004047a10ULL, 0x000fe40007f3e0ffULL, 0x0000620006067a10ULL, 0x000fc40007f5e0ffULL,
0x0000630005037a10ULL, 0x000fe400007fe4ffULL, 0x0000630007057a10ULL, 0x000fe40000ffe4ffULL,
0x0000630009077a10ULL, 0x000fe200017fe4ffULL, 0x0000000002117faeULL, 0x0003e8000b901c48ULL,
0x0000000004137faeULL, 0x0003e8000b901c48ULL, 0x0000000006157faeULL, 0x0003e4000b901c48ULL,
0x000000006e0473c2ULL, 0x000ea200000e0000ULL, 0x000000ff7500720cULL, 0x000fe20003f05270ULL,
0x000000ffff117224ULL, 0x002fe200078e00ffULL, 0x000176a86e027811ULL, 0x000fe200078e18ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff397224ULL, 0x000fe200078e00ffULL,
0x000176a804047891ULL, 0x004fd2000f8e203fULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff047f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200002027f8cULL, 0x000ea2000c80043fULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00009c4000008947ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x002fe200078e0005ULL, 0x00000002ff7a7819ULL, 0x000fe20000011600ULL,
0x000000ffff0e7224ULL, 0x004fc400078e0003ULL, 0xff317217ff127424ULL, 0x000fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fc400078e00ffULL,
0x000000ffff107224ULL, 0x00afca00078e00ffULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x0000000400087824ULL, 0x000fca00078e00ffULL, 0xfffffff8080f7812ULL, 0x000fc800078ec0ffULL,
0x000176c80f0a7810ULL, 0x000fe20007ffe0ffULL, 0x0176cc000f097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe4000780480eULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000802137210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e03ULL,
0x003d09001300780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401300780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000001308087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000110107810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0176cc000f097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe4000780480eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010b027810ULL, 0x000fe20007ffe0ffULL, 0x000000206e037824ULL, 0x000fc600078e00ffULL,
0x000000750200720cULL, 0x000fe20003f26070ULL, 0x000001000b097824ULL, 0x000fca00078e0203ULL,
0x0000004009037810ULL, 0x000fca0007ffe0ffULL, 0x0000660076167a24ULL, 0x000fe400078e0203ULL,
0x0000040000009947ULL, 0x000fea0003800000ULL, 0x0000000361027217ULL, 0x000fe20007800000ULL,
0x00000010740f7824ULL, 0x000fe200078e00ffULL, 0x00000003ff087819ULL, 0x000fc6000001160dULL,
0x0000000102027824ULL, 0x000fe200078e0a03ULL, 0x0000000408107810ULL, 0x040fe20007ffe0ffULL,
0x000000010f0e7824ULL, 0x040fe200078e0208ULL, 0x0000000808137810ULL, 0x000fe40007ffe0ffULL,
0x000000020f027217ULL, 0x000fe20007800000ULL, 0x000000010e037824ULL, 0x040fe400078e020dULL,
0x000000080e147824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fc400078e0a0fULL,
0x000000010f157824ULL, 0x000fe200078e0213ULL, 0xfffffff814257812ULL, 0x000fe200078ee203ULL,
0x000000100d037824ULL, 0x000fe200078e00ffULL, 0x0000000c08147810ULL, 0x000fe20007ffe0ffULL,
0x0000000815357824ULL, 0x000fe200078e00ffULL, 0x000000021000720cULL, 0x080fe20003f66070ULL,
0x000000010f107824ULL, 0x040fe200078e0210ULL, 0x000000020800720cULL, 0x080fe20003f86070ULL,
0x000000010f177824ULL, 0x000fe200078e0214ULL, 0x000000021300720cULL, 0x080fe20003f46070ULL,
0x0000000110087824ULL, 0x000fe200078e020dULL, 0x000000021400720cULL, 0x000fe20003f06070ULL,
0x000000010e027824ULL, 0x100fe200078e0216ULL, 0x0000007003137812ULL, 0x000fe200078ec0ffULL,
0x00000001100e7824ULL, 0x000fc400078e0216ULL, 0x0000000810277824ULL, 0x000fe400078e00ffULL,
0x0000008002027825ULL, 0x000fc600078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee208ULL,
0x0000000115147824ULL, 0x000fe200078e0216ULL, 0x0000001302027212ULL, 0x000fe200078efcffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0x0000620002027a10ULL, 0x000fe20007fbe0ffULL,
0x0000000117167824ULL, 0x000fe200078e0216ULL, 0x000000130e0e7212ULL, 0x000fe200078efcffULL,
0x0000000115087824ULL, 0x100fe200078e020dULL, 0x0000630003037a10ULL, 0x000fe20002ffe4ffULL,
0x0000000117107824ULL, 0x040fe200078e020dULL, 0x000062000e0e7a10ULL, 0x000fe20007fde0ffULL,
0x0000000817377824ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee208ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000140006e087811ULL, 0x000fc400078e68ffULL,
0xfffffff837377812ULL, 0x000fe200078ee210ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000001314147212ULL, 0x080fe400078efcffULL, 0x000063000f0f7a10ULL, 0x000fe400037fe4ffULL,
0x0000001316167212ULL, 0x000fe200078efcffULL, 0x0000001025137824ULL, 0x100fe200078e0208ULL,
0x0000620014147a10ULL, 0x000fe20007fbe0ffULL, 0x0000001027257824ULL, 0x100fe200078e0208ULL,
0x0000620016167a10ULL, 0x000fe20007fde0ffULL, 0x0000001035277824ULL, 0x100fe200078e0208ULL,
0x0000630015157a10ULL, 0x000fe20002ffe4ffULL, 0x0000001037357824ULL, 0x000fe200078e0208ULL,
0x0000630017177a10ULL, 0x000fe200037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002137faeULL, 0x0003e8000e101c48ULL, 0x000000000e257faeULL, 0x0003e8000d901c48ULL,
0x0000000014277faeULL, 0x0003e8000d101c48ULL, 0x0000000016357faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001074027824ULL, 0x000fe200078e00ffULL,
0x000140006e357811ULL, 0x000fc800078e68ffULL, 0x000000020d037211ULL, 0x040fe200078fe8ffULL,
0x000000100d027824ULL, 0x000fc600078e00ffULL, 0x0000000803137810ULL, 0x040fe20007ffe0ffULL,
0x0000000103087824ULL, 0x040fe200078e020dULL, 0x0000007002277812ULL, 0x000fe200078ec0ffULL,
0x00000008030f7824ULL, 0x040fe200078e00ffULL, 0x0000000c03157810ULL, 0x040fe20007ffe0ffULL,
0x0000000103027824ULL, 0x000fe400078e0216ULL, 0x0000000813247824ULL, 0x000fe200078e00ffULL,
0xfffffff80f087812ULL, 0x000fe200078ee208ULL, 0x0000000113147824ULL, 0x000fe200078e0216ULL,
0x00000004030f7810ULL, 0x000fe20007ffe0ffULL, 0x0000008002027825ULL, 0x000fc800078e00ffULL,
0x000000010f0e7824ULL, 0x140fe200078e0216ULL, 0x0000002702027212ULL, 0x000fe200078efcffULL,
0x000000010f107824ULL, 0x140fe400078e020dULL, 0x000000080f177824ULL, 0x000fe200078e00ffULL,
0x0000620002027a10ULL, 0x000fe20007f1e0ffULL, 0x00000001130f7824ULL, 0x100fe400078e020dULL,
0x0000000115167824ULL, 0x000fe200078e0216ULL, 0xfffffff817107812ULL, 0x000fe200078ee210ULL,
0x0000000115137824ULL, 0x040fe200078e020dULL, 0xfffffff824247812ULL, 0x000fe200078ee20fULL,
0x0000000815267824ULL, 0x000fe200078e00ffULL, 0x0000630003037a10ULL, 0x000fe200007fe4ffULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff826267812ULL, 0x000fe200078ee213ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000270e0e7212ULL, 0x000fc600078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000002714147212ULL, 0x080fe400078efcffULL,
0x000062000e0e7a10ULL, 0x000fe20007f1e0ffULL, 0x0000001008137824ULL, 0x100fe200078e0235ULL,
0x0000002716167212ULL, 0x000fe200078efcffULL, 0x0000001010257824ULL, 0x100fe200078e0235ULL,
0x0000620014147a10ULL, 0x000fe20007f5e0ffULL, 0x0000001024277824ULL, 0x100fe200078e0235ULL,
0x0000620016167a10ULL, 0x000fe20007f7e0ffULL, 0x0000001026357824ULL, 0x000fe200078e0235ULL,
0x000063000f0f7a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002137faeULL, 0x0003e2000b901c48ULL, 0x0000630015157a10ULL, 0x000fc400017fe4ffULL,
0x0000630017177a10ULL, 0x000fe20001ffe4ffULL, 0x000000000e257faeULL, 0x0003e8000b901c48ULL,
0x0000000014277faeULL, 0x0003e8000b901c48ULL, 0x0000000016357faeULL, 0x0003e4000b901c48ULL,
0xfffffff00c0e7812ULL, 0x042fe400078ec0ffULL, 0xffffffe00c027812ULL, 0x000fc400078ec0ffULL,
0x000000000e0573c2ULL, 0x000e6200000e0000ULL, 0x000000100c037812ULL, 0x000fca00078ec0ffULL,
0x0000000102137824ULL, 0x000fe400078e0203ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000874167824ULL, 0x000fe200078e0213ULL, 0x000176b005057890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176b0000e0e7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176080016167f8cULL, 0x000ea4000c80043fULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x000000080c087812ULL, 0x000fca00078ec0ffULL,
0x0000000113087824ULL, 0x000fca00078e0208ULL, 0x01760c0008137984ULL, 0x000ee40000000800ULL,
0x8000000013ff7812ULL, 0x00cfe40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff247224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000102400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001402137210ULL, 0x000fca0007f1e1ffULL,
0x0000000115147824ULL, 0x000fe200000e0e03ULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011414ULL,
0x0000001310107211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0614ULL,
0x0000000210107819ULL, 0x000fc80000001213ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000124247810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01760c0008137984ULL, 0x000ea40000000800ULL,
0x8000000013ff7812ULL, 0x004fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000100d5f7824ULL, 0x000fe200078e00ffULL,
0x00000001ff7b7819ULL, 0x000fe2000001160dULL, 0x0000002000027824ULL, 0x000fc600078e00ffULL,
0x000000705f5f7812ULL, 0x000fe400078ec0ffULL, 0xffffff8002027812ULL, 0x000fe400078ec0ffULL,
0x0000000c7b7b7812ULL, 0x000fc800078ec0ffULL, 0x000000027b027210ULL, 0x000fca0007ffe05fULL,
0x0170000002037984ULL, 0x000ea80000000800ULL, 0x0172000002107984ULL, 0x0006620000000800ULL,
0x000000120300720bULL, 0x004fe20003f1d000ULL, 0x000111f27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000137806ULL, 0x008fc800000e0100ULL, 0x0000ffff13177812ULL, 0x000fe2000780c0ffULL,
0x0000048000007945ULL, 0x000fe20003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000ffff027224ULL, 0x000fd200078e0012ULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000007a00720cULL, 0x000fe40003f05270ULL, 0x000000120300720bULL, 0x000fe20003f54000ULL,
0x000111b27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x000fc400010e0100ULL,
0x0000008000168824ULL, 0x000fe200078e025fULL, 0x0000001203027209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991014157816ULL, 0x000fe200000000ffULL,
0x000000017b138824ULL, 0x000fca00078e0216ULL, 0x0174000213008388ULL, 0x0005e20000000800ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000001202127221ULL, 0x004fe20000010100ULL, 0x000000ff14ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b12127820ULL, 0x000fcc0000410000ULL,
0x0000001200127308ULL, 0x000ea40000000800ULL, 0x0000001211117220ULL, 0x004fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff137819ULL, 0x000fe2000001160dULL,
0x000110f27f007947ULL, 0x000fea000b800000ULL, 0x00001f1312137589ULL, 0x0004e400000e0000ULL,
0x0000001330307220ULL, 0x08cfe40000410000ULL, 0x0000001331317220ULL, 0x080fe40000410000ULL,
0x000000132c2c7220ULL, 0x080fe40000410000ULL, 0x000000132d2d7220ULL, 0x000fc40000410000ULL,
0x0000001328287220ULL, 0x080fe40000410000ULL, 0x0000001329297220ULL, 0x080fe40000410000ULL,
0x000000133c3c7220ULL, 0x080fe40000410000ULL, 0x000000133d3d7220ULL, 0x080fe40000410000ULL,
0x0000001338387220ULL, 0x080fe40000410000ULL, 0x0000001339397220ULL, 0x000fc40000410000ULL,
0x000000131c1c7220ULL, 0x080fe40000410000ULL, 0x000000131d1d7220ULL, 0x080fe40000410000ULL,
0x0000001318187220ULL, 0x080fe40000410000ULL, 0x0000001319197220ULL, 0x080fe40000410000ULL,
0x0000001320207220ULL, 0x080fe40000410000ULL, 0x0000001321217220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0014ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d137811ULL, 0x000fe200078ff0ffULL,
0x00010ff27f007947ULL, 0x000fea000b800000ULL, 0x00001f1312137589ULL, 0x0004e400000e0000ULL,
0x0000001332327220ULL, 0x08cfe40000410000ULL, 0x0000001333337220ULL, 0x080fe40000410000ULL,
0x000000132e2e7220ULL, 0x080fe40000410000ULL, 0x000000132f2f7220ULL, 0x080fe40000410000ULL,
0x000000132a2a7220ULL, 0x080fe40000410000ULL, 0x000000132b2b7220ULL, 0x000fc40000410000ULL,
0x000000133e3e7220ULL, 0x080fe40000410000ULL, 0x000000133f3f7220ULL, 0x080fe40000410000ULL,
0x000000133a3a7220ULL, 0x080fe40000410000ULL, 0x000000133b3b7220ULL, 0x080fe40000410000ULL,
0x000000131e1e7220ULL, 0x080fe40000410000ULL, 0x000000131f1f7220ULL, 0x000fc40000410000ULL,
0x000000131a1a7220ULL, 0x080fe40000410000ULL, 0x000000131b1b7220ULL, 0x080fe40000410000ULL,
0x0000001322227220ULL, 0x080fe40000410000ULL, 0x0000001323237220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff17ff7812ULL, 0x000fe20007806014ULL,
0x00000001ff167424ULL, 0x000fd800078e00ffULL, 0x8000000203030221ULL, 0x000fe20000010000ULL,
0x00007610ff160816ULL, 0x000fc60000000016ULL, 0x3fb8aa3b03030820ULL, 0x000fc80000410000ULL,
0x0000000300070308ULL, 0x000ea40000000800ULL, 0x0000000710100220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001110117221ULL, 0x002fc40000010000ULL,
0x0000000000127805ULL, 0x000fca0000015200ULL, 0xfffffff00c247812ULL, 0x000fca00078ec0ffULL,
0x0176ac0024037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804804ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff177224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001412107210ULL, 0x000fca0007f1e1ffULL,
0x0000000115147824ULL, 0x000fe200000e0e13ULL, 0x003d09001000780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401000780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011414ULL,
0x0000001003037211ULL, 0x000fca00078110ffULL, 0x000000ffff107224ULL, 0x000fca00000e0614ULL,
0x0000000203037819ULL, 0x000fc80000001210ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000117177810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac0024037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804804ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991016037816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000007ff03723eULL, 0x000fe400000000ffULL, 0x00000002ff047819ULL, 0x000fe4000001160dULL,
0x0000541003037816ULL, 0x000fe20000000003ULL, 0x00010be27f007947ULL, 0x000fea000b800000ULL,
0x00001f0403067589ULL, 0x0002a400000e0000ULL, 0x0000000804137810ULL, 0x000fe20007ffe0ffULL,
0x00010c327f007947ULL, 0x000fea000b800000ULL, 0x00001f1303057589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001004137810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff347224ULL, 0x000fe200078e0003ULL, 0x00002c1000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x000118f000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001804137810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff347224ULL, 0x000fe200078e0003ULL,
0x00002c8000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0001188000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000070d107812ULL, 0x000fe200078ec0ffULL,
0x0000020000037824ULL, 0x00afe200078e00ffULL, 0x00000004ff157819ULL, 0x100fe2000001160dULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000008105b7812ULL, 0x000fc600078ef80dULL,
0x000000046e047824ULL, 0x000fe400078e0215ULL, 0x000000085b127824ULL, 0x040fe400078e00ffULL,
0x000000015b637824ULL, 0x000fe200078e0204ULL, 0xfffff80003047812ULL, 0x000fe400078ec0ffULL,
0x000000080d037812ULL, 0x000fe400078ec0ffULL, 0xfffffff812137812ULL, 0x004fca00078ee263ULL,
0x0000001013347824ULL, 0x000fc400078e0204ULL, 0x0000001003127212ULL, 0x040fe200078efcffULL,
0x0000000474137824ULL, 0x000fe200078e0215ULL, 0x000130006e627811ULL, 0x000fe400078e68ffULL,
0x0000001003037812ULL, 0x000fe200078efe10ULL, 0x0000000112147824ULL, 0x040fe400078e0213ULL,
0x0000000812157824ULL, 0x000fe400078e00ffULL, 0x0000000113107824ULL, 0x000fe400078e0203ULL,
0x0000000803137824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fc400078ee214ULL,
0x0000000214147810ULL, 0x000fe40007ffe0ffULL, 0xfffffff813137812ULL, 0x000fe200078ee210ULL,
0x0000001015157824ULL, 0x000fe200078e0262ULL, 0x0000000210107810ULL, 0x000fc60007ffe0ffULL,
0x0000001013137824ULL, 0x000fe200078e0262ULL, 0x000000001524783bULL, 0x000e680000004200ULL,
0x000000001344783bULL, 0x0002a40000004200ULL, 0x0000010024137824ULL, 0x002fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe20000011424ULL, 0x0000010026357824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe20000011425ULL, 0x0000010046407824ULL, 0x004fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe20000011413ULL, 0x0000000812137824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe20000011426ULL, 0x0000010025127824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011427ULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0xfffffff813137812ULL, 0x000fc400078ee214ULL, 0x0000888024527816ULL, 0x040fe200000000ffULL,
0x0001000024247824ULL, 0x000fe200078e00ffULL, 0x0000888025537816ULL, 0x000fe200000000ffULL,
0x0000001013137824ULL, 0x000fe200078e0262ULL, 0x00008880266a7816ULL, 0x040fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x000000001314783bULL, 0x0002a20000004200ULL,
0x0000888027487816ULL, 0x000fe200000000ffULL, 0x00000035006b7306ULL, 0x0007e20000200c00ULL,
0x00000018ff247819ULL, 0x000fc40000011424ULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000010027137824ULL, 0x042fe200078e00ffULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x011000003434783bULL, 0x008e620000000200ULL, 0x0000002400607306ULL, 0x000fe20000200c00ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x00000018ff277819ULL, 0x000fc40000011427ULL,
0x00000018ff427819ULL, 0x000fe40000011447ULL, 0x00008880474a7816ULL, 0x000fe200000000ffULL,
0x00000013005a7306ULL, 0x0007e20000200c00ULL, 0x00000018ff437819ULL, 0x000fe40000011444ULL,
0x00008880444c7816ULL, 0x040fe400000000ffULL, 0x00000018ff417819ULL, 0x000fe40000011446ULL,
0x00008880454e7816ULL, 0x000fe200000000ffULL, 0x00000025005e7306ULL, 0x000fe20000200c00ULL,
0x0000010044137824ULL, 0x048fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011445ULL,
0x0001000044447824ULL, 0x000fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fc40000011440ULL,
0x00000018ff4d7819ULL, 0x000fe20000011413ULL, 0x0000000803137824ULL, 0x000fe200078e00ffULL,
0x0000002600697306ULL, 0x000fe20000200c00ULL, 0x00000018ff447819ULL, 0x000fc60000011444ULL,
0xfffffff813137812ULL, 0x000fe200078ee210ULL, 0x0000010045107824ULL, 0x040fe200078e00ffULL,
0x00000018ff577819ULL, 0x004fe20000011414ULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x0000002700687306ULL, 0x0005e20000200c00ULL, 0x0000001013137824ULL, 0x000fe200078e0262ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000888014667816ULL, 0x000fe400000000ffULL,
0x00000018ff567819ULL, 0x000fe20000011415ULL, 0x0000000634348232ULL, 0x082fe20000000000ULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x000000001324783bULL, 0x004e620000004200ULL,
0x0000000636368232ULL, 0x000fe20000000000ULL, 0x00000018ff517819ULL, 0x000fe20000011417ULL,
0x0000000535358232ULL, 0x080fe20000000000ULL, 0x00000018ff507819ULL, 0x000fe20000011416ULL,
0x0000000537378232ULL, 0x000fe20000000000ULL, 0x00000018ff4b7819ULL, 0x000fe20000011445ULL,
0x0000005900597306ULL, 0x000eb00000200c00ULL, 0x0000005300537306ULL, 0x000ff00000200c00ULL,
0x0000001200127306ULL, 0x000ee20000200c00ULL, 0x0000541052527816ULL, 0x004fc40000000059ULL,
0x0000888015597816ULL, 0x000fca00000000ffULL, 0x00000010004f7306ULL, 0x0005f00000200c00ULL,
0x0000005c005c7306ULL, 0x000f220000200c00ULL, 0x0000010047107824ULL, 0x004fe200078e00ffULL,
0x0000541053537816ULL, 0x008fe20000000012ULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x00000018ff137819ULL, 0x002fc40000011424ULL, 0x00000018ff647819ULL, 0x000fe20000011410ULL,
0x0001000046107824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x0000004400587306ULL, 0x0003e20000200c00ULL, 0x000000523430723cULL, 0x000b640000001830ULL,
0x00000018ff6d7819ULL, 0x000fe40000011410ULL, 0x00000018ff107819ULL, 0x000fc60000011426ULL,
0x00000047006c7306ULL, 0x0005e20000200c00ULL, 0x0000888046447816ULL, 0x002fe200000000ffULL,
0x0000010015527824ULL, 0x060fe400078e00ffULL, 0x0001000015157824ULL, 0x000fc600078e00ffULL,
0x00000018ff527819ULL, 0x000fe20000011452ULL, 0x0000006400467306ULL, 0x0003e20000200c00ULL,
0x0000010014477824ULL, 0x044fe400078e00ffULL, 0x0001000014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff477819ULL, 0x000fe40000011447ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff647819ULL, 0x002fce0000011427ULL,
0x0000006400127306ULL, 0x000ff00000200c00ULL, 0x0000001400647306ULL, 0x0003f00000200c00ULL,
0x0000004800487306ULL, 0x000ea20000200c00ULL, 0x0000541060147816ULL, 0x002fc4000000005dULL,
0x00000018ff5d7819ULL, 0x000fe40000011415ULL, 0x000054105e157816ULL, 0x010fe4000000005cULL,
0x00008880175c7816ULL, 0x000fe200000000ffULL, 0x0000005200657306ULL, 0x0003e20000200c00ULL,
0x00008880165e7816ULL, 0x000fc600000000ffULL, 0x00000014342c723cULL, 0x000be8000000182cULL,
0x0000004700677306ULL, 0x0007e20000200c00ULL, 0x000000085b527824ULL, 0x002fe400078e00ffULL,
0x0000010016157824ULL, 0x060fe400078e00ffULL, 0x0000010017147824ULL, 0x040fe400078e00ffULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x0000000263477810ULL, 0x008fe20007ffe0ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fc40000011414ULL,
0xfffffff852477812ULL, 0x000fe400078ee247ULL, 0x00000018ff527819ULL, 0x000fe20000011417ULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000888024177816ULL, 0x000fca00000000ffULL, 0x0000001500607306ULL, 0x0005f00000200c00ULL,
0x0000001400637306ULL, 0x0007e20000200c00ULL, 0x0000541048157816ULL, 0x004fe2000000005aULL,
0x0000001047487824ULL, 0x000fe200078e0204ULL, 0x0000541068537816ULL, 0x002fe20000000054ULL,
0x000000ffff477224ULL, 0x000fc400078e0017ULL, 0x0000010024547824ULL, 0x000fe400078e00ffULL,
0x0000006600667306ULL, 0x000e620000200c00ULL, 0x000054106a147816ULL, 0x008fe2000000006bULL,
0x0001000024247824ULL, 0x000fca00078e00ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000005900597306ULL, 0x000ea20000200c00ULL, 0x000000143428723cULL, 0x000b6e0000001828ULL,
0x00000016005b7306ULL, 0x0007f00000200c00ULL, 0x00000052005a7306ULL, 0x0009e20000200c00ULL,
0x011000004814783bULL, 0x028eee0000000200ULL, 0x0000005700577306ULL, 0x000e620000200c00ULL,
0x0000541069527816ULL, 0x010fc40000000055ULL, 0x00000018ff557819ULL, 0x000fe40000011454ULL,
0x0000888025547816ULL, 0x000fc600000000ffULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x00000052343c723cULL, 0x000b6e000000183cULL, 0x0000005d005d7306ULL, 0x000f220000200c00ULL,
0x0000541066527816ULL, 0x022fe20000000067ULL, 0x0000010025667824ULL, 0x000fe200078e00ffULL,
0x0000541059537816ULL, 0x004fc80000000065ULL, 0x00000018ff597819ULL, 0x000fe20000011466ULL,
0x0000005e005e7306ULL, 0x000fe40000200c00ULL, 0x000000523438723cULL, 0x000b6c0000001838ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x0000541064527816ULL, 0x020fe20000000057ULL,
0x0000000614148232ULL, 0x088fe20000000000ULL, 0x000054105d537816ULL, 0x010fe20000000056ULL,
0x0000000616168232ULL, 0x000fc40000000000ULL, 0x0000000515158232ULL, 0x080fe40000000000ULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x0000000517178232ULL, 0x000fe20000000000ULL,
0x00000052341c723cULL, 0x000b6c000000181cULL, 0x0000005100517306ULL, 0x000ea20000200c00ULL,
0x0001000025537824ULL, 0x020fca00078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x000054105b507816ULL, 0x002fce0000000050ULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x000054105a517816ULL, 0x004fce0000000051ULL,
0x0000004e004e7306ULL, 0x000eb00000200c00ULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x000054104c4c7816ULL, 0x002fce000000004dULL, 0x0000004000457306ULL, 0x0002e20000200c00ULL,
0x000054104e4d7816ULL, 0x004fce000000004fULL, 0x0000004a004a7306ULL, 0x000ea20000200c00ULL,
0x00000018ff407819ULL, 0x002fe20000011425ULL, 0x0000004c1430723cULL, 0x000fe20000001830ULL,
0x000054105c257816ULL, 0x000fca0000000063ULL, 0x0000002400527306ULL, 0x0003e20000200c00ULL,
0x0000541044447816ULL, 0x008fce0000000045ULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x000054105e247816ULL, 0x002fe40000000060ULL, 0x000054104a457816ULL, 0x004fca0000000046ULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x000000243418723cULL, 0x040b6e0000001818ULL,
0x0000006d006d7306ULL, 0x000e620000200c00ULL, 0x000000503434723cULL, 0x000b640000001820ULL,
0x0000888026257816ULL, 0x020fca00000000ffULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x0000010026207824ULL, 0x040fe200078e00ffULL, 0x0000888027217816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x000000441428723cULL, 0x000b620000001828ULL,
0x0000010027227824ULL, 0x040fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x000054106d247816ULL, 0x002fe20000000041ULL, 0x000000ffff4c7224ULL, 0x000fe200078e0021ULL,
0x00000018ff227819ULL, 0x000fc40000011422ULL, 0x00000018ff447819ULL, 0x020fc60000011427ULL,
0x0000004b004b7306ULL, 0x000e700000200c00ULL, 0x0000002500507306ULL, 0x0005f00000200c00ULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x000054106c257816ULL, 0x004fc40000000042ULL,
0x000054104b217816ULL, 0x002fca0000000049ULL, 0x0000005500557306ULL, 0x000ff00000200c00ULL,
0x0000005400547306ULL, 0x000ff00000200c00ULL, 0x0000005900597306ULL, 0x000ff00000200c00ULL,
0x0000002000517306ULL, 0x0002b00000200c00ULL, 0x0000001300137306ULL, 0x000ee20000200c00ULL,
0x0000541058207816ULL, 0x002fc40000000043ULL, 0x00000018ff437819ULL, 0x000fe40000011426ULL,
0x000000241424723cULL, 0x000f66000000183cULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x0000541050507816ULL, 0x004fc80000000051ULL, 0x00000020142c723cULL, 0x000b66000000182cULL,
0x0000005300537306ULL, 0x000e620000200c00ULL, 0x0000541052527816ULL, 0x008fc60000000013ULL,
0x0000541047207816ULL, 0x020fe40000000055ULL, 0x0000541054217816ULL, 0x000fe40000000059ULL,
0x0000004c004c7306ULL, 0x000ff00000200c00ULL, 0x0000002200497306ULL, 0x0004e20000200c00ULL,
0x0000541053537816ULL, 0x002fce0000000040ULL, 0x0000001000107306ULL, 0x000fe20000200c00ULL,
0x000000201420723cULL, 0x044b6e0000001838ULL, 0x0000004300437306ULL, 0x000e620000200c00ULL,
0x000054104c517816ULL, 0x008fe20000000049ULL, 0x00000052141c723cULL, 0x040f6c000000181cULL,
0x00000044003d7306ULL, 0x000ea40000200c00ULL, 0x000000501418723cULL, 0x000f640000001818ULL,
0x0000541043387816ULL, 0x022fe20000000010ULL, 0x0000000200107824ULL, 0x000fca00078e00ffULL,
0xfffffff810107812ULL, 0x000fe400078ec0ffULL, 0x000054103d397816ULL, 0x004fce0000000012ULL,
0x000000381414723cULL, 0x000b6e0000001834ULL, 0x000176c86e367811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000036367f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176880010ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff387224ULL, 0x000fc600078e00ffULL, 0x0000000000127805ULL, 0x000fc80000015200ULL,
0x000004000a357984ULL, 0x000ee40000000800ULL, 0x8000000035ff7812ULL, 0x00afc40007804837ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003412397210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e13ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff107819ULL, 0x004fc80000011435ULL, 0x0000003910107211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000210107819ULL, 0x000fc80000001235ULL,
0x000000100000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000a357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe40007804837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008009137810ULL, 0x000fca0007ffe0ffULL,
0x0000660076377a24ULL, 0x000fe200078e0213ULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x0000001361107217ULL, 0x004fe20007800000ULL, 0x0000001074357824ULL, 0x000fe200078e00ffULL,
0x00000003ff127819ULL, 0x000fc6000001160dULL, 0x0000000110107824ULL, 0x000fe200078e0a13ULL,
0x0000000412367810ULL, 0x040fe20007ffe0ffULL, 0x0000000135347824ULL, 0x040fe200078e0212ULL,
0x0000000c12397810ULL, 0x000fe40007ffe0ffULL, 0x0000001035107217ULL, 0x000fe20007800000ULL,
0x0000000134137824ULL, 0x040fe400078e020dULL, 0x0000000834387824ULL, 0x000fe400078e00ffULL,
0x0000000110107824ULL, 0x000fc400078e0a35ULL, 0x00000001353a7824ULL, 0x040fe200078e0239ULL,
0xfffffff8383b7812ULL, 0x000fe400078ee213ULL, 0x000000103600720cULL, 0x080fe20003f66070ULL,
0x0000000135367824ULL, 0x000fe200078e0236ULL, 0x0000000812387810ULL, 0x000fe20007ffe0ffULL,
0x000000083a417824ULL, 0x000fe200078e00ffULL, 0x000000101200720cULL, 0x080fe20003f86070ULL,
0x0000000134127824ULL, 0x000fe200078e0237ULL, 0x000000103800720cULL, 0x080fe20003f46070ULL,
0x0000000136137824ULL, 0x040fe200078e020dULL, 0x000000103900720cULL, 0x000fe20003f06070ULL,
0x0000000836347824ULL, 0x000fc400078e00ffULL, 0x0000000135387824ULL, 0x000fe400078e0238ULL,
0x000000103b3b7824ULL, 0x000fe200078e0262ULL, 0xfffffff8343d7812ULL, 0x000fe200078ee213ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x0000000136347824ULL, 0x100fe200078e0237ULL,
0x0000005f12127212ULL, 0x000fe200078efcffULL, 0x0000000138367824ULL, 0x000fe400078e0237ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000620012127a10ULL, 0x000fc60007fbe0ffULL,
0x0000000138107824ULL, 0x000fe200078e020dULL, 0x0000005f34347212ULL, 0x080fe200078efcffULL,
0x00000008383f7824ULL, 0x000fe200078e00ffULL, 0x0000630013137a10ULL, 0x000fe20002ffe4ffULL,
0x000000013a387824ULL, 0x000fe200078e0237ULL, 0x0000620034347a10ULL, 0x000fe20007fbe0ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee210ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000123b7faeULL, 0x0003e2000e101c48ULL,
0x0000630035357a10ULL, 0x000fe20002ffe4ffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000005f36367212ULL, 0x000fc600078efcffULL, 0x000000013a107824ULL, 0x000fe200078e020dULL,
0x0000005f38387212ULL, 0x000fe200078efcffULL, 0x000000103d3d7824ULL, 0x100fe200078e0262ULL,
0x0000620036367a10ULL, 0x000fe20007fbe0ffULL, 0x000000103f3f7824ULL, 0x000fe200078e0262ULL,
0xfffffff841417812ULL, 0x000fe400078ee210ULL, 0x0000620038387a10ULL, 0x000fe20007fde0ffULL,
0x00000000343d7faeULL, 0x0003e2000d901c48ULL, 0x0000630037377a10ULL, 0x000fe20002ffe4ffULL,
0x0000001041417824ULL, 0x000fe200078e0262ULL, 0x0000630039397a10ULL, 0x000fc600037fe4ffULL,
0x00000000363f7faeULL, 0x0003e8000d101c48ULL, 0x0000000038417faeULL, 0x0003e2000c101c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001074107824ULL, 0x004fca00078e00ffULL,
0x000000100d107211ULL, 0x000fc800078fe8ffULL, 0x0000000410387810ULL, 0x040fe20007ffe0ffULL,
0x0000000110127824ULL, 0x140fe200078e020dULL, 0x0000000810347810ULL, 0x040fe20007ffe0ffULL,
0x00000008103b7824ULL, 0x000fe400078e00ffULL, 0x0000000138137824ULL, 0x040fe400078e020dULL,
0x0000000838367824ULL, 0x000fe200078e00ffULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee212ULL,
0x0000000110127824ULL, 0x040fe200078e0237ULL, 0x0000000c10107810ULL, 0x000fe20007ffe0ffULL,
0x0000000134357824ULL, 0x000fe200078e020dULL, 0xfffffff8363d7812ULL, 0x000fe200078ee213ULL,
0x00000008343a7824ULL, 0x000fc400078e00ffULL, 0x0000000138387824ULL, 0x000fe400078e0237ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff83a3f7812ULL, 0x000fc600078ee235ULL,
0x0000000134347824ULL, 0x100fe200078e0237ULL, 0x0000005f12127212ULL, 0x000fe200078efcffULL,
0x0000000110367824ULL, 0x000fe400078e0237ULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x0000620012127a10ULL, 0x000fc60007f1e0ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000005f38387212ULL, 0x080fe400078efcffULL, 0x0000630013137a10ULL, 0x000fe200007fe4ffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000005f34347212ULL, 0x080fe400078efcffULL,
0x0000620038387a10ULL, 0x000fe20007f5e0ffULL, 0x00000001103a7824ULL, 0x000fe200078e020dULL,
0x0000005f36367212ULL, 0x000fe200078efcffULL, 0x0000000810417824ULL, 0x000fe200078e00ffULL,
0x0000620034347a10ULL, 0x000fe20007f1e0ffULL, 0x000000103b3b7824ULL, 0x100fe200078e0262ULL,
0x0000620036367a10ULL, 0x000fe20007f7e0ffULL, 0x000000103d3d7824ULL, 0x000fe200078e0262ULL,
0xfffffff841417812ULL, 0x000fe200078ee23aULL, 0x000000103f3f7824ULL, 0x100fe200078e0262ULL,
0x0000630039397a10ULL, 0x000fe200017fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000123b7faeULL, 0x0003e2000b901c48ULL, 0x0000630035357a10ULL, 0x000fe200007fe4ffULL,
0x0000001041417824ULL, 0x000fe200078e0262ULL, 0x0000630037377a10ULL, 0x000fe20001ffe4ffULL,
0x00000000383d7faeULL, 0x0003e8000b901c48ULL, 0x00000000343f7faeULL, 0x0003e8000b901c48ULL,
0x0000000036417faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000106e107824ULL, 0x000fe200078e00ffULL, 0xffffffe00c137812ULL, 0x000fc400078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x000000080c127812ULL, 0x000fe400078ec0ffULL,
0x0000001010107812ULL, 0x000fc800078ec0ffULL, 0x0000001312107210ULL, 0x000fe20007ffe010ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff447f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176280010367f8cULL, 0x0004e4000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x01762c0008357984ULL, 0x000f240000000800ULL, 0x8000000035ff7812ULL, 0x018fe40007804837ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003412397210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e13ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x004fc80000011435ULL,
0x0000003910107211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000210107819ULL, 0x000fc80000001235ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01762c0008357984ULL, 0x000ee40000000800ULL,
0x8000000035ff7812ULL, 0x008fe40007804837ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002000107824ULL, 0x004fca00078e00ffULL, 0xffffff8010107812ULL, 0x000fc800078ec0ffULL,
0x000000805f107810ULL, 0x000fca0007ffe010ULL, 0x000000017b107824ULL, 0x000fca00078e0210ULL,
0x0170000010397984ULL, 0x000ea80000000800ULL, 0x0172000010127984ULL, 0x0006620000000800ULL,
0x000000023900720bULL, 0x004fe20003f1d000ULL, 0x0000ed527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000137806ULL, 0x008fc800000e0100ULL, 0x0000ffff133b7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff107424ULL, 0x000fd600078e00ffULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000017a137810ULL, 0x000fe40007ffe0ffULL,
0x000000023900720bULL, 0x000fe40003f54000ULL, 0x000000001300720cULL, 0x000fe20003f05270ULL,
0x0000ed127f007947ULL, 0x000fd4000b800000ULL, 0x0000000000107806ULL, 0x000fc400010e0100ULL,
0x0000008000348824ULL, 0x000fe200078e025fULL, 0x0000000239357209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991010137816ULL, 0x000fe200000000ffULL,
0x000000017b348824ULL, 0x000fca00078e0234ULL, 0x0174003534008388ULL, 0x0005e20000000800ULL,
0x000000ff1300720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000003502137221ULL, 0x004fe20000010000ULL, 0x000000ff10ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL,
0x0000001300387308ULL, 0x000ea40000000800ULL, 0x0000003811117220ULL, 0x004fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff137819ULL, 0x000fe2000001160dULL,
0x0000ec527f007947ULL, 0x000fea000b800000ULL, 0x00001f1338137589ULL, 0x0004e400000e0000ULL,
0x0000001330307220ULL, 0x08cfe40000410000ULL, 0x0000001331317220ULL, 0x080fe40000410000ULL,
0x000000132c2c7220ULL, 0x080fe40000410000ULL, 0x000000132d2d7220ULL, 0x080fe40000410000ULL,
0x0000001328287220ULL, 0x080fe40000410000ULL, 0x0000001329297220ULL, 0x000fc40000410000ULL,
0x0000001324247220ULL, 0x080fe40000410000ULL, 0x0000001325257220ULL, 0x080fe40000410000ULL,
0x0000001320207220ULL, 0x080fe40000410000ULL, 0x0000001321217220ULL, 0x080fe40000410000ULL,
0x000000131c1c7220ULL, 0x080fe40000410000ULL, 0x000000131d1d7220ULL, 0x000fc40000410000ULL,
0x0000001318187220ULL, 0x080fe40000410000ULL, 0x0000001319197220ULL, 0x080fe40000410000ULL,
0x0000001314147220ULL, 0x080fe40000410000ULL, 0x0000001315157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0010ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d137811ULL, 0x000fe200078ff0ffULL,
0x0000eb527f007947ULL, 0x000fea000b800000ULL, 0x00001f1338137589ULL, 0x0004e400000e0000ULL,
0x0000001332327220ULL, 0x08cfe40000410000ULL, 0x0000001333337220ULL, 0x080fe40000410000ULL,
0x000000132e2e7220ULL, 0x080fe40000410000ULL, 0x000000132f2f7220ULL, 0x080fe40000410000ULL,
0x000000132a2a7220ULL, 0x080fe40000410000ULL, 0x000000132b2b7220ULL, 0x000fc40000410000ULL,
0x0000001326267220ULL, 0x080fe40000410000ULL, 0x0000001327277220ULL, 0x080fe40000410000ULL,
0x0000001322227220ULL, 0x080fe40000410000ULL, 0x0000001323237220ULL, 0x080fe40000410000ULL,
0x000000131e1e7220ULL, 0x080fe40000410000ULL, 0x000000131f1f7220ULL, 0x000fc40000410000ULL,
0x000000131a1a7220ULL, 0x080fe40000410000ULL, 0x000000131b1b7220ULL, 0x080fe40000410000ULL,
0x0000001316167220ULL, 0x080fe40000410000ULL, 0x0000001317177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff3bff7812ULL, 0x000fe20007806010ULL,
0x00000001ff107424ULL, 0x000fe200078e00ffULL, 0x0000000239027209ULL, 0x000fd60007810000ULL,
0x8000000239390221ULL, 0x000fe20000010000ULL, 0x00007610ff100816ULL, 0x000fc60000000010ULL,
0x3fb8aa3b39390820ULL, 0x000fc80000410000ULL, 0x0000003900070308ULL, 0x000ea40000000800ULL,
0x0000000712120220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001112117221ULL, 0x002fc40000010000ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0xfffffff00c387812ULL, 0x000fca00078ec0ffULL, 0x0176b40038357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003412377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e13ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176b40038357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910100e7816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000007ff05723eULL, 0x000fe400000000ffULL,
0x00000002ff0f7819ULL, 0x000fe4000001160dULL, 0x00005410050e7816ULL, 0x000fe20000000005ULL,
0x0000e7327f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0e067589ULL, 0x0002a400000e0000ULL,
0x000000080f137810ULL, 0x000fe20007ffe0ffULL, 0x0000e7827f007947ULL, 0x000fea000b800000ULL,
0x00001f130e057589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100f137810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff347224ULL, 0x000fe200078e000eULL,
0x0000532000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000f1e000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180f137810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff347224ULL, 0x000fe200078e000eULL, 0x0000539000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000f17000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000200687824ULL, 0x000fe200078e00ffULL, 0x000000070d127812ULL, 0x040fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe60003800000ULL, 0x00000004680e7812ULL, 0x00afe400078ec0ffULL,
0x00000008120f7812ULL, 0x000fe400078ef80dULL, 0x0000000e0d0e7211ULL, 0x000fc600078fe0ffULL,
0x000000080f477824ULL, 0x040fe400078e00ffULL, 0x000000010f107824ULL, 0x000fe200078e020eULL,
0x000000080d0f7812ULL, 0x000fc800078ec0ffULL, 0xfffffff847477812ULL, 0x000fca00078ee210ULL,
0x0000001047477824ULL, 0x000fc400078e0204ULL, 0x00000004000e7824ULL, 0x000fe200078e00ffULL,
0x000000120f3a7212ULL, 0x000fe200078efcffULL, 0x0000000803537824ULL, 0x000fe200078e00ffULL,
0x0000100062797810ULL, 0x000fe40007ffe0ffULL, 0x000000040e0e7812ULL, 0x000fe200078ec0ffULL,
0x000000083a137824ULL, 0x004fe200078e00ffULL, 0xfffffff868687812ULL, 0x000fe400078ec0ffULL,
0x0000000e0d0f7211ULL, 0x000fca00078fe0ffULL, 0x000000013a387824ULL, 0x100fe400078e020fULL,
0x0000000103127824ULL, 0x000fc600078e020fULL, 0xfffffff813607812ULL, 0x000fe200078ee238ULL,
0x0000000803137824ULL, 0x000fe200078e00ffULL, 0x0000000238467810ULL, 0x000fc60007ffe0ffULL,
0x0000001060607824ULL, 0x100fe200078e0279ULL, 0xfffffff8130e7812ULL, 0x000fe400078ee212ULL,
0x0000000212127810ULL, 0x000fe40007ffe0ffULL, 0x00000000603c783bULL, 0x000e620000004200ULL,
0x000000100e347824ULL, 0x000fe200078e0279ULL, 0xfffffff853127812ULL, 0x000fca00078ee212ULL,
0x000000003434783bULL, 0x000ea20000004200ULL, 0x00000018ff4c7819ULL, 0x002fe2000001143cULL,
0x000001003c397824ULL, 0x040fe200078e00ffULL, 0x000088803c407816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fe2000001143dULL,
0x000001003d437824ULL, 0x040fe200078e00ffULL, 0x000088803d427816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000001003f507824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe2000001143eULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x00000018ff647819ULL, 0x000fe2000001143fULL,
0x0000010035517824ULL, 0x004fe200078e00ffULL, 0x000088803e697816ULL, 0x000fc400000000ffULL,
0x000088803f497816ULL, 0x040fe200000000ffULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000003c005e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff417819ULL, 0x000fe20000011439ULL, 0x000000083a397824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe4000001143fULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0xfffffff839467812ULL, 0x000fe200078ee246ULL, 0x0000003d004f7306ULL, 0x000fe20000200c00ULL,
0x000001003e3c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe20000011434ULL,
0x0000001046387824ULL, 0x000fe200078e0279ULL, 0x00000018ff3c7819ULL, 0x000fc4000001143cULL,
0x00000018ff677819ULL, 0x000fe2000001143eULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x00000018ff4e7819ULL, 0x000fe20000011435ULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x0000888034547816ULL, 0x000fe400000000ffULL, 0x0000888035567816ULL, 0x040fe200000000ffULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0000003c006a7306ULL, 0x0005e20000200c00ULL, 0x00000018ff4b7819ULL, 0x000fc40000011436ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff4a7819ULL, 0x000fe40000011437ULL,
0x0000888037527816ULL, 0x000fe200000000ffULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x01180000473c783bULL, 0x004eae0000000200ULL, 0x0000004300437306ULL, 0x000ef00000200c00ULL,
0x00000050006b7306ULL, 0x0009f00000200c00ULL, 0x00000035005d7306ULL, 0x0007e20000200c00ULL,
0x0000010034507824ULL, 0x050fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x002fe20000011438ULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fc40000011439ULL,
0x00000018ff507819ULL, 0x000fe40000011450ULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000004c004c7306ULL, 0x000e620000200c00ULL, 0x0000541042357816ULL, 0x008fe40000000043ULL,
0x00000018ff587819ULL, 0x000fe4000001143aULL, 0x00000018ff597819ULL, 0x000fc6000001143bULL,
0x00000034005a7306ULL, 0x0007e20000200c00ULL, 0x000000063c3c8232ULL, 0x084fe40000000000ULL,
0x000000063e3e8232ULL, 0x000fe40000000000ULL, 0x000000053d3d8232ULL, 0x080fe40000000000ULL,
0x000000053f3f8232ULL, 0x000fe20000000000ULL, 0x0000001300137306ULL, 0x000ea20000200c00ULL,
0x0000541040347816ULL, 0x008fe20000000041ULL, 0x0000001012407824ULL, 0x000fcc00078e0279ULL,
0x000000343c30723cULL, 0x000be20000001830ULL, 0x0000006900697306ULL, 0x000ee20000200c00ULL,
0x000000004040783bULL, 0x000f2a0000004200ULL, 0x0000010036347824ULL, 0x020fe400078e00ffULL,
0x0000010037357824ULL, 0x040fe200078e00ffULL, 0x0000004900497306ULL, 0x000e620000200c00ULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00000018ff377819ULL, 0x000fe40000011437ULL,
0x0000005100577306ULL, 0x000ff00000200c00ULL, 0x0000003400517306ULL, 0x0003f00000200c00ULL,
0x0000003500537306ULL, 0x0005e20000200c00ULL, 0x000054105e347816ULL, 0x002fce000000004cULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x000054104f357816ULL, 0x004fe40000000013ULL,
0x00000018ff4c7819ULL, 0x010fe40000011440ULL, 0x00000018ff4f7819ULL, 0x000fe40000011441ULL,
0x00000018ff137819ULL, 0x000fe20000011442ULL, 0x000000343c2c723cULL, 0x000b62000000182cULL,
0x0000006400647306ULL, 0x000fec0000200c00ULL, 0x0000541069347816ULL, 0x028fc4000000006aULL,
0x0000541049357816ULL, 0x000fe2000000006bULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x00000018ff697819ULL, 0x000fca0000011443ULL, 0x000000343c28723cULL, 0x000be40000001828ULL,
0x0000006600667306ULL, 0x000eaa0000200c00ULL, 0x0000010038347824ULL, 0x020fe400078e00ffULL,
0x0000010039357824ULL, 0x000fe200078e00ffULL, 0x0000005000557306ULL, 0x0007e40000200c00ULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff357819ULL, 0x000fc80000011435ULL,
0x00000037005e7306ULL, 0x0009e20000200c00ULL, 0x0000888036507816ULL, 0x048fe200000000ffULL,
0x0001000036367824ULL, 0x000fca00078e00ffULL, 0x00000018ff367819ULL, 0x000fe20000011436ULL,
0x00000034006b7306ULL, 0x0003e20000200c00ULL, 0x0000888038377816ULL, 0x050fe200000000ffULL,
0x0001000038387824ULL, 0x000fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000003600637306ULL, 0x0007e20000200c00ULL, 0x0000541067347816ULL, 0x002fce0000000065ULL,
0x00000035006c7306ULL, 0x0005e20000200c00ULL, 0x0000888039367816ULL, 0x048fe200000000ffULL,
0x0001000039397824ULL, 0x000fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x0000003700377306ULL, 0x000fe20000200c00ULL, 0x0000541066357816ULL, 0x004fe40000000064ULL,
0x000088803b667816ULL, 0x000fca00000000ffULL, 0x0000003600367306ULL, 0x000e620000200c00ULL,
0x000000343c24723cULL, 0x000b6e0000001824ULL, 0x000001003a347824ULL, 0x020fe200078e00ffULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x000001003b357824ULL, 0x000fc400078e00ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe40000011434ULL,
0x00000018ff677819ULL, 0x000fe40000011435ULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x0000541036357816ULL, 0x002fe4000000006cULL, 0x00000018ff3b7819ULL, 0x000fca000001143bULL,
0x0000003800387306ULL, 0x000e700000200c00ULL, 0x0000003900397306ULL, 0x000eb00000200c00ULL,
0x00000034006a7306ULL, 0x0007e20000200c00ULL, 0x0000541038387816ULL, 0x002fce000000005cULL,
0x0000006900497306ULL, 0x0003e20000200c00ULL, 0x0000541037347816ULL, 0x008fe4000000006bULL,
0x0000541039397816ULL, 0x004fe2000000005bULL, 0x00000100405b7824ULL, 0x040fe200078e00ffULL,
0x00008880406b7816ULL, 0x040fe200000000ffULL, 0x0001000040407824ULL, 0x000fe400078e00ffULL,
0x000000343c34723cULL, 0x000b620000001820ULL, 0x000088803a697816ULL, 0x042fe200000000ffULL,
0x011800004820783bULL, 0x020e620000000200ULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x00000018ff407819ULL, 0x000fc60000011440ULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x000000383c1c723cULL, 0x000b66000000181cULL,
0x0000006900697306ULL, 0x000fe80000200c00ULL, 0x0000010041397824ULL, 0x020fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fc6000001145bULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x00000018ff397819ULL, 0x000fce0000011439ULL, 0x0000005800587306ULL, 0x000ff00000200c00ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x0000000620208232ULL, 0x002fce0000000000ULL,
0x0000003a00657306ULL, 0x000e620000200c00ULL, 0x0000000622228232ULL, 0x000fe40000000000ULL,
0x0000000521218232ULL, 0x080fe40000000000ULL, 0x0000000523238232ULL, 0x000fc60000000000ULL,
0x0000003b00647306ULL, 0x0004f00000200c00ULL, 0x0000003800487306ULL, 0x0009e20000200c00ULL,
0x0000541065587816ULL, 0x002fe40000000058ULL, 0x00008880413b7816ULL, 0x044fe200000000ffULL,
0x0001000041417824ULL, 0x000fc800078e00ffULL, 0x00000039005b7306ULL, 0x0003e20000200c00ULL,
0x0000541069387816ULL, 0x010fe4000000006aULL, 0x0000541064597816ULL, 0x008fe40000000059ULL,
0x00000018ff417819ULL, 0x000fc60000011441ULL, 0x0000004d004d7306ULL, 0x000ea20000200c00ULL,
0x0000541066397816ULL, 0x002fe20000000067ULL, 0x000000583c14723cULL, 0x040fec0000001814ULL,
0x0000004e004e7306ULL, 0x000e640000200c00ULL, 0x000000383c18723cULL, 0x000b6c0000001818ULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x0000010042397824ULL, 0x060fe200078e00ffULL,
0x0000888042387816ULL, 0x040fe200000000ffULL, 0x00000100433f7824ULL, 0x040fe200078e00ffULL,
0x00008880433e7816ULL, 0x040fe200000000ffULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000038003c7306ULL, 0x0005e20000200c00ULL, 0x00000018ff3f7819ULL, 0x000fc4000001143fULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff437819ULL, 0x000fc60000011443ULL,
0x00000039003d7306ULL, 0x0002e20000200c00ULL, 0x000054105a387816ULL, 0x004fce000000004dULL,
0x0000004b004b7306ULL, 0x000ea20000200c00ULL, 0x000054105d397816ULL, 0x002fce000000004eULL,
0x00000038202c723cULL, 0x000b62000000182cULL, 0x0000005400547306ULL, 0x000e620000200c00ULL,
0x000054103c3c7816ULL, 0x008fca000000003dULL, 0x000054105e397816ULL, 0x020fe4000000004aULL,
0x0000005000507306ULL, 0x000ee20000200c00ULL, 0x0000541063387816ULL, 0x004fce000000004bULL,
0x0000005600567306ULL, 0x000ea20000200c00ULL, 0x0000541054547816ULL, 0x002fe20000000055ULL,
0x000000382024723cULL, 0x000f6c0000001824ULL, 0x0000005200527306ULL, 0x000e620000200c00ULL,
0x0000541050507816ULL, 0x008fce0000000051ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x0000541056557816ULL, 0x004fce0000000057ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x0000541052517816ULL, 0x002fe20000000053ULL, 0x000000542030723cULL, 0x040f6c0000001830ULL,
0x0000001300137306ULL, 0x000fe40000200c00ULL, 0x000000502028723cULL, 0x000f6c0000001828ULL,
0x0000006b003a7306ULL, 0x000e700000200c00ULL, 0x0000003b003b7306ULL, 0x000eb00000200c00ULL,
0x0000004000407306ULL, 0x000ee20000200c00ULL, 0x000054103a3a7816ULL, 0x002fce0000000048ULL,
0x0000004100417306ULL, 0x000e620000200c00ULL, 0x000054103b3b7816ULL, 0x004fce000000005bULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x0000541040407816ULL, 0x008fe2000000004cULL,
0x0000003a2038723cULL, 0x000f6c0000001834ULL, 0x0000003f003f7306ULL, 0x000ea20000200c00ULL,
0x0000541041417816ULL, 0x002fce000000004fULL, 0x0000004200427306ULL, 0x000e620000200c00ULL,
0x00000040201c723cULL, 0x000f6e000000181cULL, 0x00000043004a7306ULL, 0x000ee20000200c00ULL,
0x000054103e3d7816ULL, 0x004fe4000000003fULL, 0x0000541042427816ULL, 0x002fca0000000013ULL,
0x0000003c2018723cULL, 0x000f620000001818ULL, 0x000054104a437816ULL, 0x008fce0000000049ULL,
0x000000422014723cULL, 0x000b6e0000001814ULL, 0x000176c86e207811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000020207f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176900068ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff137224ULL, 0x000fc600078e00ffULL, 0x0000000000227805ULL, 0x000fc80000015200ULL,
0x000004000a357984ULL, 0x000ee40000000800ULL, 0x8000000035ff7812ULL, 0x00afc40007804821ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003422377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e23ULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000113137810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000a357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe40007804821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c009207810ULL, 0x000fca0007ffe0ffULL,
0x0000660076367a24ULL, 0x000fe200078e0220ULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x0000002061137217ULL, 0x000fe20007800000ULL, 0x0000001074227824ULL, 0x000fe200078e00ffULL,
0x00000003ff217819ULL, 0x000fc6000001160dULL, 0x0000000113137824ULL, 0x000fe200078e0a20ULL,
0x0000000421347810ULL, 0x040fe20007ffe0ffULL, 0x0000000122207824ULL, 0x040fe200078e0221ULL,
0x0000000c21357810ULL, 0x000fe40007ffe0ffULL, 0x0000001322137217ULL, 0x000fe20007800000ULL,
0x0000000120237824ULL, 0x040fe400078e020dULL, 0x00000008203c7824ULL, 0x000fe400078e00ffULL,
0x0000000113137824ULL, 0x000fc400078e0a22ULL, 0x0000000120207824ULL, 0x000fe200078e0236ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee223ULL, 0x00000001223d7824ULL, 0x000fe200078e0235ULL,
0x000000133400720cULL, 0x080fe20003f66070ULL, 0x0000000122347824ULL, 0x000fe200078e0234ULL,
0x0000000821237810ULL, 0x000fe20007ffe0ffULL, 0x000000083d427824ULL, 0x000fe200078e00ffULL,
0x000000132100720cULL, 0x080fe20003f86070ULL, 0x0000000134217824ULL, 0x040fe200078e020dULL,
0x000000132300720cULL, 0x080fe20003f46070ULL, 0x00000008343e7824ULL, 0x000fe200078e00ffULL,
0x000000133500720cULL, 0x000fe20003f06070ULL, 0x0000000122237824ULL, 0x000fc400078e0223ULL,
0x0000000134227824ULL, 0x000fe200078e0236ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee221ULL,
0x0000008020207825ULL, 0x000fc800078e00ffULL, 0x0000000123347824ULL, 0x040fe200078e0236ULL,
0x0000005f20207212ULL, 0x000fe200078efcffULL, 0x0000000123137824ULL, 0x040fe400078e020dULL,
0x0000000823407824ULL, 0x000fe200078e00ffULL, 0x0000620020207a10ULL, 0x000fe20007fbe0ffULL,
0x0000008022227825ULL, 0x000fc600078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee213ULL,
0x000000013d367824ULL, 0x000fe200078e0236ULL, 0x0000005f22227212ULL, 0x080fe200078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000630021217a10ULL, 0x000fe40002ffe4ffULL,
0x0000620022227a10ULL, 0x000fe20007fbe0ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000005f34347212ULL, 0x080fe400078efcffULL, 0x0000630023237a10ULL, 0x000fe20002ffe4ffULL,
0x000000013d137824ULL, 0x000fe200078e020dULL, 0x0000005f36367212ULL, 0x000fe200078efcffULL,
0x000000103e3d7824ULL, 0x100fe200078e0279ULL, 0x0000620034347a10ULL, 0x000fe20007fbe0ffULL,
0x00000010403f7824ULL, 0x000fe200078e0279ULL, 0xfffffff842427812ULL, 0x000fe200078ee213ULL,
0x000000103c137824ULL, 0x000fe200078e0279ULL, 0x0000620036367a10ULL, 0x000fc40007fde0ffULL,
0x0000630035357a10ULL, 0x000fe20002ffe4ffULL, 0x0000001042417824ULL, 0x000fe200078e0279ULL,
0x0000630037377a10ULL, 0x000fe200037fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020137faeULL, 0x0003e8000e101c48ULL, 0x00000000223d7faeULL, 0x0003e8000d901c48ULL,
0x00000000343f7faeULL, 0x0003e8000d101c48ULL, 0x0000000036417faeULL, 0x0003e2000c101c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x0000001074207824ULL, 0x000fca00078e00ffULL,
0x000000200d137211ULL, 0x000fc800078fe8ffULL, 0x00000004133c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000113207824ULL, 0x140fe200078e020dULL, 0x0000000813347810ULL, 0x040fe20007ffe0ffULL,
0x0000000813237824ULL, 0x000fe400078e00ffULL, 0x000000013c217824ULL, 0x140fe400078e020dULL,
0x000000083c407824ULL, 0x000fe200078e00ffULL, 0xfffffff8233e7812ULL, 0x000fe200078ee220ULL,
0x0000000113207824ULL, 0x040fe200078e0236ULL, 0x0000000c13137810ULL, 0x000fe20007ffe0ffULL,
0x0000000134227824ULL, 0x000fe200078e020dULL, 0xfffffff840407812ULL, 0x000fe200078ee221ULL,
0x0000000834357824ULL, 0x000fc400078e00ffULL, 0x000000013c3c7824ULL, 0x000fe400078e0236ULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0xfffffff835427812ULL, 0x000fc600078ee222ULL,
0x0000000134347824ULL, 0x100fe200078e0236ULL, 0x0000005f20227212ULL, 0x000fe200078efcffULL,
0x0000000113367824ULL, 0x000fe400078e0236ULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x0000620022227a10ULL, 0x000fc60007f1e0ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000005f3c207212ULL, 0x000fc600078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000005f34347212ULL, 0x080fe400078efcffULL, 0x0000620020207a10ULL, 0x000fe20007f5e0ffULL,
0x0000000113237824ULL, 0x040fe200078e020dULL, 0x0000005f36367212ULL, 0x000fe200078efcffULL,
0x0000000813487824ULL, 0x000fe400078e00ffULL, 0x000000103e137824ULL, 0x100fe200078e0279ULL,
0x0000620036367a10ULL, 0x000fe20007f7e0ffULL, 0x00000010423f7824ULL, 0x000fe200078e0279ULL,
0xfffffff848487812ULL, 0x000fc400078ee223ULL, 0x0000630021237a10ULL, 0x000fe400007fe4ffULL,
0x0000620034347a10ULL, 0x000fe20007f1e0ffULL, 0x0000001048417824ULL, 0x100fe200078e0279ULL,
0x000063003d217a10ULL, 0x000fe200017fe4ffULL, 0x00000010403d7824ULL, 0x000fe200078e0279ULL,
0x0000630035357a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000022137faeULL, 0x0003e2000b901c48ULL, 0x0000630037377a10ULL, 0x000fc60001ffe4ffULL,
0x00000000203d7faeULL, 0x0003e8000b901c48ULL, 0x00000000343f7faeULL, 0x0003e8000b901c48ULL,
0x0000000036417faeULL, 0x0003e4000b901c48ULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xfffffff00c207812ULL, 0x000fce00078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176b00020207f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176480008227f8cULL, 0x0006a4000c80043fULL,
0x0000000000347805ULL, 0x000fc40000015200ULL, 0xffffffe00c087812ULL, 0x048fe400078ec0ffULL,
0x000000100c137812ULL, 0x040fe400078ec0ffULL, 0x000000080c367812ULL, 0x000fc800078ec0ffULL,
0x0000000836087210ULL, 0x000fca0007ffe013ULL, 0x01764c0008137984ULL, 0x000ee40000000800ULL,
0x8000000013ff7812ULL, 0x00cfe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000367805ULL, 0x000fcc0000015200ULL,
0x0000003634367210ULL, 0x000fca0007f1e1ffULL, 0x0000000137377824ULL, 0x000fe200000e0e35ULL,
0x003d09003600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff137819ULL, 0x000fc80000011437ULL, 0x0000003613137211ULL, 0x000fca00078110ffULL,
0x000000ffff367224ULL, 0x000fca00000e0637ULL, 0x0000000213137819ULL, 0x000fc80000001236ULL,
0x000000130000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01764c0008137984ULL, 0x000ea40000000800ULL, 0x8000000013ff7812ULL, 0x004fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000087824ULL, 0x000fca00078e00ffULL,
0xffffff8008087812ULL, 0x000fc800078ec0ffULL, 0x000001005f087810ULL, 0x000fca0007ffe008ULL,
0x000000017b087824ULL, 0x000fca00078e0208ULL, 0x0170000008237984ULL, 0x000ea80000000800ULL,
0x0172000008227984ULL, 0x0006620000000800ULL, 0x000000022300720bULL, 0x004fe20003f1d000ULL,
0x0000c9027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000137806ULL, 0x008fc800000e0100ULL,
0x0000ffff133d7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff087424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000027a137810ULL, 0x000fe40007ffe0ffULL, 0x000000022300720bULL, 0x000fe40003f54000ULL,
0x000000001300720cULL, 0x000fe20003f05270ULL, 0x0000c8c27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000087806ULL, 0x000fc400010e0100ULL, 0x0000008000348824ULL, 0x000fe200078e025fULL,
0x0000000223138209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x000000017b368824ULL, 0x000fe200078e0234ULL, 0x0000991008347816ULL, 0x000fc800000000ffULL,
0x0174001336008388ULL, 0x0005e20000000800ULL, 0x000000ff3400720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000223137209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff08ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000213137221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b13137820ULL, 0x000fc80000410000ULL,
0x00000013003c7308ULL, 0x000ea40000000800ULL, 0x0000003c11117220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff137819ULL, 0x000fe2000001160dULL,
0x0000c7f27f007947ULL, 0x000fea000b800000ULL, 0x00001f133c137589ULL, 0x0004e400000e0000ULL,
0x0000001330307220ULL, 0x08cfe40000410000ULL, 0x0000001331317220ULL, 0x080fe40000410000ULL,
0x000000132c2c7220ULL, 0x080fe40000410000ULL, 0x000000132d2d7220ULL, 0x000fc40000410000ULL,
0x0000001328287220ULL, 0x080fe40000410000ULL, 0x0000001329297220ULL, 0x080fe40000410000ULL,
0x0000001324247220ULL, 0x080fe40000410000ULL, 0x0000001325257220ULL, 0x080fe40000410000ULL,
0x0000001338387220ULL, 0x080fe40000410000ULL, 0x0000001339397220ULL, 0x000fc40000410000ULL,
0x000000131c1c7220ULL, 0x080fe40000410000ULL, 0x000000131d1d7220ULL, 0x080fe40000410000ULL,
0x0000001318187220ULL, 0x080fe40000410000ULL, 0x0000001319197220ULL, 0x080fe40000410000ULL,
0x0000001314147220ULL, 0x080fe40000410000ULL, 0x0000001315157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0008ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d137811ULL, 0x000fe200078ff0ffULL,
0x0000c6f27f007947ULL, 0x000fea000b800000ULL, 0x00001f133c137589ULL, 0x0004e400000e0000ULL,
0x0000001332327220ULL, 0x08cfe40000410000ULL, 0x0000001333337220ULL, 0x080fe40000410000ULL,
0x000000132e2e7220ULL, 0x080fe40000410000ULL, 0x000000132f2f7220ULL, 0x080fe40000410000ULL,
0x000000132a2a7220ULL, 0x080fe40000410000ULL, 0x000000132b2b7220ULL, 0x000fc40000410000ULL,
0x0000001326267220ULL, 0x080fe40000410000ULL, 0x0000001327277220ULL, 0x080fe40000410000ULL,
0x000000133a3a7220ULL, 0x080fe40000410000ULL, 0x000000133b3b7220ULL, 0x080fe40000410000ULL,
0x000000131e1e7220ULL, 0x080fe40000410000ULL, 0x000000131f1f7220ULL, 0x000fc40000410000ULL,
0x000000131a1a7220ULL, 0x080fe40000410000ULL, 0x000000131b1b7220ULL, 0x080fe40000410000ULL,
0x0000001316167220ULL, 0x080fe40000410000ULL, 0x0000001317177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff3dff7812ULL, 0x000fe20007806008ULL,
0x00000001ff087424ULL, 0x000fe200078e00ffULL, 0x0000000223027209ULL, 0x000fd60007810000ULL,
0x8000000223230221ULL, 0x000fe20000010000ULL, 0x00007610ff080816ULL, 0x000fc60000000008ULL,
0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL, 0x0000002300070308ULL, 0x000ea40000000800ULL,
0x0000000722220220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001122117221ULL, 0x002fc40000010000ULL, 0x0000000000227805ULL, 0x000fca0000015200ULL,
0xfffffff00c377812ULL, 0x000fca00078ec0ffULL, 0x0176ac0037137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804845ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003422347210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e23ULL,
0x003d09003400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff137819ULL, 0x000fc80000011435ULL, 0x0000003413137211ULL, 0x000fca00078110ffULL,
0x000000ffff347224ULL, 0x000fca00000e0635ULL, 0x0000000213137819ULL, 0x000fc80000001234ULL,
0x000000130000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac0037137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804845ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991008087816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000007ff05723eULL, 0x000fe400000000ffULL,
0x00000002ff237819ULL, 0x000fe4000001160dULL, 0x0000541005087816ULL, 0x000fe20000000005ULL,
0x0000c2d27f007947ULL, 0x000fea000b800000ULL, 0x00001f2308067589ULL, 0x0002a400000e0000ULL,
0x0000000823137810ULL, 0x000fe20007ffe0ffULL, 0x0000c3227f007947ULL, 0x000fea000b800000ULL,
0x00001f1308057589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001023137810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff347224ULL, 0x000fe200078e0008ULL,
0x000079e000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000cb2000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001823137810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff347224ULL, 0x000fe200078e0008ULL, 0x00007a5000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000cab000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001046407824ULL, 0x100fe200078e0262ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000100e347824ULL, 0x100fe200078e0262ULL, 0x012000004744783bULL, 0x000f220000000200ULL,
0x00000010123c7824ULL, 0x000fc600078e0262ULL, 0x000000004040783bULL, 0x000ee80000004200ULL,
0x000000003434783bULL, 0x000ea80000004200ULL, 0x000000003c3c783bULL, 0x000e620000004200ULL,
0x0000000644448232ULL, 0x094fe40000000000ULL, 0x0000000646468232ULL, 0x000fe20000000000ULL,
0x0000010040087824ULL, 0x04afe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011440ULL,
0x0000010041137824ULL, 0x040fe200078e00ffULL, 0x00008880404c7816ULL, 0x040fe200000000ffULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff087819ULL, 0x000fe20000011408ULL,
0x0000000545458232ULL, 0x080fe20000000000ULL, 0x00000018ff497819ULL, 0x000fe20000011441ULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x00008880414e7816ULL, 0x040fe200000000ffULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011442ULL,
0x0000000547478232ULL, 0x000fe20000000000ULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000010034227824ULL, 0x000fe200078e00ffULL, 0x0000888042507816ULL, 0x000fe200000000ffULL,
0x00000008004d7306ULL, 0x0003e20000200c00ULL, 0x00000018ff137819ULL, 0x000fc40000011413ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000018ff5c7819ULL, 0x000fe40000011434ULL,
0x00000018ff557819ULL, 0x000fe20000011443ULL, 0x00000040004b7306ULL, 0x0004e20000200c00ULL,
0x0000010042087824ULL, 0x042fe200078e00ffULL, 0x0000888043517816ULL, 0x000fe200000000ffULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff127819ULL, 0x000fe4000001143eULL,
0x00000018ff087819ULL, 0x000fc40000011408ULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x0000010035407824ULL, 0x004fe200078e00ffULL, 0x0000004c004c7306ULL, 0x000e620000200c00ULL,
0x000088803e667816ULL, 0x000fe400000000ffULL, 0x000088803c6b7816ULL, 0x000fe400000000ffULL,
0x000088803d6a7816ULL, 0x000fe400000000ffULL, 0x000054104b487816ULL, 0x008fe20000000048ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff647819ULL, 0x000fc4000001143cULL,
0x00000018ff637819ULL, 0x000fe4000001143dULL, 0x000088803f657816ULL, 0x000fe400000000ffULL,
0x00000018ff237819ULL, 0x000fe20000011422ULL, 0x00000013004f7306ULL, 0x0004e20000200c00ULL,
0x000054104c4c7816ULL, 0x002fe4000000004dULL, 0x00000018ff5b7819ULL, 0x000fe40000011435ULL,
0x0000888035227816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fe2000001143fULL, 0x00000041004a7306ULL, 0x0003e20000200c00ULL,
0x0000010043137824ULL, 0x044fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe20000011437ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011435ULL,
0x0000010036357824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fc40000011413ULL,
0x0000004200577306ULL, 0x0005e20000200c00ULL, 0x00000018ff417819ULL, 0x002fe20000011440ULL,
0x0001000034407824ULL, 0x000fe200078e00ffULL, 0x000054104e4d7816ULL, 0x008fe4000000004fULL,
0x0000888034137816ULL, 0x000fe400000000ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000004900497306ULL, 0x000e620000200c00ULL, 0x000000080d427812ULL, 0x004fe200078ec0ffULL,
0x0000004c444c723cULL, 0x000b620000001838ULL, 0x00000018ff437819ULL, 0x000fc40000011443ULL,
0x0000000742427812ULL, 0x000fe400078ef80dULL, 0x00000018ff597819ULL, 0x000fe20000011435ULL,
0x0000004000787306ULL, 0x0005e20000200c00ULL, 0x000000070d3a7812ULL, 0x020fe200078ec0ffULL,
0x00000001420f7824ULL, 0x040fe200078e020fULL, 0x0000888037357816ULL, 0x000fe200000000ffULL,
0x0000000842427824ULL, 0x000fe200078e00ffULL, 0x000000083a3a7812ULL, 0x000fe200078ef80dULL,
0x000001003f387824ULL, 0x000fe200078e00ffULL, 0x00008880365a7816ULL, 0x000fe200000000ffULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x000001003c407824ULL, 0x004fe200078e00ffULL,
0xfffffff8420f7812ULL, 0x000fe200078ee20fULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x000054104a497816ULL, 0x002fc40000000049ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000000800087306ULL, 0x000e620000200c00ULL, 0x00000018ff397819ULL, 0x000fe20000011438ULL,
0x000100003e387824ULL, 0x000fe200078e00ffULL, 0x000000484448723cULL, 0x000b62000000181cULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff5e7819ULL, 0x000fe40000011436ULL,
0x00000040006c7306ULL, 0x0005e20000200c00ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x000000083a1c7824ULL, 0x020fcc00078e00ffULL, 0x0000004100347306ULL, 0x0007e20000200c00ULL,
0x000000100f407824ULL, 0x004fe200078e0262ULL, 0x0000541050507816ULL, 0x002fe20000000008ULL,
0x000001003e0f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff0f7819ULL, 0x000fe2000001140fULL,
0x000001003d417824ULL, 0x048fe200078e00ffULL, 0x0000004300567306ULL, 0x000fe20000200c00ULL,
0x000100003d3d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff3d7819ULL, 0x000fe4000001143dULL, 0x0000000f00677306ULL, 0x0003f00000200c00ULL,
0x00000041006d7306ULL, 0x0005e20000200c00ULL, 0x00000002100f7810ULL, 0x002fc80007ffe0ffULL,
0xfffffff81c1c7812ULL, 0x000fc600078ee20fULL, 0x00000038006f7306ULL, 0x0003e20000200c00ULL,
0x000000004040783bULL, 0x004ea20000004200ULL, 0x000000101c087824ULL, 0x000fcc00078e00ffULL,
0x00000039003e7306ULL, 0x0007e20000200c00ULL, 0x0001200004387810ULL, 0x002fce0007ffe008ULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x000000003838783bULL, 0x008eee0000000200ULL,
0x0000005500557306ULL, 0x000f300000200c00ULL, 0x0000006b006b7306ULL, 0x000ea20000200c00ULL,
0x0000541057547816ULL, 0x002fce0000000054ULL, 0x0000006a006a7306ULL, 0x000e620000200c00ULL,
0x0000541056557816ULL, 0x010fe40000000055ULL, 0x0000888040717816ULL, 0x004fe400000000ffULL,
0x0000888041707816ULL, 0x000fe400000000ffULL, 0x00000018ff047819ULL, 0x000fe20000011443ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000000544454723cULL, 0x000b620000001814ULL,
0x000054106b1c7816ULL, 0x000fc4000000006cULL, 0x00000018ff0f7819ULL, 0x000fc80000011442ULL,
0x0000005200527306ULL, 0x000ea20000200c00ULL, 0x0000010040147824ULL, 0x020fe200078e00ffULL,
0x0000000638388232ULL, 0x088fe20000000000ULL, 0x0000010041157824ULL, 0x000fe200078e00ffULL,
0x000000063a3a8232ULL, 0x000fe20000000000ULL, 0x000054106a1d7816ULL, 0x002fe2000000006dULL,
0x0000000539398232ULL, 0x080fe20000000000ULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x000000053b3b8232ULL, 0x000fe20000000000ULL,
0x00000018ff157819ULL, 0x000fcc0000011415ULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x0000541051517816ULL, 0x004fe20000000052ULL, 0x0000001c381c723cULL, 0x000bec000000184cULL,
0x0000003c00697306ULL, 0x0002a20000200c00ULL, 0x00008880434e7816ULL, 0x020fe200000000ffULL,
0x000000504450723cULL, 0x000bec0000001818ULL, 0x0000003d00687306ULL, 0x0007220000200c00ULL,
0x00000018ff3c7819ULL, 0x002fe20000011440ULL, 0x0001000040407824ULL, 0x000fca00078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000001400727306ULL, 0x0003e20000200c00ULL,
0x00000018ff3d7819ULL, 0x008fe20000011441ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x0000541069187816ULL, 0x024fc80000000064ULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000888042147816ULL, 0x002fe400000000ffULL,
0x0000541068197816ULL, 0x010fc60000000063ULL, 0x000000ffff4c7224ULL, 0x000fe400078e0014ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000010042147824ULL, 0x000fe200078e00ffULL,
0x000000183818723cULL, 0x000be80000001848ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000001500737306ULL, 0x0003f00000200c00ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000010043157824ULL, 0x002fc400078e00ffULL, 0x0001000043437824ULL, 0x000fca00078e00ffULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff437819ULL, 0x000fce0000011443ULL,
0x00000040006b7306ULL, 0x0002b00000200c00ULL, 0x00000041006a7306ULL, 0x0007220000200c00ULL,
0x0001000042407824ULL, 0x002fca00078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000006500657306ULL, 0x000e620000200c00ULL, 0x00000018ff417819ULL, 0x008fe40000011415ULL,
0x000054106b3c7816ULL, 0x004fca000000003cULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x000054106a3d7816ULL, 0x010fce000000003dULL, 0x00000014004d7306ULL, 0x000ea20000200c00ULL,
0x0000541065157816ULL, 0x002fce000000003eULL, 0x0000004e004e7306ULL, 0x000ff00000200c00ULL,
0x0000004100427306ULL, 0x0002f00000200c00ULL, 0x0000004000487306ULL, 0x0209e20000200c00ULL,
0x0000541070417816ULL, 0x002fce0000000073ULL, 0x0000000f000f7306ULL, 0x000e620000200c00ULL,
0x0000541071407816ULL, 0x010fce0000000072ULL, 0x0000000400047306ULL, 0x000fe20000200c00ULL,
0x000000404430723cULL, 0x040b6e0000001830ULL, 0x0000004300437306ULL, 0x000f220000200c00ULL,
0x000100003f417824ULL, 0x020fe400078e00ffULL, 0x0000003c443c723cULL, 0x000b62000000182cULL,
0x0000010037407824ULL, 0x000fc400078e00ffULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x0000001200127306ULL, 0x000e620000200c00ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x000054104c2c7816ULL, 0x024fe4000000004dULL,
0x000054104e2d7816ULL, 0x008fe40000000042ULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000005800587306ULL, 0x000fe80000200c00ULL, 0x0000002c442c723cULL, 0x000b680000001828ULL,
0x0000004100417306ULL, 0x000ea60000200c00ULL, 0x00010000362a7824ULL, 0x020fe200078e00ffULL,
0x0000541048287816ULL, 0x002fc4000000000fULL, 0x0000541043297816ULL, 0x010fe40000000004ULL,
0x00000018ff047819ULL, 0x000fe2000001142aULL, 0x0000002200227306ULL, 0x000e680000200c00ULL,
0x000000284444723cULL, 0x000b680000001824ULL, 0x0000005c005c7306ULL, 0x000ee60000200c00ULL,
0x000054106f247816ULL, 0x020fc40000000012ULL, 0x0000541041257816ULL, 0x004fc60000000058ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x0000541022297816ULL, 0x002fc60000000034ULL,
0x000000243854723cULL, 0x000b680000001854ULL, 0x0000001300137306ULL, 0x000fe60000200c00ULL,
0x0000541078247816ULL, 0x028fca000000005cULL, 0x0000002300237306ULL, 0x000e700000200c00ULL,
0x0000007700777306ULL, 0x000eb00000200c00ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x0000541013287816ULL, 0x002fce0000000023ULL, 0x0000005900597306ULL, 0x000e620000200c00ULL,
0x0000541077257816ULL, 0x004fe2000000005bULL, 0x000000283828723cULL, 0x040b6c0000001830ULL,
0x0000003500357306ULL, 0x000fe40000200c00ULL, 0x000000243824723cULL, 0x000b6c000000183cULL,
0x0000006600667306ULL, 0x000ea20000200c00ULL, 0x000054105a347816ULL, 0x002fce0000000059ULL,
0x0000004000367306ULL, 0x000e700000200c00ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x0000541066147816ULL, 0x004fce0000000067ULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x0000541035357816ULL, 0x002fe20000000036ULL, 0x000000143814723cULL, 0x040b6c0000001850ULL,
0x00000004000f7306ULL, 0x0002a40000200c00ULL, 0x00000034382c723cULL, 0x000b6c000000182cULL,
0x0000003700127306ULL, 0x000ee20000200c00ULL, 0x000176987a047811ULL, 0x002fc400078e18ffULL,
0x000054100f5c7816ULL, 0x004fe4000000005eULL, 0x00005410125d7816ULL, 0x008fce000000005dULL,
0x0000005c3838723cULL, 0x000b620000001844ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000000a307f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000004ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff0f7224ULL, 0x000fc600078e00ffULL, 0x0000000000127805ULL, 0x000fc80000015200ULL,
0x000004000a237984ULL, 0x000f240000000800ULL, 0x8000000023ff7812ULL, 0x014fe40007804831ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002212337210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e13ULL,
0x003d09003300780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403300780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x008fc80000011423ULL, 0x0000003304047211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x0000000204047819ULL, 0x000fc80000001223ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000a237984ULL, 0x000ea40000000800ULL, 0x8000000023ff7812ULL, 0x004fe40007804831ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010b047810ULL, 0x008fc80007ffe0ffULL,
0x000000750400720cULL, 0x000fda0003f06070ULL, 0x0000072000000947ULL, 0x000fea0003800000ULL,
0x000000020b047810ULL, 0x000fe40007ffe0ffULL, 0x0000010009097810ULL, 0x000fe40007ffe0ffULL,
0x000000750400720cULL, 0x000fc60003f06070ULL, 0x00006600760f7a24ULL, 0x000fd400078e0209ULL,
0x000003d000008947ULL, 0x000fea0003800000ULL, 0x0000000961047217ULL, 0x000fe20007800000ULL,
0x0000001074137824ULL, 0x000fe200078e00ffULL, 0x00000003ff127819ULL, 0x000fc6000001160dULL,
0x0000000104047824ULL, 0x000fe200078e0a09ULL, 0x0000000412237810ULL, 0x040fe20007ffe0ffULL,
0x0000000113227824ULL, 0x040fe200078e0212ULL, 0x0000000812317810ULL, 0x000fe40007ffe0ffULL,
0x0000000413047217ULL, 0x000fe20007800000ULL, 0x0000000122097824ULL, 0x040fe400078e020dULL,
0x0000000822307824ULL, 0x000fe400078e00ffULL, 0x0000000104047824ULL, 0x000fc400078e0a13ULL,
0x0000000113327824ULL, 0x040fe200078e0231ULL, 0xfffffff830097812ULL, 0x000fe200078ee209ULL,
0x0000000113307824ULL, 0x000fe200078e0223ULL, 0x000000042300720cULL, 0x080fe40003f66070ULL,
0x000000041200720cULL, 0x080fe20003f86070ULL, 0x0000000830357824ULL, 0x000fe200078e00ffULL,
0x0000000c12237810ULL, 0x000fe20007ffe0ffULL, 0x0000000122127824ULL, 0x000fe200078e020fULL,
0x000000043100720cULL, 0x080fe20003f46070ULL, 0x0000000130227824ULL, 0x000fe200078e020dULL,
0x000000042300720cULL, 0x000fe20003f06070ULL, 0x0000000113347824ULL, 0x000fc400078e0223ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fc600078ee222ULL,
0x0000000130227824ULL, 0x000fe200078e020fULL, 0x0000005f12127212ULL, 0x000fe200078efcffULL,
0x0000000132047824ULL, 0x040fe400078e020dULL, 0x0000000832317824ULL, 0x000fe200078e00ffULL,
0x0000620012127a10ULL, 0x000fe20007fbe0ffULL, 0x0000008022227825ULL, 0x000fc600078e00ffULL,
0x0000630013137a10ULL, 0x000fe20002ffe4ffULL, 0x0000000132307824ULL, 0x100fe200078e020fULL,
0x0000005f22227212ULL, 0x000fe200078efcffULL, 0x0000000134327824ULL, 0x000fe200078e020fULL,
0xfffffff8310f7812ULL, 0x000fe200078ee204ULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x0000620022227a10ULL, 0x000fc60007fbe0ffULL, 0x0000008032327825ULL, 0x000fe200078e00ffULL,
0x0000005f30307212ULL, 0x080fe400078efcffULL, 0x0000630023237a10ULL, 0x000fe20002ffe4ffULL,
0x0000000134047824ULL, 0x000fe200078e020dULL, 0x0000005f32327212ULL, 0x000fe200078efcffULL,
0x0000000834377824ULL, 0x000fe200078e00ffULL, 0x0000620030307a10ULL, 0x000fe20007fbe0ffULL,
0x0000001009097824ULL, 0x100fe200078e0262ULL, 0x0000620032327a10ULL, 0x000fe20007fde0ffULL,
0x0000001035357824ULL, 0x000fe200078e0262ULL, 0xfffffff837377812ULL, 0x000fe200078ee204ULL,
0x000000100f0f7824ULL, 0x100fe200078e0262ULL, 0x0000630031317a10ULL, 0x000fe20002ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012097faeULL, 0x0005e2000e101c48ULL,
0x0000630033337a10ULL, 0x000fe200037fe4ffULL, 0x0000001037377824ULL, 0x000fc400078e0262ULL,
0x0000000022357faeULL, 0x0005e8000d901c48ULL, 0x00000000300f7faeULL, 0x0005e8000d101c48ULL,
0x0000000032377faeULL, 0x0005e2000c101c48ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001074047824ULL, 0x000fca00078e00ffULL, 0x000000040d047211ULL, 0x000fc800078fe8ffULL,
0x0000000404327810ULL, 0x040fe20007ffe0ffULL, 0x0000000104097824ULL, 0x140fe200078e020dULL,
0x0000000804227810ULL, 0x040fe20007ffe0ffULL, 0x0000000804307824ULL, 0x000fe400078e00ffULL,
0x0000000132127824ULL, 0x040fe400078e020dULL, 0x0000000832357824ULL, 0x000fe200078e00ffULL,
0xfffffff830097812ULL, 0x000fe200078ee209ULL, 0x0000000122137824ULL, 0x040fe400078e020dULL,
0x0000000822347824ULL, 0x000fe200078e00ffULL, 0xfffffff835357812ULL, 0x000fe200078ee212ULL,
0x0000000104127824ULL, 0x140fe200078e020fULL, 0x0000000c04047810ULL, 0x000fe20007ffe0ffULL,
0x0000000132327824ULL, 0x000fe200078e020fULL, 0xfffffff834377812ULL, 0x000fe200078ee213ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x0000000122227824ULL, 0x100fe200078e020fULL,
0x0000005f12127212ULL, 0x000fe200078efcffULL, 0x0000000104307824ULL, 0x000fe400078e020fULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0x0000620012127a10ULL, 0x000fc60007f1e0ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000005f32327212ULL, 0x080fe400078efcffULL,
0x0000630013137a10ULL, 0x000fe200007fe4ffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x0000005f22227212ULL, 0x080fe400078efcffULL, 0x0000620032327a10ULL, 0x000fe20007f5e0ffULL,
0x00000001040f7824ULL, 0x000fe200078e020dULL, 0x0000005f30307212ULL, 0x000fe200078efcffULL,
0x0000000804047824ULL, 0x000fe200078e00ffULL, 0x0000620022227a10ULL, 0x000fe20007f1e0ffULL,
0x0000001009097824ULL, 0x100fe200078e0262ULL, 0x0000620030307a10ULL, 0x000fe20007f7e0ffULL,
0x0000001035357824ULL, 0x100fe200078e0262ULL, 0xfffffff8040f7812ULL, 0x000fe200078ee20fULL,
0x0000001037377824ULL, 0x100fe200078e0262ULL, 0x0000630033337a10ULL, 0x000fe200017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012097faeULL, 0x0005e2000b901c48ULL,
0x0000630023237a10ULL, 0x000fe200007fe4ffULL, 0x000000100f0f7824ULL, 0x000fe200078e0262ULL,
0x0000630031317a10ULL, 0x000fe20001ffe4ffULL, 0x0000000032357faeULL, 0x0005e8000b901c48ULL,
0x0000000022377faeULL, 0x0005e8000b901c48ULL, 0x00000000300f7faeULL, 0x0005e4000b901c48ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0x000000106e097824ULL, 0x000fe200078e00ffULL,
0x000000080c047812ULL, 0x000fc400078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a04ULL,
0x0000001009097812ULL, 0x000fca00078ee2ffULL, 0x000000207a097824ULL, 0x000fc800078e0209ULL,
0x0000000104097824ULL, 0x000fe200078e0209ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff127f8cULL, 0x000ea2000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176680009307f8cULL, 0x000662000c80043fULL,
0x000000ffff047224ULL, 0x004fc600078e0013ULL, 0x0000000000127805ULL, 0x000fc80000015200ULL,
0x01766c00090f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x006fe40007804831ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002212227210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e13ULL, 0x003d09002200780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402200780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0f7819ULL, 0x000fc80000011423ULL,
0x000000220f0f7211ULL, 0x000fca00078110ffULL, 0x000000ffff227224ULL, 0x000fca00000e0623ULL,
0x000000020f0f7819ULL, 0x000fc80000001222ULL, 0x0000000f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000132327810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01766c00090f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804831ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001807a127811ULL, 0x000fc800078e38ffULL, 0x000000127b127210ULL, 0x000fca0007ffe05fULL,
0x0170000012097984ULL, 0x008e680000000800ULL, 0x0172000012227984ULL, 0x0004e20000000800ULL,
0x000000020900720bULL, 0x002fe20003f1d000ULL, 0x0000a5527f007947ULL, 0x000fd8000b800000ULL,
0x0000000000137806ULL, 0x004fc800000e0100ULL, 0x0000ffff13307812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff127224ULL, 0x000fd200078e0002ULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x000000037a0f7810ULL, 0x000fe40007ffe0ffULL, 0x000000020900720bULL, 0x000fe40003f54000ULL,
0x000000000f00720cULL, 0x000fe20003f05270ULL, 0x0000a5027f007947ULL, 0x000fd4000b800000ULL,
0x00000000000f7806ULL, 0x000fc400010e0100ULL, 0x0000008000328824ULL, 0x000fe200078e025fULL,
0x0000000209127209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x000099100f137816ULL, 0x000fe200000000ffULL, 0x000000017b7b8824ULL, 0x000fca00078e0232ULL,
0x017400127b008388ULL, 0x0003e20000000800ULL, 0x000000ff1300720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000000212027221ULL, 0x002fe20000010100ULL,
0x000000ff0fff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b02027820ULL, 0x000fcc0000410000ULL, 0x0000000200027308ULL, 0x000e640000000800ULL,
0x0000000211117220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff137819ULL, 0x000fe2000001160dULL, 0x0000a4427f007947ULL, 0x000fea000b800000ULL,
0x00001f1302137589ULL, 0x0002a400000e0000ULL, 0x0000001328287220ULL, 0x084fe40000410000ULL,
0x0000001329297220ULL, 0x080fe40000410000ULL, 0x0000001324247220ULL, 0x080fe40000410000ULL,
0x0000001325257220ULL, 0x000fc40000410000ULL, 0x000000132c2c7220ULL, 0x080fe40000410000ULL,
0x000000132d2d7220ULL, 0x080fe40000410000ULL, 0x0000001338387220ULL, 0x080fe40000410000ULL,
0x0000001339397220ULL, 0x080fe40000410000ULL, 0x000000131c1c7220ULL, 0x080fe40000410000ULL,
0x000000131d1d7220ULL, 0x000fc40000410000ULL, 0x0000001318187220ULL, 0x080fe40000410000ULL,
0x0000001319197220ULL, 0x080fe40000410000ULL, 0x0000001314147220ULL, 0x080fe40000410000ULL,
0x0000001315157220ULL, 0x080fe40000410000ULL, 0x0000001354547220ULL, 0x080fe40000410000ULL,
0x0000001355557220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000fff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080d137811ULL, 0x000fe200078ff0ffULL, 0x0000a3427f007947ULL, 0x000fea000b800000ULL,
0x00001f1302137589ULL, 0x00046400000e0000ULL, 0x000000132a2a7220ULL, 0x086fe40000410000ULL,
0x000000132b2b7220ULL, 0x080fe40000410000ULL, 0x0000001326267220ULL, 0x080fe40000410000ULL,
0x0000001327277220ULL, 0x080fe40000410000ULL, 0x000000132e2e7220ULL, 0x080fe40000410000ULL,
0x000000132f2f7220ULL, 0x000fc40000410000ULL, 0x000000133a3a7220ULL, 0x080fe40000410000ULL,
0x000000133b3b7220ULL, 0x080fe40000410000ULL, 0x000000131e1e7220ULL, 0x080fe40000410000ULL,
0x000000131f1f7220ULL, 0x080fe40000410000ULL, 0x000000131a1a7220ULL, 0x080fe40000410000ULL,
0x000000131b1b7220ULL, 0x000fc40000410000ULL, 0x0000001316167220ULL, 0x080fe40000410000ULL,
0x0000001317177220ULL, 0x080fe40000410000ULL, 0x0000001356567220ULL, 0x080fe40000410000ULL,
0x0000001357577220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff30ff7812ULL, 0x000fe2000780600fULL, 0x00000001ff0f7424ULL, 0x000fd800078e00ffULL,
0x0000000912090221ULL, 0x000fe20000010100ULL, 0x00007610ff0f0816ULL, 0x000fc6000000000fULL,
0x3fb8aa3b09090820ULL, 0x000fc80000410000ULL, 0x0000000900070308ULL, 0x000e640000000800ULL,
0x0000000722220220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001122117221ULL, 0x008fc40000010000ULL, 0x0000000000227805ULL, 0x000fca0000015200ULL,
0xfffffff00c137812ULL, 0x000fe200078ec0ffULL, 0x0000000400027824ULL, 0x000fc800078e00ffULL,
0x0176b40013097984ULL, 0x000e620000000800ULL, 0x0000000402027812ULL, 0x000fc800078ec0ffULL,
0x0000000202027812ULL, 0x000fe400078efcffULL, 0x8000000009ff7812ULL, 0x002fe20007804821ULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000103200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fcc0000015200ULL,
0x0000003022307210ULL, 0x000fca0007f1e1ffULL, 0x0000000131317824ULL, 0x000fe200000e0e23ULL,
0x003d09003000780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403000780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011431ULL, 0x0000003009097211ULL, 0x000fca00078110ffULL,
0x000000ffff307224ULL, 0x000fca00000e0631ULL, 0x0000000209097819ULL, 0x000fc80000001230ULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000132327810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0176b40013097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804821ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100f097816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0900720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000007ff05723eULL, 0x000fe400000000ffULL, 0x00000002ff207819ULL, 0x000fe4000001160dULL,
0x0000541005097816ULL, 0x000fe20000000005ULL, 0x00009ee27f007947ULL, 0x000fea000b800000ULL,
0x00001f2009067589ULL, 0x0002a400000e0000ULL, 0x0000000820137810ULL, 0x000fe20007ffe0ffULL,
0x00009f327f007947ULL, 0x000fea000b800000ULL, 0x00001f1309057589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001020137810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff347224ULL, 0x000fe200078e0009ULL, 0x0000a03000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000a4d000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001820137810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff347224ULL, 0x000fe200078e0009ULL,
0x0000a0a000357802ULL, 0x000fe20000000f00ULL, 0x0000001fff377424ULL, 0x000fc400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000a46000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000070d367812ULL, 0x040fe200078ec0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000080d137812ULL, 0x00cfe400078ec0ffULL,
0x0000000836097812ULL, 0x002fe400078ef80dULL, 0x000000037a467810ULL, 0x000fc60007ffe0ffULL,
0x0000000809097824ULL, 0x000fca00078e00ffULL, 0xfffffff809097812ULL, 0x000fca00078ee210ULL,
0x000000807a347824ULL, 0x000fca00078e0209ULL, 0x0001280034347811ULL, 0x000fc400078e20ffULL,
0x000000006030783bULL, 0x000e640000004200ULL, 0x0000010030097824ULL, 0x002fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe20000011431ULL, 0x00000100310f7824ULL, 0x040fe200078e00ffULL,
0x00008880314a7816ULL, 0x040fe200000000ffULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe40000011409ULL, 0x0000100062097810ULL, 0x000fe20007ffe0ffULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff317819ULL, 0x000fc40000011431ULL,
0x00000018ff497819ULL, 0x000fe20000011430ULL, 0x000000100e207824ULL, 0x000fe200078e0209ULL,
0x0000888030507816ULL, 0x040fe200000000ffULL, 0x0001000030307824ULL, 0x000fe200078e00ffULL,
0x00000018ff0f7819ULL, 0x000fe2000001140fULL, 0x00000031006b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff5f7819ULL, 0x000fe20000011432ULL, 0x000000002020783bULL, 0x000ea20000004200ULL,
0x00000018ff5e7819ULL, 0x000fe20000011433ULL, 0x00000100320e7824ULL, 0x040fe200078e00ffULL,
0x0000888032437816ULL, 0x040fe200000000ffULL, 0x0001000032327824ULL, 0x000fe200078e00ffULL,
0x0000888033417816ULL, 0x000fe200000000ffULL, 0x0000000f006d7306ULL, 0x0007e20000200c00ULL,
0x0000003613317212ULL, 0x002fc400078efcffULL, 0x000000020d367211ULL, 0x000fe400078fe0ffULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000000131027824ULL, 0x040fe200078e0236ULL, 0x00000030006c7306ULL, 0x0005e20000200c00ULL,
0x0000000831317824ULL, 0x000fe200078e00ffULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x00000100330f7824ULL, 0x048fe400078e00ffULL, 0x0001000033337824ULL, 0x000fe200078e00ffULL,
0xfffffff831027812ULL, 0x000fc400078ee202ULL, 0x00000018ff0f7819ULL, 0x000fe2000001140fULL,
0x0000003200687306ULL, 0x000fe20000200c00ULL, 0x00000018ff337819ULL, 0x000fe20000011433ULL,
0x0000001002027824ULL, 0x000fcc00078e0279ULL, 0x0000000f00427306ULL, 0x000fe20000200c00ULL,
0x00000018ff307819ULL, 0x004fce0000011422ULL, 0x0000003300677306ULL, 0x000fe20000200c00ULL,
0x00000018ff5b7819ULL, 0x000fe20000011420ULL, 0x0000010021137824ULL, 0x040fe200078e00ffULL,
0x0000888020637816ULL, 0x000fe400000000ffULL, 0x00000018ff5a7819ULL, 0x000fe40000011421ULL,
0x0000888021607816ULL, 0x040fe200000000ffULL, 0x00000030000f7306ULL, 0x0003e20000200c00ULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x0000888022537816ULL, 0x000fc400000000ffULL,
0x00000018ff107819ULL, 0x000fe40000011423ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000000e00407306ULL, 0x0005e20000200c00ULL, 0x000000000230783bULL, 0x0022e20000004200ULL,
0x0000888023587816ULL, 0x000fe400000000ffULL, 0x00000018ff137819ULL, 0x000fc80000011413ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x00000100200e7824ULL, 0x044fe400078e00ffULL,
0x0001000020207824ULL, 0x000fe400078e00ffULL, 0x0000010023027824ULL, 0x042fe200078e00ffULL,
0x00000018ff0e7819ULL, 0x000fe2000001140eULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011420ULL, 0x0000004c004c7306ULL, 0x000e620000200c00ULL,
0x00000018ff027819ULL, 0x000fc40000011402ULL, 0x00000018ff237819ULL, 0x000fca0000011423ULL,
0x0000000e00627306ULL, 0x0005f00000200c00ULL, 0x00000020005d7306ULL, 0x0007e20000200c00ULL,
0x00000001030e7824ULL, 0x044fe400078e0236ULL, 0x000000003434783bULL, 0x000ea20000000200ULL,
0x0000000803037824ULL, 0x000fc800078e00ffULL, 0x0000004a004a7306ULL, 0x000f220000200c00ULL,
0x0000010030207824ULL, 0x048fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011430ULL,
0x00008880304f7816ULL, 0x040fe200000000ffULL, 0x0001000030307824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000021005c7306ULL, 0x0007e20000200c00ULL,
0xfffffff8030e7812ULL, 0x000fe200078ee20eULL, 0x0000010022037824ULL, 0x040fe200078e00ffULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011431ULL, 0x000000100e0e7824ULL, 0x000fe200078e0209ULL,
0x00008880314e7816ULL, 0x040fe200000000ffULL, 0x00000020004d7306ULL, 0x0003e20000200c00ULL,
0x0000010031217824ULL, 0x048fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x000000000e3c783bULL, 0x000ee20000004200ULL, 0x0001000031317824ULL, 0x000fe200078e00ffULL,
0x00000018ff037819ULL, 0x000fc40000011403ULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000003000667306ULL, 0x0009e20000200c00ULL, 0x0000010032207824ULL, 0x042fe200078e00ffULL,
0x00000018ff317819ULL, 0x000fe40000011431ULL, 0x00000018ff447819ULL, 0x000fe40000011433ULL,
0x0000888032457816ULL, 0x000fe400000000ffULL, 0x0000002100517306ULL, 0x0003e20000200c00ULL,
0x00000018ff307819ULL, 0x010fe20000011420ULL, 0x0000000634348232ULL, 0x084fe20000000000ULL,
0x0000541050207816ULL, 0x000fe2000000004cULL, 0x0000000636368232ULL, 0x000fe20000000000ULL,
0x00008880334c7816ULL, 0x000fe200000000ffULL, 0x0000000535358232ULL, 0x000fc40000000000ULL,
0x00000022006a7306ULL, 0x0005e20000200c00ULL, 0x0000000537378232ULL, 0x000fe20000000000ULL,
0x000054104a217816ULL, 0x002fcc000000006dULL, 0x0000002300697306ULL, 0x0003e20000200c00ULL,
0x0000080046227824ULL, 0x004fe200078e0208ULL, 0x000000203428723cULL, 0x000be20000001828ULL,
0x0000010033087824ULL, 0x040fe400078e00ffULL, 0x0001000033337824ULL, 0x000fc600078e00ffULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x011000002220783bULL, 0x022e620000000200ULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x00000018ff097819ULL, 0x008fe4000001143cULL,
0x00000018ff337819ULL, 0x000fe40000011433ULL, 0x0000004300437306ULL, 0x000ea20000200c00ULL,
0x00000018ff0e7819ULL, 0x000fce000001143dULL, 0x0000004100417306ULL, 0x000ef00000200c00ULL,
0x0000005f005f7306ULL, 0x000f220000200c00ULL, 0x0000541043407816ULL, 0x004fce0000000040ULL,
0x0000005e005e7306ULL, 0x000ea20000200c00ULL, 0x0000541041417816ULL, 0x008fce0000000042ULL,
0x0000003100657306ULL, 0x0007e20000200c00ULL, 0x000000403440723cULL, 0x000be2000000182cULL,
0x0000000620208232ULL, 0x082fe40000000000ULL, 0x0000000622228232ULL, 0x000fe40000000000ULL,
0x0000000521218232ULL, 0x080fe40000000000ULL, 0x0000003000467306ULL, 0x0003e20000200c00ULL,
0x000054106b317816ULL, 0x008fe2000000004bULL, 0x0000000523238232ULL, 0x000fe20000000000ULL,
0x00005410682c7816ULL, 0x030fc4000000005fULL, 0x00005410672d7816ULL, 0x004fe4000000005eULL,
0x000088803d2e7816ULL, 0x000fe200000000ffULL, 0x0000005b005b7306ULL, 0x000ea20000200c00ULL,
0x000054106c307816ULL, 0x002fe40000000049ULL, 0x000088803c6c7816ULL, 0x000fe200000000ffULL,
0x0000002c3438723cULL, 0x000be20000001838ULL, 0x000000ffff5e7224ULL, 0x000fc600078e002eULL,
0x0000005a005a7306ULL, 0x000e660000200c00ULL, 0x000001003d2c7824ULL, 0x060fe200078e00ffULL,
0x000000303424723cULL, 0x000b620000001824ULL, 0x000100003d3d7824ULL, 0x000fc600078e00ffULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x00000018ff5f7819ULL, 0x000fe4000001142cULL,
0x000001003c317824ULL, 0x060fe200078e00ffULL, 0x000054105d2c7816ULL, 0x004fe2000000005bULL,
0x000000ffff307224ULL, 0x000fe400078e006cULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x000054105c2d7816ULL, 0x002fe4000000005aULL,
0x00000018ff317819ULL, 0x000fc40000011431ULL, 0x00000018ff3c7819ULL, 0x000fc6000001143cULL,
0x0000001300647306ULL, 0x0003e80000200c00ULL, 0x0000002c202c723cULL, 0x000be80000001824ULL,
0x0000004f004f7306ULL, 0x000ea20000200c00ULL, 0x00000018ff137819ULL, 0x002fe20000011432ULL,
0x0001000032327824ULL, 0x000fe200078e00ffULL, 0x000088803e277816ULL, 0x020fc400000000ffULL,
0x00000018ff267819ULL, 0x000fe4000001143dULL, 0x00000018ff327819ULL, 0x000fe20000011432ULL,
0x0000004e004e7306ULL, 0x000e700000200c00ULL, 0x0000005300537306ULL, 0x000fe20000200c00ULL,
0x000054104f247816ULL, 0x004fce000000004dULL, 0x0000000300527306ULL, 0x0005e20000200c00ULL,
0x000054104e257816ULL, 0x002fce0000000051ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x00000024341c723cULL, 0x000b62000000181cULL, 0x00000018ff037819ULL, 0x004fcc000001143fULL,
0x0000000200597306ULL, 0x0003e20000200c00ULL, 0x000088803f257816ULL, 0x020fce00000000ffULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x00000018ff027819ULL, 0x002fce000001143eULL,
0x0000004800487306ULL, 0x000e700000200c00ULL, 0x0000004500457306ULL, 0x000eb00000200c00ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x0000541065657816ULL, 0x002fce0000000048ULL,
0x0000000800507306ULL, 0x000fe20000200c00ULL, 0x0000541045467816ULL, 0x004fce0000000046ULL,
0x0000001300137306ULL, 0x000ff00000200c00ULL, 0x0000004400447306ULL, 0x000ff00000200c00ULL,
0x00000032004a7306ULL, 0x000e700000200c00ULL, 0x0000003300497306ULL, 0x000eb00000200c00ULL,
0x0000003000087306ULL, 0x0007e20000200c00ULL, 0x000054104a487816ULL, 0x002fce0000000013ULL,
0x00000031004b7306ULL, 0x0003e20000200c00ULL, 0x0000541063307816ULL, 0x008fe40000000062ULL,
0x0000541049497816ULL, 0x004fca0000000044ULL, 0x0000001000107306ULL, 0x000ea20000200c00ULL,
0x0000541060317816ULL, 0x002fe40000000064ULL, 0x0000541066647816ULL, 0x000fe40000000047ULL,
0x000054104c477816ULL, 0x000fc60000000050ULL, 0x0000003c00607306ULL, 0x0003e20000200c00ULL,
0x000000302030723cULL, 0x000bee0000001828ULL, 0x0000541053287816ULL, 0x020fe20000000052ULL,
0x000001003e3c7824ULL, 0x002fe200078e00ffULL, 0x0000541058297816ULL, 0x000fe20000000059ULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000000643418723cULL, 0x000f620000001818ULL, 0x00000018ff247819ULL, 0x000fe2000001143cULL,
0x000001003f3c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00005410693d7816ULL, 0x004fc40000000010ULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x000000282028723cULL, 0x000bee0000001840ULL,
0x00000018ff407819ULL, 0x020fe2000001143cULL, 0x0000000900097306ULL, 0x000ea20000200c00ULL,
0x00000018ff417819ULL, 0x000fe2000001143fULL, 0x000000463414723cULL, 0x000f620000001814ULL,
0x000054106a3c7816ULL, 0x000fca000000000fULL, 0x0000000e000e7306ULL, 0x000fe40000200c00ULL,
0x000000483434723cULL, 0x000f6c0000001854ULL, 0x0000002600267306ULL, 0x000ee40000200c00ULL,
0x0000003c203c723cULL, 0x000b6c0000001838ULL, 0x0000002700277306ULL, 0x000fe20000200c00ULL,
0x0000541008387816ULL, 0x020fc4000000004bULL, 0x000054105e397816ULL, 0x002fca000000005fULL,
0x0000002400247306ULL, 0x000e640000200c00ULL, 0x000000382038723cULL, 0x000b6c000000181cULL,
0x0000002500257306ULL, 0x000fe20000200c00ULL, 0x00005410601c7816ULL, 0x024fe40000000009ULL,
0x00005410261d7816ULL, 0x008fca000000000eULL, 0x0000004000407306ULL, 0x000ea20000200c00ULL,
0x0000541027247816ULL, 0x002fe20000000024ULL, 0x0000001c201c723cULL, 0x000b6c0000001818ULL,
0x0000000200027306ULL, 0x000ff00000200c00ULL, 0x0000000300037306ULL, 0x000fe20000200c00ULL,
0x0000541025257816ULL, 0x004fce0000000040ULL, 0x0000001300137306ULL, 0x000e620000200c00ULL,
0x000000242018723cULL, 0x000b6e0000001814ULL, 0x0000004100107306ULL, 0x000ea20000200c00ULL,
0x0000541013027816ULL, 0x002fe40000000002ULL, 0x0000541010037816ULL, 0x004fce0000000003ULL,
0x000000022020723cULL, 0x000b620000001834ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x000000000a027f8cULL, 0x0202a2000c80043fULL, 0x000000010b0b7810ULL, 0x000fe40007ffe0ffULL,
0x000176a07a087811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000008ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff0e7224ULL, 0x004fe200078e0003ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff642000007947ULL, 0x000fea000383ffffULL,
0x000000ff7500720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000011007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000b1b000047802ULL, 0x002fc40000000f00ULL,
0x0000919000007944ULL, 0x00cfea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000001100007308ULL, 0x000f240000001000ULL, 0xbf80000000027423ULL, 0x014fc80000000011ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006b00ff037624ULL, 0x000fe400078e00ffULL,
0x00006a00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x000f28000c1e9900ULL,
0x0000000000047919ULL, 0x002e680000000000ULL, 0x0000000000077919ULL, 0x000ee20000000000ULL,
0x00000002ff067819ULL, 0x002fe40000011604ULL, 0x0000000807047811ULL, 0x008fe200078ff0ffULL,
0x0000000003057220ULL, 0x014fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000003000307220ULL, 0x042fe40000410000ULL,
0x0000003100317220ULL, 0x040fe40000410000ULL, 0x0000002c002c7220ULL, 0x040fe40000410000ULL,
0x0000002d002d7220ULL, 0x000fc40000410000ULL, 0x0000002800287220ULL, 0x040fe40000410000ULL,
0x0000002900297220ULL, 0x040fe40000410000ULL, 0x0000003c003c7220ULL, 0x040fe40000410000ULL,
0x0000003d003d7220ULL, 0x040fe40000410000ULL, 0x0000003800387220ULL, 0x040fe40000410000ULL,
0x0000003900397220ULL, 0x000fc40000410000ULL, 0x0000001c001c7220ULL, 0x040fe40000410000ULL,
0x0000001d001d7220ULL, 0x040fe40000410000ULL, 0x0000001800187220ULL, 0x040fe40000410000ULL,
0x0000001900197220ULL, 0x040fe40000410000ULL, 0x0000002000207220ULL, 0x040fe40000410000ULL,
0x0000002100217220ULL, 0x000fc40000410000ULL, 0x0000003204327220ULL, 0x044fe40000410000ULL,
0x0000003304337220ULL, 0x040fe40000410000ULL, 0x0000002e042e7220ULL, 0x040fe40000410000ULL,
0x0000002f042f7220ULL, 0x040fe40000410000ULL, 0x0000002a042a7220ULL, 0x040fe40000410000ULL,
0x0000002b042b7220ULL, 0x000fc40000410000ULL, 0x0000003e043e7220ULL, 0x040fe40000410000ULL,
0x0000003f043f7220ULL, 0x040fe40000410000ULL, 0x0000003a043a7220ULL, 0x040fe40000410000ULL,
0x0000003b043b7220ULL, 0x040fe40000410000ULL, 0x0000001e041e7220ULL, 0x040fe40000410000ULL,
0x0000001f041f7220ULL, 0x000fc40000410000ULL, 0x0000001a041a7220ULL, 0x040fe40000410000ULL,
0x0000001b041b7220ULL, 0x040fe40000410000ULL, 0x0000002204227220ULL, 0x040fe40000410000ULL,
0x0000002304237220ULL, 0x000fc40000410000ULL, 0x0000000000007919ULL, 0x000f220000000000ULL,
0x0000001c1d1c723eULL, 0x000fe200000000ffULL, 0x000000206e0b7824ULL, 0x000fe200078e00ffULL,
0x000000181918723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000002a2b2a723eULL, 0x000fc400000000ffULL, 0x0000003e3f15723eULL, 0x000fe400000000ffULL,
0x0000003a3b3a723eULL, 0x000fe400000000ffULL, 0x0000001e1f1d723eULL, 0x000fe400000000ffULL,
0x0000001a1b1a723eULL, 0x000fe400000000ffULL, 0x00000022230d723eULL, 0x000fe400000000ffULL,
0x000054102a147816ULL, 0x000fc40000000015ULL, 0x00000002ff057819ULL, 0x012fe40000011600ULL,
0x0000000200027812ULL, 0x044fe400078ec0ffULL, 0x0000000800077811ULL, 0x000fe200078ff0ffULL,
0x0000000805097824ULL, 0x040fe200078e00ffULL, 0x0000000502047211ULL, 0x040fe200078ff8ffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x000fe200078ff8ffULL,
0x00000008070e7824ULL, 0x000fe200078e00ffULL, 0x0000000204027810ULL, 0x040fe20007ffe0ffULL,
0x0000000805077824ULL, 0x000fe200078e00ffULL, 0x0000000404067810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL, 0x0000100074037824ULL, 0x000fe200078e00ffULL,
0xfffffff809087812ULL, 0x008fe400078ee202ULL, 0xfffffff807027812ULL, 0x000fe200078ee204ULL,
0x000008006e057824ULL, 0x000fe200078e0203ULL, 0x0000000604077810ULL, 0x000fe20007ffe0ffULL,
0x0000000800047824ULL, 0x000fe200078e00ffULL, 0xfffffff8090a7812ULL, 0x000fe200078ee206ULL,
0x0000001002067824ULL, 0x000fe200078e0205ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x0000001008087824ULL, 0x100fe200078e0205ULL, 0x0000000804077812ULL, 0x000fe200078ec0ffULL,
0x000000100e0e7824ULL, 0x100fe200078e0205ULL, 0x000000303102723eULL, 0x000fe200000000ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0205ULL, 0x0000002c2d04723eULL, 0x000fe200000000ffULL,
0x0000000106067824ULL, 0x000fe200078e0207ULL, 0x000076322a157816ULL, 0x000fe20000000015ULL,
0x0000000107087824ULL, 0x040fe200078e0208ULL, 0x0000541002107816ULL, 0x100fe20000000004ULL,
0x000000100c0c7824ULL, 0x000fe200078e0205ULL, 0x0000763202117816ULL, 0x000fe20000000004ULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x000000282902723eULL, 0x000fe200000000ffULL,
0x00000001070a7824ULL, 0x000fe200078e020aULL, 0x0000003c3d04723eULL, 0x000fe200000000ffULL,
0x0000001006007388ULL, 0x0003e20000000a00ULL, 0x000000383905723eULL, 0x000fe200000000ffULL,
0x0000000107077824ULL, 0x000fe200078e020cULL, 0x00000020210c723eULL, 0x000fc400000000ffULL,
0x000000ff6e00720cULL, 0x000fe40003f05270ULL, 0x0000541002107816ULL, 0x142fe40000000004ULL,
0x0000763202117816ULL, 0x000fe40000000004ULL, 0x000000323302723eULL, 0x000fe400000000ffULL,
0x0000002e2f04723eULL, 0x000fe200000000ffULL, 0x0000001008007388ULL, 0x0003e40000000a00ULL,
0x0000541005107816ULL, 0x002fc4000000001cULL, 0x0000763205117816ULL, 0x000fe4000000001cULL,
0x000054103a1c7816ULL, 0x140fe4000000001dULL, 0x000076323a1d7816ULL, 0x000fe2000000001dULL,
0x000000100a007388ULL, 0x0003e20000000a00ULL, 0x000076321a057816ULL, 0x000fe4000000000dULL,
0x0000541018107816ULL, 0x142fe4000000000cULL, 0x0000763218117816ULL, 0x000fca000000000cULL,
0x0000001007007388ULL, 0x0003e40000000a00ULL, 0x0000541002107816ULL, 0x142fe40000000004ULL,
0x0000763202117816ULL, 0x000fe20000000004ULL, 0x000000010b027824ULL, 0x000fe200078e0200ULL,
0x000054101a047816ULL, 0x000fc6000000000dULL, 0x000000100e007388ULL, 0x000fe20000000a00ULL,
0x0000001002027824ULL, 0x000fc600078e0203ULL, 0x0004001408007388ULL, 0x000fe80000000a00ULL,
0x0004001c0a007388ULL, 0x000fe80000000a00ULL, 0x0004000407007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000020c7984ULL, 0x000e680000000c00ULL,
0x0004000002147984ULL, 0x000ea80000000c00ULL, 0x0008000002107984ULL, 0x000ee80000000c00ULL,
0x000c000002187984ULL, 0x000f220000000c00ULL, 0x200000ff0f0f7230ULL, 0x002fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x004fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x000000130f0f7230ULL, 0x008fe40000000000ULL,
0x000000120e0e7230ULL, 0x000fe40000000000ULL, 0x000000110d0d7230ULL, 0x000fe40000000000ULL,
0x000000100c0c7230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x010fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000c02007388ULL, 0x000fe20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001402007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff067819ULL, 0x000fc80000011600ULL,
0x0000007d0600720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000011f7983ULL, 0x000ea20000100800ULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0x0000000106027824ULL, 0x000fe200078e0200ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x00005900ff1e7624ULL, 0x000fe200078e00ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x00005a007c117a19ULL, 0x000fe200000006ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x0000000702057812ULL, 0x000fe400078ec0ffULL, 0x0000580000067ab9ULL, 0x000fe20000000800ULL,
0x00005a001e1e7a19ULL, 0x000fc400000006ffULL, 0x0ffffff805027812ULL, 0x000fe400078ef800ULL,
0x0000000700077812ULL, 0x000fc600078ec0ffULL, 0x0000001002047824ULL, 0x000fe400078e0203ULL,
0x0000000874077824ULL, 0x000fc600078e0207ULL, 0x0000000004087984ULL, 0x0007220000000c00ULL,
0x00000006040472a4ULL, 0x002fe2000f8e023fULL, 0x000000101f027824ULL, 0x004fca00078e0206ULL,
0x0000000502067c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff057a19ULL, 0x000fe20000011602ULL,
0x000000041e027c24ULL, 0x000fe4000f8e02ffULL, 0x0000000111067824ULL, 0x000fc800078e0206ULL,
0x0000001e05057224ULL, 0x000fe200078e0206ULL, 0x0000002000067810ULL, 0x000fc80007ffe0ffULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x008fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440cULL,
0x00000003ff0c7819ULL, 0x000fc60000011606ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000007d0c00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0103f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x142fe200078e020cULL,
0x00000007060d7812ULL, 0x000fe200078ec0ffULL, 0x000000101f0c7824ULL, 0x000fc600078e020cULL,
0x0000000704057812ULL, 0x000fe200078ec0ffULL, 0x00000008740d7824ULL, 0x000fc600078e020dULL,
0x0ffffff805047812ULL, 0x000fca00078ef806ULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x000000050c047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0c7a19ULL, 0x000fe4000001160cULL,
0x0000000007087984ULL, 0x000e620000000c00ULL, 0x0000000111057824ULL, 0x000fc800078e0204ULL,
0x0000001e0c057224ULL, 0x000fe200078e0205ULL, 0x00000040000c7810ULL, 0x000fc80007ffe0ffULL,
0x0000000502057210ULL, 0x000fe40007f1e0ffULL, 0x00000003ff067819ULL, 0x000fc6000001160cULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x0000007d0600720cULL, 0x000fc60003f06070ULL,
0x000000100d047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c047824ULL, 0x102fe200078e0206ULL,
0x0000006000007810ULL, 0x000fe20007ffe0ffULL, 0x000000101f067824ULL, 0x000fe200078e0206ULL,
0x000000070c0d7812ULL, 0x000fe400078ec0ffULL, 0x0000000704057812ULL, 0x000fc600078ec0ffULL,
0x00000008740d7824ULL, 0x000fe200078e020dULL, 0x0ffffff805047812ULL, 0x000fca00078ef80cULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x0000000506047c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff067a19ULL, 0x000fe40000011606ULL, 0x0000000007087984ULL, 0x0002a20000000c00ULL,
0x0000000111057824ULL, 0x000fc800078e0204ULL, 0x0000001e06057224ULL, 0x000fe200078e0205ULL,
0x00000003ff067819ULL, 0x000fc80000011600ULL, 0x0000000502057210ULL, 0x000fe20007f1e0ffULL,
0x0000000100077824ULL, 0x002fc800078e0206ULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fe400078040ffULL, 0x0000000707077812ULL, 0x000fe400078ec0ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x0000007d0600720cULL, 0x000fe40003f06070ULL,
0xfffffff8070c7812ULL, 0x000fe200078ef800ULL, 0x000000100d047825ULL, 0x000fca00078e0004ULL,
0x0000000804007986ULL, 0x0043ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000100c0c7824ULL, 0x000fe200078e0203ULL, 0x0000000700057812ULL, 0x002fe200078ec0ffULL,
0x000000101f067824ULL, 0x000fc800078e0206ULL, 0x000000000c0c7984ULL, 0x000e620000000c00ULL,
0x0000000506037c12ULL, 0x000fe2000f8e30ffULL, 0x0000000874057824ULL, 0x000fe200078e0205ULL,
0x00005a00ff067a19ULL, 0x000fc60000011606ULL, 0x0000000111037824ULL, 0x000fc800078e0203ULL,
0x0000001e06037224ULL, 0x000fca00078e0203ULL, 0x0000000302037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fca00000f4404ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000c02007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006a00ff047624ULL, 0x000fe400078e00ffULL, 0x00006b00ff057624ULL, 0x000fca00078e00ffULL,
0x0000000804037981ULL, 0x000322000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0600780cULL, 0x000fe20003f04070ULL, 0x000000020a637824ULL, 0x000fe200078e00ffULL,
0x01760000ff047f8cULL, 0x002e62000c80043fULL, 0x00000040006c7824ULL, 0x000fe400078e00ffULL,
0x0000590063637a24ULL, 0x000fc800078e027cULL, 0x0000660063067a24ULL, 0x000fc800078e026cULL,
0x00000c7000000947ULL, 0x000fea0003800000ULL, 0x00000003ff1b7819ULL, 0x000fe4000001160dULL,
0x0000006c61077217ULL, 0x000fe40007800000ULL, 0x000000041b0b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000106087824ULL, 0x040fe200078e021bULL, 0x000000081b117810ULL, 0x000fe20007ffe0ffULL,
0x00000001070c7824ULL, 0x000fe200078e0a6cULL, 0x0000000c1b177810ULL, 0x040fe20007ffe0ffULL,
0x00000001060a7824ULL, 0x000fe200078e020bULL, 0x000000101b0f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000111097824ULL, 0x100fe200078e020dULL, 0x0000000c0b00720cULL, 0x080fe20003fa6070ULL,
0x0000000811207824ULL, 0x000fe200078e00ffULL, 0x000000141b1f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b077824ULL, 0x000fe200078e020dULL, 0x000000181b237810ULL, 0x000fe20007ffe0ffULL,
0x000000080b1a7824ULL, 0x000fe200078e00ffULL, 0xfffffff820207812ULL, 0x000fe200078ee209ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000000c1700720cULL, 0x000fc40003f46070ULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee207ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000700a147812ULL, 0x100fe400078ef802ULL, 0x0000001c1b277810ULL, 0x000fe20007ffe0ffULL,
0x000000080f137824ULL, 0x040fe200078e00ffULL, 0x0000007008127812ULL, 0x000fe200078ef802ULL,
0x000000010f087824ULL, 0x000fe200078e020dULL, 0x0000620014147a10ULL, 0x000fe20007f3e0ffULL,
0x00000001060a7824ULL, 0x000fe200078e0217ULL, 0x0000620012127a10ULL, 0x000fe20007f1e0ffULL,
0x0000000106107824ULL, 0x000fe200078e021fULL, 0x000063000b157a10ULL, 0x000fe20000ffe4ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff813247812ULL, 0x000fc400078ee208ULL,
0x0000000c1100720cULL, 0x080fe20003f26070ULL, 0x0000000106087824ULL, 0x040fe200078e0211ULL,
0x0000630009137a10ULL, 0x000fe200007fe4ffULL, 0x00000001061c7824ULL, 0x000fe200078e0223ULL,
0x000000700a187812ULL, 0x100fe200078ef802ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000c0f00720cULL, 0x000fe40003f06070ULL, 0x0000620018187a10ULL, 0x000fe20007f9e0ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x00000070100a7812ULL, 0x000fc400078ef802ULL,
0x000063000b197a10ULL, 0x000fe200027fe4ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000007008167812ULL, 0x100fe400078ef802ULL, 0x000062000a0a7a10ULL, 0x000fe20007f9e0ffULL,
0x0000000117077824ULL, 0x100fe200078e020dULL, 0x000000701c087812ULL, 0x000fe200078ef802ULL,
0x000000011b1c7824ULL, 0x000fe200078e020dULL, 0x00006300110b7a10ULL, 0x000fe200027fe4ffULL,
0x0000000817227824ULL, 0x000fe200078e00ffULL, 0x0000000c1b00720cULL, 0x000fe20003f86070ULL,
0x00000001060f7824ULL, 0x000fe200078e020fULL, 0x000000071c1e7812ULL, 0x000fe200078ec0ffULL,
0x0000000106107824ULL, 0x000fe200078e0227ULL, 0xfffffff822227812ULL, 0x000fe200078ee207ULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0x0000100000077811ULL, 0x000fc400078e70ffULL,
0x0ffffff81e1e7812ULL, 0x100fe200078ef80dULL, 0x0000000123257824ULL, 0x040fe200078e020dULL,
0x0000620016167a10ULL, 0x000fe20007f7e0ffULL, 0x0000000823287824ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fe200078ef802ULL, 0x000000101e217824ULL, 0x000fe200078e0207ULL,
0x0000630009177a10ULL, 0x000fe20001ffe4ffULL, 0x000000011f1c7824ULL, 0x000fe200078e020dULL,
0x000062000e0e7a10ULL, 0x000fe20007f7e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000281b2d7810ULL, 0x000fe20007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012217faeULL, 0x0005e2000e101c48ULL, 0x0000620008087a10ULL, 0x000fc40007fde0ffULL,
0x000000201b297810ULL, 0x000fe40007ffe0ffULL, 0x000063000f0f7a10ULL, 0x000fe40001ffe4ffULL,
0x0000000c2300720cULL, 0x080fe20003f86070ULL, 0x0000000106237824ULL, 0x040fe200078e022dULL,
0x0000000c1f00720cULL, 0x040fe20003f66070ULL, 0x000000081f1f7824ULL, 0x000fe200078e00ffULL,
0x000063001d097a10ULL, 0x000fe200037fe4ffULL, 0x00000001061d7824ULL, 0x000fe200078e0229ULL,
0x000000241b2b7810ULL, 0x000fe20007ffe0ffULL, 0x000000101a217824ULL, 0x004fe200078e0207ULL,
0xfffffff81f267812ULL, 0x000fe200078ee21cULL, 0x0000008023127825ULL, 0x000fe200078e00ffULL,
0x0000007010107812ULL, 0x000fc400078ef802ULL, 0x0000000014217faeULL, 0x0005e2000e901c48ULL,
0x0000001020237824ULL, 0x000fe200078e0207ULL, 0x0000620010107a10ULL, 0x000fe20007fde0ffULL,
0x000000801d1c7825ULL, 0x000fe200078e00ffULL, 0x0000002c1b2f7810ULL, 0x000fe40007ffe0ffULL,
0x0000000016237faeULL, 0x0007e2000c901c48ULL, 0x00000001061e7824ULL, 0x000fe200078e022bULL,
0x0000000c2900720cULL, 0x040fe20003f26070ULL, 0x0000000129207824ULL, 0x000fe200078e020dULL,
0x000000701c1c7812ULL, 0x000fe200078ef802ULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000630011117a10ULL, 0x000fc400037fe4ffULL, 0x000062001c1c7a10ULL, 0x000fe20007fde0ffULL,
0x0000000829297824ULL, 0x000fe200078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee225ULL,
0x0000001022217824ULL, 0x004fe200078e0207ULL, 0x000000701e1e7812ULL, 0x000fe200078ef802ULL,
0x00000001271a7824ULL, 0x040fe200078e020dULL, 0x0000000c2700720cULL, 0x080fe20003fa6070ULL,
0x0000001024177824ULL, 0x008fe200078e0207ULL, 0xfffffff829207812ULL, 0x000fe200078ee220ULL,
0x0000000827277824ULL, 0x000fe200078e00ffULL, 0x000000301b297810ULL, 0x000fe20007ffe0ffULL,
0x0000000106147824ULL, 0x000fe200078e022fULL, 0x0000000018217faeULL, 0x0005e2000d101c48ULL,
0x000063001d1d7a10ULL, 0x000fe200037fe4ffULL, 0x000000012b227824ULL, 0x040fe200078e020dULL,
0x000062001e1e7a10ULL, 0x000fe20007fde0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000c2b00720cULL, 0x0c0fe20003f46070ULL, 0x000000000e177faeULL, 0x0007e2000c101c48ULL,
0x0000007012127812ULL, 0x000fe200078ef802ULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff8271a7812ULL, 0x000fe200078ee21aULL, 0x0000001020257824ULL, 0x100fe200078e0207ULL,
0x000063001f1f7a10ULL, 0x000fe200037fe4ffULL, 0x0000001026197824ULL, 0x104fe200078e0207ULL,
0x0000620012127a10ULL, 0x000fe20007fde0ffULL, 0x0000001028217824ULL, 0x100fe200078e0207ULL,
0x0000007014147812ULL, 0x000fe200078ef802ULL, 0x000000101a237824ULL, 0x000fe200078e0207ULL,
0x000000000a197faeULL, 0x0005e2000d901c48ULL, 0x00000001060e7824ULL, 0x008fe200078e0229ULL,
0xfffffff82b227812ULL, 0x000fe200078ee222ULL, 0x000000012d0f7824ULL, 0x000fe200078e020dULL,
0x0000000008217faeULL, 0x0007e2000e101c48ULL, 0x000000341b177810ULL, 0x000fe20007ffe0ffULL,
0x0000000829187824ULL, 0x000fe200078e00ffULL, 0x0000630013137a10ULL, 0x000fe200037fe4ffULL,
0x0000001022277824ULL, 0x000fe200078e0207ULL, 0x0000620014147a10ULL, 0x000fe20007fde0ffULL,
0x0000000010237faeULL, 0x0003e2000e901c48ULL, 0x000000381b2b7810ULL, 0x040fe20007ffe0ffULL,
0x00000001060a7824ULL, 0x004fe200078e0217ULL, 0x0000003c1b1b7810ULL, 0x000fe20007ffe0ffULL,
0x000000001c257faeULL, 0x0005e2000c901c48ULL, 0x0000630015157a10ULL, 0x000fe200037fe4ffULL,
0x000000800e087825ULL, 0x008fe200078e00ffULL, 0x0000000c2d00720cULL, 0x080fe20003fa6070ULL,
0x000000001e277faeULL, 0x0007e2000d101c48ULL, 0x0000000c2f00720cULL, 0x000fe20003f86070ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x00000070080e7812ULL, 0x000fc400078ef802ULL,
0x0000000c2900720cULL, 0x080fe20003f66070ULL, 0x000000082d107824ULL, 0x002fe200078e00ffULL,
0x000062000e0e7a10ULL, 0x000fe20007fde0ffULL, 0x000000012f087824ULL, 0x100fe200078e020dULL,
0x0000000c1700720cULL, 0x080fe20003f46070ULL, 0x000000082f2f7824ULL, 0x000fe200078e00ffULL,
0x0000000c2b00720cULL, 0x080fe20003f26070ULL, 0x0000000117197824ULL, 0x000fe200078e020dULL,
0x0000000c1b00720cULL, 0x000fe20003f06070ULL, 0x00000008171a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8100c7812ULL, 0x000fe200078ee20fULL, 0x000000081b1e7824ULL, 0x008fe200078e00ffULL,
0x00006300090f7a10ULL, 0x000fe200037fe4ffULL, 0x0000000129097824ULL, 0x000fe200078e020dULL,
0x000000700a107812ULL, 0x000fe200078ef802ULL, 0x00000001060a7824ULL, 0x000fe200078e022bULL,
0xfffffff82f167812ULL, 0x000fc400078ee208ULL, 0xfffffff818187812ULL, 0x000fe200078ee209ULL,
0x000000800a087825ULL, 0x000fe200078e00ffULL, 0x0000620010107a10ULL, 0x000fe40007fde0ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee219ULL, 0x00000001060a7824ULL, 0x000fe200078e021bULL,
0x000063000b117a10ULL, 0x000fe200037fe4ffULL, 0x000000012b067824ULL, 0x000fe200078e020dULL,
0x0000007008087812ULL, 0x000fe200078ef802ULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0x0000620008087a10ULL, 0x000fe20007fde0ffULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0x000000700a027812ULL, 0x000fe200078ef802ULL, 0x000000011b0d7824ULL, 0x000fe200078e020dULL,
0x0000630009097a10ULL, 0x000fe200037fe4ffULL, 0x0000001016177824ULL, 0x100fe200078e0207ULL,
0xfffffff82b1c7812ULL, 0x004fe200078ee206ULL, 0x0000001018197824ULL, 0x000fe200078e0207ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20dULL, 0x000000100c0d7824ULL, 0x100fe200078e0207ULL,
0x0000620002067a10ULL, 0x000fe20007fde0ffULL, 0x000000101a1b7824ULL, 0x000fc400078e0207ULL,
0x000000101c1d7824ULL, 0x100fe200078e0207ULL, 0x00000000120d7faeULL, 0x0003e2000e901c48ULL,
0x000000101e1f7824ULL, 0x000fe200078e0207ULL, 0x000063000b077a10ULL, 0x000fe400037fe4ffULL,
0x0000000014177faeULL, 0x0003e8000e101c48ULL, 0x000000000e197faeULL, 0x0003e8000d901c48ULL,
0x00000000101b7faeULL, 0x0003e8000d101c48ULL, 0x00000000081d7faeULL, 0x0003e8000c901c48ULL,
0x00000000061f7faeULL, 0x0003e2000c101c48ULL, 0x00000b3000007947ULL, 0x000fea0003800000ULL,
0x000000040d097811ULL, 0x040fe400078fe8ffULL, 0x000000080d0a7811ULL, 0x000fc400078fe8ffULL,
0x0000000c0d0b7811ULL, 0x000fe200078fe8ffULL, 0x0000000109077824ULL, 0x100fe200078e020dULL,
0x0000001c0d137811ULL, 0x000fe200078fe8ffULL, 0x00000008090e7824ULL, 0x000fe200078e00ffULL,
0x000000140d0f7811ULL, 0x040fe200078fe8ffULL, 0x000000010a087824ULL, 0x040fe200078e020dULL,
0x000000180d117811ULL, 0x000fe200078fe8ffULL, 0x000000080a197824ULL, 0x000fe200078e00ffULL,
0xfffffff80e177812ULL, 0x000fe200078ee207ULL, 0x000000010b0c7824ULL, 0x100fe200078e020dULL,
0x000000100d0e7811ULL, 0x000fe200078fe8ffULL, 0x000000080b1b7824ULL, 0x000fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fe200078ee208ULL, 0x0000000113107824ULL, 0x100fe200078e020dULL,
0x000000280d167811ULL, 0x000fe200078fe8ffULL, 0x0000000813157824ULL, 0x000fe200078e00ffULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee20cULL, 0x000000010f087824ULL, 0x100fe200078e020dULL,
0x0000002c0d187811ULL, 0x000fe200078fe8ffULL, 0x000000080f1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8151c7812ULL, 0x000fe200078ee210ULL, 0x00000001110c7824ULL, 0x100fe200078e020dULL,
0x000000240d157811ULL, 0x000fe200078fe8ffULL, 0x0000000811217824ULL, 0x000fe200078e00ffULL,
0x000000200d147811ULL, 0x000fe200078fe8ffULL, 0x000000010e077824ULL, 0x140fe200078e020dULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee208ULL, 0x000000080e127824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee20cULL, 0x0000000115087824ULL, 0x000fe200078e020dULL,
0x000000340d297811ULL, 0x000fe200078fe8ffULL, 0x0000000815237824ULL, 0x000fe200078e00ffULL,
0xfffffff8121d7812ULL, 0x000fe200078ee207ULL, 0x00000001160c7824ULL, 0x140fe200078e020dULL,
0x000000380d2b7811ULL, 0x000fe200078fe8ffULL, 0x0000000816257824ULL, 0x000fe200078e00ffULL,
0xfffffff823207812ULL, 0x000fe200078ee208ULL, 0x0000000118107824ULL, 0x140fe200078e020dULL,
0x0000000d0d087211ULL, 0x000fe200078fe8ffULL, 0x0000000818277824ULL, 0x000fe200078e00ffULL,
0xfffffff825237812ULL, 0x000fe200078ee20cULL, 0x0000000114077824ULL, 0x040fe200078e020dULL,
0x0000003c0d2c7811ULL, 0x000fe200078fe8ffULL, 0x00000008141e7824ULL, 0x000fe200078e00ffULL,
0xfffffff827257812ULL, 0x000fe200078ee210ULL, 0x00000001060c7824ULL, 0x040fe200078e020bULL,
0x000000300d277811ULL, 0x040fe200078fe8ffULL, 0x0000000106247824ULL, 0x000fe200078e0214ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee207ULL, 0x0000000106287824ULL, 0x040fe200078e0216ULL,
0x000000060d077211ULL, 0x000fe200078fe8ffULL, 0x00000001062a7824ULL, 0x000fe200078e0218ULL,
0x0000000708087812ULL, 0x000fe200078ec0ffULL, 0x0000000106097824ULL, 0x000fc400078e0209ULL,
0x00000001060a7824ULL, 0x040fe400078e020aULL, 0x00000001060e7824ULL, 0x040fe400078e020eULL,
0x0000000106107824ULL, 0x040fe400078e020fULL, 0x0000000106127824ULL, 0x040fe400078e0211ULL,
0x0000000106227824ULL, 0x040fe400078e0213ULL, 0x0000000106267824ULL, 0x000fe200078e0215ULL,
0x0ffffff808157812ULL, 0x000fe200078ef80dULL, 0x00000001061a7824ULL, 0x000fc400078e0227ULL,
0x00000001270b7824ULL, 0x040fe400078e020dULL, 0x00000008272e7824ULL, 0x000fe400078e00ffULL,
0x0000000106187824ULL, 0x040fe400078e0229ULL, 0x0000000106167824ULL, 0x040fe400078e022bULL,
0x0000000106147824ULL, 0x000fe400078e022cULL, 0x0000008007067825ULL, 0x000fc800078e00ffULL,
0x00000001290f7824ULL, 0x100fe200078e020dULL, 0x0000007006067812ULL, 0x000fe200078ef802ULL,
0x000000012b117824ULL, 0x140fe400078e020dULL, 0x000000012c087824ULL, 0x000fe200078e020dULL,
0xfffffff82e0d7812ULL, 0x000fe200078ee20bULL, 0x000000082c137824ULL, 0x000fe200078e00ffULL,
0x00001000002c7811ULL, 0x000fe200078e70ffULL, 0x000000082b327824ULL, 0x000fe200078e00ffULL,
0x0000620006067a10ULL, 0x000fe20007f1e0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fc400078ee208ULL, 0xfffffff832117812ULL, 0x000fe200078ee211ULL,
0x0000000829307824ULL, 0x000fe200078e00ffULL, 0x000000700a0a7812ULL, 0x000fe200078ef802ULL,
0x000000100d3b7824ULL, 0x000fe200078e022cULL, 0x0000630007077a10ULL, 0x000fe200007fe4ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffff8300f7812ULL, 0x000fe400078ee20fULL,
0x000062000a0a7a10ULL, 0x000fe20007f1e0ffULL, 0x0000008009087825ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x000fc400078ef802ULL, 0x000063000b0b7a10ULL, 0x000fe200007fe4ffULL,
0x00000010113f7824ULL, 0x000fe200078e022cULL, 0x0000007008087812ULL, 0x000fe200078ef802ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000062000c0c7a10ULL, 0x000fe40007f1e0ffULL,
0x0000620008087a10ULL, 0x000fe20007f3e0ffULL, 0x000000100f3d7824ULL, 0x000fe200078e022cULL,
0x0000007010107812ULL, 0x000fe200078ef802ULL, 0x0000001023377824ULL, 0x000fe200078e022cULL,
0x000063000d0d7a10ULL, 0x000fe200007fe4ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000620010107a10ULL, 0x000fc40007f1e0ffULL, 0x0000630009097a10ULL, 0x000fe20000ffe4ffULL,
0x0000001013417824ULL, 0x000fe200078e022cULL, 0x000000700e0e7812ULL, 0x000fe200078ef802ULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000630011117a10ULL, 0x000fe400007fe4ffULL,
0x000062000e0e7a10ULL, 0x000fe20007f3e0ffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0x000063000f0f7a10ULL, 0x000fe20000ffe4ffULL, 0x0000001025397824ULL, 0x000fe200078e022cULL,
0x0000007012127812ULL, 0x000fe200078ef802ULL, 0x0000001015157824ULL, 0x100fe400078e022cULL,
0x0000001017177824ULL, 0x100fe200078e022cULL, 0x0000620012127a10ULL, 0x000fe20007f5e0ffULL,
0x0000001019197824ULL, 0x100fe200078e022cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006157faeULL, 0x0005e2000b901c48ULL, 0x000000101b1b7824ULL, 0x100fe200078e022cULL,
0x0000630013137a10ULL, 0x000fe200017fe4ffULL, 0x000000101d1d7824ULL, 0x100fe200078e022cULL,
0x0000000008177faeULL, 0x0005e2000b901c48ULL, 0x000000101f1f7824ULL, 0x000fc400078e022cULL,
0x0000001021217824ULL, 0x100fe200078e022cULL, 0x000000000a197faeULL, 0x0005e2000b901c48ULL,
0x000000101c1c7824ULL, 0x100fe400078e022cULL, 0x000000101e1e7824ULL, 0x100fe200078e022cULL,
0x000000000c1b7faeULL, 0x0005e2000b901c48ULL, 0x0000001020357824ULL, 0x000fe200078e022cULL,
0x00000070222c7812ULL, 0x100fe200078ef802ULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x000000000e1d7faeULL, 0x0005e4000b901c48ULL, 0x000062002c2c7a10ULL, 0x000fe20007f1e0ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x00000070242e7812ULL, 0x100fe200078ef802ULL,
0x00000000101f7faeULL, 0x0005e2000b901c48ULL, 0x00006300232d7a10ULL, 0x000fe200007fe4ffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x0000007026307812ULL, 0x100fe200078ef802ULL,
0x0000000012217faeULL, 0x0005e2000b901c48ULL, 0x000062002e2e7a10ULL, 0x000fe20007f3e0ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000007028327812ULL, 0x000fe200078ef802ULL,
0x000000002c1c7faeULL, 0x0005e2000b901c48ULL, 0x0000620030307a10ULL, 0x000fe20007f1e0ffULL,
0x000000801a227825ULL, 0x000fe200078e00ffULL, 0x0000620032327a10ULL, 0x000fc40007f5e0ffULL,
0x00006300252f7a10ULL, 0x000fe20000ffe4ffULL, 0x0000008018247825ULL, 0x000fe200078e00ffULL,
0x000000702a2a7812ULL, 0x100fe400078ef802ULL, 0x0000630027317a10ULL, 0x000fe200007fe4ffULL,
0x0000008016267825ULL, 0x000fe200078e00ffULL, 0x0000630029337a10ULL, 0x000fe200017fe4ffULL,
0x000000002e1e7faeULL, 0x0005e2000b901c48ULL, 0x000062002a2a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000008014287825ULL, 0x000fe200078e00ffULL, 0x0000007022227812ULL, 0x100fe200078ef802ULL,
0x0000000030357faeULL, 0x0005e2000b901c48ULL, 0x0000007024247812ULL, 0x000fc400078ef802ULL,
0x0000007026267812ULL, 0x100fe200078ef802ULL, 0x0000000032377faeULL, 0x0005e2000b901c48ULL,
0x000063002b2b7a10ULL, 0x000fe400007fe4ffULL, 0x0000007028027812ULL, 0x000fe400078ef802ULL,
0x0000620022227a10ULL, 0x000fe20007f1e0ffULL, 0x000000002a397faeULL, 0x0005e2000b901c48ULL,
0x0000620024247a10ULL, 0x000fe40007f3e0ffULL, 0x0000620026267a10ULL, 0x000fc40007f5e0ffULL,
0x0000620002287a10ULL, 0x000fe40007f7e0ffULL, 0x0000630023237a10ULL, 0x000fe400007fe4ffULL,
0x0000630025257a10ULL, 0x000fe40000ffe4ffULL, 0x0000630027277a10ULL, 0x000fe200017fe4ffULL,
0x00000000223b7faeULL, 0x0005e2000b901c48ULL, 0x0000630029297a10ULL, 0x000fc60001ffe4ffULL,
0x00000000243d7faeULL, 0x0005e8000b901c48ULL, 0x00000000263f7faeULL, 0x0005e8000b901c48ULL,
0x0000000028417faeULL, 0x0005e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x006fc40000015200ULL, 0x01760400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008060b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011409ULL, 0x0000000b02027211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000202027819ULL, 0x000fc80000001209ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000002000027824ULL, 0x002fca00078e0205ULL, 0x00000003ff047819ULL, 0x000fc80000011602ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x0000000f02047812ULL, 0x000fc600078ec0ffULL,
0x0000000102057824ULL, 0x000fe400078e0205ULL, 0x0000001004077824ULL, 0x040fe400078e00ffULL,
0x0000001004047824ULL, 0x000fe200078e00ffULL, 0x0000000f05027812ULL, 0x040fe400078ec0ffULL,
0x0000000105057810ULL, 0x000fe40007ffe0ffULL, 0x000000f007027812ULL, 0x000fe400078ee202ULL,
0x0000000f05057812ULL, 0x000fc600078ec0ffULL, 0x00000000020c7984ULL, 0x000e62000000cc00ULL,
0x000000f004057812ULL, 0x000fca00078ee205ULL, 0x0000000005087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fe400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fc400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001002007388ULL, 0x0003e8000000cc00ULL, 0x0000000c05007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01760000ff087f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x002fc80000015200ULL,
0x01760400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011407ULL, 0x0000000b02027211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000202027819ULL, 0x000fc80000001207ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff7500720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0000001fff057424ULL, 0x000fe200078e00ffULL, 0x80005800616b7a10ULL, 0x000fe20007ffe0ffULL,
0x00000001ff6d7424ULL, 0x000fe200078e00ffULL, 0x000001006c6c7810ULL, 0x000fe20007ffe0ffULL,
0x00005800ff5f7624ULL, 0x000fe200078e00ffULL, 0x0000580005057a10ULL, 0x000fe20007ffe0ffULL,
0x3db504f303037820ULL, 0x010fe20000410000ULL, 0x0001768800717811ULL, 0x040fe200078e18ffULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x00000004ff057819ULL, 0x000fe20000011605ULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x0001760800777811ULL, 0x000fc400078e28ffULL,
0x000058006d6d7a10ULL, 0x000fe40007ffe1ffULL, 0x000000095f5f7810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff6b7819ULL, 0x000fe4000001166bULL, 0x0ffffffe05607812ULL, 0x000fc400078ec0ffULL,
0x0000000204067810ULL, 0x040fe20007ffe0ffULL, 0x0000010004057824ULL, 0x000fe200078e026cULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000010d5e7812ULL, 0x000fe400078e0cffULL,
0x000000750600720cULL, 0x000fe20003f06070ULL, 0x0000660063097a24ULL, 0x000fd800078e0205ULL,
0x00000ca000008947ULL, 0x00cfea0003800000ULL, 0x00000003ff197819ULL, 0x002fe20000011602ULL,
0x0000001002087824ULL, 0x000fe200078e00ffULL, 0x00000005610c7217ULL, 0x000fe20007800000ULL,
0x0000000200187824ULL, 0x000fe200078e025eULL, 0x00000008190f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001191c7824ULL, 0x140fe200078e0202ULL, 0x0000000419077810ULL, 0x040fe20007ffe0ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0a05ULL, 0x0000000c19117810ULL, 0x000fe20007ffe0ffULL,
0x000000010f0b7824ULL, 0x040fe200078e0202ULL, 0x0000007008087812ULL, 0x000fe200078ec0ffULL,
0x000000080f0e7824ULL, 0x000fe200078e00ffULL, 0x0000001019137810ULL, 0x000fe20007ffe0ffULL,
0x00000001070a7824ULL, 0x040fe200078e0209ULL, 0x0000000c0700720cULL, 0x000fe20003fa6070ULL,
0x0000000811297824ULL, 0x000fe200078e00ffULL, 0xfffffff80e277812ULL, 0x000fe200078ee20bULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x00000014191f7810ULL, 0x000fc40007ffe0ffULL,
0x00000018192d7810ULL, 0x000fe20007ffe0ffULL, 0x00000001110e7824ULL, 0x100fe200078e0202ULL,
0x000000080a0a7212ULL, 0x000fe200078efcffULL, 0x0000000107067824ULL, 0x100fe200078e0202ULL,
0x0000000c1100720cULL, 0x080fe20003f46070ULL, 0x0000000807257824ULL, 0x000fe200078e00ffULL,
0x000062000a0a7a10ULL, 0x000fe20007f3e0ffULL, 0x0000000113217824ULL, 0x000fe200078e0202ULL,
0xfffffff829297812ULL, 0x000fe200078ee20eULL, 0x0000000813107824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee206ULL, 0x000000010f0e7824ULL, 0x100fe200078e0209ULL,
0x000063000b0b7a10ULL, 0x000fe20000ffe4ffULL, 0x0000000119067824ULL, 0x000fe200078e0209ULL,
0xfffffff810217812ULL, 0x000fe200078ee221ULL, 0x0000000111107824ULL, 0x000fe200078e0209ULL,
0x0000000c0f00720cULL, 0x000fe20003f26070ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001c192f7810ULL, 0x000fc40007ffe0ffULL, 0x000000071c1d7812ULL, 0x000fe200078ec0ffULL,
0x0000000113147824ULL, 0x000fe200078e0209ULL, 0x000000080e0e7212ULL, 0x080fe200078efcffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000002019317810ULL, 0x000fe40007ffe0ffULL,
0x000062000e0e7a10ULL, 0x000fe20007f7e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000806067212ULL, 0x080fe400078efcffULL, 0x000063000f0f7a10ULL, 0x000fe20001ffe4ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000000810127212ULL, 0x000fc400078efcffULL,
0x0000620006067a10ULL, 0x000fe20007f1e0ffULL, 0x000000011f167824ULL, 0x100fe200078e0209ULL,
0x0000000814107212ULL, 0x080fe200078efcffULL, 0x000000012d1a7824ULL, 0x000fe200078e0209ULL,
0x0000620012127a10ULL, 0x000fe20007f9e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000620010107a10ULL, 0x000fe40007f7e0ffULL, 0x0000630007077a10ULL, 0x000fe200007fe4ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000000816147212ULL, 0x000fc400078efcffULL,
0x0000000c1300720cULL, 0x000fe20003f06070ULL, 0x000000011f1e7824ULL, 0x100fe200078e0202ULL,
0x000000081a167212ULL, 0x000fe200078efcffULL, 0x000000012f1a7824ULL, 0x100fe200078e0209ULL,
0x0000630011137a10ULL, 0x000fe200027fe4ffULL, 0x000000081f2b7824ULL, 0x000fe200078e00ffULL,
0x0000630015117a10ULL, 0x000fe20001ffe4ffULL, 0x00000001311c7824ULL, 0x000fe200078e0209ULL,
0x0000620014147a10ULL, 0x000fe20007f7e0ffULL, 0x000000012d227824ULL, 0x000fe200078e0202ULL,
0x0000620016167a10ULL, 0x000fc40007f9e0ffULL, 0x0000630017157a10ULL, 0x000fe40001ffe4ffULL,
0x000063001b177a10ULL, 0x000fe200027fe4ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000c1900720cULL, 0x000fe40003f86070ULL, 0x0000100018187811ULL, 0x000fe400078e68ffULL,
0x0ffffff81d1d7812ULL, 0x000fe400078ef802ULL, 0x0000002419337810ULL, 0x000fe20007ffe0ffULL,
0x0000001021217824ULL, 0x100fe200078e0218ULL, 0x000000081a1a7212ULL, 0x000fe200078efcffULL,
0x000000101d237824ULL, 0x000fe200078e0218ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee21eULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000002819357810ULL, 0x000fc40007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006237faeULL, 0x0003e2000e101c48ULL,
0x00000001331e7824ULL, 0x100fe200078e0209ULL, 0x0000000c1f00720cULL, 0x000fe20003f66070ULL,
0x0000000135207824ULL, 0x000fe200078e0209ULL, 0x000062001a1a7a10ULL, 0x000fe20007fde0ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000000081c1c7212ULL, 0x080fe400078efcffULL,
0x0000002c19377810ULL, 0x000fe40007ffe0ffULL, 0x000063001b1b7a10ULL, 0x000fe200037fe4ffULL,
0x0000001025237824ULL, 0x102fe200078e0218ULL, 0x000062001c1c7a10ULL, 0x000fe20007fde0ffULL,
0x0000001027257824ULL, 0x000fe200078e0218ULL, 0x000000081e1e7212ULL, 0x000fe200078efcffULL,
0x0000008020067825ULL, 0x000fe200078e00ffULL, 0x000000000a237faeULL, 0x0003e2000e901c48ULL,
0x0000000c2d00720cULL, 0x000fc40003f86070ULL, 0x000000082d2d7824ULL, 0x000fe200078e00ffULL,
0x000063001d1d7a10ULL, 0x000fe200037fe4ffULL, 0x000000012f207824ULL, 0x040fe200078e0202ULL,
0x0000000c2f00720cULL, 0x040fe20003fa6070ULL, 0x000000000e257faeULL, 0x0005e2000c901c48ULL,
0x000062001e1e7a10ULL, 0x000fe20007fde0ffULL, 0x000000082f2f7824ULL, 0x000fe200078e00ffULL,
0x0000000806067212ULL, 0x000fe200078efcffULL, 0x0000000833277824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee222ULL, 0x0000001029237824ULL, 0x002fe200078e0218ULL,
0x0000003019297810ULL, 0x000fe20007ffe0ffULL, 0x00000001370a7824ULL, 0x000fe200078e0209ULL,
0x000063001f1f7a10ULL, 0x000fe200037fe4ffULL, 0x0000000133227824ULL, 0x000fe200078e0202ULL,
0x0000000012237faeULL, 0x0003e2000d101c48ULL, 0x000000102b0f7824ULL, 0x004fe200078e0218ULL,
0x0000620006067a10ULL, 0x000fe20007fde0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000000010217faeULL, 0x0005e2000c101c48ULL, 0xfffffff82f2f7812ULL, 0x000fc400078ee220ULL,
0x00000001290e7824ULL, 0x100fe200078e0209ULL, 0x00000000140f7faeULL, 0x0007e2000d901c48ULL,
0x0000000c3100720cULL, 0x040fe20003f26070ULL, 0x0000000131207824ULL, 0x040fe200078e0202ULL,
0x000000080a0a7212ULL, 0x000fe200078efcffULL, 0x0000000831317824ULL, 0x000fe200078e00ffULL,
0x0000630007077a10ULL, 0x000fe200037fe4ffULL, 0x000000102d137824ULL, 0x102fe200078e0218ULL,
0x0000000c3300720cULL, 0x000fe20003f46070ULL, 0x000000102f237824ULL, 0x000fe200078e0218ULL,
0x0000003419217810ULL, 0x004fe20007ffe0ffULL, 0x0000000135127824ULL, 0x000fe200078e0202ULL,
0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL, 0x000000800e0e7825ULL, 0x008fe200078e00ffULL,
0xfffffff831257812ULL, 0x000fe200078ee220ULL, 0x0000000016137faeULL, 0x0003e2000e101c48ULL,
0xfffffff827277812ULL, 0x000fe200078ee222ULL, 0x0000000121107824ULL, 0x100fe200078e0209ULL,
0x000000080e0e7212ULL, 0x080fe200078efcffULL, 0x0000001025257824ULL, 0x100fe200078e0218ULL,
0x000063000b0b7a10ULL, 0x000fe200037fe4ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000062000e0e7a10ULL, 0x000fe20007fde0ffULL, 0x000000001a237faeULL, 0x0005e2000e901c48ULL,
0x00000038192b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001027277824ULL, 0x000fe200078e0218ULL,
0x0000000810147212ULL, 0x000fe200078efcffULL, 0x0000000835177824ULL, 0x002fe200078e00ffULL,
0x000063000f0f7a10ULL, 0x000fe200037fe4ffULL, 0x000000012b107824ULL, 0x100fe200078e0209ULL,
0x0000003c192d7810ULL, 0x000fe20007ffe0ffULL, 0x000000001c257faeULL, 0x0003e2000c901c48ULL,
0xfffffff817177812ULL, 0x000fe200078ee212ULL, 0x0000000129127824ULL, 0x140fe200078e0202ULL,
0x0000620014147a10ULL, 0x000fe20007fde0ffULL, 0x00000008291b7824ULL, 0x004fe200078e00ffULL,
0x000000001e277faeULL, 0x0005e2000d101c48ULL, 0x0000000c3500720cULL, 0x080fe20003fa6070ULL,
0x0000000837197824ULL, 0x040fe200078e00ffULL, 0x0000000c3700720cULL, 0x080fe20003f86070ULL,
0x000000082b1a7824ULL, 0x000fe200078e00ffULL, 0x0000000c2900720cULL, 0x080fe20003f66070ULL,
0x000000012d167824ULL, 0x000fe200078e0202ULL, 0x0000000c2100720cULL, 0x0c0fe20003f46070ULL,
0x00000008211d7824ULL, 0x002fe200078e00ffULL, 0x0000000c2b00720cULL, 0x080fe20003f26070ULL,
0x0000001017177824ULL, 0x000fe200078e0218ULL, 0x0000000c2d00720cULL, 0x000fe20003f06070ULL,
0x00000001370c7824ULL, 0x000fe200078e0202ULL, 0x0000630011157a10ULL, 0x000fe200037fe4ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee212ULL,
0x0000000006177faeULL, 0x0003e2000e901c48ULL, 0xfffffff819197812ULL, 0x000fe200078ee20cULL,
0x000000012d127824ULL, 0x000fe200078e0209ULL, 0x0000000810107212ULL, 0x000fe200078efcffULL,
0x00000001210c7824ULL, 0x000fc400078e0202ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000620010107a10ULL, 0x000fe40007fde0ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee20cULL,
0x000000012b097824ULL, 0x000fe200078e0202ULL, 0x0000000812087212ULL, 0x000fe200078efcffULL,
0x000000082d217824ULL, 0x000fe200078e00ffULL, 0x0000630011117a10ULL, 0x000fe200037fe4ffULL,
0x0000001019197824ULL, 0x100fe200078e0218ULL, 0xfffffff81a097812ULL, 0x000fe200078ee209ULL,
0x000000101b1b7824ULL, 0x000fe200078e0218ULL, 0xfffffff821217812ULL, 0x000fe200078ee216ULL,
0x000000101d1d7824ULL, 0x100fe200078e0218ULL, 0x0000620008087a10ULL, 0x000fe20007fde0ffULL,
0x00000010091f7824ULL, 0x104fe200078e0218ULL, 0x000000000a197faeULL, 0x0003e2000e101c48ULL,
0x0000001021217824ULL, 0x000fe200078e0218ULL, 0x0000630013097a10ULL, 0x000fc400037fe4ffULL,
0x000000000e1b7faeULL, 0x0003e8000d901c48ULL, 0x00000000141d7faeULL, 0x0003e8000d101c48ULL,
0x00000000101f7faeULL, 0x0003e8000c901c48ULL, 0x0000000008217faeULL, 0x0003e2000c101c48ULL,
0x00000b6000007947ULL, 0x000fea0003800000ULL, 0x00000008020a7811ULL, 0x042fe200078fe8ffULL,
0x00000010023b7824ULL, 0x040fe200078e00ffULL, 0x0000001402127811ULL, 0x000fc400078fe8ffULL,
0x0000000402087811ULL, 0x000fe200078fe8ffULL, 0x000000010a077824ULL, 0x100fe200078e0202ULL,
0x0000001002107811ULL, 0x000fe200078fe8ffULL, 0x000000080a0c7824ULL, 0x000fe200078e00ffULL,
0x0000000c020e7811ULL, 0x000fe200078fe8ffULL, 0x00000001120b7824ULL, 0x100fe200078e0202ULL,
0x0000001802147811ULL, 0x000fe200078fe8ffULL, 0x0000000812187824ULL, 0x000fe200078e00ffULL,
0xfffffff80c357812ULL, 0x000fe200078ee207ULL, 0x0000000108067824ULL, 0x100fe200078e0202ULL,
0x00000024021a7811ULL, 0x000fe200078fe8ffULL, 0x0000000808377824ULL, 0x000fe200078e00ffULL,
0xfffffff8182f7812ULL, 0x000fe200078ee20bULL, 0x0000000110077824ULL, 0x000fe200078e0202ULL,
0x0000002002187811ULL, 0x000fe200078fe8ffULL, 0x0000000810167824ULL, 0x000fe200078e00ffULL,
0xfffffff837377812ULL, 0x000fe200078ee206ULL, 0x000000010e067824ULL, 0x100fe200078e0202ULL,
0x00000028021c7811ULL, 0x000fe200078fe8ffULL, 0x000000080e337824ULL, 0x000fe200078e00ffULL,
0xfffffff816317812ULL, 0x000fe200078ee207ULL, 0x0000000118077824ULL, 0x000fe200078e0202ULL,
0x0000001c02167811ULL, 0x000fe200078fe8ffULL, 0x00000008181e7824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee206ULL, 0x00000001140c7824ULL, 0x100fe200078e0202ULL,
0x00000030022a7811ULL, 0x000fe200078fe8ffULL, 0x00000008142d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e297812ULL, 0x000fe200078ee207ULL, 0x000000011a0b7824ULL, 0x100fe200078e0202ULL,
0x0000002c021e7811ULL, 0x000fe200078fe8ffULL, 0x000000081a207824ULL, 0x000fe200078e00ffULL,
0x0000003402287811ULL, 0x000fe200078fe8ffULL, 0x0000000116067824ULL, 0x040fe200078e0202ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee20cULL, 0x00000008162b7824ULL, 0x000fe200078e00ffULL,
0xfffffff820277812ULL, 0x000fe200078ee20bULL, 0x000000011c0c7824ULL, 0x000fe200078e0202ULL,
0x0000003802267811ULL, 0x000fe200078fe8ffULL, 0x000000081c257824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee206ULL, 0x000000012a077824ULL, 0x040fe200078e0202ULL,
0x000000703b3b7812ULL, 0x000fe200078ec0ffULL, 0x000000082a207824ULL, 0x000fe200078e00ffULL,
0xfffffff825257812ULL, 0x000fe200078ee20cULL, 0x000000011e067824ULL, 0x000fc400078e0202ULL,
0x000000081e237824ULL, 0x000fe200078e00ffULL, 0xfffffff8200f7812ULL, 0x000fe200078ee207ULL,
0x00000001280b7824ULL, 0x000fe200078e0202ULL, 0x0000003c02077811ULL, 0x000fe200078fe8ffULL,
0x0000000828227824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee206ULL,
0x00000001260c7824ULL, 0x000fe200078e0202ULL, 0x0000000902067211ULL, 0x000fe200078fe8ffULL,
0x0000000826117824ULL, 0x000fe200078e00ffULL, 0xfffffff822217812ULL, 0x000fe200078ee20bULL,
0x0000000108087824ULL, 0x100fe200078e0209ULL, 0x00000002020b7211ULL, 0x000fe200078fe8ffULL,
0x000000010a0a7824ULL, 0x100fe200078e0209ULL, 0xfffffff811117812ULL, 0x000fe200078ee20cULL,
0x000000010e0e7824ULL, 0x100fe200078e0209ULL, 0x000000070b0b7812ULL, 0x000fe200078ec0ffULL,
0x0000000110107824ULL, 0x000fc400078e0209ULL, 0x0000000112127824ULL, 0x100fe200078e0209ULL,
0x0ffffff80b397812ULL, 0x000fe200078ef802ULL, 0x0000000114147824ULL, 0x100fe400078e0209ULL,
0x0000000116167824ULL, 0x100fe400078e0209ULL, 0x0000000118187824ULL, 0x100fe400078e0209ULL,
0x000000011a1a7824ULL, 0x100fe400078e0209ULL, 0x000000011c1c7824ULL, 0x000fc400078e0209ULL,
0x000000011e1e7824ULL, 0x100fe400078e0209ULL, 0x000000012a2a7824ULL, 0x100fe400078e0209ULL,
0x0000000128287824ULL, 0x100fe400078e0209ULL, 0x0000000126267824ULL, 0x100fe400078e0209ULL,
0x0000000107247824ULL, 0x000fe400078e0209ULL, 0x00000002000c7824ULL, 0x000fc400078e025eULL,
0x0000000107097824ULL, 0x040fe400078e0202ULL, 0x0000000807207824ULL, 0x000fe200078e00ffULL,
0x000010000c0c7811ULL, 0x000fe200078e68ffULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffff820137812ULL, 0x000fe200078ee209ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000003b06067212ULL, 0x000fc600078efcffULL, 0x000000100f227824ULL, 0x100fe200078e020cULL,
0x0000620006067a10ULL, 0x000fe20007f1e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000003b0a0a7212ULL, 0x080fe400078efcffULL, 0x0000630007077a10ULL, 0x000fe200007fe4ffULL,
0x0000001039397824ULL, 0x100fe200078e020cULL, 0x000062000a0a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000001037377824ULL, 0x100fe200078e020cULL, 0x0000003b0e0e7212ULL, 0x000fe200078efcffULL,
0x0000001035357824ULL, 0x100fe200078e020cULL, 0x000063000b0b7a10ULL, 0x000fe200007fe4ffULL,
0x0000001033337824ULL, 0x100fe200078e020cULL, 0x000062000e0e7a10ULL, 0x000fe20007f1e0ffULL,
0x0000001031317824ULL, 0x100fe200078e020cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006397faeULL, 0x0003e2000b901c48ULL, 0x000000102f2f7824ULL, 0x100fe200078e020cULL,
0x000063000f0f7a10ULL, 0x000fe200007fe4ffULL, 0x000000102d2d7824ULL, 0x000fc400078e020cULL,
0x000000102b2b7824ULL, 0x100fe400078e020cULL, 0x0000001029297824ULL, 0x100fe400078e020cULL,
0x0000001027277824ULL, 0x100fe400078e020cULL, 0x0000001025257824ULL, 0x100fe400078e020cULL,
0x0000001023237824ULL, 0x100fe400078e020cULL, 0x0000001021217824ULL, 0x000fc400078e020cULL,
0x0000001011207824ULL, 0x100fe400078e020cULL, 0x00000010130c7824ULL, 0x000fe400078e020cULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000003b12127212ULL, 0x000fc600078efcffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000620012127a10ULL, 0x000fe40007f1e0ffULL, 0x0000003b16167212ULL, 0x080fe200078efcffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000003b08087212ULL, 0x080fe400078efcffULL,
0x0000630013137a10ULL, 0x000fe200007fe4ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000620016167a10ULL, 0x000fe40007f1e0ffULL, 0x0000620008087a10ULL, 0x000fe20007f3e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000003b1a1a7212ULL, 0x000fc400078efcffULL,
0x0000003b10107212ULL, 0x080fe200078efcffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000003b14147212ULL, 0x080fe400078efcffULL, 0x0000630017177a10ULL, 0x000fe200007fe4ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000630009097a10ULL, 0x000fe40000ffe4ffULL,
0x000062001a1a7a10ULL, 0x000fe20007f1e0ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000620010107a10ULL, 0x000fe20007f3e0ffULL, 0x0000000008377faeULL, 0x0003e2000b901c48ULL,
0x0000003b1e1e7212ULL, 0x080fe200078efcffULL, 0x000000802a3c7825ULL, 0x000fe200078e00ffULL,
0x0000620014147a10ULL, 0x000fe20007f5e0ffULL, 0x000000000a357faeULL, 0x0003e2000b901c48ULL,
0x0000003b18187212ULL, 0x080fe200078efcffULL, 0x00000080283e7825ULL, 0x000fe200078e00ffULL,
0x0000003b1c1c7212ULL, 0x000fe200078efcffULL, 0x000000000e337faeULL, 0x0003e2000b901c48ULL,
0x000063001b1b7a10ULL, 0x000fe200007fe4ffULL, 0x0000008026407825ULL, 0x000fe200078e00ffULL,
0x0000630011117a10ULL, 0x000fc40000ffe4ffULL, 0x000062001e1e7a10ULL, 0x000fe20007f1e0ffULL,
0x0000008024427825ULL, 0x000fe200078e00ffULL, 0x0000630015157a10ULL, 0x000fe200017fe4ffULL,
0x0000000010317faeULL, 0x0003e2000b901c48ULL, 0x0000620018187a10ULL, 0x000fe40007f3e0ffULL,
0x0000003b3c3a7212ULL, 0x080fe200078efcffULL, 0x00000000122f7faeULL, 0x0003e2000b901c48ULL,
0x000062001c1c7a10ULL, 0x000fe40007f5e0ffULL, 0x0000003b3e3c7212ULL, 0x080fe200078efcffULL,
0x00000000142d7faeULL, 0x0003e2000b901c48ULL, 0x0000003b403e7212ULL, 0x000fc400078efcffULL,
0x000063001f1f7a10ULL, 0x000fe200007fe4ffULL, 0x00000000162b7faeULL, 0x0003e2000b901c48ULL,
0x0000003b423b7212ULL, 0x000fe400078efcffULL, 0x0000630019197a10ULL, 0x000fe40000ffe4ffULL,
0x000062003a3a7a10ULL, 0x000fe40007f1e0ffULL, 0x000063001d1d7a10ULL, 0x000fe200017fe4ffULL,
0x0000000018297faeULL, 0x0003e2000b901c48ULL, 0x000062003c3c7a10ULL, 0x000fc40007f3e0ffULL,
0x000062003e3e7a10ULL, 0x000fe20007f5e0ffULL, 0x000000001a277faeULL, 0x0003e2000b901c48ULL,
0x000062003b407a10ULL, 0x000fe40007f7e0ffULL, 0x000063003d3b7a10ULL, 0x000fe200007fe4ffULL,
0x000000001c257faeULL, 0x0003e2000b901c48ULL, 0x000063003f3d7a10ULL, 0x000fe40000ffe4ffULL,
0x00006300413f7a10ULL, 0x000fe200017fe4ffULL, 0x000000001e237faeULL, 0x0003e2000b901c48ULL,
0x0000630043417a10ULL, 0x000fc60001ffe4ffULL, 0x000000003a227faeULL, 0x0003e8000b901c48ULL,
0x000000003c217faeULL, 0x0003e8000b901c48ULL, 0x000000003e207faeULL, 0x0003e8000b901c48ULL,
0x00000000400c7faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x00000020020b7810ULL, 0x002fe20007ffe0ffULL, 0x0000000200077824ULL, 0x000fe200078e020dULL,
0x00000007020d7812ULL, 0x040fe200078ec0ffULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0xfffffff802097812ULL, 0x000fe200078ec0ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0xfffffff80b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000004ff677819ULL, 0x000fe20000011602ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000100007077811ULL, 0x000fe400078e68ffULL, 0x000000080d087812ULL, 0x100fe400078ef802ULL,
0x0000000709097812ULL, 0x100fe400078ef802ULL, 0x000000070b067812ULL, 0x000fc600078ef802ULL,
0x00000001090b7824ULL, 0x040fe200078e020aULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000008090c7824ULL, 0x060fe400078e00ffULL, 0x0000000809197824ULL, 0x000fc400078e00ffULL,
0x000000020a727824ULL, 0x000fe200078e0267ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee20bULL,
0x00000001060b7824ULL, 0x000fc800078e020aULL, 0x000000100c107824ULL, 0x000fe400078e0207ULL,
0x00000008060c7824ULL, 0x000fc800078e00ffULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0xfffffff80c0c7812ULL, 0x000fca00078ee20bULL, 0x000000100c0c7824ULL, 0x000fcc00078e0207ULL,
0x000000000c0c783bULL, 0x000ea20000000200ULL, 0x00000018ff4c7819ULL, 0x002fe20000011410ULL,
0x00010000100b7824ULL, 0x040fe200078e00ffULL, 0x0000888010737816ULL, 0x040fe200000000ffULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe20000011411ULL,
0x0001000011187824ULL, 0x040fe200078e00ffULL, 0x00008880116e7816ULL, 0x040fe200000000ffULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff0b7819ULL, 0x000fc4000001140bULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff667819ULL, 0x000fe40000011412ULL,
0x0000888012687816ULL, 0x000fe200000000ffULL, 0x0000001000747306ULL, 0x0002e20000200c00ULL,
0x00000018ff557819ULL, 0x004fe4000001140cULL, 0x000088800c547816ULL, 0x000fe400000000ffULL,
0x00000018ff5b7819ULL, 0x000fc40000011413ULL, 0x0000888013507816ULL, 0x040fe200000000ffULL,
0x0000000b00767306ULL, 0x0005e20000200c00ULL, 0x0001000013107824ULL, 0x042fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe4000001140eULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000011006f7306ULL, 0x0003e20000200c00ULL, 0x00010000120b7824ULL, 0x044fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0000010012127824ULL, 0x000fe200078e00ffULL,
0x000088800e527816ULL, 0x000fc400000000ffULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x0000001000657306ULL, 0x0005e20000200c00ULL, 0x000000010a117810ULL, 0x002fe40007ffe0ffULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x00000018ff4f7819ULL, 0x000fe4000001140fULL,
0x000088800f4d7816ULL, 0x000fe200000000ffULL, 0x0000001200697306ULL, 0x0003e20000200c00ULL,
0x0000000109107824ULL, 0x004fe200078e0211ULL, 0x00000018ff577819ULL, 0x000fe2000001140dULL,
0x0000000106117824ULL, 0x000fe200078e0211ULL, 0x000088800d597816ULL, 0x000fc400000000ffULL,
0x000000020a0a7810ULL, 0x000fe40007ffe0ffULL, 0x0000000b006a7306ULL, 0x0005e20000200c00ULL,
0xfffffff819127812ULL, 0x002fe200078ee210ULL, 0x000100000d107824ULL, 0x040fe200078e00ffULL,
0x000000080a00780cULL, 0x000fe20003f05270ULL, 0x000001000d0d7824ULL, 0x000fe400078e00ffULL,
0x0000001012127824ULL, 0x000fe200078e0207ULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000001300647306ULL, 0x000fe20000200c00ULL, 0x000100000c0b7824ULL, 0x044fe200078e00ffULL,
0x00000018ff0d7819ULL, 0x000fe2000001140dULL, 0x00000000121c783bULL, 0x000e620000000200ULL,
0x000001000c0c7824ULL, 0x000fc400078e00ffULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x00000010005a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff0c7819ULL, 0x000fce000001140cULL,
0x0000000c005c7306ULL, 0x0005f00000200c00ULL, 0x0000001800707306ULL, 0x0009e20000200c00ULL,
0x00000008060c7824ULL, 0x004fca00078e00ffULL, 0xfffffff80c0c7812ULL, 0x000fe400078ee211ULL,
0x0000007300737306ULL, 0x000ea60000200c00ULL, 0x000000100c187824ULL, 0x010fe400078e0207ULL,
0x000100000f0c7824ULL, 0x040fe400078e00ffULL, 0x000001000f0f7824ULL, 0x000fe200078e00ffULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x000000001818783bULL, 0x000f220000000200ULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x000100001c107824ULL, 0x002fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001141cULL, 0x000100001d117824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fc4000001141dULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000000c00497306ULL, 0x0003e20000200c00ULL, 0x00000018ff437819ULL, 0x000fe20000011411ULL,
0x0000001008117824ULL, 0x000fe200078e00ffULL, 0x000088801d427816ULL, 0x040fe200000000ffULL,
0x000001001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001141eULL,
0x000088801e457816ULL, 0x000fe200000000ffULL, 0x0000001000417306ULL, 0x0005e20000200c00ULL,
0x000088801c0c7816ULL, 0x042fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x00000018ff3c7819ULL, 0x000fe4000001141fULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000001d00447306ULL, 0x0003e20000200c00ULL,
0x0000000108107824ULL, 0x144fe200078e0272ULL, 0x000088801f477816ULL, 0x000fe400000000ffULL,
0x0000000208727810ULL, 0x000fe40007ffe072ULL, 0xfffffff011107812ULL, 0x000fe400078ee210ULL,
0x0000001c00407306ULL, 0x0005e20000200c00ULL, 0x000100001f1d7824ULL, 0x002fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001140fULL, 0x0000001010107824ULL, 0x000fc400078e00ffULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0x000100001e1c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x000001001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x010fe40000011418ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000001d004b7306ULL, 0x0007e20000200c00ULL,
0x00000018ff1e7819ULL, 0x000fce000001141eULL, 0x0000001c00467306ULL, 0x0005e20000200c00ULL,
0x00005410741d7816ULL, 0x008fce000000004cULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x00005410731c7816ULL, 0x004fce0000000076ULL, 0x0000006800687306ULL, 0x000eb00000200c00ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x0000001c1038723cULL, 0x002b6e0000001838ULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x000054106e1c7816ULL, 0x020fe20000000070ULL,
0x00010000186e7824ULL, 0x000fe200078e00ffULL, 0x000054106f1d7816ULL, 0x000fe2000000004aULL,
0x00000010086f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe2000001146eULL,
0x0000001e00487306ULL, 0x0007e20000200c00ULL, 0xfffffff06f727812ULL, 0x000fe200078ee272ULL,
0x0000001c1034723cULL, 0x000bec0000001834ULL, 0x0000000b005d7306ULL, 0x0009e20000200c00ULL,
0x00005410681c7816ULL, 0x024fc4000000006aULL, 0x00005410691d7816ULL, 0x000fe40000000066ULL,
0x00008880181e7816ULL, 0x008fc600000000ffULL, 0x0000001f004c7306ULL, 0x0005e20000200c00ULL,
0x000100000e0b7824ULL, 0x050fe200078e00ffULL, 0x0000001c1030723cULL, 0x000b620000001830ULL,
0x000001000e0e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x0000001e004a7306ULL, 0x0007e20000200c00ULL, 0x00005410501c7816ULL, 0x022fe20000000065ULL,
0x00000100181f7824ULL, 0x004fe200078e00ffULL, 0x00005410641d7816ULL, 0x000fe2000000005bULL,
0x0001000019647824ULL, 0x040fe200078e00ffULL, 0x00000018ff0e7819ULL, 0x000fe4000001140eULL,
0x00000018ff667819ULL, 0x000fe2000001141fULL, 0x0000005500557306ULL, 0x000e620000200c00ULL,
0x00000010721e7824ULL, 0x008fe200078e00ffULL, 0x0000001c102c723cULL, 0x000b62000000182cULL,
0x0000888019657816ULL, 0x000fc400000000ffULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x000000001e1c783bULL, 0x020ea20000000200ULL, 0x0000005400547306ULL, 0x000ee20000200c00ULL,
0x000000ffff5b7224ULL, 0x000fce00078e0065ULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x000054105c557816ULL, 0x002fe20000000055ULL, 0x00000100195c7824ULL, 0x000fcc00078e00ffULL,
0x0000000b00537306ULL, 0x0003220000200c00ULL, 0x0000541054547816ULL, 0x008fce000000005dULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000000541028723cULL, 0x000b620000001828ULL,
0x00000018ff0b7819ULL, 0x002fcc000001141bULL, 0x0000000e00567306ULL, 0x0002e20000200c00ULL,
0x0000541052527816ULL, 0x010fce0000000053ULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x00000018ff0e7819ULL, 0x002fce0000011419ULL, 0x0000005900597306ULL, 0x000e620000200c00ULL,
0x0000541056537816ULL, 0x008fce0000000051ULL, 0x0000000d00587306ULL, 0x0007220000200c00ULL,
0x000000521020723cULL, 0x000bee0000001820ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x0000541059547816ULL, 0x022fe4000000005aULL, 0x00000018ff0d7819ULL, 0x008fca000001141aULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x0000541058557816ULL, 0x010fce0000000057ULL,
0x0000004e004e7306ULL, 0x000ee20000200c00ULL, 0x000000541024723cULL, 0x000b6e0000001824ULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x000054104d527816ULL, 0x002fe40000000049ULL,
0x000088801a557816ULL, 0x020fc400000000ffULL, 0x00000018ff547819ULL, 0x000fc6000001145cULL,
0x0000000c000c7306ULL, 0x000e620000200c00ULL, 0x000054104e537816ULL, 0x008fe2000000004fULL,
0x000000ffff517224ULL, 0x000fe400078e0055ULL, 0x000100001a557824ULL, 0x040fe400078e00ffULL,
0x000001001a1a7824ULL, 0x000fe400078e00ffULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x000000521014723cULL, 0x000b640000001814ULL, 0x00000018ff1a7819ULL, 0x000fca000001141aULL,
0x0000004500457306ULL, 0x000ee20000200c00ULL, 0x000054100c107816ULL, 0x022fe20000000041ULL,
0x000100001b137824ULL, 0x040fe200078e00ffULL, 0x0000541040117816ULL, 0x000fe4000000003fULL,
0x000088801b0c7816ULL, 0x040fe200000000ffULL, 0x000001001b1b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff127819ULL, 0x000fe20000011455ULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x000000101c38723cULL, 0x004b620000001838ULL,
0x00000018ff1b7819ULL, 0x000fca000001141bULL, 0x0000004300437306ULL, 0x000e620000200c00ULL,
0x0000541045107816ULL, 0x028fe40000000046ULL, 0x0000541048117816ULL, 0x000fca000000003dULL,
0x0000003e003e7306ULL, 0x000ea40000200c00ULL, 0x000000101c30723cULL, 0x000b6c0000001830ULL,
0x0000003c003c7306ULL, 0x000ee20000200c00ULL, 0x0000541042427816ULL, 0x002fce0000000043ULL,
0x0000004700477306ULL, 0x000e620000200c00ULL, 0x0000541044437816ULL, 0x004fe4000000003eULL,
0x000054104c117816ULL, 0x028fca000000003cULL, 0x0000000f000f7306ULL, 0x000fe20000200c00ULL,
0x000000421c34723cULL, 0x000f620000001834ULL, 0x0000541047107816ULL, 0x002fcc000000004bULL,
0x0000000e000e7306ULL, 0x000fe20000200c00ULL, 0x000000101c2c723cULL, 0x000b6e000000182cULL,
0x0000000d000d7306ULL, 0x000ff00000200c00ULL, 0x0000000b000b7306ULL, 0x000ff00000200c00ULL,
0x0000006e00187306ULL, 0x000e700000200c00ULL, 0x0000006600507306ULL, 0x000eb00000200c00ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x000054104a4a7816ULL, 0x002fce0000000018ULL,
0x0000006400197306ULL, 0x000e620000200c00ULL, 0x00005410504b7816ULL, 0x004fce000000000fULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x0000004a1c28723cULL, 0x000b6e0000001828ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000054105b107816ULL, 0x022fce0000000019ULL,
0x0000001200127306ULL, 0x000e620000200c00ULL, 0x0000541054117816ULL, 0x004fce000000000eULL,
0x0000001a001a7306ULL, 0x000ea20000200c00ULL, 0x000000101c24723cULL, 0x000b6e0000001824ULL,
0x0000000c003e7306ULL, 0x0003f00000200c00ULL, 0x0000001300137306ULL, 0x000ee20000200c00ULL,
0x00005410510c7816ULL, 0x002fc40000000012ULL, 0x000054101a0d7816ULL, 0x004fca000000000dULL,
0x0000001b003c7306ULL, 0x000e640000200c00ULL, 0x0000000c1c20723cULL, 0x000b620000001820ULL,
0x000054103e3e7816ULL, 0x008fe40000000013ULL, 0x000054103c3f7816ULL, 0x002fce000000000bULL,
0x0000003e1c14723cULL, 0x000b620000001814ULL, 0xfffff0a000000947ULL, 0x000fce000383ffffULL,
0x0000000000007918ULL, 0x000fc80000000000ULL, 0x0000000331317220ULL, 0x080fe40000410000ULL,
0x000000032c2c7220ULL, 0x080fe40000410000ULL, 0x0000000328287220ULL, 0x080fe40000410000ULL,
0x0000000338387220ULL, 0x080fe40000410000ULL, 0x0000000339397220ULL, 0x080fe40000410000ULL,
0x0000000329297220ULL, 0x000fc40000410000ULL, 0x0000000314147220ULL, 0x0a0fe40000410000ULL,
0x000000032a0b7220ULL, 0x080fe40000410000ULL, 0x0000000333087220ULL, 0x080fe40000410000ULL,
0x000000032e097220ULL, 0x080fe40000410000ULL, 0x000000032b137220ULL, 0x000fe40000410000ULL,
0x000000ffff2a7224ULL, 0x000fc400078e0031ULL, 0x00000003301b7220ULL, 0x080fe40000410000ULL,
0x000000032d337220ULL, 0x080fe40000410000ULL, 0x000000032f0a7220ULL, 0x080fe40000410000ULL,
0x00000003212e7220ULL, 0x080fe40000410000ULL, 0x00000003230e7220ULL, 0x000fe40000410000ULL,
0x000000ffff2b7224ULL, 0x000fc400078e002cULL, 0x000000ffff317224ULL, 0x000fe400078e0028ULL,
0x000000033a3a7220ULL, 0x080fe40000410000ULL, 0x000000033b3b7220ULL, 0x080fe40000410000ULL,
0x00000003341f7220ULL, 0x080fe40000410000ULL, 0x00000003351d7220ULL, 0x080fe40000410000ULL,
0x00000003361e7220ULL, 0x000fc40000410000ULL, 0x00000003371c7220ULL, 0x080fe40000410000ULL,
0x0000000332327220ULL, 0x080fe40000410000ULL, 0x00000003242d7220ULL, 0x080fe40000410000ULL,
0x0000000325307220ULL, 0x080fe40000410000ULL, 0x00000003260c7220ULL, 0x080fe40000410000ULL,
0x00000003271a7220ULL, 0x000fc40000410000ULL, 0x00000003202f7220ULL, 0x080fe40000410000ULL,
0x00000003220d7220ULL, 0x080fe40000410000ULL, 0x0000000315157220ULL, 0x080fe40000410000ULL,
0x00000003160f7220ULL, 0x080fe40000410000ULL, 0x0000000317187220ULL, 0x000fe40000410000ULL,
0x000000ffff237224ULL, 0x000fc400078e0038ULL, 0x000000ffff217224ULL, 0x000fe400078e0039ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0029ULL, 0x000000ffff287224ULL, 0x000fe200078e0014ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000071067f8cULL, 0x0002a2000c80043fULL,
0x000000ffff297224ULL, 0x000fe400078e0015ULL, 0x000000ffff257224ULL, 0x000fe400078e0032ULL,
0x000000ffff227224ULL, 0x000fc400078e003aULL, 0x000000ffff207224ULL, 0x000fe400078e003bULL,
0x000000ffff247224ULL, 0x000fe400078e0008ULL, 0x000000ffff267224ULL, 0x000fe400078e0009ULL,
0x000000ffff327224ULL, 0x000fe400078e000aULL, 0x000000ffff277224ULL, 0x000fe400078e000bULL,
0x000000ffff147224ULL, 0x000fc400078e000cULL, 0x000000ffff157224ULL, 0x000fe400078e000dULL,
0x000000ffff167224ULL, 0x000fe400078e000eULL, 0x000000ffff177224ULL, 0x000fc400078e000fULL,
0x0000000000087805ULL, 0x002fca0000015200ULL, 0x00000400710b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x006fe40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc8000001140bULL, 0x0000000d0a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x000000020a0a7819ULL, 0x000fc8000000120bULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400710b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000402197824ULL, 0x000fe200078e00ffULL,
0x0000006b0400720cULL, 0x000fc80003f06070ULL, 0xfffffff019077812ULL, 0x000fca00078ec0ffULL,
0x0000008000127824ULL, 0x000fca00078e0207ULL, 0x0174000012087984ULL, 0x0002a20000000c00ULL,
0x0000136000008947ULL, 0x000fea0003800000ULL, 0x0000000202347824ULL, 0x040fe200078e00ffULL,
0xffffff0005367810ULL, 0x000fe20007ffe0ffULL, 0x00000002ff467424ULL, 0x000fe200078e00ffULL,
0x0000006202067211ULL, 0x000fe400078ff0ffULL, 0x0000003661057217ULL, 0x000fe40007800000ULL,
0x0000000634347812ULL, 0x000fe400078ec0ffULL, 0x00005a00ff0c7a19ULL, 0x000fe20000011606ULL,
0x0000000105367824ULL, 0x000fe200078e0a36ULL, 0x0000580034057a10ULL, 0x000fe20007ffe0ffULL,
0x000000015f077824ULL, 0x000fe200078e0234ULL, 0x0000000c6d517217ULL, 0x000fc40003800000ULL,
0x000000360500720cULL, 0x080fe20003f06070ULL, 0x00000001070e7824ULL, 0x140fe200078e0a36ULL,
0x000000360700720cULL, 0x000fe20003f26070ULL, 0x0000005160517224ULL, 0x000fe200078e02ffULL,
0x0000000806077810ULL, 0x000fe20007ffe0ffULL, 0x0000000105067824ULL, 0x000fe200078e0a36ULL,
0x0000000e6d0e7217ULL, 0x040fe40003800000ULL, 0x00005a00ff0c7a19ULL, 0x000fe40000011607ULL,
0x000000066d067217ULL, 0x000fc40003800000ULL, 0x00000004ff0e7819ULL, 0x000fe4000001160eULL,
0x0000001034377812ULL, 0x000fe400078efcffULL, 0x0000000c6d4f7217ULL, 0x000fe40003800000ULL,
0x000000ff06397207ULL, 0x000fe40000000000ULL, 0x000000ff0e067207ULL, 0x000fe20000800000ULL,
0x000000015f3f7824ULL, 0x000fe200078e0237ULL, 0x00005800373b7a10ULL, 0x000fe20007ffe0ffULL,
0x0000004f604f7224ULL, 0x000fe200078e02ffULL, 0x0000005139117211ULL, 0x000fe200078fe0ffULL,
0x00000001510f7824ULL, 0x000fe200078e0206ULL, 0x000000363f00720cULL, 0x040fe20003f26070ULL,
0x000000013f3e7824ULL, 0x100fe200078e0a36ULL, 0x0000004f390d7211ULL, 0x000fe200078fe0ffULL,
0x000000013b3c7824ULL, 0x000fe200078e0a36ULL, 0x00000020343f7812ULL, 0x000fe200078efcffULL,
0x0000600011107625ULL, 0x000fe200078e0046ULL, 0x0000003e6d3e7217ULL, 0x000fc60003800000ULL,
0x000060000f0e7625ULL, 0x000fe200078e0046ULL, 0x000000363b00720cULL, 0x000fe20003f06070ULL,
0x0000000810387981ULL, 0x000722000c1e9500ULL, 0x0000003c6d3c7217ULL, 0x000fe20003800000ULL,
0x000060000d0c7625ULL, 0x080fe200078e0046ULL, 0x000058003f417a10ULL, 0x000fe20007ffe0ffULL,
0x000000080e357981ULL, 0x000322000c1e9500ULL, 0x00000004ff3e7819ULL, 0x000fe2000001163eULL,
0x0000000106077824ULL, 0x000fe200078e024fULL, 0x000000ff3c3c7207ULL, 0x000fe20000000000ULL,
0x0000000141427824ULL, 0x000fe200078e0a36ULL, 0x000000080c3a7981ULL, 0x000522000c1e9500ULL,
0x0000600007067625ULL, 0x000fe200078e0046ULL, 0x000000364100720cULL, 0x000fc40003f06070ULL,
0x000000ff3e0e7207ULL, 0x002fe20000800000ULL, 0x000000015f477824ULL, 0x000fe200078e023fULL,
0x000000426d427217ULL, 0x000fe20003800000ULL, 0x00000008063d7981ULL, 0x000322000c1e9500ULL,
0x000000513c0d7211ULL, 0x004fe200078fe0ffULL, 0x00000001510f7824ULL, 0x000fe200078e020eULL,
0x000000ff42487207ULL, 0x000fe20000000000ULL, 0x0000000147447824ULL, 0x040fe200078e0a36ULL,
0x000000364700720cULL, 0x000fe20003f26070ULL, 0x000060000d067625ULL, 0x002fe200078e0046ULL,
0x0000003034477812ULL, 0x000fc600078efcffULL, 0x000060000f0c7625ULL, 0x000fe200078e0046ULL,
0x0000004f3c0f7211ULL, 0x000fe200078fe0ffULL, 0x00000008063e7981ULL, 0x0002a2000c1e9500ULL,
0x000000446d447217ULL, 0x000fe20003800000ULL, 0x000000010e117824ULL, 0x008fe400078e024fULL,
0x000000015f537824ULL, 0x000fe200078e0247ULL, 0x00000004ff447819ULL, 0x000fe20000011644ULL,
0x000060000f0e7625ULL, 0x080fe200078e0046ULL, 0x0000580047497a10ULL, 0x000fe20007ffe0ffULL,
0x000000080c437981ULL, 0x0006a2000c1e9500ULL, 0x0000005148077211ULL, 0x002fe200078fe0ffULL,
0x0000600011107625ULL, 0x080fe200078e0046ULL, 0x000000ff44447207ULL, 0x000fe20000800000ULL,
0x000000080e407981ULL, 0x0002a4000c1e9500ULL, 0x0000600007067625ULL, 0x000fc400078e0046ULL,
0x0000000810457981ULL, 0x0002a4000c1e9500ULL, 0x00000001534a7824ULL, 0x000fe400078e0a36ULL,
0x0000000806427981ULL, 0x0002a2000c1e9500ULL, 0x00000001510d7824ULL, 0x008fe200078e0244ULL,
0x0000004f480f7211ULL, 0x002fe400078fe0ffULL, 0x0000004a6d4a7217ULL, 0x000fe20003800000ULL,
0x0000000144117824ULL, 0x000fe400078e024fULL, 0x0000000149067824ULL, 0x040fe200078e0a36ULL,
0x000000364900720cULL, 0x000fe20003f06070ULL, 0x000060000d0c7625ULL, 0x000fe200078e0046ULL,
0x000000365300720cULL, 0x000fc40003f26070ULL, 0x000000066d067217ULL, 0x000fe20003800000ULL,
0x000060000f0e7625ULL, 0x080fe200078e0046ULL, 0x00000004ff077819ULL, 0x000fe2000001164aULL,
0x000000080c4b7981ULL, 0x0002e4000c1e9500ULL, 0x0000600011107625ULL, 0x000fe200078e0046ULL,
0x000000ff064a7207ULL, 0x000fe20000000000ULL, 0x000000080e447981ULL, 0x0002e2000c1e9500ULL,
0x000000ff074c7207ULL, 0x000fc60000800000ULL, 0x00000008104d7981ULL, 0x0002e2000c1e9500ULL,
0x000000514a077211ULL, 0x000fe200078fe0ffULL, 0x00000001510d7824ULL, 0x002fc800078e024cULL,
0x0000600007067625ULL, 0x000fc800078e0046ULL, 0x000060000d0c7625ULL, 0x000fe400078e0046ULL,
0x0000000806067981ULL, 0x0002e2000c1e9500ULL, 0x0000004f4a0f7211ULL, 0x000fc600078fe0ffULL,
0x000000080c0d7981ULL, 0x0002e2000c1e9500ULL, 0x000000014c117824ULL, 0x000fe400078e024fULL,
0x000060000f0e7625ULL, 0x000fc800078e0046ULL, 0x0000600011107625ULL, 0x000fe400078e0046ULL,
0x000000080e0e7981ULL, 0x0002e8000c1e9500ULL, 0x00000008104f7981ULL, 0x0002e2000c1e9500ULL,
0xfffffff0394c7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff467424ULL, 0x000fe200078e00ffULL,
0xfffffff03c4e7812ULL, 0x000fc600078ec0ffULL, 0x00000001364c7824ULL, 0x000fe200078e024cULL,
0x0000000134737812ULL, 0x000fc600078efcffULL, 0x00000001053c7824ULL, 0x000fe200078e0a4cULL,
0x00000008346f7812ULL, 0x040fe400078efcffULL, 0x0000000934697812ULL, 0x000fe400078efcffULL,
0x0000003c463c7219ULL, 0x000fe400000006ffULL, 0x00005800737d7a10ULL, 0x000fe40007ffe0ffULL,
0x000058006f7b7a10ULL, 0x000fe40007ffe0ffULL, 0x0000580069797a10ULL, 0x000fc40007ffe0ffULL,
0xfffffff048507812ULL, 0x000fe200078ec0ffULL, 0x000000017b487824ULL, 0x100fe200078e0a4cULL,
0xfffffff04a647812ULL, 0x000fe200078ec0ffULL, 0x000000017d4a7824ULL, 0x100fe400078e0a4cULL,
0x00000001794c7824ULL, 0x000fe200078e0a4cULL, 0x0000001834597812ULL, 0x000fe400078efcffULL,
0x0000004846487219ULL, 0x040fe400000006ffULL, 0x0000004c464c7219ULL, 0x000fe200000006ffULL,
0x00000001364e7824ULL, 0x000fe200078e024eULL, 0x0000580059657a10ULL, 0x000fc60007ffe0ffULL,
0x000000013b5a7824ULL, 0x100fe400078e0a4eULL, 0x00000001655c7824ULL, 0x000fe200078e0a4eULL,
0x00000011345b7812ULL, 0x040fe400078efcffULL, 0x0000001934577812ULL, 0x000fe400078efcffULL,
0x0000004a464a7219ULL, 0x040fe400000006ffULL, 0x0000005a465a7219ULL, 0x040fe400000006ffULL,
0x0000005c465c7219ULL, 0x000fe200000006ffULL, 0x0000000136507824ULL, 0x000fe200078e0250ULL,
0x000058005b677a10ULL, 0x000fc40007ffe0ffULL, 0x00005800575d7a10ULL, 0x000fe20007ffe0ffULL,
0x0000000141687824ULL, 0x000fe400078e0a50ULL, 0x0000000167587824ULL, 0x100fe400078e0a4eULL,
0x000000015d667824ULL, 0x000fe200078e0a4eULL, 0x0000002134557812ULL, 0x040fe400078efcffULL,
0x0000002834537812ULL, 0x040fe400078efcffULL, 0x0000002934517812ULL, 0x000fc400078efcffULL,
0x0000005846587219ULL, 0x040fe400000006ffULL, 0x0000006646667219ULL, 0x040fe400000006ffULL,
0x0000006846687219ULL, 0x000fe200000006ffULL, 0x0000000136647824ULL, 0x000fe200078e0264ULL,
0x0000580055107a10ULL, 0x002fe40007ffe0ffULL, 0x00005800530c7a10ULL, 0x000fe40007ffe0ffULL,
0x0000580051397a10ULL, 0x000fe20007ffe0ffULL, 0x00000001106a7824ULL, 0x000fc400078e0a50ULL,
0x000000010c6e7824ULL, 0x100fe400078e0a50ULL, 0x0000000139707824ULL, 0x000fe400078e0a50ULL,
0x0000000149727824ULL, 0x000fe200078e0a64ULL, 0x0000003134117812ULL, 0x040fe400078efcffULL,
0x00000038340f7812ULL, 0x040fe400078efcffULL, 0x0000003934077812ULL, 0x000fe400078efcffULL,
0x0000006a466a7219ULL, 0x000fc400000006ffULL, 0x0000006e466e7219ULL, 0x040fe400000006ffULL,
0x0000007046707219ULL, 0x040fe400000006ffULL, 0x0000007246727219ULL, 0x000fe400000006ffULL,
0x00005800114e7a10ULL, 0x000fe40007ffe0ffULL, 0x000058000f507a10ULL, 0x000fe40007ffe0ffULL,
0x0000580007527a10ULL, 0x000fe20007ffe0ffULL, 0x000000014e547824ULL, 0x000fc400078e0a64ULL,
0x0000000150567824ULL, 0x100fe400078e0a64ULL, 0x0000000152647824ULL, 0x000fe200078e0a64ULL,
0x0000005446547219ULL, 0x040fe400000006ffULL, 0x0000005646567219ULL, 0x040fe400000006ffULL,
0x0000006446647219ULL, 0x000fe400000006ffULL, 0x0000541038357816ULL, 0x010fc80000000035ULL,
0x000000353cff7212ULL, 0x000fc8000780c0ffULL, 0x000000360500720cULL, 0x000fc80000701470ULL,
0x000000363400720cULL, 0x000fe40000701070ULL, 0x000054103a3d7816ULL, 0x000fe4000000003dULL,
0xff80000023237808ULL, 0x000fe40000000000ULL, 0x0000003d3cff7212ULL, 0x080fe4000788c0ffULL,
0x0000003d48ff7212ULL, 0x080fe400078cc0ffULL, 0x0000003d4cff7212ULL, 0x000fc4000780c0ffULL,
0x000000360500720cULL, 0x080fe40002781470ULL, 0x000000367b00720cULL, 0x080fe400037c1470ULL,
0x000000367900720cULL, 0x080fe40000701470ULL, 0x000000354cff7212ULL, 0x000fe4000782c0ffULL,
0x000000363400720cULL, 0x080fe40002781070ULL, 0x000000366f00720cULL, 0x000fc400037c1070ULL,
0x000000366900720cULL, 0x080fe40000701070ULL, 0x000054103e437816ULL, 0x004fe40000000043ULL,
0x000000367900720cULL, 0x000fe40000f21470ULL, 0xff80000022227808ULL, 0x000fe40002000000ULL,
0x0000541040457816ULL, 0x000fe40000000045ULL, 0xff8000001e1e7808ULL, 0x000fc40003000000ULL,
0xff8000001c1c7808ULL, 0x000fe40000000000ULL, 0x000000354aff7212ULL, 0x080fe4000786c0ffULL,
0x0000003548ff7212ULL, 0x000fe4000784c0ffULL, 0x0000003d4aff7212ULL, 0x000fe400078ac0ffULL,
0x000000435aff7212ULL, 0x040fe4000788c0ffULL, 0x000000455aff7212ULL, 0x000fc400078cc0ffULL,
0x000000455cff7212ULL, 0x000fe4000780c0ffULL, 0x000000366900720cULL, 0x080fe40000f21070ULL,
0x000000367d00720cULL, 0x0c0fe40001f61470ULL, 0x000000367d00720cULL, 0x080fe40002fa1470ULL,
0x000000367b00720cULL, 0x080fe40001741470ULL, 0x000000363b00720cULL, 0x000fc40002781470ULL,
0x000000363b00720cULL, 0x080fe400037c1470ULL, 0x000000366500720cULL, 0x080fe40000701470ULL,
0xff8000001d1d7808ULL, 0x000fe40000800000ULL, 0x000000367300720cULL, 0x0c0fe40001f61070ULL,
0x000000367300720cULL, 0x080fe40002fa1070ULL, 0x000000366f00720cULL, 0x000fc40001741070ULL,
0x000000363700720cULL, 0x0c0fe40002721070ULL, 0x000000363700720cULL, 0x080fe400037c1070ULL,
0x000000365900720cULL, 0x000fe40000701070ULL, 0x00005410424b7816ULL, 0x008fe4000000004bULL,
0x00005410444d7816ULL, 0x000fe4000000004dULL, 0xff80000021217808ULL, 0x000fc40001800000ULL,
0xff80000020207808ULL, 0x000fe40002800000ULL, 0xff8000001f1f7808ULL, 0x000fe40001000000ULL,
0xff8000001b1b7808ULL, 0x000fe40000800000ULL, 0xff80000025257808ULL, 0x000fe40003000000ULL,
0xff80000026267808ULL, 0x000fe40000000000ULL, 0x0000004358ff7212ULL, 0x000fc4000786c0ffULL,
0x000000435cff7212ULL, 0x080fe400078ac0ffULL, 0x0000004366ff7212ULL, 0x000fe4000784c0ffULL,
0x0000004558ff7212ULL, 0x080fe4000788c0ffULL, 0x0000004566ff7212ULL, 0x000fe4000782c0ffULL,
0x0000004b68ff7212ULL, 0x040fe400078cc0ffULL, 0x0000004d68ff7212ULL, 0x000fc4000780c0ffULL,
0x000000366700720cULL, 0x0c0fe40001f61470ULL, 0x000000366700720cULL, 0x080fe40002781470ULL,
0x000000366500720cULL, 0x080fe40002fa1470ULL, 0x000000365d00720cULL, 0x0c0fe40001741470ULL,
0x000000365d00720cULL, 0x080fe40000f21470ULL, 0x000000364100720cULL, 0x000fc400037c1470ULL,
0x000000364100720cULL, 0x080fe40000701470ULL, 0x000000365b00720cULL, 0x0c0fe40001f61070ULL,
0x000000365b00720cULL, 0x080fe40002781070ULL, 0x000000365900720cULL, 0x080fe40002fa1070ULL,
0x000000365700720cULL, 0x0c0fe40001741070ULL, 0x000000365700720cULL, 0x000fc40000f21070ULL,
0x000000363f00720cULL, 0x0c0fe400037c1070ULL, 0x000000363f00720cULL, 0x000fe40000701070ULL,
0x00005410060d7816ULL, 0x000fe4000000000dULL, 0xff8000002a2a7808ULL, 0x000fe40001800000ULL,
0xff80000024247808ULL, 0x000fe40002000000ULL, 0xff8000002b2b7808ULL, 0x000fc40002800000ULL,
0xff80000033337808ULL, 0x000fe40001000000ULL, 0xff80000032327808ULL, 0x000fe40000800000ULL,
0xff80000031317808ULL, 0x000fe40003000000ULL, 0xff80000027277808ULL, 0x000fe40000000000ULL,
0x0000004b6aff7212ULL, 0x080fe4000786c0ffULL, 0x0000004b6eff7212ULL, 0x000fc4000788c0ffULL,
0x0000004b70ff7212ULL, 0x000fe400078ac0ffULL, 0x0000004d6aff7212ULL, 0x080fe4000784c0ffULL,
0x0000004d6eff7212ULL, 0x080fe4000782c0ffULL, 0x0000004d70ff7212ULL, 0x000fe400078cc0ffULL,
0x0000000d72ff7212ULL, 0x000fe4000780c0ffULL, 0x000000361000720cULL, 0x000fc40001f61470ULL,
0x000000361000720cULL, 0x080fe40001741470ULL, 0x000000360c00720cULL, 0x0c0fe40002781470ULL,
0x000000360c00720cULL, 0x080fe40000f21470ULL, 0x000000363900720cULL, 0x0c0fe40002fa1470ULL,
0x000000363900720cULL, 0x080fe400037c1470ULL, 0x000000364900720cULL, 0x000fc40000701470ULL,
0x000000365500720cULL, 0x0c0fe40001f61070ULL, 0x000000365500720cULL, 0x080fe40001741070ULL,
0x000000365300720cULL, 0x0c0fe40002781070ULL, 0x000000365300720cULL, 0x080fe40000f21070ULL,
0x000000365100720cULL, 0x0c0fe40002fa1070ULL, 0x000000365100720cULL, 0x000fc400037c1070ULL,
0x000000364700720cULL, 0x000fe40000701070ULL, 0x000054100e4f7816ULL, 0x000fe4000000004fULL,
0xff8000002c2c7808ULL, 0x000fe40001800000ULL, 0xff80000013137808ULL, 0x000fe40001000000ULL,
0xff8000002d2d7808ULL, 0x000fe40002000000ULL, 0xff80000014147808ULL, 0x000fc40000800000ULL,
0xff80000030307808ULL, 0x000fe40002800000ULL, 0xff8000001a1a7808ULL, 0x000fe40003000000ULL,
0xff8000002f2f7808ULL, 0x000fe40000000000ULL, 0x0000000d54ff7212ULL, 0x080fe4000786c0ffULL,
0x0000000d56ff7212ULL, 0x080fe4000784c0ffULL, 0x0000000d64ff7212ULL, 0x000fc4000788c0ffULL,
0x0000004f72ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004f54ff7212ULL, 0x080fe400078ac0ffULL,
0x0000004f56ff7212ULL, 0x080fe400078cc0ffULL, 0x0000004f64ff7212ULL, 0x000fe4000780c0ffULL,
0x000000364900720cULL, 0x080fe40000f21470ULL, 0x000000364e00720cULL, 0x000fc40001f61470ULL,
0x000000364e00720cULL, 0x080fe40002fa1470ULL, 0x000000365000720cULL, 0x0c0fe40001741470ULL,
0x000000365000720cULL, 0x080fe400037c1470ULL, 0x000000365200720cULL, 0x0c0fe40002781470ULL,
0x000000365200720cULL, 0x080fe40000701470ULL, 0x000000364700720cULL, 0x000fc40000f21070ULL,
0x000000361100720cULL, 0x0c0fe40001f61070ULL, 0x000000361100720cULL, 0x080fe40002fa1070ULL,
0x000000360f00720cULL, 0x0c0fe40001741070ULL, 0x000000360f00720cULL, 0x080fe400037c1070ULL,
0x000000360700720cULL, 0x0c0fe40002781070ULL, 0x000000360700720cULL, 0x000fc40000701070ULL,
0xff8000002e2e7808ULL, 0x000fe40001800000ULL, 0xff80000028287808ULL, 0x000fe40001000000ULL,
0xff80000029297808ULL, 0x000fe40002000000ULL, 0xff80000015157808ULL, 0x000fe40000800000ULL,
0xff80000016167808ULL, 0x000fe40002800000ULL, 0xff80000017177808ULL, 0x000fc40003000000ULL,
0xff80000018187808ULL, 0x000fc40000000000ULL, 0x000000230800720bULL, 0x004fe40003f1e000ULL,
0x000000220900720bULL, 0x000fe40003f3e000ULL, 0x0000000823087208ULL, 0x000fe40004000000ULL,
0x0000000922097208ULL, 0x000fe40004800000ULL, 0x000000210800720bULL, 0x000fe40003f1e000ULL,
0x000000200900720bULL, 0x000fc40003f3e000ULL, 0x0000000821087208ULL, 0x000fe40004000000ULL,
0x0000000920097208ULL, 0x000fe40004800000ULL, 0x0000001f0800720bULL, 0x000fe40003f1e000ULL,
0x0000001e0900720bULL, 0x000fe40003f3e000ULL, 0x000000081f087208ULL, 0x000fe40004000000ULL,
0x000000091e097208ULL, 0x000fc40004800000ULL, 0x0000001d0800720bULL, 0x000fe40003f1e000ULL,
0x0000001c0900720bULL, 0x000fe40003f3e000ULL, 0x000000081d087208ULL, 0x000fe40004000000ULL,
0x000000091c067208ULL, 0x000fe40004800000ULL, 0x0000001b0800720bULL, 0x000fe40003f1e000ULL,
0x000000250600720bULL, 0x000fc40003f3e000ULL, 0x000000081b057208ULL, 0x000fe40004000000ULL,
0x0000000625077208ULL, 0x000fe40004800000ULL, 0x0000002a0500720bULL, 0x000fe40003f1e000ULL,
0x000000240700720bULL, 0x000fe40003f3e000ULL, 0x000000052a067208ULL, 0x000fe40004000000ULL,
0x0000000724077208ULL, 0x000fc40004800000ULL, 0x0000002b0600720bULL, 0x000fe40003f1e000ULL,
0x000000260700720bULL, 0x000fe40003f3e000ULL, 0x000000062b067208ULL, 0x000fe40004000000ULL,
0x0000000726077208ULL, 0x000fe40004800000ULL, 0x000000330600720bULL, 0x000fe40003f1e000ULL,
0x000000320700720bULL, 0x000fc40003f3e000ULL, 0x0000000633067208ULL, 0x000fe40004000000ULL,
0x0000000732087208ULL, 0x000fe40004800000ULL, 0x000000310600720bULL, 0x000fe40003f1e000ULL,
0x000000270800720bULL, 0x000fe40003f3e000ULL, 0x0000000631057208ULL, 0x000fe40004000000ULL,
0x0000000827087208ULL, 0x000fc40004800000ULL, 0x0000002c0500720bULL, 0x000fe40003f1e000ULL,
0x000000130800720bULL, 0x000fe40003f3e000ULL, 0x000000052c067208ULL, 0x000fe40004000000ULL,
0x0000000813057208ULL, 0x000fe40004800000ULL, 0x0000002d0600720bULL, 0x000fe40003f1e000ULL,
0x000000140500720bULL, 0x000fc40003f3e000ULL, 0x000000062d077208ULL, 0x000fe40004000000ULL,
0x0000000514057208ULL, 0x000fe40004800000ULL, 0x000000300700720bULL, 0x000fe40003f1e000ULL,
0x0000001a0500720bULL, 0x000fe40003f3e000ULL, 0x0000000730067208ULL, 0x000fe40004000000ULL,
0x000000051a087208ULL, 0x000fc40004800000ULL, 0x0000002f0600720bULL, 0x000fe40003f1e000ULL,
0x000000150800720bULL, 0x000fe40003f3e000ULL, 0x000000062f057208ULL, 0x000fe40004000000ULL,
0x0000000815077208ULL, 0x000fe40004800000ULL, 0x0000002e0500720bULL, 0x000fe40003f1e000ULL,
0x000000160700720bULL, 0x000fc40003f3e000ULL, 0x000000052e057208ULL, 0x000fe40004000000ULL,
0x0000000716067208ULL, 0x000fe40004800000ULL, 0x000000280500720bULL, 0x000fe40003f1e000ULL,
0x000000170600720bULL, 0x000fe40003f3e000ULL, 0x0000000528087208ULL, 0x000fe40004000000ULL,
0x0000000617057208ULL, 0x000fc40004800000ULL, 0x000000290800720bULL, 0x000fe40003f1e000ULL,
0x000000180500720bULL, 0x000fe40003f3e000ULL, 0x00000008290d7208ULL, 0x000fe40004000000ULL,
0x00000005180f7208ULL, 0x000fe20004800000ULL, 0x000016b27f007947ULL, 0x000fec000b800000ULL,
0x0c401f000d057f89ULL, 0x0004e400000e0000ULL, 0x000000050d00720bULL, 0x008fc80003f1e000ULL,
0x0000000d05117208ULL, 0x000fe20004000000ULL, 0x000016e27f007947ULL, 0x000fea000b800000ULL,
0x0c401f000f057f89ULL, 0x000ee800000e0000ULL, 0x0c401f000a097f89ULL, 0x000f2800000e0000ULL,
0x0c401f000b067f89ULL, 0x000e6800000e0000ULL, 0x0c201f0011087f89ULL, 0x000ea200000e0000ULL,
0x000000050f00720bULL, 0x008fc40003f1e000ULL, 0x000000090a00720bULL, 0x010fe40003f3e000ULL,
0x0000000f05077208ULL, 0x000fe40004000000ULL, 0x0000000a090c7208ULL, 0x000fe40004800000ULL,
0x000000060b00720bULL, 0x002fe20003f1e000ULL, 0x0c201f00070e7f89ULL, 0x000e6600000e0000ULL,
0x0000000b06057208ULL, 0x000fe20004000000ULL, 0x0c201f000c0d7f89ULL, 0x004ea200000e0000ULL,
0x000000081100720bULL, 0x000fc60003f1e000ULL, 0x0c201f0005067f89ULL, 0x0006e200000e0000ULL,
0x0000001108087208ULL, 0x000fe40004000000ULL, 0x0000000e0700720bULL, 0x002fe40003f3e000ULL,
0x0000000d0c00720bULL, 0x004fe40003f5e000ULL, 0x000000070e097208ULL, 0x000fe40004800000ULL,
0x0000000c0d0a7208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b080c7820ULL, 0x008fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3c003c00ff117424ULL, 0x000fe200078e00ffULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b2b0b7823ULL, 0x100fe2000001080cULL,
0x000000060500720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b23237823ULL, 0x000fc4000001080cULL,
0x0000000b00367308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b21217823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b1d1d7823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b1b077823ULL, 0x100fe2000001080cULL, 0x0000002300237308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b280b7823ULL, 0x104fe4000001080cULL, 0x3fb8aa3b29287823ULL, 0x000fc4000001080cULL,
0x3fb8aa3b09297820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe2000001080cULL,
0x00000021000e7308ULL, 0x002fe20000000800ULL, 0x3fb8aa3b20207823ULL, 0x100fe40000010829ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b22227823ULL, 0x100fe40000010829ULL,
0x3fb8aa3b1e1e7823ULL, 0x000fe20000010829ULL, 0x0000001f001f7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b33337823ULL, 0x000fc4000001080cULL, 0x3fb8aa3b311b7823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b2d2b7823ULL, 0x100fe2000001080cULL,
0x0000001d00107308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b30307823ULL, 0x000fe4000001080cULL,
0x3fb8aa3b24247823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b26267823ULL, 0x000fc40000010829ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010829ULL, 0x00000022000d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b32327823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b27277823ULL, 0x100fe40000010829ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe40000010829ULL, 0x3fb8aa3b13137823ULL, 0x100fe20000010829ULL,
0x0000002000207308ULL, 0x000e620000000800ULL, 0x3fb8aa3b14147823ULL, 0x000fc40000010829ULL,
0x3fb8aa3b15157823ULL, 0x000fca0000010829ULL, 0x0000001e000f7308ULL, 0x000ff00000000800ULL,
0x0000001c001c7308ULL, 0x000ea20000000800ULL, 0x0000000d200d723eULL, 0x002fce00000000ffULL,
0x0000000700347308ULL, 0x0003f00000000800ULL, 0x0000002a00357308ULL, 0x0007220000000800ULL,
0x3fb8aa3b2f077823ULL, 0x002fe2000001080cULL, 0x0000000f1c0f723eULL, 0x004fcc00000000ffULL,
0x0000003300337308ULL, 0x000e620000000800ULL, 0x3fb8aa3b2e2a7823ULL, 0x008fe2000001080cULL,
0x000000230e0c723eULL, 0x000fe400000000ffULL, 0x0000001f100e723eULL, 0x000fe200000000ffULL,
0x3c003c00ff107424ULL, 0x000fc600078e00ffULL, 0x00000025001d7308ULL, 0x000fe20000000800ULL,
0x00000034351c723eULL, 0x010fe400000000ffULL, 0x00000002ff347819ULL, 0x000fe20000011602ULL,
0x000000100c20723cULL, 0x000f6800000018ffULL, 0x0000002400247308ULL, 0x000ea20000000800ULL,
0x00000036331e723eULL, 0x002fe200000000ffULL, 0x00000008342f7824ULL, 0x000fc400078e00ffULL,
0x0000000834367824ULL, 0x040fe400078e00ffULL, 0x0000000834337824ULL, 0x040fe400078e00ffULL,
0x0000002600267308ULL, 0x000fe20000000800ULL, 0x0000000834357824ULL, 0x000fce00078e00ffULL,
0x00000032002d7308ULL, 0x0002e20000000800ULL, 0x0000001d241d723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b16247823ULL, 0x000fe20000010829ULL, 0x0000000234167810ULL, 0x000fc80007ffe0ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee216ULL, 0x0000001b001b7308ULL, 0x000fe20000000800ULL,
0x0000000434327810ULL, 0x002fc80007ffe0ffULL, 0xfffffff833337812ULL, 0x000fe400078ee232ULL,
0x000000262d1f723eULL, 0x008fe200000000ffULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b17267823ULL, 0x100fe20000010829ULL, 0x0000000334177810ULL, 0x040fe20007ffe0ffULL,
0x00000008342d7824ULL, 0x000fe400078e00ffULL, 0x3fb8aa3b18297823ULL, 0x000fe20000010829ULL,
0x000000101c20723cULL, 0x020f620000001820ULL, 0xfffffff836317812ULL, 0x000fe200078ee217ULL,
0x0000002b002b7308ULL, 0x000ff00000000800ULL, 0x0000003000307308ULL, 0x000e700000000800ULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x00000013002e7308ULL, 0x000fe20000000800ULL,
0x0000002b3016723eULL, 0x002fe200000000ffULL, 0x00000008342b7824ULL, 0x000fca00078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee234ULL, 0x0000001400257308ULL, 0x0003f00000000800ULL,
0x0000001a001a7308ULL, 0x000ea20000000800ULL, 0x0000000134147810ULL, 0x002fc80007ffe0ffULL,
0xfffffff82d2d7812ULL, 0x000fe400078ee214ULL, 0x0000001b2c14723eULL, 0x000fe200000000ffULL,
0x0000001500137308ULL, 0x0003e20000000800ULL, 0x00000008342c7824ULL, 0x000fe200078e00ffULL,
0x000000251a17723eULL, 0x004fcc00000000ffULL, 0x0000000700077308ULL, 0x000fe20000000800ULL,
0x000000272e15723eULL, 0x002fe400000000ffULL, 0x0000000634257810ULL, 0x040fe40007ffe0ffULL,
0xffffffff34277810ULL, 0x000fe40007ffe0ffULL, 0xfffffff82c377812ULL, 0x000fe200078ee225ULL,
0x000000101420723cULL, 0x020f620000001820ULL, 0x0000002a002a7308ULL, 0x000e700000000800ULL,
0x0000000b000b7308ULL, 0x000ff00000000800ULL, 0x0000002800287308ULL, 0x000ff00000000800ULL,
0x0000002400187308ULL, 0x0004f00000000800ULL, 0x00000026001b7308ULL, 0x0009e20000000800ULL,
0x0000000534247810ULL, 0x004fc80007ffe0ffULL, 0xfffffff835357812ULL, 0x000fe400078ee224ULL,
0x000000072a24723eULL, 0x002fe200000000ffULL, 0x00000029001a7308ULL, 0x0002a20000000800ULL,
0x0000000834267810ULL, 0x050fe20007ffe0ffULL, 0x0000000834347824ULL, 0x000fe200078e00ffULL,
0x000000131825723eULL, 0x008fe400000000ffULL, 0x0000000c19187812ULL, 0x000fe200078ec0ffULL,
0x00000008263b7824ULL, 0x000fe200078e00ffULL, 0xfffffff834397812ULL, 0x000fc800078ee227ULL,
0xfffffff83b297812ULL, 0x002fe400078ee226ULL, 0x0000000b2826723eULL, 0x000fe400000000ffULL,
0x0001100000287811ULL, 0x000fe400078e58ffULL, 0x0000001b1a27723eULL, 0x004fe400000000ffULL,
0x00000005060b7208ULL, 0x000fe20004800000ULL, 0x000000102b2b7824ULL, 0x100fe400078e0228ULL,
0x000000102d2d7824ULL, 0x000fc400078e0228ULL, 0x000000102420723cULL, 0x020f620000001820ULL,
0x000000102f2f7824ULL, 0x100fe400078e0228ULL, 0x0000001031317824ULL, 0x100fe400078e0228ULL,
0x0000001033337824ULL, 0x000fe400078e0228ULL, 0x000000012b2b7824ULL, 0x000fe400078e0218ULL,
0x0000001035357824ULL, 0x100fe400078e0228ULL, 0x00000001182d7824ULL, 0x000fe200078e022dULL,
0x0000000c2b007388ULL, 0x0003e20000000800ULL, 0x0000001037377824ULL, 0x000fc400078e0228ULL,
0x00000001182f7824ULL, 0x040fe200078e022fULL, 0x0000000e2d007388ULL, 0x0003e20000000800ULL,
0x0000001039397824ULL, 0x100fe400078e0228ULL, 0x0000000118317824ULL, 0x040fe200078e0231ULL,
0x0000001c2f007388ULL, 0x0003e20000000800ULL, 0x0000001029297824ULL, 0x000fe400078e0228ULL,
0x0000000118337824ULL, 0x040fe200078e0233ULL, 0x0000001e31007388ULL, 0x0003e20000000800ULL,
0x0000000118357824ULL, 0x000fc400078e0235ULL, 0x0000000118377824ULL, 0x040fe200078e0237ULL,
0x0000001433007388ULL, 0x0003e20000000800ULL, 0x0000000118397824ULL, 0x040fe400078e0239ULL,
0x0000000118187824ULL, 0x000fe200078e0229ULL, 0x0000001635007388ULL, 0x0003e20000000800ULL,
0x000000ffff217224ULL, 0x020fc600078e0022ULL, 0x0000002437007388ULL, 0x0003e80000000800ULL,
0x0000002639007388ULL, 0x0003e80000000800ULL, 0x0000000d18007388ULL, 0x0003e80000000800ULL,
0x0004000f2d007388ULL, 0x0003e80000000800ULL, 0x0004001d2f007388ULL, 0x0003e80000000800ULL,
0x0004001f31007388ULL, 0x0003e80000000800ULL, 0x0004001533007388ULL, 0x0003e80000000800ULL,
0x0004001735007388ULL, 0x0003e80000000800ULL, 0x0004002537007388ULL, 0x0003e80000000800ULL,
0x0004002739007388ULL, 0x0003e80000000800ULL, 0x0170000812008388ULL, 0x0003e80000000c00ULL,
0x0172002012008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000077ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080077ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100077ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000104047810ULL, 0x000fe20007ffe0ffULL, 0x0000180077ff7f8cULL, 0x0003e4000c80043fULL,
0x000000ffff0d7224ULL, 0x002fe200078e005eULL, 0x000000750400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffaba000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff137807ULL, 0x008fe20004000000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x0001361000347802ULL, 0x000fc40000000f00ULL,
0x00000f4000007944ULL, 0x002fea0003c00000ULL, 0xfffeedd000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x000fe20005000000ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x0001366000347802ULL, 0x000fc40000000f00ULL, 0x00000ef000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0013ULL, 0xfffeee0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0012ULL, 0x000136d000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000e3000007944ULL, 0x002fea0003c00000ULL, 0xfffeeec000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0012ULL, 0x0001373000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000dd000007944ULL, 0x002fea0003c00000ULL, 0xfffeefc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0003ULL, 0x000137a000357802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fe400078e0004ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000d6000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0013ULL, 0xfffef3b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0003ULL, 0x0001381000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000cf000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0013ULL,
0xfffef37000007947ULL, 0x000fea000383ffffULL, 0x00000001ff137807ULL, 0x008fe20004000000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x0001387000347802ULL, 0x000fc40000000f00ULL,
0x00000ce000007944ULL, 0x002fea0003c00000ULL, 0xffff127000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x000fe20005000000ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x000138c000347802ULL, 0x000fc40000000f00ULL, 0x00000c9000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0013ULL, 0xffff12a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0038ULL, 0x0001393000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000bd000007944ULL, 0x002fea0003c00000ULL, 0xffff136000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0038ULL, 0x0001399000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000b7000007944ULL, 0x002fea0003c00000ULL, 0xffff146000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e000eULL, 0x00013a0000357802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fe400078e000fULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x00000b0000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0013ULL, 0xffff186000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e000eULL, 0x00013a7000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x00000a9000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0013ULL,
0xffff182000007947ULL, 0x000fea000383ffffULL, 0x00000001ff137807ULL, 0x008fe20004000000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x00013ad000347802ULL, 0x000fc40000000f00ULL,
0x00000a8000007944ULL, 0x002fea0003c00000ULL, 0xffff36c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x000fe20005000000ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x00013b2000347802ULL, 0x000fc40000000f00ULL, 0x00000a3000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e0013ULL, 0xffff36f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e003cULL, 0x00013b9000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000097000007944ULL, 0x002fea0003c00000ULL, 0xffff37c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e003cULL, 0x00013bf000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000091000007944ULL, 0x002fea0003c00000ULL, 0xffff38c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0008ULL, 0x00013c6000357802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fe400078e0023ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x000008a000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0013ULL, 0xffff3cc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0008ULL, 0x00013cd000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000083000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0013ULL,
0xffff3c8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff137807ULL, 0x004fe20004000000ULL,
0xffffffffff357424ULL, 0x000fe200078e00ffULL, 0x00013d3000347802ULL, 0x000fc40000000f00ULL,
0x0000082000007944ULL, 0x008fea0003c00000ULL, 0xffff5a7000007947ULL, 0x000fea000383ffffULL,
0x00000001ff137807ULL, 0x000fe20005000000ULL, 0xffffffffff357424ULL, 0x000fe200078e00ffULL,
0x00013d8000347802ULL, 0x000fc40000000f00ULL, 0x000007d000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e0013ULL, 0xffff5ab000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0002ULL, 0x00013df000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x0000071000007944ULL, 0x008fea0003c00000ULL, 0xffff5b7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0002ULL, 0x00013e5000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fe400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x000006b000007944ULL, 0x00afea0003c00000ULL, 0xffff5c7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0009ULL, 0x00013ec000357802ULL, 0x000fe20000000f00ULL,
0x000000ffff137224ULL, 0x000fe400078e0020ULL, 0x0000001fff377424ULL, 0x000fe400078e00ffULL,
0xffffffffff367424ULL, 0x000fc400078e00ffULL, 0x0000064000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0013ULL, 0xffff60b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff347224ULL, 0x000fe200078e0009ULL, 0x00013f3000357802ULL, 0x000fe20000000f00ULL,
0x0000001fff377424ULL, 0x000fc400078e00ffULL, 0xffffffffff367424ULL, 0x000fc400078e00ffULL,
0x000005d000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0013ULL,
0xffff607000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0e7424ULL, 0x000fe200078e00ffULL,
0x00013fa000067802ULL, 0x000fe20000000f00ULL, 0x0000001fff0c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff357424ULL, 0x000fc400078e00ffULL, 0x0000052000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e000cULL, 0xffffe8f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0d7224ULL, 0x006fe200078e000fULL, 0x0001402000067802ULL, 0x000fe20000000f00ULL,
0x00000002ff0e7424ULL, 0x000fe400078e00ffULL, 0x0000001fff0c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff357424ULL, 0x000fc400078e00ffULL, 0x000004a000007944ULL, 0x000fea0003c00000ULL,
0x0000000c0f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0d7224ULL, 0x002fe200078e000aULL,
0x000140a000067802ULL, 0x000fe20000000f00ULL, 0x00000002ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000000f0c097208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff357424ULL, 0x000fc400078e00ffULL, 0x0000042000007944ULL, 0x000fea0003c00000ULL,
0x0000000c0a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0d7224ULL, 0x002fe200078e000bULL,
0x0001412000067802ULL, 0x000fe20000000f00ULL, 0x00000002ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000000a0c0f7208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff357424ULL, 0x000fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x0000000c0b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0d7224ULL, 0x002fe200078e0011ULL,
0x000141a000067802ULL, 0x000fe20000000f00ULL, 0x00000001ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000000b0c057208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff357424ULL, 0x000fc400078e00ffULL, 0x0000032000007944ULL, 0x000fea0003c00000ULL,
0x0000000c1100720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0d7224ULL, 0x002fe200078e0009ULL,
0x0001422000067802ULL, 0x000fe20000000f00ULL, 0x00000001ff0e7424ULL, 0x000fe200078e00ffULL,
0x000000110c087208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff357424ULL, 0x000fc400078e00ffULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x0000000c0900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0d7224ULL, 0x002fe200078e000fULL,
0x000142a000067802ULL, 0x000fe20000000f00ULL, 0x00000001ff0e7424ULL, 0x000fe200078e00ffULL,
0x000000090c097208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff357424ULL, 0x000fc400078e00ffULL, 0x0000022000007944ULL, 0x000fea0003c00000ULL,
0x0000000c0f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0d7224ULL, 0x002fe200078e0005ULL,
0x0001432000067802ULL, 0x000fe20000000f00ULL, 0x00000001ff0e7424ULL, 0x000fe200078e00ffULL,
0x0000000f0c0a7208ULL, 0x000fe20004000000ULL, 0x0000001fff0c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff357424ULL, 0x000fc400078e00ffULL, 0x000001a000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000cULL, 0xffffe6d000007947ULL, 0x000fea000383ffffULL,
0x0180000011007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000001100008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff11ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000011027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000001100007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffebb4002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff077424ULL, 0x000fe200078e00ffULL, 0x0000003500007348ULL, 0x000fe80003800000ULL,
0x0c00000e0d0c7389ULL, 0x0002a200000e000cULL, 0xfffebb0006007950ULL, 0x000fea0003c3ffffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0000001334137389ULL, 0x0002a400000e0037ULL,
0x000000ffff347224ULL, 0x002fc400078e0035ULL, 0x00000000ff357424ULL, 0x000fc800078e00ffULL,
0xfffebab034007950ULL, 0x000fea0003c3ffffULL, 0x000000011300780cULL, 0x000fe20003f45070ULL,
0x0000003500007348ULL, 0x000fd80003800000ULL, 0x0000000000137806ULL, 0x000fc800050e0100ULL,
0x0000003513137212ULL, 0x000fe200078ec0ffULL, 0x00000000ff357424ULL, 0x000fc800078e00ffULL,
0xfffeba5034007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005f4ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000750ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f0ULL, 0x00000000000003f8ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000de8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ea8ULL, 0x00000000000007c0ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001668ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001678ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001708ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000000170cULL, 0x00000000000001b8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001900ULL, 0x0000000000014680ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015f80ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015fd0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000016350ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001708ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000014878ULL, 0x0000000000014878ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000015f80ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000016350ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_80_cubin_len = 91184;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
