/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000145d0ULL, 0x0000000000014250ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL,
0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL,
0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL,
0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL,
0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000030ULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000001baULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000034ULL,
0x0000000000000004ULL, 0x000c00010000028dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000002dbULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000329ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c0001000003c5ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c00010000040bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000459ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000049fULL, 0x0000000000012680ULL,
0x0000000000000180ULL, 0x000b0022000004d2ULL, 0x0000000000012800ULL, 0x0000000000000040ULL,
0x000b0022000004fdULL, 0x0000000000012840ULL, 0x0000000000000050ULL, 0x000b002200000527ULL,
0x0000000000012890ULL, 0x0000000000000170ULL, 0x000a000300000595ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005b5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005e5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000012a00ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001268000000000ULL,
0x0000040400000000ULL, 0x810c000001640400ULL, 0x0048300400288080ULL, 0x0000000000000000ULL,
0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x9208288080820828ULL, 0x2880809308288080ULL,
0x80bd082880809408ULL, 0x1628808084082880ULL, 0x0000031028808280ULL, 0x8492000000000000ULL,
0x0000002200288080ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x0001268000000000ULL,
0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL, 0x0900000010042880ULL,
0x2880808228808084ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880809208288080ULL, 0x8094082880809308ULL, 0x08288080bd082880ULL, 0x8082801628808088ULL,
0x0000000000031028ULL, 0x2880808892000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x0000011800000000ULL, 0x0001280000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880809208288080ULL,
0x8094082880809308ULL, 0x16288080bd082880ULL, 0x0000031028808280ULL, 0xbd92000000000000ULL,
0x0000002200288080ULL, 0x0000002cffffffffULL, 0x000001b000000000ULL, 0x0001284000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8092288080bd0900ULL, 0x0000000000002880ULL,
0x0000005cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880809208288080ULL,
0x80bd082880809408ULL, 0x1628808093082880ULL, 0x0000031028808280ULL, 0x9392000000000000ULL,
0x0000002200288080ULL, 0x0000002cffffffffULL, 0x0000025000000000ULL, 0x0001289000000000ULL,
0x0000017000000000ULL, 0x0000080400000000ULL, 0x8092288080930900ULL, 0x0000000000002880ULL,
0x0000001b00082f04ULL, 0x000823040000007fULL, 0x0000000000000017ULL, 0x0000001700081204ULL,
0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x000000000000001bULL, 0x0000001b00081204ULL, 0x0008110400000000ULL, 0x000000000000001bULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0058016000000018ULL, 0x000c170400581903ULL,
0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL, 0x000c17040021f000ULL,
0x0040000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040061f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0x0000090000043104ULL, 0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0000044001342804ULL, 0x0000058000000470ULL, 0x00002490000023e0ULL, 0x00002710000025b0ULL,
0x00002bb000002b80ULL, 0x00002c5000002c00ULL, 0x00004b4000004ab0ULL, 0x00004dc000004c60ULL,
0x0000527000005240ULL, 0x00005310000052c0ULL, 0x0000721000007170ULL, 0x000074a000007340ULL,
0x0000795000007920ULL, 0x000079f0000079a0ULL, 0x000097f000009750ULL, 0x00009a7000009910ULL,
0x00009f6000009f30ULL, 0x0000a00000009fb0ULL, 0x0000b2400000b230ULL, 0x00010fc000010f80ULL,
0x00010fe000010fd0ULL, 0x0001105000011030ULL, 0x0001108000011070ULL, 0x00011d0000011cc0ULL,
0x00011d9000011d50ULL, 0x00011e3000011de0ULL, 0x00011ec000011e80ULL, 0x00011f5000011f10ULL,
0x00011ff000011fa0ULL, 0x0001208000012040ULL, 0x00012110000120d0ULL, 0x000121b000012160ULL,
0x0001224000012200ULL, 0x000122d000012290ULL, 0x0001237000012320ULL, 0x00012420000123c0ULL,
0x000124e000012480ULL, 0x000125a000012540ULL, 0x0001266000012600ULL, 0x000003d004403904ULL,
0x0000f600000000ffULL, 0x000004a0003f0100ULL, 0x0000f6080000000bULL, 0x000004c0003f0120ULL,
0x0000f6880000000bULL, 0x000004e0003f0120ULL, 0x0000f6a80000000bULL, 0x00000540003f0120ULL,
0x0000f6c80000000bULL, 0x00000910003f0120ULL, 0x0000f600000000ffULL, 0x00000a70003f0107ULL,
0x0000f68c0000000bULL, 0x00000b00003f0102ULL, 0x0000f6880000000bULL, 0x00001330003f0101ULL,
0x00000000000000ffULL, 0x000013b000040107ULL, 0x00000000000000ffULL, 0x0000141000040101ULL,
0x0000002000000006ULL, 0x00001570003f0101ULL, 0x0000f6cc0000000cULL, 0x00001750003f0105ULL,
0x0000f6cc0000000cULL, 0x00001fa0003f0105ULL, 0x0000f6b000000010ULL, 0x00002040003f0107ULL,
0x0000f6b000000010ULL, 0x000020a0003f0101ULL, 0x0000f6080000001eULL, 0x000020e0003f0101ULL,
0x0000f60c00000008ULL, 0x000022c0003f0105ULL, 0x0000f60c00000008ULL, 0x000028e0003f0105ULL,
0x0000f6ac0000001fULL, 0x00002ab0003f0105ULL, 0x0000f6ac0000001fULL, 0x00003d20003f0105ULL,
0x0000000000000032ULL, 0x00003d80003f0101ULL, 0x0000f6880000000dULL, 0x00003db0003f0101ULL,
0x0000000400000009ULL, 0x00003f70003f0105ULL, 0x0000000400000009ULL, 0x000046c0003f0105ULL,
0x00000000000000ffULL, 0x0000479000040107ULL, 0x00000000000000ffULL, 0x000047f000040101ULL,
0x0000f6280000000dULL, 0x00004810003f0101ULL, 0x0000f62c00000008ULL, 0x000049e0003f0105ULL,
0x0000f62c00000008ULL, 0x00004fa0003f0105ULL, 0x0000f6b400000034ULL, 0x00005170003f0105ULL,
0x0000f6b400000034ULL, 0x000063d0003f0105ULL, 0x0000000000000012ULL, 0x00006430003f0101ULL,
0x0000f69000000067ULL, 0x00006460003f0101ULL, 0x0000000400000009ULL, 0x00006620003f0105ULL,
0x0000000400000009ULL, 0x00006d80003f0105ULL, 0x00000008000000ffULL, 0x00006e1000040107ULL,
0x0000f6b000000020ULL, 0x00006e70003f0101ULL, 0x0000f64800000008ULL, 0x00006ed0003f0101ULL,
0x0000f64c00000008ULL, 0x000070a0003f0105ULL, 0x0000f64c00000008ULL, 0x00007680003f0105ULL,
0x0000f6ac00000032ULL, 0x00007850003f0105ULL, 0x0000f6ac00000032ULL, 0x00008980003f0105ULL,
0x0000000000000009ULL, 0x000089e0003f0101ULL, 0x0000000000000004ULL, 0x00008a10003f0101ULL,
0x0000000400000009ULL, 0x00008bd0003f0105ULL, 0x0000000400000009ULL, 0x00009370003f0105ULL,
0x00000000000000ffULL, 0x0000944000040107ULL, 0x00000000000000ffULL, 0x000094a000040101ULL,
0x0000f6680000000dULL, 0x000094d0003f0101ULL, 0x0000f66c0000000dULL, 0x000096a0003f0105ULL,
0x0000f66c0000000dULL, 0x00009c50003f0105ULL, 0x0000f6b400000034ULL, 0x00009e50003f0105ULL,
0x0000f6b400000034ULL, 0x0000b000003f0105ULL, 0x0000000000000009ULL, 0x0000b080003f0101ULL,
0x000000000000000cULL, 0x0000c140003f0101ULL, 0x0000f600000000ffULL, 0x0000ccf0003f0101ULL,
0x0000f604000000ffULL, 0x0000cec0003f0105ULL, 0x0000f604000000ffULL, 0x0000d0f0003f0105ULL,
0x0000f600000000ffULL, 0x0000d120003f0101ULL, 0x0000f604000000ffULL, 0x0000d2e0003f0105ULL,
0x0000f604000000ffULL, 0x0000f510003f0105ULL, 0x0000000000000072ULL, 0x0000f570003f0101ULL,
0x0000000400000072ULL, 0x0000f740003f0105ULL, 0x0000000400000072ULL, 0x00011b20003f0105ULL,
0x0000000000000074ULL, 0x00011b80003f0101ULL, 0x0000000800000074ULL, 0x00011be0003f0101ULL,
0x0000001000000074ULL, 0x00011c50003f0101ULL, 0x0000001800000074ULL, 0x00053803003f0101ULL,
0x0000ba9000201c04ULL, 0x0000bca00000bac0ULL, 0x0000bf900000be00ULL, 0x0000d3400000c090ULL,
0x0000040100011c90ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x00000000000002ccULL, 0x0000001b00000002ULL,
0x000000000000022cULL, 0x0000001b00000002ULL, 0x000000000000019cULL, 0x0000001b00000002ULL,
0x00000000000000ecULL, 0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL,
0x00000000000002a6ULL, 0x0000001b00000002ULL, 0x0000000000000206ULL, 0x0000001b00000002ULL,
0x0000000000000173ULL, 0x0000001b00000002ULL, 0x00000000000000c6ULL, 0x0000001b00000002ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff6f7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000747919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000a7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a006f797a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000f280000002100ULL,
0x00000000000c7919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000040003077a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a07ULL,
0x0000040003007624ULL, 0x000fca00078e026fULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff07aa12ULL, 0x000fc800078e33ffULL, 0x0000000700007306ULL, 0x000e620000209000ULL,
0x000000ff0700720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000307047224ULL, 0x004fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000007403727227ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000ee40000002200ULL,
0x000000ffff007224ULL, 0x000fc800078e0a72ULL, 0x0000000007007224ULL, 0x000fca00078e0274ULL,
0x000000070000720cULL, 0x000fda0003f66070ULL, 0x0000000100003824ULL, 0x000fe200078e0a07ULL,
0x0000000172723810ULL, 0x000fe20007ffe0ffULL, 0x000001000a027a24ULL, 0x008fc600078e0203ULL,
0x000000070000720cULL, 0x000fe20003f86070ULL, 0x00000000020b7a24ULL, 0x010fca00078e0209ULL,
0x000000ff0b00720cULL, 0x040fe40003f45270ULL, 0x0000007f0b00780cULL, 0x040fe40003f04070ULL,
0x0000000f0b00780cULL, 0x040fe40003f24070ULL, 0x000000030b00780cULL, 0x000fe40003f64070ULL,
0x0000000172724810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff72d212ULL, 0x000fc400078e33ffULL,
0x000000010b00780cULL, 0x000fe20003f84070ULL, 0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL,
0x000000ffff007224ULL, 0x000fe400078e0a72ULL, 0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL,
0x0000000007747224ULL, 0x000fe200078e0274ULL, 0x00000005ff007819ULL, 0x000fe20000011609ULL,
0xff317217ff088424ULL, 0x000fe200078e00ffULL, 0x00f60002ff00a388ULL, 0x0003e20000000a00ULL,
0x00000010746d7824ULL, 0x000fc400078e00ffULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x00f400080b008388ULL, 0x0005e20000004800ULL, 0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL,
0x000000046d007c0cULL, 0x040fe2000bf03070ULL, 0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL,
0x00001fff0a097589ULL, 0x000fe200000e0000ULL, 0x7fffff60ff07b424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff02b424ULL, 0x002fe200078e00ffULL, 0x00001fff00007589ULL, 0x000e6200000e0000ULL,
0x7fffff80ff03b424ULL, 0x000fe200078e00ffULL, 0x000000046d087c10ULL, 0x004fc4000fffe1ffULL,
0x00f608040b009388ULL, 0x0005e40000008a00ULL, 0x0000001008087817ULL, 0x000fe40003800000ULL,
0x00f688060b00b388ULL, 0x0007e40000008a00ULL, 0x000000ff08737207ULL, 0x000fe40000000000ULL,
0x00f6a8020b00b388ULL, 0x0003e20000008a00ULL, 0x00005a0072087a19ULL, 0x000fe400000006ffULL,
0x000000107300780cULL, 0x000fe20003f05270ULL, 0x3fffffc0ff04c424ULL, 0x004fc400078e00ffULL,
0x7fffffc0ff05c424ULL, 0x000fe400078e00ffULL, 0x000058000c067a24ULL, 0x008fc600078e02ffULL,
0x00f6c8040b00c388ULL, 0x0005e20000008a00ULL, 0x0000000409027824ULL, 0x002fe400078e0200ULL,
0x0000007906067224ULL, 0x000fe400078e0208ULL, 0x0000000202047824ULL, 0x004fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000001d000008947ULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fc40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x00000004ff077819ULL, 0x002fca0000011602ULL, 0x0000000104087824ULL, 0x000fc800078e0207ULL,
0x000000016d037824ULL, 0x000fca00078e0208ULL, 0x0000000403057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff0a7a19ULL, 0x000fe20000011603ULL, 0x0000001002037824ULL, 0x000fe400078e00ffULL,
0x0000000106067824ULL, 0x000fe200078e0205ULL, 0x0000000473057217ULL, 0x000fe40007800000ULL,
0x000000f0030b7812ULL, 0x000fe200078ec0ffULL, 0x000000790a0a7224ULL, 0x000fe400078e0206ULL,
0x0000000105067824ULL, 0x000fc400078e0a04ULL, 0x000001000a047825ULL, 0x000fc600078e00ffULL,
0x000000060700720cULL, 0x000fe20003f06070ULL, 0x0000000108067824ULL, 0x000fe200078e0202ULL,
0x0000000b040b7212ULL, 0x000fe200078efcffULL, 0x0000001008077824ULL, 0x000fc600078e00ffULL,
0x00005e000b047a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff007067812ULL, 0x000fe400078ee206ULL,
0x00005f0005057a10ULL, 0x000fc60000ffe4ffULL, 0x0000001006077824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e2000c101c48ULL,
0x0000018000007947ULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x0000000402077211ULL, 0x002fca00078fe0ffULL,
0x000000016d037824ULL, 0x000fca00078e0207ULL, 0x0000000403057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fe20000011603ULL, 0x0000001002037824ULL, 0x000fe400078e00ffULL,
0x0000000106057824ULL, 0x000fe400078e0205ULL, 0x0000000107067824ULL, 0x000fe200078e0202ULL,
0x000000f0030b7812ULL, 0x000fe200078ec0ffULL, 0x0000007904047224ULL, 0x000fe400078e0205ULL,
0x0000001007077824ULL, 0x000fc400078e00ffULL, 0x0000010004047825ULL, 0x000fc600078e00ffULL,
0xfffffff007067812ULL, 0x000fe400078ee206ULL, 0x0000000b04047212ULL, 0x000fc600078efcffULL,
0x0000001006077824ULL, 0x000fe200078e00ffULL, 0x00005e0004047a10ULL, 0x000fc80007f1e0ffULL,
0x00005f0005057a10ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e8000b901c48ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000067806ULL, 0x000fc600038e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000600047300ULL, 0x000e7000000e0000ULL, 0x0000000600077309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe20003f02070ULL, 0x00000004ff057424ULL, 0x000fc400078e00ffULL,
0x000000ffff077224ULL, 0x004fe400078e0a07ULL, 0x000064000c047625ULL, 0x000fd000078e0005ULL,
0x00f60407ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000804627981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe40003f05270ULL, 0x000000ff62067810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff637819ULL, 0x000fce0000011606ULL, 0x0000b66000008947ULL, 0x000fea0003800000ULL,
0x00000008000b7824ULL, 0x000fe400078e00ffULL, 0x00000003ff047424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f68c040bff738cULL, 0x0005e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0600780cULL, 0x000fe20003f04070ULL,
0x000000020c047824ULL, 0x004fe200078e00ffULL, 0x00000001ff587819ULL, 0x000fe20000011600ULL,
0x00f688000bff7f8cULL, 0x0005e2000c80043fULL, 0x00000001006d7812ULL, 0x000fe200078ec0ffULL,
0x00005900046f7624ULL, 0x000fe400078e026fULL, 0x0000002058757824ULL, 0x000fc400078e00ffULL,
0x00000001726f7824ULL, 0x000fc800078e026fULL, 0x000066006f067a24ULL, 0x000fe200078e0275ULL,
0x000003e000000947ULL, 0x000fea0003800000ULL, 0x0000007562047217ULL, 0x004fe20007800000ULL,
0x000000106d057824ULL, 0x000fe200078e00ffULL, 0x00000003ff077819ULL, 0x002fc60000011602ULL,
0x0000000104047824ULL, 0x000fe200078e0a75ULL, 0x00000004070c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105097824ULL, 0x000fe200078e0207ULL, 0x0000000c070e7810ULL, 0x000fe40007ffe0ffULL,
0x0000000504047217ULL, 0x000fe20007800000ULL, 0x0000000109087824ULL, 0x040fe400078e0202ULL,
0x00000008090d7824ULL, 0x000fe400078e00ffULL, 0x0000000104047824ULL, 0x000fc400078e0a05ULL,
0x0000000106097824ULL, 0x000fe200078e0209ULL, 0xfffffff80d0a7812ULL, 0x000fe200078ee208ULL,
0x00000001050f7824ULL, 0x000fe200078e020eULL, 0x0000000807087810ULL, 0x040fe40007ffe0ffULL,
0x000000040700720cULL, 0x080fe20003f66070ULL, 0x0000000105077824ULL, 0x040fe200078e020cULL,
0x000000040c00720cULL, 0x080fe20003f46070ULL, 0x00000001050d7824ULL, 0x000fe200078e0208ULL,
0x000000040800720cULL, 0x080fe20003f26070ULL, 0x0000000106087824ULL, 0x000fe200078e0207ULL,
0x000000040e00720cULL, 0x000fe20003f06070ULL, 0x0000008009047825ULL, 0x000fc800078e00ffULL,
0x0000000107097824ULL, 0x140fe200078e0202ULL, 0x00000070040c7812ULL, 0x000fe200078ef803ULL,
0x00000008070e7824ULL, 0x000fe400078e00ffULL, 0x0000000106077824ULL, 0x000fe200078e020dULL,
0x000062000c0c7a10ULL, 0x000fe20007f9e0ffULL, 0x0000000106117824ULL, 0x000fe200078e020fULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL, 0x000000010d067824ULL, 0x040fe400078e0202ULL,
0x000000080d0d7824ULL, 0x000fc400078e00ffULL, 0x000000010f047824ULL, 0x040fe400078e0202ULL,
0x000000080f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff80d107812ULL, 0x000fe200078ee206ULL,
0x0000008007067825ULL, 0x000fe200078e00ffULL, 0x00006300050d7a10ULL, 0x000fe400027fe4ffULL,
0xfffffff80f127812ULL, 0x000fe200078ee204ULL, 0x0000008008047825ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x100fe400078ef803ULL, 0x0000b000580f7811ULL, 0x000fe200078e68ffULL,
0x0000008011087825ULL, 0x000fe200078e00ffULL, 0x0000007004047812ULL, 0x000fc400078ef803ULL,
0x0000620006067a10ULL, 0x000fe20007fbe0ffULL, 0x000000100a117824ULL, 0x000fe200078e020fULL,
0x0000007008087812ULL, 0x000fe200078ef803ULL, 0x000000100e137824ULL, 0x100fe200078e020fULL,
0x0000620004047a10ULL, 0x000fe20007f9e0ffULL, 0x0000001010037824ULL, 0x100fe200078e020fULL,
0x0000620008087a10ULL, 0x000fe20007fde0ffULL, 0x00000010120f7824ULL, 0x000fe200078e020fULL,
0x0000630005057a10ULL, 0x000fe200027fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c117faeULL, 0x0003e2000d901c48ULL, 0x0000630007077a10ULL, 0x000fc40002ffe4ffULL,
0x0000630009097a10ULL, 0x000fe200037fe4ffULL, 0x0000000004137faeULL, 0x0003e8000d101c48ULL,
0x0000000006037faeULL, 0x0003e8000c901c48ULL, 0x00000000080f7faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x000000106d057824ULL, 0x004fca00078e00ffULL,
0x0000000502057211ULL, 0x000fc800078fe8ffULL, 0x0000000405097810ULL, 0x040fe20007ffe0ffULL,
0x0000000106047824ULL, 0x000fe200078e0205ULL, 0x00000008050d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000105077824ULL, 0x042fe200078e0202ULL, 0x0000000c050f7810ULL, 0x040fe20007ffe0ffULL,
0x00000008050a7824ULL, 0x000fe400078e00ffULL, 0x0000008004047825ULL, 0x000fc600078e00ffULL,
0xfffffff80a0a7812ULL, 0x000fe200078ee207ULL, 0x0000000106077824ULL, 0x000fe200078e0209ULL,
0x00000070040c7812ULL, 0x000fe200078ef803ULL, 0x0000000109087824ULL, 0x040fe400078e0202ULL,
0x0000000809137824ULL, 0x000fe200078e00ffULL, 0x000062000c0c7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000106097824ULL, 0x040fe400078e020dULL, 0x0000000106117824ULL, 0x000fe200078e020fULL,
0xfffffff8130e7812ULL, 0x000fe200078ee208ULL, 0x000000010d067824ULL, 0x040fe200078e0202ULL,
0x0000b00058137811ULL, 0x000fe200078e68ffULL, 0x000000080d0d7824ULL, 0x000fc400078e00ffULL,
0x000000010f047824ULL, 0x040fe400078e0202ULL, 0x000000080f0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80d107812ULL, 0x000fe400078ee206ULL, 0x00006300050d7a10ULL, 0x000fe400007fe4ffULL,
0xfffffff80f127812ULL, 0x000fe200078ee204ULL, 0x0000008007047825ULL, 0x000fc800078e00ffULL,
0x0000008009067825ULL, 0x000fe200078e00ffULL, 0x0000007004047812ULL, 0x000fc600078ef803ULL,
0x0000008011087825ULL, 0x000fe200078e00ffULL, 0x0000007006067812ULL, 0x000fe400078ef803ULL,
0x0000620004047a10ULL, 0x000fe20007f1e0ffULL, 0x000000100a0f7824ULL, 0x000fe200078e0213ULL,
0x0000007008087812ULL, 0x000fe200078ef803ULL, 0x000000100e117824ULL, 0x100fe200078e0213ULL,
0x0000620006067a10ULL, 0x000fe20007f3e0ffULL, 0x0000001010037824ULL, 0x100fe200078e0213ULL,
0x0000620008087a10ULL, 0x000fe20007f5e0ffULL, 0x0000001012137824ULL, 0x000fe200078e0213ULL,
0x0000630005057a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c0f7faeULL, 0x0003e2000b901c48ULL, 0x0000630007077a10ULL, 0x000fc40000ffe4ffULL,
0x0000630009097a10ULL, 0x000fe200017fe4ffULL, 0x0000000004117faeULL, 0x0003e8000b901c48ULL,
0x0000000006037faeULL, 0x0003e8000b901c48ULL, 0x0000000008137faeULL, 0x0003e4000b901c48ULL,
0x00000000580473c2ULL, 0x000ea200000e0000ULL, 0x000000ff6300720cULL, 0x000fe20003f05270ULL,
0x000000ffff0f7224ULL, 0x002fe200078e00ffULL, 0x0000f6a858067811ULL, 0x000fe200078e18ffULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x0000f6a804047891ULL, 0x004fd2000f8e203fULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff047f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200006067f8cULL, 0x000ea2000c80043fULL,
0x000000ffff247224ULL, 0x000fe200078e00ffULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00009c0000008947ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x002fe200078e0005ULL, 0x00000002ff717819ULL, 0x000fe20000011600ULL,
0x000000ffff037224ULL, 0x004fc400078e0007ULL, 0xff317217ff0d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0a7224ULL, 0x000fe400078e00ffULL, 0x000000ffff337224ULL, 0x000fc400078e00ffULL,
0x000000ffff127224ULL, 0x024fca00078e00ffULL, 0x0000000000107805ULL, 0x000fc40000015200ULL,
0x0000000400087824ULL, 0x000fca00078e00ffULL, 0xfffffff8080c7812ULL, 0x000fc800078ec0ffULL,
0x0000f6c80c0e7810ULL, 0x000fe20007ffe0ffULL, 0x00f6cc000c087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000021000007945ULL, 0x000fe20003800000ULL, 0x000000ffff097224ULL, 0x000fe200078e000eULL,
0x000001e000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000810137210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e11ULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011409ULL,
0x0000001308087211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000208087819ULL, 0x000fc80000001209ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc000c087984ULL, 0x000e640000000800ULL,
0x8000000008ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff097224ULL, 0x000fc400078e000eULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010a087810ULL, 0x040fe20007ffe0ffULL, 0x000001000a4c7824ULL, 0x000fc600078e0275ULL,
0x000000630800720cULL, 0x000fe40003f26070ULL, 0x000000404c087810ULL, 0x000fca0007ffe0ffULL,
0x000066006f1e7a24ULL, 0x000fcc00078e0208ULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x0000000862037217ULL, 0x000fe20007800000ULL, 0x000000106d0c7824ULL, 0x000fe200078e00ffULL,
0x00000003ff0e7819ULL, 0x000fc60000011602ULL, 0x0000000103037824ULL, 0x000fe200078e0a08ULL,
0x000000040e107810ULL, 0x000fe20007ffe0ffULL, 0x000000010c117824ULL, 0x000fe200078e020eULL,
0x0000000c0e127810ULL, 0x000fe40007ffe0ffULL, 0x000000030c037217ULL, 0x000fe20007800000ULL,
0x0000000111087824ULL, 0x040fe400078e0202ULL, 0x0000000811137824ULL, 0x000fe400078e00ffULL,
0x0000000103037824ULL, 0x000fc400078e0a0cULL, 0x000000010c1f7824ULL, 0x040fe200078e0212ULL,
0xfffffff813287812ULL, 0x000fe200078ee208ULL, 0x000000010c137824ULL, 0x000fe200078e0210ULL,
0x000000031000720cULL, 0x080fe20003f66070ULL, 0x0000001002087824ULL, 0x000fe200078e00ffULL,
0x000000080e107810ULL, 0x040fe20007ffe0ffULL, 0x0000000813297824ULL, 0x040fe200078e00ffULL,
0x000000030e00720cULL, 0x080fe20003f86070ULL, 0x00000001130e7824ULL, 0x000fe200078e0202ULL,
0x000000031000720cULL, 0x080fe20003f46070ULL, 0x000000010c1d7824ULL, 0x000fe200078e0210ULL,
0x000000031200720cULL, 0x000fe20003f06070ULL, 0x0000000111107824ULL, 0x000fe200078e021eULL,
0xfffffff8290e7812ULL, 0x000fe200078ee20eULL, 0x0000000113127824ULL, 0x100fe200078e021eULL,
0x0000007008297812ULL, 0x000fe200078ec0ffULL, 0x000000011d1c7824ULL, 0x000fc400078e021eULL,
0x000000011f1e7824ULL, 0x040fe400078e021eULL, 0x000000011f0c7824ULL, 0x000fe400078e0202ULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x000000081f1f7824ULL, 0x000fe200078e00ffULL,
0x0000002910107212ULL, 0x000fe200078efcffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff81f0c7812ULL, 0x000fe200078ee20cULL, 0x000000011d037824ULL, 0x040fe200078e0202ULL,
0x0000002912127212ULL, 0x080fe200078efcffULL, 0x000000081d087824ULL, 0x000fe200078e00ffULL,
0x0000620010107a10ULL, 0x000fe20007fbe0ffULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x0000620012127a10ULL, 0x000fe40007fde0ffULL, 0xfffffff808087812ULL, 0x000fe200078ee203ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000000291c1c7212ULL, 0x000fc400078efcffULL,
0x0000c00058037811ULL, 0x000fe400078e68ffULL, 0x000000291e1e7212ULL, 0x000fe400078efcffULL,
0x0000630011117a10ULL, 0x000fe20002ffe4ffULL, 0x0000001028297824ULL, 0x100fe200078e0203ULL,
0x0000630013137a10ULL, 0x000fe200037fe4ffULL, 0x000000100e2b7824ULL, 0x100fe200078e0203ULL,
0x000062001c1c7a10ULL, 0x000fe20007fbe0ffULL, 0x00000010083d7824ULL, 0x100fe200078e0203ULL,
0x000062001e1e7a10ULL, 0x000fe20007fde0ffULL, 0x000000100c037824ULL, 0x000fe200078e0203ULL,
0x000063001d1d7a10ULL, 0x000fe20002ffe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010297faeULL, 0x0003e2000e101c48ULL, 0x000063001f1f7a10ULL, 0x000fc600037fe4ffULL,
0x00000000122b7faeULL, 0x0003e8000d901c48ULL, 0x000000001c3d7faeULL, 0x0003e8000d101c48ULL,
0x000000001e037faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x000000106d037824ULL, 0x000fe200078e00ffULL, 0x0000c000583d7811ULL, 0x000fe200078e68ffULL,
0x0000001002087824ULL, 0x000fc600078e00ffULL, 0x0000000302037211ULL, 0x000fe400078fe8ffULL,
0x00000070082b7812ULL, 0x000fe400078ec0ffULL, 0x0000000403137810ULL, 0x040fe20007ffe0ffULL,
0x00000001030c7824ULL, 0x040fe200078e0202ULL, 0x00000008031d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000803117824ULL, 0x040fe200078e00ffULL, 0x0000000c031f7810ULL, 0x040fe20007ffe0ffULL,
0x0000000103107824ULL, 0x100fe400078e021eULL, 0x0000000113127824ULL, 0x000fe200078e021eULL,
0xfffffff8110c7812ULL, 0x000fe200078ee20cULL, 0x0000000113037824ULL, 0x000fc400078e0202ULL,
0x0000000813087824ULL, 0x000fe400078e00ffULL, 0x000000011d1c7824ULL, 0x040fe400078e021eULL,
0x000000011d0e7824ULL, 0x100fe200078e0202ULL, 0xfffffff808087812ULL, 0x000fe200078ee203ULL,
0x000000011f137824ULL, 0x040fe400078e0202ULL, 0x000000081f287824ULL, 0x000fe400078e00ffULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff828287812ULL, 0x000fe200078ee213ULL,
0x000000081d1d7824ULL, 0x000fe200078e00ffULL, 0x0000002b10107212ULL, 0x080fe200078efcffULL,
0x000000011f1e7824ULL, 0x000fe400078e021eULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0xfffffff81d0e7812ULL, 0x000fe400078ee20eULL, 0x0000620010107a10ULL, 0x000fe20007f1e0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000002b12127212ULL, 0x000fc400078efcffULL,
0x0000630011117a10ULL, 0x000fe200007fe4ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000002b1c1c7212ULL, 0x080fe400078efcffULL, 0x0000620012127a10ULL, 0x000fe20007f1e0ffULL,
0x000000100c037824ULL, 0x100fe200078e023dULL, 0x0000002b1e1e7212ULL, 0x000fe200078efcffULL,
0x0000001008297824ULL, 0x100fe200078e023dULL, 0x000062001c1c7a10ULL, 0x000fe20007f5e0ffULL,
0x000000100e2b7824ULL, 0x100fe200078e023dULL, 0x000062001e1e7a10ULL, 0x000fe20007f7e0ffULL,
0x00000010283d7824ULL, 0x000fe200078e023dULL, 0x0000630013137a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010037faeULL, 0x0003e2000b901c48ULL,
0x000063001d1d7a10ULL, 0x000fc400017fe4ffULL, 0x000063001f1f7a10ULL, 0x000fe20001ffe4ffULL,
0x0000000012297faeULL, 0x0003e8000b901c48ULL, 0x000000001c2b7faeULL, 0x0003e8000b901c48ULL,
0x000000001e3d7faeULL, 0x0003e4000b901c48ULL, 0xfffffff00b107812ULL, 0x042fe400078ec0ffULL,
0xffffffe00b037812ULL, 0x000fc400078ec0ffULL, 0x00000000100573c2ULL, 0x000e6200000e0000ULL,
0x000000100b087812ULL, 0x000fca00078ec0ffULL, 0x0000000103087824ULL, 0x000fe400078e0208ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000000086d1e7824ULL, 0x000fe200078e0208ULL,
0x0000f6b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6b00010107f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f608001e1e7f8cULL, 0x000ea4000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x000000080b037812ULL, 0x000fca00078ec0ffULL, 0x0000000108087824ULL, 0x000fca00078e0203ULL,
0x00f60c0008037984ULL, 0x000ee40000000800ULL, 0x8000000003ff7812ULL, 0x00cfe4000780481fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0e7224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c120c7210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1c7824ULL, 0x000fe200000e0e13ULL,
0x003d09000c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1c00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1c00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001141cULL, 0x0000000c03037211ULL, 0x000fca00078110ffULL,
0x000000ffff0c7224ULL, 0x000fca00000e061cULL, 0x0000000203037819ULL, 0x000fc8000000120cULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f60c0008037984ULL, 0x000ea40000000800ULL, 0x8000000003ff7812ULL, 0x004fe4000780481fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001002597824ULL, 0x000fe200078e00ffULL, 0x00000001ff6e7819ULL, 0x000fe20000011602ULL,
0x0000002000037824ULL, 0x000fe400078e00ffULL, 0xffffffffff767424ULL, 0x000fe200078e00ffULL,
0x0000007059597812ULL, 0x000fc400078ec0ffULL, 0xffffff8003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c6e6e7812ULL, 0x000fc800078ec0ffULL, 0x000000036e037210ULL, 0x000fca0007ffe059ULL,
0x00f00000030e7984ULL, 0x000ea80000000800ULL, 0x00f20000031c7984ULL, 0x0006620000000800ULL,
0x0000000d0e00720bULL, 0x004fe20003f1d000ULL, 0x0000f8c27f007947ULL, 0x000fd8000b800000ULL,
0x00000000003c7806ULL, 0x008fc800000e0100ULL, 0x0000ffff3c1e7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff037424ULL, 0x000fe400078e00ffULL,
0x000000ffff0c7224ULL, 0x000fc400078e000dULL, 0x0000001fff787424ULL, 0x000fe400078e00ffULL,
0xffffffffff777424ULL, 0x000fca00078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x000000007100720cULL, 0x000fe40003f05270ULL, 0x0000000d0e00720bULL, 0x000fe20003f54000ULL,
0x0000f8527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000037806ULL, 0x000fc400010e0100ULL,
0x0000008000138824ULL, 0x000fe200078e0259ULL, 0x0000000d0e0c7209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991003127816ULL, 0x000fe200000000ffULL,
0x000000016e138824ULL, 0x000fca00078e0213ULL, 0x00f4000c13008388ULL, 0x0005e20000000800ULL,
0x000000ff1200720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x0000000d0c0d7221ULL, 0x004fe20000010100ULL, 0x000000ff03ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fcc0000410000ULL,
0x0000000d000d7308ULL, 0x000ea40000000800ULL, 0x0000000d0f0f7220ULL, 0x004fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff127819ULL, 0x000fe20000011602ULL,
0x0000f7827f007947ULL, 0x000fea000b800000ULL, 0x00001f120d3c7589ULL, 0x0004e400000e0000ULL,
0x0000003c38387220ULL, 0x08cfe20000410000ULL, 0x0000003c39397220ULL, 0x080fe20000410000ULL,
0x0000003c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000003c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000003c14147220ULL, 0x080fe20000410000ULL, 0x0000003c15157220ULL, 0x080fe20000410000ULL,
0x0000003c34347220ULL, 0x080fe20000410000ULL, 0x0000003c35357220ULL, 0x080fe20000410000ULL,
0x0000003c24247220ULL, 0x080fe20000410000ULL, 0x0000003c25257220ULL, 0x080fe20000410000ULL,
0x0000003c20207220ULL, 0x080fe20000410000ULL, 0x0000003c21217220ULL, 0x080fe20000410000ULL,
0x0000003c18187220ULL, 0x080fe20000410000ULL, 0x0000003c19197220ULL, 0x080fe20000410000ULL,
0x0000003c30307220ULL, 0x080fe20000410000ULL, 0x0000003c31317220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0003ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802127811ULL, 0x000fe200078ff0ffULL,
0x0000f6627f007947ULL, 0x000fea000b800000ULL, 0x00001f120d3c7589ULL, 0x0004e400000e0000ULL,
0x0000003c3a3a7220ULL, 0x08cfe20000410000ULL, 0x0000003c3b3b7220ULL, 0x080fe20000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000003c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000003c16167220ULL, 0x080fe20000410000ULL, 0x0000003c17177220ULL, 0x080fe20000410000ULL,
0x0000003c36367220ULL, 0x080fe20000410000ULL, 0x0000003c37377220ULL, 0x080fe20000410000ULL,
0x0000003c26267220ULL, 0x080fe20000410000ULL, 0x0000003c27277220ULL, 0x080fe20000410000ULL,
0x0000003c22227220ULL, 0x080fe20000410000ULL, 0x0000003c23237220ULL, 0x080fe20000410000ULL,
0x0000003c1a1a7220ULL, 0x080fe20000410000ULL, 0x0000003c1b1b7220ULL, 0x080fe20000410000ULL,
0x0000003c32327220ULL, 0x080fe20000410000ULL, 0x0000003c33337220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff1eff7812ULL, 0x000fe20007806003ULL,
0x00000001ff037424ULL, 0x000fd800078e00ffULL, 0x8000000c0e0e0221ULL, 0x000fe20000010000ULL,
0x00007610ff030816ULL, 0x000fc60000000003ULL, 0x3fb8aa3b0e0e0820ULL, 0x000fc80000410000ULL,
0x0000000e00070308ULL, 0x000ea40000000800ULL, 0x000000071c1c0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000f1c0f7221ULL, 0x002fc20000010000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0xfffffff00b1f7812ULL, 0x000fca00078ec0ffULL,
0x00f6ac001f0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804804ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c120e7210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1c7824ULL, 0x000fe200000e0e13ULL, 0x003d09000e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc8000001141cULL,
0x0000000e0d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff0e7224ULL, 0x000fca00000e061cULL,
0x000000020d0d7819ULL, 0x000fc8000000120eULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac001f0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804804ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991003037816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000007ff03723eULL, 0x000fe400000000ffULL, 0x00000002ff047819ULL, 0x000fe40000011602ULL,
0x0000541003037816ULL, 0x000fe20000000003ULL, 0x0000f2327f007947ULL, 0x000fea000b800000ULL,
0x00001f0403067589ULL, 0x0002a400000e0000ULL, 0x0000000804127810ULL, 0x000fe20007ffe0ffULL,
0x0000f2627f007947ULL, 0x000fea000b800000ULL, 0x00001f1203057589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001004127810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200078e0003ULL, 0x00002c10003d7802ULL, 0x000fc40000000f00ULL,
0x0000fc3000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001804127810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200078e0003ULL,
0x00002c60003d7802ULL, 0x000fc40000000f00ULL, 0x0000fbe000007944ULL, 0x006fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000007020e7812ULL, 0x000fe200078ec0ffULL,
0x0000020000037824ULL, 0x00afe200078e00ffULL, 0x00000004ff127819ULL, 0x100fe20000011602ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000080e5b7812ULL, 0x000fc600078ef802ULL,
0x0000000458047824ULL, 0x000fe400078e0212ULL, 0x000000085b1c7824ULL, 0x040fe400078e00ffULL,
0x000000015b5f7824ULL, 0x000fe200078e0204ULL, 0xfffff80003047812ULL, 0x000fe400078ec0ffULL,
0x0000000802037812ULL, 0x000fe400078ec0ffULL, 0xfffffff81c0d7812ULL, 0x000fca00078ee25fULL,
0x000000100d3c7824ULL, 0x004fc400078e0204ULL, 0x0000000e030d7212ULL, 0x000fe200078efcffULL,
0x000000046d127824ULL, 0x000fe200078e0212ULL, 0x0000b000585d7811ULL, 0x000fe400078e68ffULL,
0x0000001003037812ULL, 0x000fe200078efe0eULL, 0x000000010d1c7824ULL, 0x040fe400078e0212ULL,
0x000000080d137824ULL, 0x000fe400078e00ffULL, 0x00000008030e7824ULL, 0x000fe400078e00ffULL,
0x000000080d1d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8131e7812ULL, 0x000fe200078ee21cULL,
0x0000000112137824ULL, 0x000fe200078e0203ULL, 0x000000021c1c7810ULL, 0x000fc60007ffe0ffULL,
0x000000101e1e7824ULL, 0x000fe200078e025dULL, 0xfffffff80e0e7812ULL, 0x000fe400078ee213ULL,
0x0000000213137810ULL, 0x000fe40007ffe0ffULL, 0x000000001e28783bULL, 0x000e620000004200ULL,
0x000000100e447824ULL, 0x000fe200078e025dULL, 0xfffffff81d1c7812ULL, 0x000fca00078ee21cULL,
0x000000004444783bULL, 0x000ea20000004200ULL, 0x000000101c1c7824ULL, 0x000fcc00078e025dULL,
0x000000001c1c783bULL, 0x000ee20000004200ULL, 0x00000018ff0e7819ULL, 0x002fe20000011428ULL,
0x0000010028127824ULL, 0x040fe200078e00ffULL, 0x0000888028507816ULL, 0x040fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001142aULL,
0x00000018ff3d7819ULL, 0x000fe20000011412ULL, 0x0000010029127824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x000088802a617816ULL, 0x000fc400000000ffULL, 0x00000018ff657819ULL, 0x000fe40000011429ULL,
0x00000018ff537819ULL, 0x000fe4000001142bULL, 0x0000888029517816ULL, 0x000fe200000000ffULL,
0x0000002800677306ULL, 0x0003e20000200c00ULL, 0x000088802b5e7816ULL, 0x000fe200000000ffULL,
0x0001000029297824ULL, 0x000fe200078e00ffULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x00000018ff427819ULL, 0x004fc40000011444ULL, 0x00000018ff297819ULL, 0x000fe20000011429ULL,
0x0000003d000d7306ULL, 0x0005220000200c00ULL, 0x000001002b287824ULL, 0x042fe200078e00ffULL,
0x00008880444a7816ULL, 0x000fe200000000ffULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011447ULL, 0x00000018ff287819ULL, 0x000fe40000011428ULL,
0x00000018ff2b7819ULL, 0x000fe2000001142bULL, 0x000001002a3d7824ULL, 0x044fe200078e00ffULL,
0x0000002800607306ULL, 0x0003e20000200c00ULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x0000888047497816ULL, 0x000fc400000000ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff2a7819ULL, 0x000fe4000001142aULL, 0x0000003d00647306ULL, 0x0005e20000200c00ULL,
0x0000010044287824ULL, 0x002fe200078e00ffULL, 0x0000541050507816ULL, 0x010fe2000000000dULL,
0x0001000044447824ULL, 0x000fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011445ULL,
0x00000018ff4b7819ULL, 0x000fe20000011428ULL, 0x0000010045287824ULL, 0x000fe200078e00ffULL,
0x0000002a006a7306ULL, 0x0003e20000200c00ULL, 0x009000003c3c783bULL, 0x004ea20000000200ULL,
0x00000018ff447819ULL, 0x000fc40000011444ULL, 0x00000018ff4e7819ULL, 0x000fe40000011428ULL,
0x00008880454d7816ULL, 0x040fe200000000ffULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x0000002900667306ULL, 0x000fe20000200c00ULL, 0x00000008032a7824ULL, 0x002fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011446ULL, 0x00000018ff547819ULL, 0x000fe40000011445ULL,
0xfffffff82a287812ULL, 0x000fe200078ee213ULL, 0x0000010046137824ULL, 0x040fe200078e00ffULL,
0x0000002b00697306ULL, 0x0003e20000200c00ULL, 0x0000888046457816ULL, 0x000fc400000000ffULL,
0x0000001028287824ULL, 0x000fe200078e025dULL, 0x00000018ff567819ULL, 0x008fe4000001141cULL,
0x00000018ff557819ULL, 0x000fe4000001141dULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x000000002828783bULL, 0x002e620000004200ULL, 0x00000018ff527819ULL, 0x000fe4000001141fULL,
0x00000018ff4f7819ULL, 0x000fe4000001141eULL, 0x00000018ff137819ULL, 0x000fc40000011413ULL,
0x0000001200127306ULL, 0x000ef00000200c00ULL, 0x0000000e000e7306ULL, 0x000f220000200c00ULL,
0x000000063c3c8232ULL, 0x084fe40000000000ULL, 0x000000063e3e8232ULL, 0x000fc40000000000ULL,
0x000000053d3d8232ULL, 0x080fe40000000000ULL, 0x000000053f3f8232ULL, 0x000fe20000000000ULL,
0x0000006500657306ULL, 0x000ea20000200c00ULL, 0x0000541051517816ULL, 0x008fce0000000012ULL,
0x0000004400577306ULL, 0x0007e20000200c00ULL, 0x000000503c38723cULL, 0x000bee0000001838ULL,
0x0000541067507816ULL, 0x030fe2000000000eULL, 0x0000010047447824ULL, 0x048fe200078e00ffULL,
0x0000541066517816ULL, 0x004fe20000000065ULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x0000006100617306ULL, 0x000ea20000200c00ULL, 0x00000018ff127819ULL, 0x002fc40000011428ULL,
0x00000018ff6b7819ULL, 0x000fe20000011444ULL, 0x0001000046447824ULL, 0x000fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x000000503c2c723cULL, 0x000b62000000182cULL,
0x00000018ff0d7819ULL, 0x000fe2000001142aULL, 0x0000005e005e7306ULL, 0x000e620000200c00ULL,
0x00000018ff447819ULL, 0x000fc80000011444ULL, 0x000088801d517816ULL, 0x020fc600000000ffULL,
0x00000047005c7306ULL, 0x0007f00000200c00ULL, 0x0000006b00467306ULL, 0x0009e20000200c00ULL,
0x00000018ff477819ULL, 0x008fce000001142bULL, 0x0000004400687306ULL, 0x0007e20000200c00ULL,
0x000088801c6b7816ULL, 0x010fce00000000ffULL, 0x00000047000e7306ULL, 0x0009e20000200c00ULL,
0x000001001c447824ULL, 0x048fe400078e00ffULL, 0x000100001c1c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x000001001d477824ULL, 0x050fe200078e00ffULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x000100001d1d7824ULL, 0x000fc600078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c00677306ULL, 0x0005f00000200c00ULL,
0x0000005300537306ULL, 0x000ee20000200c00ULL, 0x00005410611c7816ULL, 0x004fc40000000064ULL,
0x000088801f617816ULL, 0x000fca00000000ffULL, 0x0000001d00647306ULL, 0x0003f00000200c00ULL,
0x0000004400507306ULL, 0x0005e20000200c00ULL, 0x000054105e1d7816ULL, 0x002fce0000000060ULL,
0x0000001c3c14723cULL, 0x000be20000001814ULL, 0x000088801e447816ULL, 0x044fe200000000ffULL,
0x00000047006c7306ULL, 0x0003ea0000200c00ULL, 0x000001001f1c7824ULL, 0x020fe200078e00ffULL,
0x000000025f1d7810ULL, 0x000fe20007ffe0ffULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000044005e7306ULL, 0x0005e20000200c00ULL, 0x000001001e477824ULL, 0x042fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fc4000001141fULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000006b006b7306ULL, 0x000e620000200c00ULL, 0x000000085b447824ULL, 0x004fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fc8000001141eULL, 0xfffffff8441f7812ULL, 0x000fe400078ee21dULL,
0x0000005100517306ULL, 0x000ea20000200c00ULL, 0x00005410691d7816ULL, 0x008fe20000000053ULL,
0x0000010028537824ULL, 0x000fe400078e00ffULL, 0x000000101f447824ULL, 0x000fc600078e0204ULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000001c00667306ULL, 0x0007e20000200c00ULL,
0x000054106b507816ULL, 0x002fce0000000050ULL, 0x0000001e00607306ULL, 0x0003e20000200c00ULL,
0x000054106a1c7816ULL, 0x008fe4000000005aULL, 0x0000541051517816ULL, 0x004fe4000000006cULL,
0x00008880295a7816ULL, 0x000fc600000000ffULL, 0x0000001c3c34723cULL, 0x040b620000001834ULL,
0x0000005600567306ULL, 0x000ea20000200c00ULL, 0x00900000441c783bULL, 0x022e6c0000000200ULL,
0x000000503c24723cULL, 0x000b620000001824ULL, 0x0000005500557306ULL, 0x000eec0000200c00ULL,
0x0000010029507824ULL, 0x020fc400078e00ffULL, 0x0000004700657306ULL, 0x0009e60000200c00ULL,
0x00000018ff5b7819ULL, 0x000fe40000011450ULL, 0x0000541067507816ULL, 0x004fc60000000056ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x0000888028477816ULL, 0x050fe200000000ffULL,
0x0001000028287824ULL, 0x000fe200078e00ffULL, 0x0000541064517816ULL, 0x008fe40000000055ULL,
0x000088802a557816ULL, 0x000fe400000000ffULL, 0x00000018ff287819ULL, 0x000fe20000011428ULL,
0x0000004f004f7306ULL, 0x000fe40000200c00ULL, 0x000000503c20723cULL, 0x000b6c0000001820ULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x0001000029517824ULL, 0x020fe200078e00ffULL,
0x000000061c1c8232ULL, 0x002fc40000000000ULL, 0x000000061e1e8232ULL, 0x000fe40000000000ULL,
0x000000051d1d8232ULL, 0x080fe20000000000ULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x000000051f1f8232ULL, 0x000fce0000000000ULL,
0x0000004200427306ULL, 0x000e700000200c00ULL, 0x0000004300437306ULL, 0x000ff00000200c00ULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x0000541057427816ULL, 0x002fce0000000042ULL,
0x0000001300487306ULL, 0x0003f00000200c00ULL, 0x0000002800507306ULL, 0x0007e20000200c00ULL,
0x00000018ff137819ULL, 0x002fe40000011429ULL, 0x0000541061297816ULL, 0x000fc40000000066ULL,
0x0000541054437816ULL, 0x004fc60000000043ULL, 0x0000004500457306ULL, 0x000e620000200c00ULL,
0x000054105e287816ULL, 0x008fc60000000065ULL, 0x000000421c2c723cULL, 0x000fe8000000182cULL,
0x0000004000407306ULL, 0x000ea80000200c00ULL, 0x000000283c18723cULL, 0x000b680000001818ULL,
0x0000004100417306ULL, 0x000ee20000200c00ULL, 0x0000541045487816ULL, 0x002fc40000000048ULL,
0x0000541060287816ULL, 0x020fe2000000004fULL, 0x000000ffff4f7224ULL, 0x000fe200078e0055ULL,
0x000054105f297816ULL, 0x000fc60000000052ULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x0000541068407816ULL, 0x004fc60000000040ULL, 0x000000283c30723cULL, 0x000b680000001830ULL,
0x0000004b004b7306ULL, 0x000e620000200c00ULL, 0x000054105c417816ULL, 0x008fe40000000041ULL,
0x000088802b3e7816ULL, 0x060fe200000000ffULL, 0x000001002b297824ULL, 0x000fe400078e00ffULL,
0x000001002a287824ULL, 0x000fc400078e00ffULL, 0x000100002b2b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011429ULL, 0x000100002a2a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff287819ULL, 0x000fe20000011428ULL, 0x0000004f003c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff457819ULL, 0x000fe4000001142bULL, 0x00000018ff3f7819ULL, 0x000fe4000001142aULL,
0x000054104a4a7816ULL, 0x002fc6000000004bULL, 0x00000028003d7306ULL, 0x0002b00000200c00ULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x000000401c28723cULL, 0x002b6e0000001834ULL,
0x0000004e004e7306ULL, 0x000e620000200c00ULL, 0x000054103c3c7816ULL, 0x004fce000000003dULL,
0x0000004900497306ULL, 0x000eb00000200c00ULL, 0x0000001200127306ULL, 0x000ee20000200c00ULL,
0x000054104d4b7816ULL, 0x002fce000000004eULL, 0x0000001300137306ULL, 0x000fe20000200c00ULL,
0x0000541049497816ULL, 0x004fe20000000046ULL, 0x0000004a1c38723cULL, 0x040f6c0000001838ULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x0000541050127816ULL, 0x008fe20000000012ULL,
0x000000481c14723cULL, 0x000f6c0000001814ULL, 0x0000005300537306ULL, 0x000e700000200c00ULL,
0x0000005a005a7306ULL, 0x000ff00000200c00ULL, 0x0000005b005b7306ULL, 0x000ea20000200c00ULL,
0x0000541047347816ULL, 0x022fce0000000053ULL, 0x0000005100517306ULL, 0x000e700000200c00ULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x000054105a357816ULL, 0x004fce000000005bULL,
0x0000004300437306ULL, 0x000ea20000200c00ULL, 0x0000541051137816ULL, 0x002fe20000000013ULL,
0x000000341c24723cULL, 0x040f6c0000001824ULL, 0x0000000d000d7306ULL, 0x000fe40000200c00ULL,
0x000000121c20723cULL, 0x000f6c0000001820ULL, 0x0000003f00427306ULL, 0x000e620000200c00ULL,
0x000054103e3d7816ULL, 0x004fce0000000043ULL, 0x0000004500457306ULL, 0x000ea20000200c00ULL,
0x0000003c1c18723cULL, 0x000f620000001818ULL, 0x0000541042427816ULL, 0x002fe2000000000dULL,
0x00000002000d7824ULL, 0x000fca00078e00ffULL, 0xfffffff80d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000541045437816ULL, 0x004fce000000000eULL, 0x000000421c1c723cULL, 0x000b6e0000001830ULL,
0x0000f6c858327811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000032327f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f688000dff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff0e7224ULL, 0x000fc600078e00ffULL,
0x0000000000127805ULL, 0x000fc80000015200ULL, 0x00000400090d7984ULL, 0x004ea40000000800ULL,
0x800000000dff7812ULL, 0x006fc40007804833ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000307805ULL, 0x000fcc0000015200ULL, 0x0000003012307210ULL, 0x000fca0007f1e1ffULL,
0x0000000131317824ULL, 0x000fe200000e0e13ULL, 0x003d09003000780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403000780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011431ULL,
0x000000300d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff307224ULL, 0x000fca00000e0631ULL,
0x000000020d0d7819ULL, 0x000fc80000001230ULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010e0e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400090d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe40007804833ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000804c0e7810ULL, 0x000fca0007ffe0ffULL, 0x000066006f337a24ULL, 0x000fe200078e020eULL,
0x000003d000009947ULL, 0x000fea0003800000ULL, 0x0000000e620d7217ULL, 0x000fe20007800000ULL,
0x000000106d307824ULL, 0x000fe200078e00ffULL, 0x00000003ff127819ULL, 0x000fc60000011602ULL,
0x000000010d0d7824ULL, 0x000fe200078e0a0eULL, 0x0000000412317810ULL, 0x000fe20007ffe0ffULL,
0x00000001300e7824ULL, 0x000fe200078e0212ULL, 0x0000000c12327810ULL, 0x000fe40007ffe0ffULL,
0x0000000d300d7217ULL, 0x000fe20007800000ULL, 0x000000010e137824ULL, 0x040fe400078e0202ULL,
0x000000080e367824ULL, 0x000fe400078e00ffULL, 0x000000010d0d7824ULL, 0x000fc400078e0a30ULL,
0x0000000130377824ULL, 0x000fe200078e0232ULL, 0xfffffff836367812ULL, 0x000fe400078ee213ULL,
0x0000000812137810ULL, 0x040fe20007ffe0ffULL, 0x00000008373e7824ULL, 0x000fe200078e00ffULL,
0x0000000d1200720cULL, 0x080fe20003f86070ULL, 0x000000010e127824ULL, 0x000fe200078e0233ULL,
0x0000000d3100720cULL, 0x080fe20003f66070ULL, 0x0000000130317824ULL, 0x040fe200078e0231ULL,
0x0000000d1300720cULL, 0x080fe20003f46070ULL, 0x0000000130347824ULL, 0x000fe200078e0213ULL,
0x0000000d3200720cULL, 0x000fe20003f06070ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000000131307824ULL, 0x040fe200078e0233ULL, 0x0000005912127212ULL, 0x000fe200078efcffULL,
0x00000001310e7824ULL, 0x040fe400078e0202ULL, 0x0000000831357824ULL, 0x000fe200078e00ffULL,
0x0000620012127a10ULL, 0x000fe20007fbe0ffULL, 0x0000008030307825ULL, 0x000fc600078e00ffULL,
0xfffffff8350e7812ULL, 0x000fe200078ee20eULL, 0x0000000134327824ULL, 0x100fe200078e0233ULL,
0x0000005930307212ULL, 0x000fe200078efcffULL, 0x00000001340d7824ULL, 0x040fe200078e0202ULL,
0x0000630013137a10ULL, 0x000fe20002ffe4ffULL, 0x00000008343c7824ULL, 0x000fe200078e00ffULL,
0x0000620030307a10ULL, 0x000fe20007fbe0ffULL, 0x0000000137347824ULL, 0x000fe400078e0233ULL,
0x0000008032327825ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fc400078ee20dULL,
0x0000630031317a10ULL, 0x000fe20002ffe4ffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000005932327212ULL, 0x000fc600078efcffULL, 0x00000001370d7824ULL, 0x000fe200078e0202ULL,
0x0000005934347212ULL, 0x000fe200078efcffULL, 0x000000100e377824ULL, 0x100fe200078e025dULL,
0x0000620032327a10ULL, 0x000fe20007fbe0ffULL, 0x000000103c3d7824ULL, 0x000fe200078e025dULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee20dULL, 0x00000010360d7824ULL, 0x100fe200078e025dULL,
0x0000620034347a10ULL, 0x000fe40007fde0ffULL, 0x0000630033337a10ULL, 0x000fe20002ffe4ffULL,
0x000000103e3f7824ULL, 0x000fe200078e025dULL, 0x0000630035357a10ULL, 0x000fe200037fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000120d7faeULL, 0x0003e8000e101c48ULL,
0x0000000030377faeULL, 0x0003e8000d901c48ULL, 0x00000000323d7faeULL, 0x0003e8000d101c48ULL,
0x00000000343f7faeULL, 0x0003e2000c101c48ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x000000106d0d7824ULL, 0x000fca00078e00ffULL, 0x0000000d020d7211ULL, 0x000fc800078fe8ffULL,
0x000000040d347810ULL, 0x040fe20007ffe0ffULL, 0x000000010d0e7824ULL, 0x140fe200078e0202ULL,
0x000000080d307810ULL, 0x040fe20007ffe0ffULL, 0x000000080d317824ULL, 0x000fe400078e00ffULL,
0x0000000134127824ULL, 0x040fe400078e0202ULL, 0x0000000834357824ULL, 0x000fe200078e00ffULL,
0xfffffff8310e7812ULL, 0x000fe200078ee20eULL, 0x0000000130137824ULL, 0x040fe400078e0202ULL,
0x00000008303c7824ULL, 0x000fe200078e00ffULL, 0xfffffff835367812ULL, 0x000fe200078ee212ULL,
0x000000010d127824ULL, 0x140fe200078e0233ULL, 0x0000000c0d0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000134347824ULL, 0x000fe200078e0233ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee213ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x0000000130307824ULL, 0x100fe200078e0233ULL,
0x0000005912127212ULL, 0x000fe200078efcffULL, 0x000000010d327824ULL, 0x000fe400078e0233ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000620012127a10ULL, 0x000fc60007f1e0ffULL,
0x0000008030307825ULL, 0x000fe200078e00ffULL, 0x0000005934347212ULL, 0x080fe400078efcffULL,
0x0000630013137a10ULL, 0x000fe200007fe4ffULL, 0x0000008032327825ULL, 0x000fe200078e00ffULL,
0x0000005930307212ULL, 0x080fe400078efcffULL, 0x0000620034347a10ULL, 0x000fe20007f5e0ffULL,
0x000000010d377824ULL, 0x040fe200078e0202ULL, 0x0000005932327212ULL, 0x000fe200078efcffULL,
0x000000080d3e7824ULL, 0x000fe200078e00ffULL, 0x0000620030307a10ULL, 0x000fe20007f1e0ffULL,
0x000000100e0d7824ULL, 0x100fe200078e025dULL, 0x0000620032327a10ULL, 0x000fe20007f7e0ffULL,
0x000000103c3d7824ULL, 0x000fe200078e025dULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee237ULL,
0x0000001036377824ULL, 0x100fe200078e025dULL, 0x0000630035357a10ULL, 0x000fe200017fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000120d7faeULL, 0x0003e2000b901c48ULL,
0x0000630031317a10ULL, 0x000fe200007fe4ffULL, 0x000000103e3f7824ULL, 0x000fe200078e025dULL,
0x0000630033337a10ULL, 0x000fe20001ffe4ffULL, 0x0000000034377faeULL, 0x0003e8000b901c48ULL,
0x00000000303d7faeULL, 0x0003e8000b901c48ULL, 0x00000000323f7faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000010580d7824ULL, 0x000fe200078e00ffULL,
0xffffffe00b0e7812ULL, 0x000fc400078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x000000080b127812ULL, 0x000fe400078ec0ffULL, 0x000000100d0d7812ULL, 0x000fc800078ec0ffULL,
0x0000000e120d7210ULL, 0x000fe20007ffe00dULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff407f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f628000d327f8cULL, 0x0004e4000c80043fULL,
0x0000000000127805ULL, 0x000fc40000015200ULL, 0x00f62c00080d7984ULL, 0x004ea40000000800ULL,
0x800000000dff7812ULL, 0x00cfe40007804833ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fcc0000015200ULL,
0x00000030120e7210ULL, 0x000fca0007f1e1ffULL, 0x0000000131307824ULL, 0x000fe200000e0e13ULL,
0x003d09000e00780cULL, 0x000fc80003f06070ULL, 0x000000ff3000720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400e00780cULL, 0x000fc80003f06070ULL,
0x000000ff3000720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc80000011430ULL, 0x0000000e0d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff0e7224ULL, 0x000fca00000e0630ULL, 0x000000020d0d7819ULL, 0x000fc8000000120eULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f62c00080d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe40007804833ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000020000d7824ULL, 0x000fca00078e00ffULL,
0xffffff800d0e7812ULL, 0x000fc800078ec0ffULL, 0x00000080590d7810ULL, 0x000fca0007ffe00eULL,
0x000000016e0d7824ULL, 0x000fca00078e020dULL, 0x00f000000d317984ULL, 0x000ea80000000800ULL,
0x00f200000d0e7984ULL, 0x0006620000000800ULL, 0x0000000c3100720bULL, 0x004fe20003f1d000ULL,
0x0000d3b27f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff3c307812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0d7424ULL, 0x000fd600078e00ffULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x00000001710d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000c3100720bULL, 0x000fe40003f54000ULL,
0x000000000d00720cULL, 0x000fe20003f05270ULL, 0x0000d3627f007947ULL, 0x000fd4000b800000ULL,
0x00000000000d7806ULL, 0x000fc400010e0100ULL, 0x0000008000338824ULL, 0x000fe200078e0259ULL,
0x0000000c31137209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x000099100d127816ULL, 0x000fe200000000ffULL, 0x000000016e328824ULL, 0x000fca00078e0233ULL,
0x00f4001332008388ULL, 0x0005e20000000800ULL, 0x000000ff1200720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x800000130c127221ULL, 0x004fe20000010000ULL,
0x000000ff0dff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL, 0x0000001200327308ULL, 0x000ea40000000800ULL,
0x000000320f0f7220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff127819ULL, 0x000fe20000011602ULL, 0x0000d2927f007947ULL, 0x000fea000b800000ULL,
0x00001f12323c7589ULL, 0x0004e400000e0000ULL, 0x0000003c38387220ULL, 0x08cfe20000410000ULL,
0x0000003c39397220ULL, 0x080fe20000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000003c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000003c14147220ULL, 0x080fe20000410000ULL,
0x0000003c15157220ULL, 0x080fe20000410000ULL, 0x0000003c28287220ULL, 0x080fe20000410000ULL,
0x0000003c29297220ULL, 0x080fe20000410000ULL, 0x0000003c24247220ULL, 0x080fe20000410000ULL,
0x0000003c25257220ULL, 0x080fe20000410000ULL, 0x0000003c20207220ULL, 0x080fe20000410000ULL,
0x0000003c21217220ULL, 0x080fe20000410000ULL, 0x0000003c18187220ULL, 0x080fe20000410000ULL,
0x0000003c19197220ULL, 0x080fe20000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000003c1d1d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000dff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000802127811ULL, 0x000fe200078ff0ffULL, 0x0000d1727f007947ULL, 0x000fea000b800000ULL,
0x00001f12323c7589ULL, 0x0004e400000e0000ULL, 0x0000003c3a3a7220ULL, 0x08cfe20000410000ULL,
0x0000003c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000003c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000003c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000003c16167220ULL, 0x080fe20000410000ULL,
0x0000003c17177220ULL, 0x080fe20000410000ULL, 0x0000003c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000003c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000003c26267220ULL, 0x080fe20000410000ULL,
0x0000003c27277220ULL, 0x080fe20000410000ULL, 0x0000003c22227220ULL, 0x080fe20000410000ULL,
0x0000003c23237220ULL, 0x080fe20000410000ULL, 0x0000003c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000003c1f1f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff30ff7812ULL, 0x000fe2000780600dULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000c310c7209ULL, 0x000fd60007810000ULL, 0x8000000c31310221ULL, 0x000fe20000010000ULL,
0x00007610ff0d0816ULL, 0x000fc6000000000dULL, 0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL,
0x0000003100070308ULL, 0x000ea40000000800ULL, 0x000000070e0e0220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000f0e0f7221ULL, 0x002fc20000010000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0xfffffff00b347812ULL, 0x000fca00078ec0ffULL,
0x00f6b40034317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff327224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000307805ULL, 0x000fcc0000015200ULL, 0x0000003012337210ULL, 0x000fca0007f1e1ffULL,
0x0000000131317824ULL, 0x000fe200000e0e13ULL, 0x003d09003300780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403300780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0e7819ULL, 0x000fc80000011431ULL,
0x000000330e0e7211ULL, 0x000fca00078110ffULL, 0x000000ffff317224ULL, 0x000fca00000e0631ULL,
0x000000020e0e7819ULL, 0x000fc80000001231ULL, 0x0000000e0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000132327810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b40034317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100d0d7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0d00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000007ff05723eULL, 0x000fe400000000ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011602ULL,
0x00005410050d7816ULL, 0x000fe20000000005ULL, 0x0000cd327f007947ULL, 0x000fea000b800000ULL,
0x00001f0e0d067589ULL, 0x0002a400000e0000ULL, 0x000000080e127810ULL, 0x000fe20007ffe0ffULL,
0x0000cd627f007947ULL, 0x000fea000b800000ULL, 0x00001f120d057589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100e127810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200078e000dULL, 0x000052d0003d7802ULL, 0x000fc40000000f00ULL,
0x0000d57000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180e127810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200078e000dULL,
0x00005320003d7802ULL, 0x000fc40000000f00ULL, 0x0000d52000007944ULL, 0x006fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000200677824ULL, 0x000fe200078e00ffULL,
0x0000000702117812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000802107812ULL, 0x000fc400078ec0ffULL, 0x00000004670d7812ULL, 0x00afe400078ec0ffULL,
0x00000008110e7812ULL, 0x000fe400078ef802ULL, 0x0000000d020d7211ULL, 0x000fc600078fe0ffULL,
0x000000080e437824ULL, 0x040fe400078e00ffULL, 0x000000010e0e7824ULL, 0x000fca00078e020dULL,
0xfffffff843437812ULL, 0x000fca00078ee20eULL, 0x0000001043437824ULL, 0x000fc400078e0204ULL,
0x00000004000d7824ULL, 0x000fe200078e00ffULL, 0x0000001110367212ULL, 0x000fe200078efcffULL,
0x0000000803107824ULL, 0x000fe200078e00ffULL, 0x000010005d6c7810ULL, 0x000fe20007ffe0ffULL,
0x00000008034e7824ULL, 0x000fe200078e00ffULL, 0x000000040d0d7812ULL, 0x000fe200078ec0ffULL,
0x0000000836117824ULL, 0x000fe200078e00ffULL, 0xfffffff867677812ULL, 0x000fe400078ec0ffULL,
0x0000000d020d7211ULL, 0x000fca00078fe0ffULL, 0x0000000136347824ULL, 0x100fe400078e020dULL,
0x00000001033d7824ULL, 0x000fc600078e020dULL, 0xfffffff811117812ULL, 0x000fe400078ee234ULL,
0xfffffff8104f7812ULL, 0x000fe400078ee23dULL, 0x0000000234427810ULL, 0x000fe20007ffe0ffULL,
0x00000010115c7824ULL, 0x100fe200078e026cULL, 0x000000023d3d7810ULL, 0x000fe20007ffe0ffULL,
0x000000104f107824ULL, 0x000fc600078e026cULL, 0x000000005c30783bULL, 0x000e680000004200ULL,
0x000000001010783bULL, 0x000ee20000004200ULL, 0x00000018ff507819ULL, 0x002fe20000011430ULL,
0x0000010030357824ULL, 0x040fe200078e00ffULL, 0x00008880303c7816ULL, 0x044fe200000000ffULL,
0x0001000030307824ULL, 0x000fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011431ULL,
0x0000010031477824ULL, 0x040fe200078e00ffULL, 0x00008880313e7816ULL, 0x040fe200000000ffULL,
0x0001000031317824ULL, 0x000fe200078e00ffULL, 0x00000018ff307819ULL, 0x000fe20000011430ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x00000100104a7824ULL, 0x008fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe20000011432ULL,
0x00000100114d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fc40000011433ULL,
0x0000888032527816ULL, 0x000fe200000000ffULL, 0x00000030005f7306ULL, 0x0003e20000200c00ULL,
0x0000888033537816ULL, 0x000fe400000000ffULL, 0x00000018ff317819ULL, 0x000fe40000011431ULL,
0x00000018ff3f7819ULL, 0x000fe20000011435ULL, 0x0000000836357824ULL, 0x000fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fe20000011410ULL, 0x0000004700617306ULL, 0x0005e20000200c00ULL,
0x0000010032307824ULL, 0x002fe200078e00ffULL, 0x0000888010497816ULL, 0x000fe200000000ffULL,
0x0001000032327824ULL, 0x000fe200078e00ffULL, 0xfffffff835427812ULL, 0x000fc400078ee242ULL,
0x00000018ff307819ULL, 0x000fe40000011430ULL, 0x0000003100487306ULL, 0x000fe20000200c00ULL,
0x0000010033477824ULL, 0x044fe200078e00ffULL, 0x00000018ff687819ULL, 0x000fe20000011432ULL,
0x0001000033337824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011411ULL,
0x0000001042347824ULL, 0x000fe200078e026cULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000003000697306ULL, 0x0003e20000200c00ULL, 0x00000018ff667819ULL, 0x000fc40000011433ULL,
0x000000003434783bULL, 0x000ea20000004200ULL, 0x00008880114b7816ULL, 0x040fe200000000ffULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000005200527306ULL, 0x000ee20000200c00ULL, 0x009800004330783bULL, 0x002e620000000200ULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff577819ULL, 0x000fc40000011412ULL, 0x0000005300537306ULL, 0x000fe20000200c00ULL,
0x00008880125e7816ULL, 0x000fe400000000ffULL, 0x00000018ff567819ULL, 0x000fca0000011413ULL,
0x0000004700477306ULL, 0x000f220000200c00ULL, 0x0000541052527816ULL, 0x008fce0000000069ULL,
0x0000006500657306ULL, 0x000ff00000200c00ULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x0000541053537816ULL, 0x010fe40000000047ULL, 0x00000018ff5b7819ULL, 0x004fc40000011434ULL,
0x00000018ff5a7819ULL, 0x000fe40000011435ULL, 0x00000018ff547819ULL, 0x000fe20000011436ULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x0000000630308232ULL, 0x082fe20000000000ULL,
0x00000018ff557819ULL, 0x000fe20000011437ULL, 0x0000000632328232ULL, 0x000fe40000000000ULL,
0x0000000531318232ULL, 0x080fe40000000000ULL, 0x0000000533338232ULL, 0x000fe20000000000ULL,
0x0000006600667306ULL, 0x000e6c0000200c00ULL, 0x000000523014723cULL, 0x000be40000001814ULL,
0x0000003f003f7306ULL, 0x000eea0000200c00ULL, 0x0000541068527816ULL, 0x024fc40000000065ULL,
0x0000888034657816ULL, 0x000fe200000000ffULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x0000541066537816ULL, 0x002fe20000000064ULL, 0x0000010034667824ULL, 0x000fe200078e00ffULL,
0x0000888036687816ULL, 0x000fe200000000ffULL, 0x0001000034347824ULL, 0x000fc600078e00ffULL,
0x00000018ff667819ULL, 0x000fe20000011466ULL, 0x000000523028723cULL, 0x000be20000001828ULL,
0x000054103c3c7816ULL, 0x008fe2000000003fULL, 0x00010000103f7824ULL, 0x000fe200078e00ffULL,
0xfffffff84e107812ULL, 0x000fe200078ee23dULL, 0x0000006500647306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x00000100124e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe2000001143fULL, 0x00000010103f7824ULL, 0x000fe200078e026cULL,
0x000054103e3d7816ULL, 0x004fe20000000061ULL, 0x0000010035527824ULL, 0x060fe200078e00ffULL,
0x0000888035537816ULL, 0x040fe200000000ffULL, 0x0000006600697306ULL, 0x000e620000200c00ULL,
0x0001000035357824ULL, 0x000fc400078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe20000011452ULL,
0x0000003c3038723cULL, 0x000b620000001838ULL, 0x0001000012127824ULL, 0x000fe200078e00ffULL,
0x000000003f3c783bULL, 0x020ea20000004200ULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000005300537306ULL, 0x000fe40000200c00ULL, 0x00000018ff127819ULL, 0x000fcc0000011412ULL,
0x0000006a006a7306ULL, 0x000ef00000200c00ULL, 0x0000003400527306ULL, 0x0003f00000200c00ULL,
0x0000003500657306ULL, 0x0007e20000200c00ULL, 0x0000541064347816ULL, 0x002fce0000000069ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x0000541053357816ULL, 0x008fe2000000006aULL,
0x0000010036537824ULL, 0x040fe400078e00ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x00000018ff477819ULL, 0x004fc6000001143dULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x000000343024723cULL, 0x000be20000001824ULL, 0x00000018ff697819ULL, 0x000fe40000011453ULL,
0x0000888037537816ULL, 0x040fe400000000ffULL, 0x00000018ff647819ULL, 0x000fe40000011436ULL,
0x0000010037347824ULL, 0x060fe200078e00ffULL, 0x000088803c367816ULL, 0x000fe200000000ffULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x0000005000507306ULL, 0x000ea40000200c00ULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff6a7819ULL, 0x000fe40000011437ULL,
0x0000541065357816ULL, 0x002fe2000000005aULL, 0x000000ffff657224ULL, 0x000fe200078e0036ULL,
0x0000003400667306ULL, 0x0003e20000200c00ULL, 0x000001003c5a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x0000005100517306ULL, 0x000ee20000200c00ULL,
0x0000541052347816ULL, 0x002fe4000000005bULL, 0x000054105f507816ULL, 0x004fca0000000050ULL,
0x000000343034723cULL, 0x000be20000001820ULL, 0x0000005400547306ULL, 0x000fe20000200c00ULL,
0x009800004420783bULL, 0x020e620000000200ULL, 0x0000541048517816ULL, 0x008fcc0000000051ULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x00000050302c723cULL, 0x000b6e000000182cULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x00000018ff507819ULL, 0x020fe4000001144eULL,
0x00008880134e7816ULL, 0x000fca00000000ffULL, 0x0000006900697306ULL, 0x000eb00000200c00ULL,
0x0000005300537306ULL, 0x000ef00000200c00ULL, 0x0000006400647306ULL, 0x000f220000200c00ULL,
0x0000541068527816ULL, 0x004fe20000000069ULL, 0x0000000620208232ULL, 0x002fc40000000000ULL,
0x0000000622228232ULL, 0x000fe40000000000ULL, 0x0000000521218232ULL, 0x080fe40000000000ULL,
0x0000006a005b7306ULL, 0x000e620000200c00ULL, 0x0000541053537816ULL, 0x008fe20000000066ULL,
0x0000000523238232ULL, 0x000fe20000000000ULL, 0x000088803d667816ULL, 0x000fca00000000ffULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x0000541064547816ULL, 0x010fe20000000054ULL,
0x000000523018723cULL, 0x000b6c0000001818ULL, 0x0000004a004a7306ULL, 0x000ea20000200c00ULL,
0x000054105b557816ULL, 0x002fe20000000055ULL, 0x000001003d537824ULL, 0x020fc400078e00ffULL,
0x000100003d3d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff527224ULL, 0x000fe200078e0066ULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x00000054301c723cULL, 0x000b62000000181cULL, 0x00000018ff3d7819ULL, 0x000fcc000001143dULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x000001003e307824ULL, 0x020fe200078e00ffULL,
0x000088803f317816ULL, 0x000fe400000000ffULL, 0x00005410494a7816ULL, 0x004fe4000000004aULL,
0x00000018ff307819ULL, 0x000fe20000011430ULL, 0x000000ffff497224ULL, 0x000fe200078e0031ULL,
0x0000004500457306ULL, 0x000ff00000200c00ULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x000054104b4b7816ULL, 0x002fce000000004dULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x0000004a2038723cULL, 0x000b6e0000001838ULL, 0x0000001100617306ULL, 0x0002a20000200c00ULL,
0x000001003f4a7824ULL, 0x020fca00078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x0000003000337306ULL, 0x0007e20000200c00ULL, 0x0000010013117824ULL, 0x042fe400078e00ffULL,
0x0001000013137824ULL, 0x000fc600078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000541061317816ULL, 0x004fe20000000046ULL, 0x0000005e00487306ULL, 0x0003e20000200c00ULL,
0x0000541060307816ULL, 0x008fce0000000045ULL, 0x00000012005f7306ULL, 0x0005e20000200c00ULL,
0x00000018ff5e7819ULL, 0x002fe20000011413ULL, 0x00000030202c723cULL, 0x000b62000000182cULL,
0x00000018ff137819ULL, 0x000fe2000001143cULL, 0x000100003c3c7824ULL, 0x000fc800078e00ffULL,
0x0000006500447306ULL, 0x0003e20000200c00ULL, 0x00000018ff127819ULL, 0x004fe2000001143fULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x000100003e307824ULL, 0x020fc600078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000001100517306ULL, 0x0005e20000200c00ULL, 0x000088803e657816ULL, 0x002fe400000000ffULL,
0x00000018ff307819ULL, 0x000fc60000011430ULL, 0x000000ffff5b7224ULL, 0x000fe400078e0065ULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x00000018ff117819ULL, 0x004fce000001143eULL,
0x0000003d003d7306ULL, 0x000e700000200c00ULL, 0x0000005b00327306ULL, 0x000eb00000200c00ULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x000054103d3d7816ULL, 0x002fce0000000047ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x0000541032327816ULL, 0x004fce0000000033ULL,
0x0000005000507306ULL, 0x000e700000200c00ULL, 0x0000004e004e7306ULL, 0x000eb00000200c00ULL,
0x0000005e005e7306ULL, 0x000ee20000200c00ULL, 0x0000541048507816ULL, 0x002fce0000000050ULL,
0x0000001300137306ULL, 0x000fe20000200c00ULL, 0x000054104e517816ULL, 0x004fce0000000051ULL,
0x0000001100117306ULL, 0x000fe20000200c00ULL, 0x000054105e317816ULL, 0x008fe20000000056ULL,
0x000000502014723cULL, 0x000b6c0000001814ULL, 0x0000001200127306ULL, 0x000ff00000200c00ULL,
0x0000005a005a7306ULL, 0x000e700000200c00ULL, 0x0000005200527306ULL, 0x000ff00000200c00ULL,
0x0000005300537306ULL, 0x000ea20000200c00ULL, 0x0000541044447816ULL, 0x002fce000000005aULL,
0x0000003c003c7306ULL, 0x000e700000200c00ULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x0000541052457816ULL, 0x004fce0000000053ULL, 0x0000004a003e7306ULL, 0x000ea20000200c00ULL,
0x000054103c3c7816ULL, 0x002fe20000000013ULL, 0x000000442024723cULL, 0x040b6c0000001824ULL,
0x0000003000467306ULL, 0x0002e40000200c00ULL, 0x0000003c2034723cULL, 0x000b6c0000001834ULL,
0x0000003f003f7306ULL, 0x000f220000200c00ULL, 0x000054105f307816ULL, 0x002fc40000000057ULL,
0x0000541049337816ULL, 0x004fe4000000003eULL, 0x0000541046467816ULL, 0x008fc60000000011ULL,
0x000000302028723cULL, 0x000b620000001828ULL, 0x000054103f477816ULL, 0x010fce0000000012ULL,
0x000000322018723cULL, 0x000b620000001818ULL, 0x0000f6c858127811ULL, 0x000fce00078e18ffULL,
0x00000046201c723cULL, 0x000b62000000181cULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000012127f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6900067ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff117224ULL, 0x000fc600078e00ffULL, 0x0000000000207805ULL, 0x020fc80000015200ULL,
0x0000040009237984ULL, 0x000ee40000000800ULL, 0x8000000023ff7812ULL, 0x00afe40007804813ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002220317210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e21ULL,
0x003d09003100780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403100780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011423ULL, 0x0000003122227211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x0000000222227819ULL, 0x000fc80000001223ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000111117810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040009237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c04c127810ULL, 0x000fca0007ffe0ffULL,
0x000066006f317a24ULL, 0x000fe200078e0212ULL, 0x000003d000009947ULL, 0x000fea0003800000ULL,
0x0000001262117217ULL, 0x000fe20007800000ULL, 0x000000106d207824ULL, 0x000fe200078e00ffULL,
0x00000003ff137819ULL, 0x000fc60000011602ULL, 0x0000000111117824ULL, 0x000fe200078e0a12ULL,
0x0000000413227810ULL, 0x040fe20007ffe0ffULL, 0x0000000120127824ULL, 0x040fe200078e0213ULL,
0x0000000c13237810ULL, 0x000fe40007ffe0ffULL, 0x0000001120117217ULL, 0x000fe20007800000ULL,
0x0000000112217824ULL, 0x040fe400078e0202ULL, 0x0000000812307824ULL, 0x000fe400078e00ffULL,
0x0000000111117824ULL, 0x000fc400078e0a20ULL, 0x0000000112127824ULL, 0x000fe200078e0231ULL,
0xfffffff830337812ULL, 0x000fe200078ee221ULL, 0x0000000120327824ULL, 0x000fe200078e0223ULL,
0x000000112200720cULL, 0x080fe20003f66070ULL, 0x0000000120227824ULL, 0x000fe200078e0222ULL,
0x0000000813217810ULL, 0x040fe40007ffe0ffULL, 0x000000111300720cULL, 0x080fe20003f86070ULL,
0x0000000122137824ULL, 0x040fe200078e0202ULL, 0x000000112100720cULL, 0x080fe20003f46070ULL,
0x0000000822307824ULL, 0x040fe200078e00ffULL, 0x000000112300720cULL, 0x000fe20003f06070ULL,
0x0000000122227824ULL, 0x000fc400078e0231ULL, 0x0000000120217824ULL, 0x000fe200078e0221ULL,
0xfffffff8303d7812ULL, 0x000fe200078ee213ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000005912127212ULL, 0x000fc600078efcffULL,
0x0000000121307824ULL, 0x140fe200078e0231ULL, 0x0000620012127a10ULL, 0x000fe20007fbe0ffULL,
0x0000000121117824ULL, 0x040fe200078e0202ULL, 0x0000005922227212ULL, 0x080fe200078efcffULL,
0x00000008213c7824ULL, 0x000fe200078e00ffULL, 0x0000630013137a10ULL, 0x000fe20002ffe4ffULL,
0x0000000132207824ULL, 0x000fe200078e0231ULL, 0x0000620022227a10ULL, 0x000fe20007fbe0ffULL,
0x0000008030307825ULL, 0x000fe200078e00ffULL, 0xfffffff83c3f7812ULL, 0x000fe400078ee211ULL,
0x0000630023237a10ULL, 0x000fe20002ffe4ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000005930307212ULL, 0x000fc600078efcffULL, 0x0000000132117824ULL, 0x000fe200078e0202ULL,
0x0000005920207212ULL, 0x000fe200078efcffULL, 0x0000000832327824ULL, 0x000fe200078e00ffULL,
0x0000620030307a10ULL, 0x000fe40007fbe0ffULL, 0x0000620020207a10ULL, 0x000fe40007fde0ffULL,
0xfffffff832457812ULL, 0x000fe200078ee211ULL, 0x0000001033117824ULL, 0x100fe200078e026cULL,
0x0000630031317a10ULL, 0x000fe20002ffe4ffULL, 0x000000103d337824ULL, 0x100fe200078e026cULL,
0x0000630021217a10ULL, 0x000fe200037fe4ffULL, 0x000000103f3d7824ULL, 0x100fe200078e026cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012117faeULL, 0x0003e2000e101c48ULL,
0x00000010453f7824ULL, 0x000fc600078e026cULL, 0x0000000022337faeULL, 0x0003e8000d901c48ULL,
0x00000000303d7faeULL, 0x0003e8000d101c48ULL, 0x00000000203f7faeULL, 0x0003e2000c101c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x000000106d117824ULL, 0x000fca00078e00ffULL,
0x0000001102117211ULL, 0x000fc800078fe8ffULL, 0x0000000411227810ULL, 0x040fe20007ffe0ffULL,
0x0000000111127824ULL, 0x140fe200078e0202ULL, 0x0000000811307810ULL, 0x040fe20007ffe0ffULL,
0x0000000811337824ULL, 0x000fe400078e00ffULL, 0x0000000122137824ULL, 0x040fe400078e0202ULL,
0x0000000822207824ULL, 0x000fe200078e00ffULL, 0xfffffff833337812ULL, 0x000fe200078ee212ULL,
0x0000000130217824ULL, 0x040fe400078e0202ULL, 0x0000000830327824ULL, 0x000fe200078e00ffULL,
0xfffffff8203d7812ULL, 0x000fe200078ee213ULL, 0x0000000111207824ULL, 0x140fe200078e0231ULL,
0x0000000c11117810ULL, 0x000fe20007ffe0ffULL, 0x0000000122227824ULL, 0x000fe200078e0231ULL,
0xfffffff8323f7812ULL, 0x000fe200078ee221ULL, 0x0000008020207825ULL, 0x000fc800078e00ffULL,
0x0000000130307824ULL, 0x100fe200078e0231ULL, 0x0000005920207212ULL, 0x000fe200078efcffULL,
0x0000000111127824ULL, 0x000fe400078e0231ULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000620020207a10ULL, 0x000fc60007f1e0ffULL, 0x0000008030307825ULL, 0x000fe200078e00ffULL,
0x0000005922227212ULL, 0x080fe400078efcffULL, 0x0000630021217a10ULL, 0x000fe200007fe4ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000005930307212ULL, 0x080fe400078efcffULL,
0x0000620022227a10ULL, 0x000fe20007f5e0ffULL, 0x0000000111327824ULL, 0x040fe200078e0202ULL,
0x0000005912127212ULL, 0x000fe200078efcffULL, 0x0000000811457824ULL, 0x000fe200078e00ffULL,
0x0000620030307a10ULL, 0x000fe20007f1e0ffULL, 0x0000001033117824ULL, 0x100fe200078e026cULL,
0x0000620012127a10ULL, 0x000fe20007f7e0ffULL, 0x000000103d337824ULL, 0x000fe200078e026cULL,
0xfffffff845457812ULL, 0x000fe200078ee232ULL, 0x000000103f3d7824ULL, 0x100fe200078e026cULL,
0x0000630023237a10ULL, 0x000fe200017fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000020117faeULL, 0x0003e2000b901c48ULL, 0x0000630031317a10ULL, 0x000fe200007fe4ffULL,
0x00000010453f7824ULL, 0x000fe200078e026cULL, 0x0000630013137a10ULL, 0x000fe20001ffe4ffULL,
0x0000000022337faeULL, 0x0003e8000b901c48ULL, 0x00000000303d7faeULL, 0x0003e8000b901c48ULL,
0x00000000123f7faeULL, 0x0003e4000b901c48ULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xfffffff00b207812ULL, 0x000fce00078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6b00020207f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480008127f8cULL, 0x0006a4000c80043fULL,
0x0000000000227805ULL, 0x000fc40000015200ULL, 0xffffffe00b087812ULL, 0x048fe400078ec0ffULL,
0x000000100b117812ULL, 0x040fe400078ec0ffULL, 0x000000080b307812ULL, 0x000fc800078ec0ffULL,
0x0000000830087210ULL, 0x000fca0007ffe011ULL, 0x00f64c0008117984ULL, 0x000ee40000000800ULL,
0x8000000011ff7812ULL, 0x00cfe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff327224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000307805ULL, 0x000fcc0000015200ULL,
0x0000003022307210ULL, 0x000fca0007f1e1ffULL, 0x0000000131317824ULL, 0x000fe200000e0e23ULL,
0x003d09003000780cULL, 0x000fc80003f06070ULL, 0x000000ff3100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403000780cULL, 0x000fc80003f06070ULL,
0x000000ff3100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff117819ULL, 0x000fc80000011431ULL, 0x0000003011117211ULL, 0x000fca00078110ffULL,
0x000000ffff307224ULL, 0x000fca00000e0631ULL, 0x0000000211117819ULL, 0x000fc80000001230ULL,
0x000000110000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000132327810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f64c0008117984ULL, 0x000ea40000000800ULL, 0x8000000011ff7812ULL, 0x004fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000087824ULL, 0x000fca00078e00ffULL,
0xffffff8008087812ULL, 0x000fc800078ec0ffULL, 0x0000010059117810ULL, 0x000fca0007ffe008ULL,
0x000000016e117824ULL, 0x000fca00078e0211ULL, 0x00f0000011237984ULL, 0x000ea80000000800ULL,
0x00f2000011227984ULL, 0x0006620000000800ULL, 0x0000000c2300720bULL, 0x004fe20003f1d000ULL,
0x0000aeb27f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x008fc800000e0100ULL,
0x0000ffff3c317812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff117424ULL, 0x000fe400078e00ffULL, 0x000000ffff087224ULL, 0x000fd200078e000cULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x0000000271117810ULL, 0x000fe40007ffe0ffULL,
0x0000000c2300720bULL, 0x000fe40003f54000ULL, 0x000000001100720cULL, 0x000fe20003f05270ULL,
0x0000ae527f007947ULL, 0x000fd4000b800000ULL, 0x0000000000087806ULL, 0x000fc400010e0100ULL,
0x0000008000138824ULL, 0x000fe200078e0259ULL, 0x0000000c23118209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991008127816ULL, 0x000fe200000000ffULL,
0x000000016e308824ULL, 0x000fca00078e0213ULL, 0x00f4001130008388ULL, 0x0005e20000000800ULL,
0x000000ff1200720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000c23117209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff08ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000c11117221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b11117820ULL, 0x000fc80000410000ULL, 0x0000001100307308ULL, 0x000ea40000000800ULL,
0x000000300f0f7220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff127819ULL, 0x000fe20000011602ULL, 0x0000ad727f007947ULL, 0x000fea000b800000ULL,
0x00001f12303c7589ULL, 0x0004e400000e0000ULL, 0x0000003c38387220ULL, 0x08cfe20000410000ULL,
0x0000003c39397220ULL, 0x080fe20000410000ULL, 0x0000003c2c2c7220ULL, 0x080fe20000410000ULL,
0x0000003c2d2d7220ULL, 0x080fe20000410000ULL, 0x0000003c14147220ULL, 0x080fe20000410000ULL,
0x0000003c15157220ULL, 0x080fe20000410000ULL, 0x0000003c28287220ULL, 0x080fe20000410000ULL,
0x0000003c29297220ULL, 0x080fe20000410000ULL, 0x0000003c24247220ULL, 0x080fe20000410000ULL,
0x0000003c25257220ULL, 0x080fe20000410000ULL, 0x0000003c34347220ULL, 0x080fe20000410000ULL,
0x0000003c35357220ULL, 0x080fe20000410000ULL, 0x0000003c18187220ULL, 0x080fe20000410000ULL,
0x0000003c19197220ULL, 0x080fe20000410000ULL, 0x0000003c1c1c7220ULL, 0x080fe20000410000ULL,
0x0000003c1d1d7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0008ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000802127811ULL, 0x000fe200078ff0ffULL, 0x0000ac527f007947ULL, 0x000fea000b800000ULL,
0x00001f12303c7589ULL, 0x0004e400000e0000ULL, 0x0000003c3a3a7220ULL, 0x08cfe20000410000ULL,
0x0000003c3b3b7220ULL, 0x080fe20000410000ULL, 0x0000003c2e2e7220ULL, 0x080fe20000410000ULL,
0x0000003c2f2f7220ULL, 0x080fe20000410000ULL, 0x0000003c16167220ULL, 0x080fe20000410000ULL,
0x0000003c17177220ULL, 0x080fe20000410000ULL, 0x0000003c2a2a7220ULL, 0x080fe20000410000ULL,
0x0000003c2b2b7220ULL, 0x080fe20000410000ULL, 0x0000003c26267220ULL, 0x080fe20000410000ULL,
0x0000003c27277220ULL, 0x080fe20000410000ULL, 0x0000003c36367220ULL, 0x080fe20000410000ULL,
0x0000003c37377220ULL, 0x080fe20000410000ULL, 0x0000003c1a1a7220ULL, 0x080fe20000410000ULL,
0x0000003c1b1b7220ULL, 0x080fe20000410000ULL, 0x0000003c1e1e7220ULL, 0x080fe20000410000ULL,
0x0000003c1f1f7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff31ff7812ULL, 0x000fe20007806008ULL, 0x00000001ff117424ULL, 0x000fe200078e00ffULL,
0x0000000c23087209ULL, 0x000fd60007810000ULL, 0x8000000823230221ULL, 0x000fe20000010000ULL,
0x00007610ff110816ULL, 0x000fc60000000011ULL, 0x3fb8aa3b23230820ULL, 0x000fc80000410000ULL,
0x0000002300070308ULL, 0x000ea40000000800ULL, 0x0000000722220220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000f220f7221ULL, 0x002fc20000010000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0xfffffff00b327812ULL, 0x000fca00078ec0ffULL,
0x00f6ac0032237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804841ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002212317210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e13ULL, 0x003d09003100780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403100780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc80000011423ULL,
0x000000310c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e0623ULL,
0x000000020c0c7819ULL, 0x000fc80000001223ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000130307810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0032237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe40007804841ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910110c7816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0c00720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000007ff05723eULL, 0x000fe400000000ffULL, 0x00000002ff117819ULL, 0x000fe40000011602ULL,
0x00005410050c7816ULL, 0x000fe20000000005ULL, 0x0000a8127f007947ULL, 0x000fea000b800000ULL,
0x00001f110c067589ULL, 0x0002a400000e0000ULL, 0x0000000811127810ULL, 0x000fe20007ffe0ffULL,
0x0000a8427f007947ULL, 0x000fea000b800000ULL, 0x00001f120c057589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001011127810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200078e000cULL, 0x000079b0003d7802ULL, 0x000fc40000000f00ULL,
0x0000ae9000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001811127810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200078e000cULL,
0x00007a00003d7802ULL, 0x000fc40000000f00ULL, 0x0000ae4000007944ULL, 0x006fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010423c7824ULL, 0x104fe200078e025dULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000104f307824ULL, 0x000fc400078e025dULL,
0x0000001010107824ULL, 0x000fe400078e025dULL, 0x000000003c3c783bULL, 0x000ea80000004200ULL,
0x000000003030783bULL, 0x000fe80000004200ULL, 0x000000001010783bULL, 0x00ae620000004200ULL,
0x00000018ff447819ULL, 0x004fe2000001143cULL, 0x000001003c0c7824ULL, 0x040fe200078e00ffULL,
0x000088803c467816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe2000001143eULL, 0x000001003d407824ULL, 0x000fe200078e00ffULL,
0x000088803e697816ULL, 0x040fe200000000ffULL, 0x000001003e417824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x00000018ff407819ULL, 0x000fc40000011440ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff497819ULL, 0x000fe4000001143fULL, 0x000088803f5f7816ULL, 0x000fe200000000ffULL,
0x0000003c00477306ULL, 0x0005e20000200c00ULL, 0x000088803d607816ULL, 0x040fe400000000ffULL,
0x00000018ff457819ULL, 0x000fe2000001143dULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fc4000001140cULL, 0x00000018ff5b7819ULL, 0x002fe20000011410ULL,
0x0000004000677306ULL, 0x0003e20000200c00ULL, 0x000001003f3c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x0000888010617816ULL, 0x000fe400000000ffULL, 0x00000018ff547819ULL, 0x000fe40000011430ULL,
0x00000041006a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff407819ULL, 0x002fe2000001143cULL,
0x000100003e3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fc4000001143fULL,
0x0000888030507816ULL, 0x000fe400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x00000040003e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff5a7819ULL, 0x000fe40000011411ULL,
0x00000018ff227819ULL, 0x000fe40000011412ULL, 0x00000018ff537819ULL, 0x000fe40000011431ULL,
0x00008880314e7816ULL, 0x000fe200000000ffULL, 0x0000003c004b7306ULL, 0x0005e20000200c00ULL,
0x00a000004340783bULL, 0x002e620000000200ULL, 0x00000018ff237819ULL, 0x000fc40000011413ULL,
0x0000888032527816ULL, 0x000fe400000000ffULL, 0x00000018ff557819ULL, 0x000fe40000011433ULL,
0x0000003f004a7306ULL, 0x0007e20000200c00ULL, 0x00000100313c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011432ULL, 0x0001000031317824ULL, 0x000fca00078e00ffULL,
0x0000000c00657306ULL, 0x000ea20000200c00ULL, 0x00000018ff3f7819ULL, 0x008fe2000001143cULL,
0x00010000303c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff577819ULL, 0x000fe20000011431ULL,
0x0000010032317824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000006000607306ULL, 0x000ee20000200c00ULL, 0x00000018ff517819ULL, 0x000fe40000011431ULL,
0x0000888033317816ULL, 0x000fca00000000ffULL, 0x0000003d000c7306ULL, 0x0009f00000200c00ULL,
0x0000003c006b7306ULL, 0x0005e20000200c00ULL, 0x00000100303d7824ULL, 0x010fe200078e00ffULL,
0x0000000640408232ULL, 0x002fc40000000000ULL, 0x0000000642428232ULL, 0x000fe40000000000ULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000000541418232ULL, 0x080fe20000000000ULL,
0x0000004500457306ULL, 0x000e620000200c00ULL, 0x00000100103c7824ULL, 0x044fe200078e00ffULL,
0x0000000543438232ULL, 0x000fe20000000000ULL, 0x0001000010107824ULL, 0x000fc600078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001143cULL, 0x0000003d004d7306ULL, 0x0007e20000200c00ULL,
0x00005410463c7816ULL, 0x000fe20000000065ULL, 0x0000010011467824ULL, 0x000fe200078e00ffULL,
0x0000000802657812ULL, 0x000fe400078ec0ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x00005410603d7816ULL, 0x008fc40000000067ULL, 0x000054100c457816ULL, 0x002fe40000000045ULL,
0x000000020e0c7810ULL, 0x000fc60007ffe0ffULL, 0x0000003c4024723cULL, 0x000b620000001824ULL,
0x0000001000647306ULL, 0x0003ec0000200c00ULL, 0x00000007023d7812ULL, 0x020fe400078ec0ffULL,
0x00000007653c7812ULL, 0x100fe200078ef802ULL, 0x0000004400447306ULL, 0x000ea20000200c00ULL,
0x000000083d3d7812ULL, 0x000fe200078ef802ULL, 0x0000010012107824ULL, 0x042fe200078e00ffULL,
0x0000888012657816ULL, 0x000fe200000000ffULL, 0x000000013c0d7824ULL, 0x000fc400078e020dULL,
0x000000083c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x000000083d3d7824ULL, 0x000fe200078e00ffULL, 0x0000005f005f7306ULL, 0x000e620000200c00ULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0xfffffff83c3c7812ULL, 0x000fe400078ee20dULL,
0xfffffff83d0c7812ULL, 0x000fc600078ee20cULL, 0x000000103c0d7824ULL, 0x000fe200078e025dULL,
0x0000003f00307306ULL, 0x0007e20000200c00ULL, 0x00008880133c7816ULL, 0x000fe200000000ffULL,
0x000000100c0c7824ULL, 0x000fe200078e00ffULL, 0x0000541047447816ULL, 0x004fca0000000044ULL,
0x0000001000667306ULL, 0x0005e20000200c00ULL, 0x00008880113f7816ULL, 0x048fe200000000ffULL,
0x0001000011117824ULL, 0x000fca00078e00ffULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000003f00607306ULL, 0x000fe20000200c00ULL, 0x0000541069107816ULL, 0x004fe2000000006aULL,
0x000000ffff697224ULL, 0x000fe200078e003cULL, 0x0000a000043c7810ULL, 0x000fe20007ffe00cULL,
0x0000010013047824ULL, 0x000fc800078e00ffULL, 0x0000001100687306ULL, 0x0003e20000200c00ULL,
0x00000018ff6a7819ULL, 0x000fe40000011404ULL, 0x00000018ff047819ULL, 0x000fca0000011412ULL,
0x0000004600677306ULL, 0x0005e20000200c00ULL, 0x000054105f117816ULL, 0x002fe4000000003eULL,
0x000000003c3c783bULL, 0x000e6a0000000200ULL, 0x0000004800487306ULL, 0x000ee20000200c00ULL,
0x000000444044723cULL, 0x044b640000001834ULL, 0x000000000d34783bULL, 0x020eaa0000004200ULL,
0x0000004900497306ULL, 0x000f220000200c00ULL, 0x000000104018723cULL, 0x000b6e0000001818ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x000054104b487816ULL, 0x008fc40000000048ULL,
0x0000541060117816ULL, 0x020fca0000000067ULL, 0x0000005e005e7306ULL, 0x000ee20000200c00ULL,
0x000054104a497816ULL, 0x010fce0000000049ULL, 0x0000005b005b7306ULL, 0x000f220000200c00ULL,
0x000000484048723cULL, 0x000be2000000181cULL, 0x000000063c3c8232ULL, 0x082fe40000000000ULL,
0x000000063e3e8232ULL, 0x000fe40000000000ULL, 0x000000053d3d8232ULL, 0x080fe40000000000ULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x0000541061107816ULL, 0x008fe2000000005eULL,
0x000000053f3f8232ULL, 0x000fe20000000000ULL, 0x00000100341d7824ULL, 0x024fe200078e00ffULL,
0x00000018ff127819ULL, 0x000fc40000011434ULL, 0x00008880341c7816ULL, 0x040fe200000000ffULL,
0x0001000034347824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe2000001141dULL,
0x000000103c24723cULL, 0x000be20000001824ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0000888035617816ULL, 0x040fe400000000ffULL, 0x00000018ff5f7819ULL, 0x000fe40000011435ULL,
0x00000018ff0d7819ULL, 0x000fe20000011436ULL, 0x0000010035107824ULL, 0x060fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe20000011437ULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0001000035117824ULL, 0x000fc400078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011410ULL,
0x00000018ff107819ULL, 0x000fe40000011434ULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x0000888036347816ULL, 0x000fce00000000ffULL,
0x0000001c00607306ULL, 0x0009f00000200c00ULL, 0x0000001d00677306ULL, 0x0003e20000200c00ULL,
0x00005410641c7816ULL, 0x010fce000000005bULL, 0x0000001000357306ULL, 0x0005e20000200c00ULL,
0x00005410681d7816ULL, 0x002fe2000000005aULL, 0x00000100365a7824ULL, 0x000fcc00078e00ffULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x0000010037107824ULL, 0x044fe200078e00ffULL,
0x0000001c3c1c723cULL, 0x000bec0000001844ULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x00000018ff457819ULL, 0x020fe2000001145aULL, 0x0001000036467824ULL, 0x000fe200078e00ffULL,
0x0000888037447816ULL, 0x040fe200000000ffULL, 0x0001000037477824ULL, 0x000fc400078e00ffULL,
0x00010000135a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000001200127306ULL, 0x000e620000200c00ULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x00000018ff5a7819ULL, 0x000fca000001145aULL, 0x0000005f005f7306ULL, 0x000ff00000200c00ULL,
0x00000011005b7306ULL, 0x0004e20000200c00ULL, 0x0000541035127816ULL, 0x002fe20000000012ULL,
0x0000010033357824ULL, 0x000fc400078e00ffULL, 0x0001000033337824ULL, 0x000fc600078e00ffULL,
0x00000018ff357819ULL, 0x000fe20000011435ULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x00000018ff117819ULL, 0x004fe40000011410ULL, 0x0000541065107816ULL, 0x000fe40000000066ULL,
0x00000018ff337819ULL, 0x000fc60000011433ULL, 0x0000001100367306ULL, 0x0003e20000200c00ULL,
0x000054105b137816ULL, 0x008fce000000005fULL, 0x0000004500457306ULL, 0x000ea20000200c00ULL,
0x0000541069117816ULL, 0x002fce000000006aULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x000000103c18723cULL, 0x000bee0000001818ULL, 0x0000541060107816ULL, 0x020fe20000000067ULL,
0x0000000d000d7306ULL, 0x000fe20000200c00ULL, 0x0000541061117816ULL, 0x000fce0000000070ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x000000104038723cULL, 0x040fee0000001838ULL,
0x0000004600377306ULL, 0x000ee20000200c00ULL, 0x000000124010723cULL, 0x000bee000000182cULL,
0x0000004700477306ULL, 0x000f220000200c00ULL, 0x00005410342c7816ULL, 0x024fc40000000045ULL,
0x00005410442d7816ULL, 0x002fca0000000036ULL, 0x0000002200227306ULL, 0x000fe40000200c00ULL,
0x0000002c402c723cULL, 0x000b6c0000001814ULL, 0x0000000400047306ULL, 0x000e620000200c00ULL,
0x0001000032167824ULL, 0x020fe200078e00ffULL, 0x0000541037147816ULL, 0x008fc4000000000dULL,
0x0000541047157816ULL, 0x010fe4000000005eULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x0000004e004e7306ULL, 0x000ea60000200c00ULL, 0x000000144040723cULL, 0x000b6a0000001828ULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x0000541004227816ULL, 0x002fce0000000022ULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x000054104e297816ULL, 0x024fce0000000030ULL,
0x0000003100317306ULL, 0x000ff00000200c00ULL, 0x0000003500327306ULL, 0x000ea20000200c00ULL,
0x0000541052307816ULL, 0x002fce0000000051ULL, 0x0000005400547306ULL, 0x000e700000200c00ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x0000541031317816ULL, 0x004fce0000000032ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x000000303c2c723cULL, 0x000b62000000182cULL,
0x000054106b147816ULL, 0x002fcc0000000054ULL, 0x0000005500557306ULL, 0x000ff00000200c00ULL,
0x0000002300237306ULL, 0x000ff00000200c00ULL, 0x0000005000507306ULL, 0x000e700000200c00ULL,
0x0000005700577306ULL, 0x000eb00000200c00ULL, 0x0000005a005a7306ULL, 0x000ee20000200c00ULL,
0x0000541050287816ULL, 0x002fce000000004dULL, 0x00000016000d7306ULL, 0x0003220000200c00ULL,
0x0000541057157816ULL, 0x004fe20000000053ULL, 0x000000283c28723cULL, 0x040b6c0000001838ULL,
0x0000003300047306ULL, 0x000ea20000200c00ULL, 0x000054105a237816ULL, 0x008fe20000000023ULL,
0x000000143c14723cULL, 0x002b640000001810ULL, 0x000054100d307816ULL, 0x030fcc0000000056ULL,
0x000000223c48723cULL, 0x000b620000001848ULL, 0x0000541004317816ULL, 0x004fe40000000055ULL,
0x0000f69871047811ULL, 0x000fca00078e18ffULL, 0x000000303c30723cULL, 0x000b620000001840ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000009107f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000004ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff0d7224ULL, 0x000fc600078e00ffULL,
0x0000000000127805ULL, 0x000fc80000015200ULL, 0x0000040009237984ULL, 0x020f240000000800ULL,
0x8000000023ff7812ULL, 0x014fe40007804811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002212357210ULL, 0x000fca0007f1e1ffULL,
0x0000000123237824ULL, 0x000fe200000e0e13ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x008fc80000011423ULL,
0x0000003504047211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e0623ULL,
0x0000000204047819ULL, 0x000fc80000001223ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040009237984ULL, 0x000ea40000000800ULL,
0x8000000023ff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010a047810ULL, 0x008fc80007ffe0ffULL, 0x000000630400720cULL, 0x000fda0003f06070ULL,
0x0000072000000947ULL, 0x000fea0003800000ULL, 0x000000020a047810ULL, 0x000fe40007ffe0ffULL,
0x000001004c0d7810ULL, 0x000fe40007ffe0ffULL, 0x000000630400720cULL, 0x000fc60003f06070ULL,
0x000066006f237a24ULL, 0x000fd400078e020dULL, 0x000003d000008947ULL, 0x000fea0003800000ULL,
0x0000000d62047217ULL, 0x000fe20007800000ULL, 0x000000106d117824ULL, 0x000fe200078e00ffULL,
0x00000003ff107819ULL, 0x000fc60000011602ULL, 0x0000000104047824ULL, 0x000fe200078e0a0dULL,
0x0000000410137810ULL, 0x040fe20007ffe0ffULL, 0x0000000111127824ULL, 0x040fe200078e0210ULL,
0x0000000810227810ULL, 0x000fe40007ffe0ffULL, 0x0000000411047217ULL, 0x000fe20007800000ULL,
0x00000001120d7824ULL, 0x040fe400078e0202ULL, 0x0000000812367824ULL, 0x000fe400078e00ffULL,
0x0000000104047824ULL, 0x000fc400078e0a11ULL, 0x0000000112127824ULL, 0x000fe200078e0223ULL,
0xfffffff836367812ULL, 0x000fe200078ee20dULL, 0x00000001110d7824ULL, 0x000fe200078e0213ULL,
0x000000041300720cULL, 0x080fe20003f66070ULL, 0x0000000111347824ULL, 0x000fe200078e0222ULL,
0x000000041000720cULL, 0x0c0fe20003f86070ULL, 0x000000080d357824ULL, 0x040fe200078e00ffULL,
0x0000000c10137810ULL, 0x000fe20007ffe0ffULL, 0x000000010d107824ULL, 0x000fe200078e0202ULL,
0x000000042200720cULL, 0x080fe20003f46070ULL, 0x0000000134227824ULL, 0x000fe200078e0223ULL,
0x000000041300720cULL, 0x000fe20003f06070ULL, 0x0000000111377824ULL, 0x000fe200078e0213ULL,
0xfffffff835047812ULL, 0x000fe200078ee210ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x000000010d107824ULL, 0x000fe200078e0223ULL, 0x0000005912127212ULL, 0x000fe200078efcffULL,
0x00000001340d7824ULL, 0x000fe400078e0202ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000620012127a10ULL, 0x000fc60007fbe0ffULL, 0x0000000834387824ULL, 0x000fe200078e00ffULL,
0x0000005910107212ULL, 0x080fe200078efcffULL, 0x0000000137347824ULL, 0x000fe200078e0223ULL,
0x0000630013137a10ULL, 0x000fe20002ffe4ffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe400078ee20dULL, 0x0000620010107a10ULL, 0x000fe20007fbe0ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000005922227212ULL, 0x080fe400078efcffULL,
0x0000630011117a10ULL, 0x000fe20002ffe4ffULL, 0x00000001370d7824ULL, 0x040fe200078e0202ULL,
0x0000005934347212ULL, 0x000fe200078efcffULL, 0x00000008373a7824ULL, 0x000fe200078e00ffULL,
0x0000620022227a10ULL, 0x000fe20007fbe0ffULL, 0x0000001004377824ULL, 0x100fe200078e025dULL,
0x0000620034347a10ULL, 0x000fe20007fde0ffULL, 0x0000001038397824ULL, 0x000fe200078e025dULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee20dULL, 0x00000010360d7824ULL, 0x000fe200078e025dULL,
0x0000630023237a10ULL, 0x000fc40002ffe4ffULL, 0x0000630035357a10ULL, 0x000fe200037fe4ffULL,
0x000000103a3b7824ULL, 0x000fe200078e025dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120d7faeULL, 0x0005e8000e101c48ULL, 0x0000000010377faeULL, 0x0005e8000d901c48ULL,
0x0000000022397faeULL, 0x0005e8000d101c48ULL, 0x00000000343b7faeULL, 0x0005e2000c101c48ULL,
0x0000030000007947ULL, 0x000fea0003800000ULL, 0x000000106d0d7824ULL, 0x000fca00078e00ffULL,
0x0000000d020d7211ULL, 0x000fc800078fe8ffULL, 0x000000040d347810ULL, 0x040fe20007ffe0ffULL,
0x000000010d047824ULL, 0x140fe200078e0202ULL, 0x000000080d227810ULL, 0x040fe20007ffe0ffULL,
0x000000080d137824ULL, 0x000fe400078e00ffULL, 0x0000000134107824ULL, 0x040fe400078e0202ULL,
0x0000000834357824ULL, 0x000fe200078e00ffULL, 0xfffffff813047812ULL, 0x000fe200078ee204ULL,
0x0000000122117824ULL, 0x040fe400078e0202ULL, 0x0000000822387824ULL, 0x000fe200078e00ffULL,
0xfffffff835367812ULL, 0x000fe200078ee210ULL, 0x000000010d107824ULL, 0x140fe200078e0223ULL,
0x0000000c0d0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000134347824ULL, 0x000fe200078e0223ULL,
0xfffffff838387812ULL, 0x000fe200078ee211ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x0000000122227824ULL, 0x100fe200078e0223ULL, 0x0000005910107212ULL, 0x000fe200078efcffULL,
0x000000010d127824ULL, 0x000fe400078e0223ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000620010107a10ULL, 0x000fc60007f1e0ffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x0000005934347212ULL, 0x080fe400078efcffULL, 0x0000630011117a10ULL, 0x000fe200007fe4ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000005922227212ULL, 0x080fe400078efcffULL,
0x0000620034347a10ULL, 0x000fe20007f5e0ffULL, 0x000000010d377824ULL, 0x040fe200078e0202ULL,
0x0000005912127212ULL, 0x000fe200078efcffULL, 0x000000080d3a7824ULL, 0x000fe200078e00ffULL,
0x0000620022227a10ULL, 0x000fe20007f1e0ffULL, 0x00000010040d7824ULL, 0x100fe200078e025dULL,
0x0000620012127a10ULL, 0x000fe20007f7e0ffULL, 0x0000001038397824ULL, 0x000fe200078e025dULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee237ULL, 0x0000001036377824ULL, 0x100fe200078e025dULL,
0x0000630035357a10ULL, 0x000fe200017fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000100d7faeULL, 0x0005e2000b901c48ULL, 0x0000630023237a10ULL, 0x000fe200007fe4ffULL,
0x000000103a3b7824ULL, 0x000fe200078e025dULL, 0x0000630013137a10ULL, 0x000fe20001ffe4ffULL,
0x0000000034377faeULL, 0x0005e8000b901c48ULL, 0x0000000022397faeULL, 0x0005e8000b901c48ULL,
0x00000000123b7faeULL, 0x0005e4000b901c48ULL, 0x0000000000007918ULL, 0x004fe20000000000ULL,
0x0000001058047824ULL, 0x000fe200078e00ffULL, 0x000000080b0d7812ULL, 0x000fc400078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe40008000a04ULL, 0x0000001004047812ULL, 0x000fca00078ee2ffULL,
0x0000002071047824ULL, 0x000fc800078e0204ULL, 0x000000010d0d7824ULL, 0x000fe200078e0204ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff127f8cULL, 0x000ea2000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f668000d107f8cULL, 0x000662000c80043fULL, 0x000000ffff047224ULL, 0x004fc600078e0013ULL,
0x0000000000127805ULL, 0x000fc80000015200ULL, 0x00f66c000d237984ULL, 0x000ea40000000800ULL,
0x8000000023ff7812ULL, 0x006fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000227805ULL, 0x000fcc0000015200ULL,
0x0000002212357210ULL, 0x000fca0007f1e1ffULL, 0x0000000123237824ULL, 0x000fe200000e0e13ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff227819ULL, 0x000fc80000011423ULL, 0x0000003522227211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0623ULL, 0x0000000222227819ULL, 0x000fc80000001223ULL,
0x000000220000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f66c000d237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000180710d7811ULL, 0x008fc800078e38ffULL,
0x0000000d6e0d7210ULL, 0x000fca0007ffe059ULL, 0x00f000000d117984ULL, 0x000e680000000800ULL,
0x00f200000d107984ULL, 0x0004e20000000800ULL, 0x000000081100720bULL, 0x002fe20003f1d000ULL,
0x00008a927f007947ULL, 0x000fd8000b800000ULL, 0x00000000003c7806ULL, 0x004fc800000e0100ULL,
0x0000ffff3c237812ULL, 0x000fe2000780c0ffULL, 0x0000049000007945ULL, 0x000fe20003800000ULL,
0x00000001ff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff0d7224ULL, 0x000fd200078e0008ULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x00000003710d7810ULL, 0x000fe40007ffe0ffULL,
0x000000081100720bULL, 0x000fe40003f54000ULL, 0x000000000d00720cULL, 0x000fe20003f05270ULL,
0x00008a327f007947ULL, 0x000fd4000b800000ULL, 0x0000000000227806ULL, 0x000fc400010e0100ULL,
0x0000008000598824ULL, 0x000fe200078e0259ULL, 0x00000008110d7209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991022127816ULL, 0x000fe200000000ffULL,
0x000000016e6e8824ULL, 0x000fca00078e0259ULL, 0x00f4000d6e008388ULL, 0x0003e20000000800ULL,
0x000000ff1200720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x000000080d087221ULL, 0x002fe20000010100ULL, 0x000000ff22ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b08087820ULL, 0x000fcc0000410000ULL,
0x0000000800087308ULL, 0x000e640000000800ULL, 0x000000080f0f7220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff127819ULL, 0x000fe20000011602ULL,
0x000089627f007947ULL, 0x000fea000b800000ULL, 0x00001f12083c7589ULL, 0x0002a400000e0000ULL,
0x0000003c28287220ULL, 0x084fe20000410000ULL, 0x0000003c29297220ULL, 0x080fe20000410000ULL,
0x0000003c14147220ULL, 0x080fe20000410000ULL, 0x0000003c15157220ULL, 0x080fe20000410000ULL,
0x0000003c2c2c7220ULL, 0x080fe20000410000ULL, 0x0000003c2d2d7220ULL, 0x080fe20000410000ULL,
0x0000003c30307220ULL, 0x080fe20000410000ULL, 0x0000003c31317220ULL, 0x080fe20000410000ULL,
0x0000003c24247220ULL, 0x080fe20000410000ULL, 0x0000003c25257220ULL, 0x080fe20000410000ULL,
0x0000003c1c1c7220ULL, 0x080fe20000410000ULL, 0x0000003c1d1d7220ULL, 0x080fe20000410000ULL,
0x0000003c18187220ULL, 0x080fe20000410000ULL, 0x0000003c19197220ULL, 0x080fe20000410000ULL,
0x0000003c48487220ULL, 0x080fe20000410000ULL, 0x0000003c49497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0022ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000802127811ULL, 0x002fe200078ff0ffULL,
0x000088427f007947ULL, 0x000fea000b800000ULL, 0x00001f12083c7589ULL, 0x0002a400000e0000ULL,
0x0000003c2a2a7220ULL, 0x084fe20000410000ULL, 0x0000003c2b2b7220ULL, 0x080fe20000410000ULL,
0x0000003c16167220ULL, 0x080fe20000410000ULL, 0x0000003c17177220ULL, 0x080fe20000410000ULL,
0x0000003c2e2e7220ULL, 0x080fe20000410000ULL, 0x0000003c2f2f7220ULL, 0x080fe20000410000ULL,
0x0000003c32327220ULL, 0x080fe20000410000ULL, 0x0000003c33337220ULL, 0x080fe20000410000ULL,
0x0000003c26267220ULL, 0x080fe20000410000ULL, 0x0000003c27277220ULL, 0x080fe20000410000ULL,
0x0000003c1e1e7220ULL, 0x080fe20000410000ULL, 0x0000003c1f1f7220ULL, 0x080fe20000410000ULL,
0x0000003c1a1a7220ULL, 0x080fe20000410000ULL, 0x0000003c1b1b7220ULL, 0x080fe20000410000ULL,
0x0000003c4a4a7220ULL, 0x080fe20000410000ULL, 0x0000003c4b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff23ff7812ULL, 0x000fe20007806022ULL,
0x00000001ff227424ULL, 0x000fd800078e00ffULL, 0x000000110d110221ULL, 0x000fe20000010100ULL,
0x00007610ff220816ULL, 0x000fc60000000022ULL, 0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL,
0x0000001100070308ULL, 0x000e640000000800ULL, 0x0000000710100220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000f100f7221ULL, 0x008fc40000010000ULL,
0x0000000000107805ULL, 0x000fca0000015200ULL, 0xfffffff00b347812ULL, 0x000fe200078ec0ffULL,
0x0000000400087824ULL, 0x000fc800078e00ffULL, 0x00f6b40034137984ULL, 0x000e620000000800ULL,
0x0000000408087812ULL, 0x000fc800078ec0ffULL, 0x0000000208357812ULL, 0x000fe400078efcffULL,
0x8000000013ff7812ULL, 0x002fe20007804821ULL, 0x0000000000007918ULL, 0x000fd40000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210237210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011413ULL,
0x0000002308087211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000208087819ULL, 0x000fc80000001213ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6b40034137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991022087816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000007ff05723eULL, 0x000fe400000000ffULL,
0x00000002ff117819ULL, 0x000fe40000011602ULL, 0x0000541005087816ULL, 0x000fe20000000005ULL,
0x000083c27f007947ULL, 0x000fea000b800000ULL, 0x00001f1108067589ULL, 0x0002a400000e0000ULL,
0x0000000811127810ULL, 0x000fe20007ffe0ffULL, 0x000083f27f007947ULL, 0x000fea000b800000ULL,
0x00001f1208057589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001011127810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff137224ULL, 0x000fe200078e0008ULL,
0x00009fc0003d7802ULL, 0x000fc40000000f00ULL, 0x0000888000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001811127810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff137224ULL, 0x000fe200078e0008ULL, 0x0000a010003d7802ULL, 0x000fc40000000f00ULL,
0x0000883000007944ULL, 0x006fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000702377812ULL, 0x000fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000371467810ULL, 0x000fc40007ffe0ffULL, 0x0000000837087812ULL, 0x00afca00078ef802ULL,
0x0000000808117824ULL, 0x000fca00078e00ffULL, 0xfffffff8110e7812ULL, 0x000fca00078ee20eULL,
0x0000008071457824ULL, 0x000fe200078e020eULL, 0x00000008020e7812ULL, 0x000fc800078ec0ffULL,
0x0000a80045457811ULL, 0x000fc400078e20ffULL, 0x000000005c20783bULL, 0x000e620000004200ULL,
0x000000370e377212ULL, 0x000fe200078efcffULL, 0x0000010020087824ULL, 0x002fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fe20000011422ULL, 0x0000010021107824ULL, 0x000fe200078e00ffULL,
0x00008880223f7816ULL, 0x040fe200000000ffULL, 0x0000010022347824ULL, 0x040fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fe20000011408ULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x000010005d087810ULL, 0x000fe20007ffe0ffULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x00000018ff767819ULL, 0x000fc40000011410ULL, 0x00000018ff4d7819ULL, 0x000fe20000011421ULL,
0x000000104f107824ULL, 0x000fe200078e0208ULL, 0x00008880214e7816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x00000018ff657819ULL, 0x000fe20000011420ULL,
0x000000001010783bULL, 0x000e620000004200ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000888020667816ULL, 0x040fe200000000ffULL, 0x0001000020207824ULL, 0x000fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fe20000011423ULL, 0x0000002200697306ULL, 0x0007e20000200c00ULL,
0x00008880233d7816ULL, 0x000fc400000000ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff347819ULL, 0x000fc60000011434ULL, 0x00000021006e7306ULL, 0x000fe20000200c00ULL,
0x0000003502227211ULL, 0x008fca00078fe0ffULL, 0x00000001370e7824ULL, 0x040fe400078e0222ULL,
0x0000000837377824ULL, 0x000fe200078e00ffULL, 0x0000002000707306ULL, 0x0007f00000200c00ULL,
0x0000006600667306ULL, 0x000f220000200c00ULL, 0x0000010023207824ULL, 0x008fc400078e00ffULL,
0x0001000023237824ULL, 0x000fc600078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x0000010011217824ULL, 0x002fe200078e00ffULL,
0x00000020003e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff5c7819ULL, 0x000fe40000011410ULL,
0x0000888010607816ULL, 0x040fe400000000ffULL, 0x00000018ff617819ULL, 0x000fe40000011421ULL,
0xfffffff837217812ULL, 0x000fe200078ee20eULL, 0x0000002300687306ULL, 0x000fe20000200c00ULL,
0x0000010010207824ULL, 0x042fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe20000011411ULL,
0x00000001030e7824ULL, 0x000fe200078e0222ULL, 0x00008880115e7816ULL, 0x000fe200000000ffULL,
0x0000001021217824ULL, 0x000fe200078e026cULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x000000002138783bULL, 0x000e620000004200ULL,
0x0000000803037824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fc40000011410ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000020005f7306ULL, 0x0007e20000200c00ULL,
0xfffffff803037812ULL, 0x000fe200078ee20eULL, 0x00000100120e7824ULL, 0x040fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011412ULL, 0x0000888012557816ULL, 0x040fe200000000ffULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe20000011413ULL,
0x00000010005d7306ULL, 0x0003e20000200c00ULL, 0x000000004520783bULL, 0x008ee20000000200ULL,
0x0000001003037824ULL, 0x000fe200078e0208ULL, 0x0000888013577816ULL, 0x040fe200000000ffULL,
0x0000010013087824ULL, 0x040fe200078e00ffULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x0000007600767306ULL, 0x000ea20000200c00ULL, 0x00000018ff087819ULL, 0x000fc40000011408ULL,
0x00000018ff137819ULL, 0x000fca0000011413ULL, 0x0000001100647306ULL, 0x0003f00000200c00ULL,
0x00000034003c7306ULL, 0x0045e20000200c00ULL, 0x0000010038107824ULL, 0x042fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe20000011438ULL, 0x0000010039117824ULL, 0x000fe200078e00ffULL,
0x0000888038517816ULL, 0x040fe200000000ffULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fc40000011410ULL, 0x00000012006c7306ULL, 0x0003e20000200c00ULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x000000000334783bULL, 0x004ea20000004200ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff4c7819ULL, 0x000fe40000011439ULL,
0x0000888039507816ULL, 0x040fe200000000ffULL, 0x00000010004f7306ULL, 0x0009e20000200c00ULL,
0x0000000620208232ULL, 0x088fe20000000000ULL, 0x0000080046127824ULL, 0x002fe200078e020cULL,
0x0000000622228232ULL, 0x000fe20000000000ULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x0000000521218232ULL, 0x080fe20000000000ULL, 0x000088803b0c7816ULL, 0x000fe200000000ffULL,
0x0000000523238232ULL, 0x000fe20000000000ULL, 0x00000038006a7306ULL, 0x0003e20000200c00ULL,
0x000001003a107824ULL, 0x010fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fc40000011439ULL,
0x00000018ff437819ULL, 0x000fe4000001143aULL, 0x00000018ff447819ULL, 0x000fe4000001143bULL,
0x0000001100537306ULL, 0x0007e20000200c00ULL, 0x00000018ff387819ULL, 0x002fe40000011410ULL,
0x0000541066107816ULL, 0x000fe40000000052ULL, 0x000088803a457816ULL, 0x040fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fc400078e00ffULL, 0x00000013006b7306ULL, 0x0003e20000200c00ULL,
0x000054104e117816ULL, 0x008fe20000000076ULL, 0x000000ffff4e7224ULL, 0x000fe200078e000cULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x000001003b0c7824ULL, 0x040fe400078e00ffULL,
0x000100003b3b7824ULL, 0x000fe400078e00ffULL, 0x000000102028723cULL, 0x000be20000001828ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x009000001210783bULL, 0x022e620000000200ULL,
0x00000018ff0c7819ULL, 0x000fc4000001140cULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x00000018ff407819ULL, 0x004fe40000011435ULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff037819ULL, 0x000fce0000011436ULL, 0x0000003f003f7306ULL, 0x000eb00000200c00ULL,
0x0000003d003d7306ULL, 0x000ef00000200c00ULL, 0x0000005400547306ULL, 0x000f220000200c00ULL,
0x000054103f3c7816ULL, 0x004fce000000003cULL, 0x0000003900677306ULL, 0x0005e20000200c00ULL,
0x000054103d3d7816ULL, 0x008fe2000000003eULL, 0x0000000610108232ULL, 0x082fe40000000000ULL,
0x0000000612128232ULL, 0x000fe40000000000ULL, 0x0000000511118232ULL, 0x080fe40000000000ULL,
0x0000003800467306ULL, 0x0003e20000200c00ULL, 0x000054106e397816ULL, 0x004fe2000000004dULL,
0x0000003c203c723cULL, 0x000be2000000182cULL, 0x0000000513138232ULL, 0x000fca0000000000ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x0000541070387816ULL, 0x002fe40000000065ULL,
0x0000888034707816ULL, 0x000fe400000000ffULL, 0x00005410692c7816ULL, 0x020fe40000000059ULL,
0x00005410682d7816ULL, 0x010fe20000000054ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000000382014723cULL, 0x000b620000001814ULL, 0x00008880352e7816ULL, 0x000fca00000000ffULL,
0x000000ffff547224ULL, 0x000fe200078e002eULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x0000010034397824ULL, 0x020fe200078e00ffULL, 0x0000002c2030723cULL, 0x000b620000001830ULL,
0x000000ffff387224ULL, 0x000fc600078e0070ULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x0000005c005c7306ULL, 0x000e620000200c00ULL, 0x00000100352c7824ULL, 0x060fe400078e00ffULL,
0x0001000035357824ULL, 0x000fc600078e00ffULL, 0x00000018ff597819ULL, 0x000fe4000001142cULL,
0x0000005b005b7306ULL, 0x000eb00000200c00ULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x000054105d2c7816ULL, 0x002fce000000005cULL, 0x0000000e00567306ULL, 0x0002e20000200c00ULL,
0x00005410642d7816ULL, 0x004fce000000005bULL, 0x0000005700577306ULL, 0x000fe20000200c00ULL,
0x0000002c102c723cULL, 0x000fe20000001814ULL, 0x00000018ff0e7819ULL, 0x002fe20000011434ULL,
0x0001000034347824ULL, 0x000fca00078e00ffULL, 0x00000008005a7306ULL, 0x0002a20000200c00ULL,
0x0000541055567816ULL, 0x008fce0000000056ULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x00000018ff087819ULL, 0x002fce0000011437ULL, 0x0000005000507306ULL, 0x000e620000200c00ULL,
0x0000541057577816ULL, 0x004fce000000005aULL, 0x0000000c00527306ULL, 0x000fe20000200c00ULL,
0x000000561014723cULL, 0x000fee000000183cULL, 0x00000038000c7306ULL, 0x0005f00000200c00ULL,
0x00000039004d7306ULL, 0x0007e20000200c00ULL, 0x0000541060387816ULL, 0x004fce000000005fULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x000054105e397816ULL, 0x008fce0000000061ULL,
0x0000004c004c7306ULL, 0x000ff00000200c00ULL, 0x0000003a00667306ULL, 0x000ff00000200c00ULL,
0x0000003b00657306ULL, 0x0005f00000200c00ULL, 0x0000004300437306ULL, 0x000ee20000200c00ULL,
0x000000381038723cULL, 0x004bee0000001828ULL, 0x00008880362a7816ULL, 0x020fe200000000ffULL,
0x0000004400447306ULL, 0x000ea20000200c00ULL, 0x00005410502b7816ULL, 0x002fc40000000053ULL,
0x00000018ff287819ULL, 0x000fe20000011434ULL, 0x000000ffff3c7224ULL, 0x000fe200078e002aULL,
0x00005410512a7816ULL, 0x000fe2000000004fULL, 0x0000010036347824ULL, 0x040fe200078e00ffULL,
0x00000018ff297819ULL, 0x000fe20000011435ULL, 0x0000004500457306ULL, 0x000e620000200c00ULL,
0x0000888037357816ULL, 0x000fe200000000ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000002a2024723cULL, 0x000b620000001824ULL,
0x0000541066647816ULL, 0x008fc60000000043ULL, 0x0000004e004e7306ULL, 0x000ee20000200c00ULL,
0x0000541065657816ULL, 0x004fe40000000044ULL, 0x000054106a2a7816ULL, 0x020fe40000000047ULL,
0x00005410672b7816ULL, 0x000fc6000000004cULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x0000541045467816ULL, 0x002fe20000000046ULL, 0x000000642048723cULL, 0x040fec0000001848ULL,
0x0000004200427306ULL, 0x000e620000200c00ULL, 0x000054104e477816ULL, 0x008fe20000000052ULL,
0x0000002a201c723cULL, 0x040b6c000000181cULL, 0x00000034003d7306ULL, 0x0005e20000200c00ULL,
0x00000100372b7824ULL, 0x020fe200078e00ffULL, 0x000000462018723cULL, 0x000b620000001818ULL,
0x000000ffff2a7224ULL, 0x000fc400078e0035ULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x000054106b357816ULL, 0x002fe20000000042ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x000054106c347816ULL, 0x004fe40000000041ULL,
0x00000018ff207819ULL, 0x020fe40000011436ULL, 0x00000018ff3f7819ULL, 0x000fc60000011437ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x000000341034723cULL, 0x000b6e0000001830ULL,
0x0000003c003c7306ULL, 0x000eb00000200c00ULL, 0x0000000e000e7306ULL, 0x000fe20000200c00ULL,
0x0000541054217816ULL, 0x002fce0000000059ULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x000054103c3c7816ULL, 0x004fce000000003dULL, 0x0000000300037306ULL, 0x000ff00000200c00ULL,
0x0000000800087306ULL, 0x000ff00000200c00ULL, 0x0000002800287306ULL, 0x000e700000200c00ULL,
0x0000002900297306ULL, 0x000eb00000200c00ULL, 0x0000002a002a7306ULL, 0x000fe20000200c00ULL,
0x0000541028287816ULL, 0x002fce000000000eULL, 0x0000002b002b7306ULL, 0x000e620000200c00ULL,
0x0000541029297816ULL, 0x004fce0000000040ULL, 0x00000020003e7306ULL, 0x0004f00000200c00ULL,
0x0000003f00317306ULL, 0x020f220000200c00ULL, 0x000054100c207816ULL, 0x004fe4000000004dULL,
0x000054102a3d7816ULL, 0x002fc4000000002bULL, 0x000054103e307816ULL, 0x008fc60000000003ULL,
0x000000201024723cULL, 0x000b620000001824ULL, 0x0000541031317816ULL, 0x010fce0000000008ULL,
0x000000281020723cULL, 0x040b70000000181cULL, 0x0000003c1018723cULL, 0x040b700000001818ULL,
0x000000301030723cULL, 0x000b620000001848ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fda0000008000ULL,
0x0000000009087f8cULL, 0x000e62000c80043fULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000f6a0710c7811ULL, 0x000fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000cff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff037224ULL, 0x002fe200078e0009ULL,
0x0000001000001944ULL, 0x000fe20003c00000ULL, 0xffff646000007947ULL, 0x000fea000383ffffULL,
0x000000ff6300720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x018000000f007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000b15000047802ULL, 0x002fc40000000f00ULL,
0x0000753000007944ULL, 0x024fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000f00007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x008fc8000000000fULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006b00ff037624ULL, 0x000fe400078e00ffULL,
0x00006a00ff027624ULL, 0x000fca00078e00ffULL, 0x0000000802037981ULL, 0x000f28000c1e9900ULL,
0x0000000000047919ULL, 0x002e680000000000ULL, 0x0000000000077919ULL, 0x004ea20000000000ULL,
0x00000002ff067819ULL, 0x002fe40000011604ULL, 0x0000000807047811ULL, 0x004fe200078ff0ffULL,
0x0000000003057220ULL, 0x018fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000003800387220ULL, 0x042fe20000410000ULL,
0x0000003900397220ULL, 0x040fe20000410000ULL, 0x0000002c002c7220ULL, 0x040fe20000410000ULL,
0x0000002d002d7220ULL, 0x040fe20000410000ULL, 0x0000001400147220ULL, 0x040fe20000410000ULL,
0x0000001500157220ULL, 0x040fe20000410000ULL, 0x0000003400347220ULL, 0x040fe20000410000ULL,
0x0000003500357220ULL, 0x040fe20000410000ULL, 0x0000002400247220ULL, 0x060fe20000410000ULL,
0x0000002500257220ULL, 0x040fe20000410000ULL, 0x0000002000207220ULL, 0x040fe20000410000ULL,
0x0000002100217220ULL, 0x040fe20000410000ULL, 0x0000001800187220ULL, 0x040fe20000410000ULL,
0x0000001900197220ULL, 0x040fe20000410000ULL, 0x0000003000307220ULL, 0x040fe20000410000ULL,
0x0000003100317220ULL, 0x000fe20000410000ULL, 0x0000003a043a7220ULL, 0x044fe20000410000ULL,
0x0000003b043b7220ULL, 0x040fe20000410000ULL, 0x0000002e042e7220ULL, 0x040fe20000410000ULL,
0x0000002f042f7220ULL, 0x040fe20000410000ULL, 0x0000001604167220ULL, 0x040fe20000410000ULL,
0x0000001704177220ULL, 0x040fe20000410000ULL, 0x0000003604367220ULL, 0x040fe20000410000ULL,
0x0000003704377220ULL, 0x040fe20000410000ULL, 0x0000002604267220ULL, 0x040fe20000410000ULL,
0x0000002704277220ULL, 0x040fe20000410000ULL, 0x0000002204227220ULL, 0x040fe20000410000ULL,
0x0000002304237220ULL, 0x040fe20000410000ULL, 0x0000001a041a7220ULL, 0x040fe20000410000ULL,
0x0000001b041b7220ULL, 0x040fe20000410000ULL, 0x0000003204327220ULL, 0x040fe20000410000ULL,
0x0000003304337220ULL, 0x000fc20000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x000000202120723eULL, 0x020fc400000000ffULL, 0x000000181918723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000161716723eULL, 0x000fe400000000ffULL,
0x00000036370b723eULL, 0x000fe400000000ffULL, 0x000000262726723eULL, 0x000fc400000000ffULL,
0x000000222313723eULL, 0x000fe400000000ffULL, 0x0000001a1b1a723eULL, 0x000fe400000000ffULL,
0x00000032330d723eULL, 0x000fe400000000ffULL, 0x000000ff5800720cULL, 0x000fe40003f05270ULL,
0x00000002ff057819ULL, 0x00afe40000011600ULL, 0x0000000200027812ULL, 0x000fc400078ec0ffULL,
0x0000000800077811ULL, 0x004fe200078ff0ffULL, 0x0000000805097824ULL, 0x040fe200078e00ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x00000008050c7824ULL, 0x000fe200078e00ffULL,
0x0000000702037211ULL, 0x000fe200078ff8ffULL, 0x00000008070e7824ULL, 0x000fe200078e00ffULL,
0x0000000204027810ULL, 0x040fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0x0000000404067810ULL, 0x000fe40007ffe0ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL,
0x000010006d037824ULL, 0x000fe200078e00ffULL, 0xfffffff809087812ULL, 0x000fc400078ee202ULL,
0xfffffff807027812ULL, 0x000fe200078ee204ULL, 0x0000080058057824ULL, 0x000fe200078e0203ULL,
0x0000000604077810ULL, 0x000fe20007ffe0ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff8090a7812ULL, 0x000fe200078ee206ULL, 0x0000001002067824ULL, 0x000fe200078e0205ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x0000001008087824ULL, 0x100fe200078e0205ULL,
0x0000000804077812ULL, 0x000fe200078ec0ffULL, 0x000000100e0e7824ULL, 0x100fe200078e0205ULL,
0x000000383902723eULL, 0x000fe200000000ffULL, 0x000000100a0a7824ULL, 0x000fe200078e0205ULL,
0x0000002c2d04723eULL, 0x000fe200000000ffULL, 0x0000000106067824ULL, 0x000fe200078e0207ULL,
0x000076321a097816ULL, 0x000fe2000000000dULL, 0x0000000107087824ULL, 0x040fe200078e0208ULL,
0x0000541002107816ULL, 0x100fe20000000004ULL, 0x000000100c0c7824ULL, 0x000fe200078e0205ULL,
0x0000763202117816ULL, 0x000fe20000000004ULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x000000141502723eULL, 0x000fe200000000ffULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x000000343504723eULL, 0x000fe200000000ffULL, 0x0000001006007388ULL, 0x0003e20000000a00ULL,
0x000000242505723eULL, 0x000fe200000000ffULL, 0x0000000107077824ULL, 0x000fe200078e020cULL,
0x00000030310c723eULL, 0x000fc400000000ffULL, 0x0000541002107816ULL, 0x142fe40000000004ULL,
0x0000763202117816ULL, 0x000fe40000000004ULL, 0x0000003a3b02723eULL, 0x000fe400000000ffULL,
0x0000002e2f04723eULL, 0x000fe200000000ffULL, 0x0000001008007388ULL, 0x0003e40000000a00ULL,
0x0000541005107816ULL, 0x142fe40000000020ULL, 0x0000763205117816ULL, 0x000fc40000000020ULL,
0x0000763216057816ULL, 0x000fc6000000000bULL, 0x000000100a007388ULL, 0x0003e40000000a00ULL,
0x0000541018107816ULL, 0x142fe4000000000cULL, 0x0000763218117816ULL, 0x000fca000000000cULL,
0x0000001007007388ULL, 0x0003e40000000a00ULL, 0x0000541002107816ULL, 0x142fe40000000004ULL,
0x0000763202117816ULL, 0x000fe20000000004ULL, 0x0000000175027824ULL, 0x000fe200078e0200ULL,
0x0000541016047816ULL, 0x000fc6000000000bULL, 0x000000100e007388ULL, 0x000fe20000000a00ULL,
0x0000001002027824ULL, 0x000fc600078e0203ULL, 0x0004000408007388ULL, 0x0003e40000000a00ULL,
0x0000541026047816ULL, 0x142fe40000000013ULL, 0x0000763226057816ULL, 0x000fe40000000013ULL,
0x000054101a087816ULL, 0x000fc6000000000dULL, 0x000400040a007388ULL, 0x000fe80000000a00ULL,
0x0004000807007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000020c7984ULL, 0x000e680000000c00ULL, 0x0004000002147984ULL, 0x000ea80000000c00ULL,
0x0008000002107984ULL, 0x000ee80000000c00ULL, 0x000c000002187984ULL, 0x000f220000000c00ULL,
0x200000ff0f0f7230ULL, 0x002fc40000000000ULL, 0x200000ff0e0e7230ULL, 0x000fe40000000000ULL,
0x200000ff0d0d7230ULL, 0x000fe40000000000ULL, 0x200000ff0c0c7230ULL, 0x000fe40000000000ULL,
0x200000ff17177230ULL, 0x004fe40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fc40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x000000130f0f7230ULL, 0x008fe40000000000ULL, 0x000000120e0e7230ULL, 0x000fe40000000000ULL,
0x000000110d0d7230ULL, 0x000fe40000000000ULL, 0x000000100c0c7230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x010fc40000000000ULL, 0x0000001a16167230ULL, 0x000fe20000000000ULL,
0x0000000c02007388ULL, 0x000fe20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fca0000000000ULL, 0x0004001402007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x000fc80000011600ULL, 0x000000730700720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107027824ULL, 0x100fe200078e0200ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x00005a0072727a19ULL, 0x000fe200000006ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000000702057812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x00000007000e7812ULL, 0x000fe400078ec0ffULL, 0x0ffffff805027812ULL, 0x000fe200078ef800ULL,
0x0000580000067ab9ULL, 0x000fc80000000800ULL, 0x0000001002047824ULL, 0x000fe400078e0203ULL,
0x0000001074027824ULL, 0x000fe400078e0207ULL, 0x000000086d077824ULL, 0x000fe200078e020eULL,
0x0000000004087984ULL, 0x0004e40000000c00ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff067a19ULL, 0x000fe20000011602ULL, 0x00000006040472a4ULL, 0x002fc4000f8e023fULL,
0x0000000172057824ULL, 0x000fc800078e0205ULL, 0x0000007906057224ULL, 0x000fe200078e0205ULL,
0x0000002000067810ULL, 0x000fe20007ffe0ffULL, 0x0000000479027c24ULL, 0x000fc6000f8e02ffULL,
0x00000003ff0d7819ULL, 0x000fe40000011606ULL, 0x0000000502057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x004fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440cULL, 0x000000730d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0083ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x102fe200078e020dULL,
0x00000040000c7810ULL, 0x000fe20007ffe0ffULL, 0x00000010740d7824ULL, 0x000fc600078e020dULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef806ULL,
0x000000050d057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x0000001004077824ULL, 0x000fe200078e0203ULL, 0x00005a00ff047a19ULL, 0x000fe2000001160dULL,
0x0000000172057824ULL, 0x000fe200078e0205ULL, 0x00000003ff0d7819ULL, 0x000fe4000001160cULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000007904057224ULL, 0x000fca00078e0205ULL,
0x0000000502057210ULL, 0x000fe20007f1e0ffULL, 0x000000086d077824ULL, 0x002fc800078e0206ULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000730d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c047824ULL, 0x102fe200078e020dULL,
0x0000006000007810ULL, 0x000fe20007ffe0ffULL, 0x00000010740d7824ULL, 0x000fc600078e020dULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef80cULL,
0x000000050d057c12ULL, 0x000fe4000f8e30ffULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x00005a00ff047a19ULL, 0x000fe2000001160dULL,
0x0000000172057824ULL, 0x000fe200078e0205ULL, 0x00000003ff0d7819ULL, 0x000fe20000011600ULL,
0x000000086d077824ULL, 0x000fe200078e020cULL, 0x0000000006087984ULL, 0x0002a20000000c00ULL,
0x0000007904057224ULL, 0x000fca00078e0205ULL, 0x0000000502057210ULL, 0x000fe20007f1e0ffULL,
0x0000000100067824ULL, 0x002fc800078e020dULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x000000730d00720cULL, 0x000fc60003f06070ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x0000000706077812ULL, 0x000fc800078ec0ffULL, 0xfffffff807067812ULL, 0x000fe200078ef800ULL,
0x0000000804007986ULL, 0x0043e8000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001006067824ULL, 0x000fe200078e0203ULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x00000010740d7824ULL, 0x000fc800078e020dULL, 0x0000000006047984ULL, 0x002e620000000c00ULL,
0x000000050d037c12ULL, 0x000fe2000f8e30ffULL, 0x000000086d6d7824ULL, 0x000fe200078e0200ULL,
0x00005a00ff087a19ULL, 0x000fc6000001160dULL, 0x0000000172037824ULL, 0x000fc800078e0203ULL,
0x0000007908037224ULL, 0x000fca00078e0203ULL, 0x0000000302037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fca00000f4408ULL, 0x000000106d027825ULL, 0x000fca00078e0002ULL,
0x0000000402007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006a00ff047624ULL, 0x000fe400078e00ffULL, 0x00006b00ff057624ULL, 0x000fca00078e00ffULL,
0x0000000804617981ULL, 0x000522000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0600780cULL, 0x000fe20003f04070ULL, 0x000000020c077824ULL, 0x002fe200078e00ffULL,
0x00f60000ff047f8cULL, 0x004e62000c80043fULL, 0x0000004000737824ULL, 0x000fe400078e00ffULL,
0x0000590007647a24ULL, 0x000fc800078e0272ULL, 0x0000660064177a24ULL, 0x000fc800078e0273ULL,
0x0000060000000947ULL, 0x000fea0003800000ULL, 0x00000002ff1a7819ULL, 0x000fe40000011602ULL,
0x00001000001b7811ULL, 0x000fe400078e68ffULL, 0x000000081a137810ULL, 0x040fe20007ffe0ffULL,
0x0000000117067824ULL, 0x040fe200078e021aULL, 0x000000181a1e7810ULL, 0x040fe40007ffe0ffULL,
0x000000101a1c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000117087824ULL, 0x000fe200078e0213ULL,
0x000000201a167810ULL, 0x000fe20007ffe0ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x000000281a187810ULL, 0x000fc60007ffe0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x00000030060e7812ULL, 0x000fc600078ef803ULL, 0x00000001170c7824ULL, 0x040fe200078e021eULL,
0x0000003008107812ULL, 0x100fe200078ef803ULL, 0x00000001170a7824ULL, 0x000fe200078e021cULL,
0x000062000e0e7a10ULL, 0x000fe20007f1e0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000620010107a10ULL, 0x000fe40007f3e0ffULL, 0x00006300070f7a10ULL, 0x000fe200007fe4ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000300c087812ULL, 0x100fe400078ef803ULL,
0x0000630009117a10ULL, 0x000fe20000ffe4ffULL, 0x0000000117127824ULL, 0x000fe200078e0216ULL,
0x000000300a067812ULL, 0x000fc400078ef803ULL, 0x0000620008087a10ULL, 0x000fe40007f3e0ffULL,
0x00000073620a7217ULL, 0x000fe40007800000ULL, 0x0000620006067a10ULL, 0x000fe40007f1e0ffULL,
0x000063000d097a10ULL, 0x000fe20000ffe4ffULL, 0x000000010a0c7824ULL, 0x000fe200078e0a73ULL,
0x000063000b077a10ULL, 0x000fe200007fe4ffULL, 0x00000080120a7825ULL, 0x000fe200078e00ffULL,
0x00000002020d7211ULL, 0x000fc400078fe8ffULL, 0x0000000c1300720cULL, 0x080fe40003f26070ULL,
0x000000030d197812ULL, 0x000fe400078ec0ffULL, 0x000000300a127812ULL, 0x000fe200078ef803ULL,
0x00000004130a7824ULL, 0x000fe200078e00ffULL, 0x0ffffffc19027812ULL, 0x000fe400078ef802ULL,
0x0000620012127a10ULL, 0x000fe40007f5e0ffULL, 0xfffffffc0a0a7812ULL, 0x000fe200078ee219ULL,
0x00000010020d7824ULL, 0x100fe200078e021bULL, 0x0000000c1a00720cULL, 0x080fe20003f06070ULL,
0x0000000117027824ULL, 0x000fe200078e0218ULL, 0x000063000b137a10ULL, 0x000fe200017fe4ffULL,
0x000000100a1d7824ULL, 0x000fe200078e021bULL, 0x0000000c1c00720cULL, 0x000fe20003fa6070ULL,
0x00000080020a7825ULL, 0x000fe200078e00ffULL, 0x000000301a027810ULL, 0x000fc40007ffe0ffULL,
0x000000381a1a7810ULL, 0x000fe20007ffe0ffULL, 0x000000041c1c7824ULL, 0x000fe200078e00ffULL,
0x000000300a147812ULL, 0x000fe200078ef803ULL, 0x00000001170a7824ULL, 0x000fe200078e0202ULL,
0x0000000c1e00720cULL, 0x080fe20003f86070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0d7faeULL, 0x0005e2000c101c48ULL, 0x0000620014147a10ULL, 0x000fe40007fde0ffULL,
0x0000000c1600720cULL, 0x080fe20003f66070ULL, 0x00000000101d7faeULL, 0x0007e2000c901c48ULL,
0x000063000b157a10ULL, 0x000fe200037fe4ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000000c1800720cULL, 0x000fc40003f46070ULL, 0x0000000c0200720cULL, 0x080fe40003f26070ULL,
0x0000000c1a00720cULL, 0x000fe20003f06070ULL, 0x00000001170c7824ULL, 0x000fe200078e021aULL,
0x000000300a0a7812ULL, 0x000fe200078ef803ULL, 0x000000041e0e7824ULL, 0x004fe400078e00ffULL,
0x0000000416107824ULL, 0x008fe200078e00ffULL, 0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0xfffffffc0e0e7812ULL, 0x000fc400078ee219ULL,
0xfffffffc10107812ULL, 0x000fe200078ee219ULL, 0x0000000418167824ULL, 0x000fe200078e00ffULL,
0x000000300c037812ULL, 0x000fe200078ef803ULL, 0x0000000402187824ULL, 0x000fe200078e00ffULL,
0xfffffffc1c027812ULL, 0x100fe200078ee219ULL, 0x000000041a1a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc16167812ULL, 0x000fe200078ee219ULL, 0x000000100e117824ULL, 0x000fe200078e021bULL,
0xfffffffc18187812ULL, 0x000fe200078ee219ULL, 0x00000010020f7824ULL, 0x000fe200078e021bULL,
0xfffffffc1a1a7812ULL, 0x000fe200078ee219ULL, 0x0000001010177824ULL, 0x100fe200078e021bULL,
0x000063000b0b7a10ULL, 0x000fe200037fe4ffULL, 0x0000001016197824ULL, 0x100fe200078e021bULL,
0x0000620003027a10ULL, 0x000fe20007fde0ffULL, 0x00000010181d7824ULL, 0x100fe200078e021bULL,
0x00000000060f7faeULL, 0x0005e2000e901c48ULL, 0x000000101a1b7824ULL, 0x000fe200078e021bULL,
0x000063000d037a10ULL, 0x000fc400037fe4ffULL, 0x0000000008117faeULL, 0x0005e8000e101c48ULL,
0x0000000012177faeULL, 0x0005e8000d901c48ULL, 0x0000000014197faeULL, 0x0005e8000d101c48ULL,
0x000000000a1d7faeULL, 0x0005e8000c901c48ULL, 0x00000000021b7faeULL, 0x0005e2000c101c48ULL,
0x0000054000007947ULL, 0x000fea0003800000ULL, 0x00000010020a7811ULL, 0x040fe400078ff0ffULL,
0x00000018020c7811ULL, 0x000fc400078ff0ffULL, 0x0000002802107811ULL, 0x040fe200078ff0ffULL,
0x00000001170b7824ULL, 0x040fe200078e020aULL, 0x0000003802147811ULL, 0x040fe200078ff0ffULL,
0x00000001170d7824ULL, 0x040fe200078e020cULL, 0x0000000802167811ULL, 0x040fe200078ff0ffULL,
0x0000000117187824ULL, 0x040fe200078e0210ULL, 0x00000020020e7811ULL, 0x040fe200078ff0ffULL,
0x00000001171c7824ULL, 0x000fe200078e0214ULL, 0x0000003002127811ULL, 0x000fe200078ff0ffULL,
0x00000004161e7824ULL, 0x000fe200078e00ffULL, 0x0000000202077211ULL, 0x000fe200078fe8ffULL,
0x000000040a0a7824ULL, 0x000fe200078e00ffULL, 0x0000001702067211ULL, 0x000fe200078ff0ffULL,
0x000000040c0c7824ULL, 0x000fe200078e00ffULL, 0x0000000307097812ULL, 0x000fe200078ec0ffULL,
0x000000040e207824ULL, 0x000fe200078e00ffULL, 0x0000100000237811ULL, 0x000fe200078e68ffULL,
0x0000000410107824ULL, 0x000fe200078e00ffULL, 0x0ffffffc09157812ULL, 0x000fe200078ef802ULL,
0x0000000412227824ULL, 0x000fe200078e00ffULL, 0xfffffffc1e027812ULL, 0x100fe200078ee209ULL,
0x0000000414147824ULL, 0x000fe200078e00ffULL, 0xfffffffc0c0f7812ULL, 0x100fe200078ee209ULL,
0x0000000117087824ULL, 0x040fe200078e0216ULL, 0xfffffffc20117812ULL, 0x100fe200078ee209ULL,
0x0000000117167824ULL, 0x040fe200078e020eULL, 0xfffffffc0a0e7812ULL, 0x100fe200078ee209ULL,
0x00000001171a7824ULL, 0x000fe200078e0212ULL, 0xfffffffc10127812ULL, 0x100fe200078ee209ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0xfffffffc22137812ULL, 0x000fc400078ee209ULL,
0xfffffffc14147812ULL, 0x000fe200078ee209ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000003006107812ULL, 0x000fc600078ef803ULL, 0x000000800b0a7825ULL, 0x000fe200078e00ffULL,
0x0000620010107a10ULL, 0x000fc60007f1e0ffULL, 0x00000010121f7824ULL, 0x000fe200078e0223ULL,
0x0000003008127812ULL, 0x000fe200078ef803ULL, 0x0000001015257824ULL, 0x000fe200078e0223ULL,
0x000000300a157812ULL, 0x000fe200078ef803ULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x0000620012127a10ULL, 0x000fc60007f3e0ffULL, 0x0000001002177824ULL, 0x000fe200078e0223ULL,
0x000000300c0c7812ULL, 0x000fe200078ef803ULL, 0x000000100e197824ULL, 0x100fe400078e0223ULL,
0x000000100f1b7824ULL, 0x100fe400078e0223ULL, 0x00000010111d7824ULL, 0x100fe200078e0223ULL,
0x0000630007117a10ULL, 0x000fe200007fe4ffULL, 0x0000001013217824ULL, 0x100fe200078e0223ULL,
0x0000630009137a10ULL, 0x000fe20000ffe4ffULL, 0x0000001014237824ULL, 0x000fe200078e0223ULL,
0x0000620015147a10ULL, 0x000fe20007f5e0ffULL, 0x0000008016067825ULL, 0x000fe200078e00ffULL,
0x000062000c0c7a10ULL, 0x000fe20007f1e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010257faeULL, 0x0005e2000b901c48ULL, 0x000063000b157a10ULL, 0x000fe200017fe4ffULL,
0x0000008018087825ULL, 0x000fe200078e00ffULL, 0x0000003006027812ULL, 0x100fe200078ef803ULL,
0x0000000012177faeULL, 0x0005e2000b901c48ULL, 0x000063000d0d7a10ULL, 0x000fe200007fe4ffULL,
0x000000801a0a7825ULL, 0x000fe200078e00ffULL, 0x0000003008067812ULL, 0x100fe200078ef803ULL,
0x0000000014197faeULL, 0x0005e2000b901c48ULL, 0x0000620002027a10ULL, 0x000fe20007f1e0ffULL,
0x000000801c0e7825ULL, 0x000fe200078e00ffULL, 0x000000300a087812ULL, 0x000fe200078ef803ULL,
0x000000000c1b7faeULL, 0x0005e2000b901c48ULL, 0x0000620006067a10ULL, 0x000fc40007f3e0ffULL,
0x000000300e037812ULL, 0x000fe400078ef803ULL, 0x0000620008087a10ULL, 0x000fe40007f5e0ffULL,
0x00006200030a7a10ULL, 0x000fe40007f7e0ffULL, 0x0000630007037a10ULL, 0x000fe400007fe4ffULL,
0x0000630009077a10ULL, 0x000fe40000ffe4ffULL, 0x000063000b097a10ULL, 0x000fe200017fe4ffULL,
0x00000000021d7faeULL, 0x0005e2000b901c48ULL, 0x000063000f0b7a10ULL, 0x000fc60001ffe4ffULL,
0x00000000061f7faeULL, 0x0005e8000b901c48ULL, 0x0000000008217faeULL, 0x0005e8000b901c48ULL,
0x000000000a237faeULL, 0x0005e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000027805ULL, 0x004fc40000015200ULL, 0x00f60400ff077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x006fc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000602097210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e03ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000906067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000002000027824ULL, 0x002fca00078e0203ULL, 0x00000003ff037819ULL, 0x000fc80000011602ULL,
0x1ffffffe03057812ULL, 0x000fe400078ec0ffULL, 0x0000000f02037812ULL, 0x000fc600078ec0ffULL,
0x0000000102057824ULL, 0x000fe400078e0205ULL, 0x0000001003077824ULL, 0x040fe400078e00ffULL,
0x0000001003047824ULL, 0x000fe200078e00ffULL, 0x0000000f05027812ULL, 0x040fe400078ec0ffULL,
0x0000000105057810ULL, 0x000fe40007ffe0ffULL, 0x000000f007027812ULL, 0x000fe400078ee202ULL,
0x0000000f05057812ULL, 0x000fc600078ec0ffULL, 0x00000000020c7984ULL, 0x000e62000000cc00ULL,
0x000000f004057812ULL, 0x000fca00078ee205ULL, 0x0000000005087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fe400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fc400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001002007388ULL, 0x0003e8000000cc00ULL, 0x0000000c05007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff067f8cULL, 0x000ea2000c80043fULL,
0x000000ffff087224ULL, 0x000fc600078e00ffULL, 0x0000000000027805ULL, 0x002fc80000015200ULL,
0x00f60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x006fc40007804807ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402097210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000900780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400900780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000904047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff6300720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x0000001fff047424ULL, 0x000fe200078e00ffULL, 0x80005800626e7a10ULL, 0x000fe20007ffe0ffULL,
0x00000001ff6f7424ULL, 0x000fe200078e00ffULL, 0x3db504f361617820ULL, 0x010fe20000410000ULL,
0x00005800ff687624ULL, 0x000fe200078e00ffULL, 0x0000580004047a10ULL, 0x000fe20007ffe0ffULL,
0x000000ffff5e7224ULL, 0x000fe200078e00ffULL, 0x0000f68800727811ULL, 0x000fe200078e18ffULL,
0x000000ffff037224ULL, 0x000fe200078e00ffULL, 0x00000004ff047819ULL, 0x000fc40000011604ULL,
0x0000f60800747811ULL, 0x000fe400078e28ffULL, 0x000058006f6f7a10ULL, 0x000fe40007ffe1ffULL,
0x0000000968687810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff6e7819ULL, 0x000fe4000001166eULL,
0x0ffffffe046c7812ULL, 0x000fc400078ec0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e0003ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000000ffff047224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x00cfc4000001ff00ULL,
0x000000010400780cULL, 0x000fe20003f25270ULL, 0x00000bc000007945ULL, 0x000fe20003800000ULL,
0x000000015e067810ULL, 0x000fc40007ffe0ffULL, 0x0000000104077810ULL, 0x000fe40007ffe0ffULL,
0x0000000105037812ULL, 0x000fe400078e0cffULL, 0x000000020700780cULL, 0x000fca0003f06070ULL,
0x000000ffff061224ULL, 0x000fc800078e025eULL, 0x00000100060f7824ULL, 0x040fe200078e0273ULL,
0x0000000106087810ULL, 0x000fe40007ffe0ffULL, 0x000000ff07067207ULL, 0x000fe20000800000ULL,
0x0000660064097a24ULL, 0x000fe200078e020fULL, 0x000000630800720cULL, 0x000fe20003f46070ULL,
0x000000ffff087224ULL, 0x000fe400078e0004ULL, 0x000000ffff047224ULL, 0x000fd400078e0007ULL,
0x000005d00000a947ULL, 0x020fea0003800000ULL, 0x0000001002077824ULL, 0x002fe200078e00ffULL,
0x00000002ff1c7819ULL, 0x000fe20000011602ULL, 0x00000002001b7824ULL, 0x000fe200078e0203ULL,
0x0000000f620e7217ULL, 0x000fe40007800000ULL, 0x0000003007077812ULL, 0x000fe200078ec0ffULL,
0x000000011c0b7824ULL, 0x040fe200078e0209ULL, 0x000000081c1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000010e1a7824ULL, 0x000fe200078e0a0fULL, 0x000000101c1e7810ULL, 0x000fe20007ffe0ffULL,
0x0000004006067824ULL, 0x000fe200078e0207ULL, 0x000000181c3c7810ULL, 0x040fe20007ffe0ffULL,
0x000000011d0d7824ULL, 0x100fe200078e0209ULL, 0x000010001b1b7811ULL, 0x000fe200078e60ffULL,
0x000000ffff077224ULL, 0x000fe200078e00ffULL, 0x000000201c3e7810ULL, 0x000fe20007ffe0ffULL,
0x000000011e137824ULL, 0x000fe200078e0209ULL, 0x0000001a3c00720cULL, 0x000fe20003fa6070ULL,
0x000000800d0c7825ULL, 0x000fc800078e0006ULL, 0x000000800b0a7825ULL, 0x000fe200078e0006ULL,
0x000062000c0e7a10ULL, 0x000fe40007f5e0ffULL, 0x00000002020c7211ULL, 0x000fe200078fe8ffULL,
0x000000013c197824ULL, 0x000fe200078e0209ULL, 0x000062000a107a10ULL, 0x000fe20007f3e0ffULL,
0x0000008013127825ULL, 0x100fe200078e0006ULL, 0x000000030c3f7812ULL, 0x000fe400078ec0ffULL,
0x000063000b117a10ULL, 0x000fe20000ffe4ffULL, 0x0000008019187825ULL, 0x000fe200078e0006ULL,
0x0000620012127a10ULL, 0x000fc40007f7e0ffULL, 0x000063000d0f7a10ULL, 0x000fe200017fe4ffULL,
0x000000041d407824ULL, 0x000fe200078e00ffULL, 0x00006200180a7a10ULL, 0x000fe20007f3e0ffULL,
0x000000041e427824ULL, 0x000fe200078e00ffULL, 0x0000630013137a10ULL, 0x000fe20001ffe4ffULL,
0x000000013e0d7824ULL, 0x000fe200078e0209ULL, 0x0000001a1e00720cULL, 0x000fe40003f66070ULL,
0xfffffffc401e7812ULL, 0x000fe200078ee23fULL, 0x000000800d0c7825ULL, 0x000fe200078e0006ULL,
0x00006300190b7a10ULL, 0x000fc40000ffe4ffULL, 0x0000001a1c00720cULL, 0x080fe20003f26070ULL,
0x000000101e1f7824ULL, 0x100fe200078e021bULL, 0x0ffffffc3f187812ULL, 0x000fe400078ef802ULL,
0x0000001a1d00720cULL, 0x000fe40003f46070ULL, 0x000000281c1e7810ULL, 0x000fe20007ffe0ffULL,
0x00000010181d7824ULL, 0x000fe200078e021bULL, 0xfffffffc42187812ULL, 0x000fe400078ee23fULL,
0x000000301c407810ULL, 0x000fe20007ffe0ffULL, 0x000000011e197824ULL, 0x000fe200078e0209ULL,
0x000062000c0c7a10ULL, 0x000fe20007f9e0ffULL, 0x00000010183d7824ULL, 0x000fe200078e021bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101d7faeULL, 0x0003e2000c901c48ULL,
0x0000008019187825ULL, 0x000fe200078e0006ULL, 0x000000381c1c7810ULL, 0x000fc40007ffe0ffULL,
0x000000000e1f7faeULL, 0x0005e2000d101c48ULL, 0x000063000d0d7a10ULL, 0x000fe400027fe4ffULL,
0x0000001a3e00720cULL, 0x080fe20003f86070ULL, 0x00000000123d7faeULL, 0x0007e2000d901c48ULL,
0x0000001a1e00720cULL, 0x080fe40003f66070ULL, 0x0000001a4000720cULL, 0x0c0fe20003f46070ULL,
0x0000000140117824ULL, 0x102fe200078e0209ULL, 0x0000001a1c00720cULL, 0x040fe20003f26070ULL,
0x000000011c097824ULL, 0x000fe200078e0209ULL, 0x00006200180e7a10ULL, 0x004fe20007fde0ffULL,
0x0000008011107825ULL, 0x000fc600078e0006ULL, 0x00006300190f7a10ULL, 0x000fe200037fe4ffULL,
0x000000043c127824ULL, 0x008fe200078e00ffULL, 0x0000620010107a10ULL, 0x000fe20007fde0ffULL,
0x000000043e187824ULL, 0x000fe400078e00ffULL, 0x000000041e1a7824ULL, 0x000fe200078e00ffULL,
0xfffffffc12127812ULL, 0x100fe200078ee23fULL, 0x0000000440407824ULL, 0x000fe200078e00ffULL,
0xfffffffc18187812ULL, 0x100fe200078ee23fULL, 0x000000041c1e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1a1a7812ULL, 0x000fe200078ee23fULL, 0x0000008009067825ULL, 0x000fe200078e0006ULL,
0xfffffffc401c7812ULL, 0x000fc400078ee23fULL, 0xfffffffc1e1e7812ULL, 0x000fe200078ee23fULL,
0x0000001012097824ULL, 0x100fe200078e021bULL, 0x0000630011117a10ULL, 0x000fe200037fe4ffULL,
0x0000001018137824ULL, 0x100fe200078e021bULL, 0x0000620006067a10ULL, 0x000fe20007fde0ffULL,
0x000000101a197824ULL, 0x100fe200078e021bULL, 0x000000000a097faeULL, 0x0003e2000e901c48ULL,
0x000000101c1d7824ULL, 0x100fe200078e021bULL, 0x0000630007077a10ULL, 0x000fe200037fe4ffULL,
0x000000101e1b7824ULL, 0x000fe200078e021bULL, 0x000000000c137faeULL, 0x0003e8000e101c48ULL,
0x000000000e197faeULL, 0x0003e8000d901c48ULL, 0x00000000101d7faeULL, 0x0003e8000d101c48ULL,
0x00000000061b7faeULL, 0x0003e2000c901c48ULL, 0x0000051000007947ULL, 0x000fea0003800000ULL,
0x0000001002077824ULL, 0x042fe200078e00ffULL, 0x00000008020c7811ULL, 0x000fe200078ff0ffULL,
0x00000002000b7824ULL, 0x000fe200078e0203ULL, 0x00000010020e7811ULL, 0x000fc400078ff0ffULL,
0x0000003007077812ULL, 0x000fe200078ec0ffULL, 0x000000010c0d7824ULL, 0x000fe200078e0209ULL,
0x0000001802107811ULL, 0x000fe200078ff0ffULL, 0x000000040c0c7824ULL, 0x000fe200078e00ffULL,
0x0000002002127811ULL, 0x000fe200078ff0ffULL, 0x0000004006067824ULL, 0x000fe200078e0207ULL,
0x0000002802187811ULL, 0x000fe200078ff0ffULL, 0x000000010e0f7824ULL, 0x100fe200078e0209ULL,
0x00000030021a7811ULL, 0x000fe200078ff0ffULL, 0x0000000110117824ULL, 0x100fe200078e0209ULL,
0x00000038021c7811ULL, 0x000fe200078ff0ffULL, 0x0000000112137824ULL, 0x100fe200078e0209ULL,
0x00000002020a7211ULL, 0x000fe200078fe8ffULL, 0x0000000118197824ULL, 0x000fc400078e0209ULL,
0x000000040e0e7824ULL, 0x000fe200078e00ffULL, 0x000000030a077812ULL, 0x000fe200078ec0ffULL,
0x0000000410107824ULL, 0x000fe200078e00ffULL, 0x000010000b0a7811ULL, 0x000fe200078e60ffULL,
0x0000000412127824ULL, 0x000fe200078e00ffULL, 0xfffffffc0c1d7812ULL, 0x100fe200078ee207ULL,
0x0000000418187824ULL, 0x000fe200078e00ffULL, 0xfffffffc0e1f7812ULL, 0x100fe200078ee207ULL,
0x000000041a1e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc103d7812ULL, 0x100fe200078ee207ULL,
0x000000041c3c7824ULL, 0x000fe200078e00ffULL, 0xfffffffc123f7812ULL, 0x000fe200078ee207ULL,
0x000000011a1b7824ULL, 0x000fe200078e0209ULL, 0xfffffffc18417812ULL, 0x000fe200078ee207ULL,
0x000000011c437824ULL, 0x000fe200078e0209ULL, 0xfffffffc1e457812ULL, 0x000fc400078ee207ULL,
0xfffffffc3c497812ULL, 0x000fe400078ee207ULL, 0x0ffffffc07077812ULL, 0x000fe400078ef802ULL,
0x00000009020b7211ULL, 0x000fe200078ff0ffULL, 0x000000101d097824ULL, 0x100fe400078e020aULL,
0x000000101f1d7824ULL, 0x100fe400078e020aULL, 0x0000001007477824ULL, 0x100fe400078e020aULL,
0x000000103d1f7824ULL, 0x000fc400078e020aULL, 0x000000103f3d7824ULL, 0x100fe400078e020aULL,
0x000000ffff077224ULL, 0x000fe400078e00ffULL, 0x00000010413f7824ULL, 0x100fe400078e020aULL,
0x0000001045417824ULL, 0x100fe400078e020aULL, 0x0000001049457824ULL, 0x000fe400078e020aULL,
0x000000800b0a7825ULL, 0x000fc800078e0006ULL, 0x000000800d0c7825ULL, 0x000fe200078e0006ULL,
0x000062000a0a7a10ULL, 0x000fc60007f3e0ffULL, 0x000000800f0e7825ULL, 0x100fe200078e0006ULL,
0x000062000c0c7a10ULL, 0x000fe40007f5e0ffULL, 0x000063000b0b7a10ULL, 0x000fe20000ffe4ffULL,
0x0000008011107825ULL, 0x100fe200078e0006ULL, 0x000062000e0e7a10ULL, 0x000fe40007f7e0ffULL,
0x000063000d0d7a10ULL, 0x000fe200017fe4ffULL, 0x0000008013127825ULL, 0x100fe200078e0006ULL,
0x0000620010107a10ULL, 0x000fe20007f9e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a477faeULL, 0x0003e2000b901c48ULL, 0x000063000f0f7a10ULL, 0x000fe20001ffe4ffULL,
0x0000008019187825ULL, 0x100fe200078e0006ULL, 0x0000620012127a10ULL, 0x000fe20007f3e0ffULL,
0x000000000c097faeULL, 0x0003e2000b901c48ULL, 0x0000630011117a10ULL, 0x000fe200027fe4ffULL,
0x000000801b1a7825ULL, 0x100fe200078e0006ULL, 0x0000620018187a10ULL, 0x000fe20007f5e0ffULL,
0x000000000e1d7faeULL, 0x0003e2000b901c48ULL, 0x0000630013137a10ULL, 0x000fe20000ffe4ffULL,
0x0000008043067825ULL, 0x000fe200078e0006ULL, 0x000062001a1a7a10ULL, 0x000fe20007f7e0ffULL,
0x00000000101f7faeULL, 0x0003e2000b901c48ULL, 0x0000630019197a10ULL, 0x000fc400017fe4ffULL,
0x0000620006067a10ULL, 0x000fe20007f9e0ffULL, 0x00000000123d7faeULL, 0x0003e2000b901c48ULL,
0x000063001b1b7a10ULL, 0x000fe40001ffe4ffULL, 0x0000630007077a10ULL, 0x000fe200027fe4ffULL,
0x00000000183f7faeULL, 0x0003e8000b901c48ULL, 0x000000001a417faeULL, 0x0003e8000b901c48ULL,
0x0000000006457faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000000200067824ULL, 0x002fe200078e0205ULL,
0x0000002002057810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0xfffffff802097812ULL, 0x000fc400078ec0ffULL, 0xfffffff805057812ULL, 0x000fe400078ec0ffULL,
0x00000007020b7812ULL, 0x000fe400078ec0ffULL, 0x0000000709097812ULL, 0x100fe400078ef802ULL,
0x00000007050a7812ULL, 0x100fe400078ef802ULL, 0x0000100006057811ULL, 0x000fe400078e60ffULL,
0x000000080b067812ULL, 0x000fc400078ef802ULL, 0x00000001ff607819ULL, 0x000fe40000011609ULL,
0x00000001ff5f7819ULL, 0x000fe2000001160aULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000001600b7824ULL, 0x100fe200078e0207ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000004090c7824ULL, 0x040fe400078e00ffULL, 0x0000000409197824ULL, 0x000fe400078e00ffULL,
0x0000000408757824ULL, 0x000fe200078e0207ULL, 0xfffffffc0c0c7812ULL, 0x000fe200078ee20bULL,
0x000000015f0b7824ULL, 0x000fc400078e0207ULL, 0x0000000275757824ULL, 0x000fe400078e00ffULL,
0x000000100c107824ULL, 0x020fe400078e0205ULL, 0x000000040a0c7824ULL, 0x000fe400078e00ffULL,
0x0000001006447824ULL, 0x000fe400078e00ffULL, 0x000000001010783bULL, 0x000e620000000200ULL,
0xfffffffc0c0c7812ULL, 0x000fca00078ee20bULL, 0x000000100c0c7824ULL, 0x000fcc00078e0205ULL,
0x000000000c0c783bULL, 0x000ea20000000200ULL, 0x00000018ff477819ULL, 0x002fe20000011410ULL,
0x00010000100b7824ULL, 0x040fe200078e00ffULL, 0x0000888010487816ULL, 0x040fe200000000ffULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe20000011411ULL,
0x0001000011187824ULL, 0x040fe200078e00ffULL, 0x00008880114c7816ULL, 0x040fe200000000ffULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x00000018ff0b7819ULL, 0x000fc4000001140bULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff677819ULL, 0x000fe40000011412ULL,
0x0000888012697816ULL, 0x000fe200000000ffULL, 0x0000001000767306ULL, 0x0002e20000200c00ULL,
0x00000018ff557819ULL, 0x004fe4000001140cULL, 0x000088800c547816ULL, 0x000fe400000000ffULL,
0x00000018ff5b7819ULL, 0x000fc40000011413ULL, 0x0000888013507816ULL, 0x040fe200000000ffULL,
0x0000000b004b7306ULL, 0x0005e20000200c00ULL, 0x0001000013107824ULL, 0x042fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe4000001140fULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000001100707306ULL, 0x0003e20000200c00ULL, 0x00010000120b7824ULL, 0x044fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0000010012127824ULL, 0x000fe200078e00ffULL,
0x000088800f4d7816ULL, 0x000fc400000000ffULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x0000001000667306ULL, 0x0005e20000200c00ULL, 0x0000000107117810ULL, 0x002fe40007ffe0ffULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x00000018ff567819ULL, 0x000fe4000001140eULL,
0x000088800e527816ULL, 0x000fe200000000ffULL, 0x00000012006a7306ULL, 0x0003e20000200c00ULL,
0x0000000160107824ULL, 0x004fe200078e0211ULL, 0x00000018ff577819ULL, 0x000fe2000001140dULL,
0x000000015f117824ULL, 0x000fe200078e0211ULL, 0x000088800d597816ULL, 0x000fc400000000ffULL,
0x0000000207077810ULL, 0x000fe40007ffe0ffULL, 0x0000000b006b7306ULL, 0x0005e20000200c00ULL,
0xfffffffc19127812ULL, 0x002fe200078ee210ULL, 0x000100000d107824ULL, 0x000fe200078e00ffULL,
0x000000040700780cULL, 0x000fe20003f25270ULL, 0x000001000d0d7824ULL, 0x000fe400078e00ffULL,
0x0000001012127824ULL, 0x000fe200078e0205ULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000001800717306ULL, 0x000fe20000200c00ULL, 0x000100000c0b7824ULL, 0x044fe200078e00ffULL,
0x00000018ff0d7819ULL, 0x000fe2000001140dULL, 0x00000000121c783bULL, 0x000e620000000200ULL,
0x000001000c0c7824ULL, 0x000fc400078e00ffULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x00000010005a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff0c7819ULL, 0x000fce000001140cULL,
0x0000000c005c7306ULL, 0x0005f00000200c00ULL, 0x0000001300657306ULL, 0x000fe20000200c00ULL,
0x000000040a0c7824ULL, 0x004fca00078e00ffULL, 0xfffffffc0c0c7812ULL, 0x000fe400078ee211ULL,
0x0000007502117211ULL, 0x000fe200078fe0ffULL, 0x0000004800487306ULL, 0x000ea20000200c00ULL,
0x0000000275757810ULL, 0x000fe20007ffe0ffULL, 0x000000100c187824ULL, 0x000fe400078e0205ULL,
0x0000000106117824ULL, 0x000fe200078e0211ULL, 0x0000007502757211ULL, 0x000fe200078fe0ffULL,
0x000100000f0c7824ULL, 0x000fe400078e00ffULL, 0x000000001818783bULL, 0x000f220000000200ULL,
0xfffffff044117812ULL, 0x000fe200078ee211ULL, 0x000100001c107824ULL, 0x002fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x000100001d127824ULL, 0x000fe200078e00ffULL,
0x00000018ff3f7819ULL, 0x000fe2000001141cULL, 0x0000001011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000000c00497306ULL, 0x0003e20000200c00ULL,
0x00000018ff437819ULL, 0x000fe20000011412ULL, 0x000001000f0f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe2000001141dULL, 0x0000000106757824ULL, 0x000fe200078e0275ULL,
0x000088801d427816ULL, 0x040fe200000000ffULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001141eULL, 0x0000001000417306ULL, 0x0005e20000200c00ULL,
0x000088801c0c7816ULL, 0x042fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x000088801e457816ULL, 0x040fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x000000001110783bULL, 0x004e620000000200ULL, 0x00000018ff4e7819ULL, 0x000fe4000001140fULL,
0x00000018ff3c7819ULL, 0x000fe4000001141fULL, 0x000088801f777816ULL, 0x000fe400000000ffULL,
0x0000001c00407306ULL, 0x0005f00000200c00ULL, 0x0000004c004c7306ULL, 0x000e620000200c00ULL,
0x000100001e1c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x010fe20000011418ULL,
0x000001001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000001d00447306ULL, 0x0007e20000200c00ULL, 0x00000018ff1e7819ULL, 0x000fce000001141eULL,
0x0000001c00467306ULL, 0x0005e20000200c00ULL, 0x00005410761d7816ULL, 0x008fce0000000047ULL,
0x0000006700677306ULL, 0x000ee20000200c00ULL, 0x00005410481c7816ULL, 0x004fe2000000004bULL,
0x000100001f4b7824ULL, 0x040fe400078e00ffULL, 0x000001001f1f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe2000001144bULL, 0x0000001c1038723cULL, 0x002b620000001838ULL,
0x0000006900697306ULL, 0x000e620000200c00ULL, 0x00000018ff1f7819ULL, 0x000fca000001141fULL,
0x000054104c1c7816ULL, 0x020fe40000000071ULL, 0x00005410701d7816ULL, 0x000fe2000000004aULL,
0x0000001e00487306ULL, 0x0005ec0000200c00ULL, 0x0000001c1034723cULL, 0x000be40000001834ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x00008880181e7816ULL, 0x004fc800000000ffULL,
0x00010000181c7824ULL, 0x020fe200078e00ffULL, 0x000054106a1d7816ULL, 0x008fe20000000067ULL,
0x000000ffff4a7224ULL, 0x000fe200078e001eULL, 0x0000005000507306ULL, 0x000ea20000200c00ULL,
0x00000010061e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fc8000001141cULL,
0xfffffff01e757812ULL, 0x000fe200078ee275ULL, 0x00000100181e7824ULL, 0x000fe200078e00ffULL,
0x0000000b005d7306ULL, 0x0007e80000200c00ULL, 0x00000018ff677819ULL, 0x000fe2000001141eULL,
0x00000010751e7824ULL, 0x000fc600078e00ffULL, 0x0000001c00187306ULL, 0x0003e20000200c00ULL,
0x000100000e0b7824ULL, 0x048fe400078e00ffULL, 0x000001000e0e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff0b7819ULL, 0x000fe4000001140bULL, 0x00000018ff0e7819ULL, 0x000fe2000001140eULL,
0x0000001f004c7306ULL, 0x000fe20000200c00ULL, 0x00005410691c7816ULL, 0x002fce000000006bULL,
0x0000001c1030723cULL, 0x000b620000001830ULL, 0x0000005500557306ULL, 0x000e6c0000200c00ULL,
0x00005410501c7816ULL, 0x024fe40000000066ULL, 0x00005410651d7816ULL, 0x000fe2000000005bULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x0000888019667816ULL, 0x040fe200000000ffULL,
0x0001000019657824ULL, 0x000fc800078e00ffULL, 0x0000001c102c723cULL, 0x000b62000000182cULL,
0x000054105c557816ULL, 0x002fe20000000055ULL, 0x000000001e1c783bULL, 0x020e620000000200ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x00000100195c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x000000ffff5b7224ULL, 0x000fe200078e0066ULL,
0x0000541054547816ULL, 0x004fc8000000005dULL, 0x0000005200527306ULL, 0x000fe60000200c00ULL,
0x000000541028723cULL, 0x000b6a0000001828ULL, 0x0000000b00517306ULL, 0x0004f00000200c00ULL,
0x0000000e00537306ULL, 0x0008620000200c00ULL, 0x00000018ff0b7819ULL, 0x004fce000001141bULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x0000541052527816ULL, 0x008fe40000000051ULL,
0x00000018ff0e7819ULL, 0x010fca0000011419ULL, 0x0000005900597306ULL, 0x000ea20000200c00ULL,
0x0000541053537816ULL, 0x002fce0000000056ULL, 0x0000000d00587306ULL, 0x0002e20000200c00ULL,
0x000000521020723cULL, 0x000bee0000001820ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x0000541059547816ULL, 0x024fe4000000005aULL, 0x00000018ff0d7819ULL, 0x002fca000001141aULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x0000541058557816ULL, 0x008fce0000000057ULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x000000541024723cULL, 0x000b6e0000001824ULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x000054104d527816ULL, 0x002fe40000000049ULL,
0x000088801a557816ULL, 0x020fc400000000ffULL, 0x00000018ff547819ULL, 0x000fc6000001145cULL,
0x0000000c000c7306ULL, 0x000e620000200c00ULL, 0x000054104e537816ULL, 0x004fe2000000004fULL,
0x000000ffff517224ULL, 0x000fe400078e0055ULL, 0x000100001a557824ULL, 0x040fe400078e00ffULL,
0x000001001a1a7824ULL, 0x000fe400078e00ffULL, 0x0000003d003d7306ULL, 0x000ea20000200c00ULL,
0x000000521014723cULL, 0x000b6e0000001814ULL, 0x0000004500457306ULL, 0x000ee20000200c00ULL,
0x000054100c107816ULL, 0x022fe20000000041ULL, 0x000100001b137824ULL, 0x000fe200078e00ffULL,
0x0000541040117816ULL, 0x000fc4000000003fULL, 0x00000018ff0c7819ULL, 0x000fe4000001141aULL,
0x00000018ff127819ULL, 0x000fe20000011455ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x000000101c38723cULL, 0x000b6c0000001838ULL,
0x0000007700477306ULL, 0x000fe20000200c00ULL, 0x000088801b107816ULL, 0x020fc400000000ffULL,
0x0000541048117816ULL, 0x004fca000000003dULL, 0x00000010001a7306ULL, 0x0007f00000200c00ULL,
0x0000004b004b7306ULL, 0x000e620000200c00ULL, 0x0000541045107816ULL, 0x008fce0000000046ULL,
0x000000101c30723cULL, 0x000b620000001830ULL, 0x0000004200427306ULL, 0x000fec0000200c00ULL,
0x000001001b117824ULL, 0x020fe200078e00ffULL, 0x0000541047107816ULL, 0x002fe2000000004bULL,
0x0000004300437306ULL, 0x000e660000200c00ULL, 0x00000018ff3d7819ULL, 0x000fc40000011411ULL,
0x000054104c117816ULL, 0x000fc6000000003cULL, 0x00000013001b7306ULL, 0x000ea80000200c00ULL,
0x000000101c2c723cULL, 0x000b68000000182cULL, 0x0000003e003e7306ULL, 0x000ee20000200c00ULL,
0x0000541042427816ULL, 0x002fce0000000043ULL, 0x0000000f000f7306ULL, 0x000fe20000200c00ULL,
0x000054101a1a7816ULL, 0x004fce000000001bULL, 0x0000000e000e7306ULL, 0x000fe20000200c00ULL,
0x0000541044437816ULL, 0x008fce000000003eULL, 0x0000000d000d7306ULL, 0x000fe20000200c00ULL,
0x000000421c34723cULL, 0x000b6e0000001834ULL, 0x0000000b000b7306ULL, 0x000ff00000200c00ULL,
0x0000004a004a7306ULL, 0x000e700000200c00ULL, 0x0000006700507306ULL, 0x000eb00000200c00ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x000054104a4a7816ULL, 0x002fce0000000018ULL,
0x0000006500197306ULL, 0x000e620000200c00ULL, 0x00005410504b7816ULL, 0x004fce000000000fULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x0000004a1c28723cULL, 0x000b6e0000001828ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000054105b107816ULL, 0x022fce0000000019ULL,
0x0000001200127306ULL, 0x000e620000200c00ULL, 0x0000541054117816ULL, 0x004fce000000000eULL,
0x0000000c000c7306ULL, 0x000ea20000200c00ULL, 0x000000101c24723cULL, 0x000b6e0000001824ULL,
0x0000003d003c7306ULL, 0x000ee20000200c00ULL, 0x0000541051127816ULL, 0x002fe40000000012ULL,
0x000054100c137816ULL, 0x004fce000000000dULL, 0x000000121c20723cULL, 0x000b620000001820ULL,
0x000054103c1b7816ULL, 0x008fce000000000bULL, 0x0000001a1c14723cULL, 0x000b620000001814ULL,
0xfffff05000001947ULL, 0x000fce000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff057224ULL, 0x000fe200078e0003ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe35000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000006131317220ULL, 0x080fe20000410000ULL, 0x000000612d2d7220ULL, 0x080fe20000410000ULL,
0x0000006139397220ULL, 0x080fe20000410000ULL, 0x0000006134347220ULL, 0x080fe20000410000ULL,
0x0000006135357220ULL, 0x080fe20000410000ULL, 0x0000006130307220ULL, 0x080fe20000410000ULL,
0x000000612c047220ULL, 0x080fe20000410000ULL, 0x000000612f067220ULL, 0x080fe20000410000ULL,
0x0000006120207220ULL, 0x0a0fe20000410000ULL, 0x00000061282f7220ULL, 0x080fe20000410000ULL,
0x0000006126127220ULL, 0x080fe20000410000ULL, 0x0000006122137220ULL, 0x080fe20000410000ULL,
0x000000612e1f7220ULL, 0x080fe20000410000ULL, 0x0000006129287220ULL, 0x080fe20000410000ULL,
0x000000612b117220ULL, 0x080fe20000410000ULL, 0x0000006115227220ULL, 0x080fe20000410000ULL,
0x000000ffff267224ULL, 0x000fe200078e0031ULL, 0x0000006124297220ULL, 0x080fe20000410000ULL,
0x00000061252e7220ULL, 0x080fe20000410000ULL, 0x0000006127187220ULL, 0x080fe20000410000ULL,
0x00000061212b7220ULL, 0x080fe20000410000ULL, 0x0000006123087220ULL, 0x080fe20000410000ULL,
0x0000006116157220ULL, 0x080fe20000410000ULL, 0x000000ffff317224ULL, 0x000fe200078e002dULL,
0x0000006138197220ULL, 0x080fe20000410000ULL, 0x000000613a1c7220ULL, 0x080fe20000410000ULL,
0x000000613b1a7220ULL, 0x080fe20000410000ULL, 0x00000061361b7220ULL, 0x080fe20000410000ULL,
0x0000006137377220ULL, 0x080fe20000410000ULL, 0x00000061321e7220ULL, 0x080fe20000410000ULL,
0x00000061331d7220ULL, 0x080fe20000410000ULL, 0x000000612a077220ULL, 0x080fe20000410000ULL,
0x0000006114217220ULL, 0x080fe20000410000ULL, 0x0000006117167220ULL, 0x000fe20000410000ULL,
0x000000ffff237224ULL, 0x000fc400078e0039ULL, 0x000000ffff247224ULL, 0x000fe400078e0034ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0035ULL, 0x000000ffff257224ULL, 0x000fe400078e0030ULL,
0x000000ffff277224ULL, 0x000fe400078e0004ULL, 0x000000ffff2d7224ULL, 0x000fe200078e0020ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000072047f8cULL, 0x0002a2000c80043fULL,
0x000000ffff2a7224ULL, 0x000fc400078e0037ULL, 0x000000ffff307224ULL, 0x000fe400078e0006ULL,
0x000000ffff207224ULL, 0x000fe400078e0007ULL, 0x000000ffff147224ULL, 0x000fc400078e0008ULL,
0x0000000000067805ULL, 0x000fca0000015200ULL, 0x0000040072097984ULL, 0x000ee40000000800ULL,
0x8000000009ff7812ULL, 0x00cfe40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x00000008060b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011409ULL, 0x0000000b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff097224ULL, 0x000fca00000e0609ULL, 0x0000000208087819ULL, 0x000fc80000001209ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040072097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000402177824ULL, 0x000fe200078e00ffULL,
0x0000006e5e00720cULL, 0x000fc80003f06070ULL, 0xfffffff017057812ULL, 0x000fca00078ec0ffULL,
0x0000008000107824ULL, 0x000fca00078e0205ULL, 0x00f4000010047984ULL, 0x0004e20000000c00ULL,
0x0000136000008947ULL, 0x000fea0003800000ULL, 0x000001005e357824ULL, 0x000fe200078e0273ULL,
0x0000006d02097211ULL, 0x040fe200078ff0ffULL, 0x0000000202337824ULL, 0x000fe400078e00ffULL,
0x00000002ff457424ULL, 0x000fe200078e00ffULL, 0x0000003562087217ULL, 0x000fe40007800000ULL,
0x0000000633337812ULL, 0x000fe400078ec0ffULL, 0x00000008090b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000108357824ULL, 0x000fe200078e0a35ULL, 0x00005a00ff087a19ULL, 0x000fe20000011609ULL,
0x00000001680a7824ULL, 0x000fe200078e0233ULL, 0x0000580033327a10ULL, 0x000fc40007ffe0ffULL,
0x000000086f097217ULL, 0x000fe40003800000ULL, 0x000000350a00720cULL, 0x040fe20003f26070ULL,
0x000000010a0a7824ULL, 0x100fe200078e0a35ULL, 0x0000001033367812ULL, 0x000fe200078efcffULL,
0x0000000132087824ULL, 0x000fe200078e0a35ULL, 0x00005a00ff0c7a19ULL, 0x000fe2000001160bULL,
0x000000096c507224ULL, 0x000fe200078e02ffULL, 0x0000000a6f0a7217ULL, 0x000fe40003800000ULL,
0x000000353200720cULL, 0x000fc40003f06070ULL, 0x000000086f087217ULL, 0x040fe40003800000ULL,
0x00000004ff0a7819ULL, 0x000fe4000001160aULL, 0x00005800363a7a10ULL, 0x000fe40007ffe0ffULL,
0x0000000c6f0b7217ULL, 0x000fe40003800000ULL, 0x000000ff08387207ULL, 0x000fe40000000000ULL,
0x000000ff0a097207ULL, 0x000fe20000800000ULL, 0x0000000168407824ULL, 0x000fe200078e0236ULL,
0x00000050380e7211ULL, 0x000fe200078fe0ffULL, 0x000000013a3e7824ULL, 0x000fc400078e0a35ULL,
0x0000000b6c4e7224ULL, 0x000fe400078e02ffULL, 0x00000001500c7824ULL, 0x000fe200078e0209ULL,
0x0000003e6f3b7217ULL, 0x000fe20003800000ULL, 0x0000000140427824ULL, 0x000fe200078e0a35ULL,
0x0000004e380a7211ULL, 0x000fe200078fe0ffULL, 0x000060000e0e7625ULL, 0x000fe200078e0045ULL,
0x00000020333e7812ULL, 0x000fc600078efcffULL, 0x000060000c0c7625ULL, 0x000fe200078e0045ULL,
0x000000426f427217ULL, 0x000fe20003800000ULL, 0x000000080e377981ULL, 0x0048a2000c1e9500ULL,
0x000000353a00720cULL, 0x080fe40003f06070ULL, 0x000000354000720cULL, 0x000fe20003f26070ULL,
0x000000080c347981ULL, 0x0002a2000c1e9500ULL, 0x000058003e407a10ULL, 0x000fe20007ffe0ffULL,
0x000060000a0a7625ULL, 0x000fe200078e0045ULL, 0x00000004ff427819ULL, 0x000fe40000011642ULL,
0x000000ff3b3b7207ULL, 0x000fe20000000000ULL, 0x0000000109087824ULL, 0x000fe200078e024eULL,
0x000000080a397981ULL, 0x0006a2000c1e9500ULL, 0x0000000140467824ULL, 0x000fc400078e0a35ULL,
0x0000600008087625ULL, 0x000fe200078e0045ULL, 0x000000ff420d7207ULL, 0x002fe40000800000ULL,
0x000000354000720cULL, 0x000fe20003f06070ULL, 0x0000000168487824ULL, 0x000fe200078e023eULL,
0x000000503b0a7211ULL, 0x008fe200078fe0ffULL, 0x00000008083c7981ULL, 0x0002e2000c1e9500ULL,
0x000000466f467217ULL, 0x000fe20003800000ULL, 0x00000001500c7824ULL, 0x000fe400078e020dULL,
0x00000001484a7824ULL, 0x000fe200078e0a35ULL, 0x000000ff46477207ULL, 0x000fe20000000000ULL,
0x000060000a087625ULL, 0x002fe200078e0045ULL, 0x0000003033467812ULL, 0x000fc600078efcffULL,
0x000060000c0a7625ULL, 0x000fe200078e0045ULL, 0x0000004e3b0c7211ULL, 0x000fe200078fe0ffULL,
0x00000008083d7981ULL, 0x0002e2000c1e9500ULL, 0x0000004a6f4a7217ULL, 0x000fe20003800000ULL,
0x000000010d0e7824ULL, 0x010fe200078e024eULL, 0x000000354800720cULL, 0x000fe20003f26070ULL,
0x0000000168527824ULL, 0x000fe200078e0246ULL, 0x00000004ff4a7819ULL, 0x000fe2000001164aULL,
0x000060000c0c7625ULL, 0x000fe200078e0045ULL, 0x000000080a427981ULL, 0x0008e2000c1e9500ULL,
0x0000005047087211ULL, 0x002fc400078fe0ffULL, 0x000060000e0e7625ULL, 0x080fe200078e0045ULL,
0x0000580046487a10ULL, 0x000fe20007ffe0ffULL, 0x000000080c3f7981ULL, 0x0002e4000c1e9500ULL,
0x0000600008087625ULL, 0x000fe200078e0045ULL, 0x000000ff4a437207ULL, 0x000fe20000800000ULL,
0x000000080e447981ULL, 0x0002e4000c1e9500ULL, 0x0000000152547824ULL, 0x000fe400078e0a35ULL,
0x0000000808417981ULL, 0x0002e2000c1e9500ULL, 0x00000001500a7824ULL, 0x010fe200078e0243ULL,
0x0000004e470c7211ULL, 0x002fc400078fe0ffULL, 0x000000546f547217ULL, 0x000fe20003800000ULL,
0x00000001430e7824ULL, 0x000fe400078e024eULL, 0x0000000148087824ULL, 0x040fe200078e0a35ULL,
0x000000354800720cULL, 0x000fe20003f06070ULL, 0x000060000a0a7625ULL, 0x000fe200078e0045ULL,
0x000000355200720cULL, 0x000fe40003f26070ULL, 0x000000086f087217ULL, 0x000fe20003800000ULL,
0x000060000c0c7625ULL, 0x080fe200078e0045ULL, 0x00000004ff547819ULL, 0x000fe20000011654ULL,
0x000000080a4a7981ULL, 0x000324000c1e9500ULL, 0x000060000e0e7625ULL, 0x000fe200078e0045ULL,
0x000000ff08497207ULL, 0x000fe20000000000ULL, 0x000000080c437981ULL, 0x000322000c1e9500ULL,
0x000000ff544b7207ULL, 0x000fc60000800000ULL, 0x000000080e4c7981ULL, 0x000322000c1e9500ULL,
0x0000005049087211ULL, 0x000fe200078fe0ffULL, 0x00000001500a7824ULL, 0x002fc800078e024bULL,
0x0000600008087625ULL, 0x000fc800078e0045ULL, 0x000060000a0a7625ULL, 0x000fe400078e0045ULL,
0x0000000808087981ULL, 0x000322000c1e9500ULL, 0x0000004e490c7211ULL, 0x000fc600078fe0ffULL,
0x000000080a0b7981ULL, 0x000322000c1e9500ULL, 0x000000014b0e7824ULL, 0x000fe400078e024eULL,
0x000060000c0c7625ULL, 0x000fc800078e0045ULL, 0x000060000e0e7625ULL, 0x000fe400078e0045ULL,
0x000000080c0c7981ULL, 0x000328000c1e9500ULL, 0x000000080e0f7981ULL, 0x000322000c1e9500ULL,
0xfffffff0384b7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff457424ULL, 0x000fe200078e00ffULL,
0xfffffff03b4d7812ULL, 0x000fc600078ec0ffULL, 0x00000001354b7824ULL, 0x000fe200078e024bULL,
0x0000000133767812ULL, 0x000fc600078efcffULL, 0x00000001323b7824ULL, 0x000fe200078e0a4bULL,
0x0000000833707812ULL, 0x040fe400078efcffULL, 0x00000009336a7812ULL, 0x000fe400078efcffULL,
0x0000003b453b7219ULL, 0x000fe400000006ffULL, 0x00005800767c7a10ULL, 0x000fe40007ffe0ffULL,
0x00005800707a7a10ULL, 0x000fe40007ffe0ffULL, 0x000058006a787a10ULL, 0x000fc40007ffe0ffULL,
0xfffffff0474f7812ULL, 0x000fe200078ec0ffULL, 0x000000017a477824ULL, 0x100fe200078e0a4bULL,
0xfffffff0495d7812ULL, 0x000fe200078ec0ffULL, 0x000000017c497824ULL, 0x100fe400078e0a4bULL,
0x00000001784b7824ULL, 0x000fe200078e0a4bULL, 0x0000001833587812ULL, 0x000fe400078efcffULL,
0x0000004745477219ULL, 0x040fe400000006ffULL, 0x0000004b454b7219ULL, 0x000fe200000006ffULL,
0x00000001354d7824ULL, 0x000fe200078e024dULL, 0x0000580058607a10ULL, 0x000fc60007ffe0ffULL,
0x000000013a597824ULL, 0x100fe400078e0a4dULL, 0x00000001605b7824ULL, 0x000fe200078e0a4dULL,
0x00000011335a7812ULL, 0x040fe400078efcffULL, 0x0000001933567812ULL, 0x000fe400078efcffULL,
0x0000004945497219ULL, 0x040fe400000006ffULL, 0x0000005945597219ULL, 0x040fe400000006ffULL,
0x0000005b455b7219ULL, 0x000fe200000006ffULL, 0x00000001354f7824ULL, 0x000fe200078e024fULL,
0x000058005a667a10ULL, 0x000fc40007ffe0ffULL, 0x00005800565c7a10ULL, 0x000fe20007ffe0ffULL,
0x0000000140657824ULL, 0x000fe400078e0a4fULL, 0x0000000166577824ULL, 0x100fe400078e0a4dULL,
0x000000015c5f7824ULL, 0x000fe200078e0a4dULL, 0x0000002133547812ULL, 0x040fe400078efcffULL,
0x0000002833527812ULL, 0x040fe400078efcffULL, 0x0000002933507812ULL, 0x000fc400078efcffULL,
0x0000005745577219ULL, 0x040fe400000006ffULL, 0x0000005f455f7219ULL, 0x040fe400000006ffULL,
0x0000006545657219ULL, 0x000fe200000006ffULL, 0x00000001355d7824ULL, 0x000fe200078e025dULL,
0x00005800540d7a10ULL, 0x002fe40007ffe0ffULL, 0x0000580052097a10ULL, 0x000fe40007ffe0ffULL,
0x0000580050387a10ULL, 0x000fe20007ffe0ffULL, 0x000000010d677824ULL, 0x000fc400078e0a4fULL,
0x0000000109697824ULL, 0x100fe400078e0a4fULL, 0x00000001386b7824ULL, 0x000fe400078e0a4fULL,
0x0000000148717824ULL, 0x000fe200078e0a5dULL, 0x00000031334e7812ULL, 0x040fe400078efcffULL,
0x00000038330e7812ULL, 0x040fe400078efcffULL, 0x00000039330a7812ULL, 0x000fe400078efcffULL,
0x0000006745677219ULL, 0x000fc400000006ffULL, 0x0000006945697219ULL, 0x040fe400000006ffULL,
0x0000006b456b7219ULL, 0x040fe400000006ffULL, 0x0000007145717219ULL, 0x000fe400000006ffULL,
0x000058004e4d7a10ULL, 0x000fe40007ffe0ffULL, 0x000058000e4f7a10ULL, 0x000fe40007ffe0ffULL,
0x000058000a517a10ULL, 0x000fe20007ffe0ffULL, 0x000000014d537824ULL, 0x000fc400078e0a5dULL,
0x000000014f557824ULL, 0x100fe400078e0a5dULL, 0x00000001515d7824ULL, 0x000fe200078e0a5dULL,
0x0000005345537219ULL, 0x040fe400000006ffULL, 0x0000005545557219ULL, 0x040fe400000006ffULL,
0x0000005d455d7219ULL, 0x000fe400000006ffULL, 0x0000541037347816ULL, 0x004fc80000000034ULL,
0x000000343bff7212ULL, 0x000fc8000780c0ffULL, 0x000000353200720cULL, 0x000fc80000701470ULL,
0x000000353300720cULL, 0x000fe40000701070ULL, 0x00005410393c7816ULL, 0x008fe4000000003cULL,
0xff80000019197808ULL, 0x000fe40000000000ULL, 0x0000003c3bff7212ULL, 0x080fe4000788c0ffULL,
0x0000003c47ff7212ULL, 0x080fe400078cc0ffULL, 0x0000003c4bff7212ULL, 0x000fc4000780c0ffULL,
0x000000353200720cULL, 0x080fe40002781470ULL, 0x000000357a00720cULL, 0x080fe400037c1470ULL,
0x000000357800720cULL, 0x080fe40000701470ULL, 0x000000344bff7212ULL, 0x000fe4000782c0ffULL,
0x000000353300720cULL, 0x080fe40002781070ULL, 0x000000357000720cULL, 0x000fc400037c1070ULL,
0x000000356a00720cULL, 0x080fe40000701070ULL, 0x000054103d427816ULL, 0x000fe40000000042ULL,
0x000000357800720cULL, 0x000fe40000f21470ULL, 0xff8000001c1c7808ULL, 0x000fe40002000000ULL,
0xff8000001b1b7808ULL, 0x000fe40003000000ULL, 0x000054103f447816ULL, 0x000fc40000000044ULL,
0xff8000002a2a7808ULL, 0x000fe40000000000ULL, 0x0000003449ff7212ULL, 0x080fe4000786c0ffULL,
0x0000003447ff7212ULL, 0x000fe4000784c0ffULL, 0x0000003c49ff7212ULL, 0x000fe400078ac0ffULL,
0x0000004259ff7212ULL, 0x040fe4000788c0ffULL, 0x0000004459ff7212ULL, 0x000fc400078cc0ffULL,
0x000000445bff7212ULL, 0x000fe4000780c0ffULL, 0x000000356a00720cULL, 0x080fe40000f21070ULL,
0x000000357c00720cULL, 0x0c0fe40001f61470ULL, 0x000000357c00720cULL, 0x080fe40002fa1470ULL,
0x000000357a00720cULL, 0x080fe40001741470ULL, 0x000000353a00720cULL, 0x000fc40002781470ULL,
0x000000353a00720cULL, 0x080fe400037c1470ULL, 0x000000356000720cULL, 0x080fe40000701470ULL,
0xff8000002c2c7808ULL, 0x000fe40000800000ULL, 0x000000357600720cULL, 0x0c0fe40001f61070ULL,
0x000000357600720cULL, 0x080fe40002fa1070ULL, 0x000000357000720cULL, 0x000fc40001741070ULL,
0x000000353600720cULL, 0x0c0fe40002721070ULL, 0x000000353600720cULL, 0x080fe400037c1070ULL,
0x000000355800720cULL, 0x000fe40000701070ULL, 0x00005410414a7816ULL, 0x010fe4000000004aULL,
0x00005410434c7816ULL, 0x000fe4000000004cULL, 0xff80000023237808ULL, 0x000fc40001800000ULL,
0xff8000001a1a7808ULL, 0x000fe40002800000ULL, 0xff80000024247808ULL, 0x000fe40001000000ULL,
0xff80000025257808ULL, 0x000fe40000800000ULL, 0xff8000001e1e7808ULL, 0x000fe40003000000ULL,
0xff8000001f1f7808ULL, 0x000fe40000000000ULL, 0x0000004257ff7212ULL, 0x000fc4000786c0ffULL,
0x000000425bff7212ULL, 0x080fe400078ac0ffULL, 0x000000425fff7212ULL, 0x000fe4000784c0ffULL,
0x0000004457ff7212ULL, 0x080fe4000788c0ffULL, 0x000000445fff7212ULL, 0x000fe4000782c0ffULL,
0x0000004a65ff7212ULL, 0x040fe400078cc0ffULL, 0x0000004c65ff7212ULL, 0x000fc4000780c0ffULL,
0x000000356600720cULL, 0x0c0fe40001f61470ULL, 0x000000356600720cULL, 0x080fe40002781470ULL,
0x000000356000720cULL, 0x080fe40002fa1470ULL, 0x000000355c00720cULL, 0x0c0fe40001741470ULL,
0x000000355c00720cULL, 0x080fe40000f21470ULL, 0x000000354000720cULL, 0x000fc400037c1470ULL,
0x000000354000720cULL, 0x080fe40000701470ULL, 0x000000355a00720cULL, 0x0c0fe40001f61070ULL,
0x000000355a00720cULL, 0x080fe40002781070ULL, 0x000000355800720cULL, 0x080fe40002fa1070ULL,
0x000000355600720cULL, 0x0c0fe40001741070ULL, 0x000000355600720cULL, 0x000fc40000f21070ULL,
0x000000353e00720cULL, 0x0c0fe400037c1070ULL, 0x000000353e00720cULL, 0x000fe40000701070ULL,
0x0000541008087816ULL, 0x000fe4000000000bULL, 0xff80000026267808ULL, 0x000fe40001800000ULL,
0xff8000001d1d7808ULL, 0x000fe40002000000ULL, 0xff80000027277808ULL, 0x000fc40002800000ULL,
0xff80000031317808ULL, 0x000fe40001000000ULL, 0xff80000030307808ULL, 0x000fe40000800000ULL,
0xff8000002f2f7808ULL, 0x000fe40003000000ULL, 0xff80000020207808ULL, 0x000fe40000000000ULL,
0x0000004a67ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004a69ff7212ULL, 0x000fc4000788c0ffULL,
0x0000004a6bff7212ULL, 0x000fe400078ac0ffULL, 0x0000004c67ff7212ULL, 0x080fe4000784c0ffULL,
0x0000004c69ff7212ULL, 0x080fe4000782c0ffULL, 0x0000004c6bff7212ULL, 0x000fe400078cc0ffULL,
0x0000000871ff7212ULL, 0x000fe4000780c0ffULL, 0x000000350d00720cULL, 0x000fc40001f61470ULL,
0x000000350d00720cULL, 0x080fe40001741470ULL, 0x000000350900720cULL, 0x0c0fe40002781470ULL,
0x000000350900720cULL, 0x080fe40000f21470ULL, 0x000000353800720cULL, 0x0c0fe40002fa1470ULL,
0x000000353800720cULL, 0x080fe400037c1470ULL, 0x000000354800720cULL, 0x000fc40000701470ULL,
0x000000355400720cULL, 0x0c0fe40001f61070ULL, 0x000000355400720cULL, 0x080fe40001741070ULL,
0x000000355200720cULL, 0x0c0fe40002781070ULL, 0x000000355200720cULL, 0x080fe40000f21070ULL,
0x000000355000720cULL, 0x0c0fe40002fa1070ULL, 0x000000355000720cULL, 0x000fc400037c1070ULL,
0x000000354600720cULL, 0x000fe40000701070ULL, 0x000054100c0c7816ULL, 0x000fe4000000000fULL,
0xff80000028287808ULL, 0x000fe40001800000ULL, 0xff80000011117808ULL, 0x000fe40001000000ULL,
0xff80000029297808ULL, 0x000fe40002000000ULL, 0xff80000012127808ULL, 0x000fc40000800000ULL,
0xff8000002e2e7808ULL, 0x000fe40002800000ULL, 0xff80000018187808ULL, 0x000fe40003000000ULL,
0xff8000002d2d7808ULL, 0x000fe40000000000ULL, 0x0000000853ff7212ULL, 0x080fe4000786c0ffULL,
0x0000000855ff7212ULL, 0x080fe4000784c0ffULL, 0x000000085dff7212ULL, 0x000fc4000788c0ffULL,
0x0000000c71ff7212ULL, 0x080fe4000782c0ffULL, 0x0000000c53ff7212ULL, 0x080fe400078ac0ffULL,
0x0000000c55ff7212ULL, 0x080fe400078cc0ffULL, 0x0000000c5dff7212ULL, 0x000fe4000780c0ffULL,
0x000000354800720cULL, 0x080fe40000f21470ULL, 0x000000354d00720cULL, 0x000fc40001f61470ULL,
0x000000354d00720cULL, 0x080fe40002fa1470ULL, 0x000000354f00720cULL, 0x0c0fe40001741470ULL,
0x000000354f00720cULL, 0x080fe400037c1470ULL, 0x000000355100720cULL, 0x0c0fe40002781470ULL,
0x000000355100720cULL, 0x080fe40000701470ULL, 0x000000354600720cULL, 0x000fc40000f21070ULL,
0x000000354e00720cULL, 0x0c0fe40001f61070ULL, 0x000000354e00720cULL, 0x080fe40002fa1070ULL,
0x000000350e00720cULL, 0x0c0fe40001741070ULL, 0x000000350e00720cULL, 0x080fe400037c1070ULL,
0x000000350a00720cULL, 0x0c0fe40002781070ULL, 0x000000350a00720cULL, 0x000fc40000701070ULL,
0xff8000002b2b7808ULL, 0x000fe40001800000ULL, 0xff80000021217808ULL, 0x000fe40001000000ULL,
0xff80000022227808ULL, 0x000fe40002000000ULL, 0xff80000013137808ULL, 0x000fe40000800000ULL,
0xff80000014147808ULL, 0x000fe40002800000ULL, 0xff80000015157808ULL, 0x000fc40003000000ULL,
0xff80000016167808ULL, 0x000fc40000000000ULL, 0x000000190400720bULL, 0x008fe20003f1e000ULL,
0x0000001fff0e7424ULL, 0x000fe200078e00ffULL, 0x0000001c0500720bULL, 0x000fe20003f3e000ULL,
0xffffffffff0f7424ULL, 0x000fe200078e00ffULL, 0x0000000419047208ULL, 0x000fe40004000000ULL,
0x000000051c057208ULL, 0x000fe40004800000ULL, 0x000000230400720bULL, 0x000fe40003f1e000ULL,
0x0000001a0500720bULL, 0x000fc40003f3e000ULL, 0x0000000423097208ULL, 0x000fe40004000000ULL,
0x000000051a047208ULL, 0x000fe40004800000ULL, 0x000000240900720bULL, 0x000fe40003f1e000ULL,
0x0000001b0400720bULL, 0x000fe40003f3e000ULL, 0x0000000924097208ULL, 0x000fe40004000000ULL,
0x000000041b057208ULL, 0x000fc40004800000ULL, 0x0000002c0900720bULL, 0x000fe40003f1e000ULL,
0x0000002a0500720bULL, 0x000fe40003f3e000ULL, 0x000000092c047208ULL, 0x000fe40004000000ULL,
0x000000052a057208ULL, 0x000fe40004800000ULL, 0x000000250400720bULL, 0x000fe40003f1e000ULL,
0x0000001e0500720bULL, 0x000fc40003f3e000ULL, 0x0000000425097208ULL, 0x000fe40004000000ULL,
0x000000051e047208ULL, 0x000fe40004800000ULL, 0x000000260900720bULL, 0x000fe40003f1e000ULL,
0x0000001d0400720bULL, 0x000fe40003f3e000ULL, 0x0000000926087208ULL, 0x000fe40004000000ULL,
0x000000041d047208ULL, 0x000fc40004800000ULL, 0x000000270800720bULL, 0x000fe40003f1e000ULL,
0x0000001f0400720bULL, 0x000fe40003f3e000ULL, 0x0000000827087208ULL, 0x000fe40004000000ULL,
0x000000041f057208ULL, 0x000fe40004800000ULL, 0x000000310800720bULL, 0x000fe40003f1e000ULL,
0x000000300500720bULL, 0x000fc40003f3e000ULL, 0x0000000831087208ULL, 0x000fe40004000000ULL,
0x0000000530057208ULL, 0x000fe40004800000ULL, 0x0000002f0800720bULL, 0x000fe40003f1e000ULL,
0x000000200500720bULL, 0x000fe40003f3e000ULL, 0x000000082f097208ULL, 0x000fe40004000000ULL,
0x0000000520047208ULL, 0x000fc40004800000ULL, 0x000000280900720bULL, 0x000fe40003f1e000ULL,
0x000000110400720bULL, 0x000fe40003f3e000ULL, 0x0000000928087208ULL, 0x000fe40004000000ULL,
0x0000000411057208ULL, 0x000fe40004800000ULL, 0x000000290800720bULL, 0x000fe40003f1e000ULL,
0x000000120500720bULL, 0x000fc40003f3e000ULL, 0x0000000829097208ULL, 0x000fe40004000000ULL,
0x0000000512057208ULL, 0x000fe40004800000ULL, 0x0000002e0900720bULL, 0x000fe40003f1e000ULL,
0x000000180500720bULL, 0x000fe40003f3e000ULL, 0x000000092e047208ULL, 0x000fe40004000000ULL,
0x0000000518087208ULL, 0x000fc40004800000ULL, 0x0000002d0400720bULL, 0x000fe40003f1e000ULL,
0x000000130800720bULL, 0x000fe40003f3e000ULL, 0x000000042d047208ULL, 0x000fe40004000000ULL,
0x0000000813057208ULL, 0x000fe40004800000ULL, 0x0000002b0400720bULL, 0x000fe40003f1e000ULL,
0x000000140500720bULL, 0x000fc40003f3e000ULL, 0x000000042b047208ULL, 0x000fe40004000000ULL,
0x0000000514087208ULL, 0x000fe40004800000ULL, 0x000000210400720bULL, 0x000fe40003f1e000ULL,
0x000000150800720bULL, 0x000fe40003f3e000ULL, 0x0000000421057208ULL, 0x000fe40004000000ULL,
0x0000000815097208ULL, 0x000fc40004800000ULL, 0x000000220500720bULL, 0x000fe40003f1e000ULL,
0x000000160900720bULL, 0x000fe40003f3e000ULL, 0x00000005220a7208ULL, 0x000fe40004000000ULL,
0x00000009160c7208ULL, 0x000fe20004800000ULL, 0x000014227f007947ULL, 0x000fec000b800000ULL,
0x0c401f000a047f89ULL, 0x00066400000e0000ULL, 0x000000040a00720bULL, 0x002fc80003f1e000ULL,
0x0000000a040d7208ULL, 0x000fe20004000000ULL, 0x000014327f007947ULL, 0x000fea000b800000ULL,
0x0c401f000c047f89ULL, 0x000e6800000e0000ULL, 0x0c401f0006057f89ULL, 0x000f2800000e0000ULL,
0x0c401f0007327f89ULL, 0x000ea200000e0000ULL, 0x000000040c00720bULL, 0x002fc40003f1e000ULL,
0x000000050600720bULL, 0x010fe40003f3e000ULL, 0x0000000c04087208ULL, 0x000fe40004000000ULL,
0x0000000605097208ULL, 0x000fe20004800000ULL, 0x0c201f000d047f89ULL, 0x000e6200000e0000ULL,
0x000000320700720bULL, 0x004fc60003f1e000ULL, 0x0c201f0008057f89ULL, 0x000ea200000e0000ULL,
0x0000000732327208ULL, 0x000fc60004000000ULL, 0x0c201f00090a7f89ULL, 0x008ee800000e0000ULL,
0x0c201f0032337f89ULL, 0x0002e400000e0000ULL, 0x000000040d00720bULL, 0x002fe40003f1e000ULL,
0x000000050800720bULL, 0x004fe40003f3e000ULL, 0x0000000d04047208ULL, 0x000fc40004000000ULL,
0x0000000a0900720bULL, 0x008fe40003f5e000ULL, 0x0000000805057208ULL, 0x000fe40004800000ULL,
0x000000090a067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04087820ULL, 0x000fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000302ff7812ULL, 0x000fe4000780c0ffULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b23237823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010808ULL,
0x00000025000d7308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010808ULL, 0x3fb8aa3b28287823ULL, 0x100fe20000010808ULL,
0x3fb8aa3b2b077823ULL, 0x100fe20000010808ULL, 0x000000333200720bULL, 0x004fe20003f3e000ULL,
0x0000001900097308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b29257823ULL, 0x008fe20000010808ULL,
0x3fb8aa3b05297820ULL, 0x000fc80000410000ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010829ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe20000010829ULL, 0x00000023000a7308ULL, 0x0022e20000000800ULL,
0x3fb8aa3b2f197823ULL, 0x104fe20000010808ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010829ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010829ULL, 0x3fb8aa3b11117823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b12127823ULL, 0x100fe20000010829ULL, 0x00000024000b7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b22237823ULL, 0x002fe20000010808ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010829ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010829ULL,
0x3fb8aa3b15157823ULL, 0x100fe20000010829ULL, 0x3fb8aa3b16167823ULL, 0x000fc40000010829ULL,
0x0000002c000c7308ULL, 0x0003220000000800ULL, 0x3fb8aa3b2d247823ULL, 0x004fce0000010808ULL,
0x0000001c001c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2e2c7823ULL, 0x002fce0000010808ULL,
0x0000001a000f7308ULL, 0x0002b00000000800ULL, 0x0000001b001b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b201a7823ULL, 0x002fe20000010829ULL, 0x3c003c00ff207424ULL, 0x000fcc00078e00ffULL,
0x0000002a002a7308ULL, 0x000e700000000800ULL, 0x00000026000e7308ULL, 0x0002b00000000800ULL,
0x0000001e00227308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b21267823ULL, 0x002fe20000010808ULL,
0x000000090a08723eULL, 0x008fe200000000ffULL, 0x3c003c00ff217424ULL, 0x000fe200078e00ffULL,
0x0000000b0c0a723eULL, 0x010fc400000000ffULL, 0x0000001c0f09723eULL, 0x004fe400000000ffULL,
0x0000001b2a0b723eULL, 0x000fe200000000ffULL, 0x0000001d002b7308ULL, 0x000e620000000800ULL,
0x0000000d0e0c723eULL, 0x000fe400000000ffULL, 0x00000002ff2a7819ULL, 0x000fc80000011602ULL,
0x000000082a397810ULL, 0x040fe20007ffe0ffULL, 0x0000001f002d7308ULL, 0x0005e20000000800ULL,
0x000000082a297824ULL, 0x040fe400078e00ffULL, 0x000000082a357824ULL, 0x000fca00078e00ffULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x00000020081c723cULL, 0x004f6200000018ffULL,
0x000000222b0d723eULL, 0x002fe200000000ffULL, 0x000000082a2b7824ULL, 0x040fe200078e00ffULL,
0x000000032a227810ULL, 0x000fc80007ffe0ffULL, 0x0000003100347308ULL, 0x0002b00000000800ULL,
0x0000003000307308ULL, 0x000ee20000000800ULL, 0x000000082a317824ULL, 0x002fe200078e00ffULL,
0x00000027340e723eULL, 0x004fcc00000000ffULL, 0x0000001900197308ULL, 0x000fe20000000800ULL,
0x000000042a277810ULL, 0x000fe40007ffe0ffULL, 0x0000002d300f723eULL, 0x008fca00000000ffULL,
0x0000002800287308ULL, 0x000fe20000000800ULL, 0x000000082a2d7824ULL, 0x040fe400078e00ffULL,
0x000000082a307824ULL, 0x040fe200078e00ffULL, 0x000000200c1c723cULL, 0x020f64000000181cULL,
0xfffffff82d2d7812ULL, 0x000fe400078ee222ULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x000000062a227810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8302f7812ULL, 0x000fc400078ee227ULL,
0xfffffff835357812ULL, 0x000fc600078ee222ULL, 0x0000002c002c7308ULL, 0x000e700000000800ULL,
0x0000001a002e7308ULL, 0x0005f00000000800ULL, 0x0000001100117308ULL, 0x000ee20000000800ULL,
0x000000012a1a7810ULL, 0x004fc80007ffe0ffULL, 0xfffffff829297812ULL, 0x000fe400078ee21aULL,
0x000000252c1a723eULL, 0x002fe200000000ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0xffffffff2a257810ULL, 0x000fce0007ffe0ffULL, 0x00000018001b7308ULL, 0x0002b00000000800ULL,
0x0000002400247308ULL, 0x000fe20000000800ULL, 0x000000022a187810ULL, 0x002fc80007ffe0ffULL,
0xfffffff82b2b7812ULL, 0x000fe400078ee218ULL, 0x000000192818723eULL, 0x000fe200000000ffULL,
0x0000000700077308ULL, 0x000e620000000800ULL, 0x0000002e1119723eULL, 0x008fe200000000ffULL,
0x000000082a117824ULL, 0x040fe200078e00ffULL, 0x000000121b1b723eULL, 0x004fe200000000ffULL,
0x0000000839287824ULL, 0x000fe200078e00ffULL, 0x000000052a127810ULL, 0x040fe40007ffe0ffULL,
0xfffffff811117812ULL, 0x000fe200078ee22aULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x000000082a2a7824ULL, 0x000fe200078e00ffULL, 0x00000020181c723cULL, 0x020f62000000181cULL,
0xfffffff831317812ULL, 0x000fc400078ee212ULL, 0x0000900000127811ULL, 0x000fe400078e58ffULL,
0xfffffff82a377812ULL, 0x000fe200078ee225ULL, 0x0000002300237308ULL, 0x000ea20000000800ULL,
0x000000240724723eULL, 0x002fe200000000ffULL, 0x0000001011117824ULL, 0x100fe200078e0212ULL,
0xfffffff828397812ULL, 0x000fe200078ee239ULL, 0x0000001029297824ULL, 0x100fe200078e0212ULL,
0x0000003233077208ULL, 0x000fe20004800000ULL, 0x000000102b2b7824ULL, 0x100fe400078e0212ULL,
0x0000001300137308ULL, 0x000fe20000000800ULL, 0x000000102d2d7824ULL, 0x000fc400078e0212ULL,
0x000000102f2f7824ULL, 0x100fe400078e0212ULL, 0x0000001031317824ULL, 0x100fe400078e0212ULL,
0x0000001035357824ULL, 0x100fe200078e0212ULL, 0x0000001400147308ULL, 0x000e620000000800ULL,
0x000000262326723eULL, 0x004fe200000000ffULL, 0x0000001037377824ULL, 0x100fe400078e0212ULL,
0x0000001039397824ULL, 0x000fc800078e0212ULL, 0x0000001500157308ULL, 0x000ff00000000800ULL,
0x0000001600167308ULL, 0x000ea20000000800ULL, 0x000000131425723eULL, 0x002fe400000000ffULL,
0x0000000c17147812ULL, 0x000fca00078ec0ffULL, 0x0000000111117824ULL, 0x000fe400078e0214ULL,
0x0000000114297824ULL, 0x040fe400078e0229ULL, 0x00000001142b7824ULL, 0x040fe200078e022bULL,
0x0000000811007388ULL, 0x0003e20000000800ULL, 0x00000001142d7824ULL, 0x000fe200078e022dULL,
0x000000151627723eULL, 0x004fe200000000ffULL, 0x00000001142f7824ULL, 0x040fe200078e022fULL,
0x0000000a29007388ULL, 0x0003e20000000800ULL, 0x0000000114317824ULL, 0x000fc400078e0231ULL,
0x0000000114357824ULL, 0x040fe200078e0235ULL, 0x0000000c2b007388ULL, 0x0003e20000000800ULL,
0x00000020241c723cULL, 0x020f62000000181cULL, 0x0000000114377824ULL, 0x040fe400078e0237ULL,
0x0000000114147824ULL, 0x000fe200078e0239ULL, 0x0000000e2d007388ULL, 0x0003e80000000800ULL,
0x000000182f007388ULL, 0x0003e80000000800ULL, 0x0000001a31007388ULL, 0x0003e80000000800ULL,
0x0000002435007388ULL, 0x0003e80000000800ULL, 0x0000002637007388ULL, 0x0003e80000000800ULL,
0x0000000914007388ULL, 0x0003e20000000800ULL, 0x000000ffff1d7224ULL, 0x020fc600078e001eULL,
0x0004000b29007388ULL, 0x0003e80000000800ULL, 0x0004000d2b007388ULL, 0x0003e80000000800ULL,
0x0004000f2d007388ULL, 0x0003e80000000800ULL, 0x000400192f007388ULL, 0x0003e80000000800ULL,
0x0004001b31007388ULL, 0x0003e80000000800ULL, 0x0004002535007388ULL, 0x0003e80000000800ULL,
0x0004002737007388ULL, 0x0003e80000000800ULL, 0x00f0000410008388ULL, 0x0003e80000000c00ULL,
0x00f2001c10008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000074ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080074ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100074ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000015e5e7810ULL, 0x000fe20007ffe0ffULL, 0x0000180074ff7f8cULL, 0x0003e6000c80043fULL,
0x000000635e00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffb7c000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff127807ULL, 0x008fe40004000000ULL, 0x00011cd000137802ULL, 0x000fc40000000f00ULL,
0x00000bc000007944ULL, 0x002fea0003c00000ULL, 0xffff071000007947ULL, 0x000fea000383ffffULL,
0x00000001ff127807ULL, 0x000fe40005000000ULL, 0x00011d1000137802ULL, 0x000fc40000000f00ULL,
0x00000b8000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e003cULL,
0xffff077000007947ULL, 0x000fea000383ffffULL, 0x000000ffff137224ULL, 0x000fe200078e000dULL,
0x00011d60003d7802ULL, 0x000fc40000000f00ULL, 0x00000ae000007944ULL, 0x002fea0003c00000ULL,
0xffff085000007947ULL, 0x000fea000383ffffULL, 0x000000ffff137224ULL, 0x000fe200078e000dULL,
0x00011da0003d7802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x002fea0003c00000ULL,
0xffff097000007947ULL, 0x000fea000383ffffULL, 0x000000ffff137224ULL, 0x000fe200078e0003ULL,
0x00011df0003d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff127224ULL, 0x000fc400078e0004ULL,
0x00000a5000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e003cULL,
0xffff0d8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff137224ULL, 0x000fe200078e0003ULL,
0x00011e40003d7802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e003cULL, 0xffff0d6000007947ULL, 0x000fea000383ffffULL,
0x00000001ff127807ULL, 0x008fe40004000000ULL, 0x00011e9000137802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x002fea0003c00000ULL, 0xffff2c2000007947ULL, 0x000fea000383ffffULL,
0x00000001ff127807ULL, 0x000fe40005000000ULL, 0x00011ed000137802ULL, 0x000fc40000000f00ULL,
0x000009c000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e003cULL,
0xffff2c6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff137224ULL, 0x000fe200078e0032ULL,
0x00011f20003d7802ULL, 0x000fc40000000f00ULL, 0x0000092000007944ULL, 0x002fea0003c00000ULL,
0xffff2d4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff137224ULL, 0x000fe200078e0032ULL,
0x00011f60003d7802ULL, 0x000fc40000000f00ULL, 0x000008e000007944ULL, 0x002fea0003c00000ULL,
0xffff2e6000007947ULL, 0x000fea000383ffffULL, 0x000000ffff137224ULL, 0x000fe200078e000dULL,
0x00011fb0003d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff127224ULL, 0x000fc400078e000eULL,
0x0000089000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e003cULL,
0xffff328000007947ULL, 0x000fea000383ffffULL, 0x000000ffff137224ULL, 0x000fe200078e000dULL,
0x00012000003d7802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e003cULL, 0xffff326000007947ULL, 0x000fea000383ffffULL,
0x00000001ff127807ULL, 0x008fe40004000000ULL, 0x0001205000137802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x002fea0003c00000ULL, 0xffff512000007947ULL, 0x000fea000383ffffULL,
0x00000001ff127807ULL, 0x000fe40005000000ULL, 0x0001209000137802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x002fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e003cULL,
0xffff517000007947ULL, 0x000fea000383ffffULL, 0x000000ffff137224ULL, 0x000fe200078e0030ULL,
0x000120e0003d7802ULL, 0x000fc40000000f00ULL, 0x0000076000007944ULL, 0x002fea0003c00000ULL,
0xffff526000007947ULL, 0x000fea000383ffffULL, 0x000000ffff137224ULL, 0x000fe200078e0030ULL,
0x00012120003d7802ULL, 0x000fc40000000f00ULL, 0x0000072000007944ULL, 0x002fea0003c00000ULL,
0xffff538000007947ULL, 0x000fea000383ffffULL, 0x000000ffff137224ULL, 0x000fe200078e000cULL,
0x00012170003d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff127224ULL, 0x000fc400078e0011ULL,
0x000006d000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e003cULL,
0xffff57a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff137224ULL, 0x000fe200078e000cULL,
0x000121c0003d7802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e003cULL, 0xffff578000007947ULL, 0x000fea000383ffffULL,
0x00000001ff127807ULL, 0x004fe40004000000ULL, 0x0001221000137802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x008fea0003c00000ULL, 0xffff754000007947ULL, 0x000fea000383ffffULL,
0x00000001ff127807ULL, 0x000fe40005000000ULL, 0x0001225000137802ULL, 0x000fc40000000f00ULL,
0x0000064000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff227224ULL, 0x000fe200078e003cULL,
0xffff759000007947ULL, 0x000fea000383ffffULL, 0x000000ffff137224ULL, 0x000fe200078e0008ULL,
0x000122a0003d7802ULL, 0x000fc40000000f00ULL, 0x000005a000007944ULL, 0x008fea0003c00000ULL,
0xffff767000007947ULL, 0x000fea000383ffffULL, 0x000000ffff137224ULL, 0x000fe200078e0008ULL,
0x000122e0003d7802ULL, 0x000fc40000000f00ULL, 0x0000056000007944ULL, 0x008fea0003c00000ULL,
0xffff779000007947ULL, 0x000fea000383ffffULL, 0x000000ffff137224ULL, 0x000fe200078e0008ULL,
0x00012330003d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff127224ULL, 0x000fc400078e0011ULL,
0x0000051000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e003cULL,
0xffff7bf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff137224ULL, 0x000fe200078e0008ULL,
0x00012380003d7802ULL, 0x000fc40000000f00ULL, 0x000004c000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e003cULL, 0xffff7bd000007947ULL, 0x000fea000383ffffULL,
0x00000002ff0b7424ULL, 0x000fe200078e00ffULL, 0x000123d000087802ULL, 0x000fc40000000f00ULL,
0x0000043000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0033ULL,
0xffffeba000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0a7224ULL, 0x008fe200078e000cULL,
0x0001243000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0b7424ULL, 0x000fc400078e00ffULL,
0x000003d000007944ULL, 0x004fea0003c00000ULL, 0x000000330c00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0006ULL, 0x0001249000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000c330c7208ULL, 0x000fc80004000000ULL,
0x0000037000007944ULL, 0x000fea0003c00000ULL, 0x000000330600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0007ULL, 0x000124f000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000633067208ULL, 0x000fc80004000000ULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x000000330700720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e000dULL, 0x0001255000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000733327208ULL, 0x000fc80004000000ULL,
0x000002b000007944ULL, 0x000fea0003c00000ULL, 0x000000330d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e000cULL, 0x000125b000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000d33047208ULL, 0x000fc80004000000ULL,
0x0000025000007944ULL, 0x000fea0003c00000ULL, 0x000000330c00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0006ULL, 0x0001261000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000c33057208ULL, 0x000fc80004000000ULL,
0x000001f000007944ULL, 0x000fea0003c00000ULL, 0x000000330600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e0032ULL, 0x0001267000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x0000000633067208ULL, 0x000fc80004000000ULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffea7000007947ULL, 0x000fea000383ffffULL,
0x018000000f007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000000f00008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff0fff7812ULL, 0x040fe4000780c0ffULL, 0x800000000f027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000f00007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffed80002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000000f00007348ULL, 0x000fe80003800000ULL,
0x0c00000b0a337389ULL, 0x0002a200000e000eULL, 0xfffed7c008007950ULL, 0x000fea0003c3ffffULL,
0x0000007700007348ULL, 0x000fe80003800000ULL, 0x00000012133c7389ULL, 0x0002a400000e0078ULL,
0x000000ffff127224ULL, 0x002fc400078e003dULL, 0x00000000ff137424ULL, 0x000fc800078e00ffULL,
0xfffed77012007950ULL, 0x000fea0003c3ffffULL, 0x000000011200780cULL, 0x000fe20003f45070ULL,
0x000000ffff127224ULL, 0x000fe200078e0013ULL, 0x0000007600007348ULL, 0x000fe80003800000ULL,
0x00000000ff137424ULL, 0x000fce00078e00ffULL, 0x00000000003c7806ULL, 0x000fc800050e0100ULL,
0x000000763c3c7212ULL, 0x000fe200078ec0ffULL, 0xfffed70012007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005f4ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000750ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f0ULL, 0x00000000000002f0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000ce0ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000da0ULL, 0x00000000000007c0ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001560ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001570ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001600ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001604ULL, 0x00000000000001b8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000012a00ULL, 0x7f00001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014200ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014250ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000145d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001600ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012c00ULL, 0x0000000000012c00ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014200ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000145d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_0_m_16_sm_86_cubin_len = 83632;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
