/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001a8c0ULL, 0x000000000001a540ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x746e695f5f240068ULL,
0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL, 0x66625f636e79736cULL,
0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL, 0x5f30376d735f6164ULL,
0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL, 0x5f5f245f335f6c61ULL,
0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL, 0x2e616c65722e0074ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x766e2e0066754265ULL,
0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL, 0x65642e006d617261ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x00000000006e6f69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c000100000377ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000003c5ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000040bULL, 0x0000000000018970ULL,
0x0000000000000180ULL, 0x000b00220000043eULL, 0x0000000000018af0ULL, 0x0000000000000040ULL,
0x000b002200000469ULL, 0x0000000000018b30ULL, 0x0000000000000050ULL, 0x000b002200000493ULL,
0x0000000000018b80ULL, 0x0000000000000100ULL, 0x000a000300000501ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0007000300000551ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000018c80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001897000000000ULL,
0x0000040400000000ULL, 0x810c000001640400ULL, 0x0060ec0400288080ULL, 0x0000000000000000ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x0001897000000000ULL,
0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808608288080ULL,
0x809d082880808708ULL, 0x082880809f082880ULL, 0x8080a308288080a1ULL, 0xea08288080a50828ULL,
0x288080ec08288080ULL, 0x80f208288080f008ULL, 0x16288080d2082880ULL, 0x0000031028808280ULL,
0xd292000000000000ULL, 0x0000002200288080ULL, 0x0000001cffffffffULL, 0x000000f000000000ULL,
0x00018af000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808508288080ULL, 0x8087082880808608ULL,
0x082880809d082880ULL, 0x8080a1082880809fULL, 0xa608288080a30828ULL, 0x288080ea08288080ULL,
0x80f008288080ec08ULL, 0x08288080f2082880ULL, 0x80828016288080a5ULL, 0x0000000000031028ULL,
0x288080a592000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL, 0x000001a800000000ULL,
0x00018b3000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL, 0x80ea288080a50900ULL,
0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x2880808508288080ULL, 0x8087082880808608ULL, 0x082880809d082880ULL, 0x8080a1082880809fULL,
0xa508288080a30828ULL, 0x288080ea08288080ULL, 0x80f008288080ec08ULL, 0x08288080f2082880ULL,
0x80828016288080a6ULL, 0x0000000000031028ULL, 0x288080a692000000ULL, 0x0000000000002200ULL,
0x0000001cffffffffULL, 0x0000027800000000ULL, 0x00018b8000000000ULL, 0x0000010000000000ULL,
0x0000000000000000ULL, 0x0000001900082f04ULL, 0x00082304000000d8ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL,
0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL,
0x0008230400000000ULL, 0x0000000000000019ULL, 0x0000001900081204ULL, 0x0008110400000000ULL,
0x0000000000000019ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0058016000000016ULL,
0x000c170400581903ULL, 0x0050000900000000ULL, 0x000c17040021f000ULL, 0x0048000800000000ULL,
0x000c17040021f000ULL, 0x0040000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL,
0x000c17040061f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0x00000b0000043104ULL, 0xffffffff019c2904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00000110019c2804ULL, 0x00000580000002e0ULL,
0x00002750000026c0ULL, 0x000029d000002860ULL, 0x00002ca000002b40ULL, 0x0000316000003120ULL,
0x000031a000003170ULL, 0x000053a000005300ULL, 0x00005620000054b0ULL, 0x000058f000005790ULL,
0x00005da000005d60ULL, 0x00005de000005db0ULL, 0x00007f5000007eb0ULL, 0x000081d000008060ULL,
0x000084a000008340ULL, 0x0000895000008910ULL, 0x0000899000008960ULL, 0x0000a9b00000a910ULL,
0x0000ac300000aac0ULL, 0x0000af000000ada0ULL, 0x0000b3a00000b360ULL, 0x0000b3e00000b3b0ULL,
0x0000c8f00000c8e0ULL, 0x0000c9100000c900ULL, 0x0001635000016310ULL, 0x0001637000016360ULL,
0x000163e0000163c0ULL, 0x0001641000016400ULL, 0x000177d000017770ULL, 0x0001788000017830ULL,
0x00017920000178d0ULL, 0x000179e000017980ULL, 0x00017aa000017a40ULL, 0x00017b6000017b00ULL,
0x00017c1000017bc0ULL, 0x00017cb000017c60ULL, 0x00017d7000017d10ULL, 0x00017e3000017dd0ULL,
0x00017ef000017e90ULL, 0x00017fa000017f50ULL, 0x0001804000017ff0ULL, 0x00018100000180a0ULL,
0x000181c000018160ULL, 0x0001828000018220ULL, 0x00018330000182e0ULL, 0x000183d000018380ULL,
0x0001849000018430ULL, 0x00018550000184f0ULL, 0x00018650000185d0ULL, 0x00018750000186d0ULL,
0x00018850000187d0ULL, 0x00018950000188d0ULL, 0x000003b004403904ULL, 0x0001a600000000ffULL,
0x00000430003f0100ULL, 0x0001a6080000000bULL, 0x000004f0003f0120ULL, 0x0001a6880000000bULL,
0x00000520003f0120ULL, 0x0001a6a80000000bULL, 0x00000550003f0120ULL, 0x0001a6c80000000bULL,
0x00000b10003f0120ULL, 0x0001a600000000ffULL, 0x00000c70003f0107ULL, 0x0001a68c00000014ULL,
0x00000d00003f0102ULL, 0x0001a68800000014ULL, 0x00001630003f0101ULL, 0x00000000000000ffULL,
0x000016b000040107ULL, 0x00000000000000ffULL, 0x0000171000040101ULL, 0x0000002000000002ULL,
0x00001880003f0101ULL, 0x0001a6cc0000000cULL, 0x00001a50003f0105ULL, 0x0001a6cc0000000cULL,
0x00002270003f0105ULL, 0x0001a6b00000001fULL, 0x00002330003f0107ULL, 0x0001a6b00000001fULL,
0x00002390003f0101ULL, 0x0001a6080000001cULL, 0x000023d0003f0101ULL, 0x0001a60c00000023ULL,
0x000025b0003f0105ULL, 0x0001a60c00000023ULL, 0x00002e50003f0105ULL, 0x0001a6ac0000001fULL,
0x00003040003f0105ULL, 0x0001a6ac0000001fULL, 0x00004520003f0105ULL, 0x0000000000000068ULL,
0x00004580003f0101ULL, 0x0001a6880000001fULL, 0x000045b0003f0101ULL, 0x000000040000000dULL,
0x00004770003f0105ULL, 0x000000040000000dULL, 0x00004ec0003f0105ULL, 0x0000000000000008ULL,
0x00004fa0003f0107ULL, 0x0000000000000008ULL, 0x00005000003f0101ULL, 0x0001a62800000023ULL,
0x00005060003f0101ULL, 0x0001a62c0000006aULL, 0x00005230003f0105ULL, 0x0001a62c0000006aULL,
0x00005ac0003f0105ULL, 0x0001a6b40000006aULL, 0x00005c90003f0105ULL, 0x0001a6b40000006aULL,
0x000070f0003f0105ULL, 0x000000000000006aULL, 0x00007150003f0101ULL, 0x0001a69000000026ULL,
0x00007180003f0101ULL, 0x000000040000000dULL, 0x00007340003f0105ULL, 0x000000040000000dULL,
0x00007ac0003f0105ULL, 0x00000008000000ffULL, 0x00007b5000040107ULL, 0x0001a6b000000068ULL,
0x00007bb0003f0101ULL, 0x0001a64800000023ULL, 0x00007c10003f0101ULL, 0x0001a64c00000023ULL,
0x00007de0003f0105ULL, 0x0001a64c00000023ULL, 0x00008670003f0105ULL, 0x0000000400000008ULL,
0x00008840003f0105ULL, 0x0000000400000008ULL, 0x00009b70003f0105ULL, 0x0000000000000026ULL,
0x00009bd0003f0101ULL, 0x0001a69800000020ULL, 0x00009c00003f0101ULL, 0x000000040000000dULL,
0x00009dc0003f0105ULL, 0x000000040000000dULL, 0x0000a560003f0105ULL, 0x00000000000000ffULL,
0x0000a61000040107ULL, 0x0000000000000008ULL, 0x0000a670003f0101ULL, 0x0001a6680000000cULL,
0x0000a690003f0101ULL, 0x0001a66c0000000cULL, 0x0000a860003f0105ULL, 0x0001a66c0000000cULL,
0x0000b0c0003f0105ULL, 0x0001a6b400000026ULL, 0x0000b290003f0105ULL, 0x0001a6b400000026ULL,
0x0000c630003f0105ULL, 0x000000000000000dULL, 0x0000c6b0003f0101ULL, 0x000000000000000aULL,
0x0000e420003f0101ULL, 0x0001a600000000ffULL, 0x0000fc30003f0101ULL, 0x0001a604000000ffULL,
0x0000fe00003f0105ULL, 0x0001a604000000ffULL, 0x00010180003f0105ULL, 0x0001a600000000ffULL,
0x000101b0003f0101ULL, 0x0001a604000000ffULL, 0x00010370003f0105ULL, 0x0001a604000000ffULL,
0x000137f0003f0105ULL, 0x000000000000005fULL, 0x00013920003f0101ULL, 0x000000040000005fULL,
0x00013af0003f0105ULL, 0x000000040000005fULL, 0x000175b0003f0105ULL, 0x000000000000005dULL,
0x00017610003f0101ULL, 0x000000080000005dULL, 0x00017670003f0101ULL, 0x000000100000005dULL,
0x000176e0003f0101ULL, 0x000000180000005dULL, 0x00053803003f0101ULL, 0x0000d80000301c04ULL,
0x0000da000000d830ULL, 0x0000dcc00000db60ULL, 0x0000df800000de20ULL, 0x0000e2700000e0e0ULL,
0x000103d00000e370ULL, 0x0000040100017730ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL, 0x0000000000000324ULL,
0x0000001900000002ULL, 0x0000000000000254ULL, 0x0000001900000002ULL, 0x0000000000000194ULL,
0x0000001900000002ULL, 0x00000000000000ccULL, 0x0000001900000002ULL, 0x0000000000000044ULL,
0x0000001900000002ULL, 0x00000000000002fbULL, 0x0000001900000002ULL, 0x000000000000022bULL,
0x0000001900000002ULL, 0x000000000000016eULL, 0x0000001900000002ULL, 0x00000000000000a8ULL,
0x0000001900000002ULL, 0x000000000001a700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0f7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000097919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000f6f7a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000077919ULL, 0x000f280000002100ULL,
0x00000000000e7919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL, 0x00000005ff1a7819ULL, 0x010fc80000011607ULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x00001fff1a1a7589ULL, 0x000fe200000e0000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x00000400031b7a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a1bULL,
0x0000040003007624ULL, 0x000fca00078e020fULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x000000011b1b0810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x000000011b1b1810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff1baa12ULL, 0x000fc800078e33ffULL, 0x0000001b00007306ULL, 0x000e620000209000ULL,
0x000000ff1b00720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000031b047224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000ee40000002200ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000000603127227ULL, 0x004fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a12ULL, 0x000000001b007224ULL, 0x000fca00078e0206ULL,
0x0000001b0000720cULL, 0x000fe20003f46070ULL, 0x0000010009027a24ULL, 0x008fe400078e0204ULL,
0x00001fff09097589ULL, 0x000e6400000e0000ULL, 0x00000000020b7a24ULL, 0x000fca00078e0207ULL,
0x000000ff0b00720cULL, 0x000fc60003fa5270ULL, 0x0000000100002824ULL, 0x000fe200078e0a1bULL,
0x0000000112122810ULL, 0x000fe40007ffe0ffULL, 0x0000007f0b00780cULL, 0x040fe40003f04070ULL,
0x0000001b0000720cULL, 0x000fe40003f66070ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x000000030b00780cULL, 0x000fe20003f44070ULL, 0x3fffff80ff02d424ULL, 0x000fc400078e00ffULL,
0x7fffff80ff03d424ULL, 0x000fc800078e00ffULL, 0xff317217ff088424ULL, 0x000fe400078e00ffULL,
0x0000000112123810ULL, 0x000fe20007ffe0ffULL, 0x01a60002ff00d388ULL, 0x0005e20000000a00ULL,
0x0000001bff12c212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x000000010b00780cULL, 0x000fe20003f64070ULL, 0x01a400080b008388ULL, 0x0007e20000004800ULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x00005a0012187a19ULL, 0x000fe200000006ffULL,
0x000000ffff007224ULL, 0x000fc600078e0a12ULL, 0x01a608040b009388ULL, 0x0009e20000008a00ULL,
0x000000001b1b7224ULL, 0x000fe400078e0206ULL, 0x3fffff60ff02a424ULL, 0x004fe400078e00ffULL,
0x000000201b007824ULL, 0x000fe400078e00ffULL, 0x7fffff60ff03a424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL, 0x0000000400087c10ULL, 0x048fe2000fffe1ffULL,
0x7fffffc0ff07b424ULL, 0x000fe200078e00ffULL, 0x0000000400007c0cULL, 0x000fe2000bf03070ULL,
0x3fffff80ff04a424ULL, 0x010fe200078e00ffULL, 0x0000002008087817ULL, 0x000fe20003800000ULL,
0x7fffff80ff05a424ULL, 0x000fe200078e00ffULL, 0x01a688020b00a388ULL, 0x0005e40000008a00ULL,
0x000000ff08197207ULL, 0x000fe20000000000ULL, 0x0000000409087824ULL, 0x002fe200078e021aULL,
0x01a6a8040b00a388ULL, 0x000fe40000008a00ULL, 0x000000201900780cULL, 0x000fe20003f05270ULL,
0x0000000408087824ULL, 0x000fe200078e00ffULL, 0x01a6c8060b00b388ULL, 0x000fe20000008a00ULL,
0x000058000e027a24ULL, 0x004fc800078e02ffULL, 0x0000006f02027224ULL, 0x000fe200078e0218ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000000819037217ULL, 0x000fe20007800000ULL, 0x00005a0000057ab9ULL, 0x000fc40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00000004ff057819ULL, 0x002fc80000011617ULL,
0x00000002050b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001080a7824ULL, 0x000fc800078e0205ULL,
0x00000001080c7824ULL, 0x000fe400078e020bULL, 0x0000000100047824ULL, 0x040fe400078e020aULL,
0x0000000100067824ULL, 0x000fe400078e020cULL, 0x0000000103087824ULL, 0x000fe200078e0a08ULL,
0x0000000404077c12ULL, 0x000fe2000f8e30ffULL, 0x0000001017037824ULL, 0x000fe200078e00ffULL,
0x00000004060d7c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff047a19ULL, 0x000fe20000011604ULL,
0x0000000102077824ULL, 0x040fe200078e0207ULL, 0x00005a00ff067a19ULL, 0x000fe20000011606ULL,
0x00000001020d7824ULL, 0x000fe200078e020dULL, 0x000000080500720cULL, 0x080fe20003f06070ULL,
0x0000006f04047224ULL, 0x080fe200078e0207ULL, 0x000000080b00720cULL, 0x000fe20003f26070ULL,
0x0000006f06067224ULL, 0x000fe200078e020dULL, 0x000000f0030b7812ULL, 0x000fe200078ec0ffULL,
0x0000010004047825ULL, 0x000fc800078e00ffULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x0000000b04047212ULL, 0x000fc600078efcffULL, 0x000000010a027824ULL, 0x100fe200078e0217ULL,
0x0000000b06067212ULL, 0x000fe200078efcffULL, 0x000000100a0d7824ULL, 0x000fe200078e00ffULL,
0x00005e0004047a10ULL, 0x000fe20007f5e0ffULL, 0x000000010c087824ULL, 0x000fe200078e0217ULL,
0x00005e0006067a10ULL, 0x000fe20007f7e0ffULL, 0x000000100c0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff00d027812ULL, 0x000fe400078ee202ULL, 0x00005f0005057a10ULL, 0x000fe400017fe4ffULL,
0xfffffff00b087812ULL, 0x000fe200078ee208ULL, 0x00000010020b7824ULL, 0x000fe200078e00ffULL,
0x00005f0007077a10ULL, 0x000fc60001ffe4ffULL, 0x00000010080d7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e8000c101c48ULL,
0x00000000060d7faeULL, 0x0003e2000c901c48ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x0000000000177919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x0000000817087211ULL, 0x002fc800078fe0ffULL, 0x00000002080a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100037824ULL, 0x000fe400078e0208ULL, 0x00000010080d7824ULL, 0x000fe400078e00ffULL,
0x0000000100067824ULL, 0x000fe200078e020aULL, 0x0000000403057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fe20000011603ULL, 0x0000001017037824ULL, 0x000fe200078e00ffULL,
0x0000000406077c12ULL, 0x000fe2000f8e30ffULL, 0x0000000102057824ULL, 0x000fe200078e0205ULL,
0x00005a00ff067a19ULL, 0x000fc40000011606ULL, 0x000000f0030b7812ULL, 0x000fe200078ec0ffULL,
0x0000000102077824ULL, 0x000fe400078e0207ULL, 0x0000006f04047224ULL, 0x080fe400078e0205ULL,
0x0000006f06067224ULL, 0x000fe400078e0207ULL, 0x0000010004047825ULL, 0x000fc800078e00ffULL,
0x0000010006067825ULL, 0x000fe200078e00ffULL, 0x0000000b04047212ULL, 0x000fc600078efcffULL,
0x0000000108027824ULL, 0x100fe200078e0217ULL, 0x0000000b06067212ULL, 0x000fe200078efcffULL,
0x000000010a087824ULL, 0x000fe200078e0217ULL, 0x00005e0004047a10ULL, 0x000fe20007f1e0ffULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff00d027812ULL, 0x000fe400078ee202ULL,
0x00005e0006067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff00b087812ULL, 0x000fe200078ee208ULL,
0x00000010020b7824ULL, 0x000fe200078e00ffULL, 0x00005f0005057a10ULL, 0x000fc400007fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20000ffe4ffULL, 0x00000010080d7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000040b7faeULL, 0x0003e8000b901c48ULL,
0x00000000060d7faeULL, 0x0003e4000b901c48ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000027806ULL, 0x000fc600038e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000200047300ULL, 0x000e7000000e0000ULL, 0x0000000200067309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe20003f02070ULL, 0x00000004ff057424ULL, 0x000fc400078e00ffULL,
0x000000ffff067224ULL, 0x004fe400078e0a06ULL, 0x000064000e047625ULL, 0x000fd000078e0005ULL,
0x01a60406ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01a60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000804167981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe40003f05270ULL, 0x000000ff16027810ULL, 0x004fc80007ffe0ffULL,
0x00000008ff157819ULL, 0x000fce0000011602ULL, 0x0000d74000008947ULL, 0x000fea0003800000ULL,
0x000000081a147824ULL, 0x000fe400078e00ffULL, 0x00000003ff057424ULL, 0x000fe200078e00ffULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a68c0514ff738cULL, 0x0005e20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0200780cULL, 0x000fe20003f04070ULL,
0x000000020e007824ULL, 0x000fe200078e00ffULL, 0x00000001ff137819ULL, 0x000fe2000001161aULL,
0x01a6880014ff7f8cULL, 0x0007e2000c80043fULL, 0x000000011a117812ULL, 0x000fe200078ec0ffULL,
0x0000590000057624ULL, 0x004fe400078e020fULL, 0x00000020136e7824ULL, 0x000fc400078e00ffULL,
0x0000000112127824ULL, 0x000fc800078e0205ULL, 0x0000660012007a24ULL, 0x000fe200078e026eULL,
0x000003e000000947ULL, 0x000fea0003800000ULL, 0x0000006e16057217ULL, 0x008fe20007800000ULL,
0x0000001011027824ULL, 0x000fe200078e00ffULL, 0x00000003ff047819ULL, 0x000fc60000011617ULL,
0x0000000105057824ULL, 0x000fe200078e0a6eULL, 0x0000000404087810ULL, 0x000fe20007ffe0ffULL,
0x0000000102067824ULL, 0x002fe200078e0204ULL, 0x0000000c04097810ULL, 0x000fe40007ffe0ffULL,
0x0000000205057217ULL, 0x000fe20007800000ULL, 0x0000000106077824ULL, 0x040fe400078e0217ULL,
0x00000008060c7824ULL, 0x000fe400078e00ffULL, 0x0000000105057824ULL, 0x000fc400078e0a02ULL,
0x00000001020a7824ULL, 0x000fe200078e0209ULL, 0xfffffff80c0c7812ULL, 0x000fe400078ee207ULL,
0x0000000804077810ULL, 0x000fe20007ffe0ffULL, 0x00000001000f7824ULL, 0x000fe200078e020aULL,
0x000000050400720cULL, 0x080fe20003f66070ULL, 0x0000000100047824ULL, 0x000fe200078e0206ULL,
0x000000050800720cULL, 0x080fe20003f46070ULL, 0x0000000102087824ULL, 0x040fe200078e0208ULL,
0x000000050700720cULL, 0x080fe20003f26070ULL, 0x0000000102077824ULL, 0x000fe200078e0207ULL,
0x000000050900720cULL, 0x000fe20003f06070ULL, 0x0000008004047825ULL, 0x000fc800078e00ffULL,
0x0000000100027824ULL, 0x000fe200078e0208ULL, 0x00000070040b7812ULL, 0x000fe200078ef803ULL,
0x0000000108067824ULL, 0x040fe400078e0217ULL, 0x00000008080d7824ULL, 0x000fe400078e00ffULL,
0x0000000100087824ULL, 0x000fe400078e0207ULL, 0x0000000107097824ULL, 0x100fe200078e0217ULL,
0xfffffff80d007812ULL, 0x000fe200078ee206ULL, 0x00000008070e7824ULL, 0x000fe200078e00ffULL,
0x00016000130d7811ULL, 0x000fe200078e68ffULL, 0x000000010a047824ULL, 0x000fc400078e0217ULL,
0x000000080a077824ULL, 0x000fe200078e00ffULL, 0x000062000b0a7a10ULL, 0x000fe20007f9e0ffULL,
0x00000010001d7824ULL, 0x000fe200078e020dULL, 0xfffffff80e0e7812ULL, 0x000fe400078ee209ULL,
0xfffffff807107812ULL, 0x000fe200078ee204ULL, 0x0000008008067825ULL, 0x000fe200078e00ffULL,
0x00006300050b7a10ULL, 0x000fc600027fe4ffULL, 0x0000008002047825ULL, 0x000fc800078e00ffULL,
0x000000800f087825ULL, 0x000fe200078e00ffULL, 0x0000007004027812ULL, 0x100fe400078ef803ULL,
0x0000007006047812ULL, 0x000fe200078ef803ULL, 0x000000100c0f7824ULL, 0x000fe200078e020dULL,
0x0000007008037812ULL, 0x000fe200078ef803ULL, 0x000000100e1f7824ULL, 0x100fe200078e020dULL,
0x0000620002027a10ULL, 0x000fe20007f9e0ffULL, 0x00000010100d7824ULL, 0x000fe200078e020dULL,
0x0000620004047a10ULL, 0x000fe20007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0f7faeULL, 0x0003e2000d901c48ULL, 0x0000620003067a10ULL, 0x000fc40007fde0ffULL,
0x0000630005037a10ULL, 0x000fe400027fe4ffULL, 0x0000630007057a10ULL, 0x000fe40002ffe4ffULL,
0x0000630009077a10ULL, 0x000fe200037fe4ffULL, 0x00000000021d7faeULL, 0x0003e8000d101c48ULL,
0x00000000041f7faeULL, 0x0003e8000c901c48ULL, 0x00000000060d7faeULL, 0x0003e2000c101c48ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x0000001011027824ULL, 0x008fe200078e00ffULL,
0x00016000131f7811ULL, 0x000fc800078e68ffULL, 0x0000000217027211ULL, 0x000fc800078fe8ffULL,
0x0000000402067810ULL, 0x042fe20007ffe0ffULL, 0x0000000102057824ULL, 0x040fe200078e0217ULL,
0x0000000c020a7810ULL, 0x040fe20007ffe0ffULL, 0x00000008020c7824ULL, 0x040fe200078e00ffULL,
0x0000000802087810ULL, 0x000fe20007ffe0ffULL, 0x0000000100047824ULL, 0x040fe400078e0202ULL,
0x0000000100027824ULL, 0x000fe200078e0206ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee205ULL,
0x0000008004047825ULL, 0x000fc800078e00ffULL, 0x0000000106077824ULL, 0x000fe200078e0217ULL,
0x00000070040b7812ULL, 0x000fe200078ef803ULL, 0x00000008060e7824ULL, 0x000fe400078e00ffULL,
0x00000001000d7824ULL, 0x000fe400078e020aULL, 0x000000010a047824ULL, 0x040fe400078e0217ULL,
0x000000080a0f7824ULL, 0x000fe200078e00ffULL, 0x000062000b0a7a10ULL, 0x000fe20007f1e0ffULL,
0x0000000100067824ULL, 0x000fe200078e0208ULL, 0xfffffff80e007812ULL, 0x000fe200078ee207ULL,
0x0000000108097824ULL, 0x040fe200078e0217ULL, 0xfffffff80f107812ULL, 0x000fe200078ee204ULL,
0x0000000808087824ULL, 0x000fe200078e00ffULL, 0x00006300050b7a10ULL, 0x000fe200007fe4ffULL,
0x0000008002047825ULL, 0x000fc600078e00ffULL, 0xfffffff8080e7812ULL, 0x000fe200078ee209ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000007004027812ULL, 0x000fc600078ef803ULL,
0x000000800d087825ULL, 0x000fe200078e00ffULL, 0x0000007006047812ULL, 0x000fe400078ef803ULL,
0x0000620002027a10ULL, 0x000fe20007f1e0ffULL, 0x000000100c0d7824ULL, 0x000fe200078e021fULL,
0x0000007008037812ULL, 0x000fe200078ef803ULL, 0x00000010000f7824ULL, 0x100fe200078e021fULL,
0x0000620004047a10ULL, 0x000fe20007f3e0ffULL, 0x000000100e1d7824ULL, 0x100fe200078e021fULL,
0x0000620003067a10ULL, 0x000fe20007f5e0ffULL, 0x00000010101f7824ULL, 0x000fe200078e021fULL,
0x0000630005037a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a0d7faeULL, 0x0003e2000b901c48ULL, 0x0000630007057a10ULL, 0x000fc40000ffe4ffULL,
0x0000630009077a10ULL, 0x000fe200017fe4ffULL, 0x00000000020f7faeULL, 0x0003e8000b901c48ULL,
0x00000000041d7faeULL, 0x0003e8000b901c48ULL, 0x00000000061f7faeULL, 0x0003e4000b901c48ULL,
0x00000000130473c2ULL, 0x000ea200000e0000ULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x000000ffff227224ULL, 0x000fe200078e00ffULL, 0x0001a6a813027811ULL, 0x002fe200078e18ffULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x0001a6a804047891ULL, 0x004fe2000f8e203fULL, 0x0000000000527805ULL, 0x000fe2000001ff00ULL,
0x0000000000507805ULL, 0x000fe2000001ff00ULL, 0x0000000000567805ULL, 0x000fe2000001ff00ULL,
0x000000ffff557224ULL, 0x000fca00078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff6c7f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200002027f8cULL, 0x000ea2000c80043fULL,
0x000000ffff547224ULL, 0x000fe200078e00ffULL, 0x00000000005a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000587805ULL, 0x000fe2000001ff00ULL, 0x00000000005e7805ULL, 0x000fe2000001ff00ULL,
0x00000000005c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000627805ULL, 0x000fe2000001ff00ULL,
0x0000000000607805ULL, 0x000fe2000001ff00ULL, 0x0000000000667805ULL, 0x000fe2000001ff00ULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000af3000008947ULL, 0x000fea0003800000ULL,
0x00000010130e7824ULL, 0x000fe200078e00ffULL, 0x00000002ff107819ULL, 0x000fe2000001161aULL,
0x000000ffff007224ULL, 0x004fc400078e0003ULL, 0xff317217ff087424ULL, 0x000fe200078e00ffULL,
0x000000100e0e7812ULL, 0x000fe200078ee2ffULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x000000ffff2b7224ULL, 0x000fc400078e00ffULL, 0x000000ffff1c7224ULL, 0x00afca00078e00ffULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x000000041a0a7824ULL, 0x000fca00078e00ffULL,
0xfffffff80a0c7812ULL, 0x000fc800078ec0ffULL, 0x0001a6c80c0d7810ULL, 0x000fe20007ffe0ffULL,
0x01a6cc000c0b7984ULL, 0x000ea40000000800ULL, 0x800000000bff7812ULL, 0x004fe40007804800ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a021d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e03ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000001d0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a6cc000c0b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe40007804800ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010f007810ULL, 0x040fe20007ffe0ffULL,
0x000001000f0c7824ULL, 0x000fc600078e026eULL, 0x000000150000720cULL, 0x000fe40003f46070ULL,
0x000000400c037810ULL, 0x000fca0007ffe0ffULL, 0x00006600121f7a24ULL, 0x000fcc00078e0203ULL,
0x000004000000a947ULL, 0x000fea0003800000ULL, 0x00000003ff0a7819ULL, 0x000fe20000011617ULL,
0x00000010110b7824ULL, 0x000fe200078e00ffULL, 0x0000000316007217ULL, 0x000fe40007800000ULL,
0x000000080a1d7810ULL, 0x040fe20007ffe0ffULL, 0x000000010b027824ULL, 0x040fe200078e020aULL,
0x0000000c0a247810ULL, 0x000fe20007ffe0ffULL, 0x0000000100007824ULL, 0x000fe400078e0a03ULL,
0x00000001021c7824ULL, 0x040fe400078e0217ULL, 0x0000000802237824ULL, 0x000fe200078e00ffULL,
0x000000000b007217ULL, 0x000fe20007800000ULL, 0x0000001017037824ULL, 0x000fc400078e00ffULL,
0x0000000102027824ULL, 0x000fe200078e021fULL, 0xfffffff823237812ULL, 0x000fe200078ee21cULL,
0x0000000100007824ULL, 0x000fe200078e0a0bULL, 0x000000040a1c7810ULL, 0x000fe20007ffe0ffULL,
0x000000010b207824ULL, 0x000fe200078e021dULL, 0x0000007003217812ULL, 0x000fe200078ec0ffULL,
0x0000008002027825ULL, 0x000fe200078e00ffULL, 0x000000000a00720cULL, 0x080fe40003fa6070ULL,
0x000000001c00720cULL, 0x080fe20003f86070ULL, 0x000000010b1e7824ULL, 0x040fe200078e021cULL,
0x00000021021c7212ULL, 0x000fe200078efcffULL, 0x000000010b267824ULL, 0x000fe200078e0224ULL,
0x000000001d00720cULL, 0x080fe20003f66070ULL, 0x000000011e0a7824ULL, 0x000fe200078e021fULL,
0x000000002400720cULL, 0x000fe20003f06070ULL, 0x000000011e007824ULL, 0x000fe200078e0217ULL,
0x000062001c1c7a10ULL, 0x000fe20007fde0ffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0x00006300031d7a10ULL, 0x000fe200037fe4ffULL, 0x000000081e257824ULL, 0x000fe200078e00ffULL,
0x000000210a1e7212ULL, 0x080fe200078efcffULL, 0x0000000120027824ULL, 0x100fe400078e021fULL,
0x00000001260a7824ULL, 0x000fe200078e021fULL, 0x000062001e1e7a10ULL, 0x000fe20007fde0ffULL,
0x0000008002027825ULL, 0x000fe200078e00ffULL, 0xfffffff825257812ULL, 0x000fe400078ee200ULL,
0x000063000b1f7a10ULL, 0x000fe200037fe4ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002102027212ULL, 0x000fc400078efcffULL, 0x0001700013007811ULL, 0x000fe200078e68ffULL,
0x0000000120247824ULL, 0x100fe200078e0217ULL, 0x0000620002027a10ULL, 0x000fe20007fde0ffULL,
0x0000000820277824ULL, 0x000fe200078e00ffULL, 0x000000210a0a7212ULL, 0x000fe200078efcffULL,
0x0000000126207824ULL, 0x040fe200078e0217ULL, 0x0000630003037a10ULL, 0x000fe200037fe4ffULL,
0x0000000826697824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee224ULL,
0x0000001023217824ULL, 0x100fe200078e0200ULL, 0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL,
0x0000001025237824ULL, 0x000fe200078e0200ULL, 0xfffffff869697812ULL, 0x000fe200078ee220ULL,
0x0000001027257824ULL, 0x100fe200078e0200ULL, 0x000063000b0b7a10ULL, 0x000fe200037fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c217faeULL, 0x0005e4000e901c48ULL,
0x0000001069277824ULL, 0x000fc400078e0200ULL, 0x000000001e237faeULL, 0x0005e8000e101c48ULL,
0x0000000002257faeULL, 0x0005e8000d901c48ULL, 0x000000000a277faeULL, 0x0005e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001011007824ULL, 0x000fe400078e00ffULL,
0x0000001017027824ULL, 0x000fc600078e00ffULL, 0x0000000017007211ULL, 0x000fe400078fe8ffULL,
0x0000007002257812ULL, 0x000fe400078ec0ffULL, 0x0000000c00247810ULL, 0x040fe20007ffe0ffULL,
0x0000000100037824ULL, 0x040fe200078e0217ULL, 0x0000000800207810ULL, 0x040fe20007ffe0ffULL,
0x00000008000a7824ULL, 0x040fe400078e00ffULL, 0x0000000100027824ULL, 0x000fe400078e021fULL,
0x0000000824697824ULL, 0x000fe200078e00ffULL, 0xfffffff80a217812ULL, 0x000fe200078ee203ULL,
0x0000008002027825ULL, 0x000fe200078e00ffULL, 0x00000004000a7810ULL, 0x000fc60007ffe0ffULL,
0x00000001201d7824ULL, 0x000fe200078e0217ULL, 0x00000025021e7212ULL, 0x000fe200078efcffULL,
0x000000010a007824ULL, 0x040fe400078e021fULL, 0x000000010a0b7824ULL, 0x100fe200078e0217ULL,
0x000062001e1e7a10ULL, 0x000fe20007f1e0ffULL, 0x000000080a267824ULL, 0x000fe400078e00ffULL,
0x0000000124027824ULL, 0x000fe400078e0217ULL, 0x00000001200a7824ULL, 0x000fe200078e021fULL,
0xfffffff826237812ULL, 0x000fe200078ee20bULL, 0x0000000820207824ULL, 0x000fe200078e00ffULL,
0xfffffff869697812ULL, 0x000fe200078ee202ULL, 0x00000001241c7824ULL, 0x000fe200078e021fULL,
0x00006300031f7a10ULL, 0x000fe200007fe4ffULL, 0x0000008000027825ULL, 0x000fe200078e00ffULL,
0xfffffff820277812ULL, 0x000fc400078ee21dULL, 0x0001700013207811ULL, 0x000fe200078e68ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000002502027212ULL, 0x000fc600078efcffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000250a0a7212ULL, 0x080fe400078efcffULL,
0x0000620002027a10ULL, 0x000fe20007f1e0ffULL, 0x0000001021217824ULL, 0x100fe200078e0220ULL,
0x000000251c1c7212ULL, 0x000fe200078efcffULL, 0x0000001023237824ULL, 0x100fe200078e0220ULL,
0x000062000a0a7a10ULL, 0x000fe20007f7e0ffULL, 0x0000001027257824ULL, 0x100fe200078e0220ULL,
0x000062001c1c7a10ULL, 0x000fe20007f9e0ffULL, 0x0000001069277824ULL, 0x000fe200078e0220ULL,
0x0000630003037a10ULL, 0x000fe200007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001e217faeULL, 0x0005e2000b901c48ULL, 0x000063000b0b7a10ULL, 0x000fc40001ffe4ffULL,
0x000063001d1d7a10ULL, 0x000fe200027fe4ffULL, 0x0000000002237faeULL, 0x0005e8000b901c48ULL,
0x000000000a257faeULL, 0x0005e8000b901c48ULL, 0x000000001c277faeULL, 0x0005e4000b901c48ULL,
0xfffffff0141f7812ULL, 0x044fe400078ec0ffULL, 0xffffffe014007812ULL, 0x000fc400078ec0ffULL,
0x000000001f0573c2ULL, 0x000ea200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000001014037812ULL, 0x000fca00078ec0ffULL, 0x0000000100007824ULL, 0x000fc800078e0203ULL,
0x00000008111c7824ULL, 0x000fe200078e0200ULL, 0x0001a6b005057890ULL, 0x004fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6b0001f207f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a608001c1c7f8cULL, 0x000ea4000c80043fULL,
0x0000000000027805ULL, 0x000fc40000015200ULL, 0x00000008140b7812ULL, 0x000fca00078ec0ffULL,
0x0000000100237824ULL, 0x000fca00078e020bULL, 0x01a60c00230b7984ULL, 0x000f240000000800ULL,
0x800000000bff7812ULL, 0x014fe4000780481dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a02257210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e03ULL, 0x003d09002500780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402500780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff007819ULL, 0x000fc8000001140bULL,
0x0000002500007211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x0000000200007819ULL, 0x000fc8000000120bULL, 0x000000000000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a60c00230b7984ULL, 0x000ea40000000800ULL,
0x800000000bff7812ULL, 0x004fe4000780481dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010170b7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0a7819ULL, 0x000fe20000011617ULL, 0x000000201a007824ULL, 0x000fc600078e00ffULL,
0x000000700b0b7812ULL, 0x000fe400078ec0ffULL, 0xffffff8000007812ULL, 0x000fe400078ec0ffULL,
0x0000000c0a0a7812ULL, 0x000fc800078ec0ffULL, 0x000000000a007210ULL, 0x000fca0007ffe00bULL,
0x01a0000000037984ULL, 0x000ea80000000800ULL, 0x01a2000000027984ULL, 0x0006620000000800ULL,
0x000000080300720bULL, 0x004fe20003f1d000ULL, 0x000150827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000007806ULL, 0x008fc800000e0100ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x0000074000007945ULL, 0x000fe20003800000ULL, 0x00000001ff247424ULL, 0x000fe400078e00ffULL,
0x000000ffff1e7224ULL, 0x000fd200078e0008ULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x0000001a1000720cULL, 0x000fe40003f05270ULL, 0x000000080300720bULL, 0x000fe20003f74000ULL,
0x000150527f007947ULL, 0x000fd8000b800000ULL, 0x00000000001d7806ULL, 0x000fc400018e0100ULL,
0x000000801a258824ULL, 0x000fe200078e020bULL, 0x00000008031e7209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a258824ULL, 0x000fca00078e0225ULL,
0x01a4001e25008388ULL, 0x0005e20000000800ULL, 0x000000ff1d00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x000000081e087221ULL, 0x004fe20000010100ULL,
0x000000ff1dff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b08087820ULL, 0x000fc80000410000ULL, 0x0000000800277308ULL, 0x000ea40000000800ULL,
0x0000002722227220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x00014fa27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002664647220ULL, 0x08cfe40000410000ULL,
0x0000002665657220ULL, 0x080fe40000410000ULL, 0x0000002660607220ULL, 0x080fe40000410000ULL,
0x0000002661617220ULL, 0x080fe40000410000ULL, 0x000000265c5c7220ULL, 0x080fe40000410000ULL,
0x000000265d5d7220ULL, 0x000fc40000410000ULL, 0x0000002658587220ULL, 0x080fe40000410000ULL,
0x0000002659597220ULL, 0x080fe40000410000ULL, 0x0000002654547220ULL, 0x080fe40000410000ULL,
0x0000002655557220ULL, 0x080fe40000410000ULL, 0x0000002650507220ULL, 0x080fe40000410000ULL,
0x0000002651517220ULL, 0x000fc40000410000ULL, 0x000000264c4c7220ULL, 0x080fe40000410000ULL,
0x000000264d4d7220ULL, 0x080fe40000410000ULL, 0x0000002648487220ULL, 0x080fe40000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001dff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x00014e827f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002666667220ULL, 0x08cfe40000410000ULL, 0x0000002667677220ULL, 0x080fe40000410000ULL,
0x0000002662627220ULL, 0x080fe40000410000ULL, 0x0000002663637220ULL, 0x080fe40000410000ULL,
0x000000265e5e7220ULL, 0x080fe40000410000ULL, 0x000000265f5f7220ULL, 0x000fc40000410000ULL,
0x000000265a5a7220ULL, 0x080fe40000410000ULL, 0x000000265b5b7220ULL, 0x080fe40000410000ULL,
0x0000002656567220ULL, 0x080fe40000410000ULL, 0x0000002657577220ULL, 0x080fe40000410000ULL,
0x0000002652527220ULL, 0x080fe40000410000ULL, 0x0000002653537220ULL, 0x000fc40000410000ULL,
0x000000264e4e7220ULL, 0x080fe40000410000ULL, 0x000000264f4f7220ULL, 0x080fe40000410000ULL,
0x000000264a4a7220ULL, 0x080fe40000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00001dff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x00014d627f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe40000410000ULL,
0x0000002645457220ULL, 0x080fe40000410000ULL, 0x0000002640407220ULL, 0x080fe40000410000ULL,
0x0000002641417220ULL, 0x080fe40000410000ULL, 0x000000263c3c7220ULL, 0x080fe40000410000ULL,
0x000000263d3d7220ULL, 0x000fc40000410000ULL, 0x0000002638387220ULL, 0x080fe40000410000ULL,
0x0000002639397220ULL, 0x080fe40000410000ULL, 0x0000002634347220ULL, 0x080fe40000410000ULL,
0x0000002635357220ULL, 0x080fe40000410000ULL, 0x0000002630307220ULL, 0x080fe40000410000ULL,
0x0000002631317220ULL, 0x000fc40000410000ULL, 0x000000262c2c7220ULL, 0x080fe40000410000ULL,
0x000000262d2d7220ULL, 0x080fe40000410000ULL, 0x0000002628287220ULL, 0x080fe40000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000001dff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x00014c527f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe40000410000ULL,
0x0000002647477220ULL, 0x080fe40000410000ULL, 0x0000002642427220ULL, 0x080fe40000410000ULL,
0x0000002643437220ULL, 0x080fe40000410000ULL, 0x000000263e3e7220ULL, 0x080fe40000410000ULL,
0x000000263f3f7220ULL, 0x000fc40000410000ULL, 0x000000263a3a7220ULL, 0x080fe40000410000ULL,
0x000000263b3b7220ULL, 0x080fe40000410000ULL, 0x0000002636367220ULL, 0x080fe40000410000ULL,
0x0000002637377220ULL, 0x080fe40000410000ULL, 0x0000002632327220ULL, 0x080fe40000410000ULL,
0x0000002633337220ULL, 0x000fc40000410000ULL, 0x000000262e2e7220ULL, 0x080fe40000410000ULL,
0x000000262f2f7220ULL, 0x080fe40000410000ULL, 0x000000262a2a7220ULL, 0x080fe40000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000001d00ff7212ULL, 0x000fda00078030ffULL, 0x8000001e03030221ULL, 0x000fe20000010000ULL,
0x00007610ff240816ULL, 0x000fc60000000024ULL, 0x3fb8aa3b03030820ULL, 0x000fc80000410000ULL,
0x0000000300090308ULL, 0x000ea40000000800ULL, 0x0000000902020220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002202227221ULL, 0x002fc40000010000ULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x01a6ac001f007984ULL, 0x000e620000000800ULL,
0x0001a6a81f087810ULL, 0x000fe40007ffe0ffULL, 0x8000000000ff7812ULL, 0x002fe2000780486dULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff267224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000102600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000001c7805ULL, 0x000fcc0000015200ULL,
0x0000001c02257210ULL, 0x000fca0007f1e1ffULL, 0x000000011d1d7824ULL, 0x000fe200000e0e03ULL,
0x003d09002500780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402500780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff007819ULL, 0x000fc8000001141dULL, 0x0000002500007211ULL, 0x000fca00078110ffULL,
0x000000ffff1d7224ULL, 0x000fca00000e061dULL, 0x0000000200007819ULL, 0x000fc8000000121dULL,
0x000000000000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000126267810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01a6ac001f007984ULL, 0x000e640000000800ULL, 0x8000000000ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991024007816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff027819ULL, 0x000fe40000011617ULL,
0x0000541000277816ULL, 0x000fe20000000000ULL, 0x000148227f007947ULL, 0x000fea000b800000ULL,
0x00001f0227077589ULL, 0x0002a400000e0000ULL, 0x0000000802267810ULL, 0x000fe20007ffe0ffULL,
0x000148627f007947ULL, 0x000fea000b800000ULL, 0x0000001002007810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0027057589ULL, 0x0006a400000e0000ULL,
0x0000001802267810ULL, 0x008fe20007ffe0ffULL, 0x000148d27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004136c7824ULL, 0x000fe200078e00ffULL, 0x0000000817007812ULL, 0x000fe200078ec0ffULL,
0x000004001a1d7824ULL, 0x000fe200078e00ffULL, 0x00000004ff787819ULL, 0x100fe20000011617ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000046c6c7812ULL, 0x000fe200078ec0ffULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x0000000700037812ULL, 0x000fc400078ef817ULL,
0x0000006c17007211ULL, 0x000fe400078fe0ffULL, 0x0000001003027812ULL, 0x042fe200078efcffULL,
0x00000008031f7824ULL, 0x000fe200078e00ffULL, 0xfffff0001d1d7812ULL, 0x000fe200078ec0ffULL,
0x00000001031c7824ULL, 0x000fe400078e0200ULL, 0x0000000100007824ULL, 0x000fe200078e0202ULL,
0x000120001d6d7810ULL, 0x000fe20007ffe0ffULL, 0x0000000802257824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1c7812ULL, 0x000fe200078ee21cULL, 0x00000004111f7824ULL, 0x000fc400078e0278ULL,
0x0000000803277824ULL, 0x008fe200078e00ffULL, 0xfffffff8251d7812ULL, 0x000fe200078ee200ULL,
0x0000000103707824ULL, 0x000fe200078e021fULL, 0x0001600013007811ULL, 0x000fe200078e68ffULL,
0x000000101c687824ULL, 0x100fe400078e026dULL, 0x000000101d247824ULL, 0x000fe200078e026dULL,
0xfffffff827257812ULL, 0x000fc600078ee270ULL, 0x000000006868783bULL, 0x000e640000000200ULL,
0x0000001025747824ULL, 0x000fe400078e0200ULL, 0x000000002424783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000768687232ULL, 0x086fe40000000000ULL,
0x000000076a6a7232ULL, 0x000fe40000000000ULL, 0x0000000669697232ULL, 0x080fe40000000000ULL,
0x000000066b6b7232ULL, 0x000fc40000000000ULL, 0x0000000524247232ULL, 0x088fe40000000000ULL,
0x0000000526267232ULL, 0x000fe40000000000ULL, 0x0000000425257232ULL, 0x080fe40000000000ULL,
0x0000000427277232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000803717824ULL, 0x000fe200078e00ffULL, 0x0000000270707810ULL, 0x000fe20007ffe0ffULL,
0x000000007474783bULL, 0x000f220000004200ULL, 0x00000001021f7824ULL, 0x000fe200078e021fULL,
0x000008d000007945ULL, 0x000fe20003800000ULL, 0xfffffff871717812ULL, 0x000fca00078ee270ULL,
0x0000001071717824ULL, 0x000fcc00078e0200ULL, 0x000000007170783bULL, 0x000ee20000004200ULL,
0x00000018ff7a7819ULL, 0x010fe20000011475ULL, 0x0001000077857824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fe40000011474ULL, 0x0000007a007e7306ULL, 0x0009e20000200c00ULL,
0x00000018ff7c7819ULL, 0x000fe40000011476ULL, 0x00000018ff7d7819ULL, 0x000fe40000011477ULL,
0x00000018ff857819ULL, 0x000fc60000011485ULL, 0x00000079007b7306ULL, 0x0005e20000200c00ULL,
0x00000100747a7824ULL, 0x010fe200078e00ffULL, 0x00000018ff837819ULL, 0x008fe20000011473ULL,
0x0000010070887824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe20000011470ULL,
0x0000010073927824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x00000018ff807819ULL, 0x000fe20000011471ULL, 0x0000008300937306ULL, 0x0007e20000200c00ULL,
0x0000888074797816ULL, 0x044fe200000000ffULL, 0x0001000074747824ULL, 0x000fe200078e00ffULL,
0x0000888070877816ULL, 0x040fe200000000ffULL, 0x0001000070707824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fc40000011472ULL, 0x00008880728e7816ULL, 0x000fe200000000ffULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x0000010077837824ULL, 0x008fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000888073917816ULL, 0x000fe400000000ffULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x0000007a007a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff927819ULL, 0x000fc40000011492ULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x00000018ff887819ULL, 0x000fc60000011488ULL, 0x0000007f008a7306ULL, 0x0005f00000200c00ULL,
0x00000080008c7306ULL, 0x0007e20000200c00ULL, 0x00008880767f7816ULL, 0x004fce00000000ffULL,
0x0000008300847306ULL, 0x0005e20000200c00ULL, 0x0000010076807824ULL, 0x048fe400078e00ffULL,
0x0001000076767824ULL, 0x000fc600078e00ffULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x00000018ff767819ULL, 0x000fe20000011476ULL, 0x0000008100907306ULL, 0x0007e20000200c00ULL,
0x0000888071837816ULL, 0x004fce00000000ffULL, 0x0000007c00827306ULL, 0x0005e20000200c00ULL,
0x0000888077817816ULL, 0x008fce00000000ffULL, 0x0000007d00867306ULL, 0x0007e20000200c00ULL,
0x00008880757c7816ULL, 0x004fce00000000ffULL, 0x0000007600777306ULL, 0x0005220000200c00ULL,
0x00000100757d7824ULL, 0x048fe400078e00ffULL, 0x0001000075757824ULL, 0x000fc600078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x0000008300897306ULL, 0x0007e20000200c00ULL,
0x0000010071767824ULL, 0x044fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011475ULL,
0x0001000071717824ULL, 0x000fc600078e00ffULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x00000070008b7306ULL, 0x0004620000200c00ULL, 0x0000010072837824ULL, 0x048fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x0001000072727824ULL, 0x000fe200078e00ffULL,
0x0000541077827816ULL, 0x010fe40000000082ULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x00000018ff727819ULL, 0x000fe20000011472ULL, 0x0000008e008e7306ULL, 0x000fe20000200c00ULL,
0x0000541079707816ULL, 0x004fe2000000007aULL, 0x0001000073797824ULL, 0x000fca00078e00ffULL,
0x00000018ff797819ULL, 0x000fe20000011479ULL, 0x00000083008f7306ULL, 0x000ea20000200c00ULL,
0x000054108b8a7816ULL, 0x002fce000000008aULL, 0x0000009100917306ULL, 0x000ff00000200c00ULL,
0x0000009200927306ULL, 0x000e620000200c00ULL, 0x000054108e8e7816ULL, 0x004fce000000008fULL,
0x0000007c007c7306ULL, 0x000ff00000200c00ULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x00005410918f7816ULL, 0x002fce0000000092ULL, 0x0000007400747306ULL, 0x000e620000200c00ULL,
0x0000008e684c723cULL, 0x080f6e000000184cULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x0000008e242c723cULL, 0x000f6e000000182cULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x0000541074747816ULL, 0x002fce000000007bULL, 0x0000008000807306ULL, 0x000e620000200c00ULL,
0x0000541075757816ULL, 0x004fce000000007eULL, 0x0000008100817306ULL, 0x000ea20000200c00ULL,
0x000000746860723cULL, 0x080f6e0000001860ULL, 0x0000008500857306ULL, 0x000ee20000200c00ULL,
0x000054107f807816ULL, 0x002fe20000000080ULL, 0x000000742440723cULL, 0x000f6c0000001840ULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x0000541081817816ULL, 0x004fce0000000084ULL,
0x0000008800887306ULL, 0x000e620000200c00ULL, 0x0000541085837816ULL, 0x008fe20000000086ULL,
0x00000080685c723cULL, 0x040f6c000000185cULL, 0x0000007600767306ULL, 0x000ea40000200c00ULL,
0x000000826858723cULL, 0x000f6c0000001858ULL, 0x00000071008d7306ULL, 0x0007220000200c00ULL,
0x0000541087887816ULL, 0x002fe20000000088ULL, 0x00000080243c723cULL, 0x040f6c000000183cULL,
0x0000007200737306ULL, 0x000e620000200c00ULL, 0x000054107c717816ULL, 0x008fe2000000007dULL,
0x000000822438723cULL, 0x000f620000001838ULL, 0x0000541089897816ULL, 0x004fca0000000076ULL,
0x00000079007a7306ULL, 0x000ea20000200c00ULL, 0x000054108d8b7816ULL, 0x010fe2000000008cULL,
0x000000706864723cULL, 0x000f620000001864ULL, 0x0000541073907816ULL, 0x002fce0000000090ULL,
0x000000886854723cULL, 0x000f620000001854ULL, 0x000054107a917816ULL, 0x004fce0000000093ULL,
0x0000008a6850723cULL, 0x040f700000001850ULL, 0x000000906848723cULL, 0x000b6e0000001848ULL,
0x000000026c697812ULL, 0x020fe200078efcffULL, 0x00000008036b7824ULL, 0x000fe200078e00ffULL,
0x000000702444723cULL, 0x000f620000001844ULL, 0x00000008026a7824ULL, 0x000fc400078e00ffULL,
0x0000000178697824ULL, 0x000fe400078e0269ULL, 0x00000008026c7824ULL, 0x040fe400078e00ffULL,
0x0000000103687824ULL, 0x100fe200078e0269ULL, 0x000000882434723cULL, 0x000f620000001834ULL,
0x0000000102697824ULL, 0x000fc600078e0269ULL, 0xfffffff86b687812ULL, 0x000fe400078ee268ULL,
0xfffffff86a6a7812ULL, 0x000fe400078ee269ULL, 0xfffffff86c697812ULL, 0x000fe200078ee21fULL,
0x0000001068687824ULL, 0x100fe200078e026dULL, 0x0000008a2430723cULL, 0x040f620000001830ULL,
0x000000106a6d7824ULL, 0x000fe400078e026dULL, 0x0000001069747824ULL, 0x000fe400078e0200ULL,
0x000000006868783bULL, 0x000e660000000200ULL, 0x000000902428723cULL, 0x000b640000001828ULL,
0x000000006d24783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000768687232ULL, 0x082fe40000000000ULL,
0x000000076a6a7232ULL, 0x000fc40000000000ULL, 0x0000000669697232ULL, 0x080fe40000000000ULL,
0x000000066b6b7232ULL, 0x000fe40000000000ULL, 0x0000000524247232ULL, 0x088fe40000000000ULL,
0x0000000526267232ULL, 0x000fe40000000000ULL, 0x0000000425257232ULL, 0x080fe40000000000ULL,
0x0000000427277232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000008026c7824ULL, 0x000fe200078e00ffULL, 0x000000021f1f7810ULL, 0x000fe20007ffe0ffULL,
0x000000007474783bULL, 0x000f260000004200ULL, 0xfffffff86c1f7812ULL, 0x000fca00078ee21fULL,
0x000000101f1f7824ULL, 0x000fca00078e0200ULL, 0x000000001f70783bULL, 0x0004e20000004200ULL,
0x00000018ff6c7819ULL, 0x010fe40000011474ULL, 0x00000018ff797819ULL, 0x000fe40000011476ULL,
0x0000006c00787306ULL, 0x0009e20000200c00ULL, 0x00000018ff6d7819ULL, 0x004fe40000011475ULL,
0x00000018ff7a7819ULL, 0x000fe40000011477ULL, 0x00008880741f7816ULL, 0x000fc600000000ffULL,
0x0000007900807306ULL, 0x0005e20000200c00ULL, 0x00000100746c7824ULL, 0x050fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x008fe20000011471ULL, 0x0001000074747824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe20000011472ULL, 0x0000010070847824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe20000011473ULL, 0x00000100728a7824ULL, 0x000fe200078e00ffULL,
0x0000006d007c7306ULL, 0x0007e20000200c00ULL, 0x0000010075797824ULL, 0x004fe200078e00ffULL,
0x00000018ff7b7819ULL, 0x000fc40000011470ULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000888070837816ULL, 0x040fe200000000ffULL, 0x0001000070707824ULL, 0x000fe200078e00ffULL,
0x0000007d00887306ULL, 0x0005e20000200c00ULL, 0x00008880756d7816ULL, 0x008fe400000000ffULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x00000018ff707819ULL, 0x000fe20000011470ULL, 0x0000007e008c7306ULL, 0x0007e20000200c00ULL,
0x00008880767d7816ULL, 0x004fc400000000ffULL, 0x00008880738d7816ULL, 0x000fe400000000ffULL,
0x0000888071857816ULL, 0x000fe400000000ffULL, 0x00000018ff8a7819ULL, 0x000fe2000001148aULL,
0x0000007f008e7306ULL, 0x0005e20000200c00ULL, 0x00000100767e7824ULL, 0x048fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe20000011484ULL, 0x0001000076767824ULL, 0x000fc600078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000007a00817306ULL, 0x000fe20000200c00ULL,
0x00010000777f7824ULL, 0x004fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fc80000011476ULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000006d006d7306ULL, 0x000ff00000200c00ULL,
0x00000079007a7306ULL, 0x0004f00000200c00ULL, 0x0000001f001f7306ULL, 0x000fe20000200c00ULL,
0x0000888077797816ULL, 0x004fce00000000ffULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x000054106d6d7816ULL, 0x008fce000000007aULL, 0x0000007b00867306ULL, 0x0007f00000200c00ULL,
0x0000007000877306ULL, 0x0008620000200c00ULL, 0x00010000757b7824ULL, 0x008fe200078e00ffULL,
0x000054101f6c7816ULL, 0x004fc8000000006cULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x0000007400757306ULL, 0x0005e20000200c00ULL, 0x0000010073707824ULL, 0x050fe200078e00ffULL,
0x0000006c2444723cULL, 0x000f620000001844ULL, 0x0001000073737824ULL, 0x000fc600078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000007f00827306ULL, 0x0007220000200c00ULL,
0x0000010077747824ULL, 0x004fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe20000011473ULL,
0x0000006c6864723cULL, 0x002f620000001864ULL, 0x0000541087867816ULL, 0x000fe40000000086ULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000007600777306ULL, 0x0002a20000200c00ULL,
0x00008880727f7816ULL, 0x048fe200000000ffULL, 0x0001000072727824ULL, 0x000fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011472ULL, 0x0000007f008b7306ULL, 0x000fe20000200c00ULL,
0x0000010071767824ULL, 0x042fe200078e00ffULL, 0x0000541082817816ULL, 0x010fe20000000081ULL,
0x0001000071717824ULL, 0x000fc600078e00ffULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x0000008a008a7306ULL, 0x000e620000200c00ULL,
0x0000541077807816ULL, 0x004fce0000000080ULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x000000802438723cULL, 0x080f6e0000001838ULL, 0x00000070007a7306ULL, 0x0004e20000200c00ULL,
0x000054108b8a7816ULL, 0x002fe2000000008aULL, 0x000000806858723cULL, 0x000f6c0000001858ULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x0000541075707816ULL, 0x004fce0000000078ULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x000054108d8b7816ULL, 0x008fce000000007aULL,
0x0000007e007e7306ULL, 0x000e620000200c00ULL, 0x0000008a242c723cULL, 0x080f6e000000182cULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x0000008a684c723cULL, 0x000f6e000000184cULL,
0x0000007400747306ULL, 0x000ea20000200c00ULL, 0x000054107d7e7816ULL, 0x002fce000000007eULL,
0x0000008300837306ULL, 0x000ff00000200c00ULL, 0x0000008400847306ULL, 0x000e620000200c00ULL,
0x00005410797f7816ULL, 0x004fce0000000074ULL, 0x0000008500857306ULL, 0x000fe20000200c00ULL,
0x0000007e243c723cULL, 0x080f6e000000183cULL, 0x0000007600767306ULL, 0x000ea20000200c00ULL,
0x0000541083847816ULL, 0x002fe20000000084ULL, 0x0000007e685c723cULL, 0x000f6c000000185cULL,
0x0000007100897306ULL, 0x0002f00000200c00ULL, 0x00000072001f7306ULL, 0x000f220000200c00ULL,
0x000054107b717816ULL, 0x002fc4000000007cULL, 0x0000541085857816ULL, 0x004fca0000000076ULL,
0x0000007300737306ULL, 0x000e620000200c00ULL, 0x0000541089877816ULL, 0x008fe20000000088ULL,
0x000000702440723cULL, 0x000f620000001840ULL, 0x000054101f8c7816ULL, 0x010fe2000000008cULL,
0x000000021a1f7824ULL, 0x000fcc00078e00ffULL, 0x000000842434723cULL, 0x000f620000001834ULL,
0xfffffff81f1f7812ULL, 0x000fe400078ec0ffULL, 0x00005410738d7816ULL, 0x002fca000000008eULL,
0x000000862430723cULL, 0x040f700000001830ULL, 0x0000008c2428723cULL, 0x000f700000001828ULL,
0x000000706860723cULL, 0x040f700000001860ULL, 0x000000846854723cULL, 0x040f700000001854ULL,
0x000000866850723cULL, 0x040f700000001850ULL, 0x0000008c6848723cULL, 0x000b6e0000001848ULL,
0x0001a6c813687811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000068687f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a688001fff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff6a7224ULL, 0x000fc600078e00ffULL,
0x0000000000247805ULL, 0x000fc80000015200ULL, 0x000004000d1f7984ULL, 0x004ea40000000800ULL,
0x800000001fff7812ULL, 0x006fc40007804869ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1f7819ULL, 0x000fc80000011427ULL,
0x000000261f1f7211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x000000021f1f7819ULL, 0x000fc80000001226ULL, 0x0000001f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000d1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000800c257810ULL, 0x000fca0007ffe0ffULL, 0x00006600126c7a24ULL, 0x000fe200078e0225ULL,
0x000003d00000a947ULL, 0x000fea0003800000ULL, 0x00000025161f7217ULL, 0x000fe20007800000ULL,
0x0000001011707824ULL, 0x000fe200078e00ffULL, 0x00000003ff277819ULL, 0x000fc60000011617ULL,
0x000000011f1f7824ULL, 0x000fe200078e0a25ULL, 0x0000000427697810ULL, 0x040fe20007ffe0ffULL,
0x0000000170247824ULL, 0x040fe200078e0227ULL, 0x00000008276b7810ULL, 0x040fe40007ffe0ffULL,
0x0000001f701f7217ULL, 0x000fe20007800000ULL, 0x0000000124257824ULL, 0x040fe200078e0217ULL,
0x0000000c27737810ULL, 0x000fe20007ffe0ffULL, 0x0000000824267824ULL, 0x000fe400078e00ffULL,
0x0000000170717824ULL, 0x000fc400078e0269ULL, 0x0000000124247824ULL, 0x000fe200078e026cULL,
0xfffffff8266d7812ULL, 0x000fe200078ee225ULL, 0x000000011f1f7824ULL, 0x000fe400078e0a70ULL,
0x0000000171267824ULL, 0x000fe400078e026cULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000001f2700720cULL, 0x080fe40003f06070ULL, 0x0000001f6900720cULL, 0x000fe20003f86070ULL,
0x0000000170727824ULL, 0x000fe200078e026bULL, 0x0000000b246a7212ULL, 0x000fe200078efcffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000001f6b00720cULL, 0x000fc40003f66070ULL,
0x000062006a6a7a10ULL, 0x000fe20007fbe0ffULL, 0x0000000170707824ULL, 0x000fe200078e0273ULL,
0x0000000b26267212ULL, 0x000fe200078efcffULL, 0x0000000172687824ULL, 0x100fe200078e026cULL,
0x00006300256b7a10ULL, 0x000fe20002ffe4ffULL, 0x0000000170247824ULL, 0x000fe200078e026cULL,
0x0000620026267a10ULL, 0x000fe20007fde0ffULL, 0x0000008068687825ULL, 0x000fe200078e00ffULL,
0x0000001f7300720cULL, 0x000fe40003fa6070ULL, 0x0000630027277a10ULL, 0x000fe200037fe4ffULL,
0x00000001716c7824ULL, 0x040fe200078e0217ULL, 0x0000000b68687212ULL, 0x000fe200078efcffULL,
0x0000000871717824ULL, 0x000fc400078e00ffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000620068687a10ULL, 0x000fe40007fde0ffULL, 0xfffffff8711f7812ULL, 0x000fe200078ee26cULL,
0x00000001726c7824ULL, 0x100fe200078e0217ULL, 0x0000000b24247212ULL, 0x000fe200078efcffULL,
0x0000000872717824ULL, 0x000fe200078e00ffULL, 0x0000630069697a10ULL, 0x000fe200037fe4ffULL,
0x0000000170727824ULL, 0x000fe200078e0217ULL, 0x0000620024247a10ULL, 0x000fe20007fde0ffULL,
0x0000000870737824ULL, 0x000fe200078e00ffULL, 0xfffffff871717812ULL, 0x000fe200078ee26cULL,
0x000000106d6d7824ULL, 0x100fe200078e0200ULL, 0x0000630025257a10ULL, 0x000fe200037fe4ffULL,
0x000000101f1f7824ULL, 0x000fe200078e0200ULL, 0xfffffff873737812ULL, 0x000fe200078ee272ULL,
0x0000001071717824ULL, 0x100fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a6d7faeULL, 0x0003e6000c101c48ULL, 0x0000001073737824ULL, 0x000fe200078e0200ULL,
0x00000000261f7faeULL, 0x0003e8000e101c48ULL, 0x0000000068717faeULL, 0x0003e8000d901c48ULL,
0x0000000024737faeULL, 0x0003e2000e901c48ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x0000001011247824ULL, 0x000fca00078e00ffULL, 0x00000024171f7211ULL, 0x000fc800078fe8ffULL,
0x000000041f267810ULL, 0x040fe20007ffe0ffULL, 0x000000011f247824ULL, 0x140fe200078e0217ULL,
0x000000081f687810ULL, 0x040fe20007ffe0ffULL, 0x000000081f6d7824ULL, 0x000fe400078e00ffULL,
0x0000000126257824ULL, 0x140fe400078e0217ULL, 0x00000008266a7824ULL, 0x000fe200078e00ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee224ULL, 0x000000011f247824ULL, 0x040fe200078e026cULL,
0x0000000c1f1f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000168277824ULL, 0x000fe200078e0217ULL,
0xfffffff86a717812ULL, 0x000fe200078ee225ULL, 0x0000000868707824ULL, 0x000fc400078e00ffULL,
0x0000000126267824ULL, 0x000fe400078e026cULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0xfffffff870737812ULL, 0x000fc600078ee227ULL, 0x0000000168687824ULL, 0x100fe200078e026cULL,
0x0000000b24247212ULL, 0x000fe200078efcffULL, 0x000000011f6a7824ULL, 0x000fe400078e026cULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000620024247a10ULL, 0x000fc60007f1e0ffULL,
0x0000008068687825ULL, 0x000fe200078e00ffULL, 0x0000000b26267212ULL, 0x080fe400078efcffULL,
0x0000630025257a10ULL, 0x000fe200007fe4ffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000000b68687212ULL, 0x080fe400078efcffULL, 0x0000620026267a10ULL, 0x000fe20007f7e0ffULL,
0x000000011f6c7824ULL, 0x040fe200078e0217ULL, 0x0000000b6a6a7212ULL, 0x000fe200078efcffULL,
0x000000081f1f7824ULL, 0x000fe200078e00ffULL, 0x0000620068687a10ULL, 0x000fe20007f1e0ffULL,
0x000000106d6d7824ULL, 0x100fe200078e0200ULL, 0x000062006a6a7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001071717824ULL, 0x000fe200078e0200ULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee26cULL,
0x0000001073737824ULL, 0x100fe200078e0200ULL, 0x0000630027277a10ULL, 0x000fe20001ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000246d7faeULL, 0x0003e2000b901c48ULL,
0x0000630069697a10ULL, 0x000fe200007fe4ffULL, 0x000000101f1f7824ULL, 0x000fe200078e0200ULL,
0x000063006b6b7a10ULL, 0x000fe200027fe4ffULL, 0x0000000026717faeULL, 0x0003e8000b901c48ULL,
0x0000000068737faeULL, 0x0003e8000b901c48ULL, 0x000000006a1f7faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fda0003f0f070ULL, 0x00000000080503c2ULL, 0x000e640000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x002fe20008000a05ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000086c7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6280023687f8cULL, 0x000664000c80043fULL, 0x0000000000247805ULL, 0x000fc40000015200ULL,
0xffffffe0141f7812ULL, 0x040fe400078ec0ffULL, 0x0000001014267812ULL, 0x000fca00078ec0ffULL,
0x000000011f267824ULL, 0x000fc800078e0226ULL, 0x00000008116a7824ULL, 0x000fca00078e0226ULL,
0x01a62c006a1f7984ULL, 0x000f240000000800ULL, 0x800000001fff7812ULL, 0x012fe40007804869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff6b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x0000002624267210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e25ULL, 0x003d09002600780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402600780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff1f7819ULL, 0x000fc80000011427ULL,
0x000000261f1f7211ULL, 0x000fca00078110ffULL, 0x000000ffff267224ULL, 0x000fca00000e0627ULL,
0x000000021f1f7819ULL, 0x000fc80000001226ULL, 0x0000001f0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000016b6b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a62c006a1f7984ULL, 0x000e640000000800ULL,
0x800000001fff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000201a1f7824ULL, 0x000fca00078e00ffULL, 0xffffff801f247812ULL, 0x000fc800078ec0ffULL,
0x000000800b1f7810ULL, 0x000fca0007ffe024ULL, 0x000000010a1f7824ULL, 0x000fca00078e021fULL,
0x01a000001f697984ULL, 0x000e680000000800ULL, 0x01a200001f687984ULL, 0x0006a20000000800ULL,
0x0000001e6900720bULL, 0x002fe20003f1d000ULL, 0x000127d27f007947ULL, 0x000fd8000b800000ULL,
0x00000000001f7806ULL, 0x008fc800000e0100ULL, 0x000000ff1f00720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff257424ULL, 0x000fe400078e00ffULL,
0x000000ffff247224ULL, 0x000fd200078e001eULL, 0x0000072000008947ULL, 0x000fea0003800000ULL,
0x0000000110257810ULL, 0x000fe40007ffe0ffULL, 0x0000001e6900720bULL, 0x000fe40003f74000ULL,
0x0000001a2500720cULL, 0x000fe20003f05270ULL, 0x000127927f007947ULL, 0x000fd4000b800000ULL,
0x0000000000707806ULL, 0x000fc400018e0100ULL, 0x000000801a258824ULL, 0x000fe200078e020bULL,
0x0000001e69247209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x000000010a258824ULL, 0x000fca00078e0225ULL, 0x01a4002425008388ULL, 0x0003e20000000800ULL,
0x000000ff7000720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000001e241e7221ULL, 0x002fe20000010100ULL, 0x000000ff70ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b1e1e7820ULL, 0x000fc80000410000ULL,
0x0000001e00277308ULL, 0x000e640000000800ULL, 0x0000002722227220ULL, 0x002fc80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff267819ULL, 0x000fe20000011617ULL,
0x000126e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002664647220ULL, 0x08cfe40000410000ULL, 0x0000002665657220ULL, 0x080fe40000410000ULL,
0x0000002660607220ULL, 0x080fe40000410000ULL, 0x0000002661617220ULL, 0x080fe40000410000ULL,
0x000000265c5c7220ULL, 0x080fe40000410000ULL, 0x000000265d5d7220ULL, 0x000fc40000410000ULL,
0x0000002658587220ULL, 0x080fe40000410000ULL, 0x0000002659597220ULL, 0x080fe40000410000ULL,
0x0000002654547220ULL, 0x080fe40000410000ULL, 0x0000002655557220ULL, 0x080fe40000410000ULL,
0x0000002650507220ULL, 0x080fe40000410000ULL, 0x0000002651517220ULL, 0x000fc40000410000ULL,
0x000000264c4c7220ULL, 0x080fe40000410000ULL, 0x000000264d4d7220ULL, 0x080fe40000410000ULL,
0x0000002648487220ULL, 0x080fe40000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0070ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000817267811ULL, 0x000fe200078ff0ffULL, 0x000125c27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x00066400000e0000ULL, 0x0000002666667220ULL, 0x086fe40000410000ULL,
0x0000002667677220ULL, 0x080fe40000410000ULL, 0x0000002662627220ULL, 0x080fe40000410000ULL,
0x0000002663637220ULL, 0x080fe40000410000ULL, 0x000000265e5e7220ULL, 0x080fe40000410000ULL,
0x000000265f5f7220ULL, 0x000fc40000410000ULL, 0x000000265a5a7220ULL, 0x080fe40000410000ULL,
0x000000265b5b7220ULL, 0x080fe40000410000ULL, 0x0000002656567220ULL, 0x080fe40000410000ULL,
0x0000002657577220ULL, 0x080fe40000410000ULL, 0x0000002652527220ULL, 0x080fe40000410000ULL,
0x0000002653537220ULL, 0x000fc40000410000ULL, 0x000000264e4e7220ULL, 0x080fe40000410000ULL,
0x000000264f4f7220ULL, 0x080fe40000410000ULL, 0x000000264a4a7220ULL, 0x080fe40000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000070ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001017267811ULL, 0x000fe200078ff0ffULL,
0x000124a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002644447220ULL, 0x08cfe40000410000ULL, 0x0000002645457220ULL, 0x080fe40000410000ULL,
0x0000002640407220ULL, 0x080fe40000410000ULL, 0x0000002641417220ULL, 0x080fe40000410000ULL,
0x000000263c3c7220ULL, 0x080fe40000410000ULL, 0x000000263d3d7220ULL, 0x000fc40000410000ULL,
0x0000002638387220ULL, 0x080fe40000410000ULL, 0x0000002639397220ULL, 0x080fe40000410000ULL,
0x0000002634347220ULL, 0x080fe40000410000ULL, 0x0000002635357220ULL, 0x080fe40000410000ULL,
0x0000002630307220ULL, 0x080fe40000410000ULL, 0x0000002631317220ULL, 0x000fc40000410000ULL,
0x000000262c2c7220ULL, 0x080fe40000410000ULL, 0x000000262d2d7220ULL, 0x080fe40000410000ULL,
0x0000002628287220ULL, 0x080fe40000410000ULL, 0x0000002629297220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000070ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001817267811ULL, 0x000fe200078ff0ffULL,
0x000123927f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0002e400000e0000ULL,
0x0000002646467220ULL, 0x08cfe40000410000ULL, 0x0000002647477220ULL, 0x080fe40000410000ULL,
0x0000002642427220ULL, 0x080fe40000410000ULL, 0x0000002643437220ULL, 0x080fe40000410000ULL,
0x000000263e3e7220ULL, 0x080fe40000410000ULL, 0x000000263f3f7220ULL, 0x000fc40000410000ULL,
0x000000263a3a7220ULL, 0x080fe40000410000ULL, 0x000000263b3b7220ULL, 0x080fe40000410000ULL,
0x0000002636367220ULL, 0x080fe40000410000ULL, 0x0000002637377220ULL, 0x080fe40000410000ULL,
0x0000002632327220ULL, 0x080fe40000410000ULL, 0x0000002633337220ULL, 0x000fc40000410000ULL,
0x000000262e2e7220ULL, 0x080fe40000410000ULL, 0x000000262f2f7220ULL, 0x080fe40000410000ULL,
0x000000262a2a7220ULL, 0x080fe40000410000ULL, 0x000000262b2b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x000000701fff7212ULL, 0x000fe200078030ffULL,
0x00000001ff257424ULL, 0x000fd800078e00ffULL, 0x8000002469690221ULL, 0x000fe20000010000ULL,
0x00007610ff250816ULL, 0x000fc60000000025ULL, 0x3fb8aa3b69690820ULL, 0x000fc80000410000ULL,
0x0000006900090308ULL, 0x000e640000000800ULL, 0x0000000968680220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002268227221ULL, 0x004fc40000010000ULL,
0x00000000001e7805ULL, 0x000fca0000015200ULL, 0xfffffff0146a7812ULL, 0x000fca00078ec0ffULL,
0x01a6b4006a277984ULL, 0x008e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe40007804821ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff687224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000106800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000267805ULL, 0x000fcc0000015200ULL, 0x000000261e697210ULL, 0x000fca0007f1e1ffULL,
0x0000000127277824ULL, 0x000fe200000e0e1fULL, 0x003d09006900780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406900780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff267819ULL, 0x000fc80000011427ULL,
0x0000006926267211ULL, 0x000fca00078110ffULL, 0x000000ffff277224ULL, 0x000fca00000e0627ULL,
0x0000000226267819ULL, 0x000fc80000001227ULL, 0x000000260000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000168687810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6b4006a277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe40007804821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910251e7816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff1e00720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff1e7819ULL, 0x000fe40000011617ULL,
0x0000541004277816ULL, 0x000fe20000000004ULL, 0x00011f727f007947ULL, 0x000fea000b800000ULL,
0x00001f1e27077589ULL, 0x0002a400000e0000ULL, 0x000000081e267810ULL, 0x000fe20007ffe0ffULL,
0x00011fb27f007947ULL, 0x000fea000b800000ULL, 0x000000101e047810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0427057589ULL, 0x0006a400000e0000ULL,
0x000000181e267810ULL, 0x008fe20007ffe0ffULL, 0x000120227f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000041a1e7824ULL, 0x042fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000004001a207824ULL, 0x040fe200078e00ffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x000010001a1f7824ULL, 0x000fe200078e00ffULL, 0x000000041e1e7812ULL, 0x000fe200078ec0ffULL,
0x0000000803267824ULL, 0x008fe200078e00ffULL, 0xfffff00020207812ULL, 0x000fc400078ec0ffULL,
0x0000001e171e7211ULL, 0x000fe400078fe0ffULL, 0x0001300020207810ULL, 0x000fe40007ffe0ffULL,
0xffffe0001f217812ULL, 0x000fe200078ec0ffULL, 0x00000001031f7824ULL, 0x000fe400078e021eULL,
0x000000101c707824ULL, 0x100fe200078e0220ULL, 0x0001700021257810ULL, 0x000fe20007ffe0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0220ULL, 0xfffffff8261c7812ULL, 0x000fc600078ee21fULL,
0x000000007070783bULL, 0x000e640000000200ULL, 0x000000101c787824ULL, 0x000fe400078e0225ULL,
0x000000001d68783bULL, 0x0006a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000770707232ULL, 0x086fe40000000000ULL, 0x0000000772727232ULL, 0x000fe40000000000ULL,
0x0000000671717232ULL, 0x080fe40000000000ULL, 0x0000000673737232ULL, 0x000fc40000000000ULL,
0x0000000568687232ULL, 0x080fe40000000000ULL, 0x000000056a6a7232ULL, 0x000fe40000000000ULL,
0x0000000469697232ULL, 0x080fe40000000000ULL, 0x000000046b6b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000803267824ULL, 0x000fe200078e00ffULL,
0x000000021f217810ULL, 0x000fe20007ffe0ffULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x0000091000007945ULL, 0x000fe40003800000ULL, 0xfffffff826217812ULL, 0x000fca00078ee221ULL,
0x0000001021747824ULL, 0x000fcc00078e0225ULL, 0x000000007474783bULL, 0x000ee20000004200ULL,
0x00000018ff1f7819ULL, 0x010fe20000011479ULL, 0x000001007b837824ULL, 0x040fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe4000001147aULL, 0x0000001f007d7306ULL, 0x0009e20000200c00ULL,
0x00000018ff277819ULL, 0x000fe4000001147bULL, 0x00000018ff1d7819ULL, 0x008fe40000011478ULL,
0x000088807b817816ULL, 0x040fe200000000ffULL, 0x000100007b7b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011483ULL, 0x0000002700857306ULL, 0x0007e20000200c00ULL,
0x00000100781f7824ULL, 0x010fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe20000011476ULL,
0x0000010074877824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fc40000011474ULL,
0x00000018ff807819ULL, 0x000fe40000011477ULL, 0x0000007f008d7306ULL, 0x0009e20000200c00ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x0000888079277816ULL, 0x008fe400000000ffULL,
0x00000018ff7e7819ULL, 0x000fe40000011475ULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000007c008a7306ULL, 0x0007e20000200c00ULL, 0x000001007a7f7824ULL, 0x010fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fc40000011487ULL, 0x00008880778f7816ULL, 0x000fe400000000ffULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000008000907306ULL, 0x000fe20000200c00ULL,
0x00000100797c7824ULL, 0x048fe400078e00ffULL, 0x0001000079797824ULL, 0x000fc600078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000001d00257306ULL, 0x0007e20000200c00ULL,
0x00000018ff797819ULL, 0x000fce0000011479ULL, 0x0000002600827306ULL, 0x000fe20000200c00ULL,
0x00008880781d7816ULL, 0x048fe200000000ffULL, 0x0001000078787824ULL, 0x000fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000007f00807306ULL, 0x0007f00000200c00ULL,
0x0000001f00267306ULL, 0x0009e20000200c00ULL, 0x00008880747f7816ULL, 0x048fe200000000ffULL,
0x0001000074747824ULL, 0x000fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000008300847306ULL, 0x0007e20000200c00ULL, 0x000088807a1f7816ULL, 0x050fe200000000ffULL,
0x000100007a7a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000002700277306ULL, 0x000fe20000200c00ULL, 0x0000888075837816ULL, 0x008fce00000000ffULL,
0x0000007c007c7306ULL, 0x000ef00000200c00ULL, 0x0000007e008b7306ULL, 0x000ff00000200c00ULL,
0x0000007b00867306ULL, 0x000fe20000200c00ULL, 0x0000541027277816ULL, 0x008fce000000007cULL,
0x00000079007e7306ULL, 0x000ff00000200c00ULL, 0x0000008700887306ULL, 0x0007f00000200c00ULL,
0x0000008300897306ULL, 0x0009e20000200c00ULL, 0x0000888076877816ULL, 0x008fce00000000ffULL,
0x00000074007b7306ULL, 0x0006a20000200c00ULL, 0x0000010076837824ULL, 0x050fe400078e00ffULL,
0x0001000076767824ULL, 0x000fc600078e00ffULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x0000007a00797306ULL, 0x0008620000200c00ULL, 0x0000010077747824ULL, 0x048fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011476ULL, 0x0001000077777824ULL, 0x000fc600078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x00000100757a7824ULL, 0x050fe200078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0001000075757824ULL, 0x000fe200078e00ffULL, 0x000054107b8a7816ULL, 0x004fe4000000008aULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x0000001d001d7306ULL, 0x000ea20000200c00ULL,
0x00000018ff757819ULL, 0x000fc40000011475ULL, 0x0000541079827816ULL, 0x002fca0000000082ULL,
0x0000001f001f7306ULL, 0x000e700000200c00ULL, 0x0000008100817306ULL, 0x000ee20000200c00ULL,
0x000054101d267816ULL, 0x004fce0000000026ULL, 0x0000007f007f7306ULL, 0x000ea20000200c00ULL,
0x000000267064723cULL, 0x000f620000001864ULL, 0x000054101f807816ULL, 0x002fe20000000080ULL,
0x00000008021f7824ULL, 0x000fca00078e00ffULL, 0x0000007a007a7306ULL, 0x000e620000200c00ULL,
0x000000266844723cULL, 0x000b620000001844ULL, 0x0000541081817816ULL, 0x008fcc0000000084ULL,
0x00000075008c7306ULL, 0x0007220000200c00ULL, 0x000054107f887816ULL, 0x004fe20000000088ULL,
0x00000080705c723cULL, 0x000f64000000185cULL, 0x0000000102277824ULL, 0x020fc800078e021eULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x000054107e757816ULL, 0x008fe2000000007dULL,
0x00000080683c723cULL, 0x000f62000000183cULL, 0x0000541089897816ULL, 0x002fca000000007aULL,
0x00000083008e7306ULL, 0x0002a20000200c00ULL, 0x000054108c8b7816ULL, 0x010fe2000000008bULL,
0x000000887054723cULL, 0x040f6c0000001854ULL, 0x0000008f008f7306ULL, 0x000fe20000200c00ULL,
0x0000541086837816ULL, 0x002fe20000000085ULL, 0x0000008a7050723cULL, 0x040f6c0000001850ULL,
0x00000074007c7306ULL, 0x0002e20000200c00ULL, 0x00005410878e7816ULL, 0x004fe2000000008eULL,
0x000000827058723cULL, 0x080f6c0000001858ULL, 0x0000007600767306ULL, 0x000ea20000200c00ULL,
0x0000541078747816ULL, 0x002fe20000000025ULL, 0x000000021a257824ULL, 0x000fe200078e00ffULL,
0x000000826838723cULL, 0x000f680000001838ULL, 0x00000004251d7812ULL, 0x000fe200078ec0ffULL,
0x0000007700777306ULL, 0x000e620000200c00ULL, 0x000054108f8f7816ULL, 0x008fc4000000007cULL,
0x000000021d267812ULL, 0x000fe200078efcffULL, 0x000000747060723cULL, 0x000f660000001860ULL,
0x0000002617267211ULL, 0x000fe400078fe0ffULL, 0x0000541076767816ULL, 0x004fc6000000008dULL,
0x0000008e704c723cULL, 0x000f62000000184cULL, 0x00000001031d7824ULL, 0x100fe400078e0226ULL,
0x0000000102267824ULL, 0x000fe200078e0226ULL, 0x0000541077777816ULL, 0x002fc80000000090ULL,
0xfffffff81f1e7812ULL, 0x000fe200078ee226ULL, 0x000000746840723cULL, 0x000f620000001840ULL,
0x0000100000267810ULL, 0x000fce0007ffe0ffULL, 0x000000767048723cULL, 0x000b6e0000001848ULL,
0x0000000803707824ULL, 0x020fe200078e00ffULL, 0x000000886834723cULL, 0x000f620000001834ULL,
0x0000000802727824ULL, 0x000fc600078e00ffULL, 0xfffffff8701d7812ULL, 0x000fe400078ee21dULL,
0xfffffff8721f7812ULL, 0x000fe400078ee227ULL, 0x0000008a6830723cULL, 0x040f620000001830ULL,
0x000000101d707824ULL, 0x100fe400078e0220ULL, 0x000000101e207824ULL, 0x000fe400078e0220ULL,
0x000000101f787824ULL, 0x000fe400078e0226ULL, 0x000000007070783bULL, 0x000e620000000200ULL,
0x0000008e682c723cULL, 0x040f70000000182cULL, 0x000000766828723cULL, 0x000b640000001828ULL,
0x000000002068783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000770707232ULL, 0x082fe40000000000ULL,
0x0000000772727232ULL, 0x000fc40000000000ULL, 0x0000000671717232ULL, 0x080fe40000000000ULL,
0x0000000673737232ULL, 0x000fe40000000000ULL, 0x0000000568687232ULL, 0x088fe40000000000ULL,
0x000000056a6a7232ULL, 0x000fe40000000000ULL, 0x0000000469697232ULL, 0x080fe40000000000ULL,
0x000000046b6b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000802757824ULL, 0x000fe200078e00ffULL, 0x0000000227207810ULL, 0x004fe20007ffe0ffULL,
0x000000007878783bULL, 0x000ea60000004200ULL, 0xfffffff875207812ULL, 0x000fca00078ee220ULL,
0x0000001020747824ULL, 0x000fcc00078e0226ULL, 0x000000007474783bULL, 0x000f220000004200ULL,
0x00000018ff277819ULL, 0x004fe20000011479ULL, 0x000100007b857824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001147bULL, 0x00000018ff267819ULL, 0x000fe20000011478ULL,
0x0000002700807306ULL, 0x0005e20000200c00ULL, 0x00000018ff7d7819ULL, 0x000fe4000001147aULL,
0x00000018ff857819ULL, 0x000fca0000011485ULL, 0x0000007e00867306ULL, 0x0007e20000200c00ULL,
0x0000010078277824ULL, 0x004fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x010fe20000011474ULL,
0x0000010074887824ULL, 0x040fe200078e00ffULL, 0x0000888074877816ULL, 0x040fe200000000ffULL,
0x0001000074747824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe20000011427ULL,
0x00000100768f7824ULL, 0x000fe200078e00ffULL, 0x00000026007c7306ULL, 0x0005e20000200c00ULL,
0x00000100797e7824ULL, 0x008fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fc40000011475ULL,
0x00000018ff827819ULL, 0x000fe40000011476ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007d00847306ULL, 0x0007e20000200c00ULL, 0x0000888078267816ULL, 0x044fe200000000ffULL,
0x0001000078787824ULL, 0x000fe200078e00ffULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x00000018ff837819ULL, 0x000fe40000011477ULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000002600267306ULL, 0x000fe20000200c00ULL, 0x00008880797d7816ULL, 0x008fc400000000ffULL,
0x0000888075897816ULL, 0x000fe400000000ffULL, 0x00008880768e7816ULL, 0x040fe200000000ffULL,
0x0001000076767824ULL, 0x000fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe2000001148fULL,
0x0000002700277306ULL, 0x000ea20000200c00ULL, 0x0000888077917816ULL, 0x000fe400000000ffULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x00000018ff767819ULL, 0x000fc60000011476ULL,
0x0000007f008a7306ULL, 0x0007f00000200c00ULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x00010000797f7824ULL, 0x008fe200078e00ffULL, 0x0000541026267816ULL, 0x004fc80000000027ULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000007e007e7306ULL, 0x000eb00000200c00ULL,
0x0000007800797306ULL, 0x0007f00000200c00ULL, 0x00000081008c7306ULL, 0x0009e20000200c00ULL,
0x000054107d277816ULL, 0x004fe2000000007eULL, 0x000001007b787824ULL, 0x008fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000008200907306ULL, 0x0005e20000200c00ULL,
0x000088807a817816ULL, 0x050fe200000000ffULL, 0x000000267064723cULL, 0x082f6c0000001864ULL,
0x00000074008b7306ULL, 0x0002e20000200c00ULL, 0x000001007a827824ULL, 0x044fe200078e00ffULL,
0x000000266844723cULL, 0x000b620000001844ULL, 0x000100007a7a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff827819ULL, 0x000fe40000011482ULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000010077747824ULL, 0x002fe200078e00ffULL, 0x0000008300927306ULL, 0x0003e20000200c00ULL,
0xfffffff825267812ULL, 0x020fc600078ec0ffULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x000054108b8a7816ULL, 0x008fe4000000008aULL, 0x00000074007e7306ULL, 0x0005e20000200c00ULL,
0x000088807b837816ULL, 0x002fce00000000ffULL, 0x0000007a007b7306ULL, 0x0002e20000200c00ULL,
0x0000541079747816ULL, 0x004fe2000000007cULL, 0x0001000077797824ULL, 0x000fca00078e00ffULL,
0x00000018ff797819ULL, 0x000fe20000011479ULL, 0x0000008e008e7306ULL, 0x000fe20000200c00ULL,
0x00000100757a7824ULL, 0x042fe400078e00ffULL, 0x0001000075757824ULL, 0x000fc600078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe4000001147aULL, 0x00000018ff757819ULL, 0x000fe20000011475ULL,
0x0000008f008f7306ULL, 0x000e620000200c00ULL, 0x000054107b847816ULL, 0x008fce0000000084ULL,
0x0000009100917306ULL, 0x000eb00000200c00ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x000054108e8e7816ULL, 0x002fce000000008fULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x00005410918f7816ULL, 0x004fce000000007eULL, 0x0000008200827306ULL, 0x000e620000200c00ULL,
0x0000008e704c723cULL, 0x080f6e000000184cULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x0000008e682c723cULL, 0x000f6e000000182cULL, 0x0000007800787306ULL, 0x000ea20000200c00ULL,
0x0000541081827816ULL, 0x002fce0000000082ULL, 0x0000008500857306ULL, 0x000e700000200c00ULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x0000541083837816ULL, 0x004fce0000000078ULL,
0x0000008800887306ULL, 0x000ea20000200c00ULL, 0x0000541085857816ULL, 0x002fe20000000086ULL,
0x00000082705c723cULL, 0x040f6c000000185cULL, 0x0000008900897306ULL, 0x000fe40000200c00ULL,
0x000000847058723cULL, 0x000f6c0000001858ULL, 0x0000007a007a7306ULL, 0x000e620000200c00ULL,
0x0000541087887816ULL, 0x004fe20000000088ULL, 0x00000082683c723cULL, 0x040f6c000000183cULL,
0x00000075008d7306ULL, 0x0004e40000200c00ULL, 0x000000846838723cULL, 0x000f6c0000001838ULL,
0x0000007600777306ULL, 0x000f220000200c00ULL, 0x000054107f757816ULL, 0x004fc40000000080ULL,
0x0000541089897816ULL, 0x002fca000000007aULL, 0x0000007900797306ULL, 0x000e620000200c00ULL,
0x000054108d8b7816ULL, 0x008fe2000000008cULL, 0x000000747060723cULL, 0x000f620000001860ULL,
0x0000541077907816ULL, 0x010fce0000000090ULL, 0x000000887054723cULL, 0x000f620000001854ULL,
0x0000541079917816ULL, 0x002fce0000000092ULL, 0x0000008a7050723cULL, 0x040f700000001850ULL,
0x000000907048723cULL, 0x000f700000001848ULL, 0x000000746840723cULL, 0x040f700000001840ULL,
0x000000886834723cULL, 0x040f700000001834ULL, 0x0000008a6830723cULL, 0x040f700000001830ULL,
0x000000906828723cULL, 0x000b6e0000001828ULL, 0x0001a6c8136a7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006a6a7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6900026ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff257224ULL, 0x000fc600078e00ffULL, 0x0000000000267805ULL, 0x004fc80000015200ULL,
0x000004000d697984ULL, 0x000ea40000000800ULL, 0x8000000069ff7812ULL, 0x006fc4000780486bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000687805ULL, 0x000fcc0000015200ULL,
0x0000006826717210ULL, 0x000fca0007f1e1ffULL, 0x0000000169697824ULL, 0x000fe200000e0e27ULL,
0x003d09007100780cULL, 0x000fc80003f06070ULL, 0x000000ff6900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c407100780cULL, 0x000fc80003f06070ULL,
0x000000ff6900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff687819ULL, 0x000fc80000011469ULL, 0x0000007168687211ULL, 0x000fca00078110ffULL,
0x000000ffff697224ULL, 0x000fca00000e0669ULL, 0x0000000268687819ULL, 0x000fc80000001269ULL,
0x000000680000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d697984ULL, 0x000e640000000800ULL, 0x8000000069ff7812ULL, 0x002fe4000780486bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000c00c277810ULL, 0x000fca0007ffe0ffULL,
0x0000660012717a24ULL, 0x000fe200078e0227ULL, 0x000003e00000a947ULL, 0x000fea0003800000ULL,
0x0000002716257217ULL, 0x000fe20007800000ULL, 0x0000001011707824ULL, 0x000fe200078e00ffULL,
0x00000003ff687819ULL, 0x000fe40000011617ULL, 0x0000100000777810ULL, 0x000fe20007ffe0ffULL,
0x0000000125257824ULL, 0x000fe200078e0a27ULL, 0x0000000468697810ULL, 0x000fe20007ffe0ffULL,
0x0000000170267824ULL, 0x000fe200078e0268ULL, 0x00000008686b7810ULL, 0x000fe40007ffe0ffULL,
0x0000002570257217ULL, 0x000fe20007800000ULL, 0x0000000126277824ULL, 0x000fc400078e0217ULL,
0x0000000826727824ULL, 0x040fe400078e00ffULL, 0x0000000125257824ULL, 0x000fe400078e0a70ULL,
0x0000000126267824ULL, 0x000fe200078e0271ULL, 0xfffffff872727812ULL, 0x000fe200078ee227ULL,
0x0000000170747824ULL, 0x000fe200078e0269ULL, 0x000000256900720cULL, 0x080fe20003f86070ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000c68697810ULL, 0x040fe40007ffe0ffULL,
0x000000256800720cULL, 0x080fe20003fa6070ULL, 0x0000000174687824ULL, 0x000fe200078e0271ULL,
0x000000256900720cULL, 0x000fe20003f06070ULL, 0x0000000170787824ULL, 0x000fe200078e0269ULL,
0x0000000b266a7212ULL, 0x000fe200078efcffULL, 0x0000008068687825ULL, 0x000fe200078e00ffULL,
0x000000256b00720cULL, 0x000fc40003f66070ULL, 0x000062006a6a7a10ULL, 0x000fe20007fde0ffULL,
0x0000000170767824ULL, 0x000fe200078e026bULL, 0x0000000b68707212ULL, 0x000fe200078efcffULL,
0x0000000174257824ULL, 0x000fe200078e0217ULL, 0x00006300276b7a10ULL, 0x000fe200037fe4ffULL,
0x0000000176267824ULL, 0x000fe200078e0271ULL, 0x0000620070707a10ULL, 0x000fe20007fde0ffULL,
0x0000000874747824ULL, 0x000fe400078e00ffULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff874747812ULL, 0x000fe200078ee225ULL, 0x0000000178687824ULL, 0x000fe200078e0271ULL,
0x0000630069717a10ULL, 0x000fe200037fe4ffULL, 0x0000000176737824ULL, 0x000fe200078e0217ULL,
0x0000000b26267212ULL, 0x000fe200078efcffULL, 0x0000008068687825ULL, 0x000fc600078e00ffULL,
0x0000620026267a10ULL, 0x000fe20007fde0ffULL, 0x0000000876767824ULL, 0x000fe200078e00ffULL,
0x0000000b68687212ULL, 0x000fe200078efcffULL, 0x0000000178257824ULL, 0x040fe200078e0217ULL,
0x0000630027277a10ULL, 0x000fe200037fe4ffULL, 0x0000000878787824ULL, 0x000fe200078e00ffULL,
0xfffffff876767812ULL, 0x000fe200078ee273ULL, 0x0000001074737824ULL, 0x000fe200078e0277ULL,
0x0000620068687a10ULL, 0x000fe40007fde0ffULL, 0xfffffff878787812ULL, 0x000fe200078ee225ULL,
0x0000001072257824ULL, 0x100fe200078e0277ULL, 0x0000630069697a10ULL, 0x000fe200037fe4ffULL,
0x0000001076757824ULL, 0x000fc400078e0277ULL, 0x0000001078777824ULL, 0x000fe200078e0277ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000006a257faeULL, 0x0003e8000e901c48ULL,
0x0000000070737faeULL, 0x0003e8000e101c48ULL, 0x0000000026757faeULL, 0x0003e8000d901c48ULL,
0x0000000068777faeULL, 0x0003e2000c101c48ULL, 0x0000031000007947ULL, 0x000fea0003800000ULL,
0x0000001011267824ULL, 0x000fe200078e00ffULL, 0x0000100000777810ULL, 0x000fc80007ffe0ffULL,
0x0000002617687211ULL, 0x000fc800078fe8ffULL, 0x00000004686a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000168267824ULL, 0x040fe200078e0271ULL, 0x0000000868747810ULL, 0x040fe20007ffe0ffULL,
0x0000000168257824ULL, 0x040fe200078e0217ULL, 0x0000000c68767810ULL, 0x040fe20007ffe0ffULL,
0x0000000868727824ULL, 0x000fe400078e00ffULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff872727812ULL, 0x000fe200078ee225ULL, 0x000000016a257824ULL, 0x000fe200078e0271ULL,
0x0000000b26707212ULL, 0x000fe200078efcffULL, 0x000000016a697824ULL, 0x040fe400078e0217ULL,
0x000000086a787824ULL, 0x000fe200078e00ffULL, 0x0000620070707a10ULL, 0x000fe20007f1e0ffULL,
0x0000000174687824ULL, 0x100fe400078e0271ULL, 0x00000001766a7824ULL, 0x040fe400078e0271ULL,
0x0000000176267824ULL, 0x000fc400078e0217ULL, 0x0000000876717824ULL, 0x000fe400078e00ffULL,
0x00000001746b7824ULL, 0x040fe400078e0217ULL, 0x00000008747a7824ULL, 0x000fe200078e00ffULL,
0xfffffff878747812ULL, 0x000fe200078ee269ULL, 0x0000008068687825ULL, 0x000fe200078e00ffULL,
0xfffffff871787812ULL, 0x000fe400078ee226ULL, 0x0000630027717a10ULL, 0x000fe200007fe4ffULL,
0x0000008025267825ULL, 0x000fe200078e00ffULL, 0xfffffff87a767812ULL, 0x000fc400078ee26bULL,
0x0000000b68687212ULL, 0x080fe200078efcffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000000b26267212ULL, 0x080fe400078efcffULL, 0x0000620068687a10ULL, 0x000fe20007f7e0ffULL,
0x0000001072257824ULL, 0x100fe200078e0277ULL, 0x0000000b6a6a7212ULL, 0x000fe200078efcffULL,
0x0000001074737824ULL, 0x100fe200078e0277ULL, 0x0000620026267a10ULL, 0x000fe20007f1e0ffULL,
0x0000001076757824ULL, 0x100fe200078e0277ULL, 0x000062006a6a7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001078777824ULL, 0x000fe200078e0277ULL, 0x0000630027277a10ULL, 0x000fe200007fe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000070257faeULL, 0x0003e2000b901c48ULL,
0x0000630069697a10ULL, 0x000fc40001ffe4ffULL, 0x000063006b6b7a10ULL, 0x000fe200027fe4ffULL,
0x0000000026737faeULL, 0x0003e8000b901c48ULL, 0x0000000068757faeULL, 0x0003e8000b901c48ULL,
0x000000006a777faeULL, 0x0003e4000b901c48ULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xfffffff014687812ULL, 0x000fce00078ec0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6b00068687f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6480023707f8cULL, 0x0004e4000c80043fULL,
0x0000000000267805ULL, 0x000fc40000015200ULL, 0xffffffe014237812ULL, 0x044fe400078ec0ffULL,
0x00000010146a7812ULL, 0x040fe400078ec0ffULL, 0x0000000814257812ULL, 0x000fc800078ec0ffULL,
0x0000002325237210ULL, 0x000fca0007ffe06aULL, 0x01a64c0023257984ULL, 0x000ea40000000800ULL,
0x8000000025ff7812ULL, 0x00cfe40007804871ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff727224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006a7805ULL, 0x000fcc0000015200ULL,
0x0000006a266a7210ULL, 0x000fca0007f1e1ffULL, 0x000000016b6b7824ULL, 0x000fe200000e0e27ULL,
0x003d09006a00780cULL, 0x000fc80003f06070ULL, 0x000000ff6b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406a00780cULL, 0x000fc80003f06070ULL,
0x000000ff6b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001146bULL, 0x0000006a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff6a7224ULL, 0x000fca00000e066bULL, 0x0000000225257819ULL, 0x000fc8000000126aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000172727810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a64c0023257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x004fe40007804871ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000201a237824ULL, 0x000fca00078e00ffULL,
0xffffff8023267812ULL, 0x000fc800078ec0ffULL, 0x000001000b237810ULL, 0x000fca0007ffe026ULL,
0x000000010a237824ULL, 0x000fca00078e0223ULL, 0x01a0000023717984ULL, 0x000ea80000000800ULL,
0x01a2000023707984ULL, 0x0006620000000800ULL, 0x000000247100720bULL, 0x004fe20003f1d000ULL,
0x0000ffb27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000727806ULL, 0x008fc800000e0100ULL,
0x000000ff7200720cULL, 0x000fe20003f05270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fd200078e0024ULL,
0x0000073000008947ULL, 0x000fea0003800000ULL, 0x0000000210237810ULL, 0x000fe40007ffe0ffULL,
0x000000247100720bULL, 0x000fe40003f74000ULL, 0x0000001a2300720cULL, 0x000fe20003f05270ULL,
0x0000ff727f007947ULL, 0x000fd4000b800000ULL, 0x0000000000237806ULL, 0x000fc400018e0100ULL,
0x000000801a278824ULL, 0x000fe200078e020bULL, 0x0000002471257209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a268824ULL, 0x000fca00078e0227ULL,
0x01a4002526008388ULL, 0x0005e20000000800ULL, 0x000000ff2300720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x8000002524257221ULL, 0x004fe20000010000ULL,
0x000000ff23ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL, 0x0000002500277308ULL, 0x000ea40000000800ULL,
0x0000002722227220ULL, 0x004fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x0000fec27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002664647220ULL, 0x08cfe40000410000ULL,
0x0000002665657220ULL, 0x080fe40000410000ULL, 0x0000002660607220ULL, 0x080fe40000410000ULL,
0x0000002661617220ULL, 0x080fe40000410000ULL, 0x000000265c5c7220ULL, 0x080fe40000410000ULL,
0x000000265d5d7220ULL, 0x000fc40000410000ULL, 0x0000002658587220ULL, 0x080fe40000410000ULL,
0x0000002659597220ULL, 0x080fe40000410000ULL, 0x0000002654547220ULL, 0x080fe40000410000ULL,
0x0000002655557220ULL, 0x080fe40000410000ULL, 0x0000002650507220ULL, 0x080fe40000410000ULL,
0x0000002651517220ULL, 0x000fc40000410000ULL, 0x000000264c4c7220ULL, 0x080fe40000410000ULL,
0x000000264d4d7220ULL, 0x080fe40000410000ULL, 0x0000002648487220ULL, 0x080fe40000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0023ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x0000fda27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002666667220ULL, 0x08cfe40000410000ULL, 0x0000002667677220ULL, 0x080fe40000410000ULL,
0x0000002662627220ULL, 0x080fe40000410000ULL, 0x0000002663637220ULL, 0x080fe40000410000ULL,
0x000000265e5e7220ULL, 0x080fe40000410000ULL, 0x000000265f5f7220ULL, 0x000fc40000410000ULL,
0x000000265a5a7220ULL, 0x080fe40000410000ULL, 0x000000265b5b7220ULL, 0x080fe40000410000ULL,
0x0000002656567220ULL, 0x080fe40000410000ULL, 0x0000002657577220ULL, 0x080fe40000410000ULL,
0x0000002652527220ULL, 0x080fe40000410000ULL, 0x0000002653537220ULL, 0x000fc40000410000ULL,
0x000000264e4e7220ULL, 0x080fe40000410000ULL, 0x000000264f4f7220ULL, 0x080fe40000410000ULL,
0x000000264a4a7220ULL, 0x080fe40000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000023ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x0000fc827f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe40000410000ULL,
0x0000002645457220ULL, 0x080fe40000410000ULL, 0x0000002640407220ULL, 0x080fe40000410000ULL,
0x0000002641417220ULL, 0x080fe40000410000ULL, 0x000000263c3c7220ULL, 0x080fe40000410000ULL,
0x000000263d3d7220ULL, 0x000fc40000410000ULL, 0x0000002638387220ULL, 0x080fe40000410000ULL,
0x0000002639397220ULL, 0x080fe40000410000ULL, 0x0000002634347220ULL, 0x080fe40000410000ULL,
0x0000002635357220ULL, 0x080fe40000410000ULL, 0x0000002630307220ULL, 0x080fe40000410000ULL,
0x0000002631317220ULL, 0x000fc40000410000ULL, 0x000000262c2c7220ULL, 0x080fe40000410000ULL,
0x000000262d2d7220ULL, 0x080fe40000410000ULL, 0x0000002628287220ULL, 0x080fe40000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000023ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x0000fb727f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe40000410000ULL,
0x0000002647477220ULL, 0x080fe40000410000ULL, 0x0000002642427220ULL, 0x080fe40000410000ULL,
0x0000002643437220ULL, 0x080fe40000410000ULL, 0x000000263e3e7220ULL, 0x080fe40000410000ULL,
0x000000263f3f7220ULL, 0x000fc40000410000ULL, 0x000000263a3a7220ULL, 0x080fe40000410000ULL,
0x000000263b3b7220ULL, 0x080fe40000410000ULL, 0x0000002636367220ULL, 0x080fe40000410000ULL,
0x0000002637377220ULL, 0x080fe40000410000ULL, 0x0000002632327220ULL, 0x080fe40000410000ULL,
0x0000002633337220ULL, 0x000fc40000410000ULL, 0x000000262e2e7220ULL, 0x080fe40000410000ULL,
0x000000262f2f7220ULL, 0x080fe40000410000ULL, 0x000000262a2a7220ULL, 0x080fe40000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000002372ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff6a7424ULL, 0x000fe200078e00ffULL,
0x0000002471237209ULL, 0x000fd60007810000ULL, 0x8000002371710221ULL, 0x000fe20000010000ULL,
0x00007610ff6a0816ULL, 0x000fc6000000006aULL, 0x3fb8aa3b71710820ULL, 0x000fc80000410000ULL,
0x0000007100090308ULL, 0x000ea40000000800ULL, 0x0000000970700220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002270227221ULL, 0x002fc40000010000ULL,
0x0000000000247805ULL, 0x000fca0000015200ULL, 0x0000040008277984ULL, 0x000e640000000800ULL,
0x8000000027ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026246b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127277824ULL, 0x000fe200000e0e25ULL,
0x003d09006b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff267819ULL, 0x000fc80000011427ULL, 0x0000006b26267211ULL, 0x000fca00078110ffULL,
0x000000ffff277224ULL, 0x000fca00000e0627ULL, 0x0000000226267819ULL, 0x000fc80000001227ULL,
0x000000260000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040008277984ULL, 0x000e640000000800ULL, 0x8000000027ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099106a247816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff2400720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000009ff04723eULL, 0x000fe400000000ffULL,
0x00000002ff247819ULL, 0x000fe40000011617ULL, 0x0000541004277816ULL, 0x000fe20000000004ULL,
0x0000f7527f007947ULL, 0x000fea000b800000ULL, 0x00001f2427077589ULL, 0x0002a400000e0000ULL,
0x0000000824267810ULL, 0x000fe20007ffe0ffULL, 0x0000f7927f007947ULL, 0x000fea000b800000ULL,
0x0000001024047810ULL, 0x000fe20007ffe0ffULL, 0x00001f2627067589ULL, 0x00066800000e0000ULL,
0x00001f0427057589ULL, 0x0006a400000e0000ULL, 0x0000001824267810ULL, 0x008fe20007ffe0ffULL,
0x0000f8027f007947ULL, 0x000fea000b800000ULL, 0x00001f2627047589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000021a6a7824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000004001a267824ULL, 0x008fe200078e00ffULL,
0x0000019000007945ULL, 0x000fe20003800000ULL, 0x00000008036c7824ULL, 0x000fe200078e00ffULL,
0x000000046a247812ULL, 0x002fe200078ec0ffULL, 0x0000000802277824ULL, 0x000fe200078e00ffULL,
0xfffff000266b7812ULL, 0x000fe200078ec0ffULL, 0x000000101c787824ULL, 0x000fe200078e0200ULL,
0x0000002417247211ULL, 0x000fc400078fe0ffULL, 0x000140006b6b7810ULL, 0x000fc60007ffe0ffULL,
0x0000000103257824ULL, 0x100fe400078e0224ULL, 0x0000000102267824ULL, 0x000fc600078e0224ULL,
0xfffffff86c247812ULL, 0x000fe400078ee225ULL, 0xfffffff827267812ULL, 0x000fc600078ee226ULL,
0x0000001024707824ULL, 0x100fe400078e026bULL, 0x0000001026267824ULL, 0x000fc800078e026bULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000002624783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000770707232ULL, 0x086fe40000000000ULL,
0x0000000772727232ULL, 0x000fe40000000000ULL, 0x0000000671717232ULL, 0x080fe40000000000ULL,
0x0000000673737232ULL, 0x000fc40000000000ULL, 0x0000000524247232ULL, 0x088fe40000000000ULL,
0x0000000526267232ULL, 0x000fe40000000000ULL, 0x0000000425257232ULL, 0x080fe40000000000ULL,
0x0000000427277232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000007878783bULL, 0x000f220000004200ULL, 0x0000001021747824ULL, 0x000fe200078e0200ULL,
0x0000082000007945ULL, 0x000fea0003800000ULL, 0x000000007474783bULL, 0x000ee20000004200ULL,
0x00000018ff7d7819ULL, 0x010fe2000001147bULL, 0x000100007b837824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fc4000001147aULL, 0x00000018ff6c7819ULL, 0x000fe20000011479ULL,
0x0000007d00857306ULL, 0x0009e20000200c00ULL, 0x00000018ff217819ULL, 0x000fe20000011478ULL,
0x0000010074887824ULL, 0x008fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe20000011474ULL,
0x00000100768e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff817819ULL, 0x000fe40000011476ULL,
0x00000018ff827819ULL, 0x000fe20000011477ULL, 0x0000006d00847306ULL, 0x0007e20000200c00ULL,
0x00000100797d7824ULL, 0x010fe200078e00ffULL, 0x0000888074877816ULL, 0x040fe200000000ffULL,
0x0001000074747824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fc40000011475ULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x0000006c00807306ULL, 0x0009e20000200c00ULL,
0x00008880796d7816ULL, 0x008fe400000000ffULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x0000888075897816ULL, 0x000fe200000000ffULL,
0x00000021007c7306ULL, 0x0007e20000200c00ULL, 0x00000100786c7824ULL, 0x010fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fc4000001148eULL, 0x00000018ff887819ULL, 0x000fe40000011488ULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000007e008a7306ULL, 0x000fe20000200c00ULL,
0x0000888078217816ULL, 0x048fe200000000ffULL, 0x0001000078787824ULL, 0x000fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000006d006d7306ULL, 0x000ff00000200c00ULL,
0x0000007d007e7306ULL, 0x0007300000200c00ULL, 0x0000008100907306ULL, 0x0005e20000200c00ULL,
0x000088807b7d7816ULL, 0x008fce00000000ffULL, 0x0000008200927306ULL, 0x0007e20000200c00ULL,
0x000088807a817816ULL, 0x004fe400000000ffULL, 0x000054106d6d7816ULL, 0x010fe2000000007eULL,
0x00000100777e7824ULL, 0x000fc800078e00ffULL, 0x0000002100217306ULL, 0x000fe20000200c00ULL,
0x000001007a827824ULL, 0x048fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x000100007a7a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff827819ULL, 0x000fe40000011482ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x00000018ff7a7819ULL, 0x000fce000001147aULL,
0x0000007f008c7306ULL, 0x0007f00000200c00ULL, 0x00000074008b7306ULL, 0x0008620000200c00ULL,
0x00010000797f7824ULL, 0x008fe200078e00ffULL, 0x00005410216c7816ULL, 0x004fc8000000006cULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000007800797306ULL, 0x0004e20000200c00ULL,
0x0000888077747816ULL, 0x050fe200000000ffULL, 0x0001000077777824ULL, 0x000fe200078e00ffULL,
0x0000006c7064723cULL, 0x082f660000001864ULL, 0x000000ffff217224ULL, 0x000fe200078e0074ULL,
0x00000018ff777819ULL, 0x000fe20000011477ULL, 0x0000008300867306ULL, 0x0003220000200c00ULL,
0x000001007b787824ULL, 0x004fe200078e00ffULL, 0x000054108b8a7816ULL, 0x000fe2000000008aULL,
0x0000006c2444723cULL, 0x000f660000001844ULL, 0x00000018ff787819ULL, 0x000fc40000011478ULL,
0x0000007a007b7306ULL, 0x0005220000200c00ULL, 0x0000888076837816ULL, 0x042fe200000000ffULL,
0x0001000076767824ULL, 0x000fe200078e00ffULL, 0x0000541079747816ULL, 0x008fc8000000007cULL,
0x00000018ff767819ULL, 0x000fe20000011476ULL, 0x00000083008f7306ULL, 0x000fe20000200c00ULL,
0x00000100757a7824ULL, 0x044fe200078e00ffULL, 0x0000541086857816ULL, 0x010fe20000000085ULL,
0x0001000075757824ULL, 0x000fc600078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x00000018ff757819ULL, 0x000fe20000011475ULL, 0x0000008e008e7306ULL, 0x000e620000200c00ULL,
0x000054107b847816ULL, 0x000fce0000000084ULL, 0x0000007600917306ULL, 0x000ea20000200c00ULL,
0x000000847058723cULL, 0x080f6e0000001858ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x000054108f8e7816ULL, 0x002fe2000000008eULL, 0x000000842438723cULL, 0x000f6c0000001838ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x0000541091907816ULL, 0x004fce0000000090ULL,
0x0000008200827306ULL, 0x000e700000200c00ULL, 0x0000007d007d7306ULL, 0x000ff00000200c00ULL,
0x0000007800787306ULL, 0x000ea20000200c00ULL, 0x0000541081827816ULL, 0x002fce0000000082ULL,
0x0000008700877306ULL, 0x000ff00000200c00ULL, 0x0000008800887306ULL, 0x000e620000200c00ULL,
0x000054107d837816ULL, 0x004fe20000000078ULL, 0x000000101f787824ULL, 0x000fcc00078e0200ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x00000082705c723cULL, 0x080f6e000000185cULL,
0x0000007a007a7306ULL, 0x000ea20000200c00ULL, 0x0000541087887816ULL, 0x002fe20000000088ULL,
0x00000082243c723cULL, 0x000f6c000000183cULL, 0x00000075008d7306ULL, 0x0002f00000200c00ULL,
0x0000002100217306ULL, 0x000fe20000200c00ULL, 0x000054107f757816ULL, 0x002fc40000000080ULL,
0x0000541089897816ULL, 0x004fca000000007aULL, 0x0000007e007e7306ULL, 0x000e620000200c00ULL,
0x000054108d8b7816ULL, 0x008fe2000000008cULL, 0x000000747060723cULL, 0x040f6c0000001860ULL,
0x0000007700777306ULL, 0x000ea40000200c00ULL, 0x000000887054723cULL, 0x000f620000001854ULL,
0x00005410218f7816ULL, 0x002fce000000007eULL, 0x0000008a7050723cULL, 0x000f620000001850ULL,
0x0000541077917816ULL, 0x004fce0000000092ULL, 0x0000008e704c723cULL, 0x040f70000000184cULL,
0x000000907048723cULL, 0x000b6e0000001848ULL, 0x000000101d707824ULL, 0x120fe200078e026bULL,
0x000000742440723cULL, 0x000f620000001840ULL, 0x000000101e6b7824ULL, 0x000fc800078e026bULL,
0x000000007070783bULL, 0x000e660000000200ULL, 0x000000882434723cULL, 0x040f700000001834ULL,
0x0000008a2430723cULL, 0x040f700000001830ULL, 0x0000008e242c723cULL, 0x040f70000000182cULL,
0x000000902428723cULL, 0x000b640000001828ULL, 0x000000006b24783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000770707232ULL, 0x082fe40000000000ULL, 0x0000000772727232ULL, 0x000fc40000000000ULL,
0x0000000671717232ULL, 0x080fe40000000000ULL, 0x0000000673737232ULL, 0x000fe40000000000ULL,
0x0000000524247232ULL, 0x088fe40000000000ULL, 0x0000000526267232ULL, 0x000fe40000000000ULL,
0x0000000425257232ULL, 0x080fe40000000000ULL, 0x0000000427277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x0000001020747824ULL, 0x000fcc00078e0200ULL, 0x000000007474783bULL, 0x000ea20000004200ULL,
0x00000018ff207819ULL, 0x010fe40000011478ULL, 0x00000018ff217819ULL, 0x000fe40000011479ULL,
0x00000020006c7306ULL, 0x0009e20000200c00ULL, 0x00000018ff6b7819ULL, 0x004fe4000001147aULL,
0x00000018ff7c7819ULL, 0x000fe20000011474ULL, 0x0000010074867824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001147bULL, 0x00000100768c7824ULL, 0x000fe200078e00ffULL,
0x000088807b817816ULL, 0x000fe200000000ffULL, 0x00000021007d7306ULL, 0x0005e20000200c00ULL,
0x0000888078207816ULL, 0x010fc400000000ffULL, 0x00000018ff7f7819ULL, 0x000fe40000011476ULL,
0x00000018ff807819ULL, 0x000fe40000011477ULL, 0x0000888074857816ULL, 0x000fe200000000ffULL,
0x0000006b00827306ULL, 0x0009e20000200c00ULL, 0x0000010078217824ULL, 0x044fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe20000011475ULL, 0x0001000078787824ULL, 0x000fe200078e00ffULL,
0x0000888075877816ULL, 0x000fe200000000ffULL, 0x0001000074747824ULL, 0x000fe200078e00ffULL,
0x00008880768b7816ULL, 0x040fe200000000ffULL, 0x0001000076767824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x00000100796b7824ULL, 0x010fe200078e00ffULL,
0x0000007c00887306ULL, 0x0005e20000200c00ULL, 0x00000018ff747819ULL, 0x000fc40000011474ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x00000018ff867819ULL, 0x000fe40000011486ULL,
0x00000018ff8c7819ULL, 0x000fe2000001148cULL, 0x0000006d00837306ULL, 0x0009e20000200c00ULL,
0x00000018ff7c7819ULL, 0x004fe4000001146bULL, 0x00000018ff767819ULL, 0x000fca0000011476ULL,
0x00000078006b7306ULL, 0x0004e20000200c00ULL, 0x00008880796d7816ULL, 0x050fe200000000ffULL,
0x0001000079797824ULL, 0x000fca00078e00ffULL, 0x00000018ff797819ULL, 0x000fe20000011479ULL,
0x0000007f008e7306ULL, 0x0009e20000200c00ULL, 0x000001007b787824ULL, 0x044fe400078e00ffULL,
0x000100007b7b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000008000907306ULL, 0x0005e20000200c00ULL,
0x000088807a7f7816ULL, 0x010fe400000000ffULL, 0x000054106b6c7816ULL, 0x008fca000000006cULL,
0x0000007b00847306ULL, 0x0007220000200c00ULL, 0x000001007a807824ULL, 0x044fe400078e00ffULL,
0x000100007a7a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x00000018ff7a7819ULL, 0x000fe2000001147aULL, 0x00010000757b7824ULL, 0x008fe200078e00ffULL,
0x0000007e00897306ULL, 0x000fe80000200c00ULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x0000541084837816ULL, 0x010fc40000000083ULL, 0x00000079007e7306ULL, 0x000ff00000200c00ULL,
0x0000007a00797306ULL, 0x0004f00000200c00ULL, 0x0000007b008a7306ULL, 0x0008620000200c00ULL,
0x00000100757a7824ULL, 0x004fca00078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe4000001147aULL,
0x0000007400757306ULL, 0x0004620000200c00ULL, 0x00000100777b7824ULL, 0x010fe200078e00ffULL,
0x0000541079827816ULL, 0x008fc80000000082ULL, 0x00000018ff7b7819ULL, 0x000fe4000001147bULL,
0x0000002000207306ULL, 0x000fe20000200c00ULL, 0x0000888077747816ULL, 0x044fe200000000ffULL,
0x0001000077777824ULL, 0x000fe200078e00ffULL, 0x000054108a897816ULL, 0x002fe20000000089ULL,
0x000000827058723cULL, 0x000f660000001858ULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0000002100217306ULL, 0x000e620000200c00ULL, 0x0000541075887816ULL, 0x000fc60000000088ULL,
0x000000822438723cULL, 0x000f680000001838ULL, 0x0000006d006d7306ULL, 0x000fe80000200c00ULL,
0x000000887050723cULL, 0x000f680000001850ULL, 0x0000007c007c7306ULL, 0x000ea20000200c00ULL,
0x0000541020207816ULL, 0x002fc60000000021ULL, 0x000000882430723cULL, 0x000f680000001830ULL,
0x00000076008f7306ULL, 0x000e700000200c00ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x000054106d217816ULL, 0x004fc4000000007cULL, 0x000054107e6d7816ULL, 0x000fca000000007dULL,
0x0000008000807306ULL, 0x000ea20000200c00ULL, 0x000054108f8e7816ULL, 0x002fe2000000008eULL,
0x0000006c7060723cULL, 0x040f6c0000001860ULL, 0x0000008100817306ULL, 0x000fe40000200c00ULL,
0x000000207064723cULL, 0x080f6c0000001864ULL, 0x0000007800787306ULL, 0x000e620000200c00ULL,
0x000054107f807816ULL, 0x004fe20000000080ULL, 0x000000202444723cULL, 0x040b6c0000001844ULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0xfffffff86a207812ULL, 0x020fe200078ec0ffULL,
0x0000006c2440723cULL, 0x000f6c0000001840ULL, 0x0000008600867306ULL, 0x000ea20000200c00ULL,
0x0000541081817816ULL, 0x002fce0000000078ULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x00000080705c723cULL, 0x080f6e000000185cULL, 0x0000007a007a7306ULL, 0x000e620000200c00ULL,
0x0000541085867816ULL, 0x004fe20000000086ULL, 0x00000080243c723cULL, 0x000f6c000000183cULL,
0x0000008b008b7306ULL, 0x000ff00000200c00ULL, 0x0000008c008c7306ULL, 0x000ea20000200c00ULL,
0x0000541087877816ULL, 0x002fce000000007aULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x000000867054723cULL, 0x080f6e0000001854ULL, 0x0000007b007b7306ULL, 0x000e620000200c00ULL,
0x000054108b8c7816ULL, 0x004fe2000000008cULL, 0x000000862434723cULL, 0x000f6c0000001834ULL,
0x0000007700777306ULL, 0x000ea20000200c00ULL, 0x00005410748d7816ULL, 0x002fce000000007bULL,
0x0000008c704c723cULL, 0x000f62000000184cULL, 0x00005410778f7816ULL, 0x004fce0000000090ULL,
0x0000008e7048723cULL, 0x000f700000001848ULL, 0x0000008c242c723cULL, 0x040f70000000182cULL,
0x0000008e2428723cULL, 0x000b6e0000001828ULL, 0x0001a6c813267811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000026267f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6980020ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff6a7224ULL, 0x000fc600078e00ffULL, 0x0000000000207805ULL, 0x004fc80000015200ULL,
0x000004000d257984ULL, 0x000ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc40007804827ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x00000024206b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000125257824ULL, 0x000fe200000e0e21ULL,
0x003d09006b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff247819ULL, 0x000fc80000011425ULL, 0x0000006b24247211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x0000000224247819ULL, 0x000fc80000001225ULL,
0x000000240000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004000d257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010f207810ULL, 0x000fc80007ffe0ffULL,
0x000000152000720cULL, 0x000fda0003f06070ULL, 0x0000072000000947ULL, 0x000fea0003800000ULL,
0x000000020f207810ULL, 0x000fe40007ffe0ffULL, 0x000001000c217810ULL, 0x000fe40007ffe0ffULL,
0x000000152000720cULL, 0x000fc60003f06070ULL, 0x00006600126c7a24ULL, 0x000fd400078e0221ULL,
0x000003d000008947ULL, 0x000fea0003800000ULL, 0x00000021160c7217ULL, 0x000fe20007800000ULL,
0x0000001011277824ULL, 0x000fe200078e00ffULL, 0x00000003ff257819ULL, 0x000fc60000011617ULL,
0x000000010c0c7824ULL, 0x000fe200078e0a21ULL, 0x00000004256b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000127207824ULL, 0x000fe200078e0225ULL, 0x0000000825717810ULL, 0x000fe40007ffe0ffULL,
0x0000000c270c7217ULL, 0x000fe20007800000ULL, 0x0000000120217824ULL, 0x040fe200078e0217ULL,
0x0000000c25737810ULL, 0x000fe20007ffe0ffULL, 0x0000000820247824ULL, 0x000fe400078e00ffULL,
0x0000000127707824ULL, 0x000fc400078e026bULL, 0x0000000120207824ULL, 0x100fe200078e026cULL,
0xfffffff8246d7812ULL, 0x000fe200078ee221ULL, 0x000000010c0c7824ULL, 0x000fe400078e0a27ULL,
0x0000000170247824ULL, 0x000fe400078e026cULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000000c2500720cULL, 0x080fe40003f06070ULL, 0x0000000c7100720cULL, 0x080fe20003f66070ULL,
0x0000000127727824ULL, 0x000fe200078e0271ULL, 0x0000000b206a7212ULL, 0x000fe200078efcffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000000c6b00720cULL, 0x000fc40003f86070ULL,
0x000062006a6a7a10ULL, 0x000fe20007fbe0ffULL, 0x0000000172267824ULL, 0x100fe200078e026cULL,
0x0000000b24247212ULL, 0x080fe200078efcffULL, 0x0000000127747824ULL, 0x000fe200078e0273ULL,
0x00006300216b7a10ULL, 0x000fe20002ffe4ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000620024247a10ULL, 0x000fe40007fde0ffULL, 0x0000000c7300720cULL, 0x000fe20003fa6070ULL,
0x0000000174207824ULL, 0x000fe200078e026cULL, 0x0000000b26267212ULL, 0x000fe200078efcffULL,
0x00000001706c7824ULL, 0x040fe200078e0217ULL, 0x0000630025257a10ULL, 0x000fe200037fe4ffULL,
0x0000000870717824ULL, 0x000fe200078e00ffULL, 0x0000620026267a10ULL, 0x000fe20007fde0ffULL,
0x0000008020207825ULL, 0x000fc600078e00ffULL, 0xfffffff871717812ULL, 0x000fe200078ee26cULL,
0x00000001720c7824ULL, 0x100fe200078e0217ULL, 0x0000000b20207212ULL, 0x000fe200078efcffULL,
0x0000000872737824ULL, 0x000fe200078e00ffULL, 0x0000630027277a10ULL, 0x000fe200037fe4ffULL,
0x00000001746c7824ULL, 0x000fe200078e0217ULL, 0x0000620020207a10ULL, 0x000fe20007fde0ffULL,
0x0000000874757824ULL, 0x000fe200078e00ffULL, 0xfffffff873737812ULL, 0x000fe200078ee20cULL,
0x000000106d6d7824ULL, 0x100fe200078e0200ULL, 0x0000630021217a10ULL, 0x000fe200037fe4ffULL,
0x0000001071717824ULL, 0x000fe200078e0200ULL, 0xfffffff875757812ULL, 0x000fe200078ee26cULL,
0x0000001073737824ULL, 0x100fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006a6d7faeULL, 0x0003e6000c101c48ULL, 0x0000001075757824ULL, 0x000fe200078e0200ULL,
0x0000000024717faeULL, 0x0003e8000e101c48ULL, 0x0000000026737faeULL, 0x0003e8000d901c48ULL,
0x0000000020757faeULL, 0x0003e2000e901c48ULL, 0x0000030000007947ULL, 0x000fea0003800000ULL,
0x00000010110c7824ULL, 0x000fca00078e00ffULL, 0x0000000c170c7211ULL, 0x000fc800078fe8ffULL,
0x000000040c247810ULL, 0x040fe20007ffe0ffULL, 0x000000010c207824ULL, 0x140fe200078e0217ULL,
0x000000080c267810ULL, 0x040fe20007ffe0ffULL, 0x000000080c6d7824ULL, 0x000fe400078e00ffULL,
0x0000000124217824ULL, 0x140fe400078e0217ULL, 0x00000008246a7824ULL, 0x000fe200078e00ffULL,
0xfffffff86d6d7812ULL, 0x000fe200078ee220ULL, 0x000000010c207824ULL, 0x040fe200078e026cULL,
0x0000000c0c0c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000126257824ULL, 0x000fe200078e0217ULL,
0xfffffff86a717812ULL, 0x000fe200078ee221ULL, 0x0000000826707824ULL, 0x000fc400078e00ffULL,
0x0000000124247824ULL, 0x000fe400078e026cULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0xfffffff870737812ULL, 0x000fc600078ee225ULL, 0x0000000126267824ULL, 0x100fe200078e026cULL,
0x0000000b20207212ULL, 0x000fe200078efcffULL, 0x000000010c6a7824ULL, 0x000fe400078e026cULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000620020207a10ULL, 0x000fc60007f1e0ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000b24247212ULL, 0x080fe400078efcffULL,
0x0000630021217a10ULL, 0x000fe200007fe4ffULL, 0x000000806a6a7825ULL, 0x000fe200078e00ffULL,
0x0000000b26267212ULL, 0x080fe400078efcffULL, 0x0000620024247a10ULL, 0x000fe20007f7e0ffULL,
0x000000010c6c7824ULL, 0x000fe200078e0217ULL, 0x0000000b6a6a7212ULL, 0x000fe200078efcffULL,
0x000000080c757824ULL, 0x000fe200078e00ffULL, 0x0000620026267a10ULL, 0x000fe20007f1e0ffULL,
0x000000106d6d7824ULL, 0x100fe200078e0200ULL, 0x000062006a6a7a10ULL, 0x000fe20007f9e0ffULL,
0x0000001071717824ULL, 0x000fe200078e0200ULL, 0xfffffff875757812ULL, 0x000fe200078ee26cULL,
0x0000001073737824ULL, 0x100fe200078e0200ULL, 0x0000630025257a10ULL, 0x000fe20001ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000206d7faeULL, 0x0003e2000b901c48ULL,
0x0000630027277a10ULL, 0x000fe200007fe4ffULL, 0x0000001075757824ULL, 0x000fe200078e0200ULL,
0x000063006b6b7a10ULL, 0x000fe200027fe4ffULL, 0x0000000024717faeULL, 0x0003e8000b901c48ULL,
0x0000000026737faeULL, 0x0003e8000b901c48ULL, 0x000000006a757faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000814217812ULL, 0x000fe200078ec0ffULL,
0x00000020100c7824ULL, 0x000fc400078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a04ULL,
0x00000001210c7824ULL, 0x000fe200078e020cULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000086c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a668000c267f8cULL, 0x000664000c80043fULL,
0x0000000000207805ULL, 0x000fc40000015200ULL, 0x01a66c000c257984ULL, 0x000f240000000800ULL,
0x8000000025ff7812ULL, 0x012fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff6a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x00000024206b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000125257824ULL, 0x000fe200000e0e21ULL,
0x003d09006b00780cULL, 0x000fc80003f06070ULL, 0x000000ff2500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406b00780cULL, 0x000fc80003f06070ULL,
0x000000ff2500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011425ULL, 0x0000006b08087211ULL, 0x000fca00078110ffULL,
0x000000ffff257224ULL, 0x000fca00000e0625ULL, 0x0000000208087819ULL, 0x000fc80000001225ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016a6a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a66c000c257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018010087811ULL, 0x000fc800078e38ffULL,
0x000000080a087210ULL, 0x000fca0007ffe00bULL, 0x01a00000080c7984ULL, 0x008e680000000800ULL,
0x01a2000008207984ULL, 0x0006a20000000800ULL, 0x000000230c00720bULL, 0x002fe20003f1d000ULL,
0x0000d8e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000217806ULL, 0x008fc800000e0100ULL,
0x000000ff2100720cULL, 0x000fe20003f05270ULL, 0x0000075000007945ULL, 0x000fe20003800000ULL,
0x00000001ff247424ULL, 0x000fe400078e00ffULL, 0x000000ffff087224ULL, 0x000fd200078e0023ULL,
0x0000071000008947ULL, 0x000fea0003800000ULL, 0x0000000310257810ULL, 0x000fe40007ffe0ffULL,
0x000000230c00720bULL, 0x000fe40003f74000ULL, 0x0000001a2500720cULL, 0x000fe20003f05270ULL,
0x0000d8a27f007947ULL, 0x000fd4000b800000ULL, 0x00000000006c7806ULL, 0x004fc400018e0100ULL,
0x000000801a0b8824ULL, 0x000fe200078e020bULL, 0x000000230c087209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x000000010a0b8824ULL, 0x000fca00078e020bULL,
0x01a400080b008388ULL, 0x0003e20000000800ULL, 0x000000ff6c00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x00000023080a7221ULL, 0x002fe20000010100ULL,
0x000000ff6cff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fc80000410000ULL, 0x0000000a00277308ULL, 0x000e640000000800ULL,
0x0000002722227220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff267819ULL, 0x000fe20000011617ULL, 0x0000d7f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0002a400000e0000ULL, 0x0000002664647220ULL, 0x084fe40000410000ULL,
0x0000002665657220ULL, 0x080fe40000410000ULL, 0x0000002660607220ULL, 0x080fe40000410000ULL,
0x0000002661617220ULL, 0x080fe40000410000ULL, 0x000000265c5c7220ULL, 0x080fe40000410000ULL,
0x000000265d5d7220ULL, 0x000fc40000410000ULL, 0x0000002658587220ULL, 0x080fe40000410000ULL,
0x0000002659597220ULL, 0x080fe40000410000ULL, 0x0000002654547220ULL, 0x080fe40000410000ULL,
0x0000002655557220ULL, 0x080fe40000410000ULL, 0x0000002650507220ULL, 0x080fe40000410000ULL,
0x0000002651517220ULL, 0x000fc40000410000ULL, 0x000000264c4c7220ULL, 0x080fe40000410000ULL,
0x000000264d4d7220ULL, 0x080fe40000410000ULL, 0x0000002648487220ULL, 0x080fe40000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff006cff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000817267811ULL, 0x000fe200078ff0ffULL,
0x0000d6d27f007947ULL, 0x000fea000b800000ULL, 0x00001f2627267589ULL, 0x0004e400000e0000ULL,
0x0000002666667220ULL, 0x08cfe40000410000ULL, 0x0000002667677220ULL, 0x080fe40000410000ULL,
0x0000002662627220ULL, 0x080fe40000410000ULL, 0x0000002663637220ULL, 0x080fe40000410000ULL,
0x000000265e5e7220ULL, 0x080fe40000410000ULL, 0x000000265f5f7220ULL, 0x000fc40000410000ULL,
0x000000265a5a7220ULL, 0x080fe40000410000ULL, 0x000000265b5b7220ULL, 0x080fe40000410000ULL,
0x0000002656567220ULL, 0x080fe40000410000ULL, 0x0000002657577220ULL, 0x080fe40000410000ULL,
0x0000002652527220ULL, 0x080fe40000410000ULL, 0x0000002653537220ULL, 0x000fc40000410000ULL,
0x000000264e4e7220ULL, 0x080fe40000410000ULL, 0x000000264f4f7220ULL, 0x080fe40000410000ULL,
0x000000264a4a7220ULL, 0x080fe40000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00006cff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001017267811ULL, 0x000fe200078ff0ffULL, 0x0000d5b27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002644447220ULL, 0x08cfe40000410000ULL,
0x0000002645457220ULL, 0x080fe40000410000ULL, 0x0000002640407220ULL, 0x080fe40000410000ULL,
0x0000002641417220ULL, 0x080fe40000410000ULL, 0x000000263c3c7220ULL, 0x080fe40000410000ULL,
0x000000263d3d7220ULL, 0x000fc40000410000ULL, 0x0000002638387220ULL, 0x080fe40000410000ULL,
0x0000002639397220ULL, 0x080fe40000410000ULL, 0x0000002634347220ULL, 0x080fe40000410000ULL,
0x0000002635357220ULL, 0x080fe40000410000ULL, 0x0000002630307220ULL, 0x080fe40000410000ULL,
0x0000002631317220ULL, 0x000fc40000410000ULL, 0x000000262c2c7220ULL, 0x080fe40000410000ULL,
0x000000262d2d7220ULL, 0x080fe40000410000ULL, 0x0000002628287220ULL, 0x080fe40000410000ULL,
0x0000002629297220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000006cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001817267811ULL, 0x000fe200078ff0ffULL, 0x0000d4a27f007947ULL, 0x000fea000b800000ULL,
0x00001f2627267589ULL, 0x0004e400000e0000ULL, 0x0000002646467220ULL, 0x08cfe40000410000ULL,
0x0000002647477220ULL, 0x080fe40000410000ULL, 0x0000002642427220ULL, 0x080fe40000410000ULL,
0x0000002643437220ULL, 0x080fe40000410000ULL, 0x000000263e3e7220ULL, 0x080fe40000410000ULL,
0x000000263f3f7220ULL, 0x000fc40000410000ULL, 0x000000263a3a7220ULL, 0x080fe40000410000ULL,
0x000000263b3b7220ULL, 0x080fe40000410000ULL, 0x0000002636367220ULL, 0x080fe40000410000ULL,
0x0000002637377220ULL, 0x080fe40000410000ULL, 0x0000002632327220ULL, 0x080fe40000410000ULL,
0x0000002633337220ULL, 0x000fc40000410000ULL, 0x000000262e2e7220ULL, 0x080fe40000410000ULL,
0x000000262f2f7220ULL, 0x080fe40000410000ULL, 0x000000262a2a7220ULL, 0x080fe40000410000ULL,
0x000000262b2b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000006c21ff7212ULL, 0x000fda00078030ffULL, 0x0000000c080c0221ULL, 0x000fe20000010100ULL,
0x00007610ff240816ULL, 0x000fc60000000024ULL, 0x3fb8aa3b0c0c0820ULL, 0x000fc80000410000ULL,
0x0000000c00090308ULL, 0x000e640000000800ULL, 0x0000000920200220ULL, 0x002fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002220227221ULL, 0x004fc40000010000ULL,
0x00000000000a7805ULL, 0x000fca0000015200ULL, 0xfffffff014267812ULL, 0x000fca00078ec0ffULL,
0x01a6b40026217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe40007804869ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff257224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x000000200a237210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e0bULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x000fc80000011421ULL,
0x000000230c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x000000020c0c7819ULL, 0x000fc80000001221ULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6b40026217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe40007804869ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009910240a7816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0a00720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000009ff04723eULL, 0x000fe400000000ffULL, 0x00000002ff0a7819ULL, 0x000fe40000011617ULL,
0x0000541004277816ULL, 0x000fe20000000004ULL, 0x0000d0927f007947ULL, 0x000fea000b800000ULL,
0x00001f0a27077589ULL, 0x0002a400000e0000ULL, 0x000000080a267810ULL, 0x000fe20007ffe0ffULL,
0x0000d0d27f007947ULL, 0x000fea000b800000ULL, 0x000000100a047810ULL, 0x000fe20007ffe0ffULL,
0x00001f2627067589ULL, 0x00066800000e0000ULL, 0x00001f0427057589ULL, 0x0006a400000e0000ULL,
0x000000180a267810ULL, 0x008fe20007ffe0ffULL, 0x0000d1427f007947ULL, 0x000fea000b800000ULL,
0x00001f2627047589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001130a7812ULL, 0x002fe200078ec0ffULL, 0x0000000803207824ULL, 0x000fe200078e00ffULL,
0x00000004ff0b7819ULL, 0x000fe20000011617ULL, 0x0000000802217824ULL, 0x000fe200078e00ffULL,
0x0000100000007810ULL, 0x000fe20007ffe0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000018000007945ULL, 0x000fe20003800000ULL, 0x000000040a0a7824ULL, 0x000fc400078e020bULL,
0x000000101c707824ULL, 0x000fe400078e0200ULL, 0x00000001030b7824ULL, 0x100fe400078e020aULL,
0x00000001020c7824ULL, 0x000fc600078e020aULL, 0xfffffff8200a7812ULL, 0x000fe200078ee20bULL,
0x000000041a207824ULL, 0x000fe200078e00ffULL, 0x00015000100b7811ULL, 0x000fe400078e60ffULL,
0xfffffff8210c7812ULL, 0x000fe400078ee20cULL, 0x0000000420207812ULL, 0x000fe200078ec0ffULL,
0x000000100a0a7824ULL, 0x100fe400078e020bULL, 0x000000100c0c7824ULL, 0x000fe200078e020bULL,
0x00000002201c7812ULL, 0x000fc400078efcffULL, 0x000000000a68783bULL, 0x0002e80000000200ULL,
0x000000000c24783bULL, 0x0082e20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000768687232ULL, 0x084fe40000000000ULL, 0x000000076a6a7232ULL, 0x000fe40000000000ULL,
0x0000000669697232ULL, 0x080fe40000000000ULL, 0x000000066b6b7232ULL, 0x000fc40000000000ULL,
0x0000000524247232ULL, 0x088fe40000000000ULL, 0x0000000526267232ULL, 0x000fe40000000000ULL,
0x0000000425257232ULL, 0x080fe40000000000ULL, 0x0000000427277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001c170a7211ULL, 0x002fe200078fe0ffULL,
0x00000008030c7824ULL, 0x040fe200078e00ffULL, 0x000000007070783bULL, 0x000e620000004200ULL,
0x000000101e1e7824ULL, 0x000fe200078e020bULL, 0x0000083000007945ULL, 0x000fe20003800000ULL,
0x0000000103037824ULL, 0x000fca00078e020aULL, 0xfffffff80c037812ULL, 0x000fca00078ee203ULL,
0x0000001003037824ULL, 0x000fca00078e0200ULL, 0x000000000374783bULL, 0x0008e20000004200ULL,
0x00000018ff207819ULL, 0x002fe20000011471ULL, 0x00010000737d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe40000011470ULL, 0x0000002000787306ULL, 0x0003e20000200c00ULL,
0x0000888070037816ULL, 0x010fe400000000ffULL, 0x00000018ff237819ULL, 0x000fe40000011473ULL,
0x00000018ff217819ULL, 0x000fc40000011472ULL, 0x00000018ff7d7819ULL, 0x000fe2000001147dULL,
0x0000000c001c7306ULL, 0x0009e20000200c00ULL, 0x0000888071207816ULL, 0x002fe400000000ffULL,
0x00000018ff6c7819ULL, 0x008fe20000011474ULL, 0x0000010074817824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fe20000011475ULL, 0x00000100700c7824ULL, 0x050fe400078e00ffULL,
0x0000006c00847306ULL, 0x000fe20000200c00ULL, 0x0001000070707824ULL, 0x000fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fc40000011476ULL, 0x00000018ff0c7819ULL, 0x000fe4000001140cULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x00000020006c7306ULL, 0x0003e20000200c00ULL,
0x00000018ff7b7819ULL, 0x000fe40000011477ULL, 0x0000888077897816ULL, 0x000fe400000000ffULL,
0x00000018ff817819ULL, 0x000fc60000011481ULL, 0x00000023007f7306ULL, 0x000fe20000200c00ULL,
0x0000010072207824ULL, 0x002fca00078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000007000237306ULL, 0x0003f00000200c00ULL, 0x0000007900857306ULL, 0x0007e20000200c00ULL,
0x0000010073707824ULL, 0x002fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000007a008a7306ULL, 0x000fe20000200c00ULL, 0x0000888072797816ULL, 0x048fe200000000ffULL,
0x0001000072727824ULL, 0x000fca00078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x00000020007a7306ULL, 0x0003f00000200c00ULL, 0x0000000300037306ULL, 0x000fe20000200c00ULL,
0x0000888074207816ULL, 0x042fe200000000ffULL, 0x0001000074747824ULL, 0x000fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x0000000c000c7306ULL, 0x000ff00000200c00ULL,
0x0000007b008b7306ULL, 0x0003f00000200c00ULL, 0x00000070007e7306ULL, 0x0007e20000200c00ULL,
0x00008880737b7816ULL, 0x002fce00000000ffULL, 0x0000007200737306ULL, 0x0003e20000200c00ULL,
0x0000888075707816ULL, 0x008fce00000000ffULL, 0x0000002000827306ULL, 0x0007e20000200c00ULL,
0x0000010075727824ULL, 0x002fca00078e00ffULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x00000021007c7306ULL, 0x0003220000200c00ULL, 0x0001000075207824ULL, 0x008fca00078e00ffULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x0000007400757306ULL, 0x0006a20000200c00ULL,
0x0000010071217824ULL, 0x042fe400078e00ffULL, 0x0001000071717824ULL, 0x000fc600078e00ffULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000007d00807306ULL, 0x0003e20000200c00ULL,
0x0000010077747824ULL, 0x048fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0001000077777824ULL, 0x000fe200078e00ffULL, 0x00005410737c7816ULL, 0x010fe4000000007cULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000007000837306ULL, 0x0007e20000200c00ULL,
0x00008880767d7816ULL, 0x002fc400000000ffULL, 0x00000018ff777819ULL, 0x000fe40000011477ULL,
0x0000541075847816ULL, 0x004fc60000000084ULL, 0x0000002000867306ULL, 0x0002a20000200c00ULL,
0x0000010076707824ULL, 0x048fe400078e00ffULL, 0x0001000076767824ULL, 0x000fc600078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x00000018ff767819ULL, 0x000fe20000011476ULL,
0x0000002100217306ULL, 0x000ee20000200c00ULL, 0x0000541003207816ULL, 0x002fe4000000000cULL,
0x0000541086857816ULL, 0x004fca0000000085ULL, 0x0000007100717306ULL, 0x000e640000200c00ULL,
0x000000846850723cULL, 0x080f6c0000001850ULL, 0x0000007900797306ULL, 0x000ea20000200c00ULL,
0x000054106c217816ULL, 0x008fe20000000021ULL, 0x000000842430723cULL, 0x000f6c0000001830ULL,
0x0000007b007b7306ULL, 0x000ee20000200c00ULL, 0x0000541071717816ULL, 0x002fe20000000078ULL,
0x000000206864723cULL, 0x080f6c0000001864ULL, 0x0000008100817306ULL, 0x000e620000200c00ULL,
0x00005410797a7816ULL, 0x004fe2000000007aULL, 0x000000202444723cULL, 0x000f6c0000001844ULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x000054107b7b7816ULL, 0x008fce000000007eULL,
0x0000007d00877306ULL, 0x0007e20000200c00ULL, 0x0000541082827816ULL, 0x002fe20000000081ULL,
0x0000007a685c723cULL, 0x080f6c000000185cULL, 0x0000007000887306ULL, 0x0003220000200c00ULL,
0x00005410807d7816ULL, 0x008fe2000000007fULL, 0x0000007a243c723cULL, 0x000f62000000183cULL,
0x0000541083837816ULL, 0x004fca0000000072ULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x0000541023707816ULL, 0x002fe2000000001cULL, 0x0000007c6858723cULL, 0x040f6c0000001858ULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x0000541087887816ULL, 0x010fe20000000088ULL,
0x000000706860723cULL, 0x040f6c0000001860ULL, 0x0000007600037306ULL, 0x000ea40000200c00ULL,
0x000000826854723cULL, 0x000f6c0000001854ULL, 0x00000077000c7306ULL, 0x000ee20000200c00ULL,
0x0000541089897816ULL, 0x002fe20000000074ULL, 0x000000702440723cULL, 0x000f620000001840ULL,
0x00005410038a7816ULL, 0x004fe2000000008aULL, 0x000000101d037824ULL, 0x000fcc00078e020bULL,
0x00000088684c723cULL, 0x000f62000000184cULL, 0x000054100c8b7816ULL, 0x008fce000000008bULL,
0x0000007c2438723cULL, 0x000f700000001838ULL, 0x0000008a6848723cULL, 0x000b6e0000001848ULL,
0x000000101f687824ULL, 0x020fe200078e0200ULL, 0x000000822434723cULL, 0x040f620000001834ULL,
0x000000001e1c783bULL, 0x000e6e0000000200ULL, 0x00000088242c723cULL, 0x040f70000000182cULL,
0x0000008a2428723cULL, 0x000b640000001828ULL, 0x000000000324783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000724247232ULL, 0x088fe40000000000ULL, 0x0000000726267232ULL, 0x000fc40000000000ULL,
0x0000000625257232ULL, 0x080fe40000000000ULL, 0x0000000627277232ULL, 0x000fe40000000000ULL,
0x000000051c1c7232ULL, 0x082fe40000000000ULL, 0x000000051e1e7232ULL, 0x000fe40000000000ULL,
0x000000041d1d7232ULL, 0x080fe40000000000ULL, 0x000000041f1f7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000802037824ULL, 0x044fe200078e00ffULL,
0x000000006868783bULL, 0x000ea20000004200ULL, 0x0000000102027824ULL, 0x000fca00078e020aULL,
0xfffffff803037812ULL, 0x000fca00078ee202ULL, 0x0000001003037824ULL, 0x000fca00078e0200ULL,
0x000000000370783bULL, 0x000f220000004200ULL, 0x00000018ff027819ULL, 0x004fe20000011469ULL,
0x000001006a747824ULL, 0x000fe200078e00ffULL, 0x00000018ff0b7819ULL, 0x000fe4000001146aULL,
0x0000000200237306ULL, 0x0005e20000200c00ULL, 0x00000018ff007819ULL, 0x000fe40000011468ULL,
0x00000018ff0c7819ULL, 0x000fe4000001146bULL, 0x00000018ff747819ULL, 0x000fc60000011474ULL,
0x0000000b00767306ULL, 0x0007e20000200c00ULL, 0x0000010068027824ULL, 0x004fe200078e00ffULL,
0x00000018ff037819ULL, 0x010fe20000011471ULL, 0x0000010070797824ULL, 0x000fc600078e00ffULL,
0x00000018ff027819ULL, 0x000fe20000011402ULL, 0x0000010072807824ULL, 0x040fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fe20000011470ULL, 0x00000100690b7824ULL, 0x008fe200078e00ffULL,
0x00000000000a7306ULL, 0x0005e20000200c00ULL, 0x00000018ff217819ULL, 0x000fe40000011472ULL,
0x00000018ff6c7819ULL, 0x000fe40000011473ULL, 0x00008880727f7816ULL, 0x040fe200000000ffULL,
0x0001000072727824ULL, 0x000fe200078e00ffULL, 0x00000018ff797819ULL, 0x000fe20000011479ULL,
0x0000000c00787306ULL, 0x0007e20000200c00ULL, 0x0000888068007816ULL, 0x044fe200000000ffULL,
0x0001000068687824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fc40000011480ULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x00000018ff687819ULL, 0x000fe20000011468ULL,
0x00000003007d7306ULL, 0x000fe20000200c00ULL, 0x00008880690c7816ULL, 0x048fe200000000ffULL,
0x0001000069697824ULL, 0x000fca00078e00ffULL, 0x00000018ff697819ULL, 0x000fe20000011469ULL,
0x0000000200037306ULL, 0x0005f00000200c00ULL, 0x00000020007c7306ULL, 0x0007e20000200c00ULL,
0x000088806a027816ULL, 0x044fe200000000ffULL, 0x000100006a6a7824ULL, 0x000fca00078e00ffULL,
0x00000018ff6a7819ULL, 0x000fe2000001146aULL, 0x0000002100827306ULL, 0x000fe20000200c00ULL,
0x00000018ff207819ULL, 0x008fce000001140bULL, 0x0000000000007306ULL, 0x000ff00000200c00ULL,
0x0000000200757306ULL, 0x0005f00000200c00ULL, 0x0000000c000c7306ULL, 0x000fe20000200c00ULL,
0x0000888070027816ULL, 0x044fe200000000ffULL, 0x0001000070707824ULL, 0x000fca00078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011470ULL, 0x0000002000217306ULL, 0x0005f00000200c00ULL,
0x0000006c00847306ULL, 0x000fe20000200c00ULL, 0x000088806b207816ULL, 0x004fce00000000ffULL,
0x00000002007a7306ULL, 0x0005f00000200c00ULL, 0x00000069006c7306ULL, 0x000fe20000200c00ULL,
0x0001000071027824ULL, 0x004fca00078e00ffULL, 0x00000018ff027819ULL, 0x000fe40000011402ULL,
0x0000006a00697306ULL, 0x0004f00000200c00ULL, 0x00000068000b7306ULL, 0x0008620000200c00ULL,
0x00000100716a7824ULL, 0x004fca00078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x00000002007e7306ULL, 0x0004620000200c00ULL, 0x000001006b687824ULL, 0x010fe200078e00ffULL,
0x0000541069767816ULL, 0x008fe20000000076ULL, 0x000100006b6b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x0000006a007b7306ULL, 0x0007e20000200c00ULL,
0x0000541000027816ULL, 0x004fe40000000003ULL, 0x000054100c037816ULL, 0x000fe20000000021ULL,
0x00000100730c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe4000001146bULL,
0x000054100b0a7816ULL, 0x002fe2000000000aULL, 0x0000006800777306ULL, 0x0003e20000200c00ULL,
0x00008880736a7816ULL, 0x048fe200000000ffULL, 0x0001000073737824ULL, 0x000fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x000000022464723cULL, 0x000b620000001864ULL,
0x000054106c0b7816ULL, 0x000fe20000000023ULL, 0x000000ffff007224ULL, 0x000fe200078e006aULL,
0x00000018ff737819ULL, 0x000fe20000011473ULL, 0x0000007400747306ULL, 0x000ea20000200c00ULL,
0x0000888071687816ULL, 0x002fc400000000ffULL, 0x000054107e7d7816ULL, 0x000fe2000000007dULL,
0x0000000a2460723cULL, 0x000b680000001860ULL, 0x0000002000207306ULL, 0x000e680000200c00ULL,
0x000000021c44723cULL, 0x000b680000001844ULL, 0x0000007200837306ULL, 0x000ee20000200c00ULL,
0x0000541075747816ULL, 0x004fc60000000074ULL, 0x0000000a1c40723cULL, 0x000b680000001840ULL,
0x0000006b006b7306ULL, 0x000ea20000200c00ULL, 0x0000541020757816ULL, 0x002fce0000000077ULL,
0x0000007900797306ULL, 0x000e620000200c00ULL, 0x0000541083827816ULL, 0x008fe20000000082ULL,
0x00000074245c723cULL, 0x080b6c000000185cULL, 0x0000006800687306ULL, 0x000ee20000200c00ULL,
0x000054106b777816ULL, 0x004fe20000000078ULL, 0x000000741c3c723cULL, 0x000b6c000000183cULL,
0x0000007000717306ULL, 0x000ea20000200c00ULL, 0x000054107a7a7816ULL, 0x002fe20000000079ULL,
0x000000762458723cULL, 0x080b6c0000001858ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x00005410687b7816ULL, 0x008fe2000000007bULL, 0x000000761c38723cULL, 0x000b6c0000001838ULL,
0x0000008000807306ULL, 0x000e620000200c00ULL, 0x00005410717c7816ULL, 0x004fe2000000007cULL,
0x0000007a2454723cULL, 0x040b6c0000001854ULL, 0x0000000000007306ULL, 0x000fe40000200c00ULL,
0x0000007c2450723cULL, 0x000b6c0000001850ULL, 0x0000000c00817306ULL, 0x000ea20000200c00ULL,
0x000054107f807816ULL, 0x002fe20000000080ULL, 0x0000007a1c34723cULL, 0x040b6c0000001834ULL,
0x0000007300737306ULL, 0x000e640000200c00ULL, 0x0000007c1c30723cULL, 0x000b620000001830ULL,
0x0000541000817816ULL, 0x004fce0000000081ULL, 0x00000080244c723cULL, 0x000b62000000184cULL,
0x0000541073837816ULL, 0x002fce0000000084ULL, 0x000000822448723cULL, 0x000b700000001848ULL,
0x000000801c2c723cULL, 0x040b70000000182cULL, 0x000000821c28723cULL, 0x000b620000001828ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x000000000d027f8cULL, 0x0202a2000c80043fULL,
0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL, 0x0001a6a0100a7811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000aff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff007224ULL, 0x004fe200078e0003ULL, 0x0000001000002944ULL, 0x000fe20003c00000ULL,
0xffff514000007947ULL, 0x000fea000383ffffULL, 0x000000ff1500720cULL, 0x000fe20003f05270ULL,
0x000000ffff0f7224ULL, 0x000fe400078e002bULL, 0x000000ffff687224ULL, 0x000fe400078e002aULL,
0x000000ffff0d7224ULL, 0x002fe400078e002fULL, 0x000000ffff247224ULL, 0x000fc400078e002eULL,
0x000000ffff0b7224ULL, 0x000fe400078e0033ULL, 0x000000ffff207224ULL, 0x000fe400078e0032ULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0180000022007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000c7e000047802ULL, 0x000fc40000000f00ULL, 0x0000c19000007944ULL, 0x00cfea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002200037308ULL, 0x004e640000001000ULL,
0xbf80000003007423ULL, 0x002fc80000000022ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006b00ff037624ULL, 0x000fe400078e00ffULL, 0x00006a00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000802037981ULL, 0x000f28000c1e9900ULL, 0x0000000000087919ULL, 0x000e680000000000ULL,
0x0000000000047919ULL, 0x000ee20000000000ULL, 0x0000001808057811ULL, 0x042fe400078ff0ffULL,
0x0000000808097811ULL, 0x000fc400078ff0ffULL, 0x00000002ff077819ULL, 0x008fe40000011604ULL,
0x0000001008157811ULL, 0x000fe200078ff0ffULL, 0x0000000003067220ULL, 0x014fca0000410000ULL,
0x00001f0706007589ULL, 0x000e6800000e0000ULL, 0x00001f0506057589ULL, 0x000ea800000e0000ULL,
0x00001f0906047589ULL, 0x000ee800000e0000ULL, 0x00001f1506027589ULL, 0x000f2200000e0000ULL,
0x0000006400647220ULL, 0x002fc40000410000ULL, 0x0000006500657220ULL, 0x040fe40000410000ULL,
0x0000006000607220ULL, 0x040fe40000410000ULL, 0x0000006100617220ULL, 0x040fe40000410000ULL,
0x0000005c005c7220ULL, 0x040fe40000410000ULL, 0x0000005d005d7220ULL, 0x040fe40000410000ULL,
0x0000005800587220ULL, 0x000fc40000410000ULL, 0x0000005900597220ULL, 0x040fe40000410000ULL,
0x0000005400547220ULL, 0x040fe40000410000ULL, 0x0000005500557220ULL, 0x040fe40000410000ULL,
0x0000005000507220ULL, 0x040fe40000410000ULL, 0x0000005100517220ULL, 0x040fe40000410000ULL,
0x0000004c004c7220ULL, 0x000fc40000410000ULL, 0x0000004d004d7220ULL, 0x040fe40000410000ULL,
0x0000004800487220ULL, 0x040fe40000410000ULL, 0x0000004900497220ULL, 0x000fe40000410000ULL,
0x0000004605467220ULL, 0x044fe40000410000ULL, 0x0000004705477220ULL, 0x040fe40000410000ULL,
0x0000004205427220ULL, 0x000fc40000410000ULL, 0x0000004305437220ULL, 0x040fe40000410000ULL,
0x0000003e053e7220ULL, 0x040fe40000410000ULL, 0x0000003f053f7220ULL, 0x040fe40000410000ULL,
0x0000003a053a7220ULL, 0x040fe40000410000ULL, 0x0000003b053b7220ULL, 0x040fe40000410000ULL,
0x0000003605367220ULL, 0x000fc40000410000ULL, 0x0000003705377220ULL, 0x040fe40000410000ULL,
0x0000002005207220ULL, 0x040fe40000410000ULL, 0x0000000b050b7220ULL, 0x040fe40000410000ULL,
0x0000002405247220ULL, 0x040fe40000410000ULL, 0x0000000d050d7220ULL, 0x040fe40000410000ULL,
0x0000006805687220ULL, 0x000fc40000410000ULL, 0x0000000f050f7220ULL, 0x000fe40000410000ULL,
0x0000000466667220ULL, 0x088fe40000410000ULL, 0x0000000467677220ULL, 0x080fe40000410000ULL,
0x0000000462627220ULL, 0x080fe40000410000ULL, 0x0000000463637220ULL, 0x080fe40000410000ULL,
0x000000045e5e7220ULL, 0x000fc40000410000ULL, 0x000000045f5f7220ULL, 0x080fe40000410000ULL,
0x000000045a5a7220ULL, 0x080fe40000410000ULL, 0x000000045b5b7220ULL, 0x080fe40000410000ULL,
0x0000000456567220ULL, 0x080fe40000410000ULL, 0x0000000457577220ULL, 0x080fe40000410000ULL,
0x0000000452527220ULL, 0x000fc40000410000ULL, 0x0000000453537220ULL, 0x080fe40000410000ULL,
0x000000044e4e7220ULL, 0x080fe40000410000ULL, 0x000000044f4f7220ULL, 0x080fe40000410000ULL,
0x000000044a4a7220ULL, 0x080fe40000410000ULL, 0x000000044b4b7220ULL, 0x000fe40000410000ULL,
0x0000000244447220ULL, 0x010fc40000410000ULL, 0x0000000245457220ULL, 0x080fe40000410000ULL,
0x0000000240407220ULL, 0x080fe40000410000ULL, 0x0000000241417220ULL, 0x080fe40000410000ULL,
0x000000023c3c7220ULL, 0x080fe40000410000ULL, 0x000000023d3d7220ULL, 0x080fe40000410000ULL,
0x0000000238387220ULL, 0x000fc40000410000ULL, 0x0000000239397220ULL, 0x080fe40000410000ULL,
0x0000000234347220ULL, 0x080fe40000410000ULL, 0x0000000235357220ULL, 0x080fe40000410000ULL,
0x0000000230307220ULL, 0x080fe40000410000ULL, 0x0000000231317220ULL, 0x080fe40000410000ULL,
0x000000022c2c7220ULL, 0x000fc40000410000ULL, 0x000000022d2d7220ULL, 0x080fe40000410000ULL,
0x0000000228287220ULL, 0x080fe40000410000ULL, 0x0000000229297220ULL, 0x000fc40000410000ULL,
0x0000000000037919ULL, 0x004e620000000000ULL, 0x000000666766723eULL, 0x000fe400000000ffULL,
0x000000626333723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000005e5f5e723eULL, 0x000fc400000000ffULL, 0x0000005a5b2f723eULL, 0x000fe400000000ffULL,
0x000000565756723eULL, 0x000fe400000000ffULL, 0x00000052532b723eULL, 0x000fe400000000ffULL,
0x0000004e4f4e723eULL, 0x000fe400000000ffULL, 0x0000004a4b27723eULL, 0x000fe400000000ffULL,
0x0000541066327816ULL, 0x000fc40000000033ULL, 0x0000000803057811ULL, 0x042fe400078ff0ffULL,
0x0000001003097811ULL, 0x040fe400078ff0ffULL, 0x0000000203007812ULL, 0x000fe200078ec0ffULL,
0x0000000805177824ULL, 0x000fe200078e00ffULL, 0x00000002ff077819ULL, 0x000fe20000011603ULL,
0x0000000809127824ULL, 0x000fe200078e00ffULL, 0x0000001803157811ULL, 0x000fe400078ff0ffULL,
0x0000000500047211ULL, 0x040fe200078ff8ffULL, 0x00000008070e7824ULL, 0x000fe200078e00ffULL,
0x0000000700027211ULL, 0x000fc400078ff8ffULL, 0x0000000900057211ULL, 0x040fe200078ff8ffULL,
0x0000000807097824ULL, 0x000fe200078e00ffULL, 0x0000001500067211ULL, 0x000fe200078ff8ffULL,
0x0000000815157824ULL, 0x000fe200078e00ffULL, 0x0000000202007810ULL, 0x000fe40007ffe0ffULL,
0xfffffff812127812ULL, 0x000fe200078ee205ULL, 0x0000000807057824ULL, 0x000fe200078e00ffULL,
0xfffffff809087812ULL, 0x000fe200078ee200ULL, 0x0000200011007824ULL, 0x000fe200078e00ffULL,
0xfffffff8170a7812ULL, 0x008fc400078ee204ULL, 0xfffffff815147812ULL, 0x000fe400078ee206ULL,
0xfffffff805047812ULL, 0x000fe200078ee202ULL, 0x0000100013057824ULL, 0x000fe200078e0200ULL,
0x0000000402067810ULL, 0x040fe40007ffe0ffULL, 0x0000000602077810ULL, 0x000fe20007ffe0ffULL,
0x0000000803027824ULL, 0x000fe200078e00ffULL, 0xfffffff8090c7812ULL, 0x000fe200078ee206ULL,
0x0000001004067824ULL, 0x000fe200078e0205ULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL,
0x000000100a107824ULL, 0x100fe200078e0205ULL, 0x0000000802077812ULL, 0x000fe200078ec0ffULL,
0x00000010080a7824ULL, 0x100fe200078e0205ULL, 0x000000646502723eULL, 0x000fe200000000ffULL,
0x0000001012127824ULL, 0x000fe200078e0205ULL, 0x000000606104723eULL, 0x000fe200000000ffULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x000000505106723eULL, 0x000fe200000000ffULL,
0x0000001014147824ULL, 0x100fe200078e0205ULL, 0x00005410021c7816ULL, 0x100fe20000000004ULL,
0x000000100c0c7824ULL, 0x100fe200078e0205ULL, 0x00007632021d7816ULL, 0x000fe20000000004ULL,
0x000000100e0e7824ULL, 0x000fe200078e0205ULL, 0x0000005c5d02723eULL, 0x000fe200000000ffULL,
0x0000000107107824ULL, 0x000fe200078e0210ULL, 0x000000585904723eULL, 0x000fe200000000ffULL,
0x0000001c08007388ULL, 0x0003e20000000a00ULL, 0x000000545505723eULL, 0x000fe200000000ffULL,
0x0000000107127824ULL, 0x000fe200078e0212ULL, 0x000000444544723eULL, 0x000fe200000000ffULL,
0x0000000107147824ULL, 0x000fe200078e0214ULL, 0x000000404122723eULL, 0x000fe200000000ffULL,
0x00000001070a7824ULL, 0x040fe200078e020aULL, 0x0000763266337816ULL, 0x000fe20000000033ULL,
0x00000001070c7824ULL, 0x040fe200078e020cULL, 0x000054105e2e7816ULL, 0x000fe2000000002fULL,
0x00000001070e7824ULL, 0x000fe200078e020eULL, 0x0000004c4d07723eULL, 0x000fc400000000ffULL,
0x000000484908723eULL, 0x002fe400000000ffULL, 0x00005410021c7816ULL, 0x140fe40000000004ULL,
0x00007632021d7816ULL, 0x000fe40000000004ULL, 0x0000541005047816ULL, 0x140fe40000000006ULL,
0x0000763205057816ULL, 0x000fe20000000006ULL, 0x0000001c0a007388ULL, 0x000fe20000000a00ULL,
0x0000541007067816ULL, 0x000fc40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x000000040c007388ULL, 0x000fe20000000a00ULL, 0x0000003c3d3c723eULL, 0x000fe400000000ffULL,
0x00000038391e723eULL, 0x000fe200000000ffULL, 0x000000060e007388ULL, 0x0003e20000000a00ULL,
0x000076325e2f7816ULL, 0x000fe4000000002fULL, 0x00005410562a7816ULL, 0x140fe2000000002bULL,
0x0000003210007388ULL, 0x000fe20000000a00ULL, 0x00007632562b7816ULL, 0x000fc4000000002bULL,
0x000054104e267816ULL, 0x140fe20000000027ULL, 0x0004002e0a007388ULL, 0x000fe20000000a00ULL,
0x000076324e277816ULL, 0x000fe40000000027ULL, 0x000054103c087816ULL, 0x000fe2000000001eULL,
0x0004002a0c007388ULL, 0x000fe20000000a00ULL, 0x0000541044067816ULL, 0x142fe40000000022ULL,
0x0000763244077816ULL, 0x000fe20000000022ULL, 0x000400260e007388ULL, 0x000fe20000000a00ULL,
0x000076323c097816ULL, 0x000fc4000000001eULL, 0x000000343534723eULL, 0x000fe200000000ffULL,
0x0000000612007388ULL, 0x000fe20000000a00ULL, 0x00000030311a723eULL, 0x000fe400000000ffULL,
0x0000002c2d2c723eULL, 0x000fe200000000ffULL, 0x000800080a007388ULL, 0x0003e20000000a00ULL,
0x000000282916723eULL, 0x000fe400000000ffULL, 0x000000464702723eULL, 0x000fe400000000ffULL,
0x000000424304723eULL, 0x000fc400000000ffULL, 0x000054102c1c7816ULL, 0x140fe40000000016ULL,
0x000076322c1d7816ULL, 0x000fe40000000016ULL, 0x0000003e3f05723eULL, 0x000fe400000000ffULL,
0x0000541034087816ULL, 0x142fe4000000001aULL, 0x0000763234097816ULL, 0x000fe4000000001aULL,
0x0000003a3b06723eULL, 0x000fc400000000ffULL, 0x0000541002167816ULL, 0x140fe20000000004ULL,
0x000800080c007388ULL, 0x0003e20000000a00ULL, 0x0000763202177816ULL, 0x000fe40000000004ULL,
0x000000363702723eULL, 0x000fe200000000ffULL, 0x0008001c0e007388ULL, 0x0005e20000000a00ULL,
0x000000200b04723eULL, 0x000fe400000000ffULL, 0x000000240d07723eULL, 0x000fe200000000ffULL,
0x0000001614007388ULL, 0x000fe20000000a00ULL, 0x00005410022c7816ULL, 0x000fc40000000004ULL,
0x00007632022d7816ULL, 0x000fe40000000004ULL, 0x000000680f08723eULL, 0x002fe400000000ffULL,
0x000000ff1300720cULL, 0x000fe40003f05270ULL, 0x00005410051c7816ULL, 0x144fe40000000006ULL,
0x00007632051d7816ULL, 0x000fe20000000006ULL, 0x000000016e057824ULL, 0x000fe200078e0203ULL,
0x0000541007067816ULL, 0x000fc40000000008ULL, 0x0000763207077816ULL, 0x000fe20000000008ULL,
0x0000001005057824ULL, 0x000fe200078e0200ULL, 0x000c001c0a007388ULL, 0x000fe80000000a00ULL,
0x000c002c0c007388ULL, 0x000fe80000000a00ULL, 0x000c00060e007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000005147984ULL, 0x000e680000000c00ULL,
0x00040000051c7984ULL, 0x000ea80000000c00ULL, 0x0008000005247984ULL, 0x000ee80000000c00ULL,
0x000c0000052c7984ULL, 0x000f280000000c00ULL, 0x0010000005087984ULL, 0x000ee80000000c00ULL,
0x0014000005207984ULL, 0x000f280000000c00ULL, 0x0018000005287984ULL, 0x000f280000000c00ULL,
0x001c000005307984ULL, 0x000f220000000c00ULL, 0x200000ff17177230ULL, 0x002fc40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fe40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x004fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fc40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x200000ff27277230ULL, 0x008fe40000000000ULL,
0x200000ff26267230ULL, 0x000fe40000000000ULL, 0x200000ff25257230ULL, 0x000fe40000000000ULL,
0x200000ff24247230ULL, 0x000fe40000000000ULL, 0x200000ff2f2f7230ULL, 0x010fc40000000000ULL,
0x200000ff2e2e7230ULL, 0x000fe40000000000ULL, 0x200000ff2d2d7230ULL, 0x000fe40000000000ULL,
0x200000ff2c2c7230ULL, 0x000fe40000000000ULL, 0x0000000b17177230ULL, 0x000fe40000000000ULL,
0x0000000a16167230ULL, 0x000fe40000000000ULL, 0x0000000915157230ULL, 0x000fc40000000000ULL,
0x0000000814147230ULL, 0x000fe40000000000ULL, 0x000000231f1f7230ULL, 0x000fe40000000000ULL,
0x000000221e1e7230ULL, 0x000fe20000000000ULL, 0x0000001405007388ULL, 0x000fe20000000c00ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x000fc40000000000ULL, 0x0000002a26267230ULL, 0x000fe20000000000ULL,
0x0004001c05007388ULL, 0x000fe20000000c00ULL, 0x0000002925257230ULL, 0x000fe40000000000ULL,
0x0000002824247230ULL, 0x000fe40000000000ULL, 0x000000332f2f7230ULL, 0x000fe40000000000ULL,
0x000000322e2e7230ULL, 0x000fe20000000000ULL, 0x0008002405007388ULL, 0x000fe20000000c00ULL,
0x000000312d2d7230ULL, 0x000fc40000000000ULL, 0x000000302c2c7230ULL, 0x000fca0000000000ULL,
0x000c002c05007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff047819ULL, 0x000fc80000011603ULL,
0x000000190400720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0x0000000104027824ULL, 0x000fe200078e0203ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x00000007030e7812ULL, 0x000fe200078ec0ffULL,
0x00005a0000067ab9ULL, 0x000fe40000000800ULL, 0x0000000702027812ULL, 0x000fe200078ec0ffULL,
0x0000000605057299ULL, 0x000fc6000800063fULL, 0x0ffffff802057812ULL, 0x000fe200078ef803ULL,
0x000000201b027824ULL, 0x000fe200078e0204ULL, 0x0000580000067ab9ULL, 0x000fc60000000800ULL,
0x0000001005057824ULL, 0x000fe200078e0200ULL, 0x0000000502077c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011602ULL, 0x0000000005087984ULL, 0x0004e20000000c00ULL,
0x0000000118077824ULL, 0x000fe200078e0207ULL, 0x00000006040472a4ULL, 0x002fc6000f8e023fULL,
0x0000006f02077224ULL, 0x000fe200078e0207ULL, 0x0000002003027810ULL, 0x000fe40007ffe0ffULL,
0x000000046f067c24ULL, 0x000fca000f8e02ffULL, 0x0000000706077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0007047a11ULL, 0x000fc800078040ffULL,
0x00005d0007057a11ULL, 0x004fe200000f440cULL, 0x0000000811077824ULL, 0x000fe200078e020eULL,
0x00000003ff0c7819ULL, 0x000fc60000011602ULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000190c00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0083f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000102047824ULL, 0x102fe400078e020cULL,
0x000000201b0c7824ULL, 0x000fc600078e020cULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef802ULL, 0x0000000702027812ULL, 0x000fc600078ec0ffULL,
0x0000001005077824ULL, 0x000fe200078e0200ULL, 0x000000050c057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff0c7a19ULL, 0x000fe4000001160cULL, 0x0000000007087984ULL, 0x0002a20000000c00ULL,
0x0000000118057824ULL, 0x000fc800078e0205ULL, 0x0000006f0c057224ULL, 0x000fe200078e0205ULL,
0x00000040030c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000811077824ULL, 0x002fc600078e0202ULL,
0x0000000506057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x00000003ff0e7819ULL, 0x000fc6000001160cULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000190e00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0043f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c027824ULL, 0x100fe200078e020eULL,
0x00000060030d7810ULL, 0x000fe20007ffe0ffULL, 0x000000201b0e7824ULL, 0x000fc600078e020eULL,
0x0000000702057812ULL, 0x002fc800078ec0ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001005027824ULL, 0x000fe200078e0200ULL,
0x000000050e057c12ULL, 0x000fe2000f8e30ffULL, 0x0000000811077824ULL, 0x000fe200078e020cULL,
0x00005a00ff0e7a19ULL, 0x000fe4000001160eULL, 0x0000000002087984ULL, 0x0002a20000000c00ULL,
0x0000000118057824ULL, 0x000fc800078e0205ULL, 0x0000006f0e057224ULL, 0x000fe200078e0205ULL,
0x00000003ff027819ULL, 0x002fc8000001160dULL, 0x0000000506057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000190200720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d047824ULL, 0x102fe200078e0202ULL,
0x00000080030c7810ULL, 0x000fe20007ffe0ffULL, 0x000000201b027824ULL, 0x000fc600078e0202ULL,
0x0000000704047812ULL, 0x000fc800078ec0ffULL, 0x0ffffff804057812ULL, 0x000fca00078ef80dULL,
0x0000001005077824ULL, 0x000fe200078e0200ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011602ULL, 0x0000000007087984ULL, 0x0002a20000000c00ULL,
0x0000000118057824ULL, 0x000fc800078e0205ULL, 0x0000006f02057224ULL, 0x000fe200078e0205ULL,
0x000000070d027812ULL, 0x000fc800078ec0ffULL, 0x0000000506057210ULL, 0x000fe20007f1e0ffULL,
0x0000000811077824ULL, 0x002fc800078e0202ULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x00000003ff0e7819ULL, 0x000fc6000001160cULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000190e00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0043f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c027824ULL, 0x100fe200078e020eULL,
0x000000a0030d7810ULL, 0x000fe20007ffe0ffULL, 0x000000201b0e7824ULL, 0x000fc600078e020eULL,
0x0000000702057812ULL, 0x002fc800078ec0ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001005027824ULL, 0x000fe200078e0200ULL,
0x000000050e057c12ULL, 0x000fe2000f8e30ffULL, 0x0000000811077824ULL, 0x000fe200078e020cULL,
0x00005a00ff0e7a19ULL, 0x000fe4000001160eULL, 0x0000000002087984ULL, 0x0002a20000000c00ULL,
0x0000000118057824ULL, 0x000fc800078e0205ULL, 0x0000006f0e057224ULL, 0x000fe200078e0205ULL,
0x00000003ff027819ULL, 0x002fc8000001160dULL, 0x0000000506057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000190200720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d047824ULL, 0x102fe200078e0202ULL,
0x000000c0030c7810ULL, 0x000fe20007ffe0ffULL, 0x000000201b027824ULL, 0x000fc600078e0202ULL,
0x0000000704047812ULL, 0x000fc800078ec0ffULL, 0x0ffffff804057812ULL, 0x000fca00078ef80dULL,
0x0000001005077824ULL, 0x000fe200078e0200ULL, 0x0000000502057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff027a19ULL, 0x000fe40000011602ULL, 0x0000000007087984ULL, 0x0002a20000000c00ULL,
0x0000000118057824ULL, 0x000fc800078e0205ULL, 0x0000006f02057224ULL, 0x000fe200078e0205ULL,
0x000000070d027812ULL, 0x000fc800078ec0ffULL, 0x0000000506057210ULL, 0x000fe20007f1e0ffULL,
0x0000000811077824ULL, 0x002fc800078e0202ULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x000fc800078040ffULL, 0x00005d0005057a11ULL, 0x000fe400000f440eULL,
0x00000003ff0e7819ULL, 0x000fc6000001160cULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000190e00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0043f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c027824ULL, 0x100fe200078e020eULL,
0x000000e003047810ULL, 0x002fe20007ffe0ffULL, 0x000000201b0e7824ULL, 0x000fc600078e020eULL,
0x0000000702057812ULL, 0x000fe400078ec0ffULL, 0x000000050e077c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef80cULL, 0x00005a00ff0e7a19ULL, 0x000fe2000001160eULL,
0x0000000118077824ULL, 0x000fe200078e0207ULL, 0x000000070c0c7812ULL, 0x000fe200078ec0ffULL,
0x0000001005057824ULL, 0x000fe400078e0200ULL, 0x0000006f0e077224ULL, 0x000fe200078e0207ULL,
0x00000003ff0e7819ULL, 0x000fc40000011604ULL, 0x0000000005087984ULL, 0x0002a40000000c00ULL,
0x0000000706077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x00005c0007027a11ULL, 0x000fe200078040ffULL, 0x0000000811057824ULL, 0x002fc600078e020cULL,
0x00005d0007037a11ULL, 0x000fe200000f4410ULL, 0x0000000104077824ULL, 0x000fe200078e020eULL,
0x000000190e00720cULL, 0x000fc60003f06070ULL, 0x0000001005027825ULL, 0x000fe200078e0002ULL,
0x0000000707077812ULL, 0x000fc800078ec0ffULL, 0xfffffff807077812ULL, 0x000fe200078ef804ULL,
0x0000000802007986ULL, 0x0043e8000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001007077824ULL, 0x000fe200078e0200ULL, 0x0000000704047812ULL, 0x000fe200078ec0ffULL,
0x000000201b0e7824ULL, 0x000fc600078e020eULL, 0x0000000007087984ULL, 0x002e620000000c00ULL,
0x0000000811117824ULL, 0x000fe200078e0204ULL, 0x000000050e037c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff0e7a19ULL, 0x000fc6000001160eULL, 0x0000000118037824ULL, 0x000fc800078e0203ULL,
0x0000006f0e037224ULL, 0x000fca00078e0203ULL, 0x0000000306037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff007224ULL, 0x000fe200000e06ffULL, 0x00005c0003027a11ULL, 0x000fc800078040ffULL,
0x00005d0003037a11ULL, 0x000fca00000f4400ULL, 0x0000001011027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006a00ff607624ULL, 0x000fe400078e00ffULL, 0x00006b00ff617624ULL, 0x000fca00078e00ffULL,
0x0000000860607981ULL, 0x000522000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0200780cULL, 0x000fe20003f04070ULL, 0x000000020e097824ULL, 0x000fe200078e00ffULL,
0x01a60000ff047f8cULL, 0x000ee2000c80043fULL, 0x000000401a077824ULL, 0x000fe400078e00ffULL,
0x0000590009027a24ULL, 0x000fc800078e0212ULL, 0x0000660002067a24ULL, 0x002fc800078e0207ULL,
0x00000c7000000947ULL, 0x000fea0003800000ULL, 0x00000003ff337819ULL, 0x000fe40000011617ULL,
0x0000000716087217ULL, 0x000fe40007800000ULL, 0x00000004330d7810ULL, 0x040fe40007ffe0ffULL,
0x00000008330f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000108147824ULL, 0x000fe200078e0a07ULL,
0x0000000c33117810ULL, 0x000fe20007ffe0ffULL, 0x000000010d097824ULL, 0x000fe200078e0217ULL,
0x0000001433217810ULL, 0x000fe20007ffe0ffULL, 0x000000080d247824ULL, 0x040fe200078e00ffULL,
0x000000140d00720cULL, 0x000fe20003fa6070ULL, 0x0000000106087824ULL, 0x000fe200078e0233ULL,
0x0000001833237810ULL, 0x000fe20007ffe0ffULL, 0x000000010f0b7824ULL, 0x040fe200078e0217ULL,
0xfffffff824247812ULL, 0x000fe200078ee209ULL, 0x000000080f267824ULL, 0x000fe200078e00ffULL,
0x0000001c33277810ULL, 0x040fe20007ffe0ffULL, 0x00000001060a7824ULL, 0x000fe200078e020dULL,
0x00000010330d7810ULL, 0x000fe20007ffe0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fc400078ee20bULL, 0x000000141100720cULL, 0x080fe20003f46070ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000007008127812ULL, 0x000fe400078ef803ULL,
0x0000002033297810ULL, 0x000fe20007ffe0ffULL, 0x000000010d087824ULL, 0x040fe200078e0217ULL,
0x000000700a187812ULL, 0x000fe200078ef803ULL, 0x000000080d197824ULL, 0x000fe200078e00ffULL,
0x0000620012127a10ULL, 0x000fe20007f1e0ffULL, 0x00000001110c7824ULL, 0x040fe200078e0217ULL,
0x0000620018187a10ULL, 0x000fe20007f3e0ffULL, 0x0000000811137824ULL, 0x000fe200078e00ffULL,
0xfffffff8192a7812ULL, 0x000fe200078ee208ULL, 0x0000000106087824ULL, 0x040fe200078e020fULL,
0x000063000b197a10ULL, 0x000fe20000ffe4ffULL, 0x00000001060a7824ULL, 0x040fe200078e0211ULL,
0xfffffff813287812ULL, 0x000fe200078ee20cULL, 0x00000001060e7824ULL, 0x000fe200078e0221ULL,
0x0000630009137a10ULL, 0x000fe200007fe4ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000140d00720cULL, 0x000fc40003f06070ULL, 0x000000140f00720cULL, 0x000fe20003f26070ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x00000070081c7812ULL, 0x000fe400078ef803ULL,
0x000020001a1b7811ULL, 0x000fe200078e70ffULL, 0x00000001060d7824ULL, 0x000fe200078e020dULL,
0x000000700a1e7812ULL, 0x000fe200078ef803ULL, 0x0000000106107824ULL, 0x000fe200078e0223ULL,
0x000062001c1c7a10ULL, 0x000fe20007f7e0ffULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x000062001e1e7a10ULL, 0x000fc40007f9e0ffULL, 0x00006300091d7a10ULL, 0x000fe20001ffe4ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x100fe400078ef803ULL,
0x000063000b1f7a10ULL, 0x000fe200027fe4ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fe400078ef803ULL, 0x000062000c0c7a10ULL, 0x000fe20007f7e0ffULL,
0x0000000106087824ULL, 0x000fe200078e0227ULL, 0x0000007010107812ULL, 0x000fe200078ef803ULL,
0x00000001330a7824ULL, 0x000fe200078e0217ULL, 0x000062000e0e7a10ULL, 0x000fe20007f9e0ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000620010107a10ULL, 0x000fc40007fde0ffULL,
0x000063000d0d7a10ULL, 0x000fe40001ffe4ffULL, 0x000063000f0f7a10ULL, 0x000fe400027fe4ffULL,
0x000000070a0a7812ULL, 0x000fe400078ec0ffULL, 0x0000007008207812ULL, 0x000fe200078ef803ULL,
0x0000000121087824ULL, 0x000fe200078e0217ULL, 0x000000143300720cULL, 0x080fe40003f86070ULL,
0x000000142100720cULL, 0x040fe20003f66070ULL, 0x0000000821217824ULL, 0x000fe200078e00ffULL,
0x0000630011117a10ULL, 0x000fc400037fe4ffULL, 0x0ffffff80a227812ULL, 0x000fe200078ef817ULL,
0x00000001060a7824ULL, 0x000fe200078e0229ULL, 0x0000620020207a10ULL, 0x000fe40007fde0ffULL,
0xfffffff8212c7812ULL, 0x000fe200078ee208ULL, 0x0000001022257824ULL, 0x000fe200078e021bULL,
0x0000630009217a10ULL, 0x000fe200037fe4ffULL, 0x000000800a087825ULL, 0x000fe200078e00ffULL,
0x00000024332b7810ULL, 0x040fe40007ffe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012257faeULL, 0x0003e2000e101c48ULL, 0x00000028332d7810ULL, 0x000fc40007ffe0ffULL,
0x00000001060a7824ULL, 0x000fe200078e022bULL, 0x0000007008227812ULL, 0x000fe200078ef803ULL,
0x0000000123087824ULL, 0x040fe200078e0217ULL, 0x000000142300720cULL, 0x040fe20003f86070ULL,
0x0000000823237824ULL, 0x000fe200078e00ffULL, 0x0000620022227a10ULL, 0x000fe20007fde0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000003833317810ULL, 0x000fe40007ffe0ffULL,
0xfffffff8232e7812ULL, 0x000fe200078ee208ULL, 0x00000001062f7824ULL, 0x000fe200078e022dULL,
0x0000630009237a10ULL, 0x000fe200037fe4ffULL, 0x0000001024257824ULL, 0x002fe200078e021bULL,
0x000000700a0a7812ULL, 0x000fe200078ef803ULL, 0x000000802f087825ULL, 0x000fe200078e00ffULL,
0x0000002c332f7810ULL, 0x000fc40007ffe0ffULL, 0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL,
0x0000000127137824ULL, 0x040fe200078e0217ULL, 0x0000007008127812ULL, 0x000fe200078ef803ULL,
0x0000000827247824ULL, 0x000fe200078e00ffULL, 0x000063000b0b7a10ULL, 0x000fe200037fe4ffULL,
0x0000000018257faeULL, 0x0003e2000e901c48ULL, 0x0000620012127a10ULL, 0x000fe20007fde0ffULL,
0x0000000106087824ULL, 0x000fe200078e022fULL, 0x000000142700720cULL, 0x080fe20003fa6070ULL,
0x0000001026277824ULL, 0x000fe200078e021bULL, 0xfffffff824247812ULL, 0x000fe200078ee213ULL,
0x000000012b267824ULL, 0x000fe200078e0217ULL, 0x0000630009137a10ULL, 0x000fe200037fe4ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000000001c277faeULL, 0x0005e2000c901c48ULL,
0x000000142900720cULL, 0x000fc40003f26070ULL, 0x0000001028257824ULL, 0x002fe200078e021bULL,
0x0000007008187812ULL, 0x000fe200078ef803ULL, 0x0000000129197824ULL, 0x040fe400078e0217ULL,
0x0000000829287824ULL, 0x000fe200078e00ffULL, 0x000000001e257faeULL, 0x0003e2000d101c48ULL,
0x000000142b00720cULL, 0x040fe20003f46070ULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0x0000620018187a10ULL, 0x000fe20007fde0ffULL, 0x000000102a1d7824ULL, 0x004fe200078e021bULL,
0xfffffff828087812ULL, 0x000fc400078ee219ULL, 0xfffffff82b267812ULL, 0x000fe400078ee226ULL,
0x00000030332b7810ULL, 0x000fe20007ffe0ffULL, 0x0000001008277824ULL, 0x100fe200078e021bULL,
0x0000630009197a10ULL, 0x000fe200037fe4ffULL, 0x000000102c097824ULL, 0x000fe200078e021bULL,
0x000000000c1d7faeULL, 0x0005e2000c101c48ULL, 0x0000000106087824ULL, 0x000fe400078e022bULL,
0x000000102e1f7824ULL, 0x102fe200078e021bULL, 0x000000000e097faeULL, 0x0003e2000d901c48ULL,
0x0000001024257824ULL, 0x100fe200078e021bULL, 0x000000142b00720cULL, 0x080fe20003f66070ULL,
0x0000001026297824ULL, 0x000fe200078e021bULL, 0x00000000101f7faeULL, 0x0007e2000e101c48ULL,
0x000000142f00720cULL, 0x080fe20003f86070ULL, 0x000000082b1c7824ULL, 0x000fe200078e00ffULL,
0x00000034331d7810ULL, 0x004fe20007ffe0ffULL, 0x0000000020257faeULL, 0x0005e2000e901c48ULL,
0x000000012d0d7824ULL, 0x000fe200078e0217ULL, 0x0000003c33337810ULL, 0x000fe20007ffe0ffULL,
0x0000008008087825ULL, 0x002fe200078e00ffULL, 0x0000000022277faeULL, 0x0003e2000c901c48ULL,
0x000000142d00720cULL, 0x000fc40003fa6070ULL, 0x00000001060e7824ULL, 0x000fe200078e021dULL,
0x00000070080c7812ULL, 0x000fe200078ef803ULL, 0x000000082d107824ULL, 0x008fe200078e00ffULL,
0x000000000a297faeULL, 0x0007e2000d101c48ULL, 0x000000012f087824ULL, 0x040fe200078e0217ULL,
0x000062000c0c7a10ULL, 0x000fe20007fde0ffULL, 0x000000082f2f7824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee20dULL, 0x000000011d117824ULL, 0x100fe200078e0217ULL,
0x00006300090d7a10ULL, 0x000fe200037fe4ffULL, 0x000000012b097824ULL, 0x100fe200078e0217ULL,
0x000000141d00720cULL, 0x0c0fe20003f46070ULL, 0x000000081d1e7824ULL, 0x000fe200078e00ffULL,
0x000000143100720cULL, 0x0c0fe20003f26070ULL, 0x00000001311d7824ULL, 0x000fe200078e0217ULL,
0x000000143300720cULL, 0x000fe20003f06070ULL, 0x000000800e0a7825ULL, 0x008fe200078e00ffULL,
0xfffffff82f147812ULL, 0x000fc400078ee208ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL,
0x0000000831207824ULL, 0x004fe200078e00ffULL, 0x000000700a0e7812ULL, 0x000fe200078ef803ULL,
0x00000001060a7824ULL, 0x000fe400078e0231ULL, 0x0000000133177824ULL, 0x000fe200078e0217ULL,
0x000062000e0e7a10ULL, 0x000fe20007fde0ffULL, 0x000000800a087825ULL, 0x000fc600078e00ffULL,
0x000063000b0f7a10ULL, 0x000fe200037fe4ffULL, 0x00000001060a7824ULL, 0x000fe200078e0233ULL,
0x0000007008087812ULL, 0x000fe200078ef803ULL, 0x0000000833227824ULL, 0x002fe200078e00ffULL,
0xfffffff81e067812ULL, 0x000fe200078ee211ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000620008087a10ULL, 0x000fe40007fde0ffULL, 0xfffffff8201e7812ULL, 0x000fe200078ee21dULL,
0x0000001014117824ULL, 0x000fe200078e021bULL, 0x000000700a0a7812ULL, 0x000fe200078ef803ULL,
0x0000001010037824ULL, 0x000fe200078e021bULL, 0xfffffff822207812ULL, 0x000fe200078ee217ULL,
0x000000101c177824ULL, 0x100fe200078e021bULL, 0x0000630009097a10ULL, 0x000fe200037fe4ffULL,
0x00000010061d7824ULL, 0x100fe200078e021bULL, 0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL,
0x000000101e1f7824ULL, 0x100fe200078e021bULL, 0x0000000012037faeULL, 0x0003e2000e901c48ULL,
0x00000010201b7824ULL, 0x000fe200078e021bULL, 0x000063000b0b7a10ULL, 0x000fc400037fe4ffULL,
0x0000000018117faeULL, 0x0003e8000e101c48ULL, 0x000000000c177faeULL, 0x0003e8000d901c48ULL,
0x000000000e1d7faeULL, 0x0003e8000d101c48ULL, 0x00000000081f7faeULL, 0x0003e8000c901c48ULL,
0x000000000a1b7faeULL, 0x0003e2000c101c48ULL, 0x00000b3000007947ULL, 0x000fea0003800000ULL,
0x00000004170b7811ULL, 0x040fe400078fe8ffULL, 0x00000008170c7811ULL, 0x000fc400078fe8ffULL,
0x0000000c170d7811ULL, 0x000fe200078fe8ffULL, 0x000000010b087824ULL, 0x100fe200078e0217ULL,
0x0000001c171f7811ULL, 0x000fe200078fe8ffULL, 0x000000080b0f7824ULL, 0x000fe200078e00ffULL,
0x0000001417187811ULL, 0x040fe200078fe8ffULL, 0x000000010c097824ULL, 0x140fe200078e0217ULL,
0x0000001017127811ULL, 0x000fe200078fe8ffULL, 0x000000080c107824ULL, 0x000fe200078e00ffULL,
0xfffffff80f0e7812ULL, 0x000fe200078ee208ULL, 0x000000010d0a7824ULL, 0x000fe200078e0217ULL,
0x00000018171b7811ULL, 0x000fe200078fe8ffULL, 0x000000080d117824ULL, 0x000fe200078e00ffULL,
0xfffffff8100f7812ULL, 0x000fe200078ee209ULL, 0x000000011f107824ULL, 0x100fe200078e0217ULL,
0x0000002417247811ULL, 0x000fe200078fe8ffULL, 0x000000081f217824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee20aULL, 0x0000000118097824ULL, 0x140fe200078e0217ULL,
0x0000002817287811ULL, 0x000fe200078fe8ffULL, 0x0000000818147824ULL, 0x000fe200078e00ffULL,
0xfffffff821207812ULL, 0x000fe200078ee210ULL, 0x0000000112087824ULL, 0x040fe200078e0217ULL,
0x0000002017217811ULL, 0x000fe200078fe8ffULL, 0x0000000812137824ULL, 0x000fe200078e00ffULL,
0xfffffff814197812ULL, 0x000fe200078ee209ULL, 0x000000011b0a7824ULL, 0x100fe200078e0217ULL,
0x0000002c172a7811ULL, 0x000fe200078fe8ffULL, 0x000000081b1d7824ULL, 0x000fe200078e00ffULL,
0xfffffff813137812ULL, 0x000fe200078ee208ULL, 0x0000000124097824ULL, 0x140fe200078e0217ULL,
0x00000030172c7811ULL, 0x000fe200078fe8ffULL, 0x0000000824147824ULL, 0x000fe200078e00ffULL,
0xfffffff81d1c7812ULL, 0x000fe200078ee20aULL, 0x0000000121087824ULL, 0x000fe200078e0217ULL,
0x00000034172d7811ULL, 0x000fe200078fe8ffULL, 0x00000008211d7824ULL, 0x000fe200078e00ffULL,
0xfffffff814257812ULL, 0x000fe200078ee209ULL, 0x00000001280a7824ULL, 0x140fe200078e0217ULL,
0x0000001717097211ULL, 0x000fe200078fe8ffULL, 0x0000000828297824ULL, 0x000fe200078e00ffULL,
0xfffffff81d227812ULL, 0x000fe200078ee208ULL, 0x000000012a107824ULL, 0x040fe200078e0217ULL,
0x00000038172f7811ULL, 0x040fe200078fe8ffULL, 0x000000082a2b7824ULL, 0x000fe200078e00ffULL,
0x0000003c17317811ULL, 0x000fe200078fe8ffULL, 0x0000000106147824ULL, 0x040fe200078e0212ULL,
0xfffffff829297812ULL, 0x000fe200078ee20aULL, 0x0000000106237824ULL, 0x040fe200078e021fULL,
0x0000000617087211ULL, 0x000fe200078fe8ffULL, 0x00000001060b7824ULL, 0x040fe200078e020bULL,
0x00000007090a7812ULL, 0x000fe200078ec0ffULL, 0x00000001060c7824ULL, 0x040fe200078e020cULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee210ULL, 0x0000000106107824ULL, 0x000fc400078e020dULL,
0x00000001061d7824ULL, 0x040fe400078e0218ULL, 0x00000001061e7824ULL, 0x040fe400078e021bULL,
0x0000000106267824ULL, 0x040fe400078e0221ULL, 0x0000000106277824ULL, 0x040fe400078e0224ULL,
0x0000000106287824ULL, 0x040fe400078e0228ULL, 0x00000001062a7824ULL, 0x000fc400078e022aULL,
0x00000001062e7824ULL, 0x040fe400078e022cULL, 0x0000000106307824ULL, 0x040fe400078e022dULL,
0x000000012d127824ULL, 0x040fe400078e0217ULL, 0x000000082d1f7824ULL, 0x000fe400078e00ffULL,
0x0000000106327824ULL, 0x040fe400078e022fULL, 0x0000000106347824ULL, 0x000fe200078e0231ULL,
0x0ffffff80a067812ULL, 0x100fe200078ef817ULL, 0x000000012c0d7824ULL, 0x100fe200078e0217ULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee212ULL, 0x000000012f1b7824ULL, 0x000fc400078e0217ULL,
0x000000082f247824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff824217812ULL, 0x000fe200078ee21bULL, 0x000000082c187824ULL, 0x000fe200078e00ffULL,
0x0000007008127812ULL, 0x000fe200078ef803ULL, 0x0000000131177824ULL, 0x040fe200078e0217ULL,
0x000020001a087811ULL, 0x000fe200078e70ffULL, 0x00000008310a7824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee20dULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000620012127a10ULL, 0x000fe40007f1e0ffULL, 0xfffffff80a247812ULL, 0x000fe200078ee217ULL,
0x000000800b0a7825ULL, 0x000fc800078e00ffULL, 0x0000001018437824ULL, 0x100fe200078e0208ULL,
0x000000700a187812ULL, 0x000fe200078ef803ULL, 0x0000001013337824ULL, 0x100fe200078e0208ULL,
0x0000630009137a10ULL, 0x000fe200007fe4ffULL, 0x0000001006177824ULL, 0x100fe200078e0208ULL,
0x0000620018187a10ULL, 0x000fe20007f3e0ffULL, 0x000000100e1b7824ULL, 0x100fe400078e0208ULL,
0x000000100f2f7824ULL, 0x100fe200078e0208ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012177faeULL, 0x0003e2000b901c48ULL, 0x0000001011317824ULL, 0x000fc400078e0208ULL,
0x0000001019357824ULL, 0x100fe200078e0208ULL, 0x000063000b197a10ULL, 0x000fe20000ffe4ffULL,
0x000000101c377824ULL, 0x100fe200078e0208ULL, 0x000000700c1c7812ULL, 0x000fe200078ef803ULL,
0x0000001020397824ULL, 0x100fe400078e0208ULL, 0x00000010223b7824ULL, 0x100fe200078e0208ULL,
0x000062001c1c7a10ULL, 0x000fe20007f1e0ffULL, 0x00000010253d7824ULL, 0x100fe200078e0208ULL,
0x00000000181b7faeULL, 0x0003e2000b901c48ULL, 0x00000010293f7824ULL, 0x000fc400078e0208ULL,
0x000000102b417824ULL, 0x100fe400078e0208ULL, 0x000000101f457824ULL, 0x100fe400078e0208ULL,
0x0000001021477824ULL, 0x100fe400078e0208ULL, 0x0000001024497824ULL, 0x000fe400078e0208ULL,
0x0000008010087825ULL, 0x000fc800078e00ffULL, 0x00000080140a7825ULL, 0x000fe200078e00ffULL,
0x00000070081f7812ULL, 0x000fc600078ef803ULL, 0x000000801d0e7825ULL, 0x000fe200078e00ffULL,
0x000063000d1d7a10ULL, 0x000fe400007fe4ffULL, 0x000000700a207812ULL, 0x100fe200078ef803ULL,
0x000000801e107825ULL, 0x000fe200078e00ffULL, 0x000062001f1e7a10ULL, 0x000fe20007f1e0ffULL,
0x000000001c2f7faeULL, 0x0003e2000b901c48ULL, 0x000000700e227812ULL, 0x100fe200078ef803ULL,
0x00000080270c7825ULL, 0x000fe200078e00ffULL, 0x0000620020207a10ULL, 0x000fe40007f3e0ffULL,
0x00006300091f7a10ULL, 0x000fe200007fe4ffULL, 0x0000008023087825ULL, 0x000fe200078e00ffULL,
0x0000007010247812ULL, 0x000fc400078ef803ULL, 0x0000620022227a10ULL, 0x000fe20007f1e0ffULL,
0x000000001e317faeULL, 0x0003e2000b901c48ULL, 0x000063000b217a10ULL, 0x000fe20000ffe4ffULL,
0x00000080260a7825ULL, 0x000fe200078e00ffULL, 0x0000620024247a10ULL, 0x000fe40007f5e0ffULL,
0x000063000f237a10ULL, 0x000fe200007fe4ffULL, 0x00000080280e7825ULL, 0x000fe200078e00ffULL,
0x0000007008267812ULL, 0x100fe200078ef803ULL, 0x0000000020337faeULL, 0x0003e2000b901c48ULL,
0x0000630011257a10ULL, 0x000fe200017fe4ffULL, 0x000000802a107825ULL, 0x000fe200078e00ffULL,
0x000000700a287812ULL, 0x000fe200078ef803ULL, 0x0000000022357faeULL, 0x0003e2000b901c48ULL,
0x0000620026267a10ULL, 0x000fc40007f1e0ffULL, 0x000000700c2a7812ULL, 0x100fe200078ef803ULL,
0x0000000024377faeULL, 0x0003e2000b901c48ULL, 0x000000700e2c7812ULL, 0x100fe400078ef803ULL,
0x0000620028287a10ULL, 0x000fe40007f3e0ffULL, 0x0000630009277a10ULL, 0x000fe200007fe4ffULL,
0x000000802e087825ULL, 0x000fe200078e00ffULL, 0x000062002a2a7a10ULL, 0x000fe40007f1e0ffULL,
0x000062002c2c7a10ULL, 0x000fe20007f5e0ffULL, 0x0000000026397faeULL, 0x0003e2000b901c48ULL,
0x000063000b297a10ULL, 0x000fe20000ffe4ffULL, 0x00000080300a7825ULL, 0x000fe200078e00ffULL,
0x0000007010107812ULL, 0x000fc400078ef803ULL, 0x000063000d2b7a10ULL, 0x000fe200007fe4ffULL,
0x00000080320c7825ULL, 0x000fe200078e00ffULL, 0x000063000f2d7a10ULL, 0x000fe200017fe4ffULL,
0x00000000283b7faeULL, 0x0003e2000b901c48ULL, 0x0000620010107a10ULL, 0x000fe20007f1e0ffULL,
0x00000080340e7825ULL, 0x000fe200078e00ffULL, 0x0000007008087812ULL, 0x100fe200078ef803ULL,
0x000000002a3d7faeULL, 0x0003e2000b901c48ULL, 0x000000700a0a7812ULL, 0x100fe400078ef803ULL,
0x000000700c0c7812ULL, 0x000fe200078ef803ULL, 0x000000002c3f7faeULL, 0x0003e2000b901c48ULL,
0x0000630011117a10ULL, 0x000fc400007fe4ffULL, 0x000000700e037812ULL, 0x000fe400078ef803ULL,
0x0000620008087a10ULL, 0x000fe20007f1e0ffULL, 0x0000000010417faeULL, 0x0003e2000b901c48ULL,
0x000062000a0a7a10ULL, 0x000fe40007f3e0ffULL, 0x000062000c0c7a10ULL, 0x000fe40007f5e0ffULL,
0x00006200030e7a10ULL, 0x000fe40007f7e0ffULL, 0x0000630009097a10ULL, 0x000fc400007fe4ffULL,
0x000063000b0b7a10ULL, 0x000fe40000ffe4ffULL, 0x000063000d0d7a10ULL, 0x000fe200017fe4ffULL,
0x0000000008437faeULL, 0x0003e2000b901c48ULL, 0x000063000f0f7a10ULL, 0x000fc60001ffe4ffULL,
0x000000000a457faeULL, 0x0003e8000b901c48ULL, 0x000000000c477faeULL, 0x0003e8000b901c48ULL,
0x000000000e497faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fc40000015200ULL, 0x01a60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x00afc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a08067210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0a7824ULL, 0x000fe200000e0e09ULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc8000001140aULL, 0x0000000603037211ULL, 0x000fca00078110ffULL,
0x000000ffff067224ULL, 0x000fca00000e060aULL, 0x0000000203037819ULL, 0x000fc80000001206ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x000000201a037824ULL, 0x002fca00078e0203ULL, 0x00000004ff047819ULL, 0x000fe40000011603ULL,
0x0000000103057810ULL, 0x040fe40007ffe0ffULL, 0x0ffffffe04067812ULL, 0x000fe400078ec0ffULL,
0x0000001f03047812ULL, 0x000fc600078ec0ffULL, 0x0000000106097824ULL, 0x040fe400078e0205ULL,
0x0000000103087824ULL, 0x000fe200078e0206ULL, 0x0000000806067810ULL, 0x000fe20007ffe0ffULL,
0x00000010040a7824ULL, 0x040fe200078e00ffULL, 0x0000000f09097812ULL, 0x000fe200078ec0ffULL,
0x00000010040b7824ULL, 0x000fe200078e00ffULL, 0x0000000f08087812ULL, 0x000fe200078ec0ffULL,
0x0000000105057824ULL, 0x100fe200078e0206ULL, 0x000001f00a097812ULL, 0x000fe200078ee209ULL,
0x0000000103037824ULL, 0x000fe200078e0206ULL, 0x000001f00b087812ULL, 0x000fe200078ee208ULL,
0x0000001004067824ULL, 0x040fe200078e00ffULL, 0x0000000f05057812ULL, 0x000fe200078ec0ffULL,
0x00000000090c7984ULL, 0x000e62000000cc00ULL, 0x0000001004047824ULL, 0x000fe200078e00ffULL,
0x0000000f03037812ULL, 0x000fc400078ec0ffULL, 0x0000000008107984ULL, 0x000ee4000000cc00ULL,
0x000001f004057812ULL, 0x000fe400078ee205ULL, 0x000001f006037812ULL, 0x000fe200078ee203ULL,
0x000000ffff1e7224ULL, 0x002fe400078e000cULL, 0x000000ffff1f7224ULL, 0x000fe400078e000eULL,
0x000000ffff1c7224ULL, 0x008fe400078e0010ULL, 0x000000ffff1d7224ULL, 0x000fc400078e0012ULL,
0x000000ffff227224ULL, 0x000fe400078e000dULL, 0x000000ffff237224ULL, 0x000fe200078e000fULL,
0x0000001c08007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff207224ULL, 0x000fe400078e0011ULL,
0x000000ffff217224ULL, 0x000fca00078e0013ULL, 0x0000002009007388ULL, 0x000fe8000000cc00ULL,
0x00000000050c7984ULL, 0x000e68000000cc00ULL, 0x0000000003107984ULL, 0x000ee2000000cc00ULL,
0x000000ffff277224ULL, 0x002fe400078e000eULL, 0x000000ffff267224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff247224ULL, 0x008fe400078e0010ULL,
0x000000ffff257224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000002403007388ULL, 0x0003e8000000cc00ULL,
0x0000000c05007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a60000ff0a7f8cULL, 0x000ee2000c80043fULL, 0x000000ffff0c7224ULL, 0x002fc600078e00ffULL,
0x0000000000047805ULL, 0x000fc80000015200ULL, 0x01a60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x00afc4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000804067210ULL, 0x000fca0007f1e1ffULL,
0x0000000109087824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011408ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0608ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff1500720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0x0000001fff047424ULL, 0x000fe200078e00ffULL,
0x8000580016197a10ULL, 0x000fe20007ffe0ffULL, 0x00000001ff5c7424ULL, 0x000fe200078e00ffULL,
0x0000010007147810ULL, 0x000fe20007ffe0ffULL, 0x00005800ff1b7624ULL, 0x000fe200078e00ffULL,
0x0000580004047a10ULL, 0x000fe20007ffe0ffULL, 0x3db504f360607820ULL, 0x010fe20000410000ULL,
0x0001a6881a5f7811ULL, 0x040fe200078e18ffULL, 0x000000ffff5e7224ULL, 0x000fe200078e00ffULL,
0x00000004ff047819ULL, 0x000fe20000011604ULL, 0x000000ffff637224ULL, 0x000fe200078e00ffULL,
0x0001a6081a5d7811ULL, 0x000fc400078e28ffULL, 0x000058005c5c7a10ULL, 0x000fe40007ffe1ffULL,
0x000000091b1b7810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff197819ULL, 0x000fe40000011619ULL,
0x0ffffffe04187812ULL, 0x000fc400078ec0ffULL, 0x000000025e047810ULL, 0x048fe20007ffe0ffULL,
0x000001005e617824ULL, 0x004fe200078e0214ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000000163177812ULL, 0x000fe400078e0cffULL, 0x000000150400720cULL, 0x000fe20003f06070ULL,
0x0000660002047a24ULL, 0x000fd800078e0261ULL, 0x00000ca000008947ULL, 0x000fea0003800000ULL,
0x00000003ff267819ULL, 0x002fe20000011603ULL, 0x0000001003077824ULL, 0x000fe200078e00ffULL,
0x0000006116067217ULL, 0x000fe20007800000ULL, 0x000000021a247824ULL, 0x000fe200078e0217ULL,
0x0000000426087810ULL, 0x040fe40007ffe0ffULL, 0x00000008260a7810ULL, 0x000fe40007ffe0ffULL,
0x00000070072b7812ULL, 0x000fe200078ec0ffULL, 0x0000000108057824ULL, 0x100fe200078e0203ULL,
0x00000010260e7810ULL, 0x000fe20007ffe0ffULL, 0x00000008080c7824ULL, 0x000fe200078e00ffULL,
0x0000001426227810ULL, 0x000fe20007ffe0ffULL, 0x000000010a097824ULL, 0x000fe200078e0203ULL,
0x0000001826287810ULL, 0x000fe20007ffe0ffULL, 0x000000080e2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c237812ULL, 0x000fe200078ee205ULL, 0x0000000106057824ULL, 0x000fe200078e0a61ULL,
0x0000001c262c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000126067824ULL, 0x140fe200078e0204ULL,
0x00000020262e7810ULL, 0x000fe20007ffe0ffULL, 0x000000080a0c7824ULL, 0x000fe200078e00ffULL,
0x000000050800720cULL, 0x040fe20003fa6070ULL, 0x0000000108087824ULL, 0x000fe200078e0204ULL,
0x0000002426307810ULL, 0x000fe20007ffe0ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0xfffffff80c277812ULL, 0x000fc400078ee209ULL, 0x0000000c260c7810ULL, 0x000fe20007ffe0ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000002b06107212ULL, 0x000fe400078efcffULL,
0x000000050c00720cULL, 0x000fe20003f46070ULL, 0x000000010e067824ULL, 0x100fe200078e0203ULL,
0x0000002b08127212ULL, 0x000fe200078efcffULL, 0x000000010c0b7824ULL, 0x000fe200078e0203ULL,
0x0000620010107a10ULL, 0x000fe20007f1e0ffULL, 0x000000080c1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee206ULL, 0x000000010a067824ULL, 0x100fe200078e0204ULL,
0x0000620012127a10ULL, 0x000fe20007f3e0ffULL, 0x000000010c087824ULL, 0x000fe200078e0204ULL,
0x0000630007117a10ULL, 0x000fe200007fe4ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000630009137a10ULL, 0x000fc40000ffe4ffULL, 0x000000050a00720cULL, 0x000fe20003f26070ULL,
0x000000010e0a7824ULL, 0x100fe200078e0204ULL, 0xfffffff81c297812ULL, 0x000fe200078ee20bULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000002b061c7212ULL, 0x000fe400078efcffULL,
0x000000050e00720cULL, 0x000fe20003f06070ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000062001c1c7a10ULL, 0x000fe40007f7e0ffULL, 0x0000002b081e7212ULL, 0x080fe200078efcffULL,
0x00000001220c7824ULL, 0x100fe200078e0204ULL, 0x0000002b0a0a7212ULL, 0x000fe200078efcffULL,
0x00000001280e7824ULL, 0x100fe200078e0204ULL, 0x00006300071d7a10ULL, 0x000fe20001ffe4ffULL,
0x000000012c067824ULL, 0x000fe200078e0204ULL, 0x000062001e1e7a10ULL, 0x000fe20007f9e0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000062000a0a7a10ULL, 0x000fc40007f7e0ffULL,
0x00006300091f7a10ULL, 0x000fe200027fe4ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000002b0c0c7212ULL, 0x080fe400078efcffULL, 0x000063000b0b7a10ULL, 0x000fe20001ffe4ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000002b0e0e7212ULL, 0x080fe400078efcffULL,
0x000062000c0c7a10ULL, 0x000fe20007f7e0ffULL, 0x0000000126087824ULL, 0x100fe200078e0203ULL,
0x0000002b06207212ULL, 0x000fe200078efcffULL, 0x000000012e067824ULL, 0x000fe200078e0204ULL,
0x000062000e0e7a10ULL, 0x000fe20007f9e0ffULL, 0x0000000122097824ULL, 0x100fe200078e0203ULL,
0x0000620020207a10ULL, 0x000fe20007fde0ffULL, 0x00000001282a7824ULL, 0x040fe200078e0203ULL,
0x000063000d0d7a10ULL, 0x000fe20001ffe4ffULL, 0x0000000828317824ULL, 0x000fe200078e00ffULL,
0x000063000f0f7a10ULL, 0x000fc400027fe4ffULL, 0x0000000708087812ULL, 0x000fe400078ec0ffULL,
0x000000052600720cULL, 0x080fe40003f86070ULL, 0x000000052200720cULL, 0x040fe20003f66070ULL,
0x0000000822227824ULL, 0x000fe200078e00ffULL, 0x0000630007217a10ULL, 0x000fe200037fe4ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000200024247811ULL, 0x000fe400078e68ffULL,
0x0ffffff808257812ULL, 0x000fe200078ef803ULL, 0x0000000130087824ULL, 0x000fe200078e0204ULL,
0xfffffff8222f7812ULL, 0x000fe200078ee209ULL, 0x0000001027277824ULL, 0x100fe200078e0224ULL,
0x0000002826327810ULL, 0x000fe20007ffe0ffULL, 0x0000001025257824ULL, 0x000fe200078e0224ULL,
0x0000002b06227212ULL, 0x000fe200078efcffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0xfffffff831317812ULL, 0x000fc400078ee22aULL, 0x0000620022227a10ULL, 0x000fe20007fde0ffULL,
0x0000000132067824ULL, 0x000fe200078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010257faeULL, 0x0003e2000e101c48ULL, 0x0000002b08087212ULL, 0x000fe400078efcffULL,
0x000000052800720cULL, 0x000fe40003f86070ULL, 0x0000002c26287810ULL, 0x040fe40007ffe0ffULL,
0x00000038262a7810ULL, 0x000fe20007ffe0ffULL, 0x0000001023257824ULL, 0x002fe200078e0224ULL,
0x0000630007237a10ULL, 0x000fe200037fe4ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000620008087a10ULL, 0x000fc40007fde0ffULL, 0x0000000012257faeULL, 0x0003e2000e901c48ULL,
0x000000052c00720cULL, 0x040fe20003fa6070ULL, 0x000000012c117824ULL, 0x000fe200078e0203ULL,
0x0000002b06107212ULL, 0x000fe200078efcffULL, 0x000000082c2c7824ULL, 0x000fe200078e00ffULL,
0x0000630009097a10ULL, 0x000fe200037fe4ffULL, 0x0000000128067824ULL, 0x000fe200078e0204ULL,
0x0000620010107a10ULL, 0x000fe20007fde0ffULL, 0x000000001c277faeULL, 0x0005e2000c901c48ULL,
0xfffffff82c337812ULL, 0x000fe400078ee211ULL, 0x0000630007117a10ULL, 0x000fe200037fe4ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x000000052e00720cULL, 0x000fc60003f26070ULL,
0x000000012e137824ULL, 0x102fe200078e0203ULL, 0x0000002b06127212ULL, 0x000fe200078efcffULL,
0x000000082e2e7824ULL, 0x000fe400078e00ffULL, 0x0000001029257824ULL, 0x100fe200078e0224ULL,
0x0000620012127a10ULL, 0x000fe20007fde0ffULL, 0x0000000130067824ULL, 0x000fe200078e0203ULL,
0x00000030261c7810ULL, 0x004fe20007ffe0ffULL, 0x0000000830297824ULL, 0x000fe200078e00ffULL,
0xfffffff82e277812ULL, 0x000fe200078ee213ULL, 0x000000102d1d7824ULL, 0x100fe200078e0224ULL,
0x0000630007137a10ULL, 0x000fe200037fe4ffULL, 0x000000102f077824ULL, 0x000fe200078e0224ULL,
0xfffffff829297812ULL, 0x000fe200078ee206ULL, 0x000000011c067824ULL, 0x000fe200078e0204ULL,
0x000000001e257faeULL, 0x0003e2000d101c48ULL, 0x000000053000720cULL, 0x000fe20003f46070ULL,
0x0000001027277824ULL, 0x000fc400078e0224ULL, 0x000000000a1d7faeULL, 0x0005e2000c101c48ULL,
0x0000001029297824ULL, 0x000fc600078e0224ULL, 0x000000000c077faeULL, 0x0007e2000d901c48ULL,
0x000000051c00720cULL, 0x080fe20003f66070ULL, 0x00000010311f7824ULL, 0x102fe200078e0224ULL,
0x00000034261e7810ULL, 0x040fe20007ffe0ffULL, 0x0000001033257824ULL, 0x000fe200078e0224ULL,
0x0000003c26267810ULL, 0x000fe40007ffe0ffULL, 0x000000000e1f7faeULL, 0x0003e2000e101c48ULL,
0x000000011e0b7824ULL, 0x004fe200078e0204ULL, 0x000000052800720cULL, 0x080fe20003f86070ULL,
0x0000008006067825ULL, 0x008fe200078e00ffULL, 0x0000000020257faeULL, 0x0005e2000e901c48ULL,
0x000000053200720cULL, 0x000fc40003fa6070ULL, 0x000000052600720cULL, 0x000fe20003f06070ULL,
0x0000000022277faeULL, 0x0007e2000c901c48ULL, 0x0000002b060a7212ULL, 0x000fe200078efcffULL,
0x000000012a067824ULL, 0x040fe200078e0204ULL, 0x000000052a00720cULL, 0x080fe20003f26070ULL,
0x0000000008297faeULL, 0x0009e2000d101c48ULL, 0x000062000a0a7a10ULL, 0x000fe20007fde0ffULL,
0x00000001320c7824ULL, 0x100fe200078e0203ULL, 0x000000051e00720cULL, 0x000fe20003f46070ULL,
0x0000000128057824ULL, 0x040fe400078e0203ULL, 0x0000000828287824ULL, 0x000fc400078e00ffULL,
0x00000008320d7824ULL, 0x000fe400078e00ffULL, 0x0000000126047824ULL, 0x000fe200078e0204ULL,
0xfffffff8280f7812ULL, 0x002fe200078ee205ULL, 0x000000800b087825ULL, 0x010fe200078e00ffULL,
0x00006300070b7a10ULL, 0x000fe400037fe4ffULL, 0xfffffff80d0d7812ULL, 0x000fe200078ee20cULL,
0x000000011c077824ULL, 0x000fe200078e0203ULL, 0x0000002b08087212ULL, 0x000fe200078efcffULL,
0x000000081c1c7824ULL, 0x000fc400078e00ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x0000620008087a10ULL, 0x000fe40007fde0ffULL, 0xfffffff81c1d7812ULL, 0x000fe200078ee207ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000630009097a10ULL, 0x000fe400037fe4ffULL,
0x0000002b04047212ULL, 0x080fe200078efcffULL, 0x000000011e0c7824ULL, 0x000fe200078e0203ULL,
0x0000002b06067212ULL, 0x000fe200078efcffULL, 0x000000081e1f7824ULL, 0x000fc400078e00ffULL,
0x000000012a0e7824ULL, 0x100fe200078e0203ULL, 0x0000620006067a10ULL, 0x000fe20007fde0ffULL,
0x000000082a217824ULL, 0x004fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20cULL,
0x00000001261c7824ULL, 0x040fe200078e0203ULL, 0x0000630007077a10ULL, 0x000fe200037fe4ffULL,
0x0000000826237824ULL, 0x008fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee20eULL,
0x000000100d0d7824ULL, 0x100fe200078e0224ULL, 0x0000620004047a10ULL, 0x000fe20007fde0ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0224ULL, 0xfffffff823237812ULL, 0x000fe200078ee21cULL,
0x000000101d1d7824ULL, 0x100fe200078e0224ULL, 0x0000630005057a10ULL, 0x000fe200037fe4ffULL,
0x000000101f1f7824ULL, 0x100fe200078e0224ULL, 0x00000000100d7faeULL, 0x0003e2000e901c48ULL,
0x0000001021217824ULL, 0x000fc400078e0224ULL, 0x0000001023237824ULL, 0x000fe200078e0224ULL,
0x00000000120f7faeULL, 0x0003e8000e101c48ULL, 0x000000000a1d7faeULL, 0x0003e8000d901c48ULL,
0x00000000081f7faeULL, 0x0003e8000d101c48ULL, 0x0000000006217faeULL, 0x0003e8000c901c48ULL,
0x0000000004237faeULL, 0x0003e2000c101c48ULL, 0x00000b6000007947ULL, 0x000fea0003800000ULL,
0x0000000403067811ULL, 0x042fe400078fe8ffULL, 0x0000000803087811ULL, 0x000fc400078fe8ffULL,
0x00000018030d7811ULL, 0x040fe200078fe8ffULL, 0x0000000106057824ULL, 0x140fe200078e0203ULL,
0x0000000c030a7811ULL, 0x040fe200078fe8ffULL, 0x0000000806127824ULL, 0x000fe200078e00ffULL,
0x00000014030c7811ULL, 0x040fe200078fe8ffULL, 0x0000000108077824ULL, 0x040fe200078e0203ULL,
0x00000010030b7811ULL, 0x000fe200078fe8ffULL, 0x00000008081c7824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee205ULL, 0x000000010d0e7824ULL, 0x000fe200078e0203ULL,
0x0000002803267811ULL, 0x000fe200078fe8ffULL, 0x000000080d0f7824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee207ULL, 0x000000010a057824ULL, 0x140fe200078e0203ULL,
0x0000001c03217811ULL, 0x040fe200078fe8ffULL, 0x000000080a1e7824ULL, 0x000fe200078e00ffULL,
0x0000002403257811ULL, 0x040fe200078fe8ffULL, 0x000000010c097824ULL, 0x140fe200078e0203ULL,
0x0000002003247811ULL, 0x000fe200078fe8ffULL, 0x000000080c227824ULL, 0x000fe200078e00ffULL,
0xfffffff80f287812ULL, 0x000fe200078ee20eULL, 0x000000010b077824ULL, 0x040fe200078e0203ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee205ULL, 0x000000080b207824ULL, 0x000fe200078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee209ULL, 0x00000001260e7824ULL, 0x040fe200078e0203ULL,
0x0000003803307811ULL, 0x000fe200078fe8ffULL, 0x00000008260f7824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee207ULL, 0x0000000121057824ULL, 0x100fe200078e0203ULL,
0x0000002c03277811ULL, 0x000fe200078fe8ffULL, 0x00000008212a7824ULL, 0x000fe200078e00ffULL,
0x00000034032e7811ULL, 0x000fe200078fe8ffULL, 0x0000000125097824ULL, 0x100fe200078e0203ULL,
0x00000030032c7811ULL, 0x000fe200078fe8ffULL, 0x0000000825367824ULL, 0x000fe200078e00ffULL,
0xfffffff80f387812ULL, 0x000fe200078ee20eULL, 0x0000000124077824ULL, 0x000fe200078e0203ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee205ULL, 0x0000000824347824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee209ULL, 0x00000001300e7824ULL, 0x000fc400078e0203ULL,
0x00000008300f7824ULL, 0x000fe200078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ee207ULL,
0x0000000127057824ULL, 0x140fe400078e0203ULL, 0x00000008273a7824ULL, 0x000fe200078e00ffULL,
0xfffffff80f407812ULL, 0x000fe200078ee20eULL, 0x000000012e097824ULL, 0x040fe200078e0203ULL,
0x0000003c030f7811ULL, 0x040fe200078fe8ffULL, 0x000000082e3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee205ULL, 0x000000012c077824ULL, 0x040fe200078e0203ULL,
0x0000000403057211ULL, 0x040fe200078fe8ffULL, 0x000000082c3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee209ULL, 0x000000021a0e7824ULL, 0x000fe200078e0217ULL,
0x0000000303097211ULL, 0x040fe200078fe8ffULL, 0x0000000106067824ULL, 0x100fe200078e0204ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee207ULL, 0x0000001003077824ULL, 0x000fe200078e00ffULL,
0x0000000709107812ULL, 0x000fe200078ec0ffULL, 0x0000000108087824ULL, 0x100fe200078e0204ULL,
0x000020000e4b7811ULL, 0x000fe200078e68ffULL, 0x000000010a0a7824ULL, 0x100fe200078e0204ULL,
0x00000070074d7812ULL, 0x000fe200078ec0ffULL, 0x000000010b0b7824ULL, 0x100fe200078e0204ULL,
0x0ffffff810107812ULL, 0x000fe200078ef803ULL, 0x000000010c0c7824ULL, 0x000fc400078e0204ULL,
0x000000010d0d7824ULL, 0x100fe400078e0204ULL, 0x0000000121217824ULL, 0x100fe400078e0204ULL,
0x0000000124247824ULL, 0x100fe400078e0204ULL, 0x0000000125257824ULL, 0x100fe400078e0204ULL,
0x0000000126267824ULL, 0x100fe400078e0204ULL, 0x0000000127277824ULL, 0x000fc400078e0204ULL,
0x000000012c2c7824ULL, 0x100fe400078e0204ULL, 0x000000012e2e7824ULL, 0x100fe400078e0204ULL,
0x0000000130307824ULL, 0x100fe400078e0204ULL, 0x000000010f327824ULL, 0x000fe400078e0204ULL,
0x0000008005047825ULL, 0x000fc800078e00ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000004d040e7212ULL, 0x000fc600078efcffULL, 0x00000010102d7824ULL, 0x000fe200078e024bULL,
0x000062000e0e7a10ULL, 0x000fe20007f1e0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000004d06107212ULL, 0x000fc600078efcffULL, 0x000000010f117824ULL, 0x040fe200078e0203ULL,
0x0000620010107a10ULL, 0x000fe20007f3e0ffULL, 0x000000080f427824ULL, 0x000fe200078e00ffULL,
0x00006300050f7a10ULL, 0x000fe200007fe4ffULL, 0x00000010122f7824ULL, 0x000fe200078e024bULL,
0x0000004d08127212ULL, 0x080fe200078efcffULL, 0x000000800a047825ULL, 0x000fe200078e00ffULL,
0xfffffff842427812ULL, 0x000fe200078ee211ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e2d7faeULL, 0x0003e2000b901c48ULL, 0x0000630007117a10ULL, 0x000fe20000ffe4ffULL,
0x000000101c317824ULL, 0x000fe200078e024bULL, 0x0000620012127a10ULL, 0x000fe20007f1e0ffULL,
0x000000800b067825ULL, 0x000fe200078e00ffULL, 0x0000004d041c7212ULL, 0x000fe200078efcffULL,
0x00000000102f7faeULL, 0x0003e2000b901c48ULL, 0x0000630009137a10ULL, 0x000fe200007fe4ffULL,
0x000000800c0a7825ULL, 0x000fe200078e00ffULL, 0x000062001c1c7a10ULL, 0x000fc60007f1e0ffULL,
0x000000101e337824ULL, 0x100fe200078e024bULL, 0x0000004d061e7212ULL, 0x080fe200078efcffULL,
0x0000001020357824ULL, 0x100fe200078e024bULL, 0x0000004d0a207212ULL, 0x080fe200078efcffULL,
0x000000800d0c7825ULL, 0x000fe200078e00ffULL, 0x000062001e1e7a10ULL, 0x000fe20007f3e0ffULL,
0x0000000012317faeULL, 0x0003e2000b901c48ULL, 0x00006300051d7a10ULL, 0x000fe200007fe4ffULL,
0x0000008021047825ULL, 0x000fe200078e00ffULL, 0x0000620020207a10ULL, 0x000fe40007f1e0ffULL,
0x00006300071f7a10ULL, 0x000fe20000ffe4ffULL, 0x0000001022377824ULL, 0x100fe200078e024bULL,
0x0000004d0c227212ULL, 0x080fe200078efcffULL, 0x0000008024067825ULL, 0x000fe200078e00ffULL,
0x000063000b217a10ULL, 0x000fe200007fe4ffULL, 0x000000001c337faeULL, 0x0003e2000b901c48ULL,
0x0000004d04247212ULL, 0x080fe200078efcffULL, 0x0000008025087825ULL, 0x000fe200078e00ffULL,
0x0000620022227a10ULL, 0x000fe20007f5e0ffULL, 0x000000001e357faeULL, 0x0003e2000b901c48ULL,
0x0000620024247a10ULL, 0x000fe20007f1e0ffULL, 0x00000080260a7825ULL, 0x000fe200078e00ffULL,
0x0000004d06267212ULL, 0x080fe200078efcffULL, 0x0000000020377faeULL, 0x0003e2000b901c48ULL,
0x000063000d237a10ULL, 0x000fe200017fe4ffULL, 0x0000001028397824ULL, 0x100fe200078e024bULL,
0x0000004d08287212ULL, 0x080fe200078efcffULL, 0x000000102a3b7824ULL, 0x000fe200078e024bULL,
0x0000004d0a2a7212ULL, 0x000fe200078efcffULL, 0x00000080270c7825ULL, 0x000fe200078e00ffULL,
0x0000620026267a10ULL, 0x000fe20007f3e0ffULL, 0x0000000022397faeULL, 0x0003e2000b901c48ULL,
0x0000630005257a10ULL, 0x000fe200007fe4ffULL, 0x000000802c047825ULL, 0x000fe200078e00ffULL,
0x0000620028287a10ULL, 0x000fc40007f1e0ffULL, 0x000062002a2a7a10ULL, 0x000fe20007f5e0ffULL,
0x00000010343d7824ULL, 0x000fe200078e024bULL, 0x0000630007277a10ULL, 0x000fe20000ffe4ffULL,
0x000000802e067825ULL, 0x000fe200078e00ffULL, 0x0000004d0c0c7212ULL, 0x080fe200078efcffULL,
0x00000000243b7faeULL, 0x0003e2000b901c48ULL, 0x0000630009297a10ULL, 0x000fe200007fe4ffULL,
0x0000008030087825ULL, 0x000fe200078e00ffULL, 0x000063000b2b7a10ULL, 0x000fe200017fe4ffULL,
0x00000000263d7faeULL, 0x0003e2000b901c48ULL, 0x000062000c0c7a10ULL, 0x000fe20007f1e0ffULL,
0x00000080320a7825ULL, 0x000fe200078e00ffULL, 0x0000004d04047212ULL, 0x000fc400078efcffULL,
0x0000004d06067212ULL, 0x080fe200078efcffULL, 0x00000010363f7824ULL, 0x100fe200078e024bULL,
0x0000004d08087212ULL, 0x080fe200078efcffULL, 0x0000001038417824ULL, 0x100fe200078e024bULL,
0x000063000d0d7a10ULL, 0x000fe200007fe4ffULL, 0x000000103a437824ULL, 0x100fe200078e024bULL,
0x0000004d0a0a7212ULL, 0x000fe200078efcffULL, 0x000000103c457824ULL, 0x100fe200078e024bULL,
0x0000620004047a10ULL, 0x000fe20007f1e0ffULL, 0x000000103e477824ULL, 0x100fe200078e024bULL,
0x0000620006067a10ULL, 0x000fe20007f3e0ffULL, 0x0000001040497824ULL, 0x100fe200078e024bULL,
0x0000620008087a10ULL, 0x000fe20007f5e0ffULL, 0x00000000283f7faeULL, 0x0003e2000b901c48ULL,
0x000062000a0a7a10ULL, 0x000fe20007f7e0ffULL, 0x00000010424b7824ULL, 0x000fe200078e024bULL,
0x0000630005057a10ULL, 0x000fe200007fe4ffULL, 0x000000002a417faeULL, 0x0003e2000b901c48ULL,
0x0000630007077a10ULL, 0x000fc40000ffe4ffULL, 0x0000630009097a10ULL, 0x000fe200017fe4ffULL,
0x000000000c437faeULL, 0x0003e2000b901c48ULL, 0x000063000b0b7a10ULL, 0x000fc60001ffe4ffULL,
0x0000000004457faeULL, 0x0003e8000b901c48ULL, 0x0000000006477faeULL, 0x0003e8000b901c48ULL,
0x0000000008497faeULL, 0x0003e8000b901c48ULL, 0x000000000a4b7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000ffff627224ULL, 0x000fe200078e00ffULL,
0x0000000000067805ULL, 0x002fe2000001ff00ULL, 0x0000000000047805ULL, 0x000fe2000001ff00ULL,
0x0000000000127805ULL, 0x000fe2000001ff00ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x00000000000c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000427805ULL, 0x000fe2000001ff00ULL, 0x0000000000407805ULL, 0x000fe2000001ff00ULL,
0x00000000003e7805ULL, 0x000fe2000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff8034c7812ULL, 0x020fe200078ec0ffULL,
0x000000021a797824ULL, 0x000fe200078e0263ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000001628c7810ULL, 0x000fc40007ffe0ffULL, 0x000000074c517812ULL, 0x100fe400078ef803ULL,
0x0000200079797811ULL, 0x000fe400078e68ffULL, 0x00000008037c7812ULL, 0x000fe200078ec0ffULL,
0x00000001514c7824ULL, 0x040fe200078e0262ULL, 0x00000004ff7d7819ULL, 0x100fe20000011603ULL,
0x00000008514d7824ULL, 0x040fe200078e00ffULL, 0x000000077c7c7812ULL, 0x000fe200078ef803ULL,
0x0000000851507824ULL, 0x040fe400078e00ffULL, 0x0000000151517824ULL, 0x000fe200078e028cULL,
0xfffffff84d4c7812ULL, 0x000fe200078ee24cULL, 0x00000002627d7824ULL, 0x000fe200078e027dULL,
0x000000107c7b7812ULL, 0x000fc400078efcffULL, 0xfffffff850507812ULL, 0x000fe200078ee251ULL,
0x000000104c4c7824ULL, 0x000fc800078e0279ULL, 0x0000001050507824ULL, 0x000fe400078e0279ULL,
0x000000004c4c783bULL, 0x000e680000000200ULL, 0x000000005050783bULL, 0x000ea20000000200ULL,
0x00000018ff547819ULL, 0x002fe2000001144cULL, 0x000100004d5a7824ULL, 0x040fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe2000001144dULL, 0x000100004c567824ULL, 0x000fe200078e00ffULL,
0x0000005400807306ULL, 0x0003e20000200c00ULL, 0x000088804d597816ULL, 0x040fe200000000ffULL,
0x000001004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fc4000001144fULL,
0x00000018ff677819ULL, 0x004fe40000011450ULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000005500847306ULL, 0x0005e20000200c00ULL, 0x0000002003547810ULL, 0x002fe40007ffe0ffULL,
0x0000888050687816ULL, 0x000fe400000000ffULL, 0xfffffff854547812ULL, 0x000fe400078ec0ffULL,
0x00000018ff587819ULL, 0x000fe20000011456ULL, 0x0000004d00877306ULL, 0x0003e20000200c00ULL,
0x000088804c557816ULL, 0x044fe200000000ffULL, 0x000001004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000007547f7812ULL, 0x000fc400078ef803ULL, 0x00000018ff787819ULL, 0x000fe4000001144eULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x000000017f547824ULL, 0x000fe200078e0262ULL,
0x0000005900827306ULL, 0x0005e20000200c00ULL, 0x000100004f4d7824ULL, 0x002fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x000000087f577824ULL, 0x040fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe20000011451ULL, 0x000000017f8c7824ULL, 0x040fe200078e028cULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x000000087f7f7824ULL, 0x000fe200078e00ffULL,
0x0000004c00837306ULL, 0x0003e20000200c00ULL, 0xfffffff857547812ULL, 0x000fc400078ee254ULL,
0x000088804f597816ULL, 0x044fe200000000ffULL, 0x000001004f4f7824ULL, 0x000fe200078e00ffULL,
0x00008880516b7816ULL, 0x000fe200000000ffULL, 0x0000001054547824ULL, 0x000fe200078e0279ULL,
0x00000018ff647819ULL, 0x000fe20000011453ULL, 0x0000004d008d7306ULL, 0x0005e20000200c00ULL,
0x000088804e4c7816ULL, 0x002fe400000000ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x0000888053717816ULL, 0x000fc400000000ffULL, 0x00000018ff657819ULL, 0x000fe20000011452ULL,
0x0000004c00867306ULL, 0x0003e20000200c00ULL, 0x00010000514d7824ULL, 0x044fe200078e00ffULL,
0x00008880526c7816ULL, 0x000fe200000000ffULL, 0x0000010051517824ULL, 0x000fe200078e00ffULL,
0xfffffff87f8c7812ULL, 0x000fe400078ee28cULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000055007e7306ULL, 0x0005e20000200c00ULL, 0x00010000504c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x0000010050507824ULL, 0x000fe200078e00ffULL,
0x0000000262627810ULL, 0x000fc40007ffe0ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000005800817306ULL, 0x0003e20000200c00ULL,
0x000000005454783bULL, 0x004ea20000000200ULL, 0x000000086200780cULL, 0x000fcc0003f05270ULL,
0x0000004f008f7306ULL, 0x0007e20000200c00ULL, 0x000100004e587824ULL, 0x042fe400078e00ffULL,
0x000001004e4e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x0000004c00697306ULL, 0x0003e20000200c00ULL, 0x000000107c4f7824ULL, 0x008fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fcc000001144eULL, 0x00000050006a7306ULL, 0x0007e20000200c00ULL,
0x000000017c4c7824ULL, 0x002fca00078e027dULL, 0xfffffff04f4c7812ULL, 0x000fe400078ee24cULL,
0x0000004d006e7306ULL, 0x0003e20000200c00ULL, 0x000000107b507824ULL, 0x008fce00078e00ffULL,
0x0000005800897306ULL, 0x0007220000200c00ULL, 0x000000017b4d7824ULL, 0x002fe200078e027dULL,
0x00000018ff7a7819ULL, 0x004fe20000011454ULL, 0x00010000567f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff777819ULL, 0x000fe40000011455ULL, 0xfffffff0504d7812ULL, 0x000fe200078ee24dULL,
0x0001000053507824ULL, 0x000fe200078e00ffULL, 0x0000004e008b7306ULL, 0x0003e20000200c00ULL,
0x000000104c587824ULL, 0x008fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011456ULL,
0x000000104d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011450ULL,
0x0000010053537824ULL, 0x000fe200078e00ffULL, 0x0000888054507816ULL, 0x000fc400000000ffULL,
0x0000005a00857306ULL, 0x000ea20000200c00ULL, 0x00010000524e7824ULL, 0x042fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000010052527824ULL, 0x000fe200078e00ffULL,
0x0000541086867816ULL, 0x010fe40000000089ULL, 0x00000018ff6f7819ULL, 0x000fe4000001144eULL,
0x0000005900887306ULL, 0x0002e20000200c00ULL, 0x000000004d4c783bULL, 0x000fe20000000200ULL,
0x00000018ff527819ULL, 0x000fc40000011452ULL, 0x00000018ff747819ULL, 0x000fe40000011457ULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x00000051006d7306ULL, 0x0009e20000200c00ULL,
0x000000005858783bULL, 0x002e620000000200ULL, 0x0000541082827816ULL, 0x004fcc0000000085ULL,
0x0000007800787306ULL, 0x000fe20000200c00ULL, 0x0001000054517824ULL, 0x010fe200078e00ffULL,
0x0000541088887816ULL, 0x008fe2000000008dULL, 0x0000010054547824ULL, 0x000fc600078e00ffULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000007600767306ULL, 0x000ea20000200c00ULL,
0x00000018ff547819ULL, 0x000fce0000011454ULL, 0x0000005300737306ULL, 0x0007f00000200c00ULL,
0x00000050008a7306ULL, 0x0009e20000200c00ULL, 0x0001000055537824ULL, 0x008fe200078e00ffULL,
0x000054108f897816ULL, 0x004fc80000000076ULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x0000005100917306ULL, 0x0005e20000200c00ULL, 0x000054107e507816ULL, 0x010fe20000000081ULL,
0x000000107c817824ULL, 0x000fe200078e00ffULL, 0x00000088581c723cULL, 0x002fea000000181cULL,
0x0000005200707306ULL, 0x0003e20000200c00ULL, 0x0000541083517816ULL, 0x004fc40000000080ULL,
0x0000541087837816ULL, 0x000fe20000000084ULL, 0x000000884c30723cULL, 0x000fe20000001830ULL,
0x000054108b877816ULL, 0x000fe40000000078ULL, 0x0000888057787816ULL, 0x000fe200000000ffULL,
0x0000005400937306ULL, 0x0005e20000200c00ULL, 0x0000888055527816ULL, 0x002fc600000000ffULL,
0x000000505844723cULL, 0x000f620000001844ULL, 0x000000ffff767224ULL, 0x000fe400078e0078ULL,
0x0001000057787824ULL, 0x040fe200078e00ffULL, 0x00000052007e7306ULL, 0x000fe20000200c00ULL,
0x0000010057577824ULL, 0x000fc600078e00ffULL, 0x000000504c08723cULL, 0x000b620000001808ULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x0000007700777306ULL, 0x000fe60000200c00ULL, 0x0000010055507824ULL, 0x020fe200078e00ffULL,
0x0000888056517816ULL, 0x040fe200000000ffULL, 0x0000010056567824ULL, 0x000fe200078e00ffULL,
0x000000825848723cULL, 0x000f640000001848ULL, 0x0000005300557306ULL, 0x0002e20000200c00ULL,
0x00000018ff547819ULL, 0x004fe20000011450ULL, 0x000000108c507824ULL, 0x000fe200078e0279ULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x000000ffff797224ULL, 0x000fc400078e0051ULL,
0x000000824c3c723cULL, 0x000b64000000183cULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x000000005050783bULL, 0x002e6a0000000200ULL, 0x000000865820723cULL, 0x080fe40000001820ULL,
0x0000007600827306ULL, 0x0207ec0000200c00ULL, 0x000000864c40723cULL, 0x000fe40000001840ULL,
0x0000007800837306ULL, 0x0008620000200c00ULL, 0x000054107e767816ULL, 0x008fc40000000055ULL,
0x000000027d557810ULL, 0x000fe40007ffe0ffULL, 0x0000541054777816ULL, 0x004fe20000000077ULL,
0x000000107b547824ULL, 0x040fe400078e00ffULL, 0x0000007a007a7306ULL, 0x000ea20000200c00ULL,
0x000000017c7c7824ULL, 0x000fe200078e0255ULL, 0x000054108a787816ULL, 0x010fe20000000091ULL,
0x000000017b557824ULL, 0x000fe200078e0255ULL, 0x000000765828723cULL, 0x000fe40000001828ULL,
0xfffffff0817c7812ULL, 0x000fc400078ee27cULL, 0x0000007500757306ULL, 0x000fe20000200c00ULL,
0xfffffff054557812ULL, 0x000fe400078ee255ULL, 0x0000541082827816ULL, 0x002fe20000000083ULL,
0x000000107c547824ULL, 0x000fe200078e00ffULL, 0x000000764c0c723cULL, 0x000be6000000180cULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x00000018ff7b7819ULL, 0x000fe40000011451ULL,
0x00000018ff7c7819ULL, 0x000fc40000011452ULL, 0x0000888051767816ULL, 0x020fc600000000ffULL,
0x0000007900807306ULL, 0x0005f00000200c00ULL, 0x0000007f007f7306ULL, 0x000e620000200c00ULL,
0x0000541093797816ULL, 0x004fe4000000007aULL, 0x00000018ff7a7819ULL, 0x000fca0000011450ULL,
0x0000005600567306ULL, 0x000ea20000200c00ULL, 0x000000785838723cULL, 0x080fee0000001838ULL,
0x00000057007d7306ULL, 0x0007220000200c00ULL, 0x0000541080807816ULL, 0x002fe2000000007fULL,
0x000000784c24723cULL, 0x000be20000001824ULL, 0x0000541056817816ULL, 0x004fe20000000075ULL,
0x0000001055757824ULL, 0x000fc800078e00ffULL, 0x0000006800687306ULL, 0x000e620000200c00ULL,
0x000000005454783bULL, 0x008ea20000000200ULL, 0x0001000050787824ULL, 0x020fe200078e00ffULL,
0x00000080582c723cULL, 0x000f62000000182cULL, 0x000054107d837816ULL, 0x010fc80000000074ULL,
0x0000006700677306ULL, 0x000ee20000200c00ULL, 0x0000888050747816ULL, 0x040fe200000000ffULL,
0x0000010050507824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe20000011453ULL,
0x000000825834723cULL, 0x000be20000001834ULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x000000007558783bULL, 0x020f240000000200ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x0000541068687816ULL, 0x002fe40000000069ULL, 0x00000018ff507819ULL, 0x000fe20000011450ULL,
0x000000804c10723cULL, 0x000f680000001810ULL, 0x0000006b006b7306ULL, 0x000e620000200c00ULL,
0x000054106a697816ULL, 0x008fc40000000067ULL, 0x0000888052677816ULL, 0x000fe200000000ffULL,
0x000000824c04723cULL, 0x000b680000001804ULL, 0x0000005000777306ULL, 0x000fe60000200c00ULL,
0x00010000514d7824ULL, 0x020fe400078e00ffULL, 0x000000ffff4c7224ULL, 0x000fc400078e0076ULL,
0x0000010051517824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000004c004e7306ULL, 0x0003e20000200c00ULL, 0x000000685444723cULL, 0x004f640000001844ULL,
0x00000018ff517819ULL, 0x000fca0000011451ULL, 0x0000004d004f7306ULL, 0x0004e20000200c00ULL,
0x000054106b4c7816ULL, 0x002fe2000000006eULL, 0x000000685808723cULL, 0x010f6c0000001808ULL,
0x0000005100507306ULL, 0x0003e20000200c00ULL, 0x000054106d4d7816ULL, 0x004fe20000000066ULL,
0x000000ffff667224ULL, 0x000fc400078e0067ULL, 0x0001000052677824ULL, 0x040fe400078e00ffULL,
0x0000010052527824ULL, 0x000fe400078e00ffULL, 0x0000004c5448723cULL, 0x000f620000001848ULL,
0x0001000053517824ULL, 0x002fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011467ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x00000018ff517819ULL, 0x000fc40000011451ULL, 0x0000004c583c723cULL, 0x000b62000000183cULL,
0x000054104e4e7816ULL, 0x008fe4000000004fULL, 0x0000006700677306ULL, 0x000e680000200c00ULL,
0x00008880534c7816ULL, 0x060fe200000000ffULL, 0x0000010053537824ULL, 0x000fc600078e00ffULL,
0x0000007c007c7306ULL, 0x000fe40000200c00ULL, 0x00000018ff537819ULL, 0x000fcc0000011453ULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x0000541066667816ULL, 0x002fce0000000067ULL,
0x0000007800757306ULL, 0x000e700000200c00ULL, 0x00000052004d7306ULL, 0x000eb00000200c00ULL,
0x0000006500657306ULL, 0x000ee20000200c00ULL, 0x0000541074747816ULL, 0x002fce0000000075ULL,
0x0000006400647306ULL, 0x000e620000200c00ULL, 0x000054104d677816ULL, 0x004fce000000007cULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x00005410706d7816ULL, 0x008fe20000000065ULL,
0x00000066542c723cULL, 0x080b6c000000182cULL, 0x0000006f006f7306ULL, 0x000ea20000200c00ULL,
0x0000541073737816ULL, 0x002fe20000000064ULL, 0x000000665810723cULL, 0x000b6c0000001810ULL,
0x0000007100717306ULL, 0x000ff00000200c00ULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x000054106c6c7816ULL, 0x004fce000000006fULL, 0x0000007a007a7306ULL, 0x000ea20000200c00ULL,
0x0000006c5420723cULL, 0x080b6e0000001820ULL, 0x0000007b007b7306ULL, 0x000ee20000200c00ULL,
0x0000541071727816ULL, 0x002fe20000000072ULL, 0x0000006c5840723cULL, 0x000b6c0000001840ULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x0000541077757816ULL, 0x004fe2000000007aULL,
0x00000072541c723cULL, 0x080b6c000000181cULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x00005410504f7816ULL, 0x008fe2000000007bULL, 0x000000725830723cULL, 0x000b6c0000001830ULL,
0x0000005100517306ULL, 0x000e640000200c00ULL, 0x000000745438723cULL, 0x040b6c0000001838ULL,
0x0000005300527306ULL, 0x000ea40000200c00ULL, 0x0000004e5428723cULL, 0x000b620000001828ULL,
0x000054104c4c7816ULL, 0x002fce0000000051ULL, 0x000000745824723cULL, 0x000b620000001824ULL,
0x00005410524d7816ULL, 0x004fce000000007dULL, 0x0000004e580c723cULL, 0x000b70000000180cULL,
0x0000004c5434723cULL, 0x080b700000001834ULL, 0x0000004c5804723cULL, 0x000b620000001804ULL,
0x0000001000008944ULL, 0x000fe20003c00000ULL, 0xffffee1000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fc40000000000ULL, 0x0000006044517220ULL, 0x080fe40000410000ULL,
0x00000060484f7220ULL, 0x020fc40000410000ULL, 0x0000006045457220ULL, 0x080fe40000410000ULL,
0x00000060384e7220ULL, 0x080fe40000410000ULL, 0x0000006039487220ULL, 0x080fe40000410000ULL,
0x000000602d447220ULL, 0x080fe40000410000ULL, 0x0000006036367220ULL, 0x080fe40000410000ULL,
0x0000006037377220ULL, 0x000fc40000410000ULL, 0x0000006049497220ULL, 0x080fe40000410000ULL,
0x0000006020507220ULL, 0x080fe40000410000ULL, 0x00000060214c7220ULL, 0x080fe40000410000ULL,
0x0000006022227220ULL, 0x080fe40000410000ULL, 0x000000601d4d7220ULL, 0x080fe40000410000ULL,
0x000000603a3a7220ULL, 0x000fc40000410000ULL, 0x000000603b3b7220ULL, 0x080fe40000410000ULL,
0x000000602a2a7220ULL, 0x080fe40000410000ULL, 0x000000602c2c7220ULL, 0x080fe40000410000ULL,
0x0000006034347220ULL, 0x080fe40000410000ULL, 0x0000006035357220ULL, 0x080fe40000410000ULL,
0x00000060082d7220ULL, 0x000fc40000410000ULL, 0x000000600a567220ULL, 0x080fe40000410000ULL,
0x000000600b577220ULL, 0x080fe40000410000ULL, 0x0000006040407220ULL, 0x080fe40000410000ULL,
0x0000006024387220ULL, 0x080fe40000410000ULL, 0x0000006025397220ULL, 0x080fe40000410000ULL,
0x0000006046527220ULL, 0x000fc40000410000ULL, 0x0000006047537220ULL, 0x080fe40000410000ULL,
0x000000604a547220ULL, 0x080fe40000410000ULL, 0x000000604b557220ULL, 0x080fe40000410000ULL,
0x000000601c1c7220ULL, 0x080fe40000410000ULL, 0x000000601e1e7220ULL, 0x080fe40000410000ULL,
0x000000601f1f7220ULL, 0x000fc40000410000ULL, 0x000000602b1d7220ULL, 0x080fe40000410000ULL,
0x000000602e207220ULL, 0x080fe40000410000ULL, 0x000000602f217220ULL, 0x080fe40000410000ULL,
0x0000006009097220ULL, 0x080fe40000410000ULL, 0x000000603d3d7220ULL, 0x080fe40000410000ULL,
0x0000006041087220ULL, 0x000fc40000410000ULL, 0x00000060300a7220ULL, 0x080fe40000410000ULL,
0x00000060310b7220ULL, 0x080fe40000410000ULL, 0x000000600c0c7220ULL, 0x080fe40000410000ULL,
0x000000600d0d7220ULL, 0x080fe40000410000ULL, 0x0000006010107220ULL, 0x080fe40000410000ULL,
0x0000006011117220ULL, 0x000fc40000410000ULL, 0x000000603e587220ULL, 0x080fe40000410000ULL,
0x000000603f597220ULL, 0x080fe40000410000ULL, 0x0000006028477220ULL, 0x080fe40000410000ULL,
0x00000060425a7220ULL, 0x080fe40000410000ULL, 0x00000060435b7220ULL, 0x000fe40000410000ULL,
0x000000ffff4a7224ULL, 0x000fc400078e0045ULL, 0x000000ffff3f7224ULL, 0x000fe400078e0036ULL,
0x000000ffff3e7224ULL, 0x000fe400078e0037ULL, 0x0000006029467220ULL, 0x080fe40000410000ULL,
0x000000603c287220ULL, 0x080fe40000410000ULL, 0x0000006032627220ULL, 0x080fe40000410000ULL,
0x0000006033637220ULL, 0x000fc40000410000ULL, 0x0000006026647220ULL, 0x080fe40000410000ULL,
0x0000006027657220ULL, 0x000fe40000410000ULL, 0x000000ffff4b7224ULL, 0x000fe400078e0049ULL,
0x000000ffff457224ULL, 0x000fe400078e002cULL, 0x000000ffff437224ULL, 0x000fe400078e0034ULL,
0x000000ffff427224ULL, 0x000fc400078e0035ULL, 0x000000ffff257224ULL, 0x000fe400078e0022ULL,
0x000000ffff2f7224ULL, 0x000fe400078e003aULL, 0x000000ffff417224ULL, 0x000fe400078e003bULL,
0x000000ffff317224ULL, 0x000fe400078e002aULL, 0x000000ffff247224ULL, 0x000fe400078e0040ULL,
0x000000ffff367224ULL, 0x000fc400078e0038ULL, 0x000000ffff377224ULL, 0x000fe400078e0039ULL,
0x0000006023237220ULL, 0x080fe40000410000ULL, 0x000000600e0e7220ULL, 0x080fe40000410000ULL,
0x000000600f0f7220ULL, 0x080fe40000410000ULL, 0x0000006012667220ULL, 0x080fe40000410000ULL,
0x0000006013677220ULL, 0x000fc40000410000ULL, 0x00000060043c7220ULL, 0x080fe40000410000ULL,
0x0000006005057220ULL, 0x080fe40000410000ULL, 0x0000006006067220ULL, 0x080fe40000410000ULL,
0x0000006007077220ULL, 0x000fe40000410000ULL, 0x000000ffff497224ULL, 0x000fe400078e001cULL,
0x000000ffff2c7224ULL, 0x000fc400078e0052ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0053ULL,
0x000000ffff297224ULL, 0x000fe400078e0054ULL, 0x000000ffff277224ULL, 0x000fe400078e0055ULL,
0x000000ffff2e7224ULL, 0x000fe400078e001eULL, 0x000000ffff307224ULL, 0x000fe400078e001fULL,
0x000000ffff3a7224ULL, 0x000fc400078e001dULL, 0x000000ffff327224ULL, 0x000fe400078e0020ULL,
0x000000ffff337224ULL, 0x000fe400078e0021ULL, 0x000000ffff2a7224ULL, 0x000fe400078e0009ULL,
0x000000ffff267224ULL, 0x000fe400078e003dULL, 0x000000ffff227224ULL, 0x000fe400078e0008ULL,
0x000000ffff347224ULL, 0x000fc400078e000aULL, 0x000000ffff357224ULL, 0x000fe400078e000bULL,
0x000000ffff387224ULL, 0x000fe400078e000cULL, 0x000000ffff397224ULL, 0x000fe400078e000dULL,
0x000000ffff407224ULL, 0x000fe400078e0010ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0011ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000005f087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff0b7224ULL, 0x000fc400078e000eULL, 0x000000ffff0c7224ULL, 0x000fe400078e000fULL,
0x000000ffff3d7224ULL, 0x000fe400078e0005ULL, 0x000000ffff207224ULL, 0x000fe400078e0056ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0057ULL, 0x000000ffff1e7224ULL, 0x000fe400078e0058ULL,
0x000000ffff1d7224ULL, 0x000fc400078e0059ULL, 0x000000ffff1c7224ULL, 0x000fe400078e005aULL,
0x000000ffff137224ULL, 0x000fe400078e005bULL, 0x000000ffff217224ULL, 0x000fe400078e0062ULL,
0x000000ffff127224ULL, 0x000fe400078e0063ULL, 0x000000ffff117224ULL, 0x000fe400078e0064ULL,
0x000000ffff0a7224ULL, 0x000fc400078e0065ULL, 0x000000ffff0d7224ULL, 0x000fe400078e0066ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0067ULL, 0x000000ffff0f7224ULL, 0x000fe400078e0006ULL,
0x000000ffff107224ULL, 0x000fc400078e0007ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x000004005f077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff527224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000105200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604537210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09005300780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c405300780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000005306067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000152527810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004005f077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000403097824ULL, 0x000fe200078e00ffULL, 0x000000195e00720cULL, 0x000fc80003f06070ULL,
0xfffffff009057812ULL, 0x000fca00078ec0ffULL, 0x000000801a087824ULL, 0x000fca00078e0205ULL,
0x01a4000008047984ULL, 0x0002a20000000c00ULL, 0x00001f6000008947ULL, 0x000fea0003800000ULL,
0x0000000203537824ULL, 0x000fe200078e00ffULL, 0xffffff0061617810ULL, 0x000fe20007ffe0ffULL,
0x00000002ff727424ULL, 0x000fe200078e00ffULL, 0x0000000003547211ULL, 0x000fe400078ff0ffULL,
0x0000006116527217ULL, 0x000fe40007800000ULL, 0x0000000653537812ULL, 0x000fe400078ec0ffULL,
0x0000000854557810ULL, 0x000fe20007ffe0ffULL, 0x0000000152527824ULL, 0x000fe200078e0a61ULL,
0x00005a00ff577a19ULL, 0x000fe20000011654ULL, 0x000000011b597824ULL, 0x000fe200078e0253ULL,
0x00005a00ff617a19ULL, 0x000fc40000011655ULL, 0x0000580053557a10ULL, 0x000fe20007ffe0ffULL,
0x00000001595b7824ULL, 0x140fe200078e0a52ULL, 0x000000525900720cULL, 0x080fe40003f26070ULL,
0x000000575c577217ULL, 0x040fe20003800000ULL, 0x0000000155597824ULL, 0x040fe200078e0a52ULL,
0x0000005b5c5b7217ULL, 0x040fe40003800000ULL, 0x000000615c617217ULL, 0x000fe20003800000ULL,
0x0000005718787224ULL, 0x000fe200078e02ffULL, 0x000000525500720cULL, 0x000fc40003f06070ULL,
0x000000595c597217ULL, 0x000fe20003800000ULL, 0x00000061187a7224ULL, 0x000fe200078e02ffULL,
0x00000004ff5b7819ULL, 0x000fe4000001165bULL, 0x0000001054567810ULL, 0x000fe40007ffe0ffULL,
0x000000ff596d7207ULL, 0x000fe40000000000ULL, 0x000000ff5b617207ULL, 0x000fe40000800000ULL,
0x00005a00ff577a19ULL, 0x000fc40000011656ULL, 0x000000786d597211ULL, 0x040fe200078fe0ffULL,
0x00000001785b7824ULL, 0x000fe200078e0261ULL, 0x0000007a6d637211ULL, 0x000fe400078fe0ffULL,
0x0000001854547810ULL, 0x000fe20007ffe0ffULL, 0x0000600059587625ULL, 0x080fe200078e0072ULL,
0x000000575c577217ULL, 0x040fe40003800000ULL, 0x00005a00ff657a19ULL, 0x000fe20000011654ULL,
0x000060005b5a7625ULL, 0x080fe200078e0072ULL, 0x0000000858547981ULL, 0x000724000c1e9500ULL,
0x000000655c657217ULL, 0x000fe20003800000ULL, 0x0000600063627625ULL, 0x000fc800078e0072ULL,
0x0000005718847224ULL, 0x040fe200078e02ffULL, 0x0000000862567981ULL, 0x0042a2000c1e9500ULL,
0x0000000161677824ULL, 0x000fe400078e027aULL, 0x0000006518867224ULL, 0x000fe200078e02ffULL,
0x000000085a577981ULL, 0x000722000c1e9500ULL, 0x000000846d697211ULL, 0x000fe200078fe0ffULL,
0x00000001616b7824ULL, 0x000fe200078e0284ULL, 0x0000001053637812ULL, 0x002fc600078efcffULL,
0x0000600069687625ULL, 0x000fe200078e0072ULL, 0x0000580063657a10ULL, 0x000fc60007ffe0ffULL,
0x000000011b757824ULL, 0x000fe200078e0263ULL, 0x0000000868587981ULL, 0x0082e2000c1e9500ULL,
0x0000600067667625ULL, 0x000fc800078e0072ULL, 0x000060006b6a7625ULL, 0x000fe200078e0072ULL,
0x00000008665b7981ULL, 0x0002a6000c1e9500ULL, 0x0000000175777824ULL, 0x000fe400078e0a52ULL,
0x0000000161717824ULL, 0x000fe400078e0286ULL, 0x0000000165737824ULL, 0x000fe200078e0a52ULL,
0x000000086a617981ULL, 0x0002e2000c1e9500ULL, 0x000000866d6f7211ULL, 0x000fc400078fe0ffULL,
0x000000775c777217ULL, 0x040fe40003800000ULL, 0x000000526500720cULL, 0x000fe40003f06070ULL,
0x000000735c737217ULL, 0x000fe20003800000ULL, 0x000060006f6e7625ULL, 0x000fe200078e0072ULL,
0x000000527500720cULL, 0x000fe40003f26070ULL, 0x00000004ff777819ULL, 0x000fe20000011677ULL,
0x0000600071707625ULL, 0x000fe200078e0072ULL, 0x000000ff73897207ULL, 0x000fe20000000000ULL,
0x000000086e597981ULL, 0x0002e2000c1e9500ULL, 0x000000ff77777207ULL, 0x000fc40000800000ULL,
0x0000007a896b7211ULL, 0x042fe200078fe0ffULL, 0x00000008705a7981ULL, 0x0002e2000c1e9500ULL,
0x0000007889697211ULL, 0x000fe200078fe0ffULL, 0x0000000178677824ULL, 0x000fe200078e0277ULL,
0x0000002053757812ULL, 0x000fe200078efcffULL, 0x000060006b6a7625ULL, 0x000fc800078e0072ULL,
0x00000001776f7824ULL, 0x040fe200078e027aULL, 0x000000086a647981ULL, 0x0002e2000c1e9500ULL,
0x0000000177737824ULL, 0x000fe400078e0284ULL, 0x0000600069687625ULL, 0x000fc800078e0072ULL,
0x0000000177777824ULL, 0x000fe200078e0286ULL, 0x0000000868627981ULL, 0x0002e2000c1e9500ULL,
0x0000600067667625ULL, 0x000fc800078e0072ULL, 0x000060006f6e7625ULL, 0x080fe400078e0072ULL,
0x0000000866677981ULL, 0x0002e4000c1e9500ULL, 0x000000011b817824ULL, 0x000fe400078e0275ULL,
0x00006000776a7625ULL, 0x002fe200078e0072ULL, 0x0000580075777a10ULL, 0x000fc60007ffe0ffULL,
0x0000600073687625ULL, 0x000fe200078e0072ULL, 0x0000008489717211ULL, 0x000fe200078fe0ffULL,
0x000000086e737981ULL, 0x0002e4000c1e9500ULL, 0x0000000181837824ULL, 0x100fe200078e0a52ULL,
0x00000086897d7211ULL, 0x000fe200078fe0ffULL, 0x00000001777f7824ULL, 0x040fe200078e0a52ULL,
0x000000527700720cULL, 0x000fe20003f06070ULL, 0x0000000868797981ULL, 0x0002e2000c1e9500ULL,
0x000000835c837217ULL, 0x040fe20003800000ULL, 0x0000600071707625ULL, 0x000fe200078e0072ULL,
0x0000007f5c7f7217ULL, 0x000fe20003800000ULL, 0x000000086a7b7981ULL, 0x0002e2000c1e9500ULL,
0x000000528100720cULL, 0x000fe20003f26070ULL, 0x000060007d7c7625ULL, 0x000fe200078e0072ULL,
0x00000004ff837819ULL, 0x000fe20000011683ULL, 0x0000000870667981ULL, 0x0002e2000c1e9500ULL,
0x000000ff7f8f7207ULL, 0x000fc40000000000ULL, 0x000000ff83697207ULL, 0x002fe20000800000ULL,
0x000000087c6c7981ULL, 0x0002e2000c1e9500ULL, 0x0000007a8f837211ULL, 0x000fc600078fe0ffULL,
0x0000000169717824ULL, 0x000fe400078e027aULL, 0x0000600083827625ULL, 0x000fe200078e0072ULL,
0x000000788f6b7211ULL, 0x000fc600078fe0ffULL, 0x0000600071707625ULL, 0x000fe200078e0072ULL,
0x0000000882767981ULL, 0x0002e2000c1e9500ULL, 0x000000848f6f7211ULL, 0x000fc600078fe0ffULL,
0x0000000870cb7981ULL, 0x0002e2000c1e9500ULL, 0x000060006b6a7625ULL, 0x000fe200078e0072ULL,
0x000000868f857211ULL, 0x000fe400078fe0ffULL, 0x0000003053b17812ULL, 0x000fe200078efcffULL,
0x00000001787f7824ULL, 0x000fe200078e0269ULL, 0x000000086a747981ULL, 0x0002e4000c1e9500ULL,
0x00000001697d7824ULL, 0x042fe400078e0284ULL, 0x0000000169877824ULL, 0x000fc400078e0286ULL,
0x000060007f7e7625ULL, 0x000fe200078e0072ULL, 0x00005800b1b37a10ULL, 0x000fc60007ffe0ffULL,
0x000060006f6e7625ULL, 0x080fe200078e0072ULL, 0x000000087e817981ULL, 0x0002e6000c1e9500ULL,
0x0000600085687625ULL, 0x080fe200078e0072ULL, 0x000000086ecf7981ULL, 0x0002e6000c1e9500ULL,
0x000060007d7c7625ULL, 0x080fe200078e0072ULL, 0x0000000868d37981ULL, 0x0002e6000c1e9500ULL,
0x00006000876a7625ULL, 0x000fe200078e0072ULL, 0x000000087c8a7981ULL, 0x0002e6000c1e9500ULL,
0x000000011b837824ULL, 0x000fe200078e02b1ULL, 0x000000086a8e7981ULL, 0x0002e6000c1e9500ULL,
0x0000000183857824ULL, 0x000fc400078e0a52ULL, 0x00000001b37f7824ULL, 0x002fc600078e0a52ULL,
0x000000855c857217ULL, 0x040fe40003800000ULL, 0x000000528300720cULL, 0x080fe40003f26070ULL,
0x00000052b300720cULL, 0x000fe40003f06070ULL, 0x0000007f5c7f7217ULL, 0x000fe40003800000ULL,
0x00000004ff857819ULL, 0x000fe40000011685ULL, 0x000000ff7f957207ULL, 0x000fc40000000000ULL,
0x000000ff85857207ULL, 0x000fe40000800000ULL, 0x00000078957d7211ULL, 0x040fe400078fe0ffULL,
0x00000084956b7211ULL, 0x000fe200078fe0ffULL, 0x00000001787f7824ULL, 0x000fe400078e0285ULL,
0x00000001856f7824ULL, 0x000fe400078e0284ULL, 0x000060007d7c7625ULL, 0x000fc800078e0072ULL,
0x000060007f7e7625ULL, 0x080fe200078e0072ULL, 0x000000087cb57981ULL, 0x0002e6000c1e9500ULL,
0x000060006b6a7625ULL, 0x080fe200078e0072ULL, 0x000000087e807981ULL, 0x0002e6000c1e9500ULL,
0x000060006f6e7625ULL, 0x000fe200078e0072ULL, 0x000000086ad17981ULL, 0x0002e2000c1e9500ULL,
0x0000007a95697211ULL, 0x000fc600078fe0ffULL, 0x000000086e8c7981ULL, 0x0002e2000c1e9500ULL,
0x0000000185717824ULL, 0x000fe400078e027aULL, 0x0000600069687625ULL, 0x000fc800078e0072ULL,
0x0000600071707625ULL, 0x000fe200078e0072ULL, 0x0000000868cd7981ULL, 0x0002e4000c1e9500ULL,
0x00000086957d7211ULL, 0x002fe400078fe0ffULL, 0x0000000870887981ULL, 0x0002e2000c1e9500ULL,
0x00000001857f7824ULL, 0x000fe400078e0286ULL, 0x000060007d7c7625ULL, 0x000fc800078e0072ULL,
0x000060007f7e7625ULL, 0x000fe200078e0072ULL, 0x000000087cd57981ULL, 0x0002e8000c1e9500ULL,
0x000000087e907981ULL, 0x0002e2000c1e9500ULL, 0xfffffff06d6d7812ULL, 0x000fe200078ec0ffULL,
0x00000001ffc97424ULL, 0x000fc800078e00ffULL, 0x0000000152687824ULL, 0x000fc800078e026dULL,
0x0000000155697824ULL, 0x000fe200078e0a68ULL, 0x0000000153837812ULL, 0x000fc800078efcffULL,
0x00000069c9697219ULL, 0x000fe400000006ffULL, 0x00005800836b7a10ULL, 0x000fe40007ffe0ffULL,
0x0000000853857812ULL, 0x000fc600078efcffULL, 0x000000016b6a7824ULL, 0x100fe200078e0a68ULL,
0x0000000953877812ULL, 0x000fe400078efcffULL, 0x00005800856f7a10ULL, 0x000fe40007ffe0ffULL,
0x0000006ac96d7219ULL, 0x000fe400000006ffULL, 0x00005800877d7a10ULL, 0x002fe20007ffe0ffULL,
0x000000016f6e7824ULL, 0x000fc800078e0a68ULL, 0x000000017d687824ULL, 0x000fe200078e0a68ULL,
0x00000011538b7812ULL, 0x000fe400078efcffULL, 0xfffffff089897812ULL, 0x000fe400078ec0ffULL,
0x0000006ec9717219ULL, 0x040fe400000006ffULL, 0x00000068c97f7219ULL, 0x000fe200000006ffULL,
0x0000000152707824ULL, 0x000fe200078e0289ULL, 0x000058008b8d7a10ULL, 0x000fe40007ffe0ffULL,
0xfffffff08f8f7812ULL, 0x000fe200078ec0ffULL, 0x0000000165687824ULL, 0x000fc400078e0a70ULL,
0x000000018d6a7824ULL, 0x000fe200078e0a70ULL, 0x0000541054547816ULL, 0x010fc80000000057ULL,
0x0000005469ff7212ULL, 0x000fc800078ac0ffULL, 0x000000525500720cULL, 0x000fc80002fa1470ULL,
0x000000525300720cULL, 0x000fe40002fa1070ULL, 0x000000546dff7212ULL, 0x000fe4000782c0ffULL,
0x0000541056567816ULL, 0x004fe4000000005bULL, 0xff80000051517808ULL, 0x000fe40002800000ULL,
0x0000005669ff7212ULL, 0x000fe4000784c0ffULL, 0x0000541058587816ULL, 0x008fc40000000061ULL,
0x000000566dff7212ULL, 0x000fe400078ac0ffULL, 0x0000005869ff7212ULL, 0x000fe4000788c0ffULL,
0x000000525500720cULL, 0x0c0fe40001741470ULL, 0x000000525500720cULL, 0x080fe40002781470ULL,
0x000000526b00720cULL, 0x0c0fe40000f21470ULL, 0x000000526b00720cULL, 0x000fc40002fa1470ULL,
0x000000525300720cULL, 0x0c0fe40001741070ULL, 0x000000525300720cULL, 0x080fe40002781070ULL,
0x000000528300720cULL, 0x0c0fe40000f21070ULL, 0x000000528300720cULL, 0x000fe40002fa1070ULL,
0x00005410595a7816ULL, 0x000fe4000000005aULL, 0xff8000002c2c7808ULL, 0x000fc40001000000ULL,
0xff8000002d2d7808ULL, 0x000fe40002000000ULL, 0xff8000004a4a7808ULL, 0x000fe40000800000ULL,
0xff8000002b2b7808ULL, 0x000fe40002800000ULL, 0x0000005471ff7212ULL, 0x000fe4000786c0ffULL,
0x0000005a69ff7212ULL, 0x000fe4000780c0ffULL, 0x000000586dff7212ULL, 0x000fc4000784c0ffULL,
0x0000005a6dff7212ULL, 0x000fe4000788c0ffULL, 0x000000567fff7212ULL, 0x000fe4000782c0ffULL,
0x0000005871ff7212ULL, 0x000fe400078ac0ffULL, 0x000000525500720cULL, 0x080fe40000701470ULL,
0x000000526b00720cULL, 0x0c0fe40001741470ULL, 0x000000526b00720cULL, 0x000fc40002781470ULL,
0x000000526f00720cULL, 0x0c0fe40001f61470ULL, 0x000000526f00720cULL, 0x080fe40002fa1470ULL,
0x000000527d00720cULL, 0x080fe20000f21470ULL, 0x0000000152727824ULL, 0x000fe200078e028fULL,
0x0000001853917812ULL, 0x040fe400078efcffULL, 0x0000001953977812ULL, 0x040fe400078efcffULL,
0x000000525300720cULL, 0x000fc40000701070ULL, 0x000000528300720cULL, 0x0c0fe40001741070ULL,
0x000000528300720cULL, 0x080fe40002781070ULL, 0x000000528500720cULL, 0x0c0fe40001f61070ULL,
0x000000528500720cULL, 0x080fe40002fa1070ULL, 0x000000528700720cULL, 0x000fe40000f21070ULL,
0x00000068c9897219ULL, 0x000fc400000006ffULL, 0x0000006ac98f7219ULL, 0x000fe400000006ffULL,
0x0000541062627816ULL, 0x000fe40000000067ULL, 0x0000541064647816ULL, 0x000fe40000000073ULL,
0x0000580091937a10ULL, 0x000fe40007ffe0ffULL, 0x0000580097997a10ULL, 0x000fe40007ffe0ffULL,
0xff80000020207808ULL, 0x000fc40000000000ULL, 0xff8000002a2a7808ULL, 0x000fe40001000000ULL,
0xff8000001f1f7808ULL, 0x000fe40002000000ULL, 0xff8000004f4f7808ULL, 0x000fe40001800000ULL,
0xff80000028287808ULL, 0x000fe40002800000ULL, 0xff80000027277808ULL, 0x000fe40000800000ULL,
0x0000005671ff7212ULL, 0x000fc4000780c0ffULL, 0x000000587fff7212ULL, 0x000fe4000784c0ffULL,
0x0000005a71ff7212ULL, 0x080fe4000788c0ffULL, 0x0000005a7fff7212ULL, 0x000fe4000786c0ffULL,
0x000000628fff7212ULL, 0x000fe400078ac0ffULL, 0x0000006489ff7212ULL, 0x000fe2000782c0ffULL,
0x00000001936e7824ULL, 0x100fe200078e0a70ULL, 0xfffffff095957812ULL, 0x000fe200078ec0ffULL,
0x0000000199707824ULL, 0x000fe200078e0a70ULL, 0x000000526f00720cULL, 0x000fc40000701470ULL,
0x000000526f00720cULL, 0x080fe40002781470ULL, 0x000000527d00720cULL, 0x0c0fe40001741470ULL,
0x000000527d00720cULL, 0x080fe40001f61470ULL, 0x000000526500720cULL, 0x080fe40000f21470ULL,
0x000000528d00720cULL, 0x080fe20002fa1470ULL, 0x00000001527e7824ULL, 0x000fe200078e0295ULL,
0x000000528500720cULL, 0x000fc40000701070ULL, 0x000000528500720cULL, 0x080fe40002781070ULL,
0x000000528700720cULL, 0x0c0fe40001741070ULL, 0x000000528700720cULL, 0x080fe40001f61070ULL,
0x000000526300720cULL, 0x080fe40000f21070ULL, 0x000000528b00720cULL, 0x000fe40002fa1070ULL,
0x0000006ec9957219ULL, 0x000fc400000006ffULL, 0x00000070c99b7219ULL, 0x000fe400000006ffULL,
0x0000541066667816ULL, 0x000fe40000000079ULL, 0x000054106c6c7816ULL, 0x000fe4000000007bULL,
0xff80000029297808ULL, 0x000fe40000000000ULL, 0xff8000001e1e7808ULL, 0x000fe40002000000ULL,
0xff80000026267808ULL, 0x000fc40001000000ULL, 0xff8000001d1d7808ULL, 0x000fe40001800000ULL,
0xff80000025257808ULL, 0x000fe40000800000ULL, 0xff8000004c4c7808ULL, 0x000fe40002800000ULL,
0x0000006289ff7212ULL, 0x080fe4000780c0ffULL, 0x0000006295ff7212ULL, 0x000fe4000788c0ffULL,
0x0000006689ff7212ULL, 0x000fc4000784c0ffULL, 0x0000006c89ff7212ULL, 0x000fe4000786c0ffULL,
0x000000668fff7212ULL, 0x000fe4000782c0ffULL, 0x000000649bff7212ULL, 0x000fe200078ac0ffULL,
0x0000000177787824ULL, 0x000fe200078e0a72ULL, 0x000000526500720cULL, 0x0c0fe40000701470ULL,
0x000000526500720cULL, 0x0c0fe40001741470ULL, 0x000000526500720cULL, 0x000fc40001f61470ULL,
0x000000528d00720cULL, 0x080fe40000f21470ULL, 0x000000529300720cULL, 0x080fe40002781470ULL,
0x000000529900720cULL, 0x080fe40002fa1470ULL, 0x00000021539f7812ULL, 0x000fe400078efcffULL,
0x000000526300720cULL, 0x0c0fe40000701070ULL, 0x000000526300720cULL, 0x000fc40001741070ULL,
0x000000526300720cULL, 0x080fe40001f61070ULL, 0x000000528b00720cULL, 0x080fe40000f21070ULL,
0x000000529100720cULL, 0x080fe40002781070ULL, 0x000000529700720cULL, 0x000fe40002fa1070ULL,
0x00000078c99d7219ULL, 0x000fe400000006ffULL, 0x0000541076767816ULL, 0x000fc400000000cbULL,
0x000058009fa17a10ULL, 0x000fe40007ffe0ffULL, 0xff80000050507808ULL, 0x000fe40000000000ULL,
0xff80000024247808ULL, 0x000fe40001000000ULL, 0xff8000001c1c7808ULL, 0x000fe40001800000ULL,
0xff80000022227808ULL, 0x000fe40000800000ULL, 0xff80000049497808ULL, 0x000fc40002000000ULL,
0xff80000030307808ULL, 0x000fe40002800000ULL, 0x000000648fff7212ULL, 0x040fe4000780c0ffULL,
0x0000006c8fff7212ULL, 0x000fe4000784c0ffULL, 0x0000006495ff7212ULL, 0x000fe4000786c0ffULL,
0x000000669bff7212ULL, 0x040fe4000782c0ffULL, 0x0000006c9bff7212ULL, 0x000fc4000788c0ffULL,
0x000000769dff7212ULL, 0x000fe200078ac0ffULL, 0x00000001a17a7824ULL, 0x000fe200078e0a72ULL,
0x000000528d00720cULL, 0x0c0fe40000701470ULL, 0x000000528d00720cULL, 0x080fe40001741470ULL,
0x000000529300720cULL, 0x080fe40001f61470ULL, 0x000000529900720cULL, 0x0c0fe40000f21470ULL,
0x000000529900720cULL, 0x000fc40002781470ULL, 0x000000527700720cULL, 0x080fe40002fa1470ULL,
0x0000002853a57812ULL, 0x040fe400078efcffULL, 0x0000002953ab7812ULL, 0x000fe400078efcffULL,
0x000000528b00720cULL, 0x0c0fe40000701070ULL, 0x000000528b00720cULL, 0x080fe40001741070ULL,
0x000000529100720cULL, 0x000fc40001f61070ULL, 0x000000529700720cULL, 0x0c0fe40000f21070ULL,
0x000000529700720cULL, 0x080fe40002781070ULL, 0x000000527500720cULL, 0x000fe40002fa1070ULL,
0x0000007ac9a37219ULL, 0x000fe400000006ffULL, 0x0000541074747816ULL, 0x000fe40000000081ULL,
0x00005410cf8a7816ULL, 0x000fc4000000008aULL, 0x00005410d38e7816ULL, 0x000fe4000000008eULL,
0x00005800a5a77a10ULL, 0x000fe40007ffe0ffULL, 0x00005800abad7a10ULL, 0x000fe40007ffe0ffULL,
0xff80000023237808ULL, 0x000fe40000000000ULL, 0xff80000013137808ULL, 0x000fe40001000000ULL,
0xff8000002e2e7808ULL, 0x000fc40001800000ULL, 0xff80000035357808ULL, 0x000fe40000800000ULL,
0xff80000012127808ULL, 0x000fe40002000000ULL, 0xff8000002f2f7808ULL, 0x000fe40002800000ULL,
0x000000547fff7212ULL, 0x000fe400078cc0ffULL, 0x0000006695ff7212ULL, 0x040fe4000780c0ffULL,
0x0000006c95ff7212ULL, 0x000fc4000784c0ffULL, 0x000000749dff7212ULL, 0x040fe4000786c0ffULL,
0x0000008a9dff7212ULL, 0x040fe4000782c0ffULL, 0x0000008e9dff7212ULL, 0x000fe4000788c0ffULL,
0x0000008aa3ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001a77c7824ULL, 0x100fe200078e0a72ULL,
0x000000527d00720cULL, 0x080fe200037c1470ULL, 0x00000001ad727824ULL, 0x000fe200078e0a72ULL,
0x000000529300720cULL, 0x000fc40000701470ULL, 0x000000529300720cULL, 0x080fe40001741470ULL,
0x000000527700720cULL, 0x0c0fe40001f61470ULL, 0x000000527700720cULL, 0x0c0fe40000f21470ULL,
0x000000527700720cULL, 0x080fe40002781470ULL, 0x00000052a100720cULL, 0x080fe40002fa1470ULL,
0x000000528700720cULL, 0x000fc400037c1070ULL, 0x000000529100720cULL, 0x0c0fe40000701070ULL,
0x000000529100720cULL, 0x080fe40001741070ULL, 0x000000527500720cULL, 0x0c0fe40001f61070ULL,
0x000000527500720cULL, 0x0c0fe40000f21070ULL, 0x000000527500720cULL, 0x080fe40002781070ULL,
0x000000529f00720cULL, 0x000fc40002fa1070ULL, 0x0000007cc9a97219ULL, 0x040fe400000006ffULL,
0x00000072c9af7219ULL, 0x000fe400000006ffULL, 0xff8000004b4b7808ULL, 0x000fe40003000000ULL,
0xff80000034347808ULL, 0x000fe40000000000ULL, 0xff80000021217808ULL, 0x000fe40001000000ULL,
0xff8000004e4e7808ULL, 0x000fc40001800000ULL, 0xff80000036367808ULL, 0x000fe40000800000ULL,
0xff80000011117808ULL, 0x000fe40002000000ULL, 0xff80000037377808ULL, 0x000fe40002800000ULL,
0x000000629bff7212ULL, 0x000fe400078cc0ffULL, 0x00000074a3ff7212ULL, 0x080fe4000780c0ffULL,
0x00000074a9ff7212ULL, 0x000fc4000784c0ffULL, 0x00000076a3ff7212ULL, 0x040fe4000786c0ffULL,
0x0000008ea3ff7212ULL, 0x000fe4000782c0ffULL, 0x00000076a9ff7212ULL, 0x000fe4000788c0ffULL,
0x0000008aafff7212ULL, 0x000fe200078ac0ffULL, 0x00000001b3827824ULL, 0x000fe200078e0a7eULL,
0x000000529900720cULL, 0x080fe400037c1470ULL, 0x00000052a100720cULL, 0x000fc40000701470ULL,
0x00000052a100720cULL, 0x0c0fe40001f61470ULL, 0x00000052a100720cULL, 0x080fe40000f21470ULL,
0x00000052a700720cULL, 0x0c0fe40001741470ULL, 0x00000052a700720cULL, 0x080fe40002781470ULL,
0x00000052ad00720cULL, 0x000fe40002fa1470ULL, 0x0000003153b97812ULL, 0x000fc400078efcffULL,
0x0000003853bf7812ULL, 0x040fe400078efcffULL, 0x0000003953c57812ULL, 0x000fe400078efcffULL,
0x000000529700720cULL, 0x080fe400037c1070ULL, 0x000000529f00720cULL, 0x0c0fe40000701070ULL,
0x000000529f00720cULL, 0x0c0fe40001f61070ULL, 0x000000529f00720cULL, 0x000fc40000f21070ULL,
0x00000052a500720cULL, 0x0c0fe40001741070ULL, 0x00000052a500720cULL, 0x080fe40002781070ULL,
0x00000052ab00720cULL, 0x000fe40002fa1070ULL, 0x00000082c9b77219ULL, 0x000fe400000006ffULL,
0x00005410b5807816ULL, 0x000fe40000000080ULL, 0x00005410d18c7816ULL, 0x000fc4000000008cULL,
0x00005800b9bb7a10ULL, 0x000fe40007ffe0ffULL, 0x00005800bfc17a10ULL, 0x000fe40007ffe0ffULL,
0x00005800c5c77a10ULL, 0x000fe40007ffe0ffULL, 0xff8000004d4d7808ULL, 0x000fe40003000000ULL,
0xff80000048487808ULL, 0x000fe40000000000ULL, 0xff80000041417808ULL, 0x000fc40001800000ULL,
0xff8000000a0a7808ULL, 0x000fe40000800000ULL, 0xff80000047477808ULL, 0x000fe40001000000ULL,
0xff80000031317808ULL, 0x000fe40002000000ULL, 0xff80000039397808ULL, 0x000fe40002800000ULL,
0x00000074afff7212ULL, 0x040fe400078cc0ffULL, 0x00000076afff7212ULL, 0x000fc4000780c0ffULL,
0x0000008aa9ff7212ULL, 0x040fe4000786c0ffULL, 0x0000008ea9ff7212ULL, 0x080fe4000782c0ffULL,
0x0000008eafff7212ULL, 0x000fe4000784c0ffULL, 0x00000080b7ff7212ULL, 0x040fe4000788c0ffULL,
0x0000008cb7ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001bb847824ULL, 0x100fe200078e0a7eULL,
0x00000052a700720cULL, 0x080fe20001f61470ULL, 0x00000001c1867824ULL, 0x100fe200078e0a7eULL,
0x00000052a700720cULL, 0x080fe20000f21470ULL, 0x00000001c77e7824ULL, 0x000fe200078e0a7eULL,
0x00000052ad00720cULL, 0x000fc400037c1470ULL, 0x00000052ad00720cULL, 0x0c0fe40000701470ULL,
0x00000052ad00720cULL, 0x080fe40001741470ULL, 0x00000052b300720cULL, 0x0c0fe40002781470ULL,
0x00000052b300720cULL, 0x000fe40002fa1470ULL, 0x00000084c9bd7219ULL, 0x040fe400000006ffULL,
0x00000086c9c37219ULL, 0x000fc400000006ffULL, 0x00000052a500720cULL, 0x0c0fe40001f61070ULL,
0x00000052a500720cULL, 0x080fe40000f21070ULL, 0x00000052ab00720cULL, 0x0c0fe400037c1070ULL,
0x00000052ab00720cULL, 0x0c0fe40000701070ULL, 0x00000052ab00720cULL, 0x080fe40001741070ULL,
0x00000052b100720cULL, 0x000fc40002781070ULL, 0x00000052b100720cULL, 0x000fe40002fa1070ULL,
0x0000007ec9c97219ULL, 0x000fe400000006ffULL, 0x00005410cd887816ULL, 0x000fe40000000088ULL,
0xff80000038387808ULL, 0x000fe40001800000ULL, 0xff8000000b0b7808ULL, 0x000fe40000800000ULL,
0xff80000046467808ULL, 0x000fc40003000000ULL, 0xff8000003a3a7808ULL, 0x000fe40000000000ULL,
0xff8000000c0c7808ULL, 0x000fe40001000000ULL, 0xff80000045457808ULL, 0x000fe40002000000ULL,
0xff80000040407808ULL, 0x000fe40002800000ULL, 0x00000080bdff7212ULL, 0x080fe4000786c0ffULL,
0x00000080c3ff7212ULL, 0x000fc4000782c0ffULL, 0x00000080c9ff7212ULL, 0x000fe400078cc0ffULL,
0x00000088b7ff7212ULL, 0x080fe4000780c0ffULL, 0x00000088bdff7212ULL, 0x080fe4000784c0ffULL,
0x00000088c3ff7212ULL, 0x000fe4000788c0ffULL, 0x0000008cbdff7212ULL, 0x000fe400078ac0ffULL,
0x00000052b300720cULL, 0x000fc40000701470ULL, 0x00000052bb00720cULL, 0x0c0fe40001f61470ULL,
0x00000052bb00720cULL, 0x0c0fe40001741470ULL, 0x00000052bb00720cULL, 0x080fe40002fa1470ULL,
0x00000052c100720cULL, 0x080fe40000f21470ULL, 0x00000052c700720cULL, 0x080fe400037c1470ULL,
0x00000052c100720cULL, 0x000fc40002781470ULL, 0x00000052b100720cULL, 0x080fe40000701070ULL,
0x00000052b900720cULL, 0x0c0fe40001f61070ULL, 0x00000052b900720cULL, 0x0c0fe40001741070ULL,
0x00000052b900720cULL, 0x080fe40002fa1070ULL, 0x00000052bf00720cULL, 0x080fe40000f21070ULL,
0x00000052c500720cULL, 0x000fc400037c1070ULL, 0x00000052bf00720cULL, 0x000fe40002781070ULL,
0x00005410d5907816ULL, 0x000fe40000000090ULL, 0xff80000032327808ULL, 0x000fe40000000000ULL,
0xff80000044447808ULL, 0x000fe40001800000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff8000003b3b7808ULL, 0x000fc40002800000ULL, 0xff80000043437808ULL, 0x000fe40000800000ULL,
0xff80000042427808ULL, 0x000fe40003000000ULL, 0xff8000003f3f7808ULL, 0x000fe40002000000ULL,
0x00000088c9ff7212ULL, 0x000fe4000780c0ffULL, 0x0000008cc3ff7212ULL, 0x080fe4000786c0ffULL,
0x0000008cc9ff7212ULL, 0x000fc4000784c0ffULL, 0x00000090b7ff7212ULL, 0x080fe400078ac0ffULL,
0x00000090bdff7212ULL, 0x080fe4000782c0ffULL, 0x00000090c3ff7212ULL, 0x080fe400078cc0ffULL,
0x00000090c9ff7212ULL, 0x000fe4000788c0ffULL, 0x00000052b300720cULL, 0x080fe40002fa1470ULL,
0x00000052bb00720cULL, 0x000fc40000f21470ULL, 0x00000052c100720cULL, 0x0c0fe40001f61470ULL,
0x00000052c100720cULL, 0x080fe400037c1470ULL, 0x00000052c700720cULL, 0x0c0fe40000701470ULL,
0x00000052c700720cULL, 0x0c0fe40001741470ULL, 0x00000052c700720cULL, 0x080fe40002781470ULL,
0x00000052b100720cULL, 0x000fc40002fa1070ULL, 0x00000052b900720cULL, 0x080fe40000f21070ULL,
0x00000052c500720cULL, 0x080fe40000701070ULL, 0x00000052bf00720cULL, 0x0c0fe40001f61070ULL,
0x00000052bf00720cULL, 0x080fe400037c1070ULL, 0x00000052c500720cULL, 0x0c0fe40001741070ULL,
0x00000052c500720cULL, 0x000fc40002781070ULL, 0xff8000003e3e7808ULL, 0x000fe40000000000ULL,
0xff8000003c3c7808ULL, 0x000fe40001800000ULL, 0xff8000003d3d7808ULL, 0x000fe40001000000ULL,
0xff8000000d0d7808ULL, 0x000fe40002800000ULL, 0xff8000000e0e7808ULL, 0x000fe40000800000ULL,
0xff8000000f0f7808ULL, 0x000fc40003000000ULL, 0xff80000010107808ULL, 0x000fc40002000000ULL,
0x000000510400720bULL, 0x004fe40003f1e000ULL, 0x0000002c0500720bULL, 0x000fe40003f3e000ULL,
0x0000002d0600720bULL, 0x000fe40003f5e000ULL, 0x000000200700720bULL, 0x000fe40003f7e000ULL,
0x0000000451537208ULL, 0x000fe40004000000ULL, 0x000000052c047208ULL, 0x000fc40004800000ULL,
0x000000062d057208ULL, 0x000fe40005000000ULL, 0x0000000720067208ULL, 0x000fe40005800000ULL,
0x0000004a5300720bULL, 0x000fe40003f1e000ULL, 0x0000002b0400720bULL, 0x000fe40003f3e000ULL,
0x0000002a0500720bULL, 0x000fe40003f5e000ULL, 0x0000001f0600720bULL, 0x000fc40003f7e000ULL,
0x000000534a527208ULL, 0x000fe40004000000ULL, 0x000000042b047208ULL, 0x000fe40004800000ULL,
0x000000052a057208ULL, 0x000fe40005000000ULL, 0x000000061f077208ULL, 0x000fe40005800000ULL,
0x0000004f5200720bULL, 0x000fe40003f1e000ULL, 0x000000290400720bULL, 0x000fc40003f3e000ULL,
0x000000280500720bULL, 0x000fe40003f5e000ULL, 0x0000001e0700720bULL, 0x000fe40003f7e000ULL,
0x000000524f527208ULL, 0x000fe40004000000ULL, 0x0000000429047208ULL, 0x000fe40004800000ULL,
0x0000000528057208ULL, 0x000fe40005000000ULL, 0x000000071e067208ULL, 0x000fc40005800000ULL,
0x0000004b5200720bULL, 0x000fe40003f1e000ULL, 0x000000270400720bULL, 0x000fe40003f3e000ULL,
0x000000260500720bULL, 0x000fe40003f5e000ULL, 0x0000001d0600720bULL, 0x000fe40003f7e000ULL,
0x000000524b077208ULL, 0x000fe40004000000ULL, 0x0000000427047208ULL, 0x000fc40004800000ULL,
0x0000000526057208ULL, 0x000fe40005000000ULL, 0x000000061d537208ULL, 0x000fe40005800000ULL,
0x000000500700720bULL, 0x000fe40003f1e000ULL, 0x000000250400720bULL, 0x000fe40003f3e000ULL,
0x000000240500720bULL, 0x000fe40003f5e000ULL, 0x0000001c5300720bULL, 0x000fc40003f7e000ULL,
0x0000000750077208ULL, 0x000fe40004000000ULL, 0x0000000425047208ULL, 0x000fe40004800000ULL,
0x0000000524057208ULL, 0x000fe40005000000ULL, 0x000000531c067208ULL, 0x000fe40005800000ULL,
0x0000004c0700720bULL, 0x000fe40003f1e000ULL, 0x000000230400720bULL, 0x000fc40003f3e000ULL,
0x000000220500720bULL, 0x000fe40003f5e000ULL, 0x000000130600720bULL, 0x000fe40003f7e000ULL,
0x000000074c527208ULL, 0x000fe40004000000ULL, 0x0000000423077208ULL, 0x000fe40004800000ULL,
0x0000000522057208ULL, 0x000fe40005000000ULL, 0x0000000613067208ULL, 0x000fc40005800000ULL,
0x000000495200720bULL, 0x000fe40003f1e000ULL, 0x0000002e0700720bULL, 0x000fe40003f3e000ULL,
0x000000340500720bULL, 0x000fe40003f5e000ULL, 0x000000210600720bULL, 0x000fe40003f7e000ULL,
0x0000005249527208ULL, 0x000fe40004000000ULL, 0x000000072e077208ULL, 0x000fc40004800000ULL,
0x0000000534047208ULL, 0x000fe40005000000ULL, 0x0000000621057208ULL, 0x000fe40005800000ULL,
0x0000004d5200720bULL, 0x000fe40003f1e000ULL, 0x000000300700720bULL, 0x000fe40003f3e000ULL,
0x000000350400720bULL, 0x000fe40003f5e000ULL, 0x000000120500720bULL, 0x000fc40003f7e000ULL,
0x000000524d537208ULL, 0x000fe40004000000ULL, 0x0000000730067208ULL, 0x000fe40004800000ULL,
0x0000000435077208ULL, 0x000fe40005000000ULL, 0x0000000512047208ULL, 0x000fe40005800000ULL,
0x0000004e5300720bULL, 0x000fe40003f1e000ULL, 0x000000360700720bULL, 0x000fc40003f5e000ULL,
0x0000002f0600720bULL, 0x000fe40003f3e000ULL, 0x000000110400720bULL, 0x000fe40003f7e000ULL,
0x000000534e537208ULL, 0x000fe40004000000ULL, 0x0000000736527208ULL, 0x000fe40005000000ULL,
0x000000062f067208ULL, 0x000fe40004800000ULL, 0x0000000411057208ULL, 0x000fc40005800000ULL,
0x000000485300720bULL, 0x000fe40003f1e000ULL, 0x000000375200720bULL, 0x000fe40003f5e000ULL,
0x000000410600720bULL, 0x000fe40003f3e000ULL, 0x0000000a0500720bULL, 0x000fe40003f7e000ULL,
0x0000005348047208ULL, 0x000fe40004000000ULL, 0x0000005237077208ULL, 0x000fc40005000000ULL,
0x0000000641067208ULL, 0x000fe40004800000ULL, 0x000000050a527208ULL, 0x000fe40005800000ULL,
0x000000470400720bULL, 0x000fe40003f1e000ULL, 0x000000380700720bULL, 0x000fe40003f5e000ULL,
0x000000310600720bULL, 0x000fe40003f3e000ULL, 0x0000000b5200720bULL, 0x000fc40003f7e000ULL,
0x0000000447057208ULL, 0x000fe40004000000ULL, 0x0000000738047208ULL, 0x000fe40005000000ULL,
0x0000000631537208ULL, 0x000fe40004800000ULL, 0x000000520b077208ULL, 0x000fe40005800000ULL,
0x000000460500720bULL, 0x000fe40003f1e000ULL, 0x000000390400720bULL, 0x000fc40003f5e000ULL,
0x0000003a5300720bULL, 0x000fe40003f3e000ULL, 0x0000000c0700720bULL, 0x000fe40003f7e000ULL,
0x0000000546067208ULL, 0x000fe40004000000ULL, 0x0000000439057208ULL, 0x000fe40005000000ULL,
0x000000533a537208ULL, 0x000fe40004800000ULL, 0x000000070c047208ULL, 0x000fc40005800000ULL,
0x000000450600720bULL, 0x000fe40003f1e000ULL, 0x000000400500720bULL, 0x000fe40003f5e000ULL,
0x000000325300720bULL, 0x000fe40003f3e000ULL, 0x0000000d0400720bULL, 0x000fe40003f7e000ULL,
0x0000000645077208ULL, 0x000fe40004000000ULL, 0x0000000540527208ULL, 0x000fc40005000000ULL,
0x0000005332067208ULL, 0x000fe40004800000ULL, 0x000000040d057208ULL, 0x000fe40005800000ULL,
0x000000440700720bULL, 0x000fe40003f1e000ULL, 0x0000003b5200720bULL, 0x000fe40003f5e000ULL,
0x000000330600720bULL, 0x000fe40003f3e000ULL, 0x0000000e0500720bULL, 0x000fc40003f7e000ULL,
0x0000000744047208ULL, 0x000fe40004000000ULL, 0x000000523b077208ULL, 0x000fe40005000000ULL,
0x0000000633067208ULL, 0x000fe40004800000ULL, 0x000000050e527208ULL, 0x000fe40005800000ULL,
0x000000430400720bULL, 0x000fe40003f1e000ULL, 0x0000003c0700720bULL, 0x000fc40003f5e000ULL,
0x0000003f0600720bULL, 0x000fe40003f3e000ULL, 0x0000000f5200720bULL, 0x000fe40003f7e000ULL,
0x0000000443057208ULL, 0x000fe40004000000ULL, 0x000000073c047208ULL, 0x000fe40005000000ULL,
0x000000063f537208ULL, 0x000fe40004800000ULL, 0x000000520f077208ULL, 0x000fc40005800000ULL,
0x000000420500720bULL, 0x000fe40003f1e000ULL, 0x0000003e5300720bULL, 0x000fe40003f3e000ULL,
0x0000003d0400720bULL, 0x000fe40003f5e000ULL, 0x000000100700720bULL, 0x000fe40003f7e000ULL,
0x0000000542057208ULL, 0x000fe40004000000ULL, 0x000000533e547208ULL, 0x000fc40004800000ULL,
0x000000043d587208ULL, 0x000fe40005000000ULL, 0x0000000710577208ULL, 0x000fe20005800000ULL,
0x000022727f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x0004e400000e0000ULL,
0x000000040500720bULL, 0x008fc80003f1e000ULL, 0x0000000504597208ULL, 0x000fe20004000000ULL,
0x000022b27f007947ULL, 0x000fea000b800000ULL, 0x0c401f0054047f89ULL, 0x000ee800000e0000ULL,
0x0c401f0058057f89ULL, 0x004ea800000e0000ULL, 0x0c401f0057067f89ULL, 0x000f2200000e0000ULL,
0x000000045400720bULL, 0x008fc40003f1e000ULL, 0x000000055800720bULL, 0x004fe40003f3e000ULL,
0x0000005404077208ULL, 0x002fe40004000000ULL, 0x0000005805527208ULL, 0x000fe20004800000ULL,
0x0c201f0059047f89ULL, 0x000e6200000e0000ULL, 0x000000065700720bULL, 0x010fc60003f1e000ULL,
0x0c201f0007567f89ULL, 0x000ea200000e0000ULL, 0x0000005706547208ULL, 0x000fc60004000000ULL,
0x0c201f0052537f89ULL, 0x000ee800000e0000ULL, 0x0c201f0054557f89ULL, 0x0002e400000e0000ULL,
0x000000045900720bULL, 0x002fe40003f1e000ULL, 0x000000560700720bULL, 0x004fe40003f3e000ULL,
0x0000005904047208ULL, 0x000fc40004000000ULL, 0x000000535200720bULL, 0x008fe40003f5e000ULL,
0x0000000756057208ULL, 0x000fe40004800000ULL, 0x0000005253067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL, 0x000000555400720bULL, 0x004fe20003f1e000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000002ff687819ULL, 0x000fe20000011603ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b49567823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b51517823ULL, 0x100fe20000010807ULL, 0x0000004c00537308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b4a4a7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4d4d7823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b4e497823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b48487823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL, 0x0000004a004a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b46467823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b45457823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b44447823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010807ULL,
0x0000004f004f7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b42427823ULL, 0x000fe40000010807ULL,
0x3fb8aa3b06077820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b054c7820ULL, 0x002fe40000410000ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL, 0x0000004b00527308ULL, 0x000e620000000800ULL,
0x3fb8aa3b2a2a7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b28287823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b26267823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b24247823ULL, 0x100fe20000010807ULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b22227823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b34347823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b35357823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010807ULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b37377823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b38387823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b39397823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010807ULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3b3b7823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b3d3d7823ULL, 0x000fe20000010807ULL,
0x0000005455077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001084cULL,
0x0000003b005b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe2000001084cULL,
0x0000000303ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b29297823ULL, 0x100fe4000001084cULL,
0x3fb8aa3b27277823ULL, 0x000fc4000001084cULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001084cULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b23237823ULL, 0x100fe4000001084cULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe4000001084cULL, 0x3fb8aa3b30307823ULL, 0x100fe4000001084cULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001084cULL, 0x0000002300587308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b41417823ULL, 0x000fc4000001084cULL, 0x3fb8aa3b31317823ULL, 0x100fe4000001084cULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe4000001084cULL, 0x3fb8aa3b32327823ULL, 0x100fe2000001084cULL,
0x0000002b002b7308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b33337823ULL, 0x100fe4000001084cULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe4000001084cULL, 0x3fb8aa3b3e3e7823ULL, 0x000fc4000001084cULL,
0x0000000868657824ULL, 0x040fe200078e00ffULL, 0x00000038004c7308ULL, 0x0007e20000000800ULL,
0x00000008686d7824ULL, 0x040fe400078e00ffULL, 0x0000000868677824ULL, 0x000fca00078e00ffULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b07387820ULL, 0x008fc80000410000ULL,
0x3fb8aa3b20207823ULL, 0x100fe40000010838ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010838ULL,
0x00000027004e7308ULL, 0x000ee20000000800ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe40000010838ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe40000010838ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe40000010838ULL,
0x3fb8aa3b13137823ULL, 0x100fe20000010838ULL, 0x0000002600237308ULL, 0x000f220000000800ULL,
0x3fb8aa3b21217823ULL, 0x000fc40000010838ULL, 0x3fb8aa3b12127823ULL, 0x100fe40000010838ULL,
0x3fb8aa3b11117823ULL, 0x100fe40000010838ULL, 0x3fb8aa3b0a0a7823ULL, 0x000fe20000010838ULL,
0x0000002000547308ULL, 0x0003f00000000800ULL, 0x0000001f003b7308ULL, 0x0005e20000000800ULL,
0x0000000868207824ULL, 0x002fce00078e00ffULL, 0x0000001e00557308ULL, 0x0003e20000000800ULL,
0x00000003681f7810ULL, 0x004fc80007ffe0ffULL, 0xfffffff820697812ULL, 0x000fe400078ee21fULL,
0x00000006681f7810ULL, 0x040fe20007ffe0ffULL, 0x0000001d00647308ULL, 0x0004e20000000800ULL,
0x00000005681e7810ULL, 0x002fc80007ffe0ffULL, 0xfffffff86d6d7812ULL, 0x000fe400078ee21eULL,
0x0000004f521e723eULL, 0x000fe200000000ffULL, 0x0000003300627308ULL, 0x000fe20000000800ULL,
0x00000004681d7810ULL, 0x004fe20007ffe0ffULL, 0x3fb8aa3b10527823ULL, 0x100fe40000010838ULL,
0x3fb8aa3b0e4f7823ULL, 0x100fe20000010838ULL, 0xfffffff8206b7812ULL, 0x000fe400078ee21dULL,
0x0000002c2b1d723eULL, 0x000fe200000000ffULL, 0x0000001c00617308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b0b2b7823ULL, 0x000fce0000010838ULL, 0x0000002200337308ULL, 0x0005e20000000800ULL,
0x00000008681c7824ULL, 0x002fca00078e00ffULL, 0xfffffff81c6f7812ULL, 0x000fe400078ee21fULL,
0x0000001300667308ULL, 0x0003220000000800ULL, 0x0000000168227810ULL, 0x004fe40007ffe0ffULL,
0x000000514a1c723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b0f517823ULL, 0x000fe20000010838ULL,
0xfffffff865657812ULL, 0x000fe400078ee222ULL, 0x000000294e1f723eULL, 0x008fe200000000ffULL,
0x00000041005a7308ULL, 0x000fe20000000800ULL, 0xffffffff68137810ULL, 0x002fe20007ffe0ffULL,
0x3fb8aa3b0d4e7823ULL, 0x000fe20000010838ULL, 0x000000282322723eULL, 0x010fc400000000ffULL,
0xfffffff820717812ULL, 0x000fe400078ee213ULL, 0x0000002d2a20723eULL, 0x000fe200000000ffULL,
0x0000003200597308ULL, 0x000fe20000000800ULL, 0x000000556423723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b0c2d7823ULL, 0x000fe20000010838ULL, 0x000000616629723eULL, 0x000fca00000000ffULL,
0x0000003400327308ULL, 0x0003f00000000800ULL, 0x0000003500417308ULL, 0x0004e20000000800ULL,
0x3c003c00ff347424ULL, 0x002fce00078e00ffULL, 0x0000003000577308ULL, 0x000fe20000000800ULL,
0x3c003c00ff357424ULL, 0x004fce00078e00ffULL, 0x0000002100637308ULL, 0x0003e20000000800ULL,
0x00000032412a723eULL, 0x008fe200000000ffULL, 0x0000000868417824ULL, 0x000fca00078e00ffULL,
0xfffffff841417812ULL, 0x000fe200078ee268ULL, 0x0000002400307308ULL, 0x0004e20000000800ULL,
0x000000543b21723eULL, 0x002fce00000000ffULL, 0x00000025004b7308ULL, 0x0003220000000800ULL,
0x0000000268247810ULL, 0x004fc80007ffe0ffULL, 0xfffffff867677812ULL, 0x000fc600078ee224ULL,
0x00000012002c7308ULL, 0x000fe20000000800ULL, 0x000000341c24723cULL, 0x002f6200000018ffULL,
0x000000303328723eULL, 0x008fcc00000000ffULL, 0x00000011004a7308ULL, 0x0003e20000000800ULL,
0x0000004b580d723eULL, 0x010fe400000000ffULL, 0x00000008684b7810ULL, 0x000fca0007ffe0ffULL,
0x0000005000507308ULL, 0x000ea20000000800ULL, 0x000000342010723cULL, 0x002f6e00000018ffULL,
0x0000005600567308ULL, 0x000ff00000000800ULL, 0x0000004d004d7308ULL, 0x000e620000000800ULL,
0x00000050530c723eULL, 0x004fc400000000ffULL, 0x0000001868537810ULL, 0x000fca0007ffe0ffULL,
0x0000002e002e7308ULL, 0x000ea20000000800ULL, 0x0000000853307824ULL, 0x000fca00078e00ffULL,
0xfffffff830537812ULL, 0x000fe400078ee253ULL, 0x000000564d0e723eULL, 0x002fe200000000ffULL,
0x0000002b003b7308ULL, 0x0003e20000000800ULL, 0x00000010684d7810ULL, 0x000fe40007ffe0ffULL,
0x0000002e570f723eULL, 0x004fca00000000ffULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x000000632c2b723eULL, 0x002fe200000000ffULL, 0x000000084b2c7824ULL, 0x000fe400078e00ffULL,
0x000000084d2e7824ULL, 0x000fe200078e00ffULL, 0x000000340c24723cULL, 0x020f640000001824ULL,
0xfffffff82c4b7812ULL, 0x000fe200078ee24bULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0xfffffff82e4d7812ULL, 0x000fc800078ee24dULL, 0x000000342810723cULL, 0x000f660000001810ULL,
0x0000003a003a7308ULL, 0x000ff00000000800ULL, 0x0000004900497308ULL, 0x000ff00000000800ULL,
0x0000004800487308ULL, 0x000e700000000800ULL, 0x0000004700477308ULL, 0x000ff00000000800ULL,
0x0000004600467308ULL, 0x000ea20000000800ULL, 0x00000049482c723eULL, 0x002fce00000000ffULL,
0x0000003900397308ULL, 0x000ff00000000800ULL, 0x0000000a000b7308ULL, 0x000fe20000000800ULL,
0x00000047462e723eULL, 0x004fce00000000ffULL, 0x0000003600367308ULL, 0x000ff00000000800ULL,
0x0000003700377308ULL, 0x000e700000000800ULL, 0x0000002d000a7308ULL, 0x0004e20000000800ULL,
0x000000363738723eULL, 0x002fce00000000ffULL, 0x0000004500457308ULL, 0x000fe20000000800ULL,
0x0000002f5a2d723eULL, 0x004fe400000000ffULL, 0x000000313a2f723eULL, 0x000fe400000000ffULL,
0x0000004c393a723eULL, 0x000fe400000000ffULL, 0x0000004a0b39723eULL, 0x000fe200000000ffULL,
0x0000004400447308ULL, 0x000e620000000800ULL, 0x0000003b0a3b723eULL, 0x008fe200000000ffULL,
0x000000342c24723cULL, 0x020f620000001824ULL, 0x000120001a367811ULL, 0x000fc400078e60ffULL,
0x0000000c090a7812ULL, 0x000fe400078ec0ffULL, 0x000000596231723eULL, 0x000fe200000000ffULL,
0x0000004300437308ULL, 0x000fe20000000800ULL, 0x0000001041417824ULL, 0x100fe200078e0236ULL,
0x000000343810723cULL, 0x000fe20000001810ULL, 0x0000001065657824ULL, 0x100fe400078e0236ULL,
0x0000001067677824ULL, 0x100fe400078e0236ULL, 0x0000001069697824ULL, 0x100fe200078e0236ULL,
0x0000004200427308ULL, 0x000ea20000000800ULL, 0x000000454430723eULL, 0x002fe200000000ffULL,
0x000000106b6b7824ULL, 0x000fc400078e0236ULL, 0x0000000141097824ULL, 0x000fe400078e020aULL,
0x000000106d6d7824ULL, 0x100fe400078e0236ULL, 0x0000003f003f7308ULL, 0x000fe20000000800ULL,
0x000000010a657824ULL, 0x040fe200078e0265ULL, 0x0000001c09007388ULL, 0x0003e20000000800ULL,
0x000000106f6f7824ULL, 0x100fe400078e0236ULL, 0x000000010a677824ULL, 0x000fe200078e0267ULL,
0x0000001e65007388ULL, 0x0007e20000000800ULL, 0x0000001071717824ULL, 0x100fe200078e0236ULL,
0x0000003e003e7308ULL, 0x000f220000000800ULL, 0x000000434232723eULL, 0x004fe200000000ffULL,
0x000000010a697824ULL, 0x000fe200078e0269ULL, 0x0000000c67007388ULL, 0x0007e20000000800ULL,
0x000000104b4b7824ULL, 0x000fc400078e0236ULL, 0x000000010a6b7824ULL, 0x040fe200078e026bULL,
0x0000000e69007388ULL, 0x0007e20000000800ULL, 0x0000004000407308ULL, 0x000ea20000000800ULL,
0x000000010a6d7824ULL, 0x040fe400078e026dULL, 0x000000010a6f7824ULL, 0x040fe200078e026fULL,
0x0000002c6b007388ULL, 0x0007e20000000800ULL, 0x000000010a717824ULL, 0x040fe400078e0271ULL,
0x000000010a1c7824ULL, 0x002fe200078e024bULL, 0x0000003c003c7308ULL, 0x000fe20000000800ULL,
0x0000003f3e33723eULL, 0x010fe200000000ffULL, 0x0000002e6d007388ULL, 0x0007e20000000800ULL,
0x000000104d4d7824ULL, 0x000fc400078e0236ULL, 0x0000001053537824ULL, 0x000fe200078e0236ULL,
0x000000306f007388ULL, 0x0007e20000000800ULL, 0x000000010a4d7824ULL, 0x040fe200078e024dULL,
0x0000003d003d7308ULL, 0x000e620000000800ULL, 0x000000405b40723eULL, 0x004fe200000000ffULL,
0x000000343024723cULL, 0x020f620000001824ULL, 0x0000003271007388ULL, 0x0007e20000000800ULL,
0x000000010a0a7824ULL, 0x000fc600078e0253ULL, 0x0000001d1c007388ULL, 0x0007e20000000800ULL,
0x0000004e004e7308ULL, 0x000fe60000000800ULL, 0x0004001f65007388ULL, 0x0007e80000000800ULL,
0x0004000d67007388ULL, 0x0007e20000000800ULL, 0x0000004f004f7308ULL, 0x000ea20000000800ULL,
0x0000003c3d42723eULL, 0x002fc400000000ffULL, 0x0004000f69007388ULL, 0x0007e80000000800ULL,
0x0004002d6b007388ULL, 0x0007e20000000800ULL, 0x0000005100517308ULL, 0x000fe40000000800ULL,
0x000000ffff257224ULL, 0x020fe200078e0026ULL, 0x0004002f6d007388ULL, 0x0007e80000000800ULL,
0x000400316f007388ULL, 0x0007e20000000800ULL, 0x0000005200527308ULL, 0x000e620000000800ULL,
0x0000004e4f41723eULL, 0x004fc400000000ffULL, 0x0004003371007388ULL, 0x0007e80000000800ULL,
0x000000204d007388ULL, 0x0007e80000000800ULL, 0x0008002265007388ULL, 0x0007e80000000800ULL,
0x0008002867007388ULL, 0x0007e20000000800ULL, 0x000000515243723eULL, 0x002fc600000000ffULL,
0x0008002a69007388ULL, 0x0007e80000000800ULL, 0x000000344010723cULL, 0x000f620000001810ULL,
0x000800386b007388ULL, 0x0007e80000000800ULL, 0x0008003a6d007388ULL, 0x0007e80000000800ULL,
0x000800406f007388ULL, 0x0007e80000000800ULL, 0x0008004271007388ULL, 0x0007e80000000800ULL,
0x000000210a007388ULL, 0x0007e80000000800ULL, 0x000c002365007388ULL, 0x0007e60000000800ULL,
0x000000ffff267224ULL, 0x020fe200078e0010ULL, 0x000c002967007388ULL, 0x0007e20000000800ULL,
0x000000ffff277224ULL, 0x000fc600078e0012ULL, 0x000c002b69007388ULL, 0x0007e80000000800ULL,
0x000c00396b007388ULL, 0x0007e80000000800ULL, 0x000c003b6d007388ULL, 0x0007e80000000800ULL,
0x000c00416f007388ULL, 0x0007e80000000800ULL, 0x000c004371007388ULL, 0x0007e80000000800ULL,
0x01a0000408008388ULL, 0x0007e80000000c00ULL, 0x01a2002408008388ULL, 0x0007e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000005dff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008005dff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010005dff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000015e5e7810ULL, 0x000fe20007ffe0ffULL,
0x000018005dff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff637224ULL, 0x000fc400078e0017ULL,
0x000000155e00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff8dc000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff257807ULL, 0x008fe20004000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0001778000267802ULL, 0x000fc40000000f00ULL, 0x0000140000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff007224ULL, 0x000fe200078e0025ULL, 0xfffeaf3000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe20005800000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x000177e000267802ULL, 0x000fc40000000f00ULL, 0x000013a000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e0025ULL, 0xfffeaf6000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001784000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x000012f000007944ULL, 0x002fea0003c00000ULL,
0xfffeb02000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001789000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x000012a000007944ULL, 0x002fea0003c00000ULL, 0xfffeb14000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x000178e000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000125000007944ULL, 0x002fea0003c00000ULL,
0xfffeb26000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001793000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000120000007944ULL, 0x002fea0003c00000ULL, 0xfffeb37000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0002ULL, 0x0001799000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x000011a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xfffeb78000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x000179f000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000114000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x0000001002267810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x00017a5000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x000010e000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xfffeb71000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x00017ab000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000108000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xfffeb6e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x00017b1000267802ULL, 0x000fc40000000f00ULL,
0x0000107000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0025ULL,
0xfffed7e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe20005800000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x00017b7000267802ULL, 0x000fc40000000f00ULL,
0x0000101000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff707224ULL, 0x000fe200078e0025ULL,
0xfffed82000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x00017bd000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000f6000007944ULL, 0x004fea0003c00000ULL, 0xfffed8e000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x00017c2000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000f1000007944ULL, 0x006fea0003c00000ULL,
0xfffeda0000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x00017c7000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000ec000007944ULL, 0x00efea0003c00000ULL, 0xfffedb2000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x00017cc000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000e7000007944ULL, 0x00efea0003c00000ULL,
0xfffedc3000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e001eULL,
0x00017d2000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000e1000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xfffee03000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x00017d8000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000db000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x000000101e267810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x00017de000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000d5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xfffedfc000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x00017e4000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000cf000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xfffedf9000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe20004000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x00017ea000267802ULL, 0x000fc40000000f00ULL, 0x00000ce000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff727224ULL, 0x000fe200078e0025ULL, 0xffff000000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe20005800000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x00017f0000267802ULL, 0x000fc40000000f00ULL, 0x00000c8000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff237224ULL, 0x000fe200078e0025ULL, 0xffff004000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x00017f6000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000bd000007944ULL, 0x002fea0003c00000ULL,
0xffff010000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x00017fb000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000b8000007944ULL, 0x002fea0003c00000ULL, 0xffff022000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001800000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x00000b3000007944ULL, 0x002fea0003c00000ULL,
0xffff034000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001805000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000ae000007944ULL, 0x002fea0003c00000ULL, 0xffff045000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0024ULL, 0x000180b000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000a8000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e0026ULL,
0xffff085000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001811000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x00000a2000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e0026ULL,
0x0000001024267810ULL, 0x000fe20007ffe0ffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001817000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x000009c000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e0026ULL,
0xffff07e000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x000181d000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000096000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e0026ULL,
0xffff07b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001823000267802ULL, 0x000fc40000000f00ULL,
0x0000095000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff217224ULL, 0x000fe200078e0025ULL,
0xffff26d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe20005800000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001829000267802ULL, 0x000fc40000000f00ULL,
0x000008f000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff6c7224ULL, 0x000fe200078e0025ULL,
0xffff271000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x000182f000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x0000084000007944ULL, 0x000fea0003c00000ULL, 0xffff27d000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001834000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x000007f000007944ULL, 0x002fea0003c00000ULL,
0xffff28f000007947ULL, 0x000fea000383ffffULL, 0x0000001fff6b7424ULL, 0x000fe200078e00ffULL,
0x0001839000257802ULL, 0x000fe20000000f00ULL, 0xffffffffff6a7424ULL, 0x000fc400078e00ffULL,
0x000007a000007944ULL, 0x002fea0003c00000ULL, 0xffff2a1000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x000183e000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000075000007944ULL, 0x002fea0003c00000ULL,
0xffff2b2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e000aULL,
0x0001844000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x000006f000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e0026ULL, 0xffff2f1000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x000184a000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000069000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0026ULL, 0x000000100a267810ULL, 0x000fe20007ffe0ffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001850000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x0000063000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff057224ULL, 0x004fe200078e0026ULL, 0xffff2ea000007947ULL, 0x000fea000383ffffULL,
0x0000001fff6b7424ULL, 0x000fe200078e00ffULL, 0x0001856000257802ULL, 0x000fe20000000f00ULL,
0xffffffffff6a7424ULL, 0x000fc400078e00ffULL, 0x000005d000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0026ULL, 0xffff2e7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x000fe200078e0005ULL, 0x000185e000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff567424ULL, 0x000fc400078e00ffULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e0055ULL, 0xffffdd2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x002fe200078e0054ULL, 0x0001866000527802ULL, 0x000fe20000000f00ULL,
0x00000002ff567424ULL, 0x000fe400078e00ffULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x004fea0003c00000ULL,
0x000000555400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0058ULL,
0x000186e000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff567424ULL, 0x000fe200078e00ffULL,
0x0000005455067208ULL, 0x000fe20004000000ULL, 0x0000001fff557424ULL, 0x000fc400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x000000555800720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0057ULL,
0x0001876000527802ULL, 0x000fe20000000f00ULL, 0x00000002ff567424ULL, 0x000fe200078e00ffULL,
0x0000005855587208ULL, 0x000fe20004000000ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x000000555700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0059ULL,
0x000187e000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff567424ULL, 0x000fe200078e00ffULL,
0x0000005755547208ULL, 0x000fe20004000000ULL, 0x0000001fff557424ULL, 0x000fc400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000555900720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0006ULL,
0x0001886000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff567424ULL, 0x000fe200078e00ffULL,
0x0000005955047208ULL, 0x000fe20004000000ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x000000550600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0058ULL,
0x000188e000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff567424ULL, 0x000fe200078e00ffULL,
0x0000000655057208ULL, 0x000fe20004000000ULL, 0x0000001fff557424ULL, 0x000fc400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000555800720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0054ULL,
0x0001896000527802ULL, 0x000fe20000000f00ULL, 0x00000001ff567424ULL, 0x000fe200078e00ffULL,
0x0000005855067208ULL, 0x000fe20004000000ULL, 0x0000001fff557424ULL, 0x000fe400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffdb1000007947ULL, 0x000fea000383ffffULL, 0x0180000022007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000002200008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff22ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000022027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002200007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe751002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff537424ULL, 0x000fe200078e00ffULL,
0x0000005a00007348ULL, 0x000fe80003800000ULL, 0x0c00005607557389ULL, 0x0002a200000e0055ULL,
0xfffe74d052007950ULL, 0x000fea0003c3ffffULL, 0x0000006a00007348ULL, 0x000fe80003800000ULL,
0x0000002627267389ULL, 0x0002a400000e006bULL, 0x000000ffff6a7224ULL, 0x002fc400078e0025ULL,
0x00000000ff6b7424ULL, 0x000fc800078e00ffULL, 0xfffe74806a007950ULL, 0x000fea0003c3ffffULL,
0x000000012500780cULL, 0x000fe20003f65070ULL, 0x0000002700007348ULL, 0x000fd80003800000ULL,
0x0000000000257806ULL, 0x000fc800058e0100ULL, 0x0000002725257212ULL, 0x000fe200078ec0ffULL,
0x00000000ff277424ULL, 0x000fc800078e00ffULL, 0xfffe742026007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000560ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c0ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000930ULL,
0x0000000000000338ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c68ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d28ULL,
0x00000000000008a0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015c8ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015d8ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001668ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x000000000000166cULL,
0x00000000000001b8ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x0000000000018c80ULL, 0xd800001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001a500ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001a540ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001a8c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001668ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000018e98ULL,
0x0000000000018e98ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001a500ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001a8c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_0_m_32_sm_80_cubin_len = 108960;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
