/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000146d0ULL, 0x0000000000014350ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL, 0x497461324545386aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x386a4c4536316a4cULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL, 0x632e766e2e006675ULL,
0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL, 0x756265642e006d61ULL,
0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL, 0x642e616c65722e00ULL,
0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL, 0x000000000000006eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b0ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003feULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000443ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b002200000489ULL, 0x0000000000012790ULL, 0x0000000000000180ULL,
0x000b0022000004bcULL, 0x0000000000012910ULL, 0x0000000000000040ULL, 0x000b0022000004e7ULL,
0x0000000000012950ULL, 0x0000000000000050ULL, 0x000b002200000511ULL, 0x00000000000129a0ULL,
0x0000000000000160ULL, 0x000a00030000057fULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000400030000059fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005cfULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000012b00ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001279000000000ULL, 0x0000040400000000ULL,
0x810c000001340400ULL, 0x0048a40400288080ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x9008288080820828ULL, 0x2880809408288080ULL, 0x8096082880809508ULL,
0x0828808097082880ULL, 0x80809e082880809cULL, 0xae08288080a50828ULL, 0x2880808408288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808084ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x0001279000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL,
0x8080288080820900ULL, 0x0900000010042880ULL, 0x2880808228808084ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880809008288080ULL, 0x8095082880809408ULL,
0x0828808096082880ULL, 0x80809e0828808097ULL, 0xae08288080a50828ULL, 0x288080b408288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x00002200288080b4ULL, 0x0000001cffffffffULL,
0x0000013000000000ULL, 0x0001291000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880809008288080ULL,
0x8095082880809408ULL, 0x0828808096082880ULL, 0x80809c0828808097ULL, 0xae08288080a50828ULL,
0x2880809e08288080ULL, 0x0003102880828016ULL, 0x9200000000000000ULL, 0x000022002880809eULL,
0x0000002cffffffffULL, 0x000001d800000000ULL, 0x0001295000000000ULL, 0x0000005000000000ULL,
0x0000100400000000ULL, 0x80902880809e0900ULL, 0x0000000000002880ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880809008288080ULL, 0x8095082880809408ULL,
0x0828808096082880ULL, 0x80809e082880809cULL, 0xae08288080a50828ULL, 0x2880809708288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808097ULL, 0x0000002cffffffffULL,
0x0000029000000000ULL, 0x000129a000000000ULL, 0x0000016000000000ULL, 0x0000140400000000ULL,
0x8090288080970900ULL, 0x0000000000002880ULL, 0x0000001a00082f04ULL, 0x000823040000008cULL,
0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL,
0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0048016000000017ULL, 0x000c170400481903ULL, 0x0040000600000000ULL, 0x000c17040021f000ULL,
0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x0000002000043104ULL, 0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000f001342804ULL, 0x0000040000000110ULL, 0x00001f3000001e90ULL, 0x000021b000002040ULL,
0x0000264000002610ULL, 0x00002720000026b0ULL, 0x000047e000004740ULL, 0x00004a7000004910ULL,
0x00004f6000004f30ULL, 0x0000504000004fd0ULL, 0x00006e1000006d80ULL, 0x000070a000006f40ULL,
0x0000754000007510ULL, 0x00007620000075b0ULL, 0x00009460000093d0ULL, 0x000096f000009590ULL,
0x00009ba000009b70ULL, 0x00009c8000009c10ULL, 0x0000ad600000ad50ULL, 0x00010c8000010c40ULL,
0x00010ca000010c90ULL, 0x00010d1000010cf0ULL, 0x00010d4000010d30ULL, 0x00011a00000119a0ULL,
0x00011ae000011a70ULL, 0x00011be000011b60ULL, 0x00011ca000011c40ULL, 0x00011d7000011d00ULL,
0x00011e6000011df0ULL, 0x00011f2000011ec0ULL, 0x0001200000011f90ULL, 0x000120f000012080ULL,
0x000121b000012150ULL, 0x0001229000012220ULL, 0x0001238000012310ULL, 0x00012470000123f0ULL,
0x00012570000124f0ULL, 0x00012670000125f0ULL, 0x00012770000126f0ULL, 0x0000020004403904ULL,
0x00017600000000ffULL, 0x00000270003f0100ULL, 0x0001760800000011ULL, 0x00000370003f0120ULL,
0x0001768800000011ULL, 0x000003a0003f0120ULL, 0x000176a800000011ULL, 0x000003d0003f0120ULL,
0x000176c800000011ULL, 0x00000460003f0120ULL, 0x00017600000000ffULL, 0x00000560003f0107ULL,
0x0001768c0000000cULL, 0x000005f0003f0102ULL, 0x000176880000000cULL, 0x00000d60003f0101ULL,
0x000176a800000008ULL, 0x00000e70003f0107ULL, 0x000176a800000008ULL, 0x00000ed0003f0101ULL,
0x0000002000000012ULL, 0x00001020003f0101ULL, 0x0000000400000004ULL, 0x00001200003f0105ULL,
0x0000000400000004ULL, 0x00001a30003f0105ULL, 0x000176a800000076ULL, 0x00001b10003f0107ULL,
0x000176a800000076ULL, 0x00001b70003f0101ULL, 0x0001760800000011ULL, 0x00001bc0003f0101ULL,
0x0001760c00000013ULL, 0x00001d90003f0105ULL, 0x0001760c00000013ULL, 0x00002370003f0105ULL,
0x000176ac00000017ULL, 0x00002540003f0105ULL, 0x000176ac00000017ULL, 0x00003810003f0105ULL,
0x0000000000000004ULL, 0x00003890003f0101ULL, 0x0001768800000045ULL, 0x00003900003f0101ULL,
0x0000000400000004ULL, 0x00003ad0003f0105ULL, 0x0000000400000004ULL, 0x00004330003f0105ULL,
0x000176a800000051ULL, 0x00004410003f0107ULL, 0x000176a800000051ULL, 0x00004470003f0101ULL,
0x0001762800000011ULL, 0x000044c0003f0101ULL, 0x0001762c0000001cULL, 0x00004690003f0105ULL,
0x0001762c0000001cULL, 0x00004c60003f0105ULL, 0x000176ac00000012ULL, 0x00004e50003f0105ULL,
0x000176ac00000017ULL, 0x00005f60003f0105ULL, 0x0000000000000004ULL, 0x00005fd0003f0101ULL,
0x0001769000000045ULL, 0x00006020003f0101ULL, 0x0000000400000004ULL, 0x000061f0003f0105ULL,
0x0000000400000004ULL, 0x00006940003f0105ULL, 0x0000000000000052ULL, 0x00006a80003f0107ULL,
0x000176a800000011ULL, 0x00006ae0003f0101ULL, 0x0001764800000016ULL, 0x00006b00003f0101ULL,
0x0001764c00000016ULL, 0x00006cd0003f0105ULL, 0x0001764c00000016ULL, 0x00007270003f0105ULL,
0x000176ac00000051ULL, 0x00007440003f0105ULL, 0x000176ac00000051ULL, 0x00008590003f0105ULL,
0x0000000000000004ULL, 0x00008600003f0101ULL, 0x0001769800000045ULL, 0x00008680003f0101ULL,
0x000176cc00000012ULL, 0x00008850003f0105ULL, 0x000176cc00000012ULL, 0x00008fa0003f0105ULL,
0x0000000000000050ULL, 0x000090c0003f0107ULL, 0x000176a800000051ULL, 0x00009120003f0101ULL,
0x000176680000001cULL, 0x00009150003f0101ULL, 0x0001766c0000001cULL, 0x00009320003f0105ULL,
0x0001766c0000001cULL, 0x000098d0003f0105ULL, 0x000176ac00000053ULL, 0x00009aa0003f0105ULL,
0x000176ac00000053ULL, 0x0000ab20003f0105ULL, 0x0000000000000004ULL, 0x0000ab80003f0101ULL,
0x000176a000000045ULL, 0x0000b8d0003f0101ULL, 0x00017600000000ffULL, 0x0000cf20003f0101ULL,
0x00017604000000ffULL, 0x0000d0f0003f0105ULL, 0x00017604000000ffULL, 0x0000d320003f0105ULL,
0x00017600000000ffULL, 0x0000d350003f0101ULL, 0x00017604000000ffULL, 0x0000d510003f0105ULL,
0x00017604000000ffULL, 0x00010110003f0105ULL, 0x0000000000000005ULL, 0x00010190003f0101ULL,
0x0000000400000005ULL, 0x00010360003f0105ULL, 0x0000000400000005ULL, 0x000117e0003f0105ULL,
0x0000000000000007ULL, 0x00011840003f0101ULL, 0x0000000800000007ULL, 0x000118a0003f0101ULL,
0x0000001000000007ULL, 0x00011910003f0101ULL, 0x0000001800000007ULL, 0x00053803003f0101ULL,
0x0000b5b000141c04ULL, 0x0000d5700000b820ULL, 0x000119600000d620ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000324ULL, 0x0000001a00000002ULL, 0x000000000000026cULL,
0x0000001a00000002ULL, 0x00000000000001c4ULL, 0x0000001a00000002ULL, 0x0000000000000104ULL,
0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL, 0x00000000000002ffULL,
0x0000001a00000002ULL, 0x0000000000000247ULL, 0x0000001a00000002ULL, 0x000000000000019fULL,
0x0000001a00000002ULL, 0x00000000000000dfULL, 0x0000001a00000002ULL, 0x0000000000017700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000117919ULL, 0x000e620000002100ULL,
0x0000000000147806ULL, 0x000fe200038e0000ULL, 0x00005800ff097624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000ea20000002300ULL,
0x0000001400047300ULL, 0x000ee200000e0000ULL, 0x0000000809097824ULL, 0x000fe400078e00ffULL,
0x0000000000057919ULL, 0x000f280000002200ULL, 0x00000000000d7919ULL, 0x000ee20000000000ULL,
0x0000001400147309ULL, 0x000ea60000000000ULL, 0x0000000000077919ULL, 0x000ee80000000000ULL,
0x0000000000127919ULL, 0x000ee20000002600ULL, 0x00000005ff3c7819ULL, 0x002fc60000011611ULL,
0x0000000000107919ULL, 0x000e680000002700ULL, 0x00001fff02037589ULL, 0x004fe200000e0000ULL,
0x0000010002007a24ULL, 0x010fc600078e0205ULL, 0x00001fff3c3c7589ULL, 0x000ea200000e0000ULL,
0x0000000000117a24ULL, 0x000fe200078e0211ULL, 0x00000004ff137819ULL, 0x008fe4000001160dULL,
0x000000070400720cULL, 0x000fe40003f02070ULL, 0x000000ff1100720cULL, 0x040fe40003f45270ULL,
0x0000000f1100780cULL, 0x040fe20003f64070ULL, 0x0000000812007824ULL, 0x000fe200078e00ffULL,
0x0000007f1100780cULL, 0x000fc40003f84070ULL, 0x000000031100780cULL, 0x000fe20003f24070ULL,
0x0000001009007224ULL, 0x002fcc00078e0200ULL, 0x3fffff80ff04a424ULL, 0x000fe400078e00ffULL,
0x0000000403027824ULL, 0x004fe400078e023cULL, 0x7fffff80ff05a424ULL, 0x000fe400078e00ffULL,
0x0000000202027824ULL, 0x000fe400078e00ffULL, 0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL,
0x01760004ff00a388ULL, 0x0003e20000000a00ULL, 0x00000001020a7824ULL, 0x040fe200078e0213ULL,
0x00000008020b7817ULL, 0x000fe20007800000ULL, 0x7fffffc0ff07b424ULL, 0x000fe200078e00ffULL,
0x000000011100780cULL, 0x000fe20003f44070ULL, 0x0000000100007824ULL, 0x000fc400078e020aULL,
0x000000010b0c7824ULL, 0x000fe200078e0a02ULL, 0x017608061100b388ULL, 0x0005e20000008a00ULL,
0x000000100d027824ULL, 0x000fe400078e00ffULL, 0x00000100ff057424ULL, 0x002fe200078e00ffULL,
0x0000000c1300720cULL, 0x000fe20003f66070ULL, 0xff317217ff0ec424ULL, 0x000fe400078e00ffULL,
0x000000100a157824ULL, 0x000fe400078e00ffULL, 0x00005c0000047625ULL, 0x000fe200078e0005ULL,
0x0174000e1100c388ULL, 0x0003e20000004800ULL, 0x000000f002077812ULL, 0x004fc400078ec0ffULL,
0x000000010a067824ULL, 0x000fe400078e020dULL, 0x3fffff60ff089424ULL, 0x000fe400078e00ffULL,
0x7fffff60ff099424ULL, 0x000fe200078e00ffULL, 0xfffffff015007812ULL, 0x000fe200078ee206ULL,
0x3fffff80ff0a9424ULL, 0x000fe200078e00ffULL, 0x0000000704067210ULL, 0x000fe20007f9e0ffULL,
0x7fffff80ff0b9424ULL, 0x000fe200078e00ffULL, 0x0176880811009388ULL, 0x0005e20000008a00ULL,
0x3fffffc0ff0ea424ULL, 0x002fc400078e00ffULL, 0x7fffffc0ff0fa424ULL, 0x000fe200078e00ffULL,
0x0176a80a11009388ULL, 0x000fe20000008a00ULL, 0x000000ffff077224ULL, 0x000fe400020e0605ULL,
0x00000004ff057424ULL, 0x000fe200078e00ffULL, 0x0176c80e1100a388ULL, 0x000fe60000008a00ULL,
0x0000600010047625ULL, 0x000fc800078e0005ULL, 0x0000001000097824ULL, 0x004fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000ffff087224ULL, 0x000fe200078e0a14ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e8000d901c46ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x01760408ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01760000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006043d7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0300720cULL, 0x000fc40003f05270ULL,
0x000000ff3d007810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff0f7819ULL, 0x000fce0000011600ULL,
0x0000b30000008947ULL, 0x000fea0003800000ULL, 0x000000083c0c7824ULL, 0x000fe400078e00ffULL,
0x00000003ff037424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01768c030cff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x0000000210097824ULL, 0x002fe200078e00ffULL,
0x0000580012047a10ULL, 0x000fe20007ffe0ffULL, 0x017688000cff7f8cULL, 0x0003e2000c80043fULL,
0x00000001ff0b7819ULL, 0x000fe4000001163cULL, 0x000000013c0e7812ULL, 0x000fe200078ec0ffULL,
0x0000580009097a24ULL, 0x000fc400078e0204ULL, 0x000000200b0a7824ULL, 0x000fc800078e00ffULL,
0x0000620009007a24ULL, 0x000fe200078e020aULL, 0x000003c000000947ULL, 0x000fea0003800000ULL,
0x0000000a3d037217ULL, 0x006fe20007800000ULL, 0x000000100e047824ULL, 0x000fe200078e00ffULL,
0x00000003ff057819ULL, 0x000fe2000001160dULL, 0x00000080ff167424ULL, 0x000fe200078e00ffULL,
0x00000070021b7812ULL, 0x000fe200078ec0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a0aULL,
0x0000000405087810ULL, 0x040fe20007ffe0ffULL, 0x0000000104067824ULL, 0x040fe200078e0205ULL,
0x0000000c05117810ULL, 0x000fe40007ffe0ffULL, 0x0000000403037217ULL, 0x000fe20007800000ULL,
0x0000000104107824ULL, 0x000fc400078e0208ULL, 0x0000000106077824ULL, 0x140fe400078e020dULL,
0x0000000103037824ULL, 0x000fe400078e0a04ULL, 0x0000000806127824ULL, 0x000fe400078e00ffULL,
0x0000000810147824ULL, 0x000fe200078e00ffULL, 0x000000030800720cULL, 0x080fe40003f46070ULL,
0x0000000805087810ULL, 0x040fe40007ffe0ffULL, 0x000000030500720cULL, 0x080fe20003f66070ULL,
0x0000000110057824ULL, 0x000fe200078e020dULL, 0x000000030800720cULL, 0x080fe20003f26070ULL,
0x0000000104087824ULL, 0x000fe200078e0208ULL, 0x000000031100720cULL, 0x000fe20003f06070ULL,
0x0000000100037824ULL, 0x000fe200078e0206ULL, 0xfffffff812077812ULL, 0x000fe200078ee207ULL,
0x0000000104127824ULL, 0x000fe200078e0211ULL, 0xfffffff814157812ULL, 0x000fe200078ee205ULL,
0x00005e0003027625ULL, 0x000fc800078e0016ULL, 0x0000000100047824ULL, 0x000fe200078e0210ULL,
0x0000001b02107210ULL, 0x000fe20007f9e0ffULL, 0x0000000100057824ULL, 0x040fe400078e0208ULL,
0x0000000100147824ULL, 0x000fe200078e0212ULL, 0x000130000b007811ULL, 0x000fe200078e68ffULL,
0x0000000108067824ULL, 0x040fe400078e020dULL, 0x0000000808177824ULL, 0x000fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fc400020e0603ULL, 0x00005e0004027625ULL, 0x000fe200078e0016ULL,
0xfffffff817177812ULL, 0x000fc600078ee206ULL, 0x0000001007137824ULL, 0x000fe200078e0200ULL,
0x0000001b02027210ULL, 0x000fe20007f9e0ffULL, 0x00005e0005047625ULL, 0x000fc600078e0016ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000d901c46ULL,
0x0000000112087824ULL, 0x000fe200078e020dULL, 0x0000001b04047210ULL, 0x000fe20007fbe0ffULL,
0x0000000812197824ULL, 0x000fe400078e00ffULL, 0x00005e0014067625ULL, 0x000fc600078e0016ULL,
0xfffffff819197812ULL, 0x000fe200078ee208ULL, 0x0000001015157824ULL, 0x100fe200078e0200ULL,
0x0000001b06067210ULL, 0x000fe20007fde0ffULL, 0x000000ffff037224ULL, 0x000fe400020e0603ULL,
0x0000001017177824ULL, 0x100fe400078e0200ULL, 0x000000ffff057224ULL, 0x000fe200028e0605ULL,
0x0000000002157faeULL, 0x0003e2000d101c46ULL, 0x0000001019197824ULL, 0x000fe400078e0200ULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x0000000004177faeULL, 0x0003e8000c901c46ULL,
0x0000000006197faeULL, 0x0003e2000c101c46ULL, 0x000002f000007947ULL, 0x000fea0003800000ULL,
0x000000100e047824ULL, 0x002fe200078e00ffULL, 0x0000007002177812ULL, 0x000fe200078ec0ffULL,
0x00000080ff157424ULL, 0x000fc600078e00ffULL, 0x000000040d037211ULL, 0x004fc800078fe8ffULL,
0x0000000803077810ULL, 0x040fe20007ffe0ffULL, 0x0000000103047824ULL, 0x040fe200078e020dULL,
0x0000000c03107810ULL, 0x040fe20007ffe0ffULL, 0x0000000803057824ULL, 0x000fe400078e00ffULL,
0x0000000100027824ULL, 0x000fe400078e0203ULL, 0x0000000107117824ULL, 0x000fe200078e020dULL,
0xfffffff805087812ULL, 0x000fe200078ee204ULL, 0x0000000807127824ULL, 0x000fe200078e00ffULL,
0x0000000403047810ULL, 0x000fe20007ffe0ffULL, 0x00005e0002027625ULL, 0x000fc600078e0015ULL,
0xfffffff812127812ULL, 0x000fe200078ee211ULL, 0x0000000100057824ULL, 0x000fe400078e0204ULL,
0x0000000104067824ULL, 0x040fe400078e020dULL, 0x0000000804197824ULL, 0x000fe400078e00ffULL,
0x0000000100047824ULL, 0x040fe400078e0207ULL, 0x0000000100137824ULL, 0x000fe200078e0210ULL,
0xfffffff819007812ULL, 0x000fe200078ee206ULL, 0x0000000110077824ULL, 0x040fe200078e020dULL,
0x000130000b197811ULL, 0x000fe200078e68ffULL, 0x0000000810147824ULL, 0x000fe200078e00ffULL,
0x0000001702107210ULL, 0x000fc80007f1e0ffULL, 0xfffffff814147812ULL, 0x000fe200078ee207ULL,
0x000000ffff117224ULL, 0x000fe400000e0603ULL, 0x00005e0005027625ULL, 0x000fc800078e0015ULL,
0x00005e0004047625ULL, 0x000fe200078e0015ULL, 0x0000001702027210ULL, 0x000fc60007f1e0ffULL,
0x00005e0013067625ULL, 0x000fe200078e0015ULL, 0x0000001704047210ULL, 0x000fc60007f3e0ffULL,
0x0000001008137824ULL, 0x100fe200078e0219ULL, 0x0000001706067210ULL, 0x000fe20007f5e0ffULL,
0x0000001000157824ULL, 0x000fe400078e0219ULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010137faeULL, 0x0003e2000b901c46ULL,
0x0000001012177824ULL, 0x000fe400078e0219ULL, 0x000000ffff057224ULL, 0x000fe200008e0605ULL,
0x0000000002157faeULL, 0x0003e2000b901c46ULL, 0x0000001014197824ULL, 0x000fc400078e0219ULL,
0x000000ffff077224ULL, 0x000fe200010e0607ULL, 0x0000000004177faeULL, 0x0003e8000b901c46ULL,
0x0000000006197faeULL, 0x0003e4000b901c46ULL, 0x000000100b087824ULL, 0x000fe200078e00ffULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x000000ffff077224ULL, 0x002fe200078e00ffULL,
0x000176a80b127811ULL, 0x000fe200078e18ffULL, 0x00000000080473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x000176a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a80008567f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200012127f8cULL, 0x000ee2000c80043fULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00009c6000008947ULL, 0x000fea0003800000ULL,
0xff317217ff567424ULL, 0x004fe400078e00ffULL, 0x000000ffff067224ULL, 0x000fc400078e00ffULL,
0x000000ffff127224ULL, 0x008fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x000fc400078e00ffULL,
0x0000010006047824ULL, 0x002fca00078e00ffULL, 0x0000003d0400720cULL, 0x000fda0003f06070ULL,
0x00009bb000000947ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x000fc400078e0012ULL,
0x0000000000107805ULL, 0x000fca0000015200ULL, 0x000176c80b047811ULL, 0x000fca00078e18ffULL,
0x0000040004147984ULL, 0x000ea40000000800ULL, 0x8000000014ff7812ULL, 0x004fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff147819ULL, 0x000fc80000011415ULL, 0x0000001714147211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000214147819ULL, 0x000fc80000001215ULL,
0x000000140000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000040004147984ULL, 0x000ea40000000800ULL, 0x8000000014ff7812ULL, 0x004fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000106107810ULL, 0x040fe20007ffe0ffULL, 0x0000010006447824ULL, 0x000fe200078e020aULL,
0x0000000112467812ULL, 0x000fe400078e0cffULL, 0x0000000f1000720cULL, 0x000fe40003f06070ULL,
0x0000004044147810ULL, 0x000fca0007ffe0ffULL, 0x00006200091e7a24ULL, 0x000fcc00078e0214ULL,
0x000003e000008947ULL, 0x000fea0003800000ULL, 0x00000003ff167819ULL, 0x100fe2000001160dULL,
0x000000100e177824ULL, 0x000fe200078e00ffULL, 0x000000143d107217ULL, 0x000fe20007800000ULL,
0x00000080ff3e7424ULL, 0x000fe200078e00ffULL, 0x0000000416407810ULL, 0x040fe20007ffe0ffULL,
0x0000000117117824ULL, 0x000fe200078e0216ULL, 0x0000000c16427810ULL, 0x000fe20007ffe0ffULL,
0x0000000110107824ULL, 0x000fe400078e0a14ULL, 0x0000000111137824ULL, 0x040fe400078e020dULL,
0x00000008111c7824ULL, 0x000fe200078e00ffULL, 0x0000001017107217ULL, 0x000fe20007800000ULL,
0x000000100d147824ULL, 0x000fc400078e00ffULL, 0x0000000111117824ULL, 0x000fe200078e021eULL,
0xfffffff81c1d7812ULL, 0x000fe200078ee213ULL, 0x0000000110137824ULL, 0x000fe200078e0a17ULL,
0x00000070143f7812ULL, 0x000fe200078ec0ffULL, 0x0000000117157824ULL, 0x000fe400078e0240ULL,
0x00005e0011107625ULL, 0x000fe200078e003eULL, 0x000000134000720cULL, 0x080fe40003f06070ULL,
0x000000131600720cULL, 0x000fe20003fa6070ULL, 0x000000020b1c7824ULL, 0x000fe200078e0246ULL,
0x0000003f10147210ULL, 0x000fe20007fde0ffULL, 0x00000001151f7824ULL, 0x000fc400078e020dULL,
0x0000000815407824ULL, 0x040fe200078e00ffULL, 0x000130001c1c7811ULL, 0x000fe200078e60ffULL,
0x0000000115107824ULL, 0x000fe400078e021eULL, 0x000000ffff157224ULL, 0x000fe200030e0611ULL,
0xfffffff8401f7812ULL, 0x000fe200078ee21fULL, 0x00005e0010107625ULL, 0x000fe200078e003eULL,
0x0000000816407810ULL, 0x000fc60007ffe0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e021cULL,
0x0000003f10167210ULL, 0x000fe20007fde0ffULL, 0x0000000117417824ULL, 0x000fe400078e0240ULL,
0x000000101f1f7824ULL, 0x000fe200078e021cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x0005e2000e901c46ULL, 0x0000000141107824ULL, 0x000fe200078e021eULL,
0x000000134000720cULL, 0x080fe20003fa6070ULL, 0x0000000117407824ULL, 0x000fe400078e0242ULL,
0x000000ffff177224ULL, 0x000fe200030e0611ULL, 0x000000134200720cULL, 0x000fe20003fc6070ULL,
0x00005e0010107625ULL, 0x000fc600078e003eULL, 0x00000000161f7faeULL, 0x0007e2000c101c46ULL,
0x0000000140137824ULL, 0x000fe200078e021eULL, 0x0000003f10107210ULL, 0x000fe20007f1e0ffULL,
0x00000001411d7824ULL, 0x044fe400078e020dULL, 0x0000000841427824ULL, 0x000fe400078e00ffULL,
0x00005e0013147625ULL, 0x000fc600078e003eULL, 0xfffffff842137812ULL, 0x000fe200078ee21dULL,
0x00000001401e7824ULL, 0x040fe400078e020dULL, 0x0000000840417824ULL, 0x000fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000003f14147210ULL, 0x000fe20007f1e0ffULL,
0x0000001013137824ULL, 0x000fe200078e021cULL, 0xfffffff8411d7812ULL, 0x000fc600078ee21eULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x0000000010137faeULL, 0x0005e2000e901c46ULL,
0x000000101d177824ULL, 0x008fca00078e021cULL, 0x0000000014177faeULL, 0x0005e2000f101c46ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x000000100e107824ULL, 0x000fe400078e00ffULL,
0x000000100d137824ULL, 0x040fe400078e00ffULL, 0x00000080ff1d7424ULL, 0x000fe200078e00ffULL,
0x000000100d117211ULL, 0x000fe400078fe8ffULL, 0x00000070133f7812ULL, 0x000fe200078ec0ffULL,
0x000000020b137824ULL, 0x000fe200078e0246ULL, 0x0000000411147810ULL, 0x040fe20007ffe0ffULL,
0x0000000111107824ULL, 0x040fe200078e020dULL, 0x0000000c113e7810ULL, 0x040fe20007ffe0ffULL,
0x00000008111f7824ULL, 0x000fc400078e00ffULL, 0x0000000114157824ULL, 0x040fe400078e020dULL,
0x0000000814167824ULL, 0x040fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee210ULL,
0x0000000111107824ULL, 0x140fe400078e021eULL, 0x0000000114147824ULL, 0x100fe200078e021eULL,
0xfffffff816417812ULL, 0x000fe200078ee215ULL, 0x000000013e1c7824ULL, 0x000fe200078e021eULL,
0x0000000811157810ULL, 0x000fe20007ffe0ffULL, 0x00005e0010107625ULL, 0x000fc800078e001dULL,
0x0000000115167824ULL, 0x040fe200078e021eULL, 0x0000003f10107210ULL, 0x000fe20007f1e0ffULL,
0x0000000115177824ULL, 0x140fe400078e020dULL, 0x00000008151e7824ULL, 0x000fe400078e00ffULL,
0x000000013e157824ULL, 0x040fe400078e020dULL, 0x000000083e3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e437812ULL, 0x000fe200078ee217ULL, 0x00005e0016167625ULL, 0x000fe200078e001dULL,
0x00013000131e7811ULL, 0x000fc400078e60ffULL, 0xfffffff83e457812ULL, 0x000fe200078ee215ULL,
0x00005e0014147625ULL, 0x000fe200078e001dULL, 0x0000003f16167210ULL, 0x000fc60007fbe0ffULL,
0x00005e001c1c7625ULL, 0x000fc800078e001dULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000003f14147210ULL, 0x080fe20007f1e0ffULL, 0x000000101f137824ULL, 0x100fe200078e021eULL,
0x0000003f1c1c7210ULL, 0x000fe20007fde0ffULL, 0x00000010411f7824ULL, 0x100fe400078e021eULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0005e2000b901c46ULL, 0x00000010433f7824ULL, 0x100fe400078e021eULL,
0x000000ffff177224ULL, 0x000fe200028e0617ULL, 0x00000000141f7faeULL, 0x0005e2000b901c46ULL,
0x0000001045417824ULL, 0x000fc400078e021eULL, 0x000000ffff1d7224ULL, 0x000fe200030e061dULL,
0x00000000163f7faeULL, 0x0005e8000b901c46ULL, 0x000000001c417faeULL, 0x0005e4000b901c46ULL,
0xfffffff00c117812ULL, 0x044fe200078ec0ffULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0xffffffe00c137812ULL, 0x040fe400078ec0ffULL, 0x000000100c107812ULL, 0x000fe200078ec0ffULL,
0x0000000846767824ULL, 0x000fe200078e0211ULL, 0x000000000000781cULL, 0x000fc60003f0f070ULL,
0x0000000113117824ULL, 0x000fe200078e0210ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000176a876527810ULL, 0x000fe40007ffe0ffULL, 0x000000080e117824ULL, 0x000fcc00078e0211ULL,
0x00000000520403c2ULL, 0x000ea40000060000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00b9b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20001f0f070ULL, 0xffffff8000003947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a80076767f8cULL, 0x000ea2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176080011167f8cULL, 0x000664000c80043fULL,
0x0000000000107805ULL, 0x008fc40000015200ULL, 0x0000001008147812ULL, 0x000fca00078ec0ffULL,
0x0000000113137824ULL, 0x000fc800078e0214ULL, 0x000000080e137824ULL, 0x000fca00078e0213ULL,
0x01760c0013157984ULL, 0x000ee40000000800ULL, 0x8000000015ff7812ULL, 0x00afe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x00000014101d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001d14147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760c0013157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100d107824ULL, 0x000fe200078e00ffULL, 0x00000001ff477819ULL, 0x000fe2000001160dULL,
0x000000203c487824ULL, 0x000fc600078e00ffULL, 0x00000070101d7812ULL, 0x000fe400078ec0ffULL,
0xffffff8048487812ULL, 0x000fe400078ec0ffULL, 0x0000000c47477812ULL, 0x000fc800078ec0ffULL,
0x0000004847107210ULL, 0x000fca0007ffe01dULL, 0x0170000010137984ULL, 0x000e680000000800ULL,
0x0172000010147984ULL, 0x0006a20000000800ULL, 0x000000561300720bULL, 0x002fe20003f1d000ULL,
0x0000fae27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x008fc800000e0100ULL,
0x0000ffff103e7812ULL, 0x000fe2000780c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000001ff687424ULL, 0x000fe400078e00ffULL, 0x000000ffff417224ULL, 0x000fd200078e0056ULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x00000002ff117819ULL, 0x000fe4000001163cULL,
0x000000561300720bULL, 0x000fe40003f14000ULL, 0x0000003c1100720cULL, 0x000fe20003fa5270ULL,
0x0000faa27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000157806ULL, 0x000fc400000e0100ULL,
0x000000803c10d824ULL, 0x000fe200078e021dULL, 0x0000001356417209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe20003800000ULL, 0x0000991015117816ULL, 0x000fe200000000ffULL,
0x000000014710d824ULL, 0x000fc600078e0210ULL, 0x000000ff1100720cULL, 0x000fe40003f05270ULL,
0x017400411000d388ULL, 0x0003f60000000800ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000004156107221ULL, 0x002fe20000010000ULL, 0x000000ff15ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000177308ULL, 0x0002ec0000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x002fe2000001160dULL, 0x0000f9f27f007947ULL, 0x000fea000b800000ULL,
0x00001f1017107589ULL, 0x0082e400000e0000ULL, 0x0000001020207220ULL, 0x088fe40000410000ULL,
0x0000001021217220ULL, 0x080fe40000410000ULL, 0x0000001024247220ULL, 0x000fc40000410000ULL,
0x0000001025257220ULL, 0x080fe40000410000ULL, 0x0000001028287220ULL, 0x080fe40000410000ULL,
0x0000001029297220ULL, 0x080fe40000410000ULL, 0x000000102c2c7220ULL, 0x080fe40000410000ULL,
0x000000102d2d7220ULL, 0x080fe40000410000ULL, 0x0000001030307220ULL, 0x000fc40000410000ULL,
0x0000001031317220ULL, 0x080fe40000410000ULL, 0x0000001034347220ULL, 0x080fe40000410000ULL,
0x0000001035357220ULL, 0x080fe40000410000ULL, 0x0000001038387220ULL, 0x080fe40000410000ULL,
0x0000001039397220ULL, 0x080fe40000410000ULL, 0x0000001018187220ULL, 0x000fc40000410000ULL,
0x0000001019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0015ff7812ULL, 0x000fe2000780c0ffULL, 0x0000001707077220ULL, 0x008fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d107811ULL, 0x002fe200078ff0ffULL,
0x0000f8f27f007947ULL, 0x000fea000b800000ULL, 0x00001f1017107589ULL, 0x0002e400000e0000ULL,
0x0000001022227220ULL, 0x088fe40000410000ULL, 0x0000001023237220ULL, 0x080fe40000410000ULL,
0x0000001026267220ULL, 0x080fe40000410000ULL, 0x0000001027277220ULL, 0x080fe40000410000ULL,
0x000000102a2a7220ULL, 0x080fe40000410000ULL, 0x000000102b2b7220ULL, 0x000fc40000410000ULL,
0x000000102e2e7220ULL, 0x080fe40000410000ULL, 0x000000102f2f7220ULL, 0x080fe40000410000ULL,
0x0000001032327220ULL, 0x080fe40000410000ULL, 0x0000001033337220ULL, 0x080fe40000410000ULL,
0x0000001036367220ULL, 0x080fe40000410000ULL, 0x0000001037377220ULL, 0x000fc40000410000ULL,
0x000000103a3a7220ULL, 0x080fe40000410000ULL, 0x000000103b3b7220ULL, 0x080fe40000410000ULL,
0x000000101a1a7220ULL, 0x080fe40000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff3eff7812ULL, 0x000fda0007806015ULL,
0x8000004113130221ULL, 0x000fe20000010000ULL, 0x00007610ff680816ULL, 0x000fc60000000068ULL,
0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL, 0x0000001300030308ULL, 0x000e640000000800ULL,
0x0000000314140220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000714077221ULL, 0x004fc40000010000ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0x0000000812177824ULL, 0x000fca00078e0208ULL, 0x0176ac0017147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe40007804857ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410147210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff137819ULL, 0x000fc80000011415ULL, 0x0000001413137211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0615ULL, 0x0000000213137819ULL, 0x000fc80000001214ULL,
0x000000130000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac0017147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fe40007804857ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991068107816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff147819ULL, 0x000fe4000001160dULL, 0x0000541000137816ULL, 0x000fe20000000000ULL,
0x0000f5027f007947ULL, 0x000fea000b800000ULL, 0x00001f1413027589ULL, 0x0002a400000e0000ULL,
0x0000000814007810ULL, 0x000fe20007ffe0ffULL, 0x0000f5527f007947ULL, 0x000fea000b800000ULL,
0x00001f0013007589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001014107810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1c7224ULL, 0x000fe200078e0013ULL,
0x000026c0001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0001029000007944ULL, 0x00efea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001814107810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff1c7224ULL, 0x004fe200078e0013ULL, 0x00002730001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x0001022000007944ULL, 0x00afea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000070d7e7812ULL, 0x000fe200078ec0ffULL, 0x000002003c3e7824ULL, 0x000fe200078e00ffULL,
0x00000004ff547819ULL, 0x100fe2000001160dULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000087e7e7812ULL, 0x000fe400078ef80dULL, 0xfffff8003e3e7812ULL, 0x000fe200078ec0ffULL,
0x000000040b617824ULL, 0x000fe400078e0254ULL, 0x000000087e107824ULL, 0x040fe400078e00ffULL,
0x000000017e617824ULL, 0x000fca00078e0261ULL, 0xfffffff8103f7812ULL, 0x000fe400078ee261ULL,
0x000000080d107812ULL, 0x000fc600078ec0ffULL, 0x000000103f3f7824ULL, 0x000fc400078e023eULL,
0x0000000710557812ULL, 0x000fe200078ef80dULL, 0x000000040e547824ULL, 0x000fe200078e0254ULL,
0x0000991068687816ULL, 0x000fe200000000ffULL, 0x000000020b4a7824ULL, 0x000fe400078e0212ULL,
0x0000000155107824ULL, 0x040fe400078e0254ULL, 0x0000000855117824ULL, 0x040fe200078e00ffULL,
0x000130004a4a7811ULL, 0x000fe200078e60ffULL, 0x0000000855137824ULL, 0x00afe200078e00ffULL,
0x00000002104e7810ULL, 0x000fe20007ffe0ffULL, 0x000000087e7e7824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fc400078ee210ULL, 0xfffffff8134e7812ULL, 0x000fc600078ee24eULL,
0x0000001011117824ULL, 0x100fe400078e024aULL, 0x000000104e1c7824ULL, 0x004fc600078e024aULL,
0x000000001114783bULL, 0x000e680000004200ULL, 0x000000001c1c783bULL, 0x000ea20000004200ULL,
0x0000010014117824ULL, 0x042fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe20000011414ULL,
0x0000010015107824ULL, 0x000fe200078e00ffULL, 0x00008880147f7816ULL, 0x040fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000010017407824ULL, 0x000fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fe20000011415ULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x0000888015537816ULL, 0x000fc400000000ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff567819ULL, 0x000fe20000011416ULL, 0x0000001100827306ULL, 0x0003e20000200c00ULL,
0x00008880167b7816ULL, 0x000fe400000000ffULL, 0x00000018ff577819ULL, 0x000fe40000011417ULL,
0x0000888017647816ULL, 0x040fe200000000ffULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x004fe2000001141cULL, 0x00000014007d7306ULL, 0x0005e20000200c00ULL,
0x0001000015117824ULL, 0x002fe200078e00ffULL, 0x0000001055157812ULL, 0x000fc400078efcffULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x00000018ff7c7819ULL, 0x000fe20000011411ULL,
0x00000008154b7824ULL, 0x000fe200078e00ffULL, 0x0000001000807306ULL, 0x0003e20000200c00ULL,
0x0000000154147824ULL, 0x004fe200078e0215ULL, 0x000088801c747816ULL, 0x000fe200000000ffULL,
0x0000010016117824ULL, 0x040fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001141dULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0xfffffff84b4b7812ULL, 0x000fc400078ee214ULL,
0x00000018ff787819ULL, 0x000fe20000011411ULL, 0x0000001700667306ULL, 0x0005e20000200c00ULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x000000104b107824ULL, 0x002fe200078e024aULL,
0x00000002144d7810ULL, 0x000fe40007ffe0ffULL, 0x00000018ff627819ULL, 0x000fe4000001141eULL,
0x00000018ff607819ULL, 0x000fe2000001141fULL, 0x000000001010783bULL, 0x000e620000004200ULL,
0x0000001600757306ULL, 0x0007e20000200c00ULL, 0x000001001d177824ULL, 0x044fe200078e00ffULL,
0x000088801d717816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x000088801e6c7816ULL, 0x000fc400000000ffULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x000088801f697816ULL, 0x000fe200000000ffULL, 0x000001001c167824ULL, 0x048fe200078e00ffULL,
0x0000001700727306ULL, 0x0005e20000200c00ULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x0000001600737306ULL, 0x0007e20000200c00ULL,
0x000001001f177824ULL, 0x044fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x000100001f1f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x0000001c00707306ULL, 0x0005e20000200c00ULL, 0x000001001e167824ULL, 0x048fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x000100001e1e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x00000017006a7306ULL, 0x000fe20000200c00ULL,
0x00000008151c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0000010011147824ULL, 0x002fc600078e00ffULL, 0xfffffff81c4d7812ULL, 0x000fe200078ee24dULL,
0x0000010013517824ULL, 0x000fe200078e00ffULL, 0x00000016006b7306ULL, 0x0003e20000200c00ULL,
0x00008880105d7816ULL, 0x040fe400000000ffULL, 0x00000018ff5f7819ULL, 0x000fe20000011414ULL,
0x000000104d1c7824ULL, 0x000fe200078e024aULL, 0x00000018ff457819ULL, 0x000fe40000011411ULL,
0x00008880115c7816ULL, 0x040fe200000000ffULL, 0x0000001d006e7306ULL, 0x000fe20000200c00ULL,
0x0000010010167824ULL, 0x002fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe20000011413ULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x00008880134a7816ULL, 0x040fe200000000ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff167819ULL, 0x000fc40000011416ULL,
0x0000001e00677306ULL, 0x000fe20000200c00ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff427819ULL, 0x000fe40000011412ULL, 0x00008880124c7816ULL, 0x000fe400000000ffULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x00000016005e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff517819ULL, 0x000fce0000011451ULL, 0x0000001f00657306ULL, 0x0005e20000200c00ULL,
0x011000003f14783bULL, 0x002e6e0000000200ULL, 0x0000004000797306ULL, 0x0007e20000200c00ULL,
0x000000001c1c783bULL, 0x004eae0000004200ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff407819ULL, 0x008fe20000011410ULL, 0x0001000010107824ULL, 0x000fca00078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005300537306ULL, 0x000ff00000200c00ULL,
0x0000001000497306ULL, 0x0007f00000200c00ULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x0000010012107824ULL, 0x048fe200078e00ffULL, 0x0000000214148232ULL, 0x082fe20000000000ULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x0000000216168232ULL, 0x000fc40000000000ULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000000015158232ULL, 0x080fe20000000000ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x0000000017178232ULL, 0x000fe20000000000ULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x00000018ff597819ULL, 0x004fe4000001141cULL,
0x00000018ff587819ULL, 0x000fe4000001141dULL, 0x0000005600567306ULL, 0x000e620000200c00ULL,
0x000000ff6800720cULL, 0x000fc40003f05270ULL, 0x00000018ff817819ULL, 0x000fe4000001141eULL,
0x000088801e687816ULL, 0x000fc600000000ffULL, 0x0000005700577306ULL, 0x000eb00000200c00ULL,
0x0000001100507306ULL, 0x0007e20000200c00ULL, 0x0000541075567816ULL, 0x002fe20000000056ULL,
0x000001001d757824ULL, 0x000fca00078e00ffULL, 0x00000018ff757819ULL, 0x000fe20000011475ULL,
0x00000010004f7306ULL, 0x0003e20000200c00ULL, 0x0000541053117816ULL, 0x008fe40000000080ULL,
0x0000541066577816ULL, 0x004fca0000000057ULL, 0x0000007b007b7306ULL, 0x000fe20000200c00ULL,
0x000054107f107816ULL, 0x002fe20000000082ULL, 0x00000056142c723cULL, 0x040fec000000182cULL,
0x0000007800787306ULL, 0x000e640000200c00ULL, 0x000000101420723cULL, 0x000b6c0000001820ULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x000054107d107816ULL, 0x020fc4000000007aULL,
0x000054107c117816ULL, 0x000fca0000000063ULL, 0x0000007400747306ULL, 0x000ee40000200c00ULL,
0x000000101424723cULL, 0x000b6c0000001824ULL, 0x0000007100717306ULL, 0x000f220000200c00ULL,
0x000054107b107816ULL, 0x022fe40000000078ULL, 0x0000541064117816ULL, 0x004fc40000000079ULL,
0x000088801d787816ULL, 0x000fc600000000ffULL, 0x00000013005a7306ULL, 0x0003e20000200c00ULL,
0x0000541074567816ULL, 0x008fe20000000073ULL, 0x000000101428723cULL, 0x000b6c0000001828ULL,
0x00000012005b7306ULL, 0x0005e20000200c00ULL, 0x0000000261137810ULL, 0x002fe40007ffe0ffULL,
0x0000541071577816ULL, 0x010fc40000000072ULL, 0xfffffff87e137812ULL, 0x000fe400078ee213ULL,
0x00000018ff617819ULL, 0x000fe2000001141fULL, 0x0000006f006f7306ULL, 0x000e620000200c00ULL,
0x000088801c127816ULL, 0x044fe200000000ffULL, 0x00000010133e7824ULL, 0x000fe200078e023eULL,
0x000000561430723cULL, 0x000b660000001830ULL, 0x000000ffff637224ULL, 0x000fe400078e0012ULL,
0x0000006d006d7306ULL, 0x000ea20000200c00ULL, 0x000001001c127824ULL, 0x000fc400078e00ffULL,
0x000100001c1c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff647819ULL, 0x000fe40000011412ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x011000003e10783bULL, 0x020ee20000000200ULL,
0x0000541070567816ULL, 0x002fe4000000006fULL, 0x00000018ff1c7819ULL, 0x000fc8000001141cULL,
0x0000006900697306ULL, 0x000e620000200c00ULL, 0x000054106e577816ULL, 0x004fce000000006dULL,
0x0000006200627306ULL, 0x000ea20000200c00ULL, 0x000000561434723cULL, 0x000b6e0000001834ULL,
0x0000006000607306ULL, 0x000f220000200c00ULL, 0x000100001d577824ULL, 0x020fe200078e00ffULL,
0x00005410691d7816ULL, 0x002fc8000000006aULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x0000001c00567306ULL, 0x0003f00000200c00ULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x000054106c1c7816ULL, 0x002fe2000000006bULL, 0x0000000210108232ULL, 0x008fc40000000000ULL,
0x0000000212128232ULL, 0x000fe40000000000ULL, 0x0000000011118232ULL, 0x080fe40000000000ULL,
0x0000001c1438723cULL, 0x000b620000001838ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x0000000013138232ULL, 0x000fca0000000000ULL, 0x00005410671c7816ULL, 0x024fe40000000062ULL,
0x00005410651d7816ULL, 0x010fe20000000060ULL, 0x0000005f005f7306ULL, 0x000e620000200c00ULL,
0x000000ffff607224ULL, 0x000fca00078e0068ULL, 0x0000001c1418723cULL, 0x000b640000001818ULL,
0x0000004000407306ULL, 0x000eaa0000200c00ULL, 0x000001001e147824ULL, 0x020fe200078e00ffULL,
0x000088801f1c7816ULL, 0x040fe200000000ffULL, 0x000001001f1d7824ULL, 0x040fe200078e00ffULL,
0x0000004500457306ULL, 0x000ee20000200c00ULL, 0x000054105c157816ULL, 0x002fe2000000005fULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0000001400167306ULL, 0x0003e20000200c00ULL,
0x00000018ff1f7819ULL, 0x000fce000001141fULL, 0x0000006000177306ULL, 0x000f220000200c00ULL,
0x000054105d147816ULL, 0x002fce000000005eULL, 0x000000141020723cULL, 0x000b620000001820ULL,
0x0000004200427306ULL, 0x000e6c0000200c00ULL, 0x0000541049147816ULL, 0x024fe40000000040ULL,
0x0000541050157816ULL, 0x008fe20000000045ULL, 0x0000004300437306ULL, 0x000ea20000200c00ULL,
0x0000541017167816ULL, 0x010fe20000000016ULL, 0x000000023c457824ULL, 0x000fc800078e00ffULL,
0x000000141024723cULL, 0x000b620000001824ULL, 0x000054105b427816ULL, 0x002fe20000000042ULL,
0x0000004c004c7306ULL, 0x000e700000200c00ULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x000054105a437816ULL, 0x004fce0000000043ULL, 0x0000005100517306ULL, 0x000ea20000200c00ULL,
0x000054104c507816ULL, 0x002fe2000000004fULL, 0x00000042102c723cULL, 0x000b6c000000182cULL,
0x0000005900597306ULL, 0x000e700000200c00ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x000054104a517816ULL, 0x004fce0000000051ULL, 0x0000008100537306ULL, 0x000fe20000200c00ULL,
0x0000541056567816ULL, 0x002fe20000000059ULL, 0x000000501028723cULL, 0x000b6c0000001828ULL,
0x0000006100617306ULL, 0x000ff00000200c00ULL, 0x0000006300637306ULL, 0x000ff00000200c00ULL,
0x0000006400647306ULL, 0x000e700000200c00ULL, 0x0000007800667306ULL, 0x000ff00000200c00ULL,
0x00000075006f7306ULL, 0x000ea20000200c00ULL, 0x0000541063647816ULL, 0x002fce0000000064ULL,
0x0000005700577306ULL, 0x000e700000200c00ULL, 0x0000001c001c7306ULL, 0x000fe20000200c00ULL,
0x0000541066657816ULL, 0x004fce000000006fULL, 0x0000001d001d7306ULL, 0x000ea20000200c00ULL,
0x0000541057577816ULL, 0x002fe20000000058ULL, 0x000000641030723cULL, 0x040b6c0000001830ULL,
0x0000001e001e7306ULL, 0x000e640000200c00ULL, 0x000000561034723cULL, 0x000b6c0000001834ULL,
0x0000001f00147306ULL, 0x020ee20000200c00ULL, 0x000054101c177816ULL, 0x004fc4000000001dULL,
0x000054101e1e7816ULL, 0x002fca0000000053ULL, 0x000000161038723cULL, 0x000b620000001838ULL,
0x00005410141f7816ULL, 0x008fce0000000061ULL, 0x0000001e1018723cULL, 0x000b620000001818ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000004127f8cULL, 0x0202a2000c80043fULL,
0xfffffff845457812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004006107811ULL, 0x000fe200078e40ffULL, 0x0176880045ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff567224ULL, 0x000fe400078e0041ULL, 0x0000003d1000720cULL, 0x000fe20003f06070ULL,
0x000000ffff577224ULL, 0x000fe400078e0077ULL, 0x000000ffff127224ULL, 0x004fd400078e0046ULL,
0x000072b000000947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x008fc40000015200ULL,
0x0000040004127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x004fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011415ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000212127819ULL, 0x000fc80000001215ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040004127984ULL, 0x000ea40000000800ULL,
0x8000000012ff7812ULL, 0x004fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000106107810ULL, 0x000fe40007ffe0ffULL, 0x0000008044127810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1000720cULL, 0x000fc60003f06070ULL, 0x00006200091e7a24ULL, 0x000fd400078e0212ULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1d7819ULL, 0x000fe2000001160dULL,
0x000000100e167824ULL, 0x000fe200078e00ffULL, 0x000000123d107217ULL, 0x000fe20007800000ULL,
0x00000080ff1f7424ULL, 0x000fe200078e00ffULL, 0x000000081d497810ULL, 0x040fe20007ffe0ffULL,
0x0000000116157824ULL, 0x000fe200078e021dULL, 0x0000000c1d4f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000110117824ULL, 0x000fe400078e0a12ULL, 0x0000000115137824ULL, 0x040fe400078e020dULL,
0x0000000815147824ULL, 0x000fe200078e00ffULL, 0x0000001116117217ULL, 0x000fe20007800000ULL,
0x0000100005107824ULL, 0x000fc600078e00ffULL, 0xfffffff814177812ULL, 0x000fe200078ee213ULL,
0x0000000111127824ULL, 0x000fe200078e0a16ULL, 0x0000100010147812ULL, 0x000fe200078ec0ffULL,
0x0000000115107824ULL, 0x000fe200078e021eULL, 0x000000041d157810ULL, 0x000fe20007ffe0ffULL,
0x000000100d137824ULL, 0x000fe200078e00ffULL, 0x000000121d00720cULL, 0x080fe20003fa6070ULL,
0x000020000b147824ULL, 0x000fe200078e0214ULL, 0x000000121500720cULL, 0x000fe20003f06070ULL,
0x0000000116407824ULL, 0x000fe200078e0215ULL, 0x0000007013137812ULL, 0x000fe200078ec0ffULL,
0x00005e0010107625ULL, 0x000fe200078e001fULL, 0x00013000141c7810ULL, 0x000fc60007ffe0ffULL,
0x0000000140157824ULL, 0x000fe200078e020dULL, 0x0000001310107210ULL, 0x000fe20007fde0ffULL,
0x0000000840427824ULL, 0x040fe400078e00ffULL, 0x0000000140147824ULL, 0x000fe400078e021eULL,
0x0000000116407824ULL, 0x000fe200078e0249ULL, 0xfffffff842437812ULL, 0x000fe200078ee215ULL,
0x00005e0014147625ULL, 0x000fc800078e001fULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x0000001314147210ULL, 0x000fe20007fde0ffULL, 0x0000001017177824ULL, 0x000fe400078e021cULL,
0x0000000116427824ULL, 0x000fe400078e024fULL, 0x0000000140167824ULL, 0x000fe200078e021eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0005e2000e901c46ULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x000000124900720cULL, 0x080fe20003fa6070ULL,
0x00000010431d7824ULL, 0x000fe200078e021cULL, 0x000000124f00720cULL, 0x000fe20003fc6070ULL,
0x0000000142127824ULL, 0x000fc400078e021eULL, 0x00000001401e7824ULL, 0x040fe200078e020dULL,
0x00000000141d7faeULL, 0x0007e2000c101c46ULL, 0x0000000840437824ULL, 0x000fe400078e00ffULL,
0x0000000842497824ULL, 0x000fe400078e00ffULL, 0x00005e0016107625ULL, 0x004fc800078e001fULL,
0x00005e0012167625ULL, 0x000fe200078e001fULL, 0x0000001310107210ULL, 0x080fe40007f1e0ffULL,
0xfffffff8431f7812ULL, 0x000fe200078ee21eULL, 0x0000000142127824ULL, 0x000fe400078e020dULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000001316167210ULL, 0x000fe20007f1e0ffULL,
0x000000101f157824ULL, 0x008fe200078e021cULL, 0xfffffff849437812ULL, 0x000fc600078ee212ULL,
0x000000ffff177224ULL, 0x000fe200000e0617ULL, 0x0000000010157faeULL, 0x0005e2000e901c46ULL,
0x00000010431d7824ULL, 0x000fca00078e021cULL, 0x00000000161d7faeULL, 0x0005e2000f101c46ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x000000100e107824ULL, 0x000fe400078e00ffULL,
0x000000100d137824ULL, 0x040fe400078e00ffULL, 0x00000080ff1d7424ULL, 0x000fe200078e00ffULL,
0x000000100d117211ULL, 0x000fe400078fe8ffULL, 0x0000007013137812ULL, 0x000fe400078ec0ffULL,
0x0000000411147810ULL, 0x040fe20007ffe0ffULL, 0x0000000111107824ULL, 0x140fe200078e020dULL,
0x0000000811157810ULL, 0x040fe20007ffe0ffULL, 0x00000008111f7824ULL, 0x040fe200078e00ffULL,
0x0000000c11407810ULL, 0x000fe20007ffe0ffULL, 0x0000000114127824ULL, 0x000fc400078e020dULL,
0x0000000814437824ULL, 0x040fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee210ULL,
0x0000100005107824ULL, 0x000fe400078e00ffULL, 0x0000000114147824ULL, 0x000fe200078e021eULL,
0xfffffff843437812ULL, 0x000fe200078ee212ULL, 0x0000000115167824ULL, 0x100fe200078e021eULL,
0x0000100010127812ULL, 0x000fe200078ec0ffULL, 0x0000000111107824ULL, 0x100fe400078e021eULL,
0x00000001401c7824ULL, 0x000fc400078e021eULL, 0x0000000115177824ULL, 0x140fe400078e020dULL,
0x00000008151e7824ULL, 0x000fe400078e00ffULL, 0x0000000140157824ULL, 0x000fe400078e020dULL,
0x00005e0010107625ULL, 0x000fe200078e001dULL, 0xfffffff81e497812ULL, 0x000fc600078ee217ULL,
0x0000000840407824ULL, 0x000fe200078e00ffULL, 0x0000001310107210ULL, 0x000fe20007f1e0ffULL,
0x000020000b127824ULL, 0x000fe400078e0212ULL, 0x00005e0016167625ULL, 0x080fe200078e001dULL,
0xfffffff8404f7812ULL, 0x000fe400078ee215ULL, 0x0001300012127810ULL, 0x000fe20007ffe0ffULL,
0x00005e0014147625ULL, 0x000fe200078e001dULL, 0x0000001316167210ULL, 0x000fc60007fbe0ffULL,
0x00005e001c1c7625ULL, 0x000fc800078e001dULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000001314147210ULL, 0x080fe20007f1e0ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0212ULL,
0x000000131c1c7210ULL, 0x000fe20007fde0ffULL, 0x0000001043437824ULL, 0x100fe400078e0212ULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101f7faeULL, 0x0005e2000b901c46ULL, 0x0000001049497824ULL, 0x100fe400078e0212ULL,
0x000000ffff177224ULL, 0x000fe200028e0617ULL, 0x0000000014437faeULL, 0x0005e2000b901c46ULL,
0x000000104f4f7824ULL, 0x000fc400078e0212ULL, 0x000000ffff1d7224ULL, 0x000fe200030e061dULL,
0x0000000016497faeULL, 0x0005e8000b901c46ULL, 0x000000001c4f7faeULL, 0x0005e4000b901c46ULL,
0x0000000805107824ULL, 0x004fe200078e00ffULL, 0xfffffff00c517812ULL, 0x040fe200078ec0ffULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0xffffffe00c127812ULL, 0x000fe400078ec0ffULL,
0x0000000810107812ULL, 0x000fc400078ec0ffULL, 0x000000100c117812ULL, 0x000fe400078ec0ffULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x0000000151517824ULL, 0x000fe400078e0210ULL,
0x0000000112117824ULL, 0x000fc600078e0211ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000080e117824ULL, 0x000fe200078e0211ULL, 0x000176a851507810ULL, 0x000fca0007ffe0ffULL,
0x00000000500403c2ULL, 0x000ea40000040000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00a9b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe2000170f070ULL, 0xffffff8000002947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a80051567f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176280011107f8cULL, 0x000e64000c80043fULL,
0x0000000000147805ULL, 0x000fc40000015200ULL, 0x0000001008177812ULL, 0x000fca00078ec0ffULL,
0x0000000112177824ULL, 0x000fc800078e0217ULL, 0x000000080e1c7824ULL, 0x000fca00078e0217ULL,
0x01762c001c177984ULL, 0x000f240000000800ULL, 0x8000000017ff7812ULL, 0x012fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1e7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101e00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x00000016141d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011417ULL,
0x0000001d12127211ULL, 0x000fca00078110ffULL, 0x000000ffff177224ULL, 0x000fca00000e0617ULL,
0x0000000212127819ULL, 0x000fc80000001217ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01762c001c177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008013107810ULL, 0x000fca0007ffe048ULL, 0x0000000147107824ULL, 0x000fca00078e0210ULL,
0x0170000010127984ULL, 0x000e680000000800ULL, 0x0172000010147984ULL, 0x0004e20000000800ULL,
0x000000411200720bULL, 0x002fe20003f1d000ULL, 0x0000d4d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000157806ULL, 0x004fc800000e0100ULL, 0x0000ffff15ff7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000ffff567224ULL, 0x008fd200078e0041ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000013c117811ULL, 0x000fe400078ff0ffULL, 0x000000411200720bULL, 0x000fe40003f14000ULL,
0x0000003c1100720cULL, 0x000fe20003fa5270ULL, 0x0000d4927f007947ULL, 0x000fd4000b800000ULL,
0x0000000000167806ULL, 0x000fc400000e0100ULL, 0x000000803c1cd824ULL, 0x000fe200078e0213ULL,
0x000000411210d209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991016117816ULL, 0x000fe200000000ffULL, 0x000000014713d824ULL, 0x000fc600078e021cULL,
0x000000ff1100720cULL, 0x000fe40003f05270ULL, 0x017400101300d388ULL, 0x0003f60000000800ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004112107209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff16ff7812ULL, 0x000fc6000780c0ffULL,
0x0000004110107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000407308ULL, 0x000e640000000800ULL, 0x0000004007077220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe2000001160dULL,
0x0000d3b27f007947ULL, 0x000fea000b800000ULL, 0x00001f1040107589ULL, 0x0002a400000e0000ULL,
0x0000001020207220ULL, 0x084fe40000410000ULL, 0x0000001021217220ULL, 0x080fe40000410000ULL,
0x0000001024247220ULL, 0x080fe40000410000ULL, 0x0000001025257220ULL, 0x000fc40000410000ULL,
0x0000001028287220ULL, 0x080fe40000410000ULL, 0x0000001029297220ULL, 0x080fe40000410000ULL,
0x000000102c2c7220ULL, 0x080fe40000410000ULL, 0x000000102d2d7220ULL, 0x080fe40000410000ULL,
0x0000001030307220ULL, 0x080fe40000410000ULL, 0x0000001031317220ULL, 0x000fc40000410000ULL,
0x0000001034347220ULL, 0x080fe40000410000ULL, 0x0000001035357220ULL, 0x080fe40000410000ULL,
0x0000001038387220ULL, 0x080fe40000410000ULL, 0x0000001039397220ULL, 0x080fe40000410000ULL,
0x0000001018187220ULL, 0x080fe40000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d107811ULL, 0x000fe200078ff0ffULL,
0x0000d2c27f007947ULL, 0x000fea000b800000ULL, 0x00001f1040107589ULL, 0x0004e400000e0000ULL,
0x0000001022227220ULL, 0x088fe40000410000ULL, 0x0000001023237220ULL, 0x080fe40000410000ULL,
0x0000001026267220ULL, 0x080fe40000410000ULL, 0x0000001027277220ULL, 0x080fe40000410000ULL,
0x000000102a2a7220ULL, 0x080fe40000410000ULL, 0x000000102b2b7220ULL, 0x000fc40000410000ULL,
0x000000102e2e7220ULL, 0x080fe40000410000ULL, 0x000000102f2f7220ULL, 0x080fe40000410000ULL,
0x0000001032327220ULL, 0x080fe40000410000ULL, 0x0000001033337220ULL, 0x080fe40000410000ULL,
0x0000001036367220ULL, 0x080fe40000410000ULL, 0x0000001037377220ULL, 0x000fc40000410000ULL,
0x000000103a3a7220ULL, 0x080fe40000410000ULL, 0x000000103b3b7220ULL, 0x080fe40000410000ULL,
0x000000101a1a7220ULL, 0x080fe40000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff16ff7812ULL, 0x000fe20007800815ULL,
0x00000001ff167424ULL, 0x000fe200078e00ffULL, 0x0000004112567209ULL, 0x000fd60007810000ULL,
0x8000005612120221ULL, 0x000fe20000010000ULL, 0x00007610ff160816ULL, 0x000fc60000000016ULL,
0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL, 0x0000001200030308ULL, 0x000e640000000800ULL,
0x0000000314140220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000714077221ULL, 0x000fc40000010000ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0x0000000846537824ULL, 0x000fc800078e00ffULL, 0x0000000108127824ULL, 0x000fca00078e0253ULL,
0x0176ac0012137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804877ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000021000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001e000000947ULL, 0x000fea0003800000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x0000000108177824ULL, 0x000fc400078e0253ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0176ac0017137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804877ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991016107816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff137819ULL, 0x000fe4000001160dULL, 0x0000541000127816ULL, 0x000fe20000000000ULL,
0x0000ce727f007947ULL, 0x000fea000b800000ULL, 0x00001f1312027589ULL, 0x0002e400000e0000ULL,
0x0000000813107810ULL, 0x000fe20007ffe0ffULL, 0x0000cec27f007947ULL, 0x000fea000b800000ULL,
0x00001f1012007589ULL, 0x0002a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001013107810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff1c7224ULL, 0x000fe200078e0012ULL,
0x00004fe0001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0000d97000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001813107810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff1c7224ULL, 0x004fe200078e0012ULL, 0x00005050001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x0000d90000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000155107824ULL, 0x042fe200078e0254ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000008554f7824ULL, 0x000fe400078e00ffULL, 0x000000020b587824ULL, 0x000fc600078e0246ULL,
0xfffffff84f4f7812ULL, 0x000fe400078ee210ULL, 0x0001300058587811ULL, 0x000fca00078e60ffULL,
0x000000104f4f7824ULL, 0x100fe400078e0258ULL, 0x000000104e4c7824ULL, 0x100fe400078e0258ULL,
0x000000104b4a7824ULL, 0x100fe200078e0258ULL, 0x000000004f1c783bULL, 0x004e620000004200ULL,
0x000000104d497824ULL, 0x000fc600078e0258ULL, 0x000000004c40783bULL, 0x000fe80000004200ULL,
0x000000004a10783bULL, 0x000ea80000004200ULL, 0x000000004914783bULL, 0x000f220000004200ULL,
0x00000018ff847819ULL, 0x002fe2000001141cULL, 0x000001001c627824ULL, 0x040fe200078e00ffULL,
0x000088801c877816ULL, 0x040fe200000000ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe2000001141dULL, 0x000001001d637824ULL, 0x040fe200078e00ffULL,
0x000088801d667816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x00000018ff627819ULL, 0x000fe20000011462ULL, 0x0001000010677824ULL, 0x004fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x00000100116d7824ULL, 0x040fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001141eULL, 0x0001000011687824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe2000001141fULL, 0x0000001c00857306ULL, 0x0003e20000200c00ULL,
0x000088801e837816ULL, 0x000fc400000000ffULL, 0x000088801f6e7816ULL, 0x000fe400000000ffULL,
0x00000018ff637819ULL, 0x000fe40000011463ULL, 0x00000018ff607819ULL, 0x000fe20000011410ULL,
0x0000001d00867306ULL, 0x0005e20000200c00ULL, 0x000001001e1c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe20000011411ULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00008880407d7816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x0000006200887306ULL, 0x0002e20000200c00ULL, 0x00000100411d7824ULL, 0x044fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x0000888041747816ULL, 0x000fe400000000ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c00827306ULL, 0x0005e20000200c00ULL,
0x000001001f627824ULL, 0x042fe200078e00ffULL, 0x00008880106b7816ULL, 0x000fe200000000ffULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x00008880116a7816ULL, 0x000fc400000000ffULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x0000001d007b7306ULL, 0x0003e20000200c00ULL,
0x00000100401c7824ULL, 0x004fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00000018ff647819ULL, 0x000fe40000011442ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000001e007f7306ULL, 0x000fe20000200c00ULL, 0x00000100431d7824ULL, 0x002fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fc40000011443ULL, 0x0000888042777816ULL, 0x000fe400000000ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c007c7306ULL, 0x0003e20000200c00ULL,
0x0000888043727816ULL, 0x040fe200000000ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011440ULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011441ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000001f00807306ULL, 0x000fe20000200c00ULL,
0x00000100421c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fc40000011441ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000001d00757306ULL, 0x000fe20000200c00ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff5e7819ULL, 0x000fe40000011412ULL,
0x0000888012657816ULL, 0x000fe400000000ffULL, 0x00000018ff5d7819ULL, 0x000fe20000011413ULL,
0x0000001c00767306ULL, 0x0003e20000200c00ULL, 0x00000018ff5c7819ULL, 0x010fc40000011414ULL,
0x00000018ff5b7819ULL, 0x000fe40000011415ULL, 0x00000018ff6d7819ULL, 0x000fe4000001146dULL,
0x00000018ff677819ULL, 0x000fe20000011467ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x00000100101c7824ULL, 0x002fe200078e00ffULL, 0x0000541087107816ULL, 0x008fe40000000088ULL,
0x00000018ff687819ULL, 0x000fe40000011468ULL, 0x00000018ff6c7819ULL, 0x000fc4000001141cULL,
0x011800003f1c783bULL, 0x000e620000000200ULL, 0x0000006300897306ULL, 0x0004e20000200c00ULL,
0x00000018ff5a7819ULL, 0x000fe40000011416ULL, 0x00000018ff597819ULL, 0x000fca0000011417ULL,
0x0000008400847306ULL, 0x000f220000200c00ULL, 0x0001000012637824ULL, 0x004fca00078e00ffULL,
0x00000018ff637819ULL, 0x000fe40000011463ULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x0000541066117816ULL, 0x008fce0000000089ULL, 0x0000007e007e7306ULL, 0x000ff00000200c00ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x000000021c1c8232ULL, 0x002fce0000000000ULL,
0x0000008300837306ULL, 0x000e620000200c00ULL, 0x000000021e1e8232ULL, 0x000fe40000000000ULL,
0x000000001d1d8232ULL, 0x080fe40000000000ULL, 0x000000001f1f8232ULL, 0x000fc60000000000ULL,
0x0000006e006e7306ULL, 0x000fe80000200c00ULL, 0x000000101c20723cULL, 0x000b680000001820ULL,
0x0000006200817306ULL, 0x0006660000200c00ULL, 0x0000541085107816ULL, 0x030fc40000000084ULL,
0x0000541086117816ULL, 0x004fc60000000069ULL, 0x0000007d007d7306ULL, 0x000ea20000200c00ULL,
0x0000010012627824ULL, 0x008fe200078e00ffULL, 0x0000888014127816ULL, 0x040fe400000000ffULL,
0x000000101c24723cULL, 0x000b640000001824ULL, 0x00000018ff627819ULL, 0x000fe20000011462ULL,
0x000000ffff697224ULL, 0x000fe200078e0012ULL, 0x0000007400747306ULL, 0x000ee20000200c00ULL,
0x0000010014127824ULL, 0x040fe400078e00ffULL, 0x0000541083107816ULL, 0x022fe20000000082ULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x000054106e117816ULL, 0x000fc40000000081ULL,
0x00000018ff6e7819ULL, 0x000fe20000011412ULL, 0x0000004200717306ULL, 0x0003e20000200c00ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000888015817816ULL, 0x000fe200000000ffULL,
0x000000101c28723cULL, 0x000f680000001828ULL, 0x0000004300707306ULL, 0x0009e20000200c00ULL,
0x0000888013427816ULL, 0x002fce00000000ffULL, 0x0000004000797306ULL, 0x0003e20000200c00ULL,
0x0000010013437824ULL, 0x050fe400078e00ffULL, 0x0001000013137824ULL, 0x000fc600078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x00000041007a7306ULL, 0x0009e20000200c00ULL,
0x000054107f407816ULL, 0x002fe2000000007eULL, 0x00000100157e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fca0000011413ULL, 0x0000007800787306ULL, 0x000e620000200c00ULL,
0x0000541080417816ULL, 0x010fce000000006fULL, 0x0000007300737306ULL, 0x000f220000200c00ULL,
0x000000401c2c723cULL, 0x000b6e000000182cULL, 0x000054107d407816ULL, 0x024fe2000000007cULL,
0x0000007700777306ULL, 0x000fe20000200c00ULL, 0x0000541074417816ULL, 0x008fc4000000007bULL,
0x00000018ff747819ULL, 0x000fca000001147eULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x000000401c30723cULL, 0x000bee0000001830ULL, 0x0000001300667306ULL, 0x0007e20000200c00ULL,
0x0000541079407816ULL, 0x022fe40000000078ULL, 0x000054107a417816ULL, 0x010fca0000000073ULL,
0x0000006400647306ULL, 0x000e620000200c00ULL, 0x011800003e10783bULL, 0x008ee20000000200ULL,
0x000000401c34723cULL, 0x000b6c0000001834ULL, 0x0000006100617306ULL, 0x000f220000200c00ULL,
0x0001000015407824ULL, 0x020fe200078e00ffULL, 0x0000541072157816ULL, 0x004fc40000000075ULL,
0x0000888016727816ULL, 0x000fe400000000ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000001400417306ULL, 0x0005f00000200c00ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x0000541077147816ULL, 0x004fce0000000076ULL, 0x000000141c38723cULL, 0x000b620000001838ULL,
0x0000006c006c7306ULL, 0x000fec0000200c00ULL, 0x0000541071147816ULL, 0x022fe40000000064ULL,
0x0000541070157816ULL, 0x010fe20000000061ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000000210108232ULL, 0x088fe20000000000ULL, 0x000000ffff617224ULL, 0x000fe200078e0072ULL,
0x0000000212128232ULL, 0x000fc40000000000ULL, 0x0000000011118232ULL, 0x080fe20000000000ULL,
0x000000141c18723cULL, 0x000b620000001818ULL, 0x0000000013138232ULL, 0x000fe20000000000ULL,
0x0000006d006d7306ULL, 0x000e6a0000200c00ULL, 0x0000010016147824ULL, 0x060fe200078e00ffULL,
0x00008880171e7816ULL, 0x040fe200000000ffULL, 0x00000100171f7824ULL, 0x000fe200078e00ffULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fc40000011414ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x000054106a157816ULL, 0x002fce000000006dULL, 0x0000006700677306ULL, 0x000e700000200c00ULL,
0x0000006800687306ULL, 0x000eb00000200c00ULL, 0x00000014001c7306ULL, 0x0007f00000200c00ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x000054106b147816ULL, 0x008fce000000006cULL,
0x0000006200627306ULL, 0x000ee20000200c00ULL, 0x000000141020723cULL, 0x000b6e0000001820ULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x0000541067147816ULL, 0x022fe40000000060ULL,
0x0000541068157816ULL, 0x004fca000000005fULL, 0x0000004300437306ULL, 0x000e640000200c00ULL,
0x000000141024723cULL, 0x000b6c0000001824ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x0000541065147816ULL, 0x028fe40000000062ULL, 0x0000541042157816ULL, 0x002fca0000000043ULL,
0x0000005d005d7306ULL, 0x000e640000200c00ULL, 0x000000141028723cULL, 0x000b6c0000001828ULL,
0x0000006300637306ULL, 0x000ea20000200c00ULL, 0x0001000017147824ULL, 0x020fce00078e00ffULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x0000541066157816ULL, 0x002fe4000000005dULL,
0x00000018ff427819ULL, 0x000fca0000011414ULL, 0x0000004000407306ULL, 0x000e620000200c00ULL,
0x0000541063147816ULL, 0x004fce000000005eULL, 0x00000061001d7306ULL, 0x000ea20000200c00ULL,
0x00000014102c723cULL, 0x000b6e000000182cULL, 0x0000005c005c7306ULL, 0x000ee20000200c00ULL,
0x00005410405d7816ULL, 0x002fce000000005bULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x000054101d1c7816ULL, 0x004fce000000001cULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x00005410415c7816ULL, 0x008fce000000005cULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x0000005c1034723cULL, 0x000b6e0000001834ULL, 0x0000006e006e7306ULL, 0x000e700000200c00ULL,
0x00000081006f7306ULL, 0x000ff00000200c00ULL, 0x0000007400747306ULL, 0x000ea20000200c00ULL,
0x0000541069147816ULL, 0x022fce000000006eULL, 0x0000001e001e7306ULL, 0x000ff00000200c00ULL,
0x0000001f001f7306ULL, 0x000e620000200c00ULL, 0x000054106f157816ULL, 0x004fce0000000074ULL,
0x0000001600177306ULL, 0x000ea20000200c00ULL, 0x000000141030723cULL, 0x000b6e0000001830ULL,
0x0000004200427306ULL, 0x000ee20000200c00ULL, 0x000054101e1d7816ULL, 0x002fe4000000001fULL,
0x00005410175a7816ULL, 0x004fca000000005aULL, 0x0000001c1038723cULL, 0x000b620000001838ULL,
0x00005410425b7816ULL, 0x008fce0000000059ULL, 0x0000005a1018723cULL, 0x000b620000001818ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000004127f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008006107811ULL, 0x000fe200078e40ffULL, 0x0176900045ff7f8cULL, 0x0007e2000c80043fULL,
0x0000000105127812ULL, 0x004fe400078ec0ffULL, 0x0000003d1000720cULL, 0x000fda0003f06070ULL,
0x00004b9000000947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x008fc40000015200ULL,
0x0000040004127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x004fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011415ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000212127819ULL, 0x000fc80000001215ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040004127984ULL, 0x000ea40000000800ULL,
0x8000000012ff7812ULL, 0x004fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000106107810ULL, 0x000fe40007ffe0ffULL, 0x000000c044127810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1000720cULL, 0x000fc60003f06070ULL, 0x00006200091c7a24ULL, 0x000fd400078e0212ULL,
0x000003c000008947ULL, 0x000fea0003800000ULL, 0x000000123d107217ULL, 0x000fe20007800000ULL,
0x000000100e177824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x100fe2000001160dULL,
0x000000100d1d7824ULL, 0x000fe400078e00ffULL, 0x0000000110107824ULL, 0x000fe200078e0a12ULL,
0x00000004161e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000117127824ULL, 0x000fe200078e0216ULL,
0x000000701d1d7812ULL, 0x000fe200078ec0ffULL, 0x00000080ff1f7424ULL, 0x000fe200078e00ffULL,
0x0000001017107217ULL, 0x000fe20007800000ULL, 0x0000000112117824ULL, 0x000fe200078e021cULL,
0x0000000c16427810ULL, 0x000fe20007ffe0ffULL, 0x0000000112137824ULL, 0x000fc400078e020dULL,
0x0000000110147824ULL, 0x000fe400078e0a17ULL, 0x0000000812127824ULL, 0x000fe400078e00ffULL,
0x0000000117407824ULL, 0x000fe200078e021eULL, 0x000000141e00720cULL, 0x080fe20003f06070ULL,
0x00005e0011107625ULL, 0x000fe200078e001fULL, 0xfffffff812157812ULL, 0x000fe400078ee213ULL,
0x000000141600720cULL, 0x000fe20003fa6070ULL, 0x00000001401e7824ULL, 0x000fe200078e020dULL,
0x0000001d10127210ULL, 0x000fe20007fde0ffULL, 0x0000000840417824ULL, 0x000fc400078e00ffULL,
0x0000000140107824ULL, 0x000fe400078e021cULL, 0x000000ffff137224ULL, 0x000fe200030e0611ULL,
0xfffffff841417812ULL, 0x000fe200078ee21eULL, 0x00005e0010107625ULL, 0x000fe200078e001fULL,
0x00000008161e7810ULL, 0x000fc60007ffe0ffULL, 0x0000001015157824ULL, 0x000fe200078e0258ULL,
0x0000001d10107210ULL, 0x000fe20007fde0ffULL, 0x0000000117407824ULL, 0x000fc600078e021eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012157faeULL, 0x0005e2000e901c46ULL,
0x0000000140167824ULL, 0x000fe200078e021cULL, 0x000000141e00720cULL, 0x080fe20003fa6070ULL,
0x00000001171e7824ULL, 0x000fe400078e0242ULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x000000144200720cULL, 0x000fe20003fc6070ULL, 0x0000001041177824ULL, 0x000fe400078e0258ULL,
0x000000011e147824ULL, 0x000fe400078e021cULL, 0x0000000840417824ULL, 0x000fe200078e00ffULL,
0x0000000010177faeULL, 0x0007e2000c101c46ULL, 0x00005e0016127625ULL, 0x004fc800078e001fULL,
0x0000000140167824ULL, 0x000fe200078e020dULL, 0x0000001d12127210ULL, 0x000fe20007f1e0ffULL,
0x00005e0014147625ULL, 0x000fc600078e001fULL, 0xfffffff8411f7812ULL, 0x000fe200078ee216ULL,
0x000000011e1c7824ULL, 0x040fe400078e020dULL, 0x000000081e437824ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x0000001d14147210ULL, 0x000fe20007f1e0ffULL,
0x000000101f117824ULL, 0x008fe200078e0258ULL, 0xfffffff843417812ULL, 0x000fc600078ee21cULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x0000000012117faeULL, 0x0005e2000e901c46ULL,
0x0000001041177824ULL, 0x000fca00078e0258ULL, 0x0000000014177faeULL, 0x0005e2000f101c46ULL,
0x000002f000007947ULL, 0x000fea0003800000ULL, 0x000000100e107824ULL, 0x000fe400078e00ffULL,
0x000000100d1d7824ULL, 0x040fe400078e00ffULL, 0x00000080ff137424ULL, 0x000fe200078e00ffULL,
0x000000100d117211ULL, 0x000fe400078fe8ffULL, 0x000000701d1d7812ULL, 0x000fe400078ec0ffULL,
0x0000000411127810ULL, 0x040fe20007ffe0ffULL, 0x0000000111107824ULL, 0x040fe200078e020dULL,
0x0000000811177810ULL, 0x040fe20007ffe0ffULL, 0x00000008111f7824ULL, 0x040fe200078e00ffULL,
0x0000000c111e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000112147824ULL, 0x000fc400078e021cULL,
0x0000000112157824ULL, 0x040fe200078e020dULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee210ULL,
0x0000000111107824ULL, 0x100fe400078e021cULL, 0x0000000812407824ULL, 0x000fe400078e00ffULL,
0x0000000117167824ULL, 0x140fe400078e021cULL, 0x000000011e127824ULL, 0x000fe200078e021cULL,
0xfffffff840417812ULL, 0x000fe200078ee215ULL, 0x00000001171c7824ULL, 0x000fc400078e020dULL,
0x0000000817437824ULL, 0x000fe400078e00ffULL, 0x00005e0010107625ULL, 0x000fc600078e0013ULL,
0xfffffff843437812ULL, 0x000fe200078ee21cULL, 0x000000011e177824ULL, 0x000fe200078e020dULL,
0x0000001d10107210ULL, 0x000fe20007f1e0ffULL, 0x000000081e1e7824ULL, 0x000fe400078e00ffULL,
0x00005e0014147625ULL, 0x000fc600078e0013ULL, 0xfffffff81e597812ULL, 0x000fe200078ee217ULL,
0x00005e0016167625ULL, 0x000fc800078e0013ULL, 0x00005e0012127625ULL, 0x000fe200078e0013ULL,
0x0000001d16167210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000001d14147210ULL, 0x080fe20007f1e0ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0258ULL,
0x0000001d12127210ULL, 0x000fe20007fde0ffULL, 0x0000001041417824ULL, 0x100fe400078e0258ULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101f7faeULL, 0x0005e2000b901c46ULL, 0x0000001043437824ULL, 0x100fe400078e0258ULL,
0x000000ffff177224ULL, 0x000fe200028e0617ULL, 0x0000000014417faeULL, 0x0005e2000b901c46ULL,
0x0000001059597824ULL, 0x000fc400078e0258ULL, 0x000000ffff137224ULL, 0x000fe200030e0613ULL,
0x0000000016437faeULL, 0x0005e8000b901c46ULL, 0x0000000012597faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0xfffffff00c117812ULL, 0x040fe200078ec0ffULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0xffffffe00c137812ULL, 0x040fe400078ec0ffULL,
0x000000100c167812ULL, 0x000fe200078ec0ffULL, 0x0000000846117824ULL, 0x000fe200078e0211ULL,
0x000000080c107812ULL, 0x000fc400078ec0ffULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x0000001310167210ULL, 0x000fd60007ffe016ULL, 0x00000000520403c2ULL, 0x000ea40000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a800117c7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176480016107f8cULL, 0x004464000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x01764c0016157984ULL, 0x000f240000000800ULL, 0x8000000015ff7812ULL, 0x012fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001412177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001714147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01764c0016157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001001d107810ULL, 0x000fca0007ffe048ULL, 0x0000000147107824ULL, 0x000fca00078e0210ULL,
0x0170000010137984ULL, 0x000e680000000800ULL, 0x0172000010127984ULL, 0x0004e20000000800ULL,
0x000000561300720bULL, 0x002fe20003f1d000ULL, 0x0000b1127f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x004fc800000e0100ULL, 0x0000ffff14ff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff677424ULL, 0x000fd600078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x000000023c117811ULL, 0x000fe400078ff0ffULL,
0x000000561300720bULL, 0x000fe40003f14000ULL, 0x0000003c1100720cULL, 0x000fe20003fa5270ULL,
0x0000b0e27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000157806ULL, 0x000fc400000e0100ULL,
0x000000803c16d824ULL, 0x000fe200078e021dULL, 0x000000135610d209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991015117816ULL, 0x000fe200000000ffULL,
0x000000014717d824ULL, 0x000fc600078e0216ULL, 0x000000ff1100720cULL, 0x000fe40003f05270ULL,
0x017400101700d388ULL, 0x0003f60000000800ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000001356117209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff15ff7812ULL, 0x000fc6000780c0ffULL, 0x8000001156107221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000167308ULL, 0x000e640000000800ULL,
0x0000001607077220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe2000001160dULL, 0x0000b0127f007947ULL, 0x000fea000b800000ULL,
0x00001f1016107589ULL, 0x0002a400000e0000ULL, 0x0000001020207220ULL, 0x084fe40000410000ULL,
0x0000001021217220ULL, 0x080fe40000410000ULL, 0x0000001024247220ULL, 0x080fe40000410000ULL,
0x0000001025257220ULL, 0x000fc40000410000ULL, 0x0000001028287220ULL, 0x080fe40000410000ULL,
0x0000001029297220ULL, 0x080fe40000410000ULL, 0x000000102c2c7220ULL, 0x080fe40000410000ULL,
0x000000102d2d7220ULL, 0x080fe40000410000ULL, 0x0000001030307220ULL, 0x080fe40000410000ULL,
0x0000001031317220ULL, 0x000fc40000410000ULL, 0x0000001034347220ULL, 0x080fe40000410000ULL,
0x0000001035357220ULL, 0x080fe40000410000ULL, 0x0000001038387220ULL, 0x080fe40000410000ULL,
0x0000001039397220ULL, 0x080fe40000410000ULL, 0x0000001018187220ULL, 0x080fe40000410000ULL,
0x0000001019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080d107811ULL, 0x000fe200078ff0ffULL, 0x0000af227f007947ULL, 0x000fea000b800000ULL,
0x00001f1016107589ULL, 0x00046400000e0000ULL, 0x0000001022227220ULL, 0x082fe40000410000ULL,
0x0000001023237220ULL, 0x080fe40000410000ULL, 0x0000001026267220ULL, 0x080fe40000410000ULL,
0x0000001027277220ULL, 0x080fe40000410000ULL, 0x000000102a2a7220ULL, 0x080fe40000410000ULL,
0x000000102b2b7220ULL, 0x000fc40000410000ULL, 0x000000102e2e7220ULL, 0x080fe40000410000ULL,
0x000000102f2f7220ULL, 0x080fe40000410000ULL, 0x0000001032327220ULL, 0x080fe40000410000ULL,
0x0000001033337220ULL, 0x080fe40000410000ULL, 0x0000001036367220ULL, 0x080fe40000410000ULL,
0x0000001037377220ULL, 0x000fc40000410000ULL, 0x000000103a3a7220ULL, 0x080fe40000410000ULL,
0x000000103b3b7220ULL, 0x080fe40000410000ULL, 0x000000101a1a7220ULL, 0x080fe40000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff15ff7812ULL, 0x000fe20007800814ULL, 0x00000001ff677424ULL, 0x000fe200078e00ffULL,
0x0000001356567209ULL, 0x000fd60007810000ULL, 0x8000005613130221ULL, 0x000fe20000010000ULL,
0x00007610ff670816ULL, 0x000fc60000000067ULL, 0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL,
0x0000001300030308ULL, 0x000e640000000800ULL, 0x0000000312120220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000712077221ULL, 0x008fc40000010000ULL,
0x0000000000107805ULL, 0x000fca0000015200ULL, 0x0176ac0051127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804857ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210157210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001512127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac0051127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe40007804857ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991067107816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff137819ULL, 0x000fe4000001160dULL, 0x0000541000127816ULL, 0x000fe20000000000ULL,
0x0000ab227f007947ULL, 0x000fea000b800000ULL, 0x00001f1312027589ULL, 0x0002e400000e0000ULL,
0x0000000813107810ULL, 0x000fe20007ffe0ffULL, 0x0000ab727f007947ULL, 0x000fea000b800000ULL,
0x00001f1012007589ULL, 0x0002a400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001013107810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff1c7224ULL, 0x000fe200078e0012ULL,
0x000075c0001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0000b39000007944ULL, 0x00cfea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001813107810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff1c7224ULL, 0x004fe200078e0012ULL, 0x00007630001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x0000b32000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000100005107824ULL, 0x002fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000155547824ULL, 0x040fe400078e0254ULL, 0x0000000855117824ULL, 0x000fe200078e00ffULL,
0x0000100010107812ULL, 0x000fc800078ec0ffULL, 0xfffffff811117812ULL, 0x000fe200078ee254ULL,
0x000020000b107824ULL, 0x000fca00078e0210ULL, 0x0001300010527810ULL, 0x000fca0007ffe0ffULL,
0x0000001011147824ULL, 0x100fe400078e0252ULL, 0x000000104e407824ULL, 0x100fe400078e0252ULL,
0x000000104b107824ULL, 0x100fe400078e0252ULL, 0x000000001414783bULL, 0x004e620000004200ULL,
0x000000104d1c7824ULL, 0x000fc600078e0252ULL, 0x000000004040783bULL, 0x000fe80000004200ULL,
0x000000001010783bULL, 0x000ea80000004200ULL, 0x000000001c1c783bULL, 0x000f220000004200ULL,
0x00000018ff807819ULL, 0x002fe20000011414ULL, 0x00000100145c7824ULL, 0x040fe200078e00ffULL,
0x0000888014837816ULL, 0x040fe200000000ffULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe20000011415ULL, 0x00000100155d7824ULL, 0x040fe200078e00ffULL,
0x0000888015627816ULL, 0x040fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x00000018ff5c7819ULL, 0x000fe2000001145cULL, 0x0001000012607824ULL, 0x004fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fc40000011415ULL, 0x00000018ff777819ULL, 0x000fe40000011416ULL,
0x00000018ff6a7819ULL, 0x000fe20000011417ULL, 0x0000001400817306ULL, 0x0003e20000200c00ULL,
0x00008880167f7816ULL, 0x000fe400000000ffULL, 0x0000888017687816ULL, 0x000fe400000000ffULL,
0x00000018ff717819ULL, 0x000fe40000011440ULL, 0x0000888040787816ULL, 0x000fe200000000ffULL,
0x0000001500827306ULL, 0x0005e20000200c00ULL, 0x0000010016147824ULL, 0x042fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe2000001145dULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fc40000011410ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000005c00847306ULL, 0x0002e20000200c00ULL, 0x0000010041157824ULL, 0x004fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x00000018ff587819ULL, 0x000fe40000011411ULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000014007e7306ULL, 0x0005e20000200c00ULL,
0x00000100175c7824ULL, 0x042fe200078e00ffULL, 0x0000888010637816ULL, 0x000fe200000000ffULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x0000888011617816ULL, 0x000fc400000000ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000001500767306ULL, 0x0003e20000200c00ULL,
0x0000010040147824ULL, 0x044fe200078e00ffULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x0000888041737816ULL, 0x000fe400000000ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000016007a7306ULL, 0x000fe20000200c00ULL,
0x0000010043157824ULL, 0x002fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fc40000011440ULL,
0x00000018ff5a7819ULL, 0x000fe40000011443ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x0000001400757306ULL, 0x0003e20000200c00ULL, 0x00008880436b7816ULL, 0x040fe200000000ffULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011442ULL,
0x0000888042707816ULL, 0x040fe400000000ffULL, 0x00000018ff6d7819ULL, 0x000fe20000011441ULL,
0x0000001700797306ULL, 0x000fe20000200c00ULL, 0x0000010042147824ULL, 0x042fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe20000011412ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fc40000011414ULL, 0x00000015006e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff557819ULL, 0x000fe40000011413ULL, 0x00000018ff4b7819ULL, 0x010fe2000001141cULL,
0x00000014006f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff4d7819ULL, 0x000fe4000001141dULL,
0x00000018ff547819ULL, 0x000fc4000001141fULL, 0x00000018ff4e7819ULL, 0x000fe4000001141eULL,
0x00000018ff607819ULL, 0x000fe20000011460ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x0000010010147824ULL, 0x042fe400078e00ffULL, 0x0001000010107824ULL, 0x000fc600078e00ffULL,
0x00000018ff667819ULL, 0x000fe40000011414ULL, 0x012000003f14783bULL, 0x000e620000000200ULL,
0x0000005d00857306ULL, 0x0005220000200c00ULL, 0x00000018ff107819ULL, 0x000fce0000011410ULL,
0x0000004000747306ULL, 0x0007e20000200c00ULL, 0x00000100135d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x0000008000807306ULL, 0x000ea20000200c00ULL,
0x0000010011407824ULL, 0x048fe400078e00ffULL, 0x0001000011117824ULL, 0x000fc600078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000006500657306ULL, 0x000ee20000200c00ULL,
0x00000018ff117819ULL, 0x000fce0000011411ULL, 0x0000007700777306ULL, 0x000fe20000200c00ULL,
0x0000000214148232ULL, 0x002fce0000000000ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000000216168232ULL, 0x000fe40000000000ULL, 0x0000000015158232ULL, 0x080fe40000000000ULL,
0x0000000017178232ULL, 0x000fc60000000000ULL, 0x00000010005e7306ULL, 0x0003f00000200c00ULL,
0x00000011005f7306ULL, 0x0009e20000200c00ULL, 0x0000541083107816ULL, 0x002fce0000000084ULL,
0x0000007f007f7306ULL, 0x000e620000200c00ULL, 0x0000541062117816ULL, 0x010fce0000000085ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000000101420723cULL, 0x000b6e0000001820ULL,
0x0000005c007b7306ULL, 0x0008620000200c00ULL, 0x0000541081107816ULL, 0x024fe40000000080ULL,
0x0000541082117816ULL, 0x008fca0000000065ULL, 0x0000007800787306ULL, 0x000ea20000200c00ULL,
0x00008880125c7816ULL, 0x010fe200000000ffULL, 0x000000101424723cULL, 0x000b6c0000001824ULL,
0x0000007300737306ULL, 0x000ee20000200c00ULL, 0x000054107f107816ULL, 0x022fe4000000007eULL,
0x0000541068117816ULL, 0x000fc4000000007bULL, 0x000088801d7b7816ULL, 0x000fc600000000ffULL,
0x0000004300697306ULL, 0x0003e40000200c00ULL, 0x000000101428723cULL, 0x000f6c0000001828ULL,
0x00000042006c7306ULL, 0x0009e20000200c00ULL, 0x0000010012437824ULL, 0x002fe200078e00ffULL,
0x000088801c127816ULL, 0x000fc800000000ffULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x000000ffff657224ULL, 0x000fe200078e0012ULL, 0x0000004100727306ULL, 0x0003e20000200c00ULL,
0x0000888013427816ULL, 0x050fe200000000ffULL, 0x0001000013137824ULL, 0x000fe400078e00ffULL,
0x000001001c127824ULL, 0x040fe400078e00ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0000004000647306ULL, 0x0009e20000200c00ULL,
0x0000541079417816ULL, 0x002fc4000000006aULL, 0x00000018ff687819ULL, 0x000fe40000011412ULL,
0x00000018ff1c7819ULL, 0x000fc6000001141cULL, 0x0000007100717306ULL, 0x000e620000200c00ULL,
0x000054107a407816ULL, 0x010fe20000000077ULL, 0x000001001d777824ULL, 0x000fca00078e00ffULL,
0x00000018ff777819ULL, 0x000fe20000011477ULL, 0x0000006d006d7306ULL, 0x000f220000200c00ULL,
0x00000040142c723cULL, 0x000b6e000000182cULL, 0x0000541078407816ULL, 0x024fe20000000075ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000541073417816ULL, 0x008fce0000000076ULL,
0x0000006b006b7306ULL, 0x000ea20000200c00ULL, 0x000000401430723cULL, 0x000b6e0000001830ULL,
0x0000001300627306ULL, 0x0007e20000200c00ULL, 0x0000541074407816ULL, 0x022fe40000000071ULL,
0x0000541072417816ULL, 0x010fc4000000006dULL, 0x0000991067717816ULL, 0x000fc600000000ffULL,
0x0000005b005b7306ULL, 0x000e620000200c00ULL, 0x012000003e10783bULL, 0x008ee20000000200ULL,
0x000000401434723cULL, 0x000b620000001834ULL, 0x000000ffff6d7224ULL, 0x000fca00078e0071ULL,
0x0000005a005a7306ULL, 0x000f220000200c00ULL, 0x000100001d417824ULL, 0x020fe200078e00ffULL,
0x000054106b1d7816ULL, 0x004fe4000000006eULL, 0x000000ff6d00720cULL, 0x000fe40003f05270ULL,
0x000088801e6b7816ULL, 0x000fe400000000ffULL, 0x0000001c00407306ULL, 0x0005e20000200c00ULL,
0x00000018ff417819ULL, 0x000fce0000011441ULL, 0x0000006300637306ULL, 0x000fe20000200c00ULL,
0x00005410701c7816ULL, 0x004fce000000006fULL, 0x0000001c1438723cULL, 0x000b620000001838ULL,
0x0000006600667306ULL, 0x000fec0000200c00ULL, 0x000054106c1c7816ULL, 0x022fe4000000005bULL,
0x00005410691d7816ULL, 0x010fe2000000005aULL, 0x0000006100617306ULL, 0x000e620000200c00ULL,
0x0000000210108232ULL, 0x088fe20000000000ULL, 0x000000ffff5a7224ULL, 0x000fe200078e006bULL,
0x0000000212128232ULL, 0x000fc40000000000ULL, 0x0000000011118232ULL, 0x080fe20000000000ULL,
0x0000001c1418723cULL, 0x000b620000001818ULL, 0x0000000013138232ULL, 0x000fe20000000000ULL,
0x0000005900597306ULL, 0x000eaa0000200c00ULL, 0x000001001e147824ULL, 0x060fe200078e00ffULL,
0x000088801f1c7816ULL, 0x040fe200000000ffULL, 0x000001001f1d7824ULL, 0x000fe200078e00ffULL,
0x0000005800587306ULL, 0x000ee20000200c00ULL, 0x0000541061157816ULL, 0x002fe20000000064ULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x0000001400167306ULL, 0x0003e20000200c00ULL,
0x00000018ff1e7819ULL, 0x000fce000001141eULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x0000541063147816ULL, 0x002fce0000000066ULL, 0x000000141020723cULL, 0x040b620000001820ULL,
0x0000005a00177306ULL, 0x000e6c0000200c00ULL, 0x000054105e147816ULL, 0x024fe40000000059ULL,
0x000054105f157816ULL, 0x008fe20000000058ULL, 0x0000005700577306ULL, 0x000fec0000200c00ULL,
0x000000141024723cULL, 0x000b620000001824ULL, 0x0000541017167816ULL, 0x002fe20000000016ULL,
0x0000001e00157306ULL, 0x020e700000200c00ULL, 0x0000005500557306ULL, 0x000eb00000200c00ULL,
0x0000004b004b7306ULL, 0x000ee20000200c00ULL, 0x0000541015147816ULL, 0x002fce000000004eULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x0000541062617816ULL, 0x004fce0000000055ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0000541040407816ULL, 0x008fce000000004bULL,
0x0000005c005c7306ULL, 0x000ff00000200c00ULL, 0x0000004300437306ULL, 0x000e700000200c00ULL,
0x0000004200427306ULL, 0x000ff00000200c00ULL, 0x0000005d005d7306ULL, 0x000ea20000200c00ULL,
0x000054105c5c7816ULL, 0x002fce0000000043ULL, 0x0000006000607306ULL, 0x000e700000200c00ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x00005410425d7816ULL, 0x004fce000000005dULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x0000541060607816ULL, 0x002fe20000000057ULL,
0x0000005c1028723cULL, 0x040b6c0000001828ULL, 0x0000007b006a7306ULL, 0x000fe40000200c00ULL,
0x00000060102c723cULL, 0x000b6c000000182cULL, 0x0000007700677306ULL, 0x000e620000200c00ULL,
0x0000541065667816ULL, 0x004fce0000000068ULL, 0x00000041006e7306ULL, 0x000eb00000200c00ULL,
0x0000001c001c7306ULL, 0x000fe20000200c00ULL, 0x000054106a677816ULL, 0x002fce0000000067ULL,
0x0000001d001d7306ULL, 0x000e620000200c00ULL, 0x000054106e417816ULL, 0x004fe2000000004dULL,
0x000000661030723cULL, 0x040b6c0000001830ULL, 0x0000001f001f7306ULL, 0x000ea40000200c00ULL,
0x000000401034723cULL, 0x000b620000001834ULL, 0x000054101c177816ULL, 0x002fce000000001dULL,
0x000000161038723cULL, 0x000b620000001838ULL, 0x000054101f157816ULL, 0x004fce0000000054ULL,
0x000000141018723cULL, 0x000b620000001818ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000004127f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c006107811ULL, 0x000fe200078e40ffULL,
0x0176980045ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff127224ULL, 0x004fe400078e0046ULL,
0x0000003d1000720cULL, 0x000fe20003f06070ULL, 0x000000ffff577224ULL, 0x000fd800078e007dULL,
0x0000255000000947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x008fc40000015200ULL,
0x000000043c127824ULL, 0x000fca00078e00ffULL, 0xfffffff812127812ULL, 0x000fca00078ec0ffULL,
0x0176cc0012147984ULL, 0x000ea40000000800ULL, 0x8000000014ff7812ULL, 0x004fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001714147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176cc0012147984ULL, 0x000ea40000000800ULL,
0x8000000014ff7812ULL, 0x004fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000206107810ULL, 0x000fe40007ffe0ffULL, 0x0000010044447810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1000720cULL, 0x000fc60003f06070ULL, 0x00006200091c7a24ULL, 0x000fd400078e0244ULL,
0x000003c000008947ULL, 0x000fea0003800000ULL, 0x000000443d107217ULL, 0x000fe20007800000ULL,
0x000000100e1d7824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x100fe2000001160dULL,
0x000000100d137824ULL, 0x000fe400078e00ffULL, 0x0000000110107824ULL, 0x000fe200078e0a44ULL,
0x0000000416177810ULL, 0x000fe20007ffe0ffULL, 0x000000011d147824ULL, 0x000fe200078e0216ULL,
0x0000007013137812ULL, 0x000fe200078ec0ffULL, 0x00000080ff1f7424ULL, 0x000fe200078e00ffULL,
0x000000101d107217ULL, 0x000fe20007800000ULL, 0x0000000114157824ULL, 0x000fe200078e020dULL,
0x0000000c16427810ULL, 0x000fe20007ffe0ffULL, 0x00000008141e7824ULL, 0x000fc400078e00ffULL,
0x0000000114117824ULL, 0x000fe400078e021cULL, 0x0000000110127824ULL, 0x000fe200078e0a1dULL,
0xfffffff81e157812ULL, 0x000fe200078ee215ULL, 0x000000011d147824ULL, 0x000fe400078e0217ULL,
0x00005e0011107625ULL, 0x000fe200078e001fULL, 0x000000121600720cULL, 0x080fe40003fa6070ULL,
0x000000121700720cULL, 0x000fe20003f06070ULL, 0x00000001141e7824ULL, 0x000fe200078e020dULL,
0x0000001310107210ULL, 0x000fe20007fde0ffULL, 0x0000000814417824ULL, 0x000fc400078e00ffULL,
0x0000000114147824ULL, 0x000fe400078e021cULL, 0x0000001015177824ULL, 0x000fe200078e0252ULL,
0xfffffff841417812ULL, 0x000fe200078ee21eULL, 0x00005e0014147625ULL, 0x000fe200078e001fULL,
0x00000008161e7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x0000001314147210ULL, 0x000fe20007fde0ffULL, 0x000000011d407824ULL, 0x000fc600078e021eULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0005e2000e901c46ULL,
0x000000121e00720cULL, 0x080fe20003fa6070ULL, 0x0000000140167824ULL, 0x000fe400078e021cULL,
0x000000011d1e7824ULL, 0x000fe400078e0242ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x000000124200720cULL, 0x000fe20003fc6070ULL, 0x00000010411d7824ULL, 0x000fe400078e0252ULL,
0x000000011e127824ULL, 0x000fc400078e021cULL, 0x00005e0016107625ULL, 0x004fe200078e001fULL,
0x00000000141d7faeULL, 0x0005e6000c101c46ULL, 0x00000001401c7824ULL, 0x000fe200078e020dULL,
0x0000001310107210ULL, 0x000fe20007f1e0ffULL, 0x0000000840417824ULL, 0x000fe400078e00ffULL,
0x00005e0012167625ULL, 0x000fc600078e001fULL, 0xfffffff8411f7812ULL, 0x000fe200078ee21cULL,
0x000000011e127824ULL, 0x040fe400078e020dULL, 0x000000081e437824ULL, 0x000fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000001316167210ULL, 0x000fe20007f1e0ffULL,
0x000000101f157824ULL, 0x004fe200078e0252ULL, 0xfffffff843417812ULL, 0x000fc600078ee212ULL,
0x000000ffff177224ULL, 0x000fe200000e0617ULL, 0x0000000010157faeULL, 0x0005e2000e901c46ULL,
0x00000010411d7824ULL, 0x000fca00078e0252ULL, 0x00000000161d7faeULL, 0x0005e2000f101c46ULL,
0x000002f000007947ULL, 0x000fea0003800000ULL, 0x000000100e107824ULL, 0x000fe400078e00ffULL,
0x000000100d137824ULL, 0x040fe400078e00ffULL, 0x00000080ff1d7424ULL, 0x000fe200078e00ffULL,
0x000000100d117211ULL, 0x000fe400078fe8ffULL, 0x0000007013137812ULL, 0x000fe400078ec0ffULL,
0x0000000411127810ULL, 0x040fe20007ffe0ffULL, 0x0000000111107824ULL, 0x040fe200078e020dULL,
0x0000000811177810ULL, 0x040fe20007ffe0ffULL, 0x00000008111f7824ULL, 0x040fe200078e00ffULL,
0x0000000c111e7810ULL, 0x000fe20007ffe0ffULL, 0x0000000112147824ULL, 0x000fc400078e021cULL,
0x0000000112157824ULL, 0x140fe200078e020dULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee210ULL,
0x0000000111107824ULL, 0x100fe400078e021cULL, 0x0000000812407824ULL, 0x000fe400078e00ffULL,
0x0000000117167824ULL, 0x040fe400078e021cULL, 0x0000000117127824ULL, 0x040fe200078e020dULL,
0xfffffff840417812ULL, 0x000fe200078ee215ULL, 0x0000000817437824ULL, 0x000fc400078e00ffULL,
0x000000011e1c7824ULL, 0x000fe400078e021cULL, 0x00005e0010107625ULL, 0x000fe200078e001dULL,
0xfffffff843437812ULL, 0x000fc600078ee212ULL, 0x000000011e177824ULL, 0x000fe200078e020dULL,
0x0000001310107210ULL, 0x000fe20007f1e0ffULL, 0x000000081e1e7824ULL, 0x000fe400078e00ffULL,
0x00005e0014147625ULL, 0x000fc600078e001dULL, 0xfffffff81e4b7812ULL, 0x000fe200078ee217ULL,
0x00005e0016167625ULL, 0x000fc800078e001dULL, 0x00005e001c1c7625ULL, 0x000fe200078e001dULL,
0x0000001316167210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000001314147210ULL, 0x080fe20007f1e0ffULL, 0x000000101f1f7824ULL, 0x100fe200078e0252ULL,
0x000000131c1c7210ULL, 0x000fe20007fde0ffULL, 0x0000001041417824ULL, 0x100fe400078e0252ULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101f7faeULL, 0x0005e2000b901c46ULL, 0x0000001043437824ULL, 0x100fe400078e0252ULL,
0x000000ffff177224ULL, 0x000fe200028e0617ULL, 0x0000000014417faeULL, 0x0005e2000b901c46ULL,
0x000000104b4b7824ULL, 0x000fc400078e0252ULL, 0x000000ffff1d7224ULL, 0x000fe200030e061dULL,
0x0000000016437faeULL, 0x0005e8000b901c46ULL, 0x000000001c4b7faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0xffffffe00c107812ULL, 0x040fe200078ec0ffULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000100c117812ULL, 0x040fe400078ec0ffULL,
0x000000080c127812ULL, 0x000fc400078ec0ffULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x00000010121c7210ULL, 0x000fd60007ffe011ULL, 0x00000000500403c2ULL, 0x000ea40000080000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00c9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000270f070ULL,
0xffffff8000004947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a80051107f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x017668001c167f8cULL, 0x0002a2000c80043fULL, 0x000000ffff577224ULL, 0x008fc600078e0011ULL,
0x0000000000107805ULL, 0x000fc80000015200ULL, 0x01766c001c157984ULL, 0x000ee40000000800ULL,
0x8000000015ff7812ULL, 0x00cfc40007804817ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x00000014101d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09001d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011415ULL, 0x0000001d12127211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000212127819ULL, 0x000fc80000001215ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01766c001c157984ULL, 0x000ea40000000800ULL, 0x8000000015ff7812ULL, 0x004fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018013487810ULL, 0x000fca0007ffe048ULL,
0x0000000147487824ULL, 0x000fca00078e0248ULL, 0x0170000048157984ULL, 0x000ea80000000800ULL,
0x0172000048127984ULL, 0x0006620000000800ULL, 0x000000561500720bULL, 0x004fe20003f1d000ULL,
0x00008d527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000147806ULL, 0x008fc800000e0100ULL,
0x0000ffff14ff7812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff167424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000033c117811ULL, 0x000fe400078ff0ffULL, 0x000000561500720bULL, 0x000fe40003f14000ULL,
0x0000003c1100720cULL, 0x000fe20003fa5270ULL, 0x00008d227f007947ULL, 0x000fd4000b800000ULL,
0x0000000000177806ULL, 0x000fc400000e0100ULL, 0x000000803c16d824ULL, 0x000fe200078e0213ULL,
0x000000561510d209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991017117816ULL, 0x000fe200000000ffULL, 0x000000014747d824ULL, 0x000fc600078e0216ULL,
0x000000ff1100720cULL, 0x000fe40003f05270ULL, 0x017400104700d388ULL, 0x0005f60000000800ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000005615117209ULL, 0x004fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff17ff7812ULL, 0x000fc6000780c0ffULL,
0x0000005611107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000167308ULL, 0x000ea40000000800ULL, 0x0000001607077220ULL, 0x004fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe2000001160dULL,
0x00008c527f007947ULL, 0x000fea000b800000ULL, 0x00001f1016107589ULL, 0x0004e400000e0000ULL,
0x0000001020207220ULL, 0x088fe40000410000ULL, 0x0000001021217220ULL, 0x080fe40000410000ULL,
0x0000001024247220ULL, 0x080fe40000410000ULL, 0x0000001025257220ULL, 0x000fc40000410000ULL,
0x0000001028287220ULL, 0x080fe40000410000ULL, 0x0000001029297220ULL, 0x080fe40000410000ULL,
0x000000102c2c7220ULL, 0x080fe40000410000ULL, 0x000000102d2d7220ULL, 0x080fe40000410000ULL,
0x0000001030307220ULL, 0x080fe40000410000ULL, 0x0000001031317220ULL, 0x000fc40000410000ULL,
0x0000001034347220ULL, 0x080fe40000410000ULL, 0x0000001035357220ULL, 0x080fe40000410000ULL,
0x0000001038387220ULL, 0x080fe40000410000ULL, 0x0000001039397220ULL, 0x080fe40000410000ULL,
0x0000001018187220ULL, 0x080fe40000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0017ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d107811ULL, 0x000fe200078ff0ffULL,
0x00008b627f007947ULL, 0x000fea000b800000ULL, 0x00001f1016107589ULL, 0x0006a400000e0000ULL,
0x0000001022227220ULL, 0x084fe40000410000ULL, 0x0000001023237220ULL, 0x080fe40000410000ULL,
0x0000001026267220ULL, 0x080fe40000410000ULL, 0x0000001027277220ULL, 0x080fe40000410000ULL,
0x000000102a2a7220ULL, 0x080fe40000410000ULL, 0x000000102b2b7220ULL, 0x000fc40000410000ULL,
0x000000102e2e7220ULL, 0x080fe40000410000ULL, 0x000000102f2f7220ULL, 0x080fe40000410000ULL,
0x0000001032327220ULL, 0x080fe40000410000ULL, 0x0000001033337220ULL, 0x080fe40000410000ULL,
0x0000001036367220ULL, 0x080fe40000410000ULL, 0x0000001037377220ULL, 0x000fc40000410000ULL,
0x000000103a3a7220ULL, 0x080fe40000410000ULL, 0x000000103b3b7220ULL, 0x080fe40000410000ULL,
0x000000101a1a7220ULL, 0x080fe40000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff17ff7812ULL, 0x000fe20007800814ULL,
0x00000001ff167424ULL, 0x008fe200078e00ffULL, 0x0000005615567209ULL, 0x000fd60007810000ULL,
0x8000005615150221ULL, 0x000fe20000010000ULL, 0x00007610ff160816ULL, 0x000fc60000000016ULL,
0x3fb8aa3b15150820ULL, 0x000fc80000410000ULL, 0x0000001500030308ULL, 0x000ea40000000800ULL,
0x0000000312120220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000712077221ULL, 0x002fc40000010000ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0x0000000108537824ULL, 0x000fca00078e0253ULL, 0x0176ac0053137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780487dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210157210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001512127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac0053137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780487dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991016107816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff137819ULL, 0x000fe4000001160dULL, 0x0000541000127816ULL, 0x000fe20000000000ULL,
0x000087527f007947ULL, 0x000fea000b800000ULL, 0x00001f1312027589ULL, 0x0002a400000e0000ULL,
0x0000000813107810ULL, 0x000fe20007ffe0ffULL, 0x000087a27f007947ULL, 0x000fea000b800000ULL,
0x00001f1012007589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001013107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff1c7224ULL, 0x000fe200078e0012ULL,
0x00009c20001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x00008d3000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001813107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff1c7224ULL, 0x004fe200078e0012ULL, 0x00009c90001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x00008cc000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000004f1c783bULL, 0x004ea80000004200ULL,
0x000000004c40783bULL, 0x000f280000004200ULL, 0x000000004a10783bULL, 0x00ae680000004200ULL,
0x000000004914783bULL, 0x000ee20000004200ULL, 0x00000018ff6f7819ULL, 0x004fe2000001141cULL,
0x000001001c4f7824ULL, 0x040fe200078e00ffULL, 0x000088801c727816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001141dULL,
0x000001001d507824ULL, 0x040fe200078e00ffULL, 0x000088801d5a7816ULL, 0x040fe200000000ffULL,
0x000100001d1d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x00000018ff4f7819ULL, 0x000fc4000001144fULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff547819ULL, 0x000fe4000001141eULL,
0x00000018ff557819ULL, 0x000fe2000001141fULL, 0x0000001c00707306ULL, 0x0005e20000200c00ULL,
0x00000018ff617819ULL, 0x010fe40000011440ULL, 0x000088801e6e7816ULL, 0x000fe400000000ffULL,
0x000088801f637816ULL, 0x000fc400000000ffULL, 0x00008880406a7816ULL, 0x040fe200000000ffULL,
0x0000001d00717306ULL, 0x0009e20000200c00ULL, 0x000001001f1c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe20000011441ULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000888041677816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000004f00737306ULL, 0x0005e20000200c00ULL, 0x00000100401d7824ULL, 0x050fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fc40000011442ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c006c7306ULL, 0x0009e20000200c00ULL, 0x000001001e4f7824ULL, 0x044fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x0000888042627816ULL, 0x000fe400000000ffULL, 0x00000018ff467819ULL, 0x002fe40000011410ULL,
0x0000001d00697306ULL, 0x0003e20000200c00ULL, 0x00000100411c7824ULL, 0x050fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fc40000011450ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000004000667306ULL, 0x000fe20000200c00ULL, 0x00000100421d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff4f7819ULL, 0x000fe4000001144fULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00687306ULL, 0x0003e20000200c00ULL, 0x00000018ff427819ULL, 0x000fc40000011442ULL,
0x00000018ff4c7819ULL, 0x000fe40000011411ULL, 0x00000018ff4e7819ULL, 0x000fe40000011443ULL,
0x00008880435d7816ULL, 0x040fe200000000ffULL, 0x0000001d005f7306ULL, 0x0005e20000200c00ULL,
0x00000100431c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011412ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe40000011413ULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x0000001e006b7306ULL, 0x000fe20000200c00ULL,
0x00000100101d7824ULL, 0x004fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x00000018ff477819ULL, 0x008fe40000011414ULL, 0x00000018ff407819ULL, 0x000fe4000001141dULL,
0x0000001f00647306ULL, 0x000fe20000200c00ULL, 0x00000018ff4a7819ULL, 0x000fe40000011415ULL,
0x00000018ff497819ULL, 0x000fc40000011417ULL, 0x00000018ff447819ULL, 0x000fc60000011416ULL,
0x0000001c00607306ULL, 0x0003f00000200c00ULL, 0x0000004100657306ULL, 0x0005e20000200c00ULL,
0x012800003f1c783bULL, 0x0022ee0000000200ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x0000888010417816ULL, 0x044fe200000000ffULL, 0x0001000010107824ULL, 0x000fc400078e00ffULL,
0x00000100123f7824ULL, 0x002fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000005000757306ULL, 0x0002b00000200c00ULL, 0x0000004f006d7306ULL, 0x0009e20000200c00ULL,
0x00000018ff507819ULL, 0x002fc4000001143fULL, 0x00008880133f7816ULL, 0x000fca00000000ffULL,
0x0000004200587306ULL, 0x0003e20000200c00ULL, 0x00000100114f7824ULL, 0x010fce00078e00ffULL,
0x0000001000517306ULL, 0x0009e20000200c00ULL, 0x0000888011427816ULL, 0x042fe200000000ffULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x000000021c1c8232ULL, 0x088fe40000000000ULL,
0x000000021e1e8232ULL, 0x000fe40000000000ULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000006f006f7306ULL, 0x000e620000200c00ULL, 0x0000010013107824ULL, 0x050fe200078e00ffULL,
0x000000001d1d8232ULL, 0x080fe20000000000ULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x000000001f1f8232ULL, 0x000fc40000000000ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000005c005c7306ULL, 0x000ee20000200c00ULL, 0x00000018ff137819ULL, 0x000fce0000011413ULL,
0x0000001100537306ULL, 0x0005f00000200c00ULL, 0x0000001000527306ULL, 0x0009e20000200c00ULL,
0x000054105a117816ULL, 0x004fce0000000075ULL, 0x0000006e006e7306ULL, 0x000ea20000200c00ULL,
0x0000541072107816ULL, 0x010fe40000000073ULL, 0x0000888014727816ULL, 0x000fca00000000ffULL,
0x0000006300637306ULL, 0x000f220000200c00ULL, 0x000000101c20723cULL, 0x000bee0000001820ULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x0000541070107816ULL, 0x022fe4000000006fULL,
0x0000541071117816ULL, 0x008fe2000000005cULL, 0x000000ffff5c7224ULL, 0x000fc800078e0072ULL,
0x0000005500557306ULL, 0x000e640000200c00ULL, 0x000000101c24723cULL, 0x000b6c0000001824ULL,
0x00000043005b7306ULL, 0x0007e20000200c00ULL, 0x000054106e107816ULL, 0x024fe4000000006dULL,
0x0000541063117816ULL, 0x010fc4000000006cULL, 0x000054106b547816ULL, 0x000fe20000000054ULL,
0x00000100156b7824ULL, 0x040fe200078e00ffULL, 0x00008880156c7816ULL, 0x000fe200000000ffULL,
0x0000006a006a7306ULL, 0x000ea20000200c00ULL, 0x00000018ff437819ULL, 0x008fe2000001144fULL,
0x000000101c28723cULL, 0x000f620000001828ULL, 0x00008880124f7816ULL, 0x040fe200000000ffULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x0000541064557816ULL, 0x002fe20000000055ULL,
0x000000ffff647224ULL, 0x000fe400078e006cULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x00000018ff127819ULL, 0x000fc60000011412ULL, 0x000000541c2c723cULL, 0x000be8000000182cULL,
0x0000001200597306ULL, 0x0007e60000200c00ULL, 0x000054106a547816ULL, 0x024fca0000000069ULL,
0x0000006100617306ULL, 0x000ea20000200c00ULL, 0x0000010014127824ULL, 0x048fe200078e00ffULL,
0x0000541067557816ULL, 0x002fe20000000068ULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe4000001146bULL, 0x00000018ff637819ULL, 0x000fe40000011412ULL,
0x0000005e005e7306ULL, 0x000e620000200c00ULL, 0x000000541c30723cULL, 0x000b620000001830ULL,
0x00000018ff147819ULL, 0x000fcc0000011414ULL, 0x00000013005a7306ULL, 0x0007e20000200c00ULL,
0x0000541066547816ULL, 0x024fce0000000061ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x012800003e10783bULL, 0x0084e20000000200ULL, 0x0000541065557816ULL, 0x002fcc000000005eULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x000000541c34723cULL, 0x000b6e0000001834ULL,
0x0000004d004d7306ULL, 0x000f220000200c00ULL, 0x0001000015547824ULL, 0x020fca00078e00ffULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000004e004e7306ULL, 0x000ee20000200c00ULL,
0x000054105d157816ULL, 0x002fe40000000060ULL, 0x00008880165d7816ULL, 0x000fca00000000ffULL,
0x00000014003e7306ULL, 0x0043f00000200c00ULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x0000541062147816ULL, 0x002fe2000000005fULL, 0x0000000210108232ULL, 0x008fc40000000000ULL,
0x0000000212128232ULL, 0x000fe40000000000ULL, 0x0000000011118232ULL, 0x080fe40000000000ULL,
0x0000004c004c7306ULL, 0x000e620000200c00ULL, 0x000000141c38723cULL, 0x000b620000001838ULL,
0x0000000013138232ULL, 0x000fcc0000000000ULL, 0x0000541058147816ULL, 0x030fe2000000004dULL,
0x000000ffff4d7224ULL, 0x000fe200078e005dULL, 0x000054105b157816ULL, 0x000fe2000000004eULL,
0x0000004800487306ULL, 0x000fec0000200c00ULL, 0x000000141c18723cULL, 0x000b640000001818ULL,
0x0000004100417306ULL, 0x000fea0000200c00ULL, 0x00008880171c7816ULL, 0x020fe200000000ffULL,
0x0000010016157824ULL, 0x040fe200078e00ffULL, 0x00005410531d7816ULL, 0x002fe2000000004cULL,
0x00000100171e7824ULL, 0x040fe200078e00ffULL, 0x0000001c001f7306ULL, 0x0003e20000200c00ULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fc8000001141eULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000004000407306ULL, 0x000ea20000200c00ULL,
0x00005410511c7816ULL, 0x002fce0000000046ULL, 0x0000001c1024723cULL, 0x000b620000001824ULL,
0x0000003f003f7306ULL, 0x000e6c0000200c00ULL, 0x00000018ff1c7819ULL, 0x020fe40000011417ULL,
0x0000004d00147306ULL, 0x000fe20000200c00ULL, 0x0000541041407816ULL, 0x004fce0000000040ULL,
0x0000001500157306ULL, 0x000ea20000200c00ULL, 0x000054103f517816ULL, 0x002fce0000000052ULL,
0x0000004b004b7306ULL, 0x000e700000200c00ULL, 0x0000004700477306ULL, 0x000ee20000200c00ULL,
0x0000541014147816ULL, 0x004fce0000000015ULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x000054105a177816ULL, 0x002fce000000004bULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x000054103e3e7816ULL, 0x008fce0000000047ULL, 0x0000004900497306ULL, 0x000ff00000200c00ULL,
0x0000004200427306ULL, 0x000ff00000200c00ULL, 0x0000004300437306ULL, 0x000e700000200c00ULL,
0x0000004f004f7306ULL, 0x000ff00000200c00ULL, 0x0000005000507306ULL, 0x000ea20000200c00ULL,
0x0000541042417816ULL, 0x002fce0000000043ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x000000401020723cULL, 0x000b6e0000001820ULL, 0x0000006300637306ULL, 0x000e620000200c00ULL,
0x000054104f507816ULL, 0x004fce0000000050ULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x000000501028723cULL, 0x000b6e0000001828ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x000054105c5c7816ULL, 0x002fce0000000063ULL, 0x0000005400557306ULL, 0x000e700000200c00ULL,
0x0000001e001e7306ULL, 0x000ee20000200c00ULL, 0x00005410645d7816ULL, 0x004fce0000000067ULL,
0x00000016001d7306ULL, 0x0005220000200c00ULL, 0x00005410553f7816ULL, 0x002fe2000000004aULL,
0x0000005c1030723cULL, 0x040b6c0000001830ULL, 0x0000001c001c7306ULL, 0x000e620000200c00ULL,
0x0000541059167816ULL, 0x004fe20000000048ULL, 0x0000003e1034723cULL, 0x000b620000001834ULL,
0x000054101f157816ULL, 0x008fc4000000001eULL, 0x000054101d487816ULL, 0x010fca0000000044ULL,
0x00000016102c723cULL, 0x000b62000000182cULL, 0x000054101c497816ULL, 0x002fce0000000049ULL,
0x000000141038723cULL, 0x040b700000001838ULL, 0x000000481018723cULL, 0x000b620000001818ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000004127f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a00045ff7f8cULL, 0x0007e2000c80043fULL, 0x0000000105127812ULL, 0x004fc600078ec0ffULL,
0x0000000106067810ULL, 0x008fc80007ffe0ffULL, 0x0000000f0600720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff63e000007947ULL, 0x000fea000383ffffULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000007007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000ac7000047802ULL, 0x002fc40000000f00ULL,
0x00007b2000007944ULL, 0x00cfea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x000f240000001000ULL, 0xbf80000000027423ULL, 0x010fc80000000007ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006700ff037624ULL, 0x000fe400078e00ffULL,
0x00006600ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x000f28000c1e9900ULL,
0x0000000000047919ULL, 0x002e680000000000ULL, 0x0000000000077919ULL, 0x004ea20000000000ULL,
0x00000002ff067819ULL, 0x002fe40000011604ULL, 0x0000000807047811ULL, 0x004fe200078ff0ffULL,
0x0000000003057220ULL, 0x018fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000002000207220ULL, 0x042fe40000410000ULL,
0x0000002100217220ULL, 0x040fe40000410000ULL, 0x0000002400247220ULL, 0x040fe40000410000ULL,
0x0000002500257220ULL, 0x000fc40000410000ULL, 0x0000002800287220ULL, 0x040fe40000410000ULL,
0x0000002900297220ULL, 0x040fe40000410000ULL, 0x0000002c002c7220ULL, 0x040fe40000410000ULL,
0x0000002d002d7220ULL, 0x040fe40000410000ULL, 0x0000003000307220ULL, 0x040fe40000410000ULL,
0x0000003100317220ULL, 0x000fc40000410000ULL, 0x0000003400347220ULL, 0x040fe40000410000ULL,
0x0000003500357220ULL, 0x040fe40000410000ULL, 0x0000003800387220ULL, 0x040fe40000410000ULL,
0x0000003900397220ULL, 0x040fe40000410000ULL, 0x0000001800187220ULL, 0x040fe40000410000ULL,
0x0000001900197220ULL, 0x000fc40000410000ULL, 0x0000002204227220ULL, 0x044fe40000410000ULL,
0x0000002304237220ULL, 0x040fe40000410000ULL, 0x0000002604267220ULL, 0x040fe40000410000ULL,
0x0000002704277220ULL, 0x040fe40000410000ULL, 0x0000002a042a7220ULL, 0x040fe40000410000ULL,
0x0000002b042b7220ULL, 0x000fc40000410000ULL, 0x0000002e042e7220ULL, 0x040fe40000410000ULL,
0x0000002f042f7220ULL, 0x040fe40000410000ULL, 0x0000003204327220ULL, 0x040fe40000410000ULL,
0x0000003304337220ULL, 0x040fe40000410000ULL, 0x0000003604367220ULL, 0x040fe40000410000ULL,
0x0000003704377220ULL, 0x000fc40000410000ULL, 0x0000003a043a7220ULL, 0x040fe40000410000ULL,
0x0000003b043b7220ULL, 0x040fe40000410000ULL, 0x0000001a041a7220ULL, 0x040fe40000410000ULL,
0x0000001b041b7220ULL, 0x000fc40000410000ULL, 0x0000000000037919ULL, 0x000f220000000000ULL,
0x000000383938723eULL, 0x000fe400000000ffULL, 0x00000018191c723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000002a2b2b723eULL, 0x000fc400000000ffULL,
0x0000002e2f2e723eULL, 0x000fe400000000ffULL, 0x000000323332723eULL, 0x000fe400000000ffULL,
0x000000363719723eULL, 0x000fe400000000ffULL, 0x0000003a3b3a723eULL, 0x000fe400000000ffULL,
0x0000001a1b1d723eULL, 0x000fe400000000ffULL, 0x000054102b2a7816ULL, 0x000fc4000000002eULL,
0x0000000203007812ULL, 0x050fe400078ec0ffULL, 0x0000000803077811ULL, 0x000fe400078ff0ffULL,
0x00000002ff057819ULL, 0x000fe40000011603ULL, 0x0000000700047211ULL, 0x042fe200078ff8ffULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0x0000000500027211ULL, 0x000fe200078ff8ffULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0x000076322b2b7816ULL, 0x000fe2000000002eULL,
0x0000000805127824ULL, 0x008fe200078e00ffULL, 0x0000000202007810ULL, 0x000fc40007ffe0ffULL,
0xfffffff8070c7812ULL, 0x000fe200078ee204ULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0xfffffff809087812ULL, 0x000fe200078ee200ULL, 0x000010000e007824ULL, 0x000fe200078e00ffULL,
0x0000000402067810ULL, 0x040fe40007ffe0ffULL, 0xfffffff807047812ULL, 0x000fe200078ee202ULL,
0x000008000b057824ULL, 0x000fe200078e0200ULL, 0x0000000602077810ULL, 0x000fe20007ffe0ffULL,
0x0000000803027824ULL, 0x000fe200078e00ffULL, 0xfffffff809107812ULL, 0x000fe200078ee206ULL,
0x0000001004067824ULL, 0x000fe200078e0205ULL, 0xfffffff812127812ULL, 0x000fe200078ee207ULL,
0x000000100c147824ULL, 0x100fe200078e0205ULL, 0x0000000802077812ULL, 0x000fe200078ec0ffULL,
0x00000010080c7824ULL, 0x100fe200078e0205ULL, 0x000000202102723eULL, 0x000fe200000000ffULL,
0x0000001010107824ULL, 0x000fe200078e0205ULL, 0x000000242504723eULL, 0x000fe200000000ffULL,
0x0000000106087824ULL, 0x000fe200078e0207ULL, 0x000000343506723eULL, 0x000fe200000000ffULL,
0x00000001070c7824ULL, 0x040fe200078e020cULL, 0x0000541002167816ULL, 0x100fe20000000004ULL,
0x0000001012127824ULL, 0x000fe200078e0205ULL, 0x0000763202177816ULL, 0x000fe20000000004ULL,
0x0000000107147824ULL, 0x000fe200078e0214ULL, 0x000000282902723eULL, 0x000fe200000000ffULL,
0x0000000107107824ULL, 0x000fe200078e0210ULL, 0x0000002c2d04723eULL, 0x000fe200000000ffULL,
0x0000001608007388ULL, 0x0003e20000000a00ULL, 0x000000303105723eULL, 0x000fe200000000ffULL,
0x0000000107127824ULL, 0x000fe200078e0212ULL, 0x0000763202097816ULL, 0x000fc40000000004ULL,
0x0000763238077816ULL, 0x000fe4000000001cULL, 0x000000ff0b00720cULL, 0x000fe40003f05270ULL,
0x0000541002087816ULL, 0x002fe40000000004ULL, 0x000000222302723eULL, 0x000fe400000000ffULL,
0x000000262704723eULL, 0x000fe200000000ffULL, 0x000000080c007388ULL, 0x0003e40000000a00ULL,
0x0000541005087816ULL, 0x002fc40000000006ULL, 0x0000763205097816ULL, 0x000fe20000000006ULL,
0x000000010a057824ULL, 0x000fe200078e0203ULL, 0x0000541038067816ULL, 0x000fc6000000001cULL,
0x0000000810007388ULL, 0x0003e20000000a00ULL, 0x0000001005057824ULL, 0x000fc600078e0200ULL,
0x0000000612007388ULL, 0x0007e20000000a00ULL, 0x000054103a087816ULL, 0x142fe4000000001dULL,
0x000076323a097816ULL, 0x000fe4000000001dULL, 0x0000541002067816ULL, 0x148fe40000000004ULL,
0x0000763202077816ULL, 0x000fca0000000004ULL, 0x0000000614007388ULL, 0x0003e80000000a00ULL,
0x0004002a0c007388ULL, 0x000fe20000000a00ULL, 0x0000541032067816ULL, 0x142fe40000000019ULL,
0x0000763232077816ULL, 0x000fca0000000019ULL, 0x0004000610007388ULL, 0x000fe80000000a00ULL,
0x0004000812007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000005147984ULL, 0x000e680000000c00ULL, 0x00040000051c7984ULL, 0x000ee80000000c00ULL,
0x0008000005187984ULL, 0x000f280000000c00ULL, 0x000c000005207984ULL, 0x000ea20000000c00ULL,
0x200000ff17177230ULL, 0x002fc40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fe40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x008fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fc40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x010fe40000000000ULL, 0x0000001a16167230ULL, 0x000fe40000000000ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fe40000000000ULL,
0x000000231f1f7230ULL, 0x004fc40000000000ULL, 0x000000221e1e7230ULL, 0x000fe20000000000ULL,
0x0000001405007388ULL, 0x000fe20000000c00ULL, 0x000000211d1d7230ULL, 0x000fe40000000000ULL,
0x000000201c1c7230ULL, 0x000fca0000000000ULL, 0x0004001c05007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000020030c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000000067919ULL, 0x000e620000002600ULL,
0x00000003ff147819ULL, 0x100fe20000011603ULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x00000003ff077819ULL, 0x000fe2000001160cULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x000000080e0f7824ULL, 0x000fe200078e00ffULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x0000000114027824ULL, 0x000fc400078e0203ULL, 0x000000010c047824ULL, 0x000fc600078e0207ULL,
0x0000000702027812ULL, 0x000fe400078ec0ffULL, 0x0000000704097812ULL, 0x000fe400078ec0ffULL,
0x0ffffff802057812ULL, 0x000fe400078ef803ULL, 0x0ffffff809097812ULL, 0x000fc600078ef80cULL,
0x0000001005057824ULL, 0x100fe400078e0200ULL, 0x0000001009027824ULL, 0x000fe400078e0200ULL,
0x00000008060d7824ULL, 0x042fe200078e00ffULL, 0x0000000005087984ULL, 0x000e620000000c00ULL,
0x0000000806067824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x004fe4000f8e023fULL,
0x0000000002107984ULL, 0x0004e20000000c00ULL, 0xfffffff80d007812ULL, 0x000fe200078ee214ULL,
0x000000080e147824ULL, 0x000fe200078e00ffULL, 0xfffffff806077812ULL, 0x000fc400078ee207ULL,
0x00000004000d7c10ULL, 0x000fe4000ff1e0ffULL, 0x0000000407077c10ULL, 0x000fe4000ff3e0ffULL,
0xfffffff814037812ULL, 0x000fe200078ee203ULL, 0x000000ffff027224ULL, 0x004fe200000e06ffULL,
0x00005a000d047a11ULL, 0x000fe200078040ffULL, 0x000000ffff007224ULL, 0x000fe200008e06ffULL,
0x00005a0007067a11ULL, 0x000fe400078240ffULL, 0x00005b000d057a11ULL, 0x000fc400000f4402ULL,
0x00005b0007077a11ULL, 0x000fe400008f4400ULL, 0xfffffff80f0d7812ULL, 0x000fe200078ee20cULL,
0x0000001003027825ULL, 0x000fc800078e0004ULL, 0x000000100d047825ULL, 0x000fe200078e0006ULL,
0x0000000802007986ULL, 0x002fe8000c101d06ULL, 0x0000001004007986ULL, 0x008fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00006600ff067624ULL, 0x002fe400078e00ffULL,
0x00006700ff077624ULL, 0x000fca00078e00ffULL, 0x0000000606067981ULL, 0x000322000c1e9900ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000001ff0000780cULL, 0x000fe20003f04070ULL,
0x0000000210037824ULL, 0x000fe200078e00ffULL, 0x01760000ff047f8cULL, 0x000ea2000c80043fULL,
0x000000403c007824ULL, 0x000fe400078e00ffULL, 0x0000580003037a24ULL, 0x000fc800078e0212ULL,
0x0000620003087a24ULL, 0x000fc800078e0200ULL, 0x00000b9000000947ULL, 0x000fea0003800000ULL,
0x00000003ff2d7819ULL, 0x000fe4000001160dULL, 0x0000007002027812ULL, 0x000fe400078ec0ffULL,
0x000000082d137810ULL, 0x040fe20007ffe0ffULL, 0x00000001080a7824ULL, 0x000fe200078e022dULL,
0x000000042d117810ULL, 0x040fe40007ffe0ffULL, 0x0000000c2d177810ULL, 0x000fe20007ffe0ffULL,
0x0000000113097824ULL, 0x100fe200078e020dULL, 0x000000142d157810ULL, 0x000fe20007ffe0ffULL,
0x0000000813227824ULL, 0x000fe200078e00ffULL, 0x0000001c2d217810ULL, 0x000fe20007ffe0ffULL,
0x0000000111077824ULL, 0x002fe200078e020dULL, 0x000000202d297810ULL, 0x000fe20007ffe0ffULL,
0x0000000811147824ULL, 0x000fe200078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee209ULL,
0x00000001170b7824ULL, 0x000fe200078e020dULL, 0x000000003d097217ULL, 0x000fe20007800000ULL,
0x0000000817247824ULL, 0x000fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee207ULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x000000382d2b7810ULL, 0x000fe20007ffe0ffULL,
0x00000001090c7824ULL, 0x000fe200078e0a00ULL, 0xfffffff824247812ULL, 0x000fe200078ee20bULL,
0x00005e000a0a7625ULL, 0x000fe200078e0007ULL, 0x000000102d097810ULL, 0x000fc40007ffe0ffULL,
0x0000000c1100720cULL, 0x000fe20003f86070ULL, 0x00000001080e7824ULL, 0x000fe200078e0211ULL,
0x000000020a187210ULL, 0x000fe20007f1e0ffULL, 0x0000000109117824ULL, 0x000fe200078e020dULL,
0x0000000c1300720cULL, 0x080fe20003f46070ULL, 0x0000000809267824ULL, 0x000fe200078e00ffULL,
0x0000000c1700720cULL, 0x080fe20003f66070ULL, 0x0000000108107824ULL, 0x000fe400078e0213ULL,
0x000000ffff197224ULL, 0x000fe200000e060bULL, 0xfffffff826267812ULL, 0x000fe200078ee211ULL,
0x00005e0010107625ULL, 0x000fe200078e0007ULL, 0x0000000c0900720cULL, 0x000fc60003f06070ULL,
0x00005e000e0a7625ULL, 0x000fe200078e0007ULL, 0x00000002101c7210ULL, 0x000fc60007fbe0ffULL,
0x0000000108107824ULL, 0x000fe200078e0209ULL, 0x000000020a1a7210ULL, 0x000fe20007f3e0ffULL,
0x00000001080e7824ULL, 0x040fe200078e0217ULL, 0x000000182d177810ULL, 0x000fe20007ffe0ffULL,
0x0000000108127824ULL, 0x000fe400078e0215ULL, 0x000000ffff1d7224ULL, 0x000fe400028e0611ULL,
0x000000ffff1b7224ULL, 0x000fe400008e060bULL, 0x00005e0010107625ULL, 0x000fc800078e0007ULL,
0x00005e000e0a7625ULL, 0x000fe200078e0007ULL, 0x0000000210107210ULL, 0x000fc60007fbe0ffULL,
0x00005e0012127625ULL, 0x000fe200078e0007ULL, 0x000000020a1e7210ULL, 0x000fc60007f3e0ffULL,
0x000000012d097824ULL, 0x000fe200078e020dULL, 0x00000002120a7210ULL, 0x000fe20007fde0ffULL,
0x0000000108127824ULL, 0x000fe400078e0217ULL, 0x000000ffff117224ULL, 0x000fe200028e0611ULL,
0x0000000709167812ULL, 0x000fe200078ec0ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e060bULL,
0x000010003c097811ULL, 0x000fe200078e70ffULL, 0x000000ffff0b7224ULL, 0x000fe200030e0613ULL,
0x0000000c2d00720cULL, 0x080fe20003fa6070ULL, 0x00000001150e7824ULL, 0x140fe200078e020dULL,
0x0000000c1500720cULL, 0x000fe20003f26070ULL, 0x00005e0012127625ULL, 0x000fe200078e0007ULL,
0x0ffffff816167812ULL, 0x000fc600078ef80dULL, 0x0000000815157824ULL, 0x000fe200078e00ffULL,
0x0000000212127210ULL, 0x000fe20007fde0ffULL, 0x0000001014257824ULL, 0x000fe400078e0209ULL,
0x0000000108147824ULL, 0x000fe200078e0221ULL, 0xfffffff8150e7812ULL, 0x000fe200078ee20eULL,
0x0000001016237824ULL, 0x000fe400078e0209ULL, 0x00005e0014147625ULL, 0x000fc600078e0007ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e2000e901c46ULL,
0x000000ffff137224ULL, 0x000fe200030e0613ULL, 0x0000000214207210ULL, 0x000fe20007fde0ffULL,
0x0000000121147824ULL, 0x000fe200078e020dULL, 0x000000001a257faeULL, 0x0007e2000e101c46ULL,
0x0000000108167824ULL, 0x000fe200078e0229ULL, 0x0000000c1700720cULL, 0x0c0fe20003fa6070ULL,
0x0000000117277824ULL, 0x000fe200078e020dULL, 0x0000000c2100720cULL, 0x000fe20003f86070ULL,
0x0000000817287824ULL, 0x000fe400078e00ffULL, 0x00005e0016167625ULL, 0x000fe200078e0007ULL,
0x000000242d237810ULL, 0x002fc40007ffe0ffULL, 0xfffffff828187812ULL, 0x000fe200078ee227ULL,
0x0000000821197824ULL, 0x000fe200078e00ffULL, 0x000000282d257810ULL, 0x048fe20007ffe0ffULL,
0x00000010241b7824ULL, 0x000fe200078e0209ULL, 0x0000002c2d277810ULL, 0x000fe20007ffe0ffULL,
0x0000000123247824ULL, 0x000fe200078e020dULL, 0xfffffff8191a7812ULL, 0x000fe200078ee214ULL,
0x0000001022197824ULL, 0x000fe400078e0209ULL, 0x0000000129227824ULL, 0x000fe400078e020dULL,
0x0000000108147824ULL, 0x000fe200078e0223ULL, 0x000000001c197faeULL, 0x0003e2000d101c46ULL,
0x0000000c2300720cULL, 0x000fe20003f46070ULL, 0x000000ffff217224ULL, 0x000fe200030e0615ULL,
0x0000000216167210ULL, 0x000fe20007fde0ffULL, 0x000000001e1b7faeULL, 0x0007e2000d901c46ULL,
0x0000000c2900720cULL, 0x040fe20003f66070ULL, 0x0000000829297824ULL, 0x000fc400078e00ffULL,
0x0000000823237824ULL, 0x000fe400078e00ffULL, 0x00005e0014147625ULL, 0x000fe200078e0007ULL,
0xfffffff829227812ULL, 0x000fe400078ee222ULL, 0xfffffff823247812ULL, 0x000fe200078ee224ULL,
0x0000001026197824ULL, 0x102fe200078e0209ULL, 0x000000302d297810ULL, 0x000fe20007ffe0ffULL,
0x000000100e1b7824ULL, 0x108fe400078e0209ULL, 0x00000010181d7824ULL, 0x100fe200078e0209ULL,
0x0000000010197faeULL, 0x0003e2000c101c46ULL, 0x000000101a1f7824ULL, 0x000fc400078e0209ULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x000000000a1b7faeULL, 0x0007e2000c901c46ULL,
0x0000001022237824ULL, 0x000fe200078e0209ULL, 0x0000000214147210ULL, 0x000fe20007fde0ffULL,
0x00000008291a7824ULL, 0x000fe200078e00ffULL, 0x00000000121d7faeULL, 0x0005e2000e901c46ULL,
0x0000000c2700720cULL, 0x080fe40003fa6070ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x00000000201f7faeULL, 0x0005e2000e101c46ULL, 0x0000000108107824ULL, 0x002fe200078e0227ULL,
0x000000342d197810ULL, 0x000fe20007ffe0ffULL, 0x00000001250a7824ULL, 0x148fe200078e020dULL,
0x0000000016237faeULL, 0x0003e2000d901c46ULL, 0x00000008250b7824ULL, 0x000fe200078e00ffULL,
0x0000003c2d1b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000129137824ULL, 0x004fe200078e020dULL,
0x0000000c2500720cULL, 0x000fe20003fc6070ULL, 0x00005e0010107625ULL, 0x000fe200078e0007ULL,
0xfffffff80b0e7812ULL, 0x000fc400078ee20aULL, 0x0000000c2900720cULL, 0x080fe20003f86070ULL,
0x00000001080a7824ULL, 0x000fe200078e0225ULL, 0x0000000c1900720cULL, 0x080fe20003f66070ULL,
0x000000081b207824ULL, 0x000fe200078e00ffULL, 0x0000000c2b00720cULL, 0x080fe20003f26070ULL,
0x0000001024177824ULL, 0x002fe200078e0209ULL, 0x0000000c1b00720cULL, 0x000fe20003f06070ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0007ULL, 0xfffffff81a1a7812ULL, 0x000fe400078ee213ULL,
0x0000000014177faeULL, 0x0003e2000d101c46ULL, 0x0000000108167824ULL, 0x000fe200078e0229ULL,
0x000000020a127210ULL, 0x000fe20007f5e0ffULL, 0x00000001270c7824ULL, 0x000fc400078e020dULL,
0x0000000827277824ULL, 0x000fe400078e00ffULL, 0x000000ffff137224ULL, 0x000fe400010e060bULL,
0x00005e00160a7625ULL, 0x000fe200078e0007ULL, 0xfffffff827187812ULL, 0x000fe400078ee20cULL,
0x0000000210147210ULL, 0x002fe20007f5e0ffULL, 0x0000000108107824ULL, 0x000fe400078e0219ULL,
0x00000001190c7824ULL, 0x000fc400078e020dULL, 0x0000000819177824ULL, 0x000fe400078e00ffULL,
0x000000ffff157224ULL, 0x000fe200010e0611ULL, 0x000000020a167210ULL, 0x000fe20007f5e0ffULL,
0x00005e0010107625ULL, 0x000fe200078e0007ULL, 0xfffffff8171c7812ULL, 0x000fc600078ee20cULL,
0x00000001080a7824ULL, 0x000fe400078e022bULL, 0x000000ffff177224ULL, 0x000fe200010e060bULL,
0x0000000210107210ULL, 0x000fe20007f5e0ffULL, 0x00000001080c7824ULL, 0x000fe400078e021bULL,
0x000000012b087824ULL, 0x000fe400078e020dULL, 0x00005e000a0a7625ULL, 0x000fc800078e0007ULL,
0x000000011b0d7824ULL, 0x000fe400078e020dULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0x000000020a0a7210ULL, 0x000fe20007f5e0ffULL, 0x000000082b2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee20dULL, 0x00005e000c0c7625ULL, 0x000fc600078e0007ULL,
0xfffffff82b1e7812ULL, 0x000fe200078ee208ULL, 0x000000ffff0b7224ULL, 0x000fe200010e060bULL,
0x000000020c087210ULL, 0x000fe20007f5e0ffULL, 0x000000100e077824ULL, 0x100fe400078e0209ULL,
0x0000001018197824ULL, 0x100fe400078e0209ULL, 0x000000101a1b7824ULL, 0x100fe200078e0209ULL,
0x0000000012077faeULL, 0x0003e2000f101c46ULL, 0x000000101c1d7824ULL, 0x100fe400078e0209ULL,
0x000000101e1f7824ULL, 0x100fe200078e0209ULL, 0x0000000014197faeULL, 0x0003e2000e901c46ULL,
0x0000001020217824ULL, 0x000fc400078e0209ULL, 0x000000ffff097224ULL, 0x000fe200010e060dULL,
0x00000000161b7faeULL, 0x0003e8000e101c46ULL, 0x00000000101d7faeULL, 0x0003e8000d901c46ULL,
0x000000000a1f7faeULL, 0x0003e8000c901c46ULL, 0x0000000008217faeULL, 0x0003e2000c101c46ULL,
0x00000a5000007947ULL, 0x000fea0003800000ULL, 0x0000000c0d117811ULL, 0x040fe400078fe8ffULL,
0x000000040d0b7811ULL, 0x000fc400078fe8ffULL, 0x000000080d0e7811ULL, 0x000fe200078fe8ffULL,
0x00000001110a7824ULL, 0x100fe200078e020dULL, 0x000000100d177811ULL, 0x000fe200078fe8ffULL,
0x0000000811157824ULL, 0x000fe200078e00ffULL, 0x0000001c0d1e7811ULL, 0x000fe200078fe8ffULL,
0x000000010b077824ULL, 0x102fe200078e020dULL, 0x000000140d1a7811ULL, 0x000fe200078fe8ffULL,
0x000000080b127824ULL, 0x000fe200078e00ffULL, 0x000000180d1c7811ULL, 0x000fe200078fe8ffULL,
0x000000010e097824ULL, 0x140fe200078e020dULL, 0xfffffff815157812ULL, 0x000fe200078ee20aULL,
0x000000080e107824ULL, 0x000fe200078e00ffULL, 0x000000200d217811ULL, 0x000fe200078fe8ffULL,
0x00000001170c7824ULL, 0x040fe200078e020dULL, 0xfffffff812127812ULL, 0x000fe200078ee207ULL,
0x0000000817197824ULL, 0x000fe200078e00ffULL, 0xfffffff810137812ULL, 0x000fe200078ee209ULL,
0x000000011e0a7824ULL, 0x140fe200078e020dULL, 0x0000002c0d2a7811ULL, 0x040fe200078fe8ffULL,
0x000000081e1f7824ULL, 0x000fe200078e00ffULL, 0x000000240d257811ULL, 0x000fe200078fe8ffULL,
0x000000011a077824ULL, 0x140fe200078e020dULL, 0xfffffff819197812ULL, 0x000fe200078ee20cULL,
0x000000081a107824ULL, 0x000fe200078e00ffULL, 0x000000280d287811ULL, 0x000fe200078fe8ffULL,
0x000000011c097824ULL, 0x140fe200078e020dULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20aULL,
0x000000081c147824ULL, 0x000fe200078e00ffULL, 0x000000300d2b7811ULL, 0x000fe200078fe8ffULL,
0x00000001210c7824ULL, 0x040fe200078e020dULL, 0xfffffff8101b7812ULL, 0x000fe200078ee207ULL,
0x0000000821237824ULL, 0x000fe200078e00ffULL, 0xfffffff8141d7812ULL, 0x000fe200078ee209ULL,
0x000000012a0a7824ULL, 0x140fe200078e020dULL, 0x0000003c0d317811ULL, 0x000fe200078fe8ffULL,
0x000000082a2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee20cULL,
0x0000000125077824ULL, 0x140fe200078e020dULL, 0x0000007002027812ULL, 0x000fe200078ec0ffULL,
0x0000000825107824ULL, 0x000fe200078e00ffULL, 0xfffffff82d2c7812ULL, 0x000fe200078ee20aULL,
0x0000000128097824ULL, 0x040fe200078e020dULL, 0x000000080d0a7211ULL, 0x000fe200078fe8ffULL,
0x0000000828147824ULL, 0x000fe200078e00ffULL, 0xfffffff810277812ULL, 0x000fe200078ee207ULL,
0x000000012b0c7824ULL, 0x000fe200078e020dULL, 0x000000340d2d7811ULL, 0x000fe200078fe8ffULL,
0x000000082b2f7824ULL, 0x000fe200078e00ffULL, 0xfffffff814297812ULL, 0x000fe200078ee209ULL,
0x00000080ff077424ULL, 0x000fe200078e00ffULL, 0x0000000d0d097211ULL, 0x000fe200078fe8ffULL,
0x0000000108107824ULL, 0x000fe200078e020bULL, 0xfffffff82f307812ULL, 0x000fe200078ee20cULL,
0x00005e000a0a7625ULL, 0x000fe200078e0007ULL, 0x000000380d2f7811ULL, 0x000fc400078fe8ffULL,
0x00000007090c7812ULL, 0x000fe200078ec0ffULL, 0x0000000108207824ULL, 0x000fe200078e021cULL,
0x000010003c387811ULL, 0x000fe200078e70ffULL, 0x0000000108147824ULL, 0x000fe200078e020eULL,
0x0ffffff80c0e7812ULL, 0x000fe200078ef80dULL, 0x0000000108167824ULL, 0x040fe400078e0211ULL,
0x0000000108187824ULL, 0x040fe400078e0217ULL, 0x00000001081a7824ULL, 0x040fe400078e021aULL,
0x0000000108227824ULL, 0x000fc400078e021eULL, 0x0000000108247824ULL, 0x040fe400078e0221ULL,
0x0000000108267824ULL, 0x040fe400078e0225ULL, 0x0000000108287824ULL, 0x040fe400078e0228ULL,
0x00000001082a7824ULL, 0x040fe400078e022aULL, 0x00000001082e7824ULL, 0x040fe400078e022bULL,
0x0000000108327824ULL, 0x000fc400078e022dULL, 0x000000012d097824ULL, 0x040fe400078e020dULL,
0x000000082d1c7824ULL, 0x000fe400078e00ffULL, 0x0000000108347824ULL, 0x040fe400078e022fULL,
0x0000000108367824ULL, 0x000fe200078e0231ULL, 0x000000020a087210ULL, 0x000fe20007f1e0ffULL,
0x000000012f117824ULL, 0x040fe200078e020dULL, 0xfffffff81c177812ULL, 0x000fe200078ee209ULL,
0x000000082f1e7824ULL, 0x000fc400078e00ffULL, 0x00000001310d7824ULL, 0x040fe400078e020dULL,
0x00000008310c7824ULL, 0x000fe200078e00ffULL, 0xfffffff81e1c7812ULL, 0x000fe200078ee211ULL,
0x000000ffff097224ULL, 0x000fe400000e060bULL, 0x00005e00100a7625ULL, 0x000fe200078e0007ULL,
0xfffffff80c1e7812ULL, 0x000fc600078ee20dULL, 0x00005e00140c7625ULL, 0x000fe200078e0007ULL,
0x000000020a0a7210ULL, 0x000fc60007f1e0ffULL, 0x00000010122d7824ULL, 0x100fe200078e0238ULL,
0x000000020c0c7210ULL, 0x000fe20007f3e0ffULL, 0x00000010132f7824ULL, 0x000fe400078e0238ULL,
0x00005e0018127625ULL, 0x000fc800078e0007ULL, 0x0000001015317824ULL, 0x000fe400078e0238ULL,
0x00005e001a147625ULL, 0x000fc800078e0007ULL, 0x000000101c497824ULL, 0x000fe400078e0238ULL,
0x000000ffff0b7224ULL, 0x000fe200000e060bULL, 0x00000002121c7210ULL, 0x000fe20007f1e0ffULL,
0x00005e0016107625ULL, 0x000fc800078e0007ULL, 0x0000001017477824ULL, 0x100fe200078e0238ULL,
0x0000000210107210ULL, 0x080fe20007f5e0ffULL, 0x000000101e4b7824ULL, 0x000fe400078e0238ULL,
0x000000ffff0d7224ULL, 0x000fe200008e060dULL, 0x00000002141e7210ULL, 0x000fe20007f3e0ffULL,
0x00005e0020167625ULL, 0x000fc800078e0007ULL, 0x0000001019337824ULL, 0x000fe400078e0238ULL,
0x00005e0022187625ULL, 0x000fc800078e0007ULL, 0x000000101d377824ULL, 0x100fe400078e0238ULL,
0x000000ffff1d7224ULL, 0x000fe200000e0613ULL, 0x0000000216207210ULL, 0x080fe20007f1e0ffULL,
0x000000101f397824ULL, 0x000fe400078e0238ULL, 0x000000ffff1f7224ULL, 0x000fe200008e0615ULL,
0x0000000218227210ULL, 0x000fe20007f3e0ffULL, 0x00005e0024127625ULL, 0x000fc800078e0007ULL,
0x00005e0026147625ULL, 0x000fc800078e0007ULL, 0x000000101b357824ULL, 0x000fe400078e0238ULL,
0x00005e00281a7625ULL, 0x000fc800078e0007ULL, 0x000000ffff217224ULL, 0x000fe200000e0617ULL,
0x0000000212247210ULL, 0x080fe20007f1e0ffULL, 0x00000010233b7824ULL, 0x000fe400078e0238ULL,
0x000000ffff237224ULL, 0x000fe200008e0619ULL, 0x0000000214267210ULL, 0x000fe20007f3e0ffULL,
0x00005e002a167625ULL, 0x000fc800078e0007ULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0x000000021a287210ULL, 0x080fe20007f5e0ffULL, 0x000000100e2b7824ULL, 0x100fe400078e0238ULL,
0x000000ffff257224ULL, 0x000fe200000e0613ULL, 0x0000000216167210ULL, 0x000fe20007f1e0ffULL,
0x00000010273f7824ULL, 0x100fe200078e0238ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000082b7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff277224ULL, 0x000fe400008e0615ULL,
0x00005e002e127625ULL, 0x080fe200078e0007ULL, 0x000000000a2d7faeULL, 0x0003e6000b901c46ULL,
0x0000001029417824ULL, 0x000fe200078e0238ULL, 0x000000000c2f7faeULL, 0x0003e2000b901c46ULL,
0x00005e0032147625ULL, 0x000fc600078e0007ULL, 0x0000000010317faeULL, 0x0003e2000b901c46ULL,
0x000000ffff297224ULL, 0x000fe200010e061bULL, 0x0000000214147210ULL, 0x080fe20007f3e0ffULL,
0x00005e0034187625ULL, 0x080fe200078e0007ULL, 0x000000001c337faeULL, 0x0003e6000b901c46ULL,
0x00005e00361a7625ULL, 0x000fe200078e0007ULL, 0x0000000218187210ULL, 0x080fe20007f5e0ffULL,
0x000000001e357faeULL, 0x0003e4000b901c46ULL, 0x000000ffff177224ULL, 0x000fe200000e0617ULL,
0x0000000212127210ULL, 0x080fe20007f1e0ffULL, 0x000000102c437824ULL, 0x100fe200078e0238ULL,
0x000000021a1a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000020377faeULL, 0x0003e2000b901c46ULL,
0x0000001030457824ULL, 0x000fc400078e0238ULL, 0x000000ffff137224ULL, 0x000fe200000e0613ULL,
0x0000000022397faeULL, 0x0003e2000b901c46ULL, 0x000000ffff157224ULL, 0x000fe400008e0615ULL,
0x000000ffff197224ULL, 0x000fe200010e0619ULL, 0x00000000243b7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff1b7224ULL, 0x000fc600018e061bULL, 0x00000000263f7faeULL, 0x0003e8000b901c46ULL,
0x0000000028417faeULL, 0x0003e8000b901c46ULL, 0x0000000016437faeULL, 0x0003e8000b901c46ULL,
0x0000000012457faeULL, 0x0003e8000b901c46ULL, 0x0000000014477faeULL, 0x0003e8000b901c46ULL,
0x0000000018497faeULL, 0x0003e8000b901c46ULL, 0x000000001a4b7faeULL, 0x0003e4000b901c46ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000087805ULL, 0x002fc40000015200ULL,
0x01760400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc40007804805ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a08077210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0a7824ULL, 0x000fe200000e0e09ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc8000001140aULL,
0x0000000702027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e060aULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804805ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x000000203c027824ULL, 0x002fca00078e0205ULL,
0x00000003ff047819ULL, 0x000fc80000011602ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x0000000f02047812ULL, 0x000fc600078ec0ffULL, 0x0000000102057824ULL, 0x000fe400078e0205ULL,
0x0000001004077824ULL, 0x040fe400078e00ffULL, 0x0000001004047824ULL, 0x000fe200078e00ffULL,
0x0000000f05027812ULL, 0x040fe400078ec0ffULL, 0x0000000105057810ULL, 0x000fe40007ffe0ffULL,
0x000000f007027812ULL, 0x000fe400078ee202ULL, 0x0000000f05057812ULL, 0x000fc600078ec0ffULL,
0x0000000002107984ULL, 0x000e62000000cc00ULL, 0x000000f004057812ULL, 0x000fca00078ee205ULL,
0x0000000005087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff147224ULL, 0x002fe400078e0010ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff157224ULL, 0x000fe400078e0012ULL,
0x000000ffff117224ULL, 0x000fe400078e0013ULL, 0x000000ffff167224ULL, 0x004fe400078e0008ULL,
0x000000ffff177224ULL, 0x000fc400078e000aULL, 0x000000ffff127224ULL, 0x000fe400078e0009ULL,
0x000000ffff137224ULL, 0x000fe200078e000bULL, 0x0000001402007388ULL, 0x0003e8000000cc00ULL,
0x0000001005007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01760000ff0a7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0c7224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x002fc80000015200ULL, 0x01760400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x006fc4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000804077210ULL, 0x000fca0007f1e1ffULL,
0x0000000109087824ULL, 0x000fe200000e0e05ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0800720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0800720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011408ULL,
0x0000000702027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0608ULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x3db504f306047820ULL, 0x010fe20000410000ULL,
0x000176883c057811ULL, 0x040fe200078e18ffULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0xffffffff0f067810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x000176083c077811ULL, 0x000fc400078e28ffULL, 0x0000010009087824ULL, 0x000fe200078e0200ULL,
0x0000000000007946ULL, 0x000fe80003800000ULL, 0x000000083d00720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x00cfea0003800000ULL, 0x00000002090a7810ULL, 0x000fe40007ffe0ffULL,
0x000000010d0b7812ULL, 0x000fe400078e0cffULL, 0x0000000f0a00720cULL, 0x000fe40003f06070ULL,
0x00000100080a7810ULL, 0x000fca0007ffe0ffULL, 0x0000620003117a24ULL, 0x000fcc00078e020aULL,
0x00000bb000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1f7819ULL, 0x002fe40000011602ULL,
0x0000000a3d107217ULL, 0x000fe40007800000ULL, 0x000000041f157810ULL, 0x040fe20007ffe0ffULL,
0x000000011f137824ULL, 0x140fe200078e0211ULL, 0x0000000c1f197810ULL, 0x040fe20007ffe0ffULL,
0x0000000110107824ULL, 0x000fe200078e0a0aULL, 0x000000081f177810ULL, 0x000fe20007ffe0ffULL,
0x00000001150c7824ULL, 0x000fe200078e0202ULL, 0x000000101f1b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000815297824ULL, 0x040fe200078e00ffULL, 0x000000101500720cULL, 0x080fe20003f86070ULL,
0x00000010020a7824ULL, 0x000fe200078e00ffULL, 0x000000101700720cULL, 0x080fe20003f46070ULL,
0x0000000115157824ULL, 0x000fe200078e0211ULL, 0xfffffff829297812ULL, 0x000fe200078ee20cULL,
0x00000080ff0c7424ULL, 0x000fe200078e00ffULL, 0x000000700a0a7812ULL, 0x000fe200078ec0ffULL,
0x0000000119147824ULL, 0x040fe200078e0202ULL, 0x000000101900720cULL, 0x000fe20003f66070ULL,
0x00005e0013127625ULL, 0x000fe200078e000cULL, 0x000000141f237810ULL, 0x000fc40007ffe0ffULL,
0x000000181f337810ULL, 0x000fe20007ffe0ffULL, 0x00000008192d7824ULL, 0x000fe200078e00ffULL,
0x0000000a121c7210ULL, 0x000fe20007f1e0ffULL, 0x00000001170e7824ULL, 0x000fe200078e0202ULL,
0x0000001c1f357810ULL, 0x000fe20007ffe0ffULL, 0x00000008172b7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee214ULL, 0x000000ffff1d7224ULL, 0x000fe200000e0613ULL,
0x000000101b00720cULL, 0x000fe20003f06070ULL, 0x00005e0015127625ULL, 0x000fe200078e000cULL,
0xfffffff82b2b7812ULL, 0x000fc400078ee20eULL, 0x000000201f377810ULL, 0x000fe20007ffe0ffULL,
0x000000011b167824ULL, 0x040fe200078e0202ULL, 0x0000000a12247210ULL, 0x000fe20007f3e0ffULL,
0x000000081b2f7824ULL, 0x000fe400078e00ffULL, 0x0000000117177824ULL, 0x100fe400078e0211ULL,
0x0000000119197824ULL, 0x000fe200078e0211ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee216ULL,
0x00005e0017147625ULL, 0x000fc800078e000cULL, 0x00005e0019167625ULL, 0x000fc800078e000cULL,
0x000000011b197824ULL, 0x100fe200078e0211ULL, 0x0000000a16187210ULL, 0x080fe20007fbe0ffULL,
0x0000000123217824ULL, 0x000fe400078e0211ULL, 0x000000ffff257224ULL, 0x000fe200008e0613ULL,
0x0000000a141a7210ULL, 0x000fe20007f3e0ffULL, 0x00005e0019127625ULL, 0x000fc800078e000cULL,
0x00005e0021207625ULL, 0x000fc800078e000cULL, 0x000000ffff1b7224ULL, 0x000fe200008e0615ULL,
0x0000000a12147210ULL, 0x080fe20007f3e0ffULL, 0x000000ffff197224ULL, 0x000fe200028e0617ULL,
0x0000000a20127210ULL, 0x000fe20007fbe0ffULL, 0x000000011f167824ULL, 0x100fe400078e0202ULL,
0x000000ffff157224ULL, 0x000fe200008e0613ULL, 0x000000102300720cULL, 0x080fe20003f26070ULL,
0x000000ffff137224ULL, 0x000fe200028e0621ULL, 0x0000000716217812ULL, 0x000fe200078ec0ffULL,
0x000000023c0e7824ULL, 0x000fe200078e020bULL, 0x000000101f00720cULL, 0x000fe20003fa6070ULL,
0x00000001231e7824ULL, 0x100fe200078e0202ULL, 0x0ffffff821217812ULL, 0x000fe200078ef802ULL,
0x0000000823317824ULL, 0x000fe200078e00ffULL, 0x000010000e0e7811ULL, 0x000fe200078e68ffULL,
0x0000000133177824ULL, 0x000fc400078e0211ULL, 0x0000000137237824ULL, 0x100fe200078e0211ULL,
0xfffffff831317812ULL, 0x000fe200078ee21eULL, 0x0000001021277824ULL, 0x100fe400078e020eULL,
0x0000001029297824ULL, 0x000fe400078e020eULL, 0x00000001331e7824ULL, 0x040fe200078e0202ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c277faeULL, 0x0003e2000e901c46ULL,
0x000000103300720cULL, 0x000fe20003fa6070ULL, 0x00005e0017167625ULL, 0x000fe400078e000cULL,
0x0000000024297faeULL, 0x0005e2000e101c46ULL, 0x000000103500720cULL, 0x000fe20003f86070ULL,
0x0000000833337824ULL, 0x000fe200078e00ffULL, 0x0000000a16167210ULL, 0x000fe20007fde0ffULL,
0x0000000135217824ULL, 0x000fc400078e0211ULL, 0x0000000135267824ULL, 0x000fe400078e0202ULL,
0x000000102d277824ULL, 0x002fe400078e020eULL, 0x00005e0021207625ULL, 0x000fe200078e000cULL,
0xfffffff833297812ULL, 0x004fc600078ee21eULL, 0x000000102b257824ULL, 0x000fe200078e020eULL,
0x000000241f2b7810ULL, 0x000fe20007ffe0ffULL, 0x00000001371e7824ULL, 0x000fe400078e0202ULL,
0x000000ffff177224ULL, 0x000fe200030e0617ULL, 0x000000001a257faeULL, 0x0003e2000d101c46ULL,
0x0000000a20207210ULL, 0x000fe20007fde0ffULL, 0x0000000835357824ULL, 0x000fe200078e00ffULL,
0x000000102b00720cULL, 0x080fe20003f46070ULL, 0x0000000018277faeULL, 0x0005e2000d901c46ULL,
0x000000103700720cULL, 0x040fe20003f66070ULL, 0x0000000837377824ULL, 0x000fe200078e00ffULL,
0xfffffff835337812ULL, 0x000fe200078ee226ULL, 0x000000012b1d7824ULL, 0x000fe200078e0211ULL,
0x000000381f357810ULL, 0x000fe20007ffe0ffULL, 0x000000012b247824ULL, 0x000fc400078e0202ULL,
0x000000082b2d7824ULL, 0x000fe200078e00ffULL, 0xfffffff8372b7812ULL, 0x000fe200078ee21eULL,
0x00005e0023227625ULL, 0x000fe200078e000cULL, 0x0000003c1f377810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee224ULL, 0x000000ffff217224ULL, 0x000fe200030e0621ULL,
0x0000000a22227210ULL, 0x000fe20007fde0ffULL, 0x000000102f1b7824ULL, 0x102fe200078e020eULL,
0x0000002c1f2f7810ULL, 0x000fe20007ffe0ffULL, 0x0000001029257824ULL, 0x000fc400078e020eULL,
0x0000001031197824ULL, 0x104fe200078e020eULL, 0x00000000141b7faeULL, 0x0003e2000c101c46ULL,
0x000000102b297824ULL, 0x100fe200078e020eULL, 0x000000281f2b7810ULL, 0x000fe20007ffe0ffULL,
0x00005e001d1c7625ULL, 0x000fe200078e000cULL, 0x0000000012197faeULL, 0x0005e2000c901c46ULL,
0x000000301f317810ULL, 0x000fe40007ffe0ffULL, 0x0000001033277824ULL, 0x000fe200078e020eULL,
0x000000341f337810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff237224ULL, 0x000fe200030e0623ULL,
0x0000000a1c1c7210ULL, 0x000fe20007fde0ffULL, 0x000000082b1f7824ULL, 0x000fe200078e00ffULL,
0x0000000016257faeULL, 0x0007e2000e901c46ULL, 0x000000012f157824ULL, 0x042fe200078e0211ULL,
0x000000102f00720cULL, 0x080fe20003fa6070ULL, 0x000000ffff1d7224ULL, 0x000fe200030e061dULL,
0x0000000020277faeULL, 0x0003e2000e101c46ULL, 0x000000012b127824ULL, 0x044fe200078e0202ULL,
0x000000102b00720cULL, 0x040fe20003fc6070ULL, 0x000000012b137824ULL, 0x000fe200078e0211ULL,
0x0000000022297faeULL, 0x0005e2000d901c46ULL, 0x000000102d197824ULL, 0x000fe200078e020eULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee212ULL, 0x00005e0013127625ULL, 0x000fe200078e000cULL,
0x000000103100720cULL, 0x000fc40003f86070ULL, 0x000000001c197faeULL, 0x0009e2000d101c46ULL,
0x0000000131177824ULL, 0x148fe200078e0202ULL, 0x0000000a12167210ULL, 0x000fe20007f5e0ffULL,
0x0000000831187824ULL, 0x000fe200078e00ffULL, 0x000000103300720cULL, 0x000fe20003f66070ULL,
0x00005e0015147625ULL, 0x000fe200078e000cULL, 0x000000103500720cULL, 0x080fe40003f26070ULL,
0xfffffff818237812ULL, 0x004fe200078ee217ULL, 0x00000001311b7824ULL, 0x000fe200078e0211ULL,
0x000000103700720cULL, 0x000fe20003f06070ULL, 0x000000ffff177224ULL, 0x000fe200010e0613ULL,
0x0000000a14187210ULL, 0x000fe20007f5e0ffULL, 0x000000012f107824ULL, 0x000fc400078e0202ULL,
0x000000082f217824ULL, 0x002fe400078e00ffULL, 0x00005e001b127625ULL, 0x000fc600078e000cULL,
0xfffffff821217812ULL, 0x000fe200078ee210ULL, 0x00000001331b7824ULL, 0x040fe400078e0211ULL,
0x000000ffff197224ULL, 0x010fe200010e0615ULL, 0x0000000a121a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000133107824ULL, 0x040fe400078e0202ULL, 0x0000000833257824ULL, 0x000fe400078e00ffULL,
0x00005e001b147625ULL, 0x000fc600078e000cULL, 0xfffffff825257812ULL, 0x000fe200078ee210ULL,
0x00000001351d7824ULL, 0x000fe400078e0211ULL, 0x000000ffff1b7224ULL, 0x000fe200010e0613ULL,
0x0000000a14147210ULL, 0x000fe20007f5e0ffULL, 0x0000000137137824ULL, 0x000fe400078e0211ULL,
0x0000000135127824ULL, 0x000fe400078e0202ULL, 0x00005e001d107625ULL, 0x000fc800078e000cULL,
0x0000000835277824ULL, 0x000fe400078e00ffULL, 0x000000ffff157224ULL, 0x000fe200010e0615ULL,
0x0000000a10107210ULL, 0x000fe20007f5e0ffULL, 0x00000001371c7824ULL, 0x000fe200078e0202ULL,
0xfffffff827277812ULL, 0x000fe200078ee212ULL, 0x0000000837297824ULL, 0x000fe400078e00ffULL,
0x00005e0013127625ULL, 0x000fc600078e000cULL, 0xfffffff829297812ULL, 0x000fe200078ee21cULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x0000000a12127210ULL, 0x000fe20007f5e0ffULL,
0x000000101f1d7824ULL, 0x100fe400078e020eULL, 0x00000010211f7824ULL, 0x100fe400078e020eULL,
0x0000001023217824ULL, 0x100fe200078e020eULL, 0x00000000161d7faeULL, 0x0003e2000f101c46ULL,
0x0000001025237824ULL, 0x100fe400078e020eULL, 0x0000001027257824ULL, 0x100fe200078e020eULL,
0x00000000181f7faeULL, 0x0003e2000e901c46ULL, 0x0000001029277824ULL, 0x000fc400078e020eULL,
0x000000ffff137224ULL, 0x000fe200010e0613ULL, 0x000000001a217faeULL, 0x0003e8000e101c46ULL,
0x0000000014237faeULL, 0x0003e8000d901c46ULL, 0x0000000010257faeULL, 0x0003e8000c901c46ULL,
0x0000000012277faeULL, 0x0003e2000c101c46ULL, 0x00000a7000007947ULL, 0x000fea0003800000ULL,
0x0000000402157811ULL, 0x042fe400078fe8ffULL, 0x0000000802177811ULL, 0x000fc400078fe8ffULL,
0x0000000c02197811ULL, 0x040fe200078fe8ffULL, 0x00000001150a7824ULL, 0x140fe200078e0202ULL,
0x00000010021b7811ULL, 0x040fe200078fe8ffULL, 0x0000000815337824ULL, 0x000fe200078e00ffULL,
0x00000018021f7811ULL, 0x040fe200078fe8ffULL, 0x00000001170c7824ULL, 0x040fe200078e0202ULL,
0x0000001c02217811ULL, 0x040fe200078fe8ffULL, 0x0000000817357824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee20aULL, 0x00000001190a7824ULL, 0x040fe200078e0202ULL,
0x0000002002237811ULL, 0x040fe200078fe8ffULL, 0x0000000819377824ULL, 0x000fe200078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee20cULL, 0x000000011b0c7824ULL, 0x140fe200078e0202ULL,
0x0000002802277811ULL, 0x040fe200078fe8ffULL, 0x000000081b397824ULL, 0x000fe200078e00ffULL,
0x00000014021d7811ULL, 0x040fe200078fe8ffULL, 0x000000011f107824ULL, 0x000fe200078e0202ULL,
0xfffffff837377812ULL, 0x000fe200078ee20aULL, 0x000000081f3f7824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee20cULL, 0x00000001210a7824ULL, 0x040fe200078e0202ULL,
0x0000002c02297811ULL, 0x040fe200078fe8ffULL, 0x0000000821417824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee210ULL, 0x00000001230c7824ULL, 0x140fe200078e0202ULL,
0x00000030024b7811ULL, 0x040fe200078fe8ffULL, 0x0000000823437824ULL, 0x000fe200078e00ffULL,
0x0000003802537811ULL, 0x040fe200078fe8ffULL, 0x0000000127107824ULL, 0x040fe200078e0202ULL,
0x0000002402257811ULL, 0x040fe200078fe8ffULL, 0x0000000827477824ULL, 0x000fe200078e00ffULL,
0xfffffff841417812ULL, 0x000fe200078ee20aULL, 0x000000011d0e7824ULL, 0x000fe200078e0202ULL,
0xfffffff843437812ULL, 0x000fe200078ee20cULL, 0x000000081d3b7824ULL, 0x000fe200078e00ffULL,
0xfffffff847477812ULL, 0x000fe200078ee210ULL, 0x00000001290a7824ULL, 0x040fe200078e0202ULL,
0x00000034024f7811ULL, 0x040fe200078fe8ffULL, 0x0000000829497824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee20eULL, 0x000000014b0c7824ULL, 0x040fe200078e0202ULL,
0x0000001102137211ULL, 0x000fe200078fe8ffULL, 0x000000084b4d7824ULL, 0x000fe200078e00ffULL,
0xfffffff849497812ULL, 0x000fe200078ee20aULL, 0x0000000153107824ULL, 0x000fc400078e0202ULL,
0x0000000853557824ULL, 0x000fe200078e00ffULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee20cULL,
0x00000001250e7824ULL, 0x040fe400078e0202ULL, 0x0000000825457824ULL, 0x000fe200078e00ffULL,
0xfffffff855557812ULL, 0x000fe200078ee210ULL, 0x00000010020a7824ULL, 0x040fe200078e00ffULL,
0x0000003c02107811ULL, 0x000fe200078fe8ffULL, 0x00000080ff0c7424ULL, 0x000fe200078e00ffULL,
0xfffffff845457812ULL, 0x000fe200078ee20eULL, 0x000000014f0e7824ULL, 0x040fe200078e0202ULL,
0x000000700a0a7812ULL, 0x000fe200078ec0ffULL, 0x000000084f517824ULL, 0x000fc400078e00ffULL,
0x00005e0013127625ULL, 0x000fc600078e000cULL, 0xfffffff851517812ULL, 0x000fe200078ee20eULL,
0x0000000115157824ULL, 0x100fe200078e0211ULL, 0x00000002020e7211ULL, 0x000fe200078fe8ffULL,
0x0000000117177824ULL, 0x100fe400078e0211ULL, 0x0000000119197824ULL, 0x100fe200078e0211ULL,
0x000000070e2b7812ULL, 0x000fe200078ec0ffULL, 0x000000011b1b7824ULL, 0x100fe400078e0211ULL,
0x000000011d1d7824ULL, 0x100fe200078e0211ULL, 0x0ffffff82b2b7812ULL, 0x000fe200078ef802ULL,
0x000000011f1f7824ULL, 0x000fc400078e0211ULL, 0x0000000121217824ULL, 0x100fe400078e0211ULL,
0x0000000123237824ULL, 0x100fe400078e0211ULL, 0x0000000125257824ULL, 0x100fe400078e0211ULL,
0x0000000127277824ULL, 0x100fe400078e0211ULL, 0x0000000129297824ULL, 0x100fe400078e0211ULL,
0x000000014b4b7824ULL, 0x000fc400078e0211ULL, 0x000000014f4f7824ULL, 0x100fe400078e0211ULL,
0x0000000153537824ULL, 0x100fe400078e0211ULL, 0x0000000110577824ULL, 0x040fe400078e0211ULL,
0x0000000110117824ULL, 0x040fe400078e0202ULL, 0x0000000810147824ULL, 0x000fe200078e00ffULL,
0x0000000a12107210ULL, 0x000fe20007f1e0ffULL, 0x000000023c127824ULL, 0x000fc600078e020bULL,
0xfffffff814597812ULL, 0x000fe200078ee211ULL, 0x000000ffff117224ULL, 0x000fe200000e0613ULL,
0x00001000120e7811ULL, 0x000fe200078e68ffULL, 0x00005e0015127625ULL, 0x000fc800078e000cULL,
0x00005e0017147625ULL, 0x000fe200078e000cULL, 0x0000000a12127210ULL, 0x000fc60007f1e0ffULL,
0x00005e0019167625ULL, 0x000fe200078e000cULL, 0x0000000a14147210ULL, 0x000fc60007f3e0ffULL,
0x00005e001b187625ULL, 0x000fe200078e000cULL, 0x0000000a16167210ULL, 0x000fc60007f5e0ffULL,
0x00005e001d1a7625ULL, 0x000fc800078e000cULL, 0x000000ffff137224ULL, 0x000fe200000e0613ULL,
0x0000000a18187210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200008e0615ULL,
0x0000000a1a1a7210ULL, 0x000fe20007f3e0ffULL, 0x00005e001f1c7625ULL, 0x000fc800078e000cULL,
0x00005e00211e7625ULL, 0x000fc800078e000cULL, 0x000000ffff197224ULL, 0x000fe200000e0619ULL,
0x0000000a1c1c7210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200008e061bULL,
0x0000000a1e1e7210ULL, 0x000fe20007f3e0ffULL, 0x00005e0023207625ULL, 0x000fc800078e000cULL,
0x00005e0025227625ULL, 0x000fc800078e000cULL, 0x00005e0027247625ULL, 0x000fc800078e000cULL,
0x000000ffff1d7224ULL, 0x000fe200000e061dULL, 0x0000000a202a7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200008e061fULL, 0x0000000a222c7210ULL, 0x000fe20007f3e0ffULL,
0x00005e0029267625ULL, 0x000fc800078e000cULL, 0x000000ffff177224ULL, 0x000fe200010e0617ULL,
0x0000000a242e7210ULL, 0x080fe20007f5e0ffULL, 0x000000102b317824ULL, 0x100fe400078e020eULL,
0x000000ffff2b7224ULL, 0x000fe200000e0621ULL, 0x0000000a26267210ULL, 0x000fe20007f1e0ffULL,
0x0000001033337824ULL, 0x100fe200078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010317faeULL, 0x0003e2000b901c46ULL, 0x0000001035357824ULL, 0x000fe400078e020eULL,
0x000000ffff2d7224ULL, 0x000fe200008e0623ULL, 0x0000000012337faeULL, 0x0003e2000b901c46ULL,
0x00005e004b207625ULL, 0x000fc600078e000cULL, 0x0000000014357faeULL, 0x0003e2000b901c46ULL,
0x0000001037377824ULL, 0x100fe400078e020eULL, 0x000000ffff2f7224ULL, 0x000fe400010e0625ULL,
0x00005e004f227625ULL, 0x000fe200078e000cULL, 0x0000000016377faeULL, 0x0003e6000b901c46ULL,
0x0000001039397824ULL, 0x000fe200078e020eULL, 0x0000000a22227210ULL, 0x000fe20007f3e0ffULL,
0x00005e0053247625ULL, 0x000fc600078e000cULL, 0x0000000018397faeULL, 0x0003e2000b901c46ULL,
0x000000103b3b7824ULL, 0x000fe200078e020eULL, 0x0000000a24247210ULL, 0x000fe20007f5e0ffULL,
0x00005e0057287625ULL, 0x000fc600078e000cULL, 0x000000001a3b7faeULL, 0x0003e2000b901c46ULL,
0x000000103f3f7824ULL, 0x100fe200078e020eULL, 0x0000000a28287210ULL, 0x080fe20007f7e0ffULL,
0x000000ffff277224ULL, 0x000fe200000e0627ULL, 0x0000000a20207210ULL, 0x000fe20007f1e0ffULL,
0x0000001041417824ULL, 0x100fe200078e020eULL, 0x000000001c3f7faeULL, 0x0003e2000b901c46ULL,
0x0000001043437824ULL, 0x100fe400078e020eULL, 0x0000001045457824ULL, 0x100fe200078e020eULL,
0x000000001e417faeULL, 0x0003e2000b901c46ULL, 0x0000001047477824ULL, 0x000fc400078e020eULL,
0x0000001049497824ULL, 0x100fe200078e020eULL, 0x000000002a437faeULL, 0x0003e2000b901c46ULL,
0x000000104d4d7824ULL, 0x100fe400078e020eULL, 0x000000ffff217224ULL, 0x000fe200000e0621ULL,
0x000000002c457faeULL, 0x0003e2000b901c46ULL, 0x0000001051517824ULL, 0x100fe400078e020eULL,
0x000000ffff237224ULL, 0x000fe200008e0623ULL, 0x000000002e477faeULL, 0x0003e2000b901c46ULL,
0x0000001055557824ULL, 0x000fc400078e020eULL, 0x000000ffff257224ULL, 0x000fe200010e0625ULL,
0x0000000026497faeULL, 0x0003e2000b901c46ULL, 0x0000001059597824ULL, 0x000fe400078e020eULL,
0x000000ffff297224ULL, 0x000fe200018e0629ULL, 0x00000000204d7faeULL, 0x0003e8000b901c46ULL,
0x0000000022517faeULL, 0x0003e8000b901c46ULL, 0x0000000024557faeULL, 0x0003e8000b901c46ULL,
0x0000000028597faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x0000002002137810ULL, 0x002fe20007ffe0ffULL, 0x000000023c0d7824ULL, 0x000fe200078e020dULL,
0x0000000702197812ULL, 0x040fe200078ec0ffULL, 0x000000ffff3f7224ULL, 0x000fe200078e00ffULL,
0xfffffff802117812ULL, 0x000fe200078ec0ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0xfffffff813137812ULL, 0x000fe200078ec0ffULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000004ff0c7819ULL, 0x000fe20000011602ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000010000d0d7811ULL, 0x000fe400078e68ffULL, 0x00000008190e7812ULL, 0x100fe400078ef802ULL,
0x00000007113e7812ULL, 0x100fe400078ef802ULL, 0x00000007130a7812ULL, 0x000fc600078ef802ULL,
0x000000013e107824ULL, 0x060fe200078e023fULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000083e117824ULL, 0x000fe200078e00ffULL, 0x000000013f417810ULL, 0x040fe20007ffe0ffULL,
0x000000023f757824ULL, 0x000fc600078e020cULL, 0xfffffff811107812ULL, 0x000fe200078ee210ULL,
0x000000080a117824ULL, 0x000fc800078e00ffULL, 0x0000001010187824ULL, 0x000fe400078e020dULL,
0x000000010a107824ULL, 0x000fe200078e023fULL, 0x000000023f3f7810ULL, 0x000fc60007ffe0ffULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0xfffffff811107812ULL, 0x000fe400078ee210ULL,
0x000000083f00780cULL, 0x000fc60003f05270ULL, 0x0000001010107824ULL, 0x000fcc00078e020dULL,
0x000000001010783bULL, 0x000ea20000000200ULL, 0x00000018ff6e7819ULL, 0x002fe20000011418ULL,
0x00010000181c7824ULL, 0x040fe200078e00ffULL, 0x0000888018707816ULL, 0x040fe200000000ffULL,
0x0000010018187824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe20000011419ULL,
0x00010000191d7824ULL, 0x040fe200078e00ffULL, 0x00008880195d7816ULL, 0x040fe200000000ffULL,
0x0000010019197824ULL, 0x000fe200078e00ffULL, 0x00000018ff187819ULL, 0x000fe20000011418ULL,
0x0000006e006e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff687819ULL, 0x000fc4000001141aULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x000088801a6a7816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000001800737306ULL, 0x0003e20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff577819ULL, 0x004fe40000011410ULL,
0x0000888010567816ULL, 0x000fc400000000ffULL, 0x00000018ff5c7819ULL, 0x000fe20000011411ULL,
0x0000001900717306ULL, 0x0005e20000200c00ULL, 0x000100001a187824ULL, 0x042fe200078e00ffULL,
0x0000888011647816ULL, 0x000fe200000000ffULL, 0x000001001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe40000011412ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff1a7819ULL, 0x000fe2000001141aULL, 0x000100001b197824ULL, 0x004fe200078e00ffULL,
0x0000001c00777306ULL, 0x000fe20000200c00ULL, 0x00000018ff407819ULL, 0x000fc40000011413ULL,
0x00008880125e7816ULL, 0x000fe400000000ffULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x0000888013587816ULL, 0x000fe200000000ffULL, 0x0000001a006d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff627819ULL, 0x000fe4000001141bULL, 0x000088801b607816ULL, 0x040fe200000000ffULL,
0x000001001b1b7824ULL, 0x000fc800078e00ffULL, 0x00000019006b7306ULL, 0x0005e20000200c00ULL,
0x000000083e1a7824ULL, 0x002fe200078e00ffULL, 0x00000018ff1b7819ULL, 0x000fcc000001141bULL,
0x0000001d006c7306ULL, 0x0003e20000200c00ULL, 0x000000013e197824ULL, 0x104fe400078e0241ULL,
0x000000010a417824ULL, 0x000fc600078e0241ULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee219ULL,
0x0001000011197824ULL, 0x040fe200078e00ffULL, 0x00000018006f7306ULL, 0x0005e20000200c00ULL,
0x0000010011117824ULL, 0x000fe400078e00ffULL, 0x000000101a1a7824ULL, 0x000fe200078e020dULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x000000001a1c783bULL, 0x002e620000000200ULL, 0x0001000010187824ULL, 0x044fe200078e00ffULL,
0x0000001100637306ULL, 0x0005e20000200c00ULL, 0x0000010010107824ULL, 0x000fc600078e00ffULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000001800677306ULL, 0x0007e20000200c00ULL, 0x0001000013117824ULL, 0x044fe400078e00ffULL,
0x0000010013137824ULL, 0x000fc600078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000001000667306ULL, 0x0005e20000200c00ULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x000000080a187824ULL, 0x008fca00078e00ffULL, 0xfffffff818187812ULL, 0x000fe200078ee241ULL,
0x00000011005b7306ULL, 0x0007e20000200c00ULL, 0x0001000012107824ULL, 0x044fe400078e00ffULL,
0x0000010012127824ULL, 0x000fe400078e00ffULL, 0x0000001018187824ULL, 0x000fe200078e020dULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x000000100e117824ULL, 0x008fe200078e00ffULL, 0x0000001000617306ULL, 0x0005e20000200c00ULL,
0x00000018ff497819ULL, 0x002fc4000001141cULL, 0x00000018ff487819ULL, 0x000fca000001141dULL,
0x00000012005f7306ULL, 0x000fe20000200c00ULL, 0x000100001c107824ULL, 0x044fe200078e00ffULL,
0x000088801c427816ULL, 0x040fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x000088801d4d7816ULL, 0x000fe400000000ffULL, 0x00000018ff4b7819ULL, 0x000fe20000011410ULL,
0x000000010e107824ULL, 0x000fe200078e0275ULL, 0x0000001300597306ULL, 0x0003e20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff477819ULL, 0x000fc4000001141eULL,
0xfffffff011107812ULL, 0x000fe200078ee210ULL, 0x000100001d117824ULL, 0x040fe200078e00ffULL,
0x000088801e4f7816ULL, 0x000fe200000000ffULL, 0x0000001b00697306ULL, 0x000fe20000200c00ULL,
0x000001001d1d7824ULL, 0x000fe200078e00ffULL, 0x000000020e757810ULL, 0x000fe20007ffe075ULL,
0x0000001010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe40000011411ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001900657306ULL, 0x0005e20000200c00ULL,
0x000000001010783bULL, 0x002fe20000000200ULL, 0x00000018ff467819ULL, 0x000fc4000001141fULL,
0x000088801f527816ULL, 0x000fc800000000ffULL, 0x0000007000707306ULL, 0x000e620000200c00ULL,
0x000000001818783bULL, 0x004eae0000000200ULL, 0x0000001c004c7306ULL, 0x0007f00000200c00ULL,
0x0000001d00517306ULL, 0x0009e20000200c00ULL, 0x000100001e1c7824ULL, 0x008fc400078e00ffULL,
0x000001001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x000100001f1d7824ULL, 0x050fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x000001001f1f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000005d005d7306ULL, 0x000ee20000200c00ULL,
0x00000018ff1f7819ULL, 0x000fce000001141fULL, 0x0000001c00507306ULL, 0x0003e20000200c00ULL,
0x00000018ff457819ULL, 0x004fe40000011418ULL, 0x00000018ff447819ULL, 0x000fe40000011419ULL,
0x00000018ff437819ULL, 0x000fe4000001141aULL, 0x00000018ff417819ULL, 0x000fe2000001141bULL,
0x0000001d00537306ULL, 0x0005e20000200c00ULL, 0x00005410701c7816ULL, 0x002fce0000000077ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x00005410731d7816ULL, 0x004fce000000006eULL,
0x0000006a006a7306ULL, 0x000e620000200c00ULL, 0x0000001c1038723cULL, 0x000b6e0000001838ULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x000054105d1c7816ULL, 0x028fe2000000006cULL,
0x000000100e6c7824ULL, 0x000fe200078e00ffULL, 0x00005410711d7816ULL, 0x000fe2000000005aULL,
0x00010000185d7824ULL, 0x000fc600078e00ffULL, 0xfffffff06c757812ULL, 0x000fe200078ee275ULL,
0x0000006000607306ULL, 0x000ea20000200c00ULL, 0x00000018ff5d7819ULL, 0x000fe2000001145dULL,
0x0000001c1034723cULL, 0x000b6c0000001834ULL, 0x0000005700577306ULL, 0x000ee20000200c00ULL,
0x000054106a1c7816ULL, 0x022fc4000000006fULL, 0x000054106d1d7816ULL, 0x000fe40000000068ULL,
0x0000888019687816ULL, 0x000fc600000000ffULL, 0x0000005600567306ULL, 0x000e640000200c00ULL,
0x0000001c1030723cULL, 0x000bec0000001830ULL, 0x0000001e00547306ULL, 0x0009e20000200c00ULL,
0x00005410601c7816ULL, 0x024fe4000000006bULL, 0x00005410691d7816ULL, 0x000fe20000000062ULL,
0x000000ffff627224ULL, 0x000fe200078e0068ULL, 0x0000541066577816ULL, 0x008fe20000000057ULL,
0x0001000019687824ULL, 0x000fc400078e00ffULL, 0x0000005c005c7306ULL, 0x000ea20000200c00ULL,
0x00008880181e7816ULL, 0x050fe200000000ffULL, 0x0000010018187824ULL, 0x000fe200078e00ffULL,
0x0000001c102c723cULL, 0x000f62000000182cULL, 0x0000541056567816ULL, 0x002fc60000000067ULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000006400647306ULL, 0x000e660000200c00ULL,
0x000000561028723cULL, 0x000b6a0000001828ULL, 0x0000001e005a7306ULL, 0x0007e40000200c00ULL,
0x0000010019567824ULL, 0x020fe200078e00ffULL, 0x0000541063197816ULL, 0x004fc4000000005cULL,
0x000088801a5c7816ULL, 0x000fe400000000ffULL, 0x00000018ff577819ULL, 0x000fe20000011468ULL,
0x0000001f00557306ULL, 0x0005e20000200c00ULL, 0x00000010751e7824ULL, 0x008fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fcc0000011456ULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x000000001e1c783bULL, 0x004eae0000000200ULL, 0x0000005e005e7306ULL, 0x000ef00000200c00ULL,
0x0000001800607306ULL, 0x0003f00000200c00ULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x0000541064187816ULL, 0x002fce0000000065ULL, 0x0000005800587306ULL, 0x000e620000200c00ULL,
0x000000181024723cULL, 0x000b6e0000001824ULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x000054105e187816ULL, 0x028fe40000000061ULL, 0x000054105f197816ULL, 0x000fe2000000004aULL,
0x000000ffff4a7224ULL, 0x000fc400078e005cULL, 0x000100001a5c7824ULL, 0x040fe400078e00ffULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x000001001a1a7824ULL, 0x000fe200078e00ffULL,
0x000000181020723cULL, 0x000b680000001820ULL, 0x00000018ff1a7819ULL, 0x000fe4000001141aULL,
0x0000004b004b7306ULL, 0x000ee20000200c00ULL, 0x0000541058187816ULL, 0x022fc4000000005bULL,
0x0000541059197816ULL, 0x000fca0000000040ULL, 0x0000004800487306ULL, 0x000e640000200c00ULL,
0x000000181014723cULL, 0x000b6c0000001814ULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x0000541042107816ULL, 0x028fe4000000004bULL, 0x000054104c117816ULL, 0x000fc40000000049ULL,
0x000088801b127816ULL, 0x000fe400000000ffULL, 0x00000018ff137819ULL, 0x000fe2000001145cULL,
0x0000004e004e7306ULL, 0x000ee40000200c00ULL, 0x000000101c38723cULL, 0x004b6c0000001838ULL,
0x0000005200527306ULL, 0x000ea20000200c00ULL, 0x0000541051117816ULL, 0x022fc40000000048ULL,
0x000054104d107816ULL, 0x008fca000000004eULL, 0x0000004700477306ULL, 0x000e640000200c00ULL,
0x000000101c34723cULL, 0x000b620000001834ULL, 0x0000541052527816ULL, 0x004fca0000000053ULL,
0x0000004600467306ULL, 0x000ea20000200c00ULL, 0x000100001b117824ULL, 0x060fe400078e00ffULL,
0x000001001b1b7824ULL, 0x000fca00078e00ffULL, 0x0000004500457306ULL, 0x000ee20000200c00ULL,
0x000000ffff107224ULL, 0x000fe200078e0012ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff1b7819ULL, 0x000fe4000001141bULL, 0x0000541054517816ULL, 0x002fe40000000047ULL,
0x0000001000107306ULL, 0x000fe20000200c00ULL, 0x0000541055537816ULL, 0x004fce0000000046ULL,
0x0000001100117306ULL, 0x000e620000200c00ULL, 0x00005410605b7816ULL, 0x008fe20000000045ULL,
0x000000521c2c723cULL, 0x000b6c000000182cULL, 0x0000004400447306ULL, 0x000ff00000200c00ULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x0000541010107816ULL, 0x002fce0000000011ULL,
0x0000004100417306ULL, 0x000ff00000200c00ULL, 0x0000004f004f7306ULL, 0x000e700000200c00ULL,
0x0000005d005d7306ULL, 0x000eb00000200c00ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x000054104f507816ULL, 0x002fce0000000050ULL, 0x0000005700577306ULL, 0x000e620000200c00ULL,
0x000054105a5a7816ULL, 0x004fe2000000005dULL, 0x000000501c30723cULL, 0x040b6c0000001830ULL,
0x0000005600637306ULL, 0x000ea40000200c00ULL, 0x0000005a1c28723cULL, 0x000b6c0000001828ULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x0000541062627816ULL, 0x002fce0000000057ULL,
0x0000001300137306ULL, 0x000e620000200c00ULL, 0x0000541063637816ULL, 0x004fce0000000044ULL,
0x0000001a001a7306ULL, 0x000ea20000200c00ULL, 0x000000621c24723cULL, 0x000b6e0000001824ULL,
0x0000001b00127306ULL, 0x000ee20000200c00ULL, 0x000054104a427816ULL, 0x002fe40000000013ULL,
0x000054101a437816ULL, 0x004fce0000000043ULL, 0x000000421c20723cULL, 0x000b620000001820ULL,
0x0000541012117816ULL, 0x008fce0000000041ULL, 0x000000101c14723cULL, 0x000b620000001814ULL,
0xfffff09000000947ULL, 0x000fce000383ffffULL, 0x000000042d2d7220ULL, 0x0a0fe40000410000ULL,
0x0000000428287220ULL, 0x080fe40000410000ULL, 0x0000000424247220ULL, 0x080fe40000410000ULL,
0x0000000425257220ULL, 0x080fe40000410000ULL, 0x0000000438387220ULL, 0x080fe40000410000ULL,
0x0000000439397220ULL, 0x000fc40000410000ULL, 0x0000000434347220ULL, 0x080fe40000410000ULL,
0x0000000435357220ULL, 0x080fe40000410000ULL, 0x00000004300a7220ULL, 0x080fe40000410000ULL,
0x0000000431317220ULL, 0x080fe40000410000ULL, 0x00000004290c7220ULL, 0x080fe40000410000ULL,
0x0000000420207220ULL, 0x000fc40000410000ULL, 0x0000000421217220ULL, 0x080fe40000410000ULL,
0x0000000426187220ULL, 0x080fe40000410000ULL, 0x0000000427197220ULL, 0x080fe40000410000ULL,
0x000000ffff297224ULL, 0x000fe400078e002dULL, 0x00000004331c7220ULL, 0x080fe40000410000ULL,
0x000000042e1d7220ULL, 0x000fc40000410000ULL, 0x000000042f1e7220ULL, 0x080fe40000410000ULL,
0x000000042a1f7220ULL, 0x080fe40000410000ULL, 0x000000042b1a7220ULL, 0x080fe40000410000ULL,
0x00000004220d7220ULL, 0x080fe40000410000ULL, 0x00000004230e7220ULL, 0x000fe40000410000ULL,
0x000000ffff2d7224ULL, 0x000fc400078e0028ULL, 0x000000ffff277224ULL, 0x000fe400078e0024ULL,
0x000000ffff267224ULL, 0x000fe400078e0025ULL, 0x000000043a3a7220ULL, 0x080fe40000410000ULL,
0x000000043b3b7220ULL, 0x080fe40000410000ULL, 0x0000000436367220ULL, 0x080fe40000410000ULL,
0x0000000437377220ULL, 0x000fc40000410000ULL, 0x00000004321b7220ULL, 0x080fe40000410000ULL,
0x000000042c2c7220ULL, 0x080fe40000410000ULL, 0x0000000414237220ULL, 0x080fe40000410000ULL,
0x0000000415227220ULL, 0x080fe40000410000ULL, 0x0000000416127220ULL, 0x080fe40000410000ULL,
0x0000000417137220ULL, 0x000fc40000410000ULL, 0x000000ffff337224ULL, 0x000fe400078e0038ULL,
0x000000ffff307224ULL, 0x000fe400078e0039ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0034ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0035ULL, 0x000000ffff2e7224ULL, 0x000fe400078e000aULL,
0x000000ffff2a7224ULL, 0x000fc400078e0031ULL, 0x000000ffff287224ULL, 0x000fe400078e000cULL,
0x000000ffff257224ULL, 0x000fe400078e0020ULL, 0x000000ffff247224ULL, 0x000fe200078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000005107f8cULL, 0x0002a2000c80043fULL,
0x000000ffff147224ULL, 0x000fe400078e003aULL, 0x000000ffff157224ULL, 0x000fe400078e003bULL,
0x000000ffff167224ULL, 0x000fc400078e0036ULL, 0x000000ffff177224ULL, 0x000fe400078e0037ULL,
0x000000ffff207224ULL, 0x000fe400078e0012ULL, 0x000000ffff217224ULL, 0x000fc400078e0013ULL,
0x0000000000127805ULL, 0x002fca0000015200ULL, 0x0000040005317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x006fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003412317210ULL, 0x000fca0007f1e1ffULL, 0x0000000135347824ULL, 0x000fe200000e0e13ULL,
0x003d09003100780cULL, 0x000fc80003f06070ULL, 0x000000ff3400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403100780cULL, 0x000fc80003f06070ULL,
0x000000ff3400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc80000011434ULL, 0x000000310a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff317224ULL, 0x000fca00000e0634ULL, 0x000000020a0a7819ULL, 0x000fc80000001231ULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040005317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004020c7824ULL, 0x000fe200078e00ffULL,
0x000000060900720cULL, 0x000fc80003f05270ULL, 0xfffffff00c117812ULL, 0x000fca00078ec0ffULL,
0x000000803c0a7824ULL, 0x000fca00078e0211ULL, 0x017400000a107984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000202317824ULL, 0x000fe400078e00ffULL,
0x000000013d087824ULL, 0x000fc600078e0a08ULL, 0x0000000631317812ULL, 0x000fc800078ec0ffULL,
0x0000000131357812ULL, 0x040fe400078efcffULL, 0x0000000831377812ULL, 0x000fe400078efcffULL,
0x000000083500720cULL, 0x080fe40003f26070ULL, 0x0000001031357812ULL, 0x000fe400078efcffULL,
0x000000083700720cULL, 0x080fe40003f06070ULL, 0x000000083500720cULL, 0x000fc40003fc6070ULL,
0x0000001131377812ULL, 0x040fe400078efcffULL, 0x0000001831357812ULL, 0x040fe400078efcffULL,
0x000000083100720cULL, 0x080fe40003f46070ULL, 0x000000083700720cULL, 0x080fe40003fa6070ULL,
0x000000083500720cULL, 0x000fe40003f66070ULL, 0x0000000931397812ULL, 0x000fc400078efcffULL,
0x0000001931377812ULL, 0x040fe400078efcffULL, 0x0000002031357812ULL, 0x000fe400078efcffULL,
0xff80000014147808ULL, 0x000fe40005000000ULL, 0xff80000033337808ULL, 0x000fe40005000000ULL,
0xff80000015157808ULL, 0x000fe40004800000ULL, 0xff80000030307808ULL, 0x000fc40004800000ULL,
0x000000083900720cULL, 0x080fe40003f86070ULL, 0x000000083700720cULL, 0x080fe40003f46070ULL,
0x000000083500720cULL, 0x000fe40003f26070ULL, 0x0000002131377812ULL, 0x040fe400078efcffULL,
0x0000002831357812ULL, 0x000fe400078efcffULL, 0xff80000016167808ULL, 0x000fc40004000000ULL,
0xff8000002b2b7808ULL, 0x000fe40004000000ULL, 0xff80000017177808ULL, 0x000fe40006000000ULL,
0xff8000002f2f7808ULL, 0x000fe40006000000ULL, 0x000000083700720cULL, 0x080fe40003f06070ULL,
0x000000083500720cULL, 0x000fe40003f86070ULL, 0x0000002931377812ULL, 0x000fc400078efcffULL,
0x0000003031357812ULL, 0x000fe400078efcffULL, 0xff8000001b1b7808ULL, 0x000fe40007000000ULL,
0xff8000002e2e7808ULL, 0x000fe40007000000ULL, 0xff8000001c1c7808ULL, 0x000fe40006800000ULL,
0xff8000002a2a7808ULL, 0x000fe40006800000ULL, 0x000000083700720cULL, 0x000fc40003fc6070ULL,
0x000000083500720cULL, 0x000fe40003fa6070ULL, 0x0000003131377812ULL, 0x040fe400078efcffULL,
0x0000003831357812ULL, 0x040fe400078efcffULL, 0x0000003931317812ULL, 0x000fe400078efcffULL,
0xff8000001d1d7808ULL, 0x000fe40005800000ULL, 0xff8000002c2c7808ULL, 0x000fc40005800000ULL,
0xff8000001e1e7808ULL, 0x000fe40005000000ULL, 0xff80000029297808ULL, 0x000fe40005000000ULL,
0xff8000001f1f7808ULL, 0x000fe40004800000ULL, 0xff8000002d2d7808ULL, 0x000fe40004800000ULL,
0x000000083700720cULL, 0x080fe40003f66070ULL, 0x000000083500720cULL, 0x000fc40003f46070ULL,
0x000000083100720cULL, 0x000fe40003f26070ULL, 0xff8000001a1a7808ULL, 0x000fe40004000000ULL,
0xff80000028287808ULL, 0x000fe40004000000ULL, 0xff80000018187808ULL, 0x000fe40006000000ULL,
0xff80000027277808ULL, 0x000fe40006000000ULL, 0xff80000019197808ULL, 0x000fc40007000000ULL,
0xff80000026267808ULL, 0x000fe40007000000ULL, 0xff8000000d0d7808ULL, 0x000fe40006800000ULL,
0xff80000025257808ULL, 0x000fe40006800000ULL, 0xff8000000e0e7808ULL, 0x000fe40005800000ULL,
0xff80000024247808ULL, 0x000fe40005800000ULL, 0xff80000020207808ULL, 0x000fc40005000000ULL,
0xff80000023237808ULL, 0x000fe40005000000ULL, 0xff80000021217808ULL, 0x000fe40004800000ULL,
0xff80000022227808ULL, 0x000fc40004800000ULL, 0x000000331000720bULL, 0x004fe40003f1e000ULL,
0x000000141100720bULL, 0x000fe40003f3e000ULL, 0x0000001033317208ULL, 0x000fe40004000000ULL,
0x0000001114087208ULL, 0x000fc40004800000ULL, 0x000000303100720bULL, 0x000fe40003f1e000ULL,
0x000000150800720bULL, 0x000fe40003f3e000ULL, 0x0000003130107208ULL, 0x000fe40004000000ULL,
0x0000000815117208ULL, 0x000fe40004800000ULL, 0x0000002b1000720bULL, 0x000fe40003f1e000ULL,
0x000000161100720bULL, 0x000fc40003f3e000ULL, 0x000000102b107208ULL, 0x000fe40004000000ULL,
0x0000001116087208ULL, 0x000fe40004800000ULL, 0x0000002f1000720bULL, 0x000fe40003f1e000ULL,
0x000000170800720bULL, 0x000fe40003f3e000ULL, 0x000000102f117208ULL, 0x000fe40004000000ULL,
0x0000000817087208ULL, 0x000fc40004800000ULL, 0x0000002e1100720bULL, 0x000fe40003f1e000ULL,
0x0000001b0800720bULL, 0x000fe40003f3e000ULL, 0x000000112e117208ULL, 0x000fe40004000000ULL,
0x000000081b317208ULL, 0x000fe40004800000ULL, 0x0000002a1100720bULL, 0x000fe40003f1e000ULL,
0x0000001c3100720bULL, 0x000fc40003f3e000ULL, 0x000000112a117208ULL, 0x000fe40004000000ULL,
0x000000311c087208ULL, 0x000fe40004800000ULL, 0x0000002c1100720bULL, 0x000fe40003f1e000ULL,
0x0000001d0800720bULL, 0x000fe40003f3e000ULL, 0x000000112c107208ULL, 0x000fe40004000000ULL,
0x000000081d117208ULL, 0x000fc40004800000ULL, 0x000000291000720bULL, 0x000fe40003f1e000ULL,
0x0000001e1100720bULL, 0x000fe40003f3e000ULL, 0x0000001029107208ULL, 0x000fe40004000000ULL,
0x000000111e087208ULL, 0x000fe40004800000ULL, 0x0000002d1000720bULL, 0x000fe40003f1e000ULL,
0x0000001f0800720bULL, 0x000fc40003f3e000ULL, 0x000000102d117208ULL, 0x000fe40004000000ULL,
0x000000081f317208ULL, 0x000fe40004800000ULL, 0x000000281100720bULL, 0x000fe40003f1e000ULL,
0x0000001a3100720bULL, 0x000fe40003f3e000ULL, 0x0000001128087208ULL, 0x000fe40004000000ULL,
0x000000311a317208ULL, 0x000fc40004800000ULL, 0x000000270800720bULL, 0x000fe40003f1e000ULL,
0x000000183100720bULL, 0x000fe40003f3e000ULL, 0x0000000827117208ULL, 0x000fe40004000000ULL,
0x0000003118087208ULL, 0x000fe40004800000ULL, 0x000000261100720bULL, 0x000fe40003f1e000ULL,
0x000000190800720bULL, 0x000fc40003f3e000ULL, 0x0000001126107208ULL, 0x000fe40004000000ULL,
0x0000000819087208ULL, 0x000fe40004800000ULL, 0x000000251000720bULL, 0x000fe40003f1e000ULL,
0x0000000d0800720bULL, 0x000fe40003f3e000ULL, 0x0000001025117208ULL, 0x000fe40004000000ULL,
0x000000080d317208ULL, 0x000fc40004800000ULL, 0x000000241100720bULL, 0x000fe40003f1e000ULL,
0x0000000e3100720bULL, 0x000fe40003f3e000ULL, 0x0000001124087208ULL, 0x000fe40004000000ULL,
0x000000310e317208ULL, 0x000fe40004800000ULL, 0x000000230800720bULL, 0x000fe40003f1e000ULL,
0x000000203100720bULL, 0x000fc40003f3e000ULL, 0x0000000823117208ULL, 0x000fe40004000000ULL,
0x0000003120087208ULL, 0x000fe40004800000ULL, 0x000000221100720bULL, 0x000fe40003f1e000ULL,
0x000000210800720bULL, 0x000fe40003f3e000ULL, 0x0000001122327208ULL, 0x000fe40004000000ULL,
0x0000000821367208ULL, 0x000fe20004800000ULL, 0x000017727f007947ULL, 0x000fec000b800000ULL,
0x0c401f0032087f89ULL, 0x0004e400000e0000ULL, 0x000000083200720bULL, 0x008fc80003f1e000ULL,
0x0000003208387208ULL, 0x000fe20004000000ULL, 0x000017a27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0036087f89ULL, 0x000ee800000e0000ULL, 0x0c401f0012117f89ULL, 0x000f2800000e0000ULL,
0x0c401f0013107f89ULL, 0x000e6200000e0000ULL, 0x000000083600720bULL, 0x008fc40003f1e000ULL,
0x000000111200720bULL, 0x010fe40003f3e000ULL, 0x0000003608327208ULL, 0x006fe40004000000ULL,
0x0000001211347208ULL, 0x000fe40004800000ULL, 0x0c201f0038117f89ULL, 0x000e6200000e0000ULL,
0x000000101300720bULL, 0x000fc60003f1e000ULL, 0x0c201f0032357f89ULL, 0x000ea200000e0000ULL,
0x0000001310087208ULL, 0x000fc60004000000ULL, 0x0c201f0034377f89ULL, 0x000ee800000e0000ULL,
0x0c201f0008317f89ULL, 0x0002e400000e0000ULL, 0x000000113800720bULL, 0x002fe40003f1e000ULL,
0x000000353200720bULL, 0x004fe40003f3e000ULL, 0x0000003811107208ULL, 0x000fc40004000000ULL,
0x000000373400720bULL, 0x008fe40003f5e000ULL, 0x0000003235117208ULL, 0x000fe40004800000ULL,
0x0000003437127208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b10327820ULL, 0x002fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000302ff7812ULL, 0x000fe4000780c0ffULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010832ULL, 0x000000310800720bULL, 0x004fe20003f3e000ULL,
0x3fb8aa3b2a2a7823ULL, 0x000fc40000010832ULL, 0x0000002b00347308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b2c137823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b33337823ULL, 0x100fe40000010832ULL,
0x3fb8aa3b30307823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010832ULL,
0x0000002a00357308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b272b7823ULL, 0x102fe40000010832ULL,
0x3fb8aa3b22277823ULL, 0x000fc40000010832ULL, 0x3fb8aa3b11227820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b29377823ULL, 0x000fe20000010832ULL, 0x0000001300367308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b14147823ULL, 0x100fe40000010822ULL, 0x3fb8aa3b15157823ULL, 0x100fe40000010822ULL,
0x3fb8aa3b16167823ULL, 0x100fe40000010822ULL, 0x3fb8aa3b17177823ULL, 0x000fe20000010822ULL,
0x0000003300337308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b282c7823ULL, 0x000fc40000010832ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b2d297823ULL, 0x100fe40000010832ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010832ULL, 0x0000003000307308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b25287823ULL, 0x100fe40000010832ULL, 0x3fb8aa3b24137823ULL, 0x102fe40000010832ULL,
0x3fb8aa3b232a7823ULL, 0x000fc40000010832ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe20000010822ULL,
0x0000001400237308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe40000010822ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe40000010822ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe40000010822ULL,
0x3fb8aa3b1f397823ULL, 0x100fe20000010822ULL, 0x0000001500247308ULL, 0x000e620000000800ULL,
0x000000333014723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b0d0d7823ULL, 0x000fc40000010822ULL,
0x3fb8aa3b0e0e7823ULL, 0x000fc80000010822ULL, 0x0000001600257308ULL, 0x000ff00000000800ULL,
0x0000001700327308ULL, 0x000ea20000000800ULL, 0x000000232415723eULL, 0x002fe200000000ffULL,
0x3c003c00ff247424ULL, 0x000fc400078e00ffULL, 0x3fb8aa3b1a237823ULL, 0x000fc80000010822ULL,
0x0000002f002f7308ULL, 0x000e620000000800ULL, 0x000000253217723eULL, 0x004fe200000000ffULL,
0x3c003c00ff257424ULL, 0x000fcc00078e00ffULL, 0x0000001c00387308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b19327823ULL, 0x100fe20000010822ULL, 0x000000342f16723eULL, 0x002fe200000000ffULL,
0x3fb8aa3b182f7823ULL, 0x000fca0000010822ULL, 0x0000001d002d7308ULL, 0x000ff00000000800ULL,
0x0000001e003a7308ULL, 0x0003f00000000800ULL, 0x0000001b001b7308ULL, 0x000ea20000000800ULL,
0x00000024141c723cULL, 0x002f6e00000018ffULL, 0x0000002e002e7308ULL, 0x000e700000000800ULL,
0x0000003700377308ULL, 0x000ee20000000800ULL, 0x0000001b3819723eULL, 0x004fc400000000ffULL,
0x0000002d3a1b723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b202d7823ULL, 0x000fe20000010822ULL,
0x0000002e3518723eULL, 0x002fc600000000ffULL, 0x0000002300307308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b212e7823ULL, 0x000fe20000010822ULL, 0x00000036371a723eULL, 0x008fcc00000000ffULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x00000002ff377819ULL, 0x000fc80000011602ULL,
0x0000000137337810ULL, 0x040fe20007ffe0ffULL, 0x000000241820723cULL, 0x022b62000000181cULL,
0x00000008373a7824ULL, 0x040fe200078e00ffULL, 0x0000002c002c7308ULL, 0x000e620000000800ULL,
0x0000000837347824ULL, 0x040fe200078e00ffULL, 0x0000000237357810ULL, 0x040fe20007ffe0ffULL,
0x0000000837367824ULL, 0x040fe200078e00ffULL, 0x00000008373e7810ULL, 0x040fe20007ffe0ffULL,
0x00000008371f7824ULL, 0x060fe200078e00ffULL, 0x00000003371c7810ULL, 0x040fe40007ffe0ffULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x00000004371d7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff81f387812ULL, 0x000fe400078ee21cULL, 0xfffffff83a3a7812ULL, 0x000fe400078ee21dULL,
0xfffffff834347812ULL, 0x000fe200078ee233ULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x000000292c1c723eULL, 0x002fe200000000ffULL, 0x00000008372c7824ULL, 0x040fe200078e00ffULL,
0x0000000537297810ULL, 0x000fe20007ffe0ffULL, 0x000000083e337824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fc400078ee235ULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee229ULL,
0x0000003900397308ULL, 0x000e620000000800ULL, 0xfffffff8333e7812ULL, 0x000fce00078ee23eULL,
0x0000002f002f7308ULL, 0x000fe20000000800ULL, 0x0000002b261e723eULL, 0x004fe200000000ffULL,
0x0000000837267824ULL, 0x040fe200078e00ffULL, 0x00000006372b7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff826267812ULL, 0x000fe200078ee237ULL, 0x0000003200327308ULL, 0x000ea20000000800ULL,
0x00000039301d723eULL, 0x002fe200000000ffULL, 0x0000000837307824ULL, 0x000fca00078e00ffULL,
0xfffffff830307812ULL, 0x000fe200078ee22bULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x0000002f321f723eULL, 0x004fce00000000ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000000837327824ULL, 0x040fe200078e00ffULL, 0xffffffff372f7810ULL, 0x000fe20007ffe0ffULL,
0x000000241c20723cULL, 0x000f660000001820ULL, 0xfffffff832327812ULL, 0x000fe400078ee22fULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0x000000281328723eULL, 0x002fc400000000ffULL, 0x000110003c137811ULL, 0x000fca00078e58ffULL,
0x0000000d000d7308ULL, 0x000fe20000000800ULL, 0x0000001026267824ULL, 0x100fe400078e0213ULL,
0x0000001034347824ULL, 0x100fe400078e0213ULL, 0x0000001036367824ULL, 0x100fe400078e0213ULL,
0x0000001038387824ULL, 0x100fe200078e0213ULL, 0x0000000e000e7308ULL, 0x000e620000000800ULL,
0x0000002a272a723eULL, 0x004fe200000000ffULL, 0x000000103a3a7824ULL, 0x000fc400078e0213ULL,
0x000000102c2c7824ULL, 0x100fe400078e0213ULL, 0x0000001030307824ULL, 0x100fe400078e0213ULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x0000001032327824ULL, 0x100fe400078e0213ULL,
0x000000103e3e7824ULL, 0x000fe200078e0213ULL, 0x0000000831137208ULL, 0x000fc80004800000ULL,
0x0000002e002e7308ULL, 0x000ea20000000800ULL, 0x0000000d0e29723eULL, 0x002fe400000000ffULL,
0x0000000c0c0d7812ULL, 0x000fca00078ec0ffULL, 0x0000000126277824ULL, 0x000fe400078e020dULL,
0x000000010d347824ULL, 0x040fe400078e0234ULL, 0x000000010d367824ULL, 0x040fe200078e0236ULL,
0x0000001427007388ULL, 0x0003e20000000800ULL, 0x000000010d387824ULL, 0x040fe200078e0238ULL,
0x0000002d2e2b723eULL, 0x004fe200000000ffULL, 0x000000010d3a7824ULL, 0x040fe200078e023aULL,
0x0000001634007388ULL, 0x0003e20000000800ULL, 0x000000010d2c7824ULL, 0x000fc400078e022cULL,
0x000000010d307824ULL, 0x040fe200078e0230ULL, 0x0000001836007388ULL, 0x0003e20000000800ULL,
0x000000242820723cULL, 0x020f620000001820ULL, 0x000000010d327824ULL, 0x040fe400078e0232ULL,
0x000000010d3e7824ULL, 0x000fe200078e023eULL, 0x0000001a38007388ULL, 0x0003e80000000800ULL,
0x0000001c3a007388ULL, 0x0003e80000000800ULL, 0x0000001e2c007388ULL, 0x0003e80000000800ULL,
0x0000002830007388ULL, 0x0003e80000000800ULL, 0x0000002a32007388ULL, 0x0003e80000000800ULL,
0x000000153e007388ULL, 0x0003e20000000800ULL, 0x000000ffff217224ULL, 0x020fc600078e0022ULL,
0x0004001734007388ULL, 0x0003e80000000800ULL, 0x0004001936007388ULL, 0x0003e80000000800ULL,
0x0004001b38007388ULL, 0x0003e80000000800ULL, 0x0004001d3a007388ULL, 0x0003e80000000800ULL,
0x0004001f2c007388ULL, 0x0003e80000000800ULL, 0x0004002930007388ULL, 0x0003e80000000800ULL,
0x0004002b32007388ULL, 0x0003e80000000800ULL, 0x017000100a008388ULL, 0x0003e80000000c00ULL,
0x017200200a008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000007ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080007ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100007ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000109097810ULL, 0x000fe20007ffe0ffULL, 0x0000180007ff7f8cULL, 0x0003e2000c80043fULL,
0x000000ffff0d7224ULL, 0x000fc400078e000bULL, 0x0000000f0900720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffbc9000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff107807ULL, 0x008fe20004000000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x000119b000177802ULL, 0x000fc40000000f00ULL,
0x00000ff000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0016ULL,
0xffff04d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20004000000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x00011a1000177802ULL, 0x000fc40000000f00ULL,
0x00000f9000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff157224ULL, 0x000fe200078e0016ULL,
0xffff051000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1c7224ULL, 0x008fe200078e0017ULL,
0x00011a80001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x00000ed000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e001cULL, 0xffff05b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1c7224ULL, 0x000fe200078e0017ULL, 0x00011af0001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x00000e6000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e001cULL,
0xffff06b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1c7224ULL, 0x000fe200078e0013ULL,
0x00011b70001e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fe400078e0014ULL,
0x0000001fff1d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x00000de000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e001cULL,
0xffff0a9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff107224ULL, 0x000fe200078e0000ULL,
0x00011bf0001e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff1c7224ULL, 0x000fc400078e0013ULL,
0x0000001fff1d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x00000d6000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e001cULL,
0xffff0a4000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x004fe20004000000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x00011c5000177802ULL, 0x000fc40000000f00ULL,
0x00000d5000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff157224ULL, 0x000fe200078e0016ULL,
0xffff2ae000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20004000000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x00011cb000177802ULL, 0x000fc40000000f00ULL,
0x00000cf000007944ULL, 0x000fea0003c00000ULL, 0xffff2b3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1c7224ULL, 0x000fe200078e0040ULL, 0x00011d10001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x00000c4000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e001cULL,
0xffff2bf000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1c7224ULL, 0x000fe200078e0040ULL,
0x00011d80001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x00000bd000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e001cULL, 0xffff2ce000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1c7224ULL, 0x000fe200078e0012ULL, 0x00011e00001e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fe400078e0013ULL, 0x0000001fff1d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x00000b5000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e001cULL, 0xffff312000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1c7224ULL, 0x000fe200078e0012ULL, 0x00011e70001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x00000ae000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e001cULL,
0xffff30e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x004fe20004000000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x00011ed000177802ULL, 0x000fc40000000f00ULL,
0x00000ad000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0016ULL,
0xffff4ea000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20004000000ULL,
0xffffffffff117424ULL, 0x000fe200078e00ffULL, 0x00011f3000177802ULL, 0x000fc40000000f00ULL,
0x00000a7000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff157224ULL, 0x000fe200078e0016ULL,
0xffff4ed000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1c7224ULL, 0x000fe200078e0016ULL,
0x00011fa0001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x000009b000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e001cULL, 0xffff4f9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1c7224ULL, 0x000fe200078e0016ULL, 0x00012010001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x0000094000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e001cULL,
0xffff508000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1c7224ULL, 0x000fe200078e0012ULL,
0x00012090001e7802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fe400078e0013ULL,
0x0000001fff1d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x000008c000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e001cULL,
0xffff547000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1c7224ULL, 0x000fe200078e0012ULL,
0x00012100001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0000085000007944ULL, 0x00efea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e001cULL, 0xffff543000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x008fe20004000000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x0001216000177802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff147224ULL, 0x000fe200078e0016ULL, 0xffff726000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe20004000000ULL, 0xffffffffff117424ULL, 0x000fe200078e00ffULL,
0x000121c000177802ULL, 0x000fc40000000f00ULL, 0x000007e000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff177224ULL, 0x000fe200078e0016ULL, 0xffff729000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1c7224ULL, 0x002fe200078e0016ULL, 0x00012230001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x0000072000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e001cULL,
0xffff735000007947ULL, 0x000fea000383ffffULL, 0x000000ffff1c7224ULL, 0x002fe200078e0016ULL,
0x000122a0001e7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x000006b000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e001cULL, 0xffff744000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1c7224ULL, 0x000fe200078e0012ULL, 0x00012320001e7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fe400078e0013ULL, 0x0000001fff1d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0000063000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e001cULL, 0xffff784000007947ULL, 0x000fea000383ffffULL,
0x000000ffff1c7224ULL, 0x000fe200078e0012ULL, 0x00012390001e7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x000005c000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e001cULL,
0xffff780000007947ULL, 0x000fea000383ffffULL, 0x00000002ff377424ULL, 0x000fe200078e00ffULL,
0x0001240000347802ULL, 0x000fe20000000f00ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0031ULL, 0xffffe83000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x006fe200078e0036ULL, 0x0001248000347802ULL, 0x000fe20000000f00ULL,
0x00000002ff377424ULL, 0x000fc400078e00ffULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x000fea0003c00000ULL,
0x000000313600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0012ULL,
0x0001250000347802ULL, 0x000fe20000000f00ULL, 0x00000002ff377424ULL, 0x000fe200078e00ffULL,
0x0000003631367208ULL, 0x000fe20004000000ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x000000311200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0013ULL,
0x0001258000347802ULL, 0x000fe20000000f00ULL, 0x00000002ff377424ULL, 0x000fe200078e00ffULL,
0x0000001231127208ULL, 0x000fe20004000000ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x000000311300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0038ULL,
0x0001260000347802ULL, 0x000fe20000000f00ULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000001331087208ULL, 0x000fe20004000000ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000313800720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0036ULL,
0x0001268000347802ULL, 0x000fe20000000f00ULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000003831107208ULL, 0x000fe20004000000ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x000000313600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0012ULL,
0x0001270000347802ULL, 0x000fe20000000f00ULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000003631117208ULL, 0x000fe20004000000ULL, 0x0000001fff317424ULL, 0x000fe400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x000000311200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0008ULL,
0x0001278000347802ULL, 0x000fe20000000f00ULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000001231127208ULL, 0x000fe20004000000ULL, 0x0000001fff317424ULL, 0x000fc400078e00ffULL,
0xffffffffff3a7424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe62000007947ULL, 0x000fea000383ffffULL, 0x0180000007007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000700008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000007027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffed6f002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff357424ULL, 0x000fe200078e00ffULL,
0x0000003a00007348ULL, 0x000fe80003800000ULL, 0x0c00003732317389ULL, 0x0002a200000e0031ULL,
0xfffed6b034007950ULL, 0x000fea0003c3ffffULL, 0x0000001f00007348ULL, 0x000fe80003800000ULL,
0x000000101c1c7389ULL, 0x0002a200000e001dULL, 0x00000000ff117424ULL, 0x000fc400078e00ffULL,
0x000000ffff107224ULL, 0x002fc800078e001eULL, 0xfffed66010007950ULL, 0x000fea0003c3ffffULL,
0x000000011000780cULL, 0x000fe20003f05070ULL, 0x0000001100007348ULL, 0x000fd80003800000ULL,
0x0000000000107806ULL, 0x000fc800040e0100ULL, 0x0000001110167212ULL, 0x000fe200078ec0ffULL,
0x000000ffff107224ULL, 0x000fe400078e0017ULL, 0x00000000ff117424ULL, 0x000fc800078e00ffULL,
0xfffed5f010007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005deULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x0000000000000348ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d10ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000dd0ULL, 0x0000000000000784ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001558ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001568ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015f8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015fcULL, 0x00000000000001a8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000012b00ULL, 0x8c00001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014300ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014350ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x00000000000146d0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000015f8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000012d08ULL, 0x0000000000012d08ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014300ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x00000000000146d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_80_cubin_len = 83888;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
