/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000012bd0ULL, 0x0000000000012850ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45346a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL, 0x497461324545386aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x386a4c4536316a4cULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL, 0x632e766e2e006675ULL,
0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL, 0x756265642e006d61ULL,
0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL, 0x642e616c65722e00ULL,
0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL, 0x000000000000006eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b0ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003feULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000443ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b002200000489ULL, 0x0000000000010cd0ULL, 0x0000000000000180ULL,
0x000b0022000004bcULL, 0x0000000000010e50ULL, 0x0000000000000040ULL, 0x000b0022000004e7ULL,
0x0000000000010e90ULL, 0x0000000000000050ULL, 0x000b002200000511ULL, 0x0000000000010ee0ULL,
0x0000000000000120ULL, 0x000a00030000057fULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000400030000059fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005cfULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000011000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00010cd000000000ULL, 0x0000040400000000ULL,
0x810c000001340400ULL, 0x0041f40400288080ULL, 0x0000000000000000ULL, 0x0000006cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8308288080820828ULL, 0x2880809008288080ULL, 0x8095082880809408ULL,
0x0828808096082880ULL, 0x80809c0828808097ULL, 0x8016288080840828ULL, 0x0000000310288082ULL,
0x8084920000000000ULL, 0x0000000022002880ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x00010cd000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808084ULL, 0x0000006cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8308288080820828ULL, 0x2880808408288080ULL, 0x8094082880809008ULL, 0x0828808095082880ULL,
0x80809c0828808096ULL, 0x8016288080b40828ULL, 0x0000000310288082ULL, 0x80b4920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000012800000000ULL, 0x00010e5000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000006cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8308288080820828ULL, 0x2880808408288080ULL, 0x8094082880809008ULL, 0x0828808095082880ULL,
0x8080970828808096ULL, 0x80162880809c0828ULL, 0x0000000310288082ULL, 0x809c920000000000ULL,
0x0000000022002880ULL, 0x0000002cffffffffULL, 0x000001c800000000ULL, 0x00010e9000000000ULL,
0x0000005000000000ULL, 0x0000100400000000ULL, 0x80902880809c0900ULL, 0x0000000000002880ULL,
0x0000006cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8308288080820828ULL, 0x2880808408288080ULL,
0x8094082880809008ULL, 0x0828808095082880ULL, 0x80809c0828808096ULL, 0x8016288080970828ULL,
0x0000000310288082ULL, 0x8097920000000000ULL, 0x0000000022002880ULL, 0x0000002cffffffffULL,
0x0000027800000000ULL, 0x00010ee000000000ULL, 0x0000012000000000ULL, 0x0000180400000000ULL,
0x8090288080970900ULL, 0x0000000000002880ULL, 0x0000001a00082f04ULL, 0x000823040000008fULL,
0x0000000000000016ULL, 0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL,
0x0000001500082304ULL, 0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL,
0x0008230400000000ULL, 0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL,
0x0000000000000014ULL, 0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL,
0x0000001300081104ULL, 0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL,
0x0008110400000000ULL, 0x000000000000001aULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0048016000000017ULL, 0x000c170400481903ULL, 0x0040000600000000ULL, 0x000c17040021f000ULL,
0x0038000500000000ULL, 0x000c17040021f000ULL, 0x0030000400000000ULL, 0x000c17040011f000ULL,
0x0018000300000000ULL, 0x000c17040061f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL,
0x0008000100000000ULL, 0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x0000002000043104ULL, 0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x000000d001342804ULL, 0x00000400000000f0ULL, 0x00001f6000001ea0ULL, 0x000021e000002070ULL,
0x0000267000002640ULL, 0x00002710000026c0ULL, 0x000047e000004740ULL, 0x00004a7000004910ULL,
0x00004f6000004f30ULL, 0x0000500000004fb0ULL, 0x00006dd000006d40ULL, 0x0000706000006f00ULL,
0x00007500000074d0ULL, 0x000075a000007550ULL, 0x000093d000009340ULL, 0x0000966000009500ULL,
0x00009b1000009ae0ULL, 0x00009bb000009b60ULL, 0x0000ac900000ac80ULL, 0x0000f5600000f520ULL,
0x0000f5800000f570ULL, 0x0000f5f00000f5d0ULL, 0x0000f6200000f610ULL, 0x000102b000010260ULL,
0x0001035000010300ULL, 0x00010410000103b0ULL, 0x000104b000010460ULL, 0x00010540000104f0ULL,
0x000105f0000105a0ULL, 0x0001069000010640ULL, 0x00010730000106e0ULL, 0x000107e000010790ULL,
0x0001088000010830ULL, 0x00010910000108c0ULL, 0x000109c000010970ULL, 0x00010a7000010a10ULL,
0x00010b3000010ad0ULL, 0x00010bf000010b90ULL, 0x00010cb000010c50ULL, 0x0000020004403904ULL,
0x0000f600000000ffULL, 0x00000270003f0100ULL, 0x0000f60800000011ULL, 0x000002f0003f0120ULL,
0x0000f68800000011ULL, 0x000003a0003f0120ULL, 0x0000f6a800000011ULL, 0x000003d0003f0120ULL,
0x0000f6c800000011ULL, 0x00000460003f0120ULL, 0x0000f600000000ffULL, 0x00000560003f0107ULL,
0x0000f68c0000000cULL, 0x000005f0003f0102ULL, 0x0000f6880000000cULL, 0x00000d60003f0101ULL,
0x0000f6a800000008ULL, 0x00000e70003f0107ULL, 0x0000f6a800000008ULL, 0x00000ed0003f0101ULL,
0x0000002000000014ULL, 0x00001020003f0101ULL, 0x0000000400000004ULL, 0x00001200003f0105ULL,
0x0000000400000004ULL, 0x00001a30003f0105ULL, 0x0000f6a80000007aULL, 0x00001b10003f0107ULL,
0x0000f6a80000007aULL, 0x00001b70003f0101ULL, 0x0000f60800000011ULL, 0x00001bc0003f0101ULL,
0x0000f60c00000013ULL, 0x00001d90003f0105ULL, 0x0000f60c00000013ULL, 0x000023a0003f0105ULL,
0x0000f6ac00000017ULL, 0x00002570003f0105ULL, 0x0000f6ac00000017ULL, 0x00003810003f0105ULL,
0x0000000000000004ULL, 0x00003890003f0101ULL, 0x0000f68800000048ULL, 0x00003900003f0101ULL,
0x0000000400000004ULL, 0x00003ad0003f0105ULL, 0x0000000400000004ULL, 0x00004320003f0105ULL,
0x0000f6a800000054ULL, 0x00004410003f0107ULL, 0x0000f6a800000054ULL, 0x00004470003f0101ULL,
0x0000f62800000011ULL, 0x000044c0003f0101ULL, 0x0000f62c0000001cULL, 0x00004690003f0105ULL,
0x0000f62c0000001cULL, 0x00004c60003f0105ULL, 0x0000f6ac00000012ULL, 0x00004e50003f0105ULL,
0x0000f6ac00000017ULL, 0x00005f20003f0105ULL, 0x0000000000000004ULL, 0x00005f90003f0101ULL,
0x0000f69000000048ULL, 0x00005fe0003f0101ULL, 0x0000000400000004ULL, 0x000061b0003f0105ULL,
0x0000000400000004ULL, 0x00006900003f0105ULL, 0x0000000000000055ULL, 0x00006a40003f0107ULL,
0x0000f6a800000011ULL, 0x00006aa0003f0101ULL, 0x0000f64800000016ULL, 0x00006ac0003f0101ULL,
0x0000f64c00000016ULL, 0x00006c90003f0105ULL, 0x0000f64c00000016ULL, 0x00007230003f0105ULL,
0x0000f6ac00000054ULL, 0x00007400003f0105ULL, 0x0000f6ac00000054ULL, 0x00008510003f0105ULL,
0x0000000000000004ULL, 0x00008580003f0101ULL, 0x0000f69800000048ULL, 0x00008600003f0101ULL,
0x0000f6cc00000014ULL, 0x000087d0003f0105ULL, 0x0000f6cc00000014ULL, 0x00008f20003f0105ULL,
0x0000000000000053ULL, 0x00009040003f0107ULL, 0x0000f6a800000054ULL, 0x000090a0003f0101ULL,
0x0000f6680000001cULL, 0x000090c0003f0101ULL, 0x0000f66c0000001cULL, 0x00009290003f0105ULL,
0x0000f66c0000001cULL, 0x00009840003f0105ULL, 0x0000f6ac00000057ULL, 0x00009a10003f0105ULL,
0x0000f6ac00000057ULL, 0x0000aa50003f0105ULL, 0x0000000000000004ULL, 0x0000aab0003f0101ULL,
0x0000f6a000000048ULL, 0x0000b800003f0101ULL, 0x0000f600000000ffULL, 0x0000c2f0003f0101ULL,
0x0000f604000000ffULL, 0x0000c4c0003f0105ULL, 0x0000f604000000ffULL, 0x0000c6f0003f0105ULL,
0x0000f600000000ffULL, 0x0000c720003f0101ULL, 0x0000f604000000ffULL, 0x0000c8e0003f0105ULL,
0x0000f604000000ffULL, 0x0000e9d0003f0105ULL, 0x0000000000000005ULL, 0x0000ea50003f0101ULL,
0x0000000400000005ULL, 0x0000ec20003f0105ULL, 0x0000000400000005ULL, 0x000100c0003f0105ULL,
0x0000000000000007ULL, 0x00010120003f0101ULL, 0x0000000800000007ULL, 0x00010180003f0101ULL,
0x0000001000000007ULL, 0x000101f0003f0101ULL, 0x0000001800000007ULL, 0x00053803003f0101ULL,
0x0000b4e000141c04ULL, 0x0000c9400000b750ULL, 0x000102300000c9f0ULL, 0x000c050400000401ULL,
0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x0000000000000304ULL, 0x0000001a00000002ULL, 0x0000000000000254ULL,
0x0000001a00000002ULL, 0x00000000000001b4ULL, 0x0000001a00000002ULL, 0x00000000000000fcULL,
0x0000001a00000002ULL, 0x0000000000000044ULL, 0x0000001a00000002ULL, 0x00000000000002ddULL,
0x0000001a00000002ULL, 0x000000000000022dULL, 0x0000001a00000002ULL, 0x000000000000018dULL,
0x0000001a00000002ULL, 0x00000000000000d5ULL, 0x0000001a00000002ULL, 0x000000000000f700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000117919ULL, 0x000e620000002100ULL,
0x0000000000147806ULL, 0x000fe200038e0000ULL, 0x00005800ff077624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000027919ULL, 0x000ea40000002300ULL,
0x0000000807077824ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000ee80000002200ULL,
0x00000000000d7919ULL, 0x000f280000000000ULL, 0x0000000000047919ULL, 0x000f280000000000ULL,
0x0000000000127919ULL, 0x000f220000002600ULL, 0x00000005ff3c7819ULL, 0x002fc60000011611ULL,
0x00000000000e7919ULL, 0x000e680000002700ULL, 0x00001fff020f7589ULL, 0x0045e200000e0000ULL,
0x0000010002007a24ULL, 0x008fc600078e0203ULL, 0x00001fff3c3c7589ULL, 0x000ee200000e0000ULL,
0x0000001400037300ULL, 0x000ea200000e0000ULL, 0x0000000000117a24ULL, 0x000fe200078e0211ULL,
0x00000004ff137819ULL, 0x010fe2000001160dULL, 0x000000100d107824ULL, 0x000fc600078e00ffULL,
0x000000ff1100720cULL, 0x040fe40003f45270ULL, 0x0000001400147309ULL, 0x000f220000000000ULL,
0x0000000f1100780cULL, 0x040fe20003f64070ULL, 0x0000000812007824ULL, 0x000fe200078e00ffULL,
0x0000007f1100780cULL, 0x040fe40003f84070ULL, 0x000000031100780cULL, 0x000fe20003f24070ULL,
0x0000000e07007224ULL, 0x002fe200078e0200ULL, 0x000000040300720cULL, 0x004fc80003f02070ULL,
0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL, 0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL,
0x000000040f067824ULL, 0x008fe400078e023cULL, 0x3fffffc0ff04b424ULL, 0x000fe200078e00ffULL,
0x00f60002ff00a388ULL, 0x0003e20000000a00ULL, 0x0000000206087824ULL, 0x000fe200078e00ffULL,
0x000000011100780cULL, 0x000fe20003f44070ULL, 0x7fffffc0ff05b424ULL, 0x000fc400078e00ffULL,
0xff317217ff0ac424ULL, 0x000fe200078e00ffULL, 0x0000000808097817ULL, 0x040fe20007800000ULL,
0x3fffff60ff069424ULL, 0x000fe200078e00ffULL, 0x00f608041100b388ULL, 0x0005e20000008a00ULL,
0x7fffff60ff079424ULL, 0x000fe400078e00ffULL, 0x00000001090c7824ULL, 0x000fe200078e0a08ULL,
0x00f4000a1100c388ULL, 0x0007e20000004800ULL, 0x0000000108087824ULL, 0x000fe400078e0213ULL,
0x00000100ff037424ULL, 0x002fe200078e00ffULL, 0x0000000c1300720cULL, 0x000fe20003f66070ULL,
0x0000000100007824ULL, 0x000fe200078e0208ULL, 0x00f6880611009388ULL, 0x0003e20000008a00ULL,
0x0000001008157824ULL, 0x000fe200078e00ffULL, 0x000000f010057812ULL, 0x004fe200078ec0ffULL,
0x0000000108047824ULL, 0x000fc400078e020dULL, 0x00005c0000027625ULL, 0x000fc600078e0003ULL,
0xfffffff015007812ULL, 0x000fe200078ee204ULL, 0x3fffff80ff089424ULL, 0x000fe200078e00ffULL,
0x0000000502047210ULL, 0x000fe20007f9e0ffULL, 0x7fffff80ff099424ULL, 0x000fe400078e00ffULL,
0x3fffffc0ff0aa424ULL, 0x008fe400078e00ffULL, 0x7fffffc0ff0ba424ULL, 0x000fe200078e00ffULL,
0x00f6a80811009388ULL, 0x000fe20000008a00ULL, 0x000000ffff057224ULL, 0x000fe400020e0603ULL,
0x0000001000077824ULL, 0x002fe200078e00ffULL, 0x00f6c80a1100a388ULL, 0x000fe20000008a00ULL,
0x000000ffff067224ULL, 0x010fc400078e0a14ULL, 0x00000004ff037424ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e2000d901c46ULL, 0x000060000e027625ULL, 0x000fc600078e0003ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00f60406ffff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006023d7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0f00720cULL, 0x000fc40003f05270ULL,
0x000000ff3d007810ULL, 0x004fc80007ffe0ffULL, 0x00000008ff0f7819ULL, 0x000fce0000011600ULL,
0x0000b23000008947ULL, 0x000fea0003800000ULL, 0x000000083c0c7824ULL, 0x000fe400078e00ffULL,
0x00000003ff037424ULL, 0x000fe200078e00ffULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f68c030cff738cULL, 0x0005e20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x000000020e097824ULL, 0x000fe200078e00ffULL,
0x0000580012027a10ULL, 0x000fe20007ffe0ffULL, 0x00f688000cff7f8cULL, 0x0007e2000c80043fULL,
0x00000001ff0b7819ULL, 0x000fe4000001163cULL, 0x000000013c0e7812ULL, 0x000fe200078ec0ffULL,
0x0000580009097a24ULL, 0x000fc400078e0202ULL, 0x000000200b0a7824ULL, 0x000fc800078e00ffULL,
0x0000620009007a24ULL, 0x000fe200078e020aULL, 0x000003c000000947ULL, 0x000fea0003800000ULL,
0x0000000a3d037217ULL, 0x00cfe20007800000ULL, 0x000000100e027824ULL, 0x000fe200078e00ffULL,
0x00000003ff047819ULL, 0x002fe2000001160dULL, 0x00000080ff177424ULL, 0x000fe200078e00ffULL,
0x00000070101b7812ULL, 0x000fe200078ec0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a0aULL,
0x0000000404077810ULL, 0x000fe20007ffe0ffULL, 0x0000000102057824ULL, 0x000fc600078e0204ULL,
0x0000000203037217ULL, 0x000fe20007800000ULL, 0x0000000105067824ULL, 0x040fe400078e020dULL,
0x0000000805117824ULL, 0x000fe400078e00ffULL, 0x0000000103037824ULL, 0x000fe400078e0a02ULL,
0x0000000102087824ULL, 0x000fe200078e0207ULL, 0xfffffff811067812ULL, 0x000fe400078ee206ULL,
0x000000030700720cULL, 0x000fe20003f46070ULL, 0x0000000808157824ULL, 0x000fe200078e00ffULL,
0x0000000804077810ULL, 0x000fc40007ffe0ffULL, 0x0000000c04117810ULL, 0x000fe40007ffe0ffULL,
0x000000030700720cULL, 0x080fe20003f26070ULL, 0x0000000102077824ULL, 0x000fe200078e0207ULL,
0x000000030400720cULL, 0x080fe20003f66070ULL, 0x0000000102137824ULL, 0x000fe200078e0211ULL,
0x000000031100720cULL, 0x000fe20003f06070ULL, 0x0000000100027824ULL, 0x000fe400078e0205ULL,
0x0000000108047824ULL, 0x000fe400078e020dULL, 0x00005e0002027625ULL, 0x000fc600078e0017ULL,
0xfffffff815127812ULL, 0x000fe200078ee204ULL, 0x0000000100087824ULL, 0x000fe200078e0208ULL,
0x0000001b02107210ULL, 0x000fe20007f9e0ffULL, 0x0000000100047824ULL, 0x040fe400078e0207ULL,
0x0000000100147824ULL, 0x000fe400078e0213ULL, 0x0000000107007824ULL, 0x100fe400078e020dULL,
0x0000000113057824ULL, 0x040fe400078e020dULL, 0x0000000813167824ULL, 0x000fe200078e00ffULL,
0x0000b0000b137811ULL, 0x000fe200078e68ffULL, 0x0000000807077824ULL, 0x000fc400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200020e0603ULL, 0xfffffff816167812ULL, 0x000fe200078ee205ULL,
0x00005e0008027625ULL, 0x000fe200078e0017ULL, 0xfffffff807007812ULL, 0x000fc600078ee200ULL,
0x0000001006157824ULL, 0x000fe200078e0213ULL, 0x0000001b02027210ULL, 0x000fe20007f9e0ffULL,
0x00005e0004047625ULL, 0x000fc600078e0017ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000d901c46ULL, 0x00005e0014067625ULL, 0x000fe200078e0017ULL,
0x0000001b04047210ULL, 0x000fc60007fbe0ffULL, 0x0000001012177824ULL, 0x000fe200078e0213ULL,
0x0000001b06067210ULL, 0x000fe20007fde0ffULL, 0x000000ffff037224ULL, 0x000fe400020e0603ULL,
0x0000001000197824ULL, 0x000fe400078e0213ULL, 0x000000ffff057224ULL, 0x000fe200028e0605ULL,
0x0000000002177faeULL, 0x0003e2000d101c46ULL, 0x0000001016137824ULL, 0x000fe400078e0213ULL,
0x000000ffff077224ULL, 0x000fe200030e0607ULL, 0x0000000004197faeULL, 0x0003e8000c901c46ULL,
0x0000000006137faeULL, 0x0003e2000c101c46ULL, 0x000002f000007947ULL, 0x000fea0003800000ULL,
0x000000100e027824ULL, 0x008fe200078e00ffULL, 0x0000007010177812ULL, 0x000fe200078ec0ffULL,
0x00000080ff167424ULL, 0x000fe200078e00ffULL, 0x0000b0000b197811ULL, 0x000fc400078e68ffULL,
0x000000020d027211ULL, 0x000fc800078fe8ffULL, 0x0000000402047810ULL, 0x042fe20007ffe0ffULL,
0x0000000102037824ULL, 0x144fe200078e020dULL, 0x0000000802077810ULL, 0x040fe20007ffe0ffULL,
0x0000000802087824ULL, 0x040fe200078e00ffULL, 0x0000000c02107810ULL, 0x000fe20007ffe0ffULL,
0x0000000100057824ULL, 0x000fe400078e0204ULL, 0x0000000104067824ULL, 0x000fe200078e020dULL,
0xfffffff808087812ULL, 0x000fe200078ee203ULL, 0x0000000100037824ULL, 0x000fe400078e0202ULL,
0x0000000804157824ULL, 0x000fc400078e00ffULL, 0x00005e0003027625ULL, 0x000fc800078e0016ULL,
0x0000000100047824ULL, 0x040fe400078e0207ULL, 0x0000000107117824ULL, 0x140fe400078e020dULL,
0x0000000807127824ULL, 0x000fe400078e00ffULL, 0x0000000100137824ULL, 0x000fe200078e0210ULL,
0xfffffff815007812ULL, 0x000fe200078ee206ULL, 0x0000000110077824ULL, 0x000fe200078e020dULL,
0xfffffff812127812ULL, 0x000fe200078ee211ULL, 0x0000000810147824ULL, 0x000fe200078e00ffULL,
0x0000001702107210ULL, 0x000fe20007f1e0ffULL, 0x0000001000157824ULL, 0x000fc600078e0219ULL,
0xfffffff814147812ULL, 0x000fe200078ee207ULL, 0x000000ffff117224ULL, 0x000fe400000e0603ULL,
0x00005e0005027625ULL, 0x000fc800078e0016ULL, 0x00005e0004047625ULL, 0x000fe200078e0016ULL,
0x0000001702027210ULL, 0x000fc60007f1e0ffULL, 0x00005e0013067625ULL, 0x000fe200078e0016ULL,
0x0000001704047210ULL, 0x000fc60007f3e0ffULL, 0x0000001008137824ULL, 0x000fe200078e0219ULL,
0x0000001706067210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff037224ULL, 0x000fe400000e0603ULL,
0x0000001012177824ULL, 0x000fe200078e0219ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0003e2000b901c46ULL, 0x000000ffff057224ULL, 0x000fe400008e0605ULL,
0x0000001014197824ULL, 0x000fe200078e0219ULL, 0x0000000002157faeULL, 0x0003e2000b901c46ULL,
0x000000ffff077224ULL, 0x000fc600010e0607ULL, 0x0000000004177faeULL, 0x0003e8000b901c46ULL,
0x0000000006197faeULL, 0x0003e4000b901c46ULL, 0x000000100b087824ULL, 0x000fe200078e00ffULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x000000ffff077224ULL, 0x002fe200078e00ffULL,
0x0000f6a80b147811ULL, 0x000fe200078e18ffULL, 0x00000000080473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a800085a7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200014147f8cULL, 0x000ee2000c80043fULL,
0x000000ffff307224ULL, 0x000fe200078e00ffULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00009b9000008947ULL, 0x000fea0003800000ULL,
0xff317217ff587424ULL, 0x000fe400078e00ffULL, 0x000000ffff067224ULL, 0x000fc400078e00ffULL,
0x000000ffff127224ULL, 0x000fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x000fc400078e00ffULL,
0x0000010006047824ULL, 0x002fca00078e00ffULL, 0x0000003d0400720cULL, 0x000fda0003f06070ULL,
0x00009ae000000947ULL, 0x004fea0003800000ULL, 0x000000ffff057224ULL, 0x000fc400078e0012ULL,
0x0000000000107805ULL, 0x000fca0000015200ULL, 0x0000f6c80b047811ULL, 0x000fca00078e18ffULL,
0x0000040004147984ULL, 0x008ee40000000800ULL, 0x8000000014ff7812ULL, 0x008fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001610147210ULL, 0x000fca0007f1e1ffULL, 0x0000000117167824ULL, 0x000fe200000e0e11ULL,
0x003d09001400780cULL, 0x000fc80003f06070ULL, 0x000000ff1600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401400780cULL, 0x000fc80003f06070ULL,
0x000000ff1600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff137819ULL, 0x000fc80000011416ULL, 0x0000001413137211ULL, 0x000fca00078110ffULL,
0x000000ffff147224ULL, 0x000fca00000e0616ULL, 0x0000000213137819ULL, 0x000fc80000001214ULL,
0x000000130000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000040004147984ULL, 0x000ee40000000800ULL, 0x8000000014ff7812ULL, 0x008fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000106107810ULL, 0x040fe20007ffe0ffULL, 0x0000010006457824ULL, 0x000fe200078e020aULL,
0x0000000112467812ULL, 0x000fe400078e0cffULL, 0x0000000f1000720cULL, 0x000fe40003f06070ULL,
0x0000004045147810ULL, 0x000fca0007ffe0ffULL, 0x00006200091e7a24ULL, 0x000fcc00078e0214ULL,
0x000003e000008947ULL, 0x000fea0003800000ULL, 0x00000003ff167819ULL, 0x100fe2000001160dULL,
0x000000100e177824ULL, 0x000fe200078e00ffULL, 0x000000143d107217ULL, 0x000fe20007800000ULL,
0x00000080ff3e7424ULL, 0x000fe200078e00ffULL, 0x0000000416407810ULL, 0x040fe20007ffe0ffULL,
0x0000000117117824ULL, 0x000fe200078e0216ULL, 0x0000000c16427810ULL, 0x000fe20007ffe0ffULL,
0x0000000110107824ULL, 0x000fe400078e0a14ULL, 0x0000000111137824ULL, 0x040fe400078e020dULL,
0x00000008111c7824ULL, 0x000fe200078e00ffULL, 0x0000001017107217ULL, 0x000fe20007800000ULL,
0x000000100d147824ULL, 0x000fc400078e00ffULL, 0x0000000111117824ULL, 0x000fe200078e021eULL,
0xfffffff81c1d7812ULL, 0x000fe200078ee213ULL, 0x0000000110137824ULL, 0x000fe200078e0a17ULL,
0x00000070143f7812ULL, 0x000fe200078ec0ffULL, 0x0000000117157824ULL, 0x000fe400078e0240ULL,
0x00005e0011107625ULL, 0x000fe200078e003eULL, 0x000000134000720cULL, 0x080fe40003f06070ULL,
0x000000131600720cULL, 0x000fe20003fa6070ULL, 0x000000020b1c7824ULL, 0x000fe200078e0246ULL,
0x0000003f10147210ULL, 0x000fe20007fde0ffULL, 0x00000001151f7824ULL, 0x000fc400078e020dULL,
0x0000000815407824ULL, 0x040fe200078e00ffULL, 0x0000b0001c1c7811ULL, 0x000fe200078e60ffULL,
0x0000000115107824ULL, 0x000fe400078e021eULL, 0x000000ffff157224ULL, 0x000fe200030e0611ULL,
0xfffffff8401f7812ULL, 0x000fe200078ee21fULL, 0x00005e0010107625ULL, 0x000fe200078e003eULL,
0x0000000816407810ULL, 0x000fc60007ffe0ffULL, 0x000000101d1d7824ULL, 0x000fe200078e021cULL,
0x0000003f10167210ULL, 0x000fe20007fde0ffULL, 0x0000000117417824ULL, 0x000fe400078e0240ULL,
0x000000101f1f7824ULL, 0x000fe200078e021cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000141d7faeULL, 0x0007e2000e901c46ULL, 0x0000000141107824ULL, 0x000fe200078e021eULL,
0x000000134000720cULL, 0x080fe20003fa6070ULL, 0x0000000117407824ULL, 0x000fe400078e0242ULL,
0x000000ffff177224ULL, 0x000fe200030e0611ULL, 0x000000134200720cULL, 0x000fe20003fc6070ULL,
0x00005e0010107625ULL, 0x000fc600078e003eULL, 0x00000000161f7faeULL, 0x0009e2000c101c46ULL,
0x0000000140137824ULL, 0x000fe200078e021eULL, 0x0000003f10107210ULL, 0x000fe20007f1e0ffULL,
0x00000001411d7824ULL, 0x048fe400078e020dULL, 0x0000000841427824ULL, 0x000fe400078e00ffULL,
0x00005e0013147625ULL, 0x000fc600078e003eULL, 0xfffffff842137812ULL, 0x000fe200078ee21dULL,
0x00000001401e7824ULL, 0x040fe400078e020dULL, 0x0000000840417824ULL, 0x000fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000003f14147210ULL, 0x000fe20007f1e0ffULL,
0x0000001013137824ULL, 0x000fe200078e021cULL, 0xfffffff8411d7812ULL, 0x000fc600078ee21eULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x0000000010137faeULL, 0x0007e2000e901c46ULL,
0x000000101d177824ULL, 0x010fca00078e021cULL, 0x0000000014177faeULL, 0x0007e2000f101c46ULL,
0x0000031000007947ULL, 0x000fea0003800000ULL, 0x000000100e107824ULL, 0x000fe400078e00ffULL,
0x000000100d137824ULL, 0x040fe400078e00ffULL, 0x00000080ff1d7424ULL, 0x000fe200078e00ffULL,
0x000000100d117211ULL, 0x000fe400078fe8ffULL, 0x00000070133f7812ULL, 0x000fe200078ec0ffULL,
0x000000020b137824ULL, 0x000fe200078e0246ULL, 0x0000000411147810ULL, 0x040fe20007ffe0ffULL,
0x0000000111107824ULL, 0x040fe200078e020dULL, 0x0000000c113e7810ULL, 0x040fe20007ffe0ffULL,
0x00000008111f7824ULL, 0x000fc400078e00ffULL, 0x0000000114157824ULL, 0x040fe400078e020dULL,
0x0000000814167824ULL, 0x040fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee210ULL,
0x0000000111107824ULL, 0x140fe400078e021eULL, 0x0000000114147824ULL, 0x100fe200078e021eULL,
0xfffffff816417812ULL, 0x000fe200078ee215ULL, 0x000000013e1c7824ULL, 0x000fe200078e021eULL,
0x0000000811157810ULL, 0x000fe20007ffe0ffULL, 0x00005e0010107625ULL, 0x000fc800078e001dULL,
0x0000000115167824ULL, 0x040fe200078e021eULL, 0x0000003f10107210ULL, 0x000fe20007f1e0ffULL,
0x0000000115177824ULL, 0x140fe400078e020dULL, 0x00000008151e7824ULL, 0x000fe400078e00ffULL,
0x000000013e157824ULL, 0x040fe400078e020dULL, 0x000000083e3e7824ULL, 0x000fe200078e00ffULL,
0xfffffff81e437812ULL, 0x000fe200078ee217ULL, 0x00005e0016167625ULL, 0x000fe200078e001dULL,
0x0000b000131e7811ULL, 0x000fc400078e60ffULL, 0xfffffff83e477812ULL, 0x000fe200078ee215ULL,
0x00005e0014147625ULL, 0x000fe200078e001dULL, 0x0000003f16167210ULL, 0x000fc60007fbe0ffULL,
0x00005e001c1c7625ULL, 0x000fc800078e001dULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000003f14147210ULL, 0x080fe20007f1e0ffULL, 0x000000101f137824ULL, 0x100fe200078e021eULL,
0x0000003f1c1c7210ULL, 0x000fe20007fde0ffULL, 0x00000010411f7824ULL, 0x100fe400078e021eULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0007e2000b901c46ULL, 0x00000010433f7824ULL, 0x100fe400078e021eULL,
0x000000ffff177224ULL, 0x000fe200028e0617ULL, 0x00000000141f7faeULL, 0x0007e2000b901c46ULL,
0x0000001047417824ULL, 0x000fc400078e021eULL, 0x000000ffff1d7224ULL, 0x000fe200030e061dULL,
0x00000000163f7faeULL, 0x0007e8000b901c46ULL, 0x000000001c417faeULL, 0x0007e4000b901c46ULL,
0xfffffff00c117812ULL, 0x048fe200078ec0ffULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0xffffffe00c137812ULL, 0x040fe400078ec0ffULL, 0x000000100c107812ULL, 0x000fe200078ec0ffULL,
0x00000008467a7824ULL, 0x000fe200078e0211ULL, 0x000000000000781cULL, 0x000fc60003f0f070ULL,
0x0000000113117824ULL, 0x000fe200078e0210ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000f6a87a557810ULL, 0x000fe40007ffe0ffULL, 0x000000080e117824ULL, 0x000fcc00078e0211ULL,
0x00000000550403c2ULL, 0x000ee40000060000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00b9b0ULL, 0x008fe20008000a04ULL,
0x000000000000081cULL, 0x000fe20001f0f070ULL, 0xffffff8000003947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a8007a7a7f8cULL, 0x000ee2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6080011167f8cULL, 0x0002e4000c80043fULL,
0x0000000000107805ULL, 0x002fc40000015200ULL, 0x0000001008147812ULL, 0x000fca00078ec0ffULL,
0x0000000113137824ULL, 0x000fc800078e0214ULL, 0x000000080e137824ULL, 0x000fca00078e0213ULL,
0x00f60c0013157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x00afe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x00000014101d7210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001d00780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401d00780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001d14147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60c0013157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100d107824ULL, 0x000fe200078e00ffULL, 0x00000001ff4a7819ULL, 0x000fe2000001160dULL,
0x000000203c4b7824ULL, 0x000fe400078e00ffULL, 0xffffffffff477424ULL, 0x000fe200078e00ffULL,
0x00000070101d7812ULL, 0x000fc400078ec0ffULL, 0xffffff804b4b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c4a4a7812ULL, 0x000fc800078ec0ffULL, 0x0000004b4a107210ULL, 0x000fca0007ffe01dULL,
0x00f0000010137984ULL, 0x000e680000000800ULL, 0x00f2000010147984ULL, 0x0006a20000000800ULL,
0x000000581300720bULL, 0x002fe20003f1d000ULL, 0x0000e3a27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000107806ULL, 0x008fc800000e0100ULL, 0x0000ffff101e7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff6a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff417224ULL, 0x000fc400078e0058ULL, 0x0000001fff497424ULL, 0x000fe400078e00ffULL,
0xffffffffff447424ULL, 0x000fca00078e00ffULL, 0x0000044000008947ULL, 0x000fea0003800000ULL,
0x00000002ff117819ULL, 0x000fe4000001163cULL, 0x000000581300720bULL, 0x000fe40003f14000ULL,
0x0000003c1100720cULL, 0x000fe20003fa5270ULL, 0x0000e3327f007947ULL, 0x000fd4000b800000ULL,
0x0000000000157806ULL, 0x000fc400000e0100ULL, 0x000000803c11d824ULL, 0x000fe200078e021dULL,
0x0000001358417209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe40003800000ULL,
0x000000014a10d824ULL, 0x000fe200078e0211ULL, 0x0000991015117816ULL, 0x000fc800000000ffULL,
0x00f400411000d388ULL, 0x0003e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x8000004158107221ULL, 0x002fe20000010000ULL,
0x000000ff15ff7812ULL, 0x000fe2000780c0ffULL, 0x0000017000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x00000010001d7308ULL, 0x0002ec0000000800ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x002fe2000001160dULL,
0x0000e2727f007947ULL, 0x000fea000b800000ULL, 0x00001f101d107589ULL, 0x0082e400000e0000ULL,
0x0000001020207220ULL, 0x088fe20000410000ULL, 0x0000001021217220ULL, 0x080fe20000410000ULL,
0x0000001024247220ULL, 0x080fe20000410000ULL, 0x0000001025257220ULL, 0x080fe20000410000ULL,
0x0000001028287220ULL, 0x080fe20000410000ULL, 0x0000001029297220ULL, 0x080fe20000410000ULL,
0x000000102c2c7220ULL, 0x080fe20000410000ULL, 0x000000102d2d7220ULL, 0x080fe20000410000ULL,
0x0000001030307220ULL, 0x080fe20000410000ULL, 0x0000001031317220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001038387220ULL, 0x080fe20000410000ULL, 0x0000001039397220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0015ff7812ULL, 0x000fe2000780c0ffULL,
0x0000001d07077220ULL, 0x008fd80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080d107811ULL, 0x002fe200078ff0ffULL, 0x0000e1527f007947ULL, 0x000fea000b800000ULL,
0x00001f101d107589ULL, 0x0002e400000e0000ULL, 0x0000001022227220ULL, 0x088fe20000410000ULL,
0x0000001023237220ULL, 0x080fe20000410000ULL, 0x0000001026267220ULL, 0x080fe20000410000ULL,
0x0000001027277220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000102e2e7220ULL, 0x080fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x000000103a3a7220ULL, 0x080fe20000410000ULL,
0x000000103b3b7220ULL, 0x080fe20000410000ULL, 0x000000101a1a7220ULL, 0x080fe20000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff1eff7812ULL, 0x000fda0007806015ULL, 0x8000004113130221ULL, 0x000fe20000010000ULL,
0x00007610ff6a0816ULL, 0x000fc6000000006aULL, 0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL,
0x0000001300020308ULL, 0x000e640000000800ULL, 0x0000000214140220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000714077221ULL, 0x004fc20000010000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x0000000812177824ULL, 0x000fca00078e0208ULL,
0x00f6ac0017147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fe4000780485bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410147210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011415ULL,
0x0000001413137211ULL, 0x000fca00078110ffULL, 0x000000ffff147224ULL, 0x000fca00000e0615ULL,
0x0000000213137819ULL, 0x000fc80000001214ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0017147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe4000780485bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099106a107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000002ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff147819ULL, 0x000fe4000001160dULL,
0x0000541000137816ULL, 0x000fe20000000000ULL, 0x0000dd427f007947ULL, 0x000fea000b800000ULL,
0x00001f1413037589ULL, 0x0002a400000e0000ULL, 0x0000000814007810ULL, 0x000fe20007ffe0ffULL,
0x0000dd727f007947ULL, 0x000fea000b800000ULL, 0x00001f0013007589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001014107810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x000026d0001c7802ULL, 0x000fc40000000f00ULL,
0x0000e7c000007944ULL, 0x00efea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001814107810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0013ULL,
0x00002720001c7802ULL, 0x000fc40000000f00ULL, 0x0000e77000007944ULL, 0x00afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000070d107812ULL, 0x000fe200078ec0ffULL,
0x000002003c3e7824ULL, 0x000fe200078e00ffULL, 0x00000004ff567819ULL, 0x100fe2000001160dULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000810817812ULL, 0x000fc400078ef80dULL,
0xfffff8003e3e7812ULL, 0x000fe200078ec0ffULL, 0x000000040b107824ULL, 0x000fc800078e0256ULL,
0x00000001815f7824ULL, 0x040fe400078e0210ULL, 0x0000000881107824ULL, 0x000fca00078e00ffULL,
0xfffffff8103f7812ULL, 0x000fe400078ee25fULL, 0x000000080d107812ULL, 0x000fc600078ec0ffULL,
0x000000103f3f7824ULL, 0x000fc400078e023eULL, 0x0000000710597812ULL, 0x000fe200078ef80dULL,
0x000000040e567824ULL, 0x000fe400078e0256ULL, 0x000000020b4f7824ULL, 0x000fe400078e0212ULL,
0x0000000159107824ULL, 0x040fe400078e0256ULL, 0x0000000859117824ULL, 0x000fe200078e00ffULL,
0x0000b0004f4f7811ULL, 0x000fe400078e60ffULL, 0x0000000210517810ULL, 0x000fc40007ffe0ffULL,
0xfffffff811127812ULL, 0x000fca00078ee210ULL, 0x0000001012127824ULL, 0x000fca00078e024fULL,
0x000000001214783bULL, 0x0062a40000004200ULL, 0x0000000859127824ULL, 0x002fca00078e00ffULL,
0xfffffff812517812ULL, 0x000fca00078ee251ULL, 0x00000010511c7824ULL, 0x000fcc00078e024fULL,
0x000000001c1c783bULL, 0x000e620000004200ULL, 0x0000010014117824ULL, 0x044fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe20000011414ULL, 0x0000010015107824ULL, 0x000fe200078e00ffULL,
0x0000888014827816ULL, 0x040fe200000000ffULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0000010017407824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe20000011415ULL, 0x0000007e007e7306ULL, 0x000fe20000200c00ULL,
0x0000888015587816ULL, 0x000fc400000000ffULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff527819ULL, 0x000fe20000011416ULL,
0x0000001100857306ULL, 0x0005e20000200c00ULL, 0x00008880167d7816ULL, 0x000fe400000000ffULL,
0x00000018ff537819ULL, 0x000fe40000011417ULL, 0x0000888017687816ULL, 0x040fe200000000ffULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x00000014007f7306ULL, 0x0009e20000200c00ULL, 0x0001000015117824ULL, 0x004fe200078e00ffULL,
0x0000001059157812ULL, 0x000fc400078efcffULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x00000018ff807819ULL, 0x000fe20000011411ULL, 0x0000000815117824ULL, 0x040fe200078e00ffULL,
0x0000001000837306ULL, 0x0005e20000200c00ULL, 0x0000000156147824ULL, 0x010fe200078e0215ULL,
0x00000018ff727819ULL, 0x002fe2000001141cULL, 0x0000000815157824ULL, 0x000fe200078e00ffULL,
0x000088801c777816ULL, 0x000fe400000000ffULL, 0xfffffff8114e7812ULL, 0x000fe200078ee214ULL,
0x0000010016117824ULL, 0x040fe200078e00ffULL, 0x0000001700787306ULL, 0x0003e20000200c00ULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x0000000214507810ULL, 0x000fe20007ffe0ffULL,
0x000000104e107824ULL, 0x004fe200078e024fULL, 0x00000018ff7c7819ULL, 0x000fc40000011411ULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0xfffffff815507812ULL, 0x000fe200078ee250ULL,
0x000000001010783bULL, 0x008ea20000004200ULL, 0x0000001600697306ULL, 0x0007e20000200c00ULL,
0x000001001d177824ULL, 0x002fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fe4000001141dULL,
0x00000018ff667819ULL, 0x000fe4000001141eULL, 0x00000018ff177819ULL, 0x000fc40000011417ULL,
0x00000018ff647819ULL, 0x000fe2000001141fULL, 0x000001001c167824ULL, 0x048fe200078e00ffULL,
0x0000001700757306ULL, 0x0003e20000200c00ULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x000088801d747816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x000088801e6f7816ULL, 0x000fe400000000ffULL,
0x0000001600767306ULL, 0x0007e20000200c00ULL, 0x000001001f177824ULL, 0x042fe200078e00ffULL,
0x000088801f6c7816ULL, 0x040fe200000000ffULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x0000001c00737306ULL, 0x0003e20000200c00ULL, 0x000001001e167824ULL, 0x048fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x00000017006d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x00000010501c7824ULL, 0x002fc400078e024fULL, 0x0000010011147824ULL, 0x004fe200078e00ffULL,
0x0000888010617816ULL, 0x000fe200000000ffULL, 0x00000100135b7824ULL, 0x000fe400078e00ffULL,
0x00000016006e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff487819ULL, 0x000fe20000011411ULL,
0x00010000125d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff637819ULL, 0x000fe40000011414ULL,
0x0000888011607816ULL, 0x040fe200000000ffULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011413ULL, 0x0000001d00717306ULL, 0x000fe20000200c00ULL,
0x0000010010167824ULL, 0x002fe200078e00ffULL, 0x00008880134c7816ULL, 0x040fe200000000ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff117819ULL, 0x000fc40000011411ULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000001e006b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x00000018ff427819ULL, 0x000fe40000011412ULL,
0x0000888012547816ULL, 0x000fe400000000ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x0000001600627306ULL, 0x0003e20000200c00ULL, 0x00000018ff5d7819ULL, 0x000fce000001145dULL,
0x0000001f00677306ULL, 0x0005e20000200c00ULL, 0x009000003f14783bULL, 0x002e6e0000000200ULL,
0x0000004000797306ULL, 0x0007e20000200c00ULL, 0x000000001c1c783bULL, 0x004eae0000004200ULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x00000018ff407819ULL, 0x008fe20000011410ULL,
0x0001000010107824ULL, 0x000fca00078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000005800587306ULL, 0x000ff00000200c00ULL, 0x00000010004d7306ULL, 0x0007f00000200c00ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x0000010012107824ULL, 0x008fe200078e00ffULL,
0x0000000314148232ULL, 0x082fe20000000000ULL, 0x0000000881127824ULL, 0x000fe200078e00ffULL,
0x0000000316168232ULL, 0x000fc40000000000ULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000000015158232ULL, 0x080fe20000000000ULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x0000000017178232ULL, 0x000fe20000000000ULL, 0x00000018ff5c7819ULL, 0x004fe4000001141cULL,
0x00000018ff5a7819ULL, 0x000fe4000001141dULL, 0x00000018ff847819ULL, 0x000fe4000001141eULL,
0x0000005200527306ULL, 0x000e700000200c00ULL, 0x0000005300537306ULL, 0x000eb00000200c00ULL,
0x0000001100577306ULL, 0x0007e20000200c00ULL, 0x0000541069527816ULL, 0x002fce0000000052ULL,
0x00000010004f7306ULL, 0x0003e20000200c00ULL, 0x0000541058117816ULL, 0x008fe40000000083ULL,
0x0000541078537816ULL, 0x004fe20000000053ULL, 0x000001001d787824ULL, 0x000fc800078e00ffULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x0000541082107816ULL, 0x002fe20000000085ULL,
0x00000052142c723cULL, 0x000fe2000000182cULL, 0x00000018ff787819ULL, 0x000fca0000011478ULL,
0x0000007c007c7306ULL, 0x000e640000200c00ULL, 0x000000101420723cULL, 0x000b6c0000001820ULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x000054107f107816ULL, 0x020fe4000000007eULL,
0x0000541080117816ULL, 0x000fca0000000065ULL, 0x0000007700777306ULL, 0x000ee40000200c00ULL,
0x000000101424723cULL, 0x000b6c0000001824ULL, 0x0000007400747306ULL, 0x000f220000200c00ULL,
0x000054107d107816ULL, 0x022fe4000000007cULL, 0x0000541068117816ULL, 0x004fc40000000079ULL,
0x000088801d797816ULL, 0x000fc600000000ffULL, 0x00000013005e7306ULL, 0x0003e20000200c00ULL,
0x0000541077527816ULL, 0x008fe20000000076ULL, 0x000000101428723cULL, 0x000f6c0000001828ULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x000000025f137810ULL, 0x002fe40007ffe0ffULL,
0x0000541074537816ULL, 0x010fc40000000075ULL, 0xfffffff812137812ULL, 0x000fe400078ee213ULL,
0x000088801c127816ULL, 0x040fe200000000ffULL, 0x0000007000707306ULL, 0x000e620000200c00ULL,
0x00000018ff5f7819ULL, 0x000fe2000001141fULL, 0x00000010133e7824ULL, 0x000fe200078e023eULL,
0x000000521430723cULL, 0x000b620000001830ULL, 0x000000ffff657224ULL, 0x000fe400078e0012ULL,
0x000001001c127824ULL, 0x040fe400078e00ffULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x0000541073527816ULL, 0x024fc40000000072ULL,
0x00000018ff687819ULL, 0x000fe40000011412ULL, 0x009000003e10783bULL, 0x000ea20000000200ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000006c006c7306ULL, 0x000ee20000200c00ULL,
0x0000541071537816ULL, 0x002fe40000000070ULL, 0x000099106a727816ULL, 0x000fca00000000ffULL,
0x0000006600667306ULL, 0x000e620000200c00ULL, 0x000000521434723cULL, 0x000b620000001834ULL,
0x000000ffff707224ULL, 0x000fca00078e0072ULL, 0x000000ff7000720cULL, 0x000fe20003f05270ULL,
0x0000006400647306ULL, 0x000f220000200c00ULL, 0x000100001d527824ULL, 0x020fe200078e00ffULL,
0x000054106c1d7816ULL, 0x008fe4000000006dULL, 0x000088801e6c7816ULL, 0x000fe400000000ffULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x0000001c00537306ULL, 0x0007f00000200c00ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x000054106f1c7816ULL, 0x008fe2000000006eULL,
0x0000000310108232ULL, 0x004fcc0000000000ULL, 0x0000001c1438723cULL, 0x000b620000001838ULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x0000000312128232ULL, 0x000fe40000000000ULL,
0x0000000011118232ULL, 0x080fe40000000000ULL, 0x0000000013138232ULL, 0x000fe20000000000ULL,
0x000054106b1c7816ULL, 0x022fe40000000066ULL, 0x00005410671d7816ULL, 0x010fe20000000064ULL,
0x0000006300637306ULL, 0x000e620000200c00ULL, 0x000000ffff647224ULL, 0x000fca00078e006cULL,
0x0000001c1418723cULL, 0x000b640000001818ULL, 0x0000004000407306ULL, 0x000eaa0000200c00ULL,
0x000001001e147824ULL, 0x020fe200078e00ffULL, 0x000088801f1c7816ULL, 0x040fe200000000ffULL,
0x000001001f1d7824ULL, 0x040fe200078e00ffULL, 0x0000004800487306ULL, 0x000ee20000200c00ULL,
0x0000541060157816ULL, 0x002fe20000000063ULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fc4000001141dULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0000001400167306ULL, 0x0003e20000200c00ULL, 0x00000018ff1f7819ULL, 0x000fce000001141fULL,
0x0000005400547306ULL, 0x000f220000200c00ULL, 0x0000541061147816ULL, 0x002fce0000000062ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x000000141020723cULL, 0x000b6e0000001820ULL,
0x0000005b005b7306ULL, 0x000e620000200c00ULL, 0x000054104d147816ULL, 0x024fe40000000040ULL,
0x0000541057157816ULL, 0x008fe20000000048ULL, 0x000000023c487824ULL, 0x000fc800078e00ffULL,
0x0000004200427306ULL, 0x000fe40000200c00ULL, 0x000000141024723cULL, 0x000b6c0000001824ULL,
0x0000004300437306ULL, 0x000ea20000200c00ULL, 0x0000541054147816ULL, 0x030fe4000000004fULL,
0x000054104c157816ULL, 0x002fca000000005bULL, 0x0000005d005d7306ULL, 0x000e640000200c00ULL,
0x000000141028723cULL, 0x000b6c0000001828ULL, 0x0000006400177306ULL, 0x000ee20000200c00ULL,
0x000054105e437816ULL, 0x004fce0000000043ULL, 0x0000005c005c7306ULL, 0x000ea20000200c00ULL,
0x000054105d427816ULL, 0x002fce0000000042ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x0000541017167816ULL, 0x008fe20000000016ULL, 0x00000042102c723cULL, 0x000b6c000000182cULL,
0x0000008400587306ULL, 0x000fe20000200c00ULL, 0x00005410535c7816ULL, 0x004fce000000005cULL,
0x0000005f005f7306ULL, 0x000ff00000200c00ULL, 0x0000006500657306ULL, 0x000ff00000200c00ULL,
0x0000006800687306ULL, 0x000e700000200c00ULL, 0x0000007900697306ULL, 0x000ff00000200c00ULL,
0x00000078006a7306ULL, 0x000ea20000200c00ULL, 0x0000541065687816ULL, 0x002fce0000000068ULL,
0x00000052006d7306ULL, 0x000e700000200c00ULL, 0x0000001c001c7306ULL, 0x000fe20000200c00ULL,
0x0000541069697816ULL, 0x004fce000000006aULL, 0x0000001d001d7306ULL, 0x000ea20000200c00ULL,
0x000054106d5d7816ULL, 0x002fe2000000005aULL, 0x000000681030723cULL, 0x040b6c0000001830ULL,
0x0000001e00157306ULL, 0x020e640000200c00ULL, 0x0000005c1034723cULL, 0x000b6c0000001834ULL,
0x0000001f00147306ULL, 0x000ee20000200c00ULL, 0x000054101c177816ULL, 0x004fc4000000001dULL,
0x00005410155e7816ULL, 0x002fca0000000058ULL, 0x000000161038723cULL, 0x000b620000001838ULL,
0x00005410145f7816ULL, 0x008fce000000005fULL, 0x0000005e1018723cULL, 0x000b620000001818ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000004147f8cULL, 0x0002a2000c80043fULL,
0xfffffff848487812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004006107811ULL, 0x020fe200078e40ffULL, 0x00f6880048ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff587224ULL, 0x000fe400078e0041ULL, 0x0000003d1000720cULL, 0x000fe20003f06070ULL,
0x000000ffff5b7224ULL, 0x000fe400078e007bULL, 0x000000ffff127224ULL, 0x000fd400078e0046ULL,
0x000071e000000947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x008fc40000015200ULL,
0x0000040004127984ULL, 0x000ee40000000800ULL, 0x8000000012ff7812ULL, 0x00cfe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040004127984ULL, 0x000ea40000000800ULL,
0x8000000012ff7812ULL, 0x004fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000106107810ULL, 0x000fe40007ffe0ffULL, 0x0000008045127810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1000720cULL, 0x000fc60003f06070ULL, 0x0000620009137a24ULL, 0x000fd400078e0212ULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x00000003ff1d7819ULL, 0x000fe2000001160dULL,
0x000000100e1e7824ULL, 0x000fe200078e00ffULL, 0x000000123d107217ULL, 0x000fe20007800000ULL,
0x00000080ff1f7424ULL, 0x000fe200078e00ffULL, 0x000000041d157810ULL, 0x040fe20007ffe0ffULL,
0x000000011e167824ULL, 0x000fe200078e021dULL, 0x000000081d4d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000110117824ULL, 0x000fe200078e0a12ULL, 0x0000000c1d4f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000116147824ULL, 0x040fe400078e020dULL, 0x0000000816177824ULL, 0x000fe200078e00ffULL,
0x000000111e117217ULL, 0x000fe20007800000ULL, 0x0000100005107824ULL, 0x000fc400078e00ffULL,
0x000000100d127824ULL, 0x000fe200078e00ffULL, 0xfffffff817177812ULL, 0x000fe200078ee214ULL,
0x000000011e407824ULL, 0x000fe200078e0215ULL, 0x0000100010147812ULL, 0x000fe200078ec0ffULL,
0x0000000116107824ULL, 0x000fe200078e0213ULL, 0x0000007012127812ULL, 0x000fe200078ec0ffULL,
0x0000000111167824ULL, 0x000fe400078e0a1eULL, 0x000020000b147824ULL, 0x000fe400078e0214ULL,
0x00005e0010107625ULL, 0x000fe200078e001fULL, 0x000000161500720cULL, 0x000fc40003f06070ULL,
0x0000b000141c7810ULL, 0x000fe20007ffe0ffULL, 0x0000000140157824ULL, 0x040fe200078e020dULL,
0x000000161d00720cULL, 0x000fe20003fa6070ULL, 0x0000000840427824ULL, 0x000fe200078e00ffULL,
0x0000001210107210ULL, 0x000fe20007fde0ffULL, 0x0000000140147824ULL, 0x000fe400078e0213ULL,
0x000000011e407824ULL, 0x000fe200078e024dULL, 0xfffffff842437812ULL, 0x000fe200078ee215ULL,
0x00005e0014147625ULL, 0x000fc800078e001fULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x0000001214147210ULL, 0x000fe20007fde0ffULL, 0x0000001017177824ULL, 0x100fe400078e021cULL,
0x000000011e427824ULL, 0x000fe400078e024fULL, 0x00000001401e7824ULL, 0x000fe200078e0213ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000010177faeULL, 0x0005e2000e901c46ULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x000000164d00720cULL, 0x080fe20003fa6070ULL,
0x00000010431d7824ULL, 0x000fe200078e021cULL, 0x000000164f00720cULL, 0x000fe20003fc6070ULL,
0x0000000142167824ULL, 0x000fc400078e0213ULL, 0x0000000140137824ULL, 0x040fe200078e020dULL,
0x00000000141d7faeULL, 0x0007e2000c101c46ULL, 0x0000000840407824ULL, 0x000fe400078e00ffULL,
0x00005e001e107625ULL, 0x004fc600078e001fULL, 0xfffffff840137812ULL, 0x000fe200078ee213ULL,
0x00005e0016167625ULL, 0x000fe200078e001fULL, 0x0000001210107210ULL, 0x000fc60007f1e0ffULL,
0x00000001421e7824ULL, 0x040fe400078e020dULL, 0x00000008421f7824ULL, 0x000fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000001216167210ULL, 0x000fe20007f1e0ffULL,
0x0000001013137824ULL, 0x000fe200078e021cULL, 0xfffffff81f1f7812ULL, 0x000fc600078ee21eULL,
0x000000ffff177224ULL, 0x000fe200000e0617ULL, 0x0000000010137faeULL, 0x0005e2000e901c46ULL,
0x000000101f157824ULL, 0x008fca00078e021cULL, 0x0000000016157faeULL, 0x0005e2000f101c46ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x000000100e107824ULL, 0x000fe400078e00ffULL,
0x000000100d127824ULL, 0x040fe400078e00ffULL, 0x00000080ff1d7424ULL, 0x000fe200078e00ffULL,
0x000000100d147211ULL, 0x000fe400078fe8ffULL, 0x0000007012127812ULL, 0x000fe400078ec0ffULL,
0x00000004141c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000114107824ULL, 0x140fe200078e020dULL,
0x00000008141e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000814157824ULL, 0x040fe200078e00ffULL,
0x0000000c14407810ULL, 0x000fe20007ffe0ffULL, 0x000000011c117824ULL, 0x000fc400078e020dULL,
0x000000081c167824ULL, 0x000fe200078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee210ULL,
0x0000100005107824ULL, 0x000fe400078e00ffULL, 0x000000081e4c7824ULL, 0x000fe200078e00ffULL,
0xfffffff8161f7812ULL, 0x000fe200078ee211ULL, 0x0000000140427824ULL, 0x000fe200078e020dULL,
0x0000100010167812ULL, 0x000fe200078ec0ffULL, 0x0000000114107824ULL, 0x100fe400078e0213ULL,
0x000000011c147824ULL, 0x000fc400078e0213ULL, 0x000020000b177824ULL, 0x000fe400078e0216ULL,
0x000000011e167824ULL, 0x100fe400078e0213ULL, 0x00000001401c7824ULL, 0x000fe400078e0213ULL,
0x000000011e137824ULL, 0x000fe200078e020dULL, 0x0000b000171e7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0010107625ULL, 0x000fc600078e001dULL, 0xfffffff84c437812ULL, 0x000fe200078ee213ULL,
0x0000001015137824ULL, 0x000fe200078e021eULL, 0x0000001210107210ULL, 0x000fe20007f1e0ffULL,
0x00005e0014147625ULL, 0x000fc800078e001dULL, 0x00005e0016167625ULL, 0x000fc800078e001dULL,
0x00000008404d7824ULL, 0x000fe200078e00ffULL, 0x0000001216167210ULL, 0x000fe20007fbe0ffULL,
0x00005e001c1c7625ULL, 0x000fc600078e001dULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee242ULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000001214147210ULL, 0x080fe20007f1e0ffULL,
0x000000101f1f7824ULL, 0x100fe200078e021eULL, 0x000000121c1c7210ULL, 0x000fe20007fde0ffULL,
0x0000001043437824ULL, 0x100fe200078e021eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0005e2000b901c46ULL, 0x000000ffff157224ULL, 0x000fe400000e0615ULL,
0x000000ffff177224ULL, 0x000fe400028e0617ULL, 0x000000104d4d7824ULL, 0x000fe200078e021eULL,
0x00000000141f7faeULL, 0x0005e2000b901c46ULL, 0x000000ffff1d7224ULL, 0x000fc600030e061dULL,
0x0000000016437faeULL, 0x0005e8000b901c46ULL, 0x000000001c4d7faeULL, 0x0005e4000b901c46ULL,
0x0000000805107824ULL, 0x004fe200078e00ffULL, 0xfffffff00c117812ULL, 0x040fe200078ec0ffULL,
0x0000012000007945ULL, 0x000fe20003800000ULL, 0xffffffe00c137812ULL, 0x000fe400078ec0ffULL,
0x0000000810107812ULL, 0x000fe400078ec0ffULL, 0x000000000000781cULL, 0x000fc60003f0f070ULL,
0x0000000111547824ULL, 0x000fe200078e0210ULL, 0x000000100c107812ULL, 0x000fc800078ec0ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000113117824ULL, 0x000fe200078e0210ULL,
0x0000f6a854537810ULL, 0x000fc60007ffe0ffULL, 0x000000080e117824ULL, 0x000fc400078e0211ULL,
0x00000000530403c2ULL, 0x000ea40000040000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff00a9b0ULL, 0x004fe20008000a04ULL,
0x000000000000081cULL, 0x000fe2000170f070ULL, 0xffffff8000002947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a800545a7f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6280011107f8cULL, 0x000e64000c80043fULL,
0x0000000000147805ULL, 0x000fc40000015200ULL, 0x0000001008167812ULL, 0x000fca00078ec0ffULL,
0x0000000113137824ULL, 0x000fc800078e0216ULL, 0x000000080e1c7824ULL, 0x000fca00078e0213ULL,
0x00f62c001c137984ULL, 0x000f240000000800ULL, 0x8000000013ff7812ULL, 0x012fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614167210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011417ULL,
0x0000001613137211ULL, 0x000fca00078110ffULL, 0x000000ffff167224ULL, 0x000fca00000e0617ULL,
0x0000000213137819ULL, 0x000fc80000001216ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011d1d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f62c001c137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000008012117810ULL, 0x000fca0007ffe04bULL, 0x000000014a117824ULL, 0x000fca00078e0211ULL,
0x00f0000011147984ULL, 0x000e680000000800ULL, 0x00f2000011137984ULL, 0x0004e20000000800ULL,
0x000000411400720bULL, 0x002fe20003f1d000ULL, 0x0000bd027f007947ULL, 0x000fd8000b800000ULL,
0x0000000000157806ULL, 0x004fc800000e0100ULL, 0x0000ffff15ff7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000ffff587224ULL, 0x000fd200078e0041ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000013c117811ULL, 0x000fe400078ff0ffULL, 0x000000411400720bULL, 0x000fe40003f14000ULL,
0x0000003c1100720cULL, 0x000fe20003fa5270ULL, 0x0000bcb27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000167806ULL, 0x000fc400000e0100ULL, 0x000000803c11d824ULL, 0x000fe200078e0212ULL,
0x000000411410d209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x000000014a17d824ULL, 0x000fe200078e0211ULL, 0x0000991016117816ULL, 0x000fc800000000ffULL,
0x00f400101700d388ULL, 0x0003e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000004114107209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff16ff7812ULL, 0x000fc6000780c0ffULL,
0x0000004110107221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000127308ULL, 0x000e640000000800ULL, 0x0000001207077220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe2000001160dULL,
0x0000bbc27f007947ULL, 0x000fea000b800000ULL, 0x00001f1012107589ULL, 0x0002a400000e0000ULL,
0x0000001020207220ULL, 0x084fe20000410000ULL, 0x0000001021217220ULL, 0x080fe20000410000ULL,
0x0000001024247220ULL, 0x080fe20000410000ULL, 0x0000001025257220ULL, 0x080fe20000410000ULL,
0x0000001028287220ULL, 0x080fe20000410000ULL, 0x0000001029297220ULL, 0x080fe20000410000ULL,
0x000000102c2c7220ULL, 0x080fe20000410000ULL, 0x000000102d2d7220ULL, 0x080fe20000410000ULL,
0x0000001030307220ULL, 0x080fe20000410000ULL, 0x0000001031317220ULL, 0x080fe20000410000ULL,
0x0000001034347220ULL, 0x080fe20000410000ULL, 0x0000001035357220ULL, 0x080fe20000410000ULL,
0x0000001038387220ULL, 0x080fe20000410000ULL, 0x0000001039397220ULL, 0x080fe20000410000ULL,
0x0000001018187220ULL, 0x080fe20000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d107811ULL, 0x000fe200078ff0ffULL,
0x0000bab27f007947ULL, 0x000fea000b800000ULL, 0x00001f1012107589ULL, 0x00046400000e0000ULL,
0x0000001022227220ULL, 0x082fe20000410000ULL, 0x0000001023237220ULL, 0x080fe20000410000ULL,
0x0000001026267220ULL, 0x080fe20000410000ULL, 0x0000001027277220ULL, 0x080fe20000410000ULL,
0x000000102a2a7220ULL, 0x080fe20000410000ULL, 0x000000102b2b7220ULL, 0x080fe20000410000ULL,
0x000000102e2e7220ULL, 0x080fe20000410000ULL, 0x000000102f2f7220ULL, 0x080fe20000410000ULL,
0x0000001032327220ULL, 0x080fe20000410000ULL, 0x0000001033337220ULL, 0x080fe20000410000ULL,
0x0000001036367220ULL, 0x080fe20000410000ULL, 0x0000001037377220ULL, 0x080fe20000410000ULL,
0x000000103a3a7220ULL, 0x080fe20000410000ULL, 0x000000103b3b7220ULL, 0x080fe20000410000ULL,
0x000000101a1a7220ULL, 0x080fe20000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff16ff7812ULL, 0x000fe20007800815ULL,
0x00000001ff167424ULL, 0x000fe200078e00ffULL, 0x0000004114587209ULL, 0x000fd60007810000ULL,
0x8000005814140221ULL, 0x000fe20000010000ULL, 0x00007610ff160816ULL, 0x000fc60000000016ULL,
0x3fb8aa3b14140820ULL, 0x000fc80000410000ULL, 0x0000001400020308ULL, 0x000e640000000800ULL,
0x0000000213130220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000713077221ULL, 0x008fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x0000000846577824ULL, 0x000fc800078e00ffULL, 0x0000000108127824ULL, 0x004fca00078e0257ULL,
0x00f6ac0012137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780487bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000021000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001e000000947ULL, 0x000fea0003800000ULL,
0x000001d000017945ULL, 0x000fe20003800000ULL, 0x0000000108177824ULL, 0x000fc400078e0257ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6ac0017137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780487bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991016107816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000002ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff137819ULL, 0x000fe4000001160dULL, 0x0000541000127816ULL, 0x000fe20000000000ULL,
0x0000b6427f007947ULL, 0x000fea000b800000ULL, 0x00001f1312037589ULL, 0x0002a400000e0000ULL,
0x0000000813107810ULL, 0x000fe20007ffe0ffULL, 0x0000b6727f007947ULL, 0x000fea000b800000ULL,
0x00001f1012007589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001013107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x00004fc0001c7802ULL, 0x000fc40000000f00ULL, 0x0000bed000007944ULL, 0x006fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001813107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x004fe200078e0012ULL, 0x00005010001c7802ULL, 0x000fc40000000f00ULL,
0x0000be8000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000159107824ULL, 0x048fe200078e0256ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000859117824ULL, 0x000fc400078e00ffULL, 0x000000020b5d7824ULL, 0x000fc600078e0246ULL,
0xfffffff811107812ULL, 0x000fe400078ee210ULL, 0x0000b0005d5d7811ULL, 0x000fca00078e60ffULL,
0x0000001010527824ULL, 0x100fe400078e025dULL, 0x00000010514f7824ULL, 0x100fe400078e025dULL,
0x000000104e4d7824ULL, 0x100fe200078e025dULL, 0x00000000521c783bULL, 0x000ee20000004200ULL,
0x00000010504c7824ULL, 0x000fc600078e025dULL, 0x000000004f40783bULL, 0x000fe80000004200ULL,
0x000000004d10783bULL, 0x002e680000004200ULL, 0x000000004c14783bULL, 0x004ea20000004200ULL,
0x00000018ff877819ULL, 0x008fe2000001141cULL, 0x000001001c657824ULL, 0x040fe200078e00ffULL,
0x000088801c8a7816ULL, 0x040fe200000000ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe2000001141dULL, 0x000001001d667824ULL, 0x040fe200078e00ffULL,
0x000088801d697816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000008a008a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x00000100106f7824ULL, 0x042fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x00010000106a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe2000001141eULL, 0x0000010011707824ULL, 0x040fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe2000001141fULL, 0x0000001c00887306ULL, 0x0003e20000200c00ULL,
0x000088801e867816ULL, 0x000fe200000000ffULL, 0x00010000116b7824ULL, 0x000fe200078e00ffULL,
0x000088801f717816ULL, 0x000fc400000000ffULL, 0x00000018ff667819ULL, 0x000fe40000011466ULL,
0x00000018ff637819ULL, 0x000fe20000011410ULL, 0x0000001d00897306ULL, 0x0007e20000200c00ULL,
0x000001001e1c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff627819ULL, 0x000fe20000011411ULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x0000888040807816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000065008b7306ULL, 0x0003220000200c00ULL,
0x00000100411d7824ULL, 0x008fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fc4000001141eULL,
0x0000888041777816ULL, 0x000fe400000000ffULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c00857306ULL, 0x0007e20000200c00ULL, 0x000001001f657824ULL, 0x042fe200078e00ffULL,
0x00008880106e7816ULL, 0x000fe200000000ffULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00008880116d7816ULL, 0x000fe400000000ffULL, 0x00000018ff657819ULL, 0x000fc40000011465ULL,
0x0000001d007e7306ULL, 0x0003e20000200c00ULL, 0x00000100401c7824ULL, 0x008fe200078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x000054108a107816ULL, 0x010fe4000000008bULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000001e00827306ULL, 0x000fe20000200c00ULL,
0x00000100431d7824ULL, 0x002fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fc40000011442ULL,
0x00000018ff647819ULL, 0x000fe40000011443ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000001c007f7306ULL, 0x0003e20000200c00ULL, 0x00008880427a7816ULL, 0x000fe400000000ffULL,
0x0000888043757816ULL, 0x040fe200000000ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe20000011440ULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011441ULL, 0x0000001f00837306ULL, 0x000fe20000200c00ULL,
0x00000100421c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x0000001d00787306ULL, 0x000fe20000200c00ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000018ff617819ULL, 0x000fe40000011412ULL,
0x0000888012687816ULL, 0x000fe200000000ffULL, 0x0000001c00797306ULL, 0x0003e20000200c00ULL,
0x00000018ff607819ULL, 0x000fe40000011413ULL, 0x00000018ff5f7819ULL, 0x004fc40000011414ULL,
0x00000018ff5e7819ULL, 0x000fe40000011415ULL, 0x00000018ff6f7819ULL, 0x000fe2000001146fULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x009800003f1c783bULL, 0x002e620000000200ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x00000018ff6a7819ULL, 0x000fe4000001146aULL,
0x00000018ff6b7819ULL, 0x000fe4000001146bULL, 0x00000066008c7306ULL, 0x0004e20000200c00ULL,
0x00000018ff5c7819ULL, 0x000fc40000011416ULL, 0x00000018ff5a7819ULL, 0x000fca0000011417ULL,
0x0000008700877306ULL, 0x000f220000200c00ULL, 0x0001000012667824ULL, 0x004fca00078e00ffULL,
0x00000018ff667819ULL, 0x000fe40000011466ULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x0000541069117816ULL, 0x008fce000000008cULL, 0x0000008100817306ULL, 0x000ff00000200c00ULL,
0x0000007200727306ULL, 0x000fe20000200c00ULL, 0x000000031c1c8232ULL, 0x082fe40000000000ULL,
0x000000031e1e8232ULL, 0x000fc40000000000ULL, 0x000000001d1d8232ULL, 0x080fe40000000000ULL,
0x000000001f1f8232ULL, 0x000fe20000000000ULL, 0x0000008600867306ULL, 0x000e6c0000200c00ULL,
0x000000101c20723cULL, 0x000b640000001820ULL, 0x0000007100717306ULL, 0x000fea0000200c00ULL,
0x0000541088107816ULL, 0x030fc40000000087ULL, 0x0000541089117816ULL, 0x004fe2000000006cULL,
0x0000006500847306ULL, 0x0004ec0000200c00ULL, 0x000000101c24723cULL, 0x000b640000001824ULL,
0x0000008000807306ULL, 0x000f220000200c00ULL, 0x0000010012657824ULL, 0x004fe200078e00ffULL,
0x0000888014127816ULL, 0x000fc600000000ffULL, 0x0000541086107816ULL, 0x022fe40000000085ULL,
0x000000ffff6c7224ULL, 0x000fe200078e0012ULL, 0x0000007700777306ULL, 0x000e620000200c00ULL,
0x0000541071117816ULL, 0x008fe20000000084ULL, 0x0000010014127824ULL, 0x040fe200078e00ffULL,
0x0000888015847816ULL, 0x000fe200000000ffULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x00000018ff717819ULL, 0x000fe20000011412ULL,
0x0000004200747306ULL, 0x0005e20000200c00ULL, 0x000000101c28723cULL, 0x000f620000001828ULL,
0x00000018ff147819ULL, 0x000fcc0000011414ULL, 0x0000004300737306ULL, 0x0007e20000200c00ULL,
0x0000888013427816ULL, 0x004fce00000000ffULL, 0x00000040007c7306ULL, 0x0005e20000200c00ULL,
0x0000010013437824ULL, 0x048fe400078e00ffULL, 0x0001000013137824ULL, 0x000fc600078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x00000041007d7306ULL, 0x0007e20000200c00ULL,
0x0000541082407816ULL, 0x004fe20000000081ULL, 0x0000010015817824ULL, 0x000fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fca0000011413ULL, 0x0000007b007b7306ULL, 0x000ea20000200c00ULL,
0x0000541083417816ULL, 0x008fce0000000072ULL, 0x0000007600767306ULL, 0x000ee20000200c00ULL,
0x000000401c2c723cULL, 0x000b6e000000182cULL, 0x0000541080407816ULL, 0x030fe2000000007fULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x0000541077417816ULL, 0x002fc4000000007eULL,
0x00000018ff777819ULL, 0x000fca0000011481ULL, 0x0000007500757306ULL, 0x000e620000200c00ULL,
0x000000401c30723cULL, 0x000b6e0000001830ULL, 0x0000001300697306ULL, 0x0009e20000200c00ULL,
0x000054107c407816ULL, 0x024fe4000000007bULL, 0x000054107d417816ULL, 0x008fca0000000076ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x009800003e10783bULL, 0x010ee20000000200ULL,
0x000000401c34723cULL, 0x000b6c0000001834ULL, 0x0000006400647306ULL, 0x000f220000200c00ULL,
0x0001000015417824ULL, 0x020fe200078e00ffULL, 0x0000541075157816ULL, 0x002fc40000000078ULL,
0x0000888016757816ULL, 0x000fe400000000ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000001400407306ULL, 0x0003f00000200c00ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x000054107a147816ULL, 0x002fce0000000079ULL, 0x000000141c38723cULL, 0x000b620000001838ULL,
0x0000006f006f7306ULL, 0x000fec0000200c00ULL, 0x0000541074147816ULL, 0x024fe40000000067ULL,
0x0000541073157816ULL, 0x010fe20000000064ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x0000000310108232ULL, 0x088fe20000000000ULL, 0x000000ffff647224ULL, 0x000fe200078e0075ULL,
0x0000000312128232ULL, 0x000fc40000000000ULL, 0x0000000011118232ULL, 0x080fe20000000000ULL,
0x000000141c18723cULL, 0x000b620000001818ULL, 0x0000000013138232ULL, 0x000fe20000000000ULL,
0x0000007000707306ULL, 0x000e6a0000200c00ULL, 0x0000010016147824ULL, 0x060fe200078e00ffULL,
0x00008880171e7816ULL, 0x040fe200000000ffULL, 0x00000100171f7824ULL, 0x000fe200078e00ffULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fc40000011414ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x000054106d157816ULL, 0x002fce0000000070ULL, 0x0000006a006a7306ULL, 0x000e700000200c00ULL,
0x0000006b006b7306ULL, 0x000eb00000200c00ULL, 0x00000014001c7306ULL, 0x0007f00000200c00ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000054106e147816ULL, 0x008fce000000006fULL,
0x0000006500657306ULL, 0x000ee20000200c00ULL, 0x000000141020723cULL, 0x000b6e0000001820ULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x000054106a147816ULL, 0x022fe40000000063ULL,
0x000054106b157816ULL, 0x004fca0000000062ULL, 0x0000004300437306ULL, 0x000e640000200c00ULL,
0x000000141024723cULL, 0x000b6c0000001824ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x0000541068147816ULL, 0x028fce0000000065ULL, 0x0000006000607306ULL, 0x000ea20000200c00ULL,
0x0000541042157816ULL, 0x002fce0000000043ULL, 0x0000006600667306ULL, 0x000e620000200c00ULL,
0x000000141028723cULL, 0x000b6e0000001828ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x0001000017147824ULL, 0x020fe200078e00ffULL, 0x0000541069157816ULL, 0x004fc80000000060ULL,
0x00000018ff427819ULL, 0x000fe40000011414ULL, 0x0000007100717306ULL, 0x000ea20000200c00ULL,
0x0000541066147816ULL, 0x002fce0000000061ULL, 0x0000008400727306ULL, 0x000fe20000200c00ULL,
0x00000014102c723cULL, 0x000b6e000000182cULL, 0x0000007700777306ULL, 0x000e620000200c00ULL,
0x000054106c147816ULL, 0x024fce0000000071ULL, 0x0000005f005f7306ULL, 0x000eb00000200c00ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x0000541072157816ULL, 0x002fce0000000077ULL,
0x0000004100417306ULL, 0x000e620000200c00ULL, 0x000000141030723cULL, 0x000b6e0000001830ULL,
0x00000064001d7306ULL, 0x000ee20000200c00ULL, 0x0000541040147816ULL, 0x024fce000000005fULL,
0x0000001e001e7306ULL, 0x000fe20000200c00ULL, 0x0000541041157816ULL, 0x002fce000000005eULL,
0x0000001f001f7306ULL, 0x000e620000200c00ULL, 0x000000141034723cULL, 0x000b6e0000001834ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x000054101d147816ULL, 0x028fce000000001cULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x000054101e157816ULL, 0x002fce000000001fULL,
0x0000001600177306ULL, 0x000e620000200c00ULL, 0x000000141038723cULL, 0x000b6e0000001838ULL,
0x0000004200437306ULL, 0x000ea20000200c00ULL, 0x0000541017147816ULL, 0x022fe4000000005cULL,
0x0000541043157816ULL, 0x004fce000000005aULL, 0x000000141018723cULL, 0x000b620000001818ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000004147f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008006107811ULL, 0x000fe200078e40ffULL, 0x00f6900048ff7f8cULL, 0x0007e2000c80043fULL,
0x0000000105127812ULL, 0x000fe400078ec0ffULL, 0x0000003d1000720cULL, 0x000fda0003f06070ULL,
0x00004b0000000947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x008fc40000015200ULL,
0x0000040004127984ULL, 0x000ee40000000800ULL, 0x8000000012ff7812ULL, 0x00cfe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040004127984ULL, 0x000ea40000000800ULL,
0x8000000012ff7812ULL, 0x004fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000106107810ULL, 0x000fe40007ffe0ffULL, 0x000000c045127810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1000720cULL, 0x000fc60003f06070ULL, 0x0000620009167a24ULL, 0x000fd400078e0212ULL,
0x000003c000008947ULL, 0x000fea0003800000ULL, 0x000000123d107217ULL, 0x000fe20007800000ULL,
0x000000100e157824ULL, 0x000fe200078e00ffULL, 0x00000003ff147819ULL, 0x100fe2000001160dULL,
0x000000100d1d7824ULL, 0x000fe400078e00ffULL, 0x0000000110107824ULL, 0x000fe200078e0a12ULL,
0x0000000414407810ULL, 0x000fe20007ffe0ffULL, 0x0000000115127824ULL, 0x000fe200078e0214ULL,
0x000000701d1d7812ULL, 0x000fe200078ec0ffULL, 0x00000080ff1c7424ULL, 0x000fe200078e00ffULL,
0x0000001015107217ULL, 0x000fe20007800000ULL, 0x0000000112137824ULL, 0x000fe200078e020dULL,
0x0000000c145a7810ULL, 0x000fe20007ffe0ffULL, 0x00000008121e7824ULL, 0x000fc400078e00ffULL,
0x0000000110177824ULL, 0x000fe400078e0a15ULL, 0x0000000112117824ULL, 0x000fe200078e0216ULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee213ULL, 0x0000000115127824ULL, 0x000fe200078e0240ULL,
0x000000174000720cULL, 0x080fe20003f06070ULL, 0x00005e0011107625ULL, 0x000fe200078e001cULL,
0x000000171400720cULL, 0x000fc60003fa6070ULL, 0x0000000112137824ULL, 0x000fe200078e020dULL,
0x0000001d10107210ULL, 0x000fe20007fde0ffULL, 0x0000000812407824ULL, 0x040fe400078e00ffULL,
0x0000000112127824ULL, 0x000fe400078e0216ULL, 0x000000101e1f7824ULL, 0x000fe200078e025dULL,
0xfffffff8401e7812ULL, 0x000fe200078ee213ULL, 0x00005e0012127625ULL, 0x000fe200078e001cULL,
0x0000000814407810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x0000001d12147210ULL, 0x000fe20007fde0ffULL, 0x0000000115427824ULL, 0x040fe400078e0240ULL,
0x000000101e417824ULL, 0x000fe200078e025dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101f7faeULL, 0x0005e2000e901c46ULL, 0x000000174000720cULL, 0x080fe20003fa6070ULL,
0x0000000142127824ULL, 0x000fe400078e0216ULL, 0x0000000115407824ULL, 0x000fe400078e025aULL,
0x000000ffff157224ULL, 0x000fe200030e0613ULL, 0x000000175a00720cULL, 0x000fe20003fc6070ULL,
0x0000000140137824ULL, 0x000fc400078e0216ULL, 0x0000000142167824ULL, 0x000fe200078e020dULL,
0x0000000014417faeULL, 0x0007e2000c101c46ULL, 0x00005e0012107625ULL, 0x004fc800078e001cULL,
0x00000008421f7824ULL, 0x000fe200078e00ffULL, 0x0000001d10107210ULL, 0x000fe20007f1e0ffULL,
0x00005e0013127625ULL, 0x000fc600078e001cULL, 0xfffffff81f167812ULL, 0x000fe200078ee216ULL,
0x0000000140177824ULL, 0x040fe400078e020dULL, 0x00000008401c7824ULL, 0x000fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000001d12127210ULL, 0x000fe20007f1e0ffULL,
0x0000001016157824ULL, 0x008fe200078e025dULL, 0xfffffff81c1c7812ULL, 0x000fc600078ee217ULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x0000000010157faeULL, 0x0005e2000e901c46ULL,
0x000000101c5d7824ULL, 0x000fca00078e025dULL, 0x00000000125d7faeULL, 0x0005e2000f101c46ULL,
0x000002f000007947ULL, 0x000fea0003800000ULL, 0x000000100e107824ULL, 0x000fe400078e00ffULL,
0x000000100d1d7824ULL, 0x040fe400078e00ffULL, 0x00000080ff157424ULL, 0x000fe200078e00ffULL,
0x000000100d117211ULL, 0x000fe400078fe8ffULL, 0x000000701d1d7812ULL, 0x000fe400078ec0ffULL,
0x00000008111e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000111107824ULL, 0x040fe200078e020dULL,
0x0000000c11407810ULL, 0x040fe20007ffe0ffULL, 0x0000000811137824ULL, 0x000fc400078e00ffULL,
0x000000011e1f7824ULL, 0x000fe400078e020dULL, 0x0000000140147824ULL, 0x000fe200078e0216ULL,
0xfffffff8131c7812ULL, 0x000fe200078ee210ULL, 0x0000000111107824ULL, 0x040fe200078e0216ULL,
0x0000000411137810ULL, 0x000fe20007ffe0ffULL, 0x000000081e5a7824ULL, 0x000fe400078e00ffULL,
0x00005e0010107625ULL, 0x000fc800078e0015ULL, 0x0000000113127824ULL, 0x140fe400078e0216ULL,
0x0000000113177824ULL, 0x140fe400078e020dULL, 0x0000000813427824ULL, 0x000fe400078e00ffULL,
0x000000011e137824ULL, 0x000fe200078e0216ULL, 0x0000001d10167210ULL, 0x000fe20007f1e0ffULL,
0x0000000140417824ULL, 0x000fe200078e020dULL, 0xfffffff8421e7812ULL, 0x000fe200078ee217ULL,
0x00000008405c7824ULL, 0x000fe200078e00ffULL, 0xfffffff85a407812ULL, 0x000fe200078ee21fULL,
0x000000ffff177224ULL, 0x000fc400000e0611ULL, 0x00005e0012107625ULL, 0x000fe200078e0015ULL,
0xfffffff85c427812ULL, 0x000fc600078ee241ULL, 0x00005e0013127625ULL, 0x000fe200078e0015ULL,
0x0000001d10107210ULL, 0x000fc60007f1e0ffULL, 0x00005e0014147625ULL, 0x000fe200078e0015ULL,
0x0000001d12127210ULL, 0x000fc60007fbe0ffULL, 0x000000101c1f7824ULL, 0x100fe200078e025dULL,
0x0000001d14147210ULL, 0x000fe20007fde0ffULL, 0x000000101e417824ULL, 0x000fe400078e025dULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000161f7faeULL, 0x0005e2000b901c46ULL, 0x0000001040437824ULL, 0x000fe400078e025dULL,
0x000000ffff137224ULL, 0x000fe200028e0613ULL, 0x0000000010417faeULL, 0x0005e2000b901c46ULL,
0x00000010425d7824ULL, 0x000fc400078e025dULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x0000000012437faeULL, 0x0005e8000b901c46ULL, 0x00000000145d7faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x004fe20000000000ULL, 0xfffffff00c117812ULL, 0x040fe200078ec0ffULL,
0x000000f000007945ULL, 0x000fe20003800000ULL, 0xffffffe00c137812ULL, 0x040fe400078ec0ffULL,
0x000000100c167812ULL, 0x000fe200078ec0ffULL, 0x0000000846117824ULL, 0x000fe200078e0211ULL,
0x000000080c107812ULL, 0x000fc400078ec0ffULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x0000001310167210ULL, 0x000fd60007ffe016ULL, 0x00000000550403c2ULL, 0x000ea40000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800117e7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6480016107f8cULL, 0x004464000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x00f64c0016157984ULL, 0x000f240000000800ULL, 0x8000000015ff7812ULL, 0x012fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001412177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001714147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f64c0016157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001001d117810ULL, 0x000fca0007ffe04bULL, 0x000000014a117824ULL, 0x000fca00078e0211ULL,
0x00f0000011137984ULL, 0x000e680000000800ULL, 0x00f2000011127984ULL, 0x0004e20000000800ULL,
0x000000581300720bULL, 0x002fe20003f1d000ULL, 0x000098e27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000147806ULL, 0x004fc800000e0100ULL, 0x0000ffff14ff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff6b7424ULL, 0x000fd600078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x000000023c117811ULL, 0x000fe400078ff0ffULL,
0x000000581300720bULL, 0x000fe40003f14000ULL, 0x0000003c1100720cULL, 0x000fe20003fa5270ULL,
0x000098a27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000157806ULL, 0x000fc400000e0100ULL,
0x000000803c1dd824ULL, 0x000fe200078e021dULL, 0x000000135810d209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991015117816ULL, 0x000fe200000000ffULL,
0x000000014a1dd824ULL, 0x000fc600078e021dULL, 0x000000ff1100720cULL, 0x000fe40003f05270ULL,
0x00f400101d00d388ULL, 0x0003f60000000800ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000001358117209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff15ff7812ULL, 0x000fc6000780c0ffULL, 0x8000001158107221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000167308ULL, 0x000e640000000800ULL,
0x0000001607077220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe2000001160dULL, 0x000097c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1016107589ULL, 0x0002a400000e0000ULL, 0x0000001020207220ULL, 0x084fe20000410000ULL,
0x0000001021217220ULL, 0x080fe20000410000ULL, 0x0000001024247220ULL, 0x080fe20000410000ULL,
0x0000001025257220ULL, 0x080fe20000410000ULL, 0x0000001028287220ULL, 0x080fe20000410000ULL,
0x0000001029297220ULL, 0x080fe20000410000ULL, 0x000000102c2c7220ULL, 0x080fe20000410000ULL,
0x000000102d2d7220ULL, 0x080fe20000410000ULL, 0x0000001030307220ULL, 0x080fe20000410000ULL,
0x0000001031317220ULL, 0x080fe20000410000ULL, 0x0000001034347220ULL, 0x080fe20000410000ULL,
0x0000001035357220ULL, 0x080fe20000410000ULL, 0x0000001038387220ULL, 0x080fe20000410000ULL,
0x0000001039397220ULL, 0x080fe20000410000ULL, 0x0000001018187220ULL, 0x080fe20000410000ULL,
0x0000001019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0015ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080d107811ULL, 0x000fe200078ff0ffULL, 0x000096b27f007947ULL, 0x000fea000b800000ULL,
0x00001f1016107589ULL, 0x00046400000e0000ULL, 0x0000001022227220ULL, 0x082fe20000410000ULL,
0x0000001023237220ULL, 0x080fe20000410000ULL, 0x0000001026267220ULL, 0x080fe20000410000ULL,
0x0000001027277220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000102e2e7220ULL, 0x080fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x000000103a3a7220ULL, 0x080fe20000410000ULL,
0x000000103b3b7220ULL, 0x080fe20000410000ULL, 0x000000101a1a7220ULL, 0x080fe20000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff15ff7812ULL, 0x000fe20007800814ULL, 0x00000001ff6b7424ULL, 0x000fe200078e00ffULL,
0x0000001358587209ULL, 0x000fd60007810000ULL, 0x8000005813130221ULL, 0x000fe20000010000ULL,
0x00007610ff6b0816ULL, 0x000fc6000000006bULL, 0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL,
0x0000001300020308ULL, 0x000e640000000800ULL, 0x0000000212120220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000712077221ULL, 0x008fc20000010000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x00f6ac0054127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe4000780485bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210157210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001512127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac0054127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe4000780485bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099106b107816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000002ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff137819ULL, 0x000fe4000001160dULL, 0x0000541000127816ULL, 0x000fe20000000000ULL,
0x000092927f007947ULL, 0x000fea000b800000ULL, 0x00001f1312037589ULL, 0x0002e400000e0000ULL,
0x0000000813107810ULL, 0x000fe20007ffe0ffULL, 0x000092c27f007947ULL, 0x000fea000b800000ULL,
0x00001f1012007589ULL, 0x0002a400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001013107810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x00007560001c7802ULL, 0x000fc40000000f00ULL, 0x0000993000007944ULL, 0x00cfea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001813107810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x004fe200078e0012ULL, 0x000075b0001c7802ULL, 0x000fc40000000f00ULL,
0x000098e000007944ULL, 0x008fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000100005107824ULL, 0x002fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000159567824ULL, 0x000fc400078e0256ULL, 0x0000000859597824ULL, 0x000fe200078e00ffULL,
0x0000100010107812ULL, 0x000fc800078ec0ffULL, 0xfffffff859147812ULL, 0x000fe200078ee256ULL,
0x000020000b107824ULL, 0x000fca00078e0210ULL, 0x0000b00010557810ULL, 0x000fca0007ffe0ffULL,
0x0000001014147824ULL, 0x100fe400078e0255ULL, 0x0000001051407824ULL, 0x100fe400078e0255ULL,
0x000000104e107824ULL, 0x100fe400078e0255ULL, 0x000000001414783bULL, 0x004e620000004200ULL,
0x00000010501c7824ULL, 0x000fc600078e0255ULL, 0x000000004040783bULL, 0x000fe80000004200ULL,
0x000000001010783bULL, 0x000ea80000004200ULL, 0x000000001c1c783bULL, 0x000f220000004200ULL,
0x00000018ff827819ULL, 0x002fe20000011414ULL, 0x00000100145e7824ULL, 0x040fe200078e00ffULL,
0x0000888014867816ULL, 0x040fe200000000ffULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011415ULL, 0x00000100155f7824ULL, 0x040fe200078e00ffULL,
0x0000888015647816ULL, 0x040fe200000000ffULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x0000008600867306ULL, 0x000fe20000200c00ULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0001000010637824ULL, 0x004fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0000010011687824ULL, 0x040fe200078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe20000011416ULL, 0x0001000011627824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe20000011417ULL, 0x0000001400857306ULL, 0x0003e20000200c00ULL,
0x0000888016837816ULL, 0x000fc400000000ffULL, 0x00008880176a7816ULL, 0x000fe400000000ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x00000018ff5c7819ULL, 0x000fe20000011410ULL,
0x0000001500847306ULL, 0x0005e20000200c00ULL, 0x0000010016147824ULL, 0x042fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe20000011411ULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00008880407a7816ULL, 0x000fe400000000ffULL, 0x00000018ff147819ULL, 0x000fc40000011414ULL,
0x0000005e00897306ULL, 0x0002e20000200c00ULL, 0x0000010041157824ULL, 0x044fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000888041777816ULL, 0x000fe400000000ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000001400807306ULL, 0x0005e20000200c00ULL,
0x00000100175e7824ULL, 0x042fe200078e00ffULL, 0x0000888010667816ULL, 0x000fe200000000ffULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x0000888011657816ULL, 0x000fc400000000ffULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x0000001500787306ULL, 0x0003e20000200c00ULL,
0x0000010040147824ULL, 0x004fe200078e00ffULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x00000018ff607819ULL, 0x000fe40000011442ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000016007c7306ULL, 0x000fe20000200c00ULL, 0x0000010043157824ULL, 0x002fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fc40000011443ULL, 0x0000888042747816ULL, 0x000fe400000000ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000001400797306ULL, 0x0003e20000200c00ULL,
0x00008880436f7816ULL, 0x040fe200000000ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff737819ULL, 0x000fe20000011440ULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011441ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x00000017007d7306ULL, 0x000fe20000200c00ULL,
0x0000010042147824ULL, 0x042fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fc40000011441ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000001500727306ULL, 0x000fe20000200c00ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff5a7819ULL, 0x000fe40000011412ULL,
0x0000888012617816ULL, 0x000fe400000000ffULL, 0x00000018ff597819ULL, 0x000fe20000011413ULL,
0x0000001400717306ULL, 0x0003e20000200c00ULL, 0x00000018ff567819ULL, 0x010fc4000001141cULL,
0x00000018ff517819ULL, 0x000fe4000001141dULL, 0x00000018ff687819ULL, 0x000fe40000011468ULL,
0x00000018ff637819ULL, 0x000fe20000011463ULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x0000010010147824ULL, 0x002fe200078e00ffULL, 0x0000541086107816ULL, 0x008fe40000000089ULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0x00000018ff677819ULL, 0x000fc40000011414ULL,
0x00a000003f14783bULL, 0x000e620000000200ULL, 0x0000005f00877306ULL, 0x0004e20000200c00ULL,
0x00000018ff507819ULL, 0x000fe4000001141eULL, 0x00000018ff4e7819ULL, 0x000fca000001141fULL,
0x0000008200827306ULL, 0x000f220000200c00ULL, 0x00010000125f7824ULL, 0x004fca00078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x0000541064117816ULL, 0x008fce0000000087ULL, 0x0000007b007b7306ULL, 0x000ff00000200c00ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x0000000314148232ULL, 0x002fce0000000000ULL,
0x0000008300837306ULL, 0x000e620000200c00ULL, 0x0000000316168232ULL, 0x000fe40000000000ULL,
0x0000000015158232ULL, 0x080fe40000000000ULL, 0x0000000017178232ULL, 0x000fc60000000000ULL,
0x0000006a006a7306ULL, 0x000fe80000200c00ULL, 0x000000101420723cULL, 0x000b680000001820ULL,
0x0000005e00817306ULL, 0x0006660000200c00ULL, 0x0000541085107816ULL, 0x030fc40000000082ULL,
0x0000541084117816ULL, 0x004fc60000000069ULL, 0x0000007a007a7306ULL, 0x000ea20000200c00ULL,
0x00000100125e7824ULL, 0x008fe200078e00ffULL, 0x000088801c127816ULL, 0x040fe400000000ffULL,
0x000000101424723cULL, 0x000b640000001824ULL, 0x00000018ff5e7819ULL, 0x000fe2000001145eULL,
0x000000ffff697224ULL, 0x000fe200078e0012ULL, 0x0000007700777306ULL, 0x000ee20000200c00ULL,
0x000001001c127824ULL, 0x040fe400078e00ffULL, 0x0000541083107816ULL, 0x022fe20000000080ULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x000054106a117816ULL, 0x000fc40000000081ULL,
0x00000018ff6a7819ULL, 0x000fe20000011412ULL, 0x00000042006d7306ULL, 0x0003e20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x000088801d807816ULL, 0x000fe200000000ffULL,
0x000000101428723cULL, 0x000f680000001828ULL, 0x00000043006e7306ULL, 0x0009e20000200c00ULL,
0x0000888013427816ULL, 0x002fce00000000ffULL, 0x0000004000767306ULL, 0x0003e20000200c00ULL,
0x0000010013437824ULL, 0x050fe400078e00ffULL, 0x0001000013137824ULL, 0x000fc600078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000004100757306ULL, 0x0009e20000200c00ULL,
0x000054107c407816ULL, 0x002fe2000000007bULL, 0x000001001d7b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fc80000011413ULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000007300737306ULL, 0x000e620000200c00ULL, 0x000054107d417816ULL, 0x010fce000000006cULL,
0x0000007000707306ULL, 0x000f220000200c00ULL, 0x00000040142c723cULL, 0x000b6e000000182cULL,
0x000054107a407816ULL, 0x024fe20000000079ULL, 0x0000007400747306ULL, 0x000fe20000200c00ULL,
0x0000541077417816ULL, 0x008fce0000000078ULL, 0x0000006f006f7306ULL, 0x000ea20000200c00ULL,
0x000000401430723cULL, 0x000b6e0000001830ULL, 0x0000001300647306ULL, 0x0007e20000200c00ULL,
0x0000541076407816ULL, 0x022fe40000000073ULL, 0x0000541075417816ULL, 0x010fc40000000070ULL,
0x000099106b737816ULL, 0x000fc600000000ffULL, 0x0000006000607306ULL, 0x000e620000200c00ULL,
0x00a000003e10783bULL, 0x008ee20000000200ULL, 0x000000401434723cULL, 0x000be20000001834ULL,
0x000000ffff707224ULL, 0x000fca00078e0073ULL, 0x0000005d005d7306ULL, 0x000f220000200c00ULL,
0x000100001d407824ULL, 0x020fe200078e00ffULL, 0x000054106f1d7816ULL, 0x004fe40000000072ULL,
0x000000ff7000720cULL, 0x000fe40003f05270ULL, 0x000088801e6f7816ULL, 0x000fe400000000ffULL,
0x0000001c00417306ULL, 0x0005e20000200c00ULL, 0x00000018ff407819ULL, 0x000fce0000011440ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x00005410741c7816ULL, 0x004fce0000000071ULL,
0x0000001c1438723cULL, 0x000b620000001838ULL, 0x0000006700677306ULL, 0x000fec0000200c00ULL,
0x000054106d1c7816ULL, 0x022fe40000000060ULL, 0x000054106e1d7816ULL, 0x010fe2000000005dULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x0000000310108232ULL, 0x088fe20000000000ULL,
0x000000ffff5d7224ULL, 0x000fe200078e006fULL, 0x0000000312128232ULL, 0x000fc40000000000ULL,
0x0000000011118232ULL, 0x080fe20000000000ULL, 0x0000001c1418723cULL, 0x000b620000001818ULL,
0x0000000013138232ULL, 0x000fe20000000000ULL, 0x0000006800687306ULL, 0x000e6a0000200c00ULL,
0x000001001e147824ULL, 0x060fe200078e00ffULL, 0x000088801f1c7816ULL, 0x040fe200000000ffULL,
0x000001001f1d7824ULL, 0x000fe200078e00ffULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fc40000011414ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff1e7819ULL, 0x000fe4000001141eULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x0000541065157816ULL, 0x002fce0000000068ULL,
0x0000006300637306ULL, 0x000e700000200c00ULL, 0x0000006200627306ULL, 0x000eb00000200c00ULL,
0x0000001400167306ULL, 0x0007f00000200c00ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x0000541066147816ULL, 0x008fce0000000067ULL, 0x0000005e005e7306ULL, 0x000ee20000200c00ULL,
0x000000141020723cULL, 0x000b6e0000001820ULL, 0x0000004200427306ULL, 0x000fe20000200c00ULL,
0x0000541063147816ULL, 0x022fe4000000005cULL, 0x0000541062157816ULL, 0x004fca000000005bULL,
0x0000004300437306ULL, 0x000e640000200c00ULL, 0x000000141024723cULL, 0x000b6c0000001824ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x0000541061147816ULL, 0x028fe4000000005eULL,
0x0000541042157816ULL, 0x002fca0000000043ULL, 0x0000004000407306ULL, 0x000e640000200c00ULL,
0x000000141028723cULL, 0x000b6c0000001828ULL, 0x0000005d00177306ULL, 0x000ea20000200c00ULL,
0x000100001f147824ULL, 0x020fce00078e00ffULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x0000541040157816ULL, 0x002fe40000000051ULL, 0x00000018ff147819ULL, 0x000fca0000011414ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x0000541017167816ULL, 0x004fce0000000016ULL,
0x0000005600567306ULL, 0x000ff00000200c00ULL, 0x0000005000507306ULL, 0x000fe20000200c00ULL,
0x00005410645b7816ULL, 0x002fce0000000059ULL, 0x0000004e004e7306ULL, 0x000ff00000200c00ULL,
0x0000005f005f7306ULL, 0x000e700000200c00ULL, 0x0000006900697306ULL, 0x000ff00000200c00ULL,
0x0000006a006a7306ULL, 0x000ea20000200c00ULL, 0x000054105f5a7816ULL, 0x002fce000000005aULL,
0x00000080006c7306ULL, 0x000fe20000200c00ULL, 0x0000005a102c723cULL, 0x000b6e000000182cULL,
0x0000007b006b7306ULL, 0x000e620000200c00ULL, 0x00005410696a7816ULL, 0x004fce000000006aULL,
0x0000001c001c7306ULL, 0x000ff00000200c00ULL, 0x0000001d001d7306ULL, 0x000ea20000200c00ULL,
0x000054106c6b7816ULL, 0x002fce000000006bULL, 0x0000001e001f7306ULL, 0x000e620000200c00ULL,
0x0000006a1030723cULL, 0x000b6e0000001830ULL, 0x0000001400437306ULL, 0x0007220000200c00ULL,
0x000054101c177816ULL, 0x004fe4000000001dULL, 0x000054101f507816ULL, 0x002fca0000000050ULL,
0x000000161038723cULL, 0x000b620000001838ULL, 0x0000541041147816ULL, 0x008fe40000000056ULL,
0x0000541043517816ULL, 0x010fca000000004eULL, 0x000000141034723cULL, 0x040b700000001834ULL,
0x000000501018723cULL, 0x000b620000001818ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000004147f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000c006107811ULL, 0x000fe200078e40ffULL,
0x00f6980048ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff127224ULL, 0x000fc400078e0046ULL,
0x0000003d1000720cULL, 0x000fe20003f06070ULL, 0x000000ffff5b7224ULL, 0x000fd800078e007fULL,
0x0000250000000947ULL, 0x000fea0003800000ULL, 0x0000000000107805ULL, 0x008fc40000015200ULL,
0x000000043c127824ULL, 0x000fca00078e00ffULL, 0xfffffff812147812ULL, 0x004fca00078ec0ffULL,
0x00f6cc0014127984ULL, 0x000ea40000000800ULL, 0x8000000012ff7812ULL, 0x004fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210177210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001712127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6cc0014127984ULL, 0x000ea40000000800ULL,
0x8000000012ff7812ULL, 0x004fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000206107810ULL, 0x000fe40007ffe0ffULL, 0x0000010045127810ULL, 0x000fe40007ffe0ffULL,
0x0000000f1000720cULL, 0x000fc60003f06070ULL, 0x00006200091c7a24ULL, 0x000fd400078e0212ULL,
0x000003c000008947ULL, 0x000fea0003800000ULL, 0x000000123d107217ULL, 0x000fe20007800000ULL,
0x000000100e1d7824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x100fe2000001160dULL,
0x000000100d117824ULL, 0x000fe400078e00ffULL, 0x0000000110107824ULL, 0x000fe200078e0a12ULL,
0x0000000416427810ULL, 0x000fe20007ffe0ffULL, 0x000000011d147824ULL, 0x000fe200078e0216ULL,
0x0000007011127812ULL, 0x000fe200078ec0ffULL, 0x00000080ff1e7424ULL, 0x000fe200078e00ffULL,
0x000000101d107217ULL, 0x000fe20007800000ULL, 0x0000000114157824ULL, 0x000fe200078e020dULL,
0x0000000c16467810ULL, 0x000fe20007ffe0ffULL, 0x0000000814407824ULL, 0x000fc400078e00ffULL,
0x0000000110137824ULL, 0x000fe400078e0a1dULL, 0x0000000114117824ULL, 0x000fe200078e021cULL,
0xfffffff840407812ULL, 0x000fe200078ee215ULL, 0x000000011d147824ULL, 0x000fe200078e0242ULL,
0x000000134200720cULL, 0x080fe20003f06070ULL, 0x00005e0011107625ULL, 0x000fe200078e001eULL,
0x000000131600720cULL, 0x000fc60003fa6070ULL, 0x0000000114157824ULL, 0x000fe200078e020dULL,
0x0000001210107210ULL, 0x000fe20007fde0ffULL, 0x0000000814427824ULL, 0x040fe400078e00ffULL,
0x0000000114147824ULL, 0x000fe400078e021cULL, 0x0000001040177824ULL, 0x000fe200078e0255ULL,
0xfffffff842407812ULL, 0x000fe200078ee215ULL, 0x00005e0014147625ULL, 0x000fe200078e001eULL,
0x0000000816427810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x0000001214147210ULL, 0x000fe20007fde0ffULL, 0x000000011d1f7824ULL, 0x040fe400078e0242ULL,
0x000000011d417824ULL, 0x000fe200078e0246ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010177faeULL, 0x0005e2000e901c46ULL, 0x000000011f167824ULL, 0x000fe200078e021cULL,
0x000000134200720cULL, 0x080fe20003fa6070ULL, 0x000000ffff157224ULL, 0x000fe200030e0615ULL,
0x000000134600720cULL, 0x000fe20003fc6070ULL, 0x00000010401d7824ULL, 0x000fc400078e0255ULL,
0x0000000141137824ULL, 0x000fe400078e021cULL, 0x000000011f1c7824ULL, 0x040fe200078e020dULL,
0x00000000141d7faeULL, 0x0007e2000c101c46ULL, 0x000000081f1f7824ULL, 0x000fe400078e00ffULL,
0x00005e0016107625ULL, 0x004fc600078e001eULL, 0xfffffff81f1c7812ULL, 0x000fe200078ee21cULL,
0x00005e0013167625ULL, 0x000fe200078e001eULL, 0x0000001210107210ULL, 0x000fc60007f1e0ffULL,
0x0000000141137824ULL, 0x040fe400078e020dULL, 0x00000008411e7824ULL, 0x000fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200000e0611ULL, 0x0000001216167210ULL, 0x000fe40007f1e0ffULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee213ULL, 0x000000101c137824ULL, 0x000fe400078e0255ULL,
0x000000ffff177224ULL, 0x000fc400000e0617ULL, 0x000000101e557824ULL, 0x000fe200078e0255ULL,
0x0000000010137faeULL, 0x0007e8000e901c46ULL, 0x0000000016557faeULL, 0x0007e2000f101c46ULL,
0x000002f000007947ULL, 0x000fea0003800000ULL, 0x000000100e107824ULL, 0x000fe400078e00ffULL,
0x000000100d127824ULL, 0x040fe400078e00ffULL, 0x00000080ff1d7424ULL, 0x000fe200078e00ffULL,
0x000000100d117211ULL, 0x000fc400078fe8ffULL, 0x0000007012127812ULL, 0x000fe400078ec0ffULL,
0x0000000811177810ULL, 0x040fe20007ffe0ffULL, 0x0000000111107824ULL, 0x040fe200078e020dULL,
0x0000000c111f7810ULL, 0x040fe20007ffe0ffULL, 0x0000000811137824ULL, 0x000fe400078e00ffULL,
0x0000000117167824ULL, 0x040fe400078e021cULL, 0x0000000817427824ULL, 0x000fe200078e00ffULL,
0xfffffff8131e7812ULL, 0x000fe200078ee210ULL, 0x0000000111107824ULL, 0x040fe200078e021cULL,
0x0000000411137810ULL, 0x000fe20007ffe0ffULL, 0x000000081f467824ULL, 0x000fc400078e00ffULL,
0x00005e0010107625ULL, 0x000fc800078e001dULL, 0x0000000113147824ULL, 0x140fe200078e021cULL,
0x0000001210107210ULL, 0x000fe20007f1e0ffULL, 0x0000000113157824ULL, 0x140fe400078e020dULL,
0x0000000813407824ULL, 0x000fe400078e00ffULL, 0x0000000117137824ULL, 0x100fe400078e020dULL,
0x000000011f177824ULL, 0x040fe200078e020dULL, 0xfffffff840407812ULL, 0x000fe200078ee215ULL,
0x000000011f1c7824ULL, 0x000fe200078e021cULL, 0xfffffff842427812ULL, 0x000fe200078ee213ULL,
0x00005e0014147625ULL, 0x000fe200078e001dULL, 0xfffffff846467812ULL, 0x000fc600078ee217ULL,
0x00005e0016167625ULL, 0x000fc800078e001dULL, 0x00005e001c1c7625ULL, 0x000fe200078e001dULL,
0x0000001216167210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff117224ULL, 0x000fe200000e0611ULL,
0x0000001214147210ULL, 0x080fe20007f1e0ffULL, 0x000000101e137824ULL, 0x100fe200078e0255ULL,
0x000000121c1c7210ULL, 0x000fe20007fde0ffULL, 0x00000010401f7824ULL, 0x000fe400078e0255ULL,
0x000000ffff157224ULL, 0x000fe200000e0615ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0005e2000b901c46ULL, 0x0000001042417824ULL, 0x000fe400078e0255ULL,
0x000000ffff177224ULL, 0x000fe200028e0617ULL, 0x00000000141f7faeULL, 0x0005e2000b901c46ULL,
0x0000001046557824ULL, 0x000fc400078e0255ULL, 0x000000ffff1d7224ULL, 0x000fe200030e061dULL,
0x0000000016417faeULL, 0x0005e8000b901c46ULL, 0x000000001c557faeULL, 0x0005e4000b901c46ULL,
0x0000000000007918ULL, 0x00cfe20000000000ULL, 0xffffffe00c107812ULL, 0x040fe200078ec0ffULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000000100c117812ULL, 0x040fe400078ec0ffULL,
0x000000080c137812ULL, 0x000fc400078ec0ffULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x00000010131c7210ULL, 0x000fd60007ffe011ULL, 0x00000000530403c2ULL, 0x000ea40000080000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00c9b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000270f070ULL,
0xffffff8000004947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800545a7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f668001c107f8cULL, 0x0002a4000c80043fULL, 0x0000000000147805ULL, 0x000fc40000015200ULL,
0x00f66c001c137984ULL, 0x000f240000000800ULL, 0x8000000013ff7812ULL, 0x014fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000167805ULL, 0x000fcc0000015200ULL, 0x0000001614167210ULL, 0x000fca0007f1e1ffULL,
0x0000000117177824ULL, 0x000fe200000e0e15ULL, 0x003d09001600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011417ULL,
0x0000001613137211ULL, 0x000fca00078110ffULL, 0x000000ffff167224ULL, 0x000fca00000e0617ULL,
0x0000000213137819ULL, 0x000fc80000001216ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011d1d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c001c137984ULL, 0x000ea40000000800ULL,
0x8000000013ff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000180124b7810ULL, 0x000fca0007ffe04bULL, 0x000000014a4b7824ULL, 0x000fca00078e024bULL,
0x00f000004b137984ULL, 0x000ea80000000800ULL, 0x00f200004b147984ULL, 0x0002e20000000800ULL,
0x000000581300720bULL, 0x004fe20003f1d000ULL, 0x000074d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000157806ULL, 0x002fc800000e0100ULL, 0x0000ffff15ff7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff167424ULL, 0x000fd600078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x000000033c117811ULL, 0x000fe400078ff0ffULL,
0x000000581300720bULL, 0x000fe40003f14000ULL, 0x0000003c1100720cULL, 0x000fe20003fa5270ULL,
0x000074927f007947ULL, 0x000fd4000b800000ULL, 0x0000000000167806ULL, 0x000fc400000e0100ULL,
0x000000803c11d824ULL, 0x000fe200078e0212ULL, 0x000000581310d209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x000000014a17d824ULL, 0x000fe200078e0211ULL,
0x0000991016117816ULL, 0x000fc800000000ffULL, 0x00f400101700d388ULL, 0x0003e20000000800ULL,
0x000000ff1100720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000005813117209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff16ff7812ULL, 0x000fc6000780c0ffULL, 0x0000005811107221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000127308ULL, 0x000e640000000800ULL,
0x0000001207077220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe2000001160dULL, 0x000073a27f007947ULL, 0x000fea000b800000ULL,
0x00001f1012107589ULL, 0x0002a400000e0000ULL, 0x0000001020207220ULL, 0x084fe20000410000ULL,
0x0000001021217220ULL, 0x080fe20000410000ULL, 0x0000001024247220ULL, 0x080fe20000410000ULL,
0x0000001025257220ULL, 0x080fe20000410000ULL, 0x0000001028287220ULL, 0x080fe20000410000ULL,
0x0000001029297220ULL, 0x080fe20000410000ULL, 0x000000102c2c7220ULL, 0x080fe20000410000ULL,
0x000000102d2d7220ULL, 0x080fe20000410000ULL, 0x0000001030307220ULL, 0x080fe20000410000ULL,
0x0000001031317220ULL, 0x080fe20000410000ULL, 0x0000001034347220ULL, 0x080fe20000410000ULL,
0x0000001035357220ULL, 0x080fe20000410000ULL, 0x0000001038387220ULL, 0x080fe20000410000ULL,
0x0000001039397220ULL, 0x080fe20000410000ULL, 0x0000001018187220ULL, 0x080fe20000410000ULL,
0x0000001019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080d107811ULL, 0x000fe200078ff0ffULL, 0x000072927f007947ULL, 0x000fea000b800000ULL,
0x00001f1012107589ULL, 0x00046400000e0000ULL, 0x0000001022227220ULL, 0x082fe20000410000ULL,
0x0000001023237220ULL, 0x080fe20000410000ULL, 0x0000001026267220ULL, 0x080fe20000410000ULL,
0x0000001027277220ULL, 0x080fe20000410000ULL, 0x000000102a2a7220ULL, 0x080fe20000410000ULL,
0x000000102b2b7220ULL, 0x080fe20000410000ULL, 0x000000102e2e7220ULL, 0x080fe20000410000ULL,
0x000000102f2f7220ULL, 0x080fe20000410000ULL, 0x0000001032327220ULL, 0x080fe20000410000ULL,
0x0000001033337220ULL, 0x080fe20000410000ULL, 0x0000001036367220ULL, 0x080fe20000410000ULL,
0x0000001037377220ULL, 0x080fe20000410000ULL, 0x000000103a3a7220ULL, 0x080fe20000410000ULL,
0x000000103b3b7220ULL, 0x080fe20000410000ULL, 0x000000101a1a7220ULL, 0x080fe20000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff16ff7812ULL, 0x000fe20007800815ULL, 0x00000001ff167424ULL, 0x000fe200078e00ffULL,
0x0000005813587209ULL, 0x000fd60007810000ULL, 0x8000005813130221ULL, 0x000fe20000010000ULL,
0x00007610ff160816ULL, 0x000fc60000000016ULL, 0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL,
0x0000001300020308ULL, 0x000e640000000800ULL, 0x0000000214140220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000714077221ULL, 0x008fc20000010000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x0000000108577824ULL, 0x000fca00078e0257ULL,
0x00f6ac0057137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780487fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x004fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac0057137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780487fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991016107816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000002ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe4000001160dULL,
0x0000541000127816ULL, 0x004fe20000000000ULL, 0x00006e627f007947ULL, 0x000fea000b800000ULL,
0x00001f1312037589ULL, 0x0002a400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x00006e927f007947ULL, 0x000fea000b800000ULL, 0x00001f1012007589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00009b70001c7802ULL, 0x000fc40000000f00ULL,
0x0000732000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0012ULL,
0x00009bc0001c7802ULL, 0x000fc40000000f00ULL, 0x000072d000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000521c783bULL, 0x000f280000004200ULL, 0x000000004f40783bULL, 0x0006a80000004200ULL,
0x000000004d10783bULL, 0x00e2a80000004200ULL, 0x000000004c14783bULL, 0x0006620000004200ULL,
0x00000018ff6d7819ULL, 0x010fe2000001141cULL, 0x000001001c4f7824ULL, 0x040fe200078e00ffULL,
0x000088801c6f7816ULL, 0x040fe200000000ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe2000001141dULL, 0x000001001d507824ULL, 0x040fe200078e00ffULL,
0x000088801d5e7816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff4f7819ULL, 0x000fc4000001144fULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff547819ULL, 0x000fe4000001141eULL, 0x00000018ff557819ULL, 0x000fe2000001141fULL,
0x0000001c00747306ULL, 0x0009e20000200c00ULL, 0x00000018ff617819ULL, 0x000fe40000011440ULL,
0x000088801e707816ULL, 0x000fe400000000ffULL, 0x000088801f647816ULL, 0x000fc400000000ffULL,
0x00008880406c7816ULL, 0x040fe200000000ffULL, 0x0000001d00727306ULL, 0x0003e20000200c00ULL,
0x000001001f1c7824ULL, 0x050fe200078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe20000011441ULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000888041657816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000004f00767306ULL, 0x0009e20000200c00ULL,
0x00000100401d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fc40000011442ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c00697306ULL, 0x0003e20000200c00ULL,
0x000001001e4f7824ULL, 0x050fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x0000888042627816ULL, 0x000fe400000000ffULL,
0x00000018ff457819ULL, 0x004fe40000011410ULL, 0x0000001d00677306ULL, 0x0005e20000200c00ULL,
0x00000100411c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fc40000011450ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000004000687306ULL, 0x000fe20000200c00ULL,
0x00000100421d7824ULL, 0x044fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c006a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff427819ULL, 0x000fc40000011442ULL, 0x00000018ff4c7819ULL, 0x008fe40000011411ULL,
0x00000018ff4e7819ULL, 0x000fe40000011443ULL, 0x0000888043597816ULL, 0x040fe200000000ffULL,
0x0000001d005f7306ULL, 0x0005e20000200c00ULL, 0x00000100431c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff477819ULL, 0x000fe20000011412ULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fe40000011414ULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x0000001e00637306ULL, 0x000fe20000200c00ULL, 0x00000100101d7824ULL, 0x004fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x00000018ff4b7819ULL, 0x000fe40000011413ULL,
0x00000018ff407819ULL, 0x000fe4000001141dULL, 0x0000001f006e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff4a7819ULL, 0x000fe40000011415ULL, 0x00000018ff447819ULL, 0x000fc40000011416ULL,
0x00000018ff497819ULL, 0x000fc60000011417ULL, 0x0000001c00607306ULL, 0x0003f00000200c00ULL,
0x0000004100667306ULL, 0x0005e20000200c00ULL, 0x00a800003f1c783bULL, 0x0022ee0000000200ULL,
0x0000005400547306ULL, 0x000f220000200c00ULL, 0x0000888010417816ULL, 0x044fe200000000ffULL,
0x0001000010107824ULL, 0x000fc400078e00ffULL, 0x00000100123f7824ULL, 0x002fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005500557306ULL, 0x000e620000200c00ULL,
0x00000018ff527819ULL, 0x000fe4000001143fULL, 0x00008880133f7816ULL, 0x000fca00000000ffULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x0000541063547816ULL, 0x010fce0000000054ULL,
0x0000005000717306ULL, 0x000fe20000200c00ULL, 0x000054106e557816ULL, 0x002fce0000000055ULL,
0x0000004f006b7306ULL, 0x0003e20000200c00ULL, 0x000000031c1c8232ULL, 0x088fe40000000000ULL,
0x000000031e1e8232ULL, 0x000fe40000000000ULL, 0x000000001d1d8232ULL, 0x080fe40000000000ULL,
0x000000001f1f8232ULL, 0x000fe20000000000ULL, 0x00000042005c7306ULL, 0x0005e20000200c00ULL,
0x00000100114f7824ULL, 0x002fca00078e00ffULL, 0x000000541c2c723cULL, 0x000be4000000182cULL,
0x0000001000507306ULL, 0x0003e20000200c00ULL, 0x0000888011427816ULL, 0x044fe200000000ffULL,
0x0001000011117824ULL, 0x000fca00078e00ffULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x0000010013107824ULL, 0x042fe400078e00ffULL,
0x0001000013137824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000006500657306ULL, 0x000e620000200c00ULL, 0x00000018ff137819ULL, 0x000fce0000011413ULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000054106c547816ULL, 0x024fce0000000067ULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x0000541065557816ULL, 0x002fce000000006aULL,
0x0000006100617306ULL, 0x000e620000200c00ULL, 0x000000541c30723cULL, 0x000bee0000001830ULL,
0x0000005d005d7306ULL, 0x000eb00000200c00ULL, 0x0000001100517306ULL, 0x0007e20000200c00ULL,
0x0000541068547816ULL, 0x022fce0000000061ULL, 0x0000001000567306ULL, 0x0003e20000200c00ULL,
0x000054105e117816ULL, 0x008fe40000000071ULL, 0x0000541066557816ULL, 0x004fe4000000005dULL,
0x00008880165d7816ULL, 0x000fc600000000ffULL, 0x0000006400647306ULL, 0x000ea20000200c00ULL,
0x000054106f107816ULL, 0x002fe20000000076ULL, 0x000000541c34723cULL, 0x000be20000001834ULL,
0x00008880146f7816ULL, 0x000fca00000000ffULL, 0x0000004300537306ULL, 0x0003e20000200c00ULL,
0x0001000015547824ULL, 0x020fe200078e00ffULL, 0x000000101c20723cULL, 0x000be80000001820ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x0000007000707306ULL, 0x000ee20000200c00ULL,
0x00000018ff437819ULL, 0x002fe4000001144fULL, 0x00008880124f7816ULL, 0x040fe200000000ffULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x0000541074107816ULL, 0x020fc4000000006dULL,
0x0000541072117816ULL, 0x000fe20000000057ULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x000000ffff577224ULL, 0x000fc800078e006fULL,
0x000000101c24723cULL, 0x000b640000001824ULL, 0x0000005900597306ULL, 0x000e6a0000200c00ULL,
0x0000541064117816ULL, 0x024fe40000000069ULL, 0x0000888015697816ULL, 0x000fe200000000ffULL,
0x00000012005a7306ULL, 0x0005e20000200c00ULL, 0x0000541070107816ULL, 0x008fc6000000006bULL,
0x000000ffff637224ULL, 0x000fe400078e0069ULL, 0x0000010015697824ULL, 0x000fe400078e00ffULL,
0x0000004d004d7306ULL, 0x000ee20000200c00ULL, 0x0000010014127824ULL, 0x044fe200078e00ffULL,
0x0000541059157816ULL, 0x002fe20000000060ULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x000000101c28723cULL, 0x000b640000001828ULL, 0x00000018ff647819ULL, 0x000fc40000011412ULL,
0x0000004e004e7306ULL, 0x000e620000200c00ULL, 0x00000018ff147819ULL, 0x000fce0000011414ULL,
0x0000001400557306ULL, 0x0005f00000200c00ULL, 0x00000013005e7306ULL, 0x0009e20000200c00ULL,
0x0000541062147816ULL, 0x004fce000000005fULL, 0x0000003f003f7306ULL, 0x000ea20000200c00ULL,
0x00a800003e10783bULL, 0x0308a20000000200ULL, 0x000000141c38723cULL, 0x000b6c0000001838ULL,
0x0000004500457306ULL, 0x000ea20000200c00ULL, 0x000054105c147816ULL, 0x028fe2000000004dULL,
0x000000ffff4d7224ULL, 0x000fe200078e005dULL, 0x0000541053157816ULL, 0x002fc4000000004eULL,
0x00000018ff3e7819ULL, 0x010fe40000011469ULL, 0x000054103f537816ULL, 0x004fe20000000056ULL,
0x0000004700477306ULL, 0x000fe40000200c00ULL, 0x000000141c18723cULL, 0x000b620000001818ULL,
0x0000541050507816ULL, 0x000fcc0000000045ULL, 0x0000010016157824ULL, 0x060fe200078e00ffULL,
0x00008880171c7816ULL, 0x040fe200000000ffULL, 0x00000100171d7824ULL, 0x040fe200078e00ffULL,
0x0000004100417306ULL, 0x000fe20000200c00ULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe4000001141dULL, 0x00000018ff167819ULL, 0x000fe40000011416ULL,
0x00000018ff3f7819ULL, 0x000fe20000011417ULL, 0x0000004000407306ULL, 0x000e620000200c00ULL,
0x0000000310108232ULL, 0x000fc40000000000ULL, 0x0000000312128232ULL, 0x000fca0000000000ULL,
0x0000004d00147306ULL, 0x000fe20000200c00ULL, 0x0000000011118232ULL, 0x080fe40000000000ULL,
0x0000000013138232ULL, 0x000fca0000000000ULL, 0x0000001500157306ULL, 0x000ea20000200c00ULL,
0x0000541041407816ULL, 0x002fce0000000040ULL, 0x0000001e001f7306ULL, 0x000ff00000200c00ULL,
0x0000004c004c7306ULL, 0x000e620000200c00ULL, 0x0000541014147816ULL, 0x004fce0000000015ULL,
0x0000004b004b7306ULL, 0x000eb00000200c00ULL, 0x0000004600467306ULL, 0x000ee20000200c00ULL,
0x0000541051517816ULL, 0x002fce000000004cULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x000054105e177816ULL, 0x004fe2000000004bULL, 0x000000501024723cULL, 0x000b6c0000001824ULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x0000541055467816ULL, 0x008fce0000000046ULL,
0x0000004900497306ULL, 0x000ff00000200c00ULL, 0x0000004200427306ULL, 0x000ff00000200c00ULL,
0x0000004300437306ULL, 0x000e700000200c00ULL, 0x0000004f004f7306ULL, 0x000ff00000200c00ULL,
0x0000005200527306ULL, 0x000ea20000200c00ULL, 0x0000541042417816ULL, 0x002fce0000000043ULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x000000401020723cULL, 0x000b6e0000001820ULL,
0x0000006400647306ULL, 0x000e620000200c00ULL, 0x000054104f527816ULL, 0x004fce0000000052ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x000000521028723cULL, 0x000b6e0000001828ULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x0000541057627816ULL, 0x002fce0000000064ULL,
0x0000005400597306ULL, 0x000e700000200c00ULL, 0x0000001c001c7306ULL, 0x000ee20000200c00ULL,
0x0000541063637816ULL, 0x004fce000000003eULL, 0x00000016001d7306ULL, 0x0005220000200c00ULL,
0x000000621030723cULL, 0x000b6e0000001830ULL, 0x0000003f001e7306ULL, 0x000f220000200c00ULL,
0x000054105a167816ULL, 0x004fe40000000047ULL, 0x0000541059477816ULL, 0x002fc4000000004aULL,
0x000054101c157816ULL, 0x008fe4000000001fULL, 0x000054101d447816ULL, 0x010fe20000000044ULL,
0x00000016102c723cULL, 0x000b62000000182cULL, 0x000054101e457816ULL, 0x000fce0000000049ULL,
0x000000461034723cULL, 0x040b700000001834ULL, 0x000000141038723cULL, 0x040b700000001838ULL,
0x000000441018723cULL, 0x000b620000001818ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x0000000004147f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6a00048ff7f8cULL, 0x0007e2000c80043fULL,
0x0000000105127812ULL, 0x000fc600078ec0ffULL, 0x0000000106067810ULL, 0x008fc80007ffe0ffULL,
0x0000000f0600720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffff64b000007947ULL, 0x000fea000383ffffULL, 0x000000ff0f00720cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0180000007007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000aba000047802ULL, 0x002fc40000000f00ULL, 0x0000613000007944ULL, 0x00cfea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000700007308ULL, 0x000f240000001000ULL,
0xbf80000000027423ULL, 0x010fc80000000007ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006700ff037624ULL, 0x000fe400078e00ffULL, 0x00006600ff027624ULL, 0x000fca00078e00ffULL,
0x0000000602037981ULL, 0x000f28000c1e9900ULL, 0x0000000000047919ULL, 0x002e680000000000ULL,
0x0000000000077919ULL, 0x004ea20000000000ULL, 0x00000002ff067819ULL, 0x002fe40000011604ULL,
0x0000000807047811ULL, 0x004fe200078ff0ffULL, 0x0000000003057220ULL, 0x018fca0000410000ULL,
0x00001f0605007589ULL, 0x000e6800000e0000ULL, 0x00001f0405047589ULL, 0x000ea200000e0000ULL,
0x0000002000207220ULL, 0x042fe20000410000ULL, 0x0000002100217220ULL, 0x040fe20000410000ULL,
0x0000002400247220ULL, 0x040fe20000410000ULL, 0x0000002500257220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002900297220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x040fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000003400347220ULL, 0x040fe20000410000ULL, 0x0000003500357220ULL, 0x040fe20000410000ULL,
0x0000003800387220ULL, 0x040fe20000410000ULL, 0x0000003900397220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001900197220ULL, 0x000fe20000410000ULL,
0x0000002204227220ULL, 0x044fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000002604267220ULL, 0x040fe20000410000ULL, 0x0000002704277220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000003204327220ULL, 0x040fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000003604367220ULL, 0x040fe20000410000ULL, 0x0000003704377220ULL, 0x040fe20000410000ULL,
0x0000003a043a7220ULL, 0x040fe20000410000ULL, 0x0000003b043b7220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x000fc20000410000ULL,
0x0000000000037919ULL, 0x000f220000000000ULL, 0x000000383938723eULL, 0x000fc400000000ffULL,
0x00000018191c723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000002a2b2b723eULL, 0x000fe400000000ffULL, 0x0000002e2f2e723eULL, 0x000fe400000000ffULL,
0x000000323332723eULL, 0x000fc400000000ffULL, 0x000000363719723eULL, 0x000fe400000000ffULL,
0x0000003a3b3a723eULL, 0x000fe400000000ffULL, 0x0000001a1b1d723eULL, 0x000fe400000000ffULL,
0x000054102b2a7816ULL, 0x000fe4000000002eULL, 0x0000000203007812ULL, 0x050fe400078ec0ffULL,
0x0000000803077811ULL, 0x000fc400078ff0ffULL, 0x00000002ff057819ULL, 0x000fe40000011603ULL,
0x0000000700047211ULL, 0x042fe200078ff8ffULL, 0x0000000807077824ULL, 0x000fe200078e00ffULL,
0x0000000500027211ULL, 0x000fe200078ff8ffULL, 0x0000000805097824ULL, 0x000fe200078e00ffULL,
0x000076322b2b7816ULL, 0x000fe2000000002eULL, 0x0000000805127824ULL, 0x000fe200078e00ffULL,
0x0000000202007810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8070c7812ULL, 0x000fe200078ee204ULL,
0x0000000805077824ULL, 0x000fe200078e00ffULL, 0xfffffff809087812ULL, 0x000fe200078ee200ULL,
0x000010000e007824ULL, 0x000fe200078e00ffULL, 0x0000000402067810ULL, 0x000fc40007ffe0ffULL,
0xfffffff807047812ULL, 0x000fe200078ee202ULL, 0x000008000b057824ULL, 0x000fe200078e0200ULL,
0x0000000602077810ULL, 0x000fe20007ffe0ffULL, 0x0000000803027824ULL, 0x000fe200078e00ffULL,
0xfffffff809107812ULL, 0x000fe200078ee206ULL, 0x0000001004067824ULL, 0x000fe200078e0205ULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x000000100c147824ULL, 0x10cfe200078e0205ULL,
0x0000000802077812ULL, 0x000fe200078ec0ffULL, 0x00000010080c7824ULL, 0x100fe200078e0205ULL,
0x000000202102723eULL, 0x000fe200000000ffULL, 0x0000001010107824ULL, 0x000fe200078e0205ULL,
0x000000242504723eULL, 0x000fe200000000ffULL, 0x0000000106087824ULL, 0x000fe200078e0207ULL,
0x000000343506723eULL, 0x000fe200000000ffULL, 0x00000001070c7824ULL, 0x040fe200078e020cULL,
0x0000541002167816ULL, 0x100fe20000000004ULL, 0x0000001012127824ULL, 0x000fe200078e0205ULL,
0x0000763202177816ULL, 0x000fe20000000004ULL, 0x0000000107147824ULL, 0x000fe200078e0214ULL,
0x000000282902723eULL, 0x000fe200000000ffULL, 0x0000000107107824ULL, 0x000fe200078e0210ULL,
0x0000002c2d04723eULL, 0x000fe200000000ffULL, 0x0000001608007388ULL, 0x0003e20000000a00ULL,
0x000000303105723eULL, 0x000fe200000000ffULL, 0x0000000107127824ULL, 0x000fe200078e0212ULL,
0x0000763202097816ULL, 0x000fc40000000004ULL, 0x0000763238077816ULL, 0x000fe4000000001cULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000541002087816ULL, 0x002fe40000000004ULL,
0x000000222302723eULL, 0x000fe400000000ffULL, 0x000000262704723eULL, 0x000fe200000000ffULL,
0x000000080c007388ULL, 0x0003e40000000a00ULL, 0x0000541005087816ULL, 0x002fc40000000006ULL,
0x0000763205097816ULL, 0x000fe20000000006ULL, 0x000000010a057824ULL, 0x000fe200078e0203ULL,
0x0000541038067816ULL, 0x000fc6000000001cULL, 0x0000000810007388ULL, 0x0003e20000000a00ULL,
0x0000001005057824ULL, 0x000fc600078e0200ULL, 0x0000000612007388ULL, 0x0005e20000000a00ULL,
0x000054103a087816ULL, 0x142fe4000000001dULL, 0x000076323a097816ULL, 0x000fe4000000001dULL,
0x0000541002067816ULL, 0x144fe40000000004ULL, 0x0000763202077816ULL, 0x000fca0000000004ULL,
0x0000000614007388ULL, 0x0003e80000000a00ULL, 0x0004002a0c007388ULL, 0x000fe20000000a00ULL,
0x0000541032067816ULL, 0x142fe40000000019ULL, 0x0000763232077816ULL, 0x000fca0000000019ULL,
0x0004000610007388ULL, 0x000fe80000000a00ULL, 0x0004000812007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000005147984ULL, 0x000e680000000c00ULL,
0x00040000051c7984ULL, 0x000ea80000000c00ULL, 0x0008000005187984ULL, 0x000ee80000000c00ULL,
0x000c000005207984ULL, 0x000f220000000c00ULL, 0x200000ff17177230ULL, 0x002fc40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fe40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x200000ff1f1f7230ULL, 0x004fe40000000000ULL,
0x200000ff1e1e7230ULL, 0x000fe40000000000ULL, 0x200000ff1d1d7230ULL, 0x000fc40000000000ULL,
0x200000ff1c1c7230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x008fe40000000000ULL,
0x0000001a16167230ULL, 0x000fe40000000000ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fe40000000000ULL, 0x000000231f1f7230ULL, 0x010fc40000000000ULL,
0x000000221e1e7230ULL, 0x000fe20000000000ULL, 0x0000001405007388ULL, 0x000fe20000000c00ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fca0000000000ULL,
0x0004001c05007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000020030c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000000067919ULL, 0x000e620000002600ULL, 0x00000003ff147819ULL, 0x100fe20000011603ULL,
0x00000000000579c3ULL, 0x000ea20000002700ULL, 0x00000003ff077819ULL, 0x000fe2000001160cULL,
0x0000580000047ab9ULL, 0x000fe20000000800ULL, 0x000000080e0f7824ULL, 0x000fe200078e00ffULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000114027824ULL, 0x000fc400078e0203ULL,
0x000000010c047824ULL, 0x000fc600078e0207ULL, 0x0000000702027812ULL, 0x000fe400078ec0ffULL,
0x0000000704097812ULL, 0x000fe400078ec0ffULL, 0x0ffffff802057812ULL, 0x000fe400078ef803ULL,
0x0ffffff809097812ULL, 0x000fc600078ef80cULL, 0x0000001005057824ULL, 0x100fe400078e0200ULL,
0x0000001009027824ULL, 0x000fe400078e0200ULL, 0x00000008060d7824ULL, 0x042fe200078e00ffULL,
0x0000000005087984ULL, 0x000e620000000c00ULL, 0x0000000806067824ULL, 0x000fe200078e00ffULL,
0x00000005040472a4ULL, 0x004fe4000f8e023fULL, 0x0000000002107984ULL, 0x0004e20000000c00ULL,
0xfffffff80d007812ULL, 0x000fe200078ee214ULL, 0x000000080e147824ULL, 0x000fe200078e00ffULL,
0xfffffff806077812ULL, 0x000fc400078ee207ULL, 0x00000004000d7c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000407077c10ULL, 0x000fe4000ff3e0ffULL, 0xfffffff814037812ULL, 0x000fe200078ee203ULL,
0x000000ffff027224ULL, 0x004fe200000e06ffULL, 0x00005a000d047a11ULL, 0x000fe200078040ffULL,
0x000000ffff007224ULL, 0x000fe200008e06ffULL, 0x00005a0007067a11ULL, 0x000fe400078240ffULL,
0x00005b000d057a11ULL, 0x000fc400000f4402ULL, 0x00005b0007077a11ULL, 0x000fe400008f4400ULL,
0xfffffff80f0d7812ULL, 0x000fe200078ee20cULL, 0x0000001003027825ULL, 0x000fc800078e0004ULL,
0x000000100d047825ULL, 0x000fe200078e0006ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000001004007986ULL, 0x008fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00006600ff067624ULL, 0x002fe400078e00ffULL, 0x00006700ff077624ULL, 0x000fca00078e00ffULL,
0x0000000606067981ULL, 0x000322000c1e9900ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x000000020e037824ULL, 0x000fe200078e00ffULL,
0x00f60000ff047f8cULL, 0x000ea2000c80043fULL, 0x000000403c007824ULL, 0x000fe400078e00ffULL,
0x0000580003037a24ULL, 0x000fc800078e0212ULL, 0x0000620003027a24ULL, 0x000fc800078e0200ULL,
0x000005a000000947ULL, 0x000fea0003800000ULL, 0x00000002ff1e7819ULL, 0x000fe2000001160dULL,
0x00000080ff237424ULL, 0x000fe200078e00ffULL, 0x0000003010217812ULL, 0x000fe400078ec0ffULL,
0x000000081e167810ULL, 0x000fe20007ffe0ffULL, 0x0000000102087824ULL, 0x000fe200078e021eULL,
0x000000101e1f7810ULL, 0x040fe40007ffe0ffULL, 0x000000181e207810ULL, 0x000fe20007ffe0ffULL,
0x00000001020a7824ULL, 0x000fe200078e0216ULL, 0x000000201e1c7810ULL, 0x000fe20007ffe0ffULL,
0x00005e0008087625ULL, 0x000fe200078e0023ULL, 0x0000000d0d0c7211ULL, 0x000fc400078fe8ffULL,
0x000010003c1a7811ULL, 0x000fe200078e68ffULL, 0x00005e000a0a7625ULL, 0x000fe200078e0023ULL,
0x0000002108127210ULL, 0x080fe40007f1e0ffULL, 0x000000030c0e7812ULL, 0x000fe200078ec0ffULL,
0x0000000102077824ULL, 0x002fe200078e021fULL, 0x000000210a147210ULL, 0x000fe20007f3e0ffULL,
0x00000001020a7824ULL, 0x000fe200078e0220ULL, 0x0ffffffc0e0d7812ULL, 0x000fe200078ef80dULL,
0x000000ffff137224ULL, 0x000fe200000e0609ULL, 0x000000301e1d7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fc400008e060bULL, 0x00005e0007087625ULL, 0x000fe200078e0023ULL,
0x000000003d077217ULL, 0x000fc60007800000ULL, 0x00005e000a0a7625ULL, 0x000fe200078e0023ULL,
0x0000002108087210ULL, 0x000fc60007f1e0ffULL, 0x0000000102107824ULL, 0x000fe200078e021cULL,
0x000000210a0a7210ULL, 0x000fe20007f3e0ffULL, 0x0000000107077824ULL, 0x000fe400078e0a00ULL,
0x00005e0010107625ULL, 0x000fc600078e0023ULL, 0x000000071f00720cULL, 0x080fe20003fa6070ULL,
0x000000ffff0b7224ULL, 0x000fe200008e060bULL, 0x000000071600720cULL, 0x040fe20003f26070ULL,
0x0000000416197824ULL, 0x000fe200078e00ffULL, 0x0000002110167210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff097224ULL, 0x000fe200000e0609ULL, 0x000000281e107810ULL, 0x040fe20007ffe0ffULL,
0x000000100d1b7824ULL, 0x000fe200078e021aULL, 0x000000071e00720cULL, 0x000fe20003f06070ULL,
0x000000ffff177224ULL, 0x000fe200010e0611ULL, 0xfffffffc19197812ULL, 0x000fe200078ee20eULL,
0x00000001020c7824ULL, 0x000fe200078e0210ULL, 0x000000381e1e7810ULL, 0x000fc40007ffe0ffULL,
0x000000072000720cULL, 0x000fe20003f86070ULL, 0x00005e000c0c7625ULL, 0x000fe200078e0023ULL,
0x000000071c00720cULL, 0x080fe40003f66070ULL, 0x000000071000720cULL, 0x000fe20003f46070ULL,
0x0000001019117824ULL, 0x000fe200078e021aULL, 0x000000210c187210ULL, 0x000fe20007fde0ffULL,
0x00000001020c7824ULL, 0x000fe200078e021dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121b7faeULL, 0x0003e2000c101c46ULL, 0x000000071e00720cULL, 0x080fe40003f06070ULL,
0x000000ffff197224ULL, 0x000fe200030e060dULL, 0x0000000014117faeULL, 0x0007e2000c901c46ULL,
0x000000071d00720cULL, 0x000fe20003f26070ULL, 0x00005e000c0c7625ULL, 0x000fc800078e0023ULL,
0x000000041f077824ULL, 0x000fe200078e00ffULL, 0x000000210c0c7210ULL, 0x000fe20007fde0ffULL,
0x00000004101b7824ULL, 0x002fe400078e00ffULL, 0x0000000420137824ULL, 0x000fe200078e00ffULL,
0xfffffffc07077812ULL, 0x000fe200078ee20eULL, 0x0000000102107824ULL, 0x000fe200078e021eULL,
0xfffffffc1b1b7812ULL, 0x100fe200078ee20eULL, 0x000000041c157824ULL, 0x008fe200078e00ffULL,
0xfffffffc13137812ULL, 0x000fe200078ee20eULL, 0x000000041d1d7824ULL, 0x000fc400078e00ffULL,
0x000000041e1f7824ULL, 0x000fe200078e00ffULL, 0xfffffffc15157812ULL, 0x100fe200078ee20eULL,
0x00005e0010107625ULL, 0x000fe200078e0023ULL, 0xfffffffc1d1d7812ULL, 0x100fe400078ee20eULL,
0xfffffffc1f1f7812ULL, 0x000fe200078ee20eULL, 0x000000ffff0d7224ULL, 0x000fe200030e060dULL,
0x0000002110107210ULL, 0x000fe20007fde0ffULL, 0x0000001007077824ULL, 0x100fe400078e021aULL,
0x0000001013137824ULL, 0x000fc400078e021aULL, 0x0000001015157824ULL, 0x100fe200078e021aULL,
0x0000000008077faeULL, 0x0003e2000e901c46ULL, 0x000000101b1b7824ULL, 0x100fe400078e021aULL,
0x000000101d1d7824ULL, 0x100fe200078e021aULL, 0x000000000a137faeULL, 0x0003e2000e101c46ULL,
0x000000101f1f7824ULL, 0x000fe400078e021aULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x0000000016157faeULL, 0x0003e8000d901c46ULL, 0x00000000181b7faeULL, 0x0003e8000d101c46ULL,
0x000000000c1d7faeULL, 0x0003e8000c901c46ULL, 0x00000000101f7faeULL, 0x0003e2000c101c46ULL,
0x000004e000007947ULL, 0x000fea0003800000ULL, 0x000000100d097811ULL, 0x040fe200078ff0ffULL,
0x00000080ff277424ULL, 0x000fe200078e00ffULL, 0x000000020d087211ULL, 0x000fc400078ff0ffULL,
0x000000300d157811ULL, 0x000fe200078ff0ffULL, 0x00000001020a7824ULL, 0x000fe200078e0209ULL,
0x0000003010297812ULL, 0x000fe200078ec0ffULL, 0x00000004091b7824ULL, 0x000fe200078e00ffULL,
0x0000000d0d077211ULL, 0x042fe200078fe8ffULL, 0x00005e0008087625ULL, 0x000fe200078e0027ULL,
0x000000180d0b7811ULL, 0x040fe400078ff0ffULL, 0x000000080d197811ULL, 0x040fe200078ff0ffULL,
0x00000001021c7824ULL, 0x040fe200078e0215ULL, 0x000000380d177811ULL, 0x000fe200078ff0ffULL,
0x0000000415157824ULL, 0x000fe200078e00ffULL, 0x000000200d117811ULL, 0x040fe200078ff0ffULL,
0x00000001020c7824ULL, 0x040fe200078e020bULL, 0x000000280d137811ULL, 0x000fe200078ff0ffULL,
0x000000040b0b7824ULL, 0x000fe200078e00ffULL, 0x0000000307167812ULL, 0x000fe200078ec0ffULL,
0x0000000102077824ULL, 0x000fe200078e0219ULL, 0x0000002908147210ULL, 0x000fe20007f1e0ffULL,
0x00000001021e7824ULL, 0x000fe200078e0217ULL, 0x0ffffffc16187812ULL, 0x000fe200078ef80dULL,
0x00000004171d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc15177812ULL, 0x100fe200078ee216ULL,
0x0000000419197824ULL, 0x000fe200078e00ffULL, 0xfffffffc0b107812ULL, 0x100fe200078ee216ULL,
0x0000000102127824ULL, 0x000fe200078e0211ULL, 0x000010003c257811ULL, 0x000fe200078e68ffULL,
0x00000001021a7824ULL, 0x000fe200078e0213ULL, 0xfffffffc19027812ULL, 0x100fe200078ee216ULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0xfffffffc1b0e7812ULL, 0x100fe200078ee216ULL,
0x0000000413137824ULL, 0x000fe200078e00ffULL, 0xfffffffc1d197812ULL, 0x100fe200078ee216ULL,
0x000000ffff157224ULL, 0x000fe200000e0609ULL, 0xfffffffc11117812ULL, 0x100fe200078ee216ULL,
0x00005e0007087625ULL, 0x000fe200078e0027ULL, 0xfffffffc13137812ULL, 0x000fc600078ee216ULL,
0x00005e000a0a7625ULL, 0x000fe200078e0027ULL, 0x0000002908167210ULL, 0x000fc60007f1e0ffULL,
0x00005e000c0c7625ULL, 0x000fc800078e0027ULL, 0x00000010182b7824ULL, 0x100fe200078e0225ULL,
0x000000290a187210ULL, 0x000fe20007f3e0ffULL, 0x0000001017237824ULL, 0x100fe400078e0225ULL,
0x0000001002077824ULL, 0x100fe200078e0225ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000142b7faeULL, 0x0003e2000b901c46ULL, 0x000000100e1b7824ULL, 0x100fe400078e0225ULL,
0x00000010101d7824ULL, 0x100fe400078e0225ULL, 0x00000010111f7824ULL, 0x000fc400078e0225ULL,
0x0000001013217824ULL, 0x000fe400078e0225ULL, 0x000000ffff177224ULL, 0x000fe200000e0609ULL,
0x000000290c0c7210ULL, 0x000fe20007f1e0ffULL, 0x0000001019257824ULL, 0x000fe400078e0225ULL,
0x000000ffff197224ULL, 0x000fe200008e060bULL, 0x0000000016077faeULL, 0x0003e2000b901c46ULL,
0x00005e0012087625ULL, 0x000fc600078e0027ULL, 0x00000000181b7faeULL, 0x0003e2000b901c46ULL,
0x00005e001a0a7625ULL, 0x000fc800078e0027ULL, 0x00005e001c107625ULL, 0x000fe200078e0027ULL,
0x000000290a0a7210ULL, 0x000fc60007f3e0ffULL, 0x00005e001e127625ULL, 0x000fe200078e0027ULL,
0x0000002910107210ULL, 0x000fc60007f5e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200000e060dULL,
0x0000002908087210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff0b7224ULL, 0x000fe200008e060bULL,
0x0000002912127210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0x000000000c1d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff097224ULL, 0x000fe400000e0609ULL,
0x000000ffff137224ULL, 0x000fc600018e0613ULL, 0x00000000081f7faeULL, 0x0003e8000b901c46ULL,
0x000000000a217faeULL, 0x0003e8000b901c46ULL, 0x0000000010237faeULL, 0x0003e8000b901c46ULL,
0x0000000012257faeULL, 0x0003e4000b901c46ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fc40000015200ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x006fc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a08077210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0a7824ULL, 0x000fe200000e0e09ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc8000001140aULL, 0x0000000702027211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e060aULL, 0x0000000202027819ULL, 0x000fc80000001207ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x000000203c027824ULL, 0x002fca00078e0205ULL, 0x00000003ff047819ULL, 0x000fc80000011602ULL,
0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL, 0x0000000f02047812ULL, 0x000fc600078ec0ffULL,
0x0000000102057824ULL, 0x000fe400078e0205ULL, 0x0000001004077824ULL, 0x040fe400078e00ffULL,
0x0000001004047824ULL, 0x000fe200078e00ffULL, 0x0000000f05027812ULL, 0x040fe400078ec0ffULL,
0x0000000105057810ULL, 0x000fe40007ffe0ffULL, 0x000000f007027812ULL, 0x000fe400078ee202ULL,
0x0000000f05057812ULL, 0x000fc600078ec0ffULL, 0x0000000002107984ULL, 0x000e62000000cc00ULL,
0x000000f004057812ULL, 0x000fca00078ee205ULL, 0x0000000005087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff147224ULL, 0x002fe400078e0010ULL, 0x000000ffff107224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e0012ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000ffff167224ULL, 0x004fe400078e0008ULL, 0x000000ffff177224ULL, 0x000fc400078e000aULL,
0x000000ffff127224ULL, 0x000fe400078e0009ULL, 0x000000ffff137224ULL, 0x000fe200078e000bULL,
0x0000001402007388ULL, 0x0003e8000000cc00ULL, 0x0000001005007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff0a7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0c7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x002fc80000015200ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc4000780480bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000804077210ULL, 0x000fca0007f1e1ffULL, 0x0000000109087824ULL, 0x000fe200000e0e05ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011408ULL, 0x0000000702027211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0608ULL, 0x0000000202027819ULL, 0x000fc80000001207ULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0f00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x3db504f306047820ULL, 0x010fe20000410000ULL, 0x0000f6883c057811ULL, 0x040fe200078e18ffULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0xffffffff0f067810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x0000f6083c077811ULL, 0x000fc400078e28ffULL,
0x0000010009087824ULL, 0x000fe200078e0200ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x000000083d00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x00cfea0003800000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e000bULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fc4000001ff00ULL,
0x000000010a0c7810ULL, 0x000fe20007ffe0ffULL, 0x00000a8000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3e7224ULL, 0x000fc400078e000aULL, 0x000000090c0b7211ULL, 0x040fe200078ff8ffULL,
0x000000ffff0a7224ULL, 0x000fe200078e000cULL, 0x000000020c00780cULL, 0x000fe40003f06070ULL,
0x000000010b0e7810ULL, 0x040fe20007ffe0ffULL, 0x000001000b107824ULL, 0x020fe200078e0200ULL,
0x000000010d0b7812ULL, 0x000fe400078e0cffULL, 0x0000000f0e00720cULL, 0x000fe20003f26070ULL,
0x00006200031d7a24ULL, 0x000fe200078e0210ULL, 0x000000010c0e7812ULL, 0x000fd600078ec0ffULL,
0x0000054000009947ULL, 0x000fea0003800000ULL, 0x0000000202117211ULL, 0x002fe200078fe8ffULL,
0x000000040e3f7824ULL, 0x000fe200078e00ffULL, 0x000000103d0c7217ULL, 0x000fe20007800000ULL,
0x000000023c0e7824ULL, 0x000fe200078e020bULL, 0x00000002ff187819ULL, 0x000fe20000011602ULL,
0x00000080ff417424ULL, 0x000fe200078e00ffULL, 0x00000003111f7812ULL, 0x000fe200078ec0ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0a10ULL, 0x0000000818117810ULL, 0x040fe20007ffe0ffULL,
0x0000000118107824ULL, 0x000fe200078e021dULL, 0xfffffffc3f3f7812ULL, 0x000fc400078ee202ULL,
0x0000000c1800720cULL, 0x080fe20003f26070ULL, 0x0000000111127824ULL, 0x040fe200078e021dULL,
0x0000000c1100720cULL, 0x040fe20003f46070ULL, 0x00000004111a7824ULL, 0x000fe200078e00ffULL,
0x000010000e0e7811ULL, 0x000fe200078e60ffULL, 0x00005e0010107625ULL, 0x080fe200078e0041ULL,
0x0ffffffc1f197812ULL, 0x000fe400078ef802ULL, 0xfffffffc1a1b7812ULL, 0x000fe200078ee21fULL,
0x00005e0012127625ULL, 0x000fe200078e0041ULL, 0x00000010181a7810ULL, 0x000fc40007ffe0ffULL,
0x00000018181c7810ULL, 0x040fe20007ffe0ffULL, 0x0000001019197824ULL, 0x000fe200078e020eULL,
0x00000020181e7810ULL, 0x040fe20007ffe0ffULL, 0x000000103f107825ULL, 0x000fe200078e0010ULL,
0x0000002818407810ULL, 0x040fe40007ffe0ffULL, 0x0000003018427810ULL, 0x040fe20007ffe0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e020eULL, 0x0000003818437810ULL, 0x000fe20007ffe0ffULL,
0x000000103f127825ULL, 0x000fe200078e0012ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010197faeULL, 0x0003e2000c901c46ULL, 0x0000000c1a00720cULL, 0x000fc40003f26070ULL,
0x0000000c1e00720cULL, 0x080fe20003f66070ULL, 0x00000000121b7faeULL, 0x0005e2000d101c46ULL,
0x0000000c1c00720cULL, 0x0c0fe20003f46070ULL, 0x000000041c447824ULL, 0x000fe200078e00ffULL,
0x0000000c4000720cULL, 0x080fe20003f86070ULL, 0x000000041e467824ULL, 0x000fe200078e00ffULL,
0x0000000c4200720cULL, 0x080fe20003fa6070ULL, 0x0000000443487824ULL, 0x040fe200078e00ffULL,
0x0000000c4300720cULL, 0x000fe20003fc6070ULL, 0x000000011a107824ULL, 0x002fe200078e021dULL,
0xfffffffc44457812ULL, 0x100fe200078ee21fULL, 0x000000041a0c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc46477812ULL, 0x000fe200078ee21fULL, 0x000000011c127824ULL, 0x004fe200078e021dULL,
0xfffffffc484d7812ULL, 0x000fe200078ee21fULL, 0x00000001401a7824ULL, 0x000fc400078e021dULL,
0x00000001421c7824ULL, 0x100fe400078e021dULL, 0x0000000440407824ULL, 0x000fe400078e00ffULL,
0x0000000442427824ULL, 0x000fe400078e00ffULL, 0x000000011e187824ULL, 0x000fe200078e021dULL,
0xfffffffc40497812ULL, 0x000fe200078ee21fULL, 0x00000001431e7824ULL, 0x000fe200078e021dULL,
0xfffffffc0c437812ULL, 0x100fe200078ee21fULL, 0x00005e0010107625ULL, 0x000fe200078e0041ULL,
0xfffffffc424b7812ULL, 0x000fc600078ee21fULL, 0x00005e0012127625ULL, 0x000fc800078e0041ULL,
0x00005e0018187625ULL, 0x000fc800078e0041ULL, 0x00005e001a1a7625ULL, 0x000fc800078e0041ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0041ULL, 0x00005e001e1e7625ULL, 0x000fc800078e0041ULL,
0x000000103f107825ULL, 0x000fc800078e0010ULL, 0x000000103f127825ULL, 0x000fc800078e0012ULL,
0x000000103f187825ULL, 0x000fc800078e0018ULL, 0x000000103f1a7825ULL, 0x000fc800078e001aULL,
0x000000103f1c7825ULL, 0x000fc800078e001cULL, 0x000000103f1e7825ULL, 0x000fc800078e001eULL,
0x00000010433f7824ULL, 0x100fe400078e020eULL, 0x0000001045417824ULL, 0x100fe400078e020eULL,
0x0000001047437824ULL, 0x100fe200078e020eULL, 0x00000000103f7faeULL, 0x0003e2000c901c46ULL,
0x0000001049457824ULL, 0x100fe400078e020eULL, 0x000000104b477824ULL, 0x100fe200078e020eULL,
0x0000000012417faeULL, 0x0003e2000d101c46ULL, 0x000000104d497824ULL, 0x000fc600078e020eULL,
0x0000000018437faeULL, 0x0003e8000d901c46ULL, 0x000000001a457faeULL, 0x0003e8000e101c46ULL,
0x000000001c477faeULL, 0x0003e8000e901c46ULL, 0x000000001e497faeULL, 0x0003e2000f101c46ULL,
0x0000048000007947ULL, 0x000fea0003800000ULL, 0x000000040e3f7824ULL, 0x000fe200078e00ffULL,
0x0000000802187811ULL, 0x002fe200078ff0ffULL, 0x000000023c0e7824ULL, 0x000fe200078e020bULL,
0x00000002020c7211ULL, 0x040fe200078fe8ffULL, 0x00000080ff437424ULL, 0x000fe200078e00ffULL,
0x00000010021a7811ULL, 0x000fe200078ff0ffULL, 0x0000000118127824ULL, 0x000fe200078e021dULL,
0x00000018021c7811ULL, 0x000fc400078ff0ffULL, 0x00000020021e7811ULL, 0x040fe400078ff0ffULL,
0x0000002802407811ULL, 0x000fe200078ff0ffULL, 0x000000041c467824ULL, 0x000fe200078e00ffULL,
0x0000003002427811ULL, 0x000fe200078ff0ffULL, 0x000000041e487824ULL, 0x000fe200078e00ffULL,
0x0000003802447811ULL, 0x000fe200078ff0ffULL, 0x00000004404a7824ULL, 0x000fe200078e00ffULL,
0x000010000e4f7811ULL, 0x000fe200078e60ffULL, 0x00000004180e7824ULL, 0x000fe200078e00ffULL,
0x000000030c137812ULL, 0x000fe200078ec0ffULL, 0x000000011a187824ULL, 0x000fe200078e021dULL,
0x0000001d02107211ULL, 0x000fe200078ff0ffULL, 0x000000041a0c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc0e0e7812ULL, 0x000fe200078ee213ULL, 0x000000011c1a7824ULL, 0x000fe200078e021dULL,
0xfffffffc46467812ULL, 0x000fe200078ee213ULL, 0x000000011e1c7824ULL, 0x000fe200078e021dULL,
0xfffffffc48487812ULL, 0x100fe200078ee213ULL, 0x00000004424c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc4a4a7812ULL, 0x000fe200078ee213ULL, 0x00000004444e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc3f3f7812ULL, 0x100fe200078ee202ULL, 0x00000001401e7824ULL, 0x000fe200078e021dULL,
0xfffffffc4c4c7812ULL, 0x000fe200078ee213ULL, 0x0000000142407824ULL, 0x000fe200078e021dULL,
0xfffffffc4e4e7812ULL, 0x000fe200078ee213ULL, 0x0000000144427824ULL, 0x000fe200078e021dULL,
0xfffffffc0c447812ULL, 0x000fe200078ee213ULL, 0x00005e0010107625ULL, 0x000fe200078e0043ULL,
0x0ffffffc130c7812ULL, 0x000fc600078ef802ULL, 0x00005e0012127625ULL, 0x000fc800078e0043ULL,
0x00005e0018187625ULL, 0x000fc800078e0043ULL, 0x00005e001a1a7625ULL, 0x000fc800078e0043ULL,
0x00005e001c1c7625ULL, 0x000fc800078e0043ULL, 0x00005e001e1e7625ULL, 0x000fc800078e0043ULL,
0x00005e0040407625ULL, 0x000fc800078e0043ULL, 0x00005e0042427625ULL, 0x000fc800078e0043ULL,
0x000000103f107825ULL, 0x000fc800078e0010ULL, 0x000000103f127825ULL, 0x000fc800078e0012ULL,
0x000000103f187825ULL, 0x000fc800078e0018ULL, 0x000000103f1a7825ULL, 0x000fc800078e001aULL,
0x000000103f1c7825ULL, 0x000fc800078e001cULL, 0x000000103f1e7825ULL, 0x000fc800078e001eULL,
0x000000103f407825ULL, 0x000fc800078e0040ULL, 0x000000103f427825ULL, 0x000fc800078e0042ULL,
0x000000100c517824ULL, 0x100fe400078e024fULL, 0x000000100e3f7824ULL, 0x100fe400078e024fULL,
0x0000001044457824ULL, 0x100fe200078e024fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010517faeULL, 0x0003e2000b901c46ULL, 0x0000001046477824ULL, 0x100fe400078e024fULL,
0x0000001048497824ULL, 0x100fe200078e024fULL, 0x00000000123f7faeULL, 0x0003e2000b901c46ULL,
0x000000104a4b7824ULL, 0x000fc400078e024fULL, 0x000000104c4d7824ULL, 0x100fe200078e024fULL,
0x0000000018457faeULL, 0x0003e2000b901c46ULL, 0x000000104e4f7824ULL, 0x000fc600078e024fULL,
0x000000001a477faeULL, 0x0003e8000b901c46ULL, 0x000000001c497faeULL, 0x0003e8000b901c46ULL,
0x000000001e4b7faeULL, 0x0003e8000b901c46ULL, 0x00000000404d7faeULL, 0x0003e8000b901c46ULL,
0x00000000424f7faeULL, 0x0003e4000b901c46ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x000000023c0c7824ULL, 0x000fe200078e020dULL,
0x00000020020d7810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff3f7224ULL, 0x002fe200078e00ffULL,
0xfffffff802417812ULL, 0x000fc400078ec0ffULL, 0xfffffff80d0d7812ULL, 0x000fe400078ec0ffULL,
0x0000000702117812ULL, 0x000fe400078ec0ffULL, 0x0000000741417812ULL, 0x100fe400078ef802ULL,
0x000000070d427812ULL, 0x100fe400078ef802ULL, 0x000010000c0c7811ULL, 0x000fe400078e60ffULL,
0x00000008110d7812ULL, 0x000fc400078ef802ULL, 0x00000001ff0e7819ULL, 0x000fe40000011641ULL,
0x00000001ff407819ULL, 0x000fe20000011642ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000010e107824ULL, 0x120fe200078e023fULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000441117824ULL, 0x000fe200078e00ffULL, 0x000000013f457810ULL, 0x000fe20007ffe0ffULL,
0x000000043e757824ULL, 0x000fc600078e023fULL, 0xfffffffc11117812ULL, 0x000fe200078ee210ULL,
0x0000000140107824ULL, 0x000fe200078e023fULL, 0x000000023f3f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000275757824ULL, 0x000fe400078e00ffULL, 0x0000001011187824ULL, 0x000fe200078e020cULL,
0x000000043f00780cULL, 0x000fe20003f25270ULL, 0x0000000442117824ULL, 0x000fc800078e00ffULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0xfffffffc11117812ULL, 0x000fca00078ee210ULL,
0x0000001011117824ULL, 0x000fcc00078e020cULL, 0x000000001110783bULL, 0x000ea20000000200ULL,
0x00000018ff5a7819ULL, 0x002fe20000011418ULL, 0x00010000181c7824ULL, 0x040fe200078e00ffULL,
0x0000888018717816ULL, 0x040fe200000000ffULL, 0x0000010018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe20000011419ULL, 0x00010000191d7824ULL, 0x040fe200078e00ffULL,
0x00008880196f7816ULL, 0x040fe200000000ffULL, 0x0000010019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff6b7819ULL, 0x000fc4000001141aULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x000088801a6d7816ULL, 0x000fe400000000ffULL, 0x00000018ff647819ULL, 0x000fe2000001141bULL,
0x0000001800737306ULL, 0x0002e20000200c00ULL, 0x000088801b5d7816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0x00000018ff557819ULL, 0x004fe20000011410ULL, 0x0000001900627306ULL, 0x0005e20000200c00ULL,
0x000100001a187824ULL, 0x002fe200078e00ffULL, 0x0000888010547816ULL, 0x000fe200000000ffULL,
0x000001001a1a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe40000011411ULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x00000018ff1a7819ULL, 0x000fe2000001141aULL,
0x000100001b197824ULL, 0x044fe200078e00ffULL, 0x0000001c00767306ULL, 0x000fe20000200c00ULL,
0x000001001b1b7824ULL, 0x000fe200078e00ffULL, 0x0000888011657816ULL, 0x000fc400000000ffULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018ff1b7819ULL, 0x000fe4000001141bULL,
0x0000001a00707306ULL, 0x0003e20000200c00ULL, 0x00000018ff587819ULL, 0x000fe40000011412ULL,
0x00000018ff437819ULL, 0x000fe40000011413ULL, 0x0000888012637816ULL, 0x000fe400000000ffULL,
0x0000888013597816ULL, 0x000fe200000000ffULL, 0x00000019006e7306ULL, 0x0005e20000200c00ULL,
0x00000004411a7824ULL, 0x002fce00078e00ffULL, 0x0000001b00697306ULL, 0x0003e20000200c00ULL,
0x000000010e197824ULL, 0x104fe400078e0245ULL, 0x0000000140457824ULL, 0x000fca00078e0245ULL,
0x0000001d00747306ULL, 0x0005e20000200c00ULL, 0xfffffffc1a1b7812ULL, 0x002fe200078ee219ULL,
0x0001000011197824ULL, 0x040fe400078e00ffULL, 0x0000010011117824ULL, 0x000fe400078e00ffULL,
0x000000101b1b7824ULL, 0x000fe200078e020cULL, 0x00000018ff197819ULL, 0x000fe20000011419ULL,
0x0000001800727306ULL, 0x0003e20000200c00ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x000000001b1c783bULL, 0x004eaa0000000200ULL, 0x0000001100687306ULL, 0x0009e20000200c00ULL,
0x0001000010187824ULL, 0x002fc400078e00ffULL, 0x0000010010107824ULL, 0x000fc600078e00ffULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0001000013117824ULL, 0x050fe200078e00ffULL, 0x0000001800677306ULL, 0x000fe20000200c00ULL,
0x0000010013137824ULL, 0x000fc600078e00ffULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x00000010006c7306ULL, 0x0003f00000200c00ULL,
0x0000001100607306ULL, 0x0009e20000200c00ULL, 0x0000000442107824ULL, 0x002fca00078e00ffULL,
0xfffffffc10457812ULL, 0x000fe200078ee245ULL, 0x0001000012107824ULL, 0x040fe200078e00ffULL,
0x00000013005e7306ULL, 0x000fe20000200c00ULL, 0x000000100d117824ULL, 0x010fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x004fe2000001141cULL, 0x0000010012127824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000001045187824ULL, 0x000fe200078e020cULL,
0x000088801c457816ULL, 0x000fe400000000ffULL, 0x0000001000667306ULL, 0x0003e20000200c00ULL,
0x00000018ff127819ULL, 0x000fc40000011412ULL, 0x00000018ff4b7819ULL, 0x000fe4000001141dULL,
0x000088801d4f7816ULL, 0x000fe400000000ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001141eULL,
0x0000001200617306ULL, 0x000fe20000200c00ULL, 0x000100001c107824ULL, 0x002fe200078e00ffULL,
0x000088801e517816ULL, 0x000fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe4000001141fULL, 0x00000018ff4e7819ULL, 0x000fc40000011410ULL,
0x0000007502107211ULL, 0x000fe200078fe0ffULL, 0x00000019006a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x000088801f537816ULL, 0x000fe200000000ffULL,
0x000000010d107824ULL, 0x000fe200078e0210ULL, 0x0000000275757810ULL, 0x000fc60007ffe0ffULL,
0x0000007100717306ULL, 0x000ea20000200c00ULL, 0xfffffff011107812ULL, 0x000fe200078ee210ULL,
0x000100001d117824ULL, 0x040fe200078e00ffULL, 0x000000001818783bULL, 0x002e620000000200ULL,
0x000001001d1d7824ULL, 0x000fe400078e00ffULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe20000011411ULL, 0x0000001c004d7306ULL, 0x0009e20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fc6000001141dULL, 0x000000001010783bULL, 0x000ea80000000200ULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x000100001e1c7824ULL, 0x050fe400078e00ffULL,
0x000001001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000006f006f7306ULL, 0x000f220000200c00ULL, 0x00000018ff1e7819ULL, 0x000fce000001141eULL,
0x0000001d00527306ULL, 0x0007f00000200c00ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000100001f1d7824ULL, 0x048fe400078e00ffULL, 0x000001001f1f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff487819ULL, 0x002fc40000011418ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x0000006d006d7306ULL, 0x000e620000200c00ULL, 0x00000018ff777819ULL, 0x000fe4000001141fULL,
0x00005410731f7816ULL, 0x000fe4000000005aULL, 0x00000018ff477819ULL, 0x000fe40000011419ULL,
0x00000018ff447819ULL, 0x000fe2000001141bULL, 0x0000001e00577306ULL, 0x0005e20000200c00ULL,
0x00000018ff467819ULL, 0x000fce000001141aULL, 0x0000001c00567306ULL, 0x0009e20000200c00ULL,
0x00005410711e7816ULL, 0x004fe40000000076ULL, 0x0000888018717816ULL, 0x000fca00000000ffULL,
0x0000001d005c7306ULL, 0x0005e20000200c00ULL, 0x000054106f1c7816ULL, 0x010fe20000000074ULL,
0x0000001e1038723cULL, 0x000b620000001838ULL, 0x000000100d6f7824ULL, 0x000fca00078e00ffULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x00005410621d7816ULL, 0x004fe2000000005bULL,
0x000000ffff1f7224ULL, 0x020fe200078e0071ULL, 0x00000075021e7211ULL, 0x000fe200078fe0ffULL,
0x0001000018627824ULL, 0x040fe400078e00ffULL, 0x0000010018187824ULL, 0x000fe400078e00ffULL,
0x0000005d005d7306ULL, 0x000ea20000200c00ULL, 0x0000001c1034723cULL, 0x000b620000001834ULL,
0x000000010d1e7824ULL, 0x000fe200078e021eULL, 0x00000018ff187819ULL, 0x000fc40000011418ULL,
0x00000018ff627819ULL, 0x000fe40000011462ULL, 0xfffffff06f1e7812ULL, 0x000fe200078ee21eULL,
0x0000005500557306ULL, 0x000ee20000200c00ULL, 0x000054106d1c7816ULL, 0x022fe40000000072ULL,
0x00005410701d7816ULL, 0x000fe2000000006bULL, 0x000000101e1e7824ULL, 0x000fe200078e00ffULL,
0x00008880196b7816ULL, 0x000fc600000000ffULL, 0x0000005400547306ULL, 0x000e640000200c00ULL,
0x0000001c1030723cULL, 0x000b6c0000001830ULL, 0x0000005f005f7306ULL, 0x000f220000200c00ULL,
0x000054105d1c7816ULL, 0x024fe4000000006eULL, 0x00005410691d7816ULL, 0x000fe20000000064ULL,
0x0001000019697824ULL, 0x000fe200078e00ffULL, 0x000054106c557816ULL, 0x008fe20000000055ULL,
0x000000ffff647224ULL, 0x000fc400078e006bULL, 0x0000006500657306ULL, 0x000ea20000200c00ULL,
0x0000541054547816ULL, 0x002fe20000000067ULL, 0x0000001c102c723cULL, 0x040bec000000182cULL,
0x0000001f005b7306ULL, 0x0003e40000200c00ULL, 0x000000541028723cULL, 0x000bec0000001828ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x000000001e1c783bULL, 0x022e620000000200ULL,
0x0000010019547824ULL, 0x000fe200078e00ffULL, 0x0000541068197816ULL, 0x010fc4000000005fULL,
0x000088801a5f7816ULL, 0x000fe400000000ffULL, 0x00000018ff557819ULL, 0x000fe20000011469ULL,
0x0000006300637306ULL, 0x000ee20000200c00ULL, 0x00000018ff547819ULL, 0x000fce0000011454ULL,
0x00000018005d7306ULL, 0x0005f00000200c00ULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x0000541065187816ULL, 0x004fce000000006aULL, 0x0000005900597306ULL, 0x000ea20000200c00ULL,
0x000000181024723cULL, 0x000b6e0000001824ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x0000541063187816ULL, 0x028fe40000000066ULL, 0x0000541061197816ULL, 0x000fe20000000058ULL,
0x000000ffff587224ULL, 0x000fc400078e005fULL, 0x000100001a5f7824ULL, 0x040fe400078e00ffULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x000001001a1a7824ULL, 0x000fe200078e00ffULL,
0x000000181020723cULL, 0x000b680000001820ULL, 0x00000018ff1a7819ULL, 0x000fe4000001141aULL,
0x0000004e004e7306ULL, 0x000ee20000200c00ULL, 0x0000541059187816ULL, 0x024fc40000000060ULL,
0x000054105e197816ULL, 0x000fca0000000043ULL, 0x0000004b004b7306ULL, 0x000ea40000200c00ULL,
0x000000181014723cULL, 0x000b6c0000001814ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x0000541045107816ULL, 0x028fe4000000004eULL, 0x000054104d117816ULL, 0x000fc4000000004cULL,
0x000088801b127816ULL, 0x000fe400000000ffULL, 0x00000018ff137819ULL, 0x000fe2000001145fULL,
0x0000005000507306ULL, 0x000ee40000200c00ULL, 0x000000101c38723cULL, 0x002b6c0000001838ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x0000541052117816ULL, 0x024fc4000000004bULL,
0x000054104f107816ULL, 0x008fca0000000050ULL, 0x0000005800587306ULL, 0x000fe40000200c00ULL,
0x000000101c34723cULL, 0x000b6c0000001834ULL, 0x0000001300137306ULL, 0x000e620000200c00ULL,
0x000100001b117824ULL, 0x060fe400078e00ffULL, 0x000001001b1b7824ULL, 0x000fca00078e00ffULL,
0x0000004a004a7306ULL, 0x000ea20000200c00ULL, 0x000000ffff107224ULL, 0x000fe200078e0012ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff1b7819ULL, 0x000fc8000001141bULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x0000541058587816ULL, 0x002fce0000000013ULL,
0x0000004800487306ULL, 0x000e620000200c00ULL, 0x0000541057577816ULL, 0x004fce000000004aULL,
0x0000004700477306ULL, 0x000ff00000200c00ULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x000054105d5d7816ULL, 0x002fce0000000048ULL, 0x0000004400447306ULL, 0x000ff00000200c00ULL,
0x0000005100517306ULL, 0x000e700000200c00ULL, 0x00000077005a7306ULL, 0x000ff00000200c00ULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x0000541051567816ULL, 0x002fce0000000056ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x000000561c30723cULL, 0x000b6e0000001830ULL,
0x0000005500557306ULL, 0x000e700000200c00ULL, 0x0000005400547306ULL, 0x000eb00000200c00ULL,
0x0000001a00597306ULL, 0x000ee20000200c00ULL, 0x0000541064647816ULL, 0x002fce0000000055ULL,
0x0000001000127306ULL, 0x0003e20000200c00ULL, 0x0000541054657816ULL, 0x004fce0000000047ULL,
0x0000001100197306ULL, 0x0005220000200c00ULL, 0x0000541053107816ULL, 0x002fe2000000005cULL,
0x000000641c24723cULL, 0x000b620000001824ULL, 0x000054105b5c7816ULL, 0x000fe40000000062ULL,
0x0000541059597816ULL, 0x008fc60000000046ULL, 0x0000001b001b7306ULL, 0x000e620000200c00ULL,
0x000054105a117816ULL, 0x004fe20000000049ULL, 0x0000005c1c28723cULL, 0x000b620000001828ULL,
0x0000541012127816ULL, 0x010fce0000000019ULL, 0x000000101c2c723cULL, 0x000b62000000182cULL,
0x000054101b137816ULL, 0x002fce0000000044ULL, 0x000000581c20723cULL, 0x040b700000001820ULL,
0x000000121c14723cULL, 0x000b620000001814ULL, 0xfffff04000001947ULL, 0x000fce000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff0d7224ULL, 0x000fe200078e000bULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffe48000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x000000042d2d7220ULL, 0x0a0fe20000410000ULL,
0x0000000428287220ULL, 0x080fe20000410000ULL, 0x0000000424247220ULL, 0x080fe20000410000ULL,
0x0000000425257220ULL, 0x080fe20000410000ULL, 0x0000000438387220ULL, 0x080fe20000410000ULL,
0x0000000439397220ULL, 0x080fe20000410000ULL, 0x0000000434347220ULL, 0x080fe20000410000ULL,
0x0000000435357220ULL, 0x080fe20000410000ULL, 0x00000004300a7220ULL, 0x080fe20000410000ULL,
0x0000000431317220ULL, 0x080fe20000410000ULL, 0x00000004290c7220ULL, 0x080fe20000410000ULL,
0x0000000420207220ULL, 0x080fe20000410000ULL, 0x0000000421217220ULL, 0x080fe20000410000ULL,
0x0000000426187220ULL, 0x080fe20000410000ULL, 0x0000000427197220ULL, 0x080fe20000410000ULL,
0x000000ffff297224ULL, 0x000fe200078e002dULL, 0x00000004331c7220ULL, 0x080fe20000410000ULL,
0x000000042e1d7220ULL, 0x080fe20000410000ULL, 0x000000042f1e7220ULL, 0x080fe20000410000ULL,
0x000000042a1f7220ULL, 0x080fe20000410000ULL, 0x000000042b1a7220ULL, 0x080fe20000410000ULL,
0x00000004220d7220ULL, 0x080fe20000410000ULL, 0x00000004230e7220ULL, 0x080fe20000410000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0028ULL, 0x000000043a3a7220ULL, 0x080fe20000410000ULL,
0x000000ffff277224ULL, 0x000fe200078e0024ULL, 0x000000043b3b7220ULL, 0x080fe20000410000ULL,
0x000000ffff267224ULL, 0x000fe200078e0025ULL, 0x0000000436367220ULL, 0x080fe20000410000ULL,
0x0000000437377220ULL, 0x080fe20000410000ULL, 0x00000004321b7220ULL, 0x080fe20000410000ULL,
0x000000042c2c7220ULL, 0x080fe20000410000ULL, 0x0000000414237220ULL, 0x080fe20000410000ULL,
0x0000000415227220ULL, 0x080fe20000410000ULL, 0x0000000416127220ULL, 0x080fe20000410000ULL,
0x0000000417137220ULL, 0x000fe20000410000ULL, 0x000000ffff337224ULL, 0x000fc400078e0038ULL,
0x000000ffff307224ULL, 0x000fe400078e0039ULL, 0x000000ffff2b7224ULL, 0x000fe400078e0034ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0035ULL, 0x000000ffff2e7224ULL, 0x000fe400078e000aULL,
0x000000ffff2a7224ULL, 0x000fe400078e0031ULL, 0x000000ffff287224ULL, 0x000fc400078e000cULL,
0x000000ffff257224ULL, 0x000fe400078e0020ULL, 0x000000ffff247224ULL, 0x000fe200078e0021ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000005107f8cULL, 0x0002a2000c80043fULL,
0x000000ffff147224ULL, 0x000fe400078e003aULL, 0x000000ffff157224ULL, 0x000fe400078e003bULL,
0x000000ffff167224ULL, 0x000fe400078e0036ULL, 0x000000ffff177224ULL, 0x000fc400078e0037ULL,
0x000000ffff207224ULL, 0x000fe400078e0012ULL, 0x000000ffff217224ULL, 0x000fc400078e0013ULL,
0x0000000000127805ULL, 0x002fca0000015200ULL, 0x0000040005317984ULL, 0x000e640000000800ULL,
0x8000000031ff7812ULL, 0x006fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003412317210ULL, 0x000fca0007f1e1ffULL, 0x0000000135347824ULL, 0x000fe200000e0e13ULL,
0x003d09003100780cULL, 0x000fc80003f06070ULL, 0x000000ff3400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403100780cULL, 0x000fc80003f06070ULL,
0x000000ff3400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0a7819ULL, 0x000fc80000011434ULL, 0x000000310a0a7211ULL, 0x000fca00078110ffULL,
0x000000ffff317224ULL, 0x000fca00000e0634ULL, 0x000000020a0a7819ULL, 0x000fc80000001231ULL,
0x0000000a0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040005317984ULL, 0x000e640000000800ULL, 0x8000000031ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004020c7824ULL, 0x000fe200078e00ffULL,
0x000000060900720cULL, 0x000fc80003f05270ULL, 0xfffffff00c117812ULL, 0x000fca00078ec0ffULL,
0x000000803c0a7824ULL, 0x000fca00078e0211ULL, 0x00f400000a107984ULL, 0x0002a20000000c00ULL,
0x0000042000000947ULL, 0x000fea0003800000ULL, 0x0000000202317824ULL, 0x000fe400078e00ffULL,
0x000000013d087824ULL, 0x000fc600078e0a08ULL, 0x0000000631317812ULL, 0x000fc800078ec0ffULL,
0x0000000131357812ULL, 0x040fe400078efcffULL, 0x0000000831377812ULL, 0x000fe400078efcffULL,
0x000000083500720cULL, 0x080fe40003f26070ULL, 0x0000001031357812ULL, 0x000fe400078efcffULL,
0x000000083700720cULL, 0x080fe40003f06070ULL, 0x000000083500720cULL, 0x000fc40003fc6070ULL,
0x0000001131377812ULL, 0x040fe400078efcffULL, 0x0000001831357812ULL, 0x040fe400078efcffULL,
0x000000083100720cULL, 0x080fe40003f46070ULL, 0x000000083700720cULL, 0x080fe40003fa6070ULL,
0x000000083500720cULL, 0x000fe40003f66070ULL, 0x0000000931397812ULL, 0x000fc400078efcffULL,
0x0000001931377812ULL, 0x040fe400078efcffULL, 0x0000002031357812ULL, 0x000fe400078efcffULL,
0xff80000014147808ULL, 0x000fe40005000000ULL, 0xff80000033337808ULL, 0x000fe40005000000ULL,
0xff80000015157808ULL, 0x000fe40004800000ULL, 0xff80000030307808ULL, 0x000fc40004800000ULL,
0x000000083900720cULL, 0x080fe40003f86070ULL, 0x000000083700720cULL, 0x080fe40003f46070ULL,
0x000000083500720cULL, 0x000fe40003f26070ULL, 0x0000002131377812ULL, 0x040fe400078efcffULL,
0x0000002831357812ULL, 0x000fe400078efcffULL, 0xff80000016167808ULL, 0x000fc40004000000ULL,
0xff8000002b2b7808ULL, 0x000fe40004000000ULL, 0xff80000017177808ULL, 0x000fe40006000000ULL,
0xff8000002f2f7808ULL, 0x000fe40006000000ULL, 0x000000083700720cULL, 0x080fe40003f06070ULL,
0x000000083500720cULL, 0x000fe40003f86070ULL, 0x0000002931377812ULL, 0x000fc400078efcffULL,
0x0000003031357812ULL, 0x000fe400078efcffULL, 0xff8000001b1b7808ULL, 0x000fe40007000000ULL,
0xff8000002e2e7808ULL, 0x000fe40007000000ULL, 0xff8000001c1c7808ULL, 0x000fe40006800000ULL,
0xff8000002a2a7808ULL, 0x000fe40006800000ULL, 0x000000083700720cULL, 0x000fc40003fc6070ULL,
0x000000083500720cULL, 0x000fe40003fa6070ULL, 0x0000003131377812ULL, 0x040fe400078efcffULL,
0x0000003831357812ULL, 0x040fe400078efcffULL, 0x0000003931317812ULL, 0x000fe400078efcffULL,
0xff8000001d1d7808ULL, 0x000fe40005800000ULL, 0xff8000002c2c7808ULL, 0x000fc40005800000ULL,
0xff8000001e1e7808ULL, 0x000fe40005000000ULL, 0xff80000029297808ULL, 0x000fe40005000000ULL,
0xff8000001f1f7808ULL, 0x000fe40004800000ULL, 0xff8000002d2d7808ULL, 0x000fe40004800000ULL,
0x000000083700720cULL, 0x080fe40003f66070ULL, 0x000000083500720cULL, 0x000fc40003f46070ULL,
0x000000083100720cULL, 0x000fe40003f26070ULL, 0xff8000001a1a7808ULL, 0x000fe40004000000ULL,
0xff80000028287808ULL, 0x000fe40004000000ULL, 0xff80000018187808ULL, 0x000fe40006000000ULL,
0xff80000027277808ULL, 0x000fe40006000000ULL, 0xff80000019197808ULL, 0x000fc40007000000ULL,
0xff80000026267808ULL, 0x000fe40007000000ULL, 0xff8000000d0d7808ULL, 0x000fe40006800000ULL,
0xff80000025257808ULL, 0x000fe40006800000ULL, 0xff8000000e0e7808ULL, 0x000fe40005800000ULL,
0xff80000024247808ULL, 0x000fe40005800000ULL, 0xff80000020207808ULL, 0x000fc40005000000ULL,
0xff80000023237808ULL, 0x000fe40005000000ULL, 0xff80000021217808ULL, 0x000fe40004800000ULL,
0xff80000022227808ULL, 0x000fc40004800000ULL, 0x000000331000720bULL, 0x004fe20003f1e000ULL,
0x0000001fff397424ULL, 0x000fe200078e00ffULL, 0x000000141100720bULL, 0x000fe20003f3e000ULL,
0xffffffffff3a7424ULL, 0x000fe200078e00ffULL, 0x0000001033317208ULL, 0x000fe40004000000ULL,
0x0000001114087208ULL, 0x000fc40004800000ULL, 0x000000303100720bULL, 0x000fe40003f1e000ULL,
0x000000150800720bULL, 0x000fe40003f3e000ULL, 0x0000003130107208ULL, 0x000fe40004000000ULL,
0x0000000815117208ULL, 0x000fe40004800000ULL, 0x0000002b1000720bULL, 0x000fe40003f1e000ULL,
0x000000161100720bULL, 0x000fc40003f3e000ULL, 0x000000102b107208ULL, 0x000fe40004000000ULL,
0x0000001116087208ULL, 0x000fe40004800000ULL, 0x0000002f1000720bULL, 0x000fe40003f1e000ULL,
0x000000170800720bULL, 0x000fe40003f3e000ULL, 0x000000102f117208ULL, 0x000fe40004000000ULL,
0x0000000817087208ULL, 0x000fc40004800000ULL, 0x0000002e1100720bULL, 0x000fe40003f1e000ULL,
0x0000001b0800720bULL, 0x000fe40003f3e000ULL, 0x000000112e117208ULL, 0x000fe40004000000ULL,
0x000000081b317208ULL, 0x000fe40004800000ULL, 0x0000002a1100720bULL, 0x000fe40003f1e000ULL,
0x0000001c3100720bULL, 0x000fc40003f3e000ULL, 0x000000112a117208ULL, 0x000fe40004000000ULL,
0x000000311c087208ULL, 0x000fe40004800000ULL, 0x0000002c1100720bULL, 0x000fe40003f1e000ULL,
0x0000001d0800720bULL, 0x000fe40003f3e000ULL, 0x000000112c107208ULL, 0x000fe40004000000ULL,
0x000000081d117208ULL, 0x000fc40004800000ULL, 0x000000291000720bULL, 0x000fe40003f1e000ULL,
0x0000001e1100720bULL, 0x000fe40003f3e000ULL, 0x0000001029107208ULL, 0x000fe40004000000ULL,
0x000000111e087208ULL, 0x000fe40004800000ULL, 0x0000002d1000720bULL, 0x000fe40003f1e000ULL,
0x0000001f0800720bULL, 0x000fc40003f3e000ULL, 0x000000102d117208ULL, 0x000fe40004000000ULL,
0x000000081f317208ULL, 0x000fe40004800000ULL, 0x000000281100720bULL, 0x000fe40003f1e000ULL,
0x0000001a3100720bULL, 0x000fe40003f3e000ULL, 0x0000001128087208ULL, 0x000fe40004000000ULL,
0x000000311a317208ULL, 0x000fc40004800000ULL, 0x000000270800720bULL, 0x000fe40003f1e000ULL,
0x000000183100720bULL, 0x000fe40003f3e000ULL, 0x0000000827117208ULL, 0x000fe40004000000ULL,
0x0000003118087208ULL, 0x000fe40004800000ULL, 0x000000261100720bULL, 0x000fe40003f1e000ULL,
0x000000190800720bULL, 0x000fc40003f3e000ULL, 0x0000001126107208ULL, 0x000fe40004000000ULL,
0x0000000819087208ULL, 0x000fe40004800000ULL, 0x000000251000720bULL, 0x000fe40003f1e000ULL,
0x0000000d0800720bULL, 0x000fe40003f3e000ULL, 0x0000001025117208ULL, 0x000fe40004000000ULL,
0x000000080d317208ULL, 0x000fc40004800000ULL, 0x000000241100720bULL, 0x000fe40003f1e000ULL,
0x0000000e3100720bULL, 0x000fe40003f3e000ULL, 0x0000001124087208ULL, 0x000fe40004000000ULL,
0x000000310e317208ULL, 0x000fe40004800000ULL, 0x000000230800720bULL, 0x000fe40003f1e000ULL,
0x000000203100720bULL, 0x000fc40003f3e000ULL, 0x0000000823117208ULL, 0x000fe40004000000ULL,
0x0000003120087208ULL, 0x000fe40004800000ULL, 0x000000221100720bULL, 0x000fe40003f1e000ULL,
0x000000210800720bULL, 0x000fe40003f3e000ULL, 0x0000001122327208ULL, 0x000fe40004000000ULL,
0x0000000821367208ULL, 0x000fe20004800000ULL, 0x000014d27f007947ULL, 0x000fec000b800000ULL,
0x0c401f0032087f89ULL, 0x0004e400000e0000ULL, 0x000000083200720bULL, 0x008fc80003f1e000ULL,
0x0000003208387208ULL, 0x000fe20004000000ULL, 0x000014e27f007947ULL, 0x000fea000b800000ULL,
0x0c401f0036087f89ULL, 0x000ee800000e0000ULL, 0x0c401f0012117f89ULL, 0x000f2800000e0000ULL,
0x0c401f0013107f89ULL, 0x000e6200000e0000ULL, 0x000000083600720bULL, 0x008fc40003f1e000ULL,
0x000000111200720bULL, 0x010fe40003f3e000ULL, 0x0000003608327208ULL, 0x006fe40004000000ULL,
0x0000001211347208ULL, 0x000fe40004800000ULL, 0x0c201f0038117f89ULL, 0x000e6200000e0000ULL,
0x000000101300720bULL, 0x000fc60003f1e000ULL, 0x0c201f0032357f89ULL, 0x000ea200000e0000ULL,
0x0000001310087208ULL, 0x000fc60004000000ULL, 0x0c201f0034377f89ULL, 0x000ee800000e0000ULL,
0x0c201f0008317f89ULL, 0x0002e400000e0000ULL, 0x000000113800720bULL, 0x002fe40003f1e000ULL,
0x000000353200720bULL, 0x004fe40003f3e000ULL, 0x0000003811107208ULL, 0x000fc40004000000ULL,
0x000000373400720bULL, 0x008fe40003f5e000ULL, 0x0000003235117208ULL, 0x000fe40004800000ULL,
0x0000003437127208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b10327820ULL, 0x002fe20000410000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000302ff7812ULL, 0x000fe4000780c0ffULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b2a2a7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b2c137823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010832ULL,
0x0000002b00347308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b29377823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b282c7823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010832ULL,
0x3fb8aa3b2d297823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010832ULL,
0x0000002a00357308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b272b7823ULL, 0x102fe20000010832ULL,
0x3fb8aa3b22277823ULL, 0x100fe20000010832ULL, 0x3fb8aa3b11227820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b25287823ULL, 0x000fe20000010832ULL, 0x000000310800720bULL, 0x004fc40003f3e000ULL,
0x3fb8aa3b14147823ULL, 0x100fe20000010822ULL, 0x3fb8aa3b15157823ULL, 0x100fe20000010822ULL,
0x3fb8aa3b16167823ULL, 0x100fe20000010822ULL, 0x3fb8aa3b17177823ULL, 0x000fe20000010822ULL,
0x0000001300367308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b232a7823ULL, 0x008fe20000010832ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010822ULL, 0x3fb8aa3b1c1c7823ULL, 0x100fe20000010822ULL,
0x3fb8aa3b1d1d7823ULL, 0x100fe20000010822ULL, 0x3fb8aa3b1e1e7823ULL, 0x100fe20000010822ULL,
0x3fb8aa3b1f397823ULL, 0x100fe20000010822ULL, 0x3fb8aa3b0d0d7823ULL, 0x000fe20000010822ULL,
0x0000001400237308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b24137823ULL, 0x002fe20000010832ULL,
0x3fb8aa3b0e0e7823ULL, 0x000fcc0000010822ULL, 0x0000001500247308ULL, 0x000e700000000800ULL,
0x0000001600257308ULL, 0x000ff00000000800ULL, 0x0000001700327308ULL, 0x000ea20000000800ULL,
0x000000232415723eULL, 0x002fe200000000ffULL, 0x3c003c00ff247424ULL, 0x000fe200078e00ffULL,
0x3fb8aa3b1a237823ULL, 0x000fca0000010822ULL, 0x0000003300337308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000e620000000800ULL, 0x000000253217723eULL, 0x004fe200000000ffULL,
0x3c003c00ff257424ULL, 0x000fe200078e00ffULL, 0x3fb8aa3b19327823ULL, 0x000fca0000010822ULL,
0x0000002f002f7308ULL, 0x000ea20000000800ULL, 0x000000333014723eULL, 0x002fce00000000ffULL,
0x0000001c00387308ULL, 0x000fe20000000800ULL, 0x000000342f16723eULL, 0x004fce00000000ffULL,
0x0000001d002d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b182f7823ULL, 0x000fce0000010822ULL,
0x0000001e003a7308ULL, 0x0003f00000000800ULL, 0x0000001b001b7308ULL, 0x000ea20000000800ULL,
0x00000024141c723cULL, 0x002f6e00000018ffULL, 0x0000002e002e7308ULL, 0x000e700000000800ULL,
0x0000003700377308ULL, 0x000ee20000000800ULL, 0x0000001b3819723eULL, 0x004fc400000000ffULL,
0x0000002d3a1b723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b202d7823ULL, 0x000fe20000010822ULL,
0x0000002e3518723eULL, 0x002fc600000000ffULL, 0x0000002300307308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b212e7823ULL, 0x000fe20000010822ULL, 0x00000036371a723eULL, 0x008fcc00000000ffULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x00000002ff377819ULL, 0x000fc80000011602ULL,
0x0000000137337810ULL, 0x040fe20007ffe0ffULL, 0x000000241820723cULL, 0x022b62000000181cULL,
0x00000008373a7824ULL, 0x040fe200078e00ffULL, 0x0000002c002c7308ULL, 0x000e620000000800ULL,
0x0000000837347824ULL, 0x040fe200078e00ffULL, 0x0000000237357810ULL, 0x040fe20007ffe0ffULL,
0x0000000837367824ULL, 0x040fe200078e00ffULL, 0x00000008373e7810ULL, 0x040fe20007ffe0ffULL,
0x00000008371f7824ULL, 0x060fe200078e00ffULL, 0x00000003371c7810ULL, 0x040fe40007ffe0ffULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x00000004371d7810ULL, 0x000fc40007ffe0ffULL,
0xfffffff81f387812ULL, 0x000fe400078ee21cULL, 0xfffffff83a3a7812ULL, 0x000fe400078ee21dULL,
0xfffffff834347812ULL, 0x000fe200078ee233ULL, 0x0000002600267308ULL, 0x000ea20000000800ULL,
0x000000292c1c723eULL, 0x002fe200000000ffULL, 0x00000008372c7824ULL, 0x040fe200078e00ffULL,
0x0000000537297810ULL, 0x000fe20007ffe0ffULL, 0x000000083e337824ULL, 0x000fe200078e00ffULL,
0xfffffff836367812ULL, 0x000fc400078ee235ULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee229ULL,
0x0000003900397308ULL, 0x000e620000000800ULL, 0xfffffff8333e7812ULL, 0x000fce00078ee23eULL,
0x0000002f002f7308ULL, 0x000fe20000000800ULL, 0x0000002b261e723eULL, 0x004fe200000000ffULL,
0x0000000837267824ULL, 0x040fe200078e00ffULL, 0x00000006372b7810ULL, 0x000fc80007ffe0ffULL,
0xfffffff826267812ULL, 0x000fe200078ee237ULL, 0x0000003200327308ULL, 0x000ea20000000800ULL,
0x00000039301d723eULL, 0x002fe200000000ffULL, 0x0000000837307824ULL, 0x000fca00078e00ffULL,
0xfffffff830307812ULL, 0x000fe200078ee22bULL, 0x0000002800287308ULL, 0x000fe20000000800ULL,
0x0000002f321f723eULL, 0x004fce00000000ffULL, 0x0000001300137308ULL, 0x000e620000000800ULL,
0x0000000837327824ULL, 0x040fe200078e00ffULL, 0xffffffff372f7810ULL, 0x000fe20007ffe0ffULL,
0x000000241c20723cULL, 0x000f660000001820ULL, 0xfffffff832327812ULL, 0x000fe400078ee22fULL,
0x0000002a002a7308ULL, 0x000ff00000000800ULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0x000000281328723eULL, 0x002fc400000000ffULL, 0x000090003c137811ULL, 0x000fca00078e58ffULL,
0x0000000d000d7308ULL, 0x000fe20000000800ULL, 0x0000001026267824ULL, 0x100fe400078e0213ULL,
0x0000001034347824ULL, 0x100fe400078e0213ULL, 0x0000001036367824ULL, 0x100fe400078e0213ULL,
0x0000001038387824ULL, 0x100fe200078e0213ULL, 0x0000000e000e7308ULL, 0x000e620000000800ULL,
0x0000002a272a723eULL, 0x004fe200000000ffULL, 0x000000103a3a7824ULL, 0x000fc400078e0213ULL,
0x000000102c2c7824ULL, 0x100fe400078e0213ULL, 0x0000001030307824ULL, 0x100fe400078e0213ULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x0000001032327824ULL, 0x100fe400078e0213ULL,
0x000000103e3e7824ULL, 0x000fe200078e0213ULL, 0x0000000831137208ULL, 0x000fc80004800000ULL,
0x0000002e002e7308ULL, 0x000ea20000000800ULL, 0x0000000d0e29723eULL, 0x002fe400000000ffULL,
0x0000000c0c0d7812ULL, 0x000fca00078ec0ffULL, 0x0000000126277824ULL, 0x000fe400078e020dULL,
0x000000010d347824ULL, 0x040fe400078e0234ULL, 0x000000010d367824ULL, 0x040fe200078e0236ULL,
0x0000001427007388ULL, 0x0003e20000000800ULL, 0x000000010d387824ULL, 0x040fe200078e0238ULL,
0x0000002d2e2b723eULL, 0x004fe200000000ffULL, 0x000000010d3a7824ULL, 0x040fe200078e023aULL,
0x0000001634007388ULL, 0x0003e20000000800ULL, 0x000000010d2c7824ULL, 0x000fc400078e022cULL,
0x000000010d307824ULL, 0x040fe200078e0230ULL, 0x0000001836007388ULL, 0x0003e20000000800ULL,
0x000000242820723cULL, 0x020f620000001820ULL, 0x000000010d327824ULL, 0x040fe400078e0232ULL,
0x000000010d3e7824ULL, 0x000fe200078e023eULL, 0x0000001a38007388ULL, 0x0003e80000000800ULL,
0x0000001c3a007388ULL, 0x0003e80000000800ULL, 0x0000001e2c007388ULL, 0x0003e80000000800ULL,
0x0000002830007388ULL, 0x0003e80000000800ULL, 0x0000002a32007388ULL, 0x0003e80000000800ULL,
0x000000153e007388ULL, 0x0003e20000000800ULL, 0x000000ffff217224ULL, 0x020fc600078e0022ULL,
0x0004001734007388ULL, 0x0003e80000000800ULL, 0x0004001936007388ULL, 0x0003e80000000800ULL,
0x0004001b38007388ULL, 0x0003e80000000800ULL, 0x0004001d3a007388ULL, 0x0003e80000000800ULL,
0x0004001f2c007388ULL, 0x0003e80000000800ULL, 0x0004002930007388ULL, 0x0003e80000000800ULL,
0x0004002b32007388ULL, 0x0003e80000000800ULL, 0x00f000100a008388ULL, 0x0003e80000000c00ULL,
0x00f200200a008388ULL, 0x0003e20000000a00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000007ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080007ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100007ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000109097810ULL, 0x000fe20007ffe0ffULL, 0x0000180007ff7f8cULL, 0x0003e6000c80043fULL,
0x0000000f0900720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffffc79000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff107807ULL, 0x008fe40004000000ULL, 0x0001027000177802ULL, 0x000fc40000000f00ULL,
0x00000c7000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff107224ULL, 0x000fe200078e0016ULL,
0xffff1c2000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40004000000ULL,
0x000102c000177802ULL, 0x000fc40000000f00ULL, 0x00000c2000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0016ULL, 0xffff1c9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x008fe200078e001dULL, 0x00010310001c7802ULL, 0x000fc40000000f00ULL,
0x00000b8000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff1d5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e001dULL,
0x00010360001c7802ULL, 0x000fc40000000f00ULL, 0x00000b3000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff1e7000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x000103c0001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0014ULL, 0x00000ad000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e0017ULL, 0xffff227000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0000ULL, 0x00010420001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff177224ULL, 0x000fc400078e0013ULL, 0x00000a7000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e0017ULL, 0xffff224000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x004fe40004000000ULL, 0x0001047000177802ULL, 0x000fc40000000f00ULL,
0x00000a7000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff157224ULL, 0x000fe200078e0016ULL,
0xffff42c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40004000000ULL,
0x000104c000177802ULL, 0x000fc40000000f00ULL, 0x00000a2000007944ULL, 0x008fea0003c00000ULL,
0xffff432000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x00010500001c7802ULL, 0x000fc40000000f00ULL, 0x0000099000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff440000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00010550001c7802ULL, 0x000fc40000000f00ULL,
0x0000094000007944ULL, 0x00afea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff451000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x000105b0001c7802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fc400078e0013ULL,
0x000008e000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff037224ULL, 0x004fe200078e0017ULL,
0xffff497000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x00010600001c7802ULL, 0x000fc40000000f00ULL, 0x0000089000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e0017ULL, 0xffff495000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x004fe40004000000ULL, 0x0001065000177802ULL, 0x000fc40000000f00ULL,
0x0000089000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff147224ULL, 0x000fe200078e0016ULL,
0xffff66e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe40004000000ULL,
0x000106a000177802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0016ULL, 0xffff672000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0016ULL, 0x000106f0001c7802ULL, 0x000fc40000000f00ULL,
0x000007a000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff680000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0016ULL,
0x00010740001c7802ULL, 0x000fc40000000f00ULL, 0x0000075000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff691000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x000107a0001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0013ULL, 0x000006f000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e0017ULL, 0xffff6d2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x000107f0001c7802ULL, 0x000fc40000000f00ULL,
0x000006a000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0017ULL,
0xffff6d0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x002fe40004000000ULL,
0x0001084000177802ULL, 0x000fc40000000f00ULL, 0x000006a000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0016ULL, 0xffff8af000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe40004000000ULL, 0x0001089000177802ULL, 0x000fc40000000f00ULL,
0x0000065000007944ULL, 0x008fea0003c00000ULL, 0xffff8b4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x000108d0001c7802ULL, 0x000fc40000000f00ULL,
0x000005c000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff8c2000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x00010920001c7802ULL, 0x000fc40000000f00ULL, 0x0000057000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff8d3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00010980001c7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fc400078e0013ULL, 0x0000051000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff037224ULL, 0x004fe200078e0017ULL, 0xffff915000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x000109d0001c7802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0017ULL,
0xffff913000007947ULL, 0x000fea000383ffffULL, 0x00000002ff377424ULL, 0x000fe200078e00ffULL,
0x00010a2000347802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x002fea0003c00000ULL,
0x000000ffff087224ULL, 0x004fe200078e0031ULL, 0xffffeaf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff327224ULL, 0x006fe200078e0036ULL, 0x00010a8000347802ULL, 0x000fe20000000f00ULL,
0x00000002ff377424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x000fea0003c00000ULL,
0x000000313600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0012ULL,
0x00010ae000347802ULL, 0x000fe20000000f00ULL, 0x00000002ff377424ULL, 0x000fe200078e00ffULL,
0x0000003631367208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000311200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0013ULL,
0x00010b4000347802ULL, 0x000fe20000000f00ULL, 0x00000002ff377424ULL, 0x000fe200078e00ffULL,
0x0000001231127208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000311300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0038ULL,
0x00010ba000347802ULL, 0x000fe20000000f00ULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000001331087208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000313800720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0036ULL,
0x00010c0000347802ULL, 0x000fe20000000f00ULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000003831107208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000313600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0012ULL,
0x00010c6000347802ULL, 0x000fe20000000f00ULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000003631117208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000311200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff327224ULL, 0x002fe200078e0008ULL,
0x00010cc000347802ULL, 0x000fe20000000f00ULL, 0x00000001ff377424ULL, 0x000fe200078e00ffULL,
0x0000001231127208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffe9c000007947ULL, 0x000fea000383ffffULL, 0x0180000007007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000700008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000007027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffef1b002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff357424ULL, 0x000fe200078e00ffULL,
0x0000003a00007348ULL, 0x000fe80003800000ULL, 0x0c00003732317389ULL, 0x0002a200000e0039ULL,
0xfffef17034007950ULL, 0x000fea0003c3ffffULL, 0x0000004400007348ULL, 0x000fe80003800000ULL,
0x0000001017177389ULL, 0x0002a200000e0049ULL, 0x00000000ff117424ULL, 0x000fc400078e00ffULL,
0x000000ffff107224ULL, 0x002fc800078e001cULL, 0xfffef12010007950ULL, 0x000fea0003c3ffffULL,
0x000000011000780cULL, 0x000fe20003f05070ULL, 0x0000004700007348ULL, 0x000fe80003800000ULL,
0x00000000ff117424ULL, 0x000fd000078e00ffULL, 0x0000000000107806ULL, 0x000fc800040e0100ULL,
0x0000004710167212ULL, 0x000fe200078ec0ffULL, 0x000000ffff107224ULL, 0x000fc800078e0017ULL,
0xfffef0b010007950ULL, 0x000fea0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000200000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005deULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x0000000000000328ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000cf0ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000db0ULL, 0x0000000000000784ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001538ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001548ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015d8ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015dcULL, 0x00000000000001a8ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000011000ULL, 0x8f00001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012800ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000012850ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000012bd0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000015d8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000011228ULL, 0x0000000000011228ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000012800ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000012bd0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_86_cubin_len = 76976;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
