/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000011da8ULL, 0x0000000000011a28ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x766e2e0000000000ULL, 0x2e6c61626f6c672eULL, 0x65722e0074696e69ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6e6f632e766e2e00ULL, 0x000033746e617473ULL, 0x536d656d73000000ULL, 0x2e766e2e00657a69ULL,
0x692e6c61626f6c67ULL, 0x4e5a5a5f0074696eULL, 0x7473336164756334ULL, 0x5f5f38345f5f3364ULL,
0x31326c6961746564ULL, 0x676e6f7274735f5fULL, 0x726564726f5f7265ULL, 0x696945616475635fULL,
0x726f66785f5f3745ULL, 0x374b4e5a5a5f006dULL, 0x4944327961727241ULL, 0x326a4c45326a4c66ULL,
0x624c497461324545ULL, 0x6a664b5245454530ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x326a4c66495f5349ULL, 0x6a4c4545326a4c45ULL,
0x324545386a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f30534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x32666c61685f5f37ULL,
0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL,
0x316a4c4545346a4cULL, 0x324545386a4c4536ULL, 0x454531624c497461ULL, 0x6a6a5f31534b5245ULL,
0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL,
0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL, 0x6132454536316a4cULL, 0x45454531624c4974ULL,
0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4534366a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45326a4c45326a4cULL,
0x316a4c45316a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL,
0x6a4c4974614d6e49ULL, 0x4c4545316a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL,
0x4432796172724137ULL, 0x6e4974736e493949ULL, 0x45346a4c4974614dULL, 0x326a4c4545326a4cULL,
0x61324545316a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4532336a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL,
0x4974614d6e497473ULL, 0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL,
0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL,
0x7961727241374b4eULL, 0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x324545386a4c4538ULL,
0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL,
0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4536316a4c454534ULL,
0x7461324545386a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x5f5f240000000000ULL,
0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL, 0x665f6e725f706372ULL,
0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL,
0x65722e0061686d5fULL, 0x2e747865742e616cULL, 0x6d5f6c656e72656bULL, 0x6e72656b24006168ULL,
0x732461686d5f6c65ULL, 0x42657479426d656dULL, 0x756265642e006675ULL, 0x00656d6172665f67ULL,
0x6265642e6c65722eULL, 0x656d6172665f6775ULL, 0x642e616c65722e00ULL, 0x6172665f67756265ULL,
0x632e766e2e00656dULL, 0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x000000000061686dULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000098ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000b0003000000a1ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b0001000000b1ULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000b0001000000efULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000b000100000128ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000b00010000016fULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000b0001000001b1ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b0001000001f7ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000b00010000023eULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b000100000284ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000b0001000002d2ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b000100000320ULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000b00010000036eULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000b0001000003b4ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000b000100000402ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000b000100000447ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000a0022000004a2ULL, 0x0000000000010450ULL, 0x0000000000000230ULL, 0x0004000300000518ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL, 0x0000000000000000ULL,
0x0000000000010680ULL, 0x000d000300000548ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x80810c0fffffffffULL,
0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0001045000000000ULL, 0x0000740400000000ULL, 0x0000288080810c00ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL, 0x0001045000000000ULL,
0x0000023000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x0000001600082f04ULL, 0x000823040000007aULL, 0x0000000000000014ULL, 0x0000001400081204ULL,
0x0008110400000000ULL, 0x0000000000000014ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0004370400000000ULL, 0x000c17040000007bULL,
0x0040000600000000ULL, 0x000c17040021f000ULL, 0x0038000500000000ULL, 0x000c17040021f000ULL,
0x0030000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL, 0x000c17040061f000ULL,
0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL, 0x000c17040021f000ULL,
0x0000000000000000ULL, 0x00801b030011f000ULL, 0xffffffff00942904ULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x0000012000942804ULL, 0x00000770000001a0ULL, 0x0000210000002070ULL,
0x00002300000021c0ULL, 0x0000281000002800ULL, 0x000044e000004480ULL, 0x00004720000045e0ULL,
0x00004b9000004b80ULL, 0x00006640000065e0ULL, 0x0000688000006740ULL, 0x00006cc000006cb0ULL,
0x000087a000008740ULL, 0x000089e0000088a0ULL, 0x00008db000008da0ULL, 0x00009e2000009e10ULL,
0x0000f9300000f880ULL, 0x0000fc000000fb60ULL, 0x0000fde00000fc20ULL, 0x000101700000ffa0ULL,
0x0000022004303904ULL, 0x00017600000000ffULL, 0x0000030000040100ULL, 0x0001760800000006ULL,
0x00000410003f0100ULL, 0x0001768800000006ULL, 0x00000530003f0100ULL, 0x000176a800000003ULL,
0x00000640003f0100ULL, 0x000176c800000002ULL, 0x000008c0003f0100ULL, 0x000176000000000eULL,
0x000009d0003f0107ULL, 0x0001768800000003ULL, 0x00001210003f0101ULL, 0x00000000000000ffULL,
0x0000124000040107ULL, 0x00000000000000ffULL, 0x000012c000040101ULL, 0x0000002000000038ULL,
0x000013a0003f0101ULL, 0x000176c800000034ULL, 0x00001520003f0109ULL, 0x000176c800000034ULL,
0x00001d40003f0109ULL, 0x000176a800000054ULL, 0x00001db0003f0107ULL, 0x000176a800000054ULL,
0x00001dc0003f0101ULL, 0x0001760800000032ULL, 0x00001e10003f0101ULL, 0x0001760800000031ULL,
0x00001f80003f0109ULL, 0x0001760800000031ULL, 0x000024b0003f0109ULL, 0x000176a80000003aULL,
0x00002620003f0109ULL, 0x000176a80000003aULL, 0x00003690003f0109ULL, 0x0000000000000004ULL,
0x000036e0003f0101ULL, 0x0001768800000036ULL, 0x00003820003f0101ULL, 0x0000000000000004ULL,
0x00003990003f0109ULL, 0x0000000000000004ULL, 0x000041d0003f0109ULL, 0x000176a80000004dULL,
0x00004220003f0107ULL, 0x000176a80000004dULL, 0x00004230003f0101ULL, 0x0001762800000030ULL,
0x00004280003f0101ULL, 0x0001762800000033ULL, 0x000043f0003f0109ULL, 0x0001762800000033ULL,
0x00004900003f0109ULL, 0x000176a800000033ULL, 0x00004a80003f0109ULL, 0x000176a80000003bULL,
0x00005940003f0109ULL, 0x0000000000000004ULL, 0x00005960003f0101ULL, 0x0001769000000036ULL,
0x00005a60003f0101ULL, 0x0000000000000004ULL, 0x00005bd0003f0109ULL, 0x0000000000000004ULL,
0x00006300003f0109ULL, 0x00000000000000ffULL, 0x000063c000040107ULL, 0x000176a800000031ULL,
0x000063d0003f0101ULL, 0x000176480000003bULL, 0x000063f0003f0101ULL, 0x000176480000003bULL,
0x00006560003f0109ULL, 0x000176480000003bULL, 0x00006a30003f0109ULL, 0x000176a80000004dULL,
0x00006ba0003f0109ULL, 0x000176a80000004dULL, 0x00007a30003f0109ULL, 0x0000000000000004ULL,
0x00007a60003f0101ULL, 0x0001769800000036ULL, 0x00007be0003f0101ULL, 0x000176c800000038ULL,
0x00007d50003f0109ULL, 0x000176c800000038ULL, 0x00008480003f0109ULL, 0x00000000000000ffULL,
0x0000850000050107ULL, 0x000176a80000004dULL, 0x00008520003f0101ULL, 0x0001766800000041ULL,
0x00008550003f0101ULL, 0x0001766800000041ULL, 0x000086c0003f0109ULL, 0x0001766800000041ULL,
0x00008ba0003f0109ULL, 0x000176a80000004fULL, 0x00008d10003f0109ULL, 0x000176a80000004fULL,
0x00009a70003f0109ULL, 0x0000000000000004ULL, 0x00009a90003f0101ULL, 0x000176a000000036ULL,
0x0000a980003f0101ULL, 0x000176000000000eULL, 0x0000bfd0003f0101ULL, 0x000176000000000eULL,
0x0000c140003f0109ULL, 0x000176000000000eULL, 0x0000c320003f0109ULL, 0x000176000000000eULL,
0x0000c340003f0101ULL, 0x000176000000000eULL, 0x0000c4b0003f0109ULL, 0x000176000000000eULL,
0x0000edd0003f0109ULL, 0x0001768800000005ULL, 0x0000efa0003f0101ULL, 0x0001768800000005ULL,
0x0000f110003f0109ULL, 0x0001768800000005ULL, 0x000103f0003f0109ULL, 0x0001760800000007ULL,
0x00010400003f0101ULL, 0x0001761000000007ULL, 0x00010410003f0101ULL, 0x0001761800000007ULL,
0x00010420003f0101ULL, 0x0001762000000007ULL, 0x00053803003f0101ULL, 0x0000a67000141c04ULL,
0x0000c4e00000a8f0ULL, 0x000104400000c580ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL,
0x0000000000041e04ULL, 0x00080a0400481903ULL, 0x0048021000000017ULL, 0x00000000000000bcULL,
0x0000001600000002ULL, 0x0000000000010450ULL, 0x0000000000000044ULL, 0x0000001600000002ULL,
0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001600000002ULL, 0x0000000000000000ULL,
0x0000000000017700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e640000000800ULL, 0x0000000000067919ULL, 0x000ea20000002300ULL,
0x0000010000047ab9ULL, 0x000fe20000000800ULL, 0x00008400ff107b82ULL, 0x000ee20000000800ULL,
0x0000022000007945ULL, 0x000fe20003800000ULL, 0x0000000000037919ULL, 0x000ea20000002200ULL,
0x00000000003d7919ULL, 0x000f2a0000002100ULL, 0x00008800ff047b82ULL, 0x000e620000000a00ULL,
0x00000000000f7919ULL, 0x000e620000002700ULL, 0x00000000000d7919ULL, 0x000e6c0000000000ULL,
0x00000000000679c3ULL, 0x000e620000002600ULL, 0x0000000000117919ULL, 0x000e620000008800ULL,
0x0000000406007c24ULL, 0x004fe2000f8e0203ULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000400027c24ULL, 0x110fe2000f8e023dULL, 0x00000005ff3d7819ULL, 0x000fc8000001163dULL,
0x0000007f0200780cULL, 0x040fe40003f84070ULL, 0x000000ff0200720cULL, 0x040fe20003f05270ULL,
0x00001fff3d3d7589ULL, 0x000ee200000e0000ULL, 0x0000000f0200780cULL, 0x040fe40003f24070ULL,
0x000000030200780cULL, 0x040fe40003f64070ULL, 0x000000010200780cULL, 0x000fca0003f44070ULL,
0x000000000003c919ULL, 0x000ea20000008800ULL, 0x000004000000c802ULL, 0x000fe20000000f00ULL,
0xff317217ff08c424ULL, 0x000fc600078e00ffULL, 0x000006540303c816ULL, 0x004fe40000000000ULL,
0x00001fff06007589ULL, 0x00026600000e0000ULL, 0x000000040203c824ULL, 0x000fe200078e0203ULL,
0x0000000000240947ULL, 0x008fec0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x001fff0000087882ULL, 0x000fe20000000000ULL,
0x7ffc000000097882ULL, 0x000fe20000000000ULL, 0x0000065405047896ULL, 0x004fe20008000004ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000000000073c6ULL, 0x000e740000000000ULL,
0x01760008043f75b2ULL, 0x0002640008000100ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000381947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402067c11ULL, 0x002fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000060712caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01760804073f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000383947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffb000000057882ULL, 0x000fc60000000000ULL, 0x0000000402067c11ULL, 0x002fe2000f8e18ffULL,
0x001ffec000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000060712caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01768804073f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x017400080300c388ULL, 0x0005e20000000800ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000383947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ee20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x008fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000402037c11ULL, 0x004fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x002fca0000000000ULL,
0x00000000030712caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x0176a804073f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ee20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x008fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000402027c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x004fca0000000000ULL, 0x00000000020712caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000ea40000000000ULL, 0x0176c804073f75b2ULL, 0x0004b00008000100ULL,
0xfffffffd00e81947ULL, 0x004fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000400037824ULL, 0x006fe200078e023dULL, 0x0000000306047899ULL, 0x000fe2000800063fULL,
0x00000004ff0a7819ULL, 0x000fe2000001160dULL, 0x0000000810027824ULL, 0x000fe200078e00ffULL,
0x00000400000e7802ULL, 0x000fe20000000f00ULL, 0x0000000203037824ULL, 0x000fe200078e00ffULL,
0x0000820000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000402027e24ULL, 0x000fe2000f8e020fULL,
0x00000654110e7816ULL, 0x000fe2000000000eULL, 0x0000000103077824ULL, 0x000fe200078e020aULL,
0x0000000803067848ULL, 0x000fe20007fe0000ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000001020b7824ULL, 0x000fe200078e0207ULL, 0x000000000e0472caULL, 0x000fe200000e0000ULL,
0x000000100d027824ULL, 0x000fe200078e00ffULL, 0x00008c00ff087b82ULL, 0x000e620000000a00ULL,
0x0000000106037824ULL, 0x000fc400078e0a03ULL, 0x000001000b047825ULL, 0x000fe200078e0004ULL,
0x000000f002117812ULL, 0x000fe400078ec0ffULL, 0x000000030a00720cULL, 0x000fe20003f06070ULL,
0x00000001070b7824ULL, 0x040fe200078e020dULL, 0x0000001104067210ULL, 0x000fe20007f3e0ffULL,
0x00000010070c7824ULL, 0x000fe400078e00ffULL, 0x0001760004047890ULL, 0x000fe4000fffe03fULL,
0x000000ffff077224ULL, 0x000fe200008e0605ULL, 0xfffffff00c0b7812ULL, 0x000fca00078ee20bULL,
0x000000100b0b7824ULL, 0x000fca00078e020eULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000060b7faeULL, 0x0005e2000c101c48ULL, 0x000000040f047825ULL, 0x002fe200078e0008ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffffff79a7ULL, 0x000fe20008200404ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a84ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0000000804377981ULL, 0x000ee2000c1e1900ULL, 0x000000ff0000720cULL, 0x000fe20003f05270ULL,
0x000000ff37007836ULL, 0x008fca0000000000ULL, 0x00000008ff357819ULL, 0x000fce0000011600ULL,
0x0000009c00ec8947ULL, 0x000fea0003800000ULL, 0x000000083d0c7824ULL, 0x000fe200078e00ffULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x00000004ff047424ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x004fe2000001163dULL, 0x000000010e037824ULL, 0x000fe200078e020cULL,
0x00008e0000047ab9ULL, 0x000fe20000000800ULL, 0x000000020f097824ULL, 0x000fe200078e00ffULL,
0x000000013d0f7812ULL, 0x000fe200078ec0ffULL, 0x0176880403ff79a7ULL, 0x0003e2000850003fULL,
0x000000200b0a7824ULL, 0x000fe400078e00ffULL, 0x0000000610047c36ULL, 0x002fc80008000000ULL,
0x0000001009097224ULL, 0x000fc800078e0204ULL, 0x0000000409007c24ULL, 0x000fe2000f8e020aULL,
0x0000000000f40947ULL, 0x000fec0003800000ULL, 0x0000000a37037248ULL, 0x000fe20007fe0000ULL,
0x000000100f047824ULL, 0x000fe200078e00ffULL, 0x00000003ff057819ULL, 0x000fe2000001160dULL,
0x00008a00ff107b82ULL, 0x000e620000000a00ULL, 0x00000070021b7812ULL, 0x000fe200078ec0ffULL,
0x0000000103037824ULL, 0x000fe400078e0a0aULL, 0x0000000104067824ULL, 0x000fe400078e0205ULL,
0x0000000405127836ULL, 0x000fe20000000000ULL, 0x0000000403037248ULL, 0x000fe20007fe0000ULL,
0x0000000806087824ULL, 0x000fe200078e00ffULL, 0x0000000d06077210ULL, 0x000fe20007ffe0ffULL,
0x0000000c05147836ULL, 0x000fc40000000000ULL, 0x0000000103037824ULL, 0x000fe200078e0a04ULL,
0xfffffff808087812ULL, 0x000fe200078ee207ULL, 0x0000000805077836ULL, 0x000fc60000000000ULL,
0x000000031200720cULL, 0x080fe20003f46070ULL, 0x0000000104127824ULL, 0x040fe200078e0212ULL,
0x000000030500720cULL, 0x080fe20003f66070ULL, 0x0000000104137824ULL, 0x000fe200078e0207ULL,
0x000000031400720cULL, 0x080fe20003f06070ULL, 0x0000000112057824ULL, 0x040fe200078e020dULL,
0x000000030700720cULL, 0x000fe20003f26070ULL, 0x0000000812167824ULL, 0x000fe400078e00ffULL,
0x0000000104047824ULL, 0x000fe400078e0214ULL, 0x0000000100077824ULL, 0x040fe200078e0212ULL,
0xfffffff816147812ULL, 0x000fe200078ee205ULL, 0x0000000100057824ULL, 0x000fc400078e0206ULL,
0x0000000100157824ULL, 0x040fe400078e0213ULL, 0x0000000100177824ULL, 0x000fe400078e0204ULL,
0x0000000113007824ULL, 0x140fe400078e020dULL, 0x0000000813137824ULL, 0x000fe400078e00ffULL,
0x0000000104067824ULL, 0x040fe400078e020dULL, 0x0000000804197824ULL, 0x000fe200078e00ffULL,
0xfffffff813007812ULL, 0x000fe200078ee200ULL, 0x000020000b037824ULL, 0x000fc400078e020eULL,
0x0000008005047825ULL, 0x002fe200078e0010ULL, 0xfffffff819127812ULL, 0x000fc600078ee206ULL,
0x0001300003137836ULL, 0x000fe20000000000ULL, 0x0000001b04047210ULL, 0x000fe20007f9e0ffULL,
0x0000008007027825ULL, 0x000fc800078e0010ULL, 0x0000008015067825ULL, 0x000fc800078e0010ULL,
0x0000008017107825ULL, 0x000fe200078e0010ULL, 0x0000001b06067210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff057224ULL, 0x000fe200020e0605ULL, 0x0000001b02027210ULL, 0x000fe20007f9e0ffULL,
0x0000001008157824ULL, 0x100fe200078e0213ULL, 0x0000001b10107210ULL, 0x000fe20007fde0ffULL,
0x0000001014177824ULL, 0x100fe200078e0213ULL, 0x00000003ff037210ULL, 0x000fe200027fe4ffULL,
0x0000001000197824ULL, 0x000fe200078e0213ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004157faeULL, 0x0003e2000d901c48ULL, 0x000000ffff077224ULL, 0x000fe400028e0607ULL,
0x0000001012137824ULL, 0x000fe200078e0213ULL, 0x0000000002177faeULL, 0x0003e2000d101c48ULL,
0x000000ffff117224ULL, 0x000fc600030e0611ULL, 0x0000000006197faeULL, 0x0003e8000c901c48ULL,
0x0000000010137faeULL, 0x0003e2000c101c48ULL, 0x0000000000c07947ULL, 0x000fea0003800000ULL,
0x000000100f047824ULL, 0x000fe200078e00ffULL, 0x00008a00ff107b82ULL, 0x000e620000000a00ULL,
0x0000007002197812ULL, 0x000fe200078ec0ffULL, 0x000020000b167824ULL, 0x000fe400078e020eULL,
0x000000040d037211ULL, 0x000fe400078fe8ffULL, 0x00013000161b7836ULL, 0x000fc60000000000ULL,
0x0000000403067836ULL, 0x000fe40000000000ULL, 0x0000000103047824ULL, 0x140fe400078e020dULL,
0x0000000803077824ULL, 0x000fe400078e00ffULL, 0x0000000106057824ULL, 0x040fe400078e020dULL,
0x0000000806127824ULL, 0x000fe200078e00ffULL, 0xfffffff807087812ULL, 0x000fe200078ee204ULL,
0x0000000803047836ULL, 0x000fc40000000000ULL, 0x0000000c03137836ULL, 0x000fe20000000000ULL,
0xfffffff812127812ULL, 0x000fe200078ee205ULL, 0x0000000100057824ULL, 0x040fe400078e0203ULL,
0x0000000100037824ULL, 0x040fe400078e0206ULL, 0x0000000100077824ULL, 0x040fe400078e0204ULL,
0x0000000100157824ULL, 0x000fe400078e0213ULL, 0x0000000104007824ULL, 0x000fc400078e020dULL,
0x0000000804177824ULL, 0x000fe400078e00ffULL, 0x0000000113067824ULL, 0x000fe400078e020dULL,
0x0000008005047825ULL, 0x002fe200078e0010ULL, 0xfffffff817007812ULL, 0x000fc600078ee200ULL,
0x0000000813137824ULL, 0x000fe200078e00ffULL, 0x0000001904047210ULL, 0x000fe20007f1e0ffULL,
0x0000008003027825ULL, 0x000fc600078e0010ULL, 0xfffffff813147812ULL, 0x000fe200078ee206ULL,
0x0000008007067825ULL, 0x000fc800078e0010ULL, 0x0000008015107825ULL, 0x000fe200078e0010ULL,
0x0000001906067210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e0605ULL,
0x0000001902027210ULL, 0x000fe20007f1e0ffULL, 0x0000001008137824ULL, 0x100fe200078e021bULL,
0x0000001910107210ULL, 0x000fe20007f5e0ffULL, 0x0000001012157824ULL, 0x000fe200078e021bULL,
0x0000001b14197211ULL, 0x000fe200078e20ffULL, 0x000000ffff037224ULL, 0x000fe200000e0603ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004137faeULL, 0x0003e2000b901c48ULL,
0x0000001000177824ULL, 0x000fe400078e021bULL, 0x000000ffff077224ULL, 0x000fe200008e0607ULL,
0x0000000002157faeULL, 0x0003e2000b901c48ULL, 0x000000ffff117224ULL, 0x000fc600010e0611ULL,
0x0000000006177faeULL, 0x0003e8000b901c48ULL, 0x0000000010197faeULL, 0x0003e4000b901c48ULL,
0x000000100b087824ULL, 0x000fe200078e00ffULL, 0x000000ff3500720cULL, 0x000fe20003f05270ULL,
0x000176a80e007836ULL, 0x000fe20000000000ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000001ff397424ULL, 0x000fe200078e00ffULL, 0x00000000080472caULL, 0x000fe200000e0000ULL,
0x000000ffff077224ULL, 0x002fe200078e00ffULL, 0x00000000000572caULL, 0x000fe400000e0000ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000127805ULL, 0x000fc4000001ff00ULL,
0x0000000000107805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff197224ULL, 0x000fe400078e00ffULL, 0x000000080b387824ULL, 0x000fe200078e0200ULL,
0x0000000504047290ULL, 0x000fe2000fffe03fULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000039ff5279a7ULL, 0x0002a20008500004ULL, 0x000000ffff187224ULL, 0x000fe200078e00ffULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fc4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00002039383879a7ULL, 0x002e62000850003fULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000008800548947ULL, 0x000fec0003800000ULL,
0xff317217ff527424ULL, 0x004fe400078e00ffULL, 0x000000ffff067224ULL, 0x000fe400078e00ffULL,
0x000000ffff307224ULL, 0x000fe400078e00ffULL, 0x000000ffff2f7224ULL, 0x000fce00078e00ffULL,
0x0000010006047824ULL, 0x000fca00078e00ffULL, 0x000000370400720cULL, 0x000fda0003f06070ULL,
0x00000088002c0947ULL, 0x002fea0003800000ULL, 0x000000ffff057224ULL, 0x000fce00078e0030ULL,
0x0000000000327805ULL, 0x000fe20000015200ULL, 0x000000080b347824ULL, 0x000fc800078e020eULL,
0x0176c839340075a7ULL, 0x002ea2000800017fULL, 0x000176c834047836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x006fec0003800000ULL, 0x000000ffff387224ULL, 0x000fce00078e00ffULL,
0x000000103800780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a32367210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3a7824ULL, 0x000fe200000e0e33ULL, 0x003d09003600780cULL, 0x000fc80003f06070ULL,
0x000000ff3a00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403600780cULL, 0x000fc80003f06070ULL, 0x000000ff3a00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff317819ULL, 0x000fc8000001143aULL,
0x0000003631317211ULL, 0x000fca00078110ffULL, 0x000000ffff367224ULL, 0x000fca00000e063aULL,
0x0000000231317819ULL, 0x000fc80000001236ULL, 0x000000310000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000138387836ULL, 0x000fce0000000000ULL,
0x0176c839340075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000106327836ULL, 0x000fe20000000000ULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x00000100063c7824ULL, 0x000fe200078e020aULL, 0x00000001303e7812ULL, 0x000fe400078e0cffULL,
0x000000353200720cULL, 0x000fe40003f06070ULL, 0x000000403c327810ULL, 0x000fca0007ffe0ffULL,
0x00000004093f7c24ULL, 0x000fcc000f8e0232ULL, 0x0000000000fc8947ULL, 0x000fea0003800000ULL,
0x00000003ff367819ULL, 0x100fe2000001160dULL, 0x000000100f347824ULL, 0x000fe200078e00ffULL,
0x0000003237317248ULL, 0x000fe20007fe0000ULL, 0x000020000b397824ULL, 0x000fe400078e020eULL,
0x0000000134387824ULL, 0x000fe400078e0236ULL, 0x0000000131317824ULL, 0x000fe400078e0a32ULL,
0x0000000138327824ULL, 0x040fe400078e020dULL, 0x0000000838337824ULL, 0x000fe200078e00ffULL,
0x0000003134317248ULL, 0x000fe20007fe0000ULL, 0x00000004363a7836ULL, 0x000fc40000000000ULL,
0x00000008363b7836ULL, 0x000fe20000000000ULL, 0xfffffff833427812ULL, 0x000fe200078ee232ULL,
0x0000000131317824ULL, 0x000fe200078e0a34ULL, 0x00008a00ff327b82ULL, 0x000e620000000a00ULL,
0x0000000c36417836ULL, 0x000fe40000000000ULL, 0x0000000134407824ULL, 0x000fe200078e023bULL,
0x000000313a00720cULL, 0x080fe20003f46070ULL, 0x00000001343a7824ULL, 0x000fe200078e023aULL,
0x000000313600720cULL, 0x080fe20003f66070ULL, 0x0000000134447824ULL, 0x000fe200078e0241ULL,
0x000000313b00720cULL, 0x080fe20003f26070ULL, 0x000000013a367824ULL, 0x040fe200078e020dULL,
0x000000314100720cULL, 0x000fe20003f06070ULL, 0x000000083a437824ULL, 0x000fe200078e00ffULL,
0x0000000344457819ULL, 0x000fe200000006ffULL, 0x000010003e317824ULL, 0x000fc400078e0239ULL,
0x000000100d347824ULL, 0x000fe200078e00ffULL, 0xfffffff843367812ULL, 0x000fe200078ee236ULL,
0x0000000138397824ULL, 0x100fe400078e023fULL, 0x000000013a3b7824ULL, 0x100fe200078e023fULL,
0x0000007034477812ULL, 0x000fe200078ec0ffULL, 0x0000000140417824ULL, 0x040fe400078e023fULL,
0x00000001403a7824ULL, 0x040fe400078e020dULL, 0x0000000840437824ULL, 0x000fc400078e00ffULL,
0x0000008039387825ULL, 0x002fc600078e0032ULL, 0xfffffff843347812ULL, 0x000fe200078ee23aULL,
0x0000000144407824ULL, 0x040fe200078e020dULL, 0x0000004738387210ULL, 0x000fe20007f9e0ffULL,
0x00000001443f7824ULL, 0x000fe400078e023fULL, 0x000000803b3a7825ULL, 0x000fe200078e0032ULL,
0xfffffff845447812ULL, 0x000fc600078ee240ULL, 0x0000008041407825ULL, 0x000fc800078e0032ULL,
0x000000803f327825ULL, 0x000fe200078e0032ULL, 0x0000004740407210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff397224ULL, 0x000fe200020e0639ULL, 0x000000473a3a7210ULL, 0x000fe20007f9e0ffULL,
0x0001300031317836ULL, 0x000fe20000000000ULL, 0x0000004732327210ULL, 0x000fe20007fde0ffULL,
0x000000ffff417224ULL, 0x000fe400028e0641ULL, 0x00000010423f7824ULL, 0x100fe400078e0231ULL,
0x0000001036437824ULL, 0x000fe400078e0231ULL, 0x000000ffff3b7224ULL, 0x000fe200020e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000383f7faeULL, 0x0003e2000d901c48ULL,
0x0000001034457824ULL, 0x000fc400078e0231ULL, 0x0000001044317824ULL, 0x000fe200078e0231ULL,
0x000000003a437faeULL, 0x0003e2000d101c48ULL, 0x000000ffff337224ULL, 0x000fc600030e0633ULL,
0x0000000040457faeULL, 0x0003e8000c901c48ULL, 0x0000000032317faeULL, 0x0003e2000c101c48ULL,
0x0000000000c87947ULL, 0x000fea0003800000ULL, 0x000000100f327824ULL, 0x000fe400078e00ffULL,
0x000020000b397824ULL, 0x000fc600078e020eULL, 0x000000320d347211ULL, 0x000fe200078fe8ffULL,
0x000010003e3a7824ULL, 0x000fe200078e0239ULL, 0x00008a00ff327b82ULL, 0x000e660000000a00ULL,
0x0000000434387836ULL, 0x000fe40000000000ULL, 0x0000000134397824ULL, 0x000fe400078e023fULL,
0x0000000138367824ULL, 0x040fe400078e020dULL, 0x00000008383b7824ULL, 0x000fc400078e00ffULL,
0x0000000134317824ULL, 0x040fe400078e020dULL, 0x0000000834427824ULL, 0x000fe200078e00ffULL,
0xfffffff83b447812ULL, 0x000fe200078ee236ULL, 0x000000100d367824ULL, 0x000fe400078e00ffULL,
0x0000000834407836ULL, 0x000fe20000000000ULL, 0xfffffff842427812ULL, 0x000fe200078ee231ULL,
0x00000001383b7824ULL, 0x100fe200078e023fULL, 0x0000007036457812ULL, 0x000fe200078ec0ffULL,
0x0000000c34467836ULL, 0x000fe20000000000ULL, 0x0000000d40347210ULL, 0x000fe20007ffe0ffULL,
0x0000000140417824ULL, 0x000fc400078e023fULL, 0x0000008039387825ULL, 0x002fc800078e0032ULL,
0x0000000146317824ULL, 0x000fe200078e023fULL, 0x0000004538387210ULL, 0x000fe20007f1e0ffULL,
0x000130003a477836ULL, 0x000fe40000000000ULL, 0x0000000840437824ULL, 0x000fe400078e00ffULL,
0x000000803b3a7825ULL, 0x000fc600078e0032ULL, 0xfffffff843347812ULL, 0x000fe200078ee234ULL,
0x00000001463f7824ULL, 0x000fe400078e020dULL, 0x0000008041407825ULL, 0x000fc800078e0032ULL,
0x0000000846467824ULL, 0x000fe200078e00ffULL, 0x0000004540407210ULL, 0x000fe20007f3e0ffULL,
0x0000008031327825ULL, 0x000fc600078e0032ULL, 0xfffffff846367812ULL, 0x000fe200078ee23fULL,
0x000000ffff397224ULL, 0x000fe200000e0639ULL, 0x000000453a3a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001042317824ULL, 0x100fe200078e0247ULL, 0x0000004532327210ULL, 0x000fe20007f5e0ffULL,
0x00000010443f7824ULL, 0x000fe400078e0247ULL, 0x000000ffff3b7224ULL, 0x000fe200000e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038317faeULL, 0x0003e2000b901c48ULL,
0x0000001034437824ULL, 0x000fe400078e0247ULL, 0x000000ffff417224ULL, 0x000fe200008e0641ULL,
0x000000003a3f7faeULL, 0x0003e2000b901c48ULL, 0x0000001036457824ULL, 0x000fc400078e0247ULL,
0x000000ffff337224ULL, 0x000fe200010e0633ULL, 0x0000000040437faeULL, 0x0003e8000b901c48ULL,
0x0000000032457faeULL, 0x0003e4000b901c48ULL, 0xfffffff00c317812ULL, 0x042fe200078ec0ffULL,
0x00000001ff3b7424ULL, 0x000fe200078e00ffULL, 0x000000100c327812ULL, 0x000fc600078ec0ffULL,
0x000000010e317824ULL, 0x000fc800078e0231ULL, 0x000000083e547824ULL, 0x000fe200078e0231ULL,
0xffffffe00c317812ULL, 0x000fc800078ec0ffULL, 0x00000000540472caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000010e317824ULL, 0x000fc800078e0231ULL,
0x0000000131327824ULL, 0x000fc800078e0232ULL, 0x000000080f327824ULL, 0x000fc600078e0232ULL,
0x000176a804047890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0176a83b545479a7ULL, 0x0002a4000850003fULL,
0x0176083b323a79a7ULL, 0x0022e4000850003fULL, 0x0000000000327805ULL, 0x002fce0000015200ULL,
0x0000001008347812ULL, 0x000fca00078ec0ffULL, 0x0000000131347824ULL, 0x000fc800078e0234ULL,
0x000000080f317824ULL, 0x000fc800078e0234ULL, 0x0176083b310075a7ULL, 0x008e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fce0000015200ULL, 0x00000038323f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e33ULL, 0x003d09003f00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403f00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011439ULL,
0x0000003f34347211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000234347819ULL, 0x000fc80000001239ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x0176083b310075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000000053d317819ULL, 0x000fe200000006ffULL, 0x000000100d327824ULL, 0x000fe200078e00ffULL,
0x00000001ff447819ULL, 0x000fe2000001160dULL, 0x00000001ff367424ULL, 0x000fe200078e00ffULL,
0xffffff8031317812ULL, 0x000fe200078ec0ffULL, 0x000000ffff4f7224ULL, 0x000fe200078e0052ULL,
0x0000007032397812ULL, 0x000fe400078ec0ffULL, 0x0000000c44447812ULL, 0x000fe200078ec0ffULL,
0x000000010e457824ULL, 0x000fca00078e0231ULL, 0x0000004544317210ULL, 0x000fca0007ffe039ULL,
0x0170000031337984ULL, 0x000e680000000800ULL, 0x0172000031347984ULL, 0x0006e20000000800ULL,
0x000000523300720bULL, 0x002fda0003f1d000ULL, 0x0000000000327806ULL, 0x000fc800000e0100ULL,
0x0000ffff32387812ULL, 0x000fda000780c0ffULL, 0x0000000000f48947ULL, 0x00cfea0003800000ULL,
0x00000002ff327819ULL, 0x000fe4000001163dULL, 0x000000523300720bULL, 0x000fe40003f14000ULL,
0x0000003d3200720cULL, 0x000fe40003f25270ULL, 0x00000033524f7209ULL, 0x000fd60007810000ULL,
0x000000803d319824ULL, 0x000fca00078e020eULL, 0x0000003144329210ULL, 0x000fe40007ffe039ULL,
0x0000000000397806ULL, 0x000fc600000e0100ULL, 0x0174004f32009388ULL, 0x0003e20000000800ULL,
0x0000991039317816ULL, 0x000fc800000000ffULL, 0x000000ff3100720cULL, 0x000fda0003f05270ULL,
0x0000000000b08947ULL, 0x002fea0003800000ULL, 0x8000004f52317221ULL, 0x000fe20000010000ULL,
0x000000ff39ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0039ff7812ULL, 0x000fe2000782c0ffULL,
0x3fb8aa3b31317820ULL, 0x000fc80000410000ULL, 0x0000003100327308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x002fcc000001160dULL,
0x00001f3132317589ULL, 0x004e6400000e0000ULL, 0x0000003128287220ULL, 0x082fe20000410000ULL,
0x0000003129297220ULL, 0x080fe20000410000ULL, 0x0000003124247220ULL, 0x080fe20000410000ULL,
0x0000003125257220ULL, 0x080fe20000410000ULL, 0x0000003120207220ULL, 0x080fe20000410000ULL,
0x0000003121217220ULL, 0x080fe20000410000ULL, 0x000000311c1c7220ULL, 0x080fe20000410000ULL,
0x000000311d1d7220ULL, 0x080fe20000410000ULL, 0x0000003118187220ULL, 0x080fe20000410000ULL,
0x0000003119197220ULL, 0x080fe20000410000ULL, 0x0000003114147220ULL, 0x080fe20000410000ULL,
0x0000003115157220ULL, 0x080fe20000410000ULL, 0x0000003110107220ULL, 0x080fe20000410000ULL,
0x0000003111117220ULL, 0x080fe20000410000ULL, 0x000000312c2c7220ULL, 0x080fe20000410000ULL,
0x000000312d2d7220ULL, 0x000fce0000410000ULL, 0x0000003207077220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x000000080d317811ULL, 0x002fcc00078ff0ffULL,
0x00001f3132317589ULL, 0x000e6400000e0000ULL, 0x000000312a2a7220ULL, 0x082fe20000410000ULL,
0x000000312b2b7220ULL, 0x080fe20000410000ULL, 0x0000003126267220ULL, 0x080fe20000410000ULL,
0x0000003127277220ULL, 0x080fe20000410000ULL, 0x0000003122227220ULL, 0x080fe20000410000ULL,
0x0000003123237220ULL, 0x080fe20000410000ULL, 0x000000311e1e7220ULL, 0x080fe20000410000ULL,
0x000000311f1f7220ULL, 0x080fe20000410000ULL, 0x000000311a1a7220ULL, 0x080fe20000410000ULL,
0x000000311b1b7220ULL, 0x080fe20000410000ULL, 0x0000003116167220ULL, 0x080fe20000410000ULL,
0x0000003117177220ULL, 0x080fe20000410000ULL, 0x0000003112127220ULL, 0x080fe20000410000ULL,
0x0000003113137220ULL, 0x080fe20000410000ULL, 0x000000312e2e7220ULL, 0x080fe20000410000ULL,
0x000000312f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff38ff7812ULL, 0x000fda0007806039ULL,
0x8000004f33330221ULL, 0x000fe20000010000ULL, 0x00007610ff360816ULL, 0x000fc60000000036ULL,
0x3fb8aa3b33330820ULL, 0x000fc80000410000ULL, 0x0000003300020308ULL, 0x000ea40000000800ULL,
0x0000000234340220ULL, 0x004fce0000410000ULL, 0x0000000734077221ULL, 0x000fce0000010000ULL,
0x0000000000327805ULL, 0x000fe20000015200ULL, 0x000000010e317824ULL, 0x002fc800078e0208ULL,
0x00000008303a7824ULL, 0x000fc800078e0231ULL, 0x0176a8533a0075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff3b7224ULL, 0x000fce00078e00ffULL,
0x000000103b00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x0000003832347210ULL, 0x000fca0007f1e1ffULL,
0x0000000139387824ULL, 0x000fe200000e0e33ULL, 0x003d09003400780cULL, 0x000fc80003f06070ULL,
0x000000ff3800720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403400780cULL, 0x000fc80003f06070ULL, 0x000000ff3800720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff317819ULL, 0x000fc80000011438ULL,
0x0000003431317211ULL, 0x000fca00078110ffULL, 0x000000ffff347224ULL, 0x000fca00000e0638ULL,
0x0000000231317819ULL, 0x000fc80000001234ULL, 0x000000310000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013b3b7836ULL, 0x000fce0000000000ULL,
0x0176a8533a0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x000020000b337824ULL, 0x000fe200078e020eULL, 0x0000991036317816ULL, 0x000fe400000000ffULL,
0x00000004ff507819ULL, 0x000fe2000001160dULL, 0x0000100030367824ULL, 0x000fe200078e0233ULL,
0x000000070d4c7812ULL, 0x040fe400078ec0ffULL, 0x000000080d307812ULL, 0x000fe200078ec0ffULL,
0x000000040b497824ULL, 0x100fe200078e0250ULL, 0x000000ff3100720cULL, 0x000fe20003f05270ULL,
0x000002003d317824ULL, 0x000fe200078e00ffULL, 0x000000084c4c7812ULL, 0x000fe200078ef80dULL,
0x000000040f507824ULL, 0x000fe200078e0250ULL, 0x0000000730517812ULL, 0x000fe200078ef80dULL,
0x0001300036367836ULL, 0x000fe20000000000ULL, 0xfffff80031317812ULL, 0x000fe200078ec0ffULL,
0x000000014c497824ULL, 0x000fc400078e0249ULL, 0x000000084c307824ULL, 0x000fe400078e00ffULL,
0x0000000151387824ULL, 0x040fe400078e0250ULL, 0x0000000851337824ULL, 0x000fe200078e00ffULL,
0xfffffff8303f7812ULL, 0x000fe200078ee249ULL, 0x000000010e347824ULL, 0x000fc600078e0231ULL,
0xfffffff833317812ULL, 0x000fe200078ee238ULL, 0x000000103f3f7824ULL, 0x000fc800078e0234ULL,
0x0000001031407824ULL, 0x000fe200078e0236ULL, 0x0000000000180947ULL, 0x000fec0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160dULL, 0x00000002ff00723eULL, 0x000fe400000000ffULL,
0x0000000803317810ULL, 0x000fe40007ffe0ffULL, 0x0000541000307816ULL, 0x000fca0000000000ULL,
0x00001f0330037589ULL, 0x0002a800000e0000ULL, 0x00001f3130007589ULL, 0x0002e400000e0000ULL,
0x011000003f30783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000031317232ULL, 0x080fe40000000000ULL, 0x0000000033337232ULL, 0x000fce0000000000ULL,
0x000000004040783bULL, 0x000f220000004200ULL, 0x00000008513a7824ULL, 0x000fe400078e00ffULL,
0x00000002384b7836ULL, 0x000fe40000000000ULL, 0x000000084c4c7824ULL, 0x000fe400078e00ffULL,
0x0000000249497836ULL, 0x000fe20000000000ULL, 0xfffffff83a4b7812ULL, 0x000fc800078ee24bULL,
0xfffffff84c497812ULL, 0x000fe200078ee249ULL, 0x000000104b387824ULL, 0x000fc600078e0236ULL,
0x0000003449347211ULL, 0x000fc600078e20ffULL, 0x000000003838783bULL, 0x000f620000004200ULL,
0x00000018ff597819ULL, 0x010fe20000011440ULL, 0x00000100404d7824ULL, 0x040fe200078e00ffULL,
0x0000888040587816ULL, 0x040fe200000000ffULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe20000011441ULL, 0x00000100414e7824ULL, 0x040fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000888041617816ULL, 0x040fe200000000ffULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fc4000001144eULL,
0x00000018ff527819ULL, 0x000fe20000011443ULL, 0x0000004d00637306ULL, 0x0009e20000200c00ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00008880435c7816ULL, 0x000fe400000000ffULL,
0x00000018ff4a7819ULL, 0x022fe40000011438ULL, 0x00000018ff487819ULL, 0x000fe20000011439ULL,
0x0000004000607306ULL, 0x0003e20000200c00ULL, 0x00000100424d7824ULL, 0x050fe200078e00ffULL,
0x00008880425b7816ULL, 0x000fc400000000ffULL, 0x00000018ff567819ULL, 0x000fe20000011442ULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x0000005800587306ULL, 0x000f220000200c00ULL, 0x0000010043407824ULL, 0x042fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x000088803b667816ULL, 0x000fe400000000ffULL, 0x00000018ff407819ULL, 0x000fc40000011440ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x00000018ff467819ULL, 0x000fe4000001143aULL, 0x000088803a647816ULL, 0x000fe400000000ffULL,
0x00000018ff477819ULL, 0x000fe2000001143bULL, 0x0000004e00627306ULL, 0x0003700000200c00ULL,
0x0000004100657306ULL, 0x0009e20000200c00ULL, 0x00008880384e7816ULL, 0x002fce00000000ffULL,
0x0000004d005e7306ULL, 0x0003e20000200c00ULL, 0x0000010038417824ULL, 0x054fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000004000677306ULL, 0x0005e20000200c00ULL, 0x00000100394d7824ULL, 0x002fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fc80000011438ULL, 0x00000018ff577819ULL, 0x000fe4000001144dULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x0000888039407816ULL, 0x044fe200000000ffULL,
0x0001000039397824ULL, 0x000fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x00000043005f7306ULL, 0x000ff00000200c00ULL, 0x0000003800437306ULL, 0x0005f00000200c00ULL,
0x00000039004d7306ULL, 0x000be20000200c00ULL, 0x0000541058387816ULL, 0x004fe20000000063ULL,
0x000000ffff587224ULL, 0x000fcc00078e0066ULL, 0x0000005b005b7306ULL, 0x000ea20000200c00ULL,
0x0000541061397816ULL, 0x028fe20000000062ULL, 0x000001003b617824ULL, 0x000fcc00078e00ffULL,
0x0000005c005c7306ULL, 0x000ee20000200c00ULL, 0x000000383028723cULL, 0x000fee0000001828ULL,
0x0000541060387816ULL, 0x000fe20000000059ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x0000541065397816ULL, 0x002fe2000000005aULL, 0x000100003b5a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fc80000011461ULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x000000383024723cULL, 0x000fee0000001824ULL,
0x00000042005d7306ULL, 0x000e620000200c00ULL, 0x000054105b387816ULL, 0x004fc4000000005eULL,
0x000054105c397816ULL, 0x008fca0000000067ULL, 0x0000004100537306ULL, 0x0005e40000200c00ULL,
0x000000383020723cULL, 0x000fec0000001820ULL, 0x0000004a004a7306ULL, 0x000ee20000200c00ULL,
0x000001003a417824ULL, 0x044fe200078e00ffULL, 0x000054105d387816ULL, 0x002fe20000000056ULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000054105f397816ULL, 0x000fc40000000052ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004800487306ULL, 0x000e620000200c00ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x00000038301c723cULL, 0x000fea000000181cULL,
0x0000004000427306ULL, 0x000fe40000200c00ULL, 0x0000541043387816ULL, 0x008fc4000000004aULL,
0x000054104d397816ULL, 0x002fc80000000048ULL, 0x0000006400407306ULL, 0x000fe20000200c00ULL,
0x00000010514d7812ULL, 0x000fe400078efcffULL, 0x000000383014723cULL, 0x000fea0000001814ULL,
0x0000004100417306ULL, 0x000e640000200c00ULL, 0x0000000150387824ULL, 0x000fc400078e024dULL,
0x000000084d397824ULL, 0x000fc800078e00ffULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0xfffffff839497812ULL, 0x000fe400078ee238ULL, 0x0000541040407816ULL, 0x002fca0000000041ULL,
0x0000004700477306ULL, 0x000ff00000200c00ULL, 0x0000004e004e7306ULL, 0x000e700000200c00ULL,
0x0000005700577306ULL, 0x000ea20000200c00ULL, 0x000054104e567816ULL, 0x002fce0000000053ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x0000541042577816ULL, 0x004fce0000000057ULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x000000563018723cULL, 0x000fee0000001818ULL,
0x0000003a003b7306ULL, 0x000ea20000200c00ULL, 0x0000541058417816ULL, 0x002fce0000000059ULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x000000403010723cULL, 0x000fe20000001810ULL,
0x000054103b467816ULL, 0x004fcc0000000046ULL, 0x0000001049407824ULL, 0x000fe200078e0236ULL,
0x000054105a477816ULL, 0x002fce0000000047ULL, 0x00000046302c723cULL, 0x000fe2000000182cULL,
0x011000003430783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000031317232ULL, 0x080fe40000000000ULL,
0x0000000033337232ULL, 0x000fce0000000000ULL, 0x000000004040783bULL, 0x000ee20000004200ULL,
0x000000084d3a7824ULL, 0x000fe400078e00ffULL, 0x0000000238477836ULL, 0x000fca0000000000ULL,
0xfffffff83a477812ULL, 0x000fca00078ee247ULL, 0x0000001047387824ULL, 0x000fcc00078e0236ULL,
0x000000003838783bULL, 0x000f220000004200ULL, 0x00000018ff587819ULL, 0x008fe20000011440ULL,
0x00000100404c7824ULL, 0x040fe200078e00ffULL, 0x00008880405c7816ULL, 0x040fe200000000ffULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011441ULL,
0x00000100414d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x00008880415e7816ULL, 0x040fe200000000ffULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fc4000001144dULL, 0x00000018ff527819ULL, 0x000fe20000011443ULL,
0x0000004c00657306ULL, 0x0007e20000200c00ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00008880435b7816ULL, 0x000fe400000000ffULL, 0x00000018ff367819ULL, 0x010fe40000011438ULL,
0x00000018ff4a7819ULL, 0x000fe20000011439ULL, 0x0000004000637306ULL, 0x0009e20000200c00ULL,
0x00000100424c7824ULL, 0x008fe200078e00ffULL, 0x0000888038537816ULL, 0x000fc400000000ffULL,
0x00008880425a7816ULL, 0x040fe400000000ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000005c005c7306ULL, 0x000ee20000200c00ULL, 0x0000010043407824ULL, 0x050fe200078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011442ULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff467819ULL, 0x000fe2000001143aULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fc40000011440ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff487819ULL, 0x000fc6000001143bULL, 0x0000004d00677306ULL, 0x000f300000200c00ULL,
0x0000004100627306ULL, 0x000bf00000200c00ULL, 0x0000004c005d7306ULL, 0x0007e20000200c00ULL,
0x0000010038417824ULL, 0x022fc400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004000607306ULL, 0x0003e20000200c00ULL,
0x00008880394c7816ULL, 0x00cfe400000000ffULL, 0x00000018ff387819ULL, 0x000fca0000011438ULL,
0x0000005900597306ULL, 0x000ea20000200c00ULL, 0x0000010039407824ULL, 0x042fe400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff577819ULL, 0x000fe40000011440ULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000004300617306ULL, 0x000fe20000200c00ULL,
0x000088803a407816ULL, 0x000fce00000000ffULL, 0x0000003800437306ULL, 0x0003f00000200c00ULL,
0x00000039004d7306ULL, 0x0009e20000200c00ULL, 0x000054105c387816ULL, 0x002fe20000000065ULL,
0x000001003b5c7824ULL, 0x000fcc00078e00ffULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x000054105e397816ULL, 0x010fce0000000067ULL, 0x0000005b005b7306ULL, 0x000ee20000200c00ULL,
0x000000383028723cULL, 0x000fee0000001828ULL, 0x0000541063387816ULL, 0x000fe20000000058ULL,
0x0000005200527306ULL, 0x000f220000200c00ULL, 0x0000541062397816ULL, 0x004fc40000000059ULL,
0x00000018ff597819ULL, 0x000fca000001145cULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x000000383024723cULL, 0x000fee0000001824ULL, 0x00000042005f7306ULL, 0x0005620000200c00ULL,
0x000054105a387816ULL, 0x002fe4000000005dULL, 0x000054105b397816ULL, 0x008fca0000000060ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x000088803b427816ULL, 0x044fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x000000383020723cULL, 0x000fea0000001820ULL,
0x00000041004e7306ULL, 0x0002a40000200c00ULL, 0x0000541061397816ULL, 0x010fc40000000052ULL,
0x00000018ff527819ULL, 0x000fe4000001143bULL, 0x000054105f387816ULL, 0x020fe40000000056ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x000001003a417824ULL, 0x042fe400078e00ffULL,
0x000100003a3a7824ULL, 0x000fe400078e00ffULL, 0x00000038301c723cULL, 0x000fe2000000181cULL,
0x00000018ff417819ULL, 0x000fc40000011441ULL, 0x0000005700577306ULL, 0x000e620000200c00ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x0000541053567816ULL, 0x004fca000000004eULL,
0x0000003600367306ULL, 0x000ea20000200c00ULL, 0x000054104c577816ULL, 0x002fce0000000057ULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x000000563018723cULL, 0x000fe20000001818ULL,
0x00005410434c7816ULL, 0x004fcc0000000036ULL, 0x0000004100417306ULL, 0x000e620000200c00ULL,
0x000000023d367824ULL, 0x000fe400078e00ffULL, 0x00000001ff437424ULL, 0x000fc600078e00ffULL,
0xfffffff8363b7812ULL, 0x000fe200078ec0ffULL, 0x00000043043879a7ULL, 0x0004a2000850003fULL,
0x0000004a004a7306ULL, 0x000ee60000200c00ULL, 0x000000010e367824ULL, 0x000fe200078e023bULL,
0x0000541040407816ULL, 0x002fc80000000041ULL, 0x0000004600467306ULL, 0x000fe20000200c00ULL,
0x0176884336ff79a7ULL, 0x0005e2000850003fULL, 0x000054104d4d7816ULL, 0x008fcc000000004aULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x0000004c3014723cULL, 0x000fee0000001814ULL,
0x0000004200427306ULL, 0x000ff00000200c00ULL, 0x0000005900597306ULL, 0x000e700000200c00ULL,
0x0000003a005b7306ULL, 0x000ee20000200c00ULL, 0x0000541042417816ULL, 0x002fce0000000059ULL,
0x0000005200537306ULL, 0x0003220000200c00ULL, 0x000000403010723cULL, 0x000fe20000001810ULL,
0x000054105b3a7816ULL, 0x008fe20000000046ULL, 0x000000ffff527224ULL, 0x002fe200078e004fULL,
0x00005410533b7816ULL, 0x010fe40000000048ULL, 0x0000005500537202ULL, 0x000fca0000000f00ULL,
0x0000003a302c723cULL, 0x000fee000000182cULL, 0x0000004006307811ULL, 0x000fc800078e40ffULL,
0x000000373000720cULL, 0x000fe20003f06070ULL, 0x000000ffff307224ULL, 0x000fd800078e003eULL,
0x0000006400040947ULL, 0x004fea0003800000ULL, 0x0000000000307805ULL, 0x000fe20000015200ULL,
0x00000039040075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x00000039040075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000106307836ULL, 0x000fe20000000000ULL,
0x00008e0000057ab9ULL, 0x000fe20000000800ULL, 0x000000803c327836ULL, 0x000fc60000000000ULL,
0x000000353000720cULL, 0x000fe20003f06070ULL, 0x0000000509437c24ULL, 0x000fd8000f8e0232ULL,
0x0000000400008947ULL, 0x000fea0003800000ULL, 0x0000003237317248ULL, 0x000fe20007fe0000ULL,
0x000000100f3a7824ULL, 0x000fe200078e00ffULL, 0x00000003ff3b7819ULL, 0x000fe2000001160dULL,
0x00008a00ff387b82ULL, 0x000e620000000a00ULL, 0x0000100005307824ULL, 0x000fe400078e00ffULL,
0x0000000131317824ULL, 0x000fe400078e0a32ULL, 0x000000013a407824ULL, 0x000fe200078e023bULL,
0x0000100030307812ULL, 0x000fe200078ec0ffULL, 0x000020000b337824ULL, 0x000fe200078e020eULL,
0x000000313a317248ULL, 0x000fe20007fe0000ULL, 0x0000000140327824ULL, 0x000fc400078e020dULL,
0x0000000840417824ULL, 0x000fe200078e00ffULL, 0x0001300033337810ULL, 0x000fe20007ffe030ULL,
0x0000000131317824ULL, 0x000fe400078e0a3aULL, 0x000000043b307836ULL, 0x000fe20000000000ULL,
0xfffffff841427812ULL, 0x000fe200078ee232ULL, 0x000000083b327836ULL, 0x000fe20000000000ULL,
0x000000313b00720cULL, 0x080fe20003f66070ULL, 0x0000000c3b3b7836ULL, 0x000fe20000000000ULL,
0x000000313000720cULL, 0x080fe20003f46070ULL, 0x000000013a307824ULL, 0x000fe200078e0230ULL,
0x000000313200720cULL, 0x080fe20003f26070ULL, 0x000000013a467824ULL, 0x000fe200078e0232ULL,
0x000000313b00720cULL, 0x000fe20003f06070ULL, 0x000000100d327824ULL, 0x000fc400078e00ffULL,
0x0000000140317824ULL, 0x000fe400078e0243ULL, 0x000000013a487824ULL, 0x000fe200078e023bULL,
0x0000000d303a7210ULL, 0x000fe20007ffe0ffULL, 0x00000001303b7824ULL, 0x000fe200078e0243ULL,
0x0000007032327812ULL, 0x000fe200078ec0ffULL, 0x00000008304d7824ULL, 0x000fe400078e00ffULL,
0x0000008031307825ULL, 0x002fc800078e0038ULL, 0x0000000146407824ULL, 0x040fe200078e020dULL,
0x0000003230307210ULL, 0x000fe20007f9e0ffULL, 0x0000000846537824ULL, 0x040fe400078e00ffULL,
0x0000000146417824ULL, 0x100fe200078e0243ULL, 0xfffffff84d467812ULL, 0x000fe200078ee23aULL,
0x0000000148437824ULL, 0x040fe400078e0243ULL, 0x00000001484a7824ULL, 0x040fe400078e020dULL,
0x0000000848577824ULL, 0x000fe200078e00ffULL, 0xfffffff853487812ULL, 0x000fe200078ee240ULL,
0x000000803b3a7825ULL, 0x000fc600078e0038ULL, 0xfffffff8574a7812ULL, 0x000fe200078ee24aULL,
0x0000008041407825ULL, 0x000fc800078e0038ULL, 0x0000008043387825ULL, 0x000fe200078e0038ULL,
0x0000003240407210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff317224ULL, 0x000fe200020e0631ULL,
0x000000323a3a7210ULL, 0x000fe20007f9e0ffULL, 0x0000001042437824ULL, 0x100fe200078e0233ULL,
0x0000003238387210ULL, 0x000fe20007fde0ffULL, 0x00000010464d7824ULL, 0x000fe400078e0233ULL,
0x000000ffff3b7224ULL, 0x000fe200020e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030437faeULL, 0x0003e2000d901c48ULL, 0x0000001048537824ULL, 0x000fe400078e0233ULL,
0x000000ffff417224ULL, 0x000fe200028e0641ULL, 0x000000003a4d7faeULL, 0x0003e2000d101c48ULL,
0x000000104a337824ULL, 0x000fc400078e0233ULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x0000000040537faeULL, 0x0003e8000c901c48ULL, 0x0000000038337faeULL, 0x0003e2000c101c48ULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x00008a00ff387b82ULL, 0x000e620000000a00ULL,
0x000000100f307824ULL, 0x000fe400078e00ffULL, 0x0000100005317824ULL, 0x000fe400078e00ffULL,
0x000000100d327824ULL, 0x040fe200078e00ffULL, 0x000000300d3a7211ULL, 0x000fe200078fe8ffULL,
0x000020000b307824ULL, 0x000fe200078e020eULL, 0x0000100031337812ULL, 0x000fe400078ec0ffULL,
0x000000083a407810ULL, 0x000fe20007ffe0ffULL, 0x000000013a317824ULL, 0x000fe200078e020dULL,
0x0001300030537810ULL, 0x000fe20007ffe033ULL, 0x000000083a427824ULL, 0x000fe200078e00ffULL,
0x0000007032327812ULL, 0x000fe200078ec0ffULL, 0x000000043a307836ULL, 0x000fc40000000000ULL,
0x0000000c3a467836ULL, 0x000fe20000000000ULL, 0xfffffff842427812ULL, 0x000fe200078ee231ULL,
0x000000013a317824ULL, 0x100fe400078e0243ULL, 0x00000001303b7824ULL, 0x040fe400078e0243ULL,
0x00000001303a7824ULL, 0x040fe400078e020dULL, 0x00000008304d7824ULL, 0x000fe400078e00ffULL,
0x0000000140417824ULL, 0x000fc400078e0243ULL, 0x0000000146337824ULL, 0x000fe400078e0243ULL,
0x0000000140437824ULL, 0x040fe400078e020dULL, 0x0000000840487824ULL, 0x000fe400078e00ffULL,
0x0000008031307825ULL, 0x002fc600078e0038ULL, 0xfffffff848487812ULL, 0x000fe200078ee243ULL,
0x0000000146407824ULL, 0x040fe200078e020dULL, 0x0000003230307210ULL, 0x000fe20007f1e0ffULL,
0x0000000846577824ULL, 0x000fe200078e00ffULL, 0xfffffff84d467812ULL, 0x000fe200078ee23aULL,
0x000000803b3a7825ULL, 0x000fc600078e0038ULL, 0xfffffff8574a7812ULL, 0x000fe200078ee240ULL,
0x0000008041407825ULL, 0x000fc800078e0038ULL, 0x0000008033387825ULL, 0x000fe200078e0038ULL,
0x0000003240407210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff317224ULL, 0x000fe200000e0631ULL,
0x000000323a3a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001042337824ULL, 0x100fe200078e0253ULL,
0x0000003238387210ULL, 0x000fe20007f5e0ffULL, 0x0000001046437824ULL, 0x000fe400078e0253ULL,
0x000000ffff3b7224ULL, 0x000fe200000e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030337faeULL, 0x0003e2000b901c48ULL, 0x00000010484d7824ULL, 0x000fe400078e0253ULL,
0x000000ffff417224ULL, 0x000fe200008e0641ULL, 0x000000003a437faeULL, 0x0003e2000b901c48ULL,
0x000000104a537824ULL, 0x000fc400078e0253ULL, 0x000000ffff397224ULL, 0x000fe200010e0639ULL,
0x00000000404d7faeULL, 0x0003e8000b901c48ULL, 0x0000000038537faeULL, 0x0003e4000b901c48ULL,
0x0000000805307824ULL, 0x002fe200078e00ffULL, 0xfffffff00c317812ULL, 0x040fe400078ec0ffULL,
0xffffffe00c337812ULL, 0x000fe400078ec0ffULL, 0x00000008304d7812ULL, 0x000fe400078ec0ffULL,
0x000000100c307812ULL, 0x000fe400078ec0ffULL, 0x0000000e4d4d7210ULL, 0x080fe20007ffe031ULL,
0x00000001ff317424ULL, 0x000fe200078e00ffULL, 0x0000000e30307210ULL, 0x000fc40007ffe033ULL,
0x000000004d0572caULL, 0x000fe200000e0000ULL, 0x0000000000007918ULL, 0x000fd80000000000ULL,
0x000176a805057890ULL, 0x000fd2000fffe03fULL, 0x00000000ff0079b0ULL, 0x000fe20008000a45ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000080f307824ULL, 0x000fe200078e0230ULL,
0x0176a8314d5279a7ULL, 0x0002aa000850003fULL, 0x01762831303079a7ULL, 0x002e64000850003fULL,
0x0000000000387805ULL, 0x000fce0000015200ULL, 0x00000010083a7812ULL, 0x000fc800078ec0ffULL,
0x0000000e3a3a7210ULL, 0x000fca0007ffe033ULL, 0x000000080f337824ULL, 0x000fc800078e023aULL,
0x01762831330075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff407224ULL, 0x000fce00078e00ffULL, 0x000000104000780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000003a7805ULL, 0x000fce0000015200ULL,
0x0000003a38417210ULL, 0x000fc80007f1e1ffULL, 0x0000003b393b7210ULL, 0x000fe400007fe5ffULL,
0x003d09004100780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c404100780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff3a7819ULL, 0x000fc8000001143bULL, 0x000000413a3a7211ULL, 0x000fca00078110ffULL,
0x000000ffff3b7224ULL, 0x000fca00000e063bULL, 0x000000023a3a7819ULL, 0x000fc8000000123bULL,
0x0000003a0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000140407836ULL, 0x000fce0000000000ULL, 0x01762831330075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000008032317810ULL, 0x000fe20007ffe045ULL,
0x00000001ff387424ULL, 0x000fe400078e00ffULL, 0x000000ffff527224ULL, 0x004fe400078e004fULL,
0x0000000144317824ULL, 0x000fca00078e0231ULL, 0x0170000031307984ULL, 0x000e680000000800ULL,
0x0172000031337984ULL, 0x0004a20000000800ULL, 0x0000004f3000720bULL, 0x002fda0003f1d000ULL,
0x0000000000397806ULL, 0x000fc800000e0100ULL, 0x0000ffff39ff7812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x004fea0003800000ULL, 0x000000013d387811ULL, 0x000fe400078ff0ffULL,
0x0000004f3000720bULL, 0x000fe40003f14000ULL, 0x0000003d3800720cULL, 0x000fd60003f25270ULL,
0x0000000000387806ULL, 0x000fe400000e0100ULL, 0x000000803d3b9824ULL, 0x000fe200078e020eULL,
0x0000004f30319209ULL, 0x000fc80007810000ULL, 0x0000003b443a9210ULL, 0x000fe40007ffe032ULL,
0x0000991038327816ULL, 0x000fc600000000ffULL, 0x017400313a009388ULL, 0x0003e20000000800ULL,
0x000000ff3200720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000004f30327209ULL, 0x000fe40007810000ULL, 0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0038ff7812ULL, 0x000fe2000782c0ffULL, 0x0000004f32317221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b31317820ULL, 0x000fc80000410000ULL, 0x0000003100327308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x002fcc000001160dULL,
0x00001f3132317589ULL, 0x004e6400000e0000ULL, 0x0000003128287220ULL, 0x082fe20000410000ULL,
0x0000003129297220ULL, 0x080fe20000410000ULL, 0x0000003124247220ULL, 0x080fe20000410000ULL,
0x0000003125257220ULL, 0x080fe20000410000ULL, 0x0000003120207220ULL, 0x080fe20000410000ULL,
0x0000003121217220ULL, 0x080fe20000410000ULL, 0x000000311c1c7220ULL, 0x080fe20000410000ULL,
0x000000311d1d7220ULL, 0x080fe20000410000ULL, 0x0000003118187220ULL, 0x080fe20000410000ULL,
0x0000003119197220ULL, 0x080fe20000410000ULL, 0x0000003114147220ULL, 0x080fe20000410000ULL,
0x0000003115157220ULL, 0x080fe20000410000ULL, 0x0000003110107220ULL, 0x080fe20000410000ULL,
0x0000003111117220ULL, 0x080fe20000410000ULL, 0x000000312c2c7220ULL, 0x080fe20000410000ULL,
0x000000312d2d7220ULL, 0x000fce0000410000ULL, 0x0000003207077220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x000000080d317811ULL, 0x002fcc00078ff0ffULL,
0x00001f3132317589ULL, 0x000e6400000e0000ULL, 0x000000312a2a7220ULL, 0x082fe20000410000ULL,
0x000000312b2b7220ULL, 0x080fe20000410000ULL, 0x0000003126267220ULL, 0x080fe20000410000ULL,
0x0000003127277220ULL, 0x080fe20000410000ULL, 0x0000003122227220ULL, 0x080fe20000410000ULL,
0x0000003123237220ULL, 0x080fe20000410000ULL, 0x000000311e1e7220ULL, 0x080fe20000410000ULL,
0x000000311f1f7220ULL, 0x080fe20000410000ULL, 0x000000311a1a7220ULL, 0x080fe20000410000ULL,
0x000000311b1b7220ULL, 0x080fe20000410000ULL, 0x0000003116167220ULL, 0x080fe20000410000ULL,
0x0000003117177220ULL, 0x080fe20000410000ULL, 0x0000003112127220ULL, 0x080fe20000410000ULL,
0x0000003113137220ULL, 0x080fe20000410000ULL, 0x000000312e2e7220ULL, 0x080fe20000410000ULL,
0x000000312f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff38ff7812ULL, 0x000fe20007800839ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x0000004f30527209ULL, 0x000fd60007810000ULL,
0x8000005230300221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b30300820ULL, 0x000fc80000410000ULL, 0x0000003000020308ULL, 0x000ea40000000800ULL,
0x0000000233330220ULL, 0x004fce0000410000ULL, 0x0000000733077221ULL, 0x000fe20000010000ULL,
0x0000000000307805ULL, 0x002fe20000015200ULL, 0x000000083e4f7824ULL, 0x000fe400078e00ffULL,
0x000000010e4e7824ULL, 0x000fc800078e0208ULL, 0x000000014e337824ULL, 0x000fc800078e024fULL,
0x0176a855330075a7ULL, 0x000ea4000800017fULL, 0x0000000000600947ULL, 0x006fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fe400078e00ffULL, 0x000000014e3b7824ULL, 0x000fce00078e024fULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230397210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003932327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x0176a8553b0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991038307816ULL, 0x000fe200000000ffULL, 0x000020000b337824ULL, 0x000fe400078e020eULL,
0x0000000151317824ULL, 0x040fe200078e0250ULL, 0x000000ff3000720cULL, 0x000fe20003f05270ULL,
0x0000000851327824ULL, 0x000fe400078e00ffULL, 0x000010003e337824ULL, 0x000fc600078e0233ULL,
0xfffffff832317812ULL, 0x000fe200078ee231ULL, 0x0001300033547836ULL, 0x000fc80000000000ULL,
0x00000010314c7824ULL, 0x000fe400078e0254ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160dULL, 0x00000002ff00723eULL, 0x000fc600000000ffULL,
0x0000000803317836ULL, 0x000fe20000000000ULL, 0x0000541000307816ULL, 0x000fca0000000000ULL,
0x00001f0330037589ULL, 0x0002a800000e0000ULL, 0x00001f3130007589ULL, 0x0002e400000e0000ULL,
0x011800003f30783bULL, 0x0022e20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000031317232ULL, 0x080fe40000000000ULL, 0x0000000033337232ULL, 0x000fce0000000000ULL,
0x000000004c40783bULL, 0x000f220000004200ULL, 0x000000104b4a7824ULL, 0x000fca00078e0254ULL,
0x000000004a38783bULL, 0x000f620000004200ULL, 0x00000018ff627819ULL, 0x010fe20000011440ULL,
0x0000010041587824ULL, 0x040fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fe40000011441ULL,
0x0000888040657816ULL, 0x040fe400000000ffULL, 0x0000000840577819ULL, 0x040fe200000006ffULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x0000888041687816ULL, 0x040fe200000000ffULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff577819ULL, 0x000fe20000011457ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x00000018ff407819ULL, 0x000fc40000011440ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000018ff567819ULL, 0x022fe40000011438ULL,
0x00008880385a7816ULL, 0x000fe200000000ffULL, 0x00000057006a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff587819ULL, 0x000fe40000011458ULL, 0x00000018ff5d7819ULL, 0x000fe40000011443ULL,
0x0000888043647816ULL, 0x000fc400000000ffULL, 0x00000018ff557819ULL, 0x000fe20000011439ULL,
0x0000004000677306ULL, 0x0009e20000200c00ULL, 0x0000010042577824ULL, 0x042fe200078e00ffULL,
0x0000888039597816ULL, 0x000fe400000000ffULL, 0x0000888042637816ULL, 0x040fe400000000ffULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000041006c7306ULL, 0x0003e20000200c00ULL,
0x0000010043407824ULL, 0x050fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe20000011442ULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe2000001143aULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fc40000011440ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x0000010038417824ULL, 0x042fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000058006b7306ULL, 0x000e620000200c00ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000018ff487819ULL, 0x000fca000001143bULL, 0x0000005700667306ULL, 0x000ff00000200c00ULL,
0x0000004000697306ULL, 0x0009f00000200c00ULL, 0x0000003800577306ULL, 0x000be20000200c00ULL,
0x0000010039407824ULL, 0x010fc400078e00ffULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe40000011440ULL, 0x0000006200627306ULL, 0x000f220000200c00ULL,
0x000001003b387824ULL, 0x028fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fe40000011439ULL,
0x000088803a407816ULL, 0x000fe400000000ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000006100617306ULL, 0x000ef00000200c00ULL, 0x0000004300607306ULL, 0x000ff00000200c00ULL,
0x0000003900587306ULL, 0x0003f00000200c00ULL, 0x0000003800437306ULL, 0x000be20000200c00ULL,
0x0000541068397816ULL, 0x002fce000000006bULL, 0x0000006300637306ULL, 0x000e620000200c00ULL,
0x0000541065387816ULL, 0x024fe2000000006aULL, 0x000100003b657824ULL, 0x000fca00078e00ffULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x0000006400647306ULL, 0x000ea20000200c00ULL,
0x000000383028723cULL, 0x000fee0000001828ULL, 0x0000541067387816ULL, 0x010fe20000000062ULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x000054106c397816ULL, 0x008fce0000000061ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x000000383024723cULL, 0x000fee0000001824ULL,
0x00000042005f7306ULL, 0x0007220000200c00ULL, 0x0000541063387816ULL, 0x002fe40000000066ULL,
0x0000541064397816ULL, 0x004fca0000000069ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x000088803b427816ULL, 0x008fe200000000ffULL, 0x000000383020723cULL, 0x000fec0000001820ULL,
0x00000041005b7306ULL, 0x0002a20000200c00ULL, 0x000054105f387816ULL, 0x010fe4000000005eULL,
0x0000541060397816ULL, 0x000fca000000005dULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x000001003a417824ULL, 0x042fe200078e00ffULL, 0x00000038301c723cULL, 0x000fe2000000181cULL,
0x000100003a3a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000005c005c7306ULL, 0x000e620000200c00ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x000054105a387816ULL, 0x004fca000000005bULL, 0x0000005600567306ULL, 0x000ea20000200c00ULL,
0x0000541059397816ULL, 0x002fce000000005cULL, 0x0000005500557306ULL, 0x000e620000200c00ULL,
0x000000383018723cULL, 0x000fee0000001818ULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x0000541057387816ULL, 0x004fe40000000056ULL, 0x0000541058397816ULL, 0x002fca0000000055ULL,
0x0000004100417306ULL, 0x000e640000200c00ULL, 0x000000383014723cULL, 0x000fec0000001814ULL,
0x0000004600467306ULL, 0x000fe20000200c00ULL, 0x0000541040407816ULL, 0x002fce0000000041ULL,
0x0000004800487306ULL, 0x000ff00000200c00ULL, 0x0000004200427306ULL, 0x000e700000200c00ULL,
0x0000003a003b7306ULL, 0x000ea20000200c00ULL, 0x0000541042417816ULL, 0x002fce0000000043ULL,
0x0000006500657306ULL, 0x000e620000200c00ULL, 0x000000403010723cULL, 0x000fe20000001810ULL,
0x000054103b387816ULL, 0x004fe40000000046ULL, 0x0000541065397816ULL, 0x002fe20000000048ULL,
0x0000001049487824ULL, 0x000fcc00078e0254ULL, 0x00000038302c723cULL, 0x000fe2000000182cULL,
0x011800003430783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000031317232ULL, 0x080fe40000000000ULL,
0x0000000033337232ULL, 0x000fce0000000000ULL, 0x000000004840783bULL, 0x000ee20000004200ULL,
0x0000001047467824ULL, 0x000fca00078e0254ULL, 0x000000004638783bULL, 0x000f220000004200ULL,
0x00000018ff657819ULL, 0x008fe20000011440ULL, 0x0000010040597824ULL, 0x040fe200078e00ffULL,
0x0000888040677816ULL, 0x040fe200000000ffULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe20000011441ULL, 0x00000100415a7824ULL, 0x040fe200078e00ffULL,
0x00008880416a7816ULL, 0x040fe200000000ffULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000006700677306ULL, 0x000fe20000200c00ULL,
0x00000018ff597819ULL, 0x000fc40000011459ULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000018ff587819ULL, 0x010fe20000011438ULL,
0x00000040006e7306ULL, 0x0007e20000200c00ULL, 0x00000018ff577819ULL, 0x000fe40000011439ULL,
0x00008880385d7816ULL, 0x000fe400000000ffULL, 0x00008880395b7816ULL, 0x000fc400000000ffULL,
0x0000888042667816ULL, 0x040fe200000000ffULL, 0x00000059006c7306ULL, 0x0009620000200c00ULL,
0x0000010043407824ULL, 0x048fe200078e00ffULL, 0x0000888043637816ULL, 0x040fe400000000ffULL,
0x00000018ff5f7819ULL, 0x000fe20000011443ULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000010042597824ULL, 0x010fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fc40000011442ULL,
0x0000001042427819ULL, 0x000fe400000006ffULL, 0x00000018ff597819ULL, 0x000fe40000011459ULL,
0x0000005a006d7306ULL, 0x000ee20000200c00ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x00000018ff557819ULL, 0x000fe4000001143aULL,
0x00000018ff567819ULL, 0x000fe2000001143bULL, 0x00000041006b7306ULL, 0x0009f00000200c00ULL,
0x0000004000687306ULL, 0x0007e20000200c00ULL, 0x0000010038417824ULL, 0x010fc400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000006500657306ULL, 0x000f220000200c00ULL, 0x0000010039407824ULL, 0x04cfe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x0000005c005c7306ULL, 0x000ea20000200c00ULL,
0x00000018ff397819ULL, 0x000fce0000011439ULL, 0x0000005900697306ULL, 0x000ff00000200c00ULL,
0x0000003800597306ULL, 0x000bf00000200c00ULL, 0x00000039005a7306ULL, 0x0007e20000200c00ULL,
0x0000541067387816ULL, 0x022fce000000006cULL, 0x0000006600667306ULL, 0x000e620000200c00ULL,
0x000054106a397816ULL, 0x008fce000000006dULL, 0x0000006300637306ULL, 0x000ee20000200c00ULL,
0x000000383028723cULL, 0x000fee0000001828ULL, 0x000054106e387816ULL, 0x010fe20000000065ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x000054106b397816ULL, 0x004fce000000005cULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x000000383024723cULL, 0x000fee0000001824ULL,
0x0000004200647306ULL, 0x0005220000200c00ULL, 0x0000541066387816ULL, 0x002fe40000000069ULL,
0x0000541063397816ULL, 0x008fca0000000068ULL, 0x0000004300627306ULL, 0x0002e20000200c00ULL,
0x000001003a427824ULL, 0x004fe200078e00ffULL, 0x000000383020723cULL, 0x000fe80000001820ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000041005e7306ULL, 0x0005e20000200c00ULL,
0x000001003b437824ULL, 0x002fe200078e00ffULL, 0x0000541064387816ULL, 0x010fc80000000061ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000004000607306ULL, 0x0003e20000200c00ULL,
0x000088803a417816ULL, 0x044fe200000000ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000541062397816ULL, 0x008fc8000000005fULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000005d005d7306ULL, 0x000ea20000200c00ULL, 0x000088803b407816ULL, 0x042fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000038301c723cULL, 0x000fe8000000181cULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000005b005b7306ULL, 0x000e640000200c00ULL,
0x000054105d387816ULL, 0x004fcc000000005eULL, 0x0000005800587306ULL, 0x000ea20000200c00ULL,
0x000054105b397816ULL, 0x002fce0000000060ULL, 0x0000005700577306ULL, 0x000e620000200c00ULL,
0x00000001ff5b7424ULL, 0x000fe200078e00ffULL, 0x000000383018723cULL, 0x000fec0000001818ULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x0000541059387816ULL, 0x004fe40000000058ULL,
0x000054105a397816ULL, 0x002fca0000000057ULL, 0x0000005600567306ULL, 0x000fe40000200c00ULL,
0x000000383014723cULL, 0x000fec0000001814ULL, 0x0000004100417306ULL, 0x000fe20000200c00ULL,
0x0000005b043879a7ULL, 0x00026e000850003fULL, 0x0000004200427306ULL, 0x000ea20000200c00ULL,
0x0176905b36ff79a7ULL, 0x0003ee000850003fULL, 0x0000004000407306ULL, 0x000ff00000200c00ULL,
0x0000004300437306ULL, 0x000ff00000200c00ULL, 0x0000003a005c7306ULL, 0x0004f00000200c00ULL,
0x0000003b005f7306ULL, 0x0009620000200c00ULL, 0x00005410413a7816ULL, 0x004fc40000000042ULL,
0x000054105c5c7816ULL, 0x008fe40000000055ULL, 0x00005410403b7816ULL, 0x010fe40000000043ULL,
0x000054105f5d7816ULL, 0x020fca0000000056ULL, 0x0000003a3010723cULL, 0x000fec0000001810ULL,
0x0000005c302c723cULL, 0x000fee000000182cULL, 0x0000008006307811ULL, 0x000fc800078e40ffULL,
0x000000373000720cULL, 0x000fe40003f06070ULL, 0x0000000105307812ULL, 0x000fd600078ec0ffULL,
0x0000004000740947ULL, 0x002fea0003800000ULL, 0x0000000000307805ULL, 0x000fe20000015200ULL,
0x00000039040075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff387224ULL, 0x000fce00078e00ffULL, 0x000000103800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000138387836ULL, 0x000fce0000000000ULL, 0x00000039040075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000106307836ULL, 0x000fe20000000000ULL,
0x00008e0000067ab9ULL, 0x000fe20000000800ULL, 0x000000c03c327836ULL, 0x000fc60000000000ULL,
0x000000353000720cULL, 0x000fe20003f06070ULL, 0x0000000609437c24ULL, 0x000fd8000f8e0232ULL,
0x0000000000f08947ULL, 0x000fea0003800000ULL, 0x0000003237307248ULL, 0x000fe20007fe0000ULL,
0x000000100f317824ULL, 0x000fe200078e00ffULL, 0x00000003ff337819ULL, 0x000fe2000001160dULL,
0x00008a00ff387b82ULL, 0x000e620000000a00ULL, 0x000000100d417824ULL, 0x000fe400078e00ffULL,
0x0000000130307824ULL, 0x000fe200078e0a32ULL, 0x00000008333b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000131327824ULL, 0x000fe200078e0233ULL, 0x0000007041417812ULL, 0x000fe400078ec0ffULL,
0x0000003031307248ULL, 0x000fe20007fe0000ULL, 0x00000001323a7824ULL, 0x000fc400078e020dULL,
0x0000000832557824ULL, 0x000fe400078e00ffULL, 0x0000000130307824ULL, 0x000fe400078e0a31ULL,
0x0000000131407824ULL, 0x000fe200078e023bULL, 0xfffffff855557812ULL, 0x000fe200078ee23aULL,
0x00000004333a7836ULL, 0x000fe20000000000ULL, 0x000000303300720cULL, 0x080fe20003f66070ULL,
0x0000000c33337836ULL, 0x000fe20000000000ULL, 0x000000303b00720cULL, 0x080fe20003f26070ULL,
0x0000000840597824ULL, 0x000fe200078e00ffULL, 0x000000303a00720cULL, 0x080fe20003f46070ULL,
0x00000001313a7824ULL, 0x000fe200078e023aULL, 0x000000303300720cULL, 0x000fe20003f06070ULL,
0x0000000131427824ULL, 0x000fc400078e0233ULL, 0x0000000132317824ULL, 0x100fe400078e0243ULL,
0x000000013a3b7824ULL, 0x040fe400078e0243ULL, 0x000000013a327824ULL, 0x140fe400078e020dULL,
0x000000083a577824ULL, 0x000fe400078e00ffULL, 0x00000001403a7824ULL, 0x000fe400078e020dULL,
0x0000008031307825ULL, 0x002fe200078e0038ULL, 0xfffffff857577812ULL, 0x000fc400078ee232ULL,
0xfffffff859597812ULL, 0x000fe200078ee23aULL, 0x0000000140337824ULL, 0x100fe200078e0243ULL,
0x0000004130307210ULL, 0x000fe20007f9e0ffULL, 0x0000000142437824ULL, 0x000fe400078e0243ULL,
0x000000803b3a7825ULL, 0x000fc800078e0038ULL, 0x0000008033327825ULL, 0x000fc800078e0038ULL,
0x0000000142407824ULL, 0x040fe200078e020dULL, 0x0000004132327210ULL, 0x000fe20007fbe0ffULL,
0x00000008425b7824ULL, 0x000fe400078e00ffULL, 0x0000008043387825ULL, 0x000fc600078e0038ULL,
0xfffffff85b5b7812ULL, 0x000fe200078ee240ULL, 0x000000ffff317224ULL, 0x000fe200020e0631ULL,
0x000000413a3a7210ULL, 0x000fe20007f9e0ffULL, 0x0000001055437824ULL, 0x100fe200078e0254ULL,
0x0000004138387210ULL, 0x000fe20007fde0ffULL, 0x0000001057557824ULL, 0x100fe400078e0254ULL,
0x000000ffff3b7224ULL, 0x000fe200020e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030437faeULL, 0x0003e2000d901c48ULL, 0x0000001059577824ULL, 0x100fe400078e0254ULL,
0x000000ffff337224ULL, 0x000fe200028e0633ULL, 0x000000003a557faeULL, 0x0003e2000d101c48ULL,
0x000000105b597824ULL, 0x000fc400078e0254ULL, 0x000000ffff397224ULL, 0x000fe200030e0639ULL,
0x0000000032577faeULL, 0x0003e8000c901c48ULL, 0x0000000038597faeULL, 0x0003e2000c101c48ULL,
0x0000000000bc7947ULL, 0x000fea0003800000ULL, 0x00008a00ff387b82ULL, 0x000e620000000a00ULL,
0x000000040f307819ULL, 0x000fe200000006ffULL, 0x000000100d417824ULL, 0x000fc600078e00ffULL,
0x000000300d307211ULL, 0x000fe400078fe8ffULL, 0x0000007041417812ULL, 0x000fc600078ec0ffULL,
0x0000000130317824ULL, 0x040fe400078e020dULL, 0x0000000830327824ULL, 0x000fe400078e00ffULL,
0x0000000830407836ULL, 0x000fc60000000000ULL, 0xfffffff832557812ULL, 0x000fe200078ee231ULL,
0x0000000430327836ULL, 0x000fe40000000000ULL, 0x0000000130317824ULL, 0x100fe400078e0243ULL,
0x0000000c30307836ULL, 0x000fe40000000000ULL, 0x00000001323b7824ULL, 0x040fe400078e0243ULL,
0x00000001323a7824ULL, 0x040fe400078e020dULL, 0x0000000832577824ULL, 0x000fc400078e00ffULL,
0x0000000140337824ULL, 0x040fe400078e0243ULL, 0x0000000140327824ULL, 0x040fe200078e020dULL,
0xfffffff857577812ULL, 0x000fe200078ee23aULL, 0x0000000840597824ULL, 0x000fe400078e00ffULL,
0x0000000130437824ULL, 0x040fe400078e0243ULL, 0x0000000130407824ULL, 0x040fe200078e020dULL,
0xfffffff859597812ULL, 0x000fe200078ee232ULL, 0x00000008305b7824ULL, 0x000fc400078e00ffULL,
0x0000008031307825ULL, 0x002fc600078e0038ULL, 0xfffffff85b5b7812ULL, 0x000fe200078ee240ULL,
0x000000803b3a7825ULL, 0x000fe200078e0038ULL, 0x0000004130307210ULL, 0x000fc60007f1e0ffULL,
0x0000008033327825ULL, 0x000fc800078e0038ULL, 0x0000008043387825ULL, 0x000fe200078e0038ULL,
0x0000004132327210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff317224ULL, 0x000fe200000e0631ULL,
0x000000413a3a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001055437824ULL, 0x100fe200078e0254ULL,
0x0000004138387210ULL, 0x000fe20007f5e0ffULL, 0x0000001057557824ULL, 0x100fe400078e0254ULL,
0x000000ffff3b7224ULL, 0x000fe200000e063bULL, 0x00000039ff397210ULL, 0x000fe200017fe4ffULL,
0x0000001059577824ULL, 0x000fe200078e0254ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000030437faeULL, 0x0003e2000b901c48ULL, 0x000000ffff337224ULL, 0x000fc400008e0633ULL,
0x000000105b597824ULL, 0x000fe200078e0254ULL, 0x000000003a557faeULL, 0x0003e8000b901c48ULL,
0x0000000032577faeULL, 0x0003e8000b901c48ULL, 0x0000000038597faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xffffffe00c337812ULL, 0x040fe400078ec0ffULL,
0x000000100c307812ULL, 0x040fe200078ec0ffULL, 0x00000000ff0079b0ULL, 0x000fe20008000a44ULL,
0xfffffff00c317812ULL, 0x000fe400078ec0ffULL, 0x0000000e30337210ULL, 0x000fe40007ffe033ULL,
0x000000080c307812ULL, 0x000fe200078ec0ffULL, 0x000000010e317824ULL, 0x000fc800078e0231ULL,
0x00000001333b7824ULL, 0x000fe400078e0230ULL, 0x00000001ff307424ULL, 0x000fe400078e00ffULL,
0x000000083e317824ULL, 0x000fe200078e0231ULL, 0x0000000000007918ULL, 0x000fc60000000000ULL,
0x0176a830315479a7ULL, 0x0002a4000850003fULL, 0x017648303b3079a7ULL, 0x0022e4000850003fULL,
0x0000000000327805ULL, 0x000fce0000015200ULL, 0x017648313b0075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fce0000015200ULL, 0x0000003832437210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e33ULL, 0x003d09004300780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c404300780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff387819ULL, 0x000fc80000011439ULL,
0x0000004338387211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000238387819ULL, 0x000fc80000001239ULL, 0x000000380000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x017648313b0075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x0000010041317810ULL, 0x000fe20007ffe045ULL, 0x00000001ff387424ULL, 0x000fc800078e00ffULL,
0x0000000144317824ULL, 0x000fca00078e0231ULL, 0x0170000031337984ULL, 0x000ee80000000800ULL,
0x0172000031307984ULL, 0x0009220000000800ULL, 0x000000523300720bULL, 0x008fda0003f1d000ULL,
0x0000000000397806ULL, 0x000fc800000e0100ULL, 0x0000ffff39ff7812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x016fea0003800000ULL, 0x000000023d327811ULL, 0x000fe400078ff0ffULL,
0x000000523300720bULL, 0x000fe40003f14000ULL, 0x0000003d3200720cULL, 0x000fd60003f25270ULL,
0x0000000000387806ULL, 0x000fe400000e0100ULL, 0x000000803d329824ULL, 0x000fe200078e020eULL,
0x0000003352319209ULL, 0x000fc80007810000ULL, 0x00000032443a9210ULL, 0x000fe40007ffe041ULL,
0x0000991038327816ULL, 0x000fc600000000ffULL, 0x017400313a009388ULL, 0x0003e20000000800ULL,
0x000000ff3200720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000003352317209ULL, 0x000fe40007810000ULL, 0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0038ff7812ULL, 0x000fe2000782c0ffULL, 0x8000003152317221ULL, 0x000fc80000010000ULL,
0x3fb8aa3b31317820ULL, 0x000fc80000410000ULL, 0x0000003100327308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff317819ULL, 0x002fcc000001160dULL,
0x00001f3132317589ULL, 0x004e6400000e0000ULL, 0x0000003128287220ULL, 0x082fe20000410000ULL,
0x0000003129297220ULL, 0x080fe20000410000ULL, 0x0000003124247220ULL, 0x080fe20000410000ULL,
0x0000003125257220ULL, 0x080fe20000410000ULL, 0x0000003120207220ULL, 0x080fe20000410000ULL,
0x0000003121217220ULL, 0x080fe20000410000ULL, 0x000000311c1c7220ULL, 0x080fe20000410000ULL,
0x000000311d1d7220ULL, 0x080fe20000410000ULL, 0x0000003118187220ULL, 0x080fe20000410000ULL,
0x0000003119197220ULL, 0x080fe20000410000ULL, 0x0000003114147220ULL, 0x080fe20000410000ULL,
0x0000003115157220ULL, 0x080fe20000410000ULL, 0x0000003110107220ULL, 0x080fe20000410000ULL,
0x0000003111117220ULL, 0x080fe20000410000ULL, 0x000000312c2c7220ULL, 0x080fe20000410000ULL,
0x000000312d2d7220ULL, 0x000fce0000410000ULL, 0x0000003207077220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x000000080d317811ULL, 0x002fcc00078ff0ffULL,
0x00001f3132317589ULL, 0x000e6400000e0000ULL, 0x000000312a2a7220ULL, 0x082fe20000410000ULL,
0x000000312b2b7220ULL, 0x080fe20000410000ULL, 0x0000003126267220ULL, 0x080fe20000410000ULL,
0x0000003127277220ULL, 0x080fe20000410000ULL, 0x0000003122227220ULL, 0x080fe20000410000ULL,
0x0000003123237220ULL, 0x080fe20000410000ULL, 0x000000311e1e7220ULL, 0x080fe20000410000ULL,
0x000000311f1f7220ULL, 0x080fe20000410000ULL, 0x000000311a1a7220ULL, 0x080fe20000410000ULL,
0x000000311b1b7220ULL, 0x080fe20000410000ULL, 0x0000003116167220ULL, 0x080fe20000410000ULL,
0x0000003117177220ULL, 0x080fe20000410000ULL, 0x0000003112127220ULL, 0x080fe20000410000ULL,
0x0000003113137220ULL, 0x080fe20000410000ULL, 0x000000312e2e7220ULL, 0x080fe20000410000ULL,
0x000000312f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff38ff7812ULL, 0x000fe20007800839ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x0000003352527209ULL, 0x000fd60007810000ULL,
0x8000005233330221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b33330820ULL, 0x000fc80000410000ULL, 0x0000003300020308ULL, 0x000ea40000000800ULL,
0x0000000230300220ULL, 0x004fce0000410000ULL, 0x0000000730077221ULL, 0x000fe20000010000ULL,
0x0000000000307805ULL, 0x002fe20000015200ULL, 0x0176a8534d0075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000327805ULL, 0x000fcc0000015200ULL, 0x0000003230397210ULL, 0x000fca0007f1e1ffULL,
0x0000000133337824ULL, 0x000fe200000e0e31ULL, 0x003d09003900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff327819ULL, 0x000fc80000011433ULL,
0x0000003932327211ULL, 0x000fca00078110ffULL, 0x000000ffff337224ULL, 0x000fca00000e0633ULL,
0x0000000232327819ULL, 0x000fc80000001233ULL, 0x000000320000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x0176a8534d0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000991038307816ULL, 0x000fe200000000ffULL, 0x0000100005317824ULL, 0x000fe400078e00ffULL,
0x0000000151507824ULL, 0x040fe200078e0250ULL, 0x000000ff3000720cULL, 0x000fe20003f05270ULL,
0x0000000851517824ULL, 0x000fe200078e00ffULL, 0x0000100031337812ULL, 0x000fe200078ec0ffULL,
0x000020000b327824ULL, 0x000fc600078e020eULL, 0xfffffff851317812ULL, 0x000fe400078ee250ULL,
0x0001300032507810ULL, 0x000fca0007ffe033ULL, 0x0000001031407824ULL, 0x000fe200078e0250ULL,
0x0000000000180947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160dULL,
0x00000002ff00723eULL, 0x000fc600000000ffULL, 0x0000000803317836ULL, 0x000fe20000000000ULL,
0x0000541000307816ULL, 0x000fca0000000000ULL, 0x00001f0330037589ULL, 0x0002a800000e0000ULL,
0x00001f3130007589ULL, 0x0002e400000e0000ULL, 0x012000003f30783bULL, 0x0022e20000000200ULL,
0x0000000000100947ULL, 0x000fea0003800000ULL, 0x0000000330307232ULL, 0x08cfe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000031317232ULL, 0x080fe40000000000ULL,
0x0000000033337232ULL, 0x000fce0000000000ULL, 0x000000004040783bULL, 0x000f220000004200ULL,
0x000000104b387824ULL, 0x000fcc00078e0250ULL, 0x000000003838783bULL, 0x000f620000004200ULL,
0x00000018ff627819ULL, 0x010fe20000011440ULL, 0x0000010041587824ULL, 0x040fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe40000011441ULL, 0x0000888040657816ULL, 0x040fe400000000ffULL,
0x0000000840577819ULL, 0x040fe200000006ffULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x0000888041687816ULL, 0x040fe200000000ffULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x00000018ff407819ULL, 0x000fc40000011440ULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff567819ULL, 0x022fe40000011438ULL, 0x00008880385a7816ULL, 0x000fe200000000ffULL,
0x00000057006a7306ULL, 0x0003e20000200c00ULL, 0x00000018ff587819ULL, 0x000fe40000011458ULL,
0x00000018ff5d7819ULL, 0x000fe40000011443ULL, 0x0000888043647816ULL, 0x000fc400000000ffULL,
0x00000018ff537819ULL, 0x000fe20000011439ULL, 0x0000004000677306ULL, 0x0009e20000200c00ULL,
0x0000010042577824ULL, 0x042fe200078e00ffULL, 0x0000888039597816ULL, 0x000fe400000000ffULL,
0x0000888042637816ULL, 0x040fe400000000ffULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000041006c7306ULL, 0x0003e20000200c00ULL, 0x0000010043407824ULL, 0x050fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe20000011442ULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe2000001143aULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fc40000011440ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000010038417824ULL, 0x042fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000058006b7306ULL, 0x000e620000200c00ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff517819ULL, 0x000fca000001143bULL,
0x0000005700667306ULL, 0x000ff00000200c00ULL, 0x0000004000697306ULL, 0x0009f00000200c00ULL,
0x0000003800577306ULL, 0x000be20000200c00ULL, 0x0000010039407824ULL, 0x010fc400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011440ULL,
0x0000006200627306ULL, 0x000f220000200c00ULL, 0x000001003b387824ULL, 0x028fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a407816ULL, 0x000fe400000000ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000006100617306ULL, 0x000ef00000200c00ULL,
0x0000004300607306ULL, 0x000ff00000200c00ULL, 0x0000003900587306ULL, 0x0003f00000200c00ULL,
0x0000003800437306ULL, 0x000be20000200c00ULL, 0x0000541068397816ULL, 0x002fce000000006bULL,
0x0000006300637306ULL, 0x000e620000200c00ULL, 0x0000541065387816ULL, 0x024fce000000006aULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x000000383028723cULL, 0x000fee0000001828ULL,
0x0000541067387816ULL, 0x010fe20000000062ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x000054106c397816ULL, 0x008fce0000000061ULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x000000383024723cULL, 0x000fee0000001824ULL, 0x00000042005f7306ULL, 0x0007220000200c00ULL,
0x0000541063387816ULL, 0x002fe40000000066ULL, 0x0000541064397816ULL, 0x004fca0000000069ULL,
0x00000041005b7306ULL, 0x0003e20000200c00ULL, 0x000088803b427816ULL, 0x048fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x000000383020723cULL, 0x000fe80000001820ULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x000001003a417824ULL, 0x042fe200078e00ffULL, 0x000054105f387816ULL, 0x010fe2000000005eULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x0000541060397816ULL, 0x000fc4000000005dULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fe4000001143aULL, 0x00000038301c723cULL, 0x000fea000000181cULL,
0x0000005c005c7306ULL, 0x000e640000200c00ULL, 0x000054105a387816ULL, 0x004fcc000000005bULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x0000541059397816ULL, 0x002fce000000005cULL,
0x0000004100417306ULL, 0x000e620000200c00ULL, 0x000000383018723cULL, 0x000fee0000001818ULL,
0x0000005600567306ULL, 0x000ea20000200c00ULL, 0x0000541040407816ULL, 0x002fce0000000041ULL,
0x0000005300537306ULL, 0x000e620000200c00ULL, 0x0000541057387816ULL, 0x004fce0000000056ULL,
0x0000004b004b7306ULL, 0x000fe20000200c00ULL, 0x0000541058397816ULL, 0x002fce0000000053ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000000383014723cULL, 0x000fee0000001814ULL,
0x0000004200427306ULL, 0x000e700000200c00ULL, 0x0000003a003a7306ULL, 0x000ea20000200c00ULL,
0x0000541042417816ULL, 0x002fce0000000043ULL, 0x0000003b00627306ULL, 0x000e620000200c00ULL,
0x000000403010723cULL, 0x000fe20000001810ULL, 0x000054103a3a7816ULL, 0x004fcc000000004bULL,
0x0000001049407824ULL, 0x000fe200078e0250ULL, 0x00005410623b7816ULL, 0x002fce0000000051ULL,
0x0000003a302c723cULL, 0x000fe2000000182cULL, 0x012000003430783bULL, 0x0002a20000000200ULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x0000000000100947ULL, 0x000fde0003800000ULL,
0x0000000330307232ULL, 0x084fe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000031317232ULL, 0x080fe40000000000ULL, 0x0000000033337232ULL, 0x000fce0000000000ULL,
0x000000004040783bULL, 0x000ee20000004200ULL, 0x0000001047387824ULL, 0x000fcc00078e0250ULL,
0x000000003838783bULL, 0x000f220000004200ULL, 0x00000018ff5d7819ULL, 0x008fe20000011440ULL,
0x0000010040567824ULL, 0x040fe200078e00ffULL, 0x0000888040537816ULL, 0x040fe200000000ffULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe20000011441ULL,
0x0000010041577824ULL, 0x040fe200078e00ffULL, 0x0000888041637816ULL, 0x040fe200000000ffULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x00000018ff567819ULL, 0x000fc40000011456ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x00000018ff597819ULL, 0x000fe40000011443ULL,
0x00008880435f7816ULL, 0x000fe200000000ffULL, 0x0000004000667306ULL, 0x0007e20000200c00ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000018ff5b7819ULL, 0x000fe40000011442ULL,
0x00008880425e7816ULL, 0x000fc400000000ffULL, 0x00000018ff4b7819ULL, 0x010fe20000011438ULL,
0x0000005600627306ULL, 0x0009620000200c00ULL, 0x0000010043407824ULL, 0x048fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011439ULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x000088803b677816ULL, 0x000fe400000000ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x0000010042567824ULL, 0x010fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fc40000011443ULL, 0x0000001042427819ULL, 0x000fe400000006ffULL,
0x0000888039437816ULL, 0x000fe400000000ffULL, 0x00000057006a7306ULL, 0x0007220000200c00ULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0x00000018ff497819ULL, 0x000fe4000001143bULL, 0x00000018ff477819ULL, 0x000fe2000001143aULL,
0x0000004100657306ULL, 0x0009e20000200c00ULL, 0x0000888038577816ULL, 0x008fce00000000ffULL,
0x0000004000687306ULL, 0x0007e20000200c00ULL, 0x0000010038417824ULL, 0x054fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x0000005d005d7306ULL, 0x000ea20000200c00ULL, 0x0000010039407824ULL, 0x048fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe40000011440ULL, 0x0000005c005c7306ULL, 0x000ee20000200c00ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x000088803a407816ULL, 0x000fca00000000ffULL,
0x0000005600617306ULL, 0x000ff00000200c00ULL, 0x0000004200607306ULL, 0x000ff00000200c00ULL,
0x0000003800427306ULL, 0x000bf00000200c00ULL, 0x0000003900567306ULL, 0x0009e20000200c00ULL,
0x0000541053387816ULL, 0x022fe20000000062ULL, 0x000001003b627824ULL, 0x000fc400078e00ffULL,
0x000100003b3b7824ULL, 0x000fe400078e00ffULL, 0x000000ffff537224ULL, 0x000fe200078e0067ULL,
0x00000018ff627819ULL, 0x000fe20000011462ULL, 0x0000005e005e7306ULL, 0x000e620000200c00ULL,
0x0000541063397816ULL, 0x010fe4000000006aULL, 0x00000018ff3b7819ULL, 0x000fca000001143bULL,
0x0000005f005f7306ULL, 0x000f220000200c00ULL, 0x000000383028723cULL, 0x000fee0000001828ULL,
0x0000541066387816ULL, 0x004fe2000000005dULL, 0x0000005b005b7306ULL, 0x000ea20000200c00ULL,
0x0000541065397816ULL, 0x008fce000000005cULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x000000383024723cULL, 0x000fee0000001824ULL, 0x0000006400647306ULL, 0x000ee20000200c00ULL,
0x000100003a397824ULL, 0x000fe200078e00ffULL, 0x000054105e387816ULL, 0x002fc80000000061ULL,
0x00000018ff5c7819ULL, 0x000fe40000011439ULL, 0x000054105f397816ULL, 0x010fe20000000068ULL,
0x0000005700577306ULL, 0x000fec0000200c00ULL, 0x000000383020723cULL, 0x000fe40000001820ULL,
0x0000004100587306ULL, 0x00032a0000200c00ULL, 0x0000541060387816ULL, 0x004fc4000000005bULL,
0x0000541064397816ULL, 0x008fe20000000059ULL, 0x0000004300437306ULL, 0x000fe20000200c00ULL,
0x000001003a417824ULL, 0x002fca00078e00ffULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x00000038301c723cULL, 0x000fe2000000181cULL, 0x0000005a005a7306ULL, 0x000e6c0000200c00ULL,
0x0000541057387816ULL, 0x010fe20000000058ULL, 0x00000001ff577424ULL, 0x000fe200078e00ffULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x0000541043397816ULL, 0x002fce000000005aULL,
0x0000004100417306ULL, 0x000e620000200c00ULL, 0x000000383018723cULL, 0x000fee0000001818ULL,
0x0000004b004b7306ULL, 0x000ea20000200c00ULL, 0x00000057043879a7ULL, 0x0006e2000850003fULL,
0x0000541040407816ULL, 0x002fcc0000000041ULL, 0x0000005100517306ULL, 0x000e620000200c00ULL,
0x0176985736ff79a7ULL, 0x0007e2000850003fULL, 0x0000541042427816ULL, 0x004fcc000000004bULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x0000541056437816ULL, 0x002fce0000000051ULL,
0x0000004900497306ULL, 0x000fe20000200c00ULL, 0x000000423014723cULL, 0x000fee0000001814ULL,
0x0000005300537306ULL, 0x000ff00000200c00ULL, 0x00000062003a7306ULL, 0x000e700000200c00ULL,
0x0000005c005c7306ULL, 0x000ea20000200c00ULL, 0x0000541053417816ULL, 0x002fce000000003aULL,
0x0000003b00587306ULL, 0x000e620000200c00ULL, 0x000000ffff537224ULL, 0x000fe200078e0055ULL,
0x000000403010723cULL, 0x000fe20000001810ULL, 0x000054105c5c7816ULL, 0x004fe40000000047ULL,
0x00005410585d7816ULL, 0x002fce0000000049ULL, 0x0000005c302c723cULL, 0x000fee000000182cULL,
0x000000c006307811ULL, 0x000fc800078e40ffULL, 0x000000373000720cULL, 0x000fe20003f06070ULL,
0x000000ffff307224ULL, 0x000fd800078e003eULL, 0x0000002000200947ULL, 0x008fea0003800000ULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x000000043d327824ULL, 0x000fca00078e00ffULL,
0xfffffff832337812ULL, 0x000fca00078ec0ffULL, 0x000000010e387824ULL, 0x000fc800078e0233ULL,
0x0176c839380075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x000fcc0000015200ULL,
0x00000032303b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003b32327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x0176c839380075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000206307836ULL, 0x000fe20000000000ULL,
0x00008e0000047ab9ULL, 0x000fe20000000800ULL, 0x000001003c3c7836ULL, 0x000fc60000000000ULL,
0x000000353000720cULL, 0x000fe20003f06070ULL, 0x0000000409337c24ULL, 0x000fd8000f8e023cULL,
0x0000000000f08947ULL, 0x000fea0003800000ULL, 0x0000003c37307248ULL, 0x000fe20007fe0000ULL,
0x000000100f317824ULL, 0x000fe200078e00ffULL, 0x00000003ff327819ULL, 0x000fe2000001160dULL,
0x00008a00ff387b82ULL, 0x000e640000000a00ULL, 0x0000000130307824ULL, 0x000fe200078e0a3cULL,
0x00000032313a7210ULL, 0x000fe20007ffe0ffULL, 0x00000008323e7836ULL, 0x000fc60000000000ULL,
0x0000003031307248ULL, 0x000fe20007fe0000ULL, 0x000000013a3b7824ULL, 0x040fe400078e020dULL,
0x000000083a3c7824ULL, 0x000fe400078e00ffULL, 0x0000000130307824ULL, 0x000fc600078e0a31ULL,
0xfffffff83c437812ULL, 0x000fe200078ee23bULL, 0x00000004323b7836ULL, 0x000fe20000000000ULL,
0x000000303200720cULL, 0x080fe20003f66070ULL, 0x0000000c32327836ULL, 0x000fe20000000000ULL,
0x000000303e00720cULL, 0x080fe20003f26070ULL, 0x00000001313c7824ULL, 0x000fe200078e023bULL,
0x000000303b00720cULL, 0x080fe20003f46070ULL, 0x00000001313e7824ULL, 0x040fe200078e023eULL,
0x000000303200720cULL, 0x000fe20003f06070ULL, 0x0000000131407824ULL, 0x000fe400078e0232ULL,
0x000000100d327824ULL, 0x000fc400078e00ffULL, 0x000000013a317824ULL, 0x000fe400078e0233ULL,
0x000000013c3a7824ULL, 0x000fe200078e020dULL, 0x0000007032327812ULL, 0x000fe200078ec0ffULL,
0x000000083c477824ULL, 0x000fe400078e00ffULL, 0x0000008031307825ULL, 0x002fc600078e0038ULL,
0xfffffff847477812ULL, 0x000fe200078ee23aULL, 0x000000013c3b7824ULL, 0x100fe200078e0233ULL,
0x0000003230307210ULL, 0x000fe20007f9e0ffULL, 0x000000013e417824ULL, 0x100fe400078e0233ULL,
0x0000000140337824ULL, 0x000fe400078e0233ULL, 0x000000013e3c7824ULL, 0x140fe400078e020dULL,
0x000000083e497824ULL, 0x000fe400078e00ffULL, 0x00000001403e7824ULL, 0x000fc400078e020dULL,
0x00000008404b7824ULL, 0x000fe200078e00ffULL, 0xfffffff849497812ULL, 0x000fe200078ee23cULL,
0x000000803b3a7825ULL, 0x000fc600078e0038ULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee23eULL,
0x0000008041407825ULL, 0x000fc800078e0038ULL, 0x0000008033387825ULL, 0x000fe200078e0038ULL,
0x0000003240407210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff317224ULL, 0x000fe200020e0631ULL,
0x000000323a3a7210ULL, 0x000fe20007f9e0ffULL, 0x0000001043337824ULL, 0x100fe200078e0250ULL,
0x0000003238387210ULL, 0x000fe20007fde0ffULL, 0x0000001047437824ULL, 0x100fe200078e0250ULL,
0x0000005049477211ULL, 0x000fe200078e20ffULL, 0x000000ffff3b7224ULL, 0x000fe200020e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030337faeULL, 0x0003e2000d901c48ULL,
0x000000ffff417224ULL, 0x000fe400028e0641ULL, 0x000000104b497824ULL, 0x000fe200078e0250ULL,
0x000000003a437faeULL, 0x0003e2000d101c48ULL, 0x000000ffff397224ULL, 0x000fc600030e0639ULL,
0x0000000040477faeULL, 0x0003e8000c901c48ULL, 0x0000000038497faeULL, 0x0003e2000c101c48ULL,
0x0000000000bc7947ULL, 0x000fea0003800000ULL, 0x00008a00ff387b82ULL, 0x000e620000000a00ULL,
0x000000100f307824ULL, 0x000fe400078e00ffULL, 0x000000100d327824ULL, 0x000fc600078e00ffULL,
0x000000300d307211ULL, 0x000fe400078fe8ffULL, 0x0000007032327812ULL, 0x000fc600078ec0ffULL,
0x0000000130317824ULL, 0x040fe400078e020dULL, 0x00000008303a7824ULL, 0x000fe400078e00ffULL,
0x00000008303e7836ULL, 0x000fc60000000000ULL, 0xfffffff83a437812ULL, 0x000fe200078ee231ULL,
0x00000004303a7836ULL, 0x000fe40000000000ULL, 0x0000000130317824ULL, 0x100fe400078e0233ULL,
0x0000000c30307836ULL, 0x000fe40000000000ULL, 0x000000013a3b7824ULL, 0x040fe400078e0233ULL,
0x000000013a3c7824ULL, 0x040fe400078e020dULL, 0x000000083a477824ULL, 0x000fc400078e00ffULL,
0x000000013e417824ULL, 0x040fe400078e0233ULL, 0x000000013e3a7824ULL, 0x040fe200078e020dULL,
0xfffffff847477812ULL, 0x000fe200078ee23cULL, 0x000000083e497824ULL, 0x000fe400078e00ffULL,
0x0000000130337824ULL, 0x040fe400078e0233ULL, 0x00000001303e7824ULL, 0x040fe200078e020dULL,
0xfffffff849497812ULL, 0x000fe200078ee23aULL, 0x00000008304b7824ULL, 0x000fc400078e00ffULL,
0x0000008031307825ULL, 0x002fc600078e0038ULL, 0xfffffff84b4b7812ULL, 0x000fe200078ee23eULL,
0x000000803b3a7825ULL, 0x000fe200078e0038ULL, 0x0000003230307210ULL, 0x000fc60007f1e0ffULL,
0x0000008041407825ULL, 0x000fc800078e0038ULL, 0x0000008033387825ULL, 0x000fe200078e0038ULL,
0x0000003240407210ULL, 0x000fc60007f3e0ffULL, 0x000000ffff317224ULL, 0x000fe200000e0631ULL,
0x000000323a3a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001043337824ULL, 0x100fe200078e0250ULL,
0x0000003238387210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff417224ULL, 0x000fe200008e0641ULL,
0x0000005047437211ULL, 0x000fe200078e20ffULL, 0x000000ffff3b7224ULL, 0x000fe200000e063bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000030337faeULL, 0x0003e2000b901c48ULL,
0x0000001049477824ULL, 0x100fe400078e0250ULL, 0x000000104b497824ULL, 0x000fe200078e0250ULL,
0x000000003a437faeULL, 0x0003e2000b901c48ULL, 0x000000ffff397224ULL, 0x000fc600010e0639ULL,
0x0000000040477faeULL, 0x0003e8000b901c48ULL, 0x0000000038497faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0xffffffe00c317812ULL, 0x040fe200078ec0ffULL,
0x00000001ff3a7424ULL, 0x000fe200078e00ffULL, 0x000000100c307812ULL, 0x040fe200078ec0ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x000000080c337812ULL, 0x000fe400078ec0ffULL,
0x0000000e30387210ULL, 0x000fe20007ffe031ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0176a83a4d3079a7ULL, 0x0002a6000850003fULL, 0x0000000138417824ULL, 0x000fc800078e0233ULL,
0x0176683a413a79a7ULL, 0x0022e4000850003fULL, 0x000000ffff537224ULL, 0x006fce00078e0031ULL,
0x0000000000307805ULL, 0x000fe20000015200ULL, 0x0176683b410075a7ULL, 0x008e64000800017fULL,
0x00000000005c0947ULL, 0x00afea0003800000ULL, 0x000000ffff3c7224ULL, 0x000fce00078e00ffULL,
0x000000103c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x0000003830387210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e31ULL, 0x003d09003800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff337819ULL, 0x000fc80000011439ULL,
0x0000003833337211ULL, 0x000fca00078110ffULL, 0x000000ffff387224ULL, 0x000fca00000e0639ULL,
0x0000000233337819ULL, 0x000fc80000001238ULL, 0x000000330000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013c3c7836ULL, 0x000fce0000000000ULL,
0x0176683b410075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000018032457810ULL, 0x000fe20007ffe045ULL, 0x00000001ff387424ULL, 0x000fc800078e00ffULL,
0x0000000144457824ULL, 0x000fca00078e0245ULL, 0x0170000045317984ULL, 0x000e680000000800ULL,
0x0172000045307984ULL, 0x0004a20000000800ULL, 0x000000523100720bULL, 0x002fda0003f1d000ULL,
0x0000000000397806ULL, 0x000fc800000e0100ULL, 0x0000ffff39ff7812ULL, 0x000fda000780c0ffULL,
0x0000000400008947ULL, 0x004fea0003800000ULL, 0x000000033d387811ULL, 0x000fe400078ff0ffULL,
0x000000523100720bULL, 0x000fe40003f14000ULL, 0x0000003d3800720cULL, 0x000fd60003f25270ULL,
0x0000000000387806ULL, 0x000fe400000e0100ULL, 0x000000803d3b9824ULL, 0x000fe200078e020eULL,
0x0000005231339209ULL, 0x000fc80007810000ULL, 0x0000003b44449210ULL, 0x000fe40007ffe032ULL,
0x0000991038327816ULL, 0x000fc600000000ffULL, 0x0174003344009388ULL, 0x0003e20000000800ULL,
0x000000ff3200720cULL, 0x000fda0003f05270ULL, 0x0000000000b48947ULL, 0x002fea0003800000ULL,
0x0000005231337209ULL, 0x000fe40007810000ULL, 0x000000ff38ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0038ff7812ULL, 0x000fe2000782c0ffULL, 0x0000005233327221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b32327820ULL, 0x000fc80000410000ULL, 0x00000032003a7308ULL, 0x0002a40000000800ULL,
0x0000000000488947ULL, 0x000fea0003800000ULL, 0x00000002ff337819ULL, 0x000fca000001160dULL,
0x00001f333a327589ULL, 0x006e6400000e0000ULL, 0x0000003228287220ULL, 0x082fe20000410000ULL,
0x0000003229297220ULL, 0x080fe20000410000ULL, 0x0000003224247220ULL, 0x080fe20000410000ULL,
0x0000003225257220ULL, 0x080fe20000410000ULL, 0x0000003220207220ULL, 0x080fe20000410000ULL,
0x0000003221217220ULL, 0x080fe20000410000ULL, 0x000000321c1c7220ULL, 0x080fe20000410000ULL,
0x000000321d1d7220ULL, 0x080fe20000410000ULL, 0x0000003218187220ULL, 0x080fe20000410000ULL,
0x0000003219197220ULL, 0x080fe20000410000ULL, 0x0000003214147220ULL, 0x080fe20000410000ULL,
0x0000003215157220ULL, 0x080fe20000410000ULL, 0x0000003210107220ULL, 0x080fe20000410000ULL,
0x0000003211117220ULL, 0x080fe20000410000ULL, 0x000000322c2c7220ULL, 0x080fe20000410000ULL,
0x000000322d2d7220ULL, 0x000fce0000410000ULL, 0x0000003a07077220ULL, 0x004fe20000410000ULL,
0x0000000000489947ULL, 0x000fec0003800000ULL, 0x000000080d337811ULL, 0x000fca00078ff0ffULL,
0x00001f333a327589ULL, 0x002e6400000e0000ULL, 0x000000322a2a7220ULL, 0x082fe20000410000ULL,
0x000000322b2b7220ULL, 0x080fe20000410000ULL, 0x0000003226267220ULL, 0x080fe20000410000ULL,
0x0000003227277220ULL, 0x080fe20000410000ULL, 0x0000003222227220ULL, 0x080fe20000410000ULL,
0x0000003223237220ULL, 0x080fe20000410000ULL, 0x000000321e1e7220ULL, 0x080fe20000410000ULL,
0x000000321f1f7220ULL, 0x080fe20000410000ULL, 0x000000321a1a7220ULL, 0x080fe20000410000ULL,
0x000000321b1b7220ULL, 0x080fe20000410000ULL, 0x0000003216167220ULL, 0x080fe20000410000ULL,
0x0000003217177220ULL, 0x080fe20000410000ULL, 0x0000003212127220ULL, 0x080fe20000410000ULL,
0x0000003213137220ULL, 0x080fe20000410000ULL, 0x000000322e2e7220ULL, 0x080fe20000410000ULL,
0x000000322f2f7220ULL, 0x000fce0000410000ULL, 0x0000ffff38ff7812ULL, 0x000fe20007800839ULL,
0x00000001ff387424ULL, 0x000fe200078e00ffULL, 0x0000005231527209ULL, 0x000fd60007810000ULL,
0x8000005231310221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b31310820ULL, 0x000fc80000410000ULL, 0x0000003100020308ULL, 0x000ea40000000800ULL,
0x0000000230300220ULL, 0x004fce0000410000ULL, 0x0000000730077221ULL, 0x000fce0000010000ULL,
0x0000000000307805ULL, 0x000fce0000015200ULL, 0x000000014e4f7824ULL, 0x000fc800078e024fULL,
0x0176a8554f0075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff3a7224ULL, 0x000fce00078e00ffULL, 0x000000103a00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000327805ULL, 0x002fcc0000015200ULL,
0x0000003230397210ULL, 0x000fca0007f1e1ffULL, 0x0000000133337824ULL, 0x000fe200000e0e31ULL,
0x003d09003900780cULL, 0x000fc80003f06070ULL, 0x000000ff3300720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403900780cULL, 0x000fc80003f06070ULL,
0x000000ff3300720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff327819ULL, 0x000fc80000011433ULL, 0x0000003932327211ULL, 0x000fca00078110ffULL,
0x000000ffff337224ULL, 0x000fca00000e0633ULL, 0x0000000232327819ULL, 0x000fc80000001233ULL,
0x000000320000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000013a3a7836ULL, 0x000fce0000000000ULL, 0x0176a8554f0075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x0000991038307816ULL, 0x000fc800000000ffULL,
0x000000ff3000720cULL, 0x000fda0003f05270ULL, 0x0000000000180947ULL, 0x000fea0003800000ULL,
0x00000002ff037819ULL, 0x000fe4000001160dULL, 0x00000002ff00723eULL, 0x000fc600000000ffULL,
0x0000000803317836ULL, 0x000fe20000000000ULL, 0x0000541000307816ULL, 0x000fca0000000000ULL,
0x00001f0330037589ULL, 0x0004e800000e0000ULL, 0x00001f3130007589ULL, 0x00046400000e0000ULL,
0x012800003f30783bULL, 0x0062a20000000200ULL, 0x0000000000100947ULL, 0x000fea0003800000ULL,
0x0000000330307232ULL, 0x08cfe40000000000ULL, 0x0000000332327232ULL, 0x000fe40000000000ULL,
0x0000000031317232ULL, 0x080fe40000000000ULL, 0x0000000033337232ULL, 0x000fce0000000000ULL,
0x000000004c40783bULL, 0x000f280000004200ULL, 0x000000004a38783bULL, 0x000b620000004200ULL,
0x00000018ff497819ULL, 0x010fe20000011440ULL, 0x00000100404a7824ULL, 0x022fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe20000011441ULL, 0x00000100424e7824ULL, 0x000fe200078e00ffULL,
0x00008880404d7816ULL, 0x040fe200000000ffULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x0000888041557816ULL, 0x040fe200000000ffULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x00000008414c7819ULL, 0x040fe200000006ffULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fc40000011440ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x0000004000547306ULL, 0x0003e20000200c00ULL,
0x00000018ff3f7819ULL, 0x008fe40000011438ULL, 0x00000018ff4a7819ULL, 0x000fe4000001144aULL,
0x00000018ff4f7819ULL, 0x000fe4000001144eULL, 0x00000018ff477819ULL, 0x000fe20000011443ULL,
0x0000004c00607306ULL, 0x0007e20000200c00ULL, 0x0000010043407824ULL, 0x042fe200078e00ffULL,
0x00008880434e7816ULL, 0x040fe200000000ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fc40000011439ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x00000041005c7306ULL, 0x0003e20000200c00ULL, 0x00008880384c7816ULL, 0x048fe400000000ffULL,
0x0000888039507816ULL, 0x000fe400000000ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x00000018ff457819ULL, 0x000fe20000011442ULL, 0x0000004d004d7306ULL, 0x000fe20000200c00ULL,
0x0000010038417824ULL, 0x042fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143aULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fc4000001143bULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004a005a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff387819ULL, 0x000fce0000011438ULL, 0x0000005500557306ULL, 0x000ee20000200c00ULL,
0x00008880424a7816ULL, 0x042fe200000000ffULL, 0x0001000042427824ULL, 0x000fca00078e00ffULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x00000040005b7306ULL, 0x0003f00000200c00ULL,
0x0000003800587306ULL, 0x0009e20000200c00ULL, 0x0000010039407824ULL, 0x002fc400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000004b004b7306ULL, 0x000e620000200c00ULL, 0x000001003b387824ULL, 0x010fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fc80000011439ULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x00000043005e7306ULL, 0x000ff00000200c00ULL, 0x0000003900577306ULL, 0x0007f00000200c00ULL,
0x0000003800437306ULL, 0x0009e20000200c00ULL, 0x0000541055397816ULL, 0x008fce0000000060ULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x000054104d387816ULL, 0x010fe2000000005aULL,
0x000100003b4d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000004f004f7306ULL, 0x000ee20000200c00ULL, 0x000000383028723cULL, 0x004fee0000001828ULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x0000541054387816ULL, 0x000fc40000000049ULL,
0x000054105c397816ULL, 0x002fca000000004bULL, 0x0000004200567306ULL, 0x0003e40000200c00ULL,
0x000000383024723cULL, 0x000fec0000001824ULL, 0x0000004100517306ULL, 0x0009e20000200c00ULL,
0x000001003a427824ULL, 0x002fe200078e00ffULL, 0x000054104a387816ULL, 0x008fc4000000004fULL,
0x000054104e397816ULL, 0x004fe4000000005bULL, 0x00000018ff5d7819ULL, 0x000fe40000011442ULL,
0x0000004500457306ULL, 0x000e620000200c00ULL, 0x000088803a417816ULL, 0x050fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000088803b427816ULL, 0x000fe200000000ffULL,
0x000000383020723cULL, 0x000fe60000001820ULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0000004700477306ULL, 0x000ea60000200c00ULL, 0x0000541056387816ULL, 0x002fca0000000045ULL,
0x0000004000597306ULL, 0x000fe20000200c00ULL, 0x000054105e397816ULL, 0x004fce0000000047ULL,
0x0000004100417306ULL, 0x000fe20000200c00ULL, 0x00000038301c723cULL, 0x000fee000000181cULL,
0x0000005d00407306ULL, 0x000e700000200c00ULL, 0x0000003f003f7306ULL, 0x000ea20000200c00ULL,
0x0000541041407816ULL, 0x002fce0000000040ULL, 0x0000004400447306ULL, 0x000e620000200c00ULL,
0x0000541058567816ULL, 0x004fce000000003fULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000541057577816ULL, 0x002fce0000000044ULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x000000563014723cULL, 0x000fee0000001814ULL, 0x0000004c004c7306ULL, 0x000e700000200c00ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x000054104c4c7816ULL, 0x002fce0000000051ULL,
0x0000004200427306ULL, 0x000e700000200c00ULL, 0x0000003a003b7306ULL, 0x000ea20000200c00ULL,
0x0000541042417816ULL, 0x002fce0000000043ULL, 0x0000004d00497306ULL, 0x0002e20000200c00ULL,
0x000000403010723cULL, 0x000fe20000001810ULL, 0x000054103b387816ULL, 0x004fe4000000003cULL,
0x00005410504d7816ULL, 0x002fe40000000059ULL, 0x0000541049397816ULL, 0x008fca000000003eULL,
0x0000004c3018723cULL, 0x000fec0000001818ULL, 0x00000038302c723cULL, 0x000fe2000000182cULL,
0x012800003430783bULL, 0x0002a20000000200ULL, 0x0000000000007918ULL, 0x000fce0000000000ULL,
0x0000000000100947ULL, 0x000fde0003800000ULL, 0x0000000330307232ULL, 0x084fe40000000000ULL,
0x0000000332327232ULL, 0x000fe40000000000ULL, 0x0000000031317232ULL, 0x080fe40000000000ULL,
0x0000000033337232ULL, 0x000fce0000000000ULL, 0x000000004840783bULL, 0x000ee80000004200ULL,
0x000000004638783bULL, 0x0009620000004200ULL, 0x00000018ff497819ULL, 0x008fe20000011440ULL,
0x0000010040467824ULL, 0x050fe200078e00ffULL, 0x0000888040487816ULL, 0x040fe200000000ffULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe20000011441ULL,
0x00000100414a7824ULL, 0x040fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x00000100424b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x0000888041587816ULL, 0x040fe200000000ffULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe2000001144aULL,
0x000001003b5c7824ULL, 0x022fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fc40000011442ULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x0000004000567306ULL, 0x0003e20000200c00ULL,
0x00000018ff3e7819ULL, 0x000fe40000011438ULL, 0x00000018ff3f7819ULL, 0x000fe40000011439ULL,
0x00000018ff457819ULL, 0x000fe40000011443ULL, 0x00000018ff4b7819ULL, 0x000fe2000001144bULL,
0x0000004600557306ULL, 0x0007e20000200c00ULL, 0x0000010043407824ULL, 0x042fe200078e00ffULL,
0x00008880434c7816ULL, 0x040fe200000000ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fc4000001143aULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x0000888042467816ULL, 0x048fe200000000ffULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fe40000011443ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143bULL, 0x00000018ff517819ULL, 0x000fe20000011442ULL,
0x0000004a005b7306ULL, 0x0003e20000200c00ULL, 0x0000888038427816ULL, 0x000fc400000000ffULL,
0x00000018ff5c7819ULL, 0x000fca000001145cULL, 0x0000004100547306ULL, 0x0007e20000200c00ULL,
0x00008880394a7816ULL, 0x002fce00000000ffULL, 0x0000004000597306ULL, 0x0003e20000200c00ULL,
0x0000010038417824ULL, 0x048fe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x0000000839407819ULL, 0x042fe200000006ffULL, 0x0001000039397824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0000004700477306ULL, 0x000ff00000200c00ULL,
0x0000004600467306ULL, 0x000ff00000200c00ULL, 0x0000004b004b7306ULL, 0x000e700000200c00ULL,
0x0000004c004c7306ULL, 0x000ee20000200c00ULL, 0x0000541046467816ULL, 0x002fce000000004bULL,
0x00000038004f7306ULL, 0x0003f00000200c00ULL, 0x00000039004e7306ULL, 0x0009e20000200c00ULL,
0x0000541048387816ULL, 0x002fce0000000055ULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x0000541058397816ULL, 0x010fce000000005bULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x000000383028723cULL, 0x004fee0000001828ULL, 0x0000005100517306ULL, 0x000e620000200c00ULL,
0x0000541056387816ULL, 0x000fe40000000049ULL, 0x0000541054397816ULL, 0x000fc40000000047ULL,
0x000054104c477816ULL, 0x008fc60000000059ULL, 0x0000004300507306ULL, 0x0004e40000200c00ULL,
0x000000383024723cULL, 0x000fe20000001824ULL, 0x0000541051447816ULL, 0x002fca0000000044ULL,
0x00000041004d7306ULL, 0x0003e20000200c00ULL, 0x000088803a437816ULL, 0x004fe200000000ffULL,
0x000100003b387824ULL, 0x000fe200078e00ffULL, 0x000000463020723cULL, 0x000fe20000001820ULL,
0x0000541050457816ULL, 0x008fc80000000045ULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x000001003a417824ULL, 0x042fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011438ULL,
0x000100003a3a7824ULL, 0x000fe400078e00ffULL, 0x00000001ff477424ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe20000011441ULL, 0x00000044301c723cULL, 0x000fe2000000181cULL,
0x000088803b417816ULL, 0x000fe200000000ffULL, 0x0000004000577306ULL, 0x000fe20000200c00ULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x00000047043879a7ULL, 0x00026c000850003fULL,
0x0000003a003b7306ULL, 0x000ea20000200c00ULL, 0x0176a04736ff79a7ULL, 0x0003ee000850003fULL,
0x0000003e003e7306ULL, 0x000ee20000200c00ULL, 0x000054103b3a7816ULL, 0x004fce0000000034ULL,
0x0000003f003f7306ULL, 0x000ea20000200c00ULL, 0x000054104f3e7816ULL, 0x008fce000000003eULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054104e3f7816ULL, 0x004fce000000003fULL,
0x0000004200427306ULL, 0x000ea20000200c00ULL, 0x0000003e3014723cULL, 0x000fee0000001814ULL,
0x0000004a004a7306ULL, 0x000ee20000200c00ULL, 0x0000541042567816ULL, 0x004fce000000004dULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x000054104a577816ULL, 0x008fce0000000057ULL,
0x0000005a00407306ULL, 0x000ea20000200c00ULL, 0x000000563018723cULL, 0x000fee0000001818ULL,
0x0000004100417306ULL, 0x000fe20000200c00ULL, 0x0000541043407816ULL, 0x004fce0000000040ULL,
0x0000005c005c7306ULL, 0x000eb00000200c00ULL, 0x0000004600457306ULL, 0x000ee20000200c00ULL,
0x0000541041417816ULL, 0x004fce000000005cULL, 0x000000403010723cULL, 0x000fe20000001810ULL,
0x00005410453b7816ULL, 0x008fce000000003cULL, 0x0000003a302c723cULL, 0x000fee000000182cULL,
0x0000000105307812ULL, 0x002fde00078ec0ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000106067836ULL, 0x000fca0000000000ULL, 0x000000350600720cULL, 0x000fda0003f06070ULL,
0xffffff7400bc8947ULL, 0x000fea000383ffffULL, 0x000000ff3500720cULL, 0x000fe20003f05270ULL,
0x000000ffff327224ULL, 0x000fe400078e0015ULL, 0x000000ffff307224ULL, 0x000fe400078e0019ULL,
0x000000ffff317224ULL, 0x000fe400078e0014ULL, 0x000000ffff197224ULL, 0x000fe400078e0018ULL,
0x000000ffff157224ULL, 0x000fe400078e001cULL, 0x000000ffff0d7224ULL, 0x000fc400078e0021ULL,
0x000000ffff097224ULL, 0x000fe200078e0020ULL, 0x0000000000d48947ULL, 0x000fec0003800000ULL,
0x0180000007007836ULL, 0x000fe20000000000ULL, 0x000000b000007945ULL, 0x000fe80003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x00000000000c0947ULL, 0x000fea0003800000ULL, 0x00009d5000047802ULL, 0x000fce0000000f00ULL,
0x0000006400c07944ULL, 0x006fea0003c00000ULL, 0x0000000000107947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x008fc80000000007ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fce0000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009200ff027b82ULL, 0x000f240000000a00ULL,
0x0000000802037981ULL, 0x010f22000c1e9900ULL, 0x0000000000057919ULL, 0x000f640000000000ULL,
0x00000002ff077819ULL, 0x02efe40000011605ULL, 0x0000000805057811ULL, 0x000fe200078ff0ffULL,
0x0000000003007220ULL, 0x010fca0000410000ULL, 0x00001f0700047589ULL, 0x000e6800000e0000ULL,
0x00001f0500067589ULL, 0x000ea200000e0000ULL, 0x0000002804287220ULL, 0x042fe20000410000ULL,
0x0000002904297220ULL, 0x040fe20000410000ULL, 0x0000002404247220ULL, 0x040fe20000410000ULL,
0x0000002504257220ULL, 0x040fe20000410000ULL, 0x0000000904097220ULL, 0x040fe20000410000ULL,
0x0000000d040d7220ULL, 0x040fe20000410000ULL, 0x0000001504157220ULL, 0x040fe20000410000ULL,
0x0000001d041d7220ULL, 0x040fe20000410000ULL, 0x0000001904197220ULL, 0x040fe20000410000ULL,
0x0000003004307220ULL, 0x040fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000003204327220ULL, 0x040fe20000410000ULL, 0x0000001004107220ULL, 0x040fe20000410000ULL,
0x0000001104117220ULL, 0x040fe20000410000ULL, 0x0000002c042c7220ULL, 0x040fe20000410000ULL,
0x0000002d042d7220ULL, 0x000fe20000410000ULL, 0x0000002a062a7220ULL, 0x044fe20000410000ULL,
0x0000002b062b7220ULL, 0x040fe20000410000ULL, 0x0000002606267220ULL, 0x040fe20000410000ULL,
0x0000002706277220ULL, 0x040fe20000410000ULL, 0x0000002206227220ULL, 0x040fe20000410000ULL,
0x0000002306237220ULL, 0x040fe20000410000ULL, 0x0000001e061e7220ULL, 0x040fe20000410000ULL,
0x0000001f061f7220ULL, 0x040fe20000410000ULL, 0x0000001a061a7220ULL, 0x040fe20000410000ULL,
0x0000001b061b7220ULL, 0x040fe20000410000ULL, 0x0000001606167220ULL, 0x040fe20000410000ULL,
0x0000001706177220ULL, 0x040fe20000410000ULL, 0x0000001206127220ULL, 0x040fe20000410000ULL,
0x0000001306137220ULL, 0x040fe20000410000ULL, 0x0000002e062e7220ULL, 0x040fe20000410000ULL,
0x0000002f062f7220ULL, 0x000fce0000410000ULL, 0x0000000000037919ULL, 0x000ee20000000000ULL,
0x000010000f0e7824ULL, 0x000fe200078e020eULL, 0x000000101110723eULL, 0x000fe200000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000222323723eULL, 0x000fe400000000ffULL,
0x0000001e1f1e723eULL, 0x000fc400000000ffULL, 0x0000001a1b1a723eULL, 0x000fe400000000ffULL,
0x0000541023227816ULL, 0x140fe4000000001eULL, 0x0000763223237816ULL, 0x000fe4000000001eULL,
0x000000121312723eULL, 0x000fe400000000ffULL, 0x000000ff0b00720cULL, 0x000fe40003f05270ULL,
0x0000000203007812ULL, 0x008fc400078ec0ffULL, 0x0000000803077811ULL, 0x000fe400078ff0ffULL,
0x00000002ff057819ULL, 0x000fe40000011603ULL, 0x0000000700047211ULL, 0x040fe200078ff8ffULL,
0x0000000807077824ULL, 0x000fe200078e00ffULL, 0x0000000500027211ULL, 0x000fe200078ff8ffULL,
0x0000000805217824ULL, 0x040fe400078e00ffULL, 0x0000000805187824ULL, 0x000fe200078e00ffULL,
0xfffffff807087812ULL, 0x000fe200078ee204ULL, 0x0000000202007836ULL, 0x000fc40000000000ULL,
0x0000000805077824ULL, 0x000fe400078e00ffULL, 0x0000000402047836ULL, 0x000fe20000000000ULL,
0xfffffff821067812ULL, 0x000fe200078ee200ULL, 0x000008000b057824ULL, 0x000fe200078e020eULL,
0xfffffff807007812ULL, 0x000fe400078ee202ULL, 0x0000000602077810ULL, 0x000fe20007ffe0ffULL,
0x0000000803027824ULL, 0x000fe200078e00ffULL, 0xfffffff8210c7812ULL, 0x000fe200078ee204ULL,
0x0000001000047824ULL, 0x100fe200078e0205ULL, 0xfffffff818187812ULL, 0x000fe200078ee207ULL,
0x00000010081c7824ULL, 0x100fe200078e0205ULL, 0x0000000802077812ULL, 0x000fe200078ec0ffULL,
0x0000001006087824ULL, 0x100fe200078e0205ULL, 0x000000282900723eULL, 0x000fe200000000ffULL,
0x000000100c147824ULL, 0x000fe200078e0205ULL, 0x000000242502723eULL, 0x000fe200000000ffULL,
0x0000000104067824ULL, 0x000fe200078e0207ULL, 0x000000193004723eULL, 0x000fe200000000ffULL,
0x0000001018187824ULL, 0x000fe200078e0205ULL, 0x0000541000207816ULL, 0x040fe20000000002ULL,
0x00000001071c7824ULL, 0x040fe200078e021cULL, 0x0000763200217816ULL, 0x000fe20000000002ULL,
0x00000001070c7824ULL, 0x000fe200078e0208ULL, 0x000000090d00723eULL, 0x000fe200000000ffULL,
0x0000000107147824ULL, 0x000fe200078e0214ULL, 0x000000151d02723eULL, 0x000fe200000000ffULL,
0x0000002006007388ULL, 0x0007e20000000a00ULL, 0x0000000107187824ULL, 0x000fe200078e0218ULL,
0x000000313205723eULL, 0x000fc400000000ffULL, 0x0000763200077816ULL, 0x140fe40000000002ULL,
0x0000002c2d08723eULL, 0x000fe400000000ffULL, 0x00000016170d723eULL, 0x000fe400000000ffULL,
0x0000002e2f09723eULL, 0x000fe400000000ffULL, 0x0000541000067816ULL, 0x008fe40000000002ULL,
0x0000002a2b00723eULL, 0x000fc400000000ffULL, 0x000000262702723eULL, 0x000fe200000000ffULL,
0x000000060c007388ULL, 0x0007e40000000a00ULL, 0x0000541004067816ULL, 0x148fe40000000005ULL,
0x0000763204077816ULL, 0x000fe40000000005ULL, 0x0000541010047816ULL, 0x140fe40000000008ULL,
0x0000763210057816ULL, 0x000fe20000000008ULL, 0x0000000614007388ULL, 0x0007e20000000a00ULL,
0x0000541012087816ULL, 0x000fc40000000009ULL, 0x0000763212097816ULL, 0x000fe20000000009ULL,
0x0000000418007388ULL, 0x0009e20000000a00ULL, 0x0000541000067816ULL, 0x148fe40000000002ULL,
0x0000763200077816ULL, 0x000fe20000000002ULL, 0x000000010a057824ULL, 0x010fc800078e0203ULL,
0x000000061c007388ULL, 0x000fe20000000a00ULL, 0x0000001005057824ULL, 0x000fc600078e020eULL,
0x000400220c007388ULL, 0x0007e40000000a00ULL, 0x000054101a0c7816ULL, 0x148fe4000000000dULL,
0x000076321a0d7816ULL, 0x000fca000000000dULL, 0x0004000c14007388ULL, 0x000fe80000000a00ULL,
0x0004000818007388ULL, 0x000fe20000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000005107984ULL, 0x000ee80000000c00ULL, 0x0004000005207984ULL, 0x000f280000000c00ULL,
0x00080000051c7984ULL, 0x000f680000000c00ULL, 0x000c000005247984ULL, 0x000f620000000c00ULL,
0x200000ff13137230ULL, 0x008fc40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fe40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x200000ff23237230ULL, 0x010fe40000000000ULL, 0x200000ff22227230ULL, 0x000fe40000000000ULL,
0x200000ff21217230ULL, 0x000fc40000000000ULL, 0x200000ff20207230ULL, 0x000fe40000000000ULL,
0x0000001f13137230ULL, 0x024fe40000000000ULL, 0x0000001e12127230ULL, 0x000fe40000000000ULL,
0x0000001d11117230ULL, 0x000fe40000000000ULL, 0x0000001c10107230ULL, 0x000fe40000000000ULL,
0x0000002723237230ULL, 0x002fc40000000000ULL, 0x0000002622227230ULL, 0x000fe20000000000ULL,
0x0000001005007388ULL, 0x0003e20000000c00ULL, 0x0000002521217230ULL, 0x000fe40000000000ULL,
0x0000002420207230ULL, 0x000fca0000000000ULL, 0x0004002005007388ULL, 0x0003e20000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000002003027836ULL, 0x000fe20000000000ULL, 0x00000003ff0c7819ULL, 0x100fe20000011603ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x00000000000579c3ULL, 0x000ee20000002700ULL,
0x0000840000047ab9ULL, 0x000fe20000000800ULL, 0x00000003ff077819ULL, 0x000fe20000011602ULL,
0x000000010c007824ULL, 0x000fe200078e0203ULL, 0x0000000304047899ULL, 0x000fe2000800063fULL,
0x000000080f147824ULL, 0x000fe400078e00ffULL, 0x0000000102047824ULL, 0x000fe200078e0207ULL,
0x0000000700007812ULL, 0x000fc800078ec0ffULL, 0x0000000704097812ULL, 0x000fe400078ec0ffULL,
0x0ffffff800057812ULL, 0x002fe400078ef803ULL, 0x0ffffff809097812ULL, 0x000fe400078ef802ULL,
0xfffffff814037812ULL, 0x000fe200078ee203ULL, 0x0000001005057824ULL, 0x100fe400078e020eULL,
0x00000010090e7824ULL, 0x000fc600078e020eULL, 0x0000000005087984ULL, 0x0003220000000c00ULL,
0x00000005040472a4ULL, 0x008fc6000f8e023fULL, 0x000000000e107984ULL, 0x000ee20000000c00ULL,
0x00000008060d7824ULL, 0x044fe400078e00ffULL, 0x0000000806067824ULL, 0x000fc600078e00ffULL,
0xfffffff80d007812ULL, 0x000fe200078ee20cULL, 0x000000080f0d7824ULL, 0x000fe200078e00ffULL,
0xfffffff806077812ULL, 0x000fe400078ee207ULL, 0x00000004000c7c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000407077c10ULL, 0x000fe2000ff3e0ffULL, 0x0000860000047ab9ULL, 0x000fe20000000a00ULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee202ULL, 0x000000ffff057224ULL, 0x002fe200000e06ffULL,
0x000000040c047c11ULL, 0x000fc4000f8040ffULL, 0x000000ffff007210ULL, 0x000fe40000ffe4ffULL,
0x0000000407067c11ULL, 0x040fe4000f8240ffULL, 0x000000050c057c11ULL, 0x000fe400080f4405ULL,
0x0000000507077c11ULL, 0x000fe200088f4400ULL, 0x0000001003027825ULL, 0x000fc800078e0004ULL,
0x000000100d047825ULL, 0x000fe200078e0006ULL, 0x0000000802007986ULL, 0x010fe8000c101d08ULL,
0x0000001004007986ULL, 0x008fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00009200ff067b82ULL, 0x004e620000000a00ULL, 0x000001ff0000780cULL, 0x000fe20003f04070ULL,
0x000000020f037824ULL, 0x000fe200078e00ffULL, 0x00008e0000047ab9ULL, 0x000fe20000000800ULL,
0x0000000806067981ULL, 0x002322000c1e9900ULL, 0x00000001ff057424ULL, 0x000fe400078e00ffULL,
0x000000403d007824ULL, 0x000fe400078e00ffULL, 0x0000000603037e24ULL, 0x000fe4000f8e0210ULL,
0x017600050e0479a7ULL, 0x0002a4000850003fULL, 0x00000004030a7c24ULL, 0x000fe2000f8e0200ULL,
0x0000000800e80947ULL, 0x000fec0003800000ULL, 0x00008a00ff087b82ULL, 0x000ee20000000a00ULL,
0x00000003ff307819ULL, 0x000fe4000001160dULL, 0x0000007002027812ULL, 0x000fc600078ec0ffULL,
0x0000000430147836ULL, 0x000fe40000000000ULL, 0x0000000830187836ULL, 0x000fe40000000000ULL,
0x0000000114077824ULL, 0x142fe400078e020dULL, 0x00000008140c7824ULL, 0x000fe400078e00ffULL,
0x000000010a117824ULL, 0x000fe400078e0230ULL, 0x00000001180b7824ULL, 0x040fe200078e020dULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL, 0x0000000818247824ULL, 0x000fe200078e00ffULL,
0x0000000037077248ULL, 0x000fe20007fe0000ULL, 0x0000001030167836ULL, 0x000fc40000000000ULL,
0x0000000c301c7836ULL, 0x000fe20000000000ULL, 0xfffffff824247812ULL, 0x000fe200078ee20bULL,
0x0000008011107825ULL, 0x008fc800078e0008ULL, 0x00000001070b7824ULL, 0x000fe200078e0a00ULL,
0x00000002101a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000116127824ULL, 0x040fe400078e020dULL,
0x0000000816137824ULL, 0x000fe200078e00ffULL, 0x0000000b1800720cULL, 0x080fe20003f46070ULL,
0x000000010a077824ULL, 0x000fe200078e0214ULL, 0x0000000b1c00720cULL, 0x080fe20003f66070ULL,
0x000000ffff1b7224ULL, 0x000fe200000e0611ULL, 0xfffffff813287812ULL, 0x000fe200078ee212ULL,
0x0000008007107825ULL, 0x000fe200078e0008ULL, 0x0000000b1400720cULL, 0x000fc40003f86070ULL,
0x000000160a077210ULL, 0x000fe20007ffe0ffULL, 0x000000010a137824ULL, 0x000fe200078e0218ULL,
0x0000000b1600720cULL, 0x000fe20003f06070ULL, 0x000000010a157824ULL, 0x000fe400078e021cULL,
0x000000011c0f7824ULL, 0x040fe400078e020dULL, 0x000000081c267824ULL, 0x000fe200078e00ffULL,
0x00000002101c7210ULL, 0x000fe20007f3e0ffULL, 0x0000001430187836ULL, 0x000fe40000000000ULL,
0x0000008013127825ULL, 0x000fe200078e0008ULL, 0xfffffff826267812ULL, 0x000fc600078ee20fULL,
0x0000008015147825ULL, 0x000fc800078e0008ULL, 0x000000010a177824ULL, 0x000fe200078e0218ULL,
0x0000000214207210ULL, 0x000fe20007fbe0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e0611ULL,
0x00000002121e7210ULL, 0x000fe20007f3e0ffULL, 0x0000008007107825ULL, 0x000fc800078e0008ULL,
0x0000008017167825ULL, 0x000fc800078e0008ULL, 0x000000ffff1f7224ULL, 0x000fe200008e0613ULL,
0x0000000210127210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff217224ULL, 0x000fe200028e0615ULL,
0x0000000216107210ULL, 0x000fe20007fbe0ffULL, 0x00000001300f7824ULL, 0x040fe400078e020dULL,
0x0000001830227836ULL, 0x000fe40000000000ULL, 0x000000ffff137224ULL, 0x000fe200008e0611ULL,
0x000000070f167812ULL, 0x000fe200078ec0ffULL, 0x000000ffff117224ULL, 0x000fe200028e0617ULL,
0x0000000b3000720cULL, 0x080fe20003fa6070ULL, 0x000000010a157824ULL, 0x000fe200078e0222ULL,
0x0ffffff816167812ULL, 0x000fe200078ef80dULL, 0x000040003d077824ULL, 0x000fe200078e020eULL,
0x0000000b1800720cULL, 0x040fe20003f26070ULL, 0x00000001180f7824ULL, 0x000fc400078e020dULL,
0x00000008182a7824ULL, 0x000fe400078e00ffULL, 0x0000001c302c7836ULL, 0x000fe40000000000ULL,
0x0000008015147825ULL, 0x000fe200078e0008ULL, 0xfffffff82a2a7812ULL, 0x000fc600078ee20fULL,
0x0000100007077836ULL, 0x000fe20000000000ULL, 0x0000000214147210ULL, 0x000fe20007fde0ffULL,
0x000000010a177824ULL, 0x000fe400078e022cULL, 0x00000010160f7824ULL, 0x000fe400078e0207ULL,
0x0000008017167825ULL, 0x000fc600078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001a0f7faeULL, 0x0003e2000e901c48ULL, 0x000000100c257824ULL, 0x000fe200078e0207ULL,
0x0000000b2200720cULL, 0x0c0fe20003fa6070ULL, 0x000000ffff157224ULL, 0x000fe400030e0615ULL,
0x00000001220c7824ULL, 0x140fe200078e020dULL, 0x000000001c257faeULL, 0x0007e2000e101c48ULL,
0x0000000822277824ULL, 0x000fe200078e00ffULL, 0x0000000216227210ULL, 0x000fe20007fde0ffULL,
0x000000012c167824ULL, 0x040fe200078e020dULL, 0x0000000b2c00720cULL, 0x040fe20003f86070ULL,
0x00000020302e7836ULL, 0x000fe20000000000ULL, 0x000000032c0f7819ULL, 0x002fe200000006ffULL,
0x00000010261b7824ULL, 0x100fe200078e0207ULL, 0xfffffff8270c7812ULL, 0x000fe200078ee20cULL,
0x000000010a197824ULL, 0x000fe200078e022eULL, 0xfffffff80f1a7812ULL, 0x000fe200078ee216ULL,
0x00000010240f7824ULL, 0x000fc400078e0207ULL, 0x0000002430247836ULL, 0x000fe40000000000ULL,
0x000000ffff237224ULL, 0x000fe200030e0617ULL, 0x000000001e0f7faeULL, 0x0003e2000d101c48ULL,
0x000000010a177824ULL, 0x000fe200078e0224ULL, 0x0000000b2400720cULL, 0x0c0fe20003f46070ULL,
0x00000001241d7824ULL, 0x008fe200078e020dULL, 0x00000000201b7faeULL, 0x0007e2000d901c48ULL,
0x0000008019187825ULL, 0x000fe200078e0008ULL, 0x0000000b2e00720cULL, 0x000fc60003f66070ULL,
0x000000012e1c7824ULL, 0x040fe200078e020dULL, 0x0000000218187210ULL, 0x000fe20007fde0ffULL,
0x000000082e257824ULL, 0x000fe400078e00ffULL, 0x0000000824247824ULL, 0x000fe400078e00ffULL,
0x00000010280f7824ULL, 0x102fe200078e0207ULL, 0xfffffff8251c7812ULL, 0x000fe200078ee21cULL,
0x000000102a1b7824ULL, 0x108fe200078e0207ULL, 0xfffffff8241e7812ULL, 0x000fe200078ee21dULL,
0x000000100c1d7824ULL, 0x000fe200078e0207ULL, 0x00000000120f7faeULL, 0x000fe2000c101c48ULL,
0x00000028300c7836ULL, 0x000fc40000000000ULL, 0x000000101a1f7824ULL, 0x000fe200078e0207ULL,
0x00000000101b7faeULL, 0x0003e2000c901c48ULL, 0x000000ffff197224ULL, 0x000fe400030e0619ULL,
0x0000008017167825ULL, 0x000fe200078e0008ULL, 0x00000000141d7faeULL, 0x000fe6000e901c48ULL,
0x000000101c217824ULL, 0x000fe200078e0207ULL, 0x00000000221f7faeULL, 0x000fe2000e101c48ULL,
0x0000000216167210ULL, 0x000fe20007fde0ffULL, 0x0000002c301a7836ULL, 0x000fc40000000000ULL,
0x000000010c107824ULL, 0x042fe200078e020dULL, 0x000000030c117819ULL, 0x040fe200000006ffULL,
0x0000000018217faeULL, 0x0003e2000d901c48ULL, 0x000000ffff177224ULL, 0x000fe200030e0617ULL,
0x0000000b0c00720cULL, 0x080fe20003fc6070ULL, 0x000000101e0f7824ULL, 0x000fe200078e0207ULL,
0x0000000b1a00720cULL, 0x080fe20003fa6070ULL, 0x00000030301c7836ULL, 0x000fe40000000000ULL,
0x0000003430207836ULL, 0x000fe20000000000ULL, 0x00000000160f7faeULL, 0x0007e2000d101c48ULL,
0x0000003830247836ULL, 0x000fe20000000000ULL, 0x0000000b1c00720cULL, 0x080fe20003f86070ULL,
0x0000003c30267836ULL, 0x000fe20000000000ULL, 0xfffffff811187812ULL, 0x002fe200078ee210ULL,
0x000000010a117824ULL, 0x000fe200078e020cULL, 0x0000000b2000720cULL, 0x080fe20003f66070ULL,
0x000000010a137824ULL, 0x000fe200078e021aULL, 0x0000000b2400720cULL, 0x080fe20003f26070ULL,
0x0000008011107825ULL, 0x000fe200078e0008ULL, 0x0000000b2600720cULL, 0x000fc60003f06070ULL,
0x000000011c0c7824ULL, 0x040fe200078e020dULL, 0x0000000210147210ULL, 0x004fe20007f5e0ffULL,
0x000000081c157824ULL, 0x000fe400078e00ffULL, 0x0000008013127825ULL, 0x000fc800078e0008ULL,
0x000000011a0b7824ULL, 0x040fe400078e020dULL, 0x000000081a1a7824ULL, 0x000fe400078e00ffULL,
0x000000010a197824ULL, 0x000fe200078e021cULL, 0xfffffff8151c7812ULL, 0x000fe200078ee20cULL,
0x000000ffff157224ULL, 0x000fe200010e0611ULL, 0x0000000212167210ULL, 0x008fe20007f5e0ffULL,
0x0000008019107825ULL, 0x000fe200078e0008ULL, 0xfffffff81a1a7812ULL, 0x000fc600078ee20bULL,
0x00000001200c7824ULL, 0x040fe400078e020dULL, 0x00000008200f7824ULL, 0x000fe400078e00ffULL,
0x000000010a0b7824ULL, 0x000fe400078e0220ULL, 0x000000ffff177224ULL, 0x000fe200010e0613ULL,
0x0000000210107210ULL, 0x000fe20007f5e0ffULL, 0x000000800b127825ULL, 0x000fe200078e0008ULL,
0xfffffff80f1e7812ULL, 0x000fc600078ee20cULL, 0x000000010a0f7824ULL, 0x040fe400078e0224ULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x00000002120c7210ULL, 0x000fe20007f5e0ffULL,
0x000000010a1b7824ULL, 0x000fe400078e0226ULL, 0x000000800f0a7825ULL, 0x000fc800078e0008ULL,
0x0000000124197824ULL, 0x100fe400078e020dULL, 0x00000001260f7824ULL, 0x000fe400078e020dULL,
0x000000ffff0d7224ULL, 0x000fe200010e0613ULL, 0x000000020a0a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000824127824ULL, 0x000fe200078e00ffULL, 0x000000071a137211ULL, 0x000fe200078e20ffULL,
0x0000000826207824ULL, 0x000fe400078e00ffULL, 0x000000801b087825ULL, 0x000fe200078e0008ULL,
0xfffffff812127812ULL, 0x000fc400078ee219ULL, 0xfffffff820207812ULL, 0x000fe200078ee20fULL,
0x000000ffff0b7224ULL, 0x000fe200010e060bULL, 0x0000000208087210ULL, 0x000fe20007f5e0ffULL,
0x00000010180f7824ULL, 0x100fe400078e0207ULL, 0x000000101c197824ULL, 0x100fe400078e0207ULL,
0x000000101e1b7824ULL, 0x100fe200078e0207ULL, 0x00000000140f7faeULL, 0x0003e2000f101c48ULL,
0x00000010121d7824ULL, 0x100fe400078e0207ULL, 0x0000001020077824ULL, 0x000fe200078e0207ULL,
0x0000000016137faeULL, 0x0003e2000e901c48ULL, 0x000000ffff097224ULL, 0x000fc600010e0609ULL,
0x0000000010197faeULL, 0x0003e8000e101c48ULL, 0x000000000c1b7faeULL, 0x0003e8000d901c48ULL,
0x000000000a1d7faeULL, 0x0003e8000c901c48ULL, 0x0000000008077faeULL, 0x0003e2000c101c48ULL,
0x0000000800987947ULL, 0x000fea0003800000ULL, 0x000000080d117811ULL, 0x000fe200078fe8ffULL,
0x000040003d2b7824ULL, 0x000fe200078e020eULL, 0x0000000c0d137811ULL, 0x040fe400078fe8ffULL,
0x000000040d0f7811ULL, 0x000fe200078fe8ffULL, 0x0000000111087824ULL, 0x100fe200078e020dULL,
0x000000180d197811ULL, 0x000fe200078fe8ffULL, 0x0000000811177824ULL, 0x000fe200078e00ffULL,
0x0000001c0d1b7811ULL, 0x000fe200078fe8ffULL, 0x0000000113097824ULL, 0x100fe200078e020dULL,
0x000000100d157811ULL, 0x000fe200078fe8ffULL, 0x0000000813147824ULL, 0x000fe200078e00ffULL,
0xfffffff817127812ULL, 0x000fe200078ee208ULL, 0x000000010f077824ULL, 0x102fe200078e020dULL,
0x000000140d177811ULL, 0x000fe200078fe8ffULL, 0x000000080f107824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee209ULL, 0x0000000119087824ULL, 0x100fe200078e020dULL,
0x000000280d217811ULL, 0x000fe200078fe8ffULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0x0000002c0d237811ULL, 0x000fe200078fe8ffULL, 0x000000011b097824ULL, 0x140fe200078e020dULL,
0xfffffff810107812ULL, 0x000fe200078ee207ULL, 0x000000081b1c7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1a7812ULL, 0x000fe200078ee208ULL, 0x0000000117077824ULL, 0x100fe200078e020dULL,
0x000000240d1f7811ULL, 0x000fe200078fe8ffULL, 0x0000000817187824ULL, 0x000fe200078e00ffULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee209ULL, 0x00000001150b7824ULL, 0x140fe200078e020dULL,
0x0000000d21087210ULL, 0x000fe20007ffe0ffULL, 0x0000000815167824ULL, 0x000fe200078e00ffULL,
0x000000200d1d7811ULL, 0x000fe200078fe8ffULL, 0x0000000821277824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee207ULL, 0x0000000123097824ULL, 0x140fe200078e020dULL,
0xfffffff816167812ULL, 0x000fe200078ee20bULL, 0x0000000823247824ULL, 0x000fe200078e00ffULL,
0xfffffff827227812ULL, 0x000fe200078ee208ULL, 0x000000011f077824ULL, 0x100fe200078e020dULL,
0x000000300d257811ULL, 0x000fe200078fe8ffULL, 0x000000081f207824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee209ULL, 0x000000011d0b7824ULL, 0x040fe200078e020dULL,
0x00008a00ff087b82ULL, 0x000e620000000a00ULL, 0x000000081d1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee207ULL, 0x0000000825267824ULL, 0x000fe200078e00ffULL,
0x0000000d0d077211ULL, 0x000fe200078fe8ffULL, 0x000000010a0f7824ULL, 0x040fe200078e020fULL,
0xfffffff81e1e7812ULL, 0x000fe200078ee20bULL, 0x00000001250b7824ULL, 0x000fe200078e020dULL,
0x000000340d277811ULL, 0x040fe200078fe8ffULL, 0x000000010a117824ULL, 0x040fe200078e0211ULL,
0x000000380d287811ULL, 0x040fe200078fe8ffULL, 0x000000010a137824ULL, 0x040fe200078e0213ULL,
0x0000003c0d2a7811ULL, 0x000fe200078fe8ffULL, 0x000000010a297824ULL, 0x000fe200078e0227ULL,
0x00000007070c7812ULL, 0x000fe200078ec0ffULL, 0x0000000127077824ULL, 0x140fe200078e020dULL,
0xfffffff826267812ULL, 0x000fe200078ee20bULL, 0x00000008272c7824ULL, 0x000fe200078e00ffULL,
0x0000000a0d0b7211ULL, 0x000fe200078fe8ffULL, 0x0000000128277824ULL, 0x100fe200078e020dULL,
0x0ffffff80c0c7812ULL, 0x000fe200078ef80dULL, 0x000000010a4b7824ULL, 0x000fe200078e0228ULL,
0x0000000328287819ULL, 0x000fe200000006ffULL, 0x000000010a4f7824ULL, 0x000fe200078e022aULL,
0x0000007002537812ULL, 0x000fe200078ec0ffULL, 0x000000012a0d7824ULL, 0x040fe200078e020dULL,
0xfffffff828277812ULL, 0x000fe200078ee227ULL, 0x000000082a2a7824ULL, 0x000fc400078e00ffULL,
0x000000010a157824ULL, 0x040fe400078e0215ULL, 0x000000010a177824ULL, 0x040fe200078e0217ULL,
0xfffffff82a0d7812ULL, 0x000fe200078ee20dULL, 0x000000010a197824ULL, 0x040fe400078e0219ULL,
0x000000010a1b7824ULL, 0x040fe400078e021bULL, 0x000000010a1d7824ULL, 0x040fe400078e021dULL,
0x000000010a1f7824ULL, 0x000fc400078e021fULL, 0x000000010a217824ULL, 0x040fe400078e0221ULL,
0x000000010a237824ULL, 0x040fe400078e0223ULL, 0x000000010a257824ULL, 0x000fe200078e0225ULL,
0xfffffff82c0a7812ULL, 0x000fe200078ee207ULL, 0x000010002b517836ULL, 0x000fc80000000000ULL,
0x000000100c077824ULL, 0x100fe400078e0251ULL, 0x00000010102b7824ULL, 0x100fe400078e0251ULL,
0x00000010122d7824ULL, 0x100fe400078e0251ULL, 0x00000010142f7824ULL, 0x100fe400078e0251ULL,
0x0000001016317824ULL, 0x100fe400078e0251ULL, 0x0000001018337824ULL, 0x000fc400078e0251ULL,
0x000000101a397824ULL, 0x100fe400078e0251ULL, 0x000000101c3b7824ULL, 0x100fe400078e0251ULL,
0x000000101e3f7824ULL, 0x100fe400078e0251ULL, 0x0000001020417824ULL, 0x100fe400078e0251ULL,
0x0000001022437824ULL, 0x100fe400078e0251ULL, 0x0000001024457824ULL, 0x000fc400078e0251ULL,
0x0000001026477824ULL, 0x100fe400078e0251ULL, 0x000000100a497824ULL, 0x100fe400078e0251ULL,
0x00000010274d7824ULL, 0x100fe400078e0251ULL, 0x000000100d517824ULL, 0x000fe400078e0251ULL,
0x000000800b0a7825ULL, 0x002fc800078e0008ULL, 0x000000800f0c7825ULL, 0x000fe200078e0008ULL,
0x000000530a0a7210ULL, 0x000fc60007f1e0ffULL, 0x0000008011107825ULL, 0x000fe200078e0008ULL,
0x000000530c0c7210ULL, 0x000fc60007f3e0ffULL, 0x0000008013127825ULL, 0x000fe200078e0008ULL,
0x0000005310107210ULL, 0x000fc60007f5e0ffULL, 0x0000008015147825ULL, 0x000fe200078e0008ULL,
0x0000005312127210ULL, 0x000fc60007f7e0ffULL, 0x0000008017167825ULL, 0x000fe200078e0008ULL,
0x00000013ff137210ULL, 0x000fc60001ffe4ffULL, 0x0000008019187825ULL, 0x000fc800078e0008ULL,
0x000000801b1a7825ULL, 0x000fc800078e0008ULL, 0x000000ffff0b7224ULL, 0x000fe200000e060bULL,
0x0000005314147210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff0d7224ULL, 0x000fe200008e060dULL,
0x0000005316167210ULL, 0x000fe20007f3e0ffULL, 0x000000801d1c7825ULL, 0x000fe200078e0008ULL,
0x000000531a1a7210ULL, 0x000fe20007f7e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a077faeULL, 0x0003e4000b901c48ULL, 0x000000ffff117224ULL, 0x000fe200010e0611ULL,
0x0000005318187210ULL, 0x000fe20007f5e0ffULL, 0x000000801f1e7825ULL, 0x100fe200078e0008ULL,
0x000000000c2b7faeULL, 0x0003e6000b901c48ULL, 0x0000008021207825ULL, 0x100fe200078e0008ULL,
0x00000000102d7faeULL, 0x0003e6000b901c48ULL, 0x0000008023227825ULL, 0x000fe200078e0008ULL,
0x00000000122f7faeULL, 0x0003e6000b901c48ULL, 0x000000ffff157224ULL, 0x000fe200000e0615ULL,
0x000000531c1c7210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff177224ULL, 0x000fe200008e0617ULL,
0x000000531e1e7210ULL, 0x000fe20007f3e0ffULL, 0x0000008025247825ULL, 0x000fe200078e0008ULL,
0x0000000014317faeULL, 0x0003e6000b901c48ULL, 0x000000ffff197224ULL, 0x000fe200010e0619ULL,
0x0000005320207210ULL, 0x000fe20007f5e0ffULL, 0x0000008029267825ULL, 0x000fe200078e0008ULL,
0x0000000016337faeULL, 0x0003e6000b901c48ULL, 0x000000ffff1b7224ULL, 0x000fe200018e061bULL,
0x0000005322227210ULL, 0x000fe20007f7e0ffULL, 0x000000804b287825ULL, 0x100fe200078e0008ULL,
0x0000000018397faeULL, 0x0003e6000b901c48ULL, 0x000000804f087825ULL, 0x000fe200078e0008ULL,
0x000000001a3b7faeULL, 0x0003e6000b901c48ULL, 0x000000ffff1d7224ULL, 0x000fe200000e061dULL,
0x0000005324247210ULL, 0x000fe20007f1e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200008e061fULL,
0x0000005326267210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff217224ULL, 0x000fe200010e0621ULL,
0x0000005328287210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff237224ULL, 0x000fe200018e0623ULL,
0x0000005308087210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff257224ULL, 0x000fe200000e0625ULL,
0x000000001c3f7faeULL, 0x0003e2000b901c48ULL, 0x000000ffff277224ULL, 0x000fc400008e0627ULL,
0x000000ffff297224ULL, 0x000fe200010e0629ULL, 0x000000001e417faeULL, 0x0003e2000b901c48ULL,
0x000000ffff097224ULL, 0x000fc600018e0609ULL, 0x0000000020437faeULL, 0x0003e8000b901c48ULL,
0x0000000022457faeULL, 0x0003e8000b901c48ULL, 0x0000000024477faeULL, 0x0003e8000b901c48ULL,
0x0000000026497faeULL, 0x0003e8000b901c48ULL, 0x00000000284d7faeULL, 0x0003e8000b901c48ULL,
0x0000000008517faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fce0000015200ULL, 0x017600050e0075a7ULL, 0x004e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff0c7224ULL, 0x000fce00078e00ffULL,
0x000000100c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fce0000015200ULL, 0x0000000a08077210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0a7824ULL, 0x000fe200000e0e09ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0a00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0a00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc8000001140aULL,
0x0000000702027211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e060aULL,
0x0000000202027819ULL, 0x000fc80000001207ULL, 0x000000020000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000010c0c7836ULL, 0x000fce0000000000ULL,
0x017600050e0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000000000027919ULL, 0x000e640000000000ULL, 0x000000203d027824ULL, 0x002fca00078e0202ULL,
0x00000003ff047819ULL, 0x000fc80000011602ULL, 0x1ffffffe04057812ULL, 0x000fe400078ec0ffULL,
0x0000000f02047812ULL, 0x000fc600078ec0ffULL, 0x0000000102057824ULL, 0x000fe400078e0205ULL,
0x0000001004087824ULL, 0x040fe400078e00ffULL, 0x0000000105027836ULL, 0x000fe20000000000ULL,
0x0000000f05057812ULL, 0x000fe200078ec0ffULL, 0x0000001004077824ULL, 0x000fc600078e00ffULL,
0x0000000f02027812ULL, 0x000fe400078ec0ffULL, 0x000000f008057812ULL, 0x000fe400078ee205ULL,
0x000000f007077812ULL, 0x000fc600078ee202ULL, 0x0000001005057824ULL, 0x100fe400078e020eULL,
0x0000001007077824ULL, 0x000fc600078e020eULL, 0x0000000005107984ULL, 0x000e680000000c00ULL,
0x0000000007087984ULL, 0x000ea20000000c00ULL, 0x0000001000147202ULL, 0x002fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fe400078e0011ULL, 0x000000ffff117224ULL, 0x000fe400078e0013ULL,
0x000000ffff157224ULL, 0x000fc400078e0012ULL, 0x000000ffff167224ULL, 0x004fe400078e0008ULL,
0x000000ffff177224ULL, 0x000fe400078e000aULL, 0x000000ffff137224ULL, 0x000fe400078e000bULL,
0x000000ffff127224ULL, 0x000fe200078e0009ULL, 0x0000001405007388ULL, 0x0003e20000000c00ULL,
0x00000001ff0b7424ULL, 0x000fc600078e00ffULL, 0x0000001007007388ULL, 0x0003e60000000c00ULL,
0x0176000b0e0a79a7ULL, 0x0002a4000850003fULL, 0x0000000000047805ULL, 0x002fce0000015200ULL,
0x0176000b0e0075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff0c7224ULL, 0x000fce00078e00ffULL, 0x000000100c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fce0000015200ULL,
0x0000000804077210ULL, 0x000fca0007f1e1ffULL, 0x0000000109087824ULL, 0x000fe200000e0e05ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0800720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0800720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011408ULL, 0x0000000702027211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0608ULL, 0x0000000202027819ULL, 0x000fc80000001207ULL,
0x000000020000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000010c0c7836ULL, 0x000fce0000000000ULL, 0x0176000b0e0075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff3500720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000027919ULL, 0x000e620000000000ULL,
0x3db504f306047820ULL, 0x010fe20000410000ULL, 0x000000083d057824ULL, 0x140fe400078e020eULL,
0xffffffff35067836ULL, 0x000fe40000000000ULL, 0x000000203d077824ULL, 0x000fe400078e020eULL,
0x000000ffff097224ULL, 0x000fe400078e00ffULL, 0x000000ffff0b7224ULL, 0x000fce00078e00ffULL,
0x0000010009087824ULL, 0x004fca00078e0200ULL, 0x000000083700720cULL, 0x000fda0003f04070ULL,
0x000000000000894dULL, 0x002fea0003800000ULL, 0x00000002090a7836ULL, 0x000fe20000000000ULL,
0x00008e0000047ab9ULL, 0x000fe20000000800ULL, 0x00000100080c7836ULL, 0x000fc60000000000ULL,
0x000000350a00720cULL, 0x000fe20003f06070ULL, 0x00000004030f7c24ULL, 0x000fe2000f8e020cULL,
0x000000010b0a7812ULL, 0x000fd600078e0cffULL, 0x0000000800f08947ULL, 0x000fea0003800000ULL,
0x00008a00ff107b82ULL, 0x000ea20000000a00ULL, 0x00000003ff207819ULL, 0x102fe40000011602ULL,
0x0000000c371f7248ULL, 0x000fe40007fe0000ULL, 0x00000004020d7819ULL, 0x000fe200000006ffULL,
0x0000000c20187836ULL, 0x000fe40000000000ULL, 0x0000000420147836ULL, 0x000fe40000000000ULL,
0x0000000118157824ULL, 0x000fc400078e0202ULL, 0x00000008181e7824ULL, 0x000fe400078e00ffULL,
0x00000010201a7836ULL, 0x000fe40000000000ULL, 0x0000000114127824ULL, 0x040fe200078e0202ULL,
0xfffffff81e2d7812ULL, 0x000fe200078ee215ULL, 0x0000000814297824ULL, 0x000fe400078e00ffULL,
0x000000011f1f7824ULL, 0x000fe200078e0a0cULL, 0x000000700d0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000120137824ULL, 0x100fe200078e020fULL, 0xfffffff829297812ULL, 0x000fe200078ee212ULL,
0x0000000114157824ULL, 0x040fe200078e020fULL, 0x0000001f1400720cULL, 0x080fe20003f86070ULL,
0x000000011a177824ULL, 0x000fe200078e0202ULL, 0x0000001f1800720cULL, 0x000fe20003f66070ULL,
0x000000081a227824ULL, 0x000fc400078e00ffULL, 0x0000000820167836ULL, 0x000fe40000000000ULL,
0x0000008013127825ULL, 0x104fe200078e0010ULL, 0xfffffff8222f7812ULL, 0x000fe400078ee217ULL,
0x0000001f1600720cULL, 0x000fe20003f46070ULL, 0x0000008015147825ULL, 0x000fe200078e0010ULL,
0x0000000c12127210ULL, 0x000fc60007f1e0ffULL, 0x00000001160d7824ULL, 0x040fe200078e0202ULL,
0x0000000c14267210ULL, 0x000fe20007f3e0ffULL, 0x00000008161c7824ULL, 0x000fe400078e00ffULL,
0x0000000118197824ULL, 0x100fe400078e020fULL, 0x0000000116177824ULL, 0x000fe200078e020fULL,
0xfffffff81c2b7812ULL, 0x000fe200078ee20dULL, 0x0000001420227836ULL, 0x000fe40000000000ULL,
0x0000008019187825ULL, 0x000fc800078e0010ULL, 0x0000008017167825ULL, 0x000fc800078e0010ULL,
0x000000011a0d7824ULL, 0x100fe400078e020fULL, 0x00000001221d7824ULL, 0x000fe400078e020fULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x0000001f1a00720cULL, 0x000fe20003f06070ULL,
0x000000ffff277224ULL, 0x000fe200008e0615ULL, 0x0000000c18187210ULL, 0x000fe20007f3e0ffULL,
0x000000800d147825ULL, 0x000fe200078e0010ULL, 0x0000000c161a7210ULL, 0x000fc60007fbe0ffULL,
0x000000801d1c7825ULL, 0x000fc800078e0010ULL, 0x000000ffff197224ULL, 0x000fe200008e0619ULL,
0x0000000c14167210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200028e0617ULL,
0x0000000c1c147210ULL, 0x000fe20007fbe0ffULL, 0x0000001820287836ULL, 0x000fe20000000000ULL,
0x00000002201c7210ULL, 0x000fe20007ffe0ffULL, 0x000040003d0d7824ULL, 0x000fe400078e020eULL,
0x0000000128217824ULL, 0x000fe200078e020fULL, 0x000000071c237812ULL, 0x000fe200078ec0ffULL,
0x000000ffff177224ULL, 0x000fe200008e0615ULL, 0x0000001f2200720cULL, 0x080fe20003f26070ULL,
0x000000ffff157224ULL, 0x000fe200028e061dULL, 0x0000001f2000720cULL, 0x000fe20003fa6070ULL,
0x000020000a1e7824ULL, 0x000fc400078e020dULL, 0x00000080211c7825ULL, 0x000fe200078e0010ULL,
0x0ffffff823217812ULL, 0x000fc600078ef802ULL, 0x000010001e1e7836ULL, 0x000fe20000000000ULL,
0x0000000c1c1c7210ULL, 0x000fe20007fde0ffULL, 0x0000001c202c7836ULL, 0x000fe40000000000ULL,
0x0000001021217824ULL, 0x100fe400078e021eULL, 0x0000001029297824ULL, 0x000fe400078e021eULL,
0x000000012c237824ULL, 0x000fe200078e020fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012217faeULL, 0x000fe2000e901c48ULL, 0x00000020202e7836ULL, 0x000fe20000000000ULL,
0x0000001f2800720cULL, 0x080fe20003fa6070ULL, 0x0000000122247824ULL, 0x040fe200078e0202ULL,
0x0000000026297faeULL, 0x0003e2000e101c48ULL, 0x0000000822317824ULL, 0x000fe200078e00ffULL,
0x0000001f2c00720cULL, 0x000fe20003f86070ULL, 0x0000008023227825ULL, 0x000fc600078e0010ULL,
0xfffffff831317812ULL, 0x000fe200078ee224ULL, 0x000000012e257824ULL, 0x000fe400078e020fULL,
0x000000ffff1d7224ULL, 0x000fe200030e061dULL, 0x0000000c22227210ULL, 0x000fe20007fde0ffULL,
0x0000008025247825ULL, 0x000fc800078e0010ULL, 0x0000002420267836ULL, 0x002fe40000000000ULL,
0x000000102b217824ULL, 0x000fe400078e021eULL, 0x00000001282a7824ULL, 0x040fe200078e0202ULL,
0x0000000f26137210ULL, 0x000fe20007ffe0ffULL, 0x0000000828337824ULL, 0x000fe200078e00ffULL,
0x000000001a217faeULL, 0x0003e2000d101c48ULL, 0x000000102d297824ULL, 0x000fe200078e021eULL,
0x0000001f2600720cULL, 0x000fe20003f46070ULL, 0x000000012c287824ULL, 0x040fe200078e0202ULL,
0xfffffff833337812ULL, 0x000fe200078ee22aULL, 0x000000082c397824ULL, 0x000fe200078e00ffULL,
0x0000000018297faeULL, 0x0005e2000d901c48ULL, 0x000000ffff237224ULL, 0x000fe200030e0623ULL,
0x0000000c24247210ULL, 0x000fe20007fde0ffULL, 0x0000008013127825ULL, 0x000fe200078e0010ULL,
0xfffffff839397812ULL, 0x000fc400078ee228ULL, 0x0000001f2e00720cULL, 0x040fe20003f66070ULL,
0x000000012e277824ULL, 0x140fe400078e0202ULL, 0x000000ffff257224ULL, 0x000fe400030e0625ULL,
0x000000082e2e7824ULL, 0x000fe400078e00ffULL, 0x0000000126287824ULL, 0x040fe400078e0202ULL,
0x00000008262d7824ULL, 0x000fe200078e00ffULL, 0x0000000c12267210ULL, 0x000fe20007fde0ffULL,
0x000000102f1b7824ULL, 0x102fe200078e021eULL, 0xfffffff82e2b7812ULL, 0x000fe200078ee227ULL,
0x0000001033197824ULL, 0x104fe200078e021eULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee228ULL,
0x000000ffff277224ULL, 0x000fe200030e0613ULL, 0x00000000161b7faeULL, 0x000fe2000c101c48ULL,
0x0000001031137824ULL, 0x000fc400078e021eULL, 0x0000002820127836ULL, 0x000fe40000000000ULL,
0x0000001039217824ULL, 0x100fe200078e021eULL, 0x0000000014137faeULL, 0x0003e2000c901c48ULL,
0x000000102b297824ULL, 0x000fe200078e021eULL, 0x0000001f1200720cULL, 0x080fe20003fc6070ULL,
0x0000002c20187836ULL, 0x000fe20000000000ULL, 0x000000001c197faeULL, 0x0005e2000e901c48ULL,
0x00000030201a7836ULL, 0x000fe40000000000ULL, 0x0000003420287836ULL, 0x000fe20000000000ULL,
0x0000000022217faeULL, 0x0007e2000e101c48ULL, 0x00000038202a7836ULL, 0x000fe20000000000ULL,
0x0000001f1800720cULL, 0x080fe20003fa6070ULL, 0x0000003c20207836ULL, 0x000fe20000000000ULL,
0x0000000024297faeULL, 0x0009e2000d901c48ULL, 0x0000000112137824ULL, 0x002fe200078e0202ULL,
0x0000001f1a00720cULL, 0x080fe20003f86070ULL, 0x0000000812147824ULL, 0x000fe200078e00ffULL,
0x0000001f2800720cULL, 0x080fe20003f66070ULL, 0x000000102d197824ULL, 0x004fe200078e021eULL,
0x0000001f2a00720cULL, 0x080fe20003f26070ULL, 0x0000000118157824ULL, 0x100fe200078e020fULL,
0x0000001f2000720cULL, 0x000fe20003f06070ULL, 0x0000000118177824ULL, 0x000fe200078e0202ULL,
0xfffffff8141f7812ULL, 0x000fe200078ee213ULL, 0x0000000112137824ULL, 0x000fe200078e020fULL,
0x0000000026197faeULL, 0x0003e2000d101c48ULL, 0x00000008181c7824ULL, 0x000fe200078e00ffULL,
0x0000000f1a1b7210ULL, 0x000fe20007ffe0ffULL, 0x0000008013127825ULL, 0x000fc600078e0010ULL,
0xfffffff81c217812ULL, 0x008fe200078ee217ULL, 0x000000011a187824ULL, 0x040fe200078e0202ULL,
0x0000000c12167210ULL, 0x000fe20007f5e0ffULL, 0x000000081a237824ULL, 0x000fe400078e00ffULL,
0x0000008015147825ULL, 0x000fc600078e0010ULL, 0xfffffff823237812ULL, 0x000fe200078ee218ULL,
0x000000ffff177224ULL, 0x000fe200010e0613ULL, 0x0000000c14187210ULL, 0x000fe20007f5e0ffULL,
0x000000801b127825ULL, 0x000fc800078e0010ULL, 0x0000000128147824ULL, 0x040fe400078e0202ULL,
0x0000000828257824ULL, 0x050fe400078e00ffULL, 0x00000001281b7824ULL, 0x000fe400078e020fULL,
0x000000ffff197224ULL, 0x002fe200010e0615ULL, 0x0000000c121a7210ULL, 0x000fe20007f5e0ffULL,
0x000000012a1d7824ULL, 0x000fe200078e020fULL, 0xfffffff825257812ULL, 0x000fe200078ee214ULL,
0x000000801b147825ULL, 0x000fc800078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe200010e0613ULL,
0x0000000c14147210ULL, 0x000fe20007f5e0ffULL, 0x000000801d127825ULL, 0x000fc800078e0010ULL,
0x00000001200f7824ULL, 0x000fe400078e020fULL, 0x000000ffff157224ULL, 0x000fe200010e0615ULL,
0x0000000c12127210ULL, 0x000fe20007f5e0ffULL, 0x000000012a1c7824ULL, 0x140fe400078e0202ULL,
0x000000082a277824ULL, 0x000fe400078e00ffULL, 0x00000001201d7824ULL, 0x040fe400078e0202ULL,
0x0000000820207824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee21cULL,
0x000000800f107825ULL, 0x000fc600078e0010ULL, 0xfffffff820297812ULL, 0x000fe200078ee21dULL,
0x000000ffff137224ULL, 0x000fe200010e0613ULL, 0x0000000c10107210ULL, 0x000fe20007f5e0ffULL,
0x000000101f0f7824ULL, 0x100fe400078e021eULL, 0x00000010211d7824ULL, 0x100fe400078e021eULL,
0x00000010231f7824ULL, 0x100fe200078e021eULL, 0x00000000160f7faeULL, 0x0003e2000f101c48ULL,
0x0000001025217824ULL, 0x100fe400078e021eULL, 0x0000001027237824ULL, 0x100fe200078e021eULL,
0x00000000181d7faeULL, 0x0003e2000e901c48ULL, 0x0000001029257824ULL, 0x000fc400078e021eULL,
0x000000ffff117224ULL, 0x000fe200010e0611ULL, 0x000000001a1f7faeULL, 0x0003e8000e101c48ULL,
0x0000000014217faeULL, 0x0003e8000d901c48ULL, 0x0000000012237faeULL, 0x0003e8000c901c48ULL,
0x0000000010257faeULL, 0x0003e2000c101c48ULL, 0x0000000800a07947ULL, 0x000fea0003800000ULL,
0x0000000402157811ULL, 0x042fe400078fe8ffULL, 0x0000000c02197811ULL, 0x040fe400078fe8ffULL,
0x00000002150c7210ULL, 0x000fe20007ffe0ffULL, 0x0000000815117824ULL, 0x000fe200078e00ffULL,
0x00000010021b7811ULL, 0x040fe200078fe8ffULL, 0x0000000119107824ULL, 0x140fe200078e0202ULL,
0x00000018021f7811ULL, 0x040fe200078fe8ffULL, 0x0000000819137824ULL, 0x000fe200078e00ffULL,
0x0000000802177811ULL, 0x040fe200078fe8ffULL, 0x0000000115157824ULL, 0x100fe200078e020fULL,
0xfffffff811147812ULL, 0x000fe200078ee20cULL, 0x000000011b0c7824ULL, 0x140fe200078e0202ULL,
0xfffffff813307812ULL, 0x000fe200078ee210ULL, 0x000000081b117824ULL, 0x000fe200078e00ffULL,
0x0000001c02217811ULL, 0x040fe200078fe8ffULL, 0x000000011f107824ULL, 0x140fe200078e0202ULL,
0x0000002402257811ULL, 0x040fe200078fe8ffULL, 0x000000081f137824ULL, 0x000fe200078e00ffULL,
0x00000014021d7811ULL, 0x040fe200078fe8ffULL, 0x00000001170d7824ULL, 0x140fe200078e0202ULL,
0xfffffff811327812ULL, 0x000fe200078ee20cULL, 0x0000000817167824ULL, 0x000fe200078e00ffULL,
0xfffffff813347812ULL, 0x000fe200078ee210ULL, 0x00000001210c7824ULL, 0x140fe200078e0202ULL,
0x0000002802277811ULL, 0x040fe200078fe8ffULL, 0x0000000821117824ULL, 0x000fe200078e00ffULL,
0x00000030022b7811ULL, 0x040fe200078fe8ffULL, 0x0000000125107824ULL, 0x140fe200078e0202ULL,
0xfffffff816167812ULL, 0x000fe200078ee20dULL, 0x0000000825137824ULL, 0x000fe200078e00ffULL,
0x0000002002237811ULL, 0x040fe200078fe8ffULL, 0x000000011d0d7824ULL, 0x140fe200078e0202ULL,
0xfffffff8111a7812ULL, 0x000fe200078ee20cULL, 0x000000081d187824ULL, 0x000fe200078e00ffULL,
0xfffffff8131e7812ULL, 0x000fe200078ee210ULL, 0x00000001270c7824ULL, 0x140fe200078e0202ULL,
0x00000034022d7811ULL, 0x040fe200078fe8ffULL, 0x0000000827117824ULL, 0x000fe200078e00ffULL,
0x0000003c024b7811ULL, 0x040fe200078fe8ffULL, 0x000000012b107824ULL, 0x140fe200078e0202ULL,
0xfffffff818187812ULL, 0x000fe200078ee20dULL, 0x000000082b137824ULL, 0x000fe200078e00ffULL,
0x0000002c02297811ULL, 0x040fe200078fe8ffULL, 0x00000001230d7824ULL, 0x140fe200078e0202ULL,
0xfffffff811207812ULL, 0x000fe200078ee20cULL, 0x00000008231c7824ULL, 0x000fe200078e00ffULL,
0xfffffff813247812ULL, 0x000fe200078ee210ULL, 0x000000082d117824ULL, 0x000fe200078e00ffULL,
0x000000022d0c7210ULL, 0x000fe20007ffe0ffULL, 0x000000014b107824ULL, 0x140fe200078e0202ULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20dULL, 0x000000084b137824ULL, 0x000fe200078e00ffULL,
0x00000038022f7811ULL, 0x040fe200078fe8ffULL, 0x00000001290d7824ULL, 0x140fe200078e0202ULL,
0xfffffff811267812ULL, 0x000fe200078ee20cULL, 0x0000000829227824ULL, 0x000fe200078e00ffULL,
0xfffffff8132a7812ULL, 0x000fe200078ee210ULL, 0x000000082f287824ULL, 0x000fe200078e00ffULL,
0x00008a00ff107b82ULL, 0x000e620000000a00ULL, 0x00000002020c7211ULL, 0x000fe200078fe8ffULL,
0x0000000117177824ULL, 0x100fe200078e020fULL, 0xfffffff822227812ULL, 0x000fe200078ee20dULL,
0x000000012f0d7824ULL, 0x000fe200078e0202ULL, 0x000000070c137812ULL, 0x000fe200078ec0ffULL,
0x0000000119197824ULL, 0x000fc400078e020fULL, 0x000000011b1b7824ULL, 0x100fe200078e020fULL,
0xfffffff828287812ULL, 0x000fe200078ee20dULL, 0x000040003d0d7824ULL, 0x000fe200078e020eULL,
0x0ffffff8130c7812ULL, 0x000fe200078ef802ULL, 0x000000011d1d7824ULL, 0x000fe200078e020fULL,
0x0000000f02137211ULL, 0x000fe200078fe8ffULL, 0x000020000a127824ULL, 0x000fe400078e020dULL,
0x000000011f1f7824ULL, 0x100fe400078e020fULL, 0x00001000124d7836ULL, 0x000fe20000000000ULL,
0x0000000402127819ULL, 0x000fe200000006ffULL, 0x0000000121217824ULL, 0x000fc400078e020fULL,
0x0000000123237824ULL, 0x100fe200078e020fULL, 0x00000070124f7812ULL, 0x000fe200078ec0ffULL,
0x0000000125257824ULL, 0x100fe400078e020fULL, 0x0000000127277824ULL, 0x100fe400078e020fULL,
0x0000000129297824ULL, 0x100fe400078e020fULL, 0x000000012b2b7824ULL, 0x100fe400078e020fULL,
0x000000012d2d7824ULL, 0x000fc400078e020fULL, 0x000000012f2f7824ULL, 0x100fe400078e020fULL,
0x000000014b4b7824ULL, 0x000fe400078e020fULL, 0x000000100c0f7824ULL, 0x100fe400078e024dULL,
0x0000001014317824ULL, 0x000fe400078e024dULL, 0x0000008013127825ULL, 0x002fc800078e0010ULL,
0x00000010160c7824ULL, 0x000fe200078e024dULL, 0x0000004f12127210ULL, 0x000fe20007f1e0ffULL,
0x0000008015147825ULL, 0x000fc800078e0010ULL, 0x0000008017167825ULL, 0x000fe200078e0010ULL,
0x0000004f14147210ULL, 0x000fc60007f3e0ffULL, 0x0000001018337824ULL, 0x000fe200078e024dULL,
0x0000004f16167210ULL, 0x000fe20007f5e0ffULL, 0x0000008019187825ULL, 0x000fc800078e0010ULL,
0x000000101a397824ULL, 0x100fe200078e024dULL, 0x0000004f18187210ULL, 0x000fe20007f7e0ffULL,
0x000000101c3b7824ULL, 0x000fe400078e024dULL, 0x000000801b1a7825ULL, 0x000fc800078e0010ULL,
0x000000101e3f7824ULL, 0x000fe400078e024dULL, 0x000000801d1c7825ULL, 0x000fc800078e0010ULL,
0x000000801f1e7825ULL, 0x000fc800078e0010ULL, 0x0000001020417824ULL, 0x000fe400078e024dULL,
0x0000008021207825ULL, 0x000fc800078e0010ULL, 0x000000ffff137224ULL, 0x000fe200000e0613ULL,
0x0000004f1a1a7210ULL, 0x000fe20007f1e0ffULL, 0x0000001022437824ULL, 0x000fe400078e024dULL,
0x000000ffff157224ULL, 0x000fe200008e0615ULL, 0x0000004f1c1c7210ULL, 0x000fe20007f3e0ffULL,
0x0000001024457824ULL, 0x000fe200078e024dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120f7faeULL, 0x0003e2000b901c48ULL, 0x0000008023227825ULL, 0x000fc600078e0010ULL,
0x0000000014317faeULL, 0x0003e2000b901c48ULL, 0x000000ffff177224ULL, 0x000fe200010e0617ULL,
0x0000004f1e1e7210ULL, 0x000fe20007f5e0ffULL, 0x0000001026477824ULL, 0x000fe400078e024dULL,
0x0000008025247825ULL, 0x000fe200078e0010ULL, 0x00000000160c7faeULL, 0x0003e6000b901c48ULL,
0x0000001028497824ULL, 0x000fe400078e024dULL, 0x0000008027267825ULL, 0x000fc800078e0010ULL,
0x000000ffff197224ULL, 0x000fe200018e0619ULL, 0x0000004f20207210ULL, 0x000fe20007f7e0ffULL,
0x0000008029287825ULL, 0x000fc600078e0010ULL, 0x00000021ff217210ULL, 0x000fe20001ffe4ffULL,
0x0000001030307824ULL, 0x100fe200078e024dULL, 0x0000004f28287210ULL, 0x000fe20007f7e0ffULL,
0x0000001032327824ULL, 0x100fe400078e024dULL, 0x0000001034347824ULL, 0x000fe200078e024dULL,
0x0000000018307faeULL, 0x0003e2000b901c48ULL, 0x000000ffff1b7224ULL, 0x000fe200000e061bULL,
0x0000004f22227210ULL, 0x000fe20007f1e0ffULL, 0x000000102a4d7824ULL, 0x000fe400078e024dULL,
0x000000ffff1d7224ULL, 0x000fe200008e061dULL, 0x0000004f24247210ULL, 0x000fe20007f3e0ffULL,
0x000000802b2a7825ULL, 0x000fe200078e0010ULL, 0x000000001a327faeULL, 0x0003e6000b901c48ULL,
0x000000ffff1f7224ULL, 0x000fe200010e061fULL, 0x0000004f26267210ULL, 0x000fe20007f5e0ffULL,
0x000000802d2c7825ULL, 0x100fe200078e0010ULL, 0x000000001c337faeULL, 0x0003e6000b901c48ULL,
0x000000802f2e7825ULL, 0x100fe200078e0010ULL, 0x000000001e347faeULL, 0x0003e6000b901c48ULL,
0x000000804b107825ULL, 0x000fe200078e0010ULL, 0x0000000020397faeULL, 0x0003e6000b901c48ULL,
0x000000ffff237224ULL, 0x000fe200000e0623ULL, 0x0000004f2a2a7210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff257224ULL, 0x000fe200008e0625ULL, 0x0000004f2c2c7210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff277224ULL, 0x000fe200010e0627ULL, 0x0000004f2e2e7210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff297224ULL, 0x000fe200018e0629ULL, 0x0000004f10107210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff2b7224ULL, 0x000fe200000e062bULL, 0x00000000223b7faeULL, 0x0003e2000b901c48ULL,
0x000000ffff2d7224ULL, 0x000fc400008e062dULL, 0x000000ffff2f7224ULL, 0x000fe200010e062fULL,
0x00000000243f7faeULL, 0x0003e2000b901c48ULL, 0x000000ffff117224ULL, 0x000fc600018e0611ULL,
0x0000000026417faeULL, 0x0003e8000b901c48ULL, 0x0000000028437faeULL, 0x0003e8000b901c48ULL,
0x000000002a457faeULL, 0x0003e8000b901c48ULL, 0x000000002c477faeULL, 0x0003e8000b901c48ULL,
0x000000002e497faeULL, 0x0003e8000b901c48ULL, 0x00000000104d7faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002002117836ULL, 0x002fe20000000000ULL,
0x00000004ff0c7819ULL, 0x000fe20000011602ULL, 0x000020000b0f7824ULL, 0x000fe200078e020dULL,
0xfffffff8020b7812ULL, 0x040fe200078ec0ffULL, 0x000000ffff3f7224ULL, 0x000fe200078e00ffULL,
0x00000007020d7812ULL, 0x000fe400078ec0ffULL, 0x00000000001a7805ULL, 0x000fe4000001ff00ULL,
0xfffffff811117812ULL, 0x000fc400078ec0ffULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x000000070b347812ULL, 0x000fe400078ef802ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x0000000000267805ULL, 0x000fe4000001ff00ULL,
0x0000000000247805ULL, 0x000fc4000001ff00ULL, 0x00000000002a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000287805ULL, 0x000fe4000001ff00ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fc4000001ff00ULL, 0x00000000003a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x000010000f0f7836ULL, 0x000fe20000000000ULL,
0x000000080d367812ULL, 0x000fe200078ef802ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000007110b7812ULL, 0x000fce00078ef802ULL, 0x0000000134107824ULL, 0x140fe400078e023fULL,
0x0000000834117824ULL, 0x000fe400078e00ffULL, 0x000000010b147824ULL, 0x040fe400078e023fULL,
0x000000080b157824ULL, 0x000fe200078e00ffULL, 0xfffffff811107812ULL, 0x000fe200078ee210ULL,
0x000000023f777824ULL, 0x000fc600078e020cULL, 0xfffffff815147812ULL, 0x000fe200078ee214ULL,
0x0000001010107824ULL, 0x000fc800078e020fULL, 0x0000001014147824ULL, 0x000fe400078e020fULL,
0x000000001010783bULL, 0x000e680000000200ULL, 0x000000001414783bULL, 0x000ea20000000200ULL,
0x00000018ff5f7819ULL, 0x002fe20000011410ULL, 0x00010000101c7824ULL, 0x040fe200078e00ffULL,
0x0000888010587816ULL, 0x040fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe20000011411ULL, 0x00010000111d7824ULL, 0x040fe200078e00ffULL,
0x0000888011727816ULL, 0x040fe200000000ffULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x00000018ff557819ULL, 0x000fc40000011412ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000888012547816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000001000747306ULL, 0x0003e20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff647819ULL, 0x004fe40000011414ULL, 0x00008880146a7816ULL, 0x000fc400000000ffULL,
0x00000018ff6c7819ULL, 0x000fe20000011413ULL, 0x0000001100737306ULL, 0x0005e20000200c00ULL,
0x0001000012107824ULL, 0x042fe200078e00ffULL, 0x0000000812127819ULL, 0x000fe400000006ffULL,
0x00008880136e7816ULL, 0x040fe400000000ffULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x0000001c00597306ULL, 0x0002e20000200c00ULL, 0x0001000013117824ULL, 0x044fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fc40000011415ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000001200707306ULL, 0x0005e20000200c00ULL, 0x00000008341c7824ULL, 0x002fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000888015677816ULL, 0x000fe400000000ffULL,
0x00000018ff3c7819ULL, 0x000fe40000011417ULL, 0x00000011006f7306ULL, 0x0003e20000200c00ULL,
0x000000013f127836ULL, 0x004fe20000000000ULL, 0x00008880175d7816ULL, 0x000fe200000000ffULL,
0x000000023f3f7836ULL, 0x000fe20000000000ULL, 0x00000018ff4c7819ULL, 0x000fc40000011416ULL,
0x0000888016627816ULL, 0x000fe400000000ffULL, 0x0000001d00757306ULL, 0x0005e20000200c00ULL,
0x0000000134117824ULL, 0x102fe200078e0212ULL, 0x000000083f00780cULL, 0x000fe20003f05270ULL,
0x000000010b127824ULL, 0x000fc600078e0212ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee211ULL,
0x0001000015117824ULL, 0x040fe200078e00ffULL, 0x0000001000717306ULL, 0x0003e20000200c00ULL,
0x0000010015157824ULL, 0x000fe400078e00ffULL, 0x000000101c1c7824ULL, 0x000fe200078e020fULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x00000013006d7306ULL, 0x0009e20000200c00ULL, 0x000000001c1c783bULL, 0x004ea20000000200ULL,
0x0001000014107824ULL, 0x002fc400078e00ffULL, 0x0000010014147824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000001500667306ULL, 0x000fe20000200c00ULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x000000080b137824ULL, 0x010fca00078e00ffULL,
0xfffffff813127812ULL, 0x000fe200078ee212ULL, 0x0000001400697306ULL, 0x0003e80000200c00ULL,
0x0000001012127824ULL, 0x000fc800078e020fULL, 0x00000010006b7306ULL, 0x0009e20000200c00ULL,
0x0001000017147824ULL, 0x042fe400078e00ffULL, 0x0000010017177824ULL, 0x000fc600078e00ffULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff177819ULL, 0x000fe20000011417ULL,
0x0001000016107824ULL, 0x050fe200078e00ffULL, 0x00000014005e7306ULL, 0x0003e20000200c00ULL,
0x0000010016167824ULL, 0x000fc600078e00ffULL, 0x00000018ff657819ULL, 0x000fe40000011410ULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x000100001d157824ULL, 0x004fe200078e00ffULL,
0x00000017005b7306ULL, 0x0005e20000200c00ULL, 0x000100001c147824ULL, 0x002fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x000fe4000001141cULL, 0x00000018ff157819ULL, 0x000fe40000011415ULL,
0x00000018ff147819ULL, 0x000fc40000011414ULL, 0x0000001100687306ULL, 0x0003e20000200c00ULL,
0x0000001036177824ULL, 0x004fe200078e00ffULL, 0x000088801c457816ULL, 0x040fe200000000ffULL,
0x000001001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4b7819ULL, 0x000fe4000001141dULL,
0x000088801d4d7816ULL, 0x040fe200000000ffULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000014004e7306ULL, 0x0005e20000200c00ULL, 0x000000001210783bULL, 0x002e620000000200ULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff4a7819ULL, 0x000fe4000001141eULL, 0x0000001500507306ULL, 0x0009e20000200c00ULL,
0x0000000136147824ULL, 0x004fe200078e0277ULL, 0x000088801e517816ULL, 0x000fe400000000ffULL,
0x00000018ff497819ULL, 0x000fe4000001141fULL, 0x000088801f537816ULL, 0x000fc400000000ffULL,
0x0000001600637306ULL, 0x0005e20000200c00ULL, 0xfffffff017157812ULL, 0x010fe400078ee214ULL,
0x0000000236777810ULL, 0x000fc60007ffe077ULL, 0x0000001015157824ULL, 0x000fe400078e020eULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x000000101e167819ULL, 0x044fe200000006ffULL,
0x000001001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff567819ULL, 0x000fe40000011416ULL,
0x000000001514783bULL, 0x000ea20000000200ULL, 0x0000001c004f7306ULL, 0x0009e20000200c00ULL,
0x00000018ff1e7819ULL, 0x000fce000001141eULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x000100001f1c7824ULL, 0x050fe200078e00ffULL, 0x00000018ff487819ULL, 0x002fe20000011410ULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011411ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x00000018ff467819ULL, 0x000fc40000011412ULL,
0x00000018ff447819ULL, 0x000fc60000011413ULL, 0x0000001d00527306ULL, 0x0003f00000200c00ULL,
0x0000001c005c7306ULL, 0x0007e20000200c00ULL, 0x00008880101d7816ULL, 0x002fce00000000ffULL,
0x0000005500557306ULL, 0x000e620000200c00ULL, 0x00005410581c7816ULL, 0x008fce0000000059ULL,
0x0000001d00587306ULL, 0x0007e20000200c00ULL, 0x0000541070557816ULL, 0x002fce0000000055ULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x00005410741d7816ULL, 0x008fe2000000005fULL,
0x0000001036747824ULL, 0x000fca00078e00ffULL, 0xfffffff074777812ULL, 0x000fe200078ee277ULL,
0x0000001c1440723cULL, 0x004fe20000001840ULL, 0x0000001e00577306ULL, 0x0005ec0000200c00ULL,
0x00005410721c7816ULL, 0x000fe40000000075ULL, 0x00005410731d7816ULL, 0x000fe20000000060ULL,
0x00010000101e7824ULL, 0x044fe200078e00ffULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x0000541054547816ULL, 0x002fc40000000071ULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0000001c1438723cULL, 0x000fe20000001838ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000006e006e7306ULL, 0x000e660000200c00ULL,
0x000000541430723cULL, 0x000fe20000001830ULL, 0x00010000111d7824ULL, 0x000fe400078e00ffULL,
0x00000010771c7824ULL, 0x000fc400078e020eULL, 0x00000010005f7306ULL, 0x0007e40000200c00ULL,
0x0000010011547824ULL, 0x000fca00078e00ffULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000006a006a7306ULL, 0x000f220000200c00ULL, 0x00000018ff107819ULL, 0x008fce000001141dULL,
0x0000001f005a7306ULL, 0x0007f00000200c00ULL, 0x0000006400647306ULL, 0x000f620000200c00ULL,
0x00008880111f7816ULL, 0x008fe400000000ffULL, 0x000054106d117816ULL, 0x004fc6000000006cULL,
0x000000ffff607224ULL, 0x000fe400078e001fULL, 0x0000001000557306ULL, 0x0003f00000200c00ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x000054106e107816ULL, 0x002fce000000006fULL,
0x0000006700677306ULL, 0x000e620000200c00ULL, 0x00000010142c723cULL, 0x000fee000000182cULL,
0x0000888012117816ULL, 0x000fe200000000ffULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x000054106a107816ULL, 0x010fc6000000006bULL, 0x000000ffff6a7224ULL, 0x000fe200078e0011ULL,
0x0000541069117816ULL, 0x020fe20000000064ULL, 0x0001000012697824ULL, 0x040fe400078e00ffULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x0000010012127824ULL, 0x000fc600078e00ffULL,
0x000000101428723cULL, 0x000fe80000001828ULL, 0x0000006500657306ULL, 0x000ea60000200c00ULL,
0x0000541067107816ULL, 0x002fe40000000068ULL, 0x0000541066117816ULL, 0x000fe40000000061ULL,
0x00000018ff617819ULL, 0x000fe20000011469ULL, 0x0000003c003c7306ULL, 0x000fe80000200c00ULL,
0x000000101424723cULL, 0x000fe80000001824ULL, 0x0000005d005d7306ULL, 0x000e660000200c00ULL,
0x0000541062107816ULL, 0x004fc40000000065ULL, 0x0000541063117816ULL, 0x000fe4000000004cULL,
0x00000018ff627819ULL, 0x000fe20000011412ULL, 0x0000001e00597306ULL, 0x0004e20000200c00ULL,
0x0000888013127816ULL, 0x000fc600000000ffULL, 0x000000101420723cULL, 0x000fe80000001820ULL,
0x0000004b004b7306ULL, 0x000f220000200c00ULL, 0x000000001c1c783bULL, 0x004ea40000000200ULL,
0x000054105d107816ULL, 0x002fe4000000005eULL, 0x000054105b117816ULL, 0x000fe4000000003cULL,
0x0000541058587816ULL, 0x008fe20000000059ULL, 0x0000004d004d7306ULL, 0x000fe80000200c00ULL,
0x000000101418723cULL, 0x000fe80000001818ULL, 0x0000001200127306ULL, 0x000fe60000200c00ULL,
0x0001000013107824ULL, 0x040fe200078e00ffULL, 0x0000541052117816ULL, 0x010fe2000000004bULL,
0x0000010013147824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000003e003e7306ULL, 0x000e620000200c00ULL, 0x00000018ff147819ULL, 0x000fce0000011414ULL,
0x0000001000137306ULL, 0x0007220000200c00ULL, 0x000054104f4f7816ULL, 0x002fce000000003eULL,
0x0000004a004a7306ULL, 0x000e620000200c00ULL, 0x000054104d107816ULL, 0x008fe40000000050ULL,
0x0000541012127816ULL, 0x010fca0000000013ULL, 0x0000004900497306ULL, 0x000ee20000200c00ULL,
0x000000101c38723cULL, 0x004fe20000001838ULL, 0x0000541057577816ULL, 0x002fcc000000004aULL,
0x0000004800487306ULL, 0x000e620000200c00ULL, 0x000054105a5d7816ULL, 0x008fce0000000049ULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x000054105f597816ULL, 0x002fce0000000048ULL,
0x0000004600467306ULL, 0x000fe20000200c00ULL, 0x000000581c28723cULL, 0x000fee0000001828ULL,
0x0000004400447306ULL, 0x000ff00000200c00ULL, 0x0000004500457306ULL, 0x000e700000200c00ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x00005410454e7816ULL, 0x002fce000000004eULL,
0x0000005600567306ULL, 0x000e620000200c00ULL, 0x0000004e1c40723cULL, 0x000fee0000001840ULL,
0x0000005300537306ULL, 0x000ea20000200c00ULL, 0x0000541051567816ULL, 0x002fce0000000056ULL,
0x0000006000607306ULL, 0x000e620000200c00ULL, 0x000000561c30723cULL, 0x000fe20000001830ULL,
0x00005410535c7816ULL, 0x004fcc000000005cULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x0000005c1c2c723cULL, 0x000fe2000000182cULL, 0x0000541060107816ULL, 0x002fcc0000000055ULL,
0x0000006a00647306ULL, 0x000fe20000200c00ULL, 0x0000541054117816ULL, 0x004fce0000000047ULL,
0x0000006100617306ULL, 0x000e620000200c00ULL, 0x000000101c24723cULL, 0x000fee0000001824ULL,
0x0000006200637306ULL, 0x0002b00000200c00ULL, 0x0000001400157306ULL, 0x000ee20000200c00ULL,
0x0000541064627816ULL, 0x002fc40000000061ULL, 0x0000541063637816ULL, 0x004fce0000000046ULL,
0x000000621c20723cULL, 0x000fe20000001820ULL, 0x0000541015137816ULL, 0x008fce0000000044ULL,
0x000000121c18723cULL, 0x000fe20000001818ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xfffffff000280947ULL, 0x000fde000383ffffULL, 0x00000001ff107424ULL, 0x000fe400078e00ffULL,
0x00000004400b7220ULL, 0x080fe20000410000ULL, 0x0000000441417220ULL, 0x080fe20000410000ULL,
0x0000000442427220ULL, 0x080fe20000410000ULL, 0x0000000443437220ULL, 0x080fe20000410000ULL,
0x0000000438387220ULL, 0x080fe20000410000ULL, 0x01768810051079a7ULL, 0x000e62000850003fULL,
0x0000000439397220ULL, 0x080fe20000410000ULL, 0x000000043a3a7220ULL, 0x080fe20000410000ULL,
0x000000043b3b7220ULL, 0x080fe20000410000ULL, 0x0000000430307220ULL, 0x080fe20000410000ULL,
0x0000000431317220ULL, 0x080fe20000410000ULL, 0x0000000432327220ULL, 0x080fe20000410000ULL,
0x0000000433337220ULL, 0x080fe20000410000ULL, 0x000000042c2c7220ULL, 0x080fe20000410000ULL,
0x000000042d2d7220ULL, 0x080fe20000410000ULL, 0x000000042e2e7220ULL, 0x080fe20000410000ULL,
0x000000042f2f7220ULL, 0x080fe20000410000ULL, 0x0000000428287220ULL, 0x080fe20000410000ULL,
0x0000000429297220ULL, 0x080fe20000410000ULL, 0x000000042a2a7220ULL, 0x080fe20000410000ULL,
0x000000042b2b7220ULL, 0x080fe20000410000ULL, 0x0000000424247220ULL, 0x080fe20000410000ULL,
0x0000000425257220ULL, 0x080fe20000410000ULL, 0x0000000426267220ULL, 0x080fe20000410000ULL,
0x0000000427277220ULL, 0x080fe20000410000ULL, 0x0000000420207220ULL, 0x080fe20000410000ULL,
0x0000000421217220ULL, 0x080fe20000410000ULL, 0x0000000422227220ULL, 0x080fe20000410000ULL,
0x0000000423237220ULL, 0x080fe20000410000ULL, 0x0000000418187220ULL, 0x080fe20000410000ULL,
0x0000000419197220ULL, 0x080fe20000410000ULL, 0x000000041a0f7220ULL, 0x080fe20000410000ULL,
0x000000041b1c7220ULL, 0x000fe20000410000ULL, 0x0000000000127805ULL, 0x000fe20000015200ULL,
0x01768811050075a7ULL, 0x002e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff167224ULL, 0x000fce00078e00ffULL, 0x000000101600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001412177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e13ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc80000011415ULL, 0x000000170c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x000000020c0c7819ULL, 0x000fc80000001215ULL,
0x0000000c0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000116167836ULL, 0x000fce0000000000ULL, 0x01768811050075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000002020c7819ULL, 0x000fe200000006ffULL,
0x000000803d117824ULL, 0x000fe200078e020eULL, 0x000000060900720cULL, 0x000fe40003f05270ULL,
0xfffffff00c0c7812ULL, 0x000fca00078ec0ffULL, 0x00000001110c7824ULL, 0x000fca00078e020cULL,
0x017400000c107984ULL, 0x0002a20000000c00ULL, 0x0000000400080947ULL, 0x000fea0003800000ULL,
0x0000000202147824ULL, 0x000fe400078e00ffULL, 0x0000000137087824ULL, 0x000fc600078e0a08ULL,
0x0000000614157812ULL, 0x000fc800078ec0ffULL, 0x0000000115177812ULL, 0x040fe400078efcffULL,
0x00000008151b7812ULL, 0x000fe400078efcffULL, 0x000000081700720cULL, 0x080fe40003f26070ULL,
0x0000001015177812ULL, 0x000fe400078efcffULL, 0x000000081b00720cULL, 0x080fe40003f06070ULL,
0x000000081700720cULL, 0x000fc40003fc6070ULL, 0x00000011151b7812ULL, 0x040fe400078efcffULL,
0x0000001815177812ULL, 0x040fe400078efcffULL, 0x000000081500720cULL, 0x080fe40003f46070ULL,
0x000000081b00720cULL, 0x080fe40003fa6070ULL, 0x000000081700720cULL, 0x000fe40003f66070ULL,
0x00000009151d7812ULL, 0x000fc400078efcffULL, 0x00000019151b7812ULL, 0x040fe400078efcffULL,
0x0000002015177812ULL, 0x000fe400078efcffULL, 0xff80000042427808ULL, 0x000fe40005000000ULL,
0xff8000000b0b7808ULL, 0x000fe40005000000ULL, 0xff80000043437808ULL, 0x000fe40004800000ULL,
0xff80000041417808ULL, 0x000fc40004800000ULL, 0x000000081d00720cULL, 0x080fe40003f86070ULL,
0x000000081b00720cULL, 0x080fe40003f46070ULL, 0x000000081700720cULL, 0x000fe40003f26070ULL,
0x00000021151b7812ULL, 0x040fe400078efcffULL, 0x0000002815177812ULL, 0x000fe400078efcffULL,
0xff8000003a3a7808ULL, 0x000fc40004000000ULL, 0xff80000038387808ULL, 0x000fe40004000000ULL,
0xff8000003b3b7808ULL, 0x000fe40006000000ULL, 0xff80000039397808ULL, 0x000fe40006000000ULL,
0x000000081b00720cULL, 0x080fe40003f06070ULL, 0x000000081700720cULL, 0x000fe40003f86070ULL,
0x00000029151b7812ULL, 0x000fc400078efcffULL, 0x0000003015177812ULL, 0x000fe400078efcffULL,
0xff80000032327808ULL, 0x000fe40007000000ULL, 0xff80000030307808ULL, 0x000fe40007000000ULL,
0xff80000033337808ULL, 0x000fe40006800000ULL, 0xff80000031317808ULL, 0x000fe40006800000ULL,
0x000000081b00720cULL, 0x000fc40003fc6070ULL, 0x000000081700720cULL, 0x000fe40003fa6070ULL,
0x00000031151b7812ULL, 0x040fe400078efcffULL, 0x0000003815177812ULL, 0x040fe400078efcffULL,
0x0000003915157812ULL, 0x000fe400078efcffULL, 0xff8000002e2e7808ULL, 0x000fe40005800000ULL,
0xff8000002c2c7808ULL, 0x000fc40005800000ULL, 0xff8000002f2f7808ULL, 0x000fe40005000000ULL,
0xff8000002d2d7808ULL, 0x000fe40005000000ULL, 0xff8000002a2a7808ULL, 0x000fe40004800000ULL,
0xff80000028287808ULL, 0x000fe40004800000ULL, 0x000000081b00720cULL, 0x080fe40003f66070ULL,
0x000000081700720cULL, 0x000fc40003f46070ULL, 0x000000081500720cULL, 0x000fe40003f26070ULL,
0xff8000002b2b7808ULL, 0x000fe40004000000ULL, 0xff80000029297808ULL, 0x000fe40004000000ULL,
0xff80000026267808ULL, 0x000fe40006000000ULL, 0xff80000024247808ULL, 0x000fe40006000000ULL,
0xff80000027277808ULL, 0x000fc40007000000ULL, 0xff80000025257808ULL, 0x000fe40007000000ULL,
0xff80000022227808ULL, 0x000fe40006800000ULL, 0xff80000020207808ULL, 0x000fe40006800000ULL,
0xff80000023237808ULL, 0x000fe40005800000ULL, 0xff80000021217808ULL, 0x000fe40005800000ULL,
0xff8000000f0f7808ULL, 0x000fc40005000000ULL, 0xff80000018187808ULL, 0x000fe40005000000ULL,
0xff8000001c1c7808ULL, 0x000fe40004800000ULL, 0xff80000019197808ULL, 0x000fce0004800000ULL,
0x0000000b1000720bULL, 0x004fe20003f1e000ULL, 0x0000000109097836ULL, 0x000fe20000000000ULL,
0xfffffff8ff0d7812ULL, 0x000fe400078ee20dULL, 0x000000100b107208ULL, 0x000fc80004000000ULL,
0x000000411000720bULL, 0x000fc80003f1e000ULL, 0x0000001041157208ULL, 0x000fc80004000000ULL,
0x000000381500720bULL, 0x000fc80003f1e000ULL, 0x0000001538087208ULL, 0x000fc80004000000ULL,
0x000000390800720bULL, 0x000fc80003f1e000ULL, 0x0000000839157208ULL, 0x000fc80004000000ULL,
0x000000301500720bULL, 0x000fc80003f1e000ULL, 0x0000001530087208ULL, 0x000fc80004000000ULL,
0x000000310800720bULL, 0x000fc80003f1e000ULL, 0x0000000831157208ULL, 0x000fc80004000000ULL,
0x0000002c1500720bULL, 0x000fc80003f1e000ULL, 0x000000152c087208ULL, 0x000fc80004000000ULL,
0x0000002d0800720bULL, 0x000fc80003f1e000ULL, 0x000000082d157208ULL, 0x000fc80004000000ULL,
0x000000281500720bULL, 0x000fc80003f1e000ULL, 0x0000001528087208ULL, 0x000fc80004000000ULL,
0x000000290800720bULL, 0x000fc80003f1e000ULL, 0x0000000829157208ULL, 0x000fc80004000000ULL,
0x000000241500720bULL, 0x000fc80003f1e000ULL, 0x0000001524087208ULL, 0x000fe40004000000ULL,
0x000000421100720bULL, 0x000fe40003f1e000ULL, 0x000000250800720bULL, 0x000fc80003f3e000ULL,
0x0000000825157208ULL, 0x000fe40004800000ULL, 0x0000001142087208ULL, 0x000fe40004000000ULL,
0x000000201500720bULL, 0x000fe40003f3e000ULL, 0x000000430800720bULL, 0x000fe40003f1e000ULL,
0x0000001520107208ULL, 0x000fe40004800000ULL, 0x0000000843117208ULL, 0x000fc40004000000ULL,
0x000000211000720bULL, 0x000fe40003f3e000ULL, 0x0000003a1100720bULL, 0x000fe40003f1e000ULL,
0x0000001021157208ULL, 0x000fe40004800000ULL, 0x000000113a087208ULL, 0x000fe40004000000ULL,
0x000000181500720bULL, 0x000fe40003f3e000ULL, 0x0000003b0800720bULL, 0x000fc40003f1e000ULL,
0x0000001518107208ULL, 0x000fe40004800000ULL, 0x000000083b117208ULL, 0x000fe40004000000ULL,
0x000000191000720bULL, 0x000fe40003f3e000ULL, 0x000000321100720bULL, 0x000fe40003f1e000ULL,
0x0000001019107208ULL, 0x000fe40004800000ULL, 0x0000001132087208ULL, 0x000fc60004000000ULL,
0x0c401f0010157f89ULL, 0x000ea200000e0000ULL, 0x000000330800720bULL, 0x000fc80003f1e000ULL,
0x0000000833117208ULL, 0x000fc80004000000ULL, 0x0000002e1100720bULL, 0x000fc80003f1e000ULL,
0x000000112e087208ULL, 0x000fc80004000000ULL, 0x0000002f0800720bULL, 0x000fc80003f1e000ULL,
0x000000082f117208ULL, 0x000fe40004000000ULL, 0x000000151000720bULL, 0x004fe40003f3e000ULL,
0x0000002a1100720bULL, 0x000fe40003f1e000ULL, 0x0000001015157208ULL, 0x000fe40004800000ULL,
0x000000112a087208ULL, 0x000fc60004000000ULL, 0x0c201f0015107f89ULL, 0x000ea200000e0000ULL,
0x0000002b0800720bULL, 0x000fc80003f1e000ULL, 0x000000082b117208ULL, 0x000fc80004000000ULL,
0x000000261100720bULL, 0x000fc80003f1e000ULL, 0x0000001126087208ULL, 0x000fc80004000000ULL,
0x000000270800720bULL, 0x000fc80003f1e000ULL, 0x0000000827117208ULL, 0x000fe40004000000ULL,
0x000000101500720bULL, 0x004fe40003f3e000ULL, 0x000000221100720bULL, 0x000fe40003f1e000ULL,
0x0000001510107208ULL, 0x000fe40004800000ULL, 0x0000001122087208ULL, 0x000fc60004000000ULL,
0x3fb8aa3b10147820ULL, 0x000fe20000410000ULL, 0x000000230800720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b0b117823ULL, 0x100fe20000010814ULL, 0x0000000823087208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b38387823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b39397823ULL, 0x100fe20000010814ULL,
0x0000001100157308ULL, 0x000fe20000000800ULL, 0x0000000f0800720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b41417823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010814ULL, 0x000000080f0b7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010814ULL,
0x0000004100167308ULL, 0x000ea20000000800ULL, 0x0000001c0b00720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b28287823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010814ULL, 0x0000000b1c0b7208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010814ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010814ULL,
0x0000003800387308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010814ULL,
0x0c401f000b087f89ULL, 0x000ee200000e0000ULL, 0x3fb8aa3b18187823ULL, 0x100fe20000010814ULL,
0x3fb8aa3b19147823ULL, 0x000fc80000010814ULL, 0x0000003900397308ULL, 0x000f300000000800ULL,
0x0000002c001a7308ULL, 0x000ff00000000800ULL, 0x00000014003f7308ULL, 0x0005e20000000800ULL,
0x000000080b00720bULL, 0x008fc80003f1e000ULL, 0x0000000b08087208ULL, 0x000fc60004000000ULL,
0x00000024001f7308ULL, 0x0007e20000000800ULL, 0x000000151614723eULL, 0x004fe200000000ffULL,
0x0c401f00120b7f89ULL, 0x000fe200000e0000ULL, 0x000000383916723eULL, 0x010fc600000000ffULL,
0x0c201f0008117f89ULL, 0x000ea400000e0000ULL, 0x00000025002c7308ULL, 0x0009e20000000800ULL,
0x3c003c00ff247424ULL, 0x008fce00078e00ffULL, 0x00000028001d7308ULL, 0x000fe20000000800ULL,
0x3c003c00ff257424ULL, 0x010fce00078e00ffULL, 0x00000029001e7308ULL, 0x000fe20000000800ULL,
0x000000110800720bULL, 0x004fce0003f1e000ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x0000000811117208ULL, 0x000fe40004000000ULL, 0x0000000b1200720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b11367820ULL, 0x000fe40000410000ULL, 0x0000003100317308ULL, 0x000fe20000000800ULL,
0x000000120b127208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b42427823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b43437823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010836ULL, 0x0000004200427308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b33337823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b26267823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b22227823ULL, 0x100fe20000010836ULL, 0x3fb8aa3b23237823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b0f0f7823ULL, 0x000fe20000010836ULL, 0x0000004300437308ULL, 0x000ea20000000800ULL,
0x0c201f00120b7f89ULL, 0x000eee00000e0000ULL, 0x0000003a00177308ULL, 0x000fe20000000800ULL,
0x000000424315723eULL, 0x004fce00000000ffULL, 0x0000003b00087308ULL, 0x000eb00000000800ULL,
0x0000002e001b7308ULL, 0x0009e20000000800ULL, 0x0000000b1200720bULL, 0x008fc80003f1e000ULL,
0x000000120b127208ULL, 0x000fe20004000000ULL, 0x000000ffff0b7224ULL, 0x000fe200078e000aULL,
0x000000170817723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b2a087823ULL, 0x100fe20000010836ULL,
0x3fb8aa3b2b2e7823ULL, 0x110fe20000010836ULL, 0x0000002d002d7308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b1c367823ULL, 0x000fe20000010836ULL, 0x0000001d1e1c723eULL, 0x000fe400000000ffULL,
0x000000241428723cULL, 0x000fe200000018ffULL, 0x0000001f2c1e723eULL, 0x000fc400000000ffULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x0000003200197308ULL, 0x000fe20000000800ULL,
0x0000001a2d1a723eULL, 0x004fce00000000ffULL, 0x00000033003c7308ULL, 0x000eb00000000800ULL,
0x0000002f00387308ULL, 0x000ee20000000800ULL, 0x000000193c19723eULL, 0x004fce00000000ffULL,
0x0000001800347308ULL, 0x0005e20000000800ULL, 0x0000001b381b723eULL, 0x008fce00000000ffULL,
0x0000000800327308ULL, 0x0007e20000000800ULL, 0x000000303118723eULL, 0x004fce00000000ffULL,
0x000000241828723cULL, 0x000fe20000001828ULL, 0x0000002e00337308ULL, 0x000ea20000000800ULL,
0x0c401f0013087f89ULL, 0x008eee00000e0000ULL, 0x0000002600267308ULL, 0x000fe20000000800ULL,
0x00000032331d723eULL, 0x004fce00000000ffULL, 0x0000002700277308ULL, 0x000ea20000000800ULL,
0x000000080d327824ULL, 0x000fce00078e00ffULL, 0x0000002000207308ULL, 0x000fe20000000800ULL,
0x000000081300720bULL, 0x008fc80003f3e000ULL, 0x0000001308137208ULL, 0x000fe40004800000ULL,
0x00000026271f723eULL, 0x004fe200000000ffULL, 0x0000002100217308ULL, 0x000ea20000000800ULL,
0x00000003ff087819ULL, 0x000fe20000011602ULL, 0x000008003d267824ULL, 0x000fc600078e020eULL,
0x0000000308087812ULL, 0x000fe200078ec0ffULL, 0x000000241c28723cULL, 0x000fe20000001828ULL,
0x0001100026307836ULL, 0x000fe20000000000ULL, 0x0000000f000f7308ULL, 0x000fe20000000800ULL,
0x000000ffff267224ULL, 0x000fc600078e0018ULL, 0x000000ffff187224ULL, 0x000fe200078e001dULL,
0x000000202120723eULL, 0x004fc600000000ffULL, 0x0000003600367308ULL, 0x000eb00000000800ULL,
0x00000022002d7308ULL, 0x0007f00000000800ULL, 0x00000023002e7308ULL, 0x0005220000000800ULL,
0x000000343f22723eULL, 0x008fc400000000ffULL, 0x0000000f3623723eULL, 0x004fe200000000ffULL,
0x000000080d0f7836ULL, 0x000fc80000000000ULL, 0x00000001082c7824ULL, 0x000fe200078e020fULL,
0x0000002d2e21723eULL, 0x010fe200000000ffULL, 0x000000080d2e7824ULL, 0x000fe400078e00ffULL,
0x00000001080d7824ULL, 0x000fe400078e020dULL, 0x0c201f0013087f89ULL, 0x000ea200000e0000ULL,
0x000000080f2f7824ULL, 0x040fe200078e00ffULL, 0x000000242028723cULL, 0x000fe20000001828ULL,
0x000000040d277836ULL, 0x000fe40000000000ULL, 0x000000080f347824ULL, 0x000fe200078e00ffULL,
0xfffffff82e0f7812ULL, 0x000fe200078ee20dULL, 0x0000000c0d2d7836ULL, 0x000fe20000000000ULL,
0xfffffff82f0d7812ULL, 0x000fe200078ee22cULL, 0x000000ffff247224ULL, 0x000fe200078e0014ULL,
0xfffffff832277812ULL, 0x000fe200078ee227ULL, 0x000000100f0f7824ULL, 0x000fe200078e0230ULL,
0xfffffff834317812ULL, 0x000fe200078ee22dULL, 0x000000ffff257224ULL, 0x000fc400078e0016ULL,
0x000000ffff147224ULL, 0x000fe400078e0015ULL, 0x000000ffff2c7224ULL, 0x000fe400078e001cULL,
0x000000ffff2d7224ULL, 0x000fe400078e001eULL, 0x000000ffff2e7224ULL, 0x000fe400078e0020ULL,
0x000000100d297824ULL, 0x100fe200078e0230ULL, 0x000000081300720bULL, 0x004fe20003f3e000ULL,
0x00000010270d7824ULL, 0x000fe200078e0230ULL, 0x0000001a00277202ULL, 0x000fe20000000f00ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0022ULL, 0x0000001308137208ULL, 0x000fe20004800000ULL,
0x000000ffff157224ULL, 0x000fc400078e0017ULL, 0x000000ffff167224ULL, 0x000fe200078e0019ULL,
0x000000240f007844ULL, 0x0005e20000000200ULL, 0x000000ffff177224ULL, 0x000fe400078e001bULL,
0x0000001031317824ULL, 0x000fe200078e0230ULL, 0x0000002c0d007844ULL, 0x0005e20000000200ULL,
0x000000ffff197224ULL, 0x000fe400078e001fULL, 0x000000ffff1a7224ULL, 0x000fe200078e0021ULL,
0x0000001429007844ULL, 0x0005e20000000200ULL, 0x000000ffff1b7224ULL, 0x000fc400078e0023ULL,
0x000000ffff1c7224ULL, 0x000fe400078e0028ULL, 0x000000ffff1d7224ULL, 0x000fe200078e002aULL,
0x0000001831007844ULL, 0x0005e20000000200ULL, 0x00000001ff087424ULL, 0x000fc600078e00ffULL,
0x017000100c008388ULL, 0x0005e80000000c00ULL, 0x0172001c0c008388ULL, 0x0005e20000000a00ULL,
0x000000350900720cULL, 0x000fe20003f06070ULL, 0x0176080807ff79a7ULL, 0x0005e2000850003fULL,
0x0176100807ff79a7ULL, 0x0005e2000850003fULL, 0x0176180807ff79a7ULL, 0x0005e2000850003fULL,
0x0176200807ff79a7ULL, 0x0005f2000850003fULL, 0xffffffc000488947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000007007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000700008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000007027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000000700007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffef8028c7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000000000000017bULL, 0x0000000000000561ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000006e0ULL, 0x0000000000000240ULL, 0x0000001600000002ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000920ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL, 0x0000000000000001ULL,
0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a00ULL, 0x0000000000000054ULL, 0x0000000000000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000a54ULL, 0x0000000000000624ULL, 0x0000000a00000003ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001078ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000001078ULL, 0x0000000000000048ULL, 0x0000000400000003ULL, 0x0000000000000008ULL,
0x0000000000000018ULL, 0x000000010000007bULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x00000000000010c0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL,
0x0000000000001100ULL, 0x0000000000010680ULL, 0x0000001600000003ULL, 0x0000000000000080ULL,
0x0000000000000000ULL, 0x000000010000008dULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x0000000000011780ULL, 0x0000000000000044ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL,
0x00000000000117d0ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL, 0x0000000000000010ULL,
0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL, 0x0000000000000000ULL,
0x00000000000117d0ULL, 0x0000000000000258ULL, 0x0000000a00000000ULL, 0x0000000000000004ULL,
0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000011da8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000011da8ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL, 0x0000000400000001ULL,
0x00000000000010c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001100ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000010680ULL, 0x0000000000010680ULL,
0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000011780ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000050ULL, 0x0000000000000450ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x00000000000117d0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000258ULL, 0x0000000000000258ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_nqpkv_8_m_8_sm_90_cubin_len = 73464;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
