/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000016750ULL, 0x00000000000163d0ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL,
0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL,
0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL,
0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL,
0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000030ULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000001baULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000034ULL,
0x0000000000000004ULL, 0x000c00010000028dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000002dbULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000329ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c0001000003c5ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c00010000040bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000459ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000049fULL, 0x0000000000014850ULL,
0x0000000000000180ULL, 0x000b0022000004d2ULL, 0x00000000000149d0ULL, 0x0000000000000040ULL,
0x000b0022000004fdULL, 0x0000000000014a10ULL, 0x0000000000000050ULL, 0x000b002200000527ULL,
0x0000000000014a60ULL, 0x0000000000000120ULL, 0x000a000300000595ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005b5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005e5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000014b80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001485000000000ULL,
0x0000040400000000ULL, 0x810c000001640400ULL, 0x0050a00400288080ULL, 0x0000000000000000ULL,
0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0xa608288080820828ULL, 0x288080af08288080ULL,
0x80b508288080b408ULL, 0x08288080c1082880ULL, 0x8082801628808084ULL, 0x0000000000031028ULL,
0x2880808492000000ULL, 0x0000000000002200ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x0001485000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808084ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x288080a608288080ULL, 0x80b408288080af08ULL, 0x08288080b5082880ULL,
0x80808608288080c1ULL, 0x0310288082801628ULL, 0x0000000000000000ULL, 0x0022002880808692ULL,
0x0000001cffffffffULL, 0x0000012000000000ULL, 0x000149d000000000ULL, 0x0000004000000000ULL,
0x0000000000000000ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL,
0x288080a608288080ULL, 0x80b408288080af08ULL, 0x08288080b5082880ULL, 0x80828016288080c1ULL,
0x0000000000031028ULL, 0x288080c192000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL,
0x000001b800000000ULL, 0x00014a1000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x80b4288080c10900ULL, 0x0000000000002880ULL, 0x00000064ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x288080a608288080ULL, 0x80b408288080af08ULL, 0x08288080c1082880ULL,
0x80828016288080b5ULL, 0x0000000000031028ULL, 0x288080b592000000ULL, 0x0000000000002200ULL,
0x0000002cffffffffULL, 0x0000026000000000ULL, 0x00014a6000000000ULL, 0x0000012000000000ULL,
0x0000080400000000ULL, 0x80b4288080b50900ULL, 0x0000000000002880ULL, 0x0000001b00082f04ULL,
0x000823040000007fULL, 0x0000000000000017ULL, 0x0000001700081204ULL, 0x0008110400000000ULL,
0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL, 0x0000000000000016ULL,
0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL, 0x0000001500081204ULL,
0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL, 0x000000000000001bULL,
0x0000001b00081204ULL, 0x0008110400000000ULL, 0x000000000000001bULL, 0x0000007b00043704ULL,
0x00080a0400003501ULL, 0x0060016000000018ULL, 0x000c170400601903ULL, 0x0058000900000000ULL,
0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL,
0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL,
0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL,
0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL,
0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL, 0x0000090000043104ULL,
0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000002b001342804ULL,
0x0000058000000470ULL, 0x00002650000025c0ULL, 0x000028e000002780ULL, 0x00002d9000002d60ULL,
0x00002e7000002e00ULL, 0x00004e5000004dc0ULL, 0x000050e000004f80ULL, 0x000055a000005570ULL,
0x0000568000005610ULL, 0x00007470000073d0ULL, 0x00007700000075a0ULL, 0x00007bc000007b90ULL,
0x00007ca000007c30ULL, 0x00009b1000009a70ULL, 0x00009da000009c40ULL, 0x0000a2a00000a270ULL,
0x0000a3800000a310ULL, 0x0000b6500000b640ULL, 0x00012df000012db0ULL, 0x00012e1000012e00ULL,
0x00012e8000012e20ULL, 0x00012ec000012ea0ULL, 0x00013b6000013b10ULL, 0x00013c3000013bd0ULL,
0x00013d1000013ca0ULL, 0x00013dc000013d70ULL, 0x00013e9000013e30ULL, 0x00013f7000013f00ULL,
0x0001402000013fd0ULL, 0x000140f000014090ULL, 0x000141d000014160ULL, 0x0001428000014230ULL,
0x00014350000142f0ULL, 0x00014430000143c0ULL, 0x00014520000144a0ULL, 0x00014620000145a0ULL,
0x00014720000146a0ULL, 0x00014820000147a0ULL, 0x0000038004403904ULL, 0x00017600000000ffULL,
0x00000400003f0100ULL, 0x000176080000000dULL, 0x000004e0003f0120ULL, 0x000176880000000dULL,
0x00000500003f0120ULL, 0x000176a80000000dULL, 0x00000530003f0120ULL, 0x000176c80000000dULL,
0x00000920003f0120ULL, 0x00017600000000ffULL, 0x00000b10003f0107ULL, 0x0000000400000006ULL,
0x00000bc0003f0102ULL, 0x0000000000000006ULL, 0x00001430003f0101ULL, 0x00000000000000ffULL,
0x000014b000040107ULL, 0x00000000000000ffULL, 0x0000151000040101ULL, 0x0000002000000006ULL,
0x00001680003f0101ULL, 0x000176cc0000000fULL, 0x00001870003f0105ULL, 0x000176cc0000000fULL,
0x000021f0003f0105ULL, 0x000176b0000000ffULL, 0x0000227000050107ULL, 0x000176b0000000ffULL,
0x000022d000050101ULL, 0x0001760800000007ULL, 0x000022f0003f0101ULL, 0x0001760c00000007ULL,
0x000024c0003f0105ULL, 0x0001760c00000007ULL, 0x00002ac0003f0105ULL, 0x000176ac00000019ULL,
0x00002c90003f0105ULL, 0x000176ac00000019ULL, 0x00003fa0003f0105ULL, 0x0000000000000012ULL,
0x00004000003f0101ULL, 0x000176880000005fULL, 0x00004030003f0101ULL, 0x0000000400000006ULL,
0x000041f0003f0105ULL, 0x0000000400000006ULL, 0x00004a10003f0105ULL, 0x000176a800000011ULL,
0x00004aa0003f0107ULL, 0x000176a800000011ULL, 0x00004b00003f0101ULL, 0x0001762800000007ULL,
0x00004b20003f0101ULL, 0x0001762c00000007ULL, 0x00004cf0003f0105ULL, 0x0001762c00000007ULL,
0x000052d0003f0105ULL, 0x000176b40000003bULL, 0x000054a0003f0105ULL, 0x000176b40000003bULL,
0x00006570003f0105ULL, 0x0000000000000036ULL, 0x000065d0003f0101ULL, 0x0001769000000034ULL,
0x00006600003f0101ULL, 0x0000000400000006ULL, 0x000067c0003f0105ULL, 0x0000000400000006ULL,
0x00006fc0003f0105ULL, 0x00000008000000ffULL, 0x000070b000040107ULL, 0x000176b00000000eULL,
0x00007110003f0101ULL, 0x0001764800000007ULL, 0x00007130003f0101ULL, 0x0001764c00000007ULL,
0x00007300003f0105ULL, 0x0001764c00000007ULL, 0x000078f0003f0105ULL, 0x000176ac0000003aULL,
0x00007ac0003f0105ULL, 0x000176ac0000003aULL, 0x00008c00003f0105ULL, 0x0000000000000022ULL,
0x00008c60003f0101ULL, 0x000000000000000bULL, 0x00008c90003f0101ULL, 0x0000000400000006ULL,
0x00008e50003f0105ULL, 0x0000000400000006ULL, 0x00009680003f0105ULL, 0x00000000000000ffULL,
0x0000976000040107ULL, 0x00000000000000ffULL, 0x000097c000040101ULL, 0x0001766800000006ULL,
0x000097f0003f0101ULL, 0x0001766c00000006ULL, 0x000099c0003f0105ULL, 0x0001766c00000006ULL,
0x00009f70003f0105ULL, 0x0000000c000000ffULL, 0x0000a19000040105ULL, 0x0000000c000000ffULL,
0x0000b41000040105ULL, 0x0000000000000006ULL, 0x0000b490003f0101ULL, 0x000000000000000cULL,
0x0000c5a0003f0101ULL, 0x00017600000000ffULL, 0x0000dea0003f0101ULL, 0x00017604000000ffULL,
0x0000e070003f0105ULL, 0x00017604000000ffULL, 0x0000e2a0003f0105ULL, 0x00017600000000ffULL,
0x0000e2d0003f0101ULL, 0x00017604000000ffULL, 0x0000e490003f0105ULL, 0x00017604000000ffULL,
0x00011320003f0105ULL, 0x0000000000000073ULL, 0x000113c0003f0101ULL, 0x0000000400000073ULL,
0x00011590003f0105ULL, 0x0000000400000073ULL, 0x00013950003f0105ULL, 0x0000000000000074ULL,
0x000139b0003f0101ULL, 0x0000000800000074ULL, 0x00013a10003f0101ULL, 0x0000001000000074ULL,
0x00013a80003f0101ULL, 0x0000001800000074ULL, 0x00053803003f0101ULL, 0x0000beb000201c04ULL,
0x0000c0c00000bee0ULL, 0x0000c3b00000c220ULL, 0x0000e4f00000c4b0ULL, 0x0000040100013ad0ULL,
0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL,
0x3605002511000000ULL, 0x00000000000002e4ULL, 0x0000001b00000002ULL, 0x000000000000023cULL,
0x0000001b00000002ULL, 0x00000000000001a4ULL, 0x0000001b00000002ULL, 0x00000000000000f4ULL,
0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL, 0x00000000000002bbULL,
0x0000001b00000002ULL, 0x0000000000000213ULL, 0x0000001b00000002ULL, 0x0000000000000180ULL,
0x0000001b00000002ULL, 0x00000000000000cbULL, 0x0000001b00000002ULL, 0x0000000000017700ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff127624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000787919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000b7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a00127a7a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000f220000002100ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x004fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003057a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a05ULL, 0x0000040003007624ULL, 0x000fca00078e0212ULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000105050810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000105051810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff05aa12ULL, 0x000fc800078e33ffULL,
0x0000000500007306ULL, 0x000e620000209000ULL, 0x000000ff0500720cULL, 0x000fce0003fa5070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x0002a4000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000305047224ULL, 0x004fc800078e02ffULL, 0x000000ffff077224ULL, 0x000fe400078e0a04ULL,
0x0000000000047919ULL, 0x000ee40000002200ULL, 0x0000000703037227ULL, 0x000fcc00078e0002ULL,
0x0000007803747227ULL, 0x000fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a74ULL,
0x0000000005007224ULL, 0x000fca00078e0278ULL, 0x000000050000720cULL, 0x000fe20003f66070ULL,
0x000001000b027a24ULL, 0x008fe400078e0204ULL, 0x00001fff0b0b7589ULL, 0x000fe400000e0000ULL,
0x00000000020d7a24ULL, 0x010fca00078e0209ULL, 0x000000ff0d00720cULL, 0x000fc60003f45270ULL,
0x0000000100003824ULL, 0x000fe200078e0a05ULL, 0x0000000174743810ULL, 0x000fe40007ffe0ffULL,
0x0000007f0d00780cULL, 0x040fe40003f04070ULL, 0x000000050000720cULL, 0x000fe40003f86070ULL,
0x0000000f0d00780cULL, 0x040fe40003f24070ULL, 0x000000030d00780cULL, 0x000fe20003f64070ULL,
0x3fffff80ff02a424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03a424ULL, 0x000fc800078e00ffULL,
0xff317217ff048424ULL, 0x000fe400078e00ffULL, 0x0000000174744810ULL, 0x000fe20007ffe0ffULL,
0x01760002ff00a388ULL, 0x0003e20000000a00ULL, 0x00000005ff74d212ULL, 0x000fe200078e33ffULL,
0x3fffffc0ff069424ULL, 0x000fe200078e00ffULL, 0x000000010d00780cULL, 0x000fe20003f84070ULL,
0x017400040d008388ULL, 0x0005e20000004800ULL, 0x7fffffc0ff079424ULL, 0x000fe400078e00ffULL,
0x000000ffff007224ULL, 0x000fc400078e0a74ULL, 0x3fffff60ff08b424ULL, 0x000fe200078e00ffULL,
0x017608060d009388ULL, 0x0007e20000008a00ULL, 0x0000000005787224ULL, 0x000fe200078e0278ULL,
0x00000005ff007819ULL, 0x000fe20000011609ULL, 0x7fffff60ff09b424ULL, 0x000fe200078e00ffULL,
0x0000000000057919ULL, 0x000f220000002700ULL, 0x0000001078647824ULL, 0x000fe400078e00ffULL,
0x3fffff80ff02b424ULL, 0x002fe200078e00ffULL, 0x00001fff00007589ULL, 0x000e6200000e0000ULL,
0x7fffff80ff03b424ULL, 0x000fe200078e00ffULL, 0x0000000464047c10ULL, 0x004fc4000fffe1ffULL,
0x0000000464007c0cULL, 0x000fe2000bf03070ULL, 0x3fffffc0ff06c424ULL, 0x008fe200078e00ffULL,
0x0000001004047817ULL, 0x000fe20003800000ULL, 0x7fffffc0ff07c424ULL, 0x000fe200078e00ffULL,
0x017688080d00b388ULL, 0x0009e40000008a00ULL, 0x000000ff04777207ULL, 0x000fe40000000000ULL,
0x0176a8020d00b388ULL, 0x0003e20000008a00ULL, 0x00005a0074047a19ULL, 0x000fe400000006ffULL,
0x000000107700780cULL, 0x000fe20003f05270ULL, 0x0176c8060d00c388ULL, 0x000fe20000008a00ULL,
0x0000580005097a24ULL, 0x010fc400078e02ffULL, 0x000000040b027824ULL, 0x002fe400078e0200ULL,
0x0000007a09047224ULL, 0x000fe400078e0204ULL, 0x0000000202027824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000001d000008947ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fc40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x00000004ff097819ULL, 0x002fe20000011603ULL, 0x0000001003087824ULL, 0x000fc800078e00ffULL,
0x00000001020a7824ULL, 0x000fc800078e0209ULL, 0x0000000164067824ULL, 0x000fca00078e020aULL,
0x0000000406077c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0d7a19ULL, 0x000fc60000011606ULL,
0x0000000104047824ULL, 0x000fe200078e0207ULL, 0x0000000277077217ULL, 0x000fc60007800000ULL,
0x0000007a0d047224ULL, 0x000fe200078e0204ULL, 0x000000f0080d7812ULL, 0x000fe200078ec0ffULL,
0x0000000107027824ULL, 0x000fe400078e0a02ULL, 0x0000010004067825ULL, 0x000fc600078e00ffULL,
0x000000020900720cULL, 0x000fe20003f06070ULL, 0x000000010a027824ULL, 0x000fe200078e0203ULL,
0x0000000d060d7212ULL, 0x000fe200078efcffULL, 0x000000100a097824ULL, 0x000fc600078e00ffULL,
0x00005e000d067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff009027812ULL, 0x000fe400078ee202ULL,
0x00005f0007077a10ULL, 0x000fc60000ffe4ffULL, 0x0000001002097824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006097faeULL, 0x0003e2000c101c48ULL,
0x0000018000007947ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x0000000203027211ULL, 0x042fe200078fe0ffULL,
0x0000001003087824ULL, 0x000fc800078e00ffULL, 0x0000000164067824ULL, 0x000fca00078e0202ULL,
0x0000000406097c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff077a19ULL, 0x000fc60000011606ULL,
0x0000000104097824ULL, 0x000fe400078e0209ULL, 0x0000000102047824ULL, 0x000fe400078e0203ULL,
0x0000007a07077224ULL, 0x000fe200078e0209ULL, 0x000000f008097812ULL, 0x000fc600078ec0ffULL,
0x0000010007067825ULL, 0x000fca00078e00ffULL, 0x0000000906067212ULL, 0x000fe200078efcffULL,
0x0000001002097824ULL, 0x000fc600078e00ffULL, 0x00005e0006067a10ULL, 0x000fe40007f1e0ffULL,
0xfffffff009047812ULL, 0x000fe400078ee204ULL, 0x00005f0007077a10ULL, 0x000fc600007fe4ffULL,
0x0000001004097824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006097faeULL, 0x0003e4000b901c48ULL, 0x0000000000077919ULL, 0x002e620000000000ULL,
0x0000000000027806ULL, 0x000fe200038e0000ULL, 0x00000004ff0a7424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000200047300ULL, 0x000e7000000e0000ULL,
0x0000000200067309ULL, 0x000ea20000000000ULL, 0x000000070400720cULL, 0x002fe20003f02070ULL,
0x000000ffff047224ULL, 0x004fc400078e0a06ULL, 0x0000660005067625ULL, 0x000fd400078e000aULL,
0x01760404ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01760000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000806637981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000007f63717810ULL, 0x044fe40007ffe0ffULL,
0x000000ff63097810ULL, 0x000fc40007ffe0ffULL, 0x00000007ff717819ULL, 0x000fe40000011671ULL,
0x00000008ff6e7819ULL, 0x000fca0000011609ULL, 0x0000ba6000008947ULL, 0x000fea0003800000ULL,
0x00000003ff047819ULL, 0x002fe20000011600ULL, 0x00000003ff0d7424ULL, 0x000fe200078e00ffULL,
0x0001768800067811ULL, 0x000fe400078e18ffULL, 0x01ffffff04047812ULL, 0x000fc800078ec0ffULL,
0x000000710400720cULL, 0x000fda0003f06070ULL, 0x0000000205028824ULL, 0x000fe400078e00ffULL,
0x00006800ff078624ULL, 0x000fc800078e00ffULL, 0x0000680002078624ULL, 0x000fe400078e0207ULL,
0xffffffffff027424ULL, 0x000fe400078e00ffULL, 0x0000000104078824ULL, 0x000fe200078e0207ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040d06ff738cULL, 0x0003e20000000000ULL,
0x00006400070a8625ULL, 0x000fe200078e000aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000080a028981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0900780cULL, 0x000fe20003f04070ULL,
0x00000080746f7824ULL, 0x000fe200078e00ffULL, 0x00000001ff6b7819ULL, 0x000fe20000011600ULL,
0x0000000006ff7f8cULL, 0x0007e2000c80043fULL, 0x0000000100767812ULL, 0x000fc600078ec0ffULL,
0x000000206b797824ULL, 0x000fca00078e00ffULL, 0x000000606f097812ULL, 0x000fe200078ef879ULL,
0x0000590002077a24ULL, 0x004fc800078e02ffULL, 0x0000008007197824ULL, 0x000fe200078e00ffULL,
0x0000040000000947ULL, 0x000fea0003800000ULL, 0x0000007963067217ULL, 0x00afe20007800000ULL,
0x0000001076077824ULL, 0x000fe200078e00ffULL, 0x00000003ff0a7819ULL, 0x000fe40000011603ULL,
0x0000620019137a11ULL, 0x000fe200078838ffULL, 0x0000000106067824ULL, 0x000fe200078e0a79ULL,
0x000000040a0d7810ULL, 0x040fe20007ffe0ffULL, 0x00000001070c7824ULL, 0x000fe200078e020aULL,
0x0000000c0a0f7810ULL, 0x000fe40007ffe0ffULL, 0x0000000706067217ULL, 0x000fe20007800000ULL,
0x000000010c0b7824ULL, 0x040fe200078e0203ULL, 0x0000630019197a11ULL, 0x000fe200020f3cffULL,
0x000000080c107824ULL, 0x000fc400078e00ffULL, 0x0000000106067824ULL, 0x000fe400078e0a07ULL,
0x0000000107167824ULL, 0x000fe200078e020fULL, 0xfffffff810107812ULL, 0x000fe200078ee20bULL,
0x00000001090c7824ULL, 0x000fe200078e020cULL, 0x000000080a0b7810ULL, 0x040fe40007ffe0ffULL,
0x000000060a00720cULL, 0x080fe20003f66070ULL, 0x00000001070a7824ULL, 0x000fe200078e020dULL,
0x000000060d00720cULL, 0x080fe20003f46070ULL, 0x00000001070e7824ULL, 0x000fe200078e020bULL,
0x000000060b00720cULL, 0x080fe20003f26070ULL, 0x000000010a077824ULL, 0x040fe200078e0203ULL,
0x000000060f00720cULL, 0x000fe20003f06070ULL, 0x000000080a127824ULL, 0x000fc400078e00ffULL,
0x000000010e0b7824ULL, 0x040fe400078e0203ULL, 0x000000080e147824ULL, 0x000fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x000000800c067825ULL, 0x000fc600078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee20bULL, 0x00000001090a7824ULL, 0x040fe200078e020aULL,
0x0000007006067812ULL, 0x000fe200078ef808ULL, 0x00000001090c7824ULL, 0x040fe400078e020eULL,
0x00000001090e7824ULL, 0x000fe200078e0216ULL, 0x0000000613067210ULL, 0x000fe20007f9e0ffULL,
0x000000800a0a7825ULL, 0x000fc800078e00ffULL, 0x0000000116097824ULL, 0x000fe200078e0203ULL,
0x000000700a117812ULL, 0x000fe200078ef808ULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x0000000816167824ULL, 0x000fe200078e00ffULL, 0x000000700c0a7812ULL, 0x000fe200078ef808ULL,
0x000000800e0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff816167812ULL, 0x000fe200078ee209ULL,
0x0000000107077824ULL, 0x000fe200020e0619ULL, 0x000000700e0c7812ULL, 0x000fe400078ef808ULL,
0x000130006b097811ULL, 0x000fe400078e68ffULL, 0x0000001311087210ULL, 0x080fe40007f9e0ffULL,
0x000000130a0a7210ULL, 0x080fe20007fbe0ffULL, 0x0000001010117824ULL, 0x100fe200078e0209ULL,
0x000000130c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001012137824ULL, 0x000fc400078e0209ULL,
0x0000001014157824ULL, 0x100fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006117faeULL, 0x0003e2000d901c48ULL, 0x0000001016177824ULL, 0x000fe400078e0209ULL,
0x000000010b097824ULL, 0x100fe400020e0619ULL, 0x000000010d0b7824ULL, 0x100fe400028e0619ULL,
0x000000010f0d7824ULL, 0x000fe200030e0619ULL, 0x0000000008137faeULL, 0x0003e8000d101c48ULL,
0x000000000a157faeULL, 0x0003e8000c901c48ULL, 0x000000000c177faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001076067824ULL, 0x00afe200078e00ffULL,
0x0000620019137a11ULL, 0x000fc400078038ffULL, 0x000130006b177811ULL, 0x000fe400078e68ffULL,
0x0000000603067211ULL, 0x000fe400078fe8ffULL, 0x0000630019197a11ULL, 0x000fe400000f3cffULL,
0x00000004060a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000106077824ULL, 0x140fe200078e0203ULL,
0x00000008060c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000806107824ULL, 0x040fe200078e00ffULL,
0x0000000c060e7810ULL, 0x000fe20007ffe0ffULL, 0x000000010a0b7824ULL, 0x000fc400078e0203ULL,
0x000000080a127824ULL, 0x000fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee207ULL,
0x0000000109077824ULL, 0x000fe400078e0206ULL, 0x000000010c0d7824ULL, 0x000fe200078e0203ULL,
0xfffffff812127812ULL, 0x000fe200078ee20bULL, 0x0000008007067825ULL, 0x000fc800078e00ffULL,
0x000000080c147824ULL, 0x000fe200078e00ffULL, 0x0000007006067812ULL, 0x000fe200078ef808ULL,
0x00000001090a7824ULL, 0x040fe400078e020aULL, 0x00000001090c7824ULL, 0x040fe200078e020cULL,
0xfffffff814147812ULL, 0x000fe200078ee20dULL, 0x00000001090f7824ULL, 0x000fe200078e020eULL,
0x0000000613067210ULL, 0x000fe20007f1e0ffULL, 0x000000800a0a7825ULL, 0x000fc800078e00ffULL,
0x000000010e097824ULL, 0x000fe200078e0203ULL, 0x000000700a117812ULL, 0x000fe200078ef808ULL,
0x000000080e167824ULL, 0x000fe400078e00ffULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff816097812ULL, 0x000fe200078ee209ULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c0a7812ULL, 0x000fc600078ef808ULL, 0x0000000107077824ULL, 0x000fe200000e0619ULL,
0x000000700e0c7812ULL, 0x000fe200078ef808ULL, 0x0000001014157824ULL, 0x100fe200078e0217ULL,
0x0000001113087210ULL, 0x040fe20007f1e0ffULL, 0x0000001010117824ULL, 0x100fe200078e0217ULL,
0x0000000a130a7210ULL, 0x040fe40007f3e0ffULL, 0x0000000c130c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001012137824ULL, 0x100fe200078e0217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006117faeULL, 0x0003e2000b901c48ULL, 0x0000001009177824ULL, 0x000fc400078e0217ULL,
0x000000010b097824ULL, 0x100fe400000e0619ULL, 0x000000010d0b7824ULL, 0x100fe400008e0619ULL,
0x000000010f0d7824ULL, 0x000fe200010e0619ULL, 0x0000000008137faeULL, 0x0003e8000b901c48ULL,
0x000000000a157faeULL, 0x0003e8000b901c48ULL, 0x000000000c177faeULL, 0x0003e4000b901c48ULL,
0x000000006b0473c2ULL, 0x000ea200000e0000ULL, 0x000000ff6e00720cULL, 0x000fe20003f05270ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x000176a86b067811ULL, 0x002fe200078e18ffULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x000000ffff1d7224ULL, 0x000fe200078e00ffULL,
0x000176a804047891ULL, 0x004fd2000f8e203fULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff0a7f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200006067f8cULL, 0x000ea2000c80043fULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00009f1000008947ULL, 0x000fea0003800000ULL,
0x0000000205707824ULL, 0x000fe200078e00ffULL, 0x00000002ff727819ULL, 0x000fe20000011600ULL,
0x00006800ff057624ULL, 0x000fc400078e00ffULL, 0x000000ffff0e7224ULL, 0x004fe400078e0007ULL,
0x0000680070707624ULL, 0x000fe400078e0205ULL, 0xff317217ff127424ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fe400078e00ffULL, 0x000000ffff3b7224ULL, 0x000fc400078e00ffULL,
0x00000000000c7805ULL, 0x014fca0000015200ULL, 0x0000000400067824ULL, 0x000fca00078e00ffULL,
0xfffffff8060f7812ULL, 0x000fc800078ec0ffULL, 0x000176c80f117810ULL, 0x000fe20007ffe0ffULL,
0x0176cc000f077984ULL, 0x000ea40000000800ULL, 0x8000000007ff7812ULL, 0x004fe4000780480eULL,
0x0000000000007918ULL, 0x000fee0000000000ULL, 0x0000022000007945ULL, 0x000fe20003800000ULL,
0x000000ffff187224ULL, 0x000fe400078e00ffULL, 0x000000ffff067224ULL, 0x000fe200078e0011ULL,
0x000001e000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x000000060c137210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e0dULL, 0x003d09001300780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401300780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000001306067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000118187810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0176cc000f077984ULL, 0x000ea40000000800ULL,
0x8000000007ff7812ULL, 0x004fe4000780480eULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff067224ULL, 0x000fc400078e0011ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000077824ULL, 0x000fe200078e00ffULL, 0x00000001050d7810ULL, 0x000fc80007ffe0ffULL,
0xffffffe0070c7812ULL, 0x000fe400078ec0ffULL, 0x0000006e0d00720cULL, 0x000fc60003f26070ULL,
0x00000100050c7824ULL, 0x000fca00078e020cULL, 0x000000400c0e7810ULL, 0x000fe20007ffe0ffULL,
0x00005900020c7a24ULL, 0x000fc600078e02ffULL, 0x000000600e027812ULL, 0x000fe200078ec0ffULL,
0x000000800c357824ULL, 0x000fc800078e00ffULL, 0x000000016f0f7824ULL, 0x000fe200078e0202ULL,
0x0000042000009947ULL, 0x000fea0003800000ULL, 0x0000000e63027217ULL, 0x000fe20007800000ULL,
0x0000001003197824ULL, 0x000fe200078e00ffULL, 0x0000001007077812ULL, 0x000fe400078ec0ffULL,
0x00000003ff137819ULL, 0x000fe20000011603ULL, 0x0000000102027824ULL, 0x000fe200078e0a0eULL,
0x0000007019377812ULL, 0x000fe400078ec0ffULL, 0x00000004130e7810ULL, 0x040fe20007ffe0ffULL,
0x00000001130c7824ULL, 0x000fe200078e0207ULL, 0x0000000702027217ULL, 0x000fc40007800000ULL,
0x0000620035237a11ULL, 0x040fe200078a38ffULL, 0x000000010c0d7824ULL, 0x040fe400078e0203ULL,
0x000000080c187824ULL, 0x000fe200078e00ffULL, 0x0000630035357a11ULL, 0x000fe200028f3cffULL,
0x0000000102027824ULL, 0x000fe400078e0a07ULL, 0x000000010f0c7824ULL, 0x000fe200078e020cULL,
0xfffffff818117812ULL, 0x000fe400078ee20dULL, 0x0000000813187810ULL, 0x000fc40007ffe0ffULL,
0x000000021300720cULL, 0x0c0fe40003f86070ULL, 0x000000021800720cULL, 0x0c0fe20003f46070ULL,
0x0000000118187824ULL, 0x000fe200078e0207ULL, 0x0000000c13137810ULL, 0x000fe40007ffe0ffULL,
0x000000020e00720cULL, 0x080fe20003f66070ULL, 0x00000001180d7824ULL, 0x040fe200078e0203ULL,
0x000000021300720cULL, 0x000fe20003f06070ULL, 0x00000008181a7824ULL, 0x000fe400078e00ffULL,
0x000000010e0e7824ULL, 0x000fc400078e0207ULL, 0x0000000113207824ULL, 0x000fe200078e0207ULL,
0xfffffff81a137812ULL, 0x000fe200078ee20dULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x000000010f1a7824ULL, 0x000fe200078e020eULL, 0x000000370c0c7212ULL, 0x000fe200078efcffULL,
0x000000010e027824ULL, 0x000fe400078e0203ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000000c230c7210ULL, 0x000fc60007fbe0ffULL, 0x000000080e077824ULL, 0x000fe200078e00ffULL,
0x000000371a1a7212ULL, 0x000fe200078efcffULL, 0x000000010f0e7824ULL, 0x040fe400078e0218ULL,
0x000000010f187824ULL, 0x000fe200078e0220ULL, 0xfffffff807077812ULL, 0x000fe200078ee202ULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000000120027824ULL, 0x000fe200078e0203ULL,
0x000000370e0e7212ULL, 0x000fe200078efcffULL, 0x0000000820217824ULL, 0x000fe400078e00ffULL,
0x0000008018187825ULL, 0x000fc600078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee202ULL,
0x000000010d0d7824ULL, 0x100fe200028e0635ULL, 0x000000231a1a7210ULL, 0x000fe40007fbe0ffULL,
0x0000003718187212ULL, 0x000fe400078efcffULL, 0x000140006b027811ULL, 0x000fe200078e68ffULL,
0x000000011b1b7824ULL, 0x000fe200028e0635ULL, 0x000000230e0e7210ULL, 0x080fe40007fbe0ffULL,
0x0000002318187210ULL, 0x000fe20007fde0ffULL, 0x0000001011117824ULL, 0x000fc400078e0202ULL,
0x0000001007077824ULL, 0x100fe400078e0202ULL, 0x0000001013137824ULL, 0x100fe200078e0202ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c117faeULL, 0x0005e2000e101c48ULL,
0x000000010f0f7824ULL, 0x100fe400028e0635ULL, 0x0000001021217824ULL, 0x000fe200078e0202ULL,
0x000000001a077faeULL, 0x0005e2000d901c48ULL, 0x0000000119197824ULL, 0x000fc600030e0635ULL,
0x000000000e137faeULL, 0x0005e8000d101c48ULL, 0x0000000018217faeULL, 0x0005e2000c101c48ULL,
0x0000035000007947ULL, 0x000fea0003800000ULL, 0x0000001007027812ULL, 0x000fe200078ec0ffULL,
0x0000001003197824ULL, 0x000fe200078e00ffULL, 0x0000620035237a11ULL, 0x000fe400078038ffULL,
0x0000000203027211ULL, 0x000fe400078fe8ffULL, 0x0000007019217812ULL, 0x000fc400078ec0ffULL,
0x00000004020e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000102077824ULL, 0x140fe200078e0203ULL,
0x0000000802187810ULL, 0x040fe20007ffe0ffULL, 0x00000008021a7824ULL, 0x000fe200078e00ffULL,
0x0000630035357a11ULL, 0x000fe200000f3cffULL, 0x000000010e0c7824ULL, 0x040fe400078e0203ULL,
0x000000080e117824ULL, 0x000fe200078e00ffULL, 0xfffffff81a077812ULL, 0x000fe200078ee207ULL,
0x00000001180d7824ULL, 0x040fe400078e0203ULL, 0x00000008181a7824ULL, 0x000fe200078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee20cULL, 0x000000010f0c7824ULL, 0x040fe200078e0202ULL,
0x0000000c02027810ULL, 0x000fe20007ffe0ffULL, 0x000000010f0e7824ULL, 0x000fe200078e020eULL,
0xfffffff81a137812ULL, 0x000fe200078ee20dULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x000000010f1a7824ULL, 0x040fe200078e0218ULL, 0x000000210c0c7212ULL, 0x000fe200078efcffULL,
0x000000010f187824ULL, 0x000fe400078e0202ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000c230c7210ULL, 0x000fc60007f1e0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x000000210e0e7212ULL, 0x000fc600078efcffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x000000211a1a7212ULL, 0x000fc600078efcffULL, 0x0000000102207824ULL, 0x000fe200078e0203ULL,
0x0000002118187212ULL, 0x000fe200078efcffULL, 0x0000000802377824ULL, 0x000fe200078e00ffULL,
0x000140006b027811ULL, 0x000fe200078e68ffULL, 0x000000010d0d7824ULL, 0x100fe200000e0635ULL,
0x0000000e230e7210ULL, 0x040fe40007f1e0ffULL, 0x0000001a231a7210ULL, 0x000fe20007f5e0ffULL,
0x0000001007077824ULL, 0x000fe200078e0202ULL, 0xfffffff837207812ULL, 0x000fe200078ee220ULL,
0x0000001011117824ULL, 0x100fe200078e0202ULL, 0x0000001823187210ULL, 0x000fe20007f7e0ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0635ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c077faeULL, 0x0005e2000b901c48ULL, 0x0000001013137824ULL, 0x000fc400078e0202ULL,
0x000000011b1b7824ULL, 0x100fe200010e0635ULL, 0x000000000e117faeULL, 0x0005e2000b901c48ULL,
0x0000001020217824ULL, 0x000fe400078e0202ULL, 0x0000000119197824ULL, 0x000fe200018e0635ULL,
0x000000001a137faeULL, 0x0005e8000b901c48ULL, 0x0000000018217faeULL, 0x0005e4000b901c48ULL,
0x0000000800027824ULL, 0x000fe200078e00ffULL, 0x00000001040c7810ULL, 0x004fe20007ffe0ffULL,
0xffffffffff0e7424ULL, 0x000fc400078e00ffULL, 0x00000000020573c2ULL, 0x000ea200000e0000ULL,
0x000000710c00720cULL, 0x000fe40003f06070ULL, 0x00000008020f7812ULL, 0x040fe400078ec0ffULL,
0xffffffe002077812ULL, 0x040fe400078ec0ffULL, 0x0000001002187812ULL, 0x000fce00078ec0ffULL,
0x00000001700c8824ULL, 0x000fe400078e020cULL, 0x00000004ff0d8424ULL, 0x000fe200078e00ffULL,
0xfffffff005057892ULL, 0x004fc6000f8ec03fULL, 0x000064000c0c8625ULL, 0x000fe200078e000dULL,
0x000176b005067890ULL, 0x000fe2000fffe03fULL, 0x000000070f077210ULL, 0x000fc60007ffe018ULL,
0x000000080c0e8981ULL, 0x000528000c1e1900ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176b000ff367f8cULL, 0x000ee2000c800405ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01760800071a7f8cULL, 0x0004e4000c80043fULL,
0x00000000000c7805ULL, 0x004fc40000015200ULL, 0x01760c00070f7984ULL, 0x000ea40000000800ULL,
0x800000000fff7812ULL, 0x00cfc4000780481bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000187805ULL, 0x000fcc0000015200ULL,
0x000000180c187210ULL, 0x000fca0007f1e1ffULL, 0x0000000119197824ULL, 0x000fe200000e0e0dULL,
0x003d09001800780cULL, 0x000fc80003f06070ULL, 0x000000ff1900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401800780cULL, 0x000fc80003f06070ULL,
0x000000ff1900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011419ULL, 0x000000180f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff187224ULL, 0x000fca00000e0619ULL, 0x000000020f0f7819ULL, 0x000fc80000001218ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000111117810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01760c00070f7984ULL, 0x000ea40000000800ULL, 0x800000000fff7812ULL, 0x004fe4000780481bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001003507824ULL, 0x000fe200078e00ffULL,
0x00000001ff737819ULL, 0x000fe20000011603ULL, 0x00000020000c7824ULL, 0x000fc600078e00ffULL,
0x0000007050507812ULL, 0x000fe400078ec0ffULL, 0xffffff800c0c7812ULL, 0x000fe400078ec0ffULL,
0x0000000c73737812ULL, 0x000fc800078ec0ffULL, 0x0000000c730c7210ULL, 0x000fca0007ffe050ULL,
0x017000000c0d7984ULL, 0x000ea80000000800ULL, 0x017200000c117984ULL, 0x0006620000000800ULL,
0x000000120d00720bULL, 0x004fe20003f1d000ULL, 0x000115227f007947ULL, 0x000fd8000b800000ULL,
0x0000000000407806ULL, 0x008fc800000e0100ULL, 0x0000ffff40197812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff187424ULL, 0x000fe400078e00ffULL,
0x000000ffff0f7224ULL, 0x000fd200078e0012ULL, 0x0000046000008947ULL, 0x000fea0003800000ULL,
0x000000007200720cULL, 0x000fe40003f05270ULL, 0x000000120d00720bULL, 0x000fe20003f54000ULL,
0x000114e27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000c7806ULL, 0x000fc400010e0100ULL,
0x0000008000188824ULL, 0x000fe200078e0250ULL, 0x000000120d0f8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x000099100c137816ULL, 0x000fe200000000ffULL,
0x0000000173188824ULL, 0x000fca00078e0218ULL, 0x0174000f18008388ULL, 0x0005e20000000800ULL,
0x000000ff1300720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x000000120d0f7209ULL, 0x004fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0cff7812ULL, 0x000fc6000780c0ffULL, 0x000000120f0f7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0f0f7820ULL, 0x000fcc0000410000ULL, 0x0000000f000f7308ULL, 0x000ea40000000800ULL,
0x0000000f10107220ULL, 0x004fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff347819ULL, 0x000fe20000011603ULL, 0x000114127f007947ULL, 0x000fea000b800000ULL,
0x00001f340f407589ULL, 0x0004e400000e0000ULL, 0x0000004024247220ULL, 0x08cfe40000410000ULL,
0x0000004025257220ULL, 0x080fe40000410000ULL, 0x0000004028287220ULL, 0x080fe40000410000ULL,
0x0000004029297220ULL, 0x000fc40000410000ULL, 0x0000004014147220ULL, 0x080fe40000410000ULL,
0x0000004015157220ULL, 0x080fe40000410000ULL, 0x000000403c3c7220ULL, 0x080fe40000410000ULL,
0x000000403d3d7220ULL, 0x080fe40000410000ULL, 0x000000401c1c7220ULL, 0x080fe40000410000ULL,
0x000000401d1d7220ULL, 0x000fc40000410000ULL, 0x0000004030307220ULL, 0x080fe40000410000ULL,
0x0000004031317220ULL, 0x080fe40000410000ULL, 0x000000402c2c7220ULL, 0x080fe40000410000ULL,
0x000000402d2d7220ULL, 0x080fe40000410000ULL, 0x0000004038387220ULL, 0x080fe40000410000ULL,
0x0000004039397220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000cff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803347811ULL, 0x000fe200078ff0ffULL, 0x000113127f007947ULL, 0x000fea000b800000ULL,
0x00001f340f407589ULL, 0x0004e400000e0000ULL, 0x0000004026267220ULL, 0x08cfe40000410000ULL,
0x0000004027277220ULL, 0x080fe40000410000ULL, 0x000000402a2a7220ULL, 0x080fe40000410000ULL,
0x000000402b2b7220ULL, 0x080fe40000410000ULL, 0x0000004016167220ULL, 0x080fe40000410000ULL,
0x0000004017177220ULL, 0x000fc40000410000ULL, 0x000000403e3e7220ULL, 0x080fe40000410000ULL,
0x000000403f3f7220ULL, 0x080fe40000410000ULL, 0x000000401e1e7220ULL, 0x080fe40000410000ULL,
0x000000401f1f7220ULL, 0x080fe40000410000ULL, 0x0000004032327220ULL, 0x080fe40000410000ULL,
0x0000004033337220ULL, 0x000fc40000410000ULL, 0x000000402e2e7220ULL, 0x080fe40000410000ULL,
0x000000402f2f7220ULL, 0x080fe40000410000ULL, 0x000000403a3a7220ULL, 0x080fe40000410000ULL,
0x000000403b3b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x004fea0003800000ULL,
0x0000ffff19ff7812ULL, 0x000fe2000780600cULL, 0x00000001ff187424ULL, 0x000fe200078e00ffULL,
0x000000120d0f7209ULL, 0x000fd60007810000ULL, 0x8000000f0d0d0221ULL, 0x000fe20000010000ULL,
0x00007610ff180816ULL, 0x000fc60000000018ULL, 0x3fb8aa3b0d0d0820ULL, 0x000fc80000410000ULL,
0x0000000d00080308ULL, 0x000ea40000000800ULL, 0x0000000811110220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001011107221ULL, 0x002fc40000010000ULL,
0x00000000000c7805ULL, 0x000fca0000015200ULL, 0xfffffff002197812ULL, 0x000fca00078ec0ffULL,
0x0176ac0019027984ULL, 0x000e640000000800ULL, 0x8000000002ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x000000120c117210ULL, 0x000fca0007f1e1ffULL,
0x0000000113127824ULL, 0x000fe200000e0e0dULL, 0x003d09001100780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401100780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011412ULL,
0x0000001102027211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0612ULL,
0x0000000202027819ULL, 0x000fc80000001211ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011a1a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac0019027984ULL, 0x000e640000000800ULL,
0x8000000002ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991018027816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000008ff02723eULL, 0x000fe400000000ffULL, 0x00000002ff0b7819ULL, 0x000fe40000011603ULL,
0x0000541002027816ULL, 0x000fe20000000002ULL, 0x00010ef27f007947ULL, 0x000fea000b800000ULL,
0x00001f0b02097589ULL, 0x0002a400000e0000ULL, 0x000000080b347810ULL, 0x000fe20007ffe0ffULL,
0x00010f427f007947ULL, 0x000fea000b800000ULL, 0x00001f34020a7589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000100b347810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff357224ULL, 0x000fe200078e0002ULL, 0x00002e1000417802ULL, 0x000fe20000000f00ULL,
0x0000001fff427424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x00011c0000007944ULL, 0x016fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000180b347810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff357224ULL, 0x000fe200078e0002ULL,
0x00002e8000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff427424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x004fc400078e00ffULL, 0x00011b9000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000002005f7824ULL, 0x040fe200078e00ffULL,
0x00000007030d7812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000008034c7812ULL, 0x000fe400078ec0ffULL, 0x000000045f027812ULL, 0x00afe400078ec0ffULL,
0x000000080d5c7812ULL, 0x000fe400078ef803ULL, 0x00000002030b7211ULL, 0x000fe200078fe0ffULL,
0x0000020000027824ULL, 0x000fc400078e00ffULL, 0x000000085c4b7824ULL, 0x040fe400078e00ffULL,
0x000000015c5e7824ULL, 0x000fe200078e020bULL, 0xfffff80002027812ULL, 0x000fc800078ec0ffULL,
0xfffffff84b4b7812ULL, 0x000fca00078ee25eULL, 0x000000104b4b7824ULL, 0x000fc400078e0202ULL,
0x00000004000b7824ULL, 0x000fe200078e00ffULL, 0x00000004ff6a7819ULL, 0x000fe40000011603ULL,
0x0000000d4c127212ULL, 0x000fe400078efcffULL, 0x000000040b0b7812ULL, 0x000fe400078ec0ffULL,
0x000130006b6d7811ULL, 0x000fe200078e68ffULL, 0x00000008120c7824ULL, 0x000fe200078e00ffULL,
0x000000104c4c7812ULL, 0x000fe200078efe0dULL, 0x000000016a117824ULL, 0x000fe200078e020bULL,
0xfffffff85f5f7812ULL, 0x000fe200078ec0ffULL, 0x0000000812187824ULL, 0x000fc400078e00ffULL,
0x0000000112137824ULL, 0x000fe400078e0211ULL, 0x000000084c0d7824ULL, 0x000fe400078e00ffULL,
0x0000000111487824ULL, 0x000fe200078e024cULL, 0xfffffff80c0b7812ULL, 0x000fe200078ee213ULL,
0x000000084c577824ULL, 0x000fc600078e00ffULL, 0xfffffff80d0c7812ULL, 0x000fe200078ee248ULL,
0x000000100b207824ULL, 0x100fe200078e026dULL, 0x00000002130d7810ULL, 0x000fe40007ffe0ffULL,
0x0000000248487810ULL, 0x000fe20007ffe0ffULL, 0x000000100c447824ULL, 0x000fe200078e026dULL,
0xfffffff8180d7812ULL, 0x000fe200078ee20dULL, 0x000000002020783bULL, 0x000e620000004200ULL,
0xfffffff857487812ULL, 0x000fc600078ee248ULL, 0x000000004444783bULL, 0x000ee20000004200ULL,
0x000000100d187824ULL, 0x000fcc00078e026dULL, 0x000000001818783bULL, 0x000ea40000004200ULL,
0x0000010021407824ULL, 0x046fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fe20000011421ULL,
0x0000010020137824ULL, 0x040fe200078e00ffULL, 0x00008880215a7816ULL, 0x040fe200000000ffULL,
0x0001000021417824ULL, 0x000fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0001000020347824ULL, 0x000fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x00000018ff527819ULL, 0x000fc40000011420ULL,
0x00008880204d7816ULL, 0x000fe400000000ffULL, 0x00000018ff357819ULL, 0x008fe40000011447ULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000004000217306ULL, 0x0003e20000200c00ULL,
0x00000018ff607819ULL, 0x000fe40000011422ULL, 0x0000888022657816ULL, 0x000fe400000000ffULL,
0x00000018ff5d7819ULL, 0x000fc40000011423ULL, 0x00000018ff497819ULL, 0x000fe20000011444ULL,
0x0000001300207306ULL, 0x0005e20000200c00ULL, 0x0000010023407824ULL, 0x002fe200078e00ffULL,
0x00008880444e7816ULL, 0x000fe400000000ffULL, 0x00000018ff4a7819ULL, 0x000fe40000011445ULL,
0x00000018ff647819ULL, 0x000fe40000011440ULL, 0x0000003500127306ULL, 0x000fe20000200c00ULL,
0x00000018ff137819ULL, 0x004fc40000011441ULL, 0x011000004b40783bULL, 0x000e620000000200ULL,
0x0000888045517816ULL, 0x000fe400000000ffULL, 0x00000018ff5b7819ULL, 0x000fe40000011418ULL,
0x0000003400357306ULL, 0x0005e20000200c00ULL, 0x00000018ff117819ULL, 0x000fe40000011446ULL,
0x00000018ff597819ULL, 0x000fe40000011419ULL, 0x00000018ff557819ULL, 0x000fc4000001141aULL,
0x00000018ff567819ULL, 0x000fe2000001141bULL, 0x0000004d004d7306ULL, 0x000ee20000200c00ULL,
0x0000010022347824ULL, 0x044fe200078e00ffULL, 0x00008880474c7816ULL, 0x000fe200000000ffULL,
0x0001000022227824ULL, 0x000fc600078e00ffULL, 0x00000018ff667819ULL, 0x000fe40000011434ULL,
0x0000005a005a7306ULL, 0x000ea20000200c00ULL, 0x0000888023347816ULL, 0x040fe200000000ffULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fc80000011422ULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x0000005200527306ULL, 0x000e620000200c00ULL,
0x000054104d207816ULL, 0x008fce0000000020ULL, 0x0000001300137306ULL, 0x000ee20000200c00ULL,
0x000054105a217816ULL, 0x004fe20000000021ULL, 0x00000100475a7824ULL, 0x040fe200078e00ffULL,
0x0000000940408232ULL, 0x082fe20000000000ULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x0000000942428232ULL, 0x000fe40000000000ULL, 0x0000000a41418232ULL, 0x080fe20000000000ULL,
0x0000002200617306ULL, 0x0003e20000200c00ULL, 0x0000000a43438232ULL, 0x000fe20000000000ULL,
0x0000541035527816ULL, 0x000fc40000000052ULL, 0x00000018ff677819ULL, 0x000fe2000001145aULL,
0x00010000465a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x0000010044227824ULL, 0x042fe200078e00ffULL,
0x0000541013537816ULL, 0x008fe20000000053ULL, 0x000000204024723cULL, 0x000fe20000001824ULL,
0x0001000044447824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x00000018ff227819ULL, 0x000fe20000011422ULL, 0x0000006600667306ULL, 0x000e620000200c00ULL,
0x00000018ff447819ULL, 0x000fc40000011444ULL, 0x000000524028723cULL, 0x000bea0000001828ULL,
0x0000003400347306ULL, 0x000ff00000200c00ULL, 0x0000006400647306ULL, 0x000ea20000200c00ULL,
0x0000541065527816ULL, 0x022fc40000000066ULL, 0x0000888018667816ULL, 0x000fca00000000ffULL,
0x0000002300627306ULL, 0x0003f00000200c00ULL, 0x00000022004f7306ULL, 0x0007e20000200c00ULL,
0x0000010045237824ULL, 0x042fe200078e00ffULL, 0x0000541034537816ULL, 0x004fe20000000064ULL,
0x0001000045457824ULL, 0x000fc600078e00ffULL, 0x00000018ff237819ULL, 0x000fe40000011423ULL,
0x0000006000607306ULL, 0x000e620000200c00ULL, 0x0000001048227824ULL, 0x008fe200078e026dULL,
0x000000524014723cULL, 0x000b620000001814ULL, 0x00000018ff577819ULL, 0x000fe40000011445ULL,
0x0000888046457816ULL, 0x000fc600000000ffULL, 0x0000002300547306ULL, 0x0005e20000200c00ULL,
0x0000010018527824ULL, 0x060fe400078e00ffULL, 0x0001000018187824ULL, 0x000fe400078e00ffULL,
0x0000010019537824ULL, 0x000fc600078e00ffULL, 0x0000005d005d7306ULL, 0x000ee20000200c00ULL,
0x000000002220783bULL, 0x004ea20000004200ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff687819ULL, 0x000fc80000011453ULL, 0x0000004400587306ULL, 0x0003f00000200c00ULL,
0x0000001800697306ULL, 0x0007e20000200c00ULL, 0x0000010046447824ULL, 0x002fca00078e00ffULL,
0x00000018ff447819ULL, 0x000fe40000011444ULL, 0x0000006700467306ULL, 0x0003e20000200c00ULL,
0x0000541061187816ULL, 0x008fe20000000060ULL, 0x000000046b617824ULL, 0x000fca00078e026aULL,
0x0000000261617810ULL, 0x000fe20007ffe05cULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x00000018ff677819ULL, 0x002fe20000011452ULL, 0x000000085c5c7824ULL, 0x000fe200078e00ffULL,
0x0000888019527816ULL, 0x040fe200000000ffULL, 0x0001000019197824ULL, 0x000fc800078e00ffULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x00000018ff537819ULL, 0x000fe40000011419ULL,
0x0000541062197816ULL, 0x000fe4000000005dULL, 0x00000018ff657819ULL, 0x004fe40000011423ULL,
0x000088801a627816ULL, 0x000fe200000000ffULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x000088801b5d7816ULL, 0x000fe200000000ffULL, 0x00000018403c723cULL, 0x000b62000000183cULL,
0x00000018ff357819ULL, 0x000fc40000011420ULL, 0x00000018ff137819ULL, 0x000fc60000011422ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000001001a197824ULL, 0x060fe400078e00ffULL,
0x000001001b187824ULL, 0x040fe400078e00ffULL, 0x000100001a1a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff197819ULL, 0x000fe20000011419ULL, 0x000100001b1b7824ULL, 0x000fe200078e00ffULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff187819ULL, 0x000fe40000011418ULL,
0x00000018ff1a7819ULL, 0x000fca000001141aULL, 0x0000005900597306ULL, 0x000ff00000200c00ULL,
0x0000005300537306ULL, 0x000e700000200c00ULL, 0x0000001900647306ULL, 0x0005f00000200c00ULL,
0x0000006500347306ULL, 0x000fe20000200c00ULL, 0xfffffff85c197812ULL, 0x004fc400078ee261ULL,
0x00000018ff617819ULL, 0x000fe4000001141bULL, 0x0000541053537816ULL, 0x002fe20000000059ULL,
0x0000001019027824ULL, 0x000fe200078e0202ULL, 0x0000541052197816ULL, 0x000fe20000000068ULL,
0x0000001800657306ULL, 0x0003e20000200c00ULL, 0x0000541069527816ULL, 0x000fe2000000005bULL,
0x0001000021687824ULL, 0x000fe200078e00ffULL, 0x00008880205c7816ULL, 0x000fca00000000ffULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x0000541066187816ULL, 0x002fe20000000067ULL,
0x0000010020667824ULL, 0x040fe200078e00ffULL, 0x0000888021677816ULL, 0x000fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x000000524030723cULL, 0x000be40000001830ULL,
0x00000018ff667819ULL, 0x000fe20000011466ULL, 0x0000005d005d7306ULL, 0x000e620000200c00ULL,
0x00000018ff207819ULL, 0x000fc60000011420ULL, 0x0000010021527824ULL, 0x020fe200078e00ffULL,
0x00000018401c723cULL, 0x000b62000000181cULL, 0x000000ffff537224ULL, 0x000fe400078e0067ULL,
0x0000001a00607306ULL, 0x0005e20000200c00ULL, 0x00000018ff677819ULL, 0x000fce0000011452ULL,
0x0000005500557306ULL, 0x000ee20000200c00ULL, 0x011000000218783bULL, 0x024eae0000000200ULL,
0x0000005600567306ULL, 0x000ff00000200c00ULL, 0x0000006100617306ULL, 0x000e700000200c00ULL,
0x00000044004d7306ULL, 0x0003f00000200c00ULL, 0x0000002000527306ULL, 0x0005e20000200c00ULL,
0x00000018ff447819ULL, 0x002fc40000011421ULL, 0x000054105d217816ULL, 0x000fe40000000065ULL,
0x00000018ff5d7819ULL, 0x000fc60000011468ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x0000541062207816ULL, 0x004fe20000000064ULL, 0x0000000918188232ULL, 0x080fe20000000000ULL,
0x0000888022627816ULL, 0x000fe200000000ffULL, 0x000000091a1a8232ULL, 0x000fe40000000000ULL,
0x0000000a19198232ULL, 0x080fe40000000000ULL, 0x00000020402c723cULL, 0x000b62000000182cULL,
0x0000004c004c7306ULL, 0x000e620000200c00ULL, 0x0000000a1b1b8232ULL, 0x000fca0000000000ULL,
0x0000541060207816ULL, 0x028fe20000000055ULL, 0x000000ffff557224ULL, 0x000fe200078e0062ULL,
0x0000541061217816ULL, 0x000fe20000000056ULL, 0x0000004900497306ULL, 0x000eac0000200c00ULL,
0x000000204038723cULL, 0x000b640000001838ULL, 0x0000004700477306ULL, 0x000eea0000200c00ULL,
0x0000010022207824ULL, 0x060fe200078e00ffULL, 0x0000888023427816ULL, 0x040fe200000000ffULL,
0x0000010023217824ULL, 0x040fe200078e00ffULL, 0x0000001100117306ULL, 0x000fe20000200c00ULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0001000023237824ULL, 0x000fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fc40000011421ULL,
0x000054104c217816ULL, 0x002fe40000000046ULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x0000541058567816ULL, 0x004fe40000000049ULL, 0x00000018ff497819ULL, 0x000fca0000011423ULL,
0x0000002000417306ULL, 0x0005f00000200c00ULL, 0x0000005c005b7306ULL, 0x000fe20000200c00ULL,
0x0000541045207816ULL, 0x004fe4000000004dULL, 0x00000018ff457819ULL, 0x000fca0000011422ULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x000000201814723cULL, 0x000b6e0000001814ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x0000541047217816ULL, 0x028fe40000000012ULL,
0x000054105a207816ULL, 0x002fc40000000011ULL, 0x000176c86b127811ULL, 0x000fc600078e18ffULL,
0x00000067005c7306ULL, 0x000e620000200c00ULL, 0x000054104e4e7816ULL, 0x004fe2000000004fULL,
0x000000201820723cULL, 0x000b6c000000183cULL, 0x0000005500407306ULL, 0x000eb00000200c00ULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x00005410533d7816ULL, 0x022fce000000005cULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x0000541040407816ULL, 0x004fce0000000041ULL,
0x0000005700577306ULL, 0x000eb00000200c00ULL, 0x0000003500357306ULL, 0x000ee20000200c00ULL,
0x00005410514f7816ULL, 0x002fce0000000054ULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x0000541057577816ULL, 0x004fe2000000004aULL, 0x0000004e1824723cULL, 0x040b6c0000001824ULL,
0x0000006600597306ULL, 0x000e620000200c00ULL, 0x0000541052527816ULL, 0x008fe20000000035ULL,
0x000000561828723cULL, 0x000b6c0000001828ULL, 0x0000005d005d7306ULL, 0x000eb00000200c00ULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x000054105b3c7816ULL, 0x002fce0000000059ULL,
0x0000004300437306ULL, 0x000e620000200c00ULL, 0x000054105d537816ULL, 0x004fe20000000044ULL,
0x0000003c181c723cULL, 0x040b6c000000181cULL, 0x0000001300137306ULL, 0x000fe40000200c00ULL,
0x000000521830723cULL, 0x000b6c0000001830ULL, 0x0000004500467306ULL, 0x000ea20000200c00ULL,
0x0000541042417816ULL, 0x002fce0000000043ULL, 0x0000004900477306ULL, 0x000e620000200c00ULL,
0x00000040182c723cULL, 0x000b62000000182cULL, 0x0000541046467816ULL, 0x004fe40000000013ULL,
0x0000541047477816ULL, 0x002fce0000000034ULL, 0x000000461818723cULL, 0x000b620000001838ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x0000000012127f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x017688005fff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff117224ULL, 0x000fc600078e00ffULL,
0x0000000000347805ULL, 0x000fc80000015200ULL, 0x0000040006397984ULL, 0x020ee40000000800ULL,
0x8000000039ff7812ULL, 0x00afe40007804813ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000387805ULL, 0x000fcc0000015200ULL, 0x00000038343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000139397824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff387819ULL, 0x000fc80000011439ULL,
0x0000003b38387211ULL, 0x000fca00078110ffULL, 0x000000ffff397224ULL, 0x000fca00000e0639ULL,
0x0000000238387819ULL, 0x000fc80000001239ULL, 0x000000380000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000111117810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040006397984ULL, 0x000e640000000800ULL,
0x8000000039ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000117824ULL, 0x000fe400078e00ffULL, 0x000059000e0e7a24ULL, 0x010fc600078e02ffULL,
0xffffffe011127812ULL, 0x000fe200078ec0ffULL, 0x000000800e0e7824ULL, 0x000fc800078e00ffULL,
0x0000010005127824ULL, 0x000fca00078e0212ULL, 0x0000008012347810ULL, 0x000fc80007ffe0ffULL,
0x0000006034127812ULL, 0x000fca00078ec0ffULL, 0x000000016f3a7824ULL, 0x000fe200078e0212ULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x0000001011387812ULL, 0x000fe400078ec0ffULL,
0x0000003463117217ULL, 0x000fe40007800000ULL, 0x00000003ff127819ULL, 0x000fc60000011603ULL,
0x0000000111117824ULL, 0x000fe200078e0a34ULL, 0x0000000412357810ULL, 0x040fe20007ffe0ffULL,
0x0000000112137824ULL, 0x140fe200078e0238ULL, 0x0000000c123b7810ULL, 0x000fe40007ffe0ffULL,
0x0000001138117217ULL, 0x000fe20007800000ULL, 0x0000000113347824ULL, 0x040fe400078e0203ULL,
0x0000000813397824ULL, 0x000fe400078e00ffULL, 0x0000000111117824ULL, 0x000fc400078e0a38ULL,
0x000000013b3f7824ULL, 0x000fe200078e0238ULL, 0xfffffff8393c7812ULL, 0x000fe200078ee234ULL,
0x0000000135347824ULL, 0x000fe200078e0238ULL, 0x0000000812397810ULL, 0x040fe20007ffe0ffULL,
0x000000013f417824ULL, 0x100fe200078e0203ULL, 0x000000111200720cULL, 0x080fe20003f86070ULL,
0x0000000113127824ULL, 0x000fe200078e023aULL, 0x000000113900720cULL, 0x0c0fe20003f46070ULL,
0x0000000139397824ULL, 0x000fe200078e0238ULL, 0x000000113500720cULL, 0x080fe20003f66070ULL,
0x0000000134137824ULL, 0x040fe200078e0203ULL, 0x000000113b00720cULL, 0x000fe20003f06070ULL,
0x00000008343e7824ULL, 0x000fc400078e00ffULL, 0x0000000139117824ULL, 0x040fe400078e0203ULL,
0x0000000839407824ULL, 0x000fe200078e00ffULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff840407812ULL, 0x000fe200078ee211ULL,
0x0000000134347824ULL, 0x100fe200078e023aULL, 0x000062000e117a11ULL, 0x000fe200078a38ffULL,
0x0000000139387824ULL, 0x100fe200078e023aULL, 0x0000005012127212ULL, 0x000fe200078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x000063000e3d7a11ULL, 0x000fe400028f3cffULL,
0x0000001211127210ULL, 0x000fe20007fbe0ffULL, 0x000000013f3a7824ULL, 0x000fe200078e023aULL,
0x0000005034347212ULL, 0x000fe200078efcffULL, 0x0000008038387825ULL, 0x000fc800078e00ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000005038387212ULL, 0x000fc600078efcffULL,
0x0000000113137824ULL, 0x000fe200028e063dULL, 0x0000001134347210ULL, 0x080fe20007fbe0ffULL,
0x000000083f427824ULL, 0x000fe200078e00ffULL, 0x000000503a3a7212ULL, 0x000fe200078efcffULL,
0x00000010403f7824ULL, 0x000fe400078e026dULL, 0x0000000135357824ULL, 0x000fe200028e063dULL,
0x0000001138387210ULL, 0x080fe40007fbe0ffULL, 0x000000113a3a7210ULL, 0x000fe20007fde0ffULL,
0x000000103c117824ULL, 0x000fe200078e026dULL, 0xfffffff842427812ULL, 0x000fe200078ee241ULL,
0x0000000139397824ULL, 0x000fc400028e063dULL, 0x000000013b3b7824ULL, 0x000fe200030e063dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012117faeULL, 0x0003e2000e101c48ULL,
0x000000103e3d7824ULL, 0x100fe400078e026dULL, 0x0000001042417824ULL, 0x000fc600078e026dULL,
0x00000000343d7faeULL, 0x0003e8000d901c48ULL, 0x00000000383f7faeULL, 0x0003e8000d101c48ULL,
0x000000003a417faeULL, 0x0003e2000c101c48ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x0000001011127812ULL, 0x000fc800078ec0ffULL, 0x0000001203117211ULL, 0x000fc800078fe8ffULL,
0x0000000411347810ULL, 0x040fe20007ffe0ffULL, 0x0000000111137824ULL, 0x040fe200078e0203ULL,
0x0000000c11357810ULL, 0x040fe20007ffe0ffULL, 0x00000008113e7824ULL, 0x040fe400078e00ffULL,
0x0000000111127824ULL, 0x140fe400078e023aULL, 0x00000001343c7824ULL, 0x000fe200078e023aULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL, 0x0000000834407824ULL, 0x040fe200078e00ffULL,
0x0000000811137810ULL, 0x000fe20007ffe0ffULL, 0x0000000134117824ULL, 0x000fc400078e0203ULL,
0x0000000135397824ULL, 0x000fe400078e0203ULL, 0x0000000113387824ULL, 0x040fe200078e023aULL,
0xfffffff840407812ULL, 0x000fe200078ee211ULL, 0x0000000113347824ULL, 0x040fe200078e0203ULL,
0x000062000e117a11ULL, 0x040fe200078038ffULL, 0x00000008133b7824ULL, 0x000fe400078e00ffULL,
0x0000000835447824ULL, 0x000fe200078e00ffULL, 0x000063000e3f7a11ULL, 0x000fe200000f3cffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff83b427812ULL, 0x000fc400078ee234ULL,
0xfffffff844447812ULL, 0x000fe200078ee239ULL, 0x00000001353a7824ULL, 0x000fe200078e023aULL,
0x0000005012347212ULL, 0x000fe200078efcffULL, 0x000000803c3c7825ULL, 0x000fc600078e00ffULL,
0x0000003411347210ULL, 0x000fe20007f1e0ffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x000000503c127212ULL, 0x000fc600078efcffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000005038387212ULL, 0x000fe400078efcffULL, 0x0000001211127210ULL, 0x000fe20007f5e0ffULL,
0x0000000113357824ULL, 0x000fe200000e063fULL, 0x000000503a3a7212ULL, 0x000fe200078efcffULL,
0x0000001044417824ULL, 0x000fe200078e026dULL, 0x0000003811387210ULL, 0x000fe20007f1e0ffULL,
0x000000013d137824ULL, 0x000fe200010e063fULL, 0x0000003a113a7210ULL, 0x000fe20007f7e0ffULL,
0x000000103e117824ULL, 0x000fc400078e026dULL, 0x0000000139397824ULL, 0x100fe400000e063fULL,
0x000000013b3b7824ULL, 0x000fe200018e063fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034117faeULL, 0x0003e2000b901c48ULL, 0x00000010403d7824ULL, 0x100fe400078e026dULL,
0x00000010423f7824ULL, 0x000fc600078e026dULL, 0x00000000123d7faeULL, 0x0003e8000b901c48ULL,
0x00000000383f7faeULL, 0x0003e8000b901c48ULL, 0x000000003a417faeULL, 0x0003e4000b901c48ULL,
0x0000000800117824ULL, 0x002fca00078e00ffULL, 0xfffffff011117812ULL, 0x000fc800078ec0ffULL,
0x00000000110573c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000176a805057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a80011127f8cULL, 0x0002e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176280007387f8cULL, 0x0002a4000c80043fULL, 0x0000000000347805ULL, 0x000fc40000015200ULL,
0x01762c0007117984ULL, 0x002e640000000800ULL, 0x8000000011ff7812ULL, 0x006fe40007804839ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000003a7805ULL, 0x000fcc0000015200ULL, 0x0000003a343a7210ULL, 0x000fca0007f1e1ffULL,
0x000000013b3b7824ULL, 0x000fe200000e0e35ULL, 0x003d09003a00780cULL, 0x000fc80003f06070ULL,
0x000000ff3b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403a00780cULL, 0x000fc80003f06070ULL, 0x000000ff3b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff117819ULL, 0x000fc8000001143bULL,
0x0000003a11117211ULL, 0x000fca00078110ffULL, 0x000000ffff3a7224ULL, 0x000fca00000e063bULL,
0x0000000211117819ULL, 0x000fc8000000123aULL, 0x000000110000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01762c0007117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002000117824ULL, 0x000fca00078e00ffULL, 0xffffff8011117812ULL, 0x000fc800078ec0ffULL,
0x0000008050347810ULL, 0x000fca0007ffe011ULL, 0x0000000173347824ULL, 0x000fca00078e0234ULL,
0x0170000034387984ULL, 0x000e680000000800ULL, 0x0172000034117984ULL, 0x0004e20000000800ULL,
0x0000000f3800720bULL, 0x002fe20003f1d000ULL, 0x0000ef827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000407806ULL, 0x004fc800000e0100ULL, 0x0000ffff403c7812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff3a7424ULL, 0x000fd600078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x0000000172357810ULL, 0x000fe40007ffe0ffULL,
0x0000000f3800720bULL, 0x000fe40003f54000ULL, 0x000000003500720cULL, 0x000fe20003f05270ULL,
0x0000ef427f007947ULL, 0x000fd4000b800000ULL, 0x0000000000397806ULL, 0x000fc400010e0100ULL,
0x00000080003a8824ULL, 0x000fe200078e0250ULL, 0x0000000f38348209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991039357816ULL, 0x000fe200000000ffULL,
0x00000001733b8824ULL, 0x000fca00078e023aULL, 0x017400343b008388ULL, 0x0003e20000000800ULL,
0x000000ff3500720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000f38347209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff39ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000f34347221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b34347820ULL, 0x000fc80000410000ULL, 0x00000034003b7308ULL, 0x000e640000000800ULL,
0x0000003b10107220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff347819ULL, 0x000fe20000011603ULL, 0x0000ee727f007947ULL, 0x000fea000b800000ULL,
0x00001f343b407589ULL, 0x0002a400000e0000ULL, 0x0000004024247220ULL, 0x084fe40000410000ULL,
0x0000004025257220ULL, 0x080fe40000410000ULL, 0x0000004028287220ULL, 0x080fe40000410000ULL,
0x0000004029297220ULL, 0x000fc40000410000ULL, 0x0000004014147220ULL, 0x080fe40000410000ULL,
0x0000004015157220ULL, 0x080fe40000410000ULL, 0x0000004020207220ULL, 0x080fe40000410000ULL,
0x0000004021217220ULL, 0x080fe40000410000ULL, 0x000000401c1c7220ULL, 0x080fe40000410000ULL,
0x000000401d1d7220ULL, 0x000fc40000410000ULL, 0x0000004030307220ULL, 0x080fe40000410000ULL,
0x0000004031317220ULL, 0x080fe40000410000ULL, 0x000000402c2c7220ULL, 0x080fe40000410000ULL,
0x000000402d2d7220ULL, 0x080fe40000410000ULL, 0x0000004018187220ULL, 0x080fe40000410000ULL,
0x0000004019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0039ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803347811ULL, 0x002fe200078ff0ffULL, 0x0000ed727f007947ULL, 0x000fea000b800000ULL,
0x00001f343b407589ULL, 0x0002a400000e0000ULL, 0x0000004026267220ULL, 0x084fe40000410000ULL,
0x0000004027277220ULL, 0x080fe40000410000ULL, 0x000000402a2a7220ULL, 0x080fe40000410000ULL,
0x000000402b2b7220ULL, 0x080fe40000410000ULL, 0x0000004016167220ULL, 0x080fe40000410000ULL,
0x0000004017177220ULL, 0x000fc40000410000ULL, 0x0000004022227220ULL, 0x080fe40000410000ULL,
0x0000004023237220ULL, 0x080fe40000410000ULL, 0x000000401e1e7220ULL, 0x080fe40000410000ULL,
0x000000401f1f7220ULL, 0x080fe40000410000ULL, 0x0000004032327220ULL, 0x080fe40000410000ULL,
0x0000004033337220ULL, 0x000fc40000410000ULL, 0x000000402e2e7220ULL, 0x080fe40000410000ULL,
0x000000402f2f7220ULL, 0x080fe40000410000ULL, 0x000000401a1a7220ULL, 0x080fe40000410000ULL,
0x000000401b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff3cff7812ULL, 0x000fe20007806039ULL, 0x00000001ff3a7424ULL, 0x000fe200078e00ffULL,
0x0000000f380f7209ULL, 0x000fd60007810000ULL, 0x8000000f38380221ULL, 0x000fe20000010000ULL,
0x00007610ff3a0816ULL, 0x000fc6000000003aULL, 0x3fb8aa3b38380820ULL, 0x000fc80000410000ULL,
0x0000003800080308ULL, 0x000e640000000800ULL, 0x0000000811110220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001011107221ULL, 0x008fc40000010000ULL,
0x0000000000347805ULL, 0x000fca0000015200ULL, 0x0000000800117824ULL, 0x000fca00078e00ffULL,
0xfffffff0113b7812ULL, 0x000fca00078ec0ffULL, 0x0176b4003b117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe40007804837ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x0000003834387210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e35ULL,
0x003d09003800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff117819ULL, 0x000fc80000011439ULL, 0x0000003811117211ULL, 0x000fca00078110ffULL,
0x000000ffff387224ULL, 0x000fca00000e0639ULL, 0x0000000211117819ULL, 0x000fc80000001238ULL,
0x000000110000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176b4003b117984ULL, 0x000e640000000800ULL, 0x8000000011ff7812ULL, 0x002fe40007804837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099103a117816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000008ff09723eULL, 0x000fe400000000ffULL,
0x00000002ff367819ULL, 0x000fe40000011603ULL, 0x0000541009117816ULL, 0x000fe20000000009ULL,
0x0000e9427f007947ULL, 0x000fea000b800000ULL, 0x00001f3611097589ULL, 0x0002a400000e0000ULL,
0x0000000836347810ULL, 0x000fe20007ffe0ffULL, 0x0000e9927f007947ULL, 0x000fea000b800000ULL,
0x00001f34110a7589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001036347810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff357224ULL, 0x000fe200078e0011ULL,
0x0000562000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff427424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0000f3f000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001836347810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff357224ULL, 0x000fe200078e0011ULL, 0x0000569000417802ULL, 0x000fe20000000f00ULL,
0x0000001fff427424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x004fc400078e00ffULL,
0x0000f38000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x000010006d117810ULL, 0x00afca0007ffe0ffULL,
0x000000100b387824ULL, 0x100fe400078e0211ULL, 0x000000100d3c7824ULL, 0x100fe400078e0211ULL,
0x000000100c407824ULL, 0x104fe400078e0211ULL, 0x000000003838783bULL, 0x000e620000004200ULL,
0x0000001048447824ULL, 0x000fc600078e0211ULL, 0x000000003c3c783bULL, 0x000ea80000004200ULL,
0x000000004040783bULL, 0x000ee80000004200ULL, 0x000000004444783bULL, 0x000f220000004200ULL,
0x0001000038357824ULL, 0x042fe200078e00ffULL, 0x00000018ff597819ULL, 0x000fe20000011438ULL,
0x0000010038347824ULL, 0x040fe200078e00ffULL, 0x00008880385f7816ULL, 0x000fe200000000ffULL,
0x000001003a5a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe20000011435ULL,
0x0000010039357824ULL, 0x040fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fe20000011434ULL,
0x0000005900597306ULL, 0x000fe20000200c00ULL, 0x0000888039607816ULL, 0x000fc400000000ffULL,
0x00000018ff577819ULL, 0x000fe20000011435ULL, 0x0001000039357824ULL, 0x000fe200078e00ffULL,
0x00000018ff587819ULL, 0x000fe40000011439ULL, 0x00000018ff687819ULL, 0x000fe2000001145aULL,
0x0000003400387306ULL, 0x0003e20000200c00ULL, 0x00000018ff5d7819ULL, 0x000fe20000011435ULL,
0x000001003b5a7824ULL, 0x000fe200078e00ffULL, 0x000088803a5b7816ULL, 0x040fe400000000ffULL,
0x00000018ff657819ULL, 0x000fe2000001143aULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000005f005f7306ULL, 0x000ee20000200c00ULL,
0x011800004b34783bULL, 0x002e620000000200ULL, 0x00000018ff567819ULL, 0x004fc4000001143cULL,
0x00000018ff6c7819ULL, 0x000fe4000001143aULL, 0x000088803c3a7816ULL, 0x040fe400000000ffULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x00000018ff647819ULL, 0x000fe4000001143bULL,
0x00000018ff537819ULL, 0x000fe4000001143eULL, 0x00000018ff547819ULL, 0x000fe4000001143fULL,
0x00000018ff557819ULL, 0x000fe2000001143dULL, 0x0000005700397306ULL, 0x0005220000200c00ULL,
0x000054105f387816ULL, 0x008fe20000000038ULL, 0x000001003c5f7824ULL, 0x040fe200078e00ffULL,
0x000088803d667816ULL, 0x000fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fc40000011440ULL, 0x00000018ff5f7819ULL, 0x000fe2000001145fULL,
0x0000005c005c7306ULL, 0x000ee20000200c00ULL, 0x000088803b577816ULL, 0x044fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x00000018ff4c7819ULL, 0x000fe40000011442ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x0000541060397816ULL, 0x010fc40000000039ULL,
0x00000018ff4d7819ULL, 0x000fe40000011443ULL, 0x00000018ff527819ULL, 0x000fe40000011441ULL,
0x00000018ff497819ULL, 0x000fe20000011445ULL, 0x0000005d005d7306ULL, 0x000ea20000200c00ULL,
0x0000000934348232ULL, 0x082fe20000000000ULL, 0x00000018ff4f7819ULL, 0x000fe20000011446ULL,
0x0000000936368232ULL, 0x000fe20000000000ULL, 0x00000018ff4e7819ULL, 0x000fe20000011447ULL,
0x0000000a35358232ULL, 0x080fe20000000000ULL, 0x00000018ff4a7819ULL, 0x000fe20000011444ULL,
0x0000000a37378232ULL, 0x000fe20000000000ULL, 0x0000005b005b7306ULL, 0x000fec0000200c00ULL,
0x000000383424723cULL, 0x000be40000001824ULL, 0x0000006800687306ULL, 0x000fea0000200c00ULL,
0x000001003d387824ULL, 0x060fe200078e00ffULL, 0x000088803e397816ULL, 0x000fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x0000005700577306ULL, 0x000fe40000200c00ULL,
0x00000018ff387819ULL, 0x000fc40000011438ULL, 0x00000018ff3d7819ULL, 0x000fc8000001143dULL,
0x0000003800677306ULL, 0x0007f00000200c00ULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x000054105c387816ULL, 0x008fe20000000059ULL, 0x000001003e5c7824ULL, 0x000fc400078e00ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff617819ULL, 0x000fe2000001145cULL,
0x0000003900597306ULL, 0x0005e20000200c00ULL, 0x000088803f5c7816ULL, 0x000fe400000000ffULL,
0x00000018ff3e7819ULL, 0x000fca000001143eULL, 0x0000003c00607306ULL, 0x0007e20000200c00ULL,
0x000054105d397816ULL, 0x004fce0000000058ULL, 0x000000383428723cULL, 0x000be20000001828ULL,
0x0000006500657306ULL, 0x000fec0000200c00ULL, 0x000001003f387824ULL, 0x060fe400078e00ffULL,
0x0000010040397824ULL, 0x000fe200078e00ffULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fc40000011438ULL,
0x00000018ff3c7819ULL, 0x008fe40000011439ULL, 0x0000541057397816ULL, 0x002fe4000000005aULL,
0x00000038005d7306ULL, 0x0003e20000200c00ULL, 0x00000018ff627819ULL, 0x000fe4000001143fULL,
0x00008880403f7816ULL, 0x040fe200000000ffULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00008880415a7816ULL, 0x000fc600000000ffULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x000054105b387816ULL, 0x002fe40000000068ULL, 0x00000018ff407819ULL, 0x000fca0000011440ULL,
0x0000003b006a7306ULL, 0x000e620000200c00ULL, 0x000000383414723cULL, 0x000bee0000001814ULL,
0x0000010041387824ULL, 0x020fe200078e00ffULL, 0x0000006100587306ULL, 0x000ea20000200c00ULL,
0x0000010042397824ULL, 0x000fc400078e00ffULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fc80000011438ULL, 0x0000003e00617306ULL, 0x0007e20000200c00ULL,
0x00000018ff417819ULL, 0x000fce0000011441ULL, 0x00000038005b7306ULL, 0x0009e20000200c00ULL,
0x00000018ff3e7819ULL, 0x008fe40000011439ULL, 0x000054106a397816ULL, 0x002fe40000000064ULL,
0x0000541059587816ULL, 0x004fc60000000058ULL, 0x0000005f003b7306ULL, 0x000fe20000200c00ULL,
0x000054106c387816ULL, 0x010fce0000000065ULL, 0x0000005600567306ULL, 0x000e620000200c00ULL,
0x000000383420723cULL, 0x000b6e0000001820ULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x0000010043387824ULL, 0x020fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003d005f7306ULL, 0x0004f00000200c00ULL, 0x0000004000697306ULL, 0x0009e20000200c00ULL,
0x00008880423d7816ULL, 0x044fe200000000ffULL, 0x0001000042427824ULL, 0x000fca00078e00ffULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x0000003a003a7306ULL, 0x000fe20000200c00ULL,
0x0000888043407816ULL, 0x050fe200000000ffULL, 0x0001000043437824ULL, 0x000fca00078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000004200657306ULL, 0x0003f00000200c00ULL,
0x0000004300647306ULL, 0x0007e20000200c00ULL, 0x0000541060427816ULL, 0x002fe20000000056ULL,
0x0000010045567824ULL, 0x040fe200078e00ffULL, 0x0000888045607816ULL, 0x000fca00000000ffULL,
0x0000006600667306ULL, 0x000e620000200c00ULL, 0x000054105f437816ULL, 0x008fe40000000055ULL,
0x00000018ff5f7819ULL, 0x000fe20000011456ULL, 0x0001000044567824ULL, 0x000fc800078e00ffULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x000000423430723cULL, 0x000bee0000001830ULL,
0x0000005400547306ULL, 0x000fe20000200c00ULL, 0x0001000045437824ULL, 0x020fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fc40000011456ULL, 0x0000541066397816ULL, 0x002fe40000000067ULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000005c005c7306ULL, 0x000e700000200c00ULL,
0x0000006200627306ULL, 0x000eb00000200c00ULL, 0x0000004100687306ULL, 0x000fe20000200c00ULL,
0x000054105c597816ULL, 0x002fce000000005dULL, 0x0000003800417306ULL, 0x0003e20000200c00ULL,
0x00000058342c723cULL, 0x000bee000000182cULL, 0x0000004200457306ULL, 0x0007e20000200c00ULL,
0x000054103a387816ULL, 0x002fe2000000003bULL, 0x00000100443a7824ULL, 0x000fe200078e00ffULL,
0x0000888046587816ULL, 0x020fc800000000ffULL, 0x00000018ff667819ULL, 0x000fe2000001143aULL,
0x0000004300567306ULL, 0x0005e20000200c00ULL, 0x0000541061427816ULL, 0x008fe20000000053ULL,
0x00000038341c723cULL, 0x000b62000000181cULL, 0x000000ffff537224ULL, 0x000fe200078e0058ULL,
0x011800000238783bULL, 0x020e680000000200ULL, 0x0000003f003f7306ULL, 0x000fe20000200c00ULL,
0x0000541062437816ULL, 0x004fce0000000054ULL, 0x0000003c00577306ULL, 0x0004e20000200c00ULL,
0x000000423418723cULL, 0x000b6e0000001818ULL, 0x0000010046347824ULL, 0x060fe200078e00ffULL,
0x0000888047427816ULL, 0x000fe200000000ffULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x00008880443c7816ULL, 0x004fe200000000ffULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff347819ULL, 0x000fc40000011434ULL, 0x00000018ff467819ULL, 0x000fca0000011446ULL,
0x0000003400377306ULL, 0x0007f00000200c00ULL, 0x0000003e003e7306ULL, 0x000ea20000200c00ULL,
0x000054103f347816ULL, 0x008fe20000000057ULL, 0x00000100473f7824ULL, 0x040fe200078e00ffULL,
0x0000000938388232ULL, 0x082fe20000000000ULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x000000093a3a8232ULL, 0x000fc40000000000ULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0000004c004c7306ULL, 0x000e620000200c00ULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x0000000a39398232ULL, 0x080fe40000000000ULL, 0x0000000a3b3b8232ULL, 0x000fc80000000000ULL,
0x0000004d004d7306ULL, 0x000ee20000200c00ULL, 0x000054103d3e7816ULL, 0x004fce000000003eULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x00005410654c7816ULL, 0x002fce000000004cULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x00005410644d7816ULL, 0x008fce000000004dULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x0000004c3820723cULL, 0x000f6e0000001820ULL,
0x0000003c003c7306ULL, 0x000ff00000200c00ULL, 0x0000006600027306ULL, 0x000e700000200c00ULL,
0x0000006000557306ULL, 0x000ff00000200c00ULL, 0x0000005f00447306ULL, 0x000ea20000200c00ULL,
0x000054103c3c7816ULL, 0x002fe20000000002ULL, 0x0000000200027824ULL, 0x000fcc00078e00ffULL,
0x0000004600467306ULL, 0x000e700000200c00ULL, 0x0000004700477306ULL, 0x000ee20000200c00ULL,
0x00005410553d7816ULL, 0x004fce0000000044ULL, 0x0000005a005a7306ULL, 0x000ea20000200c00ULL,
0x0000541046467816ULL, 0x002fe2000000004fULL, 0x0000003c381c723cULL, 0x000f6c000000181cULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x0000541047477816ULL, 0x008fce000000004eULL,
0x0000005200527306ULL, 0x000ee20000200c00ULL, 0x000054105a357816ULL, 0x004fe2000000005bULL,
0x000000463818723cULL, 0x040f6c0000001818ULL, 0x0000003f00437306ULL, 0x0005e40000200c00ULL,
0x000000343824723cULL, 0x000b6c0000001824ULL, 0x0000005300367306ULL, 0x000f220000200c00ULL,
0x00005410403f7816ULL, 0x004fc40000000041ULL, 0x0000541069347816ULL, 0x022fe40000000051ULL,
0x0000541068357816ULL, 0x008fc60000000052ULL, 0x0000004a004a7306ULL, 0x000e620000200c00ULL,
0x0000003e3814723cULL, 0x040f6e0000001814ULL, 0x0000004900497306ULL, 0x000ea20000200c00ULL,
0x000000343828723cULL, 0x000b620000001828ULL, 0x0000541036367816ULL, 0x010fcc0000000037ULL,
0x0000004200427306ULL, 0x000ee20000200c00ULL, 0x0000541045347816ULL, 0x022fe4000000004aULL,
0x0000541056357816ULL, 0x004fce0000000049ULL, 0x000000343830723cULL, 0x000b620000001830ULL,
0x0000541042377816ULL, 0x008fcc0000000043ULL, 0xfffffff802347812ULL, 0x020fe200078ec0ffULL,
0x00000036382c723cULL, 0x000b6e000000182cULL, 0x000176c86b367811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000036367f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176900034ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff027224ULL, 0x000fc600078e00ffULL, 0x0000000000347805ULL, 0x004fc80000015200ULL,
0x0000040006397984ULL, 0x000ea40000000800ULL, 0x8000000039ff7812ULL, 0x006fc40007804837ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x00000038343b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e35ULL,
0x003d09003b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff387819ULL, 0x000fc80000011439ULL, 0x0000003b38387211ULL, 0x000fca00078110ffULL,
0x000000ffff397224ULL, 0x000fca00000e0639ULL, 0x0000000238387819ULL, 0x000fc80000001239ULL,
0x000000380000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000102027810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040006397984ULL, 0x000e640000000800ULL, 0x8000000039ff7812ULL, 0x002fe40007804837ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010005367824ULL, 0x000fca00078e0279ULL,
0x000000c036347810ULL, 0x000fc80007ffe0ffULL, 0x0000006034027812ULL, 0x000fca00078ec0ffULL,
0x000000016f3c7824ULL, 0x000fe200078e0202ULL, 0x0000040000009947ULL, 0x000fea0003800000ULL,
0x0000003463027217ULL, 0x000fe20007800000ULL, 0x0000001000357824ULL, 0x000fc800078e00ffULL,
0x0000000102027824ULL, 0x000fe200078e0a34ULL, 0x0000001035357812ULL, 0x000fe400078ec0ffULL,
0x00000003ff347819ULL, 0x000fe40000011603ULL, 0x0000000235027217ULL, 0x000fe40007800000ULL,
0x0000000434377810ULL, 0x040fe40007ffe0ffULL, 0x0000000834387810ULL, 0x000fe20007ffe0ffULL,
0x0000000102027824ULL, 0x000fe200078e0a35ULL, 0x0000000c34397810ULL, 0x000fc60007ffe0ffULL,
0x00000001383a7824ULL, 0x100fe200078e0235ULL, 0x000000023400720cULL, 0x0c0fe20003f86070ULL,
0x0000000134347824ULL, 0x100fe200078e0235ULL, 0x000000023700720cULL, 0x0c0fe20003f66070ULL,
0x0000000137377824ULL, 0x100fe200078e0235ULL, 0x000000023800720cULL, 0x080fe20003f46070ULL,
0x0000000139417824ULL, 0x040fe200078e0235ULL, 0x000000023900720cULL, 0x000fe20003f06070ULL,
0x0000000134027824ULL, 0x040fe400078e0203ULL, 0x0000000834397824ULL, 0x000fc400078e00ffULL,
0x0000000137357824ULL, 0x140fe400078e0203ULL, 0x00000008373e7824ULL, 0x000fe200078e00ffULL,
0xfffffff839027812ULL, 0x000fe200078ee202ULL, 0x0000000134347824ULL, 0x000fe400078e023cULL,
0x000000013a397824ULL, 0x000fe200078e0203ULL, 0xfffffff83e3e7812ULL, 0x000fe200078ee235ULL,
0x000000083a407824ULL, 0x000fe400078e00ffULL, 0x0000008034347825ULL, 0x000fc600078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee239ULL, 0x0000000137387824ULL, 0x100fe200078e023cULL,
0x000062000e377a11ULL, 0x000fe200078a38ffULL, 0x000000013a3a7824ULL, 0x100fe200078e023cULL,
0x0000005034347212ULL, 0x080fe200078efcffULL, 0x0000008038387825ULL, 0x000fe200078e00ffULL,
0x000063000e3f7a11ULL, 0x000fe400028f3cffULL, 0x0000003734347210ULL, 0x000fe20007fbe0ffULL,
0x00000001413c7824ULL, 0x000fe200078e023cULL, 0x0000005038387212ULL, 0x000fe200078efcffULL,
0x000000803a3a7825ULL, 0x000fc800078e00ffULL, 0x000000803c3c7825ULL, 0x000fe200078e00ffULL,
0x000000503a3a7212ULL, 0x000fc600078efcffULL, 0x0000000135357824ULL, 0x000fe200028e063fULL,
0x0000003738387210ULL, 0x080fe20007fbe0ffULL, 0x00000001410e7824ULL, 0x040fe200078e0203ULL,
0x000000503c3c7212ULL, 0x000fe200078efcffULL, 0x0000000841417824ULL, 0x000fe400078e00ffULL,
0x0000000139397824ULL, 0x000fe200028e063fULL, 0x000000373a3a7210ULL, 0x080fe40007fbe0ffULL,
0x000000373c3c7210ULL, 0x000fe20007fde0ffULL, 0x0000001002377824ULL, 0x000fe200078e0211ULL,
0xfffffff8410e7812ULL, 0x000fe200078ee20eULL, 0x000000013b3b7824ULL, 0x000fc400028e063fULL,
0x000000013d3d7824ULL, 0x000fe200030e063fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000034377faeULL, 0x0003e2000e101c48ULL, 0x000000103e3f7824ULL, 0x100fe400078e0211ULL,
0x0000001040417824ULL, 0x100fe400078e0211ULL, 0x000000100e437824ULL, 0x000fe200078e0211ULL,
0x00000000383f7faeULL, 0x0003e8000d901c48ULL, 0x000000003a417faeULL, 0x0003e8000d101c48ULL,
0x000000003c437faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x000fca00078e00ffULL, 0x0000001002027812ULL, 0x000fc800078ec0ffULL,
0x0000000203027211ULL, 0x000fc800078fe8ffULL, 0x0000000402377810ULL, 0x040fe20007ffe0ffULL,
0x0000000102357824ULL, 0x040fe200078e0203ULL, 0x0000000c02387810ULL, 0x040fe20007ffe0ffULL,
0x0000000802407824ULL, 0x040fe400078e00ffULL, 0x0000000102347824ULL, 0x100fe400078e023cULL,
0x00000001373e7824ULL, 0x040fe200078e023cULL, 0xfffffff840407812ULL, 0x000fe200078ee235ULL,
0x00000008373b7824ULL, 0x040fe200078e00ffULL, 0x0000000802357810ULL, 0x000fe20007ffe0ffULL,
0x0000000137027824ULL, 0x000fc400078e0203ULL, 0x0000000138397824ULL, 0x100fe400078e0203ULL,
0x0000000135377824ULL, 0x000fe200078e0203ULL, 0xfffffff83b027812ULL, 0x000fe200078ee202ULL,
0x0000000835427824ULL, 0x040fe400078e00ffULL, 0x00000001353a7824ULL, 0x100fe400078e023cULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe400078ee237ULL,
0x000062000e377a11ULL, 0x000fe200078038ffULL, 0x00000001383c7824ULL, 0x000fc400078e023cULL,
0x0000000838447824ULL, 0x000fe200078e00ffULL, 0x0000005034387212ULL, 0x080fe200078efcffULL,
0x000000803e3e7825ULL, 0x000fe200078e00ffULL, 0x000063000e417a11ULL, 0x000fe400000f3cffULL,
0x0000003738387210ULL, 0x000fe20007f1e0ffULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x000000503e347212ULL, 0x080fe400078efcffULL, 0xfffffff844447812ULL, 0x000fe200078ee239ULL,
0x000000803c3c7825ULL, 0x000fe200078e00ffULL, 0x000000503a3a7212ULL, 0x000fc400078efcffULL,
0x0000003734347210ULL, 0x080fe20007f5e0ffULL, 0x0000000135397824ULL, 0x000fe200000e0641ULL,
0x000000503c3c7212ULL, 0x000fe200078efcffULL, 0x0000001044437824ULL, 0x000fe200078e0211ULL,
0x000000373a3a7210ULL, 0x080fe20007f1e0ffULL, 0x000000013f357824ULL, 0x000fe200010e0641ULL,
0x000000373c3c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001040377824ULL, 0x000fe400078e0211ULL,
0x000000013b3b7824ULL, 0x100fe400000e0641ULL, 0x000000013d3d7824ULL, 0x000fe200018e0641ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000038377faeULL, 0x0003e2000b901c48ULL,
0x00000010023f7824ULL, 0x000fc400078e0211ULL, 0x0000001042417824ULL, 0x000fc600078e0211ULL,
0x00000000343f7faeULL, 0x0003e8000b901c48ULL, 0x000000003a417faeULL, 0x0003e8000b901c48ULL,
0x000000003c437faeULL, 0x0003e4000b901c48ULL, 0x0000000204047810ULL, 0x000fe20007ffe0ffULL,
0x0000000804057890ULL, 0x000fe2000fffe03fULL, 0xffffffffff027424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000710400720cULL, 0x000fcc0003f06070ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fee0008000a05ULL, 0x0000000104348824ULL, 0x000fe400078e0270ULL,
0x00000004ff358424ULL, 0x000fc800078e00ffULL, 0x0000640034348625ULL, 0x000fca00078e0035ULL,
0x0000000834028981ULL, 0x000322000c1e1900ULL, 0x00000008000e7824ULL, 0x000fca00078e00ffULL,
0xfffffff00e0e7812ULL, 0x000fe200078ec0ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176b0000e387f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176480007347f8cULL, 0x0022a4000c80043fULL,
0x00000000003a7805ULL, 0x000fc40000015200ULL, 0x01764c0007377984ULL, 0x000e640000000800ULL,
0x8000000037ff7812ULL, 0x006fe40007804835ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3e7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000003c7805ULL, 0x000fcc0000015200ULL,
0x0000003c3a377210ULL, 0x000fca0007f1e1ffULL, 0x000000013d3c7824ULL, 0x000fe200000e0e3bULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3c00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3c00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0e7819ULL, 0x000fc8000001143cULL, 0x000000370e0e7211ULL, 0x000fca00078110ffULL,
0x000000ffff377224ULL, 0x000fca00000e063cULL, 0x000000020e0e7819ULL, 0x000fc80000001237ULL,
0x0000000e0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013e3e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01764c0007377984ULL, 0x000e640000000800ULL, 0x8000000037ff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000077824ULL, 0x000fca00078e00ffULL,
0xffffff8007077812ULL, 0x000fc800078ec0ffULL, 0x00000100500e7810ULL, 0x000fca0007ffe007ULL,
0x00000001730e7824ULL, 0x000fca00078e020eULL, 0x017000000e3a7984ULL, 0x000e680000000800ULL,
0x017200000e377984ULL, 0x0004e20000000800ULL, 0x0000000f3a00720bULL, 0x002fe20003f1d000ULL,
0x0000cbd27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000407806ULL, 0x004fc800000e0100ULL,
0x0000ffff403c7812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff3b7424ULL, 0x000fe400078e00ffULL, 0x000000ffff077224ULL, 0x000fd200078e000fULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x0000000272077810ULL, 0x000fe40007ffe0ffULL,
0x0000000f3a00720bULL, 0x000fe40003f54000ULL, 0x000000000700720cULL, 0x000fe20003f05270ULL,
0x0000cb827f007947ULL, 0x000fd4000b800000ULL, 0x0000000000077806ULL, 0x000fc400010e0100ULL,
0x0000008000348824ULL, 0x000fe200078e0250ULL, 0x0000000f3a0e8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x0000000173358824ULL, 0x000fe200078e0234ULL,
0x0000991007347816ULL, 0x000fc800000000ffULL, 0x0174000e35008388ULL, 0x0003e20000000800ULL,
0x000000ff3400720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000f3a0e7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff07ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000f0e0e7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0e0e7820ULL, 0x000fc80000410000ULL, 0x0000000e003b7308ULL, 0x000e640000000800ULL,
0x0000003b10107220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff347819ULL, 0x000fe20000011603ULL, 0x0000cab27f007947ULL, 0x000fea000b800000ULL,
0x00001f343b407589ULL, 0x0002a400000e0000ULL, 0x0000004024247220ULL, 0x084fe40000410000ULL,
0x0000004025257220ULL, 0x080fe40000410000ULL, 0x0000004028287220ULL, 0x080fe40000410000ULL,
0x0000004029297220ULL, 0x000fc40000410000ULL, 0x0000004014147220ULL, 0x080fe40000410000ULL,
0x0000004015157220ULL, 0x080fe40000410000ULL, 0x0000004020207220ULL, 0x080fe40000410000ULL,
0x0000004021217220ULL, 0x080fe40000410000ULL, 0x000000401c1c7220ULL, 0x080fe40000410000ULL,
0x000000401d1d7220ULL, 0x000fc40000410000ULL, 0x0000004030307220ULL, 0x080fe40000410000ULL,
0x0000004031317220ULL, 0x080fe40000410000ULL, 0x000000402c2c7220ULL, 0x080fe40000410000ULL,
0x000000402d2d7220ULL, 0x080fe40000410000ULL, 0x0000004018187220ULL, 0x080fe40000410000ULL,
0x0000004019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0007ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803347811ULL, 0x002fe200078ff0ffULL, 0x0000c9b27f007947ULL, 0x000fea000b800000ULL,
0x00001f343b407589ULL, 0x0002a400000e0000ULL, 0x0000004026267220ULL, 0x084fe40000410000ULL,
0x0000004027277220ULL, 0x080fe40000410000ULL, 0x000000402a2a7220ULL, 0x080fe40000410000ULL,
0x000000402b2b7220ULL, 0x080fe40000410000ULL, 0x0000004016167220ULL, 0x080fe40000410000ULL,
0x0000004017177220ULL, 0x000fc40000410000ULL, 0x0000004022227220ULL, 0x080fe40000410000ULL,
0x0000004023237220ULL, 0x080fe40000410000ULL, 0x000000401e1e7220ULL, 0x080fe40000410000ULL,
0x000000401f1f7220ULL, 0x080fe40000410000ULL, 0x0000004032327220ULL, 0x080fe40000410000ULL,
0x0000004033337220ULL, 0x000fc40000410000ULL, 0x000000402e2e7220ULL, 0x080fe40000410000ULL,
0x000000402f2f7220ULL, 0x080fe40000410000ULL, 0x000000401a1a7220ULL, 0x080fe40000410000ULL,
0x000000401b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff3cff7812ULL, 0x000fe20007806007ULL, 0x00000001ff3b7424ULL, 0x000fe200078e00ffULL,
0x0000000f3a077209ULL, 0x000fd60007810000ULL, 0x800000073a3a0221ULL, 0x000fe20000010000ULL,
0x00007610ff3b0816ULL, 0x000fc6000000003bULL, 0x3fb8aa3b3a3a0820ULL, 0x000fc80000410000ULL,
0x0000003a00080308ULL, 0x000e640000000800ULL, 0x0000000837370220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001037107221ULL, 0x008fc40000010000ULL,
0x00000000000e7805ULL, 0x000fca0000015200ULL, 0x0000000800347824ULL, 0x000fca00078e00ffULL,
0xfffffff0343a7812ULL, 0x000fca00078ec0ffULL, 0x0176ac003a357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff3c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x000000340e377210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e0fULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff347819ULL, 0x000fc80000011435ULL, 0x0000003734347211ULL, 0x000fca00078110ffULL,
0x000000ffff357224ULL, 0x000fca00000e0635ULL, 0x0000000234347819ULL, 0x000fc80000001235ULL,
0x000000340000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000013c3c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac003a357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099103b0e7816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000008ff09723eULL, 0x000fe400000000ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011603ULL, 0x00005410090e7816ULL, 0x000fe20000000009ULL,
0x0000c5827f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0e097589ULL, 0x0002a400000e0000ULL,
0x000000080f347810ULL, 0x000fe20007ffe0ffULL, 0x0000c5d27f007947ULL, 0x000fea000b800000ULL,
0x00001f340e0a7589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x000000100f347810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff357224ULL, 0x000fe200078e000eULL,
0x00007c4000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff427424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0000cdd000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x000000180f347810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff357224ULL, 0x000fe200078e000eULL, 0x00007cb000417802ULL, 0x000fe20000000f00ULL,
0x0000001fff427424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x004fc400078e00ffULL,
0x0000cd6000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100b3c7824ULL, 0x100fe200078e026dULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000100d447824ULL, 0x100fe400078e026dULL, 0x000000100c407824ULL, 0x104fe400078e026dULL,
0x000000003c3c783bULL, 0x000ea20000004200ULL, 0x00000010480c7824ULL, 0x000fc600078e026dULL,
0x000000004444783bULL, 0x000ee80000004200ULL, 0x000000004040783bULL, 0x000e680000004200ULL,
0x000000000c0c783bULL, 0x00ae620000004200ULL, 0x00000018ff6a7819ULL, 0x004fe2000001143cULL,
0x000001003c4e7824ULL, 0x040fe200078e00ffULL, 0x000088803c4f7816ULL, 0x040fe200000000ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe2000001143dULL,
0x000001003e537824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe2000001144eULL,
0x000001003d517824ULL, 0x040fe200078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe2000001143cULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x000088803d4e7816ULL, 0x040fe200000000ffULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe20000011453ULL,
0x0000010046547824ULL, 0x000fe200078e00ffULL, 0x00000018ff377819ULL, 0x000fc4000001143eULL,
0x00000018ff5a7819ULL, 0x000fe2000001143fULL, 0x0000003c00757306ULL, 0x0005e20000200c00ULL,
0x000088803e527816ULL, 0x040fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x000088803f537816ULL, 0x040fe400000000ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x000001003f3c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011451ULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fc40000011444ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003d006c7306ULL, 0x0005e20000200c00ULL,
0x00000018ff3f7819ULL, 0x000fe4000001143fULL, 0x0000888044657816ULL, 0x040fe400000000ffULL,
0x00000018ff4c7819ULL, 0x000fe40000011445ULL, 0x0000888045597816ULL, 0x000fe200000000ffULL,
0x0000003c005d7306ULL, 0x0007e20000200c00ULL, 0x00000100443d7824ULL, 0x044fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe20000011440ULL, 0x0001000044447824ULL, 0x000fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fc40000011441ULL, 0x00000018ff667819ULL, 0x000fe4000001143dULL,
0x0000003e00627306ULL, 0x000fe20000200c00ULL, 0x00000100453c7824ULL, 0x048fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe40000011446ULL, 0x00000018ff5f7819ULL, 0x000fe4000001143cULL,
0x0000003f00677306ULL, 0x0005e20000200c00ULL, 0x00000018ff457819ULL, 0x000fc40000011445ULL,
0x0000888046567816ULL, 0x040fe200000000ffULL, 0x0001000046467824ULL, 0x000fe200078e00ffULL,
0x00000018ff497819ULL, 0x000fe40000011447ULL, 0x0000888047557816ULL, 0x000fe200000000ffULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x012000004b3c783bULL, 0x004ea20000000200ULL,
0x00000018ff467819ULL, 0x000fe40000011446ULL, 0x00000018ff357819ULL, 0x000fe40000011442ULL,
0x00000018ff3a7819ULL, 0x000fc40000011443ULL, 0x0000005100517306ULL, 0x000ee20000200c00ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff137819ULL, 0x002fe4000001140cULL,
0x00000018ff347819ULL, 0x000fe4000001140eULL, 0x00000018ff0b7819ULL, 0x000fe2000001140dULL,
0x00000044005c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff127819ULL, 0x000fce000001140fULL,
0x00000045005b7306ULL, 0x0007e20000200c00ULL, 0x0000010047447824ULL, 0x042fe400078e00ffULL,
0x0001000047477824ULL, 0x000fc600078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000054104e457816ULL, 0x008fe40000000051ULL,
0x00008880404e7816ULL, 0x000fe400000000ffULL, 0x0000888041517816ULL, 0x000fe400000000ffULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x0000004400587306ULL, 0x0003e20000200c00ULL,
0x000000093c3c8232ULL, 0x004fc40000000000ULL, 0x000000093e3e8232ULL, 0x000fe40000000000ULL,
0x0000000a3d3d8232ULL, 0x080fe40000000000ULL, 0x0000000a3f3f8232ULL, 0x000fe20000000000ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x000054104f447816ULL, 0x002fce0000000060ULL,
0x000000443c24723cULL, 0x000be20000001824ULL, 0x0000005200527306ULL, 0x000fec0000200c00ULL,
0x0000010040447824ULL, 0x060fe400078e00ffULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x0000006900697306ULL, 0x000e620000200c00ULL, 0x0000010041457824ULL, 0x040fe200078e00ffULL,
0x00000018ff447819ULL, 0x000fe20000011444ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fc40000011440ULL, 0x00000018ff577819ULL, 0x000fe40000011445ULL,
0x0000005300537306ULL, 0x000ea20000200c00ULL, 0x0000888042457816ULL, 0x000fce00000000ffULL,
0x00000044004f7306ULL, 0x0007e20000200c00ULL, 0x0000541052527816ULL, 0x002fce0000000069ULL,
0x0000004000687306ULL, 0x0003e20000200c00ULL, 0x00000018ff447819ULL, 0x008fe40000011441ULL,
0x000054106c417816ULL, 0x000fe40000000064ULL, 0x0000541053537816ULL, 0x004fc6000000005dULL,
0x0000003700377306ULL, 0x000ea20000200c00ULL, 0x0000541075407816ULL, 0x002fc6000000006aULL,
0x000000523c14723cULL, 0x040be80000001814ULL, 0x0000004400647306ULL, 0x0003e60000200c00ULL,
0x000088800c537816ULL, 0x020fe200000000ffULL, 0x000000403c28723cULL, 0x000b680000001828ULL,
0x0000005a005a7306ULL, 0x000ee20000200c00ULL, 0x0000000703447812ULL, 0x002fc400078ec0ffULL,
0x0000010042407824ULL, 0x020fe400078e00ffULL, 0x0000010043417824ULL, 0x000fe200078e00ffULL,
0x0000000844447812ULL, 0x000fe200078ef803ULL, 0x0001000042427824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000004600607306ULL, 0x000fe20000200c00ULL,
0x00000018ff417819ULL, 0x000fe20000011441ULL, 0x0000000844527824ULL, 0x000fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x000000ffff447224ULL, 0x000fc800078e0053ULL,
0x0000004000467306ULL, 0x0005f00000200c00ULL, 0x00000041004b7306ULL, 0x0003e20000200c00ULL,
0x0000541062407816ULL, 0x004fe40000000037ULL, 0x000000025e377810ULL, 0x000fc80007ffe0ffULL,
0xfffffff852377812ULL, 0x000fe200078ee237ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0000020000417824ULL, 0x002fca00078e00ffULL, 0xfffff80041527812ULL, 0x000fe400078ec0ffULL,
0x0000006600667306ULL, 0x000e620000200c00ULL, 0x0000541067417816ULL, 0x008fe4000000005aULL,
0x0000001037537824ULL, 0x000fca00078e0252ULL, 0x0000005900597306ULL, 0x000ff00000200c00ULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x0000541065527816ULL, 0x002fe40000000066ULL,
0x000088800d657816ULL, 0x000fca00000000ffULL, 0x0000004700617306ULL, 0x0003f00000200c00ULL,
0x0000004200627306ULL, 0x0005e20000200c00ULL, 0x0000888043477816ULL, 0x042fe200000000ffULL,
0x0001000043437824ULL, 0x000fca00078e00ffULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x000001000c427824ULL, 0x044fe400078e00ffULL,
0x000100000c0c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe40000011442ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff0c7819ULL, 0x000fce000001140cULL,
0x0000004a004a7306ULL, 0x000e700000200c00ULL, 0x0000004900497306ULL, 0x000eb00000200c00ULL,
0x0000005600567306ULL, 0x000fe20000200c00ULL, 0x0000541060607816ULL, 0x002fce000000004aULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x0000541061617816ULL, 0x004fce0000000049ULL,
0x0000005500557306ULL, 0x000ea20000200c00ULL, 0x000000603c18723cULL, 0x000fee0000001818ULL,
0x00000043005d7306ULL, 0x0007e20000200c00ULL, 0x0000541056547816ULL, 0x002fce0000000054ULL,
0x0000003b003b7306ULL, 0x000e620000200c00ULL, 0x000000403c40723cULL, 0x048b620000001820ULL,
0x0000541055557816ULL, 0x004fe20000000058ULL, 0x012000005320783bULL, 0x0204ea0000000200ULL,
0x0000004500457306ULL, 0x000e620000200c00ULL, 0x000000543c2c723cULL, 0x000fe2000000182cULL,
0x0000541059537816ULL, 0x004fe2000000005fULL, 0x000001000d5f7824ULL, 0x000fc400078e00ffULL,
0x000100000d0d7824ULL, 0x000fc600078e00ffULL, 0x0000003500357306ULL, 0x000fe20000200c00ULL,
0x0000541068687816ULL, 0x002fe2000000003bULL, 0x000000523c1c723cULL, 0x000be2000000181cULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x00000018ff0d7819ULL, 0x000fe4000001140dULL,
0x0000541045467816ULL, 0x000fe20000000046ULL, 0x0000004e004e7306ULL, 0x000e620000200c00ULL,
0x000054105c527816ULL, 0x020fe4000000004dULL, 0x000054105b537816ULL, 0x000fca000000004cULL,
0x0000000c004c7306ULL, 0x0005e40000200c00ULL, 0x000000523c30723cULL, 0x000b6c0000001830ULL,
0x0000004800487306ULL, 0x000ee20000200c00ULL, 0x000088800e537816ULL, 0x060fe200000000ffULL,
0x000001000e527824ULL, 0x000fe200078e00ffULL, 0x000088800f3e7816ULL, 0x040fe200000000ffULL,
0x000001000f0c7824ULL, 0x044fe200078e00ffULL, 0x000054104e4e7816ULL, 0x002fe2000000004fULL,
0x000100000e0e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe20000011452ULL,
0x000100000f0f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001140cULL,
0x000000ffff4a7224ULL, 0x000fe200078e0053ULL, 0x00000018ff3b7819ULL, 0x000fe2000001140eULL,
0x0000003a003a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff457819ULL, 0x000fe2000001140fULL,
0x0000000920208232ULL, 0x088fe20000000000ULL, 0x00005410620c7816ULL, 0x000fe20000000035ULL,
0x0000000922228232ULL, 0x000fe20000000000ULL, 0x0000541064697816ULL, 0x000fe20000000048ULL,
0x0000000a21218232ULL, 0x000fc40000000000ULL, 0x0000004a003c7306ULL, 0x000fe20000200c00ULL,
0x0000000a23238232ULL, 0x000fce0000000000ULL, 0x0000003d003d7306ULL, 0x000e620000200c00ULL,
0x000000682028723cULL, 0x000f6e0000001828ULL, 0x0000001300137306ULL, 0x000eb00000200c00ULL,
0x0000000b000b7306ULL, 0x000fe20000200c00ULL, 0x000054103c3c7816ULL, 0x002fce000000003dULL,
0x0000003400347306ULL, 0x000fe20000200c00ULL, 0x000054104c4c7816ULL, 0x004fce0000000013ULL,
0x0000001200127306ULL, 0x000ff00000200c00ULL, 0x0000005100517306ULL, 0x000ff00000200c00ULL,
0x0000005700577306ULL, 0x000e700000200c00ULL, 0x0000004700477306ULL, 0x000eb00000200c00ULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x00005410514f7816ULL, 0x002fce0000000057ULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x0000541047477816ULL, 0x004fe2000000004bULL,
0x0000004e2024723cULL, 0x040f6c0000001824ULL, 0x0000006500597306ULL, 0x000fe40000200c00ULL,
0x000000462014723cULL, 0x000f6c0000001814ULL, 0x0000005f005f7306ULL, 0x000fe20000200c00ULL,
0x0000541044447816ULL, 0x002fce000000005aULL, 0x0000000d004d7306ULL, 0x0002b00000200c00ULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x000054105d0d7816ULL, 0x002fce000000003aULL,
0x0000003f003f7306ULL, 0x000e620000200c00ULL, 0x000054104d4d7816ULL, 0x004fe2000000000bULL,
0x0000000c200c723cULL, 0x000f620000001840ULL, 0x00017698720b7811ULL, 0x000fca00078e18ffULL,
0x0000003b003b7306ULL, 0x000ea40000200c00ULL, 0x0000004c2030723cULL, 0x000f6c0000001830ULL,
0x0000004500357306ULL, 0x0006e20000200c00ULL, 0x000054103e3d7816ULL, 0x002fe4000000003fULL,
0x000054103b347816ULL, 0x004fca0000000034ULL, 0x0000003c202c723cULL, 0x000f62000000182cULL,
0x0000541059457816ULL, 0x008fe4000000005fULL, 0x0000541035357816ULL, 0x000fca0000000012ULL,
0x00000044201c723cULL, 0x040f70000000181cULL, 0x000000342018723cULL, 0x000b6e0000001818ULL,
0x000176c86b227811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000022227f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000bff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff347224ULL, 0x000fc600078e00ffULL,
0x0000000000127805ULL, 0x000fc80000015200ULL, 0x00000400060b7984ULL, 0x004ea40000000800ULL,
0x800000000bff7812ULL, 0x006fc40007804823ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x0000002012207210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e13ULL, 0x003d09002000780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402000780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011421ULL,
0x000000200b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff207224ULL, 0x000fca00000e0621ULL,
0x000000020b0b7819ULL, 0x000fc80000001220ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400060b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804823ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000001050b7810ULL, 0x000fc80007ffe0ffULL, 0x0000006e0b00720cULL, 0x000fda0003f06070ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x00000002050b7810ULL, 0x000fe20007ffe0ffULL,
0x0000590002067a24ULL, 0x010fe200078e02ffULL, 0x0000010036367810ULL, 0x000fe40007ffe0ffULL,
0x0000006e0b00720cULL, 0x000fe20003f06070ULL, 0x0000008006067824ULL, 0x000fe200078e00ffULL,
0x0000006036127812ULL, 0x000fca00078ec0ffULL, 0x000000016f137824ULL, 0x000fcc00078e0212ULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x00000036630b7217ULL, 0x000fe20007800000ULL,
0x0000001000127824ULL, 0x000fe200078e00ffULL, 0x00000003ff207819ULL, 0x000fc60000011603ULL,
0x000000010b0b7824ULL, 0x000fe200078e0a36ULL, 0x0000001012127812ULL, 0x000fe400078ec0ffULL,
0x0000000420217810ULL, 0x000fe40007ffe0ffULL, 0x0000000b120b7217ULL, 0x000fe40007800000ULL,
0x0000000820227810ULL, 0x040fe20007ffe0ffULL, 0x0000000121347824ULL, 0x100fe200078e0212ULL,
0x0000000c20237810ULL, 0x000fe20007ffe0ffULL, 0x000000010b0b7824ULL, 0x000fc400078e0a12ULL,
0x00000001223c7824ULL, 0x100fe400078e0212ULL, 0x0000000834357824ULL, 0x000fe200078e00ffULL,
0x0000000b2200720cULL, 0x080fe20003f46070ULL, 0x0000000134227824ULL, 0x000fe200078e0203ULL,
0x0000000b2000720cULL, 0x0c0fe20003f86070ULL, 0x0000000120207824ULL, 0x100fe200078e0212ULL,
0x0000000b2100720cULL, 0x080fe20003f66070ULL, 0x00000001233e7824ULL, 0x000fe200078e0212ULL,
0xfffffff8353a7812ULL, 0x000fe200078ee222ULL, 0x0000000120227824ULL, 0x040fe200078e0213ULL,
0x0000000b2300720cULL, 0x000fe20003f06070ULL, 0x0000000120217824ULL, 0x000fc400078e0203ULL,
0x0000000820367824ULL, 0x000fe400078e00ffULL, 0x0000000134347824ULL, 0x100fe400078e0213ULL,
0x000000013c127824ULL, 0x000fe200078e0213ULL, 0xfffffff836367812ULL, 0x000fe200078ee221ULL,
0x000000013c0b7824ULL, 0x040fe400078e0203ULL, 0x000000083c3c7824ULL, 0x000fe400078e00ffULL,
0x000000013e207824ULL, 0x000fc400078e0213ULL, 0x000000013e137824ULL, 0x000fe200078e0203ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20bULL, 0x000000083e3e7824ULL, 0x000fe200078e00ffULL,
0x00006200060b7a11ULL, 0x000fe200078a38ffULL, 0x0000008022227825ULL, 0x000fc600078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee213ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000005022227212ULL, 0x080fe400078efcffULL, 0x00006300063b7a11ULL, 0x000fe200028f3cffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000005034347212ULL, 0x000fe400078efcffULL,
0x000000220b227210ULL, 0x000fe20007fbe0ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000000b34347210ULL, 0x000fc40007fde0ffULL, 0x0000005012127212ULL, 0x080fe200078efcffULL,
0x0000000123237824ULL, 0x100fe200028e063bULL, 0x0000005020207212ULL, 0x000fe200078efcffULL,
0x0000000135357824ULL, 0x000fe200030e063bULL, 0x0000000b12127210ULL, 0x080fe20007fbe0ffULL,
0x000000103a3d7824ULL, 0x100fe200078e026dULL, 0x0000000b20207210ULL, 0x000fe20007fde0ffULL,
0x00000010360b7824ULL, 0x100fe400078e026dULL, 0x000000103c3f7824ULL, 0x000fe400078e026dULL,
0x0000000113137824ULL, 0x000fe200028e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000220b7faeULL, 0x0003e2000e101c48ULL, 0x000000103e6d7824ULL, 0x000fc400078e026dULL,
0x0000000121217824ULL, 0x000fe200030e063bULL, 0x00000000343d7faeULL, 0x0003e8000d901c48ULL,
0x00000000123f7faeULL, 0x0003e8000d101c48ULL, 0x00000000206d7faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x00000010000b7824ULL, 0x000fca00078e00ffULL,
0x000000100b127812ULL, 0x000fc800078ec0ffULL, 0x0000001203207211ULL, 0x000fc800078fe8ffULL,
0x0000000420227810ULL, 0x040fe20007ffe0ffULL, 0x00000001200b7824ULL, 0x040fe200078e0203ULL,
0x00000008203a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000820367824ULL, 0x040fe200078e00ffULL,
0x0000000c203c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000120127824ULL, 0x100fe400078e0213ULL,
0x0000000122207824ULL, 0x000fe200078e0213ULL, 0xfffffff836367812ULL, 0x000fe200078ee20bULL,
0x00000001220b7824ULL, 0x040fe400078e0203ULL, 0x00000008223e7824ULL, 0x000fc400078e00ffULL,
0x000000013a227824ULL, 0x100fe400078e0213ULL, 0x000000013c347824ULL, 0x000fe400078e0213ULL,
0x000000013a217824ULL, 0x040fe400078e0203ULL, 0x000000083a407824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3a7812ULL, 0x000fe200078ee20bULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x00006200060b7a11ULL, 0x000fc600078038ffULL, 0x000000013c237824ULL, 0x000fe200078e0203ULL,
0x0000005012127212ULL, 0x000fe200078efcffULL, 0x000000083c427824ULL, 0x000fe200078e00ffULL,
0xfffffff8403c7812ULL, 0x000fe200078ee221ULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x00006300063b7a11ULL, 0x000fe400000f3cffULL, 0xfffffff8423e7812ULL, 0x000fe200078ee223ULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x000000120b127210ULL, 0x000fe40007f1e0ffULL,
0x0000005020207212ULL, 0x080fe200078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000005022227212ULL, 0x000fc600078efcffULL, 0x0000000113137824ULL, 0x000fe200000e063bULL,
0x0000005034347212ULL, 0x000fe200078efcffULL, 0x000000103a3d7824ULL, 0x100fe200078e026dULL,
0x000000200b207210ULL, 0x040fe20007f1e0ffULL, 0x000000103c3f7824ULL, 0x100fe200078e026dULL,
0x000000220b227210ULL, 0x040fe40007f5e0ffULL, 0x000000340b347210ULL, 0x000fe20007f7e0ffULL,
0x00000010360b7824ULL, 0x000fe400078e026dULL, 0x0000000121217824ULL, 0x000fc400000e063bULL,
0x0000000123237824ULL, 0x000fe200010e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120b7faeULL, 0x0003e2000b901c48ULL, 0x000000103e6d7824ULL, 0x000fe400078e026dULL,
0x0000000135357824ULL, 0x000fe200018e063bULL, 0x00000000203d7faeULL, 0x0003e8000b901c48ULL,
0x00000000223f7faeULL, 0x0003e8000b901c48ULL, 0x00000000346d7faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000106b0b7824ULL, 0x000fc400078e00ffULL,
0x0000000800067824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a04ULL,
0x000000100b0b7812ULL, 0x000fe400078ee2ffULL, 0x0000000806067812ULL, 0x000fc600078ec0ffULL,
0x00000020720b7824ULL, 0x000fc800078e020bULL, 0x0000000106067824ULL, 0x000fe200078e020bULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff127f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176680006227f8cULL, 0x0004e2000c80043fULL, 0x000000ffff0b7224ULL, 0x002fc600078e0013ULL,
0x0000000000127805ULL, 0x000fc80000015200ULL, 0x01766c0006217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x00afe40007804823ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff347224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x0000002012357210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e13ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff207819ULL, 0x000fc80000011421ULL, 0x0000003520207211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0621ULL, 0x0000000220207819ULL, 0x000fc80000001221ULL,
0x000000200000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000134347810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01766c0006217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe40007804823ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018072067811ULL, 0x004fc800078e38ffULL,
0x0000000673067210ULL, 0x000fca0007ffe050ULL, 0x0170000006207984ULL, 0x000e680000000800ULL,
0x0172000006137984ULL, 0x0004e20000000800ULL, 0x000000072000720bULL, 0x002fe20003f1d000ULL,
0x0000a7927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000407806ULL, 0x004fc800000e0100ULL,
0x0000ffff40237812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff227424ULL, 0x000fe400078e00ffULL, 0x000000ffff127224ULL, 0x000fd200078e0007ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x0000000372217810ULL, 0x000fe40007ffe0ffULL,
0x000000072000720bULL, 0x000fe40003f54000ULL, 0x000000002100720cULL, 0x000fe20003f05270ULL,
0x0000a7427f007947ULL, 0x000fd4000b800000ULL, 0x0000000000067806ULL, 0x000fc400010e0100ULL,
0x0000008000508824ULL, 0x000fe200078e0250ULL, 0x0000000720128209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991006217816ULL, 0x000fe200000000ffULL,
0x0000000173738824ULL, 0x000fca00078e0250ULL, 0x0174001273008388ULL, 0x0003e20000000800ULL,
0x000000ff2100720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000720127209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff06ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000712127221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b12127820ULL, 0x000fc80000410000ULL, 0x0000001200217308ULL, 0x000e640000000800ULL,
0x0000002110107220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff347819ULL, 0x000fe20000011603ULL, 0x0000a6727f007947ULL, 0x000fea000b800000ULL,
0x00001f3421407589ULL, 0x0002a400000e0000ULL, 0x0000004024247220ULL, 0x084fe40000410000ULL,
0x0000004025257220ULL, 0x080fe40000410000ULL, 0x0000004028287220ULL, 0x080fe40000410000ULL,
0x0000004029297220ULL, 0x000fc40000410000ULL, 0x0000004014147220ULL, 0x080fe40000410000ULL,
0x0000004015157220ULL, 0x080fe40000410000ULL, 0x000000400c0c7220ULL, 0x080fe40000410000ULL,
0x000000400d0d7220ULL, 0x080fe40000410000ULL, 0x000000401c1c7220ULL, 0x080fe40000410000ULL,
0x000000401d1d7220ULL, 0x000fc40000410000ULL, 0x0000004030307220ULL, 0x080fe40000410000ULL,
0x0000004031317220ULL, 0x080fe40000410000ULL, 0x000000402c2c7220ULL, 0x080fe40000410000ULL,
0x000000402d2d7220ULL, 0x080fe40000410000ULL, 0x0000004018187220ULL, 0x080fe40000410000ULL,
0x0000004019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0006ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000803347811ULL, 0x002fe200078ff0ffULL, 0x0000a5727f007947ULL, 0x000fea000b800000ULL,
0x00001f3421407589ULL, 0x0002a400000e0000ULL, 0x0000004026267220ULL, 0x084fe40000410000ULL,
0x0000004027277220ULL, 0x080fe40000410000ULL, 0x000000402a2a7220ULL, 0x080fe40000410000ULL,
0x000000402b2b7220ULL, 0x080fe40000410000ULL, 0x0000004016167220ULL, 0x080fe40000410000ULL,
0x0000004017177220ULL, 0x000fc40000410000ULL, 0x000000400e0e7220ULL, 0x080fe40000410000ULL,
0x000000400f0f7220ULL, 0x080fe40000410000ULL, 0x000000401e1e7220ULL, 0x080fe40000410000ULL,
0x000000401f1f7220ULL, 0x080fe40000410000ULL, 0x0000004032327220ULL, 0x080fe40000410000ULL,
0x0000004033337220ULL, 0x000fc40000410000ULL, 0x000000402e2e7220ULL, 0x080fe40000410000ULL,
0x000000402f2f7220ULL, 0x080fe40000410000ULL, 0x000000401a1a7220ULL, 0x080fe40000410000ULL,
0x000000401b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff23ff7812ULL, 0x000fe20007806006ULL, 0x00000001ff227424ULL, 0x000fe200078e00ffULL,
0x0000000720127209ULL, 0x000fd60007810000ULL, 0x8000001220200221ULL, 0x000fe20000010000ULL,
0x00007610ff220816ULL, 0x000fc60000000022ULL, 0x3fb8aa3b20200820ULL, 0x000fc80000410000ULL,
0x0000002000080308ULL, 0x000e640000000800ULL, 0x0000000813130220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001013107221ULL, 0x008fc40000010000ULL,
0x0000000000067805ULL, 0x000fca0000015200ULL, 0x00000c04ff137984ULL, 0x000e620008000800ULL,
0x0000000400207824ULL, 0x000fe400078e00ffULL, 0x000000ffff347224ULL, 0x000fc600078e00ffULL,
0x0000000420207812ULL, 0x000fc800078ec0ffULL, 0x0000000220237810ULL, 0x000fe40007ffe0ffULL,
0x8000000013ff7812ULL, 0x002fe20007804839ULL, 0x0000000476137824ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x0000002006357210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e07ULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff207819ULL, 0x000fc80000011421ULL,
0x0000003520207211ULL, 0x000fca00078110ffULL, 0x000000ffff217224ULL, 0x000fca00000e0621ULL,
0x0000000220207819ULL, 0x000fc80000001221ULL, 0x000000200000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00000c04ff217984ULL, 0x000e640008000800ULL,
0x8000000021ff7812ULL, 0x002fe40007804839ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991022067816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff0600720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000008ff06723eULL, 0x000fe400000000ffULL,
0x00000002ff077819ULL, 0x000fe40000011603ULL, 0x0000541006067816ULL, 0x000fe20000000006ULL,
0x0000a1027f007947ULL, 0x000fea000b800000ULL, 0x00001f0706097589ULL, 0x0002a400000e0000ULL,
0x0000000807347810ULL, 0x000fe20007ffe0ffULL, 0x0000a1527f007947ULL, 0x000fea000b800000ULL,
0x00001f34060a7589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001007347810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff357224ULL, 0x000fe200078e0006ULL,
0x0000a32000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff427424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0000a6f000007944ULL, 0x016fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001807347810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff357224ULL, 0x000fe200078e0006ULL, 0x0000a39000417802ULL, 0x000fe20000000f00ULL,
0x0000001fff427424ULL, 0x000fc400078e00ffULL, 0xffffffffff407424ULL, 0x004fc400078e00ffULL,
0x0000a68000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000703227812ULL, 0x040fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000003724b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000822067812ULL, 0x00afe400078ef803ULL,
0x0000000803217812ULL, 0x000fe200078ec0ffULL, 0x000008004b4b7824ULL, 0x000fe400078e00ffULL,
0x0000000806077824ULL, 0x000fca00078e00ffULL, 0xfffffff8074c7812ULL, 0x000fca00078ee25eULL,
0x000000104c4c7824ULL, 0x000fc400078e024bULL, 0x0000001303137211ULL, 0x000fe400078fe0ffULL,
0x0000002221207212ULL, 0x000fe400078efcffULL, 0x0000002303237211ULL, 0x000fe400078fe0ffULL,
0x0000001021347812ULL, 0x000fe200078efe22ULL, 0x0000000120067824ULL, 0x040fe400078e0213ULL,
0x0000000820077824ULL, 0x000fe400078e00ffULL, 0x0000000834227824ULL, 0x000fc600078e00ffULL,
0xfffffff807067812ULL, 0x000fe200078ee206ULL, 0x0000000120077824ULL, 0x040fe400078e0223ULL,
0x0000000820207824ULL, 0x000fe400078e00ffULL, 0x0000001006067824ULL, 0x000fc600078e0211ULL,
0xfffffff820207812ULL, 0x000fe200078ee207ULL, 0x0000000134077824ULL, 0x000fe200078e0213ULL,
0x00000000063c783bULL, 0x0002e60000004200ULL, 0x0000001020207824ULL, 0x000fe200078e0211ULL,
0xfffffff822227812ULL, 0x000fe200078ee207ULL, 0x0000000834077824ULL, 0x000fc600078e00ffULL,
0x000000002040783bULL, 0x004ea20000004200ULL, 0x0000001022227824ULL, 0x000fe400078e0211ULL,
0x0000000134067824ULL, 0x002fc600078e0223ULL, 0x000000002238783bULL, 0x000e640000004200ULL,
0xfffffff807067812ULL, 0x000fca00078ee206ULL, 0x0000001006067824ULL, 0x000fca00078e0211ULL,
0x000000000620783bULL, 0x000e620000004200ULL, 0x000001003c477824ULL, 0x048fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fe2000001143cULL, 0x000001003d487824ULL, 0x040fe200078e00ffULL,
0x000088803c6c7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe20000011447ULL, 0x000001003e497824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe2000001143dULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x000088803d477816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc4000001143cULL, 0x00000018ff547819ULL, 0x000fe4000001143eULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000003c006a7306ULL, 0x0007e20000200c00ULL,
0x00000018ff557819ULL, 0x000fe4000001143fULL, 0x000088803e647816ULL, 0x040fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x000088803f627816ULL, 0x040fe400000000ffULL,
0x00000018ff507819ULL, 0x004fe20000011440ULL, 0x0000003d00697306ULL, 0x0005e20000200c00ULL,
0x000001003f3c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fc40000011441ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x00000100403d7824ULL, 0x044fe200078e00ffULL, 0x0000003c00667306ULL, 0x0005e20000200c00ULL,
0x00008880405b7816ULL, 0x040fe200000000ffULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00008880415a7816ULL, 0x040fe400000000ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x0000003e00617306ULL, 0x000fe20000200c00ULL,
0x00000100413c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fe20000011449ULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fc40000011440ULL,
0x00000018ff3c7819ULL, 0x000fe4000001143cULL, 0x0000003d005c7306ULL, 0x0005e20000200c00ULL,
0x00000018ff417819ULL, 0x000fe40000011441ULL, 0x00000018ff367819ULL, 0x002fe40000011438ULL,
0x00000018ff447819ULL, 0x000fe40000011439ULL, 0x00008880394a7816ULL, 0x000fe200000000ffULL,
0x0000003c005d7306ULL, 0x0003e20000200c00ULL, 0x00000100423d7824ULL, 0x004fe200078e00ffULL,
0x00000018ff457819ULL, 0x000fc40000011442ULL, 0x0000888042537816ULL, 0x040fe200000000ffULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000003f00577306ULL, 0x000fe20000200c00ULL, 0x00000100433c7824ULL, 0x002fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff467819ULL, 0x000fe40000011443ULL,
0x00000018ff567819ULL, 0x000fc4000001143cULL, 0x0000003d00527306ULL, 0x0003e20000200c00ULL,
0x0000888043517816ULL, 0x040fe200000000ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff347819ULL, 0x000fe4000001143aULL, 0x00000018ff357819ULL, 0x000fe4000001143bULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x011000004c3c783bULL, 0x002e620000000200ULL, 0x00000018ff067819ULL, 0x000fc40000011422ULL,
0x00000018ff117819ULL, 0x000fe40000011420ULL, 0x00000018ff137819ULL, 0x000fe40000011421ULL,
0x0000006d006d7306ULL, 0x000ea20000200c00ULL, 0x00000018ff077819ULL, 0x000fce0000011423ULL,
0x0000004700477306ULL, 0x000ff00000200c00ULL, 0x00000048005e7306ULL, 0x000ef00000200c00ULL,
0x0000004900657306ULL, 0x0003f00000200c00ULL, 0x0000004000597306ULL, 0x0005e20000200c00ULL,
0x0000888038497816ULL, 0x002fe200000000ffULL, 0x000000093c3c8232ULL, 0x000fc40000000000ULL,
0x000000093e3e8232ULL, 0x000fe40000000000ULL, 0x0000000a3d3d8232ULL, 0x080fe40000000000ULL,
0x0000004100587306ULL, 0x0003e20000200c00ULL, 0x0000010038407824ULL, 0x044fe200078e00ffULL,
0x0000000a3f3f8232ULL, 0x000fe20000000000ULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0000010039417824ULL, 0x042fe200078e00ffULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff417819ULL, 0x000fe40000011441ULL,
0x00000018ff397819ULL, 0x000fe40000011439ULL, 0x0000003800607306ULL, 0x0005f00000200c00ULL,
0x00000039005f7306ULL, 0x0007e20000200c00ULL, 0x000054106c387816ULL, 0x004fce000000006dULL,
0x0000006400647306ULL, 0x000ea20000200c00ULL, 0x0000541047397816ULL, 0x008fce000000005eULL,
0x000000383c24723cULL, 0x000b620000001824ULL, 0x0000006200627306ULL, 0x000eec0000200c00ULL,
0x000001003b387824ULL, 0x020fe200078e00ffULL, 0x0000541069397816ULL, 0x002fe20000000067ULL,
0x00000042004d7306ULL, 0x0003e60000200c00ULL, 0x00000018ff387819ULL, 0x000fca0000011438ULL,
0x0000004000487306ULL, 0x0005e20000200c00ULL, 0x000001003a427824ULL, 0x002fce00078e00ffULL,
0x0000003800477306ULL, 0x0003e20000200c00ULL, 0x000088803a407816ULL, 0x044fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe2000001143aULL,
0x00000043004e7306ULL, 0x0005e20000200c00ULL, 0x000054106a387816ULL, 0x002fe40000000068ULL,
0x00008880203a7816ULL, 0x000fca00000000ffULL, 0x0000005400547306ULL, 0x000e620000200c00ULL,
0x000088803b437816ULL, 0x044fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x000000383c28723cULL, 0x000be20000001828ULL, 0x000000ffff677224ULL, 0x000fe400078e003aULL,
0x00000010373a7824ULL, 0x000fe200078e024bULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x0000005500557306ULL, 0x000ea20000200c00ULL, 0x00000100204b7824ULL, 0x000fe200078e00ffULL,
0x0000541064387816ULL, 0x020fc40000000065ULL, 0x0000541062397816ULL, 0x008fe40000000066ULL,
0x0000888021627816ULL, 0x000fe400000000ffULL, 0x0000005b005b7306ULL, 0x000ee20000200c00ULL,
0x0000541061547816ULL, 0x002fe20000000054ULL, 0x0000010021617824ULL, 0x000fe200078e00ffULL,
0x000000383c14723cULL, 0x000f620000001814ULL, 0x00000018ff4b7819ULL, 0x000fc6000001144bULL,
0x00000018ff617819ULL, 0x000fe20000011461ULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x0000541057557816ULL, 0x004fe20000000055ULL, 0x000000ffff577224ULL, 0x000fcc00078e0062ULL,
0x00000041004c7306ULL, 0x0005e20000200c00ULL, 0x000000543c0c723cULL, 0x000b6e000000180cULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x00000018ff417819ULL, 0x004fe40000011442ULL,
0x000054105b547816ULL, 0x028fc4000000005cULL, 0x000054105a557816ULL, 0x002fe2000000005dULL,
0x00010000205a7824ULL, 0x000fe400078e00ffULL, 0x0000003b00427306ULL, 0x0003e60000200c00ULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x000000543c1c723cULL, 0x000b68000000181cULL,
0x0000005300537306ULL, 0x000ea20000200c00ULL, 0x011000003a38783bULL, 0x002e640000000200ULL,
0x0000541059547816ULL, 0x020fca0000000050ULL, 0x0000005100517306ULL, 0x000ff00000200c00ULL,
0x0000005600567306ULL, 0x000ee20000200c00ULL, 0x0000541053507816ULL, 0x004fe40000000052ULL,
0x0000888022527816ULL, 0x000fca00000000ffULL, 0x0000004f004f7306ULL, 0x000eb00000200c00ULL,
0x0000004500457306ULL, 0x000e620000200c00ULL, 0x0000541051517816ULL, 0x008fce0000000056ULL,
0x0000004600467306ULL, 0x000ee20000200c00ULL, 0x000000503c2c723cULL, 0x040be2000000182cULL,
0x0000541058557816ULL, 0x004fe2000000004fULL, 0x0000000938388232ULL, 0x082fe20000000000ULL,
0x00010000214f7824ULL, 0x000fe200078e00ffULL, 0x000000093a3a8232ULL, 0x000fe40000000000ULL,
0x0000000a39398232ULL, 0x080fe20000000000ULL, 0x0000004900497306ULL, 0x000e620000200c00ULL,
0x000054104d507816ULL, 0x020fe20000000045ULL, 0x000000543c30723cULL, 0x000f620000001830ULL,
0x0000000a3b3b8232ULL, 0x000fe20000000000ULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x000000ffff457224ULL, 0x000fc600078e0052ULL, 0x0000004a004a7306ULL, 0x000ea20000200c00ULL,
0x000054104e517816ULL, 0x008fce0000000046ULL, 0x0000004000407306ULL, 0x000fe20000200c00ULL,
0x000000503c18723cULL, 0x000b620000001818ULL, 0x0000541049487816ULL, 0x002fcc0000000048ULL,
0x0000004100417306ULL, 0x000e620000200c00ULL, 0x00000100223c7824ULL, 0x020fe200078e00ffULL,
0x000054104a497816ULL, 0x004fe2000000004cULL, 0x0001000022227824ULL, 0x000fe200078e00ffULL,
0x00008880233d7816ULL, 0x000fe400000000ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000004300437306ULL, 0x000ea20000200c00ULL, 0x000000483824723cULL, 0x000b620000001824ULL,
0x00000018ff227819ULL, 0x000fcc0000011422ULL, 0x0000003600367306ULL, 0x000ee20000200c00ULL,
0x0000541040407816ULL, 0x002fe20000000041ULL, 0x000000ffff487224ULL, 0x020fe400078e003dULL,
0x00000100233d7824ULL, 0x000fe200078e00ffULL, 0x0000541043417816ULL, 0x004fc60000000047ULL,
0x0000003c00467306ULL, 0x0003e80000200c00ULL, 0x000000403814723cULL, 0x000b620000001814ULL,
0x0000541060607816ULL, 0x008fc60000000036ULL, 0x0000003400347306ULL, 0x000fe20000200c00ULL,
0x00010000233c7824ULL, 0x002fe200078e00ffULL, 0x00000018ff367819ULL, 0x000fc8000001143dULL,
0x00000018ff407819ULL, 0x020fe4000001143cULL, 0x0000003500357306ULL, 0x000e700000200c00ULL,
0x0000005e005e7306ULL, 0x000eb00000200c00ULL, 0x0000004400447306ULL, 0x000fe20000200c00ULL,
0x0000541042357816ULL, 0x002fce0000000035ULL, 0x0000001100117306ULL, 0x000fe20000200c00ULL,
0x000054105e347816ULL, 0x004fce0000000034ULL, 0x0000001300137306ULL, 0x000fe20000200c00ULL,
0x00000034383c723cULL, 0x000b6e000000180cULL, 0x0000006700377306ULL, 0x000fe20000200c00ULL,
0x000000046b0c7810ULL, 0x020fce0007ffe0ffULL, 0x0000004b004b7306ULL, 0x000e700000200c00ULL,
0x0000005700577306ULL, 0x000ff00000200c00ULL, 0x0000006100207306ULL, 0x0004e20000200c00ULL,
0x0000541037567816ULL, 0x002fce000000004bULL, 0x0000005a00217306ULL, 0x000e620000200c00ULL,
0x000054105f617816ULL, 0x004fce0000000044ULL, 0x0000004f004f7306ULL, 0x000ea20000200c00ULL,
0x0000541057577816ULL, 0x008fe20000000020ULL, 0x000000603828723cULL, 0x040f6c0000001828ULL,
0x0000004500457306ULL, 0x000ee20000200c00ULL, 0x00005410214e7816ULL, 0x002fe20000000011ULL,
0x00000056381c723cULL, 0x000f6c000000181cULL, 0x0000004800487306ULL, 0x000fe20000200c00ULL,
0x000054104f4f7816ULL, 0x004fce0000000013ULL, 0x0000003600497306ULL, 0x000e620000200c00ULL,
0x0000541045467816ULL, 0x008fe20000000046ULL, 0x0000004e3830723cULL, 0x000f6c0000001830ULL,
0x0000000600067306ULL, 0x000ff00000200c00ULL, 0x0000000700077306ULL, 0x000fe20000200c00ULL,
0x0000541048477816ULL, 0x002fce0000000049ULL, 0x0000002200237306ULL, 0x000e620000200c00ULL,
0x00000046382c723cULL, 0x000f6e000000182cULL, 0x0000004000407306ULL, 0x000ea20000200c00ULL,
0x0000541023067816ULL, 0x002fe40000000006ULL, 0x0000541040077816ULL, 0x004fce0000000007ULL,
0x000000063838723cULL, 0x000b6e0000001818ULL, 0x000176a80c067811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fcc0000008000ULL, 0x0000000006067f8cULL, 0x000e62000c80043fULL,
0x0000000105057810ULL, 0x000fe40007ffe0ffULL, 0x000176a0720c7811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000cff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff0e7224ULL, 0x002fe200078e0007ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff617000007947ULL, 0x000fea000383ffffULL, 0x000000ff6e00720cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0180000010007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000b56000047802ULL, 0x000fc40000000f00ULL, 0x000092f000007944ULL, 0x016fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001000037308ULL, 0x000ee40000001000ULL,
0xbf80000003007423ULL, 0x008fc80000000010ULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x010fca00078e00ffULL,
0x0000000802037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000047919ULL, 0x000ea80000000000ULL,
0x0000000000077919ULL, 0x004ea20000000000ULL, 0x00000002ff067819ULL, 0x000fe40000011604ULL,
0x0000000807047811ULL, 0x004fe200078ff0ffULL, 0x0000000003057220ULL, 0x008fca0000410000ULL,
0x00001f0605007589ULL, 0x000ea800000e0000ULL, 0x00001f0405047589ULL, 0x000ee200000e0000ULL,
0x0000002400247220ULL, 0x044fe40000410000ULL, 0x0000002500257220ULL, 0x040fe40000410000ULL,
0x0000002800287220ULL, 0x040fe40000410000ULL, 0x0000002900297220ULL, 0x000fc40000410000ULL,
0x0000001400147220ULL, 0x040fe40000410000ULL, 0x0000001500157220ULL, 0x040fe40000410000ULL,
0x0000003c003c7220ULL, 0x040fe40000410000ULL, 0x0000003d003d7220ULL, 0x040fe40000410000ULL,
0x0000001c001c7220ULL, 0x040fe40000410000ULL, 0x0000001d001d7220ULL, 0x000fc40000410000ULL,
0x0000003000307220ULL, 0x040fe40000410000ULL, 0x0000003100317220ULL, 0x040fe40000410000ULL,
0x0000002c002c7220ULL, 0x040fe40000410000ULL, 0x0000002d002d7220ULL, 0x040fe40000410000ULL,
0x0000003800387220ULL, 0x040fe40000410000ULL, 0x0000003900397220ULL, 0x000fc40000410000ULL,
0x0000002604267220ULL, 0x048fe40000410000ULL, 0x0000002704277220ULL, 0x040fe40000410000ULL,
0x0000002a042a7220ULL, 0x040fe40000410000ULL, 0x0000002b042b7220ULL, 0x040fe40000410000ULL,
0x0000001604167220ULL, 0x040fe40000410000ULL, 0x0000001704177220ULL, 0x000fc40000410000ULL,
0x0000003e043e7220ULL, 0x040fe40000410000ULL, 0x0000003f043f7220ULL, 0x040fe40000410000ULL,
0x0000001e041e7220ULL, 0x040fe40000410000ULL, 0x0000001f041f7220ULL, 0x040fe40000410000ULL,
0x0000003204327220ULL, 0x040fe40000410000ULL, 0x0000003304337220ULL, 0x000fc40000410000ULL,
0x0000002e042e7220ULL, 0x040fe40000410000ULL, 0x0000002f042f7220ULL, 0x040fe40000410000ULL,
0x0000003a043a7220ULL, 0x040fe40000410000ULL, 0x0000003b043b7220ULL, 0x000fc40000410000ULL,
0x0000000000027919ULL, 0x010ee20000000000ULL, 0x000000303130723eULL, 0x000fe400000000ffULL,
0x0000002c2d2c723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000383938723eULL, 0x000fc400000000ffULL, 0x000000161716723eULL, 0x000fe400000000ffULL,
0x0000001e1f1e723eULL, 0x000fe400000000ffULL, 0x0000002e2f2e723eULL, 0x000fe400000000ffULL,
0x0000003a3b17723eULL, 0x000fe400000000ffULL, 0x000000ff6b00720cULL, 0x000fe40003f05270ULL,
0x00000002ff057819ULL, 0x108fe20000011602ULL, 0x0000000179797824ULL, 0x000fe200078e0202ULL,
0x0000000202007812ULL, 0x000fc400078ec0ffULL, 0x0000000802077811ULL, 0x004fe200078ff0ffULL,
0x00000008050c7824ULL, 0x000fe200078e00ffULL, 0x0000000500037211ULL, 0x040fe400078ff8ffULL,
0x0000000700047211ULL, 0x000fe200078ff8ffULL, 0x0000000807097824ULL, 0x000fe200078e00ffULL,
0x0000000203007810ULL, 0x000fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0x0000000403067810ULL, 0x000fe40007ffe0ffULL, 0xfffffff8090e7812ULL, 0x000fe200078ee204ULL,
0x0000000805047824ULL, 0x000fe200078e00ffULL, 0xfffffff807087812ULL, 0x000fe200078ee200ULL,
0x0000000805097824ULL, 0x000fe200078e00ffULL, 0x0000000603077810ULL, 0x000fe20007ffe0ffULL,
0x0000100076007824ULL, 0x000fe200078e00ffULL, 0xfffffff804047812ULL, 0x000fe200078ee203ULL,
0x0000000802057824ULL, 0x000fe200078e00ffULL, 0xfffffff8090a7812ULL, 0x002fe200078ee206ULL,
0x000008006b037824ULL, 0x100fe200078e0200ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x0000001079797824ULL, 0x000fe200078e0200ULL, 0x0000000805067812ULL, 0x000fe200078ec0ffULL,
0x0000001004057824ULL, 0x100fe200078e0203ULL, 0x000000282904723eULL, 0x000fe200000000ffULL,
0x000000100e0f7824ULL, 0x000fc400078e0203ULL, 0x0000001008097824ULL, 0x100fe400078e0203ULL,
0x000000100a0b7824ULL, 0x100fe400078e0203ULL, 0x000000100c0d7824ULL, 0x000fe200078e0203ULL,
0x000000242503723eULL, 0x000fe200000000ffULL, 0x0000000105077824ULL, 0x000fe200078e0206ULL,
0x0000001c1d05723eULL, 0x000fe200000000ffULL, 0x00000001060a7824ULL, 0x040fe200078e020fULL,
0x0000541003107816ULL, 0x140fe20000000004ULL, 0x0000000106097824ULL, 0x040fe200078e0209ULL,
0x0000763203117816ULL, 0x000fe20000000004ULL, 0x0000000106087824ULL, 0x040fe200078e020bULL,
0x000000141503723eULL, 0x000fe200000000ffULL, 0x00000001060d7824ULL, 0x000fe200078e020dULL,
0x0000003c3d04723eULL, 0x000fe200000000ffULL, 0x0000001007007388ULL, 0x0003e20000000a00ULL,
0x0000003e3f0b723eULL, 0x000fc400000000ffULL, 0x0000541003067816ULL, 0x000fe40000000004ULL,
0x00000032330f723eULL, 0x000fc800000000ffULL, 0x000054101e0e7816ULL, 0x140fe4000000000fULL,
0x000076321e0f7816ULL, 0x000fe4000000000fULL, 0x0000763203077816ULL, 0x002fe40000000004ULL,
0x000000262703723eULL, 0x000fe400000000ffULL, 0x0000002a2b04723eULL, 0x000fe200000000ffULL,
0x0000000609007388ULL, 0x0003e40000000a00ULL, 0x0000541005067816ULL, 0x002fc40000000030ULL,
0x0000763205077816ULL, 0x000fca0000000030ULL, 0x0000000608007388ULL, 0x0003e40000000a00ULL,
0x000054102c067816ULL, 0x142fe40000000038ULL, 0x000076322c077816ULL, 0x000fca0000000038ULL,
0x000000060d007388ULL, 0x0003e40000000a00ULL, 0x0000541003067816ULL, 0x142fe40000000004ULL,
0x0000763203077816ULL, 0x000fca0000000004ULL, 0x000000060a007388ULL, 0x0003e40000000a00ULL,
0x00005410160a7816ULL, 0x142fe4000000000bULL, 0x00007632160b7816ULL, 0x000fca000000000bULL,
0x0004000a09007388ULL, 0x0003e80000000a00ULL, 0x0004000e08007388ULL, 0x000fe20000000a00ULL,
0x000054102e0a7816ULL, 0x142fe40000000017ULL, 0x000076322e0b7816ULL, 0x000fca0000000017ULL,
0x0004000a0d007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000079047984ULL, 0x000e680000000c00ULL, 0x0004000079147984ULL, 0x000ea80000000c00ULL,
0x0008000079107984ULL, 0x000ee80000000c00ULL, 0x000c000079187984ULL, 0x000ee20000000c00ULL,
0x200000ff07077230ULL, 0x002fc40000000000ULL, 0x200000ff06067230ULL, 0x000fe40000000000ULL,
0x200000ff05057230ULL, 0x000fe40000000000ULL, 0x200000ff04047230ULL, 0x000fe40000000000ULL,
0x200000ff17177230ULL, 0x004fe40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fc40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x0000001307077230ULL, 0x008fe40000000000ULL, 0x0000001206067230ULL, 0x000fe40000000000ULL,
0x0000001105057230ULL, 0x000fe40000000000ULL, 0x0000001004047230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x000fc40000000000ULL, 0x0000001a16167230ULL, 0x000fe20000000000ULL,
0x0000000479007388ULL, 0x000fe20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fca0000000000ULL, 0x0004001479007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff057819ULL, 0x000fc80000011602ULL, 0x000000770500720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0x0000000105037824ULL, 0x000fe200078e0202ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x00005a00740d7a19ULL, 0x000fe200000006ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000002002077810ULL, 0x040fe20007ffe0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x0000000703037812ULL, 0x000fe400078ec0ffULL, 0x0000580000067ab9ULL, 0x000fe20000000800ULL,
0x00000007020f7812ULL, 0x000fc400078ec0ffULL, 0x0ffffff803037812ULL, 0x000fca00078ef802ULL,
0x0000001003047824ULL, 0x000fe400078e0200ULL, 0x0000001078037824ULL, 0x000fc600078e0205ULL,
0x0000000004087984ULL, 0x0004e40000000c00ULL, 0x0000000503057c12ULL, 0x000fe2000f8e30ffULL,
0x00000006040472a4ULL, 0x002fe2000f8e023fULL, 0x00005a00ff037a19ULL, 0x000fc60000011603ULL,
0x000000010d057824ULL, 0x000fe400078e0205ULL, 0x000000047a067c24ULL, 0x000fe4000f8e02ffULL,
0x0000007a03037224ULL, 0x000fca00078e0205ULL, 0x0000000306037210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0003047a11ULL, 0x004fc800078040ffULL,
0x00005d0003057a11ULL, 0x000fe200000f440cULL, 0x0000000876037824ULL, 0x000fe200078e020fULL,
0x00000003ff0c7819ULL, 0x000fc60000011607ULL, 0x0000001003047825ULL, 0x000fe200078e0004ULL,
0x000000770c00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0083f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107037824ULL, 0x100fe400078e020cULL,
0x00000010780c7824ULL, 0x000fc600078e020cULL, 0x0000000703047812ULL, 0x002fe400078ec0ffULL,
0x00005a00ff057a19ULL, 0x000fe4000001160cULL, 0x0ffffff804037812ULL, 0x000fe400078ef807ULL,
0x000000050c047c12ULL, 0x000fe4000f8e30ffULL, 0x00000040020c7810ULL, 0x000fe20007ffe0ffULL,
0x0000001003037824ULL, 0x000fe200078e0200ULL, 0x0000000707077812ULL, 0x000fe200078ec0ffULL,
0x000000010d047824ULL, 0x000fc600078e0204ULL, 0x0000000003087984ULL, 0x0002a20000000c00ULL,
0x0000007a05057224ULL, 0x000fe400078e0204ULL, 0x0000000876077824ULL, 0x000fc600078e0207ULL,
0x0000000506057210ULL, 0x000fe40007f1e0ffULL, 0x00000003ff037819ULL, 0x002fc6000001160cULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x000fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000770300720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0043ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c047824ULL, 0x142fe200078e0203ULL,
0x000000070c077812ULL, 0x000fe200078ec0ffULL, 0x0000001078037824ULL, 0x000fc600078e0203ULL,
0x0000000704057812ULL, 0x000fe200078ec0ffULL, 0x0000000876077824ULL, 0x000fe200078e0207ULL,
0x0000000503047c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff805057812ULL, 0x000fe400078ef80cULL,
0x00005a00ff037a19ULL, 0x000fe20000011603ULL, 0x000000010d047824ULL, 0x000fe400078e0204ULL,
0x0000001005057824ULL, 0x000fe400078e0200ULL, 0x0000007a03037224ULL, 0x000fe200078e0204ULL,
0x0000006002047810ULL, 0x000fc40007ffe0ffULL, 0x0000000005087984ULL, 0x0002a40000000c00ULL,
0x0000000306037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0003027a11ULL, 0x040fe400078040ffULL, 0x00000003ff057819ULL, 0x002fe40000011604ULL,
0x00005d0003037a11ULL, 0x000fe400000f440eULL, 0x000000770500720cULL, 0x000fe20003f06070ULL,
0x00000001040c7824ULL, 0x000fe400078e0205ULL, 0x0000001007027825ULL, 0x000fc600078e0002ULL,
0x000000070c077812ULL, 0x000fc800078ec0ffULL, 0xfffffff807077812ULL, 0x000fe200078ef804ULL,
0x0000000802007986ULL, 0x0043e4000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001007077824ULL, 0x000fe400078e0200ULL, 0x0000001078057824ULL, 0x000fc600078e0205ULL,
0x0000000007087984ULL, 0x002e640000000c00ULL, 0x0000000505007c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff057a19ULL, 0x000fc60000011605ULL, 0x000000010d007824ULL, 0x000fc800078e0200ULL,
0x0000007a05057224ULL, 0x000fca00078e0200ULL, 0x0000000506067210ULL, 0x000fe40007f1e0ffULL,
0x0000000704057812ULL, 0x000fc600078ec0ffULL, 0x000000ffff037224ULL, 0x000fe200000e06ffULL,
0x00005c0006027a11ULL, 0x000fe200078040ffULL, 0x0000000876057824ULL, 0x000fc600078e0205ULL,
0x00005d0006037a11ULL, 0x000fca00000f4403ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff5e7819ULL, 0x000fe20000011600ULL, 0xffffffffff107424ULL, 0x000fc600078e00ffULL,
0x000000715e00720cULL, 0x000fda0003f06070ULL, 0x00000002050d8824ULL, 0x000fc800078e00ffULL,
0x000068000d0d8a24ULL, 0x000fc800078e025eULL, 0x000064000d0c8625ULL, 0x000fe200078e000aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006c00ff0e7624ULL, 0x000fe200078e00ffULL,
0x000000080c108981ULL, 0x000ea2000c1e1900ULL, 0x00006d00ff0f7624ULL, 0x000fc600078e00ffULL,
0x01760000ff067f8cULL, 0x000ee8000c80043fULL, 0x000000080e047981ULL, 0x002322000c1e9900ULL,
0x000001ff0900780cULL, 0x000fe20003f04070ULL, 0x0000008074687824ULL, 0x000fe400078e00ffULL,
0x00000040006f7824ULL, 0x000fe400078e00ffULL, 0x0000008012757824ULL, 0x000fc600078e00ffULL,
0x0000004068027812ULL, 0x000fe200078ef86fULL, 0x00000010752f7224ULL, 0x004fc800078e02ffULL,
0x00000c9000000947ULL, 0x000fea0003800000ULL, 0x00000003ff1b7819ULL, 0x00afe40000011603ULL,
0x0000006f631c7217ULL, 0x000fe40007800000ULL, 0x000000041b0f7810ULL, 0x040fe20007ffe0ffULL,
0x00000001020c7824ULL, 0x000fe200078e021bULL, 0x000000081b137810ULL, 0x040fe20007ffe0ffULL,
0x000000011c1c7824ULL, 0x000fe200078e0a6fULL, 0x0000000c1b157810ULL, 0x000fe20007ffe0ffULL,
0x000000010f097824ULL, 0x100fe200078e0203ULL, 0x000000101b117810ULL, 0x000fe20007ffe0ffULL,
0x000000080f0e7824ULL, 0x040fe200078e00ffULL, 0x0000001c0f00720cULL, 0x080fe20003fa6070ULL,
0x00000001130b7824ULL, 0x000fe200078e0203ULL, 0x000000141b1d7810ULL, 0x000fe20007ffe0ffULL,
0x0000000813107824ULL, 0x040fe200078e00ffULL, 0xfffffff80e237812ULL, 0x000fe200078ee209ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000001c1300720cULL, 0x000fc40003f26070ULL,
0xfffffff810257812ULL, 0x000fe200078ee20bULL, 0x00000001150e7824ULL, 0x100fe200078e0203ULL,
0x000062002f0b7a11ULL, 0x000fe200078038ffULL, 0x0000000815277824ULL, 0x000fe200078e00ffULL,
0x000000700c1e7812ULL, 0x000fe200078ef808ULL, 0x00000001110c7824ULL, 0x000fe200078e0203ULL,
0x000063002f097a11ULL, 0x000fe200000f3cffULL, 0x0000000811297824ULL, 0x000fe200078e00ffULL,
0xfffffff827277812ULL, 0x000fe200078ee20eULL, 0x00000001020e7824ULL, 0x040fe200078e0213ULL,
0x0000001e0b1e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000102167824ULL, 0x040fe200078e0211ULL,
0xfffffff829297812ULL, 0x000fe200078ee20cULL, 0x00000001020c7824ULL, 0x000fe200078e020fULL,
0x000000181b2d7810ULL, 0x000fe20007ffe0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001c1500720cULL, 0x000fc40003f46070ULL, 0x0000001c1b2f7810ULL, 0x000fe20007ffe0ffULL,
0x000000010d1f7824ULL, 0x000fe200000e0609ULL, 0x000000700e127812ULL, 0x100fe200078ef808ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000001c1100720cULL, 0x000fe40003f06070ULL,
0x0000000b12127210ULL, 0x000fe20007f9e0ffULL, 0x0000000102107824ULL, 0x000fe200078e0215ULL,
0x000000700c187812ULL, 0x000fe200078ef808ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x00001000001a7811ULL, 0x000fc400078e70ffULL, 0x0000000b18187210ULL, 0x080fe20007f7e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x00000070160e7812ULL, 0x100fe400078ef808ULL,
0x000000201b317810ULL, 0x000fe20007ffe0ffULL, 0x0000000102207824ULL, 0x000fe200078e021dULL,
0x0000007010147812ULL, 0x000fe200078ef808ULL, 0x000000010f137824ULL, 0x000fe200020e0609ULL,
0x0000000b0e0e7210ULL, 0x000fe20007f9e0ffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x000000241b337810ULL, 0x000fc40007ffe0ffULL, 0x000000281b357810ULL, 0x040fe20007ffe0ffULL,
0x000000011b167824ULL, 0x000fe200078e0203ULL, 0x00000070200c7812ULL, 0x000fe200078ef808ULL,
0x000000010d197824ULL, 0x000fe200018e0609ULL, 0x0000000b14147210ULL, 0x080fe20007f7e0ffULL,
0x0000000102107824ULL, 0x000fe200078e022dULL, 0x0000000716207812ULL, 0x000fe200078ec0ffULL,
0x00000001170f7824ULL, 0x100fe200020e0609ULL, 0x0000001c1b00720cULL, 0x080fe20003f86070ULL,
0x0000000111157824ULL, 0x000fe200018e0609ULL, 0x0000001c1d00720cULL, 0x040fe20003f66070ULL,
0x000000011d167824ULL, 0x140fe200078e0203ULL, 0x0000000b0c0c7210ULL, 0x000fe20007fde0ffULL,
0x000000081d2b7824ULL, 0x000fe200078e00ffULL, 0x0ffffff8201d7812ULL, 0x000fe200078ef803ULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee216ULL,
0x0000000102177824ULL, 0x000fe200078e022fULL, 0x0000007010107812ULL, 0x000fe200078ef808ULL,
0x000000101d1d7824ULL, 0x000fe400078e021aULL, 0x0000008017167825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001e1d7faeULL, 0x0003e2000e101c48ULL,
0x00000001210d7824ULL, 0x000fe200030e0609ULL, 0x0000000b10107210ULL, 0x000fe20007fde0ffULL,
0x0000000102207824ULL, 0x000fe200078e0231ULL, 0x0000001c2d00720cULL, 0x040fe20003f86070ULL,
0x000000012d227824ULL, 0x040fe200078e0203ULL, 0x0000007016167812ULL, 0x000fe200078ef808ULL,
0x000000082d2d7824ULL, 0x000fe400078e00ffULL, 0x0000008020207825ULL, 0x000fc600078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee222ULL, 0x0000000111117824ULL, 0x000fe200030e0609ULL,
0x0000000b16167210ULL, 0x000fe20007fde0ffULL, 0x0000000102247824ULL, 0x000fe200078e0233ULL,
0x00000070201e7812ULL, 0x002fe200078ef808ULL, 0x00000010231d7824ULL, 0x000fe400078e021aULL,
0x0000008024227825ULL, 0x000fc600078e00ffULL, 0x00000000181d7faeULL, 0x0003e2000e901c48ULL,
0x0000000117177824ULL, 0x000fe200030e0609ULL, 0x0000000b1e1e7210ULL, 0x080fe20007fde0ffULL,
0x0000001025257824ULL, 0x000fe200078e021aULL, 0x0000007022207812ULL, 0x000fe200078ef808ULL,
0x0000001027277824ULL, 0x100fe200078e021aULL, 0x0000001c2f00720cULL, 0x0c0fe20003fa6070ULL,
0x000000012f247824ULL, 0x000fe200078e0203ULL, 0x0000000012257faeULL, 0x0005e2000c901c48ULL,
0x00000001211f7824ULL, 0x000fe200030e0609ULL, 0x0000000b20207210ULL, 0x000fe20007fde0ffULL,
0x000000082f2f7824ULL, 0x000fe200078e00ffULL, 0x0000000014277faeULL, 0x0007e2000d101c48ULL,
0x0000000102187824ULL, 0x002fe200078e0235ULL, 0x0000001c3300720cULL, 0x080fe20003f46070ULL,
0x0000001029297824ULL, 0x000fe200078e021aULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee224ULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000001c3100720cULL, 0x000fc40003f26070ULL,
0x000000000e297faeULL, 0x0003e2000c101c48ULL, 0x000000102b2b7824ULL, 0x000fe200078e021aULL,
0x0000007018187812ULL, 0x000fe200078ef808ULL, 0x0000000123217824ULL, 0x000fe200030e0609ULL,
0x0000002c1b157810ULL, 0x008fe20007ffe0ffULL, 0x00000001311d7824ULL, 0x000fe200078e0203ULL,
0x000000301b237810ULL, 0x000fe20007ffe0ffULL, 0x0000000831247824ULL, 0x000fe200078e00ffULL,
0x000000000c2b7faeULL, 0x0007e2000d901c48ULL, 0x0000000102127824ULL, 0x004fe200078e0215ULL,
0x0000000b18187210ULL, 0x000fe20007fde0ffULL, 0x0000000133227824ULL, 0x040fe200078e0203ULL,
0xfffffff8241d7812ULL, 0x000fe200078ee21dULL, 0x0000000833337824ULL, 0x000fe200078e00ffULL,
0x000000341b257810ULL, 0x000fe20007ffe0ffULL, 0x000000102d2d7824ULL, 0x000fe200078e021aULL,
0x000000381b277810ULL, 0x000fe20007ffe0ffULL, 0x00000001020e7824ULL, 0x002fe200078e0223ULL,
0xfffffff833137812ULL, 0x000fe200078ee222ULL, 0x000000102f2f7824ULL, 0x000fe200078e021aULL,
0x00000000102d7faeULL, 0x0003e2000e101c48ULL, 0x00000080120c7825ULL, 0x008fe200078e00ffULL,
0x0000003c1b297810ULL, 0x000fc40007ffe0ffULL, 0x00000000162f7faeULL, 0x0005e2000e901c48ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x000fe400078ef808ULL,
0x0000001c1500720cULL, 0x080fe20003f86070ULL, 0x000000101d1d7824ULL, 0x000fe200078e021aULL,
0x000000700e127812ULL, 0x000fe200078ef808ULL, 0x0000000119197824ULL, 0x000fe200030e0609ULL,
0x0000000b0c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001013137824ULL, 0x000fe200078e021aULL,
0x000000001e1d7faeULL, 0x0007e2000c901c48ULL, 0x0000000102107824ULL, 0x002fe200078e0225ULL,
0x0000001c3500720cULL, 0x080fe20003fa6070ULL, 0x0000000115147824ULL, 0x040fe200078e0203ULL,
0x0000000020137faeULL, 0x0003e2000d101c48ULL, 0x00000008151b7824ULL, 0x000fe200078e00ffULL,
0x0000001c2300720cULL, 0x080fe20003f66070ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000001c2500720cULL, 0x000fc40003f46070ULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee214ULL,
0x00000001230e7824ULL, 0x040fe200078e0203ULL, 0x0000007010147812ULL, 0x000fe200078ef808ULL,
0x00000008231d7824ULL, 0x008fe200078e00ffULL, 0x0000001c2700720cULL, 0x080fe20003f26070ULL,
0x000000010d0d7824ULL, 0x000fe200030e0609ULL, 0x0000000b12127210ULL, 0x000fe20007fde0ffULL,
0x0000000135137824ULL, 0x002fe200078e0203ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee20eULL,
0x0000000835167824ULL, 0x004fe200078e00ffULL, 0x0000001c2900720cULL, 0x000fe20003f06070ULL,
0x00000001020e7824ULL, 0x000fc400078e0227ULL, 0x0000000125107824ULL, 0x000fe200078e0203ULL,
0xfffffff816177812ULL, 0x000fe200078ee213ULL, 0x000000010f137824ULL, 0x000fe200030e0609ULL,
0x0000000b14147210ULL, 0x000fe20007fde0ffULL, 0x00000008251f7824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fe400078e0229ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fc600078ee210ULL, 0x0000000111157824ULL, 0x000fe400030e0609ULL,
0x0000008002107825ULL, 0x000fe200078e00ffULL, 0x000000700e027812ULL, 0x000fc600078ef808ULL,
0x0000000127167824ULL, 0x100fe200078e0203ULL, 0x0000000b02027210ULL, 0x080fe20007fde0ffULL,
0x0000000129037824ULL, 0x040fe200078e0203ULL, 0x0000007010087812ULL, 0x000fe200078ef808ULL,
0x00000008290e7824ULL, 0x000fe400078e00ffULL, 0x0000000827217824ULL, 0x000fe400078e00ffULL,
0x0000001017177824ULL, 0x000fe200078e021aULL, 0xfffffff80e237812ULL, 0x000fe200078ee203ULL,
0x000000010f037824ULL, 0x000fe200030e0609ULL, 0xfffffff821217812ULL, 0x000fe200078ee216ULL,
0x000000101b1b7824ULL, 0x100fe200078e021aULL, 0x0000000b08087210ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x100fe200078e021aULL, 0x0000000018177faeULL, 0x0003e2000e901c48ULL,
0x000000101f1f7824ULL, 0x000fc400078e021aULL, 0x0000001021217824ULL, 0x100fe200078e021aULL,
0x000000000c1b7faeULL, 0x0003e2000e101c48ULL, 0x0000001023237824ULL, 0x000fe400078e021aULL,
0x0000000111097824ULL, 0x000fe200030e0609ULL, 0x00000000121d7faeULL, 0x0003e8000d901c48ULL,
0x00000000141f7faeULL, 0x0003e8000d101c48ULL, 0x0000000002217faeULL, 0x0003e8000c901c48ULL,
0x0000000008237faeULL, 0x0003e2000c101c48ULL, 0x00000b5000007947ULL, 0x000fea0003800000ULL,
0x00000004030d7811ULL, 0x04afe400078fe8ffULL, 0x0000000c030f7811ULL, 0x000fc400078fe8ffULL,
0x0000001403137811ULL, 0x000fe200078fe8ffULL, 0x000000010d097824ULL, 0x100fe200078e0203ULL,
0x0000001003117811ULL, 0x000fe200078fe8ffULL, 0x000000080d127824ULL, 0x000fe200078e00ffULL,
0x00000008030e7811ULL, 0x000fe200078fe8ffULL, 0x000000010f0c7824ULL, 0x000fe200078e0203ULL,
0x0000001c03177811ULL, 0x000fe200078fe8ffULL, 0x000000080f217824ULL, 0x000fe200078e00ffULL,
0xfffffff8121b7812ULL, 0x000fe200078ee209ULL, 0x0000000113097824ULL, 0x100fe200078e0203ULL,
0x0000002403327811ULL, 0x000fe200078fe8ffULL, 0x0000000813127824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee20cULL, 0x0000000111107824ULL, 0x100fe200078e0203ULL,
0x0000002003197811ULL, 0x000fe200078fe8ffULL, 0x0000000811237824ULL, 0x000fe200078e00ffULL,
0x0000001803157811ULL, 0x040fe200078fe8ffULL, 0x000000010e0b7824ULL, 0x040fe200078e0203ULL,
0x0000002c03307811ULL, 0x000fe200078fe8ffULL, 0x000000080e147824ULL, 0x000fe200078e00ffULL,
0xfffffff812257812ULL, 0x000fe200078ee209ULL, 0x00000001170c7824ULL, 0x000fe200078e0203ULL,
0xfffffff823237812ULL, 0x000fe200078ee210ULL, 0x0000000817297824ULL, 0x000fe200078e00ffULL,
0xfffffff8141d7812ULL, 0x000fe200078ee20bULL, 0x0000000132097824ULL, 0x140fe200078e0203ULL,
0x00000030032e7811ULL, 0x000fe200078fe8ffULL, 0x00000008321a7824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee20cULL, 0x0000000119107824ULL, 0x000fe200078e0203ULL,
0x0000002803317811ULL, 0x000fe200078fe8ffULL, 0x00000008192b7824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee209ULL, 0x00000001150b7824ULL, 0x100fe200078e0203ULL,
0x0000000303097211ULL, 0x000fe200078fe8ffULL, 0x0000000815147824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee210ULL, 0x00000001300c7824ULL, 0x040fe200078e0203ULL,
0x0000003803247811ULL, 0x040fe200078fe8ffULL, 0x00000008301f7824ULL, 0x000fe200078e00ffULL,
0xfffffff814277812ULL, 0x000fe200078ee20bULL, 0x000000012e107824ULL, 0x140fe200078e0203ULL,
0x0000003c03267811ULL, 0x000fe200078fe8ffULL, 0x000000082e2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff81f207812ULL, 0x000fe200078ee20cULL, 0x00000001310b7824ULL, 0x000fe200078e0203ULL,
0x00000034031f7811ULL, 0x000fe200078fe8ffULL, 0x00000008311c7824ULL, 0x000fe200078e00ffULL,
0x00000007090c7812ULL, 0x000fe200078ec0ffULL, 0x00000001022c7824ULL, 0x040fe200078e0226ULL,
0xfffffff82d227812ULL, 0x000fe200078ee210ULL, 0x0000000102107824ULL, 0x000fe200078e020fULL,
0xfffffff81c1c7812ULL, 0x000fe200078ee20bULL, 0x000000011f097824ULL, 0x100fe200078e0203ULL,
0x00000002030b7211ULL, 0x000fe200078fe8ffULL, 0x00000001240f7824ULL, 0x100fe200078e0203ULL,
0x0ffffff80c0c7812ULL, 0x000fe200078ef803ULL, 0x000000081f287824ULL, 0x000fc400078e00ffULL,
0x0000000126037824ULL, 0x000fe400078e0203ULL, 0x0000000824347824ULL, 0x000fe400078e00ffULL,
0x0000000826267824ULL, 0x000fe400078e00ffULL, 0x00000001022a7824ULL, 0x000fe200078e0224ULL,
0xfffffff828247812ULL, 0x000fe200078ee209ULL, 0x00000001020d7824ULL, 0x000fe200078e020dULL,
0xfffffff8340f7812ULL, 0x000fe200078ee20fULL, 0x00000001020e7824ULL, 0x000fe200078e020eULL,
0xfffffff826287812ULL, 0x000fe200078ee203ULL, 0x0000000102127824ULL, 0x000fe200078e0211ULL,
0x0000100000347811ULL, 0x000fe200078e70ffULL, 0x0000000102147824ULL, 0x040fe200078e0213ULL,
0x000062002f097a11ULL, 0x000fe200078038ffULL, 0x0000000102167824ULL, 0x000fc400078e0215ULL,
0x0000000102187824ULL, 0x040fe200078e0217ULL, 0x000063002f2f7a11ULL, 0x000fe200000f3cffULL,
0x00000001021e7824ULL, 0x040fe400078e0219ULL, 0x0000000102327824ULL, 0x040fe400078e0232ULL,
0x0000000102317824ULL, 0x040fe400078e0231ULL, 0x0000000102307824ULL, 0x040fe400078e0230ULL,
0x00000001022e7824ULL, 0x000fc400078e022eULL, 0x00000001022d7824ULL, 0x000fe400078e021fULL,
0x000000800b027825ULL, 0x000fc800078e00ffULL, 0x000000100f267824ULL, 0x000fe200078e0234ULL,
0x0000007002027812ULL, 0x000fe200078ef808ULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0x0000000209027210ULL, 0x000fe20007f1e0ffULL, 0x000000100c0b7824ULL, 0x000fe200078e0234ULL,
0x000000700e0e7812ULL, 0x000fe200078ef808ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x000000800d0c7825ULL, 0x000fe200078e00ffULL, 0x0000007012127812ULL, 0x000fc600078ef808ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x000fc600078ef808ULL,
0x0000000103037824ULL, 0x100fe200000e062fULL, 0x0000000e090e7210ULL, 0x040fe20007f1e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000007010107812ULL, 0x100fe400078ef808ULL,
0x0000000c090c7210ULL, 0x040fe20007f3e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000001009107210ULL, 0x000fe20007f5e0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020b7faeULL, 0x0003e2000b901c48ULL, 0x0000007014147812ULL, 0x100fe200078ef808ULL,
0x000000010f0f7824ULL, 0x000fe200000e062fULL, 0x0000001209127210ULL, 0x000fe20007f1e0ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000007016167812ULL, 0x000fc600078ef808ULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000007018187812ULL, 0x000fc600078ef808ULL,
0x000000101b1b7824ULL, 0x000fe200078e0234ULL, 0x000000701e1e7812ULL, 0x000fe200078ef808ULL,
0x000000101d1d7824ULL, 0x100fe400078e0234ULL, 0x0000001021217824ULL, 0x100fe200078e0234ULL,
0x0000001e091e7210ULL, 0x000fe20007f7e0ffULL, 0x0000001023237824ULL, 0x100fe400078e0234ULL,
0x0000001025257824ULL, 0x100fe400078e0234ULL, 0x0000001027277824ULL, 0x000fc400078e0234ULL,
0x0000001029297824ULL, 0x100fe400078e0234ULL, 0x000000102b2b7824ULL, 0x100fe400078e0234ULL,
0x000000101a1a7824ULL, 0x100fe400078e0234ULL, 0x000000101c1c7824ULL, 0x100fe400078e0234ULL,
0x0000001020207824ULL, 0x100fe400078e0234ULL, 0x0000001022227824ULL, 0x000fc400078e0234ULL,
0x0000001024247824ULL, 0x100fe400078e0234ULL, 0x0000001028287824ULL, 0x000fe400078e0234ULL,
0x0000008032327825ULL, 0x000fc800078e00ffULL, 0x0000008031347825ULL, 0x000fc800078e00ffULL,
0x000000802e367825ULL, 0x000fc800078e00ffULL, 0x0000000113137824ULL, 0x000fe200000e062fULL,
0x0000001409147210ULL, 0x000fe20007f1e0ffULL, 0x0000008030307825ULL, 0x000fc800078e00ffULL,
0x000000802d387825ULL, 0x000fe200078e00ffULL, 0x0000007030307812ULL, 0x000fc600078ef808ULL,
0x000000010d0d7824ULL, 0x100fe200008e062fULL, 0x0000001609167210ULL, 0x000fe20007f3e0ffULL,
0x000000802a3a7825ULL, 0x000fe200078e00ffULL, 0x00000070322a7812ULL, 0x100fe400078ef808ULL,
0x0000007034327812ULL, 0x100fe200078ef808ULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x0000007036347812ULL, 0x100fe200078ef808ULL, 0x000000000c1b7faeULL, 0x0003e2000b901c48ULL,
0x0000007038367812ULL, 0x100fe200078ef808ULL, 0x0000000111117824ULL, 0x100fe200010e062fULL,
0x0000001809187210ULL, 0x000fe20007f5e0ffULL, 0x0000000115157824ULL, 0x100fe200000e062fULL,
0x000000703a387812ULL, 0x100fe200078ef808ULL, 0x0000000117177824ULL, 0x100fe200008e062fULL,
0x000000702c2c7812ULL, 0x000fe200078ef808ULL, 0x0000000119197824ULL, 0x100fe200010e062fULL,
0x0000002a09087210ULL, 0x000fe20007f1e0ffULL, 0x000000011f1f7824ULL, 0x000fe200018e062fULL,
0x0000003209327210ULL, 0x040fe20007f3e0ffULL, 0x000000000e1d7faeULL, 0x0003e2000b901c48ULL,
0x0000003009307210ULL, 0x000fc40007f5e0ffULL, 0x0000003409347210ULL, 0x040fe20007f7e0ffULL,
0x0000000010217faeULL, 0x0003e2000b901c48ULL, 0x0000003609367210ULL, 0x000fe20007f9e0ffULL,
0x0000000131317824ULL, 0x100fe200010e062fULL, 0x0000003809387210ULL, 0x040fe20007fbe0ffULL,
0x0000000012237faeULL, 0x0003e2000b901c48ULL, 0x0000002c092c7210ULL, 0x000fe20007fde0ffULL,
0x0000000133097824ULL, 0x100fe400000e062fULL, 0x0000000135337824ULL, 0x100fe200008e062fULL,
0x0000000014257faeULL, 0x0003e2000b901c48ULL, 0x0000000137357824ULL, 0x000fc400018e062fULL,
0x0000000139377824ULL, 0x100fe200020e062fULL, 0x0000000016277faeULL, 0x0003e2000b901c48ULL,
0x000000013b397824ULL, 0x100fe400028e062fULL, 0x000000012d2d7824ULL, 0x000fe200030e062fULL,
0x0000000018297faeULL, 0x0003e8000b901c48ULL, 0x000000001e2b7faeULL, 0x0003e8000b901c48ULL,
0x00000000081a7faeULL, 0x0003e8000b901c48ULL, 0x00000000321c7faeULL, 0x0003e8000b901c48ULL,
0x0000000030207faeULL, 0x0003e8000b901c48ULL, 0x0000000034227faeULL, 0x0003e8000b901c48ULL,
0x0000000036247faeULL, 0x0003e8000b901c48ULL, 0x0000000038267faeULL, 0x0003e8000b901c48ULL,
0x000000002c287faeULL, 0x0003e4000b901c48ULL, 0x000000025e5e7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff607424ULL, 0x000fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x000000715e00720cULL, 0x000fda0003f06070ULL, 0x00000002050b8824ULL, 0x002fc800078e00ffULL,
0x000068000b0b8a24ULL, 0x000fc800078e025eULL, 0x000064000b0a8625ULL, 0x000fca00078e000aULL,
0x000000080a608981ULL, 0x000324000c1e1900ULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x01760400ff097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x002fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008020b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e03ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011409ULL,
0x0000000b08087211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000208087819ULL, 0x000fc80000001209ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000037919ULL, 0x000e640000000000ULL, 0x0000002000027824ULL, 0x002fca00078e0203ULL,
0x00000003ff037819ULL, 0x000fc80000011602ULL, 0x1ffffffe03077812ULL, 0x000fe400078ec0ffULL,
0x0000000f02037812ULL, 0x000fc600078ec0ffULL, 0x0000000102077824ULL, 0x000fe400078e0207ULL,
0x0000001003097824ULL, 0x040fe400078e00ffULL, 0x0000001003067824ULL, 0x000fe200078e00ffULL,
0x0000000f07027812ULL, 0x040fe400078ec0ffULL, 0x0000000107077810ULL, 0x000fe40007ffe0ffULL,
0x000000f009027812ULL, 0x000fe400078ee202ULL, 0x0000000f07077812ULL, 0x000fc600078ec0ffULL,
0x00000000020c7984ULL, 0x000e62000000cc00ULL, 0x000000f006077812ULL, 0x000fca00078ee207ULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fe400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fc400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001002007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01760000ff087f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0a7224ULL, 0x000fc600078e00ffULL,
0x0000000000027805ULL, 0x002fc80000015200ULL, 0x01760400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x006fc40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006020b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e03ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff6e00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000027919ULL, 0x000e620000000000ULL, 0x00005800ff617624ULL, 0x000fe200078e00ffULL,
0x80005800636d7a10ULL, 0x000fe20007ffe0ffULL, 0x0000680005767a24ULL, 0x000fe200078e02ffULL,
0x000001006f6f7810ULL, 0x000fe20007ffe0ffULL, 0x3db504f304037820ULL, 0x010fe20000410000ULL,
0x0000001f61057810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0xffffffff61727810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff117224ULL, 0x000fe200078e00ffULL,
0x00000004ff057819ULL, 0x000fc40000011605ULL, 0x0001768800737811ULL, 0x040fe400078e18ffULL,
0x0001760800747811ULL, 0x000fe400078e28ffULL, 0x0000000961617810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff6d7819ULL, 0x000fe4000001166dULL, 0x0ffffffe05627812ULL, 0x000fc400078ec0ffULL,
0x0000000204077810ULL, 0x040fe20007ffe0ffULL, 0x0000010004057824ULL, 0x000fe200078e026fULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000006075607224ULL, 0x010fe200078e02ffULL,
0x0000006e0700720cULL, 0x000fc40003f06070ULL, 0x0000004005077812ULL, 0x000fe400078ec0ffULL,
0x00000001115f7812ULL, 0x000fc600078e0cffULL, 0x0000000168077824ULL, 0x000fcc00078e0207ULL,
0x00000cc000008947ULL, 0x00cfea0003800000ULL, 0x00000003ff107819ULL, 0x102fe20000011602ULL,
0x00000010020b7824ULL, 0x000fe200078e00ffULL, 0x00000005630c7217ULL, 0x000fe40007800000ULL,
0x0000000810127810ULL, 0x040fe20007ffe0ffULL, 0x0000000110087824ULL, 0x040fe200078e0207ULL,
0x00000004100e7810ULL, 0x000fe20007ffe0ffULL, 0x000000010c1b7824ULL, 0x000fe200078e0a05ULL,
0x0000000c10147810ULL, 0x000fe20007ffe0ffULL, 0x0000000112097824ULL, 0x140fe200078e0202ULL,
0x000000700b0b7812ULL, 0x000fe200078ec0ffULL, 0x00000008120a7824ULL, 0x000fe200078e00ffULL,
0x0000001b0e00720cULL, 0x040fe20003fa6070ULL, 0x000000010e067824ULL, 0x000fe200078e0202ULL,
0x0000001010187810ULL, 0x000fe20007ffe0ffULL, 0x000000080e257824ULL, 0x000fe200078e00ffULL,
0xfffffff80a297812ULL, 0x000fe200078ee209ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x00006200600a7a11ULL, 0x000fc400078038ffULL, 0xfffffff825257812ULL, 0x000fe200078ee206ULL,
0x00000001140d7824ULL, 0x100fe200078e0202ULL, 0x0000000b08177212ULL, 0x000fe200078efcffULL,
0x0000000814087824ULL, 0x000fe200078e00ffULL, 0x0000630060067a11ULL, 0x000fe200000f3cffULL,
0x00000001120c7824ULL, 0x000fe200078e0207ULL, 0x000000170a167210ULL, 0x000fe20007f1e0ffULL,
0x0000000118217824ULL, 0x000fe200078e0202ULL, 0xfffffff8082b7812ULL, 0x000fe200078ee20dULL,
0x000000010e087824ULL, 0x000fe200078e0207ULL, 0x00000014101e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109177824ULL, 0x000fe200000e0606ULL, 0x0000001b1800720cULL, 0x080fe20003f06070ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000001b1400720cULL, 0x000fc40003f46070ULL,
0x0000001b1200720cULL, 0x000fe20003f26070ULL, 0x00000001140e7824ULL, 0x000fe200078e0207ULL,
0x0000000b08157212ULL, 0x080fe200078efcffULL, 0x00000008181a7824ULL, 0x000fe200078e00ffULL,
0x0000001810227810ULL, 0x000fe20007ffe0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000000a15087210ULL, 0x000fe40007f7e0ffULL, 0x0000001c10247810ULL, 0x000fe20007ffe0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000b0e157212ULL, 0x000fc400078efcffULL,
0xfffffff81a217812ULL, 0x000fe200078ee221ULL, 0x0000000118187824ULL, 0x100fe200078e0207ULL,
0x0000000b0c137212ULL, 0x080fe200078efcffULL, 0x000000011e1c7824ULL, 0x000fe200078e0207ULL,
0x0000002010267810ULL, 0x000fe20007ffe0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000000a13127210ULL, 0x080fe40007f9e0ffULL, 0x0000002410287810ULL, 0x000fe20007ffe0ffULL,
0x0000000109097824ULL, 0x000fe200018e0606ULL, 0x0000000a15147210ULL, 0x000fe20007f7e0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x0000000b181f7212ULL, 0x000fc600078efcffULL,
0x000000010f157824ULL, 0x100fe200018e0606ULL, 0x0000000a1f0e7210ULL, 0x080fe20007f7e0ffULL,
0x000000010d137824ULL, 0x100fe200020e0606ULL, 0x0000000b1c0d7212ULL, 0x000fe200078efcffULL,
0x0000000122187824ULL, 0x000fe400078e0207ULL, 0x00000001190f7824ULL, 0x000fe200018e0606ULL,
0x0000000a0d0c7210ULL, 0x000fe20007f9e0ffULL, 0x00000001101c7824ULL, 0x000fe200078e0202ULL,
0x0000001b1e00720cULL, 0x000fe20003f66070ULL, 0x0000008018187825ULL, 0x000fc600078e00ffULL,
0x000000071c1f7812ULL, 0x000fe200078ec0ffULL, 0x00000002001a7824ULL, 0x000fe400078e025fULL,
0x000000011d0d7824ULL, 0x000fe200020e0606ULL, 0x0000000b181d7212ULL, 0x000fe200078efcffULL,
0x00000001241c7824ULL, 0x100fe200078e0207ULL, 0x0000001b1000720cULL, 0x000fe20003f86070ULL,
0x000000011e207824ULL, 0x100fe200078e0202ULL, 0x000010001a1a7811ULL, 0x000fe200078e68ffULL,
0x000000081e2d7824ULL, 0x000fe200078e00ffULL, 0x0ffffff81f1f7812ULL, 0x000fe200078ef802ULL,
0x00000001261e7824ULL, 0x000fe200078e0207ULL, 0x0000000a1d187210ULL, 0x000fe20007fde0ffULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0xfffffff82d2d7812ULL, 0x000fc600078ee220ULL,
0x000000101f237824ULL, 0x000fe200078e021aULL, 0x0000000b1c1f7212ULL, 0x000fe200078efcffULL,
0x0000000119197824ULL, 0x000fe400030e0606ULL, 0x0000000122207824ULL, 0x000fe200078e0202ULL,
0x0000000a1f1c7210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000016237faeULL, 0x0003e2000e101c48ULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000001b2200720cULL, 0x000fc60003f86070ULL, 0x00000008222f7824ULL, 0x000fe400078e00ffULL,
0x0000000128227824ULL, 0x000fe400078e0207ULL, 0x000000011d1d7824ULL, 0x000fe200030e0606ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee220ULL, 0x0000001025257824ULL, 0x000fe200078e021aULL,
0x0000000b1e177212ULL, 0x002fe200078efcffULL, 0x0000008022227825ULL, 0x000fc600078e00ffULL,
0x0000000a17167210ULL, 0x080fe20007fde0ffULL, 0x0000000008257faeULL, 0x0003e2000e901c48ULL,
0x0000000b22277212ULL, 0x000fe200078efcffULL, 0x0000000124207824ULL, 0x040fe200078e0202ULL,
0x0000001b2400720cULL, 0x0c0fe20003fa6070ULL, 0x000000011f177824ULL, 0x000fe200030e0606ULL,
0x0000000a271e7210ULL, 0x000fe20007fde0ffULL, 0x0000000824317824ULL, 0x000fe200078e00ffULL,
0x0000002810247810ULL, 0x000fe20007ffe0ffULL, 0x0000001029277824ULL, 0x000fe400078e021aULL,
0x00000001231f7824ULL, 0x000fe200030e0606ULL, 0xfffffff831317812ULL, 0x000fe200078ee220ULL,
0x000000102b237824ULL, 0x100fe200078e021aULL, 0x0000000012277faeULL, 0x0005e2000c901c48ULL,
0x0000000124087824ULL, 0x002fe200078e0207ULL, 0x0000001b2600720cULL, 0x080fe20003f26070ULL,
0x0000001021217824ULL, 0x000fe200078e021aULL, 0x0000000014237faeULL, 0x0003e2000d101c48ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000001b2800720cULL, 0x000fc40003f46070ULL,
0x000000000e217faeULL, 0x0007e2000c101c48ULL, 0x0000000126207824ULL, 0x000fe200078e0202ULL,
0x0000000b08257212ULL, 0x000fe200078efcffULL, 0x0000000826297824ULL, 0x000fe200078e00ffULL,
0x0000003c10267810ULL, 0x000fe20007ffe0ffULL, 0x000000102d137824ULL, 0x004fe200078e021aULL,
0x0000000a25087210ULL, 0x000fe20007fde0ffULL, 0x0000000128227824ULL, 0x000fe200078e0202ULL,
0x0000002c10147810ULL, 0x002fe20007ffe0ffULL, 0x00000008282b7824ULL, 0x000fe200078e00ffULL,
0x000000000c137faeULL, 0x0003e2000d901c48ULL, 0xfffffff829257812ULL, 0x000fe200078ee220ULL,
0x000000102f157824ULL, 0x000fe200078e021aULL, 0x0000003010207810ULL, 0x000fe20007ffe0ffULL,
0x0000000114127824ULL, 0x100fe200078e0207ULL, 0xfffffff82b277812ULL, 0x000fe200078ee222ULL,
0x0000001031237824ULL, 0x100fe200078e021aULL, 0x0000003410227810ULL, 0x000fe20007ffe0ffULL,
0x0000001025257824ULL, 0x000fe200078e021aULL, 0x0000000018157faeULL, 0x0005e2000e101c48ULL,
0x00000001200e7824ULL, 0x008fe200078e0207ULL, 0x0000001b1400720cULL, 0x080fe20003f86070ULL,
0x00000080120c7825ULL, 0x002fe200078e00ffULL, 0x000000001c237faeULL, 0x0003e2000e901c48ULL,
0x0000001b2400720cULL, 0x000fc40003fa6070ULL, 0x0000001027277824ULL, 0x000fe200078e021aULL,
0x0000000b0c0f7212ULL, 0x000fe200078efcffULL, 0x0000000109097824ULL, 0x000fe200030e0606ULL,
0x0000000016257faeULL, 0x0007e2000c901c48ULL, 0x0000000122127824ULL, 0x000fe200078e0207ULL,
0x0000003810187810ULL, 0x004fe20007ffe0ffULL, 0x0000000124107824ULL, 0x000fe200078e0202ULL,
0x0000000a0f0c7210ULL, 0x000fe20007fde0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000001e277faeULL, 0x0005e2000d101c48ULL, 0x0000001b2000720cULL, 0x000fc40003f66070ULL,
0x0000001b2200720cULL, 0x080fe20003f46070ULL, 0x00000008201d7824ULL, 0x002fe200078e00ffULL,
0x0000001b1800720cULL, 0x080fe20003f26070ULL, 0x0000000114167824ULL, 0x108fe200078e0202ULL,
0x0000001b2600720cULL, 0x000fe20003f06070ULL, 0x00000008141b7824ULL, 0x000fe200078e00ffULL,
0x0000000b0e157212ULL, 0x000fe200078efcffULL, 0x0000000120147824ULL, 0x000fe400078e0202ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff81b1b7812ULL, 0x000fc400078ee216ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee214ULL, 0x000000010d0d7824ULL, 0x100fe200030e0606ULL,
0x0000000a150e7210ULL, 0x080fe20007fde0ffULL, 0x0000000118147824ULL, 0x000fe200078e0207ULL,
0x0000000b12177212ULL, 0x000fe200078efcffULL, 0x0000000824197824ULL, 0x000fe400078e00ffULL,
0x000000010f0f7824ULL, 0x000fe200030e0606ULL, 0x0000000a17167210ULL, 0x000fe20007fde0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fc600078ee210ULL,
0x0000000126127824ULL, 0x000fe200078e0207ULL, 0x0000000b14077212ULL, 0x000fe200078efcffULL,
0x0000000122107824ULL, 0x040fe400078e0202ULL, 0x00000008221f7824ULL, 0x004fe400078e00ffULL,
0x0000000113177824ULL, 0x000fe200030e0606ULL, 0x0000000a07147210ULL, 0x000fe20007fde0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fc600078ee210ULL,
0x0000000118107824ULL, 0x100fe200078e0202ULL, 0x0000000b120b7212ULL, 0x000fe200078efcffULL,
0x0000000818217824ULL, 0x000fe400078e00ffULL, 0x0000000126187824ULL, 0x040fe400078e0202ULL,
0x0000000826237824ULL, 0x000fe200078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee210ULL,
0x0000000115157824ULL, 0x000fe200030e0606ULL, 0x0000000a0b0a7210ULL, 0x000fe20007fde0ffULL,
0x0000001019077824ULL, 0x000fe200078e021aULL, 0xfffffff823237812ULL, 0x000fe200078ee218ULL,
0x000000101b197824ULL, 0x000fc400078e021aULL, 0x000000101d1b7824ULL, 0x100fe200078e021aULL,
0x0000000008077faeULL, 0x0003e2000e901c48ULL, 0x000000101f1d7824ULL, 0x100fe400078e021aULL,
0x00000010211f7824ULL, 0x100fe200078e021aULL, 0x000000000c197faeULL, 0x0003e2000e101c48ULL,
0x0000001023217824ULL, 0x000fe400078e021aULL, 0x00000001130b7824ULL, 0x000fe200030e0606ULL,
0x000000000e1b7faeULL, 0x0003e8000d901c48ULL, 0x00000000161d7faeULL, 0x0003e8000d101c48ULL,
0x00000000141f7faeULL, 0x0003e8000c901c48ULL, 0x000000000a217faeULL, 0x0003e2000c101c48ULL,
0x00000b8000007947ULL, 0x000fea0003800000ULL, 0x00000004020a7811ULL, 0x042fe200078fe8ffULL,
0x0000001002457824ULL, 0x040fe200078e00ffULL, 0x0000000802087811ULL, 0x000fc400078fe8ffULL,
0x0000000c02127811ULL, 0x000fe200078fe8ffULL, 0x000000010a067824ULL, 0x100fe200078e0202ULL,
0x00000010020e7811ULL, 0x000fe200078fe8ffULL, 0x000000080a3f7824ULL, 0x000fe200078e00ffULL,
0x0000001402147811ULL, 0x000fe200078fe8ffULL, 0x0000000108097824ULL, 0x000fe200078e0202ULL,
0x0000001802157811ULL, 0x000fe200078fe8ffULL, 0x00000008080c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee206ULL, 0x00000001120b7824ULL, 0x100fe200078e0202ULL,
0x0000001c02167811ULL, 0x000fe200078fe8ffULL, 0x0000000812107824ULL, 0x000fe200078e00ffULL,
0xfffffff80c3d7812ULL, 0x000fe200078ee209ULL, 0x000000010e067824ULL, 0x100fe200078e0202ULL,
0x0000002002187811ULL, 0x000fe200078fe8ffULL, 0x000000080e397824ULL, 0x000fe200078e00ffULL,
0xfffffff8103b7812ULL, 0x000fe200078ee20bULL, 0x0000000114097824ULL, 0x000fe200078e0202ULL,
0x0000002402207811ULL, 0x000fe200078fe8ffULL, 0x00000008140c7824ULL, 0x000fe200078e00ffULL,
0xfffffff839397812ULL, 0x000fe200078ee206ULL, 0x00000001150b7824ULL, 0x140fe200078e0202ULL,
0x00000028021e7811ULL, 0x000fe200078fe8ffULL, 0x0000000815107824ULL, 0x000fe200078e00ffULL,
0xfffffff80c377812ULL, 0x000fe200078ee209ULL, 0x0000000116067824ULL, 0x100fe200078e0202ULL,
0x0000002c021c7811ULL, 0x000fe200078fe8ffULL, 0x0000000816337824ULL, 0x000fe200078e00ffULL,
0xfffffff810357812ULL, 0x000fe200078ee20bULL, 0x0000000118097824ULL, 0x000fe200078e0202ULL,
0x00000030021a7811ULL, 0x000fe200078fe8ffULL, 0x00000008180c7824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee206ULL, 0x00000001200b7824ULL, 0x100fe200078e0202ULL,
0x0000003402227811ULL, 0x000fe200078fe8ffULL, 0x0000000820107824ULL, 0x000fe200078e00ffULL,
0xfffffff80c317812ULL, 0x000fe200078ee209ULL, 0x000000011e067824ULL, 0x100fe200078e0202ULL,
0x0000003802247811ULL, 0x000fe200078fe8ffULL, 0x000000081e2d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8102f7812ULL, 0x000fe200078ee20bULL, 0x000000011c097824ULL, 0x000fe200078e0202ULL,
0x0000003c02267811ULL, 0x000fe200078fe8ffULL, 0x000000081c0c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee206ULL, 0x000000011a0b7824ULL, 0x140fe200078e0202ULL,
0x0000007045457812ULL, 0x000fe200078ec0ffULL, 0x000000081a107824ULL, 0x000fe200078e00ffULL,
0xfffffff80c2b7812ULL, 0x000fe200078ee209ULL, 0x0000000122067824ULL, 0x100fe200078e0202ULL,
0x00006200602c7a11ULL, 0x000fe200078038ffULL, 0x0000000822297824ULL, 0x000fe200078e00ffULL,
0xfffffff8100d7812ULL, 0x000fe200078ee20bULL, 0x0000000124097824ULL, 0x000fe200078e0202ULL,
0x0000630060437a11ULL, 0x000fe200000f3cffULL, 0x00000008240c7824ULL, 0x000fe200078e00ffULL,
0xfffffff829297812ULL, 0x000fe200078ee206ULL, 0x00000001260b7824ULL, 0x100fe200078e0202ULL,
0x0000000202067211ULL, 0x000fe200078fe8ffULL, 0x0000000826107824ULL, 0x000fe200078e00ffULL,
0xfffffff80c0f7812ULL, 0x000fe200078ee209ULL, 0x000000010a0a7824ULL, 0x100fe200078e0207ULL,
0x0000000706097812ULL, 0x000fe200078ec0ffULL, 0x0000000108067824ULL, 0x000fe200078e0207ULL,
0xfffffff810137812ULL, 0x000fe200078ee20bULL, 0x00000002000b7824ULL, 0x000fe200078e025fULL,
0x0000000702087211ULL, 0x000fe200078fe8ffULL, 0x0000000112127824ULL, 0x100fe200078e0207ULL,
0x0ffffff809417812ULL, 0x000fe200078ef802ULL, 0x000000010e0e7824ULL, 0x000fe200078e0207ULL,
0x000010000b107811ULL, 0x000fe200078e68ffULL, 0x0000008008087825ULL, 0x000fc800078e00ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000004508177212ULL, 0x000fc600078efcffULL,
0x0000000114147824ULL, 0x100fe200078e0207ULL, 0x000000172c0c7210ULL, 0x000fe20007f1e0ffULL,
0x0000000115157824ULL, 0x100fe400078e0207ULL, 0x0000000116167824ULL, 0x100fe400078e0207ULL,
0x0000000118187824ULL, 0x100fe400078e0207ULL, 0x0000000120207824ULL, 0x100fe400078e0207ULL,
0x000000011e1e7824ULL, 0x000fc400078e0207ULL, 0x000000011c1c7824ULL, 0x100fe400078e0207ULL,
0x000000011a1a7824ULL, 0x100fe400078e0207ULL, 0x0000000122227824ULL, 0x100fe400078e0207ULL,
0x0000000124247824ULL, 0x100fe400078e0207ULL, 0x0000000126267824ULL, 0x000fe400078e0207ULL,
0x0000001041417824ULL, 0x000fc400078e0210ULL, 0x000000103f3f7824ULL, 0x100fe400078e0210ULL,
0x000000103d3d7824ULL, 0x100fe400078e0210ULL, 0x000000103b3b7824ULL, 0x100fe400078e0210ULL,
0x0000001039397824ULL, 0x100fe400078e0210ULL, 0x0000001037377824ULL, 0x100fe400078e0210ULL,
0x0000001035357824ULL, 0x000fc400078e0210ULL, 0x0000001033337824ULL, 0x100fe400078e0210ULL,
0x0000001031317824ULL, 0x100fe400078e0210ULL, 0x000000102f2f7824ULL, 0x100fe400078e0210ULL,
0x000000102d2d7824ULL, 0x100fe400078e0210ULL, 0x000000102b2b7824ULL, 0x100fe400078e0210ULL,
0x000000100d2a7824ULL, 0x100fe200078e0210ULL, 0x000000450a0d7212ULL, 0x000fe200078efcffULL,
0x0000001029297824ULL, 0x000fc400078e0210ULL, 0x000000100f287824ULL, 0x100fe200078e0210ULL,
0x0000000d2c0a7210ULL, 0x000fe20007f3e0ffULL, 0x0000001013107824ULL, 0x000fe400078e0210ULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000004506197212ULL, 0x000fc600078efcffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000004512177212ULL, 0x000fc600078efcffULL, 0x00000001090d7824ULL, 0x100fe200000e0643ULL,
0x000000192c087210ULL, 0x000fe20007f1e0ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x000000172c067210ULL, 0x000fe40007f5e0ffULL, 0x000000450e177212ULL, 0x080fe200078efcffULL,
0x0000000107097824ULL, 0x100fe200000e0643ULL, 0x00000045181b7212ULL, 0x000fe200078efcffULL,
0x0000000113077824ULL, 0x000fe200010e0643ULL, 0x000000172c0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000008014127825ULL, 0x000fe200078e00ffULL, 0x0000001b2c187210ULL, 0x000fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c417faeULL, 0x0003e4000b901c48ULL,
0x0000008015147825ULL, 0x000fe200078e00ffULL, 0x0000004512217212ULL, 0x000fc600078efcffULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x00000045141f7212ULL, 0x000fc600078efcffULL,
0x000000010f0f7824ULL, 0x100fe200000e0643ULL, 0x00000045161d7212ULL, 0x000fe200078efcffULL,
0x000000010b0b7824ULL, 0x000fe200008e0643ULL, 0x000000212c127210ULL, 0x000fe20007f1e0ffULL,
0x0000008020207825ULL, 0x000fe200078e00ffULL, 0x0000001f2c147210ULL, 0x040fe40007f3e0ffULL,
0x0000001d2c167210ULL, 0x000fe20007f5e0ffULL, 0x000000801e1e7825ULL, 0x000fe200078e00ffULL,
0x0000004520517212ULL, 0x080fe200078efcffULL, 0x000000000a3f7faeULL, 0x0003e4000b901c48ULL,
0x000000801c1c7825ULL, 0x000fe200078e00ffULL, 0x000000451e4f7212ULL, 0x080fe200078efcffULL,
0x00000000083d7faeULL, 0x0003e4000b901c48ULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x000000451c4d7212ULL, 0x080fe200078efcffULL, 0x00000000063b7faeULL, 0x0003e4000b901c48ULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x000000451a4b7212ULL, 0x080fe200078efcffULL,
0x000000000e397faeULL, 0x0003e4000b901c48ULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000004522497212ULL, 0x000fc600078efcffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000004524477212ULL, 0x000fe400078efcffULL, 0x000000492c227210ULL, 0x040fe20007f9e0ffULL,
0x0000000113137824ULL, 0x100fe200000e0643ULL, 0x000000512c207210ULL, 0x040fe20007f1e0ffULL,
0x0000000115157824ULL, 0x100fe200008e0643ULL, 0x0000004f2c1e7210ULL, 0x000fe20007f3e0ffULL,
0x0000000117177824ULL, 0x100fe200010e0643ULL, 0x0000004526457212ULL, 0x000fe200078efcffULL,
0x0000000119197824ULL, 0x100fe200018e0643ULL, 0x0000004d2c1c7210ULL, 0x040fe20007f5e0ffULL,
0x0000000121217824ULL, 0x100fe200000e0643ULL, 0x0000004b2c1a7210ULL, 0x040fe20007f7e0ffULL,
0x000000011f1f7824ULL, 0x100fe200008e0643ULL, 0x000000472c247210ULL, 0x040fe20007fbe0ffULL,
0x0000000012377faeULL, 0x0003e2000b901c48ULL, 0x000000452c267210ULL, 0x000fe20007fde0ffULL,
0x000000011d1d7824ULL, 0x000fc400010e0643ULL, 0x0000000014357faeULL, 0x0003e2000b901c48ULL,
0x000000011b1b7824ULL, 0x100fe400018e0643ULL, 0x0000000123237824ULL, 0x100fe200020e0643ULL,
0x0000000016337faeULL, 0x0003e2000b901c48ULL, 0x0000000125257824ULL, 0x100fe400028e0643ULL,
0x0000000127277824ULL, 0x000fe200030e0643ULL, 0x0000000018317faeULL, 0x0003e8000b901c48ULL,
0x00000000202f7faeULL, 0x0003e8000b901c48ULL, 0x000000001e2d7faeULL, 0x0003e8000b901c48ULL,
0x000000001c2b7faeULL, 0x0003e8000b901c48ULL, 0x000000001a2a7faeULL, 0x0003e8000b901c48ULL,
0x0000000022297faeULL, 0x0003e8000b901c48ULL, 0x0000000024287faeULL, 0x0003e8000b901c48ULL,
0x0000000026107faeULL, 0x0003e4000b901c48ULL, 0x000000025e5e7810ULL, 0x000fe20007ffe0ffULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff607424ULL, 0x000fc400078e00ffULL,
0x000000715e00720cULL, 0x000fe40003f06070ULL, 0x00000020020b7810ULL, 0x002fe20007ffe0ffULL,
0x0000000200087824ULL, 0x000fe200078e0211ULL, 0x00000007020d7812ULL, 0x040fe400078ec0ffULL,
0xfffffff802097812ULL, 0x000fce00078ec0ffULL, 0x0000000276068824ULL, 0x000fe400078e025eULL,
0x00000004ff078424ULL, 0x000fe200078e00ffULL, 0xfffffff80b0b7812ULL, 0x000fc600078ec0ffULL,
0x0000640006068625ULL, 0x000fe200078e0007ULL, 0x00000004ff6c7819ULL, 0x000fe20000011602ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x0000000806608981ULL, 0x000322000c1e1900ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000100008077811ULL, 0x002fe200078e68ffULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x000000080d087812ULL, 0x100fe400078ef802ULL, 0x0000000709097812ULL, 0x100fe400078ef802ULL,
0x000000070b067812ULL, 0x000fc600078ef802ULL, 0x00000001090b7824ULL, 0x040fe200078e020aULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000008090c7824ULL, 0x060fe400078e00ffULL,
0x0000000809157824ULL, 0x000fe400078e00ffULL, 0x000000020a707824ULL, 0x000fe200078e026cULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee20bULL, 0x00000001060b7824ULL, 0x000fc800078e020aULL,
0x000000100c107824ULL, 0x000fe400078e0207ULL, 0x00000008060c7824ULL, 0x000fc800078e00ffULL,
0x000000001010783bULL, 0x000e620000000200ULL, 0xfffffff80c0c7812ULL, 0x000fca00078ee20bULL,
0x000000100c0c7824ULL, 0x000fcc00078e0207ULL, 0x000000000c0c783bULL, 0x000ea20000000200ULL,
0x00000018ff447819ULL, 0x002fe20000011410ULL, 0x00010000100b7824ULL, 0x040fe200078e00ffULL,
0x0000888010457816ULL, 0x040fe200000000ffULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011411ULL, 0x0001000011147824ULL, 0x040fe200078e00ffULL,
0x0000888011477816ULL, 0x040fe200000000ffULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x00000018ff0b7819ULL, 0x000fc4000001140bULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff677819ULL, 0x000fe40000011412ULL, 0x00008880126a7816ULL, 0x000fe200000000ffULL,
0x0000001000777306ULL, 0x0003e20000200c00ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000018ff557819ULL, 0x004fe4000001140cULL, 0x000088800c547816ULL, 0x000fc400000000ffULL,
0x00000018ff517819ULL, 0x000fe20000011413ULL, 0x0000000b00467306ULL, 0x0004e20000200c00ULL,
0x0001000013107824ULL, 0x042fe200078e00ffULL, 0x0000888013507816ULL, 0x040fe200000000ffULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fe4000001140dULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000011004a7306ULL, 0x0003e20000200c00ULL,
0x00010000120b7824ULL, 0x044fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x000088800d5a7816ULL, 0x000fc400000000ffULL,
0x00000018ff0b7819ULL, 0x000fe4000001140bULL, 0x0000001000667306ULL, 0x0005e20000200c00ULL,
0x000000010a117810ULL, 0x002fe40007ffe0ffULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x00000018ff4f7819ULL, 0x000fe4000001140fULL, 0x000088800f4d7816ULL, 0x000fe200000000ffULL,
0x0000001200697306ULL, 0x0003e20000200c00ULL, 0x0000000109107824ULL, 0x104fe200078e0211ULL,
0x00000018ff577819ULL, 0x000fe2000001140eULL, 0x0000000106117824ULL, 0x000fe200078e0211ULL,
0x000088800e537816ULL, 0x000fc400000000ffULL, 0x000000020a0a7810ULL, 0x000fe40007ffe0ffULL,
0x00000014004b7306ULL, 0x0005e20000200c00ULL, 0xfffffff815127812ULL, 0x002fe200078ee210ULL,
0x0000001008157824ULL, 0x000fe200078e00ffULL, 0x000000080a00780cULL, 0x000fe20003f05270ULL,
0x000100000d107824ULL, 0x040fe400078e00ffULL, 0x0000001012127824ULL, 0x000fe400078e0207ULL,
0x0000000b006b7306ULL, 0x0003e20000200c00ULL, 0x0000000108147824ULL, 0x044fe200078e0270ULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x00000000121c783bULL, 0x000ea20000000200ULL,
0x000001000d0d7824ULL, 0x000fe200078e00ffULL, 0x0000000208707810ULL, 0x000fc40007ffe070ULL,
0xfffffff015147812ULL, 0x000fe200078ee214ULL, 0x00000010005b7306ULL, 0x000fe20000200c00ULL,
0x000100000c0b7824ULL, 0x042fe200078e00ffULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x000001000c0c7824ULL, 0x000fe400078e00ffULL, 0x0000001014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff0b7819ULL, 0x000fe4000001140bULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x0000004400447306ULL, 0x000e700000200c00ULL, 0x0000000c005c7306ULL, 0x0003f00000200c00ULL,
0x0000000b005d7306ULL, 0x0007e20000200c00ULL, 0x00000008060c7824ULL, 0x002fca00078e00ffULL,
0xfffffff80c0c7812ULL, 0x000fe400078ee211ULL, 0x0000001300657306ULL, 0x0003e20000200c00ULL,
0x000100000e0b7824ULL, 0x008fe200078e00ffULL, 0x000088801c3f7816ULL, 0x044fe200000000ffULL,
0x000100001c157824ULL, 0x000fe200078e00ffULL, 0x000088801d427816ULL, 0x000fe200000000ffULL,
0x000000100c107824ULL, 0x000fe200078e0207ULL, 0x00000018ff0b7819ULL, 0x000fe2000001140bULL,
0x000100000f0c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fe20000011415ULL,
0x000100001d437824ULL, 0x000fe200078e00ffULL, 0x000000001414783bULL, 0x000fe20000000200ULL,
0x0000000b00527306ULL, 0x0005e20000200c00ULL, 0x00000018ff497819ULL, 0x000fe2000001140cULL,
0x000001000f0f7824ULL, 0x000fe200078e00ffULL, 0x000000001010783bULL, 0x002e620000000200ULL,
0x00000018ff0c7819ULL, 0x000fe2000001141dULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x000001000e0e7824ULL, 0x000fe200078e00ffULL,
0x0000004800487306ULL, 0x000ee20000200c00ULL, 0x00000018ff0b7819ULL, 0x004fe2000001141cULL,
0x000001001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fc4000001140fULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000004700477306ULL, 0x000eb00000200c00ULL, 0x0000001c00407306ULL, 0x0005f00000200c00ULL,
0x0000006a006a7306ULL, 0x000ee20000200c00ULL, 0x00005410451c7816ULL, 0x004fc40000000046ULL,
0x00000018ff457819ULL, 0x000fe4000001141dULL, 0x00005410771d7816ULL, 0x000fe40000000044ULL,
0x000088801e447816ULL, 0x000fe200000000ffULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x000088801f777816ULL, 0x000fe400000000ffULL, 0x00000018ff0f7819ULL, 0x002fe20000011410ULL,
0x0000001c1438723cULL, 0x000b620000001838ULL, 0x00000018ff3e7819ULL, 0x000fc40000011413ULL,
0x00000018ff3c7819ULL, 0x000fe20000011411ULL, 0x0000000d00597306ULL, 0x0003e20000200c00ULL,
0x00000018ff3d7819ULL, 0x000fe40000011412ULL, 0x000100001e1c7824ULL, 0x020fe200078e00ffULL,
0x000054104a1d7816ULL, 0x008fe20000000048ULL, 0x000100001f4a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x00000018ff0d7819ULL, 0x002fe2000001141eULL, 0x000001001e1e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x0000001c00467306ULL, 0x0003f00000200c00ULL,
0x0000005000507306ULL, 0x000ee20000200c00ULL, 0x00005410471c7816ULL, 0x002fc4000000004bULL,
0x00000018ff4b7819ULL, 0x000fe4000001144aULL, 0x00008880104a7816ULL, 0x000fc600000000ffULL,
0x0000001c1434723cULL, 0x000b620000001834ULL, 0x0000001e00477306ULL, 0x0003ec0000200c00ULL,
0x00010000101d7824ULL, 0x020fe200078e00ffULL, 0x000054106a1c7816ULL, 0x000fe2000000006bULL,
0x00000010086b7824ULL, 0x000fe200078e00ffULL, 0x0000000e00567306ULL, 0x0005e20000200c00ULL,
0x00000100101e7824ULL, 0x002fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fc4000001141dULL,
0xfffffff06b707812ULL, 0x000fc800078ee270ULL, 0x0000001d00107306ULL, 0x0003e20000200c00ULL,
0x00000018ff0e7819ULL, 0x004fe2000001141fULL, 0x000001001f1f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff1f7819ULL, 0x000fe2000001141fULL, 0x0000005300537306ULL, 0x000ea20000200c00ULL,
0x00005410691d7816ULL, 0x002fe40000000067ULL, 0x00000018ff677819ULL, 0x000fe2000001141eULL,
0x00000010701e7824ULL, 0x000fc800078e00ffULL, 0x0000001c1430723cULL, 0x000b620000001830ULL,
0x0000001f004c7306ULL, 0x0003ec0000200c00ULL, 0x00005410501c7816ULL, 0x028fe40000000066ULL,
0x00005410651d7816ULL, 0x000fe20000000051ULL, 0x0000005500557306ULL, 0x000ee20000200c00ULL,
0x0000541053527816ULL, 0x004fe20000000052ULL, 0x0001000011657824ULL, 0x040fe200078e00ffULL,
0x0000888011667816ULL, 0x000fc600000000ffULL, 0x0000001c142c723cULL, 0x000b62000000182cULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x000000001e1c783bULL, 0x022e620000000200ULL,
0x0000005700577306ULL, 0x000ea20000200c00ULL, 0x000000ffff517224ULL, 0x000fe200078e0066ULL,
0x000054105c557816ULL, 0x008fcc0000000055ULL, 0x0000005400547306ULL, 0x000ee20000200c00ULL,
0x00000100115c7824ULL, 0x000fce00078e00ffULL, 0x0000005800587306ULL, 0x000e620000200c00ULL,
0x0000541056537816ULL, 0x004fe20000000057ULL, 0x0001000012567824ULL, 0x000fca00078e00ffULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x0000004f004f7306ULL, 0x000fe20000200c00ULL,
0x0000541054547816ULL, 0x008fe2000000005dULL, 0x000000521420723cULL, 0x040fec0000001820ULL,
0x0000005a005a7306ULL, 0x000ea40000200c00ULL, 0x000000541428723cULL, 0x000b6c0000001828ULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x0000541059557816ULL, 0x022fce0000000058ULL,
0x0000004900497306ULL, 0x000e620000200c00ULL, 0x000054105a547816ULL, 0x004fce000000005bULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x000000541424723cULL, 0x000b6e0000001824ULL,
0x0000000b000b7306ULL, 0x000ee20000200c00ULL, 0x000054104d527816ULL, 0x002fe40000000049ULL,
0x00000018ff547819ULL, 0x020fc4000001145cULL, 0x0000888012557816ULL, 0x000fc600000000ffULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x000054104e537816ULL, 0x004fce000000004fULL,
0x0000004100417306ULL, 0x000e620000200c00ULL, 0x000000521418723cULL, 0x000b6e0000001818ULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x0000541040157816ULL, 0x028fe2000000000bULL,
0x0000010012167824ULL, 0x000fe200078e00ffULL, 0x00008880130b7816ULL, 0x000fca00000000ffULL,
0x0000004300437306ULL, 0x000ea20000200c00ULL, 0x000054103f147816ULL, 0x002fce0000000041ULL,
0x0000000c000c7306ULL, 0x000fe20000200c00ULL, 0x000000141c38723cULL, 0x000b6e0000001838ULL,
0x0000004500457306ULL, 0x000e620000200c00ULL, 0x0000541042427816ULL, 0x004fe40000000043ULL,
0x00000018ff147819ULL, 0x020fca0000011416ULL, 0x0000000d000d7306ULL, 0x000ea20000200c00ULL,
0x0000541045437816ULL, 0x002fe2000000000cULL, 0x00010000130c7824ULL, 0x000fcc00078e00ffULL,
0x0000000e000e7306ULL, 0x000e620000200c00ULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x000000421c34723cULL, 0x000b660000001834ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x0000000f000f7306ULL, 0x000fe20000200c00ULL,
0x0000541047477816ULL, 0x004fce000000000dULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x000054104c497816ULL, 0x002fce000000000eULL, 0x0000003d003d7306ULL, 0x000ff00000200c00ULL,
0x0000003e003e7306ULL, 0x000ff00000200c00ULL, 0x0000004400447306ULL, 0x000e700000200c00ULL,
0x0000007700487306ULL, 0x000ff00000200c00ULL, 0x0000004b004b7306ULL, 0x000ea20000200c00ULL,
0x0000541044467816ULL, 0x002fce0000000046ULL, 0x0000004a004a7306ULL, 0x000e620000200c00ULL,
0x000000461c30723cULL, 0x000b6e0000001830ULL, 0x0000006700507306ULL, 0x000ee20000200c00ULL,
0x0000541048487816ULL, 0x004fce000000004bULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x000054104a0e7816ULL, 0x002fe20000000010ULL, 0x000000481c2c723cULL, 0x000b6c000000182cULL,
0x0000006500117306ULL, 0x000fe20000200c00ULL, 0x00005410500f7816ULL, 0x008fce000000000fULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x0000000e1c28723cULL, 0x000b6e0000001828ULL,
0x0000005500557306ULL, 0x000ff00000200c00ULL, 0x0000005600127306ULL, 0x000ea20000200c00ULL,
0x00005410540d7816ULL, 0x002fce000000003cULL, 0x0000001400147306ULL, 0x000ff00000200c00ULL,
0x0000000b000b7306ULL, 0x000fe20000200c00ULL, 0x0000541055127816ULL, 0x004fce0000000012ULL,
0x0000000c00167306ULL, 0x0002b00000200c00ULL, 0x0000001300177306ULL, 0x0006e20000200c00ULL,
0x00005410510c7816ULL, 0x002fe40000000011ULL, 0x000054100b167816ULL, 0x004fca0000000016ULL,
0x0000000c1c24723cULL, 0x000b620000001824ULL, 0x0000541014137816ULL, 0x008fe4000000003dULL,
0x0000541017177816ULL, 0x000fca000000003eULL, 0x000000121c20723cULL, 0x040b700000001820ULL,
0x000000161c18723cULL, 0x000b620000001818ULL, 0xfffff0b000000947ULL, 0x000fce000383ffffULL,
0x0000000331317220ULL, 0x0a0fe40000410000ULL, 0x0000000339397220ULL, 0x000fc40000410000ULL,
0x0000000334347220ULL, 0x080fe40000410000ULL, 0x0000000335357220ULL, 0x080fe40000410000ULL,
0x0000000330307220ULL, 0x080fe40000410000ULL, 0x000000032c067220ULL, 0x080fe40000410000ULL,
0x0000000328077220ULL, 0x080fe40000410000ULL, 0x00000003331f7220ULL, 0x000fc40000410000ULL,
0x000000032e087220ULL, 0x080fe40000410000ULL, 0x000000032a0a7220ULL, 0x080fe40000410000ULL,
0x0000000327157220ULL, 0x080fe40000410000ULL, 0x000000032d337220ULL, 0x080fe40000410000ULL,
0x000000032f097220ULL, 0x080fe40000410000ULL, 0x000000032b127220ULL, 0x000fc40000410000ULL,
0x00000003242a7220ULL, 0x080fe40000410000ULL, 0x00000003252e7220ULL, 0x080fe40000410000ULL,
0x0000000326147220ULL, 0x080fe40000410000ULL, 0x00000003230c7220ULL, 0x080fe40000410000ULL,
0x000000ffff277224ULL, 0x000fe400078e0031ULL, 0x0000000338137220ULL, 0x000fc40000410000ULL,
0x000000033a1e7220ULL, 0x080fe40000410000ULL, 0x000000033b167220ULL, 0x080fe40000410000ULL,
0x0000000336177220ULL, 0x080fe40000410000ULL, 0x0000000337377220ULL, 0x080fe40000410000ULL,
0x0000000332327220ULL, 0x080fe40000410000ULL, 0x0000000329297220ULL, 0x000fc40000410000ULL,
0x00000003202d7220ULL, 0x080fe40000410000ULL, 0x00000003212b7220ULL, 0x080fe40000410000ULL,
0x00000003220b7220ULL, 0x080fe40000410000ULL, 0x0000000318237220ULL, 0x080fe40000410000ULL,
0x0000000319247220ULL, 0x080fe40000410000ULL, 0x000000031a0d7220ULL, 0x000fc40000410000ULL,
0x000000031b1c7220ULL, 0x000fe40000410000ULL, 0x000000ffff257224ULL, 0x000fe400078e0039ULL,
0x000000ffff267224ULL, 0x000fe400078e0034ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0035ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0030ULL, 0x000000ffff287224ULL, 0x000fc400078e0006ULL,
0x000000ffff317224ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000073067f8cULL, 0x0002a2000c80043fULL, 0x000000ffff207224ULL, 0x000fe400078e0032ULL,
0x000000ffff307224ULL, 0x000fe400078e0037ULL, 0x000000ffff217224ULL, 0x000fe400078e0008ULL,
0x000000ffff327224ULL, 0x000fe400078e0009ULL, 0x000000ffff227224ULL, 0x000fc400078e000aULL,
0x000000ffff197224ULL, 0x000fe400078e000bULL, 0x000000ffff1a7224ULL, 0x000fe400078e000cULL,
0x000000ffff1b7224ULL, 0x000fc400078e000dULL, 0x0000000000087805ULL, 0x002fca0000015200ULL,
0x00000400730b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x006fe40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000000d0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400730b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004021d7824ULL, 0x000fe200078e00ffULL, 0x0000006d0400720cULL, 0x000fc80003f06070ULL,
0xfffffff01d077812ULL, 0x000fca00078ec0ffULL, 0x0000008000187824ULL, 0x000fca00078e0207ULL,
0x0174000018087984ULL, 0x0002a20000000c00ULL, 0x0000136000008947ULL, 0x000fea0003800000ULL,
0xffffff0005067810ULL, 0x000fe20007ffe0ffULL, 0x0000000202347824ULL, 0x000fe400078e00ffULL,
0x00000002ff497424ULL, 0x000fe200078e00ffULL, 0x0000000663057217ULL, 0x000fe40007800000ULL,
0x0000000634347812ULL, 0x000fc600078ec0ffULL, 0x0000000105057824ULL, 0x000fe200078e0a06ULL,
0x0000006402067211ULL, 0x000fe200078ff0ffULL, 0x00000001610c7824ULL, 0x000fe200078e0234ULL,
0x0000580034367a10ULL, 0x000fe40007ffe0ffULL, 0x00005a00ff077a19ULL, 0x000fe20000011606ULL,
0x000000010c0f7824ULL, 0x100fe200078e0a05ULL, 0x000000053600720cULL, 0x040fe20003f06070ULL,
0x00000001360d7824ULL, 0x000fe200078e0a05ULL, 0x0000000772077217ULL, 0x040fe40003800000ULL,
0x0000000f720f7217ULL, 0x000fc40003800000ULL, 0x0000000d720d7217ULL, 0x000fe20003800000ULL,
0x0000000762507224ULL, 0x000fe200078e02ffULL, 0x000000050c00720cULL, 0x000fe40003f26070ULL,
0x00000004ff0f7819ULL, 0x000fe4000001160fULL, 0x000000ff0d417207ULL, 0x000fe40000000000ULL,
0x000000ff0f0f7207ULL, 0x000fe40000800000ULL, 0x00000050410c7211ULL, 0x000fc400078fe0ffULL,
0x0000000806107810ULL, 0x000fe20007ffe0ffULL, 0x00000001500e7824ULL, 0x000fe200078e020fULL,
0x00000010343c7812ULL, 0x000fe200078efcffULL, 0x000060000c067625ULL, 0x080fe200078e0049ULL,
0x00005a00ff117a19ULL, 0x000fe40000011610ULL, 0x000058003c387a10ULL, 0x000fe20007ffe0ffULL,
0x000060000e0c7625ULL, 0x000fe200078e0049ULL, 0x0000001172117217ULL, 0x000fe20003800000ULL,
0x0000000806477981ULL, 0x0046a2000c1e9500ULL, 0x00000020343a7812ULL, 0x000fc600078efcffULL,
0x000000080c4e7981ULL, 0x0002a2000c1e9500ULL, 0x0000001162527224ULL, 0x000fe400078e02ffULL,
0x0000000138077824ULL, 0x148fe400078e0a05ULL, 0x0000000161067824ULL, 0x000fe200078e023cULL,
0x000000053800720cULL, 0x000fe20003f06070ULL, 0x000000010f107824ULL, 0x000fe200078e0252ULL,
0x0000000772077217ULL, 0x000fe20003800000ULL, 0x00000001060d7824ULL, 0x002fe200078e0a05ULL,
0x000058003a407a10ULL, 0x000fe20007ffe0ffULL, 0x0000600010107625ULL, 0x000fe200078e0049ULL,
0x00000052410e7211ULL, 0x000fc400078fe0ffULL, 0x000000ff07357207ULL, 0x000fe20000000000ULL,
0x00000001403b7824ULL, 0x000fe200078e0a05ULL, 0x0000000d720d7217ULL, 0x000fe20003800000ULL,
0x000060000e0e7625ULL, 0x000fe200078e0049ULL, 0x000000050600720cULL, 0x080fe20003f26070ULL,
0x00000008104c7981ULL, 0x0002e2000c1e9500ULL, 0x0000005035067211ULL, 0x000fe200078fe0ffULL,
0x0000000161447824ULL, 0x000fe200078e023aULL, 0x00000004ff0d7819ULL, 0x000fe2000001160dULL,
0x000000080e437981ULL, 0x0002e2000c1e9500ULL, 0x000000054000720cULL, 0x000fc40003f06070ULL,
0x0000003b723b7217ULL, 0x000fe20003800000ULL, 0x0000600006067625ULL, 0x000fc600078e0049ULL,
0x000000ff3b3b7207ULL, 0x000fe20000000000ULL, 0x00000001443d7824ULL, 0x040fe200078e0a05ULL,
0x0000000806377981ULL, 0x0002e4000c1e9500ULL, 0x000000ff0d0f7207ULL, 0x002fe40000800000ULL,
0x000000054400720cULL, 0x000fe40003f26070ULL, 0x0000003034447812ULL, 0x000fe200078efcffULL,
0x00000001500c7824ULL, 0x000fe200078e020fULL, 0x00000052350e7211ULL, 0x000fe200078fe0ffULL,
0x000000010f107824ULL, 0x000fe200078e0252ULL, 0x0000003d723d7217ULL, 0x000fc40003800000ULL,
0x000000503b067211ULL, 0x000fe200078fe0ffULL, 0x0000000161547824ULL, 0x000fe200078e0244ULL,
0x00000004ff3d7819ULL, 0x000fe2000001163dULL, 0x000060000c0c7625ULL, 0x000fe200078e0049ULL,
0x0000580044467a10ULL, 0x000fc60007ffe0ffULL, 0x000060000e0e7625ULL, 0x000fc800078e0049ULL,
0x0000600010107625ULL, 0x080fe200078e0049ULL, 0x000000ff3d3f7207ULL, 0x000fe20000800000ULL,
0x000000080c3e7981ULL, 0x0002e4000c1e9500ULL, 0x0000600006067625ULL, 0x000fe400078e0049ULL,
0x000000080e397981ULL, 0x0002e4000c1e9500ULL, 0x0000000154457824ULL, 0x000fe400078e0a05ULL,
0x0000000810427981ULL, 0x0002e8000c1e9500ULL, 0x00000008063d7981ULL, 0x0002e2000c1e9500ULL,
0x0000004572457217ULL, 0x000fe20003800000ULL, 0x00000001500c7824ULL, 0x002fe200078e023fULL,
0x000000523b0e7211ULL, 0x000fe200078fe0ffULL, 0x000000013f107824ULL, 0x000fc400078e0252ULL,
0x0000000146077824ULL, 0x040fe200078e0a05ULL, 0x000000054600720cULL, 0x000fe20003f06070ULL,
0x000060000c0c7625ULL, 0x000fe200078e0049ULL, 0x000000055400720cULL, 0x000fe40003f26070ULL,
0x0000000772077217ULL, 0x000fe20003800000ULL, 0x000060000e0e7625ULL, 0x080fe200078e0049ULL,
0x00000004ff067819ULL, 0x000fe20000011645ULL, 0x000000080c487981ULL, 0x0002e4000c1e9500ULL,
0x0000600010107625ULL, 0x000fe200078e0049ULL, 0x000000ff07457207ULL, 0x000fe20000000000ULL,
0x000000080e3f7981ULL, 0x0002e2000c1e9500ULL, 0x000000ff064b7207ULL, 0x000fc60000800000ULL,
0x00000008104a7981ULL, 0x0002e2000c1e9500ULL, 0x0000005045067211ULL, 0x000fe200078fe0ffULL,
0x00000001500c7824ULL, 0x002fc800078e024bULL, 0x0000600006067625ULL, 0x000fc800078e0049ULL,
0x000060000c0c7625ULL, 0x000fe400078e0049ULL, 0x0000000806067981ULL, 0x0002e2000c1e9500ULL,
0x00000052450e7211ULL, 0x000fc600078fe0ffULL, 0x000000080c0d7981ULL, 0x0002e2000c1e9500ULL,
0x000000014b107824ULL, 0x000fe400078e0252ULL, 0x000060000e0e7625ULL, 0x000fc800078e0049ULL,
0x0000600010107625ULL, 0x000fe400078e0049ULL, 0x000000080e0e7981ULL, 0x0002e8000c1e9500ULL,
0x0000000810117981ULL, 0x0004e2000c1e9500ULL, 0xfffffff041507812ULL, 0x000fe200078ec0ffULL,
0x00000001ff417424ULL, 0x000fc800078e00ffULL, 0x0000000105077824ULL, 0x002fe200078e0250ULL,
0x0000000834507812ULL, 0x000fc600078efcffULL, 0x0000000136587824ULL, 0x100fe200078e0a07ULL,
0x0000000934547812ULL, 0x000fe400078efcffULL, 0x0000580050527a10ULL, 0x000fe40007ffe0ffULL,
0x0000005841587219ULL, 0x000fe400000006ffULL, 0x00005800540c7a10ULL, 0x000fe20007ffe0ffULL,
0x00000001525a7824ULL, 0x000fc800078e0a07ULL, 0x000000010c5c7824ULL, 0x000fe200078e0a07ULL,
0x0000005a415a7219ULL, 0x000fe400000006ffULL, 0xfffffff035497812ULL, 0x000fe400078ec0ffULL,
0x0000005c415c7219ULL, 0x000fe400000006ffULL, 0x00000018347c7812ULL, 0x040fe200078efcffULL,
0x0000000105497824ULL, 0x000fe200078e0249ULL, 0x00000019347a7812ULL, 0x000fc600078efcffULL,
0x0000000138517824ULL, 0x000fe200078e0a49ULL, 0x000058007a0f7a10ULL, 0x000fe40007ffe0ffULL,
0xfffffff03b4b7812ULL, 0x000fc600078ec0ffULL, 0x000000010f577824ULL, 0x000fe400078e0a49ULL,
0x00000001054b7824ULL, 0x000fe200078e024bULL, 0x00000021346a7812ULL, 0x000fc600078efcffULL,
0x0000000140597824ULL, 0x000fe200078e0a4bULL, 0x0000002834667812ULL, 0x000fe400078efcffULL,
0xfffffff045457812ULL, 0x000fe400078ec0ffULL, 0x0000005741577219ULL, 0x000fe400000006ffULL,
0x000058006a787a10ULL, 0x000fe20007ffe0ffULL, 0x00000001054d7824ULL, 0x000fe200078e0245ULL,
0x0000580066707a10ULL, 0x000fc60007ffe0ffULL, 0x00000001785b7824ULL, 0x100fe400078e0a4bULL,
0x00000001705d7824ULL, 0x000fe400078e0a4bULL, 0x00000001464f7824ULL, 0x000fca00078e0a4dULL,
0x0000004f414f7219ULL, 0x000fe400000006ffULL, 0x0000541047477816ULL, 0x004fe4000000004eULL,
0x00000001344e7812ULL, 0x000fe400078efcffULL, 0x0000004758ff7212ULL, 0x000fe4000780c0ffULL,
0x000058004e567a10ULL, 0x000fe40007ffe0ffULL, 0x000000053600720cULL, 0x000fc60000701470ULL,
0x0000000156107824ULL, 0x000fe200078e0a07ULL, 0x000000053400720cULL, 0x040fe40000701070ULL,
0x0000001134077812ULL, 0x000fe400078efcffULL, 0x0000001041107219ULL, 0x000fe400000006ffULL,
0x000000475aff7212ULL, 0x080fe4000784c0ffULL, 0x0000004710ff7212ULL, 0x080fe4000786c0ffULL,
0x000000475cff7212ULL, 0x000fc4000782c0ffULL, 0x0000541043437816ULL, 0x008fe4000000004cULL,
0xff80000013137808ULL, 0x000fe40000000000ULL, 0x0000004358ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004310ff7212ULL, 0x080fe400078ac0ffULL, 0x000000435aff7212ULL, 0x080fe400078cc0ffULL,
0x000000435cff7212ULL, 0x000fc4000780c0ffULL, 0x0000580007477a10ULL, 0x000fe40007ffe0ffULL,
0x000058007c437a10ULL, 0x000fe40007ffe0ffULL, 0x000000053600720cULL, 0x080fe20002781470ULL,
0x0000000147537824ULL, 0x100fe200078e0a49ULL, 0x000000055200720cULL, 0x080fe200037c1470ULL,
0x0000000143557824ULL, 0x000fe200078e0a49ULL, 0x000000050c00720cULL, 0x000fe40000701470ULL,
0x0000005141497219ULL, 0x000fc400000006ffULL, 0x0000005341517219ULL, 0x040fe400000006ffULL,
0x000000053400720cULL, 0x080fe40002781070ULL, 0x000000055000720cULL, 0x080fe400037c1070ULL,
0x000000055400720cULL, 0x000fe40000701070ULL, 0x0000005541537219ULL, 0x000fe400000006ffULL,
0x00005410373e7816ULL, 0x000fc4000000003eULL, 0x000000050c00720cULL, 0x000fe40000f21470ULL,
0xff8000001e1e7808ULL, 0x000fe40002000000ULL, 0x0000541039427816ULL, 0x000fe40000000042ULL,
0xff80000017177808ULL, 0x000fe40003000000ULL, 0xff80000030307808ULL, 0x000fe40000000000ULL,
0x0000003e49ff7212ULL, 0x000fc4000788c0ffULL, 0x0000004249ff7212ULL, 0x080fe400078cc0ffULL,
0x0000004253ff7212ULL, 0x000fe4000780c0ffULL, 0x000000055400720cULL, 0x080fe40000f21070ULL,
0x000000055600720cULL, 0x0c0fe40001f61470ULL, 0x000000055600720cULL, 0x080fe40002fa1470ULL,
0x000000055200720cULL, 0x000fc40001741470ULL, 0x000000053800720cULL, 0x0c0fe40002781470ULL,
0x000000053800720cULL, 0x080fe400037c1470ULL, 0x000000054300720cULL, 0x080fe40000701470ULL,
0xff8000002f2f7808ULL, 0x000fe40000800000ULL, 0x00000029345c7812ULL, 0x000fe400078efcffULL,
0x000000054e00720cULL, 0x000fc40001f61070ULL, 0x000000054e00720cULL, 0x080fe40002fa1070ULL,
0x000000055000720cULL, 0x080fe40001741070ULL, 0x000000053c00720cULL, 0x0c0fe40002721070ULL,
0x000000053c00720cULL, 0x080fe400037c1070ULL, 0x000000057c00720cULL, 0x000fe40000701070ULL,
0x0000005941557219ULL, 0x000fc400000006ffULL, 0x000054103d487816ULL, 0x000fe40000000048ULL,
0x000054103f4a7816ULL, 0x000fe4000000004aULL, 0x000058005c6c7a10ULL, 0x000fe40007ffe0ffULL,
0xff80000025257808ULL, 0x000fe40001800000ULL, 0xff80000016167808ULL, 0x000fe40002800000ULL,
0xff80000026267808ULL, 0x000fc40001000000ULL, 0xff8000002c2c7808ULL, 0x000fe40000800000ULL,
0xff80000020207808ULL, 0x000fe40003000000ULL, 0xff80000021217808ULL, 0x000fe40000000000ULL,
0x0000003e51ff7212ULL, 0x080fe4000786c0ffULL, 0x0000003e53ff7212ULL, 0x080fe400078ac0ffULL,
0x0000003e57ff7212ULL, 0x000fc4000784c0ffULL, 0x0000004251ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004257ff7212ULL, 0x000fe4000782c0ffULL, 0x0000004855ff7212ULL, 0x040fe400078cc0ffULL,
0x0000004a55ff7212ULL, 0x000fe2000780c0ffULL, 0x000000016c657824ULL, 0x000fe200078e0a4bULL,
0x000000054700720cULL, 0x0c0fe40001f61470ULL, 0x000000054700720cULL, 0x000fc40002781470ULL,
0x000000054300720cULL, 0x080fe40002fa1470ULL, 0x000000050f00720cULL, 0x0c0fe40001741470ULL,
0x000000050f00720cULL, 0x080fe40000f21470ULL, 0x000000054000720cULL, 0x0c0fe400037c1470ULL,
0x000000054000720cULL, 0x000fe40000701470ULL, 0x0000003134587812ULL, 0x000fc400078efcffULL,
0x00000038344c7812ULL, 0x040fe400078efcffULL, 0x0000003934107812ULL, 0x000fe400078efcffULL,
0x0000005b41597219ULL, 0x000fe400000006ffULL, 0x000000050700720cULL, 0x0c0fe40001f61070ULL,
0x000000050700720cULL, 0x080fe40002781070ULL, 0x000000057c00720cULL, 0x000fc40002fa1070ULL,
0x000000057a00720cULL, 0x0c0fe40001741070ULL, 0x000000057a00720cULL, 0x080fe40000f21070ULL,
0x000000053a00720cULL, 0x0c0fe400037c1070ULL, 0x000000053a00720cULL, 0x000fe40000701070ULL,
0x0000005d415b7219ULL, 0x040fe400000006ffULL, 0x0000006541657219ULL, 0x000fc400000006ffULL,
0x0000541006067816ULL, 0x000fe4000000000dULL, 0x00005800585a7a10ULL, 0x000fe40007ffe0ffULL,
0x000058004c357a10ULL, 0x000fe40007ffe0ffULL, 0x00005800103b7a10ULL, 0x000fe40007ffe0ffULL,
0xff80000027277808ULL, 0x000fe40001800000ULL, 0xff8000001f1f7808ULL, 0x000fc40002000000ULL,
0xff80000028287808ULL, 0x000fe40002800000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fe40000800000ULL, 0xff80000031317808ULL, 0x000fe40003000000ULL,
0xff80000022227808ULL, 0x000fe40000000000ULL, 0x0000004859ff7212ULL, 0x000fc4000786c0ffULL,
0x000000485bff7212ULL, 0x080fe4000788c0ffULL, 0x0000004865ff7212ULL, 0x000fe400078ac0ffULL,
0x0000004a59ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004a5bff7212ULL, 0x080fe4000782c0ffULL,
0x0000004a65ff7212ULL, 0x000fe400078cc0ffULL, 0x000000064fff7212ULL, 0x000fe2000780c0ffULL,
0x000000015a4b7824ULL, 0x100fe200078e0a4dULL, 0x000000057800720cULL, 0x0c0fe20001f61470ULL,
0x0000000135457824ULL, 0x100fe200078e0a4dULL, 0x000000057800720cULL, 0x080fe20001741470ULL,
0x000000013b4d7824ULL, 0x000fe200078e0a4dULL, 0x000000057000720cULL, 0x000fc40002781470ULL,
0x000000057000720cULL, 0x080fe40000f21470ULL, 0x000000056c00720cULL, 0x0c0fe40002fa1470ULL,
0x000000056c00720cULL, 0x080fe400037c1470ULL, 0x000000054600720cULL, 0x080fe40000701470ULL,
0x000000056a00720cULL, 0x0c0fe40001f61070ULL, 0x000000056a00720cULL, 0x000fc40001741070ULL,
0x000000056600720cULL, 0x0c0fe40002781070ULL, 0x000000056600720cULL, 0x080fe40000f21070ULL,
0x000000055c00720cULL, 0x0c0fe40002fa1070ULL, 0x000000055c00720cULL, 0x080fe400037c1070ULL,
0x000000054400720cULL, 0x000fe40000701070ULL, 0x0000004b414b7219ULL, 0x000fc400000006ffULL,
0x0000004541457219ULL, 0x040fe400000006ffULL, 0x0000004d414d7219ULL, 0x000fe400000006ffULL,
0x000054100e0e7816ULL, 0x000fe40000000011ULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff80000012127808ULL, 0x000fe40001000000ULL, 0xff8000002a2a7808ULL, 0x000fc40002000000ULL,
0xff80000014147808ULL, 0x000fe40000800000ULL, 0xff8000002e2e7808ULL, 0x000fe40002800000ULL,
0xff80000015157808ULL, 0x000fe40003000000ULL, 0xff8000002d2d7808ULL, 0x000fe40000000000ULL,
0x000000064bff7212ULL, 0x080fe4000786c0ffULL, 0x0000000645ff7212ULL, 0x000fc4000784c0ffULL,
0x000000064dff7212ULL, 0x000fe4000788c0ffULL, 0x0000000e4fff7212ULL, 0x080fe4000782c0ffULL,
0x0000000e4bff7212ULL, 0x080fe400078ac0ffULL, 0x0000000e45ff7212ULL, 0x080fe400078cc0ffULL,
0x0000000e4dff7212ULL, 0x000fe4000780c0ffULL, 0x000000054600720cULL, 0x000fc40000f21470ULL,
0x000000055a00720cULL, 0x0c0fe40001f61470ULL, 0x000000055a00720cULL, 0x080fe40002fa1470ULL,
0x000000053500720cULL, 0x0c0fe40001741470ULL, 0x000000053500720cULL, 0x080fe400037c1470ULL,
0x000000053b00720cULL, 0x0c0fe40002781470ULL, 0x000000053b00720cULL, 0x000fc40000701470ULL,
0x000000054400720cULL, 0x080fe40000f21070ULL, 0x000000055800720cULL, 0x0c0fe40001f61070ULL,
0x000000055800720cULL, 0x080fe40002fa1070ULL, 0x000000054c00720cULL, 0x0c0fe40001741070ULL,
0x000000054c00720cULL, 0x080fe400037c1070ULL, 0x000000051000720cULL, 0x000fc40002781070ULL,
0x000000051000720cULL, 0x000fe40000701070ULL, 0xff8000002b2b7808ULL, 0x000fe40001800000ULL,
0xff80000023237808ULL, 0x000fe40001000000ULL, 0xff80000024247808ULL, 0x000fe40002000000ULL,
0xff80000019197808ULL, 0x000fe40000800000ULL, 0xff8000001a1a7808ULL, 0x000fc40002800000ULL,
0xff8000001b1b7808ULL, 0x000fe40003000000ULL, 0xff8000001c1c7808ULL, 0x000fc40000000000ULL,
0x000000130800720bULL, 0x004fe40003f1e000ULL, 0x0000001e0900720bULL, 0x000fe40003f3e000ULL,
0x0000000813087208ULL, 0x000fe40004000000ULL, 0x000000091e097208ULL, 0x000fe40004800000ULL,
0x000000250800720bULL, 0x000fc40003f1e000ULL, 0x000000160900720bULL, 0x000fe40003f3e000ULL,
0x0000000825057208ULL, 0x000fe40004000000ULL, 0x0000000916067208ULL, 0x000fe40004800000ULL,
0x000000260500720bULL, 0x000fe40003f1e000ULL, 0x000000170600720bULL, 0x000fe40003f3e000ULL,
0x0000000526087208ULL, 0x000fc40004000000ULL, 0x0000000617057208ULL, 0x000fe40004800000ULL,
0x0000002f0800720bULL, 0x000fe40003f1e000ULL, 0x000000300500720bULL, 0x000fe40003f3e000ULL,
0x000000082f077208ULL, 0x000fe40004000000ULL, 0x0000000530057208ULL, 0x000fe40004800000ULL,
0x0000002c0700720bULL, 0x000fc40003f1e000ULL, 0x000000200500720bULL, 0x000fe40003f3e000ULL,
0x000000072c067208ULL, 0x000fe40004000000ULL, 0x0000000520087208ULL, 0x000fe40004800000ULL,
0x000000270600720bULL, 0x000fe40003f1e000ULL, 0x0000001f0800720bULL, 0x000fe40003f3e000ULL,
0x0000000627057208ULL, 0x000fc40004000000ULL, 0x000000081f087208ULL, 0x000fe40004800000ULL,
0x000000280500720bULL, 0x000fe40003f1e000ULL, 0x000000210800720bULL, 0x000fe40003f3e000ULL,
0x0000000528067208ULL, 0x000fe40004000000ULL, 0x0000000821057208ULL, 0x000fe40004800000ULL,
0x000000330600720bULL, 0x000fc40003f1e000ULL, 0x000000320500720bULL, 0x000fe40003f3e000ULL,
0x0000000633067208ULL, 0x000fe40004000000ULL, 0x0000000532057208ULL, 0x000fe40004800000ULL,
0x000000310600720bULL, 0x000fe40003f1e000ULL, 0x000000220500720bULL, 0x000fe40003f3e000ULL,
0x0000000631067208ULL, 0x000fc40004000000ULL, 0x0000000522057208ULL, 0x000fe40004800000ULL,
0x000000290600720bULL, 0x000fe40003f1e000ULL, 0x000000120500720bULL, 0x000fe40003f3e000ULL,
0x0000000629077208ULL, 0x000fe40004000000ULL, 0x0000000512057208ULL, 0x000fe40004800000ULL,
0x0000002a0700720bULL, 0x000fc40003f1e000ULL, 0x000000140500720bULL, 0x000fe40003f3e000ULL,
0x000000072a077208ULL, 0x000fe40004000000ULL, 0x0000000514067208ULL, 0x000fe40004800000ULL,
0x0000002e0700720bULL, 0x000fe40003f1e000ULL, 0x000000150600720bULL, 0x000fe40003f3e000ULL,
0x000000072e087208ULL, 0x000fc40004000000ULL, 0x0000000615067208ULL, 0x000fe40004800000ULL,
0x0000002d0800720bULL, 0x000fe40003f1e000ULL, 0x000000190600720bULL, 0x000fe40003f3e000ULL,
0x000000082d087208ULL, 0x000fe40004000000ULL, 0x0000000619057208ULL, 0x000fe40004800000ULL,
0x0000002b0800720bULL, 0x000fc40003f1e000ULL, 0x0000001a0500720bULL, 0x000fe40003f3e000ULL,
0x000000082b087208ULL, 0x000fe40004000000ULL, 0x000000051a067208ULL, 0x000fe40004800000ULL,
0x000000230800720bULL, 0x000fe40003f1e000ULL, 0x0000001b0600720bULL, 0x000fe40003f3e000ULL,
0x0000000823057208ULL, 0x000fc40004000000ULL, 0x000000061b077208ULL, 0x000fe40004800000ULL,
0x000000240500720bULL, 0x000fe40003f1e000ULL, 0x0000001c0700720bULL, 0x000fe40003f3e000ULL,
0x00000005240d7208ULL, 0x000fe40004000000ULL, 0x000000071c0f7208ULL, 0x000fe20004800000ULL,
0x000016b27f007947ULL, 0x000fec000b800000ULL, 0x0c401f000d057f89ULL, 0x0004e400000e0000ULL,
0x000000050d00720bULL, 0x008fc80003f1e000ULL, 0x0000000d05117208ULL, 0x000fe20004000000ULL,
0x000016e27f007947ULL, 0x000fea000b800000ULL, 0x0c401f000f057f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a097f89ULL, 0x000e6800000e0000ULL, 0x0c401f000b067f89ULL, 0x000ea800000e0000ULL,
0x0c201f0011087f89ULL, 0x000ea200000e0000ULL, 0x000000050f00720bULL, 0x008fc40003f1e000ULL,
0x000000090a00720bULL, 0x002fe40003f3e000ULL, 0x0000000f05077208ULL, 0x000fe40004000000ULL,
0x0000000a090c7208ULL, 0x000fe40004800000ULL, 0x000000060b00720bULL, 0x004fe20003f1e000ULL,
0x0c201f00070e7f89ULL, 0x000e6600000e0000ULL, 0x0000000b06057208ULL, 0x000fe20004000000ULL,
0x0c201f000c0d7f89ULL, 0x000ea200000e0000ULL, 0x000000081100720bULL, 0x000fc60003f1e000ULL,
0x0c201f0005067f89ULL, 0x0006e200000e0000ULL, 0x0000001108087208ULL, 0x000fe40004000000ULL,
0x0000000e0700720bULL, 0x002fe40003f3e000ULL, 0x0000000d0c00720bULL, 0x004fe40003f5e000ULL,
0x000000070e097208ULL, 0x000fe40004800000ULL, 0x0000000c0d0a7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b080c7820ULL, 0x008fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000c1d1d7812ULL, 0x000fc400078ec0ffULL, 0x3fb8aa3b280b7823ULL, 0x100fe2000001080cULL,
0x0000000302ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b13137823ULL, 0x100fe2000001080cULL,
0x000000060500720bULL, 0x000fe20003f3e000ULL, 0x0000000b00367308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b25257823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b26267823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080cULL,
0x0000001300137308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b230b7823ULL, 0x004fc4000001080cULL,
0x3fb8aa3b09237820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b27077823ULL, 0x000fe4000001080cULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010823ULL, 0x00000025000e7308ULL, 0x0022a20000000800ULL,
0x3fb8aa3b17177823ULL, 0x100fe40000010823ULL, 0x3fb8aa3b30307823ULL, 0x100fe40000010823ULL,
0x3fb8aa3b16167823ULL, 0x000fc40000010823ULL, 0x3fb8aa3b2a277823ULL, 0x100fe2000001080cULL,
0x00000026000d7308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x000fe40000010823ULL,
0x3fb8aa3b33337823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b31257823ULL, 0x002fe2000001080cULL,
0x00000002ff317819ULL, 0x000fe20000011602ULL, 0x3fb8aa3b29287823ULL, 0x100fe2000001080cULL,
0x0000002f00107308ULL, 0x0002a20000000800ULL, 0x3fb8aa3b2b267823ULL, 0x108fe2000001080cULL,
0x00000008313a7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b242a7823ULL, 0x000fc4000001080cULL,
0x3fb8aa3b20207823ULL, 0x100fe40000010823ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010823ULL,
0x0000001e001e7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b32327823ULL, 0x100fe20000010823ULL,
0x00000002312f7810ULL, 0x002fe20007ffe0ffULL, 0x3fb8aa3b122b7823ULL, 0x100fe40000010823ULL,
0x3fb8aa3b22227823ULL, 0x100fe40000010823ULL, 0x3fb8aa3b19197823ULL, 0x100fe20000010823ULL,
0x00000016000f7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b1a1a7823ULL, 0x000fc40000010823ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe40000010823ULL, 0x3fb8aa3b1c1c7823ULL, 0x000fe40000010823ULL,
0x0000000831387824ULL, 0x000fe200078e00ffULL, 0x0000001700177308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000ef00000000800ULL, 0x0000002c00347308ULL, 0x0003f00000000800ULL,
0x0000000700357308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b2e2c7823ULL, 0x002fc4000001080cULL,
0x3fb8aa3b152e7823ULL, 0x000fca0000010823ULL, 0x0000001f00297308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b2d077823ULL, 0x004fe2000001080cULL, 0x000000130e0c723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b142d7823ULL, 0x000fe20000010823ULL, 0x0000000d100e723eULL, 0x000fe400000000ffULL,
0x0000001e0f0d723eULL, 0x000fe200000000ffULL, 0x3c003c00ff1e7424ULL, 0x000fe200078e00ffULL,
0x00000017300f723eULL, 0x008fe200000000ffULL, 0x3c003c00ff1f7424ULL, 0x002fe200078e00ffULL,
0x0000003300337308ULL, 0x000e620000000800ULL, 0x000000343514723eULL, 0x000fe200000000ffULL,
0x0000000831307824ULL, 0x000fc800078e00ffULL, 0x0000001e0c10723cULL, 0x000f6400000018ffULL,
0x0000002000207308ULL, 0x000eb00000000800ULL, 0x0000002100217308ULL, 0x000fe20000000800ULL,
0x000000363316723eULL, 0x002fe200000000ffULL, 0x0000000831367824ULL, 0x000fcc00078e00ffULL,
0x0000003200327308ULL, 0x000e620000000800ULL, 0x000000202915723eULL, 0x004fe400000000ffULL,
0x0000000131297810ULL, 0x000fc80007ffe0ffULL, 0xfffffff830307812ULL, 0x000fe200078ee229ULL,
0x0000002200247308ULL, 0x0005e20000000800ULL, 0x0000000831297824ULL, 0x000fe200078e00ffULL,
0x000000213217723eULL, 0x002fcc00000000ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x0000000831327824ULL, 0x040fe200078e00ffULL, 0x0000001e1420723cULL, 0x024b680000001810ULL,
0xfffffff832327812ULL, 0x000fe400078ee22fULL, 0x0000002800287308ULL, 0x000e620000000800ULL,
0x0000000831137824ULL, 0x060fe200078e00ffULL, 0x0000000331107810ULL, 0x000fcc0007ffe0ffULL,
0x0000002700277308ULL, 0x000fe20000000800ULL, 0x0000000431117810ULL, 0x000fe40007ffe0ffULL,
0xfffffff813347812ULL, 0x000fe400078ee210ULL, 0xfffffff836367812ULL, 0x000fc600078ee211ULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x000000252810723eULL, 0x002fe200000000ffULL,
0x0000000831287824ULL, 0x040fe200078e00ffULL, 0x0000000631257810ULL, 0x000fc80007ffe0ffULL,
0xfffffff828287812ULL, 0x000fe200078ee231ULL, 0x0000002b002b7308ULL, 0x000e700000000800ULL,
0x0000002d002d7308ULL, 0x000fe20000000800ULL, 0x000000272c12723eULL, 0x004fc400000000ffULL,
0xffffffff31277810ULL, 0x000fc80007ffe0ffULL, 0xfffffff838387812ULL, 0x000fe200078ee227ULL,
0x0000002e002e7308ULL, 0x000ea20000000800ULL, 0x000000242b11723eULL, 0x002fe200000000ffULL,
0x000000083a2b7824ULL, 0x000fe200078e00ffULL, 0x0000000531247810ULL, 0x000fc80007ffe0ffULL,
0xfffffff8292c7812ULL, 0x000fe200078ee224ULL, 0x0000000700077308ULL, 0x000fe20000000800ULL,
0xfffffff82b3a7812ULL, 0x000fe400078ee23aULL, 0x0000002d2e13723eULL, 0x004fca00000000ffULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x00000008312e7824ULL, 0x000fe200078e00ffULL,
0x0000001e1020723cULL, 0x000f680000001820ULL, 0xfffffff82e2e7812ULL, 0x000fe400078ee225ULL,
0x0000000b000b7308ULL, 0x000ff00000000800ULL, 0x0000002a002a7308ULL, 0x000ea20000000800ULL,
0x000000072624723eULL, 0x002fc400000000ffULL, 0x0001100000077811ULL, 0x000fca00078e58ffULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x0000001028287824ULL, 0x100fe400078e0207ULL,
0x0000001030307824ULL, 0x100fe400078e0207ULL, 0x0000001032327824ULL, 0x100fe400078e0207ULL,
0x0000001034347824ULL, 0x100fe200078e0207ULL, 0x0000001a001a7308ULL, 0x000e620000000800ULL,
0x0000000b2a26723eULL, 0x004fe200000000ffULL, 0x0000001036367824ULL, 0x000fc400078e0207ULL,
0x00000001280b7824ULL, 0x000fe400078e021dULL, 0x000000102c2c7824ULL, 0x100fe400078e0207ULL,
0x0000001b001b7308ULL, 0x000fe20000000800ULL, 0x000000011d307824ULL, 0x040fe200078e0230ULL,
0x0000000c0b007388ULL, 0x0005e20000000800ULL, 0x000000102e2e7824ULL, 0x100fe400078e0207ULL,
0x000000011d327824ULL, 0x040fe200078e0232ULL, 0x0000000e30007388ULL, 0x0007e20000000800ULL,
0x0000001038387824ULL, 0x100fe200078e0207ULL, 0x0000001c001c7308ULL, 0x000ee20000000800ULL,
0x000000191a25723eULL, 0x002fe200000000ffULL, 0x000000011d347824ULL, 0x040fe200078e0234ULL,
0x0000001432007388ULL, 0x0003e20000000800ULL, 0x000000103a3a7824ULL, 0x000fe200078e0207ULL,
0x00000005060b7208ULL, 0x004fe20004800000ULL, 0x000000011d367824ULL, 0x040fe200078e0236ULL,
0x0000001634007388ULL, 0x0003e20000000800ULL, 0x000000011d2c7824ULL, 0x000fc400078e022cULL,
0x000000011d2e7824ULL, 0x040fe200078e022eULL, 0x0000001036007388ULL, 0x0003e20000000800ULL,
0x000000011d387824ULL, 0x040fe400078e0238ULL, 0x000000011d3a7824ULL, 0x000fe200078e023aULL,
0x000000122c007388ULL, 0x0003e20000000800ULL, 0x0000001b1c27723eULL, 0x008fc600000000ffULL,
0x000000242e007388ULL, 0x0003e80000000800ULL, 0x0000001e2420723cULL, 0x020f620000001820ULL,
0x0000002638007388ULL, 0x0003e80000000800ULL, 0x0000000d3a007388ULL, 0x0003e80000000800ULL,
0x0004000f30007388ULL, 0x0003e80000000800ULL, 0x0004001532007388ULL, 0x0003e80000000800ULL,
0x0004001734007388ULL, 0x0003e80000000800ULL, 0x0004001136007388ULL, 0x0003e60000000800ULL,
0x000000ffff217224ULL, 0x020fe200078e0022ULL, 0x000400132c007388ULL, 0x0003e80000000800ULL,
0x000400252e007388ULL, 0x0003e80000000800ULL, 0x0004002738007388ULL, 0x0003e80000000800ULL,
0x0170000818008388ULL, 0x0003e80000000c00ULL, 0x0172002018008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000074ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080074ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100074ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000104047810ULL, 0x000fe20007ffe0ffULL,
0x0000180074ff7f8cULL, 0x0003e4000c80043fULL, 0x000000ffff117224ULL, 0x002fe200078e005fULL,
0x0000006e0400720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffab3000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff347807ULL, 0x008fe20004000000ULL, 0xffffffffff417424ULL, 0x000fe200078e00ffULL,
0x00013b2000357802ULL, 0x000fc40000000f00ULL, 0x00000f4000007944ULL, 0x012fea0003c00000ULL,
0xfffeeaa000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe20005000000ULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x00013b7000357802ULL, 0x000fc40000000f00ULL,
0x00000ef000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e0040ULL,
0xfffeead000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e000fULL,
0x00013be000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff427424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000e3000007944ULL, 0x012fea0003c00000ULL,
0xfffeeba000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e000fULL,
0x00013c4000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff427424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000dd000007944ULL, 0x012fea0003c00000ULL,
0xfffeeca000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0002ULL,
0x00013cb000417802ULL, 0x000fe20000000f00ULL, 0x000000ffff347224ULL, 0x000fe400078e000bULL,
0x0000001fff427424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x00000d6000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0040ULL,
0xfffef0a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0002ULL,
0x00013d2000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff427424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000cf000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e0040ULL, 0xfffef06000007947ULL, 0x000fea000383ffffULL,
0x00000001ff347807ULL, 0x004fe20004000000ULL, 0xffffffffff417424ULL, 0x000fe200078e00ffULL,
0x00013d8000357802ULL, 0x000fc40000000f00ULL, 0x00000ce000007944ULL, 0x008fea0003c00000ULL,
0xffff104000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe20005000000ULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x00013dd000357802ULL, 0x000fc40000000f00ULL,
0x00000c9000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff397224ULL, 0x000fe200078e0040ULL,
0xffff107000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e003bULL,
0x00013e4000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff427424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000bd000007944ULL, 0x008fea0003c00000ULL,
0xffff114000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e003bULL,
0x00013ea000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff427424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000b7000007944ULL, 0x008fea0003c00000ULL,
0xffff124000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0011ULL,
0x00013f1000417802ULL, 0x000fe20000000f00ULL, 0x000000ffff347224ULL, 0x000fe400078e0036ULL,
0x0000001fff427424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x00000b0000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0040ULL,
0xffff165000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0011ULL,
0x00013f8000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff427424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x00000a9000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e0040ULL, 0xffff161000007947ULL, 0x000fea000383ffffULL,
0x00000001ff347807ULL, 0x004fe20004000000ULL, 0xffffffffff417424ULL, 0x000fe200078e00ffULL,
0x00013fe000357802ULL, 0x000fc40000000f00ULL, 0x00000a8000007944ULL, 0x018fea0003c00000ULL,
0xffff33f000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe20005000000ULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x0001403000357802ULL, 0x000fc40000000f00ULL,
0x00000a3000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff077224ULL, 0x000fe200078e0040ULL,
0xffff343000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e003bULL,
0x000140a000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff427424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0000097000007944ULL, 0x018fea0003c00000ULL,
0xffff350000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e003bULL,
0x0001410000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff427424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0000091000007944ULL, 0x018fea0003c00000ULL,
0xffff360000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e000eULL,
0x0001417000417802ULL, 0x000fe20000000f00ULL, 0x000000ffff347224ULL, 0x000fe400078e000fULL,
0x0000001fff427424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x000008a000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0040ULL,
0xffff3a1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e000eULL,
0x000141e000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff427424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0000083000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e0040ULL, 0xffff39d000007947ULL, 0x000fea000383ffffULL,
0x00000001ff347807ULL, 0x004fe20004000000ULL, 0xffffffffff417424ULL, 0x000fe200078e00ffULL,
0x0001424000357802ULL, 0x000fc40000000f00ULL, 0x0000082000007944ULL, 0x018fea0003c00000ULL,
0xffff583000007947ULL, 0x000fea000383ffffULL, 0x00000001ff347807ULL, 0x000fe20005000000ULL,
0xffffffffff417424ULL, 0x000fe200078e00ffULL, 0x0001429000357802ULL, 0x000fc40000000f00ULL,
0x000007d000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff067224ULL, 0x000fe200078e0040ULL,
0xffff587000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0021ULL,
0x0001430000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff427424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x0000071000007944ULL, 0x018fea0003c00000ULL,
0xffff594000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0021ULL,
0x0001436000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff427424ULL, 0x000fe400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x000006b000007944ULL, 0x018fea0003c00000ULL,
0xffff5a4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0006ULL,
0x000143d000417802ULL, 0x000fe20000000f00ULL, 0x000000ffff347224ULL, 0x000fe400078e0007ULL,
0x0000001fff427424ULL, 0x000fe400078e00ffULL, 0xffffffffff407424ULL, 0x000fc400078e00ffULL,
0x0000064000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff097224ULL, 0x004fe200078e0040ULL,
0xffff5e9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff357224ULL, 0x000fe200078e0006ULL,
0x0001444000417802ULL, 0x000fe20000000f00ULL, 0x0000001fff427424ULL, 0x000fc400078e00ffULL,
0xffffffffff407424ULL, 0x000fc400078e00ffULL, 0x000005d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x004fe200078e0040ULL, 0xffff5e5000007947ULL, 0x000fea000383ffffULL,
0x00000002ff0e7424ULL, 0x000fe200078e00ffULL, 0x000144b000067802ULL, 0x000fe20000000f00ULL,
0x0000001fff0c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff357424ULL, 0x000fc400078e00ffULL,
0x0000052000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff057224ULL, 0x004fe200078e000cULL,
0xffffe8f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff0d7224ULL, 0x006fe200078e000fULL,
0x0001453000067802ULL, 0x000fe20000000f00ULL, 0x00000002ff0e7424ULL, 0x000fe400078e00ffULL,
0x0000001fff0c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff357424ULL, 0x000fc400078e00ffULL,
0x000004a000007944ULL, 0x010fea0003c00000ULL, 0x0000000c0f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0d7224ULL, 0x002fe200078e000aULL, 0x000145b000067802ULL, 0x000fe20000000f00ULL,
0x00000002ff0e7424ULL, 0x000fe200078e00ffULL, 0x0000000f0c097208ULL, 0x000fe20004000000ULL,
0x0000001fff0c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff357424ULL, 0x000fc400078e00ffULL,
0x0000042000007944ULL, 0x000fea0003c00000ULL, 0x0000000c0a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0d7224ULL, 0x002fe200078e000bULL, 0x0001463000067802ULL, 0x000fe20000000f00ULL,
0x00000002ff0e7424ULL, 0x000fe200078e00ffULL, 0x0000000a0c0f7208ULL, 0x000fe20004000000ULL,
0x0000001fff0c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff357424ULL, 0x000fc400078e00ffULL,
0x000003a000007944ULL, 0x000fea0003c00000ULL, 0x0000000c0b00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0d7224ULL, 0x002fe200078e0011ULL, 0x000146b000067802ULL, 0x000fe20000000f00ULL,
0x00000001ff0e7424ULL, 0x000fe200078e00ffULL, 0x0000000b0c057208ULL, 0x000fe20004000000ULL,
0x0000001fff0c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff357424ULL, 0x000fc400078e00ffULL,
0x0000032000007944ULL, 0x000fea0003c00000ULL, 0x0000000c1100720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0d7224ULL, 0x002fe200078e0009ULL, 0x0001473000067802ULL, 0x000fe20000000f00ULL,
0x00000001ff0e7424ULL, 0x000fe200078e00ffULL, 0x000000110c087208ULL, 0x000fe20004000000ULL,
0x0000001fff0c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff357424ULL, 0x000fc400078e00ffULL,
0x000002a000007944ULL, 0x000fea0003c00000ULL, 0x0000000c0900720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0d7224ULL, 0x002fe200078e000fULL, 0x000147b000067802ULL, 0x000fe20000000f00ULL,
0x00000001ff0e7424ULL, 0x000fe200078e00ffULL, 0x000000090c097208ULL, 0x000fe20004000000ULL,
0x0000001fff0c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff357424ULL, 0x000fc400078e00ffULL,
0x0000022000007944ULL, 0x000fea0003c00000ULL, 0x0000000c0f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff0d7224ULL, 0x002fe200078e0005ULL, 0x0001483000067802ULL, 0x000fe20000000f00ULL,
0x00000001ff0e7424ULL, 0x000fe200078e00ffULL, 0x0000000f0c0a7208ULL, 0x000fe20004000000ULL,
0x0000001fff0c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff357424ULL, 0x000fc400078e00ffULL,
0x000001a000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000cULL,
0xffffe6d000007947ULL, 0x000fea000383ffffULL, 0x0180000010007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000001000008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff10ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000010027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000001000007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffeb63002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff077424ULL, 0x000fe200078e00ffULL,
0x0000003500007348ULL, 0x000fe80003800000ULL, 0x0c00000e0d0c7389ULL, 0x0002a200000e000cULL,
0xfffeb5f006007950ULL, 0x000fea0003c3ffffULL, 0x0000004000007348ULL, 0x000fe80003800000ULL,
0x0000003435407389ULL, 0x0002a400000e0042ULL, 0x000000ffff347224ULL, 0x002fc400078e0041ULL,
0x00000000ff357424ULL, 0x000fc800078e00ffULL, 0xfffeb5a034007950ULL, 0x000fea0003c3ffffULL,
0x000000013400780cULL, 0x000fe20003f45070ULL, 0x000000ffff347224ULL, 0x000fe200078e0035ULL,
0x0000004100007348ULL, 0x000fe80003800000ULL, 0x00000000ff357424ULL, 0x000fce00078e00ffULL,
0x0000000000407806ULL, 0x000fc800050e0100ULL, 0x0000004140407212ULL, 0x000fe200078ec0ffULL,
0xfffeb53034007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000100000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005f4ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000750ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f0ULL, 0x0000000000000308ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000cf8ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000db8ULL, 0x00000000000007c0ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001578ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001588ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001618ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x000000000000161cULL, 0x00000000000001c0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000014b80ULL, 0x7f00001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000016380ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000163d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000016750ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001618ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000014d68ULL, 0x0000000000014d68ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000016380ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000016750ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_80_cubin_len = 92208;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
