/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000014b50ULL, 0x00000000000147d0ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL,
0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL,
0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL,
0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL,
0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000030ULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000001baULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000034ULL,
0x0000000000000004ULL, 0x000c00010000028dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000002dbULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000329ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c0001000003c5ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c00010000040bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000459ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000049fULL, 0x0000000000012bd0ULL,
0x0000000000000180ULL, 0x000b0022000004d2ULL, 0x0000000000012d50ULL, 0x0000000000000040ULL,
0x000b0022000004fdULL, 0x0000000000012d90ULL, 0x0000000000000050ULL, 0x000b002200000527ULL,
0x0000000000012de0ULL, 0x0000000000000120ULL, 0x000a000300000595ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005b5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005e5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000012f00ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00012bd000000000ULL,
0x0000040400000000ULL, 0x810c000001640400ULL, 0x0049840400288080ULL, 0x0000000000000000ULL,
0x00000084ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8508288080820828ULL, 0x2880808608288080ULL,
0x808d082880808708ULL, 0x082880808e082880ULL, 0x808090082880808fULL, 0xa708288080990828ULL,
0x288080b108288080ULL, 0x80c808288080c208ULL, 0x1628808084082880ULL, 0x0000031028808280ULL,
0x8492000000000000ULL, 0x0000002200288080ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL,
0x00012bd000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL, 0x8080288080820900ULL,
0x0900000010042880ULL, 0x2880808228808084ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x2880808508288080ULL, 0x8087082880808608ULL, 0x082880808e082880ULL,
0x808090082880808fULL, 0x9908288080910828ULL, 0x288080a108288080ULL, 0x80b108288080a708ULL,
0x08288080c2082880ULL, 0x80808c08288080c8ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808c92ULL, 0x0000001cffffffffULL, 0x0000014000000000ULL, 0x00012d5000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080800828808081ULL,
0x8408288080820828ULL, 0x2880808508288080ULL, 0x8087082880808608ULL, 0x082880808d082880ULL,
0x80808f082880808eULL, 0x9908288080900828ULL, 0x288080a108288080ULL, 0x80b108288080a708ULL,
0x08288080c2082880ULL, 0x80809108288080c8ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880809192ULL, 0x0000002cffffffffULL, 0x0000020000000000ULL, 0x00012d9000000000ULL,
0x0000005000000000ULL, 0x00000c0400000000ULL, 0x8090288080910900ULL, 0x0000000000002880ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8408288080820828ULL, 0x2880808508288080ULL,
0x8087082880808608ULL, 0x082880808e082880ULL, 0x808091082880808fULL, 0xa108288080990828ULL,
0x288080a708288080ULL, 0x80c208288080b108ULL, 0x08288080c8082880ULL, 0x8082801628808090ULL,
0x0000000000031028ULL, 0x2880809092000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x000002d000000000ULL, 0x00012de000000000ULL, 0x0000012000000000ULL, 0x0000000000000000ULL,
0x0000001b00082f04ULL, 0x0008230400000080ULL, 0x0000000000000017ULL, 0x0000001700081204ULL,
0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x000000000000001bULL, 0x0000001b00081204ULL, 0x0008110400000000ULL, 0x000000000000001bULL,
0x0000007b00043704ULL, 0x0000001800080a04ULL, 0x0060190300600160ULL, 0x00000000000c1704ULL,
0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0021f00000500008ULL, 0x00000000000c1704ULL,
0x0011f00000480007ULL, 0x00000000000c1704ULL, 0x0081f00000280006ULL, 0x00000000000c1704ULL,
0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL,
0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL,
0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400801b03ULL,
0x0134290400000900ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x01342804ffffffffULL,
0x00000460000002c0ULL, 0x000025d000000580ULL, 0x000027b000002680ULL, 0x00002d9000002910ULL,
0x00002e1000002dc0ULL, 0x00004da000002e60ULL, 0x00004f7000004e40ULL, 0x00005560000050d0ULL,
0x000055e000005590ULL, 0x0000739000005630ULL, 0x0000755000007420ULL, 0x00007b40000076b0ULL,
0x00007bc000007b70ULL, 0x000099d000007c10ULL, 0x00009ba000009a70ULL, 0x0000a1f000009d00ULL,
0x0000a2700000a220ULL, 0x0000b5800000a2c0ULL, 0x000114d00000b590ULL, 0x0001152000011510ULL,
0x0001154000011530ULL, 0x000115c0000115a0ULL, 0x00012210000115e0ULL, 0x000122a000012250ULL,
0x00012330000122e0ULL, 0x000123d000012380ULL, 0x0001246000012410ULL, 0x000124f0000124a0ULL,
0x0001259000012540ULL, 0x00012620000125d0ULL, 0x000126b000012660ULL, 0x0001275000012700ULL,
0x000127e000012790ULL, 0x0001287000012820ULL, 0x00012910000128c0ULL, 0x000129d000012970ULL,
0x00012a9000012a30ULL, 0x00012b5000012af0ULL, 0x0440390400012bb0ULL, 0x000000ff00000390ULL,
0x003f01000000f600ULL, 0x0000000b00000400ULL, 0x003f01200000f608ULL, 0x0000000b000004e0ULL,
0x003f01200000f688ULL, 0x0000000b00000500ULL, 0x003f01200000f6a8ULL, 0x0000000b00000530ULL,
0x003f01200000f6c8ULL, 0x000000ff00000940ULL, 0x003f01070000f600ULL, 0x0000000600000b10ULL,
0x003f010200000004ULL, 0x0000000600000bc0ULL, 0x003f010100000000ULL, 0x00000071000013b0ULL,
0x003f01070000f6a8ULL, 0x00000071000014c0ULL, 0x003f01010000f6a8ULL, 0x0000000600001520ULL,
0x003f01010000f6c8ULL, 0x00000005000016a0ULL, 0x003f01050000f6ccULL, 0x0000000500001880ULL,
0x003f01050000f6ccULL, 0x000000ff000021f0ULL, 0x000501070000f6b0ULL, 0x000000ff00002270ULL,
0x000501010000f6b0ULL, 0x00000009000022d0ULL, 0x003f01010000f608ULL, 0x00000009000022f0ULL,
0x003f01050000f60cULL, 0x00000009000024c0ULL, 0x003f01050000f60cULL, 0x0000002400002af0ULL,
0x003f01050000f6acULL, 0x0000002400002cc0ULL, 0x003f01050000f6acULL, 0x0000000c00003f80ULL,
0x003f010100000000ULL, 0x0000006000003fe0ULL, 0x003f01010000f688ULL, 0x0000000a00004010ULL,
0x003f010500000004ULL, 0x0000000a000041d0ULL, 0x003f010500000004ULL, 0x00000005000049f0ULL,
0x003f01070000f6a8ULL, 0x0000000500004a80ULL, 0x003f01010000f6a8ULL, 0x0000000900004ae0ULL,
0x003f01010000f628ULL, 0x0000000900004b00ULL, 0x003f01050000f62cULL, 0x0000000900004cd0ULL,
0x003f01050000f62cULL, 0x00000036000052c0ULL, 0x003f01050000f6b4ULL, 0x0000003600005490ULL,
0x003f01050000f6b4ULL, 0x0000001000006520ULL, 0x003f010100000000ULL, 0x0000001200006580ULL,
0x003f01010000f690ULL, 0x0000000a000065b0ULL, 0x003f010500000004ULL, 0x0000000a00006770ULL,
0x003f010500000004ULL, 0x0000007100006f70ULL, 0x003f01070000f6b0ULL, 0x0000000d00007070ULL,
0x003f01010000f6b0ULL, 0x00000009000070d0ULL, 0x003f01010000f648ULL, 0x00000009000070f0ULL,
0x003f01050000f64cULL, 0x00000009000072c0ULL, 0x003f01050000f64cULL, 0x00000013000078a0ULL,
0x003f01050000f6acULL, 0x0000001300007a70ULL, 0x003f01050000f6acULL, 0x0000000e00008b60ULL,
0x003f010100000000ULL, 0x0000000d00008bc0ULL, 0x003f010100000000ULL, 0x0000000a00008bf0ULL,
0x003f010500000004ULL, 0x0000000a00008db0ULL, 0x003f010500000004ULL, 0x000000ff000095e0ULL,
0x0004010700000000ULL, 0x00000071000096c0ULL, 0x003f01010000f6a8ULL, 0x0000000a00009720ULL,
0x003f01010000f668ULL, 0x0000000a00009750ULL, 0x003f01050000f66cULL, 0x0000000a00009920ULL,
0x003f01050000f66cULL, 0x0000007100009ed0ULL, 0x003f01050000f6b4ULL, 0x000000710000a100ULL,
0x003f01050000f6b4ULL, 0x000000020000b350ULL, 0x003f010100000000ULL, 0x000000050000b3d0ULL,
0x003f010100000000ULL, 0x000000ff0000c4d0ULL, 0x003f01010000f600ULL, 0x000000ff0000d100ULL,
0x003f01050000f604ULL, 0x000000ff0000d2d0ULL, 0x003f01050000f604ULL, 0x000000ff0000d500ULL,
0x003f01010000f600ULL, 0x000000ff0000d530ULL, 0x003f01050000f604ULL, 0x000000ff0000d6f0ULL,
0x003f01050000f604ULL, 0x000000740000fa20ULL, 0x003f010100000000ULL, 0x000000740000fac0ULL,
0x003f010500000004ULL, 0x000000740000fc90ULL, 0x003f010500000004ULL, 0x0000007600012070ULL,
0x003f010100000000ULL, 0x00000076000120d0ULL, 0x003f010100000008ULL, 0x0000007600012130ULL,
0x003f010100000010ULL, 0x00000076000121a0ULL, 0x003f010100000018ULL, 0x00201c0400053803ULL,
0x0000be100000bde0ULL, 0x0000c1500000bff0ULL, 0x0000c3e00000c2e0ULL, 0x000121e00000d750ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000037cULL, 0x0000001b00000002ULL,
0x00000000000002acULL, 0x0000001b00000002ULL, 0x00000000000001ecULL, 0x0000001b00000002ULL,
0x0000000000000114ULL, 0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL,
0x0000000000000353ULL, 0x0000001b00000002ULL, 0x0000000000000288ULL, 0x0000001b00000002ULL,
0x00000000000001c8ULL, 0x0000001b00000002ULL, 0x00000000000000eeULL, 0x0000001b00000002ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0c7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000067919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x0000000000097919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000c7a7a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000077919ULL, 0x000f280000002100ULL,
0x0000000000707919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000040003757a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a75ULL,
0x0000040003007624ULL, 0x000fca00078e020cULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x0000000175750810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x0000000175751810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff75aa12ULL, 0x000fc800078e33ffULL, 0x0000007500007306ULL, 0x000e620000209000ULL,
0x000000ff7500720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000375047224ULL, 0x004fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fe400078e0a04ULL, 0x0000000000047919ULL, 0x000ee40000002200ULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000000603727227ULL, 0x000fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a72ULL, 0x0000000075007224ULL, 0x000fca00078e0206ULL,
0x000000750000720cULL, 0x000fe20003f66070ULL, 0x0000010009027a24ULL, 0x008fe400078e0204ULL,
0x00001fff09097589ULL, 0x000fe400000e0000ULL, 0x00000000020b7a24ULL, 0x010fca00078e0207ULL,
0x000000ff0b00720cULL, 0x000fc60003f45270ULL, 0x0000000100003824ULL, 0x000fe200078e0a75ULL,
0x0000000172723810ULL, 0x000fe40007ffe0ffULL, 0x0000007f0b00780cULL, 0x040fe40003f04070ULL,
0x000000750000720cULL, 0x000fe40003f86070ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x000000030b00780cULL, 0x000fe20003f64070ULL, 0x3fffff80ff02a424ULL, 0x000fc400078e00ffULL,
0x7fffff80ff03a424ULL, 0x000fc800078e00ffULL, 0xff317217ff088424ULL, 0x000fe400078e00ffULL,
0x0000000172724810ULL, 0x000fe20007ffe0ffULL, 0x00f60002ff00a388ULL, 0x0003e20000000a00ULL,
0x00000075ff72d212ULL, 0x000fe200078e33ffULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x000000010b00780cULL, 0x000fe20003f84070ULL, 0x00f400080b008388ULL, 0x0005e20000004800ULL,
0x7fffffc0ff059424ULL, 0x000fe400078e00ffULL, 0x000000ffff007224ULL, 0x000fc600078e0a72ULL,
0x00f608040b009388ULL, 0x0007e20000008a00ULL, 0x0000000075757224ULL, 0x000fe200078e0206ULL,
0x00000005ff007819ULL, 0x000fe20000011607ULL, 0x3fffff60ff06b424ULL, 0x000fe400078e00ffULL,
0x00000010756f7824ULL, 0x000fe400078e00ffULL, 0x7fffff60ff07b424ULL, 0x000fe200078e00ffULL,
0x00001fff00007589ULL, 0x000f2200000e0000ULL, 0x3fffff80ff02b424ULL, 0x002fe200078e00ffULL,
0x000000046f087c10ULL, 0x044fe2000fffe1ffULL, 0x7fffff80ff03b424ULL, 0x000fe200078e00ffULL,
0x000000046f007c0cULL, 0x000fe2000bf03070ULL, 0x3fffffc0ff04c424ULL, 0x008fe200078e00ffULL,
0x0000001008087817ULL, 0x000fe20003800000ULL, 0x7fffffc0ff05c424ULL, 0x000fe200078e00ffULL,
0x00f688060b00b388ULL, 0x0003e40000008a00ULL, 0x000000ff08747207ULL, 0x000fc40000000000ULL,
0x00f6a8020b00b388ULL, 0x0009e20000008a00ULL, 0x00005a0072087a19ULL, 0x000fe400000006ffULL,
0x000000107400780cULL, 0x000fe20003f05270ULL, 0x00f6c8040b00c388ULL, 0x000fe20000008a00ULL,
0x0000580070077a24ULL, 0x002fe400078e02ffULL, 0x0000000409027824ULL, 0x010fe400078e0200ULL,
0x0000007a07077224ULL, 0x000fe400078e0208ULL, 0x0000000202037824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000001d000008947ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fc40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x00000004ff087819ULL, 0x002fca0000011604ULL, 0x00000001030a7824ULL, 0x000fc800078e0208ULL,
0x000000016f027824ULL, 0x000fe400078e020aULL, 0x000000100a0b7824ULL, 0x000fc600078e00ffULL,
0x0000000402067c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff057a19ULL, 0x000fe40000011602ULL,
0x0000000374027217ULL, 0x000fe20007800000ULL, 0x0000000107067824ULL, 0x000fc800078e0206ULL,
0x0000007a05077224ULL, 0x000fe400078e0206ULL, 0x0000001004057824ULL, 0x000fe400078e00ffULL,
0x0000000102067824ULL, 0x000fe400078e0a03ULL, 0x0000010007027825ULL, 0x000fe200078e00ffULL,
0x000000f005077812ULL, 0x000fe400078ec0ffULL, 0x000000060800720cULL, 0x000fe20003f06070ULL,
0x000000010a067824ULL, 0x000fe200078e0204ULL, 0x0000000702077212ULL, 0x000fc800078efcffULL,
0xfffffff00b067812ULL, 0x000fe400078ee206ULL, 0x00005e0007027a10ULL, 0x000fc60007f3e0ffULL,
0x0000001006077824ULL, 0x000fe200078e00ffULL, 0x00005f0003037a10ULL, 0x000fca0000ffe4ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002077faeULL, 0x0003e2000c101c48ULL,
0x0000018000007947ULL, 0x000fea0003800000ULL, 0x0000000000047919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x0000000304067211ULL, 0x042fe200078fe0ffULL,
0x0000001004057824ULL, 0x000fc800078e00ffULL, 0x000000016f027824ULL, 0x000fe200078e0206ULL,
0x000000f0050b7812ULL, 0x000fc800078ec0ffULL, 0x0000000402087c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff037a19ULL, 0x000fc60000011602ULL, 0x0000000107087824ULL, 0x000fe400078e0208ULL,
0x0000000106077824ULL, 0x040fe400078e0204ULL, 0x0000007a03037224ULL, 0x000fe400078e0208ULL,
0x0000001006067824ULL, 0x000fe400078e00ffULL, 0x0000010003027825ULL, 0x000fc600078e00ffULL,
0xfffffff006077812ULL, 0x000fe400078ee207ULL, 0x0000000b02027212ULL, 0x000fc600078efcffULL,
0x0000001007077824ULL, 0x000fe200078e00ffULL, 0x00005e0002027a10ULL, 0x000fc80007f1e0ffULL,
0x00005f0003037a10ULL, 0x000fca00007fe4ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002077faeULL, 0x0003e8000b901c48ULL, 0x0000000000067919ULL, 0x000ea20000000000ULL,
0x0000000000027806ULL, 0x002fc800038e0000ULL, 0x0000000200037300ULL, 0x000eb000000e0000ULL,
0x0000000200077309ULL, 0x000e620000000000ULL, 0x000000060300720cULL, 0x004fe40003f02070ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x000000ffff037224ULL, 0x002fc400078e0a07ULL,
0x00000004ff077424ULL, 0x000fc800078e00ffULL, 0x0000660070647625ULL, 0x000fc800078e0007ULL,
0x00f60403ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000864647981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe40003f05270ULL, 0x0000007f64687810ULL, 0x044fe40007ffe0ffULL,
0x000000ff640d7810ULL, 0x000fc40007ffe0ffULL, 0x00000007ff687819ULL, 0x000fe40000011668ULL,
0x00000008ff677819ULL, 0x000fca000001160dULL, 0x0000b99000008947ULL, 0x000fea0003800000ULL,
0x00000003ff557819ULL, 0x000fe20000011600ULL, 0x00000003ff097424ULL, 0x000fe200078e00ffULL,
0x0000f68800067811ULL, 0x000fe200078e18ffULL, 0xffffffffff0c7424ULL, 0x000fe200078e00ffULL,
0x01ffffff55557812ULL, 0x000fc800078ec0ffULL, 0x000000685500720cULL, 0x000fda0003f06070ULL,
0x0000000270028824ULL, 0x000fe400078e00ffULL, 0x00006800ff038624ULL, 0x002fc800078e00ffULL,
0x0000680002028624ULL, 0x000fc800078e0203ULL, 0x0000000155028824ULL, 0x000fe200078e0202ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040906ff738cULL, 0x0003e20000000000ULL,
0x0000640002028625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000008020c8981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0d00780cULL, 0x000fe20003f04070ULL,
0x00000080726b7824ULL, 0x000fe200078e00ffULL, 0x00000001ff447819ULL, 0x000fe20000011600ULL,
0x0000000006ff7f8cULL, 0x0007e2000c80043fULL, 0x0000000100737812ULL, 0x000fc600078ec0ffULL,
0x0000002044767824ULL, 0x000fca00078e00ffULL, 0x000000606b077812ULL, 0x000fe200078ef876ULL,
0x000059000c087a24ULL, 0x004fc800078e02ffULL, 0x0000008008177824ULL, 0x000fe200078e00ffULL,
0x0000040000000947ULL, 0x000fea0003800000ULL, 0x0000007664037217ULL, 0x008fe20007800000ULL,
0x0000001073027824ULL, 0x000fe200078e00ffULL, 0x00000003ff067819ULL, 0x002fe40000011604ULL,
0x0000620017157a11ULL, 0x000fe200078838ffULL, 0x0000000103037824ULL, 0x000fe200078e0a76ULL,
0x00000004060a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000102087824ULL, 0x000fe200078e0206ULL,
0x0000000c060b7810ULL, 0x000fe40007ffe0ffULL, 0x0000000203037217ULL, 0x000fe20007800000ULL,
0x0000000108097824ULL, 0x040fe200078e0204ULL, 0x0000630017177a11ULL, 0x000fe200020f3cffULL,
0x00000008080e7824ULL, 0x000fc400078e00ffULL, 0x0000000103037824ULL, 0x000fe400078e0a02ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0xfffffff80e0d7812ULL, 0x000fe200078ee209ULL,
0x00000001020e7824ULL, 0x000fe200078e020bULL, 0x0000000806097810ULL, 0x000fe40007ffe0ffULL,
0x000000030a00720cULL, 0x080fe20003f46070ULL, 0x00000001020a7824ULL, 0x040fe200078e020aULL,
0x000000030900720cULL, 0x080fe20003f26070ULL, 0x0000000102097824ULL, 0x000fe200078e0209ULL,
0x000000030600720cULL, 0x080fe20003f66070ULL, 0x000000010a027824ULL, 0x040fe200078e0204ULL,
0x000000030b00720cULL, 0x000fe20003f06070ULL, 0x000000080a0f7824ULL, 0x000fc400078e00ffULL,
0x0000000109067824ULL, 0x040fe400078e0204ULL, 0x0000000809117824ULL, 0x000fe200078e00ffULL,
0xfffffff80f0f7812ULL, 0x000fe200078ee202ULL, 0x0000008008027825ULL, 0x000fc600078e00ffULL,
0xfffffff811117812ULL, 0x000fe200078ee206ULL, 0x0000000107067824ULL, 0x040fe200078e020aULL,
0x0000007002027812ULL, 0x000fe200078ef805ULL, 0x0000000107097824ULL, 0x040fe400078e0209ULL,
0x00000001070a7824ULL, 0x000fe200078e020eULL, 0x0000000215027210ULL, 0x000fe20007f9e0ffULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x0000008009087825ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fc600078ef805ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000007008087812ULL, 0x000fc600078ef805ULL, 0x000000010e107824ULL, 0x000fe200078e0204ULL,
0x000000700a057812ULL, 0x000fe200078ef805ULL, 0x000000080e137824ULL, 0x000fe200078e00ffULL,
0x0000b000440e7811ULL, 0x000fe200078e68ffULL, 0x0000000103037824ULL, 0x100fe200020e0617ULL,
0x0000001506067210ULL, 0x080fe40007f9e0ffULL, 0x0000001508087210ULL, 0x080fe20007fbe0ffULL,
0x000000100d0d7824ULL, 0x000fe200078e020eULL, 0xfffffff813137812ULL, 0x000fe200078ee210ULL,
0x000000100f0f7824ULL, 0x100fe200078e020eULL, 0x00000015050a7210ULL, 0x000fe20007fde0ffULL,
0x0000000107077824ULL, 0x000fe200020e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020d7faeULL, 0x0003e2000d901c48ULL, 0x0000001011117824ULL, 0x000fc400078e020eULL,
0x0000000109097824ULL, 0x100fe200028e0617ULL, 0x00000000060f7faeULL, 0x0003e2000d101c48ULL,
0x0000001013137824ULL, 0x000fe400078e020eULL, 0x000000010b0b7824ULL, 0x000fe200030e0617ULL,
0x0000000008117faeULL, 0x0003e8000c901c48ULL, 0x000000000a137faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001073037824ULL, 0x008fe200078e00ffULL,
0x0000620017117a11ULL, 0x000fc400078038ffULL, 0x0000b00044127811ULL, 0x000fe400078e68ffULL,
0x0000000304027211ULL, 0x000fe400078fe8ffULL, 0x0000630017177a11ULL, 0x000fe400000f3cffULL,
0x0000000402067810ULL, 0x042fe20007ffe0ffULL, 0x0000000102037824ULL, 0x040fe200078e0204ULL,
0x0000000802097810ULL, 0x040fe20007ffe0ffULL, 0x0000000802087824ULL, 0x000fe400078e00ffULL,
0x00000008060b7824ULL, 0x000fc400078e00ffULL, 0x00000001090a7824ULL, 0x100fe200078e0204ULL,
0xfffffff8080d7812ULL, 0x000fe200078ee203ULL, 0x0000000106087824ULL, 0x000fe400078e0204ULL,
0x0000000107037824ULL, 0x000fe400078e0202ULL, 0x00000008090f7824ULL, 0x000fe200078e00ffULL,
0xfffffff80b0e7812ULL, 0x000fe200078ee208ULL, 0x0000000107067824ULL, 0x000fe200078e0206ULL,
0x0000000c02087810ULL, 0x000fe20007ffe0ffULL, 0x0000008003027825ULL, 0x000fe200078e00ffULL,
0xfffffff80f0f7812ULL, 0x000fc600078ee20aULL, 0x0000000107097824ULL, 0x040fe200078e0209ULL,
0x0000007002027812ULL, 0x000fe200078ef805ULL, 0x00000001070a7824ULL, 0x000fe400078e0208ULL,
0x0000000108107824ULL, 0x040fe200078e0204ULL, 0x0000000211027210ULL, 0x000fe20007f1e0ffULL,
0x0000000808137824ULL, 0x000fe400078e00ffULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffff813107812ULL, 0x000fe200078ee210ULL, 0x0000008009087825ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fc600078ef805ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000007008087812ULL, 0x000fc600078ef805ULL, 0x0000000103037824ULL, 0x000fe200000e0617ULL,
0x000000700a057812ULL, 0x000fe200078ef805ULL, 0x000000100d0d7824ULL, 0x100fe200078e0212ULL,
0x0000000611067210ULL, 0x000fe20007f1e0ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0212ULL,
0x0000000811087210ULL, 0x040fe40007f3e0ffULL, 0x00000005110a7210ULL, 0x000fe20007f5e0ffULL,
0x000000100e057824ULL, 0x000fe200078e0212ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000020d7faeULL, 0x0003e2000b901c48ULL, 0x0000000107077824ULL, 0x000fc400000e0617ULL,
0x0000000109097824ULL, 0x100fe400008e0617ULL, 0x0000001010117824ULL, 0x000fe200078e0212ULL,
0x0000000006057faeULL, 0x0003e2000b901c48ULL, 0x000000010b0b7824ULL, 0x000fc600010e0617ULL,
0x00000000080f7faeULL, 0x0003e8000b901c48ULL, 0x000000000a117faeULL, 0x0003e4000b901c48ULL,
0x0000001044717824ULL, 0x040fe200078e00ffULL, 0x000000ff6700720cULL, 0x000fe20003f05270ULL,
0x0000000844067824ULL, 0x002fe200078e00ffULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x00000000710473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000000ffff037224ULL, 0x000fe200078e00ffULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000000ffff217224ULL, 0x000fe200078e00ffULL,
0x0000f6a804047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800710e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6c80006067f8cULL, 0x000ee2000c80043fULL, 0x000000ffff207224ULL, 0x000fe200078e00ffULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x00009e4000008947ULL, 0x000fea0003800000ULL, 0x00000002706c7824ULL, 0x000fe200078e00ffULL,
0x00000002ff6d7819ULL, 0x000fe20000011600ULL, 0x00006800ff057624ULL, 0x000fc400078e00ffULL,
0x000000ffff0e7224ULL, 0x004fe400078e000fULL, 0x000000ffff027224ULL, 0x008fe400078e0007ULL,
0x000068006c6c7624ULL, 0x000fe400078e0205ULL, 0xff317217ff0f7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0b7224ULL, 0x000fe400078e00ffULL, 0x000000ffff177224ULL, 0x000fc400078e00ffULL,
0x0000000000107805ULL, 0x038fca0000015200ULL, 0x0000000400057824ULL, 0x000fca00078e00ffULL,
0xfffffff805057812ULL, 0x000fc800078ec0ffULL, 0x0000f6c8050a7810ULL, 0x000fe20007ffe0ffULL,
0x00f6cc0005097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe40007804802ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100d00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210127210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff097819ULL, 0x000fc80000011413ULL, 0x0000001209097211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e0613ULL, 0x0000000209097819ULL, 0x000fc80000001212ULL,
0x000000090000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6cc0005097984ULL, 0x000ea40000000800ULL, 0x8000000009ff7812ULL, 0x004fe40007804802ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000027824ULL, 0x000fe200078e00ffULL, 0x000000010b127810ULL, 0x000fe20007ffe0ffULL,
0x000059000c057a24ULL, 0x000fc600078e02ffULL, 0xffffffe002107812ULL, 0x000fe200078ec0ffULL,
0x00000080053b7824ULL, 0x000fe200078e00ffULL, 0x000000671200720cULL, 0x000fc60003f26070ULL,
0x000001000b107824ULL, 0x000fca00078e0210ULL, 0x0000004010097810ULL, 0x000fc80007ffe0ffULL,
0x00000060090c7812ULL, 0x000fca00078ec0ffULL, 0x000000016b3a7824ULL, 0x000fe200078e020cULL,
0x0000042000009947ULL, 0x000fea0003800000ULL, 0x0000001002057812ULL, 0x000fe400078ec0ffULL,
0x0000000964027217ULL, 0x000fe40007800000ULL, 0x00000003ff0d7819ULL, 0x000fc60000011604ULL,
0x0000000102027824ULL, 0x000fe200078e0a09ULL, 0x000000040d117810ULL, 0x040fe20007ffe0ffULL,
0x000000010d097824ULL, 0x000fc600078e0205ULL, 0x0000000502027217ULL, 0x000fe20007800000ULL,
0x00000001090c7824ULL, 0x040fe400078e0204ULL, 0x0000000809137824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fc600078e0a05ULL, 0xfffffff813267812ULL, 0x000fe200078ee20cULL,
0x000000013a0c7824ULL, 0x000fe200078e0209ULL, 0x000000080d137810ULL, 0x040fe40007ffe0ffULL,
0x000000020d00720cULL, 0x0c0fe40003f86070ULL, 0x0000000c0d0d7810ULL, 0x000fe40007ffe0ffULL,
0x000000021100720cULL, 0x0c0fe20003f66070ULL, 0x0000000111117824ULL, 0x100fe200078e0205ULL,
0x000000020d00720cULL, 0x0c0fe20003f06070ULL, 0x000000010d277824ULL, 0x000fe200078e0205ULL,
0x000000021300720cULL, 0x000fe20003f46070ULL, 0x00000010040d7824ULL, 0x000fe200078e00ffULL,
0x000062003b097a11ULL, 0x000fe200078a38ffULL, 0x0000000111027824ULL, 0x000fc400078e0204ULL,
0x0000000811257824ULL, 0x000fe200078e00ffULL, 0x000000700d397812ULL, 0x000fe200078ec0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000063003b3b7a11ULL, 0x000fe400028f3cffULL,
0xfffffff825027812ULL, 0x000fe200078ee202ULL, 0x000000013a247824ULL, 0x000fe200078e0211ULL,
0x000000390c0c7212ULL, 0x000fe200078efcffULL, 0x0000000113137824ULL, 0x000fe400078e0205ULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000000c090c7210ULL, 0x000fc60007fbe0ffULL,
0x0000000113057824ULL, 0x040fe200078e0204ULL, 0x0000003924247212ULL, 0x000fe200078efcffULL,
0x0000000813387824ULL, 0x000fe400078e00ffULL, 0x000000013a107824ULL, 0x040fe400078e0213ULL,
0x000000013a127824ULL, 0x000fe200078e0227ULL, 0xfffffff838387812ULL, 0x000fe200078ee205ULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x0000000127057824ULL, 0x040fe200078e0204ULL,
0x0000003910107212ULL, 0x000fe200078efcffULL, 0x00000008273a7824ULL, 0x000fe400078e00ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff83a3a7812ULL, 0x000fe200078ee205ULL,
0x000000010d0d7824ULL, 0x100fe200028e063bULL, 0x0000000924247210ULL, 0x000fe40007fbe0ffULL,
0x0000003912127212ULL, 0x000fe400078efcffULL, 0x0000c00044057811ULL, 0x000fe200078e68ffULL,
0x0000000125257824ULL, 0x000fe200028e063bULL, 0x0000000910107210ULL, 0x080fe40007fbe0ffULL,
0x0000000912127210ULL, 0x000fe20007fde0ffULL, 0x0000001026097824ULL, 0x000fc400078e0205ULL,
0x0000001002277824ULL, 0x100fe400078e0205ULL, 0x0000001038397824ULL, 0x000fe200078e0205ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c097faeULL, 0x0005e2000e101c48ULL,
0x0000000111117824ULL, 0x000fe400028e063bULL, 0x000000103a057824ULL, 0x000fe200078e0205ULL,
0x0000000024277faeULL, 0x0005e2000d901c48ULL, 0x0000000113137824ULL, 0x000fc600030e063bULL,
0x0000000010397faeULL, 0x0005e8000d101c48ULL, 0x0000000012057faeULL, 0x0005e2000c101c48ULL,
0x0000035000007947ULL, 0x000fea0003800000ULL, 0x0000001002057812ULL, 0x000fe200078ec0ffULL,
0x0000001004107824ULL, 0x040fe200078e00ffULL, 0x000062003b3d7a11ULL, 0x000fe400078038ffULL,
0x0000000504057211ULL, 0x000fe400078fe8ffULL, 0x0000007010397812ULL, 0x000fc400078ec0ffULL,
0x0000000405097810ULL, 0x040fe20007ffe0ffULL, 0x0000000105027824ULL, 0x140fe200078e0204ULL,
0x0000000805117810ULL, 0x040fe20007ffe0ffULL, 0x00000008050d7824ULL, 0x000fe200078e00ffULL,
0x000063003b3b7a11ULL, 0x000fe200000f3cffULL, 0x00000001090c7824ULL, 0x040fe400078e0204ULL,
0x0000000809137824ULL, 0x000fe200078e00ffULL, 0xfffffff80d027812ULL, 0x000fe200078ee202ULL,
0x00000001110d7824ULL, 0x040fe400078e0204ULL, 0x0000000811127824ULL, 0x000fe200078e00ffULL,
0xfffffff813267812ULL, 0x000fe200078ee20cULL, 0x000000013a0c7824ULL, 0x040fe200078e0205ULL,
0x0000000c05057810ULL, 0x000fe20007ffe0ffULL, 0x000000013a107824ULL, 0x000fe200078e0209ULL,
0xfffffff812277812ULL, 0x000fe200078ee20dULL, 0x000000800c0c7825ULL, 0x000fc800078e00ffULL,
0x000000013a127824ULL, 0x000fe200078e0211ULL, 0x000000390c0c7212ULL, 0x000fe200078efcffULL,
0x000000013a247824ULL, 0x000fe400078e0205ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000000c3d0c7210ULL, 0x000fc60007f1e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000003910107212ULL, 0x000fc600078efcffULL, 0x0000008024247825ULL, 0x000fe200078e00ffULL,
0x0000003912127212ULL, 0x000fc600078efcffULL, 0x0000000105097824ULL, 0x040fe200078e0204ULL,
0x0000003924247212ULL, 0x000fe200078efcffULL, 0x0000000805387824ULL, 0x000fe200078e00ffULL,
0x0000c00044397811ULL, 0x000fe200078e68ffULL, 0x000000010d0d7824ULL, 0x000fe200000e063bULL,
0x000000103d107210ULL, 0x040fe40007f1e0ffULL, 0x000000123d127210ULL, 0x040fe20007f5e0ffULL,
0x0000001002057824ULL, 0x000fe200078e0239ULL, 0xfffffff838387812ULL, 0x000fe200078ee209ULL,
0x0000001026097824ULL, 0x000fe200078e0239ULL, 0x000000243d247210ULL, 0x000fe20007f7e0ffULL,
0x0000000111117824ULL, 0x000fe200000e063bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c057faeULL, 0x0005e2000b901c48ULL, 0x0000001027277824ULL, 0x000fc400078e0239ULL,
0x0000000113137824ULL, 0x000fe200010e063bULL, 0x0000000010097faeULL, 0x0005e2000b901c48ULL,
0x0000001038397824ULL, 0x000fe400078e0239ULL, 0x0000000125257824ULL, 0x000fe200018e063bULL,
0x0000000012277faeULL, 0x0005e8000b901c48ULL, 0x0000000024397faeULL, 0x0005e4000b901c48ULL,
0x00000008000c7824ULL, 0x004fe200078e00ffULL, 0x0000000155057810ULL, 0x000fc60007ffe0ffULL,
0x000000000c0573c2ULL, 0x000ea200000e0000ULL, 0x000000680500720cULL, 0x000fe40003f06070ULL,
0x000000100c027812ULL, 0x040fe400078ec0ffULL, 0xffffffe00c097812ULL, 0x040fe400078ec0ffULL,
0x000000080c0d7812ULL, 0x000fce00078ec0ffULL, 0x000000016c108824ULL, 0x000fe400078e0205ULL,
0x00000004ff118424ULL, 0x000fe400078e00ffULL, 0xffffffffff057424ULL, 0x000fe400078e00ffULL,
0x0000640010108625ULL, 0x000fe200078e0011ULL, 0xfffffff005057892ULL, 0x004fe2000f8ec03fULL,
0x000000090d097210ULL, 0x000fc60007ffe002ULL, 0x0000000810058981ULL, 0x000522000c1e1900ULL,
0x0000f6b005067890ULL, 0x000fc8000fffe03fULL, 0x0000000000007918ULL, 0x000fea0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a06ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x00f6b000ff127f8cULL, 0x000ea2000c800405ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6080009267f8cULL, 0x000664000c80043fULL,
0x0000000000107805ULL, 0x000fc40000015200ULL, 0x00f60c00090d7984ULL, 0x000ee40000000800ULL,
0x800000000dff7812ULL, 0x00afe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff387224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000247805ULL, 0x000fcc0000015200ULL,
0x00000024100d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000125247824ULL, 0x000fe200000e0e11ULL,
0x003d09000d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2400720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2400720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff027819ULL, 0x000fc80000011424ULL, 0x0000000d02027211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e0624ULL, 0x0000000202027819ULL, 0x000fc8000000120dULL,
0x000000020000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000138387810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60c00090d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001004567824ULL, 0x000fe200078e00ffULL,
0x00000001ff707819ULL, 0x000fe20000011604ULL, 0x0000002000027824ULL, 0x000fe400078e00ffULL,
0xffffffffff777424ULL, 0x000fe200078e00ffULL, 0x0000007056567812ULL, 0x000fc400078ec0ffULL,
0xffffff80020d7812ULL, 0x000fe400078ec0ffULL, 0x0000000c70707812ULL, 0x000fc800078ec0ffULL,
0x0000000d700d7210ULL, 0x000fca0007ffe056ULL, 0x00f000000d247984ULL, 0x000e680000000800ULL,
0x00f200000d257984ULL, 0x0006a20000000800ULL, 0x0000000f2400720bULL, 0x002fe20003f1d000ULL,
0x0000fc227f007947ULL, 0x000fd8000b800000ULL, 0x00000000000d7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0d277812ULL, 0x000fe2000780c0ffULL, 0x000004c000007945ULL, 0x000fe20003800000ULL,
0x00000001ff267424ULL, 0x000fe400078e00ffULL, 0x000000ffff027224ULL, 0x000fc400078e000fULL,
0x0000001fff797424ULL, 0x000fe400078e00ffULL, 0xffffffffff787424ULL, 0x000fca00078e00ffULL,
0x0000046000008947ULL, 0x000fea0003800000ULL, 0x000000006d00720cULL, 0x000fe40003f05270ULL,
0x0000000f2400720bULL, 0x000fe20003f54000ULL, 0x0000fbb27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000027806ULL, 0x000fc400010e0100ULL, 0x0000008000118824ULL, 0x000fe200078e0256ULL,
0x0000000f240d8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe40003800000ULL,
0x0000000170108824ULL, 0x000fe200078e0211ULL, 0x0000991002117816ULL, 0x000fc800000000ffULL,
0x00f4000d10008388ULL, 0x0003e20000000800ULL, 0x000000ff1100720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000f24107209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff02ff7812ULL, 0x000fc6000780c0ffULL,
0x0000000f100d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d00267308ULL, 0x000e640000000800ULL, 0x0000002603037220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011604ULL,
0x0000fad27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d260d7589ULL, 0x0002e400000e0000ULL,
0x0000000d30307220ULL, 0x08cfe20000410000ULL, 0x0000000d31317220ULL, 0x080fe20000410000ULL,
0x0000000d2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000d28287220ULL, 0x080fe20000410000ULL, 0x0000000d29297220ULL, 0x080fe20000410000ULL,
0x0000000d34347220ULL, 0x080fe20000410000ULL, 0x0000000d35357220ULL, 0x080fe20000410000ULL,
0x0000000d20207220ULL, 0x080fe20000410000ULL, 0x0000000d21217220ULL, 0x080fe20000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000d1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000d18187220ULL, 0x080fe20000410000ULL, 0x0000000d19197220ULL, 0x080fe20000410000ULL,
0x0000000d14147220ULL, 0x080fe20000410000ULL, 0x0000000d15157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0002ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008040d7811ULL, 0x000fe200078ff0ffULL,
0x0000f9b27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d260d7589ULL, 0x00066400000e0000ULL,
0x0000000d32327220ULL, 0x086fe20000410000ULL, 0x0000000d33337220ULL, 0x080fe20000410000ULL,
0x0000000d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000d2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000d2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000d36367220ULL, 0x080fe20000410000ULL, 0x0000000d37377220ULL, 0x080fe20000410000ULL,
0x0000000d22227220ULL, 0x080fe20000410000ULL, 0x0000000d23237220ULL, 0x080fe20000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000d1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000d1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000d1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000d16167220ULL, 0x080fe20000410000ULL, 0x0000000d17177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff27ff7812ULL, 0x000fe20007806002ULL,
0x00000001ff267424ULL, 0x008fe200078e00ffULL, 0x0000000f24027209ULL, 0x000fd60007810000ULL,
0x8000000224240221ULL, 0x000fe20000010000ULL, 0x00007610ff260816ULL, 0x000fc60000000026ULL,
0x3fb8aa3b24240820ULL, 0x000fc80000410000ULL, 0x0000002400080308ULL, 0x000e640000000800ULL,
0x0000000825250220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000325037221ULL, 0x004fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0xfffffff00c247812ULL, 0x000fca00078ec0ffULL, 0x00f6ac00240d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480eULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fcc0000015200ULL,
0x0000000c100f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e11ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc8000001140dULL, 0x0000000f0c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e060dULL, 0x000000020c0c7819ULL, 0x000fc8000000120dULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac00240d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000780480eULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910260c7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0c00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000008ff06723eULL, 0x000fe400000000ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011604ULL, 0x00005410060c7816ULL, 0x000fe20000000006ULL,
0x0000f5727f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0c077589ULL, 0x0002a400000e0000ULL,
0x000000080f0d7810ULL, 0x000fe20007ffe0ffULL, 0x0000f5a27f007947ULL, 0x000fea000b800000ULL,
0x00001f0d0c067589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100f0d7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200078e000cULL,
0x00002e2000117802ULL, 0x000fc40000000f00ULL, 0x0000ff7000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180f0d7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200078e000cULL, 0x00002e7000117802ULL, 0x000fc40000000f00ULL,
0x0000ff2000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000200607824ULL, 0x000fe200078e00ffULL, 0x00000007040d7812ULL, 0x00cfe200078ec0ffULL,
0x0000020000457824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000804487812ULL, 0x000fc400078ec0ffULL, 0x00000004600f7812ULL, 0x002fe400078ec0ffULL,
0x000000080d597812ULL, 0x000fe400078ef804ULL, 0x0000000f040c7211ULL, 0x000fe400078fe0ffULL,
0xfffff80045457812ULL, 0x000fe200078ec0ffULL, 0x00000008594e7824ULL, 0x040fe400078e00ffULL,
0x0000000159577824ULL, 0x000fca00078e020cULL, 0xfffffff84e4e7812ULL, 0x000fca00078ee257ULL,
0x000000104e4e7824ULL, 0x000fc400078e0245ULL, 0x00000004000f7824ULL, 0x000fe200078e00ffULL,
0x00000004ff667819ULL, 0x000fe40000011604ULL, 0x0000000d480c7212ULL, 0x000fe400078efcffULL,
0x000000040f0f7812ULL, 0x000fe400078ec0ffULL, 0x0000b000446a7811ULL, 0x000fe200078e68ffULL,
0x000000080c477824ULL, 0x000fe200078e00ffULL, 0x0000001048487812ULL, 0x000fe200078efe0dULL,
0x00000001660f7824ULL, 0x000fe200078e020fULL, 0xfffffff860607812ULL, 0x000fe200078ec0ffULL,
0x000000080c0d7824ULL, 0x000fc400078e00ffULL, 0x000000010c0e7824ULL, 0x000fe400078e020fULL,
0x00000008484d7824ULL, 0x040fe400078e00ffULL, 0x000000010f4c7824ULL, 0x000fe200078e0248ULL,
0xfffffff847477812ULL, 0x000fe200078ee20eULL, 0x00000008485d7824ULL, 0x000fe200078e00ffULL,
0x000000020e467810ULL, 0x000fe40007ffe0ffULL, 0xfffffff84d4d7812ULL, 0x000fe200078ee24cULL,
0x0000001047247824ULL, 0x000fe200078e026aULL, 0xfffffff80d467812ULL, 0x000fc400078ee246ULL,
0x000000024c4c7810ULL, 0x000fe20007ffe0ffULL, 0x000000104d3c7824ULL, 0x100fe400078e026aULL,
0x000000002424783bULL, 0x000e620000004200ULL, 0x00000010460c7824ULL, 0x000fe200078e026aULL,
0xfffffff85d4c7812ULL, 0x000fe400078ee24cULL, 0x000000003c3c783bULL, 0x000ea20000004200ULL,
0x00000100240d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff4a7819ULL, 0x000fe20000011424ULL,
0x0001000024397824ULL, 0x040fe200078e00ffULL, 0x00008880244f7816ULL, 0x000fe200000000ffULL,
0x00000100253a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fc4000001140dULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x000000000c0c783bULL, 0x000e620000004200ULL,
0x0000003800247306ULL, 0x0007e20000200c00ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000018ff497819ULL, 0x000fe40000011425ULL, 0x0000888025537816ULL, 0x040fe200000000ffULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff407819ULL, 0x004fe2000001143cULL,
0x00000039004b7306ULL, 0x0005e20000200c00ULL, 0x0000010026387824ULL, 0x008fe200078e00ffULL,
0x000088803c427816ULL, 0x000fc400000000ffULL, 0x00000018ff257819ULL, 0x000fe40000011425ULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000003a00587306ULL, 0x000fe20000200c00ULL,
0x0000010027397824ULL, 0x004fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fe40000011426ULL,
0x00000018ff517819ULL, 0x000fe40000011427ULL, 0x00000018ff637819ULL, 0x000fc40000011439ULL,
0x0000003800657306ULL, 0x0005e20000200c00ULL, 0x00008880265c7816ULL, 0x040fe200000000ffULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x0000888027627816ULL, 0x040fe200000000ffULL,
0x0001000027277824ULL, 0x000fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fe4000001143dULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000004f004f7306ULL, 0x000ee20000200c00ULL,
0x009000004e38783bULL, 0x004ea20000000200ULL, 0x00000018ff277819ULL, 0x000fc40000011427ULL,
0x000088803d487816ULL, 0x000fe400000000ffULL, 0x00000018ff107819ULL, 0x000fe4000001143eULL,
0x00000025006e7306ULL, 0x0007e20000200c00ULL, 0x00000018ff117819ULL, 0x000fe4000001143fULL,
0x00000018ff5b7819ULL, 0x002fe4000001140cULL, 0x00000018ff5a7819ULL, 0x000fe4000001140dULL,
0x00000018ff527819ULL, 0x000fe2000001140eULL, 0x0000005300537306ULL, 0x000e620000200c00ULL,
0x000001003c257824ULL, 0x048fe200078e00ffULL, 0x000054104f247816ULL, 0x000fe20000000024ULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff547819ULL, 0x000fc4000001140fULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000004900497306ULL, 0x000ee20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fce000001143cULL, 0x0000002500437306ULL, 0x0003f00000200c00ULL,
0x0000004a004a7306ULL, 0x000ee20000200c00ULL, 0x000001003d257824ULL, 0x042fe200078e00ffULL,
0x0000000738388232ULL, 0x084fe20000000000ULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x000000073a3a8232ULL, 0x000fc40000000000ULL, 0x00000018ff4f7819ULL, 0x000fe20000011425ULL,
0x0000000639398232ULL, 0x080fe20000000000ULL, 0x0000541053257816ULL, 0x000fe20000000058ULL,
0x000000063b3b8232ULL, 0x000fe20000000000ULL, 0x0000003c005e7306ULL, 0x0003e20000200c00ULL,
0x00000018ff3d7819ULL, 0x000fca000001143dULL, 0x000000243830723cULL, 0x000be40000001830ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x000088803e3c7816ULL, 0x002fc800000000ffULL,
0x000054106e257816ULL, 0x028fe20000000049ULL, 0x000000ffff497224ULL, 0x000fe200078e003cULL,
0x000054104b247816ULL, 0x000fe2000000004aULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x000001003e3c7824ULL, 0x040fe200078e00ffULL, 0x000088803f4a7816ULL, 0x000fe200000000ffULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000024382c723cULL, 0x000b62000000182cULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3e7819ULL, 0x000fce000001143eULL, 0x0000006200627306ULL, 0x000ff00000200c00ULL,
0x0000006300637306ULL, 0x000ff00000200c00ULL, 0x0000002600617306ULL, 0x0002b00000200c00ULL,
0x00000027005f7306ULL, 0x0006e20000200c00ULL, 0x000000104c267824ULL, 0x002fce00078e026aULL,
0x0000003d00587306ULL, 0x0003e20000200c00ULL, 0x0000541061507816ULL, 0x004fe20000000050ULL,
0x000001000c617824ULL, 0x000fe200078e00ffULL, 0x000000002624783bULL, 0x028ea80000004200ULL,
0x00000018ff617819ULL, 0x000fe20000011461ULL, 0x0000003e005d7306ULL, 0x0007e20000200c00ULL,
0x000001003f3d7824ULL, 0x002fe200078e00ffULL, 0x000054105f517816ULL, 0x000fe20000000051ULL,
0x000100003f3f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff537819ULL, 0x000fe4000001143dULL,
0x00000018ff697819ULL, 0x000fe2000001143fULL, 0x000000503834723cULL, 0x000b620000001834ULL,
0x000054105c3e7816ULL, 0x008fe20000000065ULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x00005410623f7816ULL, 0x000fc80000000063ULL, 0x000001000d507824ULL, 0x060fe200078e00ffULL,
0x000088800d517816ULL, 0x040fe200000000ffULL, 0x000100000d0d7824ULL, 0x000fe200078e00ffULL,
0x0000003e3828723cULL, 0x000b620000001828ULL, 0x0000006100627306ULL, 0x000fe20000200c00ULL,
0x00000018ff637819ULL, 0x000fca0000011450ULL, 0x000088800c3e7816ULL, 0x060fe200000000ffULL,
0x000100000c0c7824ULL, 0x000fe200078e00ffULL, 0x0000005100517306ULL, 0x000fe80000200c00ULL,
0x00000018ff0c7819ULL, 0x000fe4000001140cULL, 0x00000018ff3d7819ULL, 0x004fe40000011424ULL,
0x0000003e005f7306ULL, 0x0002a20000200c00ULL, 0x00000018ff3f7819ULL, 0x000fce0000011425ULL,
0x00000063006e7306ULL, 0x0006a20000200c00ULL, 0x00000018ff3e7819ULL, 0x002fce0000011427ULL,
0x0000000c00507306ULL, 0x0005e20000200c00ULL, 0x000088800e637816ULL, 0x008fce00000000ffULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x000054105f0c7816ULL, 0x004fe20000000062ULL,
0x0000000444627824ULL, 0x000fe200078e0266ULL, 0x00000018ff5f7819ULL, 0x000fe4000001140dULL,
0x00005410510d7816ULL, 0x000fe4000000006eULL, 0x0000000262627810ULL, 0x000fe20007ffe059ULL,
0x0000000859597824ULL, 0x000fe200078e00ffULL, 0x0000005f005f7306ULL, 0x000e620000200c00ULL,
0x000088800f517816ULL, 0x000fc400000000ffULL, 0x0000000c3820723cULL, 0x000be20000001820ULL,
0xfffffff8597c7812ULL, 0x000fe400078ee262ULL, 0x0000888024597816ULL, 0x000fe400000000ffULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x000000107c457824ULL, 0x000fe400078e0245ULL,
0x000001000e0d7824ULL, 0x020fe400078e00ffULL, 0x000001000f0c7824ULL, 0x000fc400078e00ffULL,
0x000100000e0e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x000100000f0f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x00000018ff0e7819ULL, 0x000fe4000001140eULL,
0x00000018ff627819ULL, 0x000fca000001140fULL, 0x0000000d006e7306ULL, 0x0002b00000200c00ULL,
0x0000000c00667306ULL, 0x0006a20000200c00ULL, 0x000054105f0d7816ULL, 0x002fe2000000005aULL,
0x00000100245a7824ULL, 0x000fc400078e00ffULL, 0x0001000024247824ULL, 0x000fc600078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001145aULL, 0x0000000e00617306ULL, 0x0003e20000200c00ULL,
0x00005410500c7816ULL, 0x008fe4000000005bULL, 0x0000541063507816ULL, 0x004fe4000000006eULL,
0x00008880255b7816ULL, 0x000fe400000000ffULL, 0x00000018ff247819ULL, 0x000fe20000011424ULL,
0x0000000c381c723cULL, 0x000b62000000181cULL, 0x0000541051517816ULL, 0x000fe20000000066ULL,
0x00900000450c783bULL, 0x022e620000000200ULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x0000888026637816ULL, 0x000fc800000000ffULL, 0x000000503818723cULL, 0x000b660000001818ULL,
0x0000005400547306ULL, 0x000fe80000200c00ULL, 0x0000010025507824ULL, 0x060fe400078e00ffULL,
0x0001000025257824ULL, 0x000fe400078e00ffULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x00000018ff5f7819ULL, 0x000fc40000011450ULL, 0x00000018ff257819ULL, 0x000fca0000011425ULL,
0x0000004200427306ULL, 0x000eb00000200c00ULL, 0x0000004000407306ULL, 0x000ee20000200c00ULL,
0x000000070c0c8232ULL, 0x002fce0000000000ULL, 0x0000004100417306ULL, 0x000e620000200c00ULL,
0x0000541042427816ULL, 0x004fe20000000043ULL, 0x000000070e0e8232ULL, 0x000fe40000000000ULL,
0x000000060d0d8232ULL, 0x080fe40000000000ULL, 0x000000060f0f8232ULL, 0x000fe40000000000ULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x000054105e407816ULL, 0x008fce0000000040ULL,
0x0000004f004f7306ULL, 0x000ea20000200c00ULL, 0x0000541058417816ULL, 0x002fce0000000041ULL,
0x0000001000107306ULL, 0x000e620000200c00ULL, 0x000000400c2c723cULL, 0x000fee000000182cULL,
0x0000001100117306ULL, 0x000fe20000200c00ULL, 0x0000541048437816ULL, 0x004fce000000004fULL,
0x00000069005c7306ULL, 0x000ea20000200c00ULL, 0x000054105d107816ULL, 0x002fe20000000010ULL,
0x000000420c30723cULL, 0x000fec0000001830ULL, 0x0000002400507306ULL, 0x0003f00000200c00ULL,
0x0000002500517306ULL, 0x0007e20000200c00ULL, 0x0000541061247816ULL, 0x002fe20000000052ULL,
0x000000ffff527224ULL, 0x000fe200078e0063ULL, 0x000054105c117816ULL, 0x004fca0000000011ULL,
0x0000003c004b7306ULL, 0x0003e20000200c00ULL, 0x0000541062257816ULL, 0x008fce0000000054ULL,
0x000000243814723cULL, 0x000b620000001814ULL, 0x00000018ff3c7819ULL, 0x002fe20000011426ULL,
0x0000003d003d7306ULL, 0x000e6a0000200c00ULL, 0x0000010026397824ULL, 0x060fe200078e00ffULL,
0x00008880273a7816ULL, 0x040fe200000000ffULL, 0x0000010027247824ULL, 0x040fe200078e00ffULL,
0x0000005200387306ULL, 0x000fe20000200c00ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff397819ULL, 0x000fe20000011439ULL, 0x0001000027277824ULL, 0x000fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fc40000011424ULL, 0x00000018ff407819ULL, 0x000fe40000011426ULL,
0x00000018ff427819ULL, 0x000fe20000011427ULL, 0x0000003900397306ULL, 0x000ea20000200c00ULL,
0x000000100c24723cULL, 0x000b620000001834ULL, 0x0000541050507816ULL, 0x002fcc000000003dULL,
0x0000004900497306ULL, 0x000e700000200c00ULL, 0x0000004a004a7306ULL, 0x000fe20000200c00ULL,
0x0000541038387816ULL, 0x004fce0000000039ULL, 0x0000005300537306ULL, 0x000ea20000200c00ULL,
0x0000541049527816ULL, 0x002fce000000004bULL, 0x0000003f003f7306ULL, 0x000e700000200c00ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x000054104a537816ULL, 0x004fce0000000053ULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x0000541051517816ULL, 0x002fe2000000003fULL,
0x000000520c28723cULL, 0x040f6c0000001828ULL, 0x0000005900597306ULL, 0x000fe40000200c00ULL,
0x000000500c1c723cULL, 0x000f6c000000181cULL, 0x0000005a005a7306ULL, 0x000e700000200c00ULL,
0x0000005b005b7306ULL, 0x000ff00000200c00ULL, 0x0000005f005f7306ULL, 0x000ea20000200c00ULL,
0x00005410595a7816ULL, 0x002fce000000005aULL, 0x0000003a003a7306ULL, 0x000ff00000200c00ULL,
0x0000003b003b7306ULL, 0x000e620000200c00ULL, 0x000054105b5b7816ULL, 0x004fce000000005fULL,
0x0000004000417306ULL, 0x000ea20000200c00ULL, 0x0000005a0c20723cULL, 0x000f6e0000001820ULL,
0x0000004200117306ULL, 0x020ee20000200c00ULL, 0x000054103a397816ULL, 0x002fe4000000003bULL,
0x00005410413c7816ULL, 0x004fca000000003cULL, 0x000000380c18723cULL, 0x000f620000001818ULL,
0x00005410113d7816ULL, 0x008fce000000003eULL, 0x0000003c0c14723cULL, 0x000b6e0000001814ULL,
0x0000f6c8440c7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000000c0c7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6880060ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff347224ULL, 0x000fc600078e00ffULL,
0x00000000000e7805ULL, 0x000fc80000015200ULL, 0x000004000a117984ULL, 0x000ee40000000800ULL,
0x8000000011ff7812ULL, 0x00afc4000780480dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100e357210ULL, 0x000fca0007f1e1ffULL,
0x0000000111117824ULL, 0x000fe200000e0e0fULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff1100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff1100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff107819ULL, 0x000fc80000011411ULL,
0x0000003510107211ULL, 0x000fca00078110ffULL, 0x000000ffff117224ULL, 0x000fca00000e0611ULL,
0x0000000210107819ULL, 0x000fc80000001211ULL, 0x000000100000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000134347810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000a117984ULL, 0x000e640000000800ULL,
0x8000000011ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010000f7824ULL, 0x000fe400078e00ffULL, 0x0000590005057a24ULL, 0x010fc600078e02ffULL,
0xffffffe00f0c7812ULL, 0x000fca00078ec0ffULL, 0x000001000b0c7824ULL, 0x000fca00078e020cULL,
0x000000800c0d7810ULL, 0x000fe20007ffe0ffULL, 0x00000080050c7824ULL, 0x000fc600078e00ffULL,
0x000000600d0e7812ULL, 0x000fca00078ec0ffULL, 0x000000016b117824ULL, 0x000fe200078e020eULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x0000000d64057217ULL, 0x000fe40007800000ULL,
0x000000100f107812ULL, 0x000fe400078ec0ffULL, 0x00000003ff0e7819ULL, 0x000fe20000011604ULL,
0x0000000105057824ULL, 0x000fc600078e0a0dULL, 0x000000040e347810ULL, 0x040fe20007ffe0ffULL,
0x000000010e0d7824ULL, 0x000fe200078e0210ULL, 0x0000000510057217ULL, 0x000fe40007800000ULL,
0x0000000c0e357810ULL, 0x000fe20007ffe0ffULL, 0x000000010d0f7824ULL, 0x040fe400078e0204ULL,
0x000000080d367824ULL, 0x000fe400078e00ffULL, 0x0000000105057824ULL, 0x100fe400078e0a10ULL,
0x0000000135387824ULL, 0x000fe200078e0210ULL, 0xfffffff836397812ULL, 0x000fc400078ee20fULL,
0x000000080e0f7810ULL, 0x000fe20007ffe0ffULL, 0x00000008383f7824ULL, 0x000fe200078e00ffULL,
0x000000050e00720cULL, 0x080fe20003f86070ULL, 0x000000010d0e7824ULL, 0x000fe200078e0211ULL,
0x000000053400720cULL, 0x0c0fe20003f66070ULL, 0x000000010f367824ULL, 0x140fe200078e0210ULL,
0x000000050f00720cULL, 0x080fe20003f46070ULL, 0x0000000134347824ULL, 0x000fe200078e0210ULL,
0x000000053500720cULL, 0x000fe20003f06070ULL, 0x0000000136057824ULL, 0x040fe400078e0204ULL,
0x00000008363a7824ULL, 0x000fc400078e00ffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff83a3d7812ULL, 0x000fe200078ee205ULL, 0x00000001340d7824ULL, 0x000fe200078e0204ULL,
0x000062000c057a11ULL, 0x000fe200078a38ffULL, 0x0000000834107824ULL, 0x000fe200078e00ffULL,
0x000000560e0e7212ULL, 0x000fe200078efcffULL, 0x0000000134347824ULL, 0x100fe400078e0211ULL,
0x0000000136367824ULL, 0x000fe200078e0211ULL, 0xfffffff8103b7812ULL, 0x000fe200078ee20dULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x000063000c0d7a11ULL, 0x000fc400028f3cffULL,
0x0000000e050e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000138107824ULL, 0x000fe200078e0211ULL,
0x0000005634347212ULL, 0x000fe200078efcffULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000005636367212ULL, 0x000fc600078efcffULL,
0x000000010f0f7824ULL, 0x000fe200028e060dULL, 0x0000000534347210ULL, 0x000fe20007fbe0ffULL,
0x00000001383a7824ULL, 0x000fe200078e0204ULL, 0x0000005610107212ULL, 0x000fc600078efcffULL,
0x0000000135357824ULL, 0x100fe200028e060dULL, 0x0000000536367210ULL, 0x080fe40007fbe0ffULL,
0x0000000510107210ULL, 0x000fe20007fde0ffULL, 0x0000001039057824ULL, 0x000fe200078e026aULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee23aULL, 0x0000000137377824ULL, 0x100fe400028e060dULL,
0x0000000111117824ULL, 0x000fe200030e060dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e057faeULL, 0x0003e2000e101c48ULL, 0x000000103b0d7824ULL, 0x000fc400078e026aULL,
0x000000103d397824ULL, 0x100fe400078e026aULL, 0x000000103f3b7824ULL, 0x000fe200078e026aULL,
0x00000000340d7faeULL, 0x0003e8000d901c48ULL, 0x0000000036397faeULL, 0x0003e8000d101c48ULL,
0x00000000103b7faeULL, 0x0003e2000c101c48ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x000000100f0f7812ULL, 0x000fc800078ec0ffULL, 0x0000000f040f7211ULL, 0x000fc800078fe8ffULL,
0x000000040f0d7810ULL, 0x040fe20007ffe0ffULL, 0x000000010f057824ULL, 0x140fe200078e0204ULL,
0x000000080f357810ULL, 0x040fe20007ffe0ffULL, 0x000000080f0e7824ULL, 0x040fe200078e00ffULL,
0x0000000c0f377810ULL, 0x040fe20007ffe0ffULL, 0x000000010f107824ULL, 0x100fe400078e0211ULL,
0x000000010d347824ULL, 0x040fe200078e0211ULL, 0xfffffff80e057812ULL, 0x000fe200078ee205ULL,
0x000000010d0f7824ULL, 0x040fe400078e0204ULL, 0x000000080d387824ULL, 0x000fc400078e00ffULL,
0x00000001350d7824ULL, 0x140fe400078e0204ULL, 0x00000008353a7824ULL, 0x040fe200078e00ffULL,
0xfffffff8383b7812ULL, 0x000fe200078ee20fULL, 0x0000000135367824ULL, 0x100fe400078e0211ULL,
0x00000001370e7824ULL, 0x040fe200078e0211ULL, 0xfffffff83a3d7812ULL, 0x000fe200078ee20dULL,
0x0000000137357824ULL, 0x040fe200078e0204ULL, 0x000062000c0d7a11ULL, 0x000fe200078038ffULL,
0x00000008373c7824ULL, 0x000fc400078e00ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000063000c397a11ULL, 0x000fe400000f3cffULL, 0xfffffff83c3f7812ULL, 0x000fe200078ee235ULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000005610107212ULL, 0x000fc600078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x000000100d107210ULL, 0x040fe40007f1e0ffULL,
0x0000005634347212ULL, 0x080fe200078efcffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000005636367212ULL, 0x000fe400078efcffULL, 0x000000340d347210ULL, 0x000fe20007f5e0ffULL,
0x0000000111117824ULL, 0x100fe200000e0639ULL, 0x000000560e0e7212ULL, 0x000fe200078efcffULL,
0x0000001005057824ULL, 0x100fe200078e026aULL, 0x000000360d367210ULL, 0x000fe20007f1e0ffULL,
0x0000000135357824ULL, 0x100fe200010e0639ULL, 0x0000000e0d0e7210ULL, 0x000fe20007f7e0ffULL,
0x000000103b0d7824ULL, 0x000fe200078e026aULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010057faeULL, 0x0003e2000b901c48ULL, 0x0000000137377824ULL, 0x000fc400000e0639ULL,
0x000000010f0f7824ULL, 0x000fe200018e0639ULL, 0x00000000340d7faeULL, 0x0003e2000b901c48ULL,
0x000000103d397824ULL, 0x100fe400078e026aULL, 0x000000103f3b7824ULL, 0x000fc600078e026aULL,
0x0000000036397faeULL, 0x0003e8000b901c48ULL, 0x000000000e3b7faeULL, 0x0003e4000b901c48ULL,
0x0000000800057824ULL, 0x002fca00078e00ffULL, 0xfffffff005057812ULL, 0x000fc800078ec0ffULL,
0x00000000050573c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000f6a805057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800050e7f8cULL, 0x0002e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6280009107f8cULL, 0x0002a4000c80043fULL, 0x0000000000347805ULL, 0x000fc40000015200ULL,
0x00f62c0009057984ULL, 0x002e640000000800ULL, 0x8000000005ff7812ULL, 0x006fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003634367210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc80000011437ULL,
0x0000003605057211ULL, 0x000fca00078110ffULL, 0x000000ffff367224ULL, 0x000fca00000e0637ULL,
0x0000000205057819ULL, 0x000fc80000001236ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f62c0009057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002000057824ULL, 0x000fca00078e00ffULL, 0xffffff8005057812ULL, 0x000fc800078ec0ffULL,
0x0000008056057810ULL, 0x000fca0007ffe005ULL, 0x0000000170057824ULL, 0x000fca00078e0205ULL,
0x00f0000005357984ULL, 0x000e680000000800ULL, 0x00f2000005347984ULL, 0x0004e20000000800ULL,
0x000000023500720bULL, 0x002fe20003f1d000ULL, 0x0000d6127f007947ULL, 0x000fd8000b800000ULL,
0x00000000000d7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0d367812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0d7424ULL, 0x000fe400078e00ffULL,
0x000000ffff057224ULL, 0x000fd200078e0002ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000016d057810ULL, 0x000fe40007ffe0ffULL, 0x000000023500720bULL, 0x000fe40003f54000ULL,
0x000000000500720cULL, 0x000fe20003f05270ULL, 0x0000d5b27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000057806ULL, 0x000fc400010e0100ULL, 0x0000008000118824ULL, 0x000fe200078e0256ULL,
0x00000002350d8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991005107816ULL, 0x000fe200000000ffULL, 0x0000000170388824ULL, 0x000fca00078e0211ULL,
0x00f4000d38008388ULL, 0x0003e20000000800ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x00000002350d7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff05ff7812ULL, 0x000fc6000780c0ffULL,
0x000000020d0d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d00387308ULL, 0x000e640000000800ULL, 0x0000003803037220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011604ULL,
0x0000d4d27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d380d7589ULL, 0x0002a400000e0000ULL,
0x0000000d30307220ULL, 0x084fe20000410000ULL, 0x0000000d31317220ULL, 0x080fe20000410000ULL,
0x0000000d2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000d28287220ULL, 0x080fe20000410000ULL, 0x0000000d29297220ULL, 0x080fe20000410000ULL,
0x0000000d24247220ULL, 0x080fe20000410000ULL, 0x0000000d25257220ULL, 0x080fe20000410000ULL,
0x0000000d20207220ULL, 0x080fe20000410000ULL, 0x0000000d21217220ULL, 0x080fe20000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000d1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000d18187220ULL, 0x080fe20000410000ULL, 0x0000000d19197220ULL, 0x080fe20000410000ULL,
0x0000000d14147220ULL, 0x080fe20000410000ULL, 0x0000000d15157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0005ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008040d7811ULL, 0x000fe200078ff0ffULL,
0x0000d3b27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d380d7589ULL, 0x00046400000e0000ULL,
0x0000000d32327220ULL, 0x086fe20000410000ULL, 0x0000000d33337220ULL, 0x080fe20000410000ULL,
0x0000000d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000d2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000d2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000d26267220ULL, 0x080fe20000410000ULL, 0x0000000d27277220ULL, 0x080fe20000410000ULL,
0x0000000d22227220ULL, 0x080fe20000410000ULL, 0x0000000d23237220ULL, 0x080fe20000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000d1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000d1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000d1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000d16167220ULL, 0x080fe20000410000ULL, 0x0000000d17177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff36ff7812ULL, 0x000fe20007806005ULL,
0x00000001ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000000235057209ULL, 0x000fd60007810000ULL,
0x8000000535350221ULL, 0x000fe20000010000ULL, 0x00007610ff0d0816ULL, 0x000fc6000000000dULL,
0x3fb8aa3b35350820ULL, 0x000fc80000410000ULL, 0x0000003500080308ULL, 0x000e640000000800ULL,
0x0000000834340220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000334037221ULL, 0x008fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x0000000800027824ULL, 0x000fca00078e00ffULL, 0xfffffff002367812ULL, 0x000fca00078ec0ffULL,
0x00f6b40036357984ULL, 0x000e640000000800ULL, 0x8000000035ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003410377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e11ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x000fc80000011435ULL,
0x0000003702027211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000202027819ULL, 0x000fc80000001235ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b40036357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100d027816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0200720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000008ff02723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe40000011604ULL,
0x0000541002027816ULL, 0x000fe20000000002ULL, 0x0000cf627f007947ULL, 0x000fea000b800000ULL,
0x00001f1302077589ULL, 0x0002a400000e0000ULL, 0x00000008130d7810ULL, 0x000fe20007ffe0ffULL,
0x0000cf927f007947ULL, 0x000fea000b800000ULL, 0x00001f0d02067589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000010130d7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200078e0002ULL, 0x000055f000117802ULL, 0x000fc40000000f00ULL,
0x0000d7a000007944ULL, 0x006fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000018130d7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200078e0002ULL,
0x0000564000117802ULL, 0x000fc40000000f00ULL, 0x0000d75000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe40003800000ULL,
0x000010006a027810ULL, 0x00afe20007ffe0ffULL, 0x009800004e3c783bULL, 0x000e680000000200ULL,
0x0000001047407824ULL, 0x000fc400078e0202ULL, 0x0000001046107824ULL, 0x100fe400078e0202ULL,
0x000000104d387824ULL, 0x100fe400078e0202ULL, 0x000000004040783bULL, 0x000ee20000004200ULL,
0x000000104c347824ULL, 0x000fc600078e0202ULL, 0x000000001010783bULL, 0x000f280000004200ULL,
0x000000003838783bULL, 0x000ea80000004200ULL, 0x000000003434783bULL, 0x000ea40000004200ULL,
0x000000073c3c8232ULL, 0x006fc40000000000ULL, 0x000000073e3e8232ULL, 0x000fe40000000000ULL,
0x000000063d3d8232ULL, 0x080fe40000000000ULL, 0x000000063f3f8232ULL, 0x000fe20000000000ULL,
0x00000100405b7824ULL, 0x048fe200078e00ffULL, 0x00008880405a7816ULL, 0x000fe200000000ffULL,
0x0000010041607824ULL, 0x040fe200078e00ffULL, 0x00008880415e7816ULL, 0x040fe200000000ffULL,
0x0001000041617824ULL, 0x000fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x0000010010657824ULL, 0x010fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe20000011460ULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x00000018ff597819ULL, 0x000fc40000011441ULL,
0x00000018ff5f7819ULL, 0x000fe20000011440ULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe40000011461ULL, 0x0000888042637816ULL, 0x000fe200000000ffULL,
0x0000005b005b7306ULL, 0x000e620000200c00ULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x00000018ff5d7819ULL, 0x000fe40000011442ULL, 0x00000018ff587819ULL, 0x000fc40000011410ULL,
0x00000018ff547819ULL, 0x000fe20000011411ULL, 0x0000005e005e7306ULL, 0x000fe20000200c00ULL,
0x0000888011697816ULL, 0x000fe400000000ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011443ULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x00000018ff517819ULL, 0x000fe20000011439ULL,
0x0000006000417306ULL, 0x000ea20000200c00ULL, 0x00000018ff527819ULL, 0x000fc40000011412ULL,
0x00000018ff537819ULL, 0x000fe40000011413ULL, 0x00000018ff507819ULL, 0x000fe40000011438ULL,
0x00000018ff0d7819ULL, 0x000fe2000001143aULL, 0x0000004000667306ULL, 0x0003e20000200c00ULL,
0x00000018ff487819ULL, 0x000fe4000001143bULL, 0x00000018ff4a7819ULL, 0x000fe40000011434ULL,
0x00000018ff497819ULL, 0x000fc40000011435ULL, 0x00000018ff4f7819ULL, 0x000fe20000011436ULL,
0x0000005f005f7306ULL, 0x000ee20000200c00ULL, 0x000054105a407816ULL, 0x002fe2000000005bULL,
0x00000100425b7824ULL, 0x000fe200078e00ffULL, 0x000054105e417816ULL, 0x004fe20000000041ULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00008880435e7816ULL, 0x000fe400000000ffULL,
0x00000018ff5b7819ULL, 0x000fe2000001145bULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x00000018ff427819ULL, 0x000fe20000011442ULL, 0x000000403c30723cULL, 0x000be20000001830ULL,
0x00000018ff4b7819ULL, 0x000fca0000011437ULL, 0x0000006100627306ULL, 0x000e620000200c00ULL,
0x0000010043407824ULL, 0x060fe200078e00ffULL, 0x0000888010417816ULL, 0x040fe200000000ffULL,
0x0001000010107824ULL, 0x000fe400078e00ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x00000063005a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff437819ULL, 0x000fca0000011443ULL,
0x0000004000617306ULL, 0x0007f00000200c00ULL, 0x0000005b005b7306ULL, 0x000ea20000200c00ULL,
0x0000541066407816ULL, 0x008fce000000005fULL, 0x00000041005f7306ULL, 0x0003f00000200c00ULL,
0x0000005e005e7306ULL, 0x000ee20000200c00ULL, 0x0000541062417816ULL, 0x002fce0000000059ULL,
0x000000403c2c723cULL, 0x000be2000000182cULL, 0x0000004200637306ULL, 0x000fec0000200c00ULL,
0x0000010011407824ULL, 0x060fe200078e00ffULL, 0x0000888012417816ULL, 0x000fe200000000ffULL,
0x0001000011117824ULL, 0x000fe200078e00ffULL, 0x0000001000427306ULL, 0x0005e40000200c00ULL,
0x00000018ff407819ULL, 0x000fc40000011440ULL, 0x00000018ff117819ULL, 0x000fc80000011411ULL,
0x0000001100597306ULL, 0x0007e20000200c00ULL, 0x000054105a107816ULL, 0x004fce000000005bULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x000054105e117816ULL, 0x008fe40000000061ULL,
0x0000888013617816ULL, 0x000fca00000000ffULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x000000103c28723cULL, 0x000b6e0000001828ULL, 0x0000004300607306ULL, 0x0002a20000200c00ULL,
0x0000010013107824ULL, 0x020fe400078e00ffULL, 0x0000010038117824ULL, 0x000fc400078e00ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000041005a7306ULL, 0x0007e20000200c00ULL, 0x0000010012437824ULL, 0x042fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0001000012127824ULL, 0x000fc600078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000001000627306ULL, 0x0003e20000200c00ULL,
0x00000018ff417819ULL, 0x008fe40000011411ULL, 0x0000541060117816ULL, 0x004fe4000000005cULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x000088803b5c7816ULL, 0x000fe200000000ffULL,
0x0000006500667306ULL, 0x0005e20000200c00ULL, 0x0000541063107816ULL, 0x002fc4000000005dULL,
0x00008880395d7816ULL, 0x000fca00000000ffULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x000000103c24723cULL, 0x000bee0000001824ULL, 0x00000040006e7306ULL, 0x0002e20000200c00ULL,
0x0000010039107824ULL, 0x060fe400078e00ffULL, 0x0001000039397824ULL, 0x000fc400078e00ffULL,
0x000001003a117824ULL, 0x000fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x00000018ff657819ULL, 0x004fe20000011439ULL, 0x0000005800587306ULL, 0x000ea20000200c00ULL,
0x00000018ff397819ULL, 0x000fe40000011411ULL, 0x0000888038407816ULL, 0x042fe200000000ffULL,
0x0001000038387824ULL, 0x000fe200078e00ffULL, 0x0000541069117816ULL, 0x008fc6000000006eULL,
0x0000001000607306ULL, 0x0003e20000200c00ULL, 0x00000018ff637819ULL, 0x000fe40000011438ULL,
0x000088803a387816ULL, 0x040fe200000000ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x0000541042587816ULL, 0x004fc60000000058ULL, 0x00000012005e7306ULL, 0x000fe20000200c00ULL,
0x000054105f107816ULL, 0x002fe40000000066ULL, 0x00000018ff3a7819ULL, 0x000fca000001143aULL,
0x000000103c20723cULL, 0x000b620000001820ULL, 0x00000013005b7306ULL, 0x000fec0000200c00ULL,
0x000001003b107824ULL, 0x060fe200078e00ffULL, 0x0000888034117816ULL, 0x000fe200000000ffULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x000100003b3b7824ULL, 0x000fc400078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x000000ffff427224ULL, 0x000fe400078e0011ULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x00000010005f7306ULL, 0x0005f00000200c00ULL,
0x0000004300437306ULL, 0x000fe20000200c00ULL, 0x009800004510783bULL, 0x004ea20000000200ULL,
0x0000541059597816ULL, 0x002fe20000000054ULL, 0x0000010034547824ULL, 0x000fc400078e00ffULL,
0x0001000034347824ULL, 0x000fc600078e00ffULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x000000583c1c723cULL, 0x000f62000000181cULL, 0x00000018ff347819ULL, 0x000fcc0000011434ULL,
0x0000005200527306ULL, 0x000e700000200c00ULL, 0x0000005300537306ULL, 0x000ef00000200c00ULL,
0x0000003800387306ULL, 0x000fe20000200c00ULL, 0x000054105e527816ULL, 0x002fce0000000052ULL,
0x0000003900397306ULL, 0x000e620000200c00ULL, 0x000054105b537816ULL, 0x008fe20000000053ULL,
0x0000000710108232ULL, 0x084fe40000000000ULL, 0x0000000712128232ULL, 0x000fe40000000000ULL,
0x0000000611118232ULL, 0x080fe40000000000ULL, 0x0000005c005c7306ULL, 0x000ea20000200c00ULL,
0x000000523c14723cULL, 0x000fe20000001814ULL, 0x0000000613138232ULL, 0x000fcc0000000000ULL,
0x0000003a00697306ULL, 0x0007e20000200c00ULL, 0x0000541038387816ULL, 0x002fce0000000039ULL,
0x0000003b00667306ULL, 0x0003e20000200c00ULL, 0x00000018ff3a7819ULL, 0x008fe20000011454ULL,
0x0000010035547824ULL, 0x000fe200078e00ffULL, 0x000054105c397816ULL, 0x004fc8000000005fULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000003a00457306ULL, 0x0005e20000200c00ULL,
0x00008880353b7816ULL, 0x042fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x000000381028723cULL, 0x000fe80000001828ULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x0000004000407306ULL, 0x000fe20000200c00ULL, 0x000054105a3a7816ULL, 0x004fce0000000043ULL,
0x0000003b00437306ULL, 0x0003f00000200c00ULL, 0x0000004100417306ULL, 0x000ea20000200c00ULL,
0x00005410613b7816ULL, 0x002fce0000000062ULL, 0x0000003a3c18723cULL, 0x000b620000001818ULL,
0x0000005000507306ULL, 0x000fec0000200c00ULL, 0x00000100363b7824ULL, 0x060fe200078e00ffULL,
0x00008880363a7816ULL, 0x040fe200000000ffULL, 0x00000100373d7824ULL, 0x040fe200078e00ffULL,
0x00008880373c7816ULL, 0x040fe200000000ffULL, 0x0001000036367824ULL, 0x000fe200078e00ffULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0001000037377824ULL, 0x000fe200078e00ffULL,
0x00000018ff3d7819ULL, 0x000fe2000001143dULL, 0x0000003a003a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff367819ULL, 0x000fc40000011436ULL, 0x00000018ff397819ULL, 0x000fe40000011437ULL,
0x0000541040407816ULL, 0x004fc60000000041ULL, 0x0000003b003b7306ULL, 0x000e700000200c00ULL,
0x0000005100517306ULL, 0x000ff00000200c00ULL, 0x0000000d000d7306ULL, 0x000fe20000200c00ULL,
0x000054103a3a7816ULL, 0x002fce000000003bULL, 0x0000004800487306ULL, 0x000e700000200c00ULL,
0x0000004a004a7306ULL, 0x000ff00000200c00ULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x0000541066377816ULL, 0x002fce0000000048ULL, 0x0000004f004f7306ULL, 0x000ff00000200c00ULL,
0x0000004b004b7306ULL, 0x000ff00000200c00ULL, 0x0000005d005d7306ULL, 0x000e700000200c00ULL,
0x0000006300637306ULL, 0x000eb00000200c00ULL, 0x0000006500657306ULL, 0x000ee20000200c00ULL,
0x000054105d417816ULL, 0x002fce0000000060ULL, 0x0000004200427306ULL, 0x000e620000200c00ULL,
0x0000541063507816ULL, 0x004fe20000000050ULL, 0x000000401030723cULL, 0x000f6c0000001830ULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x0000541065517816ULL, 0x008fce0000000051ULL,
0x0000003400347306ULL, 0x000ee20000200c00ULL, 0x0000541042427816ULL, 0x002fe20000000045ULL,
0x00000050102c723cULL, 0x000f6c000000182cULL, 0x0000003500357306ULL, 0x000e620000200c00ULL,
0x0000541043437816ULL, 0x004fce0000000054ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000541034347816ULL, 0x008fe2000000004aULL, 0x000000421020723cULL, 0x000f6c0000001820ULL,
0x0000003d003d7306ULL, 0x000ea20000200c00ULL, 0x0000541035357816ULL, 0x002fce0000000049ULL,
0x0000003600387306ULL, 0x0002e20000200c00ULL, 0x00000034101c723cULL, 0x000f6e000000181cULL,
0x00000039003e7306ULL, 0x000f220000200c00ULL, 0x0000541069367816ULL, 0x002fe2000000000dULL,
0x00000002000d7824ULL, 0x000fe200078e00ffULL, 0x000054103c3b7816ULL, 0x004fc4000000003dULL,
0x0000541038387816ULL, 0x008fc6000000004fULL, 0x000000361024723cULL, 0x000f620000001824ULL,
0x000054103e397816ULL, 0x010fce000000004bULL, 0x0000003a1018723cULL, 0x040f700000001818ULL,
0x000000381014723cULL, 0x000b6e0000001814ULL, 0x0000f6c844107811ULL, 0x020fc400078e18ffULL,
0xfffffff80d127812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x0000000010107f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6900012ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff0d7224ULL, 0x000fc600078e00ffULL,
0x0000000000127805ULL, 0x004fc80000015200ULL, 0x000004000a357984ULL, 0x000ea40000000800ULL,
0x8000000035ff7812ULL, 0x006fe40007804811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100d00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003412377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e13ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010d0d7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000a357984ULL, 0x000e640000000800ULL,
0x8000000035ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001000b127824ULL, 0x000fca00078e0276ULL, 0x000000c012117810ULL, 0x000fc80007ffe0ffULL,
0x0000006011107812ULL, 0x000fca00078ec0ffULL, 0x000000016b137824ULL, 0x000fe200078e0210ULL,
0x0000040000009947ULL, 0x000fea0003800000ULL, 0x00000011640d7217ULL, 0x000fe20007800000ULL,
0x0000001000107824ULL, 0x000fe200078e00ffULL, 0x000062000c3b7a11ULL, 0x000fc600078a38ffULL,
0x000000010d0d7824ULL, 0x000fe200078e0a11ULL, 0x0000001010107812ULL, 0x000fe400078ec0ffULL,
0x00000003ff117819ULL, 0x000fe40000011604ULL, 0x0000000d100d7217ULL, 0x000fe40007800000ULL,
0x0000000411347810ULL, 0x040fe40007ffe0ffULL, 0x0000000811357810ULL, 0x000fe20007ffe0ffULL,
0x000000010d0d7824ULL, 0x000fe200078e0a10ULL, 0x0000000c11367810ULL, 0x000fc40007ffe0ffULL,
0x000063000c3d7a11ULL, 0x000fe400028f3cffULL, 0x0000000d1100720cULL, 0x0c0fe20003f86070ULL,
0x0000000111117824ULL, 0x100fe200078e0210ULL, 0x0000000d3400720cULL, 0x0c0fe20003f66070ULL,
0x0000000134347824ULL, 0x100fe200078e0210ULL, 0x0000000d3500720cULL, 0x0c0fe20003f46070ULL,
0x0000000135357824ULL, 0x100fe200078e0210ULL, 0x0000000d3600720cULL, 0x040fe20003f06070ULL,
0x0000000136387824ULL, 0x000fe400078e0210ULL, 0x00000001110d7824ULL, 0x000fc400078e0204ULL,
0x0000000811367824ULL, 0x040fe400078e00ffULL, 0x0000000111107824ULL, 0x000fe400078e0213ULL,
0x0000000134117824ULL, 0x100fe200078e0204ULL, 0xfffffff836397812ULL, 0x000fe200078ee20dULL,
0x00000008343a7824ULL, 0x000fe400078e00ffULL, 0x00000001350d7824ULL, 0x040fe400078e0204ULL,
0x0000000835367824ULL, 0x000fe200078e00ffULL, 0xfffffff83a3f7812ULL, 0x000fe200078ee211ULL,
0x0000008010107825ULL, 0x000fc600078e00ffULL, 0xfffffff836417812ULL, 0x000fe200078ee20dULL,
0x0000000134347824ULL, 0x100fe200078e0213ULL, 0x0000005610107212ULL, 0x000fe200078efcffULL,
0x0000000135367824ULL, 0x000fe400078e0213ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000003b10107210ULL, 0x000fc60007fbe0ffULL, 0x00000001380d7824ULL, 0x000fe200078e0213ULL,
0x0000005634347212ULL, 0x000fe200078efcffULL, 0x0000008036367825ULL, 0x000fc800078e00ffULL,
0x000000800d0c7825ULL, 0x000fe200078e00ffULL, 0x0000005636367212ULL, 0x000fc600078efcffULL,
0x0000000111117824ULL, 0x100fe200028e063dULL, 0x0000003b34347210ULL, 0x080fe20007fbe0ffULL,
0x0000000138137824ULL, 0x000fe200078e0204ULL, 0x000000560c0c7212ULL, 0x000fe200078efcffULL,
0x0000000838387824ULL, 0x000fe400078e00ffULL, 0x0000000135357824ULL, 0x000fe200028e063dULL,
0x0000003b36367210ULL, 0x080fe40007fbe0ffULL, 0x0000003b0c0c7210ULL, 0x000fe20007fde0ffULL,
0x00000010413b7824ULL, 0x100fe200078e0202ULL, 0xfffffff838437812ULL, 0x000fe200078ee213ULL,
0x0000001039137824ULL, 0x000fc400078e0202ULL, 0x000000103f397824ULL, 0x100fe400078e0202ULL,
0x0000000137377824ULL, 0x100fe200028e063dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0003e2000e101c48ULL, 0x000000010d0d7824ULL, 0x000fe400030e063dULL,
0x00000010433d7824ULL, 0x000fe200078e0202ULL, 0x0000000034397faeULL, 0x0003e8000d901c48ULL,
0x00000000363b7faeULL, 0x0003e8000d101c48ULL, 0x000000000c3d7faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x00000010000d7824ULL, 0x000fca00078e00ffULL,
0x000000100d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000d040d7211ULL, 0x000fc800078fe8ffULL,
0x000000040d117810ULL, 0x040fe20007ffe0ffULL, 0x000000010d107824ULL, 0x040fe200078e0204ULL,
0x000000080d357810ULL, 0x040fe20007ffe0ffULL, 0x000000080d3b7824ULL, 0x040fe200078e00ffULL,
0x0000000c0d377810ULL, 0x040fe20007ffe0ffULL, 0x000000010d367824ULL, 0x100fe400078e0213ULL,
0x0000000111387824ULL, 0x100fe200078e0213ULL, 0xfffffff83b3b7812ULL, 0x000fe200078ee210ULL,
0x0000000135347824ULL, 0x100fe400078e0213ULL, 0x0000000137107824ULL, 0x000fc400078e0213ULL,
0x0000000137137824ULL, 0x140fe400078e0204ULL, 0x00000008373e7824ULL, 0x000fe400078e00ffULL,
0x00000001110d7824ULL, 0x140fe400078e0204ULL, 0x00000008113a7824ULL, 0x000fe200078e00ffULL,
0xfffffff83e437812ULL, 0x000fe200078ee213ULL, 0x0000000135117824ULL, 0x040fe200078e0204ULL,
0x000062000c137a11ULL, 0x000fe200078038ffULL, 0x00000008353c7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3f7812ULL, 0x000fe200078ee20dULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x000063000c3d7a11ULL, 0x000fc400000f3cffULL, 0xfffffff83c417812ULL, 0x000fe200078ee211ULL,
0x0000008038387825ULL, 0x000fe200078e00ffULL, 0x00000056360d7212ULL, 0x000fc600078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000005638367212ULL, 0x080fe400078efcffULL,
0x000000130d0c7210ULL, 0x080fe20007f1e0ffULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000005634347212ULL, 0x080fe400078efcffULL, 0x0000001336367210ULL, 0x080fe20007f5e0ffULL,
0x00000001370d7824ULL, 0x100fe200000e063dULL, 0x0000005610107212ULL, 0x000fe400078efcffULL,
0x0000001334347210ULL, 0x080fe20007f1e0ffULL, 0x0000000139377824ULL, 0x000fe200010e063dULL,
0x0000001310107210ULL, 0x000fe20007f7e0ffULL, 0x000000103b137824ULL, 0x000fc400078e0202ULL,
0x000000103f397824ULL, 0x100fe400078e0202ULL, 0x0000000135357824ULL, 0x100fe200000e063dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c137faeULL, 0x0003e2000b901c48ULL,
0x0000000111117824ULL, 0x000fe400018e063dULL, 0x00000010413b7824ULL, 0x100fe200078e0202ULL,
0x0000000036397faeULL, 0x0003e2000b901c48ULL, 0x00000010433d7824ULL, 0x000fc600078e0202ULL,
0x00000000343b7faeULL, 0x0003e8000b901c48ULL, 0x00000000103d7faeULL, 0x0003e4000b901c48ULL,
0x00000000710573c2ULL, 0x000ea200000e0000ULL, 0x0000000255557810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0c7424ULL, 0x002fe200078e00ffULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x000000685500720cULL, 0x000fda0003f06070ULL, 0x0000000155108824ULL, 0x000fe400078e026cULL,
0x00000004ff118424ULL, 0x000fe200078e00ffULL, 0x0000f6b005057890ULL, 0x004fc6000fffe03fULL,
0x0000640010108625ULL, 0x000fca00078e0011ULL, 0x00000008100c8981ULL, 0x000322000c1e1900ULL,
0x00000008000d7824ULL, 0x000fc600078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a05ULL,
0xfffffff00d0d7812ULL, 0x000fe200078ec0ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6b0000d347f8cULL, 0x0004e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480009107f8cULL, 0x0022a4000c80043fULL,
0x0000000000367805ULL, 0x000fc40000015200ULL, 0x00f64c00090d7984ULL, 0x004ea40000000800ULL,
0x800000000dff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff137224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000387805ULL, 0x000fcc0000015200ULL,
0x0000003836387210ULL, 0x000fca0007f1e1ffULL, 0x0000000139397824ULL, 0x000fe200000e0e37ULL,
0x003d09003800780cULL, 0x000fc80003f06070ULL, 0x000000ff3900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403800780cULL, 0x000fc80003f06070ULL,
0x000000ff3900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc80000011439ULL, 0x000000380d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff387224ULL, 0x000fca00000e0639ULL, 0x000000020d0d7819ULL, 0x000fc80000001238ULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000113137810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f64c00090d7984ULL, 0x000ea40000000800ULL, 0x800000000dff7812ULL, 0x004fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000097824ULL, 0x002fca00078e00ffULL,
0xffffff8009097812ULL, 0x000fc800078ec0ffULL, 0x0000010056097810ULL, 0x000fca0007ffe009ULL,
0x0000000170097824ULL, 0x000fca00078e0209ULL, 0x00f0000009367984ULL, 0x000e680000000800ULL,
0x00f2000009137984ULL, 0x0004e20000000800ULL, 0x000000053600720bULL, 0x002fe20003f1d000ULL,
0x0000b1e27f007947ULL, 0x000fd8000b800000ULL, 0x00000000000d7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0d387812ULL, 0x000fe2000780c0ffULL, 0x000004a000007945ULL, 0x000fe20003800000ULL,
0x00000001ff097424ULL, 0x000fd600078e00ffULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000026d097810ULL, 0x000fe40007ffe0ffULL, 0x000000053600720bULL, 0x000fe40003f54000ULL,
0x000000000900720cULL, 0x000fe20003f05270ULL, 0x0000b1927f007947ULL, 0x000fd4000b800000ULL,
0x0000000000097806ULL, 0x000fc400010e0100ULL, 0x0000008000118824ULL, 0x000fe200078e0256ULL,
0x00000005360d8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991009107816ULL, 0x000fe200000000ffULL, 0x00000001703a8824ULL, 0x000fca00078e0211ULL,
0x00f4000d3a008388ULL, 0x0003e20000000800ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000000536107209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff09ff7812ULL, 0x000fc6000780c0ffULL,
0x00000005100d7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL,
0x0000000d003a7308ULL, 0x000e640000000800ULL, 0x0000003a03037220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0d7819ULL, 0x000fe20000011604ULL,
0x0000b0b27f007947ULL, 0x000fea000b800000ULL, 0x00001f0d3a0d7589ULL, 0x0002a400000e0000ULL,
0x0000000d30307220ULL, 0x084fe20000410000ULL, 0x0000000d31317220ULL, 0x080fe20000410000ULL,
0x0000000d2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000d2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000d28287220ULL, 0x080fe20000410000ULL, 0x0000000d29297220ULL, 0x080fe20000410000ULL,
0x0000000d24247220ULL, 0x080fe20000410000ULL, 0x0000000d25257220ULL, 0x080fe20000410000ULL,
0x0000000d20207220ULL, 0x080fe20000410000ULL, 0x0000000d21217220ULL, 0x080fe20000410000ULL,
0x0000000d1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000d1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000d18187220ULL, 0x080fe20000410000ULL, 0x0000000d19197220ULL, 0x080fe20000410000ULL,
0x0000000d14147220ULL, 0x080fe20000410000ULL, 0x0000000d15157220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0009ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008040d7811ULL, 0x000fe200078ff0ffULL,
0x0000af927f007947ULL, 0x000fea000b800000ULL, 0x00001f0d3a0d7589ULL, 0x00046400000e0000ULL,
0x0000000d32327220ULL, 0x086fe20000410000ULL, 0x0000000d33337220ULL, 0x080fe20000410000ULL,
0x0000000d2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000d2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000d2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000d2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000d26267220ULL, 0x080fe20000410000ULL, 0x0000000d27277220ULL, 0x080fe20000410000ULL,
0x0000000d22227220ULL, 0x080fe20000410000ULL, 0x0000000d23237220ULL, 0x080fe20000410000ULL,
0x0000000d1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000d1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000d1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000d1b1b7220ULL, 0x080fe20000410000ULL,
0x0000000d16167220ULL, 0x080fe20000410000ULL, 0x0000000d17177220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff38ff7812ULL, 0x000fe20007806009ULL,
0x00000001ff097424ULL, 0x000fe200078e00ffULL, 0x0000000536057209ULL, 0x000fd60007810000ULL,
0x8000000536360221ULL, 0x000fe20000010000ULL, 0x00007610ff090816ULL, 0x000fc60000000009ULL,
0x3fb8aa3b36360820ULL, 0x000fc80000410000ULL, 0x0000003600080308ULL, 0x000e640000000800ULL,
0x0000000813130220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000313037221ULL, 0x008fc20000010000ULL, 0x0000000000107805ULL, 0x000fcc0000015200ULL,
0x00000008000d7824ULL, 0x000fca00078e00ffULL, 0xfffffff00d137812ULL, 0x000fca00078ec0ffULL,
0x00f6ac00130d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff387224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fcc0000015200ULL, 0x0000003610367210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e11ULL, 0x003d09003600780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403600780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011437ULL,
0x000000360d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff367224ULL, 0x000fca00000e0637ULL,
0x000000020d0d7819ULL, 0x000fc80000001236ULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000138387810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6ac00130d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991009097816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0900720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000008ff06723eULL, 0x000fe400000000ffULL, 0x00000002ff0e7819ULL, 0x000fe40000011604ULL,
0x0000541006097816ULL, 0x000fe20000000006ULL, 0x0000ab427f007947ULL, 0x000fea000b800000ULL,
0x00001f0e09077589ULL, 0x0002a400000e0000ULL, 0x000000080e0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000ab727f007947ULL, 0x000fea000b800000ULL, 0x00001f0d09067589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100e0d7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200078e0009ULL, 0x00007bd000117802ULL, 0x000fc40000000f00ULL,
0x0000b1c000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180e0d7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200078e0009ULL,
0x00007c2000117802ULL, 0x000fc40000000f00ULL, 0x0000b17000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000010473c7824ULL, 0x100fe200078e026aULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000001046487824ULL, 0x000fc400078e026aULL,
0x000000104c387824ULL, 0x100fe400078e026aULL, 0x000000003c3c783bULL, 0x000ee20000004200ULL,
0x000000104d407824ULL, 0x000fc600078e026aULL, 0x000000004848783bULL, 0x000ea80000004200ULL,
0x000000004040783bULL, 0x000e680000004200ULL, 0x000000003838783bULL, 0x000fe20000004200ULL,
0x00000018ff507819ULL, 0x008fe2000001143cULL, 0x000001003c4c7824ULL, 0x040fe200078e00ffULL,
0x000088803c547816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001143dULL, 0x000001003d517824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x000100003f5a7824ULL, 0x000fe200078e00ffULL,
0x000088803d587816ULL, 0x040fe200000000ffULL, 0x000100003d3d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000004c00597306ULL, 0x0007e20000200c00ULL,
0x00000018ff097819ULL, 0x002fe2000001143eULL, 0x00000100485c7824ULL, 0x004fe200078e00ffULL,
0x000088803e697816ULL, 0x000fc400000000ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x00000018ff5b7819ULL, 0x000fe20000011451ULL, 0x0000003c00527306ULL, 0x0003e20000200c00ULL,
0x000001003e4c7824ULL, 0x048fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001143fULL,
0x000100003e3e7824ULL, 0x000fe200078e00ffULL, 0x000088803f617816ULL, 0x040fe400000000ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001144cULL, 0x0000003d00517306ULL, 0x0005e20000200c00ULL,
0x000001003f3c7824ULL, 0x002fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fc4000001143eULL,
0x00000018ff607819ULL, 0x000fe4000001145cULL, 0x00000018ff6f7819ULL, 0x000fe4000001143cULL,
0x0000005400547306ULL, 0x000e620000200c00ULL, 0x00a000004e3c783bULL, 0x0044e20000000200ULL,
0x00000018ff477819ULL, 0x000fe40000011449ULL, 0x00008880495c7816ULL, 0x000fe400000000ffULL,
0x00000018ff537819ULL, 0x000fc40000011448ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x00000100494e7824ULL, 0x044fe200078e00ffULL, 0x00008880485d7816ULL, 0x040fe200000000ffULL,
0x0001000049497824ULL, 0x000fe200078e00ffULL, 0x00000018ff5a7819ULL, 0x000fe4000001145aULL,
0x00000018ff637819ULL, 0x000fe2000001144eULL, 0x00010000484e7824ULL, 0x000fe200078e00ffULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x0000541054487816ULL, 0x002fe40000000059ULL,
0x00000018ff547819ULL, 0x000fc40000011449ULL, 0x00000018ff367819ULL, 0x000fe40000011440ULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000005000507306ULL, 0x000e620000200c00ULL,
0x00000018ff377819ULL, 0x000fe40000011441ULL, 0x00000018ff467819ULL, 0x000fe4000001144aULL,
0x00000018ff457819ULL, 0x000fe4000001144bULL, 0x00000018ff107819ULL, 0x000fe20000011442ULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x0000541058497816ULL, 0x004fc4000000005bULL,
0x000088804a5b7816ULL, 0x000fe400000000ffULL, 0x000088804b587816ULL, 0x000fe400000000ffULL,
0x00000018ff117819ULL, 0x000fe20000011443ULL, 0x0000005a00667306ULL, 0x000fe20000200c00ULL,
0x000000073c3c8232ULL, 0x088fe20000000000ULL, 0x00000018ff0e7819ULL, 0x000fe20000011438ULL,
0x000000073e3e8232ULL, 0x000fe20000000000ULL, 0x00000018ff0d7819ULL, 0x000fe20000011439ULL,
0x000000063d3d8232ULL, 0x080fe20000000000ULL, 0x00000018ff137819ULL, 0x000fe2000001143aULL,
0x000000063f3f8232ULL, 0x000fe20000000000ULL, 0x0000000900097306ULL, 0x000fe20000200c00ULL,
0x00000018ff0f7819ULL, 0x000fca000001143bULL, 0x000000483c30723cULL, 0x000be40000001830ULL,
0x0000004c004c7306ULL, 0x000eaa0000200c00ULL, 0x000001004a487824ULL, 0x060fe400078e00ffULL,
0x000001004b497824ULL, 0x040fe200078e00ffULL, 0x0000006900697306ULL, 0x000fe20000200c00ULL,
0x000100004a4a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x000100004b4b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff497819ULL, 0x000fc40000011449ULL,
0x00000018ff4a7819ULL, 0x000fe4000001144aULL, 0x0000004800597306ULL, 0x0003e20000200c00ULL,
0x00000018ff4b7819ULL, 0x000fce000001144bULL, 0x00000049005a7306ULL, 0x0007e20000200c00ULL,
0x0000541052487816ULL, 0x002fce0000000050ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x0000541051497816ULL, 0x008fe4000000004dULL, 0x00008880404d7816ULL, 0x000fe400000000ffULL,
0x0000888041517816ULL, 0x000fc600000000ffULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x000000483c2c723cULL, 0x000b6e000000182cULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x0000010040487824ULL, 0x060fe400078e00ffULL, 0x0001000040407824ULL, 0x000fc400078e00ffULL,
0x0000010041497824ULL, 0x040fe200078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x0000004f004f7306ULL, 0x000e620000200c00ULL,
0x00000018ff407819ULL, 0x000fe40000011440ULL, 0x00000018ff527819ULL, 0x000fe40000011449ULL,
0x0000888042497816ULL, 0x000fc600000000ffULL, 0x0000004e00627306ULL, 0x0005f00000200c00ULL,
0x0000004800507306ULL, 0x0007e20000200c00ULL, 0x000054104c4e7816ULL, 0x004fe20000000009ULL,
0x0000010043097824ULL, 0x000fe200078e00ffULL, 0x00005410664f7816ULL, 0x002fc8000000004fULL,
0x00000018ff4c7819ULL, 0x000fe20000011409ULL, 0x0000004000657306ULL, 0x0003e20000200c00ULL,
0x00000018ff487819ULL, 0x008fe20000011441ULL, 0x0000004e3c24723cULL, 0x000b620000001824ULL,
0x0000541061417816ULL, 0x000fe4000000006fULL, 0x0000000704097812ULL, 0x000fc600078ec0ffULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x0000541069407816ULL, 0x002fe4000000006eULL,
0x00008880384e7816ULL, 0x020fca00000000ffULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x000000403c28723cULL, 0x000bee0000001828ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x0000000809417812ULL, 0x020fe200078ef804ULL, 0x0000010042407824ULL, 0x040fe200078e00ffULL,
0x0000000257097810ULL, 0x000fe20007ffe0ffULL, 0x0001000042427824ULL, 0x000fc600078e00ffULL,
0x00000018ff407819ULL, 0x000fe20000011440ULL, 0x0000006300637306ULL, 0x000e620000200c00ULL,
0x00000018ff427819ULL, 0x000fce0000011442ULL, 0x0000005300537306ULL, 0x000eb00000200c00ULL,
0x0000004800617306ULL, 0x0007f00000200c00ULL, 0x0000004a005e7306ULL, 0x0003e20000200c00ULL,
0x0000000841487824ULL, 0x008fc400078e00ffULL, 0x0000020000417824ULL, 0x000fc600078e00ffULL,
0xfffffff848097812ULL, 0x000fe200078ee209ULL, 0x000000ffff487224ULL, 0x000fe200078e004eULL,
0x0000004b005f7306ULL, 0x000fe20000200c00ULL, 0x00008880434a7816ULL, 0x042fe200000000ffULL,
0x0001000043437824ULL, 0x000fe200078e00ffULL, 0xfffff800414e7812ULL, 0x000fe400078ec0ffULL,
0x000054105c417816ULL, 0x000fe40000000063ULL, 0x00000018ff437819ULL, 0x000fe20000011443ULL,
0x00000040004b7306ULL, 0x0003e20000200c00ULL, 0x00000010094f7824ULL, 0x000fe200078e024eULL,
0x00005410624e7816ULL, 0x004fc40000000053ULL, 0x0000888039627816ULL, 0x000fc800000000ffULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x000054105d407816ULL, 0x002fce0000000060ULL,
0x0000004200607306ULL, 0x0003f00000200c00ULL, 0x00000043005d7306ULL, 0x0005e20000200c00ULL,
0x0000010038427824ULL, 0x042fe400078e00ffULL, 0x0001000038387824ULL, 0x000fc600078e00ffULL,
0x00000018ff537819ULL, 0x000fe40000011442ULL, 0x0000005400547306ULL, 0x000e620000200c00ULL,
0x000000403c40723cULL, 0x004be40000001820ULL, 0x00a000004f20783bULL, 0x0202aa0000000200ULL,
0x0000004600467306ULL, 0x000ef00000200c00ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x00005410544f7816ULL, 0x002fe20000000047ULL, 0x0000010039477824ULL, 0x000fc400078e00ffULL,
0x0001000039397824ULL, 0x000fc600078e00ffULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x0000005b005b7306ULL, 0x000e620000200c00ULL, 0x0000004e3c1c723cULL, 0x000b62000000181cULL,
0x000054105e467816ULL, 0x008fcc0000000046ULL, 0x0000005800587306ULL, 0x000ee20000200c00ULL,
0x00000018ff4e7819ULL, 0x020fe40000011438ULL, 0x00000018ff4f7819ULL, 0x000fca0000011439ULL,
0x0000003600367306ULL, 0x000ee20000200c00ULL, 0x000054105b387816ULL, 0x002fe20000000059ULL,
0x0000000720208232ULL, 0x084fe40000000000ULL, 0x0000000722228232ULL, 0x000fe40000000000ULL,
0x0000000621218232ULL, 0x080fe40000000000ULL, 0x0000003700377306ULL, 0x000e620000200c00ULL,
0x0000541058397816ULL, 0x008fe2000000005aULL, 0x0000000623238232ULL, 0x000fe20000000000ULL,
0x000001003a587824ULL, 0x000fca00078e00ffULL, 0x00000047005c7306ULL, 0x0005e20000200c00ULL,
0x0000541065367816ULL, 0x000fe20000000036ULL, 0x000000383c18723cULL, 0x000b620000001818ULL,
0x0000541061377816ULL, 0x002fca0000000037ULL, 0x0000001000107306ULL, 0x000e620000200c00ULL,
0x000054105f477816ULL, 0x004fe40000000045ULL, 0x000088803a397816ULL, 0x020fe200000000ffULL,
0x00000036202c723cULL, 0x000fe8000000182cULL, 0x0000001100117306ULL, 0x000ea80000200c00ULL,
0x000000463c14723cULL, 0x000b680000001814ULL, 0x0000004900497306ULL, 0x000fe20000200c00ULL,
0x0000541060107816ULL, 0x002fc40000000010ULL, 0x000001003b3e7824ULL, 0x060fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fe40000011458ULL, 0x000088803b3d7816ULL, 0x000fe400000000ffULL,
0x0000000e000e7306ULL, 0x000fe20000200c00ULL, 0x00000018ff367819ULL, 0x000fe2000001143eULL,
0x000100003a3e7824ULL, 0x000fe200078e00ffULL, 0x000054105d117816ULL, 0x004fe20000000011ULL,
0x000100003b3b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff3e7819ULL, 0x000fe2000001143eULL,
0x0000000d000d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff3b7819ULL, 0x000fe2000001143bULL,
0x000000102024723cULL, 0x000b6c0000001824ULL, 0x0000004d004d7306ULL, 0x000e700000200c00ULL,
0x0000005100517306ULL, 0x000ff00000200c00ULL, 0x0000005200527306ULL, 0x000ea20000200c00ULL,
0x000054104d507816ULL, 0x002fce0000000050ULL, 0x0000004a004a7306ULL, 0x000ff00000200c00ULL,
0x0000004c004c7306ULL, 0x000e620000200c00ULL, 0x0000541051517816ULL, 0x004fce0000000052ULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x000000502030723cULL, 0x000f6e0000001830ULL,
0x0000005300537306ULL, 0x000ea20000200c00ULL, 0x000054104a377816ULL, 0x002fce000000004cULL,
0x0000006200547306ULL, 0x000ff00000200c00ULL, 0x0000004e004e7306ULL, 0x000e620000200c00ULL,
0x0000541048487816ULL, 0x004fce0000000053ULL, 0x0000004f00387306ULL, 0x000eb00000200c00ULL,
0x0000003900397306ULL, 0x000fe20000200c00ULL, 0x000054104e4e7816ULL, 0x002fce000000000eULL,
0x0000003c003c7306ULL, 0x000e620000200c00ULL, 0x00005410384f7816ULL, 0x004fe4000000000dULL,
0x0000f6986d0d7811ULL, 0x000fca00078e18ffULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x0000004e201c723cULL, 0x000f6e000000181cULL, 0x00000036003a7306ULL, 0x0004e20000200c00ULL,
0x00005410393c7816ULL, 0x002fce000000003cULL, 0x0000001300137306ULL, 0x000fe20000200c00ULL,
0x0000541049367816ULL, 0x004fe4000000004bULL, 0x0000541054497816ULL, 0x000fe4000000005cULL,
0x000054103d3d7816ULL, 0x008fc6000000003aULL, 0x0000000f000f7306ULL, 0x000fe20000200c00ULL,
0x000000362028723cULL, 0x040f6e0000001828ULL, 0x0000003e003e7306ULL, 0x000e620000200c00ULL,
0x000000482040723cULL, 0x040f6e0000001840ULL, 0x0000003b00107306ULL, 0x020ea20000200c00ULL,
0x0000003c2018723cULL, 0x000f620000001818ULL, 0x000054103e0e7816ULL, 0x002fc40000000013ULL,
0x00005410100f7816ULL, 0x004fce000000000fULL, 0x0000000e2014723cULL, 0x000b6e0000001814ULL,
0x0000f6c8440e7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000000e0e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000000dff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff137224ULL, 0x000fc600078e00ffULL,
0x0000000000107805ULL, 0x000fc80000015200ULL, 0x000004000a0d7984ULL, 0x004ea40000000800ULL,
0x800000000dff7812ULL, 0x006fc4000780480fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101300780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000207805ULL, 0x000fcc0000015200ULL, 0x0000002010207210ULL, 0x000fca0007f1e1ffULL,
0x0000000121217824ULL, 0x000fe200000e0e11ULL, 0x003d09002000780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402000780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0d7819ULL, 0x000fc80000011421ULL,
0x000000200d0d7211ULL, 0x000fca00078110ffULL, 0x000000ffff207224ULL, 0x000fca00000e0621ULL,
0x000000020d0d7819ULL, 0x000fc80000001220ULL, 0x0000000d0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000113137810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000004000a0d7984ULL, 0x000e640000000800ULL,
0x800000000dff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010b0a7810ULL, 0x000fc80007ffe0ffULL, 0x000000670a00720cULL, 0x000fda0003f06070ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x000000020b0a7810ULL, 0x000fe20007ffe0ffULL,
0x000059000c0d7a24ULL, 0x010fe200078e02ffULL, 0x0000010012127810ULL, 0x000fe40007ffe0ffULL,
0x000000670a00720cULL, 0x000fe20003f06070ULL, 0x000000800d0a7824ULL, 0x000fe200078e00ffULL,
0x00000060120e7812ULL, 0x000fca00078ec0ffULL, 0x000000016b0f7824ULL, 0x000fcc00078e020eULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x00000012640d7217ULL, 0x000fe20007800000ULL,
0x00000010000e7824ULL, 0x000fe200078e00ffULL, 0x00000003ff107819ULL, 0x000fc60000011604ULL,
0x000000010d0d7824ULL, 0x000fe200078e0a12ULL, 0x000000100e0e7812ULL, 0x000fe400078ec0ffULL,
0x0000000410117810ULL, 0x000fe40007ffe0ffULL, 0x0000000d0e0d7217ULL, 0x000fe40007800000ULL,
0x0000000810137810ULL, 0x040fe20007ffe0ffULL, 0x0000000111127824ULL, 0x100fe200078e020eULL,
0x0000000c10207810ULL, 0x000fe20007ffe0ffULL, 0x000000010d0d7824ULL, 0x000fc400078e0a0eULL,
0x0000000113217824ULL, 0x100fe400078e020eULL, 0x0000000120227824ULL, 0x100fe200078e020eULL,
0x0000000d1000720cULL, 0x0c0fe20003f86070ULL, 0x0000000110107824ULL, 0x000fe200078e020eULL,
0x0000000d1100720cULL, 0x080fe20003f66070ULL, 0x0000000812387824ULL, 0x000fe200078e00ffULL,
0x0000000d2000720cULL, 0x080fe20003f06070ULL, 0x0000000110117824ULL, 0x040fe200078e0204ULL,
0x0000000d1300720cULL, 0x000fe20003f46070ULL, 0x0000000810367824ULL, 0x000fc400078e00ffULL,
0x0000000110207824ULL, 0x000fe400078e020fULL, 0x0000000112137824ULL, 0x100fe200078e0204ULL,
0xfffffff836377812ULL, 0x000fe200078ee211ULL, 0x0000000112107824ULL, 0x100fe400078e020fULL,
0x00000001210e7824ULL, 0x040fe200078e020fULL, 0xfffffff838397812ULL, 0x000fe200078ee213ULL,
0x00000001210d7824ULL, 0x040fe400078e0204ULL, 0x0000000821367824ULL, 0x000fc400078e00ffULL,
0x0000000122127824ULL, 0x040fe400078e020fULL, 0x00000001220f7824ULL, 0x000fe200078e0204ULL,
0xfffffff8363b7812ULL, 0x000fe200078ee20dULL, 0x0000000822227824ULL, 0x000fe200078e00ffULL,
0x000062000a0d7a11ULL, 0x000fe200078a38ffULL, 0x0000008020207825ULL, 0x000fc600078e00ffULL,
0xfffffff8223d7812ULL, 0x000fe200078ee20fULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000005620207212ULL, 0x080fe400078efcffULL, 0x000063000a237a11ULL, 0x000fe200028f3cffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000005610107212ULL, 0x000fe400078efcffULL,
0x000000200d207210ULL, 0x000fe20007fbe0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000d10107210ULL, 0x000fc40007fde0ffULL, 0x000000560e0e7212ULL, 0x080fe200078efcffULL,
0x0000000121217824ULL, 0x100fe200028e0623ULL, 0x0000005612127212ULL, 0x000fe200078efcffULL,
0x0000000111117824ULL, 0x100fe200030e0623ULL, 0x0000000d0e0e7210ULL, 0x080fe20007fbe0ffULL,
0x0000001037377824ULL, 0x100fe200078e026aULL, 0x0000000d12127210ULL, 0x000fe20007fde0ffULL,
0x0000001039397824ULL, 0x100fe400078e026aULL, 0x000000103b3b7824ULL, 0x000fe200078e026aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020377faeULL, 0x0003e2000e101c48ULL,
0x000000010f0f7824ULL, 0x000fc400028e0623ULL, 0x000000103d3d7824ULL, 0x000fe200078e026aULL,
0x0000000010397faeULL, 0x0003e2000d901c48ULL, 0x0000000113137824ULL, 0x000fc600030e0623ULL,
0x000000000e3b7faeULL, 0x0003e8000d101c48ULL, 0x00000000123d7faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x00000010000d7824ULL, 0x000fca00078e00ffULL,
0x000000100d0d7812ULL, 0x000fc800078ec0ffULL, 0x0000000d040d7211ULL, 0x000fc800078fe8ffULL,
0x000000040d117810ULL, 0x040fe20007ffe0ffULL, 0x000000010d107824ULL, 0x140fe200078e0204ULL,
0x000000080d137810ULL, 0x040fe20007ffe0ffULL, 0x000000080d237824ULL, 0x040fe200078e00ffULL,
0x0000000c0d217810ULL, 0x040fe20007ffe0ffULL, 0x000000010d0e7824ULL, 0x100fe400078e020fULL,
0x00000001110d7824ULL, 0x000fe200078e0204ULL, 0xfffffff823237812ULL, 0x000fe200078ee210ULL,
0x0000000811227824ULL, 0x040fe400078e00ffULL, 0x0000000111107824ULL, 0x000fc400078e020fULL,
0x0000000113127824ULL, 0x000fe200078e020fULL, 0xfffffff822397812ULL, 0x000fe200078ee20dULL,
0x0000000121207824ULL, 0x000fe200078e020fULL, 0x000062000a0d7a11ULL, 0x040fe200078038ffULL,
0x0000000113117824ULL, 0x040fe400078e0204ULL, 0x0000000813367824ULL, 0x000fe200078e00ffULL,
0x000063000a377a11ULL, 0x000fe200000f3cffULL, 0x000000800e0e7825ULL, 0x000fc600078e00ffULL,
0xfffffff8363b7812ULL, 0x000fe200078ee211ULL, 0x0000000121137824ULL, 0x040fe200078e0204ULL,
0x000000560e0e7212ULL, 0x000fe200078efcffULL, 0x0000000821387824ULL, 0x000fe400078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000e0d0e7210ULL, 0x000fe40007f1e0ffULL,
0xfffffff8383d7812ULL, 0x000fe200078ee213ULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000005610107212ULL, 0x000fc600078efcffULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0x0000005612127212ULL, 0x000fc600078efcffULL, 0x000000010f0f7824ULL, 0x100fe200000e0637ULL,
0x0000005620207212ULL, 0x000fe200078efcffULL, 0x0000001023237824ULL, 0x100fe200078e026aULL,
0x000000100d107210ULL, 0x000fe20007f1e0ffULL, 0x0000001039397824ULL, 0x100fe200078e026aULL,
0x000000120d127210ULL, 0x000fe20007f5e0ffULL, 0x000000103b3b7824ULL, 0x000fe200078e026aULL,
0x000000200d207210ULL, 0x000fe20007f7e0ffULL, 0x0000000111117824ULL, 0x100fe200000e0637ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e237faeULL, 0x0003e2000b901c48ULL,
0x0000000113137824ULL, 0x000fc400010e0637ULL, 0x000000103d3d7824ULL, 0x000fe200078e026aULL,
0x0000000010397faeULL, 0x0003e2000b901c48ULL, 0x0000000121217824ULL, 0x000fc600018e0637ULL,
0x00000000123b7faeULL, 0x0003e8000b901c48ULL, 0x00000000203d7faeULL, 0x0003e4000b901c48ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000010440a7824ULL, 0x000fe400078e00ffULL,
0x00000008000d7824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe40008000a04ULL,
0x000000100a0a7812ULL, 0x000fc400078ee2ffULL, 0x000000080d0d7812ULL, 0x000fc600078ec0ffULL,
0x000000206d0a7824ULL, 0x000fc800078e020aULL, 0x000000010d0a7824ULL, 0x000fe200078e020aULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a800710e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f668000a107f8cULL, 0x000662000c80043fULL, 0x000000ffff0e7224ULL, 0x004fc600078e000fULL,
0x0000000000127805ULL, 0x000fc80000015200ULL, 0x00f66c000a0d7984ULL, 0x000ea40000000800ULL,
0x800000000dff7812ULL, 0x006fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x0000002012207210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e13ULL,
0x003d09002000780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402000780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc80000011421ULL, 0x000000200d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff207224ULL, 0x000fca00000e0621ULL, 0x000000020d0d7819ULL, 0x000fc80000001220ULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f66c000a0d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000001806d0d7811ULL, 0x000fc800078e38ffULL,
0x0000000d700d7210ULL, 0x000fca0007ffe056ULL, 0x00f000000d0a7984ULL, 0x008e680000000800ULL,
0x00f200000d127984ULL, 0x0004e20000000800ULL, 0x000000050a00720bULL, 0x002fe20003f1d000ULL,
0x00008d627f007947ULL, 0x000fd8000b800000ULL, 0x00000000000d7806ULL, 0x004fc800000e0100ULL,
0x0000ffff0d207812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0d7424ULL, 0x000fe400078e00ffULL, 0x000000ffff0f7224ULL, 0x000fd200078e0005ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x000000036d0d7810ULL, 0x000fe40007ffe0ffULL,
0x000000050a00720bULL, 0x000fe40003f54000ULL, 0x000000000d00720cULL, 0x000fe20003f05270ULL,
0x00008d027f007947ULL, 0x000fd4000b800000ULL, 0x00000000000f7806ULL, 0x000fc400010e0100ULL,
0x0000008000118824ULL, 0x000fe200078e0256ULL, 0x000000050a0d8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x000099100f107816ULL, 0x000fe200000000ffULL,
0x0000000170708824ULL, 0x000fca00078e0211ULL, 0x00f4000d70008388ULL, 0x0003e20000000800ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x000000050a107209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff0fff7812ULL, 0x000fc6000780c0ffULL, 0x00000005100d7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0d0d7820ULL, 0x000fc80000410000ULL, 0x0000000d00227308ULL, 0x000e640000000800ULL,
0x0000002203037220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe20000011604ULL, 0x00008c227f007947ULL, 0x000fea000b800000ULL,
0x00001f0d220d7589ULL, 0x0002a400000e0000ULL, 0x0000000d30307220ULL, 0x084fe20000410000ULL,
0x0000000d31317220ULL, 0x080fe20000410000ULL, 0x0000000d2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000d2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000d28287220ULL, 0x080fe20000410000ULL,
0x0000000d29297220ULL, 0x080fe20000410000ULL, 0x0000000d24247220ULL, 0x080fe20000410000ULL,
0x0000000d25257220ULL, 0x080fe20000410000ULL, 0x0000000d40407220ULL, 0x080fe20000410000ULL,
0x0000000d41417220ULL, 0x080fe20000410000ULL, 0x0000000d1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000d1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000d18187220ULL, 0x080fe20000410000ULL,
0x0000000d19197220ULL, 0x080fe20000410000ULL, 0x0000000d14147220ULL, 0x080fe20000410000ULL,
0x0000000d15157220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff000fff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008040d7811ULL, 0x000fe200078ff0ffULL, 0x00008b027f007947ULL, 0x000fea000b800000ULL,
0x00001f0d220d7589ULL, 0x00046400000e0000ULL, 0x0000000d32327220ULL, 0x086fe20000410000ULL,
0x0000000d33337220ULL, 0x080fe20000410000ULL, 0x0000000d2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000d2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000d2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000d2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000d26267220ULL, 0x080fe20000410000ULL,
0x0000000d27277220ULL, 0x080fe20000410000ULL, 0x0000000d42427220ULL, 0x080fe20000410000ULL,
0x0000000d43437220ULL, 0x080fe20000410000ULL, 0x0000000d1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000d1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000d1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000d1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000d16167220ULL, 0x080fe20000410000ULL,
0x0000000d17177220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff20ff7812ULL, 0x000fe2000780600fULL, 0x00000001ff0d7424ULL, 0x000fe200078e00ffULL,
0x000000050a0f7209ULL, 0x000fd60007810000ULL, 0x8000000f0a0a0221ULL, 0x000fe20000010000ULL,
0x00007610ff0d0816ULL, 0x000fc6000000000dULL, 0x3fb8aa3b0a0a0820ULL, 0x000fc80000410000ULL,
0x0000000a00080308ULL, 0x000e640000000800ULL, 0x0000000812120220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000312037221ULL, 0x008fc20000010000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x00f6b40071137984ULL, 0x000e620000000800ULL,
0x0000000400057824ULL, 0x000fe400078e00ffULL, 0x00000004730a7824ULL, 0x000fc600078e00ffULL,
0x0000000405207812ULL, 0x000fe200078ec0ffULL, 0x000000ffff057224ULL, 0x000fc600078e00ffULL,
0x0000000220207810ULL, 0x000fe40007ffe0ffULL, 0x8000000013ff7812ULL, 0x002fe20007804835ULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000021000007945ULL, 0x000fe20003800000ULL,
0x000000ffff137224ULL, 0x000fe200078e0020ULL, 0x000001e000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210217210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09002100780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402100780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000002112127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000105057810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00f6b40071137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe40007804835ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff137224ULL, 0x000fc400078e0020ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100d057816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0500720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000008ff05723eULL, 0x000fe400000000ffULL,
0x00000002ff127819ULL, 0x000fe40000011604ULL, 0x0000541005057816ULL, 0x000fe20000000005ULL,
0x000086527f007947ULL, 0x000fea000b800000ULL, 0x00001f1205077589ULL, 0x0002a400000e0000ULL,
0x00000008120d7810ULL, 0x000fe20007ffe0ffULL, 0x000086827f007947ULL, 0x000fea000b800000ULL,
0x00001f0d05067589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x00000010120d7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff107224ULL, 0x000fe200078e0005ULL,
0x0000a28000117802ULL, 0x000fc40000000f00ULL, 0x00008b1000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x00000018120d7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff107224ULL, 0x000fe200078e0005ULL, 0x0000a2d000117802ULL, 0x000fc40000000f00ULL,
0x00008ac000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000704127812ULL, 0x002fe200078ec0ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000036d4b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000812057812ULL, 0x008fe400078ef804ULL,
0x0000000804117812ULL, 0x000fe200078ec0ffULL, 0x000008004b4b7824ULL, 0x000fe400078e00ffULL,
0x00000008054a7824ULL, 0x000fca00078e00ffULL, 0xfffffff84a4a7812ULL, 0x000fca00078ee257ULL,
0x000000104a4a7824ULL, 0x000fc400078e024bULL, 0x0000000a04107211ULL, 0x040fe400078fe0ffULL,
0x00000012110d7212ULL, 0x044fe400078efcffULL, 0x0000001304137211ULL, 0x000fe400078fe0ffULL,
0x0000001011127812ULL, 0x000fe200078efe12ULL, 0x000000010d057824ULL, 0x040fe400078e0210ULL,
0x000000080d0a7824ULL, 0x000fe400078e00ffULL, 0x0000000812117824ULL, 0x000fc600078e00ffULL,
0xfffffff80a057812ULL, 0x000fe200078ee205ULL, 0x000000010d0a7824ULL, 0x040fe400078e0213ULL,
0x000000080d0d7824ULL, 0x000fe400078e00ffULL, 0x0000001005057824ULL, 0x000fc600078e0202ULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee20aULL, 0x00000001120a7824ULL, 0x000fe200078e0210ULL,
0x000000000520783bULL, 0x0002a60000004200ULL, 0x000000100d0d7824ULL, 0x000fe200078e0202ULL,
0xfffffff811117812ULL, 0x000fc800078ee20aULL, 0x000000000d38783bULL, 0x000ee20000004200ULL,
0x0000001011117824ULL, 0x000fe400078e0202ULL, 0x0000000112057824ULL, 0x042fe400078e0213ULL,
0x0000000812127824ULL, 0x000fe200078e00ffULL, 0x000000001134783bULL, 0x000e680000004200ULL,
0xfffffff812057812ULL, 0x000fca00078ee205ULL, 0x0000001005057824ULL, 0x000fca00078e0202ULL,
0x000000000510783bULL, 0x000e620000004200ULL, 0x00000018ff6e7819ULL, 0x004fe20000011420ULL,
0x0000010020477824ULL, 0x040fe200078e00ffULL, 0x0000888020617816ULL, 0x040fe200000000ffULL,
0x0001000020207824ULL, 0x000fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe20000011421ULL,
0x0000010021487824ULL, 0x040fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011447ULL,
0x0000010022497824ULL, 0x000fe200078e00ffULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x0000888021477816ULL, 0x040fe200000000ffULL,
0x0001000021217824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fc40000011422ULL,
0x00000018ff537819ULL, 0x000fe40000011423ULL, 0x00000018ff217819ULL, 0x000fe20000011421ULL,
0x0000002000707306ULL, 0x0005e20000200c00ULL, 0x0000888022657816ULL, 0x040fe200000000ffULL,
0x0001000022227824ULL, 0x000fe200078e00ffULL, 0x0000888023637816ULL, 0x040fe400000000ffULL,
0x00000018ff4e7819ULL, 0x008fe40000011438ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x00000021006f7306ULL, 0x0007e20000200c00ULL, 0x0000010023207824ULL, 0x044fe200078e00ffULL,
0x00008880385a7816ULL, 0x000fe200000000ffULL, 0x0001000023237824ULL, 0x000fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fc40000011448ULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x0000010038217824ULL, 0x048fe200078e00ffULL,
0x0000002000697306ULL, 0x0005e20000200c00ULL, 0x0001000038387824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe40000011439ULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000888039597816ULL, 0x000fc400000000ffULL, 0x00000021005b7306ULL, 0x0007e20000200c00ULL,
0x0000010039207824ULL, 0x044fe200078e00ffULL, 0x00000018ff387819ULL, 0x000fe20000011438ULL,
0x0001000039397824ULL, 0x000fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe4000001143aULL,
0x00000018ff207819ULL, 0x000fe40000011420ULL, 0x00000022005f7306ULL, 0x000fe20000200c00ULL,
0x000001003a217824ULL, 0x008fe200078e00ffULL, 0x00000018ff397819ULL, 0x000fc40000011439ULL,
0x000088803a517816ULL, 0x040fe200000000ffULL, 0x000100003a3a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe40000011421ULL, 0x00000020005c7306ULL, 0x0005e20000200c00ULL,
0x00000018ff497819ULL, 0x000fe40000011449ULL, 0x00000018ff3a7819ULL, 0x000fe4000001143aULL,
0x00000018ff467819ULL, 0x000fe4000001143bULL, 0x000088803b4f7816ULL, 0x040fe200000000ffULL,
0x0000002300567306ULL, 0x0007e20000200c00ULL, 0x000001003b207824ULL, 0x044fe200078e00ffULL,
0x00000018ff3e7819ULL, 0x002fe20000011434ULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc40000011436ULL, 0x00000018ff547819ULL, 0x000fe40000011420ULL,
0x0000007800787306ULL, 0x000e620000200c00ULL, 0x009000004a20783bULL, 0x008ea20000000200ULL,
0x00000018ff3b7819ULL, 0x000fe4000001143bULL, 0x00000018ff3f7819ULL, 0x000fe40000011435ULL,
0x00000018ff3d7819ULL, 0x000fe40000011437ULL, 0x0000004700477306ULL, 0x000fe20000200c00ULL,
0x00000018ff0d7819ULL, 0x000fc40000011412ULL, 0x00000018ff0a7819ULL, 0x000fe40000011413ULL,
0x00000018ff027819ULL, 0x000fe40000011410ULL, 0x00000018ff057819ULL, 0x000fe20000011411ULL,
0x0000004800607306ULL, 0x000ef00000200c00ULL, 0x0000003800587306ULL, 0x0003f00000200c00ULL,
0x0000003900577306ULL, 0x0005e20000200c00ULL, 0x0000010034387824ULL, 0x002fca00078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x0000888035397816ULL, 0x004fe200000000ffULL, 0x0000000720208232ULL, 0x080fe40000000000ULL,
0x0000000722228232ULL, 0x000fe40000000000ULL, 0x0000000621218232ULL, 0x080fe40000000000ULL,
0x0000003800487306ULL, 0x0005e20000200c00ULL, 0x0000000623238232ULL, 0x000fce0000000000ULL,
0x00000039004a7306ULL, 0x0007e20000200c00ULL, 0x0000541061387816ULL, 0x004fce0000000078ULL,
0x0000006a006a7306ULL, 0x000ea20000200c00ULL, 0x0000541047397816ULL, 0x008fce0000000060ULL,
0x000000382030723cULL, 0x000b620000001830ULL, 0x0000003a005e7306ULL, 0x0007ec0000200c00ULL,
0x0000010037387824ULL, 0x020fe400078e00ffULL, 0x0000004900667306ULL, 0x0003e20000200c00ULL,
0x00000100353a7824ULL, 0x008fc400078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011438ULL,
0x0001000036387824ULL, 0x000fe400078e00ffULL, 0x00000018ff3a7819ULL, 0x000fe2000001143aULL,
0x0001000035357824ULL, 0x000fe200078e00ffULL, 0x0000006500657306ULL, 0x000ee20000200c00ULL,
0x0000888034497816ULL, 0x042fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe40000011438ULL, 0x00000018ff357819ULL, 0x000fc40000011435ULL,
0x00000018ff347819ULL, 0x000fe20000011434ULL, 0x0000006300637306ULL, 0x000e700000200c00ULL,
0x0000003b005d7306ULL, 0x0003f00000200c00ULL, 0x0000003a004c7306ULL, 0x0005e20000200c00ULL,
0x00000100363b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff3b7819ULL, 0x000fe4000001143bULL,
0x0000003800607306ULL, 0x0003e20000200c00ULL, 0x00008880363a7816ULL, 0x004fce00000000ffULL,
0x0000003900367306ULL, 0x0005e20000200c00ULL, 0x0000541070387816ULL, 0x002fce000000006eULL,
0x0000003400627306ULL, 0x000fe20000200c00ULL, 0x000054106f397816ULL, 0x004fce000000006aULL,
0x0000003a00347306ULL, 0x0003e20000200c00ULL, 0x00000038202c723cULL, 0x000b6e000000182cULL,
0x0000541065387816ULL, 0x028fe20000000066ULL, 0x0000003b00477306ULL, 0x0004e20000200c00ULL,
0x00008880103a7816ULL, 0x002fc400000000ffULL, 0x0000541063397816ULL, 0x000fe40000000069ULL,
0x0000888011637816ULL, 0x000fe200000000ffULL, 0x000000ffff6a7224ULL, 0x000fe400078e003aULL,
0x00000010093a7824ULL, 0x000fe200078e024bULL, 0x0000005200527306ULL, 0x000e620000200c00ULL,
0x00000100103b7824ULL, 0x004fe200078e00ffULL, 0x000000382028723cULL, 0x000b680000001828ULL,
0x00000018ff4b7819ULL, 0x000fc4000001143bULL, 0x009000003a38783bULL, 0x020ea20000000200ULL,
0x0000005300537306ULL, 0x000e620000200c00ULL, 0x0000541034347816ULL, 0x008fe40000000047ULL,
0x000054105f527816ULL, 0x002fca0000000052ULL, 0x0000005a005a7306ULL, 0x000e620000200c00ULL,
0x00000100115f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff5f7819ULL, 0x000fe4000001145fULL,
0x0000005900597306ULL, 0x000ee20000200c00ULL, 0x0000541056537816ULL, 0x000fe20000000053ULL,
0x000000ffff567224ULL, 0x000fcc00078e0063ULL, 0x0000004e004e7306ULL, 0x000ea20000200c00ULL,
0x000000522024723cULL, 0x000b6e0000001824ULL, 0x0000004d004d7306ULL, 0x000ea20000200c00ULL,
0x000054105a527816ULL, 0x022fe4000000005bULL, 0x0000541059537816ULL, 0x008fe2000000005cULL,
0x0001000010597824ULL, 0x000fe200078e00ffULL, 0x0000000738388232ULL, 0x004fc60000000000ULL,
0x0000004500457306ULL, 0x000e620000200c00ULL, 0x000000073a3a8232ULL, 0x000fe20000000000ULL,
0x000000522040723cULL, 0x000be20000001840ULL, 0x0000000639398232ULL, 0x080fe20000000000ULL,
0x00000018ff597819ULL, 0x000fe20000011459ULL, 0x000000063b3b8232ULL, 0x000fc60000000000ULL,
0x0000004600467306ULL, 0x000ea20000200c00ULL, 0x0000541058527816ULL, 0x020fe4000000004eULL,
0x0000541057537816ULL, 0x000fe2000000004dULL, 0x00010000114d7824ULL, 0x000fc800078e00ffULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x000054105e5c7816ULL, 0x002fe20000000045ULL,
0x00000052201c723cULL, 0x000f62000000181cULL, 0x00000018ff4d7819ULL, 0x000fca000001144dULL,
0x0000005000507306ULL, 0x000e620000200c00ULL, 0x000054105d5d7816ULL, 0x004fce0000000046ULL,
0x0000004f004f7306ULL, 0x000fe20000200c00ULL, 0x0000005c2014723cULL, 0x000fee0000001814ULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x00005410514e7816ULL, 0x002fce0000000050ULL,
0x0000004900497306ULL, 0x000e620000200c00ULL, 0x000054104f4f7816ULL, 0x004fce0000000054ULL,
0x0000003e003e7306ULL, 0x000ea20000200c00ULL, 0x0000004e2018723cULL, 0x000b620000001818ULL,
0x0000541049487816ULL, 0x002fcc0000000048ULL, 0x0000003f003f7306ULL, 0x000fe20000200c00ULL,
0x000054104a497816ULL, 0x000fe4000000004cULL, 0x0000888013217816ULL, 0x020fe200000000ffULL,
0x0000010012207824ULL, 0x040fe200078e00ffULL, 0x00008880124e7816ULL, 0x000fc600000000ffULL,
0x0000003500617306ULL, 0x0002e20000200c00ULL, 0x000000483830723cULL, 0x000b620000001830ULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x00005410623e7816ULL, 0x004fe2000000003eULL,
0x000000ffff457224ULL, 0x000fe200078e004eULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x000000ffff487224ULL, 0x020fe200078e0021ULL,
0x0000888037357816ULL, 0x002fe200000000ffULL, 0x0000010013217824ULL, 0x000fe200078e00ffULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x0001000037377824ULL, 0x000fc400078e00ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x00005410613f7816ULL, 0x008fe4000000003fULL, 0x00000018ff377819ULL, 0x000fe20000011437ULL,
0x0000003500357306ULL, 0x000e620000200c00ULL, 0x00000018ff137819ULL, 0x000fc60000011413ULL,
0x0000003e382c723cULL, 0x000b68000000182cULL, 0x0000003d003d7306ULL, 0x000ff00000200c00ULL,
0x0000000200027306ULL, 0x000fe20000200c00ULL, 0x0000541035357816ULL, 0x002fc40000000036ULL,
0x0000541060367816ULL, 0x000fca000000003cULL, 0x0000000500057306ULL, 0x000fe20000200c00ULL,
0x000000343828723cULL, 0x000b6e0000001828ULL, 0x0000000d000d7306ULL, 0x000ff00000200c00ULL,
0x0000000a000a7306ULL, 0x000ff00000200c00ULL, 0x0000003700377306ULL, 0x000e700000200c00ULL,
0x0000006a00097306ULL, 0x000ff00000200c00ULL, 0x0000004b004b7306ULL, 0x000fe20000200c00ULL,
0x0000541037377816ULL, 0x002fce000000003dULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x000000363834723cULL, 0x000b6e0000001824ULL, 0x0000005f00107306ULL, 0x000ff00000200c00ULL,
0x0000005900117306ULL, 0x000e700000200c00ULL, 0x0000004d004d7306ULL, 0x000eb00000200c00ULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x00005410114c7816ULL, 0x002fc40000000002ULL,
0x0000000444027810ULL, 0x000fc80007ffe0ffULL, 0x0000f6a802027811ULL, 0x000fe200078e18ffULL,
0x0000002000467306ULL, 0x0002e20000200c00ULL, 0x000054104d4d7816ULL, 0x004fce0000000005ULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x0000541009207816ULL, 0x002fe2000000004bULL,
0x0000004c381c723cULL, 0x000b6c000000181cULL, 0x00000021003f7306ULL, 0x0202a20000200c00ULL,
0x0000541045467816ULL, 0x008fce0000000046ULL, 0x0000001200127306ULL, 0x000ee20000200c00ULL,
0x0000541056217816ULL, 0x002fce0000000010ULL, 0x0000001300137306ULL, 0x000e620000200c00ULL,
0x0000541048477816ULL, 0x004fe2000000003fULL, 0x000000203820723cULL, 0x000b620000001840ULL,
0x0000541012127816ULL, 0x008fce000000000dULL, 0x000000463818723cULL, 0x000b620000001818ULL,
0x0000541013137816ULL, 0x002fce000000000aULL, 0x000000123814723cULL, 0x000b620000001814ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x0000000002107f8cULL, 0x0002a2000c80043fULL,
0x000000010b0b7810ULL, 0x000fe40007ffe0ffULL, 0x0000f6a06d057811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000005ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff027224ULL, 0x006fe200078e0011ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff625000007947ULL, 0x000fea000383ffffULL, 0x000000ff6700720cULL, 0x000fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0180000003007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000b4a000047802ULL, 0x000fc40000000f00ULL, 0x0000773000007944ULL, 0x03efea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000300007308ULL, 0x000e640000001000ULL,
0xbf80000000027423ULL, 0x002fc80000000003ULL, 0x800000ff02057221ULL, 0x008fc80000010100ULL,
0x0000000500007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000802037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000047919ULL, 0x000e680000000000ULL,
0x0000000000077919ULL, 0x000ea20000000000ULL, 0x00000002ff067819ULL, 0x002fe40000011604ULL,
0x0000000807047811ULL, 0x004fe200078ff0ffULL, 0x0000000003057220ULL, 0x008fca0000410000ULL,
0x00001f0605007589ULL, 0x000e6800000e0000ULL, 0x00001f0405047589ULL, 0x000ea200000e0000ULL,
0x0000003000307220ULL, 0x042fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000002c002c7220ULL, 0x040fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000002800287220ULL, 0x040fe20000410000ULL, 0x0000002900297220ULL, 0x040fe20000410000ULL,
0x0000003400347220ULL, 0x040fe20000410000ULL, 0x0000003500357220ULL, 0x040fe20000410000ULL,
0x0000002000207220ULL, 0x060fe20000410000ULL, 0x0000002100217220ULL, 0x040fe20000410000ULL,
0x0000001c001c7220ULL, 0x040fe20000410000ULL, 0x0000001d001d7220ULL, 0x040fe20000410000ULL,
0x0000001800187220ULL, 0x040fe20000410000ULL, 0x0000001900197220ULL, 0x040fe20000410000ULL,
0x0000001400147220ULL, 0x040fe20000410000ULL, 0x0000001500157220ULL, 0x000fe20000410000ULL,
0x0000003204327220ULL, 0x044fe20000410000ULL, 0x0000003304337220ULL, 0x040fe20000410000ULL,
0x0000002e042e7220ULL, 0x040fe20000410000ULL, 0x0000002f042f7220ULL, 0x040fe20000410000ULL,
0x0000002a042a7220ULL, 0x040fe20000410000ULL, 0x0000002b042b7220ULL, 0x040fe20000410000ULL,
0x0000003604367220ULL, 0x040fe20000410000ULL, 0x0000003704377220ULL, 0x040fe20000410000ULL,
0x0000002204227220ULL, 0x040fe20000410000ULL, 0x0000002304237220ULL, 0x040fe20000410000ULL,
0x0000001e041e7220ULL, 0x040fe20000410000ULL, 0x0000001f041f7220ULL, 0x040fe20000410000ULL,
0x0000001a041a7220ULL, 0x040fe20000410000ULL, 0x0000001b041b7220ULL, 0x040fe20000410000ULL,
0x0000001604167220ULL, 0x040fe20000410000ULL, 0x0000001704177220ULL, 0x000fc20000410000ULL,
0x0000000000057919ULL, 0x008ee20000000000ULL, 0x0000001c1d1c723eULL, 0x000fc400000000ffULL,
0x000000181918723eULL, 0x020fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x000000222322723eULL, 0x000fe400000000ffULL,
0x0000001a1b1a723eULL, 0x000fc400000000ffULL, 0x000000ff4400720cULL, 0x000fe40003f05270ULL,
0x00000002ff077819ULL, 0x108fe20000011605ULL, 0x0000000176767824ULL, 0x000fe200078e0205ULL,
0x0000000205007812ULL, 0x040fe400078ec0ffULL, 0x0000000805097811ULL, 0x000fe200078ff0ffULL,
0x00000008070b7824ULL, 0x040fe200078e00ffULL, 0x0000000700027211ULL, 0x040fe200078ff8ffULL,
0x00000008070d7824ULL, 0x000fe200078e00ffULL, 0x0000000900037211ULL, 0x000fe200078ff8ffULL,
0x00000008090e7824ULL, 0x004fe200078e00ffULL, 0x0000000202007810ULL, 0x040fe20007ffe0ffULL,
0x0000000807097824ULL, 0x000fe200078e00ffULL, 0x0000000402047810ULL, 0x000fc40007ffe0ffULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee203ULL, 0x0000100073037824ULL, 0x000fe200078e00ffULL,
0xfffffff80b067812ULL, 0x000fe400078ee200ULL, 0xfffffff809007812ULL, 0x000fe200078ee202ULL,
0x0000080044077824ULL, 0x000fe200078e0203ULL, 0x0000000602087810ULL, 0x000fe20007ffe0ffULL,
0x0000000805027824ULL, 0x000fe200078e00ffULL, 0xfffffff80b0a7812ULL, 0x000fe200078ee204ULL,
0x0000001000047824ULL, 0x100fe200078e0207ULL, 0x000000303100723eULL, 0x000fe200000000ffULL,
0x000000100e0e7824ULL, 0x100fe200078e0207ULL, 0x0000000802097812ULL, 0x000fe200078ec0ffULL,
0x000000100a0a7824ULL, 0x000fe200078e0207ULL, 0x0000002c2d02723eULL, 0x000fe200000000ffULL,
0x0000001076767824ULL, 0x000fe200078e0203ULL, 0xfffffff80d0c7812ULL, 0x010fe200078ee208ULL,
0x0000001006087824ULL, 0x000fe200078e0207ULL, 0x0000541000107816ULL, 0x100fe20000000002ULL,
0x0000000104067824ULL, 0x000fe200078e0209ULL, 0x0000763200117816ULL, 0x000fe20000000002ULL,
0x000000100c0c7824ULL, 0x000fe200078e0207ULL, 0x000000282900723eULL, 0x000fe200000000ffULL,
0x0000000109087824ULL, 0x000fe200078e0208ULL, 0x000000343502723eULL, 0x000fe200000000ffULL,
0x0000001006007388ULL, 0x0005e20000000a00ULL, 0x000000202104723eULL, 0x000fe200000000ffULL,
0x00000001090e7824ULL, 0x040fe200078e020eULL, 0x0000763200077816ULL, 0x000fe20000000002ULL,
0x00000001090a7824ULL, 0x000fe200078e020aULL, 0x00000016170d723eULL, 0x000fe200000000ffULL,
0x0000000109097824ULL, 0x000fe200078e020cULL, 0x00000014150c723eULL, 0x000fc400000000ffULL,
0x000000363715723eULL, 0x000fe400000000ffULL, 0x000076321a1d7816ULL, 0x000fe4000000000dULL,
0x0000541000067816ULL, 0x004fe40000000002ULL, 0x000000323300723eULL, 0x000fe400000000ffULL,
0x0000002e2f02723eULL, 0x000fe200000000ffULL, 0x0000000608007388ULL, 0x0005e20000000a00ULL,
0x0000001e1f11723eULL, 0x000fc400000000ffULL, 0x000054102a147816ULL, 0x140fe40000000015ULL,
0x000076322a157816ULL, 0x000fe40000000015ULL, 0x0000541004067816ULL, 0x144fe4000000001cULL,
0x0000763204077816ULL, 0x000fe4000000001cULL, 0x000054101a1c7816ULL, 0x000fc6000000000dULL,
0x000000060a007388ULL, 0x0005e40000000a00ULL, 0x0000541018067816ULL, 0x144fe4000000000cULL,
0x0000763218077816ULL, 0x000fca000000000cULL, 0x0000000609007388ULL, 0x0005e40000000a00ULL,
0x0000541000067816ULL, 0x144fe40000000002ULL, 0x0000763200077816ULL, 0x000fca0000000002ULL,
0x000000060e007388ULL, 0x0005e80000000a00ULL, 0x0004001408007388ULL, 0x000fe20000000a00ULL,
0x0000541022067816ULL, 0x144fe40000000011ULL, 0x0000763222077816ULL, 0x000fca0000000011ULL,
0x000400060a007388ULL, 0x000fe80000000a00ULL, 0x0004001c09007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000760c7984ULL, 0x000ea80000000c00ULL,
0x0004000076147984ULL, 0x000ee80000000c00ULL, 0x0008000076107984ULL, 0x000e680000000c00ULL,
0x000c000076187984ULL, 0x000e620000000c00ULL, 0x200000ff0f0f7230ULL, 0x004fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x008fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x000000130f0f7230ULL, 0x002fe40000000000ULL,
0x000000120e0e7230ULL, 0x000fe40000000000ULL, 0x000000110d0d7230ULL, 0x000fe40000000000ULL,
0x000000100c0c7230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x000fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000c76007388ULL, 0x000fe20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001476007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff047819ULL, 0x000fc80000011605ULL,
0x000000740400720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000104007824ULL, 0x100fe200078e0205ULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x00005a0072117a19ULL, 0x000fe200000006ffULL,
0x00005a0000067ab9ULL, 0x000fe20000000800ULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x0000000605057299ULL, 0x000fe2000800063fULL, 0x00000007050c7812ULL, 0x000fe400078ec0ffULL,
0x0ffffff800007812ULL, 0x000fe200078ef805ULL, 0x0000580000067ab9ULL, 0x000fc40000000800ULL,
0x00000008730d7824ULL, 0x000fe400078e020cULL, 0x0000001000027824ULL, 0x000fe400078e0203ULL,
0x0000001075007824ULL, 0x000fc600078e0204ULL, 0x0000000002087984ULL, 0x0004e40000000c00ULL,
0x0000000500047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff077a19ULL, 0x000fe20000011600ULL,
0x00000006040472a4ULL, 0x002fe4000f8e023fULL, 0x0000000111047824ULL, 0x000fe200078e0204ULL,
0x0000002005027810ULL, 0x004fc60007ffe0ffULL, 0x0000007a07077224ULL, 0x000fe200078e0204ULL,
0x00000003ff0f7819ULL, 0x000fe20000011602ULL, 0x000000047a007c24ULL, 0x000fca000f8e02ffULL,
0x0000000700077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x00005c0007067a11ULL, 0x000fc800078040ffULL, 0x00005d0007077a11ULL, 0x000fe400000f4404ULL,
0x000000740f00720cULL, 0x000fc60003f06070ULL, 0x000000100d067825ULL, 0x000fca00078e0006ULL,
0x0000000806007986ULL, 0x0083ea000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000102047824ULL, 0x100fe200078e020fULL, 0x00000040050c7810ULL, 0x000fe20007ffe0ffULL,
0x00000010750f7824ULL, 0x000fc600078e020fULL, 0x0000000704077812ULL, 0x002fe400078ec0ffULL,
0x000000050f067c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff807047812ULL, 0x000fe400078ef802ULL,
0x00005a00ff0f7a19ULL, 0x000fe2000001160fULL, 0x0000000111067824ULL, 0x000fe200078e0206ULL,
0x0000000702027812ULL, 0x000fe200078ec0ffULL, 0x0000001004047824ULL, 0x000fe400078e0203ULL,
0x0000007a0f0f7224ULL, 0x000fc400078e0206ULL, 0x00000008730d7824ULL, 0x000fe200078e0202ULL,
0x0000000004087984ULL, 0x000e640000000c00ULL, 0x0000000f000f7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c000f067a11ULL, 0x000fc800078040ffULL,
0x00005d000f077a11ULL, 0x000fe400000f440eULL, 0x00000003ff0f7819ULL, 0x000fc6000001160cULL,
0x000000100d067825ULL, 0x000fe200078e0006ULL, 0x000000740f00720cULL, 0x000fc80003f06070ULL,
0x0000000806007986ULL, 0x0023f2000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x000000010c027824ULL, 0x100fe200078e020fULL, 0x0000006005067810ULL, 0x002fe20007ffe0ffULL,
0x00000010750f7824ULL, 0x000fc600078e020fULL, 0x0000000702077812ULL, 0x000fe400078ec0ffULL,
0x000000050f047c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff807027812ULL, 0x000fe400078ef80cULL,
0x00005a00ff0f7a19ULL, 0x000fe2000001160fULL, 0x0000000111047824ULL, 0x000fe200078e0204ULL,
0x00000003ff0d7819ULL, 0x000fe20000011606ULL, 0x0000001002027824ULL, 0x000fe200078e0203ULL,
0x000000070c0c7812ULL, 0x000fe200078ec0ffULL, 0x0000007a0f0f7224ULL, 0x000fc600078e0204ULL,
0x0000000002087984ULL, 0x0002a20000000c00ULL, 0x0000000873077824ULL, 0x000fe200078e020cULL,
0x0000000f000f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c000f047a11ULL, 0x000fe200078040ffULL, 0x0000000106027824ULL, 0x002fc600078e020dULL,
0x00005d000f057a11ULL, 0x000fe400000f440eULL, 0x000000740d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fe200078e0004ULL, 0x0000000702077812ULL, 0x000fc800078ec0ffULL,
0xfffffff807027812ULL, 0x000fe200078ef806ULL, 0x0000000804007986ULL, 0x0043e8000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001002047824ULL, 0x002fe200078e0203ULL,
0x0000000706067812ULL, 0x000fe200078ec0ffULL, 0x00000010750d7824ULL, 0x000fc600078e020dULL,
0x0000000004087984ULL, 0x000e620000000c00ULL, 0x0000000873737824ULL, 0x000fe200078e0206ULL,
0x000000050d027c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0d7a19ULL, 0x000fc6000001160dULL,
0x0000000111027824ULL, 0x000fc800078e0202ULL, 0x0000007a0d0d7224ULL, 0x000fca00078e0202ULL,
0x0000000d000d7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff007224ULL, 0x000fe200000e06ffULL,
0x00005c000d027a11ULL, 0x000fc800078040ffULL, 0x00005d000d037a11ULL, 0x000fca00000f4400ULL,
0x0000001073027825ULL, 0x000fca00078e0002ULL, 0x0000000802007986ULL, 0x002fe2000c101d08ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff027819ULL, 0x000fc80000011600ULL,
0x000000680200720cULL, 0x000fda0003f06070ULL, 0x0000000270038824ULL, 0x002fc800078e00ffULL,
0x0000680003088a24ULL, 0x000fe400078e0202ULL, 0xffffffffff037424ULL, 0x000fe400078e00ffULL,
0x0000640008088625ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006c00ff0a7624ULL, 0x000fe200078e00ffULL, 0x0000000808038981ULL, 0x000ea2000c1e1900ULL,
0x00006d00ff0b7624ULL, 0x000fc600078e00ffULL, 0x00f60000ff067f8cULL, 0x000e68000c80043fULL,
0x000000080a637981ULL, 0x000722000c1e9900ULL, 0x000001ff0d00780cULL, 0x000fe20003f04070ULL,
0x0000008072697824ULL, 0x000fe400078e00ffULL, 0x0000004000757824ULL, 0x000fe400078e00ffULL,
0x000000800c717824ULL, 0x000fc600078e00ffULL, 0x0000004069177812ULL, 0x000fe200078ef875ULL,
0x0000007103237224ULL, 0x004fc800078e02ffULL, 0x0000062000000947ULL, 0x000fea0003800000ULL,
0x00000002ff1a7819ULL, 0x00afe40000011604ULL, 0x0000620023217a11ULL, 0x000fe400078038ffULL,
0x000000081a187810ULL, 0x040fe20007ffe0ffULL, 0x0000000117087824ULL, 0x040fe200078e021aULL,
0x000000101a1c7810ULL, 0x040fe40007ffe0ffULL, 0x000000181a1e7810ULL, 0x040fe20007ffe0ffULL,
0x00000001170a7824ULL, 0x000fe200078e0218ULL, 0x0000630023237a11ULL, 0x000fe200000f3cffULL,
0x00000001170c7824ULL, 0x000fe200078e021cULL, 0x000000201a167810ULL, 0x000fe20007ffe0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x00001000001b7811ULL, 0x000fc600078e68ffULL,
0x00000001170e7824ULL, 0x000fe200078e021eULL, 0x000000300a127812ULL, 0x000fe200078ef805ULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0x0000002112127210ULL, 0x000fe20007f3e0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000003008107812ULL, 0x000fc600078ef805ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000300c087812ULL, 0x000fe400078ef805ULL,
0x00000075640c7217ULL, 0x000fe20007800000ULL, 0x000000010b137824ULL, 0x000fe200008e0623ULL,
0x000000300e0a7812ULL, 0x000fe200078ef805ULL, 0x0000000117147824ULL, 0x000fe200078e0216ULL,
0x00000004040e7211ULL, 0x000fe200078fe8ffULL, 0x000000010c157824ULL, 0x000fe200078e0a75ULL,
0x000000210a0a7210ULL, 0x000fe40007f3e0ffULL, 0x0000001021107210ULL, 0x000fc40007f1e0ffULL,
0x000000030e197812ULL, 0x000fe200078ec0ffULL, 0x000000010f0b7824ULL, 0x100fe200008e0623ULL,
0x000000151800720cULL, 0x040fe20003f26070ULL, 0x00000004180e7824ULL, 0x000fe200078e00ffULL,
0x000000281a187810ULL, 0x000fe20007ffe0ffULL, 0x0000000109117824ULL, 0x000fe200000e0623ULL,
0x0000002108087210ULL, 0x000fe40007f1e0ffULL, 0xfffffffc0e0e7812ULL, 0x000fe200078ee219ULL,
0x00000001170f7824ULL, 0x000fe200078e0218ULL, 0x0ffffffc19047812ULL, 0x000fe200078ef804ULL,
0x000000010d097824ULL, 0x000fe200000e0623ULL, 0x000000151a00720cULL, 0x080fe20003f06070ULL,
0x00000080140c7825ULL, 0x000fe200078e00ffULL, 0x000000151c00720cULL, 0x000fc40003fa6070ULL,
0x000000151e00720cULL, 0x080fe20003f86070ULL, 0x000000100e1f7824ULL, 0x000fe200078e021bULL,
0x000000300c0c7812ULL, 0x000fe200078ef805ULL, 0x000000800f0e7825ULL, 0x000fe200078e00ffULL,
0x000000151600720cULL, 0x000fe40003f66070ULL, 0x000000210c0c7210ULL, 0x080fe20007f5e0ffULL,
0x00000010041d7824ULL, 0x000fe200078e021bULL, 0x000000300e147812ULL, 0x000fe200078ef805ULL,
0x000000041e1e7824ULL, 0x000fe200078e00ffULL, 0x000000301a047810ULL, 0x040fe20007ffe0ffULL,
0x000000010d0d7824ULL, 0x100fe200010e0623ULL, 0x000000381a1a7810ULL, 0x000fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000101d7faeULL, 0x0003e2000c101c48ULL,
0x0000002114147210ULL, 0x000fe20007fde0ffULL, 0x00000001170e7824ULL, 0x000fe200078e0204ULL,
0x000000151800720cULL, 0x080fe20003f46070ULL, 0x00000000121f7faeULL, 0x0005e2000c901c48ULL,
0x000000150400720cULL, 0x0c0fe20003f26070ULL, 0x0000000404227824ULL, 0x000fe200078e00ffULL,
0x000000151a00720cULL, 0x000fe20003f06070ULL, 0x000000010f157824ULL, 0x000fc400030e0623ULL,
0x000000800e0e7825ULL, 0x000fc800078e00ffULL, 0x0000000117107824ULL, 0x002fe200078e021aULL,
0x000000300e047812ULL, 0x000fe200078ef805ULL, 0x000000041c127824ULL, 0x004fe400078e00ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000002104047210ULL, 0x080fe40007fde0ffULL,
0xfffffffc12127812ULL, 0x100fe200078ee219ULL, 0x00000004161c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1e167812ULL, 0x000fe200078ee219ULL, 0x0000000418207824ULL, 0x000fe200078e00ffULL,
0x00000030100e7812ULL, 0x000fe200078ef805ULL, 0x000000041a247824ULL, 0x000fe200078e00ffULL,
0xfffffffc1c187812ULL, 0x000fe200078ee219ULL, 0x000000010f057824ULL, 0x000fe200030e0623ULL,
0xfffffffc201a7812ULL, 0x000fe200078ee219ULL, 0x0000001012137824ULL, 0x000fe200078e021bULL,
0xfffffffc22107812ULL, 0x000fe200078ee219ULL, 0x0000001016177824ULL, 0x000fe200078e021bULL,
0xfffffffc241c7812ULL, 0x000fe200078ee219ULL, 0x0000001018197824ULL, 0x100fe200078e021bULL,
0x000000210e0e7210ULL, 0x000fe20007fde0ffULL, 0x000000101a1d7824ULL, 0x100fe200078e021bULL,
0x0000000008137faeULL, 0x0003e2000e901c48ULL, 0x00000010101f7824ULL, 0x000fc400078e021bULL,
0x000000101c1b7824ULL, 0x000fe200078e021bULL, 0x000000000a177faeULL, 0x0003e2000e101c48ULL,
0x00000001110f7824ULL, 0x000fc600030e0623ULL, 0x000000000c197faeULL, 0x0003e8000d901c48ULL,
0x00000000141d7faeULL, 0x0003e8000d101c48ULL, 0x00000000041f7faeULL, 0x0003e8000c901c48ULL,
0x000000000e1b7faeULL, 0x0003e2000c101c48ULL, 0x0000056000007947ULL, 0x000fea0003800000ULL,
0x0000001704087211ULL, 0x04afe400078ff0ffULL, 0x0000000404097211ULL, 0x000fc400078fe8ffULL,
0x0000003004147811ULL, 0x040fe400078ff0ffULL, 0x0000003804167811ULL, 0x000fe400078ff0ffULL,
0x0000000309157812ULL, 0x000fe200078ec0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x00000010040c7811ULL, 0x040fe400078ff0ffULL, 0x00000018040e7811ULL, 0x040fe200078ff0ffULL,
0x0000000117137824ULL, 0x040fe200078e0214ULL, 0x0000000804187811ULL, 0x000fe200078ff0ffULL,
0x00000004141a7824ULL, 0x000fe200078e00ffULL, 0x0000002004107811ULL, 0x040fe200078ff0ffULL,
0x0000000117147824ULL, 0x000fe200078e0216ULL, 0x0000002804127811ULL, 0x000fe200078ff0ffULL,
0x00000004161c7824ULL, 0x000fe200078e00ffULL, 0x0000620023277a11ULL, 0x000fe200078038ffULL,
0x00000001170b7824ULL, 0x040fe200078e020cULL, 0x0000003008167812ULL, 0x000fe200078ef805ULL,
0x000000040c0c7824ULL, 0x000fe200078e00ffULL, 0x0000100000257811ULL, 0x000fe200078e68ffULL,
0x00000001170d7824ULL, 0x000fe200078e020eULL, 0x0000630023297a11ULL, 0x000fe200000f3cffULL,
0x00000001170a7824ULL, 0x000fe200078e0218ULL, 0xfffffffc1a087812ULL, 0x100fe200078ee215ULL,
0x000000040e0e7824ULL, 0x000fe200078e00ffULL, 0x0000001627167210ULL, 0x000fe20007f1e0ffULL,
0x00000001170f7824ULL, 0x040fe200078e0210ULL, 0xfffffffc0c0c7812ULL, 0x100fe200078ee215ULL,
0x0000000117117824ULL, 0x000fe200078e0212ULL, 0x0ffffffc15177812ULL, 0x000fe200078ef804ULL,
0x0000000410107824ULL, 0x000fe200078e00ffULL, 0xfffffffc0e0e7812ULL, 0x000fe200078ee215ULL,
0x0000000418187824ULL, 0x000fc400078e00ffULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0xfffffffc10107812ULL, 0x000fe200078ee215ULL, 0x00000010172b7824ULL, 0x000fe200078e0225ULL,
0xfffffffc18047812ULL, 0x000fe200078ee215ULL, 0x0000001008237824ULL, 0x000fe200078e0225ULL,
0xfffffffc12127812ULL, 0x000fe200078ee215ULL, 0x0000000109177824ULL, 0x000fe200000e0629ULL,
0xfffffffc1c157812ULL, 0x000fe200078ee215ULL, 0x000000800a087825ULL, 0x000fc600078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000162b7faeULL, 0x0003e2000b901c48ULL,
0x000000100c1b7824ULL, 0x000fe400078e0225ULL, 0x000000800b0a7825ULL, 0x000fc800078e00ffULL,
0x000000100e1d7824ULL, 0x000fe400078e0225ULL, 0x000000800d0c7825ULL, 0x000fc800078e00ffULL,
0x00000010101f7824ULL, 0x000fe400078e0225ULL, 0x000000800f0e7825ULL, 0x000fc800078e00ffULL,
0x0000001004197824ULL, 0x000fe200078e0225ULL, 0x0000003008047812ULL, 0x000fe200078ef805ULL,
0x0000001012217824ULL, 0x000fe200078e0225ULL, 0x000000300a087812ULL, 0x100fe200078ef805ULL,
0x0000008011107825ULL, 0x000fe200078e00ffULL, 0x000000300c0a7812ULL, 0x100fe400078ef805ULL,
0x000000300e0c7812ULL, 0x000fe200078ef805ULL, 0x0000001015257824ULL, 0x000fe200078e0225ULL,
0x00000030100e7812ULL, 0x000fe200078ef805ULL, 0x0000008013127825ULL, 0x000fe200078e00ffULL,
0x0000000427047210ULL, 0x000fc40007f1e0ffULL, 0x0000000827087210ULL, 0x040fe20007f3e0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000003012107812ULL, 0x100fe400078ef805ULL,
0x0000000a270a7210ULL, 0x040fe40007f5e0ffULL, 0x0000003014057812ULL, 0x000fe400078ef805ULL,
0x0000000c270c7210ULL, 0x040fe40007f7e0ffULL, 0x0000000e270e7210ULL, 0x000fc40007f9e0ffULL,
0x0000000527127210ULL, 0x000fe20007fde0ffULL, 0x0000000109057824ULL, 0x100fe200000e0629ULL,
0x0000001027107210ULL, 0x000fe20007fbe0ffULL, 0x000000010b097824ULL, 0x100fe400008e0629ULL,
0x000000010d0b7824ULL, 0x100fe200010e0629ULL, 0x0000000004197faeULL, 0x0003e2000b901c48ULL,
0x000000010f0d7824ULL, 0x100fe400018e0629ULL, 0x00000001110f7824ULL, 0x100fe200020e0629ULL,
0x00000000081b7faeULL, 0x0003e2000b901c48ULL, 0x0000000113117824ULL, 0x000fc400028e0629ULL,
0x0000000115137824ULL, 0x000fe200030e0629ULL, 0x000000000a1d7faeULL, 0x0003e8000b901c48ULL,
0x000000000c1f7faeULL, 0x0003e8000b901c48ULL, 0x000000000e217faeULL, 0x0003e8000b901c48ULL,
0x0000000010237faeULL, 0x0003e8000b901c48ULL, 0x0000000012257faeULL, 0x0003e4000b901c48ULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000000047805ULL, 0x002fc40000015200ULL,
0x00f60400ff097984ULL, 0x000e640000000800ULL, 0x8000000009ff7812ULL, 0x002fc40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x00000008040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011409ULL,
0x0000000b08087211ULL, 0x000fca00078110ffULL, 0x000000ffff097224ULL, 0x000fca00000e0609ULL,
0x0000000208087819ULL, 0x000fc80000001209ULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff097984ULL, 0x000e640000000800ULL,
0x8000000009ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002000047824ULL, 0x002fca00078e0205ULL,
0x00000003ff057819ULL, 0x000fc80000011604ULL, 0x1ffffffe05077812ULL, 0x000fe400078ec0ffULL,
0x0000000f04057812ULL, 0x000fc600078ec0ffULL, 0x0000000104077824ULL, 0x000fe400078e0207ULL,
0x0000001005097824ULL, 0x040fe400078e00ffULL, 0x0000001005067824ULL, 0x000fe200078e00ffULL,
0x0000000f07047812ULL, 0x040fe400078ec0ffULL, 0x0000000107077810ULL, 0x000fe40007ffe0ffULL,
0x000000f009047812ULL, 0x000fe400078ee204ULL, 0x0000000f07077812ULL, 0x000fc600078ec0ffULL,
0x00000000040c7984ULL, 0x000e62000000cc00ULL, 0x000000f006077812ULL, 0x000fca00078ee207ULL,
0x0000000007087984ULL, 0x000ea2000000cc00ULL, 0x000000ffff107224ULL, 0x002fe400078e000cULL,
0x000000ffff0c7224ULL, 0x000fe400078e000dULL, 0x000000ffff117224ULL, 0x000fe400078e000eULL,
0x000000ffff0d7224ULL, 0x000fe400078e000fULL, 0x000000ffff127224ULL, 0x004fe400078e0008ULL,
0x000000ffff137224ULL, 0x000fc400078e000aULL, 0x000000ffff0e7224ULL, 0x000fe400078e0009ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000bULL, 0x0000001004007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f60000ff087f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0a7224ULL, 0x000fc600078e00ffULL,
0x0000000000047805ULL, 0x002fc80000015200ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x006fc40007804809ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff6700720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x00005800ff6a7624ULL, 0x000fe200078e00ffULL,
0x8000580064727a10ULL, 0x000fe20007ffe0ffULL, 0x0000680070707a24ULL, 0x000fe200078e02ffULL,
0x3db504f363637820ULL, 0x010fe20000410000ULL, 0x0000f68800747811ULL, 0x000fe200078e18ffULL,
0x000000ffff607224ULL, 0x000fe200078e00ffULL, 0x0000001f6a067810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff057224ULL, 0x000fe200078e00ffULL, 0xffffffff6a737810ULL, 0x000fe40007ffe0ffULL,
0x00000004ff067819ULL, 0x000fc40000011606ULL, 0x0000f60800767811ULL, 0x000fe400078e28ffULL,
0x000000096a6a7810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff727819ULL, 0x000fe40000011672ULL,
0x0ffffffe066d7812ULL, 0x000fc400078ec0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff077224ULL, 0x000fe200078e0005ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x01cfc4000001ff00ULL,
0x000000010600780cULL, 0x000fe20003f25270ULL, 0x00000c2000007945ULL, 0x000fe20003800000ULL,
0x0000000160087810ULL, 0x000fe20007ffe0ffULL, 0x0000007103097224ULL, 0x010fe200078e02ffULL,
0x00000001060b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000107057812ULL, 0x000fe400078e0cffULL,
0x000000020b00780cULL, 0x000fca0003f06070ULL, 0x000000ffff081224ULL, 0x000fc800078e0260ULL,
0x00000100081c7824ULL, 0x060fe200078e0275ULL, 0x00000001080a7810ULL, 0x000fe40007ffe0ffULL,
0x000000ff0b087207ULL, 0x000fe40000800000ULL, 0x000000670a00720cULL, 0x000fe20003f46070ULL,
0x000000ffff0a7224ULL, 0x000fe200078e0006ULL, 0x000000401c0c7812ULL, 0x000fe200078ec0ffULL,
0x000000ffff067224ULL, 0x000fc800078e000bULL, 0x00000001691d7824ULL, 0x000fcc00078e020cULL,
0x000005f00000a947ULL, 0x000fea0003800000ULL, 0x00000010040c7824ULL, 0x002fe200078e00ffULL,
0x00000002ff3e7819ULL, 0x000fe20000011604ULL, 0x00000002003c7824ULL, 0x000fe200078e0205ULL,
0x0000001c640b7217ULL, 0x000fe40007800000ULL, 0x000000300c0d7812ULL, 0x000fe200078ec0ffULL,
0x000000013e0f7824ULL, 0x040fe200078e021dULL, 0x000000083e3d7810ULL, 0x040fe20007ffe0ffULL,
0x000000010b1c7824ULL, 0x000fe200078e0a1cULL, 0x000000183e407810ULL, 0x000fe20007ffe0ffULL,
0x00000040080c7824ULL, 0x000fe200078e020dULL, 0x00006200090b7a11ULL, 0x000fe200078238ffULL,
0x000000ffff0d7224ULL, 0x000fe200078e00ffULL, 0x000000103e3f7810ULL, 0x040fe20007ffe0ffULL,
0x000000013d117824ULL, 0x000fe200078e021dULL, 0x0000630009097a11ULL, 0x000fe200008f3cffULL,
0x000000800f0e7825ULL, 0x000fe200078e000cULL, 0x000000203e427810ULL, 0x000fc40007ffe0ffULL,
0x000010003c3c7811ULL, 0x000fe200078e60ffULL, 0x00000001401f7824ULL, 0x000fe200078e021dULL,
0x0000000b0e147210ULL, 0x080fe20007f3e0ffULL, 0x0000008011107825ULL, 0x100fe200078e000cULL,
0x000000303e457810ULL, 0x000fe40007ffe0ffULL, 0x0000001c4000720cULL, 0x000fe20003fa6070ULL,
0x000000801f1e7825ULL, 0x000fe200078e000cULL, 0x0000000b10127210ULL, 0x000fe40007f5e0ffULL,
0x0000000404107211ULL, 0x000fe200078fe8ffULL, 0x000000013f177824ULL, 0x000fc400078e021dULL,
0x000000010f157824ULL, 0x000fe200008e0609ULL, 0x0000000b1e0e7210ULL, 0x000fe20007f3e0ffULL,
0x0000008017167825ULL, 0x000fe200078e000cULL, 0x0000000310437812ULL, 0x000fc600078ec0ffULL,
0x000000043f447824ULL, 0x000fe200078e00ffULL, 0x0000000b16167210ULL, 0x080fe20007f7e0ffULL,
0x000000011f0f7824ULL, 0x100fe200008e0609ULL, 0x0000001c3e00720cULL, 0x080fe20003f26070ULL,
0x0000000111137824ULL, 0x000fe200010e0609ULL, 0x0000001c3d00720cULL, 0x0c0fe20003f46070ULL,
0x000000043d1e7824ULL, 0x000fe200078e00ffULL, 0xfffffffc44417812ULL, 0x000fe200078ee243ULL,
0x0000000117177824ULL, 0x000fe200018e0609ULL, 0x0ffffffc433d7812ULL, 0x000fe200078ef804ULL,
0x0000000142117824ULL, 0x000fe200078e021dULL, 0x000000283e447810ULL, 0x000fe20007ffe0ffULL,
0x0000001041417824ULL, 0x100fe200078e023cULL, 0x0000001c3f00720cULL, 0x080fe20003f66070ULL,
0x000000103d3d7824ULL, 0x000fe200078e023cULL, 0xfffffffc1e3f7812ULL, 0x000fe200078ee243ULL,
0x00000001441f7824ULL, 0x000fe200078e021dULL, 0x000000383e3e7810ULL, 0x000fe20007ffe0ffULL,
0x0000008011107825ULL, 0x000fe200078e000cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000143d7faeULL, 0x0003e4000c901c48ULL, 0x0000001c3e00720cULL, 0x000fe20003f26070ULL,
0x000000103f3f7824ULL, 0x000fe200078e023cULL, 0x0000000b10107210ULL, 0x000fe20007f9e0ffULL,
0x000000801f1e7825ULL, 0x000fc600078e000cULL, 0x00000000123f7faeULL, 0x0005e2000d101c48ULL,
0x0000000111117824ULL, 0x000fe200020e0609ULL, 0x0000001c4200720cULL, 0x080fe20003f86070ULL,
0x0000000440407824ULL, 0x000fe200078e00ffULL, 0x0000000016417faeULL, 0x0007e2000d901c48ULL,
0x0000000145157824ULL, 0x142fe200078e021dULL, 0x0000001c4400720cULL, 0x080fe20003f66070ULL,
0x000000013e1d7824ULL, 0x000fe200078e021dULL, 0x0000001c4500720cULL, 0x000fe20003f46070ULL,
0x0000008015147825ULL, 0x000fe200078e000cULL, 0x0000000b1e127210ULL, 0x004fc60007fde0ffULL,
0x0000000442427824ULL, 0x000fe400078e00ffULL, 0x0000000444447824ULL, 0x000fe200078e00ffULL,
0xfffffffc40177812ULL, 0x008fe200078ee243ULL, 0x000000011f137824ULL, 0x000fe200030e0609ULL,
0x0000000b14147210ULL, 0x000fe20007fde0ffULL, 0x0000000445167824ULL, 0x000fe200078e00ffULL,
0xfffffffc441f7812ULL, 0x000fe200078ee243ULL, 0x000000801d0c7825ULL, 0x000fe200078e000cULL,
0xfffffffc421d7812ULL, 0x100fe400078ee243ULL, 0xfffffffc163d7812ULL, 0x000fe200078ee243ULL,
0x000000043e3e7824ULL, 0x000fc400078e00ffULL, 0x0000000115157824ULL, 0x000fe200030e0609ULL,
0x0000000b0c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001017177824ULL, 0x100fe200078e023cULL,
0xfffffffc3e437812ULL, 0x000fe200078ee243ULL, 0x000000101d1d7824ULL, 0x100fe400078e023cULL,
0x000000101f0b7824ULL, 0x100fe200078e023cULL, 0x000000000e177faeULL, 0x0003e2000e901c48ULL,
0x000000103d1f7824ULL, 0x100fe400078e023cULL, 0x00000010433d7824ULL, 0x000fe200078e023cULL,
0x00000000101d7faeULL, 0x0003e2000e101c48ULL, 0x000000010d0d7824ULL, 0x000fc600030e0609ULL,
0x00000000120b7faeULL, 0x0003e8000d901c48ULL, 0x00000000141f7faeULL, 0x0003e8000d101c48ULL,
0x000000000c3d7faeULL, 0x0003e2000c901c48ULL, 0x0000053000007947ULL, 0x000fea0003800000ULL,
0x0000000804107811ULL, 0x042fe200078ff0ffULL, 0x00000010040b7824ULL, 0x040fe200078e00ffULL,
0x0000001004127811ULL, 0x000fe200078ff0ffULL, 0x00000002000e7824ULL, 0x000fe200078e0205ULL,
0x0000001804147811ULL, 0x000fe200078ff0ffULL, 0x0000000110117824ULL, 0x100fe200078e021dULL,
0x0000002004167811ULL, 0x000fe200078ff0ffULL, 0x0000000410107824ULL, 0x000fe200078e00ffULL,
0x00000028041c7811ULL, 0x000fe200078ff0ffULL, 0x0000000112137824ULL, 0x100fe200078e021dULL,
0x00000030041e7811ULL, 0x000fe200078ff0ffULL, 0x0000000114157824ULL, 0x100fe200078e021dULL,
0x00000004040c7211ULL, 0x000fe200078fe8ffULL, 0x0000000116177824ULL, 0x100fe200078e021dULL,
0x00000038043c7811ULL, 0x000fe200078ff0ffULL, 0x000000011c1f7824ULL, 0x100fe200078e021dULL,
0x000000030c0d7812ULL, 0x000fe200078ec0ffULL, 0x000000011e457824ULL, 0x000fe200078e021dULL,
0x000000300b0b7812ULL, 0x000fe200078ec0ffULL, 0x0000000412127824ULL, 0x000fe200078e00ffULL,
0x000010000e0e7811ULL, 0x000fe200078e60ffULL, 0x0000000414147824ULL, 0x000fe200078e00ffULL,
0xfffffffc103d7812ULL, 0x100fe200078ee20dULL, 0x0000000416167824ULL, 0x000fe200078e00ffULL,
0xfffffffc123f7812ULL, 0x100fe200078ee20dULL, 0x000000041c1c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc14417812ULL, 0x100fe200078ee20dULL, 0x000000041e1e7824ULL, 0x000fe200078e00ffULL,
0xfffffffc16437812ULL, 0x100fe200078ee20dULL, 0x000000043c0c7824ULL, 0x000fe200078e00ffULL,
0xfffffffc1c477812ULL, 0x000fe200078ee20dULL, 0x000000013c497824ULL, 0x000fe200078e021dULL,
0xfffffffc1e4b7812ULL, 0x000fc400078ee20dULL, 0xfffffffc0c4d7812ULL, 0x000fe200078ee20dULL,
0x00000040080c7824ULL, 0x000fe200078e020bULL, 0x0ffffffc0d0d7812ULL, 0x000fe200078ef804ULL,
0x000000103d0b7824ULL, 0x100fe200078e020eULL, 0x0000001d040f7211ULL, 0x000fe200078ff0ffULL,
0x000000103f3d7824ULL, 0x100fe400078e020eULL, 0x000000100d4f7824ULL, 0x100fe400078e020eULL,
0x00000010413f7824ULL, 0x100fe400078e020eULL, 0x0000001043417824ULL, 0x000fc400078e020eULL,
0x000000ffff0d7224ULL, 0x000fe400078e00ffULL, 0x0000001047437824ULL, 0x100fe400078e020eULL,
0x000000104b477824ULL, 0x100fe400078e020eULL, 0x000000104d4b7824ULL, 0x000fe200078e020eULL,
0x00006200094d7a11ULL, 0x000fe200078238ffULL, 0x000000800f0e7825ULL, 0x000fc600078e000cULL,
0x0000630009097a11ULL, 0x000fe200008f3cffULL, 0x0000008011107825ULL, 0x000fe200078e000cULL,
0x0000004d0e0e7210ULL, 0x000fc60007f3e0ffULL, 0x0000008013127825ULL, 0x000fe200078e000cULL,
0x0000004d10107210ULL, 0x000fc60007f5e0ffULL, 0x0000008015147825ULL, 0x000fe200078e000cULL,
0x0000004d12127210ULL, 0x000fc60007f7e0ffULL, 0x0000008017167825ULL, 0x000fe200078e000cULL,
0x0000004d14147210ULL, 0x000fc60007f9e0ffULL, 0x000000801f1c7825ULL, 0x000fc800078e000cULL,
0x00000080451e7825ULL, 0x000fc800078e000cULL, 0x00000080490c7825ULL, 0x000fc800078e000cULL,
0x000000010f0f7824ULL, 0x100fe200008e0609ULL, 0x0000004d16167210ULL, 0x080fe20007f3e0ffULL,
0x0000000111117824ULL, 0x100fe200010e0609ULL, 0x0000004d1c1c7210ULL, 0x080fe20007f5e0ffULL,
0x0000000113137824ULL, 0x100fe200018e0609ULL, 0x0000004d1e1e7210ULL, 0x080fe20007f7e0ffULL,
0x0000000115157824ULL, 0x100fe200020e0609ULL, 0x0000004d0c0c7210ULL, 0x000fe20007f9e0ffULL,
0x0000000117177824ULL, 0x100fe200008e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e4f7faeULL, 0x0003e2000b901c48ULL, 0x000000011d1d7824ULL, 0x000fc400010e0609ULL,
0x000000011f1f7824ULL, 0x100fe200018e0609ULL, 0x00000000100b7faeULL, 0x0003e2000b901c48ULL,
0x000000010d0d7824ULL, 0x000fc600020e0609ULL, 0x00000000123d7faeULL, 0x0003e8000b901c48ULL,
0x00000000143f7faeULL, 0x0003e8000b901c48ULL, 0x0000000016417faeULL, 0x0003e8000b901c48ULL,
0x000000001c437faeULL, 0x0003e8000b901c48ULL, 0x000000001e477faeULL, 0x0003e8000b901c48ULL,
0x000000000c4b7faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010800780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x0000000202027810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff037424ULL, 0x000fc600078e00ffULL, 0x000000680200720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000270087824ULL, 0x000fe400078e0202ULL,
0x00000004ff097424ULL, 0x000fc800078e00ffULL, 0x0000640008087625ULL, 0x000fca00078e0009ULL,
0x0000000808037981ULL, 0x000524000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x0000002004097810ULL, 0x004fe20007ffe0ffULL,
0x0000000200087824ULL, 0x000fe200078e0207ULL, 0xfffffff8040b7812ULL, 0x042fe400078ec0ffULL,
0xfffffff809077812ULL, 0x000fe200078ec0ffULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x00000007040d7812ULL, 0x000fe400078ec0ffULL, 0x000000070b0b7812ULL, 0x100fe400078ef804ULL,
0x00000007070c7812ULL, 0x000fc400078ef804ULL, 0x0000100008077811ULL, 0x000fe400078e60ffULL,
0x000000080d087812ULL, 0x000fe400078ef804ULL, 0x00000001ff627819ULL, 0x000fe4000001160bULL,
0x00000001ff617819ULL, 0x000fe2000001160cULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000001620d7824ULL, 0x000fe200078e0209ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000040b0e7824ULL, 0x000fe200078e00ffULL, 0x00000001090f7810ULL, 0x000fe20007ffe0ffULL,
0x000000040c147824ULL, 0x000fc400078e00ffULL, 0x000000040a6e7824ULL, 0x000fe200078e0209ULL,
0xfffffffc0e0e7812ULL, 0x000fe200078ee20dULL, 0x00000001610d7824ULL, 0x000fe200078e0209ULL,
0x0000000209097810ULL, 0x000fe20007ffe0ffULL, 0x000000026e6e7824ULL, 0x000fe400078e00ffULL,
0x000000100e0e7824ULL, 0x000fe200078e0207ULL, 0xfffffffc14147812ULL, 0x000fe400078ee20dULL,
0x000000040900780cULL, 0x000fe40003f25270ULL, 0x000000000e10783bULL, 0x020e620000000200ULL,
0x0000001014147824ULL, 0x000fcc00078e0207ULL, 0x000000001414783bULL, 0x000ea20000000200ULL,
0x00010000110e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011410ULL,
0x00010000100d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011411ULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000888010447816ULL, 0x040fe200000000ffULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x0000888011467816ULL, 0x040fe200000000ffULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fc40000011412ULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000000e00497306ULL, 0x0003e20000200c00ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00008880124e7816ULL, 0x000fe400000000ffULL,
0x00000018ff557819ULL, 0x004fe40000011414ULL, 0x0000888014547816ULL, 0x000fe200000000ffULL,
0x0000000d00437306ULL, 0x0005e20000200c00ULL, 0x00010000130e7824ULL, 0x002fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fc40000011415ULL, 0x00000018ff577819ULL, 0x000fe40000011416ULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x00000010004a7306ULL, 0x0002e20000200c00ULL,
0x00010000120d7824ULL, 0x044fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011417ULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00008880155b7816ULL, 0x000fe400000000ffULL,
0x00000018ff0d7819ULL, 0x000fc4000001140dULL, 0x0000001100487306ULL, 0x0005e20000200c00ULL,
0x0000000162107824ULL, 0x102fe200078e020fULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x00000001610f7824ULL, 0x000fe200078e020fULL, 0x0000888016597816ULL, 0x000fe400000000ffULL,
0x00008880174f7816ULL, 0x000fe400000000ffULL, 0x0000000e00667306ULL, 0x0003e20000200c00ULL,
0x000000040b117824ULL, 0x004fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fc40000011413ULL,
0x0000888013527816ULL, 0x040fe200000000ffULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0xfffffffc11107812ULL, 0x000fe400078ee210ULL, 0x0000000d006c7306ULL, 0x0005e20000200c00ULL,
0x00010000150e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x0000001010107824ULL, 0x000fe200078e0207ULL, 0x000054104a457816ULL, 0x008fe20000000045ULL,
0x0000010015157824ULL, 0x000fe200078e00ffULL, 0x00000018ff0e7819ULL, 0x000fc4000001140eULL,
0x00000012006b7306ULL, 0x0003e20000200c00ULL, 0x00010000140d7824ULL, 0x044fe200078e00ffULL,
0x00000000101c783bULL, 0x0004e20000000200ULL, 0x0000010014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000018ff0d7819ULL, 0x000fe4000001140dULL,
0x0000000e005d7306ULL, 0x0005e20000200c00ULL, 0x000000040c127824ULL, 0x002fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fcc0000011414ULL, 0x0000000d005f7306ULL, 0x0003e20000200c00ULL,
0xfffffffc120e7812ULL, 0x004fca00078ee20fULL, 0x000000100e107824ULL, 0x000fe400078e0207ULL,
0x00010000170e7824ULL, 0x040fe200078e00ffULL, 0x00000014005e7306ULL, 0x000fe20000200c00ULL,
0x00010000160d7824ULL, 0x042fe400078e00ffULL, 0x0000010016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff0e7819ULL, 0x000fe2000001140eULL, 0x0000010017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff0d7819ULL, 0x000fe4000001140dULL, 0x0000000e004b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff167819ULL, 0x000fc40000011416ULL, 0x00000018ff177819ULL, 0x000fca0000011417ULL,
0x0000000d00587306ULL, 0x0005e20000200c00ULL, 0x00000010080e7824ULL, 0x002fe200078e00ffULL,
0x00000018ff417819ULL, 0x008fe2000001141cULL, 0x000100001c427824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe4000001141dULL, 0x000088801d4a7816ULL, 0x000fe400000000ffULL,
0x00000015005c7306ULL, 0x000fe20000200c00ULL, 0x0000006e040d7211ULL, 0x004fe400078fe0ffULL,
0x00000018ff3e7819ULL, 0x000fc4000001141fULL, 0x000088801e4d7816ULL, 0x000fe200000000ffULL,
0x00000001080d7824ULL, 0x000fe200078e020dULL, 0x00000018ff3f7819ULL, 0x000fe2000001141eULL,
0x0000001600567306ULL, 0x000fe20000200c00ULL, 0x00000018ff427819ULL, 0x000fe40000011442ULL,
0xfffffff00e0d7812ULL, 0x000fe400078ee20dULL, 0x000088801c0e7816ULL, 0x040fe200000000ffULL,
0x000001001c1c7824ULL, 0x000fe400078e00ffULL, 0x000000100d147824ULL, 0x000fe200078e00ffULL,
0x0000001700507306ULL, 0x0003e40000200c00ULL, 0x00000018ff1c7819ULL, 0x000fcc000001141cULL,
0x0000004400447306ULL, 0x000ea20000200c00ULL, 0x000000001414783bULL, 0x002e6e0000000200ULL,
0x0000001300657306ULL, 0x0007e20000200c00ULL, 0x0000541044447816ULL, 0x004fe20000000043ULL,
0x000000001010783bULL, 0x008eac0000000200ULL, 0x0000004600467306ULL, 0x000ef00000200c00ULL,
0x0000004700477306ULL, 0x000eb00000200c00ULL, 0x0000001c00437306ULL, 0x0007e20000200c00ULL,
0x000000441438723cULL, 0x002bee0000001838ULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x00005410461c7816ULL, 0x008fc40000000049ULL, 0x000088801f497816ULL, 0x000fe200000000ffULL,
0x000100001d457824ULL, 0x060fe400078e00ffULL, 0x000001001d1d7824ULL, 0x000fe400078e00ffULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x00000018ff0d7819ULL, 0x004fc60000011413ULL,
0x0000001d00467306ULL, 0x0003e20000200c00ULL, 0x00000018ff3d7819ULL, 0x000fe40000011410ULL,
0x00000018ff3c7819ULL, 0x000fe40000011411ULL, 0x00000018ff0f7819ULL, 0x000fc60000011412ULL,
0x0000005500557306ULL, 0x000ea20000200c00ULL, 0x00005410481d7816ULL, 0x002fe20000000047ULL,
0x000100001e487824ULL, 0x040fe400078e00ffULL, 0x000001001e1e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011448ULL, 0x0000001c1434723cULL, 0x000be20000001834ULL,
0x0000004d00477306ULL, 0x000fe20000200c00ULL, 0x00000018ff1e7819ULL, 0x000fca000001141eULL,
0x000100001f1c7824ULL, 0x060fe200078e00ffULL, 0x000054105e557816ULL, 0x004fe20000000055ULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000005400547306ULL, 0x000e620000200c00ULL,
0x00000100115e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x00000018ff1d7819ULL, 0x000fe4000001141fULL, 0x00008880101f7816ULL, 0x000fe400000000ffULL,
0x0000001c004d7306ULL, 0x0005f00000200c00ULL, 0x0000005300537306ULL, 0x000ee20000200c00ULL,
0x000054104e1c7816ULL, 0x004fe2000000006cULL, 0x00000010086c7824ULL, 0x000fe200078e00ffULL,
0x0000541054547816ULL, 0x002fca000000005fULL, 0x0000001d004e7306ULL, 0x0003e40000200c00ULL,
0x000000541428723cULL, 0x000fec0000001828ULL, 0x0000005200527306ULL, 0x000ea20000200c00ULL,
0x000054106b1d7816ULL, 0x002fe2000000004cULL, 0x000000ffff4c7224ULL, 0x000fe200078e001fULL,
0x000000026e1f7810ULL, 0x000fc80007ffe0ffULL, 0x0000001f041f7211ULL, 0x000fe200078fe0ffULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x0000001c1430723cULL, 0x000b660000001830ULL,
0x00000001081f7824ULL, 0x000fc800078e021fULL, 0x0000005b005b7306ULL, 0x000e620000200c00ULL,
0x00000100101c7824ULL, 0x020fe200078e00ffULL, 0xfffffff06c1f7812ULL, 0x000fe400078ee21fULL,
0x00005410651d7816ULL, 0x008fe20000000053ULL, 0x0001000011657824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe2000001141cULL, 0x000000101f1f7824ULL, 0x000fe200078e00ffULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x00005410521c7816ULL, 0x004fe40000000066ULL,
0x000054105c557816ULL, 0x002fc4000000005aULL, 0x0000888011667816ULL, 0x000fe400000000ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001145eULL, 0x0000005900597306ULL, 0x000e620000200c00ULL,
0x000054105b547816ULL, 0x000fe2000000005dULL, 0x0000001c142c723cULL, 0x000f62000000182cULL,
0x00008880125b7816ULL, 0x000fe200000000ffULL, 0x000000ffff537224ULL, 0x000fe200078e0066ULL,
0x00000018ff657819ULL, 0x000fc60000011465ULL, 0x0000004a00447306ULL, 0x000fe40000200c00ULL,
0x000000541424723cULL, 0x000b6c0000001824ULL, 0x0000001e004a7306ULL, 0x0005e20000200c00ULL,
0x0000541059547816ULL, 0x022fe40000000058ULL, 0x0000541056557816ULL, 0x000fe20000000057ULL,
0x0001000012577824ULL, 0x000fc400078e00ffULL, 0x000000ffff567224ULL, 0x000fe400078e005bULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x00010000101e7824ULL, 0x004fe200078e00ffULL,
0x000000541420723cULL, 0x000b620000001820ULL, 0x00000018ff577819ULL, 0x000fc60000011457ULL,
0x00000018ff6b7819ULL, 0x000fe4000001141eULL, 0x0000004f004f7306ULL, 0x000ea20000200c00ULL,
0x000000001f1c783bULL, 0x000eee0000000200ULL, 0x0000000e000e7306ULL, 0x000fe20000200c00ULL,
0x0000541050557816ULL, 0x022fce0000000051ULL, 0x0000004200427306ULL, 0x000e620000200c00ULL,
0x000054104f547816ULL, 0x004fce000000004bULL, 0x0000003f003f7306ULL, 0x000ea20000200c00ULL,
0x000000541418723cULL, 0x000b6e0000001818ULL, 0x0000004800487306ULL, 0x000ee20000200c00ULL,
0x0000010012147824ULL, 0x020fe200078e00ffULL, 0x000054100e427816ULL, 0x002fe20000000042ULL,
0x0001000013167824ULL, 0x000fc600078e00ffULL, 0x00000018ff0e7819ULL, 0x000fe40000011414ULL,
0x0000003e003e7306ULL, 0x000fe20000200c00ULL, 0x0000888013147816ULL, 0x040fe200000000ffULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x000054104a157816ULL, 0x004fe4000000003fULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x0000004900497306ULL, 0x000e700000200c00ULL, 0x0000001400177306ULL, 0x0007f00000200c00ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x0000541047147816ULL, 0x008fce0000000048ULL,
0x000000141c30723cULL, 0x040b620000001830ULL, 0x0000006b00107306ULL, 0x000eac0000200c00ULL,
0x0000541049147816ULL, 0x022fe4000000004dULL, 0x000054104e157816ULL, 0x000fe2000000003eULL,
0x0000004500457306ULL, 0x000e6c0000200c00ULL, 0x000000141c2c723cULL, 0x000b62000000182cULL,
0x000054104c4c7816ULL, 0x004fe20000000010ULL, 0x0000005300537306ULL, 0x000ff00000200c00ULL,
0x0000006500117306ULL, 0x000ea20000200c00ULL, 0x0000541044447816ULL, 0x002fce0000000045ULL,
0x0000001600167306ULL, 0x000e700000200c00ULL, 0x0000004100417306ULL, 0x000ee20000200c00ULL,
0x0000541053107816ULL, 0x004fce0000000011ULL, 0x0000004000407306ULL, 0x000ea20000200c00ULL,
0x0000541017167816ULL, 0x002fce0000000016ULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x0000541043437816ULL, 0x008fce0000000041ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000541046457816ULL, 0x004fe20000000040ULL, 0x000000421c38723cULL, 0x040b6c0000001838ULL,
0x0000000f000f7306ULL, 0x000fe40000200c00ULL, 0x000000441c34723cULL, 0x000b6c0000001834ULL,
0x0000000d000d7306ULL, 0x000ff00000200c00ULL, 0x0000006c00527306ULL, 0x000e700000200c00ULL,
0x0000005a005a7306ULL, 0x000eb00000200c00ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x00005410524d7816ULL, 0x002fce000000003dULL, 0x0000005700127306ULL, 0x000e620000200c00ULL,
0x000054105a117816ULL, 0x004fe2000000003cULL, 0x0000004c1c28723cULL, 0x040b6c0000001828ULL,
0x0000000e000e7306ULL, 0x000ea40000200c00ULL, 0x000000101c24723cULL, 0x000b6c0000001824ULL,
0x0000001300147306ULL, 0x0204e20000200c00ULL, 0x0000541056127816ULL, 0x002fc40000000012ULL,
0x000054100e137816ULL, 0x004fe4000000000fULL, 0x0000541014177816ULL, 0x008fca000000000dULL,
0x000000121c20723cULL, 0x040b700000001820ULL, 0x000000161c18723cULL, 0x000b620000001818ULL,
0xfffff05000001947ULL, 0x000fce000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff077224ULL, 0x000fe200078e0005ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe23000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000006331317220ULL, 0x080fe20000410000ULL, 0x0000006339397220ULL, 0x080fe20000410000ULL,
0x0000006334347220ULL, 0x080fe20000410000ULL, 0x0000006335357220ULL, 0x080fe20000410000ULL,
0x0000006330307220ULL, 0x080fe20000410000ULL, 0x000000632c067220ULL, 0x080fe20000410000ULL,
0x0000006328077220ULL, 0x080fe20000410000ULL, 0x00000063331f7220ULL, 0x0a0fe20000410000ULL,
0x000000632e0a7220ULL, 0x080fe20000410000ULL, 0x000000632a0c7220ULL, 0x080fe20000410000ULL,
0x0000006327157220ULL, 0x080fe20000410000ULL, 0x000000632d337220ULL, 0x080fe20000410000ULL,
0x000000632f0b7220ULL, 0x080fe20000410000ULL, 0x000000632b127220ULL, 0x080fe20000410000ULL,
0x00000063242a7220ULL, 0x080fe20000410000ULL, 0x00000063252e7220ULL, 0x080fe20000410000ULL,
0x0000006326147220ULL, 0x080fe20000410000ULL, 0x00000063230e7220ULL, 0x080fe20000410000ULL,
0x000000ffff277224ULL, 0x000fe200078e0031ULL, 0x0000006338137220ULL, 0x080fe20000410000ULL,
0x000000633a1e7220ULL, 0x080fe20000410000ULL, 0x000000633b167220ULL, 0x080fe20000410000ULL,
0x0000006336177220ULL, 0x080fe20000410000ULL, 0x0000006337377220ULL, 0x080fe20000410000ULL,
0x0000006332327220ULL, 0x080fe20000410000ULL, 0x0000006329297220ULL, 0x080fe20000410000ULL,
0x00000063202d7220ULL, 0x080fe20000410000ULL, 0x00000063212b7220ULL, 0x080fe20000410000ULL,
0x00000063220d7220ULL, 0x080fe20000410000ULL, 0x0000006318237220ULL, 0x080fe20000410000ULL,
0x0000006319247220ULL, 0x080fe20000410000ULL, 0x000000631a0f7220ULL, 0x080fe20000410000ULL,
0x000000631b1c7220ULL, 0x000fe20000410000ULL, 0x000000ffff257224ULL, 0x000fc400078e0039ULL,
0x000000ffff267224ULL, 0x000fe400078e0034ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0035ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0030ULL, 0x000000ffff287224ULL, 0x000fe400078e0006ULL,
0x000000ffff317224ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000074087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff207224ULL, 0x000fc400078e0032ULL,
0x000000ffff307224ULL, 0x000fe400078e0037ULL, 0x000000ffff217224ULL, 0x000fe400078e000aULL,
0x000000ffff327224ULL, 0x000fe400078e000bULL, 0x000000ffff227224ULL, 0x000fe400078e000cULL,
0x000000ffff197224ULL, 0x000fe400078e000dULL, 0x000000ffff1a7224ULL, 0x000fc400078e000eULL,
0x000000ffff1b7224ULL, 0x000fc400078e000fULL, 0x0000000000067805ULL, 0x002fca0000015200ULL,
0x00000400740b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x006fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a060d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e07ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000000d0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400740b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004041d7824ULL, 0x000fe200078e00ffULL, 0x000000726000720cULL, 0x000fc80003f06070ULL,
0xfffffff01d077812ULL, 0x000fca00078ec0ffULL, 0x0000008000187824ULL, 0x000fca00078e0207ULL,
0x00f4000018087984ULL, 0x0002a20000000c00ULL, 0x0000136000008947ULL, 0x000fea0003800000ULL,
0x0000010060077824ULL, 0x000fe200078e0275ULL, 0x0000006f04067211ULL, 0x040fe200078ff0ffULL,
0x0000000204357824ULL, 0x000fe400078e00ffULL, 0x00000002ff4a7424ULL, 0x000fe200078e00ffULL,
0x0000000764347217ULL, 0x000fe40007800000ULL, 0x0000000635357812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff0c7a19ULL, 0x000fe20000011606ULL, 0x0000000134347824ULL, 0x000fe200078e0a07ULL,
0x0000580035377a10ULL, 0x000fe20007ffe0ffULL, 0x000000016a077824ULL, 0x000fe200078e0235ULL,
0x0000000c730c7217ULL, 0x000fc40003800000ULL, 0x000000343700720cULL, 0x080fe20003f06070ULL,
0x0000000107107824ULL, 0x140fe200078e0a34ULL, 0x000000340700720cULL, 0x000fe20003f26070ULL,
0x00000001370e7824ULL, 0x000fe400078e0a34ULL, 0x0000000c6d517224ULL, 0x000fe200078e02ffULL,
0x0000001073107217ULL, 0x040fe40003800000ULL, 0x0000000e730e7217ULL, 0x000fe40003800000ULL,
0x00000004ff107819ULL, 0x000fc40000011610ULL, 0x000000ff0e427207ULL, 0x000fe40000000000ULL,
0x000000ff10107207ULL, 0x000fe40000800000ULL, 0x0000005142077211ULL, 0x000fe400078fe0ffULL,
0x00000008060e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001510d7824ULL, 0x000fe200078e0210ULL,
0x00000010353d7812ULL, 0x000fe200078efcffULL, 0x0000600007067625ULL, 0x000fe200078e004aULL,
0x00005a00ff0e7a19ULL, 0x000fc6000001160eULL, 0x000060000d0c7625ULL, 0x000fe200078e004aULL,
0x000058003d397a10ULL, 0x000fe20007ffe0ffULL, 0x0000000806487981ULL, 0x0046a2000c1e9500ULL,
0x0000000e730e7217ULL, 0x000fc60003800000ULL, 0x000000080c4f7981ULL, 0x0002a2000c1e9500ULL,
0x00000020353b7812ULL, 0x000fe200078efcffULL, 0x0000000e6d537224ULL, 0x000fe400078e02ffULL,
0x0000000139067824ULL, 0x148fe400078e0a34ULL, 0x000000016a077824ULL, 0x000fe200078e023dULL,
0x000000343900720cULL, 0x000fe20003f06070ULL, 0x0000000110117824ULL, 0x000fe200078e0253ULL,
0x0000000673067217ULL, 0x000fe20003800000ULL, 0x00000001070c7824ULL, 0x002fe200078e0a34ULL,
0x000058003b417a10ULL, 0x000fe20007ffe0ffULL, 0x0000600011107625ULL, 0x000fe200078e004aULL,
0x00000053420f7211ULL, 0x000fc400078fe0ffULL, 0x000000ff06367207ULL, 0x000fe20000000000ULL,
0x00000001413c7824ULL, 0x000fe200078e0a34ULL, 0x0000000c730c7217ULL, 0x000fe20003800000ULL,
0x000060000f0e7625ULL, 0x000fe200078e004aULL, 0x000000340700720cULL, 0x080fe20003f26070ULL,
0x00000008104d7981ULL, 0x0002e2000c1e9500ULL, 0x0000005136077211ULL, 0x000fe200078fe0ffULL,
0x000000016a457824ULL, 0x000fe200078e023bULL, 0x00000004ff0c7819ULL, 0x000fe2000001160cULL,
0x000000080e447981ULL, 0x0002e2000c1e9500ULL, 0x000000344100720cULL, 0x000fc40003f06070ULL,
0x0000003c733c7217ULL, 0x000fe20003800000ULL, 0x0000600007067625ULL, 0x000fc600078e004aULL,
0x000000ff3c3c7207ULL, 0x000fe20000000000ULL, 0x00000001453e7824ULL, 0x040fe200078e0a34ULL,
0x0000000806387981ULL, 0x0002e4000c1e9500ULL, 0x000000ff0c0e7207ULL, 0x002fe40000800000ULL,
0x000000344500720cULL, 0x000fe40003f26070ULL, 0x0000003035457812ULL, 0x000fe200078efcffULL,
0x00000001510d7824ULL, 0x000fe200078e020eULL, 0x00000053360f7211ULL, 0x000fe200078fe0ffULL,
0x000000010e117824ULL, 0x000fe200078e0253ULL, 0x0000003e733e7217ULL, 0x000fc40003800000ULL,
0x000000513c077211ULL, 0x000fe200078fe0ffULL, 0x000000016a557824ULL, 0x000fe200078e0245ULL,
0x00000004ff3e7819ULL, 0x000fe2000001163eULL, 0x000060000d0c7625ULL, 0x000fe200078e004aULL,
0x0000580045477a10ULL, 0x000fc60007ffe0ffULL, 0x000060000f0e7625ULL, 0x000fc800078e004aULL,
0x0000600011107625ULL, 0x080fe200078e004aULL, 0x000000ff3e407207ULL, 0x000fe20000800000ULL,
0x000000080c3f7981ULL, 0x0002e4000c1e9500ULL, 0x0000600007067625ULL, 0x000fe400078e004aULL,
0x000000080e3a7981ULL, 0x0002e4000c1e9500ULL, 0x0000000155467824ULL, 0x000fe400078e0a34ULL,
0x0000000810437981ULL, 0x0002e8000c1e9500ULL, 0x00000008063e7981ULL, 0x0002e2000c1e9500ULL,
0x0000004673467217ULL, 0x000fe20003800000ULL, 0x00000001510d7824ULL, 0x002fe200078e0240ULL,
0x000000533c0f7211ULL, 0x000fe200078fe0ffULL, 0x0000000140117824ULL, 0x000fc400078e0253ULL,
0x0000000147067824ULL, 0x040fe200078e0a34ULL, 0x000000344700720cULL, 0x000fe20003f06070ULL,
0x000060000d0c7625ULL, 0x000fe200078e004aULL, 0x000000345500720cULL, 0x000fe40003f26070ULL,
0x0000000673067217ULL, 0x000fe20003800000ULL, 0x000060000f0e7625ULL, 0x080fe200078e004aULL,
0x00000004ff077819ULL, 0x000fe20000011646ULL, 0x000000080c497981ULL, 0x0002e4000c1e9500ULL,
0x0000600011107625ULL, 0x000fe200078e004aULL, 0x000000ff06467207ULL, 0x000fe20000000000ULL,
0x000000080e407981ULL, 0x0002e2000c1e9500ULL, 0x000000ff074c7207ULL, 0x000fc60000800000ULL,
0x00000008104b7981ULL, 0x0002e2000c1e9500ULL, 0x0000005146077211ULL, 0x000fe200078fe0ffULL,
0x00000001510d7824ULL, 0x002fc800078e024cULL, 0x0000600007067625ULL, 0x000fc800078e004aULL,
0x000060000d0c7625ULL, 0x000fe400078e004aULL, 0x0000000806067981ULL, 0x0002e2000c1e9500ULL,
0x00000053460f7211ULL, 0x000fc600078fe0ffULL, 0x000000080c0d7981ULL, 0x0002e2000c1e9500ULL,
0x000000014c117824ULL, 0x000fe400078e0253ULL, 0x000060000f0e7625ULL, 0x000fc800078e004aULL,
0x0000600011107625ULL, 0x000fe400078e004aULL, 0x000000080e0e7981ULL, 0x0002e8000c1e9500ULL,
0x0000000810117981ULL, 0x0002e2000c1e9500ULL, 0xfffffff042517812ULL, 0x000fe200078ec0ffULL,
0x00000001ff427424ULL, 0x000fe200078e00ffULL, 0x0000000135077812ULL, 0x002fc600078efcffULL,
0x00000001344a7824ULL, 0x000fe200078e0251ULL, 0x0000000935537812ULL, 0x000fc600078efcffULL,
0x0000000137577824ULL, 0x100fe200078e0a4aULL, 0x0000580007557a10ULL, 0x000fe40007ffe0ffULL,
0x00005800530f7a10ULL, 0x000fe40007ffe0ffULL, 0x0000005742577219ULL, 0x000fe200000006ffULL,
0x0000000155597824ULL, 0x100fe400078e0a4aULL, 0x000000010f5d7824ULL, 0x000fc600078e0a4aULL,
0x0000005942597219ULL, 0x040fe400000006ffULL, 0x0000005d425d7219ULL, 0x000fe400000006ffULL,
0x00000011357d7812ULL, 0x040fe400078efcffULL, 0x00000018357b7812ULL, 0x040fe400078efcffULL,
0x0000001935797812ULL, 0x000fe400078efcffULL, 0x000058007b107a10ULL, 0x000fc40007ffe0ffULL,
0x00005800790c7a10ULL, 0x000fe40007ffe0ffULL, 0x0000002135617812ULL, 0x040fe400078efcffULL,
0x00000028355f7812ULL, 0x000fe400078efcffULL, 0xfffffff046467812ULL, 0x000fe400078ec0ffULL,
0x0000580061777a10ULL, 0x000fe40007ffe0ffULL, 0x000058005f6b7a10ULL, 0x000fe20007ffe0ffULL,
0x00000001344c7824ULL, 0x000fc800078e0246ULL, 0x00000001474e7824ULL, 0x000fca00078e0a4cULL,
0x0000004e424e7219ULL, 0x000fe400000006ffULL, 0x0000541048487816ULL, 0x004fe4000000004fULL,
0x00000008354f7812ULL, 0x000fc800078efcffULL, 0x000058004f517a10ULL, 0x000fe40007ffe0ffULL,
0x0000004857ff7212ULL, 0x000fc6000780c0ffULL, 0x00000001515b7824ULL, 0x000fe200078e0a4aULL,
0x000000343700720cULL, 0x000fc80000701470ULL, 0x0000005b425b7219ULL, 0x000fe400000006ffULL,
0x0000004859ff7212ULL, 0x080fe4000786c0ffULL, 0x000000485bff7212ULL, 0x080fe4000784c0ffULL,
0x000000485dff7212ULL, 0x000fe4000782c0ffULL, 0x000000343500720cULL, 0x000fe40000701070ULL,
0x0000541044447816ULL, 0x008fc4000000004dULL, 0xfffffff036487812ULL, 0x000fe400078ec0ffULL,
0xff80000013137808ULL, 0x000fe40000000000ULL, 0x0000004457ff7212ULL, 0x080fe2000788c0ffULL,
0x0000000134487824ULL, 0x000fe200078e0248ULL, 0x0000004459ff7212ULL, 0x080fe400078ac0ffULL,
0x000000445bff7212ULL, 0x080fe400078cc0ffULL, 0x000000445dff7212ULL, 0x000fc4000780c0ffULL,
0x000058007d447a10ULL, 0x000fe20007ffe0ffULL, 0x0000000139507824ULL, 0x100fe200078e0a48ULL,
0x000000343700720cULL, 0x080fe20002781470ULL, 0x0000000110547824ULL, 0x100fe200078e0a48ULL,
0x000000345100720cULL, 0x080fe200037c1470ULL, 0x0000000144527824ULL, 0x100fe200078e0a48ULL,
0x000000340f00720cULL, 0x000fe20000701470ULL, 0x000000010c567824ULL, 0x000fe200078e0a48ULL,
0x0000005042487219ULL, 0x000fe400000006ffULL, 0xfffffff03c4a7812ULL, 0x000fc400078ec0ffULL,
0x0000005242507219ULL, 0x040fe400000006ffULL, 0x000000343500720cULL, 0x080fe40002781070ULL,
0x000000344f00720cULL, 0x080fe400037c1070ULL, 0x000000345300720cULL, 0x000fe40000701070ULL,
0x0000005442527219ULL, 0x000fe400000006ffULL, 0x00005410383f7816ULL, 0x000fe2000000003fULL,
0x00000001344a7824ULL, 0x000fe200078e024aULL, 0x000000340f00720cULL, 0x000fc40000f21470ULL,
0x000054103a437816ULL, 0x000fe40000000043ULL, 0xff8000001e1e7808ULL, 0x000fe40002000000ULL,
0xff80000017177808ULL, 0x000fe40003000000ULL, 0xff80000030307808ULL, 0x000fe40000000000ULL,
0x0000003f48ff7212ULL, 0x040fe4000788c0ffULL, 0x0000004348ff7212ULL, 0x000fc400078cc0ffULL,
0x0000004352ff7212ULL, 0x000fe2000780c0ffULL, 0x0000000141587824ULL, 0x000fe200078e0a4aULL,
0x000000345300720cULL, 0x080fe40000f21070ULL, 0x000000345500720cULL, 0x0c0fe40001f61470ULL,
0x000000345500720cULL, 0x080fe40002fa1470ULL, 0x000000345100720cULL, 0x080fe40001741470ULL,
0x000000343900720cULL, 0x000fc40002781470ULL, 0x000000343900720cULL, 0x080fe400037c1470ULL,
0x000000341000720cULL, 0x080fe40000701470ULL, 0xff8000002f2f7808ULL, 0x000fe40000800000ULL,
0x00000029355d7812ULL, 0x000fe400078efcffULL, 0x000000340700720cULL, 0x0c0fe40001f61070ULL,
0x000000340700720cULL, 0x000fc40002fa1070ULL, 0x000000344f00720cULL, 0x080fe40001741070ULL,
0x000000343d00720cULL, 0x0c0fe40002721070ULL, 0x000000343d00720cULL, 0x080fe400037c1070ULL,
0x000000347b00720cULL, 0x000fe40000701070ULL, 0x0000005642567219ULL, 0x040fe400000006ffULL,
0x0000005842547219ULL, 0x000fc400000006ffULL, 0x000054103e497816ULL, 0x000fe40000000049ULL,
0x00005410404b7816ULL, 0x000fe4000000004bULL, 0x000058005d657a10ULL, 0x000fe40007ffe0ffULL,
0xff80000025257808ULL, 0x000fe40001800000ULL, 0xff80000016167808ULL, 0x000fe40002800000ULL,
0xff80000026267808ULL, 0x000fc40001000000ULL, 0xff8000002c2c7808ULL, 0x000fe40000800000ULL,
0xff80000020207808ULL, 0x000fe40003000000ULL, 0xff80000021217808ULL, 0x000fe40000000000ULL,
0x0000003f50ff7212ULL, 0x080fe4000786c0ffULL, 0x0000003f52ff7212ULL, 0x080fe400078ac0ffULL,
0x0000003f56ff7212ULL, 0x000fc4000784c0ffULL, 0x0000004350ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004356ff7212ULL, 0x000fe4000782c0ffULL, 0x0000004954ff7212ULL, 0x040fe400078cc0ffULL,
0x0000004b54ff7212ULL, 0x000fe2000780c0ffULL, 0x00000001775a7824ULL, 0x100fe200078e0a4aULL,
0x000000344400720cULL, 0x0c0fe20001f61470ULL, 0x000000016b5c7824ULL, 0x100fe200078e0a4aULL,
0x000000344400720cULL, 0x080fe20002781470ULL, 0x00000001655e7824ULL, 0x000fe200078e0a4aULL,
0x000000341000720cULL, 0x000fc40002fa1470ULL, 0x000000340c00720cULL, 0x0c0fe40001741470ULL,
0x000000340c00720cULL, 0x080fe40000f21470ULL, 0x000000344100720cULL, 0x0c0fe400037c1470ULL,
0x000000344100720cULL, 0x000fe40000701470ULL, 0x0000003135597812ULL, 0x040fe400078efcffULL,
0x0000003835577812ULL, 0x000fc400078efcffULL, 0x00000039354d7812ULL, 0x000fe400078efcffULL,
0x0000005a42587219ULL, 0x000fe400000006ffULL, 0x000000347d00720cULL, 0x0c0fe40001f61070ULL,
0x000000347d00720cULL, 0x080fe40002781070ULL, 0x000000347b00720cULL, 0x080fe40002fa1070ULL,
0x000000347900720cULL, 0x000fc40001741070ULL, 0x000000347900720cULL, 0x080fe40000f21070ULL,
0x000000343b00720cULL, 0x0c0fe400037c1070ULL, 0x000000343b00720cULL, 0x000fe40000701070ULL,
0x0000005c425a7219ULL, 0x040fe400000006ffULL, 0x0000005e425e7219ULL, 0x000fe400000006ffULL,
0x00005410060d7816ULL, 0x000fc4000000000dULL, 0x00005800595b7a10ULL, 0x000fe40007ffe0ffULL,
0x0000580057367a10ULL, 0x000fe40007ffe0ffULL, 0x000058004d3c7a10ULL, 0x000fe40007ffe0ffULL,
0xff80000027277808ULL, 0x000fe40001800000ULL, 0xff8000001f1f7808ULL, 0x000fe40002000000ULL,
0xff80000028287808ULL, 0x000fc40002800000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fe40000800000ULL, 0xff80000031317808ULL, 0x000fe40003000000ULL,
0xff80000022227808ULL, 0x000fe40000000000ULL, 0x0000004958ff7212ULL, 0x080fe4000786c0ffULL,
0x000000495aff7212ULL, 0x000fc4000788c0ffULL, 0x000000495eff7212ULL, 0x000fe400078ac0ffULL,
0x0000004b58ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004b5aff7212ULL, 0x080fe4000782c0ffULL,
0x0000004b5eff7212ULL, 0x000fe400078cc0ffULL, 0x0000000d4eff7212ULL, 0x000fe2000780c0ffULL,
0x000000015b4a7824ULL, 0x100fe200078e0a4cULL, 0x000000347700720cULL, 0x0c0fe20001f61470ULL,
0x0000000136467824ULL, 0x100fe200078e0a4cULL, 0x000000347700720cULL, 0x080fe20001741470ULL,
0x000000013c4c7824ULL, 0x000fe200078e0a4cULL, 0x000000346b00720cULL, 0x000fc40002781470ULL,
0x000000346b00720cULL, 0x080fe40000f21470ULL, 0x000000346500720cULL, 0x0c0fe40002fa1470ULL,
0x000000346500720cULL, 0x080fe400037c1470ULL, 0x000000344700720cULL, 0x080fe40000701470ULL,
0x000000346100720cULL, 0x0c0fe40001f61070ULL, 0x000000346100720cULL, 0x000fc40001741070ULL,
0x000000345f00720cULL, 0x0c0fe40002781070ULL, 0x000000345f00720cULL, 0x080fe40000f21070ULL,
0x000000345d00720cULL, 0x0c0fe40002fa1070ULL, 0x000000345d00720cULL, 0x080fe400037c1070ULL,
0x000000344500720cULL, 0x000fe40000701070ULL, 0x0000004a424a7219ULL, 0x000fc400000006ffULL,
0x0000004642467219ULL, 0x040fe400000006ffULL, 0x0000004c424c7219ULL, 0x000fe400000006ffULL,
0x000054100e117816ULL, 0x000fe40000000011ULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff80000012127808ULL, 0x000fe40001000000ULL, 0xff8000002a2a7808ULL, 0x000fc40002000000ULL,
0xff80000014147808ULL, 0x000fe40000800000ULL, 0xff8000002e2e7808ULL, 0x000fe40002800000ULL,
0xff80000015157808ULL, 0x000fe40003000000ULL, 0xff8000002d2d7808ULL, 0x000fe40000000000ULL,
0x0000000d4aff7212ULL, 0x080fe4000786c0ffULL, 0x0000000d46ff7212ULL, 0x000fc4000784c0ffULL,
0x0000000d4cff7212ULL, 0x000fe4000788c0ffULL, 0x000000114eff7212ULL, 0x080fe4000782c0ffULL,
0x000000114aff7212ULL, 0x080fe400078ac0ffULL, 0x0000001146ff7212ULL, 0x080fe400078cc0ffULL,
0x000000114cff7212ULL, 0x000fe4000780c0ffULL, 0x000000344700720cULL, 0x000fc40000f21470ULL,
0x000000345b00720cULL, 0x0c0fe40001f61470ULL, 0x000000345b00720cULL, 0x080fe40002fa1470ULL,
0x000000343600720cULL, 0x0c0fe40001741470ULL, 0x000000343600720cULL, 0x080fe400037c1470ULL,
0x000000343c00720cULL, 0x0c0fe40002781470ULL, 0x000000343c00720cULL, 0x000fc40000701470ULL,
0x000000344500720cULL, 0x080fe40000f21070ULL, 0x000000345900720cULL, 0x0c0fe40001f61070ULL,
0x000000345900720cULL, 0x080fe40002fa1070ULL, 0x000000345700720cULL, 0x0c0fe40001741070ULL,
0x000000345700720cULL, 0x080fe400037c1070ULL, 0x000000344d00720cULL, 0x000fc40002781070ULL,
0x000000344d00720cULL, 0x000fe40000701070ULL, 0xff8000002b2b7808ULL, 0x000fe40001800000ULL,
0xff80000023237808ULL, 0x000fe40001000000ULL, 0xff80000024247808ULL, 0x000fe40002000000ULL,
0xff80000019197808ULL, 0x000fe40000800000ULL, 0xff8000001a1a7808ULL, 0x000fc40002800000ULL,
0xff8000001b1b7808ULL, 0x000fe40003000000ULL, 0xff8000001c1c7808ULL, 0x000fc40000000000ULL,
0x000000130800720bULL, 0x004fe20003f1e000ULL, 0x0000001fff117424ULL, 0x000fe200078e00ffULL,
0x0000001e0900720bULL, 0x000fe20003f3e000ULL, 0xffffffffff367424ULL, 0x000fe200078e00ffULL,
0x0000000813087208ULL, 0x000fe40004000000ULL, 0x000000091e097208ULL, 0x000fe40004800000ULL,
0x000000250800720bULL, 0x000fc40003f1e000ULL, 0x000000160900720bULL, 0x000fe40003f3e000ULL,
0x0000000825077208ULL, 0x000fe40004000000ULL, 0x0000000916067208ULL, 0x000fe40004800000ULL,
0x000000260700720bULL, 0x000fe40003f1e000ULL, 0x000000170600720bULL, 0x000fe40003f3e000ULL,
0x0000000726087208ULL, 0x000fc40004000000ULL, 0x0000000617077208ULL, 0x000fe40004800000ULL,
0x0000002f0800720bULL, 0x000fe40003f1e000ULL, 0x000000300700720bULL, 0x000fe40003f3e000ULL,
0x000000082f097208ULL, 0x000fe40004000000ULL, 0x0000000730077208ULL, 0x000fe40004800000ULL,
0x0000002c0900720bULL, 0x000fc40003f1e000ULL, 0x000000200700720bULL, 0x000fe40003f3e000ULL,
0x000000092c067208ULL, 0x000fe40004000000ULL, 0x0000000720087208ULL, 0x000fe40004800000ULL,
0x000000270600720bULL, 0x000fe40003f1e000ULL, 0x0000001f0800720bULL, 0x000fe40003f3e000ULL,
0x0000000627077208ULL, 0x000fc40004000000ULL, 0x000000081f087208ULL, 0x000fe40004800000ULL,
0x000000280700720bULL, 0x000fe40003f1e000ULL, 0x000000210800720bULL, 0x000fe40003f3e000ULL,
0x0000000728067208ULL, 0x000fe40004000000ULL, 0x0000000821077208ULL, 0x000fe40004800000ULL,
0x000000330600720bULL, 0x000fc40003f1e000ULL, 0x000000320700720bULL, 0x000fe40003f3e000ULL,
0x0000000633067208ULL, 0x000fe40004000000ULL, 0x0000000732077208ULL, 0x000fe40004800000ULL,
0x000000310600720bULL, 0x000fe40003f1e000ULL, 0x000000220700720bULL, 0x000fe40003f3e000ULL,
0x0000000631067208ULL, 0x000fc40004000000ULL, 0x0000000722077208ULL, 0x000fe40004800000ULL,
0x000000290600720bULL, 0x000fe40003f1e000ULL, 0x000000120700720bULL, 0x000fe40003f3e000ULL,
0x0000000629097208ULL, 0x000fe40004000000ULL, 0x0000000712077208ULL, 0x000fe40004800000ULL,
0x0000002a0900720bULL, 0x000fc40003f1e000ULL, 0x000000140700720bULL, 0x000fe40003f3e000ULL,
0x000000092a097208ULL, 0x000fe40004000000ULL, 0x0000000714067208ULL, 0x000fe40004800000ULL,
0x0000002e0900720bULL, 0x000fe40003f1e000ULL, 0x000000150600720bULL, 0x000fe40003f3e000ULL,
0x000000092e087208ULL, 0x000fc40004000000ULL, 0x0000000615067208ULL, 0x000fe40004800000ULL,
0x0000002d0800720bULL, 0x000fe40003f1e000ULL, 0x000000190600720bULL, 0x000fe40003f3e000ULL,
0x000000082d087208ULL, 0x000fe40004000000ULL, 0x0000000619077208ULL, 0x000fe40004800000ULL,
0x0000002b0800720bULL, 0x000fc40003f1e000ULL, 0x0000001a0700720bULL, 0x000fe40003f3e000ULL,
0x000000082b087208ULL, 0x000fe40004000000ULL, 0x000000071a067208ULL, 0x000fe40004800000ULL,
0x000000230800720bULL, 0x000fe40003f1e000ULL, 0x0000001b0600720bULL, 0x000fe40003f3e000ULL,
0x0000000823077208ULL, 0x000fc40004000000ULL, 0x000000061b097208ULL, 0x000fe40004800000ULL,
0x000000240700720bULL, 0x000fe40003f1e000ULL, 0x0000001c0900720bULL, 0x000fe40003f3e000ULL,
0x00000007240e7208ULL, 0x000fe40004000000ULL, 0x000000091c107208ULL, 0x000fe20004800000ULL,
0x000014227f007947ULL, 0x000fec000b800000ULL, 0x0c401f000e067f89ULL, 0x0004e400000e0000ULL,
0x000000060e00720bULL, 0x008fc80003f1e000ULL, 0x0000000e06347208ULL, 0x000fe20004000000ULL,
0x000014327f007947ULL, 0x000fea000b800000ULL, 0x0c401f0010067f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a077f89ULL, 0x000e6800000e0000ULL, 0x0c401f000b087f89ULL, 0x000ea800000e0000ULL,
0x0c201f0034097f89ULL, 0x000ea200000e0000ULL, 0x000000061000720bULL, 0x008fc40003f1e000ULL,
0x000000070a00720bULL, 0x002fe40003f3e000ULL, 0x00000010060c7208ULL, 0x000fe40004000000ULL,
0x0000000a070d7208ULL, 0x000fe40004800000ULL, 0x000000080b00720bULL, 0x004fe20003f1e000ULL,
0x0c201f000c0f7f89ULL, 0x000e6600000e0000ULL, 0x0000000b08067208ULL, 0x000fe20004000000ULL,
0x0c201f000d0e7f89ULL, 0x000ea200000e0000ULL, 0x000000093400720bULL, 0x000fc60003f1e000ULL,
0x0c201f0006077f89ULL, 0x0006e200000e0000ULL, 0x0000003409087208ULL, 0x000fe40004000000ULL,
0x0000000f0c00720bULL, 0x002fe40003f3e000ULL, 0x0000000e0d00720bULL, 0x004fe40003f5e000ULL,
0x0000000c0f097208ULL, 0x000fe40004800000ULL, 0x0000000d0e0a7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b080c7820ULL, 0x008fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000c1d1d7812ULL, 0x000fc400078ec0ffULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b280f7823ULL, 0x102fe2000001080cULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001080cULL, 0x00000025000e7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b270b7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b29287823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b2a297823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b31277823ULL, 0x100fe2000001080cULL, 0x0000001300137308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b23257823ULL, 0x102fe2000001080cULL, 0x3fb8aa3b09237820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b242a7823ULL, 0x000fe2000001080cULL, 0x0000000304ff7812ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010823ULL,
0x00000026000d7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010823ULL,
0x0000002f00107308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b2b267823ULL, 0x002fe2000001080cULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b1c1c7823ULL, 0x000fe20000010823ULL,
0x000000070600720bULL, 0x004fc80003f3e000ULL, 0x0000000f00367308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b152f7823ULL, 0x000fce0000010823ULL, 0x0000001e001e7308ULL, 0x000ff00000000800ULL,
0x00000016000f7308ULL, 0x000e700000000800ULL, 0x0000001700177308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000eb00000000800ULL, 0x0000002c00347308ULL, 0x0003f00000000800ULL,
0x0000000b00357308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b2e2c7823ULL, 0x002fe2000001080cULL,
0x3fb8aa3b142e7823ULL, 0x000fcc0000010823ULL, 0x0000001f002b7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b2d0b7823ULL, 0x004fe2000001080cULL, 0x000000130e0c723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b122d7823ULL, 0x000fe20000010823ULL, 0x0000000d100e723eULL, 0x000fe400000000ffULL,
0x0000001e0f0d723eULL, 0x000fe200000000ffULL, 0x3c003c00ff1e7424ULL, 0x000fe200078e00ffULL,
0x00000017300f723eULL, 0x000fe200000000ffULL, 0x3c003c00ff1f7424ULL, 0x002fe200078e00ffULL,
0x0000003300337308ULL, 0x000e620000000800ULL, 0x000000343514723eULL, 0x000fca00000000ffULL,
0x0000001e0c10723cULL, 0x000f6400000018ffULL, 0x0000002000207308ULL, 0x000eb00000000800ULL,
0x0000002100217308ULL, 0x000fe20000000800ULL, 0x000000363316723eULL, 0x002fc400000000ffULL,
0x00000002ff337819ULL, 0x000fc80000011604ULL, 0x0000000233317810ULL, 0x000fe20007ffe0ffULL,
0x0000003200327308ULL, 0x000e620000000800ULL, 0x000000202b15723eULL, 0x004fe200000000ffULL,
0x0000000833367824ULL, 0x040fe200078e00ffULL, 0x00000001332b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000833307824ULL, 0x040fe200078e00ffULL, 0x00000008333a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000833387824ULL, 0x040fe400078e00ffULL, 0x0000002200247308ULL, 0x0005e20000000800ULL,
0xfffffff830307812ULL, 0x000fe200078ee22bULL, 0x00000008332b7824ULL, 0x000fe200078e00ffULL,
0x000000213217723eULL, 0x002fca00000000ffULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x0000000833327824ULL, 0x040fe200078e00ffULL, 0x0000001e1420723cULL, 0x024b680000001810ULL,
0xfffffff832327812ULL, 0x000fe400078ee231ULL, 0x0000002800287308ULL, 0x000e620000000800ULL,
0x0000000833137824ULL, 0x060fe200078e00ffULL, 0x0000000333107810ULL, 0x000fcc0007ffe0ffULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x0000000433117810ULL, 0x000fe40007ffe0ffULL,
0xfffffff813347812ULL, 0x000fe400078ee210ULL, 0xfffffff836367812ULL, 0x000fc600078ee211ULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x000000272810723eULL, 0x002fe200000000ffULL,
0x0000000833287824ULL, 0x040fe200078e00ffULL, 0x0000000633277810ULL, 0x000fc80007ffe0ffULL,
0xfffffff828287812ULL, 0x000fe200078ee233ULL, 0x0000002d002d7308ULL, 0x000e700000000800ULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x000000292c12723eULL, 0x004fc400000000ffULL,
0xffffffff33297810ULL, 0x000fc80007ffe0ffULL, 0xfffffff838387812ULL, 0x000fe200078ee229ULL,
0x0000002f002f7308ULL, 0x000ea20000000800ULL, 0x000000242d11723eULL, 0x002fe200000000ffULL,
0x000000083a2d7824ULL, 0x000fe200078e00ffULL, 0x0000000533247810ULL, 0x000fc80007ffe0ffULL,
0xfffffff82b2c7812ULL, 0x000fe200078ee224ULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0xfffffff82d3a7812ULL, 0x000fe400078ee23aULL, 0x0000002e2f13723eULL, 0x004fca00000000ffULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x00000008332e7824ULL, 0x000fe200078e00ffULL,
0x0000001e1020723cULL, 0x000f680000001820ULL, 0xfffffff82e2e7812ULL, 0x000fe400078ee227ULL,
0x0000002500257308ULL, 0x000ff00000000800ULL, 0x0000002a002a7308ULL, 0x000ea20000000800ULL,
0x0000000b2624723eULL, 0x002fc400000000ffULL, 0x00009000000b7811ULL, 0x000fca00078e58ffULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x0000001028287824ULL, 0x100fe400078e020bULL,
0x0000001030307824ULL, 0x100fe400078e020bULL, 0x0000001032327824ULL, 0x100fe400078e020bULL,
0x0000001034347824ULL, 0x100fe200078e020bULL, 0x0000001a001a7308ULL, 0x000e620000000800ULL,
0x000000252a26723eULL, 0x004fe200000000ffULL, 0x0000001036367824ULL, 0x000fc400078e020bULL,
0x000000102c2c7824ULL, 0x100fe400078e020bULL, 0x000000011d307824ULL, 0x040fe400078e0230ULL,
0x0000001b001b7308ULL, 0x000fe20000000800ULL, 0x000000102e2e7824ULL, 0x100fe400078e020bULL,
0x000000011d327824ULL, 0x040fe400078e0232ULL, 0x0000001038387824ULL, 0x000fe400078e020bULL,
0x000000011d347824ULL, 0x000fe200078e0234ULL, 0x0000001c001c7308ULL, 0x000ea20000000800ULL,
0x000000191a25723eULL, 0x002fe200000000ffULL, 0x0000000128197824ULL, 0x000fc400078e021dULL,
0x000000103a3a7824ULL, 0x000fe200078e020bULL, 0x00000006070b7208ULL, 0x000fe20004800000ULL,
0x000000011d367824ULL, 0x040fe200078e0236ULL, 0x0000000c19007388ULL, 0x0003e20000000800ULL,
0x000000011d2c7824ULL, 0x040fe400078e022cULL, 0x000000011d2e7824ULL, 0x040fe200078e022eULL,
0x0000000e30007388ULL, 0x0003e20000000800ULL, 0x000000011d387824ULL, 0x040fe400078e0238ULL,
0x000000011d3a7824ULL, 0x000fe200078e023aULL, 0x0000001432007388ULL, 0x0003e20000000800ULL,
0x0000001b1c27723eULL, 0x004fc600000000ffULL, 0x0000001634007388ULL, 0x0003e80000000800ULL,
0x0000001e2420723cULL, 0x020f620000001820ULL, 0x0000001036007388ULL, 0x0003e80000000800ULL,
0x000000122c007388ULL, 0x0003e80000000800ULL, 0x000000242e007388ULL, 0x0003e80000000800ULL,
0x0000002638007388ULL, 0x0003e80000000800ULL, 0x0000000d3a007388ULL, 0x0003e80000000800ULL,
0x0004000f30007388ULL, 0x0003e60000000800ULL, 0x000000ffff217224ULL, 0x020fe200078e0022ULL,
0x0004001532007388ULL, 0x0003e80000000800ULL, 0x0004001734007388ULL, 0x0003e80000000800ULL,
0x0004001136007388ULL, 0x0003e80000000800ULL, 0x000400132c007388ULL, 0x0003e80000000800ULL,
0x000400252e007388ULL, 0x0003e80000000800ULL, 0x0004002738007388ULL, 0x0003e80000000800ULL,
0x00f0000818008388ULL, 0x0003e80000000c00ULL, 0x00f2002018008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000076ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080076ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100076ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000160607810ULL, 0x000fe20007ffe0ffULL,
0x0000180076ff7f8cULL, 0x0003e6000c80043fULL, 0x000000676000720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb67000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0d7807ULL, 0x008fe40004000000ULL,
0x0001222000107802ULL, 0x000fc40000000f00ULL, 0x00000bc000007944ULL, 0x014fea0003c00000ULL,
0xffff03b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x000fe40005000000ULL,
0x0001226000107802ULL, 0x000fc40000000f00ULL, 0x00000b8000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff027224ULL, 0x000fe200078e000dULL, 0xffff041000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0026ULL, 0x000122b000117802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x014fea0003c00000ULL, 0xffff050000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0026ULL, 0x000122f000117802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x016fea0003c00000ULL, 0xffff062000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e000cULL, 0x0001234000117802ULL, 0x000fe20000000f00ULL,
0x000000ffff0d7224ULL, 0x000fc400078e000fULL, 0x00000a5000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000dULL, 0xffff0a4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e000cULL, 0x0001239000117802ULL, 0x000fc40000000f00ULL,
0x00000a0000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000dULL,
0xffff0a2000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x004fe40004000000ULL,
0x000123e000107802ULL, 0x000fc40000000f00ULL, 0x00000a0000007944ULL, 0x008fea0003c00000ULL,
0xffff29c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x000fe40005000000ULL,
0x0001242000107802ULL, 0x000fc40000000f00ULL, 0x000009c000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff057224ULL, 0x000fe200078e000dULL, 0xffff2a1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0038ULL, 0x0001247000117802ULL, 0x000fc40000000f00ULL,
0x0000092000007944ULL, 0x008fea0003c00000ULL, 0xffff2b0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0038ULL, 0x000124b000117802ULL, 0x000fc40000000f00ULL,
0x000008e000007944ULL, 0x00afea0003c00000ULL, 0xffff2c2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0002ULL, 0x0001250000117802ULL, 0x000fe20000000f00ULL,
0x000000ffff0d7224ULL, 0x000fc400078e0013ULL, 0x0000089000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000dULL, 0xffff305000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0002ULL, 0x0001255000117802ULL, 0x000fc40000000f00ULL,
0x0000084000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000dULL,
0xffff303000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x004fe40004000000ULL,
0x000125a000107802ULL, 0x000fc40000000f00ULL, 0x0000084000007944ULL, 0x018fea0003c00000ULL,
0xffff4df000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x000fe40005000000ULL,
0x000125e000107802ULL, 0x000fc40000000f00ULL, 0x0000080000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff097224ULL, 0x000fe200078e000dULL, 0xffff4e3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e003aULL, 0x0001263000117802ULL, 0x000fc40000000f00ULL,
0x0000076000007944ULL, 0x018fea0003c00000ULL, 0xffff4f2000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e003aULL, 0x0001267000117802ULL, 0x000fc40000000f00ULL,
0x0000072000007944ULL, 0x01afea0003c00000ULL, 0xffff504000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0009ULL, 0x000126c000117802ULL, 0x000fe20000000f00ULL,
0x000000ffff0d7224ULL, 0x000fc400078e000eULL, 0x000006d000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000dULL, 0xffff547000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0009ULL, 0x0001271000117802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000dULL,
0xffff545000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x004fe40004000000ULL,
0x0001276000107802ULL, 0x000fc40000000f00ULL, 0x0000068000007944ULL, 0x018fea0003c00000ULL,
0xffff727000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0d7807ULL, 0x000fe40005000000ULL,
0x000127a000107802ULL, 0x000fc40000000f00ULL, 0x0000064000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x000fe200078e000dULL, 0xffff72c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0022ULL, 0x000127f000117802ULL, 0x000fc40000000f00ULL,
0x000005a000007944ULL, 0x018fea0003c00000ULL, 0xffff73b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0022ULL, 0x0001283000117802ULL, 0x000fc40000000f00ULL,
0x0000056000007944ULL, 0x01afea0003c00000ULL, 0xffff74d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0005ULL, 0x0001288000117802ULL, 0x000fe20000000f00ULL,
0x000000ffff0d7224ULL, 0x000fc400078e0012ULL, 0x0000051000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff077224ULL, 0x004fe200078e000dULL, 0xffff796000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0005ULL, 0x000128d000117802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff067224ULL, 0x004fe200078e000dULL,
0xffff794000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x00012920000c7802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0007ULL, 0xffffeba000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x006fe200078e0010ULL, 0x00012980000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x010fea0003c00000ULL,
0x000000071000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x000129e0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001007107208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x000000070a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000bULL,
0x00012a40000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a070a7208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x000000070b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0034ULL,
0x00012aa0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000b07067208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x000000073400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0010ULL,
0x00012b00000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000003407087208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x000000071000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x00012b60000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001007097208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x000000070a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0006ULL,
0x00012bc0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a070a7208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffea7000007947ULL, 0x000fea000383ffffULL, 0x0180000003007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000000300008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff057807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000005ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff03ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000003027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000005ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000300007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x006fc800078e00ffULL,
0xfffed2b002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000003600007348ULL, 0x000fe80003800000ULL, 0x0c00000f0e077389ULL, 0x0002a200000e0011ULL,
0xfffed2700c007950ULL, 0x000fea0003c3ffffULL, 0x0000007800007348ULL, 0x000fe80003800000ULL,
0x0000000d100d7389ULL, 0x0002a400000e0079ULL, 0x000000ffff107224ULL, 0x002fc400078e0011ULL,
0x00000000ff117424ULL, 0x000fc800078e00ffULL, 0xfffed22010007950ULL, 0x000fea0003c3ffffULL,
0x000000010d00780cULL, 0x000fe20003f45070ULL, 0x00000000ff117424ULL, 0x000fe200078e00ffULL,
0x0000007700007348ULL, 0x000ff60003800000ULL, 0x00000000000d7806ULL, 0x000fc800050e0100ULL,
0x000000770d0d7212ULL, 0x000fe200078ec0ffULL, 0xfffed1c010007950ULL, 0x000fec0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005f4ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000750ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f0ULL, 0x0000000000000390ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d80ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e40ULL, 0x00000000000007bcULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001600ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001610ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000016a0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000016a4ULL, 0x00000000000001c0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000012f00ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014780ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x00000000000147d0ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000014b50ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000016a0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000130e0ULL, 0x00000000000130e0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014780ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000014b50ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_16_sm_89_cubin_len = 85040;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
