/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001adc0ULL, 0x000000000001aa40ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x746e695f5f240068ULL,
0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL, 0x66625f636e79736cULL,
0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL, 0x5f30376d735f6164ULL,
0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL, 0x5f5f245f335f6c61ULL,
0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL, 0x2e616c65722e0074ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x766e2e0066754265ULL,
0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL, 0x65642e006d617261ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x00000000006e6f69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c000100000377ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000003c5ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000040bULL, 0x0000000000018e20ULL,
0x0000000000000180ULL, 0x000b00220000043eULL, 0x0000000000018fa0ULL, 0x0000000000000040ULL,
0x000b002200000469ULL, 0x0000000000018fe0ULL, 0x0000000000000050ULL, 0x000b002200000493ULL,
0x0000000000019030ULL, 0x0000000000000150ULL, 0x000a000300000501ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0007000300000551ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000019180ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00018e2000000000ULL,
0x0000040400000000ULL, 0x810c000001640400ULL, 0x0062180400288080ULL, 0x0000000000000000ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x00018e2000000000ULL,
0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8408288080830828ULL, 0x2880808708288080ULL,
0x808d082880808c08ULL, 0x082880808e082880ULL, 0x8080a2082880808fULL, 0xa508288080a30828ULL,
0x288080a808288080ULL, 0x80f108288080aa08ULL, 0x08288080f8082880ULL, 0x8082801628808088ULL,
0x0000000000031028ULL, 0x2880808892000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x000000f000000000ULL, 0x00018fa000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8408288080830828ULL, 0x2880808808288080ULL,
0x808d082880808c08ULL, 0x082880808e082880ULL, 0x8080a2082880808fULL, 0xa508288080a30828ULL,
0x288080a908288080ULL, 0x80f108288080aa08ULL, 0x08288080f8082880ULL, 0x80828016288080a8ULL,
0x0000000000031028ULL, 0x288080a892000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL,
0x000001b000000000ULL, 0x00018fe000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL,
0x80aa288080a80900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8408288080830828ULL, 0x2880808808288080ULL, 0x808d082880808c08ULL, 0x082880808e082880ULL,
0x8080a2082880808fULL, 0xa508288080a30828ULL, 0x288080a808288080ULL, 0x80f108288080aa08ULL,
0x08288080f8082880ULL, 0x80828016288080a9ULL, 0x0000000000031028ULL, 0x288080a992000000ULL,
0x0000000000002200ULL, 0x0000002cffffffffULL, 0x0000028000000000ULL, 0x0001903000000000ULL,
0x0000015000000000ULL, 0x0000180400000000ULL, 0x80aa288080a90900ULL, 0x0000000000002880ULL,
0x0000001900082f04ULL, 0x00082304000000deULL, 0x0000000000000015ULL, 0x0000001500081204ULL,
0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL,
0x0000000000000019ULL, 0x0000001900081204ULL, 0x0008110400000000ULL, 0x0000000000000019ULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0060016000000016ULL, 0x000c170400601903ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040021f000ULL,
0x0048000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040081f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL,
0x00000b0000043104ULL, 0xffffffff019c2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x00000100019c2804ULL, 0x00000580000002d0ULL, 0x00002960000028d0ULL,
0x00002be000002a70ULL, 0x00002eb000002d50ULL, 0x0000337000003330ULL, 0x000033b000003380ULL,
0x0000562000005590ULL, 0x000058b000005740ULL, 0x00005b8000005a20ULL, 0x0000604000006000ULL,
0x0000608000006050ULL, 0x0000810000008060ULL, 0x0000839000008220ULL, 0x0000866000008500ULL,
0x00008b0000008ac0ULL, 0x00008b4000008b10ULL, 0x0000ab900000aaf0ULL, 0x0000ae100000aca0ULL,
0x0000b0e00000af80ULL, 0x0000b5a00000b560ULL, 0x0000b5e00000b5b0ULL, 0x0000ca700000ca60ULL,
0x0000ca900000ca80ULL, 0x000165f0000165b0ULL, 0x0001661000016600ULL, 0x0001668000016660ULL,
0x000166b0000166a0ULL, 0x00017a8000017a20ULL, 0x00017b5000017af0ULL, 0x00017c1000017bb0ULL,
0x00017cf000017c80ULL, 0x00017dd000017d60ULL, 0x00017e9000017e30ULL, 0x00017f6000017f00ULL,
0x0001802000017fc0ULL, 0x0001810000018090ULL, 0x000181e000018170ULL, 0x000182a000018240ULL,
0x0001837000018310ULL, 0x00018430000183d0ULL, 0x00018510000184a0ULL, 0x000185f000018580ULL,
0x000186b000018650ULL, 0x0001878000018720ULL, 0x00018840000187e0ULL, 0x00018920000188b0ULL,
0x00018a0000018990ULL, 0x00018b0000018a80ULL, 0x00018c0000018b80ULL, 0x00018d0000018c80ULL,
0x00018e0000018d80ULL, 0x000003c004403904ULL, 0x0001a600000000ffULL, 0x00000400003f0100ULL,
0x0001a6080000000dULL, 0x000004f0003f0120ULL, 0x0001a6880000000dULL, 0x00000510003f0120ULL,
0x0001a6a80000000dULL, 0x00000540003f0120ULL, 0x0001a6c80000000dULL, 0x00000b20003f0120ULL,
0x0001a600000000ffULL, 0x00000d10003f0107ULL, 0x0000000400000006ULL, 0x00000dc0003f0102ULL,
0x0000000000000006ULL, 0x00001730003f0101ULL, 0x00000000000000ffULL, 0x000017b000040107ULL,
0x00000000000000ffULL, 0x0000181000040101ULL, 0x0000002000000006ULL, 0x000019c0003f0101ULL,
0x0001a6cc00000008ULL, 0x00001b90003f0105ULL, 0x0001a6cc00000008ULL, 0x000024d0003f0105ULL,
0x0001a6b00000000aULL, 0x00002580003f0107ULL, 0x0001a6b00000000aULL, 0x000025e0003f0101ULL,
0x0001a60800000022ULL, 0x00002600003f0101ULL, 0x0001a60c00000022ULL, 0x000027d0003f0105ULL,
0x0001a60c00000022ULL, 0x00003060003f0105ULL, 0x0001a6ac0000000aULL, 0x00003250003f0105ULL,
0x0001a6ac0000000aULL, 0x00004750003f0105ULL, 0x000000000000006cULL, 0x000047b0003f0101ULL,
0x0001a68800000025ULL, 0x000047e0003f0101ULL, 0x0000000400000014ULL, 0x000049a0003f0105ULL,
0x0000000400000014ULL, 0x00005190003f0105ULL, 0x0000000000000010ULL, 0x00005270003f0107ULL,
0x0000000000000010ULL, 0x000052d0003f0101ULL, 0x0001a62800000022ULL, 0x000052f0003f0101ULL,
0x0001a62c00000022ULL, 0x000054c0003f0105ULL, 0x0001a62c00000022ULL, 0x00005d70003f0105ULL,
0x0001a6b40000006eULL, 0x00005f40003f0105ULL, 0x0001a6b40000006eULL, 0x00007200003f0105ULL,
0x000000000000006eULL, 0x00007260003f0101ULL, 0x0001a69000000028ULL, 0x00007290003f0101ULL,
0x0000000400000014ULL, 0x00007450003f0105ULL, 0x0000000400000014ULL, 0x00007c50003f0105ULL,
0x00000008000000ffULL, 0x00007d4000040107ULL, 0x0001a6b00000002aULL, 0x00007da0003f0101ULL,
0x0001a64800000022ULL, 0x00007dc0003f0101ULL, 0x0001a64c00000022ULL, 0x00007f90003f0105ULL,
0x0001a64c00000022ULL, 0x00008830003f0105ULL, 0x0000000400000010ULL, 0x00008a00003f0105ULL,
0x0000000400000010ULL, 0x00009ca0003f0105ULL, 0x0000000000000014ULL, 0x00009d00003f0101ULL,
0x0001a69800000002ULL, 0x00009d30003f0101ULL, 0x0000000400000014ULL, 0x00009ef0003f0105ULL,
0x0000000400000014ULL, 0x0000a750003f0105ULL, 0x00000000000000ffULL, 0x0000a7e000040107ULL,
0x0000000000000010ULL, 0x0000a840003f0101ULL, 0x0001a66800000006ULL, 0x0000a870003f0101ULL,
0x0001a66c00000006ULL, 0x0000aa40003f0105ULL, 0x0001a66c00000006ULL, 0x0000b2c0003f0105ULL,
0x0001a6b400000008ULL, 0x0000b490003f0105ULL, 0x0001a6b400000008ULL, 0x0000c810003f0105ULL,
0x0000000000000014ULL, 0x0000c890003f0101ULL, 0x0000000000000006ULL, 0x0000e600003f0101ULL,
0x0001a600000000ffULL, 0x0000ff00003f0101ULL, 0x0001a604000000ffULL, 0x000100d0003f0105ULL,
0x0001a604000000ffULL, 0x00010450003f0105ULL, 0x0001a600000000ffULL, 0x00010480003f0101ULL,
0x0001a604000000ffULL, 0x00010640003f0105ULL, 0x0001a604000000ffULL, 0x00013ab0003f0105ULL,
0x0000000000000064ULL, 0x00013bc0003f0101ULL, 0x0000000400000064ULL, 0x00013d90003f0105ULL,
0x0000000400000064ULL, 0x00017860003f0105ULL, 0x0000000000000062ULL, 0x000178c0003f0101ULL,
0x0000000800000062ULL, 0x00017920003f0101ULL, 0x0000001000000062ULL, 0x00017990003f0101ULL,
0x0000001800000062ULL, 0x00053803003f0101ULL, 0x0000d99000301c04ULL, 0x0000dba00000d9c0ULL,
0x0000de600000dd00ULL, 0x0000e1200000dfc0ULL, 0x0000e4100000e280ULL, 0x000106a00000e510ULL,
0x00000401000179e0ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000032cULL, 0x0000001900000002ULL,
0x000000000000025cULL, 0x0000001900000002ULL, 0x000000000000019cULL, 0x0000001900000002ULL,
0x00000000000000ccULL, 0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL,
0x0000000000000303ULL, 0x0000001900000002ULL, 0x0000000000000233ULL, 0x0000001900000002ULL,
0x0000000000000173ULL, 0x0000001900000002ULL, 0x00000000000000a8ULL, 0x0000001900000002ULL,
0x000000000001a700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0e7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000767919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000b7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000e807a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000f220000002100ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL,
0x00000005ff207819ULL, 0x010fc80000011609ULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x00001fff20207589ULL, 0x000fe200000e0000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x010fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003077a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a07ULL, 0x0000040003007624ULL, 0x000fca00078e020eULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff07aa12ULL, 0x000fc800078e33ffULL,
0x0000000700007306ULL, 0x000e620000209000ULL, 0x000000ff0700720cULL, 0x000fce0003f85070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000307047224ULL, 0x010fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x0000000000047919ULL, 0x000ee40000002200ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000007603197227ULL, 0x004fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a19ULL,
0x0000000007007224ULL, 0x000fca00078e0276ULL, 0x000000070000720cULL, 0x000fe20003f46070ULL,
0x000001000b027a24ULL, 0x008fe400078e0204ULL, 0x00001fff0b0b7589ULL, 0x000e6400000e0000ULL,
0x00000000020d7a24ULL, 0x000fca00078e0209ULL, 0x000000ff0d00720cULL, 0x000fc60003fa5270ULL,
0x0000000100002824ULL, 0x000fe200078e0a07ULL, 0x0000000119192810ULL, 0x000fe40007ffe0ffULL,
0x0000000f0d00780cULL, 0x040fe40003f24070ULL, 0x000000070000720cULL, 0x000fe40003f66070ULL,
0x0000007f0d00780cULL, 0x040fe40003f04070ULL, 0x000000030d00780cULL, 0x000fe20003f44070ULL,
0x3fffff80ff02d424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03d424ULL, 0x000fc800078e00ffULL,
0x3fffffc0ff049424ULL, 0x000fe400078e00ffULL, 0x0000000119193810ULL, 0x000fe20007ffe0ffULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x00000007ff19c212ULL, 0x000fe200078e33ffULL,
0x01a60002ff00d388ULL, 0x0005e20000000a00ULL, 0xff317217ff0a8424ULL, 0x000fe200078e00ffULL,
0x000000010d00780cULL, 0x000fe20003f64070ULL, 0x3fffff80ff06a424ULL, 0x000fe200078e00ffULL,
0x01a608040d009388ULL, 0x0007e20000008a00ULL, 0x000000ffff007224ULL, 0x000fe200078e0a19ULL,
0x00005a0019757a19ULL, 0x000fc400000006ffULL, 0x01a4000a0d008388ULL, 0x000fe20000004800ULL,
0x0000000007767224ULL, 0x000fe400078e0276ULL, 0x3fffff60ff02a424ULL, 0x004fe400078e00ffULL,
0x0000002076007824ULL, 0x000fe400078e00ffULL, 0x7fffff60ff03a424ULL, 0x000fe200078e00ffULL,
0x0000000000047919ULL, 0x008ea20000002700ULL, 0x7fffff80ff07a424ULL, 0x000fe200078e00ffULL,
0x0000000400057c10ULL, 0x040fe2000fffe1ffULL, 0x3fffffc0ff08b424ULL, 0x000fe200078e00ffULL,
0x0000000400007c0cULL, 0x000fe2000bf03070ULL, 0x7fffffc0ff09b424ULL, 0x000fe200078e00ffULL,
0x0000002005057817ULL, 0x000fe20003800000ULL, 0x01a688020d00a388ULL, 0x0005e60000008a00ULL,
0x000000ff05747207ULL, 0x000fe20000000000ULL, 0x01a6a8060d00a388ULL, 0x000fe20000008a00ULL,
0x000000040b057824ULL, 0x002fc400078e0220ULL, 0x000000207400780cULL, 0x000fe20003f05270ULL,
0x01a6c8080d00b388ULL, 0x000fe20000008a00ULL, 0x0000000405057824ULL, 0x000fe400078e00ffULL,
0x0000580004027a24ULL, 0x004fc800078e02ffULL, 0x0000008002027224ULL, 0x000fe200078e0275ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x00000000001f7919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000000574067217ULL, 0x000fe20007800000ULL, 0x00005a0000057ab9ULL, 0x000fc40000000800ULL,
0x0000000504047299ULL, 0x000fe4000800063fULL, 0x0000000106067824ULL, 0x000fe200078e0a05ULL,
0x00000004ff037819ULL, 0x002fc8000001161fULL, 0x00000002030a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105087824ULL, 0x000fe200078e0203ULL, 0x000000060300720cULL, 0x080fe40003f06070ULL,
0x000000060a00720cULL, 0x000fe20003f26070ULL, 0x00000001050c7824ULL, 0x000fe400078e020aULL,
0x0000000100077824ULL, 0x040fe400078e0208ULL, 0x00000001000d7824ULL, 0x000fe400078e020cULL,
0x000000101f057824ULL, 0x000fe200078e00ffULL, 0x0000000407097c12ULL, 0x000fe2000f8e30ffULL,
0x00000001080a7824ULL, 0x000fe200078e021fULL, 0x000000040d0f7c12ULL, 0x000fc4000f8e30ffULL,
0x00005a00ff077a19ULL, 0x000fe20000011607ULL, 0x0000000102097824ULL, 0x040fe200078e0209ULL,
0x00005a00ff0d7a19ULL, 0x000fe2000001160dULL, 0x00000001020f7824ULL, 0x000fe400078e020fULL,
0x0000008007027224ULL, 0x080fe200078e0209ULL, 0x000000f005097812ULL, 0x000fe200078ec0ffULL,
0x000000800d077224ULL, 0x000fe400078e020fULL, 0x0000010002027825ULL, 0x000fc800078e00ffULL,
0x0000010007067825ULL, 0x000fe200078e00ffULL, 0x0000000902027212ULL, 0x000fc600078efcffULL,
0x00000010080d7824ULL, 0x000fe200078e00ffULL, 0x0000000906067212ULL, 0x000fe200078efcffULL,
0x000000010c087824ULL, 0x000fe200078e021fULL, 0x00005e0002027a10ULL, 0x000fe20007f5e0ffULL,
0x000000100c097824ULL, 0x000fe200078e00ffULL, 0xfffffff00d0a7812ULL, 0x000fe400078ee20aULL,
0x00005e0006067a10ULL, 0x000fe40007f7e0ffULL, 0xfffffff009087812ULL, 0x000fe200078ee208ULL,
0x000000100a097824ULL, 0x000fe200078e00ffULL, 0x00005f0003037a10ULL, 0x000fc400017fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20001ffe4ffULL, 0x00000010080d7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000c101c48ULL,
0x00000000060d7faeULL, 0x0003e2000c901c48ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x00000000001f7919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fc40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x000000051f087211ULL, 0x002fc800078fe0ffULL, 0x00000002080a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100037824ULL, 0x000fe400078e0208ULL, 0x0000000108097824ULL, 0x000fe400078e021fULL,
0x0000000100067824ULL, 0x000fe200078e020aULL, 0x0000000403057c12ULL, 0x000fe2000f8e30ffULL,
0x00000010080c7824ULL, 0x000fe200078e00ffULL, 0x00005a00ff037a19ULL, 0x000fe20000011603ULL,
0x000000010a087824ULL, 0x000fe200078e021fULL, 0x0000000406077c12ULL, 0x000fe2000f8e30ffULL,
0x0000000102057824ULL, 0x000fe200078e0205ULL, 0xfffffff00c097812ULL, 0x000fc600078ee209ULL,
0x0000000102027824ULL, 0x000fe200078e0207ULL, 0x00005a00ff077a19ULL, 0x000fe20000011606ULL,
0x0000008003037224ULL, 0x080fe400078e0205ULL, 0x000000101f057824ULL, 0x000fe400078e00ffULL,
0x0000008007077224ULL, 0x000fe400078e0202ULL, 0x0000010003027825ULL, 0x000fe200078e00ffULL,
0x000000f0050d7812ULL, 0x000fc600078ec0ffULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x0000000d02027212ULL, 0x000fc600078efcffULL, 0x0000001009097824ULL, 0x000fe200078e00ffULL,
0x0000000d06067212ULL, 0x000fe200078efcffULL, 0x000000100a0d7824ULL, 0x000fe200078e00ffULL,
0x00005e0002027a10ULL, 0x000fe40007f1e0ffULL, 0x00005e0006067a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00d087812ULL, 0x000fe400078ee208ULL, 0x00005f0003037a10ULL, 0x000fe400007fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20000ffe4ffULL, 0x00000010080d7824ULL, 0x000fc400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000b901c48ULL,
0x00000000060d7faeULL, 0x0003e4000b901c48ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x0000000000067806ULL, 0x000fe200038e0000ULL, 0x00000004ff097424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000600027300ULL, 0x000e7000000e0000ULL,
0x0000000600077309ULL, 0x000ea20000000000ULL, 0x000000030200720cULL, 0x002fe20003f02070ULL,
0x0000660004027625ULL, 0x000fc800078e0009ULL, 0x000000ffff077224ULL, 0x004fd000078e0a07ULL,
0x01a60407ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01a60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008021e7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000007f1e1d7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff1e087810ULL, 0x000fc40007ffe0ffULL, 0x00000007ff1d7819ULL, 0x000fe4000001161dULL,
0x00000008ff1c7819ULL, 0x000fca0000011608ULL, 0x0000d8c000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1b7819ULL, 0x000fe20000011620ULL, 0x00000003ff077424ULL, 0x002fe200078e00ffULL,
0x0001a68820067811ULL, 0x000fe200078e18ffULL, 0xffffffffff247424ULL, 0x000fe200078e00ffULL,
0x01ffffff1b1b7812ULL, 0x000fc800078ec0ffULL, 0x0000001d1b00720cULL, 0x000fda0003f06070ULL,
0x0000000204008824ULL, 0x000fe400078e00ffULL, 0x00006800ff038624ULL, 0x000fc800078e00ffULL,
0x0000680000008624ULL, 0x000fc800078e0203ULL, 0x000000011b008824ULL, 0x000fe200078e0200ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040706ff738cULL, 0x0003e20000000000ULL,
0x0000640000028625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000802248981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0800780cULL, 0x000fe20003f04070ULL,
0x0000008019197824ULL, 0x000fe200078e00ffULL, 0x00000001ff1a7819ULL, 0x000fe20000011620ULL,
0x0000000006ff7f8cULL, 0x0007e2000c80043fULL, 0x0000000120007812ULL, 0x000fc600078ec0ffULL,
0x000000201a777824ULL, 0x000fca00078e00ffULL, 0x0000006019077812ULL, 0x002fe200078ef877ULL,
0x0000590024087a24ULL, 0x004fc800078e02ffULL, 0x0000008008137824ULL, 0x000fe200078e00ffULL,
0x0000040000000947ULL, 0x000fea0003800000ULL, 0x0000001000037824ULL, 0x008fe200078e00ffULL,
0x000000771e007217ULL, 0x000fe40007800000ULL, 0x00000003ff027819ULL, 0x000fe4000001161fULL,
0x00006200130f7a11ULL, 0x000fe200078838ffULL, 0x0000000100007824ULL, 0x000fe200078e0a77ULL,
0x0000000402097810ULL, 0x040fe20007ffe0ffULL, 0x0000000103067824ULL, 0x000fe200078e0202ULL,
0x0000000c020a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000300007217ULL, 0x000fe20007800000ULL,
0x0000000106087824ULL, 0x040fe200078e021fULL, 0x0000630013137a11ULL, 0x000fe200020f3cffULL,
0x00000008060b7824ULL, 0x000fe400078e00ffULL, 0x0000000100007824ULL, 0x000fe400078e0a03ULL,
0x0000000103107824ULL, 0x000fe200078e020aULL, 0xfffffff80b0c7812ULL, 0x000fe400078ee208ULL,
0x0000000802087810ULL, 0x000fe20007ffe0ffULL, 0x00000001100d7824ULL, 0x000fe200078e021fULL,
0x000000000200720cULL, 0x080fe20003f66070ULL, 0x0000000107027824ULL, 0x000fe200078e0206ULL,
0x000000000800720cULL, 0x080fe20003f26070ULL, 0x0000000103067824ULL, 0x000fe200078e0209ULL,
0x000000000900720cULL, 0x080fe20003f46070ULL, 0x0000000103087824ULL, 0x000fe200078e0208ULL,
0x000000000a00720cULL, 0x000fe20003f06070ULL, 0x0000000106037824ULL, 0x000fc400078e021fULL,
0x00000008060e7824ULL, 0x000fe400078e00ffULL, 0x0000000108097824ULL, 0x040fe400078e021fULL,
0x0000000808127824ULL, 0x000fe200078e00ffULL, 0xfffffff80e007812ULL, 0x000fe200078ee203ULL,
0x0000008002027825ULL, 0x000fc600078e00ffULL, 0xfffffff8120e7812ULL, 0x000fe200078ee209ULL,
0x0000000107067824ULL, 0x040fe200078e0206ULL, 0x0000007002027812ULL, 0x000fe200078ef805ULL,
0x0000000107087824ULL, 0x040fe400078e0208ULL, 0x00000001070a7824ULL, 0x000fe200078e0210ULL,
0x000000020f027210ULL, 0x000fe20007f9e0ffULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000007006067812ULL, 0x000fc600078ef805ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000007008087812ULL, 0x000fc600078ef805ULL,
0x0000000810107824ULL, 0x000fe200078e00ffULL, 0x000000700a0a7812ULL, 0x000fe200078ef805ULL,
0x0000000103037824ULL, 0x000fe200020e0613ULL, 0x000160001a057811ULL, 0x000fe400078e68ffULL,
0x0000000f06067210ULL, 0x080fe40007f9e0ffULL, 0x0000000f08087210ULL, 0x080fe20007fbe0ffULL,
0x000000100e117824ULL, 0x000fe200078e0205ULL, 0xfffffff810107812ULL, 0x000fe200078ee20dULL,
0x000000100c0d7824ULL, 0x100fe200078e0205ULL, 0x0000000f0a0a7210ULL, 0x000fe20007fde0ffULL,
0x00000010000f7824ULL, 0x000fc400078e0205ULL, 0x0000000107077824ULL, 0x100fe200020e0613ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020d7faeULL, 0x0003e2000d901c48ULL,
0x0000000109097824ULL, 0x000fe400028e0613ULL, 0x0000001010057824ULL, 0x000fe200078e0205ULL,
0x00000000060f7faeULL, 0x0003e2000d101c48ULL, 0x000000010b0b7824ULL, 0x000fc600030e0613ULL,
0x0000000008117faeULL, 0x0003e8000c901c48ULL, 0x000000000a057faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001000007824ULL, 0x008fe200078e00ffULL,
0x0000620013117a11ULL, 0x000fe400078038ffULL, 0x000160001a157811ULL, 0x000fe400078e68ffULL,
0x000000001f007211ULL, 0x000fc400078fe8ffULL, 0x0000630013137a11ULL, 0x000fe400000f3cffULL,
0x0000000400067810ULL, 0x040fe20007ffe0ffULL, 0x0000000100027824ULL, 0x140fe200078e021fULL,
0x0000000800087810ULL, 0x040fe20007ffe0ffULL, 0x0000000800037824ULL, 0x000fe400078e00ffULL,
0x00000008060a7824ULL, 0x000fe400078e00ffULL, 0x0000000108097824ULL, 0x100fe200078e021fULL,
0xfffffff8030c7812ULL, 0x000fe200078ee202ULL, 0x0000000106037824ULL, 0x000fc400078e021fULL,
0x0000000107027824ULL, 0x000fe200078e0200ULL, 0x0000000c00007810ULL, 0x000fe20007ffe0ffULL,
0x00000008080e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a0d7812ULL, 0x000fe200078ee203ULL,
0x0000008002027825ULL, 0x000fc600078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL,
0x0000000107067824ULL, 0x040fe200078e0206ULL, 0x0000007002027812ULL, 0x000fe200078ef805ULL,
0x0000000107087824ULL, 0x040fe400078e0208ULL, 0x00000001070a7824ULL, 0x000fe200078e0200ULL,
0x0000000211027210ULL, 0x000fe20007f1e0ffULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000007006067812ULL, 0x000fc600078ef805ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000007008087812ULL, 0x000fc600078ef805ULL,
0x00000001000f7824ULL, 0x000fe200078e021fULL, 0x000000700a057812ULL, 0x000fe200078ef805ULL,
0x0000000800007824ULL, 0x000fe200078e00ffULL, 0x0000000811087210ULL, 0x000fe20007f3e0ffULL,
0x0000000103037824ULL, 0x000fe200000e0613ULL, 0x0000000611067210ULL, 0x000fe20007f1e0ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0215ULL, 0xfffffff800007812ULL, 0x000fe200078ee20fULL,
0x000000100e0f7824ULL, 0x100fe200078e0215ULL, 0x00000005110a7210ULL, 0x000fe20007f5e0ffULL,
0x000000100c057824ULL, 0x000fc400078e0215ULL, 0x0000000107077824ULL, 0x100fe400000e0613ULL,
0x0000000109097824ULL, 0x000fe200008e0613ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000b901c48ULL, 0x0000001000117824ULL, 0x000fe400078e0215ULL,
0x000000010b0b7824ULL, 0x000fe200010e0613ULL, 0x00000000060d7faeULL, 0x0003e8000b901c48ULL,
0x00000000080f7faeULL, 0x0003e8000b901c48ULL, 0x000000000a117faeULL, 0x0003e4000b901c48ULL,
0x000000001a0473c2ULL, 0x000ea200000e0000ULL, 0x000000ff1c00720cULL, 0x000fe20003f05270ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x0001a6a81a067811ULL, 0x002fe200078e18ffULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000687805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0001a6a804047891ULL, 0x004fe2000f8e203fULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3d7224ULL, 0x000fca00078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff027f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200006067f8cULL, 0x000ea2000c80043fULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000b01000008947ULL, 0x000fea0003800000ULL,
0x000000101a157824ULL, 0x000fe200078e00ffULL, 0x00000002ff177819ULL, 0x000fe20000011620ULL,
0x0000000204187824ULL, 0x000fc400078e00ffULL, 0x00006800ff057624ULL, 0x000fe200078e00ffULL,
0x0000001015157812ULL, 0x000fe200078ee2ffULL, 0x000000ffff007224ULL, 0x002fe400078e0003ULL,
0x000000ffff037224ULL, 0x004fe400078e0007ULL, 0x0000680018187624ULL, 0x000fe400078e0205ULL,
0xff317217ff027424ULL, 0x000fe400078e00ffULL, 0x000000ffff167224ULL, 0x000fc400078e00ffULL,
0x000000ffff6b7224ULL, 0x000fc400078e00ffULL, 0x000000ffff0a7224ULL, 0x01afca00078e00ffULL,
0x0000000000047805ULL, 0x000fc40000015200ULL, 0x0000000420067824ULL, 0x000fca00078e00ffULL,
0xfffffff806087812ULL, 0x000fc800078ec0ffULL, 0x0001a6c808147810ULL, 0x000fe20007ffe0ffULL,
0x01a6cc0008067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000906067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a6cc0008067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001020037824ULL, 0x000fe200078e00ffULL,
0x0000000116077810ULL, 0x000fe20007ffe0ffULL, 0x0000590024247a24ULL, 0x000fc600078e02ffULL,
0xffffffe003057812ULL, 0x000fe200078ec0ffULL, 0x0000008024277824ULL, 0x000fe200078e00ffULL,
0x0000001c0700720cULL, 0x000fc60003f46070ULL, 0x0000010016057824ULL, 0x000fca00078e0205ULL,
0x0000004005057810ULL, 0x000fc80007ffe0ffULL, 0x0000006005047812ULL, 0x000fca00078ec0ffULL,
0x00000001190b7824ULL, 0x000fe200078e0204ULL, 0x000004200000a947ULL, 0x000fea0003800000ULL,
0x0000001003047812ULL, 0x000fe200078ec0ffULL, 0x000000101f087824ULL, 0x000fe200078e00ffULL,
0x000000051e037217ULL, 0x000fe40007800000ULL, 0x00000003ff077819ULL, 0x000fe4000001161fULL,
0x0000007008257812ULL, 0x000fe200078ec0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a05ULL,
0x0000000407087810ULL, 0x040fe20007ffe0ffULL, 0x0000000107067824ULL, 0x040fe200078e0204ULL,
0x0000000807097810ULL, 0x000fc40007ffe0ffULL, 0x0000000403037217ULL, 0x000fe20007800000ULL,
0x0000000106057824ULL, 0x040fe200078e021fULL, 0x0000000c070a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000806107824ULL, 0x000fe200078e00ffULL, 0x0000620027237a11ULL, 0x000fe200078c38ffULL,
0x0000000103037824ULL, 0x100fe400078e0a04ULL, 0x000000010a247824ULL, 0x000fe200078e0204ULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x000000010b057824ULL, 0x000fe200078e0206ULL,
0x000000030800720cULL, 0x0c0fe20003f86070ULL, 0x0000000108067824ULL, 0x100fe200078e0204ULL,
0x000000030700720cULL, 0x080fe20003fa6070ULL, 0x0000000109087824ULL, 0x040fe200078e0204ULL,
0x000000030a00720cULL, 0x080fe20003f06070ULL, 0x0000000106077824ULL, 0x040fe200078e021fULL,
0x000000030900720cULL, 0x000fe20003f66070ULL, 0x0000000806127824ULL, 0x000fe200078e00ffULL,
0x0000630027277a11ULL, 0x000fe200030f3cffULL, 0x0000008005047825ULL, 0x000fc600078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x000000010b067824ULL, 0x040fe200078e0206ULL,
0x00000025040a7212ULL, 0x000fe200078efcffULL, 0x000000010b097824ULL, 0x000fe400078e0208ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000000a230a7210ULL, 0x000fc60007fde0ffULL,
0x0000000108037824ULL, 0x000fe200078e021fULL, 0x0000002506067212ULL, 0x000fe200078efcffULL,
0x0000000808227824ULL, 0x000fe400078e00ffULL, 0x0000008009087825ULL, 0x000fc600078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee203ULL, 0x000000010b047824ULL, 0x000fe200078e0224ULL,
0x0000002508087212ULL, 0x000fe200078efcffULL, 0x00000001050b7824ULL, 0x000fe200030e0627ULL,
0x0000002306067210ULL, 0x000fe20007fde0ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x000170001a037811ULL, 0x000fc600078e68ffULL, 0x0000000107077824ULL, 0x000fe200030e0627ULL,
0x0000002308087210ULL, 0x000fe20007fde0ffULL, 0x0000000124137824ULL, 0x000fe200078e021fULL,
0x0000002504047212ULL, 0x000fe200078efcffULL, 0x0000000824247824ULL, 0x000fe400078e00ffULL,
0x0000000109097824ULL, 0x000fe200030e0627ULL, 0x0000002304047210ULL, 0x000fe20007fde0ffULL,
0x0000001012237824ULL, 0x000fe200078e0203ULL, 0xfffffff824247812ULL, 0x000fe200078ee213ULL,
0x0000001010137824ULL, 0x000fc400078e0203ULL, 0x0000001022257824ULL, 0x100fe400078e0203ULL,
0x0000001024037824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a137faeULL, 0x0003e2000e901c48ULL, 0x0000000105057824ULL, 0x000fc600030e0627ULL,
0x0000000006237faeULL, 0x0003e8000e101c48ULL, 0x0000000008257faeULL, 0x0003e8000d901c48ULL,
0x0000000004037faeULL, 0x0003e2000c101c48ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001003047812ULL, 0x000fe200078ec0ffULL, 0x000000101f097824ULL, 0x000fe200078e00ffULL,
0x0000620027257a11ULL, 0x000fc400078038ffULL, 0x000000041f047211ULL, 0x000fe400078fe8ffULL,
0x0000007009237812ULL, 0x000fe400078ec0ffULL, 0x0000000404067810ULL, 0x040fe20007ffe0ffULL,
0x0000000104037824ULL, 0x140fe200078e021fULL, 0x0000000804087810ULL, 0x040fe20007ffe0ffULL,
0x00000008040a7824ULL, 0x000fe200078e00ffULL, 0x0000630027277a11ULL, 0x000fe200000f3cffULL,
0x0000000106057824ULL, 0x000fe200078e021fULL, 0x000170001a297811ULL, 0x000fe200078e68ffULL,
0x0000000806107824ULL, 0x000fe200078e00ffULL, 0xfffffff80a037812ULL, 0x000fe200078ee203ULL,
0x0000000108077824ULL, 0x000fe200078e021fULL, 0x0000000c040a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000808127824ULL, 0x000fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee205ULL,
0x000000010b057824ULL, 0x000fc400078e0204ULL, 0x000000010b067824ULL, 0x000fe200078e0206ULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x0000008005047825ULL, 0x000fc800078e00ffULL,
0x000000010b087824ULL, 0x040fe200078e0208ULL, 0x0000002304047212ULL, 0x000fe200078efcffULL,
0x000000010b0b7824ULL, 0x000fe400078e020aULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000000425047210ULL, 0x000fc60007f1e0ffULL, 0x000000010a137824ULL, 0x000fe200078e021fULL,
0x0000002306067212ULL, 0x000fe200078efcffULL, 0x000000080a227824ULL, 0x000fe400078e00ffULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee213ULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0x0000002308087212ULL, 0x000fc600078efcffULL,
0x0000000105057824ULL, 0x000fe200000e0627ULL, 0x000000230a0a7212ULL, 0x000fe200078efcffULL,
0x0000001003037824ULL, 0x100fe200078e0229ULL, 0x0000000625067210ULL, 0x040fe20007f1e0ffULL,
0x0000001010137824ULL, 0x100fe200078e0229ULL, 0x0000000825087210ULL, 0x040fe20007f7e0ffULL,
0x0000001012237824ULL, 0x000fe200078e0229ULL, 0x0000000a250a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000107077824ULL, 0x100fe200000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e2000b901c48ULL, 0x0000000109097824ULL, 0x000fc400018e0627ULL,
0x0000001022257824ULL, 0x000fe200078e0229ULL, 0x0000000006137faeULL, 0x0003e2000b901c48ULL,
0x000000010b0b7824ULL, 0x000fc600020e0627ULL, 0x0000000008237faeULL, 0x0003e8000b901c48ULL,
0x000000000a257faeULL, 0x0003e4000b901c48ULL, 0x0000000820037824ULL, 0x002fe200078e00ffULL,
0x000000011b047810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0xfffffff0030a7812ULL, 0x040fe400078ec0ffULL, 0x0000001d0400720cULL, 0x000fe40003f06070ULL,
0x000000000a0573c2ULL, 0x000e6200000e0000ULL, 0xffffffe003227812ULL, 0x040fe400078ec0ffULL,
0x0000001003077812ULL, 0x040fe400078ec0ffULL, 0x0000000803037812ULL, 0x000fcc00078ec0ffULL,
0x0000000118048824ULL, 0x000fe400078e0204ULL, 0x00000004ff058424ULL, 0x000fe200078e00ffULL,
0x0000002203227210ULL, 0x000fe40007ffe007ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000640004048625ULL, 0x000fca00078e0005ULL, 0x0000000804248981ULL, 0x000522000c1e1900ULL,
0x0001a6b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x01a6b0000a267f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6080022087f8cULL, 0x000664000c80043fULL, 0x0000000000047805ULL, 0x000fc40000015200ULL,
0x01a60c0022037984ULL, 0x000ee40000000800ULL, 0x8000000003ff7812ULL, 0x00afe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60c0022037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000101f137824ULL, 0x000fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe2000001161fULL,
0x0000002020037824ULL, 0x000fc600078e00ffULL, 0x0000007013137812ULL, 0x000fe400078ec0ffULL,
0xffffff8003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c12127812ULL, 0x000fc800078ec0ffULL,
0x0000000312037210ULL, 0x000fca0007ffe013ULL, 0x01a0000003057984ULL, 0x000e680000000800ULL,
0x01a2000003047984ULL, 0x0006a20000000800ULL, 0x000000020500720bULL, 0x002fe20003f1d000ULL,
0x000151227f007947ULL, 0x000fd8000b800000ULL, 0x0000000000037806ULL, 0x008fc800000e0100ULL,
0x000000ff0300720cULL, 0x000fe20003f05270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x00000001ff067424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fd200078e0002ULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x000000201700720cULL, 0x000fe40003f05270ULL,
0x000000020500720bULL, 0x000fe20003f74000ULL, 0x000150f27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000087806ULL, 0x000fc400018e0100ULL, 0x0000008020078824ULL, 0x000fe200078e0213ULL,
0x0000000205237209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000112108824ULL, 0x000fca00078e0207ULL, 0x01a4002310008388ULL, 0x0003e20000000800ULL,
0x000000ff0800720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000000223027221ULL, 0x002fe20000010100ULL, 0x000000ff08ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b02027820ULL, 0x000fcc0000410000ULL,
0x0000000200027308ULL, 0x000e640000000800ULL, 0x0000000221217220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff297819ULL, 0x000fe2000001161fULL,
0x000150427f007947ULL, 0x000fea000b800000ULL, 0x00001f2902297589ULL, 0x0002e400000e0000ULL,
0x000000292c2c7220ULL, 0x08cfe40000410000ULL, 0x000000292d2d7220ULL, 0x080fe40000410000ULL,
0x0000002930307220ULL, 0x080fe40000410000ULL, 0x0000002931317220ULL, 0x000fc40000410000ULL,
0x0000002934347220ULL, 0x080fe40000410000ULL, 0x0000002935357220ULL, 0x080fe40000410000ULL,
0x0000002938387220ULL, 0x080fe40000410000ULL, 0x0000002939397220ULL, 0x080fe40000410000ULL,
0x000000293c3c7220ULL, 0x080fe40000410000ULL, 0x000000293d3d7220ULL, 0x000fc40000410000ULL,
0x0000002940407220ULL, 0x080fe40000410000ULL, 0x0000002941417220ULL, 0x080fe40000410000ULL,
0x0000002944447220ULL, 0x080fe40000410000ULL, 0x0000002945457220ULL, 0x080fe40000410000ULL,
0x0000002948487220ULL, 0x080fe40000410000ULL, 0x0000002949497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0008ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000081f297811ULL, 0x000fe200078ff0ffULL, 0x00014f327f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x00066400000e0000ULL, 0x000000292e2e7220ULL, 0x086fe40000410000ULL,
0x000000292f2f7220ULL, 0x080fe40000410000ULL, 0x0000002932327220ULL, 0x080fe40000410000ULL,
0x0000002933337220ULL, 0x080fe40000410000ULL, 0x0000002936367220ULL, 0x080fe40000410000ULL,
0x0000002937377220ULL, 0x000fc40000410000ULL, 0x000000293a3a7220ULL, 0x080fe40000410000ULL,
0x000000293b3b7220ULL, 0x080fe40000410000ULL, 0x000000293e3e7220ULL, 0x080fe40000410000ULL,
0x000000293f3f7220ULL, 0x080fe40000410000ULL, 0x0000002942427220ULL, 0x080fe40000410000ULL,
0x0000002943437220ULL, 0x000fc40000410000ULL, 0x0000002946467220ULL, 0x080fe40000410000ULL,
0x0000002947477220ULL, 0x080fe40000410000ULL, 0x000000294a4a7220ULL, 0x080fe40000410000ULL,
0x000000294b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000008ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000101f297811ULL, 0x000fe200078ff0ffULL,
0x00014e227f007947ULL, 0x000fea000b800000ULL, 0x00001f2902297589ULL, 0x0002e400000e0000ULL,
0x000000294c4c7220ULL, 0x08cfe40000410000ULL, 0x000000294d4d7220ULL, 0x080fe40000410000ULL,
0x0000002950507220ULL, 0x080fe40000410000ULL, 0x0000002951517220ULL, 0x080fe40000410000ULL,
0x0000002954547220ULL, 0x080fe40000410000ULL, 0x0000002955557220ULL, 0x000fc40000410000ULL,
0x0000002958587220ULL, 0x080fe40000410000ULL, 0x0000002959597220ULL, 0x080fe40000410000ULL,
0x000000295c5c7220ULL, 0x080fe40000410000ULL, 0x000000295d5d7220ULL, 0x080fe40000410000ULL,
0x0000002960607220ULL, 0x080fe40000410000ULL, 0x0000002961617220ULL, 0x000fc40000410000ULL,
0x0000002964647220ULL, 0x080fe40000410000ULL, 0x0000002965657220ULL, 0x080fe40000410000ULL,
0x0000002968687220ULL, 0x080fe40000410000ULL, 0x0000002969697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000008ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000181f297811ULL, 0x000fe200078ff0ffULL,
0x00014d227f007947ULL, 0x000fea000b800000ULL, 0x00001f2902297589ULL, 0x0002e400000e0000ULL,
0x000000294e4e7220ULL, 0x08cfe40000410000ULL, 0x000000294f4f7220ULL, 0x080fe40000410000ULL,
0x0000002952527220ULL, 0x080fe40000410000ULL, 0x0000002953537220ULL, 0x080fe40000410000ULL,
0x0000002956567220ULL, 0x080fe40000410000ULL, 0x0000002957577220ULL, 0x000fc40000410000ULL,
0x000000295a5a7220ULL, 0x080fe40000410000ULL, 0x000000295b5b7220ULL, 0x080fe40000410000ULL,
0x000000295e5e7220ULL, 0x080fe40000410000ULL, 0x000000295f5f7220ULL, 0x080fe40000410000ULL,
0x0000002962627220ULL, 0x080fe40000410000ULL, 0x0000002963637220ULL, 0x000fc40000410000ULL,
0x0000002966667220ULL, 0x080fe40000410000ULL, 0x0000002967677220ULL, 0x080fe40000410000ULL,
0x000000296a6a7220ULL, 0x080fe40000410000ULL, 0x000000296b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000000803ff7212ULL, 0x000fda00078030ffULL,
0x8000002305050221ULL, 0x000fe20000010000ULL, 0x00007610ff060816ULL, 0x000fc60000000006ULL,
0x3fb8aa3b05050820ULL, 0x000fc80000410000ULL, 0x0000000500110308ULL, 0x000e640000000800ULL,
0x0000001104040220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002104217221ULL, 0x004fc40000010000ULL, 0x0000000000027805ULL, 0x008fca0000015200ULL,
0x01a6ac000a057984ULL, 0x000e620000000800ULL, 0x0001a6a80a107810ULL, 0x000fe40007ffe0ffULL,
0x8000000005ff7812ULL, 0x002fe20007804800ULL, 0x0000000000007918ULL, 0x000fd40000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff087224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100800780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000047805ULL, 0x000fcc0000015200ULL, 0x0000000402077210ULL, 0x000fca0007f1e1ffULL,
0x0000000105057824ULL, 0x000fe200000e0e03ULL, 0x003d09000700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011405ULL,
0x0000000704047211ULL, 0x000fca00078110ffULL, 0x000000ffff057224ULL, 0x000fca00000e0605ULL,
0x0000000204047819ULL, 0x000fc80000001205ULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000108087810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x01a6ac000a057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804800ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991006007816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0000720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000011ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff037819ULL, 0x000fe4000001161fULL, 0x0000541000007816ULL, 0x000fe20000000000ULL,
0x000149027f007947ULL, 0x000fea000b800000ULL, 0x00001f03000f7589ULL, 0x0002a400000e0000ULL,
0x0000000803297810ULL, 0x000fe20007ffe0ffULL, 0x000149527f007947ULL, 0x000fea000b800000ULL,
0x00000010030d7810ULL, 0x000fe20007ffe0ffULL, 0x00001f29000e7589ULL, 0x00066a00000e0000ULL,
0x00001f0d000d7589ULL, 0x0006a400000e0000ULL, 0x0000001803297810ULL, 0x008fe20007ffe0ffULL,
0x000149e27f007947ULL, 0x000fea000b800000ULL, 0x00001f29000c7589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000220257824ULL, 0x040fe200078e00ffULL,
0x000000081f027812ULL, 0x000fe200078ec0ffULL, 0x0000000420067824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000024000007945ULL, 0x000fe20003800000ULL,
0x0000000425007812ULL, 0x00afc400078ec0ffULL, 0x00000007020b7812ULL, 0x000fe200078ef81fULL,
0x0000040020027824ULL, 0x000fe200078e00ffULL, 0x000000001f047211ULL, 0x000fe400078fe0ffULL,
0x000000100b097812ULL, 0x040fe200078efcffULL, 0x000000080b037824ULL, 0x040fe200078e00ffULL,
0x0000000406067812ULL, 0x000fe200078ec0ffULL, 0x000000010b0a7824ULL, 0x000fe200078e0204ULL,
0xfffff000027d7812ULL, 0x000fe200078ec0ffULL, 0x0000000104087824ULL, 0x000fe200078e0209ULL,
0x000000061f027211ULL, 0x000fe200078fe0ffULL, 0x0000000809077824ULL, 0x000fe200078e00ffULL,
0xfffffff8030a7812ULL, 0x000fe200078ee20aULL, 0x0000100020037824ULL, 0x000fe200078e00ffULL,
0x000120007d7d7810ULL, 0x000fe20007ffe0ffULL, 0x000000080b047824ULL, 0x000fe200078e00ffULL,
0xfffffff807087812ULL, 0x000fc400078ee208ULL, 0xffffe00003057812ULL, 0x000fe200078ec0ffULL,
0x000000010b037824ULL, 0x000fe400078e0202ULL, 0x000000100a6c7824ULL, 0x100fe200078e027dULL,
0x0001600005057810ULL, 0x000fe20007ffe0ffULL, 0x0000001008287824ULL, 0x000fe200078e027dULL,
0xfffffff804077812ULL, 0x000fc600078ee203ULL, 0x000000006c6c783bULL, 0x000e640000000200ULL,
0x0000001007787824ULL, 0x000fe400078e0205ULL, 0x000000002828783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f6c6c7232ULL, 0x086fe40000000000ULL,
0x0000000f6e6e7232ULL, 0x000fe40000000000ULL, 0x0000000e6d6d7232ULL, 0x080fe40000000000ULL,
0x0000000e6f6f7232ULL, 0x000fc40000000000ULL, 0x0000000d28287232ULL, 0x088fe40000000000ULL,
0x0000000d2a2a7232ULL, 0x000fe40000000000ULL, 0x0000000c29297232ULL, 0x080fe40000000000ULL,
0x0000000c2b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000080b717824ULL, 0x000fe200078e00ffULL, 0x0000000203067810ULL, 0x000fe20007ffe0ffULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x0000000200007812ULL, 0x000fe200078efcffULL,
0x000008d000007945ULL, 0x000fe20003800000ULL, 0xfffffff871067812ULL, 0x000fc400078ee206ULL,
0x000000001f007211ULL, 0x000fc600078fe0ffULL, 0x0000001006707824ULL, 0x000fcc00078e0205ULL,
0x000000007070783bULL, 0x000ea20000004200ULL, 0x00000018ff037819ULL, 0x008fe40000011478ULL,
0x00000018ff047819ULL, 0x000fe40000011479ULL, 0x00000003007c7306ULL, 0x0007e20000200c00ULL,
0x00000018ff057819ULL, 0x000fe4000001147aULL, 0x00000018ff7e7819ULL, 0x000fe4000001147bULL,
0x000088807b857816ULL, 0x000fc600000000ffULL, 0x0000000400817306ULL, 0x0003e20000200c00ULL,
0x0000888078037816ULL, 0x008fe200000000ffULL, 0x00000100708a7824ULL, 0x004fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe20000011470ULL, 0x0000010072907824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe40000011471ULL, 0x00000018ff837819ULL, 0x000fe20000011472ULL,
0x0000007f008c7306ULL, 0x0005e20000200c00ULL, 0x0000010078047824ULL, 0x042fe200078e00ffULL,
0x00000018ff847819ULL, 0x000fe20000011473ULL, 0x0001000078787824ULL, 0x000fe200078e00ffULL,
0x0000888070897816ULL, 0x040fe200000000ffULL, 0x0001000070707824ULL, 0x000fe200078e00ffULL,
0x00000018ff047819ULL, 0x000fc40000011404ULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x00010000797f7824ULL, 0x004fe200078e00ffULL, 0x0000000500867306ULL, 0x0003e20000200c00ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x00008880718b7816ULL, 0x000fe400000000ffULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x00008880728f7816ULL, 0x040fe200000000ffULL,
0x0000007e00877306ULL, 0x0005e20000200c00ULL, 0x0000888079057816ULL, 0x002fe200000000ffULL,
0x0001000072727824ULL, 0x000fe200078e00ffULL, 0x0000888073917816ULL, 0x000fc400000000ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001148aULL, 0x00000018ff907819ULL, 0x000fe20000011490ULL,
0x00000082008d7306ULL, 0x000fe20000200c00ULL, 0x00000100797e7824ULL, 0x004fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fc80000011472ULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x0000007800797306ULL, 0x0003f00000200c00ULL, 0x0000008300927306ULL, 0x0005e20000200c00ULL,
0x000001007b787824ULL, 0x002fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000008400937306ULL, 0x0003e20000200c00ULL, 0x000088807a837816ULL, 0x004fce00000000ffULL,
0x0000007f00827306ULL, 0x0005e20000200c00ULL, 0x000001007a847824ULL, 0x042fe400078e00ffULL,
0x000100007a7a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff847819ULL, 0x000fe40000011484ULL,
0x0000000300037306ULL, 0x000fe20000200c00ULL, 0x000100007b7f7824ULL, 0x004fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fc8000001147aULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000000400047306ULL, 0x000e700000200c00ULL, 0x0000000500057306ULL, 0x000ff00000200c00ULL,
0x0000007e007e7306ULL, 0x000ea20000200c00ULL, 0x0000541003047816ULL, 0x002fce0000000004ULL,
0x0000008500857306ULL, 0x000ff00000200c00ULL, 0x0000007800787306ULL, 0x000e620000200c00ULL,
0x0000541005057816ULL, 0x004fce000000007eULL, 0x0000007a007b7306ULL, 0x0004e20000200c00ULL,
0x000000046c2c723cULL, 0x080f6e000000182cULL, 0x0000007f00887306ULL, 0x000ee20000200c00ULL,
0x00000100717a7824ULL, 0x004fe200078e00ffULL, 0x0000541085857816ULL, 0x002fe20000000078ULL,
0x0001000071717824ULL, 0x000fe200078e00ffULL, 0x00000004284c723cULL, 0x000b64000000184cULL,
0x00000018ff7a7819ULL, 0x000fc4000001147aULL, 0x00000070007f7306ULL, 0x0002a20000200c00ULL,
0x00000018ff717819ULL, 0x000fe40000011471ULL, 0x000054107b867816ULL, 0x008fe20000000086ULL,
0x000000010b057824ULL, 0x120fe400078e0200ULL, 0x0000000109047824ULL, 0x000fe400078e0200ULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x0000010073707824ULL, 0x042fe200078e00ffULL,
0x0000541088877816ULL, 0x000fe20000000087ULL, 0x0001000073737824ULL, 0x000fc400078e00ffULL,
0x0000000109007824ULL, 0x000fe200078e0202ULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x00000018ff737819ULL, 0x000fe20000011473ULL, 0x0000008400847306ULL, 0x000e620000200c00ULL,
0x000054107f8c7816ULL, 0x004fe2000000008cULL, 0x000000866c38723cULL, 0x080f6c0000001838ULL,
0x0000008900897306ULL, 0x000fe40000200c00ULL, 0x000000862858723cULL, 0x000f6c0000001858ULL,
0x0000008a008a7306ULL, 0x000ea20000200c00ULL, 0x0000541083847816ULL, 0x002fce0000000084ULL,
0x0000008b008b7306ULL, 0x000fe20000200c00ULL, 0x000000846c34723cULL, 0x080f6e0000001834ULL,
0x0000007a007a7306ULL, 0x000e620000200c00ULL, 0x00005410898a7816ULL, 0x004fe2000000008aULL,
0x000000842854723cULL, 0x000f6c0000001854ULL, 0x00000071008e7306ULL, 0x0004f00000200c00ULL,
0x0000008f008f7306ULL, 0x000fe20000200c00ULL, 0x0000541082717816ULL, 0x004fc40000000081ULL,
0x000054108b8b7816ULL, 0x002fca000000007aULL, 0x0000009000907306ULL, 0x000e620000200c00ULL,
0x000054108e8d7816ULL, 0x008fe2000000008dULL, 0x0000008a6c3c723cULL, 0x040f6c000000183cULL,
0x0000009100917306ULL, 0x000fe40000200c00ULL, 0x0000008c6c40723cULL, 0x000f6c0000001840ULL,
0x00000070007e7306ULL, 0x0004e20000200c00ULL, 0x000054108f907816ULL, 0x002fe20000000090ULL,
0x0000008a285c723cULL, 0x040f6c000000185cULL, 0x0000007200037306ULL, 0x000e620000200c00ULL,
0x0000541079707816ULL, 0x004fe2000000007cULL, 0x0000008c2860723cULL, 0x000f6c0000001860ULL,
0x0000007300787306ULL, 0x000ea20000200c00ULL, 0x0000541091917816ULL, 0x008fe2000000007eULL,
0x000000706c30723cULL, 0x000f620000001830ULL, 0x0000541003927816ULL, 0x002fe20000000092ULL,
0x0000000809037824ULL, 0x000fcc00078e00ffULL, 0x000000906c44723cULL, 0x000f620000001844ULL,
0xfffffff803047812ULL, 0x000fe400078ee204ULL, 0x0000541078937816ULL, 0x004fe40000000093ULL,
0x000160001a037811ULL, 0x000fc600078e68ffULL, 0x000000702850723cULL, 0x000f700000001850ULL,
0x000000926c48723cULL, 0x000b6e0000001848ULL, 0x000000080b6c7824ULL, 0x020fe200078e00ffULL,
0x000000902864723cULL, 0x000f620000001864ULL, 0x00000008096d7824ULL, 0x000fc600078e00ffULL,
0xfffffff86c057812ULL, 0x000fe400078ee205ULL, 0xfffffff86d027812ULL, 0x000fe400078ee200ULL,
0x000000922868723cULL, 0x000b620000001868ULL, 0x00000010056c7824ULL, 0x100fe400078e027dULL,
0x00000010047d7824ULL, 0x000fe400078e027dULL, 0x0000001002787824ULL, 0x000fe400078e0203ULL,
0x000000006c6c783bULL, 0x000e680000000200ULL, 0x000000007d28783bULL, 0x0204e20000000200ULL,
0x0000008000000947ULL, 0x000fce0003800000ULL, 0x0000000f6c6c7232ULL, 0x082fe40000000000ULL,
0x0000000f6e6e7232ULL, 0x000fc40000000000ULL, 0x0000000e6d6d7232ULL, 0x080fe40000000000ULL,
0x0000000e6f6f7232ULL, 0x000fe40000000000ULL, 0x0000000d28287232ULL, 0x088fe40000000000ULL,
0x0000000d2a2a7232ULL, 0x000fe40000000000ULL, 0x0000000c29297232ULL, 0x080fe40000000000ULL,
0x0000000c2b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000809717824ULL, 0x000fe200078e00ffULL, 0x0000000200007810ULL, 0x000fe20007ffe0ffULL,
0x000000007878783bULL, 0x000ea20000004200ULL, 0xfffffff825257812ULL, 0x000fc400078ec0ffULL,
0xfffffff871007812ULL, 0x000fca00078ee200ULL, 0x0000001000707824ULL, 0x000fcc00078e0203ULL,
0x000000007070783bULL, 0x000ee20000004200ULL, 0x00000018ff7c7819ULL, 0x004fe40000011478ULL,
0x00000018ff7d7819ULL, 0x000fe40000011479ULL, 0x0000007c007e7306ULL, 0x0005e20000200c00ULL,
0x00000018ff817819ULL, 0x000fe4000001147bULL, 0x00000018ff7f7819ULL, 0x000fca000001147aULL,
0x0000007d00847306ULL, 0x0003e20000200c00ULL, 0x00008880787c7816ULL, 0x004fe200000000ffULL,
0x00000100708c7824ULL, 0x008fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011471ULL,
0x00000100718d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011470ULL,
0x0000010073977824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011472ULL,
0x0000008100897306ULL, 0x0005e20000200c00ULL, 0x00000100787d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe20000011473ULL, 0x0001000078787824ULL, 0x000fe200078e00ffULL,
0x00008880708b7816ULL, 0x040fe200000000ffULL, 0x0001000070707824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fc4000001147dULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000010079817824ULL, 0x004fe200078e00ffULL, 0x0000007f00877306ULL, 0x0003e20000200c00ULL,
0x0000888073957816ULL, 0x040fe200000000ffULL, 0x0001000073737824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x00000018ff817819ULL, 0x000fe40000011481ULL,
0x00000018ff8c7819ULL, 0x000fe2000001148cULL, 0x0000008300917306ULL, 0x0005e20000200c00ULL,
0x00008880797f7816ULL, 0x002fc400000000ffULL, 0x00000018ff8d7819ULL, 0x000fe4000001148dULL,
0x00000018ff977819ULL, 0x000fc60000011497ULL, 0x00000082008e7306ULL, 0x000fe20000200c00ULL,
0x0001000079837824ULL, 0x004fca00078e00ffULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x0000007800797306ULL, 0x0003f00000200c00ULL, 0x0000008100827306ULL, 0x0005e20000200c00ULL,
0x000001007b787824ULL, 0x002fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x000088807b817816ULL, 0x044fe200000000ffULL,
0x000100007b7b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000007d007d7306ULL, 0x000e700000200c00ULL, 0x0000007800887306ULL, 0x0005f00000200c00ULL,
0x0000008500967306ULL, 0x0007e20000200c00ULL, 0x0000888071787816ULL, 0x044fe200000000ffULL,
0x0001000071717824ULL, 0x000fca00078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0000008600987306ULL, 0x0005e20000200c00ULL, 0x000088807a857816ULL, 0x008fce00000000ffULL,
0x0000007b008a7306ULL, 0x0007e20000200c00ULL, 0x000001007a867824ULL, 0x044fe400078e00ffULL,
0x000100007a7a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff867819ULL, 0x000fe40000011486ULL,
0x0000007800907306ULL, 0x0005e20000200c00ULL, 0x00008880727b7816ULL, 0x008fe400000000ffULL,
0x00000018ff7a7819ULL, 0x000fca000001147aULL, 0x0000007b00937306ULL, 0x0007e20000200c00ULL,
0x0000010072787824ULL, 0x044fe400078e00ffULL, 0x0001000072727824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x00000070008f7306ULL, 0x0002a20000200c00ULL, 0x00000018ff7b7819ULL, 0x008fce0000011473ULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x000054107c707816ULL, 0x002fce000000007dULL,
0x00000097007c7306ULL, 0x000fe20000200c00ULL, 0x000054108f8e7816ULL, 0x004fce000000008eULL,
0x0000008300837306ULL, 0x000ff00000200c00ULL, 0x0000008500857306ULL, 0x000ff00000200c00ULL,
0x0000008600867306ULL, 0x000ff00000200c00ULL, 0x0000008100817306ULL, 0x000e700000200c00ULL,
0x0000007a007a7306ULL, 0x000eb00000200c00ULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x0000541081737816ULL, 0x002fce0000000088ULL, 0x0000008c008c7306ULL, 0x000e620000200c00ULL,
0x000054107a7a7816ULL, 0x004fce0000000087ULL, 0x0000008d008d7306ULL, 0x000eb00000200c00ULL,
0x0000007100927306ULL, 0x0006a20000200c00ULL, 0x000054108b8c7816ULL, 0x002fce000000008cULL,
0x0000007800947306ULL, 0x0002620000200c00ULL, 0x000054107f717816ULL, 0x008fe40000000082ULL,
0x00005410908d7816ULL, 0x004fca000000008dULL, 0x0000009500957306ULL, 0x000ea20000200c00ULL,
0x0000541079787816ULL, 0x002fe2000000007eULL, 0x00000070284c723cULL, 0x000f62000000184cULL,
0x0000541083797816ULL, 0x000fe40000000084ULL, 0x00005410928f7816ULL, 0x000fc60000000091ULL,
0x00000072007d7306ULL, 0x0002e20000200c00ULL, 0x0000541093947816ULL, 0x000fe20000000094ULL,
0x000000782850723cULL, 0x040f6c0000001850ULL, 0x0000007b00977306ULL, 0x0006e20000200c00ULL,
0x0000541085727816ULL, 0x002fe20000000086ULL, 0x0000008c285c723cULL, 0x000f62000000185cULL,
0x0000541095957816ULL, 0x004fc4000000007cULL, 0x000054107d967816ULL, 0x008fe40000000096ULL,
0x000054108a7b7816ULL, 0x000fc60000000089ULL, 0x000000722854723cULL, 0x000f620000001854ULL,
0x0000541097977816ULL, 0x000fce0000000098ULL, 0x0000007a2858723cULL, 0x040f700000001858ULL,
0x0000008e2860723cULL, 0x040f700000001860ULL, 0x000000942864723cULL, 0x040f700000001864ULL,
0x000000962868723cULL, 0x000f700000001868ULL, 0x000000706c2c723cULL, 0x040f70000000182cULL,
0x000000786c30723cULL, 0x040f700000001830ULL, 0x000000726c34723cULL, 0x040f700000001834ULL,
0x0000007a6c38723cULL, 0x040f700000001838ULL, 0x0000008c6c3c723cULL, 0x040f70000000183cULL,
0x0000008e6c40723cULL, 0x040f700000001840ULL, 0x000000946c44723cULL, 0x040f700000001844ULL,
0x000000966c48723cULL, 0x000b6e0000001848ULL, 0x0001a6c81a6c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006c6c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6880025ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff6e7224ULL, 0x000fc600078e00ffULL, 0x0000000000287805ULL, 0x000fc80000015200ULL,
0x0000040014257984ULL, 0x004ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc4000780486dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016e6e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040014257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001020257824ULL, 0x000fe400078e00ffULL,
0x0000590024247a24ULL, 0x010fc600078e02ffULL, 0xffffffe025297812ULL, 0x000fe200078ec0ffULL,
0x0000008024247824ULL, 0x000fc800078e00ffULL, 0x0000010016297824ULL, 0x000fca00078e0229ULL,
0x0000008029297810ULL, 0x000fc80007ffe0ffULL, 0x0000006029287812ULL, 0x000fca00078ec0ffULL,
0x0000000119707824ULL, 0x000fe200078e0228ULL, 0x000003f00000a947ULL, 0x000fea0003800000ULL,
0x0000001025727812ULL, 0x000fe400078ec0ffULL, 0x000000291e257217ULL, 0x000fe40007800000ULL,
0x00000003ff2b7819ULL, 0x000fe4000001161fULL, 0x0000620024717a11ULL, 0x000fe200078838ffULL,
0x0000000125257824ULL, 0x000fe200078e0a29ULL, 0x000000042b2a7810ULL, 0x040fe20007ffe0ffULL,
0x000000012b287824ULL, 0x040fe200078e0272ULL, 0x000000082b6f7810ULL, 0x000fc40007ffe0ffULL,
0x0000002572257217ULL, 0x000fe20007800000ULL, 0x0000000128297824ULL, 0x040fe200078e021fULL,
0x0000000c2b7b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000828787824ULL, 0x000fe200078e00ffULL,
0x0000630024737a11ULL, 0x000fe200020f3cffULL, 0x0000000125257824ULL, 0x100fe400078e0a72ULL,
0x000000012a797824ULL, 0x000fe200078e0272ULL, 0xfffffff878787812ULL, 0x000fe200078ee229ULL,
0x0000000128287824ULL, 0x100fe200078e0270ULL, 0x000000252a00720cULL, 0x080fe20003f66070ULL,
0x00000001792a7824ULL, 0x000fe200078e0270ULL, 0x000000252b00720cULL, 0x080fe20003f06070ULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x000000256f00720cULL, 0x000fc60003f86070ULL,
0x000000016f7a7824ULL, 0x000fe200078e0272ULL, 0x00000013286e7212ULL, 0x000fe200078efcffULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0x0000006e716e7210ULL, 0x000fe20007fbe0ffULL,
0x000000017a6c7824ULL, 0x000fe200078e0270ULL, 0x000000132a2a7212ULL, 0x000fe200078efcffULL,
0x000000017b727824ULL, 0x000fe400078e0272ULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x000000712a2a7210ULL, 0x000fc60007fde0ffULL, 0x0000000172287824ULL, 0x000fe200078e0270ULL,
0x000000136c6c7212ULL, 0x000fe200078efcffULL, 0x00000001296f7824ULL, 0x000fe200028e0673ULL,
0x000000257b00720cULL, 0x000fe20003fa6070ULL, 0x0000000179707824ULL, 0x040fe400078e021fULL,
0x0000000879797824ULL, 0x000fe400078e00ffULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0xfffffff879707812ULL, 0x000fe200078ee270ULL, 0x000000012b2b7824ULL, 0x000fe200030e0673ULL,
0x000000716c6c7210ULL, 0x000fe20007fde0ffULL, 0x000000017a257824ULL, 0x100fe200078e021fULL,
0x0000001328287212ULL, 0x000fe200078efcffULL, 0x000000087a7a7824ULL, 0x000fe400078e00ffULL,
0x0000000172797824ULL, 0x040fe400078e021fULL, 0x00000008727c7824ULL, 0x000fe200078e00ffULL,
0xfffffff87a727812ULL, 0x000fe200078ee225ULL, 0x000000016d6d7824ULL, 0x000fe200030e0673ULL,
0x0000007128287210ULL, 0x000fe20007fde0ffULL, 0x0000001078257824ULL, 0x000fe200078e0203ULL,
0xfffffff87c787812ULL, 0x000fe200078ee279ULL, 0x0000001070717824ULL, 0x000fc400078e0203ULL,
0x0000000129297824ULL, 0x000fe200030e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e257faeULL, 0x0003e2000c101c48ULL, 0x0000001072737824ULL, 0x100fe400078e0203ULL,
0x0000001078797824ULL, 0x000fe200078e0203ULL, 0x000000002a717faeULL, 0x0003e8000d901c48ULL,
0x000000006c737faeULL, 0x0003e8000e101c48ULL, 0x0000000028797faeULL, 0x0003e2000e901c48ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001025287812ULL, 0x000fc800078ec0ffULL,
0x000000281f257211ULL, 0x000fc800078fe8ffULL, 0x00000004252b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000125297824ULL, 0x040fe200078e021fULL, 0x0000000c256d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000825727824ULL, 0x040fe400078e00ffULL, 0x0000000125287824ULL, 0x100fe400078e0270ULL,
0x000000012b2a7824ULL, 0x040fe200078e0270ULL, 0xfffffff872727812ULL, 0x000fe200078ee229ULL,
0x000000082b787824ULL, 0x000fe200078e00ffULL, 0x0000000825297810ULL, 0x000fe20007ffe0ffULL,
0x000000012b257824ULL, 0x000fc400078e021fULL, 0x000000016d6f7824ULL, 0x100fe400078e021fULL,
0x00000001296c7824ULL, 0x040fe400078e0270ULL, 0x00000001292b7824ULL, 0x040fe400078e021fULL,
0x00000008297a7824ULL, 0x000fe400078e00ffULL, 0x000000086d7c7824ULL, 0x000fe400078e00ffULL,
0x0000008028287825ULL, 0x000fc800078e00ffULL, 0x000000016d6e7824ULL, 0x000fe200078e0270ULL,
0xfffffff878707812ULL, 0x000fe200078ee225ULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0xfffffff87a787812ULL, 0x000fe400078ee22bULL, 0x0000620024257a11ULL, 0x000fe200078038ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0xfffffff87c7a7812ULL, 0x000fe400078ee26fULL,
0x0000001328287212ULL, 0x000fe200078efcffULL, 0x000000806e6e7825ULL, 0x000fe200078e00ffULL,
0x0000630024717a11ULL, 0x000fc400000f3cffULL, 0x0000002825287210ULL, 0x000fe20007f1e0ffULL,
0x0000001078737824ULL, 0x100fe200078e0203ULL, 0x000000132a2a7212ULL, 0x080fe200078efcffULL,
0x000000107a797824ULL, 0x000fe200078e0203ULL, 0x000000136c6c7212ULL, 0x080fe200078efcffULL,
0x0000000129297824ULL, 0x000fe200000e0671ULL, 0x000000136e6e7212ULL, 0x000fe400078efcffULL,
0x0000002a252a7210ULL, 0x040fe40007f7e0ffULL, 0x0000006c256c7210ULL, 0x000fc40007f1e0ffULL,
0x0000006e256e7210ULL, 0x000fe20007f9e0ffULL, 0x000000012b2b7824ULL, 0x000fe400018e0671ULL,
0x0000001072257824ULL, 0x000fe400078e0203ULL, 0x000000016d6d7824ULL, 0x100fe400000e0671ULL,
0x000000016f6f7824ULL, 0x000fe200020e0671ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028257faeULL, 0x0003e2000b901c48ULL, 0x0000001070717824ULL, 0x000fca00078e0203ULL,
0x000000002a717faeULL, 0x0003e8000b901c48ULL, 0x000000006c737faeULL, 0x0003e8000b901c48ULL,
0x000000006e797faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f070ULL,
0x00000000100503c2ULL, 0x000e640000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x002fe20008000a05ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000106c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a62800226e7f8cULL, 0x000664000c80043fULL,
0x0000000000287805ULL, 0x000fc40000015200ULL, 0x01a62c0022257984ULL, 0x000f240000000800ULL,
0x8000000025ff7812ULL, 0x012fc4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a62c0022257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002020257824ULL, 0x000fca00078e00ffULL,
0xffffff8025287812ULL, 0x000fc800078ec0ffULL, 0x0000008013257810ULL, 0x000fca0007ffe028ULL,
0x0000000112257824ULL, 0x000fca00078e0225ULL, 0x01a00000256e7984ULL, 0x000e680000000800ULL,
0x01a2000025727984ULL, 0x0006a20000000800ULL, 0x000000236e00720bULL, 0x002fe20003f1d000ULL,
0x000128727f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x008fc800000e0100ULL,
0x000000ff2500720cULL, 0x000fe20003f05270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6f7424ULL, 0x000fd600078e00ffULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x0000000117297810ULL, 0x000fe40007ffe0ffULL, 0x000000236e00720bULL, 0x000fe40003f74000ULL,
0x000000202900720cULL, 0x000fe20003f05270ULL, 0x000128427f007947ULL, 0x000fd4000b800000ULL,
0x0000000000787806ULL, 0x000fc400018e0100ULL, 0x0000008020298824ULL, 0x000fe200078e0213ULL,
0x000000236e288209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000112298824ULL, 0x000fca00078e0229ULL, 0x01a4002829008388ULL, 0x0003e20000000800ULL,
0x000000ff7800720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x000000236e287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff78ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002328287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x00000028007a7308ULL, 0x000e640000000800ULL,
0x0000007a21217220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x000127827f007947ULL, 0x000fea000b800000ULL,
0x00001f297a297589ULL, 0x0002e400000e0000ULL, 0x000000292c2c7220ULL, 0x08cfe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0078ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x000fe200078ff0ffULL,
0x000126727f007947ULL, 0x000fea000b800000ULL, 0x00001f297a297589ULL, 0x00066400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000078ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x000fe200078ff0ffULL, 0x000125627f007947ULL, 0x000fea000b800000ULL,
0x00001f297a297589ULL, 0x0002e400000e0000ULL, 0x000000294c4c7220ULL, 0x08cfe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000078ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x000fe200078ff0ffULL, 0x000124627f007947ULL, 0x000fea000b800000ULL,
0x00001f297a297589ULL, 0x0002e400000e0000ULL, 0x000000294e4e7220ULL, 0x08cfe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000007825ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff6f7424ULL, 0x000fe200078e00ffULL,
0x000000236e237209ULL, 0x000fd60007810000ULL, 0x800000236e6e0221ULL, 0x000fe20000010000ULL,
0x00007610ff6f0816ULL, 0x000fc6000000006fULL, 0x3fb8aa3b6e6e0820ULL, 0x000fc80000410000ULL,
0x0000006e00110308ULL, 0x000e640000000800ULL, 0x0000001172720220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002172217221ULL, 0x004fc40000010000ULL,
0x0000000000287805ULL, 0x000fca0000015200ULL, 0x0000000820257824ULL, 0x000fca00078e00ffULL,
0xfffffff0256e7812ULL, 0x000fca00078ec0ffULL, 0x01a6b4006e257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a6b4006e257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099106f257816ULL, 0x000fc800000000ffULL,
0x000000ff2500720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff0c723eULL, 0x000fe400000000ffULL, 0x00000002ff257819ULL, 0x000fe4000001161fULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x000120427f007947ULL, 0x000fea000b800000ULL,
0x00001f250c0f7589ULL, 0x0002a400000e0000ULL, 0x0000000825297810ULL, 0x000fe20007ffe0ffULL,
0x000120927f007947ULL, 0x000fea000b800000ULL, 0x00000010250d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f290c0e7589ULL, 0x0002ea00000e0000ULL, 0x00001f0d0c0d7589ULL, 0x0002a400000e0000ULL,
0x0000001825297810ULL, 0x002fe20007ffe0ffULL, 0x000121227f007947ULL, 0x000fea000b800000ULL,
0x00001f290c0c7589ULL, 0x0002e400000e0000ULL, 0x0000040020257824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100020267824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00025257812ULL, 0x000fc400078ec0ffULL,
0xffffe00026267812ULL, 0x000fe400078ec0ffULL, 0x0001300025277810ULL, 0x000fe40007ffe0ffULL,
0x0001700026257810ULL, 0x000fc60007ffe0ffULL, 0x000000100a707824ULL, 0x100fe400078e0227ULL,
0x0000001008287824ULL, 0x000fe400078e0227ULL, 0x00000010077c7824ULL, 0x000fe400078e0225ULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000002828783bULL, 0x002e620000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f70707232ULL, 0x084fe40000000000ULL,
0x0000000f72727232ULL, 0x000fc40000000000ULL, 0x0000000e71717232ULL, 0x088fe40000000000ULL,
0x0000000e73737232ULL, 0x000fe40000000000ULL, 0x0000000d28287232ULL, 0x082fe40000000000ULL,
0x0000000d2a2a7232ULL, 0x000fe40000000000ULL, 0x0000000c29297232ULL, 0x080fe40000000000ULL,
0x0000000c2b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001006787824ULL, 0x000fe200078e0225ULL, 0x000000007c7c783bULL, 0x000f220000004200ULL,
0x0000082000007945ULL, 0x000fe80003800000ULL, 0x000000007878783bULL, 0x008ee20000004200ULL,
0x00000018ff6e7819ULL, 0x010fe2000001147eULL, 0x000001007f897824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fc4000001147fULL, 0x0000006e00877306ULL, 0x0009e20000200c00ULL,
0x00000018ff827819ULL, 0x008fe20000011478ULL, 0x00000100798f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe4000001147dULL, 0x00000018ff257819ULL, 0x000fe4000001147cULL,
0x00000018ff847819ULL, 0x000fe20000011479ULL, 0x0000006f008a7306ULL, 0x0007e20000200c00ULL,
0x000088807d6e7816ULL, 0x010fe400000000ffULL, 0x00000018ff867819ULL, 0x000fc4000001147bULL,
0x00000018ff907819ULL, 0x000fe4000001148fULL, 0x00000018ff857819ULL, 0x000fe2000001147aULL,
0x00000082008e7306ULL, 0x000fe20000200c00ULL, 0x000001007d6f7824ULL, 0x008fe200078e00ffULL,
0x000088807f887816ULL, 0x000fe200000000ffULL, 0x000100007d7d7824ULL, 0x000fe200078e00ffULL,
0x000088807b957816ULL, 0x000fe200000000ffULL, 0x000100007f7f7824ULL, 0x000fe200078e00ffULL,
0x00008880798d7816ULL, 0x040fe200000000ffULL, 0x0001000079797824ULL, 0x000fe200078e00ffULL,
0x0000006e00827306ULL, 0x0007e20000200c00ULL, 0x00000018ff7d7819ULL, 0x000fc4000001147dULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x00000018ff897819ULL, 0x000fe40000011489ULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000002600837306ULL, 0x0009e20000200c00ULL,
0x000001007e6e7824ULL, 0x008fe200078e00ffULL, 0x00000018ff797819ULL, 0x000fc80000011479ULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x0000002500817306ULL, 0x0007e20000200c00ULL,
0x000001007c267824ULL, 0x010fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000008400917306ULL, 0x000fe20000200c00ULL, 0x000088807c257816ULL, 0x048fe200000000ffULL,
0x000100007c7c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000008600977306ULL, 0x000ff00000200c00ULL, 0x0000007d00847306ULL, 0x0007f00000200c00ULL,
0x0000006e00867306ULL, 0x0009e20000200c00ULL, 0x00000100787d7824ULL, 0x008fca00078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x0000002500257306ULL, 0x000fe20000200c00ULL,
0x00008880786e7816ULL, 0x050fe200000000ffULL, 0x0001000078787824ULL, 0x000fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000002600267306ULL, 0x000ff00000200c00ULL,
0x0000007c007c7306ULL, 0x000ff00000200c00ULL, 0x00000078008f7306ULL, 0x0007300000200c00ULL,
0x0000006e008b7306ULL, 0x0005e20000200c00ULL, 0x000001007b787824ULL, 0x008fc400078e00ffULL,
0x000100007b7b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000008500967306ULL, 0x0007e20000200c00ULL, 0x000088807a6e7816ULL, 0x004fe400000000ffULL,
0x000054108f8e7816ULL, 0x010fca000000008eULL, 0x0000007d008c7306ULL, 0x0005220000200c00ULL,
0x000088807e857816ULL, 0x048fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000006e00937306ULL, 0x0007e20000200c00ULL,
0x000001007a7d7824ULL, 0x044fe400078e00ffULL, 0x000100007a7a7824ULL, 0x000fc600078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x00005410256e7816ULL, 0x008fe40000000026ULL,
0x000054108b8c7816ULL, 0x010fca000000008cULL, 0x0000007800267306ULL, 0x0007f00000200c00ULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x000054107c787816ULL, 0x008fe40000000081ULL,
0x00000018ff7c7819ULL, 0x000fc4000001147bULL, 0x00005410826f7816ULL, 0x004fc6000000006fULL,
0x0000008800887306ULL, 0x000fe80000200c00ULL, 0x0000006e702c723cULL, 0x080f68000000182cULL,
0x0000008900897306ULL, 0x000ea80000200c00ULL, 0x0000006e284c723cULL, 0x002f68000000184cULL,
0x0000007e007e7306ULL, 0x000e700000200c00ULL, 0x0000007f007f7306ULL, 0x000ee20000200c00ULL,
0x00005410887b7816ULL, 0x004fce0000000089ULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x000054107e7e7816ULL, 0x002fce0000000087ULL, 0x0000009000907306ULL, 0x000e620000200c00ULL,
0x000054107f7f7816ULL, 0x008fce000000008aULL, 0x0000007900927306ULL, 0x0004e20000200c00ULL,
0x0000007e7038723cULL, 0x080f6e0000001838ULL, 0x0000007d00947306ULL, 0x000f220000200c00ULL,
0x0000541084797816ULL, 0x004fe20000000083ULL, 0x0000007e2858723cULL, 0x000f620000001858ULL,
0x000054108d8d7816ULL, 0x002fca0000000090ULL, 0x0000009500957306ULL, 0x000e620000200c00ULL,
0x00005410928f7816ULL, 0x008fe20000000091ULL, 0x000000787030723cULL, 0x040f6c0000001830ULL,
0x0000007a00257306ULL, 0x0004e20000200c00ULL, 0x0000541093947816ULL, 0x010fe20000000094ULL,
0x0000008c703c723cULL, 0x040f6c000000183cULL, 0x0000007c007c7306ULL, 0x000f220000200c00ULL,
0x00005410857a7816ULL, 0x004fe20000000086ULL, 0x0000008e7040723cULL, 0x000f620000001840ULL,
0x0000541095957816ULL, 0x002fc40000000026ULL, 0x0000541025967816ULL, 0x008fca0000000096ULL,
0x0000007a7034723cULL, 0x000f620000001834ULL, 0x0000100003257810ULL, 0x000fe40007ffe0ffULL,
0x000054107c977816ULL, 0x010fc60000000097ULL, 0x0000001002267824ULL, 0x000fe400078e0225ULL,
0x000000947044723cULL, 0x040f700000001844ULL, 0x000000967048723cULL, 0x000b6e0000001848ULL,
0x0000001005707824ULL, 0x120fe200078e0227ULL, 0x000000782850723cULL, 0x000f620000001850ULL,
0x0000001004277824ULL, 0x000fc800078e0227ULL, 0x000000007070783bULL, 0x000e660000000200ULL,
0x0000007a2854723cULL, 0x040f700000001854ULL, 0x0000008c285c723cULL, 0x040f70000000185cULL,
0x0000008e2860723cULL, 0x040f700000001860ULL, 0x000000942864723cULL, 0x040f700000001864ULL,
0x000000962868723cULL, 0x000b640000001868ULL, 0x000000002728783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000f70707232ULL, 0x082fe40000000000ULL, 0x0000000f72727232ULL, 0x000fc40000000000ULL,
0x0000000e71717232ULL, 0x080fe40000000000ULL, 0x0000000e73737232ULL, 0x000fe40000000000ULL,
0x0000000d28287232ULL, 0x088fe40000000000ULL, 0x0000000d2a2a7232ULL, 0x000fe40000000000ULL,
0x0000000c29297232ULL, 0x080fe40000000000ULL, 0x0000000c2b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000267c783bULL, 0x000f220000004200ULL,
0x0000001000787824ULL, 0x000fcc00078e0225ULL, 0x000000007878783bULL, 0x000ea20000004200ULL,
0x00000018ff6f7819ULL, 0x010fe2000001147eULL, 0x000001007f897824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fe4000001147fULL, 0x00000018ff277819ULL, 0x004fe2000001147cULL,
0x0000006f00877306ULL, 0x0005e20000200c00ULL, 0x00000018ff6e7819ULL, 0x000fe2000001147dULL,
0x00000100788b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe20000011478ULL,
0x00000100798f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011479ULL,
0x000001007a937824ULL, 0x000fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe2000001147aULL,
0x00000082008a7306ULL, 0x0009e20000200c00ULL, 0x000088807d6f7816ULL, 0x004fc400000000ffULL,
0x00000018ff907819ULL, 0x000fe4000001148fULL, 0x00000018ff887819ULL, 0x000fe4000001147bULL,
0x00000018ff8b7819ULL, 0x000fe2000001148bULL, 0x0000002700817306ULL, 0x0005e20000200c00ULL,
0x000001007d827824ULL, 0x010fe200078e00ffULL, 0x000088807b957816ULL, 0x000fe200000000ffULL,
0x000100007d7d7824ULL, 0x000fe200078e00ffULL, 0x00008880798d7816ULL, 0x040fe200000000ffULL,
0x0001000079797824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fc40000011482ULL,
0x0000006e00837306ULL, 0x0009e20000200c00ULL, 0x000088807c277816ULL, 0x044fe400000000ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x00000018ff897819ULL, 0x000fe40000011489ULL,
0x00000018ff797819ULL, 0x000fe20000011479ULL, 0x00000084008e7306ULL, 0x000fe20000200c00ULL,
0x000001007c6e7824ULL, 0x050fe200078e00ffULL, 0x00000018ff937819ULL, 0x000fe20000011493ULL,
0x000100007c7c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000007d00847306ULL, 0x0005f00000200c00ULL,
0x0000006f006f7306ULL, 0x000fe20000200c00ULL, 0x00008880787d7816ULL, 0x044fe200000000ffULL,
0x0001000078787824ULL, 0x000fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000008200827306ULL, 0x000eb00000200c00ULL, 0x0000007c007c7306ULL, 0x000ff00000200c00ULL,
0x00000078008f7306ULL, 0x0008e20000200c00ULL, 0x000054106f6f7816ULL, 0x004fce0000000082ULL,
0x0000002700277306ULL, 0x000fe20000200c00ULL, 0x000001007b787824ULL, 0x050fe400078e00ffULL,
0x000100007b7b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x000054108f8e7816ULL, 0x008fce000000008eULL,
0x0000008500917306ULL, 0x0007f00000200c00ULL, 0x0000008600967306ULL, 0x0009e20000200c00ULL,
0x000088807e857816ULL, 0x008fe400000000ffULL, 0x00005410276e7816ULL, 0x004fca000000006eULL,
0x0000008800977306ULL, 0x0005e20000200c00ULL, 0x000001007e867824ULL, 0x050fe200078e00ffULL,
0x0000006e702c723cULL, 0x002f62000000182cULL, 0x000100007e7e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff867819ULL, 0x000fe40000011486ULL, 0x0000008b008c7306ULL, 0x0003e20000200c00ULL,
0x000088807f887816ULL, 0x044fe200000000ffULL, 0x000100007f7f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000006e284c723cULL, 0x000b66000000184cULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000007800827306ULL, 0x0005e20000200c00ULL,
0x000088807a8b7816ULL, 0x042fe200000000ffULL, 0x000100007a7a7824ULL, 0x000fe200078e00ffULL,
0x0001a6c81a6e7811ULL, 0x020fc800078e18ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x000054107c787816ULL, 0x004fe40000000081ULL,
0x00000018ff7c7819ULL, 0x000fca000001147bULL, 0x0000008600867306ULL, 0x000ff00000200c00ULL,
0x0000008800887306ULL, 0x000ff00000200c00ULL, 0x0000008900897306ULL, 0x000e700000200c00ULL,
0x0000007e007e7306ULL, 0x000eb00000200c00ULL, 0x0000007f007f7306ULL, 0x000ee20000200c00ULL,
0x00005410887b7816ULL, 0x002fce0000000089ULL, 0x0000007d007d7306ULL, 0x000e620000200c00ULL,
0x000054107e7e7816ULL, 0x004fce0000000087ULL, 0x0000008d008d7306ULL, 0x000fe20000200c00ULL,
0x000054107f7f7816ULL, 0x008fce000000008aULL, 0x0000009000907306ULL, 0x000ea20000200c00ULL,
0x000054107d8c7816ULL, 0x002fe2000000008cULL, 0x0000007e7038723cULL, 0x080f6c0000001838ULL,
0x0000007900927306ULL, 0x0002e40000200c00ULL, 0x0000007e2858723cULL, 0x000f6c0000001858ULL,
0x0000008b008b7306ULL, 0x000fe20000200c00ULL, 0x0000541084797816ULL, 0x002fc40000000083ULL,
0x000054108d8d7816ULL, 0x004fca0000000090ULL, 0x0000009300947306ULL, 0x000e620000200c00ULL,
0x00005410928f7816ULL, 0x008fe20000000091ULL, 0x000000787030723cULL, 0x040f6c0000001830ULL,
0x0000009500957306ULL, 0x000ea40000200c00ULL, 0x0000008c703c723cULL, 0x040f6c000000183cULL,
0x0000007a00277306ULL, 0x0007220000200c00ULL, 0x000054108b947816ULL, 0x002fe20000000094ULL,
0x0000008e7040723cULL, 0x000f6c0000001840ULL, 0x0000007c007c7306ULL, 0x000e620000200c00ULL,
0x00005410857a7816ULL, 0x008fe20000000086ULL, 0x000000782850723cULL, 0x000f620000001850ULL,
0x0000541095957816ULL, 0x004fc40000000082ULL, 0x0000541027967816ULL, 0x010fe20000000096ULL,
0x0000000220277824ULL, 0x000fc800078e00ffULL, 0x0000007a7034723cULL, 0x000f620000001834ULL,
0x000054107c977816ULL, 0x002fce0000000097ULL, 0x000000947044723cULL, 0x040f700000001844ULL,
0x000000967048723cULL, 0x000f700000001848ULL, 0x0000007a2854723cULL, 0x040f700000001854ULL,
0x0000008c285c723cULL, 0x040f70000000185cULL, 0x0000008e2860723cULL, 0x040f700000001860ULL,
0x000000942864723cULL, 0x040f700000001864ULL, 0x000000962868723cULL, 0x000b6e0000001868ULL,
0xfffffff827287812ULL, 0x020fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006e6e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6900028ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff277224ULL, 0x000fc600078e00ffULL,
0x0000000000287805ULL, 0x004fc80000015200ULL, 0x00000400142b7984ULL, 0x000ea40000000800ULL,
0x800000002bff7812ULL, 0x006fc4000780486fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28717210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09007100780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407100780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x000000712a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000127277810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400142b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010016277824ULL, 0x000fca00078e0277ULL, 0x000000c027297810ULL, 0x000fc80007ffe0ffULL,
0x0000006029287812ULL, 0x000fca00078ec0ffULL, 0x0000000119727824ULL, 0x000fe200078e0228ULL,
0x000004000000a947ULL, 0x000fea0003800000ULL, 0x00000010202a7824ULL, 0x000fe200078e00ffULL,
0x000000291e287217ULL, 0x000fe40007800000ULL, 0x00000003ff707819ULL, 0x000fe4000001161fULL,
0x000000102a737812ULL, 0x000fe200078ec0ffULL, 0x0000000128287824ULL, 0x000fe200078e0a29ULL,
0x00000004706e7810ULL, 0x040fe40007ffe0ffULL, 0x00000008707c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000170787824ULL, 0x100fe200078e0273ULL, 0x0000002873287217ULL, 0x000fe20007800000ULL,
0x000000016e7a7824ULL, 0x000fe200078e0273ULL, 0x0000620024797a11ULL, 0x000fe200078038ffULL,
0x0000000178297824ULL, 0x000fc400078e0272ULL, 0x0000000128717824ULL, 0x100fe200078e0a73ULL,
0x00006300247b7a11ULL, 0x000fe200000f3cffULL, 0x0000008029287825ULL, 0x000fe200078e00ffULL,
0x0000000c70247810ULL, 0x000fe40007ffe0ffULL, 0x000000716e00720cULL, 0x000fe20003f66070ULL,
0x000000017a2a7824ULL, 0x000fe200078e0272ULL, 0x00000013286e7212ULL, 0x000fe200078efcffULL,
0x000000017c7d7824ULL, 0x000fe200078e0273ULL, 0x000000717000720cULL, 0x000fe20003f86070ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x000000796e6e7210ULL, 0x000fc40007fbe0ffULL,
0x000000717c00720cULL, 0x000fe20003f06070ULL, 0x000000017d287824ULL, 0x000fe200078e0272ULL,
0x000000132a707212ULL, 0x000fe200078efcffULL, 0x00000001247c7824ULL, 0x000fe400078e0273ULL,
0x00000001296f7824ULL, 0x000fe200028e067bULL, 0x0000007970707210ULL, 0x000fe20007fde0ffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x000000712400720cULL, 0x000fc60003fa6070ULL,
0x000000017c2a7824ULL, 0x000fe200078e0272ULL, 0x0000001328287212ULL, 0x000fe200078efcffULL,
0x000000012b717824ULL, 0x000fe400030e067bULL, 0x0000000178247824ULL, 0x000fe200078e021fULL,
0x0000007928287210ULL, 0x000fe20007fde0ffULL, 0x0000000878737824ULL, 0x000fe400078e00ffULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0xfffffff873247812ULL, 0x000fe200078ee224ULL,
0x000000017a727824ULL, 0x100fe200078e021fULL, 0x000000132a2a7212ULL, 0x000fe200078efcffULL,
0x000000087a7f7824ULL, 0x000fe400078e00ffULL, 0x000000017d737824ULL, 0x140fe400078e021fULL,
0x000000087d787824ULL, 0x000fe200078e00ffULL, 0xfffffff87f727812ULL, 0x000fe200078ee272ULL,
0x000000017c7a7824ULL, 0x040fe400078e021fULL, 0x000000087c7d7824ULL, 0x000fe200078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee273ULL, 0x0000000129297824ULL, 0x000fe200030e067bULL,
0x000000792a2a7210ULL, 0x000fe20007fde0ffULL, 0x0000001024737824ULL, 0x100fe200078e0225ULL,
0xfffffff87d7a7812ULL, 0x000fe200078ee27aULL, 0x0000001072797824ULL, 0x000fc400078e0225ULL,
0x000000012b2b7824ULL, 0x000fe200030e067bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e737faeULL, 0x0003e2000e101c48ULL, 0x00000010787b7824ULL, 0x100fe400078e0225ULL,
0x000000107a7d7824ULL, 0x000fe200078e0225ULL, 0x0000000070797faeULL, 0x0003e8000d901c48ULL,
0x00000000287b7faeULL, 0x0003e8000c101c48ULL, 0x000000002a7d7faeULL, 0x0003e2000e901c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001020287824ULL, 0x000fe200078e00ffULL,
0x0000620024737a11ULL, 0x000fc800078038ffULL, 0x0000001028287812ULL, 0x000fe400078ec0ffULL,
0x0000630024797a11ULL, 0x000fe400000f3cffULL, 0x000000281f297211ULL, 0x000fc800078fe8ffULL,
0x00000004292b7810ULL, 0x040fe20007ffe0ffULL, 0x00000001292a7824ULL, 0x140fe200078e021fULL,
0x0000000c29717810ULL, 0x040fe20007ffe0ffULL, 0x00000008296f7824ULL, 0x040fe400078e00ffULL,
0x0000000129287824ULL, 0x000fe400078e0272ULL, 0x000000082b7a7824ULL, 0x000fe200078e00ffULL,
0xfffffff86f787812ULL, 0x000fe200078ee22aULL, 0x000000012b2a7824ULL, 0x000fe200078e0272ULL,
0x00000008296f7810ULL, 0x000fe20007ffe0ffULL, 0x000000012b297824ULL, 0x000fc400078e021fULL,
0x0000000171707824ULL, 0x100fe400078e0272ULL, 0x000000016f6e7824ULL, 0x040fe200078e0272ULL,
0xfffffff87a727812ULL, 0x000fe200078ee229ULL, 0x000000016f2b7824ULL, 0x140fe400078e021fULL,
0x000000086f7c7824ULL, 0x000fe400078e00ffULL, 0x00000001716f7824ULL, 0x040fe400078e021fULL,
0x00000008717e7824ULL, 0x000fe200078e00ffULL, 0xfffffff87c7a7812ULL, 0x000fe200078ee22bULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff87e7c7812ULL, 0x000fe200078ee26fULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000001328287212ULL, 0x000fc600078efcffULL,
0x000000806e6e7825ULL, 0x000fe200078e00ffULL, 0x0000007328287210ULL, 0x000fe40007f1e0ffULL,
0x000000132a2a7212ULL, 0x080fe200078efcffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000136e6e7212ULL, 0x000fe400078efcffULL, 0x000000732a2a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000129297824ULL, 0x000fe200000e0679ULL, 0x0000001370707212ULL, 0x000fe200078efcffULL,
0x000000107a7b7824ULL, 0x000fe200078e0225ULL, 0x000000736e6e7210ULL, 0x080fe20007f1e0ffULL,
0x000000012b2b7824ULL, 0x000fe200018e0679ULL, 0x0000007370707210ULL, 0x000fe20007f9e0ffULL,
0x0000001078737824ULL, 0x000fc400078e0225ULL, 0x000000016f6f7824ULL, 0x100fe400000e0679ULL,
0x0000000171717824ULL, 0x000fe200020e0679ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028737faeULL, 0x0003e2000b901c48ULL, 0x0000001072797824ULL, 0x100fe400078e0225ULL,
0x000000107c7d7824ULL, 0x000fc600078e0225ULL, 0x000000002a797faeULL, 0x0003e8000b901c48ULL,
0x000000006e7b7faeULL, 0x0003e8000b901c48ULL, 0x00000000707d7faeULL, 0x0003e4000b901c48ULL,
0x000000021b1b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0xffffffffff247424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000001d1b00720cULL, 0x000fcc0003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fee0008000a05ULL,
0x000000011b288824ULL, 0x000fe400078e0218ULL, 0x00000004ff298424ULL, 0x000fc800078e00ffULL,
0x0000640028288625ULL, 0x000fca00078e0029ULL, 0x0000000828248981ULL, 0x000322000c1e1900ULL,
0x00000008202a7824ULL, 0x000fca00078e00ffULL, 0xfffffff02a2a7812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6b0002a6e7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6480022707f8cULL, 0x0002a4000c80043fULL, 0x0000000000287805ULL, 0x002fc40000015200ULL,
0x01a64c00222b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x006fe40007804871ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28737210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09007300780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407300780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x000000732a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a64c00222b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002020227824ULL, 0x000fca00078e00ffULL, 0xffffff8022227812ULL, 0x000fc800078ec0ffULL,
0x0000010013297810ULL, 0x000fca0007ffe022ULL, 0x0000000112297824ULL, 0x000fca00078e0229ULL,
0x01a0000029727984ULL, 0x000e680000000800ULL, 0x01a2000029787984ULL, 0x0004e20000000800ULL,
0x000000237200720bULL, 0x002fe20003f1d000ULL, 0x000101b27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000717806ULL, 0x004fc800000e0100ULL, 0x000000ff7100720cULL, 0x000fe20003f05270ULL,
0x0000078000007945ULL, 0x000fe20003800000ULL, 0x00000001ff707424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x000fd200078e0023ULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x0000000217297810ULL, 0x000fe40007ffe0ffULL, 0x000000237200720bULL, 0x000fe40003f74000ULL,
0x000000202900720cULL, 0x000fe20003f05270ULL, 0x000101727f007947ULL, 0x000fd4000b800000ULL,
0x0000000000227806ULL, 0x000fc400018e0100ULL, 0x0000008020298824ULL, 0x000fe200078e0213ULL,
0x0000002372288209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000112298824ULL, 0x000fca00078e0229ULL, 0x01a4002829008388ULL, 0x0003e20000000800ULL,
0x000000ff2200720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000002372287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff22ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002328287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x00000028007a7308ULL, 0x000e640000000800ULL,
0x0000007a21217220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x000100b27f007947ULL, 0x000fea000b800000ULL,
0x00001f297a297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0022ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x000fe200078ff0ffULL,
0x0000ffa27f007947ULL, 0x000fea000b800000ULL, 0x00001f297a297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000022ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x000fe200078ff0ffULL, 0x0000fe927f007947ULL, 0x000fea000b800000ULL,
0x00001f297a297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000022ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x000fe200078ff0ffULL, 0x0000fd927f007947ULL, 0x000fea000b800000ULL,
0x00001f297a297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000002271ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff707424ULL, 0x000fe200078e00ffULL,
0x0000002372227209ULL, 0x000fd60007810000ULL, 0x8000002272720221ULL, 0x000fe20000010000ULL,
0x00007610ff700816ULL, 0x000fc60000000070ULL, 0x3fb8aa3b72720820ULL, 0x000fc80000410000ULL,
0x0000007200110308ULL, 0x000e640000000800ULL, 0x0000001178780220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002178217221ULL, 0x008fc40000010000ULL,
0x0000000000287805ULL, 0x000fca0000015200ULL, 0x0000040010237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff717224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107100780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc8000001142bULL, 0x0000002a23237211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000223237819ULL, 0x000fc8000000122aULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000171717810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040010237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991070237816ULL, 0x000fc800000000ffULL,
0x000000ff2300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff0c723eULL, 0x000fe400000000ffULL, 0x00000002ff237819ULL, 0x000fe4000001161fULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x0000f9927f007947ULL, 0x000fea000b800000ULL,
0x00001f230c0f7589ULL, 0x0002a400000e0000ULL, 0x0000000823297810ULL, 0x000fe20007ffe0ffULL,
0x0000f9e27f007947ULL, 0x000fea000b800000ULL, 0x00000010230d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f290c0e7589ULL, 0x00066a00000e0000ULL, 0x00001f0d0c0d7589ULL, 0x0006a400000e0000ULL,
0x0000001823297810ULL, 0x008fe20007ffe0ffULL, 0x0000fa727f007947ULL, 0x000fea000b800000ULL,
0x00001f290c0c7589ULL, 0x0022e400000e0000ULL, 0x0000040020237824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x00000010077c7824ULL, 0x000fc400078e0203ULL, 0xfffff00023237812ULL, 0x000fc800078ec0ffULL,
0x0001400023237810ULL, 0x000fca0007ffe0ffULL, 0x000000100a0a7824ULL, 0x100fe400078e0223ULL,
0x0000001008087824ULL, 0x000fc600078e0223ULL, 0x000000000a70783bULL, 0x0002e80000000200ULL,
0x000000000828783bULL, 0x0022a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f70707232ULL, 0x08cfe40000000000ULL, 0x0000000f72727232ULL, 0x000fe40000000000ULL,
0x0000000e71717232ULL, 0x080fe40000000000ULL, 0x0000000e73737232ULL, 0x000fc40000000000ULL,
0x0000000d28287232ULL, 0x080fe40000000000ULL, 0x0000000d2a2a7232ULL, 0x000fe40000000000ULL,
0x0000000c29297232ULL, 0x080fe40000000000ULL, 0x0000000c2b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000007c7c783bULL, 0x000e620000004200ULL,
0x0000001006787824ULL, 0x000fe200078e0203ULL, 0x0000082000007945ULL, 0x000fea0003800000ULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x00000018ff087819ULL, 0x002fe2000001147dULL,
0x000100007f887824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fc4000001147eULL,
0x0000000800847306ULL, 0x0003e20000200c00ULL, 0x00000018ff067819ULL, 0x000fe4000001147cULL,
0x00000018ff827819ULL, 0x008fe20000011479ULL, 0x00000100788a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe2000001147fULL, 0x000001007a927824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011478ULL, 0x0000006c00867306ULL, 0x0007e20000200c00ULL,
0x000001007c087824ULL, 0x002fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fc4000001147aULL,
0x00000018ff857819ULL, 0x000fe4000001147bULL, 0x00000018ff087819ULL, 0x000fe40000011408ULL,
0x00000006000a7306ULL, 0x0003e20000200c00ULL, 0x000088807d6c7816ULL, 0x008fe400000000ffULL,
0x000088807f877816ULL, 0x000fe400000000ffULL, 0x00008880798e7816ULL, 0x000fe400000000ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001148aULL, 0x0000008200907306ULL, 0x000fe20000200c00ULL,
0x000088807c067816ULL, 0x042fe200000000ffULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fc40000011492ULL, 0x00000018ff887819ULL, 0x000fe40000011488ULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000006d00897306ULL, 0x000ff00000200c00ULL,
0x0000006c00827306ULL, 0x0003f00000200c00ULL, 0x00000008006d7306ULL, 0x0007e20000200c00ULL,
0x000001007e6c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x00000081008c7306ULL, 0x0003e20000200c00ULL, 0x000088807e087816ULL, 0x048fe200000000ffULL,
0x000100007e7e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000008300947306ULL, 0x0007e20000200c00ULL, 0x000001007d817824ULL, 0x002fca00078e00ffULL,
0x00000018ff817819ULL, 0x000fe40000011481ULL, 0x0000008500967306ULL, 0x000fe20000200c00ULL,
0x000100007d837824ULL, 0x008fca00078e00ffULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x0000000600067306ULL, 0x000ff00000200c00ULL, 0x0000007c007d7306ULL, 0x0003f00000200c00ULL,
0x0000006c00857306ULL, 0x0007e20000200c00ULL, 0x000001007f7c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe4000001147cULL, 0x0000007e007f7306ULL, 0x0002a20000200c00ULL,
0x00008880786c7816ULL, 0x048fe200000000ffULL, 0x0001000078787824ULL, 0x000fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000008100817306ULL, 0x000fe20000200c00ULL,
0x00000100797e7824ULL, 0x042fe400078e00ffULL, 0x0001000079797824ULL, 0x000fc600078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000006c008b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff797819ULL, 0x000fe40000011479ULL, 0x000054107f867816ULL, 0x004fca0000000086ULL,
0x00000078008d7306ULL, 0x0004e20000200c00ULL, 0x000088807a6c7816ULL, 0x042fe200000000ffULL,
0x000100007a7a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000007e008f7306ULL, 0x0003e20000200c00ULL, 0x000088807b787816ULL, 0x004fce00000000ffULL,
0x0000006c00937306ULL, 0x0005e20000200c00ULL, 0x000001007b7e7824ULL, 0x002fe200078e00ffULL,
0x000054108d8c7816ULL, 0x008fe2000000008cULL, 0x000100007b7b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x00005410066c7816ULL, 0x004fe2000000006dULL, 0x000000ffff067224ULL, 0x000fe200078e0078ULL,
0x000054107d787816ULL, 0x000fe4000000000aULL, 0x00000018ff0a7819ULL, 0x000fe4000001147bULL,
0x00005410826d7816ULL, 0x000fe20000000081ULL, 0x0000007c007c7306ULL, 0x000e6c0000200c00ULL,
0x0000006c702c723cULL, 0x080f64000000182cULL, 0x0000008a008a7306ULL, 0x000eac0000200c00ULL,
0x0000006c284c723cULL, 0x000f64000000184cULL, 0x0000009200927306ULL, 0x000ee20000200c00ULL,
0x00005410877b7816ULL, 0x002fe2000000007cULL, 0x00000010027c7824ULL, 0x000fcc00078e0203ULL,
0x0000007a00957306ULL, 0x000e620000200c00ULL, 0x000054108b8a7816ULL, 0x004fce000000008aULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x0000541093927816ULL, 0x008fce0000000092ULL,
0x0000000800087306ULL, 0x000ea20000200c00ULL, 0x0000541095947816ULL, 0x002fce0000000094ULL,
0x0000008800887306ULL, 0x000e700000200c00ULL, 0x0000008e008e7306ULL, 0x000ee20000200c00ULL,
0x00005410087a7816ULL, 0x004fce0000000085ULL, 0x0000007900917306ULL, 0x0004e20000200c00ULL,
0x0000541088877816ULL, 0x002fe20000000089ULL, 0x0000007a7034723cULL, 0x040f6c0000001834ULL,
0x0000000600067306ULL, 0x000fe20000200c00ULL, 0x0000541083797816ULL, 0x004fe20000000084ULL,
0x000000867038723cULL, 0x000f620000001838ULL, 0x000054108e8b7816ULL, 0x008fca000000008fULL,
0x0000007e007d7306ULL, 0x000e620000200c00ULL, 0x00005410918d7816ULL, 0x000fe20000000090ULL,
0x000000787030723cULL, 0x040f6c0000001830ULL, 0x0000000a00817306ULL, 0x000ea40000200c00ULL,
0x0000008a703c723cULL, 0x000f62000000183cULL, 0x0000541006937816ULL, 0x002fce000000007dULL,
0x0000008c7040723cULL, 0x000f620000001840ULL, 0x0000541081957816ULL, 0x004fce0000000096ULL,
0x000000927044723cULL, 0x040f700000001844ULL, 0x000000947048723cULL, 0x000b6e0000001848ULL,
0x0000001005707824ULL, 0x120fe200078e0223ULL, 0x000000782850723cULL, 0x000f620000001850ULL,
0x0000001004237824ULL, 0x000fc800078e0223ULL, 0x000000007070783bULL, 0x000e660000000200ULL,
0x0000007a2854723cULL, 0x040f700000001854ULL, 0x000000862858723cULL, 0x040f700000001858ULL,
0x0000008a285c723cULL, 0x040f70000000185cULL, 0x0000008c2860723cULL, 0x040f700000001860ULL,
0x000000922864723cULL, 0x040f700000001864ULL, 0x000000942828723cULL, 0x000b640000001868ULL,
0x000000002368783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000f70707232ULL, 0x082fe40000000000ULL,
0x0000000f72727232ULL, 0x000fc40000000000ULL, 0x0000000e71717232ULL, 0x080fe40000000000ULL,
0x0000000e73737232ULL, 0x000fe40000000000ULL, 0x0000000d68687232ULL, 0x088fe40000000000ULL,
0x0000000d6a6a7232ULL, 0x000fe40000000000ULL, 0x0000000c69697232ULL, 0x080fe40000000000ULL,
0x0000000c6b6b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x002fea0003800000ULL,
0x0000001000787824ULL, 0x000fe200078e0203ULL, 0x000000007c7c783bULL, 0x000e6a0000004200ULL,
0x000000007878783bULL, 0x000ea20000004200ULL, 0x00000018ff0a7819ULL, 0x002fe2000001147fULL,
0x000001007e837824ULL, 0x000fe200078e00ffULL, 0x00000018ff027819ULL, 0x000fc4000001147dULL,
0x00000018ff087819ULL, 0x000fe2000001147eULL, 0x0000000a00867306ULL, 0x0003e20000200c00ULL,
0x00000018ff6c7819ULL, 0x004fe20000011479ULL, 0x0000010078897824ULL, 0x000fe200078e00ffULL,
0x00000018ff007819ULL, 0x000fe2000001147cULL, 0x000001007a8e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001147aULL, 0x00000018ff237819ULL, 0x000fe20000011478ULL,
0x0000000200817306ULL, 0x0005e20000200c00ULL, 0x000001007d0a7824ULL, 0x002fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fc4000001147bULL, 0x0000888078887816ULL, 0x040fe200000000ffULL,
0x0001000078787824ULL, 0x000fe200078e00ffULL, 0x00000018ff0a7819ULL, 0x000fe4000001140aULL,
0x0000000800847306ULL, 0x0003e20000200c00ULL, 0x000001007c027824ULL, 0x004fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x00000018ff027819ULL, 0x000fc40000011402ULL, 0x0000006c008c7306ULL, 0x0005e20000200c00ULL,
0x000088807d087816ULL, 0x002fe400000000ffULL, 0x00000018ff897819ULL, 0x000fe40000011489ULL,
0x00000018ff8e7819ULL, 0x000fc6000001148eULL, 0x0000000000067306ULL, 0x0003e20000200c00ULL,
0x000100007d6c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000006d00927306ULL, 0x000fe20000200c00ULL, 0x000088807c007816ULL, 0x042fe200000000ffULL,
0x000100007c7c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000000800087306ULL, 0x000ff00000200c00ULL, 0x0000000a006d7306ULL, 0x0002b00000200c00ULL,
0x00000023008a7306ULL, 0x000fe20000200c00ULL, 0x000088807f0a7816ULL, 0x002fce00000000ffULL,
0x0000000200237306ULL, 0x000fe20000200c00ULL, 0x00005410086d7816ULL, 0x004fe2000000006dULL,
0x000001007b087824ULL, 0x000fca00078e00ffULL, 0x00000018ff087819ULL, 0x000fe20000011408ULL,
0x0000000000007306ULL, 0x000ff00000200c00ULL, 0x0000006c00027306ULL, 0x0003f00000200c00ULL,
0x0000008200947306ULL, 0x0005e20000200c00ULL, 0x000100007f6c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000007c007d7306ULL, 0x0003e20000200c00ULL,
0x000088807e827816ULL, 0x044fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000006c00877306ULL, 0x0005e20000200c00ULL,
0x000001007f7c7824ULL, 0x002fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x00000078008b7306ULL, 0x0002e20000200c00ULL, 0x000088807a6c7816ULL, 0x044fe200000000ffULL,
0x000100007a7a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000007c00857306ULL, 0x0005e20000200c00ULL, 0x000088807b787816ULL, 0x042fe200000000ffULL,
0x000100007b7b7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000007e007f7306ULL, 0x0002620000200c00ULL, 0x00008880797c7816ULL, 0x004fe400000000ffULL,
0x000054108b8a7816ULL, 0x008fca000000008aULL, 0x0000006c00907306ULL, 0x0005e20000200c00ULL,
0x00000100797e7824ULL, 0x042fe400078e00ffULL, 0x0001000079797824ULL, 0x000fc600078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe4000001147eULL, 0x00000018ff797819ULL, 0x000fe20000011479ULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x00005410006c7816ULL, 0x004fe20000000023ULL,
0x000000ffff007224ULL, 0x000fe200078e0078ULL, 0x000054107d787816ULL, 0x000fe40000000006ULL,
0x000054107f847816ULL, 0x000fc60000000084ULL, 0x0000008300837306ULL, 0x000e620000200c00ULL,
0x0000006c684c723cULL, 0x080b6e000000184cULL, 0x0000000a000a7306ULL, 0x000ea20000200c00ULL,
0x0000006c702c723cULL, 0x000b6e000000182cULL, 0x0000008800887306ULL, 0x000fe20000200c00ULL,
0x0000541082827816ULL, 0x002fce0000000083ULL, 0x0000008900897306ULL, 0x000e620000200c00ULL,
0x000054100a837816ULL, 0x004fe40000000085ULL, 0x0000541087857816ULL, 0x000fca0000000086ULL,
0x0000008e00917306ULL, 0x000ea20000200c00ULL, 0x000000826854723cULL, 0x040b6e0000001854ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x0000541088887816ULL, 0x002fe20000000089ULL,
0x000000846858723cULL, 0x000b6c0000001858ULL, 0x0000007e008d7306ULL, 0x000e620000200c00ULL,
0x0000541090907816ULL, 0x004fe20000000091ULL, 0x000000827034723cULL, 0x040b6c0000001834ULL,
0x00000079008f7306ULL, 0x0004e40000200c00ULL, 0x000000847038723cULL, 0x000b6c0000001838ULL,
0x0000007a00937306ULL, 0x000ee20000200c00ULL, 0x0000541002797816ULL, 0x004fc40000000081ULL,
0x000054107c897816ULL, 0x002fca000000008dULL, 0x0000000000007306ULL, 0x000fe20000200c00ULL,
0x000054108f8b7816ULL, 0x008fe2000000008cULL, 0x000000786850723cULL, 0x040b6c0000001850ULL,
0x0000000800237306ULL, 0x000e620000200c00ULL, 0x0000541093927816ULL, 0x000fe20000000092ULL,
0x00000088685c723cULL, 0x040b6c000000185cULL, 0x0000007b007b7306ULL, 0x000ea40000200c00ULL,
0x0000008a6860723cULL, 0x000b620000001860ULL, 0x0000541000917816ULL, 0x002fe20000000023ULL,
0x0000000220007824ULL, 0x000fcc00078e00ffULL, 0x000000787030723cULL, 0x000b620000001830ULL,
0xfffffff800027812ULL, 0x000fe400078ec0ffULL, 0x000054107b937816ULL, 0x004fca0000000094ULL,
0x000000906864723cULL, 0x000b700000001864ULL, 0x00000088703c723cULL, 0x040b70000000183cULL,
0x0000008a7040723cULL, 0x040b700000001840ULL, 0x000000907044723cULL, 0x040b700000001844ULL,
0x000000927048723cULL, 0x080b700000001848ULL, 0x000000926868723cULL, 0x000b620000001828ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x00000000146c7f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6980002ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff007224ULL, 0x000fc600078e00ffULL,
0x0000000000287805ULL, 0x000fc80000015200ULL, 0x0000040014237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x006fc4000780486dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28237210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2a7824ULL, 0x000fe200000e0e29ULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x008fc8000001142aULL,
0x0000002302027211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e062aULL,
0x0000000202027819ULL, 0x000fc80000001223ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000100007810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040014237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000116237810ULL, 0x000fc80007ffe0ffULL, 0x0000001c2300720cULL, 0x000fda0003f06070ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x0000000216237810ULL, 0x000fe20007ffe0ffULL,
0x0000590024027a24ULL, 0x018fe200078e02ffULL, 0x0000010027277810ULL, 0x000fe40007ffe0ffULL,
0x0000001c2300720cULL, 0x000fe20003f06070ULL, 0x0000008002067824ULL, 0x000fe200078e00ffULL,
0x0000006027007812ULL, 0x000fca00078ec0ffULL, 0x0000000119027824ULL, 0x000fcc00078e0200ULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x000000271e007217ULL, 0x000fe20007800000ULL,
0x0000001020087824ULL, 0x000fe200078e00ffULL, 0x0000620006237a11ULL, 0x000fc600078038ffULL,
0x0000000100007824ULL, 0x000fe200078e0a27ULL, 0x00000010086d7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff087819ULL, 0x000fe4000001161fULL, 0x000000006d007217ULL, 0x000fe40007800000ULL,
0x0000000408297810ULL, 0x040fe20007ffe0ffULL, 0x00000001080a7824ULL, 0x100fe200078e026dULL,
0x0000630006277a11ULL, 0x000fe200000f3cffULL, 0x0000000100007824ULL, 0x100fe200078e0a6dULL,
0x0000000808067810ULL, 0x000fe20007ffe0ffULL, 0x000000010a287824ULL, 0x000fe200078e0202ULL,
0x0000000c08707810ULL, 0x000fe20007ffe0ffULL, 0x0000000129717824ULL, 0x040fe200078e026dULL,
0x000000002900720cULL, 0x080fe20003f86070ULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x000000000800720cULL, 0x000fc40003fa6070ULL, 0x000000007000720cULL, 0x080fe20003f06070ULL,
0x00000001712a7824ULL, 0x000fe200078e0202ULL, 0x00000013286c7212ULL, 0x000fe200078efcffULL,
0x0000000106087824ULL, 0x040fe200078e026dULL, 0x000000000600720cULL, 0x000fe20003f66070ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000006c236c7210ULL, 0x000fc60007fde0ffULL,
0x0000000170727824ULL, 0x000fe200078e026dULL, 0x000000132a707212ULL, 0x000fe200078efcffULL,
0x0000000108287824ULL, 0x000fe400078e0202ULL, 0x0000000171007824ULL, 0x000fe400078e021fULL,
0x00000001296d7824ULL, 0x000fe200030e0627ULL, 0x0000002370707210ULL, 0x000fe20007fde0ffULL,
0x0000000871717824ULL, 0x000fe400078e00ffULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0xfffffff871007812ULL, 0x000fe200078ee200ULL, 0x000000010a067824ULL, 0x000fe200078e021fULL,
0x0000001328287212ULL, 0x000fe200078efcffULL, 0x000000080a737824ULL, 0x000fe400078e00ffULL,
0x00000001722a7824ULL, 0x000fe400078e0202ULL, 0x000000012b717824ULL, 0x000fe200030e0627ULL,
0xfffffff873067812ULL, 0x000fe200078ee206ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000002328287210ULL, 0x000fc60007fde0ffULL, 0x00000001080a7824ULL, 0x100fe200078e021fULL,
0x000000132a027212ULL, 0x000fe200078efcffULL, 0x0000000808737824ULL, 0x000fe400078e00ffULL,
0x0000000172087824ULL, 0x040fe400078e021fULL, 0x0000000872797824ULL, 0x000fe200078e00ffULL,
0xfffffff8730a7812ULL, 0x000fe200078ee20aULL, 0x0000000129297824ULL, 0x000fe200030e0627ULL,
0x0000002302027210ULL, 0x000fe20007fde0ffULL, 0x0000001006237824ULL, 0x100fe200078e0203ULL,
0xfffffff879087812ULL, 0x000fe200078ee208ULL, 0x0000001000737824ULL, 0x000fc400078e0203ULL,
0x000000100a797824ULL, 0x100fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c237faeULL, 0x0003e2000e901c48ULL, 0x00000010087b7824ULL, 0x000fe400078e0203ULL,
0x000000012b037824ULL, 0x000fe200030e0627ULL, 0x0000000070737faeULL, 0x0003e8000e101c48ULL,
0x0000000028797faeULL, 0x0003e8000d901c48ULL, 0x00000000027b7faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001020007824ULL, 0x000fca00078e00ffULL,
0x0000001000007812ULL, 0x000fc800078ec0ffULL, 0x000000001f007211ULL, 0x000fc800078fe8ffULL,
0x00000004000a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000100087824ULL, 0x040fe200078e021fULL,
0x0000000c00277810ULL, 0x040fe20007ffe0ffULL, 0x0000000800237824ULL, 0x040fe400078e00ffULL,
0x0000000100287824ULL, 0x100fe400078e0202ULL, 0x000000010a2a7824ULL, 0x000fe200078e0202ULL,
0xfffffff823087812ULL, 0x000fe200078ee208ULL, 0x0000000127707824ULL, 0x040fe200078e0202ULL,
0x0000000800237810ULL, 0x000fe20007ffe0ffULL, 0x0000000827727824ULL, 0x000fc400078e00ffULL,
0x000000010a007824ULL, 0x140fe400078e021fULL, 0x00000001236c7824ULL, 0x040fe400078e0202ULL,
0x0000000123027824ULL, 0x140fe400078e021fULL, 0x00000008236d7824ULL, 0x000fe400078e00ffULL,
0x0000000127237824ULL, 0x000fe400078e021fULL, 0x000000080a2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff86d0a7812ULL, 0x000fe200078ee202ULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0xfffffff872727812ULL, 0x000fc400078ee223ULL, 0x0000620006237a11ULL, 0x000fe200078038ffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0xfffffff82b007812ULL, 0x000fe400078ee200ULL,
0x0000001328287212ULL, 0x080fe200078efcffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000630006277a11ULL, 0x000fe400000f3cffULL, 0x0000002823287210ULL, 0x000fe20007f1e0ffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000132a027212ULL, 0x000fc400078efcffULL,
0x000000136c2a7212ULL, 0x080fe200078efcffULL, 0x0000000129297824ULL, 0x000fe200000e0627ULL,
0x00000013706c7212ULL, 0x000fe200078efcffULL, 0x0000001000737824ULL, 0x100fe200078e0203ULL,
0x0000000223027210ULL, 0x040fe20007f1e0ffULL, 0x000000100a797824ULL, 0x100fe200078e0203ULL,
0x0000002a232a7210ULL, 0x040fe20007f7e0ffULL, 0x00000010727b7824ULL, 0x100fe200078e0203ULL,
0x0000006c236c7210ULL, 0x000fe20007f9e0ffULL, 0x0000001008237824ULL, 0x000fe400078e0203ULL,
0x000000012b037824ULL, 0x000fc400000e0627ULL, 0x000000016d2b7824ULL, 0x100fe200018e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028237faeULL, 0x0003e2000b901c48ULL,
0x00000001716d7824ULL, 0x000fc600020e0627ULL, 0x0000000002737faeULL, 0x0003e8000b901c48ULL,
0x000000002a797faeULL, 0x0003e8000b901c48ULL, 0x000000006c7b7faeULL, 0x0003e4000b901c48ULL,
0x0000000820027824ULL, 0x00afe400078e00ffULL, 0x0000002017007824ULL, 0x000fc600078e0215ULL,
0x0000000802037812ULL, 0x000fe400078ec0ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x0000000103067824ULL, 0x000fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000010027f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a66800062a7f8cULL, 0x000662000c80043fULL, 0x000000ffff007224ULL, 0x004fc600078e0003ULL,
0x0000000000027805ULL, 0x000fc80000015200ULL, 0x01a66c0006237984ULL, 0x000ea40000000800ULL,
0x8000000023ff7812ULL, 0x006fc4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002802237210ULL, 0x000fca0007f1e1ffULL, 0x0000000129287824ULL, 0x000fe200000e0e03ULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011428ULL, 0x0000002308087211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0628ULL, 0x0000000208087819ULL, 0x000fc80000001223ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a66c0006237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018017027811ULL, 0x000fc800078e38ffULL,
0x0000000212027210ULL, 0x000fca0007ffe013ULL, 0x01a0000002037984ULL, 0x000e680000000800ULL,
0x01a2000002067984ULL, 0x0084e20000000800ULL, 0x000000220300720bULL, 0x002fe20003f1d000ULL,
0x0000db327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x004fc800000e0100ULL,
0x000000ff0800720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff027224ULL, 0x000fd200078e0022ULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x0000000317237810ULL, 0x000fe40007ffe0ffULL,
0x000000220300720bULL, 0x000fe40003f74000ULL, 0x000000202300720cULL, 0x000fe20003f05270ULL,
0x0000daf27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000237806ULL, 0x000fc400018e0100ULL,
0x0000008020138824ULL, 0x000fe200078e0213ULL, 0x0000002203027209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000112138824ULL, 0x000fca00078e0213ULL,
0x01a4000213008388ULL, 0x0003e20000000800ULL, 0x000000ff2300720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x00000022020a7221ULL, 0x002fe20000010100ULL,
0x000000ff23ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fcc0000410000ULL, 0x0000000a000a7308ULL, 0x000e640000000800ULL,
0x0000000a21217220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x0000da427f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe40000410000ULL,
0x000000292d2d7220ULL, 0x080fe40000410000ULL, 0x0000002930307220ULL, 0x080fe40000410000ULL,
0x0000002931317220ULL, 0x000fc40000410000ULL, 0x0000002934347220ULL, 0x080fe40000410000ULL,
0x0000002935357220ULL, 0x080fe40000410000ULL, 0x0000002938387220ULL, 0x080fe40000410000ULL,
0x0000002939397220ULL, 0x080fe40000410000ULL, 0x000000293c3c7220ULL, 0x080fe40000410000ULL,
0x000000293d3d7220ULL, 0x000fc40000410000ULL, 0x0000002940407220ULL, 0x080fe40000410000ULL,
0x0000002941417220ULL, 0x080fe40000410000ULL, 0x0000002944447220ULL, 0x080fe40000410000ULL,
0x0000002945457220ULL, 0x080fe40000410000ULL, 0x0000002948487220ULL, 0x080fe40000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0023ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x000fe200078ff0ffULL,
0x0000d9327f007947ULL, 0x000fea000b800000ULL, 0x00001f290a297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe40000410000ULL, 0x000000292f2f7220ULL, 0x080fe40000410000ULL,
0x0000002932327220ULL, 0x080fe40000410000ULL, 0x0000002933337220ULL, 0x080fe40000410000ULL,
0x0000002936367220ULL, 0x080fe40000410000ULL, 0x0000002937377220ULL, 0x000fc40000410000ULL,
0x000000293a3a7220ULL, 0x080fe40000410000ULL, 0x000000293b3b7220ULL, 0x080fe40000410000ULL,
0x000000293e3e7220ULL, 0x080fe40000410000ULL, 0x000000293f3f7220ULL, 0x080fe40000410000ULL,
0x0000002942427220ULL, 0x080fe40000410000ULL, 0x0000002943437220ULL, 0x000fc40000410000ULL,
0x0000002946467220ULL, 0x080fe40000410000ULL, 0x0000002947477220ULL, 0x080fe40000410000ULL,
0x000000294a4a7220ULL, 0x080fe40000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000023ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x000fe200078ff0ffULL, 0x0000d8227f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe40000410000ULL,
0x000000294d4d7220ULL, 0x080fe40000410000ULL, 0x0000002950507220ULL, 0x080fe40000410000ULL,
0x0000002951517220ULL, 0x080fe40000410000ULL, 0x0000002954547220ULL, 0x080fe40000410000ULL,
0x0000002955557220ULL, 0x000fc40000410000ULL, 0x0000002958587220ULL, 0x080fe40000410000ULL,
0x0000002959597220ULL, 0x080fe40000410000ULL, 0x000000295c5c7220ULL, 0x080fe40000410000ULL,
0x000000295d5d7220ULL, 0x080fe40000410000ULL, 0x0000002960607220ULL, 0x080fe40000410000ULL,
0x0000002961617220ULL, 0x000fc40000410000ULL, 0x0000002964647220ULL, 0x080fe40000410000ULL,
0x0000002965657220ULL, 0x080fe40000410000ULL, 0x0000002968687220ULL, 0x080fe40000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000023ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x000fe200078ff0ffULL, 0x0000d7227f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe40000410000ULL,
0x000000294f4f7220ULL, 0x080fe40000410000ULL, 0x0000002952527220ULL, 0x080fe40000410000ULL,
0x0000002953537220ULL, 0x080fe40000410000ULL, 0x0000002956567220ULL, 0x080fe40000410000ULL,
0x0000002957577220ULL, 0x000fc40000410000ULL, 0x000000295a5a7220ULL, 0x080fe40000410000ULL,
0x000000295b5b7220ULL, 0x080fe40000410000ULL, 0x000000295e5e7220ULL, 0x080fe40000410000ULL,
0x000000295f5f7220ULL, 0x080fe40000410000ULL, 0x0000002962627220ULL, 0x080fe40000410000ULL,
0x0000002963637220ULL, 0x000fc40000410000ULL, 0x0000002966667220ULL, 0x080fe40000410000ULL,
0x0000002967677220ULL, 0x080fe40000410000ULL, 0x000000296a6a7220ULL, 0x080fe40000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000002308ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff0a7424ULL, 0x000fd800078e00ffULL,
0x0000000302030221ULL, 0x000fe20000010100ULL, 0x00007610ff0a0816ULL, 0x000fc6000000000aULL,
0x3fb8aa3b03030820ULL, 0x000fc80000410000ULL, 0x0000000300110308ULL, 0x000e640000000800ULL,
0x0000001106060220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002106217221ULL, 0x008fc40000010000ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0x0000000820037824ULL, 0x000fca00078e00ffULL, 0xfffffff003087812ULL, 0x000fca00078ec0ffULL,
0x01a6b40008037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002212067210ULL, 0x000fca0007f1e1ffULL,
0x0000000123227824ULL, 0x000fe200000e0e13ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff2200720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff2200720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011422ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0622ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000110107810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6b40008037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100a037816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff03723eULL, 0x000fe400000000ffULL, 0x00000002ff067819ULL, 0x000fe4000001161fULL,
0x0000541003037816ULL, 0x000fe20000000003ULL, 0x0000d3027f007947ULL, 0x000fea000b800000ULL,
0x00001f06030f7589ULL, 0x0002a400000e0000ULL, 0x0000000806297810ULL, 0x000fe20007ffe0ffULL,
0x0000d3527f007947ULL, 0x000fea000b800000ULL, 0x0000001006087810ULL, 0x000fe20007ffe0ffULL,
0x00001f29030e7589ULL, 0x00066800000e0000ULL, 0x00001f08030d7589ULL, 0x0006a400000e0000ULL,
0x0000001806297810ULL, 0x008fe20007ffe0ffULL, 0x0000d3e27f007947ULL, 0x000fea000b800000ULL,
0x00001f29030c7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000011a037812ULL, 0x00afe200078ec0ffULL, 0x000000080b0a7824ULL, 0x000fe200078e00ffULL,
0x00000004ff067819ULL, 0x000fe2000001161fULL, 0x0000000809137824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x0000001007707824ULL, 0x000fc400078e0225ULL, 0x0000000403067824ULL, 0x000fc800078e0206ULL,
0x000000010b037824ULL, 0x100fe400078e0206ULL, 0x0000000109087824ULL, 0x000fc600078e0206ULL,
0xfffffff80a067812ULL, 0x000fe200078ee203ULL, 0x00000004200a7824ULL, 0x000fe200078e00ffULL,
0x0001500017037811ULL, 0x000fe400078e60ffULL, 0xfffffff813087812ULL, 0x000fe400078ee208ULL,
0x000000040a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000001006067824ULL, 0x100fe400078e0203ULL,
0x0000001008087824ULL, 0x000fe200078e0203ULL, 0x000000020a0a7812ULL, 0x000fc400078efcffULL,
0x00000000066c783bULL, 0x0002e80000000200ULL, 0x000000000828783bULL, 0x0002a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f6c6c7232ULL, 0x08cfe40000000000ULL,
0x0000000f6e6e7232ULL, 0x000fe40000000000ULL, 0x0000000e6d6d7232ULL, 0x080fe40000000000ULL,
0x0000000e6f6f7232ULL, 0x000fc40000000000ULL, 0x0000000d28287232ULL, 0x080fe40000000000ULL,
0x0000000d2a2a7232ULL, 0x000fe40000000000ULL, 0x0000000c29297232ULL, 0x080fe40000000000ULL,
0x0000000c2b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000a1f087211ULL, 0x002fe200078fe0ffULL, 0x000000080b067824ULL, 0x040fe200078e00ffULL,
0x000000007070783bULL, 0x000e620000004200ULL, 0x0000001004047824ULL, 0x000fe200078e0203ULL,
0x0000082000007945ULL, 0x000fe20003800000ULL, 0x000000010b0b7824ULL, 0x000fca00078e0208ULL,
0xfffffff806067812ULL, 0x000fca00078ee20bULL, 0x0000001006067824ULL, 0x000fca00078e0225ULL,
0x000000000678783bULL, 0x0006a20000004200ULL, 0x00000018ff0b7819ULL, 0x002fe20000011471ULL,
0x00010000737e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff077819ULL, 0x000fe40000011470ULL,
0x0000000b00227306ULL, 0x0003e20000200c00ULL, 0x00000018ff107819ULL, 0x000fe40000011472ULL,
0x00000018ff127819ULL, 0x000fe40000011473ULL, 0x0000888070067816ULL, 0x008fc400000000ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x00000007000a7306ULL, 0x0007e20000200c00ULL,
0x00000100710b7824ULL, 0x002fe200078e00ffULL, 0x00000018ff277819ULL, 0x004fe2000001147aULL,
0x0000010078817824ULL, 0x000fca00078e00ffULL, 0x00000010007c7306ULL, 0x0003e20000200c00ULL,
0x00000018ff137819ULL, 0x000fe20000011478ULL, 0x0000010070077824ULL, 0x048fe200078e00ffULL,
0x00000018ff237819ULL, 0x000fe20000011479ULL, 0x0001000070707824ULL, 0x000fe200078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe2000001147bULL, 0x0001000079857824ULL, 0x000fe200078e00ffULL,
0x00000018ff077819ULL, 0x000fe20000011407ULL, 0x00000027008a7306ULL, 0x0005e20000200c00ULL,
0x0000888071107816ULL, 0x042fe200000000ffULL, 0x0001000071717824ULL, 0x000fe200078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011470ULL, 0x000001007a877824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fc40000011481ULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x00000012007f7306ULL, 0x0003e20000200c00ULL, 0x0000010072277824ULL, 0x004fe200078e00ffULL,
0x0000888079837816ULL, 0x000fe400000000ffULL, 0x000088807b897816ULL, 0x000fe400000000ffULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000001300847306ULL, 0x000fe20000200c00ULL,
0x00000018ff127819ULL, 0x002fc4000001140bULL, 0x00000018ff857819ULL, 0x000fe40000011485ULL,
0x00000018ff877819ULL, 0x000fc60000011487ULL, 0x0000002300867306ULL, 0x0003f00000200c00ULL,
0x0000001200137306ULL, 0x000fe20000200c00ULL, 0x0000888072237816ULL, 0x042fe200000000ffULL,
0x0001000072727824ULL, 0x000fca00078e00ffULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x0000002700127306ULL, 0x0003f00000200c00ULL, 0x0000000600067306ULL, 0x000fe20000200c00ULL,
0x0000888078277816ULL, 0x042fe200000000ffULL, 0x0001000078787824ULL, 0x000fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000000700077306ULL, 0x000e700000200c00ULL,
0x00000070000b7306ULL, 0x0004f00000200c00ULL, 0x0000001000107306ULL, 0x000ee20000200c00ULL,
0x0000010073707824ULL, 0x004fe200078e00ffULL, 0x0000541006067816ULL, 0x002fc80000000007ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000007100717306ULL, 0x000e620000200c00ULL,
0x000054100b0a7816ULL, 0x008fce000000000aULL, 0x0000007d008b7306ULL, 0x0005e20000200c00ULL,
0x0000541010077816ULL, 0x000fce0000000013ULL, 0x0000008100827306ULL, 0x0007e20000200c00ULL,
0x00008880737d7816ULL, 0x004fe200000000ffULL, 0x000000066c2c723cULL, 0x000f62000000182cULL,
0x00005410710b7816ULL, 0x002fca0000000022ULL, 0x0000007200737306ULL, 0x0002a20000200c00ULL,
0x000088807a817816ULL, 0x048fe200000000ffULL, 0x000100007a7a7824ULL, 0x000fe200078e00ffULL,
0x0000000a6c30723cULL, 0x080f680000001830ULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000007d007d7306ULL, 0x000fe20000200c00ULL, 0x0000010079727824ULL, 0x002fe400078e00ffULL,
0x0000000a2850723cULL, 0x000b660000001850ULL, 0x00000018ff727819ULL, 0x000fc40000011472ULL,
0x0000007800797306ULL, 0x0002e20000200c00ULL, 0x00005410737c7816ULL, 0x004fe2000000007cULL,
0x00000010050a7824ULL, 0x020fe200078e0203ULL, 0x00000006284c723cULL, 0x000b64000000184cULL,
0x000000000404783bULL, 0x020ea60000000200ULL, 0x0000007000707306ULL, 0x000ee20000200c00ULL,
0x000001007b787824ULL, 0x042fe400078e00ffULL, 0x000100007b7b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000018ff7b7819ULL, 0x000fe2000001147bULL,
0x0000002300237306ULL, 0x000e620000200c00ULL, 0x0000541079847816ULL, 0x008fe40000000084ULL,
0x000054107d137816ULL, 0x000fca0000000070ULL, 0x0000007e007e7306ULL, 0x000ef00000200c00ULL,
0x0000002700277306ULL, 0x000ea20000200c00ULL, 0x0000541023127816ULL, 0x002fce0000000012ULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x000054107e7d7816ULL, 0x008fe2000000007fULL,
0x000000122854723cULL, 0x040f6c0000001854ULL, 0x0000007200727306ULL, 0x000e620000200c00ULL,
0x0000541027827816ULL, 0x004fe20000000082ULL, 0x0000007c2858723cULL, 0x000f6c0000001858ULL,
0x0000008500857306ULL, 0x000ea40000200c00ULL, 0x000000126c34723cULL, 0x040f6c0000001834ULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0x0000541083837816ULL, 0x002fe20000000072ULL,
0x0000007c6c38723cULL, 0x000f6c0000001838ULL, 0x0000008700887306ULL, 0x000e620000200c00ULL,
0x0000541085857816ULL, 0x004fe20000000086ULL, 0x00000082285c723cULL, 0x040f6c000000185cULL,
0x0000008900897306ULL, 0x000fe40000200c00ULL, 0x000000842860723cULL, 0x000f6c0000001860ULL,
0x0000007800787306ULL, 0x000ea20000200c00ULL, 0x0000541081887816ULL, 0x002fe20000000088ULL,
0x000000826c3c723cULL, 0x040f6c000000183cULL, 0x0000007a00717306ULL, 0x000e640000200c00ULL,
0x000000846c40723cULL, 0x000f6c0000001840ULL, 0x0000007b00107306ULL, 0x000ee20000200c00ULL,
0x0000541089897816ULL, 0x004fc40000000078ULL, 0x00005410718a7816ULL, 0x002fca000000008aULL,
0x000000882864723cULL, 0x000f620000001864ULL, 0x00005410108b7816ULL, 0x008fce000000008bULL,
0x000000886c44723cULL, 0x000f700000001844ULL, 0x0000008a2868723cULL, 0x080b640000001868ULL,
0x000000000a28783bULL, 0x0202ac0000000200ULL, 0x0000008a6c48723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000f28287232ULL, 0x084fe40000000000ULL, 0x0000000f2a2a7232ULL, 0x000fc40000000000ULL,
0x0000000e29297232ULL, 0x080fe40000000000ULL, 0x0000000e2b2b7232ULL, 0x000fe40000000000ULL,
0x0000000d04047232ULL, 0x080fe40000000000ULL, 0x0000000d06067232ULL, 0x000fe40000000000ULL,
0x0000000c05057232ULL, 0x080fe40000000000ULL, 0x0000000c07077232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000809037824ULL, 0x040fe200078e00ffULL,
0x00000000266c783bULL, 0x020ee20000004200ULL, 0x0000000109087824ULL, 0x000fca00078e0208ULL,
0xfffffff803087812ULL, 0x000fca00078ee208ULL, 0x0000001008087824ULL, 0x000fcc00078e0225ULL,
0x000000000808783bULL, 0x002e620000004200ULL, 0x00000018ff107819ULL, 0x008fe4000001146dULL,
0x00000018ff037819ULL, 0x000fe4000001146cULL, 0x0000001000257306ULL, 0x0007e20000200c00ULL,
0x00000018ff137819ULL, 0x000fe4000001146eULL, 0x00000018ff227819ULL, 0x000fe4000001146fULL,
0x000088806f717816ULL, 0x000fc600000000ffULL, 0x0000000300127306ULL, 0x0005e20000200c00ULL,
0x000001006c107824ULL, 0x008fe200078e00ffULL, 0x00000018ff237819ULL, 0x002fe20000011408ULL,
0x00000100087a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000001300727306ULL, 0x0003e20000200c00ULL, 0x000088806c037816ULL, 0x044fe200000000ffULL,
0x000100006c6c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe2000001140aULL,
0x000100000a827824ULL, 0x040fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fe2000001140bULL,
0x000001000a817824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x00000023007c7306ULL, 0x0005e20000200c00ULL, 0x000001006d137824ULL, 0x002fe200078e00ffULL,
0x0000888008797816ULL, 0x040fe200000000ffULL, 0x0001000008087824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fc40000011409ULL, 0x00008880097b7816ULL, 0x000fe400000000ffULL,
0x0000000300037306ULL, 0x000fe20000200c00ULL, 0x00000018ff237819ULL, 0x004fe40000011413ULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x000088800b857816ULL, 0x000fe400000000ffULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x0000001000107306ULL, 0x000fe20000200c00ULL,
0x00000018ff7a7819ULL, 0x000fc4000001147aULL, 0x000088800a7f7816ULL, 0x000fe400000000ffULL,
0x00000018ff817819ULL, 0x000fc60000011481ULL, 0x0000002200737306ULL, 0x0003f00000200c00ULL,
0x0000006c00137306ULL, 0x0004e20000200c00ULL, 0x000088806d227816ULL, 0x042fe200000000ffULL,
0x000100006d6d7824ULL, 0x000fca00078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x0000002700837306ULL, 0x0003e20000200c00ULL, 0x000001006f6c7824ULL, 0x044fe400078e00ffULL,
0x000100006f6f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000007000847306ULL, 0x0005e20000200c00ULL, 0x000088806e277816ULL, 0x002fe400000000ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000541013127816ULL, 0x008fc60000000012ULL,
0x0000002200227306ULL, 0x000fe20000200c00ULL, 0x000001006e707824ULL, 0x044fe400078e00ffULL,
0x000100006e6e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x0000002300237306ULL, 0x000fe20000200c00ULL, 0x00000018ff6e7819ULL, 0x000fce000001146eULL,
0x00000026007d7306ULL, 0x000ff00000200c00ULL, 0x0000006d00267306ULL, 0x000e700000200c00ULL,
0x0000006f00787306ULL, 0x000eb00000200c00ULL, 0x0000006e006d7306ULL, 0x0006a20000200c00ULL,
0x0000541026137816ULL, 0x002fce0000000025ULL, 0x00000008006f7306ULL, 0x0002620000200c00ULL,
0x00000100096e7824ULL, 0x048fe200078e00ffULL, 0x0000541078737816ULL, 0x004fe20000000073ULL,
0x0001000009097824ULL, 0x000fe200078e00ffULL, 0x000000122830723cULL, 0x080b640000001830ULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x00000018ff097819ULL, 0x000fe20000011409ULL,
0x0000008200827306ULL, 0x000ea20000200c00ULL, 0x0000541003087816ULL, 0x002fe20000000010ULL,
0x000001000b107824ULL, 0x000fe200078e00ffULL, 0x000054106d727816ULL, 0x000fe20000000072ULL,
0x000100000b0b7824ULL, 0x000fe200078e00ffULL, 0x000000120450723cULL, 0x000b620000001850ULL,
0x000000ffff037224ULL, 0x000fe200078e0085ULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x00000009007e7306ULL, 0x0002e20000200c00ULL, 0x00000018ff0b7819ULL, 0x000fc4000001140bULL,
0x000054106f7c7816ULL, 0x000fe4000000007cULL, 0x000000722838723cULL, 0x080b660000001838ULL,
0x0000002700277306ULL, 0x000fe20000200c00ULL, 0x0000541022097816ULL, 0x002fe40000000023ULL,
0x0000541082827816ULL, 0x004fe40000000083ULL, 0x000000720458723cULL, 0x000b660000001858ULL,
0x0000007000707306ULL, 0x000e620000200c00ULL, 0x000054107e7d7816ULL, 0x008fc8000000007dULL,
0x00000008282c723cULL, 0x040b66000000182cULL, 0x0000007100717306ULL, 0x000fea0000200c00ULL,
0x0000007c2840723cULL, 0x000b660000001840ULL, 0x0000006c006c7306ULL, 0x000ea20000200c00ULL,
0x0000541027707816ULL, 0x002fc80000000070ULL, 0x00000008044c723cULL, 0x040b66000000184cULL,
0x0000007900797306ULL, 0x000fea0000200c00ULL, 0x0000007c0460723cULL, 0x000b660000001860ULL,
0x0000007a007a7306ULL, 0x000e620000200c00ULL, 0x0000541071717816ULL, 0x004fce000000006cULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x000000702834723cULL, 0x080b6e0000001834ULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x00005410797a7816ULL, 0x002fe2000000007aULL,
0x000000700454723cULL, 0x000b6c0000001854ULL, 0x0000007f007f7306ULL, 0x000ff00000200c00ULL,
0x00000081000a7306ULL, 0x000e620000200c00ULL, 0x000054107b7b7816ULL, 0x004fce000000006eULL,
0x0000000300037306ULL, 0x000fe20000200c00ULL, 0x0000007a283c723cULL, 0x080b6e000000183cULL,
0x0000001000107306ULL, 0x000ea20000200c00ULL, 0x000054107f0a7816ULL, 0x002fe2000000000aULL,
0x0000007a045c723cULL, 0x000b6c000000185cULL, 0x0000000b00237306ULL, 0x0004640000200c00ULL,
0x00005410030b7816ULL, 0x004fc40000000010ULL, 0x0000541023837816ULL, 0x002fca0000000084ULL,
0x0000000a2844723cULL, 0x040b700000001844ULL, 0x000000822848723cULL, 0x000b700000001848ULL,
0x0000000a0464723cULL, 0x040b700000001864ULL, 0x000000820468723cULL, 0x000b620000001868ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x0000000014047f8cULL, 0x0202a2000c80043fULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0001a6a017067811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000006ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff037224ULL, 0x004fe200078e0005ULL, 0x0000001000002944ULL, 0x000fe20003c00000ULL,
0xffff50a000007947ULL, 0x000fea000383ffffULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0180000021007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000c96000047802ULL, 0x000fc40000000f00ULL, 0x0000c4c000007944ULL, 0x01efea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002100007308ULL, 0x000ee40000001000ULL,
0xbf80000000027423ULL, 0x00afc80000000021ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000802037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000087919ULL, 0x000e680000000000ULL,
0x0000000000047919ULL, 0x000ea20000000000ULL, 0x0000001808057811ULL, 0x042fe400078ff0ffULL,
0x0000000808097811ULL, 0x000fc400078ff0ffULL, 0x00000002ff077819ULL, 0x004fe40000011604ULL,
0x00000010080b7811ULL, 0x000fe200078ff0ffULL, 0x0000000003067220ULL, 0x008fca0000410000ULL,
0x00001f0706007589ULL, 0x000e6800000e0000ULL, 0x00001f0506057589ULL, 0x000ea800000e0000ULL,
0x00001f0906047589ULL, 0x000ee800000e0000ULL, 0x00001f0b06027589ULL, 0x000ea200000e0000ULL,
0x0000002c002c7220ULL, 0x002fc40000410000ULL, 0x0000002d002d7220ULL, 0x040fe40000410000ULL,
0x0000003000307220ULL, 0x040fe40000410000ULL, 0x0000003100317220ULL, 0x040fe40000410000ULL,
0x0000003400347220ULL, 0x040fe40000410000ULL, 0x0000003500357220ULL, 0x040fe40000410000ULL,
0x0000003800387220ULL, 0x000fc40000410000ULL, 0x0000003900397220ULL, 0x040fe40000410000ULL,
0x0000003c003c7220ULL, 0x040fe40000410000ULL, 0x0000003d003d7220ULL, 0x040fe40000410000ULL,
0x0000004000407220ULL, 0x040fe40000410000ULL, 0x0000004100417220ULL, 0x040fe40000410000ULL,
0x0000004400447220ULL, 0x000fc40000410000ULL, 0x0000004500457220ULL, 0x040fe40000410000ULL,
0x0000004800487220ULL, 0x040fe40000410000ULL, 0x0000004900497220ULL, 0x000fe40000410000ULL,
0x0000004e054e7220ULL, 0x044fe40000410000ULL, 0x0000004f054f7220ULL, 0x040fe40000410000ULL,
0x0000005205527220ULL, 0x000fc40000410000ULL, 0x0000005305537220ULL, 0x040fe40000410000ULL,
0x0000005605567220ULL, 0x040fe40000410000ULL, 0x0000005705577220ULL, 0x040fe40000410000ULL,
0x0000005a055a7220ULL, 0x040fe40000410000ULL, 0x0000005b055b7220ULL, 0x040fe40000410000ULL,
0x0000005e055e7220ULL, 0x000fc40000410000ULL, 0x0000005f055f7220ULL, 0x040fe40000410000ULL,
0x0000006205627220ULL, 0x040fe40000410000ULL, 0x0000006305637220ULL, 0x040fe40000410000ULL,
0x0000006605667220ULL, 0x040fe40000410000ULL, 0x0000006705677220ULL, 0x040fe40000410000ULL,
0x0000006a056a7220ULL, 0x000fc40000410000ULL, 0x0000006b056b7220ULL, 0x000fe40000410000ULL,
0x000000042e2e7220ULL, 0x088fe40000410000ULL, 0x000000042f2f7220ULL, 0x080fe40000410000ULL,
0x0000000432327220ULL, 0x080fe40000410000ULL, 0x0000000433337220ULL, 0x080fe40000410000ULL,
0x0000000436367220ULL, 0x000fc40000410000ULL, 0x0000000437377220ULL, 0x080fe40000410000ULL,
0x000000043a3a7220ULL, 0x080fe40000410000ULL, 0x000000043b3b7220ULL, 0x080fe40000410000ULL,
0x000000043e3e7220ULL, 0x080fe40000410000ULL, 0x000000043f3f7220ULL, 0x080fe40000410000ULL,
0x0000000442427220ULL, 0x000fc40000410000ULL, 0x0000000443437220ULL, 0x080fe40000410000ULL,
0x0000000446467220ULL, 0x080fe40000410000ULL, 0x0000000447477220ULL, 0x080fe40000410000ULL,
0x000000044a4a7220ULL, 0x080fe40000410000ULL, 0x000000044b4b7220ULL, 0x000fe40000410000ULL,
0x000000024c4c7220ULL, 0x000fc40000410000ULL, 0x000000024d4d7220ULL, 0x080fe40000410000ULL,
0x0000000250507220ULL, 0x080fe40000410000ULL, 0x0000000251517220ULL, 0x080fe40000410000ULL,
0x0000000254547220ULL, 0x080fe40000410000ULL, 0x0000000255557220ULL, 0x080fe40000410000ULL,
0x0000000258587220ULL, 0x000fc40000410000ULL, 0x0000000259597220ULL, 0x080fe40000410000ULL,
0x000000025c5c7220ULL, 0x080fe40000410000ULL, 0x000000025d5d7220ULL, 0x080fe40000410000ULL,
0x0000000260607220ULL, 0x080fe40000410000ULL, 0x0000000261617220ULL, 0x080fe40000410000ULL,
0x0000000264647220ULL, 0x000fc40000410000ULL, 0x0000000265657220ULL, 0x080fe40000410000ULL,
0x0000000268687220ULL, 0x080fe40000410000ULL, 0x0000000269697220ULL, 0x000fc40000410000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x0000002e2f2e723eULL, 0x000fe400000000ffULL,
0x000000323317723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000363736723eULL, 0x000fc400000000ffULL, 0x0000003a3b1b723eULL, 0x000fe400000000ffULL,
0x0000003e3f3e723eULL, 0x000fe400000000ffULL, 0x00000042431f723eULL, 0x000fe400000000ffULL,
0x000000464746723eULL, 0x000fe400000000ffULL, 0x0000004a4b23723eULL, 0x000fe400000000ffULL,
0x000054102e167816ULL, 0x000fc40000000017ULL, 0x0000000800057811ULL, 0x048fe400078ff0ffULL,
0x0000000200027812ULL, 0x042fe400078ec0ffULL, 0x0000001800097811ULL, 0x000fe200078ff0ffULL,
0x00000008050a7824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x000fe400078ff8ffULL,
0x0000001000057811ULL, 0x000fe200078ff0ffULL, 0x0000000809147824ULL, 0x000fe200078e00ffULL,
0xfffffff80a0a7812ULL, 0x000fc400078ee203ULL, 0x00000002ff077819ULL, 0x004fe20000011600ULL,
0x0000000805127824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x040fe400078ff8ffULL,
0x0000000902057211ULL, 0x040fe200078ff8ffULL, 0x0000000807097824ULL, 0x040fe200078e00ffULL,
0x0000000702047211ULL, 0x000fe200078ff8ffULL, 0x00000008070e7824ULL, 0x040fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee203ULL, 0x0000200020037824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x0000000807057824ULL, 0x000fe200078e00ffULL,
0x0000000204027810ULL, 0x000fc40007ffe0ffULL, 0x0000200003037812ULL, 0x000fe400078ee2ffULL,
0xfffffff809087812ULL, 0x000fe400078ee202ULL, 0xfffffff805027812ULL, 0x000fe200078ee204ULL,
0x000010001a057824ULL, 0x000fe200078e0203ULL, 0x0000000404067810ULL, 0x040fe40007ffe0ffULL,
0x0000000604077810ULL, 0x000fe20007ffe0ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff8090c7812ULL, 0x000fe200078ee206ULL, 0x0000001002067824ULL, 0x000fe200078e0205ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL, 0x000000100a107824ULL, 0x100fe200078e0205ULL,
0x0000000804077812ULL, 0x000fe200078ec0ffULL, 0x00000010080a7824ULL, 0x100fe200078e0205ULL,
0x0000002c2d02723eULL, 0x000fe200000000ffULL, 0x0000001012127824ULL, 0x000fe200078e0205ULL,
0x000000303104723eULL, 0x000fe200000000ffULL, 0x0000000106087824ULL, 0x000fe200078e0207ULL,
0x000000404106723eULL, 0x000fe200000000ffULL, 0x0000001014147824ULL, 0x100fe200078e0205ULL,
0x0000541002187816ULL, 0x100fe20000000004ULL, 0x000000100c0c7824ULL, 0x100fe200078e0205ULL,
0x0000763202197816ULL, 0x000fe20000000004ULL, 0x000000100e0e7824ULL, 0x000fe200078e0205ULL,
0x000000343502723eULL, 0x000fe200000000ffULL, 0x0000000107107824ULL, 0x000fe200078e0210ULL,
0x000000383904723eULL, 0x000fe200000000ffULL, 0x0000001808007388ULL, 0x0003e20000000a00ULL,
0x0000003c3d05723eULL, 0x000fe200000000ffULL, 0x0000000107127824ULL, 0x000fe200078e0212ULL,
0x0000004c4d4c723eULL, 0x000fe200000000ffULL, 0x0000000107147824ULL, 0x000fe200078e0214ULL,
0x000000505126723eULL, 0x000fe200000000ffULL, 0x00000001070a7824ULL, 0x040fe200078e020aULL,
0x000076322e177816ULL, 0x000fe20000000017ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x000000545554723eULL, 0x000fe200000000ffULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x000000444507723eULL, 0x000fc400000000ffULL, 0x000000484908723eULL, 0x002fe400000000ffULL,
0x0000541002187816ULL, 0x140fe40000000004ULL, 0x0000763202197816ULL, 0x000fe40000000004ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x000000180a007388ULL, 0x000fe20000000a00ULL, 0x0000541007067816ULL, 0x000fc40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000000040c007388ULL, 0x0003e20000000a00ULL,
0x00000058592a723eULL, 0x000fe400000000ffULL, 0x000054103e1e7816ULL, 0x140fe2000000001fULL,
0x000000060e007388ULL, 0x0005e20000000a00ULL, 0x000076323e1f7816ULL, 0x000fe4000000001fULL,
0x0000541046227816ULL, 0x140fe20000000023ULL, 0x0000001610007388ULL, 0x0007e20000000a00ULL,
0x0000763246237816ULL, 0x000fc40000000023ULL, 0x0000541054087816ULL, 0x000fe4000000002aULL,
0x0000541036047816ULL, 0x142fe4000000001bULL, 0x0000763236057816ULL, 0x000fe4000000001bULL,
0x000054104c067816ULL, 0x144fe40000000026ULL, 0x000076324c077816ULL, 0x000fe20000000026ULL,
0x000400040a007388ULL, 0x0003e20000000a00ULL, 0x0000763254097816ULL, 0x000fc4000000002aULL,
0x0000005c5d5c723eULL, 0x000fe200000000ffULL, 0x0004001e0c007388ULL, 0x000fe20000000a00ULL,
0x000000606160723eULL, 0x000fe400000000ffULL, 0x000000646564723eULL, 0x000fe200000000ffULL,
0x000400220e007388ULL, 0x000fe20000000a00ULL, 0x000000686932723eULL, 0x000fe400000000ffULL,
0x0000004e4f02723eULL, 0x000fe200000000ffULL, 0x0000000612007388ULL, 0x0005e20000000a00ULL,
0x0000541064107816ULL, 0x008fc40000000032ULL, 0x0000763264117816ULL, 0x000fe20000000032ULL,
0x000800080a007388ULL, 0x0007e20000000a00ULL, 0x000000525304723eULL, 0x002fe400000000ffULL,
0x000000565705723eULL, 0x000fe400000000ffULL, 0x000000ff1a00720cULL, 0x000fe40003f05270ULL,
0x0000005a5b06723eULL, 0x004fe400000000ffULL, 0x000000666707723eULL, 0x000fc400000000ffULL,
0x000054105c087816ULL, 0x148fe40000000060ULL, 0x000076325c097816ULL, 0x000fca0000000060ULL,
0x000800080c007388ULL, 0x0003e80000000a00ULL, 0x000800100e007388ULL, 0x0005e20000000a00ULL,
0x0000006a6b08723eULL, 0x002fe400000000ffULL, 0x0000541002107816ULL, 0x144fe40000000004ULL,
0x0000763202117816ULL, 0x000fe40000000004ULL, 0x0000005e5f02723eULL, 0x000fc400000000ffULL,
0x000000626304723eULL, 0x000fe200000000ffULL, 0x0000001014007388ULL, 0x0003e20000000a00ULL,
0x0000541007227816ULL, 0x000fe40000000008ULL, 0x0000541002187816ULL, 0x140fe40000000004ULL,
0x0000763202197816ULL, 0x000fe20000000004ULL, 0x0000000177027824ULL, 0x000fe200078e0200ULL,
0x0000763207237816ULL, 0x000fc60000000008ULL, 0x0000001002027824ULL, 0x000fe200078e0203ULL,
0x0000541005107816ULL, 0x142fe40000000006ULL, 0x0000763205117816ULL, 0x000fca0000000006ULL,
0x000c00100a007388ULL, 0x000fe80000000a00ULL, 0x000c00180c007388ULL, 0x000fe80000000a00ULL,
0x000c00220e007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000002047984ULL, 0x000e680000000c00ULL, 0x0004000002107984ULL, 0x000ea80000000c00ULL,
0x00080000021c7984ULL, 0x000ee80000000c00ULL, 0x000c000002287984ULL, 0x000ee80000000c00ULL,
0x0010000002087984ULL, 0x000ee80000000c00ULL, 0x0014000002147984ULL, 0x000ee80000000c00ULL,
0x0018000002247984ULL, 0x010ee80000000c00ULL, 0x001c0000022c7984ULL, 0x000ee20000000c00ULL,
0x200000ff07077230ULL, 0x002fc40000000000ULL, 0x200000ff06067230ULL, 0x000fe40000000000ULL,
0x200000ff05057230ULL, 0x000fe40000000000ULL, 0x200000ff04047230ULL, 0x000fe40000000000ULL,
0x200000ff13137230ULL, 0x004fe40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fc40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x008fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fe40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff2b2b7230ULL, 0x000fc40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fe40000000000ULL,
0x200000ff29297230ULL, 0x000fe40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x0000000b07077230ULL, 0x000fe40000000000ULL, 0x0000000a06067230ULL, 0x000fe40000000000ULL,
0x0000000905057230ULL, 0x000fc40000000000ULL, 0x0000000804047230ULL, 0x000fe40000000000ULL,
0x0000001713137230ULL, 0x000fe40000000000ULL, 0x0000001612127230ULL, 0x000fe20000000000ULL,
0x0000000402007388ULL, 0x000fe20000000c00ULL, 0x0000001511117230ULL, 0x000fe40000000000ULL,
0x0000001410107230ULL, 0x000fe40000000000ULL, 0x000000271f1f7230ULL, 0x000fc40000000000ULL,
0x000000261e1e7230ULL, 0x000fe20000000000ULL, 0x0004001002007388ULL, 0x000fe20000000c00ULL,
0x000000251d1d7230ULL, 0x000fe40000000000ULL, 0x000000241c1c7230ULL, 0x000fe40000000000ULL,
0x0000002f2b2b7230ULL, 0x000fe40000000000ULL, 0x0000002e2a2a7230ULL, 0x000fe20000000000ULL,
0x0008001c02007388ULL, 0x000fe20000000c00ULL, 0x0000002d29297230ULL, 0x000fc40000000000ULL,
0x0000002c28287230ULL, 0x000fca0000000000ULL, 0x000c002802007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x000fc80000011600ULL, 0x000000740700720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107027824ULL, 0x100fe200078e0200ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x0000000120117812ULL, 0x000fe200078ec0ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000000702057812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x00000007000e7812ULL, 0x000fe400078ec0ffULL, 0x0ffffff805027812ULL, 0x000fe200078ef800ULL,
0x0000580000067ab9ULL, 0x000fc80000000800ULL, 0x0000001002047824ULL, 0x000fe400078e0203ULL,
0x0000002076027824ULL, 0x000fe400078e0207ULL, 0x0000000811077824ULL, 0x000fe200078e020eULL,
0x0000000004087984ULL, 0x0004e40000000c00ULL, 0x0000000502067c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff057a19ULL, 0x000fe20000011602ULL, 0x00000006040472a4ULL, 0x002fc4000f8e023fULL,
0x0000000175067824ULL, 0x000fc800078e0206ULL, 0x0000008005057224ULL, 0x000fe200078e0206ULL,
0x0000002000067810ULL, 0x000fe20007ffe0ffULL, 0x0000000480027c24ULL, 0x000fc6000f8e02ffULL,
0x00000003ff0d7819ULL, 0x000fe40000011606ULL, 0x0000000502057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x004fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440cULL, 0x000000740d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0083ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x102fe200078e020dULL,
0x00000040000c7810ULL, 0x000fe20007ffe0ffULL, 0x00000020760d7824ULL, 0x000fc600078e020dULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef806ULL,
0x0000000706067812ULL, 0x000fc600078ec0ffULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x000000050d047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000800d0d7224ULL, 0x000fe400078e0204ULL, 0x0000000811077824ULL, 0x002fc600078e0206ULL,
0x0000000d020d7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c000d047a11ULL, 0x000fc800078040ffULL, 0x00005d000d057a11ULL, 0x000fe400000f440eULL,
0x00000003ff0d7819ULL, 0x000fc6000001160cULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000740d00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0043f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c047824ULL, 0x102fe400078e020dULL,
0x00000020760d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050d047c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000800d0d7224ULL, 0x000fca00078e0204ULL, 0x0000000d02057210ULL, 0x000fe40007f1e0ffULL,
0x00000060000d7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x040fe400078040ffULL, 0x00000003ff0f7819ULL, 0x000fe4000001160dULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000740f00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d047824ULL, 0x102fe200078e020fULL,
0x0000008000077810ULL, 0x000fe20007ffe0ffULL, 0x00000020760f7824ULL, 0x000fc600078e020fULL,
0x0000000704047812ULL, 0x000fc800078ec0ffULL, 0x0ffffff804047812ULL, 0x000fe400078ef80dULL,
0x000000070d0d7812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050f047c12ULL, 0x000fe2000f8e30ffULL, 0x00000008110d7824ULL, 0x000fe200078e020dULL,
0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000175047824ULL, 0x000fc800078e0204ULL, 0x000000800f0f7224ULL, 0x000fca00078e0204ULL,
0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c000f047a11ULL, 0x000fc800078040ffULL, 0x00005d000f057a11ULL, 0x000fe400000f440cULL,
0x00000003ff0f7819ULL, 0x000fc60000011607ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x000000740f00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0023f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107047824ULL, 0x102fe200078e020fULL,
0x000000a0000c7810ULL, 0x000fe20007ffe0ffULL, 0x00000020760f7824ULL, 0x000fc600078e020fULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x00000003ff0d7819ULL, 0x000fe4000001160cULL,
0x0ffffff804047812ULL, 0x000fe400078ef807ULL, 0x0000000707077812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050f047c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e0207ULL, 0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000800f0f7224ULL, 0x000fca00078e0204ULL, 0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c000f047a11ULL, 0x000fc800078040ffULL,
0x00005d000f057a11ULL, 0x000fe400000f440eULL, 0x000000740d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c047824ULL, 0x102fe400078e020dULL,
0x00000020760d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050d047c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000800d0d7224ULL, 0x000fca00078e0204ULL, 0x0000000d02057210ULL, 0x000fe40007f1e0ffULL,
0x000000c0000d7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x040fe400078040ffULL, 0x00000003ff0f7819ULL, 0x000fe4000001160dULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000740f00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d047824ULL, 0x102fe200078e020fULL,
0x000000e000007810ULL, 0x000fe20007ffe0ffULL, 0x00000020760f7824ULL, 0x000fc600078e020fULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x00000003ff077819ULL, 0x000fe40000011600ULL,
0x0ffffff804047812ULL, 0x000fe400078ef80dULL, 0x000000070d0d7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050f047c12ULL, 0x000fe2000f8e30ffULL,
0x00000008110d7824ULL, 0x000fe200078e020dULL, 0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000800f0f7224ULL, 0x000fe400078e0204ULL, 0x0000000100067824ULL, 0x002fc600078e0207ULL,
0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c000f047a11ULL, 0x000fc800078040ffULL, 0x00005d000f057a11ULL, 0x000fe400000f440cULL,
0x000000740700720cULL, 0x000fc60003f06070ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x00000007060d7812ULL, 0x000fc800078ec0ffULL, 0xfffffff80d067812ULL, 0x000fe200078ef800ULL,
0x0000000804007986ULL, 0x0043e8000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001006067824ULL, 0x000fe200078e0203ULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x0000002076077824ULL, 0x000fc600078e0207ULL, 0x0000000006087984ULL, 0x002e620000000c00ULL,
0x0000000811057824ULL, 0x000fe200078e0200ULL, 0x0000000507047c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff077a19ULL, 0x000fc60000011607ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x0000008007077224ULL, 0x000fca00078e0204ULL, 0x0000000702077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005c0007027a11ULL, 0x000fc800078040ffULL,
0x00005d0007037a11ULL, 0x000fca00000f4404ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff227819ULL, 0x000fe20000011620ULL, 0xffffffffff0f7424ULL, 0x000fc600078e00ffULL,
0x0000001d2200720cULL, 0x000fda0003f06070ULL, 0x0000000204038824ULL, 0x000fc800078e00ffULL,
0x00006800030a8a24ULL, 0x000fc800078e0222ULL, 0x000064000a0a8625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006c00ff0c7624ULL, 0x000fe200078e00ffULL,
0x000000080a0f8981ULL, 0x000ea2000c1e1900ULL, 0x00006d00ff0d7624ULL, 0x000fc600078e00ffULL,
0x01a60000ff067f8cULL, 0x002e68000c80043fULL, 0x000000080c657981ULL, 0x000722000c1e9900ULL,
0x000001ff0800780cULL, 0x000fe20003f04070ULL, 0x0000008019037824ULL, 0x000fe400078e00ffULL,
0x0000004020237824ULL, 0x000fe400078e00ffULL, 0x000000800e027824ULL, 0x000fc600078e00ffULL,
0x0000004003087812ULL, 0x000fe200078ef823ULL, 0x0000000f02317224ULL, 0x004fc800078e02ffULL,
0x00000c9000000947ULL, 0x000fea0003800000ULL, 0x00000003ff307819ULL, 0x10afe4000001161fULL,
0x0000620031357a11ULL, 0x040fe400078038ffULL, 0x00000004300e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001080a7824ULL, 0x000fe200078e0230ULL, 0x0000000830127810ULL, 0x040fe40007ffe0ffULL,
0x0000000c30167810ULL, 0x000fe20007ffe0ffULL, 0x000000010e0b7824ULL, 0x140fe200078e021fULL,
0x0000630031377a11ULL, 0x000fe200000f3cffULL, 0x000000080e107824ULL, 0x000fe200078e00ffULL,
0x00000014301a7810ULL, 0x000fe20007ffe0ffULL, 0x00000001120c7824ULL, 0x000fe200078e021fULL,
0x0000001c30287810ULL, 0x000fe20007ffe0ffULL, 0x0000000812297824ULL, 0x000fe200078e00ffULL,
0xfffffff810257812ULL, 0x000fe200078ee20bULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000001030107810ULL, 0x000fc40007ffe0ffULL, 0xfffffff829297812ULL, 0x000fe200078ee20cULL,
0x00000001160d7824ULL, 0x000fe200078e021fULL, 0x000000700a147812ULL, 0x000fe200078ef805ULL,
0x00000001100a7824ULL, 0x000fe200078e021fULL, 0x000000231e0c7217ULL, 0x000fe20007800000ULL,
0x00000008102d7824ULL, 0x000fe200078e00ffULL, 0x0000001435147210ULL, 0x000fe20007f1e0ffULL,
0x0000000816187824ULL, 0x000fe200078e00ffULL, 0x0000200020267811ULL, 0x000fe200078e70ffULL,
0x000000010c217824ULL, 0x000fe200078e0a23ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee20aULL,
0x00000001080a7824ULL, 0x000fe200078e020eULL, 0xfffffff8182b7812ULL, 0x000fe200078ee20dULL,
0x00000001080c7824ULL, 0x000fe200078e0212ULL, 0x000000210e00720cULL, 0x080fe20003fa6070ULL,
0x000000010b157824ULL, 0x000fe200000e0637ULL, 0x000000211200720cULL, 0x080fe20003f26070ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000211600720cULL, 0x000fc40003f46070ULL,
0x000000211000720cULL, 0x000fe20003f06070ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x00000020302a7810ULL, 0x040fe40007ffe0ffULL, 0x00000024302c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001080e7824ULL, 0x000fe200078e0216ULL, 0x000000700a167812ULL, 0x100fe200078ef805ULL,
0x0000000108127824ULL, 0x000fe200078e021aULL, 0x000000700c187812ULL, 0x000fe200078ef805ULL,
0x0000000108107824ULL, 0x000fe200078e0210ULL, 0x00000018300c7810ULL, 0x000fe20007ffe0ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000003516167210ULL, 0x000fc40007f7e0ffULL,
0x0000003518187210ULL, 0x000fe20007f9e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fc600078ef805ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x0000007012127812ULL, 0x000fc600078ef805ULL, 0x00000001080a7824ULL, 0x000fe200078e020cULL,
0x0000007010107812ULL, 0x000fe200078ef805ULL, 0x000000010b177824ULL, 0x000fe200018e0637ULL,
0x000000350e0e7210ULL, 0x080fe20007f7e0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000003512127210ULL, 0x000fc60007fde0ffULL, 0x000000010d197824ULL, 0x000fe200020e0637ULL,
0x0000003510107210ULL, 0x000fe20007f9e0ffULL, 0x00000001300d7824ULL, 0x000fe200078e021fULL,
0x000000700a1b7812ULL, 0x000fe200078ef805ULL, 0x000000010f0f7824ULL, 0x100fe200018e0637ULL,
0x000000211a00720cULL, 0x040fe20003f66070ULL, 0x0000000113137824ULL, 0x000fe200030e0637ULL,
0x000000070d247812ULL, 0x000fe200078ec0ffULL, 0x000000011a0a7824ULL, 0x040fe400078e021fULL,
0x000000081a2f7824ULL, 0x000fe200078e00ffULL, 0x000000351b1a7210ULL, 0x000fe20007fde0ffULL,
0x0000000111117824ULL, 0x000fe200020e0637ULL, 0x000000213000720cULL, 0x000fe20003f86070ULL,
0x00000001080d7824ULL, 0x000fe200078e0228ULL, 0x0ffffff824277812ULL, 0x000fe200078ef81fULL,
0x000000010b1b7824ULL, 0x000fe200030e0637ULL, 0xfffffff82f2f7812ULL, 0x000fe200078ee20aULL,
0x000000800d0a7825ULL, 0x000fc800078e00ffULL, 0x0000001027277824ULL, 0x000fe200078e0226ULL,
0x000000700a247812ULL, 0x000fe200078ef805ULL, 0x00000001080d7824ULL, 0x000fe400078e022aULL,
0x000000010c0a7824ULL, 0x040fe200078e021fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014277faeULL, 0x0003e2000e101c48ULL, 0x000000210c00720cULL, 0x040fe20003f86070ULL,
0x000000080c317824ULL, 0x000fe200078e00ffULL, 0x0000003524247210ULL, 0x000fe20007fde0ffULL,
0x000000800d0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff831317812ULL, 0x000fe200078ee20aULL,
0x00000001082e7824ULL, 0x000fe200078e022cULL, 0x000000700c0c7812ULL, 0x000fe200078ef805ULL,
0x0000001029297824ULL, 0x100fe400078e0226ULL, 0x0000001025277824ULL, 0x002fe400078e0226ULL,
0x000000010b257824ULL, 0x000fe200030e0637ULL, 0x000000350c0c7210ULL, 0x000fe20007fde0ffULL,
0x000000802e0a7825ULL, 0x000fe200078e00ffULL, 0x0000000016277faeULL, 0x0003e2000e901c48ULL,
0x000000212800720cULL, 0x000fc40003fa6070ULL, 0x0000000128157824ULL, 0x000fe200078e021fULL,
0x000000700a147812ULL, 0x000fe200078ef805ULL, 0x00000008280a7824ULL, 0x000fe200078e00ffULL,
0x0000002830287810ULL, 0x000fe20007ffe0ffULL, 0x000000010d0d7824ULL, 0x000fe200030e0637ULL,
0x0000003514147210ULL, 0x000fe20007fde0ffULL, 0x000000102b2b7824ULL, 0x000fe200078e0226ULL,
0xfffffff80a337812ULL, 0x000fe200078ee215ULL, 0x00000001080a7824ULL, 0x000fe200078e0228ULL,
0x0000000018297faeULL, 0x0005e2000c901c48ULL, 0x000000010b157824ULL, 0x000fe200030e0637ULL,
0x000000212a00720cULL, 0x080fe20003f26070ULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000000e2b7faeULL, 0x0007e2000d101c48ULL, 0x000000212c00720cULL, 0x000fc40003f46070ULL,
0x000000082c277824ULL, 0x002fe200078e00ffULL, 0x000000700a167812ULL, 0x000fe200078ef805ULL,
0x000000012c0a7824ULL, 0x100fe200078e021fULL, 0x0000003c302c7810ULL, 0x000fe20007ffe0ffULL,
0x000000012a177824ULL, 0x000fe200078e021fULL, 0x0000002c30187810ULL, 0x004fe20007ffe0ffULL,
0x000000082a2a7824ULL, 0x000fe200078e00ffULL, 0x0000003516167210ULL, 0x000fe20007fde0ffULL,
0x000000102d2d7824ULL, 0x000fe200078e0226ULL, 0xfffffff8270f7812ULL, 0x008fe200078ee20aULL,
0x00000001080a7824ULL, 0x000fe200078e0218ULL, 0xfffffff82a197812ULL, 0x000fe200078ee217ULL,
0x000000010b177824ULL, 0x000fe200030e0637ULL, 0x00000000102d7faeULL, 0x0003e2000c101c48ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x00000034302a7810ULL, 0x000fc40007ffe0ffULL,
0x000000212c00720cULL, 0x000fe20003f06070ULL, 0x000000102f2f7824ULL, 0x100fe200078e0226ULL,
0x000000700a0e7812ULL, 0x000fe200078ef805ULL, 0x0000001031317824ULL, 0x100fe400078e0226ULL,
0x0000001033337824ULL, 0x100fe200078e0226ULL, 0x00000000122f7faeULL, 0x0005e2000d901c48ULL,
0x0000001019197824ULL, 0x100fe200078e0226ULL, 0x0000003030107810ULL, 0x002fe20007ffe0ffULL,
0x000000100f0f7824ULL, 0x000fe200078e0226ULL, 0x000000350e0e7210ULL, 0x000fe20007fde0ffULL,
0x000000001a317faeULL, 0x0003e2000e101c48ULL, 0x0000000128117824ULL, 0x100fe200078e021fULL,
0x000000211000720cULL, 0x080fe20003f66070ULL, 0x00000001080a7824ULL, 0x000fe200078e0210ULL,
0x0000000024337faeULL, 0x0007e2000e901c48ULL, 0x000000212800720cULL, 0x0c0fe20003fa6070ULL,
0x0000000828287824ULL, 0x000fe200078e00ffULL, 0x000000211800720cULL, 0x040fe20003f86070ULL,
0x000000000c197faeULL, 0x0007e2000c901c48ULL, 0x0000000118127824ULL, 0x004fc600078e021fULL,
0x00000000140f7faeULL, 0x0005e2000d101c48ULL, 0x00000008101b7824ULL, 0x002fe200078e00ffULL,
0x00000038301a7810ULL, 0x000fe40007ffe0ffULL, 0x000000212a00720cULL, 0x080fe40003f46070ULL,
0x000000211a00720cULL, 0x000fe20003f26070ULL, 0x000000082a217824ULL, 0x000fe400078e00ffULL,
0x00000001080c7824ULL, 0x008fe400078e022aULL, 0x0000000818197824ULL, 0x000fe200078e00ffULL,
0xfffffff828157812ULL, 0x004fe200078ee211ULL, 0x000000010b0f7824ULL, 0x000fc400030e0637ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0xfffffff819197812ULL, 0x000fc600078ee212ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700a137812ULL, 0x000fc600078ef805ULL,
0x00000001100a7824ULL, 0x000fe200078e021fULL, 0x0000003513107210ULL, 0x080fe20007fde0ffULL,
0x0000000108147824ULL, 0x000fe200078e022cULL, 0x000000700c127812ULL, 0x000fe200078ef805ULL,
0x000000012a0c7824ULL, 0x000fe200078e021fULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee20aULL,
0x00000001080a7824ULL, 0x000fe400078e021aULL, 0x000000010b117824ULL, 0x000fe200030e0637ULL,
0x0000003512127210ULL, 0x000fe20007fde0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fc600078ee20cULL, 0x000000010d137824ULL, 0x000fe200030e0637ULL,
0x000000700a0a7812ULL, 0x000fe200078ef805ULL, 0x00000080140c7825ULL, 0x000fc600078e00ffULL,
0x000000350a0a7210ULL, 0x080fe20007fde0ffULL, 0x000000011a087824ULL, 0x000fe200078e021fULL,
0x000000700c0c7812ULL, 0x000fe200078ef805ULL, 0x000000081a257824ULL, 0x000fe400078e00ffULL,
0x000000012c1f7824ULL, 0x040fe400078e021fULL, 0x000000082c2c7824ULL, 0x000fe200078e00ffULL,
0xfffffff825057812ULL, 0x000fe200078ee208ULL, 0x000000010b0b7824ULL, 0x000fe200030e0637ULL,
0x000000350c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001015157824ULL, 0x100fe200078e0226ULL,
0xfffffff82c1f7812ULL, 0x000fe200078ee21fULL, 0x0000001019197824ULL, 0x000fc400078e0226ULL,
0x000000101b1b7824ULL, 0x100fe200078e0226ULL, 0x0000000016157faeULL, 0x0003e2000e901c48ULL,
0x0000001021217824ULL, 0x100fe400078e0226ULL, 0x0000001005057824ULL, 0x100fe200078e0226ULL,
0x000000000e197faeULL, 0x0003e2000e101c48ULL, 0x000000101f1f7824ULL, 0x000fe400078e0226ULL,
0x000000010d0d7824ULL, 0x000fe200030e0637ULL, 0x00000000101b7faeULL, 0x0003e8000d901c48ULL,
0x0000000012217faeULL, 0x0003e8000d101c48ULL, 0x000000000a057faeULL, 0x0003e8000c901c48ULL,
0x000000000c1f7faeULL, 0x0003e2000c101c48ULL, 0x00000b5000007947ULL, 0x000fea0003800000ULL,
0x0000000c1f117811ULL, 0x04afe400078fe8ffULL, 0x000000101f137811ULL, 0x000fc400078fe8ffULL,
0x000000081f0f7811ULL, 0x000fe200078fe8ffULL, 0x00000001110c7824ULL, 0x100fe200078e021fULL,
0x000000041f0d7811ULL, 0x000fe200078fe8ffULL, 0x0000000811177824ULL, 0x000fe200078e00ffULL,
0x000000201f1b7811ULL, 0x000fe200078fe8ffULL, 0x0000000113147824ULL, 0x100fe200078e021fULL,
0x000000281f267811ULL, 0x000fe200078fe8ffULL, 0x0000000813197824ULL, 0x000fe200078e00ffULL,
0xfffffff817127812ULL, 0x000fe200078ee20cULL, 0x000000010f0b7824ULL, 0x100fe200078e021fULL,
0x000000181f177811ULL, 0x000fe200078fe8ffULL, 0x000000080f107824ULL, 0x000fe200078e00ffULL,
0xfffffff819147812ULL, 0x000fe200078ee214ULL, 0x000000010d0a7824ULL, 0x000fe200078e021fULL,
0x0000001c1f197811ULL, 0x000fe200078fe8ffULL, 0x000000080d157824ULL, 0x000fe200078e00ffULL,
0xfffffff810107812ULL, 0x000fe200078ee20bULL, 0x00000001170b7824ULL, 0x100fe200078e021fULL,
0x000000301f2c7811ULL, 0x000fe200078fe8ffULL, 0x0000000817187824ULL, 0x000fe200078e00ffULL,
0xfffffff8150e7812ULL, 0x000fe200078ee20aULL, 0x000000011b217824ULL, 0x000fe200078e021fULL,
0x000000141f157811ULL, 0x000fe200078fe8ffULL, 0x000000081b247824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee20bULL, 0x00000001190c7824ULL, 0x000fe200078e021fULL,
0x0000002c1f287811ULL, 0x000fe200078fe8ffULL, 0x0000000819277824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee221ULL, 0x00000001260b7824ULL, 0x140fe200078e021fULL,
0x000000241f217811ULL, 0x000fe200078fe8ffULL, 0x00000008262a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8271a7812ULL, 0x000fe200078ee20cULL, 0x000000012c297824ULL, 0x040fe200078e021fULL,
0x000000381f2f7811ULL, 0x000fe200078fe8ffULL, 0x000000082c2e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a277812ULL, 0x000fe200078ee20bULL, 0x00000001150a7824ULL, 0x000fe200078e021fULL,
0x0000001f1f0b7211ULL, 0x000fe200078fe8ffULL, 0x0000000815257824ULL, 0x000fe200078e00ffULL,
0xfffffff82e2d7812ULL, 0x000fe200078ee229ULL, 0x00000001280c7824ULL, 0x140fe200078e021fULL,
0x000000341f2e7811ULL, 0x000fe200078fe8ffULL, 0x00000008282b7824ULL, 0x000fe200078e00ffULL,
0xfffffff825167812ULL, 0x000fe200078ee20aULL, 0x00000001210a7824ULL, 0x100fe200078e021fULL,
0x0000003c1f307811ULL, 0x000fe200078fe8ffULL, 0x0000000821257824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee20cULL, 0x00000001083a7824ULL, 0x000fe200078e022eULL,
0x000000070b0c7812ULL, 0x000fe200078ec0ffULL, 0x000000012e0b7824ULL, 0x040fe200078e021fULL,
0xfffffff825257812ULL, 0x000fe200078ee20aULL, 0x000000082e2e7824ULL, 0x000fe200078e00ffULL,
0x000000081f0a7211ULL, 0x000fe200078fe8ffULL, 0x0000000108297824ULL, 0x000fe200078e0219ULL,
0x0ffffff80c0c7812ULL, 0x100fe200078ef81fULL, 0x000000012f197824ULL, 0x100fe200078e021fULL,
0x00002000204d7811ULL, 0x000fe200078e70ffULL, 0x00000001083e7824ULL, 0x000fe200078e0230ULL,
0x00006200314f7a11ULL, 0x000fe200078038ffULL, 0x00000001301f7824ULL, 0x000fc400078e021fULL,
0x00000001080d7824ULL, 0x040fe200078e020dULL, 0x0000630031517a11ULL, 0x000fe200000f3cffULL,
0x00000001080f7824ULL, 0x040fe400078e020fULL, 0x0000000108117824ULL, 0x040fe400078e0211ULL,
0x0000000108137824ULL, 0x040fe400078e0213ULL, 0x0000000108157824ULL, 0x040fe400078e0215ULL,
0x0000000108177824ULL, 0x000fc400078e0217ULL, 0x00000001082a7824ULL, 0x040fe400078e021bULL,
0x0000000108327824ULL, 0x040fe400078e0221ULL, 0x0000000108347824ULL, 0x040fe400078e0226ULL,
0x0000000108367824ULL, 0x040fe400078e0228ULL, 0x0000000108387824ULL, 0x040fe400078e022cULL,
0x00000001083c7824ULL, 0x000fe200078e022fULL, 0xfffffff82e087812ULL, 0x000fe200078ee20bULL,
0x0000000830307824ULL, 0x000fc400078e00ffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0xfffffff8301b7812ULL, 0x000fe200078ee21fULL, 0x000000082f267824ULL, 0x000fe400078e00ffULL,
0x000000100c1f7824ULL, 0x100fe400078e024dULL, 0x00000010183b7824ULL, 0x000fe200078e024dULL,
0x000000700a187812ULL, 0x000fe200078ef805ULL, 0x000000100e217824ULL, 0x000fe200078e024dULL,
0xfffffff826197812ULL, 0x000fe200078ee219ULL, 0x000000800d0c7825ULL, 0x000fe200078e00ffULL,
0x000000184f187210ULL, 0x000fc60007f1e0ffULL, 0x0000001010337824ULL, 0x000fe400078e024dULL,
0x000000800f0e7825ULL, 0x000fc800078e00ffULL, 0x0000008011107825ULL, 0x000fc800078e00ffULL,
0x000000101a3d7824ULL, 0x000fe200078e024dULL, 0x000000700c1a7812ULL, 0x000fe200078ef805ULL,
0x00000010243f7824ULL, 0x000fe200078e024dULL, 0x000000700e247812ULL, 0x000fe200078ef805ULL,
0x0000001012357824ULL, 0x000fe200078e024dULL, 0x0000007010267812ULL, 0x000fe200078ef805ULL,
0x00000010194b7824ULL, 0x000fe200078e024dULL, 0x0000001a4f1a7210ULL, 0x000fe20007f3e0ffULL,
0x0000008013127825ULL, 0x000fe200078e00ffULL, 0x000000264f267210ULL, 0x000fc60007f5e0ffULL,
0x000000010b197824ULL, 0x000fe200000e0651ULL, 0x000000244f247210ULL, 0x000fe20007f1e0ffULL,
0x0000001014377824ULL, 0x000fe200078e024dULL, 0x0000007012287812ULL, 0x000fe200078ef805ULL,
0x0000001016397824ULL, 0x100fe200078e024dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000181f7faeULL, 0x0003e2000b901c48ULL, 0x0000001025417824ULL, 0x100fe400078e024dULL,
0x0000001027437824ULL, 0x100fe400078e024dULL, 0x000000102b457824ULL, 0x000fc400078e024dULL,
0x000000102d477824ULL, 0x100fe400078e024dULL, 0x0000001008497824ULL, 0x100fe400078e024dULL,
0x000000101b4d7824ULL, 0x000fe400078e024dULL, 0x000000010d1b7824ULL, 0x000fe400008e0651ULL,
0x00000080150a7825ULL, 0x000fc600078e00ffULL, 0x000000001a217faeULL, 0x0003e2000b901c48ULL,
0x000000010f257824ULL, 0x000fe200000e0651ULL, 0x000000284f287210ULL, 0x000fe20007f1e0ffULL,
0x00000080170c7825ULL, 0x000fc600078e00ffULL, 0x0000000024337faeULL, 0x0003e2000b901c48ULL,
0x0000000111277824ULL, 0x000fe200010e0651ULL, 0x000000700c2c7812ULL, 0x000fe200078ef805ULL,
0x00000080290e7825ULL, 0x000fc600078e00ffULL, 0x0000002c4f2c7210ULL, 0x000fe20007f3e0ffULL,
0x000000802a107825ULL, 0x000fe200078e00ffULL, 0x000000700a2a7812ULL, 0x100fe200078ef805ULL,
0x0000000026357faeULL, 0x0003e2000b901c48ULL, 0x000000700e2e7812ULL, 0x000fe200078ef805ULL,
0x0000000113297824ULL, 0x000fe200000e0651ULL, 0x0000007010307812ULL, 0x000fe200078ef805ULL,
0x000000010d2d7824ULL, 0x100fe200008e0651ULL, 0x0000002a4f2a7210ULL, 0x040fe20007f1e0ffULL,
0x00000080340c7825ULL, 0x000fe200078e00ffULL, 0x0000002e4f2e7210ULL, 0x040fe20007f5e0ffULL,
0x0000000028377faeULL, 0x0003e2000b901c48ULL, 0x000000304f307210ULL, 0x000fe20007f7e0ffULL,
0x000000010b2b7824ULL, 0x000fe200000e0651ULL, 0x000000700c0c7812ULL, 0x000fe200078ef805ULL,
0x00000080320a7825ULL, 0x000fc600078e00ffULL, 0x0000000c4f0c7210ULL, 0x000fe20007f3e0ffULL,
0x000000010f2f7824ULL, 0x000fe200010e0651ULL, 0x000000700a0a7812ULL, 0x000fe200078ef805ULL,
0x0000000111317824ULL, 0x000fe200018e0651ULL, 0x000000002a397faeULL, 0x0003e2000b901c48ULL,
0x00000080360e7825ULL, 0x000fe200078e00ffULL, 0x0000000a4f0a7210ULL, 0x000fe40007f1e0ffULL,
0x000000002c3b7faeULL, 0x0003e2000b901c48ULL, 0x0000008038107825ULL, 0x000fe200078e00ffULL,
0x000000700e0e7812ULL, 0x000fc400078ef805ULL, 0x000000002e3d7faeULL, 0x0003e2000b901c48ULL,
0x000000803a127825ULL, 0x000fe200078e00ffULL, 0x0000007010107812ULL, 0x100fe400078ef805ULL,
0x0000000e4f0e7210ULL, 0x040fe20007f5e0ffULL, 0x000000803c147825ULL, 0x000fe200078e00ffULL,
0x0000007012127812ULL, 0x100fe200078ef805ULL, 0x00000000303f7faeULL, 0x0003e2000b901c48ULL,
0x000000104f107210ULL, 0x000fe20007f7e0ffULL, 0x000000803e167825ULL, 0x000fe200078e00ffULL,
0x0000007014147812ULL, 0x000fc400078ef805ULL, 0x000000124f127210ULL, 0x000fe20007f9e0ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0651ULL, 0x0000007016057812ULL, 0x000fe200078ef805ULL,
0x000000010d0d7824ULL, 0x100fe200008e0651ULL, 0x000000144f147210ULL, 0x000fe20007fbe0ffULL,
0x000000010f0f7824ULL, 0x100fe200010e0651ULL, 0x000000054f167210ULL, 0x000fe20007fde0ffULL,
0x0000000111117824ULL, 0x100fe200018e0651ULL, 0x000000000a417faeULL, 0x0003e2000b901c48ULL,
0x0000000113137824ULL, 0x100fe400020e0651ULL, 0x0000000115157824ULL, 0x100fe200028e0651ULL,
0x000000000c437faeULL, 0x0003e2000b901c48ULL, 0x0000000117177824ULL, 0x000fc600030e0651ULL,
0x000000000e457faeULL, 0x0003e8000b901c48ULL, 0x0000000010477faeULL, 0x0003e8000b901c48ULL,
0x0000000012497faeULL, 0x0003e8000b901c48ULL, 0x00000000144b7faeULL, 0x0003e8000b901c48ULL,
0x00000000164d7faeULL, 0x0003e4000b901c48ULL, 0x0000000222227810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff1f7424ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000001d2200720cULL, 0x000fda0003f06070ULL, 0x0000000204058824ULL, 0x000fc800078e00ffULL,
0x0000680005088a24ULL, 0x000fc800078e0222ULL, 0x0000640008088625ULL, 0x000fca00078e0009ULL,
0x00000008081f8981ULL, 0x000324000c1e1900ULL, 0x0000000000087805ULL, 0x002fc40000015200ULL,
0x01a60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e09ULL, 0x003d09000a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc8000001140bULL,
0x0000000a05057211ULL, 0x000fca00078110ffULL, 0x000000ffff0a7224ULL, 0x000fca00000e060bULL,
0x0000000205057819ULL, 0x000fc8000000120aULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe40007804807ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002020057824ULL, 0x002fca00078e0205ULL,
0x00000004ff067819ULL, 0x000fe40000011605ULL, 0x0000000105077810ULL, 0x040fe40007ffe0ffULL,
0x0ffffffe06087812ULL, 0x000fe400078ec0ffULL, 0x0000001f05067812ULL, 0x000fc600078ec0ffULL,
0x00000001080a7824ULL, 0x040fe400078e0207ULL, 0x0000000105097824ULL, 0x000fe200078e0208ULL,
0x0000000808087810ULL, 0x000fe20007ffe0ffULL, 0x00000010060b7824ULL, 0x000fe200078e00ffULL,
0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x00000010060c7824ULL, 0x000fe200078e00ffULL,
0x0000000f09097812ULL, 0x000fe200078ec0ffULL, 0x0000000107077824ULL, 0x000fe200078e0208ULL,
0x000001f00b0a7812ULL, 0x000fe200078ee20aULL, 0x0000000105057824ULL, 0x000fe200078e0208ULL,
0x000001f00c097812ULL, 0x000fe200078ee209ULL, 0x0000001006087824ULL, 0x040fe200078e00ffULL,
0x0000000f07077812ULL, 0x000fe200078ec0ffULL, 0x000000000a0c7984ULL, 0x000e62000000cc00ULL,
0x0000001006067824ULL, 0x000fe200078e00ffULL, 0x0000000f05057812ULL, 0x000fc400078ec0ffULL,
0x0000000009107984ULL, 0x000ea4000000cc00ULL, 0x000001f006077812ULL, 0x000fe400078ee207ULL,
0x000001f008057812ULL, 0x000fe200078ee205ULL, 0x000000ffff167224ULL, 0x002fe400078e000cULL,
0x000000ffff177224ULL, 0x000fe400078e000eULL, 0x000000ffff147224ULL, 0x004fe400078e0010ULL,
0x000000ffff157224ULL, 0x000fc400078e0012ULL, 0x000000ffff1a7224ULL, 0x000fe400078e000dULL,
0x000000ffff1b7224ULL, 0x000fe200078e000fULL, 0x0000001409007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff187224ULL, 0x000fe400078e0011ULL, 0x000000ffff197224ULL, 0x000fca00078e0013ULL,
0x000000180a007388ULL, 0x000fe8000000cc00ULL, 0x00000000070c7984ULL, 0x000e68000000cc00ULL,
0x0000000005107984ULL, 0x000ea2000000cc00ULL, 0x000000ffff277224ULL, 0x002fe400078e000eULL,
0x000000ffff267224ULL, 0x000fc400078e000cULL, 0x000000ffff0e7224ULL, 0x000fe400078e000dULL,
0x000000ffff247224ULL, 0x004fe400078e0010ULL, 0x000000ffff257224ULL, 0x000fe400078e0012ULL,
0x000000ffff0c7224ULL, 0x000fe400078e0011ULL, 0x000000ffff0d7224ULL, 0x000fe200078e0013ULL,
0x0000002405007388ULL, 0x0003e8000000cc00ULL, 0x0000000c07007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a60000ff0a7f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0c7224ULL, 0x002fc600078e00ffULL, 0x0000000000067805ULL, 0x000fc80000015200ULL,
0x01a60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x006fc4000780480bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000806087210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc80000011409ULL, 0x0000000805057211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e0609ULL, 0x0000000205057819ULL, 0x000fc80000001208ULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a60400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000217919ULL, 0x000e620000000000ULL,
0x00005800ff607624ULL, 0x000fe200078e00ffULL, 0x800058001e5e7a10ULL, 0x000fe20007ffe0ffULL,
0x00006800045d7a24ULL, 0x000fe200078e02ffULL, 0x0000010023237810ULL, 0x000fe20007ffe0ffULL,
0x3db504f365657820ULL, 0x010fe20000410000ULL, 0x0000001f60047810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff637224ULL, 0x000fe200078e00ffULL, 0xffffffff60617810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff697224ULL, 0x000fe200078e00ffULL, 0x00000004ff047819ULL, 0x000fc40000011604ULL,
0x0001a68820647811ULL, 0x040fe400078e18ffULL, 0x0001a60820627811ULL, 0x000fe400078e28ffULL,
0x0000000960607810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff5e7819ULL, 0x000fe4000001165eULL,
0x0ffffffe045c7812ULL, 0x000fc400078ec0ffULL, 0x0000000263057810ULL, 0x040fe20007ffe0ffULL,
0x0000010063677824ULL, 0x000fe200078e0223ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000001f02297224ULL, 0x010fe200078e02ffULL, 0x0000001c0500720cULL, 0x000fc40003f06070ULL,
0x0000004067047812ULL, 0x000fe400078ec0ffULL, 0x00000001695f7812ULL, 0x000fc600078e0cffULL,
0x0000000103047824ULL, 0x000fcc00078e0204ULL, 0x00000cc000008947ULL, 0x00cfea0003800000ULL,
0x00000003ff247819ULL, 0x002fe20000011621ULL, 0x00000002201a7824ULL, 0x000fe200078e025fULL,
0x0000620029277a11ULL, 0x040fe400078038ffULL, 0x00000004240a7810ULL, 0x040fe40007ffe0ffULL,
0x00000008240c7810ULL, 0x040fe40007ffe0ffULL, 0x0000001024127810ULL, 0x000fe20007ffe0ffULL,
0x000000010a057824ULL, 0x100fe200078e0221ULL, 0x0000000c240e7810ULL, 0x000fe20007ffe0ffULL,
0x000000080a067824ULL, 0x000fe200078e00ffULL, 0x0000630029297a11ULL, 0x000fe200000f3cffULL,
0x000000010c077824ULL, 0x000fe200078e0221ULL, 0x0000001424187810ULL, 0x000fe20007ffe0ffULL,
0x000000080c087824ULL, 0x000fe200078e00ffULL, 0xfffffff806197812ULL, 0x000fe200078ee205ULL,
0x0000000124067824ULL, 0x040fe200078e0204ULL, 0x0000001824267810ULL, 0x000fe20007ffe0ffULL,
0x0000001021057824ULL, 0x000fe200078e00ffULL, 0xfffffff8081f7812ULL, 0x000fe200078ee207ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x000000671e087217ULL, 0x000fc40007800000ULL,
0x00000070052b7812ULL, 0x000fe200078ec0ffULL, 0x00000008122d7824ULL, 0x000fe200078e00ffULL,
0x0000001c242a7810ULL, 0x000fe20007ffe0ffULL, 0x000000010e057824ULL, 0x100fe200078e0221ULL,
0x0000002b06107212ULL, 0x000fe200078efcffULL, 0x0000000112067824ULL, 0x100fe200078e0221ULL,
0x00000020242c7810ULL, 0x000fe20007ffe0ffULL, 0x000000080e147824ULL, 0x000fe200078e00ffULL,
0x0000001027107210ULL, 0x000fe20007f1e0ffULL, 0x0000000126287824ULL, 0x000fe200078e0221ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee206ULL, 0x000000010a067824ULL, 0x000fe200078e0204ULL,
0xfffffff814257812ULL, 0x000fe200078ee205ULL, 0x0000000108057824ULL, 0x000fe200078e0a67ULL,
0x000020001a1a7811ULL, 0x000fe200078e68ffULL, 0x0000000107117824ULL, 0x000fe200000e0629ULL,
0x00000024242e7810ULL, 0x000fe20007ffe0ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x000000050a00720cULL, 0x000fc40003fa6070ULL, 0x000000050c00720cULL, 0x0c0fe20003f26070ULL,
0x000000010c087824ULL, 0x100fe200078e0204ULL, 0x000000051200720cULL, 0x080fe20003f06070ULL,
0x000000010e0a7824ULL, 0x140fe200078e0204ULL, 0x000000050e00720cULL, 0x000fe20003f46070ULL,
0x00000001120c7824ULL, 0x000fe200078e0204ULL, 0x0000002b06127212ULL, 0x000fe200078efcffULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0x0000002712127210ULL, 0x000fe20007f7e0ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000002b0a0a7212ULL, 0x000fc600078efcffULL,
0x00000001180e7824ULL, 0x100fe200078e0204ULL, 0x0000002b08147212ULL, 0x000fe200078efcffULL,
0x0000000126067824ULL, 0x000fe400078e0204ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000002714147210ULL, 0x000fc60007f9e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000002b0c0c7212ULL, 0x000fc600078efcffULL, 0x0000000107137824ULL, 0x000fe200018e0629ULL,
0x000000270a0a7210ULL, 0x000fe20007f7e0ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000002b0e0e7212ULL, 0x000fc600078efcffULL, 0x000000010b0b7824ULL, 0x100fe200018e0629ULL,
0x0000002b06167212ULL, 0x000fe200078efcffULL, 0x0000000109157824ULL, 0x000fe200020e0629ULL,
0x000000270c0c7210ULL, 0x080fe20007f7e0ffULL, 0x0000000124087824ULL, 0x000fe200078e0221ULL,
0x000000270e0e7210ULL, 0x080fe20007f9e0ffULL, 0x000000012a067824ULL, 0x000fe200078e0204ULL,
0x0000002716167210ULL, 0x000fe20007fde0ffULL, 0x000000010d0d7824ULL, 0x100fe200018e0629ULL,
0x0000000708087812ULL, 0x000fe200078ec0ffULL, 0x000000010f0f7824ULL, 0x000fe200020e0629ULL,
0x000000051800720cULL, 0x0c0fe20003f66070ULL, 0x0000000118097824ULL, 0x100fe200078e0221ULL,
0x000000052400720cULL, 0x000fe20003f86070ULL, 0x0000000818187824ULL, 0x000fe200078e00ffULL,
0x0ffffff8081b7812ULL, 0x000fe200078ef821ULL, 0x0000000107177824ULL, 0x000fc400030e0629ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0xfffffff8182f7812ULL, 0x000fc600078ee209ULL,
0x000000012c087824ULL, 0x000fe200078e0204ULL, 0x0000002b06187212ULL, 0x000fe200078efcffULL,
0x000000101b1b7824ULL, 0x000fe400078e021aULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000002718187210ULL, 0x000fe40007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101b7faeULL, 0x0003e2000e101c48ULL, 0x000000012e067824ULL, 0x000fe200078e0204ULL,
0x0000002b08087212ULL, 0x000fe200078efcffULL, 0x0000000826317824ULL, 0x040fe200078e00ffULL,
0x000000052600720cULL, 0x000fe20003f86070ULL, 0x000000101f1f7824ULL, 0x000fe200078e021aULL,
0x0000002824267810ULL, 0x000fc40007ffe0ffULL, 0xfffffff831317812ULL, 0x000fe400078ee228ULL,
0x0000003024287810ULL, 0x000fe20007ffe0ffULL, 0x00000010191b7824ULL, 0x002fe400078e021aULL,
0x0000000107197824ULL, 0x000fe200030e0629ULL, 0x0000002708087210ULL, 0x000fe20007fde0ffULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x00000000121b7faeULL, 0x0003e2000e901c48ULL,
0x000000052a00720cULL, 0x040fe40003fa6070ULL, 0x000000012a117824ULL, 0x000fe200078e0221ULL,
0x0000002b06107212ULL, 0x000fe200078efcffULL, 0x000000082a2a7824ULL, 0x000fe200078e00ffULL,
0x00000000141f7faeULL, 0x0005e2000c901c48ULL, 0x0000000109097824ULL, 0x000fe200030e0629ULL,
0x0000002710107210ULL, 0x000fe20007fde0ffULL, 0x0000000126067824ULL, 0x000fe200078e0204ULL,
0xfffffff82a337812ULL, 0x000fc400078ee211ULL, 0x000000052c00720cULL, 0x000fe20003f26070ULL,
0x0000000107117824ULL, 0x000fe400030e0629ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000002c24147810ULL, 0x004fc60007ffe0ffULL, 0x000000012c137824ULL, 0x102fe200078e0221ULL,
0x0000002b06127212ULL, 0x000fe200078efcffULL, 0x000000082c2c7824ULL, 0x000fe400078e00ffULL,
0x00000010251b7824ULL, 0x100fe200078e021aULL, 0x0000002712127210ULL, 0x000fe20007fde0ffULL,
0x000000012e067824ULL, 0x000fe200078e0221ULL, 0xfffffff82c1f7812ULL, 0x000fe200078ee213ULL,
0x000000082e257824ULL, 0x040fe200078e00ffULL, 0x000000000a1b7faeULL, 0x0003e2000d101c48ULL,
0x000000102d157824ULL, 0x000fe200078e021aULL, 0x000000052e00720cULL, 0x000fe20003f46070ULL,
0x0000000107137824ULL, 0x000fe200030e0629ULL, 0xfffffff825257812ULL, 0x000fe200078ee206ULL,
0x000000102f077824ULL, 0x000fe200078e021aULL, 0x000000000c157faeULL, 0x0005e2000c101c48ULL,
0x0000000114067824ULL, 0x000fc400078e0204ULL, 0x000000101f1f7824ULL, 0x100fe200078e021aULL,
0x000000000e077faeULL, 0x0007e2000d901c48ULL, 0x0000001025257824ULL, 0x100fe200078e021aULL,
0x000000052800720cULL, 0x000fe20003f66070ULL, 0x00000010310b7824ULL, 0x102fe400078e021aULL,
0x00000010331b7824ULL, 0x000fc600078e021aULL, 0x00000000160b7faeULL, 0x0003e2000e101c48ULL,
0x000000051400720cULL, 0x0c0fe20003f86070ULL, 0x00000001140d7824ULL, 0x004fe400078e0221ULL,
0x0000008006067825ULL, 0x008fe200078e00ffULL, 0x00000034240e7810ULL, 0x000fe20007ffe0ffULL,
0x00000000181b7faeULL, 0x0005e2000e901c48ULL, 0x000000052600720cULL, 0x000fe20003fa6070ULL,
0x0000000814147824ULL, 0x000fe200078e00ffULL, 0x0000002b060a7212ULL, 0x000fe200078efcffULL,
0x0000000128067824ULL, 0x000fe200078e0204ULL, 0x00000000081f7faeULL, 0x0007e2000c901c48ULL,
0x0000003824167810ULL, 0x002fe20007ffe0ffULL, 0x0000000828157824ULL, 0x000fe200078e00ffULL,
0x000000270a0a7210ULL, 0x000fe20007fde0ffULL, 0x0000000010257faeULL, 0x0003e2000d101c48ULL,
0x0000003c24247810ULL, 0x000fc40007ffe0ffULL, 0x000000050e00720cULL, 0x080fe20003f46070ULL,
0x00000001070b7824ULL, 0x000fe200030e0629ULL, 0x000000051600720cULL, 0x080fe20003f26070ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x000000052400720cULL, 0x000fc60003f06070ULL,
0x0000000126057824ULL, 0x000fe200078e0221ULL, 0x0000002b060c7212ULL, 0x000fe200078efcffULL,
0x0000000826267824ULL, 0x000fe200078e00ffULL, 0xfffffff814117812ULL, 0x002fe200078ee20dULL,
0x000000010e087824ULL, 0x008fe200078e0204ULL, 0x000000270c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000000128067824ULL, 0x000fe200078e0221ULL, 0xfffffff8260f7812ULL, 0x000fe200078ee205ULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff815157812ULL, 0x000fe200078ee206ULL,
0x0000000116057824ULL, 0x100fe200078e0204ULL, 0x0000002b08087212ULL, 0x000fe200078efcffULL,
0x00000001070d7824ULL, 0x000fe400030e0629ULL, 0x000000010e077824ULL, 0x000fe200078e0221ULL,
0x0000002708087210ULL, 0x000fe20007fde0ffULL, 0x0000000124067824ULL, 0x000fe400078e0204ULL,
0x000000080e0e7824ULL, 0x000fe400078e00ffULL, 0x0000008005047825ULL, 0x000fc600078e00ffULL,
0xfffffff80e177812ULL, 0x000fe200078ee207ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000002b04047212ULL, 0x000fc600078efcffULL, 0x0000000109097824ULL, 0x000fe200030e0629ULL,
0x0000002704047210ULL, 0x000fe20007fde0ffULL, 0x00000001160e7824ULL, 0x100fe200078e0221ULL,
0x0000002b06067212ULL, 0x000fe200078efcffULL, 0x0000000816197824ULL, 0x004fe400078e00ffULL,
0x0000000124107824ULL, 0x040fe400078e0221ULL, 0x00000008241b7824ULL, 0x000fe200078e00ffULL,
0xfffffff819197812ULL, 0x000fe200078ee20eULL, 0x0000000105057824ULL, 0x000fe200030e0629ULL,
0x0000002706067210ULL, 0x000fe20007fde0ffULL, 0x000000100f0f7824ULL, 0x000fe200078e021aULL,
0xfffffff81b1b7812ULL, 0x000fe200078ee210ULL, 0x0000001011117824ULL, 0x000fc400078e021aULL,
0x0000001015157824ULL, 0x100fe200078e021aULL, 0x00000000120f7faeULL, 0x0003e2000e901c48ULL,
0x0000001017177824ULL, 0x100fe400078e021aULL, 0x0000001019197824ULL, 0x100fe200078e021aULL,
0x000000000a117faeULL, 0x0003e2000e101c48ULL, 0x000000101b1b7824ULL, 0x000fe400078e021aULL,
0x0000000107077824ULL, 0x000fe200030e0629ULL, 0x000000000c157faeULL, 0x0003e8000d901c48ULL,
0x0000000008177faeULL, 0x0003e8000d101c48ULL, 0x0000000004197faeULL, 0x0003e8000c901c48ULL,
0x00000000061b7faeULL, 0x0003e2000c101c48ULL, 0x00000b8000007947ULL, 0x000fea0003800000ULL,
0x0000000421067811ULL, 0x042fe400078fe8ffULL, 0x0000000821087811ULL, 0x000fc400078fe8ffULL,
0x00000010210c7811ULL, 0x040fe200078fe8ffULL, 0x0000000106057824ULL, 0x140fe200078e0221ULL,
0x0000000c210a7811ULL, 0x040fe200078fe8ffULL, 0x0000000806147824ULL, 0x000fe200078e00ffULL,
0x00000014210e7811ULL, 0x040fe200078fe8ffULL, 0x0000000108077824ULL, 0x040fe200078e0221ULL,
0x0000001c21107811ULL, 0x040fe200078fe8ffULL, 0x0000000808167824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x000000010c057824ULL, 0x040fe200078e0221ULL,
0x00000018210f7811ULL, 0x040fe200078fe8ffULL, 0x000000080c1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee207ULL, 0x000000010a097824ULL, 0x040fe200078e0221ULL,
0x0000002021117811ULL, 0x040fe200078fe8ffULL, 0x000000080a187824ULL, 0x000fe200078e00ffULL,
0xfffffff81a1a7812ULL, 0x000fe200078ee205ULL, 0x000000010e077824ULL, 0x040fe200078e0221ULL,
0x00000028212e7811ULL, 0x040fe200078fe8ffULL, 0x000000080e247824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee209ULL, 0x0000000110057824ULL, 0x040fe200078e0221ULL,
0x00000024212c7811ULL, 0x000fe200078fe8ffULL, 0x0000000810287824ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee207ULL, 0x000000010f097824ULL, 0x000fe200078e0221ULL,
0x0000002c21307811ULL, 0x000fe200078fe8ffULL, 0x000000080f267824ULL, 0x000fe200078e00ffULL,
0xfffffff828287812ULL, 0x000fe200078ee205ULL, 0x0000000111077824ULL, 0x000fe200078e0221ULL,
0x0000003421347811ULL, 0x000fe200078fe8ffULL, 0x00000008112a7824ULL, 0x000fe200078e00ffULL,
0xfffffff826267812ULL, 0x000fe200078ee209ULL, 0x000000012e057824ULL, 0x040fe200078e0221ULL,
0x0000003021327811ULL, 0x040fe200078fe8ffULL, 0x000000082e3c7824ULL, 0x000fe200078e00ffULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee207ULL, 0x000000012c097824ULL, 0x040fe200078e0221ULL,
0x0000003821367811ULL, 0x040fe200078fe8ffULL, 0x000000082c3a7824ULL, 0x000fe200078e00ffULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee205ULL, 0x0000000130077824ULL, 0x040fe200078e0221ULL,
0x0000003c21387811ULL, 0x000fe200078fe8ffULL, 0x00000008303e7824ULL, 0x000fe200078e00ffULL,
0xfffffff83a3a7812ULL, 0x000fe200078ee209ULL, 0x0000000134057824ULL, 0x040fe200078e0221ULL,
0x00006200294d7a11ULL, 0x040fe200078038ffULL, 0x0000000834427824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3e7812ULL, 0x000fe200078ee207ULL, 0x0000000132097824ULL, 0x040fe200078e0221ULL,
0x00006300294f7a11ULL, 0x000fe200000f3cffULL, 0x0000000832407824ULL, 0x000fe200078e00ffULL,
0xfffffff842427812ULL, 0x000fe200078ee205ULL, 0x0000000136077824ULL, 0x040fe200078e0221ULL,
0x0000002121057211ULL, 0x000fe200078fe8ffULL, 0x0000000836447824ULL, 0x000fe200078e00ffULL,
0xfffffff840407812ULL, 0x000fe200078ee209ULL, 0x0000000138097824ULL, 0x040fe200078e0221ULL,
0x0000000705127812ULL, 0x000fe200078ec0ffULL, 0x0000000838467824ULL, 0x000fe200078e00ffULL,
0xfffffff844447812ULL, 0x000fe200078ee207ULL, 0x0000000220077824ULL, 0x000fe200078e025fULL,
0x0ffffff812127812ULL, 0x000fe200078ef821ULL, 0x0000000106067824ULL, 0x100fe200078e0204ULL,
0xfffffff846467812ULL, 0x000fe200078ee209ULL, 0x0000000108087824ULL, 0x100fe200078e0204ULL,
0x0000200007077811ULL, 0x000fe200078e68ffULL, 0x000000010a0a7824ULL, 0x000fc400078e0204ULL,
0x000000010c0c7824ULL, 0x100fe400078e0204ULL, 0x000000010e0e7824ULL, 0x100fe400078e0204ULL,
0x000000010f0f7824ULL, 0x100fe400078e0204ULL, 0x0000000110107824ULL, 0x100fe400078e0204ULL,
0x0000000111117824ULL, 0x100fe400078e0204ULL, 0x000000012c2c7824ULL, 0x000fc400078e0204ULL,
0x000000012e2e7824ULL, 0x100fe400078e0204ULL, 0x0000000130307824ULL, 0x100fe400078e0204ULL,
0x0000000132327824ULL, 0x100fe400078e0204ULL, 0x0000000134347824ULL, 0x100fe400078e0204ULL,
0x0000000136367824ULL, 0x100fe400078e0204ULL, 0x0000000138387824ULL, 0x000fe200078e0204ULL,
0x0000000421047211ULL, 0x040fe200078fe8ffULL, 0x0000001021057824ULL, 0x000fc400078e00ffULL,
0x00000010121f7824ULL, 0x100fe400078e0207ULL, 0x00000010142d7824ULL, 0x000fe200078e0207ULL,
0x00000070054b7812ULL, 0x000fe200078ec0ffULL, 0x0000008004047825ULL, 0x000fc800078e00ffULL,
0x00000010162f7824ULL, 0x100fe200078e0207ULL, 0x0000004b04127212ULL, 0x000fe200078efcffULL,
0x0000001018317824ULL, 0x100fe400078e0207ULL, 0x000000101a337824ULL, 0x100fe200078e0207ULL,
0x000000124d127210ULL, 0x000fe20007f1e0ffULL, 0x0000001024357824ULL, 0x100fe400078e0207ULL,
0x0000001026377824ULL, 0x100fe400078e0207ULL, 0x0000001028397824ULL, 0x000fc400078e0207ULL,
0x000000102a3b7824ULL, 0x100fe400078e0207ULL, 0x000000103a3d7824ULL, 0x100fe400078e0207ULL,
0x000000103c3f7824ULL, 0x100fe400078e0207ULL, 0x000000103e417824ULL, 0x100fe400078e0207ULL,
0x0000001040437824ULL, 0x100fe400078e0207ULL, 0x0000001042457824ULL, 0x000fc400078e0207ULL,
0x0000001044477824ULL, 0x100fe400078e0207ULL, 0x0000001046497824ULL, 0x000fe400078e0207ULL,
0x0000008006067825ULL, 0x000fc800078e00ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000004b06147212ULL, 0x000fc600078efcffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000004b08167212ULL, 0x080fe400078efcffULL, 0x000000144d147210ULL, 0x000fe20007f3e0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000004b0a187212ULL, 0x000fc600078efcffULL,
0x0000000105137824ULL, 0x100fe200000e064fULL, 0x000000164d167210ULL, 0x000fe20007f1e0ffULL,
0x0000000107157824ULL, 0x100fe200008e064fULL, 0x000000184d187210ULL, 0x000fe20007f5e0ffULL,
0x000000800e047825ULL, 0x000fe200078e00ffULL, 0x0000004b0c1a7212ULL, 0x080fe200078efcffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000121f7faeULL, 0x0003e4000b901c48ULL,
0x0000000109177824ULL, 0x100fe200000e064fULL, 0x0000001a4d1a7210ULL, 0x000fe20007f1e0ffULL,
0x000000800f067825ULL, 0x000fe200078e00ffULL, 0x0000004b04247212ULL, 0x080fe200078efcffULL,
0x00000000142d7faeULL, 0x0003e4000b901c48ULL, 0x000000010b197824ULL, 0x100fe200010e064fULL,
0x0000004b06267212ULL, 0x080fe200078efcffULL, 0x0000008010087825ULL, 0x000fe200078e00ffULL,
0x00000000162f7faeULL, 0x0003e4000b901c48ULL, 0x000000264d267210ULL, 0x000fe20007f3e0ffULL,
0x00000080110a7825ULL, 0x000fe200078e00ffULL, 0x0000004b08287212ULL, 0x080fe200078efcffULL,
0x0000000018317faeULL, 0x0003e4000b901c48ULL, 0x000000010d1b7824ULL, 0x100fe200000e064fULL,
0x0000004b0a2a7212ULL, 0x080fe200078efcffULL, 0x0000000107277824ULL, 0x100fe200008e064fULL,
0x000000244d247210ULL, 0x040fe20007f1e0ffULL, 0x000000802e067825ULL, 0x000fe200078e00ffULL,
0x000000284d287210ULL, 0x040fe20007f5e0ffULL, 0x000000001a337faeULL, 0x0003e2000b901c48ULL,
0x0000002a4d2a7210ULL, 0x000fe20007f7e0ffULL, 0x0000000105257824ULL, 0x000fe200000e064fULL,
0x0000004b06067212ULL, 0x000fe200078efcffULL, 0x000000802c047825ULL, 0x000fc600078e00ffULL,
0x000000064d067210ULL, 0x000fe20007f3e0ffULL, 0x0000000109297824ULL, 0x100fe200010e064fULL,
0x0000004b04047212ULL, 0x080fe200078efcffULL, 0x000000010b2b7824ULL, 0x000fe200018e064fULL,
0x0000000024357faeULL, 0x0003e2000b901c48ULL, 0x0000008030087825ULL, 0x000fe200078e00ffULL,
0x000000044d047210ULL, 0x000fe40007f1e0ffULL, 0x0000000026377faeULL, 0x0003e2000b901c48ULL,
0x00000080320a7825ULL, 0x000fe200078e00ffULL, 0x0000004b08087212ULL, 0x000fc400078efcffULL,
0x0000000028397faeULL, 0x0003e2000b901c48ULL, 0x00000080340c7825ULL, 0x000fe200078e00ffULL,
0x0000004b0a0a7212ULL, 0x080fe400078efcffULL, 0x000000084d087210ULL, 0x040fe20007f5e0ffULL,
0x00000080360e7825ULL, 0x000fe200078e00ffULL, 0x0000004b0c0c7212ULL, 0x080fe200078efcffULL,
0x000000002a3b7faeULL, 0x0003e2000b901c48ULL, 0x0000000a4d0a7210ULL, 0x000fe20007f7e0ffULL,
0x0000008038107825ULL, 0x000fe200078e00ffULL, 0x0000004b0e0e7212ULL, 0x000fc400078efcffULL,
0x0000000c4d0c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000105057824ULL, 0x100fe200000e064fULL,
0x0000004b10107212ULL, 0x000fe200078efcffULL, 0x0000000107077824ULL, 0x100fe200008e064fULL,
0x0000000e4d0e7210ULL, 0x000fe20007fbe0ffULL, 0x0000000109097824ULL, 0x100fe200010e064fULL,
0x000000104d107210ULL, 0x000fe20007fde0ffULL, 0x000000010b0b7824ULL, 0x100fe200018e064fULL,
0x00000000043d7faeULL, 0x0003e2000b901c48ULL, 0x000000010d0d7824ULL, 0x100fe400020e064fULL,
0x000000010f0f7824ULL, 0x100fe200028e064fULL, 0x00000000063f7faeULL, 0x0003e2000b901c48ULL,
0x0000000111117824ULL, 0x000fc600030e064fULL, 0x0000000008417faeULL, 0x0003e8000b901c48ULL,
0x000000000a437faeULL, 0x0003e8000b901c48ULL, 0x000000000c457faeULL, 0x0003e8000b901c48ULL,
0x000000000e477faeULL, 0x0003e8000b901c48ULL, 0x0000000010497faeULL, 0x0003e4000b901c48ULL,
0x0000000222227810ULL, 0x000fe20007ffe0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff1f7424ULL, 0x002fc400078e00ffULL, 0x0000001d2200720cULL, 0x000fe20003f06070ULL,
0x000000ffff667224ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fd4000001ff00ULL, 0x000000025d0c8824ULL, 0x000fe400078e0222ULL,
0x00000004ff0d8424ULL, 0x000fc800078e00ffULL, 0x000064000c0c8625ULL, 0x000fe200078e000dULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x00000000000e7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x000000080c1f8981ULL, 0x000322000c1e1900ULL, 0x0000000000107805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x0000000000147805ULL, 0x000fe2000001ff00ULL,
0x00000000001a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000000c7805ULL, 0x002fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff8214c7812ULL, 0x020fe200078ec0ffULL, 0x00000002207f7824ULL, 0x000fe200078e0269ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000166807810ULL, 0x000fc40007ffe0ffULL,
0x000000074c517812ULL, 0x100fe400078ef821ULL, 0x000020007f7f7811ULL, 0x000fe400078e68ffULL,
0x00000004ff857819ULL, 0x000fe20000011621ULL, 0x00000001514c7824ULL, 0x040fe400078e0266ULL,
0x00000008514d7824ULL, 0x040fe400078e00ffULL, 0x0000000851507824ULL, 0x040fe400078e00ffULL,
0x0000000151517824ULL, 0x000fe200078e0280ULL, 0xfffffff84d4c7812ULL, 0x000fe200078ee24cULL,
0x0000000266857824ULL, 0x000fc600078e0285ULL, 0xfffffff850507812ULL, 0x000fe200078ee251ULL,
0x000000104c4c7824ULL, 0x000fc800078e027fULL, 0x0000001050507824ULL, 0x000fe400078e027fULL,
0x000000004c4c783bULL, 0x000e680000000200ULL, 0x000000005050783bULL, 0x000ea20000000200ULL,
0x00000018ff547819ULL, 0x002fe2000001144cULL, 0x000100004c567824ULL, 0x040fe200078e00ffULL,
0x000088804c557816ULL, 0x040fe200000000ffULL, 0x000001004c4c7824ULL, 0x000fe200078e00ffULL,
0x0000005400887306ULL, 0x0003e20000200c00ULL, 0x00000018ff847819ULL, 0x000fe2000001144dULL,
0x000100004d5a7824ULL, 0x040fe200078e00ffULL, 0x000088804d597816ULL, 0x040fe200000000ffULL,
0x000001004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fc40000011456ULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000005500867306ULL, 0x000fe20000200c00ULL,
0x0000002021547810ULL, 0x002fe40007ffe0ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0xfffffff854547812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7d7819ULL, 0x000fe2000001144eULL,
0x0000005800897306ULL, 0x0003e20000200c00ULL, 0x0000000754877812ULL, 0x000fc400078ef821ULL,
0x00000018ff7b7819ULL, 0x000fe4000001144fULL, 0x00000018ff687819ULL, 0x004fe20000011450ULL,
0x0000000187547824ULL, 0x000fe200078e0266ULL, 0x000088804f817816ULL, 0x000fe200000000ffULL,
0x0000004c008b7306ULL, 0x0005e20000200c00ULL, 0x000100004e587824ULL, 0x002fe200078e00ffULL,
0x00008880506d7816ULL, 0x000fe200000000ffULL, 0x0000000887577824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x00000018ff587819ULL, 0x000fc40000011458ULL,
0x0000004d008f7306ULL, 0x0003e20000200c00ULL, 0x000088804e4c7816ULL, 0x044fe200000000ffULL,
0x000001004e4e7824ULL, 0x000fe200078e00ffULL, 0xfffffff857547812ULL, 0x000fe400078ee254ULL,
0x00000018ff6c7819ULL, 0x000fe40000011451ULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000004c008c7306ULL, 0x0005e20000200c00ULL, 0x000100004f4d7824ULL, 0x002fe200078e00ffULL,
0x0000888051707816ULL, 0x000fe200000000ffULL, 0x000001004f4f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe20000011452ULL, 0x0000001054547824ULL, 0x000fe200078e027fULL,
0x00000018ff4d7819ULL, 0x000fc4000001144dULL, 0x0000004e008e7306ULL, 0x0003e20000200c00ULL,
0x00010000504c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000010050507824ULL, 0x000fe200078e00ffULL, 0x000000005454783bULL, 0x000ea20000000200ULL,
0x0000888052717816ULL, 0x000fe400000000ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000004d00907306ULL, 0x0007e20000200c00ULL, 0x00000008214e7812ULL, 0x002fe400078ec0ffULL,
0x00000018ff507819ULL, 0x000fc40000011450ULL, 0x000000074e837812ULL, 0x000fe200078ef821ULL,
0x00010000524e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe20000011453ULL,
0x0000004f00927306ULL, 0x0003e20000200c00ULL, 0x00010000514d7824ULL, 0x008fe200078e00ffULL,
0x0000001083827812ULL, 0x000fe200078efcffULL, 0x0000010051517824ULL, 0x000fe200078e00ffULL,
0x00000018ff727819ULL, 0x000fe2000001144eULL, 0x0000010052527824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000004c006e7306ULL, 0x0007e20000200c00ULL,
0x00000010834f7824ULL, 0x002fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fc40000011451ULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x0000888053767816ULL, 0x000fe400000000ffULL,
0x00000050006f7306ULL, 0x0003e20000200c00ULL, 0x00000001834c7824ULL, 0x008fe200078e0285ULL,
0x0000000266667810ULL, 0x000fc80007ffe0ffULL, 0xfffffff04f4c7812ULL, 0x000fe400078ee24cULL,
0x0000004d00757306ULL, 0x0007e20000200c00ULL, 0x0000001082507824ULL, 0x002fe200078e00ffULL,
0x000000086600780cULL, 0x000fe40003f05270ULL, 0x00000018ff7e7819ULL, 0x004fe40000011454ULL,
0x00000018ff7c7819ULL, 0x000fe40000011455ULL, 0x0000005800917306ULL, 0x0002a20000200c00ULL,
0x00000001824d7824ULL, 0x008fe200078e0285ULL, 0x00000018ff7a7819ULL, 0x000fc40000011456ULL,
0x00000018ff787819ULL, 0x000fe40000011457ULL, 0xfffffff0504d7812ULL, 0x000fe200078ee24dULL,
0x0001000053507824ULL, 0x000fe200078e00ffULL, 0x00000059008a7306ULL, 0x000fe20000200c00ULL,
0x000000104c587824ULL, 0x002fe400078e00ffULL, 0x000000104d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff797819ULL, 0x000fe20000011450ULL, 0x0000010053537824ULL, 0x000fe200078e00ffULL,
0x0000888054507816ULL, 0x000fc400000000ffULL, 0x0000005a008d7306ULL, 0x0002e20000200c00ULL,
0x000000004d4c783bULL, 0x000ee20000000200ULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x000054108c8c7816ULL, 0x004fc80000000091ULL, 0x0000005100737306ULL, 0x0005e20000200c00ULL,
0x000000005858783bULL, 0x002e6e0000000200ULL, 0x0000005200747306ULL, 0x0007e20000200c00ULL,
0x0001000054517824ULL, 0x004fe200078e00ffULL, 0x000054108a8a7816ULL, 0x008fc8000000008dULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000005000937306ULL, 0x0005e20000200c00ULL,
0x0000010054527824ULL, 0x000fca00078e00ffULL, 0x00000018ff527819ULL, 0x000fe40000011452ULL,
0x0000005100547306ULL, 0x0007e20000200c00ULL, 0x0000541086507816ULL, 0x004fe20000000089ULL,
0x0001000055867824ULL, 0x000fca00078e00ffULL, 0x00000018ff867819ULL, 0x000fe20000011486ULL,
0x0000008400847306ULL, 0x000ea20000200c00ULL, 0x000054108b517816ULL, 0x008fce0000000088ULL,
0x000000504c28723cULL, 0x080fe20000001828ULL, 0x0000005200957306ULL, 0x0007ee0000200c00ULL,
0x000000505848723cULL, 0x002b620000001848ULL, 0x0000007b007b7306ULL, 0x000e620000200c00ULL,
0x0000000887527824ULL, 0x008fe200078e00ffULL, 0x000054108f8b7816ULL, 0x004fe20000000084ULL,
0x0001000056847824ULL, 0x000fc600078e00ffULL, 0x0000010055507824ULL, 0x020fe400078e00ffULL,
0x0000000187517824ULL, 0x000fe200078e0280ULL, 0x0000007d007d7306ULL, 0x000ea20000200c00ULL,
0x00000018ff847819ULL, 0x000fe20000011484ULL, 0x0000008a5844723cULL, 0x080f620000001844ULL,
0x00000018ff807819ULL, 0x000fe40000011450ULL, 0xfffffff852507812ULL, 0x000fe400078ee251ULL,
0x0000888056517816ULL, 0x040fe200000000ffULL, 0x0000005300777306ULL, 0x0007e20000200c00ULL,
0x0000010056567824ULL, 0x000fe200078e00ffULL, 0x0000541092917816ULL, 0x002fe2000000007bULL,
0x0000001050507824ULL, 0x000fe200078e027fULL, 0x0000008a4c24723cULL, 0x000b620000001824ULL,
0x000000ffff7f7224ULL, 0x000fe200078e0051ULL, 0x00000018ff567819ULL, 0x000fc40000011456ULL,
0x0000008000877306ULL, 0x0003e20000200c00ULL, 0x0000888055537816ULL, 0x008fe400000000ffULL,
0x000054108e8d7816ULL, 0x004fca000000007dULL, 0x0000008600557306ULL, 0x000fe20000200c00ULL,
0x0000888057807816ULL, 0x002fe200000000ffULL, 0x0000008c5840723cULL, 0x080fe80000001840ULL,
0x000000ffff7b7224ULL, 0x000fe200078e0080ULL, 0x0000541093807816ULL, 0x000fe20000000054ULL,
0x0000007f00867306ULL, 0x0003e20000200c00ULL, 0x0000000285547810ULL, 0x000fe20007ffe0ffULL,
0x0000008c4c18723cULL, 0x000fec0000001818ULL, 0x0000008100817306ULL, 0x000ea20000200c00ULL,
0x00010000577f7824ULL, 0x002fc400078e00ffULL, 0x0000010057577824ULL, 0x000fc600078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe4000001147fULL, 0x0000007e007e7306ULL, 0x000e620000200c00ULL,
0x00000018ff577819ULL, 0x000fce0000011457ULL, 0x0000005300887306ULL, 0x0006620000200c00ULL,
0x0000541081907816ULL, 0x004fce0000000090ULL, 0x0000007c007c7306ULL, 0x000ea20000200c00ULL,
0x000000005050783bULL, 0x008ee20000000200ULL, 0x0000541095817816ULL, 0x002fe2000000007eULL,
0x00000090583c723cULL, 0x040f6a000000183cULL, 0x0000007b008a7306ULL, 0x020fe20000200c00ULL,
0x00005410887e7816ULL, 0x000fe20000000055ULL, 0x0000001082557824ULL, 0x000fe200078e00ffULL,
0x000000805838723cULL, 0x000fea0000001838ULL, 0x0000007f008b7306ULL, 0x0004660000200c00ULL,
0x000000904c14723cULL, 0x000f6a0000001814ULL, 0x0000007a007a7306ULL, 0x000fe20000200c00ULL,
0x00005410877f7816ULL, 0x004fc4000000007cULL, 0x000000804c10723cULL, 0x000fea0000001810ULL,
0x0000007800787306ULL, 0x000fe20000200c00ULL, 0x000054108a8a7816ULL, 0x002fe4000000008bULL,
0x0000007e5834723cULL, 0x000f6a0000001834ULL, 0x00000084007d7306ULL, 0x0002a20000200c00ULL,
0x00000018ff7c7819ULL, 0x008fc40000011451ULL, 0x0000007e4c0c723cULL, 0x000fe2000000180cULL,
0x00000018ff7b7819ULL, 0x000fc80000011450ULL, 0x0000005600897306ULL, 0x0006a20000200c00ULL,
0x00000018ff847819ULL, 0x002fce0000011453ULL, 0x0000005700857306ULL, 0x000e620000200c00ULL,
0x0000001083567824ULL, 0x048fe200078e00ffULL, 0x0000541086867816ULL, 0x004fe2000000007dULL,
0x0000000183837824ULL, 0x000fe200078e0254ULL, 0x00000018ff7d7819ULL, 0x000fe20000011452ULL,
0x0000000182547824ULL, 0x000fc600078e0254ULL, 0xfffffff056837812ULL, 0x000fe200078ee283ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0xfffffff055557812ULL, 0x000fe400078ee254ULL,
0x0000541089877816ULL, 0x000fe2000000007aULL, 0x0000001083547824ULL, 0x000fe400078e00ffULL,
0x00000010557a7824ULL, 0x000fe200078e00ffULL, 0x00005410858b7816ULL, 0x002fe20000000078ULL,
0x0000007000707306ULL, 0x000fe20000200c00ULL, 0x0000888050787816ULL, 0x000fe200000000ffULL,
0x000000865830723cULL, 0x040f620000001830ULL, 0x000000005454783bULL, 0x000e6a0000000200ULL,
0x0000006800687306ULL, 0x000ea40000200c00ULL, 0x0000008a582c723cULL, 0x000b64000000182cULL,
0x000000007a58783bULL, 0x0206680000000200ULL, 0x0000006b006b7306ULL, 0x000fe40000200c00ULL,
0x000000864c08723cULL, 0x000f620000001808ULL, 0x00008880517a7816ULL, 0x008fca00000000ffULL,
0x0000006a006a7306ULL, 0x000ee20000200c00ULL, 0x000054106f6f7816ULL, 0x004fe20000000068ULL,
0x0000008a4c04723cULL, 0x000b620000001804ULL, 0x0000888052687816ULL, 0x000fca00000000ffULL,
0x0000006d006d7306ULL, 0x000ea20000200c00ULL, 0x00010000514d7824ULL, 0x060fe400078e00ffULL,
0x000000ffff4c7224ULL, 0x000fe400078e007aULL, 0x0000010051517824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000004c004e7306ULL, 0x0005e20000200c00ULL,
0x0000541077777816ULL, 0x008fe4000000006aULL, 0x00000018ff517819ULL, 0x000fca0000011451ULL,
0x0000004d004f7306ULL, 0x0006620000200c00ULL, 0x00005410704c7816ULL, 0x004fe40000000075ULL,
0x000054106d6e7816ULL, 0x000fca000000006eULL, 0x0000007c00827306ULL, 0x0005e20000200c00ULL,
0x00005410734d7816ULL, 0x008fe2000000006cULL, 0x00010000526c7824ULL, 0x000fe200078e00ffULL,
0x0000541074737816ULL, 0x000fe2000000006bULL, 0x00010000536b7824ULL, 0x000fe200078e00ffULL,
0x0000006e5448723cULL, 0x042f620000001848ULL, 0x0000010052527824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe2000001146cULL, 0x0000007600767306ULL, 0x000fe20000200c00ULL,
0x00010000507c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff6b7819ULL, 0x000fe2000001146bULL,
0x0000010050507824ULL, 0x000fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe20000011452ULL,
0x0000004c5444723cULL, 0x000f620000001844ULL, 0x00000018ff7c7819ULL, 0x000fc4000001147cULL,
0x00000018ff507819ULL, 0x000fe20000011450ULL, 0x0000007900797306ULL, 0x000e620000200c00ULL,
0x000054104e4e7816ULL, 0x000fc6000000004fULL, 0x0000004c5824723cULL, 0x040b680000001824ULL,
0x0000007d00837306ULL, 0x000fe60000200c00ULL, 0x00008880534c7816ULL, 0x060fe200000000ffULL,
0x0000010053537824ULL, 0x000fe200078e00ffULL, 0x0000006e5828723cULL, 0x000b660000001828ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x00000018ff537819ULL, 0x000fc40000011453ULL,
0x0000541076767816ULL, 0x002fca0000000079ULL, 0x0000006c004d7306ULL, 0x000fe40000200c00ULL,
0x00000076543c723cULL, 0x080b6c000000183cULL, 0x0000007100717306ULL, 0x000fe40000200c00ULL,
0x000000765814723cULL, 0x000b6c0000001814ULL, 0x0000007200727306ULL, 0x000e700000200c00ULL,
0x0000007b007b7306ULL, 0x000ff00000200c00ULL, 0x0000008400847306ULL, 0x000fe20000200c00ULL,
0x0000541071727816ULL, 0x002fce0000000072ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x000000725440723cULL, 0x080b6e0000001840ULL, 0x0000007c007d7306ULL, 0x000e620000200c00ULL,
0x000000725818723cULL, 0x000b6e0000001818ULL, 0x0000005000507306ULL, 0x000eb00000200c00ULL,
0x0000005100517306ULL, 0x000ee20000200c00ULL, 0x0000541078787816ULL, 0x002fce000000007dULL,
0x0000005200527306ULL, 0x000e620000200c00ULL, 0x0000541050797816ULL, 0x004fce000000007bULL,
0x0000004c006d7306ULL, 0x0005e20000200c00ULL, 0x00005410514f7816ULL, 0x008fe20000000082ULL,
0x000000785438723cULL, 0x040b6c0000001838ULL, 0x0000006b006a7306ULL, 0x000ee20000200c00ULL,
0x00005410684c7816ULL, 0x004fe2000000004dULL, 0x0000004e5434723cULL, 0x000b620000001834ULL,
0x00005410524d7816ULL, 0x002fca0000000083ULL, 0x0000005300537306ULL, 0x000e640000200c00ULL,
0x0000004c5430723cULL, 0x000b620000001830ULL, 0x000054106d6a7816ULL, 0x008fce000000006aULL,
0x000000785810723cULL, 0x000b620000001810ULL, 0x00005410536b7816ULL, 0x002fce0000000084ULL,
0x0000004e580c723cULL, 0x000b70000000180cULL, 0x0000006a542c723cULL, 0x000b70000000182cULL,
0x0000004c5808723cULL, 0x040b700000001808ULL, 0x0000006a5804723cULL, 0x000b620000001804ULL,
0x0000001000008944ULL, 0x000fe20003c00000ULL, 0xffffee2000007947ULL, 0x000fcc000383ffffULL,
0x0000006548577220ULL, 0x0a0fe40000410000ULL, 0x0000006549567220ULL, 0x000fc40000410000ULL,
0x000000654a487220ULL, 0x080fe40000410000ULL, 0x000000654b497220ULL, 0x080fe40000410000ULL,
0x0000006546467220ULL, 0x080fe40000410000ULL, 0x000000653f3f7220ULL, 0x080fe40000410000ULL,
0x0000006538597220ULL, 0x080fe40000410000ULL, 0x0000006547477220ULL, 0x000fc40000410000ULL,
0x0000006542427220ULL, 0x080fe40000410000ULL, 0x0000006543437220ULL, 0x080fe40000410000ULL,
0x000000653e3e7220ULL, 0x080fe40000410000ULL, 0x000000653a3a7220ULL, 0x080fe40000410000ULL,
0x000000653b3b7220ULL, 0x080fe40000410000ULL, 0x0000006536367220ULL, 0x000fc40000410000ULL,
0x0000006537377220ULL, 0x080fe40000410000ULL, 0x000000652e387220ULL, 0x080fe40000410000ULL,
0x0000006528287220ULL, 0x080fe40000410000ULL, 0x0000006529297220ULL, 0x080fe40000410000ULL,
0x0000006525257220ULL, 0x080fe40000410000ULL, 0x0000006518187220ULL, 0x000fc40000410000ULL,
0x0000006519197220ULL, 0x080fe40000410000ULL, 0x0000006515157220ULL, 0x080fe40000410000ULL,
0x0000006510107220ULL, 0x080fe40000410000ULL, 0x000000650d0d7220ULL, 0x080fe40000410000ULL,
0x0000006508087220ULL, 0x080fe40000410000ULL, 0x0000006545547220ULL, 0x000fc40000410000ULL,
0x00000065344f7220ULL, 0x080fe40000410000ULL, 0x00000065354e7220ULL, 0x080fe40000410000ULL,
0x00000065304d7220ULL, 0x080fe40000410000ULL, 0x000000652b5b7220ULL, 0x080fe40000410000ULL,
0x0000006539507220ULL, 0x080fe40000410000ULL, 0x00000065314c7220ULL, 0x000fc40000410000ULL,
0x000000652c4b7220ULL, 0x080fe40000410000ULL, 0x000000652d4a7220ULL, 0x080fe40000410000ULL,
0x000000652f457220ULL, 0x000fe40000410000ULL, 0x000000ffff347224ULL, 0x000fe400078e0048ULL,
0x000000ffff357224ULL, 0x000fe400078e0049ULL, 0x000000ffff2b7224ULL, 0x000fc400078e0046ULL,
0x000000ffff307224ULL, 0x000fe400078e003fULL, 0x0000006544557220ULL, 0x080fe40000410000ULL,
0x0000006540537220ULL, 0x080fe40000410000ULL, 0x0000006541527220ULL, 0x080fe40000410000ULL,
0x000000653c517220ULL, 0x080fe40000410000ULL, 0x000000653d587220ULL, 0x000fc40000410000ULL,
0x000000652a5a7220ULL, 0x080fe40000410000ULL, 0x0000006514397220ULL, 0x000fe40000410000ULL,
0x000000ffff2d7224ULL, 0x000fe400078e0047ULL, 0x000000ffff2c7224ULL, 0x000fe400078e0042ULL,
0x000000ffff497224ULL, 0x000fe400078e0043ULL, 0x000000ffff2e7224ULL, 0x000fc400078e003eULL,
0x000000ffff2f7224ULL, 0x000fe400078e003aULL, 0x000000ffff487224ULL, 0x000fe400078e003bULL,
0x000000ffff317224ULL, 0x000fe400078e0036ULL, 0x000000ffff3f7224ULL, 0x000fe400078e0037ULL,
0x000000ffff467224ULL, 0x000fe400078e0038ULL, 0x0000006532327220ULL, 0x000fc40000410000ULL,
0x0000006533337220ULL, 0x080fe40000410000ULL, 0x00000065242a7220ULL, 0x080fe40000410000ULL,
0x0000006526267220ULL, 0x080fe40000410000ULL, 0x0000006527667220ULL, 0x080fe40000410000ULL,
0x000000651a1a7220ULL, 0x080fe40000410000ULL, 0x000000651b687220ULL, 0x000fc40000410000ULL,
0x0000006516167220ULL, 0x080fe40000410000ULL, 0x0000006517177220ULL, 0x080fe40000410000ULL,
0x00000065113c7220ULL, 0x080fe40000410000ULL, 0x0000006512127220ULL, 0x080fe40000410000ULL,
0x0000006513137220ULL, 0x080fe40000410000ULL, 0x000000650c3d7220ULL, 0x000fc40000410000ULL,
0x000000650e0e7220ULL, 0x080fe40000410000ULL, 0x000000650f0f7220ULL, 0x080fe40000410000ULL,
0x0000006509407220ULL, 0x080fe40000410000ULL, 0x000000650a147220ULL, 0x080fe40000410000ULL,
0x000000650b0b7220ULL, 0x080fe40000410000ULL, 0x0000006504417220ULL, 0x000fc40000410000ULL,
0x0000006505447220ULL, 0x080fe40000410000ULL, 0x0000006506067220ULL, 0x080fe40000410000ULL,
0x0000006507077220ULL, 0x000fe40000410000ULL, 0x000000ffff437224ULL, 0x000fe400078e0028ULL,
0x000000ffff427224ULL, 0x000fe400078e0029ULL, 0x000000ffff367224ULL, 0x000fc400078e0025ULL,
0x000000ffff377224ULL, 0x000fe400078e0018ULL, 0x000000ffff387224ULL, 0x000fe400078e0019ULL,
0x000000ffff3a7224ULL, 0x000fe400078e0015ULL, 0x000000ffff3b7224ULL, 0x000fe400078e0010ULL,
0x000000ffff3e7224ULL, 0x000fe400078e000dULL, 0x000000ffff477224ULL, 0x000fe200078e0008ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000064087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1b7224ULL, 0x000fc400078e0026ULL, 0x000000ffff287224ULL, 0x000fe400078e001aULL,
0x000000ffff267224ULL, 0x000fe400078e0016ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0017ULL,
0x000000ffff197224ULL, 0x000fe400078e0012ULL, 0x000000ffff187224ULL, 0x000fe400078e0013ULL,
0x000000ffff247224ULL, 0x000fc400078e005aULL, 0x000000ffff277224ULL, 0x000fe400078e005bULL,
0x000000ffff257224ULL, 0x000fe400078e0066ULL, 0x000000ffff297224ULL, 0x000fe400078e0068ULL,
0x000000ffff127224ULL, 0x000fe400078e000eULL, 0x000000ffff137224ULL, 0x000fe400078e000fULL,
0x000000ffff157224ULL, 0x000fc400078e000bULL, 0x000000ffff167224ULL, 0x000fe400078e0006ULL,
0x000000ffff177224ULL, 0x000fc400078e0007ULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x0000040064077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040064077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000421117824ULL, 0x000fe200078e00ffULL, 0x0000005e6300720cULL, 0x000fc80003f06070ULL,
0xfffffff011057812ULL, 0x000fca00078ec0ffULL, 0x0000008020107824ULL, 0x000fca00078e0205ULL,
0x01a4000010047984ULL, 0x0002a20000000c00ULL, 0x00001f6000008947ULL, 0x000fea0003800000ULL,
0x00000002215b7824ULL, 0x000fe200078e00ffULL, 0xffffff0067677810ULL, 0x000fe20007ffe0ffULL,
0x00000002ff7c7424ULL, 0x000fe200078e00ffULL, 0x0000000021087211ULL, 0x000fe400078ff0ffULL,
0x000000671e5a7217ULL, 0x000fe40007800000ULL, 0x000000065b5b7812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff0a7a19ULL, 0x000fe20000011608ULL, 0x000000015a5a7824ULL, 0x000fe200078e0a67ULL,
0x000058005b677a10ULL, 0x000fe20007ffe0ffULL, 0x0000000160097824ULL, 0x000fe200078e025bULL,
0x00000008080b7810ULL, 0x000fc40007ffe0ffULL, 0x00000010080d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001090c7824ULL, 0x100fe200078e0a5aULL, 0x00000018080f7810ULL, 0x000fe20007ffe0ffULL,
0x0000000167087824ULL, 0x000fe200078e0a5aULL, 0x0000005a0900720cULL, 0x000fe40003f26070ULL,
0x0000000c610c7217ULL, 0x040fe40003800000ULL, 0x0000000a61097217ULL, 0x000fe40003800000ULL,
0x00005a00ff0e7a19ULL, 0x000fc4000001160bULL, 0x0000005a6700720cULL, 0x000fe20003f06070ULL,
0x000000095c8b7224ULL, 0x000fe200078e02ffULL, 0x0000000861087217ULL, 0x040fe40003800000ULL,
0x00000004ff0c7819ULL, 0x000fe4000001160cULL, 0x0000000e610b7217ULL, 0x000fe40003800000ULL,
0x000000ff087a7207ULL, 0x000fe40000000000ULL, 0x000000ff0c0e7207ULL, 0x000fe20000800000ULL,
0x0000000b5c8d7224ULL, 0x000fe200078e02ffULL, 0x00005a00ff087a19ULL, 0x000fc4000001160dULL,
0x00005a00ff0a7a19ULL, 0x000fe2000001160fULL, 0x000000018b0b7824ULL, 0x000fe200078e020eULL,
0x0000008b7a097211ULL, 0x040fe400078fe0ffULL, 0x00000008610f7217ULL, 0x040fe40003800000ULL,
0x0000000a61697217ULL, 0x000fe20003800000ULL, 0x0000600009087625ULL, 0x080fe200078e007cULL,
0x000000105b777812ULL, 0x000fe400078efcffULL, 0x0000008d7a0d7211ULL, 0x000fe200078fe0ffULL,
0x000060000b0a7625ULL, 0x000fe200078e007cULL, 0x0000000808667981ULL, 0x0046a6000c1e9500ULL,
0x0000000f5c8f7224ULL, 0x000fc400078e02ffULL, 0x000000695c917224ULL, 0x000fe400078e02ffULL,
0x000000080a697981ULL, 0x0002a2000c1e9500ULL, 0x0000008f7a6b7211ULL, 0x000fe200078fe0ffULL,
0x000000010e0f7824ULL, 0x040fe400078e028dULL, 0x000000010e6f7824ULL, 0x000fe400078e028fULL,
0x000060000d0c7625ULL, 0x000fc800078e007cULL, 0x00000001600b7824ULL, 0x002fe200078e0277ULL,
0x0000580077757a10ULL, 0x000fe20007ffe0ffULL, 0x000000010e717824ULL, 0x000fe200078e0291ULL,
0x000000080c687981ULL, 0x0002a2000c1e9500ULL, 0x000000010b727824ULL, 0x000fe400078e0a5aULL,
0x000060006b6a7625ULL, 0x000fc800078e007cULL, 0x000060000f0e7625ULL, 0x000fe200078e007cULL,
0x0000007261727217ULL, 0x000fe20003800000ULL, 0x000000086a6e7981ULL, 0x0002a4000c1e9500ULL,
0x000060006f087625ULL, 0x008fe200078e007cULL, 0x0000005a0b00720cULL, 0x000fc60003f26070ULL,
0x00006000710c7625ULL, 0x002fe200078e007cULL, 0x0000000808737981ULL, 0x0002e2000c1e9500ULL,
0x00000004ff727819ULL, 0x000fe40000011672ULL, 0x00000001750a7824ULL, 0x040fe200078e0a5aULL,
0x000000080e717981ULL, 0x0002e2000c1e9500ULL, 0x000000917a6d7211ULL, 0x000fe400078fe0ffULL,
0x0000005a7500720cULL, 0x000fe20003f06070ULL, 0x000000080c707981ULL, 0x0002e2000c1e9500ULL,
0x0000000a610a7217ULL, 0x000fe20003800000ULL, 0x000060006d6c7625ULL, 0x000fe200078e007cULL,
0x000000ff720e7207ULL, 0x002fc80000800000ULL, 0x000000086c6f7981ULL, 0x0002e2000c1e9500ULL,
0x000000ff0a827207ULL, 0x000fe20000000000ULL, 0x000000018b0b7824ULL, 0x000fc600078e020eULL,
0x0000008b82097211ULL, 0x000fe200078fe0ffULL, 0x000000010e0f7824ULL, 0x000fe200078e028dULL,
0x0000008d820d7211ULL, 0x000fe200078fe0ffULL, 0x000060000b0a7625ULL, 0x000fe200078e007cULL,
0x000000205b7f7812ULL, 0x000fc600078efcffULL, 0x0000600009087625ULL, 0x080fe200078e007cULL,
0x000000080a797981ULL, 0x0002e6000c1e9500ULL, 0x000000010e7b7824ULL, 0x040fe200078e028fULL,
0x0000000808727981ULL, 0x0002e2000c1e9500ULL, 0x000000010e7d7824ULL, 0x000fe400078e0291ULL,
0x000060000d0c7625ULL, 0x000fe200078e007cULL, 0x000058007f817a10ULL, 0x000fc60007ffe0ffULL,
0x000060000f0e7625ULL, 0x080fe200078e007cULL, 0x000000080c747981ULL, 0x0002e6000c1e9500ULL,
0x00000001600b7824ULL, 0x002fe400078e027fULL, 0x000060007b087625ULL, 0x000fe400078e007cULL,
0x000000080e7b7981ULL, 0x0002e4000c1e9500ULL, 0x000000010b7e7824ULL, 0x100fe200078e0a5aULL,
0x0000008f826b7211ULL, 0x040fe200078fe0ffULL, 0x00000001810a7824ULL, 0x000fe200078e0a5aULL,
0x00000091826d7211ULL, 0x000fc400078fe0ffULL, 0x0000007e617e7217ULL, 0x000fe20003800000ULL,
0x000060006b6a7625ULL, 0x000fe200078e007cULL, 0x0000005a8100720cULL, 0x000fe40003f06070ULL,
0x0000000a610a7217ULL, 0x000fe20003800000ULL, 0x000060006d6c7625ULL, 0x000fe200078e007cULL,
0x0000005a0b00720cULL, 0x000fe20003f26070ULL, 0x000000086a767981ULL, 0x0002e2000c1e9500ULL,
0x00000004ff7e7819ULL, 0x000fe2000001167eULL, 0x000060007d0c7625ULL, 0x000fe200078e007cULL,
0x000000ff0a887207ULL, 0x000fe20000000000ULL, 0x00000008087d7981ULL, 0x0002e8000c1e9500ULL,
0x000000086c787981ULL, 0x0002e8000c1e9500ULL, 0x000000080c837981ULL, 0x0002e4000c1e9500ULL,
0x000000ff7e087207ULL, 0x002fc40000800000ULL, 0x0000008b880b7211ULL, 0x000fc600078fe0ffULL,
0x0000000108097824ULL, 0x000fe200078e028dULL, 0x0000008d880d7211ULL, 0x000fe200078fe0ffULL,
0x000000018b6d7824ULL, 0x000fe400078e0208ULL, 0x0000000108877824ULL, 0x040fe400078e028fULL,
0x0000000108897824ULL, 0x000fe400078e0291ULL, 0x000060000d0c7625ULL, 0x000fc800078e007cULL,
0x0000600009087625ULL, 0x080fe200078e007cULL, 0x000000080c807981ULL, 0x0002e6000c1e9500ULL,
0x000060000b0a7625ULL, 0x080fe200078e007cULL, 0x0000000808d17981ULL, 0x0002e2000c1e9500ULL,
0x0000008f886b7211ULL, 0x040fe400078fe0ffULL, 0x000060006d6c7625ULL, 0x000fe200078e007cULL,
0x000000080a7e7981ULL, 0x0002e2000c1e9500ULL, 0x00000091880f7211ULL, 0x000fc400078fe0ffULL,
0x000060006b6a7625ULL, 0x080fe200078e007cULL, 0x000000086c857981ULL, 0x0002e6000c1e9500ULL,
0x00006000870a7625ULL, 0x082fe200078e007cULL, 0x000000305b877812ULL, 0x000fe200078efcffULL,
0x000000086a847981ULL, 0x0002e4000c1e9500ULL, 0x000060000f0e7625ULL, 0x080fe400078e007cULL,
0x000000080ad57981ULL, 0x0002e4000c1e9500ULL, 0x00006000890c7625ULL, 0x000fe200078e007cULL,
0x0000580087897a10ULL, 0x000fe20007ffe0ffULL, 0x000000080e867981ULL, 0x0002e4000c1e9500ULL,
0x00000001606d7824ULL, 0x000fc400078e0287ULL, 0x000000080cd97981ULL, 0x0002e4000c1e9500ULL,
0x000000016d8a7824ULL, 0x100fe400078e0a5aULL, 0x00000001896c7824ULL, 0x000fc600078e0a5aULL,
0x0000008a618a7217ULL, 0x000fe40003800000ULL, 0x0000005a6d00720cULL, 0x080fe40003f26070ULL,
0x0000005a8900720cULL, 0x000fe40003f06070ULL, 0x0000006c616c7217ULL, 0x000fe40003800000ULL,
0x00000004ff087819ULL, 0x000fe4000001168aULL, 0x000000ff6c8a7207ULL, 0x000fc40000000000ULL,
0x000000ff088c7207ULL, 0x000fe40000800000ULL, 0x0000008b8a6b7211ULL, 0x042fe400078fe0ffULL,
0x0000008f8a0b7211ULL, 0x000fe200078fe0ffULL, 0x000000018b6d7824ULL, 0x000fe400078e028cULL,
0x000000018c0f7824ULL, 0x000fe400078e028fULL, 0x000060006b6a7625ULL, 0x000fc800078e007cULL,
0x000060006d6c7625ULL, 0x080fe200078e007cULL, 0x000000086abb7981ULL, 0x0002e6000c1e9500ULL,
0x000060000b0a7625ULL, 0x080fe200078e007cULL, 0x000000086c8e7981ULL, 0x0002e6000c1e9500ULL,
0x000060000f0e7625ULL, 0x000fe200078e007cULL, 0x000000080ad77981ULL, 0x0002e2000c1e9500ULL,
0x0000008d8a097211ULL, 0x000fc600078fe0ffULL, 0x000000080e927981ULL, 0x0002e2000c1e9500ULL,
0x000000018c0d7824ULL, 0x000fe400078e028dULL, 0x0000600009087625ULL, 0x000fc800078e007cULL,
0x000060000d0c7625ULL, 0x080fe200078e007cULL, 0x0000000808d37981ULL, 0x0002e4000c1e9500ULL,
0x000000918a6b7211ULL, 0x002fe400078fe0ffULL, 0x000000080c907981ULL, 0x0002e2000c1e9500ULL,
0x000000018c6d7824ULL, 0x000fe400078e0291ULL, 0x000060006b6a7625ULL, 0x000fc800078e007cULL,
0x000060006d6c7625ULL, 0x000fe200078e007cULL, 0x000000086adb7981ULL, 0x0002e8000c1e9500ULL,
0x000000086c947981ULL, 0x0002e2000c1e9500ULL, 0xfffffff07a097812ULL, 0x000fe200078ec0ffULL,
0x00000001ffcf7424ULL, 0x000fc800078e00ffULL, 0x000000015a087824ULL, 0x000fc800078e0209ULL,
0x0000000167097824ULL, 0x000fe200078e0a08ULL, 0x000000015b8b7812ULL, 0x000fc800078efcffULL,
0x00000009cf097219ULL, 0x000fe400000006ffULL, 0x000058008b0b7a10ULL, 0x000fe40007ffe0ffULL,
0xfffffff0820d7812ULL, 0x002fc600078ec0ffULL, 0x000000010b0a7824ULL, 0x100fe200078e0a08ULL,
0x000000085b8d7812ULL, 0x040fe200078efcffULL, 0x000000015a0e7824ULL, 0x000fe200078e020dULL,
0x000000095b8f7812ULL, 0x000fe400078efcffULL, 0x0000000acf0d7219ULL, 0x000fe400000006ffULL,
0x000058008d0f7a10ULL, 0x000fe40007ffe0ffULL, 0x000058008f6d7a10ULL, 0x000fe40007ffe0ffULL,
0xfffffff0886b7812ULL, 0x000fe200078ec0ffULL, 0x000000010f0c7824ULL, 0x100fe200078e0a08ULL,
0xfffffff08a917812ULL, 0x000fe200078ec0ffULL, 0x000000016d087824ULL, 0x000fe200078e0a08ULL,
0x000000115b957812ULL, 0x000fe200078efcffULL, 0x000000015a6a7824ULL, 0x040fe200078e026bULL,
0x0000000ccf6b7219ULL, 0x040fe200000006ffULL, 0x000000015a827824ULL, 0x000fe200078e0291ULL,
0x00000008cf917219ULL, 0x000fc400000006ffULL, 0x0000580095977a10ULL, 0x000fe40007ffe0ffULL,
0x0000541066667816ULL, 0x004fc80000000069ULL, 0x0000006609ff7212ULL, 0x000fc800078ac0ffULL,
0x0000005a6700720cULL, 0x000fc80002fa1470ULL, 0x0000005a5b00720cULL, 0x000fe40002fa1070ULL,
0x000000660dff7212ULL, 0x000fe4000782c0ffULL, 0xff80000057577808ULL, 0x000fe40002800000ULL,
0x0000005a0b00720cULL, 0x000fe40000f21470ULL, 0x000054106e6e7816ULL, 0x008fe40000000073ULL,
0x0000541068687816ULL, 0x000fc40000000071ULL, 0x0000006e09ff7212ULL, 0x040fe4000788c0ffULL,
0x0000006809ff7212ULL, 0x080fe4000784c0ffULL, 0x000000680dff7212ULL, 0x000fe400078ac0ffULL,
0x0000005a6700720cULL, 0x0c0fe40001741470ULL, 0x0000005a6700720cULL, 0x080fe40002781470ULL,
0x0000005a0b00720cULL, 0x000fc40002fa1470ULL, 0x0000005a5b00720cULL, 0x0c0fe40001741070ULL,
0x0000005a5b00720cULL, 0x080fe40002781070ULL, 0x0000005a8b00720cULL, 0x0c0fe40000f21070ULL,
0x0000005a8b00720cULL, 0x000fe40002fa1070ULL, 0x000054106f707816ULL, 0x000fe40000000070ULL,
0xff80000034347808ULL, 0x000fc40001000000ULL, 0xff80000043437808ULL, 0x000fe40002000000ULL,
0xff80000056567808ULL, 0x000fe40000800000ULL, 0xff80000035357808ULL, 0x000fe40002800000ULL,
0x000000666bff7212ULL, 0x000fe4000786c0ffULL, 0x0000007009ff7212ULL, 0x000fe4000780c0ffULL,
0x0000006e0dff7212ULL, 0x000fc4000784c0ffULL, 0x000000700dff7212ULL, 0x000fe4000788c0ffULL,
0x0000006891ff7212ULL, 0x000fe4000782c0ffULL, 0x0000006e6bff7212ULL, 0x000fe200078ac0ffULL,
0x0000000175087824ULL, 0x100fe200078e0a0eULL, 0x0000005a6700720cULL, 0x080fe20000701470ULL,
0x00000001970a7824ULL, 0x000fe200078e0a0eULL, 0x0000005a0b00720cULL, 0x0c0fe40001741470ULL,
0x0000005a0b00720cULL, 0x000fc40002781470ULL, 0x0000005a0f00720cULL, 0x0c0fe40001f61470ULL,
0x0000005a0f00720cULL, 0x080fe40002fa1470ULL, 0x0000005a6d00720cULL, 0x080fe40000f21470ULL,
0x000000185b9b7812ULL, 0x040fe400078efcffULL, 0x000000195ba17812ULL, 0x040fe400078efcffULL,
0x0000005a5b00720cULL, 0x000fc40000701070ULL, 0x0000005a8b00720cULL, 0x0c0fe40001741070ULL,
0x0000005a8b00720cULL, 0x080fe40002781070ULL, 0x0000005a8d00720cULL, 0x0c0fe40001f61070ULL,
0x0000005a8d00720cULL, 0x080fe40002fa1070ULL, 0x0000005a8f00720cULL, 0x000fe40000f21070ULL,
0x00000008cf937219ULL, 0x000fc400000006ffULL, 0x0000000acf997219ULL, 0x000fe400000006ffULL,
0x0000541072727816ULL, 0x000fe40000000079ULL, 0x0000541074747816ULL, 0x000fe4000000007bULL,
0x000058009b9d7a10ULL, 0x000fe40007ffe0ffULL, 0x00005800a1a37a10ULL, 0x000fe40007ffe0ffULL,
0xff80000024247808ULL, 0x000fc40000000000ULL, 0xff80000042427808ULL, 0x000fe40001000000ULL,
0xff80000027277808ULL, 0x000fe40002000000ULL, 0xff80000055557808ULL, 0x000fe40001800000ULL,
0xff8000002a2a7808ULL, 0x000fe40002800000ULL, 0xff8000002d2d7808ULL, 0x000fe40000800000ULL,
0x000000686bff7212ULL, 0x000fc4000780c0ffULL, 0x0000006e91ff7212ULL, 0x000fe4000784c0ffULL,
0x000000706bff7212ULL, 0x080fe4000788c0ffULL, 0x0000007091ff7212ULL, 0x000fe4000786c0ffULL,
0x0000007299ff7212ULL, 0x000fe400078ac0ffULL, 0x0000007493ff7212ULL, 0x000fe2000782c0ffULL,
0x000000019d0c7824ULL, 0x100fe200078e0a0eULL, 0x0000005a0f00720cULL, 0x080fe20000701470ULL,
0x00000001a30e7824ULL, 0x000fe200078e0a0eULL, 0x0000005a0f00720cULL, 0x000fc40002781470ULL,
0x0000005a6d00720cULL, 0x0c0fe40001741470ULL, 0x0000005a6d00720cULL, 0x080fe40001f61470ULL,
0x0000005a7500720cULL, 0x080fe40000f21470ULL, 0x0000005a9700720cULL, 0x080fe40002fa1470ULL,
0x0000005a8d00720cULL, 0x0c0fe40000701070ULL, 0x0000005a8d00720cULL, 0x000fc40002781070ULL,
0x0000005a8f00720cULL, 0x0c0fe40001741070ULL, 0x0000005a8f00720cULL, 0x080fe40001f61070ULL,
0x0000005a7700720cULL, 0x080fe40000f21070ULL, 0x0000005a9500720cULL, 0x000fe40002fa1070ULL,
0x0000000ccf9f7219ULL, 0x040fe400000006ffULL, 0x0000000ecfa57219ULL, 0x000fc400000006ffULL,
0x0000541076767816ULL, 0x000fe4000000007dULL, 0x0000541078787816ULL, 0x000fe40000000083ULL,
0xff8000002b2b7808ULL, 0x000fe40000000000ULL, 0xff8000001b1b7808ULL, 0x000fe40002000000ULL,
0xff80000036367808ULL, 0x000fe40001000000ULL, 0xff80000025257808ULL, 0x000fc40001800000ULL,
0xff8000002c2c7808ULL, 0x000fe40000800000ULL, 0xff80000052527808ULL, 0x000fe40002800000ULL,
0x0000007293ff7212ULL, 0x080fe4000780c0ffULL, 0x000000729fff7212ULL, 0x000fe4000788c0ffULL,
0x0000007693ff7212ULL, 0x040fe4000784c0ffULL, 0x0000007893ff7212ULL, 0x000fc4000786c0ffULL,
0x0000007699ff7212ULL, 0x000fe4000782c0ffULL, 0x00000074a5ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001816c7824ULL, 0x000fe200078e0a6aULL, 0x0000005a7500720cULL, 0x0c0fe40000701470ULL,
0x0000005a7500720cULL, 0x0c0fe40001741470ULL, 0x0000005a7500720cULL, 0x080fe40001f61470ULL,
0x0000005a9700720cULL, 0x000fc40000f21470ULL, 0x0000005a9d00720cULL, 0x080fe40002781470ULL,
0x0000005aa300720cULL, 0x080fe40002fa1470ULL, 0x000000215ba97812ULL, 0x000fe400078efcffULL,
0x0000005a7700720cULL, 0x0c0fe40000701070ULL, 0x0000005a7700720cULL, 0x0c0fe40001741070ULL,
0x0000005a7700720cULL, 0x000fc40001f61070ULL, 0x0000005a9500720cULL, 0x080fe40000f21070ULL,
0x0000005a9b00720cULL, 0x080fe40002781070ULL, 0x0000005aa100720cULL, 0x000fe40002fa1070ULL,
0x0000006ccfa77219ULL, 0x000fe400000006ffULL, 0x0000541080807816ULL, 0x000fe400000000d1ULL,
0x00005800a9ab7a10ULL, 0x000fc40007ffe0ffULL, 0xff80000053537808ULL, 0x000fe40000000000ULL,
0xff80000037377808ULL, 0x000fe40001000000ULL, 0xff80000028287808ULL, 0x000fe40001800000ULL,
0xff80000038387808ULL, 0x000fe40000800000ULL, 0xff80000051517808ULL, 0x000fe40002000000ULL,
0xff80000030307808ULL, 0x000fc40002800000ULL, 0x0000007499ff7212ULL, 0x040fe4000780c0ffULL,
0x0000007899ff7212ULL, 0x000fe4000784c0ffULL, 0x000000749fff7212ULL, 0x000fe4000786c0ffULL,
0x00000076a5ff7212ULL, 0x040fe4000782c0ffULL, 0x00000078a5ff7212ULL, 0x000fe4000788c0ffULL,
0x00000080a7ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001ab7a7824ULL, 0x000fe200078e0a6aULL,
0x0000005a9700720cULL, 0x000fc40000701470ULL, 0x0000005a9700720cULL, 0x080fe40001741470ULL,
0x0000005a9d00720cULL, 0x080fe40001f61470ULL, 0x0000005aa300720cULL, 0x0c0fe40000f21470ULL,
0x0000005aa300720cULL, 0x080fe40002781470ULL, 0x0000005a8100720cULL, 0x000fe40002fa1470ULL,
0x000000285baf7812ULL, 0x000fc400078efcffULL, 0x000000295bb57812ULL, 0x000fe400078efcffULL,
0x0000005a9500720cULL, 0x0c0fe40000701070ULL, 0x0000005a9500720cULL, 0x080fe40001741070ULL,
0x0000005a9b00720cULL, 0x080fe40001f61070ULL, 0x0000005aa100720cULL, 0x0c0fe40000f21070ULL,
0x0000005aa100720cULL, 0x000fc40002781070ULL, 0x0000005a7f00720cULL, 0x000fe40002fa1070ULL,
0x0000007acfad7219ULL, 0x000fe400000006ffULL, 0x000054107e7e7816ULL, 0x000fe40000000085ULL,
0x0000541084847816ULL, 0x000fe400000000d5ULL, 0x0000541086867816ULL, 0x000fe400000000d9ULL,
0x00005800afb17a10ULL, 0x000fc40007ffe0ffULL, 0x00005800b5b77a10ULL, 0x000fe40007ffe0ffULL,
0xff80000049497808ULL, 0x000fe40000000000ULL, 0xff80000029297808ULL, 0x000fe40001000000ULL,
0xff8000002e2e7808ULL, 0x000fe40001800000ULL, 0xff8000003a3a7808ULL, 0x000fe40000800000ULL,
0xff8000001a1a7808ULL, 0x000fc40002000000ULL, 0xff8000002f2f7808ULL, 0x000fe40002800000ULL,
0x0000006691ff7212ULL, 0x000fe400078cc0ffULL, 0x000000769fff7212ULL, 0x040fe4000780c0ffULL,
0x000000789fff7212ULL, 0x000fe4000784c0ffULL, 0x0000007ea7ff7212ULL, 0x040fe4000786c0ffULL,
0x00000084a7ff7212ULL, 0x000fc4000782c0ffULL, 0x00000086a7ff7212ULL, 0x000fe4000788c0ffULL,
0x00000084adff7212ULL, 0x000fe200078ac0ffULL, 0x00000001b17c7824ULL, 0x100fe200078e0a6aULL,
0x0000005a6d00720cULL, 0x080fe200037c1470ULL, 0x00000001b76a7824ULL, 0x000fe200078e0a6aULL,
0x0000005a9d00720cULL, 0x0c0fe40000701470ULL, 0x0000005a9d00720cULL, 0x080fe40001741470ULL,
0x0000005a8100720cULL, 0x000fc40001f61470ULL, 0x0000005a8100720cULL, 0x0c0fe40000f21470ULL,
0x0000005a8100720cULL, 0x080fe40002781470ULL, 0x0000005aab00720cULL, 0x080fe40002fa1470ULL,
0x0000005a8f00720cULL, 0x080fe400037c1070ULL, 0x0000005a9b00720cULL, 0x0c0fe40000701070ULL,
0x0000005a9b00720cULL, 0x000fc40001741070ULL, 0x0000005a7f00720cULL, 0x0c0fe40001f61070ULL,
0x0000005a7f00720cULL, 0x0c0fe40000f21070ULL, 0x0000005a7f00720cULL, 0x080fe40002781070ULL,
0x0000005aa900720cULL, 0x000fe40002fa1070ULL, 0x0000007ccfb37219ULL, 0x040fe400000006ffULL,
0x0000006acfb97219ULL, 0x000fc400000006ffULL, 0xff80000054547808ULL, 0x000fe40003000000ULL,
0xff80000039397808ULL, 0x000fe40000000000ULL, 0xff80000026267808ULL, 0x000fe40001000000ULL,
0xff80000059597808ULL, 0x000fe40001800000ULL, 0xff8000003b3b7808ULL, 0x000fe40000800000ULL,
0xff80000019197808ULL, 0x000fc40002000000ULL, 0xff8000003c3c7808ULL, 0x000fe40002800000ULL,
0x00000072a5ff7212ULL, 0x000fe400078cc0ffULL, 0x0000007eadff7212ULL, 0x080fe4000780c0ffULL,
0x0000007eb3ff7212ULL, 0x000fe4000784c0ffULL, 0x00000080adff7212ULL, 0x040fe4000786c0ffULL,
0x00000086adff7212ULL, 0x000fc4000782c0ffULL, 0x00000080b3ff7212ULL, 0x000fe4000788c0ffULL,
0x00000084b9ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000189887824ULL, 0x000fe200078e0a82ULL,
0x0000005aa300720cULL, 0x080fe400037c1470ULL, 0x0000005aab00720cULL, 0x0c0fe40000701470ULL,
0x0000005aab00720cULL, 0x0c0fe40001f61470ULL, 0x0000005aab00720cULL, 0x000fc40000f21470ULL,
0x0000005ab100720cULL, 0x0c0fe40001741470ULL, 0x0000005ab100720cULL, 0x080fe40002781470ULL,
0x0000005ab700720cULL, 0x000fe40002fa1470ULL, 0x000000315bbf7812ULL, 0x040fe400078efcffULL,
0x000000385bc57812ULL, 0x040fe400078efcffULL, 0x000000395bcb7812ULL, 0x000fc400078efcffULL,
0x0000005aa100720cULL, 0x080fe400037c1070ULL, 0x0000005aa900720cULL, 0x0c0fe40000701070ULL,
0x0000005aa900720cULL, 0x0c0fe40001f61070ULL, 0x0000005aa900720cULL, 0x080fe40000f21070ULL,
0x0000005aaf00720cULL, 0x0c0fe40001741070ULL, 0x0000005aaf00720cULL, 0x000fc40002781070ULL,
0x0000005ab500720cULL, 0x000fe40002fa1070ULL, 0x00000088cfbd7219ULL, 0x000fe400000006ffULL,
0x00005410bb8e7816ULL, 0x000fe4000000008eULL, 0x00005410d7927816ULL, 0x000fe40000000092ULL,
0x00005800bfc17a10ULL, 0x000fe40007ffe0ffULL, 0x00005800c5c77a10ULL, 0x000fc40007ffe0ffULL,
0x00005800cbcd7a10ULL, 0x000fe40007ffe0ffULL, 0xff80000058587808ULL, 0x000fe40003000000ULL,
0xff80000050507808ULL, 0x000fe40000000000ULL, 0xff80000048487808ULL, 0x000fe40001800000ULL,
0xff80000018187808ULL, 0x000fe40000800000ULL, 0xff8000004f4f7808ULL, 0x000fc40001000000ULL,
0xff80000031317808ULL, 0x000fe40002000000ULL, 0xff8000003e3e7808ULL, 0x000fe40002800000ULL,
0x0000007eb9ff7212ULL, 0x040fe400078cc0ffULL, 0x00000080b9ff7212ULL, 0x000fe4000780c0ffULL,
0x00000084b3ff7212ULL, 0x040fe4000786c0ffULL, 0x00000086b3ff7212ULL, 0x000fc4000782c0ffULL,
0x00000086b9ff7212ULL, 0x000fe4000784c0ffULL, 0x0000008ebdff7212ULL, 0x040fe4000788c0ffULL,
0x00000092bdff7212ULL, 0x000fe200078ac0ffULL, 0x00000001c18a7824ULL, 0x100fe200078e0a82ULL,
0x0000005ab100720cULL, 0x080fe20001f61470ULL, 0x00000001c78c7824ULL, 0x100fe200078e0a82ULL,
0x0000005ab100720cULL, 0x080fe20000f21470ULL, 0x00000001cd827824ULL, 0x000fe200078e0a82ULL,
0x0000005ab700720cULL, 0x000fc400037c1470ULL, 0x0000005ab700720cULL, 0x0c0fe40000701470ULL,
0x0000005ab700720cULL, 0x080fe40001741470ULL, 0x0000005a8900720cULL, 0x0c0fe40002781470ULL,
0x0000005a8900720cULL, 0x000fe40002fa1470ULL, 0x0000008acfc37219ULL, 0x040fe400000006ffULL,
0x0000008ccfc97219ULL, 0x000fc400000006ffULL, 0x0000005aaf00720cULL, 0x0c0fe40001f61070ULL,
0x0000005aaf00720cULL, 0x080fe40000f21070ULL, 0x0000005ab500720cULL, 0x0c0fe400037c1070ULL,
0x0000005ab500720cULL, 0x0c0fe40000701070ULL, 0x0000005ab500720cULL, 0x080fe40001741070ULL,
0x0000005a8700720cULL, 0x000fc40002781070ULL, 0x0000005a8700720cULL, 0x000fe40002fa1070ULL,
0x00000082cfcf7219ULL, 0x000fe400000006ffULL, 0x00005410d3907816ULL, 0x000fe40000000090ULL,
0xff8000003d3d7808ULL, 0x000fe40001800000ULL, 0xff80000012127808ULL, 0x000fe40000800000ULL,
0xff8000004e4e7808ULL, 0x000fc40003000000ULL, 0xff8000003f3f7808ULL, 0x000fe40000000000ULL,
0xff80000013137808ULL, 0x000fe40001000000ULL, 0xff8000004d4d7808ULL, 0x000fe40002000000ULL,
0xff80000047477808ULL, 0x000fe40002800000ULL, 0x0000008ec3ff7212ULL, 0x080fe4000786c0ffULL,
0x0000008ec9ff7212ULL, 0x000fc4000782c0ffULL, 0x0000008ecfff7212ULL, 0x000fe400078cc0ffULL,
0x00000090bdff7212ULL, 0x080fe4000780c0ffULL, 0x00000090c3ff7212ULL, 0x080fe4000784c0ffULL,
0x00000090c9ff7212ULL, 0x000fe4000788c0ffULL, 0x00000092c3ff7212ULL, 0x000fe400078ac0ffULL,
0x0000005a8900720cULL, 0x000fc40000701470ULL, 0x0000005ac100720cULL, 0x0c0fe40001f61470ULL,
0x0000005ac100720cULL, 0x0c0fe40001741470ULL, 0x0000005ac100720cULL, 0x080fe40002fa1470ULL,
0x0000005ac700720cULL, 0x080fe40000f21470ULL, 0x0000005acd00720cULL, 0x080fe400037c1470ULL,
0x0000005ac700720cULL, 0x000fc40002781470ULL, 0x0000005a8700720cULL, 0x080fe40000701070ULL,
0x0000005abf00720cULL, 0x0c0fe40001f61070ULL, 0x0000005abf00720cULL, 0x0c0fe40001741070ULL,
0x0000005abf00720cULL, 0x080fe40002fa1070ULL, 0x0000005ac500720cULL, 0x080fe40000f21070ULL,
0x0000005acb00720cULL, 0x000fc400037c1070ULL, 0x0000005ac500720cULL, 0x000fe40002781070ULL,
0x00005410db947816ULL, 0x000fe40000000094ULL, 0xff80000032327808ULL, 0x000fe40000000000ULL,
0xff8000004c4c7808ULL, 0x000fe40001800000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff80000040407808ULL, 0x000fc40002800000ULL, 0xff8000004b4b7808ULL, 0x000fe40000800000ULL,
0xff8000004a4a7808ULL, 0x000fe40003000000ULL, 0xff80000046467808ULL, 0x000fe40002000000ULL,
0x00000090cfff7212ULL, 0x000fe4000780c0ffULL, 0x00000092c9ff7212ULL, 0x080fe4000786c0ffULL,
0x00000092cfff7212ULL, 0x000fc4000784c0ffULL, 0x00000094bdff7212ULL, 0x080fe400078ac0ffULL,
0x00000094c3ff7212ULL, 0x080fe4000782c0ffULL, 0x00000094c9ff7212ULL, 0x080fe400078cc0ffULL,
0x00000094cfff7212ULL, 0x000fe4000788c0ffULL, 0x0000005a8900720cULL, 0x080fe40002fa1470ULL,
0x0000005ac100720cULL, 0x000fc40000f21470ULL, 0x0000005ac700720cULL, 0x0c0fe40001f61470ULL,
0x0000005ac700720cULL, 0x080fe400037c1470ULL, 0x0000005acd00720cULL, 0x0c0fe40000701470ULL,
0x0000005acd00720cULL, 0x0c0fe40001741470ULL, 0x0000005acd00720cULL, 0x080fe40002781470ULL,
0x0000005a8700720cULL, 0x000fc40002fa1070ULL, 0x0000005abf00720cULL, 0x080fe40000f21070ULL,
0x0000005acb00720cULL, 0x080fe40000701070ULL, 0x0000005ac500720cULL, 0x0c0fe40001f61070ULL,
0x0000005ac500720cULL, 0x080fe400037c1070ULL, 0x0000005acb00720cULL, 0x0c0fe40001741070ULL,
0x0000005acb00720cULL, 0x000fc40002781070ULL, 0xff80000045457808ULL, 0x000fe40000000000ULL,
0xff80000041417808ULL, 0x000fe40001800000ULL, 0xff80000044447808ULL, 0x000fe40001000000ULL,
0xff80000014147808ULL, 0x000fe40002800000ULL, 0xff80000015157808ULL, 0x000fe40000800000ULL,
0xff80000016167808ULL, 0x000fc40003000000ULL, 0xff80000017177808ULL, 0x000fc40002000000ULL,
0x000000570400720bULL, 0x004fe40003f1e000ULL, 0x000000340500720bULL, 0x000fe40003f3e000ULL,
0x000000430600720bULL, 0x000fe40003f5e000ULL, 0x000000240700720bULL, 0x000fe40003f7e000ULL,
0x0000000457097208ULL, 0x000fe40004000000ULL, 0x0000000534047208ULL, 0x000fc40004800000ULL,
0x0000000643057208ULL, 0x000fe40005000000ULL, 0x0000000724067208ULL, 0x000fe40005800000ULL,
0x000000560900720bULL, 0x000fe40003f1e000ULL, 0x000000350400720bULL, 0x000fe40003f3e000ULL,
0x000000420500720bULL, 0x000fe40003f5e000ULL, 0x000000270600720bULL, 0x000fc40003f7e000ULL,
0x0000000956087208ULL, 0x000fe40004000000ULL, 0x0000000435047208ULL, 0x000fe40004800000ULL,
0x0000000542057208ULL, 0x000fe40005000000ULL, 0x0000000627067208ULL, 0x000fe40005800000ULL,
0x000000550800720bULL, 0x000fe40003f1e000ULL, 0x0000002b0400720bULL, 0x000fc40003f3e000ULL,
0x0000002a0500720bULL, 0x000fe40003f5e000ULL, 0x0000001b0600720bULL, 0x000fe40003f7e000ULL,
0x0000000855077208ULL, 0x000fe40004000000ULL, 0x000000042b047208ULL, 0x000fe40004800000ULL,
0x000000052a057208ULL, 0x000fe40005000000ULL, 0x000000061b067208ULL, 0x000fc40005800000ULL,
0x000000540700720bULL, 0x000fe40003f1e000ULL, 0x0000002d0400720bULL, 0x000fe40003f3e000ULL,
0x000000360500720bULL, 0x000fe40003f5e000ULL, 0x000000250600720bULL, 0x000fe40003f7e000ULL,
0x0000000754087208ULL, 0x000fe40004000000ULL, 0x000000042d077208ULL, 0x000fc40004800000ULL,
0x0000000536047208ULL, 0x000fe40005000000ULL, 0x0000000625057208ULL, 0x000fe40005800000ULL,
0x000000530800720bULL, 0x000fe40003f1e000ULL, 0x0000002c0700720bULL, 0x000fe40003f3e000ULL,
0x000000370400720bULL, 0x000fe40003f5e000ULL, 0x000000280500720bULL, 0x000fc40003f7e000ULL,
0x0000000853097208ULL, 0x000fe40004000000ULL, 0x000000072c067208ULL, 0x000fe40004800000ULL,
0x0000000437077208ULL, 0x000fe40005000000ULL, 0x0000000528047208ULL, 0x000fe40005800000ULL,
0x000000520900720bULL, 0x000fe40003f1e000ULL, 0x000000490600720bULL, 0x000fc40003f3e000ULL,
0x000000380700720bULL, 0x000fe40003f5e000ULL, 0x000000290400720bULL, 0x000fe40003f7e000ULL,
0x0000000952087208ULL, 0x000fe40004000000ULL, 0x0000000649057208ULL, 0x000fe40004800000ULL,
0x0000000738067208ULL, 0x000fe40005000000ULL, 0x0000000429077208ULL, 0x000fc40005800000ULL,
0x000000510800720bULL, 0x000fe40003f1e000ULL, 0x0000002e0500720bULL, 0x000fe40003f3e000ULL,
0x000000390600720bULL, 0x000fe40003f5e000ULL, 0x000000260700720bULL, 0x000fe40003f7e000ULL,
0x0000000851097208ULL, 0x000fe40004000000ULL, 0x000000052e057208ULL, 0x000fc40004800000ULL,
0x00000006390b7208ULL, 0x000fe40005000000ULL, 0x0000000726077208ULL, 0x000fe40005800000ULL,
0x000000580900720bULL, 0x000fe40003f1e000ULL, 0x000000300500720bULL, 0x000fe40003f3e000ULL,
0x0000003a0b00720bULL, 0x000fe40003f5e000ULL, 0x0000001a0700720bULL, 0x000fc40003f7e000ULL,
0x0000000958047208ULL, 0x000fe40004000000ULL, 0x0000000530067208ULL, 0x000fe40004800000ULL,
0x0000000b3a087208ULL, 0x000fe40005000000ULL, 0x000000071a0a7208ULL, 0x000fe40005800000ULL,
0x000000590400720bULL, 0x000fe40003f1e000ULL, 0x0000002f0600720bULL, 0x000fc40003f3e000ULL,
0x0000003b0800720bULL, 0x000fe40003f5e000ULL, 0x000000190a00720bULL, 0x000fe40003f7e000ULL,
0x0000000459057208ULL, 0x000fe40004000000ULL, 0x000000062f077208ULL, 0x000fe40004800000ULL,
0x000000083b097208ULL, 0x000fe40005000000ULL, 0x0000000a190b7208ULL, 0x000fc40005800000ULL,
0x000000500500720bULL, 0x000fe40003f1e000ULL, 0x000000480700720bULL, 0x000fe40003f3e000ULL,
0x0000003c0900720bULL, 0x000fe40003f5e000ULL, 0x000000180b00720bULL, 0x000fe40003f7e000ULL,
0x0000000550047208ULL, 0x000fe40004000000ULL, 0x0000000748067208ULL, 0x000fc40004800000ULL,
0x000000093c087208ULL, 0x000fe40005000000ULL, 0x0000000b180b7208ULL, 0x000fe40005800000ULL,
0x0000004f0400720bULL, 0x000fe40003f1e000ULL, 0x000000310600720bULL, 0x000fe40003f3e000ULL,
0x0000003d0800720bULL, 0x000fe40003f5e000ULL, 0x000000120b00720bULL, 0x000fc40003f7e000ULL,
0x000000044f057208ULL, 0x000fe40004000000ULL, 0x0000000631067208ULL, 0x000fe40004800000ULL,
0x000000083d077208ULL, 0x000fe40005000000ULL, 0x0000000b12047208ULL, 0x000fe40005800000ULL,
0x0000004e0500720bULL, 0x000fe40003f1e000ULL, 0x0000003f0600720bULL, 0x000fc40003f3e000ULL,
0x0000003e0700720bULL, 0x000fe40003f5e000ULL, 0x000000130400720bULL, 0x000fe40003f7e000ULL,
0x000000054e087208ULL, 0x000fe40004000000ULL, 0x000000063f057208ULL, 0x000fe40004800000ULL,
0x000000073e067208ULL, 0x000fe40005000000ULL, 0x0000000413077208ULL, 0x000fc40005800000ULL,
0x000000320500720bULL, 0x000fe40003f3e000ULL, 0x000000470600720bULL, 0x000fe40003f5e000ULL,
0x0000004d0800720bULL, 0x000fe40003f1e000ULL, 0x000000140700720bULL, 0x000fe40003f7e000ULL,
0x0000000532047208ULL, 0x000fe40004800000ULL, 0x0000000647057208ULL, 0x000fc40005000000ULL,
0x000000084d097208ULL, 0x000fe40004000000ULL, 0x0000000714067208ULL, 0x000fe40005800000ULL,
0x000000330400720bULL, 0x000fe40003f3e000ULL, 0x000000400500720bULL, 0x000fe40003f5e000ULL,
0x0000004c0900720bULL, 0x000fe40003f1e000ULL, 0x000000150600720bULL, 0x000fc40003f7e000ULL,
0x0000000433077208ULL, 0x000fe40004800000ULL, 0x0000000540047208ULL, 0x000fe40005000000ULL,
0x000000094c087208ULL, 0x000fe40004000000ULL, 0x0000000615057208ULL, 0x000fe40005800000ULL,
0x000000460700720bULL, 0x000fe40003f3e000ULL, 0x000000410400720bULL, 0x000fc40003f5e000ULL,
0x0000004b0800720bULL, 0x000fe40003f1e000ULL, 0x000000160500720bULL, 0x000fe40003f7e000ULL,
0x0000000746067208ULL, 0x000fe40004800000ULL, 0x0000000441077208ULL, 0x000fe40005000000ULL,
0x000000084b097208ULL, 0x000fe40004000000ULL, 0x0000000516047208ULL, 0x000fc40005800000ULL,
0x0000004a0900720bULL, 0x000fe40003f1e000ULL, 0x000000450600720bULL, 0x000fe40003f3e000ULL,
0x000000440700720bULL, 0x000fe40003f5e000ULL, 0x000000170400720bULL, 0x000fe40003f7e000ULL,
0x000000094a057208ULL, 0x000fe40004000000ULL, 0x00000006450a7208ULL, 0x000fc40004800000ULL,
0x00000007440e7208ULL, 0x000fe40005000000ULL, 0x00000004170d7208ULL, 0x000fe20005800000ULL,
0x000024827f007947ULL, 0x000fea000b800000ULL, 0x0c401f0005047f89ULL, 0x0004e400000e0000ULL,
0x000000040500720bULL, 0x008fc80003f1e000ULL, 0x00000005040f7208ULL, 0x000fe20004000000ULL,
0x000024c27f007947ULL, 0x000fea000b800000ULL, 0x0c401f000a047f89ULL, 0x000ee800000e0000ULL,
0x0c401f000e057f89ULL, 0x004ea800000e0000ULL, 0x0c401f000d067f89ULL, 0x000e6200000e0000ULL,
0x000000040a00720bULL, 0x008fc40003f1e000ULL, 0x000000050e00720bULL, 0x004fe40003f3e000ULL,
0x0000000a04077208ULL, 0x002fe40004000000ULL, 0x0000000e05087208ULL, 0x000fe20004800000ULL,
0x0c201f000f047f89ULL, 0x000e6200000e0000ULL, 0x000000060d00720bULL, 0x000fc60003f1e000ULL,
0x0c201f00070c7f89ULL, 0x000ea200000e0000ULL, 0x0000000d060a7208ULL, 0x000fc60004000000ULL,
0x0c201f0008097f89ULL, 0x000ee800000e0000ULL, 0x0c201f000a0b7f89ULL, 0x0002e400000e0000ULL,
0x000000040f00720bULL, 0x002fe40003f1e000ULL, 0x0000000c0700720bULL, 0x004fe40003f3e000ULL,
0x0000000f04047208ULL, 0x000fc40004000000ULL, 0x000000090800720bULL, 0x008fe40003f5e000ULL,
0x000000070c057208ULL, 0x000fe40004800000ULL, 0x0000000809067208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL, 0x0000000b0a00720bULL, 0x004fe20003f1e000ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x00000002ff687819ULL, 0x000fe20000011621ULL,
0x3fb8aa3b57577823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b510c7823ULL, 0x000fc40000010807ULL,
0x0000005700087308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b56567823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b55557823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b54547823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b53537823ULL, 0x100fe20000010807ULL, 0x0000000c00577308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b52527823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b58587823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b59517823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL,
0x0000005600097308ULL, 0x000ea20000000800ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b4e4e7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b4d4d7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL, 0x0000005500557308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b4b4b7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b4a4a7823ULL, 0x000fe40000010807ULL,
0x3fb8aa3b06077820ULL, 0x000fe40000410000ULL, 0x3fb8aa3b050c7820ULL, 0x002fe20000410000ULL,
0x0000005400547308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b43437823ULL, 0x100fe20000010807ULL,
0x000000080908723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b42427823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b2a2a7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010807ULL,
0x0000004300437308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b37377823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b38387823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b39397823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b3a3a7823ULL, 0x100fe20000010807ULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b3b3b7823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010807ULL,
0x00000036000d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b47477823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b40407823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b41417823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b44447823ULL, 0x000fe20000010807ULL, 0x0000000a0b077208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe2000001080cULL, 0x0000004200427308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe2000001080cULL, 0x00000002680b7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b34347823ULL, 0x100fe2000001080cULL, 0x00000001680a7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b35357823ULL, 0x100fe2000001080cULL, 0x0000000321ff7812ULL, 0x000fe2000780c0ffULL,
0x3fb8aa3b30307823ULL, 0x100fe2000001080cULL, 0x0000002d000e7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b32327823ULL, 0x000fc4000001080cULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b49497823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b2e2e7823ULL, 0x100fe2000001080cULL,
0x0000002b002b7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b072d7820ULL, 0x002fe40000410000ULL,
0x3fb8aa3b2f2f7823ULL, 0x000fe4000001080cULL, 0x3fb8aa3b1b1b7823ULL, 0x000fc4000001082dULL,
0x3fb8aa3b48487823ULL, 0x100fe2000001080cULL, 0x0000003400347308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b31317823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe4000001080cULL,
0x3fb8aa3b33337823ULL, 0x100fe4000001080cULL, 0x3fb8aa3b46467823ULL, 0x000fe2000001080cULL,
0x0000003500357308ULL, 0x000e620000000800ULL, 0x3fb8aa3b24247823ULL, 0x000fc4000001082dULL,
0x3fb8aa3b27277823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b450c7823ULL, 0x000fe4000001080cULL,
0x3fb8aa3b25257823ULL, 0x000fe2000001082dULL, 0x0000003000597308ULL, 0x000fe20000000800ULL,
0x00000008686b7824ULL, 0x040fe400078e00ffULL, 0x0000000868677824ULL, 0x040fe400078e00ffULL,
0x0000000868717824ULL, 0x000fc400078e00ffULL, 0x00000008686d7824ULL, 0x040fe200078e00ffULL,
0x00000032005a7308ULL, 0x000fe20000000800ULL, 0xfffffff867677812ULL, 0x000fe200078ee20aULL,
0x0000000868737824ULL, 0x040fe200078e00ffULL, 0x00000004680a7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b26267823ULL, 0x000fe2000001082dULL, 0x000000343509723eULL, 0x002fe200000000ffULL,
0x3c003c00ff347424ULL, 0x000fe200078e00ffULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee20aULL,
0x00000024000f7308ULL, 0x0003e20000000800ULL, 0x00000055540a723eULL, 0x000fe200000000ffULL,
0x3c003c00ff357424ULL, 0x000fc400078e00ffULL, 0x3fb8aa3b28287823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b29297823ULL, 0x100fe4000001082dULL, 0x0000002700307308ULL, 0x000ea20000000800ULL,
0x0000000868247824ULL, 0x002fe400078e00ffULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b19197823ULL, 0x000fe2000001082dULL, 0xfffffff824697812ULL, 0x000fe200078ee20bULL,
0x3fb8aa3b16557823ULL, 0x100fe2000001082dULL, 0x0000000c00457308ULL, 0x0003e20000000800ULL,
0x00000005680b7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b17667823ULL, 0x000fc4000001082dULL,
0x3fb8aa3b12127823ULL, 0x000fe2000001082dULL, 0xfffffff8246f7812ULL, 0x000fe400078ee20bULL,
0x0000002b0e0b723eULL, 0x000fe200000000ffULL, 0x0000001b001b7308ULL, 0x000fe20000000800ULL,
0x00000003680c7810ULL, 0x042fe40007ffe0ffULL, 0x0000002a0d0e723eULL, 0x000fe400000000ffULL,
0xfffffff86b6b7812ULL, 0x000fe400078ee20cULL, 0x00000006680c7810ULL, 0x000fe20007ffe0ffULL,
0x0000002500327308ULL, 0x000e620000000800ULL, 0x0000000f300d723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b13307823ULL, 0x000fe2000001082dULL, 0xfffffff871717812ULL, 0x000fc400078ee20cULL,
0xffffffff680c7810ULL, 0x000fc60007ffe0ffULL, 0x0000003f00567308ULL, 0x000fe20000000800ULL,
0xfffffff873737812ULL, 0x000fe400078ee20cULL, 0x00000043420c723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b15437823ULL, 0x000fe2000001082dULL, 0x0000001b320f723eULL, 0x002fc600000000ffULL,
0x00000026005b7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b14327823ULL, 0x000fce000001082dULL,
0x0000002800367308ULL, 0x000fe20000000800ULL, 0x000000340824723cULL, 0x082f6e00000018ffULL,
0x00000029003f7308ULL, 0x0003f00000000800ULL, 0x0000005300537308ULL, 0x000fe20000000800ULL,
0x000000340c28723cULL, 0x002f6e00000018ffULL, 0x0000005200527308ULL, 0x000e700000000800ULL,
0x0000005800587308ULL, 0x000eb00000000800ULL, 0x0000002c002c7308ULL, 0x000fe20000000800ULL,
0x000000535214723eULL, 0x002fc400000000ffULL, 0x0000000868537810ULL, 0x000fca0007ffe0ffULL,
0x0000004900497308ULL, 0x000e620000000800ULL, 0x000000575816723eULL, 0x004fe400000000ffULL,
0x0000001068577810ULL, 0x000fca0007ffe0ffULL, 0x0000002e002e7308ULL, 0x000eb00000000800ULL,
0x0000003700377308ULL, 0x000fe20000000800ULL, 0x0000002c4915723eULL, 0x002fe200000000ffULL,
0x00000008532c7824ULL, 0x000fc400078e00ffULL, 0x0000000868497824ULL, 0x000fc600078e00ffULL,
0xfffffff82c537812ULL, 0x000fe200078ee253ULL, 0x0000003800387308ULL, 0x000e620000000800ULL,
0x0000002e5917723eULL, 0x004fe200000000ffULL, 0x00000008572e7824ULL, 0x000fe200078e00ffULL,
0x0000001868597810ULL, 0x000fe40007ffe0ffULL, 0xfffffff849497812ULL, 0x000fe400078ee268ULL,
0xfffffff82e577812ULL, 0x000fe200078ee257ULL, 0x0000003900397308ULL, 0x000fe20000000800ULL,
0x000000341424723cULL, 0x020f6e0000001824ULL, 0x0000003a003a7308ULL, 0x000ff00000000800ULL,
0x0000001a00547308ULL, 0x0004f00000000800ULL, 0x0000001900427308ULL, 0x0007e20000000800ULL,
0x3fb8aa3b181a7823ULL, 0x004fe2000001082dULL, 0x000000373818723eULL, 0x002fe200000000ffULL,
0x0000000859387824ULL, 0x000fca00078e00ffULL, 0x0000001a00137308ULL, 0x0002a20000000800ULL,
0x000000363f19723eULL, 0x008fe400000000ffULL, 0x0000005b541b723eULL, 0x000fe400000000ffULL,
0xfffffff838597812ULL, 0x000fc600078ee259ULL, 0x0000002f002f7308ULL, 0x000fe20000000800ULL,
0x000000393a1a723eULL, 0x002fce00000000ffULL, 0x0000004800487308ULL, 0x000e620000000800ULL,
0x000000341828723cULL, 0x000f620000001828ULL, 0x000000421339723eULL, 0x004fcc00000000ffULL,
0x0000005100517308ULL, 0x000ff00000000800ULL, 0x0000005000507308ULL, 0x000ea20000000800ULL,
0x0000002f482d723eULL, 0x002fce00000000ffULL, 0x0000004f004f7308ULL, 0x000ff00000000800ULL,
0x0000004e004e7308ULL, 0x000e620000000800ULL, 0x00000051502c723eULL, 0x004fce00000000ffULL,
0x0000003100317308ULL, 0x000eb00000000800ULL, 0x0000003b003b7308ULL, 0x000fe20000000800ULL,
0x0000004f4e2e723eULL, 0x002fce00000000ffULL, 0x0000003c003c7308ULL, 0x000e620000000800ULL,
0x00000031562f723eULL, 0x004fce00000000ffULL, 0x0000003d003d7308ULL, 0x000fe20000000800ULL,
0x000000342c24723cULL, 0x020f6e0000001824ULL, 0x0000003e003e7308ULL, 0x000ea20000000800ULL,
0x0000003b3c38723eULL, 0x002fe400000000ffULL, 0x00012000203c7811ULL, 0x000fca00078e60ffULL,
0x0000001200127308ULL, 0x000fe20000000800ULL, 0x0000001049497824ULL, 0x100fe400078e023cULL,
0x0000001067677824ULL, 0x100fe400078e023cULL, 0x0000001069697824ULL, 0x100fe400078e023cULL,
0x000000106b6b7824ULL, 0x100fe200078e023cULL, 0x0000003000377308ULL, 0x000e620000000800ULL,
0x0000003d3e3a723eULL, 0x004fe200000000ffULL, 0x000000106d6d7824ULL, 0x000fc400078e023cULL,
0x000000106f6f7824ULL, 0x100fe400078e023cULL, 0x0000001071717824ULL, 0x100fe400078e023cULL,
0x0000003300337308ULL, 0x000ea20000000800ULL, 0x0000001073737824ULL, 0x100fe400078e023cULL,
0x0000001053537824ULL, 0x100fe400078e023cULL, 0x0000001057577824ULL, 0x100fe400078e023cULL,
0x0000001059597824ULL, 0x000fe200078e023cULL, 0x00000012373b723eULL, 0x002fe200000000ffULL,
0x0000004d004d7308ULL, 0x000fe20000000800ULL, 0x0000000c11127812ULL, 0x000fca00078ec0ffULL,
0x000000343828723cULL, 0x000fe20000001828ULL, 0x0000005a3331723eULL, 0x004fe200000000ffULL,
0x0000004c004c7308ULL, 0x000e620000000800ULL, 0x0000000149497824ULL, 0x000fe400078e0212ULL,
0x0000000112677824ULL, 0x040fe400078e0267ULL, 0x0000000112697824ULL, 0x040fe200078e0269ULL,
0x0000000849007388ULL, 0x0005e20000000800ULL, 0x00000001126b7824ULL, 0x040fe200078e026bULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x00000001126d7824ULL, 0x040fe200078e026dULL,
0x0000000a67007388ULL, 0x0007e20000000800ULL, 0x00000001126f7824ULL, 0x000fc400078e026fULL,
0x0000000112717824ULL, 0x040fe200078e0271ULL, 0x0000001469007388ULL, 0x0007e20000000800ULL,
0x0000000112737824ULL, 0x000fe200078e0273ULL, 0x0000004a004a7308ULL, 0x000fe20000000800ULL,
0x0000004d4c30723eULL, 0x002fe200000000ffULL, 0x0000000112087824ULL, 0x044fe200078e0253ULL,
0x000000166b007388ULL, 0x0007e20000000800ULL, 0x0000000112577824ULL, 0x040fe400078e0257ULL,
0x0000000112127824ULL, 0x000fe200078e0259ULL, 0x0000002c6d007388ULL, 0x0007e20000000800ULL,
0x0000004600467308ULL, 0x000e660000000800ULL, 0x0000002e6f007388ULL, 0x0007e80000000800ULL,
0x0000003071007388ULL, 0x0007e20000000800ULL, 0x0000004700477308ULL, 0x000ff00000000800ULL,
0x0000004000407308ULL, 0x000ea20000000800ULL, 0x000000464533723eULL, 0x002fce00000000ffULL,
0x0000004100417308ULL, 0x000ff00000000800ULL, 0x0000004400447308ULL, 0x000e620000000800ULL,
0x00000047403c723eULL, 0x004fce00000000ffULL, 0x0000003200367308ULL, 0x0005f00000000800ULL,
0x0000004300437308ULL, 0x000ee20000000800ULL, 0x0000004b4a32723eULL, 0x004fe400000000ffULL,
0x00000041443e723eULL, 0x002fc600000000ffULL, 0x0000003273007388ULL, 0x0003e40000000800ULL,
0x00000055003f7308ULL, 0x000fe20000000800ULL, 0x000000343024723cULL, 0x020f620000001824ULL,
0x0000000908007388ULL, 0x0003e80000000800ULL, 0x0004000b67007388ULL, 0x0003e40000000800ULL,
0x0000006600667308ULL, 0x000ea20000000800ULL, 0x00000036433d723eULL, 0x008fe200000000ffULL,
0x0004001569007388ULL, 0x0003e80000000800ULL, 0x000400176b007388ULL, 0x0003e80000000800ULL,
0x0004002d6d007388ULL, 0x0003e80000000800ULL, 0x0004002f6f007388ULL, 0x0003e20000000800ULL,
0x0000003f663f723eULL, 0x004fc400000000ffULL, 0x000000ffff257224ULL, 0x020fe200078e0026ULL,
0x0004003171007388ULL, 0x0003e80000000800ULL, 0x0004003373007388ULL, 0x0003e20000000800ULL,
0x000000343c28723cULL, 0x000f660000001828ULL, 0x0000000c57007388ULL, 0x0003e80000000800ULL,
0x0008000e67007388ULL, 0x0003e80000000800ULL, 0x0008001869007388ULL, 0x0003e80000000800ULL,
0x0008001a6b007388ULL, 0x0003e80000000800ULL, 0x000800386d007388ULL, 0x0003e80000000800ULL,
0x0008003a6f007388ULL, 0x0003e20000000800ULL, 0x000000ffff267224ULL, 0x020fc400078e0028ULL,
0x000000ffff277224ULL, 0x000fe200078e002aULL, 0x0008003c71007388ULL, 0x0003e80000000800ULL,
0x0008003e73007388ULL, 0x0003e80000000800ULL, 0x0000000d12007388ULL, 0x0003e80000000800ULL,
0x000c000f67007388ULL, 0x0003e80000000800ULL, 0x000c001969007388ULL, 0x0003e80000000800ULL,
0x000c001b6b007388ULL, 0x0003e80000000800ULL, 0x000c00396d007388ULL, 0x0003e80000000800ULL,
0x000c003b6f007388ULL, 0x0003e80000000800ULL, 0x000c003d71007388ULL, 0x0003e80000000800ULL,
0x000c003f73007388ULL, 0x0003e80000000800ULL, 0x01a0000410008388ULL, 0x0003e80000000c00ULL,
0x01a2002410008388ULL, 0x0003e20000000c00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000062ff7f8cULL, 0x0005e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000080062ff7f8cULL, 0x0007e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000100062ff7f8cULL, 0x0003e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000163637810ULL, 0x000fe20007ffe0ffULL, 0x0000180062ff7f8cULL, 0x0003e4000c80043fULL,
0x000000ffff697224ULL, 0x002fe200078e005fULL, 0x0000001c6300720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff8dd000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff287807ULL, 0x008fe20004000000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x00017a3000297802ULL, 0x000fc40000000f00ULL,
0x0000160000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff037224ULL, 0x000fe200078e0028ULL,
0xfffeae9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe20005800000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x00017a9000297802ULL, 0x000fc40000000f00ULL,
0x000015a000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0028ULL,
0xfffeaec000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x00017b0000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000014e000007944ULL, 0x014fea0003c00000ULL,
0xfffeaf7000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x00017b6000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000148000007944ULL, 0x016fea0003c00000ULL,
0xfffeb08000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x00017bc000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000142000007944ULL, 0x01efea0003c00000ULL,
0xfffeb19000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x00017c2000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000013c000007944ULL, 0x01efea0003c00000ULL,
0xfffeb29000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x00017c9000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0003ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000135000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0xfffeb69000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x00017d0000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000012e000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0x0000001003297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0000ULL, 0x00017d7000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000127000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0029ULL,
0xfffeb60000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x00017de000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000120000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0029ULL, 0xfffeb5c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x008fe20004000000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x00017e4000297802ULL, 0x000fc40000000f00ULL, 0x000011f000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff257224ULL, 0x000fe200078e0028ULL, 0xfffed74000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe20005800000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x00017ea000297802ULL, 0x000fc40000000f00ULL, 0x0000119000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff787224ULL, 0x000fe200078e0028ULL, 0xfffed77000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e007aULL, 0x00017f1000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000010d000007944ULL, 0x004fea0003c00000ULL, 0xfffed83000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e007aULL, 0x00017f7000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000107000007944ULL, 0x006fea0003c00000ULL, 0xfffed94000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e007aULL, 0x00017fd000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000101000007944ULL, 0x00efea0003c00000ULL, 0xfffeda5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e007aULL, 0x0001803000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000fb000007944ULL, 0x00efea0003c00000ULL, 0xfffedb5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x000180a000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fe400078e0025ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000f4000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0xfffedf5000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001811000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000ed000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0x0000001025297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001818000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000e6000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0029ULL, 0xfffedec000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x000181f000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000df000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0029ULL,
0xfffede8000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x004fe20004000000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x0001825000297802ULL, 0x000fc40000000f00ULL,
0x00000de000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff717224ULL, 0x000fe200078e0028ULL,
0xfffefe0000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe20005800000ULL,
0xffffffffff2a7424ULL, 0x000fe200078e00ffULL, 0x000182b000297802ULL, 0x000fc40000000f00ULL,
0x00000d8000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff227224ULL, 0x000fe200078e0028ULL,
0xfffefe4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e007aULL,
0x0001832000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000cc000007944ULL, 0x018fea0003c00000ULL,
0xfffeff0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e007aULL,
0x0001838000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000c6000007944ULL, 0x01afea0003c00000ULL,
0xffff001000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e007aULL,
0x000183e000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000c0000007944ULL, 0x01afea0003c00000ULL,
0xffff012000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e007aULL,
0x0001844000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000ba000007944ULL, 0x01afea0003c00000ULL,
0xffff022000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x000184b000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fe400078e0023ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000b3000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0xffff060000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001852000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x00000ac000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0x0000001023297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001859000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x00000a5000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0029ULL,
0xffff057000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001860000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x000009e000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0029ULL, 0xffff053000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x004fe20004000000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x0001866000297802ULL, 0x000fc40000000f00ULL, 0x000009d000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e0028ULL, 0xffff248000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe20005800000ULL, 0xffffffffff2a7424ULL, 0x000fe200078e00ffULL,
0x000186c000297802ULL, 0x000fc40000000f00ULL, 0x0000097000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff237224ULL, 0x000fe200078e0028ULL, 0xffff24c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x0001873000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000008b000007944ULL, 0x018fea0003c00000ULL, 0xffff257000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x0001879000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000085000007944ULL, 0x01afea0003c00000ULL, 0xffff268000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x000187f000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000007f000007944ULL, 0x01afea0003c00000ULL, 0xffff279000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x0001885000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fc400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x0000079000007944ULL, 0x01afea0003c00000ULL, 0xffff289000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x000188c000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fe400078e0006ULL, 0x0000001fff707424ULL, 0x000fe400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000072000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0xffff2c9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x0001893000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000006b000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0x0000001006297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0003ULL,
0x000189a000287802ULL, 0x000fe20000000f00ULL, 0x0000001fff707424ULL, 0x000fc400078e00ffULL,
0xffffffffff2b7424ULL, 0x000fc400078e00ffULL, 0x0000064000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0029ULL, 0xffff2c0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x00018a1000287802ULL, 0x000fe20000000f00ULL,
0x0000001fff707424ULL, 0x000fe400078e00ffULL, 0xffffffffff2b7424ULL, 0x000fc400078e00ffULL,
0x000005d000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0029ULL,
0xffff2bc000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x000fe200078e0005ULL,
0x00018a9000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0c7424ULL, 0x000fe400078e00ffULL,
0x0000001fff0b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5a7424ULL, 0x000fc400078e00ffULL,
0x0000051000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff047224ULL, 0x004fe200078e000bULL,
0xffffdb1000007947ULL, 0x000fea000383ffffULL, 0x000000ffff077224ULL, 0x002fe200078e000aULL,
0x00018b1000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0c7424ULL, 0x000fe400078e00ffULL,
0x0000001fff0b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5a7424ULL, 0x000fc400078e00ffULL,
0x0000049000007944ULL, 0x014fea0003c00000ULL, 0x0000000b0a00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000eULL, 0x00018b9000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000a0b067208ULL, 0x000fe20004000000ULL,
0x0000001fff0b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5a7424ULL, 0x000fc400078e00ffULL,
0x0000041000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000dULL, 0x00018c1000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000e0b0e7208ULL, 0x000fe20004000000ULL,
0x0000001fff0b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5a7424ULL, 0x000fc400078e00ffULL,
0x0000039000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0d00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000fULL, 0x00018c9000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000d0b0a7208ULL, 0x000fe20004000000ULL,
0x0000001fff0b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5a7424ULL, 0x000fc400078e00ffULL,
0x0000031000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0f00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e0006ULL, 0x00018d1000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000f0b047208ULL, 0x000fe20004000000ULL,
0x0000001fff0b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5a7424ULL, 0x000fc400078e00ffULL,
0x0000029000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0600720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000eULL, 0x00018d9000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x000000060b057208ULL, 0x000fe20004000000ULL,
0x0000001fff0b7424ULL, 0x000fc400078e00ffULL, 0xffffffffff5a7424ULL, 0x000fc400078e00ffULL,
0x0000021000007944ULL, 0x000fea0003c00000ULL, 0x0000000b0e00720bULL, 0x004fe20003f1e000ULL,
0x000000ffff077224ULL, 0x002fe200078e000aULL, 0x00018e1000087802ULL, 0x000fe20000000f00ULL,
0x00000001ff0c7424ULL, 0x000fe200078e00ffULL, 0x0000000e0b067208ULL, 0x000fe20004000000ULL,
0x0000001fff0b7424ULL, 0x000fe400078e00ffULL, 0xffffffffff5a7424ULL, 0x000fc400078e00ffULL,
0x0000019000007944ULL, 0x000fea0003c00000ULL, 0xffffd90000007947ULL, 0x000fea000383ffffULL,
0x0180000021007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000002100008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff21ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000021027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000002100007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffe706002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff097424ULL, 0x000fe200078e00ffULL, 0x0000005a00007348ULL, 0x000fe80003800000ULL,
0x0c00000c070b7389ULL, 0x0002a200000e000bULL, 0xfffe702008007950ULL, 0x000fea0003c3ffffULL,
0x0000002b00007348ULL, 0x000fe80003800000ULL, 0x000000292a297389ULL, 0x0002a400000e0070ULL,
0x000000ffff2a7224ULL, 0x002fc400078e0028ULL, 0x00000000ff2b7424ULL, 0x000fc800078e00ffULL,
0xfffe6fd02a007950ULL, 0x000fea0003c3ffffULL, 0x000000012800780cULL, 0x000fe20003f65070ULL,
0x0000002a00007348ULL, 0x000fe80003800000ULL, 0x00000000ff2b7424ULL, 0x000fd000078e00ffULL,
0x0000000000287806ULL, 0x000fc800058e0100ULL, 0x0000002a28287212ULL, 0x000fe200078ec0ffULL,
0x000000ffff2a7224ULL, 0x000fc800078e0029ULL, 0xfffe6f602a007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000560ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c0ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000930ULL,
0x0000000000000350ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c80ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d40ULL,
0x00000000000008a0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001680ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001684ULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x0000000000019180ULL, 0xde00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001aa00ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001aa40ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001adc0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000019380ULL,
0x0000000000019380ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001aa00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001adc0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_80_cubin_len = 110240;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
