/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_89_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x00000000000190c0ULL, 0x0000000000018d40ULL, 0x0038004000590559ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x746e695f5f240068ULL,
0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL, 0x66625f636e79736cULL,
0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL, 0x5f30376d735f6164ULL,
0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL, 0x5f5f245f335f6c61ULL,
0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL, 0x2e616c65722e0074ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x766e2e0066754265ULL,
0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL, 0x65642e006d617261ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x00000000006e6f69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c000100000377ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000003c5ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000040bULL, 0x0000000000017130ULL,
0x0000000000000180ULL, 0x000b00220000043eULL, 0x00000000000172b0ULL, 0x0000000000000040ULL,
0x000b002200000469ULL, 0x00000000000172f0ULL, 0x0000000000000050ULL, 0x000b002200000493ULL,
0x0000000000017340ULL, 0x0000000000000140ULL, 0x000a000300000501ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0007000300000551ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000017480ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001713000000000ULL,
0x0000040400000000ULL, 0x810c000001640400ULL, 0x005adc0400288080ULL, 0x0000000000000000ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x0001713000000000ULL,
0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080830828ULL, 0x2880808c08288080ULL,
0x808e082880808d08ULL, 0x082880808f082880ULL, 0x8080a308288080a2ULL, 0xa808288080a50828ULL,
0x288080aa08288080ULL, 0x80f108288080ef08ULL, 0x08288080f2082880ULL, 0x8082801628808088ULL,
0x0000000000031028ULL, 0x2880808892000000ULL, 0x0000000000002200ULL, 0x0000001cffffffffULL,
0x000000f000000000ULL, 0x000172b000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x0000008cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8808288080830828ULL, 0x2880808c08288080ULL,
0x808e082880808d08ULL, 0x082880808f082880ULL, 0x8080a308288080a2ULL, 0xa908288080a50828ULL,
0x288080aa08288080ULL, 0x80f108288080ef08ULL, 0x08288080f2082880ULL, 0x80828016288080a8ULL,
0x0000000000031028ULL, 0x288080a892000000ULL, 0x0000000000002200ULL, 0x0000002cffffffffULL,
0x000001b000000000ULL, 0x000172f000000000ULL, 0x0000005000000000ULL, 0x0000100400000000ULL,
0x80aa288080a80900ULL, 0x0000000000002880ULL, 0x0000008cffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8808288080830828ULL, 0x2880808c08288080ULL, 0x808e082880808d08ULL, 0x082880808f082880ULL,
0x8080a308288080a2ULL, 0xa808288080a50828ULL, 0x288080aa08288080ULL, 0x80f108288080ef08ULL,
0x08288080f2082880ULL, 0x80828016288080a9ULL, 0x0000000000031028ULL, 0x288080a992000000ULL,
0x0000000000002200ULL, 0x0000002cffffffffULL, 0x0000028000000000ULL, 0x0001734000000000ULL,
0x0000014000000000ULL, 0x0000080400000000ULL, 0x80aa288080a90900ULL, 0x0000000000002880ULL,
0x0000001900082f04ULL, 0x00082304000000deULL, 0x0000000000000015ULL, 0x0000001500081204ULL,
0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL, 0x0008120400000000ULL,
0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001200082304ULL,
0x0008120400000000ULL, 0x0000000000000012ULL, 0x0000001200081104ULL, 0x0008230400000000ULL,
0x0000000000000019ULL, 0x0000001900081204ULL, 0x0008110400000000ULL, 0x0000000000000019ULL,
0x0000007b00043704ULL, 0x0000001600080a04ULL, 0x0060190300600160ULL, 0x00000000000c1704ULL,
0x0021f00000580009ULL, 0x00000000000c1704ULL, 0x0021f00000500008ULL, 0x00000000000c1704ULL,
0x0011f00000480007ULL, 0x00000000000c1704ULL, 0x0081f00000280006ULL, 0x00000000000c1704ULL,
0x0021f00000200005ULL, 0x00000000000c1704ULL, 0x0021f00000180004ULL, 0x00000000000c1704ULL,
0x0021f00000100003ULL, 0x00000000000c1704ULL, 0x0011f00000080002ULL, 0x00000000000c1704ULL,
0x0011f00000040001ULL, 0x00000000000c1704ULL, 0x0011f00000000000ULL, 0x0004310400ff1b03ULL,
0x019c290400000b00ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x019c2804ffffffffULL, 0x000002d000000100ULL, 0x000028e000000580ULL, 0x00002aa000002990ULL,
0x00002d8000002c10ULL, 0x0000336000002ee0ULL, 0x000033b0000033a0ULL, 0x000055d0000033e0ULL,
0x0000578000005660ULL, 0x00005a60000058f0ULL, 0x0000604000005bc0ULL, 0x0000609000006080ULL,
0x000080a0000060c0ULL, 0x0000826000008140ULL, 0x00008540000083d0ULL, 0x00008b00000086a0ULL,
0x00008b5000008b40ULL, 0x0000ab3000008b80ULL, 0x0000ace00000abd0ULL, 0x0000afc00000ae50ULL,
0x0000b5a00000b120ULL, 0x0000b5f00000b5e0ULL, 0x0000caa00000b620ULL, 0x0000cac00000cab0ULL,
0x00014e500000cad0ULL, 0x00014ea000014e90ULL, 0x00014f0000014eb0ULL, 0x00014f4000014f20ULL,
0x000162b000014f50ULL, 0x0001635000016300ULL, 0x000163d000016390ULL, 0x0001646000016410ULL,
0x00016500000164b0ULL, 0x000165a000016550ULL, 0x00016640000165f0ULL, 0x000166c000016680ULL,
0x0001675000016700ULL, 0x000167f0000167a0ULL, 0x0001689000016840ULL, 0x00016930000168e0ULL,
0x000169b000016970ULL, 0x00016a40000169f0ULL, 0x00016ae000016a90ULL, 0x00016b8000016b30ULL,
0x00016c2000016bd0ULL, 0x00016ca000016c60ULL, 0x00016d3000016ce0ULL, 0x00016dd000016d80ULL,
0x00016e7000016e20ULL, 0x00016f3000016ed0ULL, 0x00016ff000016f90ULL, 0x000170b000017050ULL,
0x0440390400017110ULL, 0x000000ff000003c0ULL, 0x003f010000012600ULL, 0x0000000d00000400ULL,
0x003f012000012608ULL, 0x0000000d000004f0ULL, 0x003f012000012688ULL, 0x0000000d00000510ULL,
0x003f0120000126a8ULL, 0x0000000d00000540ULL, 0x003f0120000126c8ULL, 0x000000ff00000b20ULL,
0x003f010700012600ULL, 0x0000000600000d10ULL, 0x003f010200000004ULL, 0x0000000600000dc0ULL,
0x003f010100000000ULL, 0x000000ff00001730ULL, 0x0004010700000000ULL, 0x000000ff000017b0ULL,
0x0004010100000000ULL, 0x0000000600001810ULL, 0x003f010100000020ULL, 0x00000008000019c0ULL,
0x003f0105000126ccULL, 0x0000000800001b90ULL, 0x003f0105000126ccULL, 0x0000000a000024d0ULL,
0x003f0107000126b0ULL, 0x0000000a00002580ULL, 0x003f0101000126b0ULL, 0x00000022000025e0ULL,
0x003f010100012608ULL, 0x0000002200002600ULL, 0x003f01050001260cULL, 0x00000022000027d0ULL,
0x003f01050001260cULL, 0x0000000a00003090ULL, 0x003f0105000126acULL, 0x0000000a00003280ULL,
0x003f0105000126acULL, 0x0000006c00004790ULL, 0x003f010100000000ULL, 0x00000025000047f0ULL,
0x003f010100012688ULL, 0x0000001400004820ULL, 0x003f010500000004ULL, 0x00000014000049e0ULL,
0x003f010500000004ULL, 0x00000010000051d0ULL, 0x003f010700000000ULL, 0x00000010000052b0ULL,
0x003f010100000000ULL, 0x0000002200005310ULL, 0x003f010100012628ULL, 0x0000002200005330ULL,
0x003f01050001262cULL, 0x0000002200005500ULL, 0x003f01050001262cULL, 0x0000006e00005db0ULL,
0x003f0105000126b4ULL, 0x0000006e00005f80ULL, 0x003f0105000126b4ULL, 0x0000006e00007240ULL,
0x003f010100000000ULL, 0x00000028000072a0ULL, 0x003f010100012690ULL, 0x00000014000072d0ULL,
0x003f010500000004ULL, 0x0000001400007490ULL, 0x003f010500000004ULL, 0x000000ff00007c90ULL,
0x0004010700000008ULL, 0x0000002a00007d80ULL, 0x003f0101000126b0ULL, 0x0000002200007de0ULL,
0x003f010100012648ULL, 0x0000002200007e00ULL, 0x003f01050001264cULL, 0x0000002200007fd0ULL,
0x003f01050001264cULL, 0x0000001000008870ULL, 0x003f010500000004ULL, 0x0000001000008a40ULL,
0x003f010500000004ULL, 0x0000001400009ce0ULL, 0x003f010100000000ULL, 0x0000000200009d40ULL,
0x003f010100012698ULL, 0x0000001400009d70ULL, 0x003f010500000004ULL, 0x0000001400009f30ULL,
0x003f010500000004ULL, 0x000000ff0000a790ULL, 0x0004010700000000ULL, 0x000000100000a820ULL,
0x003f010100000000ULL, 0x000000060000a880ULL, 0x003f010100012668ULL, 0x000000060000a8b0ULL,
0x003f01050001266cULL, 0x000000060000aa80ULL, 0x003f01050001266cULL, 0x000000080000b300ULL,
0x003f0105000126b4ULL, 0x000000080000b4d0ULL, 0x003f0105000126b4ULL, 0x000000140000c850ULL,
0x003f010100000000ULL, 0x000000060000c8d0ULL, 0x003f010100000000ULL, 0x000000ff0000e640ULL,
0x003f010100012600ULL, 0x000000ff0000f270ULL, 0x003f010500012604ULL, 0x000000ff0000f440ULL,
0x003f010500012604ULL, 0x000000ff0000f7c0ULL, 0x003f010100012600ULL, 0x000000ff0000f7f0ULL,
0x003f010500012604ULL, 0x000000ff0000f9b0ULL, 0x003f010500012604ULL, 0x0000006700012310ULL,
0x003f010100000000ULL, 0x0000006700012440ULL, 0x003f010500000004ULL, 0x0000006700012610ULL,
0x003f010500000004ULL, 0x0000006600016110ULL, 0x003f010100000000ULL, 0x0000006600016170ULL,
0x003f010100000008ULL, 0x00000066000161d0ULL, 0x003f010100000010ULL, 0x0000006600016240ULL,
0x003f010100000018ULL, 0x00301c0400053803ULL, 0x0000da000000d9d0ULL, 0x0000dd400000dbe0ULL,
0x0000e0000000dea0ULL, 0x0000e2c00000e160ULL, 0x0000e5500000e450ULL, 0x000162800000fa10ULL,
0x000c050400000401ULL, 0x0000000100000100ULL, 0x00041e0400000001ULL, 0x0000000000000000ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000032cULL, 0x0000001900000002ULL,
0x000000000000025cULL, 0x0000001900000002ULL, 0x000000000000019cULL, 0x0000001900000002ULL,
0x00000000000000ccULL, 0x0000001900000002ULL, 0x0000000000000044ULL, 0x0000001900000002ULL,
0x0000000000000303ULL, 0x0000001900000002ULL, 0x0000000000000233ULL, 0x0000001900000002ULL,
0x0000000000000173ULL, 0x0000001900000002ULL, 0x00000000000000a8ULL, 0x0000001900000002ULL,
0x0000000000012700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0e7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000767919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000b7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000e827a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000f220000002100ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL,
0x00000005ff207819ULL, 0x010fc80000011609ULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x00001fff20207589ULL, 0x000fe200000e0000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x000000ffff057224ULL, 0x010fc800078e0a03ULL, 0x0000590005057a24ULL, 0x000fc800078e02ffULL,
0x0000000503037227ULL, 0x000fcc00078e0002ULL, 0x0000040003077a27ULL, 0x000fc800078e00ffULL,
0x000000ffff037224ULL, 0x000fc800078e0a07ULL, 0x0000040003007624ULL, 0x000fca00078e020eULL,
0x0000590000007a0cULL, 0x000fda0003f06070ULL, 0x8000590000000a10ULL, 0x000fe40007ffe0ffULL,
0x0000000107070810ULL, 0x000fe40007ffe0ffULL, 0x0000590000007a0cULL, 0x000fda0003f26070ULL,
0x0000000107071810ULL, 0x000fe40007ffe0ffULL, 0x00005900ff07aa12ULL, 0x000fc800078e33ffULL,
0x0000000700007306ULL, 0x000e620000209000ULL, 0x000000ff0700720cULL, 0x000fce0003f85070ULL,
0x0000000000007308ULL, 0x002e640000001000ULL, 0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x000000ffff027224ULL, 0x002fe400078e00ffULL,
0x0000000307047224ULL, 0x010fc800078e02ffULL, 0x000000ffff057224ULL, 0x000fe400078e0a04ULL,
0x0000000000047919ULL, 0x000ee40000002200ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000007603197227ULL, 0x004fc800078e00ffULL, 0x000000ffff007224ULL, 0x000fc800078e0a19ULL,
0x0000000007007224ULL, 0x000fca00078e0276ULL, 0x000000070000720cULL, 0x000fe20003f46070ULL,
0x000001000b027a24ULL, 0x008fe400078e0204ULL, 0x00001fff0b0b7589ULL, 0x000e6400000e0000ULL,
0x00000000020d7a24ULL, 0x000fca00078e0209ULL, 0x000000ff0d00720cULL, 0x000fc60003fa5270ULL,
0x0000000100002824ULL, 0x000fe200078e0a07ULL, 0x0000000119192810ULL, 0x000fe40007ffe0ffULL,
0x0000000f0d00780cULL, 0x040fe40003f24070ULL, 0x000000070000720cULL, 0x000fe40003f66070ULL,
0x0000007f0d00780cULL, 0x040fe40003f04070ULL, 0x000000030d00780cULL, 0x000fe20003f44070ULL,
0x3fffff80ff02d424ULL, 0x000fc400078e00ffULL, 0x7fffff80ff03d424ULL, 0x000fc800078e00ffULL,
0x3fffffc0ff049424ULL, 0x000fe400078e00ffULL, 0x0000000119193810ULL, 0x000fe20007ffe0ffULL,
0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL, 0x00000007ff19c212ULL, 0x000fe200078e33ffULL,
0x01260002ff00d388ULL, 0x0005e20000000a00ULL, 0xff317217ff0a8424ULL, 0x000fe200078e00ffULL,
0x000000010d00780cULL, 0x000fe20003f64070ULL, 0x3fffff80ff06a424ULL, 0x000fe200078e00ffULL,
0x012608040d009388ULL, 0x0007e20000008a00ULL, 0x000000ffff007224ULL, 0x000fe200078e0a19ULL,
0x00005a0019757a19ULL, 0x000fc400000006ffULL, 0x0124000a0d008388ULL, 0x000fe20000004800ULL,
0x0000000007767224ULL, 0x000fe400078e0276ULL, 0x3fffff60ff02a424ULL, 0x004fe400078e00ffULL,
0x0000002076007824ULL, 0x000fe400078e00ffULL, 0x7fffff60ff03a424ULL, 0x000fe200078e00ffULL,
0x0000000000047919ULL, 0x008ea20000002700ULL, 0x7fffff80ff07a424ULL, 0x000fe200078e00ffULL,
0x0000000400057c10ULL, 0x040fe2000fffe1ffULL, 0x3fffffc0ff08b424ULL, 0x000fe200078e00ffULL,
0x0000000400007c0cULL, 0x000fe2000bf03070ULL, 0x7fffffc0ff09b424ULL, 0x000fe200078e00ffULL,
0x0000002005057817ULL, 0x000fe20003800000ULL, 0x012688020d00a388ULL, 0x0005e60000008a00ULL,
0x000000ff05747207ULL, 0x000fe20000000000ULL, 0x0126a8060d00a388ULL, 0x000fe20000008a00ULL,
0x000000040b057824ULL, 0x002fc400078e0220ULL, 0x000000207400780cULL, 0x000fe20003f05270ULL,
0x0126c8080d00b388ULL, 0x000fe20000008a00ULL, 0x0000000405057824ULL, 0x000fe400078e00ffULL,
0x0000580004027a24ULL, 0x004fc800078e02ffULL, 0x0000008202027224ULL, 0x000fe200078e0275ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x00000000001f7919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000000574067217ULL, 0x000fe20007800000ULL, 0x00005a0000057ab9ULL, 0x000fc40000000800ULL,
0x0000000504047299ULL, 0x000fe4000800063fULL, 0x0000000106067824ULL, 0x000fe200078e0a05ULL,
0x00000004ff037819ULL, 0x002fc8000001161fULL, 0x00000002030a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000105087824ULL, 0x000fe200078e0203ULL, 0x000000060300720cULL, 0x080fe40003f06070ULL,
0x000000060a00720cULL, 0x000fe20003f26070ULL, 0x00000001050c7824ULL, 0x000fe400078e020aULL,
0x0000000100077824ULL, 0x040fe400078e0208ULL, 0x00000001000d7824ULL, 0x000fe400078e020cULL,
0x000000101f057824ULL, 0x000fe200078e00ffULL, 0x0000000407097c12ULL, 0x000fe2000f8e30ffULL,
0x00000001080a7824ULL, 0x000fe200078e021fULL, 0x000000040d0f7c12ULL, 0x000fc4000f8e30ffULL,
0x00005a00ff077a19ULL, 0x000fe20000011607ULL, 0x0000000102097824ULL, 0x040fe200078e0209ULL,
0x00005a00ff0d7a19ULL, 0x000fe2000001160dULL, 0x00000001020f7824ULL, 0x000fe400078e020fULL,
0x0000008207027224ULL, 0x080fe200078e0209ULL, 0x000000f005097812ULL, 0x000fe200078ec0ffULL,
0x000000820d077224ULL, 0x000fe400078e020fULL, 0x0000010002027825ULL, 0x000fc800078e00ffULL,
0x0000010007067825ULL, 0x000fe200078e00ffULL, 0x0000000902027212ULL, 0x000fc600078efcffULL,
0x00000010080d7824ULL, 0x000fe200078e00ffULL, 0x0000000906067212ULL, 0x000fe200078efcffULL,
0x000000010c087824ULL, 0x000fe200078e021fULL, 0x00005e0002027a10ULL, 0x000fe20007f5e0ffULL,
0x000000100c097824ULL, 0x000fe200078e00ffULL, 0xfffffff00d0a7812ULL, 0x000fe400078ee20aULL,
0x00005e0006067a10ULL, 0x000fe40007f7e0ffULL, 0xfffffff009087812ULL, 0x000fe200078ee208ULL,
0x000000100a097824ULL, 0x000fe200078e00ffULL, 0x00005f0003037a10ULL, 0x000fc400017fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20001ffe4ffULL, 0x00000010080d7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000c101c48ULL,
0x00000000060d7faeULL, 0x0003e2000c901c48ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x00000000001f7919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fc40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x000000051f087211ULL, 0x002fc800078fe0ffULL, 0x00000002080a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100037824ULL, 0x000fe400078e0208ULL, 0x0000000108097824ULL, 0x000fe400078e021fULL,
0x0000000100067824ULL, 0x000fe200078e020aULL, 0x0000000403057c12ULL, 0x000fe2000f8e30ffULL,
0x00000010080c7824ULL, 0x000fe200078e00ffULL, 0x00005a00ff037a19ULL, 0x000fe20000011603ULL,
0x000000010a087824ULL, 0x000fe200078e021fULL, 0x0000000406077c12ULL, 0x000fe2000f8e30ffULL,
0x0000000102057824ULL, 0x000fe200078e0205ULL, 0xfffffff00c097812ULL, 0x000fc600078ee209ULL,
0x0000000102027824ULL, 0x000fe200078e0207ULL, 0x00005a00ff077a19ULL, 0x000fe20000011606ULL,
0x0000008203037224ULL, 0x080fe400078e0205ULL, 0x000000101f057824ULL, 0x000fe400078e00ffULL,
0x0000008207077224ULL, 0x000fe400078e0202ULL, 0x0000010003027825ULL, 0x000fe200078e00ffULL,
0x000000f0050d7812ULL, 0x000fc600078ec0ffULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x0000000d02027212ULL, 0x000fc600078efcffULL, 0x0000001009097824ULL, 0x000fe200078e00ffULL,
0x0000000d06067212ULL, 0x000fe200078efcffULL, 0x000000100a0d7824ULL, 0x000fe200078e00ffULL,
0x00005e0002027a10ULL, 0x000fe40007f1e0ffULL, 0x00005e0006067a10ULL, 0x000fe40007f3e0ffULL,
0xfffffff00d087812ULL, 0x000fe400078ee208ULL, 0x00005f0003037a10ULL, 0x000fe400007fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20000ffe4ffULL, 0x00000010080d7824ULL, 0x000fc400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002097faeULL, 0x0003e8000b901c48ULL,
0x00000000060d7faeULL, 0x0003e4000b901c48ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x0000000000067806ULL, 0x000fe200038e0000ULL, 0x00000004ff097424ULL, 0x000fe400078e00ffULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000600027300ULL, 0x000e7000000e0000ULL,
0x0000000600077309ULL, 0x000ea20000000000ULL, 0x000000030200720cULL, 0x002fe20003f02070ULL,
0x0000660004027625ULL, 0x000fc800078e0009ULL, 0x000000ffff077224ULL, 0x004fd000078e0a07ULL,
0x01260407ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01260000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000008021e7981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0b00720cULL, 0x000fe40003f05270ULL, 0x0000007f1e1d7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff1e0a7810ULL, 0x000fc40007ffe0ffULL, 0x00000007ff1d7819ULL, 0x000fe4000001161dULL,
0x00000008ff1c7819ULL, 0x000fca000001160aULL, 0x0000d90000008947ULL, 0x000fea0003800000ULL,
0x00000003ff1b7819ULL, 0x000fe20000011620ULL, 0x00000003ff077424ULL, 0x002fe200078e00ffULL,
0x0001268820067811ULL, 0x000fe200078e18ffULL, 0xffffffffff247424ULL, 0x000fe200078e00ffULL,
0x01ffffff1b1b7812ULL, 0x000fc800078ec0ffULL, 0x0000001d1b00720cULL, 0x000fda0003f06070ULL,
0x0000000204008824ULL, 0x000fe400078e00ffULL, 0x00006800ff038624ULL, 0x000fc800078e00ffULL,
0x0000680000008624ULL, 0x000fc800078e0203ULL, 0x000000011b008824ULL, 0x000fe200078e0200ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040706ff738cULL, 0x0003e20000000000ULL,
0x0000640000028625ULL, 0x000fe200078e0009ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000802248981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0a00780cULL, 0x000fe20003f04070ULL,
0x0000008019197824ULL, 0x000fe200078e00ffULL, 0x00000001ff1a7819ULL, 0x000fe20000011620ULL,
0x0000000006ff7f8cULL, 0x0007e2000c80043fULL, 0x0000000120007812ULL, 0x000fc600078ec0ffULL,
0x000000201a777824ULL, 0x000fca00078e00ffULL, 0x0000006019077812ULL, 0x002fe200078ef877ULL,
0x0000590024087a24ULL, 0x004fc800078e02ffULL, 0x0000008008137824ULL, 0x000fe200078e00ffULL,
0x0000040000000947ULL, 0x000fea0003800000ULL, 0x0000001000037824ULL, 0x008fe200078e00ffULL,
0x000000771e007217ULL, 0x000fe40007800000ULL, 0x00000003ff027819ULL, 0x000fe4000001161fULL,
0x00006200130f7a11ULL, 0x000fe200078838ffULL, 0x0000000100007824ULL, 0x000fe200078e0a77ULL,
0x0000000402097810ULL, 0x040fe20007ffe0ffULL, 0x0000000103067824ULL, 0x000fe200078e0202ULL,
0x0000000c020a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000300007217ULL, 0x000fe20007800000ULL,
0x0000000106087824ULL, 0x040fe200078e021fULL, 0x0000630013137a11ULL, 0x000fe200020f3cffULL,
0x00000008060b7824ULL, 0x000fe400078e00ffULL, 0x0000000100007824ULL, 0x000fe400078e0a03ULL,
0x0000000103107824ULL, 0x000fe200078e020aULL, 0xfffffff80b0c7812ULL, 0x000fe400078ee208ULL,
0x0000000802087810ULL, 0x000fe20007ffe0ffULL, 0x00000001100d7824ULL, 0x000fe200078e021fULL,
0x000000000200720cULL, 0x080fe20003f66070ULL, 0x0000000107027824ULL, 0x000fe200078e0206ULL,
0x000000000800720cULL, 0x080fe20003f26070ULL, 0x0000000103067824ULL, 0x000fe200078e0209ULL,
0x000000000900720cULL, 0x080fe20003f46070ULL, 0x0000000103087824ULL, 0x000fe200078e0208ULL,
0x000000000a00720cULL, 0x000fe20003f06070ULL, 0x0000000106037824ULL, 0x000fc400078e021fULL,
0x00000008060e7824ULL, 0x000fe400078e00ffULL, 0x0000000108097824ULL, 0x040fe400078e021fULL,
0x0000000808127824ULL, 0x000fe200078e00ffULL, 0xfffffff80e007812ULL, 0x000fe200078ee203ULL,
0x0000008002027825ULL, 0x000fc600078e00ffULL, 0xfffffff8120e7812ULL, 0x000fe200078ee209ULL,
0x0000000107067824ULL, 0x040fe200078e0206ULL, 0x0000007002027812ULL, 0x000fe200078ef805ULL,
0x0000000107087824ULL, 0x040fe400078e0208ULL, 0x00000001070a7824ULL, 0x000fe200078e0210ULL,
0x000000020f027210ULL, 0x000fe20007f9e0ffULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000007006067812ULL, 0x000fc600078ef805ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000007008087812ULL, 0x000fc600078ef805ULL,
0x0000000810107824ULL, 0x000fe200078e00ffULL, 0x000000700a0a7812ULL, 0x000fe200078ef805ULL,
0x0000000103037824ULL, 0x000fe200020e0613ULL, 0x0000e0001a057811ULL, 0x000fe400078e68ffULL,
0x0000000f06067210ULL, 0x080fe40007f9e0ffULL, 0x0000000f08087210ULL, 0x080fe20007fbe0ffULL,
0x000000100e117824ULL, 0x000fe200078e0205ULL, 0xfffffff810107812ULL, 0x000fe200078ee20dULL,
0x000000100c0d7824ULL, 0x100fe200078e0205ULL, 0x0000000f0a0a7210ULL, 0x000fe20007fde0ffULL,
0x00000010000f7824ULL, 0x000fc400078e0205ULL, 0x0000000107077824ULL, 0x100fe200020e0613ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000020d7faeULL, 0x0003e2000d901c48ULL,
0x0000000109097824ULL, 0x000fe400028e0613ULL, 0x0000001010057824ULL, 0x000fe200078e0205ULL,
0x00000000060f7faeULL, 0x0003e2000d101c48ULL, 0x000000010b0b7824ULL, 0x000fc600030e0613ULL,
0x0000000008117faeULL, 0x0003e8000c901c48ULL, 0x000000000a057faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001000007824ULL, 0x008fe200078e00ffULL,
0x0000620013117a11ULL, 0x000fe400078038ffULL, 0x0000e0001a157811ULL, 0x000fe400078e68ffULL,
0x000000001f007211ULL, 0x000fc400078fe8ffULL, 0x0000630013137a11ULL, 0x000fe400000f3cffULL,
0x0000000400067810ULL, 0x040fe20007ffe0ffULL, 0x0000000100027824ULL, 0x140fe200078e021fULL,
0x0000000800087810ULL, 0x040fe20007ffe0ffULL, 0x0000000800037824ULL, 0x000fe400078e00ffULL,
0x00000008060a7824ULL, 0x000fe400078e00ffULL, 0x0000000108097824ULL, 0x100fe200078e021fULL,
0xfffffff8030c7812ULL, 0x000fe200078ee202ULL, 0x0000000106037824ULL, 0x000fc400078e021fULL,
0x0000000107027824ULL, 0x000fe200078e0200ULL, 0x0000000c00007810ULL, 0x000fe20007ffe0ffULL,
0x00000008080e7824ULL, 0x000fe200078e00ffULL, 0xfffffff80a0d7812ULL, 0x000fe200078ee203ULL,
0x0000008002027825ULL, 0x000fc600078e00ffULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee209ULL,
0x0000000107067824ULL, 0x040fe200078e0206ULL, 0x0000007002027812ULL, 0x000fe200078ef805ULL,
0x0000000107087824ULL, 0x040fe400078e0208ULL, 0x00000001070a7824ULL, 0x000fe200078e0200ULL,
0x0000000211027210ULL, 0x000fe20007f1e0ffULL, 0x0000008006067825ULL, 0x000fc800078e00ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000007006067812ULL, 0x000fc600078ef805ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000007008087812ULL, 0x000fc600078ef805ULL,
0x00000001000f7824ULL, 0x000fe200078e021fULL, 0x000000700a057812ULL, 0x000fe200078ef805ULL,
0x0000000800007824ULL, 0x000fe200078e00ffULL, 0x0000000811087210ULL, 0x000fe20007f3e0ffULL,
0x0000000103037824ULL, 0x000fe200000e0613ULL, 0x0000000611067210ULL, 0x000fe20007f1e0ffULL,
0x000000100d0d7824ULL, 0x000fe200078e0215ULL, 0xfffffff800007812ULL, 0x000fe200078ee20fULL,
0x000000100e0f7824ULL, 0x100fe200078e0215ULL, 0x00000005110a7210ULL, 0x000fe20007f5e0ffULL,
0x000000100c057824ULL, 0x000fc400078e0215ULL, 0x0000000107077824ULL, 0x100fe400000e0613ULL,
0x0000000109097824ULL, 0x000fe200008e0613ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002057faeULL, 0x0003e2000b901c48ULL, 0x0000001000117824ULL, 0x000fe400078e0215ULL,
0x000000010b0b7824ULL, 0x000fe200010e0613ULL, 0x00000000060d7faeULL, 0x0003e8000b901c48ULL,
0x00000000080f7faeULL, 0x0003e8000b901c48ULL, 0x000000000a117faeULL, 0x0003e4000b901c48ULL,
0x000000001a0473c2ULL, 0x000ea200000e0000ULL, 0x000000ff1c00720cULL, 0x000fe20003f05270ULL,
0x000000ffff217224ULL, 0x000fe200078e00ffULL, 0x000126a81a067811ULL, 0x002fe200078e18ffULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000687805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x000126a804047891ULL, 0x004fe2000f8e203fULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3d7224ULL, 0x000fca00078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff027f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200006067f8cULL, 0x000ea2000c80043fULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000b05000008947ULL, 0x000fea0003800000ULL,
0x000000101a157824ULL, 0x000fe200078e00ffULL, 0x00000002ff177819ULL, 0x000fe20000011620ULL,
0x0000000204187824ULL, 0x000fc400078e00ffULL, 0x00006800ff057624ULL, 0x000fe200078e00ffULL,
0x0000001015157812ULL, 0x000fe200078ee2ffULL, 0x000000ffff007224ULL, 0x002fe400078e0003ULL,
0x000000ffff037224ULL, 0x004fe400078e0007ULL, 0x0000680018187624ULL, 0x000fe400078e0205ULL,
0xff317217ff027424ULL, 0x000fe400078e00ffULL, 0x000000ffff167224ULL, 0x000fc400078e00ffULL,
0x000000ffff6b7224ULL, 0x000fc400078e00ffULL, 0x000000ffff0a7224ULL, 0x01afca00078e00ffULL,
0x0000000000047805ULL, 0x000fc40000015200ULL, 0x0000000420067824ULL, 0x000fca00078e00ffULL,
0xfffffff806087812ULL, 0x000fc800078ec0ffULL, 0x000126c808147810ULL, 0x000fe20007ffe0ffULL,
0x0126cc0008067984ULL, 0x000e640000000800ULL, 0x8000000006ff7812ULL, 0x002fe40007804803ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001f000007945ULL, 0x000fe20003800000ULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604097210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000900780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400900780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000906067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0126cc0008067984ULL, 0x000e640000000800ULL,
0x8000000006ff7812ULL, 0x002fe40007804803ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001020037824ULL, 0x000fe200078e00ffULL,
0x0000000116077810ULL, 0x000fe20007ffe0ffULL, 0x0000590024247a24ULL, 0x000fc600078e02ffULL,
0xffffffe003057812ULL, 0x000fe200078ec0ffULL, 0x0000008024277824ULL, 0x000fe200078e00ffULL,
0x0000001c0700720cULL, 0x000fc60003f46070ULL, 0x0000010016057824ULL, 0x000fca00078e0205ULL,
0x0000004005057810ULL, 0x000fc80007ffe0ffULL, 0x0000006005047812ULL, 0x000fca00078ec0ffULL,
0x00000001190b7824ULL, 0x000fe200078e0204ULL, 0x000004200000a947ULL, 0x000fea0003800000ULL,
0x0000001003047812ULL, 0x000fe200078ec0ffULL, 0x000000101f087824ULL, 0x000fe200078e00ffULL,
0x000000051e037217ULL, 0x000fe40007800000ULL, 0x00000003ff077819ULL, 0x000fe4000001161fULL,
0x0000007008257812ULL, 0x000fe200078ec0ffULL, 0x0000000103037824ULL, 0x000fe200078e0a05ULL,
0x0000000407087810ULL, 0x040fe20007ffe0ffULL, 0x0000000107067824ULL, 0x040fe200078e0204ULL,
0x0000000807097810ULL, 0x000fc40007ffe0ffULL, 0x0000000403037217ULL, 0x000fe20007800000ULL,
0x0000000106057824ULL, 0x040fe200078e021fULL, 0x0000000c070a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000806107824ULL, 0x000fe200078e00ffULL, 0x0000620027237a11ULL, 0x000fe200078c38ffULL,
0x0000000103037824ULL, 0x100fe400078e0a04ULL, 0x000000010a247824ULL, 0x000fe200078e0204ULL,
0xfffffff810107812ULL, 0x000fe200078ee205ULL, 0x000000010b057824ULL, 0x000fe200078e0206ULL,
0x000000030800720cULL, 0x0c0fe20003f86070ULL, 0x0000000108067824ULL, 0x100fe200078e0204ULL,
0x000000030700720cULL, 0x080fe20003fa6070ULL, 0x0000000109087824ULL, 0x040fe200078e0204ULL,
0x000000030a00720cULL, 0x080fe20003f06070ULL, 0x0000000106077824ULL, 0x040fe200078e021fULL,
0x000000030900720cULL, 0x000fe20003f66070ULL, 0x0000000806127824ULL, 0x000fe200078e00ffULL,
0x0000630027277a11ULL, 0x000fe200030f3cffULL, 0x0000008005047825ULL, 0x000fc600078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x000000010b067824ULL, 0x040fe200078e0206ULL,
0x00000025040a7212ULL, 0x000fe200078efcffULL, 0x000000010b097824ULL, 0x000fe400078e0208ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0x0000000a230a7210ULL, 0x000fc60007fde0ffULL,
0x0000000108037824ULL, 0x000fe200078e021fULL, 0x0000002506067212ULL, 0x000fe200078efcffULL,
0x0000000808227824ULL, 0x000fe400078e00ffULL, 0x0000008009087825ULL, 0x000fc600078e00ffULL,
0xfffffff822227812ULL, 0x000fe200078ee203ULL, 0x000000010b047824ULL, 0x000fe200078e0224ULL,
0x0000002508087212ULL, 0x000fe200078efcffULL, 0x00000001050b7824ULL, 0x000fe200030e0627ULL,
0x0000002306067210ULL, 0x000fe20007fde0ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x0000f0001a037811ULL, 0x000fc600078e68ffULL, 0x0000000107077824ULL, 0x000fe200030e0627ULL,
0x0000002308087210ULL, 0x000fe20007fde0ffULL, 0x0000000124137824ULL, 0x000fe200078e021fULL,
0x0000002504047212ULL, 0x000fe200078efcffULL, 0x0000000824247824ULL, 0x000fe400078e00ffULL,
0x0000000109097824ULL, 0x000fe200030e0627ULL, 0x0000002304047210ULL, 0x000fe20007fde0ffULL,
0x0000001012237824ULL, 0x000fe200078e0203ULL, 0xfffffff824247812ULL, 0x000fe200078ee213ULL,
0x0000001010137824ULL, 0x000fc400078e0203ULL, 0x0000001022257824ULL, 0x100fe400078e0203ULL,
0x0000001024037824ULL, 0x000fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a137faeULL, 0x0003e2000e901c48ULL, 0x0000000105057824ULL, 0x000fc600030e0627ULL,
0x0000000006237faeULL, 0x0003e8000e101c48ULL, 0x0000000008257faeULL, 0x0003e8000d901c48ULL,
0x0000000004037faeULL, 0x0003e2000c101c48ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001003047812ULL, 0x000fe200078ec0ffULL, 0x000000101f097824ULL, 0x000fe200078e00ffULL,
0x0000620027257a11ULL, 0x000fc400078038ffULL, 0x000000041f047211ULL, 0x000fe400078fe8ffULL,
0x0000007009237812ULL, 0x000fe400078ec0ffULL, 0x0000000404067810ULL, 0x040fe20007ffe0ffULL,
0x0000000104037824ULL, 0x140fe200078e021fULL, 0x0000000804087810ULL, 0x040fe20007ffe0ffULL,
0x00000008040a7824ULL, 0x000fe200078e00ffULL, 0x0000630027277a11ULL, 0x000fe200000f3cffULL,
0x0000000106057824ULL, 0x000fe200078e021fULL, 0x0000f0001a297811ULL, 0x000fe200078e68ffULL,
0x0000000806107824ULL, 0x000fe200078e00ffULL, 0xfffffff80a037812ULL, 0x000fe200078ee203ULL,
0x0000000108077824ULL, 0x000fe200078e021fULL, 0x0000000c040a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000808127824ULL, 0x000fe200078e00ffULL, 0xfffffff810107812ULL, 0x000fe200078ee205ULL,
0x000000010b057824ULL, 0x000fc400078e0204ULL, 0x000000010b067824ULL, 0x000fe200078e0206ULL,
0xfffffff812127812ULL, 0x000fe200078ee207ULL, 0x0000008005047825ULL, 0x000fc800078e00ffULL,
0x000000010b087824ULL, 0x040fe200078e0208ULL, 0x0000002304047212ULL, 0x000fe200078efcffULL,
0x000000010b0b7824ULL, 0x000fe400078e020aULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000000425047210ULL, 0x000fc60007f1e0ffULL, 0x000000010a137824ULL, 0x000fe200078e021fULL,
0x0000002306067212ULL, 0x000fe200078efcffULL, 0x000000080a227824ULL, 0x000fe400078e00ffULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee213ULL,
0x000000800b0a7825ULL, 0x000fe200078e00ffULL, 0x0000002308087212ULL, 0x000fc600078efcffULL,
0x0000000105057824ULL, 0x000fe200000e0627ULL, 0x000000230a0a7212ULL, 0x000fe200078efcffULL,
0x0000001003037824ULL, 0x100fe200078e0229ULL, 0x0000000625067210ULL, 0x040fe20007f1e0ffULL,
0x0000001010137824ULL, 0x100fe200078e0229ULL, 0x0000000825087210ULL, 0x040fe20007f7e0ffULL,
0x0000001012237824ULL, 0x000fe200078e0229ULL, 0x0000000a250a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000107077824ULL, 0x100fe200000e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004037faeULL, 0x0003e2000b901c48ULL, 0x0000000109097824ULL, 0x000fc400018e0627ULL,
0x0000001022257824ULL, 0x000fe200078e0229ULL, 0x0000000006137faeULL, 0x0003e2000b901c48ULL,
0x000000010b0b7824ULL, 0x000fc600020e0627ULL, 0x0000000008237faeULL, 0x0003e8000b901c48ULL,
0x000000000a257faeULL, 0x0003e4000b901c48ULL, 0x0000000820037824ULL, 0x002fe200078e00ffULL,
0x000000011b047810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff247424ULL, 0x000fc600078e00ffULL,
0xfffffff0030a7812ULL, 0x040fe400078ec0ffULL, 0x0000001d0400720cULL, 0x000fe40003f06070ULL,
0x000000000a0573c2ULL, 0x000e6200000e0000ULL, 0xffffffe003227812ULL, 0x040fe400078ec0ffULL,
0x0000001003077812ULL, 0x040fe400078ec0ffULL, 0x0000000803037812ULL, 0x000fcc00078ec0ffULL,
0x0000000118048824ULL, 0x000fe400078e0204ULL, 0x00000004ff058424ULL, 0x000fe200078e00ffULL,
0x0000002203227210ULL, 0x000fe40007ffe007ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000640004048625ULL, 0x000fca00078e0005ULL, 0x0000000804248981ULL, 0x000522000c1e1900ULL,
0x000126b005057890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a05ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x0126b0000a267f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126080022087f8cULL, 0x000664000c80043fULL, 0x0000000000047805ULL, 0x000fc40000015200ULL,
0x01260c0022037984ULL, 0x000ee40000000800ULL, 0x8000000003ff7812ULL, 0x00afe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0b7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x0000000604067210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011407ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0607ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260c0022037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000101f137824ULL, 0x000fe200078e00ffULL, 0x00000001ff127819ULL, 0x000fe2000001161fULL,
0x0000002020037824ULL, 0x000fe400078e00ffULL, 0xffffffffff807424ULL, 0x000fe200078e00ffULL,
0x0000007013137812ULL, 0x000fc400078ec0ffULL, 0xffffff8003037812ULL, 0x000fe400078ec0ffULL,
0x0000000c12127812ULL, 0x000fc800078ec0ffULL, 0x0000000312037210ULL, 0x000fca0007ffe013ULL,
0x0120000003057984ULL, 0x000e680000000800ULL, 0x0122000003047984ULL, 0x0006a20000000800ULL,
0x000000020500720bULL, 0x002fe20003f1d000ULL, 0x000139b27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000037806ULL, 0x008fc800000e0100ULL, 0x000000ff0300720cULL, 0x000fe20003f05270ULL,
0x0000076000007945ULL, 0x000fe20003800000ULL, 0x00000001ff067424ULL, 0x000fe400078e00ffULL,
0x000000ffff237224ULL, 0x000fc400078e0002ULL, 0x0000001fff847424ULL, 0x000fe400078e00ffULL,
0xffffffffff817424ULL, 0x000fca00078e00ffULL, 0x0000070000008947ULL, 0x000fea0003800000ULL,
0x000000201700720cULL, 0x000fe40003f05270ULL, 0x000000020500720bULL, 0x000fe20003f74000ULL,
0x000139527f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x000fc400018e0100ULL,
0x0000008020078824ULL, 0x000fe200078e0213ULL, 0x0000000205237209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000112108824ULL, 0x000fca00078e0207ULL,
0x0124002310008388ULL, 0x0003e20000000800ULL, 0x000000ff0800720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x0000000223027221ULL, 0x002fe20000010100ULL,
0x000000ff08ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b02027820ULL, 0x000fcc0000410000ULL, 0x0000000200027308ULL, 0x000e640000000800ULL,
0x0000000221217220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x000138927f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x0002e400000e0000ULL, 0x000000292c2c7220ULL, 0x08cfe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0008ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x000fe200078ff0ffULL,
0x000137627f007947ULL, 0x000fea000b800000ULL, 0x00001f2902297589ULL, 0x00066400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000008ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x000fe200078ff0ffULL, 0x000136327f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x0002e400000e0000ULL, 0x000000294c4c7220ULL, 0x08cfe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000008ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x000fe200078ff0ffULL, 0x000135127f007947ULL, 0x000fea000b800000ULL,
0x00001f2902297589ULL, 0x0002e400000e0000ULL, 0x000000294e4e7220ULL, 0x08cfe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000000803ff7212ULL, 0x000fda00078030ffULL, 0x8000002305050221ULL, 0x000fe20000010000ULL,
0x00007610ff060816ULL, 0x000fc60000000006ULL, 0x3fb8aa3b05050820ULL, 0x000fc80000410000ULL,
0x0000000500110308ULL, 0x000e640000000800ULL, 0x0000001104040220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002104217221ULL, 0x004fc20000010000ULL,
0x0000000000027805ULL, 0x008fcc0000015200ULL, 0x0126ac000a057984ULL, 0x000e620000000800ULL,
0x000126a80a107810ULL, 0x000fe40007ffe0ffULL, 0x8000000005ff7812ULL, 0x002fe20007804800ULL,
0x0000000000007918ULL, 0x000fd40000000000ULL, 0x0000020000007945ULL, 0x000fe20003800000ULL,
0x000000ffff087224ULL, 0x000fe200078e00ffULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000100800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x0000000402077210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09000700780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400700780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000000704047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0126ac000a057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804800ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991006007816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0000720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff037819ULL, 0x000fe4000001161fULL,
0x0000541000007816ULL, 0x000fe20000000000ULL, 0x000130d27f007947ULL, 0x000fea000b800000ULL,
0x00001f03000f7589ULL, 0x0002a400000e0000ULL, 0x0000000803297810ULL, 0x000fe20007ffe0ffULL,
0x000131027f007947ULL, 0x000fea000b800000ULL, 0x00000010030d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f29000e7589ULL, 0x00066a00000e0000ULL, 0x00001f0d000d7589ULL, 0x0006a400000e0000ULL,
0x0000001803297810ULL, 0x008fe20007ffe0ffULL, 0x000131527f007947ULL, 0x000fea000b800000ULL,
0x00001f29000c7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000220257824ULL, 0x040fe200078e00ffULL, 0x000000081f027812ULL, 0x000fe200078ec0ffULL,
0x0000000420067824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000024000007945ULL, 0x000fe20003800000ULL, 0x0000000425007812ULL, 0x00afc400078ec0ffULL,
0x00000007020b7812ULL, 0x000fe200078ef81fULL, 0x0000040020027824ULL, 0x000fe200078e00ffULL,
0x000000001f047211ULL, 0x000fe400078fe0ffULL, 0x000000100b097812ULL, 0x040fe200078efcffULL,
0x000000080b037824ULL, 0x040fe200078e00ffULL, 0x0000000406067812ULL, 0x000fe200078ec0ffULL,
0x000000010b0a7824ULL, 0x000fe200078e0204ULL, 0xfffff000027d7812ULL, 0x000fe200078ec0ffULL,
0x0000000104087824ULL, 0x000fe200078e0209ULL, 0x000000061f027211ULL, 0x000fe200078fe0ffULL,
0x0000000809077824ULL, 0x000fe200078e00ffULL, 0xfffffff8030a7812ULL, 0x000fe200078ee20aULL,
0x0000100020037824ULL, 0x000fe200078e00ffULL, 0x0000a0007d7d7810ULL, 0x000fe20007ffe0ffULL,
0x000000080b047824ULL, 0x000fe200078e00ffULL, 0xfffffff807087812ULL, 0x000fc400078ee208ULL,
0xffffe00003057812ULL, 0x000fe200078ec0ffULL, 0x000000010b037824ULL, 0x000fe400078e0202ULL,
0x000000100a6c7824ULL, 0x100fe200078e027dULL, 0x0000e00005057810ULL, 0x000fe20007ffe0ffULL,
0x0000001008287824ULL, 0x000fe200078e027dULL, 0xfffffff804077812ULL, 0x000fc600078ee203ULL,
0x000000006c6c783bULL, 0x000e640000000200ULL, 0x0000001007787824ULL, 0x000fe400078e0205ULL,
0x000000002828783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f6c6c7232ULL, 0x086fe40000000000ULL, 0x0000000f6e6e7232ULL, 0x000fe40000000000ULL,
0x0000000e6d6d7232ULL, 0x080fe40000000000ULL, 0x0000000e6f6f7232ULL, 0x000fc40000000000ULL,
0x0000000d28287232ULL, 0x088fe40000000000ULL, 0x0000000d2a2a7232ULL, 0x000fe40000000000ULL,
0x0000000c29297232ULL, 0x080fe40000000000ULL, 0x0000000c2b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000080b717824ULL, 0x000fe200078e00ffULL,
0x0000000203067810ULL, 0x000fe20007ffe0ffULL, 0x000000007878783bULL, 0x000ee20000004200ULL,
0x0000000200007812ULL, 0x000fe200078efcffULL, 0x000008e000007945ULL, 0x000fe20003800000ULL,
0xfffffff871067812ULL, 0x000fc400078ee206ULL, 0x000000001f007211ULL, 0x000fc600078fe0ffULL,
0x0000001006707824ULL, 0x000fcc00078e0205ULL, 0x000000007070783bULL, 0x000ea20000004200ULL,
0x00000018ff7e7819ULL, 0x008fe4000001147bULL, 0x00000018ff037819ULL, 0x000fe40000011478ULL,
0x00000018ff047819ULL, 0x000fe20000011479ULL, 0x0000007e008b7306ULL, 0x0007e20000200c00ULL,
0x00000018ff057819ULL, 0x000fe4000001147aULL, 0x000088807b8a7816ULL, 0x000fca00000000ffULL,
0x00000003007c7306ULL, 0x0003e20000200c00ULL, 0x00000018ff877819ULL, 0x004fe20000011473ULL,
0x00000100797e7824ULL, 0x008fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe20000011470ULL,
0x00000100708d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011471ULL,
0x00000100718f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000008700977306ULL, 0x0005e20000200c00ULL, 0x0000888078037816ULL, 0x002fe200000000ffULL,
0x0000010072937824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fc4000001148fULL,
0x00000018ff867819ULL, 0x000fe40000011472ULL, 0x0000888071907816ULL, 0x000fe200000000ffULL,
0x0000000400837306ULL, 0x0003e20000200c00ULL, 0x000001007a877824ULL, 0x004fe200078e00ffULL,
0x0000888073957816ULL, 0x000fe200000000ffULL, 0x0001000071717824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe4000001148dULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x0000000500897306ULL, 0x0005e20000200c00ULL, 0x0000010078047824ULL, 0x042fe200078e00ffULL,
0x00000018ff937819ULL, 0x000fe20000011493ULL, 0x0001000078787824ULL, 0x000fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fc40000011471ULL, 0x00000018ff047819ULL, 0x000fe40000011404ULL,
0x0000008700887306ULL, 0x0003e20000200c00ULL, 0x0000888079057816ULL, 0x004fe400000000ffULL,
0x00000018ff787819ULL, 0x000fca0000011478ULL, 0x0000007f008e7306ULL, 0x0005e20000200c00ULL,
0x0000888070877816ULL, 0x042fe200000000ffULL, 0x0001000070707824ULL, 0x000fca00078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011470ULL, 0x0000000500057306ULL, 0x000fe20000200c00ULL,
0x00010000797f7824ULL, 0x004fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000007e007e7306ULL, 0x000e700000200c00ULL, 0x0000007800797306ULL, 0x0005f00000200c00ULL,
0x0000000300037306ULL, 0x000fe20000200c00ULL, 0x000001007b787824ULL, 0x004fe200078e00ffULL,
0x0000541005057816ULL, 0x002fe2000000007eULL, 0x000100007b7b7824ULL, 0x000fc600078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000000400047306ULL, 0x000e620000200c00ULL,
0x00000018ff7b7819ULL, 0x000fce000001147bULL, 0x00000070008f7306ULL, 0x0004f00000200c00ULL,
0x0000008500927306ULL, 0x0007e20000200c00ULL, 0x0000010073707824ULL, 0x004fe200078e00ffULL,
0x0000541003047816ULL, 0x002fe20000000004ULL, 0x0001000073737824ULL, 0x000fc600078e00ffULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000007b008c7306ULL, 0x0003e20000200c00ULL,
0x000088807a857816ULL, 0x048fe200000000ffULL, 0x000100007a7a7824ULL, 0x000fe200078e00ffULL,
0x000054108f8e7816ULL, 0x000fe2000000008eULL, 0x000000046c2c723cULL, 0x000f66000000182cULL,
0x00000018ff7a7819ULL, 0x000fe2000001147aULL, 0x00000070007e7306ULL, 0x0005e20000200c00ULL,
0x00008880727b7816ULL, 0x042fe200000000ffULL, 0x0001000072727824ULL, 0x000fc400078e00ffULL,
0x00000004284c723cULL, 0x000b66000000184cULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x0000008600967306ULL, 0x000fe20000200c00ULL, 0x0000541079707816ULL, 0x004fe4000000007cULL,
0x00000018ff797819ULL, 0x000fe20000011473ULL, 0x000000010b057824ULL, 0x120fe400078e0200ULL,
0x0000000109047824ULL, 0x000fc400078e0200ULL, 0x0000007f00867306ULL, 0x000fe20000200c00ULL,
0x0000000109007824ULL, 0x000fce00078e0202ULL, 0x00000078007f7306ULL, 0x000ff00000200c00ULL,
0x0000008d00787306ULL, 0x000ff00000200c00ULL, 0x0000008500857306ULL, 0x000ff00000200c00ULL,
0x0000008a008a7306ULL, 0x000e700000200c00ULL, 0x0000007a007a7306ULL, 0x000eb00000200c00ULL,
0x0000008700877306ULL, 0x000ee20000200c00ULL, 0x000054108a737816ULL, 0x002fce000000007fULL,
0x0000009000907306ULL, 0x000fe20000200c00ULL, 0x000054107a7a7816ULL, 0x004fce0000000089ULL,
0x0000009100917306ULL, 0x000fe20000200c00ULL, 0x0000541087787816ULL, 0x008fce0000000078ULL,
0x00000071008d7306ULL, 0x0002b00000200c00ULL, 0x0000007b00947306ULL, 0x0007e20000200c00ULL,
0x0000541086717816ULL, 0x002fce0000000083ULL, 0x0000009300937306ULL, 0x000e620000200c00ULL,
0x000054108c7b7816ULL, 0x008fe2000000008bULL, 0x000000706c30723cULL, 0x000f620000001830ULL,
0x000054108d8f7816ULL, 0x004fca0000000092ULL, 0x0000009500957306ULL, 0x000ea40000200c00ULL,
0x0000007a6c38723cULL, 0x040f6c0000001838ULL, 0x0000007200037306ULL, 0x0006a20000200c00ULL,
0x0000541094947816ULL, 0x002fe20000000093ULL, 0x0000008e6c40723cULL, 0x000f6c0000001840ULL,
0x00000079007c7306ULL, 0x0002620000200c00ULL, 0x0000541085727816ULL, 0x008fe20000000088ULL,
0x000000702850723cULL, 0x000f620000001850ULL, 0x0000541095957816ULL, 0x004fc4000000007eULL,
0x0000541003967816ULL, 0x000fe20000000096ULL, 0x0000000809037824ULL, 0x000fe200078e00ffULL,
0x0000541090797816ULL, 0x002fc60000000091ULL, 0x000000726c34723cULL, 0x000f620000001834ULL,
0xfffffff803047812ULL, 0x000fe400078ee204ULL, 0x000054107c977816ULL, 0x000fe40000000097ULL,
0x0000e0001a037811ULL, 0x000fc600078e68ffULL, 0x000000786c3c723cULL, 0x040f70000000183cULL,
0x000000946c44723cULL, 0x040f700000001844ULL, 0x000000966c48723cULL, 0x000b6e0000001848ULL,
0x000000080b6c7824ULL, 0x020fe200078e00ffULL, 0x000000722854723cULL, 0x000f620000001854ULL,
0x00000008096d7824ULL, 0x000fc600078e00ffULL, 0xfffffff86c057812ULL, 0x000fe400078ee205ULL,
0xfffffff86d027812ULL, 0x000fe400078ee200ULL, 0x0000007a2858723cULL, 0x000f620000001858ULL,
0x00000010056c7824ULL, 0x100fe400078e027dULL, 0x00000010047d7824ULL, 0x000fc800078e027dULL,
0x000000006c6c783bULL, 0x000e620000000200ULL, 0x00000078285c723cULL, 0x040b6e000000185cULL,
0x0000001002787824ULL, 0x020fe200078e0203ULL, 0x0000008e2860723cULL, 0x040f700000001860ULL,
0x000000942864723cULL, 0x040f700000001864ULL, 0x000000962868723cULL, 0x000b640000001868ULL,
0x000000007d28783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000f6c6c7232ULL, 0x082fe40000000000ULL,
0x0000000f6e6e7232ULL, 0x000fc40000000000ULL, 0x0000000e6d6d7232ULL, 0x080fe40000000000ULL,
0x0000000e6f6f7232ULL, 0x000fe40000000000ULL, 0x0000000d28287232ULL, 0x088fe40000000000ULL,
0x0000000d2a2a7232ULL, 0x000fe40000000000ULL, 0x0000000c29297232ULL, 0x080fe40000000000ULL,
0x0000000c2b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000809717824ULL, 0x000fe200078e00ffULL, 0x0000000200007810ULL, 0x000fe20007ffe0ffULL,
0x000000007878783bULL, 0x000ea20000004200ULL, 0xfffffff825257812ULL, 0x000fc400078ec0ffULL,
0xfffffff871007812ULL, 0x000fca00078ee200ULL, 0x0000001000707824ULL, 0x000fcc00078e0203ULL,
0x000000007070783bULL, 0x000ee20000004200ULL, 0x00000018ff7c7819ULL, 0x004fe20000011478ULL,
0x000001007a8a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe40000011479ULL,
0x0000007c007e7306ULL, 0x0005e20000200c00ULL, 0x00000018ff837819ULL, 0x000fe4000001147bULL,
0x00000018ff7f7819ULL, 0x000fe4000001147aULL, 0x00000018ff8a7819ULL, 0x000fc6000001148aULL,
0x0000007d00877306ULL, 0x0003e20000200c00ULL, 0x00008880787c7816ULL, 0x004fe200000000ffULL,
0x00000100708f7824ULL, 0x008fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011470ULL,
0x0000010071917824ULL, 0x000fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe20000011471ULL,
0x00000100739a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe20000011472ULL,
0x00000083008d7306ULL, 0x0005e20000200c00ULL, 0x00000100787d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011473ULL, 0x0001000078787824ULL, 0x000fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fc4000001148fULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000010079837824ULL, 0x004fe200078e00ffULL,
0x0000007f008b7306ULL, 0x0003e20000200c00ULL, 0x0000888073997816ULL, 0x040fe200000000ffULL,
0x0001000073737824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fe40000011491ULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x00000018ff9a7819ULL, 0x000fe2000001149aULL,
0x0000008500927306ULL, 0x0005e20000200c00ULL, 0x00008880797f7816ULL, 0x002fce00000000ffULL,
0x0000008600957306ULL, 0x000fe20000200c00ULL, 0x0001000079857824ULL, 0x004fca00078e00ffULL,
0x00000018ff857819ULL, 0x000fe40000011485ULL, 0x0000007800797306ULL, 0x0003f00000200c00ULL,
0x0000008300867306ULL, 0x0005e20000200c00ULL, 0x000001007b787824ULL, 0x002fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000007c007c7306ULL, 0x000fe20000200c00ULL,
0x000088807b837816ULL, 0x044fe200000000ffULL, 0x000100007b7b7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000007d007d7306ULL, 0x000e700000200c00ULL,
0x00000078008c7306ULL, 0x0005f00000200c00ULL, 0x0000008800977306ULL, 0x000fe20000200c00ULL,
0x0000888071787816ULL, 0x044fe200000000ffULL, 0x0001000071717824ULL, 0x000fca00078e00ffULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x00000089009b7306ULL, 0x0005f00000200c00ULL,
0x0000008500887306ULL, 0x0007e20000200c00ULL, 0x000088807a897816ULL, 0x044fe200000000ffULL,
0x000100007a7a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000007800947306ULL, 0x0005e20000200c00ULL, 0x0000888070857816ULL, 0x048fe200000000ffULL,
0x0001000070707824ULL, 0x000fca00078e00ffULL, 0x00000018ff707819ULL, 0x000fe20000011470ULL,
0x0000007b008e7306ULL, 0x0007e20000200c00ULL, 0x0000010072787824ULL, 0x004fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x0000008f00907306ULL, 0x000fe20000200c00ULL,
0x00008880727b7816ULL, 0x048fe200000000ffULL, 0x0001000072727824ULL, 0x000fca00078e00ffULL,
0x00000018ff727819ULL, 0x000fe20000011472ULL, 0x0000007b008f7306ULL, 0x0005f00000200c00ULL,
0x0000007000937306ULL, 0x0002e20000200c00ULL, 0x00000018ff7b7819ULL, 0x004fce0000011473ULL,
0x0000007800987306ULL, 0x0004e20000200c00ULL, 0x000054107c707816ULL, 0x002fce000000007dULL,
0x0000007f007f7306ULL, 0x000fe20000200c00ULL, 0x0000541079787816ULL, 0x004fe4000000007eULL,
0x0000541093927816ULL, 0x008fe40000000092ULL, 0x0000541088797816ULL, 0x000fc60000000087ULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x000054108f987816ULL, 0x000fc60000000098ULL,
0x000000782850723cULL, 0x080f680000001850ULL, 0x0000008a008a7306ULL, 0x000fe80000200c00ULL,
0x000000786c30723cULL, 0x000f680000001830ULL, 0x0000008300837306ULL, 0x000e700000200c00ULL,
0x0000007a007a7306ULL, 0x000eb00000200c00ULL, 0x0000008500857306ULL, 0x000ee20000200c00ULL,
0x0000541083737816ULL, 0x002fce000000008cULL, 0x0000009100917306ULL, 0x000e620000200c00ULL,
0x000054107a7a7816ULL, 0x004fce000000008bULL, 0x0000007100967306ULL, 0x0004620000200c00ULL,
0x0000541085907816ULL, 0x008fce0000000090ULL, 0x0000009900997306ULL, 0x000fe20000200c00ULL,
0x000054107f717816ULL, 0x004fe40000000086ULL, 0x0000541094917816ULL, 0x002fca0000000091ULL,
0x0000009a009a7306ULL, 0x000e620000200c00ULL, 0x0000541096937816ULL, 0x000fe20000000095ULL,
0x00000070284c723cULL, 0x040f6c000000184cULL, 0x00000072007c7306ULL, 0x0004e40000200c00ULL,
0x00000090285c723cULL, 0x040f6c000000185cULL, 0x0000007b007e7306ULL, 0x0006e20000200c00ULL,
0x0000541089727816ULL, 0x004fe2000000008aULL, 0x000000922860723cULL, 0x000f620000001860ULL,
0x0000541099997816ULL, 0x002fc4000000009aULL, 0x000054107c7c7816ULL, 0x008fe40000000097ULL,
0x000054108e7b7816ULL, 0x000fc6000000008dULL, 0x000000722854723cULL, 0x000f620000001854ULL,
0x000054107e7d7816ULL, 0x000fce000000009bULL, 0x0000007a2858723cULL, 0x040f700000001858ULL,
0x000000982864723cULL, 0x040f700000001864ULL, 0x0000007c2868723cULL, 0x000f700000001868ULL,
0x000000706c2c723cULL, 0x040f70000000182cULL, 0x000000726c34723cULL, 0x040f700000001834ULL,
0x0000007a6c38723cULL, 0x040f700000001838ULL, 0x000000906c3c723cULL, 0x040f70000000183cULL,
0x000000926c40723cULL, 0x040f700000001840ULL, 0x000000986c44723cULL, 0x040f700000001844ULL,
0x0000007c6c48723cULL, 0x000b6e0000001848ULL, 0x000126c81a6c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006c6c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0126880025ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff6e7224ULL, 0x000fc600078e00ffULL, 0x0000000000287805ULL, 0x000fc80000015200ULL,
0x0000040014257984ULL, 0x004ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc4000780486dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000106e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000016e6e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040014257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001020257824ULL, 0x000fe400078e00ffULL,
0x0000590024247a24ULL, 0x010fc600078e02ffULL, 0xffffffe025297812ULL, 0x000fe200078ec0ffULL,
0x0000008024247824ULL, 0x000fc800078e00ffULL, 0x0000010016297824ULL, 0x000fca00078e0229ULL,
0x0000008029297810ULL, 0x000fc80007ffe0ffULL, 0x0000006029287812ULL, 0x000fca00078ec0ffULL,
0x0000000119707824ULL, 0x000fe200078e0228ULL, 0x000003f00000a947ULL, 0x000fea0003800000ULL,
0x0000001025727812ULL, 0x000fe400078ec0ffULL, 0x000000291e257217ULL, 0x000fe40007800000ULL,
0x00000003ff2b7819ULL, 0x000fe4000001161fULL, 0x0000620024717a11ULL, 0x000fe200078838ffULL,
0x0000000125257824ULL, 0x000fe200078e0a29ULL, 0x000000042b2a7810ULL, 0x040fe20007ffe0ffULL,
0x000000012b287824ULL, 0x040fe200078e0272ULL, 0x000000082b6f7810ULL, 0x000fc40007ffe0ffULL,
0x0000002572257217ULL, 0x000fe20007800000ULL, 0x0000000128297824ULL, 0x040fe200078e021fULL,
0x0000000c2b7b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000828787824ULL, 0x000fe200078e00ffULL,
0x0000630024737a11ULL, 0x000fe200020f3cffULL, 0x0000000125257824ULL, 0x100fe400078e0a72ULL,
0x000000012a797824ULL, 0x000fe200078e0272ULL, 0xfffffff878787812ULL, 0x000fe200078ee229ULL,
0x0000000128287824ULL, 0x100fe200078e0270ULL, 0x000000252a00720cULL, 0x080fe20003f66070ULL,
0x00000001792a7824ULL, 0x000fe200078e0270ULL, 0x000000252b00720cULL, 0x080fe20003f06070ULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x000000256f00720cULL, 0x000fc60003f86070ULL,
0x000000016f7a7824ULL, 0x000fe200078e0272ULL, 0x00000013286e7212ULL, 0x000fe200078efcffULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0x0000006e716e7210ULL, 0x000fe20007fbe0ffULL,
0x000000017a6c7824ULL, 0x000fe200078e0270ULL, 0x000000132a2a7212ULL, 0x000fe200078efcffULL,
0x000000017b727824ULL, 0x000fe400078e0272ULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x000000712a2a7210ULL, 0x000fc60007fde0ffULL, 0x0000000172287824ULL, 0x000fe200078e0270ULL,
0x000000136c6c7212ULL, 0x000fe200078efcffULL, 0x00000001296f7824ULL, 0x000fe200028e0673ULL,
0x000000257b00720cULL, 0x000fe20003fa6070ULL, 0x0000000179707824ULL, 0x040fe400078e021fULL,
0x0000000879797824ULL, 0x000fe400078e00ffULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0xfffffff879707812ULL, 0x000fe200078ee270ULL, 0x000000012b2b7824ULL, 0x000fe200030e0673ULL,
0x000000716c6c7210ULL, 0x000fe20007fde0ffULL, 0x000000017a257824ULL, 0x100fe200078e021fULL,
0x0000001328287212ULL, 0x000fe200078efcffULL, 0x000000087a7a7824ULL, 0x000fe400078e00ffULL,
0x0000000172797824ULL, 0x040fe400078e021fULL, 0x00000008727c7824ULL, 0x000fe200078e00ffULL,
0xfffffff87a727812ULL, 0x000fe200078ee225ULL, 0x000000016d6d7824ULL, 0x000fe200030e0673ULL,
0x0000007128287210ULL, 0x000fe20007fde0ffULL, 0x0000001078257824ULL, 0x000fe200078e0203ULL,
0xfffffff87c787812ULL, 0x000fe200078ee279ULL, 0x0000001070717824ULL, 0x000fc400078e0203ULL,
0x0000000129297824ULL, 0x000fe200030e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e257faeULL, 0x0003e2000c101c48ULL, 0x0000001072737824ULL, 0x100fe400078e0203ULL,
0x0000001078797824ULL, 0x000fe200078e0203ULL, 0x000000002a717faeULL, 0x0003e8000d901c48ULL,
0x000000006c737faeULL, 0x0003e8000e101c48ULL, 0x0000000028797faeULL, 0x0003e2000e901c48ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001025287812ULL, 0x000fc800078ec0ffULL,
0x000000281f257211ULL, 0x000fc800078fe8ffULL, 0x00000004252b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000125297824ULL, 0x040fe200078e021fULL, 0x0000000c256d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000825727824ULL, 0x040fe400078e00ffULL, 0x0000000125287824ULL, 0x100fe400078e0270ULL,
0x000000012b2a7824ULL, 0x040fe200078e0270ULL, 0xfffffff872727812ULL, 0x000fe200078ee229ULL,
0x000000082b787824ULL, 0x000fe200078e00ffULL, 0x0000000825297810ULL, 0x000fe20007ffe0ffULL,
0x000000012b257824ULL, 0x000fc400078e021fULL, 0x000000016d6f7824ULL, 0x100fe400078e021fULL,
0x00000001296c7824ULL, 0x040fe400078e0270ULL, 0x00000001292b7824ULL, 0x040fe400078e021fULL,
0x00000008297a7824ULL, 0x000fe400078e00ffULL, 0x000000086d7c7824ULL, 0x000fe400078e00ffULL,
0x0000008028287825ULL, 0x000fc800078e00ffULL, 0x000000016d6e7824ULL, 0x000fe200078e0270ULL,
0xfffffff878707812ULL, 0x000fe200078ee225ULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0xfffffff87a787812ULL, 0x000fe400078ee22bULL, 0x0000620024257a11ULL, 0x000fe200078038ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0xfffffff87c7a7812ULL, 0x000fe400078ee26fULL,
0x0000001328287212ULL, 0x000fe200078efcffULL, 0x000000806e6e7825ULL, 0x000fe200078e00ffULL,
0x0000630024717a11ULL, 0x000fc400000f3cffULL, 0x0000002825287210ULL, 0x000fe20007f1e0ffULL,
0x0000001078737824ULL, 0x100fe200078e0203ULL, 0x000000132a2a7212ULL, 0x080fe200078efcffULL,
0x000000107a797824ULL, 0x000fe200078e0203ULL, 0x000000136c6c7212ULL, 0x080fe200078efcffULL,
0x0000000129297824ULL, 0x000fe200000e0671ULL, 0x000000136e6e7212ULL, 0x000fe400078efcffULL,
0x0000002a252a7210ULL, 0x040fe40007f7e0ffULL, 0x0000006c256c7210ULL, 0x000fc40007f1e0ffULL,
0x0000006e256e7210ULL, 0x000fe20007f9e0ffULL, 0x000000012b2b7824ULL, 0x000fe400018e0671ULL,
0x0000001072257824ULL, 0x000fe400078e0203ULL, 0x000000016d6d7824ULL, 0x100fe400000e0671ULL,
0x000000016f6f7824ULL, 0x000fe200020e0671ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028257faeULL, 0x0003e2000b901c48ULL, 0x0000001070717824ULL, 0x000fca00078e0203ULL,
0x000000002a717faeULL, 0x0003e8000b901c48ULL, 0x000000006c737faeULL, 0x0003e8000b901c48ULL,
0x000000006e797faeULL, 0x0003e4000b901c48ULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x000000a000007945ULL, 0x000fe20003800000ULL, 0x000000000000781cULL, 0x000fda0003f0f070ULL,
0x00000000100503c2ULL, 0x000e640000020000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0099b0ULL, 0x002fe20008000a05ULL,
0x000000000000081cULL, 0x000fe20000f0f070ULL, 0xffffff8000001947ULL, 0x000fd8000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000106c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01262800226e7f8cULL, 0x000664000c80043fULL,
0x0000000000287805ULL, 0x000fc40000015200ULL, 0x01262c0022257984ULL, 0x000f240000000800ULL,
0x8000000025ff7812ULL, 0x012fc4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01262c0022257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002020257824ULL, 0x000fca00078e00ffULL,
0xffffff8025287812ULL, 0x000fc800078ec0ffULL, 0x0000008013257810ULL, 0x000fca0007ffe028ULL,
0x0000000112257824ULL, 0x000fca00078e0225ULL, 0x01200000256e7984ULL, 0x000e680000000800ULL,
0x0122000025707984ULL, 0x0006a20000000800ULL, 0x000000236e00720bULL, 0x002fe20003f1d000ULL,
0x00010fb27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000257806ULL, 0x008fc800000e0100ULL,
0x000000ff2500720cULL, 0x000fe20003f05270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6f7424ULL, 0x000fd600078e00ffULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x0000000117297810ULL, 0x000fe40007ffe0ffULL, 0x000000236e00720bULL, 0x000fe40003f74000ULL,
0x000000202900720cULL, 0x000fe20003f05270ULL, 0x00010f727f007947ULL, 0x000fd4000b800000ULL,
0x0000000000727806ULL, 0x000fc400018e0100ULL, 0x0000008020298824ULL, 0x000fe200078e0213ULL,
0x000000236e288209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000112298824ULL, 0x000fca00078e0229ULL, 0x0124002829008388ULL, 0x0003e20000000800ULL,
0x000000ff7200720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x000000236e287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff72ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002328287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x0000002800787308ULL, 0x000e640000000800ULL,
0x0000007821217220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x00010ea27f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x0002e400000e0000ULL, 0x000000292c2c7220ULL, 0x08cfe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0072ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x000fe200078ff0ffULL,
0x00010d727f007947ULL, 0x000fea000b800000ULL, 0x00001f2978297589ULL, 0x00066400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000072ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x000fe200078ff0ffULL, 0x00010c427f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x0002e400000e0000ULL, 0x000000294c4c7220ULL, 0x08cfe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000072ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x000fe200078ff0ffULL, 0x00010b227f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x0002e400000e0000ULL, 0x000000294e4e7220ULL, 0x08cfe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000007225ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff6f7424ULL, 0x000fe200078e00ffULL,
0x000000236e237209ULL, 0x000fd60007810000ULL, 0x800000236e6e0221ULL, 0x000fe20000010000ULL,
0x00007610ff6f0816ULL, 0x000fc6000000006fULL, 0x3fb8aa3b6e6e0820ULL, 0x000fc80000410000ULL,
0x0000006e00110308ULL, 0x000e640000000800ULL, 0x0000001170700220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002170217221ULL, 0x004fc20000010000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000000820257824ULL, 0x000fca00078e00ffULL,
0xfffffff0256e7812ULL, 0x000fca00078ec0ffULL, 0x0126b4006e257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804827ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0126b4006e257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804827ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099106f257816ULL, 0x000fc800000000ffULL,
0x000000ff2500720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff0c723eULL, 0x000fe400000000ffULL, 0x00000002ff257819ULL, 0x000fe4000001161fULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x000106e27f007947ULL, 0x000fea000b800000ULL,
0x00001f250c0f7589ULL, 0x0002a400000e0000ULL, 0x0000000825297810ULL, 0x000fe20007ffe0ffULL,
0x000107127f007947ULL, 0x000fea000b800000ULL, 0x00000010250d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f290c0e7589ULL, 0x0002ea00000e0000ULL, 0x00001f0d0c0d7589ULL, 0x0002a400000e0000ULL,
0x0000001825297810ULL, 0x002fe20007ffe0ffULL, 0x000107627f007947ULL, 0x000fea000b800000ULL,
0x00001f290c0c7589ULL, 0x0002e400000e0000ULL, 0x0000040020257824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100020267824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00025257812ULL, 0x000fc400078ec0ffULL,
0xffffe00026267812ULL, 0x000fe400078ec0ffULL, 0x0000b00025277810ULL, 0x000fe40007ffe0ffULL,
0x0000f00026257810ULL, 0x000fc60007ffe0ffULL, 0x000000100a707824ULL, 0x100fe400078e0227ULL,
0x0000001008287824ULL, 0x000fe400078e0227ULL, 0x00000010077c7824ULL, 0x000fe400078e0225ULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000002828783bULL, 0x002e620000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f70707232ULL, 0x084fe40000000000ULL,
0x0000000f72727232ULL, 0x000fc40000000000ULL, 0x0000000e71717232ULL, 0x088fe40000000000ULL,
0x0000000e73737232ULL, 0x000fe40000000000ULL, 0x0000000d28287232ULL, 0x082fe40000000000ULL,
0x0000000d2a2a7232ULL, 0x000fe40000000000ULL, 0x0000000c29297232ULL, 0x080fe40000000000ULL,
0x0000000c2b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001006787824ULL, 0x008fe200078e0225ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x0000082000007945ULL, 0x000fe80003800000ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x00000018ff6e7819ULL, 0x008fe2000001147eULL, 0x000001007f8c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fc4000001147fULL, 0x0000006e008b7306ULL, 0x0007e20000200c00ULL,
0x00000018ff857819ULL, 0x010fe20000011478ULL, 0x0000010079927824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe4000001147dULL, 0x00000018ff257819ULL, 0x000fe4000001147cULL,
0x00000018ff867819ULL, 0x000fe20000011479ULL, 0x0000006f008e7306ULL, 0x0009e20000200c00ULL,
0x000088807d6e7816ULL, 0x008fe400000000ffULL, 0x00000018ff887819ULL, 0x000fc4000001147aULL,
0x00000018ff937819ULL, 0x000fe40000011492ULL, 0x00000018ff897819ULL, 0x000fe2000001147bULL,
0x00000085008f7306ULL, 0x000fe20000200c00ULL, 0x000001007d6f7824ULL, 0x010fe200078e00ffULL,
0x0000888079917816ULL, 0x000fe200000000ffULL, 0x000100007d7d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001148cULL, 0x0001000079797824ULL, 0x000fe200078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000006e00857306ULL, 0x0007e20000200c00ULL,
0x00000018ff7d7819ULL, 0x000fc4000001147dULL, 0x00000018ff797819ULL, 0x000fca0000011479ULL,
0x0000002600877306ULL, 0x0009e20000200c00ULL, 0x000001007e6e7824ULL, 0x008fca00078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe4000001146eULL, 0x0000002500837306ULL, 0x0007e20000200c00ULL,
0x000001007c267824ULL, 0x010fca00078e00ffULL, 0x00000018ff267819ULL, 0x000fe40000011426ULL,
0x0000008600957306ULL, 0x000fe20000200c00ULL, 0x000088807c257816ULL, 0x048fe200000000ffULL,
0x000100007c7c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000006f00867306ULL, 0x0007f00000200c00ULL, 0x0000006e008a7306ULL, 0x0009e20000200c00ULL,
0x000088807f6f7816ULL, 0x048fe200000000ffULL, 0x000100007f7f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000006f008d7306ULL, 0x0007e20000200c00ULL,
0x00008880786e7816ULL, 0x010fce00000000ffULL, 0x0000002500257306ULL, 0x000fe20000200c00ULL,
0x00000100786f7824ULL, 0x048fe400078e00ffULL, 0x0001000078787824ULL, 0x000fc600078e00ffULL,
0x00000018ff6f7819ULL, 0x000fe4000001146fULL, 0x0000002600267306ULL, 0x000fe20000200c00ULL,
0x00000018ff787819ULL, 0x000fce0000011478ULL, 0x0000007c007c7306ULL, 0x000ff00000200c00ULL,
0x0000007800927306ULL, 0x0007300000200c00ULL, 0x00000088009a7306ULL, 0x000fe20000200c00ULL,
0x000001007b787824ULL, 0x008fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000007d00887306ULL, 0x000fe20000200c00ULL, 0x0000541092927816ULL, 0x010fce000000008fULL,
0x0000006e007d7306ULL, 0x0007f00000200c00ULL, 0x00000089009b7306ULL, 0x0009e20000200c00ULL,
0x000088807a6e7816ULL, 0x008fce00000000ffULL, 0x0000009300947306ULL, 0x0007e20000200c00ULL,
0x000088807e897816ULL, 0x050fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000006f00907306ULL, 0x0008a20000200c00ULL,
0x000088807b937816ULL, 0x048fe200000000ffULL, 0x000100007b7b7824ULL, 0x000fcc00078e00ffULL,
0x0000006e00977306ULL, 0x0007e20000200c00ULL, 0x000001007a6f7824ULL, 0x050fe400078e00ffULL,
0x000100007a7a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x00000018ff7a7819ULL, 0x000fe2000001147aULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x00005410256e7816ULL, 0x008fe40000000026ULL, 0x000054107d907816ULL, 0x004fca0000000090ULL,
0x0000007800267306ULL, 0x0005f00000200c00ULL, 0x0000008c008c7306ULL, 0x000ee20000200c00ULL,
0x000054107c787816ULL, 0x004fe40000000083ULL, 0x00000018ff7c7819ULL, 0x000fca000001147bULL,
0x0000007e007e7306ULL, 0x000eb00000200c00ULL, 0x0000007f007f7306ULL, 0x000f220000200c00ULL,
0x000054108d7b7816ULL, 0x008fce000000008cULL, 0x0000009100917306ULL, 0x000ee20000200c00ULL,
0x000054107e7e7816ULL, 0x004fce000000008bULL, 0x0000007900967306ULL, 0x0004620000200c00ULL,
0x000054107f7f7816ULL, 0x010fce000000008eULL, 0x0000006f00987306ULL, 0x0008620000200c00ULL,
0x0000541088797816ULL, 0x004fe20000000087ULL, 0x0000007e7038723cULL, 0x000f620000001838ULL,
0x0000541091917816ULL, 0x008fca0000000094ULL, 0x0000009300997306ULL, 0x0002a20000200c00ULL,
0x00005410856f7816ULL, 0x010fe20000000086ULL, 0x000000787030723cULL, 0x040f6c0000001830ULL,
0x0000007a00257306ULL, 0x0007220000200c00ULL, 0x0000541096937816ULL, 0x002fe20000000095ULL,
0x0000006e702c723cULL, 0x000f62000000182cULL, 0x0000541097987816ULL, 0x000fca0000000098ULL,
0x0000007c007c7306ULL, 0x000e620000200c00ULL, 0x00005410897a7816ULL, 0x008fe2000000008aULL,
0x00000090703c723cULL, 0x000f62000000183cULL, 0x0000541099997816ULL, 0x004fe40000000026ULL,
0x00005410259a7816ULL, 0x010fca000000009aULL, 0x0000007a7034723cULL, 0x000f620000001834ULL,
0x0000100003257810ULL, 0x000fe40007ffe0ffULL, 0x000054107c9b7816ULL, 0x002fc6000000009bULL,
0x0000001002267824ULL, 0x000fe400078e0225ULL, 0x000000927040723cULL, 0x040f700000001840ULL,
0x000000987044723cULL, 0x040f700000001844ULL, 0x0000009a7048723cULL, 0x000b6e0000001848ULL,
0x0000001005707824ULL, 0x120fe200078e0227ULL, 0x0000006e284c723cULL, 0x000f62000000184cULL,
0x0000001004277824ULL, 0x000fc800078e0227ULL, 0x000000007070783bULL, 0x000e660000000200ULL,
0x000000782850723cULL, 0x040f700000001850ULL, 0x0000007a2854723cULL, 0x040f700000001854ULL,
0x0000007e2858723cULL, 0x040f700000001858ULL, 0x00000090285c723cULL, 0x040f70000000185cULL,
0x000000922860723cULL, 0x040f700000001860ULL, 0x000000982864723cULL, 0x040f700000001864ULL,
0x0000009a2868723cULL, 0x000b640000001868ULL, 0x000000002728783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000f70707232ULL, 0x082fe40000000000ULL, 0x0000000f72727232ULL, 0x000fc40000000000ULL,
0x0000000e71717232ULL, 0x080fe40000000000ULL, 0x0000000e73737232ULL, 0x000fe40000000000ULL,
0x0000000d28287232ULL, 0x088fe40000000000ULL, 0x0000000d2a2a7232ULL, 0x000fe40000000000ULL,
0x0000000c29297232ULL, 0x080fe40000000000ULL, 0x0000000c2b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x002fea0003800000ULL, 0x00000000267c783bULL, 0x000e620000004200ULL,
0x0000001000787824ULL, 0x000fcc00078e0225ULL, 0x000000007878783bULL, 0x000f220000004200ULL,
0x00000018ff6f7819ULL, 0x002fe2000001147eULL, 0x000001007f8c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe4000001147fULL, 0x00000018ff277819ULL, 0x004fe2000001147cULL,
0x0000006f008b7306ULL, 0x0003e20000200c00ULL, 0x00000018ff6e7819ULL, 0x000fe2000001147dULL,
0x00000100788f7824ULL, 0x010fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe20000011479ULL,
0x0000010079937824ULL, 0x000fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fc40000011478ULL,
0x00000018ff897819ULL, 0x000fe2000001147aULL, 0x00000085008d7306ULL, 0x0005e20000200c00ULL,
0x000088807d6f7816ULL, 0x042fe400000000ffULL, 0x00000018ff947819ULL, 0x000fe40000011493ULL,
0x00000018ff8a7819ULL, 0x000fe4000001147bULL, 0x00000018ff8f7819ULL, 0x000fe2000001148fULL,
0x0000002700837306ULL, 0x0003e20000200c00ULL, 0x000001007d857824ULL, 0x004fe200078e00ffULL,
0x000088807b997816ULL, 0x000fe200000000ffULL, 0x000100007d7d7824ULL, 0x000fe200078e00ffULL,
0x0000888079917816ULL, 0x040fe200000000ffULL, 0x0001000079797824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fc40000011485ULL, 0x0000006e00877306ULL, 0x0005e20000200c00ULL,
0x000088807c277816ULL, 0x042fe400000000ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147dULL,
0x00000018ff8c7819ULL, 0x000fe4000001148cULL, 0x00000018ff797819ULL, 0x000fe20000011479ULL,
0x0000008800957306ULL, 0x000fe20000200c00ULL, 0x000001007c6e7824ULL, 0x044fe400078e00ffULL,
0x000100007c7c7824ULL, 0x000fc600078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000007d00887306ULL, 0x0003f00000200c00ULL,
0x0000008600927306ULL, 0x000fe20000200c00ULL, 0x00008880787d7816ULL, 0x042fe200000000ffULL,
0x0001000078787824ULL, 0x000fca00078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x0000006f006f7306ULL, 0x000ff00000200c00ULL, 0x0000008500867306ULL, 0x0002b00000200c00ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x000088807f857816ULL, 0x042fe200000000ffULL,
0x000100007f7f7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0000007800937306ULL, 0x0003220000200c00ULL, 0x000054106f6f7816ULL, 0x004fce0000000086ULL,
0x0000002700277306ULL, 0x000fe20000200c00ULL, 0x000001007b787824ULL, 0x042fe400078e00ffULL,
0x000100007b7b7824ULL, 0x000fc600078e00ffULL, 0x00000018ff787819ULL, 0x000fe40000011478ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x0000541093927816ULL, 0x010fce0000000092ULL,
0x00000089009a7306ULL, 0x0005f00000200c00ULL, 0x0000008a009b7306ULL, 0x0009e20000200c00ULL,
0x000088807e897816ULL, 0x004fe400000000ffULL, 0x00005410276e7816ULL, 0x002fca000000006eULL,
0x0000007f008e7306ULL, 0x0003e20000200c00ULL, 0x000001007e8a7824ULL, 0x050fe200078e00ffULL,
0x0000006e702c723cULL, 0x000f62000000182cULL, 0x000100007e7e7824ULL, 0x000fc600078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe4000001148aULL, 0x0000008f00907306ULL, 0x0005e20000200c00ULL,
0x000088807a7f7816ULL, 0x002fe200000000ffULL, 0x0000006e284c723cULL, 0x008b62000000184cULL,
0x00000018ff7e7819ULL, 0x000fca000001147eULL, 0x0000007800867306ULL, 0x0003e20000200c00ULL,
0x000001007a8f7824ULL, 0x004fe200078e00ffULL, 0x000126c81a6e7811ULL, 0x020fe200078e18ffULL,
0x000100007a7a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff8f7819ULL, 0x000fe4000001148fULL,
0x00000018ff7a7819ULL, 0x000fe2000001147aULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x000054107c787816ULL, 0x002fe40000000083ULL, 0x00000018ff7c7819ULL, 0x000fca000001147bULL,
0x0000008a008a7306ULL, 0x000ff00000200c00ULL, 0x0000008500857306ULL, 0x000ff00000200c00ULL,
0x0000008c008c7306ULL, 0x000e700000200c00ULL, 0x0000007e007e7306ULL, 0x000eb00000200c00ULL,
0x0000007d007d7306ULL, 0x000ee20000200c00ULL, 0x00005410857b7816ULL, 0x002fce000000008cULL,
0x0000009100917306ULL, 0x000fe20000200c00ULL, 0x000054107e7e7816ULL, 0x004fce000000008bULL,
0x0000009400947306ULL, 0x000e620000200c00ULL, 0x000054107d907816ULL, 0x008fce0000000090ULL,
0x0000007900967306ULL, 0x0004f00000200c00ULL, 0x0000007f00977306ULL, 0x0009e20000200c00ULL,
0x0000541088797816ULL, 0x004fe40000000087ULL, 0x0000541091917816ULL, 0x002fca0000000094ULL,
0x0000008f00987306ULL, 0x000e620000200c00ULL, 0x000054108e7f7816ULL, 0x010fe2000000008dULL,
0x000000787030723cULL, 0x000f620000001830ULL, 0x0000541096937816ULL, 0x008fca0000000095ULL,
0x0000009900997306ULL, 0x000ea40000200c00ULL, 0x0000007e7038723cULL, 0x040f6c0000001838ULL,
0x0000007a00277306ULL, 0x0007220000200c00ULL, 0x0000541097987816ULL, 0x002fe20000000098ULL,
0x00000090703c723cULL, 0x040f6c000000183cULL, 0x0000007c007c7306ULL, 0x000e620000200c00ULL,
0x00005410897a7816ULL, 0x008fe2000000008aULL, 0x000000927040723cULL, 0x000f620000001840ULL,
0x0000541099997816ULL, 0x004fc40000000086ULL, 0x00005410279a7816ULL, 0x010fe2000000009aULL,
0x0000000220277824ULL, 0x000fc800078e00ffULL, 0x0000007a7034723cULL, 0x000f620000001834ULL,
0x000054107c9b7816ULL, 0x002fce000000009bULL, 0x000000987044723cULL, 0x040f700000001844ULL,
0x0000009a7048723cULL, 0x000f700000001848ULL, 0x000000782850723cULL, 0x040f700000001850ULL,
0x0000007a2854723cULL, 0x040f700000001854ULL, 0x0000007e2858723cULL, 0x040f700000001858ULL,
0x00000090285c723cULL, 0x040f70000000185cULL, 0x000000922860723cULL, 0x040f700000001860ULL,
0x000000982864723cULL, 0x040f700000001864ULL, 0x0000009a2868723cULL, 0x000b6e0000001868ULL,
0xfffffff827287812ULL, 0x020fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006e6e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126900028ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff277224ULL, 0x000fc600078e00ffULL,
0x0000000000287805ULL, 0x004fc80000015200ULL, 0x00000400142b7984ULL, 0x000ea40000000800ULL,
0x800000002bff7812ULL, 0x006fc4000780486fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28717210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09007100780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407100780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x000000712a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000127277810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400142b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010016277824ULL, 0x000fca00078e0277ULL, 0x000000c027297810ULL, 0x000fc80007ffe0ffULL,
0x0000006029287812ULL, 0x000fca00078ec0ffULL, 0x0000000119727824ULL, 0x000fe200078e0228ULL,
0x000004000000a947ULL, 0x000fea0003800000ULL, 0x00000010202a7824ULL, 0x000fe200078e00ffULL,
0x000000291e287217ULL, 0x000fe40007800000ULL, 0x00000003ff707819ULL, 0x000fe4000001161fULL,
0x000000102a737812ULL, 0x000fe200078ec0ffULL, 0x0000000128287824ULL, 0x000fe200078e0a29ULL,
0x00000004706e7810ULL, 0x040fe40007ffe0ffULL, 0x00000008707c7810ULL, 0x040fe20007ffe0ffULL,
0x0000000170787824ULL, 0x100fe200078e0273ULL, 0x0000002873287217ULL, 0x000fe20007800000ULL,
0x000000016e7a7824ULL, 0x000fe200078e0273ULL, 0x0000620024797a11ULL, 0x000fe200078038ffULL,
0x0000000178297824ULL, 0x000fc400078e0272ULL, 0x0000000128717824ULL, 0x100fe200078e0a73ULL,
0x00006300247b7a11ULL, 0x000fe200000f3cffULL, 0x0000008029287825ULL, 0x000fe200078e00ffULL,
0x0000000c70247810ULL, 0x000fe40007ffe0ffULL, 0x000000716e00720cULL, 0x000fe20003f66070ULL,
0x000000017a2a7824ULL, 0x000fe200078e0272ULL, 0x00000013286e7212ULL, 0x000fe200078efcffULL,
0x000000017c7d7824ULL, 0x000fe200078e0273ULL, 0x000000717000720cULL, 0x000fe20003f86070ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x000000796e6e7210ULL, 0x000fc40007fbe0ffULL,
0x000000717c00720cULL, 0x000fe20003f06070ULL, 0x000000017d287824ULL, 0x000fe200078e0272ULL,
0x000000132a707212ULL, 0x000fe200078efcffULL, 0x00000001247c7824ULL, 0x000fe400078e0273ULL,
0x00000001296f7824ULL, 0x000fe200028e067bULL, 0x0000007970707210ULL, 0x000fe20007fde0ffULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x000000712400720cULL, 0x000fc60003fa6070ULL,
0x000000017c2a7824ULL, 0x000fe200078e0272ULL, 0x0000001328287212ULL, 0x000fe200078efcffULL,
0x000000012b717824ULL, 0x000fe400030e067bULL, 0x0000000178247824ULL, 0x000fe200078e021fULL,
0x0000007928287210ULL, 0x000fe20007fde0ffULL, 0x0000000878737824ULL, 0x000fe400078e00ffULL,
0x000000802a2a7825ULL, 0x000fc600078e00ffULL, 0xfffffff873247812ULL, 0x000fe200078ee224ULL,
0x000000017a727824ULL, 0x100fe200078e021fULL, 0x000000132a2a7212ULL, 0x000fe200078efcffULL,
0x000000087a7f7824ULL, 0x000fe400078e00ffULL, 0x000000017d737824ULL, 0x140fe400078e021fULL,
0x000000087d787824ULL, 0x000fe200078e00ffULL, 0xfffffff87f727812ULL, 0x000fe200078ee272ULL,
0x000000017c7a7824ULL, 0x040fe400078e021fULL, 0x000000087c7d7824ULL, 0x000fe200078e00ffULL,
0xfffffff878787812ULL, 0x000fe200078ee273ULL, 0x0000000129297824ULL, 0x000fe200030e067bULL,
0x000000792a2a7210ULL, 0x000fe20007fde0ffULL, 0x0000001024737824ULL, 0x100fe200078e0225ULL,
0xfffffff87d7a7812ULL, 0x000fe200078ee27aULL, 0x0000001072797824ULL, 0x000fc400078e0225ULL,
0x000000012b2b7824ULL, 0x000fe200030e067bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006e737faeULL, 0x0003e2000e101c48ULL, 0x00000010787b7824ULL, 0x100fe400078e0225ULL,
0x000000107a7d7824ULL, 0x000fe200078e0225ULL, 0x0000000070797faeULL, 0x0003e8000d901c48ULL,
0x00000000287b7faeULL, 0x0003e8000c101c48ULL, 0x000000002a7d7faeULL, 0x0003e2000e901c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001020287824ULL, 0x000fe200078e00ffULL,
0x0000620024737a11ULL, 0x000fc800078038ffULL, 0x0000001028287812ULL, 0x000fe400078ec0ffULL,
0x0000630024797a11ULL, 0x000fe400000f3cffULL, 0x000000281f297211ULL, 0x000fc800078fe8ffULL,
0x00000004292b7810ULL, 0x040fe20007ffe0ffULL, 0x00000001292a7824ULL, 0x140fe200078e021fULL,
0x0000000c29717810ULL, 0x040fe20007ffe0ffULL, 0x00000008296f7824ULL, 0x040fe400078e00ffULL,
0x0000000129287824ULL, 0x000fe400078e0272ULL, 0x000000082b7a7824ULL, 0x000fe200078e00ffULL,
0xfffffff86f787812ULL, 0x000fe200078ee22aULL, 0x000000012b2a7824ULL, 0x000fe200078e0272ULL,
0x00000008296f7810ULL, 0x000fe20007ffe0ffULL, 0x000000012b297824ULL, 0x000fc400078e021fULL,
0x0000000171707824ULL, 0x100fe400078e0272ULL, 0x000000016f6e7824ULL, 0x040fe200078e0272ULL,
0xfffffff87a727812ULL, 0x000fe200078ee229ULL, 0x000000016f2b7824ULL, 0x140fe400078e021fULL,
0x000000086f7c7824ULL, 0x000fe400078e00ffULL, 0x00000001716f7824ULL, 0x040fe400078e021fULL,
0x00000008717e7824ULL, 0x000fe200078e00ffULL, 0xfffffff87c7a7812ULL, 0x000fe200078ee22bULL,
0x0000008028287825ULL, 0x000fc600078e00ffULL, 0xfffffff87e7c7812ULL, 0x000fe200078ee26fULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000001328287212ULL, 0x000fc600078efcffULL,
0x000000806e6e7825ULL, 0x000fe200078e00ffULL, 0x0000007328287210ULL, 0x000fe40007f1e0ffULL,
0x000000132a2a7212ULL, 0x080fe200078efcffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000136e6e7212ULL, 0x000fe400078efcffULL, 0x000000732a2a7210ULL, 0x000fe20007f7e0ffULL,
0x0000000129297824ULL, 0x000fe200000e0679ULL, 0x0000001370707212ULL, 0x000fe200078efcffULL,
0x000000107a7b7824ULL, 0x000fe200078e0225ULL, 0x000000736e6e7210ULL, 0x080fe20007f1e0ffULL,
0x000000012b2b7824ULL, 0x000fe200018e0679ULL, 0x0000007370707210ULL, 0x000fe20007f9e0ffULL,
0x0000001078737824ULL, 0x000fc400078e0225ULL, 0x000000016f6f7824ULL, 0x100fe400000e0679ULL,
0x0000000171717824ULL, 0x000fe200020e0679ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000028737faeULL, 0x0003e2000b901c48ULL, 0x0000001072797824ULL, 0x100fe400078e0225ULL,
0x000000107c7d7824ULL, 0x000fc600078e0225ULL, 0x000000002a797faeULL, 0x0003e8000b901c48ULL,
0x000000006e7b7faeULL, 0x0003e8000b901c48ULL, 0x00000000707d7faeULL, 0x0003e4000b901c48ULL,
0x000000021b1b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000804057890ULL, 0x000fe2000fffe03fULL,
0xffffffffff247424ULL, 0x000fe200078e00ffULL, 0x0000000000007918ULL, 0x002fe20000000000ULL,
0x0000001d1b00720cULL, 0x000fcc0003f06070ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fee0008000a05ULL,
0x000000011b288824ULL, 0x000fe400078e0218ULL, 0x00000004ff298424ULL, 0x000fc800078e00ffULL,
0x0000640028288625ULL, 0x000fca00078e0029ULL, 0x0000000828248981ULL, 0x000322000c1e1900ULL,
0x00000008202a7824ULL, 0x000fca00078e00ffULL, 0xfffffff02a2a7812ULL, 0x000fe200078ec0ffULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126b0002a6e7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126480022707f8cULL, 0x0002a4000c80043fULL, 0x0000000000287805ULL, 0x002fc40000015200ULL,
0x01264c00222b7984ULL, 0x000e640000000800ULL, 0x800000002bff7812ULL, 0x006fe40007804871ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28737210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2b7824ULL, 0x000fe200000e0e29ULL, 0x003d09007300780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407300780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff2a7819ULL, 0x000fc8000001142bULL,
0x000000732a2a7211ULL, 0x000fca00078110ffULL, 0x000000ffff2b7224ULL, 0x000fca00000e062bULL,
0x000000022a2a7819ULL, 0x000fc8000000122bULL, 0x0000002a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000172727810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01264c00222b7984ULL, 0x000e640000000800ULL,
0x800000002bff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002020227824ULL, 0x000fca00078e00ffULL, 0xffffff8022227812ULL, 0x000fc800078ec0ffULL,
0x0000010013297810ULL, 0x000fca0007ffe022ULL, 0x0000000112297824ULL, 0x000fca00078e0229ULL,
0x0120000029707984ULL, 0x000e680000000800ULL, 0x0122000029727984ULL, 0x0004e20000000800ULL,
0x000000237000720bULL, 0x002fe20003f1d000ULL, 0x0000e7d27f007947ULL, 0x000fd8000b800000ULL,
0x0000000000717806ULL, 0x004fc800000e0100ULL, 0x000000ff7100720cULL, 0x000fe20003f05270ULL,
0x0000078000007945ULL, 0x000fe20003800000ULL, 0x00000001ff737424ULL, 0x000fe400078e00ffULL,
0x000000ffff227224ULL, 0x000fd200078e0023ULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x0000000217297810ULL, 0x000fe40007ffe0ffULL, 0x000000237000720bULL, 0x000fe40003f74000ULL,
0x000000202900720cULL, 0x000fe20003f05270ULL, 0x0000e7827f007947ULL, 0x000fd4000b800000ULL,
0x0000000000227806ULL, 0x000fc400018e0100ULL, 0x0000008020298824ULL, 0x000fe200078e0213ULL,
0x0000002370288209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000112298824ULL, 0x000fca00078e0229ULL, 0x0124002829008388ULL, 0x0003e20000000800ULL,
0x000000ff2200720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000002370287209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff22ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002328287221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b28287820ULL, 0x000fc80000410000ULL, 0x0000002800787308ULL, 0x000e640000000800ULL,
0x0000007821217220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x0000e6b27f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0022ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x000fe200078ff0ffULL,
0x0000e5827f007947ULL, 0x000fea000b800000ULL, 0x00001f2978297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000022ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x000fe200078ff0ffULL, 0x0000e4527f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000022ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x000fe200078ff0ffULL, 0x0000e3327f007947ULL, 0x000fea000b800000ULL,
0x00001f2978297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000002271ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff737424ULL, 0x000fe200078e00ffULL,
0x0000002370227209ULL, 0x000fd60007810000ULL, 0x8000002270700221ULL, 0x000fe20000010000ULL,
0x00007610ff730816ULL, 0x000fc60000000073ULL, 0x3fb8aa3b70700820ULL, 0x000fc80000410000ULL,
0x0000007000110308ULL, 0x000e640000000800ULL, 0x0000001172720220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002172217221ULL, 0x008fc20000010000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000040010237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a282a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e29ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff237819ULL, 0x000fc8000001142bULL, 0x0000002a23237211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000223237819ULL, 0x000fc8000000122aULL,
0x000000230000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040010237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991073237816ULL, 0x000fc800000000ffULL,
0x000000ff2300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff0c723eULL, 0x000fe400000000ffULL, 0x00000002ff237819ULL, 0x000fe4000001161fULL,
0x000054100c0c7816ULL, 0x000fe2000000000cULL, 0x0000df127f007947ULL, 0x000fea000b800000ULL,
0x00001f230c0f7589ULL, 0x0002a400000e0000ULL, 0x0000000823297810ULL, 0x000fe20007ffe0ffULL,
0x0000df427f007947ULL, 0x000fea000b800000ULL, 0x00000010230d7810ULL, 0x000fe20007ffe0ffULL,
0x00001f290c0e7589ULL, 0x00066a00000e0000ULL, 0x00001f0d0c0d7589ULL, 0x0006a400000e0000ULL,
0x0000001823297810ULL, 0x008fe20007ffe0ffULL, 0x0000df927f007947ULL, 0x000fea000b800000ULL,
0x00001f290c0c7589ULL, 0x0022e400000e0000ULL, 0x0000040020237824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x00000010077c7824ULL, 0x000fc400078e0203ULL, 0xfffff00023237812ULL, 0x000fc800078ec0ffULL,
0x0000c00023237810ULL, 0x000fca0007ffe0ffULL, 0x000000100a0a7824ULL, 0x100fe400078e0223ULL,
0x0000001008087824ULL, 0x000fc600078e0223ULL, 0x000000000a70783bULL, 0x0002e80000000200ULL,
0x000000000828783bULL, 0x0022a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000000f70707232ULL, 0x08cfe40000000000ULL, 0x0000000f72727232ULL, 0x000fe40000000000ULL,
0x0000000e71717232ULL, 0x080fe40000000000ULL, 0x0000000e73737232ULL, 0x000fc40000000000ULL,
0x0000000d28287232ULL, 0x080fe40000000000ULL, 0x0000000d2a2a7232ULL, 0x000fe40000000000ULL,
0x0000000c29297232ULL, 0x080fe40000000000ULL, 0x0000000c2b2b7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001006787824ULL, 0x000fe200078e0203ULL,
0x000000007c7c783bULL, 0x000e620000004200ULL, 0x0000082000007945ULL, 0x000fe80003800000ULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x00000018ff087819ULL, 0x002fc4000001147dULL,
0x00000018ff6c7819ULL, 0x000fe4000001147eULL, 0x00000018ff067819ULL, 0x000fe2000001147cULL,
0x0000000800887306ULL, 0x0003e20000200c00ULL, 0x00000018ff837819ULL, 0x008fe20000011478ULL,
0x00000100788d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011479ULL,
0x000001007a947824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe2000001147fULL,
0x00000100798f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe2000001147aULL,
0x0000006c00897306ULL, 0x0007e20000200c00ULL, 0x000001007c087824ULL, 0x002fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fc4000001147bULL, 0x000088807f8a7816ULL, 0x000fe400000000ffULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x0000008300907306ULL, 0x0003e20000200c00ULL,
0x000088807d6c7816ULL, 0x048fe400000000ffULL, 0x00000018ff947819ULL, 0x000fe40000011494ULL,
0x00000018ff8d7819ULL, 0x000fe4000001148dULL, 0x00000018ff8f7819ULL, 0x000fe2000001148fULL,
0x00000006000a7306ULL, 0x0007e20000200c00ULL, 0x000001007d837824ULL, 0x002fca00078e00ffULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x0000008500927306ULL, 0x000fe20000200c00ULL,
0x000088807c067816ULL, 0x048fe200000000ffULL, 0x000100007c7c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000006c00857306ULL, 0x0003f00000200c00ULL,
0x0000006d008c7306ULL, 0x000fe20000200c00ULL, 0x000001007e6c7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000008600967306ULL, 0x000ff00000200c00ULL,
0x0000000600067306ULL, 0x000ff00000200c00ULL, 0x00000008006d7306ULL, 0x0002f00000200c00ULL,
0x0000008300867306ULL, 0x000ea20000200c00ULL, 0x000088807e087816ULL, 0x042fe200000000ffULL,
0x000100007e7e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000006c00837306ULL, 0x0003f00000200c00ULL, 0x0000008700987306ULL, 0x0005e20000200c00ULL,
0x00008880786c7816ULL, 0x042fe200000000ffULL, 0x0001000078787824ULL, 0x000fca00078e00ffULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000006c008e7306ULL, 0x0003e20000200c00ULL,
0x000100007d877824ULL, 0x004fca00078e00ffULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x0000007c007d7306ULL, 0x0004e20000200c00ULL, 0x000088807a6c7816ULL, 0x042fe200000000ffULL,
0x000100007a7a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000006c00957306ULL, 0x0007e20000200c00ULL, 0x000001007f7c7824ULL, 0x044fe400078e00ffULL,
0x000100007f7f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000007800917306ULL, 0x0002a20000200c00ULL, 0x00005410066c7816ULL, 0x008fe4000000006dULL,
0x00005410856d7816ULL, 0x000fe20000000086ULL, 0x000001007b857824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fc6000001147fULL, 0x0000007c008b7306ULL, 0x0007e20000200c00ULL,
0x000088807b787816ULL, 0x042fe200000000ffULL, 0x000100007b7b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe20000011485ULL, 0x0000006c702c723cULL, 0x080f64000000182cULL,
0x000000ffff067224ULL, 0x000fe200078e0078ULL, 0x000054107d787816ULL, 0x000fe2000000000aULL,
0x0000009400947306ULL, 0x000e620000200c00ULL, 0x00008880797c7816ULL, 0x048fe200000000ffULL,
0x0001000079797824ULL, 0x000fe200078e00ffULL, 0x00000018ff0a7819ULL, 0x000fe2000001147bULL,
0x0000006c284c723cULL, 0x000f62000000184cULL, 0x0000541091907816ULL, 0x004fc40000000090ULL,
0x00000018ff797819ULL, 0x000fe20000011479ULL, 0x0000007a00977306ULL, 0x000eb00000200c00ULL,
0x0000008700877306ULL, 0x000fe20000200c00ULL, 0x0000541095947816ULL, 0x002fce0000000094ULL,
0x0000000800087306ULL, 0x000e620000200c00ULL, 0x0000541097967816ULL, 0x004fce0000000096ULL,
0x0000008a008a7306ULL, 0x000eb00000200c00ULL, 0x0000007e007e7306ULL, 0x000ee20000200c00ULL,
0x00005410087a7816ULL, 0x002fce0000000083ULL, 0x0000007f007f7306ULL, 0x000e620000200c00ULL,
0x000054108a7b7816ULL, 0x004fce000000008bULL, 0x0000008d008d7306ULL, 0x000ea20000200c00ULL,
0x000054107e7e7816ULL, 0x008fe20000000089ULL, 0x0000007a7034723cULL, 0x080f6c0000001834ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x000054107f7f7816ULL, 0x002fe2000000008cULL,
0x0000007a2854723cULL, 0x000f6c0000001854ULL, 0x0000008f008f7306ULL, 0x000e620000200c00ULL,
0x000054108e8e7816ULL, 0x004fe2000000008dULL, 0x0000007e7038723cULL, 0x080f6c0000001838ULL,
0x0000007900937306ULL, 0x0004e40000200c00ULL, 0x0000007e2858723cULL, 0x000f6c0000001858ULL,
0x0000000600067306ULL, 0x000fe20000200c00ULL, 0x0000541087797816ULL, 0x004fc40000000088ULL,
0x000054107c8f7816ULL, 0x002fe2000000008fULL, 0x00000010027c7824ULL, 0x000fc800078e0203ULL,
0x0000008500857306ULL, 0x000e620000200c00ULL, 0x0000541093917816ULL, 0x008fe20000000092ULL,
0x000000787030723cULL, 0x040f6c0000001830ULL, 0x0000000a007d7306ULL, 0x000ea40000200c00ULL,
0x0000008e703c723cULL, 0x000f62000000183cULL, 0x0000541006957816ULL, 0x002fce0000000085ULL,
0x000000907040723cULL, 0x000f620000001840ULL, 0x000054107d977816ULL, 0x004fce0000000098ULL,
0x000000947044723cULL, 0x040f700000001844ULL, 0x000000967048723cULL, 0x000b6e0000001848ULL,
0x0000001005707824ULL, 0x120fe200078e0223ULL, 0x000000782850723cULL, 0x000f620000001850ULL,
0x0000001004237824ULL, 0x000fc800078e0223ULL, 0x000000007070783bULL, 0x000e660000000200ULL,
0x0000008e285c723cULL, 0x040f70000000185cULL, 0x000000902860723cULL, 0x040f700000001860ULL,
0x000000942864723cULL, 0x040f700000001864ULL, 0x000000962828723cULL, 0x000b640000001868ULL,
0x000000002368783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000000f70707232ULL, 0x082fe40000000000ULL,
0x0000000f72727232ULL, 0x000fc40000000000ULL, 0x0000000e71717232ULL, 0x080fe40000000000ULL,
0x0000000e73737232ULL, 0x000fe40000000000ULL, 0x0000000d68687232ULL, 0x088fe40000000000ULL,
0x0000000d6a6a7232ULL, 0x000fe40000000000ULL, 0x0000000c69697232ULL, 0x080fe40000000000ULL,
0x0000000c6b6b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001000787824ULL, 0x000fe200078e0203ULL, 0x000000007c7c783bULL, 0x000eaa0000004200ULL,
0x000000007878783bULL, 0x000ee20000004200ULL, 0x00000018ff0a7819ULL, 0x004fe2000001147fULL,
0x000001007e867824ULL, 0x000fe200078e00ffULL, 0x00000018ff027819ULL, 0x000fc4000001147dULL,
0x00000018ff087819ULL, 0x000fe2000001147eULL, 0x0000000a00897306ULL, 0x0005e20000200c00ULL,
0x00000018ff6c7819ULL, 0x008fe20000011479ULL, 0x00000100788c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff007819ULL, 0x000fe2000001147cULL, 0x000001007a927824ULL, 0x000fe200078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001147aULL, 0x00000018ff237819ULL, 0x000fe20000011478ULL,
0x0000000200837306ULL, 0x0007e20000200c00ULL, 0x000001007d0a7824ULL, 0x004fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fc4000001147bULL, 0x00008880788b7816ULL, 0x040fe200000000ffULL,
0x0001000078787824ULL, 0x000fe200078e00ffULL, 0x00000018ff0a7819ULL, 0x000fe4000001140aULL,
0x0000000800887306ULL, 0x0005e20000200c00ULL, 0x000001007c027824ULL, 0x008fe200078e00ffULL,
0x00000018ff787819ULL, 0x000fe40000011478ULL, 0x00000018ff927819ULL, 0x000fe40000011492ULL,
0x00000018ff027819ULL, 0x000fc40000011402ULL, 0x0000006c00907306ULL, 0x0007e20000200c00ULL,
0x000088807d087816ULL, 0x004fe400000000ffULL, 0x00000018ff867819ULL, 0x000fe40000011486ULL,
0x00000018ff8c7819ULL, 0x000fc6000001148cULL, 0x0000000000067306ULL, 0x0005e20000200c00ULL,
0x000100007d6c7824ULL, 0x008fca00078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000006d00947306ULL, 0x000fe20000200c00ULL, 0x000088807c007816ULL, 0x044fe200000000ffULL,
0x000100007c7c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000000800087306ULL, 0x000ff00000200c00ULL, 0x0000000a006d7306ULL, 0x0004f00000200c00ULL,
0x00000023008e7306ULL, 0x000fe20000200c00ULL, 0x000088807f0a7816ULL, 0x004fce00000000ffULL,
0x0000000200237306ULL, 0x000fe20000200c00ULL, 0x00005410086d7816ULL, 0x008fe2000000006dULL,
0x000001007b087824ULL, 0x000fca00078e00ffULL, 0x00000018ff087819ULL, 0x000fe20000011408ULL,
0x0000000000007306ULL, 0x000ff00000200c00ULL, 0x0000006c00027306ULL, 0x0005f00000200c00ULL,
0x0000008500967306ULL, 0x0007e20000200c00ULL, 0x000100007f6c7824ULL, 0x004fca00078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001146cULL, 0x0000007c007d7306ULL, 0x0005e20000200c00ULL,
0x000088807e857816ULL, 0x048fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000006c008a7306ULL, 0x0006620000200c00ULL,
0x000001007f7c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x00000078008f7306ULL, 0x0004620000200c00ULL, 0x000088807a6c7816ULL, 0x048fe200000000ffULL,
0x000100007a7a7824ULL, 0x000fca00078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000007c00877306ULL, 0x0007e20000200c00ULL, 0x000088807b787816ULL, 0x044fe200000000ffULL,
0x000100007b7b7824ULL, 0x000fe200078e00ffULL, 0x000054108a897816ULL, 0x002fc80000000089ULL,
0x00000018ff7b7819ULL, 0x000fe2000001147bULL, 0x0000007e007f7306ULL, 0x0002a20000200c00ULL,
0x00008880797c7816ULL, 0x008fe400000000ffULL, 0x000054108f8e7816ULL, 0x000fca000000008eULL,
0x0000006c00937306ULL, 0x0007e20000200c00ULL, 0x00000100797e7824ULL, 0x042fe400078e00ffULL,
0x0001000079797824ULL, 0x000fc600078e00ffULL, 0x00000018ff7e7819ULL, 0x000fe4000001147eULL,
0x00000018ff797819ULL, 0x000fe20000011479ULL, 0x0000009200927306ULL, 0x000e620000200c00ULL,
0x00005410006c7816ULL, 0x008fe20000000023ULL, 0x000000ffff007224ULL, 0x000fe200078e0078ULL,
0x000054107d787816ULL, 0x000fe40000000006ULL, 0x000054107f887816ULL, 0x004fc60000000088ULL,
0x0000008500857306ULL, 0x000fe20000200c00ULL, 0x0000006c684c723cULL, 0x040b6e000000184cULL,
0x0000008600867306ULL, 0x000ea20000200c00ULL, 0x0000541093927816ULL, 0x002fe20000000092ULL,
0x000000886858723cULL, 0x000b6c0000001858ULL, 0x0000000a000a7306ULL, 0x000e640000200c00ULL,
0x0000006c702c723cULL, 0x040b6c000000182cULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x0000541085867816ULL, 0x004fe20000000086ULL, 0x000000887038723cULL, 0x000b6c0000001838ULL,
0x0000008c008c7306ULL, 0x000ea20000200c00ULL, 0x000054100a877816ULL, 0x002fce0000000087ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x000000866854723cULL, 0x080b6e0000001854ULL,
0x0000007e008d7306ULL, 0x000e620000200c00ULL, 0x000054108b8c7816ULL, 0x004fe2000000008cULL,
0x000000867034723cULL, 0x000b6c0000001834ULL, 0x0000007900917306ULL, 0x0004f00000200c00ULL,
0x0000007a00957306ULL, 0x000ee20000200c00ULL, 0x0000541002797816ULL, 0x004fc40000000083ULL,
0x000054107c8d7816ULL, 0x002fca000000008dULL, 0x0000000000007306ULL, 0x000fe20000200c00ULL,
0x00005410918f7816ULL, 0x008fe20000000090ULL, 0x000000786850723cULL, 0x040b6c0000001850ULL,
0x0000000800237306ULL, 0x000e620000200c00ULL, 0x0000541095947816ULL, 0x000fe20000000094ULL,
0x0000008c685c723cULL, 0x040b6c000000185cULL, 0x0000007b007b7306ULL, 0x000ea40000200c00ULL,
0x0000008e6860723cULL, 0x000b620000001860ULL, 0x0000541000937816ULL, 0x002fe20000000023ULL,
0x0000000220007824ULL, 0x000fcc00078e00ffULL, 0x000000787030723cULL, 0x000b620000001830ULL,
0xfffffff800027812ULL, 0x000fe400078ec0ffULL, 0x000054107b957816ULL, 0x004fca0000000096ULL,
0x000000926864723cULL, 0x000b700000001864ULL, 0x0000008c703c723cULL, 0x040b70000000183cULL,
0x0000008e7040723cULL, 0x040b700000001840ULL, 0x000000927044723cULL, 0x040b700000001844ULL,
0x000000947048723cULL, 0x080b700000001848ULL, 0x000000946868723cULL, 0x000b620000001828ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fde0000008000ULL,
0x00000000146c7f8cULL, 0x0202a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0126980002ff7f8cULL, 0x0007e2000c80043fULL, 0x000000ffff007224ULL, 0x000fc600078e00ffULL,
0x0000000000287805ULL, 0x000fc80000015200ULL, 0x0000040014237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x006fc4000780486dULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000002a7805ULL, 0x000fcc0000015200ULL, 0x0000002a28237210ULL, 0x000fca0007f1e1ffULL,
0x000000012b2a7824ULL, 0x000fe200000e0e29ULL, 0x003d09002300780cULL, 0x000fc80003f06070ULL,
0x000000ff2a00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c402300780cULL, 0x000fc80003f06070ULL, 0x000000ff2a00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff027819ULL, 0x008fc8000001142aULL,
0x0000002302027211ULL, 0x000fca00078110ffULL, 0x000000ffff237224ULL, 0x000fca00000e062aULL,
0x0000000202027819ULL, 0x000fc80000001223ULL, 0x000000020000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000100007810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040014237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780486dULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000116237810ULL, 0x000fc80007ffe0ffULL, 0x0000001c2300720cULL, 0x000fda0003f06070ULL,
0x000007b000000947ULL, 0x000fea0003800000ULL, 0x0000000216237810ULL, 0x000fe20007ffe0ffULL,
0x0000590024027a24ULL, 0x018fe200078e02ffULL, 0x0000010027277810ULL, 0x000fe40007ffe0ffULL,
0x0000001c2300720cULL, 0x000fe20003f06070ULL, 0x0000008002067824ULL, 0x000fe200078e00ffULL,
0x0000006027007812ULL, 0x000fca00078ec0ffULL, 0x0000000119027824ULL, 0x000fcc00078e0200ULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x000000271e007217ULL, 0x000fe20007800000ULL,
0x0000001020087824ULL, 0x000fe200078e00ffULL, 0x0000620006237a11ULL, 0x000fc600078038ffULL,
0x0000000100007824ULL, 0x000fe200078e0a27ULL, 0x00000010086d7812ULL, 0x000fe400078ec0ffULL,
0x00000003ff087819ULL, 0x000fe4000001161fULL, 0x000000006d007217ULL, 0x000fe40007800000ULL,
0x0000000408297810ULL, 0x040fe20007ffe0ffULL, 0x00000001080a7824ULL, 0x100fe200078e026dULL,
0x0000630006277a11ULL, 0x000fe200000f3cffULL, 0x0000000100007824ULL, 0x100fe200078e0a6dULL,
0x0000000808067810ULL, 0x000fe20007ffe0ffULL, 0x000000010a287824ULL, 0x000fe200078e0202ULL,
0x0000000c08707810ULL, 0x000fe20007ffe0ffULL, 0x0000000129717824ULL, 0x040fe200078e026dULL,
0x000000002900720cULL, 0x080fe20003f86070ULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0x000000000800720cULL, 0x000fc40003fa6070ULL, 0x000000007000720cULL, 0x080fe20003f06070ULL,
0x00000001712a7824ULL, 0x000fe200078e0202ULL, 0x00000013286c7212ULL, 0x000fe200078efcffULL,
0x0000000106087824ULL, 0x040fe200078e026dULL, 0x000000000600720cULL, 0x000fe20003f66070ULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000006c236c7210ULL, 0x000fc60007fde0ffULL,
0x0000000170727824ULL, 0x000fe200078e026dULL, 0x000000132a707212ULL, 0x000fe200078efcffULL,
0x0000000108287824ULL, 0x000fe400078e0202ULL, 0x0000000171007824ULL, 0x000fe400078e021fULL,
0x00000001296d7824ULL, 0x000fe200030e0627ULL, 0x0000002370707210ULL, 0x000fe20007fde0ffULL,
0x0000000871717824ULL, 0x000fe400078e00ffULL, 0x0000008028287825ULL, 0x000fc600078e00ffULL,
0xfffffff871007812ULL, 0x000fe200078ee200ULL, 0x000000010a067824ULL, 0x000fe200078e021fULL,
0x0000001328287212ULL, 0x000fe200078efcffULL, 0x000000080a737824ULL, 0x000fe400078e00ffULL,
0x00000001722a7824ULL, 0x000fe400078e0202ULL, 0x000000012b717824ULL, 0x000fe200030e0627ULL,
0xfffffff873067812ULL, 0x000fe200078ee206ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000002328287210ULL, 0x000fc60007fde0ffULL, 0x00000001080a7824ULL, 0x100fe200078e021fULL,
0x000000132a027212ULL, 0x000fe200078efcffULL, 0x0000000808737824ULL, 0x000fe400078e00ffULL,
0x0000000172087824ULL, 0x040fe400078e021fULL, 0x0000000872797824ULL, 0x000fe200078e00ffULL,
0xfffffff8730a7812ULL, 0x000fe200078ee20aULL, 0x0000000129297824ULL, 0x000fe200030e0627ULL,
0x0000002302027210ULL, 0x000fe20007fde0ffULL, 0x0000001006237824ULL, 0x100fe200078e0203ULL,
0xfffffff879087812ULL, 0x000fe200078ee208ULL, 0x0000001000737824ULL, 0x000fc400078e0203ULL,
0x000000100a797824ULL, 0x100fe200078e0203ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000006c237faeULL, 0x0003e2000e901c48ULL, 0x00000010087b7824ULL, 0x000fe400078e0203ULL,
0x000000012b037824ULL, 0x000fe200030e0627ULL, 0x0000000070737faeULL, 0x0003e8000e101c48ULL,
0x0000000028797faeULL, 0x0003e8000d901c48ULL, 0x00000000027b7faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001020007824ULL, 0x000fca00078e00ffULL,
0x0000001000007812ULL, 0x000fc800078ec0ffULL, 0x000000001f007211ULL, 0x000fc800078fe8ffULL,
0x00000004000a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000100087824ULL, 0x040fe200078e021fULL,
0x0000000c00277810ULL, 0x040fe20007ffe0ffULL, 0x0000000800237824ULL, 0x040fe400078e00ffULL,
0x0000000100287824ULL, 0x100fe400078e0202ULL, 0x000000010a2a7824ULL, 0x000fe200078e0202ULL,
0xfffffff823087812ULL, 0x000fe200078ee208ULL, 0x0000000127707824ULL, 0x040fe200078e0202ULL,
0x0000000800237810ULL, 0x000fe20007ffe0ffULL, 0x0000000827727824ULL, 0x000fc400078e00ffULL,
0x000000010a007824ULL, 0x140fe400078e021fULL, 0x00000001236c7824ULL, 0x040fe400078e0202ULL,
0x0000000123027824ULL, 0x140fe400078e021fULL, 0x00000008236d7824ULL, 0x000fe400078e00ffULL,
0x0000000127237824ULL, 0x000fe400078e021fULL, 0x000000080a2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff86d0a7812ULL, 0x000fe200078ee202ULL, 0x0000008028287825ULL, 0x000fe200078e00ffULL,
0xfffffff872727812ULL, 0x000fc400078ee223ULL, 0x0000620006237a11ULL, 0x000fe200078038ffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0xfffffff82b007812ULL, 0x000fe400078ee200ULL,
0x0000001328287212ULL, 0x080fe200078efcffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000630006277a11ULL, 0x000fe400000f3cffULL, 0x0000002823287210ULL, 0x000fe20007f1e0ffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000132a027212ULL, 0x000fc400078efcffULL,
0x000000136c2a7212ULL, 0x080fe200078efcffULL, 0x0000000129297824ULL, 0x000fe200000e0627ULL,
0x00000013706c7212ULL, 0x000fe200078efcffULL, 0x0000001000737824ULL, 0x100fe200078e0203ULL,
0x0000000223027210ULL, 0x040fe20007f1e0ffULL, 0x000000100a797824ULL, 0x100fe200078e0203ULL,
0x0000002a232a7210ULL, 0x040fe20007f7e0ffULL, 0x00000010727b7824ULL, 0x100fe200078e0203ULL,
0x0000006c236c7210ULL, 0x000fe20007f9e0ffULL, 0x0000001008237824ULL, 0x000fe400078e0203ULL,
0x000000012b037824ULL, 0x000fc400000e0627ULL, 0x000000016d2b7824ULL, 0x100fe200018e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000028237faeULL, 0x0003e2000b901c48ULL,
0x00000001716d7824ULL, 0x000fc600020e0627ULL, 0x0000000002737faeULL, 0x0003e8000b901c48ULL,
0x000000002a797faeULL, 0x0003e8000b901c48ULL, 0x000000006c7b7faeULL, 0x0003e4000b901c48ULL,
0x0000000820027824ULL, 0x00afe400078e00ffULL, 0x0000002017007824ULL, 0x000fc600078e0215ULL,
0x0000000802037812ULL, 0x000fe400078ec0ffULL, 0x0000000000007918ULL, 0x000fe60000000000ULL,
0x0000000103067824ULL, 0x000fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe60000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000010027f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01266800062a7f8cULL, 0x000662000c80043fULL, 0x000000ffff007224ULL, 0x004fc600078e0003ULL,
0x0000000000027805ULL, 0x000fc80000015200ULL, 0x01266c0006237984ULL, 0x000ea40000000800ULL,
0x8000000023ff7812ULL, 0x006fc4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002802237210ULL, 0x000fca0007f1e1ffULL, 0x0000000129287824ULL, 0x000fe200000e0e03ULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2800720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2800720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff087819ULL, 0x000fc80000011428ULL, 0x0000002308087211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0628ULL, 0x0000000208087819ULL, 0x000fc80000001223ULL,
0x000000080000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01266c0006237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000018017027811ULL, 0x000fc800078e38ffULL,
0x0000000212027210ULL, 0x000fca0007ffe013ULL, 0x0120000002037984ULL, 0x000e680000000800ULL,
0x0122000002067984ULL, 0x0084e20000000800ULL, 0x000000220300720bULL, 0x002fe20003f1d000ULL,
0x0000c0327f007947ULL, 0x000fd8000b800000ULL, 0x0000000000087806ULL, 0x004fc800000e0100ULL,
0x000000ff0800720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff0a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff027224ULL, 0x000fd200078e0022ULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x0000000317237810ULL, 0x000fe40007ffe0ffULL,
0x000000220300720bULL, 0x000fe40003f74000ULL, 0x000000202300720cULL, 0x000fe20003f05270ULL,
0x0000bfe27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000237806ULL, 0x000fc400018e0100ULL,
0x0000008020138824ULL, 0x000fe200078e0213ULL, 0x0000002203027209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000112138824ULL, 0x000fca00078e0213ULL,
0x0124000213008388ULL, 0x0003e20000000800ULL, 0x000000ff2300720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x00000022020a7221ULL, 0x002fe20000010100ULL,
0x000000ff23ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0a0a7820ULL, 0x000fcc0000410000ULL, 0x0000000a000a7308ULL, 0x000e640000000800ULL,
0x0000000a21217220ULL, 0x002fe40000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff297819ULL, 0x000fe2000001161fULL, 0x0000bf227f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x0002a400000e0000ULL, 0x000000292c2c7220ULL, 0x084fe20000410000ULL,
0x000000292d2d7220ULL, 0x080fe20000410000ULL, 0x0000002930307220ULL, 0x080fe20000410000ULL,
0x0000002931317220ULL, 0x080fe20000410000ULL, 0x0000002934347220ULL, 0x080fe20000410000ULL,
0x0000002935357220ULL, 0x080fe20000410000ULL, 0x0000002938387220ULL, 0x080fe20000410000ULL,
0x0000002939397220ULL, 0x080fe20000410000ULL, 0x000000293c3c7220ULL, 0x080fe20000410000ULL,
0x000000293d3d7220ULL, 0x080fe20000410000ULL, 0x0000002940407220ULL, 0x080fe20000410000ULL,
0x0000002941417220ULL, 0x080fe20000410000ULL, 0x0000002944447220ULL, 0x080fe20000410000ULL,
0x0000002945457220ULL, 0x080fe20000410000ULL, 0x0000002948487220ULL, 0x080fe20000410000ULL,
0x0000002949497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0023ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000081f297811ULL, 0x000fe200078ff0ffULL,
0x0000bdf27f007947ULL, 0x000fea000b800000ULL, 0x00001f290a297589ULL, 0x00046400000e0000ULL,
0x000000292e2e7220ULL, 0x086fe20000410000ULL, 0x000000292f2f7220ULL, 0x080fe20000410000ULL,
0x0000002932327220ULL, 0x080fe20000410000ULL, 0x0000002933337220ULL, 0x080fe20000410000ULL,
0x0000002936367220ULL, 0x080fe20000410000ULL, 0x0000002937377220ULL, 0x080fe20000410000ULL,
0x000000293a3a7220ULL, 0x080fe20000410000ULL, 0x000000293b3b7220ULL, 0x080fe20000410000ULL,
0x000000293e3e7220ULL, 0x080fe20000410000ULL, 0x000000293f3f7220ULL, 0x080fe20000410000ULL,
0x0000002942427220ULL, 0x080fe20000410000ULL, 0x0000002943437220ULL, 0x080fe20000410000ULL,
0x0000002946467220ULL, 0x080fe20000410000ULL, 0x0000002947477220ULL, 0x080fe20000410000ULL,
0x000000294a4a7220ULL, 0x080fe20000410000ULL, 0x000000294b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000023ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000101f297811ULL, 0x000fe200078ff0ffULL, 0x0000bcc27f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x00046400000e0000ULL, 0x000000294c4c7220ULL, 0x086fe20000410000ULL,
0x000000294d4d7220ULL, 0x080fe20000410000ULL, 0x0000002950507220ULL, 0x080fe20000410000ULL,
0x0000002951517220ULL, 0x080fe20000410000ULL, 0x0000002954547220ULL, 0x080fe20000410000ULL,
0x0000002955557220ULL, 0x080fe20000410000ULL, 0x0000002958587220ULL, 0x080fe20000410000ULL,
0x0000002959597220ULL, 0x080fe20000410000ULL, 0x000000295c5c7220ULL, 0x080fe20000410000ULL,
0x000000295d5d7220ULL, 0x080fe20000410000ULL, 0x0000002960607220ULL, 0x080fe20000410000ULL,
0x0000002961617220ULL, 0x080fe20000410000ULL, 0x0000002964647220ULL, 0x080fe20000410000ULL,
0x0000002965657220ULL, 0x080fe20000410000ULL, 0x0000002968687220ULL, 0x080fe20000410000ULL,
0x0000002969697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000023ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000181f297811ULL, 0x000fe200078ff0ffULL, 0x0000bba27f007947ULL, 0x000fea000b800000ULL,
0x00001f290a297589ULL, 0x00046400000e0000ULL, 0x000000294e4e7220ULL, 0x086fe20000410000ULL,
0x000000294f4f7220ULL, 0x080fe20000410000ULL, 0x0000002952527220ULL, 0x080fe20000410000ULL,
0x0000002953537220ULL, 0x080fe20000410000ULL, 0x0000002956567220ULL, 0x080fe20000410000ULL,
0x0000002957577220ULL, 0x080fe20000410000ULL, 0x000000295a5a7220ULL, 0x080fe20000410000ULL,
0x000000295b5b7220ULL, 0x080fe20000410000ULL, 0x000000295e5e7220ULL, 0x080fe20000410000ULL,
0x000000295f5f7220ULL, 0x080fe20000410000ULL, 0x0000002962627220ULL, 0x080fe20000410000ULL,
0x0000002963637220ULL, 0x080fe20000410000ULL, 0x0000002966667220ULL, 0x080fe20000410000ULL,
0x0000002967677220ULL, 0x080fe20000410000ULL, 0x000000296a6a7220ULL, 0x080fe20000410000ULL,
0x000000296b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000002308ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff0a7424ULL, 0x000fd800078e00ffULL,
0x0000000302030221ULL, 0x000fe20000010100ULL, 0x00007610ff0a0816ULL, 0x000fc6000000000aULL,
0x3fb8aa3b03030820ULL, 0x000fc80000410000ULL, 0x0000000300110308ULL, 0x000e640000000800ULL,
0x0000001106060220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002106217221ULL, 0x008fc20000010000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000000820037824ULL, 0x000fca00078e00ffULL, 0xfffffff003087812ULL, 0x000fca00078ec0ffULL,
0x0126b40008037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff107224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101000780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000227805ULL, 0x000fcc0000015200ULL, 0x0000002212067210ULL, 0x000fca0007f1e1ffULL,
0x0000000123227824ULL, 0x000fe200000e0e13ULL, 0x003d09000600780cULL, 0x000fc80003f06070ULL,
0x000000ff2200720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400600780cULL, 0x000fc80003f06070ULL, 0x000000ff2200720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff037819ULL, 0x000fc80000011422ULL,
0x0000000603037211ULL, 0x000fca00078110ffULL, 0x000000ffff067224ULL, 0x000fca00000e0622ULL,
0x0000000203037819ULL, 0x000fc80000001206ULL, 0x000000030000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000110107810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0126b40008037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100a037816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff0300720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000011ff03723eULL, 0x000fe400000000ffULL, 0x00000002ff067819ULL, 0x000fe4000001161fULL,
0x0000541003037816ULL, 0x000fe20000000003ULL, 0x0000b7627f007947ULL, 0x000fea000b800000ULL,
0x00001f06030f7589ULL, 0x0002a400000e0000ULL, 0x0000000806297810ULL, 0x000fe20007ffe0ffULL,
0x0000b7927f007947ULL, 0x000fea000b800000ULL, 0x0000001006087810ULL, 0x000fe20007ffe0ffULL,
0x00001f29030e7589ULL, 0x00066800000e0000ULL, 0x00001f08030d7589ULL, 0x0006a400000e0000ULL,
0x0000001806297810ULL, 0x008fe20007ffe0ffULL, 0x0000b7e27f007947ULL, 0x000fea000b800000ULL,
0x00001f29030c7589ULL, 0x0006a400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000011a037812ULL, 0x00afe200078ec0ffULL, 0x000000080b0a7824ULL, 0x000fe200078e00ffULL,
0x00000004ff067819ULL, 0x000fe2000001161fULL, 0x0000000809137824ULL, 0x000fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000018000007945ULL, 0x000fe20003800000ULL,
0x0000001007707824ULL, 0x000fc400078e0225ULL, 0x0000000403067824ULL, 0x000fc800078e0206ULL,
0x000000010b037824ULL, 0x100fe400078e0206ULL, 0x0000000109087824ULL, 0x000fc600078e0206ULL,
0xfffffff80a067812ULL, 0x000fe200078ee203ULL, 0x00000004200a7824ULL, 0x000fe200078e00ffULL,
0x0000d00017037811ULL, 0x000fe400078e60ffULL, 0xfffffff813087812ULL, 0x000fe400078ee208ULL,
0x000000040a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000001006067824ULL, 0x100fe400078e0203ULL,
0x0000001008087824ULL, 0x000fe200078e0203ULL, 0x000000020a0a7812ULL, 0x000fc400078efcffULL,
0x00000000066c783bULL, 0x0002e80000000200ULL, 0x000000000828783bULL, 0x0002a20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000000f6c6c7232ULL, 0x08cfe40000000000ULL,
0x0000000f6e6e7232ULL, 0x000fe40000000000ULL, 0x0000000e6d6d7232ULL, 0x080fe40000000000ULL,
0x0000000e6f6f7232ULL, 0x000fc40000000000ULL, 0x0000000d28287232ULL, 0x080fe40000000000ULL,
0x0000000d2a2a7232ULL, 0x000fe40000000000ULL, 0x0000000c29297232ULL, 0x080fe40000000000ULL,
0x0000000c2b2b7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000a1f087211ULL, 0x002fe200078fe0ffULL, 0x000000080b067824ULL, 0x040fe200078e00ffULL,
0x000000007070783bULL, 0x000e620000004200ULL, 0x0000001004047824ULL, 0x000fe200078e0203ULL,
0x0000082000007945ULL, 0x000fe20003800000ULL, 0x000000010b0b7824ULL, 0x000fca00078e0208ULL,
0xfffffff806067812ULL, 0x000fca00078ee20bULL, 0x0000001006067824ULL, 0x000fca00078e0225ULL,
0x000000000678783bULL, 0x0006a20000004200ULL, 0x00000018ff077819ULL, 0x002fe20000011470ULL,
0x00010000737e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0b7819ULL, 0x000fe40000011471ULL,
0x00000018ff107819ULL, 0x000fe20000011472ULL, 0x00000007000a7306ULL, 0x0003e20000200c00ULL,
0x0000888070067816ULL, 0x008fe400000000ffULL, 0x00000018ff127819ULL, 0x000fe40000011473ULL,
0x00000018ff7e7819ULL, 0x000fc6000001147eULL, 0x0000000b00227306ULL, 0x0007e20000200c00ULL,
0x0000010070077824ULL, 0x042fe400078e00ffULL, 0x0001000070707824ULL, 0x000fe200078e00ffULL,
0x00000018ff237819ULL, 0x004fe20000011479ULL, 0x0000010078807824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe4000001147aULL, 0x00000010007c7306ULL, 0x0003e20000200c00ULL,
0x00000100710b7824ULL, 0x008fe200078e00ffULL, 0x00000018ff077819ULL, 0x000fe20000011407ULL,
0x000001007b897824ULL, 0x000fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fe20000011478ULL,
0x000001007a867824ULL, 0x000fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fc40000011470ULL,
0x0000002300847306ULL, 0x0005e20000200c00ULL, 0x0000888071107816ULL, 0x042fe200000000ffULL,
0x0001000071717824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe4000001147bULL,
0x0000888079817816ULL, 0x000fe400000000ffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0000002700887306ULL, 0x0003e20000200c00ULL, 0x0000888072237816ULL, 0x004fe400000000ffULL,
0x000088807b877816ULL, 0x040fe200000000ffULL, 0x000100007b7b7824ULL, 0x000fe200078e00ffULL,
0x000088807a857816ULL, 0x040fe200000000ffULL, 0x000100007a7a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x00000012007f7306ULL, 0x0005e20000200c00ULL,
0x0000010072277824ULL, 0x042fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe20000011486ULL,
0x0001000072727824ULL, 0x000fe200078e00ffULL, 0x00000018ff7b7819ULL, 0x000fc4000001147bULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000001300837306ULL, 0x000fe20000200c00ULL,
0x00000018ff127819ULL, 0x004fe4000001140bULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x00000018ff897819ULL, 0x000fe40000011489ULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000000600067306ULL, 0x000ff00000200c00ULL, 0x0000000700077306ULL, 0x000e700000200c00ULL,
0x00000070000b7306ULL, 0x0004f00000200c00ULL, 0x0000001000107306ULL, 0x000fe20000200c00ULL,
0x0000010073707824ULL, 0x004fe200078e00ffULL, 0x0000541006067816ULL, 0x002fc80000000007ULL,
0x00000018ff707819ULL, 0x000fe40000011470ULL, 0x0000001200137306ULL, 0x000e620000200c00ULL,
0x000054100b0a7816ULL, 0x008fce000000000aULL, 0x0000007100717306ULL, 0x000eb00000200c00ULL,
0x0000007d008a7306ULL, 0x0007e20000200c00ULL, 0x0000541010077816ULL, 0x002fce0000000013ULL,
0x0000002700127306ULL, 0x0003e20000200c00ULL, 0x00008880737d7816ULL, 0x008fe200000000ffULL,
0x000000066c2c723cULL, 0x000f62000000182cULL, 0x00005410710b7816ULL, 0x004fca0000000022ULL,
0x0000007200737306ULL, 0x0004e20000200c00ULL, 0x0000888078277816ULL, 0x042fe200000000ffULL,
0x0001000078787824ULL, 0x000fe200078e00ffULL, 0x0000000a6c30723cULL, 0x080f680000001830ULL,
0x00000018ff787819ULL, 0x000fe20000011478ULL, 0x0000007d007d7306ULL, 0x000fe20000200c00ULL,
0x0000010079727824ULL, 0x044fe400078e00ffULL, 0x0001000079797824ULL, 0x000fe200078e00ffULL,
0x0000000a2850723cULL, 0x000b640000001850ULL, 0x00000018ff727819ULL, 0x000fc40000011472ULL,
0x00000018ff797819ULL, 0x000fe20000011479ULL, 0x0000007000707306ULL, 0x000e620000200c00ULL,
0x00005410737c7816ULL, 0x008fe2000000007cULL, 0x00000010050a7824ULL, 0x020fe200078e0203ULL,
0x00000006284c723cULL, 0x000b64000000184cULL, 0x000000000404783bULL, 0x020ea60000000200ULL,
0x0000002300237306ULL, 0x000ef00000200c00ULL, 0x0000007e007e7306ULL, 0x000ee20000200c00ULL,
0x000054107d137816ULL, 0x002fce0000000070ULL, 0x0000002700277306ULL, 0x000fe20000200c00ULL,
0x0000541023127816ULL, 0x008fce0000000012ULL, 0x0000008000807306ULL, 0x000e620000200c00ULL,
0x000054107e7d7816ULL, 0x000fe2000000007fULL, 0x000000122854723cULL, 0x040f6c0000001854ULL,
0x0000008100817306ULL, 0x000fe40000200c00ULL, 0x0000007c2858723cULL, 0x000f6c0000001858ULL,
0x0000007200727306ULL, 0x000ee20000200c00ULL, 0x0000541027807816ULL, 0x002fe20000000080ULL,
0x000000126c34723cULL, 0x040f6c0000001834ULL, 0x0000007800787306ULL, 0x000e640000200c00ULL,
0x0000007c6c38723cULL, 0x000f6c0000001838ULL, 0x0000007900797306ULL, 0x000ea20000200c00ULL,
0x0000541081817816ULL, 0x008fce0000000072ULL, 0x0000008500857306ULL, 0x000fe20000200c00ULL,
0x0000541078787816ULL, 0x002fe20000000083ULL, 0x00000080285c723cULL, 0x080f6c000000185cULL,
0x0000008600867306ULL, 0x000e620000200c00ULL, 0x0000541079797816ULL, 0x004fe20000000084ULL,
0x000000806c3c723cULL, 0x000f6c000000183cULL, 0x0000008700877306ULL, 0x000fe40000200c00ULL,
0x000000782860723cULL, 0x080f6c0000001860ULL, 0x0000008900107306ULL, 0x000ea20000200c00ULL,
0x0000541085867816ULL, 0x002fe20000000086ULL, 0x000000786c40723cULL, 0x000f6c0000001840ULL,
0x0000007a00717306ULL, 0x000e700000200c00ULL, 0x0000007b007b7306ULL, 0x000ee20000200c00ULL,
0x0000541087877816ULL, 0x004fc40000000010ULL, 0x0000541071887816ULL, 0x002fca0000000088ULL,
0x000000862864723cULL, 0x000f620000001864ULL, 0x000054107b897816ULL, 0x008fce000000008aULL,
0x000000866c44723cULL, 0x000f700000001844ULL, 0x000000882868723cULL, 0x080b640000001868ULL,
0x000000000a28783bULL, 0x0202ac0000000200ULL, 0x000000886c48723cULL, 0x000b620000001848ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000000f28287232ULL, 0x084fe40000000000ULL, 0x0000000f2a2a7232ULL, 0x000fc40000000000ULL,
0x0000000e29297232ULL, 0x080fe40000000000ULL, 0x0000000e2b2b7232ULL, 0x000fe40000000000ULL,
0x0000000d04047232ULL, 0x080fe40000000000ULL, 0x0000000d06067232ULL, 0x000fe40000000000ULL,
0x0000000c05057232ULL, 0x080fe40000000000ULL, 0x0000000c07077232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000809037824ULL, 0x040fe200078e00ffULL,
0x00000000266c783bULL, 0x020ee20000004200ULL, 0x0000000109087824ULL, 0x000fca00078e0208ULL,
0xfffffff803087812ULL, 0x000fca00078ee208ULL, 0x0000001008087824ULL, 0x000fcc00078e0225ULL,
0x000000000808783bULL, 0x002e620000004200ULL, 0x00000018ff107819ULL, 0x008fe4000001146dULL,
0x00000018ff037819ULL, 0x000fe4000001146cULL, 0x0000001000257306ULL, 0x0007e20000200c00ULL,
0x00000018ff137819ULL, 0x000fe4000001146eULL, 0x00000018ff227819ULL, 0x000fe4000001146fULL,
0x000088806f717816ULL, 0x000fc600000000ffULL, 0x0000000300127306ULL, 0x0005e20000200c00ULL,
0x000001006c107824ULL, 0x008fe200078e00ffULL, 0x00000018ff237819ULL, 0x002fe20000011408ULL,
0x00000100087a7824ULL, 0x000fc600078e00ffULL, 0x00000018ff107819ULL, 0x000fe40000011410ULL,
0x0000001300727306ULL, 0x0003e20000200c00ULL, 0x000088806c037816ULL, 0x044fe200000000ffULL,
0x000100006c6c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe2000001140aULL,
0x000001000a807824ULL, 0x000fe200078e00ffULL, 0x00000018ff707819ULL, 0x000fe4000001140bULL,
0x00000018ff6c7819ULL, 0x000fe2000001146cULL, 0x00000023007c7306ULL, 0x0005e20000200c00ULL,
0x000001006d137824ULL, 0x002fe200078e00ffULL, 0x0000888008797816ULL, 0x040fe200000000ffULL,
0x0001000008087824ULL, 0x000fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fc40000011409ULL,
0x000088800a7f7816ULL, 0x040fe200000000ffULL, 0x000100000a0a7824ULL, 0x000fe200078e00ffULL,
0x0000000300037306ULL, 0x000fe20000200c00ULL, 0x00000018ff237819ULL, 0x004fe40000011413ULL,
0x00000018ff087819ULL, 0x000fe40000011408ULL, 0x000088800b817816ULL, 0x000fe400000000ffULL,
0x00008880097b7816ULL, 0x000fe200000000ffULL, 0x0000001000107306ULL, 0x000fe20000200c00ULL,
0x00000018ff7a7819ULL, 0x000fc4000001147aULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x00000018ff0a7819ULL, 0x000fc6000001140aULL, 0x0000006c00137306ULL, 0x0002b00000200c00ULL,
0x0000002200737306ULL, 0x0007e20000200c00ULL, 0x000001006f6c7824ULL, 0x042fe400078e00ffULL,
0x000100006f6f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe4000001146cULL,
0x0000002700837306ULL, 0x0003e20000200c00ULL, 0x000088806d227816ULL, 0x048fe200000000ffULL,
0x000100006d6d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x0000541013127816ULL, 0x004fe40000000012ULL, 0x00000018ff6d7819ULL, 0x000fe2000001146dULL,
0x0000007000847306ULL, 0x0005e20000200c00ULL, 0x000088806e277816ULL, 0x002fce00000000ffULL,
0x0000006f00787306ULL, 0x000e620000200c00ULL, 0x000001006e707824ULL, 0x044fe400078e00ffULL,
0x000100006e6e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff707819ULL, 0x000fe40000011470ULL,
0x00000018ff6e7819ULL, 0x000fe2000001146eULL, 0x00000026007d7306ULL, 0x000fe20000200c00ULL,
0x0000541078737816ULL, 0x002fce0000000073ULL, 0x00000008006f7306ULL, 0x0002b00000200c00ULL,
0x0000006d00267306ULL, 0x000ee20000200c00ULL, 0x0000541003087816ULL, 0x002fe20000000010ULL,
0x000001000b107824ULL, 0x000fc400078e00ffULL, 0x000100000b0b7824ULL, 0x000fe400078e00ffULL,
0x000000ffff037224ULL, 0x000fe200078e0081ULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000006e006d7306ULL, 0x0002e20000200c00ULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x000054106f7c7816ULL, 0x004fca000000007cULL, 0x0000002200227306ULL, 0x000fe20000200c00ULL,
0x00000100096e7824ULL, 0x042fe200078e00ffULL, 0x0000541026137816ULL, 0x008fe20000000025ULL,
0x0001000009097824ULL, 0x000fc600078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe4000001146eULL,
0x00000018ff097819ULL, 0x000fe20000011409ULL, 0x0000002300237306ULL, 0x000fe20000200c00ULL,
0x000054106d727816ULL, 0x000fe20000000072ULL, 0x000000122830723cULL, 0x040b6c0000001830ULL,
0x0000002700277306ULL, 0x000fe40000200c00ULL, 0x000000722838723cULL, 0x000b6c0000001838ULL,
0x0000007000707306ULL, 0x000e640000200c00ULL, 0x000000120450723cULL, 0x040b6c0000001850ULL,
0x0000007100717306ULL, 0x000fe40000200c00ULL, 0x000000720458723cULL, 0x000b6c0000001858ULL,
0x0000006c006c7306ULL, 0x000ea20000200c00ULL, 0x0000541027707816ULL, 0x002fce0000000070ULL,
0x0000007900797306ULL, 0x000ff00000200c00ULL, 0x0000007a007a7306ULL, 0x000e620000200c00ULL,
0x0000541071717816ULL, 0x004fce000000006cULL, 0x0000007b007b7306ULL, 0x000fe20000200c00ULL,
0x000000702834723cULL, 0x080b6e0000001834ULL, 0x0000006e006e7306ULL, 0x000ea20000200c00ULL,
0x00005410797a7816ULL, 0x002fe2000000007aULL, 0x000000700454723cULL, 0x000b6c0000001854ULL,
0x00000009007e7306ULL, 0x0002f00000200c00ULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x0000541022097816ULL, 0x002fc40000000023ULL, 0x000054107b7b7816ULL, 0x004fca000000006eULL,
0x0000008000807306ULL, 0x000e620000200c00ULL, 0x000054107e7d7816ULL, 0x008fe2000000007dULL,
0x00000008282c723cULL, 0x040b6c000000182cULL, 0x0000000a000a7306ULL, 0x000ea40000200c00ULL,
0x0000007a283c723cULL, 0x040b6c000000183cULL, 0x0000000300037306ULL, 0x000fe20000200c00ULL,
0x000054107f807816ULL, 0x002fe20000000080ULL, 0x0000007c2840723cULL, 0x000b6c0000001840ULL,
0x0000001000107306ULL, 0x000e620000200c00ULL, 0x000054100a0a7816ULL, 0x004fe20000000083ULL,
0x00000008044c723cULL, 0x040b6c000000184cULL, 0x0000000b000b7306ULL, 0x000ea40000200c00ULL,
0x0000007a045c723cULL, 0x000b62000000185cULL, 0x0000541003817816ULL, 0x002fce0000000010ULL,
0x0000007c0460723cULL, 0x000b620000001860ULL, 0x000054100b0b7816ULL, 0x004fce0000000084ULL,
0x000000802844723cULL, 0x040b700000001844ULL, 0x0000000a2848723cULL, 0x000b700000001848ULL,
0x000000800464723cULL, 0x040b700000001864ULL, 0x0000000a0468723cULL, 0x000b620000001868ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x0000000014047f8cULL, 0x0202a2000c80043fULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x000126a017067811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000006ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff037224ULL, 0x004fe200078e0005ULL, 0x0000001000002944ULL, 0x000fe20003c00000ULL,
0xffff506000007947ULL, 0x000fea000383ffffULL, 0x000000ff1c00720cULL, 0x000fda0003f05270ULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x0180000021007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000c9a000047802ULL, 0x000fc40000000f00ULL, 0x0000a79000007944ULL, 0x01efea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000002100007308ULL, 0x000ee40000001000ULL,
0xbf80000000027423ULL, 0x00afc80000000021ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000802037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000087919ULL, 0x000e680000000000ULL,
0x0000000000047919ULL, 0x000ea20000000000ULL, 0x0000001808057811ULL, 0x042fe400078ff0ffULL,
0x0000000808097811ULL, 0x000fc400078ff0ffULL, 0x00000002ff077819ULL, 0x004fe40000011604ULL,
0x00000010080b7811ULL, 0x000fe200078ff0ffULL, 0x0000000003067220ULL, 0x008fca0000410000ULL,
0x00001f0706007589ULL, 0x000e6800000e0000ULL, 0x00001f0506057589ULL, 0x000ea800000e0000ULL,
0x00001f0906047589ULL, 0x000ee800000e0000ULL, 0x00001f0b06027589ULL, 0x000ea200000e0000ULL,
0x0000002c002c7220ULL, 0x042fe20000410000ULL, 0x0000002d002d7220ULL, 0x040fe20000410000ULL,
0x0000003000307220ULL, 0x040fe20000410000ULL, 0x0000003100317220ULL, 0x040fe20000410000ULL,
0x0000003400347220ULL, 0x040fe20000410000ULL, 0x0000003500357220ULL, 0x040fe20000410000ULL,
0x0000003800387220ULL, 0x040fe20000410000ULL, 0x0000003900397220ULL, 0x040fe20000410000ULL,
0x0000003c003c7220ULL, 0x040fe20000410000ULL, 0x0000003d003d7220ULL, 0x040fe20000410000ULL,
0x0000004000407220ULL, 0x040fe20000410000ULL, 0x0000004100417220ULL, 0x040fe20000410000ULL,
0x0000004400447220ULL, 0x040fe20000410000ULL, 0x0000004500457220ULL, 0x040fe20000410000ULL,
0x0000004800487220ULL, 0x040fe20000410000ULL, 0x0000004900497220ULL, 0x000fe20000410000ULL,
0x0000004e054e7220ULL, 0x044fe20000410000ULL, 0x0000004f054f7220ULL, 0x040fe20000410000ULL,
0x0000005205527220ULL, 0x040fe20000410000ULL, 0x0000005305537220ULL, 0x040fe20000410000ULL,
0x0000005605567220ULL, 0x040fe20000410000ULL, 0x0000005705577220ULL, 0x040fe20000410000ULL,
0x0000005a055a7220ULL, 0x040fe20000410000ULL, 0x0000005b055b7220ULL, 0x040fe20000410000ULL,
0x0000005e055e7220ULL, 0x040fe20000410000ULL, 0x0000005f055f7220ULL, 0x040fe20000410000ULL,
0x0000006205627220ULL, 0x040fe20000410000ULL, 0x0000006305637220ULL, 0x040fe20000410000ULL,
0x0000006605667220ULL, 0x040fe20000410000ULL, 0x0000006705677220ULL, 0x040fe20000410000ULL,
0x0000006a056a7220ULL, 0x040fe20000410000ULL, 0x0000006b056b7220ULL, 0x000fe20000410000ULL,
0x000000042e2e7220ULL, 0x088fe20000410000ULL, 0x000000042f2f7220ULL, 0x080fe20000410000ULL,
0x0000000432327220ULL, 0x080fe20000410000ULL, 0x0000000433337220ULL, 0x080fe20000410000ULL,
0x0000000436367220ULL, 0x080fe20000410000ULL, 0x0000000437377220ULL, 0x080fe20000410000ULL,
0x000000043a3a7220ULL, 0x080fe20000410000ULL, 0x000000043b3b7220ULL, 0x080fe20000410000ULL,
0x000000043e3e7220ULL, 0x080fe20000410000ULL, 0x000000043f3f7220ULL, 0x080fe20000410000ULL,
0x0000000442427220ULL, 0x080fe20000410000ULL, 0x0000000443437220ULL, 0x080fe20000410000ULL,
0x0000000446467220ULL, 0x080fe20000410000ULL, 0x0000000447477220ULL, 0x080fe20000410000ULL,
0x000000044a4a7220ULL, 0x080fe20000410000ULL, 0x000000044b4b7220ULL, 0x000fe20000410000ULL,
0x000000024c4c7220ULL, 0x080fe20000410000ULL, 0x000000024d4d7220ULL, 0x080fe20000410000ULL,
0x0000000250507220ULL, 0x080fe20000410000ULL, 0x0000000251517220ULL, 0x080fe20000410000ULL,
0x0000000254547220ULL, 0x080fe20000410000ULL, 0x0000000255557220ULL, 0x080fe20000410000ULL,
0x0000000258587220ULL, 0x080fe20000410000ULL, 0x0000000259597220ULL, 0x080fe20000410000ULL,
0x000000025c5c7220ULL, 0x080fe20000410000ULL, 0x000000025d5d7220ULL, 0x080fe20000410000ULL,
0x0000000260607220ULL, 0x080fe20000410000ULL, 0x0000000261617220ULL, 0x080fe20000410000ULL,
0x0000000264647220ULL, 0x080fe20000410000ULL, 0x0000000265657220ULL, 0x080fe20000410000ULL,
0x0000000268687220ULL, 0x080fe20000410000ULL, 0x0000000269697220ULL, 0x000fc20000410000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x0000002e2f2e723eULL, 0x000fc400000000ffULL,
0x000000323317723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000363736723eULL, 0x000fe400000000ffULL, 0x0000003a3b1b723eULL, 0x000fe400000000ffULL,
0x0000003e3f3e723eULL, 0x000fc400000000ffULL, 0x00000042431f723eULL, 0x000fe400000000ffULL,
0x000000464746723eULL, 0x000fe400000000ffULL, 0x0000004a4b23723eULL, 0x000fe400000000ffULL,
0x000054102e167816ULL, 0x000fe40000000017ULL, 0x0000000800057811ULL, 0x048fe400078ff0ffULL,
0x0000000200027812ULL, 0x002fc400078ec0ffULL, 0x0000001800097811ULL, 0x000fe200078ff0ffULL,
0x00000008050a7824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x000fe400078ff8ffULL,
0x0000001000057811ULL, 0x000fe200078ff0ffULL, 0x0000000809147824ULL, 0x000fe200078e00ffULL,
0xfffffff80a0a7812ULL, 0x000fe400078ee203ULL, 0x00000002ff077819ULL, 0x004fe20000011600ULL,
0x0000000805127824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x000fc400078ff8ffULL,
0x0000000902057211ULL, 0x040fe200078ff8ffULL, 0x0000000807097824ULL, 0x040fe200078e00ffULL,
0x0000000702047211ULL, 0x000fe200078ff8ffULL, 0x00000008070e7824ULL, 0x040fe200078e00ffULL,
0xfffffff812127812ULL, 0x000fe200078ee203ULL, 0x0000200020037824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x0000000807057824ULL, 0x000fe200078e00ffULL,
0x0000000204027810ULL, 0x000fe40007ffe0ffULL, 0x0000200003037812ULL, 0x000fc400078ee2ffULL,
0xfffffff809087812ULL, 0x000fe400078ee202ULL, 0xfffffff805027812ULL, 0x000fe200078ee204ULL,
0x000010001a057824ULL, 0x000fe200078e0203ULL, 0x0000000404067810ULL, 0x040fe40007ffe0ffULL,
0x0000000604077810ULL, 0x000fe20007ffe0ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff8090c7812ULL, 0x000fe200078ee206ULL, 0x0000001002067824ULL, 0x000fe200078e0205ULL,
0xfffffff80e0e7812ULL, 0x000fe200078ee207ULL, 0x000000100a107824ULL, 0x100fe200078e0205ULL,
0x0000000804077812ULL, 0x000fe200078ec0ffULL, 0x00000010080a7824ULL, 0x100fe200078e0205ULL,
0x0000002c2d02723eULL, 0x000fe200000000ffULL, 0x0000001012127824ULL, 0x000fe200078e0205ULL,
0x000000303104723eULL, 0x000fe200000000ffULL, 0x0000000106087824ULL, 0x000fe200078e0207ULL,
0x000000404106723eULL, 0x000fe200000000ffULL, 0x0000001014147824ULL, 0x100fe200078e0205ULL,
0x0000541002187816ULL, 0x100fe20000000004ULL, 0x000000100c0c7824ULL, 0x100fe200078e0205ULL,
0x0000763202197816ULL, 0x000fe20000000004ULL, 0x000000100e0e7824ULL, 0x000fe200078e0205ULL,
0x000000343502723eULL, 0x000fe200000000ffULL, 0x0000000107107824ULL, 0x000fe200078e0210ULL,
0x000000383904723eULL, 0x000fe200000000ffULL, 0x0000001808007388ULL, 0x0003e20000000a00ULL,
0x0000003c3d05723eULL, 0x000fe200000000ffULL, 0x0000000107127824ULL, 0x000fe200078e0212ULL,
0x0000004c4d4c723eULL, 0x000fe200000000ffULL, 0x0000000107147824ULL, 0x000fe200078e0214ULL,
0x000000505126723eULL, 0x000fe200000000ffULL, 0x00000001070a7824ULL, 0x040fe200078e020aULL,
0x000076322e177816ULL, 0x000fe20000000017ULL, 0x00000001070c7824ULL, 0x000fe200078e020cULL,
0x000000545554723eULL, 0x000fe200000000ffULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x000000444507723eULL, 0x000fc400000000ffULL, 0x000000484908723eULL, 0x002fe400000000ffULL,
0x0000541002187816ULL, 0x140fe40000000004ULL, 0x0000763202197816ULL, 0x000fe40000000004ULL,
0x0000541005047816ULL, 0x140fe40000000006ULL, 0x0000763205057816ULL, 0x000fe20000000006ULL,
0x000000180a007388ULL, 0x000fe20000000a00ULL, 0x0000541007067816ULL, 0x000fc40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000000040c007388ULL, 0x0003e20000000a00ULL,
0x00000058592a723eULL, 0x000fe400000000ffULL, 0x000054103e1e7816ULL, 0x140fe2000000001fULL,
0x000000060e007388ULL, 0x0005e20000000a00ULL, 0x000076323e1f7816ULL, 0x000fe4000000001fULL,
0x0000541046227816ULL, 0x140fe20000000023ULL, 0x0000001610007388ULL, 0x0007e20000000a00ULL,
0x0000763246237816ULL, 0x000fc40000000023ULL, 0x0000541054087816ULL, 0x000fe4000000002aULL,
0x0000541036047816ULL, 0x142fe4000000001bULL, 0x0000763236057816ULL, 0x000fe4000000001bULL,
0x000054104c067816ULL, 0x144fe40000000026ULL, 0x000076324c077816ULL, 0x000fe20000000026ULL,
0x000400040a007388ULL, 0x0003e20000000a00ULL, 0x0000763254097816ULL, 0x000fc4000000002aULL,
0x0000005c5d5c723eULL, 0x000fe200000000ffULL, 0x0004001e0c007388ULL, 0x000fe20000000a00ULL,
0x000000606160723eULL, 0x000fe400000000ffULL, 0x000000646564723eULL, 0x000fe200000000ffULL,
0x000400220e007388ULL, 0x000fe20000000a00ULL, 0x000000686932723eULL, 0x000fe400000000ffULL,
0x0000004e4f02723eULL, 0x000fe200000000ffULL, 0x0000000612007388ULL, 0x0005e20000000a00ULL,
0x0000541064107816ULL, 0x008fc40000000032ULL, 0x0000763264117816ULL, 0x000fe20000000032ULL,
0x000800080a007388ULL, 0x0007e20000000a00ULL, 0x000000525304723eULL, 0x002fe400000000ffULL,
0x000000565705723eULL, 0x000fe400000000ffULL, 0x000000ff1a00720cULL, 0x000fe40003f05270ULL,
0x0000005a5b06723eULL, 0x004fe400000000ffULL, 0x000000666707723eULL, 0x000fc400000000ffULL,
0x000054105c087816ULL, 0x148fe40000000060ULL, 0x000076325c097816ULL, 0x000fca0000000060ULL,
0x000800080c007388ULL, 0x0003e80000000a00ULL, 0x000800100e007388ULL, 0x0005e20000000a00ULL,
0x0000006a6b08723eULL, 0x002fe400000000ffULL, 0x0000541002107816ULL, 0x144fe40000000004ULL,
0x0000763202117816ULL, 0x000fe40000000004ULL, 0x0000005e5f02723eULL, 0x000fc400000000ffULL,
0x000000626304723eULL, 0x000fe200000000ffULL, 0x0000001014007388ULL, 0x0003e20000000a00ULL,
0x0000541007227816ULL, 0x000fe40000000008ULL, 0x0000541002187816ULL, 0x140fe40000000004ULL,
0x0000763202197816ULL, 0x000fe20000000004ULL, 0x0000000177027824ULL, 0x000fe200078e0200ULL,
0x0000763207237816ULL, 0x000fc60000000008ULL, 0x0000001002027824ULL, 0x000fe200078e0203ULL,
0x0000541005107816ULL, 0x142fe40000000006ULL, 0x0000763205117816ULL, 0x000fca0000000006ULL,
0x000c00100a007388ULL, 0x000fe80000000a00ULL, 0x000c00180c007388ULL, 0x000fe80000000a00ULL,
0x000c00220e007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000002047984ULL, 0x000e680000000c00ULL, 0x0004000002107984ULL, 0x000ea80000000c00ULL,
0x00080000021c7984ULL, 0x000ee80000000c00ULL, 0x000c000002287984ULL, 0x000ee80000000c00ULL,
0x0010000002087984ULL, 0x000ee80000000c00ULL, 0x0014000002147984ULL, 0x000ee80000000c00ULL,
0x0018000002247984ULL, 0x010ee80000000c00ULL, 0x001c0000022c7984ULL, 0x000ee20000000c00ULL,
0x200000ff07077230ULL, 0x002fc40000000000ULL, 0x200000ff06067230ULL, 0x000fe40000000000ULL,
0x200000ff05057230ULL, 0x000fe40000000000ULL, 0x200000ff04047230ULL, 0x000fe40000000000ULL,
0x200000ff13137230ULL, 0x004fe40000000000ULL, 0x200000ff12127230ULL, 0x000fe40000000000ULL,
0x200000ff11117230ULL, 0x000fc40000000000ULL, 0x200000ff10107230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x008fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fe40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff2b2b7230ULL, 0x000fc40000000000ULL, 0x200000ff2a2a7230ULL, 0x000fe40000000000ULL,
0x200000ff29297230ULL, 0x000fe40000000000ULL, 0x200000ff28287230ULL, 0x000fe40000000000ULL,
0x0000000b07077230ULL, 0x000fe40000000000ULL, 0x0000000a06067230ULL, 0x000fe40000000000ULL,
0x0000000905057230ULL, 0x000fc40000000000ULL, 0x0000000804047230ULL, 0x000fe40000000000ULL,
0x0000001713137230ULL, 0x000fe40000000000ULL, 0x0000001612127230ULL, 0x000fe20000000000ULL,
0x0000000402007388ULL, 0x000fe20000000c00ULL, 0x0000001511117230ULL, 0x000fe40000000000ULL,
0x0000001410107230ULL, 0x000fe40000000000ULL, 0x000000271f1f7230ULL, 0x000fc40000000000ULL,
0x000000261e1e7230ULL, 0x000fe20000000000ULL, 0x0004001002007388ULL, 0x000fe20000000c00ULL,
0x000000251d1d7230ULL, 0x000fe40000000000ULL, 0x000000241c1c7230ULL, 0x000fe40000000000ULL,
0x0000002f2b2b7230ULL, 0x000fe40000000000ULL, 0x0000002e2a2a7230ULL, 0x000fe20000000000ULL,
0x0008001c02007388ULL, 0x000fe20000000c00ULL, 0x0000002d29297230ULL, 0x000fc40000000000ULL,
0x0000002c28287230ULL, 0x000fca0000000000ULL, 0x000c002802007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x000fc80000011600ULL, 0x000000740700720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107027824ULL, 0x100fe200078e0200ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x0000000120117812ULL, 0x000fe200078ec0ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000000702057812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x00000007000e7812ULL, 0x000fe400078ec0ffULL, 0x0ffffff805027812ULL, 0x000fe200078ef800ULL,
0x0000580000067ab9ULL, 0x000fc80000000800ULL, 0x0000001002047824ULL, 0x000fe400078e0203ULL,
0x0000002076027824ULL, 0x000fe400078e0207ULL, 0x0000000811077824ULL, 0x000fe200078e020eULL,
0x0000000004087984ULL, 0x0004e40000000c00ULL, 0x0000000502067c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff057a19ULL, 0x000fe20000011602ULL, 0x00000006040472a4ULL, 0x002fc4000f8e023fULL,
0x0000000175067824ULL, 0x000fc800078e0206ULL, 0x0000008205057224ULL, 0x000fe200078e0206ULL,
0x0000002000067810ULL, 0x000fe20007ffe0ffULL, 0x0000000482027c24ULL, 0x000fc6000f8e02ffULL,
0x00000003ff0d7819ULL, 0x000fe40000011606ULL, 0x0000000502057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x004fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440cULL, 0x000000740d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0083ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x102fe200078e020dULL,
0x00000040000c7810ULL, 0x000fe20007ffe0ffULL, 0x00000020760d7824ULL, 0x000fc600078e020dULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef806ULL,
0x0000000706067812ULL, 0x000fc600078ec0ffULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x000000050d047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000820d0d7224ULL, 0x000fe400078e0204ULL, 0x0000000811077824ULL, 0x002fc600078e0206ULL,
0x0000000d020d7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c000d047a11ULL, 0x000fc800078040ffULL, 0x00005d000d057a11ULL, 0x000fe400000f440eULL,
0x00000003ff0d7819ULL, 0x000fc6000001160cULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000740d00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0043f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c047824ULL, 0x102fe400078e020dULL,
0x00000020760d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050d047c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000820d0d7224ULL, 0x000fca00078e0204ULL, 0x0000000d02057210ULL, 0x000fe40007f1e0ffULL,
0x00000060000d7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x040fe400078040ffULL, 0x00000003ff0f7819ULL, 0x000fe4000001160dULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000740f00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d047824ULL, 0x102fe200078e020fULL,
0x0000008000077810ULL, 0x000fe20007ffe0ffULL, 0x00000020760f7824ULL, 0x000fc600078e020fULL,
0x0000000704047812ULL, 0x000fc800078ec0ffULL, 0x0ffffff804047812ULL, 0x000fe400078ef80dULL,
0x000000070d0d7812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050f047c12ULL, 0x000fe2000f8e30ffULL, 0x00000008110d7824ULL, 0x000fe200078e020dULL,
0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000175047824ULL, 0x000fc800078e0204ULL, 0x000000820f0f7224ULL, 0x000fca00078e0204ULL,
0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c000f047a11ULL, 0x000fc800078040ffULL, 0x00005d000f057a11ULL, 0x000fe400000f440cULL,
0x00000003ff0f7819ULL, 0x000fc60000011607ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x000000740f00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0023f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107047824ULL, 0x102fe200078e020fULL,
0x000000a0000c7810ULL, 0x000fe20007ffe0ffULL, 0x00000020760f7824ULL, 0x000fc600078e020fULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x00000003ff0d7819ULL, 0x000fe4000001160cULL,
0x0ffffff804047812ULL, 0x000fe400078ef807ULL, 0x0000000707077812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050f047c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e0207ULL, 0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000820f0f7224ULL, 0x000fca00078e0204ULL, 0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c000f047a11ULL, 0x000fc800078040ffULL,
0x00005d000f057a11ULL, 0x000fe400000f440eULL, 0x000000740d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c047824ULL, 0x102fe400078e020dULL,
0x00000020760d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050d047c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000820d0d7224ULL, 0x000fca00078e0204ULL, 0x0000000d02057210ULL, 0x000fe40007f1e0ffULL,
0x000000c0000d7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x040fe400078040ffULL, 0x00000003ff0f7819ULL, 0x000fe4000001160dULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000740f00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d047824ULL, 0x102fe200078e020fULL,
0x000000e000007810ULL, 0x000fe20007ffe0ffULL, 0x00000020760f7824ULL, 0x000fc600078e020fULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x00000003ff077819ULL, 0x000fe40000011600ULL,
0x0ffffff804047812ULL, 0x000fe400078ef80dULL, 0x000000070d0d7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050f047c12ULL, 0x000fe2000f8e30ffULL,
0x00000008110d7824ULL, 0x000fe200078e020dULL, 0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x000000820f0f7224ULL, 0x000fe400078e0204ULL, 0x0000000100067824ULL, 0x002fc600078e0207ULL,
0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c000f047a11ULL, 0x000fc800078040ffULL, 0x00005d000f057a11ULL, 0x000fe400000f440cULL,
0x000000740700720cULL, 0x000fc60003f06070ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x00000007060d7812ULL, 0x000fc800078ec0ffULL, 0xfffffff80d067812ULL, 0x000fe200078ef800ULL,
0x0000000804007986ULL, 0x0043e8000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001006067824ULL, 0x000fe200078e0203ULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x0000002076077824ULL, 0x000fc600078e0207ULL, 0x0000000006087984ULL, 0x002e620000000c00ULL,
0x0000000811057824ULL, 0x000fe200078e0200ULL, 0x0000000507047c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff077a19ULL, 0x000fc60000011607ULL, 0x0000000175047824ULL, 0x000fc800078e0204ULL,
0x0000008207077224ULL, 0x000fca00078e0204ULL, 0x0000000702077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005c0007027a11ULL, 0x000fc800078040ffULL,
0x00005d0007037a11ULL, 0x000fca00000f4404ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff607819ULL, 0x000fe20000011620ULL, 0xffffffffff217424ULL, 0x000fc600078e00ffULL,
0x0000001d6000720cULL, 0x000fda0003f06070ULL, 0x0000000204038824ULL, 0x000fc800078e00ffULL,
0x0000680003088a24ULL, 0x000fc800078e0260ULL, 0x0000640008088625ULL, 0x000fe200078e0009ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006c00ff687624ULL, 0x000fe200078e00ffULL,
0x0000000808218981ULL, 0x000ea2000c1e1900ULL, 0x00006d00ff697624ULL, 0x000fc600078e00ffULL,
0x01260000ff067f8cULL, 0x002e68000c80043fULL, 0x0000000868687981ULL, 0x000722000c1e9900ULL,
0x000001ff0a00780cULL, 0x000fe20003f04070ULL, 0x0000008019227824ULL, 0x000fe400078e00ffULL,
0x0000004020037824ULL, 0x000fe400078e00ffULL, 0x000000800e027824ULL, 0x000fc600078e00ffULL,
0x0000004022167812ULL, 0x000fe200078ef803ULL, 0x0000000221277224ULL, 0x004fc800078e02ffULL,
0x0000062000000947ULL, 0x000fea0003800000ULL, 0x00000002ff247819ULL, 0x00afe4000001161fULL,
0x0000620027257a11ULL, 0x040fe400078038ffULL, 0x0000000824137810ULL, 0x000fe20007ffe0ffULL,
0x0000000116087824ULL, 0x000fe200078e0224ULL, 0x0000001024267810ULL, 0x040fe40007ffe0ffULL,
0x0000001824287810ULL, 0x000fe20007ffe0ffULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x0000630027277a11ULL, 0x000fc400000f3cffULL, 0x0000002024197810ULL, 0x000fe20007ffe0ffULL,
0x00000001160a7824ULL, 0x000fe200078e0213ULL, 0x0000003008107812ULL, 0x100fe200078ef805ULL,
0x00000001160c7824ULL, 0x000fe200078e0226ULL, 0x000000031e087217ULL, 0x000fe20007800000ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000001025107210ULL, 0x000fe40007f1e0ffULL,
0x0000001f1f127211ULL, 0x000fe200078fe8ffULL, 0x00000001160e7824ULL, 0x000fe200078e0228ULL,
0x000000300a0a7812ULL, 0x000fe200078ef805ULL, 0x0000000109117824ULL, 0x000fe200000e0627ULL,
0x0000000312187812ULL, 0x000fe200078ec0ffULL, 0x0000000116097824ULL, 0x000fe200078e0219ULL,
0x000000250a0a7210ULL, 0x000fe20007f3e0ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x00000028241b7810ULL, 0x000fc40007ffe0ffULL, 0x00002000201a7811ULL, 0x000fe200078e68ffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000300c0c7812ULL, 0x000fe400078ef805ULL,
0x0ffffffc181f7812ULL, 0x000fe200078ef81fULL, 0x0000000108157824ULL, 0x000fe200078e0a03ULL,
0x000000300e0e7812ULL, 0x000fe200078ef805ULL, 0x0000008009087825ULL, 0x000fe200078e00ffULL,
0x000000250c0c7210ULL, 0x080fe40007f1e0ffULL, 0x0000003024237810ULL, 0x000fe20007ffe0ffULL,
0x000000010b0b7824ULL, 0x000fe200008e0627ULL, 0x0000003008127812ULL, 0x000fe200078ef805ULL,
0x0000000116087824ULL, 0x000fe200078e021bULL, 0x000000250e0e7210ULL, 0x080fe20007f3e0ffULL,
0x000000010d0d7824ULL, 0x100fe200000e0627ULL, 0x0000002512127210ULL, 0x000fe20007f5e0ffULL,
0x0000000413177824ULL, 0x000fe200078e00ffULL, 0x000000152400720cULL, 0x080fe20003f06070ULL,
0x000000010f0f7824ULL, 0x100fe200008e0627ULL, 0x000000151300720cULL, 0x000fe20003f26070ULL,
0x0000000109137824ULL, 0x000fe200010e0627ULL, 0xfffffffc17177812ULL, 0x000fe200078ee218ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000003824247810ULL, 0x000fc40007ffe0ffULL,
0x000000152600720cULL, 0x080fe20003fa6070ULL, 0x000000101f1f7824ULL, 0x100fe200078e021aULL,
0x0000003008147812ULL, 0x000fe200078ef805ULL, 0x0000001017177824ULL, 0x000fe200078e021aULL,
0x000000152800720cULL, 0x000fe20003f86070ULL, 0x0000000116087824ULL, 0x000fe200078e0223ULL,
0x0000002514147210ULL, 0x000fe20007fde0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101f7faeULL, 0x0003e2000c101c48ULL, 0x000000151900720cULL, 0x0c0fe20003f66070ULL,
0x0000000419197824ULL, 0x000fe200078e00ffULL, 0x000000151b00720cULL, 0x080fe20003f46070ULL,
0x000000000a177faeULL, 0x0005e2000c901c48ULL, 0x000000152300720cULL, 0x080fe20003f26070ULL,
0x000000041b1b7824ULL, 0x000fe200078e00ffULL, 0x000000152400720cULL, 0x000fe20003f06070ULL,
0x0000000109157824ULL, 0x000fe200030e0627ULL, 0xfffffffc19197812ULL, 0x100fe200078ee218ULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0xfffffffc1b1b7812ULL, 0x000fc600078ee218ULL,
0x0000000426117824ULL, 0x002fe200078e00ffULL, 0x0000003008087812ULL, 0x100fe200078ef805ULL,
0x00000001160a7824ULL, 0x004fe400078e0224ULL, 0x0000000428177824ULL, 0x000fe200078e00ffULL,
0x0000002508087210ULL, 0x000fe20007fde0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffffc11117812ULL, 0x100fe400078ee218ULL, 0xfffffffc17177812ULL, 0x000fe200078ee218ULL,
0x0000000423237824ULL, 0x000fe200078e00ffULL, 0x000000300a0a7812ULL, 0x000fe200078ef805ULL,
0x00000004241f7824ULL, 0x000fc400078e00ffULL, 0x0000000109097824ULL, 0x000fe200030e0627ULL,
0xfffffffc23057812ULL, 0x000fe200078ee218ULL, 0x0000001011117824ULL, 0x000fe200078e021aULL,
0xfffffffc1f1f7812ULL, 0x000fe200078ee218ULL, 0x0000001017177824ULL, 0x100fe200078e021aULL,
0x000000250a0a7210ULL, 0x000fe20007fde0ffULL, 0x0000001019197824ULL, 0x100fe200078e021aULL,
0x000000000c117faeULL, 0x0003e2000e901c48ULL, 0x000000101b1b7824ULL, 0x100fe400078e021aULL,
0x0000001005057824ULL, 0x100fe200078e021aULL, 0x000000000e177faeULL, 0x0003e2000e101c48ULL,
0x000000101f1f7824ULL, 0x000fc400078e021aULL, 0x000000010b0b7824ULL, 0x000fe200030e0627ULL,
0x0000000012197faeULL, 0x0003e8000d901c48ULL, 0x00000000141b7faeULL, 0x0003e8000d101c48ULL,
0x0000000008057faeULL, 0x0003e8000c901c48ULL, 0x000000000a1f7faeULL, 0x0003e2000c101c48ULL,
0x0000056000007947ULL, 0x000fea0003800000ULL, 0x000000201f097811ULL, 0x04afe400078ff0ffULL,
0x000000161f087211ULL, 0x000fc400078ff0ffULL, 0x000000181f157811ULL, 0x040fe200078ff0ffULL,
0x0000000116107824ULL, 0x000fe200078e0209ULL, 0x000000381f0f7811ULL, 0x000fe200078ff0ffULL,
0x0000000409197824ULL, 0x000fe200078e00ffULL, 0x0000001f1f0a7211ULL, 0x040fe200078fe8ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000000081f117811ULL, 0x040fe400078ff0ffULL,
0x000000101f137811ULL, 0x000fe200078ff0ffULL, 0x0000000415177824ULL, 0x000fe200078e00ffULL,
0x000000281f0b7811ULL, 0x040fe200078ff0ffULL, 0x00000001160e7824ULL, 0x000fe200078e0215ULL,
0x000000301f0d7811ULL, 0x000fe200078ff0ffULL, 0x000000040f257824ULL, 0x000fe200078e00ffULL,
0x000000030a187812ULL, 0x000fe200078ec0ffULL, 0x00000001160a7824ULL, 0x040fe200078e0211ULL,
0x00006200272b7a11ULL, 0x040fe200078038ffULL, 0x00000001160c7824ULL, 0x000fe200078e0213ULL,
0x00002000201a7811ULL, 0x000fe200078e68ffULL, 0x0000000116127824ULL, 0x040fe200078e020bULL,
0x00006300272d7a11ULL, 0x000fe200000f3cffULL, 0x0000000116147824ULL, 0x000fe200078e020dULL,
0x0ffffffc181f7812ULL, 0x000fe200078ef81fULL, 0x000000040d237824ULL, 0x000fc400078e00ffULL,
0x0000000116157824ULL, 0x000fe200078e020fULL, 0x0000003008167812ULL, 0x000fe200078ef805ULL,
0x0000000411117824ULL, 0x000fe200078e00ffULL, 0xfffffffc170f7812ULL, 0x100fe200078ee218ULL,
0x0000000413137824ULL, 0x000fe200078e00ffULL, 0xfffffffc25177812ULL, 0x100fe200078ee218ULL,
0x000000040b1b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc23087812ULL, 0x000fe200078ee218ULL,
0x000000101f2f7824ULL, 0x100fe200078e021aULL, 0x000000162b167210ULL, 0x000fe20007f1e0ffULL,
0x0000001017297824ULL, 0x000fe200078e021aULL, 0xfffffffc110b7812ULL, 0x000fe200078ee218ULL,
0x0000001008277824ULL, 0x000fe200078e021aULL, 0xfffffffc130d7812ULL, 0x100fe200078ee218ULL,
0x0000000109177824ULL, 0x000fe200000e062dULL, 0xfffffffc19117812ULL, 0x000fe200078ee218ULL,
0x000000100b197824ULL, 0x000fe200078e021aULL, 0xfffffffc1b137812ULL, 0x000fe200078ee218ULL,
0x000000800a087825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000162f7faeULL, 0x0003e6000b901c48ULL, 0x000000100d1b7824ULL, 0x000fe200078e021aULL,
0x0000003008087812ULL, 0x000fe200078ef805ULL, 0x000000800c0a7825ULL, 0x000fc600078e00ffULL,
0x000000082b087210ULL, 0x000fe20007f1e0ffULL, 0x000000100f1f7824ULL, 0x000fe200078e021aULL,
0x000000300a0a7812ULL, 0x000fe200078ef805ULL, 0x000000800e0c7825ULL, 0x000fc600078e00ffULL,
0x0000000a2b0a7210ULL, 0x000fe20007f3e0ffULL, 0x0000001011237824ULL, 0x000fe200078e021aULL,
0x000000300c0c7812ULL, 0x000fe200078ef805ULL, 0x00000080100e7825ULL, 0x000fc600078e00ffULL,
0x0000000c2b0c7210ULL, 0x000fe20007f5e0ffULL, 0x0000001013257824ULL, 0x000fe200078e021aULL,
0x000000300e0e7812ULL, 0x000fe200078ef805ULL, 0x0000008012107825ULL, 0x000fc600078e00ffULL,
0x0000000e2b0e7210ULL, 0x000fe20007f7e0ffULL, 0x0000008014127825ULL, 0x000fe200078e00ffULL,
0x0000003010107812ULL, 0x000fc600078ef805ULL, 0x0000008015147825ULL, 0x000fe200078e00ffULL,
0x0000003012127812ULL, 0x000fe400078ef805ULL, 0x000000102b107210ULL, 0x000fe20007f9e0ffULL,
0x0000000109097824ULL, 0x000fe200000e062dULL, 0x0000003014057812ULL, 0x000fe200078ef805ULL,
0x000000010b0b7824ULL, 0x100fe200008e062dULL, 0x000000122b127210ULL, 0x000fe20007fbe0ffULL,
0x000000010d0d7824ULL, 0x100fe200010e062dULL, 0x000000052b147210ULL, 0x000fe20007fde0ffULL,
0x000000010f0f7824ULL, 0x100fe200018e062dULL, 0x0000000008197faeULL, 0x0003e2000b901c48ULL,
0x0000000111117824ULL, 0x000fc400020e062dULL, 0x0000000113137824ULL, 0x100fe200028e062dULL,
0x000000000a1b7faeULL, 0x0003e2000b901c48ULL, 0x0000000115157824ULL, 0x000fc600030e062dULL,
0x000000000c1f7faeULL, 0x0003e8000b901c48ULL, 0x000000000e237faeULL, 0x0003e8000b901c48ULL,
0x0000000010257faeULL, 0x0003e8000b901c48ULL, 0x0000000012277faeULL, 0x0003e8000b901c48ULL,
0x0000000014297faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000087805ULL, 0x002fc40000015200ULL, 0x01260400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fc40007804807ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fcc0000015200ULL,
0x0000000a080a7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e09ULL,
0x003d09000a00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400a00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff057819ULL, 0x000fc8000001140bULL, 0x0000000a05057211ULL, 0x000fca00078110ffULL,
0x000000ffff0a7224ULL, 0x000fca00000e060bULL, 0x0000000205057819ULL, 0x000fc8000000120aULL,
0x000000050000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01260400ff057984ULL, 0x000e640000000800ULL, 0x8000000005ff7812ULL, 0x002fe40007804807ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000057919ULL, 0x000e640000000000ULL,
0x0000002020057824ULL, 0x002fca00078e0205ULL, 0x00000004ff067819ULL, 0x000fe40000011605ULL,
0x0000000105077810ULL, 0x040fe40007ffe0ffULL, 0x0ffffffe06087812ULL, 0x000fe400078ec0ffULL,
0x0000001f05067812ULL, 0x000fc600078ec0ffULL, 0x00000001080a7824ULL, 0x040fe400078e0207ULL,
0x0000000105097824ULL, 0x000fe200078e0208ULL, 0x0000000808087810ULL, 0x000fe20007ffe0ffULL,
0x00000010060b7824ULL, 0x000fe200078e00ffULL, 0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL,
0x00000010060c7824ULL, 0x000fe200078e00ffULL, 0x0000000f09097812ULL, 0x000fe200078ec0ffULL,
0x0000000107077824ULL, 0x000fe200078e0208ULL, 0x000001f00b0a7812ULL, 0x000fe200078ee20aULL,
0x0000000105057824ULL, 0x000fe200078e0208ULL, 0x000001f00c097812ULL, 0x000fe200078ee209ULL,
0x0000001006087824ULL, 0x040fe200078e00ffULL, 0x0000000f07077812ULL, 0x000fe200078ec0ffULL,
0x000000000a0c7984ULL, 0x000e62000000cc00ULL, 0x0000001006067824ULL, 0x000fe200078e00ffULL,
0x0000000f05057812ULL, 0x000fc400078ec0ffULL, 0x0000000009107984ULL, 0x000ea4000000cc00ULL,
0x000001f006077812ULL, 0x000fe400078ee207ULL, 0x000001f008057812ULL, 0x000fe200078ee205ULL,
0x000000ffff167224ULL, 0x002fe400078e000cULL, 0x000000ffff177224ULL, 0x000fe400078e000eULL,
0x000000ffff147224ULL, 0x004fe400078e0010ULL, 0x000000ffff157224ULL, 0x000fc400078e0012ULL,
0x000000ffff1a7224ULL, 0x000fe400078e000dULL, 0x000000ffff1b7224ULL, 0x000fe200078e000fULL,
0x0000001409007388ULL, 0x000fe2000000cc00ULL, 0x000000ffff187224ULL, 0x000fe400078e0011ULL,
0x000000ffff197224ULL, 0x000fca00078e0013ULL, 0x000000180a007388ULL, 0x000fe8000000cc00ULL,
0x00000000070c7984ULL, 0x000e68000000cc00ULL, 0x0000000005107984ULL, 0x000ea2000000cc00ULL,
0x000000ffff277224ULL, 0x002fe400078e000eULL, 0x000000ffff267224ULL, 0x000fc400078e000cULL,
0x000000ffff0e7224ULL, 0x000fe400078e000dULL, 0x000000ffff247224ULL, 0x004fe400078e0010ULL,
0x000000ffff257224ULL, 0x000fe400078e0012ULL, 0x000000ffff0c7224ULL, 0x000fe400078e0011ULL,
0x000000ffff0d7224ULL, 0x000fe200078e0013ULL, 0x0000002405007388ULL, 0x0003e8000000cc00ULL,
0x0000000c07007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01260000ff0a7f8cULL, 0x000ea2000c80043fULL, 0x000000ffff0c7224ULL, 0x002fc600078e00ffULL,
0x0000000000067805ULL, 0x000fc80000015200ULL, 0x01260400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x006fc4000780480bULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000087805ULL, 0x000fcc0000015200ULL, 0x0000000806087210ULL, 0x000fca0007f1e1ffULL,
0x0000000109097824ULL, 0x000fe200000e0e07ULL, 0x003d09000800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff057819ULL, 0x000fc80000011409ULL,
0x0000000805057211ULL, 0x000fca00078110ffULL, 0x000000ffff087224ULL, 0x000fca00000e0609ULL,
0x0000000205057819ULL, 0x000fc80000001208ULL, 0x000000050000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01260400ff057984ULL, 0x000e640000000800ULL,
0x8000000005ff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff1c00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x00000000001f7919ULL, 0x000e620000000000ULL, 0x00005800ff627624ULL, 0x000fe200078e00ffULL,
0x800058001e617a10ULL, 0x000fe20007ffe0ffULL, 0x0000680004697a24ULL, 0x000fe200078e02ffULL,
0x3db504f368687820ULL, 0x010fe20000410000ULL, 0x0001268820677811ULL, 0x000fe200078e18ffULL,
0x0000000000647805ULL, 0x000fe2000001ff00ULL, 0x0000001f62047810ULL, 0x040fe40007ffe0ffULL,
0xffffffff62637810ULL, 0x000fe40007ffe0ffULL, 0x00000004ff047819ULL, 0x000fc40000011604ULL,
0x0001260820667811ULL, 0x000fe400078e28ffULL, 0x0000000962627810ULL, 0x000fe40007ffe0ffULL,
0x00000008ff617819ULL, 0x000fe40000011661ULL, 0x0ffffffe04237812ULL, 0x000fc400078ec0ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x000000ffff6b7224ULL, 0x000fe200078e0065ULL,
0x00000000000e7805ULL, 0x008fe2000001ff00ULL, 0x000000ffff6a7224ULL, 0x000fe200078e00ffULL,
0x00000000000c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000127805ULL, 0x000fe2000001ff00ULL,
0x0000000000107805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x0000000000167805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000000a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000087805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000004e7805ULL, 0x000fe2000001ff00ULL,
0x00000000004c7805ULL, 0x014fc4000001ff00ULL, 0x000000016a00780cULL, 0x000fe20003f25270ULL,
0x00000c2000007945ULL, 0x000fe20003800000ULL, 0x0000000164047810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff6c7224ULL, 0x000fe200078e006aULL, 0x000000016a057810ULL, 0x000fe20007ffe0ffULL,
0x00000002216e7224ULL, 0x010fe200078e02ffULL, 0x000000016b657812ULL, 0x000fc400078e0cffULL,
0x000000020500780cULL, 0x000fe20003f06070ULL, 0x000000ffff6a7224ULL, 0x000fc800078e0005ULL,
0x000000ffff041224ULL, 0x000fc800078e0264ULL, 0x0000010004067824ULL, 0x040fe200078e0203ULL,
0x0000000104077810ULL, 0x000fe40007ffe0ffULL, 0x000000ff05047207ULL, 0x000fe40000800000ULL,
0x0000001c0700720cULL, 0x000fe40003f46070ULL, 0x0000004006077812ULL, 0x000fca00078ec0ffULL,
0x00000001225e7824ULL, 0x020fcc00078e0207ULL, 0x000005f00000a947ULL, 0x000fea0003800000ULL,
0x000000101f077824ULL, 0x002fe200078e00ffULL, 0x000000061e057217ULL, 0x000fe20007800000ULL,
0x00000002205c7824ULL, 0x000fe200078e0265ULL, 0x00000002ff707819ULL, 0x000fe4000001161fULL,
0x0000003007077812ULL, 0x000fe200078ec0ffULL, 0x0000000105057824ULL, 0x000fe200078e0a06ULL,
0x0000001870727810ULL, 0x040fe20007ffe0ffULL, 0x0000000170517824ULL, 0x140fe200078e025eULL,
0x00000008705a7810ULL, 0x000fe20007ffe0ffULL, 0x0000004004067824ULL, 0x000fe200078e0207ULL,
0x000062006e6f7a11ULL, 0x000fe200078238ffULL, 0x000000ffff077224ULL, 0x000fe200078e00ffULL,
0x00000010705b7810ULL, 0x000fe20007ffe0ffULL, 0x0000000172577824ULL, 0x000fe200078e025eULL,
0x000063006e717a11ULL, 0x000fe200008f3cffULL, 0x0000008051507825ULL, 0x000fe200078e0006ULL,
0x0000002070737810ULL, 0x000fc40007ffe0ffULL, 0x000020005c5c7811ULL, 0x000fe200078e60ffULL,
0x000000015a537824ULL, 0x000fe200078e025eULL, 0x0000006f50587210ULL, 0x000fe20007f3e0ffULL,
0x0000008057567825ULL, 0x000fe200078e0006ULL, 0x0000001f1f507211ULL, 0x000fe400078fe8ffULL,
0x0000002870747810ULL, 0x000fe20007ffe0ffULL, 0x000000015e557824ULL, 0x000fe200078e025bULL,
0x00000003506e7812ULL, 0x000fe200078ec0ffULL, 0x0000008053527825ULL, 0x000fe200078e0006ULL,
0x0000003070757810ULL, 0x000fc40007ffe0ffULL, 0x0ffffffc6e5d7812ULL, 0x000fe200078ef81fULL,
0x0000000151597824ULL, 0x000fe200008e0671ULL, 0x0000006f56567210ULL, 0x080fe20007f3e0ffULL,
0x0000000173517824ULL, 0x000fe200078e025eULL, 0x0000006f52527210ULL, 0x000fe20007f5e0ffULL,
0x0000008055547825ULL, 0x000fe200078e0006ULL, 0x000000057200720cULL, 0x000fc60003fa6070ULL,
0x0000008051507825ULL, 0x000fe200078e0006ULL, 0x0000006f54547210ULL, 0x000fc60007f7e0ffULL,
0x0000000157577824ULL, 0x100fe200008e0671ULL, 0x000000057000720cULL, 0x080fe20003f26070ULL,
0x0000000153537824ULL, 0x100fe200010e0671ULL, 0x000000055a00720cULL, 0x040fe20003f46070ULL,
0x000000045a5f7824ULL, 0x000fe200078e00ffULL, 0x0000006f505a7210ULL, 0x000fe20007f9e0ffULL,
0x000000045b6d7824ULL, 0x000fe200078e00ffULL, 0x0000003870707810ULL, 0x000fe20007ffe0ffULL,
0x0000000155557824ULL, 0x100fe200018e0671ULL, 0x000000055b00720cULL, 0x080fe20003f66070ULL,
0x00000001515b7824ULL, 0x000fe200020e0671ULL, 0xfffffffc5f5f7812ULL, 0x000fe200078ee26eULL,
0x000000105d5d7824ULL, 0x000fe200078e025cULL, 0xfffffffc6d6d7812ULL, 0x000fe200078ee26eULL,
0x0000000174517824ULL, 0x000fe200078e025eULL, 0x000000057300720cULL, 0x080fe20003f86070ULL,
0x000000105f5f7824ULL, 0x000fe200078e025cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000585d7faeULL, 0x0003e2000c901c48ULL, 0x0000008051507825ULL, 0x000fe200078e0006ULL,
0x000000057000720cULL, 0x000fc40003f26070ULL, 0x00000000525f7faeULL, 0x0005e2000d101c48ULL,
0x000000106d6d7824ULL, 0x000fe200078e025cULL, 0x0000006f50507210ULL, 0x000fe40007fde0ffULL,
0x000000057500720cULL, 0x0c0fe40003f46070ULL, 0x00000000546d7faeULL, 0x0007e2000d901c48ULL,
0x000000057400720cULL, 0x000fe20003f66070ULL, 0x0000000175597824ULL, 0x102fe400078e025eULL,
0x00000001705d7824ULL, 0x000fc400078e025eULL, 0x0000008059527825ULL, 0x004fc800078e0006ULL,
0x0000000472057824ULL, 0x000fe400078e00ffULL, 0x0000000473557824ULL, 0x008fe400078e00ffULL,
0x000000805d067825ULL, 0x000fe200078e0006ULL, 0xfffffffc05057812ULL, 0x100fe400078ee26eULL,
0xfffffffc55557812ULL, 0x000fe200078ee26eULL, 0x0000000151517824ULL, 0x000fe200030e0671ULL,
0x0000006f52527210ULL, 0x000fe20007fde0ffULL, 0x0000000474597824ULL, 0x000fc400078e00ffULL,
0x00000004755d7824ULL, 0x000fe400078e00ffULL, 0x00000004705f7824ULL, 0x000fe200078e00ffULL,
0xfffffffc59597812ULL, 0x100fe200078ee26eULL, 0x0000000153537824ULL, 0x000fe200030e0671ULL,
0xfffffffc5d5d7812ULL, 0x000fe200078ee26eULL, 0x0000001005057824ULL, 0x000fe200078e025cULL,
0xfffffffc5f5f7812ULL, 0x000fe200078ee26eULL, 0x0000001055557824ULL, 0x100fe200078e025cULL,
0x0000006f06067210ULL, 0x000fe20007fde0ffULL, 0x0000001059597824ULL, 0x100fe200078e025cULL,
0x0000000056057faeULL, 0x0003e2000e901c48ULL, 0x000000105d5d7824ULL, 0x000fc400078e025cULL,
0x000000105f5f7824ULL, 0x000fe200078e025cULL, 0x000000005a557faeULL, 0x0003e2000e101c48ULL,
0x0000000107077824ULL, 0x000fc600030e0671ULL, 0x0000000050597faeULL, 0x0003e8000d901c48ULL,
0x00000000525d7faeULL, 0x0003e8000d101c48ULL, 0x00000000065f7faeULL, 0x0003e2000c901c48ULL,
0x0000053000007947ULL, 0x000fea0003800000ULL, 0x0000000220077824ULL, 0x000fe200078e0265ULL,
0x000000081f537811ULL, 0x042fe200078ff0ffULL, 0x000000101f057824ULL, 0x040fe200078e00ffULL,
0x000000101f557811ULL, 0x000fc400078ff0ffULL, 0x000000181f577811ULL, 0x000fe200078ff0ffULL,
0x0000000153517824ULL, 0x100fe200078e025eULL, 0x000000201f597811ULL, 0x000fe200078ff0ffULL,
0x00000004555f7824ULL, 0x000fe200078e00ffULL, 0x000000281f5b7811ULL, 0x000fe200078ff0ffULL,
0x00000004576d7824ULL, 0x000fe200078e00ffULL, 0x0000200007777811ULL, 0x000fe200078e60ffULL,
0x0000000453077824ULL, 0x000fe200078e00ffULL, 0x000000301f5d7811ULL, 0x000fe200078ff0ffULL,
0x0000000155537824ULL, 0x100fe200078e025eULL, 0x000000381f757811ULL, 0x000fe200078ff0ffULL,
0x0000000157557824ULL, 0x100fe200078e025eULL, 0x0000001f1f067211ULL, 0x000fe200078fe8ffULL,
0x0000000159577824ULL, 0x100fe200078e025eULL, 0x0000003005057812ULL, 0x000fe200078ec0ffULL,
0x00000004596f7824ULL, 0x000fe200078e00ffULL, 0x0000000306067812ULL, 0x000fe200078ec0ffULL,
0x000000015b597824ULL, 0x040fe200078e025eULL, 0x000062006e797a11ULL, 0x000fe200078238ffULL,
0x000000045b717824ULL, 0x000fe200078e00ffULL, 0xfffffffc07507812ULL, 0x000fe200078ee206ULL,
0x000000015d5b7824ULL, 0x000fe200078e025eULL, 0xfffffffc5f527812ULL, 0x100fe200078ee206ULL,
0x000000045d5d7824ULL, 0x000fe200078e00ffULL, 0xfffffffc6d547812ULL, 0x100fe200078ee206ULL,
0x0000000475737824ULL, 0x000fe200078e00ffULL, 0xfffffffc6f567812ULL, 0x100fe200078ee206ULL,
0x00000040045c7824ULL, 0x000fe200078e0205ULL, 0xfffffffc71587812ULL, 0x000fe200078ee206ULL,
0x0000000175757824ULL, 0x000fe200078e025eULL, 0xfffffffc5d5a7812ULL, 0x100fe200078ee206ULL,
0x000000ffff5d7224ULL, 0x000fe200078e00ffULL, 0xfffffffc73707812ULL, 0x000fe200078ee206ULL,
0x0000001050057824ULL, 0x000fe200078e0277ULL, 0x0ffffffc06067812ULL, 0x000fe200078ef81fULL,
0x00000010525f7824ULL, 0x100fe200078e0277ULL, 0x0000005e1f077211ULL, 0x000fe200078ff0ffULL,
0x00000010546d7824ULL, 0x000fc400078e0277ULL, 0x00000010067b7824ULL, 0x000fe400078e0277ULL,
0x0000008007067825ULL, 0x000fc800078e005cULL, 0x00000010566f7824ULL, 0x100fe400078e0277ULL,
0x0000001058717824ULL, 0x100fe400078e0277ULL, 0x000000105a737824ULL, 0x000fe400078e0277ULL,
0x0000008051507825ULL, 0x000fc800078e005cULL, 0x0000008053527825ULL, 0x000fe200078e005cULL,
0x0000007950507210ULL, 0x000fc60007f5e0ffULL, 0x0000008055547825ULL, 0x000fe200078e005cULL,
0x0000007952527210ULL, 0x000fc60007f7e0ffULL, 0x0000008057567825ULL, 0x000fe200078e005cULL,
0x0000007954547210ULL, 0x000fc60007f9e0ffULL, 0x0000008059587825ULL, 0x000fc800078e005cULL,
0x000000805b5a7825ULL, 0x000fc800078e005cULL, 0x00000080755c7825ULL, 0x000fe200078e005cULL,
0x000063006e757a11ULL, 0x000fe400008f3cffULL, 0x0000007906067210ULL, 0x080fe20007f3e0ffULL,
0x0000001070777824ULL, 0x000fe400078e0277ULL, 0x0000000151517824ULL, 0x100fe200010e0675ULL,
0x0000007958587210ULL, 0x080fe20007f5e0ffULL, 0x0000000107077824ULL, 0x100fe200008e0675ULL,
0x0000007956567210ULL, 0x080fe20007f3e0ffULL, 0x0000000153537824ULL, 0x100fe200018e0675ULL,
0x000000795a5a7210ULL, 0x080fe20007f7e0ffULL, 0x0000000155557824ULL, 0x100fe200020e0675ULL,
0x000000795c5c7210ULL, 0x000fe20007f9e0ffULL, 0x0000000157577824ULL, 0x100fe200008e0675ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000067b7faeULL, 0x0003e2000b901c48ULL,
0x0000000159597824ULL, 0x000fc400010e0675ULL, 0x000000015b5b7824ULL, 0x100fe200018e0675ULL,
0x0000000050057faeULL, 0x0003e2000b901c48ULL, 0x000000015d5d7824ULL, 0x000fc600020e0675ULL,
0x00000000525f7faeULL, 0x0003e8000b901c48ULL, 0x00000000546d7faeULL, 0x0003e8000b901c48ULL,
0x00000000566f7faeULL, 0x0003e8000b901c48ULL, 0x0000000058717faeULL, 0x0003e8000b901c48ULL,
0x000000005a737faeULL, 0x0003e8000b901c48ULL, 0x000000005c777faeULL, 0x0003e4000b901c48ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000010400780cULL, 0x000fe20003f25270ULL,
0x000000a000007945ULL, 0x000fd80003800000ULL, 0x0000008000001947ULL, 0x000fea0003800000ULL,
0x0000000260607810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff217424ULL, 0x000fc600078e00ffULL,
0x0000001d6000720cULL, 0x000fda0003f26070ULL, 0x0000004000001947ULL, 0x000fea0003800000ULL,
0x0000000269047824ULL, 0x000fe400078e0260ULL, 0x00000004ff057424ULL, 0x002fc800078e00ffULL,
0x0000640004047625ULL, 0x000fca00078e0005ULL, 0x0000000804217981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0x000000086c707824ULL, 0x000fe400078e00ffULL, 0x000000ffff797224ULL, 0x000fe400078e00ffULL,
0x00000010ff6f7424ULL, 0x002fe200078e00ffULL, 0x00000012706e7810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff6d7224ULL, 0x000fe200078e00ffULL, 0x0000000270707810ULL, 0x000fe20007ffe0ffULL,
0x000080400000791aULL, 0x000fc80000000000ULL, 0xfffffff81f047812ULL, 0x000fe200078ec0ffULL,
0x0000000220517824ULL, 0x020fe200078e026bULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000016d5f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000704507812ULL, 0x000fe400078ef81fULL,
0x0000200051517811ULL, 0x000fe400078e60ffULL, 0x00000001ff527819ULL, 0x000fe20000011650ULL,
0x0000000450057824ULL, 0x040fe400078e00ffULL, 0x0000000450537824ULL, 0x000fe400078e00ffULL,
0x0000000152047824ULL, 0x040fe400078e026dULL, 0x0000000152527824ULL, 0x000fc600078e025fULL,
0xfffffffc05047812ULL, 0x000fe400078ee204ULL, 0xfffffffc53527812ULL, 0x000fc600078ee252ULL,
0x0000001004047824ULL, 0x100fe400078e0251ULL, 0x0000001052527824ULL, 0x000fc800078e0251ULL,
0x000000000404783bULL, 0x000e680000000200ULL, 0x000000005258783bULL, 0x0004e20000000200ULL,
0x00000018ff507819ULL, 0x002fe20000011404ULL, 0x0001000004527824ULL, 0x044fe200078e00ffULL,
0x0000888004537816ULL, 0x040fe200000000ffULL, 0x0000010004547824ULL, 0x000fe200078e00ffULL,
0x00000050008f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff887819ULL, 0x000fe20000011405ULL,
0x00010000055e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fc40000011452ULL,
0x00000018ff5d7819ULL, 0x000fe40000011454ULL, 0x00000018ff727819ULL, 0x008fe20000011458ULL,
0x00000053008d7306ULL, 0x0005e20000200c00ULL, 0x000000201f507810ULL, 0x002fe40007ffe0ffULL,
0x00000018ff717819ULL, 0x000fe40000011459ULL, 0xfffffff850507812ULL, 0x000fe400078ec0ffULL,
0x0000888058757816ULL, 0x000fe200000000ffULL, 0x0000005c008e7306ULL, 0x0002e20000200c00ULL,
0x0000000750507812ULL, 0x000fc400078ef81fULL, 0x0000888005537816ULL, 0x044fe200000000ffULL,
0x0000010005057824ULL, 0x000fe200078e00ffULL, 0x00000001ff527819ULL, 0x000fe20000011650ULL,
0x0000000450557824ULL, 0x000fe200078e00ffULL, 0x0000888059787816ULL, 0x000fe200000000ffULL,
0x0000005300917306ULL, 0x0005e20000200c00ULL, 0x00000018ff057819ULL, 0x000fe20000011405ULL,
0x0000000152047824ULL, 0x000fe200078e026dULL, 0x00008880065c7816ULL, 0x002fe200000000ffULL,
0x0000000152527824ULL, 0x000fe200078e025fULL, 0x00000018ff5e7819ULL, 0x000fc4000001145eULL,
0xfffffffc55047812ULL, 0x000fe200078ee204ULL, 0x0000000500937306ULL, 0x0003e20000200c00ULL,
0x000000086c537824ULL, 0x004fe200078e026fULL, 0x00000018ff847819ULL, 0x000fe40000011407ULL,
0x0000001004047824ULL, 0x000fe200078e0251ULL, 0x0000888007897816ULL, 0x000fe400000000ffULL,
0x00000018ff747819ULL, 0x000fe2000001145aULL, 0x0000005c00947306ULL, 0x000fe20000200c00ULL,
0x000000000454783bULL, 0x0004e20000000200ULL, 0x0000000450057824ULL, 0x002fe200078e00ffULL,
0x000088805a7c7816ULL, 0x000fe200000000ffULL, 0x0001000059507824ULL, 0x040fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe20000011406ULL, 0x0000010059597824ULL, 0x000fe200078e00ffULL,
0xfffffffc05527812ULL, 0x000fe200078ee252ULL, 0x0000005d00907306ULL, 0x0002e20000200c00ULL,
0x0001000007047824ULL, 0x044fe200078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe20000011450ULL,
0x0000010007077824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fc40000011459ULL,
0x00000018ff047819ULL, 0x000fe40000011404ULL, 0x0000005e00927306ULL, 0x000ea20000200c00ULL,
0x00010000065d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff077819ULL, 0x000fe20000011407ULL,
0x0000010006067824ULL, 0x000fe200078e00ffULL, 0x000054108d8e7816ULL, 0x008fe4000000008eULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x00000004008a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff067819ULL, 0x000fc40000011406ULL, 0x00005410908f7816ULL, 0x000fe4000000008fULL,
0x00000018ff737819ULL, 0x000fe4000001145bULL, 0x000000026d6d7810ULL, 0x000fe20007ffe0ffULL,
0x0000005d00957306ULL, 0x000fe20000200c00ULL, 0x0001000058047824ULL, 0x042fe200078e00ffULL,
0x0000541091927816ULL, 0x004fe20000000092ULL, 0x0000010058587824ULL, 0x000fc600078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011404ULL, 0x0000001052047824ULL, 0x000fe200078e0251ULL,
0x000000081f527812ULL, 0x040fe200078ec0ffULL, 0x0000008800887306ULL, 0x000e620000200c00ULL,
0x00000018ff587819ULL, 0x000fe20000011458ULL, 0x0001000054977824ULL, 0x000fe200078e00ffULL,
0x000000071f517812ULL, 0x000fe200078ec0ffULL, 0x0001000055907824ULL, 0x000fe200078e00ffULL,
0x000000521f507211ULL, 0x000fe400078fe0ffULL, 0x0000000752597812ULL, 0x000fe200078ef81fULL,
0x0000005800777306ULL, 0x0005e20000200c00ULL, 0x00000018ff867819ULL, 0x000fe20000011454ULL,
0x00000001518c7824ULL, 0x000fe200078e0250ULL, 0x00000018ff857819ULL, 0x000fe20000011455ULL,
0x000000086c517824ULL, 0x000fe200078e0279ULL, 0x0000888055987816ULL, 0x000fe200000000ffULL,
0x0000001059527824ULL, 0x040fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011456ULL,
0x000000018c517824ULL, 0x040fe200078e0251ULL, 0x0000001059587812ULL, 0x004fe200078efcffULL,
0x000000018c537824ULL, 0x000fe200078e0253ULL, 0x0000008400847306ULL, 0x000fe20000200c00ULL,
0x000100005a507824ULL, 0x000fe200078e00ffULL, 0xfffffff052517812ULL, 0x000fe200078ee251ULL,
0x00000010585c7824ULL, 0x000fe200078e00ffULL, 0x0000541093937816ULL, 0x002fe20000000088ULL,
0x000001005a5a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe20000011450ULL,
0x0000010055557824ULL, 0x000fe200078e00ffULL, 0xfffffff05c537812ULL, 0x000fe200078ee253ULL,
0x00000010515c7824ULL, 0x000fe200078e00ffULL, 0x00000007008b7306ULL, 0x000e620000200c00ULL,
0x00000018ff7f7819ULL, 0x000fe2000001145aULL, 0x000000ffff8d7224ULL, 0x000fe200078e0098ULL,
0x00008880545a7816ULL, 0x040fe200000000ffULL, 0x0000001053537824ULL, 0x000fe200078e00ffULL,
0x000000005c5c783bULL, 0x000ea20000000200ULL, 0x0000010054547824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x0000008900897306ULL, 0x000ee20000200c00ULL,
0x0000888056887816ULL, 0x000fe200000000ffULL, 0x000000005350783bULL, 0x000ea20000000200ULL,
0x00000018ff547819ULL, 0x000fe20000011454ULL, 0x0000001058587824ULL, 0x000fe200078e00ffULL,
0x00000018ff827819ULL, 0x000fc40000011457ULL, 0x00000018ff977819ULL, 0x000fe20000011497ULL,
0x0000000600967306ULL, 0x0007e20000200c00ULL, 0x000054108b8b7816ULL, 0x002fe20000000084ULL,
0x0001000057847824ULL, 0x000fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fe40000011490ULL,
0x0000541094947816ULL, 0x000fe40000000095ULL, 0x00000018ff847819ULL, 0x000fe20000011484ULL,
0x0000005400997306ULL, 0x000fe20000200c00ULL, 0x000000000404783bULL, 0x008e620000000200ULL,
0x00005410898a7816ULL, 0x000fcc000000008aULL, 0x0000005500547306ULL, 0x0007f00000200c00ULL,
0x0000008700877306ULL, 0x000ea20000200c00ULL, 0x0000888057557816ULL, 0x048fe200000000ffULL,
0x0000010057577824ULL, 0x000fe200078e00ffULL, 0x0000008e5c4c723cULL, 0x084fe8000000184cULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x0000005a005a7306ULL, 0x000fe60000200c00ULL,
0x0000008e5008723cULL, 0x000bea0000001808ULL, 0x0000009700977306ULL, 0x000ea20000200c00ULL,
0x0000541096957816ULL, 0x000fc40000000087ULL, 0x000000708c877210ULL, 0x100fe20007ffe079ULL,
0x00010000568e7824ULL, 0x060fe200078e00ffULL, 0x0000008a5c18723cULL, 0x080fe20000001818ULL,
0x0000010056567824ULL, 0x000fe200078e00ffULL, 0x0000006e8c797210ULL, 0x000fe20007ffe079ULL,
0x0000008600867306ULL, 0x000ee20000200c00ULL, 0x00000018ff8e7819ULL, 0x000fe4000001148eULL,
0x00000018ff567819ULL, 0x000fe40000011456ULL, 0x0000008a5014723cULL, 0x000be20000001814ULL,
0xfffffff058797812ULL, 0x000fc400078ee279ULL, 0x00000088008f7306ULL, 0x0005e20000200c00ULL,
0x00000018ff817819ULL, 0x002fe40000011404ULL, 0x0000001079587824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe20000011405ULL, 0x000000925c34723cULL, 0x000fe20000001834ULL,
0x00000018ff797819ULL, 0x000fe40000011407ULL, 0x0000008e008e7306ULL, 0x000e620000200c00ULL,
0x000054105a887816ULL, 0x004fe20000000097ULL, 0x00000010595a7824ULL, 0x000fe200078e00ffULL,
0x0000541099897816ULL, 0x008fc40000000086ULL, 0x000088805b867816ULL, 0x000fe200000000ffULL,
0x000000945c38723cULL, 0x000f620000001838ULL, 0xfffffff05a877812ULL, 0x000fe200078ee287ULL,
0x0000008500857306ULL, 0x000ea20000200c00ULL, 0x00000018ff7e7819ULL, 0x000fe20000011406ULL,
0x000000ffff597224ULL, 0x000fc800078e0086ULL, 0x000000885c30723cULL, 0x000fe40000001830ULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x000054108f8e7816ULL, 0x002fca000000008eULL,
0x000000925024723cULL, 0x000fe40000001824ULL, 0x0000008200827306ULL, 0x000fe20000200c00ULL,
0x0000541054857816ULL, 0x004fe20000000085ULL, 0x000100005b547824ULL, 0x000fc800078e00ffULL,
0x00000094503c723cULL, 0x000f62000000183cULL, 0x00000018ff867819ULL, 0x000fe20000011454ULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x0000001087547824ULL, 0x000fca00078e00ffULL,
0x000000885048723cULL, 0x000fe40000001848ULL, 0x0000009000907306ULL, 0x000ff00000200c00ULL,
0x0000005600567306ULL, 0x000e700000200c00ULL, 0x0000005500557306ULL, 0x000ff00000200c00ULL,
0x00000084008a7306ULL, 0x0204e20000200c00ULL, 0x00005410568f7816ULL, 0x002fce0000000083ULL,
0x00000057008b7306ULL, 0x0002620000200c00ULL, 0x000054108d847816ULL, 0x004fe20000000090ULL,
0x0000008e5c40723cULL, 0x040fec0000001840ULL, 0x0000007c007c7306ULL, 0x000fe20000200c00ULL,
0x00005410558a7816ULL, 0x008fe2000000008aULL, 0x000000845c2c723cULL, 0x080f62000000182cULL,
0x000000005454783bULL, 0x002e6a0000000200ULL, 0x0000007d007d7306ULL, 0x000ea20000200c00ULL,
0x000054108b8b7816ULL, 0x000fe20000000082ULL, 0x000000845028723cULL, 0x000fec0000001828ULL,
0x0000007400747306ULL, 0x000fe40000200c00ULL, 0x0000008a5c44723cULL, 0x000b6c0000001844ULL,
0x0000007f007f7306ULL, 0x000ee20000200c00ULL, 0x00008880045d7816ULL, 0x060fe200000000ffULL,
0x00010000045e7824ULL, 0x040fe200078e00ffULL, 0x00008880055f7816ULL, 0x000fe200000000ffULL,
0x0000010004047824ULL, 0x000fe200078e00ffULL, 0x0000008e5010723cULL, 0x000f620000001810ULL,
0x000001005b5c7824ULL, 0x000fe200078e00ffULL, 0x000054107c7c7816ULL, 0x004fe2000000007dULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x00000018ff047819ULL, 0x000fc40000011404ULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000008a500c723cULL, 0x000b62000000180cULL,
0x00000018ff5e7819ULL, 0x000fe4000001145eULL, 0x0000007600767306ULL, 0x000ea20000200c00ULL,
0x000054107f7d7816ULL, 0x008fe20000000074ULL, 0x0001000007747824ULL, 0x040fe400078e00ffULL,
0x000000ffff507224ULL, 0x020fe200078e005fULL, 0x00008880075f7816ULL, 0x000fe200000000ffULL,
0x0001000005517824ULL, 0x040fe200078e00ffULL, 0x0000888006527816ULL, 0x040fe200000000ffULL,
0x00000059008c7306ULL, 0x0007e20000200c00ULL, 0x0001000006537824ULL, 0x040fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x0000010005057824ULL, 0x000fe200078e00ffULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x0000010007077824ULL, 0x000fe200078e00ffULL,
0x00000018ff537819ULL, 0x000fe20000011453ULL, 0x0000010006067824ULL, 0x000fe200078e00ffULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000000005858783bULL, 0x008ee20000000200ULL,
0x00000018ff057819ULL, 0x000fe20000011405ULL, 0x0000007c5438723cULL, 0x002f620000001838ULL,
0x00000018ff077819ULL, 0x000fc40000011407ULL, 0x00000018ff067819ULL, 0x000fe40000011406ULL,
0x0000007a007a7306ULL, 0x000e620000200c00ULL, 0x0000541075767816ULL, 0x004fce0000000076ULL,
0x0000008100817306ULL, 0x000ff00000200c00ULL, 0x0000000400047306ULL, 0x000ff00000200c00ULL,
0x0000007900827306ULL, 0x0003f00000200c00ULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x000054107a797816ULL, 0x002fe20000000071ULL, 0x0000007c583c723cULL, 0x008f6c000000183cULL,
0x0000005000507306ULL, 0x000ff00000200c00ULL, 0x0000005100517306ULL, 0x000e620000200c00ULL,
0x0000541077777816ULL, 0x004fce0000000072ULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x00000076544c723cULL, 0x080f6e000000184cULL, 0x0000005300537306ULL, 0x000ea20000200c00ULL,
0x0000541050507816ULL, 0x002fe20000000051ULL, 0x000000765808723cULL, 0x000f6c0000001808ULL,
0x0000005f00757306ULL, 0x0003f00000200c00ULL, 0x0000007400747306ULL, 0x000ee20000200c00ULL,
0x00005410045f7816ULL, 0x002fc40000000081ULL, 0x000000046f047810ULL, 0x000fe40007ffe0ffULL,
0x0000541052527816ULL, 0x004fe40000000053ULL, 0x000000180400780cULL, 0x000fe20003f25270ULL,
0x0000007300737306ULL, 0x000ff00000200c00ULL, 0x0000007800787306ULL, 0x000fe20000200c00ULL,
0x0000541075747816ULL, 0x008fce0000000074ULL, 0x0000007b007b7306ULL, 0x000e700000200c00ULL,
0x0000008000807306ULL, 0x000ff00000200c00ULL, 0x0000007e007e7306ULL, 0x000fe20000200c00ULL,
0x0000541078787816ULL, 0x002fce000000007bULL, 0x0000008600837306ULL, 0x000e620000200c00ULL,
0x000000785434723cULL, 0x080f6e0000001834ULL, 0x0000005c005c7306ULL, 0x000ea20000200c00ULL,
0x000000785824723cULL, 0x000b6e0000001824ULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x000054108c727816ULL, 0x002fc40000000083ULL, 0xfffffff46f797810ULL, 0x020fe20007ffe0ffULL,
0x000000ffff6f7224ULL, 0x000fc800078e0004ULL, 0x0000005e005e7306ULL, 0x000e620000200c00ULL,
0x000054105c737816ULL, 0x004fce0000000073ULL, 0x0000000500057306ULL, 0x000ea20000200c00ULL,
0x000000725418723cULL, 0x080b6e0000001818ULL, 0x0000000600717306ULL, 0x000ee20000200c00ULL,
0x000054105d5e7816ULL, 0x002fe2000000005eULL, 0x000000725814723cULL, 0x000b6c0000001814ULL,
0x0000000700077306ULL, 0x000e620000200c00ULL, 0x0000541005517816ULL, 0x004fe20000000080ULL,
0x0000005e5430723cULL, 0x000b620000001830ULL, 0x0000541071537816ULL, 0x008fce000000007eULL,
0x00000050542c723cULL, 0x000b62000000182cULL, 0x0000541007757816ULL, 0x002fce0000000082ULL,
0x000000525440723cULL, 0x040b700000001840ULL, 0x000000745444723cULL, 0x000b700000001844ULL,
0x0000005e5848723cULL, 0x040b700000001848ULL, 0x000000505828723cULL, 0x040b700000001828ULL,
0x000000525810723cULL, 0x040b700000001810ULL, 0x00000074580c723cULL, 0x000b62000000180cULL,
0x0000001000009944ULL, 0x000fe20003c00000ULL, 0xffffedb000007947ULL, 0x000fcc000383ffffULL,
0x0000000000007918ULL, 0x000fd20000000000ULL, 0x000000ffff6b7224ULL, 0x000fe200078e0065ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffffdff000007947ULL, 0x000fea000383ffffULL,
0x0000000000007918ULL, 0x000fdc0000000000ULL, 0x0000006832327220ULL, 0x0a0fe20000410000ULL,
0x0000006845457220ULL, 0x080fe20000410000ULL, 0x0000006836367220ULL, 0x080fe20000410000ULL,
0x0000006837377220ULL, 0x080fe20000410000ULL, 0x000000683a3a7220ULL, 0x080fe20000410000ULL,
0x000000683b3b7220ULL, 0x080fe20000410000ULL, 0x0000006833337220ULL, 0x080fe20000410000ULL,
0x0000006842427220ULL, 0x080fe20000410000ULL, 0x0000006844447220ULL, 0x080fe20000410000ULL,
0x0000006846467220ULL, 0x080fe20000410000ULL, 0x000000684e047220ULL, 0x080fe20000410000ULL,
0x000000684f057220ULL, 0x080fe20000410000ULL, 0x0000006838537220ULL, 0x080fe20000410000ULL,
0x000000681a1a7220ULL, 0x080fe20000410000ULL, 0x000000681b1b7220ULL, 0x080fe20000410000ULL,
0x000000682f067220ULL, 0x080fe20000410000ULL, 0x0000006843437220ULL, 0x080fe20000410000ULL,
0x0000006847077220ULL, 0x080fe20000410000ULL, 0x0000006824247220ULL, 0x080fe20000410000ULL,
0x0000006825257220ULL, 0x080fe20000410000ULL, 0x0000006814147220ULL, 0x080fe20000410000ULL,
0x0000006815157220ULL, 0x080fe20000410000ULL, 0x0000006810107220ULL, 0x080fe20000410000ULL,
0x000000680c0c7220ULL, 0x080fe20000410000ULL, 0x000000684c577220ULL, 0x080fe20000410000ULL,
0x0000006839527220ULL, 0x080fe20000410000ULL, 0x000000683c387220ULL, 0x080fe20000410000ULL,
0x000000684a5c7220ULL, 0x080fe20000410000ULL, 0x000000684d567220ULL, 0x080fe20000410000ULL,
0x0000006831507220ULL, 0x080fe20000410000ULL, 0x000000682c4f7220ULL, 0x080fe20000410000ULL,
0x000000682d4e7220ULL, 0x080fe20000410000ULL, 0x00000068414c7220ULL, 0x080fe20000410000ULL,
0x000000683d397220ULL, 0x080fe20000410000ULL, 0x00000068483c7220ULL, 0x080fe20000410000ULL,
0x000000684b5d7220ULL, 0x080fe20000410000ULL, 0x000000682b5f7220ULL, 0x080fe20000410000ULL,
0x000000ffff4a7224ULL, 0x000fe200078e0045ULL, 0x0000006834557220ULL, 0x080fe20000410000ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0032ULL, 0x0000006835547220ULL, 0x080fe20000410000ULL,
0x0000006818517220ULL, 0x080fe20000410000ULL, 0x0000006819587220ULL, 0x080fe20000410000ULL,
0x0000006830597220ULL, 0x080fe20000410000ULL, 0x000000682e317220ULL, 0x080fe20000410000ULL,
0x00000068404d7220ULL, 0x080fe20000410000ULL, 0x000000683e5a7220ULL, 0x080fe20000410000ULL,
0x000000683f5b7220ULL, 0x080fe20000410000ULL, 0x00000068493d7220ULL, 0x080fe20000410000ULL,
0x000000682a5e7220ULL, 0x080fe20000410000ULL, 0x0000006811417220ULL, 0x080fe20000410000ULL,
0x000000ffff4b7224ULL, 0x000fe200078e0044ULL, 0x0000006808357220ULL, 0x080fe20000410000ULL,
0x000000ffff2b7224ULL, 0x000fe200078e0036ULL, 0x0000006809347220ULL, 0x080fe20000410000ULL,
0x000000ffff2d7224ULL, 0x000fe200078e0037ULL, 0x000000680a0a7220ULL, 0x080fe20000410000ULL,
0x000000ffff2c7224ULL, 0x000fe200078e003aULL, 0x000000680b0b7220ULL, 0x080fe20000410000ULL,
0x000000ffff487224ULL, 0x000fe200078e003bULL, 0x0000006826187220ULL, 0x080fe20000410000ULL,
0x000000ffff477224ULL, 0x000fe200078e0033ULL, 0x0000006827197220ULL, 0x080fe20000410000ULL,
0x000000ffff327224ULL, 0x000fe200078e0042ULL, 0x0000006816167220ULL, 0x080fe20000410000ULL,
0x000000ffff457224ULL, 0x000fe200078e0046ULL, 0x0000006817177220ULL, 0x080fe20000410000ULL,
0x00000068283e7220ULL, 0x080fe20000410000ULL, 0x00000068293f7220ULL, 0x080fe20000410000ULL,
0x0000006812117220ULL, 0x080fe20000410000ULL, 0x00000068136a7220ULL, 0x080fe20000410000ULL,
0x000000680d0d7220ULL, 0x080fe20000410000ULL, 0x000000680e0e7220ULL, 0x080fe20000410000ULL,
0x000000680f0f7220ULL, 0x000fe20000410000ULL, 0x000000ffff2a7224ULL, 0x000fc400078e0004ULL,
0x000000ffff497224ULL, 0x000fe400078e0005ULL, 0x000000ffff2e7224ULL, 0x000fe400078e001aULL,
0x000000ffff307224ULL, 0x000fe400078e001bULL, 0x000000ffff407224ULL, 0x000fe400078e0006ULL,
0x000000ffff337224ULL, 0x000fe400078e0043ULL, 0x000000ffff447224ULL, 0x000fc400078e0007ULL,
0x000000ffff367224ULL, 0x000fe400078e0024ULL, 0x000000ffff377224ULL, 0x000fe400078e0025ULL,
0x000000ffff3a7224ULL, 0x000fe400078e0014ULL, 0x000000ffff3b7224ULL, 0x000fe400078e0015ULL,
0x000000ffff467224ULL, 0x000fe400078e0010ULL, 0x000000ffff427224ULL, 0x000fe200078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000067087f8cULL, 0x0002a2000c80043fULL,
0x000000ffff1b7224ULL, 0x000fc400078e0018ULL, 0x000000ffff247224ULL, 0x000fe400078e0019ULL,
0x000000ffff257224ULL, 0x000fe400078e0016ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0017ULL,
0x000000ffff437224ULL, 0x000fe400078e000dULL, 0x000000ffff267224ULL, 0x000fe400078e000aULL,
0x000000ffff277224ULL, 0x000fc400078e000bULL, 0x000000ffff297224ULL, 0x000fe400078e005aULL,
0x000000ffff287224ULL, 0x000fe400078e005bULL, 0x000000ffff197224ULL, 0x000fe400078e005cULL,
0x000000ffff187224ULL, 0x000fe400078e005dULL, 0x000000ffff127224ULL, 0x000fe400078e005eULL,
0x000000ffff137224ULL, 0x000fc400078e005fULL, 0x000000ffff147224ULL, 0x000fe400078e0011ULL,
0x000000ffff157224ULL, 0x000fe400078e006aULL, 0x000000ffff167224ULL, 0x000fe400078e000eULL,
0x000000ffff177224ULL, 0x000fc400078e000fULL, 0x0000000000047805ULL, 0x006fca0000015200ULL,
0x0000040067077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040067077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000041f117824ULL, 0x000fe200078e00ffULL, 0x000000616400720cULL, 0x000fc80003f06070ULL,
0xfffffff011057812ULL, 0x000fca00078ec0ffULL, 0x0000008020107824ULL, 0x000fca00078e0205ULL,
0x0124000010047984ULL, 0x0002a20000000c00ULL, 0x00001f6000008947ULL, 0x000fea0003800000ULL,
0x0000010064097824ULL, 0x000fe200078e0203ULL, 0x000000001f087211ULL, 0x040fe200078ff0ffULL,
0x000000021f5b7824ULL, 0x000fe400078e00ffULL, 0x00000002ff7c7424ULL, 0x000fe200078e00ffULL,
0x000000091e5a7217ULL, 0x000fe40007800000ULL, 0x000000065b5b7812ULL, 0x000fe400078ec0ffULL,
0x00000008080b7810ULL, 0x000fe20007ffe0ffULL, 0x000000015a5a7824ULL, 0x000fe200078e0a09ULL,
0x000058005b5d7a10ULL, 0x000fe20007ffe0ffULL, 0x0000000162097824ULL, 0x000fe200078e025bULL,
0x00005a00ff0a7a19ULL, 0x000fc40000011608ULL, 0x00000010080d7810ULL, 0x040fe20007ffe0ffULL,
0x00000001090c7824ULL, 0x100fe200078e0a5aULL, 0x00000018080f7810ULL, 0x000fe20007ffe0ffULL,
0x000000015d087824ULL, 0x000fe200078e0a5aULL, 0x00005a00ff0e7a19ULL, 0x000fe4000001160bULL,
0x0000000c630c7217ULL, 0x040fe40003800000ULL, 0x0000000a630a7217ULL, 0x040fe40003800000ULL,
0x0000000e630e7217ULL, 0x000fc40003800000ULL, 0x0000005a0900720cULL, 0x000fe20003f26070ULL,
0x0000000a238b7224ULL, 0x000fe200078e02ffULL, 0x0000005a5d00720cULL, 0x000fe20003f06070ULL,
0x0000000e238d7224ULL, 0x000fe200078e02ffULL, 0x0000000863087217ULL, 0x000fe40003800000ULL,
0x00000004ff0c7819ULL, 0x000fe4000001160cULL, 0x000000ff087a7207ULL, 0x000fe40000000000ULL,
0x000000ff0c0e7207ULL, 0x000fc40000800000ULL, 0x00005a00ff087a19ULL, 0x000fe4000001160dULL,
0x00005a00ff0a7a19ULL, 0x000fe2000001160fULL, 0x000000018b0b7824ULL, 0x000fe200078e020eULL,
0x0000008b7a097211ULL, 0x000fe400078fe0ffULL, 0x00000008635c7217ULL, 0x040fe40003800000ULL,
0x0000000a635e7217ULL, 0x000fe20003800000ULL, 0x0000600009087625ULL, 0x000fe200078e007cULL,
0x000000105b777812ULL, 0x000fc400078efcffULL, 0x0000008d7a0d7211ULL, 0x000fe200078fe0ffULL,
0x000060000b0a7625ULL, 0x000fc800078e007cULL, 0x0000005c238f7224ULL, 0x040fe200078e02ffULL,
0x000000080a5f7981ULL, 0x0046a2000c1e9500ULL, 0x0000005e23917224ULL, 0x000fe400078e02ffULL,
0x000000010e0f7824ULL, 0x000fe200078e028dULL, 0x00000008085c7981ULL, 0x0002a2000c1e9500ULL,
0x0000008f7a6b7211ULL, 0x000fe200078fe0ffULL, 0x000000010e6f7824ULL, 0x000fe400078e028fULL,
0x000060000d0c7625ULL, 0x000fc800078e007cULL, 0x00000001620b7824ULL, 0x008fe200078e0277ULL,
0x0000580077757a10ULL, 0x000fe20007ffe0ffULL, 0x000000010e717824ULL, 0x000fe200078e0291ULL,
0x000000080c5e7981ULL, 0x0006a2000c1e9500ULL, 0x000000010b727824ULL, 0x000fe400078e0a5aULL,
0x000060006b6a7625ULL, 0x000fc800078e007cULL, 0x000060000f0e7625ULL, 0x000fe200078e007cULL,
0x0000007263727217ULL, 0x000fe20003800000ULL, 0x000000086a6e7981ULL, 0x0006a4000c1e9500ULL,
0x000060006f087625ULL, 0x002fe200078e007cULL, 0x0000005a0b00720cULL, 0x000fc60003f26070ULL,
0x00006000710c7625ULL, 0x008fe200078e007cULL, 0x0000000808737981ULL, 0x0002e2000c1e9500ULL,
0x00000004ff727819ULL, 0x000fe40000011672ULL, 0x00000001750a7824ULL, 0x040fe200078e0a5aULL,
0x000000080e717981ULL, 0x0002e2000c1e9500ULL, 0x000000917a6d7211ULL, 0x000fe400078fe0ffULL,
0x0000005a7500720cULL, 0x000fe20003f06070ULL, 0x000000080c707981ULL, 0x0002e2000c1e9500ULL,
0x0000000a630a7217ULL, 0x000fe20003800000ULL, 0x000060006d6c7625ULL, 0x000fe200078e007cULL,
0x000000ff720e7207ULL, 0x002fc80000800000ULL, 0x000000086c6f7981ULL, 0x0002e2000c1e9500ULL,
0x000000ff0a827207ULL, 0x000fe20000000000ULL, 0x000000018b0b7824ULL, 0x000fc600078e020eULL,
0x0000008b82097211ULL, 0x000fe200078fe0ffULL, 0x000000010e0f7824ULL, 0x000fe200078e028dULL,
0x0000008d820d7211ULL, 0x000fe200078fe0ffULL, 0x000060000b0a7625ULL, 0x000fe200078e007cULL,
0x000000205b7f7812ULL, 0x000fc600078efcffULL, 0x0000600009087625ULL, 0x080fe200078e007cULL,
0x000000080a797981ULL, 0x0002e6000c1e9500ULL, 0x000000010e7b7824ULL, 0x040fe200078e028fULL,
0x0000000808727981ULL, 0x0002e2000c1e9500ULL, 0x000000010e7d7824ULL, 0x000fe400078e0291ULL,
0x000060000d0c7625ULL, 0x000fe200078e007cULL, 0x000058007f817a10ULL, 0x000fc60007ffe0ffULL,
0x000060000f0e7625ULL, 0x080fe200078e007cULL, 0x000000080c747981ULL, 0x0002e6000c1e9500ULL,
0x00000001620b7824ULL, 0x002fe400078e027fULL, 0x000060007b087625ULL, 0x000fe400078e007cULL,
0x000000080e7b7981ULL, 0x0002e4000c1e9500ULL, 0x000000010b7e7824ULL, 0x100fe200078e0a5aULL,
0x0000008f826b7211ULL, 0x040fe200078fe0ffULL, 0x00000001810a7824ULL, 0x000fe200078e0a5aULL,
0x00000091826d7211ULL, 0x000fc400078fe0ffULL, 0x0000007e637e7217ULL, 0x000fe20003800000ULL,
0x000060006b6a7625ULL, 0x000fe200078e007cULL, 0x0000005a8100720cULL, 0x000fe40003f06070ULL,
0x0000000a630a7217ULL, 0x000fe20003800000ULL, 0x000060006d6c7625ULL, 0x000fe200078e007cULL,
0x0000005a0b00720cULL, 0x000fe20003f26070ULL, 0x000000086a767981ULL, 0x0002e2000c1e9500ULL,
0x00000004ff7e7819ULL, 0x000fe2000001167eULL, 0x000060007d0c7625ULL, 0x000fe200078e007cULL,
0x000000ff0a887207ULL, 0x000fe20000000000ULL, 0x00000008087d7981ULL, 0x0002e8000c1e9500ULL,
0x000000086c787981ULL, 0x0002e8000c1e9500ULL, 0x000000080c837981ULL, 0x0002e4000c1e9500ULL,
0x000000ff7e087207ULL, 0x002fc40000800000ULL, 0x0000008b880b7211ULL, 0x000fc600078fe0ffULL,
0x0000000108097824ULL, 0x000fe200078e028dULL, 0x0000008d880d7211ULL, 0x000fe200078fe0ffULL,
0x000000018b6d7824ULL, 0x000fe400078e0208ULL, 0x0000000108877824ULL, 0x040fe400078e028fULL,
0x0000000108897824ULL, 0x000fe400078e0291ULL, 0x000060000d0c7625ULL, 0x000fc800078e007cULL,
0x0000600009087625ULL, 0x080fe200078e007cULL, 0x000000080c807981ULL, 0x0002e6000c1e9500ULL,
0x000060000b0a7625ULL, 0x080fe200078e007cULL, 0x0000000808d17981ULL, 0x0002e2000c1e9500ULL,
0x0000008f886b7211ULL, 0x040fe400078fe0ffULL, 0x000060006d6c7625ULL, 0x000fe200078e007cULL,
0x000000080a7e7981ULL, 0x0002e2000c1e9500ULL, 0x00000091880f7211ULL, 0x000fc400078fe0ffULL,
0x000060006b6a7625ULL, 0x080fe200078e007cULL, 0x000000086c857981ULL, 0x0002e6000c1e9500ULL,
0x00006000870a7625ULL, 0x082fe200078e007cULL, 0x000000305b877812ULL, 0x000fe200078efcffULL,
0x000000086a847981ULL, 0x0002e4000c1e9500ULL, 0x000060000f0e7625ULL, 0x080fe400078e007cULL,
0x000000080ad57981ULL, 0x0002e4000c1e9500ULL, 0x00006000890c7625ULL, 0x000fe200078e007cULL,
0x0000580087897a10ULL, 0x000fe20007ffe0ffULL, 0x000000080e867981ULL, 0x0002e4000c1e9500ULL,
0x00000001626d7824ULL, 0x000fc400078e0287ULL, 0x000000080cd97981ULL, 0x0002e4000c1e9500ULL,
0x000000016d8a7824ULL, 0x100fe400078e0a5aULL, 0x00000001896c7824ULL, 0x000fc600078e0a5aULL,
0x0000008a638a7217ULL, 0x000fe40003800000ULL, 0x0000005a6d00720cULL, 0x080fe40003f26070ULL,
0x0000005a8900720cULL, 0x000fe40003f06070ULL, 0x0000006c636c7217ULL, 0x000fe40003800000ULL,
0x00000004ff087819ULL, 0x000fe4000001168aULL, 0x000000ff6c8a7207ULL, 0x000fc40000000000ULL,
0x000000ff088c7207ULL, 0x000fe40000800000ULL, 0x0000008b8a6b7211ULL, 0x042fe400078fe0ffULL,
0x0000008f8a0b7211ULL, 0x000fe200078fe0ffULL, 0x000000018b6d7824ULL, 0x000fe400078e028cULL,
0x000000018c0f7824ULL, 0x000fe400078e028fULL, 0x000060006b6a7625ULL, 0x000fc800078e007cULL,
0x000060006d6c7625ULL, 0x080fe200078e007cULL, 0x000000086abb7981ULL, 0x0002e6000c1e9500ULL,
0x000060000b0a7625ULL, 0x080fe200078e007cULL, 0x000000086c8e7981ULL, 0x0002e6000c1e9500ULL,
0x000060000f0e7625ULL, 0x000fe200078e007cULL, 0x000000080ad77981ULL, 0x0002e2000c1e9500ULL,
0x0000008d8a097211ULL, 0x000fc600078fe0ffULL, 0x000000080e927981ULL, 0x0002e2000c1e9500ULL,
0x000000018c0d7824ULL, 0x000fe400078e028dULL, 0x0000600009087625ULL, 0x000fc800078e007cULL,
0x000060000d0c7625ULL, 0x080fe200078e007cULL, 0x0000000808d37981ULL, 0x0002e4000c1e9500ULL,
0x000000918a6b7211ULL, 0x002fe400078fe0ffULL, 0x000000080c907981ULL, 0x0002e2000c1e9500ULL,
0x000000018c6d7824ULL, 0x000fe400078e0291ULL, 0x000060006b6a7625ULL, 0x000fc800078e007cULL,
0x000060006d6c7625ULL, 0x000fe200078e007cULL, 0x000000086adb7981ULL, 0x0002e8000c1e9500ULL,
0x000000086c947981ULL, 0x0002e2000c1e9500ULL, 0xfffffff07a097812ULL, 0x000fe200078ec0ffULL,
0x00000001ffcf7424ULL, 0x000fc800078e00ffULL, 0x000000015a087824ULL, 0x000fc800078e0209ULL,
0x000000015d097824ULL, 0x000fe200078e0a08ULL, 0x000000015b8b7812ULL, 0x000fc800078efcffULL,
0x00000009cf097219ULL, 0x000fe400000006ffULL, 0x000058008b0b7a10ULL, 0x000fe40007ffe0ffULL,
0xfffffff0820d7812ULL, 0x002fc600078ec0ffULL, 0x000000010b0a7824ULL, 0x100fe200078e0a08ULL,
0x000000085b8d7812ULL, 0x040fe200078efcffULL, 0x000000015a0e7824ULL, 0x000fe200078e020dULL,
0x000000095b8f7812ULL, 0x000fe400078efcffULL, 0x0000000acf0d7219ULL, 0x000fe400000006ffULL,
0x000058008d0f7a10ULL, 0x000fe40007ffe0ffULL, 0x000058008f6d7a10ULL, 0x000fe40007ffe0ffULL,
0xfffffff0886b7812ULL, 0x000fe200078ec0ffULL, 0x000000010f0c7824ULL, 0x100fe200078e0a08ULL,
0xfffffff08a917812ULL, 0x000fe200078ec0ffULL, 0x000000016d087824ULL, 0x000fe200078e0a08ULL,
0x000000115b957812ULL, 0x000fe200078efcffULL, 0x000000015a6a7824ULL, 0x040fe200078e026bULL,
0x0000000ccf6b7219ULL, 0x040fe200000006ffULL, 0x000000015a827824ULL, 0x000fe200078e0291ULL,
0x00000008cf917219ULL, 0x000fc400000006ffULL, 0x0000580095977a10ULL, 0x000fe40007ffe0ffULL,
0x000054105c5c7816ULL, 0x004fc8000000005fULL, 0x0000005c09ff7212ULL, 0x000fc800078ac0ffULL,
0x0000005a5d00720cULL, 0x000fc80002fa1470ULL, 0x0000005a5b00720cULL, 0x000fe40002fa1070ULL,
0x0000005c0dff7212ULL, 0x000fe4000782c0ffULL, 0xff80000057577808ULL, 0x000fe40002800000ULL,
0x0000005a0b00720cULL, 0x000fe40000f21470ULL, 0x000054106e6e7816ULL, 0x008fe40000000073ULL,
0x000054105e5e7816ULL, 0x000fc40000000071ULL, 0x0000006e09ff7212ULL, 0x040fe4000788c0ffULL,
0x0000005e09ff7212ULL, 0x080fe4000784c0ffULL, 0x0000005e0dff7212ULL, 0x000fe400078ac0ffULL,
0x0000005a5d00720cULL, 0x0c0fe40001741470ULL, 0x0000005a5d00720cULL, 0x080fe40002781470ULL,
0x0000005a0b00720cULL, 0x000fc40002fa1470ULL, 0x0000005a5b00720cULL, 0x0c0fe40001741070ULL,
0x0000005a5b00720cULL, 0x080fe40002781070ULL, 0x0000005a8b00720cULL, 0x0c0fe40000f21070ULL,
0x0000005a8b00720cULL, 0x000fe40002fa1070ULL, 0x000054106f707816ULL, 0x000fe40000000070ULL,
0xff8000002a2a7808ULL, 0x000fc40001000000ULL, 0xff80000035357808ULL, 0x000fe40002000000ULL,
0xff80000056567808ULL, 0x000fe40000800000ULL, 0xff80000049497808ULL, 0x000fe40002800000ULL,
0x0000005c6bff7212ULL, 0x000fe4000786c0ffULL, 0x0000007009ff7212ULL, 0x000fe4000780c0ffULL,
0x0000006e0dff7212ULL, 0x000fc4000784c0ffULL, 0x000000700dff7212ULL, 0x000fe4000788c0ffULL,
0x0000005e91ff7212ULL, 0x000fe4000782c0ffULL, 0x0000006e6bff7212ULL, 0x000fe200078ac0ffULL,
0x0000000175087824ULL, 0x100fe200078e0a0eULL, 0x0000005a5d00720cULL, 0x080fe20000701470ULL,
0x00000001970a7824ULL, 0x000fe200078e0a0eULL, 0x0000005a0b00720cULL, 0x0c0fe40001741470ULL,
0x0000005a0b00720cULL, 0x000fc40002781470ULL, 0x0000005a0f00720cULL, 0x0c0fe40001f61470ULL,
0x0000005a0f00720cULL, 0x080fe40002fa1470ULL, 0x0000005a6d00720cULL, 0x080fe40000f21470ULL,
0x000000185b9b7812ULL, 0x040fe400078efcffULL, 0x000000195ba17812ULL, 0x040fe400078efcffULL,
0x0000005a5b00720cULL, 0x000fc40000701070ULL, 0x0000005a8b00720cULL, 0x0c0fe40001741070ULL,
0x0000005a8b00720cULL, 0x080fe40002781070ULL, 0x0000005a8d00720cULL, 0x0c0fe40001f61070ULL,
0x0000005a8d00720cULL, 0x080fe40002fa1070ULL, 0x0000005a8f00720cULL, 0x000fe40000f21070ULL,
0x00000008cf937219ULL, 0x000fc400000006ffULL, 0x0000000acf997219ULL, 0x000fe400000006ffULL,
0x0000541072727816ULL, 0x000fe40000000079ULL, 0x0000541074747816ULL, 0x000fe4000000007bULL,
0x000058009b9d7a10ULL, 0x000fe40007ffe0ffULL, 0x00005800a1a37a10ULL, 0x000fe40007ffe0ffULL,
0xff80000026267808ULL, 0x000fc40000000000ULL, 0xff80000034347808ULL, 0x000fe40001000000ULL,
0xff80000027277808ULL, 0x000fe40002000000ULL, 0xff80000055557808ULL, 0x000fe40001800000ULL,
0xff80000036367808ULL, 0x000fe40002800000ULL, 0xff8000002d2d7808ULL, 0x000fe40000800000ULL,
0x0000005e6bff7212ULL, 0x000fc4000780c0ffULL, 0x0000006e91ff7212ULL, 0x000fe4000784c0ffULL,
0x000000706bff7212ULL, 0x080fe4000788c0ffULL, 0x0000007091ff7212ULL, 0x000fe4000786c0ffULL,
0x0000007299ff7212ULL, 0x000fe400078ac0ffULL, 0x0000007493ff7212ULL, 0x000fe2000782c0ffULL,
0x000000019d0c7824ULL, 0x100fe200078e0a0eULL, 0x0000005a0f00720cULL, 0x080fe20000701470ULL,
0x00000001a30e7824ULL, 0x000fe200078e0a0eULL, 0x0000005a0f00720cULL, 0x000fc40002781470ULL,
0x0000005a6d00720cULL, 0x0c0fe40001741470ULL, 0x0000005a6d00720cULL, 0x080fe40001f61470ULL,
0x0000005a7500720cULL, 0x080fe40000f21470ULL, 0x0000005a9700720cULL, 0x080fe40002fa1470ULL,
0x0000005a8d00720cULL, 0x0c0fe40000701070ULL, 0x0000005a8d00720cULL, 0x000fc40002781070ULL,
0x0000005a8f00720cULL, 0x0c0fe40001741070ULL, 0x0000005a8f00720cULL, 0x080fe40001f61070ULL,
0x0000005a7700720cULL, 0x080fe40000f21070ULL, 0x0000005a9500720cULL, 0x000fe40002fa1070ULL,
0x0000000ccf9f7219ULL, 0x040fe400000006ffULL, 0x0000000ecfa57219ULL, 0x000fc400000006ffULL,
0x0000541076767816ULL, 0x000fe4000000007dULL, 0x0000541078787816ULL, 0x000fe40000000083ULL,
0xff8000002b2b7808ULL, 0x000fe40000000000ULL, 0xff8000001b1b7808ULL, 0x000fe40002000000ULL,
0xff80000037377808ULL, 0x000fe40001000000ULL, 0xff80000024247808ULL, 0x000fc40001800000ULL,
0xff8000002c2c7808ULL, 0x000fe40000800000ULL, 0xff80000052527808ULL, 0x000fe40002800000ULL,
0x0000007293ff7212ULL, 0x080fe4000780c0ffULL, 0x000000729fff7212ULL, 0x000fe4000788c0ffULL,
0x0000007693ff7212ULL, 0x040fe4000784c0ffULL, 0x0000007893ff7212ULL, 0x000fc4000786c0ffULL,
0x0000007699ff7212ULL, 0x000fe4000782c0ffULL, 0x00000074a5ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001816c7824ULL, 0x000fe200078e0a6aULL, 0x0000005a7500720cULL, 0x0c0fe40000701470ULL,
0x0000005a7500720cULL, 0x0c0fe40001741470ULL, 0x0000005a7500720cULL, 0x080fe40001f61470ULL,
0x0000005a9700720cULL, 0x000fc40000f21470ULL, 0x0000005a9d00720cULL, 0x080fe40002781470ULL,
0x0000005aa300720cULL, 0x080fe40002fa1470ULL, 0x000000215ba97812ULL, 0x000fe400078efcffULL,
0x0000005a7700720cULL, 0x0c0fe40000701070ULL, 0x0000005a7700720cULL, 0x0c0fe40001741070ULL,
0x0000005a7700720cULL, 0x000fc40001f61070ULL, 0x0000005a9500720cULL, 0x080fe40000f21070ULL,
0x0000005a9b00720cULL, 0x080fe40002781070ULL, 0x0000005aa100720cULL, 0x000fe40002fa1070ULL,
0x0000006ccfa77219ULL, 0x000fe400000006ffULL, 0x0000541080807816ULL, 0x000fe400000000d1ULL,
0x00005800a9ab7a10ULL, 0x000fc40007ffe0ffULL, 0xff80000053537808ULL, 0x000fe40000000000ULL,
0xff80000038387808ULL, 0x000fe40001000000ULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff80000039397808ULL, 0x000fe40000800000ULL, 0xff80000051517808ULL, 0x000fe40002000000ULL,
0xff80000030307808ULL, 0x000fc40002800000ULL, 0x0000007499ff7212ULL, 0x040fe4000780c0ffULL,
0x0000007899ff7212ULL, 0x000fe4000784c0ffULL, 0x000000749fff7212ULL, 0x000fe4000786c0ffULL,
0x00000076a5ff7212ULL, 0x040fe4000782c0ffULL, 0x00000078a5ff7212ULL, 0x000fe4000788c0ffULL,
0x00000080a7ff7212ULL, 0x000fe200078ac0ffULL, 0x00000001ab7a7824ULL, 0x000fe200078e0a6aULL,
0x0000005a9700720cULL, 0x000fc40000701470ULL, 0x0000005a9700720cULL, 0x080fe40001741470ULL,
0x0000005a9d00720cULL, 0x080fe40001f61470ULL, 0x0000005aa300720cULL, 0x0c0fe40000f21470ULL,
0x0000005aa300720cULL, 0x080fe40002781470ULL, 0x0000005a8100720cULL, 0x000fe40002fa1470ULL,
0x000000285baf7812ULL, 0x000fc400078efcffULL, 0x000000295bb57812ULL, 0x000fe400078efcffULL,
0x0000005a9500720cULL, 0x0c0fe40000701070ULL, 0x0000005a9500720cULL, 0x080fe40001741070ULL,
0x0000005a9b00720cULL, 0x080fe40001f61070ULL, 0x0000005aa100720cULL, 0x0c0fe40000f21070ULL,
0x0000005aa100720cULL, 0x000fc40002781070ULL, 0x0000005a7f00720cULL, 0x000fe40002fa1070ULL,
0x0000007acfad7219ULL, 0x000fe400000006ffULL, 0x000054107e7e7816ULL, 0x000fe40000000085ULL,
0x0000541084847816ULL, 0x000fe400000000d5ULL, 0x0000541086867816ULL, 0x000fe400000000d9ULL,
0x00005800afb17a10ULL, 0x000fc40007ffe0ffULL, 0x00005800b5b77a10ULL, 0x000fe40007ffe0ffULL,
0xff80000048487808ULL, 0x000fe40000000000ULL, 0xff80000028287808ULL, 0x000fe40001000000ULL,
0xff8000002e2e7808ULL, 0x000fe40001800000ULL, 0xff8000003b3b7808ULL, 0x000fe40000800000ULL,
0xff8000001a1a7808ULL, 0x000fc40002000000ULL, 0xff8000002f2f7808ULL, 0x000fe40002800000ULL,
0x0000005c91ff7212ULL, 0x000fe400078cc0ffULL, 0x000000769fff7212ULL, 0x040fe4000780c0ffULL,
0x000000789fff7212ULL, 0x000fe4000784c0ffULL, 0x0000007ea7ff7212ULL, 0x040fe4000786c0ffULL,
0x00000084a7ff7212ULL, 0x000fc4000782c0ffULL, 0x00000086a7ff7212ULL, 0x000fe4000788c0ffULL,
0x00000084adff7212ULL, 0x000fe200078ac0ffULL, 0x00000001b17c7824ULL, 0x100fe200078e0a6aULL,
0x0000005a6d00720cULL, 0x080fe200037c1470ULL, 0x00000001b76a7824ULL, 0x000fe200078e0a6aULL,
0x0000005a9d00720cULL, 0x0c0fe40000701470ULL, 0x0000005a9d00720cULL, 0x080fe40001741470ULL,
0x0000005a8100720cULL, 0x000fc40001f61470ULL, 0x0000005a8100720cULL, 0x0c0fe40000f21470ULL,
0x0000005a8100720cULL, 0x080fe40002781470ULL, 0x0000005aab00720cULL, 0x080fe40002fa1470ULL,
0x0000005a8f00720cULL, 0x080fe400037c1070ULL, 0x0000005a9b00720cULL, 0x0c0fe40000701070ULL,
0x0000005a9b00720cULL, 0x000fc40001741070ULL, 0x0000005a7f00720cULL, 0x0c0fe40001f61070ULL,
0x0000005a7f00720cULL, 0x0c0fe40000f21070ULL, 0x0000005a7f00720cULL, 0x080fe40002781070ULL,
0x0000005aa900720cULL, 0x000fe40002fa1070ULL, 0x0000007ccfb37219ULL, 0x040fe400000006ffULL,
0x0000006acfb97219ULL, 0x000fc400000006ffULL, 0xff80000054547808ULL, 0x000fe40003000000ULL,
0xff8000003a3a7808ULL, 0x000fe40000000000ULL, 0xff80000025257808ULL, 0x000fe40001000000ULL,
0xff80000059597808ULL, 0x000fe40001800000ULL, 0xff8000003c3c7808ULL, 0x000fe40000800000ULL,
0xff80000019197808ULL, 0x000fc40002000000ULL, 0xff8000003d3d7808ULL, 0x000fe40002800000ULL,
0x00000072a5ff7212ULL, 0x000fe400078cc0ffULL, 0x0000007eadff7212ULL, 0x080fe4000780c0ffULL,
0x0000007eb3ff7212ULL, 0x000fe4000784c0ffULL, 0x00000080adff7212ULL, 0x040fe4000786c0ffULL,
0x00000086adff7212ULL, 0x000fc4000782c0ffULL, 0x00000080b3ff7212ULL, 0x000fe4000788c0ffULL,
0x00000084b9ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000189887824ULL, 0x000fe200078e0a82ULL,
0x0000005aa300720cULL, 0x080fe400037c1470ULL, 0x0000005aab00720cULL, 0x0c0fe40000701470ULL,
0x0000005aab00720cULL, 0x0c0fe40001f61470ULL, 0x0000005aab00720cULL, 0x000fc40000f21470ULL,
0x0000005ab100720cULL, 0x0c0fe40001741470ULL, 0x0000005ab100720cULL, 0x080fe40002781470ULL,
0x0000005ab700720cULL, 0x000fe40002fa1470ULL, 0x000000315bbf7812ULL, 0x040fe400078efcffULL,
0x000000385bc57812ULL, 0x040fe400078efcffULL, 0x000000395bcb7812ULL, 0x000fc400078efcffULL,
0x0000005aa100720cULL, 0x080fe400037c1070ULL, 0x0000005aa900720cULL, 0x0c0fe40000701070ULL,
0x0000005aa900720cULL, 0x0c0fe40001f61070ULL, 0x0000005aa900720cULL, 0x080fe40000f21070ULL,
0x0000005aaf00720cULL, 0x0c0fe40001741070ULL, 0x0000005aaf00720cULL, 0x000fc40002781070ULL,
0x0000005ab500720cULL, 0x000fe40002fa1070ULL, 0x00000088cfbd7219ULL, 0x000fe400000006ffULL,
0x00005410bb8e7816ULL, 0x000fe4000000008eULL, 0x00005410d7927816ULL, 0x000fe40000000092ULL,
0x00005800bfc17a10ULL, 0x000fe40007ffe0ffULL, 0x00005800c5c77a10ULL, 0x000fc40007ffe0ffULL,
0x00005800cbcd7a10ULL, 0x000fe40007ffe0ffULL, 0xff80000058587808ULL, 0x000fe40003000000ULL,
0xff80000050507808ULL, 0x000fe40000000000ULL, 0xff80000047477808ULL, 0x000fe40001800000ULL,
0xff80000018187808ULL, 0x000fe40000800000ULL, 0xff8000004f4f7808ULL, 0x000fc40001000000ULL,
0xff80000031317808ULL, 0x000fe40002000000ULL, 0xff8000003f3f7808ULL, 0x000fe40002800000ULL,
0x0000007eb9ff7212ULL, 0x040fe400078cc0ffULL, 0x00000080b9ff7212ULL, 0x000fe4000780c0ffULL,
0x00000084b3ff7212ULL, 0x040fe4000786c0ffULL, 0x00000086b3ff7212ULL, 0x000fc4000782c0ffULL,
0x00000086b9ff7212ULL, 0x000fe4000784c0ffULL, 0x0000008ebdff7212ULL, 0x040fe4000788c0ffULL,
0x00000092bdff7212ULL, 0x000fe200078ac0ffULL, 0x00000001c18a7824ULL, 0x100fe200078e0a82ULL,
0x0000005ab100720cULL, 0x080fe20001f61470ULL, 0x00000001c78c7824ULL, 0x100fe200078e0a82ULL,
0x0000005ab100720cULL, 0x080fe20000f21470ULL, 0x00000001cd827824ULL, 0x000fe200078e0a82ULL,
0x0000005ab700720cULL, 0x000fc400037c1470ULL, 0x0000005ab700720cULL, 0x0c0fe40000701470ULL,
0x0000005ab700720cULL, 0x080fe40001741470ULL, 0x0000005a8900720cULL, 0x0c0fe40002781470ULL,
0x0000005a8900720cULL, 0x000fe40002fa1470ULL, 0x0000008acfc37219ULL, 0x040fe400000006ffULL,
0x0000008ccfc97219ULL, 0x000fc400000006ffULL, 0x0000005aaf00720cULL, 0x0c0fe40001f61070ULL,
0x0000005aaf00720cULL, 0x080fe40000f21070ULL, 0x0000005ab500720cULL, 0x0c0fe400037c1070ULL,
0x0000005ab500720cULL, 0x0c0fe40000701070ULL, 0x0000005ab500720cULL, 0x080fe40001741070ULL,
0x0000005a8700720cULL, 0x000fc40002781070ULL, 0x0000005a8700720cULL, 0x000fe40002fa1070ULL,
0x00000082cfcf7219ULL, 0x000fe400000006ffULL, 0x00005410d3907816ULL, 0x000fe40000000090ULL,
0xff8000003e3e7808ULL, 0x000fe40001800000ULL, 0xff80000012127808ULL, 0x000fe40000800000ULL,
0xff8000004e4e7808ULL, 0x000fc40003000000ULL, 0xff80000040407808ULL, 0x000fe40000000000ULL,
0xff80000013137808ULL, 0x000fe40001000000ULL, 0xff8000004d4d7808ULL, 0x000fe40002000000ULL,
0xff80000046467808ULL, 0x000fe40002800000ULL, 0x0000008ec3ff7212ULL, 0x080fe4000786c0ffULL,
0x0000008ec9ff7212ULL, 0x000fc4000782c0ffULL, 0x0000008ecfff7212ULL, 0x000fe400078cc0ffULL,
0x00000090bdff7212ULL, 0x080fe4000780c0ffULL, 0x00000090c3ff7212ULL, 0x080fe4000784c0ffULL,
0x00000090c9ff7212ULL, 0x000fe4000788c0ffULL, 0x00000092c3ff7212ULL, 0x000fe400078ac0ffULL,
0x0000005a8900720cULL, 0x000fc40000701470ULL, 0x0000005ac100720cULL, 0x0c0fe40001f61470ULL,
0x0000005ac100720cULL, 0x0c0fe40001741470ULL, 0x0000005ac100720cULL, 0x080fe40002fa1470ULL,
0x0000005ac700720cULL, 0x080fe40000f21470ULL, 0x0000005acd00720cULL, 0x080fe400037c1470ULL,
0x0000005ac700720cULL, 0x000fc40002781470ULL, 0x0000005a8700720cULL, 0x080fe40000701070ULL,
0x0000005abf00720cULL, 0x0c0fe40001f61070ULL, 0x0000005abf00720cULL, 0x0c0fe40001741070ULL,
0x0000005abf00720cULL, 0x080fe40002fa1070ULL, 0x0000005ac500720cULL, 0x080fe40000f21070ULL,
0x0000005acb00720cULL, 0x000fc400037c1070ULL, 0x0000005ac500720cULL, 0x000fe40002781070ULL,
0x00005410db947816ULL, 0x000fe40000000094ULL, 0xff80000032327808ULL, 0x000fe40000000000ULL,
0xff8000004c4c7808ULL, 0x000fe40001800000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff80000041417808ULL, 0x000fc40002800000ULL, 0xff8000004b4b7808ULL, 0x000fe40000800000ULL,
0xff8000004a4a7808ULL, 0x000fe40003000000ULL, 0xff80000045457808ULL, 0x000fe40002000000ULL,
0x00000090cfff7212ULL, 0x000fe4000780c0ffULL, 0x00000092c9ff7212ULL, 0x080fe4000786c0ffULL,
0x00000092cfff7212ULL, 0x000fc4000784c0ffULL, 0x00000094bdff7212ULL, 0x080fe400078ac0ffULL,
0x00000094c3ff7212ULL, 0x080fe4000782c0ffULL, 0x00000094c9ff7212ULL, 0x080fe400078cc0ffULL,
0x00000094cfff7212ULL, 0x000fe4000788c0ffULL, 0x0000005a8900720cULL, 0x080fe40002fa1470ULL,
0x0000005ac100720cULL, 0x000fc40000f21470ULL, 0x0000005ac700720cULL, 0x0c0fe40001f61470ULL,
0x0000005ac700720cULL, 0x080fe400037c1470ULL, 0x0000005acd00720cULL, 0x0c0fe40000701470ULL,
0x0000005acd00720cULL, 0x0c0fe40001741470ULL, 0x0000005acd00720cULL, 0x080fe40002781470ULL,
0x0000005a8700720cULL, 0x000fc40002fa1070ULL, 0x0000005abf00720cULL, 0x080fe40000f21070ULL,
0x0000005acb00720cULL, 0x080fe40000701070ULL, 0x0000005ac500720cULL, 0x0c0fe40001f61070ULL,
0x0000005ac500720cULL, 0x080fe400037c1070ULL, 0x0000005acb00720cULL, 0x0c0fe40001741070ULL,
0x0000005acb00720cULL, 0x000fc40002781070ULL, 0xff80000044447808ULL, 0x000fe40000000000ULL,
0xff80000042427808ULL, 0x000fe40001800000ULL, 0xff80000043437808ULL, 0x000fe40001000000ULL,
0xff80000014147808ULL, 0x000fe40002800000ULL, 0xff80000015157808ULL, 0x000fe40000800000ULL,
0xff80000016167808ULL, 0x000fc40003000000ULL, 0xff80000017177808ULL, 0x000fc40002000000ULL,
0x000000570400720bULL, 0x004fe20003f1e000ULL, 0x0000001fff5a7424ULL, 0x000fe200078e00ffULL,
0x0000002a0500720bULL, 0x000fe20003f3e000ULL, 0xffffffffff5b7424ULL, 0x000fe200078e00ffULL,
0x000000350600720bULL, 0x000fe40003f5e000ULL, 0x000000260700720bULL, 0x000fe40003f7e000ULL,
0x0000000457097208ULL, 0x000fe40004000000ULL, 0x000000052a047208ULL, 0x000fc40004800000ULL,
0x0000000635057208ULL, 0x000fe40005000000ULL, 0x0000000726067208ULL, 0x000fe40005800000ULL,
0x000000560900720bULL, 0x000fe40003f1e000ULL, 0x000000490400720bULL, 0x000fe40003f3e000ULL,
0x000000340500720bULL, 0x000fe40003f5e000ULL, 0x000000270600720bULL, 0x000fc40003f7e000ULL,
0x0000000956087208ULL, 0x000fe40004000000ULL, 0x0000000449047208ULL, 0x000fe40004800000ULL,
0x0000000534057208ULL, 0x000fe40005000000ULL, 0x0000000627067208ULL, 0x000fe40005800000ULL,
0x000000550800720bULL, 0x000fe40003f1e000ULL, 0x0000002b0400720bULL, 0x000fc40003f3e000ULL,
0x000000360500720bULL, 0x000fe40003f5e000ULL, 0x0000001b0600720bULL, 0x000fe40003f7e000ULL,
0x0000000855077208ULL, 0x000fe40004000000ULL, 0x000000042b047208ULL, 0x000fe40004800000ULL,
0x0000000536087208ULL, 0x000fe40005000000ULL, 0x000000061b057208ULL, 0x000fc40005800000ULL,
0x000000540700720bULL, 0x000fe40003f1e000ULL, 0x0000002d0400720bULL, 0x000fe40003f3e000ULL,
0x000000370800720bULL, 0x000fe40003f5e000ULL, 0x000000240500720bULL, 0x000fe40003f7e000ULL,
0x0000000754067208ULL, 0x000fe40004000000ULL, 0x000000042d077208ULL, 0x000fc40004800000ULL,
0x0000000837097208ULL, 0x000fe40005000000ULL, 0x0000000524047208ULL, 0x000fe40005800000ULL,
0x000000530600720bULL, 0x000fe40003f1e000ULL, 0x0000002c0700720bULL, 0x000fe40003f3e000ULL,
0x000000380900720bULL, 0x000fe40003f5e000ULL, 0x000000290400720bULL, 0x000fc40003f7e000ULL,
0x0000000653057208ULL, 0x000fe40004000000ULL, 0x000000072c077208ULL, 0x000fe40004800000ULL,
0x0000000938067208ULL, 0x000fe40005000000ULL, 0x0000000429097208ULL, 0x000fe40005800000ULL,
0x000000520500720bULL, 0x000fe40003f1e000ULL, 0x000000480700720bULL, 0x000fc40003f3e000ULL,
0x000000390600720bULL, 0x000fe40003f5e000ULL, 0x000000280900720bULL, 0x000fe40003f7e000ULL,
0x0000000552047208ULL, 0x000fe40004000000ULL, 0x0000000748077208ULL, 0x000fe40004800000ULL,
0x0000000639057208ULL, 0x000fe40005000000ULL, 0x0000000928067208ULL, 0x000fc40005800000ULL,
0x000000510400720bULL, 0x000fe40003f1e000ULL, 0x0000002e0700720bULL, 0x000fe40003f3e000ULL,
0x0000003a0500720bULL, 0x000fe40003f5e000ULL, 0x000000250600720bULL, 0x000fe40003f7e000ULL,
0x0000000451097208ULL, 0x000fe40004000000ULL, 0x000000072e077208ULL, 0x000fc40004800000ULL,
0x000000053a047208ULL, 0x000fe40005000000ULL, 0x0000000625057208ULL, 0x000fe40005800000ULL,
0x000000580900720bULL, 0x000fe40003f1e000ULL, 0x000000300700720bULL, 0x000fe40003f3e000ULL,
0x0000003b0400720bULL, 0x000fe40003f5e000ULL, 0x0000001a0500720bULL, 0x000fc40003f7e000ULL,
0x0000000958067208ULL, 0x000fe40004000000ULL, 0x0000000730087208ULL, 0x000fe40004800000ULL,
0x000000043b077208ULL, 0x000fe40005000000ULL, 0x000000051a047208ULL, 0x000fe40005800000ULL,
0x000000590600720bULL, 0x000fe40003f1e000ULL, 0x0000002f0800720bULL, 0x000fc40003f3e000ULL,
0x0000003c0700720bULL, 0x000fe40003f5e000ULL, 0x000000190400720bULL, 0x000fe40003f7e000ULL,
0x0000000659057208ULL, 0x000fe40004000000ULL, 0x000000082f087208ULL, 0x000fe40004800000ULL,
0x000000073c067208ULL, 0x000fe40005000000ULL, 0x0000000419077208ULL, 0x000fc40005800000ULL,
0x000000500500720bULL, 0x000fe40003f1e000ULL, 0x000000470800720bULL, 0x000fe40003f3e000ULL,
0x0000003d0600720bULL, 0x000fe40003f5e000ULL, 0x000000180700720bULL, 0x000fe40003f7e000ULL,
0x0000000550047208ULL, 0x000fe40004000000ULL, 0x0000000847087208ULL, 0x000fc40004800000ULL,
0x000000063d057208ULL, 0x000fe40005000000ULL, 0x0000000718077208ULL, 0x000fe40005800000ULL,
0x0000004f0400720bULL, 0x000fe40003f1e000ULL, 0x000000310800720bULL, 0x000fe40003f3e000ULL,
0x0000003e0500720bULL, 0x000fe40003f5e000ULL, 0x000000120700720bULL, 0x000fc40003f7e000ULL,
0x000000044f097208ULL, 0x000fe40004000000ULL, 0x00000008310b7208ULL, 0x000fe40004800000ULL,
0x000000053e047208ULL, 0x000fe40005000000ULL, 0x0000000712067208ULL, 0x000fe40005800000ULL,
0x0000004e0900720bULL, 0x000fe40003f1e000ULL, 0x000000400b00720bULL, 0x000fc40003f3e000ULL,
0x0000003f0400720bULL, 0x000fe40003f5e000ULL, 0x000000130600720bULL, 0x000fe40003f7e000ULL,
0x000000094e087208ULL, 0x000fe40004000000ULL, 0x0000000b400b7208ULL, 0x000fe40004800000ULL,
0x000000043f057208ULL, 0x000fe40005000000ULL, 0x0000000613077208ULL, 0x000fc40005800000ULL,
0x0000004d0800720bULL, 0x000fe40003f1e000ULL, 0x000000320b00720bULL, 0x000fe40003f3e000ULL,
0x000000460500720bULL, 0x000fe40003f5e000ULL, 0x000000140700720bULL, 0x000fe40003f7e000ULL,
0x000000084d097208ULL, 0x000fe40004000000ULL, 0x0000000b32047208ULL, 0x000fc40004800000ULL,
0x0000000546067208ULL, 0x000fe40005000000ULL, 0x0000000714087208ULL, 0x000fe40005800000ULL,
0x000000330400720bULL, 0x000fe40003f3e000ULL, 0x0000004c0900720bULL, 0x000fe40003f1e000ULL,
0x000000410600720bULL, 0x000fe40003f5e000ULL, 0x000000150800720bULL, 0x000fc40003f7e000ULL,
0x0000000433047208ULL, 0x000fe40004800000ULL, 0x000000094c0a7208ULL, 0x000fe40004000000ULL,
0x0000000641057208ULL, 0x000fe40005000000ULL, 0x0000000815077208ULL, 0x000fe40005800000ULL,
0x000000450400720bULL, 0x000fe40003f3e000ULL, 0x0000004b0a00720bULL, 0x000fc40003f1e000ULL,
0x000000420500720bULL, 0x000fe40003f5e000ULL, 0x000000160700720bULL, 0x000fe40003f7e000ULL,
0x00000004450b7208ULL, 0x000fe40004800000ULL, 0x0000000a4b097208ULL, 0x000fe40004000000ULL,
0x0000000542047208ULL, 0x000fe40005000000ULL, 0x0000000716067208ULL, 0x000fc40005800000ULL,
0x0000004a0900720bULL, 0x000fe40003f1e000ULL, 0x000000440b00720bULL, 0x000fe40003f3e000ULL,
0x000000430400720bULL, 0x000fe40003f5e000ULL, 0x000000170600720bULL, 0x000fe40003f7e000ULL,
0x000000094a077208ULL, 0x000fe40004000000ULL, 0x0000000b440a7208ULL, 0x000fc40004800000ULL,
0x00000004430e7208ULL, 0x000fe40005000000ULL, 0x00000006170d7208ULL, 0x000fe20005800000ULL,
0x000020027f007947ULL, 0x000fea000b800000ULL, 0x0c401f0007047f89ULL, 0x0004e400000e0000ULL,
0x000000040700720bULL, 0x008fc80003f1e000ULL, 0x00000007040f7208ULL, 0x000fe20004000000ULL,
0x000020127f007947ULL, 0x000fea000b800000ULL, 0x0c401f000a047f89ULL, 0x000ee800000e0000ULL,
0x0c401f000e057f89ULL, 0x000e6800000e0000ULL, 0x0c401f000d067f89ULL, 0x000ea200000e0000ULL,
0x000000040a00720bULL, 0x008fc40003f1e000ULL, 0x000000050e00720bULL, 0x002fe40003f3e000ULL,
0x0000000a04077208ULL, 0x004fe40004000000ULL, 0x0000000e05087208ULL, 0x000fe20004800000ULL,
0x0c201f000f047f89ULL, 0x000e6200000e0000ULL, 0x000000060d00720bULL, 0x000fc60003f1e000ULL,
0x0c201f00070c7f89ULL, 0x000ea200000e0000ULL, 0x0000000d060a7208ULL, 0x000fc60004000000ULL,
0x0c201f0008097f89ULL, 0x000ee800000e0000ULL, 0x0c201f000a0b7f89ULL, 0x0002e400000e0000ULL,
0x000000040f00720bULL, 0x002fe40003f1e000ULL, 0x0000000c0700720bULL, 0x004fe40003f3e000ULL,
0x0000000f04047208ULL, 0x000fc40004000000ULL, 0x000000090800720bULL, 0x008fe40003f5e000ULL,
0x000000070c057208ULL, 0x000fe40004800000ULL, 0x0000000809067208ULL, 0x000fc60005000000ULL,
0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL, 0x0000000b0a00720bULL, 0x004fe20003f1e000ULL,
0x3fb8aa3b060d7820ULL, 0x000fe20000410000ULL, 0x00000002ff5f7819ULL, 0x000fe2000001161fULL,
0x3fb8aa3b510c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b57577823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b56567823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b55557823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b54547823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b52527823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b58587823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b59517823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b4b4b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b4a4a7823ULL, 0x000fe20000010807ULL,
0x3fb8aa3b05077820ULL, 0x000fe20000410000ULL, 0x0000005700087308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b35357823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b34347823ULL, 0x000fe2000001080dULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b49497823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2b2b7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b48487823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010807ULL,
0x3fb8aa3b45457823ULL, 0x100fe20000010807ULL, 0x3fb8aa3b44077823ULL, 0x000fe20000010807ULL,
0x0000000c00577308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b36367823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b37377823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b38387823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b39397823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b3c3c7823ULL, 0x100fe2000001080dULL,
0x0000000700447308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b3f3f7823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b46467823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b41417823ULL, 0x100fe2000001080dULL,
0x3fb8aa3b42427823ULL, 0x100fe2000001080dULL, 0x3fb8aa3b430d7823ULL, 0x000fe2000001080dULL,
0x0000002d000c7308ULL, 0x0005e20000000800ULL, 0x0000000a0b077208ULL, 0x002fe20004000000ULL,
0x000000085f6a7824ULL, 0x040fe200078e00ffULL, 0x000000025f0b7810ULL, 0x040fe20007ffe0ffULL,
0x000000085f6c7824ULL, 0x040fe200078e00ffULL, 0x000000015f0a7810ULL, 0x040fe20007ffe0ffULL,
0x000000085f707824ULL, 0x000fe200078e00ffULL, 0xfffffff86a6a7812ULL, 0x000fe200078ee20bULL,
0x0000002b002b7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b072d7820ULL, 0x004fe20000410000ULL,
0x000000085f727824ULL, 0x040fe200078e00ffULL, 0x000000055f0b7810ULL, 0x000fe20007ffe0ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x3fb8aa3b1b1b7823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b27277823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b24247823ULL, 0x000fe2000001082dULL, 0x0000005600097308ULL, 0x000ea20000000800ULL,
0xfffffff870707812ULL, 0x000fe200078ee20bULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b29297823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b28287823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b1a1a7823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b19197823ULL, 0x100fe2000001082dULL,
0x0000002b0c0b723eULL, 0x002fe200000000ffULL, 0x0000004800597308ULL, 0x000fe20000000800ULL,
0xffffffff5f0c7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b12127823ULL, 0x000fe2000001082dULL,
0x0000000c11117812ULL, 0x000fc400078ec0ffULL, 0x000000031fff7812ULL, 0x000fc6000780c0ffULL,
0x0000000d00437308ULL, 0x0003e20000000800ULL, 0x000000080908723eULL, 0x004fce00000000ffULL,
0x0000005500557308ULL, 0x000fe20000000800ULL, 0x000000035f0d7810ULL, 0x002fc80007ffe0ffULL,
0xfffffff86c6c7812ULL, 0x000fe400078ee20dULL, 0x000000065f0d7810ULL, 0x040fe20007ffe0ffULL,
0x0000005400547308ULL, 0x000fe60000000800ULL, 0xfffffff872727812ULL, 0x000fe200078ee20dULL,
0x000000085f0d7824ULL, 0x000fc800078e00ffULL, 0x0000002a002a7308ULL, 0x000fe20000000800ULL,
0xfffffff80d747812ULL, 0x000fce00078ee20cULL, 0x0000004900497308ULL, 0x000e700000000800ULL,
0x00000030005b7308ULL, 0x000ff00000000800ULL, 0x0000004700567308ULL, 0x000fe20000000800ULL,
0x0000002a4909723eULL, 0x002fce00000000ffULL, 0x0000003200487308ULL, 0x000ff00000000800ULL,
0x00000035000e7308ULL, 0x0003f00000000800ULL, 0x00000034000f7308ULL, 0x0004e20000000800ULL,
0x000000085f357824ULL, 0x002fca00078e00ffULL, 0xfffffff8355e7812ULL, 0x000fe200078ee20aULL,
0x3c003c00ff357424ULL, 0x000fe200078e00ffULL, 0x0000003600367308ULL, 0x000fe20000000800ULL,
0x000000045f0a7810ULL, 0x000fe20007ffe0ffULL, 0x3c003c00ff347424ULL, 0x004fcc00078e00ffULL,
0x0000003700377308ULL, 0x000e620000000800ULL, 0x0000000e0f0c723eULL, 0x008fce00000000ffULL,
0x0000002600307308ULL, 0x000ff00000000800ULL, 0x0000002700477308ULL, 0x0004e20000000800ULL,
0x00000036370e723eULL, 0x002fce00000000ffULL, 0x0000001b001b7308ULL, 0x000fe20000000800ULL,
0x000000085f277824ULL, 0x004fca00078e00ffULL, 0xfffffff8276e7812ULL, 0x000fe400078ee20aULL,
0x0000002400327308ULL, 0x000e620000000800ULL, 0x00000055540a723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b16547823ULL, 0x100fe2000001082dULL, 0x00000030470d723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b13307823ULL, 0x100fe2000001082dULL, 0x3fb8aa3b15477823ULL, 0x100fe2000001082dULL,
0x3fb8aa3b17557823ULL, 0x000fe4000001082dULL, 0x00000025005c7308ULL, 0x0005e20000000800ULL,
0x0000001b320f723eULL, 0x002fce00000000ffULL, 0x00000029005a7308ULL, 0x000fe20000000800ULL,
0x000000340824723cULL, 0x004f6200000018ffULL, 0x3fb8aa3b14327823ULL, 0x000fcc000001082dULL,
0x00000028005d7308ULL, 0x0003f00000000800ULL, 0x0000005300537308ULL, 0x000fe20000000800ULL,
0x000000340c28723cULL, 0x002f6e00000018ffULL, 0x0000005200527308ULL, 0x000e700000000800ULL,
0x0000005800587308ULL, 0x000eb00000000800ULL, 0x0000002c002c7308ULL, 0x000ee20000000800ULL,
0x000000535214723eULL, 0x002fe200000000ffULL, 0x000000085f527824ULL, 0x000fca00078e00ffULL,
0xfffffff852527812ULL, 0x000fe200078ee25fULL, 0x0000002e002e7308ULL, 0x000e620000000800ULL,
0x000000575816723eULL, 0x004fe400000000ffULL, 0x000000085f587810ULL, 0x000fca0007ffe0ffULL,
0x0000003800387308ULL, 0x000fe20000000800ULL, 0x0000002c5915723eULL, 0x008fce00000000ffULL,
0x0000003900397308ULL, 0x000ea20000000800ULL, 0x0000002e5b17723eULL, 0x002fce00000000ffULL,
0x0000003a003a7308ULL, 0x000fe20000000800ULL, 0x000000341424723cULL, 0x020f6e0000001824ULL,
0x0000003b003b7308ULL, 0x000ff00000000800ULL, 0x0000001a00497308ULL, 0x0002f00000000800ULL,
0x0000001900367308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b181a7823ULL, 0x002fe2000001082dULL,
0x000000383918723eULL, 0x004fe200000000ffULL, 0x00000008582d7824ULL, 0x000fca00078e00ffULL,
0x0000001a00137308ULL, 0x0002a20000000800ULL, 0x0000005a5d19723eULL, 0x008fe400000000ffULL,
0x0000005c491b723eULL, 0x000fe400000000ffULL, 0x000000105f5a7810ULL, 0x000fe40007ffe0ffULL,
0xfffffff82d587812ULL, 0x000fe200078ee258ULL, 0x0000002f002f7308ULL, 0x000ee20000000800ULL,
0x0000003a3b1a723eULL, 0x002fe200000000ffULL, 0x000000085a397824ULL, 0x000fe200078e00ffULL,
0x000000185f5f7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff8395a7812ULL, 0x000fe200078ee25aULL,
0x0000005100517308ULL, 0x000fe20000000800ULL, 0x000000341828723cULL, 0x000f620000001828ULL,
0x000000361339723eULL, 0x004fe200000000ffULL, 0x000000085f5c7824ULL, 0x000fca00078e00ffULL,
0x0000005000507308ULL, 0x000e620000000800ULL, 0x0000002f562d723eULL, 0x008fe400000000ffULL,
0xfffffff85c5c7812ULL, 0x000fca00078ee25fULL, 0x0000004f004f7308ULL, 0x000ff00000000800ULL,
0x0000004e004e7308ULL, 0x000ea20000000800ULL, 0x00000051502c723eULL, 0x002fce00000000ffULL,
0x0000003100317308ULL, 0x000ff00000000800ULL, 0x0000004000407308ULL, 0x000e620000000800ULL,
0x0000004f4e2e723eULL, 0x004fce00000000ffULL, 0x0000003c003c7308ULL, 0x000ff00000000800ULL,
0x0000003d003d7308ULL, 0x000ea20000000800ULL, 0x00000031402f723eULL, 0x002fce00000000ffULL,
0x0000003e003e7308ULL, 0x000fe20000000800ULL, 0x000000342c24723cULL, 0x020f6e0000001824ULL,
0x0000003f003f7308ULL, 0x000e620000000800ULL, 0x0000003c3d38723eULL, 0x004fe400000000ffULL,
0x0000a000203d7811ULL, 0x000fca00078e60ffULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x0000001052527824ULL, 0x100fe400078e023dULL, 0x000000105e5e7824ULL, 0x100fe400078e023dULL,
0x000000106a6a7824ULL, 0x100fe400078e023dULL, 0x000000106c6c7824ULL, 0x100fe200078e023dULL,
0x00000030003b7308ULL, 0x000ea20000000800ULL, 0x0000003e3f3a723eULL, 0x002fe200000000ffULL,
0x000000106e6e7824ULL, 0x000fc400078e023dULL, 0x0000001070707824ULL, 0x100fe400078e023dULL,
0x0000001072727824ULL, 0x000fe400078e023dULL, 0x0000004d004d7308ULL, 0x000fe20000000800ULL,
0x0000000152137824ULL, 0x000fe400078e0211ULL, 0x0000001074747824ULL, 0x100fe400078e023dULL,
0x0000001058587824ULL, 0x100fe200078e023dULL, 0x0000000813007388ULL, 0x0003e20000000800ULL,
0x000000105a5a7824ULL, 0x100fe200078e023dULL, 0x0000004c004c7308ULL, 0x000ee20000000800ULL,
0x000000123b3b723eULL, 0x004fe200000000ffULL, 0x000000105c5c7824ULL, 0x000fc400078e023dULL,
0x00000001115e7824ULL, 0x040fe400078e025eULL, 0x00000001116a7824ULL, 0x040fe400078e026aULL,
0x0000003300337308ULL, 0x000ea20000000800ULL, 0x000000343828723cULL, 0x000fe20000001828ULL,
0x00000001116c7824ULL, 0x040fe200078e026cULL, 0x0000000a5e007388ULL, 0x0003e20000000800ULL,
0x00000001116e7824ULL, 0x040fe400078e026eULL, 0x0000000111707824ULL, 0x040fe200078e0270ULL,
0x000000146a007388ULL, 0x0003e20000000800ULL, 0x0000004b004b7308ULL, 0x000fe20000000800ULL,
0x0000004d4c30723eULL, 0x008fe200000000ffULL, 0x0000000111727824ULL, 0x040fe200078e0272ULL,
0x000000166c007388ULL, 0x0007e20000000800ULL, 0x0000000111747824ULL, 0x000fc400078e0274ULL,
0x0000000111587824ULL, 0x000fe200078e0258ULL, 0x0000002c6e007388ULL, 0x0007e20000000800ULL,
0x0000004a004a7308ULL, 0x000fe20000000800ULL, 0x000000483331723eULL, 0x004fe200000000ffULL,
0x0000000111137824ULL, 0x042fe200078e025aULL, 0x0000002e70007388ULL, 0x0007e20000000800ULL,
0x00000001115c7824ULL, 0x000fc600078e025cULL, 0x0000003072007388ULL, 0x0007e20000000800ULL,
0x0000004500457308ULL, 0x000e700000000800ULL, 0x0000004600467308ULL, 0x000ff00000000800ULL,
0x0000004100417308ULL, 0x000ea20000000800ULL, 0x000000454433723eULL, 0x002fce00000000ffULL,
0x0000004200427308ULL, 0x000e700000000800ULL, 0x0000003200377308ULL, 0x0003e20000000800ULL,
0x00000046413c723eULL, 0x004fce00000000ffULL, 0x00000047004c7308ULL, 0x000ea20000000800ULL,
0x0000004b4a32723eULL, 0x002fe400000000ffULL, 0x00000042433e723eULL, 0x000fc600000000ffULL,
0x0000003274007388ULL, 0x0007e40000000800ULL, 0x00000054003f7308ULL, 0x000fe20000000800ULL,
0x000000343024723cULL, 0x020f620000001824ULL, 0x0000000958007388ULL, 0x0007e80000000800ULL,
0x0004000b5e007388ULL, 0x0007e40000000800ULL, 0x0000005500127308ULL, 0x000e620000000800ULL,
0x000000374c3d723eULL, 0x004fe200000000ffULL, 0x000400156a007388ULL, 0x0007e80000000800ULL,
0x000400176c007388ULL, 0x0007e80000000800ULL, 0x0004002d6e007388ULL, 0x0007e80000000800ULL,
0x0004002f70007388ULL, 0x0007e20000000800ULL, 0x0000003f123f723eULL, 0x002fc400000000ffULL,
0x000000ffff257224ULL, 0x020fe200078e0026ULL, 0x0004003172007388ULL, 0x0007e80000000800ULL,
0x0004003374007388ULL, 0x0007e20000000800ULL, 0x000000343c28723cULL, 0x000f660000001828ULL,
0x0000000c13007388ULL, 0x0007e80000000800ULL, 0x0008000e5e007388ULL, 0x0007e80000000800ULL,
0x000800186a007388ULL, 0x0007e80000000800ULL, 0x0008001a6c007388ULL, 0x0007e80000000800ULL,
0x000800386e007388ULL, 0x0007e80000000800ULL, 0x0008003a70007388ULL, 0x0007e20000000800ULL,
0x000000ffff267224ULL, 0x020fc400078e0028ULL, 0x000000ffff277224ULL, 0x000fe200078e002aULL,
0x0008003c72007388ULL, 0x0007e80000000800ULL, 0x0008003e74007388ULL, 0x0007e80000000800ULL,
0x0000000d5c007388ULL, 0x0007e80000000800ULL, 0x000c000f5e007388ULL, 0x0007e80000000800ULL,
0x000c00196a007388ULL, 0x0007e80000000800ULL, 0x000c001b6c007388ULL, 0x0007e80000000800ULL,
0x000c00396e007388ULL, 0x0007e80000000800ULL, 0x000c003b70007388ULL, 0x0007e80000000800ULL,
0x000c003d72007388ULL, 0x0007e80000000800ULL, 0x000c003f74007388ULL, 0x0007e80000000800ULL,
0x0120000410008388ULL, 0x0007e80000000c00ULL, 0x0122002410008388ULL, 0x0007e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000066ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080066ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100066ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000164647810ULL, 0x000fe20007ffe0ffULL,
0x0000180066ff7f8cULL, 0x0003e6000c80043fULL, 0x0000001c6400720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffff988000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff287807ULL, 0x008fe40004000000ULL,
0x000162c000297802ULL, 0x000fc40000000f00ULL, 0x0000108000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff037224ULL, 0x000fe200078e0028ULL, 0xfffec61000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40005800000ULL, 0x0001631000297802ULL, 0x000fc40000000f00ULL,
0x0000103000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0028ULL,
0xfffec67000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x0001636000287802ULL, 0x000fc40000000f00ULL, 0x00000f9000007944ULL, 0x014fea0003c00000ULL,
0xfffec74000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x000163a000287802ULL, 0x000fc40000000f00ULL, 0x00000f5000007944ULL, 0x016fea0003c00000ULL,
0xfffec87000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x000163e000287802ULL, 0x000fc40000000f00ULL, 0x00000f1000007944ULL, 0x01efea0003c00000ULL,
0xfffec9a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0002ULL,
0x0001642000287802ULL, 0x000fc40000000f00ULL, 0x00000ed000007944ULL, 0x01efea0003c00000ULL,
0xfffecac000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x0001647000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0003ULL,
0x00000e8000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0xfffecee000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x000164c000287802ULL, 0x000fc40000000f00ULL, 0x00000e3000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0x0000001003297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0000ULL, 0x0001651000287802ULL, 0x000fc40000000f00ULL,
0x00000de000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0029ULL,
0xfffece9000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0000ULL,
0x0001656000287802ULL, 0x000fc40000000f00ULL, 0x00000d9000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0029ULL, 0xfffece7000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x008fe40004000000ULL, 0x000165b000297802ULL, 0x000fc40000000f00ULL,
0x00000d9000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff257224ULL, 0x000fe200078e0028ULL,
0xfffef01000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe40005800000ULL,
0x0001660000297802ULL, 0x000fc40000000f00ULL, 0x00000d4000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff727224ULL, 0x000fe200078e0028ULL, 0xfffef05000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0078ULL, 0x0001665000287802ULL, 0x000fc40000000f00ULL,
0x00000ca000007944ULL, 0x004fea0003c00000ULL, 0xfffef13000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0078ULL, 0x0001669000287802ULL, 0x000fc40000000f00ULL,
0x00000c6000007944ULL, 0x006fea0003c00000ULL, 0xfffef26000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0078ULL, 0x000166d000287802ULL, 0x000fc40000000f00ULL,
0x00000c2000007944ULL, 0x00efea0003c00000ULL, 0xfffef39000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0078ULL, 0x0001671000287802ULL, 0x000fc40000000f00ULL,
0x00000be000007944ULL, 0x00efea0003c00000ULL, 0xfffef4b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001676000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e0025ULL, 0x00000b9000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0xfffef8d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x000167b000287802ULL, 0x000fc40000000f00ULL,
0x00000b4000007944ULL, 0x00efea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0x0000001025297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x0001680000287802ULL, 0x000fc40000000f00ULL, 0x00000af000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0029ULL, 0xfffef88000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x0001685000287802ULL, 0x000fc40000000f00ULL,
0x00000aa000007944ULL, 0x00cfea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0029ULL,
0xfffef86000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x004fe40004000000ULL,
0x000168a000297802ULL, 0x000fc40000000f00ULL, 0x00000aa000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff717224ULL, 0x000fe200078e0028ULL, 0xffff17f000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x000fe40005800000ULL, 0x000168f000297802ULL, 0x000fc40000000f00ULL,
0x00000a5000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff227224ULL, 0x000fe200078e0028ULL,
0xffff184000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0078ULL,
0x0001694000287802ULL, 0x000fc40000000f00ULL, 0x000009b000007944ULL, 0x018fea0003c00000ULL,
0xffff192000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0078ULL,
0x0001698000287802ULL, 0x000fc40000000f00ULL, 0x0000097000007944ULL, 0x01afea0003c00000ULL,
0xffff1a5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0078ULL,
0x000169c000287802ULL, 0x000fc40000000f00ULL, 0x0000093000007944ULL, 0x01afea0003c00000ULL,
0xffff1b8000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0078ULL,
0x00016a0000287802ULL, 0x000fc40000000f00ULL, 0x000008f000007944ULL, 0x01afea0003c00000ULL,
0xffff1ca000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x00016a5000287802ULL, 0x000fe20000000f00ULL, 0x000000ffff297224ULL, 0x000fc400078e0023ULL,
0x000008a000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff0f7224ULL, 0x004fe200078e0029ULL,
0xffff20a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x00016aa000287802ULL, 0x000fc40000000f00ULL, 0x0000085000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0e7224ULL, 0x004fe200078e0029ULL, 0x0000001023297810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000cULL, 0x00016af000287802ULL, 0x000fc40000000f00ULL,
0x0000080000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff0d7224ULL, 0x004fe200078e0029ULL,
0xffff205000007947ULL, 0x000fea000383ffffULL, 0x000000ffff2a7224ULL, 0x000fe200078e000cULL,
0x00016b4000287802ULL, 0x000fc40000000f00ULL, 0x000007b000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0c7224ULL, 0x004fe200078e0029ULL, 0xffff203000007947ULL, 0x000fea000383ffffULL,
0x00000001ff287807ULL, 0x004fe40004000000ULL, 0x00016b9000297802ULL, 0x000fc40000000f00ULL,
0x000007b000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff087224ULL, 0x000fe200078e0028ULL,
0xffff3f9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff287807ULL, 0x000fe40005800000ULL,
0x00016be000297802ULL, 0x000fc40000000f00ULL, 0x0000076000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff237224ULL, 0x000fe200078e0028ULL, 0xffff3fe000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x00016c3000287802ULL, 0x000fc40000000f00ULL,
0x000006c000007944ULL, 0x018fea0003c00000ULL, 0xffff40b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x00016c7000287802ULL, 0x000fc40000000f00ULL,
0x0000068000007944ULL, 0x01afea0003c00000ULL, 0xffff41e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x00016cb000287802ULL, 0x000fc40000000f00ULL,
0x0000064000007944ULL, 0x01afea0003c00000ULL, 0xffff431000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e000aULL, 0x00016cf000287802ULL, 0x000fc40000000f00ULL,
0x0000060000007944ULL, 0x01afea0003c00000ULL, 0xffff443000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x00016d4000287802ULL, 0x000fe20000000f00ULL,
0x000000ffff297224ULL, 0x000fc400078e0006ULL, 0x000005b000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff0f7224ULL, 0x004fe200078e0029ULL, 0xffff485000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x00016d9000287802ULL, 0x000fc40000000f00ULL,
0x0000056000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0e7224ULL, 0x004fe200078e0029ULL,
0x0000001006297810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff2a7224ULL, 0x000fe200078e0003ULL,
0x00016de000287802ULL, 0x000fc40000000f00ULL, 0x0000051000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0029ULL, 0xffff480000007947ULL, 0x000fea000383ffffULL,
0x000000ffff2a7224ULL, 0x000fe200078e0003ULL, 0x00016e3000287802ULL, 0x000fc40000000f00ULL,
0x000004c000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff0c7224ULL, 0x004fe200078e0029ULL,
0xffff47e000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0c7424ULL, 0x000fe200078e00ffULL,
0x00016e8000087802ULL, 0x000fc40000000f00ULL, 0x0000043000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e000bULL, 0xffffdfc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x006fe200078e000aULL, 0x00016ee000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff0c7424ULL, 0x000fc400078e00ffULL, 0x000003d000007944ULL, 0x010fea0003c00000ULL,
0x0000000b0a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000eULL,
0x00016f4000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000a0b067208ULL, 0x000fc80004000000ULL, 0x0000037000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000dULL,
0x00016fa000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000e0b0e7208ULL, 0x000fc80004000000ULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0d00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000fULL,
0x0001700000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000d0b0a7208ULL, 0x000fc80004000000ULL, 0x000002b000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0006ULL,
0x0001706000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000f0b047208ULL, 0x000fc80004000000ULL, 0x0000025000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000eULL,
0x000170c000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x000000060b057208ULL, 0x000fc80004000000ULL, 0x000001f000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0e00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000aULL,
0x0001712000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff0c7424ULL, 0x000fe200078e00ffULL,
0x0000000e0b067208ULL, 0x000fc80004000000ULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffde9000007947ULL, 0x000fea000383ffffULL, 0x0180000021007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000002100008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff21ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000021027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000002100007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe8d5002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000005b00007348ULL, 0x000fe80003800000ULL, 0x0c00000c070b7389ULL, 0x0002a200000e005aULL,
0xfffe8d1008007950ULL, 0x000fea0003c3ffffULL, 0x0000008100007348ULL, 0x000fe80003800000ULL,
0x000000292a297389ULL, 0x0002a200000e0084ULL, 0x00000000ff2b7424ULL, 0x000fc400078e00ffULL,
0x000000ffff2a7224ULL, 0x002fc800078e0028ULL, 0xfffe8cc02a007950ULL, 0x000fea0003c3ffffULL,
0x000000012800780cULL, 0x000fe20003f65070ULL, 0x000000ffff2a7224ULL, 0x000fe200078e0029ULL,
0x0000008000007348ULL, 0x000fe80003800000ULL, 0x00000000ff2b7424ULL, 0x000fce00078e00ffULL,
0x0000000000287806ULL, 0x000fc800058e0100ULL, 0x0000008028287212ULL, 0x000fe200078ec0ffULL,
0xfffe8c502a007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000200000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000560ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c0ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000930ULL,
0x0000000000000350ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c80ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d40ULL,
0x000000000000089cULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015e0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f0ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001680ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001684ULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x0000000000017480ULL, 0xde00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000018d00ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000018d40ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x00000000000190c0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001680ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000017680ULL,
0x0000000000017680ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000018d00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000190c0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_89_cubin_len = 102816;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
