/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_90_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000018130ULL, 0x0000000000017db0ULL, 0x00380040005a055aULL, 0x0001000e00400006ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x65722e0000000000ULL,
0x6b2e747865742e6cULL, 0x686d5f6c656e7265ULL, 0x2e616c65722e0061ULL, 0x72656b2e74786574ULL,
0x0061686d5f6c656eULL, 0x665f67756265642eULL, 0x65722e00656d6172ULL, 0x5f67756265642e6cULL,
0x722e00656d617266ULL, 0x756265642e616c65ULL, 0x00656d6172665f67ULL, 0x736e6f632e766e2eULL,
0x656b2e30746e6174ULL, 0x61686d5f6c656e72ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x7368732e00000000ULL,
0x732e006261747274ULL, 0x732e006261747274ULL, 0x732e006261746d79ULL, 0x68735f6261746d79ULL,
0x2e766e2e0078646eULL, 0x72746e652e746675ULL, 0x6e692e766e2e0079ULL, 0x656e72656b006f66ULL,
0x742e0061686d5f6cULL, 0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x2e6f666e692e766eULL,
0x6d5f6c656e72656bULL, 0x732e766e2e006168ULL, 0x656b2e6465726168ULL, 0x61686d5f6c656e72ULL,
0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x72655073776f7200ULL, 0x6e2e006b636f6c42ULL,
0x6174736e6f632e76ULL, 0x000000000033746eULL, 0x657a69536d656d73ULL, 0x7563344e5a5a5f00ULL,
0x5f33647473336164ULL, 0x7465645f5f38345fULL, 0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL,
0x75635f726564726fULL, 0x5f37456969456164ULL, 0x5f006d726f66785fULL, 0x727241374b4e5a5aULL,
0x6a4c664944327961ULL, 0x324545326a4c4532ULL, 0x454530624c497461ULL, 0x31456a6a664b5245ULL,
0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL,
0x6a4c45326a4c6649ULL, 0x4c45326a4c454532ULL, 0x497461324545386aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3053ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x5f5f374944327961ULL, 0x346a4c32666c6168ULL, 0x61324545386a4c45ULL, 0x45454530624c4974ULL,
0x456a6a5f30534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL,
0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL, 0x497461324545386aULL,
0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x316a4c4532336a4cULL,
0x4c49746132454536ULL, 0x534b524545453162ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4534366aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x4d6e4974736e4939ULL, 0x4c45346a4c497461ULL, 0x45326a4c4545316aULL,
0x7461324545316a4cULL, 0x5245454530624c49ULL, 0x31456a6a5f31534bULL, 0x72655073776f7234ULL,
0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL, 0x4939494432796172ULL, 0x74614d6e4974736eULL,
0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL, 0x4c49746132454531ULL, 0x534b524545453062ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x736e493949443279ULL, 0x4c4974614d6e4974ULL, 0x4545326a4c45326aULL, 0x45316a4c45346a4cULL,
0x30624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL,
0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL,
0x324545386a4c4532ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x0000000000000067ULL, 0x0000000000000000ULL, 0x2400000000000000ULL,
0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL, 0x6e725f7063725f30ULL,
0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x742e6c65722e0068ULL, 0x6e72656b2e747865ULL,
0x2e0061686d5f6c65ULL, 0x7865742e616c6572ULL, 0x6c656e72656b2e74ULL, 0x656b240061686d5fULL,
0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x65642e0066754265ULL, 0x6d6172665f677562ULL,
0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL, 0x665f67756265642eULL,
0x766e2e00656d6172ULL, 0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x00000061686d5f6cULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b5ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000000beULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000b0001000000fcULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000b000100000135ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000b00010000017cULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000b0001000001beULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000b000100000204ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000b00010000024bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000b000100000291ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000b0001000002dfULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000b00010000032dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000b00010000037bULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000b0001000003c9ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x0000010000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000a002200000424ULL, 0x0000000000016710ULL, 0x0000000000000270ULL,
0x000400030000049aULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000a101200000040ULL,
0x0000000000000000ULL, 0x0000000000016980ULL, 0x000d0003000004caULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000024ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001671000000000ULL, 0x0001080400000000ULL,
0x0000288080810c00ULL, 0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL,
0x0000000000000000ULL, 0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000006000000000ULL,
0x0001671000000000ULL, 0x0000027000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL,
0x0000000000002880ULL, 0x0000001500082f04ULL, 0x00082304000000bbULL, 0x0000000000000013ULL,
0x0000001300081204ULL, 0x0008110400000000ULL, 0x0000000000000013ULL, 0x0000001500082304ULL,
0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL, 0x0004370400000000ULL,
0x000c17040000007bULL, 0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL,
0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL,
0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL,
0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL,
0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL,
0x00ff1b030011f000ULL, 0xffffffff00dc2904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0x000001b000dc2804ULL, 0x0000096000000250ULL, 0x00002c0000002b90ULL,
0x00002e1000002ce0ULL, 0x0000308000002f40ULL, 0x0000362000003610ULL, 0x0000364000003630ULL,
0x00005440000053e0ULL, 0x0000568000005550ULL, 0x000058f0000057b0ULL, 0x00005d9000005d80ULL,
0x00005db000005da0ULL, 0x00007b2000007ac0ULL, 0x00007d6000007c30ULL, 0x00007fd000007e90ULL,
0x0000841000008400ULL, 0x0000843000008420ULL, 0x0000a1600000a0f0ULL, 0x0000a3800000a250ULL,
0x0000a5f00000a4b0ULL, 0x0000ab000000aaf0ULL, 0x0000ab200000ab10ULL, 0x0000bdb00000bda0ULL,
0x0000bdd00000bdc0ULL, 0x00014fe000014f30ULL, 0x000153d0000152b0ULL, 0x000158c0000157c0ULL,
0x00015c1000015b70ULL, 0x0000047004303904ULL, 0x0001a600000000ffULL, 0x0000055000040100ULL,
0x0001a60800000000ULL, 0x00000660003f0100ULL, 0x0001a68800000000ULL, 0x00000790003f0100ULL,
0x0001a6a800000006ULL, 0x000008a0003f0100ULL, 0x0001a6c800000004ULL, 0x00000fe0003f0100ULL,
0x0001a60000000009ULL, 0x00001160003f0107ULL, 0x0001a68800000000ULL, 0x00001b40003f0101ULL,
0x00000000000000ffULL, 0x00001bc000040107ULL, 0x00000000000000ffULL, 0x00001c4000040101ULL,
0x0000002000000003ULL, 0x00001da0003f0101ULL, 0x0001a6c800000038ULL, 0x00001f20003f0109ULL,
0x0001a6c800000038ULL, 0x00002840003f0109ULL, 0x0001a6b00000003aULL, 0x00002900003f0107ULL,
0x0001a6b00000003aULL, 0x00002910003f0101ULL, 0x0001a60800000080ULL, 0x00002930003f0101ULL,
0x0001a60800000080ULL, 0x00002aa0003f0109ULL, 0x0001a60800000080ULL, 0x00003210003f0109ULL,
0x0001a6a80000003aULL, 0x000033a0003f0109ULL, 0x0001a6a80000003aULL, 0x000047c0003f0109ULL,
0x0001a6c800000034ULL, 0x000047d0003f0101ULL, 0x0001a6880000007cULL, 0x00004800003f0101ULL,
0x0000000000000006ULL, 0x00004970003f0109ULL, 0x0000000000000006ULL, 0x00005160003f0109ULL,
0x00000000000000ffULL, 0x000051a000050107ULL, 0x00000000000000ffULL, 0x000051b000050101ULL,
0x0001a62800000080ULL, 0x000051d0003f0101ULL, 0x0001a62800000080ULL, 0x00005340003f0109ULL,
0x0001a62800000080ULL, 0x00005ad0003f0109ULL, 0x0001a6b000000037ULL, 0x00005c40003f0109ULL,
0x0001a6b000000037ULL, 0x00006e20003f0109ULL, 0x0001a6c800000034ULL, 0x00006e30003f0101ULL,
0x0001a69000000036ULL, 0x00006e60003f0101ULL, 0x0000000000000006ULL, 0x00006fd0003f0109ULL,
0x0000000000000006ULL, 0x000077c0003f0109ULL, 0x00000008000000ffULL, 0x0000788000040107ULL,
0x0000000800000086ULL, 0x00007890003f0101ULL, 0x0001a64800000080ULL, 0x000078b0003f0101ULL,
0x0001a64800000080ULL, 0x00007a20003f0109ULL, 0x0001a64800000080ULL, 0x00008180003f0109ULL,
0x00000000000000ffULL, 0x000082f000050109ULL, 0x00000000000000ffULL, 0x0000949000050109ULL,
0x0000000000000006ULL, 0x000094a0003f0101ULL, 0x0001a69800000036ULL, 0x000094c0003f0101ULL,
0x0000000000000006ULL, 0x00009630003f0109ULL, 0x0000000000000006ULL, 0x00009e60003f0109ULL,
0x00000000000000ffULL, 0x00009ea000040107ULL, 0x00000000000000ffULL, 0x00009eb000050101ULL,
0x0001a66800000008ULL, 0x00009ee0003f0101ULL, 0x0001a66800000008ULL, 0x0000a050003f0109ULL,
0x0001a66800000008ULL, 0x0000a7c0003f0109ULL, 0x0001a6b000000037ULL, 0x0000a930003f0109ULL,
0x0001a6b000000037ULL, 0x0000bb90003f0109ULL, 0x0000000000000006ULL, 0x0000bbd0003f0101ULL,
0x0001a6a000000006ULL, 0x0000d920003f0101ULL, 0x0001a60000000009ULL, 0x0000f280003f0101ULL,
0x0001a60000000009ULL, 0x0000f3f0003f0109ULL, 0x0001a60000000009ULL, 0x0000f740003f0109ULL,
0x0001a60000000009ULL, 0x0000f760003f0101ULL, 0x0001a60000000009ULL, 0x0000f8d0003f0109ULL,
0x0001a60000000009ULL, 0x00012810003f0109ULL, 0x0001a68800000008ULL, 0x00012be0003f0101ULL,
0x0001a68800000008ULL, 0x00012d50003f0109ULL, 0x0001a68800000008ULL, 0x000166a0003f0109ULL,
0x0001a60800000075ULL, 0x000166b0003f0101ULL, 0x0001a61000000075ULL, 0x000166c0003f0101ULL,
0x0001a61800000075ULL, 0x000166d0003f0101ULL, 0x0001a62000000075ULL, 0x00053803003f0101ULL,
0x0000cce000301c04ULL, 0x0000cef00000cd40ULL, 0x0000d1b00000d050ULL, 0x0000d4700000d310ULL,
0x0000d7600000d5d0ULL, 0x0000f9000000d860ULL, 0x000c050400016700ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0060190300000000ULL, 0x0000001600080a04ULL, 0x0000000000600210ULL,
0x00000000000000bcULL, 0x0000001500000002ULL, 0x0000000000016710ULL, 0x0000000000000044ULL,
0x0000001500000002ULL, 0x0000000000000000ULL, 0x0000000000000098ULL, 0x0000001500000002ULL,
0x0000000000000000ULL, 0x000000000001a700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017b82ULL, 0x000e700000000800ULL, 0x00008400ff027b82ULL, 0x000ea20000000a00ULL,
0x00000000000f7919ULL, 0x000ee20000002300ULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000000000a7919ULL, 0x000eea0000002200ULL, 0x00000400ff067b82ULL, 0x000f220000000800ULL,
0x0000010000047ab9ULL, 0x000fce0000000800ULL, 0x00008600ff0e7b82ULL, 0x000f620000000800ULL,
0x0000000300007306ULL, 0x004ea20000209000ULL, 0x000000ff0300720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x004ea40000001000ULL, 0x0ffffffe00047836ULL, 0x004fcc0000000000ULL,
0x0000000400057305ULL, 0x0004e4000021f000ULL, 0x000000ffff047224ULL, 0x004fe400078e00ffULL,
0x000000ffff087224ULL, 0x00afc800078e0a05ULL, 0x0000000308077224ULL, 0x000fe400078e02ffULL,
0x0000000000087919ULL, 0x000e640000002600ULL, 0x0000000705057227ULL, 0x000fe400078e0004ULL,
0x0000000000077919ULL, 0x000ea80000002100ULL, 0x0000000605777227ULL, 0x010fc800078e00ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a77ULL, 0x0000000503007224ULL, 0x000fca00078e0206ULL,
0x000000030000720cULL, 0x000fda0003f06070ULL, 0x0000000100000824ULL, 0x000fe400078e0a03ULL,
0x0000000177770836ULL, 0x000fe20000000000ULL, 0x00000005ff787819ULL, 0x004fe40000011607ULL,
0x000000030000720cULL, 0x000fc80003f26070ULL, 0x00001fff78787589ULL, 0x000f7200000e0000ULL,
0x0000000177771836ULL, 0x000fe20000000000ULL, 0x00000003ff77a212ULL, 0x000fc800078e33ffULL,
0x0000007700007306ULL, 0x000ea20000209000ULL, 0x000000ff7700720cULL, 0x000fce0003f45070ULL,
0x0000000000007308ULL, 0x004ea40000001000ULL, 0x0ffffffe00047836ULL, 0x004fe40000000000ULL,
0x000000040f007c24ULL, 0x000fe2000f8e020aULL, 0x0000000000047ab9ULL, 0x000fc60000000800ULL,
0x0000000400057305ULL, 0x0004e2000021f000ULL, 0x00001fff0f0f7589ULL, 0x000f6200000e0000ULL,
0x000000ffff047224ULL, 0x004fe400078e00ffULL, 0x0000000577067224ULL, 0x008fc800078e02ffULL,
0x000000ffff097224ULL, 0x000fc800078e0a06ULL, 0x0000000905057227ULL, 0x000fc800078e0004ULL,
0x0000000400047c24ULL, 0x000fe4000f8e0207ULL, 0x0000000805597227ULL, 0x002fc600078e00ffULL,
0x0000007f0400780cULL, 0x040fe20003f64070ULL, 0x000000ffff057224ULL, 0x000fe200078e0a59ULL,
0x000000030400780cULL, 0x000fc60003f84070ULL, 0x0000000577007224ULL, 0x000fe400078e0208ULL,
0x0000000000057919ULL, 0x000f660000002700ULL, 0x000000770000720cULL, 0x000fc60003f06070ULL,
0x000000000009b919ULL, 0x000e620000008800ULL, 0x000004000006b802ULL, 0x000fe20000000f00ULL,
0xff317217ff07b424ULL, 0x000fd000078e00ffULL, 0x0000000100000824ULL, 0x000fe400078e0a77ULL,
0x0000000159590836ULL, 0x000fe20000000000ULL, 0x000000ff0400720cULL, 0x000fe40003f05270ULL,
0x000000770000720cULL, 0x000fda0003f26070ULL, 0x0000000159591836ULL, 0x000fe20000000000ULL,
0x00000077ff59a212ULL, 0x000fe400078e33ffULL, 0x0000000f0400780cULL, 0x040fe40003f24070ULL,
0x000006540909b816ULL, 0x002fe20000000006ULL, 0x000000ffff007224ULL, 0x000fe200078e0a59ULL,
0x000000010400780cULL, 0x000fc60003f44070ULL, 0x0000000077777224ULL, 0x000fe400078e0208ULL,
0x000000040406b824ULL, 0x000fe200078e0209ULL, 0x0000000000240947ULL, 0x020fee0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x001fff0000067882ULL, 0x000fe20000000000ULL, 0x7ffc000000077882ULL, 0x000fe20000000000ULL,
0x0000065405047896ULL, 0x002fe20008000004ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000000000073c6ULL, 0x000e740000000000ULL, 0x01a60006043f75b2ULL, 0x0002640008000100ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000010000007945ULL, 0x000fe80003800000ULL, 0x0000000000381947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000e620000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x002fc60008000004ULL,
0x7ffe000000057882ULL, 0x000fc60000000000ULL, 0x0000000404007c11ULL, 0x000fe2000f8e18ffULL,
0x001fff8000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000000612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a60804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000384947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000e620000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x002fc60008000004ULL, 0x7ffb000000057882ULL, 0x000fc60000000000ULL,
0x0000000404007c11ULL, 0x000fe2000f8e18ffULL, 0x001ffec000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x000fca0000000000ULL, 0x00000000000612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a68804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x01a400070600b388ULL, 0x0003e20000000800ULL, 0x0000011000007945ULL, 0x000fe20003800000ULL,
0x0000002077007824ULL, 0x000fc600078e00ffULL, 0x0000000000384947ULL, 0x000fea0003800000ULL,
0x00000000000579c3ULL, 0x000ea20000008800ULL, 0x0000040000047882ULL, 0x000fe20000000000ULL,
0x000000000000781cULL, 0x000fe20003f2f070ULL, 0x0000065405047896ULL, 0x004fc60008000004ULL,
0x7ffc000000057882ULL, 0x000fc60000000000ULL, 0x0000000404067c11ULL, 0x002fe2000f8e18ffULL,
0x001fff0000047882ULL, 0x000fe20000000000ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000000060612caULL, 0x000fd00000000000ULL, 0x000000000000181cULL, 0x000fe4000072f070ULL,
0x000000000000781cULL, 0x000fe20003f0f070ULL, 0x00000000000073c6ULL, 0x000e640000000000ULL,
0x01a6a804063f75b2ULL, 0x0002700008000100ULL, 0xfffffffd00e81947ULL, 0x002fea000393ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000010000007945ULL, 0x000fe80003800000ULL,
0x0000000000382947ULL, 0x000fea0003800000ULL, 0x00000000000579c3ULL, 0x000ea20000008800ULL,
0x0000040000047882ULL, 0x000fe20000000000ULL, 0x000000000000781cULL, 0x000fe20003f2f070ULL,
0x0000065405047896ULL, 0x004fc60008000004ULL, 0x7ffe000000057882ULL, 0x000fc60000000000ULL,
0x0000000404047c11ULL, 0x000fe2000f8e18ffULL, 0x001fff8000047882ULL, 0x000fe20000000000ULL,
0x0000000000007918ULL, 0x002fca0000000000ULL, 0x00000000040612caULL, 0x000fd00000000000ULL,
0x000000000000181cULL, 0x000fe4000072f070ULL, 0x000000000000781cULL, 0x000fe20003f0f070ULL,
0x00000000000073c6ULL, 0x000e640000000000ULL, 0x01a6c804063f75b2ULL, 0x0002700008000100ULL,
0xfffffffd00e81947ULL, 0x002fea000393ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x000fe200078e0a00ULL, 0x0000000e02077219ULL, 0x002fe200000006ffULL,
0x0000000205027224ULL, 0x000fe200078e02ffULL, 0x0000000e030b7219ULL, 0x000fe200000006ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000700720cULL, 0x000fe20003f06070ULL,
0x0000820000067ab9ULL, 0x000fe20000000a00ULL, 0x0000002007757446ULL, 0x000fe20003800004ULL,
0x000000040f047824ULL, 0x000fe200078e0278ULL, 0x0000000e59767219ULL, 0x000fc400000006ffULL,
0x000000ff75757207ULL, 0x000fe20000000000ULL, 0x0000000404047824ULL, 0x000fe400078e00ffULL,
0x0000000b02027224ULL, 0x000fe200078e0276ULL, 0x000000207500780cULL, 0x000fda0003f05270ULL,
0x0000000000c48947ULL, 0x000fea0003800000ULL, 0x00000000000a7919ULL, 0x000e620000000000ULL,
0xffffffffff097424ULL, 0x000fe200078e00ffULL, 0x0000000475077248ULL, 0x000fe20007fe0000ULL,
0x00008a0000047ab9ULL, 0x000fe20000000a00ULL, 0x0000000000107919ULL, 0x000ea40000008800ULL,
0x0000000e09087219ULL, 0x000fe200000006ffULL, 0x0000000107077824ULL, 0x000fe200078e0a04ULL,
0x0000040000097802ULL, 0x000fe40000000f00ULL, 0x00000004ff067819ULL, 0x002fc8000001160aULL,
0x000000070600720cULL, 0x080fe20003f06070ULL, 0x00000002060c7836ULL, 0x000fe20000000000ULL,
0x0000065410097816ULL, 0x004fe20000000009ULL, 0x0000000104137824ULL, 0x040fe400078e0206ULL,
0x0000000104157824ULL, 0x000fe200078e020cULL, 0x000000070c00720cULL, 0x000fe20003f26070ULL,
0x00000001000d7824ULL, 0x040fe400078e0213ULL, 0x0000000100177824ULL, 0x000fc600078e0215ULL,
0x000000080d117212ULL, 0x080fe400078e30ffULL, 0x0000000817197212ULL, 0x000fe400078e30ffULL,
0x0000000eff047219ULL, 0x080fe2000001160dULL, 0x0000000102117824ULL, 0x040fe200078e0211ULL,
0x0000000eff087219ULL, 0x000fe20000011617ULL, 0x0000000102197824ULL, 0x000fe400078e0219ULL,
0x0000000b04067224ULL, 0x000fe400078e0211ULL, 0x000000100a047824ULL, 0x000fc400078e00ffULL,
0x0000000b08087224ULL, 0x000fe400078e0219ULL, 0x0000010006067825ULL, 0x000fe200078e00ffULL,
0x000000f004117812ULL, 0x000fc600078ec0ffULL, 0x00000100080c7825ULL, 0x000fe200078e00ffULL,
0x0000001106067212ULL, 0x000fc600078efcffULL, 0x0000000113027824ULL, 0x140fe200078e020aULL,
0x000000110c0c7212ULL, 0x000fe200078efcffULL, 0x0000001013137824ULL, 0x000fe200078e00ffULL,
0x0000000406067c10ULL, 0x000fe2000ff5e0ffULL, 0x0000000115087824ULL, 0x040fe200078e020aULL,
0x000000040c0c7c10ULL, 0x000fe2000ff7e0ffULL, 0x0000001015157824ULL, 0x000fe200078e00ffULL,
0xfffffff013027812ULL, 0x000fe400078ee202ULL, 0x0000000507077c10ULL, 0x000fe400097fe4ffULL,
0xfffffff015087812ULL, 0x000fe200078ee208ULL, 0x0000001002117824ULL, 0x000fe200078e0209ULL,
0x000000050d0d7c10ULL, 0x000fc60009ffe4ffULL, 0x0000001008137824ULL, 0x000fe200078e0209ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006117faeULL, 0x0003e8000c101c46ULL,
0x000000000c137faeULL, 0x0003e2000c901c46ULL, 0x0000000000a87947ULL, 0x000fea0003800000ULL,
0x00000000000a7919ULL, 0x000e620000000000ULL, 0xffffffffff077424ULL, 0x000fe200078e00ffULL,
0x0000040000087802ULL, 0x000fe20000000f00ULL, 0x00008a0000047ab9ULL, 0x000fe20000000a00ULL,
0x00000000000d7919ULL, 0x000ea40000008800ULL, 0x0000000e07097219ULL, 0x000fe400000006ffULL,
0x000000040a117211ULL, 0x002fca00078fe0ffULL, 0x0000000211137836ULL, 0x000fe40000000000ULL,
0x0000000100047824ULL, 0x040fe400078e0211ULL, 0x0000000100067824ULL, 0x000fc600078e0213ULL,
0x0000000904077212ULL, 0x080fe400078e30ffULL, 0x0000000906097212ULL, 0x000fe400078e30ffULL,
0x0000000eff047219ULL, 0x080fe20000011604ULL, 0x0000000102077824ULL, 0x040fe200078e0207ULL,
0x0000000eff067219ULL, 0x000fe20000011606ULL, 0x0000000102027824ULL, 0x000fe200078e0209ULL,
0x000006540d097816ULL, 0x004fe20000000008ULL, 0x0000000b04077224ULL, 0x000fe400078e0207ULL,
0x000000100a047824ULL, 0x000fc400078e00ffULL, 0x0000000b06027224ULL, 0x000fe400078e0202ULL,
0x0000010007067825ULL, 0x000fe200078e00ffULL, 0x000000f004157812ULL, 0x000fc600078ec0ffULL,
0x00000100020c7825ULL, 0x000fe200078e00ffULL, 0x0000001506067212ULL, 0x000fc600078efcffULL,
0x0000000111027824ULL, 0x140fe200078e020aULL, 0x000000150c0c7212ULL, 0x000fe200078efcffULL,
0x0000001011117824ULL, 0x000fe200078e00ffULL, 0x0000000406067c10ULL, 0x000fe2000ff1e0ffULL,
0x0000000113087824ULL, 0x040fe200078e020aULL, 0x000000040c0c7c10ULL, 0x000fe2000ff3e0ffULL,
0x0000001013137824ULL, 0x000fe200078e00ffULL, 0xfffffff011027812ULL, 0x000fe400078ee202ULL,
0x0000000507077c10ULL, 0x000fe400087fe4ffULL, 0xfffffff013087812ULL, 0x000fe200078ee208ULL,
0x0000001002117824ULL, 0x000fe200078e0209ULL, 0x000000050d0d7c10ULL, 0x000fc60008ffe4ffULL,
0x0000001008137824ULL, 0x000fe200078e0209ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006117faeULL, 0x0003e8000b901c46ULL, 0x000000000c137faeULL, 0x0003e4000b901c46ULL,
0x00000000090472caULL, 0x000fe200000e0000ULL, 0x00009200ff067b82ULL, 0x002e620000000a00ULL,
0x0000000000007918ULL, 0x000fd60000000000ULL, 0x0001a60004047890ULL, 0x000fd2000fffe03fULL,
0x000000ffffff79a7ULL, 0x000fe20008200404ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a84ULL,
0x0000000405067825ULL, 0x002fe200078e0006ULL, 0x0000000000007918ULL, 0x000fc80000000000ULL,
0x0000000606747981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0f00720cULL, 0x000fe20003f05270ULL,
0x0000007f74637836ULL, 0x004fe40000000000ULL, 0x000000ff74027836ULL, 0x000fc60000000000ULL,
0x00000007ff637819ULL, 0x000fe40000011663ULL, 0x00000008ff617819ULL, 0x000fca0000011602ULL,
0x000000c400f08947ULL, 0x000fea0003800000ULL, 0x00000003ff607819ULL, 0x000fe20000011678ULL,
0xffffffffff827424ULL, 0x000fe400078e00ffULL, 0x00000004ff0f7424ULL, 0x000fe200078e00ffULL,
0x01ffffff60607812ULL, 0x000fc800078ec0ffULL, 0x000000636000720cULL, 0x000fda0003f06070ULL,
0x00009400ff0d8b82ULL, 0x000e620000000800ULL, 0x0000000205008824ULL, 0x000fce00078e00ffULL,
0x00009000ff068b82ULL, 0x000ea20000000a00ULL, 0x0000000d000d8224ULL, 0x002fe400078e020dULL,
0x0000000878007824ULL, 0x000fe400078e0209ULL, 0x00000001600d8824ULL, 0x000fe400078e020dULL,
0x01a6880f00ff79a7ULL, 0x0003e4000850003fULL, 0x000000040d068825ULL, 0x004fca00078e0006ULL,
0x0000000606828981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0200780cULL, 0x000fe20003f04070ULL,
0x0000008059597824ULL, 0x000fe200078e00ffULL, 0x00000001ff627819ULL, 0x000fe40000011678ULL,
0x0000000178027812ULL, 0x000fc600078ec0ffULL, 0x00000020625b7824ULL, 0x000fca00078e00ffULL,
0x0000006059007812ULL, 0x002fe200078ef85bULL, 0x0000000382037224ULL, 0x004fc800078e02ffULL,
0x0000008003157824ULL, 0x000fe200078e00ffULL, 0x0000000400080947ULL, 0x000fec0003800000ULL,
0x0000001002037824ULL, 0x000fe200078e00ffULL, 0x0000005b74027248ULL, 0x000fe20007fe0000ULL,
0x00008e00ff187b82ULL, 0x000e620000000a00ULL, 0x00000003ff067819ULL, 0x000fc6000001160aULL,
0x0000000102027824ULL, 0x000fe400078e0a5bULL, 0x0000000103077824ULL, 0x000fe400078e0206ULL,
0x00000004060c7836ULL, 0x000fe20000000000ULL, 0x0000000302027248ULL, 0x000fe20007fe0000ULL,
0x0000000107087824ULL, 0x040fe400078e020aULL, 0x00000008070d7824ULL, 0x000fe400078e00ffULL,
0x0000000102027824ULL, 0x000fc400078e0a03ULL, 0x00000008060e7836ULL, 0x000fe20000000000ULL,
0xfffffff80d087812ULL, 0x000fe200078ee208ULL, 0x00000001030d7824ULL, 0x000fe200078e020cULL,
0x000000020c00720cULL, 0x080fe20003f46070ULL, 0x0000000c060c7836ULL, 0x000fe20000000000ULL,
0x000000020600720cULL, 0x080fe20003f66070ULL, 0x000000010d067824ULL, 0x040fe200078e020aULL,
0x000000020e00720cULL, 0x080fe20003f26070ULL, 0x000000080d137824ULL, 0x000fe200078e00ffULL,
0x000000020c00720cULL, 0x000fe20003f06070ULL, 0x00000001030f7824ULL, 0x000fc400078e020eULL,
0x0000000103117824ULL, 0x000fe200078e020cULL, 0xfffffff813107812ULL, 0x000fe200078ee206ULL,
0x0000000100027824ULL, 0x040fe200078e0207ULL, 0x0000001815137211ULL, 0x042fe200078838ffULL,
0x0000000100067824ULL, 0x040fe400078e020dULL, 0x00000001000c7824ULL, 0x040fe200078e020fULL,
0x0000001915197211ULL, 0x000fe200020f3cffULL, 0x00000001000e7824ULL, 0x000fe400078e0211ULL,
0x0000008002027825ULL, 0x000fc800078e00ffULL, 0x0000000111077824ULL, 0x140fe200078e020aULL,
0x0000007002027812ULL, 0x000fe200078ef804ULL, 0x0000000811147824ULL, 0x000fe400078e00ffULL,
0x000000010f007824ULL, 0x040fe200078e020aULL, 0x0000000213027210ULL, 0x000fe20007f9e0ffULL,
0x000000080f0f7824ULL, 0x000fe200078e00ffULL, 0xfffffff814147812ULL, 0x000fe200078ee207ULL,
0x0000008006067825ULL, 0x000fc600078e00ffULL, 0xfffffff80f127812ULL, 0x000fe200078ee200ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000007006067812ULL, 0x000fc600078ef804ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x000fc600078ef804ULL,
0x0000200062007824ULL, 0x000fe200078e0209ULL, 0x000000700e047812ULL, 0x000fe200078ef804ULL,
0x0000000103037824ULL, 0x000fe200020e0619ULL, 0x0000001306067210ULL, 0x000fe20007f9e0ffULL,
0x0001600000117836ULL, 0x000fe20000000000ULL, 0x000000130c0c7210ULL, 0x000fe40007fbe0ffULL,
0x00000013040e7210ULL, 0x000fe20007fde0ffULL, 0x0000001008137824ULL, 0x100fe400078e0211ULL,
0x0000001010157824ULL, 0x000fc400078e0211ULL, 0x0000000107077824ULL, 0x000fe200020e0619ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002137faeULL, 0x0003e2000d901c46ULL,
0x0000001012177824ULL, 0x000fe400078e0211ULL, 0x000000010d0d7824ULL, 0x000fe200028e0619ULL,
0x0000000006157faeULL, 0x0003e2000d101c46ULL, 0x0000001014117824ULL, 0x000fe400078e0211ULL,
0x000000010f0f7824ULL, 0x000fe200030e0619ULL, 0x000000000c177faeULL, 0x0003e8000c901c46ULL,
0x000000000e117faeULL, 0x0003e2000c101c46ULL, 0x0000000000d47947ULL, 0x000fea0003800000ULL,
0x0000001002037824ULL, 0x000fe200078e00ffULL, 0x00008e00ff127b82ULL, 0x000e680000000a00ULL,
0x000000030a037211ULL, 0x000fca00078fe8ffULL, 0x0000000103027824ULL, 0x140fe400078e020aULL,
0x00000008030d7824ULL, 0x000fe400078e00ffULL, 0x0000000403077836ULL, 0x000fe40000000000ULL,
0x0000000c030f7836ULL, 0x000fe20000000000ULL, 0xfffffff80d087812ULL, 0x000fe200078ee202ULL,
0x0000000107067824ULL, 0x040fe400078e020aULL, 0x0000000807117824ULL, 0x000fc400078e00ffULL,
0x00000008030d7836ULL, 0x000fe40000000000ULL, 0x0000000100027824ULL, 0x040fe200078e0203ULL,
0xfffffff811107812ULL, 0x000fe200078ee206ULL, 0x0000000100077824ULL, 0x040fe200078e0207ULL,
0x0000001215117211ULL, 0x042fe200078038ffULL, 0x00000001000c7824ULL, 0x040fe400078e020dULL,
0x00000001000e7824ULL, 0x000fe200078e020fULL, 0x0000001315197211ULL, 0x000fe200000f3cffULL,
0x000000010f067824ULL, 0x000fc400078e020aULL, 0x0000008002027825ULL, 0x000fc800078e00ffULL,
0x000000010d007824ULL, 0x000fe200078e020aULL, 0x0000007002027812ULL, 0x000fe200078ef804ULL,
0x000000080f0f7824ULL, 0x000fe400078e00ffULL, 0x000000080d0d7824ULL, 0x000fe200078e00ffULL,
0x0000000211027210ULL, 0x000fe20007f1e0ffULL, 0x0000200062137824ULL, 0x000fe200078e0209ULL,
0xfffffff80f127812ULL, 0x000fe200078ee206ULL, 0x0000008007067825ULL, 0x000fe200078e00ffULL,
0xfffffff80d007812ULL, 0x000fc600078ee200ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000007006067812ULL, 0x000fc600078ef804ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c0c7812ULL, 0x000fc600078ef804ULL, 0x0000000103037824ULL, 0x000fe200000e0619ULL,
0x000000700e047812ULL, 0x000fe200078ef804ULL, 0x0001600013177836ULL, 0x000fe20000000000ULL,
0x0000000611067210ULL, 0x000fe40007f1e0ffULL, 0x0000000c110c7210ULL, 0x000fe20007f3e0ffULL,
0x0000001010137824ULL, 0x100fe200078e0217ULL, 0x00000004110e7210ULL, 0x000fe20007f5e0ffULL,
0x0000001008117824ULL, 0x000fe400078e0217ULL, 0x0000000107077824ULL, 0x000fc400000e0619ULL,
0x0000001000157824ULL, 0x000fe200078e0217ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002117faeULL, 0x0003e2000b901c46ULL, 0x000000010d0d7824ULL, 0x000fe400008e0619ULL,
0x0000001012177824ULL, 0x000fe200078e0217ULL, 0x0000000006137faeULL, 0x0003e2000b901c46ULL,
0x000000010f0f7824ULL, 0x000fc600010e0619ULL, 0x000000000c157faeULL, 0x0003e8000b901c46ULL,
0x000000000e177faeULL, 0x0003e4000b901c46ULL, 0x0001a6a809037836ULL, 0x002fe20000000000ULL,
0x00000000620472caULL, 0x000fe200000e0000ULL, 0x00000001ff027424ULL, 0x000fe200078e00ffULL,
0x000000ff6100720cULL, 0x000fe20003f05270ULL, 0x000000ffff837224ULL, 0x000fe200078e00ffULL,
0x00000000030572caULL, 0x000fe400000e0000ULL, 0x00000000002e7805ULL, 0x000fe4000001ff00ULL,
0x00000000002c7805ULL, 0x000fe4000001ff00ULL, 0x0000000000327805ULL, 0x000fc4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000227805ULL, 0x000fe4000001ff00ULL,
0x0000000000207805ULL, 0x000fe4000001ff00ULL, 0x00000000001e7805ULL, 0x000fe4000001ff00ULL,
0x00000000001c7805ULL, 0x000fe4000001ff00ULL, 0x00000000001a7805ULL, 0x000fc4000001ff00ULL,
0x0000000000187805ULL, 0x000fe4000001ff00ULL, 0x0000000000167805ULL, 0x000fe4000001ff00ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000504047291ULL, 0x000fe2000f8e203fULL,
0x0000000000127805ULL, 0x000fe4000001ff00ULL, 0x0000000000107805ULL, 0x000fe4000001ff00ULL,
0x00000000000e7805ULL, 0x000fc4000001ff00ULL, 0x00000000000c7805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000007918ULL, 0x000fe20000000000ULL, 0x0000000000527805ULL, 0x000fc4000001ff00ULL,
0x0000000000507805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x000000ffff497224ULL, 0x000fe400078e00ffULL,
0x0000000862037824ULL, 0x000fe200078e0203ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x00000002ff7a79a7ULL, 0x0002a20008500004ULL, 0x000000ffff487224ULL, 0x000fe200078e00ffULL,
0x0000000000467805ULL, 0x000fc4000001ff00ULL, 0x0000000000447805ULL, 0x000fe4000001ff00ULL,
0x0000000000427805ULL, 0x000fe4000001ff00ULL, 0x0000000000407805ULL, 0x000fe4000001ff00ULL,
0x00000000003e7805ULL, 0x000fe4000001ff00ULL, 0x00000000003c7805ULL, 0x000fe2000001ff00ULL,
0x00002002030279a7ULL, 0x002e62000850003fULL, 0x0000000000567805ULL, 0x000fc4000001ff00ULL,
0x0000000000547805ULL, 0x000fe2000001ff00ULL, 0x0000009c00e08947ULL, 0x000fec0003800000ULL,
0x00009400ff047b82ULL, 0x000ee20000000800ULL, 0x00000002ff5a7819ULL, 0x000fe20000011678ULL,
0x0000000878027824ULL, 0x002fe200078e00ffULL, 0x0000000162007812ULL, 0x000fe200078ec0ffULL,
0x0000000205057824ULL, 0x000fe400078e00ffULL, 0x000000205a077824ULL, 0x000fe200078e0209ULL,
0x0000000802027812ULL, 0x000fe200078ec0ffULL, 0x000000ffff397224ULL, 0x000fe400078e0003ULL,
0x0000001000077824ULL, 0x000fc400078e0207ULL, 0xff317217ff7e7424ULL, 0x000fe400078e00ffULL,
0x0000000102087824ULL, 0x000fe400078e0207ULL, 0x000000ffff587224ULL, 0x000fe400078e00ffULL,
0x000000ffff2f7224ULL, 0x000fe400078e00ffULL, 0x0000000405077224ULL, 0x008fce00078e0204ULL,
0x0000000000347805ULL, 0x016fce0000015200ULL, 0x0000000478067824ULL, 0x000fca00078e00ffULL,
0xfffffff806067812ULL, 0x000fca00078ec0ffULL, 0x0000000109387824ULL, 0x000fc800078e0206ULL,
0x01a6c839380075a7ULL, 0x000e62000800017fULL, 0x0001a6c838067836ULL, 0x000fe20000000000ULL,
0x00000000005c0947ULL, 0x002fec0003800000ULL, 0x000000ffff3a7224ULL, 0x000fce00078e00ffULL,
0x000000103a00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000013a3a7836ULL, 0x000fce0000000000ULL,
0x01a6c839380075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x0000001078347824ULL, 0x000fe200078e00ffULL, 0x0000850000057ab9ULL, 0x000fe20000000800ULL,
0x0000000158367836ULL, 0x000fe40000000000ULL, 0x0000000582827c24ULL, 0x000fe2000f8e02ffULL,
0xffffffe034357812ULL, 0x000fe400078ec0ffULL, 0x000000613600720cULL, 0x000fe20003f26070ULL,
0x0000008082827824ULL, 0x000fe400078e00ffULL, 0x0000010058357824ULL, 0x000fc800078e0235ULL,
0x0000004035357836ULL, 0x000fca0000000000ULL, 0x0000006035367812ULL, 0x000fca00078ec0ffULL,
0x00000001594c7824ULL, 0x000fe200078e0236ULL, 0x0000000400109947ULL, 0x000fec0003800000ULL,
0x0000001034377812ULL, 0x000fe400078ec0ffULL, 0x0000003574347248ULL, 0x000fe40007fe0000ULL,
0x00000003ff3a7819ULL, 0x000fc6000001160aULL, 0x0000000134347824ULL, 0x000fe400078e0a35ULL,
0x000000013a397824ULL, 0x100fe400078e0237ULL, 0x000000083a4d7836ULL, 0x000fe20000000000ULL,
0x0000003734367248ULL, 0x000fe20007fe0000ULL, 0x0000000139387824ULL, 0x040fe200078e020aULL,
0x00008e00ff347b82ULL, 0x000e620000000a00ULL, 0x00000008393b7824ULL, 0x000fe400078e00ffULL,
0x0000000136367824ULL, 0x000fc400078e0a37ULL, 0x000000014c397824ULL, 0x000fe200078e0239ULL,
0xfffffff83b4e7812ULL, 0x000fe200078ee238ULL, 0x000000043a3b7836ULL, 0x000fe20000000000ULL,
0x000000363a00720cULL, 0x080fe20003f86070ULL, 0x0000000c3a3a7836ULL, 0x000fe20000000000ULL,
0x000000364d00720cULL, 0x080fe20003f46070ULL, 0x000000100a387824ULL, 0x000fe200078e00ffULL,
0x000000363b00720cULL, 0x0c0fe20003f66070ULL, 0x000000013b3b7824ULL, 0x100fe200078e0237ULL,
0x000000363a00720cULL, 0x000fe20003f06070ULL, 0x000000014d4d7824ULL, 0x000fc400078e0237ULL,
0x000000013b367824ULL, 0x140fe400078e020aULL, 0x000000083b5d7824ULL, 0x000fe400078e00ffULL,
0x000000013a4f7824ULL, 0x000fe400078e0237ULL, 0x000000014d377824ULL, 0x040fe200078e020aULL,
0xfffffff85d5c7812ULL, 0x000fe200078ee236ULL, 0x000000084d5e7824ULL, 0x000fe200078e00ffULL,
0x00000070385d7812ULL, 0x000fe200078ec0ffULL, 0x0000008039387825ULL, 0x000fc600078e00ffULL,
0xfffffff85e5e7812ULL, 0x000fe200078ee237ULL, 0x000000014c367824ULL, 0x040fe400078e023bULL,
0x000000014c3a7824ULL, 0x040fe400078e024dULL, 0x000000014c4c7824ULL, 0x000fe400078e024fULL,
0x000000014f3b7824ULL, 0x040fe400078e020aULL, 0x000000084f647824ULL, 0x000fe200078e00ffULL,
0x00000034824f7211ULL, 0x002fe200078a38ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000005d38347212ULL, 0x000fc400078efcffULL, 0x0000003582677211ULL, 0x000fe200028f3cffULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x000000344f347210ULL, 0x000fe40007fbe0ffULL,
0xfffffff864647812ULL, 0x000fe200078ee23bULL, 0x000000803a3a7825ULL, 0x000fe200078e00ffULL,
0x0000005d36367212ULL, 0x000fc600078efcffULL, 0x0000000139357824ULL, 0x000fe200028e0667ULL,
0x0000004f36367210ULL, 0x000fe20007fbe0ffULL, 0x0000200062397824ULL, 0x000fe200078e0209ULL,
0x0000005d3a387212ULL, 0x080fe400078efcffULL, 0x0000005d4c3a7212ULL, 0x000fe200078efcffULL,
0x0001700039397836ULL, 0x000fe40000000000ULL, 0x0000000137377824ULL, 0x000fe200028e0667ULL,
0x0000004f38387210ULL, 0x000fe20007fbe0ffULL, 0x000000105c5d7824ULL, 0x100fe200078e0239ULL,
0x0000004f3a3a7210ULL, 0x000fe20007fde0ffULL, 0x000000104e4f7824ULL, 0x000fc400078e0239ULL,
0x000000105e5f7824ULL, 0x100fe400078e0239ULL, 0x0000001064657824ULL, 0x000fe200078e0239ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000344f7faeULL, 0x0003e2000e101c46ULL,
0x000000013b397824ULL, 0x100fe400028e0667ULL, 0x000000014d3b7824ULL, 0x000fe200030e0667ULL,
0x00000000365d7faeULL, 0x0003e8000d901c46ULL, 0x00000000385f7faeULL, 0x0003e8000d101c46ULL,
0x000000003a657faeULL, 0x0003e2000c101c46ULL, 0x0000000000dc7947ULL, 0x000fea0003800000ULL,
0x0000001034377812ULL, 0x000fe400078ec0ffULL, 0x00008e00ff347b82ULL, 0x000e640000000a00ULL,
0x000000370a377211ULL, 0x000fca00078fe8ffULL, 0x0000000437397836ULL, 0x000fe40000000000ULL,
0x0000000137367824ULL, 0x140fe400078e020aULL, 0x00000008373b7824ULL, 0x000fe400078e00ffULL,
0x0000000139387824ULL, 0x040fe400078e020aULL, 0x00000008394d7824ULL, 0x000fe200078e00ffULL,
0xfffffff83b4e7812ULL, 0x000fe200078ee236ULL, 0x000000014c367824ULL, 0x000fc400078e0237ULL,
0x00000008373b7836ULL, 0x000fe20000000000ULL, 0xfffffff84d5c7812ULL, 0x000fe200078ee238ULL,
0x000000100a387824ULL, 0x000fe400078e00ffULL, 0x0000000c374d7836ULL, 0x000fe20000000000ULL,
0x00000034825d7211ULL, 0x002fe200078038ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x00000070384f7812ULL, 0x000fe400078ec0ffULL, 0x0000003582677211ULL, 0x000fe200000f3cffULL,
0x000000014c3a7824ULL, 0x000fe200078e023bULL, 0x0000004f36347212ULL, 0x000fe200078efcffULL,
0x000000013b387824ULL, 0x000fc400078e020aULL, 0x000000083b5f7824ULL, 0x000fe200078e00ffULL,
0x000000345d347210ULL, 0x000fe20007f1e0ffULL, 0x000000014d3b7824ULL, 0x040fe400078e020aULL,
0x000000084d647824ULL, 0x000fe200078e00ffULL, 0xfffffff85f5e7812ULL, 0x000fe200078ee238ULL,
0x000000014c397824ULL, 0x040fe400078e0239ULL, 0x000000014c4c7824ULL, 0x000fe200078e024dULL,
0xfffffff864647812ULL, 0x000fe200078ee23bULL, 0x0000008039387825ULL, 0x000fc800078e00ffULL,
0x000000803a3a7825ULL, 0x000fe200078e00ffULL, 0x0000004f38367212ULL, 0x000fc600078efcffULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x0000004f3a387212ULL, 0x000fc600078efcffULL,
0x0000000137357824ULL, 0x000fe200000e0667ULL, 0x0000004f4c3a7212ULL, 0x000fe200078efcffULL,
0x0000200062377824ULL, 0x000fe200078e0209ULL, 0x000000365d367210ULL, 0x000fe40007f1e0ffULL,
0x000000385d387210ULL, 0x000fe20007f5e0ffULL, 0x0001700037377836ULL, 0x000fe20000000000ULL,
0x0000003a5d3a7210ULL, 0x000fc60007f7e0ffULL, 0x000000104e4f7824ULL, 0x100fe400078e0237ULL,
0x000000105c5d7824ULL, 0x100fe400078e0237ULL, 0x000000105e5f7824ULL, 0x100fe200078e0237ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000344f7faeULL, 0x0003e2000b901c46ULL,
0x0000001064657824ULL, 0x000fe400078e0237ULL, 0x0000000139377824ULL, 0x100fe400000e0667ULL,
0x000000013b397824ULL, 0x000fc400010e0667ULL, 0x000000014d3b7824ULL, 0x000fe200018e0667ULL,
0x00000000365d7faeULL, 0x0003e8000b901c46ULL, 0x00000000385f7faeULL, 0x0003e8000b901c46ULL,
0x000000003a657faeULL, 0x0003e4000b901c46ULL, 0x0000000160367836ULL, 0x002fe40000000000ULL,
0xffffffffff7a7424ULL, 0x004fc600078e00ffULL, 0x000000633600720cULL, 0x000fe20003f06070ULL,
0x0000000878387824ULL, 0x000fd800078e00ffULL, 0x0000000107378824ULL, 0x000fe200078e0236ULL,
0xfffffff038367812ULL, 0x000fe200078ec0ffULL, 0x00009000ff348b82ULL, 0x000e680000000a00ULL,
0x00000001093a7824ULL, 0x000fca00078e0236ULL, 0x000000003a0572caULL, 0x000fe200000e0000ULL,
0x0000000000007918ULL, 0x000fd80000000000ULL, 0x0001a6b005057890ULL, 0x000fe2000fffe03fULL,
0x0000000437348825ULL, 0x002fca00078e0034ULL, 0x00000006347a8981ULL, 0x000322000c1e1900ULL,
0xffffffe038367812ULL, 0x040fe200078ec0ffULL, 0x00000001ff397424ULL, 0x000fe200078e00ffULL,
0x0000001038377812ULL, 0x040fe200078ec0ffULL, 0x00000000ff0079b0ULL, 0x000fe60008000a45ULL,
0x0000000937367210ULL, 0x000fe40007ffe036ULL, 0x0000000838377812ULL, 0x000fca00078ec0ffULL,
0x0000000136807824ULL, 0x000fe200078e0237ULL, 0x0000000000007918ULL, 0x002fcc0000000000ULL,
0x01a6b0393a8679a7ULL, 0x0002a4000850003fULL, 0x01a60839803879a7ULL, 0x0022e4000850003fULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x01a60839800075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a60839800075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x000000100a6e7824ULL, 0x000fe200078e00ffULL, 0x00000001ff6f7819ULL, 0x000fe2000001160aULL,
0x0000002078347824ULL, 0x000fe400078e00ffULL, 0x00000001ff387424ULL, 0x000fe200078e00ffULL,
0x000000706e6e7812ULL, 0x000fe200078ec0ffULL, 0x000000ffff857224ULL, 0x000fe200078e007eULL,
0xffffff8034347812ULL, 0x000fe400078ec0ffULL, 0x0000000c6f6f7812ULL, 0x000fe400078ec0ffULL,
0x000000096e347210ULL, 0x000fca0007ffe034ULL, 0x0000000134347824ULL, 0x000fca00078e026fULL,
0x01a0000034357984ULL, 0x000ee80000000800ULL, 0x01a2000034367984ULL, 0x000b620000000800ULL,
0x0000007e3500720bULL, 0x008fda0003f1d000ULL, 0x0000000000377806ULL, 0x000fc800000e0100ULL,
0x000000ff3700720cULL, 0x000fda0003f05270ULL, 0x00000004008c8947ULL, 0x026fea0003800000ULL,
0x000000785a00720cULL, 0x000fe40003f45270ULL, 0x0000007e3500720bULL, 0x0c0fe40003f14000ULL,
0x0000007e35857209ULL, 0x000fd20007810000ULL, 0x000000807834a824ULL, 0x000fe400078e0209ULL,
0x00000000004c7806ULL, 0x000fc600000e0100ULL, 0x000000346f34a210ULL, 0x000fe40007ffe06eULL,
0x000000ff4c00720cULL, 0x000fc60003f05270ULL, 0x01a400853400a388ULL, 0x0003f40000000800ULL,
0x0000000400508947ULL, 0x002fea0003800000ULL, 0x0000007e85347221ULL, 0x000fe20000010100ULL,
0x000000ff4cff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff004cff7812ULL, 0x000fe2000784c0ffULL,
0x3fb8aa3b34347820ULL, 0x000fe20000410000ULL, 0x00ff00004cff7812ULL, 0x040fe4000786c0ffULL,
0xff0000004cff7812ULL, 0x000fe2000788c0ffULL, 0x0000003400397308ULL, 0x0002ac0000000800ULL,
0x0000000000488947ULL, 0x000fec0003800000ULL, 0x00000002ff347819ULL, 0x002fcc000001160aULL,
0x00001f3439347589ULL, 0x004e6400000e0000ULL, 0x0000003454547220ULL, 0x082fe20000410000ULL,
0x0000003455557220ULL, 0x080fe20000410000ULL, 0x000000343c3c7220ULL, 0x080fe20000410000ULL,
0x000000343d3d7220ULL, 0x080fe20000410000ULL, 0x0000003440407220ULL, 0x080fe20000410000ULL,
0x0000003441417220ULL, 0x080fe20000410000ULL, 0x0000003444447220ULL, 0x080fe20000410000ULL,
0x0000003445457220ULL, 0x080fe20000410000ULL, 0x0000003448487220ULL, 0x080fe20000410000ULL,
0x0000003449497220ULL, 0x080fe20000410000ULL, 0x0000003450507220ULL, 0x080fe20000410000ULL,
0x0000003451517220ULL, 0x080fe20000410000ULL, 0x0000003428287220ULL, 0x080fe20000410000ULL,
0x0000003429297220ULL, 0x080fe20000410000ULL, 0x0000003424247220ULL, 0x080fe20000410000ULL,
0x0000003425257220ULL, 0x000fce0000410000ULL, 0x000000000048a947ULL, 0x000fea0003800000ULL,
0x000000080a347811ULL, 0x002fcc00078ff0ffULL, 0x00001f3439347589ULL, 0x004e6400000e0000ULL,
0x0000003456567220ULL, 0x082fe20000410000ULL, 0x0000003457577220ULL, 0x080fe20000410000ULL,
0x000000343e3e7220ULL, 0x080fe20000410000ULL, 0x000000343f3f7220ULL, 0x080fe20000410000ULL,
0x0000003442427220ULL, 0x080fe20000410000ULL, 0x0000003443437220ULL, 0x080fe20000410000ULL,
0x0000003446467220ULL, 0x080fe20000410000ULL, 0x0000003447477220ULL, 0x080fe20000410000ULL,
0x000000344a4a7220ULL, 0x080fe20000410000ULL, 0x000000344b4b7220ULL, 0x080fe20000410000ULL,
0x0000003452527220ULL, 0x080fe20000410000ULL, 0x0000003453537220ULL, 0x080fe20000410000ULL,
0x000000342a2a7220ULL, 0x080fe20000410000ULL, 0x000000342b2b7220ULL, 0x080fe20000410000ULL,
0x0000003426267220ULL, 0x080fe20000410000ULL, 0x0000003427277220ULL, 0x000fce0000410000ULL,
0x000000000048b947ULL, 0x000fea0003800000ULL, 0x000000100a347811ULL, 0x002fcc00078ff0ffULL,
0x00001f3439347589ULL, 0x004e6400000e0000ULL, 0x000000340c0c7220ULL, 0x082fe20000410000ULL,
0x000000340d0d7220ULL, 0x080fe20000410000ULL, 0x0000003410107220ULL, 0x080fe20000410000ULL,
0x0000003411117220ULL, 0x080fe20000410000ULL, 0x0000003414147220ULL, 0x080fe20000410000ULL,
0x0000003415157220ULL, 0x080fe20000410000ULL, 0x0000003418187220ULL, 0x080fe20000410000ULL,
0x0000003419197220ULL, 0x080fe20000410000ULL, 0x000000341c1c7220ULL, 0x080fe20000410000ULL,
0x000000341d1d7220ULL, 0x080fe20000410000ULL, 0x0000003420207220ULL, 0x080fe20000410000ULL,
0x0000003421217220ULL, 0x080fe20000410000ULL, 0x0000003430307220ULL, 0x080fe20000410000ULL,
0x0000003431317220ULL, 0x080fe20000410000ULL, 0x000000342c2c7220ULL, 0x080fe20000410000ULL,
0x000000342d2d7220ULL, 0x000fce0000410000ULL, 0x0000003983837220ULL, 0x004fe20000410000ULL,
0x000000000048c947ULL, 0x000fec0003800000ULL, 0x000000180a347811ULL, 0x002fcc00078ff0ffULL,
0x00001f3439347589ULL, 0x000e6400000e0000ULL, 0x000000340e0e7220ULL, 0x082fe20000410000ULL,
0x000000340f0f7220ULL, 0x080fe20000410000ULL, 0x0000003412127220ULL, 0x080fe20000410000ULL,
0x0000003413137220ULL, 0x080fe20000410000ULL, 0x0000003416167220ULL, 0x080fe20000410000ULL,
0x0000003417177220ULL, 0x080fe20000410000ULL, 0x000000341a1a7220ULL, 0x080fe20000410000ULL,
0x000000341b1b7220ULL, 0x080fe20000410000ULL, 0x000000341e1e7220ULL, 0x080fe20000410000ULL,
0x000000341f1f7220ULL, 0x080fe20000410000ULL, 0x0000003422227220ULL, 0x080fe20000410000ULL,
0x0000003423237220ULL, 0x080fe20000410000ULL, 0x0000003432327220ULL, 0x080fe20000410000ULL,
0x0000003433337220ULL, 0x080fe20000410000ULL, 0x000000342e2e7220ULL, 0x080fe20000410000ULL,
0x000000342f2f7220ULL, 0x000fce0000410000ULL, 0x0000004c37ff7212ULL, 0x000fda00078030ffULL,
0x8000008535350221ULL, 0x000fe20000010000ULL, 0x00007610ff380816ULL, 0x000fc60000000038ULL,
0x3fb8aa3b35350820ULL, 0x000fc80000410000ULL, 0x0000003500040308ULL, 0x000ea40000000800ULL,
0x0000000436360220ULL, 0x004fce0000410000ULL, 0x0000008336837221ULL, 0x000fce0000010000ULL,
0x0000000000347805ULL, 0x002fce0000015200ULL, 0x01a6a87b3a0075a7ULL, 0x000e62000800017fULL,
0x0001a6a83a397836ULL, 0x000fca0000000000ULL, 0x00000000390572caULL, 0x000fe200000e0000ULL,
0x0000000000600947ULL, 0x002fdc0003800000ULL, 0x000000ffff4c7224ULL, 0x000fce00078e00ffULL,
0x000000104c00780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000367805ULL, 0x000fce0000015200ULL, 0x00000036343b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000137377824ULL, 0x000fe200000e0e35ULL, 0x003d09003b00780cULL, 0x000fc80003f06070ULL,
0x000000ff3700720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403b00780cULL, 0x000fc80003f06070ULL, 0x000000ff3700720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff367819ULL, 0x000fc80000011437ULL,
0x0000003b36367211ULL, 0x000fca00078110ffULL, 0x000000ffff377224ULL, 0x000fca00000e0637ULL,
0x0000000236367819ULL, 0x000fc80000001237ULL, 0x000000360000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x000000014c4c7836ULL, 0x000fce0000000000ULL,
0x01a6a87b3a0075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000000390572caULL, 0x000fde00000e0000ULL, 0x00000002787c7824ULL, 0x000fe200078e00ffULL,
0x000000080a357812ULL, 0x000fe200078ec0ffULL, 0x0000000478717824ULL, 0x000fe200078e00ffULL,
0x0000991038387816ULL, 0x000fe200000000ffULL, 0x0000100078377824ULL, 0x000fe200078e00ffULL,
0x000000047c7d7812ULL, 0x000fe400078ec0ffULL, 0x00000007356c7812ULL, 0x000fe200078ef80aULL,
0x000000ffff357224ULL, 0x000fe200078e0038ULL, 0x0000007d0a347211ULL, 0x000fe400078fe0ffULL,
0x000000106c797812ULL, 0x040fe200078efcffULL, 0x000000086c367824ULL, 0x040fe200078e00ffULL,
0x000000ff3500720cULL, 0x000fe20003f05270ULL, 0x000000016c7f7824ULL, 0x000fe200078e0234ULL,
0x0000000471717812ULL, 0x000fe200078ec0ffULL, 0x0000040078357824ULL, 0x000fe200078e00ffULL,
0xffffe00037387812ULL, 0x000fe200078ec0ffULL, 0x00000001347e7824ULL, 0x000fe200078e0279ULL,
0xfffffff8367f7812ULL, 0x000fe200078ee27fULL, 0x000000086c6d7824ULL, 0x000fe200078e00ffULL,
0xfffff00035367812ULL, 0x000fe200078ec0ffULL, 0x0000000879357824ULL, 0x000fe200078e00ffULL,
0x000000710a717211ULL, 0x000fc400078fe0ffULL, 0x0001200009737810ULL, 0x040fe40007ffe036ULL,
0xfffffff8357e7812ULL, 0x000fe200078ee27eULL, 0x000000016c4c7824ULL, 0x000fe200078e0271ULL,
0x00016000094e7810ULL, 0x000fe20007ffe038ULL, 0x000000107f367824ULL, 0x100fe400078e0273ULL,
0x000000107e387824ULL, 0x000fe200078e0273ULL, 0xfffffff86d6d7812ULL, 0x000fe200078ee24cULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000000ffULL, 0x0000001003057836ULL, 0x000fe20000000000ULL,
0x0000541000347816ULL, 0x000fe20000000000ULL, 0x0000000803357836ULL, 0x000fe40000000000ULL,
0x0000001803377836ULL, 0x000fe40000000000ULL, 0x00001f0534057589ULL, 0x0002a800000e0000ULL,
0x00001f3534027589ULL, 0x0002e800000e0000ULL, 0x00001f0334037589ULL, 0x00026800000e0000ULL,
0x00001f3734007589ULL, 0x00026400000e0000ULL, 0x000000003634783bULL, 0x002e620000000200ULL,
0x000000106d5c7824ULL, 0x000fc600078e024eULL, 0x000000003838783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x088fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x0000000538387232ULL, 0x084fe40000000000ULL,
0x000000053a3a7232ULL, 0x000fc40000000000ULL, 0x0000000039397232ULL, 0x080fe40000000000ULL,
0x000000003b3b7232ULL, 0x000fce0000000000ULL, 0x000000005c5c783bULL, 0x000f620000004200ULL,
0x000000086c647824ULL, 0x000fe200078e00ffULL, 0x000000027d7d7812ULL, 0x000fe200078efcffULL,
0x000000024c7b7836ULL, 0x000fc60000000000ULL, 0x0000007d0a7d7211ULL, 0x000fe400078fe0ffULL,
0xfffffff8647b7812ULL, 0x000fca00078ee27bULL, 0x000000107b4e7824ULL, 0x000fcc00078e024eULL,
0x000000004e4c783bULL, 0x000f640000004200ULL, 0x000001005c647824ULL, 0x068fe200078e00ffULL,
0x000088805d8e7816ULL, 0x040fe200000000ffULL, 0x000001005d657824ULL, 0x040fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe4000001145cULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x0000008e008e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff8a7819ULL, 0x000fe2000001145dULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x000088805c897816ULL, 0x040fe200000000ffULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fc4000001145eULL, 0x00000018ff957819ULL, 0x000fe2000001145dULL,
0x0000006400907306ULL, 0x0007e20000200c00ULL, 0x00000018ff937819ULL, 0x000fe2000001145cULL,
0x000001005e5d7824ULL, 0x040fe200078e00ffULL, 0x000088805e5c7816ULL, 0x000fe200000000ffULL,
0x000001004d697824ULL, 0x004fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe2000001144dULL,
0x000001004c687824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe2000001144cULL,
0x0000006500977306ULL, 0x0005620000200c00ULL, 0x000001005f647824ULL, 0x008fe200078e00ffULL,
0x00000018ff917819ULL, 0x000fe2000001145dULL, 0x000001004e707824ULL, 0x000fe200078e00ffULL,
0x00000018ff687819ULL, 0x000fc40000011468ULL, 0x00000018ff847819ULL, 0x000fe4000001145fULL,
0x0000008900897306ULL, 0x000ee20000200c00ULL, 0x00000018ff657819ULL, 0x004fe20000011464ULL,
0x000100005e647824ULL, 0x000fe200078e00ffULL, 0x000088805f5d7816ULL, 0x040fe200000000ffULL,
0x000100005f5f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe40000011469ULL,
0x00000018ff8f7819ULL, 0x000fe20000011464ULL, 0x00000065005e7306ULL, 0x0005e20000200c00ULL,
0x000088804c647816ULL, 0x040fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6a7819ULL, 0x000fc4000001144eULL, 0x00000018ff6b7819ULL, 0x000fe4000001144fULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x00000068008d7306ULL, 0x0007e20000200c00ULL,
0x000088804d657816ULL, 0x044fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x00000018ff817819ULL, 0x000fe40000011470ULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000004c008b7306ULL, 0x0005e20000200c00ULL,
0x000088804e687816ULL, 0x04afe200000000ffULL, 0x000100004e4e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe2000001144eULL, 0x0000004d00727306ULL, 0x000be20000200c00ULL,
0x000001004f4c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000006900827306ULL, 0x0003e20000200c00ULL, 0x000054108e4d7816ULL, 0x020fe20000000097ULL,
0x000100004f8e7824ULL, 0x000fca00078e00ffULL, 0x00000018ff8e7819ULL, 0x000fe2000001148eULL,
0x0000004c00707306ULL, 0x0005e20000200c00ULL, 0x000088804f697816ULL, 0x002fce00000000ffULL,
0x0000005d005d7306ULL, 0x000e620000200c00ULL, 0x00005410894c7816ULL, 0x004fce0000000090ULL,
0x0000008c008c7306ULL, 0x000fe20000200c00ULL, 0x0000004c3454723cULL, 0x000fe20000001854ULL,
0x000054105d5d7816ULL, 0x002fcc000000005eULL, 0x0000008a008a7306ULL, 0x000fe20000200c00ULL,
0x0000004c380c723cULL, 0x000fee000000180cULL, 0x0000008800887306ULL, 0x000fe20000200c00ULL,
0x00000001794c7824ULL, 0x000fce00078e0271ULL, 0x0000008400847306ULL, 0x000ff00000200c00ULL,
0x0000006600667306ULL, 0x000e700000200c00ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x000054108b667816ULL, 0x002fce0000000066ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541072677816ULL, 0x004fce0000000067ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x0000200062727824ULL, 0x000fe200078e0209ULL, 0x000000663450723cULL, 0x000fec0000001850ULL,
0x0000009300937306ULL, 0x000fe20000200c00ULL, 0x000000663820723cULL, 0x000fee0000001820ULL,
0x0000009500957306ULL, 0x000e700000200c00ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x00005410954f7816ULL, 0x002fce000000008aULL, 0x0000009100917306ULL, 0x000e700000200c00ULL,
0x0000008f008f7306ULL, 0x000ea20000200c00ULL, 0x000054105c5c7816ULL, 0x002fce0000000091ULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x000054108f5e7816ULL, 0x004fcc0000000088ULL, 0x0000006400647306ULL, 0x000ea20000200c00ULL,
0x0000005c3814723cULL, 0x000fe20000001814ULL, 0x000054105f5f7816ULL, 0x002fcc0000000084ULL,
0x0000006500657306ULL, 0x000e620000200c00ULL, 0x0001600072847836ULL, 0x000fe20000000000ULL,
0x0000005e3444723cULL, 0x000fe20000001844ULL, 0x0000541064647816ULL, 0x004fca000000008dULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x0000005e3818723cULL, 0x000fe20000001818ULL,
0x0000541065657816ULL, 0x002fcc0000000082ULL, 0x0000008100817306ULL, 0x000e620000200c00ULL,
0x000000643448723cULL, 0x000fee0000001848ULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x00000064381c723cULL, 0x000fe2000000181cULL, 0x0000541068687816ULL, 0x002fcc0000000081ULL,
0x0000004e00897306ULL, 0x0002e20000200c00ULL, 0x0000541069697816ULL, 0x004fce0000000070ULL,
0x0000008e008e7306ULL, 0x000ea20000200c00ULL, 0x00005410934e7816ULL, 0x002fe2000000008cULL,
0x000000016c707824ULL, 0x100fe400078e027dULL, 0x00000001797d7824ULL, 0x000fe200078e027dULL,
0x000000683428723cULL, 0x000fe20000001828ULL, 0x00005410896a7816ULL, 0x008fca000000006aULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x000054108e6b7816ULL, 0x004fca000000006bULL,
0x0000004e3810723cULL, 0x000fec0000001810ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x000000683830723cULL, 0x000fe20000001830ULL, 0x000000086c357824ULL, 0x000fc400078e00ffULL,
0x0000000879347824ULL, 0x000fc600078e00ffULL, 0xfffffff835707812ULL, 0x000fe200078ee270ULL,
0x0000000879357824ULL, 0x000fe200078e00ffULL, 0xfffffff834717812ULL, 0x000fe200078ee27dULL,
0x0000006a3838723cULL, 0x000fe4000000182cULL, 0x0000001070347824ULL, 0x100fe200078e0273ULL,
0xfffffff8357d7812ULL, 0x000fe200078ee24cULL, 0x0000001071737824ULL, 0x000fc800078e0273ULL,
0x000000003434783bULL, 0x000e620000000200ULL, 0x000000107d5c7824ULL, 0x000fc600078e0284ULL,
0x00000000732c783bULL, 0x0004e20000000200ULL, 0x0000000000200947ULL, 0x000ff60003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x080fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x00000008794e7824ULL, 0x000fe200078e00ffULL, 0x000000005c5c783bULL, 0x000f620000004200ULL,
0x000000024c737836ULL, 0x004fe20000000000ULL, 0xfffffff87c7c7812ULL, 0x000fc800078ec0ffULL,
0xfffffff84e737812ULL, 0x000fe200078ee273ULL, 0x00000001097c7824ULL, 0x000fc800078e027cULL,
0x00000010734c7824ULL, 0x000fcc00078e0284ULL, 0x000000004c4c783bULL, 0x000ea20000004200ULL,
0x000001005c647824ULL, 0x020fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fe2000001145dULL,
0x000001005d657824ULL, 0x040fe200078e00ffULL, 0x000088805d947816ULL, 0x040fe200000000ffULL,
0x000100005d5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x0000009000907306ULL, 0x000fe20000200c00ULL,
0x00000018ff957819ULL, 0x000fe2000001145dULL, 0x000001005e5d7824ULL, 0x000fe200078e00ffULL,
0x000088805c897816ULL, 0x000fc400000000ffULL, 0x00000018ff927819ULL, 0x000fe2000001145cULL,
0x000100005c5c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff917819ULL, 0x000fe2000001145dULL,
0x0000006400967306ULL, 0x000be20000200c00ULL, 0x00000018ff667819ULL, 0x004fe2000001144cULL,
0x000001004d687824ULL, 0x000fe200078e00ffULL, 0x000088805f5d7816ULL, 0x040fe200000000ffULL,
0x000001004e697824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe4000001144dULL,
0x00000018ff937819ULL, 0x000fe2000001145cULL, 0x0000006500977306ULL, 0x0005e20000200c00ULL,
0x000001005f647824ULL, 0x028fe200078e00ffULL, 0x00000018ff8f7819ULL, 0x000fc4000001145eULL,
0x00000018ff8e7819ULL, 0x000fe2000001145fULL, 0x000100005f5f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe40000011464ULL, 0x0000009400947306ULL, 0x000fe20000200c00ULL,
0x000001004c657824ULL, 0x044fe200078e00ffULL, 0x000088804c647816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x000088805e5c7816ULL, 0x040fe200000000ffULL,
0x000100005e5e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fc40000011465ULL,
0x000088804d657816ULL, 0x040fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x0000008900897306ULL, 0x000fe20000200c00ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000018ff8c7819ULL, 0x000fe40000011468ULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff6a7819ULL, 0x000fe2000001144eULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x000088804e687816ULL, 0x040fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fc40000011469ULL, 0x00000018ff6b7819ULL, 0x000fe4000001144fULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000008a008a7306ULL, 0x000ea20000200c00ULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x000088804f697816ULL, 0x000fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fc6000001144eULL, 0x0000004c008b7306ULL, 0x0007e20000200c00ULL,
0x000054105d5d7816ULL, 0x004fce000000008aULL, 0x0000004d00887306ULL, 0x0005e20000200c00ULL,
0x000001004f4c7824ULL, 0x008fca00078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000009200927306ULL, 0x000fe20000200c00ULL, 0x00005410944d7816ULL, 0x004fe20000000097ULL,
0x000100004f947824ULL, 0x000fca00078e00ffULL, 0x00000018ff947819ULL, 0x000fe20000011494ULL,
0x0000004c00827306ULL, 0x0005f00000200c00ULL, 0x0000008f008f7306ULL, 0x000fe20000200c00ULL,
0x00005410894c7816ULL, 0x004fce0000000096ULL, 0x0000008e008e7306ULL, 0x000fe20000200c00ULL,
0x0000004c3454723cULL, 0x002fec0000001854ULL, 0x0000004c2c0c723cULL, 0x000fe2000000180cULL,
0x0000006600667306ULL, 0x000e700000200c00ULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x000054108b667816ULL, 0x002fce0000000066ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541088677816ULL, 0x004fce0000000067ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000000663450723cULL, 0x000fee0000001850ULL, 0x0000009300937306ULL, 0x000fe20000200c00ULL,
0x000000662c20723cULL, 0x000fee0000001820ULL, 0x0000009500957306ULL, 0x000e700000200c00ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00005410954f7816ULL, 0x002fce0000000090ULL,
0x0000009100917306ULL, 0x000e700000200c00ULL, 0x0000005e005e7306ULL, 0x000ea20000200c00ULL,
0x000054105c5c7816ULL, 0x002fce0000000091ULL, 0x0000005f005f7306ULL, 0x000e620000200c00ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x000054105e5e7816ULL, 0x004fcc000000008fULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000005c2c14723cULL, 0x000fe20000001814ULL,
0x000054105f5f7816ULL, 0x002fcc000000008eULL, 0x0000008d008d7306ULL, 0x000e620000200c00ULL,
0x0000005e3444723cULL, 0x000fee0000001844ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0000005e2c18723cULL, 0x000fe20000001818ULL, 0x0000541064647816ULL, 0x002fcc000000008dULL,
0x0000008c008c7306ULL, 0x000e700000200c00ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000541065657816ULL, 0x002fce000000008cULL, 0x0000008100817306ULL, 0x000e620000200c00ULL,
0x000000643448723cULL, 0x000fee0000001848ULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x000000642c1c723cULL, 0x000fe2000000181cULL, 0x0000541068687816ULL, 0x002fcc0000000081ULL,
0x0000004e00897306ULL, 0x0002e20000200c00ULL, 0x0000541069697816ULL, 0x004fce0000000082ULL,
0x00000094008a7306ULL, 0x000ea20000200c00ULL, 0x00005410934e7816ULL, 0x002fe20000000092ULL,
0x000000683428723cULL, 0x000fe20000001828ULL, 0x00005410896a7816ULL, 0x008fca000000006aULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x000054108a6b7816ULL, 0x004fca000000006bULL,
0x0000004e2c10723cULL, 0x000fec0000001810ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x000000682c30723cULL, 0x000fe20000001830ULL, 0x0000000862347824ULL, 0x000fc400078e0209ULL,
0x00000001ff377424ULL, 0x000fc600078e00ffULL, 0x0000006a2c38723cULL, 0x000fe20000001838ULL,
0x01a6c837343479a7ULL, 0x0002a2000850003fULL, 0x01a688377cff79a7ULL, 0x0003de000850003fULL,
0x0000000000007918ULL, 0x000fce0000000000ULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x00000035060075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c377210ULL, 0x002fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000372e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035060075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x00000010782e7824ULL, 0x000fe200078e00ffULL,
0x0000850000087ab9ULL, 0x000fe40000000800ULL, 0x000000087a7a7c24ULL, 0x010fe4000f8e02ffULL,
0xffffffe02e2d7812ULL, 0x000fe400078ec0ffULL, 0x000000807a827824ULL, 0x000fc600078e00ffULL,
0x00000100582d7824ULL, 0x000fc800078e022dULL, 0x000000802d2d7836ULL, 0x000fca0000000000ULL,
0x000000602d2c7812ULL, 0x000fca00078ec0ffULL, 0x00000001594d7824ULL, 0x000fe200078e022cULL,
0x0000000400009947ULL, 0x000fec0003800000ULL, 0x0000002d742c7248ULL, 0x000fe40007fe0000ULL,
0x000000102e2f7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff347819ULL, 0x000fe2000001160aULL,
0x000000012c2e7824ULL, 0x000fe400078e0a2dULL, 0x00008e00ff2c7b82ULL, 0x000ea40000000a00ULL,
0x0000000134367824ULL, 0x000fe200078e022fULL, 0x0000002e2f2e7248ULL, 0x000fe20007fe0000ULL,
0x0000000834377836ULL, 0x002fc40000000000ULL, 0x0000000136357824ULL, 0x040fe400078e020aULL,
0x00000008364c7824ULL, 0x000fe400078e00ffULL, 0x000000012e2e7824ULL, 0x000fe400078e0a2fULL,
0x0000000c344e7836ULL, 0x000fe20000000000ULL, 0xfffffff84c5f7812ULL, 0x000fe200078ee235ULL,
0x0000000434357836ULL, 0x000fe20000000000ULL, 0x0000002e3400720cULL, 0x080fe20003f86070ULL,
0x0000000136367824ULL, 0x000fe200078e024dULL, 0x0000002e3700720cULL, 0x080fe20003f46070ULL,
0x0000000135347824ULL, 0x140fe200078e022fULL, 0x0000002e3500720cULL, 0x080fe20003f66070ULL,
0x00000001374c7824ULL, 0x100fe200078e022fULL, 0x0000002e4e00720cULL, 0x040fe20003f06070ULL,
0x000000014e5c7824ULL, 0x000fc400078e022fULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000002c824f7211ULL, 0x004fc600078a38ffULL, 0x00000001342f7824ULL, 0x100fe200078e020aULL,
0x0000006e362c7212ULL, 0x000fe200078efcffULL, 0x00000008345e7824ULL, 0x000fe200078e00ffULL,
0x0000002d825d7211ULL, 0x000fe200028f3cffULL, 0x0000000134347824ULL, 0x000fe200078e024dULL,
0x0000002c4f2c7210ULL, 0x000fe20007fbe0ffULL, 0x000000014c2e7824ULL, 0x040fe200078e020aULL,
0xfffffff85e657812ULL, 0x000fe200078ee22fULL, 0x000000084c677824ULL, 0x000fe400078e00ffULL,
0x0000008034347825ULL, 0x000fc600078e00ffULL, 0xfffffff867677812ULL, 0x000fe200078ee22eULL,
0x000000014c4c7824ULL, 0x100fe200078e024dULL, 0x0000006e34347212ULL, 0x000fe200078efcffULL,
0x000000015c2e7824ULL, 0x000fe400078e024dULL, 0x000000804c4c7825ULL, 0x000fc800078e00ffULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000006e4c367212ULL, 0x000fc600078efcffULL,
0x00000001372d7824ULL, 0x100fe200028e065dULL, 0x0000004f34347210ULL, 0x000fe20007fbe0ffULL,
0x000000015c377824ULL, 0x000fe200078e020aULL, 0x0000006e2e2e7212ULL, 0x000fe200078efcffULL,
0x000000085c5c7824ULL, 0x000fe400078e00ffULL, 0x0000000135357824ULL, 0x100fe200028e065dULL,
0x0000004f36367210ULL, 0x000fe40007fbe0ffULL, 0x0000004f2e2e7210ULL, 0x000fe20007fde0ffULL,
0x000000105f4f7824ULL, 0x000fe200078e0284ULL, 0xfffffff85c697812ULL, 0x000fe200078ee237ULL,
0x000000014d377824ULL, 0x000fc400028e065dULL, 0x000000012f2f7824ULL, 0x000fe200030e065dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c4f7faeULL, 0x0003e2000e101c46ULL,
0x00000010654d7824ULL, 0x100fe400078e0284ULL, 0x00000010675d7824ULL, 0x100fe400078e0284ULL,
0x00000010695f7824ULL, 0x000fe200078e0284ULL, 0x00000000344d7faeULL, 0x0003e8000d901c46ULL,
0x00000000365d7faeULL, 0x0003e8000d101c46ULL, 0x000000002e5f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000cc7947ULL, 0x000fea0003800000ULL, 0x000000102e2d7812ULL, 0x000fe400078ec0ffULL,
0x00008e00ff2e7b82ULL, 0x000ea40000000a00ULL, 0x0000002d0a2d7211ULL, 0x000fca00078fe8ffULL,
0x000000012d2c7824ULL, 0x040fe400078e020aULL, 0x000000082d4f7824ULL, 0x040fe400078e00ffULL,
0x000000042d347836ULL, 0x000fe40000000000ULL, 0x000000082d357836ULL, 0x000fe20000000000ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee22cULL, 0x0000000c2d377836ULL, 0x002fe40000000000ULL,
0x000000012d367824ULL, 0x000fc400078e024dULL, 0x00000001344c7824ULL, 0x140fe400078e024dULL,
0x00000001342d7824ULL, 0x140fe400078e020aULL, 0x00000008344e7824ULL, 0x000fe200078e00ffULL,
0x0000002e825d7211ULL, 0x044fe200078038ffULL, 0x0000000135347824ULL, 0x100fe400078e024dULL,
0x00000001372c7824ULL, 0x000fe200078e024dULL, 0xfffffff84e657812ULL, 0x000fe200078ee22dULL,
0x00000001354d7824ULL, 0x040fe200078e020aULL, 0x0000002f825f7211ULL, 0x000fe200000f3cffULL,
0x00000008355c7824ULL, 0x000fc400078e00ffULL, 0x0000000137357824ULL, 0x040fe400078e020aULL,
0x00000008375e7824ULL, 0x000fe200078e00ffULL, 0xfffffff85c677812ULL, 0x000fe200078ee24dULL,
0x0000008036367825ULL, 0x000fc600078e00ffULL, 0xfffffff85e697812ULL, 0x000fe200078ee235ULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x0000006e362e7212ULL, 0x000fc600078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000006e4c367212ULL, 0x080fe400078efcffULL,
0x0000002e5d2e7210ULL, 0x000fe20007f1e0ffULL, 0x000000802c2c7825ULL, 0x000fe200078e00ffULL,
0x0000006e34347212ULL, 0x080fe400078efcffULL, 0x000000365d367210ULL, 0x000fe20007f5e0ffULL,
0x00000001372f7824ULL, 0x100fe200000e065fULL, 0x0000006e2c2c7212ULL, 0x000fe400078efcffULL,
0x000000345d347210ULL, 0x000fe20007f1e0ffULL, 0x000000014d377824ULL, 0x000fe200010e065fULL,
0x0000002c5d2c7210ULL, 0x000fe20007f7e0ffULL, 0x000000104f4d7824ULL, 0x000fc400078e0284ULL,
0x00000010654f7824ULL, 0x100fe400078e0284ULL, 0x0000000135357824ULL, 0x100fe200000e065fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002e4d7faeULL, 0x0003e2000b901c46ULL,
0x000000012d2d7824ULL, 0x000fe400018e065fULL, 0x00000010675d7824ULL, 0x100fe200078e0284ULL,
0x00000000364f7faeULL, 0x0003e2000b901c46ULL, 0x00000010695f7824ULL, 0x000fc600078e0284ULL,
0x00000000345d7faeULL, 0x0003e8000b901c46ULL, 0x000000002c5f7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff2d7424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a45ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000002dff8879a7ULL, 0x0002a40008500005ULL, 0x01a6282d802c79a7ULL, 0x0022e4000850003fULL,
0x00000000002e7805ULL, 0x000fce0000015200ULL, 0x01a6282d800075a7ULL, 0x008ee4000800017fULL,
0x00000000005c0947ULL, 0x008fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x000000342e377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e2fULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6282d800075a7ULL, 0x000ee4000800017fULL, 0xfffffffc00a88947ULL, 0x008fea000383ffffULL,
0x00000020782c7824ULL, 0x000fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fc600078e00ffULL,
0xffffff802c2c7812ULL, 0x000fc800078ec0ffULL, 0x00000080092c7810ULL, 0x000fc80007ffe02cULL,
0x0000002c6f2c7210ULL, 0x000fca0007ffe06eULL, 0x01a000002c2e7984ULL, 0x000ee80000000800ULL,
0x01a200002c2d7984ULL, 0x0009220000000800ULL, 0x000000852e00720bULL, 0x008fda0003f1d000ULL,
0x0000000000357806ULL, 0x000fc800000e0100ULL, 0x000000ff3500720cULL, 0x000fda0003f05270ULL,
0x00000004009c8947ULL, 0x016fea0003800000ULL, 0x000000015a2f7836ULL, 0x000fe20000000000ULL,
0x000000852e00720bULL, 0x000fc80003f14000ULL, 0x000000782f00720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x00000080782fa824ULL, 0x000fe200078e0209ULL,
0x000000852e2ca209ULL, 0x000fe40007810000ULL, 0x000000ff3400720cULL, 0x000fe40003f05270ULL,
0x0000002f6f2fa210ULL, 0x000fca0007ffe06eULL, 0x01a4002c2f00a388ULL, 0x0003ec0000000800ULL,
0x0000000400548947ULL, 0x000fea0003800000ULL, 0x000000852e2c7209ULL, 0x002fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x000000852c2c7221ULL, 0x000fe20000010100ULL, 0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000034ff7812ULL, 0x000fe2000788c0ffULL, 0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL,
0x0000002c00367308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff2f7819ULL, 0x000fca000001160aULL, 0x00001f2f362c7589ULL, 0x006e6400000e0000ULL,
0x000000542c547220ULL, 0x042fe20000410000ULL, 0x000000552c557220ULL, 0x040fe20000410000ULL,
0x0000003c2c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d2c3d7220ULL, 0x040fe20000410000ULL,
0x000000402c407220ULL, 0x040fe20000410000ULL, 0x000000412c417220ULL, 0x040fe20000410000ULL,
0x000000442c447220ULL, 0x040fe20000410000ULL, 0x000000452c457220ULL, 0x040fe20000410000ULL,
0x000000482c487220ULL, 0x040fe20000410000ULL, 0x000000492c497220ULL, 0x040fe20000410000ULL,
0x000000502c507220ULL, 0x040fe20000410000ULL, 0x000000512c517220ULL, 0x040fe20000410000ULL,
0x000000282c287220ULL, 0x040fe20000410000ULL, 0x000000292c297220ULL, 0x040fe20000410000ULL,
0x000000242c247220ULL, 0x040fe20000410000ULL, 0x000000252c257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a2f7811ULL, 0x000fca00078ff0ffULL,
0x00001f2f362c7589ULL, 0x006e6400000e0000ULL, 0x000000562c567220ULL, 0x042fe20000410000ULL,
0x000000572c577220ULL, 0x040fe20000410000ULL, 0x0000003e2c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f2c3f7220ULL, 0x040fe20000410000ULL, 0x000000422c427220ULL, 0x040fe20000410000ULL,
0x000000432c437220ULL, 0x040fe20000410000ULL, 0x000000462c467220ULL, 0x040fe20000410000ULL,
0x000000472c477220ULL, 0x040fe20000410000ULL, 0x0000004a2c4a7220ULL, 0x040fe20000410000ULL,
0x0000004b2c4b7220ULL, 0x040fe20000410000ULL, 0x000000522c527220ULL, 0x040fe20000410000ULL,
0x000000532c537220ULL, 0x040fe20000410000ULL, 0x0000002a2c2a7220ULL, 0x040fe20000410000ULL,
0x0000002b2c2b7220ULL, 0x040fe20000410000ULL, 0x000000262c267220ULL, 0x040fe20000410000ULL,
0x000000272c277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a2f7811ULL, 0x000fca00078ff0ffULL, 0x00001f2f362c7589ULL, 0x006e6400000e0000ULL,
0x0000000c2c0c7220ULL, 0x042fe20000410000ULL, 0x0000000d2c0d7220ULL, 0x040fe20000410000ULL,
0x000000102c107220ULL, 0x040fe20000410000ULL, 0x000000112c117220ULL, 0x040fe20000410000ULL,
0x000000142c147220ULL, 0x040fe20000410000ULL, 0x000000152c157220ULL, 0x040fe20000410000ULL,
0x000000182c187220ULL, 0x040fe20000410000ULL, 0x000000192c197220ULL, 0x040fe20000410000ULL,
0x0000001c2c1c7220ULL, 0x040fe20000410000ULL, 0x0000001d2c1d7220ULL, 0x040fe20000410000ULL,
0x000000202c207220ULL, 0x040fe20000410000ULL, 0x000000212c217220ULL, 0x040fe20000410000ULL,
0x000000302c307220ULL, 0x040fe20000410000ULL, 0x000000312c317220ULL, 0x040fe20000410000ULL,
0x000000382c387220ULL, 0x040fe20000410000ULL, 0x000000392c397220ULL, 0x000fce0000410000ULL,
0x0000003683837220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a2f7811ULL, 0x000fca00078ff0ffULL, 0x00001f2f362c7589ULL, 0x002e6400000e0000ULL,
0x0000000e2c0e7220ULL, 0x042fe20000410000ULL, 0x0000000f2c0f7220ULL, 0x040fe20000410000ULL,
0x000000122c127220ULL, 0x040fe20000410000ULL, 0x000000132c137220ULL, 0x040fe20000410000ULL,
0x000000162c167220ULL, 0x040fe20000410000ULL, 0x000000172c177220ULL, 0x040fe20000410000ULL,
0x0000001a2c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b2c1b7220ULL, 0x040fe20000410000ULL,
0x0000001e2c1e7220ULL, 0x040fe20000410000ULL, 0x0000001f2c1f7220ULL, 0x040fe20000410000ULL,
0x000000222c227220ULL, 0x040fe20000410000ULL, 0x000000232c237220ULL, 0x040fe20000410000ULL,
0x000000322c327220ULL, 0x040fe20000410000ULL, 0x000000332c337220ULL, 0x040fe20000410000ULL,
0x0000003a2c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b2c3b7220ULL, 0x000fce0000410000ULL,
0x0000003435ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x000000852e857209ULL, 0x000fd60007810000ULL, 0x800000852e2e0221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL,
0x0000002e00040308ULL, 0x000ea40000000800ULL, 0x000000042d2d0220ULL, 0x004fce0000410000ULL,
0x000000832d837221ULL, 0x000fe20000010000ULL, 0x00000000002c7805ULL, 0x002fe20000015200ULL,
0x00000008782e7824ULL, 0x000fca00078e00ffULL, 0xfffffff02e2e7812ULL, 0x000fca00078ec0ffULL,
0x0000000109377824ULL, 0x000fc800078e022eULL, 0x01a6b087370075a7ULL, 0x000ea4000800017fULL,
0x00000000005c0947ULL, 0x006fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x00000000002e7805ULL, 0x000fcc0000015200ULL, 0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL,
0x000000012f2f7824ULL, 0x000fe200000e0e2dULL, 0x003d09003500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff2e7819ULL, 0x000fc8000001142fULL,
0x000000352e2e7211ULL, 0x000fca00078110ffULL, 0x000000ffff2f7224ULL, 0x000fca00000e062fULL,
0x000000022e2e7819ULL, 0x000fc8000000122fULL, 0x0000002e0000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6b087370075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00009910342c7816ULL, 0x000fe200000000ffULL, 0x00000400782d7824ULL, 0x040fe400078e00ffULL,
0x00001000782e7824ULL, 0x000fe200078e00ffULL, 0x000000ff2c00720cULL, 0x000fe40003f05270ULL,
0xfffff0002d7c7812ULL, 0x000fe400078ec0ffULL, 0xffffe0002e2e7812ULL, 0x000fe400078ec0ffULL,
0x00013000097c7810ULL, 0x000fc40007ffe07cULL, 0x00017000094c7810ULL, 0x000fc60007ffe02eULL,
0x000000107f347824ULL, 0x100fe400078e027cULL, 0x000000107e2c7824ULL, 0x000fe400078e027cULL,
0x000000106d5c7824ULL, 0x000fe200078e024cULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff2e7819ULL, 0x000fe4000001160aULL, 0x00000004ff00723eULL, 0x000fc600000000ffULL,
0x000000082e027836ULL, 0x000fe20000000000ULL, 0x00005410002d7816ULL, 0x000fe20000000000ULL,
0x000000102e367836ULL, 0x000fe40000000000ULL, 0x000000182e4e7836ULL, 0x000fe40000000000ULL,
0x00001f022d027589ULL, 0x0002a800000e0000ULL, 0x00001f362d057589ULL, 0x0002e800000e0000ULL,
0x00001f2e2d037589ULL, 0x00026800000e0000ULL, 0x00001f4e2d007589ULL, 0x00026400000e0000ULL,
0x000000003434783bULL, 0x002e680000000200ULL, 0x000000002c2c783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x084fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x088fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000005c5c783bULL, 0x000f220000004200ULL,
0x000000107b4c7824ULL, 0x000fcc00078e024cULL, 0x000000004c4c783bULL, 0x000f620000004200ULL,
0x000001005c647824ULL, 0x010fe200078e00ffULL, 0x00000018ff907819ULL, 0x000fe2000001145dULL,
0x000001005d657824ULL, 0x040fe200078e00ffULL, 0x000088805d947816ULL, 0x040fe200000000ffULL,
0x000100005d5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff647819ULL, 0x000fe40000011464ULL,
0x00000018ff657819ULL, 0x000fe20000011465ULL, 0x000001004d687824ULL, 0x028fe200078e00ffULL,
0x0000006400967306ULL, 0x0007e20000200c00ULL, 0x00000018ff957819ULL, 0x000fe2000001145dULL,
0x000001005e5d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe2000001144cULL,
0x000001004e697824ULL, 0x000fe200078e00ffULL, 0x000088805c877816ULL, 0x000fc400000000ffULL,
0x00000018ff917819ULL, 0x000fe2000001145dULL, 0x0000006500977306ULL, 0x0009e20000200c00ULL,
0x000001005f647824ULL, 0x048fe200078e00ffULL, 0x000088805f5d7816ULL, 0x000fe400000000ffULL,
0x00000018ff677819ULL, 0x000fe4000001144dULL, 0x00000018ff8a7819ULL, 0x000fe40000011464ULL,
0x0000009400947306ULL, 0x000fe20000200c00ULL, 0x000001004c657824ULL, 0x050fe200078e00ffULL,
0x000088804c647816ULL, 0x040fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fe2000001145cULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fc40000011465ULL, 0x000088804d657816ULL, 0x040fe200000000ffULL,
0x000100004d4d7824ULL, 0x000fe200078e00ffULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff937819ULL, 0x000fe4000001145cULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x00000018ff8f7819ULL, 0x000fe2000001145eULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff8e7819ULL, 0x000fe2000001145fULL,
0x000100005f5f7824ULL, 0x000fe200078e00ffULL, 0x000088805e5c7816ULL, 0x040fe200000000ffULL,
0x000100005e5e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fc40000011468ULL,
0x00000018ff6a7819ULL, 0x000fe2000001144eULL, 0x0000008a008a7306ULL, 0x000ee20000200c00ULL,
0x000088804e687816ULL, 0x040fe200000000ffULL, 0x000100004e4e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe40000011469ULL, 0x00000018ff6b7819ULL, 0x000fe4000001144fULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x0000004c008b7306ULL, 0x0009e20000200c00ULL,
0x00000018ff5f7819ULL, 0x000fc4000001145fULL, 0x000088804f697816ULL, 0x000fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x000054105d5d7816ULL, 0x008fe2000000008aULL,
0x0000004d00867306ULL, 0x0007e20000200c00ULL, 0x000001004f4c7824ULL, 0x010fca00078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000009200927306ULL, 0x000fe20000200c00ULL,
0x00005410944d7816ULL, 0x008fe20000000097ULL, 0x000100004f947824ULL, 0x000fca00078e00ffULL,
0x00000018ff947819ULL, 0x000fe20000011494ULL, 0x0000004c007a7306ULL, 0x0007f00000200c00ULL,
0x0000009000907306ULL, 0x000fe20000200c00ULL, 0x00005410874c7816ULL, 0x008fce0000000096ULL,
0x0000008f008f7306ULL, 0x000fe20000200c00ULL, 0x0000004c3454723cULL, 0x002fec0000001854ULL,
0x0000004c2c0c723cULL, 0x000fe2000000180cULL, 0x0000008e008e7306ULL, 0x000fec0000200c00ULL,
0x00000010714c7824ULL, 0x000fc400078e027cULL, 0x0000006600667306ULL, 0x000e700000200c00ULL,
0x0000006700677306ULL, 0x000ee20000200c00ULL, 0x000054108b667816ULL, 0x002fce0000000066ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x0000541086677816ULL, 0x008fce0000000067ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000000663450723cULL, 0x000fee0000001850ULL,
0x0000009300937306ULL, 0x000fe20000200c00ULL, 0x000000662c20723cULL, 0x000fee0000001820ULL,
0x0000009500957306ULL, 0x000e700000200c00ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x00005410954f7816ULL, 0x002fce0000000090ULL, 0x0000009100917306ULL, 0x000e700000200c00ULL,
0x0000005e005e7306ULL, 0x000ee20000200c00ULL, 0x000054105c5c7816ULL, 0x002fce0000000091ULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x000054105e5e7816ULL, 0x008fcc000000008fULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x000054105f5f7816ULL, 0x002fcc000000008eULL,
0x0000008d008d7306ULL, 0x000e620000200c00ULL, 0x0000005e3444723cULL, 0x000fee0000001844ULL,
0x0000006500657306ULL, 0x000fe20000200c00ULL, 0x0000005e2c18723cULL, 0x000fe20000001818ULL,
0x0000541064647816ULL, 0x002fcc000000008dULL, 0x0000008c008c7306ULL, 0x000e700000200c00ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x0000541065657816ULL, 0x002fce000000008cULL,
0x0000008100817306ULL, 0x000e620000200c00ULL, 0x000000643448723cULL, 0x000fee0000001848ULL,
0x0000006900697306ULL, 0x000ee20000200c00ULL, 0x000000642c1c723cULL, 0x000fe2000000181cULL,
0x0000541068687816ULL, 0x002fcc0000000081ULL, 0x0000004e00877306ULL, 0x0003220000200c00ULL,
0x0000541069697816ULL, 0x008fce000000007aULL, 0x00000094008a7306ULL, 0x000ee20000200c00ULL,
0x00005410934e7816ULL, 0x002fe20000000092ULL, 0x00017000727a7836ULL, 0x000fe20000000000ULL,
0x000000683428723cULL, 0x000fe20000001828ULL, 0x00005410876a7816ULL, 0x010fca000000006aULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x000054108a6b7816ULL, 0x008fca000000006bULL,
0x0000004e2c10723cULL, 0x000fec0000001810ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x000000682c30723cULL, 0x000fe20000001830ULL, 0x0000001070347824ULL, 0x000fc400078e027cULL,
0x000000107d7c7824ULL, 0x000fc600078e027aULL, 0x0000006a2c38723cULL, 0x000fe20000001838ULL,
0x000000003434783bULL, 0x000e680000000200ULL, 0x000000004c2c783bULL, 0x0006a20000000200ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x084fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x080fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x000000007c5c783bULL, 0x000f220000004200ULL, 0x00000010734c7824ULL, 0x008fcc00078e027aULL,
0x000000004c4c783bULL, 0x000ee20000004200ULL, 0x000001005c647824ULL, 0x010fe200078e00ffULL,
0x00000018ff8c7819ULL, 0x000fe2000001145dULL, 0x000001005d657824ULL, 0x040fe200078e00ffULL,
0x000088805d957816ULL, 0x040fe200000000ffULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x000001004c697824ULL, 0x008fe200078e00ffULL, 0x0000006400967306ULL, 0x0007e20000200c00ULL,
0x00000018ff937819ULL, 0x000fe2000001145cULL, 0x000001004d817824ULL, 0x000fe200078e00ffULL,
0x000088805c877816ULL, 0x040fe200000000ffULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff977819ULL, 0x000fe2000001145dULL, 0x000001005e5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fe2000001145eULL, 0x0000006500987306ULL, 0x0009e20000200c00ULL,
0x000001005f647824ULL, 0x008fe200078e00ffULL, 0x00000018ff947819ULL, 0x000fc4000001145cULL,
0x000088805e5c7816ULL, 0x040fe400000000ffULL, 0x00000018ff687819ULL, 0x000fe20000011464ULL,
0x000100005e647824ULL, 0x000fe200078e00ffULL, 0x0000009500957306ULL, 0x000ee20000200c00ULL,
0x00000018ff677819ULL, 0x000fe4000001144dULL, 0x00000018ff667819ULL, 0x000fe4000001144cULL,
0x00000018ff657819ULL, 0x010fe20000011464ULL, 0x000100005f647824ULL, 0x000fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x00000068005e7306ULL, 0x0009e20000200c00ULL,
0x00000018ff6a7819ULL, 0x000fc4000001144eULL, 0x00000018ff927819ULL, 0x000fe40000011464ULL,
0x000088804c647816ULL, 0x040fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x000088804e997816ULL, 0x000fe200000000ffULL, 0x0000008c008c7306ULL, 0x000fe20000200c00ULL,
0x000088804d687816ULL, 0x050fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff917819ULL, 0x000fc4000001145dULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000009700977306ULL, 0x000f220000200c00ULL,
0x00000018ff6b7819ULL, 0x000fe4000001144fULL, 0x000088805f5d7816ULL, 0x000fe400000000ffULL,
0x00000018ff8f7819ULL, 0x000fe4000001145fULL, 0x00000018ff817819ULL, 0x000fe20000011481ULL,
0x0000008700877306ULL, 0x000ff00000200c00ULL, 0x00000069008d7306ULL, 0x000bf00000200c00ULL,
0x0000004d008a7306ULL, 0x0007e20000200c00ULL, 0x000001004e697824ULL, 0x024fc400078e00ffULL,
0x000100004e4e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff9a7819ULL, 0x000fe40000011469ULL,
0x0000004c008b7306ULL, 0x0005e20000200c00ULL, 0x00005410954d7816ULL, 0x008fe20000000098ULL,
0x000100004f957824ULL, 0x040fe200078e00ffULL, 0x000088804f697816ULL, 0x000fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fc6000001144eULL, 0x0000005d005d7306ULL, 0x000ee20000200c00ULL,
0x000001004f4c7824ULL, 0x004fe200078e00ffULL, 0x00005410974f7816ULL, 0x010fe4000000008cULL,
0x00000018ff8c7819ULL, 0x000fe40000011495ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x00000065005f7306ULL, 0x000fe20000200c00ULL, 0x000054105d5d7816ULL, 0x008fce000000005eULL,
0x0000004c00867306ULL, 0x0005f00000200c00ULL, 0x0000009000907306ULL, 0x000ee20000200c00ULL,
0x00005410874c7816ULL, 0x004fce0000000096ULL, 0x0000006800657306ULL, 0x000fe20000200c00ULL,
0x0000004c3454723cULL, 0x002fe20000001854ULL, 0x000054105f5e7816ULL, 0x008fcc0000000090ULL,
0x00000081008e7306ULL, 0x000e620000200c00ULL, 0x0000004c2c0c723cULL, 0x000fee000000180cULL,
0x0000009300937306ULL, 0x000fe20000200c00ULL, 0x0000541065657816ULL, 0x002fce000000008eULL,
0x0000008f008f7306ULL, 0x000ff00000200c00ULL, 0x0000006600667306ULL, 0x000e700000200c00ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x000054108b667816ULL, 0x002fce0000000066ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000054108a677816ULL, 0x004fce0000000067ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000000663450723cULL, 0x000fee0000001850ULL,
0x0000009400947306ULL, 0x000fe20000200c00ULL, 0x000000662c20723cULL, 0x000fee0000001820ULL,
0x0000005c005c7306ULL, 0x000ff00000200c00ULL, 0x0000009100917306ULL, 0x000e700000200c00ULL,
0x0000009200927306ULL, 0x000ea20000200c00ULL, 0x000054105c5c7816ULL, 0x002fce0000000091ULL,
0x0000006400647306ULL, 0x000e620000200c00ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x00005410925f7816ULL, 0x004fcc000000008fULL, 0x0000009900687306ULL, 0x000fe20000200c00ULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x0000541064647816ULL, 0x002fcc000000008dULL,
0x0000009a00817306ULL, 0x000e620000200c00ULL, 0x0000005e3444723cULL, 0x000fee0000001844ULL,
0x0000006900697306ULL, 0x000ea20000200c00ULL, 0x000000643448723cULL, 0x000fe20000001848ULL,
0x0000541068687816ULL, 0x002fcc0000000081ULL, 0x0000004e00877306ULL, 0x0002e20000200c00ULL,
0x0000005e2c18723cULL, 0x000fe20000001818ULL, 0x0000541069697816ULL, 0x004fcc0000000086ULL,
0x0000008c008c7306ULL, 0x000ea20000200c00ULL, 0x00005410944e7816ULL, 0x002fe20000000093ULL,
0x000000642c1c723cULL, 0x000fe2000000181cULL, 0x00005410876a7816ULL, 0x008fca000000006aULL,
0x0000004e343c723cULL, 0x000fec000000183cULL, 0x000000683428723cULL, 0x000fe20000001828ULL,
0x000054108c6b7816ULL, 0x004fca000000006bULL, 0x0000004e2c10723cULL, 0x000fec0000001810ULL,
0x0000006a3424723cULL, 0x000fec0000001824ULL, 0x000000682c30723cULL, 0x000fe20000001830ULL,
0x0000000278347824ULL, 0x000fc400078e00ffULL, 0x00000001ff377424ULL, 0x000fc600078e00ffULL,
0xfffffff834367812ULL, 0x000fe200078ec0ffULL, 0x0000000862347824ULL, 0x000fe200078e0209ULL,
0x0000006a2c38723cULL, 0x000fe60000001838ULL, 0x0000000109367824ULL, 0x000fe400078e0236ULL,
0x01a6c837343479a7ULL, 0x0002a4000850003fULL, 0x01a6903736ff79a7ULL, 0x0003de000850003fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x00000035060075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x002fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fcc0000015200ULL,
0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000372e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000010058817824ULL, 0x000fc800078e025bULL,
0x000000c0812d7836ULL, 0x000fca0000000000ULL, 0x000000602d2c7812ULL, 0x000fca00078ec0ffULL,
0x0000000159357824ULL, 0x000fe200078e022cULL, 0x0000000400049947ULL, 0x000fec0003800000ULL,
0x0000002d742c7248ULL, 0x000fe20007fe0000ULL, 0x00000010782e7824ULL, 0x000fe200078e00ffULL,
0x00000003ff347819ULL, 0x000fc6000001160aULL, 0x000000012c2c7824ULL, 0x000fe200078e0a2dULL,
0x000000102e2d7812ULL, 0x000fe200078ec0ffULL, 0x0000000434367836ULL, 0x002fe20000000000ULL,
0x00008e00ff2e7b82ULL, 0x000e620000000a00ULL, 0x0000000834377836ULL, 0x000fe20000000000ULL,
0x0000002c2d2c7248ULL, 0x000fe20007fe0000ULL, 0x0000000c344d7836ULL, 0x000fe40000000000ULL,
0x00000001364c7824ULL, 0x100fe400078e022dULL, 0x000000012c2c7824ULL, 0x000fc400078e0a2dULL,
0x000000014d5c7824ULL, 0x100fe400078e022dULL, 0x00000001374e7824ULL, 0x140fe200078e022dULL,
0x0000002c3400720cULL, 0x0c0fe20003f86070ULL, 0x0000000134347824ULL, 0x000fe200078e022dULL,
0x0000002c3600720cULL, 0x080fe20003f66070ULL, 0x000000014c2d7824ULL, 0x100fe200078e020aULL,
0x0000002c3700720cULL, 0x080fe20003f46070ULL, 0x0000000134367824ULL, 0x040fe200078e0235ULL,
0x0000002c4d00720cULL, 0x000fe20003f06070ULL, 0x00000001342c7824ULL, 0x000fc400078e020aULL,
0x00000008344d7824ULL, 0x000fe400078e00ffULL, 0x000000084c5e7824ULL, 0x000fe200078e00ffULL,
0x0000002e824f7211ULL, 0x002fe200078a38ffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0xfffffff84d4d7812ULL, 0x000fe400078ee22cULL, 0xfffffff85e5f7812ULL, 0x000fe200078ee22dULL,
0x000000014e347824ULL, 0x000fe200078e020aULL, 0x0000006e36367212ULL, 0x000fe200078efcffULL,
0x000000084e657824ULL, 0x000fe200078e00ffULL, 0x0000002f825d7211ULL, 0x000fe200028f3cffULL,
0x000000014c2c7824ULL, 0x100fe200078e0235ULL, 0x0000004f36367210ULL, 0x000fe20007fbe0ffULL,
0x000000014e2e7824ULL, 0x000fe200078e0235ULL, 0xfffffff865657812ULL, 0x000fe200078ee234ULL,
0x000000802c2c7825ULL, 0x000fc800078e00ffULL, 0x000000015c347824ULL, 0x000fe200078e0235ULL,
0x0000006e2c2c7212ULL, 0x000fe200078efcffULL, 0x000000802e2e7825ULL, 0x000fc800078e00ffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000006e2e2e7212ULL, 0x000fc600078efcffULL,
0x0000000137377824ULL, 0x100fe200028e065dULL, 0x0000004f2c2c7210ULL, 0x000fe20007fbe0ffULL,
0x000000015c4c7824ULL, 0x000fe200078e020aULL, 0x0000006e34347212ULL, 0x000fe200078efcffULL,
0x000000085c677824ULL, 0x000fe400078e00ffULL, 0x000000012d2d7824ULL, 0x100fe200028e065dULL,
0x0000004f2e2e7210ULL, 0x000fe20007fbe0ffULL, 0x000000104d4d7824ULL, 0x100fe200078e027aULL,
0x0000004f34347210ULL, 0x000fe20007fde0ffULL, 0x000000105f5f7824ULL, 0x100fe200078e027aULL,
0xfffffff8674f7812ULL, 0x000fe200078ee24cULL, 0x000000012f2f7824ULL, 0x000fe200028e065dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000364d7faeULL, 0x0003e2000e101c46ULL,
0x0000001065657824ULL, 0x000fc400078e027aULL, 0x0000000135357824ULL, 0x000fe200030e065dULL,
0x000000002c5f7faeULL, 0x0003e2000d901c46ULL, 0x000000104f4f7824ULL, 0x000fc600078e027aULL,
0x000000002e657faeULL, 0x0003e8000d101c46ULL, 0x00000000344f7faeULL, 0x0003e2000c101c46ULL,
0x0000000000d07947ULL, 0x000fea0003800000ULL, 0x00000010782c7824ULL, 0x000fca00078e00ffULL,
0x000000102c2d7812ULL, 0x000fc800078ec0ffULL, 0x0000002d0a2e7211ULL, 0x000fe400078fe8ffULL,
0x00008e00ff2c7b82ULL, 0x000ea60000000a00ULL, 0x000000012e2f7824ULL, 0x040fe400078e020aULL,
0x000000082e367824ULL, 0x002fe400078e00ffULL, 0x000000042e347836ULL, 0x000fe40000000000ULL,
0x000000082e377836ULL, 0x000fe20000000000ULL, 0xfffffff8364f7812ULL, 0x000fe200078ee22fULL,
0x0000000c2e4d7836ULL, 0x000fc40000000000ULL, 0x000000012e4c7824ULL, 0x100fe400078e0235ULL,
0x00000001342e7824ULL, 0x140fe400078e0235ULL, 0x00000001342f7824ULL, 0x140fe400078e020aULL,
0x00000008344e7824ULL, 0x000fe400078e00ffULL, 0x0000000137347824ULL, 0x100fe400078e0235ULL,
0x000000014d367824ULL, 0x000fe200078e0235ULL, 0xfffffff84e657812ULL, 0x000fe200078ee22fULL,
0x0000000137357824ULL, 0x040fe200078e020aULL, 0x0000002c825d7211ULL, 0x004fe200078038ffULL,
0x00000008375c7824ULL, 0x000fc400078e00ffULL, 0x000000014d377824ULL, 0x040fe200078e020aULL,
0x0000002d825f7211ULL, 0x000fe200000f3cffULL, 0x000000084d5e7824ULL, 0x000fe200078e00ffULL,
0xfffffff85c677812ULL, 0x000fe200078ee235ULL, 0x000000804c4c7825ULL, 0x000fc600078e00ffULL,
0xfffffff85e697812ULL, 0x000fe200078ee237ULL, 0x000000802e2e7825ULL, 0x000fe200078e00ffULL,
0x0000006e4c2c7212ULL, 0x000fc600078efcffULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000005d2c2c7210ULL, 0x000fe40007f1e0ffULL, 0x0000006e2e2e7212ULL, 0x080fe200078efcffULL,
0x0000008036367825ULL, 0x000fe200078e00ffULL, 0x0000006e34347212ULL, 0x080fe400078efcffULL,
0x0000005d2e2e7210ULL, 0x000fe20007f5e0ffULL, 0x000000014d2d7824ULL, 0x100fe200000e065fULL,
0x0000006e36367212ULL, 0x000fe200078efcffULL, 0x000000104f4f7824ULL, 0x100fe200078e027aULL,
0x0000005d34347210ULL, 0x000fe20007f1e0ffULL, 0x000000012f2f7824ULL, 0x100fe200010e065fULL,
0x0000005d36367210ULL, 0x000fe20007f7e0ffULL, 0x0000001065657824ULL, 0x000fe200078e027aULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c4f7faeULL, 0x0003e2000b901c46ULL,
0x0000000135357824ULL, 0x000fc400000e065fULL, 0x0000001067677824ULL, 0x100fe200078e027aULL,
0x000000002e657faeULL, 0x0003e2000b901c46ULL, 0x0000000137377824ULL, 0x000fe400018e065fULL,
0x0000001069697824ULL, 0x000fe200078e027aULL, 0x0000000034677faeULL, 0x0003e8000b901c46ULL,
0x0000000036697faeULL, 0x0003e4000b901c46ULL, 0x0000000260607836ULL, 0x000fe20000000000ULL,
0x0000000804087890ULL, 0x000fe2000fffe03fULL, 0xffffffffff827424ULL, 0x000fe200078e00ffULL,
0x0000000000007918ULL, 0x002fe40000000000ULL, 0x000000636000720cULL, 0x000fca0003f06070ULL,
0x00000000ff0079b0ULL, 0x000ff00008000a48ULL, 0x00009000ff2c8b82ULL, 0x000e620000000a00ULL,
0x00000001602f8824ULL, 0x000fe400078e0207ULL, 0x00000008782e7824ULL, 0x000fc400078e00ffULL,
0x000000042f2c8825ULL, 0x002fca00078e002cULL, 0x000000062c828981ULL, 0x000322000c1e1900ULL,
0xfffffff02e2e7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff2f7424ULL, 0x000fc600078e00ffULL,
0x0001a6a82e867810ULL, 0x000fe20007ffe009ULL, 0x0000000000007918ULL, 0x000fcc0000000000ULL,
0x0000082f868679a7ULL, 0x0004e2000850003fULL, 0x01a6482f802c79a7ULL, 0x002464000850003fULL,
0x00000000002e7805ULL, 0x004fce0000015200ULL, 0x01a6482d800075a7ULL, 0x002e64000800017fULL,
0x00000000005c0947ULL, 0x002fea0003800000ULL, 0x000000ffff367224ULL, 0x000fce00078e00ffULL,
0x000000103600780cULL, 0x000fda0003f06270ULL, 0x0000000000448947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fce0000015200ULL, 0x000000342e377210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e2fULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000000000088947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fea0003800000ULL, 0x0000000000287947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x0000001fff347819ULL, 0x000fc80000011435ULL,
0x0000003734347211ULL, 0x000fca00078110ffULL, 0x000000ffff357224ULL, 0x000fca00000e0635ULL,
0x0000000234347819ULL, 0x000fc80000001235ULL, 0x000000340000735dULL, 0x000fea0003800000ULL,
0x0000000000047947ULL, 0x000fea0003800000ULL, 0x0000000136367836ULL, 0x000fce0000000000ULL,
0x01a6482d800075a7ULL, 0x000e64000800017fULL, 0xfffffffc00a88947ULL, 0x002fea000383ffffULL,
0x00000020782c7824ULL, 0x000fe400078e00ffULL, 0x00000001ff347424ULL, 0x000fc600078e00ffULL,
0xffffff802c2c7812ULL, 0x000fc800078ec0ffULL, 0x00000100092c7810ULL, 0x000fc80007ffe02cULL,
0x0000002c6f2c7210ULL, 0x000fca0007ffe06eULL, 0x01a000002c2e7984ULL, 0x000e680000000800ULL,
0x01a200002c2d7984ULL, 0x0004a20000000800ULL, 0x000000852e00720bULL, 0x002fda0003f1d000ULL,
0x0000000000357806ULL, 0x000fc800000e0100ULL, 0x000000ff3500720cULL, 0x000fda0003f05270ULL,
0x00000004009c8947ULL, 0x00cfea0003800000ULL, 0x000000025a2f7836ULL, 0x000fe20000000000ULL,
0x000000852e00720bULL, 0x000fc80003f14000ULL, 0x000000782f00720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x00000080782fa824ULL, 0x000fe200078e0209ULL,
0x000000852e2ca209ULL, 0x000fe40007810000ULL, 0x000000ff3400720cULL, 0x000fe40003f05270ULL,
0x0000002f6f2fa210ULL, 0x000fca0007ffe06eULL, 0x01a4002c2f00a388ULL, 0x0003ec0000000800ULL,
0x0000000400548947ULL, 0x000fea0003800000ULL, 0x000000852e2c7209ULL, 0x002fe40007810000ULL,
0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL, 0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL,
0x000000852c2c7221ULL, 0x000fe20000010100ULL, 0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL,
0xff00000034ff7812ULL, 0x000fe2000788c0ffULL, 0x3fb8aa3b2c2c7820ULL, 0x000fc80000410000ULL,
0x0000002c00367308ULL, 0x0002a40000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff2f7819ULL, 0x000fca000001160aULL, 0x00001f2f362c7589ULL, 0x006e6400000e0000ULL,
0x000000542c547220ULL, 0x042fe20000410000ULL, 0x000000552c557220ULL, 0x040fe20000410000ULL,
0x0000003c2c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d2c3d7220ULL, 0x040fe20000410000ULL,
0x000000402c407220ULL, 0x040fe20000410000ULL, 0x000000412c417220ULL, 0x040fe20000410000ULL,
0x000000442c447220ULL, 0x040fe20000410000ULL, 0x000000452c457220ULL, 0x040fe20000410000ULL,
0x000000482c487220ULL, 0x040fe20000410000ULL, 0x000000492c497220ULL, 0x040fe20000410000ULL,
0x000000502c507220ULL, 0x040fe20000410000ULL, 0x000000512c517220ULL, 0x040fe20000410000ULL,
0x000000282c287220ULL, 0x040fe20000410000ULL, 0x000000292c297220ULL, 0x040fe20000410000ULL,
0x000000242c247220ULL, 0x040fe20000410000ULL, 0x000000252c257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a2f7811ULL, 0x000fca00078ff0ffULL,
0x00001f2f362c7589ULL, 0x006e6400000e0000ULL, 0x000000562c567220ULL, 0x042fe20000410000ULL,
0x000000572c577220ULL, 0x040fe20000410000ULL, 0x0000003e2c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f2c3f7220ULL, 0x040fe20000410000ULL, 0x000000422c427220ULL, 0x040fe20000410000ULL,
0x000000432c437220ULL, 0x040fe20000410000ULL, 0x000000462c467220ULL, 0x040fe20000410000ULL,
0x000000472c477220ULL, 0x040fe20000410000ULL, 0x0000004a2c4a7220ULL, 0x040fe20000410000ULL,
0x0000004b2c4b7220ULL, 0x040fe20000410000ULL, 0x000000522c527220ULL, 0x040fe20000410000ULL,
0x000000532c537220ULL, 0x040fe20000410000ULL, 0x0000002a2c2a7220ULL, 0x040fe20000410000ULL,
0x0000002b2c2b7220ULL, 0x040fe20000410000ULL, 0x000000262c267220ULL, 0x040fe20000410000ULL,
0x000000272c277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a2f7811ULL, 0x000fca00078ff0ffULL, 0x00001f2f362c7589ULL, 0x006e6400000e0000ULL,
0x0000000c2c0c7220ULL, 0x042fe20000410000ULL, 0x0000000d2c0d7220ULL, 0x040fe20000410000ULL,
0x000000102c107220ULL, 0x040fe20000410000ULL, 0x000000112c117220ULL, 0x040fe20000410000ULL,
0x000000142c147220ULL, 0x040fe20000410000ULL, 0x000000152c157220ULL, 0x040fe20000410000ULL,
0x000000182c187220ULL, 0x040fe20000410000ULL, 0x000000192c197220ULL, 0x040fe20000410000ULL,
0x0000001c2c1c7220ULL, 0x040fe20000410000ULL, 0x0000001d2c1d7220ULL, 0x040fe20000410000ULL,
0x000000202c207220ULL, 0x040fe20000410000ULL, 0x000000212c217220ULL, 0x040fe20000410000ULL,
0x000000302c307220ULL, 0x040fe20000410000ULL, 0x000000312c317220ULL, 0x040fe20000410000ULL,
0x000000382c387220ULL, 0x040fe20000410000ULL, 0x000000392c397220ULL, 0x000fce0000410000ULL,
0x0000003683837220ULL, 0x004fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a2f7811ULL, 0x000fca00078ff0ffULL, 0x00001f2f362c7589ULL, 0x002e6400000e0000ULL,
0x0000000e2c0e7220ULL, 0x042fe20000410000ULL, 0x0000000f2c0f7220ULL, 0x040fe20000410000ULL,
0x000000122c127220ULL, 0x040fe20000410000ULL, 0x000000132c137220ULL, 0x040fe20000410000ULL,
0x000000162c167220ULL, 0x040fe20000410000ULL, 0x000000172c177220ULL, 0x040fe20000410000ULL,
0x0000001a2c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b2c1b7220ULL, 0x040fe20000410000ULL,
0x0000001e2c1e7220ULL, 0x040fe20000410000ULL, 0x0000001f2c1f7220ULL, 0x040fe20000410000ULL,
0x000000222c227220ULL, 0x040fe20000410000ULL, 0x000000232c237220ULL, 0x040fe20000410000ULL,
0x000000322c327220ULL, 0x040fe20000410000ULL, 0x000000332c337220ULL, 0x040fe20000410000ULL,
0x0000003a2c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b2c3b7220ULL, 0x000fce0000410000ULL,
0x0000003435ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff347424ULL, 0x000fe200078e00ffULL,
0x000000852e857209ULL, 0x000fd60007810000ULL, 0x800000852e2e0221ULL, 0x000fe20000010000ULL,
0x00007610ff340816ULL, 0x000fc60000000034ULL, 0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL,
0x0000002e00040308ULL, 0x000ea40000000800ULL, 0x000000042d2d0220ULL, 0x004fce0000410000ULL,
0x000000832d837221ULL, 0x000fce0000010000ULL, 0x00000000002c7805ULL, 0x002fce0000015200ULL,
0x00000089ff0075a7ULL, 0x000e640008000145ULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000352e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000089ff0075a7ULL, 0x000e640008000145ULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00009910342c7816ULL, 0x000fe200000000ffULL,
0x00000400782d7824ULL, 0x000fe400078e00ffULL, 0x000000106d5c7824ULL, 0x000fe200078e0284ULL,
0x000000ff2c00720cULL, 0x000fe40003f05270ULL, 0xfffff0002d807812ULL, 0x000fc800078ec0ffULL,
0x0001400009807810ULL, 0x000fca0007ffe080ULL, 0x000000107f347824ULL, 0x100fe400078e0280ULL,
0x000000107e2c7824ULL, 0x000fe200078e0280ULL, 0x0000000000280947ULL, 0x000fec0003800000ULL,
0x00000002ff2e7819ULL, 0x000fe4000001160aULL, 0x00000004ff00723eULL, 0x000fc600000000ffULL,
0x000000082e027836ULL, 0x000fe20000000000ULL, 0x00005410002d7816ULL, 0x000fe20000000000ULL,
0x000000102e367836ULL, 0x000fe40000000000ULL, 0x000000182e4c7836ULL, 0x000fe40000000000ULL,
0x00001f022d027589ULL, 0x0002a800000e0000ULL, 0x00001f362d057589ULL, 0x0002e800000e0000ULL,
0x00001f2e2d037589ULL, 0x00026800000e0000ULL, 0x00001f4c2d007589ULL, 0x00026400000e0000ULL,
0x000000003434783bULL, 0x002e680000000200ULL, 0x000000002c2c783bULL, 0x000ee20000000200ULL,
0x0000000000200947ULL, 0x000fea0003800000ULL, 0x0000000334347232ULL, 0x082fe40000000000ULL,
0x0000000336367232ULL, 0x000fe40000000000ULL, 0x0000000235357232ULL, 0x084fe40000000000ULL,
0x0000000237377232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x088fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000005c5c783bULL, 0x000f620000004200ULL,
0x000000107b4c7824ULL, 0x000fe400078e0284ULL, 0x0001600072727836ULL, 0x000fc80000000000ULL,
0x000000004c4c783bULL, 0x000f640000004200ULL, 0x000001005d657824ULL, 0x068fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe2000001145dULL, 0x000001005c647824ULL, 0x000fe200078e00ffULL,
0x000088805d927816ULL, 0x040fe200000000ffULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x000001004d687824ULL, 0x004fe200078e00ffULL, 0x0000006500957306ULL, 0x0005e20000200c00ULL,
0x00000018ff937819ULL, 0x000fe2000001145dULL, 0x000001005e5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe2000001144dULL, 0x000001004e697824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fc4000001144cULL, 0x000088805c7f7816ULL, 0x000fe200000000ffULL,
0x0000006400947306ULL, 0x0007e20000200c00ULL, 0x000001004c657824ULL, 0x004fe200078e00ffULL,
0x00000018ff8e7819ULL, 0x000fe2000001145cULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe4000001145dULL, 0x00000018ff8b7819ULL, 0x000fe40000011465ULL,
0x0000009200927306ULL, 0x000ea20000200c00ULL, 0x000001005f647824ULL, 0x008fe200078e00ffULL,
0x000088804d657816ULL, 0x040fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff917819ULL, 0x000fc4000001145cULL, 0x00000018ff907819ULL, 0x000fe40000011464ULL,
0x0000008800887306ULL, 0x000fe20000200c00ULL, 0x000088804c647816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff8d7819ULL, 0x000fe4000001145eULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000009300937306ULL, 0x000ee20000200c00ULL, 0x00000018ff8c7819ULL, 0x000fc4000001145fULL,
0x000088805e5c7816ULL, 0x040fe200000000ffULL, 0x000100005e5e7824ULL, 0x000fe200078e00ffULL,
0x000088805f5d7816ULL, 0x040fe200000000ffULL, 0x000100005f5f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe20000011468ULL, 0x0000007f007f7306ULL, 0x000f620000200c00ULL,
0x00000018ff6a7819ULL, 0x000fe4000001144eULL, 0x000088804e687816ULL, 0x040fe200000000ffULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7b7819ULL, 0x000fc40000011469ULL,
0x00000018ff6b7819ULL, 0x000fe2000001144fULL, 0x0000004d00847306ULL, 0x0005e20000200c00ULL,
0x000088804f697816ULL, 0x040fe400000000ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000004c00897306ULL, 0x0007e20000200c00ULL, 0x00005410924d7816ULL, 0x004fe20000000095ULL,
0x000100004f927824ULL, 0x000fcc00078e00ffULL, 0x0000008e008e7306ULL, 0x000fe20000200c00ULL,
0x000001004f4c7824ULL, 0x00afe200078e00ffULL, 0x00005410934f7816ULL, 0x000fe40000000088ULL,
0x00000018ff887819ULL, 0x000fe40000011492ULL, 0x00000018ff4c7819ULL, 0x000fe4000001144cULL,
0x0000008d008d7306ULL, 0x000ff00000200c00ULL, 0x0000004c007e7306ULL, 0x000bf00000200c00ULL,
0x0000008c008c7306ULL, 0x000fe20000200c00ULL, 0x000054107f4c7816ULL, 0x020fce0000000094ULL,
0x0000006600667306ULL, 0x000e620000200c00ULL, 0x0000004c3454723cULL, 0x000fec0000001854ULL,
0x0000004c2c0c723cULL, 0x000fe2000000180cULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x0000541089667816ULL, 0x002fce0000000066ULL, 0x0000006a006a7306ULL, 0x000fe20000200c00ULL,
0x0000541084677816ULL, 0x004fce0000000067ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000000663450723cULL, 0x000fee0000001850ULL, 0x0000009100917306ULL, 0x000fe20000200c00ULL,
0x000000662c20723cULL, 0x000fee0000001820ULL, 0x0000005c005c7306ULL, 0x000ff00000200c00ULL,
0x0000008f008f7306ULL, 0x000e700000200c00ULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x000054105c5c7816ULL, 0x002fce000000008fULL, 0x0000009000907306ULL, 0x000e700000200c00ULL,
0x0000005e005e7306ULL, 0x000ea20000200c00ULL, 0x000054105d5d7816ULL, 0x002fce0000000090ULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x0000005c3440723cULL, 0x000fe20000001840ULL,
0x000054105e5e7816ULL, 0x004fcc000000008dULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x0000005c2c14723cULL, 0x000fe20000001814ULL, 0x000054105f5f7816ULL, 0x002fcc000000008cULL,
0x0000008b008b7306ULL, 0x000e620000200c00ULL, 0x000000107d5c7824ULL, 0x000fe200078e0272ULL,
0x0000005e3444723cULL, 0x000fec0000001844ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0000005e2c18723cULL, 0x000fe20000001818ULL, 0x0000541064647816ULL, 0x002fcc000000008bULL,
0x0000008a008a7306ULL, 0x000e700000200c00ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000541065657816ULL, 0x002fce000000008aULL, 0x0000007b007b7306ULL, 0x000e620000200c00ULL,
0x000000643448723cULL, 0x000fee0000001848ULL, 0x0000006900697306ULL, 0x000ea20000200c00ULL,
0x000000642c1c723cULL, 0x000fe2000000181cULL, 0x0000541068687816ULL, 0x002fcc000000007bULL,
0x0000004e007f7306ULL, 0x0002e20000200c00ULL, 0x0000541069697816ULL, 0x004fce000000007eULL,
0x0000008800887306ULL, 0x000ea20000200c00ULL, 0x00005410914e7816ULL, 0x002fe2000000008eULL,
0x000000683428723cULL, 0x000fe20000001828ULL, 0x000054107f6a7816ULL, 0x008fca000000006aULL,
0x0000004e343c723cULL, 0x000fe2000000183cULL, 0x00005410886b7816ULL, 0x004fca000000006bULL,
0x0000004e2c10723cULL, 0x000fec0000001810ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x000000682c30723cULL, 0x000fe20000001830ULL, 0x0000001070347824ULL, 0x000fc400078e0280ULL,
0x0000001071807824ULL, 0x000fc600078e0280ULL, 0x0000006a2c38723cULL, 0x000fe20000001838ULL,
0x000000003434783bULL, 0x000e680000000200ULL, 0x00000000802c783bULL, 0x0004e20000000200ULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0x0000000000200947ULL, 0x000fde0003800000ULL,
0x0000000334347232ULL, 0x082fe40000000000ULL, 0x0000000336367232ULL, 0x000fe40000000000ULL,
0x0000000235357232ULL, 0x080fe40000000000ULL, 0x0000000237377232ULL, 0x000fe40000000000ULL,
0x000000052c2c7232ULL, 0x088fe40000000000ULL, 0x000000052e2e7232ULL, 0x000fc40000000000ULL,
0x000000002d2d7232ULL, 0x080fe40000000000ULL, 0x000000002f2f7232ULL, 0x000fce0000000000ULL,
0x000000005c5c783bULL, 0x000f620000004200ULL, 0x00000010734c7824ULL, 0x000fcc00078e0272ULL,
0x000000004c4c783bULL, 0x000f640000004200ULL, 0x000001005d657824ULL, 0x064fe200078e00ffULL,
0x000088805c807816ULL, 0x040fe200000000ffULL, 0x000001005c647824ULL, 0x000fe200078e00ffULL,
0x000088805d8e7816ULL, 0x000fe400000000ffULL, 0x00000018ff657819ULL, 0x000fe40000011465ULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x00000018ff677819ULL, 0x008fe2000001144dULL, 0x000001004d687824ULL, 0x000fe200078e00ffULL,
0x00000018ff8a7819ULL, 0x000fe2000001145dULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff667819ULL, 0x000fe2000001144cULL, 0x000001004e697824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe2000001145cULL, 0x0000006500937306ULL, 0x0005e20000200c00ULL,
0x00000018ff917819ULL, 0x000fe2000001145dULL, 0x000100005c5c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe2000001145eULL, 0x000001005e5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fc4000001145fULL, 0x00000018ff8c7819ULL, 0x000fe2000001145cULL,
0x00000064008f7306ULL, 0x0007620000200c00ULL, 0x000001004c657824ULL, 0x004fe200078e00ffULL,
0x00000018ff8d7819ULL, 0x000fe4000001145dULL, 0x000088805e5c7816ULL, 0x040fe200000000ffULL,
0x000100005e5e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe40000011465ULL,
0x000088804d657816ULL, 0x000fe200000000ffULL, 0x000001005f647824ULL, 0x008fe200078e00ffULL,
0x0000008e008e7306ULL, 0x000ea20000200c00ULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x000088805f5d7816ULL, 0x040fe200000000ffULL, 0x000100005f5f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff907819ULL, 0x000fc40000011464ULL, 0x000088804c647816ULL, 0x040fe200000000ffULL,
0x000100004c4c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144dULL,
0x0000008b008b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff847819ULL, 0x000fe40000011468ULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x00000018ff6a7819ULL, 0x000fe4000001144eULL,
0x000088804e687816ULL, 0x040fe200000000ffULL, 0x0000004d007e7306ULL, 0x0007e20000200c00ULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7b7819ULL, 0x000fc40000011469ULL,
0x00000018ff6b7819ULL, 0x000fe4000001144fULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x0000004c007d7306ULL, 0x000be20000200c00ULL, 0x000001004f4d7824ULL, 0x048fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe4000001145fULL, 0x000088804f697816ULL, 0x000fe400000000ffULL,
0x00000018ff4e7819ULL, 0x000fc4000001144eULL, 0x0000008a008a7306ULL, 0x000fe20000200c00ULL,
0x00005410804c7816ULL, 0x022fe4000000008fULL, 0x00000018ff807819ULL, 0x000fe4000001144dULL,
0x000054108e4d7816ULL, 0x004fe20000000093ULL, 0x000100004f8e7824ULL, 0x000fe400078e00ffULL,
0x0000008900897306ULL, 0x000fe60000200c00ULL, 0x00000018ff8e7819ULL, 0x000fe2000001148eULL,
0x0000004c3454723cULL, 0x000fe80000001854ULL, 0x0000008800887306ULL, 0x000fe40000200c00ULL,
0x0000004c2c0c723cULL, 0x000fec000000180cULL, 0x0000006600667306ULL, 0x000e700000200c00ULL,
0x0000006700677306ULL, 0x000ea20000200c00ULL, 0x000054107d667816ULL, 0x002fce0000000066ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000054107e677816ULL, 0x004fce0000000067ULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x000000663450723cULL, 0x000fee0000001850ULL,
0x0000008c008c7306ULL, 0x000fe20000200c00ULL, 0x000000662c20723cULL, 0x000fee0000001820ULL,
0x0000009100917306ULL, 0x000e700000200c00ULL, 0x0000005c005c7306ULL, 0x000fe20000200c00ULL,
0x00005410914f7816ULL, 0x002fce000000008aULL, 0x0000008d008d7306ULL, 0x000e700000200c00ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x000054105c5c7816ULL, 0x002fce000000008dULL,
0x0000009000907306ULL, 0x000e700000200c00ULL, 0x0000005e005e7306ULL, 0x000ea20000200c00ULL,
0x000054105d5d7816ULL, 0x002fce0000000090ULL, 0x0000005f005f7306ULL, 0x000e620000200c00ULL,
0x0000005c3440723cULL, 0x000fe20000001840ULL, 0x000054105e5e7816ULL, 0x004fcc0000000089ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x0000005c2c14723cULL, 0x000fe20000001814ULL,
0x000054105f5f7816ULL, 0x002fcc0000000088ULL, 0x0000007f007f7306ULL, 0x000e620000200c00ULL,
0x0000005e3444723cULL, 0x000fee0000001844ULL, 0x0000006500657306ULL, 0x000fe20000200c00ULL,
0x0000005e2c18723cULL, 0x000fe20000001818ULL, 0x0000541064647816ULL, 0x002fcc000000007fULL,
0x0000008400847306ULL, 0x000e700000200c00ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x0000541065657816ULL, 0x002fce0000000084ULL, 0x0000007b007b7306ULL, 0x000e620000200c00ULL,
0x000000643448723cULL, 0x000fee0000001848ULL, 0x0000004e00737306ULL, 0x0004e20000200c00ULL,
0x000000642c1c723cULL, 0x000fe2000000181cULL, 0x0000541068687816ULL, 0x002fcc000000007bULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x000054108c4e7816ULL, 0x004fe4000000008bULL,
0x00005410736a7816ULL, 0x008fca000000006aULL, 0x0000008000807306ULL, 0x000e620000200c00ULL,
0x0000004e343c723cULL, 0x000fec000000183cULL, 0x0000004e2c10723cULL, 0x000fe20000001810ULL,
0x0000008e008e7306ULL, 0x000ea20000200c00ULL, 0x0000541069697816ULL, 0x002fce0000000080ULL,
0x000000683428723cULL, 0x000fe20000001828ULL, 0x000054108e6b7816ULL, 0x004fca000000006bULL,
0x000000682c30723cULL, 0x000fec0000001830ULL, 0x0000006a3424723cULL, 0x000fec0000001824ULL,
0x0000006a2c38723cULL, 0x000fe20000001838ULL, 0x0000000278347824ULL, 0x000fc400078e00ffULL,
0x00000001ff377424ULL, 0x000fc600078e00ffULL, 0xfffffff834347812ULL, 0x000fca00078ec0ffULL,
0x0000000109367824ULL, 0x000fe400078e0234ULL, 0x00000037063479a7ULL, 0x0002a4000850003fULL,
0x01a6983736ff79a7ULL, 0x0003f2000850003fULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x00000035060075a7ULL, 0x004ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x002fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000372e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x00000035060075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x00000001582c7836ULL, 0x000fca0000000000ULL,
0x000000612c00720cULL, 0x000fda0003f06070ULL, 0x0000000400f80947ULL, 0x000fea0003800000ULL,
0x00000002582c7836ULL, 0x000fe20000000000ULL, 0x0000850000087ab9ULL, 0x000fe20000000800ULL,
0x0000010081817836ULL, 0x000fe40000000000ULL, 0x00000008824e7c24ULL, 0x010fe2000f8e02ffULL,
0x000000612c00720cULL, 0x000fe40003f06070ULL, 0x00000060812c7812ULL, 0x000fe200078ec0ffULL,
0x000000804e4e7824ULL, 0x000fc800078e00ffULL, 0x00000001592f7824ULL, 0x000fcc00078e022cULL,
0x0000000400048947ULL, 0x000fea0003800000ULL, 0x00000081742c7248ULL, 0x000fe20007fe0000ULL,
0x00000010782d7824ULL, 0x000fe200078e00ffULL, 0x00000003ff347819ULL, 0x000fc6000001160aULL,
0x000000012c2c7824ULL, 0x000fe200078e0a81ULL, 0x000000102d357812ULL, 0x000fe200078ec0ffULL,
0x0000000434367836ULL, 0x002fe40000000000ULL, 0x00000008344c7836ULL, 0x000fe20000000000ULL,
0x0000002c352e7248ULL, 0x000fe20007fe0000ULL, 0x0000000c344f7836ULL, 0x000fe20000000000ULL,
0x00008e00ff2c7b82ULL, 0x000e620000000a00ULL, 0x0000000136377824ULL, 0x100fe400078e0235ULL,
0x000000012e2e7824ULL, 0x000fc400078e0a35ULL, 0x000000014c4d7824ULL, 0x100fe400078e0235ULL,
0x0000000837657824ULL, 0x000fe200078e00ffULL, 0x0000002e3400720cULL, 0x0c0fe20003f86070ULL,
0x0000000134347824ULL, 0x100fe200078e0235ULL, 0x0000002e3600720cULL, 0x080fe20003f66070ULL,
0x000000014f5c7824ULL, 0x040fe200078e0235ULL, 0x0000002e4c00720cULL, 0x080fe20003f46070ULL,
0x0000000134367824ULL, 0x040fe200078e020aULL, 0x0000002e4f00720cULL, 0x000fe20003f06070ULL,
0x00000008345f7824ULL, 0x000fc400078e00ffULL, 0x00000001374c7824ULL, 0x100fe400078e020aULL,
0x000000014d357824ULL, 0x040fe200078e020aULL, 0xfffffff85f5f7812ULL, 0x000fe200078ee236ULL,
0x000000084d5e7824ULL, 0x000fe200078e00ffULL, 0xfffffff865657812ULL, 0x000fe200078ee24cULL,
0x00000001342e7824ULL, 0x100fe200078e022fULL, 0x0000002c4e4f7211ULL, 0x042fe200078a38ffULL,
0x0000000137347824ULL, 0x100fe200078e022fULL, 0xfffffff85e677812ULL, 0x000fe200078ee235ULL,
0x000000014d367824ULL, 0x100fe200078e022fULL, 0x0000002d4e5d7211ULL, 0x000fe200028f3cffULL,
0x000000015c4c7824ULL, 0x000fc400078e022fULL, 0x000000015c377824ULL, 0x040fe400078e020aULL,
0x000000085c5c7824ULL, 0x000fe400078e00ffULL, 0x000000802e2e7825ULL, 0x000fc600078e00ffULL,
0xfffffff85c697812ULL, 0x000fe200078ee237ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000006e2e2c7212ULL, 0x000fc600078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000006e342e7212ULL, 0x080fe400078efcffULL, 0x0000002c4f2c7210ULL, 0x000fe20007fbe0ffULL,
0x000000804c4c7825ULL, 0x000fe200078e00ffULL, 0x0000004f2e2e7210ULL, 0x000fe40007fde0ffULL,
0x0000006e36347212ULL, 0x080fe200078efcffULL, 0x000000012f2d7824ULL, 0x100fe200028e065dULL,
0x0000006e4c367212ULL, 0x000fe200078efcffULL, 0x00000001352f7824ULL, 0x000fe200030e065dULL,
0x0000004f34347210ULL, 0x000fe20007fbe0ffULL, 0x000000105f5f7824ULL, 0x100fe200078e0272ULL,
0x0000004f36367210ULL, 0x000fe20007fde0ffULL, 0x0000001065657824ULL, 0x000fc400078e0272ULL,
0x0000001067677824ULL, 0x100fe200078e0272ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000002c5f7faeULL, 0x0003e2000e101c46ULL, 0x0000000137357824ULL, 0x100fe400028e065dULL,
0x0000001069697824ULL, 0x000fe200078e0272ULL, 0x000000002e657faeULL, 0x0003e2000d901c46ULL,
0x000000014d377824ULL, 0x000fc600030e065dULL, 0x0000000034677faeULL, 0x0003e8000d101c46ULL,
0x0000000036697faeULL, 0x0003e2000c101c46ULL, 0x0000000000d07947ULL, 0x000fea0003800000ULL,
0x00000010782c7824ULL, 0x000fe200078e00ffULL, 0x00008e00ff4c7b82ULL, 0x000ea80000000a00ULL,
0x000000102c2d7812ULL, 0x000fc800078ec0ffULL, 0x0000002d0a2d7211ULL, 0x000fca00078fe8ffULL,
0x000000012d2c7824ULL, 0x040fe400078e020aULL, 0x000000082d4f7824ULL, 0x040fe400078e00ffULL,
0x000000042d347836ULL, 0x000fe40000000000ULL, 0x000000082d377836ULL, 0x002fe20000000000ULL,
0xfffffff84f4f7812ULL, 0x000fe200078ee22cULL, 0x000000012d2c7824ULL, 0x100fe400078e022fULL,
0x0000000c2d2d7836ULL, 0x000fe20000000000ULL, 0x0000004c4e5d7211ULL, 0x004fe200078038ffULL,
0x00000001342e7824ULL, 0x000fc400078e022fULL, 0x0000000134357824ULL, 0x100fe200078e020aULL,
0x0000004d4e4d7211ULL, 0x000fe200000f3cffULL, 0x00000008345c7824ULL, 0x000fe400078e00ffULL,
0x0000000137347824ULL, 0x100fe400078e022fULL, 0x000000012d367824ULL, 0x000fe200078e022fULL,
0xfffffff85c5f7812ULL, 0x000fe200078ee235ULL, 0x00000001372f7824ULL, 0x040fe400078e020aULL,
0x00000008375e7824ULL, 0x000fc400078e00ffULL, 0x000000012d377824ULL, 0x040fe400078e020aULL,
0x000000082d647824ULL, 0x000fe200078e00ffULL, 0xfffffff85e657812ULL, 0x000fe200078ee22fULL,
0x000000802c2c7825ULL, 0x000fc600078e00ffULL, 0xfffffff864677812ULL, 0x000fe200078ee237ULL,
0x000000802e2e7825ULL, 0x000fe200078e00ffULL, 0x0000006e2c2c7212ULL, 0x000fc600078efcffULL,
0x0000008034347825ULL, 0x000fe200078e00ffULL, 0x0000002c5d2c7210ULL, 0x000fe40007f1e0ffULL,
0x0000006e2e2e7212ULL, 0x080fe200078efcffULL, 0x0000008036367825ULL, 0x000fe200078e00ffULL,
0x0000006e34347212ULL, 0x000fc600078efcffULL, 0x000000012d2d7824ULL, 0x100fe200000e064dULL,
0x0000006e36367212ULL, 0x000fe200078efcffULL, 0x000000104f4f7824ULL, 0x100fe200078e0272ULL,
0x0000002e5d2e7210ULL, 0x000fe20007f1e0ffULL, 0x000000105f5f7824ULL, 0x100fe200078e0272ULL,
0x000000345d347210ULL, 0x000fe20007f5e0ffULL, 0x0000001065657824ULL, 0x000fe200078e0272ULL,
0x000000365d367210ULL, 0x000fe20007f7e0ffULL, 0x000000012f2f7824ULL, 0x100fe200000e064dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000002c4f7faeULL, 0x0003e2000b901c46ULL,
0x0000000135357824ULL, 0x000fc400010e064dULL, 0x0000001067677824ULL, 0x000fe200078e0272ULL,
0x000000002e5f7faeULL, 0x0003e2000b901c46ULL, 0x0000000137377824ULL, 0x000fc600018e064dULL,
0x0000000034657faeULL, 0x0003e8000b901c46ULL, 0x0000000036677faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x00000001ff357424ULL, 0x000fe200078e00ffULL,
0x00000000ff0079b0ULL, 0x000fe20008000a44ULL, 0x0000000000007918ULL, 0x000fca0000000000ULL,
0x00000035ff2c79a7ULL, 0x0002a40008500005ULL, 0x01a66835083479a7ULL, 0x0022e4000850003fULL,
0x000000ffff7b7224ULL, 0x006fce00078e002dULL, 0x00000000002c7805ULL, 0x000fce0000015200ULL,
0x01a66835080075a7ULL, 0x008e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c377210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003700780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403700780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000372e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a66835080075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000805a2d7824ULL, 0x000fe400078e0209ULL,
0x00000001ff347424ULL, 0x000fe400078e00ffULL, 0x000000ffff7e7224ULL, 0x000fe200078e0085ULL,
0x000001806e2c7810ULL, 0x000fca0007ffe02dULL, 0x000000016f2c7824ULL, 0x000fca00078e022cULL,
0x01a000002c2e7984ULL, 0x000e680000000800ULL, 0x01a200002c2d7984ULL, 0x0004a20000000800ULL,
0x000000852e00720bULL, 0x002fda0003f1d000ULL, 0x0000000000357806ULL, 0x000fc800000e0100ULL,
0x000000ff3500720cULL, 0x000fda0003f05270ULL, 0x0000000400948947ULL, 0x004fea0003800000ULL,
0x000000035a2f7836ULL, 0x000fe20000000000ULL, 0x000000852e00720bULL, 0x0c0fe40003f14000ULL,
0x000000852e7e7209ULL, 0x000fe40007810000ULL, 0x000000782f00720cULL, 0x000fd20003f45270ULL,
0x0000000000347806ULL, 0x000fc800000e0100ULL, 0x00000080782ca824ULL, 0x000fe200078e0209ULL,
0x000000ff3400720cULL, 0x000fc80003f05270ULL, 0x0000002c6f6fa210ULL, 0x000fca0007ffe06eULL,
0x01a4007e6f00a388ULL, 0x0003e80000000800ULL, 0x0000000400508947ULL, 0x000fea0003800000ULL,
0x000000857e2c7221ULL, 0x000fe20000010100ULL, 0x000000ff34ff7812ULL, 0x040fe4000780c0ffULL,
0x0000ff0034ff7812ULL, 0x000fe2000784c0ffULL, 0x3fb8aa3b2c2c7820ULL, 0x000fe20000410000ULL,
0x00ff000034ff7812ULL, 0x040fe4000786c0ffULL, 0xff00000034ff7812ULL, 0x000fe2000788c0ffULL,
0x0000002c00367308ULL, 0x0004ec0000000800ULL, 0x0000000000488947ULL, 0x000fec0003800000ULL,
0x00000002ff2f7819ULL, 0x000fca000001160aULL, 0x00001f2f362c7589ULL, 0x00cea400000e0000ULL,
0x000000542c547220ULL, 0x044fe20000410000ULL, 0x000000552c557220ULL, 0x040fe20000410000ULL,
0x0000003c2c3c7220ULL, 0x040fe20000410000ULL, 0x0000003d2c3d7220ULL, 0x040fe20000410000ULL,
0x000000402c407220ULL, 0x040fe20000410000ULL, 0x000000412c417220ULL, 0x040fe20000410000ULL,
0x000000442c447220ULL, 0x040fe20000410000ULL, 0x000000452c457220ULL, 0x040fe20000410000ULL,
0x000000482c487220ULL, 0x040fe20000410000ULL, 0x000000492c497220ULL, 0x040fe20000410000ULL,
0x000000502c507220ULL, 0x040fe20000410000ULL, 0x000000512c517220ULL, 0x040fe20000410000ULL,
0x000000282c287220ULL, 0x040fe20000410000ULL, 0x000000292c297220ULL, 0x040fe20000410000ULL,
0x000000242c247220ULL, 0x040fe20000410000ULL, 0x000000252c257220ULL, 0x000fce0000410000ULL,
0x000000000048a947ULL, 0x000fea0003800000ULL, 0x000000080a2f7811ULL, 0x000fca00078ff0ffULL,
0x00001f2f362c7589ULL, 0x00cea400000e0000ULL, 0x000000562c567220ULL, 0x044fe20000410000ULL,
0x000000572c577220ULL, 0x040fe20000410000ULL, 0x0000003e2c3e7220ULL, 0x040fe20000410000ULL,
0x0000003f2c3f7220ULL, 0x040fe20000410000ULL, 0x000000422c427220ULL, 0x040fe20000410000ULL,
0x000000432c437220ULL, 0x040fe20000410000ULL, 0x000000462c467220ULL, 0x040fe20000410000ULL,
0x000000472c477220ULL, 0x040fe20000410000ULL, 0x0000004a2c4a7220ULL, 0x040fe20000410000ULL,
0x0000004b2c4b7220ULL, 0x040fe20000410000ULL, 0x000000522c527220ULL, 0x040fe20000410000ULL,
0x000000532c537220ULL, 0x040fe20000410000ULL, 0x0000002a2c2a7220ULL, 0x040fe20000410000ULL,
0x0000002b2c2b7220ULL, 0x040fe20000410000ULL, 0x000000262c267220ULL, 0x040fe20000410000ULL,
0x000000272c277220ULL, 0x000fce0000410000ULL, 0x000000000048b947ULL, 0x000fea0003800000ULL,
0x000000100a2f7811ULL, 0x000fca00078ff0ffULL, 0x00001f2f362c7589ULL, 0x00cea400000e0000ULL,
0x0000000c2c0c7220ULL, 0x044fe20000410000ULL, 0x0000000d2c0d7220ULL, 0x040fe20000410000ULL,
0x000000102c107220ULL, 0x040fe20000410000ULL, 0x000000112c117220ULL, 0x040fe20000410000ULL,
0x000000142c147220ULL, 0x040fe20000410000ULL, 0x000000152c157220ULL, 0x040fe20000410000ULL,
0x000000182c187220ULL, 0x040fe20000410000ULL, 0x000000192c197220ULL, 0x040fe20000410000ULL,
0x0000001c2c1c7220ULL, 0x040fe20000410000ULL, 0x0000001d2c1d7220ULL, 0x040fe20000410000ULL,
0x000000202c207220ULL, 0x040fe20000410000ULL, 0x000000212c217220ULL, 0x040fe20000410000ULL,
0x000000302c307220ULL, 0x040fe20000410000ULL, 0x000000312c317220ULL, 0x040fe20000410000ULL,
0x000000382c387220ULL, 0x040fe20000410000ULL, 0x000000392c397220ULL, 0x000fce0000410000ULL,
0x0000003683837220ULL, 0x008fe20000410000ULL, 0x000000000048c947ULL, 0x000fec0003800000ULL,
0x000000180a2f7811ULL, 0x000fca00078ff0ffULL, 0x00001f2f362c7589ULL, 0x004ea400000e0000ULL,
0x0000000e2c0e7220ULL, 0x044fe20000410000ULL, 0x0000000f2c0f7220ULL, 0x040fe20000410000ULL,
0x000000122c127220ULL, 0x040fe20000410000ULL, 0x000000132c137220ULL, 0x040fe20000410000ULL,
0x000000162c167220ULL, 0x040fe20000410000ULL, 0x000000172c177220ULL, 0x040fe20000410000ULL,
0x0000001a2c1a7220ULL, 0x040fe20000410000ULL, 0x0000001b2c1b7220ULL, 0x040fe20000410000ULL,
0x0000001e2c1e7220ULL, 0x040fe20000410000ULL, 0x0000001f2c1f7220ULL, 0x040fe20000410000ULL,
0x000000222c227220ULL, 0x040fe20000410000ULL, 0x000000232c237220ULL, 0x040fe20000410000ULL,
0x000000322c327220ULL, 0x040fe20000410000ULL, 0x000000332c337220ULL, 0x040fe20000410000ULL,
0x0000003a2c3a7220ULL, 0x040fe20000410000ULL, 0x0000003b2c3b7220ULL, 0x000fce0000410000ULL,
0x0000003435ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff347424ULL, 0x000fd800078e00ffULL,
0x0000002e7e2e0221ULL, 0x000fe20000010100ULL, 0x00007610ff340816ULL, 0x000fc60000000034ULL,
0x3fb8aa3b2e2e0820ULL, 0x000fc80000410000ULL, 0x0000002e00040308ULL, 0x000ee40000000800ULL,
0x000000042d2d0220ULL, 0x008fce0000410000ULL, 0x000000832d837221ULL, 0x000fce0000010000ULL,
0x00000000002c7805ULL, 0x004fce0000015200ULL, 0x00000008782e7824ULL, 0x000fca00078e00ffULL,
0xfffffff02e2e7812ULL, 0x000fca00078ec0ffULL, 0x0000000109377824ULL, 0x000fc800078e022eULL,
0x01a6b087370075a7ULL, 0x000ea4000800017fULL, 0x00000000005c0947ULL, 0x004fea0003800000ULL,
0x000000ffff367224ULL, 0x000fce00078e00ffULL, 0x000000103600780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000002e7805ULL, 0x000fce0000015200ULL,
0x0000002e2c357210ULL, 0x000fca0007f1e1ffULL, 0x000000012f2f7824ULL, 0x000fe200000e0e2dULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff2f00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff2f00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff2e7819ULL, 0x000fc8000001142fULL, 0x000000352e2e7211ULL, 0x000fca00078110ffULL,
0x000000ffff2f7224ULL, 0x000fca00000e062fULL, 0x000000022e2e7819ULL, 0x000fc8000000122fULL,
0x0000002e0000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000136367836ULL, 0x000fce0000000000ULL, 0x01a6b087370075a7ULL, 0x000ea4000800017fULL,
0xfffffffc00a88947ULL, 0x004fea000383ffffULL, 0x00000001622c7812ULL, 0x000fe200078ec0ffULL,
0x00000004782e7824ULL, 0x000fe200078e00ffULL, 0x00000004ff2f7819ULL, 0x000fe2000001160aULL,
0x000010005a6e7824ULL, 0x000fe200078e0209ULL, 0x00009910342d7816ULL, 0x000fe200000000ffULL,
0x000000086c347824ULL, 0x000fe200078e00ffULL, 0x000000042e2e7812ULL, 0x000fe200078ec0ffULL,
0x000000042c2c7824ULL, 0x000fe200078e022fULL, 0x000000ff2d00720cULL, 0x000fe20003f05270ULL,
0x00000008792f7824ULL, 0x000fe200078e00ffULL, 0x000000022e7d7812ULL, 0x000fe200078efcffULL,
0x000000016c2d7824ULL, 0x000fc400078e022cULL, 0x00000001792c7824ULL, 0x000fe400078e022cULL,
0x000150006e6e7836ULL, 0x000fe20000000000ULL, 0xfffffff8342d7812ULL, 0x000fe200078ee22dULL,
0x000000106d4c7824ULL, 0x000fe200078e027aULL, 0xfffffff82f2f7812ULL, 0x000fc600078ee22cULL,
0x000000102d2d7824ULL, 0x100fe400078e026eULL, 0x000000102f2f7824ULL, 0x000fe200078e026eULL,
0x0000000000280947ULL, 0x000fec0003800000ULL, 0x00000002ff037819ULL, 0x000fe4000001160aULL,
0x00000004ff00723eULL, 0x000fc600000000ffULL, 0x0000001003057836ULL, 0x000fe20000000000ULL,
0x00005410002c7816ULL, 0x000fe20000000000ULL, 0x0000000803357836ULL, 0x000fe40000000000ULL,
0x0000001803377836ULL, 0x000fe40000000000ULL, 0x00001f052c057589ULL, 0x0004e800000e0000ULL,
0x00001f352c027589ULL, 0x00046800000e0000ULL, 0x00001f032c037589ULL, 0x00046800000e0000ULL,
0x00001f372c007589ULL, 0x00046400000e0000ULL, 0x000000002d5c783bULL, 0x000ae80000000200ULL,
0x000000002f34783bULL, 0x0044620000000200ULL, 0x0000000000200947ULL, 0x020fea0003800000ULL,
0x000000035c5c7232ULL, 0x08afe40000000000ULL, 0x000000035e5e7232ULL, 0x000fe40000000000ULL,
0x000000025d5d7232ULL, 0x080fe40000000000ULL, 0x000000025f5f7232ULL, 0x000fe40000000000ULL,
0x0000000534347232ULL, 0x080fe40000000000ULL, 0x0000000536367232ULL, 0x000fc40000000000ULL,
0x0000000035357232ULL, 0x080fe40000000000ULL, 0x0000000037377232ULL, 0x000fce0000000000ULL,
0x000000004c4c783bULL, 0x000f620000004200ULL, 0x0000007d0a7d7211ULL, 0x000fe200078fe0ffULL,
0x000000086c2d7824ULL, 0x000fc800078e00ffULL, 0x000000016c6c7824ULL, 0x000fca00078e027dULL,
0xfffffff82d2d7812ULL, 0x000fca00078ee26cULL, 0x000000102d2d7824ULL, 0x000fcc00078e027aULL,
0x000000002d2c783bULL, 0x004ea20000004200ULL, 0x000001004c677824ULL, 0x060fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe2000001144cULL, 0x000001004d687824ULL, 0x040fe200078e00ffULL,
0x000088804c667816ULL, 0x040fe200000000ffULL, 0x000100004c4c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff897819ULL, 0x000fe20000011467ULL, 0x000001004e697824ULL, 0x000fe200078e00ffULL,
0x00000018ff657819ULL, 0x000fe2000001144dULL, 0x0000006400647306ULL, 0x000fe20000200c00ULL,
0x000088804d677816ULL, 0x040fe200000000ffULL, 0x000100004d4d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff4c7819ULL, 0x000fc4000001144cULL, 0x00000018ff847819ULL, 0x000fe40000011468ULL,
0x00000018ff4d7819ULL, 0x000fe2000001144dULL, 0x0000004c00877306ULL, 0x000b620000200c00ULL,
0x00000018ff6a7819ULL, 0x000fe4000001144eULL, 0x000088804e687816ULL, 0x040fe200000000ffULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe20000011469ULL,
0x000001002e817824ULL, 0x004fe200078e00ffULL, 0x00000018ff867819ULL, 0x000fe2000001142cULL,
0x0000004d00887306ULL, 0x0005e20000200c00ULL, 0x000001004f4c7824ULL, 0x028fe200078e00ffULL,
0x000088802c6c7816ULL, 0x000fe200000000ffULL, 0x000001002f8c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fc4000001144fULL, 0x00000018ff8a7819ULL, 0x000fe4000001144cULL,
0x00000018ff4c7819ULL, 0x000fe2000001144eULL, 0x000100004f4d7824ULL, 0x044fe200078e00ffULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000088804f697816ULL, 0x000fe400000000ffULL,
0x00000018ff727819ULL, 0x000fe4000001142eULL, 0x00000018ff4e7819ULL, 0x000fe2000001144dULL,
0x000001002c4d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff737819ULL, 0x000fe2000001142fULL,
0x000100002c2c7824ULL, 0x000fe200078e00ffULL, 0x0000008400847306ULL, 0x000ea20000200c00ULL,
0x000088802e807816ULL, 0x040fe200000000ffULL, 0x000100002e2e7824ULL, 0x000fe200078e00ffULL,
0x000088802f8b7816ULL, 0x040fe200000000ffULL, 0x000100002f2f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001142cULL, 0x000100002d2c7824ULL, 0x040fe200078e00ffULL,
0x000088802d6d7816ULL, 0x000fe200000000ffULL, 0x0000006500657306ULL, 0x000ee20000200c00ULL,
0x00000018ff6f7819ULL, 0x002fc4000001142dULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0x00000018ff2c7819ULL, 0x000fe4000001142cULL, 0x00000018ff817819ULL, 0x000fe20000011481ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x00000018ff8c7819ULL, 0x000fe4000001148cULL,
0x0000541087647816ULL, 0x000fe40000000064ULL, 0x00000018ff2e7819ULL, 0x000fc4000001142eULL,
0x00000018ff877819ULL, 0x000fe2000001142fULL, 0x0000008500857306ULL, 0x000e620000200c00ULL,
0x0000541067677816ULL, 0x004fe40000000084ULL, 0x0000541088657816ULL, 0x008fca0000000065ULL,
0x0000004c004f7306ULL, 0x0005e40000200c00ULL, 0x000000643410723cULL, 0x000fe20000001810ULL,
0x0000541068687816ULL, 0x002fca0000000085ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x000001002d4c7824ULL, 0x004fe200078e00ffULL, 0x000000645c3c723cULL, 0x000fe8000000183cULL,
0x00000018ff4c7819ULL, 0x000fe4000001144cULL, 0x0000007f002d7306ULL, 0x000ff00000200c00ULL,
0x0000004c004c7306ULL, 0x000e700000200c00ULL, 0x0000006a006a7306ULL, 0x000ea20000200c00ULL,
0x000054106d6d7816ULL, 0x002fce000000004cULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x00000010704c7824ULL, 0x000fe200078e026eULL, 0x000054104f6a7816ULL, 0x004fcc000000006aULL,
0x0000008600867306ULL, 0x000ff00000200c00ULL, 0x0000006f006f7306ULL, 0x000ff00000200c00ULL,
0x0000006600667306ULL, 0x000ff00000200c00ULL, 0x0000008900897306ULL, 0x000e700000200c00ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x0000541066667816ULL, 0x002fce0000000089ULL,
0x0000008a008a7306ULL, 0x000e620000200c00ULL, 0x00000066340c723cULL, 0x000fee000000180cULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x000000665c54723cULL, 0x000fe20000001854ULL,
0x0000541069697816ULL, 0x002fcc000000008aULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x000000683414723cULL, 0x000fe20000001814ULL, 0x000054104e6b7816ULL, 0x004fcc000000006bULL,
0x0000004d004d7306ULL, 0x000e620000200c00ULL, 0x000000685c40723cULL, 0x000fee0000001840ULL,
0x0000002c002c7306ULL, 0x000ea20000200c00ULL, 0x0000006a3418723cULL, 0x000fe20000001818ULL,
0x000054106c6c7816ULL, 0x002fcc000000004dULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x0000006a5c44723cULL, 0x000fe20000001844ULL, 0x000000004c4c783bULL, 0x000ee20000000200ULL,
0x000054102c6f7816ULL, 0x004fca000000006fULL, 0x0000008100817306ULL, 0x000e620000200c00ULL,
0x0000006c341c723cULL, 0x000fec000000181cULL, 0x0000006c5c48723cULL, 0x000fe20000001848ULL,
0x0000008b007f7306ULL, 0x000fe20000200c00ULL, 0x0000541080707816ULL, 0x002fce0000000081ULL,
0x0000008c00847306ULL, 0x000e700000200c00ULL, 0x0000007200727306ULL, 0x000ff00000200c00ULL,
0x0000007300737306ULL, 0x000ff00000200c00ULL, 0x0000002e00857306ULL, 0x0005700000200c00ULL,
0x0000008700887306ULL, 0x000ee20000200c00ULL, 0x00000010712e7824ULL, 0x004fe200078e026eULL,
0x000054102d6e7816ULL, 0x000fc40000000086ULL, 0x000054107f717816ULL, 0x002fe40000000084ULL,
0x0000541085727816ULL, 0x020fe20000000072ULL, 0x000000002e2c783bULL, 0x000e640000000200ULL,
0x0000006e3420723cULL, 0x000fe20000001820ULL, 0x0000541088737816ULL, 0x008fca0000000073ULL,
0x000000703430723cULL, 0x000fec0000001830ULL, 0x0000006e5c50723cULL, 0x000fec0000001850ULL,
0x000000705c28723cULL, 0x000fec0000001828ULL, 0x000000725c24723cULL, 0x000fec0000001824ULL,
0x000000723434723cULL, 0x000fe20000001838ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0x0000000000200947ULL, 0x000fde0003800000ULL, 0x000000034c4c7232ULL, 0x080fe40000000000ULL,
0x000000034e4e7232ULL, 0x000fe40000000000ULL, 0x000000024d4d7232ULL, 0x080fe40000000000ULL,
0x000000024f4f7232ULL, 0x000fe40000000000ULL, 0x000000052c2c7232ULL, 0x082fe40000000000ULL,
0x000000052e2e7232ULL, 0x000fc40000000000ULL, 0x000000002d2d7232ULL, 0x080fe40000000000ULL,
0x000000002f2f7232ULL, 0x000fce0000000000ULL, 0x000000007c5c783bULL, 0x000ea20000004200ULL,
0x00000001797d7824ULL, 0x000fe400078e027dULL, 0x0000000158587836ULL, 0x000fe40000000000ULL,
0x000001005c387824ULL, 0x044fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fe2000001145cULL,
0x000001005d397824ULL, 0x000fe200078e00ffULL, 0x000088805c677816ULL, 0x040fe200000000ffULL,
0x000100005c5c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe20000011438ULL,
0x0000000879387824ULL, 0x000fe200078e00ffULL, 0x00000018ff847819ULL, 0x000fe20000011439ULL,
0x000001005e647824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe2000001145cULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0xfffffff8387d7812ULL, 0x000fc400078ee27dULL,
0x00000018ff6d7819ULL, 0x000fe4000001145eULL, 0x000088805e727816ULL, 0x040fe200000000ffULL,
0x000000107d387824ULL, 0x000fe200078e027aULL, 0x000088805d7f7816ULL, 0x000fe200000000ffULL,
0x0000005c007d7306ULL, 0x0005e20000200c00ULL, 0x000100005e5e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe4000001145fULL, 0x000000003838783bULL, 0x000ee20000004200ULL,
0x000088805f737816ULL, 0x000fc400000000ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001145dULL,
0x0000007c007c7306ULL, 0x000f620000200c00ULL, 0x000001005f5c7824ULL, 0x044fe200078e00ffULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x000100005f5f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5e7819ULL, 0x000fe2000001145eULL, 0x000100005d5d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000007f007f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff717819ULL, 0x000fc4000001145fULL, 0x00000018ff5d7819ULL, 0x000fca000001145dULL,
0x0000008400847306ULL, 0x000eb00000200c00ULL, 0x0000005c007a7306ULL, 0x000ff00000200c00ULL,
0x0000006400797306ULL, 0x0005e20000200c00ULL, 0x00000018ff657819ULL, 0x008fe2000001143aULL,
0x000001003a817824ULL, 0x000fe200078e00ffULL, 0x00000018ff5f7819ULL, 0x000fca0000011438ULL,
0x0000005e00707306ULL, 0x0007e20000200c00ULL, 0x00000018ff647819ULL, 0x006fe40000011439ULL,
0x0000888038697816ULL, 0x000fe400000000ffULL, 0x0000888039687816ULL, 0x000fc600000000ffULL,
0x00000065005c7306ULL, 0x0003e20000200c00ULL, 0x00000100385e7824ULL, 0x048fe400078e00ffULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe4000001145eULL,
0x0000006e006e7306ULL, 0x000ea20000200c00ULL, 0x0000010039657824ULL, 0x042fe200078e00ffULL,
0x00000018ff387819ULL, 0x000fe20000011438ULL, 0x0001000039397824ULL, 0x000fc600078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe40000011465ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x00000018ff397819ULL, 0x000fce0000011439ULL, 0x0000005d00807306ULL, 0x0002f00000200c00ULL,
0x0000003800667306ULL, 0x000be20000200c00ULL, 0x00000018ff5d7819ULL, 0x002fce000001143bULL,
0x0000003900657306ULL, 0x0003e20000200c00ULL, 0x0000541067387816ULL, 0x020fe2000000007cULL,
0x000001003b7c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fc80000011481ULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x000054107f397816ULL, 0x002fce0000000084ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x000000384c54723cULL, 0x000fec0000001854ULL, 0x000000382c0c723cULL, 0x000fe2000000180cULL,
0x0000007100717306ULL, 0x000e6c0000200c00ULL, 0x000054107d387816ULL, 0x004fc4000000006eULL,
0x0000007200727306ULL, 0x000ea20000200c00ULL, 0x000088803b6e7816ULL, 0x040fe200000000ffULL,
0x000100003b3b7824ULL, 0x000fe200078e00ffULL, 0x0000541080397816ULL, 0x008fc8000000006fULL,
0x00000018ff3b7819ULL, 0x000fe2000001143bULL, 0x0000005e006a7306ULL, 0x0007e20000200c00ULL,
0x0000541071717816ULL, 0x002fe2000000006cULL, 0x000000384c3c723cULL, 0x000fec000000183cULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x000088803a5e7816ULL, 0x048fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x000000382c10723cULL, 0x000fe80000001810ULL,
0x00000018ff3a7819ULL, 0x000fe2000001143aULL, 0x0000006400647306ULL, 0x000fe40000200c00ULL,
0x0000541073397816ULL, 0x000fc4000000007aULL, 0x0000541072387816ULL, 0x004fc80000000079ULL,
0x0000006900697306ULL, 0x000e660000200c00ULL, 0x000000384c40723cULL, 0x000fea0000001840ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000000382c14723cULL, 0x000fee0000001814ULL,
0x0000006b006b7306ULL, 0x000ea20000200c00ULL, 0x0000541069387816ULL, 0x002fce000000006aULL,
0x0000006d006d7306ULL, 0x000e620000200c00ULL, 0x0000541068397816ULL, 0x004fce000000006bULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x000000384c48723cULL, 0x000fe20000001848ULL,
0x0000541070707816ULL, 0x002fcc000000006dULL, 0x0000006700677306ULL, 0x000e620000200c00ULL,
0x000000382c1c723cULL, 0x000fee000000181cULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x000000702c18723cULL, 0x000fe20000001818ULL, 0x000054105e5e7816ULL, 0x002fcc0000000067ULL,
0x0000007c00737306ULL, 0x000e620000200c00ULL, 0x000000704c44723cULL, 0x000fee0000001844ULL,
0x0000005d005d7306ULL, 0x000ff00000200c00ULL, 0x0000003a006f7306ULL, 0x0004f00000200c00ULL,
0x0000003b006c7306ULL, 0x000b620000200c00ULL, 0x00005410663a7816ULL, 0x004fc4000000005fULL,
0x000054106e5f7816ULL, 0x002fe40000000073ULL, 0x000054106f5c7816ULL, 0x008fe4000000005cULL,
0x00005410653b7816ULL, 0x020fc60000000064ULL, 0x0000005e2c30723cULL, 0x000fe20000001830ULL,
0x000054106c5d7816ULL, 0x000fca000000005dULL, 0x0000003a4c50723cULL, 0x000fec0000001850ULL,
0x0000003a2c20723cULL, 0x000fec0000001820ULL, 0x0000005e4c28723cULL, 0x000fe20000001828ULL,
0x00000001ff3b7424ULL, 0x000fc800078e00ffULL, 0x0000003b063879a7ULL, 0x0002a2000850003fULL,
0x0000005c4c24723cULL, 0x000fec0000001824ULL, 0x0000005c2c2c723cULL, 0x000fe20000001834ULL,
0x000000085a067824ULL, 0x002fc800078e0209ULL, 0x01a6a03b06ff79a7ULL, 0x0003e2000850003fULL,
0x0000000000007918ULL, 0x000fc60000000000ULL, 0xffffff6000589947ULL, 0x000fde000383ffffULL,
0x000000ff6100720cULL, 0x000fe20003f05270ULL, 0x000000ffff397224ULL, 0x004fe400078e0041ULL,
0x000000ffff377224ULL, 0x000fe400078e0040ULL, 0x000000ffff357224ULL, 0x000fd000078e003cULL,
0x0000000400648947ULL, 0x000fea0003800000ULL, 0x0180000083007836ULL, 0x000fe20000000000ULL,
0x000000b000007945ULL, 0x000fe80003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x00000000000c0947ULL, 0x000fea0003800000ULL,
0x0000bcc000047802ULL, 0x000fce0000000f00ULL, 0x000000a800947944ULL, 0x012fea0003c00000ULL,
0x0000000000107947ULL, 0x000fea0003800000ULL, 0x0000008300007308ULL, 0x000ea40000001000ULL,
0xbf80000000027423ULL, 0x006fc80000000083ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000300007223ULL, 0x000fce0000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00009800ff027b82ULL, 0x000f640000000a00ULL, 0x0000000602037981ULL, 0x02aee2000c1e9900ULL,
0x0000000000067919ULL, 0x000e640000000000ULL, 0x0000000806057811ULL, 0x042fe400078ff0ffULL,
0x0000001806077811ULL, 0x040fe400078ff0ffULL, 0x00000002ff3b7819ULL, 0x000fe40000011606ULL,
0x0000001006417811ULL, 0x000fe200078ff0ffULL, 0x0000000003007220ULL, 0x00cfca0000410000ULL,
0x00001f3b00047589ULL, 0x000e6800000e0000ULL, 0x00001f0500057589ULL, 0x000ea800000e0000ULL,
0x00001f4100067589ULL, 0x000ee800000e0000ULL, 0x00001f0700077589ULL, 0x000f6200000e0000ULL,
0x0000005404547220ULL, 0x042fe20000410000ULL, 0x0000005504557220ULL, 0x040fe20000410000ULL,
0x0000003504357220ULL, 0x040fe20000410000ULL, 0x0000003d043d7220ULL, 0x040fe20000410000ULL,
0x0000003704377220ULL, 0x040fe20000410000ULL, 0x0000003904397220ULL, 0x040fe20000410000ULL,
0x0000004404447220ULL, 0x040fe20000410000ULL, 0x0000004504457220ULL, 0x040fe20000410000ULL,
0x0000004804487220ULL, 0x040fe20000410000ULL, 0x0000004904497220ULL, 0x040fe20000410000ULL,
0x0000005004507220ULL, 0x040fe20000410000ULL, 0x0000005104517220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000002404247220ULL, 0x040fe20000410000ULL, 0x0000002504257220ULL, 0x000fe20000410000ULL,
0x0000005605567220ULL, 0x044fe20000410000ULL, 0x0000005705577220ULL, 0x040fe20000410000ULL,
0x0000003e053e7220ULL, 0x040fe20000410000ULL, 0x0000003f053f7220ULL, 0x040fe20000410000ULL,
0x0000004205427220ULL, 0x040fe20000410000ULL, 0x0000004305437220ULL, 0x040fe20000410000ULL,
0x0000004605467220ULL, 0x040fe20000410000ULL, 0x0000004705477220ULL, 0x040fe20000410000ULL,
0x0000004a054a7220ULL, 0x040fe20000410000ULL, 0x0000004b054b7220ULL, 0x040fe20000410000ULL,
0x0000005205527220ULL, 0x040fe20000410000ULL, 0x0000005305537220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000002605267220ULL, 0x040fe20000410000ULL, 0x0000002705277220ULL, 0x000fe20000410000ULL,
0x0000000c060c7220ULL, 0x048fe20000410000ULL, 0x0000000d060d7220ULL, 0x040fe20000410000ULL,
0x0000001006107220ULL, 0x040fe20000410000ULL, 0x0000001106117220ULL, 0x040fe20000410000ULL,
0x0000001406147220ULL, 0x040fe20000410000ULL, 0x0000001506157220ULL, 0x040fe20000410000ULL,
0x0000001806187220ULL, 0x040fe20000410000ULL, 0x0000001906197220ULL, 0x040fe20000410000ULL,
0x0000001c061c7220ULL, 0x040fe20000410000ULL, 0x0000001d061d7220ULL, 0x040fe20000410000ULL,
0x0000002006207220ULL, 0x040fe20000410000ULL, 0x0000002106217220ULL, 0x040fe20000410000ULL,
0x0000003006307220ULL, 0x040fe20000410000ULL, 0x0000003106317220ULL, 0x040fe20000410000ULL,
0x0000002c062c7220ULL, 0x040fe20000410000ULL, 0x0000002d062d7220ULL, 0x000fe20000410000ULL,
0x0000000e070e7220ULL, 0x060fe20000410000ULL, 0x0000000f070f7220ULL, 0x040fe20000410000ULL,
0x0000001207127220ULL, 0x040fe20000410000ULL, 0x0000001307137220ULL, 0x040fe20000410000ULL,
0x0000001607167220ULL, 0x040fe20000410000ULL, 0x0000001707177220ULL, 0x040fe20000410000ULL,
0x0000001a071a7220ULL, 0x040fe20000410000ULL, 0x0000001b071b7220ULL, 0x040fe20000410000ULL,
0x0000001e071e7220ULL, 0x040fe20000410000ULL, 0x0000001f071f7220ULL, 0x040fe20000410000ULL,
0x0000002207227220ULL, 0x040fe20000410000ULL, 0x0000002307237220ULL, 0x040fe20000410000ULL,
0x0000003207327220ULL, 0x040fe20000410000ULL, 0x0000003307337220ULL, 0x040fe20000410000ULL,
0x0000002e072e7220ULL, 0x040fe20000410000ULL, 0x0000002f072f7220ULL, 0x000fce0000410000ULL,
0x0000000000007919ULL, 0x000ea20000000000ULL, 0x0000000178787812ULL, 0x000fe400078ec0ffULL,
0x000000484948723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000200078097824ULL, 0x000fe200078e0209ULL, 0x000000505150723eULL, 0x000fc400000000ffULL,
0x000000282928723eULL, 0x000fe400000000ffULL, 0x000000242524723eULL, 0x000fe400000000ffULL,
0x000000565756723eULL, 0x000fe400000000ffULL, 0x0000003e3f3e723eULL, 0x000fe400000000ffULL,
0x000000424342723eULL, 0x000fe400000000ffULL, 0x000000464746723eULL, 0x000fc400000000ffULL,
0x0000004a4b4a723eULL, 0x000fe400000000ffULL, 0x000000525325723eULL, 0x000fe400000000ffULL,
0x0000002a2b2a723eULL, 0x000fe400000000ffULL, 0x000000262726723eULL, 0x000fe400000000ffULL,
0x0000000800057811ULL, 0x044fe400078ff0ffULL, 0x0000000200027812ULL, 0x002fc400078ec0ffULL,
0x00000002ff077819ULL, 0x000fe20000011600ULL, 0x00000008050a7824ULL, 0x000fe200078e00ffULL,
0x0000000502037211ULL, 0x000fe400078ff8ffULL, 0x0000001000057811ULL, 0x040fe200078ff0ffULL,
0x0000000807087824ULL, 0x040fe200078e00ffULL, 0xfffffff80a0a7812ULL, 0x000fe200078ee203ULL,
0x0000000807347824ULL, 0x000fe200078e00ffULL, 0x00000018003b7811ULL, 0x000fe200078ff0ffULL,
0x0000000805417824ULL, 0x000fe200078e00ffULL, 0x0000000702037211ULL, 0x000fc400078ff8ffULL,
0x0000000502047211ULL, 0x040fe200078ff8ffULL, 0x000000083b3c7824ULL, 0x000fe200078e00ffULL,
0x0000003b02057211ULL, 0x000fe200078ff8ffULL, 0x00000008073b7824ULL, 0x000fe200078e00ffULL,
0xfffffff841367812ULL, 0x000fe200078ee204ULL, 0x0000000203027836ULL, 0x000fe20000000000ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee205ULL, 0x0000000403057836ULL, 0x000fe20000000000ULL,
0x0000000c0d0c723eULL, 0x000fe200000000ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff83b067812ULL, 0x000fe200078ee202ULL, 0x0000000807027824ULL, 0x000fe200078e00ffULL,
0xfffffff808087812ULL, 0x000fe200078ee205ULL, 0x0000000603077836ULL, 0x000fe20000000000ULL,
0x0000000804057812ULL, 0x000fc400078ec0ffULL, 0xfffffff802027812ULL, 0x000fe200078ee203ULL,
0x0000100062037824ULL, 0x000fe200078e0209ULL, 0xfffffff834347812ULL, 0x000fe400078ee207ULL,
0x000000141514723eULL, 0x000fe200000000ffULL, 0x000000100a387824ULL, 0x100fe200078e0203ULL,
0x0000001c1d1c723eULL, 0x000fe200000000ffULL, 0x00000010363a7824ULL, 0x100fe200078e0203ULL,
0x000000202120723eULL, 0x000fe200000000ffULL, 0x0000001002047824ULL, 0x100fe200078e0203ULL,
0x000000545502723eULL, 0x000fe200000000ffULL, 0x000000103c3c7824ULL, 0x100fe200078e0203ULL,
0x000000303130723eULL, 0x000fe200000000ffULL, 0x0000001006067824ULL, 0x100fe200078e0203ULL,
0x0000000e0f0e723eULL, 0x000fe200000000ffULL, 0x00000010080a7824ULL, 0x100fe200078e0203ULL,
0x000000121307723eULL, 0x000fe200000000ffULL, 0x0000001034367824ULL, 0x000fe200078e0203ULL,
0x000000353d03723eULL, 0x000fe200000000ffULL, 0x0000000104047824ULL, 0x000fe200078e0205ULL,
0x000000161716723eULL, 0x000fe200000000ffULL, 0x0000000105387824ULL, 0x040fe200078e0238ULL,
0x0000541002407816ULL, 0x140fe20000000003ULL, 0x00000001053a7824ULL, 0x040fe200078e023aULL,
0x0000763202417816ULL, 0x000fe20000000003ULL, 0x00000001053c7824ULL, 0x000fe200078e023cULL,
0x000000373902723eULL, 0x000fe200000000ffULL, 0x0000000105087824ULL, 0x000fe200078e0206ULL,
0x000000444503723eULL, 0x000fe200000000ffULL, 0x0000004004007388ULL, 0x0003e20000000a00ULL,
0x0000000105347824ULL, 0x000fe200078e020aULL, 0x000000101106723eULL, 0x000fe200000000ffULL,
0x0000000105367824ULL, 0x000fe200078e0236ULL, 0x0000763202057816ULL, 0x000fc40000000003ULL,
0x00000018190a723eULL, 0x000fe400000000ffULL, 0x0000002c2d18723eULL, 0x000fe400000000ffULL,
0x0000001a1b1a723eULL, 0x000fe400000000ffULL, 0x0000541002047816ULL, 0x002fe40000000003ULL,
0x0000541048027816ULL, 0x140fe40000000050ULL, 0x0000763248037816ULL, 0x000fe20000000050ULL,
0x0000000408007388ULL, 0x000fe20000000a00ULL, 0x0000001e1f1e723eULL, 0x000fc400000000ffULL,
0x00000022230f723eULL, 0x000fe200000000ffULL, 0x0000000234007388ULL, 0x0003e20000000a00ULL,
0x000000323332723eULL, 0x000fe400000000ffULL, 0x0000002e2f19723eULL, 0x000fe400000000ffULL,
0x00007632160d7816ULL, 0x000fe4000000001aULL, 0x000076321e217816ULL, 0x000fe4000000000fULL,
0x0000763232297816ULL, 0x000fc40000000019ULL, 0x000000ff6200720cULL, 0x000fe40003f05270ULL,
0x0000541028027816ULL, 0x142fe40000000024ULL, 0x0000763228037816ULL, 0x000fe40000000024ULL,
0x000054104a247816ULL, 0x140fe40000000025ULL, 0x000076324a257816ULL, 0x000fe20000000025ULL,
0x0000000236007388ULL, 0x0003e20000000a00ULL, 0x0000541032287816ULL, 0x000fc40000000019ULL,
0x0000541056027816ULL, 0x142fe4000000003eULL, 0x0000763256037816ULL, 0x000fca000000003eULL,
0x0000000238007388ULL, 0x0003e40000000a00ULL, 0x0000541042027816ULL, 0x142fe40000000046ULL,
0x0000763242037816ULL, 0x000fca0000000046ULL, 0x0004000208007388ULL, 0x0003e80000000a00ULL,
0x0004002434007388ULL, 0x000fe20000000a00ULL, 0x000054102a027816ULL, 0x142fe40000000026ULL,
0x000076322a037816ULL, 0x000fca0000000026ULL, 0x0004000236007388ULL, 0x0003e40000000a00ULL,
0x000054100c027816ULL, 0x142fe40000000006ULL, 0x000076320c037816ULL, 0x000fe40000000006ULL,
0x000054100e067816ULL, 0x140fe40000000007ULL, 0x000076320e077816ULL, 0x000fe20000000007ULL,
0x000000023a007388ULL, 0x0003e20000000a00ULL, 0x00005410160c7816ULL, 0x000fc4000000001aULL,
0x0000541014027816ULL, 0x142fe4000000000aULL, 0x0000763214037816ULL, 0x000fca000000000aULL,
0x0008000208007388ULL, 0x0003e40000000a00ULL, 0x000054101c027816ULL, 0x142fe40000000020ULL,
0x000076321c037816ULL, 0x000fe40000000020ULL, 0x000054101e207816ULL, 0x000fc6000000000fULL,
0x0008000234007388ULL, 0x0003e40000000a00ULL, 0x0000541030027816ULL, 0x142fe40000000018ULL,
0x0000763230037816ULL, 0x000fca0000000018ULL, 0x0008000236007388ULL, 0x0003e80000000a00ULL,
0x000000063c007388ULL, 0x000fe80000000a00ULL, 0x000c000c08007388ULL, 0x000fe20000000a00ULL,
0x000000015b027824ULL, 0x002fc600078e0200ULL, 0x000c002034007388ULL, 0x000fe20000000a00ULL,
0x0000001002027824ULL, 0x000fc600078e0209ULL, 0x000c002836007388ULL, 0x000fe20000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x0000000002047984ULL, 0x000e680000000c00ULL,
0x0004000002107984ULL, 0x000ea80000000c00ULL, 0x0008000002187984ULL, 0x000ee80000000c00ULL,
0x000c000002207984ULL, 0x000f680000000c00ULL, 0x00100000020c7984ULL, 0x000ee80000000c00ULL,
0x0014000002147984ULL, 0x000f680000000c00ULL, 0x00180000021c7984ULL, 0x000f680000000c00ULL,
0x001c000002247984ULL, 0x000f620000000c00ULL, 0x200000ff07077230ULL, 0x002fc40000000000ULL,
0x200000ff06067230ULL, 0x000fe40000000000ULL, 0x200000ff05057230ULL, 0x000fe40000000000ULL,
0x200000ff04047230ULL, 0x000fe40000000000ULL, 0x200000ff13137230ULL, 0x004fe40000000000ULL,
0x200000ff12127230ULL, 0x000fe40000000000ULL, 0x200000ff11117230ULL, 0x000fc40000000000ULL,
0x200000ff10107230ULL, 0x000fe40000000000ULL, 0x200000ff1b1b7230ULL, 0x008fe40000000000ULL,
0x200000ff1a1a7230ULL, 0x000fe40000000000ULL, 0x200000ff19197230ULL, 0x000fe40000000000ULL,
0x200000ff18187230ULL, 0x000fe40000000000ULL, 0x200000ff23237230ULL, 0x020fc40000000000ULL,
0x200000ff22227230ULL, 0x000fe40000000000ULL, 0x200000ff21217230ULL, 0x000fe40000000000ULL,
0x200000ff20207230ULL, 0x000fe40000000000ULL, 0x0000000f07077230ULL, 0x000fe40000000000ULL,
0x0000000e06067230ULL, 0x000fe40000000000ULL, 0x0000000d05057230ULL, 0x000fc40000000000ULL,
0x0000000c04047230ULL, 0x000fe40000000000ULL, 0x0000001713137230ULL, 0x000fe40000000000ULL,
0x0000001612127230ULL, 0x000fe20000000000ULL, 0x0000000402007388ULL, 0x0003e20000000c00ULL,
0x0000001511117230ULL, 0x000fe40000000000ULL, 0x0000001410107230ULL, 0x000fe40000000000ULL,
0x0000001f1b1b7230ULL, 0x000fc40000000000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000000000ULL,
0x0004001002007388ULL, 0x0003e20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000000000ULL,
0x0000001c18187230ULL, 0x000fe40000000000ULL, 0x0000002723237230ULL, 0x000fe40000000000ULL,
0x0000002622227230ULL, 0x000fe20000000000ULL, 0x0008001802007388ULL, 0x0003e20000000c00ULL,
0x0000002521217230ULL, 0x000fc40000000000ULL, 0x0000002420207230ULL, 0x000fca0000000000ULL,
0x000c002002007388ULL, 0x0003e20000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000000000479c3ULL, 0x000ea20000002700ULL,
0x00000003ff047819ULL, 0x002fe20000011600ULL, 0x0000840000057ab9ULL, 0x000fc60000000800ULL,
0x000000750400720cULL, 0x000fe20003f06070ULL, 0x00000005040472a4ULL, 0x004fd8000f8e023fULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000104027824ULL, 0x000fe200078e0200ULL,
0x00008600000a7ab9ULL, 0x000fe20000000800ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x0000880000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000a05057299ULL, 0x000fe2000800063fULL,
0x0000000702037812ULL, 0x000fe200078ec0ffULL, 0x0000002000067836ULL, 0x000fc60000000000ULL,
0x0ffffff803027812ULL, 0x000fca00078ef800ULL, 0x0000001002037824ULL, 0x000fe400078e0209ULL,
0x0000002077027824ULL, 0x000fc600078e0204ULL, 0x00000000030c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff047c19ULL, 0x000fe20008011602ULL,
0x000000040b027c24ULL, 0x000fe4000f8e02ffULL, 0x0000000176057824ULL, 0x000fe200078e0205ULL,
0x0000000700037812ULL, 0x002fc600078ec0ffULL, 0x0000000b04057224ULL, 0x000fe400078e0205ULL,
0x0000000878037824ULL, 0x000fc600078e0203ULL, 0x0000000502057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff087224ULL, 0x000fe200000e06ffULL, 0x0000000805047c11ULL, 0x000fc8000f8040ffULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x00000003ff087819ULL, 0x000fe20000011606ULL,
0x0000001003047825ULL, 0x000fc600078e0004ULL, 0x000000750800720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106037824ULL, 0x140fe200078e0208ULL, 0x0000000706077812ULL, 0x000fe200078ec0ffULL,
0x0000002077087824ULL, 0x000fc600078e0208ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000000878077824ULL, 0x000fe200078e0207ULL, 0x0000000508057c12ULL, 0x002fe4000f8e30ffULL,
0x0ffffff803047812ULL, 0x000fe400078ef806ULL, 0x0000000aff087c19ULL, 0x000fe20008011608ULL,
0x0000000176057824ULL, 0x000fe400078e0205ULL, 0x0000001004037824ULL, 0x000fe400078e0209ULL,
0x0000000b08057224ULL, 0x000fc600078e0205ULL, 0x00000000030c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fe2000f8040ffULL, 0x0000004000037836ULL, 0x002fc60000000000ULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x00000003ff067819ULL, 0x000fe20000011603ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x000000750600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000103047824ULL, 0x102fe400078e0206ULL, 0x0000002077067824ULL, 0x000fc600078e0206ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff804047812ULL, 0x000fe400078ef803ULL, 0x0000000aff067c19ULL, 0x000fe20008011606ULL,
0x0000000176057824ULL, 0x000fe200078e0205ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000001004077824ULL, 0x000fe400078e0209ULL, 0x0000000b06057224ULL, 0x000fc400078e0205ULL,
0x0000000878037824ULL, 0x000fe200078e0203ULL, 0x00000000070c7984ULL, 0x000e640000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe200080f4406ULL,
0x0000006000067836ULL, 0x000fe40000000000ULL, 0x0000001003047825ULL, 0x000fc600078e0004ULL,
0x00000003ff087819ULL, 0x000fc80000011606ULL, 0x000000750800720cULL, 0x000fe20003f06070ULL,
0x0000000c04007986ULL, 0x0023d8000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106037824ULL, 0x140fe200078e0208ULL, 0x0000000706077812ULL, 0x000fe200078ec0ffULL,
0x0000002077087824ULL, 0x000fc600078e0208ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000000878077824ULL, 0x000fe200078e0207ULL, 0x0000000508057c12ULL, 0x002fe4000f8e30ffULL,
0x0ffffff803047812ULL, 0x000fe400078ef806ULL, 0x0000000aff087c19ULL, 0x000fe20008011608ULL,
0x0000000176057824ULL, 0x000fe400078e0205ULL, 0x0000001004037824ULL, 0x000fe400078e0209ULL,
0x0000000b08057224ULL, 0x000fc600078e0205ULL, 0x00000000030c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fe2000f8040ffULL, 0x0000008000037836ULL, 0x002fc60000000000ULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x00000003ff067819ULL, 0x000fe20000011603ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x000000750600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000103047824ULL, 0x102fe400078e0206ULL, 0x0000002077067824ULL, 0x000fc600078e0206ULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x0000000506057c12ULL, 0x000fe4000f8e30ffULL,
0x0ffffff804047812ULL, 0x000fe400078ef803ULL, 0x0000000aff067c19ULL, 0x000fe20008011606ULL,
0x0000000176057824ULL, 0x000fe200078e0205ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000001004077824ULL, 0x000fe400078e0209ULL, 0x0000000b06057224ULL, 0x000fc400078e0205ULL,
0x0000000878037824ULL, 0x000fe200078e0203ULL, 0x00000000070c7984ULL, 0x000e640000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff067224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fc8000f8040ffULL, 0x0000000905057c11ULL, 0x000fe200080f4406ULL,
0x000000a000067836ULL, 0x000fe40000000000ULL, 0x0000001003047825ULL, 0x000fc600078e0004ULL,
0x00000003ff087819ULL, 0x000fc80000011606ULL, 0x000000750800720cULL, 0x000fe20003f06070ULL,
0x0000000c04007986ULL, 0x0023d8000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000106037824ULL, 0x140fe200078e0208ULL, 0x0000000706077812ULL, 0x000fe200078ec0ffULL,
0x0000002077087824ULL, 0x000fc600078e0208ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000000878077824ULL, 0x000fe200078e0207ULL, 0x0000000508057c12ULL, 0x002fe4000f8e30ffULL,
0x0ffffff803047812ULL, 0x000fe400078ef806ULL, 0x0000000aff087c19ULL, 0x000fe20008011608ULL,
0x0000000176057824ULL, 0x000fe400078e0205ULL, 0x0000001004037824ULL, 0x000fe400078e0209ULL,
0x0000000b08057224ULL, 0x000fc600078e0205ULL, 0x00000000030c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fe2000f8040ffULL, 0x000000c000037836ULL, 0x002fc60000000000ULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x00000003ff067819ULL, 0x000fe20000011603ULL,
0x0000001007047825ULL, 0x000fc600078e0004ULL, 0x000000750600720cULL, 0x000fe40003f06070ULL,
0x0000000c04007986ULL, 0x0043f6000c101d06ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000103047824ULL, 0x102fe400078e0206ULL, 0x0000002077067824ULL, 0x000fe400078e0206ULL,
0x000000e000007836ULL, 0x000fe20000000000ULL, 0x0000000704047812ULL, 0x000fe400078ec0ffULL,
0x0000000506057c12ULL, 0x000fe4000f8e30ffULL, 0x0ffffff804047812ULL, 0x000fe400078ef803ULL,
0x0000000aff067c19ULL, 0x000fe20008011606ULL, 0x0000000176057824ULL, 0x000fe200078e0205ULL,
0x0000000703037812ULL, 0x000fe200078ec0ffULL, 0x0000001004077824ULL, 0x000fc400078e0209ULL,
0x0000000b06057224ULL, 0x000fe200078e0205ULL, 0x00000003ff067819ULL, 0x000fe20000011600ULL,
0x0000000878037824ULL, 0x000fe200078e0203ULL, 0x00000000070c7984ULL, 0x0002a40000000c00ULL,
0x0000000502057210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff087224ULL, 0x000fe200000e06ffULL,
0x0000000805047c11ULL, 0x000fe2000f8040ffULL, 0x0000000100077824ULL, 0x002fc600078e0206ULL,
0x0000000905057c11ULL, 0x000fe400080f4408ULL, 0x000000750600720cULL, 0x000fe40003f06070ULL,
0x0000000707077812ULL, 0x000fe200078ec0ffULL, 0x0000001003047825ULL, 0x000fc600078e0004ULL,
0xfffffff807087812ULL, 0x000fe400078ef800ULL, 0x0000000c04007986ULL, 0x0043ea000c101d06ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000001008087824ULL, 0x000fe200078e0209ULL,
0x0000000700057812ULL, 0x002fe200078ec0ffULL, 0x0000002077067824ULL, 0x000fc600078e0206ULL,
0x00000000080c7984ULL, 0x000e620000000c00ULL, 0x0000000878057824ULL, 0x000fe200078e0205ULL,
0x0000000506037c12ULL, 0x000fe4000f8e30ffULL, 0x0000000aff067c19ULL, 0x000fc60008011606ULL,
0x0000000176037824ULL, 0x000fc800078e0203ULL, 0x0000000b06037224ULL, 0x000fca00078e0203ULL,
0x0000000302037210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff047224ULL, 0x000fe200000e06ffULL,
0x0000000803027c11ULL, 0x000fc8000f8040ffULL, 0x0000000903037c11ULL, 0x000fc600080f4404ULL,
0x0000001005027825ULL, 0x000fca00078e0002ULL, 0x0000000c02007986ULL, 0x002fe2000c101d06ULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff7a7819ULL, 0x000fe20000011678ULL,
0x00009800ff5e7b82ULL, 0x000e620000000a00ULL, 0xffffffffff0f7424ULL, 0x000fe400078e00ffULL,
0x000000637a00720cULL, 0x000fda0003f06070ULL, 0x00009400ff068b82ULL, 0x000ea20000000800ULL,
0x0000000205078824ULL, 0x000fce00078e00ffULL, 0x00009000ff0c8b82ULL, 0x000ee20000000a00ULL,
0x000000065e5e7981ULL, 0x002322000c1e9900ULL, 0x0000000607078224ULL, 0x004fe400078e027aULL,
0x00000001ff067424ULL, 0x000fe400078e00ffULL, 0x00000004070c8825ULL, 0x008fc800078e000cULL,
0x01a60006090679a7ULL, 0x000262000850003fULL, 0x000000060c0f8981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0200780cULL, 0x000fe20003f04070ULL, 0x0000008003027824ULL, 0x000fe400078e00ffULL,
0x0000008059037824ULL, 0x000fe400078e00ffULL, 0x0000004078777824ULL, 0x000fca00078e00ffULL,
0x00000040030b7812ULL, 0x000fe200078ef877ULL, 0x0000000f02367224ULL, 0x004fe400078e02ffULL,
0x0000000c002c0947ULL, 0x002fea0003800000ULL, 0x00008e00ff0e7b82ULL, 0x000e620000000a00ULL,
0x00000003ff2c7819ULL, 0x000fca000001160aULL, 0x000000082c167836ULL, 0x000fe40000000000ULL,
0x000000042c127836ULL, 0x000fe40000000000ULL, 0x00000001160d7824ULL, 0x040fe400078e020aULL,
0x0000000816107824ULL, 0x000fe400078e00ffULL, 0x000000010b0c7824ULL, 0x000fe400078e022cULL,
0x0000000112087824ULL, 0x040fe200078e020aULL, 0xfffffff810257812ULL, 0x000fe200078ee20dULL,
0x0000000812217824ULL, 0x000fe200078e00ffULL, 0x0000007774107248ULL, 0x000fe20007fe0000ULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff821217812ULL, 0x000fe200078ee208ULL,
0x0000000c2c1a7836ULL, 0x000fe20000000000ULL, 0x0000000e360e7211ULL, 0x002fe200078038ffULL,
0x000000102c147836ULL, 0x000fe20000000000ULL, 0x000000700c197812ULL, 0x000fe200078ef804ULL,
0x000000081a1c7824ULL, 0x000fe200078e00ffULL, 0x0000000f36087211ULL, 0x000fe200000f3cffULL,
0x000000011a0f7824ULL, 0x100fe200078e020aULL, 0x000000190e187210ULL, 0x000fe20007f1e0ffULL,
0x00000001140c7824ULL, 0x040fe400078e020aULL, 0x0000000814297824ULL, 0x000fe200078e00ffULL,
0xfffffff81c277812ULL, 0x000fe200078ee20fULL, 0x00000001100f7824ULL, 0x000fc400078e0a77ULL,
0x000000010b107824ULL, 0x040fe200078e0216ULL, 0xfffffff829297812ULL, 0x000fe200078ee20cULL,
0x000000010b0c7824ULL, 0x000fe200078e0212ULL, 0x0000000f1200720cULL, 0x080fe20003fa6070ULL,
0x000000010d197824ULL, 0x000fe200000e0608ULL, 0x0000000f1600720cULL, 0x080fe20003f26070ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000000f1400720cULL, 0x080fe40003f06070ULL,
0x0000000f1a00720cULL, 0x000fe20003f46070ULL, 0x000000010b127824ULL, 0x000fe200078e021aULL,
0x000000700c1b7812ULL, 0x000fe200078ef804ULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x0000000e1b1a7210ULL, 0x000fe20007f7e0ffULL, 0x000000142c207836ULL, 0x000fe20000000000ULL,
0x00000070101d7812ULL, 0x000fe200078ef804ULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0x0000000e1d1c7210ULL, 0x000fe20007f9e0ffULL, 0x000000010b147824ULL, 0x040fe200078e0214ULL,
0x00000070121f7812ULL, 0x000fe200078ef804ULL, 0x000000010b167824ULL, 0x000fe400078e0220ULL,
0x0000008014147825ULL, 0x000fc800078e00ffULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x000000010d1b7824ULL, 0x100fe200018e0608ULL, 0x0000000e1f1e7210ULL, 0x000fe20007f7e0ffULL,
0x00000001111d7824ULL, 0x100fe200020e0608ULL, 0x0000007014117812ULL, 0x000fe200078ef804ULL,
0x000000182c147836ULL, 0x000fe20000000000ULL, 0x00000070160d7812ULL, 0x000fe200078ef804ULL,
0x00000001131f7824ULL, 0x000fe200018e0608ULL, 0x0000000e11107210ULL, 0x000fe20007f7e0ffULL,
0x00004000780c7824ULL, 0x000fe200078e0209ULL, 0x0000000e0d127210ULL, 0x000fe20007f9e0ffULL,
0x000000010b0d7824ULL, 0x000fc400078e0214ULL, 0x000020000c227836ULL, 0x000fe40000000000ULL,
0x0000000115117824ULL, 0x000fe200018e0608ULL, 0x0000000f2000720cULL, 0x000fe20003f66070ULL,
0x000000800d0c7825ULL, 0x000fc800078e00ffULL, 0x000000012c157824ULL, 0x000fe400078e020aULL,
0x0000000117137824ULL, 0x000fe200020e0608ULL, 0x000000700c177812ULL, 0x000fe200078ef804ULL,
0x0000001c2c247836ULL, 0x000fe20000000000ULL, 0x0000000715157812ULL, 0x000fe200078ec0ffULL,
0x00000001200c7824ULL, 0x040fe200078e020aULL, 0x0000000e17167210ULL, 0x000fe20007fde0ffULL,
0x00000008202b7824ULL, 0x000fe200078e00ffULL, 0x0000000f2c00720cULL, 0x000fe20003f86070ULL,
0x000000202c267836ULL, 0x000fe20000000000ULL, 0x0ffffff815237812ULL, 0x000fe200078ef80aULL,
0x000000010b157824ULL, 0x000fe200078e0224ULL, 0xfffffff82b2b7812ULL, 0x000fe200078ee20cULL,
0x000000010d177824ULL, 0x000fc400030e0608ULL, 0x00000080150c7825ULL, 0x000fc800078e00ffULL,
0x0000001023237824ULL, 0x000fe200078e0222ULL, 0x000000700c2d7812ULL, 0x000fe200078ef804ULL,
0x000000010b157824ULL, 0x000fe400078e0226ULL, 0x000000242c287836ULL, 0x000fe20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000018237faeULL, 0x0003e2000e101c46ULL,
0x0000000f1400720cULL, 0x040fe20003f86070ULL, 0x00000001140c7824ULL, 0x040fe200078e020aULL,
0x0000000e2d207210ULL, 0x000fe20007fde0ffULL, 0x00000008142f7824ULL, 0x000fe400078e00ffULL,
0x0000008015147825ULL, 0x000fc600078e00ffULL, 0xfffffff82f2d7812ULL, 0x000fe200078ee20cULL,
0x000000010b2a7824ULL, 0x000fe400078e0228ULL, 0x0000001021237824ULL, 0x002fe200078e0222ULL,
0x0000007014197812ULL, 0x000fe200078ef804ULL, 0x000000010d217824ULL, 0x000fe400030e0608ULL,
0x000000802a0c7825ULL, 0x000fe200078e00ffULL, 0x0000000e19147210ULL, 0x000fe20007fde0ffULL,
0x000000001a237faeULL, 0x0003e2000e901c46ULL, 0x0000000f2400720cULL, 0x040fe20003fa6070ULL,
0x0000000124197824ULL, 0x040fe200078e020aULL, 0x000000700c2f7812ULL, 0x000fe200078ef804ULL,
0x00000008240c7824ULL, 0x000fc400078e00ffULL, 0x000000282c247836ULL, 0x000fe40000000000ULL,
0x0000000115157824ULL, 0x000fe200030e0608ULL, 0x0000000e2f187210ULL, 0x000fe20007fde0ffULL,
0x0000000826317824ULL, 0x000fe200078e00ffULL, 0xfffffff80c2f7812ULL, 0x000fe200078ee219ULL,
0x000000010b0c7824ULL, 0x000fe400078e0224ULL, 0x000000010d197824ULL, 0x000fe400030e0608ULL,
0x000000800c0c7825ULL, 0x000fc800078e00ffULL, 0x00000001261a7824ULL, 0x042fe200078e020aULL,
0x000000700c1b7812ULL, 0x000fe200078ef804ULL, 0x0000001025257824ULL, 0x100fe400078e0222ULL,
0x0000001027277824ULL, 0x100fe200078e0222ULL, 0x0000000e1b0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001029297824ULL, 0x100fe200078e0222ULL, 0xfffffff8311b7812ULL, 0x000fe200078ee21aULL,
0x0000002c2c1a7836ULL, 0x000fe20000000000ULL, 0x000000001c257faeULL, 0x0003e2000c901c46ULL,
0x0000000f2600720cULL, 0x000fe20003f26070ULL, 0x000000102b2b7824ULL, 0x000fc400078e0222ULL,
0x000000001e277faeULL, 0x0005e2000d101c46ULL, 0x000000102d2d7824ULL, 0x100fe200078e0222ULL,
0x0000000f2800720cULL, 0x0c0fe20003f46070ULL, 0x000000102f2f7824ULL, 0x000fe200078e0222ULL,
0x0000000010297faeULL, 0x0007e2000c101c46ULL, 0x0000000128237824ULL, 0x040fe400078e020aULL,
0x000000101b1b7824ULL, 0x000fe200078e0222ULL, 0x00000000122b7faeULL, 0x000be2000d901c46ULL,
0x000000010b1c7824ULL, 0x002fe400078e021aULL, 0x0000000828287824ULL, 0x000fe200078e00ffULL,
0x00000000162d7faeULL, 0x000fe2000e101c46ULL, 0x000000302c1e7836ULL, 0x004fe20000000000ULL,
0x0000000f1a00720cULL, 0x000fe20003f86070ULL, 0x000000010d0d7824ULL, 0x000fe200030e0608ULL,
0x00000000202f7faeULL, 0x000fe2000e901c46ULL, 0x000000801c107825ULL, 0x008fe200078e00ffULL,
0xfffffff828237812ULL, 0x000fc400078ee223ULL, 0x00000000141b7faeULL, 0x0003e2000c901c46ULL,
0x000000342c1c7836ULL, 0x000fe20000000000ULL, 0x0000007010137812ULL, 0x020fe200078ef804ULL,
0x000000010b107824ULL, 0x000fe200078e021eULL, 0x0000000f2400720cULL, 0x080fe20003fa6070ULL,
0x0000001023237824ULL, 0x000fe200078e0222ULL, 0x0000000f1e00720cULL, 0x0c0fe20003f66070ULL,
0x000000010b127824ULL, 0x000fe400078e021cULL, 0x000000081e1d7824ULL, 0x000fe200078e00ffULL,
0x0000000018237faeULL, 0x0005e2000d101c46ULL, 0x000000382c267836ULL, 0x000fe20000000000ULL,
0x0000000e13147210ULL, 0x002fe20007fde0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000000f1c00720cULL, 0x000fc40003f46070ULL, 0x0000000f2600720cULL, 0x000fe20003f26070ULL,
0x0000000111157824ULL, 0x000fe400030e0608ULL, 0x0000008010107825ULL, 0x000fc800078e00ffULL,
0x000000011a177824ULL, 0x100fe200078e020aULL, 0x0000007010197812ULL, 0x004fe200078ef804ULL,
0x000000011e107824ULL, 0x000fe400078e020aULL, 0x000000081a1a7824ULL, 0x000fe200078e00ffULL,
0x0000000e19167210ULL, 0x000fe20007fde0ffULL, 0x0000003c2c287836ULL, 0x000fe20000000000ULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee210ULL, 0x000000010b107824ULL, 0x000fe200078e0226ULL,
0x0000007012197812ULL, 0x000fe200078ef804ULL, 0x000000011c127824ULL, 0x040fe200078e020aULL,
0xfffffff81a1b7812ULL, 0x000fe200078ee217ULL, 0x0000000111177824ULL, 0x000fe200030e0608ULL,
0x0000000e19187210ULL, 0x000fe20007fde0ffULL, 0x000000081c1f7824ULL, 0x000fe200078e00ffULL,
0x0000000f2800720cULL, 0x000fe20003f06070ULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee212ULL, 0x000000010b1a7824ULL, 0x000fe200078e0228ULL,
0x0000007010217812ULL, 0x000fe200078ef804ULL, 0x00000001240f7824ULL, 0x040fe400078e020aULL,
0x0000000824247824ULL, 0x000fe400078e00ffULL, 0x0000000113197824ULL, 0x000fe400030e0608ULL,
0x000000801a127825ULL, 0x000fe200078e00ffULL, 0xfffffff8240f7812ULL, 0x000fc600078ee20fULL,
0x00000001260b7824ULL, 0x140fe200078e020aULL, 0x0000007012257812ULL, 0x000fe200078ef804ULL,
0x0000000826267824ULL, 0x000fe400078e00ffULL, 0x0000000128107824ULL, 0x040fe200078e020aULL,
0x0000000e210a7210ULL, 0x000fe20007fde0ffULL, 0x0000000828237824ULL, 0x000fe200078e00ffULL,
0xfffffff826217812ULL, 0x000fe200078ee20bULL, 0x000000101b1b7824ULL, 0x000fe400078e0222ULL,
0x00000001110b7824ULL, 0x000fe200030e0608ULL, 0xfffffff823237812ULL, 0x000fe200078ee210ULL,
0x000000100f117824ULL, 0x100fe200078e0222ULL, 0x0000000e250e7210ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x000fc400078e0222ULL, 0x000000101f1f7824ULL, 0x100fe200078e0222ULL,
0x000000000c117faeULL, 0x0003e2000e901c46ULL, 0x0000001021217824ULL, 0x100fe400078e0222ULL,
0x0000001023237824ULL, 0x000fe200078e0222ULL, 0x00000000141b7faeULL, 0x0003e2000e101c46ULL,
0x00000001130f7824ULL, 0x000fc600030e0608ULL, 0x00000000161d7faeULL, 0x0003e8000d901c46ULL,
0x00000000181f7faeULL, 0x0003e8000d101c46ULL, 0x000000000a217faeULL, 0x0003e8000c901c46ULL,
0x000000000e237faeULL, 0x0003e2000c101c46ULL, 0x0000000800dc7947ULL, 0x000fea0003800000ULL,
0x000000080a127811ULL, 0x000fe200078fe8ffULL, 0x00004000782d7824ULL, 0x000fe200078e0209ULL,
0x0000000c0a147811ULL, 0x040fe400078fe8ffULL, 0x000000100a167811ULL, 0x000fe200078fe8ffULL,
0x00000001120c7824ULL, 0x100fe200078e020aULL, 0x000000180a1a7811ULL, 0x000fe200078fe8ffULL,
0x0000000812137824ULL, 0x000fe200078e00ffULL, 0x0000001c0a1c7811ULL, 0x000fe200078fe8ffULL,
0x00000001140d7824ULL, 0x100fe200078e020aULL, 0x000000200a1e7811ULL, 0x000fe200078fe8ffULL,
0x0000000814187824ULL, 0x000fe200078e00ffULL, 0xfffffff813137812ULL, 0x000fe200078ee20cULL,
0x00000001160e7824ULL, 0x100fe200078e020aULL, 0x000000040a107811ULL, 0x000fe200078fe8ffULL,
0x0000000816177824ULL, 0x000fe200078e00ffULL, 0xfffffff818157812ULL, 0x000fe200078ee20dULL,
0x000000011a0c7824ULL, 0x100fe200078e020aULL, 0x000000280a227811ULL, 0x000fe200078fe8ffULL,
0x000000081a1b7824ULL, 0x000fe200078e00ffULL, 0xfffffff817177812ULL, 0x000fe200078ee20eULL,
0x000000011c0d7824ULL, 0x100fe200078e020aULL, 0x0000002c0a247811ULL, 0x000fe200078fe8ffULL,
0x000000081c207824ULL, 0x000fe200078e00ffULL, 0x000000300a267811ULL, 0x000fe200078fe8ffULL,
0x000000011e0e7824ULL, 0x140fe200078e020aULL, 0xfffffff81b1b7812ULL, 0x000fe200078ee20cULL,
0x000000081e1f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8201d7812ULL, 0x000fe200078ee20dULL,
0x0000000110087824ULL, 0x100fe200078e020aULL, 0x000000140a187811ULL, 0x000fe200078fe8ffULL,
0x0000000810117824ULL, 0x000fe200078e00ffULL, 0xfffffff81f1f7812ULL, 0x000fe200078ee20eULL,
0x00000001220c7824ULL, 0x100fe200078e020aULL, 0x000000240a207811ULL, 0x000fe200078fe8ffULL,
0x0000000822237824ULL, 0x000fe200078e00ffULL, 0xfffffff811117812ULL, 0x000fe200078ee208ULL,
0x00000001240d7824ULL, 0x100fe200078e020aULL, 0x000000380a297811ULL, 0x000fe200078fe8ffULL,
0x0000000824287824ULL, 0x000fe200078e00ffULL, 0xfffffff823237812ULL, 0x000fe200078ee20cULL,
0x00000001260e7824ULL, 0x100fe200078e020aULL, 0x0000003c0a2b7811ULL, 0x000fe200078fe8ffULL,
0x0000000826277824ULL, 0x000fe200078e00ffULL, 0xfffffff828257812ULL, 0x000fe200078ee20dULL,
0x0000000118087824ULL, 0x040fe200078e020aULL, 0x00008e00ff0c7b82ULL, 0x000e620000000a00ULL,
0x0000000818197824ULL, 0x000fe200078e00ffULL, 0xfffffff827277812ULL, 0x000fe200078ee20eULL,
0x0000000820217824ULL, 0x000fe200078e00ffULL, 0x0000000a0a0e7211ULL, 0x000fe200078fe8ffULL,
0x000000010b2a7824ULL, 0x040fe200078e0222ULL, 0xfffffff819197812ULL, 0x000fe200078ee208ULL,
0x0000000120087824ULL, 0x000fe200078e020aULL, 0x000000070e0f7812ULL, 0x000fe200078ec0ffULL,
0x000000010b0e7824ULL, 0x040fe200078e0212ULL, 0x000000340a287811ULL, 0x040fe200078fe8ffULL,
0x000000010b127824ULL, 0x040fe200078e0216ULL, 0xfffffff821217812ULL, 0x000fe200078ee208ULL,
0x000000010b167824ULL, 0x040fe200078e021aULL, 0x0000000b0a087211ULL, 0x000fe200078fe8ffULL,
0x000000010b1a7824ULL, 0x040fe200078e021eULL, 0x0ffffff80f0f7812ULL, 0x000fe200078ef80aULL,
0x000000010b1e7824ULL, 0x000fc400078e0220ULL, 0x0000000128207824ULL, 0x100fe400078e020aULL,
0x0000000129227824ULL, 0x100fe400078e020aULL, 0x000000010b347824ULL, 0x000fe200078e022bULL,
0x0000000c364b7211ULL, 0x042fe200078038ffULL, 0x000000012b0a7824ULL, 0x040fe400078e020aULL,
0x000000082b2b7824ULL, 0x000fe200078e00ffULL, 0x0000000d364d7211ULL, 0x000fe200000f3cffULL,
0x000000010b2c7824ULL, 0x000fc400078e0224ULL, 0x000000010b107824ULL, 0x040fe200078e0210ULL,
0xfffffff82b247812ULL, 0x000fe200078ee20aULL, 0x000000010b147824ULL, 0x040fe400078e0214ULL,
0x000000010b187824ULL, 0x040fe400078e0218ULL, 0x000000010b1c7824ULL, 0x040fe400078e021cULL,
0x000000010b2e7824ULL, 0x040fe400078e0226ULL, 0x000000010b307824ULL, 0x000fc400078e0228ULL,
0x000000010b327824ULL, 0x000fe400078e0229ULL, 0x00000080080a7825ULL, 0x000fc800078e00ffULL,
0x000020002d267836ULL, 0x000fe20000000000ULL, 0x000000700a0a7812ULL, 0x000fe200078ef804ULL,
0x00000008282f7824ULL, 0x000fe400078e00ffULL, 0x000000100f2b7824ULL, 0x000fe200078e0226ULL,
0x0000000a4b0a7210ULL, 0x000fe20007f1e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff82f207812ULL, 0x000fc600078ee220ULL, 0x00000010132f7824ULL, 0x000fe200078e0226ULL,
0x000000700e0e7812ULL, 0x000fe200078ef804ULL, 0x0000000829297824ULL, 0x000fe400078e00ffULL,
0x0000008012127825ULL, 0x000fc600078e00ffULL, 0xfffffff829227812ULL, 0x000fe200078ee222ULL,
0x00000010112d7824ULL, 0x000fe400078e0226ULL, 0x00000080100c7825ULL, 0x000fc800078e00ffULL,
0x0000008014107825ULL, 0x000fe200078e00ffULL, 0x000000700c0c7812ULL, 0x000fc600078ef804ULL,
0x000000010b0b7824ULL, 0x000fe200000e064dULL, 0x0000000e4b0e7210ULL, 0x000fe20007f1e0ffULL,
0x0000001020457824ULL, 0x100fe200078e0226ULL, 0x0000007012207812ULL, 0x000fe200078ef804ULL,
0x0000001015317824ULL, 0x100fe200078e0226ULL, 0x0000007010107812ULL, 0x000fe200078ef804ULL,
0x0000001017337824ULL, 0x100fe200078e0226ULL, 0x0000000c4b0c7210ULL, 0x000fe20007f3e0ffULL,
0x0000008018147825ULL, 0x000fe200078e00ffULL, 0x000000104b107210ULL, 0x000fe20007f5e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a2b7faeULL, 0x0003e4000b901c46ULL,
0x0000001019357824ULL, 0x000fc400078e0226ULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x000000101b377824ULL, 0x000fe400078e0226ULL, 0x000000010f0f7824ULL, 0x000fe200000e064dULL,
0x000000204b207210ULL, 0x000fe20007f1e0ffULL, 0x000000801c187825ULL, 0x000fc800078e00ffULL,
0x000000801a1a7825ULL, 0x000fc800078e00ffULL, 0x0000001022477824ULL, 0x100fe200078e0226ULL,
0x0000007014227812ULL, 0x000fe200078ef804ULL, 0x0000001024497824ULL, 0x100fe200078e0226ULL,
0x0000007016247812ULL, 0x000fe200078ef804ULL, 0x000000101d397824ULL, 0x100fe200078e0226ULL,
0x000000701a287812ULL, 0x000fe200078ef804ULL, 0x000000101f3b7824ULL, 0x100fe400078e0226ULL,
0x00000010213d7824ULL, 0x100fe200078e0226ULL, 0x000000284b287210ULL, 0x000fe20007f7e0ffULL,
0x00000010233f7824ULL, 0x000fc400078e0226ULL, 0x0000001025417824ULL, 0x100fe400078e0226ULL,
0x0000001027437824ULL, 0x000fe200078e0226ULL, 0x0000007018267812ULL, 0x000fe200078ef804ULL,
0x0000000113217824ULL, 0x100fe200000e064dULL, 0x000000224b227210ULL, 0x000fe20007f1e0ffULL,
0x000000010d0d7824ULL, 0x100fe200008e064dULL, 0x000000244b247210ULL, 0x000fe20007f3e0ffULL,
0x0000000111117824ULL, 0x100fe200010e064dULL, 0x000000264b267210ULL, 0x000fe20007f5e0ffULL,
0x0000000115237824ULL, 0x000fe200000e064dULL, 0x000000000c2d7faeULL, 0x0003e2000b901c46ULL,
0x000000801e127825ULL, 0x000fc600078e00ffULL, 0x000000000e2f7faeULL, 0x0003e2000b901c46ULL,
0x0000000117257824ULL, 0x100fe200008e064dULL, 0x0000007012127812ULL, 0x000fe200078ef804ULL,
0x000000802a147825ULL, 0x000fe200078e00ffULL, 0x0000000010317faeULL, 0x0003e4000b901c46ULL,
0x000000124b127210ULL, 0x000fe20007f1e0ffULL, 0x0000000119277824ULL, 0x100fe200010e064dULL,
0x0000007014147812ULL, 0x000fe200078ef804ULL, 0x000000802c167825ULL, 0x000fe200078e00ffULL,
0x0000000020337faeULL, 0x0003e4000b901c46ULL, 0x000000144b147210ULL, 0x000fe20007f3e0ffULL,
0x000000011b297824ULL, 0x100fe200018e064dULL, 0x0000007016167812ULL, 0x000fe200078ef804ULL,
0x000000802e187825ULL, 0x000fe200078e00ffULL, 0x0000000022357faeULL, 0x0003e4000b901c46ULL,
0x000000164b167210ULL, 0x000fe20007f5e0ffULL, 0x00000080301a7825ULL, 0x000fe200078e00ffULL,
0x0000007018187812ULL, 0x000fe200078ef804ULL, 0x0000000024377faeULL, 0x0003e4000b901c46ULL,
0x00000080321c7825ULL, 0x000fe200078e00ffULL, 0x000000701a1a7812ULL, 0x000fe200078ef804ULL,
0x0000000026397faeULL, 0x0003e2000b901c46ULL, 0x000000184b187210ULL, 0x000fe20007f7e0ffULL,
0x00000080341e7825ULL, 0x000fe200078e00ffULL, 0x000000701c1c7812ULL, 0x000fe200078ef804ULL,
0x00000000283b7faeULL, 0x0003e2000b901c46ULL, 0x0000001a4b1a7210ULL, 0x000fe20007f9e0ffULL,
0x0000000113137824ULL, 0x100fe200000e064dULL, 0x000000701e047812ULL, 0x000fe200078ef804ULL,
0x0000000115157824ULL, 0x100fe200008e064dULL, 0x0000001c4b1c7210ULL, 0x000fe20007fbe0ffULL,
0x0000000117177824ULL, 0x100fe200010e064dULL, 0x000000044b1e7210ULL, 0x000fe20007fde0ffULL,
0x0000000119197824ULL, 0x100fe200018e064dULL, 0x00000000123d7faeULL, 0x0003e2000b901c46ULL,
0x000000011b1b7824ULL, 0x000fc400020e064dULL, 0x000000011d1d7824ULL, 0x100fe200028e064dULL,
0x00000000143f7faeULL, 0x0003e2000b901c46ULL, 0x000000011f1f7824ULL, 0x000fc600030e064dULL,
0x0000000016417faeULL, 0x0003e8000b901c46ULL, 0x0000000018437faeULL, 0x0003e8000b901c46ULL,
0x000000001a457faeULL, 0x0003e8000b901c46ULL, 0x000000001c477faeULL, 0x0003e8000b901c46ULL,
0x000000001e497faeULL, 0x0003e4000b901c46ULL, 0x000000027a7a7836ULL, 0x000fe20000000000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0xffffffffff797424ULL, 0x000fc600078e00ffULL,
0x000000637a00720cULL, 0x000fda0003f06070ULL, 0x00009400ff048b82ULL, 0x000ea20000000800ULL,
0x00000002050d8824ULL, 0x002fce00078e00ffULL, 0x00009000ff0a8b82ULL, 0x000e620000000a00ULL,
0x000000040d0d8224ULL, 0x004fc800078e027aULL, 0x000000040d0a8825ULL, 0x002fca00078e000aULL,
0x000000060a798981ULL, 0x000324000c1e1900ULL, 0x00000000000a7805ULL, 0x002fce0000015200ULL,
0x01a60007090075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x000000100800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000c7805ULL, 0x000fce0000015200ULL,
0x0000000c0a0f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010d0d7824ULL, 0x000fe200000e0e0bULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0d00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0d00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc8000001140dULL, 0x0000000f04047211ULL, 0x000fca00078110ffULL,
0x000000ffff0d7224ULL, 0x000fca00000e060dULL, 0x0000000204047819ULL, 0x000fc8000000120dULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000108087836ULL, 0x000fce0000000000ULL, 0x01a60007090075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x0000000000077919ULL, 0x000e640000000000ULL,
0x0000002078047824ULL, 0x002fc800078e0207ULL, 0x0000000104087836ULL, 0x000fe20000000000ULL,
0x00000004ff067819ULL, 0x000fc80000011604ULL, 0x0ffffffe06077812ULL, 0x000fe400078ec0ffULL,
0x0000001f04067812ULL, 0x000fc600078ec0ffULL, 0x00000001070b7824ULL, 0x000fe400078e0208ULL,
0x00000001040a7824ULL, 0x000fe400078e0207ULL, 0x00000010060c7824ULL, 0x040fe200078e00ffULL,
0x0000000f0b0b7812ULL, 0x000fe200078ec0ffULL, 0x00000010060d7824ULL, 0x000fe200078e00ffULL,
0x0000000f0a0a7812ULL, 0x000fe200078ec0ffULL, 0x0000000807077836ULL, 0x000fe20000000000ULL,
0x000001f00c0c7812ULL, 0x000fe200078ee20bULL, 0x00000010060b7824ULL, 0x000fe200078e00ffULL,
0x000001f00d0a7812ULL, 0x000fe200078ee20aULL, 0x0000000104047824ULL, 0x000fc400078e0207ULL,
0x000000100c0c7824ULL, 0x100fe400078e0209ULL, 0x000000100a0a7824ULL, 0x000fe200078e0209ULL,
0x0000000f04047812ULL, 0x000fe200078ec0ffULL, 0x0000000108077824ULL, 0x000fe200078e0207ULL,
0x000000000c107984ULL, 0x000e620000000c00ULL, 0x0000001006067824ULL, 0x000fe200078e00ffULL,
0x000001f00b047812ULL, 0x000fe400078ee204ULL, 0x000000000a147984ULL, 0x000ea20000000c00ULL,
0x0000000f07077812ULL, 0x000fc400078ec0ffULL, 0x0000001004047824ULL, 0x000fe400078e0209ULL,
0x000001f006067812ULL, 0x000fca00078ee207ULL, 0x0000001006067824ULL, 0x000fe400078e0209ULL,
0x000000ffff1a7224ULL, 0x002fe400078e0010ULL, 0x000000ffff1b7224ULL, 0x000fe400078e0012ULL,
0x000000ffff187224ULL, 0x004fe400078e0014ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff1e7224ULL, 0x000fc400078e0011ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0013ULL,
0x000000180a007388ULL, 0x000fe20000000c00ULL, 0x000000ffff1c7224ULL, 0x000fe400078e0015ULL,
0x000000ffff1d7224ULL, 0x000fca00078e0017ULL, 0x0000001c0c007388ULL, 0x0003e80000000c00ULL,
0x0000000006107984ULL, 0x000ea80000000c00ULL, 0x0000000004147984ULL, 0x000ee20000000c00ULL,
0x00000001ff0c7424ULL, 0x002fe400078e00ffULL, 0x000000ffff237224ULL, 0x004fc400078e0012ULL,
0x000000ffff227224ULL, 0x000fe400078e0010ULL, 0x000000ffff127224ULL, 0x000fe400078e0011ULL,
0x000000ffff207224ULL, 0x008fe400078e0014ULL, 0x000000ffff217224ULL, 0x000fe400078e0016ULL,
0x000000ffff107224ULL, 0x000fe400078e0015ULL, 0x000000ffff117224ULL, 0x000fe200078e0017ULL,
0x0000002004007388ULL, 0x0003e80000000c00ULL, 0x0000001006007388ULL, 0x0003e20000000c00ULL,
0x01a6000c090c79a7ULL, 0x0002a4000850003fULL, 0x0000000000067805ULL, 0x002fce0000015200ULL,
0x01a6000d090075a7ULL, 0x004e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff087224ULL, 0x000fce00078e00ffULL, 0x000000100800780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x00000000000a7805ULL, 0x000fce0000015200ULL,
0x0000000a060f7210ULL, 0x000fca0007f1e1ffULL, 0x000000010b0b7824ULL, 0x000fe200000e0e07ULL,
0x003d09000f00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c400f00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc8000001140bULL, 0x0000000f04047211ULL, 0x000fca00078110ffULL,
0x000000ffff0b7224ULL, 0x000fca00000e060bULL, 0x0000000204047819ULL, 0x000fc8000000120bULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x0000000108087836ULL, 0x000fce0000000000ULL, 0x01a6000d090075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000ff6100720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x00009400ff767b82ULL, 0x000e620000000800ULL,
0x00000000000b7919ULL, 0x000ea20000000000ULL, 0x0000840000097ab9ULL, 0x000fe20000000800ULL,
0x0000010077777836ULL, 0x000fe20000000000ULL, 0x0000001f09047890ULL, 0x000fe4000fffe03fULL,
0x80000009745f7c36ULL, 0x000fe40008000000ULL, 0x3db504f35e5e7820ULL, 0x010fe20000410000ULL,
0x0000000878087824ULL, 0x140fe200078e0209ULL, 0x000000043f047899ULL, 0x000fe20008011604ULL,
0x0000002078757824ULL, 0x000fe200078e0209ULL, 0x00000008ff5f7819ULL, 0x000fe2000001165fULL,
0x000000ffff727224ULL, 0x000fe200078e00ffULL, 0xffffffff09057890ULL, 0x000fe2000fffe03fULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x0000000909087890ULL, 0x000fc4000fffe03fULL,
0x0ffffffe04047892ULL, 0x000fe2000f8ec03fULL, 0x0000007605767224ULL, 0x002fd600078e02ffULL,
0x0000000272047836ULL, 0x000fe20000000000ULL, 0x000000010a5d7812ULL, 0x000fe200078e0cffULL,
0x0000010072597824ULL, 0x000fe400078e0277ULL, 0x0000007902797224ULL, 0x010fe200078e02ffULL,
0x000000610400720cULL, 0x000fe40003f06070ULL, 0x0000004059067812ULL, 0x000fca00078ec0ffULL,
0x0000000103067824ULL, 0x000fcc00078e0206ULL, 0x0000000c00388947ULL, 0x000fea0003800000ULL,
0x00008e00ff047b82ULL, 0x000e620000000a00ULL, 0x00000003ff247819ULL, 0x004fca000001160bULL,
0x00000004240e7836ULL, 0x000fe40000000000ULL, 0x0000000824127836ULL, 0x000fe40000000000ULL,
0x000000010e077824ULL, 0x140fe400078e020bULL, 0x000000080e0c7824ULL, 0x000fe400078e00ffULL,
0x00000001120d7824ULL, 0x040fe400078e020bULL, 0x0000000812107824ULL, 0x000fe200078e00ffULL,
0xfffffff80c217812ULL, 0x000fe200078ee207ULL, 0x00000001240c7824ULL, 0x000fc400078e0206ULL,
0x0000001024187836ULL, 0x000fe20000000000ULL, 0xfffffff810257812ULL, 0x000fe200078ee20dULL,
0x000000100b107824ULL, 0x000fe400078e00ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000000479077211ULL, 0x042fe400078038ffULL, 0x0000007010107812ULL, 0x000fe200078ec0ffULL,
0x0000000818297824ULL, 0x000fe200078e00ffULL, 0x0000005974047248ULL, 0x000fe20007fe0000ULL,
0x0000000c24147836ULL, 0x000fe20000000000ULL, 0x000000100c1c7212ULL, 0x000fe200078efcffULL,
0x00000001180c7824ULL, 0x000fe200078e020bULL, 0x0000000579057211ULL, 0x000fe200000f3cffULL,
0x0000000104117824ULL, 0x000fe200078e0a59ULL, 0x0000001c071c7210ULL, 0x000fe20007f1e0ffULL,
0x00000001140f7824ULL, 0x040fe200078e020bULL, 0xfffffff829297812ULL, 0x000fe200078ee20cULL,
0x0000000814167824ULL, 0x000fe200078e00ffULL, 0x000000110e00720cULL, 0x0c0fe20003fa6070ULL,
0x000000010e0c7824ULL, 0x100fe200078e0206ULL, 0x000000111200720cULL, 0x0c0fe20003f26070ULL,
0x00000001120e7824ULL, 0x000fe200078e0206ULL, 0xfffffff816277812ULL, 0x000fe200078ee20fULL,
0x000000010d1d7824ULL, 0x000fe200000e0605ULL, 0x000000111800720cULL, 0x080fe20003f06070ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000111400720cULL, 0x000fc60003f46070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000100c1e7212ULL, 0x000fc600078efcffULL,
0x0000000114127824ULL, 0x100fe200078e0206ULL, 0x000000100e147212ULL, 0x000fe200078efcffULL,
0x0000000118187824ULL, 0x000fe200078e0206ULL, 0x000000071e1e7210ULL, 0x000fe20007f7e0ffULL,
0x0000001424207836ULL, 0x000fe20000000000ULL, 0x0000000714147210ULL, 0x000fe20007f9e0ffULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x0000008018187825ULL, 0x000fe200078e00ffULL,
0x0000001012167212ULL, 0x000fc600078efcffULL, 0x00000001201a7824ULL, 0x000fe200078e0206ULL,
0x00000010180c7212ULL, 0x000fe200078efcffULL, 0x0000001824267836ULL, 0x000fe40000000000ULL,
0x000000801a1a7825ULL, 0x000fc800078e00ffULL, 0x000000010d1f7824ULL, 0x100fe200018e0605ULL,
0x0000000716167210ULL, 0x000fe20007f7e0ffULL, 0x000000010f157824ULL, 0x000fe200020e0605ULL,
0x000000070c0c7210ULL, 0x000fe20007f9e0ffULL, 0x0000400078047824ULL, 0x000fe200078e0209ULL,
0x000000101a0e7212ULL, 0x000fe200078efcffULL, 0x0000000126127824ULL, 0x000fe400078e0206ULL,
0x0000000113177824ULL, 0x100fe200018e0605ULL, 0x000000070e0e7210ULL, 0x000fe20007f7e0ffULL,
0x00000001190d7824ULL, 0x000fe200020e0605ULL, 0x000000112400720cULL, 0x000fe20003f86070ULL,
0x000020005d187824ULL, 0x000fc400078e0204ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x0000000124197824ULL, 0x000fe400078e020bULL, 0x0000200018227836ULL, 0x000fe20000000000ULL,
0x0000001012187212ULL, 0x000fe200078efcffULL, 0x000000011b0f7824ULL, 0x000fe200018e0605ULL,
0x00000007191a7812ULL, 0x000fe200078ec0ffULL, 0x0000001c242a7836ULL, 0x000fe20000000000ULL,
0x000000112000720cULL, 0x040fe20003f66070ULL, 0x0000000120197824ULL, 0x040fe200078e020bULL,
0x0000000718187210ULL, 0x000fe20007fde0ffULL, 0x0000000820207824ULL, 0x000fe200078e00ffULL,
0x0ffffff81a237812ULL, 0x000fe200078ef80bULL, 0x000000012a127824ULL, 0x000fc400078e0206ULL,
0x00000020242c7836ULL, 0x000fe20000000000ULL, 0xfffffff8202b7812ULL, 0x000fe200078ee219ULL,
0x0000000113197824ULL, 0x000fe400030e0605ULL, 0x0000008012127825ULL, 0x000fc800078e00ffULL,
0x000000012c1a7824ULL, 0x000fe200078e0206ULL, 0x0000001012207212ULL, 0x080fe200078efcffULL,
0x0000001023237824ULL, 0x000fe400078e0222ULL, 0x00000024242e7836ULL, 0x000fe20000000000ULL,
0x0000000720207210ULL, 0x000fe20007fde0ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000001c237faeULL, 0x0003e2000e101c46ULL,
0x000000112600720cULL, 0x000fe40003f86070ULL, 0x000000012e127824ULL, 0x000fe200078e0206ULL,
0x000000101a1a7212ULL, 0x000fe200078efcffULL, 0x0000000126287824ULL, 0x000fc400078e020bULL,
0x00000008262d7824ULL, 0x000fe400078e00ffULL, 0x0000001025257824ULL, 0x100fe400078e0222ULL,
0x0000002824267836ULL, 0x000fe20000000000ULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee228ULL,
0x0000001021237824ULL, 0x002fe400078e0222ULL, 0x0000000113217824ULL, 0x000fe200030e0605ULL,
0x000000071a1a7210ULL, 0x000fe20007fde0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000001e237faeULL, 0x0003e2000e901c46ULL, 0x000000112a00720cULL, 0x000fc40003fa6070ULL,
0x000000012a1d7824ULL, 0x000fe200078e020bULL, 0x00000010121c7212ULL, 0x000fe200078efcffULL,
0x000000082a2a7824ULL, 0x000fe200078e00ffULL, 0x0000000014257faeULL, 0x0005e2000c901c46ULL,
0x000000011b1b7824ULL, 0x000fe200030e0605ULL, 0x000000071c1c7210ULL, 0x000fe20007fde0ffULL,
0x0000000126127824ULL, 0x000fe200078e0206ULL, 0xfffffff82a2f7812ULL, 0x000fe200078ee21dULL,
0x0000003424287836ULL, 0x000fe20000000000ULL, 0x000000112c00720cULL, 0x000fe20003f26070ULL,
0x00000010271f7824ULL, 0x002fc400078e0222ULL, 0x00000001131d7824ULL, 0x000fe400030e0605ULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x00000000161f7faeULL, 0x0003e2000d101c46ULL,
0x000000112e00720cULL, 0x000fe40003f46070ULL, 0x0000001029157824ULL, 0x004fe200078e0222ULL,
0x0000001012127212ULL, 0x000fe200078efcffULL, 0x000000012c1e7824ULL, 0x140fe400078e020bULL,
0x000000082c277824ULL, 0x000fe200078e00ffULL, 0x000000000c157faeULL, 0x0005e2000c101c46ULL,
0x0000000712127210ULL, 0x000fe20007fde0ffULL, 0x000000012e237824ULL, 0x000fc400078e020bULL,
0x0000002c24167836ULL, 0x002fe20000000000ULL, 0xfffffff827257812ULL, 0x000fe200078ee21eULL,
0x000000082e2e7824ULL, 0x000fe400078e00ffULL, 0x0000000116147824ULL, 0x000fe400078e0206ULL,
0x00000030241e7836ULL, 0x000fe20000000000ULL, 0xfffffff82e277812ULL, 0x000fe200078ee223ULL,
0x00000080140c7825ULL, 0x004fc800078e00ffULL, 0x0000000113137824ULL, 0x100fe200030e0605ULL,
0x000000100c147212ULL, 0x000fe200078efcffULL, 0x000000102b177824ULL, 0x000fe400078e0222ULL,
0x000000011e0c7824ULL, 0x040fe200078e0206ULL, 0x0000000714147210ULL, 0x000fe20007fde0ffULL,
0x000000102d1f7824ULL, 0x100fe200078e0222ULL, 0x000000000e177faeULL, 0x0003e2000d901c46ULL,
0x000000102f237824ULL, 0x100fe200078e0222ULL, 0x000000111e00720cULL, 0x080fe20003f66070ULL,
0x0000001025257824ULL, 0x100fe200078e0222ULL, 0x00000000181f7faeULL, 0x0005e2000e101c46ULL,
0x000000010d157824ULL, 0x000fe200030e0605ULL, 0x000000111600720cULL, 0x080fe20003f86070ULL,
0x0000001027277824ULL, 0x000fe200078e0222ULL, 0x0000000020237faeULL, 0x000fe2000e901c46ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000112600720cULL, 0x000fc40003fa6070ULL,
0x000000001a257faeULL, 0x0007e2000c901c46ULL, 0x00000001280e7824ULL, 0x002fe400078e0206ULL,
0x0000000116177824ULL, 0x140fe200078e020bULL, 0x000000001c277faeULL, 0x0003e2000d101c46ULL,
0x0000000816187824ULL, 0x004fe200078e00ffULL, 0x000000100c167212ULL, 0x000fe200078efcffULL,
0x000000011e0c7824ULL, 0x000fe200078e020bULL, 0x000000112800720cULL, 0x000fe20003f46070ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x0000000716167210ULL, 0x000fc40007fde0ffULL,
0xfffffff8181b7812ULL, 0x008fe200078ee217ULL, 0x00000038242a7836ULL, 0x000fe20000000000ULL,
0x000000100e187212ULL, 0x000fe200078efcffULL, 0x0000003c24247836ULL, 0x000fe40000000000ULL,
0x000000081e1d7824ULL, 0x002fe200078e00ffULL, 0x000000112a00720cULL, 0x080fe20003f26070ULL,
0x0000000128197824ULL, 0x000fe200078e020bULL, 0x000000112400720cULL, 0x000fe20003f06070ULL,
0x000000010d177824ULL, 0x000fe200030e0605ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee20cULL,
0x000000012a0c7824ULL, 0x000fe200078e0206ULL, 0x0000000718187210ULL, 0x000fe20007fde0ffULL,
0x0000000828287824ULL, 0x000fc400078e00ffULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff8281f7812ULL, 0x000fe200078ee219ULL, 0x00000001240e7824ULL, 0x000fe200078e0206ULL,
0x000000100c0c7212ULL, 0x000fe200078efcffULL, 0x0000000126117824ULL, 0x040fe400078e020bULL,
0x0000000826267824ULL, 0x000fe400078e00ffULL, 0x000000010f197824ULL, 0x000fe200030e0605ULL,
0x000000070c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0xfffffff826117812ULL, 0x000fc600078ee211ULL, 0x000000012a1a7824ULL, 0x100fe200078e020bULL,
0x000000100e067212ULL, 0x000fe200078efcffULL, 0x000000082a217824ULL, 0x000fe400078e00ffULL,
0x00000001241c7824ULL, 0x040fe400078e020bULL, 0x0000000824237824ULL, 0x000fe200078e00ffULL,
0xfffffff821217812ULL, 0x000fe200078ee21aULL, 0x000000010d0d7824ULL, 0x000fe200030e0605ULL,
0x0000000706067210ULL, 0x000fe20007fde0ffULL, 0x0000001011117824ULL, 0x100fe200078e0222ULL,
0xfffffff823237812ULL, 0x000fe200078ee21cULL, 0x000000101b1b7824ULL, 0x000fc400078e0222ULL,
0x000000101d1d7824ULL, 0x100fe200078e0222ULL, 0x0000000012117faeULL, 0x0003e2000e901c46ULL,
0x000000101f1f7824ULL, 0x100fe400078e0222ULL, 0x0000001021217824ULL, 0x100fe200078e0222ULL,
0x00000000141b7faeULL, 0x0003e2000e101c46ULL, 0x0000001023237824ULL, 0x000fe400078e0222ULL,
0x000000010f077824ULL, 0x000fe200030e0605ULL, 0x00000000161d7faeULL, 0x0003e8000d901c46ULL,
0x00000000181f7faeULL, 0x0003e8000d101c46ULL, 0x000000000c217faeULL, 0x0003e8000c901c46ULL,
0x0000000006237faeULL, 0x0003e2000c101c46ULL, 0x0000000800e87947ULL, 0x000fea0003800000ULL,
0x000000080b0f7811ULL, 0x044fe400078fe8ffULL, 0x000000180b167811ULL, 0x040fe400078fe8ffULL,
0x000000280b1d7811ULL, 0x000fe200078fe8ffULL, 0x000000010f057824ULL, 0x100fe200078e020bULL,
0x000000140b147811ULL, 0x000fe200078fe8ffULL, 0x000000080f0c7824ULL, 0x000fe200078e00ffULL,
0x000000040b0e7811ULL, 0x040fe200078fe8ffULL, 0x0000000816357824ULL, 0x040fe200078e00ffULL,
0x000000100b127811ULL, 0x000fe200078fe8ffULL, 0x000000081d3d7824ULL, 0x000fe200078e00ffULL,
0xfffffff80c2d7812ULL, 0x000fe200078ee205ULL, 0x00000001160c7824ULL, 0x100fe200078e020bULL,
0x000000380b217811ULL, 0x040fe200078fe8ffULL, 0x0000000114077824ULL, 0x140fe200078e020bULL,
0x0000000c0b107811ULL, 0x000fe200078fe8ffULL, 0x00000008141a7824ULL, 0x000fe200078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee20cULL, 0x000000011d0c7824ULL, 0x100fe200078e020bULL,
0x000000240b1c7811ULL, 0x040fe200078fe8ffULL, 0x000000010e047824ULL, 0x140fe200078e020bULL,
0xfffffff81a337812ULL, 0x000fe200078ee207ULL, 0x000000080e2b7824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee20cULL, 0x0000000112057824ULL, 0x140fe200078e020bULL,
0x000000200b1a7811ULL, 0x000fe200078fe8ffULL, 0x0000000812187824ULL, 0x000fe200078e00ffULL,
0xfffffff82b2b7812ULL, 0x000fe200078ee204ULL, 0x00000001210c7824ULL, 0x100fe200078e020bULL,
0x000000300b1f7811ULL, 0x000fe200078fe8ffULL, 0x0000000821457824ULL, 0x000fe200078e00ffULL,
0xfffffff818317812ULL, 0x000fe200078ee205ULL, 0x0000000110047824ULL, 0x140fe200078e020bULL,
0x0000001c0b187811ULL, 0x040fe200078fe8ffULL, 0x00000008102f7824ULL, 0x000fe200078e00ffULL,
0xfffffff845457812ULL, 0x000fe200078ee20cULL, 0x000000011a057824ULL, 0x140fe200078e020bULL,
0x00008e00ff0c7b82ULL, 0x000e620000000a00ULL, 0x000000081a1e7824ULL, 0x000fe200078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee204ULL, 0x000000011c077824ULL, 0x140fe200078e020bULL,
0x0000003c0b117811ULL, 0x040fe200078fe8ffULL, 0x000000081c207824ULL, 0x000fe200078e00ffULL,
0xfffffff81e397812ULL, 0x000fe200078ee205ULL, 0x0000000118047824ULL, 0x140fe200078e020bULL,
0x0000002c0b1e7811ULL, 0x000fe200078fe8ffULL, 0x0000000818377824ULL, 0x000fe200078e00ffULL,
0xfffffff8203b7812ULL, 0x000fe200078ee207ULL, 0x000000011f057824ULL, 0x100fe200078e020bULL,
0x000000340b207811ULL, 0x000fe200078fe8ffULL, 0x000000081f227824ULL, 0x000fe200078e00ffULL,
0xfffffff837377812ULL, 0x000fe200078ee204ULL, 0x000000011e047824ULL, 0x000fc400078e020bULL,
0x000000081e3f7824ULL, 0x000fe200078e00ffULL, 0xfffffff822417812ULL, 0x000fe200078ee205ULL,
0x0000000120077824ULL, 0x040fe200078e020bULL, 0x0000000b0b057211ULL, 0x000fe200078fe8ffULL,
0x0000000820247824ULL, 0x000fe200078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe200078ee204ULL,
0x0000400078047824ULL, 0x000fe200078e0209ULL, 0x0000000c794b7211ULL, 0x002fe200078038ffULL,
0x000000010e0e7824ULL, 0x100fe200078e0206ULL, 0xfffffff824437812ULL, 0x000fe200078ee207ULL,
0x000000010f0f7824ULL, 0x100fe200078e0206ULL, 0x000000060b077211ULL, 0x000fe200078fe8ffULL,
0x0000000110107824ULL, 0x100fe200078e0206ULL, 0x0000000d79797211ULL, 0x000fe200000f3cffULL,
0x0000000112127824ULL, 0x000fc400078e0206ULL, 0x0000000114147824ULL, 0x100fe400078e0206ULL,
0x0000000116167824ULL, 0x100fe400078e0206ULL, 0x0000000118187824ULL, 0x100fe400078e0206ULL,
0x000000011a1a7824ULL, 0x100fe400078e0206ULL, 0x000000011c1c7824ULL, 0x100fe400078e0206ULL,
0x000000011d1d7824ULL, 0x000fc400078e0206ULL, 0x000000011e1e7824ULL, 0x100fe400078e0206ULL,
0x000000011f1f7824ULL, 0x100fe400078e0206ULL, 0x0000000120207824ULL, 0x100fe400078e0206ULL,
0x0000000121217824ULL, 0x100fe400078e0206ULL, 0x0000000111227824ULL, 0x000fe200078e0206ULL,
0x0000000705067812ULL, 0x000fe200078ec0ffULL, 0x0000000111157824ULL, 0x000fc400078e020bULL,
0x0000000811247824ULL, 0x000fe200078e00ffULL, 0x0ffffff806117812ULL, 0x000fe200078ef80bULL,
0x000020005d137824ULL, 0x000fe400078e0204ULL, 0x000000100b057824ULL, 0x000fe200078e00ffULL,
0xfffffff824157812ULL, 0x000fe200078ee215ULL, 0x0000200013247836ULL, 0x000fe40000000000ULL,
0x0000008007067825ULL, 0x000fe200078e00ffULL, 0x0000007005497812ULL, 0x000fc600078ec0ffULL,
0x0000001011057824ULL, 0x000fe200078e0224ULL, 0x0000004906067212ULL, 0x000fe200078efcffULL,
0x000000800e0c7825ULL, 0x000fc600078e00ffULL, 0x000000064b067210ULL, 0x000fe20007f1e0ffULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x000000490c0c7212ULL, 0x000fc600078efcffULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0x0000004910107212ULL, 0x080fe400078efcffULL,
0x0000000c4b0c7210ULL, 0x000fe20007f3e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x000000490e0e7212ULL, 0x000fe400078efcffULL, 0x000000104b107210ULL, 0x000fe20007f5e0ffULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x000000801a1a7825ULL, 0x000fe200078e00ffULL,
0x0000004918267212ULL, 0x000fc600078efcffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000491a287212ULL, 0x000fc600078efcffULL, 0x000000102b2b7824ULL, 0x100fe200078e0224ULL,
0x0000004912127212ULL, 0x000fe200078efcffULL, 0x000000102d2d7824ULL, 0x100fe200078e0224ULL,
0x000000284b287210ULL, 0x000fe20007f7e0ffULL, 0x000000102f2f7824ULL, 0x100fe400078e0224ULL,
0x0000001031317824ULL, 0x100fe400078e0224ULL, 0x0000001033337824ULL, 0x100fe400078e0224ULL,
0x0000001035357824ULL, 0x000fc400078e0224ULL, 0x0000001037377824ULL, 0x100fe400078e0224ULL,
0x0000001039397824ULL, 0x100fe400078e0224ULL, 0x000000103b3b7824ULL, 0x100fe400078e0224ULL,
0x000000103d3d7824ULL, 0x100fe400078e0224ULL, 0x000000103f3f7824ULL, 0x100fe400078e0224ULL,
0x0000001041417824ULL, 0x000fc400078e0224ULL, 0x0000001043437824ULL, 0x100fe400078e0224ULL,
0x0000001045457824ULL, 0x100fe400078e0224ULL, 0x0000001015477824ULL, 0x000fe200078e0224ULL,
0x0000004916247212ULL, 0x080fe200078efcffULL, 0x0000000107077824ULL, 0x100fe200000e0679ULL,
0x0000000e4b0e7210ULL, 0x000fe20007f1e0ffULL, 0x000000010d0d7824ULL, 0x100fe200008e0679ULL,
0x000000244b247210ULL, 0x000fe20007f3e0ffULL, 0x0000000111117824ULL, 0x100fe200010e0679ULL,
0x000000264b267210ULL, 0x000fe20007f5e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000006057faeULL, 0x0003e6000b901c46ULL,
0x000000010f0f7824ULL, 0x100fe200000e0679ULL, 0x000000124b127210ULL, 0x000fe20007f1e0ffULL,
0x0000000117257824ULL, 0x100fe200008e0679ULL, 0x0000004914147212ULL, 0x000fe200078efcffULL,
0x0000000119277824ULL, 0x000fe200010e0679ULL, 0x000000000c2b7faeULL, 0x0003e2000b901c46ULL,
0x000000801c167825ULL, 0x000fc600078e00ffULL, 0x000000000e2d7faeULL, 0x0003e2000b901c46ULL,
0x000000011b297824ULL, 0x100fe200018e0679ULL, 0x0000004916167212ULL, 0x080fe200078efcffULL,
0x000000801d187825ULL, 0x000fe200078e00ffULL, 0x00000000102f7faeULL, 0x0003e6000b901c46ULL,
0x0000000113137824ULL, 0x000fe200000e0679ULL, 0x000000144b147210ULL, 0x000fe20007f1e0ffULL,
0x000000801e1a7825ULL, 0x000fe200078e00ffULL, 0x0000004918187212ULL, 0x000fc400078efcffULL,
0x0000000012317faeULL, 0x0003e2000b901c46ULL, 0x000000801f1c7825ULL, 0x000fe200078e00ffULL,
0x000000491a1a7212ULL, 0x080fe400078efcffULL, 0x000000184b187210ULL, 0x000fe20007f3e0ffULL,
0x00000080201e7825ULL, 0x000fe200078e00ffULL, 0x000000491c1c7212ULL, 0x080fe400078efcffULL,
0x0000001a4b1a7210ULL, 0x000fe20007f5e0ffULL, 0x0000008021207825ULL, 0x000fe200078e00ffULL,
0x000000491e1e7212ULL, 0x000fc400078efcffULL, 0x0000001c4b1c7210ULL, 0x000fe20007f7e0ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000004920207212ULL, 0x080fe400078efcffULL,
0x0000001e4b1e7210ULL, 0x000fe20007f9e0ffULL, 0x0000000115157824ULL, 0x100fe200000e0679ULL,
0x000000164b167210ULL, 0x000fe20007f1e0ffULL, 0x0000000119197824ULL, 0x100fe200008e0679ULL,
0x0000004922227212ULL, 0x000fe200078efcffULL, 0x000000011b1b7824ULL, 0x100fe200010e0679ULL,
0x000000204b207210ULL, 0x000fe20007fbe0ffULL, 0x0000000117177824ULL, 0x100fe200000e0679ULL,
0x000000224b227210ULL, 0x000fe20007fde0ffULL, 0x0000000014337faeULL, 0x0003e2000b901c46ULL,
0x000000011d1d7824ULL, 0x000fc400018e0679ULL, 0x000000011f1f7824ULL, 0x100fe200020e0679ULL,
0x0000000024357faeULL, 0x0003e2000b901c46ULL, 0x0000000121217824ULL, 0x100fe400028e0679ULL,
0x0000000123237824ULL, 0x000fe200030e0679ULL, 0x0000000026377faeULL, 0x0003e8000b901c46ULL,
0x0000000028397faeULL, 0x0003e8000b901c46ULL, 0x00000000163b7faeULL, 0x0003e8000b901c46ULL,
0x00000000183d7faeULL, 0x0003e8000b901c46ULL, 0x000000001a3f7faeULL, 0x0003e8000b901c46ULL,
0x000000001c417faeULL, 0x0003e8000b901c46ULL, 0x000000001e437faeULL, 0x0003e8000b901c46ULL,
0x0000000020457faeULL, 0x0003e8000b901c46ULL, 0x0000000022477faeULL, 0x0003e4000b901c46ULL,
0x000000027a7a7836ULL, 0x000fe20000000000ULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff797424ULL, 0x000fc600078e00ffULL, 0x000000637a00720cULL, 0x000fda0003f06070ULL,
0x00009000ff0c8b82ULL, 0x002e620000000a00ULL, 0x0000000276058824ULL, 0x000fe200078e027aULL,
0x000000080b5c7812ULL, 0x040fe200078ec0ffULL, 0x000000200b607836ULL, 0x000fe20000000000ULL,
0xfffffff80b627812ULL, 0x040fe200078ec0ffULL, 0x000020000a5b7824ULL, 0x000fe200078e0204ULL,
0x00000004ff587819ULL, 0x000fe2000001160bULL, 0x000000ffff737224ULL, 0x000fe200078e00ffULL,
0x000000070b5a7812ULL, 0x000fe400078ec0ffULL, 0x0000000000067805ULL, 0x000fc4000001ff00ULL,
0x0000000000167805ULL, 0x000fe4000001ff00ULL, 0x0000000000147805ULL, 0x000fe4000001ff00ULL,
0x00000000001a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000187805ULL, 0x000fe4000001ff00ULL,
0x00000000001e7805ULL, 0x000fe4000001ff00ULL, 0x00000000001c7805ULL, 0x000fc4000001ff00ULL,
0x0000000000227805ULL, 0x000fe4000001ff00ULL, 0x0000000000207805ULL, 0x000fe4000001ff00ULL,
0x0000000000267805ULL, 0x000fe4000001ff00ULL, 0x0000000000247805ULL, 0x000fe4000001ff00ULL,
0x00000000002a7805ULL, 0x000fe4000001ff00ULL, 0x0000000000287805ULL, 0x000fc4000001ff00ULL,
0x00000000002e7805ULL, 0x000fe4000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000004050c8825ULL, 0x002fe200078e000cULL, 0x0000000000327805ULL, 0x000fe4000001ff00ULL,
0x0000000000307805ULL, 0x000fe4000001ff00ULL, 0x0000000000367805ULL, 0x000fe4000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x000000060c798981ULL, 0x000322000c1e1900ULL,
0xfffffff860607812ULL, 0x000fc400078ec0ffULL, 0x0000000000047805ULL, 0x000fe4000001ff00ULL,
0x000000075c5c7812ULL, 0x000fe400078ef80bULL, 0x00000000003a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000387805ULL, 0x000fe4000001ff00ULL, 0x00000000003e7805ULL, 0x000fe4000001ff00ULL,
0x00000000003c7805ULL, 0x000fc4000001ff00ULL, 0x0000000000427805ULL, 0x000fe4000001ff00ULL,
0x0000000000407805ULL, 0x000fe4000001ff00ULL, 0x0000000000467805ULL, 0x000fe4000001ff00ULL,
0x0000000000447805ULL, 0x000fe4000001ff00ULL, 0x00000000004a7805ULL, 0x000fe4000001ff00ULL,
0x0000000000487805ULL, 0x000fc4000001ff00ULL, 0x00000000004e7805ULL, 0x000fe4000001ff00ULL,
0x00000000004c7805ULL, 0x000fe2000001ff00ULL, 0x000020005b5b7836ULL, 0x000fe20000000000ULL,
0x0000000762627812ULL, 0x000fe200078ef80bULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000000760607812ULL, 0x000fe400078ef80bULL, 0x000000105c0a7812ULL, 0x002fce00078efcffULL,
0x00000001620c7824ULL, 0x140fe400078e0273ULL, 0x00000008620d7824ULL, 0x000fe400078e00ffULL,
0x0000000160107824ULL, 0x040fe400078e0273ULL, 0x0000000860117824ULL, 0x000fe200078e00ffULL,
0xfffffff80d0c7812ULL, 0x000fe200078ee20cULL, 0x00000001737b7836ULL, 0x000fe40000000000ULL,
0x0000000273917824ULL, 0x000fe200078e0258ULL, 0xfffffff811107812ULL, 0x000fe200078ee210ULL,
0x000000100c0c7824ULL, 0x000fc400078e025bULL, 0x000000100a9d7824ULL, 0x000fe400078e00ffULL,
0x0000001010107824ULL, 0x000fe400078e025bULL, 0x000000000c0c783bULL, 0x000e620000000200ULL,
0x0000000273737836ULL, 0x000fc60000000000ULL, 0x000000001010783bULL, 0x000ea40000000200ULL,
0x000000087300780cULL, 0x000fe40003f05270ULL, 0x00000018ff507819ULL, 0x002fe2000001140cULL,
0x000100000c517824ULL, 0x040fe200078e00ffULL, 0x000088800c527816ULL, 0x040fe200000000ffULL,
0x000001000c0c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6f7819ULL, 0x000fe2000001140dULL,
0x000100000d547824ULL, 0x040fe200078e00ffULL, 0x000088800d6e7816ULL, 0x040fe200000000ffULL,
0x000001000d0d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x00000018ff537819ULL, 0x000fc40000011451ULL,
0x00000018ff0d7819ULL, 0x000fe4000001140dULL, 0x00000018ff717819ULL, 0x000fe4000001140eULL,
0x000088800e707816ULL, 0x000fe200000000ffULL, 0x0000000c00517306ULL, 0x0003e20000200c00ULL,
0x00000018ff547819ULL, 0x000fe40000011454ULL, 0x00000018ff697819ULL, 0x004fe40000011410ULL,
0x0000888010687816ULL, 0x000fc400000000ffULL, 0x00000018ff6b7819ULL, 0x000fe20000011411ULL,
0x0000000d00987306ULL, 0x0005e20000200c00ULL, 0x000100000e0c7824ULL, 0x042fe200078e00ffULL,
0x00008880116a7816ULL, 0x000fe200000000ffULL, 0x000001000e0e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff677819ULL, 0x000fe4000001140fULL, 0x00000018ff0c7819ULL, 0x000fe4000001140cULL,
0x00000018ff0e7819ULL, 0x000fe2000001140eULL, 0x000100000f0d7824ULL, 0x044fe200078e00ffULL,
0x00000054009b7306ULL, 0x000fe20000200c00ULL, 0x000088800f667816ULL, 0x040fe200000000ffULL,
0x000001000f0f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fc40000011412ULL,
0x00000018ff0d7819ULL, 0x000fe4000001140dULL, 0x00000018ff0f7819ULL, 0x000fe2000001140fULL,
0x0000000e00967306ULL, 0x0003e20000200c00ULL, 0x00000018ff657819ULL, 0x000fe40000011413ULL,
0x00008880126c7816ULL, 0x000fe400000000ffULL, 0x0000888013647816ULL, 0x000fc600000000ffULL,
0x0000000d00997306ULL, 0x0005e20000200c00ULL, 0x00000008620e7824ULL, 0x002fce00078e00ffULL,
0x0000000c00817306ULL, 0x0003e20000200c00ULL, 0x00000001620d7824ULL, 0x104fe400078e027bULL,
0x00000001607b7824ULL, 0x000fc600078e027bULL, 0xfffffff80e0e7812ULL, 0x000fe200078ee20dULL,
0x00010000110d7824ULL, 0x040fe200078e00ffULL, 0x0000000f008c7306ULL, 0x000fe20000200c00ULL,
0x00010000100c7824ULL, 0x002fe400078e00ffULL, 0x000000100e0e7824ULL, 0x000fe200078e025bULL,
0x00000018ff0d7819ULL, 0x000fe2000001140dULL, 0x0000010010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff0c7819ULL, 0x000fe2000001140cULL, 0x0000010011117824ULL, 0x000fe200078e00ffULL,
0x000000000e54783bULL, 0x000e620000000200ULL, 0x0000000d00957306ULL, 0x000fe20000200c00ULL,
0x00000018ff107819ULL, 0x000fc40000011410ULL, 0x00000018ff117819ULL, 0x000fca0000011411ULL,
0x00000010008e7306ULL, 0x0005f00000200c00ULL, 0x0000001100947306ULL, 0x0007e20000200c00ULL,
0x0000000860107824ULL, 0x004fca00078e00ffULL, 0xfffffff810107812ULL, 0x000fe400078ee27bULL,
0x0000000c00977306ULL, 0x0005e20000200c00ULL, 0x000000105c117824ULL, 0x008fe400078e00ffULL,
0x00000010100d7824ULL, 0x000fe400078e025bULL, 0x0001000013107824ULL, 0x040fe400078e00ffULL,
0x0000010013137824ULL, 0x000fe200078e00ffULL, 0x0000005300537306ULL, 0x000ee20000200c00ULL,
0x00010000120c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff107819ULL, 0x000fe20000011410ULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fc40000011413ULL,
0x00000018ff8f7819ULL, 0x000fe2000001140cULL, 0x0001000055837824ULL, 0x042fe200078e00ffULL,
0x0000001000937306ULL, 0x0003e20000200c00ULL, 0x00000018ff887819ULL, 0x000fe20000011454ULL,
0x000000000d0c783bULL, 0x000ea20000000200ULL, 0x00008880548a7816ULL, 0x000fe200000000ffULL,
0x0001000056857824ULL, 0x000fe200078e00ffULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x00000018ff827819ULL, 0x000fe20000011455ULL, 0x0000005000507306ULL, 0x000f620000200c00ULL,
0x000000015c107824ULL, 0x002fe200078e0291ULL, 0x0000888055867816ULL, 0x040fe200000000ffULL,
0x0000010055557824ULL, 0x000fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fc40000011456ULL,
0xfffffff011107812ULL, 0x000fe200078ee210ULL, 0x0001000054117824ULL, 0x040fe200078e00ffULL,
0x0000001200927306ULL, 0x000fe20000200c00ULL, 0x0000010054547824ULL, 0x000fe200078e00ffULL,
0x00000018ff557819ULL, 0x000fe20000011455ULL, 0x0000001010107824ULL, 0x000fe200078e0209ULL,
0x00000018ff8d7819ULL, 0x000fe40000011411ULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000001300907306ULL, 0x0003e20000200c00ULL, 0x0000888056847816ULL, 0x040fe200000000ffULL,
0x0000010056567824ULL, 0x000fe200078e00ffULL, 0x00000018ff837819ULL, 0x000fc40000011483ULL,
0x00000018ff7f7819ULL, 0x000fe40000011457ULL, 0x00000018ff567819ULL, 0x000fe20000011456ULL,
0x00000054008b7306ULL, 0x0007e20000200c00ULL, 0x000000001010783bULL, 0x002e620000000200ULL,
0x00000018ff857819ULL, 0x000fcc0000011485ULL, 0x0000005500877306ULL, 0x000be20000200c00ULL,
0x000000010a547824ULL, 0x008fe200078e0291ULL, 0x00000018ff7e7819ULL, 0x004fe4000001140cULL,
0x00000018ff7d7819ULL, 0x000fe4000001140dULL, 0xfffffff09d9a7812ULL, 0x000fe400078ee254ULL,
0x0000541052547816ULL, 0x000fe20000000053ULL, 0x0000006f006f7306ULL, 0x000ea20000200c00ULL,
0x0000541051557816ULL, 0x020fe20000000050ULL, 0x000000109a527824ULL, 0x000fe200078e0209ULL,
0x00008880579a7816ULL, 0x000fc400000000ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001140eULL,
0x00000018ff7b7819ULL, 0x000fe2000001140fULL, 0x000000005250783bULL, 0x000ee20000000200ULL,
0x0000007100717306ULL, 0x000f620000200c00ULL, 0x00005410986f7816ULL, 0x004fe2000000006fULL,
0x000000ffff987224ULL, 0x000fcc00078e009aULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x00010000579a7824ULL, 0x040fe400078e00ffULL, 0x0000010057577824ULL, 0x000fc600078e00ffULL,
0x00000018ff9a7819ULL, 0x000fe2000001149aULL, 0x00000054104c723cULL, 0x002fe2000000184cULL,
0x0000006900697306ULL, 0x000e620000200c00ULL, 0x0000541096717816ULL, 0x020fe40000000071ULL,
0x00000018ff577819ULL, 0x000fe40000011457ULL, 0x000054108c677816ULL, 0x004fc60000000067ULL,
0x0000006b006b7306ULL, 0x000ea20000200c00ULL, 0x000054108e697816ULL, 0x002fce0000000069ULL,
0x0000006d006d7306ULL, 0x000e620000200c00ULL, 0x00005410946b7816ULL, 0x004fce000000006bULL,
0x0000006500657306ULL, 0x000ea20000200c00ULL, 0x00000054502c723cULL, 0x008fe2000000182cULL,
0x00005410926d7816ULL, 0x002fcc000000006dULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x0000541090657816ULL, 0x004fce0000000065ULL, 0x0000007000707306ULL, 0x000ea20000200c00ULL,
0x000054106e6e7816ULL, 0x002fce000000009bULL, 0x0000006600667306ULL, 0x000e620000200c00ULL,
0x0000006e1048723cULL, 0x000fe20000001848ULL, 0x0000541070707816ULL, 0x004fcc0000000081ULL,
0x0000006800687306ULL, 0x000ea20000200c00ULL, 0x0000006e5028723cULL, 0x000fe20000001828ULL,
0x0000541066667816ULL, 0x002fcc0000000099ULL, 0x0000006a006a7306ULL, 0x000e620000200c00ULL,
0x000000701044723cULL, 0x000fe20000001844ULL, 0x0000541068687816ULL, 0x004fcc0000000097ULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x000000661040723cULL, 0x000fe20000001840ULL,
0x000054106a6a7816ULL, 0x002fcc0000000095ULL, 0x0000008f008f7306ULL, 0x000e620000200c00ULL,
0x00000068103c723cULL, 0x000fec000000183cULL, 0x0000006a1038723cULL, 0x000fe20000001838ULL,
0x0000006400647306ULL, 0x000eaa0000200c00ULL, 0x000000665020723cULL, 0x000fe20000001820ULL,
0x000054106c6c7816ULL, 0x002fc4000000008fULL, 0x0000008300897306ULL, 0x000fe60000200c00ULL,
0x00000068501c723cULL, 0x000fe2000000181cULL, 0x000000100a667824ULL, 0x000fe200078e00ffULL,
0x0000541064647816ULL, 0x004fc60000000093ULL, 0x0000005600837306ULL, 0x0003e20000200c00ULL,
0x0000006c1034723cULL, 0x000fec0000001834ULL, 0x000000641030723cULL, 0x000fe20000001830ULL,
0x00000057008e7306ULL, 0x000fe20000200c00ULL, 0x000088800c567816ULL, 0x002fc800000000ffULL,
0x000000705024723cULL, 0x000fe20000001824ULL, 0x000000ffff8f7224ULL, 0x000fe200078e0056ULL,
0x000088800d107816ULL, 0x040fe200000000ffULL, 0x000100000c567824ULL, 0x000fe200078e00ffULL,
0x000088800e127816ULL, 0x000fe200000000ffULL, 0x000001000c0c7824ULL, 0x000fe200078e00ffULL,
0x0000006a5018723cULL, 0x000fe20000001818ULL, 0x0000000291117836ULL, 0x000fe20000000000ULL,
0x00000018ff567819ULL, 0x000fe20000011456ULL, 0x000000105c137824ULL, 0x040fe200078e00ffULL,
0x00000018ff917819ULL, 0x000fe2000001140cULL, 0x000000015c0c7824ULL, 0x100fe200078e0211ULL,
0x0000005600907306ULL, 0x0003e20000200c00ULL, 0x000000010a117824ULL, 0x000fe200078e0211ULL,
0x0000006c5014723cULL, 0x000fe20000001814ULL, 0x000000ffff6e7224ULL, 0x000fe200078e0010ULL,
0xfffffff0130c7812ULL, 0x000fe200078ee20cULL, 0x000100000d107824ULL, 0x000fe200078e00ffULL,
0x000088800f6a7816ULL, 0x000fe200000000ffULL, 0x000000ffff687224ULL, 0x000fe200078e0012ULL,
0x000000645004723cULL, 0x000fe20000001804ULL, 0x000000100c0c7824ULL, 0x000fe200078e0209ULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x000100000e127824ULL, 0x040fe200078e00ffULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x000001000d0d7824ULL, 0x000fe200078e00ffULL,
0x000000000c54783bULL, 0x0022a20000000200ULL, 0x000001000e0e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff697819ULL, 0x000fe20000011412ULL, 0x000001000f507824ULL, 0x000fe200078e00ffULL,
0x00000018ff0d7819ULL, 0x000fc4000001140dULL, 0x00000010006f7306ULL, 0x0007e20000200c00ULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0xfffffff0660c7812ULL, 0x002fe400078ee211ULL,
0x00000018ff527819ULL, 0x000fc60000011450ULL, 0x000000100c0c7824ULL, 0x000fe200078e0209ULL,
0x0000000d00707306ULL, 0x0003e80000200c00ULL, 0x000000000c10783bULL, 0x008ee80000000200ULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000100000f0d7824ULL, 0x002fca00078e00ffULL,
0x00000018ff6d7819ULL, 0x000fe4000001140dULL, 0x0000006900697306ULL, 0x000e700000200c00ULL,
0x0000000e006b7306ULL, 0x000f620000200c00ULL, 0x0000541068687816ULL, 0x002fce0000000069ULL,
0x0000008800887306ULL, 0x000e620000200c00ULL, 0x000054106b697816ULL, 0x020fce000000007cULL,
0x0000008200827306ULL, 0x000f620000200c00ULL, 0x000000685434723cULL, 0x004fe20000001834ULL,
0x000054108b0d7816ULL, 0x002fcc0000000088ULL, 0x0000008000807306ULL, 0x000e620000200c00ULL,
0x000000681014723cULL, 0x008fe20000001814ULL, 0x00005410870f7816ULL, 0x020fcc0000000082ULL,
0x0000007f007f7306ULL, 0x000ea20000200c00ULL, 0x0000541083517816ULL, 0x002fce0000000080ULL,
0x0000007e007e7306ULL, 0x000fe20000200c00ULL, 0x000054108e537816ULL, 0x004fce000000007fULL,
0x0000007d007d7306ULL, 0x000e700000200c00ULL, 0x0000007b007b7306ULL, 0x000fe20000200c00ULL,
0x0000541070677816ULL, 0x002fce000000007dULL, 0x0000008a008a7306ULL, 0x000ff00000200c00ULL,
0x0000008d008d7306ULL, 0x000e700000200c00ULL, 0x0000008600867306ULL, 0x000ea20000200c00ULL,
0x000054108a0c7816ULL, 0x002fce000000008dULL, 0x0000008400847306ULL, 0x000fe20000200c00ULL,
0x0000000c544c723cULL, 0x000fe2000000184cULL, 0x00005410860e7816ULL, 0x004fcc0000000089ULL,
0x0000008500857306ULL, 0x000e620000200c00ULL, 0x0000000c102c723cULL, 0x000fee000000182cULL,
0x0000009800817306ULL, 0x000fe20000200c00ULL, 0x0000000e5448723cULL, 0x000fe20000001848ULL,
0x0000541084507816ULL, 0x002fcc0000000085ULL, 0x0000009a008c7306ULL, 0x000fe20000200c00ULL,
0x0000000e1028723cULL, 0x000fec0000001828ULL, 0x000000505444723cULL, 0x000fe20000001844ULL,
0x0000008f008f7306ULL, 0x000e6a0000200c00ULL, 0x000000501024723cULL, 0x000fe60000001824ULL,
0x0000009100917306ULL, 0x000ea20000200c00ULL, 0x000054108f647816ULL, 0x002fce0000000090ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x0000541091657816ULL, 0x004fce000000007eULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x00000064543c723cULL, 0x000fe2000000183cULL,
0x000054106e667816ULL, 0x002fcc000000006fULL, 0x0000006d006d7306ULL, 0x000e620000200c00ULL,
0x00000064101c723cULL, 0x000fee000000181cULL, 0x00000052006c7306ULL, 0x0004e20000200c00ULL,
0x000000665438723cULL, 0x000fe20000001838ULL, 0x000054106a6a7816ULL, 0x002fca000000006dULL,
0x000000661018723cULL, 0x000fe20000001818ULL, 0x0000541081527816ULL, 0x004fe4000000008cULL,
0x000054106c6b7816ULL, 0x008fca000000007bULL, 0x000000525440723cULL, 0x000fec0000001840ULL,
0x0000006a5430723cULL, 0x000fec0000001830ULL, 0x000000521020723cULL, 0x000fec0000001820ULL,
0x0000006a1004723cULL, 0x000fe20000001804ULL, 0x0000000000007918ULL, 0x000fd00000000000ULL,
0xffffffec00b40947ULL, 0x000fde000383ffffULL, 0x00000001ff137424ULL, 0x000fe400078e00ffULL,
0x0000005e4c0d7220ULL, 0x080fe20000410000ULL, 0x0000005e4d4d7220ULL, 0x080fe20000410000ULL,
0x0000005e4e4e7220ULL, 0x080fe20000410000ULL, 0x0000005e4f4f7220ULL, 0x080fe20000410000ULL,
0x0000005e48487220ULL, 0x080fe20000410000ULL, 0x01a68813081279a7ULL, 0x000262000850003fULL,
0x0000005e49497220ULL, 0x080fe20000410000ULL, 0x0000005e4a4a7220ULL, 0x080fe20000410000ULL,
0x0000005e4b4b7220ULL, 0x080fe20000410000ULL, 0x0000005e44447220ULL, 0x080fe20000410000ULL,
0x0000005e45457220ULL, 0x080fe20000410000ULL, 0x0000005e46467220ULL, 0x080fe20000410000ULL,
0x0000005e47477220ULL, 0x080fe20000410000ULL, 0x0000005e40407220ULL, 0x080fe20000410000ULL,
0x0000005e41417220ULL, 0x080fe20000410000ULL, 0x0000005e42427220ULL, 0x080fe20000410000ULL,
0x0000005e43437220ULL, 0x080fe20000410000ULL, 0x0000005e3c3c7220ULL, 0x080fe20000410000ULL,
0x0000005e3d3d7220ULL, 0x080fe20000410000ULL, 0x0000005e3e3e7220ULL, 0x080fe20000410000ULL,
0x0000005e3f3f7220ULL, 0x080fe20000410000ULL, 0x0000005e38387220ULL, 0x080fe20000410000ULL,
0x0000005e39397220ULL, 0x080fe20000410000ULL, 0x0000005e3a3a7220ULL, 0x080fe20000410000ULL,
0x0000005e3b3b7220ULL, 0x080fe20000410000ULL, 0x0000005e34347220ULL, 0x080fe20000410000ULL,
0x0000005e35357220ULL, 0x080fe20000410000ULL, 0x0000005e36367220ULL, 0x080fe20000410000ULL,
0x0000005e37377220ULL, 0x080fe20000410000ULL, 0x0000005e30307220ULL, 0x080fe20000410000ULL,
0x0000005e31317220ULL, 0x080fe20000410000ULL, 0x0000005e32327220ULL, 0x080fe20000410000ULL,
0x0000005e33337220ULL, 0x080fe20000410000ULL, 0x0000005e2c0f7220ULL, 0x080fe20000410000ULL,
0x0000005e2d2d7220ULL, 0x080fe20000410000ULL, 0x0000005e2e2e7220ULL, 0x080fe20000410000ULL,
0x0000005e2f2f7220ULL, 0x080fe20000410000ULL, 0x0000005e28287220ULL, 0x080fe20000410000ULL,
0x0000005e29297220ULL, 0x080fe20000410000ULL, 0x0000005e2a2a7220ULL, 0x080fe20000410000ULL,
0x0000005e2b2b7220ULL, 0x080fe20000410000ULL, 0x0000005e24247220ULL, 0x080fe20000410000ULL,
0x0000005e25257220ULL, 0x080fe20000410000ULL, 0x0000005e26267220ULL, 0x080fe20000410000ULL,
0x0000005e27277220ULL, 0x080fe20000410000ULL, 0x0000005e20207220ULL, 0x080fe20000410000ULL,
0x0000005e21217220ULL, 0x080fe20000410000ULL, 0x0000005e22227220ULL, 0x080fe20000410000ULL,
0x0000005e23237220ULL, 0x080fe20000410000ULL, 0x0000005e1c1c7220ULL, 0x080fe20000410000ULL,
0x0000005e1d1d7220ULL, 0x080fe20000410000ULL, 0x0000005e1e1e7220ULL, 0x080fe20000410000ULL,
0x0000005e1f1f7220ULL, 0x080fe20000410000ULL, 0x0000005e18187220ULL, 0x080fe20000410000ULL,
0x0000005e19197220ULL, 0x080fe20000410000ULL, 0x0000005e1a1a7220ULL, 0x080fe20000410000ULL,
0x0000005e1b1b7220ULL, 0x080fe20000410000ULL, 0x0000005e14147220ULL, 0x080fe20000410000ULL,
0x0000005e15157220ULL, 0x080fe20000410000ULL, 0x0000005e16167220ULL, 0x080fe20000410000ULL,
0x0000005e17177220ULL, 0x080fe20000410000ULL, 0x0000005e040a7220ULL, 0x080fe20000410000ULL,
0x0000005e050c7220ULL, 0x080fe20000410000ULL, 0x0000005e060e7220ULL, 0x080fe20000410000ULL,
0x0000005e07107220ULL, 0x002fce0000410000ULL, 0x0000000000067805ULL, 0x000fce0000015200ULL,
0x01a68813080075a7ULL, 0x000e64000800017fULL, 0x00000000005c0947ULL, 0x002fea0003800000ULL,
0x000000ffff2c7224ULL, 0x000fce00078e00ffULL, 0x000000102c00780cULL, 0x000fda0003f06270ULL,
0x0000000000448947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fce0000015200ULL,
0x0000000406117210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e07ULL,
0x003d09001100780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000000000088947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fea0003800000ULL,
0x0000000000287947ULL, 0x000fea0003800000ULL, 0x00009c401100780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x00000000001c8947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000001104047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fea0003800000ULL, 0x0000000000047947ULL, 0x000fea0003800000ULL,
0x000000012c2c7836ULL, 0x000fce0000000000ULL, 0x01a68813080075a7ULL, 0x000e64000800017fULL,
0xfffffffc00a88947ULL, 0x002fea000383ffffULL, 0x000000040b047824ULL, 0x000fe200078e00ffULL,
0x0000005f7200720cULL, 0x000fe20003f06070ULL, 0x0000008078117824ULL, 0x000fc600078e0209ULL,
0xfffffff004047812ULL, 0x000fca00078ec0ffULL, 0x0000000111117824ULL, 0x000fca00078e0204ULL,
0x01a4000011047984ULL, 0x0002a20000000c00ULL, 0x0000001c00c48947ULL, 0x000fea0003800000ULL,
0xffffff0059597836ULL, 0x000fe20000000000ULL, 0x0000860000097ab9ULL, 0x000fe20000000800ULL,
0x000000020baa7824ULL, 0x000fe200078e00ffULL, 0x00008c00ff547b82ULL, 0x000ee20000000a00ULL,
0x00008400000a7ab9ULL, 0x000fe20000000800ULL, 0x0000005974127248ULL, 0x000fe40007fe0000ULL,
0x00000006aaaa7812ULL, 0x000fc600078ec0ffULL, 0x0000000112ab7824ULL, 0x000fe200078e0a59ULL,
0x000000000b127211ULL, 0x000fe200078ff0ffULL, 0x0000000aaaa97c36ULL, 0x000fe40008000000ULL,
0x000000ffff837224ULL, 0x000fe200078e0aabULL, 0x00000009ff137c19ULL, 0x000fe20008011612ULL,
0x00000008122c7836ULL, 0x000fe20000000000ULL, 0x000000aba900720cULL, 0x000fe20003f06070ULL,
0x00000010124c7836ULL, 0x000fe20000000000ULL, 0x0000000513137c48ULL, 0x000fe2000bfe0000ULL,
0x0000001812507836ULL, 0x000fe20000000000ULL, 0x00000009ff2c7c19ULL, 0x000fe2000801162cULL,
0x00000008aa127c36ULL, 0x000fe20008000000ULL, 0x00000005a99a7e46ULL, 0x000fe2000b800083ULL,
0x00000004136b7c24ULL, 0x000fe2000f8e02ffULL, 0x000000052c2c7c48ULL, 0x000fc4000bfe0000ULL,
0x000000ab1200720cULL, 0x000fe40003f26070ULL, 0x0000000512127e46ULL, 0x000fe2000b800083ULL,
0x000000042c6d7c24ULL, 0x000fe2000f8e02ffULL, 0x000000ff9a9a7207ULL, 0x000fe40000000000ULL,
0x00000004ff127819ULL, 0x000fe40000011612ULL, 0x00000009ff4c7c19ULL, 0x000fe4000801164cULL,
0x000000ff122c7207ULL, 0x000fc40000800000ULL, 0x0000006b9a137211ULL, 0x000fe400078fe0ffULL,
0x000000054c4c7c48ULL, 0x000fe2000bfe0000ULL, 0x000000016b597824ULL, 0x000fe200078e022cULL,
0x00000009ff507c19ULL, 0x000fe20008011650ULL, 0x0000000213127825ULL, 0x108fe200078e0054ULL,
0x00000010aa857812ULL, 0x000fe400078efcffULL, 0x00000005505b7c48ULL, 0x000fe2000bfe0000ULL,
0x0000000259587825ULL, 0x000fe200078e0054ULL, 0x0000000612a77981ULL, 0x0044e2000c1e9500ULL,
0x0000006d9a517211ULL, 0x000fc400078fe0ffULL, 0x000000044c697c24ULL, 0x000fe2000f8e02ffULL,
0x0000000658a87981ULL, 0x000ee2000c1e9500ULL, 0x000000012c977824ULL, 0x040fe400078e026dULL,
0x000000012c657824ULL, 0x000fe200078e0269ULL, 0x000000699a577211ULL, 0x000fe200078fe0ffULL,
0x000000045b5b7c24ULL, 0x000fe4000f8e02ffULL, 0x0000000297967825ULL, 0x000fc800078e0054ULL,
0x0000000265127825ULL, 0x104fe200078e0054ULL, 0x0000005b9a537211ULL, 0x000fe200078fe0ffULL,
0x0000000696967981ULL, 0x000ea4000c1e9500ULL, 0x0000000a85867c36ULL, 0x000fe40008000000ULL,
0x0000000251507825ULL, 0x000fe200078e0054ULL, 0x0000000612127981ULL, 0x000f66000c1e9500ULL,
0x000000012c677824ULL, 0x000fc400078e025bULL, 0x0000000257567825ULL, 0x100fe200078e0054ULL,
0x000000ab8600720cULL, 0x080fe20003f06070ULL, 0x0000000650957981ULL, 0x0006a4000c1e9500ULL,
0x00000008852c7c36ULL, 0x000fe20008000000ULL, 0x0000000586997e46ULL, 0x000fe2000b800083ULL,
0x0000000656937981ULL, 0x000f62000c1e9500ULL, 0x0000000253527825ULL, 0x000fe400078e0054ULL,
0x000000052c4c7e46ULL, 0x000fe4000b800083ULL, 0x000000ff99997207ULL, 0x000fe20000000000ULL,
0x0000000652947981ULL, 0x000762000c1e9500ULL, 0x000000ab2c00720cULL, 0x000fc40003f26070ULL,
0x00000004ff4c7819ULL, 0x000fe2000001164cULL, 0x0000000267507825ULL, 0x00afc600078e0054ULL,
0x000000ff4c4c7207ULL, 0x000fe40000800000ULL, 0x0000006d99537211ULL, 0x000fe200078fe0ffULL,
0x0000000650517981ULL, 0x000ee4000c1e9500ULL, 0x000000014c6f7824ULL, 0x000fe400078e025bULL,
0x0000000253527825ULL, 0x000fe200078e0054ULL, 0x0000006b99577211ULL, 0x000fc600078fe0ffULL,
0x000000016b8d7824ULL, 0x000fe200078e024cULL, 0x0000000652897981ULL, 0x0002e2000c1e9500ULL,
0x000000014c597824ULL, 0x000fe400078e026dULL, 0x000000028d8c7825ULL, 0x000fc800078e0054ULL,
0x0000000257567825ULL, 0x100fe400078e0054ULL, 0x000000068c8c7981ULL, 0x000ee4000c1e9500ULL,
0x000000026f527825ULL, 0x102fe200078e0054ULL, 0x00000020aa6f7812ULL, 0x000fe200078efcffULL,
0x00000006568b7981ULL, 0x0002e4000c1e9500ULL, 0x0000000259587825ULL, 0x000fe200078e0054ULL,
0x0000006999677211ULL, 0x000fe200078fe0ffULL, 0x0000000652527981ULL, 0x000ee4000c1e9500ULL,
0x000000086f2c7c36ULL, 0x000fc40008000000ULL, 0x00000006588a7981ULL, 0x0002e2000c1e9500ULL,
0x000000014c137824ULL, 0x000fe200078e0269ULL, 0x0000005b99657211ULL, 0x000fe200078fe0ffULL,
0x0000000a6f707c36ULL, 0x000fe20008000000ULL, 0x000000052c4c7e46ULL, 0x000fe2000b800083ULL,
0x0000000267667825ULL, 0x000fe200078e0054ULL, 0x000000ab2c00720cULL, 0x080fe40003f26070ULL,
0x00000004ff4c7819ULL, 0x000fe2000001164cULL, 0x0000000265647825ULL, 0x100fe200078e0054ULL,
0x000000ab7000720cULL, 0x000fe20003f06070ULL, 0x0000000666887981ULL, 0x000ee2000c1e9500ULL,
0x0000000570507e46ULL, 0x000fe2000b800083ULL, 0x0000000213567825ULL, 0x002fe200078e0054ULL,
0x000000ff4c4c7207ULL, 0x000fe20000800000ULL, 0x0000000664877981ULL, 0x000ee2000c1e9500ULL,
0x000000ff50507207ULL, 0x000fc60000000000ULL, 0x0000000656137981ULL, 0x0002e2000c1e9500ULL,
0x000000014c7f7824ULL, 0x000fe200078e026dULL, 0x0000006b50597211ULL, 0x000fc600078fe0ffULL,
0x000000027f7e7825ULL, 0x000fe200078e0054ULL, 0x0000006d50577211ULL, 0x002fca00078fe0ffULL,
0x000000067e7e7981ULL, 0x000ee2000c1e9500ULL, 0x0000000257567825ULL, 0x000fe200078e0054ULL,
0x0000005b507d7211ULL, 0x000fc800078fe0ffULL, 0x0000000656737981ULL, 0x0002e2000c1e9500ULL,
0x0000000259587825ULL, 0x000fe200078e0054ULL, 0x0000006950677211ULL, 0x000fc600078fe0ffULL,
0x000000016b817824ULL, 0x000fe200078e024cULL, 0x00000006587b7981ULL, 0x0002e2000c1e9500ULL,
0x000000014c657824ULL, 0x040fe400078e0269ULL, 0x000000014c537824ULL, 0x000fe200078e025bULL,
0x00000030aa577812ULL, 0x002fe200078efcffULL, 0x0000000281807825ULL, 0x000fc800078e0054ULL,
0x000000027d7c7825ULL, 0x100fe400078e0054ULL, 0x0000000680807981ULL, 0x000ee4000c1e9500ULL,
0x0000000267667825ULL, 0x100fe400078e0054ULL, 0x000000067c7c7981ULL, 0x000ee4000c1e9500ULL,
0x0000000265647825ULL, 0x100fe400078e0054ULL, 0x0000000666717981ULL, 0x000ee4000c1e9500ULL,
0x0000000253587825ULL, 0x000fc400078e0054ULL, 0x00000006642c7981ULL, 0x0002e4000c1e9500ULL,
0x00000008574c7c36ULL, 0x000fe40008000000ULL, 0x0000000658537981ULL, 0x0002e2000c1e9500ULL,
0x0000000a575c7c36ULL, 0x000fe40008000000ULL, 0x000000054c567e46ULL, 0x000fe4000b800083ULL,
0x000000ab4c00720cULL, 0x080fe40003f26070ULL, 0x000000ab5c00720cULL, 0x000fc40003f06070ULL,
0x000000055c987e46ULL, 0x000fe4000b800083ULL, 0x00000004ff567819ULL, 0x000fe40000011656ULL,
0x000000ff98987207ULL, 0x000fe40000000000ULL, 0x000000ff56567207ULL, 0x000fe40000800000ULL,
0x0000006b98657211ULL, 0x042fe400078fe0ffULL, 0x0000006d98837211ULL, 0x000fe200078fe0ffULL,
0x00000001566d7824ULL, 0x000fe200078e026dULL, 0x0000006998677211ULL, 0x000fe200078fe0ffULL,
0x000000016b597824ULL, 0x000fc400078e0256ULL, 0x00000001567d7824ULL, 0x000fe400078e0269ULL,
0x0000000265647825ULL, 0x000fc800078e0054ULL, 0x0000000267667825ULL, 0x100fe400078e0054ULL,
0x0000000664647981ULL, 0x000ee4000c1e9500ULL, 0x000000026d687825ULL, 0x100fe400078e0054ULL,
0x0000000666677981ULL, 0x000ee4000c1e9500ULL, 0x0000000259587825ULL, 0x100fe400078e0054ULL,
0x0000000668697981ULL, 0x000ee4000c1e9500ULL, 0x000000027d6c7825ULL, 0x000fc400078e0054ULL,
0x00000006586b7981ULL, 0x0002e8000c1e9500ULL, 0x000000066c4c7981ULL, 0x0002e2000c1e9500ULL,
0x0000000283827825ULL, 0x000fca00078e0054ULL, 0x0000000682627981ULL, 0x0002e4000c1e9500ULL,
0x0000005b98597211ULL, 0x002fe200078fe0ffULL, 0x00000001565b7824ULL, 0x000fc800078e025bULL,
0x0000000259587825ULL, 0x000fc800078e0054ULL, 0x000000025b547825ULL, 0x000fe200078e0054ULL,
0x0000000658607981ULL, 0x000ee8000c1e9500ULL, 0x0000000654657981ULL, 0x0002e2000c1e9500ULL,
0xfffffff09a9a7812ULL, 0x000fe200078ec0ffULL, 0x00000001ff977424ULL, 0x000fc800078e00ffULL,
0x00000001ab9a7824ULL, 0x000fc800078e029aULL, 0x00000001a9a67824ULL, 0x000fe200078e0a9aULL,
0x00000001aa917812ULL, 0x000fe400078efcffULL, 0xfffffff050507812ULL, 0x000fe400078ec0ffULL,
0x000000a697a67219ULL, 0x000fe400000006ffULL, 0xfffffff098987812ULL, 0x000fe200078ec0ffULL,
0x0000000a91927c36ULL, 0x000fe20008000000ULL, 0xfffffff0999c7812ULL, 0x000fe200078ec0ffULL,
0x00000001ab997824ULL, 0x000fc400078e0250ULL, 0x00000001ab507824ULL, 0x000fe400078e0298ULL,
0x0000000192987824ULL, 0x000fe200078e0a9aULL, 0x00000008aa8e7812ULL, 0x040fe400078efcffULL,
0x00000009aa8d7812ULL, 0x040fe400078efcffULL, 0x0000009897987219ULL, 0x000fe200000006ffULL,
0x0000000a8e907c36ULL, 0x000fe20008000000ULL, 0x00000021aa6d7812ULL, 0x040fe200078efcffULL,
0x0000000a8d8f7c36ULL, 0x000fe20008000000ULL, 0x00000028aa687812ULL, 0x000fc400078efcffULL,
0x00000029aa667812ULL, 0x000fe200078efcffULL, 0x0000000190b87824ULL, 0x100fe400078e0a9aULL,
0x0000000a6d6e7c36ULL, 0x000fe40008000000ULL, 0x0000000a686c7c36ULL, 0x000fe40008000000ULL,
0x0000000a666a7c36ULL, 0x000fe40008000000ULL, 0x000000018f9a7824ULL, 0x000fe200078e0a9aULL,
0x00000011aa837812ULL, 0x000fe200078efcffULL, 0x0000000170b27824ULL, 0x000fc400078e0a99ULL,
0x000000016ea07824ULL, 0x100fe200078e0a99ULL, 0x0000009a979a7219ULL, 0x040fe200000006ffULL,
0x000000016cb07824ULL, 0x100fe400078e0a99ULL, 0x000000016aa27824ULL, 0x000fe200078e0a99ULL,
0x000000b897997219ULL, 0x000fe400000006ffULL, 0x00005410a7a77816ULL, 0x000fc800000000a8ULL,
0x000000a7a6ff7212ULL, 0x000fc800078ac0ffULL, 0x000000aba900720cULL, 0x000fc80002fa1470ULL,
0x000000abaa00720cULL, 0x000fe40002fa1070ULL, 0x000000a798ff7212ULL, 0x000fe4000788c0ffULL,
0xff8000000d0d7808ULL, 0x000fe40002800000ULL, 0x0000541095957816ULL, 0x004fe40000000096ULL,
0x0000541093937816ULL, 0x020fe40000000012ULL, 0x00000095a6ff7212ULL, 0x000fc4000784c0ffULL,
0x00000093a6ff7212ULL, 0x000fe4000782c0ffULL, 0x0000009598ff7212ULL, 0x000fe400078ac0ffULL,
0x000000aba900720cULL, 0x0c0fe40001741470ULL, 0x000000aba900720cULL, 0x080fe40000f21470ULL,
0x000000ab9200720cULL, 0x0c0fe40002781470ULL, 0x000000ab9200720cULL, 0x000fc40002fa1470ULL,
0x000000abaa00720cULL, 0x0c0fe40001741070ULL, 0x000000abaa00720cULL, 0x080fe40000f21070ULL,
0x000000ab9100720cULL, 0x0c0fe40002781070ULL, 0x000000ab9100720cULL, 0x000fe40002fa1070ULL,
0x0000541094517816ULL, 0x008fe20000000051ULL, 0x0000000a83847c36ULL, 0x000fe20008000000ULL,
0x00000018aa7f7812ULL, 0x040fe200078efcffULL, 0x00000001ab9b7824ULL, 0x000fe200078e029cULL,
0x00000019aa7d7812ULL, 0x000fc400078efcffULL, 0xff8000004e4e7808ULL, 0x000fe40001000000ULL,
0xff8000000f0f7808ULL, 0x000fe40000800000ULL, 0xff8000004d4d7808ULL, 0x000fe40002000000ULL,
0xff8000004f4f7808ULL, 0x000fe40002800000ULL, 0x000000a799ff7212ULL, 0x000fe4000786c0ffULL,
0x00000051a6ff7212ULL, 0x000fc4000780c0ffULL, 0x0000009398ff7212ULL, 0x040fe4000784c0ffULL,
0x0000005198ff7212ULL, 0x000fe4000782c0ffULL, 0x000000959aff7212ULL, 0x000fe4000788c0ffULL,
0x0000009399ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000a7f827c36ULL, 0x000fe20008000000ULL,
0x000000aba900720cULL, 0x080fe20000701470ULL, 0x0000000a7d817c36ULL, 0x000fe20008000000ULL,
0x000000ab9200720cULL, 0x080fe20001741470ULL, 0x0000000186b67824ULL, 0x100fe200078e0a9bULL,
0x000000ab9200720cULL, 0x080fe20000f21470ULL, 0x00000001849c7824ULL, 0x000fe200078e0a9bULL,
0x000000ab9000720cULL, 0x000fc40001f61470ULL, 0x000000ab9000720cULL, 0x080fe40002fa1470ULL,
0x000000ab8f00720cULL, 0x080fe20002781470ULL, 0x0000000182b47824ULL, 0x100fe200078e0a9bULL,
0x000000abaa00720cULL, 0x080fe20000701070ULL, 0x00000001819e7824ULL, 0x000fe200078e0a9bULL,
0x000000ab9100720cULL, 0x0c0fe40001741070ULL, 0x000000ab9100720cULL, 0x080fe40000f21070ULL,
0x000000ab8e00720cULL, 0x000fc40001f61070ULL, 0x000000ab8e00720cULL, 0x080fe40002fa1070ULL,
0x000000ab8d00720cULL, 0x000fe40002781070ULL, 0x000000b6979b7219ULL, 0x040fe400000006ffULL,
0x0000009c979c7219ULL, 0x000fe400000006ffULL, 0x000054108b8b7816ULL, 0x000fe4000000008cULL,
0x0000541089897816ULL, 0x000fc4000000008aULL, 0xff8000002e2e7808ULL, 0x000fe40000000000ULL,
0xff8000002d2d7808ULL, 0x000fe40001000000ULL, 0xff8000002f2f7808ULL, 0x000fe40000800000ULL,
0xff80000048487808ULL, 0x000fe40001800000ULL, 0xff80000028287808ULL, 0x000fe40002800000ULL,
0xff8000004b4b7808ULL, 0x000fc40002000000ULL, 0x0000009599ff7212ULL, 0x040fe4000780c0ffULL,
0x000000939aff7212ULL, 0x040fe4000784c0ffULL, 0x0000005199ff7212ULL, 0x080fe4000782c0ffULL,
0x000000519aff7212ULL, 0x000fe4000786c0ffULL, 0x0000008b9cff7212ULL, 0x000fe400078ac0ffULL,
0x000000899bff7212ULL, 0x000fc4000788c0ffULL, 0x000000ab9000720cULL, 0x0c0fe40000701470ULL,
0x000000ab9000720cULL, 0x080fe40000f21470ULL, 0x000000ab8f00720cULL, 0x0c0fe40001741470ULL,
0x000000ab8f00720cULL, 0x080fe40001f61470ULL, 0x000000ab8600720cULL, 0x080fe40002781470ULL,
0x000000ab8400720cULL, 0x000fc40002fa1470ULL, 0x000000ab8e00720cULL, 0x0c0fe40000701070ULL,
0x000000ab8e00720cULL, 0x080fe40000f21070ULL, 0x000000ab8d00720cULL, 0x0c0fe40001741070ULL,
0x000000ab8d00720cULL, 0x080fe40001f61070ULL, 0x000000ab8500720cULL, 0x080fe40002781070ULL,
0x000000ab8300720cULL, 0x000fc40002fa1070ULL, 0x000000b4979d7219ULL, 0x040fe400000006ffULL,
0x0000009e979e7219ULL, 0x000fe400000006ffULL, 0x0000541088137816ULL, 0x000fe40000000013ULL,
0x0000541087527816ULL, 0x000fe40000000052ULL, 0xff8000004a4a7808ULL, 0x000fe40000000000ULL,
0xff8000002a2a7808ULL, 0x000fc40000800000ULL, 0xff80000029297808ULL, 0x000fe40001000000ULL,
0xff8000002b2b7808ULL, 0x000fe40001800000ULL, 0xff80000046467808ULL, 0x000fe40002000000ULL,
0xff80000045457808ULL, 0x000fe40002800000ULL, 0x0000008b9bff7212ULL, 0x080fe4000780c0ffULL,
0x0000008b9dff7212ULL, 0x000fc4000782c0ffULL, 0x000000139bff7212ULL, 0x0c0fe4000784c0ffULL,
0x000000529bff7212ULL, 0x000fe4000786c0ffULL, 0x000000139cff7212ULL, 0x000fe4000788c0ffULL,
0x000000899eff7212ULL, 0x000fe400078ac0ffULL, 0x000000ab8600720cULL, 0x0c0fe40000701470ULL,
0x000000ab8600720cULL, 0x000fc40001741470ULL, 0x000000ab8600720cULL, 0x080fe40001f61470ULL,
0x000000ab8400720cULL, 0x080fe40002781470ULL, 0x000000ab8200720cULL, 0x080fe40000f21470ULL,
0x000000ab8100720cULL, 0x080fe40002fa1470ULL, 0x000000ab8500720cULL, 0x0c0fe40000701070ULL,
0x000000ab8500720cULL, 0x000fc40001741070ULL, 0x000000ab8500720cULL, 0x080fe40001f61070ULL,
0x000000ab8300720cULL, 0x080fe40002781070ULL, 0x000000ab7f00720cULL, 0x080fe40000f21070ULL,
0x000000ab7d00720cULL, 0x000fe40002fa1070ULL, 0x000000b2979f7219ULL, 0x000fe400000006ffULL,
0x0000541073737816ULL, 0x000fc4000000007eULL, 0xff80000044447808ULL, 0x000fe40000000000ULL,
0xff80000024247808ULL, 0x000fe40001000000ULL, 0xff80000026267808ULL, 0x000fe40001800000ULL,
0xff80000025257808ULL, 0x000fe40002000000ULL, 0xff80000040407808ULL, 0x000fe40000800000ULL,
0xff80000043437808ULL, 0x000fc40002800000ULL, 0x000000899cff7212ULL, 0x0c0fe4000780c0ffULL,
0x000000529cff7212ULL, 0x080fe4000784c0ffULL, 0x000000899dff7212ULL, 0x000fe4000786c0ffULL,
0x000000139eff7212ULL, 0x040fe4000788c0ffULL, 0x000000529eff7212ULL, 0x000fe4000782c0ffULL,
0x000000739fff7212ULL, 0x000fc400078ac0ffULL, 0x000000ab8400720cULL, 0x0c0fe40000701470ULL,
0x000000ab8400720cULL, 0x080fe40001741470ULL, 0x000000ab8200720cULL, 0x080fe40001f61470ULL,
0x000000ab8100720cULL, 0x0c0fe40002781470ULL, 0x000000ab8100720cULL, 0x080fe40000f21470ULL,
0x000000ab7000720cULL, 0x000fc40002fa1470ULL, 0x000000ab8300720cULL, 0x0c0fe40000701070ULL,
0x000000ab8300720cULL, 0x080fe40001741070ULL, 0x000000ab7f00720cULL, 0x080fe40001f61070ULL,
0x000000ab7d00720cULL, 0x0c0fe40002781070ULL, 0x000000ab7d00720cULL, 0x080fe40000f21070ULL,
0x000000ab6f00720cULL, 0x000fc40002fa1070ULL, 0x000000a097a07219ULL, 0x000fe400000006ffULL,
0x000054107b7b7816ULL, 0x000fe40000000080ULL, 0x00005410712c7816ULL, 0x000fe4000000002cULL,
0x000054107c537816ULL, 0x000fe40000000053ULL, 0xff80000047477808ULL, 0x000fe40000000000ULL,
0xff80000027277808ULL, 0x000fc40001000000ULL, 0xff80000042427808ULL, 0x000fe40001800000ULL,
0xff80000021217808ULL, 0x000fe40002000000ULL, 0xff80000023237808ULL, 0x000fe40000800000ULL,
0xff8000003e3e7808ULL, 0x000fe40002800000ULL, 0x000000a79aff7212ULL, 0x000fe400078cc0ffULL,
0x000000139dff7212ULL, 0x000fc4000780c0ffULL, 0x000000529dff7212ULL, 0x000fe4000784c0ffULL,
0x0000007b9fff7212ULL, 0x040fe4000786c0ffULL, 0x0000002c9fff7212ULL, 0x0c0fe4000788c0ffULL,
0x000000539fff7212ULL, 0x000fe4000782c0ffULL, 0x0000002ca0ff7212ULL, 0x000fe400078ac0ffULL,
0x000000ab8f00720cULL, 0x000fc400037c1470ULL, 0x000000ab8200720cULL, 0x0c0fe40000701470ULL,
0x000000ab8200720cULL, 0x080fe40001741470ULL, 0x000000ab7000720cULL, 0x0c0fe40001f61470ULL,
0x000000ab7000720cULL, 0x0c0fe40002781470ULL, 0x000000ab7000720cULL, 0x080fe40000f21470ULL,
0x000000ab6e00720cULL, 0x000fc40002fa1470ULL, 0x000000ab8d00720cULL, 0x080fe400037c1070ULL,
0x000000ab7f00720cULL, 0x0c0fe40000701070ULL, 0x000000ab7f00720cULL, 0x080fe40001741070ULL,
0x000000ab6f00720cULL, 0x0c0fe40001f61070ULL, 0x000000ab6f00720cULL, 0x0c0fe40002781070ULL,
0x000000ab6f00720cULL, 0x000fc40000f21070ULL, 0x000000ab6d00720cULL, 0x000fe40002fa1070ULL,
0x000000b097a17219ULL, 0x040fe400000006ffULL, 0x000000a297a27219ULL, 0x000fe400000006ffULL,
0xff80000049497808ULL, 0x000fe40003000000ULL, 0xff80000020207808ULL, 0x000fe40000000000ULL,
0xff80000022227808ULL, 0x000fc40001000000ULL, 0xff8000003c3c7808ULL, 0x000fe40001800000ULL,
0xff8000001c1c7808ULL, 0x000fe40002000000ULL, 0xff8000001e1e7808ULL, 0x000fe40000800000ULL,
0xff8000001d1d7808ULL, 0x000fe40002800000ULL, 0x0000008b9eff7212ULL, 0x000fe400078cc0ffULL,
0x0000007ba0ff7212ULL, 0x000fc4000780c0ffULL, 0x0000007ba1ff7212ULL, 0x040fe4000784c0ffULL,
0x00000073a0ff7212ULL, 0x040fe4000786c0ffULL, 0x00000053a0ff7212ULL, 0x000fe4000788c0ffULL,
0x00000073a1ff7212ULL, 0x000fe4000782c0ffULL, 0x0000002ca2ff7212ULL, 0x000fe200078ac0ffULL,
0x000000015cae7824ULL, 0x000fe200078e0a50ULL, 0x000000ab8100720cULL, 0x000fc400037c1470ULL,
0x000000ab6e00720cULL, 0x0c0fe40000701470ULL, 0x000000ab6e00720cULL, 0x0c0fe40001f61470ULL,
0x000000ab6e00720cULL, 0x080fe40002781470ULL, 0x000000ab6c00720cULL, 0x0c0fe40001741470ULL,
0x000000ab6c00720cULL, 0x080fe40000f21470ULL, 0x000000ab6a00720cULL, 0x000fc40002fa1470ULL,
0x00000031aa567812ULL, 0x040fe400078efcffULL, 0x00000038aa557812ULL, 0x042fe400078efcffULL,
0x00000039aa547812ULL, 0x000fe400078efcffULL, 0x000000ab7d00720cULL, 0x080fe400037c1070ULL,
0x000000ab6d00720cULL, 0x0c0fe40000701070ULL, 0x000000ab6d00720cULL, 0x000fc40001f61070ULL,
0x000000ab6d00720cULL, 0x080fe40002781070ULL, 0x000000ab6800720cULL, 0x0c0fe40001741070ULL,
0x000000ab6800720cULL, 0x080fe40000f21070ULL, 0x000000ab6600720cULL, 0x000fe40002fa1070ULL,
0x000000ae97a37219ULL, 0x000fe400000006ffULL, 0x0000541064647816ULL, 0x000fc4000000006bULL,
0x00005410674c7816ULL, 0x000fe2000000004cULL, 0x0000000a565b7c36ULL, 0x000fe20008000000ULL,
0xff80000041417808ULL, 0x000fe20003000000ULL, 0x0000000a55597c36ULL, 0x000fe20008000000ULL,
0xff8000003d3d7808ULL, 0x000fe20000000000ULL, 0x0000000a54587c36ULL, 0x000fe20008000000ULL,
0xff8000003f3f7808ULL, 0x000fe40001800000ULL, 0xff8000001f1f7808ULL, 0x000fe40002000000ULL,
0xff80000038387808ULL, 0x000fc40001000000ULL, 0xff8000003a3a7808ULL, 0x000fe40000800000ULL,
0xff80000019197808ULL, 0x000fe40002800000ULL, 0x0000007ba2ff7212ULL, 0x040fe400078cc0ffULL,
0x00000073a2ff7212ULL, 0x000fe4000780c0ffULL, 0x0000002ca1ff7212ULL, 0x040fe4000786c0ffULL,
0x00000053a1ff7212ULL, 0x000fc4000788c0ffULL, 0x00000053a2ff7212ULL, 0x000fe4000784c0ffULL,
0x00000064a3ff7212ULL, 0x040fe4000782c0ffULL, 0x0000004ca3ff7212ULL, 0x000fe200078ac0ffULL,
0x000000015ba47824ULL, 0x100fe200078e0a50ULL, 0x000000ab6c00720cULL, 0x0c0fe20001f61470ULL,
0x0000000159ac7824ULL, 0x100fe200078e0a50ULL, 0x000000ab6c00720cULL, 0x080fe20002781470ULL,
0x0000000158507824ULL, 0x000fe200078e0a50ULL, 0x000000ab6a00720cULL, 0x000fc400037c1470ULL,
0x000000ab6a00720cULL, 0x0c0fe40000701470ULL, 0x000000ab6a00720cULL, 0x080fe40001741470ULL,
0x000000ab5c00720cULL, 0x0c0fe40000f21470ULL, 0x000000ab5c00720cULL, 0x080fe40002fa1470ULL,
0x000000ab6800720cULL, 0x0c0fe40001f61070ULL, 0x000000ab6800720cULL, 0x000fc40002781070ULL,
0x000000ab6600720cULL, 0x0c0fe400037c1070ULL, 0x000000ab6600720cULL, 0x0c0fe40000701070ULL,
0x000000ab6600720cULL, 0x080fe40001741070ULL, 0x000000ab5700720cULL, 0x0c0fe40000f21070ULL,
0x000000ab5700720cULL, 0x000fe40002fa1070ULL, 0x000000a497a47219ULL, 0x000fc400000006ffULL,
0x000000ac97a57219ULL, 0x040fe400000006ffULL, 0x0000005097507219ULL, 0x000fe400000006ffULL,
0x0000541062627816ULL, 0x000fe40000000069ULL, 0xff80000018187808ULL, 0x000fe40001800000ULL,
0xff8000001a1a7808ULL, 0x000fe40002000000ULL, 0xff80000039397808ULL, 0x000fc40003000000ULL,
0xff8000003b3b7808ULL, 0x000fe40000000000ULL, 0xff8000001b1b7808ULL, 0x000fe40001000000ULL,
0xff80000034347808ULL, 0x000fe40000800000ULL, 0xff80000014147808ULL, 0x000fe40002800000ULL,
0x00000064a4ff7212ULL, 0x080fe4000786c0ffULL, 0x00000064a5ff7212ULL, 0x000fc4000788c0ffULL,
0x0000006450ff7212ULL, 0x000fe400078cc0ffULL, 0x00000062a3ff7212ULL, 0x080fe4000780c0ffULL,
0x00000062a4ff7212ULL, 0x0c0fe4000784c0ffULL, 0x00000062a5ff7212ULL, 0x000fe4000782c0ffULL,
0x0000004ca4ff7212ULL, 0x000fe400078ac0ffULL, 0x000000ab5c00720cULL, 0x000fc40000701470ULL,
0x000000ab5b00720cULL, 0x0c0fe40001f61470ULL, 0x000000ab5b00720cULL, 0x0c0fe40001741470ULL,
0x000000ab5b00720cULL, 0x080fe40002fa1470ULL, 0x000000ab5900720cULL, 0x0c0fe40002781470ULL,
0x000000ab5800720cULL, 0x080fe400037c1470ULL, 0x000000ab5900720cULL, 0x000fc40000f21470ULL,
0x000000ab5700720cULL, 0x080fe40000701070ULL, 0x000000ab5600720cULL, 0x0c0fe40001f61070ULL,
0x000000ab5600720cULL, 0x0c0fe40001741070ULL, 0x000000ab5600720cULL, 0x080fe40002fa1070ULL,
0x000000ab5500720cULL, 0x0c0fe40002781070ULL, 0x000000ab5500720cULL, 0x000fc40000f21070ULL,
0x000000ab5400720cULL, 0x000fe400037c1070ULL, 0x0000541060607816ULL, 0x000fe40000000065ULL,
0xff80000036367808ULL, 0x000fe40000000000ULL, 0xff80000035357808ULL, 0x000fe40001800000ULL,
0xff80000037377808ULL, 0x000fe40001000000ULL, 0xff80000015157808ULL, 0x000fc40002800000ULL,
0xff80000030307808ULL, 0x000fe40002000000ULL, 0xff80000032327808ULL, 0x000fe40000800000ULL,
0xff80000031317808ULL, 0x000fe40003000000ULL, 0x0000006250ff7212ULL, 0x040fe4000780c0ffULL,
0x0000004ca5ff7212ULL, 0x080fe4000786c0ffULL, 0x0000004c50ff7212ULL, 0x000fc4000784c0ffULL,
0x00000060a3ff7212ULL, 0x080fe400078ac0ffULL, 0x00000060a4ff7212ULL, 0x080fe4000788c0ffULL,
0x00000060a5ff7212ULL, 0x080fe4000782c0ffULL, 0x0000006050ff7212ULL, 0x000fe400078cc0ffULL,
0x000000ab5c00720cULL, 0x080fe40002fa1470ULL, 0x000000ab5b00720cULL, 0x000fc40002781470ULL,
0x000000ab5900720cULL, 0x0c0fe40001f61470ULL, 0x000000ab5900720cULL, 0x080fe40000f21470ULL,
0x000000ab5800720cULL, 0x0c0fe40000701470ULL, 0x000000ab5800720cULL, 0x0c0fe40001741470ULL,
0x000000ab5800720cULL, 0x080fe400037c1470ULL, 0x000000ab5700720cULL, 0x000fc40002fa1070ULL,
0x000000ab5600720cULL, 0x080fe40002781070ULL, 0x000000ab5400720cULL, 0x0c0fe40000701070ULL,
0x000000ab5500720cULL, 0x0c0fe40001f61070ULL, 0x000000ab5500720cULL, 0x080fe40000f21070ULL,
0x000000ab5400720cULL, 0x0c0fe40001741070ULL, 0x000000ab5400720cULL, 0x000fc400037c1070ULL,
0xff80000033337808ULL, 0x000fe40000000000ULL, 0xff8000000a0a7808ULL, 0x000fe40001800000ULL,
0xff8000000c0c7808ULL, 0x000fe40001000000ULL, 0xff80000016167808ULL, 0x000fe40002800000ULL,
0xff80000017177808ULL, 0x000fe40002000000ULL, 0xff8000000e0e7808ULL, 0x000fc40000800000ULL,
0xff80000010107808ULL, 0x000fce0003000000ULL, 0x0000000d0400720bULL, 0x004fe20003f1e000ULL,
0x0000000172727836ULL, 0x000fe20000000000ULL, 0xfffffff8ff5a7812ULL, 0x000fe400078ee25aULL,
0x000000040d047208ULL, 0x000fc80004000000ULL, 0x0000004d0400720bULL, 0x000fc80003f1e000ULL,
0x000000044d137208ULL, 0x000fc80004000000ULL, 0x000000481300720bULL, 0x000fc80003f1e000ULL,
0x0000001348047208ULL, 0x000fc80004000000ULL, 0x000000490400720bULL, 0x000fc80003f1e000ULL,
0x0000000449137208ULL, 0x000fc80004000000ULL, 0x000000441300720bULL, 0x000fc80003f1e000ULL,
0x0000001344047208ULL, 0x000fc80004000000ULL, 0x000000450400720bULL, 0x000fc80003f1e000ULL,
0x0000000445137208ULL, 0x000fc80004000000ULL, 0x000000401300720bULL, 0x000fc80003f1e000ULL,
0x0000001340047208ULL, 0x000fc80004000000ULL, 0x000000410400720bULL, 0x000fc80003f1e000ULL,
0x0000000441137208ULL, 0x000fc80004000000ULL, 0x0000003c1300720bULL, 0x000fc80003f1e000ULL,
0x000000133c047208ULL, 0x000fc80004000000ULL, 0x0000003d0400720bULL, 0x000fc80003f1e000ULL,
0x000000043d137208ULL, 0x000fc80004000000ULL, 0x000000381300720bULL, 0x000fc80003f1e000ULL,
0x0000001338047208ULL, 0x000fc80004000000ULL, 0x000000390400720bULL, 0x000fc80003f1e000ULL,
0x0000000439137208ULL, 0x000fc80004000000ULL, 0x000000341300720bULL, 0x000fc80003f1e000ULL,
0x0000001334047208ULL, 0x000fc80004000000ULL, 0x000000350400720bULL, 0x000fc80003f1e000ULL,
0x0000000435137208ULL, 0x000fc80004000000ULL, 0x000000301300720bULL, 0x000fc80003f1e000ULL,
0x0000001330047208ULL, 0x000fe40004000000ULL, 0x0000004e0500720bULL, 0x000fe40003f1e000ULL,
0x000000310400720bULL, 0x000fc80003f3e000ULL, 0x0000000431127208ULL, 0x000fe40004800000ULL,
0x000000054e047208ULL, 0x000fc60004000000ULL, 0x0c401f0012137f89ULL, 0x000ee200000e0000ULL,
0x0000004f0400720bULL, 0x000fc80003f1e000ULL, 0x000000044f057208ULL, 0x000fc80004000000ULL,
0x0000004a0500720bULL, 0x000fc80003f1e000ULL, 0x000000054a047208ULL, 0x000fc80004000000ULL,
0x0000004b0400720bULL, 0x000fc80003f1e000ULL, 0x000000044b057208ULL, 0x000fe40004000000ULL,
0x000000131200720bULL, 0x008fe40003f3e000ULL, 0x000000460500720bULL, 0x000fe40003f1e000ULL,
0x0000001213137208ULL, 0x000fe40004800000ULL, 0x0000000546047208ULL, 0x000fc60004000000ULL,
0x0c201f0013127f89ULL, 0x000ee200000e0000ULL, 0x000000470400720bULL, 0x000fc80003f1e000ULL,
0x0000000447057208ULL, 0x000fc80004000000ULL, 0x000000420500720bULL, 0x000fc80003f1e000ULL,
0x0000000542047208ULL, 0x000fc80004000000ULL, 0x000000430400720bULL, 0x000fc80003f1e000ULL,
0x0000000443057208ULL, 0x000fe40004000000ULL, 0x000000121300720bULL, 0x008fe40003f3e000ULL,
0x0000003e0500720bULL, 0x000fe40003f1e000ULL, 0x0000001312047208ULL, 0x000fe40004800000ULL,
0x000000053e127208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b04507820ULL, 0x000fe20000410000ULL,
0x0000003f1200720bULL, 0x000fc60003f1e000ULL, 0x3fb8aa3b442c7823ULL, 0x100fe20000010850ULL,
0x000000123f057208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b4d4c7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b0d0d7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b48487823ULL, 0x100fe20000010850ULL,
0x0000003a0500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b49497823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b45457823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b40407823ULL, 0x100fe20000010850ULL,
0x000000053a127208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b41417823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b3d3d7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b38387823ULL, 0x100fe20000010850ULL,
0x0000003b1200720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b39397823ULL, 0x000fe20000010850ULL,
0x0000000d000d7308ULL, 0x000fe40000000800ULL, 0x000000123b057208ULL, 0x000fc80004000000ULL,
0x000000360500720bULL, 0x000fe40003f1e000ULL, 0x0000004c004c7308ULL, 0x000fe40000000800ULL,
0x0000000536127208ULL, 0x000fc80004000000ULL, 0x000000371200720bULL, 0x000fe40003f1e000ULL,
0x0000004000407308ULL, 0x000fe40000000800ULL, 0x0000001237057208ULL, 0x000fc80004000000ULL,
0x000000320500720bULL, 0x000fe40003f1e000ULL, 0x0000004100417308ULL, 0x000fe40000000800ULL,
0x0000000532127208ULL, 0x000fc80004000000ULL, 0x000000331200720bULL, 0x000fe40003f1e000ULL,
0x0000004800487308ULL, 0x000fe40000000800ULL, 0x0000001233137208ULL, 0x000fe20004000000ULL,
0x3fb8aa3b3c127823ULL, 0x100fe20000010850ULL, 0x0000000f0600720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b313c7823ULL, 0x000fe40000010850ULL, 0x0c401f0013447f89ULL, 0x000ee200000e0000ULL,
0x000000060f067208ULL, 0x000fe20004000000ULL, 0x0000004900497308ULL, 0x000fe60000000800ULL,
0x0000002d0600720bULL, 0x000fc80003f1e000ULL, 0x000000062d057208ULL, 0x000fe20004000000ULL,
0x0000002c002c7308ULL, 0x000fe60000000800ULL, 0x000000280500720bULL, 0x000fc80003f1e000ULL,
0x0000000528067208ULL, 0x000fe20004000000ULL, 0x0000004500457308ULL, 0x000fe60000000800ULL,
0x000000290600720bULL, 0x000fe40003f1e000ULL, 0x000000441300720bULL, 0x008fe40003f3e000ULL,
0x0000000629057208ULL, 0x000fe20004000000ULL, 0x0000001200127308ULL, 0x000fe20000000800ULL,
0x0000001344447208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b34137823ULL, 0x100fe20000010850ULL,
0x000000240500720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b35347823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b30357823ULL, 0x000fe20000010850ULL, 0x0c201f0044517f89ULL, 0x000ee200000e0000ULL,
0x0000000524067208ULL, 0x000fe20004000000ULL, 0x0000003d003d7308ULL, 0x000fe60000000800ULL,
0x000000250600720bULL, 0x000fc80003f1e000ULL, 0x0000000625057208ULL, 0x000fe20004000000ULL,
0x0000003800387308ULL, 0x000fe60000000800ULL, 0x000000200500720bULL, 0x000fc80003f1e000ULL,
0x0000000520067208ULL, 0x000fe20004000000ULL, 0x0000003900397308ULL, 0x000fe60000000800ULL,
0x000000210600720bULL, 0x000fe40003f1e000ULL, 0x000000514400720bULL, 0x008fe40003f3e000ULL,
0x00000006214d7208ULL, 0x000fe20004000000ULL, 0x0000001300137308ULL, 0x000fe20000000800ULL,
0x0000004451057208ULL, 0x000fc40004800000ULL, 0x0000001c4d00720bULL, 0x000fc60003f1e000ULL,
0x3fb8aa3b05507820ULL, 0x000fe20000410000ULL, 0x0000004d1c067208ULL, 0x000fe20004000000ULL,
0x0000003400347308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b4a447823ULL, 0x100fe20000010850ULL,
0x0000001d0600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b4f4f7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b4e307823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b4b4b7823ULL, 0x100fe20000010850ULL,
0x000000061d317208ULL, 0x000fe20004000000ULL, 0x0000004400447308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b46467823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b47477823ULL, 0x100fe20000010850ULL,
0x000000183100720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b3e3e7823ULL, 0x100fe20000010850ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010850ULL,
0x0000003118067208ULL, 0x000fe20004000000ULL, 0x0000003000307308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b3b3b7823ULL, 0x100fe20000010850ULL, 0x3fb8aa3b36367823ULL, 0x100fe20000010850ULL,
0x000000190600720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b37377823ULL, 0x000fc60000010850ULL,
0x00000006194d7208ULL, 0x000fe20004000000ULL, 0x0000004f00317308ULL, 0x0007620000000800ULL,
0x0000002e0700720bULL, 0x000fe40003f1e000ULL, 0x000000144d00720bULL, 0x000fe40003f3e000ULL,
0x000000072e067208ULL, 0x000fe40004000000ULL, 0x0000004d144a7208ULL, 0x000fe20004800000ULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x0000002f0600720bULL, 0x000fc40003f1e000ULL,
0x000000154a00720bULL, 0x000fe40003f3e000ULL, 0x000000062f077208ULL, 0x000fe40004000000ULL,
0x0000004a154d7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b424a7823ULL, 0x000fe20000010850ULL,
0x0000002a0700720bULL, 0x000fe20003f1e000ULL, 0x0000004600467308ULL, 0x000fe20000000800ULL,
0x0000000a4d00720bULL, 0x000fe40003f3e000ULL, 0x000000072a067208ULL, 0x000fc40004000000ULL,
0x0000004d0a4d7208ULL, 0x000fe40004800000ULL, 0x0000002b0600720bULL, 0x000fe20003f1e000ULL,
0x0000004700477308ULL, 0x000f620000000800ULL, 0x0000000c4d00720bULL, 0x000fe40003f3e000ULL,
0x000000062b077208ULL, 0x000fe40004000000ULL, 0x0000004d0c427208ULL, 0x000fe20004800000ULL,
0x3fb8aa3b434d7823ULL, 0x100fe20000010850ULL, 0x000000260700720bULL, 0x000fe20003f1e000ULL,
0x3fb8aa3b33437823ULL, 0x000fe20000010850ULL, 0x0000004a004a7308ULL, 0x000fe20000000800ULL,
0x0c401f00424f7f89ULL, 0x008ee200000e0000ULL, 0x0000000726067208ULL, 0x000fc80004000000ULL,
0x000000270600720bULL, 0x000fe40003f1e000ULL, 0x0000004d004d7308ULL, 0x000fe40000000800ULL,
0x0000000627077208ULL, 0x000fc80004000000ULL, 0x000000220700720bULL, 0x000fe40003f1e000ULL,
0x0000003500357308ULL, 0x000fe40000000800ULL, 0x0000000722067208ULL, 0x000fc80004000000ULL,
0x000000230600720bULL, 0x000fe40003f1e000ULL, 0x0000003c003c7308ULL, 0x000fe20000000800ULL,
0x0000004f4200720bULL, 0x008fe40003f3e000ULL, 0x0000000623077208ULL, 0x000fe40004000000ULL,
0x000000424f4f7208ULL, 0x000fe20004800000ULL, 0x3fb8aa3b32427823ULL, 0x000fe20000010850ULL,
0x0000001e0700720bULL, 0x000fe20003f1e000ULL, 0x0000003e003e7308ULL, 0x000fe40000000800ULL,
0x0c201f004f4e7f89ULL, 0x000ee200000e0000ULL, 0x000000071e067208ULL, 0x000fc80004000000ULL,
0x0000001f0600720bULL, 0x000fe20003f1e000ULL, 0x0000003f003f7308ULL, 0x000fe60000000800ULL,
0x000000061f077208ULL, 0x000fc80004000000ULL, 0x0000001a0700720bULL, 0x000fe20003f1e000ULL,
0x0000003a003a7308ULL, 0x000fe60000000800ULL, 0x000000071a067208ULL, 0x000fc80004000000ULL,
0x0000001b0600720bULL, 0x000fe20003f1e000ULL, 0x0000003b003b7308ULL, 0x000fe20000000800ULL,
0x0000004e4f00720bULL, 0x008fe40003f3e000ULL, 0x000000061b077208ULL, 0x000fe40004000000ULL,
0x0000004f4e067208ULL, 0x000fe40004800000ULL, 0x000000160700720bULL, 0x000fe20003f1e000ULL,
0x0000003600367308ULL, 0x000fe40000000800ULL, 0x3fb8aa3b06337820ULL, 0x000fe20000410000ULL,
0x0000000716327208ULL, 0x000fc60004000000ULL, 0x3fb8aa3b284e7823ULL, 0x100fe20000010833ULL,
0x000000173200720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b19527823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b0f0f7823ULL, 0x100fe20000010833ULL, 0x0000004e00547308ULL, 0x0007e20000000800ULL,
0x0000003217077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b29297823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b1d4f7823ULL, 0x100fe20000010833ULL,
0x0000000e0700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b24247823ULL, 0x100fe20000010833ULL, 0x0000000f00327308ULL, 0x000be20000000800ULL,
0x000000070e077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b1c4e7823ULL, 0x108fe20000010833ULL,
0x3fb8aa3b25257823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b20207823ULL, 0x100fe20000010833ULL,
0x000000100700720bULL, 0x000fe20003f1e000ULL, 0x3fb8aa3b18517823ULL, 0x100fe20000010833ULL,
0x3fb8aa3b15507823ULL, 0x100fe20000010833ULL, 0x0000002d00557308ULL, 0x000fe20000000800ULL,
0x0000000710077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b140f7823ULL, 0x122fe20000010833ULL,
0x3fb8aa3b0a0a7823ULL, 0x100fe20000010833ULL, 0x3fb8aa3b0c537823ULL, 0x000fe20000010833ULL,
0x3c003c00ff0c7424ULL, 0x000fe200078e00ffULL, 0x0c401f0007287f89ULL, 0x000e6400000e0000ULL,
0x0000002900297308ULL, 0x000ef00000000800ULL, 0x0000002100597308ULL, 0x000bf00000000800ULL,
0x0000002000587308ULL, 0x0007e20000000800ULL, 0x000000303121723eULL, 0x020fc400000000ffULL,
0x000000280700720bULL, 0x002fca0003f1e000ULL, 0x0000002400567308ULL, 0x0003e20000000800ULL,
0x0000000d4c20723eULL, 0x008fe200000000ffULL, 0x3c003c00ff0d7424ULL, 0x000fe200078e00ffULL,
0x0000000728077208ULL, 0x000fca0004000000ULL, 0x0c201f00071c7f89ULL, 0x000ee200000e0000ULL,
0x0000002c4524723eULL, 0x002fe200000000ffULL, 0x0000002500577308ULL, 0x0003f00000000800ULL,
0x0000003700377308ULL, 0x000fe20000000800ULL, 0x000000464725723eULL, 0x002fe200000000ffULL,
0x000000085a477836ULL, 0x000fcc0000000000ULL, 0x0000004e004e7308ULL, 0x000fe20000000800ULL,
0x0000001c0700720bULL, 0x008fce0003f1e000ULL, 0x0000004f004f7308ULL, 0x000fe20000000800ULL,
0x000000071c077208ULL, 0x000fe40004000000ULL, 0x000000030bff7812ULL, 0x000fc6000780c0ffULL,
0x3fb8aa3b07197820ULL, 0x000fe40000410000ULL, 0x0000005100517308ULL, 0x000fe40000000800ULL,
0x3fb8aa3b2a2a7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe20000010819ULL,
0x3fb8aa3b221c7823ULL, 0x100fe20000010819ULL, 0x3fb8aa3b23287823ULL, 0x100fe20000010819ULL,
0x0000002e001d7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b26267823ULL, 0x100fe20000010819ULL,
0x000000484922723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b1e317823ULL, 0x100fe20000010819ULL,
0x000000444b23723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b27277823ULL, 0x100fe20000010819ULL,
0x00000054291e723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010819ULL,
0x0000002f00147308ULL, 0x0002e20000000800ULL, 0x3fb8aa3b1b1b7823ULL, 0x000fe20000010819ULL,
0x000000105a497836ULL, 0x000fc40000000000ULL, 0x3fb8aa3b0e0e7823ULL, 0x100fe20000010819ULL,
0x000000185a4b7836ULL, 0x000fe40000000000ULL, 0x3fb8aa3b10107823ULL, 0x000fe20000010819ULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x0000000c202c723cULL, 0x002fe200000018ffULL,
0x0000001d141d723eULL, 0x008fcc00000000ffULL, 0x0000002b002b7308ULL, 0x000e700000000800ULL,
0x0000001c00337308ULL, 0x0007f00000000800ULL, 0x0000002800307308ULL, 0x000a620000000800ULL,
0x00000032551c723eULL, 0x008fe200000000ffULL, 0x0000000849557824ULL, 0x000fc400078e00ffULL,
0x0000000849497824ULL, 0x000fc800078e00ffULL, 0x0000002600157308ULL, 0x0007e20000000800ULL,
0x000000565728723eULL, 0x020fe200000000ffULL, 0x000000084b577824ULL, 0x040fe200078e00ffULL,
0x00000003ff567819ULL, 0x000fe2000001160bULL, 0x000000084b4b7824ULL, 0x000fc600078e00ffULL,
0x000000040b147810ULL, 0x000fe20007ffe056ULL, 0x0000002700187308ULL, 0x000b620000000800ULL,
0x000000404126723eULL, 0x008fe200000000ffULL, 0x3fb8aa3b1f417823ULL, 0x000fe20000010819ULL,
0x0000002a2b1f723eULL, 0x002fe400000000ffULL, 0x00000033302b723eULL, 0x000fe400000000ffULL,
0x00000058592a723eULL, 0x000fe200000000ffULL, 0x0000003100407308ULL, 0x0003e20000000800ULL,
0x0000004a4d27723eULL, 0x020fe200000000ffULL, 0x00000008474d7824ULL, 0x040fe200078e00ffULL,
0x0000000714147812ULL, 0x000fe200078ec0ffULL, 0x0000000847477824ULL, 0x000fe200078e00ffULL,
0x000000151829723eULL, 0x000fc600000000ffULL, 0x0000000c242c723cULL, 0x000fe2000000182cULL,
0x0000005200527308ULL, 0x000ee20000000800ULL, 0x000000085a157824ULL, 0x000fe400078e00ffULL,
0x3fb8aa3b16187823ULL, 0x000fe20000010819ULL, 0xfffffff84d4a7812ULL, 0x000fe200078ee214ULL,
0x0000000c1c30723cULL, 0x002fe200000018ffULL, 0xfffffff815487812ULL, 0x000fe400078ee214ULL,
0x0000004100417308ULL, 0x000e620000000800ULL, 0xfffffff8554c7812ULL, 0x000fc400078ee214ULL,
0xfffffff857547812ULL, 0x000fe400078ee214ULL, 0x000000123d14723eULL, 0x000fe200000000ffULL,
0x3fb8aa3b17127823ULL, 0x000fe20000010819ULL, 0x000000383916723eULL, 0x000fe200000000ffULL,
0x0000001a00447308ULL, 0x000be20000000800ULL, 0x0000003e3f15723eULL, 0x000fe400000000ffULL,
0x0000003a3b17723eULL, 0x000fe200000000ffULL, 0x000000085a3b7824ULL, 0x000fe200078e00ffULL,
0x000000363719723eULL, 0x000fe200000000ffULL, 0x00001000783a7824ULL, 0x000fe200078e0209ULL,
0x000000515236723eULL, 0x008fe200000000ffULL, 0x0000001b00457308ULL, 0x000ee20000000800ULL,
0x000000353c1a723eULL, 0x020fe200000000ffULL, 0x0000000c142c723cULL, 0x000fe2000000182cULL,
0x000000404135723eULL, 0x002fca00000000ffULL, 0x0000000c2830723cULL, 0x000fe20000001830ULL,
0x0000001800467308ULL, 0x0003e20000000800ULL, 0x000000444537723eULL, 0x008fce00000000ffULL,
0x0000004200427308ULL, 0x000fe20000000800ULL, 0x000000133418723eULL, 0x002fe400000000ffULL,
0x0000004e4f34723eULL, 0x000fca00000000ffULL, 0x0000004300437308ULL, 0x000e6e0000000800ULL,
0x0000000c3430723cULL, 0x000fe20000001830ULL, 0x0000000a000a7308ULL, 0x000fe20000000800ULL,
0x00000042431b723eULL, 0x002fce00000000ffULL, 0x0000005300537308ULL, 0x000e620000000800ULL,
0x0000000c182c723cULL, 0x000fee000000182cULL, 0x0000000f000f7308ULL, 0x000fe20000000800ULL,
0x0000000a5352723eULL, 0x002fce00000000ffULL, 0x0000005000507308ULL, 0x000e700000000800ULL,
0x0000001200397308ULL, 0x0007620000000800ULL, 0x000000ffff2d7224ULL, 0x000fe200078e002eULL,
0x0000000f5050723eULL, 0x002fcc00000000ffULL, 0x0000000e000e7308ULL, 0x000fe20000000800ULL,
0x0000000356127812ULL, 0x008fe200078ec0ffULL, 0x000120003a0f7836ULL, 0x000fe40000000000ULL,
0x000000ffff3a7224ULL, 0x000fe400078e0024ULL, 0x0000000112127824ULL, 0x000fe200078e020bULL,
0x000000463951723eULL, 0x020fe200000000ffULL, 0x0000001000137308ULL, 0x000e620000000800ULL,
0x0000001048487824ULL, 0x100fe400078e020fULL, 0x0000000712127812ULL, 0x000fe200078ec0ffULL,
0x000000104a4a7824ULL, 0x000fc400078e020fULL, 0x000000104c4c7824ULL, 0x100fe200078e020fULL,
0xfffffff83b387812ULL, 0x000fe200078ee212ULL, 0x000000ffff397224ULL, 0x000fe200078e0022ULL,
0xfffffff8473c7812ULL, 0x000fe200078ee212ULL, 0x000000ffff3b7224ULL, 0x000fe200078e0026ULL,
0xfffffff8493e7812ULL, 0x000fe200078ee212ULL, 0x00000010380a7824ULL, 0x100fe200078e020fULL,
0xfffffff84b127812ULL, 0x000fe200078ee212ULL, 0x000000ffff387224ULL, 0x000fe200078e0020ULL,
0x0000000e1353723eULL, 0x002fe200000000ffULL, 0x0000001054547824ULL, 0x000fc400078e020fULL,
0x000000103c3c7824ULL, 0x100fe200078e020fULL, 0x000000380a007844ULL, 0x0003e20000000200ULL,
0x000000103e3e7824ULL, 0x100fe400078e020fULL, 0x0000000c5030723cULL, 0x000fe20000001830ULL,
0x0000001012127824ULL, 0x000fe400078e020fULL, 0x000000ffff207224ULL, 0x000fe400078e0021ULL,
0x000000ffff0e7224ULL, 0x000fe400078e0018ULL, 0x000000ffff0c7224ULL, 0x000fc400078e0014ULL,
0x000000ffff0d7224ULL, 0x000fe400078e0016ULL, 0x000000ffff0f7224ULL, 0x000fe400078e001aULL,
0x000000ffff217224ULL, 0x000fe400078e0023ULL, 0x000000ffff147224ULL, 0x000fe200078e0015ULL,
0x0000000c48007844ULL, 0x0007e20000000200ULL, 0x000000ffff227224ULL, 0x000fe400078e0025ULL,
0x000000ffff237224ULL, 0x000fc400078e0027ULL, 0x000000ffff157224ULL, 0x000fe400078e0017ULL,
0x000000ffff167224ULL, 0x000fe200078e0019ULL, 0x000000203c007844ULL, 0x0007e20000000200ULL,
0x000000ffff177224ULL, 0x000fe400078e001bULL, 0x000000ffff187224ULL, 0x000fe400078e001cULL,
0x000000ffff197224ULL, 0x000fe200078e001eULL, 0x000000144a007844ULL, 0x0007e20000000200ULL,
0x000000ffff1a7224ULL, 0x000fc400078e0028ULL, 0x000000ffff1b7224ULL, 0x000fe400078e002aULL,
0x000000ffff1c7224ULL, 0x000fe400078e001dULL, 0x000000ffff247224ULL, 0x000fe200078e0034ULL,
0x000000183e007844ULL, 0x0007e20000000200ULL, 0x000000ffff257224ULL, 0x000fe400078e0036ULL,
0x000000ffff267224ULL, 0x000fe400078e0050ULL, 0x000000ffff277224ULL, 0x000fc400078e0052ULL,
0x000000ffff1d7224ULL, 0x000fe400078e001fULL, 0x000000ffff1e7224ULL, 0x000fe200078e0029ULL,
0x000000244c007844ULL, 0x0007e20000000200ULL, 0x000000ffff1f7224ULL, 0x000fe400078e002bULL,
0x000000ffff287224ULL, 0x000fe400078e0035ULL, 0x000000ffff297224ULL, 0x000fe200078e0037ULL,
0x0000001c12007844ULL, 0x0007e20000000200ULL, 0x000000ffff2a7224ULL, 0x000fc400078e0051ULL,
0x000000ffff2b7224ULL, 0x000fe400078e0053ULL, 0x000000ffff2e7224ULL, 0x000fe400078e0030ULL,
0x000000ffff2f7224ULL, 0x000fe200078e0032ULL, 0x0000002854007844ULL, 0x0007e20000000200ULL,
0x00000001ff0a7424ULL, 0x002fc600078e00ffULL, 0x01a0000411008388ULL, 0x0007e80000000c00ULL,
0x01a2002c11008388ULL, 0x0007e20000000c00ULL, 0x000000617200720cULL, 0x000fe20003f06070ULL,
0x01a6080a75ff79a7ULL, 0x000fe2000850003fULL, 0x01a6100a75ff79a7ULL, 0x000fe2000850003fULL,
0x01a6180a75ff79a7ULL, 0x000fe2000850003fULL, 0x01a6200a75ff79a7ULL, 0x0003e4000850003fULL,
0x000000ffff0a7224ULL, 0x002fce00078e005dULL, 0xffffff9000c88947ULL, 0x00cfea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x0180000083007836ULL, 0x000fe20000000000ULL,
0x0000013000017945ULL, 0x000fe80003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000008300008308ULL, 0x0002a20000001000ULL,
0x0000000000388947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x00000000001c8947ULL, 0x000fea0003800000ULL, 0x007fffff83ff7812ULL, 0x040fe4000780c0ffULL,
0x8000000083027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000000000047947ULL, 0x000fec0003800000ULL,
0x0000008300007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffffe9402dc7950ULL, 0x000fea0003c3ffffULL, 0xfffffffc00fc7947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000111ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000017bULL, 0x00000000000004e3ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000660ULL, 0x0000000000000228ULL, 0x0000001500000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000c8ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000888ULL, 0x00000000000000e0ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000968ULL, 0x0000000000000054ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009bcULL, 0x0000000000000700ULL, 0x0000000a00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000004000000b2ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010c0ULL, 0x0000000000000000ULL, 0x0000000a00000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000004000000e6ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000010c0ULL, 0x0000000000000048ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001108ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001180ULL, 0x0000000000016980ULL, 0x0000001500000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017b00ULL, 0x0000000000000040ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000017b40ULL, 0x0000000000000400ULL, 0x0000000a00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x00000001000000f8ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000017b40ULL, 0x0000000000000270ULL, 0x0000000a00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000400000006ULL, 0x0000000000018130ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000018130ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000150ULL, 0x0000000000000150ULL, 0x0000000000000008ULL,
0x0000000400000001ULL, 0x0000000000001108ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001180ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000016980ULL,
0x0000000000016980ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x0000000000017b00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000440ULL,
0x0000000000000008ULL, 0x0000000400000001ULL, 0x0000000000017b40ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000270ULL, 0x0000000000000270ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_0_m_32_sm_90_cubin_len = 98944;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
