/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000015cd0ULL, 0x0000000000015950ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x632e766e2e006168ULL,
0x33746e6174736e6fULL, 0x6f6c672e766e2e00ULL, 0x74696e692e6c6162ULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6f632e766e2e0061ULL, 0x0033746e6174736eULL, 0x657a69536d656d73ULL, 0x6f6c672e766e2e00ULL,
0x74696e692e6c6162ULL, 0x7563344e5a5a5f00ULL, 0x5f33647473336164ULL, 0x7465645f5f38345fULL,
0x735f5f31326c6961ULL, 0x5f7265676e6f7274ULL, 0x75635f726564726fULL, 0x5f37456969456164ULL,
0x5f006d726f66785fULL, 0x727241374b4e5a5aULL, 0x6a4c664944327961ULL, 0x324545326a4c4532ULL,
0x454530624c497461ULL, 0x31456a6a664b5245ULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL,
0x7241374b4e5a5a5fULL, 0x5f53494432796172ULL, 0x6a4c45326a4c6649ULL, 0x4c45316a4c454532ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3053ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x5f5f374944327961ULL, 0x326a4c32666c6168ULL,
0x61324545386a4c45ULL, 0x45454530624c4974ULL, 0x456a6a5f30534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL,
0x4c4536316a4c4545ULL, 0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL,
0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6556334944327961ULL,
0x4545346a4c6a4963ULL, 0x316a4c4536316a4cULL, 0x4c49746132454536ULL, 0x534b524545453162ULL,
0x723431456a6a5f31ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4534366aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x4974736e49394944ULL, 0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL,
0x324545316a4c4531ULL, 0x454530624c497461ULL, 0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL,
0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL, 0x4944327961727241ULL, 0x4d6e4974736e4939ULL,
0x4c45346a4c497461ULL, 0x45326a4c4545316aULL, 0x7461324545316a4cULL, 0x5245454530624c49ULL,
0x31456a6a5f31534bULL, 0x72655073776f7234ULL, 0x00676e6964696c53ULL, 0x7241374b4e5a5a5fULL,
0x4939494432796172ULL, 0x74614d6e4974736eULL, 0x326a4c45346a4c49ULL, 0x6a4c45326a4c4545ULL,
0x4c49746132454531ULL, 0x534b524545453062ULL, 0x723431456a6a5f31ULL, 0x6c5372655073776fULL,
0x5a5f00676e696469ULL, 0x61727241374b4e5aULL, 0x6365563349443279ULL, 0x4c4545346a4c6a49ULL,
0x45386a4c4532336aULL, 0x31624c4974613245ULL, 0x5f31534b52454545ULL, 0x776f723431456a6aULL,
0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL, 0x4974736e49394944ULL,
0x326a4c4974614d6eULL, 0x6a4c4545326a4c45ULL, 0x324545316a4c4532ULL, 0x454530624c497461ULL,
0x6a6a5f31534b5245ULL, 0x5073776f72343145ULL, 0x6e6964696c537265ULL, 0x374b4e5a5a5f0067ULL,
0x4944327961727241ULL, 0x6a4c6a4963655633ULL, 0x4c45386a4c454534ULL, 0x497461324545386aULL,
0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL,
0x727241374b4e5a5aULL, 0x6556334944327961ULL, 0x4545346a4c6a4963ULL, 0x386a4c4536316a4cULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5f5f2400676e6964ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f305fULL, 0x5f30326d735f6164ULL,
0x665f6e725f706372ULL, 0x735f3233665f7a74ULL, 0x0068746170776f6cULL, 0x7265746e695f5f24ULL,
0x5f245f315f6c616eULL, 0x6d735f616475635fULL, 0x736c6668735f3037ULL, 0x796c66625f636e79ULL,
0x6e695f5f2400705fULL, 0x325f6c616e726574ULL, 0x616475635f5f245fULL, 0x68735f30376d735fULL,
0x695f636e79736c66ULL, 0x5f5f2400705f7864ULL, 0x6c616e7265746e69ULL, 0x75635f5f245f335fULL,
0x5f30376d735f6164ULL, 0x636e797365746f76ULL, 0x00746f6c6c61625fULL, 0x65742e616c65722eULL,
0x656e72656b2e7478ULL, 0x722e0061686d5f6cULL, 0x2e747865742e6c65ULL, 0x6d5f6c656e72656bULL,
0x6e72656b24006168ULL, 0x732461686d5f6c65ULL, 0x42657479426d656dULL, 0x632e766e2e006675ULL,
0x30746e6174736e6fULL, 0x5f6c656e72656b2eULL, 0x7261705f0061686dULL, 0x756265642e006d61ULL,
0x00656d6172665f67ULL, 0x6265642e6c65722eULL, 0x656d6172665f6775ULL, 0x642e616c65722e00ULL,
0x6172665f67756265ULL, 0x722e766e2e00656dULL, 0x6f697463612e6c65ULL, 0x000000000000006eULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0009000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0009000100000094ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c00030000009dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c0001000000adULL,
0x0000000000000034ULL, 0x0000000000000010ULL, 0x000c0001000000ebULL, 0x000000000000001cULL,
0x0000000000000004ULL, 0x000c000100000124ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c00010000016bULL, 0x000000000000002cULL, 0x0000000000000004ULL, 0x000c0001000001adULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000c0001000001f3ULL, 0x0000000000000024ULL,
0x0000000000000004ULL, 0x000c00010000023aULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000280ULL, 0x0000000000000030ULL, 0x0000000000000004ULL, 0x000c0001000002ceULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c00010000031cULL, 0x0000000000000018ULL,
0x0000000000000004ULL, 0x000c00010000036aULL, 0x000000000000000cULL, 0x0000000000000004ULL,
0x000c0001000003b0ULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c0001000003feULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000443ULL, 0x0000000000000020ULL,
0x0000000000000004ULL, 0x000b002200000489ULL, 0x0000000000013dc0ULL, 0x0000000000000180ULL,
0x000b0022000004bcULL, 0x0000000000013f40ULL, 0x0000000000000040ULL, 0x000b0022000004e7ULL,
0x0000000000013f80ULL, 0x0000000000000050ULL, 0x000b002200000511ULL, 0x0000000000013fd0ULL,
0x0000000000000130ULL, 0x000a00030000057fULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000400030000059fULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00070003000005cfULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL, 0x0000000000000000ULL,
0x0000000000014100ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL, 0x00000034ffffffffULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00013dc000000000ULL, 0x0000040400000000ULL,
0x810c000001340400ULL, 0x004e2c0400288080ULL, 0x0000000000000000ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8b08288080820828ULL, 0x2880809008288080ULL, 0x8096082880809408ULL,
0x0828808097082880ULL, 0x80809c082880809aULL, 0xac082880809d0828ULL, 0x2880808408288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808084ULL, 0x00000034ffffffffULL,
0x0000007000000000ULL, 0x00013dc000000000ULL, 0x0000018000000000ULL, 0x0000480400000000ULL,
0x8080288080820900ULL, 0x0900000010042880ULL, 0x2880808228808084ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8b08288080820828ULL, 0x2880809008288080ULL, 0x8096082880809408ULL,
0x082880809a082880ULL, 0x80809d082880809cULL, 0xb608288080ac0828ULL, 0x2880828016288080ULL,
0x0000000000000310ULL, 0x00288080b6920000ULL, 0x0000000000000022ULL, 0x0000001cffffffffULL,
0x0000013000000000ULL, 0x00013f4000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL,
0x00000074ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080800828808081ULL, 0x8b08288080820828ULL, 0x2880809008288080ULL,
0x8096082880809408ULL, 0x0828808097082880ULL, 0x80809c082880809aULL, 0x9d08288080ac0828ULL,
0x2880828016288080ULL, 0x0000000000000310ULL, 0x002880809d920000ULL, 0x0000000000000022ULL,
0x0000002cffffffffULL, 0x000001d800000000ULL, 0x00013f8000000000ULL, 0x0000005000000000ULL,
0x0000100400000000ULL, 0x80902880809d0900ULL, 0x0000000000002880ULL, 0x0000006cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080800828808081ULL, 0x8b08288080820828ULL, 0x2880809008288080ULL, 0x8096082880809408ULL,
0x082880809a082880ULL, 0x8080ac082880809cULL, 0x80162880809d0828ULL, 0x0000000310288082ULL,
0x809d920000000000ULL, 0x0000000022002880ULL, 0x0000002cffffffffULL, 0x0000029000000000ULL,
0x00013fd000000000ULL, 0x0000013000000000ULL, 0x0000180400000000ULL, 0x80902880809d0900ULL,
0x0000000000002880ULL, 0x0000001a00082f04ULL, 0x000823040000008eULL, 0x0000000000000016ULL,
0x0000001600081204ULL, 0x0008110400000000ULL, 0x0000000000000016ULL, 0x0000001500082304ULL,
0x0008120400000000ULL, 0x0000000000000015ULL, 0x0000001500081104ULL, 0x0008230400000000ULL,
0x0000000000000014ULL, 0x0000001400081204ULL, 0x0008110400000000ULL, 0x0000000000000014ULL,
0x0000001300082304ULL, 0x0008120400000000ULL, 0x0000000000000013ULL, 0x0000001300081104ULL,
0x0008230400000000ULL, 0x000000000000001aULL, 0x0000001a00081204ULL, 0x0008110400000000ULL,
0x000000000000001aULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0050016000000017ULL,
0x000c170400501903ULL, 0x0048000600000000ULL, 0x000c17040021f000ULL, 0x0040000500000000ULL,
0x000c17040021f000ULL, 0x0038000400000000ULL, 0x000c17040011f000ULL, 0x0018000300000000ULL,
0x000c17040081f000ULL, 0x0010000200000000ULL, 0x000c17040021f000ULL, 0x0008000100000000ULL,
0x000c17040021f000ULL, 0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x0000002000043104ULL,
0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x000000e001342804ULL,
0x000003f000000100ULL, 0x00002390000022f0ULL, 0x00002610000024a0ULL, 0x00002ab000002a80ULL,
0x00002b9000002b20ULL, 0x00004e1000004d70ULL, 0x000050a000004f40ULL, 0x0000554000005510ULL,
0x00005620000055b0ULL, 0x000075c000007520ULL, 0x00007850000076f0ULL, 0x00007cf000007cc0ULL,
0x00007dd000007d60ULL, 0x00009d8000009ce0ULL, 0x0000a00000009ea0ULL, 0x0000a4900000a460ULL,
0x0000a5700000a500ULL, 0x0000b6600000b650ULL, 0x0001229000012250ULL, 0x000122b0000122a0ULL,
0x0001232000012300ULL, 0x0001235000012340ULL, 0x0001301000012fb0ULL, 0x000130f000013080ULL,
0x000131f000013170ULL, 0x000132b000013250ULL, 0x0001339000013320ULL, 0x0001348000013410ULL,
0x00013540000134e0ULL, 0x00013620000135b0ULL, 0x00013710000136a0ULL, 0x000137d000013770ULL,
0x000138b000013840ULL, 0x000139a000013930ULL, 0x00013a9000013a10ULL, 0x00013b9000013b10ULL,
0x00013c9000013c10ULL, 0x00013d9000013d10ULL, 0x000001f004403904ULL, 0x00017600000000ffULL,
0x00000260003f0100ULL, 0x0001760800000005ULL, 0x00000370003f0120ULL, 0x0001768800000005ULL,
0x000003a0003f0120ULL, 0x000176a800000005ULL, 0x000003d0003f0120ULL, 0x000176c800000005ULL,
0x00000450003f0120ULL, 0x00017600000000ffULL, 0x00000600003f0107ULL, 0x0000000400000005ULL,
0x000006b0003f0102ULL, 0x0000000000000005ULL, 0x00001000003f0101ULL, 0x00000000000000ffULL,
0x0000108000040107ULL, 0x00000000000000ffULL, 0x000010e000040101ULL, 0x0000002000000012ULL,
0x00001290003f0101ULL, 0x000176cc00000016ULL, 0x00001470003f0105ULL, 0x000176cc00000016ULL,
0x00001e30003f0105ULL, 0x000176a800000044ULL, 0x00001fa0003f0107ULL, 0x000176a800000044ULL,
0x00002000003f0101ULL, 0x0001760800000049ULL, 0x00002020003f0101ULL, 0x0001760c00000049ULL,
0x000021f0003f0105ULL, 0x0001760c00000049ULL, 0x000027e0003f0105ULL, 0x000176ac00000016ULL,
0x000029b0003f0105ULL, 0x000176ac00000016ULL, 0x00003cd0003f0105ULL, 0x000176c800000012ULL,
0x00003d50003f0101ULL, 0x0001768800000045ULL, 0x00003dd0003f0101ULL, 0x000000040000004aULL,
0x00003fa0003f0105ULL, 0x000000040000004aULL, 0x00004990003f0105ULL, 0x000176a800000053ULL,
0x00004a60003f0107ULL, 0x000176a800000053ULL, 0x00004ac0003f0101ULL, 0x0001762800000049ULL,
0x00004af0003f0101ULL, 0x0001762c00000049ULL, 0x00004cc0003f0105ULL, 0x0001762c00000049ULL,
0x00005270003f0105ULL, 0x000176ac00000044ULL, 0x00005440003f0105ULL, 0x000176ac00000044ULL,
0x00006540003f0105ULL, 0x0000000000000012ULL, 0x000065b0003f0101ULL, 0x0001769000000045ULL,
0x00006610003f0101ULL, 0x000000040000004aULL, 0x000067e0003f0105ULL, 0x000000040000004aULL,
0x000070c0003f0105ULL, 0x0000000000000054ULL, 0x00007220003f0107ULL, 0x000176a800000044ULL,
0x00007280003f0101ULL, 0x0001764800000049ULL, 0x000072a0003f0101ULL, 0x0001764c00000049ULL,
0x00007470003f0105ULL, 0x0001764c00000049ULL, 0x00007a20003f0105ULL, 0x000176ac00000053ULL,
0x00007bf0003f0105ULL, 0x000176ac00000053ULL, 0x00008d40003f0105ULL, 0x0000000000000012ULL,
0x00008db0003f0101ULL, 0x0001769800000045ULL, 0x00008e30003f0101ULL, 0x000000040000004aULL,
0x00009000003f0105ULL, 0x000000040000004aULL, 0x00009900003f0105ULL, 0x0000000000000052ULL,
0x000099e0003f0107ULL, 0x000176a800000053ULL, 0x00009a40003f0101ULL, 0x0001766800000049ULL,
0x00009a60003f0101ULL, 0x0001766c00000049ULL, 0x00009c30003f0105ULL, 0x0001766c00000049ULL,
0x0000a1c0003f0105ULL, 0x000176ac00000044ULL, 0x0000a390003f0105ULL, 0x000176ac00000044ULL,
0x0000b410003f0105ULL, 0x0000000000000012ULL, 0x0000b470003f0101ULL, 0x000176a000000045ULL,
0x0000c240003f0101ULL, 0x00017600000000ffULL, 0x0000df20003f0101ULL, 0x00017604000000ffULL,
0x0000e0f0003f0105ULL, 0x00017604000000ffULL, 0x0000e320003f0105ULL, 0x00017600000000ffULL,
0x0000e350003f0101ULL, 0x00017604000000ffULL, 0x0000e510003f0105ULL, 0x00017604000000ffULL,
0x00011740003f0105ULL, 0x0000000000000009ULL, 0x000117a0003f0101ULL, 0x0000000400000009ULL,
0x00011970003f0105ULL, 0x0000000400000009ULL, 0x00012df0003f0105ULL, 0x000000000000000bULL,
0x00012e50003f0101ULL, 0x000000080000000bULL, 0x00012eb0003f0101ULL, 0x000000100000000bULL,
0x00012f20003f0101ULL, 0x000000180000000bULL, 0x00053803003f0101ULL, 0x0000bed000141c04ULL,
0x0000e5700000c150ULL, 0x00012f700000e630ULL, 0x000c050400000401ULL, 0x0000000100000100ULL,
0x00041e0400000001ULL, 0x0000000000000000ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x000000000000031cULL, 0x0000001a00000002ULL, 0x000000000000026cULL, 0x0000001a00000002ULL,
0x00000000000001c4ULL, 0x0000001a00000002ULL, 0x0000000000000104ULL, 0x0000001a00000002ULL,
0x0000000000000044ULL, 0x0000001a00000002ULL, 0x00000000000002f5ULL, 0x0000001a00000002ULL,
0x0000000000000242ULL, 0x0000001a00000002ULL, 0x000000000000019aULL, 0x0000001a00000002ULL,
0x00000000000000dfULL, 0x0000001a00000002ULL, 0x0000000000017700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000000000057919ULL, 0x000e620000002100ULL,
0x0000000000127806ULL, 0x000fe200038e0000ULL, 0x00005800ff157624ULL, 0x000fe200078e00ffULL,
0x0000460000067ab9ULL, 0x000fe20000000a00ULL, 0x0000000000037919ULL, 0x000ea20000002300ULL,
0x0000001200047300ULL, 0x000ee600000e0000ULL, 0x0000000000027919ULL, 0x000f280000002200ULL,
0x0000000000077919ULL, 0x000ee20000000000ULL, 0x0000001200127309ULL, 0x000ea60000000000ULL,
0x0000000000147919ULL, 0x000ee80000002600ULL, 0x0000000000067919ULL, 0x000ee20000002700ULL,
0x00000005ff3d7819ULL, 0x002fc60000011605ULL, 0x00000000000d7919ULL, 0x000e680000000000ULL,
0x00001fff03007589ULL, 0x0045e200000e0000ULL, 0x0000010003027a24ULL, 0x010fc600078e0202ULL,
0x00001fff3d3d7589ULL, 0x000f2200000e0000ULL, 0x0000000002057a24ULL, 0x000fe200078e0205ULL,
0x000000070400720cULL, 0x008fe20003f02070ULL, 0x0000000815047824ULL, 0x000fe400078e00ffULL,
0x0000000814077824ULL, 0x000fe200078e00ffULL, 0x000000ff0500720cULL, 0x040fe40003f45270ULL,
0x0000000f0500780cULL, 0x040fe20003f64070ULL, 0x0000000604077224ULL, 0x000fe200078e0207ULL,
0x0000007f0500780cULL, 0x000fc40003f84070ULL, 0x000000030500780cULL, 0x000fe40003f24070ULL,
0x00000004ff137819ULL, 0x002fca000001160dULL, 0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff03a424ULL, 0x004fe400078e00ffULL, 0x00000004000a7824ULL, 0x010fe400078e023dULL,
0x3fffffc0ff08b424ULL, 0x000fe200078e00ffULL, 0x01760002ff00a388ULL, 0x0003e20000000a00ULL,
0x000000020a047824ULL, 0x000fe200078e00ffULL, 0x000000010500780cULL, 0x000fe20003f44070ULL,
0x7fffffc0ff09b424ULL, 0x000fc400078e00ffULL, 0x00000001040e7824ULL, 0x040fe200078e0213ULL,
0x00000008040f7817ULL, 0x000fe20007800000ULL, 0xff317217ff10c424ULL, 0x000fe200078e00ffULL,
0x017608080500b388ULL, 0x0005e20000008a00ULL, 0x3fffff60ff0a9424ULL, 0x000fe400078e00ffULL,
0x000000010f0c7824ULL, 0x000fe200078e0a04ULL, 0x017400100500c388ULL, 0x0007e20000004800ULL,
0x000000100d047824ULL, 0x000fe400078e00ffULL, 0x00000100ff037424ULL, 0x002fe200078e00ffULL,
0x0000000c1300720cULL, 0x000fe20003f66070ULL, 0x0000000107027824ULL, 0x000fc400078e020eULL,
0x000000010e077824ULL, 0x000fe200078e020dULL, 0x000000f004097812ULL, 0x004fe200078ec0ffULL,
0x000000100e087824ULL, 0x000fe400078e00ffULL, 0x00005c0002027625ULL, 0x000fc600078e0003ULL,
0xfffffff008077812ULL, 0x000fe200078ee207ULL, 0x7fffff60ff0b9424ULL, 0x000fe200078e00ffULL,
0x0000000902087210ULL, 0x000fe20007f9e0ffULL, 0x3fffff80ff0e9424ULL, 0x000fe400078e00ffULL,
0x7fffff80ff0f9424ULL, 0x000fe200078e00ffULL, 0x0176880a05009388ULL, 0x0003e20000008a00ULL,
0x3fffffc0ff10a424ULL, 0x008fe400078e00ffULL, 0x7fffffc0ff11a424ULL, 0x000fe200078e00ffULL,
0x0176a80e05009388ULL, 0x000fe20000008a00ULL, 0x000000ffff097224ULL, 0x000fc400020e0603ULL,
0x0000001007077824ULL, 0x000fe200078e00ffULL, 0x0176c8100500a388ULL, 0x000fe20000008a00ULL,
0x000000ffff0a7224ULL, 0x002fc600078e0a12ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008077faeULL, 0x0003e2000d901c46ULL,
0x00000004ff0b7424ULL, 0x000fc600078e00ffULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000620006027625ULL, 0x000fc600078e000bULL, 0x0176040affff038cULL, 0x0003e80000000200ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x01760000ff0079b0ULL, 0x000fe20008000a3fULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x00000006023c7981ULL, 0x000ea2000c1e1900ULL, 0x000000ff0000720cULL, 0x000fe40003f05270ULL,
0x0000007f3c0e7810ULL, 0x044fe40007ffe0ffULL, 0x000000ff3c007810ULL, 0x000fc40007ffe0ffULL,
0x00000007ff0e7819ULL, 0x000fe4000001160eULL, 0x00000008ff0f7819ULL, 0x000fca0000011600ULL,
0x0000bc1000008947ULL, 0x000fea0003800000ULL, 0x00000003ff417819ULL, 0x000fe2000001163dULL,
0x00000003ff087424ULL, 0x002fe200078e00ffULL, 0x000176883d057811ULL, 0x000fe200078e18ffULL,
0xffffffffff0c7424ULL, 0x000fe200078e00ffULL, 0x01ffffff41417812ULL, 0x000fc800078ec0ffULL,
0x0000000e4100720cULL, 0x000fda0003f06070ULL, 0x0000000206028824ULL, 0x000fe400078e00ffULL,
0x00006400ff038624ULL, 0x000fc800078e00ffULL, 0x0000640002028624ULL, 0x000fc800078e0203ULL,
0x0000000141028824ULL, 0x000fe200078e0202ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000040805ff738cULL, 0x0003e20000000000ULL, 0x0000600002028625ULL, 0x000fe200078e000bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000006020c8981ULL, 0x000ea2000c1e1900ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x00000080140a7824ULL, 0x000fe200078e00ffULL,
0x00000001ff0b7819ULL, 0x000fe2000001163dULL, 0x0000000005ff7f8cULL, 0x0007e2000c80043fULL,
0x000000013d007812ULL, 0x000fc600078ec0ffULL, 0x000000200b097824ULL, 0x000fca00078e00ffULL,
0x000000600a077812ULL, 0x000fe200078ef809ULL, 0x000058000c087a24ULL, 0x006fc800078e02ffULL,
0x0000008008157824ULL, 0x000fe200078e00ffULL, 0x0000047000000947ULL, 0x000fea0003800000ULL,
0x0000001000037824ULL, 0x008fe200078e00ffULL, 0x000000093c007217ULL, 0x000fe40007800000ULL,
0x00000003ff027819ULL, 0x000fe4000001160dULL, 0x00000070041b7812ULL, 0x000fe200078ec0ffULL,
0x0000000100007824ULL, 0x000fe200078e0a09ULL, 0x0000000402107810ULL, 0x040fe20007ffe0ffULL,
0x0000000103087824ULL, 0x000fe200078e0202ULL, 0x0000000802117810ULL, 0x000fc40007ffe0ffULL,
0x0000000300007217ULL, 0x000fe20007800000ULL, 0x0000000108057824ULL, 0x040fe400078e020dULL,
0x0000000808127824ULL, 0x000fe400078e00ffULL, 0x0000000100007824ULL, 0x000fe400078e0a03ULL,
0x0000000107087824ULL, 0x000fe200078e0208ULL, 0xfffffff812057812ULL, 0x000fe400078ee205ULL,
0x000000001000720cULL, 0x000fe20003f46070ULL, 0x0000000103107824ULL, 0x000fe200078e0210ULL,
0x0000000815137210ULL, 0x000fe20007f1e0ffULL, 0x0000000103087824ULL, 0x000fe200078e0211ULL,
0x0000000c02127810ULL, 0x000fc40007ffe0ffULL, 0x000000000200720cULL, 0x080fe20003f66070ULL,
0x0000000110027824ULL, 0x040fe200078e020dULL, 0x000000001100720cULL, 0x080fe20003f26070ULL,
0x0000000810117824ULL, 0x000fe200078e00ffULL, 0x00005e00131a7a11ULL, 0x000fe200078838ffULL,
0x000000ffff167224ULL, 0x000fe200000e06ffULL, 0x000000001200720cULL, 0x000fe20003f06070ULL,
0x0000000103147824ULL, 0x000fe200078e0212ULL, 0xfffffff811037812ULL, 0x000fe200078ee202ULL,
0x0000000107107824ULL, 0x000fe200078e0210ULL, 0x00005f0013127a11ULL, 0x000fe200020f3c16ULL,
0x0000000107007824ULL, 0x000fc400078e0208ULL, 0x0000000107077824ULL, 0x000fe200078e0214ULL,
0x0000001015107210ULL, 0x040fe20007f9e0ffULL, 0x0000000108027824ULL, 0x140fe200078e020dULL,
0x0000000015167210ULL, 0x040fe20007fbe0ffULL, 0x0000000808117824ULL, 0x000fe200078e00ffULL,
0x0000000715087210ULL, 0x000fe20007fde0ffULL, 0x0000000814137824ULL, 0x040fe200078e00ffULL,
0x000130000b007811ULL, 0x000fe200078e68ffULL, 0x000000ffff077224ULL, 0x000fe200020e06ffULL,
0xfffffff811117812ULL, 0x000fe200078ee202ULL, 0x0000000114027824ULL, 0x000fe200078e020dULL,
0x00005e0010147a11ULL, 0x000fe200078838ffULL, 0x0000001003157824ULL, 0x000fc400078e0200ULL,
0x0000001011177824ULL, 0x000fe200078e0200ULL, 0xfffffff813137812ULL, 0x000fe200078ee202ULL,
0x000000ffff117224ULL, 0x000fe200028e06ffULL, 0x00005f0010187a11ULL, 0x000fe200020f3c07ULL,
0x0000001005077824ULL, 0x100fe200078e0200ULL, 0x0000001a1b027210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff057224ULL, 0x000fe200030e06ffULL, 0x00005e0016107a11ULL, 0x000fe200078a38ffULL,
0x0000001013197824ULL, 0x000fe400078e0200ULL, 0x000000ffff037224ULL, 0x000fe200020e0612ULL,
0x00005e0008127a11ULL, 0x000fc400078c38ffULL, 0x0000001b14047210ULL, 0x080fe40007f9e0ffULL,
0x00005f0016117a11ULL, 0x000fe200028f3c11ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002077faeULL, 0x0003e2000d901c46ULL, 0x00005f0008007a11ULL, 0x000fe200030f3c05ULL,
0x000000ffff057224ULL, 0x000fe200020e0618ULL, 0x0000001b10107210ULL, 0x080fe40007fbe0ffULL,
0x0000001b12127210ULL, 0x000fe40007f9e0ffULL, 0x0000000004157faeULL, 0x0003e2000d101c46ULL,
0x000000ffff117224ULL, 0x000fc400028e0611ULL, 0x000000ffff137224ULL, 0x000fc600020e0600ULL,
0x0000000010177faeULL, 0x0003e8000c901c46ULL, 0x0000000012197faeULL, 0x0003e2000c101c46ULL,
0x000003a000007947ULL, 0x000fea0003800000ULL, 0x0000001000007824ULL, 0x008fe200078e00ffULL,
0x000130000b197811ULL, 0x000fe400078e68ffULL, 0x00000070041b7812ULL, 0x000fe400078ec0ffULL,
0x000000000d007211ULL, 0x000fc800078fe8ffULL, 0x0000000400087810ULL, 0x040fe20007ffe0ffULL,
0x0000000100027824ULL, 0x140fe200078e020dULL, 0x0000000800107810ULL, 0x040fe20007ffe0ffULL,
0x0000000800057824ULL, 0x000fe400078e00ffULL, 0x0000000108037824ULL, 0x040fe400078e020dULL,
0x0000000808127824ULL, 0x000fe200078e00ffULL, 0xfffffff805027812ULL, 0x000fe200078ee202ULL,
0x0000000107087824ULL, 0x040fe400078e0208ULL, 0x0000000107057824ULL, 0x040fe200078e0210ULL,
0xfffffff812037812ULL, 0x000fe200078ee203ULL, 0x0000000810137824ULL, 0x000fe200078e00ffULL,
0x0000000c00127810ULL, 0x000fe20007ffe0ffULL, 0x0000000107007824ULL, 0x000fe200078e0200ULL,
0x0000000815147210ULL, 0x000fc40007f5e0ffULL, 0x0000000515117210ULL, 0x000fe20007f7e0ffULL,
0x0000000107077824ULL, 0x000fe200078e0212ULL, 0x0000000015167210ULL, 0x040fe20007f3e0ffULL,
0x0000000110007824ULL, 0x100fe400078e020dULL, 0x0000000112057824ULL, 0x040fe200078e020dULL,
0x0000000715087210ULL, 0x000fe20007f1e0ffULL, 0x0000000812107824ULL, 0x000fe200078e00ffULL,
0xfffffff813007812ULL, 0x000fe200078ee200ULL, 0x000000ffff077224ULL, 0x000fe200008e06ffULL,
0x00005e0016127a11ULL, 0x000fe200078238ffULL, 0x0000001003157824ULL, 0x000fe200078e0219ULL,
0xfffffff810057812ULL, 0x000fe200078ee205ULL, 0x000000ffff037224ULL, 0x000fe200010e06ffULL,
0x00005f0016167a11ULL, 0x000fe200008f3c07ULL, 0x0000001002077824ULL, 0x100fe200078e0219ULL,
0x00005e0014137a11ULL, 0x000fe200078238ffULL, 0x0000001000177824ULL, 0x100fe200078e0219ULL,
0x00005e0011107a11ULL, 0x000fe200078438ffULL, 0x0000001005197824ULL, 0x000fe200078e0219ULL,
0x00005f0014147a11ULL, 0x000fe200008f3c03ULL, 0x000000ffff007224ULL, 0x000fe200018e06ffULL,
0x000000121b027210ULL, 0x000fe20007f3e0ffULL, 0x000000ffff057224ULL, 0x000fe200000e06ffULL,
0x00005e0008127a11ULL, 0x000fc400078638ffULL, 0x000000131b047210ULL, 0x000fe20007f1e0ffULL,
0x000000ffff037224ULL, 0x000fe200008e0616ULL, 0x00005f0011117a11ULL, 0x000fe400010f3c00ULL,
0x000000101b107210ULL, 0x040fe40007f3e0ffULL, 0x00005f0008007a11ULL, 0x000fe200018f3c05ULL,
0x000000ffff057224ULL, 0x000fe200000e0614ULL, 0x000000121b127210ULL, 0x000fe20007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002077faeULL, 0x0003e6000b901c46ULL, 0x000000ffff137224ULL, 0x000fe200010e0600ULL,
0x0000000004157faeULL, 0x0003e8000b901c46ULL, 0x0000000010177faeULL, 0x0003e8000b901c46ULL,
0x0000000012197faeULL, 0x0003e4000b901c46ULL, 0x000000000b0473c2ULL, 0x000ea200000e0000ULL,
0x000000ff0f00720cULL, 0x000fe20003f05270ULL, 0x000000ffff077224ULL, 0x002fe200078e00ffULL,
0x000176a80b127811ULL, 0x000fe200078e18ffULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x000000ffff317224ULL, 0x000fe200078e00ffULL, 0x000176a804047891ULL, 0x004fd2000f8e203fULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00000000ff587f8cULL, 0x000e62000c800404ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000200012127f8cULL, 0x000ea2000c80043fULL, 0x000000ffff307224ULL, 0x000fe200078e00ffULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000a35000008947ULL, 0x000fea0003800000ULL, 0x0000000206087824ULL, 0x000fe400078e00ffULL,
0x00006400ff037624ULL, 0x000fc400078e00ffULL, 0xff317217ff577424ULL, 0x000fe400078e00ffULL,
0x0000640008087624ULL, 0x000fe400078e0203ULL, 0x000000ffff067224ULL, 0x000fe400078e00ffULL,
0x000000ffff127224ULL, 0x004fe400078e00ffULL, 0x000000ffff1b7224ULL, 0x000fc400078e00ffULL,
0x0000010006057824ULL, 0x000fca00078e00ffULL, 0x0000003c0500720cULL, 0x000fda0003f06070ULL,
0x0000a27000000947ULL, 0x012fea0003800000ULL, 0x000000ffff057224ULL, 0x000fe400078e0041ULL,
0x000000ffff047224ULL, 0x000fc400078e0012ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0x000000043d147824ULL, 0x000fca00078e00ffULL, 0xfffffff814167812ULL, 0x000fc800078ec0ffULL,
0x000176c8164a7810ULL, 0x000fe20007ffe0ffULL, 0x0176cc0016147984ULL, 0x000ea40000000800ULL,
0x8000000014ff7812ULL, 0x004fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001714147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0176cc0016147984ULL, 0x000ea40000000800ULL,
0x8000000014ff7812ULL, 0x004fe40007804813ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000103d107824ULL, 0x000fe200078e00ffULL,
0x0000000106147810ULL, 0x000fe20007ffe0ffULL, 0x000058000c0c7a24ULL, 0x000fe200078e02ffULL,
0x0000000112467812ULL, 0x000fe400078e0cffULL, 0x0000000f1400720cULL, 0x000fe20003f06070ULL,
0x000000800c457824ULL, 0x000fe200078e00ffULL, 0xffffffe010117812ULL, 0x000fca00078ec0ffULL,
0x0000010006117824ULL, 0x000fca00078e0211ULL, 0x0000004011117810ULL, 0x000fc80007ffe0ffULL,
0x000000600a437812ULL, 0x000fe200078ef811ULL, 0x0000049000008947ULL, 0x000fea0003800000ULL,
0x0000001010137812ULL, 0x000fe200078ec0ffULL, 0x000000020b177824ULL, 0x000fe200078e0246ULL,
0x00000003ff1e7819ULL, 0x000fc8000001160dULL, 0x000000041e3e7810ULL, 0x040fe20007ffe0ffULL,
0x000000011e107824ULL, 0x140fe200078e0213ULL, 0x0001300017177811ULL, 0x000fe400078e60ffULL,
0x000000081e427810ULL, 0x040fe20007ffe0ffULL, 0x00000001430c7824ULL, 0x000fe200078e0210ULL,
0x0000000c1e447810ULL, 0x000fe20007ffe0ffULL, 0x000000013e167824ULL, 0x000fe400078e0213ULL,
0x00000008101c7824ULL, 0x000fe200078e00ffULL, 0x0000000c451d7210ULL, 0x000fc40007f1e0ffULL,
0x000000113c0c7217ULL, 0x000fc60007800000ULL, 0x000000ffff147224ULL, 0x000fe200000e06ffULL,
0x00005e001d157a11ULL, 0x000fe200078038ffULL, 0x000000010c0c7824ULL, 0x000fe400078e0a11ULL,
0x000000100d117824ULL, 0x000fe200078e00ffULL, 0x00005f001d1d7a11ULL, 0x000fe200000f3c14ULL,
0x0000000143147824ULL, 0x000fe200078e0216ULL, 0x000000130c0c7217ULL, 0x000fe40007800000ULL,
0x0000007011407812ULL, 0x000fe200078ec0ffULL, 0x0000000110117824ULL, 0x000fe200078e020dULL,
0x00000014453f7210ULL, 0x000fe20007fde0ffULL, 0x000000010c0c7824ULL, 0x000fe200078e0a13ULL,
0x0000004015107210ULL, 0x000fe20007fbe0ffULL, 0x0000000116157824ULL, 0x000fe200078e020dULL,
0xfffffff81c147812ULL, 0x000fe200078ee211ULL, 0x000000ffff1c7224ULL, 0x000fe200030e06ffULL,
0x0000000c1e00720cULL, 0x080fe20003f06070ULL, 0x000000ffff117224ULL, 0x000fe200028e061dULL,
0x00005e003f1f7a11ULL, 0x040fe200078c38ffULL, 0x00000010141d7824ULL, 0x000fe200078e0217ULL,
0x0000000c3e00720cULL, 0x000fe20003fa6070ULL, 0x0000000816167824ULL, 0x000fe200078e00ffULL,
0x00005f003f3f7a11ULL, 0x000fe200030f3c1cULL, 0x00000001421c7824ULL, 0x000fc400078e0213ULL,
0x00000001443e7824ULL, 0x000fe200078e0213ULL, 0xfffffff816167812ULL, 0x000fe200078ee215ULL,
0x00000001431e7824ULL, 0x000fe400078e021cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101d7faeULL, 0x0005e2000c101c46ULL, 0x000000401f147210ULL, 0x000fe20007f1e0ffULL,
0x0000001016137824ULL, 0x000fe200078e0217ULL, 0x0000001e451e7210ULL, 0x000fe20007fde0ffULL,
0x000000081c1f7824ULL, 0x000fe400078e00ffULL, 0x000000ffff157224ULL, 0x000fe200000e063fULL,
0x0000000c4200720cULL, 0x000fc80003f06070ULL, 0x0000000014137faeULL, 0x0007e2000e901c46ULL,
0x0000000143107824ULL, 0x004fe200078e023eULL, 0x00005e001e117a11ULL, 0x000fe200078a38ffULL,
0x000000ffff1d7224ULL, 0x000fc600030e06ffULL, 0x0000001045167210ULL, 0x000fe40007fde0ffULL,
0x00005f001e1e7a11ULL, 0x000fe400028f3c1dULL, 0x0000000c4400720cULL, 0x000fe20003fa6070ULL,
0x000000ffff1d7224ULL, 0x000fe200030e06ffULL, 0x0000004011107210ULL, 0x000fe20007fde0ffULL,
0x000000011c0c7824ULL, 0x100fe400078e020dULL, 0x000000013e137824ULL, 0x008fe400078e020dULL,
0x000000ffff117224ULL, 0x000fe200030e061eULL, 0x00005e0016147a11ULL, 0x000fe200078c38ffULL,
0x000000083e3e7824ULL, 0x000fe200078e00ffULL, 0xfffffff81f0c7812ULL, 0x000fc400078ee20cULL,
0x00005f0016157a11ULL, 0x000fe400030f3c1dULL, 0x0000004014147210ULL, 0x000fe40007fde0ffULL,
0xfffffff83e167812ULL, 0x000fe200078ee213ULL, 0x000000100c137824ULL, 0x000fe400078e0217ULL,
0x000000ffff157224ULL, 0x000fe400030e0615ULL, 0x0000001016177824ULL, 0x000fe200078e0217ULL,
0x0000000010137faeULL, 0x0005e8000c101c46ULL, 0x0000000014177faeULL, 0x0005e2000e901c46ULL,
0x000003c000007947ULL, 0x000fea0003800000ULL, 0x00000010100c7812ULL, 0x000fc800078ec0ffULL,
0x0000000c0d0c7211ULL, 0x000fc800078fe8ffULL, 0x000000040c147810ULL, 0x040fe20007ffe0ffULL,
0x0000000143107824ULL, 0x000fe400078e020cULL, 0x000000010c117824ULL, 0x140fe400078e020dULL,
0x000000080c167824ULL, 0x000fe200078e00ffULL, 0x0000001045407210ULL, 0x000fe20007f1e0ffULL,
0x0000000114157824ULL, 0x000fe200078e020dULL, 0x000000080c107810ULL, 0x000fe20007ffe0ffULL,
0x00000008141c7824ULL, 0x000fe200078e00ffULL, 0xfffffff816137812ULL, 0x000fe200078ee211ULL,
0x0000000143147824ULL, 0x040fe200078e0214ULL, 0x0000000c0c167810ULL, 0x000fe20007ffe0ffULL,
0x00000001430c7824ULL, 0x000fe200078e0210ULL, 0xfffffff81c177812ULL, 0x000fe200078ee215ULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005e00403f7a11ULL, 0x000fe200078038ffULL,
0x00000008161d7824ULL, 0x000fe200078e00ffULL, 0x00000014451f7210ULL, 0x000fe20007fde0ffULL,
0x0000000143117824ULL, 0x000fe200078e0216ULL, 0x00005f0040407a11ULL, 0x000fe200000f3c15ULL,
0x0000000810157824ULL, 0x040fe200078e00ffULL, 0x0000000c453e7210ULL, 0x040fe20007fbe0ffULL,
0x00000001100c7824ULL, 0x100fe200078e020dULL, 0x0000001145117210ULL, 0x000fe20007f1e0ffULL,
0x0000000116107824ULL, 0x000fc400078e020dULL, 0x000000ffff167224ULL, 0x000fe200030e06ffULL,
0x00005e001f147a11ULL, 0x000fe200078c38ffULL, 0x000000ffff1e7224ULL, 0x000fe200000e06ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee210ULL, 0x000000100d107824ULL, 0x000fe200078e00ffULL,
0xfffffff8150c7812ULL, 0x000fe200078ee20cULL, 0x000000ffff157224ULL, 0x000fe200028e06ffULL,
0x00005f001f1f7a11ULL, 0x000fe400030f3c16ULL, 0x00005e003e167a11ULL, 0x000fe400078a38ffULL,
0x0000007010437812ULL, 0x000fc400078ec0ffULL, 0x00005f003e3e7a11ULL, 0x000fe200028f3c15ULL,
0x000000020b157824ULL, 0x000fe200078e0246ULL, 0x00005e00111c7a11ULL, 0x000fe400078c38ffULL,
0x000000433f107210ULL, 0x080fe40007f1e0ffULL, 0x0000004314147210ULL, 0x080fe40007fbe0ffULL,
0x00005f00111e7a11ULL, 0x000fe200030f3c1eULL, 0x000000ffff117224ULL, 0x000fe200000e0640ULL,
0x0001300015427811ULL, 0x000fe200078e60ffULL, 0x000000ffff157224ULL, 0x000fe200028e061fULL,
0x0000004316167210ULL, 0x000fc40007f1e0ffULL, 0x000000431c1c7210ULL, 0x000fe20007fbe0ffULL,
0x0000001013137824ULL, 0x100fe400078e0242ULL, 0x00000010171f7824ULL, 0x100fe400078e0242ULL,
0x000000100c3f7824ULL, 0x100fe200078e0242ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0005e2000b901c46ULL, 0x000000101d437824ULL, 0x000fe400078e0242ULL,
0x000000ffff177224ULL, 0x000fe200000e063eULL, 0x00000000141f7faeULL, 0x0005e2000b901c46ULL,
0x000000ffff1d7224ULL, 0x000fc600028e061eULL, 0x00000000163f7faeULL, 0x0005e8000b901c46ULL,
0x000000001c437faeULL, 0x0005e4000b901c46ULL, 0x000000083d137824ULL, 0x004fe200078e00ffULL,
0x0000000141117810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff0c7424ULL, 0x000fc600078e00ffULL,
0xfffffff013157812ULL, 0x000fe400078ec0ffULL, 0x0000000e1100720cULL, 0x000fc60003f06070ULL,
0x0000000846447824ULL, 0x000fca00078e0215ULL, 0x0000000000007918ULL, 0x000fea0000000000ULL,
0x0000000108108810ULL, 0x000fe20007ffe041ULL, 0x00000004ff118424ULL, 0x000fe200078e00ffULL,
0xffffffe013497812ULL, 0x040fe400078ec0ffULL, 0x0000001013147812ULL, 0x040fe200078ec0ffULL,
0x0000600010108625ULL, 0x000fe200078e0011ULL, 0x0000000813137812ULL, 0x000fe200078ec0ffULL,
0x000000d000007945ULL, 0x000fe20003800000ULL, 0x000176a844547810ULL, 0x000fc40007ffe0ffULL,
0x00000006100c8981ULL, 0x000522000c1e1900ULL, 0x000000000000781cULL, 0x000fe40003f0f070ULL,
0x0000004913497210ULL, 0x000fd60007ffe014ULL, 0x00000000540403c2ULL, 0x000ee40000060000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00b9b0ULL, 0x008fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20001f0f070ULL,
0xffffff8000003947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a800447e7f8cULL, 0x0006a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176080049167f8cULL, 0x0006a4000c80043fULL, 0x0000000000107805ULL, 0x004fc40000015200ULL,
0x01760c0049137984ULL, 0x000ea40000000800ULL, 0x8000000013ff7812ULL, 0x004fc40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410147210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011415ULL,
0x0000001413137211ULL, 0x000fca00078110ffULL, 0x000000ffff147224ULL, 0x000fca00000e0615ULL,
0x0000000213137819ULL, 0x000fc80000001214ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760c0049137984ULL, 0x000ea40000000800ULL,
0x8000000013ff7812ULL, 0x004fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000100d107824ULL, 0x000fe200078e00ffULL, 0x00000001ff477819ULL, 0x000fe2000001160dULL,
0x000000203d487824ULL, 0x000fc600078e00ffULL, 0x00000070101c7812ULL, 0x000fe400078ec0ffULL,
0xffffff8048487812ULL, 0x000fe400078ec0ffULL, 0x0000000c47477812ULL, 0x000fc800078ec0ffULL,
0x0000004847107210ULL, 0x000fca0007ffe01cULL, 0x0170000010147984ULL, 0x000ea80000000800ULL,
0x0172000010167984ULL, 0x0006620000000800ULL, 0x000000571400720bULL, 0x004fe20003f1d000ULL,
0x00010c927f007947ULL, 0x000fd8000b800000ULL, 0x0000000000107806ULL, 0x008fc800000e0100ULL,
0x0000ffff101e7812ULL, 0x000fe2000780c0ffULL, 0x0000048000007945ULL, 0x000fe20003800000ULL,
0x00000001ff6a7424ULL, 0x000fe400078e00ffULL, 0x000000ffff407224ULL, 0x000fd200078e0057ULL,
0x0000044000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe4000001163dULL,
0x000000571400720bULL, 0x000fe40003f14000ULL, 0x0000003d1000720cULL, 0x000fe20003fa5270ULL,
0x00010c527f007947ULL, 0x000fd4000b800000ULL, 0x0000000000137806ULL, 0x000fc400000e0100ULL,
0x000000803d10d824ULL, 0x000fe200078e021cULL, 0x0000001457407209ULL, 0x000fe20007810000ULL,
0x0000036000017945ULL, 0x000fe40003800000ULL, 0x000000014711d824ULL, 0x000fe200078e0210ULL,
0x0000991013107816ULL, 0x000fc800000000ffULL, 0x017400401100d388ULL, 0x0005e20000000800ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000030000008947ULL, 0x000fea0003800000ULL,
0x8000004057107221ULL, 0x004fe20000010000ULL, 0x000000ff13ff7812ULL, 0x000fe2000780c0ffULL,
0x0000017000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x0000001000157308ULL, 0x0004ec0000000800ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x004fe2000001160dULL, 0x00010ba27f007947ULL, 0x000fea000b800000ULL,
0x00001f1015107589ULL, 0x0084e400000e0000ULL, 0x0000001020207220ULL, 0x088fe40000410000ULL,
0x0000001021217220ULL, 0x080fe40000410000ULL, 0x0000001024247220ULL, 0x000fc40000410000ULL,
0x0000001025257220ULL, 0x080fe40000410000ULL, 0x0000001028287220ULL, 0x080fe40000410000ULL,
0x0000001029297220ULL, 0x080fe40000410000ULL, 0x000000102c2c7220ULL, 0x080fe40000410000ULL,
0x000000102d2d7220ULL, 0x080fe40000410000ULL, 0x0000001030307220ULL, 0x000fc40000410000ULL,
0x0000001031317220ULL, 0x080fe40000410000ULL, 0x0000001034347220ULL, 0x080fe40000410000ULL,
0x0000001035357220ULL, 0x080fe40000410000ULL, 0x0000001038387220ULL, 0x080fe40000410000ULL,
0x0000001039397220ULL, 0x080fe40000410000ULL, 0x0000001018187220ULL, 0x000fc40000410000ULL,
0x0000001019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0013ff7812ULL, 0x000fe2000780c0ffULL, 0x0000001507077220ULL, 0x008fd80000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d107811ULL, 0x004fe200078ff0ffULL,
0x00010aa27f007947ULL, 0x000fea000b800000ULL, 0x00001f1015107589ULL, 0x0004e400000e0000ULL,
0x0000001022227220ULL, 0x088fe40000410000ULL, 0x0000001023237220ULL, 0x080fe40000410000ULL,
0x0000001026267220ULL, 0x080fe40000410000ULL, 0x0000001027277220ULL, 0x080fe40000410000ULL,
0x000000102a2a7220ULL, 0x080fe40000410000ULL, 0x000000102b2b7220ULL, 0x000fc40000410000ULL,
0x000000102e2e7220ULL, 0x080fe40000410000ULL, 0x000000102f2f7220ULL, 0x080fe40000410000ULL,
0x0000001032327220ULL, 0x080fe40000410000ULL, 0x0000001033337220ULL, 0x080fe40000410000ULL,
0x0000001036367220ULL, 0x080fe40000410000ULL, 0x0000001037377220ULL, 0x000fc40000410000ULL,
0x000000103a3a7220ULL, 0x080fe40000410000ULL, 0x000000103b3b7220ULL, 0x080fe40000410000ULL,
0x000000101a1a7220ULL, 0x080fe40000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x004fea0003800000ULL, 0x0000ffff1eff7812ULL, 0x000fda0007806013ULL,
0x8000004014140221ULL, 0x000fe20000010000ULL, 0x00007610ff6a0816ULL, 0x000fc6000000006aULL,
0x3fb8aa3b14140820ULL, 0x000fc80000410000ULL, 0x0000001400030308ULL, 0x000ea40000000800ULL,
0x0000000316160220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000716077221ULL, 0x002fc40000010000ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0x000000020b137824ULL, 0x000fc800078e0212ULL, 0x0000000813167824ULL, 0x000fca00078e00ffULL,
0x0176ac0016147984ULL, 0x000e640000000800ULL, 0x8000000014ff7812ULL, 0x002fe40007804859ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff177224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101700780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410147210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011415ULL,
0x0000001413137211ULL, 0x000fca00078110ffULL, 0x000000ffff147224ULL, 0x000fca00000e0615ULL,
0x0000000213137819ULL, 0x000fc80000001214ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000117177810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac0016147984ULL, 0x000e640000000800ULL,
0x8000000014ff7812ULL, 0x002fe40007804859ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099106a107816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000003ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff147819ULL, 0x000fe4000001160dULL,
0x0000541000137816ULL, 0x000fe20000000000ULL, 0x000106a27f007947ULL, 0x000fea000b800000ULL,
0x00001f1413027589ULL, 0x0002a400000e0000ULL, 0x0000000814007810ULL, 0x000fe20007ffe0ffULL,
0x000106f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0013007589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001014107810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x00002b30001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x0001145000007944ULL, 0x01efea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001814107810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0013ULL,
0x00002ba0001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x000113e000007944ULL, 0x01afea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000070d707812ULL, 0x000fe200078ec0ffULL,
0x000000023d4c7824ULL, 0x040fe200078e00ffULL, 0x00000004ff6c7819ULL, 0x100fe2000001160dULL,
0x000002003d3e7824ULL, 0x000fe200078e00ffULL, 0x0000000870707812ULL, 0x000fe200078ef80dULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x000000044c117812ULL, 0x000fe400078ec0ffULL,
0xfffff8003e3e7812ULL, 0x000fe200078ec0ffULL, 0x0000000870107824ULL, 0x040fe200078e00ffULL,
0x0000001170117210ULL, 0x000fc40007ffe06cULL, 0x000000080d567812ULL, 0x000fe400078ec0ffULL,
0xfffffff810117812ULL, 0x000fca00078ee211ULL, 0x00000010113f7824ULL, 0x000fc400078e023eULL,
0x000000043d557824ULL, 0x000fe200078e00ffULL, 0x0000000756567812ULL, 0x000fe200078ef80dULL,
0x000000020b4f7824ULL, 0x040fe400078e0212ULL, 0x000000040b837824ULL, 0x000fe200078e026cULL,
0x0000000455557812ULL, 0x000fe200078ec0ffULL, 0x0000000856117824ULL, 0x040fe200078e00ffULL,
0x000130004f4f7811ULL, 0x000fe400078e60ffULL, 0x0000001056587812ULL, 0x000fe200078efcffULL,
0x000000016c557824ULL, 0x000fe200078e0255ULL, 0x0000000283837810ULL, 0x000fe20007ffe070ULL,
0x0000000870707824ULL, 0x000fc400078e00ffULL, 0x0000000156107824ULL, 0x000fe400078e0255ULL,
0x00000008584d7824ULL, 0x000fe200078e00ffULL, 0xfffffff870837812ULL, 0x000fe200078ee283ULL,
0x00000001554e7824ULL, 0x000fe200078e0258ULL, 0xfffffff811127812ULL, 0x000fe400078ee210ULL,
0x0000000210507810ULL, 0x000fe20007ffe0ffULL, 0x00000010833e7824ULL, 0x000fe200078e023eULL,
0xfffffff84d4d7812ULL, 0x000fe200078ee24eULL, 0x0000001012127824ULL, 0x000fe200078e024fULL,
0x000000024e4e7810ULL, 0x000fc60007ffe0ffULL, 0x000000104d147824ULL, 0x002fe200078e024fULL,
0x00000000121c783bULL, 0x000e6a0000004200ULL, 0x000000001414783bULL, 0x004ea20000004200ULL,
0x000001001c117824ULL, 0x042fe200078e00ffULL, 0x00000018ff7b7819ULL, 0x000fe2000001141cULL,
0x000001001d517824ULL, 0x000fe200078e00ffULL, 0x000088801c817816ULL, 0x040fe200000000ffULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff887819ULL, 0x000fe20000011411ULL,
0x0000000856117824ULL, 0x000fe200078e00ffULL, 0x00000018ff657819ULL, 0x000fe2000001141dULL,
0x0000010017577824ULL, 0x004fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000008100817306ULL, 0x000fe20000200c00ULL, 0xfffffff811507812ULL, 0x000fc400078ee250ULL,
0x000088801d7d7816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe20000011414ULL, 0x0000001050107824ULL, 0x000fe200078e024fULL,
0x00000018ff517819ULL, 0x000fe20000011451ULL, 0x0000001c00847306ULL, 0x0003e20000200c00ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000888014617816ULL, 0x000fe200000000ffULL,
0x000000001010783bULL, 0x008ea20000004200ULL, 0x00000018ff527819ULL, 0x000fc4000001141eULL,
0x00000018ff537819ULL, 0x000fe2000001141fULL, 0x0000001d00827306ULL, 0x0007e20000200c00ULL,
0x000001001e1c7824ULL, 0x042fe200078e00ffULL, 0x000088801e807816ULL, 0x040fe200000000ffULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x000088801f687816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000005100867306ULL, 0x0003e20000200c00ULL,
0x00000008581d7824ULL, 0x008fe200078e00ffULL, 0x00000018ff437819ULL, 0x000fc40000011415ULL,
0x00000018ff457819ULL, 0x000fe40000011416ULL, 0xfffffff81d4e7812ULL, 0x000fe400078ee24eULL,
0x0000001c00797306ULL, 0x0007e20000200c00ULL, 0x000001001f517824ULL, 0x042fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x000fe20000011417ULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x00008880155f7816ULL, 0x000fe400000000ffULL, 0x00000018ff517819ULL, 0x000fc40000011451ULL,
0x0000888016607816ULL, 0x000fe200000000ffULL, 0x00000100141c7824ULL, 0x048fe200078e00ffULL,
0x0000005100777306ULL, 0x0003e20000200c00ULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x00000018ff667819ULL, 0x000fe2000001141cULL,
0x000000104e1c7824ULL, 0x000fe200078e024fULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x00000100154f7824ULL, 0x040fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x0001000015157824ULL, 0x000fe200078e00ffULL, 0x00000014005d7306ULL, 0x0007e20000200c00ULL,
0x0000888017517816ULL, 0x042fe200000000ffULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x0000010011787824ULL, 0x044fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0001000010767824ULL, 0x000fe200078e00ffULL,
0x00000018ff177819ULL, 0x000fe20000011417ULL, 0x0000001e00697306ULL, 0x000fe20000200c00ULL,
0x0000010016147824ULL, 0x048fe200078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011410ULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe20000011411ULL,
0x0001000011747824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000010013727824ULL, 0x000fe200078e00ffULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000001f007c7306ULL, 0x0003e20000200c00ULL, 0x00008880107a7816ULL, 0x000fe200000000ffULL,
0x00000100126e7824ULL, 0x000fe200078e00ffULL, 0x0000888011737816ULL, 0x000fc400000000ffULL,
0x00000018ff637819ULL, 0x000fe40000011413ULL, 0x00000018ff787819ULL, 0x000fe20000011478ULL,
0x00000014005b7306ULL, 0x0005e20000200c00ULL, 0x000000001c1c783bULL, 0x002e620000004200ULL,
0x00000018ff677819ULL, 0x000fe40000011412ULL, 0x00000018ff767819ULL, 0x000fe40000011476ULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000001500627306ULL, 0x000fe20000200c00ULL,
0x0000010010147824ULL, 0x004fe200078e00ffULL, 0x00008880126f7816ULL, 0x040fe200000000ffULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x00000018ff6e7819ULL, 0x000fc4000001146eULL,
0x00000018ff757819ULL, 0x000fe40000011414ULL, 0x00000016005e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff127819ULL, 0x000fe40000011412ULL, 0x00000018ff727819ULL, 0x000fe40000011472ULL,
0x00000018ff4f7819ULL, 0x000fc6000001144fULL, 0x00000017005a7306ULL, 0x0005f00000200c00ULL,
0x0000008800887306ULL, 0x000ee20000200c00ULL, 0x011000003f14783bULL, 0x004eae0000000200ULL,
0x0000007d007d7306ULL, 0x000ee20000200c00ULL, 0x00000018ff6b7819ULL, 0x002fc4000001141eULL,
0x00000018ff597819ULL, 0x000fe4000001141cULL, 0x00000018ff587819ULL, 0x000fc6000001141dULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x0000541081107816ULL, 0x008fce0000000088ULL,
0x0000006500657306ULL, 0x000e620000200c00ULL, 0x000054107d117816ULL, 0x000fce0000000086ULL,
0x00000057005c7306ULL, 0x000ff00000200c00ULL, 0x0000006b00577306ULL, 0x0007e20000200c00ULL,
0x0000000214148232ULL, 0x084fe40000000000ULL, 0x0000000216168232ULL, 0x000fc40000000000ULL,
0x0000000015158232ULL, 0x080fe40000000000ULL, 0x0000000017178232ULL, 0x000fe20000000000ULL,
0x0000005200527306ULL, 0x000ea20000200c00ULL, 0x00008880136b7816ULL, 0x048fe200000000ffULL,
0x0001000013137824ULL, 0x000fc800078e00ffULL, 0x000000101420723cULL, 0x000b640000001820ULL,
0x0000005300537306ULL, 0x000eea0000200c00ULL, 0x00000018ff107819ULL, 0x020fe40000011413ULL,
0x0000541082117816ULL, 0x002fe20000000065ULL, 0x0000008000807306ULL, 0x000fe20000200c00ULL,
0x0000541069527816ULL, 0x004fc40000000052ULL, 0x000088801c137816ULL, 0x000fca00000000ffULL,
0x0000006800687306ULL, 0x000fe20000200c00ULL, 0x000054107c537816ULL, 0x008fce0000000053ULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x00000052142c723cULL, 0x000bee000000182cULL,
0x0000007500757306ULL, 0x000e700000200c00ULL, 0x0000007300737306ULL, 0x000ff00000200c00ULL,
0x0000007800787306ULL, 0x000ea20000200c00ULL, 0x000054107a527816ULL, 0x022fce0000000075ULL,
0x0000001000707306ULL, 0x0003f00000200c00ULL, 0x0000007100717306ULL, 0x000fe20000200c00ULL,
0x0000541084107816ULL, 0x002fe4000000007bULL, 0x0000541073537816ULL, 0x004fca0000000078ULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x000000101424723cULL, 0x040bee0000001824ULL,
0x0000007600767306ULL, 0x000e620000200c00ULL, 0x0000541080107816ULL, 0x020fe20000000079ULL,
0x000000521430723cULL, 0x000be20000001830ULL, 0x0000541068117816ULL, 0x000fc40000000077ULL,
0x000088801d777816ULL, 0x000fc600000000ffULL, 0x0000007400747306ULL, 0x000ea40000200c00ULL,
0x000000101428723cULL, 0x000f620000001828ULL, 0x000000ffff697224ULL, 0x000fe400078e0077ULL,
0x000001001d777824ULL, 0x000fc600078e00ffULL, 0x00000012006c7306ULL, 0x0007e20000200c00ULL,
0x0000541076527816ULL, 0x022fe40000000071ULL, 0x000099106a717816ULL, 0x000fe400000000ffULL,
0x00000018ff777819ULL, 0x000fc60000011477ULL, 0x0000006f006f7306ULL, 0x000fe20000200c00ULL,
0x000001001c127824ULL, 0x008fe200078e00ffULL, 0x0000541074537816ULL, 0x004fe2000000006dULL,
0x000100001c1c7824ULL, 0x000fe400078e00ffULL, 0x000000ffff6d7224ULL, 0x000fe200078e0071ULL,
0x00000018ff687819ULL, 0x000fe40000011412ULL, 0x0000006e006e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x000000521434723cULL, 0x000b620000001834ULL,
0x000000ff6d00720cULL, 0x000fca0003f05270ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x000100001d537824ULL, 0x020fca00078e00ffULL, 0x00000018ff537819ULL, 0x000fe40000011453ULL,
0x0000007200727306ULL, 0x000e700000200c00ULL, 0x0000001300657306ULL, 0x0005f00000200c00ULL,
0x0000006700677306ULL, 0x000ee20000200c00ULL, 0x011000003e10783bULL, 0x004ea20000000200ULL,
0x000054106b1d7816ULL, 0x002fc40000000072ULL, 0x000088801e6b7816ULL, 0x000fc800000000ffULL,
0x0000006300637306ULL, 0x000e700000200c00ULL, 0x0000001c00527306ULL, 0x0003f00000200c00ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x000054106f1c7816ULL, 0x002fce000000006eULL,
0x0000001c1438723cULL, 0x000b620000001838ULL, 0x0000006600667306ULL, 0x000fec0000200c00ULL,
0x000054106c1c7816ULL, 0x028fe40000000067ULL, 0x00005410701d7816ULL, 0x000fe20000000063ULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x0000000210108232ULL, 0x084fe20000000000ULL,
0x000000ffff637224ULL, 0x000fe200078e006bULL, 0x0000000212128232ULL, 0x000fc40000000000ULL,
0x0000000011118232ULL, 0x080fe20000000000ULL, 0x0000001c1418723cULL, 0x000b620000001818ULL,
0x0000000013138232ULL, 0x000fe20000000000ULL, 0x0000004f00647306ULL, 0x000e6a0000200c00ULL,
0x000001001e147824ULL, 0x060fe200078e00ffULL, 0x000088801f1c7816ULL, 0x000fe200000000ffULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x0000006000607306ULL, 0x000ea40000200c00ULL,
0x00000018ff147819ULL, 0x000fc40000011414ULL, 0x00000018ff1e7819ULL, 0x000fc8000001141eULL,
0x0000001400167306ULL, 0x0007e20000200c00ULL, 0x000054105f157816ULL, 0x002fce0000000064ULL,
0x00000051004f7306ULL, 0x0003e20000200c00ULL, 0x0000541061147816ULL, 0x008fce0000000066ULL,
0x000000141020723cULL, 0x000b620000001820ULL, 0x00000018ff517819ULL, 0x002fe2000001141fULL,
0x0000006300177306ULL, 0x000e6a0000200c00ULL, 0x000001001f157824ULL, 0x060fe200078e00ffULL,
0x0000541060147816ULL, 0x004fe2000000005bULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000004200427306ULL, 0x000ea40000200c00ULL, 0x00000018ff157819ULL, 0x000fc40000011415ULL,
0x00000018ff1f7819ULL, 0x000fc8000001141fULL, 0x00000015001d7306ULL, 0x0007e20000200c00ULL,
0x0000541017167816ULL, 0x002fce0000000016ULL, 0x0000004300437306ULL, 0x000e620000200c00ULL,
0x000054104f157816ULL, 0x008fe4000000005cULL, 0x000054105d427816ULL, 0x004fca0000000042ULL,
0x000000141028723cULL, 0x000b620000001828ULL, 0x0000004500457306ULL, 0x000ea20000200c00ULL,
0x0000541062437816ULL, 0x002fce0000000043ULL, 0x0000004b004b7306ULL, 0x000e620000200c00ULL,
0x000000421024723cULL, 0x000f6e0000001824ULL, 0x0000005900597306ULL, 0x000ee20000200c00ULL,
0x000054105e5e7816ULL, 0x004fce0000000045ULL, 0x0000005800587306ULL, 0x000fe20000200c00ULL,
0x000054105a5f7816ULL, 0x002fce000000004bULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x0000541052527816ULL, 0x008fe20000000059ULL, 0x0000005e102c723cULL, 0x000f6c000000182cULL,
0x0000006800687306ULL, 0x000e700000200c00ULL, 0x0000006900697306ULL, 0x000ff00000200c00ULL,
0x00000077006a7306ULL, 0x000ea20000200c00ULL, 0x0000541065687816ULL, 0x002fce0000000068ULL,
0x0000005300537306ULL, 0x000e700000200c00ULL, 0x0000001c001c7306ULL, 0x000ee20000200c00ULL,
0x0000541069697816ULL, 0x004fce000000006aULL, 0x0000001e001e7306ULL, 0x000ea20000200c00ULL,
0x0000541053537816ULL, 0x002fe20000000058ULL, 0x000000681030723cULL, 0x040f6c0000001830ULL,
0x0000001f00147306ULL, 0x020e620000200c00ULL, 0x000054101c177816ULL, 0x008fe2000000001dULL,
0x000000521034723cULL, 0x000f620000001834ULL, 0x000054101e1e7816ULL, 0x004fce0000000057ULL,
0x000000161038723cULL, 0x000f620000001838ULL, 0x00005410141f7816ULL, 0x002fce0000000051ULL,
0x0000001e1018723cULL, 0x000b6e0000001818ULL, 0x000000080b127824ULL, 0x020fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd00000008000ULL, 0x0176c80012127f8cULL, 0x000e62000c80043fULL,
0xfffffff84c457812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000004006117811ULL, 0x000fe200078e40ffULL, 0x0176880045ff7f8cULL, 0x0005e2000c80043fULL,
0x0000000141417810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff577224ULL, 0x000fe200078e0040ULL,
0x0000003c1100720cULL, 0x000fe20003f06070ULL, 0x000000ffff597224ULL, 0x000fc400078e007fULL,
0x000000ffff127224ULL, 0x002fd400078e0046ULL, 0x000076e000000947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x004fc40000015200ULL, 0x000004004a127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011415ULL, 0x0000001712127211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000212127819ULL, 0x000fc80000001215ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004004a127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000103d127824ULL, 0x000fe200078e00ffULL,
0x0000000106107810ULL, 0x000fe20007ffe0ffULL, 0x000058000c587a24ULL, 0x010fc600078e02ffULL,
0x0000000f1000720cULL, 0x000fe20003f06070ULL, 0x0000008058587824ULL, 0x000fe200078e00ffULL,
0xffffffe012117812ULL, 0x000fca00078ec0ffULL, 0x0000010006117824ULL, 0x000fca00078e0211ULL,
0x0000008011117810ULL, 0x000fc80007ffe0ffULL, 0x000000600a157812ULL, 0x000fe200078ef811ULL,
0x000004b000008947ULL, 0x000fea0003800000ULL, 0x0000001012437812ULL, 0x000fe200078ec0ffULL,
0x000000100d147824ULL, 0x000fe200078e00ffULL, 0x00000003ff1f7819ULL, 0x000fe4000001160dULL,
0x000000113c107217ULL, 0x000fe40007800000ULL, 0x000000041f167810ULL, 0x040fe20007ffe0ffULL,
0x000000011f127824ULL, 0x040fe200078e0243ULL, 0x0000007014147812ULL, 0x000fe200078ec0ffULL,
0x0000000110107824ULL, 0x000fe200078e0a11ULL, 0x000000081f4b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000112117824ULL, 0x000fc400078e0215ULL, 0x00000001164c7824ULL, 0x000fe200078e0243ULL,
0x0000001043107217ULL, 0x000fe20007800000ULL, 0x0000000112137824ULL, 0x000fe200078e020dULL,
0x0000001158177210ULL, 0x000fe20007f1e0ffULL, 0x0000000812427824ULL, 0x000fe400078e00ffULL,
0x000000014c117824ULL, 0x000fe400078e0215ULL, 0x00000001101c7824ULL, 0x000fe200078e0a43ULL,
0xfffffff842427812ULL, 0x000fe200078ee213ULL, 0x000000ffff107224ULL, 0x000fe200000e06ffULL,
0x00000011581d7210ULL, 0x000fe20007fde0ffULL, 0x000000014b527824ULL, 0x000fe200078e0243ULL,
0x00005e0017137a11ULL, 0x040fe200078038ffULL, 0x000000084c4f7824ULL, 0x000fe200078e00ffULL,
0x0000001c1600720cULL, 0x000fe20003fa6070ULL, 0x000000ffff167224ULL, 0x000fe200030e06ffULL,
0x00005f0017177a11ULL, 0x000fe200000f3c10ULL, 0x0000100004107824ULL, 0x000fe200078e00ffULL,
0x00005e001d117a11ULL, 0x000fc400078c38ffULL, 0x0000001413127210ULL, 0x080fe40007f1e0ffULL,
0x00005f001d1d7a11ULL, 0x000fe400030f3c16ULL, 0x0000100010167812ULL, 0x000fe200078ec0ffULL,
0x000000ffff137224ULL, 0x000fe200000e0617ULL, 0x0000001411107210ULL, 0x000fe20007fde0ffULL,
0x0000000152177824ULL, 0x000fe200078e0215ULL, 0x0000001c1f00720cULL, 0x000fe20003f06070ULL,
0x000020000b167824ULL, 0x000fe400078e0216ULL, 0x000000ffff117224ULL, 0x000fe200030e061dULL,
0x00000017581e7210ULL, 0x000fc40007fde0ffULL, 0x00013000161d7810ULL, 0x000fe20007ffe0ffULL,
0x000000014c167824ULL, 0x000fe200078e020dULL, 0x0000000c1f4c7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff417224ULL, 0x000fe200030e06ffULL, 0x00005e001e177a11ULL, 0x000fe200078c38ffULL,
0x00000010421f7824ULL, 0x000fe200078e021dULL, 0xfffffff84f167812ULL, 0x000fe200078ee216ULL,
0x000000014c427824ULL, 0x000fe200078e0243ULL, 0x00005f001e1e7a11ULL, 0x000fe200030f3c41ULL,
0x0000000852437824ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000121f7faeULL, 0x0003e2000c101c46ULL, 0x0000000142157824ULL, 0x000fc400078e0215ULL,
0x0000001016417824ULL, 0x000fe200078e021dULL, 0x0000001417167210ULL, 0x000fe40007f1e0ffULL,
0x0000001558157210ULL, 0x000fe40007fde0ffULL, 0x0000000010417faeULL, 0x0005e2000e901c46ULL,
0x000000ffff177224ULL, 0x000fe200000e061eULL, 0x0000001c4b00720cULL, 0x080fe20003fa6070ULL,
0x00000001521e7824ULL, 0x100fe200078e020dULL, 0x0000001c4c00720cULL, 0x000fe20003f06070ULL,
0x000000ffff1c7224ULL, 0x000fe200030e06ffULL, 0x00005e0015137a11ULL, 0x002fe200078c38ffULL,
0x0000000142127824ULL, 0x040fe200078e020dULL, 0xfffffff8431e7812ULL, 0x000fe200078ee21eULL,
0x00000008421f7824ULL, 0x000fe200078e00ffULL, 0x00005f0015117a11ULL, 0x004fc400030f3c1cULL,
0x0000001413107210ULL, 0x000fe20007fde0ffULL, 0x000000101e137824ULL, 0x000fe200078e021dULL,
0xfffffff81f127812ULL, 0x000fc600078ee212ULL, 0x000000ffff117224ULL, 0x000fe200030e0611ULL,
0x0000000016137faeULL, 0x0003e2000e901c46ULL, 0x00000010121d7824ULL, 0x000fca00078e021dULL,
0x00000000101d7faeULL, 0x0003e2000c101c46ULL, 0x000003e000007947ULL, 0x000fea0003800000ULL,
0x0000001012127812ULL, 0x000fc800078ec0ffULL, 0x000000120d127211ULL, 0x000fc800078fe8ffULL,
0x00000008121c7810ULL, 0x040fe20007ffe0ffULL, 0x0000000112117824ULL, 0x040fe200078e0215ULL,
0x0000000412147810ULL, 0x040fe20007ffe0ffULL, 0x0000000112107824ULL, 0x100fe400078e020dULL,
0x000000011c167824ULL, 0x140fe400078e020dULL, 0x000000081c4b7824ULL, 0x000fe400078e00ffULL,
0x0000000114137824ULL, 0x040fe400078e020dULL, 0x00000008141e7824ULL, 0x000fe200078e00ffULL,
0xfffffff84b4b7812ULL, 0x000fe200078ee216ULL, 0x0000000812417824ULL, 0x000fe200078e00ffULL,
0x0000001158167210ULL, 0x000fe20007f1e0ffULL, 0x0000000114117824ULL, 0x000fe200078e0215ULL,
0xfffffff81e437812ULL, 0x000fe200078ee213ULL, 0x000000011c137824ULL, 0x000fe200078e0215ULL,
0x0000000c12127810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1d7224ULL, 0x000fe200000e06ffULL,
0x00000011581c7210ULL, 0x000fc40007fbe0ffULL, 0xfffffff841417812ULL, 0x000fe200078ee210ULL,
0x0000100004107824ULL, 0x000fe200078e00ffULL, 0x00005e00161f7a11ULL, 0x000fe200078038ffULL,
0x000000ffff177224ULL, 0x000fe200028e06ffULL, 0x00005e001c117a11ULL, 0x000fe200078a38ffULL,
0x0000000112157824ULL, 0x000fe200078e0215ULL, 0x00005f0016167a11ULL, 0x000fe200000f3c1dULL,
0x0000000112147824ULL, 0x000fe200078e020dULL, 0x00005f001c1c7a11ULL, 0x000fe200028f3c17ULL,
0x00000008124f7824ULL, 0x000fe200078e00ffULL, 0x0000100010107812ULL, 0x000fc400078ec0ffULL,
0x0000001358137210ULL, 0x040fe40007f1e0ffULL, 0xfffffff84f4f7812ULL, 0x000fe200078ee214ULL,
0x000000100d147824ULL, 0x000fe200078e00ffULL, 0x0000001558157210ULL, 0x000fe20007fbe0ffULL,
0x000020000b107824ULL, 0x000fe400078e0210ULL, 0x000000ffff427224ULL, 0x000fe200000e06ffULL,
0x00005e0013177a11ULL, 0x000fe200078038ffULL, 0x000000ffff1e7224ULL, 0x000fe200028e06ffULL,
0x00005e00151d7a11ULL, 0x000fc400078a38ffULL, 0x0000007014147812ULL, 0x000fe400078ec0ffULL,
0x00013000104c7810ULL, 0x000fe40007ffe0ffULL, 0x00005f0013427a11ULL, 0x000fe400000f3c42ULL,
0x00005f00151e7a11ULL, 0x000fe200028f3c1eULL, 0x0000001041157824ULL, 0x100fe200078e024cULL,
0x000000141f107210ULL, 0x080fe20007f1e0ffULL, 0x00000010431f7824ULL, 0x100fe200078e024cULL,
0x0000001411127210ULL, 0x000fe20007fbe0ffULL, 0x000000104b417824ULL, 0x000fc400078e024cULL,
0x000000ffff117224ULL, 0x000fe200000e0616ULL, 0x0000001417167210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200028e061cULL, 0x000000141d1c7210ULL, 0x000fe20007fbe0ffULL,
0x000000104f437824ULL, 0x000fe200078e024cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010157faeULL, 0x0003e2000b901c46ULL, 0x000000ffff177224ULL, 0x000fe400000e0642ULL,
0x000000ffff1d7224ULL, 0x000fe200028e061eULL, 0x00000000121f7faeULL, 0x0003e8000b901c46ULL,
0x0000000016417faeULL, 0x0003e8000b901c46ULL, 0x000000001c437faeULL, 0x0003e4000b901c46ULL,
0x000000083d117824ULL, 0x002fe200078e00ffULL, 0x0000010000007945ULL, 0x000fe20003800000ULL,
0x0000000804107824ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fc40003f0f070ULL,
0xfffffff011117812ULL, 0x000fe400078ec0ffULL, 0x0000000810107812ULL, 0x000fca00078ec0ffULL,
0x0000000111537824ULL, 0x000fca00078e0210ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000176a853527810ULL, 0x000fc80007ffe0ffULL, 0x00000000520403c2ULL, 0x000e640000040000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00a9b0ULL, 0x002fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000170f070ULL,
0xffffff8000002947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a80053127f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176280049107f8cULL, 0x000662000c80043fULL, 0x000000ffff597224ULL, 0x004fc600078e0013ULL,
0x0000000000127805ULL, 0x000fc80000015200ULL, 0x01762c0049157984ULL, 0x000ea40000000800ULL,
0x8000000015ff7812ULL, 0x006fe40007804811ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff1c7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101c00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001612167210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e13ULL,
0x003d09001600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff157819ULL, 0x000fc80000011417ULL, 0x0000001615157211ULL, 0x000fca00078110ffULL,
0x000000ffff167224ULL, 0x000fca00000e0617ULL, 0x0000000215157819ULL, 0x000fc80000001216ULL,
0x000000150000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01762c0049157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000008014107810ULL, 0x000fca0007ffe048ULL,
0x0000000147107824ULL, 0x000fca00078e0210ULL, 0x0170000010137984ULL, 0x000e680000000800ULL,
0x0172000010127984ULL, 0x0004e20000000800ULL, 0x000000401300720bULL, 0x002fe20003f1d000ULL,
0x0000e4b27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000157806ULL, 0x004fc800000e0100ULL,
0x0000ffff15ff7812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff167424ULL, 0x000fe400078e00ffULL, 0x000000ffff577224ULL, 0x000fd200078e0040ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x000000013d107811ULL, 0x000fe400078ff0ffULL,
0x000000401300720bULL, 0x000fe40003f14000ULL, 0x0000003d1000720cULL, 0x000fe20003fa5270ULL,
0x0000e4727f007947ULL, 0x000fd4000b800000ULL, 0x0000000000167806ULL, 0x000fc400000e0100ULL,
0x000000803d14d824ULL, 0x000fe200078e0214ULL, 0x000000401310d209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991016117816ULL, 0x000fe200000000ffULL,
0x000000014717d824ULL, 0x000fc600078e0214ULL, 0x000000ff1100720cULL, 0x000fe40003f05270ULL,
0x017400101700d388ULL, 0x0003f60000000800ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000004013117209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff16ff7812ULL, 0x000fc6000780c0ffULL, 0x0000004011107221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000147308ULL, 0x000e640000000800ULL,
0x0000001407077220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe2000001160dULL, 0x0000e3a27f007947ULL, 0x000fea000b800000ULL,
0x00001f1014107589ULL, 0x0002a400000e0000ULL, 0x0000001020207220ULL, 0x084fe40000410000ULL,
0x0000001021217220ULL, 0x080fe40000410000ULL, 0x0000001024247220ULL, 0x080fe40000410000ULL,
0x0000001025257220ULL, 0x000fc40000410000ULL, 0x0000001028287220ULL, 0x080fe40000410000ULL,
0x0000001029297220ULL, 0x080fe40000410000ULL, 0x000000102c2c7220ULL, 0x080fe40000410000ULL,
0x000000102d2d7220ULL, 0x080fe40000410000ULL, 0x0000001030307220ULL, 0x080fe40000410000ULL,
0x0000001031317220ULL, 0x000fc40000410000ULL, 0x0000001034347220ULL, 0x080fe40000410000ULL,
0x0000001035357220ULL, 0x080fe40000410000ULL, 0x0000001038387220ULL, 0x080fe40000410000ULL,
0x0000001039397220ULL, 0x080fe40000410000ULL, 0x0000001018187220ULL, 0x080fe40000410000ULL,
0x0000001019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080d107811ULL, 0x000fe200078ff0ffULL, 0x0000e2b27f007947ULL, 0x000fea000b800000ULL,
0x00001f1014107589ULL, 0x00046400000e0000ULL, 0x0000001022227220ULL, 0x082fe40000410000ULL,
0x0000001023237220ULL, 0x080fe40000410000ULL, 0x0000001026267220ULL, 0x080fe40000410000ULL,
0x0000001027277220ULL, 0x080fe40000410000ULL, 0x000000102a2a7220ULL, 0x080fe40000410000ULL,
0x000000102b2b7220ULL, 0x000fc40000410000ULL, 0x000000102e2e7220ULL, 0x080fe40000410000ULL,
0x000000102f2f7220ULL, 0x080fe40000410000ULL, 0x0000001032327220ULL, 0x080fe40000410000ULL,
0x0000001033337220ULL, 0x080fe40000410000ULL, 0x0000001036367220ULL, 0x080fe40000410000ULL,
0x0000001037377220ULL, 0x000fc40000410000ULL, 0x000000103a3a7220ULL, 0x080fe40000410000ULL,
0x000000103b3b7220ULL, 0x080fe40000410000ULL, 0x000000101a1a7220ULL, 0x080fe40000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff16ff7812ULL, 0x000fe20007800815ULL, 0x00000001ff167424ULL, 0x000fe200078e00ffULL,
0x0000004013577209ULL, 0x000fd60007810000ULL, 0x8000005713130221ULL, 0x000fe20000010000ULL,
0x00007610ff160816ULL, 0x000fc60000000016ULL, 0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL,
0x0000001300030308ULL, 0x000e640000000800ULL, 0x0000000312120220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000712077221ULL, 0x008fc40000010000ULL,
0x0000000000107805ULL, 0x000fca0000015200ULL, 0x0176ac0044137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780487fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x004fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101400780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210157210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001512127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000114147810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0176ac0044137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780487fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991016107816ULL, 0x000fe200000000ffULL,
0x0000019000007945ULL, 0x000fe60003800000ULL, 0x000000ff1000720cULL, 0x000fda0003f05270ULL,
0x0000016000000947ULL, 0x000fea0003800000ULL, 0x00000003ff00723eULL, 0x000fe400000000ffULL,
0x00000002ff137819ULL, 0x000fe4000001160dULL, 0x0000541000127816ULL, 0x000fe20000000000ULL,
0x0000deb27f007947ULL, 0x000fea000b800000ULL, 0x00001f1312027589ULL, 0x0002a400000e0000ULL,
0x0000000813107810ULL, 0x000fe20007ffe0ffULL, 0x0000df027f007947ULL, 0x000fea000b800000ULL,
0x00001f1012007589ULL, 0x00066400000e0000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001013107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x000055c0001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0000e9c000007944ULL, 0x006fea0003c00000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001813107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x004fe200078e0012ULL, 0x00005630001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x0000e95000007944ULL, 0x002fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000156107824ULL, 0x048fe200078e0255ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000856117824ULL, 0x000fe400078e00ffULL, 0x000000020b5b7824ULL, 0x000fc600078e0246ULL,
0xfffffff811107812ULL, 0x000fe400078ee210ULL, 0x000130005b5b7811ULL, 0x000fca00078e60ffULL,
0x0000001010517824ULL, 0x100fe400078e025bULL, 0x00000010504f7824ULL, 0x100fe400078e025bULL,
0x000000104d4c7824ULL, 0x100fe200078e025bULL, 0x00000000511c783bULL, 0x000ee20000004200ULL,
0x000000104e4b7824ULL, 0x000fc600078e025bULL, 0x000000004f40783bULL, 0x000fe80000004200ULL,
0x000000004c10783bULL, 0x002e680000004200ULL, 0x000000004b14783bULL, 0x004ea20000004200ULL,
0x00000018ff867819ULL, 0x008fe2000001141cULL, 0x000001001c647824ULL, 0x040fe200078e00ffULL,
0x000088801c897816ULL, 0x040fe200000000ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe2000001141dULL, 0x000001001d657824ULL, 0x040fe200078e00ffULL,
0x000088801d687816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x00000018ff647819ULL, 0x000fe20000011464ULL, 0x0001000010697824ULL, 0x002fe200078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe2000001141dULL, 0x00000100116f7824ULL, 0x040fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fe2000001141eULL, 0x00010000116a7824ULL, 0x000fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fe2000001141fULL, 0x0000001c00877306ULL, 0x0003e20000200c00ULL,
0x000088801e857816ULL, 0x000fc400000000ffULL, 0x000088801f707816ULL, 0x000fe400000000ffULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x00000018ff627819ULL, 0x000fe20000011410ULL,
0x0000001d00887306ULL, 0x0007e20000200c00ULL, 0x000001001e1c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff617819ULL, 0x000fe20000011411ULL, 0x000100001e1e7824ULL, 0x000fe200078e00ffULL,
0x00008880407f7816ULL, 0x000fe400000000ffULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x00000064008a7306ULL, 0x0003220000200c00ULL, 0x00000100411d7824ULL, 0x048fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x0000888041767816ULL, 0x000fe400000000ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c00847306ULL, 0x0007e20000200c00ULL,
0x000001001f647824ULL, 0x042fe200078e00ffULL, 0x00008880106d7816ULL, 0x000fe200000000ffULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x00008880116c7816ULL, 0x000fc400000000ffULL,
0x00000018ff647819ULL, 0x000fe40000011464ULL, 0x0000001d007d7306ULL, 0x0003e20000200c00ULL,
0x00000100401c7824ULL, 0x008fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00000018ff667819ULL, 0x000fe40000011442ULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000001e00817306ULL, 0x000fe20000200c00ULL, 0x00000100431d7824ULL, 0x002fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fc40000011443ULL, 0x0000888042797816ULL, 0x000fe400000000ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c007e7306ULL, 0x0003e20000200c00ULL,
0x0000888043747816ULL, 0x040fe200000000ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff7a7819ULL, 0x000fe20000011440ULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff757819ULL, 0x000fe20000011441ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x0000001f00827306ULL, 0x000fe20000200c00ULL,
0x00000100421c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fc40000011441ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000001d00777306ULL, 0x000fe20000200c00ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff607819ULL, 0x000fe40000011412ULL,
0x0000888012677816ULL, 0x000fe400000000ffULL, 0x00000018ff5f7819ULL, 0x000fe20000011413ULL,
0x0000001c00787306ULL, 0x0003e20000200c00ULL, 0x00000018ff5e7819ULL, 0x004fc40000011414ULL,
0x00000018ff5d7819ULL, 0x000fe40000011415ULL, 0x00000018ff6f7819ULL, 0x000fe4000001146fULL,
0x00000018ff697819ULL, 0x000fe20000011469ULL, 0x0000006800687306ULL, 0x000fe20000200c00ULL,
0x00000100101c7824ULL, 0x002fe200078e00ffULL, 0x0000541089107816ULL, 0x010fe4000000008aULL,
0x00000018ff6a7819ULL, 0x000fe4000001146aULL, 0x00000018ff6e7819ULL, 0x000fc4000001141cULL,
0x011800003f1c783bULL, 0x000e620000000200ULL, 0x00000065008b7306ULL, 0x0004e20000200c00ULL,
0x00000018ff5c7819ULL, 0x000fe40000011416ULL, 0x00000018ff5a7819ULL, 0x000fca0000011417ULL,
0x0000008600867306ULL, 0x000f220000200c00ULL, 0x0001000012657824ULL, 0x004fca00078e00ffULL,
0x00000018ff657819ULL, 0x000fe40000011465ULL, 0x0000006b006b7306ULL, 0x000ea20000200c00ULL,
0x0000541068117816ULL, 0x008fce000000008bULL, 0x0000008000807306ULL, 0x000ff00000200c00ULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x000000021c1c8232ULL, 0x002fce0000000000ULL,
0x0000008500857306ULL, 0x000e620000200c00ULL, 0x000000021e1e8232ULL, 0x000fe40000000000ULL,
0x000000001d1d8232ULL, 0x080fe40000000000ULL, 0x000000001f1f8232ULL, 0x000fc60000000000ULL,
0x0000007000707306ULL, 0x000fe80000200c00ULL, 0x000000101c20723cULL, 0x000b680000001820ULL,
0x0000006400837306ULL, 0x0006660000200c00ULL, 0x0000541087107816ULL, 0x030fc40000000086ULL,
0x0000541088117816ULL, 0x004fc6000000006bULL, 0x0000007f007f7306ULL, 0x000ea20000200c00ULL,
0x0000010012647824ULL, 0x008fe200078e00ffULL, 0x0000888014127816ULL, 0x040fe400000000ffULL,
0x000000101c24723cULL, 0x000b640000001824ULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x000000ffff6b7224ULL, 0x000fe200078e0012ULL, 0x0000007600767306ULL, 0x000ee20000200c00ULL,
0x0000010014127824ULL, 0x040fe400078e00ffULL, 0x0000541085107816ULL, 0x022fe20000000084ULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x0000541070117816ULL, 0x000fc40000000083ULL,
0x00000018ff707819ULL, 0x000fe20000011412ULL, 0x0000004200737306ULL, 0x0003e20000200c00ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000888015837816ULL, 0x000fe200000000ffULL,
0x000000101c28723cULL, 0x000f680000001828ULL, 0x0000004300727306ULL, 0x0009e20000200c00ULL,
0x0000888013427816ULL, 0x002fce00000000ffULL, 0x00000040007b7306ULL, 0x0003e20000200c00ULL,
0x0000010013437824ULL, 0x050fe400078e00ffULL, 0x0001000013137824ULL, 0x000fc600078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x00000041007c7306ULL, 0x0009e20000200c00ULL,
0x0000541081407816ULL, 0x002fe20000000080ULL, 0x0000010015807824ULL, 0x000fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fca0000011413ULL, 0x0000007a007a7306ULL, 0x000e620000200c00ULL,
0x0000541082417816ULL, 0x010fce0000000071ULL, 0x0000007500757306ULL, 0x000f220000200c00ULL,
0x000000401c2c723cULL, 0x000b6e000000182cULL, 0x000054107f407816ULL, 0x024fe2000000007eULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x0000541076417816ULL, 0x008fc4000000007dULL,
0x00000018ff767819ULL, 0x000fca0000011480ULL, 0x0000007400747306ULL, 0x000ea20000200c00ULL,
0x000000401c30723cULL, 0x000b6e0000001830ULL, 0x0000001300687306ULL, 0x0007e20000200c00ULL,
0x000054107b407816ULL, 0x022fe4000000007aULL, 0x000054107c417816ULL, 0x010fca0000000075ULL,
0x0000006600667306ULL, 0x000e620000200c00ULL, 0x011800003e10783bULL, 0x008ee20000000200ULL,
0x000000401c34723cULL, 0x000b6c0000001834ULL, 0x0000006300637306ULL, 0x000f220000200c00ULL,
0x0001000015407824ULL, 0x020fe200078e00ffULL, 0x0000541074157816ULL, 0x004fc40000000077ULL,
0x0000888016747816ULL, 0x000fe400000000ffULL, 0x00000018ff407819ULL, 0x000fe40000011440ULL,
0x0000001400417306ULL, 0x0005f00000200c00ULL, 0x0000006d006d7306ULL, 0x000fe20000200c00ULL,
0x0000541079147816ULL, 0x004fce0000000078ULL, 0x000000141c38723cULL, 0x000b620000001838ULL,
0x0000006e006e7306ULL, 0x000fec0000200c00ULL, 0x0000541073147816ULL, 0x022fe40000000066ULL,
0x0000541072157816ULL, 0x010fe20000000063ULL, 0x0000006c006c7306ULL, 0x000fe20000200c00ULL,
0x0000000210108232ULL, 0x088fe20000000000ULL, 0x000000ffff637224ULL, 0x000fe200078e0074ULL,
0x0000000212128232ULL, 0x000fc40000000000ULL, 0x0000000011118232ULL, 0x080fe20000000000ULL,
0x000000141c18723cULL, 0x000b620000001818ULL, 0x0000000013138232ULL, 0x000fe20000000000ULL,
0x0000006f006f7306ULL, 0x000e6a0000200c00ULL, 0x0000010016147824ULL, 0x060fe200078e00ffULL,
0x00008880171e7816ULL, 0x040fe200000000ffULL, 0x00000100171f7824ULL, 0x000fe200078e00ffULL,
0x0000006200627306ULL, 0x000fe20000200c00ULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fc40000011414ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x000054106c157816ULL, 0x002fce000000006fULL, 0x0000006900697306ULL, 0x000e700000200c00ULL,
0x0000006a006a7306ULL, 0x000eb00000200c00ULL, 0x00000014001c7306ULL, 0x0007f00000200c00ULL,
0x0000006700677306ULL, 0x000fe20000200c00ULL, 0x000054106d147816ULL, 0x008fce000000006eULL,
0x0000006400647306ULL, 0x000ee20000200c00ULL, 0x000000141020723cULL, 0x000b6e0000001820ULL,
0x0000004200427306ULL, 0x000fe20000200c00ULL, 0x0000541069147816ULL, 0x022fe40000000062ULL,
0x000054106a157816ULL, 0x004fca0000000061ULL, 0x0000004300437306ULL, 0x000e640000200c00ULL,
0x000000141024723cULL, 0x000b6c0000001824ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x0000541067147816ULL, 0x028fce0000000064ULL, 0x0000005f005f7306ULL, 0x000ea20000200c00ULL,
0x0000541042157816ULL, 0x002fce0000000043ULL, 0x0000006500657306ULL, 0x000e620000200c00ULL,
0x000000141028723cULL, 0x000b6e0000001828ULL, 0x0000006b006b7306ULL, 0x000fe20000200c00ULL,
0x0001000017147824ULL, 0x020fe200078e00ffULL, 0x0000541068157816ULL, 0x004fc8000000005fULL,
0x00000018ff427819ULL, 0x000fe40000011414ULL, 0x0000007000707306ULL, 0x000ea20000200c00ULL,
0x0000541065147816ULL, 0x002fce0000000060ULL, 0x0000008300717306ULL, 0x000fe20000200c00ULL,
0x00000014102c723cULL, 0x000b6e000000182cULL, 0x0000007600767306ULL, 0x000e620000200c00ULL,
0x000054106b147816ULL, 0x024fce0000000070ULL, 0x0000005e005e7306ULL, 0x000eb00000200c00ULL,
0x0000005d005d7306ULL, 0x000fe20000200c00ULL, 0x0000541071157816ULL, 0x002fce0000000076ULL,
0x0000004000407306ULL, 0x000e620000200c00ULL, 0x000000141030723cULL, 0x000b6e0000001830ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x0000541041147816ULL, 0x024fce000000005eULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x0000541040157816ULL, 0x002fce000000005dULL,
0x00000063001d7306ULL, 0x000e620000200c00ULL, 0x000000141034723cULL, 0x000b6e0000001834ULL,
0x0000001e001e7306ULL, 0x000ff00000200c00ULL, 0x0000001f001f7306ULL, 0x000ea20000200c00ULL,
0x000054101d147816ULL, 0x022fce000000001cULL, 0x0000001600177306ULL, 0x000e700000200c00ULL,
0x0000004200437306ULL, 0x000ee20000200c00ULL, 0x000054101e157816ULL, 0x004fe4000000001fULL,
0x00005410175c7816ULL, 0x002fca000000005cULL, 0x000000141038723cULL, 0x000f620000001838ULL,
0x00005410435d7816ULL, 0x008fce000000005aULL, 0x0000005c1018723cULL, 0x000b6e0000001818ULL,
0x000176c80b127811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000012127f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000008006117811ULL, 0x000fe200078e40ffULL, 0x0176900045ff7f8cULL, 0x0005e2000c80043fULL,
0x0000000105417810ULL, 0x000fc40007ffe0ffULL, 0x0000003c1100720cULL, 0x000fe40003f06070ULL,
0x0000000104127812ULL, 0x002fd600078ec0ffULL, 0x00004ea000000947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x004fc40000015200ULL, 0x000004004a0c7984ULL, 0x000e640000000800ULL,
0x800000000cff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff127224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0c7819ULL, 0x000fc80000011415ULL, 0x000000170c0c7211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x000000020c0c7819ULL, 0x000fc80000001215ULL,
0x0000000c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000112127810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004004a0c7984ULL, 0x000e640000000800ULL, 0x800000000cff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000103d107824ULL, 0x000fe200078e00ffULL,
0x00000001060c7810ULL, 0x000fc80007ffe0ffULL, 0x0000000f0c00720cULL, 0x000fe40003f06070ULL,
0xffffffe010117812ULL, 0x000fca00078ec0ffULL, 0x0000010006117824ULL, 0x000fca00078e0211ULL,
0x000000c011137810ULL, 0x000fc80007ffe0ffULL, 0x000000600a0c7812ULL, 0x000fe200078ef813ULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000010101f7812ULL, 0x000fe200078ec0ffULL,
0x000000100d1c7824ULL, 0x000fe200078e00ffULL, 0x00000003ff167819ULL, 0x000fe4000001160dULL,
0x000000133c107217ULL, 0x000fe40007800000ULL, 0x00000004161d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000116177824ULL, 0x000fe200078e021fULL, 0x000000701c1c7812ULL, 0x000fe200078ec0ffULL,
0x0000000110107824ULL, 0x000fe200078e0a13ULL, 0x0000000816417810ULL, 0x000fe20007ffe0ffULL,
0x0000000117117824ULL, 0x000fc400078e020cULL, 0x000000011d407824ULL, 0x100fe200078e021fULL,
0x000000101f107217ULL, 0x000fe20007800000ULL, 0x0000000141427824ULL, 0x100fe200078e021fULL,
0x0000001158117210ULL, 0x000fe20007f1e0ffULL, 0x0000000840437824ULL, 0x000fe400078e00ffULL,
0x0000000110147824ULL, 0x000fe400078e0a1fULL, 0x000000ffff127224ULL, 0x000fe200000e06ffULL,
0x00005e0011137a11ULL, 0x000fe200078038ffULL, 0x0000000117107824ULL, 0x000fc400078e020dULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0x00005f0011157a11ULL, 0x000fe200000f3c12ULL,
0x0000000140117824ULL, 0x000fe200078e020cULL, 0x000000141600720cULL, 0x000fe40003f06070ULL,
0x0000001c13127210ULL, 0x000fe40007fbe0ffULL, 0x0000001158117210ULL, 0x000fe40007fde0ffULL,
0xfffffff8171e7812ULL, 0x000fe200078ee210ULL, 0x000000ffff137224ULL, 0x000fe200028e0615ULL,
0x000000141d00720cULL, 0x000fe20003fa6070ULL, 0x000000ffff107224ULL, 0x000fe200030e06ffULL,
0x00005e0011177a11ULL, 0x000fe200078c38ffULL, 0x000000101e157824ULL, 0x000fc400078e025bULL,
0x00000001401e7824ULL, 0x000fe200078e020dULL, 0x0000000c16407810ULL, 0x000fe40007ffe0ffULL,
0x00005f00111d7a11ULL, 0x000fe200030f3c10ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000012157faeULL, 0x0003e2000c101c46ULL, 0x0000000142117824ULL, 0x000fe200078e020cULL,
0x0000001c17107210ULL, 0x000fe20007f1e0ffULL, 0x00000001401f7824ULL, 0x000fe200078e021fULL,
0xfffffff8431e7812ULL, 0x000fe400078ee21eULL, 0x0000001158167210ULL, 0x000fe20007fde0ffULL,
0x000000ffff117224ULL, 0x000fe200000e061dULL, 0x000000144100720cULL, 0x000fc60003f06070ULL,
0x000000ffff177224ULL, 0x000fe400030e06ffULL, 0x000000101e157824ULL, 0x002fe400078e025bULL,
0x000000011f137824ULL, 0x000fc600078e020cULL, 0x0000000010157faeULL, 0x0003e2000e901c46ULL,
0x00005e00161d7a11ULL, 0x000fe400078a38ffULL, 0x00000013580c7210ULL, 0x000fe40007fde0ffULL,
0x00005f0016137a11ULL, 0x000fe200028f3c17ULL, 0x000000081f167824ULL, 0x000fe200078e00ffULL,
0x000000144000720cULL, 0x000fe20003fa6070ULL, 0x000000ffff177224ULL, 0x000fe200030e06ffULL,
0x0000001c1d127210ULL, 0x000fe20007fde0ffULL, 0x0000000142147824ULL, 0x000fc400078e020dULL,
0x00000008421d7824ULL, 0x000fe400078e00ffULL, 0x000000ffff137224ULL, 0x000fe200030e0613ULL,
0x00005e000c117a11ULL, 0x042fe200078c38ffULL, 0x000000011f157824ULL, 0x000fe200078e020dULL,
0xfffffff81d147812ULL, 0x000fe400078ee214ULL, 0x00005f000c0c7a11ULL, 0x000fe400030f3c17ULL,
0x0000001c11107210ULL, 0x000fe40007fde0ffULL, 0xfffffff816167812ULL, 0x000fe200078ee215ULL,
0x0000001014157824ULL, 0x000fc400078e025bULL, 0x000000ffff117224ULL, 0x000fe400030e060cULL,
0x00000010165b7824ULL, 0x000fe200078e025bULL, 0x0000000012157faeULL, 0x0003e8000c101c46ULL,
0x00000000105b7faeULL, 0x0003e2000e901c46ULL, 0x000003a000007947ULL, 0x000fea0003800000ULL,
0x0000001010107812ULL, 0x000fe200078ec0ffULL, 0x000000100d1c7824ULL, 0x000fc600078e00ffULL,
0x000000100d107211ULL, 0x000fe400078fe8ffULL, 0x000000701c1c7812ULL, 0x000fe400078ec0ffULL,
0x0000000410157810ULL, 0x040fe20007ffe0ffULL, 0x0000000110117824ULL, 0x040fe400078e020cULL,
0x0000000110127824ULL, 0x100fe400078e020dULL, 0x0000000115137824ULL, 0x040fe200078e020dULL,
0x0000001158147210ULL, 0x000fe20007f1e0ffULL, 0x0000000815407824ULL, 0x000fc400078e00ffULL,
0x0000000810177824ULL, 0x000fe400078e00ffULL, 0x0000000115117824ULL, 0x000fe200078e020cULL,
0xfffffff840407812ULL, 0x000fe200078ee213ULL, 0x000000ffff137224ULL, 0x000fe200000e06ffULL,
0xfffffff817127812ULL, 0x000fe400078ee212ULL, 0x00005e00141f7a11ULL, 0x000fe400078038ffULL,
0x0000000810177810ULL, 0x040fe40007ffe0ffULL, 0x0000000c10107810ULL, 0x000fc40007ffe0ffULL,
0x00005f0014147a11ULL, 0x000fe200000f3c13ULL, 0x0000000117137824ULL, 0x140fe200078e020cULL,
0x0000001158167210ULL, 0x000fe20007f1e0ffULL, 0x0000000110117824ULL, 0x000fe400078e020cULL,
0x00000001170c7824ULL, 0x140fe200078e020dULL, 0x0000001358137210ULL, 0x040fe20007fbe0ffULL,
0x0000000817177824ULL, 0x000fe200078e00ffULL, 0x0000001158117210ULL, 0x000fe20007fde0ffULL,
0x000000ffff157224ULL, 0x000fe200000e06ffULL, 0x00005e0016417a11ULL, 0x000fe200078038ffULL,
0x00000001101d7824ULL, 0x040fe200078e020dULL, 0xfffffff817427812ULL, 0x000fe200078ee20cULL,
0x0000000810587824ULL, 0x000fe200078e00ffULL, 0x00005f0016167a11ULL, 0x000fe200000f3c15ULL,
0x000000ffff1e7224ULL, 0x000fe200028e06ffULL, 0x00005e0013157a11ULL, 0x000fe200078038ffULL,
0x000000ffff0c7224ULL, 0x000fe200030e06ffULL, 0x00005e0011177a11ULL, 0x000fc400078a38ffULL,
0xfffffff858587812ULL, 0x000fe200078ee21dULL, 0x00000010121d7824ULL, 0x100fe200078e025bULL,
0x00005f00131e7a11ULL, 0x000fe400000f3c1eULL, 0x00005f00110c7a11ULL, 0x000fe400028f3c0cULL,
0x0000001c1f107210ULL, 0x080fe20007f1e0ffULL, 0x00000010401f7824ULL, 0x100fe200078e025bULL,
0x0000001c41127210ULL, 0x080fe20007fbe0ffULL, 0x0000001042417824ULL, 0x100fe400078e025bULL,
0x000000ffff117224ULL, 0x000fe200000e0614ULL, 0x0000001c15147210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff137224ULL, 0x000fe200028e0616ULL, 0x0000001c17167210ULL, 0x000fe20007fbe0ffULL,
0x00000010585b7824ULL, 0x000fe200078e025bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101d7faeULL, 0x0003e2000b901c46ULL, 0x000000ffff157224ULL, 0x000fc400000e061eULL,
0x000000ffff177224ULL, 0x000fe200028e060cULL, 0x00000000121f7faeULL, 0x0003e8000b901c46ULL,
0x0000000014417faeULL, 0x0003e8000b901c46ULL, 0x00000000165b7faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x0000000205117810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0c7424ULL, 0x000fe200078e00ffULL, 0x000000000000781cULL, 0x000fc40003f0f070ULL,
0x0000000e1100720cULL, 0x000fda0003fa6070ULL, 0x0000004000005947ULL, 0x000fea0003800000ULL,
0x0000000208107810ULL, 0x000fe20007ffe005ULL, 0x00000004ff117424ULL, 0x000fc800078e00ffULL,
0x0000600010107625ULL, 0x000fca00078e0011ULL, 0x00000006100c7981ULL, 0x000324000c1e1900ULL,
0x0000009000007945ULL, 0x000fe40003800000ULL, 0x00000000540403c2ULL, 0x000ea40000020000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0099b0ULL, 0x004fe20008000a04ULL, 0x000000000000081cULL, 0x000fe20000f0f070ULL,
0xffffff8000001947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a800447e7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176480049107f8cULL, 0x0022a4000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x01764c0049157984ULL, 0x000e640000000800ULL, 0x8000000015ff7812ULL, 0x006fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001412177210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e13ULL, 0x003d09001700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff147819ULL, 0x000fc80000011415ULL,
0x0000001714147211ULL, 0x000fca00078110ffULL, 0x000000ffff157224ULL, 0x000fca00000e0615ULL,
0x0000000214147819ULL, 0x000fc80000001215ULL, 0x000000140000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01764c0049157984ULL, 0x000e640000000800ULL,
0x8000000015ff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000001001c107810ULL, 0x000fca0007ffe048ULL, 0x0000000147107824ULL, 0x000fca00078e0210ULL,
0x0170000010127984ULL, 0x000e680000000800ULL, 0x0172000010147984ULL, 0x0004e20000000800ULL,
0x000000571200720bULL, 0x002fe20003f1d000ULL, 0x0000bf927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000137806ULL, 0x004fc800000e0100ULL, 0x0000ffff13ff7812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff687424ULL, 0x000fe400078e00ffULL,
0x000000ffff547224ULL, 0x000fd200078e0057ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x000000023d107811ULL, 0x000fe400078ff0ffULL, 0x000000571200720bULL, 0x000fe40003f14000ULL,
0x0000003d1000720cULL, 0x000fe20003fa5270ULL, 0x0000bf527f007947ULL, 0x000fd4000b800000ULL,
0x0000000000167806ULL, 0x000fc400000e0100ULL, 0x000000803d1cd824ULL, 0x000fe200078e021cULL,
0x000000125710d209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x0000991016117816ULL, 0x000fe200000000ffULL, 0x000000014715d824ULL, 0x000fc600078e021cULL,
0x000000ff1100720cULL, 0x000fe40003f05270ULL, 0x017400101500d388ULL, 0x0003f60000000800ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x0000001257107209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff16ff7812ULL, 0x000fc6000780c0ffULL,
0x8000001057107221ULL, 0x000fc80000010000ULL, 0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL,
0x00000010001e7308ULL, 0x000e640000000800ULL, 0x0000001e07077220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff107819ULL, 0x000fe2000001160dULL,
0x0000be827f007947ULL, 0x000fea000b800000ULL, 0x00001f101e107589ULL, 0x0002a400000e0000ULL,
0x0000001020207220ULL, 0x084fe40000410000ULL, 0x0000001021217220ULL, 0x080fe40000410000ULL,
0x0000001024247220ULL, 0x080fe40000410000ULL, 0x0000001025257220ULL, 0x000fc40000410000ULL,
0x0000001028287220ULL, 0x080fe40000410000ULL, 0x0000001029297220ULL, 0x080fe40000410000ULL,
0x000000102c2c7220ULL, 0x080fe40000410000ULL, 0x000000102d2d7220ULL, 0x080fe40000410000ULL,
0x0000001030307220ULL, 0x080fe40000410000ULL, 0x0000001031317220ULL, 0x000fc40000410000ULL,
0x0000001034347220ULL, 0x080fe40000410000ULL, 0x0000001035357220ULL, 0x080fe40000410000ULL,
0x0000001038387220ULL, 0x080fe40000410000ULL, 0x0000001039397220ULL, 0x080fe40000410000ULL,
0x0000001018187220ULL, 0x080fe40000410000ULL, 0x0000001019197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x000000080d107811ULL, 0x000fe200078ff0ffULL,
0x0000bd927f007947ULL, 0x000fea000b800000ULL, 0x00001f101e107589ULL, 0x00046400000e0000ULL,
0x0000001022227220ULL, 0x082fe40000410000ULL, 0x0000001023237220ULL, 0x080fe40000410000ULL,
0x0000001026267220ULL, 0x080fe40000410000ULL, 0x0000001027277220ULL, 0x080fe40000410000ULL,
0x000000102a2a7220ULL, 0x080fe40000410000ULL, 0x000000102b2b7220ULL, 0x000fc40000410000ULL,
0x000000102e2e7220ULL, 0x080fe40000410000ULL, 0x000000102f2f7220ULL, 0x080fe40000410000ULL,
0x0000001032327220ULL, 0x080fe40000410000ULL, 0x0000001033337220ULL, 0x080fe40000410000ULL,
0x0000001036367220ULL, 0x080fe40000410000ULL, 0x0000001037377220ULL, 0x000fc40000410000ULL,
0x000000103a3a7220ULL, 0x080fe40000410000ULL, 0x000000103b3b7220ULL, 0x080fe40000410000ULL,
0x000000101a1a7220ULL, 0x080fe40000410000ULL, 0x000000101b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff16ff7812ULL, 0x000fe20007800813ULL,
0x00000001ff687424ULL, 0x000fe200078e00ffULL, 0x0000001257547209ULL, 0x000fd60007810000ULL,
0x8000005412120221ULL, 0x000fe20000010000ULL, 0x00007610ff680816ULL, 0x000fc60000000068ULL,
0x3fb8aa3b12120820ULL, 0x000fc80000410000ULL, 0x0000001200030308ULL, 0x000e640000000800ULL,
0x0000000314140220ULL, 0x00afcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000714077221ULL, 0x008fc40000010000ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0x0176ac0053127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe40007804859ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac0053127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804859ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991068107816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000003ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe4000001160dULL,
0x0000541000127816ULL, 0x000fe20000000000ULL, 0x0000b9927f007947ULL, 0x000fea000b800000ULL,
0x00001f1312027589ULL, 0x0002e400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x0000b9e27f007947ULL, 0x000fea000b800000ULL, 0x00001f1012007589ULL, 0x0002a400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x002fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00007d70001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x0000c21000007944ULL, 0x01cfea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x002fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0012ULL,
0x00007de0001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0000c1a000007944ULL, 0x018fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000100004107824ULL, 0x002fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000156557824ULL, 0x040fe400078e0255ULL,
0x0000000856147824ULL, 0x000fe200078e00ffULL, 0x0000100010107812ULL, 0x000fc800078ec0ffULL,
0xfffffff814147812ULL, 0x000fe200078ee255ULL, 0x000020000b107824ULL, 0x000fca00078e0210ULL,
0x0001300010557810ULL, 0x000fca0007ffe0ffULL, 0x0000001014147824ULL, 0x100fe400078e0255ULL,
0x0000001050407824ULL, 0x100fe400078e0255ULL, 0x000000104d107824ULL, 0x100fe400078e0255ULL,
0x000000001414783bULL, 0x004e620000004200ULL, 0x000000104e1c7824ULL, 0x000fc600078e0255ULL,
0x000000004040783bULL, 0x000fe80000004200ULL, 0x000000001010783bULL, 0x000ea80000004200ULL,
0x000000001c1c783bULL, 0x000ee20000004200ULL, 0x00000018ff817819ULL, 0x002fe20000011414ULL,
0x00000100145c7824ULL, 0x040fe200078e00ffULL, 0x0000888014837816ULL, 0x040fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff677819ULL, 0x000fe20000011415ULL,
0x00000100155d7824ULL, 0x040fe200078e00ffULL, 0x0000888015627816ULL, 0x040fe200000000ffULL,
0x0001000015157824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0000008300837306ULL, 0x000fe20000200c00ULL, 0x00000018ff5c7819ULL, 0x000fe2000001145cULL,
0x0000010011667824ULL, 0x044fe200078e00ffULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x0001000011607824ULL, 0x000fe200078e00ffULL, 0x00000018ff797819ULL, 0x000fc40000011416ULL,
0x00000018ff697819ULL, 0x000fe20000011417ULL, 0x0000001400847306ULL, 0x0003e20000200c00ULL,
0x0000888016807816ULL, 0x040fe400000000ffULL, 0x00008880176a7816ULL, 0x000fe400000000ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x00000018ff5a7819ULL, 0x000fe20000011410ULL,
0x0000001500827306ULL, 0x0005e20000200c00ULL, 0x0000010016147824ULL, 0x002fe200078e00ffULL,
0x0000888010647816ULL, 0x000fe200000000ffULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff597819ULL, 0x000fc40000011411ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x0000005c00867306ULL, 0x0003e20000200c00ULL, 0x0000010041157824ULL, 0x004fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fe40000011416ULL, 0x0000888040787816ULL, 0x000fe400000000ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000014007d7306ULL, 0x0005e20000200c00ULL,
0x00000100175c7824ULL, 0x002fe200078e00ffULL, 0x0000888041757816ULL, 0x000fe200000000ffULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x0000888011637816ULL, 0x000fc400000000ffULL,
0x00000018ff5c7819ULL, 0x000fe4000001145cULL, 0x0000001500767306ULL, 0x0003e20000200c00ULL,
0x0000010040147824ULL, 0x004fe200078e00ffULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x00000018ff5e7819ULL, 0x000fe40000011442ULL, 0x00000018ff147819ULL, 0x000fe40000011414ULL,
0x00000016007c7306ULL, 0x000fe20000200c00ULL, 0x0000010043157824ULL, 0x002fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fc40000011443ULL, 0x0000888042727816ULL, 0x000fe400000000ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000001400777306ULL, 0x0003e20000200c00ULL,
0x00008880436d7816ULL, 0x040fe200000000ffULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff717819ULL, 0x000fe20000011440ULL, 0x0001000040407824ULL, 0x000fe200078e00ffULL,
0x00000018ff6e7819ULL, 0x000fe20000011441ULL, 0x0001000041417824ULL, 0x000fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe20000011443ULL, 0x00000017007a7306ULL, 0x000fe20000200c00ULL,
0x0000010042147824ULL, 0x042fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fc40000011441ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000001500707306ULL, 0x000fe20000200c00ULL,
0x00000018ff427819ULL, 0x000fe40000011442ULL, 0x00000018ff587819ULL, 0x000fe40000011412ULL,
0x00008880125f7816ULL, 0x000fe400000000ffULL, 0x00000018ff577819ULL, 0x000fe20000011413ULL,
0x00000014006f7306ULL, 0x0003e20000200c00ULL, 0x00000018ff567819ULL, 0x008fc4000001141cULL,
0x00000018ff4d7819ULL, 0x000fe4000001141dULL, 0x00000018ff667819ULL, 0x000fe40000011466ULL,
0x00000018ff507819ULL, 0x000fe2000001141fULL, 0x0000006200627306ULL, 0x000fe20000200c00ULL,
0x0000010010147824ULL, 0x042fe200078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe2000001141eULL,
0x0001000010107824ULL, 0x000fe200078e00ffULL, 0x00000018ff607819ULL, 0x000fe40000011460ULL,
0x00000018ff657819ULL, 0x000fc40000011414ULL, 0x012000003f14783bULL, 0x000e620000000200ULL,
0x0000005d00857306ULL, 0x0004e20000200c00ULL, 0x00000018ff107819ULL, 0x000fce0000011410ULL,
0x0000008100817306ULL, 0x000e620000200c00ULL, 0x00010000125d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001145dULL, 0x0000006700677306ULL, 0x000ea20000200c00ULL,
0x0000541062117816ULL, 0x008fce0000000085ULL, 0x0000007900797306ULL, 0x000ff00000200c00ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x0000000214148232ULL, 0x002fce0000000000ULL,
0x0000001000617306ULL, 0x0003e20000200c00ULL, 0x0000000216168232ULL, 0x000fe40000000000ULL,
0x0000000015158232ULL, 0x080fe40000000000ULL, 0x0000000017178232ULL, 0x000fc60000000000ULL,
0x0000008000807306ULL, 0x000ee20000200c00ULL, 0x0000541083107816ULL, 0x002fce0000000086ULL,
0x0000006a006a7306ULL, 0x000fe20000200c00ULL, 0x000000101420723cULL, 0x000b6e0000001820ULL,
0x0000005c007b7306ULL, 0x0002e20000200c00ULL, 0x0000541084107816ULL, 0x020fe40000000081ULL,
0x0000541082117816ULL, 0x004fca0000000067ULL, 0x0000007800787306ULL, 0x000ea20000200c00ULL,
0x00000100125c7824ULL, 0x002fe200078e00ffULL, 0x000088801c127816ULL, 0x040fe200000000ffULL,
0x000000101424723cULL, 0x000be60000001824ULL, 0x00000018ff5c7819ULL, 0x000fe2000001145cULL,
0x000000ffff677224ULL, 0x000fe200078e0012ULL, 0x0000007500757306ULL, 0x000e620000200c00ULL,
0x000001001c127824ULL, 0x000fe200078e00ffULL, 0x0000541080107816ULL, 0x028fe2000000007dULL,
0x000100001c1c7824ULL, 0x000fe200078e00ffULL, 0x000054106a117816ULL, 0x000fc4000000007bULL,
0x00000018ff6a7819ULL, 0x000fe40000011412ULL, 0x00000042006b7306ULL, 0x0007e20000200c00ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x000000101428723cULL, 0x000f620000001828ULL,
0x000088801d7b7816ULL, 0x000fc800000000ffULL, 0x00000043006c7306ULL, 0x0003e20000200c00ULL,
0x0000888013427816ULL, 0x008fce00000000ffULL, 0x0000004000747306ULL, 0x0007e20000200c00ULL,
0x0000010013437824ULL, 0x042fe400078e00ffULL, 0x0001000013137824ULL, 0x000fc600078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x0000004100737306ULL, 0x0003e20000200c00ULL,
0x000054107c407816ULL, 0x008fe20000000079ULL, 0x000001001d797824ULL, 0x000fe200078e00ffULL,
0x00000018ff137819ULL, 0x000fc80000011413ULL, 0x00000018ff797819ULL, 0x000fe20000011479ULL,
0x0000007100717306ULL, 0x000ee20000200c00ULL, 0x000054107a417816ULL, 0x002fce0000000069ULL,
0x0000006e006e7306ULL, 0x000e620000200c00ULL, 0x00000040142c723cULL, 0x000b6e000000182cULL,
0x0000541078407816ULL, 0x024fe20000000077ULL, 0x0000007200727306ULL, 0x000fe20000200c00ULL,
0x0000541075417816ULL, 0x000fce0000000076ULL, 0x0000006d006d7306ULL, 0x000ea20000200c00ULL,
0x000000401430723cULL, 0x000b6e0000001830ULL, 0x0000001300627306ULL, 0x0005e20000200c00ULL,
0x0000541074407816ULL, 0x028fe40000000071ULL, 0x0000541073417816ULL, 0x002fc4000000006eULL,
0x0000991068717816ULL, 0x000fc600000000ffULL, 0x0000005e005e7306ULL, 0x000e620000200c00ULL,
0x012000003e10783bULL, 0x004ea20000000200ULL, 0x000000401434723cULL, 0x000b620000001834ULL,
0x000000ffff6e7224ULL, 0x000fca00078e0071ULL, 0x0000005b005b7306ULL, 0x000ee20000200c00ULL,
0x000100001d407824ULL, 0x020fe200078e00ffULL, 0x000054106d1d7816ULL, 0x000fe40000000070ULL,
0x000000ff6e00720cULL, 0x000fe40003f05270ULL, 0x000088801e6d7816ULL, 0x000fe400000000ffULL,
0x0000001c00417306ULL, 0x0003e20000200c00ULL, 0x00000018ff407819ULL, 0x000fce0000011440ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x00005410721c7816ULL, 0x002fce000000006fULL,
0x0000001c1438723cULL, 0x000b620000001838ULL, 0x0000006500657306ULL, 0x000fec0000200c00ULL,
0x000054106b1c7816ULL, 0x020fe4000000005eULL, 0x000054106c1d7816ULL, 0x008fe2000000005bULL,
0x0000006300637306ULL, 0x000fe20000200c00ULL, 0x0000000210108232ULL, 0x084fe20000000000ULL,
0x000000ffff5b7224ULL, 0x000fe200078e006dULL, 0x0000000212128232ULL, 0x000fc40000000000ULL,
0x0000000011118232ULL, 0x080fe20000000000ULL, 0x0000001c1418723cULL, 0x000b620000001818ULL,
0x0000000013138232ULL, 0x000fe20000000000ULL, 0x0000006600667306ULL, 0x000e6a0000200c00ULL,
0x000001001e147824ULL, 0x060fe200078e00ffULL, 0x000088801f1c7816ULL, 0x000fe200000000ffULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x0000005f005f7306ULL, 0x000fe40000200c00ULL,
0x00000018ff147819ULL, 0x000fc40000011414ULL, 0x00000018ff1e7819ULL, 0x000fc8000001141eULL,
0x0000005c005c7306ULL, 0x000ea20000200c00ULL, 0x0000541063157816ULL, 0x002fce0000000066ULL,
0x0000004200427306ULL, 0x000ff00000200c00ULL, 0x0000004300437306ULL, 0x000e700000200c00ULL,
0x0000001400167306ULL, 0x0007f00000200c00ULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x0000541064147816ULL, 0x008fce0000000065ULL, 0x000000141020723cULL, 0x000b620000001820ULL,
0x0000006000607306ULL, 0x000eec0000200c00ULL, 0x000001001f157824ULL, 0x020fe200078e00ffULL,
0x000054105f147816ULL, 0x004fe2000000005cULL, 0x000100001f1f7824ULL, 0x000fe200078e00ffULL,
0x0000005700577306ULL, 0x000ea40000200c00ULL, 0x00000018ff1d7819ULL, 0x000fc40000011415ULL,
0x0000541042157816ULL, 0x002fe40000000043ULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x0000004e004e7306ULL, 0x000fe60000200c00ULL, 0x000000141028723cULL, 0x000b6a0000001828ULL,
0x0000005b00177306ULL, 0x0006700000200c00ULL, 0x0000001e00157306ULL, 0x020e620000200c00ULL,
0x00005410605b7816ULL, 0x008fc40000000059ULL, 0x0000541062597816ULL, 0x004fca0000000057ULL,
0x0000005a005a7306ULL, 0x000ea20000200c00ULL, 0x0000541017167816ULL, 0x002fce0000000016ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x0000541015147816ULL, 0x000fce000000004eULL,
0x0000005600567306ULL, 0x000e620000200c00ULL, 0x00005410615a7816ULL, 0x004fce000000005aULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x0000005a1024723cULL, 0x000f6e0000001824ULL,
0x0000005000507306ULL, 0x000fe20000200c00ULL, 0x0000541041567816ULL, 0x002fce0000000056ULL,
0x0000005d005d7306ULL, 0x000e700000200c00ULL, 0x0000006700677306ULL, 0x000ff00000200c00ULL,
0x0000006a006a7306ULL, 0x000ea20000200c00ULL, 0x000054105d587816ULL, 0x002fce0000000058ULL,
0x0000007b00697306ULL, 0x000fe20000200c00ULL, 0x00000058102c723cULL, 0x000f6e000000182cULL,
0x0000007900687306ULL, 0x000e620000200c00ULL, 0x00005410676a7816ULL, 0x004fce000000006aULL,
0x0000004000407306ULL, 0x000eb00000200c00ULL, 0x0000001c001c7306ULL, 0x000fe20000200c00ULL,
0x00005410696b7816ULL, 0x002fce0000000068ULL, 0x0000001d001d7306ULL, 0x000e620000200c00ULL,
0x0000541040577816ULL, 0x004fe2000000004dULL, 0x0000006a1030723cULL, 0x040f6c0000001830ULL,
0x0000001f001f7306ULL, 0x000ea40000200c00ULL, 0x000000561034723cULL, 0x000f620000001834ULL,
0x000054101c177816ULL, 0x002fce000000001dULL, 0x000000161038723cULL, 0x000f620000001838ULL,
0x000054101f157816ULL, 0x004fce0000000050ULL, 0x000000141018723cULL, 0x000b6e0000001818ULL,
0x000176c80b127811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x0000000012127f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x000000c006117811ULL, 0x000fe200078e40ffULL, 0x0176980045ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff127224ULL, 0x002fe200078e0046ULL, 0x0000000205417810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff577224ULL, 0x000fe200078e0054ULL, 0x0000003c1100720cULL, 0x000fe20003f06070ULL,
0x000000ffff597224ULL, 0x000fd800078e007fULL, 0x0000268000000947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x004fc40000015200ULL, 0x000004004a127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000147805ULL, 0x000fcc0000015200ULL,
0x0000001410177210ULL, 0x000fca0007f1e1ffULL, 0x0000000115157824ULL, 0x000fe200000e0e11ULL,
0x003d09001700780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401700780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011415ULL, 0x0000001712127211ULL, 0x000fca00078110ffULL,
0x000000ffff157224ULL, 0x000fca00000e0615ULL, 0x0000000212127819ULL, 0x000fc80000001215ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000004004a127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000206127810ULL, 0x040fe20007ffe0ffULL,
0x0000010006107824ULL, 0x000fe400078e0209ULL, 0x000058000c137a24ULL, 0x010fe200078e02ffULL,
0x0000000f1200720cULL, 0x000fe40003f06070ULL, 0x0000010010117810ULL, 0x000fe20007ffe0ffULL,
0x0000008013137824ULL, 0x000fc600078e00ffULL, 0x000000600a167812ULL, 0x000fce00078ef811ULL,
0x0000048000008947ULL, 0x000fea0003800000ULL, 0x000000103d107824ULL, 0x000fe200078e00ffULL,
0x00000003ff1c7819ULL, 0x000fe2000001160dULL, 0x000000100d177824ULL, 0x000fc600078e00ffULL,
0x0000001010417812ULL, 0x000fe400078ec0ffULL, 0x000000113c107217ULL, 0x000fe40007800000ULL,
0x000000041c427810ULL, 0x040fe20007ffe0ffULL, 0x000000011c1d7824ULL, 0x040fe200078e0241ULL,
0x0000000c1c4a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000110107824ULL, 0x000fe400078e0a11ULL,
0x000000011d127824ULL, 0x000fe400078e0216ULL, 0x0000000142437824ULL, 0x000fe200078e0241ULL,
0x0000001041107217ULL, 0x000fe20007800000ULL, 0x000000081d407824ULL, 0x000fe200078e00ffULL,
0x0000001213127210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x00005e0012117a11ULL, 0x000fc800078038ffULL, 0x00005f0012147a11ULL, 0x000fe200000f3c15ULL,
0x000000011d157824ULL, 0x000fe200078e020dULL, 0x0000007017127812ULL, 0x000fe200078ec0ffULL,
0x0000000110177824ULL, 0x000fe400078e0a41ULL, 0x0000000143107824ULL, 0x000fe200078e0216ULL,
0xfffffff840407812ULL, 0x000fe400078ee215ULL, 0x000000171c00720cULL, 0x000fe40003f06070ULL,
0x00000010131e7210ULL, 0x000fe20007fde0ffULL, 0x00000010401d7824ULL, 0x000fe200078e0255ULL,
0x0000001211107210ULL, 0x000fe20007fbe0ffULL, 0x0000000843407824ULL, 0x000fc400078e00ffULL,
0x000000ffff1f7224ULL, 0x000fe200030e06ffULL, 0x00005e001e157a11ULL, 0x000fe200078c38ffULL,
0x000000ffff117224ULL, 0x000fe200028e0614ULL, 0x000000174200720cULL, 0x000fe40003fa6070ULL,
0x000000081c427810ULL, 0x000fe40007ffe0ffULL, 0x00005f001e1e7a11ULL, 0x000fe200030f3c1fULL,
0x00000001431f7824ULL, 0x000fe200078e020dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000101d7faeULL, 0x0003e2000c101c46ULL, 0x0000000142467824ULL, 0x100fe200078e0241ULL,
0x0000001215147210ULL, 0x000fe20007f1e0ffULL, 0x000000014a417824ULL, 0x000fe200078e0241ULL,
0xfffffff840407812ULL, 0x000fe200078ee21fULL, 0x00000001461c7824ULL, 0x000fc400078e0216ULL,
0x0000000141167824ULL, 0x000fe400078e0216ULL, 0x000000ffff157224ULL, 0x000fe200000e061eULL,
0x0000001c131c7210ULL, 0x000fe20007fde0ffULL, 0x00000008411e7824ULL, 0x000fe200078e00ffULL,
0x000000174200720cULL, 0x000fe20003f06070ULL, 0x00000010401d7824ULL, 0x002fe400078e0255ULL,
0x000000ffff1f7224ULL, 0x000fe200030e06ffULL, 0x0000001613167210ULL, 0x000fe40007fde0ffULL,
0x00000000141d7faeULL, 0x0003e2000e901c46ULL, 0x00005e001c117a11ULL, 0x000fc400078a38ffULL,
0x000000ffff137224ULL, 0x000fe400030e06ffULL, 0x00005f001c1c7a11ULL, 0x000fe400028f3c1fULL,
0x0000001211107210ULL, 0x000fe40007fde0ffULL, 0x000000174a00720cULL, 0x000fe20003fa6070ULL,
0x0000000146177824ULL, 0x140fe400078e020dULL, 0x0000000846467824ULL, 0x000fe400078e00ffULL,
0x000000ffff117224ULL, 0x000fe200030e061cULL, 0x00005e0016157a11ULL, 0x002fe200078c38ffULL,
0x00000001411d7824ULL, 0x000fe200078e020dULL, 0xfffffff8461c7812ULL, 0x000fc400078ee217ULL,
0x00005f0016167a11ULL, 0x000fe400030f3c13ULL, 0x0000001215147210ULL, 0x000fe20007fde0ffULL,
0x000000101c137824ULL, 0x000fe200078e0255ULL, 0xfffffff81e1e7812ULL, 0x000fc600078ee21dULL,
0x000000ffff157224ULL, 0x000fe200030e0616ULL, 0x0000000010137faeULL, 0x0003e2000c101c46ULL,
0x000000101e557824ULL, 0x000fca00078e0255ULL, 0x0000000014557faeULL, 0x0003e2000e901c46ULL,
0x000003b000007947ULL, 0x000fea0003800000ULL, 0x000000103d107824ULL, 0x000fca00078e00ffULL,
0x0000001010107812ULL, 0x000fc800078ec0ffULL, 0x000000100d127211ULL, 0x000fc800078fe8ffULL,
0x0000000412157810ULL, 0x040fe20007ffe0ffULL, 0x0000000112107824ULL, 0x140fe200078e0216ULL,
0x0000000c121d7810ULL, 0x040fe20007ffe0ffULL, 0x0000000112117824ULL, 0x140fe400078e020dULL,
0x0000000812147824ULL, 0x000fe200078e00ffULL, 0x0000001013427210ULL, 0x000fe20007f1e0ffULL,
0x0000000115177824ULL, 0x040fe400078e020dULL, 0x0000000815467824ULL, 0x040fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee211ULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00005e00421f7a11ULL, 0x000fe200078038ffULL, 0x0000000115107824ULL, 0x000fe200078e0216ULL,
0xfffffff846467812ULL, 0x000fe200078ee217ULL, 0x000000081d417824ULL, 0x000fe200078e00ffULL,
0x0000000812177810ULL, 0x000fc40007ffe0ffULL, 0x00005f0042427a11ULL, 0x000fe400000f3c11ULL,
0x0000001013107210ULL, 0x000fe20007f1e0ffULL, 0x0000000117127824ULL, 0x100fe400078e0216ULL,
0x000000011d167824ULL, 0x000fe400078e0216ULL, 0x00000001171c7824ULL, 0x000fe200078e020dULL,
0x0000001213407210ULL, 0x000fe20007fbe0ffULL, 0x0000000817177824ULL, 0x000fe200078e00ffULL,
0x0000001613167210ULL, 0x000fe20007fde0ffULL, 0x000000ffff117224ULL, 0x000fe200000e06ffULL,
0x00005e0010157a11ULL, 0x040fe200078038ffULL, 0x000000100d127824ULL, 0x000fe200078e00ffULL,
0xfffffff8174a7812ULL, 0x000fe200078ee21cULL, 0x000000ffff137224ULL, 0x000fe200028e06ffULL,
0x00005f00101c7a11ULL, 0x000fe200000f3c11ULL, 0x000000011d107824ULL, 0x000fe200078e020dULL,
0x00005e0040177a11ULL, 0x000fe200078038ffULL, 0x000000ffff117224ULL, 0x000fe200030e06ffULL,
0x00005e00161d7a11ULL, 0x000fc400078a38ffULL, 0x0000007012127812ULL, 0x000fe400078ec0ffULL,
0xfffffff8414e7812ULL, 0x000fe200078ee210ULL, 0x000000104a417824ULL, 0x000fe200078e0255ULL,
0x00005f0040407a11ULL, 0x000fe200000f3c13ULL, 0x0000001014137824ULL, 0x000fe200078e0255ULL,
0x00005f00161e7a11ULL, 0x000fe400028f3c11ULL, 0x000000121f107210ULL, 0x080fe20007f1e0ffULL,
0x00000010461f7824ULL, 0x100fe200078e0255ULL, 0x0000001215147210ULL, 0x000fe20007fbe0ffULL,
0x000000104e557824ULL, 0x000fc400078e0255ULL, 0x000000ffff117224ULL, 0x000fe200000e0642ULL,
0x0000001217167210ULL, 0x080fe20007f1e0ffULL, 0x000000ffff157224ULL, 0x000fe200028e061cULL,
0x000000121d1c7210ULL, 0x000fe40007fbe0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000010137faeULL, 0x0003e2000b901c46ULL, 0x000000ffff177224ULL, 0x000fe400000e0640ULL,
0x000000ffff1d7224ULL, 0x000fe200028e061eULL, 0x00000000141f7faeULL, 0x0003e8000b901c46ULL,
0x0000000016417faeULL, 0x0003e8000b901c46ULL, 0x000000001c557faeULL, 0x0003e4000b901c46ULL,
0x0000000000007918ULL, 0x002fe20000000000ULL, 0x000000a000007945ULL, 0x000fe20003800000ULL,
0x000000000000781cULL, 0x000fda0003f0f070ULL, 0x00000000520403c2ULL, 0x000e640000080000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff00c9b0ULL, 0x002fe20008000a04ULL, 0x000000000000081cULL, 0x000fe2000270f070ULL,
0xffffff8000004947ULL, 0x000fd8000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176a80053587f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0176680049167f8cULL, 0x000664000c80043fULL, 0x0000000000107805ULL, 0x000fc40000015200ULL,
0x01766c0049137984ULL, 0x000f240000000800ULL, 0x8000000013ff7812ULL, 0x012fc40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000001410147210ULL, 0x000fca0007f1e1ffULL,
0x0000000115157824ULL, 0x000fe200000e0e11ULL, 0x003d09001400780cULL, 0x000fc80003f06070ULL,
0x000000ff1500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401400780cULL, 0x000fc80003f06070ULL, 0x000000ff1500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff137819ULL, 0x000fc80000011415ULL,
0x0000001413137211ULL, 0x000fca00078110ffULL, 0x000000ffff147224ULL, 0x000fca00000e0615ULL,
0x0000000213137819ULL, 0x000fc80000001214ULL, 0x000000130000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000011c1c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01766c0049137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe40007804817ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000018012487810ULL, 0x000fca0007ffe048ULL, 0x0000000147487824ULL, 0x000fca00078e0248ULL,
0x0170000048137984ULL, 0x000e680000000800ULL, 0x0172000048147984ULL, 0x0006a20000000800ULL,
0x000000541300720bULL, 0x002fe20003f1d000ULL, 0x00009a627f007947ULL, 0x000fd8000b800000ULL,
0x0000000000157806ULL, 0x008fc800000e0100ULL, 0x0000ffff15ff7812ULL, 0x000fe2000780c0ffULL,
0x0000049000007945ULL, 0x000fe20003800000ULL, 0x00000001ff167424ULL, 0x000fe400078e00ffULL,
0x000000ffff577224ULL, 0x000fd200078e0054ULL, 0x0000045000008947ULL, 0x000fea0003800000ULL,
0x000000033d107811ULL, 0x000fe400078ff0ffULL, 0x000000541300720bULL, 0x000fe40003f14000ULL,
0x0000003d1000720cULL, 0x000fe20003fa5270ULL, 0x00009a227f007947ULL, 0x000fd4000b800000ULL,
0x0000000000167806ULL, 0x000fc400000e0100ULL, 0x000000803d12d824ULL, 0x000fe200078e0212ULL,
0x0000005413577209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x0000991016107816ULL, 0x000fe200000000ffULL, 0x000000014712d824ULL, 0x000fc600078e0212ULL,
0x000000ff1000720cULL, 0x000fe40003f05270ULL, 0x017400571200d388ULL, 0x0003f60000000800ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x0000005457107221ULL, 0x002fe20000010100ULL,
0x000000ff16ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b10107820ULL, 0x000fc80000410000ULL, 0x0000001000127308ULL, 0x000e640000000800ULL,
0x0000001207077220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff107819ULL, 0x000fe2000001160dULL, 0x000099627f007947ULL, 0x000fea000b800000ULL,
0x00001f1012107589ULL, 0x0002e400000e0000ULL, 0x0000001020207220ULL, 0x088fe40000410000ULL,
0x0000001021217220ULL, 0x080fe40000410000ULL, 0x0000001024247220ULL, 0x080fe40000410000ULL,
0x0000001025257220ULL, 0x080fe40000410000ULL, 0x0000001028287220ULL, 0x080fe40000410000ULL,
0x0000001029297220ULL, 0x000fc40000410000ULL, 0x000000102c2c7220ULL, 0x080fe40000410000ULL,
0x000000102d2d7220ULL, 0x080fe40000410000ULL, 0x0000001030307220ULL, 0x080fe40000410000ULL,
0x0000001031317220ULL, 0x080fe40000410000ULL, 0x0000001034347220ULL, 0x080fe40000410000ULL,
0x0000001035357220ULL, 0x000fc40000410000ULL, 0x0000001038387220ULL, 0x080fe40000410000ULL,
0x0000001039397220ULL, 0x080fe40000410000ULL, 0x0000001018187220ULL, 0x080fe40000410000ULL,
0x0000001019197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0016ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x000000080d107811ULL, 0x000fe200078ff0ffULL, 0x000098727f007947ULL, 0x000fea000b800000ULL,
0x00001f1012107589ULL, 0x00066400000e0000ULL, 0x0000001022227220ULL, 0x082fe40000410000ULL,
0x0000001023237220ULL, 0x080fe40000410000ULL, 0x0000001026267220ULL, 0x080fe40000410000ULL,
0x0000001027277220ULL, 0x080fe40000410000ULL, 0x000000102a2a7220ULL, 0x080fe40000410000ULL,
0x000000102b2b7220ULL, 0x000fc40000410000ULL, 0x000000102e2e7220ULL, 0x080fe40000410000ULL,
0x000000102f2f7220ULL, 0x080fe40000410000ULL, 0x0000001032327220ULL, 0x080fe40000410000ULL,
0x0000001033337220ULL, 0x080fe40000410000ULL, 0x0000001036367220ULL, 0x080fe40000410000ULL,
0x0000001037377220ULL, 0x000fc40000410000ULL, 0x000000103a3a7220ULL, 0x080fe40000410000ULL,
0x000000103b3b7220ULL, 0x080fe40000410000ULL, 0x000000101a1a7220ULL, 0x080fe40000410000ULL,
0x000000101b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff16ff7812ULL, 0x000fe20007800815ULL, 0x00000001ff167424ULL, 0x000fd800078e00ffULL,
0x0000001357130221ULL, 0x000fe20000010100ULL, 0x00007610ff160816ULL, 0x000fc60000000016ULL,
0x3fb8aa3b13130820ULL, 0x000fc80000410000ULL, 0x0000001300030308ULL, 0x000e640000000800ULL,
0x0000000314140220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000714077221ULL, 0x004fc40000010000ULL, 0x0000000000107805ULL, 0x000fca0000015200ULL,
0x0176ac0044137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780487fULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff147224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x008fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0176ac0044137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780487fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991016107816ULL, 0x000fe200000000ffULL, 0x0000019000007945ULL, 0x000fe60003800000ULL,
0x000000ff1000720cULL, 0x000fda0003f05270ULL, 0x0000016000000947ULL, 0x000fea0003800000ULL,
0x00000003ff00723eULL, 0x000fe400000000ffULL, 0x00000002ff137819ULL, 0x000fe4000001160dULL,
0x0000541000127816ULL, 0x008fe20000000000ULL, 0x000094827f007947ULL, 0x000fea000b800000ULL,
0x00001f1312027589ULL, 0x0002a400000e0000ULL, 0x0000000813107810ULL, 0x000fe20007ffe0ffULL,
0x000094d27f007947ULL, 0x000fea000b800000ULL, 0x00001f1012007589ULL, 0x00066400000e0000ULL,
0x000000637f007947ULL, 0x000fea000b800000ULL, 0x0000001013107810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x0000a510001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x00009a7000007944ULL, 0x006fea0003c00000ULL, 0x000000637f007947ULL, 0x000fea000b800000ULL,
0x0000001813107810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff177224ULL, 0x004fe200078e0012ULL,
0x0000a580001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x00009a0000007944ULL, 0x002fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000000511c783bULL, 0x000f280000004200ULL, 0x000000004f40783bULL, 0x0006a80000004200ULL,
0x000000004c10783bULL, 0x00ae680000004200ULL, 0x000000004b14783bULL, 0x0044e20000004200ULL,
0x00000018ff6e7819ULL, 0x010fe2000001141cULL, 0x000001001c4f7824ULL, 0x040fe200078e00ffULL,
0x000088801c707816ULL, 0x040fe200000000ffULL, 0x000100001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001141dULL, 0x000001001d507824ULL, 0x040fe200078e00ffULL,
0x000088801d587816ULL, 0x040fe200000000ffULL, 0x000100001d1d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff1c7819ULL, 0x000fe2000001141cULL, 0x0000007000707306ULL, 0x000fe20000200c00ULL,
0x00000018ff4f7819ULL, 0x000fc4000001144fULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff547819ULL, 0x000fe4000001141eULL, 0x00000018ff557819ULL, 0x000fe2000001141fULL,
0x0000001c00737306ULL, 0x0009e20000200c00ULL, 0x00000018ff627819ULL, 0x000fe40000011440ULL,
0x000088801e6f7816ULL, 0x000fe400000000ffULL, 0x000088801f637816ULL, 0x000fc400000000ffULL,
0x00008880406b7816ULL, 0x040fe200000000ffULL, 0x0000001d00717306ULL, 0x0003e20000200c00ULL,
0x000001001f1c7824ULL, 0x050fe200078e00ffULL, 0x00000018ff5e7819ULL, 0x000fe20000011441ULL,
0x000100001f1f7824ULL, 0x000fe200078e00ffULL, 0x0000888041667816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000004f00757306ULL, 0x0009e20000200c00ULL,
0x00000100401d7824ULL, 0x042fe200078e00ffULL, 0x00000018ff1f7819ULL, 0x000fe2000001141fULL,
0x0001000040407824ULL, 0x000fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fc40000011442ULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c006a7306ULL, 0x0003e20000200c00ULL,
0x000001001e4f7824ULL, 0x050fe200078e00ffULL, 0x00000018ff407819ULL, 0x000fe20000011440ULL,
0x000100001e1e7824ULL, 0x000fe200078e00ffULL, 0x0000888042617816ULL, 0x000fe400000000ffULL,
0x00000018ff467819ULL, 0x000fe40000011410ULL, 0x0000001d00687306ULL, 0x0009e20000200c00ULL,
0x00000100411c7824ULL, 0x042fe200078e00ffULL, 0x00000018ff1e7819ULL, 0x000fe2000001141eULL,
0x0001000041417824ULL, 0x000fe200078e00ffULL, 0x00000018ff507819ULL, 0x000fc40000011450ULL,
0x00000018ff1c7819ULL, 0x000fe4000001141cULL, 0x0000004000677306ULL, 0x000fe20000200c00ULL,
0x00000100421d7824ULL, 0x050fe200078e00ffULL, 0x00000018ff417819ULL, 0x000fe20000011441ULL,
0x0001000042427824ULL, 0x000fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe4000001144fULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001c00697306ULL, 0x0003e20000200c00ULL,
0x00000018ff427819ULL, 0x000fc40000011442ULL, 0x00000018ff4c7819ULL, 0x000fe40000011411ULL,
0x00000018ff4e7819ULL, 0x000fe40000011443ULL, 0x00008880435c7816ULL, 0x040fe200000000ffULL,
0x0000001d00607306ULL, 0x0009e20000200c00ULL, 0x00000100431c7824ULL, 0x042fe200078e00ffULL,
0x00000018ff487819ULL, 0x000fe20000011412ULL, 0x0001000043437824ULL, 0x000fe200078e00ffULL,
0x00000018ff4b7819ULL, 0x004fe40000011413ULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x0000001e006d7306ULL, 0x000fe20000200c00ULL, 0x00000100101d7824ULL, 0x010fe200078e00ffULL,
0x00000018ff437819ULL, 0x000fe40000011443ULL, 0x00000018ff477819ULL, 0x008fe40000011414ULL,
0x00000018ff407819ULL, 0x000fe4000001141dULL, 0x0000001f00647306ULL, 0x000fe20000200c00ULL,
0x00000018ff4a7819ULL, 0x000fe40000011415ULL, 0x00000018ff497819ULL, 0x000fc40000011417ULL,
0x00000018ff447819ULL, 0x000fc60000011416ULL, 0x0000001c005f7306ULL, 0x0003f00000200c00ULL,
0x0000004100657306ULL, 0x0005e20000200c00ULL, 0x012800003f1c783bULL, 0x0022ee0000000200ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x0000888010417816ULL, 0x044fe200000000ffULL,
0x0001000010107824ULL, 0x000fc400078e00ffULL, 0x00000100123f7824ULL, 0x002fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005000777306ULL, 0x0002b00000200c00ULL,
0x0000004f006c7306ULL, 0x0009e20000200c00ULL, 0x00000018ff507819ULL, 0x002fc4000001143fULL,
0x00008880133f7816ULL, 0x000fca00000000ffULL, 0x0000004200567306ULL, 0x0003e20000200c00ULL,
0x00000100114f7824ULL, 0x010fce00078e00ffULL, 0x0000001000517306ULL, 0x0009e20000200c00ULL,
0x0000888011427816ULL, 0x042fe200000000ffULL, 0x0001000011117824ULL, 0x000fe200078e00ffULL,
0x000000021c1c8232ULL, 0x088fe40000000000ULL, 0x000000021e1e8232ULL, 0x000fe40000000000ULL,
0x00000018ff117819ULL, 0x000fe20000011411ULL, 0x0000006e006e7306ULL, 0x000e620000200c00ULL,
0x0000010013107824ULL, 0x050fe200078e00ffULL, 0x000000001d1d8232ULL, 0x080fe20000000000ULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x000000001f1f8232ULL, 0x000fc40000000000ULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x0000005a005a7306ULL, 0x000ee20000200c00ULL,
0x00000018ff137819ULL, 0x000fce0000011413ULL, 0x0000001100537306ULL, 0x0005f00000200c00ULL,
0x0000001000527306ULL, 0x0009e20000200c00ULL, 0x0000541058117816ULL, 0x004fce0000000077ULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x0000541070107816ULL, 0x010fe40000000075ULL,
0x0000888014707816ULL, 0x000fca00000000ffULL, 0x0000006300637306ULL, 0x000f220000200c00ULL,
0x000000101c20723cULL, 0x000bee0000001820ULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x0000541073107816ULL, 0x022fe4000000006eULL, 0x0000541071117816ULL, 0x008fe2000000005aULL,
0x000000ffff5a7224ULL, 0x000fc800078e0070ULL, 0x0000005500557306ULL, 0x000e640000200c00ULL,
0x000000101c24723cULL, 0x000b6c0000001824ULL, 0x00000043005d7306ULL, 0x0007e20000200c00ULL,
0x000054106f107816ULL, 0x024fe4000000006cULL, 0x0000541063117816ULL, 0x010fc4000000006aULL,
0x000054106d547816ULL, 0x000fe40000000054ULL, 0x00008880156a7816ULL, 0x040fe200000000ffULL,
0x0000006b006b7306ULL, 0x000ea20000200c00ULL, 0x00000018ff437819ULL, 0x008fe2000001144fULL,
0x000000101c28723cULL, 0x000f620000001828ULL, 0x00008880124f7816ULL, 0x040fe200000000ffULL,
0x0001000012127824ULL, 0x000fe200078e00ffULL, 0x0000541064557816ULL, 0x002fe20000000055ULL,
0x000000ffff647224ULL, 0x000fe400078e006aULL, 0x0000006600667306ULL, 0x000e620000200c00ULL,
0x00000018ff127819ULL, 0x000fe20000011412ULL, 0x00000100156a7824ULL, 0x000fc400078e00ffULL,
0x000000541c2c723cULL, 0x000be8000000182cULL, 0x00000012005b7306ULL, 0x0007e60000200c00ULL,
0x000054106b547816ULL, 0x024fca0000000068ULL, 0x0000006200627306ULL, 0x000ea20000200c00ULL,
0x0000010014127824ULL, 0x008fe200078e00ffULL, 0x0000541066557816ULL, 0x002fe20000000069ULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x00000018ff697819ULL, 0x000fe4000001146aULL,
0x00000018ff637819ULL, 0x000fe40000011412ULL, 0x0000005e005e7306ULL, 0x000e620000200c00ULL,
0x000000541c30723cULL, 0x000be20000001830ULL, 0x00000018ff147819ULL, 0x000fcc0000011414ULL,
0x0000001300587306ULL, 0x0007e20000200c00ULL, 0x0000541067547816ULL, 0x024fce0000000062ULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x012800003e10783bULL, 0x0084e20000000200ULL,
0x0000541065557816ULL, 0x002fcc000000005eULL, 0x0000005c005c7306ULL, 0x000e620000200c00ULL,
0x000000541c34723cULL, 0x000b6e0000001834ULL, 0x0000004d004d7306ULL, 0x000f220000200c00ULL,
0x0001000015547824ULL, 0x020fca00078e00ffULL, 0x00000018ff547819ULL, 0x000fe40000011454ULL,
0x0000004e004e7306ULL, 0x000ee20000200c00ULL, 0x000054105c157816ULL, 0x002fe4000000005fULL,
0x00008880165c7816ULL, 0x000fca00000000ffULL, 0x00000014003e7306ULL, 0x0043f00000200c00ULL,
0x0000004600467306ULL, 0x000fe20000200c00ULL, 0x0000541061147816ULL, 0x002fe20000000060ULL,
0x0000000210108232ULL, 0x008fc40000000000ULL, 0x0000000212128232ULL, 0x000fe40000000000ULL,
0x0000000011118232ULL, 0x080fe40000000000ULL, 0x0000004c004c7306ULL, 0x000e620000200c00ULL,
0x000000141c38723cULL, 0x000b620000001838ULL, 0x0000000013138232ULL, 0x000fcc0000000000ULL,
0x0000541056147816ULL, 0x030fe2000000004dULL, 0x000000ffff4d7224ULL, 0x000fe200078e005cULL,
0x000054105d157816ULL, 0x000fe2000000004eULL, 0x0000004800487306ULL, 0x000fec0000200c00ULL,
0x000000141c18723cULL, 0x000b640000001818ULL, 0x0000004100417306ULL, 0x000fea0000200c00ULL,
0x00008880171c7816ULL, 0x020fe200000000ffULL, 0x0000010016157824ULL, 0x040fe200078e00ffULL,
0x00005410531d7816ULL, 0x002fe2000000004cULL, 0x00000100171e7824ULL, 0x040fe200078e00ffULL,
0x0000001c001f7306ULL, 0x0003e20000200c00ULL, 0x0001000017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x0001000016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fc8000001141eULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x0000004000407306ULL, 0x000ea20000200c00ULL, 0x00005410511c7816ULL, 0x002fce0000000046ULL,
0x0000001c1024723cULL, 0x000b620000001824ULL, 0x0000003f003f7306ULL, 0x000e6c0000200c00ULL,
0x00000018ff1c7819ULL, 0x020fe40000011417ULL, 0x0000004d00147306ULL, 0x000fe20000200c00ULL,
0x0000541041407816ULL, 0x004fce0000000040ULL, 0x0000001500157306ULL, 0x000ea20000200c00ULL,
0x000054103f517816ULL, 0x002fce0000000052ULL, 0x0000004b004b7306ULL, 0x000e700000200c00ULL,
0x0000004700477306ULL, 0x000ee20000200c00ULL, 0x0000541014147816ULL, 0x004fce0000000015ULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x0000541058177816ULL, 0x002fce000000004bULL,
0x0000004400447306ULL, 0x000fe20000200c00ULL, 0x000054103e3e7816ULL, 0x008fce0000000047ULL,
0x0000004900497306ULL, 0x000ff00000200c00ULL, 0x0000004200427306ULL, 0x000ff00000200c00ULL,
0x0000004300437306ULL, 0x000e700000200c00ULL, 0x0000004f004f7306ULL, 0x000ff00000200c00ULL,
0x0000005000507306ULL, 0x000ea20000200c00ULL, 0x0000541042417816ULL, 0x002fce0000000043ULL,
0x0000005a005a7306ULL, 0x000fe20000200c00ULL, 0x000000401020723cULL, 0x000f6e0000001820ULL,
0x0000006300637306ULL, 0x000e620000200c00ULL, 0x000054104f507816ULL, 0x004fce0000000050ULL,
0x0000006400647306ULL, 0x000fe20000200c00ULL, 0x000000501028723cULL, 0x000f6e0000001828ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x000054105a5a7816ULL, 0x002fce0000000063ULL,
0x0000005400557306ULL, 0x000e700000200c00ULL, 0x0000001e001e7306ULL, 0x000eb00000200c00ULL,
0x00000016001d7306ULL, 0x0007220000200c00ULL, 0x00005410553f7816ULL, 0x002fce000000004aULL,
0x0000001c001c7306ULL, 0x000e620000200c00ULL, 0x000054105b167816ULL, 0x008fe20000000048ULL,
0x0000003e1034723cULL, 0x000f620000001834ULL, 0x00005410645b7816ULL, 0x000fe40000000069ULL,
0x000054101f157816ULL, 0x004fe4000000001eULL, 0x000054101d487816ULL, 0x010fc60000000044ULL,
0x00000016102c723cULL, 0x000f62000000182cULL, 0x000054101c497816ULL, 0x002fce0000000049ULL,
0x0000005a1030723cULL, 0x040f700000001830ULL, 0x000000141038723cULL, 0x040f700000001838ULL,
0x000000481018723cULL, 0x000b6e0000001818ULL, 0x000176c80b127811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000012127f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0176a00045ff7f8cULL, 0x0005e2000c80043fULL,
0x0000000205417810ULL, 0x000fc40007ffe0ffULL, 0x0000000104127812ULL, 0x002fc400078ec0ffULL,
0x0000000106067810ULL, 0x004fc80007ffe0ffULL, 0x0000000f0600720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x000fe20003c00000ULL, 0xffff5d2000007947ULL, 0x000fea000383ffffULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x0000037000008947ULL, 0x000fea0003800000ULL,
0x0180000007007810ULL, 0x000fe20007ffe0ffULL, 0x000000b000007945ULL, 0x000fe60003800000ULL,
0x7f80000000007812ULL, 0x000fc800078ec0ffULL, 0x01ffffff0000780cULL, 0x000fda0003f04070ULL,
0x0000003000000947ULL, 0x000fea0003800000ULL, 0x0000b57000047802ULL, 0x000fc40000000f00ULL,
0x0000885000007944ULL, 0x016fea0003c00000ULL, 0x0000004000007947ULL, 0x000fea0003800000ULL,
0x0000000700007308ULL, 0x000ee40000001000ULL, 0xbf80000000027423ULL, 0x008fc80000000007ULL,
0x800000ff02037221ULL, 0x000fc80000010100ULL, 0x0000000300007223ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00006900ff037624ULL, 0x000fe400078e00ffULL,
0x00006800ff027624ULL, 0x000fca00078e00ffULL, 0x0000000602037981ULL, 0x008ee8000c1e9900ULL,
0x0000000000047919ULL, 0x000ea80000000000ULL, 0x0000000000077919ULL, 0x006e620000000000ULL,
0x00000002ff067819ULL, 0x000fe40000011604ULL, 0x0000000807047811ULL, 0x002fe200078ff0ffULL,
0x0000000003057220ULL, 0x008fca0000410000ULL, 0x00001f0605007589ULL, 0x000e6800000e0000ULL,
0x00001f0405047589ULL, 0x000ea200000e0000ULL, 0x0000002000207220ULL, 0x042fe40000410000ULL,
0x0000002100217220ULL, 0x040fe40000410000ULL, 0x0000002400247220ULL, 0x040fe40000410000ULL,
0x0000002500257220ULL, 0x000fc40000410000ULL, 0x0000002800287220ULL, 0x040fe40000410000ULL,
0x0000002900297220ULL, 0x040fe40000410000ULL, 0x0000002c002c7220ULL, 0x040fe40000410000ULL,
0x0000002d002d7220ULL, 0x040fe40000410000ULL, 0x0000003000307220ULL, 0x040fe40000410000ULL,
0x0000003100317220ULL, 0x000fc40000410000ULL, 0x0000003400347220ULL, 0x040fe40000410000ULL,
0x0000003500357220ULL, 0x040fe40000410000ULL, 0x0000003800387220ULL, 0x040fe40000410000ULL,
0x0000003900397220ULL, 0x040fe40000410000ULL, 0x0000001800187220ULL, 0x040fe40000410000ULL,
0x0000001900197220ULL, 0x000fc40000410000ULL, 0x0000002204227220ULL, 0x044fe40000410000ULL,
0x0000002304237220ULL, 0x040fe40000410000ULL, 0x0000002604267220ULL, 0x040fe40000410000ULL,
0x0000002704277220ULL, 0x040fe40000410000ULL, 0x0000002a042a7220ULL, 0x040fe40000410000ULL,
0x0000002b042b7220ULL, 0x000fc40000410000ULL, 0x0000002e042e7220ULL, 0x040fe40000410000ULL,
0x0000002f042f7220ULL, 0x040fe40000410000ULL, 0x0000003204327220ULL, 0x040fe40000410000ULL,
0x0000003304337220ULL, 0x040fe40000410000ULL, 0x0000003604367220ULL, 0x040fe40000410000ULL,
0x0000003704377220ULL, 0x000fc40000410000ULL, 0x0000003a043a7220ULL, 0x040fe40000410000ULL,
0x0000003b043b7220ULL, 0x040fe40000410000ULL, 0x0000001a041a7220ULL, 0x040fe40000410000ULL,
0x0000001b041b7220ULL, 0x000fc40000410000ULL, 0x0000000000007919ULL, 0x000ee20000000000ULL,
0x000010003d067824ULL, 0x000fe200078e00ffULL, 0x000000343535723eULL, 0x000fe400000000ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000383938723eULL, 0x000fc400000000ffULL,
0x00000018191c723eULL, 0x000fe400000000ffULL, 0x0000002a2b2a723eULL, 0x000fe400000000ffULL,
0x000000323332723eULL, 0x000fe400000000ffULL, 0x000000363719723eULL, 0x000fe400000000ffULL,
0x0000003a3b3a723eULL, 0x000fe400000000ffULL, 0x0000001a1b1d723eULL, 0x000fc400000000ffULL,
0x00000002ff057819ULL, 0x108fe20000011600ULL, 0x0000000109097824ULL, 0x000fe200078e0200ULL,
0x0000000200027812ULL, 0x040fe400078ec0ffULL, 0x0000000800077811ULL, 0x000fe200078ff0ffULL,
0x00000008050c7824ULL, 0x010fe200078e00ffULL, 0x0000000502037211ULL, 0x040fe400078ff8ffULL,
0x0000000702047211ULL, 0x000fe200078ff8ffULL, 0x00000008070d7824ULL, 0x000fe200078e00ffULL,
0x0000000203027810ULL, 0x000fe20007ffe0ffULL, 0x0000000805077824ULL, 0x000fe200078e00ffULL,
0x000000ff0b00720cULL, 0x000fc40003f05270ULL, 0xfffffff80d0e7812ULL, 0x000fe200078ee204ULL,
0x0000000805047824ULL, 0x000fe200078e00ffULL, 0xfffffff807087812ULL, 0x000fe200078ee202ULL,
0x00000008050d7824ULL, 0x000fe200078e00ffULL, 0x0000100006027812ULL, 0x000fe200078ee2ffULL,
0x0000000800057824ULL, 0x000fe200078e00ffULL, 0x0000000403067810ULL, 0x040fe40007ffe0ffULL,
0x0000000603077810ULL, 0x000fe20007ffe0ffULL, 0x0000001009097824ULL, 0x100fe200078e0202ULL,
0xfffffff804047812ULL, 0x000fe200078ee203ULL, 0x000008000b037824ULL, 0x000fe200078e0202ULL,
0xfffffff80d0a7812ULL, 0x000fc400078ee206ULL, 0xfffffff80c0c7812ULL, 0x000fe200078ee207ULL,
0x000000100e137824ULL, 0x104fe200078e0203ULL, 0x0000000805067812ULL, 0x000fe200078ec0ffULL,
0x0000001004057824ULL, 0x100fe200078e0203ULL, 0x000000242504723eULL, 0x000fe200000000ffULL,
0x00000010080d7824ULL, 0x000fe200078e0203ULL, 0x000054103a0e7816ULL, 0x000fe2000000001dULL,
0x000000100a0f7824ULL, 0x100fe400078e0203ULL, 0x000000100c117824ULL, 0x000fe200078e0203ULL,
0x000000202103723eULL, 0x000fe200000000ffULL, 0x0000000105077824ULL, 0x000fe200078e0206ULL,
0x000000303105723eULL, 0x000fe200000000ffULL, 0x0000000106137824ULL, 0x040fe200078e0213ULL,
0x0000541003147816ULL, 0x140fe20000000004ULL, 0x00000001060d7824ULL, 0x040fe200078e020dULL,
0x0000763203157816ULL, 0x000fe20000000004ULL, 0x00000001060f7824ULL, 0x040fe200078e020fULL,
0x000000282903723eULL, 0x000fe200000000ffULL, 0x0000000106117824ULL, 0x000fe200078e0211ULL,
0x0000002c2d04723eULL, 0x000fe200000000ffULL, 0x0000001407007388ULL, 0x0005e20000000a00ULL,
0x0000541005347816ULL, 0x000fc40000000035ULL, 0x0000541003067816ULL, 0x100fe40000000004ULL,
0x0000763205357816ULL, 0x000fe40000000035ULL, 0x00005410320c7816ULL, 0x000fe40000000019ULL,
0x0000763203077816ULL, 0x004fe40000000004ULL, 0x000000222303723eULL, 0x000fe400000000ffULL,
0x000000262704723eULL, 0x000fe200000000ffULL, 0x000000060d007388ULL, 0x0005e20000000a00ULL,
0x0000002e2f15723eULL, 0x000fc600000000ffULL, 0x000000340f007388ULL, 0x000fe20000000a00ULL,
0x000054102a147816ULL, 0x140fe40000000015ULL, 0x000076322a157816ULL, 0x000fe40000000015ULL,
0x0000541038067816ULL, 0x144fe4000000001cULL, 0x0000763238077816ULL, 0x000fca000000001cULL,
0x0000000611007388ULL, 0x0005e40000000a00ULL, 0x0000541003067816ULL, 0x144fe40000000004ULL,
0x0000763203077816ULL, 0x000fca0000000004ULL, 0x0000000613007388ULL, 0x000fe80000000a00ULL,
0x000400140d007388ULL, 0x0005e40000000a00ULL, 0x00007632320d7816ULL, 0x004fca0000000019ULL,
0x0004000c0f007388ULL, 0x0005e40000000a00ULL, 0x000076323a0f7816ULL, 0x004fca000000001dULL,
0x0004000e11007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000009047984ULL, 0x000ea80000000c00ULL, 0x0004000009187984ULL, 0x000ee80000000c00ULL,
0x0008000009147984ULL, 0x000e680000000c00ULL, 0x000c0000091c7984ULL, 0x000e620000000c00ULL,
0x200000ff07077230ULL, 0x004fc40000000000ULL, 0x200000ff06067230ULL, 0x000fe40000000000ULL,
0x200000ff05057230ULL, 0x000fe40000000000ULL, 0x200000ff04047230ULL, 0x000fe40000000000ULL,
0x200000ff1b1b7230ULL, 0x008fe40000000000ULL, 0x200000ff1a1a7230ULL, 0x000fe40000000000ULL,
0x200000ff19197230ULL, 0x000fc40000000000ULL, 0x200000ff18187230ULL, 0x000fe40000000000ULL,
0x0000001707077230ULL, 0x002fe40000000000ULL, 0x0000001606067230ULL, 0x000fe40000000000ULL,
0x0000001505057230ULL, 0x000fe40000000000ULL, 0x0000001404047230ULL, 0x000fe40000000000ULL,
0x0000001f1b1b7230ULL, 0x000fc40000000000ULL, 0x0000001e1a1a7230ULL, 0x000fe20000000000ULL,
0x0000000409007388ULL, 0x000fe20000000c00ULL, 0x0000001d19197230ULL, 0x000fe40000000000ULL,
0x0000001c18187230ULL, 0x000fca0000000000ULL, 0x0004001809007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000002000067810ULL, 0x000fe20007ffe0ffULL, 0x0000000000107919ULL, 0x000e620000002600ULL,
0x00000003ff117819ULL, 0x000fe20000011600ULL, 0x00000000000579c3ULL, 0x000ea20000002700ULL,
0x00000003ff057819ULL, 0x000fe20000011606ULL, 0x0000580000047ab9ULL, 0x000fe20000000800ULL,
0x000000013d3d7812ULL, 0x000fe200078ec0ffULL, 0x0000000111037824ULL, 0x000fe200078e0200ULL,
0x0000000304047899ULL, 0x000fe2000800063fULL, 0x0000000106047824ULL, 0x000fc600078e0205ULL,
0x0000000703037812ULL, 0x000fe400078ec0ffULL, 0x0000000704077812ULL, 0x000fe400078ec0ffULL,
0x0ffffff803037812ULL, 0x000fe400078ef800ULL, 0x0ffffff807077812ULL, 0x000fc600078ef806ULL,
0x0000001003037824ULL, 0x100fe400078e0202ULL, 0x0000001007077824ULL, 0x000fe400078e0202ULL,
0x0000000810027824ULL, 0x042fe200078e00ffULL, 0x0000000003087984ULL, 0x000e620000000c00ULL,
0x0000000810107824ULL, 0x000fe200078e00ffULL, 0x00000005040472a4ULL, 0x004fe4000f8e023fULL,
0x00000000070c7984ULL, 0x0004e20000000c00ULL, 0xfffffff802027812ULL, 0x000fc400078ee211ULL,
0xfffffff810057812ULL, 0x000fe400078ee205ULL, 0x0000000402117c10ULL, 0x000fe4000ff1e0ffULL,
0x0000000405057c10ULL, 0x000fe2000ff3e0ffULL, 0x000000083d077824ULL, 0x004fe400078e00ffULL,
0x000000ffff127224ULL, 0x000fe200000e06ffULL, 0x00005a0011027a11ULL, 0x000fe200078040ffULL,
0x000000ffff107224ULL, 0x000fe200008e06ffULL, 0x00005a0005047a11ULL, 0x000fe200078240ffULL,
0x000000083d3d7824ULL, 0x000fe200078e00ffULL, 0x00005b0011037a11ULL, 0x000fc400000f4412ULL,
0xfffffff807077812ULL, 0x000fe400078ee200ULL, 0x00005b0005057a11ULL, 0x000fe400008f4410ULL,
0xfffffff83d117812ULL, 0x000fe200078ee206ULL, 0x0000001007027825ULL, 0x000fc800078e0002ULL,
0x0000001011047825ULL, 0x000fe200078e0004ULL, 0x0000000802007986ULL, 0x002fe8000c101d06ULL,
0x0000000c04007986ULL, 0x008fe2000c101d06ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff057819ULL, 0x000fe2000001163dULL, 0xffffffffff077424ULL, 0x002fc600078e00ffULL,
0x0000000e0500720cULL, 0x000fda0003f06070ULL, 0x0000000206108824ULL, 0x000fc800078e00ffULL,
0x0000640010108a24ULL, 0x000fc800078e0205ULL, 0x0000600010108625ULL, 0x000fe200078e000bULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00006800ff127624ULL, 0x000fe200078e00ffULL,
0x0000000610078981ULL, 0x000ea2000c1e1900ULL, 0x00006900ff137624ULL, 0x000fc600078e00ffULL,
0x01760000ff087f8cULL, 0x000e68000c80043fULL, 0x00000006120a7981ULL, 0x000722000c1e9900ULL,
0x000001ff0000780cULL, 0x000fe20003f04070ULL, 0x0000008014007824ULL, 0x000fe400078e00ffULL,
0x000000403d037824ULL, 0x000fe400078e00ffULL, 0x0000008015027824ULL, 0x000fc600078e00ffULL,
0x00000040000c7812ULL, 0x000fe200078ef803ULL, 0x0000000702077224ULL, 0x004fc800078e02ffULL,
0x00000e8000000947ULL, 0x000fea0003800000ULL, 0x000000033c107217ULL, 0x00afe40007800000ULL,
0x00000003ff127819ULL, 0x000fe4000001160dULL, 0x0000007004047812ULL, 0x000fe200078ec0ffULL,
0x0000000110117824ULL, 0x000fe200078e0a03ULL, 0x0000000412147810ULL, 0x000fe20007ffe0ffULL,
0x000000010c107824ULL, 0x000fe200078e0212ULL, 0x0000000812187810ULL, 0x000fe40007ffe0ffULL,
0x000000111400720cULL, 0x040fe20003f06070ULL, 0x0000000114137824ULL, 0x100fe200078e020dULL,
0x0000001007207210ULL, 0x040fe20007f3e0ffULL, 0x000000010c107824ULL, 0x000fe200078e0214ULL,
0x00000014121a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000814167824ULL, 0x000fe200078e00ffULL,
0x0000000c12267810ULL, 0x000fe20007ffe0ffULL, 0x0000000118147824ULL, 0x040fe200078e020dULL,
0x0000001007107210ULL, 0x000fe20007f5e0ffULL, 0x00000008181d7824ULL, 0x000fe200078e00ffULL,
0xfffffff8161b7812ULL, 0x000fe200078ee213ULL, 0x000000ffff177224ULL, 0x000fe200008e06ffULL,
0x00005e00201f7a11ULL, 0x000fe200078238ffULL, 0x000000ffff157224ULL, 0x000fe200010e06ffULL,
0x00005e0010257a11ULL, 0x000fe200078438ffULL, 0x000000010c1c7824ULL, 0x000fe200078e021aULL,
0x0000001012167810ULL, 0x000fc40007ffe0ffULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee214ULL,
0x000000010c147824ULL, 0x000fe200078e0226ULL, 0x00005f0020207a11ULL, 0x000fe400008f3c17ULL,
0x00005f0010227a11ULL, 0x000fe200010f3c15ULL, 0x000000010c107824ULL, 0x000fe200078e0218ULL,
0x000000111800720cULL, 0x000fe20003f26070ULL, 0x000000010c187824ULL, 0x000fe200078e0216ULL,
0x0000001c071c7210ULL, 0x040fe40007f7e0ffULL, 0x0000001407147210ULL, 0x000fc40007fbe0ffULL,
0x0000001807187210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff137224ULL, 0x000fe200018e06ffULL,
0x00005e001c297a11ULL, 0x000fe200078638ffULL, 0x000000ffff177224ULL, 0x000fe200028e06ffULL,
0x00005e00142d7a11ULL, 0x000fe200078a38ffULL, 0x000000ffff157224ULL, 0x000fe200010e06ffULL,
0x00000018121e7810ULL, 0x000fe40007ffe0ffULL, 0x00005f001c287a11ULL, 0x000fe200018f3c13ULL,
0x0000000112137824ULL, 0x000fe200078e020dULL, 0x00005e00182b7a11ULL, 0x000fe200078438ffULL,
0x00000008261c7824ULL, 0x000fe200078e00ffULL, 0x0000001007107210ULL, 0x000fc40007f9e0ffULL,
0x00005f00142c7a11ULL, 0x000fe200028f3c17ULL, 0x000000010c147824ULL, 0x000fe200078e021eULL,
0x00005f00182a7a11ULL, 0x000fe200010f3c15ULL, 0x000000ffff197224ULL, 0x000fe200020e06ffULL,
0x0000000713187812ULL, 0x000fe200078ec0ffULL, 0x0000000126137824ULL, 0x140fe200078e020dULL,
0x000000112600720cULL, 0x000fe20003fa6070ULL, 0x0000000116177824ULL, 0x000fe200078e020dULL,
0x00005e0010237a11ULL, 0x000fe400078838ffULL, 0x0000001407267210ULL, 0x000fc40007fde0ffULL,
0x000000041f147210ULL, 0x000fe40007f7e0ffULL, 0x00005f0010247a11ULL, 0x000fe200020f3c19ULL,
0x000000ffff197224ULL, 0x000fe200030e06ffULL, 0x000010003d107811ULL, 0x000fe200078e70ffULL,
0x000000ffff157224ULL, 0x000fe200018e0620ULL, 0x000000111600720cULL, 0x040fe20003f86070ULL,
0x0000000816167824ULL, 0x000fe200078e00ffULL, 0x0ffffff818217812ULL, 0x000fe200078ef80dULL,
0x000000101d1d7824ULL, 0x000fe200078e0210ULL, 0x00005e0026277a11ULL, 0x000fc400078638ffULL,
0xfffffff81c1f7812ULL, 0x000fe200078ee213ULL, 0x0000001021137824ULL, 0x100fe200078e0210ULL,
0xfffffff816217812ULL, 0x000fe200078ee217ULL, 0x000000011a1c7824ULL, 0x000fe200078e020dULL,
0x00005f0026267a11ULL, 0x000fe200018f3c19ULL, 0x000000101f1f7824ULL, 0x100fe200078e0210ULL,
0x0000000425167210ULL, 0x080fe20007f7e0ffULL, 0x000000081e257824ULL, 0x000fe200078e00ffULL,
0x0000001c12207810ULL, 0x040fe20007ffe0ffULL, 0x0000001021217824ULL, 0x000fe200078e0210ULL,
0x000000111200720cULL, 0x000fe20003f46070ULL, 0x000000ffff177224ULL, 0x000fe200018e0622ULL,
0x0000000423187210ULL, 0x000fe20007f7e0ffULL, 0x000000010c227824ULL, 0x000fc400078e0220ULL,
0x000000081a237824ULL, 0x000fe400078e00ffULL, 0x000000ffff197224ULL, 0x000fe200018e0624ULL,
0x0000002207227210ULL, 0x000fe40007fde0ffULL, 0x000000111e00720cULL, 0x080fe40003f66070ULL,
0xfffffff823237812ULL, 0x000fe200078ee21cULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000014137faeULL, 0x0003e2000d101c46ULL, 0x000000111a00720cULL, 0x000fe20003f46070ULL,
0x00000001201c7824ULL, 0x000fc400078e020dULL, 0x0000001023237824ULL, 0x100fe400078e0210ULL,
0x000000011e147824ULL, 0x002fe200078e020dULL, 0x00000020121e7810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff157224ULL, 0x000fe200030e06ffULL, 0x00005e00222f7a11ULL, 0x040fe200078c38ffULL,
0x000000101b137824ULL, 0x000fe200078e0210ULL, 0xfffffff825257812ULL, 0x000fe400078ee214ULL,
0x00005f0022247a11ULL, 0x000fe200030f3c15ULL, 0x000000010c227824ULL, 0x000fe200078e021eULL,
0x000000042d147210ULL, 0x000fe20007fde0ffULL, 0x0000000016137faeULL, 0x0003e2000c101c46ULL,
0x000000112000720cULL, 0x000fe20003f06070ULL, 0x0000001025257824ULL, 0x000fc400078e0210ULL,
0x00000000181d7faeULL, 0x0005e2000c901c46ULL, 0x000000ffff157224ULL, 0x000fe200030e062cULL,
0x0000002207227210ULL, 0x000fe40007fde0ffULL, 0x000000042b1a7210ULL, 0x000fe20007f3e0ffULL,
0x00000008202b7824ULL, 0x000fe200078e00ffULL, 0x00000000141f7faeULL, 0x0007e2000e901c46ULL,
0x000000011e167824ULL, 0x002fe400078e020dULL, 0x000000ffff177224ULL, 0x000fe200030e06ffULL,
0x00005e00222d7a11ULL, 0x000fe200078c38ffULL, 0x000000081e1d7824ULL, 0x004fe200078e00ffULL,
0x0000002412187810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff1b7224ULL, 0x000fe200008e062aULL,
0x000000111e00720cULL, 0x000fc40003f26070ULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee216ULL,
0x000000010c167824ULL, 0x000fe200078e0218ULL, 0x00005f0022207a11ULL, 0x000fe200030f3c17ULL,
0x000000001a217faeULL, 0x0003e2000e101c46ULL, 0x000000111800720cULL, 0x040fe20003f86070ULL,
0x0000000118197824ULL, 0x040fe200078e020dULL, 0x00000016071e7210ULL, 0x000fe20007fde0ffULL,
0x0000000818187824ULL, 0x000fe200078e00ffULL, 0x0000000429167210ULL, 0x080fe20007fbe0ffULL,
0x000000101d1f7824ULL, 0x008fe200078e0210ULL, 0xfffffff82b137812ULL, 0x000fe200078ee21cULL,
0x000000ffff2b7224ULL, 0x000fe200030e06ffULL, 0x00005e001e297a11ULL, 0x000fe200078c38ffULL,
0x000000ffff177224ULL, 0x000fe200028e0628ULL, 0x0000000427147210ULL, 0x000fe20007fbe0ffULL,
0x0000001013137824ULL, 0x000fe200078e0210ULL, 0xfffffff818277812ULL, 0x000fc400078ee219ULL,
0x0000000016237faeULL, 0x0005e2000d101c46ULL, 0x000000ffff157224ULL, 0x000fe200028e0626ULL,
0x000000042f187210ULL, 0x080fe20007f5e0ffULL, 0x0000001027277824ULL, 0x000fe200078e0210ULL,
0x00005f001e1e7a11ULL, 0x000fe400030f3c2bULL, 0x0000000014257faeULL, 0x0007e2000d901c46ULL,
0x000000ffff197224ULL, 0x000fe200010e0624ULL, 0x000000042d1a7210ULL, 0x082fe40007f7e0ffULL,
0x00000004291c7210ULL, 0x000fc40007f5e0ffULL, 0x0000002c12167810ULL, 0x044fe20007ffe0ffULL,
0x000000ffff1b7224ULL, 0x000fe200018e0620ULL, 0x0000003412207810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff1d7224ULL, 0x000fe200010e061eULL, 0x00000030121e7810ULL, 0x040fe20007ffe0ffULL,
0x0000000018137faeULL, 0x0003e2000c101c46ULL, 0x0000002812147810ULL, 0x008fe20007ffe0ffULL,
0x0000000816177824ULL, 0x000fe200078e00ffULL, 0x0000003812227810ULL, 0x040fe20007ffe0ffULL,
0x000000001a1f7faeULL, 0x0005e2000c901c46ULL, 0x0000003c12247810ULL, 0x000fe20007ffe0ffULL,
0x000000010c127824ULL, 0x000fe200078e0214ULL, 0x000000111400720cULL, 0x080fe20003fa6070ULL,
0x000000001c277faeULL, 0x0007e2000e101c46ULL, 0x000000111600720cULL, 0x000fc40003f86070ULL,
0x000000111e00720cULL, 0x080fe20003f66070ULL, 0x0000000114137824ULL, 0x102fe200078e020dULL,
0x000000112000720cULL, 0x080fe20003f46070ULL, 0x0000000814187824ULL, 0x000fe200078e00ffULL,
0x0000001207147210ULL, 0x000fe20007f1e0ffULL, 0x0000000116127824ULL, 0x000fe200078e020dULL,
0x000000112200720cULL, 0x080fe20003f26070ULL, 0x000000010c167824ULL, 0x000fe200078e0216ULL,
0x00005e0014157a11ULL, 0x000fe200078c38ffULL, 0x000000ffff197224ULL, 0x000fe200000e06ffULL,
0x000000112400720cULL, 0x000fe20003f06070ULL, 0x00000008201a7824ULL, 0x004fe200078e00ffULL,
0xfffffff818117812ULL, 0x000fe200078ee213ULL, 0x00000008221d7824ULL, 0x008fe200078e00ffULL,
0xfffffff817177812ULL, 0x000fc400078ee212ULL, 0x00005f0014137a11ULL, 0x000fe200030f3c19ULL,
0x000000011e147824ULL, 0x100fe200078e020dULL, 0x0000000415127210ULL, 0x000fe20007fde0ffULL,
0x0000000120157824ULL, 0x000fe400078e020dULL, 0x000000081e197824ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x000fe200030e0613ULL, 0x0000001607187210ULL, 0x000fe20007fde0ffULL,
0x000000010c1e7824ULL, 0x000fe200078e021eULL, 0xfffffff81a1b7812ULL, 0x000fe200078ee215ULL,
0x0000001011117824ULL, 0x000fe200078e0210ULL, 0xfffffff819197812ULL, 0x000fe200078ee214ULL,
0x000000ffff217224ULL, 0x000fe200030e06ffULL, 0x00005e00181f7a11ULL, 0x000fe200078c38ffULL,
0x000000010c207824ULL, 0x000fe200078e0220ULL, 0x0000000012117faeULL, 0x0003e2000e901c46ULL,
0x0000000122167824ULL, 0x000fe200078e020dULL, 0x00005f0018157a11ULL, 0x000fe200030f3c21ULL,
0x000000010c227824ULL, 0x040fe200078e0222ULL, 0x000000041f147210ULL, 0x000fe20007fde0ffULL,
0x000000010c0c7824ULL, 0x000fe200078e0224ULL, 0x0000002007207210ULL, 0x000fe20007fbe0ffULL,
0x00000001240d7824ULL, 0x040fe200078e020dULL, 0xfffffff81d1d7812ULL, 0x000fe200078ee216ULL,
0x000000ffff157224ULL, 0x000fe200030e0615ULL, 0x0000001e071e7210ULL, 0x000fe20007fde0ffULL,
0x0000000824247824ULL, 0x000fc400078e00ffULL, 0x0000001017177824ULL, 0x100fe400078e0210ULL,
0x000000ffff1f7224ULL, 0x000fe200030e06ffULL, 0x00005e001e237a11ULL, 0x000fe200078c38ffULL,
0x000000ffff217224ULL, 0x000fe200028e06ffULL, 0xfffffff8240d7812ULL, 0x000fe200078ee20dULL,
0x0000000014177faeULL, 0x0005e2000e101c46ULL, 0x00005f001e1a7a11ULL, 0x000fe200030f3c1fULL,
0x0000001019197824ULL, 0x100fe200078e0210ULL, 0x00005e00201f7a11ULL, 0x040fe200078a38ffULL,
0x000000101b1b7824ULL, 0x100fe200078e0210ULL, 0x0000000c07167210ULL, 0x000fe20007fde0ffULL,
0x000000101d1d7824ULL, 0x000fe200078e0210ULL, 0x00005f0020187a11ULL, 0x000fc400028f3c21ULL,
0x0000002207227210ULL, 0x000fe20007f9e0ffULL, 0x000000100d077824ULL, 0x000fe200078e0210ULL,
0x00000004230c7210ULL, 0x080fe20007fbe0ffULL, 0x000000ffff117224ULL, 0x002fe200030e06ffULL,
0x00005e0016157a11ULL, 0x004fe200078c38ffULL, 0x000000ffff177224ULL, 0x000fe200020e06ffULL,
0x00005e0022137a11ULL, 0x040fe200078838ffULL, 0x000000ffff0d7224ULL, 0x000fe200028e061aULL,
0x000000041f107210ULL, 0x000fe40007fbe0ffULL, 0x00005f0022177a11ULL, 0x000fc400020f3c17ULL,
0x00005f0016167a11ULL, 0x000fe200030f3c11ULL, 0x000000ffff117224ULL, 0x000fe200028e0618ULL,
0x0000000413127210ULL, 0x080fe20007f9e0ffULL, 0x000000000c197faeULL, 0x0003e2000d901c46ULL,
0x0000000415147210ULL, 0x000fc60007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200020e0617ULL,
0x00000000101b7faeULL, 0x0003e2000d101c46ULL, 0x000000ffff157224ULL, 0x000fc600028e0616ULL,
0x00000000121d7faeULL, 0x0003e8000c901c46ULL, 0x0000000014077faeULL, 0x0003e2000c101c46ULL,
0x00000d4000007947ULL, 0x000fea0003800000ULL, 0x000000100d197811ULL, 0x04afe400078fe8ffULL,
0x0000000c0d177811ULL, 0x040fe400078fe8ffULL, 0x000000040d137811ULL, 0x000fe200078fe8ffULL,
0x0000000119247824ULL, 0x100fe200078e020dULL, 0x0000001c0d1f7811ULL, 0x000fe200078fe8ffULL,
0x00000008191b7824ULL, 0x000fe200078e00ffULL, 0x000000200d277811ULL, 0x000fe200078fe8ffULL,
0x00000001171c7824ULL, 0x100fe200078e020dULL, 0x000000080d157811ULL, 0x000fe200078fe8ffULL,
0x0000000817117824ULL, 0x000fe200078e00ffULL, 0xfffffff81b247812ULL, 0x000fe200078ee224ULL,
0x0000000113237824ULL, 0x100fe200078e020dULL, 0x000000140d1b7811ULL, 0x000fe200078fe8ffULL,
0x0000000813107824ULL, 0x000fe200078e00ffULL, 0xfffffff8111c7812ULL, 0x000fe200078ee21cULL,
0x000000011f207824ULL, 0x100fe200078e020dULL, 0x000000180d1d7811ULL, 0x000fe200078fe8ffULL,
0x000000081f297824ULL, 0x000fe200078e00ffULL, 0x000000240d287811ULL, 0x000fe200078fe8ffULL,
0x00000001271e7824ULL, 0x040fe200078e020dULL, 0xfffffff810237812ULL, 0x000fe200078ee223ULL,
0x00000008272b7824ULL, 0x000fe200078e00ffULL, 0xfffffff829207812ULL, 0x000fe200078ee220ULL,
0x000000011b227824ULL, 0x100fe200078e020dULL, 0x000000280d297811ULL, 0x000fe200078fe8ffULL,
0x000000081b117824ULL, 0x000fe200078e00ffULL, 0xfffffff82b1e7812ULL, 0x000fe200078ee21eULL,
0x0000000115257824ULL, 0x100fe200078e020dULL, 0x0000002c0d2b7811ULL, 0x000fe200078fe8ffULL,
0x0000000815127824ULL, 0x000fe200078e00ffULL, 0xfffffff811227812ULL, 0x000fe200078ee222ULL,
0x000000011d217824ULL, 0x000fe200078e020dULL, 0x000000300d2d7811ULL, 0x000fe200078fe8ffULL,
0x000000081d107824ULL, 0x000fe200078e00ffULL, 0xfffffff812257812ULL, 0x000fe200078ee225ULL,
0x00000001281a7824ULL, 0x040fe200078e020dULL, 0x0000000c0d147211ULL, 0x000fe200078fe8ffULL,
0x0000000828117824ULL, 0x000fe200078e00ffULL, 0xfffffff810217812ULL, 0x000fe200078ee221ULL,
0x0000000129187824ULL, 0x100fe200078e020dULL, 0x0000001407357210ULL, 0x000fe20007f1e0ffULL,
0x00000008292f7824ULL, 0x000fe200078e00ffULL, 0xfffffff8111a7812ULL, 0x000fe200078ee21aULL,
0x000000012b127824ULL, 0x100fe200078e020dULL, 0x0000000d0d117211ULL, 0x000fe200078fe8ffULL,
0x000000082b317824ULL, 0x000fe200078e00ffULL, 0xfffffff82f187812ULL, 0x000fe200078ee218ULL,
0x000000012d107824ULL, 0x000fe200078e020dULL, 0x000000340d2f7811ULL, 0x000fe200078fe8ffULL,
0x000000082d337824ULL, 0x000fe200078e00ffULL, 0xfffffff831127812ULL, 0x000fe200078ee212ULL,
0x000000010c167824ULL, 0x040fe200078e0213ULL, 0x000000380d317811ULL, 0x000fe200078fe8ffULL,
0x000000010c367824ULL, 0x040fe200078e0228ULL, 0xfffffff833107812ULL, 0x000fe200078ee210ULL,
0x000000010c267824ULL, 0x000fe200078e0215ULL, 0x0000003c0d337811ULL, 0x000fe200078fe8ffULL,
0x0000000131137824ULL, 0x100fe200078e020dULL, 0x0000000711147812ULL, 0x000fe200078ec0ffULL,
0x000000012f117824ULL, 0x100fe200078e020dULL, 0x000010003d4f7811ULL, 0x000fe200078e70ffULL,
0x00000008334a7824ULL, 0x040fe200078e00ffULL, 0x0ffffff814287812ULL, 0x100fe200078ef80dULL,
0x00000001330d7824ULL, 0x000fc400078e020dULL, 0x000000010c2a7824ULL, 0x040fe400078e0217ULL,
0x000000010c2c7824ULL, 0x000fe200078e0219ULL, 0xfffffff84a477812ULL, 0x000fe200078ee20dULL,
0x000000010c2e7824ULL, 0x040fe200078e021bULL, 0x0000002a072a7210ULL, 0x040fe20007f5e0ffULL,
0x000000010c307824ULL, 0x040fe200078e021dULL, 0x0000002c072c7210ULL, 0x000fe20007f7e0ffULL,
0x000000010c327824ULL, 0x040fe400078e021fULL, 0x000000010c347824ULL, 0x000fc400078e0227ULL,
0x000000010c387824ULL, 0x040fe400078e0229ULL, 0x000000010c3a7824ULL, 0x040fe400078e022bULL,
0x000000010c3e7824ULL, 0x040fe400078e022dULL, 0x000000010c407824ULL, 0x040fe400078e022fULL,
0x000000082f427824ULL, 0x000fe400078e00ffULL, 0x000000010c447824ULL, 0x000fc400078e0231ULL,
0x0000000831487824ULL, 0x000fe200078e00ffULL, 0xfffffff842427812ULL, 0x000fe200078ee211ULL,
0x000000010c467824ULL, 0x000fe200078e0233ULL, 0x0000004407447210ULL, 0x000fe20007f9e0ffULL,
0x000000ffff147224ULL, 0x000fe200000e06ffULL, 0x00005e00350c7a11ULL, 0x040fe200078038ffULL,
0x000000ffff157224ULL, 0x000fe200010e06ffULL, 0xfffffff848457812ULL, 0x000fe200078ee213ULL,
0x000000ffff177224ULL, 0x000fe200018e06ffULL, 0x00005f00350d7a11ULL, 0x000fe200000f3c14ULL,
0x00000010252b7824ULL, 0x100fe200078e024fULL, 0x0000001607117210ULL, 0x000fe20007f1e0ffULL,
0x0000001023297824ULL, 0x100fe200078e024fULL, 0x0000002607137210ULL, 0x000fe20007f3e0ffULL,
0x0000001022317824ULL, 0x100fe200078e024fULL, 0x00005e002a147a11ULL, 0x000fe200078438ffULL,
0x000000ffff4a7224ULL, 0x000fe200000e06ffULL, 0x00005e002c167a11ULL, 0x000fe200078638ffULL,
0x000000ffff487224ULL, 0x000fe200008e06ffULL, 0x00005e00114d7a11ULL, 0x000fe200078038ffULL,
0x0000001021337824ULL, 0x100fe200078e024fULL, 0x00005e0013267a11ULL, 0x000fe200078238ffULL,
0x00000010242f7824ULL, 0x000fe200078e024fULL, 0x00005f002a157a11ULL, 0x000fe200010f3c15ULL,
0x000000101c2d7824ULL, 0x000fe200078e024fULL, 0x00005f002c177a11ULL, 0x000fe200018f3c17ULL,
0x0000001020357824ULL, 0x100fe200078e024fULL, 0x00005f0011117a11ULL, 0x000fe200000f3c4aULL,
0x000000101e377824ULL, 0x100fe200078e024fULL, 0x00005f0013137a11ULL, 0x000fe200008f3c48ULL,
0x000000101a397824ULL, 0x100fe200078e024fULL, 0x0000003207327210ULL, 0x040fe20007f5e0ffULL,
0x00000010183b7824ULL, 0x100fe200078e024fULL, 0x0000003407347210ULL, 0x040fe20007f7e0ffULL,
0x00000010123f7824ULL, 0x100fe200078e024fULL, 0x0000002e072e7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200010e06ffULL, 0x0000003007307210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200018e06ffULL, 0x00005e00324a7a11ULL, 0x000fe200078438ffULL,
0x000000ffff197224ULL, 0x000fe200000e06ffULL, 0x00005e0034277a11ULL, 0x000fe200078638ffULL,
0x000000ffff1b7224ULL, 0x000fe200008e06ffULL, 0x00005e002e4c7a11ULL, 0x000fe200078038ffULL,
0x0000001010417824ULL, 0x100fe200078e024fULL, 0x00005e00304b7a11ULL, 0x000fe200078238ffULL,
0x0000001042437824ULL, 0x000fe200078e024fULL, 0x00005f00321d7a11ULL, 0x000fe200010f3c1dULL,
0x0000001045457824ULL, 0x000fe200078e024fULL, 0x00005f00341f7a11ULL, 0x000fe200018f3c1fULL,
0x0000001047477824ULL, 0x000fe200078e024fULL, 0x00005f002e197a11ULL, 0x000fc400000f3c19ULL,
0x00005f00301b7a11ULL, 0x000fe400008f3c1bULL, 0x0000003607367210ULL, 0x040fe40007f7e0ffULL,
0x0000003807387210ULL, 0x040fe40007f5e0ffULL, 0x0000003a073a7210ULL, 0x040fe20007f1e0ffULL,
0x000000ffff497224ULL, 0x000fe200018e06ffULL, 0x0000003e073e7210ULL, 0x040fe20007f3e0ffULL,
0x000000ffff257224ULL, 0x000fe200010e06ffULL, 0x00005e0036487a11ULL, 0x000fe200078c38ffULL,
0x000000ffff237224ULL, 0x000fe200000e06ffULL, 0x0000004007407210ULL, 0x000fe20007f7e0ffULL,
0x000000ffff217224ULL, 0x000fe200008e06ffULL, 0x00005e0038227a11ULL, 0x000fc400078438ffULL,
0x00005e003a247a11ULL, 0x000fe400078038ffULL, 0x00005e003e327a11ULL, 0x000fe400078238ffULL,
0x0000004607467210ULL, 0x000fe20007fbe0ffULL, 0x0000001028077824ULL, 0x000fe200078e024fULL,
0x00005f0036497a11ULL, 0x000fe400030f3c49ULL, 0x00005f0038387a11ULL, 0x000fe200010f3c25ULL,
0x000000ffff257224ULL, 0x000fe200018e06ffULL, 0x00005f003a367a11ULL, 0x000fe200000f3c23ULL,
0x000000ffff237224ULL, 0x000fe200020e06ffULL, 0x00005f003e347a11ULL, 0x000fe200008f3c21ULL,
0x000000ffff217224ULL, 0x000fe200028e06ffULL, 0x00000070044f7812ULL, 0x000fc400078ec0ffULL,
0x00005e0040287a11ULL, 0x000fe400078238ffULL, 0x00005e00442a7a11ULL, 0x000fe400078438ffULL,
0x00005e00462c7a11ULL, 0x000fe400078638ffULL, 0x0000000c4f0c7210ULL, 0x040fe40007f1e0ffULL,
0x00005f0040307a11ULL, 0x000fe400008f3c25ULL, 0x00005f00442e7a11ULL, 0x000fe200010f3c23ULL,
0x000000ffff0d7224ULL, 0x000fe200000e060dULL, 0x0000004d4f107210ULL, 0x000fc40007f3e0ffULL,
0x00005f0046047a11ULL, 0x000fe400018f3c21ULL, 0x000000264f127210ULL, 0x040fe20007f5e0ffULL,
0x000000ffff117224ULL, 0x000fe200008e0611ULL, 0x000000144f147210ULL, 0x040fe20007f7e0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000c077faeULL, 0x0003e2000b901c46ULL,
0x000000164f167210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff137224ULL, 0x000fe200010e0613ULL,
0x0000004c4f187210ULL, 0x040fe20007f9e0ffULL, 0x000000ffff157224ULL, 0x000fe200018e0615ULL,
0x0000004b4f1a7210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff177224ULL, 0x000fe200028e0617ULL,
0x0000004a4f1c7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff197224ULL, 0x000fe200020e0619ULL,
0x000000274f1e7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff1b7224ULL, 0x000fe200000e061bULL,
0x000000484f207210ULL, 0x040fe20007f7e0ffULL, 0x0000000010297faeULL, 0x0005e2000b901c46ULL,
0x000000224f227210ULL, 0x040fe20007fbe0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e061dULL,
0x000000244f247210ULL, 0x040fe20007f9e0ffULL, 0x00000000122b7faeULL, 0x0007e2000b901c46ULL,
0x000000324f267210ULL, 0x040fe20007f1e0ffULL, 0x000000ffff1f7224ULL, 0x000fe200010e061fULL,
0x000000284f287210ULL, 0x040fe20007f3e0ffULL, 0x00000000142d7faeULL, 0x0003e2000b901c46ULL,
0x0000002a4f2a7210ULL, 0x040fe20007f5e0ffULL, 0x000000ffff217224ULL, 0x000fe200018e0649ULL,
0x0000002c4f2c7210ULL, 0x000fe20007f7e0ffULL, 0x00000000162f7faeULL, 0x0003e2000b901c46ULL,
0x000000ffff237224ULL, 0x000fc400028e0638ULL, 0x000000ffff257224ULL, 0x000fe200020e0636ULL,
0x0000000018317faeULL, 0x0003e2000b901c46ULL, 0x000000ffff277224ULL, 0x000fe400000e0634ULL,
0x000000ffff297224ULL, 0x004fe200008e0630ULL, 0x000000001a337faeULL, 0x0005e2000b901c46ULL,
0x000000ffff2b7224ULL, 0x008fe400010e062eULL, 0x000000ffff2d7224ULL, 0x002fe200018e0604ULL,
0x000000001c357faeULL, 0x0005e8000b901c46ULL, 0x000000001e377faeULL, 0x0005e8000b901c46ULL,
0x0000000020397faeULL, 0x0005e8000b901c46ULL, 0x00000000223b7faeULL, 0x0005e8000b901c46ULL,
0x00000000243f7faeULL, 0x0005e8000b901c46ULL, 0x0000000026417faeULL, 0x0005e8000b901c46ULL,
0x0000000028437faeULL, 0x0005e8000b901c46ULL, 0x000000002a457faeULL, 0x0005e8000b901c46ULL,
0x000000002c477faeULL, 0x0005e4000b901c46ULL, 0x0000000205057810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff077424ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000e0500720cULL, 0x000fda0003f06070ULL, 0x00000002060c8824ULL, 0x000fc800078e00ffULL,
0x000064000c0c8a24ULL, 0x000fc800078e0205ULL, 0x000060000c0c8625ULL, 0x000fca00078e000bULL,
0x000000060c078981ULL, 0x000324000c1e1900ULL, 0x00000000000c7805ULL, 0x002fc40000015200ULL,
0x01760400ff0b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff127224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000107805ULL, 0x000fcc0000015200ULL, 0x000000100c0b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000111107824ULL, 0x000fe200000e0e0dULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff1000720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff1000720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc80000011410ULL,
0x0000000b04047211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e0610ULL,
0x0000000204047819ULL, 0x000fc8000000120bULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e640000000000ULL, 0x000000203d047824ULL, 0x002fca00078e0204ULL,
0x00000003ff087819ULL, 0x000fc80000011604ULL, 0x1ffffffe08097812ULL, 0x000fe400078ec0ffULL,
0x0000000f04087812ULL, 0x000fc600078ec0ffULL, 0x0000000104097824ULL, 0x000fe400078e0209ULL,
0x00000010080b7824ULL, 0x040fe400078e00ffULL, 0x0000001008087824ULL, 0x000fe200078e00ffULL,
0x0000000f09047812ULL, 0x040fe400078ec0ffULL, 0x0000000109097810ULL, 0x000fe40007ffe0ffULL,
0x000000f00b047812ULL, 0x000fe400078ee204ULL, 0x0000000f09097812ULL, 0x000fc600078ec0ffULL,
0x0000000004147984ULL, 0x000e62000000cc00ULL, 0x000000f008097812ULL, 0x000fca00078ee209ULL,
0x0000000009107984ULL, 0x000ee2000000cc00ULL, 0x000000ffff187224ULL, 0x002fe400078e0014ULL,
0x000000ffff147224ULL, 0x000fe400078e0015ULL, 0x000000ffff197224ULL, 0x000fe400078e0016ULL,
0x000000ffff157224ULL, 0x000fe400078e0017ULL, 0x000000ffff1a7224ULL, 0x00cfe400078e0010ULL,
0x000000ffff1b7224ULL, 0x000fc400078e0012ULL, 0x000000ffff167224ULL, 0x000fe400078e0011ULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x0000001804007388ULL, 0x0003e8000000cc00ULL,
0x0000001409007388ULL, 0x0003e2000000cc00ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01760000ff107f8cULL, 0x000ea2000c80043fULL, 0x000000ffff127224ULL, 0x000fc600078e00ffULL,
0x0000000000087805ULL, 0x002fc80000015200ULL, 0x01760400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x006fc40007804811ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101200780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000c7805ULL, 0x000fcc0000015200ULL, 0x0000000c080b7210ULL, 0x000fca0007f1e1ffULL,
0x000000010d0c7824ULL, 0x000fe200000e0e09ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0c00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0c00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff047819ULL, 0x000fc8000001140cULL,
0x0000000b04047211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060cULL,
0x0000000204047819ULL, 0x000fc8000000120bULL, 0x000000040000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000112127810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01760400ff0b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000ff0f00720cULL, 0x000fda0003f05270ULL, 0x000000000000894dULL, 0x000fea0003800000ULL,
0x0000000000047919ULL, 0x000e620000000000ULL, 0x3db504f30a087820ULL, 0x010fe20000410000ULL,
0x000176883d097811ULL, 0x000fe200078e18ffULL, 0x0000640006067a24ULL, 0x000fe200078e02ffULL,
0xffffffff0f0a7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0c7224ULL, 0x000fe200078e00ffULL,
0x000176083d0b7811ULL, 0x000fe200078e28ffULL, 0x000000ffff107224ULL, 0x000fc400078e00ffULL,
0x000001000c0d7824ULL, 0x000fe200078e0203ULL, 0x0000000000007946ULL, 0x000fe80003800000ULL,
0x0000000d3c00720cULL, 0x000fda0003f04070ULL, 0x000000000000894dULL, 0x01cfea0003800000ULL,
0x000000020c127810ULL, 0x000fe20007ffe0ffULL, 0x0000000702077224ULL, 0x000fe200078e02ffULL,
0x000001000d157810ULL, 0x000fe40007ffe0ffULL, 0x0000000f1200720cULL, 0x000fe40003f06070ULL,
0x0000004015117812ULL, 0x000fe400078ec0ffULL, 0x00000001103e7812ULL, 0x000fc600078e0cffULL,
0x0000000100117824ULL, 0x000fcc00078e0211ULL, 0x00000ea000008947ULL, 0x000fea0003800000ULL,
0x00000003ff147819ULL, 0x102fe40000011604ULL, 0x000000153c137217ULL, 0x000fe40007800000ULL,
0x00000008141a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000114127824ULL, 0x040fe200078e0211ULL,
0x0000000414167810ULL, 0x040fe20007ffe0ffULL, 0x0000000113137824ULL, 0x000fe200078e0a15ULL,
0x0000000c141c7810ULL, 0x000fe20007ffe0ffULL, 0x000000011a197824ULL, 0x140fe200078e0204ULL,
0x0000001207187210ULL, 0x040fe20007f1e0ffULL, 0x000000081a2a7824ULL, 0x000fe200078e00ffULL,
0x000000131600720cULL, 0x0c0fe20003f86070ULL, 0x0000000116127824ULL, 0x000fe200078e0211ULL,
0x000000131a00720cULL, 0x000fe20003fa6070ULL, 0x0000000116177824ULL, 0x100fe200078e0204ULL,
0xfffffff82a2a7812ULL, 0x000fe200078ee219ULL, 0x0000000816227824ULL, 0x000fe200078e00ffULL,
0x0000001014247810ULL, 0x000fe20007ffe0ffULL, 0x000000011a167824ULL, 0x100fe200078e0211ULL,
0x00000012071a7210ULL, 0x040fe20007f3e0ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x00005e0018197a11ULL, 0x000fe200078038ffULL, 0x000000011c127824ULL, 0x040fe200078e0211ULL,
0x0000001607167210ULL, 0x040fe20007f5e0ffULL, 0x000000011c1d7824ULL, 0x100fe200078e0204ULL,
0x00005f0018187a11ULL, 0x000fe200000f3c15ULL, 0x000000ffff157224ULL, 0x000fe200008e06ffULL,
0x00005e001a217a11ULL, 0x000fe200078038ffULL, 0x000000ffff1f7224ULL, 0x000fe200010e06ffULL,
0x00005e00161b7a11ULL, 0x000fe200078238ffULL, 0x000000081c2c7824ULL, 0x000fe200078e00ffULL,
0x0000001414307810ULL, 0x000fe20007ffe0ffULL, 0x0000000124257824ULL, 0x000fe200078e0204ULL,
0x00005f001a1a7a11ULL, 0x000fe200000f3c15ULL, 0x00000008242e7824ULL, 0x040fe200078e00ffULL,
0x00000012071e7210ULL, 0x040fe20007f1e0ffULL, 0x0000000124127824ULL, 0x000fe200078e0211ULL,
0x00005f00161f7a11ULL, 0x000fe200008f3c1fULL, 0x0000000130167824ULL, 0x000fe200078e0211ULL,
0x0000001814327810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff157224ULL, 0x000fe200000e06ffULL,
0x0000001207207210ULL, 0x000fc40007f3e0ffULL, 0x00005e001e2f7a11ULL, 0x000fe200078038ffULL,
0x0000000132127824ULL, 0x000fe200078e0211ULL, 0x0000001607167210ULL, 0x040fe40007f5e0ffULL,
0x00005f001e1e7a11ULL, 0x000fe200000f3c15ULL, 0x000000ffff157224ULL, 0x000fe200008e06ffULL,
0x0000001207127210ULL, 0x000fe20007f7e0ffULL, 0x000000ffff297224ULL, 0x000fe200010e06ffULL,
0x00005e00202b7a11ULL, 0x000fe400078038ffULL, 0x00005e0016237a11ULL, 0x000fc400078238ffULL,
0xfffffff822227812ULL, 0x000fe200078ee217ULL, 0x000000ffff177224ULL, 0x000fe200018e06ffULL,
0x00005f0020207a11ULL, 0x000fe200000f3c15ULL, 0x000000023d157824ULL, 0x000fe200078e023eULL,
0x00005f0016297a11ULL, 0x000fe200008f3c29ULL, 0x0000001004167824ULL, 0x000fe200078e00ffULL,
0x00005e00122d7a11ULL, 0x000fe400078038ffULL, 0x0000001c14347810ULL, 0x000fe40007ffe0ffULL,
0x00005f0012287a11ULL, 0x000fe200000f3c17ULL, 0x0000000114177824ULL, 0x000fe200078e0204ULL,
0x0000007016127812ULL, 0x000fe200078ec0ffULL, 0x0000000134167824ULL, 0x000fe200078e0211ULL,
0x000000131c00720cULL, 0x000fc40003f66070ULL, 0x0000000717177812ULL, 0x000fe400078ec0ffULL,
0x0000001607267210ULL, 0x000fe40007fde0ffULL, 0x0000001219167210ULL, 0x000fe40007f3e0ffULL,
0x0000100015157811ULL, 0x000fe200078e68ffULL, 0x000000ffff197224ULL, 0x000fe200030e06ffULL,
0x000000131400720cULL, 0x040fe40003f06070ULL, 0x0ffffff8171c7812ULL, 0x000fe200078ef804ULL,
0x000000ffff177224ULL, 0x000fe200008e0618ULL, 0x0000002014367810ULL, 0x000fc40007ffe0ffULL,
0x00005e0026277a11ULL, 0x000fe400078238ffULL, 0xfffffff82c2c7812ULL, 0x000fe200078ee21dULL,
0x000000101c1d7824ULL, 0x000fe200078e0215ULL, 0x00005f0026267a11ULL, 0x000fe200008f3c19ULL,
0x00000001361c7824ULL, 0x000fe200078e0211ULL, 0x0000001221187210ULL, 0x000fe20007f3e0ffULL,
0x0000000130217824ULL, 0x040fe200078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000161d7faeULL, 0x0003e2000c101c46ULL, 0x000000133000720cULL, 0x040fe20003f06070ULL,
0x0000000830307824ULL, 0x000fe200078e00ffULL, 0x0000001c071c7210ULL, 0x000fe20007fde0ffULL,
0x000000ffff197224ULL, 0x000fe200008e061aULL, 0x000000121b1a7210ULL, 0x000fc40007f3e0ffULL,
0xfffffff82e2e7812ULL, 0x000fe400078ee225ULL, 0x000000132400720cULL, 0x080fe20003f46070ULL,
0x000000ffff1b7224ULL, 0x000fe200008e061fULL, 0x000000133200720cULL, 0x0c0fe20003f26070ULL,
0x0000000132167824ULL, 0x002fe200078e0204ULL, 0xfffffff830307812ULL, 0x000fe200078ee221ULL,
0x00000008321d7824ULL, 0x000fe200078e00ffULL, 0x0000002414387810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff177224ULL, 0x000fe200030e06ffULL, 0x00005e001c257a11ULL, 0x000fe200078c38ffULL,
0x00000010221f7824ULL, 0x100fe200078e0215ULL, 0xfffffff81d327812ULL, 0x000fe200078ee216ULL,
0x000000102a217824ULL, 0x000fe200078e0215ULL, 0x00005f001c247a11ULL, 0x000fe200030f3c17ULL,
0x0000000134227824ULL, 0x040fe200078e0204ULL, 0x000000122f167210ULL, 0x000fe20007fde0ffULL,
0x00000000181f7faeULL, 0x0003e2000e101c46ULL, 0x000000133400720cULL, 0x040fe20003f86070ULL,
0x00000008342f7824ULL, 0x000fc400078e00ffULL, 0x000000001a217faeULL, 0x0005e2000e901c46ULL,
0x000000ffff177224ULL, 0x000fe200030e061eULL, 0x000000122b1c7210ULL, 0x000fe20007fbe0ffULL,
0x00000001381e7824ULL, 0x000fe200078e0211ULL, 0xfffffff82f2a7812ULL, 0x000fc600078ee222ULL,
0x000000ffff1d7224ULL, 0x000fe200028e0620ULL, 0x0000001e071e7210ULL, 0x000fe20007fde0ffULL,
0x0000000136187824ULL, 0x142fe200078e0204ULL, 0x000000133600720cULL, 0x000fe20003fa6070ULL,
0x000000102e1f7824ULL, 0x100fe400078e0215ULL, 0x00000008361b7824ULL, 0x004fe200078e00ffULL,
0x0000002814367810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff197224ULL, 0x000fe200030e06ffULL,
0x00005e001e2b7a11ULL, 0x000fe200078c38ffULL, 0x00000001381a7824ULL, 0x000fe200078e0204ULL,
0xfffffff81b347812ULL, 0x000fe200078ee218ULL, 0x000000102c1b7824ULL, 0x000fe200078e0215ULL,
0x00005f001e227a11ULL, 0x000fe200030f3c19ULL, 0x0000000136187824ULL, 0x000fc400078e0211ULL,
0x0000000838217824ULL, 0x000fe200078e00ffULL, 0x00000000161b7faeULL, 0x0003e4000d901c46ULL,
0x0000001807207210ULL, 0x000fe40007fde0ffULL, 0x0000001223187210ULL, 0x000fe20007f7e0ffULL,
0x000000001c1f7faeULL, 0x0005e2000d101c46ULL, 0xfffffff8212c7812ULL, 0x000fe200078ee21aULL,
0x0000001030217824ULL, 0x000fe200078e0215ULL, 0x000000133800720cULL, 0x000fe20003f46070ULL,
0x000000ffff197224ULL, 0x000fc400018e0629ULL, 0x000000ffff237224ULL, 0x000fe200030e06ffULL,
0x00005e0020297a11ULL, 0x000fe400078c38ffULL, 0x000000122d167210ULL, 0x082fe20007f7e0ffULL,
0x0000000018217faeULL, 0x0003e2000c101c46ULL, 0x00000012271a7210ULL, 0x000fe20007f1e0ffULL,
0x0000001034277824ULL, 0x000fe200078e0215ULL, 0x00005f0020207a11ULL, 0x000fe200030f3c23ULL,
0x000000ffff177224ULL, 0x000fe200018e0628ULL, 0x0000003814287810ULL, 0x000fe20007ffe0ffULL,
0x0000001032237824ULL, 0x000fc400078e0215ULL, 0x000000ffff1b7224ULL, 0x000fe200000e0626ULL,
0x000000122b1e7210ULL, 0x080fe40007f1e0ffULL, 0x0000000016237faeULL, 0x0007e2000c901c46ULL,
0x00000012251c7210ULL, 0x084fe20007f3e0ffULL, 0x000000102a257824ULL, 0x100fe200078e0215ULL,
0x0000003414267810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff1f7224ULL, 0x000fe200000e0622ULL,
0x0000002c14227810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff1d7224ULL, 0x000fe200008e0624ULL,
0x0000003014247810ULL, 0x000fe20007ffe0ffULL, 0x000000102c197824ULL, 0x002fe200078e0215ULL,
0x0000003c142a7810ULL, 0x000fe20007ffe0ffULL, 0x0000000122147824ULL, 0x000fe200078e0211ULL,
0x000000001a257faeULL, 0x0003e2000e101c46ULL, 0x0000001229167210ULL, 0x008fe20007f1e0ffULL,
0x0000000136187824ULL, 0x040fe200078e0204ULL, 0x000000133600720cULL, 0x0c0fe20003f86070ULL,
0x000000001c277faeULL, 0x0005e2000e901c46ULL, 0x0000001407147210ULL, 0x000fe20007f3e0ffULL,
0x0000000836217824ULL, 0x000fe200078e00ffULL, 0x000000132200720cULL, 0x080fe20003fa6070ULL,
0x000000001e197faeULL, 0x0007e2000d101c46ULL, 0x000000ffff177224ULL, 0x000fe200000e0620ULL,
0x000000132400720cULL, 0x0c0fe20003f66070ULL, 0x0000000824207824ULL, 0x000fe200078e00ffULL,
0x000000132600720cULL, 0x080fe20003f46070ULL, 0x000000ffff1b7224ULL, 0x002fe200008e06ffULL,
0x000000132800720cULL, 0x000fc40003f26070ULL, 0x000000132a00720cULL, 0x000fe20003f06070ULL,
0x00000008221c7824ULL, 0x004fe200078e00ffULL, 0xfffffff8211a7812ULL, 0x000fe200078ee218ULL,
0x00000001241d7824ULL, 0x000fe200078e0204ULL, 0x00005e0014197a11ULL, 0x008fc800078c38ffULL,
0x00005f0014137a11ULL, 0x000fe200030f3c1bULL, 0x0000000124147824ULL, 0x000fe200078e0211ULL,
0x0000001219187210ULL, 0x000fe20007fde0ffULL, 0x00000001221b7824ULL, 0x100fe200078e0204ULL,
0xfffffff820207812ULL, 0x000fe200078ee21dULL, 0x0000000826227824ULL, 0x000fe400078e00ffULL,
0x000000ffff197224ULL, 0x000fe200030e0613ULL, 0x0000001407147210ULL, 0x000fe20007fde0ffULL,
0x000000101a137824ULL, 0x000fe200078e0215ULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee21bULL,
0x00000001261b7824ULL, 0x000fc400078e0204ULL, 0x000000ffff1d7224ULL, 0x000fe200030e06ffULL,
0x00005e00141f7a11ULL, 0x000fe200078c38ffULL, 0x0000000016137faeULL, 0x0003e2000e101c46ULL,
0xfffffff822227812ULL, 0x000fe200078ee21bULL, 0x000000101c1b7824ULL, 0x000fe200078e0215ULL,
0x00005f00141e7a11ULL, 0x000fe200030f3c1dULL, 0x0000000126147824ULL, 0x100fe400078e0211ULL,
0x00000001281a7824ULL, 0x100fe200078e0211ULL, 0x00000000181b7faeULL, 0x0005e2000e901c46ULL,
0x000000012a1c7824ULL, 0x000fe200078e0211ULL, 0x0000001407147210ULL, 0x040fe20007fbe0ffULL,
0x0000000128117824ULL, 0x100fe200078e0204ULL, 0x0000001a071a7210ULL, 0x040fe20007f9e0ffULL,
0x000000012a1d7824ULL, 0x000fe200078e0204ULL, 0x0000001c071c7210ULL, 0x000fe20007fde0ffULL,
0x0000000828287824ULL, 0x000fc400078e00ffULL, 0x000000082a2a7824ULL, 0x000fe400078e00ffULL,
0x000000ffff137224ULL, 0x002fe200028e06ffULL, 0x00005e0014217a11ULL, 0x000fe200078a38ffULL,
0x0000001020077824ULL, 0x000fe200078e0215ULL, 0xfffffff828167812ULL, 0x000fe200078ee211ULL,
0x0000001022117824ULL, 0x000fe200078e0215ULL, 0xfffffff82a187812ULL, 0x004fe200078ee21dULL,
0x000000ffff177224ULL, 0x000fe200030e06ffULL, 0x00005f0014207a11ULL, 0x000fe200028f3c13ULL,
0x00000010161b7824ULL, 0x100fe200078e0215ULL, 0x000000121f147210ULL, 0x080fe20007fbe0ffULL,
0x00000010181d7824ULL, 0x000fe200078e0215ULL, 0x00005e001c137a11ULL, 0x000fe200078c38ffULL,
0x000000ffff1f7224ULL, 0x000fe200020e06ffULL, 0x00005e001a197a11ULL, 0x000fe200078838ffULL,
0x000000ffff157224ULL, 0x000fe200028e061eULL, 0x0000001221167210ULL, 0x000fc40007fbe0ffULL,
0x00005f001a1e7a11ULL, 0x000fe400020f3c1fULL, 0x00005f001c1a7a11ULL, 0x000fe200030f3c17ULL,
0x000000ffff177224ULL, 0x000fe200028e0620ULL, 0x0000001219187210ULL, 0x080fe20007f9e0ffULL,
0x0000000014077faeULL, 0x0003e2000d901c46ULL, 0x0000001213127210ULL, 0x000fc60007fbe0ffULL,
0x000000ffff197224ULL, 0x000fe200020e061eULL, 0x0000000016117faeULL, 0x0003e2000d101c46ULL,
0x000000ffff137224ULL, 0x000fc600028e061aULL, 0x00000000181b7faeULL, 0x0003e8000c901c46ULL,
0x00000000121d7faeULL, 0x0003e2000c101c46ULL, 0x00000d6000007947ULL, 0x000fea0003800000ULL,
0x0000000404147811ULL, 0x042fe400078fe8ffULL, 0x0000000804167811ULL, 0x040fe400078fe8ffULL,
0x00000018041f7811ULL, 0x000fe200078fe8ffULL, 0x0000000114267824ULL, 0x100fe200078e0204ULL,
0x00000010041b7811ULL, 0x000fe200078fe8ffULL, 0x0000000814137824ULL, 0x000fe200078e00ffULL,
0x0000002004237811ULL, 0x000fe200078fe8ffULL, 0x00000001162b7824ULL, 0x000fe200078e0204ULL,
0x0000001c04217811ULL, 0x000fe200078fe8ffULL, 0x0000000816127824ULL, 0x000fe200078e00ffULL,
0xfffffff813267812ULL, 0x000fe200078ee226ULL, 0x000000011f307824ULL, 0x140fe200078e0204ULL,
0x0000000c04187811ULL, 0x000fe200078fe8ffULL, 0x000000081f137824ULL, 0x000fe200078e00ffULL,
0xfffffff8122b7812ULL, 0x000fe200078ee22bULL, 0x000000011b277824ULL, 0x040fe200078e0204ULL,
0x0000002404357811ULL, 0x040fe200078fe8ffULL, 0x000000081b127824ULL, 0x000fe200078e00ffULL,
0xfffffff813307812ULL, 0x000fe200078ee230ULL, 0x00000001232e7824ULL, 0x140fe200078e0204ULL,
0x0000002804367811ULL, 0x000fe200078fe8ffULL, 0x0000000823137824ULL, 0x000fe200078e00ffULL,
0xfffffff812277812ULL, 0x000fe200078ee227ULL, 0x00000001212f7824ULL, 0x040fe200078e0204ULL,
0x0000002c04377811ULL, 0x000fe200078fe8ffULL, 0x0000000821127824ULL, 0x000fe200078e00ffULL,
0xfffffff8132e7812ULL, 0x000fe200078ee22eULL, 0x00000001182d7824ULL, 0x100fe200078e0204ULL,
0x00000014041d7811ULL, 0x000fe200078fe8ffULL, 0x00000008181a7824ULL, 0x000fe200078e00ffULL,
0xfffffff8122f7812ULL, 0x000fe200078ee22fULL, 0x00000001352c7824ULL, 0x140fe200078e0204ULL,
0x0000003004387811ULL, 0x040fe200078fe8ffULL, 0x0000000835157824ULL, 0x000fe200078e00ffULL,
0x00000034043a7811ULL, 0x000fe200078fe8ffULL, 0x00000001362a7824ULL, 0x000fe200078e0204ULL,
0xfffffff81a2d7812ULL, 0x000fe200078ee22dULL, 0x0000000836137824ULL, 0x000fe200078e00ffULL,
0xfffffff8152c7812ULL, 0x000fe200078ee22cULL, 0x0000000137297824ULL, 0x040fe200078e0204ULL,
0x0000003804407811ULL, 0x040fe200078fe8ffULL, 0x0000000837127824ULL, 0x000fe200078e00ffULL,
0xfffffff8132a7812ULL, 0x000fe200078ee22aULL, 0x000000011d317824ULL, 0x140fe200078e0204ULL,
0x0000000404337211ULL, 0x000fe200078fe8ffULL, 0x000000081d1a7824ULL, 0x000fe200078e00ffULL,
0xfffffff812297812ULL, 0x000fe200078ee229ULL, 0x0000000138287824ULL, 0x100fe200078e0204ULL,
0x0000001104127211ULL, 0x000fe200078fe8ffULL, 0x0000000838157824ULL, 0x000fe200078e00ffULL,
0xfffffff81a317812ULL, 0x000fe200078ee231ULL, 0x000000013a247824ULL, 0x000fe200078e0204ULL,
0x0000003c04397811ULL, 0x000fe200078fe8ffULL, 0x000000083a137824ULL, 0x000fe200078e00ffULL,
0xfffffff815287812ULL, 0x000fe200078ee228ULL, 0x0000000114147824ULL, 0x100fe200078e0211ULL,
0x0000000733337812ULL, 0x000fe200078ec0ffULL, 0x0000000140257824ULL, 0x040fe200078e0204ULL,
0xfffffff813247812ULL, 0x000fe200078ee224ULL, 0x00000008401a7824ULL, 0x000fe200078e00ffULL,
0x0000001207137210ULL, 0x040fe20007f1e0ffULL, 0x0000000116167824ULL, 0x100fe200078e0211ULL,
0x0000001407157210ULL, 0x000fe20007f3e0ffULL, 0x0000000118187824ULL, 0x000fe200078e0211ULL,
0xfffffff81a257812ULL, 0x000fe200078ee225ULL, 0x000000ffff1c7224ULL, 0x000fe200000e06ffULL,
0x00005e0013127a11ULL, 0x000fe200078038ffULL, 0x000000ffff1a7224ULL, 0x000fe200008e06ffULL,
0x00005e0015147a11ULL, 0x000fe200078238ffULL, 0x0000000138387824ULL, 0x100fe200078e0211ULL,
0x00005f0013137a11ULL, 0x000fe200000f3c1cULL, 0x000000011d1c7824ULL, 0x100fe200078e0211ULL,
0x00005f0015157a11ULL, 0x000fe200008f3c1aULL, 0x000000011b1a7824ULL, 0x100fe200078e0211ULL,
0x0000001607177210ULL, 0x040fe20007f1e0ffULL, 0x000000013a3a7824ULL, 0x100fe200078e0211ULL,
0x0000001807197210ULL, 0x040fe20007f3e0ffULL, 0x0000000140407824ULL, 0x100fe200078e0211ULL,
0x0000001a071b7210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff207224ULL, 0x000fe200000e06ffULL,
0x00005e0017167a11ULL, 0x000fe200078038ffULL, 0x000000ffff1e7224ULL, 0x000fe200008e06ffULL,
0x00005e0019187a11ULL, 0x000fe200078238ffULL, 0x0000000139427824ULL, 0x100fe200078e0211ULL,
0x00005f0017177a11ULL, 0x000fe200000f3c20ULL, 0x000000ffff207224ULL, 0x000fe200010e06ffULL,
0x00005f0019197a11ULL, 0x000fe200008f3c1eULL, 0x000000011f1e7824ULL, 0x000fe200078e0211ULL,
0x0000001c071d7210ULL, 0x000fe20007f3e0ffULL, 0x0000000839467824ULL, 0x000fe200078e00ffULL,
0x00005e001b1a7a11ULL, 0x000fc400078038ffULL, 0x0ffffff833337812ULL, 0x000fe200078ef804ULL,
0x000000ffff227224ULL, 0x000fe200008e06ffULL, 0x00005f001b1b7a11ULL, 0x000fe200000f3c20ULL,
0x0000000121207824ULL, 0x100fe200078e0211ULL, 0x00005e001d1c7a11ULL, 0x000fe400078238ffULL,
0x0000001e071f7210ULL, 0x000fe40007f1e0ffULL, 0x00005f001d1d7a11ULL, 0x000fe200008f3c22ULL,
0x0000000123227824ULL, 0x000fe200078e0211ULL, 0x0000002007217210ULL, 0x000fe20007f3e0ffULL,
0x000000ffff327224ULL, 0x000fe200000e06ffULL, 0x00005e001f1e7a11ULL, 0x000fc400078038ffULL,
0x0000002207237210ULL, 0x000fe20007f5e0ffULL, 0x000000ffff347224ULL, 0x000fe200008e06ffULL,
0x00005e0021207a11ULL, 0x000fe400078238ffULL, 0x00005f001f1f7a11ULL, 0x000fe200000f3c32ULL,
0x000000ffff327224ULL, 0x000fe200010e06ffULL, 0x00005f0021217a11ULL, 0x000fe200008f3c34ULL,
0x000000023d347824ULL, 0x000fe200078e023eULL, 0x00005e0023227a11ULL, 0x000fe400078038ffULL,
0x0000003807387210ULL, 0x000fc40007f3e0ffULL, 0x00005f0023237a11ULL, 0x000fe200000f3c32ULL,
0x0000000135327824ULL, 0x100fe200078e0211ULL, 0x0000100034447811ULL, 0x000fe200078e68ffULL,
0x0000000136347824ULL, 0x100fe200078e0211ULL, 0x0000003a073a7210ULL, 0x000fe20007f5e0ffULL,
0x0000000137367824ULL, 0x000fe200078e0211ULL, 0x0000003207327210ULL, 0x000fe20007fde0ffULL,
0x0000000139117824ULL, 0x000fe200078e0204ULL, 0x0000003407347210ULL, 0x000fe20007fbe0ffULL,
0x0000001029417824ULL, 0x100fe200078e0244ULL, 0x0000003607367210ULL, 0x040fe20007f1e0ffULL,
0x0000001028437824ULL, 0x100fe200078e0244ULL, 0x0000004007407210ULL, 0x000fe20007f7e0ffULL,
0x0000001025477824ULL, 0x100fe200078e0244ULL, 0x0000004207427210ULL, 0x000fe20007f9e0ffULL,
0x0000001033077824ULL, 0x100fe200078e0244ULL, 0xfffffff846497812ULL, 0x000fe200078ee211ULL,
0x0000001027337824ULL, 0x000fc400078e0244ULL, 0x000000ffff277224ULL, 0x000fe200030e06ffULL,
0x00005e0032467a11ULL, 0x000fe200078c38ffULL, 0x0000001026117824ULL, 0x100fe400078e0244ULL,
0x000000ffff297224ULL, 0x000fe200000e06ffULL, 0x00005f0032487a11ULL, 0x000fe200030f3c27ULL,
0x000000ffff277224ULL, 0x000fe200028e06ffULL, 0x00005e0034267a11ULL, 0x000fe200078a38ffULL,
0x000000102a3f7824ULL, 0x100fe200078e0244ULL, 0x00005e0036287a11ULL, 0x000fe200078038ffULL,
0x0000001024457824ULL, 0x000fc400078e0244ULL, 0x000000ffff257224ULL, 0x000fe200008e06ffULL,
0x00005e00382a7a11ULL, 0x000fe200078238ffULL, 0x0000001004247824ULL, 0x000fe200078e00ffULL,
0x00005f0036297a11ULL, 0x000fe200000f3c29ULL, 0x000000102b2b7824ULL, 0x100fe200078e0244ULL,
0x00005f0038367a11ULL, 0x000fe200008f3c25ULL, 0x000000102d2d7824ULL, 0x100fe200078e0244ULL,
0x00000070244b7812ULL, 0x000fe200078ec0ffULL, 0x0000001031317824ULL, 0x100fe400078e0244ULL,
0x0000001030357824ULL, 0x100fe200078e0244ULL, 0x0000004b12127210ULL, 0x000fe20007f1e0ffULL,
0x000000102f377824ULL, 0x000fc400078e0244ULL, 0x000000102e397824ULL, 0x100fe400078e0244ULL,
0x000000102c3b7824ULL, 0x100fe200078e0244ULL, 0x00005e003a2c7a11ULL, 0x000fe200078238ffULL,
0x0000001049497824ULL, 0x000fe200078e0244ULL, 0x00005f0034447a11ULL, 0x000fe200028f3c27ULL,
0x000000ffff277224ULL, 0x000fe200010e06ffULL, 0x00005e00402e7a11ULL, 0x000fe200078438ffULL,
0x000000ffff2f7224ULL, 0x000fe200018e06ffULL, 0x00005e0042307a11ULL, 0x000fe200078638ffULL,
0x000000ffff257224ULL, 0x000fe200020e06ffULL, 0x00005f003a347a11ULL, 0x000fe200008f3c27ULL,
0x000000ffff137224ULL, 0x000fe200000e0613ULL, 0x00005f00402f7a11ULL, 0x000fc400010f3c2fULL,
0x0000004b14147210ULL, 0x080fe40007f3e0ffULL, 0x00005f0042327a11ULL, 0x000fe200018f3c25ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000012077faeULL, 0x0003e2000b901c46ULL,
0x0000004b16167210ULL, 0x080fe20007f5e0ffULL, 0x000000ffff157224ULL, 0x000fe200008e0615ULL,
0x0000004b18187210ULL, 0x080fe40007f7e0ffULL, 0x0000004b1a1a7210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff177224ULL, 0x000fe200010e0617ULL, 0x0000004b1c1c7210ULL, 0x080fe20007f9e0ffULL,
0x000000ffff197224ULL, 0x000fe200018e0619ULL, 0x0000004b1e1e7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff1b7224ULL, 0x000fe200028e061bULL, 0x0000004b20207210ULL, 0x080fe20007f3e0ffULL,
0x000000ffff1d7224ULL, 0x000fe200020e061dULL, 0x0000004b22227210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff1f7224ULL, 0x000fe200000e061fULL, 0x0000004b46247210ULL, 0x080fe20007f7e0ffULL,
0x0000000014117faeULL, 0x0003e2000b901c46ULL, 0x0000004b26267210ULL, 0x080fe20007fbe0ffULL,
0x000000ffff217224ULL, 0x000fe200008e0621ULL, 0x0000004b28287210ULL, 0x080fe20007f9e0ffULL,
0x00000000162b7faeULL, 0x0005e2000b901c46ULL, 0x0000004b2a2a7210ULL, 0x080fe20007f1e0ffULL,
0x000000ffff237224ULL, 0x000fe200010e0623ULL, 0x0000004b2c2c7210ULL, 0x080fe20007f3e0ffULL,
0x00000000182d7faeULL, 0x0007e2000b901c46ULL, 0x0000004b2e2e7210ULL, 0x080fe20007f5e0ffULL,
0x000000ffff257224ULL, 0x000fe200018e0648ULL, 0x0000004b30307210ULL, 0x000fe20007f7e0ffULL,
0x000000001a337faeULL, 0x0003e2000b901c46ULL, 0x000000ffff277224ULL, 0x000fc400028e0644ULL,
0x000000ffff297224ULL, 0x000fe200020e0629ULL, 0x000000001c317faeULL, 0x0009e2000b901c46ULL,
0x000000ffff2b7224ULL, 0x004fe400000e0636ULL, 0x000000ffff2f7224ULL, 0x000fe200010e062fULL,
0x000000001e357faeULL, 0x0003e2000b901c46ULL, 0x000000ffff2d7224ULL, 0x008fc600008e0634ULL,
0x0000000020377faeULL, 0x0003e8000b901c46ULL, 0x0000000022397faeULL, 0x0003e2000b901c46ULL,
0x000000ffff317224ULL, 0x010fc600018e0632ULL, 0x00000000243b7faeULL, 0x0003e8000b901c46ULL,
0x00000000263f7faeULL, 0x0003e8000b901c46ULL, 0x0000000028417faeULL, 0x0003e8000b901c46ULL,
0x000000002a437faeULL, 0x0003e8000b901c46ULL, 0x000000002c457faeULL, 0x0003e8000b901c46ULL,
0x000000002e477faeULL, 0x0003e8000b901c46ULL, 0x0000000030497faeULL, 0x0003e4000b901c46ULL,
0x0000000205057810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff077424ULL, 0x002fe200078e00ffULL,
0x00000000000079afULL, 0x000e240000000000ULL, 0x0000000e0500720cULL, 0x000fda0003f06070ULL,
0x0000000206128824ULL, 0x000fe400078e0205ULL, 0x00000004ff138424ULL, 0x000fc800078e00ffULL,
0x0000600012128625ULL, 0x000fe200078e0013ULL, 0x00000020043f7810ULL, 0x040fe40007ffe0ffULL,
0x0000000704117812ULL, 0x040fe200078ec0ffULL, 0x000000023d417824ULL, 0x000fe200078e0210ULL,
0x0000000612078981ULL, 0x000322000c1e1900ULL, 0xfffffff804437812ULL, 0x000fe200078ec0ffULL,
0x000000ffff447224ULL, 0x000fe200078e00ffULL, 0xfffffff83f3f7812ULL, 0x000fe200078ec0ffULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000004ff407819ULL, 0x000fe20000011604ULL,
0x0000000000147805ULL, 0x000fe2000001ff00ULL, 0x0000000000227805ULL, 0x000fe2000001ff00ULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x0000000000267805ULL, 0x000fe2000001ff00ULL,
0x0000000000247805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x0000100041417811ULL, 0x000fe400078e68ffULL, 0x0000000811427812ULL, 0x100fe400078ef804ULL,
0x0000000743437812ULL, 0x100fe400078ef804ULL, 0x000000073f3f7812ULL, 0x002fc600078ef804ULL,
0x0000000143107824ULL, 0x060fe200078e0244ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000843117824ULL, 0x000fe400078e00ffULL, 0x0000000244777824ULL, 0x000fc600078e0240ULL,
0xfffffff811107812ULL, 0x000fe200078ee210ULL, 0x000000083f117824ULL, 0x000fc800078e00ffULL,
0x0000001010187824ULL, 0x000fe400078e0241ULL, 0x000000013f107824ULL, 0x000fc800078e0244ULL,
0x000000001818783bULL, 0x000e620000000200ULL, 0xfffffff811107812ULL, 0x000fca00078ee210ULL,
0x0000001010107824ULL, 0x000fcc00078e0241ULL, 0x000000001010783bULL, 0x000ea20000000200ULL,
0x00000018ff737819ULL, 0x002fe20000011418ULL, 0x00010000181c7824ULL, 0x040fe200078e00ffULL,
0x0000888018757816ULL, 0x040fe200000000ffULL, 0x0000010018187824ULL, 0x000fe200078e00ffULL,
0x00000018ff5b7819ULL, 0x000fe20000011419ULL, 0x00010000191d7824ULL, 0x040fe200078e00ffULL,
0x0000888019717816ULL, 0x040fe200000000ffULL, 0x0000010019197824ULL, 0x000fe200078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000007300737306ULL, 0x000fe20000200c00ULL,
0x00000018ff6d7819ULL, 0x000fc4000001141aULL, 0x000088801a6f7816ULL, 0x000fe400000000ffULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000001800787306ULL, 0x0003e20000200c00ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000018ff557819ULL, 0x004fe40000011410ULL, 0x0000888010547816ULL, 0x000fc400000000ffULL,
0x00000018ff617819ULL, 0x000fe20000011411ULL, 0x0000001900647306ULL, 0x0005e20000200c00ULL,
0x000100001a187824ULL, 0x042fe200078e00ffULL, 0x0000888011677816ULL, 0x000fe200000000ffULL,
0x000001001a1a7824ULL, 0x000fe200078e00ffULL, 0x00000018ff667819ULL, 0x000fe4000001141bULL,
0x00000018ff187819ULL, 0x000fe40000011418ULL, 0x00000018ff1a7819ULL, 0x000fe2000001141aULL,
0x000100001b197824ULL, 0x044fe200078e00ffULL, 0x0000001c007a7306ULL, 0x0003e20000200c00ULL,
0x000088801b5f7816ULL, 0x040fe200000000ffULL, 0x000001001b1b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fc40000011412ULL, 0x00000018ff197819ULL, 0x000fe40000011419ULL,
0x00000018ff457819ULL, 0x000fe20000011413ULL, 0x0000001a00727306ULL, 0x0005e20000200c00ULL,
0x00000008431c7824ULL, 0x002fe200078e00ffULL, 0x0000888012657816ULL, 0x000fe400000000ffULL,
0x00008880135d7816ULL, 0x000fe400000000ffULL, 0x00000018ff1b7819ULL, 0x000fe4000001141bULL,
0x0000001900707306ULL, 0x0003e20000200c00ULL, 0x00000001441a7810ULL, 0x004fc40007ffe0ffULL,
0x0000000244447810ULL, 0x000fc80007ffe0ffULL, 0x000000084400780cULL, 0x000fe20003f05270ULL,
0x0000001d00767306ULL, 0x0005e20000200c00ULL, 0x0000000143197824ULL, 0x102fe400078e021aULL,
0x000000013f1a7824ULL, 0x000fc600078e021aULL, 0xfffffff81c1c7812ULL, 0x000fe200078ee219ULL,
0x0001000011197824ULL, 0x040fe200078e00ffULL, 0x0000001800747306ULL, 0x0003e20000200c00ULL,
0x0000010011117824ULL, 0x000fe400078e00ffULL, 0x000000101c1c7824ULL, 0x000fe200078e0241ULL,
0x00000018ff197819ULL, 0x000fe40000011419ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x0000001b006b7306ULL, 0x0007e20000200c00ULL, 0x000000001c1c783bULL, 0x004ea20000000200ULL,
0x0001000010187824ULL, 0x002fc400078e00ffULL, 0x0000010010107824ULL, 0x000fc600078e00ffULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x00000011006a7306ULL, 0x0003e20000200c00ULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x000000083f1b7824ULL, 0x008fca00078e00ffULL,
0xfffffff81b1a7812ULL, 0x000fe200078ee21aULL, 0x00000010006e7306ULL, 0x0007e20000200c00ULL,
0x0001000013117824ULL, 0x042fe400078e00ffULL, 0x0000010013137824ULL, 0x000fe400078e00ffULL,
0x000000101a1a7824ULL, 0x000fe200078e0241ULL, 0x00000018ff117819ULL, 0x000fe40000011411ULL,
0x00000018ff137819ULL, 0x000fe20000011413ULL, 0x0001000012107824ULL, 0x048fe200078e00ffULL,
0x0000001100627306ULL, 0x0003e20000200c00ULL, 0x0000010012127824ULL, 0x000fc600078e00ffULL,
0x00000018ff107819ULL, 0x000fe40000011410ULL, 0x00000018ff127819ULL, 0x000fe40000011412ULL,
0x0000001000687306ULL, 0x0007e20000200c00ULL, 0x0000001042117824ULL, 0x002fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x004fcc000001141cULL, 0x0000001200637306ULL, 0x000fe20000200c00ULL,
0x000100001c107824ULL, 0x048fe200078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001141dULL,
0x000088801c477816ULL, 0x040fe200000000ffULL, 0x000001001c1c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fe20000011410ULL, 0x0000000142107824ULL, 0x000fe200078e0277ULL,
0x0000001300607306ULL, 0x0003e20000200c00ULL, 0x000088801d517816ULL, 0x000fe400000000ffULL,
0x00000018ff1c7819ULL, 0x000fc4000001141cULL, 0xfffffff011107812ULL, 0x000fe200078ee210ULL,
0x000100001d117824ULL, 0x040fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001141eULL,
0x0000001800697306ULL, 0x000fe20000200c00ULL, 0x000001001d1d7824ULL, 0x000fe200078e00ffULL,
0x000088801e537816ULL, 0x000fe200000000ffULL, 0x0000001010107824ULL, 0x000fe200078e00ffULL,
0x00000018ff527819ULL, 0x000fe40000011411ULL, 0x00000018ff1d7819ULL, 0x000fe4000001141dULL,
0x00000019006c7306ULL, 0x0005e20000200c00ULL, 0x000000001010783bULL, 0x002fe20000000200ULL,
0x0000000242777810ULL, 0x000fc40007ffe077ULL, 0x00000018ff4b7819ULL, 0x000fe4000001141fULL,
0x000088801f577816ULL, 0x000fe400000000ffULL, 0x0000007500757306ULL, 0x000e620000200c00ULL,
0x000000001a18783bULL, 0x004eae0000000200ULL, 0x0000001c004f7306ULL, 0x0007f00000200c00ULL,
0x0000001d00567306ULL, 0x0003e20000200c00ULL, 0x000100001e1c7824ULL, 0x008fc400078e00ffULL,
0x000001001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe4000001141cULL,
0x0000005b005b7306ULL, 0x000fe20000200c00ULL, 0x000100001f1d7824ULL, 0x042fe200078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe2000001141eULL, 0x000001001f1f7824ULL, 0x000fc600078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000007100717306ULL, 0x000e620000200c00ULL,
0x00000018ff1f7819ULL, 0x000fce000001141fULL, 0x0000001c00587306ULL, 0x0007e20000200c00ULL,
0x00000018ff4a7819ULL, 0x004fe40000011418ULL, 0x00000018ff497819ULL, 0x000fe40000011419ULL,
0x00000018ff487819ULL, 0x000fe4000001141aULL, 0x00000018ff467819ULL, 0x000fe2000001141bULL,
0x0000001d005e7306ULL, 0x0005e20000200c00ULL, 0x00005410751c7816ULL, 0x008fce000000007aULL,
0x0000006d006d7306ULL, 0x000fe20000200c00ULL, 0x00005410781d7816ULL, 0x004fce0000000073ULL,
0x0000006f006f7306ULL, 0x000ea20000200c00ULL, 0x0000001c1038723cULL, 0x000b6e0000001838ULL,
0x0000006600667306ULL, 0x000fe20000200c00ULL, 0x00005410711c7816ULL, 0x022fe20000000076ULL,
0x0000001042767824ULL, 0x000fe200078e00ffULL, 0x00005410641d7816ULL, 0x000fe2000000005bULL,
0x0001000018647824ULL, 0x000fc600078e00ffULL, 0xfffffff076777812ULL, 0x000fe200078ee277ULL,
0x0000005f005f7306ULL, 0x000e620000200c00ULL, 0x00000018ff647819ULL, 0x000fe20000011464ULL,
0x0000001c1034723cULL, 0x000b6c0000001834ULL, 0x0000005500557306ULL, 0x000ee20000200c00ULL,
0x000054106f1c7816ULL, 0x024fc40000000074ULL, 0x00005410721d7816ULL, 0x000fe4000000006dULL,
0x00008880196d7816ULL, 0x000fc600000000ffULL, 0x0000005400547306ULL, 0x000ea40000200c00ULL,
0x0000001c1030723cULL, 0x000b6c0000001830ULL, 0x0000001e00597306ULL, 0x0005e20000200c00ULL,
0x000054105f1c7816ULL, 0x022fe40000000070ULL, 0x000054106b1d7816ULL, 0x000fe20000000066ULL,
0x00010000196b7824ULL, 0x000fe200078e00ffULL, 0x000054106e557816ULL, 0x008fe20000000055ULL,
0x000000ffff667224ULL, 0x000fc400078e006dULL, 0x0000006100617306ULL, 0x000e620000200c00ULL,
0x00008880181e7816ULL, 0x044fe200000000ffULL, 0x0000010018187824ULL, 0x000fe200078e00ffULL,
0x0000001c102c723cULL, 0x000fe2000000182cULL, 0x0000541054547816ULL, 0x000fc60000000069ULL,
0x00000018ff187819ULL, 0x000fe20000011418ULL, 0x0000006700677306ULL, 0x000ea60000200c00ULL,
0x000000541028723cULL, 0x000bea0000001828ULL, 0x0000001e005b7306ULL, 0x0007e40000200c00ULL,
0x0000010019547824ULL, 0x020fe200078e00ffULL, 0x000054106a197816ULL, 0x002fc40000000061ULL,
0x000088801a617816ULL, 0x000fe400000000ffULL, 0x00000018ff557819ULL, 0x000fe2000001146bULL,
0x0000001f005c7306ULL, 0x0003e20000200c00ULL, 0x00000010771e7824ULL, 0x008fe200078e00ffULL,
0x00000018ff547819ULL, 0x000fcc0000011454ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x000000001e1c783bULL, 0x002e6e0000000200ULL, 0x0000006500657306ULL, 0x000ef00000200c00ULL,
0x00000018005f7306ULL, 0x0005f00000200c00ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x0000541067187816ULL, 0x004fce000000006cULL, 0x0000005d005d7306ULL, 0x000ea20000200c00ULL,
0x000000181024723cULL, 0x000b6e0000001824ULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x0000541065187816ULL, 0x028fe40000000068ULL, 0x0000541063197816ULL, 0x000fe2000000005aULL,
0x000000ffff5a7224ULL, 0x000fc400078e0061ULL, 0x000100001a617824ULL, 0x040fe400078e00ffULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x000001001a1a7824ULL, 0x000fe200078e00ffULL,
0x000000181020723cULL, 0x000b6c0000001820ULL, 0x0000005000507306ULL, 0x000ee20000200c00ULL,
0x000054105d187816ULL, 0x024fc40000000062ULL, 0x0000541060197816ULL, 0x000fca0000000045ULL,
0x0000004d004d7306ULL, 0x000ea40000200c00ULL, 0x000000181014723cULL, 0x000b6c0000001814ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x0000541047107816ULL, 0x028fe20000000050ULL,
0x000001001b187824ULL, 0x000fe200078e00ffULL, 0x000054104f117816ULL, 0x000fc4000000004eULL,
0x000088801b127816ULL, 0x000fe400000000ffULL, 0x00000018ff137819ULL, 0x000fe20000011461ULL,
0x0000005200527306ULL, 0x000ee20000200c00ULL, 0x00000018ff197819ULL, 0x000fe2000001141aULL,
0x000000101c38723cULL, 0x002b620000001838ULL, 0x00000018ff187819ULL, 0x000fca0000011418ULL,
0x0000005700577306ULL, 0x000fe20000200c00ULL, 0x0000541056117816ULL, 0x024fe4000000004dULL,
0x0000541051107816ULL, 0x008fca0000000052ULL, 0x0000005a005a7306ULL, 0x000fe40000200c00ULL,
0x000000101c34723cULL, 0x000b6c0000001834ULL, 0x0000001300137306ULL, 0x000fe20000200c00ULL,
0x000100001b117824ULL, 0x020fe400078e00ffULL, 0x000000ffff107224ULL, 0x000fca00078e0012ULL,
0x0000004c004c7306ULL, 0x000e620000200c00ULL, 0x00000018ff117819ULL, 0x000fce0000011411ULL,
0x0000004b004b7306ULL, 0x000ff00000200c00ULL, 0x0000004a004a7306ULL, 0x000ea20000200c00ULL,
0x0000541059597816ULL, 0x002fce000000004cULL, 0x0000004900497306ULL, 0x000ff00000200c00ULL,
0x0000004800487306ULL, 0x000fe20000200c00ULL, 0x000054105f5f7816ULL, 0x004fce000000004aULL,
0x0000004600467306ULL, 0x000ff00000200c00ULL, 0x0000005300537306ULL, 0x000e700000200c00ULL,
0x0000006400647306ULL, 0x000ff00000200c00ULL, 0x0000006600667306ULL, 0x000fe20000200c00ULL,
0x0000541053587816ULL, 0x002fce0000000058ULL, 0x0000005500557306ULL, 0x000e620000200c00ULL,
0x000000581c30723cULL, 0x000b6e0000001830ULL, 0x0000005400547306ULL, 0x000eb00000200c00ULL,
0x0000001900197306ULL, 0x000ee20000200c00ULL, 0x0000541066667816ULL, 0x002fce0000000055ULL,
0x0000001000127306ULL, 0x0003e20000200c00ULL, 0x0000541054677816ULL, 0x004fce0000000049ULL,
0x00000011001b7306ULL, 0x0004a20000200c00ULL, 0x0000541057107816ULL, 0x002fe2000000005eULL,
0x000000661c24723cULL, 0x000b620000001824ULL, 0x000054105b5e7816ULL, 0x000fe40000000064ULL,
0x0000541019197816ULL, 0x008fc60000000048ULL, 0x0000001800457306ULL, 0x0002e20000200c00ULL,
0x000054105c117816ULL, 0x004fe2000000004bULL, 0x0000005e1c28723cULL, 0x000b620000001828ULL,
0x0000541012127816ULL, 0x000fe4000000001bULL, 0x000054105a187816ULL, 0x002fca0000000013ULL,
0x000000101c2c723cULL, 0x000b62000000182cULL, 0x0000541045137816ULL, 0x008fce0000000046ULL,
0x000000181c20723cULL, 0x040b700000001820ULL, 0x000000121c14723cULL, 0x000b620000001814ULL,
0xfffff09000000947ULL, 0x000fce000383ffffULL, 0x0000000834347220ULL, 0x080fe40000410000ULL,
0x0000000835357220ULL, 0x000fc40000410000ULL, 0x0000000838387220ULL, 0x080fe40000410000ULL,
0x0000000839397220ULL, 0x080fe40000410000ULL, 0x0000000830107220ULL, 0x0a0fe40000410000ULL,
0x0000000831117220ULL, 0x080fe40000410000ULL, 0x000000082d127220ULL, 0x080fe40000410000ULL,
0x0000000828287220ULL, 0x000fc40000410000ULL, 0x0000000826187220ULL, 0x080fe40000410000ULL,
0x0000000827197220ULL, 0x080fe40000410000ULL, 0x00000008331c7220ULL, 0x080fe40000410000ULL,
0x000000082f1e7220ULL, 0x080fe40000410000ULL, 0x000000082a1f7220ULL, 0x080fe40000410000ULL,
0x000000082b1a7220ULL, 0x000fc40000410000ULL, 0x0000000820277220ULL, 0x080fe40000410000ULL,
0x0000000821267220ULL, 0x080fe40000410000ULL, 0x00000008321b7220ULL, 0x080fe40000410000ULL,
0x000000082c337220ULL, 0x080fe40000410000ULL, 0x000000082e1d7220ULL, 0x080fe40000410000ULL,
0x00000008242b7220ULL, 0x000fc40000410000ULL, 0x00000008252a7220ULL, 0x080fe40000410000ULL,
0x0000000822207220ULL, 0x080fe40000410000ULL, 0x0000000823217220ULL, 0x080fe40000410000ULL,
0x000000ffff2f7224ULL, 0x000fe400078e0034ULL, 0x000000ffff307224ULL, 0x000fe400078e0035ULL,
0x000000083a3a7220ULL, 0x000fc40000410000ULL, 0x000000083b3b7220ULL, 0x080fe40000410000ULL,
0x0000000836367220ULL, 0x080fe40000410000ULL, 0x0000000837377220ULL, 0x080fe40000410000ULL,
0x00000008292c7220ULL, 0x080fe40000410000ULL, 0x0000000814257220ULL, 0x080fe40000410000ULL,
0x0000000815247220ULL, 0x000fc40000410000ULL, 0x0000000816227220ULL, 0x080fe40000410000ULL,
0x0000000817237220ULL, 0x000fe40000410000ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0038ULL,
0x000000ffff2e7224ULL, 0x000fe400078e0039ULL, 0x000000ffff317224ULL, 0x000fe400078e0010ULL,
0x000000ffff327224ULL, 0x000fc400078e0011ULL, 0x000000ffff347224ULL, 0x000fe400078e0012ULL,
0x000000ffff357224ULL, 0x000fe200078e0028ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000009107f8cULL, 0x0002a2000c80043fULL, 0x000000ffff147224ULL, 0x000fe400078e003aULL,
0x000000ffff157224ULL, 0x000fe400078e003bULL, 0x000000ffff167224ULL, 0x000fe400078e0036ULL,
0x000000ffff177224ULL, 0x000fc400078e0037ULL, 0x0000000000127805ULL, 0x000fca0000015200ULL,
0x0000040009297984ULL, 0x000ee40000000800ULL, 0x8000000029ff7812ULL, 0x00cfc40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000287805ULL, 0x000fcc0000015200ULL, 0x0000002812377210ULL, 0x000fca0007f1e1ffULL,
0x0000000129297824ULL, 0x000fe200000e0e13ULL, 0x003d09003700780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403700780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff287819ULL, 0x000fc80000011429ULL,
0x0000003728287211ULL, 0x000fca00078110ffULL, 0x000000ffff297224ULL, 0x000fca00000e0629ULL,
0x0000000228287819ULL, 0x000fc80000001229ULL, 0x000000280000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040009297984ULL, 0x000ea40000000800ULL,
0x8000000029ff7812ULL, 0x004fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000404297824ULL, 0x000fe200078e00ffULL, 0x0000000a0c00720cULL, 0x000fc80003f05270ULL,
0xfffffff029287812ULL, 0x000fca00078ec0ffULL, 0x000000803d287824ULL, 0x000fca00078e0228ULL,
0x0174000028107984ULL, 0x0004e20000000c00ULL, 0x0000042000000947ULL, 0x000fea0003800000ULL,
0x0000000204367824ULL, 0x000fe400078e00ffULL, 0x000000013c0d7824ULL, 0x000fc600078e0a0dULL,
0x0000000636367812ULL, 0x000fc800078ec0ffULL, 0x0000000136387812ULL, 0x040fe400078efcffULL,
0x00000008363a7812ULL, 0x000fe400078efcffULL, 0x0000000d3800720cULL, 0x080fe40003f26070ULL,
0x0000001036387812ULL, 0x000fe400078efcffULL, 0x0000000d3a00720cULL, 0x080fe40003f06070ULL,
0x0000000d3800720cULL, 0x000fc40003fc6070ULL, 0x00000011363a7812ULL, 0x040fe400078efcffULL,
0x0000001836387812ULL, 0x040fe400078efcffULL, 0x0000000d3600720cULL, 0x080fe40003f46070ULL,
0x0000000d3a00720cULL, 0x080fe40003fa6070ULL, 0x0000000d3800720cULL, 0x000fe40003f66070ULL,
0x0000000936407812ULL, 0x000fc400078efcffULL, 0x00000019363a7812ULL, 0x040fe400078efcffULL,
0x0000002036387812ULL, 0x000fe400078efcffULL, 0xff80000014147808ULL, 0x000fe40005000000ULL,
0xff8000002d2d7808ULL, 0x000fe40005000000ULL, 0xff80000015157808ULL, 0x000fe40004800000ULL,
0xff8000002e2e7808ULL, 0x000fc40004800000ULL, 0x0000000d4000720cULL, 0x080fe40003f86070ULL,
0x0000000d3a00720cULL, 0x080fe40003f46070ULL, 0x0000000d3800720cULL, 0x000fe40003f26070ULL,
0x00000021363a7812ULL, 0x040fe400078efcffULL, 0x0000002836387812ULL, 0x000fe400078efcffULL,
0xff80000016167808ULL, 0x000fc40004000000ULL, 0xff8000002f2f7808ULL, 0x000fe40004000000ULL,
0xff80000017177808ULL, 0x000fe40006000000ULL, 0xff80000030307808ULL, 0x000fe40006000000ULL,
0x0000000d3a00720cULL, 0x080fe40003f06070ULL, 0x0000000d3800720cULL, 0x000fe40003f86070ULL,
0x00000029363a7812ULL, 0x000fc400078efcffULL, 0x0000003036387812ULL, 0x000fe400078efcffULL,
0xff8000001b1b7808ULL, 0x000fe40007000000ULL, 0xff80000031317808ULL, 0x000fe40007000000ULL,
0xff8000001c1c7808ULL, 0x000fe40006800000ULL, 0xff80000032327808ULL, 0x000fe40006800000ULL,
0x0000000d3a00720cULL, 0x000fc40003fc6070ULL, 0x0000000d3800720cULL, 0x000fe40003fa6070ULL,
0x00000031363a7812ULL, 0x040fe400078efcffULL, 0x0000003836387812ULL, 0x040fe400078efcffULL,
0x0000003936367812ULL, 0x000fe400078efcffULL, 0xff8000001d1d7808ULL, 0x000fe40005800000ULL,
0xff80000033337808ULL, 0x000fc40005800000ULL, 0xff8000001e1e7808ULL, 0x000fe40005000000ULL,
0xff80000034347808ULL, 0x000fe40005000000ULL, 0xff8000001f1f7808ULL, 0x000fe40004800000ULL,
0xff80000035357808ULL, 0x000fe40004800000ULL, 0x0000000d3a00720cULL, 0x080fe40003f66070ULL,
0x0000000d3800720cULL, 0x000fc40003f46070ULL, 0x0000000d3600720cULL, 0x000fe40003f26070ULL,
0xff8000001a1a7808ULL, 0x000fe40004000000ULL, 0xff8000002c2c7808ULL, 0x000fe40004000000ULL,
0xff80000018187808ULL, 0x000fe40006000000ULL, 0xff8000002b2b7808ULL, 0x000fe40006000000ULL,
0xff80000019197808ULL, 0x000fc40007000000ULL, 0xff8000002a2a7808ULL, 0x000fe40007000000ULL,
0xff80000020207808ULL, 0x000fe40006800000ULL, 0xff80000027277808ULL, 0x000fe40006800000ULL,
0xff80000021217808ULL, 0x000fe40005800000ULL, 0xff80000026267808ULL, 0x000fe40005800000ULL,
0xff80000022227808ULL, 0x000fc40005000000ULL, 0xff80000025257808ULL, 0x000fe40005000000ULL,
0xff80000023237808ULL, 0x000fe40004800000ULL, 0xff80000024247808ULL, 0x000fc40004800000ULL,
0x0000002d1000720bULL, 0x008fe40003f1e000ULL, 0x000000141100720bULL, 0x000fe40003f3e000ULL,
0x000000102d0d7208ULL, 0x000fe40004000000ULL, 0x0000001114107208ULL, 0x000fc40004800000ULL,
0x0000002e0d00720bULL, 0x000fe40003f1e000ULL, 0x000000151000720bULL, 0x000fe40003f3e000ULL,
0x0000000d2e367208ULL, 0x000fe40004000000ULL, 0x00000010150d7208ULL, 0x000fe40004800000ULL,
0x0000002f3600720bULL, 0x000fe40003f1e000ULL, 0x000000160d00720bULL, 0x000fc40003f3e000ULL,
0x000000362f117208ULL, 0x000fe40004000000ULL, 0x0000000d16107208ULL, 0x000fe40004800000ULL,
0x000000301100720bULL, 0x000fe40003f1e000ULL, 0x000000171000720bULL, 0x000fe40003f3e000ULL,
0x0000001130367208ULL, 0x000fe40004000000ULL, 0x0000001017107208ULL, 0x000fc40004800000ULL,
0x000000313600720bULL, 0x000fe40003f1e000ULL, 0x0000001b1000720bULL, 0x000fe40003f3e000ULL,
0x00000036310d7208ULL, 0x000fe40004000000ULL, 0x000000101b117208ULL, 0x000fe40004800000ULL,
0x000000320d00720bULL, 0x000fe40003f1e000ULL, 0x0000001c1100720bULL, 0x000fc40003f3e000ULL,
0x0000000d32107208ULL, 0x000fe40004000000ULL, 0x000000111c367208ULL, 0x000fe40004800000ULL,
0x000000331000720bULL, 0x000fe40003f1e000ULL, 0x0000001d3600720bULL, 0x000fe40003f3e000ULL,
0x00000010330d7208ULL, 0x000fe40004000000ULL, 0x000000361d117208ULL, 0x000fc40004800000ULL,
0x000000340d00720bULL, 0x000fe40003f1e000ULL, 0x0000001e1100720bULL, 0x000fe40003f3e000ULL,
0x0000000d34107208ULL, 0x000fe40004000000ULL, 0x000000111e367208ULL, 0x000fe40004800000ULL,
0x000000351000720bULL, 0x000fe40003f1e000ULL, 0x0000001f3600720bULL, 0x000fc40003f3e000ULL,
0x00000010350d7208ULL, 0x000fe40004000000ULL, 0x000000361f117208ULL, 0x000fe40004800000ULL,
0x0000002c0d00720bULL, 0x000fe40003f1e000ULL, 0x0000001a1100720bULL, 0x000fe40003f3e000ULL,
0x0000000d2c107208ULL, 0x000fe40004000000ULL, 0x000000111a117208ULL, 0x000fc40004800000ULL,
0x0000002b1000720bULL, 0x000fe40003f1e000ULL, 0x000000181100720bULL, 0x000fe40003f3e000ULL,
0x000000102b0d7208ULL, 0x000fe40004000000ULL, 0x0000001118107208ULL, 0x000fe40004800000ULL,
0x0000002a0d00720bULL, 0x000fe40003f1e000ULL, 0x000000191000720bULL, 0x000fc40003f3e000ULL,
0x0000000d2a367208ULL, 0x000fe40004000000ULL, 0x00000010190d7208ULL, 0x000fe40004800000ULL,
0x000000273600720bULL, 0x000fe40003f1e000ULL, 0x000000200d00720bULL, 0x000fe40003f3e000ULL,
0x0000003627117208ULL, 0x000fe40004000000ULL, 0x0000000d20107208ULL, 0x000fc40004800000ULL,
0x000000261100720bULL, 0x000fe40003f1e000ULL, 0x000000211000720bULL, 0x000fe40003f3e000ULL,
0x0000001126367208ULL, 0x000fe40004000000ULL, 0x00000010210d7208ULL, 0x000fe40004800000ULL,
0x000000253600720bULL, 0x000fe40003f1e000ULL, 0x000000220d00720bULL, 0x000fc40003f3e000ULL,
0x0000003625117208ULL, 0x000fe40004000000ULL, 0x0000000d22107208ULL, 0x000fe40004800000ULL,
0x000000241100720bULL, 0x000fe40003f1e000ULL, 0x000000231000720bULL, 0x000fe40003f3e000ULL,
0x0000001124397208ULL, 0x000fe40004000000ULL, 0x00000010233b7208ULL, 0x000fe20004800000ULL,
0x000017827f007947ULL, 0x000fec000b800000ULL, 0x0c401f00390d7f89ULL, 0x00066400000e0000ULL,
0x0000000d3900720bULL, 0x002fc80003f1e000ULL, 0x000000390d3f7208ULL, 0x000fe20004000000ULL,
0x000017b27f007947ULL, 0x000fea000b800000ULL, 0x0c401f003b0d7f89ULL, 0x000e6800000e0000ULL,
0x0c401f0012117f89ULL, 0x000ea800000e0000ULL, 0x0c401f0013107f89ULL, 0x000ee200000e0000ULL,
0x0000000d3b00720bULL, 0x002fc40003f1e000ULL, 0x000000111200720bULL, 0x004fe40003f3e000ULL,
0x0000003b0d377208ULL, 0x000fe40004000000ULL, 0x0000001211387208ULL, 0x000fe40004800000ULL,
0x0c201f003f117f89ULL, 0x000e6200000e0000ULL, 0x000000101300720bULL, 0x008fc60003f1e000ULL,
0x0c201f00373a7f89ULL, 0x000ea200000e0000ULL, 0x00000013100d7208ULL, 0x000fc60004000000ULL,
0x0c201f0038397f89ULL, 0x000ee800000e0000ULL, 0x0c201f000d367f89ULL, 0x0002e400000e0000ULL,
0x000000113f00720bULL, 0x002fe40003f1e000ULL, 0x0000003a3700720bULL, 0x004fe40003f3e000ULL,
0x0000003f11107208ULL, 0x000fc40004000000ULL, 0x000000393800720bULL, 0x008fe40003f5e000ULL,
0x000000373a117208ULL, 0x000fe40004800000ULL, 0x0000003839127208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b10377820ULL, 0x000fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000304ff7812ULL, 0x000fe4000780c0ffULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010837ULL,
0x000000360d00720bULL, 0x000fe20003f3e000ULL, 0x3fb8aa3b2e2e7823ULL, 0x000fc40000010837ULL,
0x00000030003b7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b2f2f7823ULL, 0x100fe40000010837ULL,
0x3fb8aa3b2d2d7823ULL, 0x100fe40000010837ULL, 0x3fb8aa3b27137823ULL, 0x100fe40000010837ULL,
0x3fb8aa3b31317823ULL, 0x100fe20000010837ULL, 0x0000002e00397308ULL, 0x0023e20000000800ULL,
0x3fb8aa3b24307823ULL, 0x004fe40000010837ULL, 0x3fb8aa3b11247820ULL, 0x000fc40000410000ULL,
0x3fb8aa3b32327823ULL, 0x100fe40000010837ULL, 0x3fb8aa3b14147823ULL, 0x100fe20000010824ULL,
0x0000002f003a7308ULL, 0x0005e20000000800ULL, 0x3fb8aa3b15157823ULL, 0x100fe40000010824ULL,
0x3fb8aa3b16167823ULL, 0x100fe40000010824ULL, 0x3fb8aa3b17177823ULL, 0x000fe40000010824ULL,
0x3fb8aa3b2c2e7823ULL, 0x102fe20000010837ULL, 0x0000001400277308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b2b2c7823ULL, 0x000fc40000010837ULL, 0x3fb8aa3b2a2f7823ULL, 0x104fe40000010837ULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe40000010824ULL, 0x3fb8aa3b33337823ULL, 0x100fe20000010837ULL,
0x00000015002a7308ULL, 0x000e620000000800ULL, 0x3fb8aa3b34347823ULL, 0x000fe40000010837ULL,
0x3fb8aa3b1c1c7823ULL, 0x100fe40000010824ULL, 0x3fb8aa3b1d1d7823ULL, 0x000fc40000010824ULL,
0x3fb8aa3b1e1e7823ULL, 0x000fe20000010824ULL, 0x00000016002b7308ULL, 0x0005e20000000800ULL,
0x3fb8aa3b26267823ULL, 0x100fe40000010837ULL, 0x3fb8aa3b25257823ULL, 0x000fca0000010837ULL,
0x0000001700407308ULL, 0x000ee20000000800ULL, 0x000000272a15723eULL, 0x002fe200000000ffULL,
0x3c003c00ff2a7424ULL, 0x000fe200078e00ffULL, 0x0000003a3b16723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b193a7823ULL, 0x100fe40000010824ULL, 0x3fb8aa3b1a277823ULL, 0x000fe40000010824ULL,
0x0000002d00387308ULL, 0x0002a20000000800ULL, 0x0000002b4017723eULL, 0x008fe200000000ffULL,
0x3c003c00ff2b7424ULL, 0x000fcc00078e00ffULL, 0x0000001c00427308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b352d7823ULL, 0x002fe20000010837ULL, 0x00000002ff407819ULL, 0x000fe20000011604ULL,
0x3fb8aa3b1f377823ULL, 0x100fe20000010824ULL, 0x000000383914723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b18397823ULL, 0x000fc60000010824ULL, 0x0000001d00357308ULL, 0x000fe20000000800ULL,
0x00000008403f7824ULL, 0x040fe200078e00ffULL, 0x00000002403b7810ULL, 0x000fcc0007ffe0ffULL,
0x0000001e00447308ULL, 0x0003f00000000800ULL, 0x0000001b001b7308ULL, 0x000ea20000000800ULL,
0x0000002a141c723cULL, 0x002f6e00000018ffULL, 0x0000003100317308ULL, 0x000ff00000000800ULL,
0x0000003200327308ULL, 0x000e620000000800ULL, 0x0000001b4219723eULL, 0x004fe200000000ffULL,
0x0000000840427824ULL, 0x000fe200078e00ffULL, 0x00000035441b723eULL, 0x000fe200000000ffULL,
0x0000000840357824ULL, 0x000fc600078e00ffULL, 0xfffffff8423b7812ULL, 0x000fe200078ee23bULL,
0x0000003300337308ULL, 0x000ff00000000800ULL, 0x0000003400347308ULL, 0x000ea20000000800ULL,
0x000000313218723eULL, 0x002fe200000000ffULL, 0x3fb8aa3b21317823ULL, 0x000fcc0000010824ULL,
0x0000002700387308ULL, 0x0003e20000000800ULL, 0x00000033341a723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b20277823ULL, 0x002fcc0000010824ULL, 0x0000002d002d7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b22337823ULL, 0x100fe20000010824ULL, 0x0000000140347810ULL, 0x040fe20007ffe0ffULL,
0x3fb8aa3b23247823ULL, 0x000fe40000010824ULL, 0x0000002a1820723cULL, 0x020b62000000181cULL,
0xfffffff835357812ULL, 0x000fe400078ee234ULL, 0x0000002e002e7308ULL, 0x000e620000000800ULL,
0xffffffff40347810ULL, 0x000fc60007ffe0ffULL, 0x00000008401e7824ULL, 0x060fe200078e00ffULL,
0x00000003401c7810ULL, 0x040fe40007ffe0ffULL, 0x00000004401d7810ULL, 0x000fe20007ffe0ffULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0xfffffff83f3f7812ULL, 0x000fe400078ee21cULL,
0xfffffff81e417812ULL, 0x000fca00078ee21dULL, 0x0000002f002f7308ULL, 0x000ea20000000800ULL,
0x0000002d2e1c723eULL, 0x002fe200000000ffULL, 0x00000008402d7824ULL, 0x040fe200078e00ffULL,
0x00000005402e7810ULL, 0x000fc80007ffe0ffULL, 0xfffffff82d2d7812ULL, 0x000fe200078ee240ULL,
0x0000003700377308ULL, 0x000e700000000800ULL, 0x0000003900397308ULL, 0x000fe20000000800ULL,
0x0000002c2f1e723eULL, 0x004fe200000000ffULL, 0x00000008402f7824ULL, 0x000fca00078e00ffULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee22eULL, 0x0000003a003a7308ULL, 0x000ea20000000800ULL,
0x00000037381d723eULL, 0x002fe200000000ffULL, 0x0000000840387824ULL, 0x040fe200078e00ffULL,
0x000110003d2e7811ULL, 0x000fe200078e58ffULL, 0x0000000840377824ULL, 0x000fc800078e00ffULL,
0x0000001300137308ULL, 0x000fe20000000800ULL, 0x000000102d2d7824ULL, 0x000fe200078e022eULL,
0xfffffff837377812ULL, 0x000fe200078ee234ULL, 0x0000001035357824ULL, 0x100fe400078e022eULL,
0x000000103b3b7824ULL, 0x100fe400078e022eULL, 0x000000103f3f7824ULL, 0x100fe200078e022eULL,
0x000000393a1f723eULL, 0x004fe200000000ffULL, 0x0000002600267308ULL, 0x000e620000000800ULL,
0x0000000840397810ULL, 0x000fe20007ffe0ffULL, 0x0000001041417824ULL, 0x000fc400078e022eULL,
0x000000102f2f7824ULL, 0x100fe400078e022eULL, 0x0000002a1c20723cULL, 0x000f620000001820ULL,
0x00000008393a7824ULL, 0x000fe200078e00ffULL, 0x0000002500257308ULL, 0x000fe20000000800ULL,
0x0000001037377824ULL, 0x000fc600078e022eULL, 0xfffffff83a397812ULL, 0x000fc800078ee239ULL,
0x0000003000307308ULL, 0x000ea20000000800ULL, 0x0000001039397824ULL, 0x000fce00078e022eULL,
0x0000002700277308ULL, 0x000ff00000000800ULL, 0x0000003100327308ULL, 0x0006700000000800ULL,
0x0000003300337308ULL, 0x000fe20000000800ULL, 0x0000000640317810ULL, 0x008fc80007ffe0ffULL,
0xfffffff838317812ULL, 0x000fc600078ee231ULL, 0x00000024002c7308ULL, 0x0002e40000000800ULL,
0x0000001031317824ULL, 0x000fe200078e022eULL, 0x000000132624723eULL, 0x002fe400000000ffULL,
0x000000253026723eULL, 0x004fe400000000ffULL, 0x000000273225723eULL, 0x000fe400000000ffULL,
0x0000000d36137208ULL, 0x000fe40004800000ULL, 0x000000332c27723eULL, 0x008fc400000000ffULL,
0x0000000c292c7812ULL, 0x000fca00078ec0ffULL, 0x0000002a2420723cULL, 0x020f620000001820ULL,
0x000000012d2d7824ULL, 0x000fe400078e022cULL, 0x000000012c357824ULL, 0x040fe400078e0235ULL,
0x000000012c3b7824ULL, 0x040fe200078e023bULL, 0x000000142d007388ULL, 0x0003e20000000800ULL,
0x000000012c3f7824ULL, 0x040fe400078e023fULL, 0x000000012c417824ULL, 0x040fe200078e0241ULL,
0x0000001635007388ULL, 0x0003e20000000800ULL, 0x000000012c2f7824ULL, 0x000fc400078e022fULL,
0x000000012c317824ULL, 0x040fe200078e0231ULL, 0x000000183b007388ULL, 0x0003e20000000800ULL,
0x000000012c377824ULL, 0x040fe400078e0237ULL, 0x000000012c2c7824ULL, 0x000fe200078e0239ULL,
0x0000001a3f007388ULL, 0x0003e80000000800ULL, 0x0000001c41007388ULL, 0x0003e40000000800ULL,
0x000000ffff217224ULL, 0x020fc400078e0022ULL, 0x0000001e2f007388ULL, 0x0003e80000000800ULL,
0x0000002431007388ULL, 0x0003e80000000800ULL, 0x0000002637007388ULL, 0x0003e80000000800ULL,
0x000000152c007388ULL, 0x0003e80000000800ULL, 0x0004001735007388ULL, 0x0003e80000000800ULL,
0x000400193b007388ULL, 0x0003e80000000800ULL, 0x0004001b3f007388ULL, 0x0003e80000000800ULL,
0x0004001d41007388ULL, 0x0003e80000000800ULL, 0x0004001f2f007388ULL, 0x0003e80000000800ULL,
0x0004002531007388ULL, 0x0003e80000000800ULL, 0x0004002737007388ULL, 0x0003e80000000800ULL,
0x0170001028008388ULL, 0x0003e80000000c00ULL, 0x0172002028008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000bff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000008000bff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000010000bff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000010c0c7810ULL, 0x000fe20007ffe0ffULL,
0x000018000bff7f8cULL, 0x0003e4000c80043fULL, 0x000000ffff107224ULL, 0x002fe200078e003eULL,
0x0000000f0c00720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffb69000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff107807ULL, 0x008fe20004000000ULL, 0xffffffffff177424ULL, 0x000fe200078e00ffULL,
0x00012fc0001d7802ULL, 0x000fc40000000f00ULL, 0x0000101000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff107224ULL, 0x000fe200078e0017ULL, 0xfffef32000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe20004000000ULL, 0xffffffffff177424ULL, 0x000fe200078e00ffULL,
0x00013020001d7802ULL, 0x000fc40000000f00ULL, 0x00000fb000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff137224ULL, 0x000fe200078e0017ULL, 0xfffef36000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x008fe200078e0015ULL, 0x00013090001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x00000ef000007944ULL, 0x012fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xfffef40000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0015ULL,
0x00013100001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x00000e8000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xfffef50000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0013ULL, 0x00013180001d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fe400078e0014ULL, 0x0000001fff1c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x00000e0000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0017ULL, 0xfffef8f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff107224ULL, 0x000fe200078e0000ULL, 0x00013200001d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff177224ULL, 0x000fc400078e0013ULL, 0x0000001fff1c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x00000d8000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e0017ULL, 0xfffef8a000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x004fe20004000000ULL, 0xffffffffff177424ULL, 0x000fe200078e00ffULL,
0x00013260001d7802ULL, 0x000fc40000000f00ULL, 0x00000d7000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0017ULL, 0xffff1b0000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe20004000000ULL, 0xffffffffff177424ULL, 0x000fe200078e00ffULL,
0x000132c0001d7802ULL, 0x000fc40000000f00ULL, 0x00000d1000007944ULL, 0x008fea0003c00000ULL,
0x000000ffff167224ULL, 0x000fe200078e0017ULL, 0xffff1b4000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0014ULL, 0x00013330001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x00000c5000007944ULL, 0x008fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff1c0000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0014ULL,
0x000133a0001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x00000be000007944ULL, 0x00afea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff1cf000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00013420001d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fe400078e0013ULL, 0x0000001fff1c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x00000b6000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0017ULL, 0xffff20e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00013490001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x00000af000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0017ULL,
0xffff20a000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x004fe20004000000ULL,
0xffffffffff177424ULL, 0x000fe200078e00ffULL, 0x000134f0001d7802ULL, 0x000fc40000000f00ULL,
0x00000ae000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff137224ULL, 0x000fe200078e0017ULL,
0xffff402000007947ULL, 0x000fea000383ffffULL, 0x00000001ff107807ULL, 0x000fe20004000000ULL,
0xffffffffff177424ULL, 0x000fe200078e00ffULL, 0x00013550001d7802ULL, 0x000fc40000000f00ULL,
0x00000a8000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff167224ULL, 0x000fe200078e0017ULL,
0xffff406000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e001eULL,
0x000135c0001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x000009c000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff412000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e001eULL, 0x00013630001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x0000095000007944ULL, 0x01afea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff421000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x000136b0001d7802ULL, 0x000fe20000000f00ULL, 0x000000ffff107224ULL, 0x000fe400078e0013ULL,
0x0000001fff1c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x000008d000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff027224ULL, 0x004fe200078e0017ULL,
0xffff460000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x00013720001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0000086000007944ULL, 0x01efea0003c00000ULL,
0x000000ffff007224ULL, 0x004fe200078e0017ULL, 0xffff45c000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x008fe20004000000ULL, 0xffffffffff177424ULL, 0x000fe200078e00ffULL,
0x00013780001d7802ULL, 0x000fc40000000f00ULL, 0x0000085000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff157224ULL, 0x000fe200078e0017ULL, 0xffff655000007947ULL, 0x000fea000383ffffULL,
0x00000001ff107807ULL, 0x000fe20004000000ULL, 0xffffffffff177424ULL, 0x000fe200078e00ffULL,
0x000137e0001d7802ULL, 0x000fc40000000f00ULL, 0x000007f000007944ULL, 0x004fea0003c00000ULL,
0x000000ffff167224ULL, 0x000fe200078e0017ULL, 0xffff659000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00013850001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fc400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x0000073000007944ULL, 0x004fea0003c00000ULL, 0x000000ffff107224ULL, 0x004fe200078e0017ULL,
0xffff664000007947ULL, 0x000fea000383ffffULL, 0x000000ffff177224ULL, 0x000fe200078e0012ULL,
0x000138c0001d7802ULL, 0x000fe20000000f00ULL, 0x0000001fff1c7424ULL, 0x000fe400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x000006c000007944ULL, 0x006fea0003c00000ULL,
0x000000ffff107224ULL, 0x004fe200078e0017ULL, 0xffff673000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x00013940001d7802ULL, 0x000fe20000000f00ULL,
0x000000ffff107224ULL, 0x000fe400078e0013ULL, 0x0000001fff1c7424ULL, 0x000fc400078e00ffULL,
0xffffffffff1f7424ULL, 0x000fc400078e00ffULL, 0x0000064000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff027224ULL, 0x004fe200078e0017ULL, 0xffff6b1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff177224ULL, 0x000fe200078e0012ULL, 0x000139b0001d7802ULL, 0x000fe20000000f00ULL,
0x0000001fff1c7424ULL, 0x000fe400078e00ffULL, 0xffffffffff1f7424ULL, 0x000fc400078e00ffULL,
0x000005d000007944ULL, 0x006fea0003c00000ULL, 0x000000ffff007224ULL, 0x004fe200078e0017ULL,
0xffff6ad000007947ULL, 0x000fea000383ffffULL, 0x00000002ff3a7424ULL, 0x000fe200078e00ffULL,
0x00013a2000367802ULL, 0x000fe20000000f00ULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000052000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff0d7224ULL, 0x004fe200078e0038ULL, 0xffffe82000007947ULL, 0x000fea000383ffffULL,
0x000000ffff397224ULL, 0x008fe200078e003bULL, 0x00013aa000367802ULL, 0x000fe20000000f00ULL,
0x00000002ff3a7424ULL, 0x000fc400078e00ffULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000004a000007944ULL, 0x014fea0003c00000ULL,
0x000000383b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff397224ULL, 0x002fe200078e0012ULL,
0x00013b2000367802ULL, 0x000fe20000000f00ULL, 0x00000002ff3a7424ULL, 0x000fe200078e00ffULL,
0x0000003b38117208ULL, 0x000fe20004000000ULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000042000007944ULL, 0x000fea0003c00000ULL,
0x000000381200720bULL, 0x004fe20003f1e000ULL, 0x000000ffff397224ULL, 0x002fe200078e0013ULL,
0x00013ba000367802ULL, 0x000fe20000000f00ULL, 0x00000002ff3a7424ULL, 0x000fe200078e00ffULL,
0x00000012383b7208ULL, 0x000fe20004000000ULL, 0x0000001fff387424ULL, 0x000fc400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000003a000007944ULL, 0x000fea0003c00000ULL,
0x000000381300720bULL, 0x004fe20003f1e000ULL, 0x000000ffff397224ULL, 0x002fe200078e003fULL,
0x00013c2000367802ULL, 0x000fe20000000f00ULL, 0x00000001ff3a7424ULL, 0x000fe200078e00ffULL,
0x00000013380d7208ULL, 0x000fe20004000000ULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000032000007944ULL, 0x000fea0003c00000ULL,
0x000000383f00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff397224ULL, 0x002fe200078e0011ULL,
0x00013ca000367802ULL, 0x000fe20000000f00ULL, 0x00000001ff3a7424ULL, 0x000fe200078e00ffULL,
0x0000003f38107208ULL, 0x000fe20004000000ULL, 0x0000001fff387424ULL, 0x000fc400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000002a000007944ULL, 0x000fea0003c00000ULL,
0x000000381100720bULL, 0x004fe20003f1e000ULL, 0x000000ffff397224ULL, 0x002fe200078e003bULL,
0x00013d2000367802ULL, 0x000fe20000000f00ULL, 0x00000001ff3a7424ULL, 0x000fe200078e00ffULL,
0x0000001138117208ULL, 0x000fe20004000000ULL, 0x0000001fff387424ULL, 0x000fe400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x0000022000007944ULL, 0x000fea0003c00000ULL,
0x000000383b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff397224ULL, 0x002fe200078e000dULL,
0x00013da000367802ULL, 0x000fe20000000f00ULL, 0x00000001ff3a7424ULL, 0x000fe200078e00ffULL,
0x0000003b38127208ULL, 0x000fe20004000000ULL, 0x0000001fff387424ULL, 0x000fc400078e00ffULL,
0xffffffffff417424ULL, 0x000fc400078e00ffULL, 0x000001a000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff367224ULL, 0x004fe200078e0038ULL, 0xffffe60000007947ULL, 0x000fea000383ffffULL,
0x0180000007007810ULL, 0x000fe20007ffe0ffULL, 0x0000013000017945ULL, 0x000fe60003800000ULL,
0x7f80000000027812ULL, 0x000fc800078ec0ffULL, 0x018000000200780cULL, 0x000fda0003f05070ULL,
0x0000000700008308ULL, 0x0002a20000001000ULL, 0x000000e000008947ULL, 0x000fea0003800000ULL,
0x000000ff0200720cULL, 0x040fe40003f25070ULL, 0x008000000200780cULL, 0x000fe40003f02070ULL,
0x00000001ff037807ULL, 0x000fe40000800000ULL, 0x00000001ff007807ULL, 0x004fc80004000000ULL,
0x0000000003ff7212ULL, 0x000fda000780fcffULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x007fffff07ff7812ULL, 0x040fe4000780c0ffULL, 0x8000000007027812ULL, 0x000fe400078ec0ffULL,
0x00000001ff007807ULL, 0x000fc80000000000ULL, 0x0000000003ff7212ULL, 0x000fda000780c0ffULL,
0x0080000002000812ULL, 0x000fe200078efcffULL, 0x000000ffff008224ULL, 0x000fe200078e0002ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000700007308ULL, 0x0004e40000001000ULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff027224ULL, 0x000fe400078e0004ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffec0c002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff377424ULL, 0x000fe200078e00ffULL, 0x0000004100007348ULL, 0x000fe80003800000ULL,
0x0c00003a39387389ULL, 0x0002a200000e0038ULL, 0xfffec08036007950ULL, 0x000fea0003c3ffffULL,
0x0000001f00007348ULL, 0x000fe80003800000ULL, 0x0000001017177389ULL, 0x0002a200000e001cULL,
0x00000000ff117424ULL, 0x000fc400078e00ffULL, 0x000000ffff107224ULL, 0x002fc800078e001dULL,
0xfffec03010007950ULL, 0x000fea0003c3ffffULL, 0x000000011000780cULL, 0x000fe20003f05070ULL,
0x0000001700007348ULL, 0x000fe80003800000ULL, 0x00000000ff117424ULL, 0x000fd000078e00ffULL,
0x0000000000107806ULL, 0x000fc800040e0100ULL, 0x0000001710177212ULL, 0x000fe200078ec0ffULL,
0x000000ffff107224ULL, 0x000fc800078e001dULL, 0xfffebfc010007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000100000008ULL, 0x0000000100000001ULL, 0x0000000100000001ULL, 0x0000001000000004ULL,
0x0000000100000001ULL, 0x0000000400000008ULL, 0x0000000300000008ULL, 0x0000000400000004ULL,
0x0000000000000003ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005deULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000740ULL, 0x0000000000000288ULL, 0x0000001a00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009c8ULL, 0x0000000000000340ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d08ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000dc8ULL, 0x0000000000000784ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001550ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000001560ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000007bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015f0ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x00000000000015f4ULL, 0x00000000000001b0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001800ULL, 0x0000000000014100ULL, 0x8e00001a00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x0000000100000089ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015900ULL, 0x0000000000000044ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000015950ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000015cd0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x00000000000015f0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000014310ULL, 0x0000000000014310ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000015900ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000015cd0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_128_nqpkv_8_m_8_sm_80_cubin_len = 89520;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
