/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_86_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x0000000000014bd0ULL, 0x0000000000014850ULL, 0x0038004000560556ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45316a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45326a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4536316aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x316a4c4545346a4cULL, 0x454536316a4c4536ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545346a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45316a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454531624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x5f00676e6964696cULL, 0x727241374b4e5a5aULL, 0x6e49394944327961ULL, 0x4974614d6e497473ULL,
0x45326a4c45326a4cULL, 0x316a4c45326a4c45ULL, 0x624c497461324545ULL, 0x31534b5245454530ULL,
0x6f723431456a6a5fULL, 0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL,
0x4963655633494432ULL, 0x6a4c4545346a4c6aULL, 0x4545386a4c453631ULL, 0x4530624c49746132ULL,
0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL, 0x6e695f5f2400676eULL,
0x305f6c616e726574ULL, 0x616475635f5f245fULL, 0x63725f30326d735fULL, 0x7a74665f6e725f70ULL,
0x6f6c735f3233665fULL, 0x5f24006874617077ULL, 0x616e7265746e695fULL, 0x635f5f245f315f6cULL,
0x30376d735f616475ULL, 0x6e79736c6668735fULL, 0x705f796c66625f63ULL, 0x65746e695f5f2400ULL,
0x245f325f6c616e72ULL, 0x735f616475635f5fULL, 0x6c6668735f30376dULL, 0x7864695f636e7973ULL,
0x6e695f5f2400705fULL, 0x335f6c616e726574ULL, 0x616475635f5f245fULL, 0x6f765f30376d735fULL,
0x625f636e79736574ULL, 0x722e00746f6c6c61ULL, 0x747865742e616c65ULL, 0x5f6c656e72656b2eULL,
0x6c65722e0061686dULL, 0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x6c656e72656b2400ULL,
0x656d732461686d5fULL, 0x667542657479426dULL, 0x6e6f632e766e2e00ULL, 0x6b2e30746e617473ULL,
0x686d5f6c656e7265ULL, 0x6d617261705f0061ULL, 0x5f67756265642e00ULL, 0x722e00656d617266ULL,
0x67756265642e6c65ULL, 0x2e00656d6172665fULL, 0x6265642e616c6572ULL, 0x656d6172665f6775ULL,
0x6c65722e766e2e00ULL, 0x006e6f697463612eULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000b00030000004bULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x000c000300000086ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000100000096ULL,
0x0000000000000014ULL, 0x0000000000000004ULL, 0x00090003000000a3ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00090001000000b1ULL, 0x0000000000000000ULL, 0x0000000000000004ULL,
0x000c0001000000baULL, 0x0000000000000038ULL, 0x0000000000000010ULL, 0x000c0001000000f8ULL,
0x0000000000000004ULL, 0x0000000000000004ULL, 0x000c000100000131ULL, 0x0000000000000030ULL,
0x0000000000000004ULL, 0x000c000100000178ULL, 0x000000000000001cULL, 0x0000000000000004ULL,
0x000c0001000001baULL, 0x0000000000000028ULL, 0x0000000000000004ULL, 0x000c000100000200ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c000100000247ULL, 0x0000000000000034ULL,
0x0000000000000004ULL, 0x000c00010000028dULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c0001000002dbULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000329ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c000100000377ULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c0001000003c5ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c00010000040bULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c000100000459ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000049fULL, 0x0000000000012c50ULL,
0x0000000000000190ULL, 0x000b0022000004d2ULL, 0x0000000000012de0ULL, 0x0000000000000040ULL,
0x000b0022000004fdULL, 0x0000000000012e20ULL, 0x0000000000000050ULL, 0x000b002200000527ULL,
0x0000000000012e70ULL, 0x0000000000000110ULL, 0x000a000300000595ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00040003000005b5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00070003000005e5ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000012f80ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00012c5000000000ULL,
0x0000040400000000ULL, 0x810c000001640400ULL, 0x0049a40400288080ULL, 0x0000000000000000ULL,
0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8708288080860828ULL, 0x2880808b08288080ULL,
0x8094082880808f08ULL, 0x0828808095082880ULL, 0x80809b0828808099ULL, 0xa708288080a10828ULL,
0x288080b108288080ULL, 0x8280162880808508ULL, 0x0000000003102880ULL, 0x8080859200000000ULL,
0x0000000000220028ULL, 0x00000034ffffffffULL, 0x0000007000000000ULL, 0x00012c5000000000ULL,
0x0000019000000000ULL, 0x0000580400000000ULL, 0x8084288080820900ULL, 0x0900000004042880ULL,
0x2880808228808085ULL, 0x0000007cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8608288080850828ULL,
0x2880808708288080ULL, 0x808f082880808e08ULL, 0x0828808094082880ULL, 0x8080990828808095ULL,
0xa1082880809b0828ULL, 0x288080a708288080ULL, 0x808c08288080b108ULL, 0x1028808280162880ULL,
0x0000000000000003ULL, 0x22002880808c9200ULL, 0x0000001cffffffffULL, 0x0000013800000000ULL,
0x00012de000000000ULL, 0x0000004000000000ULL, 0x0000000000000000ULL, 0x0000007cffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8608288080850828ULL, 0x2880808708288080ULL, 0x808f082880808b08ULL,
0x0828808094082880ULL, 0x80809b0828808099ULL, 0xa708288080a10828ULL, 0x288080b108288080ULL,
0x8280162880809508ULL, 0x0000000003102880ULL, 0x8080959200000000ULL, 0x0000000000220028ULL,
0x0000002cffffffffULL, 0x000001e800000000ULL, 0x00012e2000000000ULL, 0x0000005000000000ULL,
0x00000c0400000000ULL, 0x8094288080950900ULL, 0x0000000000002880ULL, 0x00000074ffffffffULL,
0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL,
0x8080820828808081ULL, 0x8608288080850828ULL, 0x2880808708288080ULL, 0x8095082880808f08ULL,
0x0828808099082880ULL, 0x8080a1082880809bULL, 0xb108288080a70828ULL, 0x2880809408288080ULL,
0x0003102880828016ULL, 0x9200000000000000ULL, 0x0000220028808094ULL, 0x0000001cffffffffULL,
0x000002a800000000ULL, 0x00012e7000000000ULL, 0x0000011000000000ULL, 0x0000000000000000ULL,
0x0000001b00082f04ULL, 0x0008230400000080ULL, 0x0000000000000017ULL, 0x0000001700081204ULL,
0x0008110400000000ULL, 0x0000000000000017ULL, 0x0000001600082304ULL, 0x0008120400000000ULL,
0x0000000000000016ULL, 0x0000001600081104ULL, 0x0008230400000000ULL, 0x0000000000000015ULL,
0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL, 0x0000001400082304ULL,
0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL, 0x0008230400000000ULL,
0x000000000000001bULL, 0x0000001b00081204ULL, 0x0008110400000000ULL, 0x000000000000001bULL,
0x0000007b00043704ULL, 0x00080a0400003501ULL, 0x0060016000000018ULL, 0x000c170400601903ULL,
0x0058000900000000ULL, 0x000c17040021f000ULL, 0x0050000800000000ULL, 0x000c17040021f000ULL,
0x0048000700000000ULL, 0x000c17040011f000ULL, 0x0028000600000000ULL, 0x000c17040081f000ULL,
0x0020000500000000ULL, 0x000c17040021f000ULL, 0x0018000400000000ULL, 0x000c17040021f000ULL,
0x0010000300000000ULL, 0x000c17040021f000ULL, 0x0008000200000000ULL, 0x000c17040011f000ULL,
0x0004000100000000ULL, 0x000c17040011f000ULL, 0x0000000000000000ULL, 0x00801b030011f000ULL,
0x0000090000043104ULL, 0xffffffff01342904ULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0x0000044001342804ULL, 0x0000058000000470ULL, 0x0000272000002680ULL, 0x000029a000002840ULL,
0x00002e6000002e30ULL, 0x00002f0000002eb0ULL, 0x00004f5000004ec0ULL, 0x000051e000005080ULL,
0x000056a000005670ULL, 0x00005740000056f0ULL, 0x00007550000074b0ULL, 0x000077e000007680ULL,
0x00007ca000007c70ULL, 0x00007d4000007cf0ULL, 0x00009be000009b40ULL, 0x00009e7000009d10ULL,
0x0000a3300000a300ULL, 0x0000a3d00000a380ULL, 0x0000b6100000b600ULL, 0x0001159000011550ULL,
0x000115b0000115a0ULL, 0x00011620000115c0ULL, 0x0001166000011640ULL, 0x000122d000012290ULL,
0x0001236000012320ULL, 0x00012400000123b0ULL, 0x0001249000012450ULL, 0x00012520000124e0ULL,
0x000125c000012570ULL, 0x0001265000012610ULL, 0x000126e0000126a0ULL, 0x0001278000012730ULL,
0x00012810000127d0ULL, 0x000128a000012860ULL, 0x00012940000128f0ULL, 0x000129f000012990ULL,
0x00012ab000012a50ULL, 0x00012b7000012b10ULL, 0x00012c3000012bd0ULL, 0x000003d004403904ULL,
0x0000f600000000ffULL, 0x000004a0003f0100ULL, 0x0000f6080000000bULL, 0x000004c0003f0120ULL,
0x0000f6880000000bULL, 0x000004e0003f0120ULL, 0x0000f6a80000000bULL, 0x00000540003f0120ULL,
0x0000f6c80000000bULL, 0x00000910003f0120ULL, 0x0000f600000000ffULL, 0x00000b10003f0107ULL,
0x0000000400000006ULL, 0x00000bc0003f0102ULL, 0x0000000000000006ULL, 0x00001400003f0101ULL,
0x0000f6a800000003ULL, 0x00001550003f0107ULL, 0x0000f6a800000003ULL, 0x000015b0003f0101ULL,
0x0000f6c800000005ULL, 0x00001750003f0101ULL, 0x0000f6cc0000000bULL, 0x00001930003f0105ULL,
0x0000f6cc0000000bULL, 0x00002270003f0105ULL, 0x0000f6b000000011ULL, 0x00002320003f0107ULL,
0x0000f6b000000011ULL, 0x00002380003f0101ULL, 0x0000f60800000008ULL, 0x000023a0003f0101ULL,
0x0000f60c00000008ULL, 0x00002570003f0105ULL, 0x0000f60c00000008ULL, 0x00002b90003f0105ULL,
0x0000f6ac00000014ULL, 0x00002d60003f0105ULL, 0x0000f6ac00000014ULL, 0x00004030003f0105ULL,
0x0000000000000014ULL, 0x00004090003f0101ULL, 0x0000f6880000005fULL, 0x000040c0003f0101ULL,
0x0000000400000004ULL, 0x00004280003f0105ULL, 0x0000000400000004ULL, 0x00004ad0003f0105ULL,
0x0000f6a80000000bULL, 0x00004ba0003f0107ULL, 0x0000f6a80000000bULL, 0x00004c00003f0101ULL,
0x0000f62800000008ULL, 0x00004c20003f0101ULL, 0x0000f62c00000008ULL, 0x00004df0003f0105ULL,
0x0000f62c00000008ULL, 0x000053d0003f0105ULL, 0x0000f6b400000034ULL, 0x000055a0003f0105ULL,
0x0000f6b400000034ULL, 0x00006620003f0105ULL, 0x000000000000000eULL, 0x00006680003f0101ULL,
0x0000f69000000010ULL, 0x000066b0003f0101ULL, 0x0000000400000004ULL, 0x00006870003f0105ULL,
0x0000000400000004ULL, 0x000070c0003f0105ULL, 0x0000f6b00000000bULL, 0x00007190003f0107ULL,
0x0000f6b00000000bULL, 0x000071f0003f0101ULL, 0x0000f64800000008ULL, 0x00007210003f0101ULL,
0x0000f64c00000008ULL, 0x000073e0003f0105ULL, 0x0000f64c00000008ULL, 0x000079d0003f0105ULL,
0x0000f6ac00000015ULL, 0x00007ba0003f0105ULL, 0x0000f6ac00000015ULL, 0x00008c50003f0105ULL,
0x000000000000000aULL, 0x00008cb0003f0101ULL, 0x0000f6980000000cULL, 0x00008ce0003f0101ULL,
0x0000000400000004ULL, 0x00008ea0003f0105ULL, 0x0000000400000004ULL, 0x000097b0003f0105ULL,
0x0000f6a80000000aULL, 0x00009840003f0107ULL, 0x0000f6a80000000aULL, 0x000098a0003f0101ULL,
0x0000f66800000003ULL, 0x000098c0003f0101ULL, 0x0000f66c00000003ULL, 0x00009a90003f0105ULL,
0x0000f66c00000003ULL, 0x0000a060003f0105ULL, 0x0000f6b40000000cULL, 0x0000a230003f0105ULL,
0x0000f6b40000000cULL, 0x0000b3d0003f0105ULL, 0x0000000000000004ULL, 0x0000b450003f0101ULL,
0x000000000000000bULL, 0x0000c570003f0101ULL, 0x0000f600000000ffULL, 0x0000d190003f0101ULL,
0x0000f604000000ffULL, 0x0000d360003f0105ULL, 0x0000f604000000ffULL, 0x0000d590003f0105ULL,
0x0000f600000000ffULL, 0x0000d5c0003f0101ULL, 0x0000f604000000ffULL, 0x0000d780003f0105ULL,
0x0000f604000000ffULL, 0x0000faa0003f0105ULL, 0x0000000000000074ULL, 0x0000fb40003f0101ULL,
0x0000000400000074ULL, 0x0000fd10003f0105ULL, 0x0000000400000074ULL, 0x000120f0003f0105ULL,
0x0000000000000076ULL, 0x00012150003f0101ULL, 0x0000000800000076ULL, 0x000121b0003f0101ULL,
0x0000001000000076ULL, 0x00012220003f0101ULL, 0x0000001800000076ULL, 0x00053803003f0101ULL,
0x0000be8000201c04ULL, 0x0000c0a00000beb0ULL, 0x0000c3900000c200ULL, 0x0000d7e00000c490ULL,
0x0000040100012260ULL, 0x00000100000c0504ULL, 0x0000000100000001ULL, 0x0000000000041e04ULL,
0x0000000000000073ULL, 0x3605002511000000ULL, 0x000000000000033cULL, 0x0000001b00000002ULL,
0x0000000000000284ULL, 0x0000001b00000002ULL, 0x00000000000001d4ULL, 0x0000001b00000002ULL,
0x000000000000010cULL, 0x0000001b00000002ULL, 0x0000000000000044ULL, 0x0000001b00000002ULL,
0x0000000000000317ULL, 0x0000001b00000002ULL, 0x000000000000025cULL, 0x0000001b00000002ULL,
0x00000000000001b1ULL, 0x0000001b00000002ULL, 0x00000000000000e4ULL, 0x0000001b00000002ULL,
0x000000000000f700ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff0c7624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x0000000000747919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000a7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a000c797a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000f280000002100ULL,
0x0000000000707919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x004fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000040003077a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a07ULL,
0x0000040003007624ULL, 0x000fca00078e020cULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff07aa12ULL, 0x000fc800078e33ffULL, 0x0000000700007306ULL, 0x000e620000209000ULL,
0x000000ff0700720cULL, 0x000fce0003fa5070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x0002a4000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000307047224ULL, 0x004fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000007403727227ULL, 0x000fe400078e00ffULL, 0x0000000000037919ULL, 0x000ee40000002200ULL,
0x000000ffff007224ULL, 0x000fc800078e0a72ULL, 0x0000000007007224ULL, 0x000fca00078e0274ULL,
0x000000070000720cULL, 0x000fda0003f66070ULL, 0x0000000100003824ULL, 0x000fe200078e0a07ULL,
0x0000000172723810ULL, 0x000fe20007ffe0ffULL, 0x000001000a027a24ULL, 0x008fc600078e0203ULL,
0x000000070000720cULL, 0x000fe20003f86070ULL, 0x00000000020b7a24ULL, 0x010fca00078e0209ULL,
0x000000ff0b00720cULL, 0x040fe40003f45270ULL, 0x0000007f0b00780cULL, 0x040fe40003f04070ULL,
0x0000000f0b00780cULL, 0x040fe40003f24070ULL, 0x000000030b00780cULL, 0x000fe40003f64070ULL,
0x0000000172724810ULL, 0x000fe40007ffe0ffULL, 0x00000007ff72d212ULL, 0x000fc400078e33ffULL,
0x000000010b00780cULL, 0x000fe20003f84070ULL, 0x3fffff80ff02a424ULL, 0x000fe400078e00ffULL,
0x000000ffff007224ULL, 0x000fe400078e0a72ULL, 0x7fffff80ff03a424ULL, 0x000fe400078e00ffULL,
0x0000000007747224ULL, 0x000fe200078e0274ULL, 0x00000005ff007819ULL, 0x000fe20000011609ULL,
0xff317217ff088424ULL, 0x000fe200078e00ffULL, 0x00f60002ff00a388ULL, 0x0003e20000000a00ULL,
0x00000010746f7824ULL, 0x000fc400078e00ffULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x00f400080b008388ULL, 0x0005e20000004800ULL, 0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL,
0x000000046f007c0cULL, 0x040fe2000bf03070ULL, 0x3fffff60ff06b424ULL, 0x000fe200078e00ffULL,
0x00001fff0a097589ULL, 0x000fe200000e0000ULL, 0x7fffff60ff07b424ULL, 0x000fe400078e00ffULL,
0x3fffff80ff02b424ULL, 0x002fe200078e00ffULL, 0x00001fff00007589ULL, 0x000e6200000e0000ULL,
0x7fffff80ff03b424ULL, 0x000fe200078e00ffULL, 0x000000046f087c10ULL, 0x004fc4000fffe1ffULL,
0x00f608040b009388ULL, 0x0005e40000008a00ULL, 0x0000001008087817ULL, 0x000fe40003800000ULL,
0x00f688060b00b388ULL, 0x0007e40000008a00ULL, 0x000000ff08737207ULL, 0x000fe40000000000ULL,
0x00f6a8020b00b388ULL, 0x0003e20000008a00ULL, 0x00005a0072087a19ULL, 0x000fe400000006ffULL,
0x000000107300780cULL, 0x000fe20003f05270ULL, 0x3fffffc0ff04c424ULL, 0x004fc400078e00ffULL,
0x7fffffc0ff05c424ULL, 0x000fe400078e00ffULL, 0x0000580070067a24ULL, 0x008fc600078e02ffULL,
0x00f6c8040b00c388ULL, 0x000fe20000008a00ULL, 0x0000000409027824ULL, 0x002fe400078e0200ULL,
0x0000007906067224ULL, 0x000fe400078e0208ULL, 0x0000000202027824ULL, 0x000fe200078e00ffULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000001d000008947ULL, 0x000fea0003800000ULL,
0x0000000000417919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fc40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x00000004ff077819ULL, 0x002fca0000011641ULL, 0x0000000102087824ULL, 0x000fc800078e0207ULL,
0x000000016f037824ULL, 0x000fca00078e0208ULL, 0x0000000403057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fe20000011603ULL, 0x0000001041037824ULL, 0x000fe400078e00ffULL,
0x0000000106067824ULL, 0x000fe200078e0205ULL, 0x0000000273057217ULL, 0x000fe40007800000ULL,
0x000000f0030b7812ULL, 0x000fe200078ec0ffULL, 0x0000007904047224ULL, 0x000fe400078e0206ULL,
0x0000000105027824ULL, 0x000fc400078e0a02ULL, 0x0000010004047825ULL, 0x000fc600078e00ffULL,
0x000000020700720cULL, 0x000fe20003f06070ULL, 0x0000000108027824ULL, 0x000fe200078e0241ULL,
0x0000000b040b7212ULL, 0x000fe200078efcffULL, 0x0000001008077824ULL, 0x000fc600078e00ffULL,
0x00005e000b047a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff007027812ULL, 0x000fe400078ee202ULL,
0x00005f0005057a10ULL, 0x000fc60000ffe4ffULL, 0x0000001002077824ULL, 0x000fca00078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000004077faeULL, 0x0003e2000c101c48ULL,
0x0000018000007947ULL, 0x000fea0003800000ULL, 0x0000000000417919ULL, 0x000e620000000000ULL,
0xffffffff00047882ULL, 0x000fe40000000000ULL, 0x00005a0000057ab9ULL, 0x000fe40000000800ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x0000000241027211ULL, 0x002fca00078fe0ffULL,
0x000000016f037824ULL, 0x000fca00078e0202ULL, 0x0000000403057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff047a19ULL, 0x000fe20000011603ULL, 0x0000001041037824ULL, 0x000fe400078e00ffULL,
0x0000000106057824ULL, 0x000fe400078e0205ULL, 0x0000000102067824ULL, 0x000fe200078e0241ULL,
0x000000f003077812ULL, 0x000fe200078ec0ffULL, 0x0000007904047224ULL, 0x000fc800078e0205ULL,
0x0000010004047825ULL, 0x000fca00078e00ffULL, 0x0000000704047212ULL, 0x000fe200078efcffULL,
0x0000001002077824ULL, 0x000fc600078e00ffULL, 0x00005e0004047a10ULL, 0x000fe40007f1e0ffULL,
0xfffffff007067812ULL, 0x000fe400078ee206ULL, 0x00005f0005057a10ULL, 0x000fc600007fe4ffULL,
0x0000001006077824ULL, 0x000fca00078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000004077faeULL, 0x0003e4000b901c48ULL, 0x0000000000057919ULL, 0x002e620000000000ULL,
0x0000000000027806ULL, 0x000fc600038e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000200047300ULL, 0x000e7000000e0000ULL, 0x0000000200067309ULL, 0x000ea20000000000ULL,
0x000000050400720cULL, 0x002fe20003f02070ULL, 0x00000004ff057424ULL, 0x000fc400078e00ffULL,
0x000000ffff047224ULL, 0x004fe400078e0a06ULL, 0x0000660070067625ULL, 0x000fd000078e0005ULL,
0x00f60404ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00f60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000806677981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe40003f05270ULL, 0x0000003f67687810ULL, 0x044fe40007ffe0ffULL,
0x000000ff67027810ULL, 0x000fc40007ffe0ffULL, 0x00000006ff687819ULL, 0x000fe40000011668ULL,
0x00000008ff697819ULL, 0x000fca0000011602ULL, 0x0000ba4000008947ULL, 0x000fea0003800000ULL,
0x00000002ff717819ULL, 0x000fe20000011600ULL, 0x00000003ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000f68800067811ULL, 0x000fe400078e18ffULL, 0x03ffffff71077812ULL, 0x000fc800078ec0ffULL,
0x000000680700720cULL, 0x000fda0003f06070ULL, 0x0000000270048824ULL, 0x002fe400078e00ffULL,
0x00006800ff098624ULL, 0x000fc800078e00ffULL, 0x0000680004088624ULL, 0x000fe400078e0209ULL,
0xffffffffff047424ULL, 0x000fe400078e00ffULL, 0x0000000107088824ULL, 0x000fe200078e0208ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040b06ff738cULL, 0x0003e20000000000ULL,
0x0000640008088625ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000808048981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0200780cULL, 0x000fe20003f04070ULL,
0x00000040726e7824ULL, 0x000fe200078e00ffULL, 0x00000001ff6b7819ULL, 0x000fe20000011600ULL,
0x0000000006ff7f8cULL, 0x0007e8000c80043fULL, 0x000000206b757824ULL, 0x000fca00078e00ffULL,
0x000000206e027812ULL, 0x000fe200078ef875ULL, 0x00005900040a7a24ULL, 0x004fe200078e02ffULL,
0x0000000100047812ULL, 0x000fc600078ec0ffULL, 0x000000400a197824ULL, 0x000fe200078e00ffULL,
0x0000040000000947ULL, 0x000fea0003800000ULL, 0x0000007567067217ULL, 0x00afe20007800000ULL,
0x0000001004097824ULL, 0x000fe200078e00ffULL, 0x00000003ff087819ULL, 0x000fe40000011641ULL,
0x0000620019117a11ULL, 0x000fe200078838ffULL, 0x0000000106067824ULL, 0x000fe200078e0a75ULL,
0x00000004080c7810ULL, 0x040fe20007ffe0ffULL, 0x00000001090a7824ULL, 0x000fe200078e0208ULL,
0x0000000c080d7810ULL, 0x000fe40007ffe0ffULL, 0x0000000906067217ULL, 0x000fe20007800000ULL,
0x000000010a0b7824ULL, 0x040fe200078e0241ULL, 0x0000630019197a11ULL, 0x000fe200020f3cffULL,
0x000000080a107824ULL, 0x000fc400078e00ffULL, 0x0000000106067824ULL, 0x000fe400078e0a09ULL,
0x00000001090e7824ULL, 0x040fe200078e020dULL, 0xfffffff810107812ULL, 0x000fe400078ee20bULL,
0x00000008080b7810ULL, 0x000fe20007ffe0ffULL, 0x000000080e137824ULL, 0x000fe200078e00ffULL,
0x000000060c00720cULL, 0x080fe20003f46070ULL, 0x00000001090c7824ULL, 0x000fe200078e020cULL,
0x000000060b00720cULL, 0x080fe20003f26070ULL, 0x00000001090b7824ULL, 0x000fe200078e020bULL,
0x000000060800720cULL, 0x080fe20003f66070ULL, 0x000000010c097824ULL, 0x040fe200078e0241ULL,
0x000000060d00720cULL, 0x000fe20003f06070ULL, 0x000000080c127824ULL, 0x000fc400078e00ffULL,
0x0000000102087824ULL, 0x000fe400078e020aULL, 0x000000010b0a7824ULL, 0x040fe200078e0241ULL,
0xfffffff812067812ULL, 0x000fe200078ee209ULL, 0x000000080b0f7824ULL, 0x000fe400078e00ffULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff80f127812ULL, 0x000fe200078ee20aULL,
0x00000001020a7824ULL, 0x000fe200078e020cULL, 0x0000007008087812ULL, 0x000fe200078ef803ULL,
0x00000001020c7824ULL, 0x040fe400078e020bULL, 0x00000001020f7824ULL, 0x000fe200078e020eULL,
0x0000000811087210ULL, 0x000fe20007f9e0ffULL, 0x000000010e027824ULL, 0x000fe400078e0241ULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0xfffffff813147812ULL, 0x000fe200078ee202ULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000700a027812ULL, 0x000fc600078ef803ULL,
0x000000800f0e7825ULL, 0x000fe200078e00ffULL, 0x000000700c0a7812ULL, 0x000fc600078ef803ULL,
0x0000000109097824ULL, 0x000fe200020e0619ULL, 0x000000700e0c7812ULL, 0x000fe400078ef803ULL,
0x0000b0006b037811ULL, 0x000fe400078e68ffULL, 0x0000001102027210ULL, 0x080fe40007f9e0ffULL,
0x000000110a0a7210ULL, 0x080fe20007fbe0ffULL, 0x0000001006137824ULL, 0x100fe200078e0203ULL,
0x000000110c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001010117824ULL, 0x000fc400078e0203ULL,
0x0000001012157824ULL, 0x100fe400078e0203ULL, 0x0000001014177824ULL, 0x000fe200078e0203ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000008117faeULL, 0x0003e2000d901c48ULL,
0x000000010b037824ULL, 0x100fe400020e0619ULL, 0x000000010d0b7824ULL, 0x100fe400028e0619ULL,
0x000000010f0d7824ULL, 0x000fe200030e0619ULL, 0x0000000002137faeULL, 0x0003e8000d101c48ULL,
0x000000000a157faeULL, 0x0003e8000c901c48ULL, 0x000000000c177faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001004067824ULL, 0x00afe200078e00ffULL,
0x0000620019117a11ULL, 0x000fc400078038ffULL, 0x0000b0006b177811ULL, 0x000fe400078e68ffULL,
0x0000000641067211ULL, 0x000fe400078fe8ffULL, 0x0000630019197a11ULL, 0x000fe400000f3cffULL,
0x00000004060a7810ULL, 0x040fe20007ffe0ffULL, 0x0000000106087824ULL, 0x040fe200078e0241ULL,
0x00000008060b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000806097824ULL, 0x000fe400078e00ffULL,
0x000000080a127824ULL, 0x000fc400078e00ffULL, 0x000000010b0c7824ULL, 0x100fe200078e0241ULL,
0xfffffff809107812ULL, 0x000fe200078ee208ULL, 0x000000010a097824ULL, 0x000fe400078e0241ULL,
0x0000000102087824ULL, 0x000fe200078e0206ULL, 0x0000000c06067810ULL, 0x000fe20007ffe0ffULL,
0x000000080b0d7824ULL, 0x000fe200078e00ffULL, 0xfffffff812127812ULL, 0x000fe200078ee209ULL,
0x0000008008087825ULL, 0x000fc600078e00ffULL, 0xfffffff80d147812ULL, 0x000fe200078ee20cULL,
0x00000001020a7824ULL, 0x000fe200078e020aULL, 0x0000007008087812ULL, 0x000fe200078ef803ULL,
0x00000001020c7824ULL, 0x040fe400078e020bULL, 0x00000001020e7824ULL, 0x000fe200078e0206ULL,
0x0000000811087210ULL, 0x000fe20007f1e0ffULL, 0x0000000106027824ULL, 0x040fe400078e0241ULL,
0x0000000806137824ULL, 0x000fe400078e00ffULL, 0x000000800a0a7825ULL, 0x000fc600078e00ffULL,
0xfffffff813067812ULL, 0x000fe200078ee202ULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x000000700a027812ULL, 0x000fc600078ef803ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000700c0a7812ULL, 0x000fc600078ef803ULL, 0x0000000109097824ULL, 0x000fe200000e0619ULL,
0x000000700e037812ULL, 0x000fe200078ef803ULL, 0x0000001012137824ULL, 0x100fe200078e0217ULL,
0x0000000211027210ULL, 0x040fe20007f1e0ffULL, 0x0000001014157824ULL, 0x100fe200078e0217ULL,
0x0000000a110a7210ULL, 0x040fe40007f3e0ffULL, 0x00000003110c7210ULL, 0x000fe20007f5e0ffULL,
0x0000001010117824ULL, 0x000fe400078e0217ULL, 0x000000010b037824ULL, 0x000fc400000e0619ULL,
0x000000010d0b7824ULL, 0x000fe200008e0619ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000008117faeULL, 0x0003e2000b901c48ULL, 0x0000001006177824ULL, 0x000fe400078e0217ULL,
0x000000010f0d7824ULL, 0x000fe200010e0619ULL, 0x0000000002137faeULL, 0x0003e8000b901c48ULL,
0x000000000a157faeULL, 0x0003e8000b901c48ULL, 0x000000000c177faeULL, 0x0003e4000b901c48ULL,
0x0000000107027810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff0e7424ULL, 0x000fc600078e00ffULL,
0x000000680200720cULL, 0x000fda0003f06070ULL, 0x0000000270038824ULL, 0x000fe400078e00ffULL,
0x00006800ff068624ULL, 0x000fc800078e00ffULL, 0x0000680003038624ULL, 0x000fc800078e0206ULL,
0x0000000103068824ULL, 0x000fe400078e0202ULL, 0x000000106b037824ULL, 0x000fe400078e00ffULL,
0x0000640006068625ULL, 0x000fe400078e0005ULL, 0x00000000030473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000fe80000000000ULL, 0x00000008060e8981ULL, 0x000522000c1e1900ULL,
0x000000ff6900720cULL, 0x000fe20003f05270ULL, 0x000000086b057824ULL, 0x000fe200078e00ffULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x000000ffff097224ULL, 0x000fe200078e00ffULL,
0x0000000000207805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000187805ULL, 0x000fe2000001ff00ULL, 0x00000000001e7805ULL, 0x000fe2000001ff00ULL,
0x00000000001c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x000000ffff357224ULL, 0x000fe200078e00ffULL, 0x0000f6a804047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x00f6a800030c7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6c80005067f8cULL, 0x000662000c80043fULL,
0x000000ffff347224ULL, 0x000fe200078e00ffULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000002a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000287805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00009e3000008947ULL, 0x000fea0003800000ULL,
0x0000001003067812ULL, 0x00afe200078ec0ffULL, 0x00000002706f7824ULL, 0x000fc400078e00ffULL,
0x00006800ff0a7624ULL, 0x000fe400078e00ffULL, 0x0000002071037824ULL, 0x000fe400078e0206ULL,
0x000068006f6f7624ULL, 0x000fe400078e020aULL, 0x000000ffff087224ULL, 0x000fe400078e0007ULL,
0x0000000804037824ULL, 0x000fe400078e0203ULL, 0xff317217ff0a7424ULL, 0x000fc400078e00ffULL,
0x000000ffff407224ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fc400078e00ffULL,
0x000000ffff6c7224ULL, 0x02afca00078e0002ULL, 0x0000000000107805ULL, 0x000fc40000015200ULL,
0x0000000400047824ULL, 0x000fca00078e00ffULL, 0xfffffff8040b7812ULL, 0x000fc800078ec0ffULL,
0x0000f6c80b047810ULL, 0x000fe20007ffe0ffULL, 0x00f6cc000b0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804808ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x000000ffff147224ULL, 0x000fe200078e00ffULL,
0x000001d000000947ULL, 0x000fea0003800000ULL, 0x000001c000017945ULL, 0x000fe40003800000ULL,
0x000000101400780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000027945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x00000012100f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000113127824ULL, 0x000fe200000e0e11ULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1200720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1200720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x004fc80000011412ULL,
0x0000000f0c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e0612ULL,
0x000000020c0c7819ULL, 0x000fc8000000120fULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000114147810ULL, 0x000fc40007ffe0ffULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00f6cc000b0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804808ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000087824ULL, 0x000fe200078e00ffULL,
0x00000001400c7810ULL, 0x004fe20007ffe0ffULL, 0x000059000e0e7a24ULL, 0x010fc600078e02ffULL,
0xffffffe0080b7812ULL, 0x000fe200078ec0ffULL, 0x000000400e3d7824ULL, 0x000fe200078e00ffULL,
0x000000690c00720cULL, 0x000fc60003f26070ULL, 0x00000100400b7824ULL, 0x000fca00078e020bULL,
0x000000400b0f7810ULL, 0x000fc80007ffe0ffULL, 0x000000200f0b7812ULL, 0x000fca00078ec0ffULL,
0x000000016e117824ULL, 0x000fe200078e020bULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x00000010080b7812ULL, 0x000fe400078ec0ffULL, 0x0000000f67087217ULL, 0x000fe40007800000ULL,
0x00000003ff107819ULL, 0x000fe40000011641ULL, 0x000062003d177a11ULL, 0x000fe200078a38ffULL,
0x0000000108087824ULL, 0x000fe200078e0a0fULL, 0x0000000810127810ULL, 0x040fe20007ffe0ffULL,
0x00000001100c7824ULL, 0x040fe200078e020bULL, 0x00000004100f7810ULL, 0x000fc40007ffe0ffULL,
0x0000000b08087217ULL, 0x000fe20007800000ULL, 0x000000010c0e7824ULL, 0x040fe200078e0241ULL,
0x000063003d3d7a11ULL, 0x000fe200028f3cffULL, 0x000000080c137824ULL, 0x000fe400078e00ffULL,
0x0000000108087824ULL, 0x000fc600078e0a0bULL, 0xfffffff813167812ULL, 0x000fe400078ee20eULL,
0x0000000c100e7810ULL, 0x000fe40007ffe0ffULL, 0x000000081200720cULL, 0x0c0fe20003f46070ULL,
0x0000000112127824ULL, 0x100fe200078e020bULL, 0x000000081000720cULL, 0x080fe20003f86070ULL,
0x000000010f107824ULL, 0x140fe200078e020bULL, 0x000000080f00720cULL, 0x080fe20003f66070ULL,
0x00000010410f7824ULL, 0x000fe200078e00ffULL, 0x000000080e00720cULL, 0x040fe20003f06070ULL,
0x000000010e247824ULL, 0x000fc400078e020bULL, 0x00000001120b7824ULL, 0x140fe200078e0241ULL,
0x000000700f257812ULL, 0x000fe200078ec0ffULL, 0x0000000812147824ULL, 0x000fe400078e00ffULL,
0x00000001110e7824ULL, 0x000fe400078e020cULL, 0x0000000110087824ULL, 0x000fe200078e0241ULL,
0xfffffff8140c7812ULL, 0x000fe200078ee20bULL, 0x000000800e0e7825ULL, 0x000fc800078e00ffULL,
0x0000000111147824ULL, 0x000fe200078e0210ULL, 0x000000250e0e7212ULL, 0x080fe200078efcffULL,
0x0000000810137824ULL, 0x000fe400078e00ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000000e170e7210ULL, 0x000fe40007fbe0ffULL, 0xfffffff813087812ULL, 0x000fe200078ee208ULL,
0x0000000111107824ULL, 0x040fe200078e0212ULL, 0x0000002514147212ULL, 0x000fe200078efcffULL,
0x0000000111127824ULL, 0x000fc400078e0224ULL, 0x00000001240b7824ULL, 0x000fe400078e0241ULL,
0x0000008010107825ULL, 0x000fc800078e00ffULL, 0x0000000824247824ULL, 0x000fe200078e00ffULL,
0x0000002510107212ULL, 0x000fe200078efcffULL, 0x0000008012127825ULL, 0x000fc600078e00ffULL,
0xfffffff824247812ULL, 0x000fe200078ee20bULL, 0x000000010f0f7824ULL, 0x100fe200028e063dULL,
0x0000001714147210ULL, 0x000fe40007fbe0ffULL, 0x0000002512127212ULL, 0x000fe400078efcffULL,
0x0000c0006b0b7811ULL, 0x000fe200078e68ffULL, 0x0000000115157824ULL, 0x000fe200028e063dULL,
0x0000001710107210ULL, 0x080fe40007fbe0ffULL, 0x0000001712127210ULL, 0x000fe20007fde0ffULL,
0x0000001016177824ULL, 0x000fc400078e020bULL, 0x0000001008257824ULL, 0x100fe400078e020bULL,
0x000000100c277824ULL, 0x000fe200078e020bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e177faeULL, 0x0003e2000e101c48ULL, 0x0000000111117824ULL, 0x000fe400028e063dULL,
0x00000010240b7824ULL, 0x000fe200078e020bULL, 0x0000000014257faeULL, 0x0003e2000d901c48ULL,
0x0000000113137824ULL, 0x000fc600030e063dULL, 0x0000000010277faeULL, 0x0003e8000d101c48ULL,
0x00000000120b7faeULL, 0x0003e2000c101c48ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001008087812ULL, 0x000fe400078ec0ffULL, 0x000062003d257a11ULL, 0x000fe400078038ffULL,
0x0000000841087211ULL, 0x000fe400078fe8ffULL, 0x000063003d3d7a11ULL, 0x000fc400000f3cffULL,
0x00000004080c7810ULL, 0x040fe20007ffe0ffULL, 0x00000001080b7824ULL, 0x140fe200078e0241ULL,
0x0000000808127810ULL, 0x040fe20007ffe0ffULL, 0x0000000808107824ULL, 0x000fe400078e00ffULL,
0x000000010c0e7824ULL, 0x040fe400078e0241ULL, 0x000000080c137824ULL, 0x000fe200078e00ffULL,
0xfffffff8100b7812ULL, 0x000fe200078ee20bULL, 0x00000001120f7824ULL, 0x040fe400078e0241ULL,
0x0000000812247824ULL, 0x000fe200078e00ffULL, 0xfffffff813167812ULL, 0x000fe200078ee20eULL,
0x0000001041107824ULL, 0x000fc400078e00ffULL, 0x00000001110e7824ULL, 0x040fe200078e0208ULL,
0xfffffff824247812ULL, 0x000fe200078ee20fULL, 0x0000000111127824ULL, 0x000fe200078e0212ULL,
0x0000000c08087810ULL, 0x000fe20007ffe0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000007010177812ULL, 0x000fc600078ec0ffULL, 0x0000000111107824ULL, 0x040fe200078e020cULL,
0x000000170e0e7212ULL, 0x000fe200078efcffULL, 0x0000000111147824ULL, 0x000fe400078e0208ULL,
0x0000008010107825ULL, 0x000fe200078e00ffULL, 0x0000000e250e7210ULL, 0x000fc60007f1e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000001710107212ULL, 0x000fc600078efcffULL,
0x00000001080c7824ULL, 0x000fe200078e0241ULL, 0x0000001712127212ULL, 0x080fe200078efcffULL,
0x0000000808277824ULL, 0x000fe400078e00ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000001225127210ULL, 0x000fe40007f5e0ffULL, 0xfffffff8270c7812ULL, 0x000fe200078ee20cULL,
0x000000010f0f7824ULL, 0x100fe200000e063dULL, 0x0000001714147212ULL, 0x000fe200078efcffULL,
0x0000000113137824ULL, 0x000fe200010e063dULL, 0x0000c0006b277811ULL, 0x000fc400078e68ffULL,
0x0000001025107210ULL, 0x040fe40007f1e0ffULL, 0x0000001425147210ULL, 0x000fe20007f7e0ffULL,
0x000000100b0b7824ULL, 0x100fe400078e0227ULL, 0x0000001016177824ULL, 0x000fe400078e0227ULL,
0x0000000111117824ULL, 0x000fe200000e063dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0b7faeULL, 0x0003e2000b901c48ULL, 0x0000001024257824ULL, 0x100fe400078e0227ULL,
0x000000100c277824ULL, 0x000fe200078e0227ULL, 0x0000000010177faeULL, 0x0003e2000b901c48ULL,
0x0000000115157824ULL, 0x000fc600018e063dULL, 0x0000000012257faeULL, 0x0003e8000b901c48ULL,
0x0000000014277faeULL, 0x0003e4000b901c48ULL, 0x0000000800087824ULL, 0x000fe200078e00ffULL,
0x00000001020e7810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff0c7424ULL, 0x000fc600078e00ffULL,
0xfffffff008117812ULL, 0x000fe400078ec0ffULL, 0x000000680e00720cULL, 0x000fe40003f06070ULL,
0x00000000110473c2ULL, 0x000e6200000e0000ULL, 0xffffffe0080b7812ULL, 0x040fe400078ec0ffULL,
0x0000001008107812ULL, 0x040fe400078ec0ffULL, 0x0000000808087812ULL, 0x000fcc00078ec0ffULL,
0x000000016f0e8824ULL, 0x000fe400078e020eULL, 0x00000004ff0f8424ULL, 0x000fe200078e00ffULL,
0x0000000b08087210ULL, 0x000fe40007ffe010ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x000064000e0e8625ULL, 0x000fca00078e000fULL, 0x000000080e0c8981ULL, 0x000522000c1e1900ULL,
0x0000f6b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x00f6b000110e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6080008147f8cULL, 0x000664000c80043fULL, 0x0000000000107805ULL, 0x002fc40000015200ULL,
0x00f60c00080b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210127210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011413ULL,
0x000000120b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff127224ULL, 0x000fca00000e0613ULL,
0x000000020b0b7819ULL, 0x000fc80000001212ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f60c00080b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001041567824ULL, 0x000fe200078e00ffULL, 0x00000001ff6d7819ULL, 0x000fe20000011641ULL,
0x00000020000b7824ULL, 0x000fe400078e00ffULL, 0xffffffffff767424ULL, 0x000fe200078e00ffULL,
0x0000007056567812ULL, 0x000fc400078ec0ffULL, 0xffffff800b0b7812ULL, 0x000fe400078ec0ffULL,
0x0000000c6d6d7812ULL, 0x000fc800078ec0ffULL, 0x0000000b6d0b7210ULL, 0x000fca0007ffe056ULL,
0x00f000000b117984ULL, 0x000e680000000800ULL, 0x00f200000b107984ULL, 0x0006a20000000800ULL,
0x0000000a1100720bULL, 0x002fe20003f1d000ULL, 0x0000fbf27f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0b137812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x0000001fff787424ULL, 0x000fc400078e00ffULL, 0xffffffffff777424ULL, 0x000fce00078e00ffULL,
0x0000045000008947ULL, 0x000fea0003800000ULL, 0x000000007100720cULL, 0x000fe40003f05270ULL,
0x0000000a1100720bULL, 0x000fe20003f54000ULL, 0x0000fb927f007947ULL, 0x000fd8000b800000ULL,
0x0000000000127806ULL, 0x000fc400010e0100ULL, 0x0000008000148824ULL, 0x000fe200078e0256ULL,
0x0000000a11157209ULL, 0x000fe20007810000ULL, 0x0000036000017945ULL, 0x000fe20003800000ULL,
0x00009910120b7816ULL, 0x000fe200000000ffULL, 0x000000016d148824ULL, 0x000fca00078e0214ULL,
0x00f4001514008388ULL, 0x0003e20000000800ULL, 0x000000ff0b00720cULL, 0x000fda0003f05270ULL,
0x0000030000008947ULL, 0x000fea0003800000ULL, 0x800000150a0b7221ULL, 0x002fe20000010000ULL,
0x000000ff12ff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL, 0x0000000b00167308ULL, 0x000e640000000800ULL,
0x0000001609097220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0b7819ULL, 0x000fe20000011641ULL, 0x0000fac27f007947ULL, 0x000fea000b800000ULL,
0x00001f0b160b7589ULL, 0x0002e400000e0000ULL, 0x0000000b30307220ULL, 0x08cfe20000410000ULL,
0x0000000b31317220ULL, 0x080fe20000410000ULL, 0x0000000b2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000b2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000b28287220ULL, 0x080fe20000410000ULL,
0x0000000b29297220ULL, 0x080fe20000410000ULL, 0x0000000b38387220ULL, 0x080fe20000410000ULL,
0x0000000b39397220ULL, 0x080fe20000410000ULL, 0x0000000b34347220ULL, 0x080fe20000410000ULL,
0x0000000b35357220ULL, 0x080fe20000410000ULL, 0x0000000b1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000b1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000b18187220ULL, 0x080fe20000410000ULL,
0x0000000b19197220ULL, 0x080fe20000410000ULL, 0x0000000b20207220ULL, 0x080fe20000410000ULL,
0x0000000b21217220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0012ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008410b7811ULL, 0x000fe200078ff0ffULL, 0x0000f9a27f007947ULL, 0x000fea000b800000ULL,
0x00001f0b160b7589ULL, 0x00066400000e0000ULL, 0x0000000b32327220ULL, 0x086fe20000410000ULL,
0x0000000b33337220ULL, 0x080fe20000410000ULL, 0x0000000b2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000b2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000b2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000b2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000b3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000b3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000b36367220ULL, 0x080fe20000410000ULL,
0x0000000b37377220ULL, 0x080fe20000410000ULL, 0x0000000b1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000b1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000b1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000b1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000b22227220ULL, 0x080fe20000410000ULL,
0x0000000b23237220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff13ff7812ULL, 0x000fe20007806012ULL, 0x00000001ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000a110a7209ULL, 0x000fd60007810000ULL, 0x8000000a11110221ULL, 0x000fe20000010000ULL,
0x00007610ff0b0816ULL, 0x000fc6000000000bULL, 0x3fb8aa3b11110820ULL, 0x000fc80000410000ULL,
0x0000001100050308ULL, 0x000e640000000800ULL, 0x0000000510100220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000910097221ULL, 0x004fc40000010000ULL,
0x0000000000107805ULL, 0x000fca0000015200ULL, 0x0000000800127824ULL, 0x000fca00078e00ffULL,
0xfffffff012147812ULL, 0x000fca00078ec0ffULL, 0x00f6ac0014127984ULL, 0x000e640000000800ULL,
0x8000000012ff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x008fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x0000001210157210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e11ULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001512127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac0014127984ULL, 0x000e640000000800ULL, 0x8000000012ff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100b0b7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0b00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000005ff06723eULL, 0x000fe400000000ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011641ULL, 0x0000541006107816ULL, 0x000fe20000000006ULL,
0x0000f5527f007947ULL, 0x000fea000b800000ULL, 0x00001f0d10067589ULL, 0x0002a400000e0000ULL,
0x000000080d0b7810ULL, 0x000fe20007ffe0ffULL, 0x0000f5827f007947ULL, 0x000fea000b800000ULL,
0x00001f0b10077589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100d0b7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200078e0010ULL,
0x00002ec000157802ULL, 0x000fc40000000f00ULL, 0x0000ff6000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180d0b7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200078e0010ULL, 0x00002f1000157802ULL, 0x000fc40000000f00ULL,
0x0000ff1000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000002005f7824ULL, 0x040fe200078e00ffULL, 0x00000007410b7812ULL, 0x04cfe200078ec0ffULL,
0x00000200004b7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000841487812ULL, 0x000fc400078ec0ffULL, 0x000000045f107812ULL, 0x002fe400078ec0ffULL,
0x000000080b597812ULL, 0x000fe400078ef841ULL, 0x0000001041107211ULL, 0x000fe400078fe0ffULL,
0xfffff8004b4b7812ULL, 0x000fe200078ec0ffULL, 0x00000008590d7824ULL, 0x040fe400078e00ffULL,
0x0000000159707824ULL, 0x000fca00078e0210ULL, 0xfffffff80d6a7812ULL, 0x000fca00078ee270ULL,
0x000000106a6a7824ULL, 0x000fc800078e00ffULL, 0x000000016a507824ULL, 0x000fc400078e024bULL,
0x0000000400117824ULL, 0x000fe200078e00ffULL, 0x00000004ff647819ULL, 0x000fe40000011641ULL,
0x0000000b480d7212ULL, 0x040fe400078efcffULL, 0x0000000411117812ULL, 0x000fe400078ec0ffULL,
0x0000001048487812ULL, 0x000fe200078efe0bULL, 0x000000080d437824ULL, 0x000fe200078e00ffULL,
0x0000b0006b657811ULL, 0x000fe200078e68ffULL, 0x0000000164117824ULL, 0x000fe200078e0211ULL,
0xfffffff85f5f7812ULL, 0x000fe200078ec0ffULL, 0x00000008484a7824ULL, 0x000fc400078e00ffULL,
0x000000010d107824ULL, 0x000fe400078e0211ULL, 0x00000001114f7824ULL, 0x000fe400078e0248ULL,
0x000000080d127824ULL, 0x000fe200078e00ffULL, 0xfffffff843437812ULL, 0x000fe200078ee210ULL,
0x000000046b647824ULL, 0x000fe200078e0264ULL, 0xfffffff84a4a7812ULL, 0x000fe400078ee24fULL,
0x0000000210497810ULL, 0x000fe20007ffe0ffULL, 0x0000001043247824ULL, 0x000fe200078e0265ULL,
0x0000000264647810ULL, 0x000fe20007ffe059ULL, 0x000000104a3c7824ULL, 0x000fe200078e0265ULL,
0xfffffff812497812ULL, 0x000fc600078ee249ULL, 0x000000002424783bULL, 0x000e640000004200ULL,
0x0000001049107824ULL, 0x000fe400078e0265ULL, 0x000000003c3c783bULL, 0x000ea20000004200ULL,
0x0000010024117824ULL, 0x042fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fe20000011424ULL,
0x0001000024157824ULL, 0x040fe200078e00ffULL, 0x0000888024457816ULL, 0x000fe200000000ffULL,
0x0001000025177824ULL, 0x000fe200078e00ffULL, 0x00000018ff167819ULL, 0x004fc4000001143fULL,
0x00000018ff147819ULL, 0x000fe20000011411ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x00000018ff157819ULL, 0x000fe20000011415ULL, 0x000000001010783bULL, 0x000e620000004200ULL,
0x00000018ff177819ULL, 0x000fe40000011417ULL, 0x00000018ff477819ULL, 0x000fe40000011425ULL,
0x0000888025547816ULL, 0x000fe200000000ffULL, 0x00000016000d7306ULL, 0x0005e20000200c00ULL,
0x00000018ff537819ULL, 0x000fc40000011426ULL, 0x0000888026627816ULL, 0x000fe400000000ffULL,
0x0000888027587816ULL, 0x000fe400000000ffULL, 0x00000018ff447819ULL, 0x000fe2000001143dULL,
0x0000001400247306ULL, 0x0007e20000200c00ULL, 0x0000010025167824ULL, 0x004fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fe4000001143cULL, 0x000088803c557816ULL, 0x000fe400000000ffULL,
0x00000018ff167819ULL, 0x000fc40000011416ULL, 0x00000015004d7306ULL, 0x0005e20000200c00ULL,
0x0000010026147824ULL, 0x048fe200078e00ffULL, 0x00000018ff527819ULL, 0x000fe20000011427ULL,
0x0001000026267824ULL, 0x000fe200078e00ffULL, 0x00000018ff0b7819ULL, 0x000fe4000001143eULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x0000001600257306ULL, 0x000fe20000200c00ULL,
0x0000010027157824ULL, 0x044fe200078e00ffULL, 0x00000018ff267819ULL, 0x000fe20000011426ULL,
0x0001000027277824ULL, 0x000fc600078e00ffULL, 0x00000018ff617819ULL, 0x000fe40000011415ULL,
0x00000017005c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff277819ULL, 0x000fe40000011427ULL,
0x00000018ff5b7819ULL, 0x002fe40000011410ULL, 0x00000018ff5a7819ULL, 0x000fe40000011411ULL,
0x00000018ff4e7819ULL, 0x000fe20000011412ULL, 0x0000001400637306ULL, 0x0003e20000200c00ULL,
0x00000018ff517819ULL, 0x000fce0000011413ULL, 0x0000004500457306ULL, 0x000ea20000200c00ULL,
0x009000005014783bULL, 0x002e6e0000000200ULL, 0x0000005400547306ULL, 0x000ee20000200c00ULL,
0x0000541045247816ULL, 0x004fce0000000024ULL, 0x0000004700477306ULL, 0x000ea20000200c00ULL,
0x0000541054257816ULL, 0x008fce0000000025ULL, 0x00000026005e7306ULL, 0x0007e20000200c00ULL,
0x000088803d547816ULL, 0x000fce00000000ffULL, 0x0000006200627306ULL, 0x000ea20000200c00ULL,
0x000001003c267824ULL, 0x048fe400078e00ffULL, 0x000100003c3c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff267819ULL, 0x000fe20000011426ULL, 0x0000000614148232ULL, 0x082fe20000000000ULL,
0x0000005800587306ULL, 0x000fe20000200c00ULL, 0x0000000616168232ULL, 0x000fe20000000000ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000000715158232ULL, 0x080fe40000000000ULL,
0x0000000717178232ULL, 0x000fc60000000000ULL, 0x0000006100617306ULL, 0x000e680000200c00ULL,
0x000000241430723cULL, 0x000b680000001830ULL, 0x0000003c005d7306ULL, 0x0007e60000200c00ULL,
0x000001003d247824ULL, 0x020fc400078e00ffULL, 0x000100003d3d7824ULL, 0x000fe400078e00ffULL,
0x0000000848257824ULL, 0x000fe200078e00ffULL, 0x000000024f487810ULL, 0x000fe20007ffe0ffULL,
0x0000005300537306ULL, 0x000e620000200c00ULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x000088803e3c7816ULL, 0x008fe400000000ffULL, 0xfffffff825487812ULL, 0x000fe400078ee248ULL,
0x000054105c257816ULL, 0x004fe20000000047ULL, 0x0000003d00577306ULL, 0x0005e20000200c00ULL,
0x00000018ff247819ULL, 0x000fce0000011424ULL, 0x0000005200527306ULL, 0x000fe20000200c00ULL,
0x000001003f3d7824ULL, 0x004fca00078e00ffULL, 0x00000018ff3d7819ULL, 0x000fe4000001143dULL,
0x0000002700607306ULL, 0x000eb00000200c00ULL, 0x0000003c00477306ULL, 0x0007f00000200c00ULL,
0x0000003d004f7306ULL, 0x0003e20000200c00ULL, 0x00005410623c7816ULL, 0x008fe20000000063ULL,
0x0000000859637824ULL, 0x000fc400078e00ffULL, 0x0001000012597824ULL, 0x000fc600078e00ffULL,
0xfffffff863647812ULL, 0x000fe200078ee264ULL, 0x0000005500457306ULL, 0x000fe20000200c00ULL,
0x00005410583d7816ULL, 0x002fe40000000061ULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x00000010644b7824ULL, 0x000fc800078e024bULL, 0x0000002400557306ULL, 0x0003e20000200c00ULL,
0x0000003c1428723cULL, 0x000bee0000001828ULL, 0x00008880103d7816ULL, 0x020fe200000000ffULL,
0x0000002600467306ULL, 0x0007e20000200c00ULL, 0x000054104d247816ULL, 0x002fe2000000004cULL,
0x000001003e4c7824ULL, 0x000fe200078e00ffULL, 0x000054105e3c7816ULL, 0x000fe20000000053ULL,
0x000100003e3e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff4d7819ULL, 0x000fe2000001144cULL,
0x0000003d00537306ULL, 0x0005e20000200c00ULL, 0x000088803f4c7816ULL, 0x040fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000024142c723cULL, 0x040b62000000182cULL,
0x0000001048267824ULL, 0x008fe200078e0265ULL, 0x00000018ff5c7819ULL, 0x000fe4000001143eULL,
0x00000018ff627819ULL, 0x000fe2000001143fULL, 0x00000100103f7824ULL, 0x000fe200078e00ffULL,
0x00005410603d7816ULL, 0x004fe20000000052ULL, 0x0001000010107824ULL, 0x000fe200078e00ffULL,
0x0000888011607816ULL, 0x040fe200000000ffULL, 0x000000002624783bULL, 0x020e620000004200ULL,
0x00000018ff5e7819ULL, 0x000fe2000001143fULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000003c1438723cULL, 0x000b6c0000001838ULL,
0x0000005e00527306ULL, 0x0004e20000200c00ULL, 0x00000100113c7824ULL, 0x020fc400078e00ffULL,
0x0001000011117824ULL, 0x000fc600078e00ffULL, 0x00000018ff617819ULL, 0x000fe4000001143cULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x00000018ff117819ULL, 0x000fe20000011411ULL,
0x00000100135e7824ULL, 0x004fcc00078e00ffULL, 0x0000006100617306ULL, 0x000ea20000200c00ULL,
0x0000541053527816ULL, 0x008fce0000000052ULL, 0x0000005a005a7306ULL, 0x000fe20000200c00ULL,
0x00000018ff3e7819ULL, 0x002fe40000011424ULL, 0x0000541060537816ULL, 0x004fca0000000061ULL,
0x0000001000107306ULL, 0x000e620000200c00ULL, 0x0000888012617816ULL, 0x040fe400000000ffULL,
0x00000018ff3f7819ULL, 0x000fe40000011425ULL, 0x00000018ff3d7819ULL, 0x000fe20000011427ULL,
0x000000521434723cULL, 0x000be20000001834ULL, 0x00000018ff3c7819ULL, 0x000fe20000011426ULL,
0x0000001100117306ULL, 0x000eaa0000200c00ULL, 0x0000010012527824ULL, 0x020fe200078e00ffULL,
0x0000888013537816ULL, 0x040fe200000000ffULL, 0x0001000013137824ULL, 0x000fe200078e00ffULL,
0x0000006200587306ULL, 0x0007e20000200c00ULL, 0x0000541010107816ULL, 0x002fc4000000005bULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x00000018ff607819ULL, 0x000fe40000011413ULL,
0x00008880245b7816ULL, 0x040fe200000000ffULL, 0x0000005300537306ULL, 0x000fe20000200c00ULL,
0x00000018ff627819ULL, 0x008fe4000001145eULL, 0x0000541011117816ULL, 0x004fe2000000005aULL,
0x00000100245a7824ULL, 0x040fe400078e00ffULL, 0x0001000024247824ULL, 0x000fc400078e00ffULL,
0x0000006200127306ULL, 0x000e620000200c00ULL, 0x00000018ff5a7819ULL, 0x000fe2000001145aULL,
0x00000010141c723cULL, 0x000b62000000181cULL, 0x00000018ff247819ULL, 0x000fca0000011424ULL,
0x0000006100617306ULL, 0x000ff00000200c00ULL, 0x0000005200527306ULL, 0x000ea20000200c00ULL,
0x0000541053537816ULL, 0x002fe40000000012ULL, 0x009000004b10783bULL, 0x020e6a0000000200ULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x0000541061527816ULL, 0x004fce0000000052ULL,
0x00000059005e7306ULL, 0x000ea20000200c00ULL, 0x000000521418723cULL, 0x000b6e0000001818ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x0000888025537816ULL, 0x060fe200000000ffULL,
0x0000010025527824ULL, 0x000fcc00078e00ffULL, 0x0000006000607306ULL, 0x000ee20000200c00ULL,
0x0001000025257824ULL, 0x000fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fc80000011452ULL,
0x00000018ff257819ULL, 0x000fe40000011425ULL, 0x0000002400527306ULL, 0x0005e20000200c00ULL,
0x0000000610108232ULL, 0x082fe40000000000ULL, 0x0000000612128232ULL, 0x000fe40000000000ULL,
0x0000000711118232ULL, 0x000fc60000000000ULL, 0x0000005400547306ULL, 0x000e620000200c00ULL,
0x000054105e247816ULL, 0x004fe2000000004eULL, 0x0000000713138232ULL, 0x000fe20000000000ULL,
0x00008880265e7816ULL, 0x000fca00000000ffULL, 0x00000025004e7306ULL, 0x0007f00000200c00ULL,
0x0000004200427306ULL, 0x000ea20000200c00ULL, 0x0000541060257816ULL, 0x008fe20000000051ULL,
0x000000ffff517224ULL, 0x000fcc00078e005eULL, 0x000000241414723cULL, 0x000b620000001820ULL,
0x0000004400447306ULL, 0x000eec0000200c00ULL, 0x0000010026207824ULL, 0x020fe200078e00ffULL,
0x0000888027227816ULL, 0x000fe200000000ffULL, 0x0000004d004d7306ULL, 0x000ea20000200c00ULL,
0x0000541054217816ULL, 0x002fe20000000055ULL, 0x0001000026267824ULL, 0x000fe200078e00ffULL,
0x00000018ff207819ULL, 0x000fc40000011420ULL, 0x0000541058257816ULL, 0x000fc6000000000dULL,
0x00000020005e7306ULL, 0x0003f00000200c00ULL, 0x0000004c004c7306ULL, 0x000ee20000200c00ULL,
0x0000541045207816ULL, 0x002fe20000000046ULL, 0x000000ffff457224ULL, 0x000fc400078e0022ULL,
0x0000010027227824ULL, 0x040fe400078e00ffULL, 0x0001000027277824ULL, 0x000fe400078e00ffULL,
0x000000201030723cULL, 0x000b620000001830ULL, 0x00000018ff227819ULL, 0x000fe20000011422ULL,
0x0000005b00597306ULL, 0x000fe20000200c00ULL, 0x00000018ff467819ULL, 0x000fc80000011427ULL,
0x000054105d207816ULL, 0x024fe40000000042ULL, 0x0000541057217816ULL, 0x008fe20000000044ULL,
0x0000000b000b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff447819ULL, 0x000fca0000011426ULL,
0x00000020102c723cULL, 0x040b64000000182cULL, 0x0000005c005c7306ULL, 0x000e6a0000200c00ULL,
0x0000541047207816ULL, 0x020fe4000000004dULL, 0x000054104c217816ULL, 0x000fe2000000004fULL,
0x0000003e003e7306ULL, 0x000eac0000200c00ULL, 0x000000201028723cULL, 0x000f640000001828ULL,
0x0000003f003f7306ULL, 0x000ee20000200c00ULL, 0x000054105c247816ULL, 0x002fce000000000bULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x00005410523e7816ULL, 0x004fe2000000003eULL,
0x000000241024723cULL, 0x000f6c0000001838ULL, 0x0000005300537306ULL, 0x000fe20000200c00ULL,
0x000054104e3f7816ULL, 0x008fce000000003fULL, 0x00000061005b7306ULL, 0x000ea20000200c00ULL,
0x00005410595a7816ULL, 0x002fe2000000005aULL, 0x0000003e101c723cULL, 0x000f6c000000181cULL,
0x0000005100517306ULL, 0x000ff00000200c00ULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x00005410535b7816ULL, 0x004fce000000005bULL, 0x0000002200427306ULL, 0x0002b00000200c00ULL,
0x0000003c003c7306ULL, 0x000fe20000200c00ULL, 0x0000005a1020723cULL, 0x002f6e0000001834ULL,
0x0000003d003d7306ULL, 0x000fe20000200c00ULL, 0x0000541045457816ULL, 0x004fce0000000042ULL,
0x0000004400477306ULL, 0x0002b00000200c00ULL, 0x0000004600467306ULL, 0x000ee20000200c00ULL,
0x0000541051447816ULL, 0x002fe4000000005eULL, 0x00005410473c7816ULL, 0x004fca000000003cULL,
0x000000441018723cULL, 0x000f620000001818ULL, 0x00005410463d7816ULL, 0x008fce000000003dULL,
0x0000003c1010723cULL, 0x000b6e0000001814ULL, 0x0000f6c86b147811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x0000000014147f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f688005fff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff0b7224ULL, 0x000fc600078e00ffULL, 0x0000000000167805ULL, 0x000fc80000015200ULL,
0x00000400040d7984ULL, 0x000ee40000000800ULL, 0x800000000dff7812ULL, 0x00afc40007804815ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100b00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000347805ULL, 0x000fcc0000015200ULL,
0x0000003416347210ULL, 0x000fca0007f1e1ffULL, 0x0000000135357824ULL, 0x000fe200000e0e17ULL,
0x003d09003400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0d7819ULL, 0x000fc80000011435ULL, 0x000000340d0d7211ULL, 0x000fca00078110ffULL,
0x000000ffff347224ULL, 0x000fca00000e0635ULL, 0x000000020d0d7819ULL, 0x000fc80000001234ULL,
0x0000000d0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00000400040d7984ULL, 0x000e640000000800ULL, 0x800000000dff7812ULL, 0x002fe40007804815ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001000157824ULL, 0x000fca00078e00ffULL,
0xffffffe0150b7812ULL, 0x000fca00078ec0ffULL, 0x00000100400b7824ULL, 0x000fca00078e020bULL,
0x000000800b147810ULL, 0x000fe20007ffe0ffULL, 0x000059000c0b7a24ULL, 0x010fc600078e02ffULL,
0x00000020140d7812ULL, 0x000fe200078ec0ffULL, 0x000000400b0b7824ULL, 0x000fc800078e00ffULL,
0x000000016e0d7824ULL, 0x000fe200078e020dULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x00000014670c7217ULL, 0x000fe40007800000ULL, 0x0000001015157812ULL, 0x000fe400078ec0ffULL,
0x00000003ff167819ULL, 0x000fe20000011641ULL, 0x000000010c0c7824ULL, 0x000fe200078e0a14ULL,
0x000062000b377a11ULL, 0x000fe400078a38ffULL, 0x0000000416347810ULL, 0x040fe20007ffe0ffULL,
0x0000000116147824ULL, 0x000fe200078e0215ULL, 0x0000000c150c7217ULL, 0x000fc40007800000ULL,
0x0000000c16357810ULL, 0x000fe20007ffe0ffULL, 0x0000000114177824ULL, 0x040fe200078e0241ULL,
0x000063000b397a11ULL, 0x000fe200028f3cffULL, 0x0000000814367824ULL, 0x000fe400078e00ffULL,
0x000000010c0c7824ULL, 0x100fe400078e0a15ULL, 0x00000001353c7824ULL, 0x000fe200078e0215ULL,
0xfffffff836367812ULL, 0x000fe200078ee217ULL, 0x0000000114147824ULL, 0x000fe200078e020dULL,
0x0000000816177810ULL, 0x000fe20007ffe0ffULL, 0x000000013c0b7824ULL, 0x000fe200078e0241ULL,
0x0000000c1600720cULL, 0x080fe20003f86070ULL, 0x0000000134167824ULL, 0x140fe200078e0215ULL,
0x0000000c3400720cULL, 0x080fe20003f66070ULL, 0x0000000117347824ULL, 0x040fe200078e0215ULL,
0x0000000c1700720cULL, 0x080fe20003f46070ULL, 0x0000000116157824ULL, 0x040fe200078e0241ULL,
0x0000000c3500720cULL, 0x000fe20003f06070ULL, 0x0000000816387824ULL, 0x000fc400078e00ffULL,
0x00000001340c7824ULL, 0x040fe400078e0241ULL, 0x0000000834177824ULL, 0x000fe200078e00ffULL,
0xfffffff838387812ULL, 0x000fe200078ee215ULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff8173a7812ULL, 0x000fe200078ee20cULL, 0x0000000116167824ULL, 0x100fe200078e020dULL,
0x0000005614147212ULL, 0x000fe200078efcffULL, 0x0000000134347824ULL, 0x000fe400078e020dULL,
0x0000008016167825ULL, 0x000fe200078e00ffULL, 0x0000001437147210ULL, 0x000fc60007fbe0ffULL,
0x000000013c0c7824ULL, 0x000fe200078e020dULL, 0x0000005616167212ULL, 0x000fe200078efcffULL,
0x0000008034347825ULL, 0x000fc800078e00ffULL, 0x000000800c0c7825ULL, 0x000fe200078e00ffULL,
0x0000005634347212ULL, 0x000fc600078efcffULL, 0x0000000115157824ULL, 0x000fe200028e0639ULL,
0x0000003716167210ULL, 0x000fe20007fbe0ffULL, 0x000000083c3c7824ULL, 0x000fe200078e00ffULL,
0x000000560c0c7212ULL, 0x000fc600078efcffULL, 0x0000000117177824ULL, 0x000fe200028e0639ULL,
0x0000003734347210ULL, 0x080fe40007fbe0ffULL, 0x000000370c0c7210ULL, 0x000fe20007fde0ffULL,
0x0000001038377824ULL, 0x000fe200078e0265ULL, 0xfffffff83c3c7812ULL, 0x000fe200078ee20bULL,
0x00000010360b7824ULL, 0x000fe400078e0265ULL, 0x0000000135357824ULL, 0x100fe400028e0639ULL,
0x000000010d0d7824ULL, 0x000fe200030e0639ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000140b7faeULL, 0x0003e2000e101c48ULL, 0x000000103a397824ULL, 0x000fc400078e0265ULL,
0x000000103c3b7824ULL, 0x000fe200078e0265ULL, 0x0000000016377faeULL, 0x0003e8000d901c48ULL,
0x0000000034397faeULL, 0x0003e8000d101c48ULL, 0x000000000c3b7faeULL, 0x0003e2000c101c48ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x00000010150c7812ULL, 0x000fe400078ec0ffULL,
0x000062000b377a11ULL, 0x000fc400078038ffULL, 0x0000000c410c7211ULL, 0x000fe400078fe8ffULL,
0x000063000b397a11ULL, 0x000fe400000f3cffULL, 0x000000040c167810ULL, 0x040fe20007ffe0ffULL,
0x000000010c157824ULL, 0x040fe200078e0241ULL, 0x000000080c387810ULL, 0x040fe20007ffe0ffULL,
0x000000080c367824ULL, 0x040fe200078e00ffULL, 0x0000000c0c3a7810ULL, 0x000fe20007ffe0ffULL,
0x00000008163c7824ULL, 0x000fe400078e00ffULL, 0x000000010c147824ULL, 0x000fe200078e020dULL,
0xfffffff836367812ULL, 0x000fe200078ee215ULL, 0x0000000116157824ULL, 0x000fc400078e0241ULL,
0x0000000116347824ULL, 0x100fe400078e020dULL, 0x0000000138167824ULL, 0x100fe400078e020dULL,
0x000000013a0c7824ULL, 0x000fe400078e020dULL, 0x00000001380d7824ULL, 0x040fe400078e0241ULL,
0x00000008383e7824ULL, 0x000fe200078e00ffULL, 0xfffffff83c387812ULL, 0x000fe200078ee215ULL,
0x000000013a177824ULL, 0x000fc400078e0241ULL, 0x000000083a427824ULL, 0x000fe200078e00ffULL,
0xfffffff83e3a7812ULL, 0x000fe200078ee20dULL, 0x0000008014147825ULL, 0x000fc600078e00ffULL,
0xfffffff8423c7812ULL, 0x000fe200078ee217ULL, 0x0000008034347825ULL, 0x000fe200078e00ffULL,
0x0000005614147212ULL, 0x000fc600078efcffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000001437147210ULL, 0x040fe40007f1e0ffULL, 0x0000005634347212ULL, 0x080fe200078efcffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x0000005616167212ULL, 0x000fe400078efcffULL,
0x0000003437347210ULL, 0x000fe20007f5e0ffULL, 0x0000000115157824ULL, 0x000fe200000e0639ULL,
0x000000560c0c7212ULL, 0x000fe200078efcffULL, 0x00000010360b7824ULL, 0x000fe200078e0265ULL,
0x0000001637167210ULL, 0x000fe20007f1e0ffULL, 0x0000000135357824ULL, 0x000fe200010e0639ULL,
0x0000000c370c7210ULL, 0x000fe20007f7e0ffULL, 0x0000001038377824ULL, 0x000fe200078e0265ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000140b7faeULL, 0x0003e2000b901c48ULL,
0x0000000117177824ULL, 0x000fc400000e0639ULL, 0x000000010d0d7824ULL, 0x000fe200018e0639ULL,
0x0000000034377faeULL, 0x0003e2000b901c48ULL, 0x000000103a397824ULL, 0x100fe400078e0265ULL,
0x000000103c3b7824ULL, 0x000fc600078e0265ULL, 0x0000000016397faeULL, 0x0003e8000b901c48ULL,
0x000000000c3b7faeULL, 0x0003e4000b901c48ULL, 0x00000008000b7824ULL, 0x002fe200078e00ffULL,
0x00000002020c7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff427424ULL, 0x000fc600078e00ffULL,
0xfffffff00b0b7812ULL, 0x000fe400078ec0ffULL, 0x000000680c00720cULL, 0x000fe40003f06070ULL,
0x000000000b0473c2ULL, 0x000e6200000e0000ULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000000016f0c8824ULL, 0x000fc400078e020cULL, 0x00000004ff0d8424ULL, 0x000fc800078e00ffULL,
0x000064000c0c8625ULL, 0x000fca00078e000dULL, 0x000000080c428981ULL, 0x000722000c1e1900ULL,
0x0000f6a804047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x008fec0000008000ULL,
0x00f6a8000b0c7f8cULL, 0x0002e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6280008147f8cULL, 0x0002a4000c80043fULL, 0x0000000000167805ULL, 0x000fc40000015200ULL,
0x00f62c00080b7984ULL, 0x002e640000000800ULL, 0x800000000bff7812ULL, 0x006fe40007804815ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff367224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000103600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000347805ULL, 0x000fcc0000015200ULL, 0x0000003416347210ULL, 0x000fca0007f1e1ffULL,
0x0000000135357824ULL, 0x000fe200000e0e17ULL, 0x003d09003400780cULL, 0x000fc80003f06070ULL,
0x000000ff3500720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c403400780cULL, 0x000fc80003f06070ULL, 0x000000ff3500720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0b7819ULL, 0x000fc80000011435ULL,
0x000000340b0b7211ULL, 0x000fca00078110ffULL, 0x000000ffff347224ULL, 0x000fca00000e0635ULL,
0x000000020b0b7819ULL, 0x000fc80000001234ULL, 0x0000000b0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000136367810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f62c00080b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804815ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000020000b7824ULL, 0x000fca00078e00ffULL, 0xffffff800b0b7812ULL, 0x000fc800078ec0ffULL,
0x0000008056147810ULL, 0x000fca0007ffe00bULL, 0x000000016d147824ULL, 0x000fca00078e0214ULL,
0x00f0000014177984ULL, 0x000e680000000800ULL, 0x00f2000014167984ULL, 0x0004e20000000800ULL,
0x0000000a1700720bULL, 0x002fe20003f1d000ULL, 0x0000d5727f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x004fc800000e0100ULL, 0x0000ffff0b357812ULL, 0x000fe2000780c0ffULL,
0x000004a000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0b7424ULL, 0x000fd600078e00ffULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000001710b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000a1700720bULL, 0x000fe40003f54000ULL, 0x000000000b00720cULL, 0x000fe20003f05270ULL,
0x0000d5227f007947ULL, 0x000fd4000b800000ULL, 0x0000000000347806ULL, 0x000fc400010e0100ULL,
0x0000008000148824ULL, 0x000fe200078e0256ULL, 0x0000000a170b8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe40003800000ULL, 0x000000016d368824ULL, 0x000fe200078e0214ULL,
0x0000991034147816ULL, 0x000fc800000000ffULL, 0x00f4000b36008388ULL, 0x0003e20000000800ULL,
0x000000ff1400720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000a170b7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff34ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000a0b0b7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL, 0x0000000b00367308ULL, 0x000e640000000800ULL,
0x0000003609097220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0b7819ULL, 0x000fe20000011641ULL, 0x0000d4427f007947ULL, 0x000fea000b800000ULL,
0x00001f0b360b7589ULL, 0x0002a400000e0000ULL, 0x0000000b30307220ULL, 0x084fe20000410000ULL,
0x0000000b31317220ULL, 0x080fe20000410000ULL, 0x0000000b2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000b2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000b28287220ULL, 0x080fe20000410000ULL,
0x0000000b29297220ULL, 0x080fe20000410000ULL, 0x0000000b24247220ULL, 0x080fe20000410000ULL,
0x0000000b25257220ULL, 0x080fe20000410000ULL, 0x0000000b20207220ULL, 0x080fe20000410000ULL,
0x0000000b21217220ULL, 0x080fe20000410000ULL, 0x0000000b1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000b1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000b18187220ULL, 0x080fe20000410000ULL,
0x0000000b19197220ULL, 0x080fe20000410000ULL, 0x0000000b10107220ULL, 0x080fe20000410000ULL,
0x0000000b11117220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0034ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008410b7811ULL, 0x000fe200078ff0ffULL, 0x0000d3227f007947ULL, 0x000fea000b800000ULL,
0x00001f0b360b7589ULL, 0x00046400000e0000ULL, 0x0000000b32327220ULL, 0x086fe20000410000ULL,
0x0000000b33337220ULL, 0x080fe20000410000ULL, 0x0000000b2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000b2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000b2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000b2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000b26267220ULL, 0x080fe20000410000ULL,
0x0000000b27277220ULL, 0x080fe20000410000ULL, 0x0000000b22227220ULL, 0x080fe20000410000ULL,
0x0000000b23237220ULL, 0x080fe20000410000ULL, 0x0000000b1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000b1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000b1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000b1b1b7220ULL, 0x080fe20000410000ULL, 0x0000000b12127220ULL, 0x080fe20000410000ULL,
0x0000000b13137220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff35ff7812ULL, 0x000fe20007806034ULL, 0x00000001ff0b7424ULL, 0x000fe200078e00ffULL,
0x0000000a170a7209ULL, 0x000fd60007810000ULL, 0x8000000a17170221ULL, 0x000fe20000010000ULL,
0x00007610ff0b0816ULL, 0x000fc6000000000bULL, 0x3fb8aa3b17170820ULL, 0x000fc80000410000ULL,
0x0000001700050308ULL, 0x000e640000000800ULL, 0x0000000516160220ULL, 0x00afcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000916097221ULL, 0x008fc20000010000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x0000000800167824ULL, 0x000fca00078e00ffULL,
0xfffffff016347812ULL, 0x000fca00078ec0ffULL, 0x00f6b40034177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff367224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000103600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614357210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09003500780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c403500780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff167819ULL, 0x000fc80000011417ULL, 0x0000003516167211ULL, 0x000fca00078110ffULL,
0x000000ffff177224ULL, 0x000fca00000e0617ULL, 0x0000000216167819ULL, 0x000fc80000001217ULL,
0x000000160000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000136367810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6b40034177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe4000780480fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099100b0b7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0b00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000005ff06723eULL, 0x000fe400000000ffULL,
0x00000002ff0f7819ULL, 0x000fe40000011641ULL, 0x00005410060e7816ULL, 0x000fe20000000006ULL,
0x0000ced27f007947ULL, 0x000fea000b800000ULL, 0x00001f0f0e067589ULL, 0x0002a400000e0000ULL,
0x000000080f0b7810ULL, 0x000fe20007ffe0ffULL, 0x0000cf027f007947ULL, 0x000fea000b800000ULL,
0x00001f0b0e077589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100f0b7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200078e000eULL,
0x0000570000157802ULL, 0x000fc40000000f00ULL, 0x0000d72000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180f0b7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200078e000eULL, 0x0000575000157802ULL, 0x000fc40000000f00ULL,
0x0000d6d000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0xffffffff00007948ULL, 0x000fe40003800000ULL, 0x0000100065517810ULL, 0x000fe20007ffe0ffULL,
0x009800005034783bULL, 0x000ee80000000200ULL, 0x0000001043587824ULL, 0x000fc400078e0251ULL,
0x0000001048147824ULL, 0x100fe400078e0251ULL, 0x00000010493c7824ULL, 0x100fe200078e0251ULL,
0x000000005844783bULL, 0x000ea20000004200ULL, 0x000000104a527824ULL, 0x000fc600078e0251ULL,
0x000000001414783bULL, 0x000e680000004200ULL, 0x000000003c3c783bULL, 0x000e680000004200ULL,
0x000000005238783bULL, 0x000e620000004200ULL, 0x0000000634348232ULL, 0x08cfe40000000000ULL,
0x0000000636368232ULL, 0x000fc40000000000ULL, 0x0000000735358232ULL, 0x082fe40000000000ULL,
0x0000000737378232ULL, 0x000fe20000000000ULL, 0x00000100444c7824ULL, 0x040fe200078e00ffULL,
0x0000888045557816ULL, 0x040fe400000000ffULL, 0x00008880440f7816ULL, 0x000fe400000000ffULL,
0x00000018ff4d7819ULL, 0x000fe2000001144cULL, 0x00000100454c7824ULL, 0x000fe200078e00ffULL,
0x0000005500557306ULL, 0x000fe20000200c00ULL, 0x00000018ff5f7819ULL, 0x000fc40000011444ULL,
0x00000018ff5e7819ULL, 0x000fe20000011445ULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001144cULL, 0x00000018ff5c7819ULL, 0x000fe20000011446ULL,
0x0000000f00547306ULL, 0x000fe20000200c00ULL, 0x00000018ff457819ULL, 0x000fe40000011445ULL,
0x00000018ff5b7819ULL, 0x000fe40000011447ULL, 0x00000018ff617819ULL, 0x000fc40000011417ULL,
0x0000888047637816ULL, 0x000fe200000000ffULL, 0x0000005d00607306ULL, 0x0002a20000200c00ULL,
0x00000018ff5a7819ULL, 0x000fe4000001143cULL, 0x00000018ff597819ULL, 0x000fe4000001143dULL,
0x00000018ff537819ULL, 0x000fe4000001143eULL, 0x00000018ff577819ULL, 0x000fe2000001143fULL,
0x0000004d004d7306ULL, 0x000ee20000200c00ULL, 0x00010000445d7824ULL, 0x002fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fc40000011438ULL, 0x00000018ff4f7819ULL, 0x000fe40000011439ULL,
0x00000018ff0b7819ULL, 0x000fe4000001143aULL, 0x0000541055557816ULL, 0x004fe20000000060ULL,
0x0000005f005f7306ULL, 0x000fe20000200c00ULL, 0x00000018ff607819ULL, 0x000fe4000001145dULL,
0x00008880465d7816ULL, 0x000fe400000000ffULL, 0x00000018ff0e7819ULL, 0x000fc4000001143bULL,
0x0000541054547816ULL, 0x008fe2000000004dULL, 0x0000006000607306ULL, 0x000e620000200c00ULL,
0x00000018ff4c7819ULL, 0x000fe40000011414ULL, 0x00000018ff0f7819ULL, 0x000fe40000011415ULL,
0x00000018ff4d7819ULL, 0x000fe20000011416ULL, 0x000000543430723cULL, 0x000be40000001830ULL,
0x0000005e005e7306ULL, 0x000fea0000200c00ULL, 0x0000010046547824ULL, 0x020fc400078e00ffULL,
0x0001000046467824ULL, 0x000fe200078e00ffULL, 0x0000004500557306ULL, 0x0004e40000200c00ULL,
0x00000018ff547819ULL, 0x000fcc0000011454ULL, 0x0000005400627306ULL, 0x0003e20000200c00ULL,
0x00000018ff457819ULL, 0x004fe20000011446ULL, 0x000001003c467824ULL, 0x000fca00078e00ffULL,
0x00000018ff467819ULL, 0x000fe20000011446ULL, 0x0000006100447306ULL, 0x000fe20000200c00ULL,
0x0000541060547816ULL, 0x002fe2000000005fULL, 0x00000100475f7824ULL, 0x000fe200078e00ffULL,
0x0000541055557816ULL, 0x008fe2000000005eULL, 0x0001000047477824ULL, 0x000fe200078e00ffULL,
0x000088803c5e7816ULL, 0x040fe200000000ffULL, 0x000100003c3c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5f7819ULL, 0x000fe2000001145fULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff477819ULL, 0x000fe20000011447ULL, 0x00000054342c723cULL, 0x000be2000000182cULL,
0x00000018ff3c7819ULL, 0x000fca000001143cULL, 0x0000006300607306ULL, 0x000fe20000200c00ULL,
0x000088803d557816ULL, 0x060fe200000000ffULL, 0x000001003d547824ULL, 0x040fe400078e00ffULL,
0x000100003d3d7824ULL, 0x000fc800078e00ffULL, 0x0000005f00617306ULL, 0x000e620000200c00ULL,
0x00000018ff3d7819ULL, 0x000fce000001143dULL, 0x0000005c005c7306ULL, 0x000ff00000200c00ULL,
0x0000005b005b7306ULL, 0x000ff00000200c00ULL, 0x0000004500457306ULL, 0x000ff00000200c00ULL,
0x0000004700667306ULL, 0x0002b00000200c00ULL, 0x00000046005f7306ULL, 0x0007e20000200c00ULL,
0x0000541060477816ULL, 0x002fc40000000061ULL, 0x000088803e617816ULL, 0x000fe400000000ffULL,
0x000088803f607816ULL, 0x000fc600000000ffULL, 0x0000003d00647306ULL, 0x0005e20000200c00ULL,
0x000054105d467816ULL, 0x008fe40000000062ULL, 0x00000018ff5d7819ULL, 0x000fca0000011454ULL,
0x0000003c00547306ULL, 0x0003e20000200c00ULL, 0x00005410663d7816ULL, 0x004fe2000000005bULL,
0x000000463428723cULL, 0x000b620000001828ULL, 0x00000100395b7824ULL, 0x000fca00078e00ffULL,
0x0000005e005e7306ULL, 0x000fe20000200c00ULL, 0x00005410453c7816ULL, 0x002fe2000000005cULL,
0x000001003f457824ULL, 0x040fe200078e00ffULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x000001003e467824ULL, 0x060fe400078e00ffULL, 0x000100003e3e7824ULL, 0x000fe200078e00ffULL,
0x00000018ff637819ULL, 0x000fe20000011445ULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x0000003c3424723cULL, 0x000be20000001824ULL, 0x000100003f3f7824ULL, 0x000fe200078e00ffULL,
0x0000888038457816ULL, 0x000fc400000000ffULL, 0x00000018ff467819ULL, 0x000fe40000011446ULL,
0x00000018ff3e7819ULL, 0x000fe2000001143eULL, 0x0000005d005d7306ULL, 0x000e620000200c00ULL,
0x00000100383c7824ULL, 0x060fe200078e00ffULL, 0x00000018ff3f7819ULL, 0x000fe2000001143fULL,
0x0001000038387824ULL, 0x000fc600078e00ffULL, 0x00000018ff3c7819ULL, 0x000fe4000001143cULL,
0x0000006100617306ULL, 0x000fe20000200c00ULL, 0x00000018ff387819ULL, 0x000fce0000011438ULL,
0x0000004600627306ULL, 0x000fe20000200c00ULL, 0x00005410553d7816ULL, 0x002fce000000005dULL,
0x0000006000607306ULL, 0x000ff00000200c00ULL, 0x0000006300637306ULL, 0x000ff00000200c00ULL,
0x0000005a005a7306ULL, 0x000e700000200c00ULL, 0x0000003e00467306ULL, 0x000ff00000200c00ULL,
0x0000003f00477306ULL, 0x0005e20000200c00ULL, 0x00005410545a7816ULL, 0x002fce000000005aULL,
0x0000005900597306ULL, 0x000e620000200c00ULL, 0x00008880393f7816ULL, 0x044fe200000000ffULL,
0x0001000039397824ULL, 0x000fca00078e00ffULL, 0x00000018ff397819ULL, 0x000fe20000011439ULL,
0x00000038003e7306ULL, 0x0005f00000200c00ULL, 0x0000003c005c7306ULL, 0x0007e20000200c00ULL,
0x000001003a387824ULL, 0x004fca00078e00ffULL, 0x00000018ff387819ULL, 0x000fe40000011438ULL,
0x0000003f00557306ULL, 0x0005e20000200c00ULL, 0x000054105e3c7816ULL, 0x008fce000000005fULL,
0x0000003c3420723cULL, 0x000b620000001820ULL, 0x0000005b005e7306ULL, 0x0007e20000200c00ULL,
0x000001003b3f7824ULL, 0x004fca00078e00ffULL, 0x000088803a3c7816ULL, 0x060fe200000000ffULL,
0x000100003a3a7824ULL, 0x000fe200078e00ffULL, 0x00000039005f7306ULL, 0x0005e20000200c00ULL,
0x000088803b5b7816ULL, 0x048fe200000000ffULL, 0x000100003b3b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff5d7819ULL, 0x000fe4000001143fULL, 0x00000018ff3f7819ULL, 0x000fc6000001143aULL,
0x00000038003d7306ULL, 0x0007e20000200c00ULL, 0x0000541060397816ULL, 0x004fe40000000063ULL,
0x0000888015607816ULL, 0x000fca00000000ffULL, 0x0000005b00547306ULL, 0x0003e20000200c00ULL,
0x0000541061387816ULL, 0x008fce0000000062ULL, 0x0000005300537306ULL, 0x000ea20000200c00ULL,
0x00005410645b7816ULL, 0x002fe40000000059ULL, 0x00000018ff597819ULL, 0x000fe4000001143bULL,
0x000000383438723cULL, 0x040be40000001818ULL, 0x009800004b18783bULL, 0x020e620000000200ULL,
0x0000005700577306ULL, 0x000eea0000200c00ULL, 0x0000005a341c723cULL, 0x000b66000000181cULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000541046467816ULL, 0x004fe20000000053ULL,
0x0000010015537824ULL, 0x000fc400078e00ffULL, 0x00008880145a7816ULL, 0x060fe200000000ffULL,
0x00000100145b7824ULL, 0x040fe400078e00ffULL, 0x0001000014147824ULL, 0x000fe200078e00ffULL,
0x0000541047477816ULL, 0x008fe20000000057ULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x0000003c003c7306ULL, 0x000ea20000200c00ULL, 0x00000018ff617819ULL, 0x000fe40000011453ULL,
0x00000018ff147819ULL, 0x000fe40000011414ULL, 0x00000018ff157819ULL, 0x000fe20000011415ULL,
0x000000463410723cULL, 0x000b620000001810ULL, 0x00000018ff5b7819ULL, 0x000fe2000001145bULL,
0x0000005d005d7306ULL, 0x000eea0000200c00ULL, 0x0000010016357824ULL, 0x020fe200078e00ffULL,
0x0000888017377816ULL, 0x000fc400000000ffULL, 0x0000001400537306ULL, 0x0007e20000200c00ULL,
0x000054103c3c7816ULL, 0x004fe4000000003dULL, 0x0000888016347816ULL, 0x000fe200000000ffULL,
0x0000000618188232ULL, 0x082fe20000000000ULL, 0x00000018ff357819ULL, 0x000fe20000011435ULL,
0x000000061a1a8232ULL, 0x000fe40000000000ULL, 0x0000001500367306ULL, 0x0003e20000200c00ULL,
0x0000000719198232ULL, 0x080fe20000000000ULL, 0x0000541045147816ULL, 0x008fe2000000005cULL,
0x000000071b1b8232ULL, 0x000fe20000000000ULL, 0x00005410543d7816ULL, 0x000fc8000000005dULL,
0x0000000e000e7306ULL, 0x000fe20000200c00ULL, 0x0000541055157816ULL, 0x002fe4000000005eULL,
0x0000003c1828723cULL, 0x040f6a0000001828ULL, 0x0000005900597306ULL, 0x000fe60000200c00ULL,
0x000000141830723cULL, 0x000b6a0000001830ULL, 0x0000004c004c7306ULL, 0x000fe40000200c00ULL,
0x0000010017147824ULL, 0x020fc400078e00ffULL, 0x0001000017177824ULL, 0x000fc600078e00ffULL,
0x00000018ff157819ULL, 0x000fe20000011414ULL, 0x0001000016147824ULL, 0x000fe200078e00ffULL,
0x0000000f000f7306ULL, 0x000e620000200c00ULL, 0x00000018ff177819ULL, 0x000fc60000011417ULL,
0x00000018ff147819ULL, 0x000fc80000011414ULL, 0x0000005a005a7306ULL, 0x000ff00000200c00ULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x00005410360f7816ULL, 0x002fce000000000fULL,
0x0000003400347306ULL, 0x000ff00000200c00ULL, 0x0000003500357306ULL, 0x000e620000200c00ULL,
0x000054105a5a7816ULL, 0x004fce000000005bULL, 0x0000004e004e7306ULL, 0x000eb00000200c00ULL,
0x0000004f004f7306ULL, 0x000ee20000200c00ULL, 0x0000541034347816ULL, 0x002fce0000000035ULL,
0x0000000b000b7306ULL, 0x000fe20000200c00ULL, 0x000054103e4e7816ULL, 0x004fce000000004eULL,
0x0000003f003f7306ULL, 0x000fe20000200c00ULL, 0x000054105f4f7816ULL, 0x008fce000000004fULL,
0x0000006000607306ULL, 0x000fe20000200c00ULL, 0x0000004e182c723cULL, 0x000f6e000000182cULL,
0x0000006100617306ULL, 0x000e700000200c00ULL, 0x0000003700377306ULL, 0x000ff00000200c00ULL,
0x0000001500167306ULL, 0x0004e20000200c00ULL, 0x00005410605b7816ULL, 0x002fce0000000061ULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x0000541059157816ULL, 0x004fe2000000000eULL,
0x0000005a1820723cULL, 0x000f620000001820ULL, 0x00005410530e7816ULL, 0x000fca000000004cULL,
0x00000014003c7306ULL, 0x0002a20000200c00ULL, 0x0000541037357816ULL, 0x008fe20000000016ULL,
0x0000000e181c723cULL, 0x040b6c000000181cULL, 0x0000001700177306ULL, 0x000ee20000200c00ULL,
0x000054103f147816ULL, 0x002fe2000000000bULL, 0x00000002000b7824ULL, 0x000fe200078e00ffULL,
0x000000341838723cULL, 0x000f640000001838ULL, 0x000054103c0e7816ULL, 0x024fcc000000004dULL,
0x000000141824723cULL, 0x000f620000001824ULL, 0x00005410170f7816ULL, 0x008fce0000000044ULL,
0x0000000e1818723cULL, 0x000b6e0000001810ULL, 0x0000f6c86b0e7811ULL, 0x020fe400078e18ffULL,
0xfffffff80b107812ULL, 0x000fe200078ec0ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fce0000008000ULL,
0x000000000e0e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6900010ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff0b7224ULL, 0x000fc600078e00ffULL,
0x0000000000107805ULL, 0x004fc80000015200ULL, 0x0000040004137984ULL, 0x000ea40000000800ULL,
0x8000000013ff7812ULL, 0x006fc4000780480fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100b00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000127805ULL, 0x000fcc0000015200ULL, 0x0000001210157210ULL, 0x000fca0007f1e1ffULL,
0x0000000113137824ULL, 0x000fe200000e0e11ULL, 0x003d09001500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff127819ULL, 0x000fc80000011413ULL,
0x0000001512127211ULL, 0x000fca00078110ffULL, 0x000000ffff137224ULL, 0x000fca00000e0613ULL,
0x0000000212127819ULL, 0x000fc80000001213ULL, 0x000000120000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010b0b7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000040004137984ULL, 0x000e640000000800ULL,
0x8000000013ff7812ULL, 0x002fe4000780480fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010000e7824ULL, 0x000fca00078e00ffULL, 0xffffffe00e0b7812ULL, 0x000fca00078ec0ffULL,
0x00000100400b7824ULL, 0x000fca00078e020bULL, 0x000000c00b107810ULL, 0x000fe20007ffe0ffULL,
0x00005900420b7a24ULL, 0x010fc600078e02ffULL, 0x00000020100f7812ULL, 0x000fe200078ec0ffULL,
0x000000400b0b7824ULL, 0x000fc800078e00ffULL, 0x000000016e147824ULL, 0x000fe200078e020fULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x000000100e117812ULL, 0x000fe400078ec0ffULL,
0x00000010670e7217ULL, 0x000fe40007800000ULL, 0x00000003ff0f7819ULL, 0x000fe40000011641ULL,
0x000062000b177a11ULL, 0x000fe200078a38ffULL, 0x000000010e0e7824ULL, 0x000fe200078e0a10ULL,
0x000000040f137810ULL, 0x040fe20007ffe0ffULL, 0x000000010f107824ULL, 0x000fe200078e0211ULL,
0x000063000b357a11ULL, 0x000fc400028f3cffULL, 0x0000000e110e7217ULL, 0x000fe20007800000ULL,
0x0000000110127824ULL, 0x040fe400078e0241ULL, 0x0000000810157824ULL, 0x000fe400078e00ffULL,
0x000000010e0e7824ULL, 0x000fc600078e0a11ULL, 0xfffffff815167812ULL, 0x000fe400078ee212ULL,
0x000000080f127810ULL, 0x040fe40007ffe0ffULL, 0x0000000e0f00720cULL, 0x0c0fe40003f86070ULL,
0x0000000c0f157810ULL, 0x000fe20007ffe0ffULL, 0x00000001100f7824ULL, 0x000fe200078e0214ULL,
0x0000000e1200720cULL, 0x0c0fe20003f46070ULL, 0x0000000113107824ULL, 0x140fe200078e0211ULL,
0x0000000e1300720cULL, 0x080fe20003f66070ULL, 0x0000000112127824ULL, 0x100fe200078e0211ULL,
0x0000000e1500720cULL, 0x040fe20003f06070ULL, 0x0000000115377824ULL, 0x000fc400078e0211ULL,
0x0000000110117824ULL, 0x040fe400078e0241ULL, 0x0000000810347824ULL, 0x000fe400078e00ffULL,
0x000000800f0e7825ULL, 0x000fc600078e00ffULL, 0xfffffff834347812ULL, 0x000fe200078ee211ULL,
0x0000000110107824ULL, 0x000fe200078e0214ULL, 0x000000560e0e7212ULL, 0x000fe200078efcffULL,
0x0000000112137824ULL, 0x040fe400078e0241ULL, 0x0000000812367824ULL, 0x000fe200078e00ffULL,
0x0000000e170e7210ULL, 0x000fe20007fbe0ffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0xfffffff836367812ULL, 0x000fe200078ee213ULL, 0x0000000112127824ULL, 0x100fe200078e0214ULL,
0x0000005610107212ULL, 0x000fe200078efcffULL, 0x0000000137147824ULL, 0x000fe400078e0214ULL,
0x0000008012127825ULL, 0x000fc800078e00ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000005612127212ULL, 0x000fc600078efcffULL, 0x000000010f0f7824ULL, 0x000fe200028e0635ULL,
0x0000001710107210ULL, 0x080fe20007fbe0ffULL, 0x00000001370b7824ULL, 0x040fe200078e0241ULL,
0x0000005614147212ULL, 0x000fe200078efcffULL, 0x00000008373c7824ULL, 0x000fe400078e00ffULL,
0x0000000111117824ULL, 0x000fe200028e0635ULL, 0x0000001712127210ULL, 0x080fe40007fbe0ffULL,
0x0000001714147210ULL, 0x000fe20007fde0ffULL, 0x0000001034177824ULL, 0x000fe200078e0251ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee20bULL, 0x00000010160b7824ULL, 0x000fc400078e0251ULL,
0x0000000113137824ULL, 0x100fe400028e0635ULL, 0x0000000115157824ULL, 0x000fe200030e0635ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e0b7faeULL, 0x0003e2000e101c48ULL,
0x0000001036357824ULL, 0x100fe400078e0251ULL, 0x000000103c377824ULL, 0x000fe200078e0251ULL,
0x0000000010177faeULL, 0x0003e8000d901c48ULL, 0x0000000012357faeULL, 0x0003e8000d101c48ULL,
0x0000000014377faeULL, 0x0003e2000c101c48ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x000000100e0e7812ULL, 0x000fe400078ec0ffULL, 0x000062000b177a11ULL, 0x000fc400078038ffULL,
0x0000000e410f7211ULL, 0x000fe400078fe8ffULL, 0x000063000b357a11ULL, 0x000fe400000f3cffULL,
0x000000040f117810ULL, 0x040fe20007ffe0ffULL, 0x000000010f107824ULL, 0x140fe200078e0241ULL,
0x0000000c0f157810ULL, 0x040fe20007ffe0ffULL, 0x000000080f137824ULL, 0x040fe400078e00ffULL,
0x000000010f0e7824ULL, 0x000fe400078e0214ULL, 0x0000000811347824ULL, 0x000fe200078e00ffULL,
0xfffffff813167812ULL, 0x000fe200078ee210ULL, 0x0000000111107824ULL, 0x000fe200078e0214ULL,
0x000000080f137810ULL, 0x000fe20007ffe0ffULL, 0x00000001110f7824ULL, 0x000fc400078e0241ULL,
0x00000008153c7824ULL, 0x000fe400078e00ffULL, 0x0000000113127824ULL, 0x040fe200078e0214ULL,
0xfffffff834347812ULL, 0x000fe200078ee20fULL, 0x0000000113117824ULL, 0x140fe400078e0241ULL,
0x0000000813367824ULL, 0x000fe400078e00ffULL, 0x0000000115137824ULL, 0x000fe400078e0241ULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0xfffffff836367812ULL, 0x000fc400078ee211ULL,
0xfffffff83c3c7812ULL, 0x000fe200078ee213ULL, 0x0000000115147824ULL, 0x000fe200078e0214ULL,
0x000000560e0e7212ULL, 0x000fe200078efcffULL, 0x0000008010107825ULL, 0x000fc600078e00ffULL,
0x0000000e170e7210ULL, 0x000fe20007f1e0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x0000005610107212ULL, 0x000fc600078efcffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000005612127212ULL, 0x000fe400078efcffULL, 0x0000001017107210ULL, 0x000fe20007f5e0ffULL,
0x000000010f0f7824ULL, 0x000fe200000e0635ULL, 0x0000005614147212ULL, 0x000fe200078efcffULL,
0x00000010160b7824ULL, 0x000fe200078e0251ULL, 0x0000001217127210ULL, 0x000fe20007f1e0ffULL,
0x0000000111117824ULL, 0x000fe200010e0635ULL, 0x0000001417147210ULL, 0x000fe20007f7e0ffULL,
0x0000001034177824ULL, 0x000fe200078e0251ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000e0b7faeULL, 0x0003e2000b901c48ULL, 0x0000000113137824ULL, 0x000fc400000e0635ULL,
0x0000000115157824ULL, 0x000fe200018e0635ULL, 0x0000000010177faeULL, 0x0003e2000b901c48ULL,
0x0000001036357824ULL, 0x100fe400078e0251ULL, 0x000000103c377824ULL, 0x000fc600078e0251ULL,
0x0000000012357faeULL, 0x0003e8000b901c48ULL, 0x0000000014377faeULL, 0x0003e4000b901c48ULL,
0x00000008000b7824ULL, 0x002fe200078e00ffULL, 0x0000000302107810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0e7424ULL, 0x000fc600078e00ffULL, 0xfffffff00b0b7812ULL, 0x000fe400078ec0ffULL,
0x000000681000720cULL, 0x000fe40003f06070ULL, 0x000000000b0473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000000016f108824ULL, 0x000fc400078e0210ULL,
0x00000004ff118424ULL, 0x000fc800078e00ffULL, 0x0000640010108625ULL, 0x000fca00078e0011ULL,
0x00000008100e8981ULL, 0x000522000c1e1900ULL, 0x0000f6b004047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x00f6b0000b107f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f6480008127f8cULL, 0x000664000c80043fULL,
0x0000000000147805ULL, 0x000fc40000015200ULL, 0x00f64c00080b7984ULL, 0x002e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804813ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0f7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000167805ULL, 0x000fcc0000015200ULL,
0x0000001614167210ULL, 0x000fca0007f1e1ffULL, 0x0000000117177824ULL, 0x000fe200000e0e15ULL,
0x003d09001600780cULL, 0x000fc80003f06070ULL, 0x000000ff1700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401600780cULL, 0x000fc80003f06070ULL,
0x000000ff1700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0b7819ULL, 0x000fc80000011417ULL, 0x000000160b0b7211ULL, 0x000fca00078110ffULL,
0x000000ffff167224ULL, 0x000fca00000e0617ULL, 0x000000020b0b7819ULL, 0x000fc80000001216ULL,
0x0000000b0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f64c00080b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x002fe40007804813ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002000087824ULL, 0x008fca00078e00ffULL,
0xffffff80080b7812ULL, 0x000fc800078ec0ffULL, 0x0000010056087810ULL, 0x000fca0007ffe00bULL,
0x000000016d087824ULL, 0x000fca00078e0208ULL, 0x00f00000080f7984ULL, 0x000e680000000800ULL,
0x00f2000008127984ULL, 0x0006a20000000800ULL, 0x0000000a0f00720bULL, 0x002fe20003f1d000ULL,
0x0000b1427f007947ULL, 0x000fd8000b800000ULL, 0x00000000000b7806ULL, 0x008fc800000e0100ULL,
0x0000ffff0b177812ULL, 0x000fe2000780c0ffULL, 0x000004b000007945ULL, 0x000fe20003800000ULL,
0x00000001ff147424ULL, 0x000fe400078e00ffULL, 0x000000ffff087224ULL, 0x000fd200078e000aULL,
0x0000047000008947ULL, 0x000fea0003800000ULL, 0x00000002710b7810ULL, 0x000fe40007ffe0ffULL,
0x0000000a0f00720bULL, 0x000fe40003f54000ULL, 0x000000000b00720cULL, 0x000fe20003f05270ULL,
0x0000b0e27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000087806ULL, 0x000fc400010e0100ULL,
0x0000008000148824ULL, 0x000fe200078e0256ULL, 0x0000000a0f0b8209ULL, 0x000fe20007810000ULL,
0x0000037000017945ULL, 0x000fe20003800000ULL, 0x0000991008137816ULL, 0x000fe200000000ffULL,
0x000000016d148824ULL, 0x000fca00078e0214ULL, 0x00f4000b14008388ULL, 0x0003e20000000800ULL,
0x000000ff1300720cULL, 0x000fda0003f05270ULL, 0x0000031000008947ULL, 0x000fea0003800000ULL,
0x0000000a0f0b7209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff08ff7812ULL, 0x000fc6000780c0ffULL, 0x0000000a0b0b7221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL, 0x0000000b00167308ULL, 0x000e640000000800ULL,
0x0000001609097220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0b7819ULL, 0x000fe20000011641ULL, 0x0000b0027f007947ULL, 0x000fea000b800000ULL,
0x00001f0b160b7589ULL, 0x0002e400000e0000ULL, 0x0000000b30307220ULL, 0x08cfe20000410000ULL,
0x0000000b31317220ULL, 0x080fe20000410000ULL, 0x0000000b2c2c7220ULL, 0x080fe20000410000ULL,
0x0000000b2d2d7220ULL, 0x080fe20000410000ULL, 0x0000000b28287220ULL, 0x080fe20000410000ULL,
0x0000000b29297220ULL, 0x080fe20000410000ULL, 0x0000000b24247220ULL, 0x080fe20000410000ULL,
0x0000000b25257220ULL, 0x080fe20000410000ULL, 0x0000000b20207220ULL, 0x080fe20000410000ULL,
0x0000000b21217220ULL, 0x080fe20000410000ULL, 0x0000000b1c1c7220ULL, 0x080fe20000410000ULL,
0x0000000b1d1d7220ULL, 0x080fe20000410000ULL, 0x0000000b38387220ULL, 0x080fe20000410000ULL,
0x0000000b39397220ULL, 0x080fe20000410000ULL, 0x0000000b18187220ULL, 0x080fe20000410000ULL,
0x0000000b19197220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0008ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000008410b7811ULL, 0x000fe200078ff0ffULL, 0x0000aee27f007947ULL, 0x000fea000b800000ULL,
0x00001f0b160b7589ULL, 0x00066400000e0000ULL, 0x0000000b32327220ULL, 0x086fe20000410000ULL,
0x0000000b33337220ULL, 0x080fe20000410000ULL, 0x0000000b2e2e7220ULL, 0x080fe20000410000ULL,
0x0000000b2f2f7220ULL, 0x080fe20000410000ULL, 0x0000000b2a2a7220ULL, 0x080fe20000410000ULL,
0x0000000b2b2b7220ULL, 0x080fe20000410000ULL, 0x0000000b26267220ULL, 0x080fe20000410000ULL,
0x0000000b27277220ULL, 0x080fe20000410000ULL, 0x0000000b22227220ULL, 0x080fe20000410000ULL,
0x0000000b23237220ULL, 0x080fe20000410000ULL, 0x0000000b1e1e7220ULL, 0x080fe20000410000ULL,
0x0000000b1f1f7220ULL, 0x080fe20000410000ULL, 0x0000000b3a3a7220ULL, 0x080fe20000410000ULL,
0x0000000b3b3b7220ULL, 0x080fe20000410000ULL, 0x0000000b1a1a7220ULL, 0x080fe20000410000ULL,
0x0000000b1b1b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000ffff17ff7812ULL, 0x000fe20007806008ULL, 0x00000001ff147424ULL, 0x000fe200078e00ffULL,
0x0000000a0f087209ULL, 0x000fd60007810000ULL, 0x800000080f0f0221ULL, 0x000fe20000010000ULL,
0x00007610ff140816ULL, 0x000fc60000000014ULL, 0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL,
0x0000000f00050308ULL, 0x000e640000000800ULL, 0x0000000512120220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000912097221ULL, 0x004fc20000010000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x00000008000f7824ULL, 0x000fca00078e00ffULL,
0xfffffff00f157812ULL, 0x000fca00078ec0ffULL, 0x00f6ac00150f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000780480dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff167224ULL, 0x008fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000101600780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x000000120a127210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e0bULL,
0x003d09001200780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401200780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff0f7819ULL, 0x000fc80000011413ULL, 0x000000120f0f7211ULL, 0x000fca00078110ffULL,
0x000000ffff127224ULL, 0x000fca00000e0613ULL, 0x000000020f0f7819ULL, 0x000fc80000001212ULL,
0x0000000f0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000116167810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f6ac00150f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780480dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00009910140a7816ULL, 0x000fe200000000ffULL,
0x0000015000007945ULL, 0x000fe60003800000ULL, 0x000000ff0a00720cULL, 0x000fda0003f05270ULL,
0x0000012000000947ULL, 0x000fea0003800000ULL, 0x00000005ff06723eULL, 0x000fe400000000ffULL,
0x00000002ff0d7819ULL, 0x000fe40000011641ULL, 0x00005410060a7816ULL, 0x000fe20000000006ULL,
0x0000aa927f007947ULL, 0x000fea000b800000ULL, 0x00001f0d0a067589ULL, 0x0002a400000e0000ULL,
0x000000080d0b7810ULL, 0x000fe20007ffe0ffULL, 0x0000aac27f007947ULL, 0x000fea000b800000ULL,
0x00001f0b0a077589ULL, 0x00066400000e0000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000100d0b7810ULL, 0x008fe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200078e000aULL,
0x00007d0000157802ULL, 0x000fc40000000f00ULL, 0x0000b12000007944ULL, 0x016fea0003c00000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000180d0b7810ULL, 0x00cfe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200078e000aULL, 0x00007d5000157802ULL, 0x000fc40000000f00ULL,
0x0000b0d000007944ULL, 0x012fea0003c00000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000010434c7824ULL, 0x100fe200078e0265ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000001049447824ULL, 0x000fc400078e0265ULL, 0x000000104a3c7824ULL, 0x100fe400078e0265ULL,
0x000000004c4c783bULL, 0x000ee20000004200ULL, 0x0000001048147824ULL, 0x000fc600078e0265ULL,
0x000000004444783bULL, 0x000ea80000004200ULL, 0x000000003c3c783bULL, 0x000e680000004200ULL,
0x000000001414783bULL, 0x000e620000004200ULL, 0x000001004c347824ULL, 0x048fe200078e00ffULL,
0x000088804c5b7816ULL, 0x000fe200000000ffULL, 0x000100004d557824ULL, 0x040fe200078e00ffULL,
0x000088804d5d7816ULL, 0x040fe200000000ffULL, 0x000001004e577824ULL, 0x000fe200078e00ffULL,
0x00000018ff607819ULL, 0x000fe20000011434ULL, 0x000001004d347824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe2000001144cULL, 0x0000005b005b7306ULL, 0x000fe20000200c00ULL,
0x00000018ff597819ULL, 0x000fc4000001144dULL, 0x00000018ff547819ULL, 0x000fe20000011434ULL,
0x000100004c347824ULL, 0x000fe200078e00ffULL, 0x00000018ff5c7819ULL, 0x000fe40000011455ULL,
0x00000018ff5e7819ULL, 0x000fe2000001144eULL, 0x0000006000607306ULL, 0x000ee20000200c00ULL,
0x00000018ff537819ULL, 0x000fe40000011434ULL, 0x00a000005034783bULL, 0x0002e20000000200ULL,
0x00000018ff647819ULL, 0x000fe4000001144fULL, 0x000088804e557816ULL, 0x040fe200000000ffULL,
0x000100004e4e7824ULL, 0x000fe200078e00ffULL, 0x0000005d005d7306ULL, 0x000fe20000200c00ULL,
0x00000018ff4a7819ULL, 0x004fe20000011444ULL, 0x000001004f507824ULL, 0x002fc400078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x00000018ff497819ULL, 0x000fe40000011445ULL,
0x00000054004c7306ULL, 0x0002a20000200c00ULL, 0x00000018ff577819ULL, 0x000fe40000011457ULL,
0x00000018ff437819ULL, 0x000fe40000011446ULL, 0x00000018ff487819ULL, 0x000fe40000011447ULL,
0x00000018ff137819ULL, 0x000fe2000001143cULL, 0x00000053004d7306ULL, 0x0005e20000200c00ULL,
0x00000018ff547819ULL, 0x002fc40000011450ULL, 0x00000018ff427819ULL, 0x000fe4000001143dULL,
0x00000018ff0f7819ULL, 0x000fe4000001143eULL, 0x00000018ff127819ULL, 0x000fe2000001143fULL,
0x0000004e00667306ULL, 0x0007e20000200c00ULL, 0x000088804f537816ULL, 0x044fe200000000ffULL,
0x000100004f4f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff0b7819ULL, 0x000fe40000011414ULL,
0x00000018ff0a7819ULL, 0x000fc40000011415ULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000005a005a7306ULL, 0x000e620000200c00ULL, 0x000054105b4e7816ULL, 0x008fe20000000060ULL,
0x0000000634348232ULL, 0x080fe20000000000ULL, 0x00008880445b7816ULL, 0x000fe200000000ffULL,
0x0000000636368232ULL, 0x000fe20000000000ULL, 0x0000888045607816ULL, 0x000fe200000000ffULL,
0x0000000735358232ULL, 0x080fe40000000000ULL, 0x0000004f00507306ULL, 0x0005e20000200c00ULL,
0x0000000737378232ULL, 0x000fe20000000000ULL, 0x00000018ff0d7819ULL, 0x000fc40000011416ULL,
0x00000018ff0c7819ULL, 0x000fc80000011417ULL, 0x0000005900597306ULL, 0x000fe20000200c00ULL,
0x000054105d4f7816ULL, 0x004fe2000000004cULL, 0x00000100445d7824ULL, 0x040fe400078e00ffULL,
0x0001000044447824ULL, 0x000fc600078e00ffULL, 0x00000018ff5d7819ULL, 0x000fe2000001145dULL,
0x0000005c005c7306ULL, 0x000ea20000200c00ULL, 0x0000004e3430723cULL, 0x000b620000001830ULL,
0x00000018ff447819ULL, 0x000fcc0000011444ULL, 0x00000100454e7824ULL, 0x060fe200078e00ffULL,
0x0000004400627306ULL, 0x0003e20000200c00ULL, 0x0001000045457824ULL, 0x000fe200078e00ffULL,
0x00008880464f7816ULL, 0x000fe400000000ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x0000005500557306ULL, 0x000fe20000200c00ULL,
0x000054104d447816ULL, 0x002fce000000005aULL, 0x00000045004d7306ULL, 0x0005f00000200c00ULL,
0x0000005700577306ULL, 0x000e620000200c00ULL, 0x000054105c457816ULL, 0x004fce0000000059ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x00000044342c723cULL, 0x000b6e000000182cULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x0000010047447824ULL, 0x020fe200078e00ffULL,
0x000088803c457816ULL, 0x000fc800000000ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x0000004e00617306ULL, 0x0007f00000200c00ULL, 0x0000005b004c7306ULL, 0x0003e20000200c00ULL,
0x00000100464e7824ULL, 0x008fc400078e00ffULL, 0x0001000046467824ULL, 0x000fc600078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe4000001144eULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x0000005e005e7306ULL, 0x000ee20000200c00ULL, 0x00008880475b7816ULL, 0x042fe200000000ffULL,
0x0001000047477824ULL, 0x000fca00078e00ffULL, 0x00000018ff477819ULL, 0x000fe20000011447ULL,
0x00000046005a7306ULL, 0x0003f00000200c00ULL, 0x0000006400647306ULL, 0x000ea20000200c00ULL,
0x0000541055467816ULL, 0x002fce0000000057ULL, 0x0000004700557306ULL, 0x0005f00000200c00ULL,
0x0000005d00637306ULL, 0x000fe20000200c00ULL, 0x0000541053477816ULL, 0x004fe40000000054ULL,
0x000088803d547816ULL, 0x000fca00000000ffULL, 0x00000044005d7306ULL, 0x0003e20000200c00ULL,
0x000000463428723cULL, 0x000bee0000001828ULL, 0x000001003d467824ULL, 0x020fe200078e00ffULL,
0x0000006000607306ULL, 0x000ea20000200c00ULL, 0x000001003c447824ULL, 0x002fc400078e00ffULL,
0x000100003c3c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff467819ULL, 0x000fe20000011446ULL,
0x000100003d3d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff447819ULL, 0x000fe40000011444ULL,
0x00000018ff3c7819ULL, 0x000fe2000001143cULL, 0x0000004600577306ULL, 0x0003e20000200c00ULL,
0x00000018ff3d7819ULL, 0x000fce000001143dULL, 0x0000003c005f7306ULL, 0x0007e20000200c00ULL,
0x000001003e467824ULL, 0x002fce00078e00ffULL, 0x0000004400537306ULL, 0x0003e20000200c00ULL,
0x00005410663c7816ULL, 0x008fce000000005eULL, 0x0000003d005e7306ULL, 0x0007e20000200c00ULL,
0x000088803e447816ULL, 0x042fe200000000ffULL, 0x000100003e3e7824ULL, 0x000fcc00078e00ffULL,
0x0000004a004a7306ULL, 0x000fe20000200c00ULL, 0x00005410503d7816ULL, 0x008fce0000000064ULL,
0x0000003c3424723cULL, 0x000be20000001824ULL, 0x0000004900497306ULL, 0x000e6c0000200c00ULL,
0x000001003f3c7824ULL, 0x020fe200078e00ffULL, 0x00005410603d7816ULL, 0x004fe20000000061ULL,
0x0000004e005c7306ULL, 0x0005e20000200c00ULL, 0x0000010014617824ULL, 0x000fc400078e00ffULL,
0x00000018ff3c7819ULL, 0x000fc6000001143cULL, 0x00000018ff617819ULL, 0x000fe40000011461ULL,
0x0000004f00597306ULL, 0x0007e20000200c00ULL, 0x00000018ff4e7819ULL, 0x004fe40000011446ULL,
0x00000018ff467819ULL, 0x000fe4000001143eULL, 0x00008880143e7816ULL, 0x040fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x000054104d4d7816ULL, 0x002fe20000000049ULL,
0x0000003c00507306ULL, 0x0003e20000200c00ULL, 0x000088803f4f7816ULL, 0x048fe200000000ffULL,
0x000100003f3f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x000000ffff607224ULL, 0x000fc600078e003eULL, 0x00000018ff477819ULL, 0x000fe2000001143fULL,
0x0000005b005b7306ULL, 0x000ea20000200c00ULL, 0x000054104c3c7816ULL, 0x002fe40000000063ULL,
0x00005410624c7816ULL, 0x000fe4000000004aULL, 0x0000888015627816ULL, 0x000fc600000000ffULL,
0x0000003c343c723cULL, 0x040b620000001820ULL, 0x0000004300437306ULL, 0x000e620000200c00ULL,
0x00a000004b20783bULL, 0x02066c0000000200ULL, 0x0000004c341c723cULL, 0x000b62000000181cULL,
0x0000004800487306ULL, 0x000e6c0000200c00ULL, 0x00000100154d7824ULL, 0x020fc400078e00ffULL,
0x00000060004a7306ULL, 0x0005e20000200c00ULL, 0x000000ffff4c7224ULL, 0x000fe400078e0062ULL,
0x00000018ff4d7819ULL, 0x000fca000001144dULL, 0x00000014004b7306ULL, 0x0087e20000200c00ULL,
0x0001000015607824ULL, 0x004fe200078e00ffULL, 0x000054105b157816ULL, 0x000fe4000000005dULL,
0x00008880165b7816ULL, 0x000fc800000000ffULL, 0x0000004500457306ULL, 0x000fe20000200c00ULL,
0x0000541059147816ULL, 0x008fe4000000005cULL, 0x00000018ff597819ULL, 0x000fca0000011460ULL,
0x000000143438723cULL, 0x000b620000001838ULL, 0x0000005400547306ULL, 0x000ea20000200c00ULL,
0x0000000620208232ULL, 0x082fe40000000000ULL, 0x0000000622228232ULL, 0x000fe40000000000ULL,
0x0000000721218232ULL, 0x080fe20000000000ULL, 0x000054105a147816ULL, 0x020fe20000000043ULL,
0x0000000723238232ULL, 0x000fe20000000000ULL, 0x0000541055157816ULL, 0x000fe20000000048ULL,
0x0000001300137306ULL, 0x000e620000200c00ULL, 0x000000ffff437224ULL, 0x000fca00078e005bULL,
0x000000143418723cULL, 0x000b640000001818ULL, 0x0000004200427306ULL, 0x000eea0000200c00ULL,
0x0000010016147824ULL, 0x020fe200078e00ffULL, 0x0000541054157816ULL, 0x004fe20000000057ULL,
0x0000010017377824ULL, 0x040fe200078e00ffULL, 0x0000888017367816ULL, 0x040fe200000000ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x00000018ff147819ULL, 0x000fe20000011414ULL,
0x0001000017177824ULL, 0x000fe200078e00ffULL, 0x0000001200127306ULL, 0x000fe40000200c00ULL,
0x00000018ff167819ULL, 0x000fc40000011416ULL, 0x00000018ff177819ULL, 0x000fc80000011417ULL,
0x0000001400357306ULL, 0x0005f00000200c00ULL, 0x0000004700477306ULL, 0x000ee20000200c00ULL,
0x0000541045147816ULL, 0x004fce0000000053ULL, 0x000000142030723cULL, 0x000b620000001830ULL,
0x0000006100497306ULL, 0x000eac0000200c00ULL, 0x000054105f147816ULL, 0x022fe40000000013ULL,
0x000054105e157816ULL, 0x008fe20000000042ULL, 0x0000004c004c7306ULL, 0x000fe20000200c00ULL,
0x0000541047477816ULL, 0x000fca0000000012ULL, 0x00000014202c723cULL, 0x000b62000000182cULL,
0x000054104a127816ULL, 0x004fe20000000049ULL, 0x0000004d004d7306ULL, 0x000e6a0000200c00ULL,
0x00000018ff157819ULL, 0x020fc60000011437ULL, 0x0000000f000f7306ULL, 0x000ff00000200c00ULL,
0x0000000b000b7306ULL, 0x000ea20000200c00ULL, 0x000054104c137816ULL, 0x002fce000000004dULL,
0x0000000a000a7306ULL, 0x000fe20000200c00ULL, 0x00000012203c723cULL, 0x000b6e000000183cULL,
0x0000000d000d7306ULL, 0x000fe20000200c00ULL, 0x000054104b127816ULL, 0x024fe2000000000bULL,
0x00000002000b7824ULL, 0x000fcc00078e00ffULL, 0x0000000c000c7306ULL, 0x000ff00000200c00ULL,
0x0000004400447306ULL, 0x000ff00000200c00ULL, 0x0000004e004e7306ULL, 0x000e700000200c00ULL,
0x0000004f004f7306ULL, 0x000eb00000200c00ULL, 0x0000004600467306ULL, 0x000ee20000200c00ULL,
0x00005410444e7816ULL, 0x002fce000000004eULL, 0x0000005900597306ULL, 0x000e620000200c00ULL,
0x000054104f4f7816ULL, 0x004fce0000000050ULL, 0x0000004300347306ULL, 0x000ea20000200c00ULL,
0x0000541046467816ULL, 0x008fe2000000000fULL, 0x0000004e2028723cULL, 0x040b6c0000001828ULL,
0x0000003600367306ULL, 0x000fe20000200c00ULL, 0x0000541059137816ULL, 0x002fe2000000000aULL,
0x000000462024723cULL, 0x000b620000001824ULL, 0x0000f6c86b0a7811ULL, 0x000fca00078e18ffULL,
0x0000001500157306ULL, 0x000e620000200c00ULL, 0x0000541034147816ULL, 0x004fe20000000035ULL,
0x00000012201c723cULL, 0x000b6c000000181cULL, 0x0000001600167306ULL, 0x000eb00000200c00ULL,
0x0000001700177306ULL, 0x000ee20000200c00ULL, 0x0000541036157816ULL, 0x002fc40000000015ULL,
0x0000541016167816ULL, 0x004fca000000000dULL, 0x000000142038723cULL, 0x000b620000001838ULL,
0x0000541017177816ULL, 0x008fe4000000000cULL, 0xfffffff80b0c7812ULL, 0x000fca00078ec0ffULL,
0x000000162018723cULL, 0x000b620000001818ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x000000000a0a7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f698000cff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff0f7224ULL, 0x000fc600078e00ffULL, 0x00000000000c7805ULL, 0x004fc80000015200ULL,
0x0000040004137984ULL, 0x020ea40000000800ULL, 0x8000000013ff7812ULL, 0x006fe4000780480bULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100f00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000127805ULL, 0x000fcc0000015200ULL,
0x000000120c157210ULL, 0x000fca0007f1e1ffULL, 0x0000000113137824ULL, 0x000fe200000e0e0dULL,
0x003d09001500780cULL, 0x000fc80003f06070ULL, 0x000000ff1300720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401500780cULL, 0x000fc80003f06070ULL,
0x000000ff1300720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff127819ULL, 0x000fc80000011413ULL, 0x0000001512127211ULL, 0x000fca00078110ffULL,
0x000000ffff137224ULL, 0x000fca00000e0613ULL, 0x0000000212127819ULL, 0x000fc80000001213ULL,
0x000000120000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010f0f7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040004137984ULL, 0x000e640000000800ULL, 0x8000000013ff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000001400c7810ULL, 0x000fe40007ffe0ffULL,
0x0000000302027810ULL, 0x000fe40007ffe0ffULL, 0x000000690c00720cULL, 0x000fda0003f06070ULL,
0x0000085000000947ULL, 0x000fea0003800000ULL, 0x00000002400a7810ULL, 0x000fe20007ffe0ffULL,
0x000001000c0c7824ULL, 0x000fe400078e0275ULL, 0x000059000e027a24ULL, 0x010fe200078e02ffULL,
0x000000690a00720cULL, 0x000fe40003f06070ULL, 0x000000200c0b7812ULL, 0x000fe200078ec0ffULL,
0x0000004002027824ULL, 0x000fc800078e00ffULL, 0x000000016e0b7824ULL, 0x000fcc00078e020bULL,
0x0000040000008947ULL, 0x000fea0003800000ULL, 0x0000000c670a7217ULL, 0x000fe20007800000ULL,
0x00000010000d7824ULL, 0x000fc800078e00ffULL, 0x000000010a0a7824ULL, 0x000fe200078e0a0cULL,
0x000000100d0d7812ULL, 0x000fe400078ec0ffULL, 0x00000003ff0c7819ULL, 0x000fe40000011641ULL,
0x0000000a0d0a7217ULL, 0x000fe40007800000ULL, 0x000000040c0e7810ULL, 0x040fe40007ffe0ffULL,
0x000000080c0f7810ULL, 0x000fe20007ffe0ffULL, 0x000000010a0a7824ULL, 0x100fe200078e0a0dULL,
0x0000000c0c137810ULL, 0x000fe20007ffe0ffULL, 0x000000010e127824ULL, 0x000fc400078e020dULL,
0x000000010f207824ULL, 0x100fe200078e020dULL, 0x0000000a0c00720cULL, 0x0c0fe20003f86070ULL,
0x000000010c0c7824ULL, 0x100fe200078e020dULL, 0x0000000a0e00720cULL, 0x080fe20003f66070ULL,
0x0000000113227824ULL, 0x000fe200078e020dULL, 0x0000000a0f00720cULL, 0x080fe20003f46070ULL,
0x000000010c0e7824ULL, 0x140fe200078e0241ULL, 0x0000000a1300720cULL, 0x000fe20003f06070ULL,
0x000000080c157824ULL, 0x000fe400078e00ffULL, 0x00000001120f7824ULL, 0x000fc400078e0241ULL,
0x0000000812167824ULL, 0x000fe200078e00ffULL, 0xfffffff815147812ULL, 0x000fe200078ee20eULL,
0x00000001200e7824ULL, 0x000fe200078e020bULL, 0x0000620002157a11ULL, 0x000fe200078a38ffULL,
0x00000001200d7824ULL, 0x000fe200078e0241ULL, 0xfffffff816167812ULL, 0x000fe200078ee20fULL,
0x0000000820207824ULL, 0x000fe200078e00ffULL, 0x0000630002177a11ULL, 0x000fe200028f3cffULL,
0x000000010c0c7824ULL, 0x100fe400078e020bULL, 0x00000001120a7824ULL, 0x000fe200078e020bULL,
0xfffffff820207812ULL, 0x000fe200078ee20dULL, 0x0000000122127824ULL, 0x000fc400078e020bULL,
0x00000001220f7824ULL, 0x040fe400078e0241ULL, 0x0000000822227824ULL, 0x000fe400078e00ffULL,
0x000000800c0c7825ULL, 0x000fc600078e00ffULL, 0xfffffff822227812ULL, 0x000fe200078ee20fULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000560c0c7212ULL, 0x000fc600078efcffULL,
0x000000800e0e7825ULL, 0x000fe200078e00ffULL, 0x000000560a0a7212ULL, 0x000fe400078efcffULL,
0x0000000c150c7210ULL, 0x000fe20007fbe0ffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000150a0a7210ULL, 0x080fe40007fde0ffULL, 0x000000560e0e7212ULL, 0x080fe200078efcffULL,
0x000000010d0d7824ULL, 0x100fe200028e0617ULL, 0x0000005612127212ULL, 0x000fe200078efcffULL,
0x000000010b0b7824ULL, 0x000fe200030e0617ULL, 0x000000150e0e7210ULL, 0x080fe20007fbe0ffULL,
0x0000001016217824ULL, 0x100fe200078e0265ULL, 0x0000001512127210ULL, 0x000fe20007fde0ffULL,
0x0000001014157824ULL, 0x000fc400078e0265ULL, 0x0000001020237824ULL, 0x000fe400078e0265ULL,
0x000000010f0f7824ULL, 0x000fe200028e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000c157faeULL, 0x0003e2000e101c48ULL, 0x0000001022657824ULL, 0x000fe400078e0265ULL,
0x0000000113137824ULL, 0x000fe200030e0617ULL, 0x000000000a217faeULL, 0x0003e8000d901c48ULL,
0x000000000e237faeULL, 0x0003e8000d101c48ULL, 0x0000000012657faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x00000010000a7824ULL, 0x000fe200078e00ffULL,
0x0000620002157a11ULL, 0x000fc800078038ffULL, 0x000000100a0a7812ULL, 0x000fe400078ec0ffULL,
0x0000630002177a11ULL, 0x000fe400000f3cffULL, 0x0000000a410c7211ULL, 0x000fc800078fe8ffULL,
0x000000040c0e7810ULL, 0x040fe20007ffe0ffULL, 0x000000010c0d7824ULL, 0x040fe200078e0241ULL,
0x000000080c167810ULL, 0x040fe20007ffe0ffULL, 0x000000080c147824ULL, 0x040fe200078e00ffULL,
0x0000000c0c207810ULL, 0x040fe20007ffe0ffULL, 0x000000010c0a7824ULL, 0x100fe400078e020bULL,
0x000000010e0c7824ULL, 0x000fe200078e020bULL, 0xfffffff814147812ULL, 0x000fe200078ee20dULL,
0x000000010e0d7824ULL, 0x040fe400078e0241ULL, 0x000000080e227824ULL, 0x000fc400078e00ffULL,
0x00000001160e7824ULL, 0x100fe400078e020bULL, 0x0000000120127824ULL, 0x000fe400078e020bULL,
0x000000800a0a7825ULL, 0x000fc800078e00ffULL, 0x00000001160f7824ULL, 0x000fe200078e0241ULL,
0x000000560a0a7212ULL, 0x000fe200078efcffULL, 0x0000000816347824ULL, 0x000fe200078e00ffULL,
0xfffffff822167812ULL, 0x000fe200078ee20dULL, 0x0000000120137824ULL, 0x040fe200078e0241ULL,
0x0000000a150a7210ULL, 0x000fe20007f1e0ffULL, 0x0000000820367824ULL, 0x000fe200078e00ffULL,
0xfffffff834207812ULL, 0x000fe200078ee20fULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0xfffffff836227812ULL, 0x000fe200078ee213ULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000560c0c7212ULL, 0x000fc600078efcffULL, 0x0000008012127825ULL, 0x000fe200078e00ffULL,
0x000000560e0e7212ULL, 0x000fc600078efcffULL, 0x000000010b0b7824ULL, 0x000fe200000e0617ULL,
0x0000005612127212ULL, 0x000fe200078efcffULL, 0x0000001016217824ULL, 0x100fe200078e0265ULL,
0x0000000c150c7210ULL, 0x040fe20007f1e0ffULL, 0x0000001020237824ULL, 0x100fe200078e0265ULL,
0x0000000e150e7210ULL, 0x040fe40007f5e0ffULL, 0x0000001215127210ULL, 0x000fe20007f7e0ffULL,
0x0000001014157824ULL, 0x000fe400078e0265ULL, 0x000000010d0d7824ULL, 0x000fc400000e0617ULL,
0x000000010f0f7824ULL, 0x000fe200010e0617ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000000a157faeULL, 0x0003e2000b901c48ULL, 0x0000001022657824ULL, 0x000fe400078e0265ULL,
0x0000000113137824ULL, 0x000fe200018e0617ULL, 0x000000000c217faeULL, 0x0003e8000b901c48ULL,
0x000000000e237faeULL, 0x0003e8000b901c48ULL, 0x0000000012657faeULL, 0x0003e4000b901c48ULL,
0x000000046c027810ULL, 0x000fe20007ffe0ffULL, 0x0000008000007945ULL, 0x000fe20003800000ULL,
0xffffffffff0e7424ULL, 0x002fc400078e00ffULL, 0x000000680200720cULL, 0x000fda0003f06070ULL,
0x0000004000000947ULL, 0x000fea0003800000ULL, 0x000000016f0e7824ULL, 0x000fe400078e0202ULL,
0x00000004ff0f7424ULL, 0x000fc800078e00ffULL, 0x000064000e0e7625ULL, 0x000fcc00078e000fULL,
0x000000080e0e7981ULL, 0x000324000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000008000a7824ULL, 0x000fca00078e00ffULL, 0xfffffff00a0a7812ULL, 0x000fc800078ec0ffULL,
0x000000000a0473c2ULL, 0x000ea200000e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000f6a804047890ULL, 0x004fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f6a8000a0c7f8cULL, 0x0004e2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00f66800030a7f8cULL, 0x004464000c80043fULL, 0x0000000000127805ULL, 0x000fc40000015200ULL,
0x00f66c00030f7984ULL, 0x002e640000000800ULL, 0x800000000fff7812ULL, 0x002fe4000780480bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x00000014120f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000115147824ULL, 0x000fe200000e0e13ULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0c7819ULL, 0x008fc80000011414ULL,
0x0000000f0c0c7211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e0614ULL,
0x000000020c0c7819ULL, 0x000fc8000000120fULL, 0x0000000c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f66c00030f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe4000780480bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000180710a7811ULL, 0x000fc800078e38ffULL, 0x0000000a6d0a7210ULL, 0x000fca0007ffe056ULL,
0x00f000000a0f7984ULL, 0x000e680000000800ULL, 0x00f200000a0c7984ULL, 0x0086a20000000800ULL,
0x000000080f00720bULL, 0x002fe20003f1d000ULL, 0x00008c727f007947ULL, 0x000fd8000b800000ULL,
0x00000000000b7806ULL, 0x008fc800000e0100ULL, 0x0000ffff0b137812ULL, 0x000fe2000780c0ffULL,
0x000004b000007945ULL, 0x000fe20003800000ULL, 0x00000001ff0b7424ULL, 0x000fe400078e00ffULL,
0x000000ffff0a7224ULL, 0x000fd200078e0008ULL, 0x0000047000008947ULL, 0x000fea0003800000ULL,
0x00000003710b7810ULL, 0x000fe40007ffe0ffULL, 0x000000080f00720bULL, 0x000fe40003f54000ULL,
0x000000000b00720cULL, 0x000fe20003f05270ULL, 0x00008c127f007947ULL, 0x000fd4000b800000ULL,
0x00000000000a7806ULL, 0x000fc400010e0100ULL, 0x0000008000568824ULL, 0x000fe200078e0256ULL,
0x000000080f0b8209ULL, 0x000fe20007810000ULL, 0x0000037000017945ULL, 0x000fe20003800000ULL,
0x000099100a127816ULL, 0x000fe200000000ffULL, 0x000000016d568824ULL, 0x000fca00078e0256ULL,
0x00f4000b56008388ULL, 0x0003e20000000800ULL, 0x000000ff1200720cULL, 0x000fda0003f05270ULL,
0x0000031000008947ULL, 0x000fea0003800000ULL, 0x000000080f0b7209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff0aff7812ULL, 0x000fc6000780c0ffULL,
0x000000080b0b7221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b0b0b7820ULL, 0x000fc80000410000ULL,
0x0000000b00127308ULL, 0x000e640000000800ULL, 0x0000001209097220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff0b7819ULL, 0x000fe20000011641ULL,
0x00008b327f007947ULL, 0x000fea000b800000ULL, 0x00001f0b120b7589ULL, 0x0002e400000e0000ULL,
0x0000000b30307220ULL, 0x08cfe20000410000ULL, 0x0000000b31317220ULL, 0x080fe20000410000ULL,
0x0000000b2c2c7220ULL, 0x080fe20000410000ULL, 0x0000000b2d2d7220ULL, 0x080fe20000410000ULL,
0x0000000b28287220ULL, 0x080fe20000410000ULL, 0x0000000b29297220ULL, 0x080fe20000410000ULL,
0x0000000b24247220ULL, 0x080fe20000410000ULL, 0x0000000b25257220ULL, 0x080fe20000410000ULL,
0x0000000b3c3c7220ULL, 0x080fe20000410000ULL, 0x0000000b3d3d7220ULL, 0x080fe20000410000ULL,
0x0000000b1c1c7220ULL, 0x080fe20000410000ULL, 0x0000000b1d1d7220ULL, 0x080fe20000410000ULL,
0x0000000b38387220ULL, 0x080fe20000410000ULL, 0x0000000b39397220ULL, 0x080fe20000410000ULL,
0x0000000b18187220ULL, 0x080fe20000410000ULL, 0x0000000b19197220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff000aff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000008410b7811ULL, 0x000fe200078ff0ffULL,
0x00008a127f007947ULL, 0x000fea000b800000ULL, 0x00001f0b120b7589ULL, 0x00066400000e0000ULL,
0x0000000b32327220ULL, 0x086fe20000410000ULL, 0x0000000b33337220ULL, 0x080fe20000410000ULL,
0x0000000b2e2e7220ULL, 0x080fe20000410000ULL, 0x0000000b2f2f7220ULL, 0x080fe20000410000ULL,
0x0000000b2a2a7220ULL, 0x080fe20000410000ULL, 0x0000000b2b2b7220ULL, 0x080fe20000410000ULL,
0x0000000b26267220ULL, 0x080fe20000410000ULL, 0x0000000b27277220ULL, 0x080fe20000410000ULL,
0x0000000b3e3e7220ULL, 0x080fe20000410000ULL, 0x0000000b3f3f7220ULL, 0x080fe20000410000ULL,
0x0000000b1e1e7220ULL, 0x080fe20000410000ULL, 0x0000000b1f1f7220ULL, 0x080fe20000410000ULL,
0x0000000b3a3a7220ULL, 0x080fe20000410000ULL, 0x0000000b3b3b7220ULL, 0x080fe20000410000ULL,
0x0000000b1a1a7220ULL, 0x080fe20000410000ULL, 0x0000000b1b1b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000ffff13ff7812ULL, 0x000fe2000780600aULL,
0x00000001ff0b7424ULL, 0x000fe200078e00ffULL, 0x000000080f0a7209ULL, 0x000fd60007810000ULL,
0x8000000a0f0f0221ULL, 0x000fe20000010000ULL, 0x00007610ff0b0816ULL, 0x000fc6000000000bULL,
0x3fb8aa3b0f0f0820ULL, 0x000fc80000410000ULL, 0x0000000f00050308ULL, 0x000e640000000800ULL,
0x000000050c0c0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000090c097221ULL, 0x004fc20000010000ULL, 0x0000000000127805ULL, 0x008fcc0000015200ULL,
0x0000000800087824ULL, 0x000fca00078e00ffULL, 0xfffffff0080c7812ULL, 0x000fca00078ec0ffULL,
0x00f6b4000c0f7984ULL, 0x000e640000000800ULL, 0x800000000fff7812ULL, 0x002fe40007804811ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff167224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101600780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000147805ULL, 0x000fcc0000015200ULL, 0x00000014120f7210ULL, 0x000fca0007f1e1ffULL,
0x0000000115147824ULL, 0x000fe200000e0e13ULL, 0x003d09000f00780cULL, 0x000fc80003f06070ULL,
0x000000ff1400720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400f00780cULL, 0x000fc80003f06070ULL, 0x000000ff1400720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff087819ULL, 0x000fc80000011414ULL,
0x0000000f08087211ULL, 0x000fca00078110ffULL, 0x000000ffff0f7224ULL, 0x000fca00000e0614ULL,
0x0000000208087819ULL, 0x000fc8000000120fULL, 0x000000080000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000116167810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00f6b4000c0f7984ULL, 0x000e640000000800ULL,
0x800000000fff7812ULL, 0x002fe40007804811ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099100b087816ULL, 0x000fe200000000ffULL, 0x0000015000007945ULL, 0x000fe60003800000ULL,
0x000000ff0800720cULL, 0x000fda0003f05270ULL, 0x0000012000000947ULL, 0x000fea0003800000ULL,
0x00000005ff06723eULL, 0x000fe400000000ffULL, 0x00000002ff0f7819ULL, 0x000fe40000011641ULL,
0x0000541006087816ULL, 0x000fe20000000006ULL, 0x000085c27f007947ULL, 0x000fea000b800000ULL,
0x00001f0f08067589ULL, 0x0002a400000e0000ULL, 0x000000080f0b7810ULL, 0x000fe20007ffe0ffULL,
0x000085f27f007947ULL, 0x000fea000b800000ULL, 0x00001f0b08077589ULL, 0x00066400000e0000ULL,
0x000000437f007947ULL, 0x000fea000b800000ULL, 0x000000100f0b7810ULL, 0x008fe20007ffe0ffULL,
0x000000ffff147224ULL, 0x000fe200078e0008ULL, 0x0000a39000157802ULL, 0x000fc40000000f00ULL,
0x00008a9000007944ULL, 0x016fea0003c00000ULL, 0x000000437f007947ULL, 0x000fea000b800000ULL,
0x000000180f0b7810ULL, 0x00cfe20007ffe0ffULL, 0x000000ffff147224ULL, 0x000fe200078e0008ULL,
0x0000a3e000157802ULL, 0x000fc40000000f00ULL, 0x00008a4000007944ULL, 0x012fea0003c00000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000800714f7824ULL, 0x040fe200078e026aULL, 0x0000000371477810ULL, 0x000fc40007ffe0ffULL,
0x000000005858783bULL, 0x000ee20000004200ULL, 0x00000008410c7812ULL, 0x000fc400078ec0ffULL,
0x0000000741647812ULL, 0x000fe200078ec0ffULL, 0x000000005214783bULL, 0x000ea20000004200ULL,
0x000000070c0f7812ULL, 0x102fe400078ef841ULL, 0x0000000864647812ULL, 0x000fe400078ef841ULL,
0x0000000270707810ULL, 0x000fe20007ffe0ffULL, 0x000000080f0c7824ULL, 0x000fe400078e00ffULL,
0x0000010058087824ULL, 0x048fe200078e00ffULL, 0x00000018ff227819ULL, 0x000fe20000011458ULL,
0x00000100590b7824ULL, 0x004fe200078e00ffULL, 0x0000888058207816ULL, 0x040fe200000000ffULL,
0x0001000058587824ULL, 0x000fe200078e00ffULL, 0x00000018ff087819ULL, 0x000fc40000011408ULL,
0x00000018ff0b7819ULL, 0x000fe2000001140bULL, 0x0000002200227306ULL, 0x000fe20000200c00ULL,
0x00000018ff607819ULL, 0x000fe4000001145bULL, 0x000088805b4b7816ULL, 0x000fe400000000ffULL,
0x00000018ff237819ULL, 0x000fe40000011458ULL, 0x00000018ff627819ULL, 0x000fe20000011459ULL,
0x0000000800487306ULL, 0x0003e20000200c00ULL, 0x0000888059217816ULL, 0x040fe200000000ffULL,
0x0001000059597824ULL, 0x000fe200078e00ffULL, 0x00000018ff617819ULL, 0x000fc4000001145aULL,
0x000088805a467816ULL, 0x040fe400000000ffULL, 0x00000018ff597819ULL, 0x000fe20000011459ULL,
0x0000000b004c7306ULL, 0x0005e20000200c00ULL, 0x000001005a087824ULL, 0x042fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe20000011414ULL, 0x000100005a5a7824ULL, 0x000fe200078e00ffULL,
0x00008880145c7816ULL, 0x000fe400000000ffULL, 0x00000018ff087819ULL, 0x000fe40000011408ULL,
0x0000005900637306ULL, 0x0003e20000200c00ULL, 0x000001005b0b7824ULL, 0x044fe200078e00ffULL,
0x00000018ff4e7819ULL, 0x000fe20000011415ULL, 0x000100005b5b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff427819ULL, 0x000fc40000011416ULL, 0x00000018ff0b7819ULL, 0x000fe4000001140bULL,
0x00000008006a7306ULL, 0x0005e20000200c00ULL, 0x00000018ff587819ULL, 0x000fe4000001145bULL,
0x00000018ff597819ULL, 0x002fe4000001145aULL, 0x00000018ff437819ULL, 0x000fe40000011417ULL,
0x00008880155a7816ULL, 0x000fe200000000ffULL, 0x0000000b00667306ULL, 0x0003e20000200c00ULL,
0x0000010014087824ULL, 0x004fe200078e00ffULL, 0x0000888016537816ULL, 0x000fe200000000ffULL,
0x0001000014147824ULL, 0x000fe200078e00ffULL, 0x0000888017567816ULL, 0x000fc400000000ffULL,
0x00000018ff5b7819ULL, 0x000fe20000011408ULL, 0x0000000400087824ULL, 0x000fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fe20000011414ULL, 0x00000100150b7824ULL, 0x042fe200078e00ffULL,
0x0000002000207306ULL, 0x000e620000200c00ULL, 0x0001000015157824ULL, 0x000fe200078e00ffULL,
0x0000000408087812ULL, 0x000fe400078ec0ffULL, 0x00000018ff5d7819ULL, 0x000fe4000001140bULL,
0x0000000208087812ULL, 0x000fc400078efcffULL, 0x00000014005e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x0000000841087211ULL, 0x000fca00078fe0ffULL,
0x000000010f0b7824ULL, 0x040fe200078e0208ULL, 0x00000015005f7306ULL, 0x000fe20000200c00ULL,
0x000000100f0f7812ULL, 0x000fe400078efcffULL, 0x0000541020207816ULL, 0x002fe40000000048ULL,
0xfffffff80c0c7812ULL, 0x000fe200078ee20bULL, 0x00000100160b7824ULL, 0x040fe400078e00ffULL,
0x0001000016167824ULL, 0x000fe200078e00ffULL, 0x0000002100217306ULL, 0x000e620000200c00ULL,
0x000000100c0c7824ULL, 0x000fe200078e0251ULL, 0x00000018ff0b7819ULL, 0x000fe2000001140bULL,
0x000000010f087824ULL, 0x040fe200078e0208ULL, 0x00000018ff167819ULL, 0x000fe20000011416ULL,
0x000000080f0f7824ULL, 0x000fe200078e00ffULL, 0x000000000c34783bULL, 0x0004e40000004200ULL,
0x00000016006d7306ULL, 0x000fe40000200c00ULL, 0xfffffff80f087812ULL, 0x000fe200078ee208ULL,
0x00000100170c7824ULL, 0x004fc400078e00ffULL, 0x0001000017177824ULL, 0x000fc600078e00ffULL,
0x0000002300237306ULL, 0x000ea20000200c00ULL, 0x0000001008087824ULL, 0x000fe200078e0251ULL,
0x0000541021217816ULL, 0x002fe4000000004cULL, 0x00000018ff177819ULL, 0x000fe40000011417ULL,
0x000000000810783bULL, 0x000e620000004200ULL, 0x00000018ff0c7819ULL, 0x000fe2000001140cULL,
0x00000017006c7306ULL, 0x0005f00000200c00ULL, 0x0000006200627306ULL, 0x000e700000200c00ULL,
0x0000004600467306ULL, 0x000e620000200c00ULL, 0x0000010034147824ULL, 0x008fe200078e00ffULL,
0x00000018ff4a7819ULL, 0x000fe20000011435ULL, 0x0000010035547824ULL, 0x040fe200078e00ffULL,
0x0000888035517816ULL, 0x040fe200000000ffULL, 0x0001000035357824ULL, 0x000fe200078e00ffULL,
0x00000018ff507819ULL, 0x000fc40000011414ULL, 0x0000004b004b7306ULL, 0x000ee20000200c00ULL,
0x00a800004f14783bULL, 0x0044e20000000200ULL, 0x00000018ff497819ULL, 0x000fe40000011434ULL,
0x0000888034527816ULL, 0x040fe200000000ffULL, 0x0001000034347824ULL, 0x000fe200078e00ffULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x0000006100617306ULL, 0x000fe20000200c00ULL,
0x00000008644f7824ULL, 0x004fe200078e00ffULL, 0x00000018ff347819ULL, 0x000fc40000011434ULL,
0x00000018ff447819ULL, 0x000fe40000011436ULL, 0xfffffff84f707812ULL, 0x000fe400078ee270ULL,
0x0000003500647306ULL, 0x0005e20000200c00ULL, 0x00008880364f7816ULL, 0x040fe400000000ffULL,
0x0000008047707824ULL, 0x000fe200078e0270ULL, 0x00000018ff547819ULL, 0x000fe20000011454ULL,
0x0000010036477824ULL, 0x040fe200078e00ffULL, 0x00000018ff0f7819ULL, 0x002fe20000011411ULL,
0x0001000036367824ULL, 0x000fe200078e00ffULL, 0x0000900070707811ULL, 0x000fe200078e20ffULL,
0x0000010037357824ULL, 0x004fe200078e00ffULL, 0x0000003400657306ULL, 0x0003e20000200c00ULL,
0x00000018ff457819ULL, 0x000fc40000011437ULL, 0x00000018ff367819ULL, 0x000fe40000011436ULL,
0x00000018ff357819ULL, 0x000fe40000011435ULL, 0x00008880374c7816ULL, 0x000fe200000000ffULL,
0x0000004f00487306ULL, 0x000fe20000200c00ULL, 0x0000541023347816ULL, 0x002fe20000000022ULL,
0x0001000037377824ULL, 0x000fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011447ULL,
0x00000018ff087819ULL, 0x000fe20000011413ULL, 0x0000000614148232ULL, 0x008fc40000000000ULL,
0x00000035004f7306ULL, 0x0003e20000200c00ULL, 0x0000000616168232ULL, 0x000fe20000000000ULL,
0x00000018ff377819ULL, 0x000fe20000011437ULL, 0x0000000715158232ULL, 0x080fe40000000000ULL,
0x0000000717178232ULL, 0x000fc60000000000ULL, 0x0000006000607306ULL, 0x000fe20000200c00ULL,
0x0000541063357816ULL, 0x002fc60000000062ULL, 0x000000201430723cULL, 0x040b640000001830ULL,
0x000000007020783bULL, 0x0202a40000000200ULL, 0x0000005900597306ULL, 0x000ee80000200c00ULL,
0x00000034142c723cULL, 0x000b62000000182cULL, 0x0000888010707816ULL, 0x002fc600000000ffULL,
0x0000005800587306ULL, 0x000e660000200c00ULL, 0x0000541046347816ULL, 0x020fe2000000006aULL,
0x00000100106a7824ULL, 0x000fe200078e00ffULL, 0x000054104b357816ULL, 0x000fc60000000066ULL,
0x0000005c005c7306ULL, 0x000fe20000200c00ULL, 0x00000018ff4b7819ULL, 0x000fc6000001146aULL,
0x000000341428723cULL, 0x000b680000001828ULL, 0x0000005b005b7306ULL, 0x000fe60000200c00ULL,
0x0000541059347816ULL, 0x028fe40000000061ULL, 0x0000541058357816ULL, 0x002fc60000000060ULL,
0x0000005a005a7306ULL, 0x000fe80000200c00ULL, 0x000000341424723cULL, 0x000b620000001824ULL,
0x0000000620208232ULL, 0x004fc60000000000ULL, 0x0000005d005d7306ULL, 0x000e620000200c00ULL,
0x0000000622228232ULL, 0x000fe40000000000ULL, 0x0000010011347824ULL, 0x020fe200078e00ffULL,
0x0000000721218232ULL, 0x080fe40000000000ULL, 0x0000000723238232ULL, 0x000fe40000000000ULL,
0x0000004d004d7306ULL, 0x000fe20000200c00ULL, 0x00000018ff347819ULL, 0x000fce0000011434ULL,
0x0000004e004e7306ULL, 0x000ea20000200c00ULL, 0x000054105a357816ULL, 0x002fce000000005dULL,
0x0000000c00577306ULL, 0x0003f00000200c00ULL, 0x0000003400597306ULL, 0x0007e20000200c00ULL,
0x00000018ff0c7819ULL, 0x002fe20000011410ULL, 0x0001000010107824ULL, 0x000fca00078e00ffULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000005300537306ULL, 0x000fe20000200c00ULL,
0x000054105c347816ULL, 0x008fce000000005bULL, 0x0000000b00557306ULL, 0x0002e20000200c00ULL,
0x000000342030723cULL, 0x000bee0000001830ULL, 0x0000005600567306ULL, 0x000ea20000200c00ULL,
0x0001000011357824ULL, 0x020fe200078e00ffULL, 0x00000018ff0b7819ULL, 0x002fcc0000011412ULL,
0x0000003600637306ULL, 0x0003f00000200c00ULL, 0x00000010005a7306ULL, 0x0007e20000200c00ULL,
0x0000888011367816ULL, 0x002fe400000000ffULL, 0x000054105f117816ULL, 0x004fc4000000004eULL,
0x00008880124e7816ULL, 0x000fe200000000ffULL, 0x000000ffff587224ULL, 0x000fe400078e0036ULL,
0x0000005200527306ULL, 0x000fe20000200c00ULL, 0x000054105e107816ULL, 0x008fe4000000004dULL,
0x00000018ff4d7819ULL, 0x000fca0000011435ULL, 0x0000005000507306ULL, 0x000e620000200c00ULL,
0x00000010202c723cULL, 0x000bee000000182cULL, 0x0000005100517306ULL, 0x000fe20000200c00ULL,
0x0000541053107816ULL, 0x020fe40000000055ULL, 0x0000541056117816ULL, 0x000fca0000000057ULL,
0x0000005400547306ULL, 0x000ea20000200c00ULL, 0x0000541052347816ULL, 0x002fe20000000050ULL,
0x000000102028723cULL, 0x000bec0000001828ULL, 0x0000004900497306ULL, 0x000e620000200c00ULL,
0x0000010012107824ULL, 0x060fe400078e00ffULL, 0x0001000012127824ULL, 0x000fca00078e00ffULL,
0x0000004a004a7306ULL, 0x000ee20000200c00ULL, 0x0000541051357816ULL, 0x004fe40000000054ULL,
0x00000018ff517819ULL, 0x000fe40000011410ULL, 0x00000018ff127819ULL, 0x000fc60000011412ULL,
0x0000004700477306ULL, 0x000fe20000200c00ULL, 0x0000541065107816ULL, 0x002fce0000000049ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x0000541064117816ULL, 0x008fce000000004aULL,
0x0000004400447306ULL, 0x000e620000200c00ULL, 0x00000010141c723cULL, 0x000bee000000181cULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000010013117824ULL, 0x020fca00078e00ffULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x0000003700627306ULL, 0x0004e20000200c00ULL,
0x0000541063447816ULL, 0x002fce0000000044ULL, 0x0000004200427306ULL, 0x000e620000200c00ULL,
0x000000341434723cULL, 0x004b6e000000183cULL, 0x00008880133c7816ULL, 0x060fe200000000ffULL,
0x0001000013137824ULL, 0x000fe200078e00ffULL, 0x000054104c3d7816ULL, 0x000fe2000000004fULL,
0x0000004300437306ULL, 0x000ea20000200c00ULL, 0x0000541062457816ULL, 0x008fe20000000045ULL,
0x000000ffff107224ULL, 0x000fe200078e003cULL, 0x00005410483c7816ULL, 0x000fc40000000047ULL,
0x00000018ff137819ULL, 0x000fe40000011413ULL, 0x000054106d427816ULL, 0x002fe20000000042ULL,
0x0000000c000c7306ULL, 0x000e640000200c00ULL, 0x0000003c143c723cULL, 0x040f6c0000001838ULL,
0x0000000f000f7306ULL, 0x000fe20000200c00ULL, 0x000054106c437816ULL, 0x004fe20000000043ULL,
0x000000441414723cULL, 0x000b6c0000001818ULL, 0x0000007000467306ULL, 0x000fe20000200c00ULL,
0x000054105a4c7816ULL, 0x002fe2000000000cULL, 0x000000422038723cULL, 0x000b6c0000001824ULL,
0x0000004b004b7306ULL, 0x000e700000200c00ULL, 0x0000005800587306ULL, 0x000eb00000200c00ULL,
0x0000004d004d7306ULL, 0x000ee20000200c00ULL, 0x0000541046467816ULL, 0x002fce000000004bULL,
0x0000004e004e7306ULL, 0x000fe20000200c00ULL, 0x0000541058477816ULL, 0x004fce0000000059ULL,
0x0000005100517306ULL, 0x000e620000200c00ULL, 0x000054104d4d7816ULL, 0x008fe2000000000fULL,
0x000000462034723cULL, 0x040b6c0000001834ULL, 0x0000001000107306ULL, 0x000fe40000200c00ULL,
0x0000004c201c723cULL, 0x000b6c000000181cULL, 0x0000001100117306ULL, 0x000ea20000200c00ULL,
0x000054104e187816ULL, 0x022fce0000000051ULL, 0x0000000b000b7306ULL, 0x000ff00000200c00ULL,
0x0000000800087306ULL, 0x000fe20000200c00ULL, 0x0000541010197816ULL, 0x004fce0000000011ULL,
0x0000001200127306ULL, 0x000e620000200c00ULL, 0x000000182018723cULL, 0x000b6e000000183cULL,
0x0000001300137306ULL, 0x000ea20000200c00ULL, 0x0000541012127816ULL, 0x002fe4000000000bULL,
0x0000541013137816ULL, 0x004fce0000000008ULL, 0x000000122020723cULL, 0x000b620000001814ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x0000000004107f8cULL, 0x0002a2000c80043fULL,
0x0000000140407810ULL, 0x000fe40007ffe0ffULL, 0x0000f6a0710b7811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x000000000bff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff087224ULL, 0x004fe200078e0011ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff627000007947ULL, 0x000fea000383ffffULL, 0x000000ff6900720cULL, 0x008fda0003f05270ULL,
0x0000037000008947ULL, 0x000fea0003800000ULL, 0x0180000009027810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000002027812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0200780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000b52000057802ULL, 0x000fc40000000f00ULL, 0x0000773000007944ULL, 0x036fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000000900047308ULL, 0x002e640000001000ULL,
0xbf80000004027423ULL, 0x002fc80000000009ULL, 0x800000ff02037221ULL, 0x000fc80000010100ULL,
0x0000000304047223ULL, 0x000fc40000000004ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000802037981ULL, 0x000ee8000c1e9900ULL, 0x0000000000057919ULL, 0x000e680000000000ULL,
0x0000000000087919ULL, 0x000ea20000000000ULL, 0x00000002ff077819ULL, 0x002fe40000011605ULL,
0x0000000808057811ULL, 0x004fe200078ff0ffULL, 0x0000000403067220ULL, 0x008fca0000410000ULL,
0x00001f0706047589ULL, 0x000e6800000e0000ULL, 0x00001f0506057589ULL, 0x000ea200000e0000ULL,
0x0000003004307220ULL, 0x042fe20000410000ULL, 0x0000003104317220ULL, 0x040fe20000410000ULL,
0x0000002c042c7220ULL, 0x040fe20000410000ULL, 0x0000002d042d7220ULL, 0x040fe20000410000ULL,
0x0000002804287220ULL, 0x040fe20000410000ULL, 0x0000002904297220ULL, 0x040fe20000410000ULL,
0x0000003804387220ULL, 0x040fe20000410000ULL, 0x0000003904397220ULL, 0x040fe20000410000ULL,
0x0000003404347220ULL, 0x040fe20000410000ULL, 0x0000003504357220ULL, 0x040fe20000410000ULL,
0x0000001c041c7220ULL, 0x040fe20000410000ULL, 0x0000001d041d7220ULL, 0x040fe20000410000ULL,
0x0000001804187220ULL, 0x060fe20000410000ULL, 0x0000001904197220ULL, 0x040fe20000410000ULL,
0x0000002004207220ULL, 0x040fe20000410000ULL, 0x0000002104217220ULL, 0x000fe20000410000ULL,
0x0000003205327220ULL, 0x044fe20000410000ULL, 0x0000003305337220ULL, 0x040fe20000410000ULL,
0x0000002e052e7220ULL, 0x040fe20000410000ULL, 0x0000002f052f7220ULL, 0x040fe20000410000ULL,
0x0000002a052a7220ULL, 0x040fe20000410000ULL, 0x0000002b052b7220ULL, 0x040fe20000410000ULL,
0x0000003a053a7220ULL, 0x040fe20000410000ULL, 0x0000003b053b7220ULL, 0x040fe20000410000ULL,
0x0000003605367220ULL, 0x040fe20000410000ULL, 0x0000003705377220ULL, 0x040fe20000410000ULL,
0x0000001e051e7220ULL, 0x040fe20000410000ULL, 0x0000001f051f7220ULL, 0x040fe20000410000ULL,
0x0000001a051a7220ULL, 0x040fe20000410000ULL, 0x0000001b051b7220ULL, 0x040fe20000410000ULL,
0x0000002205227220ULL, 0x040fe20000410000ULL, 0x0000002305237220ULL, 0x000fc20000410000ULL,
0x0000000000047919ULL, 0x002e620000000000ULL, 0x0000100000087824ULL, 0x000fe200078e00ffULL,
0x0000001c1d1c723eULL, 0x000fc400000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000181918723eULL, 0x020fe400000000ffULL, 0x00000020210c723eULL, 0x004fe400000000ffULL,
0x0000002a2b2a723eULL, 0x000fc400000000ffULL, 0x0000003a3b15723eULL, 0x000fe400000000ffULL,
0x000000363736723eULL, 0x000fe400000000ffULL, 0x0000001e1f1e723eULL, 0x000fe400000000ffULL,
0x000054102a147816ULL, 0x000fe40000000015ULL, 0x00000002ff077819ULL, 0x102fe20000011604ULL,
0x0000000175757824ULL, 0x000fe200078e0204ULL, 0x0000000204027812ULL, 0x000fc400078ec0ffULL,
0x0000000804097811ULL, 0x000fe200078ff0ffULL, 0x00000008070a7824ULL, 0x040fe200078e00ffULL,
0x0000000702037211ULL, 0x040fe200078ff8ffULL, 0x00000008070d7824ULL, 0x000fe200078e00ffULL,
0x0000000902057211ULL, 0x000fe200078ff8ffULL, 0x0000000809067824ULL, 0x000fe200078e00ffULL,
0x0000000203027810ULL, 0x000fe20007ffe0ffULL, 0x0000000807097824ULL, 0x040fe200078e00ffULL,
0x000076322a157816ULL, 0x000fe40000000015ULL, 0xfffffff8060f7812ULL, 0x000fe200078ee205ULL,
0x0000000807067824ULL, 0x000fe200078e00ffULL, 0xfffffff809097812ULL, 0x000fc400078ee202ULL,
0x0000100008027812ULL, 0x000fe400078ee2ffULL, 0xfffffff806057812ULL, 0x000fe400078ee203ULL,
0x0000000403077810ULL, 0x000fe20007ffe0ffULL, 0x000008006b067824ULL, 0x000fe200078e0202ULL,
0x0000000603087810ULL, 0x000fe20007ffe0ffULL, 0x0000000804037824ULL, 0x000fe200078e00ffULL,
0xfffffff80a0b7812ULL, 0x000fe200078ee207ULL, 0x0000001005077824ULL, 0x000fe200078e0206ULL,
0xfffffff80d0d7812ULL, 0x000fe200078ee208ULL, 0x0000001009097824ULL, 0x100fe200078e0206ULL,
0x0000000803087812ULL, 0x000fe200078ec0ffULL, 0x000000100f0f7824ULL, 0x100fe200078e0206ULL,
0x000000303103723eULL, 0x000fe200000000ffULL, 0x000000100b0b7824ULL, 0x000fe200078e0206ULL,
0x0000002c2d05723eULL, 0x000fe200000000ffULL, 0x0000000107077824ULL, 0x000fe200078e0208ULL,
0x0000001a1b1a723eULL, 0x000fe200000000ffULL, 0x0000000108097824ULL, 0x040fe200078e0209ULL,
0x0000541003107816ULL, 0x100fe20000000005ULL, 0x000000100d0d7824ULL, 0x000fe200078e0206ULL,
0x0000763203117816ULL, 0x000fe20000000005ULL, 0x00000001080f7824ULL, 0x040fe200078e020fULL,
0x000000282903723eULL, 0x000fe200000000ffULL, 0x00000001080b7824ULL, 0x040fe200078e020bULL,
0x000000383905723eULL, 0x000fe200000000ffULL, 0x0000001007007388ULL, 0x0003e20000000a00ULL,
0x000000343506723eULL, 0x000fe200000000ffULL, 0x0000000108087824ULL, 0x000fe200078e020dULL,
0x00000022230d723eULL, 0x000fe200000000ffULL, 0x0000001075757824ULL, 0x000fe200078e0202ULL,
0x000000ff6b00720cULL, 0x000fc40003f05270ULL, 0x000054101a0a7816ULL, 0x000fe4000000000dULL,
0x0000541003107816ULL, 0x142fe40000000005ULL, 0x0000763203117816ULL, 0x000fe40000000005ULL,
0x0000763218077816ULL, 0x000fe4000000000cULL, 0x000000323303723eULL, 0x000fe200000000ffULL,
0x0000001009007388ULL, 0x0003e20000000a00ULL, 0x0000002e2f05723eULL, 0x000fc400000000ffULL,
0x0000541006107816ULL, 0x142fe4000000001cULL, 0x0000763206117816ULL, 0x000fe4000000001cULL,
0x0000541018067816ULL, 0x000fc6000000000cULL, 0x000000100b007388ULL, 0x000fe80000000a00ULL,
0x0000000608007388ULL, 0x0003e40000000a00ULL, 0x0000541003067816ULL, 0x142fe40000000005ULL,
0x0000763203077816ULL, 0x000fca0000000005ULL, 0x000000060f007388ULL, 0x0003e80000000a00ULL,
0x0004001409007388ULL, 0x000fe20000000a00ULL, 0x0000541036067816ULL, 0x142fe4000000001eULL,
0x0000763236077816ULL, 0x000fca000000001eULL, 0x000400060b007388ULL, 0x0003e40000000a00ULL,
0x000076321a0b7816ULL, 0x002fca000000000dULL, 0x0004000a08007388ULL, 0x000fe80000000a00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x00000000750c7984ULL, 0x010e680000000c00ULL,
0x0004000075147984ULL, 0x000ea80000000c00ULL, 0x0008000075107984ULL, 0x000ee80000000c00ULL,
0x000c000075187984ULL, 0x000ee20000000c00ULL, 0x200000ff0f0f7230ULL, 0x002fc40000000000ULL,
0x200000ff0e0e7230ULL, 0x000fe40000000000ULL, 0x200000ff0d0d7230ULL, 0x000fe40000000000ULL,
0x200000ff0c0c7230ULL, 0x000fe40000000000ULL, 0x200000ff17177230ULL, 0x004fe40000000000ULL,
0x200000ff16167230ULL, 0x000fe40000000000ULL, 0x200000ff15157230ULL, 0x000fc40000000000ULL,
0x200000ff14147230ULL, 0x000fe40000000000ULL, 0x000000130f0f7230ULL, 0x008fe40000000000ULL,
0x000000120e0e7230ULL, 0x000fe40000000000ULL, 0x000000110d0d7230ULL, 0x000fe40000000000ULL,
0x000000100c0c7230ULL, 0x000fe40000000000ULL, 0x0000001b17177230ULL, 0x000fc40000000000ULL,
0x0000001a16167230ULL, 0x000fe20000000000ULL, 0x0000000c75007388ULL, 0x000fe20000000c00ULL,
0x0000001915157230ULL, 0x000fe40000000000ULL, 0x0000001814147230ULL, 0x000fca0000000000ULL,
0x0004001475007388ULL, 0x000fe80000000c00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x00000003ff077819ULL, 0x000fc80000011604ULL,
0x000000730700720cULL, 0x000fda0003f06070ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000000107037824ULL, 0x100fe200078e0204ULL, 0x00000000000479c3ULL, 0x000e620000002700ULL,
0xffffffff00057882ULL, 0x000fe20000000000ULL, 0x00005a0072727a19ULL, 0x000fe200000006ffULL,
0x00005a0000067ab9ULL, 0x000fe20000000800ULL, 0x0000000703037812ULL, 0x000fe200078ec0ffULL,
0x0000000605057299ULL, 0x000fe2000800063fULL, 0x00000001000f7812ULL, 0x000fe400078ec0ffULL,
0x0ffffff803037812ULL, 0x000fe200078ef804ULL, 0x0000580000067ab9ULL, 0x000fe20000000800ULL,
0x0000002004007810ULL, 0x000fc40007ffe0ffULL, 0x00000007040e7812ULL, 0x000fe200078ec0ffULL,
0x0000001003057824ULL, 0x000fe200078e0202ULL, 0x00000003ff0d7819ULL, 0x000fe20000011600ULL,
0x0000001074037824ULL, 0x000fc600078e0207ULL, 0x0000000005087984ULL, 0x0004e40000000c00ULL,
0x0000000503077c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff067a19ULL, 0x000fe20000011603ULL,
0x00000006040472a4ULL, 0x002fe4000f8e023fULL, 0x0000000172077824ULL, 0x000fe400078e0207ULL,
0x000000080f057824ULL, 0x004fe400078e020eULL, 0x0000007906067224ULL, 0x000fc400078e0207ULL,
0x0000000479037c24ULL, 0x000fca000f8e02ffULL, 0x0000000603077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0007067a11ULL, 0x000fc800078040ffULL,
0x00005d0007077a11ULL, 0x000fe400000f440cULL, 0x000000730d00720cULL, 0x000fc60003f06070ULL,
0x0000001005067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0083ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000100057824ULL, 0x100fe200078e020dULL,
0x00000040040c7810ULL, 0x000fe20007ffe0ffULL, 0x00000010740d7824ULL, 0x000fc600078e020dULL,
0x0000000705057812ULL, 0x000fe400078ec0ffULL, 0x000000050d077c12ULL, 0x002fe4000f8e30ffULL,
0x0ffffff805057812ULL, 0x000fe400078ef800ULL, 0x00005a00ff067a19ULL, 0x000fe2000001160dULL,
0x0000000172077824ULL, 0x000fe200078e0207ULL, 0x00000003ff0d7819ULL, 0x000fe2000001160cULL,
0x0000001005057824ULL, 0x000fe200078e0202ULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x0000007906067224ULL, 0x000fc600078e0207ULL, 0x0000000005087984ULL, 0x0002a40000000c00ULL,
0x0000000603077210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0007067a11ULL, 0x000fe200078040ffULL, 0x000000080f057824ULL, 0x002fc600078e0200ULL,
0x00005d0007077a11ULL, 0x000fe400000f440eULL, 0x000000730d00720cULL, 0x000fc60003f06070ULL,
0x0000001005067825ULL, 0x000fca00078e0006ULL, 0x0000000806007986ULL, 0x0043ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c007824ULL, 0x100fe400078e020dULL,
0x00000010740d7824ULL, 0x000fc600078e020dULL, 0x0000000700057812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff067a19ULL, 0x002fe4000001160dULL, 0x0ffffff805057812ULL, 0x000fe400078ef80cULL,
0x000000070c0c7812ULL, 0x000fc600078ec0ffULL, 0x0000001005007824ULL, 0x000fe200078e0202ULL,
0x000000050d057c12ULL, 0x000fe2000f8e30ffULL, 0x000000080f077824ULL, 0x000fc600078e020cULL,
0x0000000000087984ULL, 0x0002a20000000c00ULL, 0x0000000172057824ULL, 0x000fc800078e0205ULL,
0x0000007906067224ULL, 0x000fca00078e0205ULL, 0x0000000603057210ULL, 0x000fe40007f1e0ffULL,
0x0000006004067810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x040fe400078040ffULL, 0x00000003ff0d7819ULL, 0x000fe40000011606ULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000730d00720cULL, 0x000fe20003f06070ULL,
0x0000000106007824ULL, 0x002fe400078e020dULL, 0x0000001007047825ULL, 0x000fc600078e0004ULL,
0x0000000700077812ULL, 0x000fc800078ec0ffULL, 0xfffffff807077812ULL, 0x000fe200078ef806ULL,
0x0000000804007986ULL, 0x0043e4000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001007077824ULL, 0x000fe200078e0202ULL, 0x0000000706067812ULL, 0x000fe200078ec0ffULL,
0x00000010740d7824ULL, 0x000fc600078e020dULL, 0x0000000007087984ULL, 0x002e620000000c00ULL,
0x000000080f057824ULL, 0x000fe200078e0206ULL, 0x000000050d027c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff007a19ULL, 0x000fc6000001160dULL, 0x0000000172027824ULL, 0x000fc800078e0202ULL,
0x0000007900007224ULL, 0x000fca00078e0202ULL, 0x0000000003007210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff037224ULL, 0x000fe200000e06ffULL, 0x00005c0000027a11ULL, 0x000fc800078040ffULL,
0x00005d0000037a11ULL, 0x000fca00000f4403ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x000000680000720cULL, 0x000fe20003f06070ULL, 0xffffffffff607424ULL, 0x000fd800078e00ffULL,
0x0000000270078824ULL, 0x000fc800078e00ffULL, 0x0000680007068a24ULL, 0x000fc800078e0200ULL,
0x0000640006068625ULL, 0x000fe200078e0005ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006c00ff647624ULL, 0x000fe200078e00ffULL, 0x0000000806608981ULL, 0x000ea2000c1e1900ULL,
0x00006d00ff657624ULL, 0x000fc600078e00ffULL, 0x00f60000ff047f8cULL, 0x002e68000c80043fULL,
0x0000000864647981ULL, 0x000722000c1e9900ULL, 0x000001ff0200780cULL, 0x000fe20003f04070ULL,
0x000000400c717824ULL, 0x000fe400078e00ffULL, 0x0000004000757824ULL, 0x000fe400078e00ffULL,
0x0000004072027824ULL, 0x000fc400078e00ffULL, 0x00000071601f7224ULL, 0x004fcc00078e02ffULL,
0x0000062000000947ULL, 0x000fea0003800000ULL, 0x00000002ff1b7819ULL, 0x00afe40000011641ULL,
0x000062001f1d7a11ULL, 0x000fe400078038ffULL, 0x000000081b0d7810ULL, 0x000fe20007ffe0ffULL,
0x0000004072727824ULL, 0x000fe200078e021bULL, 0x000063001f1f7a11ULL, 0x000fe400000f3cffULL,
0x00000041410c7211ULL, 0x000fe200078fe8ffULL, 0x0000008072067825ULL, 0x040fe200078e00ffULL,
0x0000000872087810ULL, 0x000fc40007ffe0ffULL, 0x00000010720a7810ULL, 0x000fe40007ffe0ffULL,
0x00000030060e7812ULL, 0x100fe200078ef803ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000030c147812ULL, 0x000fe400078ec0ffULL, 0x0000000e1d0e7210ULL, 0x000fe20007f1e0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000003008107812ULL, 0x000fe400078ef803ULL,
0x0000007567087217ULL, 0x000fe20007800000ULL, 0x00000001070f7824ULL, 0x000fe200000e061fULL,
0x0000001d10107210ULL, 0x000fc40007f3e0ffULL, 0x0000100000167811ULL, 0x000fe200078e68ffULL,
0x0000000108127824ULL, 0x000fe200078e0a75ULL, 0x00000028720c7810ULL, 0x000fe20007ffe0ffULL,
0x0000000109117824ULL, 0x000fe200008e061fULL, 0x0ffffffc14417812ULL, 0x000fe400078ef841ULL,
0x000000120d00720cULL, 0x0c0fe20003f26070ULL, 0x000000040d0d7824ULL, 0x000fe200078e00ffULL,
0x000000121b00720cULL, 0x000fe20003f06070ULL, 0x0000001041417824ULL, 0x000fe200078e0216ULL,
0x000000300a067812ULL, 0x000fc400078ef803ULL, 0xfffffffc0d0d7812ULL, 0x000fe400078ee214ULL,
0x0000001d06067210ULL, 0x000fe40007f5e0ffULL, 0x00000020720a7810ULL, 0x040fe20007ffe0ffULL,
0x000000100d137824ULL, 0x000fe200078e0216ULL, 0x0000001872097810ULL, 0x000fe20007ffe0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000101b217810ULL, 0x040fe20007ffe0ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000e417faeULL, 0x0003e2000c101c48ULL,
0x000000181b237810ULL, 0x000fe20007ffe0ffULL, 0x000000010b077824ULL, 0x000fe200010e061fULL,
0x000000300c0c7812ULL, 0x000fe200078ef803ULL, 0x0000000010137faeULL, 0x0005e2000c901c48ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000201b157810ULL, 0x000fc40007ffe0ffULL,
0x000000281b177810ULL, 0x000fe20007ffe0ffULL, 0x0000008009087825ULL, 0x000fe200078e00ffULL,
0x000000300a0a7812ULL, 0x100fe400078ef803ULL, 0x00000038720e7810ULL, 0x002fe20007ffe0ffULL,
0x0000000417257824ULL, 0x000fe200078e00ffULL, 0x0000003008087812ULL, 0x000fe400078ef803ULL,
0x0000001d0c107210ULL, 0x084fe20007fde0ffULL, 0x0000000421137824ULL, 0x000fe200078e00ffULL,
0x00000030720c7810ULL, 0x000fe20007ffe0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x0000001d0a0a7210ULL, 0x000fc40007f7e0ffULL, 0x0000001d08087210ULL, 0x080fe20007f5e0ffULL,
0x000000010d117824ULL, 0x000fe200030e061fULL, 0x000000301b197810ULL, 0x040fe20007ffe0ffULL,
0x000000800c0c7825ULL, 0x000fe200078e00ffULL, 0x000000381b1b7810ULL, 0x000fe40007ffe0ffULL,
0x000000122300720cULL, 0x0c0fe20003f86070ULL, 0x0000000423237824ULL, 0x000fe200078e00ffULL,
0x000000300c0c7812ULL, 0x000fe200078ef803ULL, 0x000000010b0b7824ULL, 0x100fe200018e061fULL,
0x000000122100720cULL, 0x080fe20003fa6070ULL, 0x0000000415217824ULL, 0x040fe200078e00ffULL,
0x000000121500720cULL, 0x080fe20003f66070ULL, 0x0000000109097824ULL, 0x000fe200010e061fULL,
0x000000121b00720cULL, 0x080fe20003f06070ULL, 0x0000000419277824ULL, 0x000fe200078e00ffULL,
0x0000001d0c0c7210ULL, 0x000fe20007fde0ffULL, 0x000000041b1b7824ULL, 0x000fe200078e00ffULL,
0x000000121700720cULL, 0x000fc40003f46070ULL, 0xfffffffc13137812ULL, 0x100fe200078ee214ULL,
0x000000010d0d7824ULL, 0x000fe200030e061fULL, 0x000000121900720cULL, 0x000fe40003f26070ULL,
0xfffffffc23157812ULL, 0x000fe200078ee214ULL, 0x0000001013137824ULL, 0x000fe200078e0216ULL,
0x000000300e0e7812ULL, 0x000fe400078ef803ULL, 0xfffffffc21177812ULL, 0x000fe200078ee214ULL,
0x0000001015157824ULL, 0x000fe200078e0216ULL, 0xfffffffc25197812ULL, 0x100fe200078ee214ULL,
0x0000000006137faeULL, 0x0003e2000e901c48ULL, 0xfffffffc27037812ULL, 0x000fe200078ee214ULL,
0x0000001017177824ULL, 0x000fe200078e0216ULL, 0xfffffffc1b1b7812ULL, 0x000fe200078ee214ULL,
0x0000001019197824ULL, 0x100fe200078e0216ULL, 0x0000001d0e0e7210ULL, 0x000fe20007fde0ffULL,
0x0000001003037824ULL, 0x100fe200078e0216ULL, 0x0000000008157faeULL, 0x0003e2000e101c48ULL,
0x000000101b1b7824ULL, 0x000fc400078e0216ULL, 0x000000010f0f7824ULL, 0x000fe200030e061fULL,
0x000000000a177faeULL, 0x0003e8000d901c48ULL, 0x0000000010197faeULL, 0x0003e8000d101c48ULL,
0x000000000c037faeULL, 0x0003e8000c901c48ULL, 0x000000000e1b7faeULL, 0x0003e2000c101c48ULL,
0x0000056000007947ULL, 0x000fea0003800000ULL, 0x0000000841157811ULL, 0x04afe400078ff0ffULL,
0x0000001041097811ULL, 0x000fc400078ff0ffULL, 0x0000004141077211ULL, 0x000fe200078fe8ffULL,
0x0000000415177824ULL, 0x000fe200078e00ffULL, 0x00000018410b7811ULL, 0x000fe200078ff0ffULL,
0x0000000409197824ULL, 0x000fe200078e00ffULL, 0x00000020410d7811ULL, 0x040fe400078ff0ffULL,
0x00000028410f7811ULL, 0x000fe200078ff0ffULL, 0x000000040b1b7824ULL, 0x000fe200078e00ffULL,
0x0000003041117811ULL, 0x000fe200078ff0ffULL, 0x000000040d1d7824ULL, 0x000fe200078e00ffULL,
0x0000003841137811ULL, 0x000fe200078ff0ffULL, 0x000000040f217824ULL, 0x000fe200078e00ffULL,
0x0000000307147812ULL, 0x000fe200078ec0ffULL, 0x0000000411277824ULL, 0x000fe200078e00ffULL,
0x0000000241067211ULL, 0x000fe200078ff0ffULL, 0x0000000413297824ULL, 0x000fe200078e00ffULL,
0x0000100000237811ULL, 0x000fc400078e68ffULL, 0xfffffffc17087812ULL, 0x100fe200078ee214ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0xfffffffc190a7812ULL, 0x100fe400078ee214ULL,
0xfffffffc1b0c7812ULL, 0x100fe200078ee214ULL, 0x0000001008177824ULL, 0x100fe200078e0223ULL,
0xfffffffc1d0e7812ULL, 0x100fe200078ee214ULL, 0x000000100a197824ULL, 0x000fe200078e0223ULL,
0x000062001f257a11ULL, 0x000fe200078038ffULL, 0x0000000102087824ULL, 0x000fe200078e0215ULL,
0xfffffffc21107812ULL, 0x100fe200078ee214ULL, 0x000000100c1b7824ULL, 0x000fe200078e0223ULL,
0x0ffffffc14417812ULL, 0x000fe200078ef841ULL, 0x00000001020a7824ULL, 0x000fe200078e0209ULL,
0xfffffffc27127812ULL, 0x100fe200078ee214ULL, 0x000000100e1d7824ULL, 0x000fe200078e0223ULL,
0xfffffffc29147812ULL, 0x000fe200078ee214ULL, 0x00000001020c7824ULL, 0x000fe200078e020bULL,
0x000063001f277a11ULL, 0x000fe200000f3cffULL, 0x00000010101f7824ULL, 0x000fe200078e0223ULL,
0x0000003006067812ULL, 0x000fe200078ef803ULL, 0x00000001020e7824ULL, 0x000fc400078e020dULL,
0x0000001041417824ULL, 0x100fe200078e0223ULL, 0x0000000625067210ULL, 0x000fe20007f1e0ffULL,
0x0000001012217824ULL, 0x000fe400078e0223ULL, 0x0000000102107824ULL, 0x000fe400078e020fULL,
0x0000008008087825ULL, 0x000fc800078e00ffULL, 0x0000001014237824ULL, 0x000fe200078e0223ULL,
0x0000003008087812ULL, 0x000fe200078ef803ULL, 0x0000000102127824ULL, 0x000fe400078e0211ULL,
0x000000800a0a7825ULL, 0x000fc800078e00ffULL, 0x0000000102147824ULL, 0x000fe200078e0213ULL,
0x000000300a0a7812ULL, 0x000fe200078ef803ULL, 0x000000800c0c7825ULL, 0x000fc600078e00ffULL,
0x0000000a250a7210ULL, 0x000fe20007f3e0ffULL, 0x000000800e0e7825ULL, 0x000fe200078e00ffULL,
0x000000300c0c7812ULL, 0x000fc600078ef803ULL, 0x0000008010107825ULL, 0x000fe200078e00ffULL,
0x000000300e0e7812ULL, 0x100fe400078ef803ULL, 0x0000000c250c7210ULL, 0x040fe20007f5e0ffULL,
0x0000008012127825ULL, 0x000fe200078e00ffULL, 0x0000003010107812ULL, 0x100fe400078ef803ULL,
0x0000000e250e7210ULL, 0x040fe20007f7e0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000003012127812ULL, 0x000fe400078ef803ULL, 0x0000001025107210ULL, 0x000fe20007f9e0ffULL,
0x0000000107077824ULL, 0x100fe200000e0627ULL, 0x0000000825087210ULL, 0x000fe20007f1e0ffULL,
0x000000010b0b7824ULL, 0x000fe200008e0627ULL, 0x0000003014037812ULL, 0x000fe200078ef803ULL,
0x000000010d0d7824ULL, 0x100fe200010e0627ULL, 0x0000001225127210ULL, 0x000fe20007fbe0ffULL,
0x0000000109097824ULL, 0x100fe200000e0627ULL, 0x0000000325147210ULL, 0x000fe20007fde0ffULL,
0x000000010f0f7824ULL, 0x100fe200018e0627ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000006417faeULL, 0x0003e2000b901c48ULL, 0x0000000111117824ULL, 0x000fc400020e0627ULL,
0x0000000113137824ULL, 0x100fe200028e0627ULL, 0x0000000008177faeULL, 0x0003e2000b901c48ULL,
0x0000000115157824ULL, 0x000fc600030e0627ULL, 0x000000000a197faeULL, 0x0003e8000b901c48ULL,
0x000000000c1b7faeULL, 0x0003e8000b901c48ULL, 0x000000000e1d7faeULL, 0x0003e8000b901c48ULL,
0x00000000101f7faeULL, 0x0003e8000b901c48ULL, 0x0000000012217faeULL, 0x0003e8000b901c48ULL,
0x0000000014237faeULL, 0x0003e4000b901c48ULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000000067805ULL, 0x002fc40000015200ULL, 0x00f60400ff037984ULL, 0x000e640000000800ULL,
0x8000000003ff7812ULL, 0x002fc40007804805ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000087805ULL, 0x000fcc0000015200ULL,
0x0000000806087210ULL, 0x000fca0007f1e1ffULL, 0x0000000109097824ULL, 0x000fe200000e0e07ULL,
0x003d09000800780cULL, 0x000fc80003f06070ULL, 0x000000ff0900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400800780cULL, 0x000fc80003f06070ULL,
0x000000ff0900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011409ULL, 0x0000000803037211ULL, 0x000fca00078110ffULL,
0x000000ffff087224ULL, 0x000fca00000e0609ULL, 0x0000000203037819ULL, 0x000fc80000001208ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804805ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e640000000000ULL,
0x0000002000037824ULL, 0x002fca00078e0203ULL, 0x00000003ff047819ULL, 0x000fc80000011603ULL,
0x1ffffffe04067812ULL, 0x000fe400078ec0ffULL, 0x0000000f03047812ULL, 0x000fc600078ec0ffULL,
0x0000000103067824ULL, 0x000fe400078e0206ULL, 0x0000001004087824ULL, 0x040fe400078e00ffULL,
0x0000001004057824ULL, 0x000fe200078e00ffULL, 0x0000000f06037812ULL, 0x040fe400078ec0ffULL,
0x0000000106067810ULL, 0x000fe40007ffe0ffULL, 0x000000f008037812ULL, 0x000fe400078ee203ULL,
0x0000000f06067812ULL, 0x000fc600078ec0ffULL, 0x00000000030c7984ULL, 0x000e62000000cc00ULL,
0x000000f005067812ULL, 0x000fca00078ee206ULL, 0x0000000006087984ULL, 0x000ea2000000cc00ULL,
0x000000ffff107224ULL, 0x002fe400078e000cULL, 0x000000ffff0c7224ULL, 0x000fe400078e000dULL,
0x000000ffff117224ULL, 0x000fe400078e000eULL, 0x000000ffff0d7224ULL, 0x000fe400078e000fULL,
0x000000ffff127224ULL, 0x004fe400078e0008ULL, 0x000000ffff137224ULL, 0x000fc400078e000aULL,
0x000000ffff0e7224ULL, 0x000fe400078e0009ULL, 0x000000ffff0f7224ULL, 0x000fe200078e000bULL,
0x0000001003007388ULL, 0x0003e8000000cc00ULL, 0x0000000c06007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00f60000ff087f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x000fc80000015200ULL,
0x00f60400ff037984ULL, 0x002e640000000800ULL, 0x8000000003ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x0000000604067210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000600780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400600780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff037819ULL, 0x000fc80000011407ULL, 0x0000000603037211ULL, 0x000fca00078110ffULL,
0x000000ffff067224ULL, 0x000fca00000e0607ULL, 0x0000000203037819ULL, 0x000fc80000001206ULL,
0x000000030000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x00f60400ff037984ULL, 0x000e640000000800ULL, 0x8000000003ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff6900720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000037919ULL, 0x000e620000000000ULL,
0x00005800ff6a7624ULL, 0x000fe200078e00ffULL, 0x8000580067727a10ULL, 0x000fe20007ffe0ffULL,
0x0000680070707a24ULL, 0x000fe200078e02ffULL, 0x3db504f364647820ULL, 0x010fe20000410000ULL,
0x0000f68800747811ULL, 0x000fe200078e18ffULL, 0x000000ffff617224ULL, 0x000fe200078e00ffULL,
0x0000001f6a067810ULL, 0x040fe20007ffe0ffULL, 0x000000ffff047224ULL, 0x000fe200078e00ffULL,
0xffffffff6a737810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff057224ULL, 0x000fe200078e0000ULL,
0x00000004ff067819ULL, 0x000fc40000011606ULL, 0x0000f60800767811ULL, 0x000fe400078e28ffULL,
0x000000096a6a7810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff727819ULL, 0x000fe40000011672ULL,
0x0ffffffe066d7812ULL, 0x000fc400078ec0ffULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x000000ffff077224ULL, 0x000fe200078e0004ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff067224ULL, 0x000fe200078e00ffULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x00000000002e7805ULL, 0x000fe2000001ff00ULL, 0x00000000002c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000327805ULL, 0x000fe2000001ff00ULL, 0x0000000000307805ULL, 0x000fe2000001ff00ULL,
0x0000000000367805ULL, 0x000fe2000001ff00ULL, 0x0000000000347805ULL, 0x000fe2000001ff00ULL,
0x00000000003a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000387805ULL, 0x01cfc4000001ff00ULL,
0x000000010600780cULL, 0x040fe20003f25270ULL, 0x00000c0000007945ULL, 0x000fe20003800000ULL,
0x00000001610c7810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff0a7224ULL, 0x000fe200078e0006ULL,
0x00000001060b7810ULL, 0x000fe20007ffe0ffULL, 0x0000007160097224ULL, 0x010fc600078e02ffULL,
0x000000020b00780cULL, 0x040fe20003f06070ULL, 0x000000ffff067224ULL, 0x000fe200078e000bULL,
0x000000ff0b087207ULL, 0x000fc60000800000ULL, 0x000000ffff0c1224ULL, 0x000fca00078e0261ULL,
0x000000010c047810ULL, 0x000fc80007ffe0ffULL, 0x000000690400720cULL, 0x000fe40003f46070ULL,
0x0000000107047812ULL, 0x000fd600078e0cffULL, 0x000006000000a947ULL, 0x020fea0003800000ULL,
0x00000010030b7824ULL, 0x002fe200078e00ffULL, 0x00000002ff417819ULL, 0x000fe20000011603ULL,
0x000001000c167824ULL, 0x000fe400078e0275ULL, 0x000000ffff0d7224ULL, 0x000fe200078e00ffULL,
0x000000300b0b7812ULL, 0x000fe200078ec0ffULL, 0x00000001020f7824ULL, 0x000fe200078e0241ULL,
0x00000010413d7810ULL, 0x040fe20007ffe0ffULL, 0x00000002001d7824ULL, 0x000fe200078e0204ULL,
0x00000008411f7810ULL, 0x000fe20007ffe0ffULL, 0x00000040080c7824ULL, 0x000fe200078e020bULL,
0x00006200090b7a11ULL, 0x000fe200078238ffULL, 0x0000000102177824ULL, 0x000fe200078e023dULL,
0x0000001667137217ULL, 0x000fe20007800000ULL, 0x000000800f0e7825ULL, 0x000fe200078e000cULL,
0x0000630009097a11ULL, 0x000fc400008f3cffULL, 0x0000001841477810ULL, 0x000fe20007ffe0ffULL,
0x0000000102117824ULL, 0x000fe200078e021fULL, 0x0000000b0e127210ULL, 0x000fe20007f3e0ffULL,
0x00000001131c7824ULL, 0x000fe200078e0a16ULL, 0x00000003030e7211ULL, 0x000fe200078fe8ffULL,
0x0000008017167825ULL, 0x100fe200078e000cULL, 0x0000002041497810ULL, 0x000fe40007ffe0ffULL,
0x000000030e1e7812ULL, 0x000fe200078ec0ffULL, 0x0000008011107825ULL, 0x000fe200078e000cULL,
0x000010001d1d7811ULL, 0x000fc400078e60ffULL, 0x0ffffffc1e3c7812ULL, 0x000fe200078ef803ULL,
0x000000010f137824ULL, 0x000fe200008e0609ULL, 0x0000000b16167210ULL, 0x080fe20007f3e0ffULL,
0x00000001020f7824ULL, 0x000fe200078e0247ULL, 0x0000000b10147210ULL, 0x080fe20007f5e0ffULL,
0x000000043d3f7824ULL, 0x000fe200078e00ffULL, 0x00000028414b7810ULL, 0x000fe20007ffe0ffULL,
0x000000800f0e7825ULL, 0x000fe200078e000cULL, 0x00000030414d7810ULL, 0x040fe40007ffe0ffULL,
0x00000038414f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000117177824ULL, 0x100fe200008e0609ULL,
0x0000001c4100720cULL, 0x080fe20003f26070ULL, 0x0000000111157824ULL, 0x000fe200010e0609ULL,
0x0000001c1f00720cULL, 0x0c0fe20003f46070ULL, 0x000000041f1f7824ULL, 0x000fe200078e00ffULL,
0x0000000b0e0e7210ULL, 0x000fe20007f7e0ffULL, 0x0000000102117824ULL, 0x040fe200078e0249ULL,
0x0000001c4700720cULL, 0x080fe20003fa6070ULL, 0x0000000102417824ULL, 0x000fe200078e024bULL,
0xfffffffc1f3e7812ULL, 0x100fe200078ee21eULL, 0x000000010f0f7824ULL, 0x000fe200018e0609ULL,
0x0000001c3d00720cULL, 0x000fe20003f66070ULL, 0x000000103c1f7824ULL, 0x000fe200078e021dULL,
0xfffffffc3f3c7812ULL, 0x000fe200078ee21eULL, 0x0000008011107825ULL, 0x000fc600078e000cULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000121f7faeULL, 0x0003e2000c901c48ULL,
0x000000103e3d7824ULL, 0x000fe200078e021dULL, 0x0000000b10107210ULL, 0x000fe20007f9e0ffULL,
0x0000000102437824ULL, 0x000fe200078e024dULL, 0x0000001c4f00720cULL, 0x080fe20003f26070ULL,
0x000000103c3f7824ULL, 0x000fe200078e021dULL, 0x00000000143d7faeULL, 0x0005e2000d101c48ULL,
0x0000000111117824ULL, 0x000fe200020e0609ULL, 0x0000001c4900720cULL, 0x080fe20003f86070ULL,
0x0000000102457824ULL, 0x000fe200078e024fULL, 0x00000000163f7faeULL, 0x0007e2000d901c48ULL,
0x0000000447477824ULL, 0x000fe200078e00ffULL, 0x0000001c4b00720cULL, 0x080fe20003f66070ULL,
0x0000008041127825ULL, 0x002fe200078e000cULL, 0x0000001c4d00720cULL, 0x000fc60003f46070ULL,
0x0000000449497824ULL, 0x000fe200078e00ffULL, 0x0000000b12127210ULL, 0x000fe20007fde0ffULL,
0x0000008043147825ULL, 0x004fe200078e000cULL, 0xfffffffc47167812ULL, 0x008fc600078ee21eULL,
0x0000000113137824ULL, 0x000fe200030e0609ULL, 0x0000000b14147210ULL, 0x000fe20007fde0ffULL,
0x000000044b4b7824ULL, 0x000fe200078e00ffULL, 0xfffffffc491c7812ULL, 0x000fe200078ee21eULL,
0x000000044d4d7824ULL, 0x000fe400078e00ffULL, 0x00000080450c7825ULL, 0x000fe200078e000cULL,
0xfffffffc4b3c7812ULL, 0x100fe400078ee21eULL, 0xfffffffc4d3e7812ULL, 0x000fe200078ee21eULL,
0x000000044f4f7824ULL, 0x000fc400078e00ffULL, 0x0000000115157824ULL, 0x000fe200030e0609ULL,
0x0000000b0c0c7210ULL, 0x000fe20007fde0ffULL, 0x0000001016177824ULL, 0x100fe200078e021dULL,
0xfffffffc4f1e7812ULL, 0x000fe200078ee21eULL, 0x000000101c1f7824ULL, 0x100fe400078e021dULL,
0x000000103c0b7824ULL, 0x100fe200078e021dULL, 0x000000000e177faeULL, 0x0003e2000e901c48ULL,
0x000000103e3d7824ULL, 0x100fe400078e021dULL, 0x000000101e1d7824ULL, 0x000fe200078e021dULL,
0x00000000101f7faeULL, 0x0003e2000e101c48ULL, 0x000000010d0d7824ULL, 0x000fc600030e0609ULL,
0x00000000120b7faeULL, 0x0003e8000d901c48ULL, 0x00000000143d7faeULL, 0x0003e8000d101c48ULL,
0x000000000c1d7faeULL, 0x0003e2000c901c48ULL, 0x0000053000007947ULL, 0x000fea0003800000ULL,
0x0000000803117811ULL, 0x042fe200078ff0ffULL, 0x00000002000d7824ULL, 0x000fe200078e0204ULL,
0x0000001003157811ULL, 0x000fc400078ff0ffULL, 0x00000018031d7811ULL, 0x000fe200078ff0ffULL,
0x00000004113d7824ULL, 0x000fe200078e00ffULL, 0x00000020034d7811ULL, 0x000fe200078ff0ffULL,
0x00000004153f7824ULL, 0x000fe200078e00ffULL, 0x00000028034f7811ULL, 0x000fe200078ff0ffULL,
0x000000041d417824ULL, 0x000fe200078e00ffULL, 0x0000003003517811ULL, 0x000fe200078ff0ffULL,
0x000000044d437824ULL, 0x000fe200078e00ffULL, 0x0000003803537811ULL, 0x000fe200078ff0ffULL,
0x000000044f457824ULL, 0x000fe200078e00ffULL, 0x00000003030b7211ULL, 0x000fe200078fe8ffULL,
0x0000000451477824ULL, 0x000fe200078e00ffULL, 0x000010000d0e7811ULL, 0x000fe200078e60ffULL,
0x0000000453497824ULL, 0x000fe200078e00ffULL, 0x000000030b0c7812ULL, 0x000fe200078ec0ffULL,
0x0000000102177824ULL, 0x040fe200078e0211ULL, 0x0000000203137211ULL, 0x000fe200078ff0ffULL,
0x00000001021f7824ULL, 0x040fe200078e0215ULL, 0xfffffffc3d3d7812ULL, 0x100fe200078ee20cULL,
0x00000001021d7824ULL, 0x040fe200078e021dULL, 0xfffffffc3f3f7812ULL, 0x100fe200078ee20cULL,
0x0000000102157824ULL, 0x000fe200078e024dULL, 0xfffffffc41417812ULL, 0x000fe200078ee20cULL,
0x000000103d3d7824ULL, 0x000fe200078e020eULL, 0xfffffffc43437812ULL, 0x000fe200078ee20cULL,
0x000000103f3f7824ULL, 0x000fe200078e020eULL, 0xfffffffc45457812ULL, 0x000fe200078ee20cULL,
0x0000001041417824ULL, 0x100fe200078e020eULL, 0x0ffffffc0c0b7812ULL, 0x000fe200078ef803ULL,
0x0000001043437824ULL, 0x000fe200078e020eULL, 0xfffffffc47477812ULL, 0x000fe200078ee20cULL,
0x0000001045457824ULL, 0x000fe200078e020eULL, 0xfffffffc49497812ULL, 0x000fe200078ee20cULL,
0x00000010030c7824ULL, 0x000fe200078e00ffULL, 0x00006200094b7a11ULL, 0x000fe200078238ffULL,
0x000000100b0b7824ULL, 0x000fc400078e020eULL, 0x0000001047477824ULL, 0x100fe200078e020eULL,
0x000000300c0f7812ULL, 0x000fe200078ec0ffULL, 0x0000001049497824ULL, 0x000fe200078e020eULL,
0x0000630009097a11ULL, 0x000fe200008f3cffULL, 0x0000000102117824ULL, 0x000fe400078e024fULL,
0x00000040080e7824ULL, 0x000fe400078e020fULL, 0x000000ffff0f7224ULL, 0x000fe400078e00ffULL,
0x00000001020d7824ULL, 0x000fc400078e0251ULL, 0x0000008013127825ULL, 0x000fc800078e000eULL,
0x0000008017167825ULL, 0x000fe200078e000eULL, 0x0000004b12127210ULL, 0x000fc60007f3e0ffULL,
0x000000801f1e7825ULL, 0x000fe200078e000eULL, 0x0000004b16167210ULL, 0x000fc60007f5e0ffULL,
0x000000801d1c7825ULL, 0x000fe200078e000eULL, 0x0000004b1e1e7210ULL, 0x000fc60007f7e0ffULL,
0x0000000102537824ULL, 0x000fe200078e0253ULL, 0x0000004b1c1c7210ULL, 0x000fe20007f9e0ffULL,
0x0000008015147825ULL, 0x000fc800078e000eULL, 0x0000008011107825ULL, 0x000fc800078e000eULL,
0x000000800d0c7825ULL, 0x000fc800078e000eULL, 0x00000080530e7825ULL, 0x000fc800078e000eULL,
0x0000000113137824ULL, 0x100fe200008e0609ULL, 0x0000004b14147210ULL, 0x080fe20007f3e0ffULL,
0x0000000117177824ULL, 0x100fe200010e0609ULL, 0x0000004b10107210ULL, 0x080fe20007f5e0ffULL,
0x000000011f1f7824ULL, 0x100fe200018e0609ULL, 0x0000004b0c0c7210ULL, 0x080fe20007f7e0ffULL,
0x000000011d1d7824ULL, 0x100fe200020e0609ULL, 0x0000004b0e0e7210ULL, 0x000fe20007f9e0ffULL,
0x0000000115157824ULL, 0x100fe200008e0609ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000120b7faeULL, 0x0003e2000b901c48ULL, 0x0000000111117824ULL, 0x000fc400010e0609ULL,
0x000000010d0d7824ULL, 0x100fe200018e0609ULL, 0x00000000163d7faeULL, 0x0003e2000b901c48ULL,
0x000000010f0f7824ULL, 0x000fc600020e0609ULL, 0x000000001e3f7faeULL, 0x0003e8000b901c48ULL,
0x000000001c417faeULL, 0x0003e8000b901c48ULL, 0x0000000014437faeULL, 0x0003e8000b901c48ULL,
0x0000000010457faeULL, 0x0003e8000b901c48ULL, 0x000000000c477faeULL, 0x0003e8000b901c48ULL,
0x000000000e497faeULL, 0x0003e4000b901c48ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000010800780cULL, 0x000fe20003f25270ULL, 0x000000a000007945ULL, 0x000fd80003800000ULL,
0x0000008000001947ULL, 0x000fea0003800000ULL, 0x0000000405057810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff607424ULL, 0x000fc600078e00ffULL, 0x000000680500720cULL, 0x000fda0003f26070ULL,
0x0000004000001947ULL, 0x000fea0003800000ULL, 0x0000000270087824ULL, 0x000fe400078e0205ULL,
0x00000004ff097424ULL, 0x000fc800078e00ffULL, 0x0000640008087625ULL, 0x000fca00078e0009ULL,
0x0000000808607981ULL, 0x000524000c1e1900ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000000000079afULL, 0x000e220000000000ULL, 0x00000020030c7810ULL, 0x042fe20007ffe0ffULL,
0x0000000200077824ULL, 0x000fe200078e0207ULL, 0xfffffff803087812ULL, 0x044fe200078ec0ffULL,
0x000000ffff097224ULL, 0x000fe200078e00ffULL, 0xfffffff80c0c7812ULL, 0x000fe400078ec0ffULL,
0x00000007030e7812ULL, 0x000fe400078ec0ffULL, 0x00000007080b7812ULL, 0x100fe400078ef803ULL,
0x000000070c0c7812ULL, 0x000fc400078ef803ULL, 0x0000100007077811ULL, 0x000fe400078e60ffULL,
0x000000080e087812ULL, 0x000fe400078ef803ULL, 0x00000001ff637819ULL, 0x000fe4000001160bULL,
0x00000001ff627819ULL, 0x000fe2000001160cULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0x00000001630d7824ULL, 0x000fe200078e0209ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x000000040b0e7824ULL, 0x000fe200078e00ffULL, 0x00000001090f7810ULL, 0x000fe20007ffe0ffULL,
0x000000040c147824ULL, 0x000fc400078e00ffULL, 0x000000040a6e7824ULL, 0x000fe200078e0209ULL,
0xfffffffc0e0e7812ULL, 0x000fe200078ee20dULL, 0x00000001620d7824ULL, 0x000fe200078e0209ULL,
0x0000000209097810ULL, 0x000fe20007ffe0ffULL, 0x000000026e6e7824ULL, 0x000fe400078e00ffULL,
0x000000100e0e7824ULL, 0x000fe200078e0207ULL, 0xfffffffc14147812ULL, 0x000fe400078ee20dULL,
0x000000040900780cULL, 0x000fe40003f25270ULL, 0x000000000e10783bULL, 0x020e620000000200ULL,
0x0000001014147824ULL, 0x000fcc00078e0207ULL, 0x000000001414783bULL, 0x000ea20000000200ULL,
0x00010000110e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff457819ULL, 0x000fe20000011410ULL,
0x00010000100d7824ULL, 0x040fe200078e00ffULL, 0x00000018ff477819ULL, 0x000fe40000011411ULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x00000018ff0d7819ULL, 0x000fe2000001140dULL,
0x0000004500457306ULL, 0x000fe20000200c00ULL, 0x0000888010447816ULL, 0x040fe200000000ffULL,
0x0000010010107824ULL, 0x000fe200078e00ffULL, 0x0000888011467816ULL, 0x040fe200000000ffULL,
0x0000010011117824ULL, 0x000fe200078e00ffULL, 0x00000018ff4c7819ULL, 0x000fc40000011412ULL,
0x00000018ff107819ULL, 0x000fe20000011410ULL, 0x0000000e00497306ULL, 0x0003e20000200c00ULL,
0x00000018ff117819ULL, 0x000fe40000011411ULL, 0x00008880124e7816ULL, 0x000fe400000000ffULL,
0x00000018ff557819ULL, 0x004fe40000011414ULL, 0x0000888014547816ULL, 0x000fe200000000ffULL,
0x0000000d00437306ULL, 0x0005e20000200c00ULL, 0x00010000130e7824ULL, 0x002fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fc40000011415ULL, 0x00000018ff577819ULL, 0x000fe40000011416ULL,
0x00000018ff0e7819ULL, 0x000fe4000001140eULL, 0x00000010004a7306ULL, 0x0002e20000200c00ULL,
0x00010000120d7824ULL, 0x044fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fe20000011417ULL,
0x0000010012127824ULL, 0x000fe200078e00ffULL, 0x00008880155b7816ULL, 0x000fe400000000ffULL,
0x00000018ff0d7819ULL, 0x000fc4000001140dULL, 0x0000001100487306ULL, 0x0005e20000200c00ULL,
0x0000000163107824ULL, 0x102fe200078e020fULL, 0x00000018ff127819ULL, 0x000fe20000011412ULL,
0x00000001620f7824ULL, 0x000fe200078e020fULL, 0x0000888016597816ULL, 0x000fe400000000ffULL,
0x00008880174f7816ULL, 0x000fe400000000ffULL, 0x0000000e00667306ULL, 0x0003e20000200c00ULL,
0x000000040b117824ULL, 0x004fe200078e00ffULL, 0x00000018ff537819ULL, 0x000fc40000011413ULL,
0x0000888013527816ULL, 0x040fe200000000ffULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0xfffffffc11107812ULL, 0x000fe400078ee210ULL, 0x0000000d006c7306ULL, 0x0005e20000200c00ULL,
0x00010000150e7824ULL, 0x042fe200078e00ffULL, 0x00000018ff137819ULL, 0x000fe20000011413ULL,
0x0000001010107824ULL, 0x000fe200078e0207ULL, 0x000054104a457816ULL, 0x008fe20000000045ULL,
0x0000010015157824ULL, 0x000fe200078e00ffULL, 0x00000018ff0e7819ULL, 0x000fc4000001140eULL,
0x00000012006b7306ULL, 0x0003e20000200c00ULL, 0x00010000140d7824ULL, 0x044fe200078e00ffULL,
0x00000000101c783bULL, 0x0004e20000000200ULL, 0x0000010014147824ULL, 0x000fe200078e00ffULL,
0x00000018ff157819ULL, 0x000fe40000011415ULL, 0x00000018ff0d7819ULL, 0x000fe4000001140dULL,
0x0000000e005d7306ULL, 0x0005e20000200c00ULL, 0x000000040c127824ULL, 0x002fe200078e00ffULL,
0x00000018ff147819ULL, 0x000fcc0000011414ULL, 0x0000000d005f7306ULL, 0x0003e20000200c00ULL,
0xfffffffc120e7812ULL, 0x004fca00078ee20fULL, 0x000000100e107824ULL, 0x000fe400078e0207ULL,
0x00010000170e7824ULL, 0x040fe200078e00ffULL, 0x00000014005e7306ULL, 0x000fe20000200c00ULL,
0x00010000160d7824ULL, 0x042fe400078e00ffULL, 0x0000010016167824ULL, 0x000fe200078e00ffULL,
0x00000018ff0e7819ULL, 0x000fe2000001140eULL, 0x0000010017177824ULL, 0x000fe200078e00ffULL,
0x00000018ff0d7819ULL, 0x000fe4000001140dULL, 0x0000000e004b7306ULL, 0x0003e20000200c00ULL,
0x00000018ff167819ULL, 0x000fc40000011416ULL, 0x00000018ff177819ULL, 0x000fca0000011417ULL,
0x0000000d00587306ULL, 0x0005e20000200c00ULL, 0x00000010080e7824ULL, 0x002fe200078e00ffULL,
0x00000018ff417819ULL, 0x008fe2000001141cULL, 0x000100001c427824ULL, 0x000fe200078e00ffULL,
0x00000018ff407819ULL, 0x000fe4000001141dULL, 0x000088801d4a7816ULL, 0x000fe400000000ffULL,
0x00000015005c7306ULL, 0x000fe20000200c00ULL, 0x0000006e030d7211ULL, 0x004fe400078fe0ffULL,
0x000088801e4d7816ULL, 0x000fc400000000ffULL, 0x000000026e6e7810ULL, 0x000fe20007ffe0ffULL,
0x00000001080d7824ULL, 0x000fe200078e020dULL, 0x00000018ff3f7819ULL, 0x000fe2000001141eULL,
0x0000001600567306ULL, 0x000fe20000200c00ULL, 0x00000018ff3e7819ULL, 0x000fe4000001141fULL,
0xfffffff00e0d7812ULL, 0x000fe400078ee20dULL, 0x000088801c0e7816ULL, 0x040fe200000000ffULL,
0x000001001c1c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff427819ULL, 0x000fe20000011442ULL,
0x000000100d147824ULL, 0x000fe200078e00ffULL, 0x0000001700507306ULL, 0x0003e40000200c00ULL,
0x00000018ff1c7819ULL, 0x000fcc000001141cULL, 0x0000004400447306ULL, 0x000ea20000200c00ULL,
0x000000001414783bULL, 0x002e6e0000000200ULL, 0x0000004600467306ULL, 0x000ee20000200c00ULL,
0x0000541044447816ULL, 0x004fce0000000043ULL, 0x0000004700477306ULL, 0x000eb00000200c00ULL,
0x0000001300657306ULL, 0x0005f00000200c00ULL, 0x0000001c00437306ULL, 0x0007e20000200c00ULL,
0x000000001010783bULL, 0x004ea20000000200ULL, 0x000000441438723cULL, 0x002be20000001838ULL,
0x00005410461c7816ULL, 0x008fca0000000049ULL, 0x0000004c004c7306ULL, 0x000e620000200c00ULL,
0x000088801f497816ULL, 0x000fe200000000ffULL, 0x000100001d457824ULL, 0x060fe400078e00ffULL,
0x000001001d1d7824ULL, 0x000fc800078e00ffULL, 0x0000004e004e7306ULL, 0x000fe20000200c00ULL,
0x00000018ff457819ULL, 0x000fe40000011445ULL, 0x00000018ff1d7819ULL, 0x000fca000001141dULL,
0x0000001d00467306ULL, 0x0007f00000200c00ULL, 0x0000005500557306ULL, 0x000e620000200c00ULL,
0x00005410481d7816ULL, 0x008fe20000000047ULL, 0x000100001e487824ULL, 0x000fc400078e00ffULL,
0x000001001e1e7824ULL, 0x000fc600078e00ffULL, 0x00000018ff487819ULL, 0x000fe20000011448ULL,
0x0000001c1434723cULL, 0x000be20000001834ULL, 0x0000004d00477306ULL, 0x000fe20000200c00ULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x00000018ff0d7819ULL, 0x004fe40000011413ULL,
0x00000018ff3d7819ULL, 0x000fe20000011410ULL, 0x000100001f1c7824ULL, 0x020fe200078e00ffULL,
0x000054106b1d7816ULL, 0x002fe2000000004cULL, 0x0000005400547306ULL, 0x000e620000200c00ULL,
0x000001001f1f7824ULL, 0x000fe200078e00ffULL, 0x000054105e557816ULL, 0x000fe20000000055ULL,
0x00000100115e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x00000018ff1f7819ULL, 0x000fe4000001141fULL, 0x0000001c004d7306ULL, 0x0005e20000200c00ULL,
0x00000018ff3c7819ULL, 0x000fe40000011411ULL, 0x00000018ff0f7819ULL, 0x000fca0000011412ULL,
0x0000005300537306ULL, 0x000fe20000200c00ULL, 0x000054104e1c7816ULL, 0x004fe4000000006cULL,
0x00008880106c7816ULL, 0x000fe400000000ffULL, 0x0000541054547816ULL, 0x002fc6000000005fULL,
0x0000001c1430723cULL, 0x000b620000001830ULL, 0x0000005200527306ULL, 0x000e620000200c00ULL,
0x000000ffff4c7224ULL, 0x000fe400078e006cULL, 0x00000010086c7824ULL, 0x000fc600078e00ffULL,
0x0000006e031d7211ULL, 0x020fe200078fe0ffULL, 0x00000100101c7824ULL, 0x000fe200078e00ffULL,
0x0000005a005a7306ULL, 0x000ea20000200c00ULL, 0x000000541428723cULL, 0x000be40000001828ULL,
0x00000001081d7824ULL, 0x000fca00078e021dULL, 0x0000005b005b7306ULL, 0x000ee20000200c00ULL,
0xfffffff06c1d7812ULL, 0x000fe400078ee21dULL, 0x00000018ff6c7819ULL, 0x000fe4000001141cULL,
0x00005410521c7816ULL, 0x002fe40000000066ULL, 0x0000888011667816ULL, 0x000fe200000000ffULL,
0x0000004a00447306ULL, 0x000fe20000200c00ULL, 0x000054105c557816ULL, 0x024fe4000000005aULL,
0x00000018ff5a7819ULL, 0x000fca000001145eULL, 0x0000001e004a7306ULL, 0x0003e20000200c00ULL,
0x000054105b547816ULL, 0x008fe4000000005dULL, 0x00008880125b7816ULL, 0x000fca00000000ffULL,
0x0000005700577306ULL, 0x000ea20000200c00ULL, 0x00010000101e7824ULL, 0x002fe200078e00ffULL,
0x000000541424723cULL, 0x000be80000001824ULL, 0x00000018ff6b7819ULL, 0x000fe2000001141eULL,
0x000000101d1e7824ULL, 0x000fe200078e00ffULL, 0x0000005900597306ULL, 0x000e620000200c00ULL,
0x00005410651d7816ULL, 0x000fe20000000053ULL, 0x0001000011657824ULL, 0x000fc400078e00ffULL,
0x000000ffff537224ULL, 0x000fc600078e0066ULL, 0x00000018ff657819ULL, 0x000fe20000011465ULL,
0x0000005100517306ULL, 0x000fe20000200c00ULL, 0x0000001c142c723cULL, 0x000b64000000182cULL,
0x0000541056557816ULL, 0x024fe20000000057ULL, 0x0001000012577824ULL, 0x000fe400078e00ffULL,
0x000000ffff567224ULL, 0x000fe400078e005bULL, 0x0000004f004f7306ULL, 0x000ea20000200c00ULL,
0x0000541059547816ULL, 0x002fc40000000058ULL, 0x00000018ff577819ULL, 0x000fca0000011457ULL,
0x0000001f004e7306ULL, 0x0003e20000200c00ULL, 0x000000541420723cULL, 0x000b6e0000001820ULL,
0x0000000e000e7306ULL, 0x000fe20000200c00ULL, 0x000000001e1c783bULL, 0x002e620000000200ULL,
0x000054104f547816ULL, 0x024fc4000000004bULL, 0x0000541050557816ULL, 0x000fc80000000051ULL,
0x0000004200427306ULL, 0x000ea60000200c00ULL, 0x000000541418723cULL, 0x000b6a0000001818ULL,
0x0000003f003f7306ULL, 0x000ee40000200c00ULL, 0x0000010012147824ULL, 0x020fc400078e00ffULL,
0x0001000013167824ULL, 0x000fc800078e00ffULL, 0x0000004800487306ULL, 0x000e620000200c00ULL,
0x000054100e427816ULL, 0x004fe40000000042ULL, 0x00000018ff0e7819ULL, 0x000fe40000011414ULL,
0x0000888013147816ULL, 0x040fe200000000ffULL, 0x0000010013137824ULL, 0x000fe200078e00ffULL,
0x00000018ff167819ULL, 0x000fe20000011416ULL, 0x0000003e003e7306ULL, 0x000fe20000200c00ULL,
0x000054104a157816ULL, 0x008fe4000000003fULL, 0x00000018ff137819ULL, 0x000fca0000011413ULL,
0x0000004900497306ULL, 0x000eb00000200c00ULL, 0x0000001400177306ULL, 0x0003f00000200c00ULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x0000541047147816ULL, 0x002fce0000000048ULL,
0x000000141c30723cULL, 0x040b620000001830ULL, 0x0000006b00107306ULL, 0x000e6c0000200c00ULL,
0x0000541049147816ULL, 0x024fe4000000004dULL, 0x000054104e157816ULL, 0x000fe2000000003eULL,
0x0000004500457306ULL, 0x000eac0000200c00ULL, 0x000000141c2c723cULL, 0x000b62000000182cULL,
0x000054104c4c7816ULL, 0x002fe20000000010ULL, 0x0000005300537306ULL, 0x000ff00000200c00ULL,
0x0000006500117306ULL, 0x000e620000200c00ULL, 0x0000541044447816ULL, 0x004fce0000000045ULL,
0x0000001600167306ULL, 0x000eb00000200c00ULL, 0x0000004100417306ULL, 0x000ee20000200c00ULL,
0x0000541053107816ULL, 0x002fce0000000011ULL, 0x0000004000407306ULL, 0x000e620000200c00ULL,
0x0000541017167816ULL, 0x004fce0000000016ULL, 0x0000003d003d7306ULL, 0x000fe20000200c00ULL,
0x0000541043437816ULL, 0x008fce0000000041ULL, 0x0000003c003c7306ULL, 0x000fe20000200c00ULL,
0x0000541046457816ULL, 0x002fe20000000040ULL, 0x000000421c38723cULL, 0x040b6c0000001838ULL,
0x0000000f000f7306ULL, 0x000fe40000200c00ULL, 0x000000441c34723cULL, 0x000b6c0000001834ULL,
0x0000000d000d7306ULL, 0x000ff00000200c00ULL, 0x0000006c00527306ULL, 0x000e700000200c00ULL,
0x0000005a005a7306ULL, 0x000eb00000200c00ULL, 0x0000005600567306ULL, 0x000fe20000200c00ULL,
0x00005410524d7816ULL, 0x002fce000000003dULL, 0x0000005700127306ULL, 0x000e620000200c00ULL,
0x000054105a117816ULL, 0x004fe2000000003cULL, 0x0000004c1c28723cULL, 0x040b6c0000001828ULL,
0x0000000e000e7306ULL, 0x000ea40000200c00ULL, 0x000000101c24723cULL, 0x000b6c0000001824ULL,
0x0000001300147306ULL, 0x0204e20000200c00ULL, 0x0000541056127816ULL, 0x002fc40000000012ULL,
0x000054100e137816ULL, 0x004fe4000000000fULL, 0x0000541014177816ULL, 0x008fca000000000dULL,
0x000000121c20723cULL, 0x040b700000001820ULL, 0x000000161c18723cULL, 0x000b620000001818ULL,
0xfffff05000001947ULL, 0x000fce000383ffffULL, 0x0000000000007918ULL, 0x000fd20000000000ULL,
0x000000ffff077224ULL, 0x000fe200078e0004ULL, 0x0000001000000944ULL, 0x000fe20003c00000ULL,
0xffffe25000007947ULL, 0x000fea000383ffffULL, 0x0000000000007918ULL, 0x000fdc0000000000ULL,
0x0000006431317220ULL, 0x080fe20000410000ULL, 0x0000006439397220ULL, 0x080fe20000410000ULL,
0x0000006434347220ULL, 0x080fe20000410000ULL, 0x0000006435357220ULL, 0x080fe20000410000ULL,
0x0000006430307220ULL, 0x080fe20000410000ULL, 0x000000642c067220ULL, 0x080fe20000410000ULL,
0x0000006428077220ULL, 0x080fe20000410000ULL, 0x00000064331f7220ULL, 0x0a0fe20000410000ULL,
0x000000642e0a7220ULL, 0x080fe20000410000ULL, 0x000000642a0c7220ULL, 0x080fe20000410000ULL,
0x0000006427157220ULL, 0x080fe20000410000ULL, 0x000000642d337220ULL, 0x080fe20000410000ULL,
0x000000642f0b7220ULL, 0x080fe20000410000ULL, 0x000000642b127220ULL, 0x080fe20000410000ULL,
0x00000064242a7220ULL, 0x080fe20000410000ULL, 0x00000064252e7220ULL, 0x080fe20000410000ULL,
0x0000006426147220ULL, 0x080fe20000410000ULL, 0x00000064230e7220ULL, 0x080fe20000410000ULL,
0x000000ffff277224ULL, 0x000fe200078e0031ULL, 0x0000006438137220ULL, 0x080fe20000410000ULL,
0x000000643a1e7220ULL, 0x080fe20000410000ULL, 0x000000643b167220ULL, 0x080fe20000410000ULL,
0x0000006436177220ULL, 0x080fe20000410000ULL, 0x0000006437377220ULL, 0x080fe20000410000ULL,
0x0000006432327220ULL, 0x080fe20000410000ULL, 0x0000006429297220ULL, 0x080fe20000410000ULL,
0x00000064202d7220ULL, 0x080fe20000410000ULL, 0x00000064212b7220ULL, 0x080fe20000410000ULL,
0x00000064220d7220ULL, 0x080fe20000410000ULL, 0x0000006418237220ULL, 0x080fe20000410000ULL,
0x0000006419247220ULL, 0x080fe20000410000ULL, 0x000000641a0f7220ULL, 0x080fe20000410000ULL,
0x000000641b1c7220ULL, 0x000fe20000410000ULL, 0x000000ffff257224ULL, 0x000fc400078e0039ULL,
0x000000ffff267224ULL, 0x000fe400078e0034ULL, 0x000000ffff2f7224ULL, 0x000fe400078e0035ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0030ULL, 0x000000ffff287224ULL, 0x000fe400078e0006ULL,
0x000000ffff317224ULL, 0x000fe200078e0007ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000074087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff207224ULL, 0x000fc400078e0032ULL,
0x000000ffff307224ULL, 0x000fe400078e0037ULL, 0x000000ffff217224ULL, 0x000fe400078e000aULL,
0x000000ffff327224ULL, 0x000fe400078e000bULL, 0x000000ffff227224ULL, 0x000fe400078e000cULL,
0x000000ffff197224ULL, 0x000fe400078e000dULL, 0x000000ffff1a7224ULL, 0x000fc400078e000eULL,
0x000000ffff1b7224ULL, 0x000fc400078e000fULL, 0x0000000000067805ULL, 0x002fca0000015200ULL,
0x00000400740b7984ULL, 0x000e640000000800ULL, 0x800000000bff7812ULL, 0x006fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0c7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100c00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000000a7805ULL, 0x000fcc0000015200ULL, 0x0000000a060d7210ULL, 0x000fca0007f1e1ffULL,
0x000000010b0b7824ULL, 0x000fe200000e0e07ULL, 0x003d09000d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0b00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0b00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff0a7819ULL, 0x000fc8000001140bULL,
0x0000000d0a0a7211ULL, 0x000fca00078110ffULL, 0x000000ffff0b7224ULL, 0x000fca00000e060bULL,
0x000000020a0a7819ULL, 0x000fc8000000120bULL, 0x0000000a0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010c0c7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400740b7984ULL, 0x000e640000000800ULL,
0x800000000bff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000004031d7824ULL, 0x000fe200078e00ffULL, 0x000000726100720cULL, 0x000fc80003f06070ULL,
0xfffffff01d077812ULL, 0x000fca00078ec0ffULL, 0x0000008000187824ULL, 0x000fca00078e0207ULL,
0x00f4000018087984ULL, 0x0002a20000000c00ULL, 0x0000136000008947ULL, 0x000fea0003800000ULL,
0x0000010061347824ULL, 0x000fe200078e0275ULL, 0x0000006f03067211ULL, 0x040fe200078ff0ffULL,
0x0000000203357824ULL, 0x000fe400078e00ffULL, 0x00000002ff4a7424ULL, 0x000fe200078e00ffULL,
0x0000003467077217ULL, 0x000fe40007800000ULL, 0x0000000635357812ULL, 0x000fe400078ec0ffULL,
0x00005a00ff0c7a19ULL, 0x000fe20000011606ULL, 0x0000000107347824ULL, 0x000fe200078e0a34ULL,
0x0000580035377a10ULL, 0x000fe20007ffe0ffULL, 0x000000016a077824ULL, 0x000fe200078e0235ULL,
0x0000000c730c7217ULL, 0x000fc40003800000ULL, 0x000000343700720cULL, 0x080fe20003f06070ULL,
0x0000000107107824ULL, 0x140fe200078e0a34ULL, 0x000000340700720cULL, 0x000fe20003f26070ULL,
0x00000001370e7824ULL, 0x000fe400078e0a34ULL, 0x0000000c6d517224ULL, 0x000fe200078e02ffULL,
0x0000001073107217ULL, 0x040fe40003800000ULL, 0x0000000e730e7217ULL, 0x000fe40003800000ULL,
0x00000004ff107819ULL, 0x000fc40000011610ULL, 0x000000ff0e427207ULL, 0x000fe40000000000ULL,
0x000000ff10107207ULL, 0x000fe40000800000ULL, 0x0000005142077211ULL, 0x000fe400078fe0ffULL,
0x00000008060e7810ULL, 0x000fe20007ffe0ffULL, 0x00000001510d7824ULL, 0x000fe200078e0210ULL,
0x00000010353d7812ULL, 0x000fe200078efcffULL, 0x0000600007067625ULL, 0x000fe200078e004aULL,
0x00005a00ff0e7a19ULL, 0x000fc6000001160eULL, 0x000060000d0c7625ULL, 0x000fe200078e004aULL,
0x000058003d397a10ULL, 0x000fe20007ffe0ffULL, 0x0000000806487981ULL, 0x0046a2000c1e9500ULL,
0x0000000e730e7217ULL, 0x000fc60003800000ULL, 0x000000080c4f7981ULL, 0x0002a2000c1e9500ULL,
0x00000020353b7812ULL, 0x000fe200078efcffULL, 0x0000000e6d537224ULL, 0x000fe400078e02ffULL,
0x0000000139067824ULL, 0x148fe400078e0a34ULL, 0x000000016a077824ULL, 0x000fe200078e023dULL,
0x000000343900720cULL, 0x000fe20003f06070ULL, 0x0000000110117824ULL, 0x000fe200078e0253ULL,
0x0000000673067217ULL, 0x000fe20003800000ULL, 0x00000001070c7824ULL, 0x002fe200078e0a34ULL,
0x000058003b417a10ULL, 0x000fe20007ffe0ffULL, 0x0000600011107625ULL, 0x000fe200078e004aULL,
0x00000053420f7211ULL, 0x000fc400078fe0ffULL, 0x000000ff06367207ULL, 0x000fe20000000000ULL,
0x00000001413c7824ULL, 0x000fe200078e0a34ULL, 0x0000000c730c7217ULL, 0x000fe20003800000ULL,
0x000060000f0e7625ULL, 0x000fe200078e004aULL, 0x000000340700720cULL, 0x080fe20003f26070ULL,
0x00000008104d7981ULL, 0x0002e2000c1e9500ULL, 0x0000005136077211ULL, 0x000fe200078fe0ffULL,
0x000000016a457824ULL, 0x000fe200078e023bULL, 0x00000004ff0c7819ULL, 0x000fe2000001160cULL,
0x000000080e447981ULL, 0x0002e2000c1e9500ULL, 0x000000344100720cULL, 0x000fc40003f06070ULL,
0x0000003c733c7217ULL, 0x000fe20003800000ULL, 0x0000600007067625ULL, 0x000fc600078e004aULL,
0x000000ff3c3c7207ULL, 0x000fe20000000000ULL, 0x00000001453e7824ULL, 0x040fe200078e0a34ULL,
0x0000000806387981ULL, 0x0002e4000c1e9500ULL, 0x000000ff0c0e7207ULL, 0x002fe40000800000ULL,
0x000000344500720cULL, 0x000fe40003f26070ULL, 0x0000003035457812ULL, 0x000fe200078efcffULL,
0x00000001510d7824ULL, 0x000fe200078e020eULL, 0x00000053360f7211ULL, 0x000fe200078fe0ffULL,
0x000000010e117824ULL, 0x000fe200078e0253ULL, 0x0000003e733e7217ULL, 0x000fc40003800000ULL,
0x000000513c077211ULL, 0x000fe200078fe0ffULL, 0x000000016a557824ULL, 0x000fe200078e0245ULL,
0x00000004ff3e7819ULL, 0x000fe2000001163eULL, 0x000060000d0c7625ULL, 0x000fe200078e004aULL,
0x0000580045477a10ULL, 0x000fc60007ffe0ffULL, 0x000060000f0e7625ULL, 0x000fc800078e004aULL,
0x0000600011107625ULL, 0x080fe200078e004aULL, 0x000000ff3e407207ULL, 0x000fe20000800000ULL,
0x000000080c3f7981ULL, 0x0002e4000c1e9500ULL, 0x0000600007067625ULL, 0x000fe400078e004aULL,
0x000000080e3a7981ULL, 0x0002e4000c1e9500ULL, 0x0000000155467824ULL, 0x000fe400078e0a34ULL,
0x0000000810437981ULL, 0x0002e8000c1e9500ULL, 0x00000008063e7981ULL, 0x0002e2000c1e9500ULL,
0x0000004673467217ULL, 0x000fe20003800000ULL, 0x00000001510d7824ULL, 0x002fe200078e0240ULL,
0x000000533c0f7211ULL, 0x000fe200078fe0ffULL, 0x0000000140117824ULL, 0x000fc400078e0253ULL,
0x0000000147067824ULL, 0x040fe200078e0a34ULL, 0x000000344700720cULL, 0x000fe20003f06070ULL,
0x000060000d0c7625ULL, 0x000fe200078e004aULL, 0x000000345500720cULL, 0x000fe40003f26070ULL,
0x0000000673067217ULL, 0x000fe20003800000ULL, 0x000060000f0e7625ULL, 0x080fe200078e004aULL,
0x00000004ff077819ULL, 0x000fe20000011646ULL, 0x000000080c497981ULL, 0x0002e4000c1e9500ULL,
0x0000600011107625ULL, 0x000fe200078e004aULL, 0x000000ff06467207ULL, 0x000fe20000000000ULL,
0x000000080e407981ULL, 0x0002e2000c1e9500ULL, 0x000000ff074c7207ULL, 0x000fc60000800000ULL,
0x00000008104b7981ULL, 0x0002e2000c1e9500ULL, 0x0000005146077211ULL, 0x000fe200078fe0ffULL,
0x00000001510d7824ULL, 0x002fc800078e024cULL, 0x0000600007067625ULL, 0x000fc800078e004aULL,
0x000060000d0c7625ULL, 0x000fe400078e004aULL, 0x0000000806067981ULL, 0x0002e2000c1e9500ULL,
0x00000053460f7211ULL, 0x000fc600078fe0ffULL, 0x000000080c0d7981ULL, 0x0002e2000c1e9500ULL,
0x000000014c117824ULL, 0x000fe400078e0253ULL, 0x000060000f0e7625ULL, 0x000fc800078e004aULL,
0x0000600011107625ULL, 0x000fe400078e004aULL, 0x000000080e0e7981ULL, 0x0002e8000c1e9500ULL,
0x0000000810117981ULL, 0x0002e2000c1e9500ULL, 0xfffffff042517812ULL, 0x000fe200078ec0ffULL,
0x00000001ff427424ULL, 0x000fe200078e00ffULL, 0x0000000135077812ULL, 0x002fc600078efcffULL,
0x00000001344a7824ULL, 0x000fe200078e0251ULL, 0x0000000935537812ULL, 0x000fc600078efcffULL,
0x0000000137577824ULL, 0x100fe200078e0a4aULL, 0x0000580007557a10ULL, 0x000fe40007ffe0ffULL,
0x00005800530f7a10ULL, 0x000fe40007ffe0ffULL, 0x0000005742577219ULL, 0x000fe200000006ffULL,
0x0000000155597824ULL, 0x100fe400078e0a4aULL, 0x000000010f5d7824ULL, 0x000fc600078e0a4aULL,
0x0000005942597219ULL, 0x040fe400000006ffULL, 0x0000005d425d7219ULL, 0x000fe400000006ffULL,
0x00000011357d7812ULL, 0x040fe400078efcffULL, 0x00000018357b7812ULL, 0x040fe400078efcffULL,
0x0000001935797812ULL, 0x000fe400078efcffULL, 0x000058007b107a10ULL, 0x000fc40007ffe0ffULL,
0x00005800790c7a10ULL, 0x000fe40007ffe0ffULL, 0x0000002135637812ULL, 0x040fe400078efcffULL,
0x00000028355f7812ULL, 0x000fe400078efcffULL, 0xfffffff046467812ULL, 0x000fe400078ec0ffULL,
0x0000580063777a10ULL, 0x000fe40007ffe0ffULL, 0x000058005f6b7a10ULL, 0x000fe20007ffe0ffULL,
0x00000001344c7824ULL, 0x000fc800078e0246ULL, 0x00000001474e7824ULL, 0x000fca00078e0a4cULL,
0x0000004e424e7219ULL, 0x000fe400000006ffULL, 0x0000541048487816ULL, 0x004fe4000000004fULL,
0x00000008354f7812ULL, 0x000fc800078efcffULL, 0x000058004f517a10ULL, 0x000fe40007ffe0ffULL,
0x0000004857ff7212ULL, 0x000fc6000780c0ffULL, 0x00000001515b7824ULL, 0x000fe200078e0a4aULL,
0x000000343700720cULL, 0x000fc80000701470ULL, 0x0000005b425b7219ULL, 0x000fe400000006ffULL,
0x0000004859ff7212ULL, 0x080fe4000786c0ffULL, 0x000000485bff7212ULL, 0x080fe4000784c0ffULL,
0x000000485dff7212ULL, 0x000fe4000782c0ffULL, 0x000000343500720cULL, 0x000fe40000701070ULL,
0x0000541044447816ULL, 0x008fc4000000004dULL, 0xfffffff036487812ULL, 0x000fe400078ec0ffULL,
0xff80000013137808ULL, 0x000fe40000000000ULL, 0x0000004457ff7212ULL, 0x080fe2000788c0ffULL,
0x0000000134487824ULL, 0x000fe200078e0248ULL, 0x0000004459ff7212ULL, 0x080fe400078ac0ffULL,
0x000000445bff7212ULL, 0x080fe400078cc0ffULL, 0x000000445dff7212ULL, 0x000fc4000780c0ffULL,
0x000058007d447a10ULL, 0x000fe20007ffe0ffULL, 0x0000000139507824ULL, 0x100fe200078e0a48ULL,
0x000000343700720cULL, 0x080fe20002781470ULL, 0x0000000110547824ULL, 0x100fe200078e0a48ULL,
0x000000345100720cULL, 0x080fe200037c1470ULL, 0x0000000144527824ULL, 0x100fe200078e0a48ULL,
0x000000340f00720cULL, 0x000fe20000701470ULL, 0x000000010c567824ULL, 0x000fe200078e0a48ULL,
0x0000005042487219ULL, 0x000fe400000006ffULL, 0xfffffff03c4a7812ULL, 0x000fc400078ec0ffULL,
0x0000005242507219ULL, 0x040fe400000006ffULL, 0x000000343500720cULL, 0x080fe40002781070ULL,
0x000000344f00720cULL, 0x080fe400037c1070ULL, 0x000000345300720cULL, 0x000fe40000701070ULL,
0x0000005442527219ULL, 0x000fe400000006ffULL, 0x00005410383f7816ULL, 0x000fe2000000003fULL,
0x00000001344a7824ULL, 0x000fe200078e024aULL, 0x000000340f00720cULL, 0x000fc40000f21470ULL,
0x000054103a437816ULL, 0x000fe40000000043ULL, 0xff8000001e1e7808ULL, 0x000fe40002000000ULL,
0xff80000017177808ULL, 0x000fe40003000000ULL, 0xff80000030307808ULL, 0x000fe40000000000ULL,
0x0000003f48ff7212ULL, 0x040fe4000788c0ffULL, 0x0000004348ff7212ULL, 0x000fc400078cc0ffULL,
0x0000004352ff7212ULL, 0x000fe2000780c0ffULL, 0x0000000141587824ULL, 0x000fe200078e0a4aULL,
0x000000345300720cULL, 0x080fe40000f21070ULL, 0x000000345500720cULL, 0x0c0fe40001f61470ULL,
0x000000345500720cULL, 0x080fe40002fa1470ULL, 0x000000345100720cULL, 0x080fe40001741470ULL,
0x000000343900720cULL, 0x000fc40002781470ULL, 0x000000343900720cULL, 0x080fe400037c1470ULL,
0x000000341000720cULL, 0x080fe40000701470ULL, 0xff8000002f2f7808ULL, 0x000fe40000800000ULL,
0x00000029355d7812ULL, 0x000fe400078efcffULL, 0x000000340700720cULL, 0x0c0fe40001f61070ULL,
0x000000340700720cULL, 0x000fc40002fa1070ULL, 0x000000344f00720cULL, 0x080fe40001741070ULL,
0x000000343d00720cULL, 0x0c0fe40002721070ULL, 0x000000343d00720cULL, 0x080fe400037c1070ULL,
0x000000347b00720cULL, 0x000fe40000701070ULL, 0x0000005642567219ULL, 0x040fe400000006ffULL,
0x0000005842547219ULL, 0x000fc400000006ffULL, 0x000054103e497816ULL, 0x000fe40000000049ULL,
0x00005410404b7816ULL, 0x000fe4000000004bULL, 0x000058005d657a10ULL, 0x000fe40007ffe0ffULL,
0xff80000025257808ULL, 0x000fe40001800000ULL, 0xff80000016167808ULL, 0x000fe40002800000ULL,
0xff80000026267808ULL, 0x000fc40001000000ULL, 0xff8000002c2c7808ULL, 0x000fe40000800000ULL,
0xff80000020207808ULL, 0x000fe40003000000ULL, 0xff80000021217808ULL, 0x000fe40000000000ULL,
0x0000003f50ff7212ULL, 0x080fe4000786c0ffULL, 0x0000003f52ff7212ULL, 0x080fe400078ac0ffULL,
0x0000003f56ff7212ULL, 0x000fc4000784c0ffULL, 0x0000004350ff7212ULL, 0x080fe4000788c0ffULL,
0x0000004356ff7212ULL, 0x000fe4000782c0ffULL, 0x0000004954ff7212ULL, 0x040fe400078cc0ffULL,
0x0000004b54ff7212ULL, 0x000fe2000780c0ffULL, 0x00000001775a7824ULL, 0x100fe200078e0a4aULL,
0x000000344400720cULL, 0x0c0fe20001f61470ULL, 0x000000016b5c7824ULL, 0x100fe200078e0a4aULL,
0x000000344400720cULL, 0x080fe20002781470ULL, 0x00000001655e7824ULL, 0x000fe200078e0a4aULL,
0x000000341000720cULL, 0x000fc40002fa1470ULL, 0x000000340c00720cULL, 0x0c0fe40001741470ULL,
0x000000340c00720cULL, 0x080fe40000f21470ULL, 0x000000344100720cULL, 0x0c0fe400037c1470ULL,
0x000000344100720cULL, 0x000fe40000701470ULL, 0x0000003135597812ULL, 0x040fe400078efcffULL,
0x0000003835577812ULL, 0x000fc400078efcffULL, 0x00000039354d7812ULL, 0x000fe400078efcffULL,
0x0000005a42587219ULL, 0x000fe400000006ffULL, 0x000000347d00720cULL, 0x0c0fe40001f61070ULL,
0x000000347d00720cULL, 0x080fe40002781070ULL, 0x000000347b00720cULL, 0x080fe40002fa1070ULL,
0x000000347900720cULL, 0x000fc40001741070ULL, 0x000000347900720cULL, 0x080fe40000f21070ULL,
0x000000343b00720cULL, 0x0c0fe400037c1070ULL, 0x000000343b00720cULL, 0x000fe40000701070ULL,
0x0000005c425a7219ULL, 0x040fe400000006ffULL, 0x0000005e425e7219ULL, 0x000fe400000006ffULL,
0x00005410060d7816ULL, 0x000fc4000000000dULL, 0x00005800595b7a10ULL, 0x000fe40007ffe0ffULL,
0x0000580057367a10ULL, 0x000fe40007ffe0ffULL, 0x000058004d3c7a10ULL, 0x000fe40007ffe0ffULL,
0xff80000027277808ULL, 0x000fe40001800000ULL, 0xff8000001f1f7808ULL, 0x000fe40002000000ULL,
0xff80000028287808ULL, 0x000fc40002800000ULL, 0xff80000033337808ULL, 0x000fe40001000000ULL,
0xff80000032327808ULL, 0x000fe40000800000ULL, 0xff80000031317808ULL, 0x000fe40003000000ULL,
0xff80000022227808ULL, 0x000fe40000000000ULL, 0x0000004958ff7212ULL, 0x080fe4000786c0ffULL,
0x000000495aff7212ULL, 0x000fc4000788c0ffULL, 0x000000495eff7212ULL, 0x000fe400078ac0ffULL,
0x0000004b58ff7212ULL, 0x080fe4000784c0ffULL, 0x0000004b5aff7212ULL, 0x080fe4000782c0ffULL,
0x0000004b5eff7212ULL, 0x000fe400078cc0ffULL, 0x0000000d4eff7212ULL, 0x000fe2000780c0ffULL,
0x000000015b4a7824ULL, 0x100fe200078e0a4cULL, 0x000000347700720cULL, 0x0c0fe20001f61470ULL,
0x0000000136467824ULL, 0x100fe200078e0a4cULL, 0x000000347700720cULL, 0x080fe20001741470ULL,
0x000000013c4c7824ULL, 0x000fe200078e0a4cULL, 0x000000346b00720cULL, 0x000fc40002781470ULL,
0x000000346b00720cULL, 0x080fe40000f21470ULL, 0x000000346500720cULL, 0x0c0fe40002fa1470ULL,
0x000000346500720cULL, 0x080fe400037c1470ULL, 0x000000344700720cULL, 0x080fe40000701470ULL,
0x000000346300720cULL, 0x0c0fe40001f61070ULL, 0x000000346300720cULL, 0x000fc40001741070ULL,
0x000000345f00720cULL, 0x0c0fe40002781070ULL, 0x000000345f00720cULL, 0x080fe40000f21070ULL,
0x000000345d00720cULL, 0x0c0fe40002fa1070ULL, 0x000000345d00720cULL, 0x080fe400037c1070ULL,
0x000000344500720cULL, 0x000fe40000701070ULL, 0x0000004a424a7219ULL, 0x000fc400000006ffULL,
0x0000004642467219ULL, 0x040fe400000006ffULL, 0x0000004c424c7219ULL, 0x000fe400000006ffULL,
0x000054100e117816ULL, 0x000fe40000000011ULL, 0xff80000029297808ULL, 0x000fe40001800000ULL,
0xff80000012127808ULL, 0x000fe40001000000ULL, 0xff8000002a2a7808ULL, 0x000fc40002000000ULL,
0xff80000014147808ULL, 0x000fe40000800000ULL, 0xff8000002e2e7808ULL, 0x000fe40002800000ULL,
0xff80000015157808ULL, 0x000fe40003000000ULL, 0xff8000002d2d7808ULL, 0x000fe40000000000ULL,
0x0000000d4aff7212ULL, 0x080fe4000786c0ffULL, 0x0000000d46ff7212ULL, 0x000fc4000784c0ffULL,
0x0000000d4cff7212ULL, 0x000fe4000788c0ffULL, 0x000000114eff7212ULL, 0x080fe4000782c0ffULL,
0x000000114aff7212ULL, 0x080fe400078ac0ffULL, 0x0000001146ff7212ULL, 0x080fe400078cc0ffULL,
0x000000114cff7212ULL, 0x000fe4000780c0ffULL, 0x000000344700720cULL, 0x000fc40000f21470ULL,
0x000000345b00720cULL, 0x0c0fe40001f61470ULL, 0x000000345b00720cULL, 0x080fe40002fa1470ULL,
0x000000343600720cULL, 0x0c0fe40001741470ULL, 0x000000343600720cULL, 0x080fe400037c1470ULL,
0x000000343c00720cULL, 0x0c0fe40002781470ULL, 0x000000343c00720cULL, 0x000fc40000701470ULL,
0x000000344500720cULL, 0x080fe40000f21070ULL, 0x000000345900720cULL, 0x0c0fe40001f61070ULL,
0x000000345900720cULL, 0x080fe40002fa1070ULL, 0x000000345700720cULL, 0x0c0fe40001741070ULL,
0x000000345700720cULL, 0x080fe400037c1070ULL, 0x000000344d00720cULL, 0x000fc40002781070ULL,
0x000000344d00720cULL, 0x000fe40000701070ULL, 0xff8000002b2b7808ULL, 0x000fe40001800000ULL,
0xff80000023237808ULL, 0x000fe40001000000ULL, 0xff80000024247808ULL, 0x000fe40002000000ULL,
0xff80000019197808ULL, 0x000fe40000800000ULL, 0xff8000001a1a7808ULL, 0x000fc40002800000ULL,
0xff8000001b1b7808ULL, 0x000fe40003000000ULL, 0xff8000001c1c7808ULL, 0x000fc40000000000ULL,
0x000000130800720bULL, 0x004fe20003f1e000ULL, 0x0000001fff117424ULL, 0x000fe200078e00ffULL,
0x0000001e0900720bULL, 0x000fe20003f3e000ULL, 0xffffffffff367424ULL, 0x000fe200078e00ffULL,
0x0000000813087208ULL, 0x000fe40004000000ULL, 0x000000091e097208ULL, 0x000fe40004800000ULL,
0x000000250800720bULL, 0x000fc40003f1e000ULL, 0x000000160900720bULL, 0x000fe40003f3e000ULL,
0x0000000825077208ULL, 0x000fe40004000000ULL, 0x0000000916067208ULL, 0x000fe40004800000ULL,
0x000000260700720bULL, 0x000fe40003f1e000ULL, 0x000000170600720bULL, 0x000fe40003f3e000ULL,
0x0000000726087208ULL, 0x000fc40004000000ULL, 0x0000000617077208ULL, 0x000fe40004800000ULL,
0x0000002f0800720bULL, 0x000fe40003f1e000ULL, 0x000000300700720bULL, 0x000fe40003f3e000ULL,
0x000000082f097208ULL, 0x000fe40004000000ULL, 0x0000000730077208ULL, 0x000fe40004800000ULL,
0x0000002c0900720bULL, 0x000fc40003f1e000ULL, 0x000000200700720bULL, 0x000fe40003f3e000ULL,
0x000000092c067208ULL, 0x000fe40004000000ULL, 0x0000000720087208ULL, 0x000fe40004800000ULL,
0x000000270600720bULL, 0x000fe40003f1e000ULL, 0x0000001f0800720bULL, 0x000fe40003f3e000ULL,
0x0000000627077208ULL, 0x000fc40004000000ULL, 0x000000081f087208ULL, 0x000fe40004800000ULL,
0x000000280700720bULL, 0x000fe40003f1e000ULL, 0x000000210800720bULL, 0x000fe40003f3e000ULL,
0x0000000728067208ULL, 0x000fe40004000000ULL, 0x0000000821077208ULL, 0x000fe40004800000ULL,
0x000000330600720bULL, 0x000fc40003f1e000ULL, 0x000000320700720bULL, 0x000fe40003f3e000ULL,
0x0000000633067208ULL, 0x000fe40004000000ULL, 0x0000000732077208ULL, 0x000fe40004800000ULL,
0x000000310600720bULL, 0x000fe40003f1e000ULL, 0x000000220700720bULL, 0x000fe40003f3e000ULL,
0x0000000631067208ULL, 0x000fc40004000000ULL, 0x0000000722077208ULL, 0x000fe40004800000ULL,
0x000000290600720bULL, 0x000fe40003f1e000ULL, 0x000000120700720bULL, 0x000fe40003f3e000ULL,
0x0000000629097208ULL, 0x000fe40004000000ULL, 0x0000000712077208ULL, 0x000fe40004800000ULL,
0x0000002a0900720bULL, 0x000fc40003f1e000ULL, 0x000000140700720bULL, 0x000fe40003f3e000ULL,
0x000000092a097208ULL, 0x000fe40004000000ULL, 0x0000000714067208ULL, 0x000fe40004800000ULL,
0x0000002e0900720bULL, 0x000fe40003f1e000ULL, 0x000000150600720bULL, 0x000fe40003f3e000ULL,
0x000000092e087208ULL, 0x000fc40004000000ULL, 0x0000000615067208ULL, 0x000fe40004800000ULL,
0x0000002d0800720bULL, 0x000fe40003f1e000ULL, 0x000000190600720bULL, 0x000fe40003f3e000ULL,
0x000000082d087208ULL, 0x000fe40004000000ULL, 0x0000000619077208ULL, 0x000fe40004800000ULL,
0x0000002b0800720bULL, 0x000fc40003f1e000ULL, 0x0000001a0700720bULL, 0x000fe40003f3e000ULL,
0x000000082b087208ULL, 0x000fe40004000000ULL, 0x000000071a067208ULL, 0x000fe40004800000ULL,
0x000000230800720bULL, 0x000fe40003f1e000ULL, 0x0000001b0600720bULL, 0x000fe40003f3e000ULL,
0x0000000823077208ULL, 0x000fc40004000000ULL, 0x000000061b097208ULL, 0x000fe40004800000ULL,
0x000000240700720bULL, 0x000fe40003f1e000ULL, 0x0000001c0900720bULL, 0x000fe40003f3e000ULL,
0x00000007240e7208ULL, 0x000fe40004000000ULL, 0x000000091c107208ULL, 0x000fe20004800000ULL,
0x000014227f007947ULL, 0x000fec000b800000ULL, 0x0c401f000e067f89ULL, 0x0004e400000e0000ULL,
0x000000060e00720bULL, 0x008fc80003f1e000ULL, 0x0000000e06347208ULL, 0x000fe20004000000ULL,
0x000014327f007947ULL, 0x000fea000b800000ULL, 0x0c401f0010067f89ULL, 0x000ee800000e0000ULL,
0x0c401f000a077f89ULL, 0x000e6800000e0000ULL, 0x0c401f000b087f89ULL, 0x000ea800000e0000ULL,
0x0c201f0034097f89ULL, 0x000ea200000e0000ULL, 0x000000061000720bULL, 0x008fc40003f1e000ULL,
0x000000070a00720bULL, 0x002fe40003f3e000ULL, 0x00000010060c7208ULL, 0x000fe40004000000ULL,
0x0000000a070d7208ULL, 0x000fe40004800000ULL, 0x000000080b00720bULL, 0x004fe20003f1e000ULL,
0x0c201f000c0f7f89ULL, 0x000e6600000e0000ULL, 0x0000000b08067208ULL, 0x000fe20004000000ULL,
0x0c201f000d0e7f89ULL, 0x000ea200000e0000ULL, 0x000000093400720bULL, 0x000fc60003f1e000ULL,
0x0c201f0006077f89ULL, 0x0006e200000e0000ULL, 0x0000003409087208ULL, 0x000fe40004000000ULL,
0x0000000f0c00720bULL, 0x002fe40003f3e000ULL, 0x0000000e0d00720bULL, 0x004fe40003f5e000ULL,
0x0000000c0f097208ULL, 0x000fe40004800000ULL, 0x0000000d0e0a7208ULL, 0x000fc40005000000ULL,
0x3fb8aa3b080c7820ULL, 0x008fe20000410000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000c1d1d7812ULL, 0x000fc400078ec0ffULL, 0x3fb8aa3b25257823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b13137823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b280f7823ULL, 0x102fe2000001080cULL,
0x3fb8aa3b26267823ULL, 0x100fe2000001080cULL, 0x00000025000e7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b2f2f7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b2c2c7823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b270b7823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b29287823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b2a297823ULL, 0x100fe2000001080cULL, 0x3fb8aa3b33337823ULL, 0x100fe2000001080cULL,
0x3fb8aa3b31277823ULL, 0x100fe2000001080cULL, 0x0000001300137308ULL, 0x000ee20000000800ULL,
0x3fb8aa3b23257823ULL, 0x102fe2000001080cULL, 0x3fb8aa3b09237820ULL, 0x000fe20000410000ULL,
0x3fb8aa3b242a7823ULL, 0x000fe2000001080cULL, 0x0000000303ff7812ULL, 0x000fc4000780c0ffULL,
0x3fb8aa3b1e1e7823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b17177823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b30307823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b16167823ULL, 0x100fe20000010823ULL,
0x00000026000d7308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b1f1f7823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b20207823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b21217823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b32327823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b22227823ULL, 0x100fe20000010823ULL,
0x3fb8aa3b19197823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b1a1a7823ULL, 0x100fe20000010823ULL,
0x0000002f00107308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b2b267823ULL, 0x002fe2000001080cULL,
0x3fb8aa3b1b1b7823ULL, 0x100fe20000010823ULL, 0x3fb8aa3b1c1c7823ULL, 0x000fe20000010823ULL,
0x000000070600720bULL, 0x004fc80003f3e000ULL, 0x0000000f00367308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b152f7823ULL, 0x000fce0000010823ULL, 0x0000001e001e7308ULL, 0x000ff00000000800ULL,
0x00000016000f7308ULL, 0x000e700000000800ULL, 0x0000001700177308ULL, 0x000ff00000000800ULL,
0x0000003000307308ULL, 0x000eb00000000800ULL, 0x0000002c00347308ULL, 0x0003f00000000800ULL,
0x0000000b00357308ULL, 0x0004e20000000800ULL, 0x3fb8aa3b2e2c7823ULL, 0x002fe2000001080cULL,
0x3fb8aa3b142e7823ULL, 0x000fcc0000010823ULL, 0x0000001f002b7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b2d0b7823ULL, 0x004fe2000001080cULL, 0x000000130e0c723eULL, 0x008fe200000000ffULL,
0x3fb8aa3b122d7823ULL, 0x000fe20000010823ULL, 0x0000000d100e723eULL, 0x000fe400000000ffULL,
0x0000001e0f0d723eULL, 0x000fe200000000ffULL, 0x3c003c00ff1e7424ULL, 0x000fe200078e00ffULL,
0x00000017300f723eULL, 0x000fe200000000ffULL, 0x3c003c00ff1f7424ULL, 0x002fe200078e00ffULL,
0x0000003300337308ULL, 0x000e620000000800ULL, 0x000000343514723eULL, 0x000fca00000000ffULL,
0x0000001e0c10723cULL, 0x000f6400000018ffULL, 0x0000002000207308ULL, 0x000eb00000000800ULL,
0x0000002100217308ULL, 0x000fe20000000800ULL, 0x000000363316723eULL, 0x002fc400000000ffULL,
0x00000002ff337819ULL, 0x000fc80000011603ULL, 0x0000000233317810ULL, 0x000fe20007ffe0ffULL,
0x0000003200327308ULL, 0x000e620000000800ULL, 0x000000202b15723eULL, 0x004fe200000000ffULL,
0x0000000833367824ULL, 0x040fe200078e00ffULL, 0x00000001332b7810ULL, 0x040fe20007ffe0ffULL,
0x0000000833307824ULL, 0x040fe200078e00ffULL, 0x00000008333a7810ULL, 0x040fe20007ffe0ffULL,
0x0000000833387824ULL, 0x040fe400078e00ffULL, 0x0000002200247308ULL, 0x0005e20000000800ULL,
0xfffffff830307812ULL, 0x000fe200078ee22bULL, 0x00000008332b7824ULL, 0x000fe200078e00ffULL,
0x000000213217723eULL, 0x002fca00000000ffULL, 0x0000002700277308ULL, 0x000fe20000000800ULL,
0x0000000833327824ULL, 0x040fe200078e00ffULL, 0x0000001e1420723cULL, 0x024b680000001810ULL,
0xfffffff832327812ULL, 0x000fe400078ee231ULL, 0x0000002800287308ULL, 0x000e620000000800ULL,
0x0000000833137824ULL, 0x060fe200078e00ffULL, 0x0000000333107810ULL, 0x000fcc0007ffe0ffULL,
0x0000002900297308ULL, 0x000fe20000000800ULL, 0x0000000433117810ULL, 0x000fe40007ffe0ffULL,
0xfffffff813347812ULL, 0x000fe400078ee210ULL, 0xfffffff836367812ULL, 0x000fc600078ee211ULL,
0x0000002c002c7308ULL, 0x000ea20000000800ULL, 0x000000272810723eULL, 0x002fe200000000ffULL,
0x0000000833287824ULL, 0x040fe200078e00ffULL, 0x0000000633277810ULL, 0x000fc80007ffe0ffULL,
0xfffffff828287812ULL, 0x000fe200078ee233ULL, 0x0000002d002d7308ULL, 0x000e700000000800ULL,
0x0000002e002e7308ULL, 0x000fe20000000800ULL, 0x000000292c12723eULL, 0x004fc400000000ffULL,
0xffffffff33297810ULL, 0x000fc80007ffe0ffULL, 0xfffffff838387812ULL, 0x000fe200078ee229ULL,
0x0000002f002f7308ULL, 0x000ea20000000800ULL, 0x000000242d11723eULL, 0x002fe200000000ffULL,
0x000000083a2d7824ULL, 0x000fe200078e00ffULL, 0x0000000533247810ULL, 0x000fc80007ffe0ffULL,
0xfffffff82b2c7812ULL, 0x000fe200078ee224ULL, 0x0000000b000b7308ULL, 0x000fe20000000800ULL,
0xfffffff82d3a7812ULL, 0x000fe400078ee23aULL, 0x0000002e2f13723eULL, 0x004fca00000000ffULL,
0x0000002600267308ULL, 0x000e620000000800ULL, 0x00000008332e7824ULL, 0x000fe200078e00ffULL,
0x0000001e1020723cULL, 0x000f680000001820ULL, 0xfffffff82e2e7812ULL, 0x000fe400078ee227ULL,
0x0000002500257308ULL, 0x000ff00000000800ULL, 0x0000002a002a7308ULL, 0x000ea20000000800ULL,
0x0000000b2624723eULL, 0x002fc400000000ffULL, 0x00009000000b7811ULL, 0x000fca00078e58ffULL,
0x0000001900197308ULL, 0x000fe20000000800ULL, 0x0000001028287824ULL, 0x100fe400078e020bULL,
0x0000001030307824ULL, 0x100fe400078e020bULL, 0x0000001032327824ULL, 0x100fe400078e020bULL,
0x0000001034347824ULL, 0x100fe200078e020bULL, 0x0000001a001a7308ULL, 0x000e620000000800ULL,
0x000000252a26723eULL, 0x004fe200000000ffULL, 0x0000001036367824ULL, 0x000fc400078e020bULL,
0x000000102c2c7824ULL, 0x100fe400078e020bULL, 0x000000011d307824ULL, 0x040fe400078e0230ULL,
0x0000001b001b7308ULL, 0x000fe20000000800ULL, 0x000000102e2e7824ULL, 0x100fe400078e020bULL,
0x000000011d327824ULL, 0x040fe400078e0232ULL, 0x0000001038387824ULL, 0x000fe400078e020bULL,
0x000000011d347824ULL, 0x000fe200078e0234ULL, 0x0000001c001c7308ULL, 0x000ea20000000800ULL,
0x000000191a25723eULL, 0x002fe200000000ffULL, 0x0000000128197824ULL, 0x000fc400078e021dULL,
0x000000103a3a7824ULL, 0x000fe200078e020bULL, 0x00000006070b7208ULL, 0x000fe20004800000ULL,
0x000000011d367824ULL, 0x040fe200078e0236ULL, 0x0000000c19007388ULL, 0x0003e20000000800ULL,
0x000000011d2c7824ULL, 0x040fe400078e022cULL, 0x000000011d2e7824ULL, 0x040fe200078e022eULL,
0x0000000e30007388ULL, 0x0003e20000000800ULL, 0x000000011d387824ULL, 0x040fe400078e0238ULL,
0x000000011d3a7824ULL, 0x000fe200078e023aULL, 0x0000001432007388ULL, 0x0003e20000000800ULL,
0x0000001b1c27723eULL, 0x004fc600000000ffULL, 0x0000001634007388ULL, 0x0003e80000000800ULL,
0x0000001e2420723cULL, 0x020f620000001820ULL, 0x0000001036007388ULL, 0x0003e80000000800ULL,
0x000000122c007388ULL, 0x0003e80000000800ULL, 0x000000242e007388ULL, 0x0003e80000000800ULL,
0x0000002638007388ULL, 0x0003e80000000800ULL, 0x0000000d3a007388ULL, 0x0003e80000000800ULL,
0x0004000f30007388ULL, 0x0003e60000000800ULL, 0x000000ffff217224ULL, 0x020fe200078e0022ULL,
0x0004001532007388ULL, 0x0003e80000000800ULL, 0x0004001734007388ULL, 0x0003e80000000800ULL,
0x0004001136007388ULL, 0x0003e80000000800ULL, 0x000400132c007388ULL, 0x0003e80000000800ULL,
0x000400252e007388ULL, 0x0003e80000000800ULL, 0x0004002738007388ULL, 0x0003e80000000800ULL,
0x00f0000818008388ULL, 0x0003e80000000c00ULL, 0x00f2002018008388ULL, 0x0003e20000000a00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000076ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080076ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100076ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000161617810ULL, 0x000fe20007ffe0ffULL,
0x0000180076ff7f8cULL, 0x0003e6000c80043fULL, 0x000000696100720cULL, 0x000fda0003f06070ULL,
0x0000001000000944ULL, 0x002fe20003c00000ULL, 0xffffb69000007947ULL, 0x000fea000383ffffULL,
0x000000000000794dULL, 0x000fea0003800000ULL, 0x00000001ff0b7807ULL, 0x008fe40004000000ULL,
0x000122a000147802ULL, 0x000fc40000000f00ULL, 0x00000bd000007944ULL, 0x014fea0003c00000ULL,
0xffff03e000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x000fe40005000000ULL,
0x000122e000147802ULL, 0x000fc40000000f00ULL, 0x00000b9000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff127224ULL, 0x000fe200078e000bULL, 0xffff043000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0016ULL, 0x0001233000157802ULL, 0x000fc40000000f00ULL,
0x00000af000007944ULL, 0x014fea0003c00000ULL, 0xffff051000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0016ULL, 0x0001237000157802ULL, 0x000fc40000000f00ULL,
0x00000ab000007944ULL, 0x016fea0003c00000ULL, 0xffff063000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0010ULL, 0x000123c000157802ULL, 0x000fe20000000f00ULL,
0x000000ffff0b7224ULL, 0x000fc400078e000dULL, 0x00000a6000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000bULL, 0xffff0a6000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0010ULL, 0x0001241000157802ULL, 0x000fc40000000f00ULL,
0x00000a1000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000bULL,
0xffff0a4000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x004fe40004000000ULL,
0x0001246000147802ULL, 0x000fc40000000f00ULL, 0x00000a1000007944ULL, 0x018fea0003c00000ULL,
0xffff2a6000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x000fe40005000000ULL,
0x000124a000147802ULL, 0x000fc40000000f00ULL, 0x000009d000007944ULL, 0x018fea0003c00000ULL,
0x000000ffff347224ULL, 0x000fe200078e000bULL, 0xffff2aa000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0036ULL, 0x000124f000157802ULL, 0x000fc40000000f00ULL,
0x0000093000007944ULL, 0x018fea0003c00000ULL, 0xffff2b9000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0036ULL, 0x0001253000157802ULL, 0x000fc40000000f00ULL,
0x000008f000007944ULL, 0x01afea0003c00000ULL, 0xffff2cb000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e000eULL, 0x0001258000157802ULL, 0x000fe20000000f00ULL,
0x000000ffff0b7224ULL, 0x000fc400078e000fULL, 0x000008a000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000bULL, 0xffff30e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e000eULL, 0x000125d000157802ULL, 0x000fc40000000f00ULL,
0x0000085000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000bULL,
0xffff30c000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x008fe40004000000ULL,
0x0001262000147802ULL, 0x000fc40000000f00ULL, 0x0000085000007944ULL, 0x014fea0003c00000ULL,
0xffff4e9000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x000fe40005000000ULL,
0x0001266000147802ULL, 0x000fc40000000f00ULL, 0x0000081000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff087224ULL, 0x000fe200078e000bULL, 0xffff4ee000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0016ULL, 0x000126b000157802ULL, 0x000fc40000000f00ULL,
0x0000077000007944ULL, 0x014fea0003c00000ULL, 0xffff4fd000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0016ULL, 0x000126f000157802ULL, 0x000fc40000000f00ULL,
0x0000073000007944ULL, 0x016fea0003c00000ULL, 0xffff50f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e000aULL, 0x0001274000157802ULL, 0x000fe20000000f00ULL,
0x000000ffff0b7224ULL, 0x000fc400078e000dULL, 0x000006e000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000bULL, 0xffff552000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e000aULL, 0x0001279000157802ULL, 0x000fc40000000f00ULL,
0x0000069000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000bULL,
0xffff550000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x008fe40004000000ULL,
0x000127e000147802ULL, 0x000fc40000000f00ULL, 0x0000069000007944ULL, 0x014fea0003c00000ULL,
0xffff736000007947ULL, 0x000fea000383ffffULL, 0x00000001ff0b7807ULL, 0x000fe40005000000ULL,
0x0001282000147802ULL, 0x000fc40000000f00ULL, 0x0000065000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e000bULL, 0xffff73b000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0012ULL, 0x0001287000157802ULL, 0x000fc40000000f00ULL,
0x000005b000007944ULL, 0x014fea0003c00000ULL, 0xffff74a000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0012ULL, 0x000128b000157802ULL, 0x000fc40000000f00ULL,
0x0000057000007944ULL, 0x016fea0003c00000ULL, 0xffff75c000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0008ULL, 0x0001290000157802ULL, 0x000fe20000000f00ULL,
0x000000ffff0b7224ULL, 0x000fc400078e000fULL, 0x0000052000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e000bULL, 0xffff79f000007947ULL, 0x000fea000383ffffULL,
0x000000ffff147224ULL, 0x000fe200078e0008ULL, 0x0001295000157802ULL, 0x000fc40000000f00ULL,
0x000004d000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff077224ULL, 0x004fe200078e000bULL,
0xffff79d000007947ULL, 0x000fea000383ffffULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x000129a0000c7802ULL, 0x000fc40000000f00ULL, 0x0000044000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff067224ULL, 0x004fe200078e0007ULL, 0xffffeba000007947ULL, 0x000fea000383ffffULL,
0x000000ffff0e7224ULL, 0x006fe200078e0010ULL, 0x00012a00000c7802ULL, 0x000fe20000000f00ULL,
0x00000002ff0f7424ULL, 0x000fc400078e00ffULL, 0x000003e000007944ULL, 0x010fea0003c00000ULL,
0x000000071000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x00012a60000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001007107208ULL, 0x000fc80004000000ULL, 0x0000038000007944ULL, 0x000fea0003c00000ULL,
0x000000070a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000bULL,
0x00012ac0000c7802ULL, 0x000fe20000000f00ULL, 0x00000002ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a070a7208ULL, 0x000fc80004000000ULL, 0x0000032000007944ULL, 0x000fea0003c00000ULL,
0x000000070b00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0034ULL,
0x00012b20000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000b07067208ULL, 0x000fc80004000000ULL, 0x000002c000007944ULL, 0x000fea0003c00000ULL,
0x000000073400720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0010ULL,
0x00012b80000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000003407087208ULL, 0x000fc80004000000ULL, 0x0000026000007944ULL, 0x000fea0003c00000ULL,
0x000000071000720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e000aULL,
0x00012be0000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000001007097208ULL, 0x000fc80004000000ULL, 0x0000020000007944ULL, 0x000fea0003c00000ULL,
0x000000070a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff0e7224ULL, 0x002fe200078e0006ULL,
0x00012c40000c7802ULL, 0x000fe20000000f00ULL, 0x00000001ff0f7424ULL, 0x000fe200078e00ffULL,
0x0000000a070a7208ULL, 0x000fc80004000000ULL, 0x000001a000007944ULL, 0x000fea0003c00000ULL,
0xffffea7000007947ULL, 0x000fea000383ffffULL, 0x0180000009027810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000002037812ULL, 0x000fc800078ec0ffULL,
0x018000000300780cULL, 0x000fda0003f05070ULL, 0x0000000900028308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0300720cULL, 0x040fe40003f25070ULL,
0x008000000300780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff027807ULL, 0x004fc80004000000ULL, 0x0000000203ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff09ff7812ULL, 0x000fc8000780c0ffULL,
0x00000001ff027807ULL, 0x000fc80000000000ULL, 0x0000000203ff7212ULL, 0x000fe4000780c0ffULL,
0x8000000009037812ULL, 0x000fd600078ec0ffULL, 0x0080000003020812ULL, 0x000fe200078efcffULL,
0x000000ffff028224ULL, 0x000fe200078e0003ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000900027308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff047224ULL, 0x00cfe400078e0002ULL, 0x000000ffff027224ULL, 0x000fe400078e0005ULL,
0x00000000ff037424ULL, 0x000fc800078e00ffULL, 0xfffed22002007950ULL, 0x000fea0003c3ffffULL,
0x00000000ff0d7424ULL, 0x000fe200078e00ffULL, 0x0000003600007348ULL, 0x000fe80003800000ULL,
0x0c00000f0e077389ULL, 0x0002a200000e0011ULL, 0xfffed1e00c007950ULL, 0x000fea0003c3ffffULL,
0x0000007700007348ULL, 0x000fe80003800000ULL, 0x0000000b140b7389ULL, 0x0002a400000e0078ULL,
0x000000ffff147224ULL, 0x002fc400078e0015ULL, 0x00000000ff157424ULL, 0x000fc800078e00ffULL,
0xfffed19014007950ULL, 0x000fea0003c3ffffULL, 0x000000010b00780cULL, 0x000fe20003f45070ULL,
0x00000000ff157424ULL, 0x000fe200078e00ffULL, 0x0000007600007348ULL, 0x000ff60003800000ULL,
0x00000000000b7806ULL, 0x000fc800050e0100ULL, 0x000000760b0b7212ULL, 0x000fe200078ec0ffULL,
0xfffed13014007950ULL, 0x000fec0003c3ffffULL, 0xfffffff000007947ULL, 0x000fc0000383ffffULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000001000000004ULL, 0x0000000100000001ULL, 0x0000001000000008ULL, 0x0000000400000001ULL,
0x0000000800000008ULL, 0x0000000800000001ULL, 0x0000000200000001ULL, 0x0000000400000003ULL,
0x0000000300000004ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000300000001ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000040ULL, 0x000000000000011cULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x000000030000000bULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000000000000015cULL, 0x00000000000005f4ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x0000000200000013ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000750ULL, 0x00000000000002a0ULL, 0x0000001b00000002ULL,
0x0000000000000008ULL, 0x0000000000000018ULL, 0x00000001000000ddULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000009f0ULL, 0x0000000000000350ULL, 0x0000000000000000ULL,
0x0000000000000001ULL, 0x0000000000000000ULL, 0x7000000000000037ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000d40ULL, 0x00000000000000c0ULL, 0x0000000000000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000000000051ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000e00ULL, 0x00000000000007c0ULL, 0x0000000b00000003ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x7000000b0000010dULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015c0ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000000000008ULL, 0x0000000000000008ULL, 0x00000009000000eaULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000015d0ULL, 0x0000000000000090ULL, 0x0000000400000003ULL,
0x0000000000000008ULL, 0x0000000000000010ULL, 0x000000010000008bULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001660ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x00000001000000c4ULL, 0x0000000000000002ULL,
0x0000000000000000ULL, 0x0000000000001664ULL, 0x00000000000001c0ULL, 0x0000000b00000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000100000040ULL, 0x0000000000100006ULL,
0x0000000000000000ULL, 0x0000000000001880ULL, 0x0000000000012f80ULL, 0x8000001b00000003ULL,
0x0000000000000080ULL, 0x0000000000000000ULL, 0x000000010000007bULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014800ULL, 0x0000000000000048ULL, 0x0000000000000000ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000800000065ULL, 0x0000000000000003ULL,
0x0000000000000000ULL, 0x0000000000014850ULL, 0x0000000000000000ULL, 0x0000000b00000000ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000500000006ULL, 0x0000000000014bd0ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x0000000000001660ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000131a0ULL, 0x00000000000131a0ULL, 0x0000000000000008ULL,
0x0000000600000001ULL, 0x0000000000014800ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000050ULL, 0x0000000000000050ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000014bd0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000000e0ULL,
0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_16_sm_86_cubin_len = 85168;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
