/*
* SPDX-FileCopyrightText: Copyright (c) 1993-2023 NVIDIA CORPORATION &
* AFFILIATES. All rights reserved. SPDX-License-Identifier: Apache-2.0
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
namespace tensorrt_llm
{
namespace kernels
{
// clang-format off
unsigned long long xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_80_cubin[] = {
0x33010102464c457fULL, 0x0000000000000007ULL, 0x0000007b00be0002ULL, 0x0000000000000000ULL,
0x000000000001afc0ULL, 0x000000000001ac40ULL, 0x0038004000500550ULL, 0x0001000e00400004ULL,
0x7472747368732e00ULL, 0x747274732e006261ULL, 0x746d79732e006261ULL, 0x746d79732e006261ULL,
0x78646e68735f6261ULL, 0x7466752e766e2e00ULL, 0x2e007972746e652eULL, 0x006f666e692e766eULL,
0x656b2e747865742eULL, 0x61686d5f6c656e72ULL, 0x666e692e766e2e00ULL, 0x6c656e72656b2e6fULL,
0x766e2e0061686d5fULL, 0x2e6465726168732eULL, 0x6d5f6c656e72656bULL, 0x672e766e2e006168ULL,
0x6e692e6c61626f6cULL, 0x632e766e2e007469ULL, 0x33746e6174736e6fULL, 0x742e616c65722e00ULL,
0x6e72656b2e747865ULL, 0x2e0061686d5f6c65ULL, 0x747865742e6c6572ULL, 0x5f6c656e72656b2eULL,
0x2e766e2e0061686dULL, 0x746e6174736e6f63ULL, 0x6c656e72656b2e30ULL, 0x65642e0061686d5fULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x68732e00006e6f69ULL,
0x2e00626174727473ULL, 0x2e00626174727473ULL, 0x2e006261746d7973ULL, 0x735f6261746d7973ULL,
0x766e2e0078646e68ULL, 0x746e652e7466752eULL, 0x692e766e2e007972ULL, 0x6e72656b006f666eULL,
0x2e0061686d5f6c65ULL, 0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x6f666e692e766e2eULL,
0x5f6c656e72656b2eULL, 0x2e766e2e0061686dULL, 0x6b2e646572616873ULL, 0x686d5f6c656e7265ULL,
0x6c672e766e2e0061ULL, 0x696e692e6c61626fULL, 0x655073776f720074ULL, 0x2e006b636f6c4272ULL,
0x74736e6f632e766eULL, 0x656d730033746e61ULL, 0x5a5f00657a69536dULL, 0x3361647563344e5aULL,
0x38345f5f33647473ULL, 0x6c69617465645f5fULL, 0x6f7274735f5f3132ULL, 0x64726f5f7265676eULL,
0x45616475635f7265ULL, 0x66785f5f37456969ULL, 0x4e5a5a5f006d726fULL, 0x327961727241374bULL,
0x4c45326a4c664944ULL, 0x497461324545326aULL, 0x4b5245454530624cULL, 0x6f723431456a6a66ULL,
0x696c537265507377ULL, 0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x4c66495f53494432ULL,
0x4545326a4c45326aULL, 0x45386a4c45326a4cULL, 0x30624c4974613245ULL, 0x5f30534b52454545ULL,
0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL, 0x327961727241374bULL,
0x6c61685f5f374944ULL, 0x6a4c45346a4c3266ULL, 0x4c49746132454538ULL, 0x534b524545453062ULL,
0x723431456a6a5f30ULL, 0x6c5372655073776fULL, 0x5a5f00676e696469ULL, 0x61727241374b4e5aULL,
0x6365563349443279ULL, 0x4c4545346a4c6a49ULL, 0x45386a4c4532336aULL, 0x31624c4974613245ULL,
0x5f31534b52454545ULL, 0x776f723431456a6aULL, 0x64696c5372655073ULL, 0x4e5a5a5f00676e69ULL,
0x327961727241374bULL, 0x6a49636556334944ULL, 0x336a4c4545346a4cULL, 0x454536316a4c4532ULL,
0x4531624c49746132ULL, 0x6a5f31534b524545ULL, 0x73776f723431456aULL, 0x6964696c53726550ULL,
0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL, 0x4c6a496365563349ULL, 0x34366a4c4545346aULL,
0x61324545386a4c45ULL, 0x45454531624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL,
0x676e6964696c5372ULL, 0x41374b4e5a5a5f00ULL, 0x3949443279617272ULL, 0x614d6e4974736e49ULL,
0x6a4c45326a4c4974ULL, 0x4c45326a4c454532ULL, 0x497461324545316aULL, 0x4b5245454530624cULL,
0x3431456a6a5f3153ULL, 0x5372655073776f72ULL, 0x5f00676e6964696cULL, 0x727241374b4e5a5aULL,
0x6e49394944327961ULL, 0x4974614d6e497473ULL, 0x45316a4c45346a4cULL, 0x316a4c45326a4c45ULL,
0x624c497461324545ULL, 0x31534b5245454530ULL, 0x6f723431456a6a5fULL, 0x696c537265507377ULL,
0x5a5a5f00676e6964ULL, 0x7961727241374b4eULL, 0x74736e4939494432ULL, 0x6a4c4974614d6e49ULL,
0x4c4545326a4c4534ULL, 0x4545316a4c45326aULL, 0x4530624c49746132ULL, 0x6a5f31534b524545ULL,
0x73776f723431456aULL, 0x6964696c53726550ULL, 0x4b4e5a5a5f00676eULL, 0x4432796172724137ULL,
0x6e4974736e493949ULL, 0x45326a4c4974614dULL, 0x346a4c4545326a4cULL, 0x61324545316a4c45ULL,
0x45454530624c4974ULL, 0x456a6a5f31534b52ULL, 0x655073776f723431ULL, 0x676e6964696c5372ULL,
0x41374b4e5a5a5f00ULL, 0x3349443279617272ULL, 0x346a4c6a49636556ULL, 0x4c4532336a4c4545ULL,
0x497461324545386aULL, 0x4b5245454530624cULL, 0x3431456a6a5f3153ULL, 0x5372655073776f72ULL,
0x2400676e6964696cULL, 0x6e7265746e695f5fULL, 0x5f5f245f305f6c61ULL, 0x326d735f61647563ULL,
0x6e725f7063725f30ULL, 0x3233665f7a74665fULL, 0x746170776f6c735fULL, 0x746e695f5f240068ULL,
0x5f315f6c616e7265ULL, 0x5f616475635f5f24ULL, 0x6668735f30376d73ULL, 0x66625f636e79736cULL,
0x5f5f2400705f796cULL, 0x6c616e7265746e69ULL, 0x75635f5f245f325fULL, 0x5f30376d735f6164ULL,
0x636e79736c666873ULL, 0x2400705f7864695fULL, 0x6e7265746e695f5fULL, 0x5f5f245f335f6c61ULL,
0x376d735f61647563ULL, 0x797365746f765f30ULL, 0x6f6c6c61625f636eULL, 0x2e616c65722e0074ULL,
0x72656b2e74786574ULL, 0x0061686d5f6c656eULL, 0x7865742e6c65722eULL, 0x6c656e72656b2e74ULL,
0x656b240061686d5fULL, 0x61686d5f6c656e72ULL, 0x7479426d656d7324ULL, 0x766e2e0066754265ULL,
0x6e6174736e6f632eULL, 0x656e72656b2e3074ULL, 0x705f0061686d5f6cULL, 0x65642e006d617261ULL,
0x6d6172665f677562ULL, 0x642e6c65722e0065ULL, 0x6172665f67756265ULL, 0x616c65722e00656dULL,
0x665f67756265642eULL, 0x766e2e00656d6172ULL, 0x7463612e6c65722eULL, 0x00000000006e6f69ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b00030000004bULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x000c000300000086ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x000c000100000096ULL, 0x0000000000000004ULL, 0x0000000000000004ULL,
0x00090003000000a3ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00090001000000b1ULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000000baULL, 0x0000000000000030ULL,
0x0000000000000010ULL, 0x000c0001000000f8ULL, 0x0000000000000014ULL, 0x0000000000000004ULL,
0x000c000100000131ULL, 0x0000000000000020ULL, 0x0000000000000004ULL, 0x000c000100000178ULL,
0x000000000000000cULL, 0x0000000000000004ULL, 0x000c0001000001baULL, 0x000000000000002cULL,
0x0000000000000004ULL, 0x000c000100000200ULL, 0x0000000000000018ULL, 0x0000000000000004ULL,
0x000c000100000247ULL, 0x0000000000000024ULL, 0x0000000000000004ULL, 0x000c00010000028dULL,
0x0000000000000000ULL, 0x0000000000000004ULL, 0x000c0001000002dbULL, 0x0000000000000028ULL,
0x0000000000000004ULL, 0x000c000100000329ULL, 0x0000000000000010ULL, 0x0000000000000004ULL,
0x000c000100000377ULL, 0x000000000000001cULL, 0x0000000000000004ULL, 0x000c0001000003c5ULL,
0x0000000000000008ULL, 0x0000000000000004ULL, 0x000b00220000040bULL, 0x0000000000019070ULL,
0x0000000000000180ULL, 0x000b00220000043eULL, 0x00000000000191f0ULL, 0x0000000000000040ULL,
0x000b002200000469ULL, 0x0000000000019230ULL, 0x0000000000000050ULL, 0x000b002200000493ULL,
0x0000000000019280ULL, 0x0000000000000100ULL, 0x000a000300000501ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0004000300000521ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0007000300000551ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000b101200000040ULL,
0x0000000000000000ULL, 0x0000000000019380ULL, 0x00000024ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x80810c0fffffffffULL, 0x288081ff08002880ULL, 0x0000002880808108ULL,
0x00000034ffffffffULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0001907000000000ULL,
0x0000040400000000ULL, 0x810c000001640400ULL, 0x0062ac0400288080ULL, 0x0000000000000000ULL,
0x0000003cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080840828808081ULL, 0x0310288082801628ULL, 0x0000000000000000ULL,
0x0022002880808492ULL, 0x0000002cffffffffULL, 0x0000007000000000ULL, 0x0001907000000000ULL,
0x0000018000000000ULL, 0x0000580400000000ULL, 0x8082288080840900ULL, 0x0000000000002880ULL,
0x0000009cffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL, 0x8080810c28808280ULL,
0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8608288080840828ULL, 0x2880808708288080ULL,
0x8094082880809308ULL, 0x0828808095082880ULL, 0x8080970828808096ULL, 0xa0082880809f0828ULL,
0x288080a508288080ULL, 0x80ec08288080a708ULL, 0x08288080f0082880ULL, 0x8080f208288080f1ULL,
0x8808288080f30828ULL, 0x2880828016288080ULL, 0x0000000000000310ULL, 0x0028808088920000ULL,
0x0000000000000022ULL, 0x0000001cffffffffULL, 0x000000f000000000ULL, 0x000191f000000000ULL,
0x0000004000000000ULL, 0x0000000000000000ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL,
0x7c040003ffffffffULL, 0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL,
0x8608288080840828ULL, 0x2880809308288080ULL, 0x8095082880809408ULL, 0x0828808096082880ULL,
0x80809f0828808097ULL, 0xa608288080a00828ULL, 0x288080a708288080ULL, 0x80f008288080ec08ULL,
0x08288080f1082880ULL, 0x8080f308288080f2ULL, 0x8016288080a50828ULL, 0x0000000310288082ULL,
0x80a5920000000000ULL, 0x0000000022002880ULL, 0x0000002cffffffffULL, 0x000001c000000000ULL,
0x0001923000000000ULL, 0x0000005000000000ULL, 0x00000c0400000000ULL, 0x80ec288080a50900ULL,
0x0000000000002880ULL, 0x00000094ffffffffULL, 0xffffffff00000000ULL, 0x7c040003ffffffffULL,
0x8080810c28808280ULL, 0x08288081ff080028ULL, 0x8080820828808081ULL, 0x8608288080840828ULL,
0x2880809308288080ULL, 0x8095082880809408ULL, 0x0828808096082880ULL, 0x80809f0828808097ULL,
0xa508288080a00828ULL, 0x288080a708288080ULL, 0x80f008288080ec08ULL, 0x08288080f1082880ULL,
0x8080f308288080f2ULL, 0x8016288080a60828ULL, 0x0000000310288082ULL, 0x80a6920000000000ULL,
0x0000000022002880ULL, 0x0000001cffffffffULL, 0x0000029800000000ULL, 0x0001928000000000ULL,
0x0000010000000000ULL, 0x0000000000000000ULL, 0x0000001900082f04ULL, 0x00082304000000dfULL,
0x0000000000000015ULL, 0x0000001500081204ULL, 0x0008110400000000ULL, 0x0000000000000015ULL,
0x0000001400082304ULL, 0x0008120400000000ULL, 0x0000000000000014ULL, 0x0000001400081104ULL,
0x0008230400000000ULL, 0x0000000000000013ULL, 0x0000001300081204ULL, 0x0008110400000000ULL,
0x0000000000000013ULL, 0x0000001200082304ULL, 0x0008120400000000ULL, 0x0000000000000012ULL,
0x0000001200081104ULL, 0x0008230400000000ULL, 0x0000000000000019ULL, 0x0000001900081204ULL,
0x0008110400000000ULL, 0x0000000000000019ULL, 0x0000007b00043704ULL, 0x00080a0400003501ULL,
0x0060016000000016ULL, 0x000c170400601903ULL, 0x0058000900000000ULL, 0x000c17040021f000ULL,
0x0050000800000000ULL, 0x000c17040021f000ULL, 0x0048000700000000ULL, 0x000c17040011f000ULL,
0x0028000600000000ULL, 0x000c17040081f000ULL, 0x0020000500000000ULL, 0x000c17040021f000ULL,
0x0018000400000000ULL, 0x000c17040021f000ULL, 0x0010000300000000ULL, 0x000c17040021f000ULL,
0x0008000200000000ULL, 0x000c17040011f000ULL, 0x0004000100000000ULL, 0x000c17040011f000ULL,
0x0000000000000000ULL, 0x00ff1b030011f000ULL, 0x00000b0000043104ULL, 0xffffffff019c2904ULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL,
0xffffffffffffffffULL, 0xffffffffffffffffULL, 0xffffffffffffffffULL, 0x00000110019c2804ULL,
0x0000058000000310ULL, 0x00002a2000002990ULL, 0x00002ca000002b30ULL, 0x00002f7000002e10ULL,
0x00003400000033c0ULL, 0x0000344000003410ULL, 0x0000570000005670ULL, 0x0000599000005820ULL,
0x00005c6000005b00ULL, 0x00006120000060e0ULL, 0x0000616000006130ULL, 0x0000821000008170ULL,
0x000084a000008330ULL, 0x0000877000008610ULL, 0x00008c3000008bf0ULL, 0x00008c7000008c40ULL,
0x0000ae100000ad70ULL, 0x0000b0900000af20ULL, 0x0000b3600000b200ULL, 0x0000b8300000b7f0ULL,
0x0000b8700000b840ULL, 0x0000ccf00000cce0ULL, 0x0000cd100000cd00ULL, 0x0001684000016800ULL,
0x0001686000016850ULL, 0x000168d0000168b0ULL, 0x00016900000168f0ULL, 0x00017cd000017c70ULL,
0x00017da000017d40ULL, 0x00017e6000017e00ULL, 0x00017f4000017ed0ULL, 0x0001802000017fb0ULL,
0x000180e000018080ULL, 0x000181b000018150ULL, 0x0001827000018210ULL, 0x00018350000182e0ULL,
0x00018430000183c0ULL, 0x000184f000018490ULL, 0x000185c000018560ULL, 0x0001868000018620ULL,
0x00018760000186f0ULL, 0x00018840000187d0ULL, 0x00018900000188a0ULL, 0x000189d000018970ULL,
0x00018a9000018a30ULL, 0x00018b7000018b00ULL, 0x00018c5000018be0ULL, 0x00018d5000018cd0ULL,
0x00018e5000018dd0ULL, 0x00018f5000018ed0ULL, 0x0001905000018fd0ULL, 0x000003e004403904ULL,
0x0001a600000000ffULL, 0x00000440003f0100ULL, 0x0001a6080000000bULL, 0x000004d0003f0120ULL,
0x0001a6880000000bULL, 0x00000530003f0120ULL, 0x0001a6a80000000bULL, 0x00000560003f0120ULL,
0x0001a6c80000000bULL, 0x00000b10003f0120ULL, 0x0001a600000000ffULL, 0x00000d10003f0107ULL,
0x0000000400000007ULL, 0x00000dc0003f0102ULL, 0x0000000000000007ULL, 0x000017d0003f0101ULL,
0x00000000000000ffULL, 0x0000185000040107ULL, 0x00000000000000ffULL, 0x000018b000040101ULL,
0x0000002000000002ULL, 0x00001a60003f0101ULL, 0x0001a6cc00000019ULL, 0x00001c40003f0105ULL,
0x0001a6cc00000019ULL, 0x00002590003f0105ULL, 0x0001a6b000000029ULL, 0x00002640003f0107ULL,
0x0001a6b000000029ULL, 0x000026a0003f0101ULL, 0x0001a60800000004ULL, 0x000026c0003f0101ULL,
0x0001a60c00000004ULL, 0x00002890003f0105ULL, 0x0001a60c00000004ULL, 0x00003120003f0105ULL,
0x0001a6ac00000029ULL, 0x000032f0003f0105ULL, 0x0001a6ac00000029ULL, 0x000047f0003f0105ULL,
0x000000000000006cULL, 0x00004850003f0101ULL, 0x0001a68800000025ULL, 0x00004880003f0101ULL,
0x0000000400000005ULL, 0x00004a40003f0105ULL, 0x0000000400000005ULL, 0x000052d0003f0105ULL,
0x0001a6a8000000ffULL, 0x0000535000040107ULL, 0x0001a6a8000000ffULL, 0x000053b000040101ULL,
0x0001a62800000004ULL, 0x000053d0003f0101ULL, 0x0001a62c00000004ULL, 0x000055a0003f0105ULL,
0x0001a62c00000004ULL, 0x00005e50003f0105ULL, 0x0001a6b40000006cULL, 0x00006020003f0105ULL,
0x0001a6b40000006cULL, 0x000072e0003f0105ULL, 0x000000000000006eULL, 0x00007340003f0101ULL,
0x0001a69000000026ULL, 0x00007370003f0101ULL, 0x0000000400000005ULL, 0x00007530003f0105ULL,
0x0000000400000005ULL, 0x00007d80003f0105ULL, 0x0001a6b000000025ULL, 0x00007e50003f0107ULL,
0x0001a6b000000025ULL, 0x00007eb0003f0101ULL, 0x0001a64800000004ULL, 0x00007ed0003f0101ULL,
0x0001a64c00000004ULL, 0x000080a0003f0105ULL, 0x0001a64c00000004ULL, 0x00008960003f0105ULL,
0x0001a6ac00000070ULL, 0x00008b30003f0105ULL, 0x0001a6ac00000070ULL, 0x00009e10003f0105ULL,
0x0000000000000025ULL, 0x00009e70003f0101ULL, 0x0001a6980000001aULL, 0x00009ea0003f0101ULL,
0x0000000400000025ULL, 0x0000a080003f0105ULL, 0x0000000400000025ULL, 0x0000a9c0003f0105ULL,
0x0001a6a800000020ULL, 0x0000aa60003f0107ULL, 0x0001a6a800000020ULL, 0x0000aac0003f0101ULL,
0x0001a66800000006ULL, 0x0000aaf0003f0101ULL, 0x0001a66c00000006ULL, 0x0000acc0003f0105ULL,
0x0001a66c00000006ULL, 0x0000b550003f0105ULL, 0x0001a6b400000024ULL, 0x0000b720003f0105ULL,
0x0001a6b400000024ULL, 0x0000ca90003f0105ULL, 0x0000000000000005ULL, 0x0000cb10003f0101ULL,
0x0000000000000004ULL, 0x0000e870003f0101ULL, 0x0001a600000000ffULL, 0x00010160003f0101ULL,
0x0001a604000000ffULL, 0x00010330003f0105ULL, 0x0001a604000000ffULL, 0x000106b0003f0105ULL,
0x0001a600000000ffULL, 0x000106e0003f0101ULL, 0x0001a604000000ffULL, 0x000108a0003f0105ULL,
0x0001a604000000ffULL, 0x00013d00003f0105ULL, 0x0000000000000064ULL, 0x00013e10003f0101ULL,
0x0000000400000064ULL, 0x00013fe0003f0105ULL, 0x0000000400000064ULL, 0x00017ab0003f0105ULL,
0x0000000000000063ULL, 0x00017b10003f0101ULL, 0x0000000800000063ULL, 0x00017b70003f0101ULL,
0x0000001000000063ULL, 0x00017be0003f0101ULL, 0x0000001800000063ULL, 0x00053803003f0101ULL,
0x0000dc1000301c04ULL, 0x0000de200000dc40ULL, 0x0000e0e00000df80ULL, 0x0000e3a00000e240ULL,
0x0000e6900000e500ULL, 0x000109000000e790ULL, 0x0000040100017c30ULL, 0x00000100000c0504ULL,
0x0000000100000001ULL, 0x0000000000041e04ULL, 0x0000000000000073ULL, 0x3605002511000000ULL,
0x000000000000034cULL, 0x0000001900000002ULL, 0x0000000000000274ULL, 0x0000001900000002ULL,
0x00000000000001acULL, 0x0000001900000002ULL, 0x00000000000000ccULL, 0x0000001900000002ULL,
0x0000000000000044ULL, 0x0000001900000002ULL, 0x0000000000000325ULL, 0x0000001900000002ULL,
0x000000000000024dULL, 0x0000001900000002ULL, 0x0000000000000182ULL, 0x0000001900000002ULL,
0x00000000000000a8ULL, 0x0000001900000002ULL, 0x000000000001a700ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000a00ff017624ULL, 0x000fc400078e00ffULL, 0x0000590000007b06ULL, 0x000e620000209000ULL,
0x00005900ff167624ULL, 0x000fe200078e00ffULL, 0x00005900ff007a0cULL, 0x000fe20003f45070ULL,
0x00000000007a7919ULL, 0x000ea20000002600ULL, 0x0000580000047ab9ULL, 0x000fe40000000800ULL,
0x00005a0000057ab9ULL, 0x000fe20000000800ULL, 0x00000000000a7919ULL, 0x000ee20000002300ULL,
0x0000000504047299ULL, 0x000fe2000800063fULL, 0x00005a0016847a19ULL, 0x000fe200000006ffULL,
0x0000460000087ab9ULL, 0x000fe20000000a00ULL, 0x0000000000097919ULL, 0x000f280000002100ULL,
0x0000000000137919ULL, 0x000ea20000002700ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fc40007ffe0ffULL, 0x00000005ff127819ULL, 0x010fc80000011609ULL,
0x0000000200037305ULL, 0x000324000021f000ULL, 0x00001fff12127589ULL, 0x000fe200000e0000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x000000ffff057224ULL, 0x010fc800078e0a03ULL,
0x0000590005057a24ULL, 0x000fc800078e02ffULL, 0x0000000503037227ULL, 0x000fcc00078e0002ULL,
0x0000040003077a27ULL, 0x000fc800078e00ffULL, 0x000000ffff037224ULL, 0x000fc800078e0a07ULL,
0x0000040003007624ULL, 0x000fca00078e0216ULL, 0x0000590000007a0cULL, 0x000fda0003f06070ULL,
0x8000590000000a10ULL, 0x000fe40007ffe0ffULL, 0x0000000107070810ULL, 0x000fe40007ffe0ffULL,
0x0000590000007a0cULL, 0x000fda0003f26070ULL, 0x0000000107071810ULL, 0x000fe40007ffe0ffULL,
0x00005900ff07aa12ULL, 0x000fc800078e33ffULL, 0x0000000700007306ULL, 0x000e620000209000ULL,
0x000000ff0700720cULL, 0x000fce0003f85070ULL, 0x0000000000007308ULL, 0x002e640000001000ULL,
0x0ffffffe00027810ULL, 0x002fcc0007ffe0ffULL, 0x0000000200037305ULL, 0x000324000021f000ULL,
0x000000ffff027224ULL, 0x002fe400078e00ffULL, 0x0000000307047224ULL, 0x010fc800078e02ffULL,
0x000000ffff057224ULL, 0x000fc800078e0a04ULL, 0x0000000503037227ULL, 0x000fe400078e0002ULL,
0x0000000000057919ULL, 0x000ee80000002200ULL, 0x0000007a03147227ULL, 0x004fc800078e00ffULL,
0x000000ffff007224ULL, 0x000fc800078e0a14ULL, 0x0000000007007224ULL, 0x000fca00078e027aULL,
0x000000070000720cULL, 0x000fe20003f46070ULL, 0x000001000a027a24ULL, 0x008fc800078e0205ULL,
0x00000000020b7a24ULL, 0x000fd000078e0209ULL, 0x0000000100002824ULL, 0x000fe200078e0a07ULL,
0x0000000114142810ULL, 0x000fe20007ffe0ffULL, 0x00001fff0a097589ULL, 0x000e6200000e0000ULL,
0x000000ff0b00720cULL, 0x040fe40003fa5270ULL, 0x000000070000720cULL, 0x000fe40003f66070ULL,
0x0000007f0b00780cULL, 0x040fe40003f04070ULL, 0x0000000f0b00780cULL, 0x040fe40003f24070ULL,
0x000000030b00780cULL, 0x000fca0003f44070ULL, 0x3fffff80ff02d424ULL, 0x000fe400078e00ffULL,
0x0000000114143810ULL, 0x000fe20007ffe0ffULL, 0x7fffff80ff03d424ULL, 0x000fe200078e00ffULL,
0x00000007ff14c212ULL, 0x000fe200078e33ffULL, 0xff317217ff088424ULL, 0x000fe200078e00ffULL,
0x000000010b00780cULL, 0x000fe20003f64070ULL, 0x3fffffc0ff049424ULL, 0x000fe200078e00ffULL,
0x01a60002ff00d388ULL, 0x0005e20000000a00ULL, 0x000000ffff007224ULL, 0x000fe200078e0a14ULL,
0x00005a0014797a19ULL, 0x000fe200000006ffULL, 0x7fffffc0ff059424ULL, 0x000fe200078e00ffULL,
0x01a400080b008388ULL, 0x0007e20000004800ULL, 0x00000000077a7224ULL, 0x000fc600078e027aULL,
0x01a608040b009388ULL, 0x0009e20000008a00ULL, 0x000000207a007824ULL, 0x000fe400078e00ffULL,
0x3fffff60ff02a424ULL, 0x004fe400078e00ffULL, 0x7fffff60ff03a424ULL, 0x000fe200078e00ffULL,
0x0000000400087c10ULL, 0x048fe2000fffe1ffULL, 0x3fffffc0ff06b424ULL, 0x000fe200078e00ffULL,
0x0000000400007c0cULL, 0x000fe2000bf03070ULL, 0x7fffffc0ff07b424ULL, 0x000fe200078e00ffULL,
0x0000002008087817ULL, 0x000fe20003800000ULL, 0x01a688020b00a388ULL, 0x0005e20000008a00ULL,
0x3fffff80ff04a424ULL, 0x010fc400078e00ffULL, 0x000000ff08787207ULL, 0x000fe20000000000ULL,
0x7fffff80ff05a424ULL, 0x000fe400078e00ffULL, 0x0000000409087824ULL, 0x002fe200078e0212ULL,
0x000000207800780cULL, 0x000fe40003f05270ULL, 0x01a6a8040b00a388ULL, 0x000fe20000008a00ULL,
0x0000000408087824ULL, 0x000fe400078e00ffULL, 0x0000580013027a24ULL, 0x004fe200078e02ffULL,
0x01a6c8060b00b388ULL, 0x000fe60000008a00ULL, 0x0000008402027224ULL, 0x000fe200078e0279ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000002e000008947ULL, 0x000fea0003800000ULL,
0x0000000000117919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe20000000000ULL,
0x0000000878037217ULL, 0x000fe20007800000ULL, 0x00005a0000057ab9ULL, 0x000fc40000000800ULL,
0x0000000504047299ULL, 0x000fe4000800063fULL, 0x0000000103037824ULL, 0x000fe200078e0a08ULL,
0x00000004ff047819ULL, 0x002fc80000011611ULL, 0x0000000204067810ULL, 0x000fe20007ffe0ffULL,
0x00000001080a7824ULL, 0x000fe200078e0204ULL, 0x000000030400720cULL, 0x080fe20003f06070ULL,
0x0000001011047824ULL, 0x000fe200078e00ffULL, 0x000000030600720cULL, 0x000fe20003f26070ULL,
0x00000001080b7824ULL, 0x000fe400078e0206ULL, 0x0000000100057824ULL, 0x040fe400078e020aULL,
0x00000001000c7824ULL, 0x000fc600078e020bULL, 0x0000000405077c12ULL, 0x000fe4000f8e30ffULL,
0x000000040c0d7c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff057a19ULL, 0x000fe20000011605ULL,
0x0000000102077824ULL, 0x040fe400078e0207ULL, 0x0000000102087824ULL, 0x000fe200078e020dULL,
0x00005a00ff0d7a19ULL, 0x000fe2000001160cULL, 0x0000008405027224ULL, 0x000fe200078e0207ULL,
0x000000f004057812ULL, 0x000fc600078ec0ffULL, 0x000000840d077224ULL, 0x000fe400078e0208ULL,
0x0000010002027825ULL, 0x000fc800078e00ffULL, 0x0000010007067825ULL, 0x000fe200078e00ffULL,
0x0000000502027212ULL, 0x000fc600078efcffULL, 0x000000010a087824ULL, 0x100fe200078e0211ULL,
0x0000000506057212ULL, 0x000fe200078efcffULL, 0x000000100a0d7824ULL, 0x000fe200078e00ffULL,
0x00005e0002027a10ULL, 0x000fe20007f5e0ffULL, 0x000000010b0a7824ULL, 0x000fe200078e0211ULL,
0x00005e0005067a10ULL, 0x000fe20007f7e0ffULL, 0x000000100b0b7824ULL, 0x000fe200078e00ffULL,
0xfffffff00d087812ULL, 0x000fe400078ee208ULL, 0x00005f0003037a10ULL, 0x000fe400017fe4ffULL,
0xfffffff00b0a7812ULL, 0x000fe200078ee20aULL, 0x0000001008057824ULL, 0x000fe200078e00ffULL,
0x00005f0007077a10ULL, 0x000fc60001ffe4ffULL, 0x000000100a0b7824ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e8000c101c48ULL,
0x00000000060b7faeULL, 0x0003e2000c901c48ULL, 0x0000027000007947ULL, 0x000fea0003800000ULL,
0x0000000000117919ULL, 0x000e620000000000ULL, 0xffffffff00047882ULL, 0x000fe40000000000ULL,
0x00005a0000057ab9ULL, 0x000fe40000000800ULL, 0x0000000504047299ULL, 0x000fe2000800063fULL,
0x0000000811087211ULL, 0x002fc800078fe0ffULL, 0x00000002080a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000100037824ULL, 0x000fe400078e0208ULL, 0x00000010080c7824ULL, 0x000fe400078e00ffULL,
0x0000000100047824ULL, 0x000fe200078e020aULL, 0x0000000403057c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff037a19ULL, 0x000fe40000011603ULL, 0x0000000404077c12ULL, 0x000fe2000f8e30ffULL,
0x0000000102057824ULL, 0x000fc800078e0205ULL, 0x0000000102027824ULL, 0x000fe200078e0207ULL,
0x00005a00ff077a19ULL, 0x000fe20000011604ULL, 0x0000008403037224ULL, 0x080fe400078e0205ULL,
0x0000001011047824ULL, 0x000fe400078e00ffULL, 0x0000008407077224ULL, 0x000fe400078e0202ULL,
0x0000010003027825ULL, 0x000fe200078e00ffULL, 0x000000f0040b7812ULL, 0x000fc600078ec0ffULL,
0x0000010007067825ULL, 0x000fe200078e00ffULL, 0x0000000b02027212ULL, 0x000fc600078efcffULL,
0x0000000108057824ULL, 0x100fe200078e0211ULL, 0x0000000b06067212ULL, 0x000fe200078efcffULL,
0x000000010a087824ULL, 0x000fe200078e0211ULL, 0x00005e0002027a10ULL, 0x000fe20007f1e0ffULL,
0x000000100a0b7824ULL, 0x000fe200078e00ffULL, 0xfffffff00c057812ULL, 0x000fe400078ee205ULL,
0x00005e0006067a10ULL, 0x000fe40007f3e0ffULL, 0xfffffff00b087812ULL, 0x000fe200078ee208ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x00005f0003037a10ULL, 0x000fc400007fe4ffULL,
0x00005f0007077a10ULL, 0x000fe20000ffe4ffULL, 0x00000010080b7824ULL, 0x000fe400078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002057faeULL, 0x0003e8000b901c48ULL,
0x00000000060b7faeULL, 0x0003e4000b901c48ULL, 0x0000000000037919ULL, 0x002e620000000000ULL,
0x0000000000057806ULL, 0x000fc600038e0000ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000000500027300ULL, 0x000e7000000e0000ULL, 0x0000000500067309ULL, 0x000ea20000000000ULL,
0x000000030200720cULL, 0x002fe20003f02070ULL, 0x000000ffff077224ULL, 0x004fc400078e0a06ULL,
0x00000004ff067424ULL, 0x000fc800078e00ffULL, 0x0000660013027625ULL, 0x000fcc00078e0006ULL,
0x01a60407ffff038cULL, 0x0003e80000000200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x01a60000ff0079b0ULL, 0x000fe20008000a3fULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000802107981ULL, 0x000ea2000c1e1900ULL,
0x000000ff0900720cULL, 0x000fe40003f05270ULL, 0x0000003f100f7810ULL, 0x044fe40007ffe0ffULL,
0x000000ff10057810ULL, 0x000fc40007ffe0ffULL, 0x00000006ff0f7819ULL, 0x000fe4000001160fULL,
0x00000008ff0e7819ULL, 0x000fca0000011605ULL, 0x0000db4000008947ULL, 0x000fea0003800000ULL,
0x00000002ff0d7819ULL, 0x000fe20000011612ULL, 0x00000003ff087424ULL, 0x000fe200078e00ffULL,
0x0001a68812077811ULL, 0x002fe400078e18ffULL, 0x03ffffff0d0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000f0a00720cULL, 0x000fda0003f06070ULL, 0x0000000213008824ULL, 0x000fe400078e00ffULL,
0x00006800ff038624ULL, 0x000fc800078e00ffULL, 0x0000680000038624ULL, 0x000fe400078e0203ULL,
0xffffffffff007424ULL, 0x000fe400078e00ffULL, 0x000000010a038824ULL, 0x000fe200078e0203ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000040807ff738cULL, 0x0003e20000000000ULL,
0x0000640003028625ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000802008981ULL, 0x000ea2000c1e1900ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x00000040140b7824ULL, 0x000fe200078e00ffULL, 0x00000001ff0c7819ULL, 0x000fe20000011612ULL,
0x0000000007ff7f8cULL, 0x0007e8000c80043fULL, 0x000000200c7b7824ULL, 0x000fca00078e00ffULL,
0x000000200b057812ULL, 0x000fe200078ef87bULL, 0x0000590000087a24ULL, 0x006fe200078e02ffULL,
0x0000000112007812ULL, 0x000fc600078ec0ffULL, 0x00000040081f7824ULL, 0x000fe200078e00ffULL,
0x0000040000000947ULL, 0x000fea0003800000ULL, 0x0000001000037824ULL, 0x008fe200078e00ffULL,
0x0000007b10007217ULL, 0x000fe40007800000ULL, 0x00000003ff027819ULL, 0x000fe40000011611ULL,
0x000062001f1d7a11ULL, 0x000fe200078838ffULL, 0x0000000100007824ULL, 0x000fe200078e0a7bULL,
0x0000000402097810ULL, 0x040fe20007ffe0ffULL, 0x0000000103087824ULL, 0x000fe200078e0202ULL,
0x0000000c02157810ULL, 0x000fc40007ffe0ffULL, 0x0000000300007217ULL, 0x000fe20007800000ULL,
0x0000000108077824ULL, 0x040fe200078e0211ULL, 0x000063001f1f7a11ULL, 0x000fe200020f3cffULL,
0x0000000808147824ULL, 0x000fe400078e00ffULL, 0x0000000100007824ULL, 0x000fe400078e0a03ULL,
0x0000000103167824ULL, 0x000fe200078e0215ULL, 0xfffffff814077812ULL, 0x000fe400078ee207ULL,
0x0000000802147810ULL, 0x040fe20007ffe0ffULL, 0x0000000105177824ULL, 0x040fe200078e0216ULL,
0x000000000200720cULL, 0x080fe20003f66070ULL, 0x0000000105027824ULL, 0x000fe200078e0208ULL,
0x000000001400720cULL, 0x080fe20003f26070ULL, 0x0000000103087824ULL, 0x000fe200078e0209ULL,
0x000000000900720cULL, 0x080fe20003f46070ULL, 0x0000000103147824ULL, 0x000fe200078e0214ULL,
0x000000001500720cULL, 0x000fe20003f06070ULL, 0x0000000108037824ULL, 0x000fc400078e0211ULL,
0x0000000808187824ULL, 0x000fe400078e00ffULL, 0x0000000114097824ULL, 0x040fe400078e0211ULL,
0x00000008141a7824ULL, 0x000fe200078e00ffULL, 0xfffffff818197812ULL, 0x000fe200078ee203ULL,
0x0000008002027825ULL, 0x000fc600078e00ffULL, 0xfffffff81a1b7812ULL, 0x000fe200078ee209ULL,
0x0000000105087824ULL, 0x040fe200078e0208ULL, 0x0000007002027812ULL, 0x000fe200078ef804ULL,
0x0000000105147824ULL, 0x000fe400078e0214ULL, 0x0000008008087825ULL, 0x000fe200078e00ffULL,
0x000000021d027210ULL, 0x000fc60007f9e0ffULL, 0x0000000116007824ULL, 0x000fe200078e0211ULL,
0x0000007008187812ULL, 0x000fe200078ef804ULL, 0x0000000816057824ULL, 0x000fe400078e00ffULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0xfffffff805057812ULL, 0x000fe200078ee200ULL,
0x0000008017167825ULL, 0x000fe200078e00ffULL, 0x0000007014087812ULL, 0x100fe400078ef804ULL,
0x000160000c007811ULL, 0x000fe200078e68ffULL, 0x0000000103037824ULL, 0x100fe200020e061fULL,
0x0000007016147812ULL, 0x000fe400078ef804ULL, 0x0000001d18047210ULL, 0x080fe20007f9e0ffULL,
0x0000001007077824ULL, 0x100fe200078e0200ULL, 0x0000001d08087210ULL, 0x080fe20007fbe0ffULL,
0x0000001019197824ULL, 0x100fe200078e0200ULL, 0x0000001d14147210ULL, 0x000fe20007fde0ffULL,
0x00000010051d7824ULL, 0x000fe200078e0200ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002077faeULL, 0x0003e2000d901c48ULL, 0x0000000109057824ULL, 0x000fc400020e061fULL,
0x000000101b1b7824ULL, 0x000fe400078e0200ULL, 0x0000000115097824ULL, 0x100fe200028e061fULL,
0x0000000004197faeULL, 0x0003e2000d101c48ULL, 0x0000000117157824ULL, 0x000fc600030e061fULL,
0x00000000081b7faeULL, 0x0003e8000c901c48ULL, 0x00000000141d7faeULL, 0x0003e2000c101c48ULL,
0x0000033000007947ULL, 0x000fea0003800000ULL, 0x0000001000007824ULL, 0x008fe200078e00ffULL,
0x000062001f197a11ULL, 0x000fe400078038ffULL, 0x000160000c1d7811ULL, 0x000fe400078e68ffULL,
0x0000000011007211ULL, 0x000fc400078fe8ffULL, 0x000063001f1f7a11ULL, 0x000fe400000f3cffULL,
0x0000000400087810ULL, 0x040fe20007ffe0ffULL, 0x0000000100027824ULL, 0x140fe200078e0211ULL,
0x0000000800147810ULL, 0x040fe20007ffe0ffULL, 0x0000000800077824ULL, 0x000fe400078e00ffULL,
0x0000000108037824ULL, 0x140fe400078e0211ULL, 0x0000000808187824ULL, 0x000fe200078e00ffULL,
0xfffffff807077812ULL, 0x000fe200078ee202ULL, 0x0000000105027824ULL, 0x000fe200078e0200ULL,
0x0000000c00007810ULL, 0x000fe20007ffe0ffULL, 0x0000000114097824ULL, 0x000fe200078e0211ULL,
0xfffffff818187812ULL, 0x000fe200078ee203ULL, 0x00000008141a7824ULL, 0x000fc400078e00ffULL,
0x0000008002027825ULL, 0x000fc600078e00ffULL, 0xfffffff81a1a7812ULL, 0x000fe200078ee209ULL,
0x0000000105087824ULL, 0x040fe200078e0208ULL, 0x0000007002027812ULL, 0x000fe200078ef804ULL,
0x0000000105147824ULL, 0x040fe400078e0214ULL, 0x0000000105167824ULL, 0x000fe200078e0200ULL,
0x0000000219027210ULL, 0x000fe20007f1e0ffULL, 0x0000000100057824ULL, 0x040fe400078e0211ULL,
0x0000000800007824ULL, 0x000fe400078e00ffULL, 0x0000008008087825ULL, 0x000fc600078e00ffULL,
0xfffffff800057812ULL, 0x000fe200078ee205ULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000007008007812ULL, 0x000fc600078ef804ULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000007014087812ULL, 0x000fc600078ef804ULL, 0x0000000103037824ULL, 0x000fe200000e061fULL,
0x0000007016147812ULL, 0x000fe200078ef804ULL, 0x0000001007077824ULL, 0x100fe200078e021dULL,
0x0000000019047210ULL, 0x040fe20007f1e0ffULL, 0x000000101a1b7824ULL, 0x100fe200078e021dULL,
0x0000000819087210ULL, 0x040fe40007f3e0ffULL, 0x0000001419147210ULL, 0x000fe20007f5e0ffULL,
0x0000001018197824ULL, 0x100fe200078e021dULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002077faeULL, 0x0003e2000b901c48ULL, 0x00000010051d7824ULL, 0x000fc400078e021dULL,
0x0000000109057824ULL, 0x100fe400000e061fULL, 0x0000000115097824ULL, 0x100fe400008e061fULL,
0x0000000117157824ULL, 0x000fe200010e061fULL, 0x0000000004197faeULL, 0x0003e8000b901c48ULL,
0x00000000081b7faeULL, 0x0003e8000b901c48ULL, 0x00000000141d7faeULL, 0x0003e4000b901c48ULL,
0x000000010a0a7810ULL, 0x000fe20007ffe0ffULL, 0xffffffffff227424ULL, 0x000fc600078e00ffULL,
0x0000000f0a00720cULL, 0x000fda0003f06070ULL, 0x0000006000000947ULL, 0x000fea0003800000ULL,
0x0000000213007824ULL, 0x000fe400078e00ffULL, 0x00006800ff037624ULL, 0x002fc800078e00ffULL,
0x0000680000037624ULL, 0x000fc800078e0203ULL, 0x0000000103077824ULL, 0x000fc800078e020aULL,
0x0000640007067625ULL, 0x000fca00078e0006ULL, 0x0000000806227981ULL, 0x000324000c1e1900ULL,
0x000000000c0473c2ULL, 0x000ea200000e0000ULL, 0x000000ff0e00720cULL, 0x000fe20003f05270ULL,
0x000000ffff1c7224ULL, 0x000fe200078e00ffULL, 0x0001a6a80c027811ULL, 0x002fe200078e18ffULL,
0x00000000006a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000687805ULL, 0x000fe2000001ff00ULL,
0x0000000000667805ULL, 0x000fe2000001ff00ULL, 0x0000000000647805ULL, 0x000fe2000001ff00ULL,
0x0000000000627805ULL, 0x000fe2000001ff00ULL, 0x0000000000607805ULL, 0x000fe2000001ff00ULL,
0x00000000005e7805ULL, 0x000fe2000001ff00ULL, 0x00000000005c7805ULL, 0x000fe2000001ff00ULL,
0x00000000005a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000587805ULL, 0x000fe2000001ff00ULL,
0x0000000000567805ULL, 0x000fe2000001ff00ULL, 0x0000000000547805ULL, 0x000fe2000001ff00ULL,
0x0000000000527805ULL, 0x000fe2000001ff00ULL, 0x0000000000507805ULL, 0x000fe2000001ff00ULL,
0x00000000004e7805ULL, 0x000fe2000001ff00ULL, 0x00000000004c7805ULL, 0x000fe2000001ff00ULL,
0x00000000004a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000487805ULL, 0x000fe2000001ff00ULL,
0x0000000000467805ULL, 0x000fe2000001ff00ULL, 0x0000000000447805ULL, 0x000fe2000001ff00ULL,
0x0001a6a804047891ULL, 0x004fe2000f8e203fULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x000000ffff3d7224ULL, 0x000fca00078e00ffULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x00000000ff187f8cULL, 0x000e62000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000200002027f8cULL, 0x000ea2000c80043fULL,
0x000000ffff3c7224ULL, 0x000fe200078e00ffULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000b1f000008947ULL, 0x000fea0003800000ULL,
0x000000100c077824ULL, 0x000fe400078e00ffULL, 0x0000000213097824ULL, 0x000fc400078e00ffULL,
0x00006800ff007624ULL, 0x000fe200078e00ffULL, 0x0000001007077812ULL, 0x000fe200078ee2ffULL,
0x000000ffff187224ULL, 0x002fe400078e0019ULL, 0x000000ffff177224ULL, 0x004fe400078e0003ULL,
0x0000680009097624ULL, 0x000fe400078e0200ULL, 0xff317217ff1a7424ULL, 0x000fe400078e00ffULL,
0x000000ffff087224ULL, 0x000fc400078e00ffULL, 0x000000ffff6b7224ULL, 0x000fc400078e00ffULL,
0x000000ffff067224ULL, 0x000fe400078e000aULL, 0x000000ffff1e7224ULL, 0x00afc600078e00ffULL,
0x0000000000027805ULL, 0x000fc80000015200ULL, 0x0000000412047824ULL, 0x000fca00078e00ffULL,
0xfffffff804197812ULL, 0x000fc800078ec0ffULL, 0x0001a6c8191b7810ULL, 0x000fe20007ffe0ffULL,
0x01a6cc0019047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x0000021000007945ULL, 0x000fe20003800000ULL,
0x000000ffff057224ULL, 0x000fe200078e001bULL, 0x000001e000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101e00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000047805ULL, 0x000fcc0000015200ULL,
0x00000004021d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000105057824ULL, 0x000fe200000e0e03ULL,
0x003d09001d00780cULL, 0x000fc80003f06070ULL, 0x000000ff0500720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401d00780cULL, 0x000fc80003f06070ULL,
0x000000ff0500720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff047819ULL, 0x000fc80000011405ULL, 0x0000001d04047211ULL, 0x000fca00078110ffULL,
0x000000ffff057224ULL, 0x000fca00000e0605ULL, 0x0000000204047819ULL, 0x000fc80000001205ULL,
0x000000040000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000011e1e7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x01a6cc0019047984ULL, 0x000e640000000800ULL, 0x8000000004ff7812ULL, 0x002fe40007804817ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x000000ffff057224ULL, 0x000fc400078e001bULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001012027824ULL, 0x000fe200078e00ffULL,
0x0000000108177810ULL, 0x000fe20007ffe0ffULL, 0x0000590022227a24ULL, 0x010fc600078e02ffULL,
0xffffffe002037812ULL, 0x000fe200078ec0ffULL, 0x0000004022277824ULL, 0x000fe200078e00ffULL,
0x0000000e1700720cULL, 0x000fc60003f26070ULL, 0x0000010008037824ULL, 0x000fca00078e0203ULL,
0x0000004003197810ULL, 0x000fc80007ffe0ffULL, 0x0000002019047812ULL, 0x000fca00078ec0ffULL,
0x000000010b237824ULL, 0x000fe200078e0204ULL, 0x0000042000009947ULL, 0x000fea0003800000ULL,
0x0000001002037812ULL, 0x000fe200078ec0ffULL, 0x00000010111d7824ULL, 0x000fe200078e00ffULL,
0x0000001910027217ULL, 0x000fe40007800000ULL, 0x00000003ff1b7819ULL, 0x000fe40000011611ULL,
0x000000701d297812ULL, 0x000fe200078ec0ffULL, 0x0000000102027824ULL, 0x000fe200078e0a19ULL,
0x000000041b1e7810ULL, 0x040fe20007ffe0ffULL, 0x000000011b047824ULL, 0x000fe200078e0203ULL,
0x0000620027257a11ULL, 0x000fc400078a38ffULL, 0x0000000302027217ULL, 0x000fe20007800000ULL,
0x0000000104177824ULL, 0x040fe200078e0211ULL, 0x0000630027277a11ULL, 0x000fe200028f3cffULL,
0x0000000804207824ULL, 0x000fe400078e00ffULL, 0x0000000102027824ULL, 0x000fc600078e0a03ULL,
0xfffffff820177812ULL, 0x000fe400078ee217ULL, 0x000000081b207810ULL, 0x040fe40007ffe0ffULL,
0x000000021b00720cULL, 0x0c0fe40003f86070ULL, 0x0000000c1b1b7810ULL, 0x000fe40007ffe0ffULL,
0x000000021e00720cULL, 0x0c0fe20003f66070ULL, 0x000000011e1e7824ULL, 0x100fe200078e0203ULL,
0x000000022000720cULL, 0x0c0fe20003f46070ULL, 0x0000000120207824ULL, 0x100fe200078e0203ULL,
0x000000021b00720cULL, 0x040fe20003f06070ULL, 0x000000011b227824ULL, 0x000fc400078e0203ULL,
0x000000011e037824ULL, 0x040fe400078e0211ULL, 0x000000081e247824ULL, 0x000fe400078e00ffULL,
0x0000000123027824ULL, 0x040fe400078e0204ULL, 0x00000001231e7824ULL, 0x000fe200078e021eULL,
0xfffffff824197812ULL, 0x000fe200078ee203ULL, 0x0000008002027825ULL, 0x000fc800078e00ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x0000002902027212ULL, 0x000fc600078efcffULL,
0x00000001201b7824ULL, 0x040fe200078e0211ULL, 0x0000000225027210ULL, 0x000fe20007fbe0ffULL,
0x0000000820267824ULL, 0x000fe200078e00ffULL, 0x000000291e1e7212ULL, 0x000fe200078efcffULL,
0x0000000123207824ULL, 0x040fe400078e0220ULL, 0x0000000123237824ULL, 0x000fe200078e0222ULL,
0xfffffff8261b7812ULL, 0x000fe200078ee21bULL, 0x0000000122047824ULL, 0x040fe400078e0211ULL,
0x00000008221d7824ULL, 0x000fc400078e00ffULL, 0x0000008020207825ULL, 0x000fc600078e00ffULL,
0xfffffff81d1d7812ULL, 0x000fe200078ee204ULL, 0x0000008023227825ULL, 0x000fe200078e00ffULL,
0x0000002920207212ULL, 0x000fe400078efcffULL, 0x000170000c047811ULL, 0x000fe200078e68ffULL,
0x0000000103037824ULL, 0x100fe200028e0627ULL, 0x000000251e1e7210ULL, 0x000fe40007fbe0ffULL,
0x0000002922227212ULL, 0x000fe200078efcffULL, 0x0000001017177824ULL, 0x100fe400078e0204ULL,
0x000000011f1f7824ULL, 0x100fe200028e0627ULL, 0x0000002520207210ULL, 0x080fe20007fbe0ffULL,
0x0000001019197824ULL, 0x100fe200078e0204ULL, 0x0000002522227210ULL, 0x000fe20007fde0ffULL,
0x000000101b1b7824ULL, 0x000fe200078e0204ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000002177faeULL, 0x0003e2000e101c48ULL, 0x0000000121217824ULL, 0x000fc400028e0627ULL,
0x000000101d1d7824ULL, 0x000fe200078e0204ULL, 0x000000001e197faeULL, 0x0003e2000d901c48ULL,
0x0000000123237824ULL, 0x000fc600030e0627ULL, 0x00000000201b7faeULL, 0x0003e8000d101c48ULL,
0x00000000221d7faeULL, 0x0003e2000c101c48ULL, 0x0000035000007947ULL, 0x000fea0003800000ULL,
0x0000001002027812ULL, 0x000fe400078ec0ffULL, 0x0000620027297a11ULL, 0x000fe400078038ffULL,
0x0000000211027211ULL, 0x000fe400078fe8ffULL, 0x0000630027277a11ULL, 0x000fc400000f3cffULL,
0x00000004021e7810ULL, 0x040fe20007ffe0ffULL, 0x0000000102037824ULL, 0x140fe200078e0211ULL,
0x0000000802207810ULL, 0x040fe20007ffe0ffULL, 0x0000000802047824ULL, 0x000fe400078e00ffULL,
0x000000011e177824ULL, 0x040fe400078e0211ULL, 0x000000081e227824ULL, 0x000fe200078e00ffULL,
0xfffffff804047812ULL, 0x000fe200078ee203ULL, 0x0000000123037824ULL, 0x000fe400078e0202ULL,
0x00000001201b7824ULL, 0x000fe200078e0211ULL, 0xfffffff822197812ULL, 0x000fe200078ee217ULL,
0x0000001011177824ULL, 0x000fe200078e00ffULL, 0x0000000c02227810ULL, 0x000fe20007ffe0ffULL,
0x0000008003027825ULL, 0x000fc600078e00ffULL, 0x0000007017257812ULL, 0x000fe200078ec0ffULL,
0x0000000820247824ULL, 0x000fe400078e00ffULL, 0x00000001231e7824ULL, 0x040fe200078e021eULL,
0x0000002502027212ULL, 0x000fe200078efcffULL, 0x0000000123207824ULL, 0x040fe200078e0220ULL,
0xfffffff8241b7812ULL, 0x000fe200078ee21bULL, 0x0000000123237824ULL, 0x000fe200078e0222ULL,
0x0000000229027210ULL, 0x000fe20007f1e0ffULL, 0x000000801e1e7825ULL, 0x000fc800078e00ffULL,
0x0000000122177824ULL, 0x000fe200078e0211ULL, 0x000000251e1e7212ULL, 0x000fe200078efcffULL,
0x0000000822247824ULL, 0x000fe400078e00ffULL, 0x0000008020207825ULL, 0x000fc600078e00ffULL,
0xfffffff8241d7812ULL, 0x000fe200078ee217ULL, 0x0000008023227825ULL, 0x000fe200078e00ffULL,
0x0000002520207212ULL, 0x080fe400078efcffULL, 0x000170000c247811ULL, 0x000fe200078e68ffULL,
0x0000000103037824ULL, 0x100fe200000e0627ULL, 0x0000002522227212ULL, 0x000fe400078efcffULL,
0x0000001e291e7210ULL, 0x040fe20007f1e0ffULL, 0x0000001004177824ULL, 0x100fe200078e0224ULL,
0x0000002029207210ULL, 0x000fe20007f5e0ffULL, 0x0000001019197824ULL, 0x100fe200078e0224ULL,
0x0000002229227210ULL, 0x000fe20007f7e0ffULL, 0x000000011f1f7824ULL, 0x000fe200000e0627ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000002177faeULL, 0x0003e2000b901c48ULL,
0x000000101b1b7824ULL, 0x000fc400078e0224ULL, 0x0000000121217824ULL, 0x100fe200010e0627ULL,
0x000000001e197faeULL, 0x0003e2000b901c48ULL, 0x000000101d1d7824ULL, 0x000fe400078e0224ULL,
0x0000000123237824ULL, 0x000fe200018e0627ULL, 0x00000000201b7faeULL, 0x0003e8000b901c48ULL,
0x00000000221d7faeULL, 0x0003e4000b901c48ULL, 0x0000000812287824ULL, 0x000fe200078e00ffULL,
0x000000010a027810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff227424ULL, 0x000fc600078e00ffULL,
0xfffffff028297812ULL, 0x000fe400078ec0ffULL, 0x0000000f0200720cULL, 0x000fe40003f06070ULL,
0x00000000290473c2ULL, 0x000e6200000e0000ULL, 0x0000001028177812ULL, 0x040fe400078ec0ffULL,
0xffffffe028047812ULL, 0x040fe400078ec0ffULL, 0x0000000828197812ULL, 0x000fcc00078ec0ffULL,
0x0000000109028824ULL, 0x000fe400078e0202ULL, 0x00000004ff038424ULL, 0x000fe200078e00ffULL,
0x0000000419047210ULL, 0x000fe40007ffe017ULL, 0x0000000000007918ULL, 0x000fe20000000000ULL,
0x0000640002028625ULL, 0x000fca00078e0003ULL, 0x0000000802228981ULL, 0x000522000c1e1900ULL,
0x0001a6b004047890ULL, 0x002fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x004fec0000008000ULL,
0x01a6b000296e7f8cULL, 0x0002a2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6080004207f8cULL, 0x000664000c80043fULL, 0x0000000000027805ULL, 0x000fc40000015200ULL,
0x01a60c0004177984ULL, 0x000ee40000000800ULL, 0x8000000017ff7812ULL, 0x00afe40007804821ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001e7805ULL, 0x000fcc0000015200ULL, 0x0000001e021e7210ULL, 0x000fca0007f1e1ffULL,
0x000000011f1f7824ULL, 0x000fe200000e0e03ULL, 0x003d09001e00780cULL, 0x000fc80003f06070ULL,
0x000000ff1f00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401e00780cULL, 0x000fc80003f06070ULL, 0x000000ff1f00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff177819ULL, 0x000fc8000001141fULL,
0x0000001e17177211ULL, 0x000fca00078110ffULL, 0x000000ffff1e7224ULL, 0x000fca00000e061fULL,
0x0000000217177819ULL, 0x000fc8000000121eULL, 0x000000170000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000119197810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60c0004177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804821ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002012027824ULL, 0x000fe200078e00ffULL, 0x00000001ff197819ULL, 0x000fe20000011611ULL,
0x0000001011037824ULL, 0x000fc600078e00ffULL, 0xffffff8002177812ULL, 0x000fe400078ec0ffULL,
0x0000007003037812ULL, 0x000fe400078ec0ffULL, 0x0000000c19027812ULL, 0x000fc800078ec0ffULL,
0x0000001702177210ULL, 0x000fca0007ffe003ULL, 0x01a0000017197984ULL, 0x000e680000000800ULL,
0x01a20000171b7984ULL, 0x0006a20000000800ULL, 0x0000001a1900720bULL, 0x002fe20003f1d000ULL,
0x000152b27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000177806ULL, 0x008fc800000e0100ULL,
0x000000ff1700720cULL, 0x000fe20003f05270ULL, 0x0000074000007945ULL, 0x000fe20003800000ULL,
0x00000001ff1e7424ULL, 0x000fe400078e00ffULL, 0x000000ffff237224ULL, 0x000fd200078e001aULL,
0x0000070000008947ULL, 0x000fea0003800000ULL, 0x000000120d00720cULL, 0x000fe40003f05270ULL,
0x0000001a1900720bULL, 0x000fe20003f54000ULL, 0x000152827f007947ULL, 0x000fd8000b800000ULL,
0x0000000000207806ULL, 0x000fc400010e0100ULL, 0x00000080121d8824ULL, 0x000fe200078e0203ULL,
0x0000001a19237209ULL, 0x000fe20007810000ULL, 0x0000063000017945ULL, 0x000fe40003800000ULL,
0x0000000102248824ULL, 0x000fca00078e021dULL, 0x01a4002324008388ULL, 0x0003e20000000800ULL,
0x000000ff2000720cULL, 0x000fda0003f05270ULL, 0x000005e000008947ULL, 0x000fea0003800000ULL,
0x0000001a231a7221ULL, 0x002fe20000010100ULL, 0x000000ff20ff7812ULL, 0x000fe2000780c0ffULL,
0x0000018000027945ULL, 0x000fe40003800000ULL, 0x3fb8aa3b1a1a7820ULL, 0x000fcc0000410000ULL,
0x0000001a001a7308ULL, 0x000e640000000800ULL, 0x0000001a1c1c7220ULL, 0x002fe40000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x000fe20000011611ULL,
0x000151d27f007947ULL, 0x000fea000b800000ULL, 0x00001f271a267589ULL, 0x0002e400000e0000ULL,
0x000000262c2c7220ULL, 0x08cfe40000410000ULL, 0x000000262d2d7220ULL, 0x080fe40000410000ULL,
0x0000002630307220ULL, 0x080fe40000410000ULL, 0x0000002631317220ULL, 0x000fc40000410000ULL,
0x0000002634347220ULL, 0x080fe40000410000ULL, 0x0000002635357220ULL, 0x080fe40000410000ULL,
0x0000002638387220ULL, 0x080fe40000410000ULL, 0x0000002639397220ULL, 0x080fe40000410000ULL,
0x000000263c3c7220ULL, 0x080fe40000410000ULL, 0x000000263d3d7220ULL, 0x000fc40000410000ULL,
0x0000002640407220ULL, 0x080fe40000410000ULL, 0x0000002641417220ULL, 0x080fe40000410000ULL,
0x0000002644447220ULL, 0x080fe40000410000ULL, 0x0000002645457220ULL, 0x080fe40000410000ULL,
0x0000002648487220ULL, 0x080fe40000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0020ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000811277811ULL, 0x002fe200078ff0ffULL, 0x000150c27f007947ULL, 0x000fea000b800000ULL,
0x00001f271a267589ULL, 0x0002e400000e0000ULL, 0x000000262e2e7220ULL, 0x08cfe40000410000ULL,
0x000000262f2f7220ULL, 0x080fe40000410000ULL, 0x0000002632327220ULL, 0x080fe40000410000ULL,
0x0000002633337220ULL, 0x080fe40000410000ULL, 0x0000002636367220ULL, 0x080fe40000410000ULL,
0x0000002637377220ULL, 0x000fc40000410000ULL, 0x000000263a3a7220ULL, 0x080fe40000410000ULL,
0x000000263b3b7220ULL, 0x080fe40000410000ULL, 0x000000263e3e7220ULL, 0x080fe40000410000ULL,
0x000000263f3f7220ULL, 0x080fe40000410000ULL, 0x0000002642427220ULL, 0x080fe40000410000ULL,
0x0000002643437220ULL, 0x000fc40000410000ULL, 0x0000002646467220ULL, 0x080fe40000410000ULL,
0x0000002647477220ULL, 0x080fe40000410000ULL, 0x000000264a4a7220ULL, 0x080fe40000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000020ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001011277811ULL, 0x002fe200078ff0ffULL,
0x00014fb27f007947ULL, 0x000fea000b800000ULL, 0x00001f271a267589ULL, 0x0002e400000e0000ULL,
0x000000264c4c7220ULL, 0x08cfe40000410000ULL, 0x000000264d4d7220ULL, 0x080fe40000410000ULL,
0x0000002650507220ULL, 0x080fe40000410000ULL, 0x0000002651517220ULL, 0x080fe40000410000ULL,
0x0000002654547220ULL, 0x080fe40000410000ULL, 0x0000002655557220ULL, 0x000fc40000410000ULL,
0x0000002658587220ULL, 0x080fe40000410000ULL, 0x0000002659597220ULL, 0x080fe40000410000ULL,
0x000000265c5c7220ULL, 0x080fe40000410000ULL, 0x000000265d5d7220ULL, 0x080fe40000410000ULL,
0x0000002660607220ULL, 0x080fe40000410000ULL, 0x0000002661617220ULL, 0x000fc40000410000ULL,
0x0000002664647220ULL, 0x080fe40000410000ULL, 0x0000002665657220ULL, 0x080fe40000410000ULL,
0x0000002668687220ULL, 0x080fe40000410000ULL, 0x0000002669697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000020ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001811277811ULL, 0x002fe200078ff0ffULL,
0x00014eb27f007947ULL, 0x000fea000b800000ULL, 0x00001f271a267589ULL, 0x0002e400000e0000ULL,
0x000000264e4e7220ULL, 0x08cfe40000410000ULL, 0x000000264f4f7220ULL, 0x080fe40000410000ULL,
0x0000002652527220ULL, 0x080fe40000410000ULL, 0x0000002653537220ULL, 0x080fe40000410000ULL,
0x0000002656567220ULL, 0x080fe40000410000ULL, 0x0000002657577220ULL, 0x000fc40000410000ULL,
0x000000265a5a7220ULL, 0x080fe40000410000ULL, 0x000000265b5b7220ULL, 0x080fe40000410000ULL,
0x000000265e5e7220ULL, 0x080fe40000410000ULL, 0x000000265f5f7220ULL, 0x080fe40000410000ULL,
0x0000002662627220ULL, 0x080fe40000410000ULL, 0x0000002663637220ULL, 0x000fc40000410000ULL,
0x0000002666667220ULL, 0x080fe40000410000ULL, 0x0000002667677220ULL, 0x080fe40000410000ULL,
0x000000266a6a7220ULL, 0x080fe40000410000ULL, 0x000000266b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000002017ff7212ULL, 0x000fda00078030ffULL,
0x8000002319190221ULL, 0x000fe20000010000ULL, 0x00007610ff1e0816ULL, 0x000fc6000000001eULL,
0x3fb8aa3b19190820ULL, 0x000fc80000410000ULL, 0x0000001900000308ULL, 0x000e640000000800ULL,
0x000000001b1b0220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001c1b247221ULL, 0x004fc40000010000ULL, 0x00000000001a7805ULL, 0x000fca0000015200ULL,
0x01a6ac0029177984ULL, 0x000e640000000800ULL, 0x8000000017ff7812ULL, 0x002fe40007804818ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff197224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000101900780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000001c7805ULL, 0x000fcc0000015200ULL, 0x0000001c1a1c7210ULL, 0x000fca0007f1e1ffULL,
0x000000011d1d7824ULL, 0x000fe200000e0e1bULL, 0x003d09001c00780cULL, 0x000fc80003f06070ULL,
0x000000ff1d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c401c00780cULL, 0x000fc80003f06070ULL, 0x000000ff1d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff177819ULL, 0x000fc8000001141dULL,
0x0000001c17177211ULL, 0x000fca00078110ffULL, 0x000000ffff1c7224ULL, 0x000fca00000e061dULL,
0x0000000217177819ULL, 0x000fc8000000121cULL, 0x000000170000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000119197810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6ac0029177984ULL, 0x000e640000000800ULL,
0x8000000017ff7812ULL, 0x002fe40007804818ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000099101e177816ULL, 0x000fe200000000ffULL, 0x0000010000007945ULL, 0x000fe60003800000ULL,
0x000000ff1700720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000000ff13723eULL, 0x000fe400000000ffULL, 0x00000002ff177819ULL, 0x000fe40000011611ULL,
0x0000541013167816ULL, 0x000fe20000000013ULL, 0x00014ac27f007947ULL, 0x000fea000b800000ULL,
0x00001f1716137589ULL, 0x0002a400000e0000ULL, 0x0000000817277810ULL, 0x000fe20007ffe0ffULL,
0x00014b127f007947ULL, 0x000fea000b800000ULL, 0x0000001017157810ULL, 0x000fe20007ffe0ffULL,
0x00001f2716147589ULL, 0x00066a00000e0000ULL, 0x00001f1516157589ULL, 0x0006a400000e0000ULL,
0x0000001817277810ULL, 0x008fe20007ffe0ffULL, 0x00014ba27f007947ULL, 0x000fea000b800000ULL,
0x00001f2716167589ULL, 0x0022e400000e0000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000212257824ULL, 0x040fe200078e00ffULL, 0x0000000811187812ULL, 0x000fe200078ec0ffULL,
0x0000000412207824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000400121b7824ULL, 0x040fe200078e00ffULL, 0x00000004251e7812ULL, 0x000fe200078ec0ffULL,
0x00001000121c7824ULL, 0x000fe200078e00ffULL, 0x0000000718177812ULL, 0x000fe200078ef811ULL,
0x0000020000007945ULL, 0x000fe20003800000ULL, 0x0000001e111a7211ULL, 0x000fc400078fe0ffULL,
0x0000000420207812ULL, 0x000fe200078ec0ffULL, 0x0000000817197824ULL, 0x000fe200078e00ffULL,
0xfffff0001b1b7812ULL, 0x000fe200078ec0ffULL, 0x0000000117187824ULL, 0x000fe200078e021aULL,
0x0000002011207211ULL, 0x000fe200078fe0ffULL, 0x0000000817277824ULL, 0x002fe200078e00ffULL,
0x000120001b217810ULL, 0x000fe40007ffe0ffULL, 0xfffffff819187812ULL, 0x000fe400078ee218ULL,
0x0000001017197812ULL, 0x000fc400078efcffULL, 0xffffe0001c1d7812ULL, 0x000fe200078ec0ffULL,
0x00000001171c7824ULL, 0x000fe400078e0220ULL, 0x000000011a1a7824ULL, 0x000fe200078e0219ULL,
0x000160001d1d7810ULL, 0x000fe20007ffe0ffULL, 0x00000008191f7824ULL, 0x000fe200078e00ffULL,
0xfffffff8271b7812ULL, 0x000fe200078ee21cULL, 0x0000001018747824ULL, 0x000fc600078e0221ULL,
0xfffffff81f1a7812ULL, 0x000fe200078ee21aULL, 0x000000101b807824ULL, 0x000fe400078e021dULL,
0x000000007474783bULL, 0x000e640000000200ULL, 0x000000101a707824ULL, 0x000fcc00078e0221ULL,
0x000000007070783bULL, 0x000ee20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000001374747232ULL, 0x086fe40000000000ULL, 0x0000001376767232ULL, 0x000fe40000000000ULL,
0x0000001475757232ULL, 0x080fe40000000000ULL, 0x0000001477777232ULL, 0x000fe40000000000ULL,
0x0000001570707232ULL, 0x088fe40000000000ULL, 0x0000001572727232ULL, 0x000fc40000000000ULL,
0x0000001671717232ULL, 0x080fe40000000000ULL, 0x0000001673737232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000008171f7824ULL, 0x000fe200078e00ffULL,
0x000000021c1c7810ULL, 0x000fe20007ffe0ffULL, 0x000000008080783bULL, 0x000ee20000004200ULL,
0x000000021e1e7812ULL, 0x000fe200078efcffULL, 0x000008e000007945ULL, 0x000fe20003800000ULL,
0xfffffff81f1c7812ULL, 0x000fe400078ee21cULL, 0x0000001e111e7211ULL, 0x000fc600078fe0ffULL,
0x000000101c7c7824ULL, 0x000fcc00078e021dULL, 0x000000007c7c783bULL, 0x000ea20000004200ULL,
0x00000018ff1f7819ULL, 0x008fe40000011481ULL, 0x00000018ff1d7819ULL, 0x000fe40000011480ULL,
0x0000001f006d7306ULL, 0x0007e20000200c00ULL, 0x00000018ff277819ULL, 0x000fe40000011483ULL,
0x00000018ff267819ULL, 0x000fca0000011482ULL, 0x0000001d002a7306ULL, 0x0003e20000200c00ULL,
0x00000100801f7824ULL, 0x008fe200078e00ffULL, 0x00000018ff297819ULL, 0x004fe2000001147cULL,
0x000001007d8d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001147dULL,
0x000001007e917824ULL, 0x000fe200078e00ffULL, 0x00000018ff6c7819ULL, 0x000fe2000001147eULL,
0x000001007f937824ULL, 0x000fe200078e00ffULL, 0x00000029008b7306ULL, 0x0005e20000200c00ULL,
0x00008880801d7816ULL, 0x042fe200000000ffULL, 0x0001000080807824ULL, 0x000fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fc4000001147fULL, 0x00000018ff1f7819ULL, 0x000fe4000001141fULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x0000002b008f7306ULL, 0x0003e20000200c00ULL,
0x0000010081297824ULL, 0x004fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fe4000001148dULL,
0x00000018ff917819ULL, 0x000fe40000011491ULL, 0x00000018ff937819ULL, 0x000fe40000011493ULL,
0x0000006c00947306ULL, 0x000fe20000200c00ULL, 0x00000018ff2b7819ULL, 0x002fce0000011429ULL,
0x0000002b006c7306ULL, 0x0003f00000200c00ULL, 0x00000027008a7306ULL, 0x0005e20000200c00ULL,
0x00008880832b7816ULL, 0x002fce00000000ffULL, 0x0000002b00897306ULL, 0x0003e20000200c00ULL,
0x0000888081277816ULL, 0x044fe200000000ffULL, 0x0001000081817824ULL, 0x000fca00078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000002600877306ULL, 0x000fe20000200c00ULL,
0x000001007c2b7824ULL, 0x002fca00078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe4000001142bULL,
0x0000008500967306ULL, 0x0003f00000200c00ULL, 0x0000001d001d7306ULL, 0x000fe20000200c00ULL,
0x0000010082857824ULL, 0x002fca00078e00ffULL, 0x00000018ff857819ULL, 0x000fe40000011485ULL,
0x0000001f00267306ULL, 0x0002b00000200c00ULL, 0x0000002700277306ULL, 0x000ee20000200c00ULL,
0x00008880821f7816ULL, 0x042fe200000000ffULL, 0x0001000082827824ULL, 0x000fca00078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x0000002b008c7306ULL, 0x0003e20000200c00ULL,
0x000054101d267816ULL, 0x004fce0000000026ULL, 0x0000008000297306ULL, 0x0004a20000200c00ULL,
0x000088807e2b7816ULL, 0x042fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fe200078e00ffULL,
0x0000541027277816ULL, 0x008fc8000000006cULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000008100867306ULL, 0x0003e20000200c00ULL, 0x0000010083807824ULL, 0x044fe200078e00ffULL,
0x00000026742c723cULL, 0x000f62000000182cULL, 0x0001000083837824ULL, 0x000fc600078e00ffULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x0000008d008e7306ULL, 0x0005e20000200c00ULL,
0x000088807c817816ULL, 0x042fe200000000ffULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x00000018ff837819ULL, 0x000fe20000011483ULL, 0x00000026704c723cULL, 0x000b62000000184cULL,
0x00005410292a7816ULL, 0x000fe4000000002aULL, 0x00000018ff7c7819ULL, 0x000fe2000001147cULL,
0x0000008500887306ULL, 0x0003e20000200c00ULL, 0x000088807f8d7816ULL, 0x044fe200000000ffULL,
0x000100007f7f7824ULL, 0x000fc400078e00ffULL, 0x0000000119267824ULL, 0x060fe400078e0220ULL,
0x0000000819277824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x0000007e001d7306ULL, 0x000ea20000200c00ULL, 0x000088807d857816ULL, 0x042fe200000000ffULL,
0x000100007d7d7824ULL, 0x000fe200078e00ffULL, 0xfffffff827207812ULL, 0x000fc800078ee226ULL,
0x00000018ff7d7819ULL, 0x000fe2000001147dULL, 0x0000001f001f7306ULL, 0x000e700000200c00ULL,
0x0000008d00957306ULL, 0x000fe20000200c00ULL, 0x000054101d947816ULL, 0x004fe20000000094ULL,
0x00000001171d7824ULL, 0x000fc400078e021eULL, 0x00000001191e7824ULL, 0x000fc800078e021eULL,
0x00000093006c7306ULL, 0x000ea20000200c00ULL, 0x000054101f887816ULL, 0x002fe20000000088ULL,
0x00000008191f7824ULL, 0x000fca00078e00ffULL, 0xfffffff81f1e7812ULL, 0x000fe200078ee21eULL,
0x0000008000807306ULL, 0x000e620000200c00ULL, 0x000160000c1f7811ULL, 0x000fce00078e68ffULL,
0x0000008200827306ULL, 0x000ee20000200c00ULL, 0x0000541095937816ULL, 0x004fce000000006cULL,
0x0000008300837306ULL, 0x000ea20000200c00ULL, 0x0000541089897816ULL, 0x002fe20000000080ULL,
0x0000001020807824ULL, 0x000fcc00078e021fULL, 0x0000008100817306ULL, 0x000e620000200c00ULL,
0x0000541082827816ULL, 0x008fe20000000087ULL, 0x000000887434723cULL, 0x080f6c0000001834ULL,
0x0000008500857306ULL, 0x000ee20000200c00ULL, 0x0000541083837816ULL, 0x004fe2000000008aULL,
0x000000887054723cULL, 0x000f6c0000001854ULL, 0x0000007c007c7306ULL, 0x000ea20000200c00ULL,
0x00005410818c7816ULL, 0x002fe2000000008cULL, 0x000000827438723cULL, 0x080f6c0000001838ULL,
0x0000007d00907306ULL, 0x000e620000200c00ULL, 0x00005410858d7816ULL, 0x008fe2000000008eULL,
0x000000827058723cULL, 0x000f6c0000001858ULL, 0x0000002b00927306ULL, 0x0007e20000200c00ULL,
0x000054107c7c7816ULL, 0x004fe2000000008bULL, 0x0000008c743c723cULL, 0x080f6c000000183cULL,
0x0000009100917306ULL, 0x000ea20000200c00ULL, 0x00005410862b7816ULL, 0x008fe2000000006dULL,
0x0000008c705c723cULL, 0x000f62000000185cULL, 0x00005410907d7816ULL, 0x002fca000000008fULL,
0x0000007f007f7306ULL, 0x000e640000200c00ULL, 0x0000002a7430723cULL, 0x000f620000001830ULL,
0x0000541092927816ULL, 0x004fce0000000091ULL, 0x0000002a7050723cULL, 0x000b620000001850ULL,
0x000054107f957816ULL, 0x002fcc0000000096ULL, 0x00000008172a7824ULL, 0x020fe200078e00ffULL,
0x0000007c7440723cULL, 0x000f680000001840ULL, 0xfffffff82a1d7812ULL, 0x000fc800078ee21dULL,
0x000000927444723cULL, 0x040f700000001844ULL, 0x000000947448723cULL, 0x000b6e0000001848ULL,
0x000000101d747824ULL, 0x120fe200078e0221ULL, 0x0000007c7060723cULL, 0x000f620000001860ULL,
0x000000101e217824ULL, 0x000fc800078e0221ULL, 0x000000007474783bULL, 0x000e660000000200ULL,
0x000000927064723cULL, 0x040f700000001864ULL, 0x000000947068723cULL, 0x000b640000001868ULL,
0x000000002170783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000001374747232ULL, 0x082fe40000000000ULL,
0x0000001376767232ULL, 0x000fc40000000000ULL, 0x0000001475757232ULL, 0x080fe40000000000ULL,
0x0000001477777232ULL, 0x000fe40000000000ULL, 0x0000001570707232ULL, 0x088fe40000000000ULL,
0x0000001572727232ULL, 0x000fe40000000000ULL, 0x0000001671717232ULL, 0x080fe40000000000ULL,
0x0000001673737232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000008192a7824ULL, 0x000fe200078e00ffULL, 0x0000000226217810ULL, 0x004fe20007ffe0ffULL,
0x000000008080783bULL, 0x000ea20000004200ULL, 0xfffffff825257812ULL, 0x000fc400078ec0ffULL,
0xfffffff82a217812ULL, 0x000fca00078ee221ULL, 0x00000010217c7824ULL, 0x000fcc00078e021fULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000018ff267819ULL, 0x004fe40000011480ULL,
0x00000018ff277819ULL, 0x000fe40000011481ULL, 0x00000026002a7306ULL, 0x0005e20000200c00ULL,
0x00000018ff297819ULL, 0x000fe40000011482ULL, 0x00000018ff2b7819ULL, 0x000fe40000011483ULL,
0x00008880838a7816ULL, 0x000fc600000000ffULL, 0x00000027006d7306ULL, 0x0003e20000200c00ULL,
0x0000888080267816ULL, 0x004fe200000000ffULL, 0x000001007c8d7824ULL, 0x008fe200078e00ffULL,
0x00000018ff877819ULL, 0x000fe2000001147fULL, 0x000001007d907824ULL, 0x000fe200078e00ffULL,
0x00000018ff6c7819ULL, 0x000fe2000001147cULL, 0x000001007e937824ULL, 0x000fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe2000001147eULL, 0x0000008700977306ULL, 0x0005e20000200c00ULL,
0x0000010080277824ULL, 0x042fe200078e00ffULL, 0x00000018ff857819ULL, 0x000fe2000001147dULL,
0x0001000080807824ULL, 0x000fe200078e00ffULL, 0x00000018ff8d7819ULL, 0x000fc4000001148dULL,
0x00000018ff277819ULL, 0x000fe40000011427ULL, 0x0000002900897306ULL, 0x0003e20000200c00ULL,
0x0000010082877824ULL, 0x004fe200078e00ffULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x000088807d8f7816ULL, 0x000fe400000000ffULL, 0x00000018ff877819ULL, 0x000fe40000011487ULL,
0x0000002b008b7306ULL, 0x0005e20000200c00ULL, 0x0000010081297824ULL, 0x002fe200078e00ffULL,
0x000088807f957816ULL, 0x000fc400000000ffULL, 0x00000018ff907819ULL, 0x000fe40000011490ULL,
0x00000018ff937819ULL, 0x000fe40000011493ULL, 0x0000006c008e7306ULL, 0x0003e20000200c00ULL,
0x00008880812b7816ULL, 0x044fe200000000ffULL, 0x0001000081817824ULL, 0x000fca00078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000008700887306ULL, 0x0005e20000200c00ULL,
0x00000018ff6c7819ULL, 0x002fce0000011429ULL, 0x0000008000297306ULL, 0x0002e20000200c00ULL,
0x000088807c877816ULL, 0x044fe200000000ffULL, 0x000100007c7c7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000002600267306ULL, 0x000fe20000200c00ULL,
0x0000010083807824ULL, 0x042fe400078e00ffULL, 0x0001000083837824ULL, 0x000fc600078e00ffULL,
0x00000018ff807819ULL, 0x000fe40000011480ULL, 0x0000002700277306ULL, 0x000e620000200c00ULL,
0x00000018ff837819ULL, 0x000fe40000011483ULL, 0x00005410292a7816ULL, 0x008fca000000002aULL,
0x0000008600967306ULL, 0x000ff00000200c00ULL, 0x0000002b002b7306ULL, 0x000fe20000200c00ULL,
0x0000541026267816ULL, 0x002fce0000000027ULL, 0x0000006c006c7306ULL, 0x000e700000200c00ULL,
0x0000008100867306ULL, 0x000eb00000200c00ULL, 0x00000083008c7306ULL, 0x0007e20000200c00ULL,
0x000054102b277816ULL, 0x002fce000000006cULL, 0x0000008500917306ULL, 0x0003e20000200c00ULL,
0x000100007d837824ULL, 0x008fe200078e00ffULL, 0x00005410862b7816ULL, 0x004fe2000000006dULL,
0x00000026742c723cULL, 0x040f66000000182cULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x0000008000817306ULL, 0x000fe20000200c00ULL, 0x0000888082857816ULL, 0x042fe200000000ffULL,
0x0001000082827824ULL, 0x000fe200078e00ffULL, 0x0000002a7430723cULL, 0x000f680000001830ULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x0000007c007d7306ULL, 0x0002a60000200c00ULL,
0x00000026704c723cULL, 0x000f6a000000184cULL, 0x0000008d00807306ULL, 0x0007e20000200c00ULL,
0x000001007f7c7824ULL, 0x002fc400078e00ffULL, 0x000100007f7f7824ULL, 0x000fe200078e00ffULL,
0x0000002a7050723cULL, 0x000f640000001850ULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000008a008a7306ULL, 0x000e620000200c00ULL,
0x000088807e8d7816ULL, 0x048fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fe200078e00ffULL,
0x000054107d8e7816ULL, 0x004fc8000000008eULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000008f008f7306ULL, 0x000ff00000200c00ULL, 0x0000009000907306ULL, 0x000ea20000200c00ULL,
0x000054108a6d7816ULL, 0x002fce0000000081ULL, 0x0000008200827306ULL, 0x000e700000200c00ULL,
0x0000008700877306ULL, 0x000ee20000200c00ULL, 0x000054108f817816ULL, 0x004fce0000000090ULL,
0x0000008300927306ULL, 0x0004e20000200c00ULL, 0x0000541082827816ULL, 0x002fce0000000089ULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x000054108c837816ULL, 0x004fe4000000008bULL,
0x0000541087807816ULL, 0x008fca0000000080ULL, 0x0000009300947306ULL, 0x000e620000200c00ULL,
0x00005410928f7816ULL, 0x000fe20000000091ULL, 0x000000827438723cULL, 0x040f6c0000001838ULL,
0x0000009500957306ULL, 0x000fe40000200c00ULL, 0x00000080743c723cULL, 0x040f6c000000183cULL,
0x0000007c007c7306ULL, 0x000ea20000200c00ULL, 0x000054108d947816ULL, 0x002fe20000000094ULL,
0x0000008e7440723cULL, 0x000f6c0000001840ULL, 0x0000007e00297306ULL, 0x000e640000200c00ULL,
0x000000827058723cULL, 0x040f6c0000001858ULL, 0x0000007f00867306ULL, 0x000ee20000200c00ULL,
0x0000541095957816ULL, 0x004fe2000000007cULL, 0x00000080705c723cULL, 0x000f62000000185cULL,
0x0000541029967816ULL, 0x002fca0000000096ULL, 0x0000008500857306ULL, 0x000e640000200c00ULL,
0x000000947444723cULL, 0x000f620000001844ULL, 0x0000541086977816ULL, 0x008fce0000000097ULL,
0x0000008e7060723cULL, 0x000f620000001860ULL, 0x00005410856c7816ULL, 0x002fce0000000088ULL,
0x000000967448723cULL, 0x000f700000001848ULL, 0x000000947064723cULL, 0x040f700000001864ULL,
0x000000967068723cULL, 0x000f700000001868ULL, 0x0000006c7434723cULL, 0x080f700000001834ULL,
0x0000006c7054723cULL, 0x000b6e0000001854ULL, 0x0001a6c80c6c7811ULL, 0x020fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fd20000008000ULL, 0x000000006c6c7f8cULL, 0x000e62000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6880025ff7f8cULL, 0x0005e2000c80043fULL,
0x000000ffff297224ULL, 0x000fc600078e00ffULL, 0x0000000000267805ULL, 0x000fc80000015200ULL,
0x0000040005257984ULL, 0x004ea40000000800ULL, 0x8000000025ff7812ULL, 0x006fc4000780486dULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102900780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000002a7805ULL, 0x000fcc0000015200ULL,
0x0000002a262a7210ULL, 0x000fca0007f1e1ffULL, 0x000000012b2b7824ULL, 0x000fe200000e0e27ULL,
0x003d09002a00780cULL, 0x000fc80003f06070ULL, 0x000000ff2b00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402a00780cULL, 0x000fc80003f06070ULL,
0x000000ff2b00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001142bULL, 0x0000002a25257211ULL, 0x000fca00078110ffULL,
0x000000ffff2a7224ULL, 0x000fca00000e062bULL, 0x0000000225257819ULL, 0x000fc8000000122aULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000129297810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040005257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001012267824ULL, 0x000fca00078e00ffULL,
0xffffffe026257812ULL, 0x000fca00078ec0ffULL, 0x0000010008257824ULL, 0x000fca00078e0225ULL,
0x0000008025277810ULL, 0x000fe20007ffe0ffULL, 0x0000590022257a24ULL, 0x010fc600078e02ffULL,
0x0000002027227812ULL, 0x000fe200078ec0ffULL, 0x0000004025297824ULL, 0x000fc800078e00ffULL,
0x000000010b707824ULL, 0x000fe200078e0222ULL, 0x000003f000009947ULL, 0x000fea0003800000ULL,
0x0000002710227217ULL, 0x000fe40007800000ULL, 0x0000001026257812ULL, 0x000fe400078ec0ffULL,
0x00000003ff267819ULL, 0x000fe20000011611ULL, 0x0000000122227824ULL, 0x000fc600078e0a27ULL,
0x00000004262b7810ULL, 0x040fe20007ffe0ffULL, 0x0000000126277824ULL, 0x040fe200078e0225ULL,
0x0000002225227217ULL, 0x000fe40007800000ULL, 0x00000008266c7810ULL, 0x000fe20007ffe0ffULL,
0x00000001272a7824ULL, 0x040fe400078e0211ULL, 0x00000008276d7824ULL, 0x000fe400078e00ffULL,
0x0000000122227824ULL, 0x000fc600078e0a25ULL, 0xfffffff86d727812ULL, 0x000fe200078ee22aULL,
0x000000012b2a7824ULL, 0x100fe200078e0225ULL, 0x0000000c266d7810ULL, 0x040fe40007ffe0ffULL,
0x000000222600720cULL, 0x080fe20003f86070ULL, 0x0000000127267824ULL, 0x000fe200078e0270ULL,
0x000000226c00720cULL, 0x0c0fe20003f46070ULL, 0x000000016c6c7824ULL, 0x100fe200078e0225ULL,
0x000000222b00720cULL, 0x080fe20003f66070ULL, 0x000000016d737824ULL, 0x040fe200078e0225ULL,
0x000000226d00720cULL, 0x000fe20003f06070ULL, 0x000000012a257824ULL, 0x000fc400078e0211ULL,
0x000000082a747824ULL, 0x000fe400078e00ffULL, 0x000000016c2b7824ULL, 0x040fe400078e0211ULL,
0x000000086c767824ULL, 0x000fe200078e00ffULL, 0xfffffff874227812ULL, 0x000fe200078ee225ULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000620029257a11ULL, 0x040fe400078a38ffULL,
0xfffffff876747812ULL, 0x000fe200078ee22bULL, 0x000000012a2a7824ULL, 0x100fe200078e0270ULL,
0x0000000326267212ULL, 0x000fe200078efcffULL, 0x000000016c6c7824ULL, 0x000fe200078e0270ULL,
0x0000630029297a11ULL, 0x000fe200028f3cffULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000002625267210ULL, 0x000fc60007fbe0ffULL, 0x0000000173707824ULL, 0x000fe200078e0270ULL,
0x000000032a2a7212ULL, 0x000fe200078efcffULL, 0x000000806c6c7825ULL, 0x000fc800078e00ffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000036c6c7212ULL, 0x000fc600078efcffULL,
0x0000000127277824ULL, 0x000fe200028e0629ULL, 0x000000252a2a7210ULL, 0x000fe20007fbe0ffULL,
0x0000000173757824ULL, 0x040fe200078e0211ULL, 0x0000000370707212ULL, 0x000fe200078efcffULL,
0x0000000873767824ULL, 0x000fe400078e00ffULL, 0x000000012b2b7824ULL, 0x000fe200028e0629ULL,
0x000000256c6c7210ULL, 0x080fe20007fbe0ffULL, 0x0000001074737824ULL, 0x100fe200078e021fULL,
0x0000002570707210ULL, 0x000fe20007fde0ffULL, 0x0000001072257824ULL, 0x000fe200078e021fULL,
0xfffffff876767812ULL, 0x000fe200078ee275ULL, 0x000000016d6d7824ULL, 0x000fc400028e0629ULL,
0x0000000171717824ULL, 0x000fe200030e0629ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e2000e101c48ULL, 0x0000001022297824ULL, 0x100fe400078e021fULL,
0x0000001076757824ULL, 0x000fc600078e021fULL, 0x000000002a297faeULL, 0x0003e8000d901c48ULL,
0x000000006c737faeULL, 0x0003e8000d101c48ULL, 0x0000000070757faeULL, 0x0003e2000c101c48ULL,
0x0000032000007947ULL, 0x000fea0003800000ULL, 0x0000001026267812ULL, 0x000fc800078ec0ffULL,
0x0000002611227211ULL, 0x000fc800078fe8ffULL, 0x0000000422277810ULL, 0x040fe20007ffe0ffULL,
0x0000000122257824ULL, 0x040fe200078e0211ULL, 0x0000000c226d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000822727824ULL, 0x040fe400078e00ffULL, 0x0000000122267824ULL, 0x100fe400078e0270ULL,
0x00000001272a7824ULL, 0x000fe200078e0270ULL, 0xfffffff872727812ULL, 0x000fe200078ee225ULL,
0x000000086d767824ULL, 0x000fe200078e00ffULL, 0x0000000822257810ULL, 0x000fe20007ffe0ffULL,
0x0000000127227824ULL, 0x000fc400078e0211ULL, 0x0000000827277824ULL, 0x000fe400078e00ffULL,
0x00000001256c7824ULL, 0x040fe400078e0270ULL, 0x00000001252b7824ULL, 0x100fe200078e0211ULL,
0xfffffff827227812ULL, 0x000fe200078ee222ULL, 0x0000000825747824ULL, 0x000fe400078e00ffULL,
0x000000016d257824ULL, 0x000fe400078e0211ULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0xfffffff874747812ULL, 0x000fc400078ee22bULL, 0xfffffff876767812ULL, 0x000fe200078ee225ULL,
0x000000016d707824ULL, 0x000fe200078e0270ULL, 0x0000620029257a11ULL, 0x040fe200078038ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000000326267212ULL, 0x080fe400078efcffULL,
0x0000630029297a11ULL, 0x000fe200000f3cffULL, 0x000000806c6c7825ULL, 0x000fe200078e00ffULL,
0x0000002625267210ULL, 0x000fe40007f1e0ffULL, 0x000000032a2a7212ULL, 0x080fe200078efcffULL,
0x0000008070707825ULL, 0x000fe200078e00ffULL, 0x000000036c6c7212ULL, 0x000fc400078efcffULL,
0x0000002a252a7210ULL, 0x000fe20007f5e0ffULL, 0x0000000127277824ULL, 0x000fe200000e0629ULL,
0x0000000370707212ULL, 0x000fe200078efcffULL, 0x0000001074737824ULL, 0x000fe200078e021fULL,
0x0000006c256c7210ULL, 0x000fe20007f1e0ffULL, 0x000000012b2b7824ULL, 0x000fe200010e0629ULL,
0x0000007025707210ULL, 0x000fe20007f7e0ffULL, 0x0000001072257824ULL, 0x000fe400078e021fULL,
0x000000016d6d7824ULL, 0x100fe400000e0629ULL, 0x0000000171717824ULL, 0x000fe200018e0629ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000026257faeULL, 0x0003e2000b901c48ULL,
0x0000001022297824ULL, 0x000fc400078e021fULL, 0x0000001076757824ULL, 0x000fc600078e021fULL,
0x000000002a297faeULL, 0x0003e8000b901c48ULL, 0x000000006c737faeULL, 0x0003e8000b901c48ULL,
0x0000000070757faeULL, 0x0003e4000b901c48ULL, 0x00000000280473c2ULL, 0x000ea200000e0000ULL,
0x000000020a267810ULL, 0x002fe20007ffe0ffULL, 0xffffffffff227424ULL, 0x000fc600078e00ffULL,
0x0000000f2600720cULL, 0x000fda0003f06070ULL, 0x0000000109268824ULL, 0x000fe400078e0226ULL,
0x00000004ff278424ULL, 0x000fe200078e00ffULL, 0xfffffff004047892ULL, 0x004fc6000f8ec03fULL,
0x0000640026268625ULL, 0x000fe200078e0027ULL, 0x0001a6a804057890ULL, 0x000fc8000fffe03fULL,
0x0000000826228981ULL, 0x000328000c1e1900ULL, 0x0000000000007918ULL, 0x000fe80000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a05ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6a800ff2a7f8cULL, 0x000ea2000c800404ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a62800046c7f8cULL, 0x000664000c80043fULL,
0x0000000000267805ULL, 0x002fc40000015200ULL, 0x01a62c0004257984ULL, 0x000e640000000800ULL,
0x8000000025ff7812ULL, 0x002fc4000780486dULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x0000002826287210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09002800780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402800780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc80000011429ULL, 0x0000002825257211ULL, 0x000fca00078110ffULL,
0x000000ffff287224ULL, 0x000fca00000e0629ULL, 0x0000000225257819ULL, 0x000fc80000001228ULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a62c0004257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe4000780486dULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002012257824ULL, 0x000fca00078e00ffULL,
0xffffff8025267812ULL, 0x000fc800078ec0ffULL, 0x0000008003257810ULL, 0x000fca0007ffe026ULL,
0x0000000102257824ULL, 0x000fca00078e0225ULL, 0x01a0000025287984ULL, 0x000e680000000800ULL,
0x01a2000025297984ULL, 0x0006a20000000800ULL, 0x000000232800720bULL, 0x002fe20003f1d000ULL,
0x000129e27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000707806ULL, 0x008fc800000e0100ULL,
0x000000ff7000720cULL, 0x000fe20003f05270ULL, 0x0000077000007945ULL, 0x000fe20003800000ULL,
0x00000001ff257424ULL, 0x000fd600078e00ffULL, 0x0000074000008947ULL, 0x000fea0003800000ULL,
0x000000010d257810ULL, 0x000fe40007ffe0ffULL, 0x000000232800720bULL, 0x000fe40003f54000ULL,
0x000000122500720cULL, 0x000fe20003f05270ULL, 0x000129b27f007947ULL, 0x000fd4000b800000ULL,
0x0000000000717806ULL, 0x000fc400010e0100ULL, 0x0000008012278824ULL, 0x000fe200078e0203ULL,
0x0000002328258209ULL, 0x000fe20007810000ULL, 0x0000064000017945ULL, 0x000fe40003800000ULL,
0x0000000102268824ULL, 0x000fca00078e0227ULL, 0x01a4002526008388ULL, 0x0003e20000000800ULL,
0x000000ff7100720cULL, 0x000fda0003f05270ULL, 0x000005f000008947ULL, 0x000fea0003800000ULL,
0x0000002328267209ULL, 0x002fe20007810000ULL, 0x000001a000027945ULL, 0x000fe20003800000ULL,
0x000000ff71ff7812ULL, 0x000fc6000780c0ffULL, 0x0000002326257221ULL, 0x000fc80000010100ULL,
0x3fb8aa3b25257820ULL, 0x000fc80000410000ULL, 0x0000002500737308ULL, 0x000e640000000800ULL,
0x0000007324247220ULL, 0x002fe20000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff277819ULL, 0x000fe20000011611ULL, 0x000128f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2773267589ULL, 0x0002e400000e0000ULL, 0x000000262c2c7220ULL, 0x08cfe40000410000ULL,
0x000000262d2d7220ULL, 0x080fe40000410000ULL, 0x0000002630307220ULL, 0x080fe40000410000ULL,
0x0000002631317220ULL, 0x000fc40000410000ULL, 0x0000002634347220ULL, 0x080fe40000410000ULL,
0x0000002635357220ULL, 0x080fe40000410000ULL, 0x0000002638387220ULL, 0x080fe40000410000ULL,
0x0000002639397220ULL, 0x080fe40000410000ULL, 0x000000263c3c7220ULL, 0x080fe40000410000ULL,
0x000000263d3d7220ULL, 0x000fc40000410000ULL, 0x0000002640407220ULL, 0x080fe40000410000ULL,
0x0000002641417220ULL, 0x080fe40000410000ULL, 0x0000002644447220ULL, 0x080fe40000410000ULL,
0x0000002645457220ULL, 0x080fe40000410000ULL, 0x0000002648487220ULL, 0x080fe40000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff0071ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000811277811ULL, 0x002fe200078ff0ffULL,
0x000127e27f007947ULL, 0x000fea000b800000ULL, 0x00001f2773267589ULL, 0x0002e400000e0000ULL,
0x000000262e2e7220ULL, 0x08cfe40000410000ULL, 0x000000262f2f7220ULL, 0x080fe40000410000ULL,
0x0000002632327220ULL, 0x080fe40000410000ULL, 0x0000002633337220ULL, 0x080fe40000410000ULL,
0x0000002636367220ULL, 0x080fe40000410000ULL, 0x0000002637377220ULL, 0x000fc40000410000ULL,
0x000000263a3a7220ULL, 0x080fe40000410000ULL, 0x000000263b3b7220ULL, 0x080fe40000410000ULL,
0x000000263e3e7220ULL, 0x080fe40000410000ULL, 0x000000263f3f7220ULL, 0x080fe40000410000ULL,
0x0000002642427220ULL, 0x080fe40000410000ULL, 0x0000002643437220ULL, 0x000fc40000410000ULL,
0x0000002646467220ULL, 0x080fe40000410000ULL, 0x0000002647477220ULL, 0x080fe40000410000ULL,
0x000000264a4a7220ULL, 0x080fe40000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff000071ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001011277811ULL, 0x002fe200078ff0ffULL, 0x000126d27f007947ULL, 0x000fea000b800000ULL,
0x00001f2773267589ULL, 0x0002e400000e0000ULL, 0x000000264c4c7220ULL, 0x08cfe40000410000ULL,
0x000000264d4d7220ULL, 0x080fe40000410000ULL, 0x0000002650507220ULL, 0x080fe40000410000ULL,
0x0000002651517220ULL, 0x080fe40000410000ULL, 0x0000002654547220ULL, 0x080fe40000410000ULL,
0x0000002655557220ULL, 0x000fc40000410000ULL, 0x0000002658587220ULL, 0x080fe40000410000ULL,
0x0000002659597220ULL, 0x080fe40000410000ULL, 0x000000265c5c7220ULL, 0x080fe40000410000ULL,
0x000000265d5d7220ULL, 0x080fe40000410000ULL, 0x0000002660607220ULL, 0x080fe40000410000ULL,
0x0000002661617220ULL, 0x000fc40000410000ULL, 0x0000002664647220ULL, 0x080fe40000410000ULL,
0x0000002665657220ULL, 0x080fe40000410000ULL, 0x0000002668687220ULL, 0x080fe40000410000ULL,
0x0000002669697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff00000071ff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001811277811ULL, 0x002fe200078ff0ffULL, 0x000125d27f007947ULL, 0x000fea000b800000ULL,
0x00001f2773267589ULL, 0x0002e400000e0000ULL, 0x000000264e4e7220ULL, 0x08cfe40000410000ULL,
0x000000264f4f7220ULL, 0x080fe40000410000ULL, 0x0000002652527220ULL, 0x080fe40000410000ULL,
0x0000002653537220ULL, 0x080fe40000410000ULL, 0x0000002656567220ULL, 0x080fe40000410000ULL,
0x0000002657577220ULL, 0x000fc40000410000ULL, 0x000000265a5a7220ULL, 0x080fe40000410000ULL,
0x000000265b5b7220ULL, 0x080fe40000410000ULL, 0x000000265e5e7220ULL, 0x080fe40000410000ULL,
0x000000265f5f7220ULL, 0x080fe40000410000ULL, 0x0000002662627220ULL, 0x080fe40000410000ULL,
0x0000002663637220ULL, 0x000fc40000410000ULL, 0x0000002666667220ULL, 0x080fe40000410000ULL,
0x0000002667677220ULL, 0x080fe40000410000ULL, 0x000000266a6a7220ULL, 0x080fe40000410000ULL,
0x000000266b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000007170ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff257424ULL, 0x000fe200078e00ffULL,
0x0000002328237209ULL, 0x000fd60007810000ULL, 0x8000002328280221ULL, 0x000fe20000010000ULL,
0x00007610ff250816ULL, 0x000fc60000000025ULL, 0x3fb8aa3b28280820ULL, 0x000fc80000410000ULL,
0x0000002800000308ULL, 0x000e640000000800ULL, 0x0000000029290220ULL, 0x006fcc0000410000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002429247221ULL, 0x004fc40000010000ULL,
0x0000000000267805ULL, 0x000fca0000015200ULL, 0x0000000812287824ULL, 0x000fca00078e00ffULL,
0xfffffff0286c7812ULL, 0x000fca00078ec0ffULL, 0x01a6b4006c297984ULL, 0x000e640000000800ULL,
0x8000000029ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff707224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107000780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000287805ULL, 0x000fcc0000015200ULL,
0x00000028266d7210ULL, 0x000fca0007f1e1ffULL, 0x0000000129297824ULL, 0x000fe200000e0e27ULL,
0x003d09006d00780cULL, 0x000fc80003f06070ULL, 0x000000ff2900720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406d00780cULL, 0x000fc80003f06070ULL,
0x000000ff2900720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff287819ULL, 0x000fc80000011429ULL, 0x0000006d28287211ULL, 0x000fca00078110ffULL,
0x000000ffff297224ULL, 0x000fca00000e0629ULL, 0x0000000228287819ULL, 0x000fc80000001229ULL,
0x000000280000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000170707810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a6b4006c297984ULL, 0x000e640000000800ULL, 0x8000000029ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000991025257816ULL, 0x000fc800000000ffULL,
0x000000ff2500720cULL, 0x000fda0003f05270ULL, 0x000000d000000947ULL, 0x000fea0003800000ULL,
0x00000000ff13723eULL, 0x000fe400000000ffULL, 0x00000002ff297819ULL, 0x000fe40000011611ULL,
0x0000541013167816ULL, 0x000fe20000000013ULL, 0x000121b27f007947ULL, 0x000fea000b800000ULL,
0x00001f2916137589ULL, 0x0002a400000e0000ULL, 0x0000000829277810ULL, 0x000fe20007ffe0ffULL,
0x000122027f007947ULL, 0x000fea000b800000ULL, 0x0000001029157810ULL, 0x000fe20007ffe0ffULL,
0x00001f2716147589ULL, 0x00066a00000e0000ULL, 0x00001f1516157589ULL, 0x0006a400000e0000ULL,
0x0000001829277810ULL, 0x008fe20007ffe0ffULL, 0x000122927f007947ULL, 0x000fea000b800000ULL,
0x00001f2716167589ULL, 0x0022e400000e0000ULL, 0x0000040012257824ULL, 0x040fe200078e00ffULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000100012267824ULL, 0x000fe200078e00ffULL,
0x0000013000007945ULL, 0x000fe40003800000ULL, 0xfffff00025257812ULL, 0x000fc400078ec0ffULL,
0xffffe00026267812ULL, 0x000fe400078ec0ffULL, 0x0001300025257810ULL, 0x000fe40007ffe0ffULL,
0x0001700026267810ULL, 0x000fc60007ffe0ffULL, 0x0000001018707824ULL, 0x100fe400078e0225ULL,
0x000000101a6c7824ULL, 0x000fe400078e0225ULL, 0x000000101b7c7824ULL, 0x000fe400078e0226ULL,
0x000000007070783bULL, 0x000e680000000200ULL, 0x000000006c6c783bULL, 0x000ee20000000200ULL,
0x0000008000000947ULL, 0x000fea0003800000ULL, 0x0000001370707232ULL, 0x086fe40000000000ULL,
0x0000001372727232ULL, 0x000fc40000000000ULL, 0x0000001471717232ULL, 0x080fe40000000000ULL,
0x0000001473737232ULL, 0x000fe40000000000ULL, 0x000000156c6c7232ULL, 0x088fe40000000000ULL,
0x000000156e6e7232ULL, 0x000fe40000000000ULL, 0x000000166d6d7232ULL, 0x080fe40000000000ULL,
0x000000166f6f7232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000101c747824ULL, 0x000fe200078e0226ULL, 0x000000007c7c783bULL, 0x000ee20000004200ULL,
0x0000082000007945ULL, 0x000fe80003800000ULL, 0x000000007474783bULL, 0x000ea20000004200ULL,
0x00000018ff267819ULL, 0x008fc4000001147cULL, 0x00000018ff277819ULL, 0x002fe4000001147dULL,
0x00000018ff297819ULL, 0x000fe2000001147eULL, 0x0000002600287306ULL, 0x0003e20000200c00ULL,
0x00000018ff807819ULL, 0x000fe2000001147fULL, 0x00000100748b7824ULL, 0x004fe200078e00ffULL,
0x00000018ff857819ULL, 0x000fe20000011476ULL, 0x00000100758d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011474ULL, 0x0000010076927824ULL, 0x000fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe20000011477ULL, 0x0000002700827306ULL, 0x0005e20000200c00ULL,
0x000088807c267816ULL, 0x002fc400000000ffULL, 0x00000018ff837819ULL, 0x000fe40000011475ULL,
0x00008880758e7816ULL, 0x040fe200000000ffULL, 0x0001000075757824ULL, 0x000fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe2000001148bULL, 0x0000002900877306ULL, 0x0003e20000200c00ULL,
0x000001007c277824ULL, 0x044fe200078e00ffULL, 0x000088807f887816ULL, 0x000fe200000000ffULL,
0x000100007c7c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00000018ff277819ULL, 0x000fc40000011427ULL, 0x00000080008a7306ULL, 0x0005e20000200c00ULL,
0x000001007d297824ULL, 0x042fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x00000018ff8f7819ULL, 0x000fe4000001148dULL, 0x0000888076917816ULL, 0x040fe200000000ffULL,
0x0001000076767824ULL, 0x000fe200078e00ffULL, 0x0000008500947306ULL, 0x0003e20000200c00ULL,
0x000088807d807816ULL, 0x044fe200000000ffULL, 0x000100007d7d7824ULL, 0x000fe200078e00ffULL,
0x00000018ff927819ULL, 0x000fc40000011492ULL, 0x0000888077937816ULL, 0x000fe400000000ffULL,
0x00000018ff7d7819ULL, 0x000fe2000001147dULL, 0x00000081008c7306ULL, 0x0005e20000200c00ULL,
0x000001007e857824ULL, 0x002fe200078e00ffULL, 0x00000018ff767819ULL, 0x000fc80000011476ULL,
0x00000018ff857819ULL, 0x000fe40000011485ULL, 0x0000008600957306ULL, 0x000fe20000200c00ULL,
0x00000018ff817819ULL, 0x004fce0000011429ULL, 0x0000007c00297306ULL, 0x0002b00000200c00ULL,
0x0000007d007d7306ULL, 0x000ee20000200c00ULL, 0x000001007f7c7824ULL, 0x042fe400078e00ffULL,
0x000100007f7f7824ULL, 0x000fc600078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x0000008500867306ULL, 0x0003e20000200c00ULL, 0x00000018ff7f7819ULL, 0x000fe4000001147fULL,
0x0000541029287816ULL, 0x004fca0000000028ULL, 0x0000002600267306ULL, 0x000fe20000200c00ULL,
0x0000888074857816ULL, 0x042fe200000000ffULL, 0x0001000074747824ULL, 0x000fe200078e00ffULL,
0x000054107d297816ULL, 0x008fc80000000082ULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000002700277306ULL, 0x000e640000200c00ULL, 0x000000287030723cULL, 0x080f6c0000001830ULL,
0x0000008000807306ULL, 0x000fe40000200c00ULL, 0x000000286c50723cULL, 0x000b6c0000001850ULL,
0x0000008100817306ULL, 0x000ea20000200c00ULL, 0x0000541026267816ULL, 0x002fc40000000027ULL,
0x000010001f287810ULL, 0x020fca0007ffe0ffULL, 0x0000008300907306ULL, 0x0003e20000200c00ULL,
0x0000001020297824ULL, 0x000fce00078e0228ULL, 0x0000007c00897306ULL, 0x000fe20000200c00ULL,
0x000088807e837816ULL, 0x042fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fe200078e00ffULL,
0x0000541080277816ULL, 0x004fc80000000081ULL, 0x00000018ff7e7819ULL, 0x000fe2000001147eULL,
0x0000008b007c7306ULL, 0x000fe40000200c00ULL, 0x00000026702c723cULL, 0x080f6c000000182cULL,
0x00000074008d7306ULL, 0x0002a40000200c00ULL, 0x000000266c4c723cULL, 0x000f6c000000184cULL,
0x00000075008b7306ULL, 0x0006a20000200c00ULL, 0x0000010077747824ULL, 0x002fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe40000011474ULL, 0x0000008300837306ULL, 0x000fe20000200c00ULL,
0x0001000077757824ULL, 0x008fe200078e00ffULL, 0x000054108d8c7816ULL, 0x004fc8000000008cULL,
0x00000018ff7d7819ULL, 0x000fe40000011475ULL, 0x0000008800887306ULL, 0x000e620000200c00ULL,
0x000054108b8d7816ULL, 0x000fce0000000090ULL, 0x0000007e007e7306ULL, 0x000ea20000200c00ULL,
0x0000008c7040723cULL, 0x080f6e0000001840ULL, 0x0000007f007f7306ULL, 0x000ee20000200c00ULL,
0x0000541088757816ULL, 0x002fe20000000089ULL, 0x0000008c6c60723cULL, 0x000f6c0000001860ULL,
0x0000008500857306ULL, 0x000e620000200c00ULL, 0x000054107e7e7816ULL, 0x004fce0000000087ULL,
0x0000008e008e7306ULL, 0x000fe20000200c00ULL, 0x000054107f7f7816ULL, 0x008fce000000008aULL,
0x0000008f008f7306ULL, 0x000fe20000200c00ULL, 0x00005410857c7816ULL, 0x002fe2000000007cULL,
0x0000007e7038723cULL, 0x080f6c0000001838ULL, 0x0000009100917306ULL, 0x000fe40000200c00ULL,
0x0000007e6c58723cULL, 0x000f6c0000001858ULL, 0x0000009200927306ULL, 0x000e700000200c00ULL,
0x0000009300937306ULL, 0x000ff00000200c00ULL, 0x0000007400807306ULL, 0x0004e20000200c00ULL,
0x0000541091927816ULL, 0x002fce0000000092ULL, 0x0000007600777306ULL, 0x000e620000200c00ULL,
0x0000541083747816ULL, 0x004fce0000000086ULL, 0x0000007d00827306ULL, 0x0004a20000200c00ULL,
0x0000541093937816ULL, 0x008fe20000000080ULL, 0x000000747034723cULL, 0x000f620000001834ULL,
0x0000541077947816ULL, 0x002fe40000000094ULL, 0x000054108e7d7816ULL, 0x004fca000000008fULL,
0x000000927044723cULL, 0x000f620000001844ULL, 0x0000541082957816ULL, 0x000fce0000000095ULL,
0x0000007c703c723cULL, 0x040f70000000183cULL, 0x000000947048723cULL, 0x000b6e0000001848ULL,
0x000000101d707824ULL, 0x120fe200078e0225ULL, 0x000000746c54723cULL, 0x000f620000001854ULL,
0x000000101e257824ULL, 0x000fc800078e0225ULL, 0x000000007070783bULL, 0x000e660000000200ULL,
0x0000007c6c5c723cULL, 0x040f70000000185cULL, 0x000000926c64723cULL, 0x040f700000001864ULL,
0x000000946c68723cULL, 0x000b640000001868ULL, 0x00000000256c783bULL, 0x0204e20000000200ULL,
0x0000000000007918ULL, 0x000fc20000000000ULL, 0x0000008000000947ULL, 0x000fde0003800000ULL,
0x0000001370707232ULL, 0x082fe40000000000ULL, 0x0000001372727232ULL, 0x000fc40000000000ULL,
0x0000001471717232ULL, 0x080fe40000000000ULL, 0x0000001473737232ULL, 0x000fe40000000000ULL,
0x000000156c6c7232ULL, 0x088fe40000000000ULL, 0x000000156e6e7232ULL, 0x000fe40000000000ULL,
0x000000166d6d7232ULL, 0x080fe40000000000ULL, 0x000000166f6f7232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000001021747824ULL, 0x000fe200078e0228ULL,
0x00000000297c783bULL, 0x000eaa0000004200ULL, 0x000000007474783bULL, 0x000ee20000004200ULL,
0x00000018ff257819ULL, 0x004fe2000001147cULL, 0x000001007e887824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fc4000001147dULL, 0x0000002500807306ULL, 0x0005e20000200c00ULL,
0x00000018ff837819ULL, 0x008fe20000011475ULL, 0x00000100748b7824ULL, 0x000fe200078e00ffULL,
0x00000018ff817819ULL, 0x000fe2000001147fULL, 0x00000100758f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff277819ULL, 0x000fe2000001147eULL, 0x0000010076937824ULL, 0x000fe200078e00ffULL,
0x00000018ff867819ULL, 0x000fe20000011476ULL, 0x0000002600857306ULL, 0x0007e20000200c00ULL,
0x000088807c257816ULL, 0x004fe400000000ffULL, 0x00000018ff827819ULL, 0x000fc40000011474ULL,
0x00000018ff877819ULL, 0x000fe40000011477ULL, 0x00000018ff907819ULL, 0x000fe2000001148fULL,
0x0000008300917306ULL, 0x0005e20000200c00ULL, 0x000001007c267824ULL, 0x048fe200078e00ffULL,
0x00000018ff8b7819ULL, 0x000fe2000001148bULL, 0x000100007c7c7824ULL, 0x000fe200078e00ffULL,
0x00008880758d7816ULL, 0x040fe200000000ffULL, 0x0001000075757824ULL, 0x000fe200078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x00000081008a7306ULL, 0x0007e20000200c00ULL,
0x000100007d837824ULL, 0x004fe200078e00ffULL, 0x00000018ff7c7819ULL, 0x000fc4000001147cULL,
0x0000888077957816ULL, 0x000fe400000000ffULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x0000002700897306ULL, 0x0005e20000200c00ULL, 0x000001007d817824ULL, 0x008fe200078e00ffULL,
0x00000018ff887819ULL, 0x000fe40000011488ULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00000018ff817819ULL, 0x000fc40000011481ULL, 0x0000008600967306ULL, 0x000fe20000200c00ULL,
0x000088807d277816ULL, 0x004fe400000000ffULL, 0x00000018ff937819ULL, 0x000fca0000011493ULL,
0x0000007c007d7306ULL, 0x0005f00000200c00ULL, 0x0000008300867306ULL, 0x0007e20000200c00ULL,
0x000001007f7c7824ULL, 0x004fca00078e00ffULL, 0x00000018ff7c7819ULL, 0x000fe4000001147cULL,
0x00000082008e7306ULL, 0x000fe20000200c00ULL, 0x0000888074837816ULL, 0x048fe200000000ffULL,
0x0001000074747824ULL, 0x000fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000008100827306ULL, 0x0005f00000200c00ULL, 0x0000002700277306ULL, 0x000ee20000200c00ULL,
0x000088807f817816ULL, 0x044fe200000000ffULL, 0x000100007f7f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000002500257306ULL, 0x000ff00000200c00ULL,
0x0000002600267306ULL, 0x000ea20000200c00ULL, 0x0000541027277816ULL, 0x008fce0000000082ULL,
0x0000008100817306ULL, 0x000ff00000200c00ULL, 0x0000007c007c7306ULL, 0x000fe20000200c00ULL,
0x0000541025267816ULL, 0x004fce0000000026ULL, 0x00000074008f7306ULL, 0x0004e20000200c00ULL,
0x00000026702c723cULL, 0x082f6e000000182cULL, 0x0000008700977306ULL, 0x0003e20000200c00ULL,
0x0000010077747824ULL, 0x044fe200078e00ffULL, 0x000000266c4c723cULL, 0x000b62000000184cULL,
0x0001000077777824ULL, 0x000fc600078e00ffULL, 0x00000018ff747819ULL, 0x000fe40000011474ULL,
0x0000008b008c7306ULL, 0x0005e20000200c00ULL, 0x000088807e877816ULL, 0x042fe200000000ffULL,
0x000100007e7e7824ULL, 0x000fe200078e00ffULL, 0x000054108f8e7816ULL, 0x008fc8000000008eULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000007400827306ULL, 0x0003e20000200c00ULL,
0x00008880768b7816ULL, 0x044fe200000000ffULL, 0x0001000076767824ULL, 0x000fca00078e00ffULL,
0x00000018ff767819ULL, 0x000fe20000011476ULL, 0x0000008700877306ULL, 0x000fe20000200c00ULL,
0x000054107d747816ULL, 0x002fe40000000080ULL, 0x00000018ff7d7819ULL, 0x000fe40000011477ULL,
0x0000541081777816ULL, 0x000fc6000000007cULL, 0x0000008800887306ULL, 0x000ff00000200c00ULL,
0x0000007e007e7306ULL, 0x000e700000200c00ULL, 0x0000007f007f7306ULL, 0x000eb00000200c00ULL,
0x0000008300837306ULL, 0x000ee20000200c00ULL, 0x000054107e7e7816ULL, 0x002fce0000000089ULL,
0x0000008d008d7306ULL, 0x000fe20000200c00ULL, 0x000054107f7f7816ULL, 0x004fce000000008aULL,
0x0000009000907306ULL, 0x000e620000200c00ULL, 0x00005410838c7816ULL, 0x008fe2000000008cULL,
0x0000007e7038723cULL, 0x080f6c0000001838ULL, 0x0000007500927306ULL, 0x0004e40000200c00ULL,
0x0000007e6c58723cULL, 0x000f6c0000001858ULL, 0x0000008b008b7306ULL, 0x000fe20000200c00ULL,
0x0000541086757816ULL, 0x004fc40000000085ULL, 0x000054108d8d7816ULL, 0x002fca0000000090ULL,
0x0000009300947306ULL, 0x000e620000200c00ULL, 0x00005410928f7816ULL, 0x008fe20000000091ULL,
0x000000747030723cULL, 0x040f6c0000001830ULL, 0x0000009500957306ULL, 0x000ea40000200c00ULL,
0x0000008c703c723cULL, 0x040f6c000000183cULL, 0x0000007600257306ULL, 0x0006a20000200c00ULL,
0x000054108b947816ULL, 0x002fe20000000094ULL, 0x0000008e7040723cULL, 0x000f6c0000001840ULL,
0x0000007d007c7306ULL, 0x000e620000200c00ULL, 0x0000541087767816ULL, 0x008fe20000000088ULL,
0x000000746c50723cULL, 0x000f620000001850ULL, 0x0000541095957816ULL, 0x004fc40000000082ULL,
0x0000541025967816ULL, 0x000fe20000000096ULL, 0x0000000212257824ULL, 0x000fc800078e00ffULL,
0x000000767034723cULL, 0x000f640000001834ULL, 0xfffffff825267812ULL, 0x020fe400078ec0ffULL,
0x000054107c977816ULL, 0x002fc80000000097ULL, 0x000000947044723cULL, 0x040f700000001844ULL,
0x000000967048723cULL, 0x000f700000001848ULL, 0x000000766c54723cULL, 0x040f700000001854ULL,
0x0000008c6c5c723cULL, 0x040f70000000185cULL, 0x0000008e6c60723cULL, 0x040f700000001860ULL,
0x000000946c64723cULL, 0x040f700000001864ULL, 0x000000966c68723cULL, 0x000b6e0000001868ULL,
0x0001a6c80c6e7811ULL, 0x020fe200078e18ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fd20000008000ULL,
0x000000006e6e7f8cULL, 0x000e62000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6900026ff7f8cULL, 0x0005e2000c80043fULL, 0x000000ffff257224ULL, 0x000fc600078e00ffULL,
0x0000000000267805ULL, 0x004fc80000015200ULL, 0x00000400056d7984ULL, 0x000ea40000000800ULL,
0x800000006dff7812ULL, 0x006fc4000780486fULL, 0x0000000000007918ULL, 0x000ff40000000000ULL,
0x000001d000007945ULL, 0x000fe20003800000ULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000102500780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006c7805ULL, 0x000fcc0000015200ULL, 0x0000006c26717210ULL, 0x000fca0007f1e1ffULL,
0x000000016d6d7824ULL, 0x000fe200000e0e27ULL, 0x003d09007100780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c407100780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff6c7819ULL, 0x000fc8000001146dULL,
0x000000716c6c7211ULL, 0x000fca00078110ffULL, 0x000000ffff6d7224ULL, 0x000fca00000e066dULL,
0x000000026c6c7819ULL, 0x000fc8000000126dULL, 0x0000006c0000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000125257810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x00000400056d7984ULL, 0x000e640000000800ULL,
0x800000006dff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000001012267824ULL, 0x000fca00078e00ffULL, 0xffffffe026257812ULL, 0x000fca00078ec0ffULL,
0x0000010008257824ULL, 0x000fca00078e0225ULL, 0x000000c025277810ULL, 0x000fe20007ffe0ffULL,
0x0000590022257a24ULL, 0x010fc600078e02ffULL, 0x0000002027227812ULL, 0x000fe200078ec0ffULL,
0x0000004025737824ULL, 0x000fc800078e00ffULL, 0x000000010b707824ULL, 0x000fe200078e0222ULL,
0x000003f000009947ULL, 0x000fea0003800000ULL, 0x0000002710227217ULL, 0x000fe40007800000ULL,
0x0000001026257812ULL, 0x000fe400078ec0ffULL, 0x00000003ff267819ULL, 0x000fe20000011611ULL,
0x0000000122227824ULL, 0x000fc600078e0a27ULL, 0x00000004266d7810ULL, 0x040fe20007ffe0ffULL,
0x0000000126277824ULL, 0x040fe200078e0225ULL, 0x0000002225227217ULL, 0x000fe40007800000ULL,
0x00000008266e7810ULL, 0x040fe20007ffe0ffULL, 0x00000001276c7824ULL, 0x040fe200078e0211ULL,
0x0000000c266f7810ULL, 0x000fe20007ffe0ffULL, 0x0000000827757824ULL, 0x000fe400078e00ffULL,
0x0000000122227824ULL, 0x100fe400078e0a25ULL, 0x000000016f727824ULL, 0x100fe200078e0225ULL,
0xfffffff875757812ULL, 0x000fe200078ee26cULL, 0x000000016d6c7824ULL, 0x100fe200078e0225ULL,
0x000000222600720cULL, 0x080fe20003f86070ULL, 0x0000000127267824ULL, 0x000fe200078e0270ULL,
0x000000226e00720cULL, 0x0c0fe20003f46070ULL, 0x000000016e6e7824ULL, 0x000fe200078e0225ULL,
0x000000226d00720cULL, 0x080fe20003f66070ULL, 0x000000016c257824ULL, 0x040fe200078e0211ULL,
0x000000226f00720cULL, 0x000fe20003f06070ULL, 0x000000086c747824ULL, 0x000fc400078e00ffULL,
0x0000008026267825ULL, 0x000fc600078e00ffULL, 0xfffffff874777812ULL, 0x000fe200078ee225ULL,
0x000000016c6c7824ULL, 0x000fe200078e0270ULL, 0x0000620073257a11ULL, 0x040fe200078a38ffULL,
0x000000016e227824ULL, 0x000fe200078e0211ULL, 0x0000000326267212ULL, 0x080fe200078efcffULL,
0x000000086e7d7824ULL, 0x000fe200078e00ffULL, 0x0000630073737a11ULL, 0x000fe200028f3cffULL,
0x000000806c6c7825ULL, 0x000fe200078e00ffULL, 0x0000002625267210ULL, 0x000fe40007fbe0ffULL,
0xfffffff87d7d7812ULL, 0x000fe200078ee222ULL, 0x000000016e6e7824ULL, 0x100fe200078e0270ULL,
0x000000036c6c7212ULL, 0x000fe200078efcffULL, 0x0000000172707824ULL, 0x000fc400078e0270ULL,
0x000000806e6e7825ULL, 0x000fc800078e00ffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000036e6e7212ULL, 0x000fc600078efcffULL, 0x0000000127277824ULL, 0x000fe200028e0673ULL,
0x000000256c6c7210ULL, 0x000fe20007fbe0ffULL, 0x0000000172227824ULL, 0x000fe200078e0211ULL,
0x0000000370707212ULL, 0x000fe200078efcffULL, 0x00000008727f7824ULL, 0x000fe400078e00ffULL,
0x000000016d6d7824ULL, 0x100fe200028e0673ULL, 0x000000256e6e7210ULL, 0x080fe40007fbe0ffULL,
0x0000002570707210ULL, 0x000fe20007fde0ffULL, 0x0000001075257824ULL, 0x000fe200078e0228ULL,
0xfffffff87f7f7812ULL, 0x000fe200078ee222ULL, 0x000000016f6f7824ULL, 0x000fc400028e0673ULL,
0x0000000171717824ULL, 0x000fe200030e0673ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e2000e101c48ULL, 0x0000001077737824ULL, 0x100fe400078e0228ULL,
0x000000107d757824ULL, 0x100fe400078e0228ULL, 0x000000107f777824ULL, 0x000fe200078e0228ULL,
0x000000006c737faeULL, 0x0003e8000d901c48ULL, 0x000000006e757faeULL, 0x0003e8000d101c48ULL,
0x0000000070777faeULL, 0x0003e2000c101c48ULL, 0x0000032000007947ULL, 0x000fea0003800000ULL,
0x0000001026267812ULL, 0x000fe400078ec0ffULL, 0x0000620073757a11ULL, 0x000fc400078038ffULL,
0x0000002611227211ULL, 0x000fe400078fe8ffULL, 0x0000630073737a11ULL, 0x000fe400000f3cffULL,
0x0000000422277810ULL, 0x040fe20007ffe0ffULL, 0x0000000122257824ULL, 0x140fe200078e0211ULL,
0x00000008226d7810ULL, 0x040fe20007ffe0ffULL, 0x00000008226c7824ULL, 0x040fe200078e00ffULL,
0x0000000c22717810ULL, 0x040fe20007ffe0ffULL, 0x0000000122267824ULL, 0x100fe400078e0270ULL,
0x0000000127227824ULL, 0x040fe200078e0211ULL, 0xfffffff86c257812ULL, 0x000fe200078ee225ULL,
0x00000001276c7824ULL, 0x000fc400078e0270ULL, 0x0000000827777824ULL, 0x000fe400078e00ffULL,
0x000000016d6e7824ULL, 0x040fe400078e0270ULL, 0x000000016d6f7824ULL, 0x100fe200078e0211ULL,
0xfffffff877777812ULL, 0x000fe200078ee222ULL, 0x000000086d727824ULL, 0x000fe400078e00ffULL,
0x00000001716d7824ULL, 0x040fe400078e0211ULL, 0x0000000871747824ULL, 0x000fe200078e00ffULL,
0xfffffff8727d7812ULL, 0x000fe200078ee26fULL, 0x0000008026267825ULL, 0x000fc600078e00ffULL,
0xfffffff8747f7812ULL, 0x000fe200078ee26dULL, 0x0000000171707824ULL, 0x000fe200078e0270ULL,
0x0000000326267212ULL, 0x000fe200078efcffULL, 0x000000806c6c7825ULL, 0x000fc600078e00ffULL,
0x0000002675267210ULL, 0x000fe20007f1e0ffULL, 0x000000806e6e7825ULL, 0x000fe200078e00ffULL,
0x000000036c6c7212ULL, 0x000fc600078efcffULL, 0x0000008070707825ULL, 0x000fe200078e00ffULL,
0x000000036e6e7212ULL, 0x080fe400078efcffULL, 0x0000006c756c7210ULL, 0x000fe20007f5e0ffULL,
0x0000000127277824ULL, 0x100fe200000e0673ULL, 0x0000000370707212ULL, 0x000fe200078efcffULL,
0x0000001025257824ULL, 0x100fe200078e0228ULL, 0x0000006e756e7210ULL, 0x000fe20007f1e0ffULL,
0x000000016d6d7824ULL, 0x100fe200010e0673ULL, 0x0000007075707210ULL, 0x000fe20007f7e0ffULL,
0x000000107d757824ULL, 0x000fe200078e0228ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000026257faeULL, 0x0003e2000b901c48ULL, 0x000000016f6f7824ULL, 0x000fc400000e0673ULL,
0x0000000171717824ULL, 0x000fe400018e0673ULL, 0x0000001077737824ULL, 0x100fe400078e0228ULL,
0x000000107f777824ULL, 0x000fc600078e0228ULL, 0x000000006c737faeULL, 0x0003e8000b901c48ULL,
0x000000006e757faeULL, 0x0003e8000b901c48ULL, 0x0000000070777faeULL, 0x0003e4000b901c48ULL,
0x0000000812257824ULL, 0x002fe200078e00ffULL, 0x000000030a267810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff227424ULL, 0x000fc600078e00ffULL, 0xfffffff025257812ULL, 0x000fe400078ec0ffULL,
0x0000000f2600720cULL, 0x000fe40003f06070ULL, 0x00000000250473c2ULL, 0x000e6200000e0000ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x0000000109268824ULL, 0x000fc400078e0226ULL,
0x00000004ff278424ULL, 0x000fc800078e00ffULL, 0x0000640026268625ULL, 0x000fca00078e0027ULL,
0x0000000826228981ULL, 0x000522000c1e1900ULL, 0x0001a6b004047890ULL, 0x002fd2000fffe03fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000ff0079b0ULL, 0x000fe20008000a04ULL, 0x0000000000007918ULL, 0x000fe40000000000ULL,
0x0000000000007992ULL, 0x004fec0000008000ULL, 0x01a6b000256e7f8cULL, 0x0002a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a6480004707f8cULL, 0x000664000c80043fULL,
0x0000000000267805ULL, 0x000fc40000015200ULL, 0x01a64c0004257984ULL, 0x002e640000000800ULL,
0x8000000025ff7812ULL, 0x002fe40007804871ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff727224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000107200780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x00000000006c7805ULL, 0x000fcc0000015200ULL,
0x0000006c266c7210ULL, 0x000fca0007f1e1ffULL, 0x000000016d6d7824ULL, 0x000fe200000e0e27ULL,
0x003d09006c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c406c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff257819ULL, 0x000fc8000001146dULL, 0x0000006c25257211ULL, 0x000fca00078110ffULL,
0x000000ffff6c7224ULL, 0x000fca00000e066dULL, 0x0000000225257819ULL, 0x000fc8000000126cULL,
0x000000250000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000172727810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a64c0004257984ULL, 0x000e640000000800ULL, 0x8000000025ff7812ULL, 0x002fe40007804871ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000002012047824ULL, 0x008fca00078e00ffULL,
0xffffff8004047812ULL, 0x000fc800078ec0ffULL, 0x0000010003257810ULL, 0x000fca0007ffe004ULL,
0x0000000102257824ULL, 0x000fca00078e0225ULL, 0x01a0000025707984ULL, 0x000e680000000800ULL,
0x01a2000025717984ULL, 0x0006a20000000800ULL, 0x000000237000720bULL, 0x002fe20003f1d000ULL,
0x000102f27f007947ULL, 0x000fd8000b800000ULL, 0x0000000000727806ULL, 0x008fc800000e0100ULL,
0x000000ff7200720cULL, 0x000fe20003f05270ULL, 0x0000078000007945ULL, 0x000fe20003800000ULL,
0x00000001ff257424ULL, 0x000fe400078e00ffULL, 0x000000ffff047224ULL, 0x000fd200078e0023ULL,
0x0000074000008947ULL, 0x000fea0003800000ULL, 0x000000020d257810ULL, 0x000fe40007ffe0ffULL,
0x000000237000720bULL, 0x000fe40003f54000ULL, 0x000000122500720cULL, 0x000fe20003f05270ULL,
0x000102b27f007947ULL, 0x000fd4000b800000ULL, 0x0000000000737806ULL, 0x000fc400010e0100ULL,
0x0000008012258824ULL, 0x000fe200078e0203ULL, 0x0000002370048209ULL, 0x000fe20007810000ULL,
0x0000064000017945ULL, 0x000fe40003800000ULL, 0x0000000102258824ULL, 0x000fca00078e0225ULL,
0x01a4000425008388ULL, 0x0003e20000000800ULL, 0x000000ff7300720cULL, 0x000fda0003f05270ULL,
0x000005f000008947ULL, 0x000fea0003800000ULL, 0x0000002370047209ULL, 0x002fe20007810000ULL,
0x000001a000027945ULL, 0x000fe20003800000ULL, 0x000000ff73ff7812ULL, 0x000fc6000780c0ffULL,
0x0000002304047221ULL, 0x000fc80000010100ULL, 0x3fb8aa3b04047820ULL, 0x000fc80000410000ULL,
0x0000000400757308ULL, 0x000e640000000800ULL, 0x0000007524247220ULL, 0x002fe20000410000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x00000002ff277819ULL, 0x000fe20000011611ULL,
0x000101f27f007947ULL, 0x000fea000b800000ULL, 0x00001f2775267589ULL, 0x0002e400000e0000ULL,
0x000000262c2c7220ULL, 0x08cfe40000410000ULL, 0x000000262d2d7220ULL, 0x080fe40000410000ULL,
0x0000002630307220ULL, 0x080fe40000410000ULL, 0x0000002631317220ULL, 0x000fc40000410000ULL,
0x0000002634347220ULL, 0x080fe40000410000ULL, 0x0000002635357220ULL, 0x080fe40000410000ULL,
0x0000002638387220ULL, 0x080fe40000410000ULL, 0x0000002639397220ULL, 0x080fe40000410000ULL,
0x000000263c3c7220ULL, 0x080fe40000410000ULL, 0x000000263d3d7220ULL, 0x000fc40000410000ULL,
0x0000002640407220ULL, 0x080fe40000410000ULL, 0x0000002641417220ULL, 0x080fe40000410000ULL,
0x0000002644447220ULL, 0x080fe40000410000ULL, 0x0000002645457220ULL, 0x080fe40000410000ULL,
0x0000002648487220ULL, 0x080fe40000410000ULL, 0x0000002649497220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x0000ff0073ff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000000811277811ULL, 0x002fe200078ff0ffULL, 0x000100e27f007947ULL, 0x000fea000b800000ULL,
0x00001f2775267589ULL, 0x0002e400000e0000ULL, 0x000000262e2e7220ULL, 0x08cfe40000410000ULL,
0x000000262f2f7220ULL, 0x080fe40000410000ULL, 0x0000002632327220ULL, 0x080fe40000410000ULL,
0x0000002633337220ULL, 0x080fe40000410000ULL, 0x0000002636367220ULL, 0x080fe40000410000ULL,
0x0000002637377220ULL, 0x000fc40000410000ULL, 0x000000263a3a7220ULL, 0x080fe40000410000ULL,
0x000000263b3b7220ULL, 0x080fe40000410000ULL, 0x000000263e3e7220ULL, 0x080fe40000410000ULL,
0x000000263f3f7220ULL, 0x080fe40000410000ULL, 0x0000002642427220ULL, 0x080fe40000410000ULL,
0x0000002643437220ULL, 0x000fc40000410000ULL, 0x0000002646467220ULL, 0x080fe40000410000ULL,
0x0000002647477220ULL, 0x080fe40000410000ULL, 0x000000264a4a7220ULL, 0x080fe40000410000ULL,
0x000000264b4b7220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x00ff000073ff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001011277811ULL, 0x002fe200078ff0ffULL,
0x0000ffd27f007947ULL, 0x000fea000b800000ULL, 0x00001f2775267589ULL, 0x0002e400000e0000ULL,
0x000000264c4c7220ULL, 0x08cfe40000410000ULL, 0x000000264d4d7220ULL, 0x080fe40000410000ULL,
0x0000002650507220ULL, 0x080fe40000410000ULL, 0x0000002651517220ULL, 0x080fe40000410000ULL,
0x0000002654547220ULL, 0x080fe40000410000ULL, 0x0000002655557220ULL, 0x000fc40000410000ULL,
0x0000002658587220ULL, 0x080fe40000410000ULL, 0x0000002659597220ULL, 0x080fe40000410000ULL,
0x000000265c5c7220ULL, 0x080fe40000410000ULL, 0x000000265d5d7220ULL, 0x080fe40000410000ULL,
0x0000002660607220ULL, 0x080fe40000410000ULL, 0x0000002661617220ULL, 0x000fc40000410000ULL,
0x0000002664647220ULL, 0x080fe40000410000ULL, 0x0000002665657220ULL, 0x080fe40000410000ULL,
0x0000002668687220ULL, 0x080fe40000410000ULL, 0x0000002669697220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0xff00000073ff7812ULL, 0x000fda000780c0ffULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000001811277811ULL, 0x002fe200078ff0ffULL,
0x0000fed27f007947ULL, 0x000fea000b800000ULL, 0x00001f2775267589ULL, 0x0002e400000e0000ULL,
0x000000264e4e7220ULL, 0x08cfe40000410000ULL, 0x000000264f4f7220ULL, 0x080fe40000410000ULL,
0x0000002652527220ULL, 0x080fe40000410000ULL, 0x0000002653537220ULL, 0x080fe40000410000ULL,
0x0000002656567220ULL, 0x080fe40000410000ULL, 0x0000002657577220ULL, 0x000fc40000410000ULL,
0x000000265a5a7220ULL, 0x080fe40000410000ULL, 0x000000265b5b7220ULL, 0x080fe40000410000ULL,
0x000000265e5e7220ULL, 0x080fe40000410000ULL, 0x000000265f5f7220ULL, 0x080fe40000410000ULL,
0x0000002662627220ULL, 0x080fe40000410000ULL, 0x0000002663637220ULL, 0x000fc40000410000ULL,
0x0000002666667220ULL, 0x080fe40000410000ULL, 0x0000002667677220ULL, 0x080fe40000410000ULL,
0x000000266a6a7220ULL, 0x080fe40000410000ULL, 0x000000266b6b7220ULL, 0x000fc40000410000ULL,
0x0000000000017941ULL, 0x002fea0003800000ULL, 0x0000007372ff7212ULL, 0x000fe200078030ffULL,
0x00000001ff257424ULL, 0x000fe200078e00ffULL, 0x0000002370047209ULL, 0x000fd60007810000ULL,
0x8000000470700221ULL, 0x000fe20000010000ULL, 0x00007610ff250816ULL, 0x000fc60000000025ULL,
0x3fb8aa3b70700820ULL, 0x000fc80000410000ULL, 0x0000007000000308ULL, 0x000e640000000800ULL,
0x0000000071710220ULL, 0x006fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000002471247221ULL, 0x004fc40000010000ULL, 0x0000000000267805ULL, 0x000fca0000015200ULL,
0x0000000812237824ULL, 0x000fca00078e00ffULL, 0xfffffff023707812ULL, 0x000fca00078ec0ffULL,
0x01a6ac0070237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff717224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000107100780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x00000000006c7805ULL, 0x000fcc0000015200ULL, 0x0000006c266c7210ULL, 0x000fca0007f1e1ffULL,
0x000000016d6d7824ULL, 0x000fe200000e0e27ULL, 0x003d09006c00780cULL, 0x000fc80003f06070ULL,
0x000000ff6d00720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c406c00780cULL, 0x000fc80003f06070ULL, 0x000000ff6d00720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff237819ULL, 0x000fc8000001146dULL,
0x0000006c23237211ULL, 0x000fca00078110ffULL, 0x000000ffff6c7224ULL, 0x000fca00000e066dULL,
0x0000000223237819ULL, 0x000fc8000000126cULL, 0x000000230000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x0000000171717810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a6ac0070237984ULL, 0x000e640000000800ULL,
0x8000000023ff7812ULL, 0x002fe4000780482bULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000991025237816ULL, 0x000fc800000000ffULL, 0x000000ff2300720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000ff13723eULL, 0x000fe400000000ffULL,
0x00000002ff237819ULL, 0x000fe40000011611ULL, 0x0000541013167816ULL, 0x000fe20000000013ULL,
0x0000fab27f007947ULL, 0x000fea000b800000ULL, 0x00001f2316137589ULL, 0x0002a400000e0000ULL,
0x0000000823277810ULL, 0x000fe20007ffe0ffULL, 0x0000fb027f007947ULL, 0x000fea000b800000ULL,
0x0000001023157810ULL, 0x000fe20007ffe0ffULL, 0x00001f2716147589ULL, 0x00066a00000e0000ULL,
0x00001f1516157589ULL, 0x0006a400000e0000ULL, 0x0000001823277810ULL, 0x008fe20007ffe0ffULL,
0x0000fb927f007947ULL, 0x000fea000b800000ULL, 0x00001f2716167589ULL, 0x0022e400000e0000ULL,
0x0000040012237824ULL, 0x040fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000100012257824ULL, 0x000fe200078e00ffULL, 0x0000013000007945ULL, 0x000fe40003800000ULL,
0xfffff00023237812ULL, 0x000fc400078ec0ffULL, 0xffffe00025257812ULL, 0x000fe400078ec0ffULL,
0x0001400023237810ULL, 0x000fe40007ffe0ffULL, 0x0001600025257810ULL, 0x000fc60007ffe0ffULL,
0x0000001018187824ULL, 0x100fe400078e0223ULL, 0x000000101a1a7824ULL, 0x000fe400078e0223ULL,
0x000000101b807824ULL, 0x000fe200078e0225ULL, 0x000000001874783bULL, 0x0002e80000000200ULL,
0x000000001a70783bULL, 0x0002a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x0000001374747232ULL, 0x08cfe40000000000ULL, 0x0000001376767232ULL, 0x000fc40000000000ULL,
0x0000001475757232ULL, 0x080fe40000000000ULL, 0x0000001477777232ULL, 0x000fe40000000000ULL,
0x0000001570707232ULL, 0x080fe40000000000ULL, 0x0000001572727232ULL, 0x000fe40000000000ULL,
0x0000001671717232ULL, 0x080fe40000000000ULL, 0x0000001673737232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000101c7c7824ULL, 0x000fe200078e0225ULL,
0x000000008080783bULL, 0x000e620000004200ULL, 0x0000082000007945ULL, 0x000fe80003800000ULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000018ff187819ULL, 0x002fc40000011480ULL,
0x00000018ff1a7819ULL, 0x000fe40000011481ULL, 0x00000018ff1c7819ULL, 0x000fe20000011482ULL,
0x00000018002a7306ULL, 0x0003e20000200c00ULL, 0x00000018ff267819ULL, 0x008fe2000001147cULL,
0x000001007d8c7824ULL, 0x040fe200078e00ffULL, 0x00000018ff277819ULL, 0x000fe2000001147dULL,
0x000100007d8d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe2000001147eULL,
0x000001007e8f7824ULL, 0x000fe200078e00ffULL, 0x00000018ff257819ULL, 0x000fe20000011483ULL,
0x00000026008a7306ULL, 0x0007e20000200c00ULL, 0x0000888080187816ULL, 0x002fc400000000ffULL,
0x000088807c897816ULL, 0x000fe400000000ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001147fULL,
0x000088807d8b7816ULL, 0x000fe200000000ffULL, 0x0000001a006c7306ULL, 0x0003e20000200c00ULL,
0x0000010081267824ULL, 0x008fe200078e00ffULL, 0x00000018ff8c7819ULL, 0x000fe4000001148cULL,
0x00000018ff8d7819ULL, 0x000fe4000001148dULL, 0x00000018ff267819ULL, 0x000fc40000011426ULL,
0x0000001c00857306ULL, 0x0007e20000200c00ULL, 0x00000100801a7824ULL, 0x042fe200078e00ffULL,
0x00000018ff8f7819ULL, 0x000fe2000001148fULL, 0x0001000080807824ULL, 0x000fc600078e00ffULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x00000027008e7306ULL, 0x000fe20000200c00ULL,
0x00008880811c7816ULL, 0x048fe200000000ffULL, 0x0001000081817824ULL, 0x000fe200078e00ffULL,
0x00000018ff807819ULL, 0x000fc80000011480ULL, 0x00000018ff817819ULL, 0x000fe20000011481ULL,
0x0000001c001c7306ULL, 0x000ff00000200c00ULL, 0x0000002600277306ULL, 0x0002f00000200c00ULL,
0x0000002b00927306ULL, 0x000fe20000200c00ULL, 0x0000888083267816ULL, 0x002fce00000000ffULL,
0x00000080002b7306ULL, 0x0002a20000200c00ULL, 0x000054101c277816ULL, 0x008fe20000000027ULL,
0x000001007f1c7824ULL, 0x000fca00078e00ffULL, 0x00000018ff1c7819ULL, 0x000fe2000001141cULL,
0x0000002500887306ULL, 0x000fe20000200c00ULL, 0x0000010083807824ULL, 0x042fe400078e00ffULL,
0x0001000083837824ULL, 0x000fc600078e00ffULL, 0x00000018ff807819ULL, 0x000fe40000011480ULL,
0x0000002600867306ULL, 0x0003e20000200c00ULL, 0x00000018ff837819ULL, 0x000fe40000011483ULL,
0x000054102b2a7816ULL, 0x004fca000000002aULL, 0x0000001800187306ULL, 0x000fe20000200c00ULL,
0x000001007c267824ULL, 0x042fe400078e00ffULL, 0x000100007c7c7824ULL, 0x000fc600078e00ffULL,
0x00000018ff267819ULL, 0x000fe40000011426ULL, 0x0000001a00257306ULL, 0x0002a20000200c00ULL,
0x00000018ff7c7819ULL, 0x000fce000001147cULL, 0x0000008000877306ULL, 0x000fe20000200c00ULL,
0x00008880821a7816ULL, 0x002fce00000000ffULL, 0x0000006d00947306ULL, 0x0003f00000200c00ULL,
0x0000002600807306ULL, 0x0007e20000200c00ULL, 0x00000100826d7824ULL, 0x042fe400078e00ffULL,
0x0001000082827824ULL, 0x000fc600078e00ffULL, 0x00000018ff6d7819ULL, 0x000fe4000001146dULL,
0x0000007c007d7306ULL, 0x0002a20000200c00ULL, 0x000088807e267816ULL, 0x048fe200000000ffULL,
0x000100007e7e7824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fc80000011482ULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000002600907306ULL, 0x0005e20000200c00ULL,
0x000088807f7c7816ULL, 0x042fe200000000ffULL, 0x000100007f7f7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000008100817306ULL, 0x000e620000200c00ULL,
0x0000541018267816ULL, 0x004fe20000000025ULL, 0x000000ffff187224ULL, 0x000fe200078e007cULL,
0x000054107d8a7816ULL, 0x000fca000000008aULL, 0x0000001a001a7306ULL, 0x000fe20000200c00ULL,
0x00000026742c723cULL, 0x080f6e000000182cULL, 0x0000006d006d7306ULL, 0x000ea20000200c00ULL,
0x00005410812b7816ULL, 0x002fe2000000006cULL, 0x00000026704c723cULL, 0x000f6c000000184cULL,
0x0000008b008b7306ULL, 0x000fe40000200c00ULL, 0x0000002a7430723cULL, 0x080f6c0000001830ULL,
0x0000008c008c7306ULL, 0x000e620000200c00ULL, 0x000054101a6c7816ULL, 0x004fe2000000006dULL,
0x0000002a7050723cULL, 0x000f620000001850ULL, 0x00005410866d7816ULL, 0x000fca0000000087ULL,
0x0000007e00937306ULL, 0x000ea40000200c00ULL, 0x0000006c7434723cULL, 0x080f6c0000001834ULL,
0x0000008200827306ULL, 0x000ee20000200c00ULL, 0x000054108b817816ULL, 0x002fe2000000008cULL,
0x0000006c7054723cULL, 0x000f6c0000001854ULL, 0x0000008300837306ULL, 0x000e620000200c00ULL,
0x0000541093927816ULL, 0x004fce0000000092ULL, 0x0000008900897306ULL, 0x000ea20000200c00ULL,
0x0000541082827816ULL, 0x008fce0000000085ULL, 0x0000008d008d7306ULL, 0x000ee20000200c00ULL,
0x0000541083837816ULL, 0x002fce0000000088ULL, 0x0000008f008f7306ULL, 0x000e620000200c00ULL,
0x0000541089807816ULL, 0x004fe20000000080ULL, 0x000000827438723cULL, 0x040f6c0000001838ULL,
0x0000001800187306ULL, 0x000fe20000200c00ULL, 0x000054108d8b7816ULL, 0x008fe2000000008eULL,
0x00000080743c723cULL, 0x040f6c000000183cULL, 0x0000001c00917306ULL, 0x000ea20000200c00ULL,
0x0000541090907816ULL, 0x002fe2000000008fULL, 0x0000008a7440723cULL, 0x000f6c0000001840ULL,
0x0000007f007f7306ULL, 0x000e640000200c00ULL, 0x000000827058723cULL, 0x000f620000001858ULL,
0x0000541018917816ULL, 0x004fce0000000091ULL, 0x00000080705c723cULL, 0x000b62000000185cULL,
0x000054107f937816ULL, 0x002fcc0000000094ULL, 0x0000001020807824ULL, 0x020fe200078e021fULL,
0x000000907444723cULL, 0x040f700000001844ULL, 0x000000927448723cULL, 0x000b6e0000001848ULL,
0x000000101d747824ULL, 0x120fe200078e0223ULL, 0x0000008a7060723cULL, 0x000f620000001860ULL,
0x000000101e237824ULL, 0x000fc800078e0223ULL, 0x000000007474783bULL, 0x000e660000000200ULL,
0x000000907064723cULL, 0x040f700000001864ULL, 0x000000927068723cULL, 0x000b640000001868ULL,
0x000000002370783bULL, 0x0204e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x0000001374747232ULL, 0x082fe40000000000ULL,
0x0000001376767232ULL, 0x000fc40000000000ULL, 0x0000001475757232ULL, 0x080fe40000000000ULL,
0x0000001477777232ULL, 0x000fe40000000000ULL, 0x0000001570707232ULL, 0x088fe40000000000ULL,
0x0000001572727232ULL, 0x000fe40000000000ULL, 0x0000001671717232ULL, 0x080fe40000000000ULL,
0x0000001673737232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x000000008080783bULL, 0x000ea20000004200ULL, 0x00000010217c7824ULL, 0x000fcc00078e021fULL,
0x000000007c7c783bULL, 0x000ee20000004200ULL, 0x00000018ff207819ULL, 0x004fe20000011483ULL,
0x00000100822b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1a7819ULL, 0x000fe20000011481ULL,
0x00000100836d7824ULL, 0x000fe200078e00ffULL, 0x0000002000867306ULL, 0x0005e20000200c00ULL,
0x00000018ff187819ULL, 0x000fe40000011480ULL, 0x00000018ff257819ULL, 0x008fe2000001147eULL,
0x000001007e8b7824ULL, 0x000fe200078e00ffULL, 0x00000018ff1c7819ULL, 0x000fc40000011482ULL,
0x00000018ff217819ULL, 0x000fe2000001147cULL, 0x0000001a00277306ULL, 0x0007e20000200c00ULL,
0x0000010081207824ULL, 0x004fe200078e00ffULL, 0x00000018ff2a7819ULL, 0x000fe4000001147fULL,
0x00000018ff237819ULL, 0x000fe4000001147dULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000001800267306ULL, 0x0005e20000200c00ULL, 0x00000100801a7824ULL, 0x008fe200078e00ffULL,
0x000088807d897816ULL, 0x000fc400000000ffULL, 0x000088807f8d7816ULL, 0x000fe400000000ffULL,
0x00000018ff1a7819ULL, 0x000fe4000001141aULL, 0x0000001c006c7306ULL, 0x0007e20000200c00ULL,
0x0000888080187816ULL, 0x044fe200000000ffULL, 0x0001000080807824ULL, 0x000fe200078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x00000018ff8b7819ULL, 0x000fe4000001148bULL,
0x00000018ff807819ULL, 0x000fe20000011480ULL, 0x00000025008e7306ULL, 0x000fe20000200c00ULL,
0x00008880811c7816ULL, 0x048fe200000000ffULL, 0x0001000081817824ULL, 0x000fca00078e00ffULL,
0x00000018ff817819ULL, 0x000fe20000011481ULL, 0x0000002000257306ULL, 0x0005f00000200c00ULL,
0x0000002100877306ULL, 0x000fe20000200c00ULL, 0x0000888083207816ULL, 0x044fe200000000ffULL,
0x0001000083837824ULL, 0x000fca00078e00ffULL, 0x00000018ff837819ULL, 0x000fe20000011483ULL,
0x0000001800187306ULL, 0x000ff00000200c00ULL, 0x0000001a00217306ULL, 0x000eb00000200c00ULL,
0x0000002000857306ULL, 0x0007f00000200c00ULL, 0x0000001c001c7306ULL, 0x000e620000200c00ULL,
0x000001007c207824ULL, 0x008fca00078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000002a00907306ULL, 0x0007f00000200c00ULL, 0x0000002000887306ULL, 0x0003e20000200c00ULL,
0x00008880822a7816ULL, 0x048fe200000000ffULL, 0x0001000082827824ULL, 0x000fca00078e00ffULL,
0x00000018ff827819ULL, 0x000fe20000011482ULL, 0x00000023008a7306ULL, 0x000fe20000200c00ULL,
0x000088807e207816ULL, 0x042fe200000000ffULL, 0x000100007e7e7824ULL, 0x000fca00078e00ffULL,
0x00000018ff7e7819ULL, 0x000fe2000001147eULL, 0x0000008000237306ULL, 0x0002f00000200c00ULL,
0x00000020008c7306ULL, 0x0005e20000200c00ULL, 0x00000018ff807819ULL, 0x002fce000001146dULL,
0x00000081001a7306ULL, 0x0002620000200c00ULL, 0x0000541018207816ULL, 0x004fe20000000021ULL,
0x000000ffff187224ULL, 0x000fe200078e008dULL, 0x000054101c217816ULL, 0x000fe20000000025ULL,
0x000001007f1c7824ULL, 0x000fe200078e00ffULL, 0x0000541023267816ULL, 0x008fe20000000026ULL,
0x000100007f7f7824ULL, 0x000fe200078e00ffULL, 0x0001a6c80c257811ULL, 0x000fe200078e18ffULL,
0x00000082006d7306ULL, 0x0004e20000200c00ULL, 0x000088807c817816ULL, 0x042fe200000000ffULL,
0x000100007c7c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff7f7819ULL, 0x000fe2000001147fULL,
0x00000020742c723cULL, 0x000b62000000182cULL, 0x00000018ff1c7819ULL, 0x000fc4000001141cULL,
0x00000018ff7c7819ULL, 0x000fe2000001147cULL, 0x0000002a002a7306ULL, 0x000fe20000200c00ULL,
0x000001007d827824ULL, 0x044fe200078e00ffULL, 0x000054101a277816ULL, 0x000fe20000000027ULL,
0x000100007d7d7824ULL, 0x000fe200078e00ffULL, 0x00000020704c723cULL, 0x000b64000000184cULL,
0x00000018ff827819ULL, 0x000fe40000011482ULL, 0x00000018ff7d7819ULL, 0x000fe2000001147dULL,
0x0000002b002b7306ULL, 0x000e620000200c00ULL, 0x000054106d6c7816ULL, 0x008fc4000000006cULL,
0x000000267430723cULL, 0x080b6a0000001830ULL, 0x0000007e008f7306ULL, 0x000ea60000200c00ULL,
0x000000267050723cULL, 0x000b6a0000001850ULL, 0x0000008000807306ULL, 0x000ee20000200c00ULL,
0x000054102a2a7816ULL, 0x002fce000000002bULL, 0x0000008300837306ULL, 0x000e620000200c00ULL,
0x000054108f8e7816ULL, 0x004fce000000008eULL, 0x0000008100817306ULL, 0x000ea20000200c00ULL,
0x00005410852b7816ULL, 0x008fce0000000080ULL, 0x0000008900897306ULL, 0x000fe20000200c00ULL,
0x00005410836d7816ULL, 0x002fe20000000086ULL, 0x0000002a7434723cULL, 0x040b6c0000001834ULL,
0x0000008200827306ULL, 0x000e620000200c00ULL, 0x0000541081887816ULL, 0x004fe20000000088ULL,
0x0000006c7438723cULL, 0x000b6c0000001838ULL, 0x0000007c007c7306ULL, 0x000ea40000200c00ULL,
0x0000002a7054723cULL, 0x040b6c0000001854ULL, 0x0000007d007d7306ULL, 0x000ee20000200c00ULL,
0x0000541089897816ULL, 0x002fe20000000082ULL, 0x0000006c7058723cULL, 0x000b6c0000001858ULL,
0x0000008b008b7306ULL, 0x000e620000200c00ULL, 0x000054107c7c7816ULL, 0x004fe20000000087ULL,
0x00000088743c723cULL, 0x080b6c000000183cULL, 0x0000001800187306ULL, 0x000fe20000200c00ULL,
0x000054107d7d7816ULL, 0x008fe2000000008aULL, 0x00000088705c723cULL, 0x000b6c000000185cULL,
0x0000001c008d7306ULL, 0x000ea20000200c00ULL, 0x000054108c8c7816ULL, 0x002fe2000000008bULL,
0x0000007c7440723cULL, 0x080b6c0000001840ULL, 0x0000007f007f7306ULL, 0x000e640000200c00ULL,
0x0000007c7060723cULL, 0x000b620000001860ULL, 0x00005410188d7816ULL, 0x004fe2000000008dULL,
0x0000000212187824ULL, 0x000fca00078e00ffULL, 0xfffffff8181a7812ULL, 0x000fe200078ec0ffULL,
0x0000008c7444723cULL, 0x000b620000001844ULL, 0x000054107f8f7816ULL, 0x002fce0000000090ULL,
0x0000008e7448723cULL, 0x000b700000001848ULL, 0x0000008c7064723cULL, 0x040b700000001864ULL,
0x0000008e7068723cULL, 0x000b620000001868ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fde0000008000ULL, 0x00000000252a7f8cULL, 0x0202a2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a698001aff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff187224ULL, 0x000fc600078e00ffULL, 0x0000000000207805ULL, 0x000fc80000015200ULL,
0x0000040025237984ULL, 0x000e620000000800ULL, 0x000000030d1a7810ULL, 0x008fc40007ffe0ffULL,
0x8000000023ff7812ULL, 0x006fe2000780482bULL, 0x0000000000007918ULL, 0x000fd60000000000ULL,
0x000001f000007945ULL, 0x000fe20003800000ULL, 0x000001d000000947ULL, 0x000fea0003800000ULL,
0x000001c000017945ULL, 0x000fe40003800000ULL, 0x000000101800780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000027945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x0000002620237210ULL, 0x000fca0007f1e1ffULL, 0x0000000127267824ULL, 0x000fe200000e0e21ULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1c7819ULL, 0x000fc80000011426ULL, 0x000000231c1c7211ULL, 0x000fca00078110ffULL,
0x000000ffff237224ULL, 0x000fca00000e0626ULL, 0x000000021c1c7819ULL, 0x000fc80000001223ULL,
0x0000001c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000118187810ULL, 0x000fc40007ffe0ffULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000040025237984ULL, 0x000e640000000800ULL, 0x8000000023ff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000108237810ULL, 0x000fe40007ffe0ffULL, 0x000000030a0a7810ULL, 0x000fe40007ffe0ffULL,
0x0000000e2300720cULL, 0x000fda0003f06070ULL, 0x0000085000000947ULL, 0x000fea0003800000ULL,
0x0000000208217810ULL, 0x000fe20007ffe0ffULL, 0x0000010023237824ULL, 0x000fe400078e027bULL,
0x0000590022227a24ULL, 0x010fe200078e02ffULL, 0x0000000e2100720cULL, 0x000fe40003f06070ULL,
0x00000020230a7812ULL, 0x000fe200078ec0ffULL, 0x00000040226d7824ULL, 0x000fc800078e00ffULL,
0x000000010b2a7824ULL, 0x000fcc00078e020aULL, 0x0000040000008947ULL, 0x000fea0003800000ULL,
0x00000023100a7217ULL, 0x000fe20007800000ULL, 0x0000001012187824ULL, 0x000fc800078e00ffULL,
0x000000010a0a7824ULL, 0x000fe200078e0a23ULL, 0x0000001018217812ULL, 0x000fe400078ec0ffULL,
0x00000003ff187819ULL, 0x000fe40000011611ULL, 0x0000000a210a7217ULL, 0x000fe40007800000ULL,
0x00000004181c7810ULL, 0x040fe40007ffe0ffULL, 0x0000000818207810ULL, 0x000fe20007ffe0ffULL,
0x000000010a0a7824ULL, 0x100fe200078e0a21ULL, 0x0000000c18257810ULL, 0x000fe20007ffe0ffULL,
0x000000011c227824ULL, 0x000fc400078e0221ULL, 0x0000000120237824ULL, 0x040fe200078e0221ULL,
0x0000000a2000720cULL, 0x080fe20003f46070ULL, 0x0000000122207824ULL, 0x000fe200078e0211ULL,
0x0000000a1800720cULL, 0x080fe20003f86070ULL, 0x00000008222b7824ULL, 0x000fe200078e00ffULL,
0x0000000a1c00720cULL, 0x080fe20003f66070ULL, 0x0000000118187824ULL, 0x100fe200078e0221ULL,
0x0000000a2500720cULL, 0x040fe20003f06070ULL, 0x0000000125217824ULL, 0x000fe200078e0221ULL,
0xfffffff82b0a7812ULL, 0x000fe200078ee220ULL, 0x00000001181c7824ULL, 0x000fc400078e0211ULL,
0x0000000818277824ULL, 0x040fe400078e00ffULL, 0x0000000118207824ULL, 0x100fe400078e022aULL,
0x0000000123267824ULL, 0x000fe200078e022aULL, 0xfffffff8271c7812ULL, 0x000fe200078ee21cULL,
0x0000000123187824ULL, 0x040fe400078e0211ULL, 0x0000000823237824ULL, 0x000fe400078e00ffULL,
0x0000000122227824ULL, 0x000fc400078e022aULL, 0x0000000121257824ULL, 0x000fe200078e0211ULL,
0xfffffff823187812ULL, 0x000fe200078ee218ULL, 0x00000008216c7824ULL, 0x040fe400078e00ffULL,
0x00000001212a7824ULL, 0x000fe400078e022aULL, 0x0000008020207825ULL, 0x000fe200078e00ffULL,
0xfffffff86c6c7812ULL, 0x000fe400078ee225ULL, 0x000062006d257a11ULL, 0x000fe200078a38ffULL,
0x0000008022227825ULL, 0x000fe200078e00ffULL, 0x0000000320207212ULL, 0x000fc400078efcffULL,
0x000063006d6d7a11ULL, 0x000fe200028f3cffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000000322227212ULL, 0x000fe400078efcffULL, 0x0000002025207210ULL, 0x000fe20007fbe0ffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000002522227210ULL, 0x000fe40007fde0ffULL,
0x0000000326267212ULL, 0x080fe200078efcffULL, 0x0000000121217824ULL, 0x100fe200028e066dULL,
0x000000032a2a7212ULL, 0x000fe200078efcffULL, 0x0000000123237824ULL, 0x000fe200030e066dULL,
0x0000002526267210ULL, 0x080fe20007fbe0ffULL, 0x000000100a717824ULL, 0x100fe200078e021fULL,
0x000000252a2a7210ULL, 0x000fe20007fde0ffULL, 0x000000101c257824ULL, 0x000fc400078e021fULL,
0x0000001018737824ULL, 0x000fe400078e021fULL, 0x0000000127277824ULL, 0x000fe200028e066dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e2000e101c48ULL,
0x000000106c1f7824ULL, 0x000fe400078e021fULL, 0x000000012b2b7824ULL, 0x000fe200030e066dULL,
0x0000000022717faeULL, 0x0003e8000d901c48ULL, 0x0000000026737faeULL, 0x0003e8000d101c48ULL,
0x000000002a1f7faeULL, 0x0003e2000c101c48ULL, 0x0000033000007947ULL, 0x000fea0003800000ULL,
0x00000010120a7824ULL, 0x000fca00078e00ffULL, 0x000000100a0a7812ULL, 0x000fc800078ec0ffULL,
0x0000000a110a7211ULL, 0x000fc800078fe8ffULL, 0x000000040a1c7810ULL, 0x040fe20007ffe0ffULL,
0x000000010a187824ULL, 0x140fe200078e0211ULL, 0x0000000c0a237810ULL, 0x040fe20007ffe0ffULL,
0x000000080a217824ULL, 0x040fe400078e00ffULL, 0x000000010a207824ULL, 0x100fe400078e022aULL,
0x000000011c227824ULL, 0x040fe200078e022aULL, 0xfffffff821187812ULL, 0x000fe200078ee218ULL,
0x000000081c277824ULL, 0x000fe200078e00ffULL, 0x000000080a217810ULL, 0x000fe20007ffe0ffULL,
0x000000011c0a7824ULL, 0x000fc400078e0211ULL, 0x0000000123257824ULL, 0x140fe400078e0211ULL,
0x00000008236c7824ULL, 0x000fe200078e00ffULL, 0xfffffff8270a7812ULL, 0x000fe200078ee20aULL,
0x0000000121267824ULL, 0x040fe400078e022aULL, 0x00000001211c7824ULL, 0x040fe200078e0211ULL,
0xfffffff86c6c7812ULL, 0x000fe200078ee225ULL, 0x00000008212b7824ULL, 0x000fe200078e00ffULL,
0x000062006d257a11ULL, 0x000fe200078038ffULL, 0x0000008020207825ULL, 0x000fc600078e00ffULL,
0xfffffff82b1c7812ULL, 0x000fe200078ee21cULL, 0x00000001232a7824ULL, 0x000fe200078e022aULL,
0x0000000320207212ULL, 0x080fe200078efcffULL, 0x0000008022227825ULL, 0x000fe200078e00ffULL,
0x000063006d6d7a11ULL, 0x000fe400000f3cffULL, 0x0000002025207210ULL, 0x000fe20007f1e0ffULL,
0x0000008026267825ULL, 0x000fe200078e00ffULL, 0x0000000322227212ULL, 0x000fc600078efcffULL,
0x000000802a2a7825ULL, 0x000fe200078e00ffULL, 0x0000000326267212ULL, 0x000fc600078efcffULL,
0x0000000121217824ULL, 0x000fe200000e066dULL, 0x000000032a2a7212ULL, 0x000fe200078efcffULL,
0x000000100a717824ULL, 0x100fe200078e021fULL, 0x0000002225227210ULL, 0x040fe20007f1e0ffULL,
0x000000101c737824ULL, 0x100fe200078e021fULL, 0x0000002625267210ULL, 0x040fe40007f5e0ffULL,
0x0000002a252a7210ULL, 0x000fe20007f7e0ffULL, 0x0000001018257824ULL, 0x000fe400078e021fULL,
0x0000000123237824ULL, 0x000fc400000e066dULL, 0x0000000127277824ULL, 0x000fe200010e066dULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020257faeULL, 0x0003e2000b901c48ULL,
0x000000106c1f7824ULL, 0x000fe400078e021fULL, 0x000000012b2b7824ULL, 0x000fe200018e066dULL,
0x0000000022717faeULL, 0x0003e8000b901c48ULL, 0x0000000026737faeULL, 0x0003e8000b901c48ULL,
0x000000002a1f7faeULL, 0x0003e4000b901c48ULL, 0x00000004060a7810ULL, 0x000fe20007ffe0ffULL,
0x0000008000007945ULL, 0x000fe20003800000ULL, 0xffffffffff227424ULL, 0x002fc400078e00ffULL,
0x0000000f0a00720cULL, 0x000fda0003f06070ULL, 0x0000004000000947ULL, 0x000fea0003800000ULL,
0x0000000109227824ULL, 0x000fe400078e020aULL, 0x00000004ff237424ULL, 0x000fc800078e00ffULL,
0x0000640022227625ULL, 0x000fcc00078e0023ULL, 0x0000000822227981ULL, 0x000324000c1e1900ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000812187824ULL, 0x000fe400078e00ffULL,
0x000000200d067824ULL, 0x000fc600078e0207ULL, 0xfffffff018207812ULL, 0x040fe400078ec0ffULL,
0x00000008181f7812ULL, 0x000fe400078ec0ffULL, 0x00000000200473c2ULL, 0x000ea200000e0000ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x000000011f067824ULL, 0x000fe200078e0206ULL,
0x0001a6a804047890ULL, 0x004fd2000fffe03fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000ff0079b0ULL, 0x000fe20008000a04ULL,
0x0000000000007918ULL, 0x000fe40000000000ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a6a80020207f8cULL, 0x000ea2000c80043fULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x01a66800062a7f8cULL, 0x000662000c80043fULL, 0x000000ffff187224ULL, 0x004fc600078e0021ULL,
0x0000000000207805ULL, 0x000fc80000015200ULL, 0x01a66c00061f7984ULL, 0x000ea40000000800ULL,
0x800000001fff7812ULL, 0x006fe4000780482bULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff237224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102300780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000267805ULL, 0x000fcc0000015200ULL,
0x00000026201f7210ULL, 0x000fca0007f1e1ffULL, 0x0000000127267824ULL, 0x000fe200000e0e21ULL,
0x003d09001f00780cULL, 0x000fc80003f06070ULL, 0x000000ff2600720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c401f00780cULL, 0x000fc80003f06070ULL,
0x000000ff2600720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff1c7819ULL, 0x000fc80000011426ULL, 0x0000001f1c1c7211ULL, 0x000fca00078110ffULL,
0x000000ffff1f7224ULL, 0x000fca00000e0626ULL, 0x000000021c1c7819ULL, 0x000fc8000000121fULL,
0x0000001c0000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000123237810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a66c00061f7984ULL, 0x000e640000000800ULL, 0x800000001fff7812ULL, 0x002fe4000780482bULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000801a1f7824ULL, 0x000fc800078e0203ULL,
0x00000001021f7824ULL, 0x000fca00078e021fULL, 0x01a000001f237984ULL, 0x000e680000000800ULL,
0x01a200001f217984ULL, 0x0004e20000000800ULL, 0x000000042300720bULL, 0x002fe20003f1d000ULL,
0x0000db027f007947ULL, 0x000fd8000b800000ULL, 0x0000000000067806ULL, 0x00cfc800000e0100ULL,
0x000000ff0600720cULL, 0x000fe20003f05270ULL, 0x0000076000007945ULL, 0x000fe20003800000ULL,
0x00000001ff1f7424ULL, 0x000fe400078e00ffULL, 0x000000ffff1a7224ULL, 0x000fd200078e0004ULL,
0x0000072000008947ULL, 0x000fea0003800000ULL, 0x000000030d1f7810ULL, 0x000fe40007ffe0ffULL,
0x000000042300720bULL, 0x000fe40003f54000ULL, 0x000000121f00720cULL, 0x000fe20003f05270ULL,
0x0000dac27f007947ULL, 0x000fd4000b800000ULL, 0x00000000001f7806ULL, 0x000fc400010e0100ULL,
0x0000008012038824ULL, 0x000fe200078e0203ULL, 0x00000004231a7209ULL, 0x000fe20007810000ULL,
0x0000063000017945ULL, 0x000fe40003800000ULL, 0x0000000102038824ULL, 0x000fca00078e0203ULL,
0x01a4001a03008388ULL, 0x0003e20000000800ULL, 0x000000ff1f00720cULL, 0x000fda0003f05270ULL,
0x000005e000008947ULL, 0x000fea0003800000ULL, 0x000000041a027221ULL, 0x002fe20000010100ULL,
0x000000ff1fff7812ULL, 0x000fe2000780c0ffULL, 0x0000018000027945ULL, 0x000fe40003800000ULL,
0x3fb8aa3b02027820ULL, 0x000fc80000410000ULL, 0x0000000200037308ULL, 0x000e640000000800ULL,
0x0000000324247220ULL, 0x002fc80000410000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x00000002ff277819ULL, 0x000fe20000011611ULL, 0x0000da127f007947ULL, 0x000fea000b800000ULL,
0x00001f2703267589ULL, 0x0002a400000e0000ULL, 0x000000262c2c7220ULL, 0x084fe40000410000ULL,
0x000000262d2d7220ULL, 0x080fe40000410000ULL, 0x0000002630307220ULL, 0x080fe40000410000ULL,
0x0000002631317220ULL, 0x080fe40000410000ULL, 0x0000002634347220ULL, 0x080fe40000410000ULL,
0x0000002635357220ULL, 0x000fc40000410000ULL, 0x0000002638387220ULL, 0x080fe40000410000ULL,
0x0000002639397220ULL, 0x080fe40000410000ULL, 0x000000263c3c7220ULL, 0x080fe40000410000ULL,
0x000000263d3d7220ULL, 0x080fe40000410000ULL, 0x0000002640407220ULL, 0x080fe40000410000ULL,
0x0000002641417220ULL, 0x000fc40000410000ULL, 0x0000002644447220ULL, 0x080fe40000410000ULL,
0x0000002645457220ULL, 0x080fe40000410000ULL, 0x0000002648487220ULL, 0x080fe40000410000ULL,
0x0000002649497220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0x0000ff001fff7812ULL, 0x000fe2000780c0ffULL, 0x0000015000027945ULL, 0x000fd80003800000ULL,
0x0000013000008947ULL, 0x000fea0003800000ULL, 0x0000000811277811ULL, 0x002fe200078ff0ffULL,
0x0000d9027f007947ULL, 0x000fea000b800000ULL, 0x00001f2703267589ULL, 0x0002a400000e0000ULL,
0x000000262e2e7220ULL, 0x084fe40000410000ULL, 0x000000262f2f7220ULL, 0x080fe40000410000ULL,
0x0000002632327220ULL, 0x080fe40000410000ULL, 0x0000002633337220ULL, 0x080fe40000410000ULL,
0x0000002636367220ULL, 0x080fe40000410000ULL, 0x0000002637377220ULL, 0x000fc40000410000ULL,
0x000000263a3a7220ULL, 0x080fe40000410000ULL, 0x000000263b3b7220ULL, 0x080fe40000410000ULL,
0x000000263e3e7220ULL, 0x080fe40000410000ULL, 0x000000263f3f7220ULL, 0x080fe40000410000ULL,
0x0000002642427220ULL, 0x080fe40000410000ULL, 0x0000002643437220ULL, 0x000fc40000410000ULL,
0x0000002646467220ULL, 0x080fe40000410000ULL, 0x0000002647477220ULL, 0x080fe40000410000ULL,
0x000000264a4a7220ULL, 0x080fe40000410000ULL, 0x000000264b4b7220ULL, 0x000fc40000410000ULL,
0x0000000000027941ULL, 0x000fea0003800000ULL, 0x00ff00001fff7812ULL, 0x000fe2000780c0ffULL,
0x0000015000027945ULL, 0x000fd80003800000ULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001011277811ULL, 0x002fe200078ff0ffULL, 0x0000d7f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2703267589ULL, 0x0002a400000e0000ULL, 0x000000264c4c7220ULL, 0x084fe40000410000ULL,
0x000000264d4d7220ULL, 0x080fe40000410000ULL, 0x0000002650507220ULL, 0x080fe40000410000ULL,
0x0000002651517220ULL, 0x080fe40000410000ULL, 0x0000002654547220ULL, 0x080fe40000410000ULL,
0x0000002655557220ULL, 0x000fc40000410000ULL, 0x0000002658587220ULL, 0x080fe40000410000ULL,
0x0000002659597220ULL, 0x080fe40000410000ULL, 0x000000265c5c7220ULL, 0x080fe40000410000ULL,
0x000000265d5d7220ULL, 0x080fe40000410000ULL, 0x0000002660607220ULL, 0x080fe40000410000ULL,
0x0000002661617220ULL, 0x000fc40000410000ULL, 0x0000002664647220ULL, 0x080fe40000410000ULL,
0x0000002665657220ULL, 0x080fe40000410000ULL, 0x0000002668687220ULL, 0x080fe40000410000ULL,
0x0000002669697220ULL, 0x000fc40000410000ULL, 0x0000000000027941ULL, 0x000fea0003800000ULL,
0xff0000001fff7812ULL, 0x000fda000780c0ffULL, 0x0000013000008947ULL, 0x000fea0003800000ULL,
0x0000001811277811ULL, 0x002fe200078ff0ffULL, 0x0000d6f27f007947ULL, 0x000fea000b800000ULL,
0x00001f2703267589ULL, 0x0002a400000e0000ULL, 0x000000264e4e7220ULL, 0x084fe40000410000ULL,
0x000000264f4f7220ULL, 0x080fe40000410000ULL, 0x0000002652527220ULL, 0x080fe40000410000ULL,
0x0000002653537220ULL, 0x080fe40000410000ULL, 0x0000002656567220ULL, 0x080fe40000410000ULL,
0x0000002657577220ULL, 0x000fc40000410000ULL, 0x000000265a5a7220ULL, 0x080fe40000410000ULL,
0x000000265b5b7220ULL, 0x080fe40000410000ULL, 0x000000265e5e7220ULL, 0x080fe40000410000ULL,
0x000000265f5f7220ULL, 0x080fe40000410000ULL, 0x0000002662627220ULL, 0x080fe40000410000ULL,
0x0000002663637220ULL, 0x000fc40000410000ULL, 0x0000002666667220ULL, 0x080fe40000410000ULL,
0x0000002667677220ULL, 0x080fe40000410000ULL, 0x000000266a6a7220ULL, 0x080fe40000410000ULL,
0x000000266b6b7220ULL, 0x000fc40000410000ULL, 0x0000000000017941ULL, 0x002fea0003800000ULL,
0x0000001f06ff7212ULL, 0x000fe200078030ffULL, 0x00000001ff1f7424ULL, 0x000fd800078e00ffULL,
0x000000231a020221ULL, 0x000fe20000010100ULL, 0x00007610ff1f0816ULL, 0x000fc6000000001fULL,
0x3fb8aa3b02020820ULL, 0x000fc80000410000ULL, 0x0000000200000308ULL, 0x000e640000000800ULL,
0x0000000021210220ULL, 0x002fcc0000410000ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00000024211c7221ULL, 0x000fe20000010000ULL, 0x000000010c047812ULL, 0x000fc400078ec0ffULL,
0x0000000000027805ULL, 0x000fca0000015200ULL, 0x0000000812067824ULL, 0x000fca00078e00ffULL,
0xfffffff006247812ULL, 0x000fca00078ec0ffULL, 0x01a6b40024217984ULL, 0x000e640000000800ULL,
0x8000000021ff7812ULL, 0x002fe4000780486fULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff257224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000102500780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000207805ULL, 0x000fcc0000015200ULL,
0x0000002002237210ULL, 0x000fca0007f1e1ffULL, 0x0000000121217824ULL, 0x000fe200000e0e03ULL,
0x003d09002300780cULL, 0x000fc80003f06070ULL, 0x000000ff2100720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c402300780cULL, 0x000fc80003f06070ULL,
0x000000ff2100720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011421ULL, 0x0000002306067211ULL, 0x000fca00078110ffULL,
0x000000ffff217224ULL, 0x000fca00000e0621ULL, 0x0000000206067819ULL, 0x000fc80000001221ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000000125257810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a6b40024217984ULL, 0x000e640000000800ULL, 0x8000000021ff7812ULL, 0x002fe4000780486fULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000099101f027816ULL, 0x000fe200000000ffULL,
0x0000010000007945ULL, 0x000fe60003800000ULL, 0x000000ff0200720cULL, 0x000fda0003f05270ULL,
0x000000d000000947ULL, 0x000fea0003800000ULL, 0x00000000ff02723eULL, 0x000fe400000000ffULL,
0x00000002ff037819ULL, 0x000fe40000011611ULL, 0x0000541002027816ULL, 0x000fe20000000002ULL,
0x0000d2c27f007947ULL, 0x000fea000b800000ULL, 0x00001f0302137589ULL, 0x0002a400000e0000ULL,
0x0000000803277810ULL, 0x000fe20007ffe0ffULL, 0x0000d3127f007947ULL, 0x000fea000b800000ULL,
0x0000001003157810ULL, 0x000fe20007ffe0ffULL, 0x00001f2702147589ULL, 0x00066a00000e0000ULL,
0x00001f1502157589ULL, 0x0006a400000e0000ULL, 0x0000001803277810ULL, 0x008fe20007ffe0ffULL,
0x0000d3a27f007947ULL, 0x000fea000b800000ULL, 0x00001f2702167589ULL, 0x0006a400000e0000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x00000004ff037819ULL, 0x002fe20000011611ULL,
0x00000008171f7824ULL, 0x000fe200078e00ffULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x0000000819217824ULL, 0x000fe200078e00ffULL, 0x0000019000007945ULL, 0x000fe20003800000ULL,
0x0000000404047824ULL, 0x000fe200078e0203ULL, 0x000000030d037810ULL, 0x000fe20007ffe0ffULL,
0x0000000412067824ULL, 0x000fc400078e00ffULL, 0x0000000117027824ULL, 0x108fe200078e0204ULL,
0x0001200003037811ULL, 0x000fe200078e60ffULL, 0x0000000119047824ULL, 0x000fe200078e0204ULL,
0x0000000406067812ULL, 0x000fe200078ec0ffULL, 0x000000101b707824ULL, 0x000fe200078e0228ULL,
0xfffffff81f027812ULL, 0x000fe400078ee202ULL, 0xfffffff821047812ULL, 0x000fe400078ee204ULL,
0x0000000206067812ULL, 0x000fe200078efcffULL, 0x0000001002027824ULL, 0x000fc400078e0203ULL,
0x0000001004047824ULL, 0x000fc600078e0203ULL, 0x00000000026c783bULL, 0x0002e80000000200ULL,
0x000000000424783bULL, 0x0002a20000000200ULL, 0x0000008000000947ULL, 0x000fea0003800000ULL,
0x000000136c6c7232ULL, 0x08cfe40000000000ULL, 0x000000136e6e7232ULL, 0x000fe40000000000ULL,
0x000000146d6d7232ULL, 0x080fe40000000000ULL, 0x000000146f6f7232ULL, 0x000fc40000000000ULL,
0x0000001524247232ULL, 0x080fe40000000000ULL, 0x0000001526267232ULL, 0x000fe40000000000ULL,
0x0000001625257232ULL, 0x080fe40000000000ULL, 0x0000001627277232ULL, 0x000fc40000000000ULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000611027211ULL, 0x002fe200078fe0ffULL,
0x0000000817047824ULL, 0x000fe200078e00ffULL, 0x000000007070783bULL, 0x000e620000004200ULL,
0x000000101d1d7824ULL, 0x000fe200078e0203ULL, 0x0000082000007945ULL, 0x000fe20003800000ULL,
0x0000000117177824ULL, 0x000fc400078e0202ULL, 0x000000101e037824ULL, 0x000fc600078e0203ULL,
0xfffffff804177812ULL, 0x000fca00078ee217ULL, 0x0000001017177824ULL, 0x000fca00078e0228ULL,
0x000000001774783bULL, 0x000ee20000004200ULL, 0x00000018ff207819ULL, 0x002fe20000011473ULL,
0x00000100737d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff067819ULL, 0x000fe40000011471ULL,
0x0000002000817306ULL, 0x0003e20000200c00ULL, 0x00000018ff1f7819ULL, 0x000fe40000011472ULL,
0x00000018ff047819ULL, 0x000fe40000011470ULL, 0x00000018ff7d7819ULL, 0x000fc6000001147dULL,
0x0000000600237306ULL, 0x0005e20000200c00ULL, 0x0000010071207824ULL, 0x002fe200078e00ffULL,
0x00000018ff2a7819ULL, 0x008fe40000011476ULL, 0x00000018ff217819ULL, 0x000fc80000011474ULL,
0x0000001f007e7306ULL, 0x0003e20000200c00ULL, 0x00000018ff207819ULL, 0x000fe20000011420ULL,
0x0000010070067824ULL, 0x004fe200078e00ffULL, 0x00000018ff2b7819ULL, 0x000fe40000011477ULL,
0x00000018ff177819ULL, 0x000fe40000011475ULL, 0x00000018ff067819ULL, 0x000fe20000011406ULL,
0x0000002a008c7306ULL, 0x000fe20000200c00ULL, 0x00008880711f7816ULL, 0x042fe200000000ffULL,
0x0001000071717824ULL, 0x000fca00078e00ffULL, 0x00000018ff717819ULL, 0x000fe20000011471ULL,
0x0000002100857306ULL, 0x0003f00000200c00ULL, 0x00000020002a7306ULL, 0x0005e20000200c00ULL,
0x0000888072217816ULL, 0x002fce00000000ffULL, 0x00000004001b7306ULL, 0x0003e20000200c00ULL,
0x0000888073207816ULL, 0x004fce00000000ffULL, 0x0000002b008d7306ULL, 0x0005e20000200c00ULL,
0x0000888070047816ULL, 0x042fe200000000ffULL, 0x0001000070707824ULL, 0x000fca00078e00ffULL,
0x00000018ff707819ULL, 0x000fe20000011470ULL, 0x00000021007c7306ULL, 0x0003e20000200c00ULL,
0x00000100722b7824ULL, 0x044fe400078e00ffULL, 0x0001000072727824ULL, 0x000fc600078e00ffULL,
0x00000018ff2b7819ULL, 0x000fe4000001142bULL, 0x00000020007f7306ULL, 0x0005e20000200c00ULL,
0x0001000073217824ULL, 0x002fe200078e00ffULL, 0x00000018ff727819ULL, 0x000fc80000011472ULL,
0x00000018ff217819ULL, 0x000fe40000011421ULL, 0x0000001700887306ULL, 0x000fe20000200c00ULL,
0x0000010074207824ULL, 0x004fca00078e00ffULL, 0x00000018ff207819ULL, 0x000fe40000011420ULL,
0x0000000600177306ULL, 0x000ff00000200c00ULL, 0x0000000400047306ULL, 0x000ff00000200c00ULL,
0x0000007100067306ULL, 0x0003f00000200c00ULL, 0x0000007d00807306ULL, 0x0005e20000200c00ULL,
0x0000888074717816ULL, 0x042fe200000000ffULL, 0x0001000074747824ULL, 0x000fca00078e00ffULL,
0x00000018ff747819ULL, 0x000fe20000011474ULL, 0x0000007200737306ULL, 0x0002e20000200c00ULL,
0x00008880757d7816ULL, 0x004fce00000000ffULL, 0x0000002100827306ULL, 0x0005e20000200c00ULL,
0x0000010075727824ULL, 0x042fe400078e00ffULL, 0x0001000075757824ULL, 0x000fc600078e00ffULL,
0x00000018ff727819ULL, 0x000fe40000011472ULL, 0x0000007100837306ULL, 0x0003e20000200c00ULL,
0x0000010076217824ULL, 0x004fe200078e00ffULL, 0x00000018ff757819ULL, 0x000fe40000011475ULL,
0x00005410737e7816ULL, 0x008fe4000000007eULL, 0x00000018ff217819ULL, 0x000fe40000011421ULL,
0x0000002000867306ULL, 0x0004e20000200c00ULL, 0x0000888077717816ULL, 0x002fce00000000ffULL,
0x0000007d00877306ULL, 0x0003e20000200c00ULL, 0x0000888076207816ULL, 0x044fe200000000ffULL,
0x0001000076767824ULL, 0x000fca00078e00ffULL, 0x00000018ff767819ULL, 0x000fe20000011476ULL,
0x0000002000897306ULL, 0x0005e20000200c00ULL, 0x00000100777d7824ULL, 0x002fe200078e00ffULL,
0x0000541083867816ULL, 0x008fe20000000086ULL, 0x0001000077777824ULL, 0x000fc600078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x00000071008b7306ULL, 0x0003e20000200c00ULL, 0x0000541004207816ULL, 0x004fce0000000017ULL,
0x0000001f001f7306ULL, 0x000fe20000200c00ULL, 0x0000541006717816ULL, 0x002fce0000000023ULL,
0x0000007000707306ULL, 0x000e700000200c00ULL, 0x0000002b002b7306ULL, 0x000eb00000200c00ULL,
0x0000007200727306ULL, 0x000ee20000200c00ULL, 0x0000541070707816ULL, 0x002fce000000001bULL,
0x0000007400747306ULL, 0x000e620000200c00ULL, 0x000054107c7c7816ULL, 0x004fe2000000002bULL,
0x000000706c30723cULL, 0x080f6c0000001830ULL, 0x0000007500757306ULL, 0x000ea20000200c00ULL,
0x0000541087877816ULL, 0x008fe20000000072ULL, 0x000000702450723cULL, 0x000f6c0000001850ULL,
0x00000021008a7306ULL, 0x0006a20000200c00ULL, 0x0000541074747816ULL, 0x002fe20000000085ULL,
0x000000866c3c723cULL, 0x080f6c000000183cULL, 0x0000007d00047306ULL, 0x0002620000200c00ULL,
0x000054101f217816ULL, 0x008fe2000000002aULL, 0x00000086245c723cULL, 0x000f62000000185cULL,
0x0000541075757816ULL, 0x004fca0000000088ULL, 0x0000007600177306ULL, 0x000ea20000200c00ULL,
0x000054107f7d7816ULL, 0x002fe20000000080ULL, 0x000000206c2c723cULL, 0x000f62000000182cULL,
0x00005410827f7816ULL, 0x000fe40000000081ULL, 0x00005410898a7816ULL, 0x000fc6000000008aULL,
0x0000007700067306ULL, 0x000e620000200c00ULL, 0x000054108b8b7816ULL, 0x000fe20000000004ULL,
0x0000007c6c34723cULL, 0x000f620000001834ULL, 0x00005410178c7816ULL, 0x004fce000000008cULL,
0x0000007e6c38723cULL, 0x000f620000001838ULL, 0x00005410068d7816ULL, 0x002fce000000008dULL,
0x000000746c40723cULL, 0x040f700000001840ULL, 0x0000008a6c44723cULL, 0x040f700000001844ULL,
0x0000008c6c48723cULL, 0x000b640000001848ULL, 0x000000001d6c783bULL, 0x0202ac0000000200ULL,
0x00000020244c723cULL, 0x040f70000000184cULL, 0x0000007c2454723cULL, 0x040f700000001854ULL,
0x0000007e2458723cULL, 0x040f700000001858ULL, 0x000000742460723cULL, 0x040f700000001860ULL,
0x0000008a2464723cULL, 0x040f700000001864ULL, 0x0000008c2468723cULL, 0x000b640000001868ULL,
0x000000000324783bULL, 0x0202e20000000200ULL, 0x0000000000007918ULL, 0x000fc20000000000ULL,
0x0000008000000947ULL, 0x000fde0003800000ULL, 0x000000136c6c7232ULL, 0x084fe40000000000ULL,
0x000000136e6e7232ULL, 0x000fc40000000000ULL, 0x000000146d6d7232ULL, 0x080fe40000000000ULL,
0x000000146f6f7232ULL, 0x000fe40000000000ULL, 0x0000001524247232ULL, 0x088fe40000000000ULL,
0x0000001526267232ULL, 0x000fe40000000000ULL, 0x0000001625257232ULL, 0x080fe40000000000ULL,
0x0000001627277232ULL, 0x000fc40000000000ULL, 0x0000000000007941ULL, 0x004fea0003800000ULL,
0x000000002970783bULL, 0x000ea20000004200ULL, 0x0000000819037824ULL, 0x002fc400078e00ffULL,
0x0000000119027824ULL, 0x000fca00078e0202ULL, 0xfffffff803037812ULL, 0x000fca00078ee202ULL,
0x0000001003037824ULL, 0x000fca00078e0228ULL, 0x000000000374783bULL, 0x0002e20000004200ULL,
0x00000018ff177819ULL, 0x004fe20000011472ULL, 0x0000010070037824ULL, 0x002fe200078e00ffULL,
0x00000018ff027819ULL, 0x000fe20000011470ULL, 0x0000010073237824ULL, 0x000fe200078e00ffULL,
0x0000001700217306ULL, 0x0003e20000200c00ULL, 0x00000018ff067819ULL, 0x000fe40000011471ULL,
0x00000018ff197819ULL, 0x000fe40000011473ULL, 0x00000018ff037819ULL, 0x000fc40000011403ULL,
0x00000018ff237819ULL, 0x000fe20000011423ULL, 0x0000000200047306ULL, 0x0005e20000200c00ULL,
0x0000010071177824ULL, 0x002fe200078e00ffULL, 0x00000018ff207819ULL, 0x008fcc0000011477ULL,
0x00000006001f7306ULL, 0x0003e20000200c00ULL, 0x0000888070027816ULL, 0x044fe200000000ffULL,
0x0001000070707824ULL, 0x000fe200078e00ffULL, 0x00000018ff1d7819ULL, 0x000fe40000011475ULL,
0x00000018ff1e7819ULL, 0x000fe40000011476ULL, 0x00000018ff707819ULL, 0x000fe20000011470ULL,
0x00000019002b7306ULL, 0x0005e20000200c00ULL, 0x0000888071067816ULL, 0x042fe200000000ffULL,
0x0001000071717824ULL, 0x000fe200078e00ffULL, 0x00000018ff1b7819ULL, 0x000fc80000011474ULL,
0x00000018ff717819ULL, 0x000fe20000011471ULL, 0x0000000200027306ULL, 0x000fe20000200c00ULL,
0x00000018ff197819ULL, 0x004fce0000011417ULL, 0x0000000300037306ULL, 0x000e700000200c00ULL,
0x0000000600067306ULL, 0x000ff00000200c00ULL, 0x0000001900197306ULL, 0x000ea20000200c00ULL,
0x0000541002027816ULL, 0x002fce0000000003ULL, 0x0000001d007f7306ULL, 0x0003f00000200c00ULL,
0x0000002000857306ULL, 0x000fe20000200c00ULL, 0x00000100721d7824ULL, 0x002fe200078e00ffULL,
0x0000541006037816ULL, 0x004fe20000000019ULL, 0x0000010077067824ULL, 0x000fc600078e00ffULL,
0x00000018ff1d7819ULL, 0x000fe4000001141dULL, 0x0000001e00837306ULL, 0x0003e20000200c00ULL,
0x00000018ff067819ULL, 0x000fe20000011406ULL, 0x000000026c2c723cULL, 0x080b6c000000182cULL,
0x0000007100207306ULL, 0x0004e20000200c00ULL, 0x00008880731e7816ULL, 0x042fe200000000ffULL,
0x0001000073737824ULL, 0x000fe200078e00ffULL, 0x00000002244c723cULL, 0x000b68000000184cULL,
0x00000018ff737819ULL, 0x000fe20000011473ULL, 0x00000023002a7306ULL, 0x0003e20000200c00ULL,
0x0000888075717816ULL, 0x004fce00000000ffULL, 0x0000007000177306ULL, 0x000fe20000200c00ULL,
0x0000010075237824ULL, 0x042fe200078e00ffULL, 0x00005410201f7816ULL, 0x008fe2000000001fULL,
0x0001000075757824ULL, 0x000fc600078e00ffULL, 0x00000018ff7d7819ULL, 0x000fe40000011423ULL,
0x0000001e00297306ULL, 0x0002a20000200c00ULL, 0x00000018ff757819ULL, 0x000fce0000011475ULL,
0x0000001b007e7306ULL, 0x0007e20000200c00ULL, 0x00000100741e7824ULL, 0x002fca00078e00ffULL,
0x00000018ff1e7819ULL, 0x000fe4000001141eULL, 0x0000001d00287306ULL, 0x0003e20000200c00ULL,
0x00008880721b7816ULL, 0x048fe200000000ffULL, 0x0001000072727824ULL, 0x000fe200078e00ffULL,
0x0000541029297816ULL, 0x004fc8000000002aULL, 0x00000018ff727819ULL, 0x000fe20000011472ULL,
0x0000007500827306ULL, 0x0004e20000200c00ULL, 0x00008880741d7816ULL, 0x042fe200000000ffULL,
0x0001000074747824ULL, 0x000fca00078e00ffULL, 0x00000018ff747819ULL, 0x000fe20000011474ULL,
0x0000007300707306ULL, 0x0003e20000200c00ULL, 0x0000888077757816ULL, 0x044fe200000000ffULL,
0x0001000077777824ULL, 0x000fca00078e00ffULL, 0x00000018ff777819ULL, 0x000fe20000011477ULL,
0x0000007d00807306ULL, 0x0005e20000200c00ULL, 0x0000010076737824ULL, 0x002fe200078e00ffULL,
0x00005410827f7816ULL, 0x008fc8000000007fULL, 0x00000018ff737819ULL, 0x000fe40000011473ULL,
0x0000001e007c7306ULL, 0x0003e20000200c00ULL, 0x00010000767d7824ULL, 0x004fca00078e00ffULL,
0x00000018ff7d7819ULL, 0x000fe4000001147dULL, 0x0000007400237306ULL, 0x000ea20000200c00ULL,
0x00008880761e7816ULL, 0x002fce00000000ffULL, 0x0000001e00817306ULL, 0x0003f00000200c00ULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x00005410171e7816ULL, 0x002fe40000000004ULL,
0x00005410237e7816ULL, 0x004fca000000007eULL, 0x0000000600067306ULL, 0x000fe20000200c00ULL,
0x0000001e6c30723cULL, 0x040b6e0000001830ULL, 0x0000001b001b7306ULL, 0x000e620000200c00ULL,
0x0000007e6c40723cULL, 0x000b6e0000001840ULL, 0x0000007200727306ULL, 0x000ea20000200c00ULL,
0x0000001e2450723cULL, 0x040b6e0000001850ULL, 0x0000001d001d7306ULL, 0x000ee20000200c00ULL,
0x000054101b287816ULL, 0x002fe20000000028ULL, 0x0000007e2460723cULL, 0x000b6c0000001860ULL,
0x0000007100717306ULL, 0x000e620000200c00ULL, 0x0000541072727816ULL, 0x004fe20000000021ULL,
0x000000286c34723cULL, 0x080b6c0000001834ULL, 0x0000007300767306ULL, 0x0004620000200c00ULL,
0x000054101d7c7816ULL, 0x008fe2000000007cULL, 0x000000282454723cULL, 0x000b6c0000001854ULL,
0x0000007d00747306ULL, 0x0002e20000200c00ULL, 0x0000541070737816ULL, 0x004fce000000002bULL,
0x0000007700047306ULL, 0x0004a20000200c00ULL, 0x00005410717d7816ULL, 0x002fe20000000080ULL,
0x000000726c38723cULL, 0x000b620000001838ULL, 0x0000541081767816ULL, 0x000fe40000000076ULL,
0x0000541074747816ULL, 0x008fe40000000083ULL, 0x0000541075777816ULL, 0x004fc60000000006ULL,
0x0000007c6c3c723cULL, 0x000b62000000183cULL, 0x0000541004757816ULL, 0x000fce0000000085ULL,
0x000000766c44723cULL, 0x040b700000001844ULL, 0x000000746c48723cULL, 0x000b700000001848ULL,
0x000000722458723cULL, 0x040b700000001858ULL, 0x0000007c245c723cULL, 0x040b70000000185cULL,
0x000000762464723cULL, 0x040b700000001864ULL, 0x000000742468723cULL, 0x000b620000001868ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fda0000008000ULL, 0x0000000005027f8cULL, 0x0202a2000c80043fULL,
0x0000000108087810ULL, 0x000fc40007ffe0ffULL, 0x0001a6a00d047811ULL, 0x000fe200078e18ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000004ff7f8cULL, 0x0007e2000c80043fULL,
0x000000ffff177224ULL, 0x004fe200078e0003ULL, 0x0000001000001944ULL, 0x000fe20003c00000ULL,
0xffff4eb000007947ULL, 0x000fea000383ffffULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x000005b000008947ULL, 0x000fea0003800000ULL, 0x018000001c007810ULL, 0x000fe20007ffe0ffULL,
0x000000b000007945ULL, 0x000fe60003800000ULL, 0x7f80000000007812ULL, 0x000fc800078ec0ffULL,
0x01ffffff0000780cULL, 0x000fda0003f04070ULL, 0x0000003000000947ULL, 0x000fea0003800000ULL,
0x0000cbe000047802ULL, 0x008fc40000000f00ULL, 0x0000c49000007944ULL, 0x016fea0003c00000ULL,
0x0000004000007947ULL, 0x000fea0003800000ULL, 0x0000001c00037308ULL, 0x004ea40000001000ULL,
0xbf80000003007423ULL, 0x004fc8000000001cULL, 0x800000ff00007221ULL, 0x000fc80000010100ULL,
0x0000000003007223ULL, 0x000fc40000000003ULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x00006d00ff037624ULL, 0x000fe400078e00ffULL, 0x00006c00ff027624ULL, 0x000fca00078e00ffULL,
0x0000000802037981ULL, 0x008ee8000c1e9900ULL, 0x0000000000087919ULL, 0x000ea80000000000ULL,
0x0000000000047919ULL, 0x000e640000000000ULL, 0x0000001808057811ULL, 0x006fc400078ff0ffULL,
0x0000000808097811ULL, 0x040fe400078ff0ffULL, 0x00000002ff077819ULL, 0x000fe40000011604ULL,
0x00000010080b7811ULL, 0x000fe200078ff0ffULL, 0x0000000003067220ULL, 0x008fca0000410000ULL,
0x00001f0706007589ULL, 0x000e6800000e0000ULL, 0x00001f0506057589ULL, 0x000ea800000e0000ULL,
0x00001f0906047589ULL, 0x000ee800000e0000ULL, 0x00001f0b06027589ULL, 0x000ea200000e0000ULL,
0x0000002c002c7220ULL, 0x002fc40000410000ULL, 0x0000002d002d7220ULL, 0x040fe40000410000ULL,
0x0000003000307220ULL, 0x040fe40000410000ULL, 0x0000003100317220ULL, 0x040fe40000410000ULL,
0x0000003400347220ULL, 0x040fe40000410000ULL, 0x0000003500357220ULL, 0x040fe40000410000ULL,
0x0000003800387220ULL, 0x000fc40000410000ULL, 0x0000003900397220ULL, 0x040fe40000410000ULL,
0x0000003c003c7220ULL, 0x040fe40000410000ULL, 0x0000003d003d7220ULL, 0x040fe40000410000ULL,
0x0000004000407220ULL, 0x040fe40000410000ULL, 0x0000004100417220ULL, 0x040fe40000410000ULL,
0x0000004400447220ULL, 0x000fc40000410000ULL, 0x0000004500457220ULL, 0x040fe40000410000ULL,
0x0000004800487220ULL, 0x040fe40000410000ULL, 0x0000004900497220ULL, 0x000fe40000410000ULL,
0x0000004e054e7220ULL, 0x044fe40000410000ULL, 0x0000004f054f7220ULL, 0x040fe40000410000ULL,
0x0000005205527220ULL, 0x000fc40000410000ULL, 0x0000005305537220ULL, 0x040fe40000410000ULL,
0x0000005605567220ULL, 0x040fe40000410000ULL, 0x0000005705577220ULL, 0x040fe40000410000ULL,
0x0000005a055a7220ULL, 0x040fe40000410000ULL, 0x0000005b055b7220ULL, 0x040fe40000410000ULL,
0x0000005e055e7220ULL, 0x000fc40000410000ULL, 0x0000005f055f7220ULL, 0x040fe40000410000ULL,
0x0000006205627220ULL, 0x040fe40000410000ULL, 0x0000006305637220ULL, 0x040fe40000410000ULL,
0x0000006605667220ULL, 0x040fe40000410000ULL, 0x0000006705677220ULL, 0x040fe40000410000ULL,
0x0000006a056a7220ULL, 0x000fc40000410000ULL, 0x0000006b056b7220ULL, 0x000fe40000410000ULL,
0x000000042e2e7220ULL, 0x088fe40000410000ULL, 0x000000042f2f7220ULL, 0x080fe40000410000ULL,
0x0000000432327220ULL, 0x080fe40000410000ULL, 0x0000000433337220ULL, 0x080fe40000410000ULL,
0x0000000436367220ULL, 0x000fc40000410000ULL, 0x0000000437377220ULL, 0x080fe40000410000ULL,
0x000000043a3a7220ULL, 0x080fe40000410000ULL, 0x000000043b3b7220ULL, 0x080fe40000410000ULL,
0x000000043e3e7220ULL, 0x080fe40000410000ULL, 0x000000043f3f7220ULL, 0x080fe40000410000ULL,
0x0000000442427220ULL, 0x000fc40000410000ULL, 0x0000000443437220ULL, 0x080fe40000410000ULL,
0x0000000446467220ULL, 0x080fe40000410000ULL, 0x0000000447477220ULL, 0x080fe40000410000ULL,
0x000000044a4a7220ULL, 0x080fe40000410000ULL, 0x000000044b4b7220ULL, 0x000fe40000410000ULL,
0x000000024c4c7220ULL, 0x000fc40000410000ULL, 0x000000024d4d7220ULL, 0x080fe40000410000ULL,
0x0000000250507220ULL, 0x080fe40000410000ULL, 0x0000000251517220ULL, 0x080fe40000410000ULL,
0x0000000254547220ULL, 0x080fe40000410000ULL, 0x0000000255557220ULL, 0x080fe40000410000ULL,
0x0000000258587220ULL, 0x000fc40000410000ULL, 0x0000000259597220ULL, 0x080fe40000410000ULL,
0x000000025c5c7220ULL, 0x080fe40000410000ULL, 0x000000025d5d7220ULL, 0x080fe40000410000ULL,
0x0000000260607220ULL, 0x080fe40000410000ULL, 0x0000000261617220ULL, 0x080fe40000410000ULL,
0x0000000264647220ULL, 0x000fc40000410000ULL, 0x0000000265657220ULL, 0x080fe40000410000ULL,
0x0000000268687220ULL, 0x080fe40000410000ULL, 0x0000000269697220ULL, 0x000fc40000410000ULL,
0x0000000000007919ULL, 0x000ee20000000000ULL, 0x0000002e2f2e723eULL, 0x000fe400000000ffULL,
0x000000323317723eULL, 0x000fe200000000ffULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x000000363736723eULL, 0x000fc400000000ffULL, 0x0000003a3b1b723eULL, 0x000fe400000000ffULL,
0x0000003e3f3e723eULL, 0x000fe400000000ffULL, 0x00000042431f723eULL, 0x000fe400000000ffULL,
0x000000464746723eULL, 0x000fe400000000ffULL, 0x0000004a4b23723eULL, 0x000fe400000000ffULL,
0x0000004c4d4c723eULL, 0x000fc400000000ffULL, 0x0000000800057811ULL, 0x04afe400078ff0ffULL,
0x0000000200027812ULL, 0x044fe400078ec0ffULL, 0x0000001800097811ULL, 0x000fe200078ff0ffULL,
0x00000008050a7824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x000fe400078ff8ffULL,
0x0000001000057811ULL, 0x000fe200078ff0ffULL, 0x0000000809187824ULL, 0x000fe200078e00ffULL,
0xfffffff80a0a7812ULL, 0x000fc400078ee203ULL, 0x00000002ff077819ULL, 0x000fe20000011600ULL,
0x0000000805167824ULL, 0x000fe200078e00ffULL, 0x0000000502037211ULL, 0x040fe400078ff8ffULL,
0x0000000902057211ULL, 0x040fe200078ff8ffULL, 0x0000000807097824ULL, 0x040fe200078e00ffULL,
0x0000000702047211ULL, 0x000fe200078ff8ffULL, 0x0000000807107824ULL, 0x040fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee203ULL, 0x0000200012037824ULL, 0x000fe200078e00ffULL,
0xfffffff818187812ULL, 0x000fe200078ee205ULL, 0x0000000807057824ULL, 0x000fe200078e00ffULL,
0x0000000204027810ULL, 0x000fc40007ffe0ffULL, 0x0000200003037812ULL, 0x000fe400078ee2ffULL,
0xfffffff809087812ULL, 0x000fe400078ee202ULL, 0xfffffff805027812ULL, 0x000fe200078ee204ULL,
0x000010000c057824ULL, 0x000fe200078e0203ULL, 0x0000000404067810ULL, 0x040fe40007ffe0ffULL,
0x0000000604077810ULL, 0x000fe20007ffe0ffULL, 0x0000000800047824ULL, 0x000fe200078e00ffULL,
0xfffffff8090e7812ULL, 0x000fe200078ee206ULL, 0x0000001002067824ULL, 0x000fe200078e0205ULL,
0xfffffff810107812ULL, 0x000fe200078ee207ULL, 0x000000100a147824ULL, 0x100fe200078e0205ULL,
0x0000000804077812ULL, 0x000fe200078ec0ffULL, 0x00000010080a7824ULL, 0x100fe200078e0205ULL,
0x0000002c2d02723eULL, 0x000fe200000000ffULL, 0x0000001016167824ULL, 0x000fe200078e0205ULL,
0x000000303104723eULL, 0x000fe200000000ffULL, 0x0000000106087824ULL, 0x000fe200078e0207ULL,
0x000000404106723eULL, 0x000fe200000000ffULL, 0x0000001018187824ULL, 0x100fe200078e0205ULL,
0x00005410021c7816ULL, 0x100fe20000000004ULL, 0x000000100e0e7824ULL, 0x100fe200078e0205ULL,
0x00007632021d7816ULL, 0x000fe20000000004ULL, 0x0000001010107824ULL, 0x000fe200078e0205ULL,
0x000000343502723eULL, 0x000fe200000000ffULL, 0x0000000107147824ULL, 0x000fe200078e0214ULL,
0x000000383904723eULL, 0x000fe200000000ffULL, 0x0000001c08007388ULL, 0x0003e20000000a00ULL,
0x0000003c3d05723eULL, 0x000fe200000000ffULL, 0x0000000107167824ULL, 0x000fe200078e0216ULL,
0x000000505126723eULL, 0x000fe200000000ffULL, 0x0000000107187824ULL, 0x040fe200078e0218ULL,
0x00005410361a7816ULL, 0x000fe2000000001bULL, 0x00000001070a7824ULL, 0x000fe200078e020aULL,
0x000000545554723eULL, 0x000fe200000000ffULL, 0x00000001070e7824ULL, 0x000fe200078e020eULL,
0x00000058592a723eULL, 0x000fe200000000ffULL, 0x0000000107107824ULL, 0x000fe200078e0210ULL,
0x000000444507723eULL, 0x000fc400000000ffULL, 0x00005410021c7816ULL, 0x142fe40000000004ULL,
0x00007632021d7816ULL, 0x000fe40000000004ULL, 0x000000484908723eULL, 0x000fe400000000ffULL,
0x0000541005047816ULL, 0x140fe20000000006ULL, 0x0000001c0a007388ULL, 0x000fe20000000a00ULL,
0x0000763205057816ULL, 0x000fe40000000006ULL, 0x0000541007067816ULL, 0x000fc40000000008ULL,
0x0000763207077816ULL, 0x000fe20000000008ULL, 0x000000040e007388ULL, 0x0003e20000000a00ULL,
0x00007632361b7816ULL, 0x000fe4000000001bULL, 0x000054103e1e7816ULL, 0x140fe2000000001fULL,
0x0000000610007388ULL, 0x0005e20000000a00ULL, 0x000076323e1f7816ULL, 0x000fe4000000001fULL,
0x0000541046227816ULL, 0x150fe40000000023ULL, 0x0000763246237816ULL, 0x000fc40000000023ULL,
0x0000541054087816ULL, 0x000fe4000000002aULL, 0x000054102e047816ULL, 0x142fe40000000017ULL,
0x000076322e057816ULL, 0x000fe40000000017ULL, 0x000054104c067816ULL, 0x144fe40000000026ULL,
0x000076324c077816ULL, 0x000fe20000000026ULL, 0x0000000414007388ULL, 0x0003e20000000a00ULL,
0x0000763254097816ULL, 0x000fc4000000002aULL, 0x0000005c5d5c723eULL, 0x000fe200000000ffULL,
0x0004001a0a007388ULL, 0x000fe20000000a00ULL, 0x000000606160723eULL, 0x000fe400000000ffULL,
0x000000646564723eULL, 0x000fe200000000ffULL, 0x0004001e0e007388ULL, 0x000fe20000000a00ULL,
0x000000686932723eULL, 0x000fe400000000ffULL, 0x0000004e4f02723eULL, 0x000fe200000000ffULL,
0x0004002210007388ULL, 0x000fe20000000a00ULL, 0x0000541064147816ULL, 0x002fc40000000032ULL,
0x0000763264157816ULL, 0x000fe20000000032ULL, 0x0000000616007388ULL, 0x0003e20000000a00ULL,
0x000000525304723eULL, 0x000fe400000000ffULL, 0x000000565705723eULL, 0x000fe200000000ffULL,
0x000800080a007388ULL, 0x0005e20000000a00ULL, 0x000000ff0c00720cULL, 0x000fe40003f05270ULL,
0x0000005a5b06723eULL, 0x002fe400000000ffULL, 0x000000666707723eULL, 0x000fc400000000ffULL,
0x000054105c087816ULL, 0x144fe40000000060ULL, 0x000076325c097816ULL, 0x000fca0000000060ULL,
0x000800080e007388ULL, 0x0003e80000000a00ULL, 0x0008001410007388ULL, 0x0005e20000000a00ULL,
0x0000006a6b08723eULL, 0x002fe400000000ffULL, 0x0000541002147816ULL, 0x144fe40000000004ULL,
0x0000763202157816ULL, 0x000fe40000000004ULL, 0x0000005e5f02723eULL, 0x000fc400000000ffULL,
0x000000626304723eULL, 0x000fe200000000ffULL, 0x0000001418007388ULL, 0x0003e20000000a00ULL,
0x00005410072c7816ULL, 0x000fe40000000008ULL, 0x0000541002247816ULL, 0x140fe40000000004ULL,
0x0000763202257816ULL, 0x000fe20000000004ULL, 0x000000017b027824ULL, 0x000fe200078e0200ULL,
0x00007632072d7816ULL, 0x000fc60000000008ULL, 0x0000001002027824ULL, 0x000fe200078e0203ULL,
0x0000541005147816ULL, 0x142fe40000000006ULL, 0x0000763205157816ULL, 0x000fca0000000006ULL,
0x000c00140a007388ULL, 0x000fe80000000a00ULL, 0x000c00240e007388ULL, 0x000fe80000000a00ULL,
0x000c002c10007388ULL, 0x000fe80000000a00ULL, 0x0000000000007b1dULL, 0x000fec0000000000ULL,
0x0000000002047984ULL, 0x000e680000000c00ULL, 0x0004000002147984ULL, 0x000ea80000000c00ULL,
0x00080000021c7984ULL, 0x000ee80000000c00ULL, 0x000c000002247984ULL, 0x000ee80000000c00ULL,
0x0010000002087984ULL, 0x000ee80000000c00ULL, 0x0014000002187984ULL, 0x000ee80000000c00ULL,
0x0018000002207984ULL, 0x000ee80000000c00ULL, 0x001c000002287984ULL, 0x000ee20000000c00ULL,
0x200000ff07077230ULL, 0x002fc40000000000ULL, 0x200000ff06067230ULL, 0x000fe40000000000ULL,
0x200000ff05057230ULL, 0x000fe40000000000ULL, 0x200000ff04047230ULL, 0x000fe40000000000ULL,
0x200000ff17177230ULL, 0x004fe40000000000ULL, 0x200000ff16167230ULL, 0x000fe40000000000ULL,
0x200000ff15157230ULL, 0x000fc40000000000ULL, 0x200000ff14147230ULL, 0x000fe40000000000ULL,
0x200000ff1f1f7230ULL, 0x008fe40000000000ULL, 0x200000ff1e1e7230ULL, 0x000fe40000000000ULL,
0x200000ff1d1d7230ULL, 0x000fe40000000000ULL, 0x200000ff1c1c7230ULL, 0x000fe40000000000ULL,
0x200000ff27277230ULL, 0x000fc40000000000ULL, 0x200000ff26267230ULL, 0x000fe40000000000ULL,
0x200000ff25257230ULL, 0x000fe40000000000ULL, 0x200000ff24247230ULL, 0x000fe40000000000ULL,
0x0000000b07077230ULL, 0x000fe40000000000ULL, 0x0000000a06067230ULL, 0x000fe40000000000ULL,
0x0000000905057230ULL, 0x000fc40000000000ULL, 0x0000000804047230ULL, 0x000fe40000000000ULL,
0x0000001b17177230ULL, 0x000fe40000000000ULL, 0x0000001a16167230ULL, 0x000fe20000000000ULL,
0x0000000402007388ULL, 0x000fe20000000c00ULL, 0x0000001915157230ULL, 0x000fe40000000000ULL,
0x0000001814147230ULL, 0x000fe40000000000ULL, 0x000000231f1f7230ULL, 0x000fc40000000000ULL,
0x000000221e1e7230ULL, 0x000fe20000000000ULL, 0x0004001402007388ULL, 0x000fe20000000c00ULL,
0x000000211d1d7230ULL, 0x000fe40000000000ULL, 0x000000201c1c7230ULL, 0x000fe40000000000ULL,
0x0000002b27277230ULL, 0x000fe40000000000ULL, 0x0000002a26267230ULL, 0x000fe20000000000ULL,
0x0008001c02007388ULL, 0x000fe20000000c00ULL, 0x0000002925257230ULL, 0x000fc40000000000ULL,
0x0000002824247230ULL, 0x000fca0000000000ULL, 0x000c002402007388ULL, 0x000fe80000000c00ULL,
0x0000000000007b1dULL, 0x000fec0000000000ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x00000003ff077819ULL, 0x000fc80000011600ULL, 0x000000780700720cULL, 0x000fda0003f06070ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107027824ULL, 0x100fe200078e0200ULL,
0x00000000000479c3ULL, 0x000e620000002700ULL, 0xffffffff00057882ULL, 0x000fe20000000000ULL,
0x0000000112117812ULL, 0x000fe200078ec0ffULL, 0x00005a0000067ab9ULL, 0x000fe20000000800ULL,
0x0000000702057812ULL, 0x000fe200078ec0ffULL, 0x0000000605057299ULL, 0x000fe2000800063fULL,
0x00000007000e7812ULL, 0x000fe400078ec0ffULL, 0x0ffffff805027812ULL, 0x000fe200078ef800ULL,
0x0000580000067ab9ULL, 0x000fc80000000800ULL, 0x0000001002047824ULL, 0x000fe400078e0203ULL,
0x000000207a027824ULL, 0x000fe400078e0207ULL, 0x0000000811077824ULL, 0x000fe200078e020eULL,
0x0000000004087984ULL, 0x0004e40000000c00ULL, 0x0000000502067c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff057a19ULL, 0x000fe20000011602ULL, 0x00000006040472a4ULL, 0x002fc4000f8e023fULL,
0x0000000179067824ULL, 0x000fc800078e0206ULL, 0x0000008405057224ULL, 0x000fe200078e0206ULL,
0x0000002000067810ULL, 0x000fe20007ffe0ffULL, 0x0000000484027c24ULL, 0x000fc6000f8e02ffULL,
0x00000003ff0d7819ULL, 0x000fe40000011606ULL, 0x0000000502057210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0c7224ULL, 0x000fe200000e06ffULL, 0x00005c0005047a11ULL, 0x004fc800078040ffULL,
0x00005d0005057a11ULL, 0x000fe400000f440cULL, 0x000000780d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0083ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000106047824ULL, 0x102fe200078e020dULL,
0x00000040000c7810ULL, 0x000fe20007ffe0ffULL, 0x000000207a0d7824ULL, 0x000fc600078e020dULL,
0x0000000704057812ULL, 0x000fc800078ec0ffULL, 0x0ffffff805047812ULL, 0x000fe400078ef806ULL,
0x0000000706067812ULL, 0x000fc600078ec0ffULL, 0x0000001004077824ULL, 0x000fe200078e0203ULL,
0x000000050d047c12ULL, 0x000fe4000f8e30ffULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL,
0x0000000007087984ULL, 0x0002a20000000c00ULL, 0x0000000179047824ULL, 0x000fc800078e0204ULL,
0x000000840d0d7224ULL, 0x000fe400078e0204ULL, 0x0000000811077824ULL, 0x002fc600078e0206ULL,
0x0000000d020d7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c000d047a11ULL, 0x000fc800078040ffULL, 0x00005d000d057a11ULL, 0x000fe400000f440eULL,
0x00000003ff0d7819ULL, 0x000fc6000001160cULL, 0x0000001007047825ULL, 0x000fe200078e0004ULL,
0x000000780d00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0043f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c047824ULL, 0x102fe400078e020dULL,
0x000000207a0d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050d047c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000179047824ULL, 0x000fc800078e0204ULL,
0x000000840d0d7224ULL, 0x000fca00078e0204ULL, 0x0000000d02057210ULL, 0x000fe40007f1e0ffULL,
0x00000060000d7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x040fe400078040ffULL, 0x00000003ff0f7819ULL, 0x000fe4000001160dULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000780f00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d047824ULL, 0x102fe200078e020fULL,
0x0000008000077810ULL, 0x000fe20007ffe0ffULL, 0x000000207a0f7824ULL, 0x000fc600078e020fULL,
0x0000000704047812ULL, 0x000fc800078ec0ffULL, 0x0ffffff804047812ULL, 0x000fe400078ef80dULL,
0x000000070d0d7812ULL, 0x000fc600078ec0ffULL, 0x0000001004067824ULL, 0x000fe200078e0203ULL,
0x000000050f047c12ULL, 0x000fe2000f8e30ffULL, 0x00000008110d7824ULL, 0x000fe200078e020dULL,
0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL, 0x0000000006087984ULL, 0x000e620000000c00ULL,
0x0000000179047824ULL, 0x000fc800078e0204ULL, 0x000000840f0f7224ULL, 0x000fca00078e0204ULL,
0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c000f047a11ULL, 0x000fc800078040ffULL, 0x00005d000f057a11ULL, 0x000fe400000f440cULL,
0x00000003ff0f7819ULL, 0x000fc60000011607ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x000000780f00720cULL, 0x000fc80003f06070ULL, 0x0000000804007986ULL, 0x0023f2000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x0000000107047824ULL, 0x102fe200078e020fULL,
0x000000a0000c7810ULL, 0x000fe20007ffe0ffULL, 0x000000207a0f7824ULL, 0x000fc600078e020fULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x00000003ff0d7819ULL, 0x000fe4000001160cULL,
0x0ffffff804047812ULL, 0x000fe400078ef807ULL, 0x0000000707077812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050f047c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e0207ULL, 0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000179047824ULL, 0x000fc800078e0204ULL,
0x000000840f0f7224ULL, 0x000fca00078e0204ULL, 0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff0e7224ULL, 0x000fe200000e06ffULL, 0x00005c000f047a11ULL, 0x000fc800078040ffULL,
0x00005d000f057a11ULL, 0x000fe400000f440eULL, 0x000000780d00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010c047824ULL, 0x102fe400078e020dULL,
0x000000207a0d7824ULL, 0x000fc600078e020dULL, 0x0000000704057812ULL, 0x000fc800078ec0ffULL,
0x0ffffff805047812ULL, 0x000fe400078ef80cULL, 0x000000070c0c7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050d047c12ULL, 0x000fe2000f8e30ffULL,
0x0000000811077824ULL, 0x000fe200078e020cULL, 0x00005a00ff0d7a19ULL, 0x000fe4000001160dULL,
0x0000000006087984ULL, 0x000e620000000c00ULL, 0x0000000179047824ULL, 0x000fc800078e0204ULL,
0x000000840d0d7224ULL, 0x000fca00078e0204ULL, 0x0000000d02057210ULL, 0x000fe40007f1e0ffULL,
0x000000c0000d7810ULL, 0x000fc60007ffe0ffULL, 0x000000ffff0e7224ULL, 0x000fe200000e06ffULL,
0x00005c0005047a11ULL, 0x040fe400078040ffULL, 0x00000003ff0f7819ULL, 0x000fe4000001160dULL,
0x00005d0005057a11ULL, 0x000fe400000f440eULL, 0x000000780f00720cULL, 0x000fc60003f06070ULL,
0x0000001007047825ULL, 0x000fca00078e0004ULL, 0x0000000804007986ULL, 0x0023ea000c101d08ULL,
0x000000000000094dULL, 0x000fea0003800000ULL, 0x000000010d047824ULL, 0x102fe200078e020fULL,
0x000000e000007810ULL, 0x000fe20007ffe0ffULL, 0x000000207a0f7824ULL, 0x000fc600078e020fULL,
0x0000000704047812ULL, 0x000fe400078ec0ffULL, 0x00000003ff077819ULL, 0x000fe40000011600ULL,
0x0ffffff804047812ULL, 0x000fe400078ef80dULL, 0x000000070d0d7812ULL, 0x000fc600078ec0ffULL,
0x0000001004067824ULL, 0x000fe200078e0203ULL, 0x000000050f047c12ULL, 0x000fe2000f8e30ffULL,
0x00000008110d7824ULL, 0x000fe200078e020dULL, 0x00005a00ff0f7a19ULL, 0x000fe4000001160fULL,
0x0000000006087984ULL, 0x0002a20000000c00ULL, 0x0000000179047824ULL, 0x000fc800078e0204ULL,
0x000000840f0f7224ULL, 0x000fe400078e0204ULL, 0x0000000100067824ULL, 0x002fc600078e0207ULL,
0x0000000f020f7210ULL, 0x000fca0007f1e0ffULL, 0x000000ffff0c7224ULL, 0x000fe200000e06ffULL,
0x00005c000f047a11ULL, 0x000fc800078040ffULL, 0x00005d000f057a11ULL, 0x000fe400000f440cULL,
0x000000780700720cULL, 0x000fc60003f06070ULL, 0x000000100d047825ULL, 0x000fe200078e0004ULL,
0x00000007060d7812ULL, 0x000fc800078ec0ffULL, 0xfffffff80d067812ULL, 0x000fe200078ef800ULL,
0x0000000804007986ULL, 0x0043e8000c101d08ULL, 0x000000000000094dULL, 0x000fea0003800000ULL,
0x0000001006067824ULL, 0x000fe200078e0203ULL, 0x0000000700007812ULL, 0x000fe200078ec0ffULL,
0x000000207a077824ULL, 0x000fc600078e0207ULL, 0x0000000006087984ULL, 0x002e620000000c00ULL,
0x0000000811057824ULL, 0x000fe200078e0200ULL, 0x0000000507047c12ULL, 0x000fe4000f8e30ffULL,
0x00005a00ff077a19ULL, 0x000fc60000011607ULL, 0x0000000179047824ULL, 0x000fc800078e0204ULL,
0x0000008407077224ULL, 0x000fca00078e0204ULL, 0x0000000702077210ULL, 0x000fca0007f1e0ffULL,
0x000000ffff047224ULL, 0x000fe200000e06ffULL, 0x00005c0007027a11ULL, 0x000fc800078040ffULL,
0x00005d0007037a11ULL, 0x000fca00000f4404ULL, 0x0000001005027825ULL, 0x000fca00078e0002ULL,
0x0000000802007986ULL, 0x002fe2000c101d08ULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x0000000f1200720cULL, 0x000fe20003f06070ULL, 0xffffffffff077424ULL, 0x002fd800078e00ffULL,
0x00000002130b8824ULL, 0x000fc800078e00ffULL, 0x000068000b0b8a24ULL, 0x000fc800078e0212ULL,
0x000064000b0a8625ULL, 0x000fe200078e0006ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x00006c00ff667624ULL, 0x000fe200078e00ffULL, 0x000000080a078981ULL, 0x000ea2000c1e1900ULL,
0x00006d00ff677624ULL, 0x000fc600078e00ffULL, 0x01a60000ff087f8cULL, 0x000e68000c80043fULL,
0x0000000866667981ULL, 0x000722000c1e9900ULL, 0x000001ff0500780cULL, 0x000fe20003f04070ULL,
0x00000040160c7824ULL, 0x000fe400078e00ffULL, 0x0000004012037824ULL, 0x000fe400078e00ffULL,
0x0000004014027824ULL, 0x000fc400078e00ffULL, 0x000000070c2f7224ULL, 0x004fcc00078e02ffULL,
0x00000c9000000947ULL, 0x000fea0003800000ULL, 0x00000003ff327819ULL, 0x00afe40000011611ULL,
0x00000003100a7217ULL, 0x000fe40007800000ULL, 0x0000000432167810ULL, 0x000fe20007ffe0ffULL,
0x0000004014077824ULL, 0x000fe200078e0232ULL, 0x0000000832147810ULL, 0x000fe20007ffe0ffULL,
0x000000010a057824ULL, 0x000fe200078e0a03ULL, 0x000062002f2d7a11ULL, 0x000fe200078438ffULL,
0x00000001160a7824ULL, 0x140fe200078e0211ULL, 0x0000001407187810ULL, 0x000fe20007ffe0ffULL,
0x00000008160d7824ULL, 0x040fe200078e00ffULL, 0x000000051600720cULL, 0x080fe20003f86070ULL,
0x00000001140b7824ULL, 0x000fe200078e0211ULL, 0x0000000c32167810ULL, 0x000fe20007ffe0ffULL,
0x0000000814287824ULL, 0x000fe200078e00ffULL, 0xfffffff80d267812ULL, 0x000fe200078ee20aULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x000000051600720cULL, 0x000fc40003f26070ULL,
0xfffffff828287812ULL, 0x000fe200078ee20bULL, 0x00000080070a7825ULL, 0x040fe200078e00ffULL,
0x000000051400720cULL, 0x000fe40003f06070ULL, 0x0000000407147810ULL, 0x040fe20007ffe0ffULL,
0x00000001160d7824ULL, 0x000fe200078e0211ULL, 0x000000700a1c7812ULL, 0x000fe200078ef804ULL,
0x00000008162a7824ULL, 0x000fe200078e00ffULL, 0x0000000807167810ULL, 0x000fe20007ffe0ffULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000063002f2f7a11ULL, 0x000fc400010f3cffULL,
0x0000001c2d1c7210ULL, 0x000fe20007f5e0ffULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000000c070a7810ULL, 0x000fe40007ffe0ffULL, 0x00000070141e7812ULL, 0x100fe200078ef804ULL,
0x000000010b1d7824ULL, 0x000fe200010e062fULL, 0x0000007016167812ULL, 0x000fe200078ef804ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000002d1e1e7210ULL, 0x080fe40007f7e0ffULL,
0x0000002d16167210ULL, 0x000fc40007f5e0ffULL, 0x000000700a207812ULL, 0x100fe200078ef804ULL,
0x00000001151f7824ULL, 0x100fe200018e062fULL, 0x0000001007147810ULL, 0x000fe20007ffe0ffULL,
0x0000000117177824ULL, 0x100fe200010e062fULL, 0x0000002d20207210ULL, 0x080fe40007f5e0ffULL,
0x00000018071a7810ULL, 0x040fe20007ffe0ffULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0x0000001c070a7810ULL, 0x000fe40007ffe0ffULL, 0x0000007018187812ULL, 0x100fe200078ef804ULL,
0x000000010b217824ULL, 0x000fe200010e062fULL, 0x0000007014227812ULL, 0x000fe200078ef804ULL,
0x00000001320b7824ULL, 0x040fe200078e0211ULL, 0x0000001032147810ULL, 0x000fe20007ffe0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000002d22227210ULL, 0x000fc40007f7e0ffULL,
0x000000070b2c7812ULL, 0x000fe200078ec0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x000000701a1a7812ULL, 0x100fe400078ef804ULL, 0x0000001432247810ULL, 0x000fe20007ffe0ffULL,
0x0000000115237824ULL, 0x000fe200018e062fULL, 0x0000002d18187210ULL, 0x080fe20007fbe0ffULL,
0x0000000114157824ULL, 0x100fe200078e0211ULL, 0x0000002d1a1a7210ULL, 0x000fe20007fde0ffULL,
0x00000008142e7824ULL, 0x000fe200078e00ffULL, 0x000000700a257812ULL, 0x000fe200078ef804ULL,
0x00000001240a7824ULL, 0x100fe200078e0211ULL, 0x000000051400720cULL, 0x080fe20003f46070ULL,
0x0000000824297824ULL, 0x000fe200078e00ffULL, 0x0ffffff82c147812ULL, 0x000fe200078ef811ULL,
0x0000000119197824ULL, 0x100fe200028e062fULL, 0x000000053200720cULL, 0x080fe20003fa6070ULL,
0x000000011b1b7824ULL, 0x000fe200030e062fULL, 0x000000052400720cULL, 0x000fc40003f66070ULL,
0xfffffff82e2c7812ULL, 0x000fe400078ee215ULL, 0xfffffff82a2a7812ULL, 0x000fe400078ee20dULL,
0x0000002d25247210ULL, 0x000fe40007fde0ffULL, 0xfffffff8292e7812ULL, 0x000fe400078ee20aULL,
0x00002000120d7811ULL, 0x000fe200078e70ffULL, 0x000000010b257824ULL, 0x000fe200030e062fULL,
0x00000020070a7810ULL, 0x000fc40007ffe0ffULL, 0x0000001c32307810ULL, 0x000fe20007ffe0ffULL,
0x0000001014277824ULL, 0x100fe200078e020dULL, 0x0000002407147810ULL, 0x000fe20007ffe0ffULL,
0x0000001026297824ULL, 0x000fe200078e020dULL, 0x0000001832267810ULL, 0x000fe20007ffe0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x000000001c277faeULL, 0x0003e4000e901c48ULL, 0x000000052600720cULL, 0x080fe20003fa6070ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000700a2b7812ULL, 0x100fe200078ef804ULL,
0x000000001e297faeULL, 0x0005e2000e101c48ULL, 0x000000053000720cULL, 0x000fe20003f86070ULL,
0x00000001260a7824ULL, 0x100fe200078e0211ULL, 0x0000007014147812ULL, 0x000fe200078ef804ULL,
0x0000000826277824ULL, 0x002fe200078e00ffULL, 0x0000002d2b1c7210ULL, 0x000fe20007fde0ffULL,
0x0000000130267824ULL, 0x000fc400078e0211ULL, 0x00000008301f7824ULL, 0x004fe200078e00ffULL,
0xfffffff8271e7812ULL, 0x000fe200078ee20aULL, 0x000000010b1d7824ULL, 0x000fe200030e062fULL,
0x00000028070a7810ULL, 0x000fe20007ffe0ffULL, 0x000000102a277824ULL, 0x100fe200078e020dULL,
0xfffffff81f267812ULL, 0x000fe200078ee226ULL, 0x00000010281f7824ULL, 0x000fe200078e020dULL,
0x0000002032287810ULL, 0x000fe20007ffe0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0x0000002d14147210ULL, 0x000fe40007fde0ffULL, 0x00000024322a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000128297824ULL, 0x000fe200078e0211ULL, 0x000000700a0a7812ULL, 0x000fe200078ef804ULL,
0x0000000828307824ULL, 0x040fe200078e00ffULL, 0x00000000161f7faeULL, 0x0003e2000c101c48ULL,
0x000000052800720cULL, 0x000fe20003f06070ULL, 0x0000000115157824ULL, 0x000fc400030e062fULL,
0x000000012a287824ULL, 0x040fe200078e0211ULL, 0x0000000020277faeULL, 0x0005e2000c901c48ULL,
0x000000052a00720cULL, 0x040fe20003f26070ULL, 0x000000082a177824ULL, 0x002fe200078e00ffULL,
0x0000002d0a167210ULL, 0x000fe20007fde0ffULL, 0x000000102c1f7824ULL, 0x000fe200078e020dULL,
0xfffffff8300a7812ULL, 0x000fe400078ee229ULL, 0xfffffff817287812ULL, 0x000fe200078ee228ULL,
0x000000010b177824ULL, 0x000fe200030e062fULL, 0x00000000221f7faeULL, 0x0003e2000d101c48ULL,
0x000000102e0b7824ULL, 0x100fe200078e020dULL, 0x0000002c32207810ULL, 0x004fe20007ffe0ffULL,
0x000000100a297824ULL, 0x100fe200078e020dULL, 0x0000002c070a7810ULL, 0x000fe20007ffe0ffULL,
0x000000101e217824ULL, 0x100fe200078e020dULL, 0x00000000180b7faeULL, 0x0005e2000d901c48ULL,
0x0000001026277824ULL, 0x100fe200078e020dULL, 0x00000028321e7810ULL, 0x000fe20007ffe0ffULL,
0x00000010282b7824ULL, 0x000fe200078e020dULL, 0x000000001a217faeULL, 0x0007e2000e901c48ULL,
0x0000003432267810ULL, 0x000fc40007ffe0ffULL, 0x0000003032227810ULL, 0x042fe20007ffe0ffULL,
0x0000000024277faeULL, 0x0003e2000e101c48ULL, 0x0000003832287810ULL, 0x040fe40007ffe0ffULL,
0x0000003c322a7810ULL, 0x000fe20007ffe0ffULL, 0x000000800a0a7825ULL, 0x004fe200078e00ffULL,
0x000000001c297faeULL, 0x0005e2000c101c48ULL, 0x000000052000720cULL, 0x040fe40003f86070ULL,
0x00000001201b7824ULL, 0x008fe200078e0211ULL, 0x000000700a187812ULL, 0x000fe200078ef804ULL,
0x00000000142b7faeULL, 0x0007e2000c901c48ULL, 0x00000030070a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000820207824ULL, 0x000fe200078e00ffULL, 0x0000002d18187210ULL, 0x000fe20007fde0ffULL,
0x0000000826247824ULL, 0x002fe200078e00ffULL, 0x000000052200720cULL, 0x0c0fe20003f66070ULL,
0x00000008221d7824ULL, 0x004fe200078e00ffULL, 0x000000051e00720cULL, 0x080fe20003fa6070ULL,
0x000000010b197824ULL, 0x000fe200030e062fULL, 0x000000052600720cULL, 0x000fe20003f46070ULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000003407147810ULL, 0x008fc40007ffe0ffULL,
0x000000052800720cULL, 0x080fe40003f26070ULL, 0x000000700a1a7812ULL, 0x000fe200078ef804ULL,
0x00000001220a7824ULL, 0x100fe200078e0211ULL, 0x000000052a00720cULL, 0x000fe20003f06070ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x0000002d1a1a7210ULL, 0x080fe40007fde0ffULL,
0xfffffff81d227812ULL, 0x000fe200078ee20aULL, 0x000000011e057824ULL, 0x040fe200078e0211ULL,
0x00000038070a7810ULL, 0x000fe20007ffe0ffULL, 0x000000081e1e7824ULL, 0x000fe200078e00ffULL,
0x00000070141c7812ULL, 0x000fe200078ef804ULL, 0x00000010221f7824ULL, 0x000fe200078e020dULL,
0xfffffff820207812ULL, 0x000fe200078ee21bULL, 0x000000010b1b7824ULL, 0x000fe200030e062fULL,
0x0000002d1c1c7210ULL, 0x000fe20007fde0ffULL, 0x000000800a0a7825ULL, 0x000fe200078e00ffULL,
0xfffffff81e1e7812ULL, 0x000fc400078ee205ULL, 0x0000003c07147810ULL, 0x000fe20007ffe0ffULL,
0x0000000126057824ULL, 0x000fe200078e0211ULL, 0x000000700a0a7812ULL, 0x100fe200078ef804ULL,
0x00000001151d7824ULL, 0x000fe400030e062fULL, 0x0000008014147825ULL, 0x000fe200078e00ffULL,
0xfffffff824247812ULL, 0x000fe400078ee205ULL, 0x0000002d0a0a7210ULL, 0x000fe20007fde0ffULL,
0x0000000128057824ULL, 0x000fe200078e0211ULL, 0x0000007014047812ULL, 0x000fe200078ef804ULL,
0x0000000828287824ULL, 0x000fc400078e00ffULL, 0x000000012a117824ULL, 0x040fe400078e0211ULL,
0x000000082a267824ULL, 0x000fe200078e00ffULL, 0xfffffff828147812ULL, 0x000fe200078ee205ULL,
0x000000010b0b7824ULL, 0x000fe200030e062fULL, 0x0000002d04047210ULL, 0x000fe20007fde0ffULL,
0x000000101e077824ULL, 0x000fe200078e020dULL, 0xfffffff826267812ULL, 0x000fe200078ee211ULL,
0x0000001020117824ULL, 0x100fe400078e020dULL, 0x0000001024217824ULL, 0x100fe200078e020dULL,
0x0000000016077faeULL, 0x0003e2000e901c48ULL, 0x0000001014237824ULL, 0x000fc400078e020dULL,
0x00000010260d7824ULL, 0x000fe200078e020dULL, 0x0000000018117faeULL, 0x0003e2000e101c48ULL,
0x0000000115057824ULL, 0x000fc600030e062fULL, 0x000000001a1f7faeULL, 0x0003e8000d901c48ULL,
0x000000001c217faeULL, 0x0003e8000d101c48ULL, 0x000000000a237faeULL, 0x0003e8000c901c48ULL,
0x00000000040d7faeULL, 0x0003e2000c101c48ULL, 0x00000b5000007947ULL, 0x000fea0003800000ULL,
0x00000004110b7811ULL, 0x04afe400078fe8ffULL, 0x0000000c11177811ULL, 0x000fc400078fe8ffULL,
0x0000000811157811ULL, 0x000fe200078fe8ffULL, 0x000000010b057824ULL, 0x100fe200078e0211ULL,
0x00000010111a7811ULL, 0x000fe200078fe8ffULL, 0x000000080b0a7824ULL, 0x000fe200078e00ffULL,
0x00000018111c7811ULL, 0x000fe200078fe8ffULL, 0x0000000117077824ULL, 0x000fe200078e0211ULL,
0x00000014111b7811ULL, 0x000fe200078fe8ffULL, 0x0000000817167824ULL, 0x000fe200078e00ffULL,
0xfffffff80a0d7812ULL, 0x000fe200078ee205ULL, 0x0000000115057824ULL, 0x000fe200078e0211ULL,
0x0000001c111e7811ULL, 0x000fe200078fe8ffULL, 0x0000000815147824ULL, 0x000fe200078e00ffULL,
0xfffffff816167812ULL, 0x000fe200078ee207ULL, 0x000000011a0a7824ULL, 0x040fe200078e0211ULL,
0x0000002411327811ULL, 0x040fe200078fe8ffULL, 0x000000081a197824ULL, 0x000fe200078e00ffULL,
0xfffffff814147812ULL, 0x000fe200078ee205ULL, 0x000000011c077824ULL, 0x140fe200078e0211ULL,
0x0000002011287811ULL, 0x000fe200078fe8ffULL, 0x000000081c227824ULL, 0x000fe200078e00ffULL,
0xfffffff819187812ULL, 0x000fe200078ee20aULL, 0x000000011b057824ULL, 0x000fe200078e0211ULL,
0x0000002811347811ULL, 0x000fe200078fe8ffULL, 0x000000081b207824ULL, 0x000fe200078e00ffULL,
0xfffffff8221d7812ULL, 0x000fe200078ee207ULL, 0x000000011e0a7824ULL, 0x040fe200078e0211ULL,
0x0000002c11367811ULL, 0x040fe200078fe8ffULL, 0x000000081e1f7824ULL, 0x000fe200078e00ffULL,
0xfffffff820197812ULL, 0x000fe200078ee205ULL, 0x0000000132077824ULL, 0x140fe200078e0211ULL,
0x00000034113a7811ULL, 0x000fe200078fe8ffULL, 0x0000000832227824ULL, 0x000fe200078e00ffULL,
0xfffffff81f1f7812ULL, 0x000fe200078ee20aULL, 0x0000000128057824ULL, 0x040fe200078e0211ULL,
0x0000003011387811ULL, 0x040fe200078fe8ffULL, 0x0000000828207824ULL, 0x000fe200078e00ffULL,
0xfffffff822217812ULL, 0x000fe200078ee207ULL, 0x00000001340a7824ULL, 0x040fe200078e0211ULL,
0x00000038113c7811ULL, 0x040fe200078fe8ffULL, 0x0000000834237824ULL, 0x000fe200078e00ffULL,
0xfffffff820207812ULL, 0x000fe200078ee205ULL, 0x0000000136057824ULL, 0x100fe200078e0211ULL,
0x0000003c113e7811ULL, 0x000fe200078fe8ffULL, 0x000000083a257824ULL, 0x000fe200078e00ffULL,
0xfffffff823227812ULL, 0x000fe200078ee20aULL, 0x00000008360a7824ULL, 0x000fe200078e00ffULL,
0x00002000122a7811ULL, 0x000fe200078e70ffULL, 0x0000000138077824ULL, 0x040fe200078e0211ULL,
0x000062002f4d7a11ULL, 0x000fe200078038ffULL, 0x0000000838247824ULL, 0x000fe200078e00ffULL,
0xfffffff80a237812ULL, 0x000fe200078ee205ULL, 0x000000013a0a7824ULL, 0x100fe200078e0211ULL,
0x0000001111057211ULL, 0x000fe200078fe8ffULL, 0x000000013e277824ULL, 0x000fe200078e0211ULL,
0xfffffff824247812ULL, 0x000fe200078ee207ULL, 0x000000013c077824ULL, 0x140fe200078e0211ULL,
0xfffffff825257812ULL, 0x000fe200078ee20aULL, 0x000000083c267824ULL, 0x000fe200078e00ffULL,
0x00000007050a7812ULL, 0x000fe200078ec0ffULL, 0x0000001016337824ULL, 0x100fe200078e022aULL,
0x000063002f4f7a11ULL, 0x000fe200000f3cffULL, 0x0000001018357824ULL, 0x100fe200078e022aULL,
0x0ffffff80a057812ULL, 0x000fe200078ef811ULL, 0x0000000102167824ULL, 0x000fe200078e0215ULL,
0x00000002110a7211ULL, 0x000fe200078fe8ffULL, 0x0000001014117824ULL, 0x000fe200078e022aULL,
0xfffffff826267812ULL, 0x000fe200078ee207ULL, 0x0000000102147824ULL, 0x000fc400078e020bULL,
0x000000800a0a7825ULL, 0x000fc800078e00ffULL, 0x00000010203d7824ULL, 0x000fe200078e022aULL,
0x000000700a207812ULL, 0x000fe200078ef804ULL, 0x0000000102187824ULL, 0x000fe400078e0217ULL,
0x0000008014147825ULL, 0x000fe200078e00ffULL, 0x000000204d207210ULL, 0x000fc60007f1e0ffULL,
0x0000001019377824ULL, 0x000fe400078e022aULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000008018187825ULL, 0x000fc800078e00ffULL, 0x0000001022417824ULL, 0x000fe200078e022aULL,
0x0000007014227812ULL, 0x000fe200078ef804ULL, 0x000000083e2c7824ULL, 0x000fe400078e00ffULL,
0x0000001024457824ULL, 0x000fe200078e022aULL, 0x0000007016247812ULL, 0x000fe200078ef804ULL,
0x00000001020a7824ULL, 0x000fe200078e021aULL, 0x000000224d227210ULL, 0x000fe20007f3e0ffULL,
0x0000001026497824ULL, 0x000fe200078e022aULL, 0x0000007018267812ULL, 0x000fe200078ef804ULL,
0x00000010213f7824ULL, 0x000fe200078e022aULL, 0xfffffff82c277812ULL, 0x000fe200078ee227ULL,
0x000000010b217824ULL, 0x000fe200000e064fULL, 0x000000244d247210ULL, 0x040fe20007f1e0ffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x000000264d267210ULL, 0x000fc60007f5e0ffULL,
0x0000000102147824ULL, 0x000fe200078e021bULL, 0x000000700a297812ULL, 0x000fe200078ef804ULL,
0x0000000102167824ULL, 0x040fe400078e021cULL, 0x0000001023437824ULL, 0x000fe400078e022aULL,
0x0000000102187824ULL, 0x000fe400078e021eULL, 0x0000001025477824ULL, 0x000fe400078e022aULL,
0x0000000115237824ULL, 0x000fc400008e064fULL, 0x00000001021a7824ULL, 0x000fe400078e0228ULL,
0x00000010274b7824ULL, 0x000fe400078e022aULL, 0x0000000117257824ULL, 0x000fe200000e064fULL,
0x000000294d287210ULL, 0x000fe20007f1e0ffULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x0000000119277824ULL, 0x000fe400010e064fULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x00000070162c7812ULL, 0x000fc600078ef804ULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x00000070182e7812ULL, 0x000fe400078ef804ULL,
0x0000002c4d2c7210ULL, 0x000fe20007f3e0ffULL, 0x0000001005077824ULL, 0x000fe200078e022aULL,
0x000000701a307812ULL, 0x000fe200078ef804ULL, 0x000000100d0d7824ULL, 0x100fe200078e022aULL,
0x0000002e4d2e7210ULL, 0x000fe20007f5e0ffULL, 0x000000101d397824ULL, 0x100fe200078e022aULL,
0x000000304d307210ULL, 0x000fe20007f7e0ffULL, 0x000000101f3b7824ULL, 0x000fe200078e022aULL,
0x00000070142a7812ULL, 0x000fe200078ef804ULL, 0x000000010b297824ULL, 0x000fe200000e064fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000020077faeULL, 0x0003e2000b901c48ULL,
0x00000001020a7824ULL, 0x040fe200078e0232ULL, 0x0000002a4d2a7210ULL, 0x000fe20007f1e0ffULL,
0x0000000102147824ULL, 0x040fe200078e0234ULL, 0x00000000220d7faeULL, 0x0003e2000b901c48ULL,
0x0000000102167824ULL, 0x000fc400078e0236ULL, 0x0000000102187824ULL, 0x040fe200078e0238ULL,
0x0000000024117faeULL, 0x0003e2000b901c48ULL, 0x00000001152b7824ULL, 0x000fe400000e064fULL,
0x00000001021a7824ULL, 0x000fe200078e023aULL, 0x0000000026337faeULL, 0x0003e2000b901c48ULL,
0x000000800a0a7825ULL, 0x000fc600078e00ffULL, 0x0000000028357faeULL, 0x0003e2000b901c48ULL,
0x00000001172d7824ULL, 0x000fe200008e064fULL, 0x000000700a057812ULL, 0x000fe200078ef804ULL,
0x00000001021c7824ULL, 0x000fe200078e023cULL, 0x000000002a377faeULL, 0x0003e2000b901c48ULL,
0x0000008014147825ULL, 0x000fc600078e00ffULL, 0x000000002c397faeULL, 0x0003e2000b901c48ULL,
0x00000001192f7824ULL, 0x100fe200010e064fULL, 0x00000070140a7812ULL, 0x000fe200078ef804ULL,
0x00000001021e7824ULL, 0x000fe400078e023eULL, 0x0000008016167825ULL, 0x000fe200078e00ffULL,
0x0000000a4d0a7210ULL, 0x000fe20007f3e0ffULL, 0x000000002e3b7faeULL, 0x0003e4000b901c48ULL,
0x000000011b317824ULL, 0x000fe200018e064fULL, 0x0000007016147812ULL, 0x000fe200078ef804ULL,
0x0000008018187825ULL, 0x000fc600078e00ffULL, 0x000000144d147210ULL, 0x040fe20007f5e0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000007018167812ULL, 0x100fe200078ef804ULL,
0x00000000303d7faeULL, 0x0003e4000b901c48ULL, 0x000000801c1c7825ULL, 0x000fe200078e00ffULL,
0x000000701a187812ULL, 0x100fe400078ef804ULL, 0x000000164d167210ULL, 0x000fe20007f7e0ffULL,
0x000000801e1e7825ULL, 0x000fe200078e00ffULL, 0x000000701c1a7812ULL, 0x000fc400078ef804ULL,
0x000000184d187210ULL, 0x040fe40007f9e0ffULL, 0x000000701e1c7812ULL, 0x000fe400078ef804ULL,
0x000000054d047210ULL, 0x040fe40007f1e0ffULL, 0x0000001a4d1a7210ULL, 0x040fe40007fbe0ffULL,
0x0000001c4d1c7210ULL, 0x000fe20007fde0ffULL, 0x000000010b057824ULL, 0x100fe400000e064fULL,
0x00000001150b7824ULL, 0x000fc400008e064fULL, 0x0000000117157824ULL, 0x100fe200010e064fULL,
0x00000000043f7faeULL, 0x0003e2000b901c48ULL, 0x0000000119177824ULL, 0x100fe400018e064fULL,
0x000000011b197824ULL, 0x100fe200020e064fULL, 0x000000000a417faeULL, 0x0003e2000b901c48ULL,
0x000000011d1b7824ULL, 0x100fe400028e064fULL, 0x000000011f1d7824ULL, 0x000fe200030e064fULL,
0x0000000014437faeULL, 0x0003e8000b901c48ULL, 0x0000000016457faeULL, 0x0003e8000b901c48ULL,
0x0000000018477faeULL, 0x0003e8000b901c48ULL, 0x000000001a497faeULL, 0x0003e8000b901c48ULL,
0x000000001c4b7faeULL, 0x0003e4000b901c48ULL, 0x00000004125c7810ULL, 0x000fe20007ffe0ffULL,
0xffffffffff0d7424ULL, 0x002fe200078e00ffULL, 0x00000000000079afULL, 0x000e240000000000ULL,
0x0000000f5c00720cULL, 0x000fda0003f06070ULL, 0x0000000213078824ULL, 0x000fc800078e00ffULL,
0x0000680007078a24ULL, 0x000fc800078e025cULL, 0x0000640007068625ULL, 0x000fca00078e0006ULL,
0x00000008060d8981ULL, 0x000324000c1e1900ULL, 0x0000000000047805ULL, 0x000fc40000015200ULL,
0x01a60400ff077984ULL, 0x002e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff20000000000ULL, 0x000001e000007945ULL, 0x000fe20003800000ULL,
0x000000ffff0a7224ULL, 0x000fe200078e00ffULL, 0x000001b000000947ULL, 0x000fea0003800000ULL,
0x000000100a00780cULL, 0x000fe20003f06270ULL, 0x0000000000007946ULL, 0x000fe20003800000ULL,
0x0000014000017945ULL, 0x000ff60003800000ULL, 0x0000011000008947ULL, 0x000fea0003800000ULL,
0x0000000000067805ULL, 0x000fcc0000015200ULL, 0x00000006040b7210ULL, 0x000fca0007f1e1ffULL,
0x0000000107077824ULL, 0x000fe200000e0e05ULL, 0x003d09000b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000002000008947ULL, 0x000fea0003800000ULL,
0x000f42400000795dULL, 0x000fe20003800000ULL, 0x000000a000007947ULL, 0x000fea0003800000ULL,
0x00009c400b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x0000001fff067819ULL, 0x000fc80000011407ULL,
0x0000000b06067211ULL, 0x000fca00078110ffULL, 0x000000ffff077224ULL, 0x000fca00000e0607ULL,
0x0000000206067819ULL, 0x000fc80000001207ULL, 0x000000060000735dULL, 0x000fe20003800000ULL,
0x0000001000007947ULL, 0x000fea0003800000ULL, 0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL,
0x0000000000017941ULL, 0x000fea0003800000ULL, 0x01a60400ff077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff60000000000ULL,
0xfffffe5000008947ULL, 0x000fea000383ffffULL, 0x0000000000007941ULL, 0x000fea0003800000ULL,
0x0000000000057919ULL, 0x000e640000000000ULL, 0x0000002012047824ULL, 0x002fca00078e0205ULL,
0x00000004ff057819ULL, 0x000fe40000011604ULL, 0x0000000104067810ULL, 0x040fe40007ffe0ffULL,
0x0ffffffe05077812ULL, 0x000fe400078ec0ffULL, 0x0000001f04057812ULL, 0x000fc600078ec0ffULL,
0x0000000107097824ULL, 0x040fe400078e0206ULL, 0x0000000104087824ULL, 0x000fe200078e0207ULL,
0x0000000807077810ULL, 0x000fe20007ffe0ffULL, 0x00000010050a7824ULL, 0x000fe200078e00ffULL,
0x0000000f09097812ULL, 0x000fe200078ec0ffULL, 0x00000010050b7824ULL, 0x000fe200078e00ffULL,
0x0000000f08087812ULL, 0x000fe200078ec0ffULL, 0x0000000106067824ULL, 0x000fe200078e0207ULL,
0x000001f00a097812ULL, 0x000fe200078ee209ULL, 0x0000000104047824ULL, 0x000fe200078e0207ULL,
0x000001f00b087812ULL, 0x000fe200078ee208ULL, 0x0000001005077824ULL, 0x040fe200078e00ffULL,
0x0000000f06067812ULL, 0x000fe200078ec0ffULL, 0x0000000009147984ULL, 0x000e62000000cc00ULL,
0x0000001005057824ULL, 0x000fe200078e00ffULL, 0x0000000f04047812ULL, 0x000fc400078ec0ffULL,
0x0000000008187984ULL, 0x000ea4000000cc00ULL, 0x000001f005067812ULL, 0x000fe400078ee206ULL,
0x000001f007047812ULL, 0x000fe200078ee204ULL, 0x000000ffff1e7224ULL, 0x002fe400078e0014ULL,
0x000000ffff1f7224ULL, 0x000fe400078e0016ULL, 0x000000ffff1c7224ULL, 0x004fe400078e0018ULL,
0x000000ffff1d7224ULL, 0x000fc400078e001aULL, 0x000000ffff227224ULL, 0x000fe400078e0015ULL,
0x000000ffff237224ULL, 0x000fe200078e0017ULL, 0x0000001c08007388ULL, 0x000fe2000000cc00ULL,
0x000000ffff207224ULL, 0x000fe400078e0019ULL, 0x000000ffff217224ULL, 0x000fca00078e001bULL,
0x0000002009007388ULL, 0x000fe8000000cc00ULL, 0x0000000006147984ULL, 0x000e68000000cc00ULL,
0x0000000004187984ULL, 0x000ea2000000cc00ULL, 0x000000ffff277224ULL, 0x002fe400078e0016ULL,
0x000000ffff267224ULL, 0x000fc400078e0014ULL, 0x000000ffff167224ULL, 0x000fe400078e0015ULL,
0x000000ffff247224ULL, 0x004fe400078e0018ULL, 0x000000ffff257224ULL, 0x000fe400078e001aULL,
0x000000ffff147224ULL, 0x000fe400078e0019ULL, 0x000000ffff157224ULL, 0x000fe200078e001bULL,
0x0000002404007388ULL, 0x0003e8000000cc00ULL, 0x0000001406007388ULL, 0x0003e2000000cc00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x01a60000ff087f8cULL, 0x000ea2000c80043fULL,
0x000000ffff0a7224ULL, 0x000fc600078e00ffULL, 0x0000000000047805ULL, 0x002fc80000015200ULL,
0x01a60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x006fc40007804809ULL,
0x0000000000007918ULL, 0x000ff40000000000ULL, 0x000001d000007945ULL, 0x000fe20003800000ULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x01a60400ff077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x000000ff0e00720cULL, 0x000fda0003f05270ULL,
0x000000000000894dULL, 0x000fea0003800000ULL, 0x0000000000117919ULL, 0x000e620000000000ULL,
0x00005800ff607624ULL, 0x000fe200078e00ffULL, 0x80005800105f7a10ULL, 0x000fe20007ffe0ffULL,
0x0000680013137a24ULL, 0x000fe200078e02ffULL, 0x0000010003657810ULL, 0x000fe20007ffe0ffULL,
0x3db504f366667820ULL, 0x010fe20000410000ULL, 0x0000001f60047810ULL, 0x040fe20007ffe0ffULL,
0x000000ffff627224ULL, 0x000fe200078e00ffULL, 0xffffffff60617810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff677224ULL, 0x000fe200078e00ffULL, 0x00000004ff047819ULL, 0x000fc40000011604ULL,
0x0001a68812647811ULL, 0x040fe400078e18ffULL, 0x0001a60812637811ULL, 0x000fe400078e28ffULL,
0x0000000960607810ULL, 0x000fe40007ffe0ffULL, 0x00000008ff5f7819ULL, 0x000fe4000001165fULL,
0x0ffffffe045e7812ULL, 0x000fc400078ec0ffULL, 0x0000000262057810ULL, 0x000fe20007ffe0ffULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000000d0c237224ULL, 0x010fe200078e02ffULL,
0x00000001675d7812ULL, 0x000fc400078e0cffULL, 0x0000000e0500720cULL, 0x000fda0003f06070ULL,
0x00000cd000008947ULL, 0x00cfea0003800000ULL, 0x00000003ff1e7819ULL, 0x002fe20000011611ULL,
0x0000010062057824ULL, 0x000fe200078e0265ULL, 0x0000620023217a11ULL, 0x000fe200078438ffULL,
0x00000002121c7824ULL, 0x000fe200078e025dULL, 0x000000041e067810ULL, 0x000fe40007ffe0ffULL,
0x0000000510047217ULL, 0x000fe40007800000ULL, 0x000000101e1a7810ULL, 0x000fe20007ffe0ffULL,
0x0000000106077824ULL, 0x000fe200078e0211ULL, 0x0000000c1e187810ULL, 0x000fe20007ffe0ffULL,
0x00000008060a7824ULL, 0x000fe200078e00ffULL, 0x000000081e087810ULL, 0x000fe20007ffe0ffULL,
0x00000001040d7824ULL, 0x000fe200078e0a05ULL, 0x000000141e207810ULL, 0x000fe20007ffe0ffULL,
0x000000011a057824ULL, 0x000fe200078e0211ULL, 0xfffffff80a1d7812ULL, 0x000fe200078ee207ULL,
0x000000081a0a7824ULL, 0x000fe200078e00ffULL, 0x000000181e227810ULL, 0x000fe20007ffe0ffULL,
0x0000000118047824ULL, 0x000fe200078e0211ULL, 0x0000001c1e247810ULL, 0x000fe20007ffe0ffULL,
0x0000000818277824ULL, 0x000fe200078e00ffULL, 0xfffffff80a297812ULL, 0x000fe200078ee205ULL,
0x0000001011057824ULL, 0x000fe200078e00ffULL, 0x0000000d0600720cULL, 0x080fe20003f26070ULL,
0x0000000108097824ULL, 0x140fe200078e0211ULL, 0xfffffff827277812ULL, 0x000fe200078ee204ULL,
0x0000000808147824ULL, 0x000fe200078e00ffULL, 0x0000007005257812ULL, 0x000fe200078ec0ffULL,
0x0000000102047824ULL, 0x000fe200078e021eULL, 0x0000000d0800720cULL, 0x000fe20003f06070ULL,
0x0000000120077824ULL, 0x000fe200078e0211ULL, 0xfffffff8141f7812ULL, 0x000fe200078ee209ULL,
0x0000008004047825ULL, 0x000fe200078e00ffULL, 0x0000630023237a11ULL, 0x000fc400010f3cffULL,
0x000000201e267810ULL, 0x000fe20007ffe0ffULL, 0x0000000820147824ULL, 0x000fe200078e00ffULL,
0x00000025040a7212ULL, 0x000fe200078efcffULL, 0x0000000102067824ULL, 0x000fe200078e0206ULL,
0x0000000d1a00720cULL, 0x000fe20003fa6070ULL, 0x0000000122097824ULL, 0x000fe200078e0211ULL,
0xfffffff8142b7812ULL, 0x000fe200078ee207ULL, 0x0000000822167824ULL, 0x000fe200078e00ffULL,
0x0000000a210a7210ULL, 0x000fe20007f5e0ffULL, 0x00000001240b7824ULL, 0x000fe200078e0211ULL,
0x000020001c1c7811ULL, 0x000fe200078e68ffULL, 0x0000000824047824ULL, 0x000fe200078e00ffULL,
0xfffffff8162d7812ULL, 0x000fe200078ee209ULL, 0x0000000102087824ULL, 0x000fc400078e0208ULL,
0x0000008006067825ULL, 0x000fe200078e00ffULL, 0xfffffff8042f7812ULL, 0x000fc600078ee20bULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000002506147212ULL, 0x000fc600078efcffULL,
0x0000000102047824ULL, 0x000fe200078e0218ULL, 0x0000002508167212ULL, 0x000fe200078efcffULL,
0x00000001050b7824ULL, 0x000fe200010e0623ULL, 0x0000002114147210ULL, 0x080fe20007f7e0ffULL,
0x0000008004047825ULL, 0x000fe200078e00ffULL, 0x0000002116167210ULL, 0x000fe40007f9e0ffULL,
0x0000000d1800720cULL, 0x000fe20003f46070ULL, 0x0000000102067824ULL, 0x000fe200078e021aULL,
0x0000002504187212ULL, 0x000fe200078efcffULL, 0x000000011e087824ULL, 0x000fc400078e0211ULL,
0x0000000107157824ULL, 0x000fe200018e0623ULL, 0x0000000d1e00720cULL, 0x000fe20003f66070ULL,
0x0000000126197824ULL, 0x000fe200078e0211ULL, 0x0000000708087812ULL, 0x000fe200078ec0ffULL,
0x0000000826047824ULL, 0x000fe400078e00ffULL, 0x0000008006067825ULL, 0x000fc600078e00ffULL,
0xfffffff804317812ULL, 0x000fe200078ee219ULL, 0x0000000109177824ULL, 0x000fe200020e0623ULL,
0x0000002118187210ULL, 0x000fe20007f9e0ffULL, 0x0000000102047824ULL, 0x000fe200078e0220ULL,
0x00000025061a7212ULL, 0x000fe200078efcffULL, 0x0000000102067824ULL, 0x000fe200078e0222ULL,
0x0ffffff808097812ULL, 0x000fe200078ef811ULL, 0x0000000105197824ULL, 0x000fe200020e0623ULL,
0x000000211a1a7210ULL, 0x000fe20007fde0ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x0000000d2000720cULL, 0x000fc40003f86070ULL, 0x000000241e207810ULL, 0x000fe20007ffe0ffULL,
0x0000001009097824ULL, 0x100fe200078e021cULL, 0x0000002504047212ULL, 0x000fe200078efcffULL,
0x00000001071b7824ULL, 0x000fe400030e0623ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x000000000a097faeULL, 0x0003e2000d901c48ULL,
0x0000000d2200720cULL, 0x000fe40003f66070ULL, 0x000000101d1d7824ULL, 0x000fe400078e021cULL,
0x0000000102087824ULL, 0x000fc400078e0224ULL, 0x0000000120227824ULL, 0x040fe200078e0211ULL,
0x00000000141d7faeULL, 0x0005e2000c901c48ULL, 0x0000000820337824ULL, 0x000fe200078e00ffULL,
0x0000000d2400720cULL, 0x000fe40003f26070ULL, 0x00000021040a7210ULL, 0x002fe20007fde0ffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x0000002506047212ULL, 0x080fe400078efcffULL,
0xfffffff833337812ULL, 0x000fe200078ee222ULL, 0x00000001050b7824ULL, 0x100fe200030e0623ULL,
0x0000002508087212ULL, 0x000fe200078efcffULL, 0x0000000102067824ULL, 0x000fe200078e0220ULL,
0x0000002104147210ULL, 0x084fe20007fde0ffULL, 0x0000000102047824ULL, 0x000fe200078e0226ULL,
0x000000281e227810ULL, 0x040fe20007ffe0ffULL, 0x000000101f1d7824ULL, 0x000fe200078e021cULL,
0x0000002c1e247810ULL, 0x000fe20007ffe0ffULL, 0x0000000107157824ULL, 0x000fe200030e0623ULL,
0x0000002108087210ULL, 0x000fe20007fde0ffULL, 0x0000008004047825ULL, 0x000fe200078e00ffULL,
0x00000000161d7faeULL, 0x0003e2000c101c48ULL, 0x0000000d2600720cULL, 0x000fc40003f06070ULL,
0x0000001027077824ULL, 0x100fe400078e021cULL, 0x0000000109097824ULL, 0x000fe400030e0623ULL,
0x00000008241f7824ULL, 0x000fe200078e00ffULL, 0x0000000018077faeULL, 0x0005e2000d101c48ULL,
0x0000000d2000720cULL, 0x000fe20003f46070ULL, 0x0000000822207824ULL, 0x000fe200078e00ffULL,
0x0000002504167212ULL, 0x002fe200078efcffULL, 0x0000000122177824ULL, 0x100fe400078e0211ULL,
0x0000000124047824ULL, 0x000fe200078e0211ULL, 0x0000002116167210ULL, 0x000fe20007fde0ffULL,
0x00000010291d7824ULL, 0x000fe200078e021cULL, 0xfffffff820277812ULL, 0x000fc400078ee217ULL,
0xfffffff81f297812ULL, 0x000fe200078ee204ULL, 0x0000000105177824ULL, 0x000fe200030e0623ULL,
0x000000301e207810ULL, 0x000fe20007ffe0ffULL, 0x0000008006047825ULL, 0x000fe200078e00ffULL,
0x000000001a1d7faeULL, 0x0003e2000e901c48ULL, 0x0000000d2200720cULL, 0x000fe40003fa6070ULL,
0x0000000102067824ULL, 0x000fe200078e0222ULL, 0x0000002504187212ULL, 0x004fe200078efcffULL,
0x0000000102047824ULL, 0x000fe400078e0224ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000002118187210ULL, 0x000fc60007fde0ffULL, 0x000000102b1f7824ULL, 0x100fe200078e021cULL,
0x0000002506067212ULL, 0x000fe200078efcffULL, 0x0000000105197824ULL, 0x000fe400030e0623ULL,
0x0000008004047825ULL, 0x000fe200078e00ffULL, 0x000000000a1f7faeULL, 0x0005e2000e101c48ULL,
0x0000000d2400720cULL, 0x000fe40003f86070ULL, 0x000000102d1d7824ULL, 0x002fe200078e021cULL,
0x00000025041a7212ULL, 0x000fe200078efcffULL, 0x00000001201b7824ULL, 0x000fe200078e0211ULL,
0x000000341e047810ULL, 0x000fe20007ffe0ffULL, 0x0000000820227824ULL, 0x040fe200078e00ffULL,
0x00000000141d7faeULL, 0x0003e2000d901c48ULL, 0x0000000d2000720cULL, 0x000fc40003f66070ULL,
0x00000021060a7210ULL, 0x084fe20007fde0ffULL, 0x0000000102067824ULL, 0x000fe200078e0220ULL,
0xfffffff8222b7812ULL, 0x000fe200078ee21bULL, 0x000000102f1f7824ULL, 0x000fe200078e021cULL,
0x000000381e207810ULL, 0x000fe20007ffe0ffULL, 0x00000001070b7824ULL, 0x100fe200030e0623ULL,
0x000000211a1a7210ULL, 0x000fe20007fde0ffULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x00000000081f7faeULL, 0x0005e2000c901c48ULL, 0x0000000d0400720cULL, 0x000fe40003f26070ULL,
0x00000001051b7824ULL, 0x000fe200030e0623ULL, 0x0000002506147212ULL, 0x002fe200078efcffULL,
0x0000000104057824ULL, 0x000fe200078e0211ULL, 0x0000003c1e1e7810ULL, 0x000fe20007ffe0ffULL,
0x0000000804067824ULL, 0x000fe200078e00ffULL, 0x0000002114147210ULL, 0x000fe20007fde0ffULL,
0x0000000102047824ULL, 0x000fc400078e0204ULL, 0x00000010311d7824ULL, 0x000fe200078e021cULL,
0xfffffff8062d7812ULL, 0x000fe200078ee205ULL, 0x0000008004047825ULL, 0x000fc600078e00ffULL,
0x00000000161d7faeULL, 0x0003e2000c101c48ULL, 0x0000000102067824ULL, 0x000fe200078e0220ULL,
0x0000002504087212ULL, 0x004fe200078efcffULL, 0x0000000107157824ULL, 0x000fe200030e0623ULL,
0x0000000d1e00720cULL, 0x000fe20003f06070ULL, 0x0000008006067825ULL, 0x000fe200078e00ffULL,
0x0000002108087210ULL, 0x000fc60007fde0ffULL, 0x00000010331f7824ULL, 0x000fe200078e021cULL,
0x0000002506067212ULL, 0x000fe200078efcffULL, 0x0000000102047824ULL, 0x000fe400078e021eULL,
0x0000000105097824ULL, 0x000fe200030e0623ULL, 0x00000000181f7faeULL, 0x0005e2000d101c48ULL,
0x0000008004047825ULL, 0x000fe200078e00ffULL, 0x0000000d2000720cULL, 0x000fe40003f46070ULL,
0x0000002106067210ULL, 0x000fe20007fde0ffULL, 0x00000001200d7824ULL, 0x000fe200078e0211ULL,
0x0000002504047212ULL, 0x000fe200078efcffULL, 0x0000000820207824ULL, 0x000fc400078e00ffULL,
0x000000011e167824ULL, 0x042fe400078e0211ULL, 0x000000081e177824ULL, 0x000fe200078e00ffULL,
0xfffffff8201f7812ULL, 0x004fe200078ee20dULL, 0x0000000107077824ULL, 0x000fe200030e0623ULL,
0x0000002104047210ULL, 0x000fe20007fde0ffULL, 0x00000010270d7824ULL, 0x000fe200078e021cULL,
0xfffffff817257812ULL, 0x000fe200078ee216ULL, 0x0000001029177824ULL, 0x100fe400078e021cULL,
0x000000102b197824ULL, 0x100fe200078e021cULL, 0x000000000a0d7faeULL, 0x0003e2000e901c48ULL,
0x000000102d1d7824ULL, 0x000fc400078e021cULL, 0x000000101f1f7824ULL, 0x100fe200078e021cULL,
0x000000001a177faeULL, 0x0003e2000e101c48ULL, 0x0000001025217824ULL, 0x000fe400078e021cULL,
0x0000000105057824ULL, 0x000fe200030e0623ULL, 0x0000000014197faeULL, 0x0003e8000d901c48ULL,
0x00000000081d7faeULL, 0x0003e8000c901c48ULL, 0x00000000061f7faeULL, 0x0003e8000d101c48ULL,
0x0000000004217faeULL, 0x0003e2000c101c48ULL, 0x00000b8000007947ULL, 0x000fea0003800000ULL,
0x0000000411077811ULL, 0x042fe400078fe8ffULL, 0x0000000811087811ULL, 0x000fc400078fe8ffULL,
0x0000001011147811ULL, 0x000fe200078fe8ffULL, 0x0000000107047824ULL, 0x100fe200078e0211ULL,
0x0000000c11097811ULL, 0x000fe200078fe8ffULL, 0x00000008072d7824ULL, 0x000fe200078e00ffULL,
0x0000001811177811ULL, 0x040fe200078fe8ffULL, 0x00000008082f7824ULL, 0x000fe200078e00ffULL,
0x00000020111b7811ULL, 0x000fe200078fe8ffULL, 0x0000000114067824ULL, 0x100fe200078e0211ULL,
0xfffffff82d2d7812ULL, 0x000fe200078ee204ULL, 0x0000000108047824ULL, 0x100fe200078e0211ULL,
0x0000001c11197811ULL, 0x040fe200078fe8ffULL, 0x0000000814337824ULL, 0x000fe200078e00ffULL,
0x00000028111f7811ULL, 0x000fe200078fe8ffULL, 0x0000000109057824ULL, 0x100fe200078e0211ULL,
0xfffffff82f2f7812ULL, 0x000fe200078ee204ULL, 0x0000000809187824ULL, 0x000fe200078e00ffULL,
0xfffffff833337812ULL, 0x000fe200078ee206ULL, 0x0000000117047824ULL, 0x000fe200078e0211ULL,
0x0000001411167811ULL, 0x000fe200078fe8ffULL, 0x0000000817377824ULL, 0x000fe200078e00ffULL,
0xfffffff818317812ULL, 0x000fe200078ee205ULL, 0x000000011b067824ULL, 0x100fe200078e0211ULL,
0x0000003011247811ULL, 0x000fe200078fe8ffULL, 0x000000081b3b7824ULL, 0x000fe200078e00ffULL,
0xfffffff837377812ULL, 0x000fe200078ee204ULL, 0x0000000119057824ULL, 0x100fe200078e0211ULL,
0x0000002c11217811ULL, 0x000fe200078fe8ffULL, 0x0000000819187824ULL, 0x000fe200078e00ffULL,
0xfffffff83b3b7812ULL, 0x000fe200078ee206ULL, 0x000000011f047824ULL, 0x000fe200078e0211ULL,
0x00000024111e7811ULL, 0x000fe200078fe8ffULL, 0x000000081f3f7824ULL, 0x000fe200078e00ffULL,
0xfffffff818397812ULL, 0x000fe200078ee205ULL, 0x00000001160a7824ULL, 0x140fe200078e0211ULL,
0x0000003811277811ULL, 0x000fe200078fe8ffULL, 0x0000000816357824ULL, 0x000fe200078e00ffULL,
0xfffffff83f3f7812ULL, 0x000fe200078ee204ULL, 0x0000000124067824ULL, 0x140fe200078e0211ULL,
0x0000001111047211ULL, 0x000fe200078fe8ffULL, 0x0000000824437824ULL, 0x000fe200078e00ffULL,
0xfffffff835357812ULL, 0x000fe200078ee20aULL, 0x0000000121057824ULL, 0x100fe200078e0211ULL,
0x0000003411257811ULL, 0x000fe200078fe8ffULL, 0x0000000821187824ULL, 0x000fe200078e00ffULL,
0xfffffff843437812ULL, 0x000fe200078ee206ULL, 0x000000011e0a7824ULL, 0x000fe200078e0211ULL,
0x0000000704047812ULL, 0x000fe200078ec0ffULL, 0x000000081e3d7824ULL, 0x000fe200078e00ffULL,
0xfffffff818417812ULL, 0x000fe200078ee205ULL, 0x0000000127067824ULL, 0x140fe200078e0211ULL,
0x0ffffff8040d7812ULL, 0x000fe200078ef811ULL, 0x0000000827477824ULL, 0x000fe200078e00ffULL,
0xfffffff83d3d7812ULL, 0x000fe200078ee20aULL, 0x0000000212057824ULL, 0x000fe200078e025dULL,
0x0000003c11297811ULL, 0x000fe200078fe8ffULL, 0x00000001250a7824ULL, 0x100fe200078e0211ULL,
0xfffffff847477812ULL, 0x000fe200078ee206ULL, 0x0000000825457824ULL, 0x000fe200078e00ffULL,
0x0000200005067811ULL, 0x000fe200078e68ffULL, 0x0000001011047824ULL, 0x040fe200078e00ffULL,
0x0000000211057211ULL, 0x000fe200078fe8ffULL, 0x0000000829497824ULL, 0x000fe200078e00ffULL,
0xfffffff845457812ULL, 0x000fe200078ee20aULL, 0x00000001290a7824ULL, 0x000fe200078e0211ULL,
0x00000070044b7812ULL, 0x000fe200078ec0ffULL, 0x0000008005047825ULL, 0x000fe200078e00ffULL,
0x00006200234d7a11ULL, 0x000fc400078038ffULL, 0xfffffff849497812ULL, 0x000fe200078ee20aULL,
0x0000000102087824ULL, 0x000fe200078e0208ULL, 0x0000004b04047212ULL, 0x000fe200078efcffULL,
0x00000001020a7824ULL, 0x000fe200078e0209ULL, 0x00006300234f7a11ULL, 0x000fe200000f3cffULL,
0x0000008008087825ULL, 0x000fe200078e00ffULL, 0x000000044d047210ULL, 0x000fc60007f1e0ffULL,
0x0000000102147824ULL, 0x000fe200078e0214ULL, 0x0000004b08087212ULL, 0x000fe200078efcffULL,
0x0000000102077824ULL, 0x000fe400078e0207ULL, 0x000000100d0d7824ULL, 0x100fe400078e0206ULL,
0x000000102d2d7824ULL, 0x100fe400078e0206ULL, 0x000000102f2f7824ULL, 0x100fe400078e0206ULL,
0x0000001031317824ULL, 0x000fc400078e0206ULL, 0x0000001033337824ULL, 0x100fe400078e0206ULL,
0x0000001035357824ULL, 0x100fe400078e0206ULL, 0x0000001037377824ULL, 0x100fe400078e0206ULL,
0x0000001039397824ULL, 0x100fe400078e0206ULL, 0x000000103b3b7824ULL, 0x100fe400078e0206ULL,
0x000000103d3d7824ULL, 0x000fc400078e0206ULL, 0x000000103f3f7824ULL, 0x100fe400078e0206ULL,
0x0000001041417824ULL, 0x100fe400078e0206ULL, 0x0000001043437824ULL, 0x100fe400078e0206ULL,
0x0000001045457824ULL, 0x100fe400078e0206ULL, 0x0000001047477824ULL, 0x100fe400078e0206ULL,
0x0000001049497824ULL, 0x000fc400078e0206ULL, 0x0000008014147825ULL, 0x000fc800078e00ffULL,
0x0000008007067825ULL, 0x000fe200078e00ffULL, 0x0000004b14147212ULL, 0x000fc600078efcffULL,
0x000000800a0a7825ULL, 0x000fe200078e00ffULL, 0x0000004b06067212ULL, 0x000fc600078efcffULL,
0x0000000105057824ULL, 0x000fe200000e064fULL, 0x000000084d087210ULL, 0x040fe20007f1e0ffULL,
0x0000000102167824ULL, 0x000fe200078e0216ULL, 0x0000004b0a0a7212ULL, 0x000fe200078efcffULL,
0x0000000102187824ULL, 0x040fe200078e0217ULL, 0x000000064d067210ULL, 0x040fe20007f3e0ffULL,
0x00000001021a7824ULL, 0x040fe200078e0219ULL, 0x0000000a4d0a7210ULL, 0x000fe20007f5e0ffULL,
0x00000001021c7824ULL, 0x000fe200078e021bULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000040d7faeULL, 0x0003e2000b901c48ULL, 0x0000008016167825ULL, 0x000fc800078e00ffULL,
0x0000008018187825ULL, 0x000fe200078e00ffULL, 0x0000004b16167212ULL, 0x000fc600078efcffULL,
0x0000000109097824ULL, 0x000fe200000e064fULL, 0x000000144d147210ULL, 0x000fe20007f1e0ffULL,
0x000000801a1a7825ULL, 0x000fe200078e00ffULL, 0x0000004b18187212ULL, 0x000fc600078efcffULL,
0x00000001021e7824ULL, 0x000fe200078e021eULL, 0x0000004b1a1a7212ULL, 0x000fe200078efcffULL,
0x000000801c1c7825ULL, 0x000fc800078e00ffULL, 0x0000000102207824ULL, 0x000fe200078e021fULL,
0x0000004b1c1c7212ULL, 0x000fe200078efcffULL, 0x0000000102227824ULL, 0x040fe400078e0221ULL,
0x0000000102247824ULL, 0x040fe200078e0224ULL, 0x0000001c4d1c7210ULL, 0x000fe20007f7e0ffULL,
0x0000000102267824ULL, 0x000fe400078e0225ULL, 0x000000801e1e7825ULL, 0x000fc800078e00ffULL,
0x0000000102287824ULL, 0x000fe200078e0227ULL, 0x0000004b1e1e7212ULL, 0x000fe200078efcffULL,
0x0000008020207825ULL, 0x000fc800078e00ffULL, 0x0000000115157824ULL, 0x000fe200000e064fULL,
0x000000164d167210ULL, 0x000fe20007f1e0ffULL, 0x00000001022a7824ULL, 0x000fe200078e0229ULL,
0x0000004b20207212ULL, 0x000fe200078efcffULL, 0x0000008022227825ULL, 0x000fc800078e00ffULL,
0x0000000107077824ULL, 0x100fe200008e064fULL, 0x000000184d187210ULL, 0x000fe20007f3e0ffULL,
0x0000008024247825ULL, 0x000fe200078e00ffULL, 0x0000004b22227212ULL, 0x080fe400078efcffULL,
0x00000000062d7faeULL, 0x0003e2000b901c48ULL, 0x000000010b0b7824ULL, 0x100fe200010e064fULL,
0x0000001a4d1a7210ULL, 0x040fe20007f5e0ffULL, 0x0000008026267825ULL, 0x000fe200078e00ffULL,
0x0000004b24247212ULL, 0x080fe200078efcffULL, 0x00000000082f7faeULL, 0x0003e4000b901c48ULL,
0x0000008028287825ULL, 0x000fe200078e00ffULL, 0x0000004b26267212ULL, 0x080fe200078efcffULL,
0x000000000a317faeULL, 0x0003e4000b901c48ULL, 0x000000802a2a7825ULL, 0x000fe200078e00ffULL,
0x0000004b28287212ULL, 0x080fe200078efcffULL, 0x0000000014337faeULL, 0x0003e2000b901c48ULL,
0x000000264d267210ULL, 0x000fe20007f9e0ffULL, 0x0000000117177824ULL, 0x100fe200000e064fULL,
0x0000001e4d1e7210ULL, 0x000fe20007f1e0ffULL, 0x0000000119197824ULL, 0x100fe200008e064fULL,
0x000000204d207210ULL, 0x000fe20007f3e0ffULL, 0x000000011b1b7824ULL, 0x100fe200010e064fULL,
0x0000004b2a2a7212ULL, 0x000fe200078efcffULL, 0x000000011d1d7824ULL, 0x100fe200018e064fULL,
0x000000224d227210ULL, 0x000fe20007f5e0ffULL, 0x000000011f1f7824ULL, 0x100fe200000e064fULL,
0x000000244d247210ULL, 0x000fe20007f7e0ffULL, 0x0000000121217824ULL, 0x100fe200008e064fULL,
0x000000284d287210ULL, 0x040fe20007fbe0ffULL, 0x0000000016357faeULL, 0x0003e2000b901c48ULL,
0x0000002a4d2a7210ULL, 0x000fe20007fde0ffULL, 0x0000000123237824ULL, 0x000fc400010e064fULL,
0x0000000018377faeULL, 0x0003e2000b901c48ULL, 0x0000000125257824ULL, 0x100fe400018e064fULL,
0x0000000127277824ULL, 0x100fe200020e064fULL, 0x000000001a397faeULL, 0x0003e2000b901c48ULL,
0x0000000129297824ULL, 0x100fe400028e064fULL, 0x000000012b2b7824ULL, 0x000fe200030e064fULL,
0x000000001c3b7faeULL, 0x0003e8000b901c48ULL, 0x000000001e3d7faeULL, 0x0003e8000b901c48ULL,
0x00000000203f7faeULL, 0x0003e8000b901c48ULL, 0x0000000022417faeULL, 0x0003e8000b901c48ULL,
0x0000000024437faeULL, 0x0003e8000b901c48ULL, 0x0000000026457faeULL, 0x0003e8000b901c48ULL,
0x0000000028477faeULL, 0x0003e8000b901c48ULL, 0x000000002a497faeULL, 0x0003e4000b901c48ULL,
0x000000045c5c7810ULL, 0x000fe20007ffe0ffULL, 0x00000000000079afULL, 0x000e220000000000ULL,
0xffffffffff0d7424ULL, 0x002fc400078e00ffULL, 0x0000000f5c00720cULL, 0x000fe20003f06070ULL,
0x000000ffff687224ULL, 0x000fe200078e00ffULL, 0x0000000000067805ULL, 0x000fe2000001ff00ULL,
0x0000000000047805ULL, 0x000fd4000001ff00ULL, 0x0000000213148824ULL, 0x000fe400078e025cULL,
0x00000004ff158424ULL, 0x000fc800078e00ffULL, 0x0000640014148625ULL, 0x000fe200078e0015ULL,
0x00000000000a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000087805ULL, 0x000fe2000001ff00ULL,
0x0000000000167805ULL, 0x000fe2000001ff00ULL, 0x00000000001a7805ULL, 0x000fe2000001ff00ULL,
0x00000008140d8981ULL, 0x000322000c1e1900ULL, 0x0000000000187805ULL, 0x000fe2000001ff00ULL,
0x00000000001e7805ULL, 0x000fe2000001ff00ULL, 0x00000000001c7805ULL, 0x000fe2000001ff00ULL,
0x0000000000227805ULL, 0x000fe2000001ff00ULL, 0x0000000000207805ULL, 0x000fe2000001ff00ULL,
0x0000000000267805ULL, 0x000fe2000001ff00ULL, 0x0000000000247805ULL, 0x000fe2000001ff00ULL,
0x00000000002a7805ULL, 0x000fe2000001ff00ULL, 0x0000000000287805ULL, 0x000fe2000001ff00ULL,
0x0000000000147805ULL, 0x002fe2000001ff00ULL, 0x00000000002e7805ULL, 0x000fe2000001ff00ULL,
0x00000000002c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000327805ULL, 0x000fe2000001ff00ULL,
0x0000000000307805ULL, 0x000fe2000001ff00ULL, 0x0000000000367805ULL, 0x000fe2000001ff00ULL,
0x0000000000347805ULL, 0x000fe2000001ff00ULL, 0x00000000003a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000387805ULL, 0x000fe2000001ff00ULL, 0x00000000003e7805ULL, 0x000fe2000001ff00ULL,
0x00000000003c7805ULL, 0x000fe2000001ff00ULL, 0x0000000000427805ULL, 0x000fe2000001ff00ULL,
0x0000000000407805ULL, 0x000fe2000001ff00ULL, 0x0000000000467805ULL, 0x000fe2000001ff00ULL,
0x0000000000447805ULL, 0x000fe2000001ff00ULL, 0x00000000004a7805ULL, 0x000fe2000001ff00ULL,
0x0000000000487805ULL, 0x000fe2000001ff00ULL, 0x000080400000791aULL, 0x000fc80000000000ULL,
0xfffffff8114c7812ULL, 0x020fe200078ec0ffULL, 0x00000002127f7824ULL, 0x000fe200078e0267ULL,
0xffffffff00007948ULL, 0x000fe20003800000ULL, 0x0000000168807810ULL, 0x000fc40007ffe0ffULL,
0x000000074c517812ULL, 0x100fe400078ef811ULL, 0x000020007f7f7811ULL, 0x000fe400078e68ffULL,
0x00000004ff857819ULL, 0x000fe20000011611ULL, 0x00000001514c7824ULL, 0x040fe400078e0268ULL,
0x00000008514d7824ULL, 0x040fe400078e00ffULL, 0x0000000851507824ULL, 0x040fe400078e00ffULL,
0x0000000151517824ULL, 0x000fe200078e0280ULL, 0xfffffff84d4c7812ULL, 0x000fe200078ee24cULL,
0x0000000268857824ULL, 0x000fc600078e0285ULL, 0xfffffff850507812ULL, 0x000fe200078ee251ULL,
0x000000104c4c7824ULL, 0x000fc800078e027fULL, 0x0000001050507824ULL, 0x000fe400078e027fULL,
0x000000004c4c783bULL, 0x000e680000000200ULL, 0x000000005050783bULL, 0x000ea20000000200ULL,
0x00000018ff547819ULL, 0x002fe2000001144cULL, 0x000100004c567824ULL, 0x040fe200078e00ffULL,
0x000088804c557816ULL, 0x040fe200000000ffULL, 0x000001004c4c7824ULL, 0x000fe200078e00ffULL,
0x0000005400887306ULL, 0x0003e20000200c00ULL, 0x00000018ff847819ULL, 0x000fe2000001144dULL,
0x000100004d5a7824ULL, 0x040fe200078e00ffULL, 0x000088804d597816ULL, 0x040fe200000000ffULL,
0x000001004d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff587819ULL, 0x000fc40000011456ULL,
0x00000018ff4c7819ULL, 0x000fe2000001144cULL, 0x0000005500867306ULL, 0x000fe20000200c00ULL,
0x0000002011547810ULL, 0x002fe40007ffe0ffULL, 0x00000018ff4d7819ULL, 0x000fe4000001144dULL,
0xfffffff854547812ULL, 0x000fe400078ec0ffULL, 0x00000018ff7d7819ULL, 0x000fe2000001144eULL,
0x0000005800897306ULL, 0x0003e20000200c00ULL, 0x0000000754877812ULL, 0x000fc400078ef811ULL,
0x00000018ff7b7819ULL, 0x000fe4000001144fULL, 0x00000018ff697819ULL, 0x004fe20000011450ULL,
0x0000000187547824ULL, 0x000fe200078e0268ULL, 0x000088804f817816ULL, 0x000fe200000000ffULL,
0x0000004c008b7306ULL, 0x0005e20000200c00ULL, 0x000100004e587824ULL, 0x002fe200078e00ffULL,
0x00008880506d7816ULL, 0x000fe200000000ffULL, 0x0000000887577824ULL, 0x000fe200078e00ffULL,
0x00000018ff5a7819ULL, 0x000fe4000001145aULL, 0x00000018ff587819ULL, 0x000fc40000011458ULL,
0x0000004d008f7306ULL, 0x0003e20000200c00ULL, 0x000088804e4c7816ULL, 0x044fe200000000ffULL,
0x000001004e4e7824ULL, 0x000fe200078e00ffULL, 0xfffffff857547812ULL, 0x000fe400078ee254ULL,
0x00000018ff6c7819ULL, 0x000fe40000011451ULL, 0x00000018ff4e7819ULL, 0x000fe2000001144eULL,
0x0000004c008c7306ULL, 0x0005e20000200c00ULL, 0x000100004f4d7824ULL, 0x002fe200078e00ffULL,
0x00008880516f7816ULL, 0x000fe200000000ffULL, 0x000001004f4f7824ULL, 0x000fe200078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe20000011452ULL, 0x0000001054547824ULL, 0x000fe200078e027fULL,
0x00000018ff4d7819ULL, 0x000fc4000001144dULL, 0x0000004e008e7306ULL, 0x0003e20000200c00ULL,
0x00010000504c7824ULL, 0x044fe200078e00ffULL, 0x00000018ff4f7819ULL, 0x000fe2000001144fULL,
0x0000010050507824ULL, 0x000fe200078e00ffULL, 0x000000005454783bULL, 0x000ea20000000200ULL,
0x0000888052717816ULL, 0x000fe400000000ffULL, 0x00000018ff4c7819ULL, 0x000fe2000001144cULL,
0x0000004d00907306ULL, 0x0007e20000200c00ULL, 0x00000008114e7812ULL, 0x002fe400078ec0ffULL,
0x00000018ff507819ULL, 0x000fc40000011450ULL, 0x000000074e837812ULL, 0x000fe200078ef811ULL,
0x00010000524e7824ULL, 0x040fe200078e00ffULL, 0x00000018ff6a7819ULL, 0x000fe20000011453ULL,
0x0000004f00927306ULL, 0x0003e20000200c00ULL, 0x00010000514d7824ULL, 0x008fe200078e00ffULL,
0x0000001083827812ULL, 0x000fe200078efcffULL, 0x0000010051517824ULL, 0x000fe200078e00ffULL,
0x00000018ff747819ULL, 0x000fe2000001144eULL, 0x0000010052527824ULL, 0x000fe200078e00ffULL,
0x00000018ff4d7819ULL, 0x000fe4000001144dULL, 0x0000004c00707306ULL, 0x0007e20000200c00ULL,
0x00000010834f7824ULL, 0x002fe200078e00ffULL, 0x00000018ff517819ULL, 0x000fc40000011451ULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x0000888053757816ULL, 0x000fe400000000ffULL,
0x00000050006e7306ULL, 0x0003e20000200c00ULL, 0x00000001834c7824ULL, 0x008fe200078e0285ULL,
0x0000000268687810ULL, 0x000fc80007ffe0ffULL, 0xfffffff04f4c7812ULL, 0x000fe400078ee24cULL,
0x0000004d00727306ULL, 0x0007e20000200c00ULL, 0x0000001082507824ULL, 0x002fe200078e00ffULL,
0x000000086800780cULL, 0x000fe40003f05270ULL, 0x00000018ff7e7819ULL, 0x004fe40000011454ULL,
0x00000018ff7c7819ULL, 0x000fe40000011455ULL, 0x0000005800917306ULL, 0x0002a20000200c00ULL,
0x00000001824d7824ULL, 0x008fe200078e0285ULL, 0x00000018ff7a7819ULL, 0x000fc40000011456ULL,
0x00000018ff797819ULL, 0x000fe40000011457ULL, 0xfffffff0504d7812ULL, 0x000fe200078ee24dULL,
0x0001000053507824ULL, 0x000fe200078e00ffULL, 0x00000059008a7306ULL, 0x000fe20000200c00ULL,
0x000000104c587824ULL, 0x002fe200078e00ffULL, 0x0000000285857810ULL, 0x000fe20007ffe0ffULL,
0x000000104d4d7824ULL, 0x000fe200078e00ffULL, 0x00000018ff787819ULL, 0x000fe20000011450ULL,
0x0000010053537824ULL, 0x000fe200078e00ffULL, 0x0000888054507816ULL, 0x000fc400000000ffULL,
0x0000005a008d7306ULL, 0x0002e20000200c00ULL, 0x000000004d4c783bULL, 0x000ee20000000200ULL,
0x00000018ff537819ULL, 0x000fe40000011453ULL, 0x000054108c8c7816ULL, 0x004fc80000000091ULL,
0x0000005100737306ULL, 0x0005e20000200c00ULL, 0x000000005858783bULL, 0x002e6e0000000200ULL,
0x0000005200767306ULL, 0x0007e20000200c00ULL, 0x0001000054517824ULL, 0x004fe200078e00ffULL,
0x000054108a8a7816ULL, 0x008fc8000000008dULL, 0x00000018ff517819ULL, 0x000fe40000011451ULL,
0x0000005000937306ULL, 0x0005e20000200c00ULL, 0x0000010054527824ULL, 0x000fca00078e00ffULL,
0x00000018ff527819ULL, 0x000fe40000011452ULL, 0x0000005100547306ULL, 0x0007e20000200c00ULL,
0x0000541086507816ULL, 0x004fe20000000089ULL, 0x0001000055867824ULL, 0x000fca00078e00ffULL,
0x00000018ff867819ULL, 0x000fe20000011486ULL, 0x0000008400847306ULL, 0x000ea20000200c00ULL,
0x000054108b517816ULL, 0x008fce0000000088ULL, 0x000000504c28723cULL, 0x080fe20000001828ULL,
0x0000005200957306ULL, 0x0007ee0000200c00ULL, 0x000000505848723cULL, 0x002b620000001848ULL,
0x0000007b007b7306ULL, 0x000e620000200c00ULL, 0x0000000887527824ULL, 0x008fe200078e00ffULL,
0x000054108f8b7816ULL, 0x004fe20000000084ULL, 0x0001000056847824ULL, 0x000fc600078e00ffULL,
0x0000010055507824ULL, 0x020fe400078e00ffULL, 0x0000000187517824ULL, 0x000fe200078e0280ULL,
0x0000007d007d7306ULL, 0x000ea20000200c00ULL, 0x00000018ff847819ULL, 0x000fe20000011484ULL,
0x0000008a5844723cULL, 0x080f620000001844ULL, 0x00000018ff807819ULL, 0x000fe40000011450ULL,
0xfffffff852507812ULL, 0x000fe400078ee251ULL, 0x0000888056517816ULL, 0x040fe200000000ffULL,
0x0000005300777306ULL, 0x0007e20000200c00ULL, 0x0000010056567824ULL, 0x000fe200078e00ffULL,
0x0000541092917816ULL, 0x002fe2000000007bULL, 0x0000001050507824ULL, 0x000fe200078e027fULL,
0x0000008a4c24723cULL, 0x000b620000001824ULL, 0x000000ffff7f7224ULL, 0x000fe200078e0051ULL,
0x00000018ff567819ULL, 0x000fc40000011456ULL, 0x0000008000877306ULL, 0x0003e20000200c00ULL,
0x0000888055537816ULL, 0x008fe400000000ffULL, 0x000054108e8d7816ULL, 0x004fca000000007dULL,
0x0000008600557306ULL, 0x000fe20000200c00ULL, 0x0000888057807816ULL, 0x002fe200000000ffULL,
0x0000008c5840723cULL, 0x080f680000001840ULL, 0x000000ffff7b7224ULL, 0x000fe200078e0080ULL,
0x0000541093807816ULL, 0x000fe20000000054ULL, 0x0000007f00867306ULL, 0x0003e20000200c00ULL,
0x0000001083547824ULL, 0x040fe200078e00ffULL, 0x0000008c4c20723cULL, 0x000f620000001820ULL,
0x0000000183837824ULL, 0x000fc400078e0285ULL, 0x0000000182857824ULL, 0x040fe400078e0285ULL,
0x0000001082827824ULL, 0x000fe200078e00ffULL, 0x0000008100817306ULL, 0x000ea20000200c00ULL,
0x00010000577f7824ULL, 0x042fe200078e00ffULL, 0xfffffff054837812ULL, 0x000fe200078ee283ULL,
0x0000010057577824ULL, 0x000fe200078e00ffULL, 0xfffffff082857812ULL, 0x000fe400078ee285ULL,
0x00000018ff7f7819ULL, 0x000fe2000001147fULL, 0x0000001083547824ULL, 0x000fe200078e00ffULL,
0x00000018ff577819ULL, 0x000fe20000011457ULL, 0x0000007e007e7306ULL, 0x000e620000200c00ULL,
0x0000001085857824ULL, 0x000fe200078e00ffULL, 0x0000541081907816ULL, 0x004fcc0000000090ULL,
0x0000007c007c7306ULL, 0x000fe20000200c00ULL, 0x00000090583c723cULL, 0x080f6e000000183cULL,
0x00000084007d7306ULL, 0x000ea20000200c00ULL, 0x0000541095817816ULL, 0x002fe2000000007eULL,
0x000000904c1c723cULL, 0x000f6c000000181cULL, 0x0000007b008a7306ULL, 0x020fe40000200c00ULL,
0x000000805838723cULL, 0x080f6c0000001838ULL, 0x0000007f008b7306ULL, 0x0002e20000200c00ULL,
0x0000541086867816ULL, 0x004fe2000000007dULL, 0x000000804c18723cULL, 0x000fec0000001818ULL,
0x0000007a007a7306ULL, 0x000fe20000200c00ULL, 0x00005410877f7816ULL, 0x002fce000000007cULL,
0x0000007900797306ULL, 0x000fe20000200c00ULL, 0x000054108a8a7816ULL, 0x008fce000000008bULL,
0x0000005300887306ULL, 0x0002b00000200c00ULL, 0x0000005600897306ULL, 0x000ee20000200c00ULL,
0x000000005050783bULL, 0x002e6e0000000200ULL, 0x0000005700847306ULL, 0x0006e20000200c00ULL,
0x00005410887e7816ULL, 0x004fc40000000055ULL, 0x0000541089877816ULL, 0x008fca000000007aULL,
0x0000007e5834723cULL, 0x000f620000001834ULL, 0x000000005454783bULL, 0x000ea20000000200ULL,
0x0000006900697306ULL, 0x000fe20000200c00ULL, 0x00005410848b7816ULL, 0x000fca0000000079ULL,
0x000000865830723cULL, 0x040fe40000001830ULL, 0x0000006d006d7306ULL, 0x000fec0000200c00ULL,
0x0000008a582c723cULL, 0x000be4000000182cULL, 0x000000008558783bULL, 0x020ee20000000200ULL,
0x0000006c006c7306ULL, 0x000eaa0000200c00ULL, 0x0000007e4c14723cULL, 0x000b620000001814ULL,
0x00000018ff7d7819ULL, 0x002fe20000011452ULL, 0x00010000507a7824ULL, 0x000fe200078e00ffULL,
0x0000006b006b7306ULL, 0x000fe20000200c00ULL, 0x00000018ff7b7819ULL, 0x000fc40000011450ULL,
0x00000018ff7c7819ULL, 0x000fe40000011451ULL, 0x00008880517e7816ULL, 0x020fe200000000ffULL,
0x000000864c08723cULL, 0x040f620000001808ULL, 0x0000888050797816ULL, 0x000fe200000000ffULL,
0x0000007100717306ULL, 0x000fe20000200c00ULL, 0x0000541073737816ULL, 0x004fe2000000006cULL,
0x00000100526c7824ULL, 0x000fe200078e00ffULL, 0x00000018ff827819ULL, 0x000fe20000011453ULL,
0x0000010050507824ULL, 0x000fe200078e00ffULL, 0x00000018ff7a7819ULL, 0x000fe2000001147aULL,
0x0000008a4c04723cULL, 0x000b620000001804ULL, 0x00000018ff6c7819ULL, 0x000fe2000001146cULL,
0x0000007400747306ULL, 0x000fe20000200c00ULL, 0x00000018ff507819ULL, 0x000fc80000011450ULL,
0x000000ffff4c7224ULL, 0x020fe200078e007eULL, 0x000054106e4d7816ULL, 0x000fe20000000069ULL,
0x00010000514e7824ULL, 0x040fe200078e00ffULL, 0x0000006a006a7306ULL, 0x000e620000200c00ULL,
0x0000010051517824ULL, 0x000fc600078e00ffULL, 0x00000018ff4e7819ULL, 0x000fe4000001144eULL,
0x00000018ff517819ULL, 0x000fe40000011451ULL, 0x0000004c004f7306ULL, 0x0005f00000200c00ULL,
0x0000004e004e7306ULL, 0x000ee20000200c00ULL, 0x000054106d4c7816ULL, 0x004fc40000000070ULL,
0x0000541077777816ULL, 0x002fca000000006aULL, 0x0000004c5448723cULL, 0x080f620000001848ULL,
0x0000006f006f7306ULL, 0x000e6e0000200c00ULL, 0x0000004c5828723cULL, 0x008b620000001828ULL,
0x0000007500757306ULL, 0x000fe20000200c00ULL, 0x000054104f4e7816ULL, 0x000fca000000004eULL,
0x00010000524d7824ULL, 0x060fe200078e00ffULL, 0x00008880524c7816ULL, 0x000fe200000000ffULL,
0x0000007800787306ULL, 0x000ea20000200c00ULL, 0x000054106f727816ULL, 0x002fe40000000072ULL,
0x00000018ff4d7819ULL, 0x000fca000001144dULL, 0x0000004c00697306ULL, 0x0003e20000200c00ULL,
0x000000725444723cULL, 0x080f6e0000001844ULL, 0x0000004d00527306ULL, 0x0006a20000200c00ULL,
0x00005410714c7816ULL, 0x002fe20000000074ULL, 0x000000725824723cULL, 0x000f6c0000001824ULL,
0x0000007b007b7306ULL, 0x000fe20000200c00ULL, 0x00005410764d7816ULL, 0x008fc4000000006bULL,
0x00008880536b7816ULL, 0x000fe400000000ffULL, 0x0000541075767816ULL, 0x004fc60000000078ULL,
0x0000004c5440723cULL, 0x000f620000001840ULL, 0x0000007c007c7306ULL, 0x000fe20000200c00ULL,
0x0000541069527816ULL, 0x000fcc0000000052ULL, 0x0000004c5820723cULL, 0x000b620000001820ULL,
0x0000007d007d7306ULL, 0x000fec0000200c00ULL, 0x000000ffff4c7224ULL, 0x020fe200078e006bULL,
0x00000076543c723cULL, 0x000b62000000183cULL, 0x00010000536b7824ULL, 0x040fe200078e00ffULL,
0x0000008200827306ULL, 0x000fe20000200c00ULL, 0x0000010053537824ULL, 0x000fc600078e00ffULL,
0x00000018ff6b7819ULL, 0x000fe4000001146bULL, 0x00000018ff537819ULL, 0x000fe20000011453ULL,
0x00000076581c723cULL, 0x000b62000000181cULL, 0x0000007900797306ULL, 0x000ff00000200c00ULL,
0x0000007a007a7306ULL, 0x000e700000200c00ULL, 0x0000005000507306ULL, 0x000eb00000200c00ULL,
0x0000005100517306ULL, 0x000ee20000200c00ULL, 0x00005410797a7816ULL, 0x002fce000000007aULL,
0x0000006c006c7306ULL, 0x000fe20000200c00ULL, 0x00005410507b7816ULL, 0x004fce000000007bULL,
0x0000004c004c7306ULL, 0x000fe20000200c00ULL, 0x00005410514f7816ULL, 0x008fe2000000007cULL,
0x0000007a5438723cULL, 0x040b6c0000001838ULL, 0x0000006b006b7306ULL, 0x000e640000200c00ULL,
0x0000004e5434723cULL, 0x000b6c0000001834ULL, 0x00000053004d7306ULL, 0x0004e40000200c00ULL,
0x0000007a5818723cULL, 0x000b620000001818ULL, 0x000054104c4c7816ULL, 0x002fc4000000006bULL,
0x000054106c537816ULL, 0x004fca000000007dULL, 0x0000004e5814723cULL, 0x000b620000001814ULL,
0x000054104d4d7816ULL, 0x008fce0000000082ULL, 0x000000525430723cULL, 0x040b700000001830ULL,
0x0000004c542c723cULL, 0x000b70000000182cULL, 0x000000525808723cULL, 0x040b700000001808ULL,
0x0000004c5804723cULL, 0x000b620000001804ULL, 0x0000001000008944ULL, 0x000fe20003c00000ULL,
0xffffee1000007947ULL, 0x000fcc000383ffffULL, 0x0000006648577220ULL, 0x0a0fe40000410000ULL,
0x0000006649567220ULL, 0x000fc40000410000ULL, 0x000000664a487220ULL, 0x080fe40000410000ULL,
0x000000664b497220ULL, 0x080fe40000410000ULL, 0x0000006646467220ULL, 0x080fe40000410000ULL,
0x000000663f3f7220ULL, 0x080fe40000410000ULL, 0x0000006638597220ULL, 0x080fe40000410000ULL,
0x0000006647477220ULL, 0x000fc40000410000ULL, 0x0000006642427220ULL, 0x080fe40000410000ULL,
0x0000006643437220ULL, 0x080fe40000410000ULL, 0x000000663e3e7220ULL, 0x080fe40000410000ULL,
0x000000663a3a7220ULL, 0x080fe40000410000ULL, 0x000000663b3b7220ULL, 0x080fe40000410000ULL,
0x0000006636367220ULL, 0x000fc40000410000ULL, 0x0000006637377220ULL, 0x080fe40000410000ULL,
0x000000662e387220ULL, 0x080fe40000410000ULL, 0x0000006628287220ULL, 0x080fe40000410000ULL,
0x0000006629297220ULL, 0x080fe40000410000ULL, 0x0000006625257220ULL, 0x080fe40000410000ULL,
0x0000006620207220ULL, 0x000fc40000410000ULL, 0x0000006621217220ULL, 0x080fe40000410000ULL,
0x000000661d1d7220ULL, 0x080fe40000410000ULL, 0x0000006618187220ULL, 0x080fe40000410000ULL,
0x0000006615157220ULL, 0x080fe40000410000ULL, 0x0000006608087220ULL, 0x080fe40000410000ULL,
0x0000006645547220ULL, 0x000fc40000410000ULL, 0x00000066344f7220ULL, 0x080fe40000410000ULL,
0x00000066354e7220ULL, 0x080fe40000410000ULL, 0x00000066304d7220ULL, 0x080fe40000410000ULL,
0x000000662b5b7220ULL, 0x080fe40000410000ULL, 0x0000006639507220ULL, 0x080fe40000410000ULL,
0x00000066314c7220ULL, 0x000fc40000410000ULL, 0x000000662c4b7220ULL, 0x080fe40000410000ULL,
0x000000662d4a7220ULL, 0x080fe40000410000ULL, 0x000000662f457220ULL, 0x000fe40000410000ULL,
0x000000ffff347224ULL, 0x000fe400078e0048ULL, 0x000000ffff357224ULL, 0x000fe400078e0049ULL,
0x000000ffff2b7224ULL, 0x000fc400078e0046ULL, 0x000000ffff307224ULL, 0x000fe400078e003fULL,
0x0000006644557220ULL, 0x080fe40000410000ULL, 0x0000006640537220ULL, 0x080fe40000410000ULL,
0x0000006641527220ULL, 0x080fe40000410000ULL, 0x000000663c517220ULL, 0x080fe40000410000ULL,
0x000000663d587220ULL, 0x000fc40000410000ULL, 0x000000662a5a7220ULL, 0x080fe40000410000ULL,
0x000000661c397220ULL, 0x000fe40000410000ULL, 0x000000ffff2d7224ULL, 0x000fe400078e0047ULL,
0x000000ffff2c7224ULL, 0x000fe400078e0042ULL, 0x000000ffff497224ULL, 0x000fe400078e0043ULL,
0x000000ffff2e7224ULL, 0x000fc400078e003eULL, 0x000000ffff2f7224ULL, 0x000fe400078e003aULL,
0x000000ffff487224ULL, 0x000fe400078e003bULL, 0x000000ffff317224ULL, 0x000fe400078e0036ULL,
0x000000ffff3f7224ULL, 0x000fe400078e0037ULL, 0x000000ffff467224ULL, 0x000fe400078e0038ULL,
0x0000006632327220ULL, 0x000fc40000410000ULL, 0x0000006633337220ULL, 0x080fe40000410000ULL,
0x00000066242a7220ULL, 0x080fe40000410000ULL, 0x0000006626267220ULL, 0x080fe40000410000ULL,
0x0000006627677220ULL, 0x080fe40000410000ULL, 0x0000006622227220ULL, 0x080fe40000410000ULL,
0x0000006623687220ULL, 0x000fc40000410000ULL, 0x000000661e1e7220ULL, 0x080fe40000410000ULL,
0x000000661f1f7220ULL, 0x080fe40000410000ULL, 0x00000066193c7220ULL, 0x080fe40000410000ULL,
0x000000661a1a7220ULL, 0x080fe40000410000ULL, 0x000000661b1b7220ULL, 0x080fe40000410000ULL,
0x00000066143d7220ULL, 0x000fc40000410000ULL, 0x0000006616167220ULL, 0x080fe40000410000ULL,
0x0000006617177220ULL, 0x080fe40000410000ULL, 0x0000006609407220ULL, 0x080fe40000410000ULL,
0x000000660a1c7220ULL, 0x080fe40000410000ULL, 0x000000660b0b7220ULL, 0x080fe40000410000ULL,
0x0000006604417220ULL, 0x000fc40000410000ULL, 0x0000006605447220ULL, 0x080fe40000410000ULL,
0x0000006606067220ULL, 0x080fe40000410000ULL, 0x0000006607077220ULL, 0x000fe40000410000ULL,
0x000000ffff437224ULL, 0x000fe400078e0028ULL, 0x000000ffff427224ULL, 0x000fe400078e0029ULL,
0x000000ffff367224ULL, 0x000fc400078e0025ULL, 0x000000ffff377224ULL, 0x000fe400078e0020ULL,
0x000000ffff387224ULL, 0x000fe400078e0021ULL, 0x000000ffff3a7224ULL, 0x000fe400078e001dULL,
0x000000ffff3b7224ULL, 0x000fe400078e0018ULL, 0x000000ffff3e7224ULL, 0x000fe400078e0015ULL,
0x000000ffff477224ULL, 0x000fe200078e0008ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x0000000000007992ULL, 0x000fec0000008000ULL,
0x0000000064087f8cULL, 0x0002a2000c80043fULL, 0x000000ffff237224ULL, 0x000fc400078e0026ULL,
0x000000ffff287224ULL, 0x000fe400078e0022ULL, 0x000000ffff267224ULL, 0x000fe400078e001eULL,
0x000000ffff227224ULL, 0x000fe400078e001fULL, 0x000000ffff217224ULL, 0x000fe400078e001aULL,
0x000000ffff207224ULL, 0x000fe400078e001bULL, 0x000000ffff247224ULL, 0x000fc400078e005aULL,
0x000000ffff277224ULL, 0x000fe400078e005bULL, 0x000000ffff257224ULL, 0x000fe400078e0067ULL,
0x000000ffff297224ULL, 0x000fe400078e0068ULL, 0x000000ffff1a7224ULL, 0x000fe400078e0016ULL,
0x000000ffff1b7224ULL, 0x000fe400078e0017ULL, 0x000000ffff1d7224ULL, 0x000fc400078e000bULL,
0x000000ffff1e7224ULL, 0x000fe400078e0006ULL, 0x000000ffff1f7224ULL, 0x000fc400078e0007ULL,
0x0000000000047805ULL, 0x006fca0000015200ULL, 0x0000040064077984ULL, 0x000e640000000800ULL,
0x8000000007ff7812ULL, 0x002fe40007804809ULL, 0x0000000000007918ULL, 0x000ff20000000000ULL,
0x000001e000007945ULL, 0x000fe20003800000ULL, 0x000000ffff0a7224ULL, 0x000fe200078e00ffULL,
0x000001b000000947ULL, 0x000fea0003800000ULL, 0x000000100a00780cULL, 0x000fe20003f06270ULL,
0x0000000000007946ULL, 0x000fe20003800000ULL, 0x0000014000017945ULL, 0x000ff60003800000ULL,
0x0000011000008947ULL, 0x000fea0003800000ULL, 0x0000000000067805ULL, 0x000fcc0000015200ULL,
0x00000006040b7210ULL, 0x000fca0007f1e1ffULL, 0x0000000107077824ULL, 0x000fe200000e0e05ULL,
0x003d09000b00780cULL, 0x000fc80003f06070ULL, 0x000000ff0700720cULL, 0x000fda0003f06300ULL,
0x0000002000008947ULL, 0x000fea0003800000ULL, 0x000f42400000795dULL, 0x000fe20003800000ULL,
0x000000a000007947ULL, 0x000fea0003800000ULL, 0x00009c400b00780cULL, 0x000fc80003f06070ULL,
0x000000ff0700720cULL, 0x000fda0003f06300ULL, 0x0000007000008947ULL, 0x000fea0003800000ULL,
0x0000001fff067819ULL, 0x000fc80000011407ULL, 0x0000000b06067211ULL, 0x000fca00078110ffULL,
0x000000ffff077224ULL, 0x000fca00000e0607ULL, 0x0000000206067819ULL, 0x000fc80000001207ULL,
0x000000060000735dULL, 0x000fe20003800000ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x000000010a0a7810ULL, 0x000fc40007ffe0ffULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x0000040064077984ULL, 0x000e640000000800ULL, 0x8000000007ff7812ULL, 0x002fe40007804809ULL,
0x0000000000007918ULL, 0x000ff60000000000ULL, 0xfffffe5000008947ULL, 0x000fea000383ffffULL,
0x0000000000007941ULL, 0x000fea0003800000ULL, 0x0000000411197824ULL, 0x000fe200078e00ffULL,
0x0000005f6200720cULL, 0x000fc80003f06070ULL, 0xfffffff019057812ULL, 0x000fca00078ec0ffULL,
0x0000008012187824ULL, 0x000fca00078e0205ULL, 0x01a4000018047984ULL, 0x0002a20000000c00ULL,
0x00001f6000008947ULL, 0x000fea0003800000ULL, 0x0000010062677824ULL, 0x000fe200078e0203ULL,
0x0000000011097211ULL, 0x040fe200078ff0ffULL, 0x00000002116a7824ULL, 0x000fe400078e00ffULL,
0x00000002ff7d7424ULL, 0x000fe200078e00ffULL, 0x0000006710087217ULL, 0x000fe40007800000ULL,
0x000000066a6a7812ULL, 0x000fe400078ec0ffULL, 0x00000008090b7810ULL, 0x000fe20007ffe0ffULL,
0x0000000108677824ULL, 0x000fe200078e0a67ULL, 0x00005a00ff087a19ULL, 0x000fe20000011609ULL,
0x00000001600a7824ULL, 0x000fe200078e026aULL, 0x000058006a6c7a10ULL, 0x000fc40007ffe0ffULL,
0x0000001009157810ULL, 0x040fe40007ffe0ffULL, 0x000000670a00720cULL, 0x040fe20003f26070ULL,
0x000000010a0a7824ULL, 0x100fe200078e0a67ULL, 0x0000001809167810ULL, 0x000fe40007ffe0ffULL,
0x0000000861097217ULL, 0x040fe20003800000ULL, 0x000000016c087824ULL, 0x000fe200078e0a67ULL,
0x0000000a610a7217ULL, 0x000fe40003800000ULL, 0x00005a00ff147a19ULL, 0x000fe2000001160bULL,
0x000000095e8c7224ULL, 0x000fe200078e02ffULL, 0x00000004ff0a7819ULL, 0x000fc4000001160aULL,
0x000000676c00720cULL, 0x000fe40003f06070ULL, 0x0000000861087217ULL, 0x040fe40003800000ULL,
0x00000014610b7217ULL, 0x000fe40003800000ULL, 0x00005a00ff147a19ULL, 0x000fe40000011615ULL,
0x00005a00ff167a19ULL, 0x000fe20000011616ULL, 0x0000000b5e927224ULL, 0x000fe200078e02ffULL,
0x000000ff0a157207ULL, 0x000fc40000800000ULL, 0x000000ff087b7207ULL, 0x000fe40000000000ULL,
0x00000016615b7217ULL, 0x000fe20003800000ULL, 0x000000018c6e7824ULL, 0x000fe200078e0215ULL,
0x0000008c7b087211ULL, 0x000fe400078fe0ffULL, 0x0000001461177217ULL, 0x000fe20003800000ULL,
0x0000005b5e967224ULL, 0x000fe200078e02ffULL, 0x000000106a787812ULL, 0x000fe200078efcffULL,
0x000060006e6e7625ULL, 0x000fe200078e007dULL, 0x000000927b0a7211ULL, 0x000fc600078fe0ffULL,
0x0000600008087625ULL, 0x000fe400078e007dULL, 0x000000086e6e7981ULL, 0x0046a4000c1e9500ULL,
0x00000001155a7824ULL, 0x040fe400078e0296ULL, 0x000000175e947224ULL, 0x000fe200078e02ffULL,
0x00000008086b7981ULL, 0x0002a2000c1e9500ULL, 0x0000000115727824ULL, 0x040fe400078e0292ULL,
0x0000000115747824ULL, 0x000fe200078e0294ULL, 0x000000947b147211ULL, 0x000fe200078fe0ffULL,
0x000060000a0a7625ULL, 0x000fc800078e007dULL, 0x000060005a087625ULL, 0x082fe200078e007dULL,
0x000000967b167211ULL, 0x000fe200078fe0ffULL, 0x000000080a6d7981ULL, 0x0002a4000c1e9500ULL,
0x00000001605a7824ULL, 0x000fe400078e0278ULL, 0x0000600072727625ULL, 0x000fe200078e007dULL,
0x0000580078767a10ULL, 0x000fe20007ffe0ffULL, 0x0000000808717981ULL, 0x0002a4000c1e9500ULL,
0x000000015a687824ULL, 0x000fc400078e0a67ULL, 0x0000600074747625ULL, 0x080fe200078e007dULL,
0x0000000872727981ULL, 0x0002a6000c1e9500ULL, 0x0000600014147625ULL, 0x080fe200078e007dULL,
0x0000006861687217ULL, 0x000fe20003800000ULL, 0x0000000874747981ULL, 0x0002a4000c1e9500ULL,
0x0000600016167625ULL, 0x000fe400078e007dULL, 0x00000008146f7981ULL, 0x0086a2000c1e9500ULL,
0x000000675a00720cULL, 0x080fe20003f26070ULL, 0x00000001760a7824ULL, 0x042fe200078e0a67ULL,
0x00000004ff687819ULL, 0x000fe20000011668ULL, 0x0000000816707981ULL, 0x0002a2000c1e9500ULL,
0x000000677600720cULL, 0x000fc40003f06070ULL, 0x0000000a610a7217ULL, 0x000fe40003800000ULL,
0x000000ff68177207ULL, 0x002fe40000800000ULL, 0x000000ff0a837207ULL, 0x000fc60000000000ULL,
0x000000018c0a7824ULL, 0x000fe200078e0217ULL, 0x0000009283147211ULL, 0x008fe200078fe0ffULL,
0x0000000117167824ULL, 0x000fe200078e0292ULL, 0x0000008c83087211ULL, 0x000fe200078fe0ffULL,
0x000060000a0a7625ULL, 0x000fe200078e007dULL, 0x000000206a807812ULL, 0x000fc600078efcffULL,
0x0000600014147625ULL, 0x080fe200078e007dULL, 0x000000080a7a7981ULL, 0x0002e6000c1e9500ULL,
0x00000001177e7824ULL, 0x040fe200078e0294ULL, 0x0000000814757981ULL, 0x0002e2000c1e9500ULL,
0x0000000117847824ULL, 0x000fe400078e0296ULL, 0x0000600008087625ULL, 0x000fe200078e007dULL,
0x0000580080827a10ULL, 0x000fc60007ffe0ffULL, 0x0000600016167625ULL, 0x080fe200078e007dULL,
0x0000000808737981ULL, 0x0002e6000c1e9500ULL, 0x00000001600a7824ULL, 0x002fe200078e0280ULL,
0x00000008167c7981ULL, 0x0002e6000c1e9500ULL, 0x000000010a147824ULL, 0x100fe200078e0a67ULL,
0x00000094835a7211ULL, 0x040fe400078fe0ffULL, 0x0000009683687211ULL, 0x000fe200078fe0ffULL,
0x0000000182087824ULL, 0x000fe200078e0a67ULL, 0x0000001461147217ULL, 0x000fe20003800000ULL,
0x000060007e7e7625ULL, 0x000fe200078e007dULL, 0x000000678200720cULL, 0x000fc40003f06070ULL,
0x0000000861087217ULL, 0x000fe20003800000ULL, 0x0000600084847625ULL, 0x000fe200078e007dULL,
0x000000670a00720cULL, 0x000fe20003f26070ULL, 0x000000087e7e7981ULL, 0x0002e2000c1e9500ULL,
0x00000004ff147819ULL, 0x000fe20000011614ULL, 0x000060005a5a7625ULL, 0x000fc800078e007dULL,
0x0000600068687625ULL, 0x000fe200078e007dULL, 0x000000ff08897207ULL, 0x000fe20000000000ULL,
0x000000085a777981ULL, 0x0002e2000c1e9500ULL, 0x000000ff140b7207ULL, 0x000fc60000800000ULL,
0x0000000868797981ULL, 0x0002e8000c1e9500ULL, 0x0000000884847981ULL, 0x0002e2000c1e9500ULL,
0x0000008c89087211ULL, 0x000fe200078fe0ffULL, 0x000000010b147824ULL, 0x000fe200078e0292ULL,
0x0000009289687211ULL, 0x002fc600078fe0ffULL, 0x0000600014147625ULL, 0x000fc800078e007dULL,
0x0000600068687625ULL, 0x080fe200078e007dULL, 0x0000000814d27981ULL, 0x0002e6000c1e9500ULL,
0x0000600008087625ULL, 0x080fe200078e007dULL, 0x0000000868817981ULL, 0x0002e6000c1e9500ULL,
0x000000010b887824ULL, 0x000fe200078e0296ULL, 0x00000008087f7981ULL, 0x0002e2000c1e9500ULL,
0x000000018c867824ULL, 0x000fe200078e020bULL, 0x00000094895a7211ULL, 0x000fe200078fe0ffULL,
0x000000010b0a7824ULL, 0x000fe200078e0294ULL, 0x0000009689167211ULL, 0x000fe200078fe0ffULL,
0x0000600086867625ULL, 0x000fc800078e007dULL, 0x0000600088087625ULL, 0x082fe200078e007dULL,
0x000000306a887812ULL, 0x000fe200078efcffULL, 0x0000000886867981ULL, 0x0002e4000c1e9500ULL,
0x000060005a5a7625ULL, 0x080fe200078e007dULL, 0x00005800888a7a10ULL, 0x000fe20007ffe0ffULL,
0x0000000808da7981ULL, 0x0002e4000c1e9500ULL, 0x0000600016167625ULL, 0x080fe400078e007dULL,
0x000000085a857981ULL, 0x0002e4000c1e9500ULL, 0x000060000a0a7625ULL, 0x000fc400078e007dULL,
0x0000000816877981ULL, 0x0022e4000c1e9500ULL, 0x00000001608e7824ULL, 0x000fe400078e0288ULL,
0x000000080ad67981ULL, 0x0002e4000c1e9500ULL, 0x000000018e907824ULL, 0x100fe400078e0a67ULL,
0x000000018a687824ULL, 0x000fc600078e0a67ULL, 0x0000009061907217ULL, 0x040fe40003800000ULL,
0x000000678e00720cULL, 0x080fe40003f26070ULL, 0x000000678a00720cULL, 0x000fe40003f06070ULL,
0x0000006861687217ULL, 0x000fe40003800000ULL, 0x00000004ff907819ULL, 0x000fe40000011690ULL,
0x000000ff688b7207ULL, 0x000fc40000000000ULL, 0x000000ff908d7207ULL, 0x000fe40000800000ULL,
0x0000008c8b5a7211ULL, 0x040fe400078fe0ffULL, 0x000000948b0a7211ULL, 0x002fe200078fe0ffULL,
0x000000018c687824ULL, 0x000fe400078e028dULL, 0x000000018d167824ULL, 0x000fe400078e0294ULL,
0x000060005a5a7625ULL, 0x000fc800078e007dULL, 0x0000600068687625ULL, 0x080fe200078e007dULL,
0x000000085abc7981ULL, 0x0002e6000c1e9500ULL, 0x000060000a0a7625ULL, 0x080fe200078e007dULL,
0x00000008688f7981ULL, 0x0002e6000c1e9500ULL, 0x0000600016167625ULL, 0x000fe200078e007dULL,
0x000000080ad87981ULL, 0x0002e2000c1e9500ULL, 0x000000928b087211ULL, 0x000fc600078fe0ffULL,
0x0000000816937981ULL, 0x0002e2000c1e9500ULL, 0x000000018d147824ULL, 0x000fe400078e0292ULL,
0x0000600008087625ULL, 0x000fc800078e007dULL, 0x0000600014147625ULL, 0x080fe200078e007dULL,
0x0000000808d47981ULL, 0x0002e4000c1e9500ULL, 0x000000968b5a7211ULL, 0x002fe400078fe0ffULL,
0x0000000814917981ULL, 0x0002e2000c1e9500ULL, 0x000000018d687824ULL, 0x000fe400078e0296ULL,
0x000060005a5a7625ULL, 0x000fc800078e007dULL, 0x0000600068687625ULL, 0x000fe200078e007dULL,
0x000000085adc7981ULL, 0x0002e8000c1e9500ULL, 0x0000000868957981ULL, 0x0002e2000c1e9500ULL,
0xfffffff07b087812ULL, 0x000fe200078ec0ffULL, 0x00000001ffd07424ULL, 0x000fc800078e00ffULL,
0x0000000167097824ULL, 0x000fc800078e0208ULL, 0x000000016c087824ULL, 0x000fe200078e0a09ULL,
0x000000016a8c7812ULL, 0x000fc800078efcffULL, 0x00000008d0087219ULL, 0x000fe400000006ffULL,
0x000058008c0a7a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff083147812ULL, 0x002fc600078ec0ffULL,
0x000000010a0b7824ULL, 0x100fe200078e0a09ULL, 0x000000086a8e7812ULL, 0x040fe200078efcffULL,
0x0000000167177824ULL, 0x000fe200078e0214ULL, 0x000000096a907812ULL, 0x000fe400078efcffULL,
0x0000000bd0147219ULL, 0x000fe400000006ffULL, 0x000058008e167a10ULL, 0x000fe40007ffe0ffULL,
0x0000580090687a10ULL, 0x000fe40007ffe0ffULL, 0xfffffff0895a7812ULL, 0x000fe200078ec0ffULL,
0x0000000116157824ULL, 0x100fe200078e0a09ULL, 0xfffffff08b927812ULL, 0x000fe200078ec0ffULL,
0x0000000168097824ULL, 0x000fe200078e0a09ULL, 0x000000116a967812ULL, 0x000fe200078efcffULL,
0x00000001675b7824ULL, 0x040fe200078e025aULL, 0x00000015d05a7219ULL, 0x040fe200000006ffULL,
0x0000000167837824ULL, 0x000fe200078e0292ULL, 0x00000009d0927219ULL, 0x000fc400000006ffULL,
0x0000580096987a10ULL, 0x000fe40007ffe0ffULL, 0x000054106b6b7816ULL, 0x004fc8000000006eULL,
0x0000006b08ff7212ULL, 0x000fc800078ac0ffULL, 0x000000676c00720cULL, 0x000fc80002fa1470ULL,
0x000000676a00720cULL, 0x000fe40002fa1070ULL, 0x0000006b14ff7212ULL, 0x000fe4000782c0ffULL,
0xff80000057577808ULL, 0x000fe40002800000ULL, 0x000054106d6d7816ULL, 0x000fc80000000072ULL,
0x0000006d08ff7212ULL, 0x080fe4000784c0ffULL, 0x000054106f6f7816ULL, 0x000fe40000000074ULL,
0x0000006d14ff7212ULL, 0x000fe400078ac0ffULL, 0x0000006f08ff7212ULL, 0x000fe4000788c0ffULL,
0x000000676c00720cULL, 0x0c0fe40001741470ULL, 0x000000676c00720cULL, 0x000fc40002781470ULL,
0x000000670a00720cULL, 0x0c0fe40000f21470ULL, 0x000000670a00720cULL, 0x080fe40002fa1470ULL,
0x000000676a00720cULL, 0x0c0fe40001741070ULL, 0x000000676a00720cULL, 0x080fe40002781070ULL,
0x000000678c00720cULL, 0x0c0fe40000f21070ULL, 0x000000678c00720cULL, 0x000fc40002fa1070ULL,
0x0000541070717816ULL, 0x000fe40000000071ULL, 0xff80000034347808ULL, 0x000fe40001000000ULL,
0xff80000043437808ULL, 0x000fe40002000000ULL, 0xff80000056567808ULL, 0x000fe40000800000ULL,
0xff80000035357808ULL, 0x000fe40002800000ULL, 0x0000006b5aff7212ULL, 0x000fc4000786c0ffULL,
0x0000007108ff7212ULL, 0x000fe4000780c0ffULL, 0x0000006f14ff7212ULL, 0x040fe4000784c0ffULL,
0x0000007114ff7212ULL, 0x000fe4000788c0ffULL, 0x0000006d92ff7212ULL, 0x000fe4000782c0ffULL,
0x0000006f5aff7212ULL, 0x000fe200078ac0ffULL, 0x0000000176097824ULL, 0x100fe200078e0a17ULL,
0x000000676c00720cULL, 0x080fe20000701470ULL, 0x00000001980b7824ULL, 0x000fe200078e0a17ULL,
0x000000670a00720cULL, 0x000fc40001741470ULL, 0x000000670a00720cULL, 0x080fe40002781470ULL,
0x000000671600720cULL, 0x0c0fe40001f61470ULL, 0x000000671600720cULL, 0x080fe40002fa1470ULL,
0x000000676800720cULL, 0x000fe40000f21470ULL, 0x000000186a9c7812ULL, 0x040fe400078efcffULL,
0x000000196aa27812ULL, 0x000fc400078efcffULL, 0x000000676a00720cULL, 0x080fe40000701070ULL,
0x000000678c00720cULL, 0x0c0fe40001741070ULL, 0x000000678c00720cULL, 0x080fe40002781070ULL,
0x000000678e00720cULL, 0x0c0fe40001f61070ULL, 0x000000678e00720cULL, 0x080fe40002fa1070ULL,
0x000000679000720cULL, 0x000fc40000f21070ULL, 0x00000009d0947219ULL, 0x040fe400000006ffULL,
0x0000000bd09a7219ULL, 0x000fe400000006ffULL, 0x0000541073737816ULL, 0x008fe4000000007aULL,
0x0000541075757816ULL, 0x000fe4000000007cULL, 0x000058009c9e7a10ULL, 0x000fe40007ffe0ffULL,
0x00005800a2a47a10ULL, 0x000fc40007ffe0ffULL, 0xff80000024247808ULL, 0x000fe40000000000ULL,
0xff80000042427808ULL, 0x000fe40001000000ULL, 0xff80000027277808ULL, 0x000fe40002000000ULL,
0xff80000055557808ULL, 0x000fe40001800000ULL, 0xff8000002a2a7808ULL, 0x000fe40002800000ULL,
0xff8000002d2d7808ULL, 0x000fc40000800000ULL, 0x0000006d5aff7212ULL, 0x000fe4000780c0ffULL,
0x0000006f92ff7212ULL, 0x000fe4000784c0ffULL, 0x000000715aff7212ULL, 0x080fe4000788c0ffULL,
0x0000007192ff7212ULL, 0x000fe4000786c0ffULL, 0x000000739aff7212ULL, 0x000fe400078ac0ffULL,
0x0000007594ff7212ULL, 0x000fe2000782c0ffULL, 0x000000019e157824ULL, 0x100fe200078e0a17ULL,
0x000000671600720cULL, 0x080fe20000701470ULL, 0x00000001a4177824ULL, 0x000fe200078e0a17ULL,
0x000000671600720cULL, 0x000fc40002781470ULL, 0x000000676800720cULL, 0x0c0fe40001741470ULL,
0x000000676800720cULL, 0x080fe40001f61470ULL, 0x000000677600720cULL, 0x080fe40000f21470ULL,
0x000000679800720cULL, 0x080fe40002fa1470ULL, 0x000000678e00720cULL, 0x0c0fe40000701070ULL,
0x000000678e00720cULL, 0x000fc40002781070ULL, 0x000000679000720cULL, 0x0c0fe40001741070ULL,
0x000000679000720cULL, 0x080fe40001f61070ULL, 0x000000677800720cULL, 0x080fe40000f21070ULL,
0x000000679600720cULL, 0x000fe40002fa1070ULL, 0x00000015d0a07219ULL, 0x040fe400000006ffULL,
0x00000017d0a67219ULL, 0x000fc400000006ffULL, 0x0000541077777816ULL, 0x000fe4000000007eULL,
0x0000541079797816ULL, 0x000fe40000000084ULL, 0xff8000002b2b7808ULL, 0x000fe40000000000ULL,
0xff80000023237808ULL, 0x000fe40002000000ULL, 0xff80000036367808ULL, 0x000fe40001000000ULL,
0xff80000025257808ULL, 0x000fc40001800000ULL, 0xff8000002c2c7808ULL, 0x000fe40000800000ULL,
0xff80000052527808ULL, 0x000fe40002800000ULL, 0x0000007394ff7212ULL, 0x080fe4000780c0ffULL,
0x00000073a0ff7212ULL, 0x000fe4000788c0ffULL, 0x0000007794ff7212ULL, 0x040fe4000784c0ffULL,
0x0000007994ff7212ULL, 0x000fc4000786c0ffULL, 0x000000779aff7212ULL, 0x000fe4000782c0ffULL,
0x00000075a6ff7212ULL, 0x000fe200078ac0ffULL, 0x0000000182697824ULL, 0x000fe200078e0a5bULL,
0x000000677600720cULL, 0x0c0fe40000701470ULL, 0x000000677600720cULL, 0x0c0fe40001741470ULL,
0x000000677600720cULL, 0x080fe40001f61470ULL, 0x000000679800720cULL, 0x000fc40000f21470ULL,
0x000000679e00720cULL, 0x080fe40002781470ULL, 0x00000067a400720cULL, 0x080fe40002fa1470ULL,
0x000000216aaa7812ULL, 0x000fe400078efcffULL, 0x000000677800720cULL, 0x0c0fe40000701070ULL,
0x000000677800720cULL, 0x0c0fe40001741070ULL, 0x000000677800720cULL, 0x000fc40001f61070ULL,
0x000000679600720cULL, 0x080fe40000f21070ULL, 0x000000679c00720cULL, 0x080fe40002781070ULL,
0x00000067a200720cULL, 0x000fe40002fa1070ULL, 0x00000069d0a87219ULL, 0x000fe400000006ffULL,
0x0000541081817816ULL, 0x000fe400000000d2ULL, 0x00005800aaac7a10ULL, 0x000fc40007ffe0ffULL,
0xff80000053537808ULL, 0x000fe40000000000ULL, 0xff80000037377808ULL, 0x000fe40001000000ULL,
0xff80000028287808ULL, 0x000fe40001800000ULL, 0xff80000038387808ULL, 0x000fe40000800000ULL,
0xff80000051517808ULL, 0x000fe40002000000ULL, 0xff80000030307808ULL, 0x000fc40002800000ULL,
0x000000759aff7212ULL, 0x040fe4000780c0ffULL, 0x000000799aff7212ULL, 0x000fe4000784c0ffULL,
0x00000075a0ff7212ULL, 0x000fe4000786c0ffULL, 0x00000077a6ff7212ULL, 0x040fe4000782c0ffULL,
0x00000079a6ff7212ULL, 0x000fe4000788c0ffULL, 0x00000081a8ff7212ULL, 0x000fe200078ac0ffULL,
0x00000001ac7b7824ULL, 0x000fe200078e0a5bULL, 0x000000679800720cULL, 0x000fc40000701470ULL,
0x000000679800720cULL, 0x080fe40001741470ULL, 0x000000679e00720cULL, 0x080fe40001f61470ULL,
0x00000067a400720cULL, 0x0c0fe40000f21470ULL, 0x00000067a400720cULL, 0x080fe40002781470ULL,
0x000000678200720cULL, 0x000fe40002fa1470ULL, 0x000000286ab07812ULL, 0x000fc400078efcffULL,
0x000000296ab67812ULL, 0x000fe400078efcffULL, 0x000000679600720cULL, 0x0c0fe40000701070ULL,
0x000000679600720cULL, 0x080fe40001741070ULL, 0x000000679c00720cULL, 0x080fe40001f61070ULL,
0x00000067a200720cULL, 0x0c0fe40000f21070ULL, 0x00000067a200720cULL, 0x000fc40002781070ULL,
0x000000678000720cULL, 0x000fe40002fa1070ULL, 0x0000007bd0ae7219ULL, 0x000fe400000006ffULL,
0x000054107f7f7816ULL, 0x000fe40000000086ULL, 0x0000541085857816ULL, 0x000fe400000000d6ULL,
0x0000541087877816ULL, 0x000fe400000000daULL, 0x00005800b0b27a10ULL, 0x000fc40007ffe0ffULL,
0x00005800b6b87a10ULL, 0x000fe40007ffe0ffULL, 0xff80000049497808ULL, 0x000fe40000000000ULL,
0xff80000029297808ULL, 0x000fe40001000000ULL, 0xff8000002e2e7808ULL, 0x000fe40001800000ULL,
0xff8000003a3a7808ULL, 0x000fe40000800000ULL, 0xff80000022227808ULL, 0x000fc40002000000ULL,
0xff8000002f2f7808ULL, 0x000fe40002800000ULL, 0x0000006b92ff7212ULL, 0x000fe400078cc0ffULL,
0x00000077a0ff7212ULL, 0x040fe4000780c0ffULL, 0x00000079a0ff7212ULL, 0x000fe4000784c0ffULL,
0x0000007fa8ff7212ULL, 0x040fe4000786c0ffULL, 0x00000085a8ff7212ULL, 0x000fc4000782c0ffULL,
0x00000087a8ff7212ULL, 0x000fe4000788c0ffULL, 0x00000085aeff7212ULL, 0x000fe200078ac0ffULL,
0x00000001b27d7824ULL, 0x100fe200078e0a5bULL, 0x000000676800720cULL, 0x080fe200037c1470ULL,
0x00000001b85b7824ULL, 0x000fe200078e0a5bULL, 0x000000679e00720cULL, 0x0c0fe40000701470ULL,
0x000000679e00720cULL, 0x080fe40001741470ULL, 0x000000678200720cULL, 0x000fc40001f61470ULL,
0x000000678200720cULL, 0x0c0fe40000f21470ULL, 0x000000678200720cULL, 0x080fe40002781470ULL,
0x00000067ac00720cULL, 0x080fe40002fa1470ULL, 0x000000679000720cULL, 0x080fe400037c1070ULL,
0x000000679c00720cULL, 0x0c0fe40000701070ULL, 0x000000679c00720cULL, 0x000fc40001741070ULL,
0x000000678000720cULL, 0x0c0fe40001f61070ULL, 0x000000678000720cULL, 0x0c0fe40000f21070ULL,
0x000000678000720cULL, 0x080fe40002781070ULL, 0x00000067aa00720cULL, 0x000fe40002fa1070ULL,
0x0000007dd0b47219ULL, 0x040fe400000006ffULL, 0x0000005bd0ba7219ULL, 0x000fc400000006ffULL,
0xff80000054547808ULL, 0x000fe40003000000ULL, 0xff80000039397808ULL, 0x000fe40000000000ULL,
0xff80000026267808ULL, 0x000fe40001000000ULL, 0xff80000059597808ULL, 0x000fe40001800000ULL,
0xff8000003b3b7808ULL, 0x000fe40000800000ULL, 0xff80000021217808ULL, 0x000fc40002000000ULL,
0xff8000003c3c7808ULL, 0x000fe40002800000ULL, 0x00000073a6ff7212ULL, 0x000fe400078cc0ffULL,
0x0000007faeff7212ULL, 0x080fe4000780c0ffULL, 0x0000007fb4ff7212ULL, 0x000fe4000784c0ffULL,
0x00000081aeff7212ULL, 0x040fe4000786c0ffULL, 0x00000087aeff7212ULL, 0x000fc4000782c0ffULL,
0x00000081b4ff7212ULL, 0x000fe4000788c0ffULL, 0x00000085baff7212ULL, 0x000fe200078ac0ffULL,
0x000000018a897824ULL, 0x000fe200078e0a83ULL, 0x00000067a400720cULL, 0x080fe400037c1470ULL,
0x00000067ac00720cULL, 0x0c0fe40000701470ULL, 0x00000067ac00720cULL, 0x0c0fe40001f61470ULL,
0x00000067ac00720cULL, 0x000fc40000f21470ULL, 0x00000067b200720cULL, 0x0c0fe40001741470ULL,
0x00000067b200720cULL, 0x080fe40002781470ULL, 0x00000067b800720cULL, 0x000fe40002fa1470ULL,
0x000000316ac07812ULL, 0x040fe400078efcffULL, 0x000000386ac67812ULL, 0x040fe400078efcffULL,
0x000000396acc7812ULL, 0x000fc400078efcffULL, 0x00000067a200720cULL, 0x080fe400037c1070ULL,
0x00000067aa00720cULL, 0x0c0fe40000701070ULL, 0x00000067aa00720cULL, 0x0c0fe40001f61070ULL,
0x00000067aa00720cULL, 0x080fe40000f21070ULL, 0x00000067b000720cULL, 0x0c0fe40001741070ULL,
0x00000067b000720cULL, 0x000fc40002781070ULL, 0x00000067b600720cULL, 0x000fe40002fa1070ULL,
0x00000089d0be7219ULL, 0x000fe400000006ffULL, 0x00005410bc8f7816ULL, 0x000fe4000000008fULL,
0x00005410d8937816ULL, 0x000fe40000000093ULL, 0x00005800c0c27a10ULL, 0x000fe40007ffe0ffULL,
0x00005800c6c87a10ULL, 0x000fc40007ffe0ffULL, 0x00005800ccce7a10ULL, 0x000fe40007ffe0ffULL,
0xff80000058587808ULL, 0x000fe40003000000ULL, 0xff80000050507808ULL, 0x000fe40000000000ULL,
0xff80000048487808ULL, 0x000fe40001800000ULL, 0xff80000020207808ULL, 0x000fe40000800000ULL,
0xff8000004f4f7808ULL, 0x000fc40001000000ULL, 0xff80000031317808ULL, 0x000fe40002000000ULL,
0xff8000003e3e7808ULL, 0x000fe40002800000ULL, 0x0000007fbaff7212ULL, 0x040fe400078cc0ffULL,
0x00000081baff7212ULL, 0x000fe4000780c0ffULL, 0x00000085b4ff7212ULL, 0x040fe4000786c0ffULL,
0x00000087b4ff7212ULL, 0x000fc4000782c0ffULL, 0x00000087baff7212ULL, 0x000fe4000784c0ffULL,
0x0000008fbeff7212ULL, 0x040fe4000788c0ffULL, 0x00000093beff7212ULL, 0x000fe200078ac0ffULL,
0x00000001c28b7824ULL, 0x100fe200078e0a83ULL, 0x00000067b200720cULL, 0x080fe20001f61470ULL,
0x00000001c88d7824ULL, 0x100fe200078e0a83ULL, 0x00000067b200720cULL, 0x080fe20000f21470ULL,
0x00000001ce837824ULL, 0x000fe200078e0a83ULL, 0x00000067b800720cULL, 0x000fc400037c1470ULL,
0x00000067b800720cULL, 0x0c0fe40000701470ULL, 0x00000067b800720cULL, 0x080fe40001741470ULL,
0x000000678a00720cULL, 0x0c0fe40002781470ULL, 0x000000678a00720cULL, 0x000fe40002fa1470ULL,
0x0000008bd0c47219ULL, 0x040fe400000006ffULL, 0x0000008dd0ca7219ULL, 0x000fc400000006ffULL,
0x00000067b000720cULL, 0x0c0fe40001f61070ULL, 0x00000067b000720cULL, 0x080fe40000f21070ULL,
0x00000067b600720cULL, 0x0c0fe400037c1070ULL, 0x00000067b600720cULL, 0x0c0fe40000701070ULL,
0x00000067b600720cULL, 0x080fe40001741070ULL, 0x000000678800720cULL, 0x000fc40002781070ULL,
0x000000678800720cULL, 0x000fe40002fa1070ULL, 0x00000083d0d07219ULL, 0x000fe400000006ffULL,
0x00005410d4917816ULL, 0x000fe40000000091ULL, 0xff8000003d3d7808ULL, 0x000fe40001800000ULL,
0xff8000001a1a7808ULL, 0x000fe40000800000ULL, 0xff8000004e4e7808ULL, 0x000fc40003000000ULL,
0xff8000003f3f7808ULL, 0x000fe40000000000ULL, 0xff8000001b1b7808ULL, 0x000fe40001000000ULL,
0xff8000004d4d7808ULL, 0x000fe40002000000ULL, 0xff80000047477808ULL, 0x000fe40002800000ULL,
0x0000008fc4ff7212ULL, 0x080fe4000786c0ffULL, 0x0000008fcaff7212ULL, 0x000fc4000782c0ffULL,
0x0000008fd0ff7212ULL, 0x000fe400078cc0ffULL, 0x00000091beff7212ULL, 0x080fe4000780c0ffULL,
0x00000091c4ff7212ULL, 0x080fe4000784c0ffULL, 0x00000091caff7212ULL, 0x000fe4000788c0ffULL,
0x00000093c4ff7212ULL, 0x000fe400078ac0ffULL, 0x000000678a00720cULL, 0x000fc40000701470ULL,
0x00000067c200720cULL, 0x0c0fe40001f61470ULL, 0x00000067c200720cULL, 0x0c0fe40001741470ULL,
0x00000067c200720cULL, 0x080fe40002fa1470ULL, 0x00000067c800720cULL, 0x080fe40000f21470ULL,
0x00000067ce00720cULL, 0x080fe400037c1470ULL, 0x00000067c800720cULL, 0x000fc40002781470ULL,
0x000000678800720cULL, 0x080fe40000701070ULL, 0x00000067c000720cULL, 0x0c0fe40001f61070ULL,
0x00000067c000720cULL, 0x0c0fe40001741070ULL, 0x00000067c000720cULL, 0x080fe40002fa1070ULL,
0x00000067c600720cULL, 0x080fe40000f21070ULL, 0x00000067cc00720cULL, 0x000fc400037c1070ULL,
0x00000067c600720cULL, 0x000fe40002781070ULL, 0x00005410dc957816ULL, 0x000fe40000000095ULL,
0xff80000032327808ULL, 0x000fe40000000000ULL, 0xff8000004c4c7808ULL, 0x000fe40001800000ULL,
0xff80000033337808ULL, 0x000fe40001000000ULL, 0xff80000040407808ULL, 0x000fc40002800000ULL,
0xff8000004b4b7808ULL, 0x000fe40000800000ULL, 0xff8000004a4a7808ULL, 0x000fe40003000000ULL,
0xff80000046467808ULL, 0x000fe40002000000ULL, 0x00000091d0ff7212ULL, 0x000fe4000780c0ffULL,
0x00000093caff7212ULL, 0x080fe4000786c0ffULL, 0x00000093d0ff7212ULL, 0x000fc4000784c0ffULL,
0x00000095beff7212ULL, 0x080fe400078ac0ffULL, 0x00000095c4ff7212ULL, 0x080fe4000782c0ffULL,
0x00000095caff7212ULL, 0x080fe400078cc0ffULL, 0x00000095d0ff7212ULL, 0x000fe4000788c0ffULL,
0x000000678a00720cULL, 0x080fe40002fa1470ULL, 0x00000067c200720cULL, 0x000fc40000f21470ULL,
0x00000067c800720cULL, 0x0c0fe40001f61470ULL, 0x00000067c800720cULL, 0x080fe400037c1470ULL,
0x00000067ce00720cULL, 0x0c0fe40000701470ULL, 0x00000067ce00720cULL, 0x0c0fe40001741470ULL,
0x00000067ce00720cULL, 0x080fe40002781470ULL, 0x000000678800720cULL, 0x000fc40002fa1070ULL,
0x00000067c000720cULL, 0x080fe40000f21070ULL, 0x00000067cc00720cULL, 0x080fe40000701070ULL,
0x00000067c600720cULL, 0x0c0fe40001f61070ULL, 0x00000067c600720cULL, 0x080fe400037c1070ULL,
0x00000067cc00720cULL, 0x0c0fe40001741070ULL, 0x00000067cc00720cULL, 0x000fc40002781070ULL,
0xff80000045457808ULL, 0x000fe40000000000ULL, 0xff80000041417808ULL, 0x000fe40001800000ULL,
0xff80000044447808ULL, 0x000fe40001000000ULL, 0xff8000001c1c7808ULL, 0x000fe40002800000ULL,
0xff8000001d1d7808ULL, 0x000fe40000800000ULL, 0xff8000001e1e7808ULL, 0x000fc40003000000ULL,
0xff8000001f1f7808ULL, 0x000fc40002000000ULL, 0x000000570400720bULL, 0x004fe40003f1e000ULL,
0x000000340500720bULL, 0x000fe40003f3e000ULL, 0x000000430600720bULL, 0x000fe40003f5e000ULL,
0x000000240700720bULL, 0x000fe40003f7e000ULL, 0x0000000457097208ULL, 0x000fe40004000000ULL,
0x0000000534047208ULL, 0x000fc40004800000ULL, 0x0000000643057208ULL, 0x000fe40005000000ULL,
0x0000000724067208ULL, 0x000fe40005800000ULL, 0x000000560900720bULL, 0x000fe40003f1e000ULL,
0x000000350400720bULL, 0x000fe40003f3e000ULL, 0x000000420500720bULL, 0x000fe40003f5e000ULL,
0x000000270600720bULL, 0x000fc40003f7e000ULL, 0x0000000956087208ULL, 0x000fe40004000000ULL,
0x0000000435047208ULL, 0x000fe40004800000ULL, 0x0000000542057208ULL, 0x000fe40005000000ULL,
0x0000000627067208ULL, 0x000fe40005800000ULL, 0x000000550800720bULL, 0x000fe40003f1e000ULL,
0x0000002b0400720bULL, 0x000fc40003f3e000ULL, 0x0000002a0500720bULL, 0x000fe40003f5e000ULL,
0x000000230600720bULL, 0x000fe40003f7e000ULL, 0x0000000855077208ULL, 0x000fe40004000000ULL,
0x000000042b047208ULL, 0x000fe40004800000ULL, 0x000000052a057208ULL, 0x000fe40005000000ULL,
0x0000000623067208ULL, 0x000fc40005800000ULL, 0x000000540700720bULL, 0x000fe40003f1e000ULL,
0x0000002d0400720bULL, 0x000fe40003f3e000ULL, 0x000000360500720bULL, 0x000fe40003f5e000ULL,
0x000000250600720bULL, 0x000fe40003f7e000ULL, 0x0000000754087208ULL, 0x000fe40004000000ULL,
0x000000042d077208ULL, 0x000fc40004800000ULL, 0x0000000536047208ULL, 0x000fe40005000000ULL,
0x0000000625057208ULL, 0x000fe40005800000ULL, 0x000000530800720bULL, 0x000fe40003f1e000ULL,
0x0000002c0700720bULL, 0x000fe40003f3e000ULL, 0x000000370400720bULL, 0x000fe40003f5e000ULL,
0x000000280500720bULL, 0x000fc40003f7e000ULL, 0x0000000853097208ULL, 0x000fe40004000000ULL,
0x000000072c067208ULL, 0x000fe40004800000ULL, 0x0000000437077208ULL, 0x000fe40005000000ULL,
0x0000000528047208ULL, 0x000fe40005800000ULL, 0x000000520900720bULL, 0x000fe40003f1e000ULL,
0x000000490600720bULL, 0x000fc40003f3e000ULL, 0x000000380700720bULL, 0x000fe40003f5e000ULL,
0x000000290400720bULL, 0x000fe40003f7e000ULL, 0x0000000952087208ULL, 0x000fe40004000000ULL,
0x0000000649057208ULL, 0x000fe40004800000ULL, 0x0000000738067208ULL, 0x000fe40005000000ULL,
0x0000000429077208ULL, 0x000fc40005800000ULL, 0x000000510800720bULL, 0x000fe40003f1e000ULL,
0x0000002e0500720bULL, 0x000fe40003f3e000ULL, 0x000000390600720bULL, 0x000fe40003f5e000ULL,
0x000000260700720bULL, 0x000fe40003f7e000ULL, 0x0000000851097208ULL, 0x000fe40004000000ULL,
0x000000052e057208ULL, 0x000fc40004800000ULL, 0x00000006390b7208ULL, 0x000fe40005000000ULL,
0x0000000726077208ULL, 0x000fe40005800000ULL, 0x000000580900720bULL, 0x000fe40003f1e000ULL,
0x000000300500720bULL, 0x000fe40003f3e000ULL, 0x0000003a0b00720bULL, 0x000fe40003f5e000ULL,
0x000000220700720bULL, 0x000fc40003f7e000ULL, 0x0000000958047208ULL, 0x000fe40004000000ULL,
0x0000000530067208ULL, 0x000fe40004800000ULL, 0x0000000b3a087208ULL, 0x000fe40005000000ULL,
0x00000007220a7208ULL, 0x000fe40005800000ULL, 0x000000590400720bULL, 0x000fe40003f1e000ULL,
0x0000002f0600720bULL, 0x000fc40003f3e000ULL, 0x0000003b0800720bULL, 0x000fe40003f5e000ULL,
0x000000210a00720bULL, 0x000fe40003f7e000ULL, 0x0000000459057208ULL, 0x000fe40004000000ULL,
0x000000062f077208ULL, 0x000fe40004800000ULL, 0x000000083b097208ULL, 0x000fe40005000000ULL,
0x0000000a210b7208ULL, 0x000fc40005800000ULL, 0x000000500500720bULL, 0x000fe40003f1e000ULL,
0x000000480700720bULL, 0x000fe40003f3e000ULL, 0x0000003c0900720bULL, 0x000fe40003f5e000ULL,
0x000000200b00720bULL, 0x000fe40003f7e000ULL, 0x0000000550047208ULL, 0x000fe40004000000ULL,
0x0000000748067208ULL, 0x000fc40004800000ULL, 0x000000093c087208ULL, 0x000fe40005000000ULL,
0x0000000b200b7208ULL, 0x000fe40005800000ULL, 0x0000004f0400720bULL, 0x000fe40003f1e000ULL,
0x000000310600720bULL, 0x000fe40003f3e000ULL, 0x0000003d0800720bULL, 0x000fe40003f5e000ULL,
0x0000001a0b00720bULL, 0x000fc40003f7e000ULL, 0x000000044f057208ULL, 0x000fe40004000000ULL,
0x0000000631067208ULL, 0x000fe40004800000ULL, 0x000000083d077208ULL, 0x000fe40005000000ULL,
0x0000000b1a047208ULL, 0x000fe40005800000ULL, 0x0000004e0500720bULL, 0x000fe40003f1e000ULL,
0x0000003f0600720bULL, 0x000fc40003f3e000ULL, 0x0000003e0700720bULL, 0x000fe40003f5e000ULL,
0x0000001b0400720bULL, 0x000fe40003f7e000ULL, 0x000000054e087208ULL, 0x000fe40004000000ULL,
0x000000063f057208ULL, 0x000fe40004800000ULL, 0x000000073e067208ULL, 0x000fe40005000000ULL,
0x000000041b077208ULL, 0x000fc40005800000ULL, 0x000000320500720bULL, 0x000fe40003f3e000ULL,
0x000000470600720bULL, 0x000fe40003f5e000ULL, 0x0000004d0800720bULL, 0x000fe40003f1e000ULL,
0x0000001c0700720bULL, 0x000fe40003f7e000ULL, 0x0000000532047208ULL, 0x000fe40004800000ULL,
0x0000000647057208ULL, 0x000fc40005000000ULL, 0x000000084d097208ULL, 0x000fe40004000000ULL,
0x000000071c067208ULL, 0x000fe40005800000ULL, 0x000000330400720bULL, 0x000fe40003f3e000ULL,
0x000000400500720bULL, 0x000fe40003f5e000ULL, 0x0000004c0900720bULL, 0x000fe40003f1e000ULL,
0x0000001d0600720bULL, 0x000fc40003f7e000ULL, 0x0000000433077208ULL, 0x000fe40004800000ULL,
0x0000000540047208ULL, 0x000fe40005000000ULL, 0x000000094c087208ULL, 0x000fe40004000000ULL,
0x000000061d057208ULL, 0x000fe40005800000ULL, 0x000000460700720bULL, 0x000fe40003f3e000ULL,
0x000000410400720bULL, 0x000fc40003f5e000ULL, 0x0000004b0800720bULL, 0x000fe40003f1e000ULL,
0x0000001e0500720bULL, 0x000fe40003f7e000ULL, 0x0000000746067208ULL, 0x000fe40004800000ULL,
0x0000000441077208ULL, 0x000fe40005000000ULL, 0x000000084b097208ULL, 0x000fe40004000000ULL,
0x000000051e047208ULL, 0x000fc40005800000ULL, 0x0000004a0900720bULL, 0x000fe40003f1e000ULL,
0x000000450600720bULL, 0x000fe40003f3e000ULL, 0x000000440700720bULL, 0x000fe40003f5e000ULL,
0x0000001f0400720bULL, 0x000fe40003f7e000ULL, 0x000000094a057208ULL, 0x000fe40004000000ULL,
0x00000006450a7208ULL, 0x000fc40004800000ULL, 0x0000000744167208ULL, 0x000fe40005000000ULL,
0x000000041f157208ULL, 0x000fe20005800000ULL, 0x000024827f007947ULL, 0x000fea000b800000ULL,
0x0c401f0005047f89ULL, 0x0004e400000e0000ULL, 0x000000040500720bULL, 0x008fc80003f1e000ULL,
0x0000000504177208ULL, 0x000fe20004000000ULL, 0x000024c27f007947ULL, 0x000fea000b800000ULL,
0x0c401f000a047f89ULL, 0x000ee800000e0000ULL, 0x0c401f0016057f89ULL, 0x004ea800000e0000ULL,
0x0c401f0015067f89ULL, 0x000e6200000e0000ULL, 0x000000040a00720bULL, 0x008fc40003f1e000ULL,
0x000000051600720bULL, 0x004fe40003f3e000ULL, 0x0000000a04077208ULL, 0x002fe40004000000ULL,
0x0000001605087208ULL, 0x000fe20004800000ULL, 0x0c201f0017047f89ULL, 0x000e6200000e0000ULL,
0x000000061500720bULL, 0x000fc60003f1e000ULL, 0x0c201f0007147f89ULL, 0x000ea200000e0000ULL,
0x00000015060a7208ULL, 0x000fc60004000000ULL, 0x0c201f0008097f89ULL, 0x000ee800000e0000ULL,
0x0c201f000a0b7f89ULL, 0x0002e400000e0000ULL, 0x000000041700720bULL, 0x002fe40003f1e000ULL,
0x000000140700720bULL, 0x004fe40003f3e000ULL, 0x0000001704047208ULL, 0x000fc40004000000ULL,
0x000000090800720bULL, 0x008fe40003f5e000ULL, 0x0000000714057208ULL, 0x000fe40004800000ULL,
0x0000000809067208ULL, 0x000fc40005000000ULL, 0x3fb8aa3b04077820ULL, 0x002fe20000410000ULL,
0x0000000b0a00720bULL, 0x004fe20003f1e000ULL, 0xffffffff00007948ULL, 0x000fe20003800000ULL,
0x00000002ff687819ULL, 0x000fe20000011611ULL, 0x3fb8aa3b57577823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b51147823ULL, 0x000fc40000010807ULL, 0x0000005700087308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b56567823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b55557823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b54547823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b53537823ULL, 0x100fe20000010807ULL,
0x0000001400577308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b52527823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b58587823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b59517823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b50507823ULL, 0x100fe20000010807ULL, 0x0000005600097308ULL, 0x000ea20000000800ULL,
0x3fb8aa3b4f4f7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b4e4e7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b4d4d7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b4c4c7823ULL, 0x100fe20000010807ULL,
0x0000005500557308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b4b4b7823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b4a4a7823ULL, 0x000fe40000010807ULL, 0x3fb8aa3b06077820ULL, 0x000fe40000410000ULL,
0x3fb8aa3b05147820ULL, 0x002fe20000410000ULL, 0x0000005400547308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b43437823ULL, 0x100fe20000010807ULL, 0x000000080908723eULL, 0x004fe200000000ffULL,
0x3fb8aa3b42427823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b2a2a7823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b36367823ULL, 0x100fe20000010807ULL, 0x0000004300437308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b37377823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b38387823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b39397823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b3a3a7823ULL, 0x100fe20000010807ULL,
0x0000002a002a7308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b3b3b7823ULL, 0x000fc40000010807ULL,
0x3fb8aa3b3c3c7823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b3d3d7823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b3e3e7823ULL, 0x100fe20000010807ULL, 0x0000003600157308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b47477823ULL, 0x100fe40000010807ULL, 0x3fb8aa3b40407823ULL, 0x100fe40000010807ULL,
0x3fb8aa3b41417823ULL, 0x000fc40000010807ULL, 0x3fb8aa3b44447823ULL, 0x000fe20000010807ULL,
0x0000000a0b077208ULL, 0x000fe20004000000ULL, 0x3fb8aa3b2d2d7823ULL, 0x100fe20000010814ULL,
0x0000004200427308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b2b2b7823ULL, 0x100fe20000010814ULL,
0x00000002680b7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b34347823ULL, 0x100fe20000010814ULL,
0x00000001680a7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b35357823ULL, 0x100fe20000010814ULL,
0x0000000311ff7812ULL, 0x000fe2000780c0ffULL, 0x3fb8aa3b30307823ULL, 0x100fe20000010814ULL,
0x0000002d00167308ULL, 0x0003e20000000800ULL, 0x3fb8aa3b32327823ULL, 0x000fc40000010814ULL,
0x3fb8aa3b2c2c7823ULL, 0x100fe40000010814ULL, 0x3fb8aa3b49497823ULL, 0x100fe40000010814ULL,
0x3fb8aa3b2e2e7823ULL, 0x100fe20000010814ULL, 0x0000002b002b7308ULL, 0x000fe20000000800ULL,
0x3fb8aa3b072d7820ULL, 0x002fe40000410000ULL, 0x3fb8aa3b2f2f7823ULL, 0x000fe40000010814ULL,
0x3fb8aa3b23237823ULL, 0x000fc4000001082dULL, 0x3fb8aa3b48487823ULL, 0x100fe20000010814ULL,
0x0000003400347308ULL, 0x000fe20000000800ULL, 0x3fb8aa3b31317823ULL, 0x100fe40000010814ULL,
0x3fb8aa3b3f3f7823ULL, 0x100fe40000010814ULL, 0x3fb8aa3b33337823ULL, 0x100fe40000010814ULL,
0x3fb8aa3b46467823ULL, 0x000fe20000010814ULL, 0x0000003500357308ULL, 0x000e620000000800ULL,
0x3fb8aa3b24247823ULL, 0x000fc4000001082dULL, 0x3fb8aa3b27277823ULL, 0x100fe4000001082dULL,
0x3fb8aa3b45147823ULL, 0x000fe40000010814ULL, 0x3fb8aa3b25257823ULL, 0x000fe2000001082dULL,
0x0000003000597308ULL, 0x000fe20000000800ULL, 0x00000008686d7824ULL, 0x040fe400078e00ffULL,
0x0000000868697824ULL, 0x040fe400078e00ffULL, 0x0000000868737824ULL, 0x000fc400078e00ffULL,
0x00000008686f7824ULL, 0x040fe200078e00ffULL, 0x00000032005a7308ULL, 0x000fe20000000800ULL,
0xfffffff869697812ULL, 0x000fe200078ee20aULL, 0x0000000868757824ULL, 0x040fe200078e00ffULL,
0x00000004680a7810ULL, 0x000fe20007ffe0ffULL, 0x3fb8aa3b26267823ULL, 0x000fe2000001082dULL,
0x000000343509723eULL, 0x002fe200000000ffULL, 0x3c003c00ff347424ULL, 0x000fe200078e00ffULL,
0xfffffff86f6f7812ULL, 0x000fe200078ee20aULL, 0x0000002400177308ULL, 0x0003e20000000800ULL,
0x00000055540a723eULL, 0x000fe200000000ffULL, 0x3c003c00ff357424ULL, 0x000fc400078e00ffULL,
0x3fb8aa3b28287823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b29297823ULL, 0x100fe4000001082dULL,
0x0000002700307308ULL, 0x000ea20000000800ULL, 0x0000000868247824ULL, 0x002fe400078e00ffULL,
0x3fb8aa3b22227823ULL, 0x100fe4000001082dULL, 0x3fb8aa3b21217823ULL, 0x000fe2000001082dULL,
0xfffffff8246b7812ULL, 0x000fe200078ee20bULL, 0x3fb8aa3b1e557823ULL, 0x100fe2000001082dULL,
0x0000001400457308ULL, 0x0003e20000000800ULL, 0x00000005680b7810ULL, 0x000fe20007ffe0ffULL,
0x3fb8aa3b1f677823ULL, 0x000fc4000001082dULL, 0x3fb8aa3b1a1a7823ULL, 0x000fe2000001082dULL,
0xfffffff824717812ULL, 0x000fe400078ee20bULL, 0x0000002b160b723eULL, 0x000fe200000000ffULL,
0x0000002300237308ULL, 0x000fe20000000800ULL, 0x0000000368147810ULL, 0x042fe40007ffe0ffULL,
0x0000002a1516723eULL, 0x000fe400000000ffULL, 0xfffffff86d6d7812ULL, 0x000fe400078ee214ULL,
0x0000000668147810ULL, 0x000fe20007ffe0ffULL, 0x0000002500327308ULL, 0x000e620000000800ULL,
0x000000173015723eULL, 0x004fe200000000ffULL, 0x3fb8aa3b1b307823ULL, 0x000fe2000001082dULL,
0xfffffff873737812ULL, 0x000fc400078ee214ULL, 0xffffffff68147810ULL, 0x000fc60007ffe0ffULL,
0x0000003f00567308ULL, 0x000fe20000000800ULL, 0xfffffff875757812ULL, 0x000fe400078ee214ULL,
0x000000434214723eULL, 0x000fe200000000ffULL, 0x3fb8aa3b1d437823ULL, 0x000fe2000001082dULL,
0x000000233217723eULL, 0x002fc600000000ffULL, 0x00000026005b7308ULL, 0x0003e20000000800ULL,
0x3fb8aa3b1c327823ULL, 0x000fce000001082dULL, 0x0000002800367308ULL, 0x000fe20000000800ULL,
0x000000340824723cULL, 0x082f6e00000018ffULL, 0x00000029003f7308ULL, 0x0003f00000000800ULL,
0x0000005300537308ULL, 0x000fe20000000800ULL, 0x000000341428723cULL, 0x002f6e00000018ffULL,
0x0000005200527308ULL, 0x000e700000000800ULL, 0x0000005800587308ULL, 0x000eb00000000800ULL,
0x0000002c002c7308ULL, 0x000fe20000000800ULL, 0x00000053521c723eULL, 0x002fc400000000ffULL,
0x0000000868537810ULL, 0x000fca0007ffe0ffULL, 0x0000004900497308ULL, 0x000e620000000800ULL,
0x00000057581e723eULL, 0x004fe400000000ffULL, 0x0000001068577810ULL, 0x000fca0007ffe0ffULL,
0x0000002e002e7308ULL, 0x000eb00000000800ULL, 0x0000003700377308ULL, 0x000fe20000000800ULL,
0x0000002c491d723eULL, 0x002fe200000000ffULL, 0x00000008532c7824ULL, 0x000fc400078e00ffULL,
0x0000000868497824ULL, 0x000fc600078e00ffULL, 0xfffffff82c537812ULL, 0x000fe200078ee253ULL,
0x0000003800387308ULL, 0x000e620000000800ULL, 0x0000002e591f723eULL, 0x004fe200000000ffULL,
0x00000008572e7824ULL, 0x000fe200078e00ffULL, 0x0000001868597810ULL, 0x000fe40007ffe0ffULL,
0xfffffff849497812ULL, 0x000fe400078ee268ULL, 0xfffffff82e577812ULL, 0x000fe200078ee257ULL,
0x0000003900397308ULL, 0x000fe20000000800ULL, 0x000000341c24723cULL, 0x020f6e0000001824ULL,
0x0000003a003a7308ULL, 0x000ff00000000800ULL, 0x0000002200547308ULL, 0x0004f00000000800ULL,
0x0000002100427308ULL, 0x0007e20000000800ULL, 0x3fb8aa3b20227823ULL, 0x004fe2000001082dULL,
0x000000373820723eULL, 0x002fe200000000ffULL, 0x0000000859387824ULL, 0x000fca00078e00ffULL,
0x00000022001b7308ULL, 0x0002a20000000800ULL, 0x000000363f21723eULL, 0x008fe400000000ffULL,
0x0000005b5423723eULL, 0x000fe400000000ffULL, 0xfffffff838597812ULL, 0x000fc600078ee259ULL,
0x0000002f002f7308ULL, 0x000fe20000000800ULL, 0x000000393a22723eULL, 0x002fce00000000ffULL,
0x0000004800487308ULL, 0x000e620000000800ULL, 0x000000342028723cULL, 0x000f620000001828ULL,
0x000000421b39723eULL, 0x004fe400000000ffULL, 0x0000000c19427812ULL, 0x000fc800078ec0ffULL,
0x0000005100517308ULL, 0x000ff00000000800ULL, 0x0000005000507308ULL, 0x000ea20000000800ULL,
0x0000002f482d723eULL, 0x002fce00000000ffULL, 0x0000004f004f7308ULL, 0x000ff00000000800ULL,
0x0000004e004e7308ULL, 0x000e620000000800ULL, 0x00000051502c723eULL, 0x004fce00000000ffULL,
0x0000003100317308ULL, 0x000eb00000000800ULL, 0x0000003b003b7308ULL, 0x000fe20000000800ULL,
0x0000004f4e2e723eULL, 0x002fce00000000ffULL, 0x0000003c003c7308ULL, 0x000e620000000800ULL,
0x00000031562f723eULL, 0x004fce00000000ffULL, 0x0000003d003d7308ULL, 0x000fe20000000800ULL,
0x000000342c24723cULL, 0x020f6e0000001824ULL, 0x0000003e003e7308ULL, 0x000ea20000000800ULL,
0x0000003b3c38723eULL, 0x002fe400000000ffULL, 0x00012000123c7811ULL, 0x000fca00078e60ffULL,
0x0000001a001a7308ULL, 0x000fe20000000800ULL, 0x0000001049497824ULL, 0x100fe400078e023cULL,
0x0000001069697824ULL, 0x100fe400078e023cULL, 0x000000106b6b7824ULL, 0x100fe400078e023cULL,
0x000000106d6d7824ULL, 0x100fe200078e023cULL, 0x0000003000377308ULL, 0x000e620000000800ULL,
0x0000003d3e3a723eULL, 0x004fe200000000ffULL, 0x000000106f6f7824ULL, 0x000fc400078e023cULL,
0x0000001071717824ULL, 0x100fe400078e023cULL, 0x0000001073737824ULL, 0x000fe400078e023cULL,
0x0000003300337308ULL, 0x000ea20000000800ULL, 0x0000000149497824ULL, 0x000fe400078e0242ULL,
0x0000001075757824ULL, 0x100fe400078e023cULL, 0x0000001053537824ULL, 0x100fe200078e023cULL,
0x0000000849007388ULL, 0x0007e20000000800ULL, 0x0000001057577824ULL, 0x100fe200078e023cULL,
0x0000001a373b723eULL, 0x002fe200000000ffULL, 0x0000004d004d7308ULL, 0x000fe20000000800ULL,
0x0000001059597824ULL, 0x000fc400078e023cULL, 0x0000000142697824ULL, 0x040fe400078e0269ULL,
0x00000001426b7824ULL, 0x040fe200078e026bULL, 0x000000343828723cULL, 0x000fe20000001828ULL,
0x0000005a3331723eULL, 0x004fe200000000ffULL, 0x0000004c004c7308ULL, 0x000e620000000800ULL,
0x00000001426d7824ULL, 0x040fe200078e026dULL, 0x0000000a69007388ULL, 0x0005e20000000800ULL,
0x00000001426f7824ULL, 0x040fe400078e026fULL, 0x0000000142717824ULL, 0x040fe200078e0271ULL,
0x0000001c6b007388ULL, 0x0005e20000000800ULL, 0x0000000142737824ULL, 0x040fe200078e0273ULL,
0x0000004b004b7308ULL, 0x000fe20000000800ULL, 0x0000000142757824ULL, 0x040fe200078e0275ULL,
0x0000001e6d007388ULL, 0x0005e20000000800ULL, 0x0000000142087824ULL, 0x008fc400078e0253ULL,
0x0000000142577824ULL, 0x040fe200078e0257ULL, 0x0000002c6f007388ULL, 0x0005e20000000800ULL,
0x0000000142427824ULL, 0x000fe200078e0259ULL, 0x0000004a004a7308ULL, 0x000fe20000000800ULL,
0x0000004d4c30723eULL, 0x002fe200000000ffULL, 0x0000002e71007388ULL, 0x0005e80000000800ULL,
0x0000003073007388ULL, 0x0005e40000000800ULL, 0x0000004600467308ULL, 0x000e700000000800ULL,
0x0000004700477308ULL, 0x000ff00000000800ULL, 0x0000004000407308ULL, 0x000ee20000000800ULL,
0x000000464533723eULL, 0x002fce00000000ffULL, 0x0000004100417308ULL, 0x000ff00000000800ULL,
0x0000004400447308ULL, 0x000e620000000800ULL, 0x00000047403c723eULL, 0x008fce00000000ffULL,
0x0000003200367308ULL, 0x0007f00000000800ULL, 0x0000004300437308ULL, 0x000ea20000000800ULL,
0x0000004b4a32723eULL, 0x008fe400000000ffULL, 0x00000041443e723eULL, 0x002fc600000000ffULL,
0x0000003275007388ULL, 0x0003e40000000800ULL, 0x00000055003f7308ULL, 0x000fe20000000800ULL,
0x000000343024723cULL, 0x020f620000001824ULL, 0x0000000908007388ULL, 0x0003e80000000800ULL,
0x0004000b69007388ULL, 0x0003e40000000800ULL, 0x00000067001a7308ULL, 0x000ee20000000800ULL,
0x00000036433d723eULL, 0x004fe200000000ffULL, 0x0004001d6b007388ULL, 0x0003e80000000800ULL,
0x0004001f6d007388ULL, 0x0003e80000000800ULL, 0x0004002d6f007388ULL, 0x0003e80000000800ULL,
0x0004002f71007388ULL, 0x0003e20000000800ULL, 0x0000003f1a3f723eULL, 0x008fc400000000ffULL,
0x000000ffff257224ULL, 0x020fe200078e0026ULL, 0x0004003173007388ULL, 0x0003e80000000800ULL,
0x0004003375007388ULL, 0x0003e20000000800ULL, 0x000000343c28723cULL, 0x000f660000001828ULL,
0x0000001457007388ULL, 0x0003e80000000800ULL, 0x0008001669007388ULL, 0x0003e80000000800ULL,
0x000800206b007388ULL, 0x0003e80000000800ULL, 0x000800226d007388ULL, 0x0003e80000000800ULL,
0x000800386f007388ULL, 0x0003e80000000800ULL, 0x0008003a71007388ULL, 0x0003e20000000800ULL,
0x000000ffff267224ULL, 0x020fc400078e0028ULL, 0x000000ffff277224ULL, 0x000fe200078e002aULL,
0x0008003c73007388ULL, 0x0003e80000000800ULL, 0x0008003e75007388ULL, 0x0003e80000000800ULL,
0x0000001542007388ULL, 0x0003e80000000800ULL, 0x000c001769007388ULL, 0x0003e80000000800ULL,
0x000c00216b007388ULL, 0x0003e80000000800ULL, 0x000c00236d007388ULL, 0x0003e80000000800ULL,
0x000c00396f007388ULL, 0x0003e80000000800ULL, 0x000c003b71007388ULL, 0x0003e80000000800ULL,
0x000c003d73007388ULL, 0x0003e80000000800ULL, 0x000c003f75007388ULL, 0x0003e80000000800ULL,
0x01a0000418008388ULL, 0x0003e80000000c00ULL, 0x01a2002418008388ULL, 0x0003e20000000c00ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000063ff7f8cULL, 0x0005e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000080063ff7f8cULL, 0x0007e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000100063ff7f8cULL, 0x0003e2000c80043fULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x00000000fffff984ULL, 0x000fe20000000800ULL, 0x00000000fffff984ULL, 0x000fe20000000800ULL,
0x0000000000007992ULL, 0x000fec0000008000ULL, 0x0000000162627810ULL, 0x000fe20007ffe0ffULL,
0x0000180063ff7f8cULL, 0x0003e2000c80043fULL, 0x000000ffff677224ULL, 0x000fc400078e005dULL,
0x0000000e6200720cULL, 0x000fda0003f06070ULL, 0x0000001000000944ULL, 0x002fe20003c00000ULL,
0xffff8de000007947ULL, 0x000fea000383ffffULL, 0x000000000000794dULL, 0x000fea0003800000ULL,
0x00000001ff257807ULL, 0x008fe20004000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x00017c8000267802ULL, 0x000fc40000000f00ULL, 0x0000160000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff177224ULL, 0x000fe200078e0025ULL, 0xfffead0000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe20005000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x00017ce000267802ULL, 0x000fc40000000f00ULL, 0x000015a000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff207224ULL, 0x000fe200078e0025ULL, 0xfffead3000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x00017d5000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000014e000007944ULL, 0x014fea0003c00000ULL, 0xfffeade000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x00017db000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000148000007944ULL, 0x014fea0003c00000ULL, 0xfffeaef000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x00017e1000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000142000007944ULL, 0x014fea0003c00000ULL, 0xfffeb00000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e001aULL, 0x00017e7000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000013c000007944ULL, 0x014fea0003c00000ULL, 0xfffeb10000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x00017ee000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fc400078e0017ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000135000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xfffeb4d000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x00017f5000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000012e000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0026ULL,
0x0000001017277810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x00017fc000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000127000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0026ULL, 0xfffeb44000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001803000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000120000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0026ULL,
0xfffeb40000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x008fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001809000267802ULL, 0x000fc40000000f00ULL,
0x000011f000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff707224ULL, 0x000fe200078e0025ULL,
0xfffed5d000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe20005000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x000180f000267802ULL, 0x000fc40000000f00ULL,
0x0000119000007944ULL, 0x014fea0003c00000ULL, 0x000000ffff717224ULL, 0x000fe200078e0025ULL,
0xfffed60000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x0001816000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000010d000007944ULL, 0x014fea0003c00000ULL,
0xfffed6c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x000181c000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000107000007944ULL, 0x014fea0003c00000ULL,
0xfffed7d000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x0001822000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000101000007944ULL, 0x014fea0003c00000ULL,
0xfffed8e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0073ULL,
0x0001828000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000fb000007944ULL, 0x014fea0003c00000ULL,
0xfffed9e000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x000182f000257802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fe400078e0029ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000f4000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xfffedde000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x0001836000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000ed000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0026ULL, 0x0000001029277810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x000183d000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000e6000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0026ULL,
0xfffedd5000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x0001844000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000df000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0026ULL, 0xfffedd1000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x008fe20004000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x000184a000267802ULL, 0x000fc40000000f00ULL, 0x00000de000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff727224ULL, 0x000fe200078e0025ULL, 0xfffefcc000007947ULL, 0x000fea000383ffffULL,
0x00000001ff257807ULL, 0x000fe20005000000ULL, 0xffffffffff277424ULL, 0x000fe200078e00ffULL,
0x0001850000267802ULL, 0x000fc40000000f00ULL, 0x00000d8000007944ULL, 0x014fea0003c00000ULL,
0x000000ffff737224ULL, 0x000fe200078e0025ULL, 0xfffefd0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0075ULL, 0x0001857000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000cc000007944ULL, 0x014fea0003c00000ULL, 0xfffefdc000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0075ULL, 0x000185d000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000c6000007944ULL, 0x014fea0003c00000ULL, 0xfffefed000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0075ULL, 0x0001863000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000c0000007944ULL, 0x014fea0003c00000ULL, 0xfffeffe000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0075ULL, 0x0001869000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000ba000007944ULL, 0x014fea0003c00000ULL, 0xffff00e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001870000257802ULL, 0x000fe20000000f00ULL,
0x000000ffff277224ULL, 0x000fe400078e0023ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000b3000007944ULL, 0x010fea0003c00000ULL,
0x000000ffff137224ULL, 0x004fe200078e0026ULL, 0xffff04e000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001877000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x00000ac000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff147224ULL, 0x004fe200078e0026ULL,
0x0000001023277810ULL, 0x000fe20007ffe0ffULL, 0x000000ffff267224ULL, 0x000fe200078e0016ULL,
0x000187e000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x00000a5000007944ULL, 0x000fea0003c00000ULL,
0x000000ffff157224ULL, 0x004fe200078e0026ULL, 0xffff045000007947ULL, 0x000fea000383ffffULL,
0x000000ffff267224ULL, 0x000fe200078e0016ULL, 0x0001885000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x000009e000007944ULL, 0x016fea0003c00000ULL, 0x000000ffff167224ULL, 0x004fe200078e0026ULL,
0xffff041000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x004fe20004000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x000188b000267802ULL, 0x000fc40000000f00ULL,
0x000009d000007944ULL, 0x018fea0003c00000ULL, 0x000000ffff067224ULL, 0x000fe200078e0025ULL,
0xffff24b000007947ULL, 0x000fea000383ffffULL, 0x00000001ff257807ULL, 0x000fe20005000000ULL,
0xffffffffff277424ULL, 0x000fe200078e00ffULL, 0x0001891000267802ULL, 0x000fc40000000f00ULL,
0x0000097000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff1f7224ULL, 0x000fe200078e0025ULL,
0xffff24f000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x0001898000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000008b000007944ULL, 0x010fea0003c00000ULL,
0xffff25a000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x000189e000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000085000007944ULL, 0x010fea0003c00000ULL,
0xffff26b000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x00018a4000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000007f000007944ULL, 0x010fea0003c00000ULL,
0xffff27c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0003ULL,
0x00018aa000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fc400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x0000079000007944ULL, 0x010fea0003c00000ULL,
0xffff28c000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x00018b1000257802ULL, 0x000fe20000000f00ULL, 0x000000ffff277224ULL, 0x000fe400078e0003ULL,
0x0000001fff6d7424ULL, 0x000fe400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000072000007944ULL, 0x010fea0003c00000ULL, 0x000000ffff137224ULL, 0x004fe200078e0026ULL,
0xffff2cd000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x00018b8000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000006b000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff147224ULL, 0x004fe200078e0026ULL, 0x0000001003277810ULL, 0x000fe20007ffe0ffULL,
0x000000ffff267224ULL, 0x000fe200078e0002ULL, 0x00018bf000257802ULL, 0x000fe20000000f00ULL,
0x0000001fff6d7424ULL, 0x000fc400078e00ffULL, 0xffffffffff6c7424ULL, 0x000fc400078e00ffULL,
0x0000064000007944ULL, 0x000fea0003c00000ULL, 0x000000ffff157224ULL, 0x004fe200078e0026ULL,
0xffff2c4000007947ULL, 0x000fea000383ffffULL, 0x000000ffff267224ULL, 0x000fe200078e0002ULL,
0x00018c6000257802ULL, 0x000fe20000000f00ULL, 0x0000001fff6d7424ULL, 0x000fe400078e00ffULL,
0xffffffffff6c7424ULL, 0x000fc400078e00ffULL, 0x000005d000007944ULL, 0x016fea0003c00000ULL,
0x000000ffff167224ULL, 0x004fe200078e0026ULL, 0xffff2c0000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x000fe200078e0005ULL, 0x00018ce000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff147424ULL, 0x000fe400078e00ffULL, 0x0000001fff0b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000051000007944ULL, 0x012fea0003c00000ULL,
0x000000ffff047224ULL, 0x004fe200078e000bULL, 0xffffdb1000007947ULL, 0x000fea000383ffffULL,
0x000000ffff077224ULL, 0x002fe200078e000aULL, 0x00018d6000087802ULL, 0x000fe20000000f00ULL,
0x00000002ff147424ULL, 0x000fe400078e00ffULL, 0x0000001fff0b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000049000007944ULL, 0x014fea0003c00000ULL,
0x0000000b0a00720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0016ULL,
0x00018de000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff147424ULL, 0x000fe200078e00ffULL,
0x0000000a0b067208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000041000007944ULL, 0x000fea0003c00000ULL,
0x0000000b1600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0015ULL,
0x00018e6000087802ULL, 0x000fe20000000f00ULL, 0x00000002ff147424ULL, 0x000fe200078e00ffULL,
0x000000160b167208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000039000007944ULL, 0x000fea0003c00000ULL,
0x0000000b1500720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0017ULL,
0x00018ee000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff147424ULL, 0x000fe200078e00ffULL,
0x000000150b0a7208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000031000007944ULL, 0x000fea0003c00000ULL,
0x0000000b1700720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0006ULL,
0x00018f6000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff147424ULL, 0x000fe200078e00ffULL,
0x000000170b047208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000029000007944ULL, 0x000fea0003c00000ULL,
0x0000000b0600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e0016ULL,
0x00018fe000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff147424ULL, 0x000fe200078e00ffULL,
0x000000060b057208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fc400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000021000007944ULL, 0x000fea0003c00000ULL,
0x0000000b1600720bULL, 0x004fe20003f1e000ULL, 0x000000ffff077224ULL, 0x002fe200078e000aULL,
0x0001906000087802ULL, 0x000fe20000000f00ULL, 0x00000001ff147424ULL, 0x000fe200078e00ffULL,
0x000000160b067208ULL, 0x000fe20004000000ULL, 0x0000001fff0b7424ULL, 0x000fe400078e00ffULL,
0xffffffffff5a7424ULL, 0x000fc400078e00ffULL, 0x0000019000007944ULL, 0x000fea0003c00000ULL,
0xffffd90000007947ULL, 0x000fea000383ffffULL, 0x018000001c007810ULL, 0x000fe20007ffe0ffULL,
0x0000013000017945ULL, 0x000fe60003800000ULL, 0x7f80000000027812ULL, 0x000fc800078ec0ffULL,
0x018000000200780cULL, 0x000fda0003f05070ULL, 0x0000001c00008308ULL, 0x0002a20000001000ULL,
0x000000e000008947ULL, 0x000fea0003800000ULL, 0x000000ff0200720cULL, 0x040fe40003f25070ULL,
0x008000000200780cULL, 0x000fe40003f02070ULL, 0x00000001ff037807ULL, 0x000fe40000800000ULL,
0x00000001ff007807ULL, 0x004fc80004000000ULL, 0x0000000003ff7212ULL, 0x000fda000780fcffULL,
0x0000007000008947ULL, 0x000fea0003800000ULL, 0x007fffff1cff7812ULL, 0x040fe4000780c0ffULL,
0x800000001c027812ULL, 0x000fe400078ec0ffULL, 0x00000001ff007807ULL, 0x000fc80000000000ULL,
0x0000000003ff7212ULL, 0x000fda000780c0ffULL, 0x0080000002000812ULL, 0x000fe200078efcffULL,
0x000000ffff008224ULL, 0x000fe200078e0002ULL, 0x0000001000007947ULL, 0x000fea0003800000ULL,
0x0000001c00007308ULL, 0x0004e40000001000ULL, 0x0000000000017941ULL, 0x000fea0003800000ULL,
0x000000ffff027224ULL, 0x000fe400078e0004ULL, 0x00000000ff037424ULL, 0x000fc800078e00ffULL,
0xfffe6e1002007950ULL, 0x000fea0003c3ffffULL, 0x00000000ff097424ULL, 0x000fe200078e00ffULL,
0x0000005a00007348ULL, 0x000fe80003800000ULL, 0x0c000014070b7389ULL, 0x0002a200000e000bULL,
0xfffe6dd008007950ULL, 0x000fea0003c3ffffULL, 0x0000006c00007348ULL, 0x000fe80003800000ULL,
0x0000002726267389ULL, 0x0002a400000e006dULL, 0x000000ffff6c7224ULL, 0x002fc400078e0025ULL,
0x00000000ff6d7424ULL, 0x000fc800078e00ffULL, 0xfffe6d806c007950ULL, 0x000fea0003c3ffffULL,
0x000000012500780cULL, 0x000fe20003f45070ULL, 0x0000002700007348ULL, 0x000fd80003800000ULL,
0x0000000000257806ULL, 0x000fc800050e0100ULL, 0x0000002725257212ULL, 0x000fe200078ec0ffULL,
0x00000000ff277424ULL, 0x000fc800078e00ffULL, 0xfffe6d2026007950ULL, 0x000fea0003c3ffffULL,
0xfffffff000007947ULL, 0x000fc0000383ffffULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000000000007918ULL, 0x000fc00000000000ULL, 0x0000000000007918ULL, 0x000fc00000000000ULL,
0x0000002000000008ULL, 0x0000000400000001ULL, 0x0000001000000004ULL, 0x0000000800000001ULL,
0x0000000100000001ULL, 0x0000000100000008ULL, 0x0000000400000003ULL, 0x0000000300000004ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x0000000300000001ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL,
0x000000000000011cULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x000000030000000bULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x000000000000015cULL,
0x0000000000000560ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x0000000200000013ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000006c0ULL,
0x0000000000000270ULL, 0x0000001900000002ULL, 0x0000000000000008ULL, 0x0000000000000018ULL,
0x00000001000000ddULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000930ULL,
0x0000000000000360ULL, 0x0000000000000000ULL, 0x0000000000000001ULL, 0x0000000000000000ULL,
0x7000000000000037ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000c90ULL,
0x00000000000000c0ULL, 0x0000000000000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000000000051ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000d50ULL,
0x00000000000008a0ULL, 0x0000000b00000003ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x7000000b0000010dULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x00000000000015f0ULL,
0x0000000000000010ULL, 0x0000000000000000ULL, 0x0000000000000008ULL, 0x0000000000000008ULL,
0x00000009000000eaULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000001600ULL,
0x0000000000000090ULL, 0x0000000400000003ULL, 0x0000000000000008ULL, 0x0000000000000010ULL,
0x000000010000008bULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001690ULL,
0x0000000000000004ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x00000001000000c4ULL, 0x0000000000000002ULL, 0x0000000000000000ULL, 0x0000000000001694ULL,
0x00000000000001c0ULL, 0x0000000b00000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000100000040ULL, 0x0000000000100006ULL, 0x0000000000000000ULL, 0x0000000000001880ULL,
0x0000000000019380ULL, 0xdf00001900000003ULL, 0x0000000000000080ULL, 0x0000000000000000ULL,
0x000000010000007bULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001ac00ULL,
0x0000000000000040ULL, 0x0000000000000000ULL, 0x0000000000000004ULL, 0x0000000000000000ULL,
0x0000000800000065ULL, 0x0000000000000003ULL, 0x0000000000000000ULL, 0x000000000001ac40ULL,
0x0000000000000000ULL, 0x0000000b00000000ULL, 0x0000000000000010ULL, 0x0000000000000000ULL,
0x0000000500000006ULL, 0x000000000001afc0ULL, 0x0000000000000000ULL, 0x0000000000000000ULL,
0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL, 0x0000000500000001ULL,
0x0000000000001690ULL, 0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000019570ULL,
0x0000000000019570ULL, 0x0000000000000008ULL, 0x0000000600000001ULL, 0x000000000001ac00ULL,
0x0000000000000000ULL, 0x0000000000000000ULL, 0x0000000000000040ULL, 0x0000000000000040ULL,
0x0000000000000008ULL, 0x0000000500000001ULL, 0x000000000001afc0ULL, 0x0000000000000000ULL,
0x0000000000000000ULL, 0x00000000000000e0ULL, 0x00000000000000e0ULL, 0x0000000000000008ULL
};
unsigned int xqa_kernel_dt_fp16_d_128_beam_1_kvt_int8_pagedKV_64_nqpkv_0_m_32_sm_80_cubin_len = 110752;

// clang-format on
} // namespace kernels
} // namespace tensorrt_llm
